﻿USE sofia;
DROP TABLE IF EXISTS sofia.klv_vpl;
CREATE TABLE klv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES klv_vpl WRITE;
INSERT INTO klv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Egai evi na-tos-gati-an sua hǝn nǝbathuyah siYesu Kristo, topat len nǝpasusan siTevit, topat len nǝpasusan siApraham: ");
INSERT INTO klv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","AApraham evi atǝman aIsak. AIsak evi atǝman aJakop, tovi atǝman aJutah mai aṽan aJutah gail. ");
INSERT INTO klv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","AJutah evi atǝman aPeres mai aSerah, analaru tovi aTamar. APeres evi atǝman aHesron. AHesron evi atǝman aRam. ");
INSERT INTO klv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ARam evi atǝman aAmminatap. AAmminatap evi atǝman aNahson, tovi atǝman aSalmon. ");
INSERT INTO klv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ASalmon evi atǝman aPoas, anan tovi Rahap. APoas evi atǝman aOpet, anan tovi aRut. AOpet evi atǝman aJesse. ");
INSERT INTO klv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ale aJesse evi atǝman aTevit tovi kiŋ. Ale aTevit evi atǝman aSolomon, anan tovi asoan aUriah a m̃o. ");
INSERT INTO klv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ale aSolomon evi atǝman aRehopoam. Ale aRehopoam evi atǝman aApijah. Ale aApijah evi atǝman aAsa. ");
INSERT INTO klv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ale aAsa evi atǝman aJehosafat. Ale aJehosafat evi atǝman aJoram. Ale aJoram evi atǝman aUsiah. ");
INSERT INTO klv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ale aUsiah evi atǝman aJotam. Ale aJotam evi atǝman aAhas. Ale aAhas evi atǝman aHesekiah. ");
INSERT INTO klv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ale aHesekiah evi atǝman aManasseh. AManasseh evi atǝman aAmon. Ale aAmon evi atǝman aJosiah. ");
INSERT INTO klv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ale aJosiah evi atǝman aJekoniah mai aṽan gail len nǝboŋ lotomap̃ip̃iriah vi Papilon. ");
INSERT INTO klv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Husur nǝmap̃ip̃iriahan vi Papilon: aJekoniah evi atǝman aSealtiel, ale aSealtiel evi atǝman aSeruppapel. ");
INSERT INTO klv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ale aSeruppapel evi atǝman aApiut, tovi atǝman aEliakim. Ale aEliakim evi atǝman aAsor. ");
INSERT INTO klv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","AAsor evi atǝman aSatok. Ale aSatok evi atǝman aAkim. Ale aAkim evi atǝman aEliut. ");
INSERT INTO klv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ale aEliut evi atǝman aEleasar. Ale aEleasar evi atǝman aMattan. Ale aMattan evi atǝman aJakop. ");
INSERT INTO klv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ale aJakop evi atǝman aJosef tovi asoan aMeri, topas aYesu, lotokisi hǝn aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imagenan, tub̃at len aApraham vǝbar aTevit ikad naur lotovi 14 p̃isi, ale tub̃at len aTevit vǝbar nǝmap̃ip̃iriahan vi Papilon ikad naur lotovi 14 am, ale tub̃at len nǝmap̃ip̃iriahan vi Papilon vǝbar aKristo, aGot totabtabuh lan, ikad naur lotovi 14 tǝtas. ");
INSERT INTO klv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nǝpasian siYesu Kristo evisi magegai. Anan aYesu, aMeri ikel gati ke tilah mai aJosef, be a tahw hǝn arb̃ib̃on, isab̃i ke etian, aNunun aGot togole. ");
INSERT INTO klv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Husur ke ahaṽut san, aJosef tovi nǝvanuan tonor, nǝboŋ tosǝsǝloŋ hǝn aMeri totian, emǝtahun b̃igol nahurun aMeri b̃isa, ŋa isab̃ sǝhoti len nǝnauan san ke teriŋ aMeri, be emǝtahun avan ideh b̃elǝboii. ");
INSERT INTO klv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nǝboŋ tonau natgalenan sal, aŋel sua siNasub̃ evisi hǝni len nab̃ǝb̃er. Ike, “Josef anatun ulum̃an siTevit, sagemǝtahw hǝn gǝb̃esǝhar aMeri hǝn b̃evi asoam̃, bathut natǝtai totian hǝni, aNunun aGot gatolavi maii. ");
INSERT INTO klv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alitenan dereh tipas anatun ulum̃an balai, ale geriŋ nahǝsan aYesu lan, husur gai tilav kuv nǝvanuan san gail dan nǝsaan salit balai.” ");
INSERT INTO klv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Natgalen p̃isi evisi hǝn b̃igol nǝsa aGot tokele len nabuŋon ahai kelkel ur b̃isarpoh. Ike: ");
INSERT INTO klv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mǝteris! Navensus dereh tetian, ale tipas anatun ulum̃an, ale lekis nahǝsan aImmanuel,” namilen tovi “AGot itah mai gadito.” ");
INSERT INTO klv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nǝboŋ aJosef tolele, igol nǝsa aŋel siNasub̃ tokel maii. Esǝhar aMeri tovi asoan ");
INSERT INTO klv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","be sagol naitian maii van vǝbar nǝboŋ topas anatun ulum̃an sua. AJosef eriŋ nǝhes Yesu lan. ");
INSERT INTO klv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Husur nǝboŋ lotopas aYesu len naut a Petlehem a Jutea, len nǝboŋ aHerot tovi kiŋ, alalum̃an namitisau hǝn nam̃eso luyar dan Nais vi Jerusalem ");
INSERT INTO klv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","luke, “Atenan lotopasi hǝn b̃evi kiŋ seJu gail, atenan gai be? Husur namtoris nam̃eso san nǝboŋ tovisi ale namtogǝm hǝn namtb̃ilotu hǝni.” ");
INSERT INTO klv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nǝboŋ aHerot aKiŋ tosǝsǝloŋ hǝn natenan, nǝlon etuhatuh, mai alat a Jerusalem p̃isi lumagenan. ");
INSERT INTO klv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ekis ab̃iltihai tutumav p̃isi mai ahai p̃usan p̃isi hǝn nalo lub̃onb̃on ale eus galit ke, “AKristo, aGot b̃itabtabuh lan, dereh lipasi a be?” ");
INSERT INTO klv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ale lukel maii ke, “Len naut a Petlehem a Jutea, husur ahai kelkel ur itosi maiegai ke: ");
INSERT INTO klv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Be gaiug, a Petlehem, len naut a Jutah, gǝsavi namǝkot len alat lotokad na-il-a-m̃o-an len naut a Jutah, husur len gaiug, nǝvanuan na-il-a-m̃o-an sua dereh tegǝm balai hǝn b̃eil a m̃o hǝn nǝvanuan sagw gail, alat a Israel, hum nǝvanuan nasipsip toil a m̃o hǝn galito.’” ");
INSERT INTO klv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Beti aHerot igol nab̃onb̃onan tosusuah mai alalum̃an namitisau hǝn nam̃eso. Eus galit hǝn nǝboŋ mai namityal nam̃eso tovisi ale lukele. ");
INSERT INTO klv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Esǝvat galit vi Petlehem ale ike, “Mitivan, doŋ vahvahur natǝtai. Nǝboŋ mǝtb̃isab̃i, kel uri mai ginau hǝn ginau am nǝb̃ivan valotu hǝni.” ");
INSERT INTO klv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nǝboŋ lotosǝsǝloŋ hǝn nakiŋ tonoŋ, loriŋ naut enan, ale nam̃eso lotorisi nǝboŋ tovisi, eil a m̃o hǝn galito van vail mǝhat hǝn naut natǝtai totoh lan. ");
INSERT INTO klv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nǝboŋ lotoris nam̃eso lukemkem masuṽ. ");
INSERT INTO klv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nǝboŋ lotob̃is lohoim loris alarminan, aMeri mai natǝtai, ale lotǝŋedur, lulotu hǝni, ale losǝŋav hǝn naviolan salit hǝn lǝb̃eviol mai natǝtai hǝn nagol, nafraŋkinsens mai namǝr. ");
INSERT INTO klv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nǝboŋ lotoke livan, aGot ikel nalǝlǝgauan mai galit len nab̃ǝb̃er ke saletǝlmam van hǝn aHerot, ŋa lotǝlmam vi lan nǝkantri salit len nap̃isal tile. ");
INSERT INTO klv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nǝboŋ alalum̃an namitisau hǝn nam̃eso lotovan tia, aŋel sua siNasub̃ evisi hǝn aJosef len nab̃ǝb̃er ike, “Gile mǝhat, sǝhar alarminan, gam vi Ijip, ale toh ei vir nǝb̃ikel mai gaiug hǝn gǝb̃etǝlmam, husur aHerot dereh tekǝta doŋ amas hǝn b̃igol b̃imat.” ");
INSERT INTO klv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ŋa aJosef ile mǝhat, esǝhar alarminan len mariug ale eriŋ naut enan vi Ijip. ");
INSERT INTO klv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Itoh ei van vǝbar nǝmatan siHerot. Imagenan, nǝsa Nasub̃ aGot tokele isarpoh, len nabuŋon ahai kelkel ur ike, “Nokis anatugw ulum̃an dan naut a Ijip.” ");
INSERT INTO klv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nǝboŋ aHerot tonau lǝboii ke alalum̃an namitisau hǝn nam̃eso lotogǝrasi, nǝlon ipaŋpaŋ masuṽ vǝsa. Esǝvat alalum̃an hǝn lǝb̃igol alathutai p̃isi, nǝdam̃ halit toru vi pan, lǝb̃imat len naut a Petlehem mai naut gail lotodar visi. Natenan inor hǝn namityal tosab̃i len alalum̃an namitisau hǝn nam̃eso. ");
INSERT INTO klv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Beti nǝsa aJeremiah, ahai kelkel ur tokele, isarpoh, ke: ");
INSERT INTO klv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ikad nadoldol sua len naut a Ramah, totaŋ, tois habat len nalolosaan, ARakel itaŋis anatun gail, emǝtahun avan ideh b̃etǝŋov nǝlon vi pan husur lob̃uer tia.” ");
INSERT INTO klv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nǝboŋ aHerot tomat tia, aŋel sua siNasub̃ evisi hǝn aJosef len nab̃ǝb̃er len naut a Ijip ");
INSERT INTO klv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","toke, “Gile mǝhat, sǝhar alarminan, gevi lan naut a Israel, husur alat lotodoŋ natǝtai hǝn lǝb̃igol b̃imat, lumat tia.” ");
INSERT INTO klv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ŋa ile mǝhat, sǝhar alarminan ale evi lan naut a Israel. ");
INSERT INTO klv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Avil nǝboŋ tosǝsǝloŋ hǝni ke aArkelaus tovi kiŋ, tolav namilen aHerot tovi atǝman, len naut a Jutea, emǝtahw hǝn b̃ivan ei. Nǝboŋ aGot tokel nalǝlǝgauan maii len nab̃ǝb̃er, eriŋ naut enan, evi Kalili. ");
INSERT INTO klv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ibar navile sua, a Nasaret, ale itoh ei. Beti nǝsa ahai kelkel ur gail lotokele isarpoh ke, “Lekisi hǝn auleNasaret balai.” ");
INSERT INTO klv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Len nǝboŋ galenan, aJon Baptais egǝm vi lan naut masmas tob̃ǝb̃esw a Jutea. Etub̃at kel ur napisulan siGot. ");
INSERT INTO klv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ike, “Mitipair dan nǝsaan samito husur natohan pipihabǝlan aGot len nǝmav egǝm pǝpadaŋ.” ");
INSERT INTO klv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Husur gai boh, ahai kelkel ur aIsaiah tosor husuri ke, “Nadoldol sua satokai len naut masmas tob̃ǝb̃esw, ‘Mǝteutaut hǝn nap̃isal m̃os Nasub̃, gol nap̃isal san gail linor.’” ");
INSERT INTO klv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","AJon m̃au esun nahurabat lotovaii hǝn nasivurhǝt nǝkamel, mai etutuṽ hǝn nǝhau tutuṽ hǝn nahurhub̃uluk. Ihan taṽtaṽor, ihan nalokust mai nǝhani. ");
INSERT INTO klv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Beti alat a Jerusalem mai a Jutea mai naut todar vis Nawisel Jortan, luvan van hǝni. ");
INSERT INTO klv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ale ibaptais hǝn galito len Nawisel Jortan nǝboŋ lotokel vǝhot nǝsaan salit gail. ");
INSERT INTO klv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nǝboŋ toris naFarisi mai naSattiusi gail lotosob̃ur lotogǝm hǝn lǝb̃ibaptais, ikel mai galit ke, “Anatun nǝm̃at gail! Ase ikel nalǝlǝgauan mai gamito hǝn mǝtb̃igam dan nab̃iltilol paŋpaŋ b̃egǝmai? ");
INSERT INTO klv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Len nǝmauran samito mitiṽan hǝn naṽite tinor hǝn nǝpairan samito dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Samtinau ke mǝtolǝboi mǝtb̃ikel mai gamit gabag ke, ‘Asike datupanis, aApraham evi atǝmadato ta sutuai.’ Husur nukel mai gamit ke, aGot elǝboi b̃ilav nǝvat galegai ŋai, ale gol ke legǝm vi pasusan siApraham! ");
INSERT INTO klv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","AGot esum̃an naulum̃an toutaut tia hǝn b̃itai nǝkadhuhai gail hǝn nakuvkuv; nǝhai p̃isi lǝsǝṽan hǝn naṽit tovoi, gai dereh titaii, bar hǝn gail vi lan nǝhab. ");
INSERT INTO klv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ginau nubaptais hǝn gamit hǝn nǝwai sil nǝpairan dan nǝsaan samito. Avil avan sua satogǝmai tohusur ginau, idaŋ am sǝhor ginau, ginau novi naut kǝmas ŋai, nǝsanor kasi hǝn nǝb̃isah rub̃at nǝhau hǝn naributbut san. Gai dereh tibaptais hǝn gamito hǝn aNunun aGot mai nǝhab. ");
INSERT INTO klv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gai esum̃an naulum̃an topat nǝhai rivrivhai hǝn b̃epǝpehun namisurhuwit dan nasugut nawit tomasmas. Dereh tib̃on hǝn namisurhuwit len natuhim han, be tepǝŋas nasugut nawit tosa len nǝhab todǝdas nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Beti aYesu egǝm len naut a Kalili vi lan Nawisel Jortan hǝn aJon b̃ibaptais hǝni. ");
INSERT INTO klv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Avil aJon isor tasi, ike, “Satimaienan, nǝsanor hum gaiug. Ivoi am ke gaiug m̃au gibaptais hǝn ginau, gol ke gogǝm hǝn ginau mabe?” ");
INSERT INTO klv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ris aYesu tosor vari ke, “Gidam̃ hǝn nǝb̃ibaptais gagai, husur inor hǝn darb̃igol natit p̃isi tonor, aGot tolǝŋoni.” Beti aJon idam̃ hǝn b̃ibaptais hǝni. ");
INSERT INTO klv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nǝboŋ aJon tobaptais hǝni tonoŋ, vǝha-sua ŋai aYesu evi mǝhat dan nǝwai. Nǝmav esǝŋav m̃osi ale eris aNunun aGot togǝm vi pan hum nǝtav, ale egǝm toh lan. ");
INSERT INTO klv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ale nadoldol len nǝmav ike, “Anatugw ulum̃an bogai notolǝmas buni. Nohǝhaṽur masuṽ hǝni.” ");
INSERT INTO klv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Beti aNunun aGot esǝhar aYesu vi lan naut masmas tob̃ǝb̃esw hǝn natǝmat b̃italtal ke tigol nǝsaan. ");
INSERT INTO klv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Len nǝmariboŋ tovi 40 mai nalenmariug tovi 40 aYesu sǝhan, gol ke nǝmal ihati. ");
INSERT INTO klv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Beti natǝmat egǝm hǝni, ike, “Gǝb̃evi aNatun aGot, kel mai nǝvat galegai ke legǝm vi bǝta.” ");
INSERT INTO klv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ris tosor vari ke, “Natosian siGot ike, ‘Nǝvanuan edǝdas b̃imaur len nabǝta ŋai, be imaur len nasoruan p̃isi aGot tokele.’” ");
INSERT INTO klv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Beti natǝmat esǝhari vi lan nab̃iltivile siGot, a Jerusalem, ale eriŋi eil gilgile a mǝhat buni len naim siGot. ");
INSERT INTO klv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ale ikel maii ke, “Gǝb̃evi aNatun aGot, gigol gaiug gabag giteh vi pan. Husur natosian siGot ike, “‘AGot dereh tikele hǝn aŋel san gail husur gaiug ale lipat gaiug vi mǝhat len navǝlalito hǝn asike nariem̃ b̃esǝhot nǝvat.’” ");
INSERT INTO klv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","AYesu isor vari ke, “Natosian siGot ikele am ke, ‘Sagitaltal kitev nǝdaŋan siNasub̃ aGot sam̃ ke timabe.’” ");
INSERT INTO klv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ale natǝmat esǝhar tǝtas hǝni van hǝn naṽehuh tosahsah habat, ale eṽusani hǝn nǝkantri p̃isi len navile a pan len nǝyalyalan salito. ");
INSERT INTO klv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ale ikel maii ke, “Dereh nilav natgaleg p̃is mai gaiug, gǝb̃etǝŋedur, lotu hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Beti aYesu ikel maii ke, “Setan gevi tut! Husur natosian siGot ike, ‘Gilotu hǝn Nasub̃ aGot sam̃ m̃au, ale gigol nalotuan van hǝn gai sǝb̃on.’” ");
INSERT INTO klv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Beti natǝmat eriŋi, ale aŋel gail logǝm vi tarhǝt san. ");
INSERT INTO klv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nǝboŋ tosǝsǝloŋ hǝni ke lototah gat aJon, riŋi len naim bǝbaŋis, aYesu eriŋ naut enan, evi Kalili. ");
INSERT INTO klv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Elul dan naut a Nasaret a Kalili van vatoh len naut a Kapernaum tarhǝb̃iltiwai. Kapernaum ipat len naut sinahǝmar gǝlaru, a Sepulun mai a Naftali. ");
INSERT INTO klv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Imagenan, nǝsa ahai kelkel ur, aIsaiah, tokele, isarpoh. Ike, ");
INSERT INTO klv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Naut sinahǝmar Sepulun mai naut sinahǝmar Naftali, metp̃isal vi lan nab̃iltiwai, tarhǝwisel Jortan, len naut a Kalili simetb̃os gail, ");
INSERT INTO klv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nǝvanuan gail lotobǝtah len nǝmargobut loris nab̃iltim̃ial; len galit lotobǝtah len naut hǝn nǝm̃ol hǝn nǝmatan, nam̃ial siGot evisi, em̃ias galito.” ");
INSERT INTO klv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Len nǝboŋ enan van, aYesu etub̃at kel uri ke, “Pair dan nǝsaan samito husur natohan pipihabǝlan aGot len nǝmav egǝm pǝpadaŋ!” ");
INSERT INTO klv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Len nǝboŋ sua aYesu iyar husur nǝtarhǝt nab̃iltiwai lotokisi hǝn Nab̃iltiwai Kalili. Eris alarmiṽan, aSimon, nahǝsan togon aPita, mai aAdru aṽan. Arubar hǝn nalevlev vi lan nab̃iltiwai, husur arovi vanuan nǝsahiehan. ");
INSERT INTO klv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ale ikel mai gǝlar ke, “Gǝm husur ginau, ale gamǝr mǝrtosah hǝn naieh, dereh nigol mirisah hǝn nǝvanuan gail.” ");
INSERT INTO klv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Vǝha-sua ŋai aroriŋ nalevlev sǝlaru, arohusuri. ");
INSERT INTO klv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nǝboŋ toyar van am, eris alarmiṽan am, nahǝsalar aJemes anatun aSepeti, mai aJon, aṽan. Arutoh len nab̃ot mai atǝmalaru aSepeti, lobutan nalevlev salit gail lunor. Ale aYesu ekis gǝlar gǝmai. ");
INSERT INTO klv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Vǝha-sua ŋai aroriŋ nab̃ot mai atǝmalaru, arohusuri. ");
INSERT INTO klv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ale aYesu iyar turtur len naut a Kalili p̃isi. Ep̃usan len naim nab̃onb̃onan seJu gail, ikel ur na-kel-uri-an tovoi hǝn natohan pipihabǝlan aGot, ale igol nǝvanuan gail lotokad namǝsahan tiltile gail o nibelit tomatmat, lumaur. ");
INSERT INTO klv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na-kel-uri-an husuri ibar naut a Siria kavkav. Ale nǝvanuan gail losǝhar alat lotomǝsah gǝm hǝni: alat lotokad namǝsahan tiltile, alat nibelit topǝŋas, alat lotokad natǝmat gail, alat lotokad nahumatmat mai alat nahudhubelit tomat, ale igol galit lumaur. ");
INSERT INTO klv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nab̃iltiluṽoh gail lohusuri, alat a Kalili, a Tekap̃olis, a Jerusalem, a Jutea mai alat tarhǝt Nawisel Jortan. ");
INSERT INTO klv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nǝboŋ aYesu toris naluṽoh gail, etǝṽehuh, ebǝtah. Nǝboŋ tobǝtah, ahai susur san gail logǝm hǝni, ");
INSERT INTO klv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ale etub̃at ṽusan galit ke: ");
INSERT INTO klv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Alat lotolǝboi len nǝlolito ke lotopar Got, be lotolǝŋoni, navoian siGot igol gagai lukab hǝni, husur natohan pipihabǝlan aGot len nǝmav evi salito. ");
INSERT INTO klv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Alat lototaŋ, navoian siGot igol gagai lukab hǝni, husur dereh lelǝŋon tivoi am len nǝlolito. ");
INSERT INTO klv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Alat nǝlolit tomǝdau, navoian siGot igol gagai lukab hǝni, husur aGot teviol hǝn navile a pan mai galito. ");
INSERT INTO klv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Alat lotomalkǝkat, lotomaduh hǝn nanoran, navoian siGot igol gagai lukab hǝni, husur dereh lihanukub. ");
INSERT INTO klv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Alat nǝlolit totaŋis avan ideh, lotovi tarhǝt san, navoian siGot igol gagai lukab hǝni, husur dereh aGot tilolosa hǝn galit balai. ");
INSERT INTO klv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Alat nǝlolit tomasil, lotolǝŋon aGot sǝb̃on ŋai, navoian siGot igol gagai lukab hǝni, husur dereh leris aGot balai. ");
INSERT INTO klv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Alat lotogol nanoŋan hǝn nǝb̃alan gail, lotogol natǝm̃at, navoian siGot igol gagai lukab hǝni, husur dereh aGot tekis galit hǝn anatun gail. ");
INSERT INTO klv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Alat, nǝvanuan gail lotomǝdas bun galito sil lotogol nǝsa tonor, navoian siGot igol gagai lukab hǝni, husur natohan pipihabǝlan aGot len nǝmav evi salito. ");
INSERT INTO klv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nǝboŋ nǝvanuan gail lǝb̃isor viles gamit vǝsa, lǝb̃emǝdas bun gamit gol ke mǝtb̃elǝŋon b̃isa vǝsa, lǝb̃elibliboŋ ke mǝttogol nǝsaan tiltile sil mǝttovi esagw, navoian siGot igol mǝtukab hǝni. ");
INSERT INTO klv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Len naṽide tomaienan lomǝdas tabtab hǝn ahai kelkel ur gail ta m̃o. Mitikemkem, mǝtehǝhaṽur husur aGot ikad nakonp̃urp̃uran totibau m̃os gamit len nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","AYesu isor kǝta ke, “Gamit mǝtohum nǝtas m̃os navile a pan. Be nabus hǝn nǝtas b̃imasig hǝn b̃edub̃e, tegǝm vi tas tǝtas am mabe? Savoi hǝn natideh am. Ivoi ŋai hǝn lǝb̃ibar hǝni len tan hǝn nǝvanuan gail lǝb̃ipal gati. ");
INSERT INTO klv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gamit mǝtohum nam̃ial m̃os navile a pan. Nab̃iltivile topat mǝhat len naṽehuh edǝdas b̃esusuah. Nǝvanuan p̃isi lolǝboi lǝb̃erisi. ");
INSERT INTO klv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ale avan ideh asike epigau nam̃ial, riŋi pipit nǝhad. Aoa! Eriŋi a mǝhat hǝn b̃em̃ias galit p̃isi lototoh len naim. ");
INSERT INTO klv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tomaienan, nam̃ial samit tem̃ial m̃os nǝvanuan p̃isi hǝn lǝb̃eris navoian mǝttogolgole, ale sal suh nǝyalyalan seTǝmamit len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Samtinau ke notogǝm hǝn nǝb̃ikaskas nalo o nǝsa ahai kelkel ur lotokele. Ao, nǝsagǝm hǝn nǝb̃ikaskasi, nogǝm hǝn nǝb̃igol b̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nokitin mai gamit ke, van vǝbar nǝboŋ nǝmav mai navile a pan arb̃imasig, sǝkad nǝmap̃irhǝt natosian b̃imasig dan nalo siGot, vir natit p̃isi b̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Imaienan, avan ideh b̃ilab̃ur b̃esua tokǝkereh len nalo, ale toṽusan nǝvanuan gail hǝn lǝb̃igol tǝtoṽ hǝni, dereh tevi ut kǝmas balai len galit lototoh pipihabǝlan aGot len nǝmav. Avil avan ideh togol husur nalo, toṽusan nǝvanuan hǝn lǝb̃igol gail, dereh tetibau balai len natohan pipihabǝlan aGot len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Be nukel mai gamit ke, mǝtb̃ike mǝtb̃eb̃is len natohan pipihabǝlan aGot len nǝmav, mitimasnor sǝhor ahai p̃usan hǝn nalo mai naFarisi gail. ");
INSERT INTO klv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mǝtosǝsǝloŋ tia hǝn nǝsa aGot tokele mai naur gail ta sutuai ke, ‘Sagigol avan ideh timat’ ale ‘avan ideh togole, dereh tipanis.’ ");
INSERT INTO klv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Be nukel mai gamit ke, avan ideh nǝlon topǝŋas aṽan, tipanis. Ale avan ideh tosor viles aṽan, dereh tevi lan nakotan hǝn nǝSanhitrin. Ale avan ideh toke, ‘Gumelmel, govi hoṽon!’ inor hǝn b̃evi lan nǝhab naut nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Imaienan, gǝb̃ilav naviolan sam̃ van hǝn nǝmel tutumavan ale gǝb̃inau tǝlmam hǝni ke, gotogol natesua togol aṽam̃ tokad nǝsasaan mai gaiug, ");
INSERT INTO klv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","b̃imaienan, riŋ naviolan sam̃ ei. Givan hǝn aṽam̃ hǝn mǝrb̃inor, mǝrb̃ikad navoivoian tǝtas. Beti gǝm, lav naviolan sam̃ mai aGot len natutumavan van hǝni. ");
INSERT INTO klv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Avan ideh b̃ikot hǝn gaiug, len nǝyaran sam̃ mai atenan tosor tas gaiug, len nap̃isal vi lan nakotan ŋai, gisaṽsaṽut hǝn mǝrb̃ikad natǝm̃at tǝtas. Asike gǝb̃igole, dereh teliv gargar gaiug vi lan nǝmatsistret, ale nǝmatsistret teriŋ gaiug len navǝlan nalipah, ale nalipah tibar hǝn gaiug len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nukel nakitinan mai gaiug ke, asike govivile dani vǝbar gǝb̃eṽur p̃is nǝvat hǝn nǝpain nǝmatsistret toriŋi. ");
INSERT INTO klv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mǝtosǝsǝloŋ tia hǝn nǝsa aGot tokele ke, ‘Sagigol naitian tob̃ur kotov nǝlahan,’ ");
INSERT INTO klv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ris notokel mai gamit ke, avan ideh tokǝta husur napǝhaṽut hǝn b̃elǝŋoni, len nǝlon, gai igol naitian maii tia. ");
INSERT INTO klv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Namǝtam̃ nǝmatu b̃igol gaiug gǝb̃igol nǝsaan, kis kuvi, bar hǝni. Nahudhubem̃ b̃eb̃uer enan esǝhor lǝb̃ibar hǝn nibem̃ kavkav len nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Navǝlam̃ nǝmatu b̃igol gaiug gǝb̃igol nǝsaan, ta kotovi, bar hǝni. Nahudhubem̃ b̃eb̃uer enan esǝhor nibem̃ kavkav b̃evi lan nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nalo ike, ‘Avan ideh totiṽos hǝn asoan, atenan timaslav nalob̃ulat hǝn natiṽosan mai alitenan.’ ");
INSERT INTO klv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Avil nukel mai gamit ke, avan ideh totiṽos hǝn asoan, naut kǝmas alitenan sagol naitian tosa, atenan igol ke asoan igol naitian tob̃ur kotov nǝlahan. Ale avan ideh tolah mai napǝhaṽut totiṽos, gai igol naitian tob̃ur kotov nǝlahan.” ");
INSERT INTO klv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","AYesu isor am ke, “Mǝtosǝsǝloŋ tia hǝn nǝsa aGot tokele mai naur gail ta sutuai ke, ‘Sagikel na-kel-gati-an gǝgǝras, be gigol na-kel-gati-an sam̃ van hǝn Nasub̃ aGot, tisarpoh.’ ");
INSERT INTO klv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Avil nukel mai gamit ke, samtikel nǝhes ideh hǝn b̃ita gat na-kel-gati-an samito. Samtikel nǝhes nǝmav husur aGot ebǝtah len nǝmav topat pipihabǝlan. ");
INSERT INTO klv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Samtikel nǝhes navile a pan husur ehum nakes aGot toriŋriŋ narien lan nǝboŋ tobǝtah len nǝmav. Samtikel nǝhes naut a Jerusalem husur evi nab̃iltivile seKiŋ toyalyal, tovi aGot. ");
INSERT INTO klv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sagikel nǝhes nǝkadum̃ hǝn b̃ita gat na-kel-gati-an sam̃ husur godǝdas gǝb̃igol nasivur ideh b̃epǝhw o b̃imermer. ");
INSERT INTO klv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Len nǝsa gotokele, ‘Evoi’ sam̃ timasvi ‘Evoi’ ŋai, ‘Aoa’ sam̃ timasvi ‘Aoa’ ŋai. Nasoran ideh am egǝm len atenan tosa vǝsa masuṽ tovi tǝmat. ");
INSERT INTO klv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mǝtosǝsǝloŋ tia hǝn nǝsa aGot tokele ke, ‘Gǝb̃igol namǝtan o nariṽon avan ideh b̃imasig, namǝtam̃ o nariṽom̃ timasmasig.’ ");
INSERT INTO klv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Avil nukel mai gamit ke, samtesisil hǝn avan ideh togol tosa hǝn gamito, be avan ideh b̃iṽos nǝtarhom̃ nǝmatu, pair hǝn nǝtarhǝte van hǝni. ");
INSERT INTO klv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ale avan ideh b̃ikot hǝn gaiug, b̃ilav nǝhai susun sam̃ hǝn b̃isar gel nǝkabut sam̃, gidam̃ hǝn nahurabat naut susus am maii. ");
INSERT INTO klv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nasoltia ta Rom b̃igol ke gǝb̃ipat natit san gail van vǝbar nǝmail b̃esua, gipati vǝbar nǝmail teru. ");
INSERT INTO klv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Avan ideh b̃eus gaiug hǝn natideh, lavi maii, ale gai b̃ike b̃ikabut sam̃, sagipair dani. ");
INSERT INTO klv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mǝtosǝsǝloŋ tia hǝn nǝsa aGot tokele ke, ‘Lǝmas bun alat lototoh pǝpadaŋ hǝn gaiug,’ ale ikad nasoruan am toke ‘mǝtahun bun aenemi sam̃ gail.’ ");
INSERT INTO klv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Avil nukel mai gamit ke, mǝtelǝmas bun aenemi samit gail, ale alat lotomǝdas bun gamit hǝn mǝtb̃elǝŋon b̃isa vǝsa, mitisor tuṽ m̃os galito. ");
INSERT INTO klv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mitimaienan hǝn mǝtb̃esum̃an aTǝmamit len nǝmav bathut igol nǝyal tovisi, tovi mǝhat, tosun alat lotosa mai lotovoi, ale esǝvat naus van hǝn alat lotonor mai lǝsanor. ");
INSERT INTO klv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Husur mǝtb̃elǝmas bun ŋai alat lotolǝmas bun gamito, aGot asike ilav nakonp̃urp̃uran ideh mai gamit sile. Nǝvanuan nǝtaks am lugol tomagenan. ");
INSERT INTO klv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mǝtb̃ike, ‘Ivoi,’ mai alat lotosum̃an gamit ŋai, gamit mǝtotile mabe? Alat lǝsavi Ju lotovi metb̃os gail, galit am lugol tomagenan. ");
INSERT INTO klv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imaienan, gamit m̃au mitimasnor kavkav hum aTǝmamit len nǝmav tonor kavkav.” ");
INSERT INTO klv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","AYesu isor am ke, “Mǝtelǝlǝgau! Samtigol nagolean tonor samito len nǝhon nǝvanuan gail hǝn lǝb̃isal suh gamito. Mǝtb̃imagenan, nakonp̃urp̃uran aTǝmamit len nǝmav tokade m̃os gamito, eb̃uer. ");
INSERT INTO klv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Imaienan, nǝboŋ mǝtb̃eviol mai alat lotom̃idol, samtiwal hǝni hum nǝvanuan gǝgǝras gail. Galit lugole len naim nab̃onb̃onan mai len nametp̃isal gail hǝn nǝvanuan gail lǝb̃isal suh galito. Nokitin ke asike lukad nakonp̃urp̃uran ideh am hǝn nǝsa lotogole, be nǝ-sal-suhi-an enan ŋai. ");
INSERT INTO klv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Avil nǝboŋ mǝtb̃eviol mai alat lotom̃idol, gole hǝn avan ideh asike b̃elǝboii. ");
INSERT INTO klv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","B̃imaienan, nǝsa mǝtb̃igole tesusuah. Ale aTǝmamit len nǝmav, toris nǝsa tosusuah, dereh gai tilav nakonp̃urp̃uran mai gamito. ");
INSERT INTO klv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nǝboŋ mǝtb̃isor tuṽ, samtesum̃an nǝvanuan gǝgǝras gail! Lolǝmas lǝb̃eil sor tuṽ len naim nab̃onb̃onan gail mai tarhǝp̃isal topasil gail hǝn nǝvanuan gail lǝb̃isal suh galito. Nokitin ke asike lukad nakonp̃urp̃uran ideh am hǝn nǝsa lotogole, be nǝ-sal-suhi-an enan ŋai. ");
INSERT INTO klv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Avil nǝboŋ mǝtb̃isor tuṽ, b̃is len naut tosusuah lohoim samito, ale nǝboŋ mǝtb̃ekǝkol hǝn nabopita b̃inoŋ, sor tuṽ vi tǝban aTǝmamit tosusuah. Ale aTǝmamit toris nǝsa gotogole tosusuah, dereh gai tilav nakonp̃urp̃uran mai gamito. ");
INSERT INTO klv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nǝboŋ mǝtb̃isor tuṽ, samtiwal tavtav hum nametb̃os gail lotonau ke nagot salit gail losǝsǝloŋ hǝn nasorsoran tobǝlav ŋai. ");
INSERT INTO klv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Imagenan, samtesum̃an galito, husur aTǝmamit elǝboi nǝsa mǝttom̃idol hǝni, naut kǝmas mǝtsausi hǝni sal. ");
INSERT INTO klv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Imagenan, mitisor tuṽ maiegai: “‘ATǝmanamito len nǝmav, nahǝsam̃ tiyalyal tabtab. ");
INSERT INTO klv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gegǝmai hǝn nǝvanuan p̃isi lǝb̃itoh pipihabǝlam̃, Nǝsa gotolǝŋoni m̃au tevisi, len navile a pan hum ŋai tovisi len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Viol hǝn nǝhanian husur nǝboŋ ṽisusua mai ginamito, ");
INSERT INTO klv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Rub̃at nǝsaan sinamit gail, sum̃an ŋai namttorub̃at nǝsaan silat lotogole hǝn ginamito. ");
INSERT INTO klv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sagidam̃ hǝn natideh hǝn b̃italtal ke namtigol nǝsaan, be lav kuv ginamito dan navǝlan atenan tosa vǝsa masuṽ, tovi tǝmat.’ ");
INSERT INTO klv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Husur mǝtb̃erub̃at nǝsaan gail silat lotogol tosa hǝn gamito, aTǝmamit len nǝmav dereh terub̃at nǝsaan samit gail. ");
INSERT INTO klv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wake asike mǝtb̃erub̃at nǝsaan gail silat lotogol tosa hǝn gamito, aTǝmamit asike erub̃at nǝsaan samito gail.” ");
INSERT INTO klv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","AYesu isor am, ike, “Nǝboŋ mǝtsǝhan m̃os mǝtb̃inau aGot, samtesum̃an alat lotokel natesua be gol natsua tile am, lotosar batut, gol nǝholit tomǝraŋraŋ. Lomǝdas nǝholito, hǝn nǝvanuan gail lǝb̃eris lǝboii ke lǝsǝhan. Nokitin ke asike lukad nakonp̃urp̃uran ideh am hǝn nǝsa lotogole, be na-ris-lǝboii-an sinǝvanuan ŋai. ");
INSERT INTO klv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Be gamito, nǝboŋ mǝtsǝhan, mǝtevǝhas nǝkadumit gail ale kǝkas nǝhomit gail ");
INSERT INTO klv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","hǝn nǝvanuan gail asike lǝb̃eris lǝboii ke mǝtsǝhan, avil aTǝmamit tosusuah ŋai dereh telǝboii. Ale aTǝmamit len nǝmav, toris nǝsa tosusuah, dereh gai tilav nakonp̃urp̃uran mai gamito.” ");
INSERT INTO klv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Beti aYesu ike, “Samtisah tuan nakontit gail m̃os gamit gabag len navile a pan. Husur len navile a pan egai nametǝlai itaŋ, nahurabat, nǝbarm̃om lomǝdasi, ale nǝvanuan vǝnvǝnah lovǝnoh gail. ");
INSERT INTO klv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aoa, mitigol nǝsa aGot tolǝŋoni ale dereh tetǝgau nakontit gail m̃os gamito len nǝmav, len naut enan naviolan asike itaŋ, asike nǝbarm̃om emǝdasi, asike nǝvanuan vǝnvǝnah eb̃ur naim, vi lohoim hǝn b̃evǝnohi. ");
INSERT INTO klv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Husur, naut nakontit sam̃ gail lotopat lan, dereh nǝlom̃ tu tipat tabtab lan. ");
INSERT INTO klv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Namǝtam̃ ehum nam̃ial tolav nam̃ial mai nibem̃. Imaienan, namǝtam̃ b̃imaur, dereh nibem̃ kavkav tepul hǝn nam̃ial. ");
INSERT INTO klv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Avil namǝtam̃ b̃isa, dereh nibem̃ kavkav tepul hǝn nǝmargobut. Imaienan, nam̃ial gǝb̃inau ke gotokade b̃evi margobut, dereh nǝmargobut enan tevisivis masuṽ! ");
INSERT INTO klv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Naslev ideh edǝdas b̃evi slev simasta toru len nǝboŋ tosua, husur dereh temǝtahun bun tesua ale telǝmas bun togon, o dereh tidaŋ len tesua ale tinau ke togon tovi naut kǝmas. Gǝsalǝboi gǝb̃evi slev siGot mai slev sinǝvat len nǝboŋ top̃itoṽ ŋai. ");
INSERT INTO klv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Husur tomaienan, nukel mai gamit ke, samtinau tuhatuh hǝn nǝmauran samito. Samtinau masuṽ hǝn nǝsa mǝtb̃ihani, nǝsa mǝtb̃emuni, samtinau masuṽ hǝn nibemito mai nǝsa mǝtb̃esuni. Nǝmauran esǝhor nǝhanian, ale nibemito esǝhor nahurabat mǝttosuni. ");
INSERT INTO klv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mitinau nǝman namǝsav gail. Lǝsǝmabul natideh, lǝsǝlav kukuv nǝhanian, lǝsatuani lohoim gail, be aTǝmamit len nǝmav evǝŋan galito. Avil len nǝnauan siGot gamit mǝtosǝhor masuṽ hǝn nǝman galenan. ");
INSERT INTO klv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mǝtolǝboi mǝtb̃igol nǝmauran samit tebǝlav am len nǝ-nau-masuṽ-hǝni-an samito a? Aoa, sǝmagenan! ");
INSERT INTO klv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ale husur nǝsa mǝttonau masuṽ hǝn nahurabat samito? Mitinau napusihai mai naṽide hǝn natovan han len naliol marireu. Saum, sasod nahurabat. ");
INSERT INTO klv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Be nukel mai gamit ke, napǝhasan hǝn napusihai enan esǝhor napǝhasan siSolomon tosun nahurabat bilbil tokab. ");
INSERT INTO klv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","AGot b̃igol naliol b̃epǝhas maienan, naut kǝmas totov damǝŋai ale pelan han tomasmas, topaŋ len naoven, a mǝhat hǝn natenan dereh tilav nahurabat mai gamito, gamit mǝttokad nadǝlomian tokǝkereh ŋai! ");
INSERT INTO klv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Imagenan, samtinau tuhatuh hǝn mǝtb̃ike, ‘Datihan nǝsa? Datukad nǝhanian a?’ o ‘Datemun nǝsa? Datukad nǝwai a?’ o ‘Datesun nǝsa? Datukad nahurabat ideh a?’ ");
INSERT INTO klv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Husur nametb̃os gail lǝsalǝboi aGot lugol tomaienan. Ale aTǝmamit len nǝmav elǝboi tia natit p̃isi mǝttom̃idol hǝni. ");
INSERT INTO klv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Be a mǝhat hǝn natit p̃isi am, mǝtelǝŋon nǝsa aGot tolǝŋoni len natohan pipihabǝlan, mitidoŋ kitev nanoran len nǝhon. Ale dereh tilav mai gamito natit p̃isi mǝttom̃idol hǝni. ");
INSERT INTO klv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Imagenan, samtinau tuhatuh hǝn nǝsa b̃evisi len nǝboŋ pelan, riŋi vir nǝboŋ pelan. Husur nǝmariboŋ p̃isi ikad na-lǝŋon-isa-an han, ale nǝmariboŋ p̃isi ikad naut todaŋ han sagesuhud hǝn natgalen ideh hǝn nǝboŋ pelan hǝn b̃egǝm b̃ipat len nǝboŋ damǝŋai. ");
INSERT INTO klv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Samtisab̃ sǝhoti ke nǝvanuan tile timaspanis, hǝn asike aGot b̃eriŋ gamit mǝtb̃ipanis. ");
INSERT INTO klv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Husur aGot dereh tisab̃ sǝhoti ke mitimaspanis p̃itp̃itoṽ hǝn nǝpanismen mǝttosab̃ sǝhoti ke nǝvanuan tile timaskade. AGot dereh tenǝnoṽ hǝn nǝsaan samito len naṽide top̃itoṽ hǝn mǝtb̃enǝnoṽ hǝn nǝsaan sivan tile gail. ");
INSERT INTO klv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Imabe gotokǝta kot nakumashǝhai len namǝtan aṽam̃ be gǝsǝnau nab̃iltitarhai len namǝtam̃? ");
INSERT INTO klv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Imabe gotolǝboi gǝb̃ikel mai aṽam̃ ke, ‘Eee, nidakuv nakumashǝhai dan namǝtam̃ bai,’ be gaiug, gukad nǝtarhai len namǝtam̃ sal? ");
INSERT INTO klv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gaiug gotovi vanuan gǝgǝras, geliv kuv nǝtarhai dan namǝtam̃ a m̃o, beti dereh gekǝta timasil b̃inor hǝn gǝb̃idakuv nakumashǝhai dan namǝtan aṽam̃. ");
INSERT INTO klv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Samtilav nǝsa tovi siGot mai nalipah gail. Ehum gotolav nasoruan siGot mai alat lotomǝtahuni. Samtebubulan nanesnes samit gail len nǝhon nabuai gail. Mǝtb̃imaienan, dereh lipal kisom gail, beti lipair van hǝn gamito, kat pǝpas gamito. ");
INSERT INTO klv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Usi van, dereh aGot teviol hǝni mai gamito; doŋi van, dereh mitisab̃i; deldel van, dereh nabopita tesǝŋav m̃os gamito. ");
INSERT INTO klv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Husur nǝvanuan p̃isi lotousi, dereh likade; avan ideh todoŋi, dereh tisab̃i; ale avan ideh todeldel, dereh nabopita tesǝŋav m̃osi. ");
INSERT INTO klv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ikad gamit ideh tǝlav nǝvat mot mai anatun nǝboŋ tous nabǝta hǝn b̃ihani a? ");
INSERT INTO klv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ale b̃eus naieh sua, gamit ideh tǝlav nǝm̃at maii a? Aoa! ");
INSERT INTO klv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Naut kǝmas mǝttosa, gamit mǝtolǝboi mǝtb̃ilav naviolan tovoi gail mai anatumit gail. Be aTǝmamit len nǝmav eviol habat sǝhor gamito, dereh teviol hǝn naviolan tovoi gail mai alat lotous gai. ");
INSERT INTO klv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Imaienan, natit p̃isi mǝttolǝŋoni ke nǝvanuan gail ligole m̃os gamito, gamit m̃au mitigol timagenan m̃os galito. Egai evi nap̃usanan kavkav hǝn nalo siGot, aMoses totosi mai natosian sihai kelkel ur gail. ");
INSERT INTO klv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“B̃is tur len nametlǝkau tomagugun, husur ikad nametlǝkau top̃osp̃os, nab̃iltip̃isal tomalum̃lum̃, tovi lan naut nǝmasigan ale nǝvanuan isob̃ur luyar tur lan. ");
INSERT INTO klv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Avil nametlǝkau tomagugun, natuhp̃isal tohab̃ taṽtaṽor, evi lan nǝmauran, ale evis ŋai lusab̃ lǝboii. ");
INSERT INTO klv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Lǝlǝgau! Kǝtkǝta gol gamit dan ahai kelkel ur gǝgǝras gail. Logǝm hǝn gamit hum nasipsip lǝsalǝboi lǝb̃emǝdas natideh, be lǝsǝmaienan. Len nǝlolito lohum nalipah katkat tosa lotomǝdas bun nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mǝtolǝboi mǝtb̃elǝboi galit len nǝsa lotogole tohum naṽit nǝhai. Nǝhai tosa sǝṽan hǝn naṽit tovoi; nǝhau tosa tokad nasunite sǝṽan hǝn nakrep, nǝhai tosa tokad nasunite sǝṽan hǝn nafik. ");
INSERT INTO klv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Len naṽide tomaienan, nǝhai p̃isi lotovoi luṽan hǝn naṽit tovoi avil nǝhai lotosa luṽan hǝn naṽit tosa. ");
INSERT INTO klv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nǝhai tovoi edǝdas b̃iṽan hǝn naṽit tosa, ale nǝhai tosa edǝdas b̃iṽan hǝn naṽit tovoi. ");
INSERT INTO klv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nǝhai ideh sǝṽan hǝn naṽit tovoi, nǝvanuan tokǝtkǝta tǝban nǝhol ita kokotovi, bar hǝni len nǝhab. ");
INSERT INTO klv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Imaienan, len nǝsa lotogole, len naṽit nǝmauran salito, dereh mǝtelǝboi ahai kelkel ur gǝgǝras gail. ");
INSERT INTO klv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Len alat lotokis ginau hǝn Nasub̃, savi galit p̃isi lǝb̃eb̃is len natohan pipihabǝlan aGot len nǝmav, be alat ŋai lotogol nǝsa aTǝmagw totoh len nǝmav tolǝŋoni, galit dereh leb̃is lan. ");
INSERT INTO klv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, dereh tisob̃ur like, ‘Nasub̃, Nasub̃, len nahǝsam̃ namtukel nasoruan sam̃, len nahǝsam̃ namtohut natǝmat gail, len nahǝsam̃ namtugol namerikel todaŋ gail!’ ");
INSERT INTO klv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Beti dereh nikel p̃arp̃ar hǝni mai galit ke, ‘Ginau nǝsalǝboi gamito boŋ ideh. Mǝtevi tut dan ginau, gamit mǝttogolgol nǝsaan!’” ");
INSERT INTO klv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","AYesu imaris kotov nasoran san ke, “Imagenan, avan ideh tosǝsǝloŋ hǝn nasoruan galen sagw ale togole, gai ehum naulum̃an tokad nǝkadun, toum hǝn naim san len nǝvat mot. ");
INSERT INTO klv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ale naus eus, nawisel ilev, nǝlan eṽuv, iṽas naim enan, be sateh husur eil gǝgat len nǝvat butitan. ");
INSERT INTO klv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Avil avan ideh tosǝsǝloŋ hǝn nasoran galen sagw be sagole, gai ehum naulum̃an tovi hoṽon, toum hǝn naim san len nabion. ");
INSERT INTO klv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ale naus eus, nawisel ilev, nǝlan eṽuv, iṽas naim enan, ale iteh vǝmasirsir.” ");
INSERT INTO klv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nǝboŋ aYesu tokǝmagenan tonoŋ, naluṽoh gail lup̃aŋ len nap̃usanan san, ");
INSERT INTO klv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","husur sahum ahai p̃usan gail hǝn nalo, gai ep̃usan lǝboii hum tokad na-il-a-m̃o-an hǝn namitisau. ");
INSERT INTO klv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nǝboŋ aYesu tomariŋ vi pan dan naṽehuh, nab̃iltiluṽoh gail lohusuri. ");
INSERT INTO klv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Beti naulum̃an tokad naleprosi egǝm pǝpadaŋ hǝni, iteh bathurien, ike, “Nasub̃, gǝb̃elǝŋoni, golǝboi gǝb̃igol nǝb̃imaur, nǝb̃iveveu.” ");
INSERT INTO klv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ale aYesu isar hǝn navǝlan, ibari, ike, “Nolǝŋoni. Gimaur, giveveu!” Vǝha-sua ŋai, naleprosi san emǝkaskas, gai iveveu. ");
INSERT INTO klv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Beti aYesu ikel maii ke, “Sagikele mai avan ideh, be gia ṽusan nibem̃ hǝn ahai tutumav, ale getutumav hǝn naviolan aMoses tokel todaŋ hǝni hǝn b̃eṽusan sǝhot galito ke gotomaur.” ");
INSERT INTO klv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nǝboŋ aYesu tobar naut a Kapernaum, nasenturion, nasoltia sua tovi auleRom egǝm hǝni, eŋiri ke, ");
INSERT INTO klv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Nasub̃, naslev sagw, a-vi-tarhǝte-an sagw ipat len nǝmel a im, nahudhuben imat ale elǝŋon isa vǝsa.” ");
INSERT INTO klv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","AYesu ikel maii ke, “Ale nia gol timaur beti.” ");
INSERT INTO klv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Be nasenturion ike, “Nasub̃, nǝsanor kasi hǝn gǝb̃egǝm vi lohoim sagw. Be gǝb̃ikele ŋai, naslev sagw dereh timaur. ");
INSERT INTO klv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Husur ginau am nutoh pipihabǝlan nakomada gail, ale nasoltia gail lutoh pipihabǝlagw. Nukel mai tosua ke, ‘Givan!’ ale ivan, nukel mai sual am ke, ‘Gǝmai!’ ale egǝmai, ale nukel mai naslev sagw ke, ‘Gol nategai!’ ale igole.” ");
INSERT INTO klv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nǝboŋ aYesu tosǝsǝloŋ hǝni tonoŋ ip̃aŋ ale ikel mai alat lotohusuri ke, “Nukel nakitinan mai gamit ke, len alat a Israel nǝsǝsab̃ avan ideh tokad nadǝlomian tosum̃an nab̃iltidǝlomian sitegai. ");
INSERT INTO klv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nukel mai gamit ke, isob̃ur lǝsavi Ju dereh legǝm len nais mai nawes, hǝn lǝb̃ihan len nab̃iltihanan mai aApraham mai aIsak mai aJakop len natohan pipihabǝlan aGot len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Avil anatun gail sinatohan pipihabǝlan aGot, aGot dereh tibar hǝn galit vi tut vi lan nǝmargobut. Len naut enan dereh litaŋ, lides batriṽoriṽ.” ");
INSERT INTO klv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Beti aYesu ikel mai nasenturion ke, “Givan. Bathut ke gotodǝlomi ke b̃imaienan, timaienan m̃os gaiug.” Ale len namityal enan ŋai naslev san imaur. ");
INSERT INTO klv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nǝboŋ aYesu tovi lohoim sePita, eris anan asoan aPita topat len nǝmel, topud hǝn namǝsahan. ");
INSERT INTO klv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","AYesu ibar navǝlan ale namǝsahan ivan dani. Beti alitenan ile mǝhat, etub̃at lav nǝhanian maii. ");
INSERT INTO klv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nǝboŋ nabǝŋ tois, nǝvanuan gail losǝhar nǝvanuan isob̃ur lotokad natǝmat gail van hǝni. Len nasoruan sua ŋai ehut nanunun tosa gail dan galito. Ale igol galit p̃isi lotomǝsah, lumaur. ");
INSERT INTO klv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Imagenan, nǝsa aGot tokele len nabuŋon ahai kelkel ur, aIsaiah, isarpoh toke: “Igol gidat datumaur dan nǝsa tomǝdas gidato, ilav kuv namǝsahan sidat vi tut.” ");
INSERT INTO klv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nǝboŋ aYesu toris nab̃iltiluṽoh lotoil dar visi, ikele hǝn ahai susur san gail ke liwol kotov nab̃iltiwai vi tarhǝte. ");
INSERT INTO klv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Beti ahai p̃usan hǝn nalo egǝm hǝni ike, “Hai p̃usan, dereh nehusur gaiug vi lan naut p̃isi gǝb̃evi lan!” ");
INSERT INTO klv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","AYesu isor vari ke, “Nafoks gail lukad nab̃ur patǝpat halito len tan, nǝman namǝsav gail lukad nǝhai ŋodŋod, be aNatun Nǝvanuan sǝkad naut ideh hǝn b̃ipat turuŋ lan, hǝn b̃iŋavŋav.” ");
INSERT INTO klv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ahai susur san sual am ikel maii ke, “Nasub̃, gidam̃ hǝn ginau nia tavun atǝmagw bai, beti nehusur gaiug.” ");
INSERT INTO klv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ris aYesu toke, “Gehusur ginau! Riŋ alat lotomat litavun nǝvanuan salit gail lotomat.” ");
INSERT INTO klv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nǝboŋ aYesu tosah len nab̃ot, ahai susur san gail lohusuri ale lotub̃at wol kotov nab̃iltiwai. ");
INSERT INTO klv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vǝha-sua ŋai nǝlan todaŋ igol nab̃iltiwai ekudkud masuṽ gol ke nǝwai topus pǝpadaŋ hǝn b̃ipah dǝlom nab̃ot. Avil aYesu ipatmari. ");
INSERT INTO klv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ahai susur gail luvan hǝni, lovǝŋoni, luke, “Nasub̃, Sanamtimasig! Datomun!” ");
INSERT INTO klv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ris aYesu toke, “Mǝtomǝtahw mabe? Nadǝlomian samit em̃idol, ekǝkereh masuṽ!” Beti ile mǝhat, esivoh len nǝlan mai nab̃iltiwai, ale naut etǝm̃at tǝtas. ");
INSERT INTO klv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ale ahai susur gail lumaŋmaŋ, luke, “Naulum̃an tomabe gagai? Nǝlan mai nab̃iltiwai am lugol nǝsa tokele!” ");
INSERT INTO klv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nǝboŋ aYesu tobar nǝtarhǝwai len naut a Katara, naulum̃an eru artokad natǝmat gail len gǝlaru, arogǝm len nab̃urhuvat nǝmatan gail, arobubur maii. Arugolgol nasǝnahan tosa gol ke avan ideh edǝdas b̃iyar tur len naut enan. ");
INSERT INTO klv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Arukai ke, “ANatun aGot, gaiug savi hǝn gǝb̃emǝdas ginamito. Gogǝm gegai a tahw hǝn nǝboŋ tonor hǝni hǝn namtb̃ipanis a?” ");
INSERT INTO klv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A tut hǝn galito ikad navǝshǝbuai lotosob̃ur lotohan. ");
INSERT INTO klv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ale natǝmat gail loŋiri ke, “Gǝb̃ehut ginamito, sǝvat ginamit vi lan navǝshǝbuai.” ");
INSERT INTO klv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ale ikel mai galit ke, “Vi tut!” Ŋa luvan dan gǝlaru, lob̃is len nabuai gail. Ale navǝshǝbuai p̃isi lugam sarmar mariŋ vi lan nab̃iltiwai. Lumat p̃isi ei. ");
INSERT INTO klv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Alat lotokǝtkǝta tǝban nabuai gail lugam vi lan nab̃iltivile. Ale lukel ur natit p̃isi mai nǝsa tovisi hǝn alaruenan artokad natǝmat gail. ");
INSERT INTO klv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Beti nǝvanuan p̃isi len nab̃iltivile luvan hǝn lǝb̃ib̃onb̃on mai aYesu. Ale nǝboŋ lotorisi, loŋiri ke teriŋ naut salit gail. ");
INSERT INTO klv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nǝboŋ aYesu tosah len nab̃ot, iwol kotov nǝwai tǝlmam vǝbar nab̃iltivile san. ");
INSERT INTO klv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nǝvanuan galevis lupat avan sua len nǝmel, nahudhuben tomat, gǝm hǝn aYesu. Nǝboŋ aYesu toris nadǝlomian salito, aYesu ikel mai atenan niben tomat ke, “Natugw, sagemǝtahw! Nǝsaan sam̃ gail lumarub̃at.” ");
INSERT INTO klv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ahai p̃usan galevis hǝn nalo lusor len galit gabag, luke, “Ategai inau ke gai tovi aGot! Isor mǝdas nahǝsan aGot!” ");
INSERT INTO klv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nǝboŋ aYesu tolǝboi nǝnauan salito ike, “Imabe mǝtunau isa maienan len nǝlomito? ");
INSERT INTO klv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nǝb̃ike, ‘Norub̃at nǝsaan sam̃ gail,’ o ‘Gile mǝhat, giyar,’ nǝsa emǝdmǝdau am? ");
INSERT INTO klv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Be hǝn mǝtb̃elǝboi sǝhoti ke aNatun Nǝvanuan tokad nǝdaŋan hǝn b̃erub̃at nǝsaan gail len navile a pan, nekǝmaiegai….” Ale aYesu ikel mai atenan nahudhuben tomat ke, “Gile mǝhat, pat nǝmel sam̃, givahim!” ");
INSERT INTO klv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ale ile mǝhat, ivahim. ");
INSERT INTO klv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nǝboŋ naluṽoh lotoris natenan, lomǝtahw, lusal suh nǝyalyalan siGot toriŋ nǝdaŋan maienan len navǝlan nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Len nǝyaran san dan naut enan, aYesu eris avan sua, nahǝsan aMattiu, tobǝtah len nǝpasvalǝval hǝn nǝtaks. Ale ikel maii ke, “Gitah mai ginau, gehusur ginau.” Ale ile mǝhat, ehusuri. ");
INSERT INTO klv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nǝboŋ aYesu tohan lohoim siMattiu, nǝvanuan nǝtaks mai nǝvanuan nǝsaan isob̃ur logǝm b̃on hǝn lǝb̃ihan mai aYesu mai ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nǝboŋ naFarisi gail lotoris natgalenan, lukel mai ahai susur san gail ke, “Imabe ahai p̃usan samit tohan mai nǝvanuan nǝtaks mai nǝvanuan nǝsaan gail?” ");
INSERT INTO klv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nǝboŋ aYesu tosǝsǝloŋ hǝn natenan ike, “Savi alat lotomaur lotovan hǝn nǝvanuan nareran, be alat lotomǝsah ŋai luvan hǝni. ");
INSERT INTO klv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mitia nau sǝhot namilen natosian egai siGot toke, ‘Nolǝŋon nalolosaan, nǝsalǝŋon natutumavan.’ Ginau nǝsagǝm hǝn nǝb̃ekis alat lotonor be nogǝm hǝn nǝb̃ekis nǝvanuan nǝsaan gail.” ");
INSERT INTO klv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Beti ahai susur siJon gail logǝm hǝn aYesu, lousi ke, “Ginamit mai naFarisi gail, len nǝboŋ tosob̃ur namtsǝhan hǝn namtb̃isor tuṽ, be naṽide sihai susur sam̃ gail sǝmagenan, luhan akis. Husur nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","AYesu ikel mai galit ke, “Amahean naulum̃an tolah gail lodǝdas lǝb̃itaŋ nǝboŋ naulum̃an totoh mai galit sal. Evoi, imaienan. Be dereh tikad nǝboŋ hǝn lǝb̃esǝhar naulum̃an tolah dan nǝvanuan san gail. Ale len nǝboŋ enan asike luhan. ");
INSERT INTO klv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Sǝkad avan ideh tolav nap̃isihoh sakǝkasi sal hǝn b̃imagugun, ale sode len nahurabat tomatu, husur dereh nap̃isihoh timagugun, timakuv dan nahurabat, titari sǝhor ta m̃o. ");
INSERT INTO klv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sǝkad avan ideh tob̃ir nǝwain veveu lotomadhagole len nahurhuwain tomatu tovi nahurhunani. Tagole, nahurhuwain tamǝtar, nǝwain tariv dani, ale nahurhuwain tǝsa. Nǝvanuan p̃isi lob̃ir nǝwain veveu len nahurhuwain veveu hǝn gǝlar p̃isi arb̃ipat b̃ivoi b̃ebǝlav.” ");
INSERT INTO klv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nǝboŋ aYesu tokǝmaienan sal, avan sua toil a m̃o hǝn naim nab̃onb̃onan egǝm hǝni, iteh bathurien, ike, “Anatvavigw imadhamat, avil gǝb̃egǝm riŋ navǝlam̃ lan, dereh timaur.” ");
INSERT INTO klv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ale aYesu ile mǝhat, ehusuri. Ahai susur san gail am lohusuri. ");
INSERT INTO klv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Len nǝboŋ enan, apǝhaṽut sua, nǝda han tosel len nasihau tovi 12, egǝm pǝpadaŋ, madun aYesu. Len nǝnauan san isor mai gai gabag ke, “Nǝb̃ibar ŋa nahurabat sitegai, dereh nimaur.” Ale ibar nagilen nahurabat. ");
INSERT INTO klv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","AYesu ipair, erisi, ike, “Litegai, tǝgau gat nǝlom̃! Nadǝlomian sam̃ igol gumaur.” Ale napǝhaṽut imaur len namityal enan ŋai. ");
INSERT INTO klv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nǝboŋ aYesu tob̃is lohoim sitenan toil a m̃o hǝn naim nab̃onb̃onan, toris alat lotoṽuv hǝn nab̃uvimal mai naluṽoh lotosuh taṽtaṽor, lotowal, ");
INSERT INTO klv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ike, “Mǝtevi tut! Atǝbarehreh sǝmat, ipat ŋai.” Be lotub̃at sor vilesi. ");
INSERT INTO klv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Avil nǝboŋ naluṽoh lotovivile, eb̃is, etǝgau navǝlan natǝbarehreh ale ile mǝhat! ");
INSERT INTO klv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na-kel-uri-an husur nǝsa tovisi ibar naut p̃isi todar vis naut enan. ");
INSERT INTO klv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nǝboŋ aYesu toriŋ naut enan, nametb̃esw eru arohusuri, arukai ke, “Anatun siTevit gilolosa hǝn ginamǝru!” ");
INSERT INTO klv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nǝboŋ aYesu tob̃is lohoim, ametb̃esw gǝlaru arogǝm hǝni, ale aYesu eus gǝlar ke, “Mǝrodǝlomi ke notolǝboi nǝb̃igol mǝrb̃imaur a?” Arukel maii ke, “Evoi, Nasub̃.” ");
INSERT INTO klv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Beti ibar namǝtalaru ike, “Husur nadǝlomian samǝr m̃au, mirimaur!” ");
INSERT INTO klv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ale namǝtalar esǝŋav, arokǝta. Ale aYesu ikel idaŋ mai gǝlar ke, “Samrisor husur nategai mai avan ideh!” ");
INSERT INTO klv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Be arovivile, aropiau hǝn na-kel-uri-an husuri van vǝbar naut p̃isi todar vis naut enan. ");
INSERT INTO klv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nǝboŋ artovivile tonoŋ, nǝvanuan galevis losǝhar naulum̃an sua van hǝn aYesu. Atenan evi nab̃ut husur ikad natǝmat. ");
INSERT INTO klv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nǝboŋ aYesu tohut natǝmat tonoŋ, nab̃ut etub̃at sor. Ale naluṽoh lumaŋmaŋ luke, “Nateg tovisi, evi metǝkav hǝn gidat a Israel.” ");
INSERT INTO klv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Be naFarisi gail lukelkele ke, “Ehut natǝmat gail len nǝdaŋan seb̃iltitǝmat toil a m̃o hǝn natǝmat gail.” ");
INSERT INTO klv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Beti aYesu iyar turtur len nab̃iltivile mai navile p̃isi len naut enan. Ep̃usan len naim nab̃onb̃onan salit gail, ikel ur na-kel-uri-an tovoi hǝn natohan pipihabǝlan aGot, ale igol nǝvanuan gail lotokad namǝsahan tiltile o nibelit tomatmat, lumaur. ");
INSERT INTO klv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nǝboŋ aYesu toris naluṽoh, nǝlon itaŋis galito husur nǝlolit etuhatuh, lolǝŋon isa hum nǝmauran salit savi natideh, lohum navǝshǝsipsip lǝsǝkad avan ideh tokǝtkǝta tǝban galito. ");
INSERT INTO klv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Beti ikel mai ahai susur san gail ke, “Nǝhanian totov tomatu isob̃ur, be nǝvanuan nauman lovis ŋai. ");
INSERT INTO klv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imagenan, mǝteŋir aMasta hǝn nǝmatuan ke tesǝvat nǝvanuan nauman gail vi lan nǝmarireu nǝmatuan san.” ");
INSERT INTO klv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","AYesu ekis ahai susur san gail gǝmai, ale ilav nǝdaŋan hǝn na-il-a-m̃o-an mai galito hǝn lǝb̃ehut nanunun nǝmargobut gail, ale hǝn lǝb̃igol nǝvanuan gail lotokad namǝsahan ideh o nibelit tomatmat, lumaur. ");
INSERT INTO klv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ahai pispisul lotovi 12 lukad nahǝsalit maiegai: metǝkav aSimon, lotokisi hǝn aPita, mai aṽan nahǝsan aAdru; ikad alarmiṽan, aJemes mai aJon anatun aSepeti gǝlaru; ");
INSERT INTO klv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ikad aFilip mai aPartolomiu; aTomas mai aMattiu tovi nǝvanuan nǝtaks; ikad aJemes anatun aAlfeus ale ikad aTatteus; ");
INSERT INTO klv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ikad aSimon tovi Selot sua mai aJutas Iskariot b̃eriŋ aYesu len navǝlan aenemi san gail. ");
INSERT INTO klv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","AYesu esǝvat alatenan lotovi 12, ikel idaŋ mai galit ke, “Samtevi lan naut ideh silat lǝsavi Ju, samteb̃is len navile ideh a Samaria. ");
INSERT INTO klv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Avil mitivan hǝn alat a Israel lotohum nasipsip gail lotomasig. ");
INSERT INTO klv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Len nǝvanan samito mitikel ur napisulan egai ke: ‘Natohan pipihabǝlan aGot len nǝmav egǝm pǝpadaŋ.’ ");
INSERT INTO klv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gol alat lotomǝsah limaur, gol alat lotomat lile mǝhat, gol alat lotokad naleprosi liveveu, hut natǝmat gail. AGot eviol kǝmas mai gamit tia, mǝteviol kǝmas. ");
INSERT INTO klv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Samtilav nǝvat hǝn nagol, nasilva o nakopa ideh len nǝpaus samito. ");
INSERT INTO klv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Samtitariv nǝhad sǝsǝŋon hǝn nǝyaran, samtilav nǝhai susun gǝgel, o naributbut gail o nǝhai tǝbatehw ideh. Husur inor hǝn lǝb̃evǝŋan nǝvanuan nauman toum salito. ");
INSERT INTO klv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ale nǝboŋ mǝtb̃eb̃is len nab̃iltivile o navile ideh, doŋ avan ideh b̃ehǝhaṽur hǝn gamito, ale toh maii vǝbar mǝtb̃eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nǝboŋ mǝtb̃eb̃is lohoim san, us aGot hǝn b̃eriŋ natǝm̃at lan. ");
INSERT INTO klv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Alat hǝn naim enan lǝb̃ehǝhaṽur hǝn gamito, natǝm̃at tipat len nǝlolito, avil asike lǝb̃ehǝhaṽur hǝn gamito, natǝm̃at tetǝlmam van hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ale avan ideh asike b̃ehǝhaṽur hǝn gamito, asike b̃esǝsǝloŋ hǝn nasoruan samito, nǝboŋ mǝtb̃evivile dan naim o navile enan, dardar hǝn nariemito hǝn nǝmasiav b̃imakuv dan gǝlaru. ");
INSERT INTO klv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nokitin mai gamit ke, len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, dereh nǝpanismen sinavile enan tesǝhor nǝpanismen togon b̃ibar alat a Sotom mai a Kom̃orrah. ");
INSERT INTO klv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nosǝvat gamit mǝttohum nasipsip gail rivuh len navǝshǝlipah katkat lǝb̃ike lǝb̃ikat sisil gamito. Imaienan, gamit m̃au mitikad nǝnauan hum nǝm̃at tohulahul, mititoh mǝdau hum nǝtav samǝdas avan ideh, sagol natideh tosa. ");
INSERT INTO klv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mǝtelǝlǝgau hǝn asike nǝvanuan gail lǝb̃emǝdas gamito, husur dereh leriŋ gamit len nakotan gail, dereh lebilas habat hǝn gamito len naim nab̃onb̃onan salito. ");
INSERT INTO klv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dereh lesǝhar gamit vi lan nakotan len nǝhon nǝgavna mai nakiŋ gail m̃os ginau hǝn mǝtb̃ikel sǝhot ginau mai galito mai alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nǝboŋ lǝb̃esǝhar gamit vi lan nakotan galenan, samtinau masuṽ hǝn nǝsa mǝtb̃ikele o naṽide hǝn nasoran samito. Husur len namityal enan ŋai aTǝmamit len nǝmav dereh teriŋ nasoruan len gamito hǝn mǝtb̃ikele. ");
INSERT INTO klv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Husur savi gamit mǝtb̃isor be aNunun aGot aTǝmamito len nǝmav dereh tisor len nabuŋomito. ");
INSERT INTO klv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nǝvanuan dereh teriŋ aṽan len navǝlan alat lotoil a m̃o hǝn b̃imat, atata dereh timagen hǝn anatun hǝn b̃imat, ale alahutai dereh lile mǝhat, pair dan analito mai atǝmalito hǝn nakotan b̃eriŋ alatmisoan gail lǝb̃imat. ");
INSERT INTO klv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nǝvanuan p̃isi dereh lemǝtahun bun gamito bathut nahǝsagw mǝttokade. Avil avan ideh b̃idaŋ len ginau, b̃ikad nǝ-daŋ-b̃uri-an van vǝbar nagilen, dereh aGot tilav kuvi hǝn b̃ikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nǝboŋ lǝb̃emǝdas tabtab hǝn gamito len navile ideh, gam dani vi lan navile ideh am. Husur nokitin mai gamit ke asike mǝtuyar tur navile p̃isi a Israel a tahw nagǝmaian siNatun Nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ahai susur satibau sǝhor ahai p̃usan san, naslev satibau sǝhor nǝmasta san. ");
INSERT INTO klv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Inor ŋai hǝn ahai susur b̃esum̃an ahai p̃usan san mai naslev b̃esum̃an nǝmasta san. Ginau nosum̃an amasta hǝn naim, gamit mǝtosum̃an alat lototoh lohoim sagw. Nǝvanuan gail lǝb̃ekis amasta hǝn naim hǝn aPeelsepul o aSetan, dereh lekis alat lototoh maii hǝn nǝhes tosa gail am. ");
INSERT INTO klv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Imagenan samtemǝtahw len galito. Natideh aGot toruŋ gole dereh tevuhe, natideh tosusuah nǝvanuan gail dereh lelǝboii. ");
INSERT INTO klv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nǝsa notokele mai gamit len nǝmargobut, gamit m̃au mitikel uri len nam̃ial. Nǝsa notokele mai gamit sǝb̃omito, mitikel ur habat hǝni mai nǝvanuan p̃isi. ");
INSERT INTO klv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Samtemǝtahw len alat lotolǝboi lǝb̃igol nǝmatan len nibemito, be lotodǝdas lǝb̃igol nǝlomito o nanunumito lǝb̃imat. Ao, mǝtemǝtahw len aGot tolǝboi b̃igol nibemito b̃imat ale b̃igol nǝlomito mai nanunumito b̃imasig len nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mǝtolǝboi mǝtb̃eṽur nǝsparo eru hǝn nǝvat tokǝkereh toru a? Avil gǝlar sua b̃iteh len tan vǝmat, aTǝmamit len nǝmav elǝboii, idam̃ hǝni. ");
INSERT INTO klv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Avil gamito, aGot ep̃uruŋ p̃is nasivur hǝn navurumit len nǝkadumito. ");
INSERT INTO klv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Imagenan, samtemǝtahw. Len nǝnauan siGot mǝtosǝhor masuṽ hǝn nǝsparo tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Imaienan, avan ideh b̃ikel uri ke tovi esagw len nǝhon nǝvanuan gail, dereh ginau m̃au nikel uri ke tovi esagw len nǝhon aTǝmagw len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Avil alat lotosor mǝtahun ginau len nǝhon nǝvanuan gail, dereh ginau m̃au nisor mǝtahun galito len nǝhon aTǝmagw len nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","AYesu isor am ke, “Samtinau ke notogǝm hǝn nǝb̃ilav natǝm̃at gǝm vi lan navile a pan. Ao, nǝsagǝm hǝn nǝb̃ilav natǝm̃at, be hǝn nǝb̃ilav nǝb̃alb̃alan. ");
INSERT INTO klv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Nogǝm hǝn nǝb̃epǝpehun naulum̃an dan atǝman, natǝbarehreh dan anan, avilah dan avuŋon pǝhaṽut. ");
INSERT INTO klv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ale aenemi sinǝvanuan, dereh levi nǝbathudud san.’ ");
INSERT INTO klv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Avan ideh tolǝmas bun anan o atǝman sǝhor tolǝmas bun ginau, gai sanor hǝn b̃evi ahai susur sagw; ale avan ideh tolǝmas bun anatun ulum̃an o anatvavin sǝhor tolǝmas bun ginau, gai sanor hǝn b̃evi ahai susur sagw. ");
INSERT INTO klv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Avan ideh asike b̃ipat nǝhai balbal san ale husur ginau, gai sanor kasi hǝn b̃evi ahai susur sagw. ");
INSERT INTO klv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Avan ideh toke b̃etǝgau gat nǝmauran san, dereh timasig dani. Ale avan ideh todam̃ hǝn nǝmauran san b̃imasig m̃os ginau, dereh tikade vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Avan ideh tohǝhaṽur hǝn gamit mǝtb̃itoh maii, ehǝhaṽur hǝn ginau; ale avan ideh tohǝhaṽur hǝn ginau nǝb̃itoh maii; ehǝhaṽur hǝn atenan tosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Avan ideh tohǝhaṽur hǝn ahai kelkel ur sua b̃itoh maii bathut ikel ur napisulan siGot, dereh tikad nakonp̃urp̃uran sihai kelkel ur. Ale avan ideh tohǝhaṽur hǝn nǝvanuan nanoran b̃itoh maii bathut tovi vanuan nanoran, dereh tikad nakonp̃urp̃uran sinǝvanuan nanoran. ");
INSERT INTO klv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ale avan ideh b̃ilav nab̃iliwai hǝn nǝwai susus mai ideh len alategai lotovi ut kǝmas bathut tovi ahai susur sagw, dereh aGot m̃au tilav nakonp̃urp̃uran mai avan enan.” ");
INSERT INTO klv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nǝboŋ aYesu tokǝmaienan mai ahai susur san tovi 12 tonoŋ, ivan dan naut enan hǝn b̃ep̃usan mai hǝn b̃ikel ur na-kel-uri-an tovoi len navile gail a Kalili. ");
INSERT INTO klv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","AJon Baptais itoh len naim bǝbaŋis, ale nǝboŋ tosǝsǝloŋ hǝn nǝsa aKristo togolgole, aJon esǝvat ahai susur san galevis hǝn lǝb̃eus aYesu ke, ");
INSERT INTO klv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Gaiug govi atenan togǝmgǝmai o namtimasvatvat vir togon?” ");
INSERT INTO klv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ale aYesu isor var galit ke, “Tǝlmam van hǝn aJon. Kel maii nǝsa mǝttosǝsǝloŋ hǝni, nǝsa mǝttoris notogole. ");
INSERT INTO klv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ametb̃esw gail lukad nakǝtaan, alat lotogau luyar, alat lotokad naleprosi lumaur, luveveu, nǝdariŋ b̃ulb̃ulol gail losǝsǝloŋ, alat lotomat lule mǝhat dan nǝmatan ale namǝsal gail losǝsǝloŋ hǝn na-kel-uri-an tovoi notokele. ");
INSERT INTO klv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","AGot tigol tivoi hǝn avan ideh sateh dan nadǝlomian len ginau sil nǝsa notogole.” ");
INSERT INTO klv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nǝboŋ galit lotovan, aYesu etub̃at sor husur aJon mai naluṽoh ke, “Gamit mǝtovi lan naut masmas tob̃ǝb̃esw hǝn mǝtb̃eris nǝsa? Mǝtuvan varis naulum̃an tohum nalut naṽiliol nǝlan toṽuvi, tokur hǝni a? ");
INSERT INTO klv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Avil mǝtuvan hǝn mǝtb̃eris nǝsa? Naulum̃an tosun nahurabat nǝvat halit totibau a? Aoa! Alat lotosun nahurabat tomaienan lutoh len nab̃iltiim sekiŋ gail. ");
INSERT INTO klv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","B̃imaienan, mǝtuvan hǝn mǝtb̃eris nǝsa? Ahai kelkel ur sual a? Evoi! Nukel mai gamit ke, savi ahai kelkel ur ŋai, iyalyal sǝhor ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Natosian siGot isor husur ategaii ke, ‘Geris! Dereh nesǝvat ahai pispisul sagw a m̃o hǝn gaiug hǝn b̃eutaut hǝn nap̃isal m̃os gaiug.’ ");
INSERT INTO klv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nokitin mai gamit ke, sǝkad avan ideh napǝhaṽut topasi, tosǝhor aJon Baptais. Be len alat lototoh pipihabǝlan aGot len nǝmav, galit ideh tovi ut kǝmas, iyalyal sǝhor aJon. ");
INSERT INTO klv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Len nǝboŋ ta m̃o siJon Baptais van vǝbar damǝŋai, nǝvanuan gail lutaltal hǝn lǝb̃eb̃is len natohan pipihabǝlan aGot len nǝmav, nǝvanuan nǝb̃alan luke litah gati. ");
INSERT INTO klv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Husur nalo siMoses mai ahai kelkel ur p̃isi lopǝhav utaut van vǝbar nǝboŋ aJon togǝmai. ");
INSERT INTO klv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ale mǝtb̃ike mǝtb̃edǝlomi, gai evi Elijah, ahai kelkel ur gail lotoke b̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Avan ideh tokad nǝdariŋan hǝn b̃esǝsǝloŋ, tesǝsǝloŋ m̃au!” ");
INSERT INTO klv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Beti aYesu eus gai gabag ke, “Be nolǝboi nǝb̃enǝnoṽ hǝn nǝvanuan gail ta damǝŋai mai nǝsa? Lohum alahutai lotobǝtah len nǝmaket lotokai van hǝn galit gabag ke, ");
INSERT INTO klv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Namtoṽuv nab̃uvimal m̃os gamito be mǝtsǝsav; namtokǝkai hǝn nǝb̃e nǝmatan be mǝtsǝtaŋ.’ ");
INSERT INTO klv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nokǝmaienan husur nǝboŋ aJon togǝmai, gai sǝhan, gai samun, be luke, ‘Gai ikad natǝmat!’ ");
INSERT INTO klv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nǝboŋ aNatun Nǝvanuan togǝmai, tohan, tomun, luke, ‘Mǝteris! Naulum̃an tohan tǝmǝhav, tomun vatǝrog bolai. Itah mai nǝvanuan nǝtaks mai nǝvanuan nǝsaan gail.’ Avil nǝvanuan gail lolǝboi lǝb̃ekǝta lǝboii ke, namitisau hǝn nǝmauran tonor, ekitin len nǝsa togole.” ");
INSERT INTO klv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Beti aYesu etub̃at sor van hǝn nab̃iltivile gail, esivoh len gail, gai togol namerikel tosob̃ur len galito, husur galit lǝsǝpair dan nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ike, “Dereh tisa vǝsa hǝn gaiug, naut a Korasin, ale gaiug am, naut a Petsaita, tisa vǝsa hǝn gaiug! Husur nǝtagol namerikel gail len naut a Tair mai a Siton hun notogole len gamǝru, gǝlaru artǝpair dan nǝsaan sǝlaru len nahurabat toharharo mai nǝmasiav. ");
INSERT INTO klv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Be nukel mai gamǝru ke, len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, nǝpanismen hǝn naut a Tair mai a Siton asike idaŋ hum b̃ibar gamǝru. ");
INSERT INTO klv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ale gaiug naut a Kapernaum, gunau ke aGot tipatpat gaiug mǝhat vǝbar nǝmav a? Ao! AGot dereh tilav gaiug vi pan vi lan naut nǝmatan. Husur nǝtagol namerikel len naut a Sotom hun notogole len gaiug tia, naut enan tǝpat sal vǝbar nǝboŋ ta damǝŋai. ");
INSERT INTO klv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Be nukel mai gaiug ke, len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, nǝpanismen hǝn naut a Sotom asike idaŋ hum b̃ibar gaiug.” ");
INSERT INTO klv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Len nǝboŋ enan aYesu isor tuṽ, ike, “Nusal suh gaiug aTata gotovi Masta hǝn nǝmav mai navile a pan. Nusal suh gaiug husur gosusuan natgalenan dan alat lotokad nǝkadulito mai alat lotokad namitisau hǝn navile a pan, ale gukel vǝhot gail mai alat lotovi ut kǝmas hum atuhlahutai. ");
INSERT INTO klv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Evoi, aTata, husur gohǝhaṽur hǝn tomaienan. ");
INSERT INTO klv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Natit p̃isi, aTǝmagw ilav gail mai ginau tia. Sǝkad avan ideh tolǝboi aNatun aGot, be aTata ŋai elǝboii. Ale sǝkad avan ideh tolǝboi aTata, be aNatun ŋai elǝboii. Ale gai ilekis hǝn nǝvanuan galevis hǝn b̃evǝhot p̃arp̃ar hǝn aTata mai galito hǝn lǝb̃elǝboii.” ");
INSERT INTO klv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nǝboŋ aYesu tokǝmaienan tonoŋ ike, “Gegǝm hǝn ginau, gaiug nibem̃ tomǝhav, nǝlom̃ tosa hǝn natit tomǝlas gotovusi, ale dereh neviol hǝn nǝŋavŋavan mai gaiug. ");
INSERT INTO klv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nayok sagw, lav nǝhai enan togol dartob̃on hǝn nǝb̃esusupah mai gaiug. Ale gegǝm vi hai susur sagw. Husur naut kǝmas nǝb̃evi amasta sam̃, nǝsǝdaŋ taltal, nǝlogw mǝdau, nǝsǝnau ginau, ale dereh nǝŋavŋavan tegǝm len gaiug, len nǝlom̃ am. ");
INSERT INTO klv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Husur nayok sagw sǝdaŋ hǝn gǝb̃ikade, sǝdaŋ hǝn gaiug gǝb̃elǝboi nǝsa notokele, ale nǝsa notoriŋi len gaiug, emǝlala, sǝdaŋ hǝn gǝb̃igole.” ");
INSERT INTO klv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Len nǝboŋ enan aYesu iyar tur len nǝmarireu nawit galevis len nǝSappat. Ahai susur san gail lumalkǝkat ale lotub̃at b̃ub̃ur nǝhavhǝt nawit gail hǝn lǝb̃ihani. ");
INSERT INTO klv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nǝboŋ naFarisi galevis lotoris natenan, lukel mai aYesu ke, “Geris, ahai susur sam̃ gail lugol nǝsa nalo tokai tasi len nǝSappat.” ");
INSERT INTO klv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ris aYesu tokel mai galit ke, “Be len natosian siGot, mǝtsaṽuruŋ lǝboi nǝsa aTevit galito lotogole nǝboŋ lotomalkǝkat a? ");
INSERT INTO klv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Eb̃is len naim siGot ale luhan nabǝta tolo, tokolkol hǝn galito be tonor hǝn ahai tutumav sǝb̃olit ŋai lǝb̃ihani. ");
INSERT INTO klv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ale mǝtsaṽuruŋi len nalo siMoses toke len nǝSappat ahai tutumav gail lotoum len naim siGot, lǝsagol kas natideh tosa, naut kǝmas lob̃ur kotov nalo hǝn nǝSappat a? ");
INSERT INTO klv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","7","Avil mǝttalǝboi namilen nategai len natosian siGot toke, ‘Nolǝŋon nalolosaan, savi natutumavan,’ asike mǝttǝsab̃ sǝhoti ke alategai lotonor limaspanis. Nukel mai gamit ke, ikad natesua gegai toyalyal sǝhor masuṽ hǝn naim siGot. ");
INSERT INTO klv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Alategai lunor bathut aNatun Nǝvanuan evi Masta hǝn nǝSappat.” ");
INSERT INTO klv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Beti aYesu eriŋ naut enan, evi lan naim nab̃onb̃onan sua salito. ");
INSERT INTO klv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ikad naulum̃an sual ei, navǝlan tomat, togǝm hum towas. Ale naFarisi gail luke lisab̃ sǝhot nǝsaban ideh len aYesu ale lousi ke, “Inor len nalo hǝn nǝvanuan b̃igol avan ideh b̃imaur len nǝSappat a?” ");
INSERT INTO klv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ale isor var galit ke, “Gamit ideh gotokad nasipsip tosua tateh len nab̃ur len nǝSappat, gǝtatǝgau gati, lav kuvi a? Evoi mǝttǝlav kuvi! ");
INSERT INTO klv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ale nasipsip savi natideh, nǝvanuan esǝhor masuṽ hǝni len nǝnauan siGot. Imaienan, inor len nalo hǝn datb̃igol navoian len nǝSappat.” ");
INSERT INTO klv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Beti ikel mai aulum̃an ke, “Gisar hǝn navǝlam̃.” Nǝboŋ tosar hǝni tonoŋ, navǝlan imaur tǝlmam inor ŋai hǝn togon. ");
INSERT INTO klv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ŋa naFarisi gail luvan, lub̃onb̃on, lusor utaut hǝn nap̃isal hǝn lǝb̃emǝdas bun aYesu hǝn b̃imat. ");
INSERT INTO klv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Be bathut ke aYesu tolǝboi natgalenan, eriŋ naut enan. Nab̃iltiluṽoh lohusuri ale igol alat lotomǝsah p̃isi lumaur. ");
INSERT INTO klv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ale ikele hǝn galit ke salihol husur gai len nǝhon nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ekǝmaienan hǝn nǝsa ahai kelkel ur, aIsaiah, tokele b̃isarpoh ke: ");
INSERT INTO klv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Naulum̃an nauman sagw bogai notolekis hǝni. Nolǝmas bun gai, nǝlogw ehǝhaṽur hǝni. Dereh neriŋ aNunugw lan, ale dereh tikel ur nanoran sagw van hǝn nǝvanuan naut tiltile gail. ");
INSERT INTO klv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Asike eṽitṽituh, asike ikai habat, asike ikad avan ideh b̃esǝsǝloŋ hǝn nadolon len nap̃isal gail. ");
INSERT INTO klv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Asike ikol b̃ur naviyab tomab̃it tia, asike ekin bun nǝhau nam̃ial topaŋ kǝkereh sal, van vǝbar b̃igol nanoran b̃ipat puŋpuŋ naut p̃isi. ");
INSERT INTO klv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ale nǝvanuan naut tiltile gail p̃isi dereh leriŋ nǝlolit lan, dereh livatvat viri hǝn b̃ilav kuv galit dan nǝsaan salito.” ");
INSERT INTO klv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Beti nǝvanuan galevis losǝhar naulum̃an tokad natǝmat togol tob̃ut mai namǝtan tob̃esw. Losǝhari van hǝn aYesu, ale igol imaur hǝn ke elǝboi b̃isor, elǝboi b̃ekǝta. ");
INSERT INTO klv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naluṽoh p̃isi lumaŋmaŋ tǝban ale luke, “Ategai bogai, anatun siTevit m̃au a?” ");
INSERT INTO klv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Be nǝboŋ naFarisi gail lotosǝsǝloŋ hǝn natenan, luke, “Ategai ehut natǝmat gail len nǝdaŋan siPeelsepul ŋai toil a m̃o hǝn natǝmat gail.” ");
INSERT INTO klv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Avil aYesu elǝboi nǝnauan salito ale ikel mai galit ke, “Nǝvanuan gail hǝn nǝkantri pipihabǝlan nakiŋ ideh lotob̃alkabaŋ, dereh naut enan timasirsir, teb̃ǝb̃esw. Navile o nǝbathudud ideh tob̃alkabaŋ, asike eil gǝgat be dereh tepǝpehw. ");
INSERT INTO klv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ASetan tahut natǝmat san gail, gai tǝb̃alkabaŋ. Dereh alat lototoh pipihabǝlan lepǝpehw, asike loil gǝgat. ");
INSERT INTO klv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ale nǝtahut natǝmat gail len nǝdaŋan siPeelsepul, ahai susur samit gail lohut natǝmat gail len nǝdaŋan sise? Ahai susur samit gail gabag loṽusani ke mǝtsanor. ");
INSERT INTO klv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Be nǝb̃ehut natǝmat gail len nǝdaŋan seNunun aGot, imagenan natohan pipihabǝlan aGot ibar gamit tia. ");
INSERT INTO klv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Avan ideh toke teb̃is len naim sinabǝhariv todaŋ hǝn b̃evǝnoh natit san gail, imasbaŋis gat abǝhariv. Nǝboŋ tobaŋisi tonoŋ ŋai, elǝboi b̃itariv kuv natit p̃isi dan naim san. ");
INSERT INTO klv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Avan ideh satoh len nǝtarhǝt sagw, avan en evi enemi sagw; ale avan ideh sasǝsǝgov mai ginau len nǝmatuan, gai igol imap̃ip̃iriah; asike b̃esǝhar nǝvanuan gail van hǝn aGot, esǝhar nǝvanuan gail van vǝsab. ");
INSERT INTO klv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Imagenan, nukel mai gamito ke, aGot dereh terub̃at nǝsaan p̃isi naut kǝmas nǝvanuan gail lǝb̃isor mǝdasi, be lǝb̃isor mǝdas aNunun aGot, aGot asike erub̃at nǝsaan enan. ");
INSERT INTO klv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Avan ideh b̃isor tas aNatun Nǝvanuan, aGot dereh terub̃at nǝsaan enan, be avan ideh b̃isor tas aNunun aGot, aGot asike erub̃at nǝsaan enan dani boŋ ideh vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ale aYesu ike, “Gǝb̃ikad nǝhai tovoi, naṽit dereh tivoi. Gǝb̃ikad nǝhai b̃isa, naṽit dereh tisa. Bathut goris lǝboi nǝhai nǝboŋ gotoris naṽite. ");
INSERT INTO klv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gamit anatun nǝm̃at gail! Anatun nǝvaipa gail! Mǝtolǝboi mǝtb̃ikel natit tovoi nǝboŋ mǝttosa? Aoa! Nǝsa topul sǝsǝhov len nǝlon nǝvanuan evivile len nǝsa tokele. ");
INSERT INTO klv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nǝvanuan tovoi, navoian egǝm len natit tovoi topul len nǝlon; avil nǝvanuan tosa, nǝsaan egǝm len natit tosa topul len nǝlon. ");
INSERT INTO klv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Be nukel mai gamit ke, len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, nǝvanuan gail limaskele sil nǝsa lotokel nasoruan p̃isi lotosor lab hǝni. ");
INSERT INTO klv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bathut len nasoruan sam̃ aGot dereh tisab̃ sǝhoti ke gotonor, ale len nasoruan sam̃ aGot dereh tisab̃ sǝhoti ke gotosa, gimaspanis.” ");
INSERT INTO klv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Beti ahai p̃usan hǝn nalo mai naFarisi galevis lous aYesu ke, “Hai p̃usan, namtuke namteris namerikel gǝb̃igole.” ");
INSERT INTO klv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","AYesu isor var galit ke, “Gamit naur ta damǝŋai mǝtusa, mǝtsǝdaŋ len aGot sum̃an apǝhaṽut tohusur aulum̃an tiltile, sǝdaŋ len asoan. Mǝtous namerikel, avil asike nugol namerikel ideh, be dereh nigol ŋai namerikel hǝn nasuhunian sihai kelkel ur, aJonah. ");
INSERT INTO klv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sum̃an aJonah totoh len nǝmariboŋ totor mai nalenmariug totor len nabǝhaṽun nab̃iltiieh, len naṽide tomagenan, aNatun Nǝvanuan dereh tipat b̃urhulon nǝtan husur nǝmariboŋ titor mai nalenmariug titor. ");
INSERT INTO klv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Husur natgalenan, len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, alat a Nineveh dereh leil, kel kot nǝsaan sinaur ta damǝŋai, like naur egai limaspanis. Alat a Nineveh dereh ligol naten husur ke, nǝboŋ aJonah tokel ur napisulan siGot, galit lupair dan nǝsaan salito, be gagai ikad natesua gegai toyalyal habat sǝhor aJonah! ");
INSERT INTO klv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, naKwin hǝn naSaut dereh tile mǝhat, kel kot nǝsaan sinaur ta damǝŋai, tike naur egai limaspanis. Dereh tigol timagenan husur egǝm len nǝtarhǝt navile a pan hǝn b̃esǝsǝloŋ hǝn namitisau siSolomon hǝn nǝmauran tonor, be gagai, ikad natesua gegai toyalyal sǝhor aSolomon!” ");
INSERT INTO klv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","AYesu isor tǝtas am ke, “Datusor husur nahutian hǝn natǝmat gail. Ale, nǝboŋ nanunun nǝmargobut tovan dan nǝvanuan ideh, nanunun nǝmargobut enan iyar turtur naut masmas gail hǝn b̃isab̃ naut ideh hǝn b̃iŋavŋav lan, be idoŋ sob̃uer hǝni. ");
INSERT INTO klv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Beti natǝmat ikel mai gai gabag, ike, ‘Netǝlmam bai vi lan naim sagw notogam dani.’ Ale nǝboŋ tobar nǝvanuan gai tovan dani, nǝvanuan enan ehum naim tob̃ǝb̃esw, lotosir vahvahuri, tuan tǝlmam hǝn natit p̃isi tonor. ");
INSERT INTO klv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Beti ivan vasǝhar nanunun tomǝlevru lotosa masuṽ sǝhor gai, ale nǝboŋ lotob̃is len nǝvanuan, lutoh tin ei. Ale nǝmauran sinǝvanuan enan egǝm isa vǝsa tibatbat sǝhor ta m̃o. Dereh timagenan hǝn naur tosa ta damǝŋai.” ");
INSERT INTO klv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nǝboŋ aYesu tosor mai naluṽoh sal, aṽan matmat gail mai anan lubar naut enan. Loil vivile, luke lisor maii. ");
INSERT INTO klv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Avan sua ikel maii ke, “Geris, anam̃ mai aṽam̃ gail loil vivile, luke lisor mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ale isor var atenan ke, “Anagw ase? Aṽagw gail ase?” ");
INSERT INTO klv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ale esuhun navǝlan van hǝn ahai susur san gail, ike, “Geris! Anana sagw mai aṽagw gail bogai! ");
INSERT INTO klv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bathut avan ideh togol nǝsa aTǝmagw len nǝmav tolǝŋoni, gai evi aṽagw, o aṽavinegw o anana sagw.” ");
INSERT INTO klv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Len nǝboŋ enan, aYesu evivile len naim, ebǝtah tarhǝwai Kalili. ");
INSERT INTO klv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ale nab̃iltiluṽoh logǝm, b̃onb̃on garu lan, gol ke isah len nab̃ot hǝn b̃ebǝtah, ale naluṽoh loil husur nabitas. ");
INSERT INTO klv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Beti ikel natit tosob̃ur mai galito len nǝb̃ol p̃usan gail. Ike, “Ikad nǝvanuan tomabmabul namisurhut gail. Boŋ sua ia bubulan namisurhut nawit. ");
INSERT INTO klv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nǝboŋ tobubulan gail van, namisurhuwit galevis lorus husur nap̃isal, ale nǝman namǝsav logǝm, luhan p̃is gail. ");
INSERT INTO klv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Galevis lorus len naut tobaŋ vat, nǝtan tokǝkereh lan, ale lutov tutut bathut nǝtan sǝsareh. ");
INSERT INTO klv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nǝboŋ namityal tovi mǝhat, nǝyal etun idaŋ gol nalut gail lomial husur sǝkad nǝharhǝt tovi pan, ale lumayoh. ");
INSERT INTO klv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Galevis lorus len nǝhau tokad nasunite, ale nǝhau itov vi mǝhat, ruŋ gut bun nawit. ");
INSERT INTO klv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Galevis lorus len nǝtan tokǝnoh ale nǝboŋ lotomatu, sua iṽan vǝkad 100, sua iṽan vǝkad 60, sual am iṽan vǝkad 30. ");
INSERT INTO klv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nǝvanuan tokad nǝdariŋan, tesǝsǝloŋ!” ");
INSERT INTO klv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Beti ahai susur san gail logǝm hǝn aYesu, lousi ke, “Nǝboŋ gotosor mai galito, gub̃ol p̃usan m̃os nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ale isor var galit ke, “Nugole husur aGot idam̃ hǝni ke mǝtb̃elǝboi nǝsa tosusuah len natohan pipihabǝlan aGot len nǝmav be aGot sǝdam̃ hǝni ke galit lǝb̃elǝboii. ");
INSERT INTO klv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bathut avan ideh nǝlon tomab̃ur hǝn nǝsa notokele, dereh aGot tilav nalǝboian am maii hǝn b̃epul hǝni. Avil avan ideh tomǝtahun b̃elǝboi nǝsa notokele, dereh aGot tilav kuv nalǝboian tokade dani. ");
INSERT INTO klv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Husur enan nusor mai galito len nǝb̃ol p̃usan, husur naut kǝmas lotokǝta, lǝsakǝta lǝboi nǝsa notogole, naut kǝmas lotosǝsǝloŋ, lǝsasǝsǝloŋ hǝn nǝsa notokele, lǝsalǝboii. ");
INSERT INTO klv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ale nasoruan siGot aIsaiah tokel uri isarpoh len galito, ike: “‘Len nasǝsǝloŋan samito, dereh mǝtesǝsǝloŋ be asike mǝtosǝsǝloŋ lǝboi nǝsa notokele, ale len nakǝtaan samito, dereh mǝtekǝta be asike mǝtokǝta lǝboi nǝsa notogole. ");
INSERT INTO klv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Husur nǝkadun alategai egǝm ṽonṽon, pǝpadaŋ nǝdariŋalit eb̃ulb̃ulol, ale namǝtalit ib̃er. Asike lǝtǝmagenan, namǝtalit takǝta ris nǝsa notogole, nǝdariŋalit tasǝsǝloŋ hǝn nǝsa notokele, nǝlolit talǝboi natgalenan, ale lǝtǝpair van hǝn ginau, ale nǝtagol galit lǝtǝmaur.’” ");
INSERT INTO klv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ale aYesu isor am ke, “Gamito, navoian siGot igol mǝtukab hǝn namǝtamito bathut ke lotokǝta, mǝtukab hǝn nǝdariŋamito bathut ke lotosǝsǝloŋ. ");
INSERT INTO klv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Husur nukel nakitinan mai gamito ke, ahai kelkel ur mai nǝvanuan tonor lotosob̃ur lolǝŋon masuṽ ke lǝtaris nǝsa mǝttorisi, be lǝsarisi, lolǝŋon masuṽ ke lǝtasǝsǝloŋ hǝn nǝsa mǝttosǝsǝloŋ hǝni, be lǝsasǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Imagenan, sǝsǝloŋ hǝn namilen nǝb̃ol hǝn nǝvanuan tobubulan namisurhuwit. ");
INSERT INTO klv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Namisurhuwit torus len nap̃isal esum̃an nǝvanuan gail lotosǝsǝloŋ hǝn nasoruan hǝn natohan pipihabǝlan aGot be lǝsalǝboii, gai tosa vǝsa masuṽ tovi tǝmat egǝm, lav kuv namisurhut nasoruan enan dan nǝlolito. ");
INSERT INTO klv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Namisurhuwit torus len naut tobaŋ vat esum̃an alat lotosǝsǝloŋ hǝn nasoruan, ale vǝha-sua ŋai lotǝgau gati len nakemkeman. ");
INSERT INTO klv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Avil lǝsǝkad nǝharhǝt tovi pan gol lǝsǝmaur sabǝlav. Be nǝboŋ todaŋ b̃ibari o avan ideh b̃emǝdas buni gol lǝb̃elǝŋon b̃isa, dereh limayoh tutut, luteh dan nadǝlomian len nasoruan. ");
INSERT INTO klv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Namisurhuwit torus len nǝhau tokad nasunite esum̃an alat lotosǝsǝloŋ hǝn nasoruan avil nǝ-nau-masuṽ-an hǝn nǝmauran ta damǝŋai mai nagǝrasian hǝn na-pul-hǝn-natite-an aroruŋ gut bun nasoruan gol sǝṽan. ");
INSERT INTO klv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Avil namisurhuwit torus len nǝtan tokǝnoh esum̃an alat lotosǝsǝloŋ hǝn nasoruan, lotolǝboii, lotoṽan masuṽ. Sual iṽan vǝkad 100, sual iṽan vǝkad 60, sual am iṽan vǝkad 30.” ");
INSERT INTO klv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","AYesu ikel nǝb̃ol p̃usan sual am mai galito, ike, “Natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad avan sua tobubulan namisurhuwit tovoi len nǝmarireu san. ");
INSERT INTO klv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Be nǝboŋ topat len mariug, aenemi sua egǝm, ebubulan namisurhuliol tosa len nǝmarireu tokad nawit tia, ale ivan. ");
INSERT INTO klv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nǝboŋ nawit totov, tub̃at b̃iṽan, naliol tosa am itov. ");
INSERT INTO klv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naslev gail simahean naim logǝm hǝni, luke, ‘Nasub̃, gaiug gobubulan namisurhuwit tovoi len nǝmarireu sam̃ be gagai epul hǝn naliol tosa! Imabe?’ ");
INSERT INTO klv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ale ikel mai galit ke, ‘Aenemi sua igol nategai.’ Ŋa naslev gail lousi ke, ‘Guke namteput tuan naliol enan a?’ ");
INSERT INTO klv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ris toke, ‘Ao, nǝboŋ mǝtb̃eputi, dereh mǝteput mǝdas nawit am. ");
INSERT INTO klv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Riŋ gǝlar p̃isi aritov b̃onb̃on vǝbar nǝmatuan, ale len nǝboŋ hǝn nǝmatuan, dereh nikel mai nǝvanuan nǝmatuan ke lepǝpehun gǝlaru, baŋis tuan naliol tosa hǝn lǝb̃epǝŋasi, ale baŋis tuan nawit vi lan naim sagw notoriŋriŋ nǝhanian lan.’” ");
INSERT INTO klv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","AYesu ib̃ol p̃usan tǝtas ike, “Natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad namisurhumastat avan sua tomabule len nǝhol san. ");
INSERT INTO klv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ekǝkereh sǝhor namisurhuhanian tiltile gail, avil nǝboŋ totov, egǝm tibau sǝhor nǝhanian gail len nǝhol, ale egǝm vi hai, hǝn ke nǝman namǝsav logǝm um hǝn nǝhai ŋodŋod salit len nǝpashǝt gail.” ");
INSERT INTO klv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","AYesu ikel nǝb̃ol p̃usan. Ike, “Natohan pipihabǝlan aGot len nǝmav imaiegai: Mitinau nayis, apǝhaṽut sua tolavi. Eb̃undasi len nǝhad nǝflaua totor van vǝbar nǝflaua kavkav totob.” ");
INSERT INTO klv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","AYesu ikel natgalen p̃isi mai naluṽoh gail len nǝb̃ol p̃usan. Nǝboŋ tosor mai galito, ikel nǝb̃ol p̃usan akis ŋai. ");
INSERT INTO klv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Igol tomaienan hǝn b̃igol nǝsa ahai kelkel ur tokele b̃isarpoh ke, “Nǝboŋ nǝb̃esǝŋav hǝn nabuŋogw, dereh nisor len nǝb̃ol p̃usan, dereh nikel ur natit gail lotosusuah ta sutuai len natub̃atan, nǝboŋ notoum hǝn navile a pan.” ");
INSERT INTO klv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Beti aYesu eriŋ naluṽoh, evi lohoim. Ale ahai susur san gail logǝm hǝni, luke, “Kel mai ginamito bai, namilen nǝb̃ol hǝn naliol tosa len nǝmarireu.” ");
INSERT INTO klv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isor var galit ke, “Atenan tobubulan namisurhuwit tovoi evi aNatun Nǝvanuan, ");
INSERT INTO klv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ale nǝmarireu evi navile a pan. Namisurhuwit tovoi lovi alat lototoh pipihabǝlan aGot. Naliol tosa lovi alat sitenan tosa vǝsa masuṽ tovi tǝmat. ");
INSERT INTO klv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ale aenemi tobubulan namisurhuliol tosa, evi natǝmat. Nǝboŋ hǝn nǝmatuan evi nǝboŋ hǝn nanoŋan hǝn navile a pan, nagilen hǝn natit p̃isi, ale alat nǝmatuan lovi aŋel gail. ");
INSERT INTO klv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sum̃an alat nǝmatuan lotobaŋis tuan naliol tosa hǝn nǝhab b̃ihani, dereh timagenan len nagilen hǝn natit p̃isi. ");
INSERT INTO klv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dereh aNatun Nǝvanuan tesǝvat aŋel san gail hǝn lǝb̃epǝpehun galit p̃isi lotogol nǝvanuan b̃igol nǝsaan, mai alat lotogol nǝsaan, dan natohan pipihabǝlan. ");
INSERT INTO klv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dereh aŋel gail libar hǝn galito vi lan nǝhab topud vǝsa; len naut enan dereh litaŋ, likat b̃urb̃ur nariṽolito. ");
INSERT INTO klv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Beti alat lotonor dereh lesum̃an namityal tom̃ial habat len natohan pipihabǝlan aTǝmalito. Nǝvanuan tokad nǝdariŋan tesǝsǝloŋ! ");
INSERT INTO klv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad nakontit sua tovoi buni, nǝvat han tosob̃ur, tosusuah len nǝmarireu sua. Ale avan sua isab̃i. Itavun tǝtas hǝni. Ale len nakemkeman san ivan, ep̃ur hǝn natit p̃isi tokade ale ia ṽur nǝmarireu enan hǝn b̃ikad natenan tovoi. ");
INSERT INTO klv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nukele am ke, natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad avan sua toṽur natit gail, p̃ur hǝn gail, todoŋ nanesnes tovoi gail. ");
INSERT INTO klv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ale nǝboŋ tosab̃ nanesnes sua, nǝvat han totibau, ivan, p̃ur hǝn natit p̃isi tokade, ale ia ṽur nanesnes enan. ");
INSERT INTO klv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nukele am ke, natohan pipihabǝlan aGot len nǝmav imaiegai: Nǝvanuan galevis lubar hǝn nalevlev len nab̃iltiwai. Sǝdareh ikad namǝŋod totiltile tosob̃ur tovisivis lan. ");
INSERT INTO klv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ale nǝboŋ topul, lolivi vahut, lobǝtah, losǝŋon tovoi gail len nǝhad sua ale lubar hǝn tosa gail vi tut. ");
INSERT INTO klv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dereh timagenan len nǝboŋ hǝn nanoŋan hǝn navile a pan, nagilen hǝn natit p̃isi. Aŋel gail dereh lia pǝpehun alat lotosa vǝsa dan alat lotonor. ");
INSERT INTO klv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dereh libar hǝn alat lotosa vi lan nǝhab topud vǝsa vagol nametǝlai tovi wai; len naut enan dereh litaŋ, likat b̃urb̃ur nariṽolito.” ");
INSERT INTO klv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","AYesu eus galit ke, “Mǝtolǝboi sǝhot natgalen p̃isi m̃au a?” Lusor vari ke, “Evoi, namtolǝboii.” ");
INSERT INTO klv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ŋa ikel mai galit ke, “Ahai p̃usan hǝn nalo siMoses togǝm vi ahai susur len natohan pipihabǝlan aGot len nǝmav, ahai p̃usan enan esum̃an amahean naim topul hǝn nakontit gail. Eriŋ natgalenan len naut sua hǝn lǝb̃esuh ei. Ale ilav nakontit toveveu mai nakontit tomatu dan naut enan.” ");
INSERT INTO klv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nǝboŋ aYesu tokel nǝb̃ol p̃usan galenan tonoŋ, eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ale nǝboŋ tobar naut a Nasaret, naut totibau lan, ep̃usan len naim nab̃onb̃onan salito. Galit lup̃aŋ, luke, “Eee, namitisau hǝn nǝmauran tovoi egai, gai ilavi a be? Nǝdaŋan hǝn b̃igol namerikel gail, ilavi a be? ");
INSERT INTO klv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Be savi anatun ulum̃an sinǝvanuan na-um-im-an a? Anan, nahǝsan aMeri a? Aṽan aJemes, aJosef, aSimon mai aJutas a? ");
INSERT INTO klv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ale aṽavinen gail p̃isi lǝsatoh mai gidato a? B̃imaienan, ilav natgalen a be? Savi gai hǝn b̃imaienan!” ");
INSERT INTO klv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ale nǝlolit epǝŋasi, lomǝtahuni. Be aYesu ikel mai galit ke, “Ahai kelkel ur ideh, len naut p̃isi loputsani len nǝnauan salito, be len naut a im san mai len naim san, lunau ke tovi ut kǝmas.” ");
INSERT INTO klv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ale aYesu sagol namerikel sasob̃ur len naut enan husur lupar dǝlomian lan. ");
INSERT INTO klv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nǝboŋ aHerot Antipas tosǝsǝloŋ hǝn na-kel-uri-an husur aYesu, ");
INSERT INTO klv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ikel mai naslev lotokǝtkǝta tǝban ke, “Atenan aJon Baptais bolai! Ile mǝhat dan nǝmatan, imagenan nǝdaŋan hǝn b̃igol namerikel gail ipat lan.” ");
INSERT INTO klv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","AHerot ekǝmaienan husur a m̃o igol ke lototah gat aJon, riŋi len naim bǝbaŋis sil abareab siHerot, aHerotias tovi asoan aFilip, aHerot aṽan aFilip tosǝhar kuvi. ");
INSERT INTO klv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Lutah gat aJon husur ikel titau hǝn aHerot ke, “Len nalo sanor hǝn gǝb̃esǝhar alitenan.” ");
INSERT INTO klv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","AHerot ike tigol aJon timat be emǝtahw len nǝlol paŋpaŋ sinaluṽoh bathut lunau ke aJon tovi ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Len nǝhanan hǝn nǝboŋ nǝpasian siHerot, anatvavin aHerotias isav len nǝholito ale aHerot ehǝhaṽur habat hǝni. ");
INSERT INTO klv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Imagenan ita gat na-kel-gati-an sua hǝn b̃eviol hǝn natideh gai b̃elǝŋoni maii. ");
INSERT INTO klv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ŋa nǝboŋ anan tokel maii hǝn nǝsa hǝn b̃eusi, natǝbarehreh ikel mai aHerot ke, “Nolǝŋon nǝkadun aJon Baptais, gegai, len nasiloh!” ");
INSERT INTO klv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ale naut kǝmas ilolosa, bathut na-kel-gati-an san gai tota gati, mai alat lotosuh len nǝhanan, aHerot ikele hǝn nasoltia galevis ke tehum tousi. ");
INSERT INTO klv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ale lovi lan naim bǝbaŋis, luta kotov nǝkadun aJon. ");
INSERT INTO klv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Loriŋ nǝkadun len nasiloh, pati, lavi mai natǝbarehreh topati vǝlavi mai anan. ");
INSERT INTO klv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Beti ahai susur siJon logǝmai, lupat niben van vǝtavuni. Ale nǝboŋ lototavuni tonoŋ, luvan hǝn aYesu, lukel nǝsa tovisi maii. ");
INSERT INTO klv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nǝboŋ aYesu tosǝsǝloŋ hǝn na-kel-uri-an husur aJon, isah len nab̃ot sua, eriŋ naut enan hǝn b̃itoh sǝb̃on len naut tob̃ǝb̃esw. Nǝboŋ naluṽoh gail lotosǝsǝloŋ hǝni, loriŋ nab̃iltivile gail, luyar a ut husuri. ");
INSERT INTO klv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nǝboŋ aYesu tomariŋ dan nab̃ot, eris nab̃iltiluṽoh, nǝlon itaŋis galito ale igol alat lotomǝsah lumaur. ");
INSERT INTO klv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nǝboŋ naut togomgom, ahai susur san gail logǝm hǝni, luke, “Naut eg ipat a tut dan navile gail. Namityal ivan p̃isi tia. Sǝvat naluṽoh van, hǝn lǝb̃evi lan navile gail hǝn lǝb̃idas hanian hǝn lǝb̃eṽuri.” ");
INSERT INTO klv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ris aYesu tokel mai galit ke, “Salivan, gamit m̃au mitilav nǝhanian mai galito.” ");
INSERT INTO klv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lukel maii ke, “Be namtsǝkad natideh gegai, natuhbǝta torim mai naieh toru ŋai.” ");
INSERT INTO klv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ale ike, “Tariv gail gǝm, mai ginau.” ");
INSERT INTO klv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Beti ikel mai naluṽoh ke lebǝtah len naliol. Ale ilav nabǝta torim mai naieh toru, ekǝta vi lan nǝmav, ikel nasipaan. Eb̃ur gail, ilav nabǝta mai ahai susur san gail ale lopǝpehun gail mai naluṽoh. ");
INSERT INTO klv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Galit p̃isi luhan, luhanukub, ale losǝsǝŋon hudhuhanian van, gol nǝhad tovi 12 lopul. ");
INSERT INTO klv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ikad alalum̃an lotovi 5,000 lotohan, be ikad alatpǝhaṽut mai alahutai am. ");
INSERT INTO klv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Beti aYesu igol ahai susur gail lusah len nab̃ot hǝn lǝb̃eil a m̃o vi lan nǝtarhǝt nab̃iltiwai. Ale gai esǝvat naluṽoh gail hǝn lǝb̃eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nǝboŋ tosǝvat galit tonoŋ, aYesu etǝṽehuh sǝb̃on vi lan naṽehuh hǝn b̃isor mai aGot. Ale nǝboŋ naut togomgom itoh sǝb̃on ei. ");
INSERT INTO klv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Len namityal enan, nab̃ot isal vi rivuh a tut dan nǝtan. Nǝwai ekudkud vapus, gol iṽas nab̃ot husur isoh b̃ur nǝlan. ");
INSERT INTO klv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Len nadudulan som̃ilan naut sǝlan sal be aYesu egǝm hǝn galito, iyar len nǝp̃on nab̃iltiwai. ");
INSERT INTO klv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nǝboŋ ahai susur gail lotoris toyaryar p̃oniwai, nǝkadulit eṽurṽur. Lukai ke, “Wao! Nanunun sua bolai.” Ale ninelit epil gol lukai habat. ");
INSERT INTO klv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Vǝha-sua ŋai aYesu isor mai galit ke, “Samtemǝtahw! Mǝteil b̃uri! Ginau bogai!” ");
INSERT INTO klv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","APita ikai van hǝni ke, “Nasub̃, b̃evi gaiug kitin, kel mai ginau ke niyar len nǝp̃on nǝwai van hǝn gaiug.” ");
INSERT INTO klv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ale ike, “Gǝmai!” Nǝboŋ aPita tomariŋ dan nab̃ot, iyar p̃oniwai van hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Be nǝboŋ aPita toris nǝlan todaŋ, emǝtahw, etub̃at sar maduŋduŋ ale ikai ke, “Nasub̃, numat! Liv kuv ginau!” ");
INSERT INTO klv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Vǝha-sua ŋai aYesu isar hǝn navǝlan, itah gati, ale ike, “Gaiug gotokad natuhdǝlomian ŋai, nǝlom̃ eur ginau mabe?” ");
INSERT INTO klv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ale nǝboŋ artosah len nab̃ot, nǝlan idar buni. ");
INSERT INTO klv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Beti alat len nab̃ot lulotu hǝni ke, “Govi aNatun aGot kitin.” ");
INSERT INTO klv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nǝboŋ lotolav tukot len nab̃iltiwai, luvahut len naut a Kennesaret. ");
INSERT INTO klv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nǝboŋ alat len naut enan lotokǝta lǝboi aYesu, lopisul van hǝn naut p̃isi todar vis naut enan ale losǝhar alat lotomǝsah van hǝni. ");
INSERT INTO klv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Loŋiri ke tidam̃ hǝn lǝb̃ibar ŋai nasum̃arhǝt nahurabat san, ale galit p̃isi lotobari lumaur. ");
INSERT INTO klv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Beti naFarisi gail mai ahai p̃usan hǝn nalo luyar a Jerusalem gǝm hǝn aYesu, luke, ");
INSERT INTO klv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Imabe ahai susur sam̃ gail lupal sob dan nap̃isal hǝn naṽide sihaṽut sidat gail ta sutuai? Husur lǝsakǝkasǝval nǝboŋ lotohan.” ");
INSERT INTO klv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ris aYesu tosor var galit ke, “Gamit, imabe mǝtob̃ur kotov nalo siGot m̃os mǝtb̃ehusur naṽide samit ta sutuai? ");
INSERT INTO klv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bathut aGot ike, ‘Putsan atǝmam̃ mai anam̃ matmat len nǝnauan sam̃,’ ikele am ke, ‘Avan ideh tosor tosa todaŋ hǝn atǝman o anan, gai timat ebun m̃au.’ ");
INSERT INTO klv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Avil gamito, mǝtumakuv dan nalo siGot hǝn mǝtb̃ehusur naṽide samit ta sutuai nǝboŋ mǝttop̃usan ke, ‘Avan ideh b̃ikel mai atǝman o anan ke, “Nǝsa notokade hǝn nǝb̃evi tarhǝt sam̃, noviol hǝni tia mai aGot. Gai b̃igol b̃imagenan, inor ŋai ke asike eputsan atǝman len nǝnauan san.”’ Gamito, mǝtugol ke nakelean siGot evi naut kǝmas ŋai. ");
INSERT INTO klv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mǝtovi nǝvanuan gǝgǝras ŋai. Nǝsa aGot tokele len nabuŋon aIsaiah husur gamito ekitin. Ike, ");
INSERT INTO klv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Nǝvanuan galegai loputsan nahǝsagw len nasoran salito, be len nǝlolito, lunau ke notovi naut kǝmas. ");
INSERT INTO klv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lulotu sob̃uer hǝn ginau, lop̃usan hǝn nakelean sinǝvanuan, hum tovi lo sagw.’” ");
INSERT INTO klv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Beti aYesu ekis naluṽoh gǝmai, ikel mai galit ke, “Mǝtesǝsǝloŋ hǝn nǝsa notokele, mǝtelǝboii. ");
INSERT INTO klv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Savi nǝsa tovi lan nǝp̃an togol nǝvanuan tob̃iŋb̃iŋal len nǝhon aGot. Ao, evi nǝsa tovivile dan nabuŋon togol nǝvanuan tosa, evi nǝsa tokele togol nǝvanuan saveveu.” ");
INSERT INTO klv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Beti ahai susur gail logǝm hǝni luke, “Nǝboŋ naFarisi gail lotosǝsǝloŋ hǝn nǝsa gotomadhakele, igol nǝlolit isa. Golǝboii m̃au a?” ");
INSERT INTO klv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ris aYesu tosor var galit ke, “Nǝhai ideh aTǝmagw len nǝmav sǝmabule, dereh teput kuvi. ");
INSERT INTO klv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Riŋ galit lesuh! Lovi metb̃esw gail lotosǝhar alat lǝsakǝta. Nametb̃esw sua b̃esǝhar nametb̃esw togon, dereh gǝlar p̃isi ariteh, arimasur len nab̃ur.” ");
INSERT INTO klv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ale aPita ike, “Kel namilen nasoruan kǝta enan mai ginamito.” ");
INSERT INTO klv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","AYesu ike, “Gamito am, mǝtsalǝboi sǝhoti a? ");
INSERT INTO klv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mǝtolǝboii tia ke natit p̃isi tovi lan nǝp̃an nǝvanuan, evi lan natǝbaŋ van, evivile vi lan nalitavtav. ");
INSERT INTO klv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Avil natit gail nǝvanuan tokele, nǝsa tovivile dan nabuŋon, egǝm len nǝsa topat len nǝlon, ale natgalenan lugol nǝvanuan isa, saveveu. ");
INSERT INTO klv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Husur natgalegai logǝm len nǝlon: nǝnauan tosa, nagolean hǝn nǝmatan, naitian tob̃ur kotov nǝlahan, naitian tosa, navǝnahan, naliboŋan len nakotan, mai nasoruan tomǝdas nahǝsan nǝvanuan o tomǝdas nahǝsan aGot. ");
INSERT INTO klv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Natgalenan lugol nǝvanuan lob̃iŋb̃iŋal len nǝhon aGot. Naṽide hǝn nakǝkasǝvalan len nǝhanan sagole!” ");
INSERT INTO klv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beti aYesu eriŋ naut a Kalili, evi lan naut pǝpadaŋ hǝn nab̃iltivile eru, a Tair mai a Siton. ");
INSERT INTO klv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Atob̃taKenaan sua totoh len naut enan, egǝm hǝn aYesu, ikai ke, “Nasub̃, aNatun siTevit, gilolosa hǝn ginau. Natǝmat sua emǝdas anatvavigw vǝsa!” ");
INSERT INTO klv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Be aYesu sasor vari len nasoruan ideh. Ale ahai susur san gail logǝm hǝni luke, “Sǝvati vi tut bathut ehusur gidato, ikai walwal!” ");
INSERT INTO klv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Len na-sor-vari-an san aYesu ike, “AGot esǝvat ginau van hǝn alat a Israel ŋai lotohum nasipsip gail lotomasig.” ");
INSERT INTO klv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋa alitenan egǝm, teh bathurien aYesu, ike, “Nasub̃, gevi tarhǝt sagw!” ");
INSERT INTO klv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","AYesu ike, “Sanor hǝn nǝb̃ilav kuv nabǝta hinatugw gail hǝn nǝb̃ibar hǝni van hǝn nalipah gail.” ");
INSERT INTO klv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ris aliten toke, “Evoi, Nasub̃, be nalipah gail lolǝboi lǝb̃ihan nasugut nabǝta torus vi pan dan natev simasta salito.” ");
INSERT INTO klv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ale aYesu isor vari ke, “Bareab, gaiug gukad nadǝlomian totibau masuṽ! Tevisi m̃os gaiug hum gotolǝŋoni.” Ale anatvavin imaur len namityal enan van. ");
INSERT INTO klv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","AYesu eriŋ naut enan, etǝlmam vi Kalili, iyar husur nǝtarhǝb̃iltiwai Kalili. Ale etǝṽehuh vi lan naṽehuh, ebǝtah ei. ");
INSERT INTO klv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nab̃iltiluṽoh gail logǝm hǝni, losǝhar alat lotogau, nametb̃esw gail, alat narielit tosa gol lǝsǝyar, nab̃ut gail mai isob̃ur am. Loriŋ galit bathurien aYesu ale igol galit lumaur. ");
INSERT INTO klv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Naluṽoh lumaŋmaŋ len nǝsa lotorisi. Nab̃ut gail lusor; alat narielit tosa, nibelit ivoŋǝvoŋ, lumaur; alat lotogau luyar; mai nametb̃esw gail lokǝta. Ale lusal suh nǝyalyalan siGot silat a Israel. ");
INSERT INTO klv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Beti aYesu ekis ahai susur san gail gǝmai ike, “Nǝlogw itaŋis alategai, husur lutah mai ginau len nǝmariboŋ totor tia ale lǝsǝkad natideh hǝn lǝb̃ihani. Nǝsalǝŋon nǝb̃esǝvat galit van malkǝkat. Nǝb̃igole, dereh limatmatioṽ husur nap̃isal salito.” ");
INSERT INTO klv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ale ahai susur gail lukel maii ke, “Len naut tob̃ǝb̃esw topat sǝb̃on maiegai, namtilav natuhbǝta tihau mabe hǝn namtb̃evǝŋan nab̃iltiluṽoh egai?” ");
INSERT INTO klv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","AYesu eus galit ke, “Mǝtukad natuhbǝta evis?” Luke, “Namtukad emǝlevru mai natuhieh galevis.” ");
INSERT INTO klv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ŋa aYesu ikel mai naluṽoh ke lebǝtah len tan. ");
INSERT INTO klv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ilav natuhbǝta tomǝlevru mai naieh gail, esipa vi tǝban aGot hǝn nǝhanian, eb̃uri, lavi mai ahai susur gail ale lopǝpehuni mai naluṽoh. ");
INSERT INTO klv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Galit p̃isi luhan vǝhanukub. Ale losǝŋon nahudhuhanian van gol nǝhad tomǝlevru lopul. ");
INSERT INTO klv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ikad alalum̃an lotovi 4,000 lotohan, be ikad alatpǝhaṽut mai alahutai gail am. ");
INSERT INTO klv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Beti aYesu esǝvat naluṽoh gail van. Ale isah len nab̃ot, igam van vǝbar naut a Makatan. ");
INSERT INTO klv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Boŋ sua naFarisi mai naSattiusi gail logǝm hǝn aYesu. Lolǝŋon ke aYesu tigol nǝsaban, ŋa lousi hǝn b̃eṽusan galit hǝn namerikel hǝn nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Be aYesu isor var galit ke, “Nǝboŋ namityal tomasur mǝtuke, ‘Pelan dereh naut tivoi husur nǝmarigw ikathab,’ ");
INSERT INTO klv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ale len nadudulan mǝtuke, ‘Damǝŋai naut ibatmot, nǝmarigw epit vi mǝhat mai nǝmav epitau. Dereh naut tisa. Nab̃iltius dereh teus.’ Mǝtolǝboi mǝtb̃eris nǝsa tovisi len nǝmav, ale vǝha-sua ŋai mǝtolǝboii ke naut tivoi o tisa, be mǝtodǝdas mǝtb̃eris lǝboi namilen nǝsa tovisi len nǝboŋ gail ta damǝŋai. Mitimabe? ");
INSERT INTO klv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gamit naur ta damǝŋai mǝtusa, mǝtsǝdaŋ len aGot sum̃an apǝhaṽut tohusur aulum̃an tiltile, sǝdaŋ len asoan. Mǝtous namerikel, avil asike nugol namerikel ideh, be dereh nigol ŋai namerikel hǝn nasuhunian sihai kelkel ur, aJonah.” Ale aYesu eriŋ galito, ivan dan galito. ");
INSERT INTO klv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nǝboŋ ahai susur gail lotogam tukot vǝbar nǝtarhǝt nab̃iltiwai, nǝlolit iboŋboŋ hǝn lǝb̃esǝŋon nabǝta ideh van. ");
INSERT INTO klv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ale aYesu ikel mai galito ke, “Mǝtelǝlǝgau hǝn gamit gabag! Mǝtekǝtkǝta gol gamito dan nayis hiFarisi mai Sattiusi gail.” ");
INSERT INTO klv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lusor mai galit gabag ke, “Ekǝmaienan husur datsǝlav nabǝta ideh gǝmai.” ");
INSERT INTO klv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","AYesu elǝboi nǝnauan salito ŋa ike, “Gamit mǝttokad natuhdǝlomian ŋai, mǝtuhol husur nabǝta mǝtsǝkade hǝn nǝsa? ");
INSERT INTO klv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mǝtsalǝboi sal a? Nǝlomit iboŋboŋ hǝn natuhbǝta torim hilat lotovi 5,000 mai nǝhad gail p̃isi mǝttosǝŋoni a? ");
INSERT INTO klv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nǝlomit iboŋboŋ hǝn natuhbǝta tomǝlevru hilat lotovi 4,000 mai nǝhad gail p̃isi mǝttosǝŋoni a? ");
INSERT INTO klv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Imabe? Mǝtunau sal ke nusor husur nabǝta m̃au a? Aoa! Be nukel mai gamit tǝtas ke, kǝtkǝta gol gamito dan nayis hiFarisi mai Sattiusi gail!” ");
INSERT INTO klv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Beti len namityal enan ŋai lunau sǝhoti ke nǝboŋ tokel nalǝlǝgauan mai galito, gai sasor husur nayis len nabǝta. Ao isor tas nap̃usanan siFarisi mai Sattiusi gail. ");
INSERT INTO klv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","AYesu eriŋ naut enan ale nǝboŋ tobar naut a Sisarea Filippi, eus ahai susur san gail ke, “Nǝvanuan gail lotosor husur aNatun Nǝvanuan, luke tovi ase?” ");
INSERT INTO klv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lusor vari ke, “Galevis luke aJon Baptais. Galevis luke aElijah. Galevis am luke aJeremiah o ahai kelkel ur sual am.” ");
INSERT INTO klv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Beti eus galit ke, “Be gamito, mǝtunau ke ginau ase?” ");
INSERT INTO klv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ASimon Pita isor vari ke, “Gaiug boh aKristo, aNatun aGot nǝkadun nǝmauran.” ");
INSERT INTO klv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ale aYesu ikel maii ke, “Tivoi hǝn gaiug, aSimon anatun aJonah! Savi avan ideh len navile a pan tokel vǝhot natenan, be aTǝmagw len nǝmav ikel vǝhoti mai gaiug. ");
INSERT INTO klv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nukele am mai gaiug ke govi aPita, nǝvat, ale dereh neum hǝn naim sagw len nǝvat enan, naim sagw tovi vanuan sagw gail. Ale nǝdaŋan hǝn nǝmatan edǝdas b̃esǝhor galito. ");
INSERT INTO klv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nukele am mai gaiug ke, dereh neviol hǝn naki hǝn nabopita hǝn natohan pipihabǝlan aGot len nǝmav mai gaiug. Natideh gǝb̃ikai tasi len navile a pan, evi nǝsa aGot tokai tasi tia len nǝmav. Ale natideh gǝb̃idam̃ hǝni len navile a pan, evi nǝsa aGot todam̃ hǝni tia len nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Beti aYesu ikel p̃uli hǝn ahai susur gail ke salikel avan ideh ke gai tovi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Len nǝboŋ enan van, aYesu etub̃at kele ip̃arp̃ar mai ahai susur san gail ke timasvi Jerusalem ale timaslǝŋon tisa vǝsa len naṽide tosob̃ur len navǝlan alat lotoil a m̃o hǝn nǝvanuan gail, ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo. Ale dereh ligol timat. Beti len nǝmariboŋ b̃itor dereh aGot tigol tile mǝhat. ");
INSERT INTO klv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Beti aPita eliv aYesu vi tarhǝte, etub̃at sor lan, ike, “Satimaiean, Nasub̃! Natgalenan salevisi hǝn gaiug!” ");
INSERT INTO klv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Be ipair van hǝn aPita, ike, “Gevi tahw dan ginau aSetan! Gugol risi hǝn nǝb̃ipes hab̃etw hǝn nǝb̃iteh. Nǝnauan sam̃ gail lǝsǝpat len nǝsa aGot tolǝŋoni, lohusur nalǝŋonian sinǝvanuan ŋai.” ");
INSERT INTO klv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Beti aYesu ikel mai ahai susur san gail ke, “Avan ideh b̃ike b̃ehusur ginau, timaske, ‘Aoa,’ hǝn nǝnauan mai nalǝŋonian san gabag, timasvus nǝhai balbal san, tehusur ginau. ");
INSERT INTO klv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Husur avan ideh b̃ike b̃iwol hǝn nǝmauran san gabag hǝn b̃etǝgau gat nǝmauran san, dereh timasig. Be nǝmauran san b̃imasig m̃os ginau, dereh tikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nǝvanuan b̃ikad natit p̃isi len navile a pan, be nǝmauran san vi sutuai b̃imasig, imabe? Ikad nǝsa? Nǝvanuan elǝboi b̃eviol hǝn nǝsa hǝn b̃ikad nǝmauran enan a? ");
INSERT INTO klv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bathut aNatun Nǝvanuan dereh tegǝm ta bog. Dereh tegǝm mai aŋel san gail len nǝdaŋan mai namǝnas seTǝman. Len nǝboŋ enan, dereh tilav nap̃urp̃uran mai nǝvanuan gail hǝn natit p̃isi lotogole, tinor hǝn nǝsa lotogole. ");
INSERT INTO klv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nokitin mai gamit ke, gamit galevis mǝttoil gegai, asike lumat van vǝbar lǝb̃eris nagǝmaian siNatun Nǝvanuan hǝn b̃eil a m̃o hum aKiŋ.” ");
INSERT INTO klv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Len nǝmariboŋ tomǝlevtes husur nǝboŋ enan, aYesu esǝhar aPita, mai alarmiṽan, aJemes mai aJon. Esǝhar galit sǝb̃olito vi mǝhat len naṽehuh sua tosahsah. ");
INSERT INTO klv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ale len nǝholito egǝm tile, nǝhon em̃ial hum namityal, nahurabat san egǝm pǝhapǝhw buni vabilbil. ");
INSERT INTO klv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vǝha-sua ŋai loris aMoses mai aElijah artohol mai aYesu. ");
INSERT INTO klv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","APita isor mai aYesu, ike, “Ivoi hǝn dattotoh gegai. Gǝb̃elǝŋoni, dereh neum hǝn nǝpasvalǝval titor, tesua esam̃, tesua siMoses, mai tesua siElijah.” ");
INSERT INTO klv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nǝboŋ aPita tosor sal, nǝmavukasw tom̃ial habat ikabut gol galito, ale nadoldol sua len nǝmavukasw ike, “Ategai evi aNatugw ulum̃an notolǝmas buni, notohǝhaṽur hǝni. Sǝsǝloŋ husuri!” ");
INSERT INTO klv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nǝboŋ lotosǝsǝloŋ hǝn natenan, ahai susur gail luteh, kǝta vi pan, nǝlolit epil vǝsa. ");
INSERT INTO klv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","AYesu egǝm hǝn galito, ibar galito, ike, “Mitile mǝhat. Samtemǝtahw.” ");
INSERT INTO klv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ale nǝboŋ lotokǝta vi mǝhat, lokǝta ris aYesu sǝb̃on ŋai, lǝsaris avan ideh am. ");
INSERT INTO klv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nǝboŋ lotomariŋ vi pan len naṽehuh, aYesu ikele hǝn galit ke, “Samtikel ur nǝsa mǝttorisi mai avan ideh am vir aGot b̃igol aNatun Nǝvanuan b̃ile mǝhat dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Beti ahai susur gail lousi ke, “Ahai p̃usan hǝn nalo luke aElijah timasgǝm a m̃o, be lukele hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","AYesu isor var galit ke, “Evoi, tarhǝt sua, aElijah dereh tegǝm a m̃o hǝn b̃igol tǝlmam hǝn natit p̃isi lǝb̃inor. ");
INSERT INTO klv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Be len nǝtarhǝte am, nukele mai gamit ke, aElijah egǝm tia, ale nǝvanuan gail lǝsakǝta lǝboii, lugol nǝsa lotolǝŋoni hǝni. Imagenan, dereh ligol aNatun Nǝvanuan am telǝŋon tisa vǝsa.” ");
INSERT INTO klv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Len namityal enan ŋai ahai susur gail lunau sǝhoti ke aYesu isor mai galito husur aJon Baptais. ");
INSERT INTO klv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nǝboŋ lototǝlmam dan naṽehuh tonoŋ, logǝm hǝn naluṽoh, ale aulum̃an sua egǝm hǝn aYesu, etǝŋedur bathurien, ");
INSERT INTO klv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ale ike, “Nasub̃, gilolosa hǝn anatugw ulum̃an husur nahumatmat ibari gol ke elǝŋon isa vǝsa batbat. Husur iteh len nǝhab tabtab ale iteh vǝha-sob̃sob̃ur len nǝwai am. ");
INSERT INTO klv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nosǝhari van hǝn ahai susur sam̃ gail avil lodǝdas lǝb̃igol b̃imaur.” ");
INSERT INTO klv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","AYesu isor vari ke, “Eee naur egai mǝttomǝtahun nadǝlomian, mǝttohusur nap̃isal tosa tokab̃kab̃ur, nitoh mai gamit tebǝlav mabe? Mǝtupar dǝlomian van van van nupetǝmas hǝni. Sǝhar natǝtai gǝmai!” ");
INSERT INTO klv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Beti aYesu esivoh len natǝmat ale imakuv dan natǝtai, ale len namityal enan van imaur buni. ");
INSERT INTO klv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ale ahai susur gail logǝm hǝn aYesu, lusor sǝb̃olit maii ke, “Imabe ginamit namtsalǝboi namtb̃ehut natǝmat enan?” ");
INSERT INTO klv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ale ikel mai galit ke, “Mǝtodǝdasi bathut nadǝlomian samit em̃idol, ekǝkereh masuṽ. Husur nokitin mai gamit ke, mǝtb̃ikad nadǝlomian hun namisurhumastat tomarisoris mǝtolǝboi mǝtb̃ikel mai naṽehuh egai ke, ‘Gerus van ea!’ ale dereh terus. Naut kǝmas mǝtunau ke mǝtodǝdas mǝtb̃igol natesua, dereh mǝtolǝboi mǝtb̃igole.” ");
INSERT INTO klv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nǝboŋ ahai susur gail lotob̃onb̃on len naut a Kalili, aYesu isor mai galit ke, “Avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dereh ligol timat, ale len nǝmariboŋ titor aGot tigol tile mǝhat.” Nǝboŋ aYesu tokǝmaienan tonoŋ, ahai susur gail lolǝŋon isa masuṽ. ");
INSERT INTO klv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nǝboŋ aYesu mai ahai susur san gail lotobar naut a Kapernaum, alat lototariv tuan nǝtaks tovi nǝtrahma toru, logǝm hǝn aPita luke, “Ahai p̃usan sam̃, eṽur nǝtaks hǝn naim siGot m̃au a?” ");
INSERT INTO klv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","APita ike, “Evoi.” Ale nǝboŋ tob̃is lohoim, aSimon sakel natideh be aYesu isor a m̃o maii ike, “Simon, len nǝnauan sam̃ nǝsa inor? Nau nakiŋ gail len navile a pan. Ase eṽur nǝlaisens mai nǝtaks lototariv tuani, anatulit gail o nametb̃os gail a?” ");
INSERT INTO klv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ale aPita ikel maii ke, “Nametb̃os gail.” Beti aYesu ike, “B̃imaienan, savi len anatulit gail hǝn lǝb̃eṽuri. ");
INSERT INTO klv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Be hǝn asike nǝlolit b̃ipaŋpaŋ, givan hǝn nab̃iltiwai, bar hǝn nǝhau. Naieh metǝkav gǝb̃isah hǝni, sǝŋav hǝn nabuŋon ale dereh gisab̃ nakoin tovi nǝstater. Lav kuvi, lavi mai galito m̃os nǝtaks sidaru.” ");
INSERT INTO klv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Len namityal enan ahai susur gail logǝm hǝn aYesu lousi ke, “Ase iyalyal sehor galit am len natohan pipihabǝlan aGot len nǝmav?” ");
INSERT INTO klv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ale aYesu ekis natuhtǝtai sua gǝmai, igol eil rivuh len galito. ");
INSERT INTO klv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Beti ike, “Nokitin, nukel mai gamit ke, asike mǝtb̃ipair dan naṽide tosa samito hǝn mǝtb̃esum̃an atuhlahutai, mitimabe? Asike asike mǝtob̃is len natohan pipihabǝlan aGot len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Imagenan, avan ideh b̃eriŋ gai hum tovi ut kǝmas sum̃an natuhtǝtai egai, gai iyalyal sǝhor galit am len natohan pipihabǝlan aGot len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ale avan ideh tohǝhaṽur hǝn natuhtǝtai sum̃an egai b̃itah maii len nahǝsagw, gai ehǝhaṽur hǝn ginau nǝb̃itah maii. ");
INSERT INTO klv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ale avan ideh b̃igol atuhlahutai sua, tokad nadǝlomian len ginau, b̃iteh len nǝsaan, nǝpanismen sitenan dereh tisa am sǝhor ke nǝvanuan galevis lǝb̃itahǝtah hǝn nab̃iltivat len naholoan, ale lǝb̃ibar hǝni len tas hǝn b̃imaduŋduŋ butitas tosareh vi pan. ");
INSERT INTO klv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Navile a pan dereh tisa vǝsa bathut natit gail lotogol nǝvanuan gail lotogol nǝsaan. Natgalenan lotomaienan dereh limasvisi be tisa vǝsa tibatbat hǝn nǝvanuan togol natgalen lǝb̃evisi. ");
INSERT INTO klv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ale, navǝlam̃ o nariem̃ b̃igol gaiug gǝb̃igol nǝsaan, gita kotovi, bar hǝni vi tut. Gǝb̃ikad nǝmauran vi sutuai be nariem̃ b̃isa gol gǝsǝyar o gugau, natenan esǝhor gǝb̃ikad nariem̃ gǝlar p̃isi arb̃ivoi ale aGot b̃ibar hǝn gaiug len nǝhab topaŋ vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Namǝtam̃ b̃igol gǝb̃iteh len nǝsaan, kis kuvi, bar hǝni vi tut. Gǝb̃ikad nǝmauran vi sutuai be namǝtam̃ b̃esua b̃ib̃esw, natenan esǝhor gǝb̃ikad namǝtam̃ gǝlar p̃isi arb̃ivoi ale aGot b̃ibar hǝn gaiug len nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Mǝtelǝlǝgau hǝn gamito! Atuhlahutai ideh tokad nadǝlomian len ginau, samtinau ke gai evi naut kǝmas. Husur nukele mai gamit ke, aŋel gail lotokǝtkǝta tǝban galito, lolǝboi tabtab hǝn lǝb̃isor m̃os galito len nǝhon aTǝmagw len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mitinau natsua. Avan ideh b̃ikad nasipsip lotovi 100, ale sua iyar lab vi tut sua, mǝtunau ke tigol nǝsa? Dereh atenan teriŋ lotovi 99 lesuh len naṽehuh hǝn b̃ia doŋ tosua toyar lab vi tut. ");
INSERT INTO klv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ale b̃isab̃i, nukel nakitinan mai gamito ke, ikemkem tǝban sǝhor lotovi 99 lǝsǝyar lab vi tut. ");
INSERT INTO klv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Imagenan, savi nalǝŋonian seTǝmamito len nǝmav hǝn atuhlahutai galegai ideh b̃imasig.” ");
INSERT INTO klv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","AYesu isor am ke, “Nǝbathudud ideh len nadǝlomian b̃igol nǝsaan hǝn gaiug, gia sor mai gai sǝb̃on, kel p̃arp̃ar hǝn nǝsa tosa gai togole maii. Gai b̃esǝsǝloŋ sǝhot nǝsa gotokele, gukad tǝlmam hǝni sum̃an na-ke-wawa-an len nadǝlomian. ");
INSERT INTO klv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Be asike b̃esǝsǝloŋ hǝn gaiug, gesǝhar nǝvanuan nadǝlomian tesua o teru am hǝn gǝb̃ehusur natosian siGot toke, ‘Nǝboŋ avan ideh b̃ikel uri ke nǝvanuan togon togol nǝsaan, nakitinan hǝn nǝsa tokele timasil p̃arp̃ar len na-kel-koti-an sinǝvanuan toru o totor am.’ ");
INSERT INTO klv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Be asike b̃esǝsǝloŋ husur galito, kel ur natit p̃isi mai nab̃onb̃onan kavkav silat lotokad nadǝlomian len naut enan. Asike b̃esǝsǝloŋ husur alat lotokad nadǝlomian am, len nǝnauan sam̃ riŋi tesum̃an nametb̃os sǝkad nadǝlomian o nǝvanuan nǝtaks. ");
INSERT INTO klv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nukel nakitinan mai gamito ke, natideh gǝb̃ikai tasi len navile a pan tevi nǝsa aGot tokai tasi tia len nǝmav, ale natideh gǝb̃idam̃ hǝni len navile a pan tevi nǝsa aGot todam̃ hǝni tia len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nukel tǝtas hǝn nakitinan mai gamit ke, gamit b̃eru arb̃ikad nǝnauan b̃esua husur natideh len navile a pan, nǝsa arb̃eusi, aTǝmagw len nǝmav dereh tigole m̃os gǝlaru. ");
INSERT INTO klv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Husur toru o totor lotob̃on len nahǝsagw, ginau nutah mai galit ei.” ");
INSERT INTO klv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Beti aPita egǝm hǝn aYesu eusi ke, “Nǝbathudud nadǝlomian sua b̃igol nǝsaan tabtab hǝn ginau, nerub̃at nǝsaan san vǝha-vis? Nerub̃at gail vǝha-mǝlevru a?” ");
INSERT INTO klv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","AYesu isor vari ke, “Ao, nǝsakel ke vǝha-mǝlevru, avil nuke gerub̃at gail sǝŋavur vǝha-mǝlevru vǝha-mǝlevru. ");
INSERT INTO klv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Imaienan, natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad nakiŋ sua toke naslev san gail lisar gel nǝkabut salit maii. ");
INSERT INTO klv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nǝboŋ totub̃at us nǝkabut salito, losǝhar avan sua van hǝni tokabut hǝn nǝtalent tovi 10,000, ale nǝtalent esua ŋai evi nap̃urp̃uran hǝn nauman hǝn nasihau tovi 15. ");
INSERT INTO klv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Husur atenan todǝdas b̃isar gel nǝkabut enan, amasta san ikele hǝni ke tep̃ur hǝn asoan mai anatun gail hǝn lǝb̃egǝm vi slev gail ale tep̃ur hǝn natit p̃isi am gai tokade, hǝn b̃isar gel nǝkabut san. ");
INSERT INTO klv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ŋa naslev iteh bathurien, eŋiri ke, ‘Sagesigarir hǝn ginau, ale dereh nisar gel tǝlmam hǝn natit p̃isi mai gaiug.’ ");
INSERT INTO klv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nǝlon amasta itaŋis naslev san enan, ikas kuv nǝkabut san, eriŋi hǝn b̃ivan. ");
INSERT INTO klv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Beti naslev enan evivile, etut len naslev togon tovi galit sua ŋai tokabut san hǝn nǝvat, natenarius tovi 100. Ale naslev itah gat togon, tub̃at tǝgau gat naholoan, ike, ‘Sar gel nǝvat gotokabut hǝni len ginau!’ ");
INSERT INTO klv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ale naslev togon iteh bathurien eŋiri ke, ‘Sagesigarir hǝn ginau, ale dereh nisar gel tǝlmam hǝni mai gaiug.’ ");
INSERT INTO klv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Be naslev ta m̃o emǝtahuni. Ivan, gole hǝn lǝb̃itah gat togon, riŋi len naim bǝbaŋis vir b̃isar gel p̃is nǝkabut san. ");
INSERT INTO klv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nǝboŋ naslev galen am lotoris nǝsa tovisi, lulolosa masuṽ, ale lua kel ur natit p̃isi lotovisi mai amasta salito. ");
INSERT INTO klv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ale amasta ekis naslev ta m̃o gǝmai, ikel maii ke, ‘Govi slev gotosa vǝsa batbat! Ginau nukas kuv nǝkabut sam̃ p̃isi husur goŋir ginau hǝni. ");
INSERT INTO klv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ivoi am gǝtalolosa hǝn naslev togon sum̃an ginau notololosa hǝn gaiug.’ ");
INSERT INTO klv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ale len nǝlol paŋpaŋ san, amasta eriŋi len navǝlan alat lotokǝtkǝta kǝkol hǝn naim bǝbaŋis hǝn lǝb̃igol niben atenan b̃epǝŋas vir b̃isar gel natit p̃isi gai tokabut hǝni. ");
INSERT INTO klv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Len naṽide tomagenan, len nǝlomito asike mǝtb̃erub̃at kitin hǝn nǝsaan sinǝbathudud nadǝlomian ideh lotogol tosa hǝn gamito, aTǝmagw len nǝmav dereh tigol timaienan hǝn gamito.” ");
INSERT INTO klv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nǝboŋ aYesu tokǝmaienan tonoŋ, eriŋ naut a Kalili, evi Jutea len naut tarhǝwisel Jortan. ");
INSERT INTO klv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nab̃iltiluṽoh gail lohusuri, ale igol galit lumaur ei. ");
INSERT INTO klv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Beti naFarisi galevis logǝm hǝn aYesu, lolǝŋon ke tekǝkos len nasoruan san, mǝdas nahǝsan ale lousi ke, “Inor hǝn aulum̃an b̃etiṽos hǝn asoan, riŋ gab̃ulani husur nǝnauan o nalǝŋonian sitenan ŋai a?” ");
INSERT INTO klv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ris aYesu tosor var galit ke, “Mǝtsaṽuruŋ natosian siGot toke ‘sutuai len natub̃atan aGot igol naulum̃an mai napǝhaṽut a?’ ");
INSERT INTO klv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ale aGot ike, ‘Bathut natenan, naulum̃an dereh teriŋ atǝman mai anan hǝn b̃eudud mai asoan, ale aresua sum̃an artovi niben tosua ŋai.’ ");
INSERT INTO klv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Husur arsaru am, arosua ŋai. Imagenan, naududan aGot togole, nǝvanuan satepǝpehuni.” ");
INSERT INTO klv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ale lousi ke, “B̃imagenan, aMoses ikel nalo toke, ‘Naulum̃an tilav nalob̃ulat hǝn natiṽosan mai asoan ale tesǝvati van,’ ikele husur nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","AYesu ikel mai galit ke, “AMoses idam̃ hǝni ke mǝttotiṽos hǝn asoamito husur nǝkadumit ihaihai masuṽ, avil sutuai len natub̃atan, sǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Be nukel mai gamito ke naulum̃an ideh totiṽos hǝn asoan naut kǝmas alitenan sagol naitian tosa, ale tolah mai napǝhaṽut ideh am, atenan igol naitian tob̃ur kotov nǝlahan.” ");
INSERT INTO klv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ahai susur san gail lukel maii ke, “Nǝlahan naulum̃an tokade mai asoan b̃imaienan, nǝlahan tob̃uer ivoi am.” ");
INSERT INTO klv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ris aYesu tosor var galit ke, “Savi nǝvanuan p̃isi lolǝboi lǝb̃esǝsǝloŋ sǝhot nap̃usanan enan, be aGot ilav nǝdaŋan mai galevis ŋai hǝn lǝb̃elǝboi lǝb̃igole. ");
INSERT INTO klv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Husur sogsog galevis lovi sogsog nǝboŋ analit lotopas galito, be sogsog galevis am, nǝvanuan gail lugol lotovi sogsog. Ale ikad galevis tile am lǝsǝlah m̃os natohan pipihabǝlan aGot len nǝmav gol ke len nǝmauran salito losum̃an sogsog gail. Avan ideh tolǝboi b̃esǝsǝloŋ sǝhot natenan, tesǝsǝloŋ sǝhoti!” ");
INSERT INTO klv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Beti nǝvanuan galevis losǝhar atuhlahutai van hǝn aYesu hǝn b̃eriŋ navǝlan gǝlaru len galito ale sor tuṽ. Avil ahai susur gail losivoh len galito. ");
INSERT INTO klv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Be aYesu ike, “Mitidam̃ hǝn alahutai lǝb̃egǝm hǝn ginau; samteil gol galito! Husur natohan pipihabǝlan aGot len nǝmav evi silat lotosum̃an alategai.” ");
INSERT INTO klv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ale nǝboŋ aYesu toriŋ navǝlan gǝlaru len galito tonoŋ, eriŋ naut enan, ivan. ");
INSERT INTO klv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Len nǝboŋ sua, aulum̃an sua egǝm hǝn aYesu eusi ke, “Hai p̃usan, nigol natit tovoi sa hǝn nǝb̃ikad nǝmauran vi sutuai?” ");
INSERT INTO klv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","AYesu isor vari ke, “Imabe gotous ginau husur natit tovoi? Ikad Atesua ŋai tovoi. Be gǝb̃ike gǝb̃evi lan nǝmauran vi sutuai, gigol nǝsa nakelean todaŋ gail siGot tokele.” ");
INSERT INTO klv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ike, “Nakelean todaŋ gail ta be?” Ale aYesu ike, “Sagigol avan ideh timat, sagigol naitian tob̃ur kotov nǝlahan, sagevǝnah, sageliboŋ len nakotan, ");
INSERT INTO klv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","geputsan atǝmam̃ mai anam̃ len nǝnauan sam̃, ale lǝmas bun nǝvanuan totoh pǝpadaŋ hǝn gaiug sum̃an gotolǝmas bun gaiug gabag.” ");
INSERT INTO klv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nǝmantuhmar ikel maii ke, “Nugol natgalen p̃isi tia. Nǝsa ipat sal hǝn nǝb̃igole?” ");
INSERT INTO klv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","AYesu ikel maii ke, “Gǝb̃ike gǝb̃inor kavkav len nǝhon aGot, gia p̃ur hǝn natit p̃isi sam̃, ale viol hǝn nǝvat han mai namǝsal gail. Ale dereh gikad nakonviolan aGot totǝgau gati m̃os gaiug len nǝmav. Beti gegǝm husur ginau.” ");
INSERT INTO klv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nǝboŋ nǝmantuhmar tosǝsǝloŋ hǝn natenan, ivan, elǝŋon isa habat husur epul hǝn natite, ikad nasugsugur isob̃ur. ");
INSERT INTO klv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ale aYesu isor mai ahai susur san gail, ike, “Nukel nakitinan mai gamit ke, idaŋ habat hǝn avan ideh topul hǝn natite b̃eb̃is len natohan pipihabǝlan aGot len nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ikele am ke, “Idaŋ habat hǝn nǝkamel b̃eb̃is tur len nab̃urhunil sǝsod. Idaŋ sǝhori am hǝn nǝvanuan topul hǝn natite b̃eb̃is len natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nǝboŋ lotosǝsǝloŋ hǝni, ahai susur gail lup̃aŋ habat, luke, “B̃imaienan, as teb̃is lan? Sǝkad avan ideh b̃ikad nǝmauran vi sutuai!” ");
INSERT INTO klv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Beti aYesu ekǝta bunus galito ike, “Len nǝvanuan gail, galit lodǝdas lǝb̃igol natenan, avil aGot elǝboi b̃igol natit p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ale aPita isor vari ke, “Geris, ginamit namtoriŋ natit p̃isi hǝn namttohusur gaiug. Dereh tikad nǝsa sinamito?” ");
INSERT INTO klv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Beti aYesu ikel mai galit ke, “Nukel nakitinan mai gamito ke, len nǝboŋ navile a pan b̃iveveu, nǝboŋ aNatun Nǝvanuan b̃ebǝtah len nab̃iltihai bǝtbǝtah san toyalyal hum akiŋ, gamit am mǝttohusur ginau, dereh mǝtebǝtah len nab̃iltihai bǝtbǝtah gail lotovi 12 hǝn mǝtb̃epǝpehun navoian dan nǝsaan len nahǝmar lotovi 12 seIsrael. ");
INSERT INTO klv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ale avan ideh toriŋ naim gail o aṽan gail o aṽavinen gail o atǝman o anan o anatun gail o nǝtan m̃os nahǝsagw, dereh aGot teviol hǝn vǝha-100 maii, ale aGot teviol am hǝn nǝmauran vi sutuai maii. ");
INSERT INTO klv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ale nab̃iltivanuan isob̃ur gagai, asike lovi natideh; ale isob̃ur lǝsavi natideh gagai, dereh legǝm vi b̃iltivanuan.” ");
INSERT INTO klv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","AYesu ep̃usan am ke, “Natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad amahean nǝtan tovivile dudulan som̃ilan hǝn b̃idas lalum̃an m̃os nauman hǝn nǝhol nakrep san. ");
INSERT INTO klv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Lous nǝvat ale idam̃ hǝn b̃eṽur galit hǝn natenarius hǝn nǝmariboŋ tesua. Ale esǝvat galit van hǝn nǝhol nakrep san. ");
INSERT INTO klv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Len namityal tomǝlapat dudulan evivile tǝtas, ale eris alalum̃an lotoil kǝmas len nǝmaket. ");
INSERT INTO klv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ale ikel mai galit ke, ‘Gamito am, mitivan vaum len nǝhol nakrep sagw, ale dereh neṽur gamito tinor.’ ");
INSERT INTO klv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ale luvan. Len natub̃lial mai len namityal totor ut mǝdau, len naṽide tomaienan, amahean idas lalum̃an tǝtas. ");
INSERT INTO klv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Len namityal torim ut mǝdau, evivile, eris galevis am lotoil ei, ale ikel mai galit ke, ‘Imabe mǝtoil kǝmas gegai len nǝmariboŋ kavkav?’ ");
INSERT INTO klv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ris lotoke, ‘Ao, avan ideh saus ginamit hǝn namtb̃eum.’ Ŋa ikel mai galit ke, ‘Gamit am mǝtevi lan nǝhol nakrep sagw.’ ");
INSERT INTO klv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nǝboŋ naut togomgom ut mǝdau, amahean nǝhol ikel mai ab̃iltivanuan nauman san ke, ‘Kis alalum̃an nauman gǝmai ale ṽur galito, tub̃at len alat lotoyar a tahw van vǝbar alat lotoil a m̃o.’ ");
INSERT INTO klv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ale nǝboŋ alat lototub̃at len namityal torim ut mǝdau lotogǝmai, eṽur galit ṽisusua hǝn natenarius tosua. ");
INSERT INTO klv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ale nǝboŋ tobar alat lotoil a m̃o, lunau ke lǝb̃ikad nǝvat b̃esǝhor galit lotogǝm a tahw. Be eṽur galit ṽisusua hǝn natenarius tosua ŋai. ");
INSERT INTO klv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nǝboŋ lotolav natenarius tosua, lukoblen mai amahean nǝtan husur lǝsahǝhaṽur hǝn nǝvat, ");
INSERT INTO klv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","luke, ‘Alategai lotomadhagǝmai, loum husur nǝhaua tosua ŋai, be gaiug, goṽur galito p̃itoṽ hǝn ginamito. Be ginamito, namttodaŋ b̃ur nab̃iltiuman mai nǝyal tosun ginamito husur nǝmariboŋ kavkav!’ ");
INSERT INTO klv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ris tosor var galit sua ke, ‘Ginau nǝsamǝdas gaiug. Gaiug gudam̃ mai ginau hǝn natenarius tosua hǝn nauman. Ale gagai gumabe? ");
INSERT INTO klv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lav nǝvat tovi esam̃, givan. Nuke neviol mai ategai toyar a tahw, hum notoviol mai gaiug. ");
INSERT INTO klv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gunau ke sanor hǝn nǝb̃igol nǝsa notolǝŋoni hǝn natit sagw gail a? Nǝlom̃ itab̃ulol bulos ginau husur noviol habat a?’” ");
INSERT INTO klv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","AYesu imaris kotovi ke, “Imagenan, alat lǝsavi natideh gagai, dereh legǝm vi b̃iltivanuan, leil a m̃o; ale alat lototibau, lotoil a m̃o, dereh asike lovi natideh.” ");
INSERT INTO klv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Husur nǝboŋ enan, aYesu evi mǝhat vi Jerusalem. Len nǝyaran san van, esǝhar ahai susur lotovi 12 hǝn b̃isor mai galit sǝb̃olito, ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mǝtesǝsǝloŋ! Datevi mǝhat vi Jerusalem. Ale dereh leriŋ aNatun Nǝvanuan len navǝlan ab̃iltihai tutumav mai ahai p̃usan gail hǝn nalo. Ale len nakotan salito dereh lisab̃ sǝhoti ke tipanis, timat. ");
INSERT INTO klv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dereh leriŋi len navǝlan alat lǝsavi Ju hǝn lǝb̃isor vilesi, bilas habat hǝni, ale p̃os gati len nǝhai balbal. Be len nǝmariboŋ titor dereh aGot tigol tile mǝhat.” ");
INSERT INTO klv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Beti anana sinatun aSepeti gail esǝhar anatun ulum̃an gǝlaru gǝm hǝn aYesu, etǝŋedur bathurien hǝn b̃eus natsua hǝni. ");
INSERT INTO klv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","AYesu eusi ke, “Golǝŋon nǝsa?” Isor vari ke, “Nuke gikel gati ke nǝboŋ gǝb̃evi Kiŋ, alarmiṽan egai sagw arebǝtah tǝban gaiug, sua len nǝmatu, sua len nǝmair.” ");
INSERT INTO klv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","AYesu ekǝta ris gǝlaru ike, “Mǝrsalǝboi nǝsa mǝrtousi. Mǝrolǝboi mǝrb̃emun len nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an ginau nǝb̃emun lan a?” Arukel maii ke, “Namrolǝboi namrb̃igole.” ");
INSERT INTO klv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ale ikel mai gǝlaru ke, “Dereh mǝremun len nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an sagw. Avil nabǝtahan len nǝmatu o nǝmair sagw, sǝpat len ginau hǝn nǝb̃idam̃ hǝni. Ipat len aTǝmagw hǝn b̃idam̃ hǝn ase arb̃ebǝtah ei, husur gai eutaut hǝn naut eru m̃os gǝlaru.” ");
INSERT INTO klv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nǝboŋ ahai susur tosǝŋavur am lotosǝsǝloŋ hǝn natgalenan, nǝlolit epǝŋas alarmiṽan. ");
INSERT INTO klv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Be aYesu ekis galit p̃isi gǝmai, ike, “Mǝtolǝboii ke nǝgavna hǝn nametb̃os gail lupatpat galit mǝhat len nǝdaŋan lotokade tǝban nǝvanuan salit gail, ale len nǝdaŋan hǝn na-il-a-m̃o-an, nǝvanuan totibau salito loil a m̃o hǝn nǝvanuan salit gail. ");
INSERT INTO klv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Samtimagenan! Be gamit ideh toke tevi vanuan totibau, gai timasgǝm vi vanuan na-vi-tarhǝte-an samito, nǝlon tomǝdau hum tovi ut kǝmas ŋai. ");
INSERT INTO klv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ale gamit ideh toke teil a m̃o hǝn gamito, gai tegǝm vi slev samit m̃au. ");
INSERT INTO klv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tesum̃an ŋai aNatun Nǝvanuan. Gai sagǝm hǝn nǝvanuan gail hǝn lǝb̃evi tarhǝt san hum galit lotovi ut kǝmas. Ao, egǝm hǝn b̃evi tarhǝt salito hum gai tovi ut kǝmas; egǝm hǝn b̃evi na-p̃ur-kuvi-an m̃os navivilean hǝn nǝvanuan tosob̃ur dan nǝpanismen sil nǝsaan salito.” ");
INSERT INTO klv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Len nǝyaran siYesu galito, luyar tur len naut a Jeriko. Ale nǝboŋ lotoriŋ naut enan, nab̃iltiluṽoh lohusur aYesu. ");
INSERT INTO klv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ikad nametb̃esw eru artobǝtah len nǝgarhǝp̃isal, ale nǝboŋ artosǝsǝloŋ hǝni ke aYesu toṽot van, arukai ke, “Nasub̃, aNatun siTevit, gilolosa hǝn ginamǝru!” ");
INSERT INTO klv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naluṽoh losivoh len gǝlaru hǝn naut b̃eb̃ut hǝn gǝlaru. Be lukai habat am ke, “Nasub̃, aNatun siTevit, gilolosa hǝn ginamǝru!” ");
INSERT INTO klv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ale aYesu eil, ikai van hǝn gǝlaru ke, “Mǝrolǝŋon ke nigol nǝsa hǝn gamǝru?” ");
INSERT INTO klv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Arusor vari ke, “Nasub̃, namrolǝŋon nakǝtaan!” ");
INSERT INTO klv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ale nǝlon aYesu itaŋis gǝlaru, ibar namǝtalaru. Vǝha-sua ŋai arokǝta tǝtas, beti arohusuri. ");
INSERT INTO klv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nǝboŋ lotogǝm pǝpadaŋ hǝn naut a Jerusalem, lubar navile a Petfas tarhǝṽehuh Oliv. Beti aYesu esǝvat ahai susur eru van. ");
INSERT INTO klv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ikel mai gǝlaru ke, “Mǝrevi lan navile ea, ale vǝha-sua ŋai dereh mǝreris natoŋki sua lotobaŋisi ei mai natuhtoŋki ulum̃an san. Sah rub̃at gǝlaru, sehar gǝlar gǝmai. ");
INSERT INTO klv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ale avan ideh b̃ikel natideh mai gamǝru, mirikele ŋai ke, ‘Nasub̃ timaskad gǝlaru.’ Ale vǝha-sua ŋai dereh atenan tidam̃ hǝn gǝlaru.” ");
INSERT INTO klv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Natenan evisi hǝn nasoruan sihai kelkel ur b̃isarpoh. Ike, ");
INSERT INTO klv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kel mai anatvavin aSion ke, ‘Geris! AKiŋ sam̃ egǝm hǝn gaiug, nǝlon emǝdau, ebǝtah len natoŋki, natuhtoŋki ulum̃an tovi anatun natoŋki sua.’” ");
INSERT INTO klv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŋa ahai susur eru aruvan, arugol ŋai nǝsa aYesu tokel mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Arosǝhar natoŋki mai natuhtoŋki gǝmai, ale aroriŋ nahurabat naut susus gail len gǝlaru hǝn aYesu b̃ebǝtah len gail. ");
INSERT INTO klv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nab̃iltiluṽoh luṽolsan nahurabat salit gail metp̃isal. Galevis am lutai nǝpashǝhai dan nǝhai gail, lobubulan gail husur nametp̃isal. ");
INSERT INTO klv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Alat lotoyar a m̃o hǝn aYesu mai alat lotohusuri lukai ke, “Hosanna van hǝn aNatun ulum̃an siTevit! Putsani! AGot ivoi hǝn atenan togǝm len nahǝsan Nasub̃! Hosanna! Sal suh aGot len nǝmav a mǝhat buni!” ");
INSERT INTO klv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nǝboŋ aYesu tob̃is len naut a Jerusalem, navile kavkav luwal taṽtaṽor, lunau tuhatuh, luke, “Ategai ase?” ");
INSERT INTO klv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Naluṽoh luke, “Ahai kelkel ur bogai, aYesu ta Nasaret len naut a Kalili!” ");
INSERT INTO klv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Beti aYesu eb̃is len naholǝvat todar vis naim siGot ale ehut alat lotop̃ur hǝn natit gail mai alat lotoṽur natit gail ei. Ikovsan natev gail silat lotogǝgel hǝn nǝvat mai nǝhai bǝtbǝtah silat lotop̃ur hǝn nǝtav gail. ");
INSERT INTO klv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ale ikel mai galit ke, “Natosian siGot ike, ‘Naim sagw, dereh lekisi hǝn naim hǝn na-sor-tuṽ-an,’ be mǝtugol tovi naut susuah sinǝvanuan vǝnvǝnah gail.” ");
INSERT INTO klv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nametb̃esw gail mai alat lotogau logǝm hǝni len naholǝvat todar vis naim siGot, ale igol galit lumaur. ");
INSERT INTO klv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ab̃iltihai tutumav mai ahai p̃usan gail hǝn nalo nǝlolit ipaŋpaŋ nǝboŋ lotoris natit gail aYesu togole nǝvanuan p̃isi lotomaŋmaŋ lan, mai nǝboŋ lotosǝsǝloŋ hǝn atuhlahutai lotokai len naholǝvat todar vis naim siGot ke, “Hosanna van hǝn aNatun ulum̃an siTevit! Putsani!” ");
INSERT INTO klv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ŋa lous aYesu ke, “Gosǝsǝloŋ hǝn nǝsa alategai lotokele a?” Ale aYesu ikel mai galit ke, “Evoi, be mǝtsaṽuruŋ natosian siGot boŋ ideh toke, ‘Gaiug Got goutaut hǝn nǝ-sal-suhi-an m̃os gaiug gabag len nabuŋon atuhlahutai mai len nabuŋon atuhtǝtai gail lotosus sal a?’” ");
INSERT INTO klv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Beti eriŋ galito, evivile dan nab̃iltivile, evi Petani ale itoh ei len nalenmariug. ");
INSERT INTO klv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dudulan som̃ilan, nǝboŋ aYesu totǝlmam vi lan nab̃iltivile, imalkǝkat. ");
INSERT INTO klv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Len nǝyaran san eris nǝhai nafik sua, ale ia das ṽite sob̃uer husur nǝhai ibaŋ lute ŋai. Ale aYesu isor lan, ike, “Sagiṽan am vi sutuai!” Vǝha-sua ŋai nǝhai nafik enan emǝlaŋ. ");
INSERT INTO klv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nǝboŋ ahai susur gail lotoris natenan, lumaŋmaŋ. Luke, “Nǝhai nafik egai emǝlaŋ tutut maiegai mabe?” ");
INSERT INTO klv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","AYesu isor var galit ke, “Nokitin mai gamit ke, mǝtb̃ikad nadǝlomian, nǝ-lon-uri-an b̃eb̃uer, nǝsa tovisi hǝn nǝhai nafik, dereh mitigole. Be savi natenan ŋai, mǝtelǝboi mǝtb̃ikel mai naṽehuh egai ke, ‘Makuv, bar hǝn gaiug len tas,’ ale dereh tevisi. ");
INSERT INTO klv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ale mǝtb̃ikad nadǝlomian, natit p̃isi mǝtb̃eusi len na-sor-tuṽ-an, natideh mǝtb̃eusi, dereh mitikade.” ");
INSERT INTO klv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","AYesu ibar naholǝvat todar vis naim siGot, eb̃is lan, ale nǝboŋ top̃usan ei, ab̃iltihai tutumav mai alat lotoil a m̃o hǝn nǝvanuan gail logǝm hǝni, lous taltal hǝni ke, “Gugol natgalenan len nǝdaŋan na-il-a-m̃o-an ta be? Len nǝdaŋan sise? Ase ilav nǝdaŋan na-il-a-m̃o-an enan mai gaiug?” ");
INSERT INTO klv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","AYesu isor var galit ke, “Nuke neus nausian sua hǝn gamit bai. Mǝtb̃isor var nausian sagw, dereh nikel ur nǝdaŋan na-il-a-m̃o-an notogol natgalenan lan mai gamito. ");
INSERT INTO klv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nausian imaiegai, ke, nǝkadhut na-il-a-m̃o-an aJon tokade hǝn tobaptais, egǝm len nǝmav o len nǝvanuan?” Lusor kitevi len galit gabag, luke, “Datb̃ike, ‘Egǝm len nǝmav,’ dereh tike, ‘Imabe mǝtsadǝlom aJon?’ ");
INSERT INTO klv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Avil datb̃ike, ‘Egǝm len nǝvanuan,’ datomǝtahw len naluṽoh husur galit p̃isi lunau ke aJon evi ahai kelkel ur.” ");
INSERT INTO klv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ŋa lusor var aYesu ke, “Namtsalǝboii.” Ale ikel mai galit ke, “B̃imaienan, ginau am, asike nukel mai gamito, nǝdaŋan na-il-a-m̃o-an notogol natgalenan lan.” ");
INSERT INTO klv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","AYesu isor am, ike, “Mǝtunau ke nǝsa? Naulum̃an sua ikad anatun ulum̃an eru, ale ivan hǝn gǝlar sua ike, ‘Anatugw, damǝŋai gia um len nǝhol nakrep.’ ");
INSERT INTO klv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anatun isor vari ke, ‘Ao, nomǝtahuni.’ Avil nǝboŋ namityal topair, egǝgel hǝn nǝnauan san, ivan. ");
INSERT INTO klv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Beti atata ivan hǝn anatun togon am ikel nasoruan top̃itoṽ hǝn tokele a m̃o tia. Ale anatun togon isor vari ke, ‘Ale Nasub̃, nivan bai.’ Wake sǝvan. ");
INSERT INTO klv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Len gǝlaru, anatun ulum̃an ta be igol nǝsa atata sǝlaru tolǝŋoni?” Lusor var aYesu, luke, “Anatun atata tosor maii a m̃o.” Ale aYesu ikel mai galit ke, “Nukel nakitinan mai gamito. Nǝvanuan nǝtaks gail mai alatpǝhaṽut lotop̃ur hǝn nibelito saltoyar a m̃o hǝn gamito vi lan natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Husur aJon egǝm hǝn gamito hǝn b̃eṽusan gamit hǝn nap̃isal hǝn nanoran, be mǝtsadǝlomi, avil nǝvanuan nǝtaks gail mai alatpǝhaṽut lotop̃ur hǝn nibelito, lodǝlomi. Naut kǝmas mǝtoris natenan, len namityal tohusuri, mǝtsagǝgel hǝn nǝnauan samito hǝn mǝtb̃edǝlom nǝsa tokele.” ");
INSERT INTO klv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","AYesu ike, “Sǝsǝloŋ hǝn nǝb̃ol p̃usan sual am. Ikad naulum̃an tokad nǝtan. Len naut enan imabul nakrep, eum hǝn nǝhol garu len nǝtan enan. Ehir nab̃ur hǝn b̃egǝm vi naut lotopal dasdas nakrep lan, ale eum hǝn naut na-kǝtkǝta-tǝban-an a mǝhat. Beti idam̃ hǝn nǝhol van hǝn alat lotokǝtkǝta tǝban nǝhol hǝn lǝb̃irentem, ale eriŋ naut enan len nǝyaran sua. ");
INSERT INTO klv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nǝboŋ nakrep pǝpadaŋ hǝn b̃imen, amahean nǝhol esǝvat naslev san gail van hǝn alat lotorentem nǝhol hǝn lǝb̃epǝpehun naṽit nakrep galevis tovi esan. ");
INSERT INTO klv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Avil alat lotorentem nǝhol lutah gat naslev san gail. Luṽas esua, lugol esua imat ale lotuṽ sual am. ");
INSERT INTO klv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ale amahean esǝvat naslev galevis am sǝhor ta m̃o, be alat lotorentem nǝhol lugol naṽide top̃itoṽ hum ta m̃o. ");
INSERT INTO klv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Len namǝkot esǝvat anatun ulum̃an van hǝn galito, isor mai gai gabag ke ‘Dereh leputsan anatugw ulum̃an len nǝnauan salito, ligol nǝsa b̃ikele.’ ");
INSERT INTO klv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Be nǝboŋ alat lotorentem nǝhol lotoris anatun ulum̃an, lusor mai galit gabag ke, ‘Atea, dereh tikad nǝhol egai nǝboŋ amahean nǝtan b̃imat. Gǝmai, datiparu buni hǝn datb̃ikad natit p̃isi b̃evi esan nǝboŋ atǝman b̃imat.’ ");
INSERT INTO klv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ale lutah gati, bar hǝni vivile dan nǝhol nakrep ale paru buni. ");
INSERT INTO klv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Imaienan, nǝboŋ amahean nǝhol nakrep b̃egǝmai, dereh tigol nǝsa hǝn alatenan lotorentem nǝhol?” ");
INSERT INTO klv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lusor var aYesu ke, “Nǝvanuan galen lotosa, dereh tilav nǝmatan tosa vǝsa masuṽ mai galito. Beti tidam̃ hǝn nǝvanuan galevis am lǝb̃irentem nǝhol, lǝb̃ilav naṽit nakrep maii nǝboŋ lǝb̃imen.” ");
INSERT INTO klv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","AYesu ikel mai galit ke, “Mǝtsaṽuruŋ nategai len natosian siGot a? Ike, “‘Nǝvat, nǝvanuan na-um-im-an gail lotomǝtahuni, gai egǝm vi vat sua ŋai b̃elǝboi b̃igol naim b̃ihav mai b̃inor. Ale evi Nasub̃ aGot togol nǝvat tomagenan ale nǝboŋ dattorisi, datumaŋmaŋ len nǝsa togole.’ ");
INSERT INTO klv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Bathut enan nukel mai gamit ke, dereh aGot tilav kuv natohan pipihabǝlan dan gamito, ale tilavi mai naluṽoh hǝn nǝvanuan tile lǝb̃igol naṽite tovi nalǝŋonian san. ");
INSERT INTO klv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Avan ideh b̃iteh len nǝvat enan, dereh timab̃urb̃ur, mai avan ideh, nǝvat b̃iteh lan, dereh tipat dole.” ");
INSERT INTO klv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nǝboŋ ab̃iltihai tutumav mai naFarisi gail lotosǝsǝloŋ hǝn nǝb̃ol galenan, lunau sǝhoti ke aYesu tosor husur galito. ");
INSERT INTO klv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imagenan ludas p̃isal hǝn lǝb̃itah gati, be lomǝtahw len naluṽoh gail lotonau ke tovi ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","AYesu ib̃ol p̃usan tǝtas mai galit am, ike, ");
INSERT INTO klv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Natohan pipihabǝlan aGot len nǝmav imaiegai. Ikad nakiŋ sua toutaut hǝn nǝhanan hǝn nǝlahan sinatun ulum̃an. ");
INSERT INTO klv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eus nǝvanuan isob̃ur hǝn lǝb̃egǝm hǝn nǝlahan enan. Ale nǝboŋ nǝhanian toutaut, esǝvat naslev san gail hǝn lǝb̃ekis nǝvanuan galenan gǝmai, be lomǝtahun lǝb̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Esǝvat naslev galevis am, ike, ‘Kel mai alat notous galit gǝmai ke numaul hǝn nǝhanian tia. Namtotibun nab̃uluk ulum̃an mai natuhb̃uluk tokǝnoh gail, ale natit p̃isi eutaut tia. Mǝtegǝm tutut hǝn nǝhanan nǝlahan!’ ");
INSERT INTO klv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Avil alat akiŋ tous galit lǝb̃egǝmai, lǝsasǝsǝloŋ husuri, luvan. Galit sua evi lan nǝtan san, togon evi lan naim p̃urp̃ur san. ");
INSERT INTO klv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Galevis am lutah gat naslev san gail, lomǝdas bun galito vagol lumat. ");
INSERT INTO klv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Akiŋ nǝlon ipaŋpaŋ masuṽ. Esǝvat navǝshǝsoltia san hǝn lǝb̃iṽabun alatenan lotogol nǝmatan ale hǝn lǝb̃epǝŋas nab̃iltivile salito. ");
INSERT INTO klv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ale ikel mai naslev san gail ke, ‘Nǝhanan hǝn nǝlahan eutaut tia, be alat notous galit hǝn lǝb̃egǝmai lǝsǝbar nǝsa notolǝŋoni tonor len nǝhanan sagw, sanor hǝn lǝb̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imaienan, mitivan hǝn nametp̃isal pasil gail, ale nǝvanuan ideh mǝtb̃isab̃i, usi hǝn b̃egǝm vi lan nǝhanan nǝlahan.’ ");
INSERT INTO klv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ale naslev galenan luvan husur nap̃isal gail. Lokis galit p̃isi lotosab̃ gail b̃onb̃on, naut kǝmas lotovoi o lotosa. Ale nǝhanan nǝlahan epul hǝn nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Be nǝboŋ akiŋ tob̃is lohoim san hǝn b̃eris alat lotohan, eris aulum̃an sual ei sasun nahurabat nǝlahan. ");
INSERT INTO klv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ale ikel maii ke, ‘Eee Tegai, gaiug gǝsasun nahurabat nǝlahan, gogǝm lohoim gegai mabe?’ Ris naut tob̃ut hǝn atenan. ");
INSERT INTO klv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Beti akiŋ ikel mai nǝvanuan nauman san gail ke, ‘Baŋis gat navǝlan gǝlaru mai narien gǝlaru, bar hǝni vivile len nǝmargobut! Len naut enan dereh litaŋ, lides batriṽoriṽ.’” ");
INSERT INTO klv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","AYesu imaris kotov nasoruan san ike, “Husur aGot ekis isob̃ur be ilekis hǝn evis ŋai.” ");
INSERT INTO klv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ale naFarisi gail luvan. Nǝboŋ lotovan tonoŋ, Lub̃onb̃on, lusor utaut hǝn lǝb̃igol aYesu b̃ekǝkos len nasoruan san. ");
INSERT INTO klv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Beti losǝvat ahai susur salit gail mai galevis len nǝpati tovi tarhǝt siHerot van hǝn aYesu. Lousi ke, “Hai p̃usan, namtolǝboii ke gokitin, gop̃usan hǝn nap̃isal siGot len nakitinan. Gukel nakitinan, nǝvanuan b̃etibau o b̃evi naut kǝmas savi natideh len gaiug. ");
INSERT INTO klv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gikel natsua mai ginamit bai. Inor hǝn datb̃eṽur nǝtaks van hǝn aSisa m̃au a? Gunau mab hǝni?” ");
INSERT INTO klv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Be aYesu elǝboi nagǝrasian tosa salito ale ike, “Vanuan gǝgǝras gail! Imabe mǝtous kitev ginau hum mǝtb̃igol ke nekǝkos? ");
INSERT INTO klv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ṽusan ginau hǝn natenarius hǝn nǝtaks.” Ale lulav nakoin sua enan van hǝni. ");
INSERT INTO klv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eus galit ke, “Nǝhon mai nahǝsan ase arupat len nakoin egai?” ");
INSERT INTO klv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lusor vari ke, “ASisa.” Beti ikel mai galit ke, “Imagenan, lav mai aSisa nǝsa tovi seSisa ale lav mai aGot nǝsa tovi siGot.” ");
INSERT INTO klv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nǝboŋ lotosǝsǝloŋ hǝn natenan, lup̃aŋ, beti loriŋi, luvan. ");
INSERT INTO klv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Len nǝboŋ enan ŋai, naSattiusi gail (lotokele ke na-le-mǝhat-an dan nǝmatan eb̃uer), logǝm hǝni, lousi ");
INSERT INTO klv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","luke, “Hai p̃usan, aMoses ikele ke, ‘Aulum̃an ideh b̃imat anatun b̃eb̃uer, aṽan matmat tilah mai nǝbatunau enan hǝn b̃ipas anatun gail hǝn aṽan tomat b̃ikad anatun gail.’ ");
INSERT INTO klv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ikad alatmiṽan tomǝlevru len ginamito. Ahai a m̃o ilah, ale imat, anatun eb̃uer. Ale aṽan tohusuri ilah mai asoan aten tomat. ");
INSERT INTO klv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aṽan enan am imat, anatun eb̃uer, ale aṽan tohusuri ilah mai nǝbatunau. Ivan magenan van vǝbar alatmiṽan p̃isi lulah mai alitenan. ");
INSERT INTO klv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ale nǝboŋ alatmiṽan p̃isi lotomat, alitenan tu imat. ");
INSERT INTO klv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Imagenan, kel mai ginamito, len na-le-mǝhat-an dan nǝmatan, alitenan dereh tevi asoan alatmiṽan tomǝlevru ta be, husur ilah mai galit p̃isi?” ");
INSERT INTO klv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","AYesu isor var galit ke, “Mǝtusab husur mǝtsalǝboi natosian siGot mai nǝdaŋan san. ");
INSERT INTO klv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Husur len na-le-mǝhat-an dan nǝmatan, nǝvanuan gail asike lulah, avan ideh asike idam̃ hǝn lǝb̃ilah, be dereh lesum̃an aŋel gail len nǝmav lǝsǝlah. ");
INSERT INTO klv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Be datb̃isor husur na-le-mǝhat-an dan nǝmatan, mǝtsaṽuruŋ nǝsa aGot tokele mai gamito a? Ike, ");
INSERT INTO klv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Gagai ginau novi aGot siApraham, aGot seIsak, aGot siJakop.’ Gai savi aGot silat lotomat be silat lotomaur.” ");
INSERT INTO klv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nǝboŋ naluṽoh gail lotosǝsǝloŋ hǝn natenan, lumaŋmaŋ len nap̃usanan san. ");
INSERT INTO klv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nǝboŋ lotosǝsǝloŋ hǝni ke aYesu togol naSattiusi gail lǝsasor am, naFarisi gail lub̃onb̃on, ");
INSERT INTO klv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ale galit sua tokad namitisau hǝn nalo eus nausian sua hǝni hǝn b̃ekǝkos len na-sor-vari-an san. ");
INSERT INTO klv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ike, “Hai p̃usan, len nalo gail, ta be esǝhor gail p̃isi am?” ");
INSERT INTO klv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","AYesu isor var galit ke, “‘Gelǝmas bun Nasub̃ aGot sam̃ len nǝlom̃ kavkav, nanunum̃ kavkav, mai nǝnauan sam̃ kavkav; len gaiug kavkav.’ ");
INSERT INTO klv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Enan evi nakelean todaŋ totibau, tosǝhor gail p̃isi am. ");
INSERT INTO klv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nakelean todaŋ tohusuri ehum enan, ike ‘Gelǝmas bun nǝvanuan totoh pǝpadaŋ hǝn gaiug sum̃an gotolǝmas bun gaiug gabag.’ ");
INSERT INTO klv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nakelean eru enan artodaŋ arovi nǝbathut nalo kavkav mai nap̃usanan sihai kelkel ur gail p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Beti aYesu eus naFarisi gail lotob̃onb̃on, ");
INSERT INTO klv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ike, “Mǝtb̃inau aKristo, aGot totabtabuh lan, mǝtunau ke gai evi anatun ase, nǝpasusan sise?” Lusor vari ke, “Anatun siTevit.” ");
INSERT INTO klv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Beti aYesu eus galit ke, “B̃imaienan, nǝboŋ aTevit tosor len aNunun aGot, bathut nǝsa ekis aKristo hǝn aMasta? Husur aTevit ike, ");
INSERT INTO klv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Nasub̃ aGot ikel mai aMasta sagw, ke “Gebǝtah tarhǝt len navǝlagw nǝmatu, vir nǝb̃eriŋ aenemi sam̃ gail pipit nariem̃ gǝlaru hǝn lǝb̃evi ut kǝmas.”’ ");
INSERT INTO klv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Imaienan, aTevit b̃ekis aKristo hǝn aMasta san, evi anatun mabe?” ");
INSERT INTO klv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Be sǝkad ideh tolǝboi b̃isor var aYesu. Len nǝboŋ enan van, galit p̃isi lomǝtahw hǝn lǝb̃eus nausian ideh hǝni am. ");
INSERT INTO klv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Beti aYesu isor mai naluṽoh gail mai ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ike, “Ahai p̃usan hǝn nalo mai naFarisi gail, lulav namilen aMoses hǝn lǝb̃ep̃usan hǝn nalo siGot. ");
INSERT INTO klv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Imaienan, sǝsǝloŋ husur galito, gol natideh lotokel mai gamito hǝn mǝtb̃igole. Avil samtigol tǝtoṽ hǝn nǝsa lotogole, husur lǝsagol nǝsa lotop̃usan hǝni. ");
INSERT INTO klv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lukai tas natit isob̃ur, lugol nalo isob̃ur am lotodaŋ habat hǝn nǝvanuan b̃ehusur gail. Ehum lotobaŋis gat natit tomǝlas habat, ale lotoriŋi len nǝbathuvǝson nǝvanuan hǝn b̃evusi. Be lomǝtahun lǝb̃igol natideh hǝn lǝb̃esusupah mai nǝvanuan hǝn b̃erusan natgalenan tomǝlas. ");
INSERT INTO klv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Natit p̃isi lotogole, lugole hǝn nǝvanuan gail lǝb̃erisi ŋai. Galit, lukad nabokis gail lotosǝŋon natosian siGot len gail hǝn lǝb̃ibaŋis gail len navǝlalit mai nabunǝholito. Be mǝteris, lugol nabokis gail lup̃osp̃os, lugol nasum̃arhǝt nahurabat salit gail lobǝlbǝlav. ");
INSERT INTO klv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lolǝŋon masuṽ hǝn lǝb̃ebǝtah rivuh len nab̃iltihanan ideh, lolǝŋon nǝhai bǝtbǝtah tovoi ŋai len naim nab̃onb̃onan. ");
INSERT INTO klv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lolǝŋon masuṽ hǝn nǝvanuan gail lǝb̃ike, ‘Ivoi,’ mai galito len nǝmaket, lolǝmas nǝvanuan lǝb̃ekis galit, ‘Hai p̃usan.’ ");
INSERT INTO klv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Be avan ideh satekis gamit hǝn ‘Hai p̃usan,’ husur mǝtukad ahai p̃usan tosua ŋai, ale gamit p̃isi mǝtop̃itp̃itoṽ sum̃an na-ke-ṽan-an gail. ");
INSERT INTO klv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ale samtinau avan ideh len navile a pan hum totibau gol ke mǝttokisi hǝn, ‘Tata,’ husur esua ŋai evi aTata samit len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Avan ideh satekis gamit hǝn ‘Hai p̃usan,’ husur esua ŋai evi ahai p̃usan samito, evi aKristo. ");
INSERT INTO klv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gamit ideh toke tetibau sǝhor gamit am, tekǝtkǝta tǝban gamito, tevi tarhǝt samito. ");
INSERT INTO klv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Avan ideh topatpat gai mǝhat, dereh tegǝm vi ut kǝmas; avan ideh togol gai savi natideh, dereh aGot teputsani vi mǝhat. ");
INSERT INTO klv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Be gamit mǝttovi ahai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail ŋai! Nǝmauran samit dereh tisa vǝsa tibatbat, husur mǝtokǝkol hǝn nabopita hǝn natohan pipihabǝlan aGot len nǝmav len nǝhon nǝvanuan gail. Bathut mǝtsab̃is lan ale alat lotoke lǝb̃eb̃is lan, mǝtsǝdam̃ hǝn ke leb̃is. ");
INSERT INTO klv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Gamit mǝttovi ahai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail ŋai! Nǝmauran samit dereh tisa vǝsa tibatbat. Husur len nǝyaran samito, mǝtuyar len tan, wol len tas, hǝn mǝtb̃egǝgel hǝn nadǝlomian sinǝvanuan b̃esua ŋai, hǝn b̃ikad nadǝlomian seJu gail. Ale nǝboŋ tohusur nadǝlomian samito, mǝtugol egǝm isa sǝhor gamito, gol ke inor hǝn nǝhab nǝmatan ŋai. ");
INSERT INTO klv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Gamit mǝttoil a m̃o, mǝttosǝhar nǝvanuan gail, mǝtovi metb̃esw gail, nǝmauran samit dereh tisa vǝsa tibatbat! Len nap̃usanan samit mǝtuke, ‘Avan ideh tota gat na-kel-gati-an san len nahǝsan naim siGot, nakelean san savi natideh. Be avan ideh tota gat na-kel-gati-an san len nahǝsan nagol hǝn naim siGot, gai timasgol nǝsa tokel gati, salǝboi b̃imakuv dani.’ ");
INSERT INTO klv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Metb̃esw gail! Melmel gail! Mǝtolǝboii ke naim siGot esǝhor masuṽ hǝn nagol topat lan. Nagol enan egǝm siGot sǝb̃on, husur ŋai topat len naim siGot. ");
INSERT INTO klv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ale len nap̃usanan samit mǝtuke, ‘Avan ideh tota gat na-kel-gati-an san len nahǝsan nǝmel tutumavan, nakelean san savi natideh. Be avan ideh tota gat na-kel-gati-an san len nahǝsan naviolan topat len nǝmel tutumavan, gai timasgol nǝsa tokel gati, salǝboi b̃imakuv dani.’ ");
INSERT INTO klv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Metb̃esw gail! Mǝtolǝboii ke nǝmel tutumavan esǝhor masuṽ hǝn naviolan ideh topat lan. Naviolan enan egǝm siGot sǝb̃on husur ŋai topat len nǝmel tutumavan len natutumavan van hǝn aGot. ");
INSERT INTO klv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Imaienan, avan ideh tota gat na-kel-gati-an san len nahǝsan nǝmel tutumavan, gai ita gat na-kel-gati-an san len nǝhes enan, mai len nahǝsan natideh topat lan. ");
INSERT INTO klv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ale avan ideh tota gat na-kel-gati-an san len nahǝsan naim siGot, gai ita gat na-kel-gati-an san len nǝhes enan, mai len nahǝsan atenan totoh lan. ");
INSERT INTO klv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ale avan ideh tota gat na-kel-gati-an san len nahǝsan nǝmav, gai ita gat na-kel-gati-an san len nahǝsan nab̃iltihai bǝtbǝtah siGot, mai len nahǝsan atenan tobǝtah lan. ");
INSERT INTO klv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gamit mǝttovi ahai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail! Nǝmauran samit dereh tisa vǝsa tibatbat, husur nahudhut tosua len nasǝŋavuran hǝn naluhai hun namint, natil mai nakumin, mǝtoviol hǝn gail mai aGot. Avil mǝtsagol natit totibau gail sǝhor natgalenan len nalo. Mǝtsagol sanor van hǝn nǝvanuan gail, mǝtsalolosa hǝn galito. Mǝtsariŋ nǝlomit len aGot, mǝtsǝdaŋ lan. Ivoi hǝn mǝttagol natgalenan ale sa-nǝlomit tiboŋboŋ hǝn mǝtb̃eviol hǝn tesua len nasǝŋavuran. ");
INSERT INTO klv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gamit mǝttoil a m̃o, mǝttosǝhar nǝvanuan gail, mǝtovi metb̃esw gail! Mǝtohisi hǝn mǝtb̃ehusur natuhlo p̃isi, be mǝtsagol nab̃iltitit gail lotopat lan. Ehum mǝttob̃ir nǝwai tur len nǝkaliko hǝn asike mǝtb̃edǝlom nahonon ideh, be mǝtodǝlom nǝkamel mǝtsarisi. ");
INSERT INTO klv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Gamit mǝttovi hai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail! Nǝmauran samit dereh tisa vǝsa tibatbat, husur mǝtokǝkas navivile hǝn nab̃iliwai mai nasiloh, be nǝlolit eb̃iŋb̃iŋal. Nǝlomit epul hǝn na-lǝŋon-masuṽ-hǝn-natite-an mai nagolean hǝn natideh mǝttolǝŋoni. Mǝtsǝnau nǝvanuan ideh am. ");
INSERT INTO klv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi namǝtamit tob̃esw! Kǝkas nǝlon nab̃iliwai a m̃o, hǝn navivile am b̃iveveu. ");
INSERT INTO klv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Gamit mǝttovi hai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail! Nǝmauran samit dereh tisa vǝsa tibatbat, husur mǝtohum nab̃urhes lotopiti pǝhapǝhw. Navivile epǝhw, ikab buni, be butite epul hǝn nabǝlasun nǝvanuan tomat gail mai natit gail am tob̃os nǝtan. ");
INSERT INTO klv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gamit mǝtumaienan. Nǝvanuan gail lotoris navivile samito lunau ke mǝtunor, avil len nǝlomito, mǝtopul hǝn nagǝgǝrasan, mǝtutoh hum nalo savi natideh. ");
INSERT INTO klv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Gamit mǝttovi hai p̃usan hǝn nalo mai naFarisi gail, mǝtovi vanuan gǝgǝras gail! Nǝmauran samit dereh tisa vǝsa tibatbat, husur mǝtoum hǝn nab̃urhes sihai kelkel ur gail, atǝmamit gail ta sutuai lotoparu bubun galito, ale mǝtovǝhas nab̃urhes silat lotonor len nǝhon aGot. ");
INSERT INTO klv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Beti, sum̃an mǝttavoi sǝhor atǝmamit gail ta sutuai, mǝtuke, ‘Dattatoh len nǝboŋ setǝmadat ta sutuai, asike dattab̃on mai galito nǝboŋ lotogol nǝda hihai kelkel ur gail lotosel.’ ");
INSERT INTO klv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nǝboŋ mǝttokǝmaienan, mǝtukel koti ke mǝttovi anatulit gail, mǝttosa sum̃an alat lotoparu bubun ahai kelkel ur gail. ");
INSERT INTO klv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gamit m̃au, nǝsa atǝmamit gail ta sutuai lototub̃at hǝni, mitigol tihav! ");
INSERT INTO klv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mǝtovi m̃at gail mai anatun nǝvaipa gail! Mitigam yav dan nǝpanismen hǝn naut nǝmatan mabe? ");
INSERT INTO klv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Husur natenan, dereh nesǝvat ahai kelkel ur gail, nǝvanuan lotokad namitisau hǝn nǝmauran tonor, mai ahai p̃usan gail hǝn nalo, van hǝn gamito. Dereh mititahǝtah hǝn galevis len nǝhai balbal hǝn lǝb̃imat. Galevis am mǝtebilas habat hǝn galito len naim nab̃onb̃onan samito, hut galit van husur nab̃iltivile ṽisusua. ");
INSERT INTO klv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ŋa nǝmatan silat lotonor p̃isi len navile a pan, dereh lipat len navǝlamito; tub̃at len nǝda hiApel tonor, van vǝbar nǝda hiSekariah, anatun ulum̃an aParakiah, mǝttotubuni rivuh hǝn nǝmel tutumavan mai naim siGot. ");
INSERT INTO klv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nukel nakitinan mai gamito, nǝpanismen hǝn nǝmatan galen p̃isi, dereh tibar naur ta damǝŋ egai. ");
INSERT INTO klv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem! Gugol ahai kelkel ur gail lumat, gotubun ahai pispisul gail aGot tosǝvat galit van hǝn gaiug. Akis nuke nigol anatum̃ gail lib̃onb̃on hum natopǝhaṽut togol natuhman san gail lub̃onb̃on hǝn b̃ihavhav hǝn galito. Be gomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Geris! AGot eriŋ gab̃ulan naim sam̃ gol eb̃ǝb̃esw. ");
INSERT INTO klv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Husur nukel mai gamit ke, gagai van, asike mǝtoris ginau am van vǝbar mǝtb̃ike, ‘AGot tivoi hǝn atenan togǝm len nahǝsan Nasub̃ aGot!’” ");
INSERT INTO klv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nǝboŋ aYesu toriŋ naholǝvat todar vis naim siGot, toyar dani, ahai susur san gail logǝm hǝni hǝn lǝb̃eṽusani hǝn naim gail ei. ");
INSERT INTO klv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Be aYesu ikel mai galit ke, “Mǝtoris naim galeg a? Nokitin mai gamit ke dereh limasirsir p̃isi hǝn asike ikad nǝvat ideh gegai b̃epǝlah len nǝvat togon.” ");
INSERT INTO klv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Beti nǝboŋ aYesu tobǝtah sǝb̃on len Naṽehuh Oliv, ahai susur san gail logǝm hǝni luke, “Natgalen gotomadhakele mai ginamito levisi ŋais? Nǝsa teṽusan nagǝmaian sam̃? Nǝsa teṽusan nǝboŋ navile a pan b̃inoŋ?” ");
INSERT INTO klv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","AYesu isor var galit ke, “Mǝtelǝlǝgau! Avan ideh sategǝras gamito, ");
INSERT INTO klv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","husur dereh tisob̃ur legǝm len nahǝsagw, like, ‘Ginau aKristo,’ ale dereh legǝras tisob̃ur nǝboŋ lǝb̃ekǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dereh mǝtesǝsǝloŋ hǝn nǝwalan hǝn nab̃iltib̃alan gail mai na-kel-uri-an hǝn nab̃iltib̃alan gail am. Be samtemǝtahw, husur timasvisi magenan, be sǝbar nagilen sal. ");
INSERT INTO klv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Naluṽoh hǝn nǝvanuan naut sua dereh ligol nab̃iltib̃alan mai naluṽoh hǝn nǝvanuan naut tile, ale nǝvanuan sekiŋ gail dereh lib̃al mai nǝvanuan sekiŋ tile gail. Dereh nǝhanian teb̃uer mai tikad nab̃iltidu gail husur naut gail. ");
INSERT INTO klv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Be natgalen p̃isi lohum natub̃atan ŋai hǝn napǝŋasan hǝn nǝpasusan. Dereh lisa van vǝsa, levisi vǝha-sob̃sob̃ur am len nǝboŋ lǝb̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Beti dereh leriŋ gamit len navǝlan alat lǝb̃emǝdas tabtab hǝn gamito mai lǝb̃igol mǝtb̃imat. Naluṽoh hǝn nǝvanuan naut tiltile dereh lemǝtahun bun gamito sil nahǝsagw. ");
INSERT INTO klv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ale len nǝboŋ enan tisob̃ur dereh lipair dan ginau, lemǝtahun bun galit gabag, leriŋ galit gabag len navǝlan aenemi salit gail. ");
INSERT INTO klv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ale ahai kelkel ur gǝgǝras gail dereh levisi, legǝras nǝvanuan tisob̃ur. ");
INSERT INTO klv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ale husur nǝsaan b̃iperŋan naut p̃isi, na-lǝmlǝmas-buni-an sinǝvanuan b̃isob̃ur dereh tegǝm kǝkereh. ");
INSERT INTO klv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Avil nǝvanuan tokad nǝ-daŋ-b̃uri-an van vǝbar nagilen, gai dereh aGot tilav kuvi hǝn b̃ikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ale nǝvanuan sagw gail dereh likel ur na-kel-uri-an tovoi egai hǝn natohan pipihabǝlan aGot, len navile a pan kavkav, hǝn ke, naluṽoh hǝn nǝvanuan naut tiltile p̃isi lǝb̃esǝsǝloŋ hǝni bai, beti nagilen navile a pan tegǝmai.” ");
INSERT INTO klv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gaiug gotoṽuruŋ nategai, geṽuruŋ lǝboii. AYesu isor am ke, “Imagenan, nǝboŋ mǝtb̃eris nǝsa ahai kelkel ur, aTaniel, totos husuri a m̃o, nǝboŋ mǝtb̃eris natit aGot tomǝtahun buni, toil len naut tolo, tomǝdas bun naut enan van vagol tob̃ǝb̃esw vi sutuai, ");
INSERT INTO klv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","len nǝboŋ enan, alat a Jutea limasgam dan naut enan vi lan naut tobaŋ ṽehuh. ");
INSERT INTO klv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Avan ideh b̃iŋavŋav mǝhat len navurun naim, timasgam tutut dan naim san, satimariŋ vi lohoim hǝn b̃itariv kukuv natite dani. ");
INSERT INTO klv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ale ideh b̃eum marireu san, satetǝlmam hǝn b̃ilav nahurabat san. ");
INSERT INTO klv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Len nǝboŋ enan nǝmauran dereh tidaŋ vǝsa habat hǝn apǝhaṽut ideh totian o tovǝhasus. ");
INSERT INTO klv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Be mitisor tuṽ vi tǝban aGot ke nǝ-gam-yav-an samit satipat len nahǝbati naut susus o len nǝSappat ideh. ");
INSERT INTO klv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nokǝmaienan husur len nǝboŋ natgalen b̃evisi, na-lǝŋon-isa-vǝsa-an dereh tidaŋ habat sǝhor nǝboŋ ta sutuai len natub̃atan, vǝbar nǝboŋ ta damǝŋai, ale asike idaŋ sǝhori tǝtas am boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Asike aGot tagol na-lǝŋon-isa-vǝsa-an tam̃idol len nǝboŋ galenan, nǝvanuan p̃isi lǝtǝmat. Avil aGot dereh tigol na-lǝŋon-isa-vǝsa-an sinǝvanuan p̃isi tem̃idol m̃os alat, gai tolekis hǝn galito, lotovi esan. ");
INSERT INTO klv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Beti avan ideh b̃ikel mai gamit ke, ‘Mǝteris, aKristo bogai!’ o ‘Gai saga!’ samtedǝlomi. ");
INSERT INTO klv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Husur akristo gǝgǝras gail mai ahai kelkel ur gǝgǝras gail dereh levisi. Dereh ligol namerikel nasuhunian nǝvanuan gail lotop̃aŋ habat lan. Lǝtalǝboi lǝtagǝras nǝvanuan gail aGot tolekis hǝn galito, dereh ligole len namerikel galenan. ");
INSERT INTO klv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nalǝlǝgauan enan, nukele hǝn mǝtb̃elǝboi nǝsa b̃evisi. ");
INSERT INTO klv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Imagenan, nǝvanuan gail lǝb̃ikel mai gamit ke, ‘Mǝteris, aKristo satotoh len naut masmas tob̃ǝb̃esw!’ samtivan varisi. Lǝb̃ike, ‘Mǝteris, satosusuah lohoim,’ samtedǝlomi. ");
INSERT INTO klv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Husur, nǝboŋ aNatun Nǝvanuan b̃egǝmai, dereh tehum nasǝm̃oropun togol nǝmav kavkav tom̃ial, nǝvanuan p̃isi lerisi. ");
INSERT INTO klv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Len naut ideh natit tomat topat lan, nab̃iltiman namǝsav tohanhan natit tomat dereh lemǝlah gǝm b̃on ei.” ");
INSERT INTO klv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","AYesu isor am, ike, “Nǝboŋ na-lǝŋon-isa-vǝsa-an hǝn nǝboŋ galenan b̃inoŋ, ‘dereh namityal timotmot, mai nahǝbati asike em̃ial; dereh nam̃eso gail lerus vi pan dan nǝmav mai natit gail lotokad nǝdaŋan len nǝmav dereh lekurkur habat.’ ");
INSERT INTO klv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Beti natit tovǝhot nagǝmaian siNatun Nǝvanuan dereh tevisi len nǝmav, ale naluṽoh hǝn nǝvanuan gail p̃isi len navile a pan dereh lelǝŋon tisa habat, litaŋ. Beti dereh leris aNatun Nǝvanuan togǝm len nǝmavukasw len nǝdaŋan mai nǝyalyalan totibau. ");
INSERT INTO klv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Len nab̃iltiwalan hǝn nǝtrampet dereh tesǝvat aŋel san gail vi lan naut p̃isi len navile a pan kavkav hǝn lǝb̃etǝtariv b̃onb̃on hǝn alat aGot tolekis hǝn galito hǝn lǝb̃evi esan.” ");
INSERT INTO klv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","AYesu ike, “Ivoi hǝn mǝtb̃elǝboi sǝhot natsua nǝhai nafik b̃eṽusani. Nǝboŋ nǝpashǝt nafik sǝmasmas am be todum̃oh, mǝtolǝboii ke nahǝbati naut pudpud egǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Len naṽide tomagenan, nǝboŋ mǝtb̃eris natgalen p̃isi notomadhasor husuri, dereh mǝtelǝboii ke natǝlmaman siNatun Nǝvanuan satogǝmai, ehum gai tia bopita. ");
INSERT INTO klv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nukel nakitinan mai gamito, naur egai asike lumat vǝbar natgalen p̃isi lǝb̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nǝmav mai navile a pan dereh arimasig, be nasoruan sagw gail asike lumasig boŋ ideh.” ");
INSERT INTO klv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","AYesu isor am ike, “Nǝmariboŋ enan o namityal enan, avan ideh salǝboii. Aŋel gail len nǝmav mai aNatun aGot, galit lǝsalǝboii, avil aGot Tata sǝb̃on, gai elǝboii. ");
INSERT INTO klv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nagǝman siNatun Nǝvanuan dereh tehum nǝboŋ siNoah gail. ");
INSERT INTO klv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Len nǝboŋ siNoah gail, nǝboŋ nilev sagǝm sal, nǝvanuan gail luhan, lomun, lulah mai ludam̃ hǝn nǝlahan gail van vǝbar nǝboŋ aNoah tob̃is len nǝak. ");
INSERT INTO klv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nǝvanuan gail lǝsǝnau sǝhot nǝsa b̃evisi van vǝbar nilev egǝm lev kuv galit p̃isi. Nǝboŋ aNatun Nǝvanuan b̃egǝmai, dereh timaienan. ");
INSERT INTO klv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Len nǝboŋ enan, dereh tikad naulum̃an toru artoum marireu. AGot dereh tilav kuv tesua, teriŋ tesua. ");
INSERT INTO klv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dereh tikad napǝhaṽut toru artolis dasdas namisurhuwit. AGot dereh tilav kuv tesua, teriŋ tesua. ");
INSERT INTO klv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Imagenan, mǝtehulahul, husur mǝtsalǝboi nǝboŋ aMasta samit b̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Be mǝtelǝboi sǝhot nategai: amahean naim talǝboi namityal nǝvanuan vǝnvǝnah tagǝmai, amahean talele hǝn nǝvanuan asike tǝlavutur vi lohoim san. ");
INSERT INTO klv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gamit am mitimasutaut, husur aNatun Nǝvanuan dereh tegǝm len namityal mǝtsǝvatvat viri.” ");
INSERT INTO klv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ale aYesu ib̃ol p̃usan, ike, “Avan sua ikad naslev eru, be ta be ivoi sǝhor togon? Naslev sua idaŋ len nauman san, ikad namitisau hǝn nǝmauran tonor. Ale amasta san itabtabuh lan hǝn b̃ekǝtkǝta tǝban naslev san gail len naim san, hǝn b̃evǝŋan galito len namityal tonor hǝni. ");
INSERT INTO klv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Amasta b̃ivahim, b̃isab̃ naslev enan togol nauman san, aslev enan dereh tehǝhaṽur habat. ");
INSERT INTO klv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nukel nakitinan mai gamito, amasta enan dereh titabtabuh len naslev enan hǝn b̃ekǝtkǝta tǝban natit p̃isi san. ");
INSERT INTO klv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Be naslev togon isa. Hum ma gai toke, ‘Amasta sagw dereh titoh a tut tebǝlav.’ ");
INSERT INTO klv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Beti etub̃at ṽas naslev gail lototoh len navǝlan, ale ihan, emun mai alat lototǝrog akis. ");
INSERT INTO klv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ale amasta dereh tetǝlmam len nǝmariboŋ naslev enan sǝvatvat viri mai namityal naslev salǝboii. ");
INSERT INTO klv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dereh amasta tita kotovi, teriŋi len naut nǝvanuan gǝgǝras lototohtoh lan. Len naut enan lutaŋ habat, kat b̃urb̃ur nariṽolit bathut lolǝŋon isa vǝsa batbat.” ");
INSERT INTO klv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Beti aYesu isor husur natǝlmaman san dan nǝmav hum nakiŋ, ike, “Datolǝboi datb̃enǝnoṽ hǝn natohan pipihabǝlan aGot len nǝmav, mai navensus tosǝŋavur lotolav nam̃ial salit, yar van hǝn lǝb̃ebubur mai naulum̃an b̃ilah. ");
INSERT INTO klv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Galit erim lovi hoṽon, erim lukad namitisau hǝn nǝmauran tonor. ");
INSERT INTO klv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Navensus lotovi hoṽon, lupat nam̃ial salit gail be lǝsǝpat naoil ideh. ");
INSERT INTO klv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Navensus lotokad namitisau hǝn nǝmauran tonor, lupat nam̃ial salit gail mai lupat nab̃iliwai hǝn naoil gail am. ");
INSERT INTO klv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Nǝboŋ naulum̃an b̃ilah tovǝlo, navensus gail p̃isi losusuh metanoṽ, gol lupatmari. ");
INSERT INTO klv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tub̃loh len mariug nǝkaian sua evi mǝhat, ‘Mǝteris! Naulum̃an b̃ilah bogai! Gǝm risi, ke “Ivoi,” maii!’ ");
INSERT INTO klv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ale navensus gail lule mǝhat, logut kuv nadurinen nawik hǝn nam̃ial salit gail. ");
INSERT INTO klv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Be torim lotovi hoṽon lukel mai torim lotokad nalǝboian ke, ‘Lav naoil ideh samit mai ginamito, husur nam̃ial sinamit gail lǝsǝpaŋ savoi, dereh limat.’ ");
INSERT INTO klv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Be alat lotokad nalǝboian luke, ‘Ao, datb̃igol b̃imaienan, dereh naoil tem̃idol hǝn gidat p̃isi. Mitia ṽur ideh samito len naim p̃urp̃ur.’ ");
INSERT INTO klv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ale luvan hǝn lǝb̃eṽuri. Be nǝboŋ lotoyar van sal, naulum̃an b̃ilah evisi. Beti navensus torim lotoutaut tia, lutah maii, lob̃is lohoim hǝn nǝlahan. Ale nǝvanuan nauman ekǝkol gat nabopita. ");
INSERT INTO klv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nǝboŋ namityal topair, navensus lotoṽur naoil lotǝlmam, lukai ke, ‘Nasub̃, Nasub̃, sǝŋav hǝn nabopita hǝn ginamito!’ ");
INSERT INTO klv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ris tosor var galit ke, ‘Nukel nakitinan mai gamito, nǝsalǝboi kas gamito.’” ");
INSERT INTO klv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","AYesu imaris kotov nǝb̃ol enan ike, “Imagenan, mǝtehulahul hǝn asike mǝtb̃esum̃an navensus lotovi hoṽon, husur mǝtsalǝboi nǝmariboŋ o namityal hǝn natǝlmaman sagw.” ");
INSERT INTO klv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","AYesu isor tǝtas husur natǝlmaman san, ike, “Natohan pipihabǝlan aGot len nǝmav imaiegai: Ikad avan sua toutaut hǝn b̃ivan len nǝyaran sua. Ekis naslev san gail gǝmai ale eriŋ natit san gail len navǝlalito. ");
INSERT INTO klv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ilav nǝvat mai galit ṽisusua tonor hǝn namitisau salito. Ilav nǝtalent torim mai naslev sua, ilav nǝtalent toru mai naslev sual am, ale ilav tosua mai naslev togon. Ale vǝha-sua ŋai eriŋ naut enan len nǝyaran san. ");
INSERT INTO klv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Naslev tokad nǝtalent torim eum lan van ikad erim am. ");
INSERT INTO klv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Len naṽide tomaienan, naslev tokad toru, eum lan van ikad eru am. ");
INSERT INTO klv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Be aten tokad nǝtalent tosua, evivile, ehir nab̃ur len tan ale itavun susuan nǝvat simasta san. ");
INSERT INTO klv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Idareh buni amasta sislev galenan etǝlmam hǝn b̃elǝboi nǝsa lotogole len nǝvat san. ");
INSERT INTO klv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naslev, amasta tolav nǝtalent torim maii, ipat nǝtalent torim am gǝm hǝni ike, ‘Nasub̃, gulav nǝtalent torim mai ginau, ale len torim enan nopisan erim eg am.’ ");
INSERT INTO klv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Amasta ikel maii ke, ‘Nauman sam̃ ikab! Govi naslev tovoi, todaŋ len ginau. Gudaŋ len natit tokǝkereh notoriŋi len navǝlam̃, imagenan dereh nitabtabuh len gaiug hǝn nǝb̃eriŋ natit tisob̃ur len navǝlam̃. Gegǝmai, gehǝhaṽur mai ginau!’ ");
INSERT INTO klv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Beti naslev, amasta tolav nǝtalent toru maii, egǝm hǝni ike, ‘Nasub̃, gulav nǝtalent toru mai ginau, ale len toru enan nopisan eru eg am.’ ");
INSERT INTO klv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Amasta ikel maii ke, ‘Nauman sam̃ ikab! Govi naslev tovoi, todaŋ len ginau. Gudaŋ len natit tokǝkereh notoriŋi len navǝlam̃, imaienan dereh nitabtabuh len gaiug hǝn nǝb̃eriŋ natit tisob̃ur len navǝlam̃. Gegǝmai, gehǝhaṽur mai ginau!’ ");
INSERT INTO klv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Beti naslev, amasta tolav nǝtalent tosua maii, egǝm hǝni ike, ‘Nasub̃, nolǝboii tia ke govi naulum̃an totaltal, len nǝmatuan gulav nǝhanian dan naut gǝsǝmabule lan, gotǝtariv wit len naut gǝsǝdaŋdaŋ namisurhute lan. ");
INSERT INTO klv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imagenan nomǝtahw, ale nua susuan nǝtalent sam̃ len tan. Nǝvat sam̃ bogai.’ ");
INSERT INTO klv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amasta san isor vari ke, ‘Govi naslev tosa vǝsa gotovekan. Gǝb̃inau ke notovi naulum̃an totaltal, gǝb̃inau ke notolav nǝhanian dan naut nǝsǝmabule lan, gǝb̃inau ke nototǝtariv wit len naut nǝsǝdaŋdaŋ namisurhute lan, ");
INSERT INTO klv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","imabe gǝsariŋ nǝvat sagw len nalulutar? Gǝtagol tomaienan, nǝboŋ nototǝlmam, nǝtǝlav nǝvat sagw mai naintǝres han.’ ");
INSERT INTO klv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ale ikel mai nǝvanuan nauman san gail ke, ‘Lav kuv nǝtalent dan ategai, lavi mai atea tokad tosǝŋavur. ");
INSERT INTO klv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Husur avan ideh toum tovoi len nǝsa tokade, dereh nilav tisob̃ur am maii hǝn b̃epul hǝni. Be avan ideh tom̃idol, avan ideh saum savoi len nǝsa tokade, dereh nilav kuv tokǝkereh gai tokade, dani. ");
INSERT INTO klv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naslev sagol natideh savoi, bar hǝni vivile len nǝmargobut, len naut enan dereh tikad nǝtaŋan mai na-desdes-batriṽoriṽ-an.’ ");
INSERT INTO klv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nǝboŋ aNatun Nǝvanuan b̃egǝmai len namǝnas hǝn nǝyalyalan san, mai aŋel gail p̃isi, dereh tebǝtah len nab̃iltihai bǝtbǝtah san toyalyal hum nakiŋ. ");
INSERT INTO klv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Beti naluṽoh hǝn nǝvanuan naut tiltile gail p̃isi dereh lib̃onb̃on len nǝhon. Ale dereh tepǝpehun galito hum nǝvanuan nasipsip topǝpehun nasipsip gail dan nǝnani gail. ");
INSERT INTO klv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dereh teriŋ nasipsip gail len nǝmatu san mai nǝnani gail len nǝmair. ");
INSERT INTO klv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Beti nakiŋ dereh tikel mai alat len nǝmatu san ke, ‘Gamit, aTǝmagw tovoi buni hǝn gamito, mǝtegǝmai! Mititoh pipihabǝlan aTǝmagw len naut toutaut hǝni tia m̃os gamito len natub̃atan, nǝboŋ togol navile a pan. ");
INSERT INTO klv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Husur nǝboŋ notomalkǝkat, mǝtovǝŋan ginau; nǝboŋ notomaduh, mǝtulav nǝwai mai ginau; nǝboŋ notovi metb̃os, mǝtokis ginau vi lohoim samito; ");
INSERT INTO klv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nǝboŋ notomalmal hǝn nahurabat, mǝtukol nahurabat len ginau; nǝboŋ notomǝsah, mǝtokǝtkǝta tǝban ginau; nǝboŋ nototoh len naim bǝbaŋis, mǝtogǝm, m̃ǝdoŋ tǝban ginau.’ ");
INSERT INTO klv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Beti alat lotonor dereh lisor vari ke, ‘Nasub̃, namtoris gotomalkǝkat namtovǝŋan gaiug ŋais? Namtoris gotomaduh namtulav nǝwai mai gaiug ŋais? ");
INSERT INTO klv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Namtoris gaiug gotovi metb̃os namtous gaiug vi lohoim sinamit ŋais? Namtoris gotomalmal hǝn nahurabat namtukol nahurabat len gaiug ŋais? ");
INSERT INTO klv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Namtoris gotomǝsah o namtom̃ǝdoŋ tǝban gaiug ŋais len naim bǝbaŋis?’ ");
INSERT INTO klv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ale nakiŋ dereh tisor var galit ke, ‘Nukel nakitinan mai gamit ke, nǝboŋ mǝttogole van hǝn nǝbathudud ideh sagw tovi ut kǝmas ŋai, mǝtugole van hǝn ginau.’ ");
INSERT INTO klv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Beti dereh tipair, tikel mai alat len nǝmair san ke, ‘Gamit, aGot togol nǝmauran samit tosa vǝsa, mǝtevi tut dan ginau, mǝtevi lan nǝhab topaŋ vi sutuai aGot toutaut hǝni tia m̃os natǝmat mai aŋel san gail! ");
INSERT INTO klv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Husur nǝboŋ notomalkǝkat, mǝtsavǝŋan ginau; nǝboŋ notomaduh, mǝtsǝlav nǝwai mai ginau; ");
INSERT INTO klv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nǝboŋ notovi metb̃os, mǝtsakis ginau vi lohoim samito; nǝboŋ notomalmal hǝn nahurabat, mǝtsakol nahurabat ideh len ginau; nǝboŋ notomǝsah o nototoh len naim bǝbaŋis, mǝtsam̃ǝdoŋ tǝban ginau.’ ");
INSERT INTO klv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Beti dereh lisor vari ke, ‘Nasub̃, ŋais namtoris gaiug gotomalkǝkat, o gotomaduh, o gotovi metb̃os, o gotomalmal, o gotomǝsah, o gototoh len naim bǝbaŋis be namtsavi tarhǝt sam̃?’ ");
INSERT INTO klv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ale dereh tisor var galit ke, ‘Nukel nakitinan mai gamit ke, nǝboŋ mǝtsagole van hǝn nǝbathudud ideh sagw tovi ut kǝmas ŋai, mǝtsagole van hǝn ginau.’ ");
INSERT INTO klv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Beti alatenan dereh levi tut, vi lan nǝpanismen topat vi sutuai, be alat lotonor levi lan nǝmauran vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nǝboŋ aYesu tokǝmaienan tonoŋ, ikel mai ahai susur san gail ike, ");
INSERT INTO klv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mǝtolǝboii tia ke nǝboŋ nǝmariboŋ b̃eru b̃inoŋ dereh tikad nǝPasova, ale aNatun Nǝvanuan, dereh leriŋi len navǝlan alat lǝb̃ip̃os gati len nǝhai balbal.” ");
INSERT INTO klv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Len namityal enan ab̃iltihai tutumav mai alat lotoil a m̃o hǝn nǝvanuan gail, lub̃onb̃on len nab̃iltiim seb̃iltihai tutumav, nahǝsan aKaiafas. ");
INSERT INTO klv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lusor utaut hǝn lǝb̃igol nagǝrasian ale tah gat aYesu hǝn lǝb̃igol b̃imat. ");
INSERT INTO klv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Be luke, “Sadatigole len Nǝhanan egai, hǝn asike nǝvanuan gail lǝb̃eluṽoh hǝn lǝb̃ib̃al taṽtaṽor, mǝdas natit gail.” ");
INSERT INTO klv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Len nǝboŋ enan, aYesu itoh len naut a Petani len naim seSimon tokad naleprosi a m̃o. ");
INSERT INTO klv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ale napǝhaṽut sua tolav nab̃otel lotoum hǝni hǝn nǝvat topǝhw, egǝm hǝn aYesu tohan. Ilav nab̃otel enan topul hǝn naoil pǝhpǝhas tosusau, nǝvat han totibau, ale eb̃iri len nǝkadun aYesu. ");
INSERT INTO klv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nǝboŋ ahai susur gail lotoris natenan, nǝlolit epǝŋasi. Luke, “Imabe tomǝdas natenan? ");
INSERT INTO klv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ivoi am tap̃ur hǝni m̃os nǝvat tosob̃ur ale tǝlav nǝvat enan mai namǝsal gail.” ");
INSERT INTO klv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Be aYesu tolǝboi natenan ikel mai galit ke, “Imabe mǝtugol nǝlon alitegai isa? Gai igol natit tokab hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mitinau nategai! Namǝsal gail lutoh mai gamit akis, be ginau, asike nutoh tabtab hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nǝboŋ alitegai tob̃ir naoil len ginau, eutaut hǝn nibegw hǝn lǝb̃itavuni. ");
INSERT INTO klv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nukel nakitinan mai gamit ke, len naut p̃isi len navile a pan lotokel ur na-kel-uri-an tovoi lan, dereh lisor husur nǝsa alitegai togole, gol ke nǝvanuan gail lǝb̃inau gati.” ");
INSERT INTO klv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Beti, ahai susur lotovi 12, galit sua, nahǝsan aJutas Iskariot, ivan hǝn ab̃iltihai tutumav gail, ");
INSERT INTO klv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ike, “Nǝb̃eriŋ aYesu len navǝlamito, mǝtudam̃ hǝn mǝtb̃ilav nǝvat tevis mai ginau?” Ale lulav nakoin nasilva tovi 30 maii. ");
INSERT INTO klv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Len nǝboŋ enan van, aJutas idas p̃isal hǝn b̃eriŋ aYesu len navǝlalito. ");
INSERT INTO klv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Len nǝmariboŋ metǝkav hǝn Nǝhanan hǝn nabǝta sǝkad nayis lan, ahai susur gail logǝm hǝn aYesu, lousi ke, “Golǝŋon ke namteutaut hǝn gǝb̃ihan nǝPasova a be?” ");
INSERT INTO klv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ale ike, “Mǝtevi lan nab̃iltivile Jerusalem. Dereh mǝteris naulum̃an sual ei, ale kel maii ke, ‘Ahai p̃usan ike: Nǝboŋ sagw egǝm pǝpadaŋ. Dereh nihan nǝhanian hǝn nǝPasova mai ahai susur sagw gail len naim sam̃.’” ");
INSERT INTO klv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŋa ahai susur gail lugol nǝsa aYesu tokel mai galito, ale loutaut hǝn nǝhanian hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nǝboŋ namityal tomasur, aYesu itah mai ahai susur lotovi 12 len natev hǝn lǝb̃ihan. ");
INSERT INTO klv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nǝboŋ lotohanhan sal, ike, “Nukel nakitinan mai gamit ke, gamit sua dereh teriŋ ginau len navǝlan aenemi sagw gail.” ");
INSERT INTO klv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ahai susur gail nǝlolit isa masuṽ, ale galit ṽisusua lotub̃at usi ke, “Nasub̃, ase lai? Savi ginau a?” ");
INSERT INTO klv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isor var galit ke, “Gamit mǝttohanhan mai ginau, gamit sua toriŋ navǝlan len nasiloh mai navǝlagw, dereh teriŋ ginau len navǝlan aenemi sagw gail. ");
INSERT INTO klv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Husur aNatun Nǝvanuan dereh timasmat hum lototos husuri a m̃o, avil atenan toriŋ aNatun Nǝvanuan len navǝlan aenemi san gail, nǝmauran sitenan tisa vǝsa tibatbat! Tavoi am hǝn atenan ke anan asike tǝpasi!” ");
INSERT INTO klv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ale aJutas, gai b̃eriŋi len navǝlan aenemi san gail, gai am eusi ke, “Hai p̃usan, savi ginau a?” Ale aYesu isor vari ke, “Evoi, gaiug boh gukele.” ");
INSERT INTO klv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nǝboŋ lotohan tin sal, aYesu ilav nabǝta, ale esipa lan, eb̃uri, beti ilavi mai ahai susur gail, ike, “Lavi, hani, nibegw bogai.” ");
INSERT INTO klv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ale nǝboŋ tolav nab̃iliwai topul hǝn nǝwain, esipa hǝni ale ilavi mai galito, ike, “Gamit p̃isi mǝtemun lan, ");
INSERT INTO klv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","husur nǝda hagw bogai, aGot tota gat na-kel-gati-an san lan mai nǝvanuan san gail. Nǝda eg hagw b̃isel, eṽusan nǝmatan sagw tohum natutumavan hǝn b̃erub̃at nǝsaan gail dan nǝvanuan tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ale nukel mai gamit ke, nǝwain egai, len natohan pipihabǝlan aTǝmagw, nǝwain eg dereh tiveveu, ale gagai van asike nomun nǝwain egai van vǝbar nǝboŋ nǝb̃emuni mai gamit ei.” ");
INSERT INTO klv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Beti lokǝkai hǝn nǝb̃e hǝn nalotuan ale lovivile, lovi lan Naṽehuh Oliv. ");
INSERT INTO klv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Beti aYesu ikel mai galit ke, “Len mariug egai dereh gamit p̃isi mitigam dan ginau. Husur len natosian siGot ike, “‘Dereh niṽabun nǝvanuan nasipsip, ale navǝshǝsipsip ligam ṽisusua.’ ");
INSERT INTO klv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Avil, nǝboŋ nǝb̃imat ale aGot b̃igol nǝb̃ile mǝhat, dereh neil a m̃o hǝn gamito vi lan naut a Kalili.” ");
INSERT INTO klv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ale aPita isor vari, ike, “Naut kǝmas nǝvanuan p̃isi lǝb̃igam dan gaiug, ginau asike nugam dan gaiug boŋ ideh!” ");
INSERT INTO klv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","AYesu isor vari ke, “Nukel nakitinan mai gaiug ke, len mariug eg ŋai, a tahw hǝn natoulum̃an b̃ekǝkǝraiko, dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau!” ");
INSERT INTO klv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","APita ikel maii ke, “Ao, naut kǝmas nǝb̃imat mai gaiug, asike nukele ke nǝsalǝboi gaiug!” Ale ahai susur gail p̃isi lokǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Beti aYesu iyar mai galito vi lan naut a Ketsemane, ale ikel mai ahai susur gail ke, “Mǝtebǝtah gegai, ale nivan ea hǝn nǝb̃isor tuṽ.” ");
INSERT INTO klv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Esǝhar aPita mai anatun aSepeti gǝlaru, aJemes mai aJon, etub̃at lolosa, nǝlon isa vǝsa habat. ");
INSERT INTO klv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ale ikel mai galit ke, “Nulolosa masuṽ! Ehum nalolosaan ikabut gol nǝlogw van numat! Mititoh gegai, mitilele mai ginau!” ");
INSERT INTO klv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nǝboŋ toyar van kǝkereh am, ib̃ov len tan, kǝta vi pan, ike, “Tata sagw, b̃ike b̃inor len nalǝŋonian sam̃, gilav kuv nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an egai dan ginau. Wake sagigol nǝsa notolǝŋoni, Tata gigol nǝsa ŋai gaiug gotolǝŋoni.” ");
INSERT INTO klv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Beti etǝlmam van hǝn ahai susur totor enan, isab̃ lotopatmari. Ikel mai aPita ke, “Mǝtsǝdaŋ sǝbar mǝtb̃ilele mai ginau len nǝhaua tosua ŋai a? ");
INSERT INTO klv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mǝtehulahul ale sor tuṽ hǝn asike mǝtb̃iteh len nǝsaan totaltal ke mǝtehusuri. Naut kǝmas nǝlomito elǝŋon b̃igol nǝsa tonor, nibemit sǝdaŋ, edǝdasi.” ");
INSERT INTO klv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ale aYesu eriŋ galit tǝtas, isor tuṽ, ike, “Tata sagw, gǝb̃ike sanor len nalǝŋonian sam̃ hǝn gǝb̃ilav kuv nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an egai dan ginau, avil gǝb̃ike nemuni, gigol nǝsa gotolǝŋoni!” ");
INSERT INTO klv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nǝboŋ tosor tuṽ tonoŋ etǝlmam tǝtas, isab̃ lotopatmari husur namǝtalit inoṽ masuṽ. ");
INSERT INTO klv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ŋa eriŋ galit tasi am, ivan, isor mai aTǝman tǝtas hum togole tia. ");
INSERT INTO klv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Beti etǝlmam van hǝn ahai susur totor, ikel mai galit ke, “Mǝtupat sal a? Mǝtuŋavŋav sal a? Mǝteris! Namityal egǝm pǝpadaŋ. Avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan alat nǝsaan ta bogai! ");
INSERT INTO klv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mitile mǝhat, dativan. Mǝteris, atenan b̃eriŋ ginau len navǝlalito satogǝm pǝpadaŋ.” ");
INSERT INTO klv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nǝboŋ aYesu tosorsor sal, aJutas tosua len tosǝŋavur pisan toru, egǝmai. Itah mai nab̃iltiluṽoh lototǝgau nab̃u nǝb̃alan mai nǝbatw gail. Ab̃iltihai tutumav gail mai alat lotoil a m̃o hǝn nǝvanuan gail losǝvat naluṽoh enan. ");
INSERT INTO klv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ale aJutas isor utaut hǝn naṽusanian sua mai galit a m̃o, ike, “Nǝboŋ nǝb̃esum̃ nǝtarhon atenan, gai bolai. Tah gati.” ");
INSERT INTO klv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ale vǝha-sua ŋai ivan hǝn aYesu ike, “Ivoi, Hai p̃usan,” ale esum̃ nǝtarhon. ");
INSERT INTO klv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","AYesu ikel maii ke, “Tegai, gaiug gigol nǝsa gotogǝm m̃osi.” Beti logǝm tǝban aYesu, lutah gati. ");
INSERT INTO klv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ŋa galit sua lototah mai aYesu eliv kuv nab̃u nǝb̃alan san, ita kotov nǝdariŋan naslev seb̃iltihai tutumav. ");
INSERT INTO klv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Beti aYesu ikel maii ke, “Riŋ tǝlmam hǝn nab̃u sam̃, bathut avan ideh tob̃al hǝn nab̃u nǝb̃alan, dereh nab̃u nǝb̃alan tigol nǝmatan san! ");
INSERT INTO klv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gamit mǝtsalǝboii ke nolǝboi nǝb̃eus aTǝmagw hǝn na-vi-tarhǝte-an san. Ale nǝtausi, gai tasǝvat nab̃iltivǝshǝŋel tovi 12 gag ŋai. ");
INSERT INTO klv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nǝtagol tomagenan, natosian siGot lotoke timasvisi maiegai, lisarpoh mabe?” ");
INSERT INTO klv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Len namityal enan ŋai aYesu ikel mai naluṽoh ke, “Imabe mǝtogǝm, lav nab̃u nǝb̃alan mai nǝbatw gail gǝmai hǝn mǝtb̃itah gat ginau hum notovi vanuan nǝb̃alan toke tib̃al mai alat lotoil a m̃o? Imabe mǝtsǝtah gat ginau len naholǝvat todar vis naim siGot? Nobǝtah, nop̃usan ei len nǝmariboŋ p̃isi. ");
INSERT INTO klv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Avil nǝsa tovisi gagai evisi hǝn natosian sihai kelkel ur b̃isarpoh.” Beti ahai susur san p̃isi loriŋi, lugam mǝtahw dani. ");
INSERT INTO klv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nǝboŋ lotogam dani tonoŋ, alat lototah gat aYesu losǝhari vi lan naim siKaiafas tovi b̃iltihai tutumav, ale ahai p̃usan gail hǝn nalo mai alat lotoil a m̃o hǝn nǝvanuan gail lub̃onb̃on ei. ");
INSERT INTO klv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Be aPita ehusuri, iyar a tut dani vǝbar naholǝvat todar vis naim seb̃iltihai tutumav. Ale nǝboŋ tob̃is lan, ebǝtah ei mai nǝvanuan nauman gail hǝn b̃eris nǝsa b̃evisi. ");
INSERT INTO klv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Len naim, ab̃iltihai tutumav mai nǝSanhitrin p̃isi ludas vanuan gǝgǝras gail lǝb̃idam̃ hǝn lǝb̃elibliboŋ ke aYesu togol tosa, gol alat lotoil a m̃o lolǝboi lǝb̃igol b̃imat sile. ");
INSERT INTO klv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Be lǝsǝsab̃ nalibliboŋan ideh tonor hǝn aYesu b̃imat sile, naut kǝmas nǝvanuan gǝgǝras isob̃ur lotogǝmai. Namǝkot hǝn galito, eru arogǝmai. ");
INSERT INTO klv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Aruke, “Ategai ike, ‘Nolǝboi nǝb̃igol naim siGot b̃imasirsir ale um tǝtas hǝni len nǝmariboŋ b̃itor.’” ");
INSERT INTO klv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Beti ab̃iltihai tutumav ile mǝhat ikel mai aYesu ke, “Imabe gǝsakel natideh hǝn gǝb̃etǝtas gol gaiug? Na-kel-koti-an sǝlaru ekitin a?” ");
INSERT INTO klv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Be aYesu sasor. Ale ab̃iltihai tutumav ikel maii ke, “Nukel idaŋ mai gaiug len nahǝsan aGot nǝkadun nǝmauran, ke, gǝb̃evi aKristo, aNatun aGot, gikele mai ginamito!” ");
INSERT INTO klv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","AYesu isor vari ke, “Gaiug gukele tia. Be nukel mai gamit ke, gagai van dereh mǝteris aNatun Nǝvanuan b̃ebǝtah len navǝlan nǝmatu siGot tovi aB̃iltidaŋan. Dereh mǝteris b̃egǝmai len nǝmavukasw hǝn nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Beti ab̃iltihai tutumav, nǝhon emǝkanun taṽtaṽor, itar nahurabat san hǝn b̃eṽusan tomǝtahun nasoruan siYesu. Ike, “Gai isor mǝdas aGot! Imabe datolǝŋon nǝvanuan ideh am hǝn b̃ikel kot nǝsaan sitegai? Gamit mǝtosǝsǝloŋ hǝn tosor mǝdas aGot! ");
INSERT INTO klv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gamit mǝtunau mab hǝni?” Lusor vari ke, “Inor hǝn b̃imat! Timasmat!” ");
INSERT INTO klv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Beti loṽulai nǝhon aYesu, lotuhi, luṽosi. ");
INSERT INTO klv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Lohǝlasi ke, “Kristo, gǝtavi aKristo gepǝhav utaut! Kel mai ginamito, ase iṽos gaiug?” ");
INSERT INTO klv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Len namityal enan aPita ebǝtah vivile len naholǝvat todar vis naim seb̃iltihai tutumav, ale natǝbarehreh tovi slev egǝm hǝni ike, “Gaiug gutah mai aYesu ta Kalili.” ");
INSERT INTO klv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Be len nǝhon alat lototoh ei aPita ike sakitin. Ike, “Gusor husur nǝsa? Ginau nǝsalǝboi nǝsa gotokele!” ");
INSERT INTO klv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ale evi lan nametlǝkau, beti natǝbarehreh togon tovi slev erisi, ikel mai galit ei ke, “Ategai itah mai aYesu ta Nasaret.” ");
INSERT INTO klv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ale aPita ikel tasi ke sakitin, ita gat nasoran san len nahǝsan aGot ike, “Ginau nǝsalǝboi atenan!” ");
INSERT INTO klv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Len namityal tovan kǝkereh galevis lotoil pǝpadaŋ logǝm hǝni, lukel mai aPita ke, “Kitin, gaiug am govi galit sua. Nǝboŋ namttosǝsǝloŋ hǝn nadolom̃, namtosǝsǝloŋ lǝboii ke govi auleKalili, nadolom̃ ikel uri.” ");
INSERT INTO klv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Beti len nahǝsan aGot aPita ita gati ke nǝsa tokele evi nakitinan. Ike, “Len nahǝsan aGot nokitin, ginau nǝsalǝboi atenan! Asike nǝb̃ekitin, aGot tipansem ginau!” Vǝha-sua ŋai natoulum̃an ekǝkǝraiko. ");
INSERT INTO klv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Beti aPita inau tǝlmam hǝn nǝsa aYesu tokele tia ke, “A tahw hǝn natoulum̃an b̃ekǝkǝraiko, dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau.” Nasoran siYesu a m̃o etunus nǝlon aPita, ale evivile, itaŋ habat. ");
INSERT INTO klv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pelan han, dudulan som̃ilan, ab̃iltihai tutumav p̃isi mai alat lotoil a m̃o hǝn nǝvanuan gail, lub̃onb̃on tǝtas hǝn lǝb̃ihol kitev nap̃isal hǝn lǝb̃igol aYesu b̃imat. ");
INSERT INTO klv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beti lubaŋis gati, losǝhari van, loriŋi len navǝlan aPilate tovi gavna ta Rom. ");
INSERT INTO klv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","AJutas, toriŋ aYesu len navǝlan aenemi san gail, nǝboŋ torisi ke nǝSanhitrin toriŋi ke aYesu b̃imat, aJutas ipair dan nǝsa togole. Ilav tǝlmam hǝn nakoin nasilva tovi 30 van hǝn ab̃iltihai tutumav gail mai alat lotoil a m̃o hǝn nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Isor tǝvah mai galit ke, “Ginau nugol nǝsaan husur noriŋ ategaii len navǝlamito hǝn b̃imat naut kǝmas sagol kas natideh tosa.” Ris lotoke, “Natenan savi natideh len ginamito. Ipat len gaiug.” ");
INSERT INTO klv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","AJutas ibar hǝn nakoin nasilva gail len naim siGot. Beti evivile, itahǝtah hǝn gai gabag hǝn b̃imat. ");
INSERT INTO klv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ab̃iltihai tutumav gail lulav nakoin galenan luke, “Sanor len nalo hǝn datb̃eriŋ nǝvat egai hǝn b̃ib̃on mai nǝvat hǝn naim siGot bathut eb̃iŋb̃iŋal, eṽur nǝda hǝn nǝmatan sivan sua.” ");
INSERT INTO klv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Imagenan, luhol b̃onb̃on. Nǝboŋ lotohol tonoŋ, loṽur nǝmarireu sivan sua togol natit hǝn nǝtan b̃ulau. Loṽur nǝtan enan hǝn b̃egǝm vi ut natǝtavunan simetb̃os gail. ");
INSERT INTO klv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Husur natenan, lokis nǝtan enan hǝn Marireu hǝn Nǝda van vǝbar nǝboŋ ta damǝŋai. ");
INSERT INTO klv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Beti nǝsa ahai kelkel ur, aJeremiah totosi, isarpoh. Ike, “Lulav nakoin nasilva tovi 30, nǝvat alat a Israel lotodam̃ hǝn lǝb̃eṽur atenan hǝni, ");
INSERT INTO klv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ale loṽur nǝmarireu sivan sua togol natit hǝn nǝtan b̃ulau, hum Nasub̃ aGot tokele hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nǝboŋ lotosǝhar aYesu van hǝn nǝgavna ta Rom tonoŋ, eil len nǝhon. Ale agavna Pilate eusi ke, “Gaiug govi kiŋ seJu gail a?” AYesu isor vari ke, “Gaiug boh gukele.” ");
INSERT INTO klv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Be nǝboŋ ab̃iltihai tutumav gail mai alat lotoil a m̃o hǝn nǝvanuan gail lotoil hirhir lan, sor tasi, aYesu sakel natideh. ");
INSERT INTO klv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Beti aPilate eusi ke, “Gǝsasǝsǝloŋ hǝn natit tosob̃ur lotosor tas gaiug hǝni a?” ");
INSERT INTO klv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Be aYesu sasor vari, sakel kas natuhsoruan ideh, gol nǝgavna ip̃aŋ habat lan. ");
INSERT INTO klv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Len Nǝhanan nǝPasova p̃isi, nǝgavna ikad naṽide sua. Idam̃ hǝn avan sua totoh len naim bǝbaŋis b̃evivile husur nalǝŋonian sinaluṽoh. ");
INSERT INTO klv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Len nǝboŋ enan, len naim bǝbaŋis, ikad naulum̃an sua nǝvanuan p̃isi lotolǝboii, nahǝsan aYesu Parappas. ");
INSERT INTO klv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nǝboŋ naluṽoh lotob̃onb̃on sal, aPilate eus galit ke, “Mǝtolǝŋon ke nigol ase tevivile? AYesu Parappas o aYesu lotokisi hǝn aKristo?” ");
INSERT INTO klv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(APilate elǝboi buni ke naJu gail loriŋ aYesu len navǝlan husur lototab̃ulol bulosi.) ");
INSERT INTO klv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Len namityal enan, aPilate ebǝtah len nǝhai bǝtbǝtah hǝn nakotan. Nǝboŋ tobǝtah maienan, asoan esǝvat napisulan van hǝni toke, “Sagigol natideh hǝn atenan tonor, bathut damǝŋai len nab̃ǝb̃er, nolǝŋon isa masuṽ husuri.” ");
INSERT INTO klv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Avil ab̃iltihai tutumav gail mai alat lotoil a m̃o hǝn nǝvanuan gail lusorsor mai naluṽoh hǝn lǝb̃igol husur galito, us aPilate hǝn b̃igol aParappas b̃evivile mai aYesu b̃imat. ");
INSERT INTO klv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Imaienan, nǝboŋ agavna tous galit tǝtas ke, “Mǝtolǝŋon nǝb̃igol gǝlar ta be b̃evivile m̃os gamito?” Lusor vari ke, “Parappas!” ");
INSERT INTO klv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","APilate esǝhoṽut, eus galit ke, “B̃imagenan, nigol nǝsa hǝn aYesu lotokisi hǝn aKristo?” Galit p̃is luke, “Timat len nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ris aPilate tous galit ke, “Bathut nǝsa? Gai igol nǝsa tosa?” Be lukai habat van am ke, “Timat len nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nǝboŋ aPilate tolǝboii ke edǝdas b̃igol natideh hǝn b̃egǝgel hǝn nǝnauan salito, be nab̃iltimǝdasian etub̃at len naluṽoh, ilav nasiloh topul hǝn nǝwai. Len nǝhon nǝvanuan gail ekǝkasǝval. Ikel mai galit ke, “Nǝda hǝn nǝmatan sitegai, sǝpat len ginau. Ipat len gamito!” ");
INSERT INTO klv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Beti nǝvanuan gail p̃isi lusor vari ke, “Nǝda hǝn nǝmatan san tipat len ginamito, mai len nǝpasusan sinamito!” ");
INSERT INTO klv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Beti igol aParappas evivile m̃os galito, be igol nasoltia san tobilas habat hǝn aYesu. Ale eriŋ aYesu len navǝlalito hǝn lǝb̃ip̃os gati len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Beti nasoltia sigavna gail losǝhar aYesu vi lohoim sisoltia gail, ale galit p̃isi lub̃onb̃on garu lan. ");
INSERT INTO klv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lukol nahurabat san dani, lukol nahurabat bisibis hum sekiŋ lan. ");
INSERT INTO klv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lovisvis hǝn nǝhau tokad nasunite tohum nab̃ulgǝgau, ale loriŋi len nǝkadun aYesu hum nǝkraun sekiŋ. Loriŋ natsua hun nǝhaie len navǝlan nǝmatu hum nǝhai sekiŋ. Beti lotǝŋedur bathurien, lotub̃at sor vilesi ke, “Sal suh nakiŋ seJu gail!” ");
INSERT INTO klv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Loṽulaii, ale lusab̃ul natenan hun nǝhaie dani, luṽas nǝkadun hǝni. ");
INSERT INTO klv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nǝboŋ lotosor vilesi tonoŋ, lukol nahurabat bisibis dani, lukol nahurabat san lan tǝtas, ale losǝhari van hǝn lǝb̃ip̃os gati len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Len nǝyaran salit dan nab̃iltivile, lobubur mai auleSairin sua nahǝsan aSimon. Lugol atenan ipat nǝhai balbal siYesu. ");
INSERT INTO klv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nǝboŋ lotobar naut a Kolkota (namilen nahǝsenan tovi Naut hǝn Nabǝlashukadhutǝmat). ");
INSERT INTO klv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lulav nǝwain lotobul hǝn natit tokon masuṽ lan maii, be nǝboŋ aYesu tomun risi, emǝtahuni. ");
INSERT INTO klv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Beti lup̃os gati len nǝhai balbal. Nǝboŋ lotop̃os gati tonoŋ, lopǝpehun nahurabat san, bar hǝn nǝvat hǝn lǝb̃isab̃ ase b̃ilav nahurabat ṽisusua. ");
INSERT INTO klv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ale lobǝtah, kǝtkǝta kǝkol hǝn aYesu ei. ");
INSERT INTO klv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lutos gat nǝsa aYesu togole tosa, ale loriŋ na-kel-uri-an enan len nǝhai balbal a mǝhat hǝn nǝkadun. Ike, “AYesu bogai, Kiŋ seJu gail.” ");
INSERT INTO klv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ikad nǝvanuan vǝnvǝnah eru artotahǝtah mai aYesu. Sual itahǝtah len nǝhai balbal len nǝmatu siYesu, togon len nǝmair san. ");
INSERT INTO klv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nǝvanuan gail lotoṽot, lohǝlas aYesu, sor mǝdas nahǝsan. Loŋit nǝholit van hǝni, ");
INSERT INTO klv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","luke, “Gaiug golǝboi gǝb̃igol naim siGot b̃imasirsir ale len nǝmariboŋ b̃itor um tǝlmam hǝni a? B̃imagenan, gǝb̃evi aNatun aGot, lav kuv gaiug gabag! Mariŋ dan nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Len naṽide tomaienan, ab̃iltihai tutumav gail, alat lotoil a m̃o hǝn nǝvanuan gail mai ahai p̃usan gail hǝn nalo lusor vilesi, luke, ");
INSERT INTO klv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Gai ilav kuv nǝvanuan tile gail be edǝdas b̃ilav kuv gai! Inau ke tovi kiŋ seIsrael a? B̃imagenan, timariŋ dan nǝhai balbal ale dereh datedǝlomi ke tovi kiŋ. ");
INSERT INTO klv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eriŋ nǝlon len aGot mai ike tovi aNatun aGot. Imagenan, gagai aGot b̃elǝŋoni, tilav kuvi.” ");
INSERT INTO klv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nǝvanuan vǝnvǝnah gǝlaru artotahǝtah tǝban aYesu, gǝlar am arokǝmaienan, arohǝlasi. ");
INSERT INTO klv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Len natub̃lial nǝmargobut ikabut gol p̃is naut kavkav van vǝbar namityal totor ut mǝdau. ");
INSERT INTO klv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ale len namityal totor enan, aYesu ikai habat len nasoruan matmat san ke, “Eli, eli, lema sapahtani!” namilen, “Got sagw, Got sagw, goriŋ gab̃ulan ginau sil nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nǝvanuan galevis lotoil ei lotosǝsǝloŋ hǝni, lunau suluṽi, lunau ke tokis aElijah. ");
INSERT INTO klv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Vǝha-sua ŋai galit sua ilav nasponts igol topul hǝn nǝwain tokon, ale esii len nǝhai, esuhuni van hǝn aYesu hǝn b̃emuni. ");
INSERT INTO klv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Be galevis am luke, “Riŋi! Datebunus risi ke aElijah dereh tegǝm lav kuvi o teb̃uer.” ");
INSERT INTO klv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Beti aYesu ikai habat tǝtas am, emǝsol, imat. ");
INSERT INTO klv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Len namityal enan ŋai, nǝkaliko mǝtortor totahǝtah len naim siGot, tub̃at a mǝhat, emǝtar vǝbar naut a pan, igol nahudhut eru. Nǝtan ekurkur, nǝvat gail lumap̃ulp̃ul, ");
INSERT INTO klv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nab̃urhuvat nǝmatan losǝŋav. Ale aGot igol nǝvanuan isob̃ur lotovi esan lule mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ale lovivile dan nab̃urhuvat nǝmatan gail. Husur na-le-mǝhat-an dan nǝmatan siYesu lob̃is len nab̃iltivile siGot, a Jerusalem, ale lovisi hǝn nǝvanuan isob̃ur. ");
INSERT INTO klv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nasenturion mai nasoltia gail lotokǝtkǝta kǝkol hǝn aYesu len nǝhai balbal, nǝboŋ lotoris nadu mai natit gail am lotovisi, lomǝtahw habat. Luke, “Kitin, ategai evi aNatun aGot!” ");
INSERT INTO klv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Len naut enan ikad napǝhaṽut tosob̃ur lotohusur aYesu, kǝtkǝta tǝban len nǝyaran san a Kalili gǝmai. Alatenan loil a tut dan nǝhai balbal, lokǝta ris nǝsa tovisi. ");
INSERT INTO klv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Galit galevis lovi aMeri ta Maktala; togon aMeri anan aJemes mai aJosef; togon asoan aSepeti, anan aJemes mai aJon. ");
INSERT INTO klv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nǝboŋ namityal pǝpadaŋ b̃imasur, aJosef tovi auleArimatea sua tokad natite mai tohusur aYesu, ");
INSERT INTO klv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ivan hǝn aPilate. Eus niben aYesu. APilate idam̃ hǝni ale ikele idaŋ ke lipat niben mai aJosef. ");
INSERT INTO klv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ŋa aJosef eruŋ gole len nǝkaliko tovi linen toveveu. ");
INSERT INTO klv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eriŋi len nab̃urhuvat nǝtavunan san toveveu, tota p̃up̃uli tia len nǝvat. Erib hǝn nab̃iltivat hǝn b̃ipat gol nabopita hǝn nab̃urhuvat nǝmatan enan, ale ivan. ");
INSERT INTO klv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","AMeri ta Maktala mai aMeri togon arobǝtah a m̃o, a tut kǝkereh dan nabopita hǝn nab̃urhuvat nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pelan han, tovi nǝmariboŋ tohusur Nǝboŋ hǝn Nautautan hǝn nǝPasova, ab̃iltihai tutumav gail mai naFarisi gail lub̃onb̃on, luvan hǝn aPilate. ");
INSERT INTO klv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ale luke, “Nasub̃, namtunau tǝlmam hǝn nǝsa nǝvanuan gǝgǝras egaii tokele nǝboŋ tomaur sal. Ike, ‘Len nǝmariboŋ titor dereh aGot tigol nile mǝhat.’ ");
INSERT INTO klv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Imaienan, namtuke gikele hǝn nasoltia sam̃ gail ke lekǝtkǝta kǝkol hǝn nab̃urhuvat nǝmatan vǝbar nǝmariboŋ titor. Asike datb̃igole, ahai susur san gail hum ma lǝb̃evǝnoh niben ale kel mai nǝvanuan gail ke tole mǝhat dan nǝmatan tia! Ale b̃imaienan, nagǝgǝrasan enan dereh tesǝhor nagǝgǝrasan tokele a m̃o.” ");
INSERT INTO klv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","APilate isor var galit ke, “Sǝhar nasoltia na-kǝtkǝta-kǝkol-an gail van, ale len namitisau ideh mǝttokade, mǝtekǝtkǝta kǝkol gat nab̃urhuvat.” ");
INSERT INTO klv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ale luvan, lokǝkol gat nab̃urhuvat nǝmatan, loriŋ na-burut-gati-an lan ale loriŋ nasoltia gail hǝn lǝb̃ekǝtkǝta kǝkol hǝni. Lugol natgalenan len nǝSappat. ");
INSERT INTO klv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nǝboŋ nǝSappat enan tonoŋ, nǝmav topitau dudulan som̃ilan, len nǝmariboŋ metǝkav hǝn nawik, aMeri ta Maktala mai aMeri togon luvan varis nab̃urhuvat nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vǝha-sua ŋai ikad nab̃iltidu, bathut aŋel sua siNasub̃ evi pan dan nǝmav, ale erib kuv nab̃iltivat topat gol nab̃urhuvat, ebǝtah lan. ");
INSERT INTO klv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nǝnahǝnah han em̃ial hum nǝkabil mai nahurabat san epǝhw yesyes hum nasno. ");
INSERT INTO klv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nasoltia gail lotokǝtkǝta kǝkol hǝn nab̃urhuvat, ninelit epil lan, lom̃inm̃inikot, luteh matmatiov. ");
INSERT INTO klv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Beti aŋel isor mai napǝhaṽut gǝlaru, ike, “Samremǝtahw! Nolǝboi mǝruke mǝreris aYesu lotogol tomat len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Be gai satoh gegai, husur aGot igol ile mǝhat tia sum̃an ŋai aYesu tokele. Mǝregǝm ris naut topat lan. ");
INSERT INTO klv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mirivan tutut! Kel mai ahai susur san gail ke, ‘Sǝsǝloŋ! AGot igol ile mǝhat dan nǝmatan. Dereh teil a m̃o hǝn gamito vi lan naut a Kalili. Ale dereh mǝterisi ei.’ Enan ŋai na-kel-uri-an sagw.” ");
INSERT INTO klv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Napǝhaṽut gǝlaru arugam tutut dan nab̃urhuvat. Aromǝtahw be aropul hǝn nakemkeman ale arusaṽsaṽut hǝn arb̃ikele mai ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vǝha-sua ŋai aYesu ebubur mai gǝlaru. Ike, “Ivoi!” Arogǝm hǝni, arotǝgau gat narien gǝlaru, arulotu hǝni. ");
INSERT INTO klv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Beti aYesu ikel mai gǝlaru ke, “Samremǝtahw. Mirivan, kel mai aṽagw gail ke levi lan naut a Kalili, ale dereh leris ginau ei.” ");
INSERT INTO klv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nǝboŋ napǝhaṽut gǝlaru artovan sal, nasoltia galevis lotokǝtkǝta kǝkol hǝn nab̃urhuvat nǝmatan lovi lan nab̃iltivile. Ale lukel ur natit p̃isi tovisi mai ab̃iltihai tutumav gail. ");
INSERT INTO klv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ab̃iltihai tutumav gail lub̃onb̃on mai alat lotoil a m̃o hǝn nǝvanuan gail ale ludam̃ hǝn na-sor-utaut-an sua. Lulav nǝvat isob̃ur mai nasoltia gail, ");
INSERT INTO klv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","lukel mai galit ke, “Mǝtekǝmaiegai ke, ‘Ahai susur san gail logǝm len mariug, lovǝnoh niben nǝboŋ namttopat.’ ");
INSERT INTO klv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Agavna Pilate b̃esǝsǝloŋ hǝn natenan, dereh namtetǝŋov nǝlon hǝn asike mǝtb̃ikad nǝpanismen ideh.” ");
INSERT INTO klv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Imaienan, nasoltia gail lulav nǝvat enan, lugol nǝsa ab̃iltiJu gail lotokele. Na-kel-uri-an enan salito, naJu gail lukele van vǝbar nǝboŋ ta damǝŋai. ");
INSERT INTO klv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Beti ahai susur lotovi 11 lovi Kalili vi lan naṽehuh aYesu tokel mai galit tia hǝn lǝb̃evi lan. ");
INSERT INTO klv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nǝboŋ lotorisi ei, lulotu hǝni, be galit galevis lukad nǝ-lon-uri-an. ");
INSERT INTO klv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","AYesu egǝm hǝn galito, ikel mai galit ke, “AGot aTǝmagw ilav mai ginau nǝdaŋan hǝn na-il-a-m̃o-an p̃isi len nǝmav mai len navile a pan. ");
INSERT INTO klv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Imagenan, mitivan hǝn mǝtb̃eṽusan naluṽoh hǝn nǝvanuan naut tiltile gail hǝn lǝb̃egǝm vi hai susur sagw gail. Baptais hǝn galito len nahǝsan aGot aTata, aNatun mai aNunun. ");
INSERT INTO klv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ṽusan galito hǝn lǝb̃igol natit p̃isi notokele todaŋ mai gamito. Nau gat nategai: ginau nutah mai gamito, ale dereh nitah mai gamito van vǝbar nǝboŋ hǝn nanoŋan hǝn navile a pan, nagilen natit p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Egai natub̃atan hǝn na-kel-uri-an tovoi husur aYesu Kristo tovi Natun aGot. ");
INSERT INTO klv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ehum ahai kelkel ur sua, aIsaiah totos gat nǝsa aGot tokel mai aNatun. Ike, “Geris! Dereh nesǝvat ahai pispisul sagw teil a m̃o hǝn gaiug, hǝn b̃eutaut hǝn nap̃isal sam̃. ");
INSERT INTO klv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nadoldol sua satokai len naut masmas tob̃ǝb̃esw ke, ‘Geutaut hǝn nap̃isal m̃os Nasub̃, gigol nap̃isal san gail linor!’” ");
INSERT INTO klv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Imagenan, aJon evisi, itoh len naut masmas tob̃ǝb̃esw, ikel uri ke, nǝvanuan gail limasbaptais hǝn b̃imasil ke lotopair dan nǝsaan salito van hǝn aGot hǝn b̃erub̃at nǝsaan salit gail. ");
INSERT INTO klv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nǝvanuan naut a Jerusalem mai naprovens Jutea kavkav luvan hǝn lǝb̃esǝsǝloŋ hǝni. Ale nǝboŋ lotokel vǝhot nǝsaan salit gail, ibaptais hǝn galito len Nawisel Jortan. ");
INSERT INTO klv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nahurabat siJon, luvaii hǝn navurun nǝkamel, ale nǝhau tutuṽ evi nahurhub̃uluk. Ihanhan nalokust, ihanhan nǝhani nasukapak toum hǝni. ");
INSERT INTO klv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","AJon ikel uri ke, “Avan sua dereh tegǝm a tahw len ginau, gai idaŋ sǝhor ginau, ale ginau nǝsanor kasi hǝn nǝb̃etǝŋadur, sah rub̃at nǝhau hǝn naributbut san. ");
INSERT INTO klv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ginau nubaptais hǝn gamito hǝn nǝwai, be dereh gai tibaptais hǝn gamito hǝn aNunun aGot.” ");
INSERT INTO klv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Len nǝboŋ sua, aYesu iyar len naut a Nasaret a Kalili gǝmai ale aJon ibaptais hǝni len Nawisel Jortan. ");
INSERT INTO klv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nǝboŋ aYesu tomadhale mǝhat dan nǝwai enan, eris aGot totar p̃ul nǝmav hǝn tosǝŋav ale eris aNunun togǝm vi pan vi lan, sum̃an nǝtav. ");
INSERT INTO klv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Beti esǝsǝloŋ hǝn nadoldol togǝm len nǝmav toke, “Gaiug govi anatugw ulum̃an sagw notolǝmas bun gaiug, nohǝhaṽur masuṽ hǝn gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Vǝha-sua ŋai aNunun aGot esǝhar aYesu vi lan naut masmas tob̃ǝb̃esw. ");
INSERT INTO klv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Itoh ei len nǝmariboŋ tovi 40 ale aSetan italtal sob̃uer ke tigol nǝsaan. Itoh mai narivatvat nalilihai lotolǝboi lǝb̃isah pǝpasi ale aŋel gail lovi tarhǝt san. ");
INSERT INTO klv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Husur nǝboŋ galenan, aenemi siJon lutah gati, riŋi len naim bǝbaŋis. Beti aYesu evi Kalili, ikel ur na-kel-uri-an siGot. ");
INSERT INTO klv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ike, “Namityal egǝm tia, natohan pipihabǝlan aGot egǝm pǝpadaŋ. Mitipair dan nǝsaan samito, dǝlom na-kel-uri-an tovoi enan!” ");
INSERT INTO klv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Boŋ sua aYesu toyaryar bitas tarhǝt Nab̃iltiwai Kalili, eris alarmiṽan, aSimon mai aAdru artobar hǝn nalevlev len nab̃iltiwai husur arovi vanuan nǝsahiehan. ");
INSERT INTO klv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ale aYesu ikel mai gǝlaru ke, “Mǝregǝmai! Mǝrehusur ginau ale nigol mǝregǝm vi vanuan nǝ-sah-hǝn-nǝvanuan-an!” ");
INSERT INTO klv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vǝha-sua ŋai aroriŋ nalevlev sǝlar gail, arohusuri. ");
INSERT INTO klv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nǝboŋ aYesu toyar kǝkereh am husur bitas, eris aJemes mai aJon alarmiṽan, anatun aSepeti gǝlaru. Arusah len nab̃ot salito, arobutan nalevlev salit gail lunor. ");
INSERT INTO klv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Vǝha-sua ŋai ekis gǝlaru hǝn arb̃itah maii, ale aroriŋ atǝmalaru len nab̃ot mai nǝvanuan nauman gail, ale arutah maii, arohusuri. ");
INSERT INTO klv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","AYesu mai ahai susur san gail lovi lan navile a Kapernaum, ale len nǝSappat eb̃is len naim nab̃onb̃onan seJu gail, ep̃usan. ");
INSERT INTO klv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nǝvanuan lup̃aŋ len nap̃usanan san bathut ep̃usan sum̃an naulum̃an tokad na-il-a-m̃o-an kitin, sasum̃an ahai p̃usan gail hǝn nalo. ");
INSERT INTO klv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Len namityal enan ŋai len naim nab̃onb̃onan salito ikad naulum̃an tokad nanunun nǝmargobut. Ikai, ");
INSERT INTO klv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ike, “Yesu ta Nasaret, gumab hǝn ginamito? Gogǝm hǝn gǝb̃igol namteb̃uer a? Ginau nolǝboi gaiug. Nolǝboi gotovi siGot, gotogǝm m̃osi.” ");
INSERT INTO klv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","AYesu esivoh len nanunun nǝmargobut, ike, “Gemǝdau! Gimakuv dani!” ");
INSERT INTO klv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ale nanunun nǝmargobut igol atenan totaltaloŋ hǝn nahumatmat, ikai habat ale nanunun nǝmargobut imakuv dani. ");
INSERT INTO klv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nǝvanuan gail lumaŋmaŋ lan, lotub̃at sor husur nǝsa tovisi. Lousus galit gabag ke, “Nap̃usanan veveu tomabe ganan? Ikad nǝdaŋan hǝn na-il-a-m̃o-an! Ikele hǝn nanunun tosa gail ale lugol husur nǝsa tokele!” ");
INSERT INTO klv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na-kel-uri-an husur nǝsa aYesu togole iperŋan tutut hǝn naut p̃isi len naut a Kalili. ");
INSERT INTO klv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nǝboŋ aYesu mai ahai susur san gail lotovivile dan naim nab̃onb̃onan seJu gail, lutah mai aJemes, aJon, lovi lohoim seSimon mai aAdru. ");
INSERT INTO klv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Anan asoan aSimon ipat len nǝmel, namǝsahan igol niben topud. AYesu tob̃is, vǝha-sua ŋai lusor husur aliten maii. ");
INSERT INTO klv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ale aYesu ivan hǝni, etǝgau navǝlan, elivi vi mǝhat hǝn b̃ebǝtah. Namǝsahan inoŋ dani ale ile mǝhat, ilav nǝhanian mai galito. ");
INSERT INTO klv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nǝboŋ namityal tomasur, naut togomgom, nǝvanuan gail losǝhar alat lotomǝsah mai alat lotokad natǝmat gail van hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nǝvanuan p̃isi len nab̃iltivile kavkav loluṽoh il bopita. ");
INSERT INTO klv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ale igol isob̃ur lotokad namǝsahan tiltile lumaur. Ehut natǝmat isob̃ur ale igol lodǝdas lǝb̃isor husur lolǝboi gai tia. ");
INSERT INTO klv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pelan han, dudulan som̃ilan, naut sǝlan sal, aYesu ile mǝhat, evivile, evi tut sua len naut tob̃ǝb̃esw ale isor tuṽ ei. ");
INSERT INTO klv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Idareh aSimon mai alat lototah maii, ludoŋi. ");
INSERT INTO klv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nǝboŋ lotosab̃i luke, “Nǝvanuan p̃isi lokǝtkǝta doŋ gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Be aYesu isor var galit ke, “Datevi tut ideh am, len naut gail lotodar vis navile egai hǝn nǝb̃ikel ur nasoruan siGot ei. Husur nogǝm m̃osi.” ");
INSERT INTO klv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ŋa iyar tur p̃is naut len naut a Kalili, ikel ur nasoruan siGot len naim nab̃onb̃onan salito ale ehut natǝmat gail. ");
INSERT INTO klv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naulum̃an tokad naleprosi egǝm tǝŋedur tǝban aYesu, eŋiri ke, “Gǝb̃elǝŋoni, golǝboi gǝb̃igol nǝb̃imaur, nǝb̃iveveu.” ");
INSERT INTO klv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nǝlon aYesu itaŋis masuṽ hǝni, isar hǝn navǝlan, ibari, ikel maii ke, “Nolǝŋoni. Gimaur, giveveu!” ");
INSERT INTO klv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vǝha-sua ŋai naleprosi ivan dan atenan, imaur, iveveu. ");
INSERT INTO klv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Beti aYesu esǝvati van, ikai tasi ");
INSERT INTO klv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ke, “Sagikel natideh mai avan ideh, be gia ṽusan gaiug hǝn ahai tutumav hǝn b̃ebunus husur nibem̃. Beti getutumav hǝn naviolan hǝn naveveuan sam̃ aMoses tokel bun gail hǝn nǝvanuan lǝb̃elǝboi sǝhoti ke gotomaur.” ");
INSERT INTO klv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Avil ategaii ivan, ikel ur nǝsa tovisi hǝni. Igole van van na-kel-uri-an enan ibar naut isob̃ur. Naten igol aYesu salǝboi b̃eb̃is len navile ideh len nǝhon nǝvanuan gail bathut naluṽoh ludar visi, be itoh len naut gail lotob̃ǝb̃esw. Be nǝvanuan gail len naut p̃isi ei logǝmgǝm hǝni sal. ");
INSERT INTO klv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Husur nǝmariboŋ galevis, aYesu etǝlmam vi Kapernaum. Nǝboŋ tobar naut enan, sǝdareh, husur ke nǝvanuan isob̃ur lotosǝsǝloŋ hǝni ke totoh ei, ");
INSERT INTO klv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","logǝm hǝn naim san gol loririhit lohoim mai vivile. Lǝsalǝboi lǝb̃eil bopita am. Ale aYesu ikel ur nasoruan mai galito. ");
INSERT INTO klv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nǝvanuan galevis logǝm hǝni, ivat lupat naulum̃an nǝtarhǝben tomat, ");
INSERT INTO klv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","be lodǝdas lǝb̃ibar aYesu bathut naluṽoh. Ale lopǝlau vi mǝhat len navurun naim topapav, ludakuvi, gol nab̃ur a mǝhat hǝn naut aYesu totoh lohoim lan. Ale loriŋ tur hǝn nǝbateh vi pan, atenan nǝtarhǝben tomat, topat lan. ");
INSERT INTO klv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nǝboŋ toris nadǝlomian salito, aYesu ikel mai atenan nǝtarhǝben tomat ke, “Natugw, nǝsaan sam̃ gail lumarub̃at.” ");
INSERT INTO klv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Be ahai p̃usan hǝn nalo lotobǝtah ei lunau natgalenan len nǝlolit ke, ");
INSERT INTO klv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gai ekǝmaienan mabe? Isor mǝdas aGot! AGot sǝb̃on ŋai elǝboi b̃erub̃at nǝsaan dan nǝvanuan!” ");
INSERT INTO klv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Vǝha-sua ŋai aYesu elǝboi nǝnauan salito ale ikel mai galit ke, “Imabe mǝtunau magenan len nǝlomito? ");
INSERT INTO klv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nǝb̃ikel mai ategai nǝtarhǝben tomat ke, ‘Norub̃at nǝsaan sam̃ gail,’ o nǝb̃ike ‘Gile mǝhat, pat nǝbateh sam̃, giyar,’ nǝsa emǝdmǝdau am? ");
INSERT INTO klv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Be nuke mǝtelǝboii ke aNatun Nǝvanuan ikad nǝdaŋan hǝn na-il-a-m̃o-an hǝn b̃erub̃at nǝsaan len navile a pan. Nokǝmaiegai hǝn nǝb̃eṽusan nǝdaŋan en mai gamito.” Ale aYesu ikel mai atenan nǝtarhǝben tomat ike, ");
INSERT INTO klv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nukel mai gaiug, gile mǝhat, pat nǝbateh sam̃, givahim sam̃.” ");
INSERT INTO klv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vǝha-sua ŋai atenan ile mǝhat, ipat nǝbateh, evivile len nǝhon nǝvanuan p̃isi. Lumaŋmaŋ masuṽ lan ale lusal suh nǝyalyalan siGot luke, “Datsaris natideh tomaienan boŋ ideh sal!” ");
INSERT INTO klv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Beti aYesu evivile, etǝlmam hǝn b̃iyar tarhǝt nab̃iltiwai Kalili. Nab̃iltiluṽoh egǝm hǝni ale eṽusan galito. ");
INSERT INTO klv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Len nǝyaran san van, eris aLevi anatun aAlfeus tobǝtah len nǝpasvalǝval hǝn nǝtaks, ale ikel maii ke, “Gitah mai ginau, gehusur ginau!” Ale aLevi ile mǝhat, ehusuri. ");
INSERT INTO klv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ŋa aLevi eus aYesu mai ahai susur san gail hǝn lǝb̃ihan lohoim san. (Ikad nǝvanuan nǝtaks mai nǝvanuan nǝsaan isob̃ur lotohan ei husur ikad nǝvanuan tosob̃ur maienan lotohusur aYesu.) ");
INSERT INTO klv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Be nǝboŋ ahai p̃usan hǝn nalo galevis lotovi Farisi lotoris aYesu tohan mai nǝvanuan gail lotomaienan, lous ahai susur san gail ke, “Imabe tohan mai nǝvanuan nǝtaks mai nǝvanuan nǝsaan gail?” ");
INSERT INTO klv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nǝboŋ aYesu tosǝsǝloŋ hǝn natenan ikel mai galit ke, “Savi alat lotomaur lotovan hǝn nǝvanuan nareran hǝn b̃irer hǝn galito, be alat lotomǝsah ŋai. Ginau nǝsagǝm hǝn nǝb̃ekis alat lotonor o alat lotonau ke lotonor, be nogǝm hǝn nǝb̃ekis nǝvanuan nǝsaan gail.” ");
INSERT INTO klv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Len nǝmariboŋ galevis ahai susur siJon mai naFarisi gail lǝsǝhan hǝn lǝb̃isor tuṽ. Ale logǝm hǝn aYesu lousi ke, “Ahai susur siJon gail mai ahai susur sinaFarisi gail lǝsǝhan hǝn lǝb̃isor tuṽ, be ahai susur sam̃ gail lǝsǝmagenan. Imabe?” ");
INSERT INTO klv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","AYesu isor var galit ke, “Mǝtunau ke nǝvanuan lototah mai naulum̃an tolah, lǝsǝhan len nǝhanan nǝlahan a? Aoa! Asike lumaienan nǝboŋ naulum̃an tolah totoh mai galit sal. ");
INSERT INTO klv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Be naulum̃an tolah, nǝboŋ b̃egǝmai hǝn lǝb̃esǝhari dan nǝvanuan san gail, ale len nǝboŋ enan asike luhan. ");
INSERT INTO klv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Sǝkad avan ideh top̃isihoh hǝn nǝkaliko veveu len nahurabat tomatu. Tagole, nap̃isihoh tǝmakuv dan nahurabat tomatu gol nǝ-tar-sili-an tamǝdasi sǝhor ta m̃o. ");
INSERT INTO klv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Natsual am, sǝkad avan ideh tob̃ir nǝwain lotomadhaum hǝni len nahurhuwain lotomatu. Tagole, nǝwain veveu tatǝvah tur lan, mǝdas nǝwain mai nahurhuwain p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Len nǝSappat sua, aYesu toyar tur marireu hǝn nawit, ahai susur san gail lotub̃at kin b̃ur nǝhavhuwit gail. ");
INSERT INTO klv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ŋa naFarisi gail lukel mai aYesu ke, “Imabe lotogol nǝsa nalo tokai tasi len nǝSappat?” ");
INSERT INTO klv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","AYesu isor var galit ke, “Mǝtsaṽuruŋ lǝboi natosian gail lotohol husur aTevit boŋ ideh nǝboŋ gai mai alat lototah maii lotopar hanian, lotomalkǝkat a? Nǝboŋ aApiatar tovi b̃iltihai tutumav, aTevit eb̃is len naim siGot, ihan nabǝta tolo ahai tutumav sǝb̃olit ŋai lolǝboi lǝb̃ihani. Ale ilav nabǝta galevis mai alat lototah maii.” ");
INSERT INTO klv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Beti aYesu ikel mai galit ke, “NǝSappat, aGot igole m̃os nǝvanuan, sagol nǝvanuan m̃os nǝSappat. ");
INSERT INTO klv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Imaienan, aNatun Nǝvanuan evi masta, evi masta hǝn nǝSappat am.” ");
INSERT INTO klv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Len nǝboŋ sua tile am, aYesu eb̃is lohoim nab̃onb̃onan seJu gail tǝtas, ale ikad avan sual ei, navǝlan tomat, togǝm hum towas. ");
INSERT INTO klv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nǝvanuan gail ei lomǝtan aYesu hǝn ke lǝb̃eris b̃igol atenan b̃imaur len nǝSappat. B̃igole, dereh likot hǝni ale kel uri ke tob̃ur kotov nalo hǝn nǝSappat. ");
INSERT INTO klv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","AYesu ikel mai atenan navǝlan tomat, togǝm hum towas ke, “Geil rivuh.” ");
INSERT INTO klv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Beti eus galit ke, “Inor hǝn datb̃igol b̃ivoi len nǝSappat o hǝn datb̃igol b̃isa? Inor hǝn datb̃eriŋ tǝlmam hǝn nǝmauran o hǝn datb̃igol nǝmatan?” Be naut eb̃ut, lǝsasor vari. ");
INSERT INTO klv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Len nǝlol paŋpaŋ san ekǝta mǝtaltal hǝn galito, ilolosa hǝn galit husur nǝkadulit iṽonṽon. Beti ikel mai atenan ke, “Gisar hǝn navǝlam̃!” Ale isar hǝni, navǝlan imaur tǝlmam. ");
INSERT INTO klv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Vǝha-sua ŋai naFarisi gail lovivile, lub̃onb̃on mai alat galevis len nǝpati tovi tarhǝt siHerot hǝn lǝb̃isor utaut hǝn lǝb̃emǝdas bun aYesu hǝn b̃imat. ");
INSERT INTO klv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","AYesu mai ahai susur san gail lovi lan nab̃iltiwai ale nab̃iltiluṽoh lohusuri. Nǝboŋ lotosǝsǝloŋ husur natit p̃isi aYesu togole, nǝvanuan isob̃ur logǝm hǝni. Logǝm len naut a Kalili, a Jutea, ");
INSERT INTO klv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","a Jerusalem, a Itumea, len naut gail tarhǝt Nawisel Jortan mai naut gail lotodar vis nab̃iltivile eru, a Tair mai a Siton. ");
INSERT INTO klv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bathut naluṽoh totibau, ikel mai ahai susur san gail ke leutaut hǝn nab̃ot viri hǝn asike nǝvanuan lǝb̃eluṽoh dar visi. ");
INSERT INTO klv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Husur len nǝmariboŋ enan igol isob̃ur lumaur tia ale isob̃ur am lotokad namǝsahan tiltile loririhit, dar visi hǝn lǝb̃ibari. ");
INSERT INTO klv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ale nǝboŋ nǝvanuan lotokad nanunun tosa gail lotoris aYesu, luteh len nǝhon, lukai habat ke, “Gaiug govi aNatun aGot!” ");
INSERT INTO klv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Avil aYesu ikai tas galito ke salikel vǝhot gai ke tovi ase. ");
INSERT INTO klv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Beti aYesu etǝṽehuh vi mǝhat, ekis alat gai tolǝŋon galito ale logǝm hǝni. ");
INSERT INTO klv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ale itabtabuh len galit lotovi 12 hǝn lǝb̃itah maii; ekis galit hǝn ahai pispisul gail hǝn b̃esǝvat galit van hǝn lǝb̃ikel ur napisulan siGot; ");
INSERT INTO klv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ale ilav nǝdaŋan hǝn na-il-a-m̃o-an mai galito hǝn lǝb̃ehut natǝmat gail. ");
INSERT INTO klv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Alat lotovi 12 nahǝsalit lumaiegai: ikad aSimon aYesu tokisi hǝn aPita; ");
INSERT INTO klv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ikad aJemes anatun aSepeti mai aJon aṽan aJemes, ale aYesu ekis gǝlaru Poanerkes namilen Natun Nab̃iliurur gǝlaru. ");
INSERT INTO klv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ikad galevis am, aAdru, aFilip, aPartolomiu, aMattiu, aTomas, aJemes anatun aAlfeus, aTatteus, aSimon tovi naSelot sua, ");
INSERT INTO klv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mai aJutas Iskariot b̃eriŋ aYesu len navǝlan aenemi san gail. ");
INSERT INTO klv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","AYesu etǝlmam vahim len naim totohtoh lan mai ahai susur san gail. Ale naluṽoh logǝm b̃onb̃on ei van gai mai ahai susur san gail lǝsǝkad namityal ideh hǝn lǝb̃ihan. ");
INSERT INTO klv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nǝboŋ nǝbathudud siYesu lotosǝsǝloŋ hǝn nakelean husur nǝsa tovisi, luke litah gati husur luke tovinvinu. ");
INSERT INTO klv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Be ahai p̃usan hǝn nalo lotogǝm len naut a Jerusalem, luke, “APeelsepul toil a m̃o hǝn natǝmat gail iwol hǝni. Ehut natǝmat gail len nǝdaŋan seb̃iltitǝmat setǝmat gail.” ");
INSERT INTO klv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ale aYesu ekis galit gǝmai, isor mai galit len nasoruan kǝta ke, “ASetan elǝboi b̃ehut aSetan mabe? ");
INSERT INTO klv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nǝvanuan lototoh pipihabǝlan nakiŋ len nǝkantri sua b̃ib̃alkabaŋ, nǝkantri dereh timap̃ulp̃ul. ");
INSERT INTO klv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nǝbathudud b̃ib̃alkabaŋ, dereh timap̃ulp̃ul. ");
INSERT INTO klv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Len naṽide tomaienan, aSetan tǝb̃al mai gai gabag, alat pipihabǝlan lǝtapǝpehw, gai asike talǝboi tail gǝgat am, nǝdaŋan san tanoŋ. ");
INSERT INTO klv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nisor kǝta maiegai ke: Avan ideh salǝboi b̃eb̃is lohoim sinabǝhariv todaŋ hǝn b̃itariv kuv natit san gail. Be a m̃o, b̃ibaŋis gat abǝhariv, beti elǝboi b̃itariv kuv natit p̃isi dan naim san. ");
INSERT INTO klv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nukel nakitinan mai gamit ke, aGot dereh terub̃at nǝsaan ideh dan nǝvanuan gail naut kǝmas lǝb̃isor tas aGot o lǝb̃emǝdas nahǝsan. ");
INSERT INTO klv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Avil avan ideh tosor mǝdas aNunun aGot, asike aGot erub̃at nǝsaan enan dani boŋ ideh. Be nǝsaan enan san, tonor hǝn nǝpanismen, dereh tipat len atenan vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","AYesu ekǝmaienan husur ahai p̃usan hǝn nalo gail luke tokad nanunun tosa. ");
INSERT INTO klv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Beti aṽan aYesu matmat gail mai anan logǝm tǝban naim aYesu totoh lan. Loil vivile, lopisul van hǝni, kisi gǝmai. ");
INSERT INTO klv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Naluṽoh lobǝtah dar vis aYesu, ale lukel maii ke, “Geris, anam̃ mai aṽam̃ gail lous gaiug vivile.” ");
INSERT INTO klv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","AYesu isor var galit ke, “Ase lai tovi anagw? As galit lai lotovi aṽagw gail?” ");
INSERT INTO klv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ale ekǝta garu len alat lotobǝtah dar visi, ike, “Gamit mǝtovi anagw mai aṽagw gail bogai. ");
INSERT INTO klv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Husur avan ideh togol nǝsa aGot tolǝŋoni, gai evi aṽagw o aṽavinegw o anagw.” ");
INSERT INTO klv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","AYesu etub̃at p̃usan tǝtas tarhǝb̃iltiwai Kalili. Nab̃ilitluṽoh logǝm b̃onb̃on dar visi gol tosah len nab̃ot, bǝtah hǝn b̃ep̃usan. Ale nǝvanuan gail p̃isi losuh pǝpadaŋ hǝn nab̃iltiwai, a ut. ");
INSERT INTO klv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eṽusan galit hǝn natit isob̃ur len nǝb̃ol p̃usan gail. Ale len nap̃usanan san ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sǝsǝloŋ! Nǝvanuan nǝmabulan hǝn namisurhut gail ia bubulan namisurhuwit. ");
INSERT INTO klv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nǝboŋ tobubulan gail, galevis luteh metp̃isal, ale nǝman namǝsav gail logǝm han p̃is gail. ");
INSERT INTO klv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Namisurhuwit galevis am luteh len naut tobaŋ vat, nǝtan tokǝkereh lan, ale lutov tutut husur nǝtan enan sǝsareh. ");
INSERT INTO klv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nǝboŋ namityal tovisi, esun bun gail ale lumayoh husur lǝsǝkad nǝharhǝte. ");
INSERT INTO klv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Namisurhuwit galevis am luteh len tan tobaŋ hau tokad nasunite lan, ale nǝboŋ nawit totov, nǝhau eruŋ gut buni, gol sǝṽan. ");
INSERT INTO klv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Namisurhuwit galevis am luteh len tan tokǝnoh. Lutov, lovivi mǝhat ale luṽan. Sua iṽan vǝkad 30, sual am iṽan vǝkad 60 ale sua tǝtas am iṽan vǝkad 100.” ");
INSERT INTO klv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Beti aYesu ike, “Nǝvanuan tokad nǝdariŋan hǝn b̃esǝsǝloŋ, tesǝsǝloŋ!” ");
INSERT INTO klv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nǝboŋ aYesu totoh sǝb̃on mai ahai susur san lotovi 12 mai galevis am, lous namilen nǝb̃ol p̃usan gail hǝni. ");
INSERT INTO klv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ale ikel mai galit ke, “AGot ikel vǝhot nǝsa tosusuah husur natohan pipihabǝlan mai gamito hǝn mǝtb̃elǝboii. Be alat lototoh vivile, nukel nakitinan p̃isi mai galito len nǝb̃ol p̃usan gail ");
INSERT INTO klv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","hǝn natosian siGot b̃isarpoh toke, “‘Naut kǝmas lǝb̃ekǝta, kǝta, lǝsakǝta lǝboi nǝsa aGot togole; naut kǝmas lǝb̃esǝsǝloŋ, sǝsǝloŋ, lǝsasǝsǝloŋ lǝboi nǝsa aGot togole. Asike lǝtǝmagenan, lǝtǝpair van hǝn aGot ale tarub̃at nǝsaan salito.’” ");
INSERT INTO klv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Beti aYesu eus galit ke, “Mǝtsalǝboi namilen nǝb̃ol p̃usan enan a? B̃imagenan, mǝtelǝboi nǝb̃ol p̃usan ideh mabe? ");
INSERT INTO klv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nǝvanuan nǝmabulan ebubulan namisurhuwit gail tovi nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Namisurhuwit toteh metp̃isal ehum alat lotosǝsǝloŋ hǝn nasoruan siGot. Ale nǝboŋ lotosǝsǝloŋ hǝni, vǝha-sua ŋai aSetan egǝmai, lav kuvi dan galito. ");
INSERT INTO klv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nǝvanuan galevis lohum namisurhuwit toteh len tan tobaŋ vat. Nǝboŋ lotosǝsǝloŋ hǝn nasoruan, ibar nǝlolito, vǝha-sua ŋai lohǝhaṽur lan. ");
INSERT INTO klv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Be husur lohum nawit nǝharhǝte sakir sǝdaŋ, lǝsatov sabǝlav. Ale nǝboŋ lotolǝŋon tosa o nǝvanuan gail lotomǝdas bun galito bathut nasoruan tobar galito, luteh dan nadǝlomian. ");
INSERT INTO klv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nǝvanuan galevis am lohum namisurhuwit toteh len tan tobaŋ hau tokad nasunite lan. Losǝsǝloŋ hǝn nasoruan ");
INSERT INTO klv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","be nǝlolit etuhatuh hǝn nǝmauran hǝn navile eg a pan, nalǝmasian hǝn natite mai na-lǝŋon-masuṽ-hǝni-an hǝn natgalevis am lob̃is len galito gol loruŋ gut bun nasoruan hǝn asike b̃iṽan. ");
INSERT INTO klv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nǝvanuan galevis tile am lohum namisurhuwit lototeh len tan tovoi. Losǝsǝloŋ hǝn nasoruan, ibar nǝlolito, ale luṽan masuṽ, galevis luṽan vǝkad 30, galevis luṽan vǝkad 60, galevis am luṽan vǝkad 100.” ");
INSERT INTO klv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Beti aYesu eus galit ke, “Ikad avan ideh topat nam̃ial hǝn b̃esusuani pipihad o pipimel a? Ao! Eriŋi a mǝhat len nǝhai nam̃ial toilil lan. ");
INSERT INTO klv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Husur natideh tosusuah dereh aGot tevǝhoti ale natideh topat len nǝmargobut dereh aGot tigol tevivile, tip̃arp̃ar. ");
INSERT INTO klv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nǝvanuan tokad nǝdariŋan hǝn b̃esǝsǝloŋ, tesǝsǝloŋ!” ");
INSERT INTO klv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Beti isor tǝtas mai galit ke, “Mǝtelǝlǝgau hǝn gamito! Mǝtesǝsǝloŋ husur nakelean sagw. Dereh aGot tilav nalǝboian mai gamito tonor hun na-sǝsǝloŋ-husuri-an samito, ale tivan am. ");
INSERT INTO klv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bathut avan ideh nǝlon tomab̃ur hǝn nǝsa notokele, dereh aGot tilav nalǝboian am maii. Avil avan ideh tomǝtahun b̃elǝboi nǝsa notokele, dereh aGot tilav kuv nalǝboian gai tokade dani.” ");
INSERT INTO klv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Beti aYesu ike, “Natohan pipihabǝlan aGot imaiegai: Ikad naulum̃an tobubulan namisurhuwit len tan. ");
INSERT INTO klv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nǝboŋ topat len nalenmariug o tolele len nalennǝyal, namisurhuwit itov, evivi mǝhat. Be itov vi mǝhat mabe? Atenan salǝboii. ");
INSERT INTO klv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nǝtan sǝb̃on evǝhasus hǝn nawit: a m̃o nalute evisi, itov ale evi mǝhat, beti iṽan hǝn nǝhavhǝte, ale ikad namisurhute tovi hanian. ");
INSERT INTO klv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Be nǝboŋ namisurhuwit tomatu, vǝha-sua ŋai atenan ivan, ita kokotovi hǝn nab̃u tohab̃ husur nǝboŋ hǝn nǝmatuan egǝmai.” ");
INSERT INTO klv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","AYesu isor tǝtas ike, “Dereh nenǝnoṽ hǝn natohan pipihabǝlan aGot mai nǝsa? Nisor vǝsvǝsaii len nǝb̃ol p̃usan tomabe? ");
INSERT INTO klv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Imaiegai: Nǝvanuan imabul namisurhumastat len tan. Ekǝkereh sǝhor namisurhut gail p̃isi len tan ");
INSERT INTO klv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","be itov vi mǝhat vatibau sǝhor nǝhanian p̃isi. Nǝpashǝt gail topasil lotibau gol ke, nǝman namǝsav lolǝboi lǝb̃eum hǝn nǝhai ŋodŋod halit len gail, len nǝm̃ol han.” ");
INSERT INTO klv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","AYesu ikel nǝb̃ol p̃usan isob̃ur hǝn b̃ikel nasoruan mai nǝvanuan gail tonor hǝn nalǝboian lotokade hǝn lǝb̃elǝboi sǝhoti. ");
INSERT INTO klv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Len nǝhon nǝvanuan gail, natit p̃isi tokele, ikel mai galit len nǝb̃ol p̃usan gail ŋai. Be nǝboŋ totoh mai ahai susur san gail sǝb̃olito, isor vǝsvǝsai namilen natgalenan. ");
INSERT INTO klv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Len nǝboŋ enan naut igomgom, ale aYesu ikel mai ahai susur san gail ke, “Datevi tarhǝt nǝwai egai.” ");
INSERT INTO klv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ŋa loriŋ naluṽoh, lusah maii len nab̃ot ale luvan. (Ikad nab̃ot galevis am lotohusuri.) ");
INSERT INTO klv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Losǝhoṽut hǝn nab̃iltilan togǝmai tokud hǝn nǝwai. Nǝwai epus vi lan nab̃ot gol totub̃at pul hǝn b̃emun. ");
INSERT INTO klv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","AYesu ipatmari len napilo a tahw, bathuwag. Lovǝŋoni, lukel maii ke, “Eee Hai p̃usan, namtomun! Gǝsǝnau ginamit a? Nab̃ot idod!” ");
INSERT INTO klv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ŋa aYesu ile mǝhat, esivoh len nǝlan, ikel mai nǝwai ke, “Gemǝdau! Vi pan!” Ale nǝlan idar buni, naut etǝm̃at. ");
INSERT INTO klv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Beti eus galit ke, “Mǝtovi batmǝtahw gail a? Mǝtsǝkad nadǝlomian sal a?” ");
INSERT INTO klv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ahai susur gail lom̃inm̃inikot habat. Lousus galit gabag ke, “Ategai ase? Nateru eg am, nǝlan mai nab̃iltiwai lugol husur nǝsa tokele!” ");
INSERT INTO klv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ale lubar nǝtarhǝt nab̃iltiwai enan, len naut a Kerasa. ");
INSERT INTO klv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nǝboŋ lotobar naut enan, aYesu imariŋ dan nab̃ot. Vǝha-sua ŋai naulum̃an tokad nanunun tosa egǝm len nab̃urhuvat nǝmatan gail ei, ebubur mai aYesu. ");
INSERT INTO klv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Atenan itoh b̃urhuvat nǝmatan gail. Nǝvanuan gail lodǝdas lǝb̃ibaŋisi am hǝn natsen. ");
INSERT INTO klv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lubaŋis narien gǝlaru mai navǝlan gǝlaru hǝn natsen vǝha-sob̃sob̃ur tia, be igol natsen tobaŋis navǝlan imarmarikot, mai natsen tobaŋis narien, ilab̃ub̃uri. Sǝkad avan ideh tokad nǝdaŋan hǝn b̃etǝgau gati. ");
INSERT INTO klv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Akis len nalennǝyal mai nalenmariug, iyar lab len nab̃urhuvat nǝmatan mai naṽehuh gail, ikai habat, tiv sisil niben gabag hǝn nǝvat. ");
INSERT INTO klv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nǝboŋ aYesu totoh a tut dani sal, atenan erisi, igam van hǝni, etǝŋedur bathurien. ");
INSERT INTO klv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","AYesu ikel maii ke, “Nanunun gotosa, gimakuv, givan dan ategai!” Atenan eis, ikai habat ike, “Gaiug, savi hǝn gǝb̃emǝdas ginau, Yesu, aNatun aGot toyalyal! Len nahǝsan aGot noŋir gaiug ke sagipansem ginau, sagemǝdas ginau!” ");
INSERT INTO klv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Beti aYesu eusi ke, “Nahǝsam̃ ase?” Ale ike, “Nahǝsagw aLuṽoh husur namtusob̃ur.” ");
INSERT INTO klv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ale loŋir vǝha-sob̃sob̃ur hǝni ke satehut galit vi lan naut a tut ideh. ");
INSERT INTO klv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Len nǝtarhǝṽehuh ei ikad nab̃iltivǝshǝbuai lotohan. ");
INSERT INTO klv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ale natǝmat galenan loŋir aYesu ke, “Sǝvat ginamit van hǝn navǝshǝbuai hǝn namtb̃eb̃is len gail.” ");
INSERT INTO klv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ŋa idam̃ hǝni. Ale natǝmat lumakuv dan naulum̃an, lob̃is len nabuai gail. Ale navǝshǝbuai lom̃ur, sarmar vi pan vi lan nab̃iltiwai. Ikad nabuai tovi 2,000 lotomun, lotomat len nab̃iltiwai. ");
INSERT INTO klv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Alat lotokǝtkǝta tǝban navǝshǝbuai, lugam dan naut enan vi lan nab̃iltivile mai naut lotodar visi hǝn lǝb̃ikel ur nǝsa tovisi. Ale nǝvanuan gail lugam gǝm hǝn lǝb̃eris nǝsa tovisi ei. ");
INSERT INTO klv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ale logǝm hǝn aYesu, loris atenan a m̃o tokad naluṽoh hǝn natǝmat ale lorisi ke esun nahurabat, ebǝtah, imaur tǝtas, nǝnauan san etǝlmam, imasil. Ŋa lomǝtahw. ");
INSERT INTO klv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Beti alat lotoris nǝsa tovisi, lukel ur natit p̃isi tovisi mai galit lotomadhagǝmai. Lusor husur naulum̃an tokad natǝmat gail ale lusor husur nabuai gail. ");
INSERT INTO klv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Imaienan, nǝvanuan gail len naut enan lotub̃at ŋir aYesu ke teriŋ naut salit gail. ");
INSERT INTO klv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nǝboŋ aYesu tosah len nab̃ot, naulum̃an a m̃o tokad natǝmat gail eŋir aYesu hǝn b̃itah maii. ");
INSERT INTO klv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Be aYesu sǝdam̃ hǝni, ike, “Givahim van hǝn nǝbathudud sam̃ ale kel mai galito hǝn natit p̃isi Nasub̃ togole m̃os gaiug mai nalolosaan tokade len gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ale atenan ivan, len naut a Tekap̃olis, etub̃at kel ur natit p̃isi aYesu togole m̃osi. Galit p̃isi ei lumaŋmaŋ len natit tokele. ");
INSERT INTO klv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Beti aYesu igam kotov nab̃iltiwai len nab̃ot tǝlmam vi lan nǝtarhǝte. Nǝboŋ tobar nǝtarhǝwai ei, nab̃iltiluṽoh logǝm b̃onb̃on dar visi. ");
INSERT INTO klv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Beti avan sua, nahǝsan aJairus toil a m̃o hǝn naim nab̃onb̃onan ei egǝm hǝn aYesu. Iteh bathurien. ");
INSERT INTO klv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Eŋir aYesu, ike, “Nasub̃, anatvavigw pǝpadaŋ hǝn b̃imat. Gegǝm vahim bai hǝn gǝb̃eriŋ navǝlam̃ lan hǝn b̃imaur, asike b̃imat.” ");
INSERT INTO klv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ale aYesu ivan maii. Nab̃iltiluṽoh lohusuri, loburuti. ");
INSERT INTO klv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ikad napǝhaṽut sual ei tomǝsah, nǝda han togam hǝn nasihau tovi 12 tia. ");
INSERT INTO klv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nǝvanuan nareran lusob̃ur lurer sob̃uer hǝni be lugol elǝŋon isa vǝsa ŋai. Ep̃ur hǝn natit p̃isi san hǝn b̃eṽur galito, be sǝmaur. Emǝsah habat am. ");
INSERT INTO klv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Esǝsǝloŋ hǝn nakelean husur aYesu, ale ikel mai gai gabag ke, “Nǝb̃ibar nahurabat san, dereh nimaur.” Ŋa eliligis hǝn gai len naluṽoh madun aYesu, ibar nahurabat san. ");
INSERT INTO klv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Vǝha-sua ŋai nǝgaman hǝn nǝda esib, ale elǝboi len niben ke tomaur tǝlmam, namǝsahan san inoŋ. ");
INSERT INTO klv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nǝboŋ alitenan tobar aYesu vǝha-sua ŋai elǝboi len gai gabag ke nǝdaŋan ivan dani. Ŋa ipair len naluṽoh ike, “Ase tobar nahurabat sagw?” ");
INSERT INTO klv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ahai susur san gail lukel maii ke, “Gebunus naluṽoh lotorihit gaiug. Imabe gotous ke, ase tobar gaiug?” ");
INSERT INTO klv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Be aYesu ekǝtkǝta garu hǝn b̃isab̃ nǝvanuan tobari. ");
INSERT INTO klv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Beti napǝhaṽut tolǝboi nǝsa tovisi hǝni, emǝtahw, ipab. Egǝm hǝni, iteh bathurien, ale ikel nakitinan kavkav maii. ");
INSERT INTO klv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ale aYesu ikel maii ke, “Litegai, nadǝlomian sam̃ igol ke gotomaur. Givan, len nǝlom̃ gikad natǝm̃at, na-lǝŋon-isa-an sam̃ inoŋ.” ");
INSERT INTO klv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nǝboŋ tosorsor sal, nǝvanuan galevis logǝm len naim siJairus toil a m̃o hǝn naim nab̃onb̃onan, lukel maii ke, “Anatvavim̃ imat tia. Sagemǝdas ahai p̃usan am.” ");
INSERT INTO klv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Be aYesu, tosǝsǝloŋ hǝn nǝsa lotokele, ikel mai aJairus ke, “Sagemǝtahw. Riŋ nǝlom̃ len ginau ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Beti aYesu sǝdam̃ hǝn avan ideh hǝn b̃ehusuri, be idam̃ hǝn aPita, aJemes mai aJon, aṽan aJemes ŋai. ");
INSERT INTO klv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nǝboŋ lotobar naim sitenan toil a m̃o hǝn naim nab̃onb̃onan, aYesu eris nǝvanuan gail lotowal taṽtaṽor, lototaŋ, lotois habat. ");
INSERT INTO klv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nǝboŋ tob̃is lohoim ikel mai galit ke, “Imabe mǝtolǝŋon isa, mǝtutaŋ maiegai? Natǝbarehreh enan sǝmat, ipatmari ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lusor vilesi, luman sili. Be esǝvat galit vivile ale esǝhar atǝman natǝbarehreh mai anan mai alat lototah maii, ale eb̃is len naut natǝbarehreh topat lan. ");
INSERT INTO klv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Etǝgau navǝlan alitenan ale ikel maii len nasoruan san ke, “Talita koum!” namilen toke, “Tuhtǝbarehreh, nukel mai gaiug, gile mǝhat!” ");
INSERT INTO klv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Vǝha-sua ŋai natuhtǝbarehreh nǝdam̃ han tovi 12, ile mǝhat, iyaryar. Nǝboŋ lotoris natenan lumaŋmaŋ habat. ");
INSERT INTO klv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ale aYesu ikel idaŋ mai galit ei ke salikel nǝsa tovisi mai avan ideh. Beti ike, “Lav nǝhanian ideh hǝn b̃ihani.” ");
INSERT INTO klv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","AYesu eriŋ naut enan, evi Nasaret, naut a im san, ale ahai susur san gail lohusuri. ");
INSERT INTO klv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Len nǝSappat etub̃at hǝn nap̃usanan len naim nab̃onb̃onan ale isob̃ur lotosǝsǝloŋ lup̃aŋ luke, “Ategai ilav natgalenan tokele a be? Namitisau egai hǝn nǝmauran tonor gai tokade egǝm len naut a be? Igol mabe hǝn namerikel lotomaienan? ");
INSERT INTO klv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Be ategai inau ke tovi ase? Gai evi nǝvanuan na-um-im-an ŋai, anatun aMeri, aṽan aJemes, aJoses, aJutas mai aSimon. Aṽavinen gail lutoh gegai!” Ale len nǝlol sasa salito lomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ale aYesu ikel mai galit ke, “Ahai kelkel ur, nǝvanuan gail loputsani len nǝnauan salito len naut p̃isi, be len naut a im san, len amahean gail mai len nǝbathudud san, natsua, lǝsaputsani, lomǝtahuni.” ");
INSERT INTO klv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Edǝdas b̃igol namerikel ideh len naut enan, be eriŋ navǝlan len nǝvanuan evis ŋai lotomǝsah ei ale lumaur. ");
INSERT INTO klv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ale ip̃aŋ husur nadǝlomian salit tob̃uer. Beti aYesu iyar husur navile ṽisusua, ep̃usan. ");
INSERT INTO klv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ale ekis b̃onb̃on hǝn ahai susur san gail ale etub̃at sǝvat galit lorururu van. Ale ilav mai galito nǝdaŋan hǝn na-il-a-m̃o-an hǝn lǝb̃ehut nanunun nǝmargobut gail. ");
INSERT INTO klv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ale ikele hǝn galit ke, “Samtilav natideh len nǝvanan samito, samtilav nabǝta, samtitariv nǝhad sǝsǝŋon, samtilav nǝvat ideh len nǝhau tutuṽ samit gail. Mitipat nǝhai tǝbatehw ŋai. ");
INSERT INTO klv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mǝtevǝlas naributbut be samtitariv nahurabat gǝgel.” ");
INSERT INTO klv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ale ikel mai galit ke, “Naim ideh mǝtb̃eb̃is lan, mititoh ei vǝbar mǝtb̃eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Len naut ideh lǝsahǝhaṽur hǝn mǝtb̃itoh lan, lǝsasǝsǝloŋ hǝn gamito, mǝteriŋ naut enan, dardar hǝn nariemito hǝn nǝmasiav b̃imakuv dan gǝlaru. Natenan tevi hǝn b̃imasil hǝn galit ei ke aGot sahǝhaṽur hǝn galito.” ");
INSERT INTO klv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Imaienan, luvan. Lukel uri ke nǝvanuan gail limaspair dan nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lohut natǝmat isob̃ur, ale lovǝhas nǝvanuan isob̃ur lotomǝsah hǝn naoil naoliv, ale lumaur. ");
INSERT INTO klv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","AHerot Antipas, aKiŋ esǝsǝloŋ hǝn nakelean husur aYesu, bathut nǝvanuan gail p̃isi lolǝboi nahǝsan. Galevis luke “Atenan evi Jon Baptais tole mǝhat dan nǝmatan. Imagenan elǝboi b̃igol namerikel gail.” ");
INSERT INTO klv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Galevis am luke, “Gai evi Elijah.” Galevis tile am luke, “Ahai kelkel ur bolai, esum̃an ahai kelkel ur gail ta sutuai.” ");
INSERT INTO klv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nǝboŋ aHerot tosǝsǝloŋ hǝn natgalenan, ike, “AJon, gai notota kotov nǝkadun, ile mǝhat dan nǝmatan! Imaur tǝlmam!” ");
INSERT INTO klv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Evi aHerot enan tokel mai nasoltia gail ke litah gat aJon, baŋisi, ale riŋi len naim bǝbaŋis. Igol tomaienan sil abareab siHerot, aHerotias. Alitenan evi asoan aFilip, be aHerot aṽan aFilip esǝhar kuvi ale ilah maii. ");
INSERT INTO klv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","AHerot eriŋ aJon len naim bǝbaŋis husur aJon ikel mai aHerot ke, “Len nalo, sanor hǝn gǝb̃esǝhar asoan aṽam̃.” ");
INSERT INTO klv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ŋa aHerotias, nǝlon epǝŋas aJon, elǝŋon ke tigol timat be edǝdasi, ");
INSERT INTO klv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","husur aHerot emǝtahw len aJon, ike aJon titoh maienan ŋai. Elǝboii ke aJon tovi vanuan tonor, tovoi buni. Nǝboŋ aHerot tosǝsǝloŋ hǝn aJon, edidimair hǝni; be naut kǝmas natenan, elǝmas b̃esǝsǝloŋ hǝn aJon. ");
INSERT INTO klv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Imaienan van van, be boŋ sua aHerotias isab̃ nap̃isal sua. Len nab̃iltiboŋ hǝn nǝpasian siHerot, aHerot igol nǝhanan m̃os nab̃iltivanuan gail lototah maii, nakomada gail mai nǝvanuan totibau gail len naut a Kalili. AHerotias ikab hǝn nǝboŋ enan husur elǝboi b̃igol aJon b̃imat. ");
INSERT INTO klv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nǝboŋ anatvavin aHerotias tob̃is ale tosav, aHerot mai alat lotohan maii ei lohǝhaṽur masuṽ hǝni. Ale aKiŋ ikel mai alitenan ke, “Us ginau hǝn natideh gotolǝŋoni ale dereh nilavi mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ale ita gat na-kel-gati-an sua len nahǝsan ke, “Natideh gǝb̃eusi hǝn ginau, dereh nilavi mai gaiug, naut kǝmas b̃evi nahudhut nǝtan notovi kiŋ lan.” ");
INSERT INTO klv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Alitenan evivile, eus anan ke, “Neus nǝsa?” Anan ike, “Geus nǝkadun aJon Baptais.” ");
INSERT INTO klv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vǝha-sua ŋai natǝbarehreh esǝtab̃ul van hǝn aKiŋ, ike, “Nolǝŋon nǝkadun aJon Baptais. Nolǝŋoni len nasiloh sua. Nolǝŋoni gag ŋai!” ");
INSERT INTO klv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nǝboŋ tokǝmaienan igol aKiŋ nǝlon isa, be husur tota gat na-kel-gati-an san len nahǝsan, ale husur tokele len nǝhon alat lotohan maii, inau ke naut kǝmas tomǝtahuni, timasgol nǝsa aliten tousi hǝni. ");
INSERT INTO klv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ŋa vǝha-sua ŋai esǝvat nasoltia nǝ-tata-vanuan-an van hǝn naim bǝbaŋis hǝn b̃ita kotov nǝkadun aJon ale pati gǝmai. Ale nasoltia ivan, ita kotov nǝkadun aJon len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ipat nǝkadun aJon len nasiloh, lavi mai natǝbarehreh. Ale natǝbarehreh ilavi mai anan. ");
INSERT INTO klv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nǝboŋ ahai susur siJon gail lotosǝsǝloŋ hǝni ke tomat, logǝm pat niben van, tavuni len nab̃ur nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nǝboŋ ahai pispisul gail lototǝlmam len nǝyaran salito, lub̃on mai aYesu hǝn lǝb̃ikel maii hǝn natit p̃isi lotogole mai lotop̃usan hǝni. ");
INSERT INTO klv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nǝvanuan isob̃ur logǝmai, isob̃ur luvan gol aYesu galito lǝsǝkad namityal ideh hǝn lǝb̃ihan. Imaienan aYesu ike, “Datevi tut ideh hǝn datb̃itoh sǝb̃odato ale ŋavŋav kǝkereh.” ");
INSERT INTO klv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋa lusah len nab̃ot sǝb̃olito, loriŋ naut enan, lovi lan naut tob̃ǝb̃esw. ");
INSERT INTO klv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wake isob̃ur loris lotovan ale lolǝboi naut lǝb̃evi lan. Ale nǝvanuan isob̃ur len navile gail lugam vi lan naut en tob̃ǝb̃esw ale lubari a m̃o. ");
INSERT INTO klv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nǝboŋ aYesu galit lotobar naut enan, lotomariŋ dan nab̃ot, aYesu eris nab̃iltiluṽoh ale nǝlon itaŋis galito husur lohum nasipsip gail lotopar vanuan hǝn b̃ekǝtkǝta tǝban galito. Ale etub̃at ṽusan galit hǝn natit isob̃ur. ");
INSERT INTO klv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Namityal ipair tia ale ahai susur san gail logǝm hǝni luke, “Naut egai ipat a tut dan navile gail ale namityal ivan p̃isi tia. ");
INSERT INTO klv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sǝvat galit van, hǝn lǝb̃evi lan naim ṽisusua marireu mai navile gail lotodar vis naut egai, hǝn lǝb̃ep̃ur hanian halit hǝn lǝb̃ihani.” ");
INSERT INTO klv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ris tosor var galit ke, “Gamit m̃au mitilav nǝhanian mai galito!” Ale lukel maii ke, “Hǝn namtb̃eṽur nǝhanian hilategai nǝvat han dereh tevi hǝn nap̃urp̃uran hǝn nahǝbati tomǝlevtor. Namtodǝdasi!” ");
INSERT INTO klv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ale aYesu eus galit ke, “Mǝtukad nabǝta evis? Mitia us kitevi.” Nǝboŋ lototǝlmam lukel uri ke, “Nabǝta erim mai naieh eru.” ");
INSERT INTO klv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Beti aYesu ikele hǝn galit ke letuan naluṽoh lebǝtah pǝpehw len naliol tokǝsan. ");
INSERT INTO klv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ale nǝvanuan lotovi 50 o lotovi 100 lobǝtah b̃onb̃on van vǝbar galit p̃isi lobǝtah. ");
INSERT INTO klv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","AYesu ilav nabǝta torim mai naieh toru, ekǝta vi lan nǝmav, ikel nasipaan hǝn gail ale eb̃ur nabǝta. Ilav gail mai ahai susur san gail hǝn lǝb̃epǝpehuni. Ale epǝpehun naieh eru enan am van hǝn nǝvanuan gail p̃isi. ");
INSERT INTO klv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ale galit p̃isi luhan, luhanukub. ");
INSERT INTO klv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naluṽoh lotohan tonoŋ, ahai susur losǝŋon nahudhubǝta mai nahudhuieh lotopat vagol nǝhad lotovi 12 lopul. ");
INSERT INTO klv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Len nǝboŋ enan alalum̃an lotohan lovi 5,000. ");
INSERT INTO klv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nǝboŋ nǝhanan tonoŋ, vǝha-sua ŋai aYesu igol ahai susur sǝb̃olit lusah len nab̃ot, il a m̃o, hǝn lǝb̃igam vi Petsaita, tarhǝb̃iltiwai Kalili. Ale aYesu esǝvat naluṽoh luvan. ");
INSERT INTO klv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tosudǝlam̃ galit tonoŋ, etǝṽehuh len naṽehuh hǝn b̃isor mai aGot. ");
INSERT INTO klv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nǝboŋ naut togomgom, nab̃ot ipat rivuh len nab̃iltiwai, ale aYesu itoh sǝb̃on a ut. ");
INSERT INTO klv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eris lotomab̃it hǝn nǝvarusan husur nab̃ot isoh b̃ur nǝlan. Len nadudulan som̃ilan naut sǝlan sal, aYesu egǝm hǝn galito, iyar len nǝp̃on nab̃iltiwai. Ike tiṽot tǝban galito, ");
INSERT INTO klv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","be nǝboŋ lotoris toyar len nǝp̃on nab̃iltiwai, lunau ke tovi nanunun sua. Lukai, ");
INSERT INTO klv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","husur nǝboŋ lotorisi galit p̃isi lom̃inm̃inikot. Be vǝha-sua ŋai aYesu ikel mai galit ke, “Samtemǝtahw. Ginau bogai. Mitikad na-il-b̃uri-an.” ");
INSERT INTO klv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ŋa isah len nab̃ot mai galito ale nǝlan evi pan, idar buni. Ahai susur gail lumaŋmaŋ vǝsa, ");
INSERT INTO klv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","husur lǝsalǝboi sal namilen namerikel aYesu togole husur nabǝta gail, bathut nǝkadulit iṽonṽon. ");
INSERT INTO klv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nǝboŋ lotogam tukot len nab̃iltiwai, luvahut a Kennesaret ale lokir ei. ");
INSERT INTO klv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lumariŋ dan nab̃ot, vǝha-sua ŋai nǝvanuan gail len naut enan lokǝta lǝboii. ");
INSERT INTO klv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lugam tutur len naut kavkav enan, ale naut lotosǝsǝloŋ hǝni ke aYesu totoh lan, lupat alat lotomǝsah van hǝni len namilelit gail. ");
INSERT INTO klv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Len naut p̃isi aYesu tovi lan, len navile, len nab̃iltivile, len nǝmarireu, loriŋ alaten lotomǝsah lupat len naut nǝmaket. Loŋiri ke tidam̃ hǝn lǝb̃ibar nasum̃arhǝt nahurabat san. Ale galit p̃isi lotobari lumaur. ");
INSERT INTO klv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Boŋ sua naFarisi mai ahai p̃usan gail hǝn nalo logǝm len naut a Jerusalem hǝn lǝb̃eris aYesu. ");
INSERT INTO klv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lobunus ahai susur galevis siYesu lotohan be lǝsakǝkasǝval. (Navǝlalit saveveu len nǝnauan siFarisi gail ");
INSERT INTO klv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","husur naFarisi mai naJu gail p̃isi am lohusur tin hǝn naṽide silat ta sutuai toke limaskǝkasǝval len naṽide tonor beti lolǝboi lǝb̃ihan. ");
INSERT INTO klv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nǝboŋ lototǝlmam dan nǝmaket, asike luhan vir lǝb̃elilos. Lohusur naṽide tosob̃ur am ta sutuai hum nakǝkasan hǝn nab̃iliwai munmun, nab̃iliwai totile mai naketel gail.) ");
INSERT INTO klv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Imaienan naFarisi mai ahai p̃usan gail hǝn nalo lousi ke, “Imabe ahai susur sam̃ gail lǝsahusur naṽide sihaṽut sidat gail ta sutuai, lǝsahusur naṽide hǝn nakǝkasǝvalan, be luhan nabǝta?” ");
INSERT INTO klv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","AYesu ikel mai galit ke, “Gamit mǝtovi vanuan gǝgǝras, nǝsa mǝtukele, mǝtsagole! AIsaiah ekitin nǝboŋ tokel ur nasoruan siGot husur gamito ke, “‘Nǝvanuan galegai loputsan nahǝsagw len nasoran salito, wake len nǝlolito, lunau ke notovi naut kǝmas. ");
INSERT INTO klv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lulotu sob̃uer hǝn ginau, lop̃usan hǝn nakelean sinǝvanuan, hum tovi lo sagw.’ ");
INSERT INTO klv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Husur gamito mǝtugam dan nakelean todaŋ siGot hǝn mǝtb̃ehusur tin hǝn naṽide samit ta sutuai lotovi nap̃usanan sinǝvanuan ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ale ikele am mai galit ke, “Gamit mǝtukad namitisau hǝn nagelean, husur mǝtugel tabtab hǝn nakelean todaŋ siGot hǝn mǝtb̃eil gǝgat len naṽide samit ta sutuai. Mǝtunau ke nakelean san savi natideh a? ");
INSERT INTO klv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mitinau nǝsa aMoses toke, ‘Putsan atǝmam̃ mai anam̃ matmat len nǝnauan sam̃,’ mai ‘Avan ideh tosor tosa vǝsa hǝn atǝman o anan, gai timasmat tebun.’ ");
INSERT INTO klv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Be gamit mǝtuke ivoi hǝn avan ideh b̃ikel mai atǝman o anan ke, ‘Nǝsa notokade hǝn nǝb̃evi tarhǝt sam̃, noviol hǝni tia mai aGot.’ ");
INSERT INTO klv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Imagenan mǝtuke inor ŋai hǝn asike evi tarhǝt setǝman mai sinan len nam̃idolan sǝlaru. ");
INSERT INTO klv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ale len naṽide ta sutuai mǝttokade, mǝtugol ke nakelean siGot evi naut kǝmas ŋai. Gamit mǝtugol natit isob̃ur tomaienan.” ");
INSERT INTO klv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Beti aYesu ekis naluṽoh gǝmai. Ikel mai galit ke, “Gamit p̃isi, mǝtesǝsǝloŋ hǝn ginau, mǝtelǝboi nategai. ");
INSERT INTO klv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nǝvanuan eb̃iŋb̃iŋal len nǝhon aGot mabe? Sǝkad natideh topat vivile len niben nǝvanuan tolǝboi b̃igol b̃eb̃iŋb̃iŋal nǝboŋ natenan tob̃is lan. Ao, evi nǝsa tovivile dan nǝvanuan togol saveveu.” ");
INSERT INTO klv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nǝboŋ aYesu toriŋ naluṽoh hǝn b̃evi lohoim, ahai susur san gail lous kitev namilen nasoruan kǝta tomadhakele. ");
INSERT INTO klv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ale ikel mai galit ke, “Gamit am mǝtsalǝboi sǝhoti a? Mǝtsalǝboii ke natit p̃isi vivile tob̃is len niben nǝvanuan salǝboi b̃igol b̃eb̃iŋb̃iŋal a? ");
INSERT INTO klv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Husur nǝboŋ tob̃is, sab̃is len nǝlon, be evi lan natǝbaŋ ale evivile vi lan nalitavtav.” (Nǝboŋ tokǝmaienan, aYesu ikele ke nǝhanian p̃isi iveveu.) ");
INSERT INTO klv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Beti aYesu ike, “Evi nǝsa tovivile len nǝlon nǝvanuan togol tosa, saveveu. ");
INSERT INTO klv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Husur natgalegai logǝm len nǝlon nǝvanuan: nǝnauan tosa, naitian tosa, navǝnahan, nagolean hǝn nǝmatan, ");
INSERT INTO klv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naitian tob̃ur kotov nǝlahan, na-lǝŋon-masuṽ-an hǝn natite, nagolean sasa gail, nagǝgǝrasan, naṽide naitian taṽtaṽor, nǝlon tovǝvǝnah, nasoruan tomǝdas nahǝsan nǝvanuan o tomǝdas nahǝsan aGot, nǝ-patpat-gai-mǝhat-an mai namelmelan. ");
INSERT INTO klv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Natgalen p̃isi lotosa logǝm len nǝlon nǝvanuan. Evi natgalenan togol nǝvanuan tob̃iŋb̃iŋal, saveveu.” ");
INSERT INTO klv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","AYesu ile mǝhat, eriŋ naut enan, evi lan naut gail pǝpadaŋ hǝn naut a Tair. Eb̃is lohoim sua, be emǝtahun avan ideh b̃elǝboii ke totoh ei. Be edǝdas b̃esusuan naut totoh lan. ");
INSERT INTO klv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ikad napǝhaṽut sual ei, nanunun nǝmargobut tob̃is len anatvavin. Nǝboŋ nǝbareab enan tosǝsǝloŋ hǝni ke aYesu totoh, vǝha-sua ŋai egǝm hǝni, iteh bathurien. ");
INSERT INTO klv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Evi atob̃taKris lotopasi len naut a Fonisia a Siria. Eus aYesu hǝn b̃ehut natǝmat dan anatvavin. ");
INSERT INTO klv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","AYesu ikel maii ke, “Anatugw gail lihanukub bai. Sanor hǝn nǝb̃ilav kuv nabǝta hinatugw gail hǝn nǝb̃ibar hǝni van hǝn nalipah gail.” ");
INSERT INTO klv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Alitenan isor vari ke, “Evoi Nasub̃, be nalipah gail pipitev am lolǝboi lǝb̃ihan nasugbǝta hilahutai.” ");
INSERT INTO klv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","AYesu ikel maii ke, “Bathut na-sor-vari-an sam̃ tovoi, givan, natǝmat eriŋ anatvavim̃, igam dani tia.” ");
INSERT INTO klv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Alitenan etǝlmam vahim. Ale nǝboŋ tovi lohoim san isab̃i ke, anatvavin topat mǝdau len nǝmel, ale natǝmat tomakuv dani tia. ");
INSERT INTO klv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","AYesu eriŋ naut gail pǝpadaŋ hǝn nab̃iltivile Tair, iyar tur len nab̃iltivile Siton mai naut a Tekap̃olis van vǝbar Nab̃iltiwai Kalili. ");
INSERT INTO klv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nǝvanuan galevis losǝhar nab̃ut sua van hǝn aYesu ale loŋiri hǝn b̃eriŋ navǝlan lan. ");
INSERT INTO klv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","AYesu esǝhar sǝb̃on hǝni vi tut kǝkereh dan naluṽoh ale esiriv hǝn nǝŋarhuvǝlan gǝlaru len nǝdariŋan gǝlaru. AYesu ep̃ulai, ibar namean atenan ");
INSERT INTO klv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ale ekǝta vi mǝhat vi lan nǝmav, ekilob ale ikel mai nab̃ut ke, “Effata!” (namilen ke, “Sǝŋav!”). ");
INSERT INTO klv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vǝha-sua ŋai nǝdariŋan nab̃ut gǝlaru arosǝŋav, namean emǝlala, isor imasil. ");
INSERT INTO klv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ale aYesu ikel buni mai nǝvanuan gail ei ke salikel ur nǝsa tovisi. Be naut kǝmas tokaikai tasi maienan, lukelkel uri am. ");
INSERT INTO klv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Galit lumaŋmaŋ vǝsa. Luke, “Igol ivoi hǝn natit p̃isi togole, ale igol alat lotodariŋ b̃ulol, losǝsǝloŋ mai nab̃ut gail, igol lusor.” ");
INSERT INTO klv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Len nǝboŋ sual am, ikad nab̃iltiluṽoh lotogǝm b̃onb̃on, ale lǝsǝkad natideh hǝn lǝb̃ihani. AYesu ekis ahai susur gail gǝm hǝni, ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nǝlogw itaŋis naluṽoh egai bathut lutah mai ginau husur nǝmariboŋ totor tia ale lǝsǝkad natideh hǝn lǝb̃ihani. ");
INSERT INTO klv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nǝmal ihat galit tia. Nǝb̃esǝvat galit van, dereh limatmatioṽ husur nametp̃isal, ale galit galevis, nap̃isal salit ebǝlav, lutoh a tut.” ");
INSERT INTO klv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ahai susur san gail lusor vari ke, “Be naut egai eb̃ǝb̃esw, ipat sǝb̃on. Avan ideh elǝboi b̃isab̃ nabǝta a be len naut egai tonor hǝn b̃evǝŋan alat eg?” ");
INSERT INTO klv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","AYesu eus galit ke, “Mǝtukad natuhbǝta evis?” Luke, “Emǝlevru.” ");
INSERT INTO klv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Beti aYesu ikel mai naluṽoh ke lebǝtah len tan. Ale itariv nabǝta tomǝlevru, ikel nasipaan, eb̃ur gail, ilav gail mai ahai susur san gail hǝn lǝb̃epǝpehun gail van hǝn naluṽoh. Ale lugole. ");
INSERT INTO klv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ikad natuhieh evis ŋai lotokade. Nǝboŋ aYesu tokel nasipaan hǝn gail, ikel mai ahai susur san gail ke lepǝpehuni am. ");
INSERT INTO klv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nǝvanuan gail luhan vǝhanukub. Ale ahai susur losǝŋon nasughanian topat, gol nǝhad emǝlevru lopul. ");
INSERT INTO klv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ikad alalum̃an lotovi 4,000 ei. Nǝboŋ lotohan tonoŋ, aYesu esǝvat alaten vahim. ");
INSERT INTO klv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ale vǝha-sua ŋai isah len nab̃ot mai ahai susur san gail ale lovi lan naut a Talmanuta. ");
INSERT INTO klv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","NaFarisi gail logǝm hǝn aYesu ale lotub̃at ṽitṽituh maii. Lolǝŋon ke tigol nǝsaban ŋa lous taltal ke tigol namerikel hǝn nǝmav. ");
INSERT INTO klv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nǝboŋ tosǝsǝloŋ hǝn natenan, aYesu eŋud habat, ike, “Naur ta damǝŋai lous namerikel mabe? Nukel nakitinan mai gamit ke, asike nugol namerikel ideh hǝn mǝtb̃erisi boŋ ideh!” ");
INSERT INTO klv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋa isah tǝlmam len nab̃ot, eriŋ naut enan, igam tukot len nab̃iltiwai. ");
INSERT INTO klv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ahai susur gail nǝlolit iboŋboŋ hǝn nabǝta. Lǝsǝkad nǝhanian ideh len nab̃ot, be natuhbǝta sua ŋai. ");
INSERT INTO klv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ale aYesu isor p̃usan mai galito, ike, “Mǝtelǝlǝgau hǝn gamit gabag! Mǝtekǝtkǝta gol gamito dan nayis hiFarisi gail mai nayis hiHerot Antipas.” ");
INSERT INTO klv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nǝboŋ lotosǝsǝloŋ hǝn natenan lotub̃at ṽitṽituh mai galit gabag husur lǝsǝkad nabǝta ideh. ");
INSERT INTO klv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","AYesu elǝboi nǝnauan salit tia, ŋa ike, “Gamit mǝtuhol husur nabǝta mǝtsǝkade hǝn nǝsa? Mǝtsalǝboi sǝhoti, mǝtsasǝsǝloŋ lǝboii a? Nǝkadumit egǝm ṽonṽon a? ");
INSERT INTO klv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mǝtukad namǝtamito be mǝtodǝdas mǝtb̃ekǝta a? Mǝtukad nǝdariŋamito, be mǝtodǝdas mǝtb̃esǝsǝloŋ a? Mǝtsǝnau tǝlmam hǝn ");
INSERT INTO klv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nǝboŋ notob̃ur nabǝta hilat lotovi 5,000 a? Mǝtosǝŋon nasughanian hǝn nǝhad evis lotopul?” Ale lusor vari ke, “Sǝŋavur pisan eru.” ");
INSERT INTO klv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","AYesu eus galit ke, “Ale nǝboŋ notob̃ur nabǝta tomǝlevru hilat lotovi 4,000, mǝtosǝŋon nasughanian hǝn nǝhad evis lotopul?” Ale lusor vari ke, “Mǝlevru.” ");
INSERT INTO klv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ale eus galit ke, “Be mǝtsalǝboi sǝhoti sal a?” ");
INSERT INTO klv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nǝboŋ lotobar naut a Petsaita, nǝvanuan galevis losǝhar ametb̃esw sua van hǝn aYesu, ale loŋir aYesu hǝn b̃ibari hǝn b̃ekǝta. ");
INSERT INTO klv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ale aYesu etǝgau navǝlan ametb̃esw, esǝhari vivile dan navile. Beti ep̃ulai len namǝtan gǝlaru, eriŋ navǝlan gǝlar lan ale eusi ke, “Goris natideh m̃au a?” ");
INSERT INTO klv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ametb̃esw ekǝta tǝlmam, ike, “Noris nǝvanuan lotohum nǝhai lotoyaryar.” ");
INSERT INTO klv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Beti aYesu eriŋ navǝlan gǝlaru tǝtas len namǝtan ametb̃esw. Nakǝtaan etǝlmam ale eris natit p̃isi lumasil. ");
INSERT INTO klv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","AYesu esǝvati vahim, ike, “Sagiyar tur len navile.” ");
INSERT INTO klv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","AYesu mai ahai susur gail loriŋ naut a Kalili, lovi lan navile gail lotodar vis naut a Sisarea Filippi. Len nǝyaran salit van, aYesu eus ahai susur san gail ke, “Nǝvanuan gail luke ginau novi ase?” ");
INSERT INTO klv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lusor vari ke, “Galevis luke gotovi aJon Baptais, galevis am luke Elijah, galevis tile am luke ahai kelkel ur sua ta sutuai.” ");
INSERT INTO klv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Beti eus galit ke, “Be gamito, mǝtunau ke ginau ase?” Ale aPita isor vari ke, “Gaiug govi aKristo, aGot totabtabuh lan.” ");
INSERT INTO klv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ŋa aYesu ikai tas galit ke salikel natenan mai avan ideh. ");
INSERT INTO klv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Len nǝboŋ enan aYesu etub̃at hǝn b̃eṽusan ahai susur san gail ke aNatun Nǝvanuan timaslǝŋon tisa vǝsa len natit tisob̃ur. Alat lotoil a m̃o hǝn nǝvanuan gail, ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo limasmǝtahuni. Timasmat ale len nǝmariboŋ b̃itor timasle mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ikel p̃arp̃ar hǝn natgalenan, ale aPita esǝhar aYesu hǝn b̃isor sǝb̃on maii, etub̃at sor lan husur tokǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","AYesu ipair, eris ahai susur san gail, ale esivoh len aPita, ike, “Gevi tahw dan ginau Setan! Nǝnauan sam̃ gail lǝsǝpat len nǝsa aGot tolǝŋoni, lohusur nalǝŋonian sinǝvanuan ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Beti aYesu ekis naluṽoh mai ahai susur san gail gǝm hǝni. Ikel mai galit ke, “Avan ideh b̃elǝŋon ke b̃ehusur ginau, timaske, ‘Aoa,’ hǝn nǝnauan mai nalǝŋonian san gabag, timasvus nǝhai balbal san, tehusur ginau. ");
INSERT INTO klv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Husur avan ideh b̃elǝŋon ke b̃etǝgau gat nǝmauran san gabag, nǝmauran san dereh timasig. Be nǝmauran san b̃imasig m̃os ginau mai na-kel-uri-an tovoi, dereh tikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nǝvanuan b̃ikad natit p̃isi len navile a pan be nǝmauran san vi sutuai b̃imasig, imabe? Ikad nǝsa? ");
INSERT INTO klv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sǝkad natideh. Nǝvanuan edǝdas b̃eviol hǝn natideh hǝn b̃ikad nǝmauran enan vi sutuai tǝtas am. ");
INSERT INTO klv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Husur avan ideh b̃emǝmau len ginau mai nasoruan sagw len nǝhon naur ta damǝŋ egai lǝsǝdaŋ len aGot be lotopul hǝn nǝsaan, aNatun Nǝvanuan dereh temǝmau len atenan balai nǝboŋ b̃egǝm mai aŋel siGot gail len nǝyalyalan mai namǝnas seTǝman.” ");
INSERT INTO klv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ale ikel mai galit ke, “Nukel nakitinan mai gamit ke gamit galevis mǝttoil gegai, asike lumat van vǝbar lǝb̃eris nagǝmaian hǝn natohan pipihabǝlan aGot, nǝdaŋan han.” ");
INSERT INTO klv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nǝmariboŋ tomǝlevtes tonoŋ aYesu esǝhar aPita, aJemes mai aJon sǝb̃olito vi mǝhat len naṽehuh sua tosahsah. Ale len nǝholito egǝm tile. ");
INSERT INTO klv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nǝhon em̃ial hum namityal, nahurabat san egǝm pǝhw yesyes vabilbil. Epǝhapǝhw sǝhor avan ideh len navile a pan tolǝboi b̃igole. ");
INSERT INTO klv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ale aElijah mai aMoses arovisi hǝn galito. Aruhol mai aYesu. ");
INSERT INTO klv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","APita ikel mai aYesu ke, “Hai p̃usan, ivoi hǝn dattotoh gegai. Namteum hǝn nǝpasvalǝval titor, tesua esam̃, tesua siMoses, mai tesua siElijah.” ");
INSERT INTO klv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(APita ekǝmaienan husur salǝboi nǝsa b̃ikele, husur lomǝtahw habat.) ");
INSERT INTO klv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ale nǝmavukasw ikabut gol galito, nadoldol sua egǝm len nǝmavukasw toke, “Ategai bogai, aNatugw ulum̃an notolǝmas buni. Sǝsǝloŋ husuri!” ");
INSERT INTO klv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Losǝhoṽut, lokǝta garu, lǝsaris aMoses mai aElijah am. Be loris aYesu ŋai totoh mai galit ei. ");
INSERT INTO klv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nǝboŋ lotoput mariŋ dan naṽehuh, ikai tas galit ke saliwal hǝn nǝsa lotorisi mai avan ideh vir aNatun Nǝvanuan b̃ile mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Imaienan lotǝgau gat nǝsa aYesu tokele len galit gabag, be luhol daŋir husur namilen nasoruan san nǝboŋ toke “b̃ile mǝhat dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Beti lous aYesu ke, “Ahai p̃usan gail hǝn nalo luke aElijah timasgǝm a m̃o. Lokǝmaienan hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","AYesu isor var galit ke, “aElijah egǝm a m̃o hǝn b̃igol natit p̃isi b̃inor tǝtas. B̃imaienan, husur nǝsa natosian siGot ike aNatun Nǝvanuan timaslǝŋon tisa vǝsa len natit tisob̃ur ale nǝvanuan gail limasmǝtahuni? ");
INSERT INTO klv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Be nukel mai gamit ke, aElijah egǝm tia, ale lugol nǝsa sum̃an lotolǝŋoni hǝni, hum ŋai natosian siGot tokel husuri.” ");
INSERT INTO klv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nǝboŋ lototǝlmam van hǝn ahai susur san gail, loris nab̃iltiluṽoh lotodar vis galito mai ahai p̃usan gail hǝn nalo lotoṽitṽituh mai galito. ");
INSERT INTO klv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nǝboŋ naluṽoh lotoris aYesu, lup̃aŋ, ale lugam van hǝni hǝn lǝb̃ike, “Ivoi,” maii. ");
INSERT INTO klv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","AYesu eus ahai susur san gail ke, “Mǝtoṽitṽituh mai galit husur nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nǝhaṽut sua len naluṽoh isor vari ke, “Hai p̃usan, nosǝhar anatugw ulum̃an gǝm hǝn gaiug. Ikad nanunun tosa sua togol anatugw tovi nab̃ut. ");
INSERT INTO klv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nǝboŋ natǝmat enan totah gati, ekub̃ hǝn anatugw len tan. Ale nabusun iyau, idesdes batriṽoriṽ, nahumatmat ibari. Nous ahai susur sam̃ gail hǝn lǝb̃ehut natǝmat be lodǝdasi.” ");
INSERT INTO klv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","AYesu ikel mai galit ei ke, “Gamit ta damǝŋai mǝtsǝkad nadǝlomian ideh! Nitoh mai gamit tebǝlav mabe? Mitikad nadǝlomian ŋais? Sǝhar natǝtai gǝmai.” ");
INSERT INTO klv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ale losǝhari van hǝn aYesu. Be nǝboŋ nanunun tosa enan toris aYesu, igol nahumatmat ibar natǝtai, ekub̃ hǝn natǝtai len tan gol italtaloŋ, nabusun iyau. ");
INSERT INTO klv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","AYesu eus atǝman natǝtai ke, “Imaiegai ŋais tia?” Isor vari ke, “Etub̃at len nǝboŋ tovi tuhtǝtai ŋai. ");
INSERT INTO klv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vǝha-sob̃sob̃ur tia natǝmat ekub̃ hǝni len nǝhab o len nǝwai hǝn b̃igol b̃imat. Gǝb̃elǝboi gǝb̃igol natideh, gevi tarhǝt sinamǝru, nǝlom̃ titaŋis ginamǝru.” ");
INSERT INTO klv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","AYesu isor vari ke, “Imabe gotoke ‘Gǝb̃elǝboi gǝb̃igole?’ AGot elǝboi b̃igol natit p̃isi. Gǝb̃ikad nadǝlomian, aGot elǝboi b̃igol natideh m̃os gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Vǝha-sua ŋai atǝman atuhtǝtai ikai ke, “Nukad nadǝlomian, be gevi tarhǝt sagw len nadǝlomian sagw tob̃uer!” ");
INSERT INTO klv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nǝboŋ aYesu toris naluṽoh lotogam gǝm hǝni, esivoh len nanunun tosa, ikel maii ke, “Natǝmat gotob̃ut, gotodariŋ b̃ulol, nukele hǝn gaiug ke, gimakuv dani! Sageb̃is lan boŋ ideh am!” ");
INSERT INTO klv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ale natǝmat eis habat, ekub̃ hǝn natǝtai hum nahumatmat tobari, ale imakuv dani. Natǝtai ehum nab̃irimat gol nǝvanuan isob̃ur ei luke, “Gai imat!” ");
INSERT INTO klv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Be aYesu etǝgau navǝlan natǝtai, elivi vi mǝhat, ale natǝtai eil sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nǝboŋ aYesu tonoŋ ei, evi lohoim ale ahai susur san gail sǝb̃olito logǝm hǝni. Lousi ke, “Imabe namtsalǝboi namtb̃ehut natǝmat enan?” ");
INSERT INTO klv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","AYesu isor var galit ke, “Natǝmat tomaienan, sǝkad natideh tolǝboi b̃ehuti, be na-sor-tuṽ-an ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Beti loriŋ naut enan, luyar tur len naut a Kalili. AYesu emǝtahun avan ideh b̃elǝboi naut lototoh lan, ");
INSERT INTO klv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","husur eṽusan ahai susur san gail. Ikel mai galit ke, “Avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan nǝvanuan gail. Ale dereh ligol timat. Nǝboŋ b̃imat, dereh tile mǝhat len nǝmariboŋ b̃itor husur nǝmatan san.” ");
INSERT INTO klv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Be galit lǝsalǝboi sǝhot namilen nǝsa tokele, ale lomǝtahw, lomǝtahun lǝb̃eusi hǝni. ");
INSERT INTO klv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nǝboŋ aYesu mai ahai susur san gail lotobar naut a Kapernaum, lob̃is lohoim sua. Ale aYesu eus galit ke, “Mǝtoṽitṽituh husur nǝsa len nǝyaran metp̃isal?” ");
INSERT INTO klv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Be naut eb̃ut, bathut metp̃isal loṽitṽituh gabag len galit ke ase len galito iyalyal sǝhor galit p̃isi. ");
INSERT INTO klv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ale aYesu ebǝtah, ekis ahai susur lotovi 12 gǝm hǝni ale ikel mai galit ke, “Avan ideh b̃ike b̃eil a m̃o len nabunusian siGot, temǝdau, timassum̃an naslev, teum salit p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Beti esǝhar natuhtǝtai, igol eil rivuh len galito. Ale elugum̃ gati, ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Avan ideh tohǝhaṽur hǝn natuhtǝtai sum̃an egai b̃itah maii len nahǝsagw, gai ehǝhaṽur hǝn ginau nǝb̃itah maii. Ale avan ideh tohǝhaṽur hǝn ginau nǝb̃itah maii, be savi ginau ŋai, ehǝhaṽur hǝn atenan tosǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ale aJon ikel mai aYesu ke, “Hai p̃usan, namtoris avan sua tohut natǝmat gail len nahǝsam̃, ale namtukai tasi husur savi ginamit ideh.” ");
INSERT INTO klv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ris aYesu toke, “Samtikai tasi! Sǝkad avan ideh tomadhagol namerikel tolǝboi b̃ikel natideh tosa husur ginau. ");
INSERT INTO klv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Avan ideh samǝtahun gidato evi tarhǝt sidato. ");
INSERT INTO klv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nukel nakitinan mai gamit ke, avan ideh b̃ilav nab̃iliwai hǝn nǝwai mai gamit len nahǝsagw husur mǝtovi seKristo, nokitin, aGot dereh tilav nakonp̃urp̃uran mai avan enan. ");
INSERT INTO klv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ale atuhtǝtai tokad nadǝlomian len ginau sum̃an egai, avan ideh b̃igol b̃iteh len nǝsaan, aGot dereh tipansem avan enan sǝhor lǝb̃itahǝtah hǝn nab̃iltivat len naholoan, ale lǝb̃ibar hǝni len tas. ");
INSERT INTO klv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ale navǝlam̃ b̃igol gǝb̃iteh len nǝsaan, gita kotovi. Ivoi am hǝn gǝb̃evi velm̃etw ale b̃is len nǝmauran vi sutuai, sǝhor gǝb̃ikad navǝlam̃ b̃eru ale vi lan nǝhab nǝmatan, nǝhab topaŋ vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ale nariem̃ b̃igol gǝb̃ipes hab̃etw, teh len nǝsaan, gita kotovi. Ivoi am hǝn gǝb̃evi rim̃etw ale b̃is len nǝmauran vi sutuai, sǝhor gǝb̃ikad nariem̃ b̃eru ale vi lan nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ale namǝtam̃ b̃igol gǝb̃iteh len nǝsaan, gekis kuvi. Ivoi am hǝn namǝtam̃ b̃esua b̃ib̃esw ale gǝb̃eb̃is len nǝmauran vi sutuai, sǝhor gǝb̃ikad namǝtam̃ b̃eru ale aGot b̃ibar hǝn gaiug len nǝhab nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Len naut enan naul lotoṽis nǝvanuan, lǝsǝmat boŋ ideh, ale nǝhab tohan nǝvanuan sǝmat boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Husur aGot dereh tiṽaditdit nǝhab len nǝvanuan p̃isi hum datb̃idardar hǝn nǝtas len nǝhanian. ");
INSERT INTO klv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nǝtas ivoi, be nabus han b̃imasig, b̃edub̃e, gigol nabus han tevi tas tǝtas mabe? Len gamit mitimashum nǝtas, hǝn nabus hamit b̃ivoi, hǝn mǝtb̃ikad natǝm̃at mai gamit gabag.” ");
INSERT INTO klv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Beti aYesu eriŋ naut enan, evi lan naut a Jutea, iyar lan tarhǝwisel Jortan. Naluṽoh gail logǝm hǝni, ale husur naṽide san akis, eṽusan galito. ");
INSERT INTO klv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","NaFarisi galevis logǝm hǝni, luke ligol tisab len nasoruan san ŋa lousi ke, “Len nalo, inor hǝn naulum̃an b̃etiṽos hǝn asoan a?” ");
INSERT INTO klv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","AYesu eus galit ke, “Len nalo, aMoses ekǝmabe mai gamito?” ");
INSERT INTO klv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lusor vari ke, “AMoses idam̃ hǝn naulum̃an b̃itos gat nalob̃ulat hǝn natiṽosan ale sǝvat nǝbareab san vi tut dani.” ");
INSERT INTO klv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ris aYesu tokel mai galit ke, “AMoses itos nalo enan m̃os gamito bathut nǝkadumit ihaihai. ");
INSERT INTO klv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Be len natub̃atan, nǝboŋ aGot togol natit p̃isi, ‘igol nǝvanuan, naulum̃an mai napǝhaṽut.’ ");
INSERT INTO klv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Husur natenan, naulum̃an dereh teriŋ atǝman mai anan hǝn b̃eudud mai asoan, ");
INSERT INTO klv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ale aresua sum̃an artovi niben nǝvanuan tosua ŋai.’ Husur arsaru am, arosua ŋai. ");
INSERT INTO klv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Imagenan, naududan aGot togole, nǝvanuan satepǝpehuni.” ");
INSERT INTO klv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nǝboŋ lototǝlmam vi lohoim, ahai susur gail lous aYesu husur natiṽosan. ");
INSERT INTO klv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ale ikel mai galit ke, “Avan ideh totiṽos hǝn abareab san ale tolah mai napǝhaṽut ideh am, atenan igol naitian tob̃ur kotov nǝlahan. ");
INSERT INTO klv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ale napǝhaṽut b̃etiṽos hǝn nǝhaṽut san ale b̃ilah mai naulum̃an ideh am, alitenan igol naitian tob̃ur kotov nǝlahan.” ");
INSERT INTO klv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Boŋ tile am nǝvanuan gail losǝhar atuhlahutai van hǝn aYesu hǝn b̃eriŋ navǝlan len galito. Be ahai susur gail losivoh len atǝmalit mai analit gail. ");
INSERT INTO klv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","AYesu toris natenan, nǝlon ipaŋpaŋ. Ikel mai ahai susur gail ke, “Mitidam̃ hǝn alahutai legǝm hǝn ginau, samtikai tas galito, husur natohan pipihabǝlan aGot evi silat lotosum̃an alategai. ");
INSERT INTO klv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nukel nakitinan mai gamit ke, avan ideh asike b̃ehǝhaṽur hǝn natohan pipihabǝlan aGot sum̃an natuhtǝtai, imabe? Asike ikade boŋ ideh!” ");
INSERT INTO klv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ale len na-lǝmas-buni-an san eriŋ navǝlan gǝlaru dar vis alahutai. Eriŋ navǝlan gǝlar len galito, beti eus aGot hǝn b̃ivoi hǝn galito. ");
INSERT INTO klv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nǝboŋ aYesu toriŋ naut enan, ivan. Len nǝyaran san husur nap̃isal, avan sua igam gǝm hǝni, etǝŋedur bathurien. Eus aYesu ke, “Hai p̃usan gotovoi, nigol nǝsa hǝn nǝb̃ikad nǝmauran vi sutuai?” ");
INSERT INTO klv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","AYesu eusi ke, “Imabe gotokis ginau ke notovoi? Avan ideh savoi, be aGot sǝb̃on ŋai. ");
INSERT INTO klv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gaiug golǝboi nakelean gail lotodaŋ lotoke, ‘Sagigol avan ideh timat, sagigol naitian tob̃ur kotov nǝlahan, sagevǝnah, sageliboŋ len nakotan, sagegǝras avan ideh hǝn gǝb̃ikad natideh esan, geputsan atǝmam̃ mai anam̃ len nǝnauan sam̃.’” ");
INSERT INTO klv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ale ikel mai aYesu ke, “Hai p̃usan, nugol natgalen p̃isi tia, tub̃at len nǝboŋ notovi natǝtai.” ");
INSERT INTO klv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","AYesu ekǝta bunusi, elǝmas buni. Ale ikel maii ke, “Gupar tetesua sal. Gia p̃ur hǝn natit p̃isi gotokade. Viol hǝn nǝvat han mai namǝsal gail hǝn gǝb̃ikad nakonviolan aGot totǝgau gati m̃os gaiug len nǝmav. Beti gegǝm husur ginau.” ");
INSERT INTO klv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nǝboŋ atenan tosǝsǝloŋ hǝn nasoruan enan, nǝhon emǝraŋraŋ. Elǝŋon isa, ivan husur topul hǝn natit tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Beti aYesu ekǝta garu, ikel mai ahai susur san gail ke, “Idaŋ habat hǝn avan topul hǝn natite b̃eb̃is len natohan pipihabǝlan aGot!” ");
INSERT INTO klv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lup̃aŋ habat len nasoruan san. Be aYesu ikel tasi am mai galito. Ike, “Anatugw notolǝmas bun gamito, idaŋ habat hǝn avan ideh b̃eb̃is len natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Idaŋ habat hǝn nǝkamel b̃eb̃is tur len nab̃urhunil sǝsod. Idaŋ sǝhori am hǝn nǝvanuan tokad natite b̃eb̃is len natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nǝboŋ tokǝmaienan, lup̃aŋ habat am. Lusorsor mai galit gabag ke, “B̃imaienan, as teb̃is lan? Sǝkad avan ideh b̃ikad nǝmauran vi sutuai!” ");
INSERT INTO klv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","AYesu ekǝta bunus galito, ike, “Len nǝvanuan gail, galit lodǝdas lǝb̃igol natenan, avil aGot elǝboi b̃igol natit p̃isi.” ");
INSERT INTO klv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Beti aPita isor vari ke, “Geris, ginamit namtoriŋ natit p̃isi hǝn namttohusur gaiug.” ");
INSERT INTO klv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","AYesu ike, “Nukel nakitinan mai gamit ke, avan ideh toriŋ naim o aṽan gail o aṽavinen gail o atata o anana o anatun gail o nǝtan m̃os ginau mai na-kel-uri-an tovoi, ");
INSERT INTO klv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dereh aGot teviol hǝn natgalenan vǝha 100 maii len nǝboŋ eg ta damǝŋai. Dereh tikad naim gail, aṽan gail, aṽavinen gail, anan gail, anatun gail, nǝtan isob̃ur mai alat lǝb̃emǝdas buni. Ale len nǝboŋ b̃egǝmai len nǝmav, dereh tikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Be nǝvanuan isob̃ur lototibau gagai, lotoil a m̃o, dereh asike lovi natideh, levi ut kǝmas; ale isob̃ur lǝsavi natideh gagai, lotovi ut kǝmas, dereh letibau, leil a m̃o.” ");
INSERT INTO klv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Len nǝyaran salit len nap̃isal vi Jerusalem, aYesu iŋad il a m̃o. Ale ahai susur gail lup̃aŋ lan, ale alat lotohusuri lomǝtahw. Ale aYesu esǝhar ahai susur lotovi 12 vi tarhǝte. Etub̃at kel mai galit hǝn natit gail lǝb̃evisi hǝni asike idareh. ");
INSERT INTO klv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ike, “Mǝtesǝsǝloŋ! Datevi mǝhat vi Jerusalem. Len naut enan avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan ab̃iltihai tutumav mai ahai p̃usan gail hǝn nalo. Ale len nakotan salito dereh lisab̃ sǝhoti ke tipanis, timat. Ale dereh leriŋi len navǝlan alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dereh lisor vilesi, leṽulaii, lebilas habat hǝni ale ligol timat. Len nǝmariboŋ b̃itor husur nǝmatan san, dereh tile mǝhat.” ");
INSERT INTO klv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Beti aJemes mai aJon, anatun aSepeti gǝlaru, arogǝm hǝn aYesu. Aruke, “Hai p̃usan, natideh namrb̃eusi hǝn gaiug, namruke gigole m̃os ginamǝru.” ");
INSERT INTO klv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eus gǝlaru ke, “Mǝruke nigol nǝsa m̃os gamǝru?” ");
INSERT INTO klv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Arusor vari ke, “Gidam̃ hǝn ginamǝr tesua tebǝtah len nǝmatu sam̃ mai togon tebǝtah len nǝmair sam̃ nǝboŋ gǝb̃egǝm vi kiŋ.” ");
INSERT INTO klv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ale aYesu ikel mai gǝlaru ke, “Gamǝru mǝrsalǝboi nǝsa mǝrtousi. Mǝrolǝboi mǝrb̃emun len nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an nǝb̃emun lan a? Mǝrolǝboi mǝrb̃ibaptais len nǝbaptaisan nǝb̃ibaptais lan a?” ");
INSERT INTO klv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Arusor vari ke, “Namrolǝboi namrb̃igole.” Beti aYesu ikel mai gǝlaru ke, “Nab̃iliwai nǝb̃emun lan, dereh mǝremun lan. Nǝbaptaisan nǝb̃ibaptais lan, dereh miribaptais lan. ");
INSERT INTO klv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Be nabǝtahan len nǝmatu sagw o len nǝmair sagw, savi len ginau hǝn nǝb̃ikele. Ipat len aGot hǝn b̃ilav naut eruenan mai galit gai toutaut hǝn naut eruenan m̃os galito.” ");
INSERT INTO klv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nǝboŋ ahai susur lotosǝŋavur lotosǝsǝloŋ hǝn natenan, nǝlolit epǝŋas aJemes mai aJon. ");
INSERT INTO klv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ŋa aYesu ekis galit gǝm hǝni, ikel mai galit ke, “Mǝtolǝboii ke alat lotoṽat nǝhes hǝn lǝb̃eil a m̃o hǝn nametb̃os gail, lupatpat galit mǝhat len nǝdaŋan lotokade tǝban nǝvanuan salit gail. Ale len nǝdaŋan hǝn na-il-a-m̃o-an, nǝvanuan totibau salito, loil a m̃o hǝn nǝvanuan salit gail. ");
INSERT INTO klv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Be sǝmaienan len gamito. Gamit ideh toke tevi vanuan totibau, gai timasgǝm vi vanuan na-vi-tarhǝte-an samito, nǝlon tomǝdau hum tovi ut kǝmas ŋai. ");
INSERT INTO klv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ale gamit ideh toke teil a m̃o hǝn gamito, gai tegǝm vi slev samit p̃isi. ");
INSERT INTO klv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tesum̃an ŋai aNatun Nǝvanuan. Gai sagǝm hǝn nǝvanuan gail hǝn lǝb̃evi tarhǝt san hum galit lotovi ut kǝmas. Ao, egǝm hǝn b̃evi tarhǝt salito hum gai tovi ut kǝmas; egǝm hǝn b̃eviol hǝn nǝmauran san, egǝm hǝn b̃imat m̃os nǝmakuvan hǝn nǝvanuan tosob̃ur dan nǝpanismen sil nǝsaan salito.” ");
INSERT INTO klv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Beti aYesu mai ahai susur san gail lubar naut a Jeriko. Ale nǝboŋ lotoriŋ nab̃iltivile enan, nab̃iltiluṽoh lohusur galito. Ametb̃esw, ebǝtah len nǝgarhǝp̃isal. (Nahǝsan aPartimeus, namilen ke anatun aTimeus. Atenan eŋir nǝvanuan gail akis hǝn nǝvat.) ");
INSERT INTO klv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nǝboŋ tosǝsǝloŋ hǝni ke aYesu ta Nasaret togǝmai, etub̃at kai ke, “Yesu, anatun siTevit, nǝlom̃ titaŋis ginau!” ");
INSERT INTO klv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nǝvanuan isob̃ur losivoh lan hǝn b̃emǝdau. Be ikai habat am ke, “Anatun siTevit, nǝlom̃ titaŋis ginau!” ");
INSERT INTO klv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nǝboŋ aYesu tosǝsǝloŋ hǝni, eil. Ike, “Kisi gǝmai!” Ale lokis ametb̃esw ke, “Gehǝhaṽur! Gele mǝhat! Ekis gaiug, gia van hǝni!” ");
INSERT INTO klv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ametb̃esw eb̃il kuv nahurabat naut susus san, ile mǝhat tutut, ivan hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","AYesu eusi ke, “Golǝŋon nǝsa hǝn nǝb̃igole m̃os gaiug?” Ametb̃esw isor vari ke, “Hai p̃usan, nuke nekǝta!” ");
INSERT INTO klv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ale aYesu ikel maii ke, “Givan! Nadǝlomian sam̃ igol gumaur.” Vǝha-sua ŋai ekǝta, ale ehusur aYesu husur nap̃isal. ");
INSERT INTO klv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nǝboŋ aYesu mai ahai susur san gail lotogǝm pǝpadaŋ hǝn naut a Jerusalem, pǝpadaŋ hǝn navile Petfas, mai a Petani, lubar Naṽehuh Oliv. Ale aYesu esǝvat ahai susur san eru van. ");
INSERT INTO klv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ikel mai gǝlar ke, “Mǝrevi lan navile ea. Nǝboŋ mǝrb̃ibari, vǝha-sua ŋai dereh mǝrekǝta ris natuhtoŋki ulum̃an totahǝtah ei, avan ideh sǝsah lan sal. Sah rub̃ati ale sǝhari gǝmai. ");
INSERT INTO klv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Avan ideh b̃eus gamǝru ke, ‘Mirimab hǝn natenan?’ Kel maii ke, ‘Nasub̃ eusi gag ŋai be asike idareh tesǝvat tǝlmam hǝni.’” ");
INSERT INTO klv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ale gǝlaru aruvan. Arusab̃ natuhtoŋki toil metp̃isal totahǝtah len nabopita naim sua, ale arusah rub̃ati. ");
INSERT INTO klv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nǝboŋ artosah rub̃ati, nǝvanuan galevis lotoil ei luke, “Natuhtoŋki enan, mǝrusah rub̃ati hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Beti arusor var galit hum aYesu tokel mai gǝlaru, ale ludam̃ hǝn arb̃esǝhari van. ");
INSERT INTO klv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Arosǝhar natuhtoŋki van hǝn aYesu, arob̃ir hǝn nahurabat salito len nǝmadun ale aYesu ebǝtah sǝŋaṽuti. ");
INSERT INTO klv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ale nǝvanuan isob̃ur luṽolsan nahurabat salit gail husur nap̃isal, nǝvanuan tile gail ludas pashǝhai lotobaŋ lute marireu, lutaii, loriŋ gail husur nap̃isal. ");
INSERT INTO klv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Alat lotoyar a m̃o hǝn aYesu mai alat lotoyar a tahw lukai habat ke, “Hosanna! AGot ivoi hǝn atenan togǝm len nahǝsan Nasub̃! ");
INSERT INTO klv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","AGot tivoi hǝn natohan togǝmai, natohan pipihabǝlan atǝmadat aTevit. Hosanna! Sal suh aGot len nǝmav a mǝhat buni!” ");
INSERT INTO klv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Beti aYesu eb̃is len naut a Jerusalem, ale evi lan naim siGot. Ekǝta garu len natit p̃isi, be husur namityal igam gole tia, eriŋ naut enan, esǝhar ahai susur lotovi 12 vi Petani. ");
INSERT INTO klv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pelan han, dudulan, nǝboŋ lotoriŋ naut a Petani, aYesu imalkǝkat. ");
INSERT INTO klv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A tut sal eris nǝhai nafik sua tokǝsan buni. Ale aYesu ivan hǝn b̃isab̃ naṽite lan. Be nǝboŋ tobar nǝhai enan, sǝsab̃ natideh lan, be naluhai ŋai, husur savi nǝboŋ hǝn naṽit nafik sal. ");
INSERT INTO klv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Beti aYesu ikel mai nǝhai enan ke, “Avan ideh satihan naṽit gaiug boŋ ideh am!” Ale ahai susur gail losǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nǝboŋ lotobar naut a Jerusalem, aYesu eb̃is len naholǝvat todar vis naim siGot. Etub̃at hut alat lotop̃ur hǝn natit gail mai alat lotoṽur natit gail ei. Ikovsan natev gail silat lotogǝgel hǝn nǝvat mai nǝhai bǝtbǝtah silat lotop̃ur hǝn nǝtav gail lotovi man namǝsav. ");
INSERT INTO klv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ale aYesu sǝdam̃ hǝn avan ideh topat natideh b̃iyar tur len naut siGot. ");
INSERT INTO klv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Beti ep̃usan. Ikel mai galit ke, “Len natosian siGot ike, ‘Naim sagw dereh lekisi hǝn naim na-sor-tuṽ-an sinaluṽoh hǝn nǝvanuan naut tiltile gail.’ Be gamit mǝtugol evi ‘naut susuah sinǝvanuan vǝnvǝnah gail.’” ");
INSERT INTO klv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nǝboŋ ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo lotosǝsǝloŋ hǝn natenan, ludas p̃isal hǝn lǝb̃igol aYesu b̃imat. Lomǝtahw lan husur naluṽoh p̃isi lotop̃aŋ len nap̃usanan san. ");
INSERT INTO klv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nǝboŋ naut togomgom, aYesu mai ahai susur san gail lovivile dan nab̃iltivile. ");
INSERT INTO klv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Len nadudulan luyar van, ṽot pǝpadaŋ len nǝhai nafik aYesu tosor lan. Loris ke toŋod vǝbar nǝharhǝte len tan. ");
INSERT INTO klv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","APita inau tǝlmam hǝn nǝsa aYesu tokele, ale ike, “Hai p̃usan, geris, nǝhai nafik gotosivoh lan iŋod.” ");
INSERT INTO klv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ŋa aYesu isor vari, ikel mai galit ke, “Mitikad nadǝlomian len aGot. ");
INSERT INTO klv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nukel nakitinan mai gamit ke, avan ideh b̃ikel mai naṽehuh egai ke, ‘Gimakuv, bar hǝn gaiug len tas!’ ale asike b̃ikad nǝ-lon-uri-an, be b̃edǝlomi ke nǝsa tokele dereh tevisi, ale dereh timaienan m̃os atenan. ");
INSERT INTO klv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Imaienan, nukel mai gamit ke, natideh mǝttousi len na-sor-tuṽ-an, dǝlomi ke mǝtukade tia ale dereh timaienan len gamito. ");
INSERT INTO klv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ale nǝboŋ mǝttoil, mǝttosor tuṽ, natideh avan ideh togol tosa hǝn gamito, mǝterub̃ati dani, hǝn aTǝmamito len nǝmav b̃erub̃at nǝsaan samit am.” ");
INSERT INTO klv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nǝboŋ aYesu mai ahai susur gail lotobar naut a Jerusalem tǝtas, aYesu iyaryar len naholǝvat todar vis naim siGot. Ale ab̃iltihai tutumav gail, ahai p̃usan gail hǝn nalo mai alat lotoil a m̃o hǝn nǝvanuan gail logǝm hǝni. ");
INSERT INTO klv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lous taltal hǝni ke, “Gukad nǝdaŋan hǝn na-il-a-m̃o-an tomabe hǝn gotogol natgalen p̃isi? Ase ilavi mai gaiug hǝn gǝb̃igol gail?” ");
INSERT INTO klv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","AYesu isor var galit ke, “Neus natsua bai. Mǝtb̃isor vari, dereh nikel mai gamito hǝn nǝdaŋan na-il-a-m̃o-an notokade hǝn notogol natgalenan. ");
INSERT INTO klv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kel mai ginau, na-il-a-m̃o-an aJon tokade hǝn tobaptais, egǝm len nǝmav o egǝm len nǝvanuan? Mitikele!” ");
INSERT INTO klv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lusor kitevi len galit gabag, luke, “Datb̃ike, ‘len nǝmav,’ dereh tike, ‘b̃imaienan, imabe mǝtsadǝlom aJon?’ ");
INSERT INTO klv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Be datb̃ike, ‘len nǝvanuan,’ nǝsa tevisi? Sadatikele.” Lokǝmaienan husur lotomǝtahw len naluṽoh husur len nabunusian sinǝvanuan p̃isi, aJon evi ahai kelkel ur kitin. ");
INSERT INTO klv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ŋa lusor var aYesu ke, “Namtsalǝboii.” Beti aYesu ikel mai galit ke, “Mǝtb̃ekǝmaienan, asike nukel mai gamit hǝn nǝdaŋan na-il-a-m̃o-an notokade hǝn nǝb̃igol natgalenan.” ");
INSERT INTO klv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Beti aYesu etub̃at sor mai galito len nǝb̃ol p̃usan. Ikel mai galit ke, “Boŋ sua avan sua imabul nakrep len nǝhol. Eum hǝn nǝṽod garu lan. Ehir nab̃ur hǝn b̃egǝm vi naut lotopal dasdas nakrep lan, ale eum hǝn naut nakǝtaan tǝban nakrep a mǝhat. Beti idam̃ hǝn nǝhol van hǝn alat lotokǝtkǝta tǝban nǝhol hǝn lǝb̃irentem, ale eriŋ naut enan itoh len nǝyaran sua. ");
INSERT INTO klv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nǝboŋ nakrep pǝpadaŋ hǝn b̃imen, amahean nǝhol esǝvat naslev san van hǝn alat lotorentem nǝhol hǝn lǝb̃epǝpehun naṽit nakrep galevis tovi esan. ");
INSERT INTO klv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Avil alat lotorentem nǝhol lutah gat naslev san, luṽasi ale losǝvati van, iyar sǝsǝlav tǝlmam. ");
INSERT INTO klv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ale amahean nǝhol esǝvat naslev tile van hǝn galito. Be alat lotorentem nǝhol luṽasṽas nǝkadun, lugol isa habat hǝn naslev gol nahurun isa lan. ");
INSERT INTO klv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ale amahean nǝhol esǝvat naslev tile am van hǝn galito, be luparu buni. Amahean esǝvat isob̃ur am, be luṽas galevis mai luparu bun galevis am. ");
INSERT INTO klv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Amahean nǝhol sǝkad naslev ideh am hǝn b̃esǝvati, be ikad anatun tosua ŋai tolǝmas buni. Esǝvat mǝkot hǝni van hǝn galito, ike, ‘Dereh leputsan anatugw ulum̃an len nǝnauan salito.’ ");
INSERT INTO klv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Be alat lotorentem nǝhol lukel mai galit gabag ke, ‘Atea, dereh tikad nǝhol egai nǝboŋ amahean nǝtan b̃imat. Datia paru buni hǝn datb̃ikad natit p̃isi b̃evi esan nǝboŋ atǝman b̃imat.’ ");
INSERT INTO klv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ŋa lutah gati, luparu buni, ale lubar hǝni vivile dan nǝhol nakrep.” ");
INSERT INTO klv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ale aYesu ike, “Ale, amahean nǝhol nakrep dereh tigol nǝsa? Dereh tegǝm ṽabun alat lotorentem nǝhol, beti tidam̃ hǝn nǝvanuan tile gail lirentem nǝhol nakrep. ");
INSERT INTO klv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mǝtsaṽuruŋ nategai len natosian siGot a? Ike, “‘Nǝvat nǝvanuan na-um-im-an gail lotomǝtahuni, gai egǝm vi vat sua ŋai b̃elǝboi b̃igol naim b̃ihav mai b̃inor. ");
INSERT INTO klv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Evi Nasub̃ aGot togol natenan ale nǝboŋ dattorisi, datumaŋmaŋ len nǝsa togole.’” ");
INSERT INTO klv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Beti ab̃iltivanuan hǝn naJu ludas p̃isal hǝn lǝb̃itah gat aYesu bathut lolǝboii ke tokel nǝb̃ol p̃usan enan sil galito. Be lomǝtahw len naluṽoh ŋa loriŋ aYesu, luvan. ");
INSERT INTO klv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Beti ab̃iltivanuan hǝn naJu lotodas p̃isal hǝn lǝb̃itah gat aYesu, losǝvat naFarisi galevis mai galevis len nǝpati tovi tarhǝt siHerot van hǝn aYesu hǝn lǝb̃igol b̃isab len nasoruan san. ");
INSERT INTO klv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Logǝm hǝn aYesu ale lukel maii ke, “Hai p̃usan, namtolǝboii ke gotokitin. Nǝvanuan b̃etibau o b̃evi naut kǝmas savi natideh len gaiug. Goṽusan nap̃isal siGot len nakitinan. Gikele, inor m̃au hǝn datb̃eṽur nǝtaks van hǝn aSisa? ");
INSERT INTO klv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dateṽuri o asike datoṽuri?” AYesu elǝboi sǝhot nausian gǝgǝras lotousi hǝni. Ale ikel mai galit ke, “Imabe mǝtous kitev ginau hum mǝtb̃igol nǝb̃isab len nasoruan sagw? Ṽusan ginau hǝn natenarius tovi nakoin hǝn nǝtaks.” ");
INSERT INTO klv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nǝboŋ lotolav nakoin gǝmai, eus galit ke, “Nǝhon ase gagai? Nahǝsan ase ipat lan?” Luke, “ASisa.” ");
INSERT INTO klv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Beti aYesu ikel mai galit ke, “Lav mai aSisa nǝsa tovi seSisa ale lav mai aGot nǝsa tovi siGot.” Nǝboŋ lotosǝsǝloŋ hǝni, lup̃aŋ habat len na-sor-vari-an san. ");
INSERT INTO klv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Beti naSattiusi galevis lotokel ke na-le-mǝhat-an dan nǝmatan tob̃uer, logǝm hǝn aYesu. Lousi ke, ");
INSERT INTO klv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Hai p̃usan, aMoses itos gat nategai m̃os gidato ke, aulum̃an b̃imat, ale asoan b̃itoh anatun b̃eb̃uer, aṽan matmat tilah mai nǝbatunau enan hǝn b̃ipas anatun aṽan tomat. ");
INSERT INTO klv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ale ikad alatmiṽan lotomǝlevru. Ahai a m̃o ilah be imat, anatun eb̃uer. ");
INSERT INTO klv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aṽan tohusuri ilah mai nǝbatunau ale gai am imat, anatun eb̃uer. Aṽalar tohusur gǝlaru am imaienan. ");
INSERT INTO klv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Alatmiṽan p̃isi lulah mai napǝhaṽut enan be lǝsǝkad anatulit ideh. Namǝkot alitenan tu imat. ");
INSERT INTO klv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ale len nǝboŋ hǝn na-le-mǝhat-an dan nǝmatan, alitenan dereh tevi asoan ase? Husur galit lotomǝlevru p̃isi lulah maii.” ");
INSERT INTO klv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","AYesu isor var galit ke, “Mǝtusab husur mǝtsalǝboi natosian siGot, mai mǝtsalǝboi nǝdaŋan san. ");
INSERT INTO klv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Husur nǝboŋ alat lotomat lǝb̃ile mǝhat, asike lulah, avan ideh asike idam̃ hǝn lǝb̃ilah. Be dereh lesum̃an aŋel gail len nǝmav. ");
INSERT INTO klv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Be mitinau alat lotomat nǝboŋ lǝb̃ile mǝhat. Mǝtsaṽuruŋ natosian len nalob̃ulat siMoses tohusur nǝhai topaŋ a? AGot isor mai a Moses, ike, ‘Gagai ginau novi aGot siApraham, aGot seIsak, aGot siJakop.’ ");
INSERT INTO klv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gai savi aGot silat lotomat, be silat lotomaur. Gamit mǝtusab habat!” ");
INSERT INTO klv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ahai p̃usan sua hǝn nalo tosǝsǝloŋ hǝn na-sor-b̃alb̃al-an enan egǝm hǝn aYesu. Elǝboi sǝhoti ke na-sor-vari-an siYesu ivoi ŋa eusi ke, “Len nakelean todaŋ gail aGot tokel mai gidato, ta be esǝhor gail p̃isi?” ");
INSERT INTO klv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","AYesu isor vari ke, “Nakelean egai esǝhor gail p̃isi: ‘Israel mǝtesǝsǝloŋ! Nasub̃ aGot sidato, Nasub̃ esua sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gelǝmas bun Nasub̃ aGot sam̃ len nǝlom̃ kavkav, nanunum̃ kavkav, nǝnauan sam̃ kavkav mai nǝdaŋan sam̃ kavkav; len gaiug kavkav.’ ");
INSERT INTO klv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nakelean sual am ehusuri toke, ‘Gelǝmas bun nǝvanuan totoh pǝpadaŋ hǝn gaiug hum gotolǝmas bun gaiug gabag.’ Sǝkad nakelean ideh todaŋ sǝhor eru enan.” ");
INSERT INTO klv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ahai p̃usan enan hǝn nalo ike, “Gai bolai Hai p̃usan! Gokitin nǝboŋ gotoke aGot tosua sǝb̃on ale sǝkad ideh am be gai sǝb̃on ŋai. ");
INSERT INTO klv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Datimaslǝmas buni len nǝlodat kavkav, nalǝboian sidat kavkav mai nǝdaŋan sidat kavkav; len gidat kavkav. Ale datimaslǝmas bun nǝvanuan totoh pǝpadaŋ hǝn gidato hum dattolǝmas bun gidat gabag. Ivoi hǝn datb̃igol natgalenan sǝhor naviolan ideh datb̃etutumav hǝni mai natit p̃isi am datb̃eviol hǝni mai aGot.” ");
INSERT INTO klv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nǝboŋ aYesu tosǝsǝloŋ hǝn na-lǝboi-sǝhoti-an len na-sor-vari-an sitenan, ikel maii ke, “Gaiug gǝsatoh a tut dan natohan pipihabǝlan aGot.” Ale len nǝboŋ enan van, sǝkad avan ideh tokad na-il-b̃uri-an hǝn b̃eus nausian ideh hǝni am. ");
INSERT INTO klv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nǝboŋ aYesu top̃usan len naholǝvat todar vis naim siGot, eus galit ei ke, “Imabe ahai p̃usan gail hǝn nalo luke aKristo, aGot totabtabuh lan, esua len nǝpasusan siTevit, anatun siTevit? ");
INSERT INTO klv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Husur len aNunun aGot, aTevit ike, “‘Nasub̃ aGot ikel mai aMasta sagw ke, “Gebǝtah tǝban ginau, len navǝlagw nǝmatu vir nǝb̃eriŋ aenemi sam̃ gail pipit nariem̃ gǝlaru hǝn lǝb̃evi ut kǝmas.”’ ");
INSERT INTO klv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ATevit m̃au ekisi hǝn ‘aMasta.’ Imaienan, imabe evi anatun siTevit?” Nab̃iltiluṽoh lohǝhaṽur hǝn lotosǝsǝloŋ hǝn aYesu tokǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ale len nap̃usanan siYesu ike, “Mǝtelǝlǝgau. Ahai p̃usan gail hǝn nalo salemǝdas gamito. Lolǝmas lǝb̃esun nahurabat tobǝlav. Lolǝmas nǝvanuan lǝb̃ike, ‘Ivoi’ mai galito len naut nǝmaket. ");
INSERT INTO klv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lolǝmas lǝb̃ebǝtah len nǝhai bǝtbǝtah tovoi ŋai len naim nab̃onb̃onan. Ale lolǝmas lǝb̃ebǝtah rivuh len nǝhanan gail. ");
INSERT INTO klv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lulav kuv p̃is naim mai nasugsugur sibatunau pǝhaṽut gail, be len nagǝgǝrasan salito len nǝhon nǝvanuan gail, lusor tuṽ ebǝbǝlav. Alatenan dereh lipanis sǝhor alat lǝsǝmaienan.” ");
INSERT INTO klv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nǝboŋ aYesu tokǝmaienan tonoŋ, ebǝtah pǝpadaŋ hǝn nabokis topat ei, nǝvanuan gail lotobubulah vat lan len naim siGot. Ekǝta bunus nǝvanuan gail nǝboŋ lotobubulah vat salito len nabokis enan. Nǝvanuan isob̃ur lotopul hǝn nǝvat lobulan isob̃ur lan. ");
INSERT INTO klv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Be nǝbatunau namǝsal sua egǝm riŋ natuhkoin eru artovi kopa. ");
INSERT INTO klv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Beti aYesu ekis ahai susur san gail gǝm hǝni. Ike, “Nukel nakitinan mai gamit ke, nǝbatunau namǝsal enan, nabulahan san esǝhor galit p̃isi am lotobubulah vi lan nabokis enan. ");
INSERT INTO klv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Husur galit loviol kinit nǝvat dan tosob̃ur lotopul hǝni. Be alitenan, naut kǝmas tovi mǝsal, eviol hǝn natit p̃isi san hǝn b̃imaur lan.” ");
INSERT INTO klv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nǝboŋ aYesu toriŋ naholǝvat todar vis naim siGot, ahai susur sua san ikel maii ke, “Geris! Hai p̃usan geris nab̃iltivat galegai! Geris nab̃iltiim gail!” ");
INSERT INTO klv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","AYesu ikel maii ke, “Ivoi. Goris nab̃iltiim galegai, be dereh gail p̃isi limasirsir, asike ikad nǝvat ideh b̃epǝlah len nǝvat ideh am.” ");
INSERT INTO klv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ale aYesu evi lan Naṽehuh Oliv, ebǝtah, ekǝta tukot van hǝn naim siGot. APita, aJemes, aJon, aAdru logǝm sor sǝb̃olit maii. ");
INSERT INTO klv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Lousi ke, “Gikel mai ginamito. Natgalen gotokele, levisi ŋais? Dereh tikad nǝsa b̃eṽusani ke natgalen p̃isi pǝpadaŋ lisarpoh?” ");
INSERT INTO klv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","AYesu isor var galito. Ike, “Mǝtelǝlǝgau hǝn gamito. Avan ideh sategǝras gamito. ");
INSERT INTO klv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nǝvanuan tisob̃ur dereh legǝm len nahǝsagw, like, ‘Ginau bogai, aKristo.’ Ale dereh legǝras nǝvanuan tisob̃ur am. ");
INSERT INTO klv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Be mǝtb̃esǝsǝloŋ hǝn nǝb̃alan mai na-kel-uri-an hǝn nǝb̃alan gail, sa-nǝlomit tetuhatuh. Natgalenan limasvisi, be nǝboŋ namǝkot sagǝm sal. ");
INSERT INTO klv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Naluṽoh hǝn nǝvanuan naut sua dereh ligol nab̃iltib̃alan mai naluṽoh hǝn nǝvanuan naut tile, ale nǝvanuan sekiŋ gail dereh lib̃al mai nǝvanuan sekiŋ tile gail. Dereh tikad nab̃iltidu gail husur naut gail. Ale dereh nǝhanian teb̃uer len naut gail. Natgalenan lohum natub̃atan hǝn napǝŋasan hǝn nǝpasusan. ");
INSERT INTO klv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Be mǝtelǝlǝgau hǝn gamito. Dereh likot hǝn gamito len nǝkaunsel gail. Ale len naim nab̃onb̃onan dereh lebilas habat hǝn gamito. Ale dereh mǝteil len nǝhon nǝgavna mai nakiŋ gail m̃os ginau hǝn mǝtb̃ikel kot ginau len nǝholito. ");
INSERT INTO klv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","A tahw hǝn nǝboŋ namǝkot, nǝvanuan sagw gail dereh limaskel ur na-kel-uri-an tovoi mai naluṽoh hǝn nǝvanuan naut tiltile p̃isi. ");
INSERT INTO klv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nǝboŋ lǝb̃itah gat gamito, kot hǝn gamito, samtinau masuṽ hǝn nǝsa mǝtb̃ikele. Len namityal enan mitikel nǝsa aGot b̃ikel mai gamit ŋai. Husur savi gamit mǝtb̃isor be aNunun aGot dereh tisor. ");
INSERT INTO klv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nǝvanuan dereh teriŋ aṽan len navǝlan alat lotoil a m̃o hǝn b̃imat, atata dereh timagen hǝn anatun hǝn b̃imat, ale alahutai dereh lile mǝhat, pair dan analito mai atǝmalito hǝn nakotan b̃eriŋ alatmisoan gail lǝb̃imat. ");
INSERT INTO klv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nǝvanuan p̃isi dereh lemǝtahun bun gamito bathut nahǝsagw mǝttokade. Avil avan ideh b̃idaŋ len ginau, b̃ikad nǝ-daŋ-b̃uri-an van vǝbar nagilen, dereh aGot tilav kuvi hǝn b̃ikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nǝboŋ mǝtb̃eris natit aGot tomǝtahun buni, natit tosa masuṽ tomǝdas bun natit isob̃ur, nǝboŋ mǝtb̃eris toil len naut sanor hǝn toil lan, (gaiug gotoṽuruŋ nategai geṽuruŋ lǝboii), beti alat len naut a Jutea, ligam tutut vi lan naṽehuh gail. ");
INSERT INTO klv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nǝvanuan b̃iŋavŋav mǝhat len navurun naim, timasgam tutut dan naim san, satevi pan hǝn b̃eb̃is lohoim hǝn b̃ilav kuv natideh. ");
INSERT INTO klv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ale nǝvanuan b̃itoh marireu, satetǝlmam vahim hǝn b̃ilav nahurabat ideh. ");
INSERT INTO klv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Len nǝboŋ enan nǝmauran dereh tidaŋ vǝsa habat hǝn apǝhaṽut ideh totian o tovǝhasus. ");
INSERT INTO klv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Be mitisor tuṽ ke natgalenan salevisi len nahǝbati naut susus. ");
INSERT INTO klv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Husur len nǝboŋ natgalen lǝb̃evisi, na-lǝŋon-isa-vǝsa-an maienan savisi len natub̃atan hǝn natit p̃isi aGot togole nǝboŋ toum hǝn navile a pan van vǝbar nǝboŋ ta damǝŋai, ale asike evisi tǝtas am boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Asike aGot tagol na-lǝŋon-isa-vǝsa-an tam̃idol len nǝboŋ galenan, nǝvanuan p̃isi lǝtǝmat. Avil aGot dereh tigol na-lǝŋon-isa-vǝsa-an sinǝvanuan p̃isi tem̃idol m̃os alat, gai tolekis hǝn galito, lotovi esan. ");
INSERT INTO klv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Beti avan ideh b̃ikel mai gamit ke, ‘Mǝteris, aKristo bogai!’ o ‘Gai saga!’ samtedǝlomi. ");
INSERT INTO klv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Husur akristo gǝgǝras gail mai ahai kelkel ur gǝgǝras gail dereh levisi. Dereh ligol namerikel gail nǝvanuan gail lǝb̃ip̃aŋ habat lan. Lǝtalǝboi lǝtagǝras nǝvanuan gail aGot tolekis hǝn galito, dereh lǝtagole len namerikel galenan. ");
INSERT INTO klv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Be gamit, mǝtelǝlǝgau! Nukel natit p̃isi mai gamit tia a tahw hǝn lǝb̃evisi.” ");
INSERT INTO klv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","AYesu isor am, ike, “Be nǝboŋ na-lǝŋon-isa-vǝsa-an hǝn nǝboŋ galenan b̃inoŋ, ‘dereh namityal timotmot, mai nahǝbati asike em̃ial; ");
INSERT INTO klv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dereh nam̃eso gail lerus vi pan dan nǝmav mai natit gail lotokad nǝdaŋan len nǝmav dereh lekurkur habat.’ ");
INSERT INTO klv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Beti dereh mǝteris nagǝman siNatun Nǝvanuan len nǝmavukasw len nab̃iltidaŋan mai nǝyalyalan. ");
INSERT INTO klv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dereh tesǝvat aŋel san gail vi lan naut p̃isi len navile a pan kavkav hǝn lǝb̃itariv b̃onb̃on hǝn alat aGot tolekis hǝn galito hǝn lotovi esan. ");
INSERT INTO klv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ivoi hǝn mǝtb̃elǝboi sǝhot natsua nǝhai nafik b̃eṽusani: Nǝboŋ nǝpashǝt nafik sǝmasmas am be todum̃oh, mǝtolǝboii ke nahǝbati naut pudpud egǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Imagenan, nǝboŋ mǝtb̃eris nǝsarpohan hǝn natgalen p̃isi notosor husuri, dereh mǝtelǝboii ke, natǝlmaman siNatun Nǝvanuan satogǝmai, ehum gai toil bopita tia. ");
INSERT INTO klv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nukel nakitinan mai gamito, naur egai asike lumat vǝbar natgalen p̃isi lǝb̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nǝmav mai navile a pan dereh arimasig, be nasoruan sagw gail asike lumasig boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nǝmariboŋ enan o namityal enan, avan ideh salǝboii. Aŋel gail len nǝmav mai aNatun aGot, galit lǝsalǝboii, avil aGot aTata, gai sǝb̃on ŋai elǝboii. ");
INSERT INTO klv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mǝtelǝlǝgau! Mǝtehulahul! Husur mǝtsalǝboi namityal enan ke ŋais. ");
INSERT INTO klv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nagǝman siNatun Nǝvanuan imaiegai ke: Ikad avan sua toyar len nǝyaran sua. Nǝboŋ toriŋ naim san, eriŋ natit p̃isi mai naut san len navǝlan naslev san gail. Ikel mai galit ṽisusua nauman salit sǝb̃olito, ale ikel buni mai naslev tokǝtkǝta kǝkol hǝn nabopita ke timashulahul. ");
INSERT INTO klv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Imagenan, mǝtehulahul! Husur mǝtsalǝboi namityal amahean naim b̃etǝlmam, len naut mǝdau, len natub̃loh len mariug, namityal natoulum̃an bekǝkǝraiko o len nadudulan som̃ilan. ");
INSERT INTO klv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amahean naim b̃evisi vǝha-sua ŋai, satisab̃ gotopatmari. ");
INSERT INTO klv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nǝsa notokel mai nǝvanuan p̃isi, nukel mai gamit am ke, mǝtehulahul!” ");
INSERT INTO klv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ale nǝPasova mai Nǝhanan hǝn nabǝta sǝkad nayis lan aripat hois. Ab̃iltihai tutumav mai ahai p̃usan gail hǝn nalo, ludas p̃isal hǝn nagǝgǝrasan, hǝn lǝb̃itah gat aYesu hǝn lǝb̃igol b̃imat. ");
INSERT INTO klv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be luke, “Sadatigole len nǝhanan hǝn nǝPasova hǝn asike nǝvanuan gail lǝb̃eluṽoh beti b̃al taṽtaṽor mǝdas natit gail.” ");
INSERT INTO klv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Len nǝboŋ enan, aYesu itoh len naut a Petani len naim seSimon tokad naleprosi a m̃o. AYesu ipat hǝn nǝgarin tarhǝtev. Ale napǝhaṽut sua tolav nab̃otel lotoum hǝni hǝn nǝvat topǝhw, egǝm hǝn aYesu. Nab̃otel enan epul hǝn naoil pǝhpǝhas tosusau, nǝvat han totibau, ale alitenan ilap̃ul nabuŋon nab̃otel, eb̃iri len nǝkadun aYesu. ");
INSERT INTO klv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nǝvanuan galevis ei nǝlolit ipaŋpaŋ ale lusor mai galit gabag ke, “Eb̃ir kǝmas hǝn nǝhai pǝhas egai sil nǝsa? ");
INSERT INTO klv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tap̃ur hǝni, tǝlav nǝvat tasǝhor nap̃urp̃uran hǝn nasihau tosua ale taviol hǝni mai namǝsal gail.” Ale losivoh masuṽ len alitenan. ");
INSERT INTO klv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ris aYesu toke, “Samtekǝmaien hǝni! Imabe mǝtomǝdasi! Gai igol natit tokab hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Husur namǝsal gail lutoh akis mai gamito, ale nǝboŋ mǝtb̃elǝŋoni mǝtolǝboi mǝtb̃igol navoian van hǝn galito. Be ginau, asike nutoh tabtab mai gamito. ");
INSERT INTO klv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Len nǝsa tokade ŋai, alitegai igol nǝsa tolǝboi b̃igole. Eb̃ir nǝhai pǝhas len nibegw hǝn b̃eutaut hǝni vir natǝtavunan sagw. ");
INSERT INTO klv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nukel nakitinan mai gamit ke, len naut p̃isi len navile a pan lotokel na-kel-uri-an tovoi lan, dereh linau gat nǝsa alitegai togole ale lihol husuri.” ");
INSERT INTO klv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Beti aJutas Iskariot, gai tosua len tosǝŋavur pisan toru, ivan hǝn nab̃iltihai tutumav gail hǝn b̃eriŋ aYesu len navǝlalito. ");
INSERT INTO klv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lohǝhaṽur hǝn lotosǝsǝloŋ hǝni, ale lukel gati ke dereh leviol hǝn nǝvat nasilva maii. Ŋa aJutas idas p̃isal hǝn b̃eriŋ aYesu len navǝlalito. ");
INSERT INTO klv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Len nǝmariboŋ metǝkav hǝn Nǝhanan hǝn nabǝta sǝkad nayis lan, evi nǝboŋ hǝn natutumavan hǝn nasipsip NǝPasova. Ale ahai susur san gail lous aYesu ke, “Guke namtevi be hǝn namtb̃eutaut hǝn nǝhanan hǝn nǝPasova hǝn gǝb̃ihani?” ");
INSERT INTO klv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ale aYesu esǝvat ahai susur san eru, ikel mai gǝlar ke, “Mǝrevi lan nab̃iltivile, dereh mǝrebubur mai naulum̃an topat nab̃iliwai, ale mǝrehusuri. ");
INSERT INTO klv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Naim ideh b̃eb̃is lan, mirikel mai amahean naim ke, ‘Ahai p̃usan eusi ke, “Narum̃ simetb̃os gai be? Nuke nihan Nǝhanian hǝn nǝPasova mai ahai susur sagw gail ei.”’ ");
INSERT INTO klv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Atenan dereh teṽusan gamǝru hǝn nab̃iltirum̃ a mǝhat tokad natit p̃isi dattolǝŋoni. Mǝreutaut vir gidat ei.” ");
INSERT INTO klv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Alaruenan aruvan dani, arob̃is len nab̃iltivile, ale arusab̃ natit p̃isi hum aYesu tokel mai gǝlaru. Ale aroutaut hǝn nǝhanan hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nǝboŋ namityal tomasur aYesu mai ahai susur lotovi 12 lubar naim enan. ");
INSERT INTO klv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nǝboŋ lotopat tarhǝgarilito tǝban natev, luhan ale aYesu ike, “Nukel nakitinan mai gamit ke, gamit sua tohan mai ginau dereh teriŋ ginau len navǝlan aenemi sagw gail.” ");
INSERT INTO klv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lolǝŋon isa habat ale galit ṽisusua lousi ke, “Ginamit ta be lai? Savi ginau a?” ");
INSERT INTO klv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ale ikel mai galit ke, “Evi gamit sua mǝttovi 12. Gamit sua tohan katǝp̃ol mai ginau len nasiloh. ");
INSERT INTO klv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ANatun Nǝvanuan dereh timasmat hum lototos husuri a m̃o, avil atenan b̃eriŋ aNatun Nǝvanuan len navǝlan aenemi san gail, nǝmauran san tisa vǝsa tibatbat! Dereh tipanis habat. Tavoi am hǝn atenan ke anan asike tǝpasi!” ");
INSERT INTO klv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nǝboŋ lotohanhan sal, aYesu ilav nabǝta, ale esipa lan, eb̃uri, beti ilavi mai galito, ike, “Lavi; nibegw bogai.” ");
INSERT INTO klv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ale nǝboŋ tolav nab̃iliwai topul hǝn nǝwain, esipa hǝni. Ilavi mai galito, ale galit p̃isi lomun lan. ");
INSERT INTO klv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ale ikel mai galit ke, “Nǝda hagw bogai, aGot tota gat na-kel-gati-an san lan mai nǝvanuan san gail. Nǝda eg hagw dereh tisel len nǝmatan sagw m̃os nǝvanuan tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nukel nakitinan mai gamit ke, nǝwain egai, len natohan pipihabǝlan aGot, nǝwain eg dereh tiveveu, ale gagai van asike nomun nǝwain egai van vǝbar nǝboŋ nǝb̃emuni mai gamit ei.” ");
INSERT INTO klv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Beti lokǝkai hǝn nǝb̃e hǝn nalotuan ale lovivile, lovi lan Naṽehuh Oliv. ");
INSERT INTO klv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ale aYesu ikel mai galit ke, “Gamit p̃isi dereh mitigam dan ginau. Husur natosian siGot ike, “‘Dereh niṽabun nǝvanuan nasipsip, ale nasipsip gail ligam ṽisusua.’ ");
INSERT INTO klv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Be nǝboŋ nǝb̃imat ale aGot b̃igol nǝb̃ile mǝhat dan nǝmatan, dereh neil a m̃o hǝn gamito vi lan naut a Kalili.” ");
INSERT INTO klv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Be aPita ikel maii ke, “Naut kǝmas galit p̃isi lǝb̃igam dan gaiug, asike nigole!” ");
INSERT INTO klv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","AYesu isor vari ke, “Nukel nakitinan mai gaiug ke, damǝŋai, len nalenmariug egai, a tahw hǝn natoulum̃an b̃ekǝkǝraiko vǝha-ru, dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau.” ");
INSERT INTO klv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Be aPita isor tǝvah ke, “Aoa! Sss! Naut kǝmas nǝb̃imat mai gaiug, asike nukel ke nǝsalǝboi gaiug!” Ale galit p̃isi am lokǝmaienan. ");
INSERT INTO klv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Len nǝyaran salito lubar naut nalilioliv, nahǝsan naut enan Ketsemane. Ale aYesu ikel mai ahai susur san gail ke, “Mǝtebǝtah gegai, nia sor tuṽ.” ");
INSERT INTO klv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Esǝhar aPita, aJemes mai aJon van ale nǝnauan san etub̃at tuhatuh habat, nǝlon isa vǝsa. ");
INSERT INTO klv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ale ikel mai galit ke, “Nulolosa masuṽ! Ehum nalolosaan sagw etǝgau gat nǝlogw van numat! Mititoh gegai, mitilele!” ");
INSERT INTO klv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nǝboŋ toyar van kǝkereh am, ipat len tan ale isor tuṽ. AYesu eus nap̃isal ideh hǝn b̃imakuv dan namityal hǝn na-lǝŋon-isa-vǝsa-an. ");
INSERT INTO klv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ike, “Appa, Ita, golǝboi gǝb̃igol natit p̃isi. Lav kuv nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an egai dan ginau. Wake sagigol nǝsa notolǝŋoni, gigol nǝsa gaiug gotolǝŋoni ŋai.” ");
INSERT INTO klv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Beti etǝlmam van hǝn ahai susur lototor, isab̃ lotopatmari. Ale ikel mai aPita ke, “Simon, gupatmari a? Gǝsalǝboi gǝb̃ilele len nǝhaua tosua ŋa? ");
INSERT INTO klv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mǝtehulahul. Mitisor tuṽ hǝn asike mǝtb̃iteh len nǝsaan totaltal ke mǝtehusuri. Naut kǝmas nǝlomito elǝŋon b̃igol nǝsa tonor, nibemit sǝdaŋ, edǝdasi.” ");
INSERT INTO klv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ale ivan vasor tuṽ tǝtas am. Na-sor-tuṽ-an san ep̃itoṽ hǝn tomadhakele. ");
INSERT INTO klv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nǝboŋ tosor tuṽ tonoŋ etǝlmam tǝtas, isab̃ lotopatmari husur namǝtalit inoṽ masuṽ. Evǝŋon galito, be lǝsalǝboi nǝsa lǝb̃ikel maii. ");
INSERT INTO klv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Len natǝlmaman na-vǝha-tor-an siYesu, ikel mai galit ke, “Mǝtupat, mǝtuŋavŋav sal a? Nǝpatan tinoŋ! Namityal egǝm tia. Mǝteris, avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan nǝvanuan nǝsaan gail ta bogai. ");
INSERT INTO klv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mitile mǝhat, dativan. Mǝteris, atenan b̃eriŋ ginau len navǝlalito satogǝm pǝpadaŋ.” ");
INSERT INTO klv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nǝboŋ aYesu tosorsor sal, aJutas tosua len tosǝŋavur pisan toru, egǝmai. Itah mai naluṽoh lototǝgau nab̃u nǝb̃alan mai nǝbatw gail. Ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo mai alat lotoil a m̃o hǝn naJu gail losǝvat naluṽoh enan. ");
INSERT INTO klv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ale aJutas isor utaut hǝn naṽusanian sua mai galit a m̃o, ike, “Nǝboŋ nǝb̃esum̃ nǝtarhon atenan, gai bolai. Tah gati. Sǝhari van, satigam yav.” ");
INSERT INTO klv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Vǝha-sua ŋai aJutas ivan hǝn aYesu, ike, “Ivoi Hai p̃usan!” ale esum̃ nǝtarhon. ");
INSERT INTO klv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ale logǝm hǝn aYesu, lutah gati. ");
INSERT INTO klv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Be len galit lototah mai aYesu, sua eliv kuv nab̃u nǝb̃alan san, eb̃il hǝni van hǝn naslev seb̃iltihai tutumav, ita kotov nǝdariŋan. ");
INSERT INTO klv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Beti aYesu ikel mai galit ke, “Imabe mǝtogǝm, lav nab̃u nǝb̃alan mai nǝbatw gail gǝmai, hǝn mǝtb̃itah gat ginau hum notovi vanuan nǝb̃alan tob̃al mai alat lotoil a m̃o? ");
INSERT INTO klv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Len nǝmariboŋ p̃isi nutah mai gamito, nop̃usan len naholǝvat todar vis naim siGot. Imabe mǝtsǝtah gat ginau ei? Avil timasmagenan hǝn natosian siGot b̃isarpoh.” ");
INSERT INTO klv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Beti ahai susur p̃isi san loriŋi, lugam dani. ");
INSERT INTO klv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ikad nǝmantuhmar sua tohusur aYesu ei, toruŋ gol gai tia hǝn nǝkaliko nalinen. Nǝboŋ lototah gati, ");
INSERT INTO klv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","igam b̃ur malmal dan galito, riŋ nǝkaliko san ipat mai galito. ");
INSERT INTO klv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Beti naluṽoh losǝhar aYesu van hǝn naim seb̃iltihai tutumav. Ale ab̃iltihai tutumav gail mai alat lotoil a m̃o hǝn naJu gail mai ahai p̃usan gail hǝn nalo lub̃onb̃on ei. ");
INSERT INTO klv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Be aPita ehusuri, iyar a tut dani vǝbar tob̃is len naholǝvat todar vis naim seb̃iltihai tutumav. Ale ebǝtah ei, etitileh mai alat lotokǝtkǝta kǝkol hǝn naim siGot. ");
INSERT INTO klv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ab̃iltihai tutumav gail mai nǝSanhitrin p̃isi ludas kel-koti-an ideh toke aYesu tob̃ur kotov nalo hǝn b̃imat sile. Be lǝsǝsab̃ ideh. ");
INSERT INTO klv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nǝvanuan isob̃ur lolibliboŋ husur aYesu be nǝSanhitrin isab̃i ke nakelean salit gail lǝsap̃itoṽ. ");
INSERT INTO klv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Galevis loil vi mǝhat, lukel nalibliboŋan egai husur aYesu, ");
INSERT INTO klv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","luke, “Namtosǝsǝloŋ hǝn ategai toke, ‘Ginau dereh nilap̃up̃ul naim siGot egai nǝvanuan lotoum hǝni, ale dereh neum tǝtas hǝn tile len nǝmariboŋ titor, nǝvanuan lotodǝdas lǝb̃eum hǝni.’” ");
INSERT INTO klv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Be nakelean salit gail am lǝsap̃itoṽ. ");
INSERT INTO klv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Beti ab̃iltihai tutumav ile mǝhat rivuh len galito. Ikel mai aYesu ke, “Imabe gǝsakel natideh hǝn gǝb̃etǝtas gole gaiug? Nǝsa lotokele ekitin a?” ");
INSERT INTO klv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Be aYesu sasor, sasor vari. Ale ab̃iltihai tutumav eusi ke, “Govi aKristo a? Govi aNatun Atenan tonor hǝn nǝ-sal-suhi-an a?” ");
INSERT INTO klv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","AYesu ike “Ginau bogai. Ale dereh mǝteris aNatun Nǝvanuan b̃ebǝtah len navǝlan nǝmatu siGot tovi aB̃iltidaŋan. Dereh mǝteris b̃egǝmai len nǝmavukasw hǝn nǝmav.” ");
INSERT INTO klv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Beti ab̃iltihai tutumav, nǝhon emǝkanun taṽtaṽor, itar nahurabat san hǝn b̃eṽusan tomǝtahun nasoruan enan siYesu. Ike, “Imabe datolǝŋon nǝvanuan ideh am hǝn b̃ikel kot nǝsaan sitegai? ");
INSERT INTO klv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamit mǝtosǝsǝloŋ hǝn tosor mǝdas aGot! Gamit mǝtunau mab hǝni?” Galit p̃isi lusab̃ sǝhoti ke tonor hǝn b̃imasmat. ");
INSERT INTO klv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Beti galevis lotub̃at ṽulai aYesu, lukabut gol nǝhon, lotuhi, lukel maii ke, “Gepǝhav utaut!” Ale alat lotokǝtkǝta kǝkol hǝn naim siGot luṽosi, lotuhi. ");
INSERT INTO klv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Len namityal enan, aPita itoh a pan sal len naholǝvat todar vis naim. Ale natǝbarehreh sua tovi slev seb̃iltihai tutumav iyar tukot. ");
INSERT INTO klv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nǝboŋ toris aPita totitileh, ekǝta bunus vahvahuri ale ike, “Gaiug gutah mai aYesu ta Nasaret.” ");
INSERT INTO klv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Be aPita ike sakitin. Ike, “Nǝsalǝboi nǝsa gotosor husuri! Nǝsalǝboi sǝhoti.” Ale iyar van hǝn nametlǝkau. Beti natoulum̃an ekǝkǝraiko. ");
INSERT INTO klv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nǝboŋ alitenan tovi slev torisi ei, etub̃at kel tasi am mai alat lotoil ei ke, “Ategai evi galit sua.” ");
INSERT INTO klv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Be aPita ikel tǝtas hǝni ke sakitin. Sǝdareh alat lotoil pǝpadaŋ lukel mai a Pita ke, “Ekitin, gaiug govi galit sua, husur gaiug am govi auleKalili.” ");
INSERT INTO klv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","APita ikel tasi ke sakitin, ita gati ke nǝsa tikele evi nakitinan. Ike, “Len nahǝsan aGot nokitin, ginau nǝsalǝboi atenan mǝttosor husuri. Asike nǝb̃ekitin, aGot tipansem ginau!” ");
INSERT INTO klv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vǝha-sua ŋai natoulum̃an ekǝkǝraiko tǝtas am. Beti aPita inau tǝlmam hǝn nǝsa aYesu tokel maii ke, “A tahw hǝn natoulum̃an b̃ekǝkǝraiko vǝha-ru, dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau.” Ale nǝlon aPita isa, itaŋ. ");
INSERT INTO klv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pelan han, dudulan som̃ilan, ab̃iltihai tutumav gail, alat lotoil a m̃o hǝn naJu gail, mai ahai p̃usan gail hǝn nalo; nǝSanhitrin kavkav lub̃onb̃on hǝn lǝb̃isor utaut. Lubaŋis gat aYesu, losǝhari van hǝn aPilate, loriŋi len navǝlan. ");
INSERT INTO klv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","APilate eus aYesu ke, “Gaiug govi Kiŋ seJu gail a?” AYesu isor vari ke, “Gai bol gotokele.” ");
INSERT INTO klv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ab̃iltihai tutumav gail loil hirhir ke aYesu togol natit isob̃ur tosa. ");
INSERT INTO klv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ŋa aPilate eus tasi ke, “Asike gusor var natgaleg a? Imabe? Gǝsasǝsǝloŋ hǝn natit tosob̃ur lotosor tas gaiug hǝni a?” ");
INSERT INTO klv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Be aYesu sakel na-sor-vari-an ideh am, gol aPilate ip̃aŋ lan. ");
INSERT INTO klv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Len Nǝhanan nǝPasova p̃isi, nǝgavna ikad naṽide sua. Idam̃ hǝn avan totoh len naim bǝbaŋis b̃evivile husur nalǝŋonian sinaluṽoh. ");
INSERT INTO klv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ikad naulum̃an sua, nahǝsan aParappas lotobaŋisi len naim bǝbaŋis mai alat lotob̃al mai nǝgavmen, lotogol nǝvanuan lotomat len nǝb̃alan mai alat aRom. ");
INSERT INTO klv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naluṽoh logǝm hǝn aPilate, lousi hǝn b̃ehusur naṽide san m̃os galito, hǝn b̃esua b̃evivile. ");
INSERT INTO klv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Be aPilate eus galit ke, “Mǝtuke nigol aKiŋ seJu tevivile van hǝn gamit a?” ");
INSERT INTO klv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ekǝmaienan bathut elǝboii ke ab̃iltihai tutumav gail lotoriŋ aYesu len navǝlan husur lutab̃ulol bulosi. ");
INSERT INTO klv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Be ab̃iltihai tutumav lusorsor mai naluṽoh hǝn lǝb̃ehusur nǝnauan salito, us aPilate hǝn b̃igol aParappas b̃evivile, savi aYesu. ");
INSERT INTO klv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Be Pilate isor var galit tǝtas ke, “B̃imagenan, mǝtolǝŋon ke nigol nǝsa hǝn ategai mǝttokisi hǝn aKiŋ seJu?” ");
INSERT INTO klv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Luvari, lukai ke, “Timat len nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","APilate eus naluṽoh ke, “Sil nǝsa? Igol nǝsa tosa?” Be lukai habat van am ke, “Timat len nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ŋa aPilate toke tetǝŋov nǝlon naluṽoh tevi pan, eriŋ aParappas evivile van hǝn galito. Ike nasoltia san gail lobilas habat hǝn aYesu, beti eriŋi len navǝlan nasoltia gail hǝn lǝb̃ip̃os gati len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Beti nasoltia gail losǝhar aYesu vab̃is len naholǝvat todar vis naim sisoltia gail, ale lokis p̃is navǝshǝsoltia lub̃onb̃on. ");
INSERT INTO klv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lukol nahurabat toboŋboŋ len aYesu, ale lovisvis hǝn nǝhau tokad nasunite tohum nab̃ulgǝgau, ale loriŋi len nǝkadun aYesu hum nǝkraun sekiŋ. ");
INSERT INTO klv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lotub̃at kai van hǝni ke, “Namtusal suh gaiug, Kiŋ seJu gail!” ");
INSERT INTO klv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Luṽasi, ṽasi, ṽas nǝkadun hǝn nǝhai, ale loṽulaii, ale lotǝŋedur bathurien. ");
INSERT INTO klv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nǝboŋ lotosor vilesi tonoŋ, lukol nahurabat toboŋboŋ dani, lukol nahurabat san tǝlmam lan. Beti losǝhari vivile hǝn lǝb̃ip̃os gati len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ikad auleSairin sua, nahǝsan aSimon, atǝman alarmiṽan, aAleksada mai aRufus. Atenan egǝm len nǝmarireu lotodar vis nab̃iltivile, imadhaṽot. Ale nasoltia lukele hǝn atenan ke tipat nǝhai balbal siYesu, ale ipati. ");
INSERT INTO klv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ale losǝhar aYesu van vǝbar naut a Kolkota, namilen nǝhes enan Naut hǝn Nabǝlashukadhutǝmat. ");
INSERT INTO klv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lulav nǝwain lotobul hǝn namǝr lan maii, be aYesu emǝtahuni. ");
INSERT INTO klv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Beti nasoltia lup̃os gati len nǝhai balbal. Lopǝpehun nahurabat san, bar hǝn nǝvat hǝn lǝb̃isab̃ ase b̃ilav nahurabat ṽisusua. ");
INSERT INTO klv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Namityal emǝlapat dudulan nǝboŋ lotogol totahǝtah len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lutos gat nǝsa lotokot hǝn aYesu sile, ale loriŋ na-kel-uri-an enan len nǝhai balbal a mǝhat hǝn nǝkadun, toke, “AKiŋ seJu gail.” ");
INSERT INTO klv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Nǝvanuan vǝnvǝnah artogolgol nasǝnahan len nǝvanuan, lup̃os gat gǝlaru arutahǝtah mai aYesu. Sual itahǝtah len nǝhai balbal len nǝmatu siYesu, togon len nǝmair san. ");
INSERT INTO klv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nǝvanuan gail lotoṽot, lohǝlas aYesu, sor mǝdas nahǝsan. Loŋit nǝholit van hǝni, luke, “Gaiug golǝboi gǝb̃igol naim siGot b̃imasirsir, ale um tǝlmam hǝni len nǝmariboŋ b̃itor a? ");
INSERT INTO klv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","B̃imagenan, gilav kuv gaiug gabag dan nǝmatan! Gimariŋ dan nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Len naṽide tomaienan, ab̃iltihai tutumav gail, alat lotoil a m̃o hǝn nǝvanuan gail mai ahai p̃usan gail hǝn nalo lusor viles aYesu mai galit gabag, luke, “Gai ilav kuv nǝvanuan tile gail be edǝdas b̃ilav kuv gai! ");
INSERT INTO klv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ategai tonau ke gai aKristo, aKiŋ seIsrael, timariŋ dan nǝhai balbal ale dereh datedǝlomi ke gai tovi kiŋ.” Alaruenan artotahǝtah tǝban aYesu, gǝlar am arokǝmaienan, arusor isa hǝni. ");
INSERT INTO klv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Len natub̃lial, nǝmargobut ikabut gol p̃is naut kavkav van vǝbar namityal totor ut mǝdau. ");
INSERT INTO klv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ale len namityal totor enan, aYesu ikai habat ke, “Eloi, eloi, lema sapahtani!” namilen ke, “Got sagw, Got sagw, goriŋ gab̃ulan ginau sil nǝsa?” ");
INSERT INTO klv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nǝboŋ nǝvanuan galevis lotoil pǝpadaŋ ei lotosǝsǝloŋ hǝni, luke, “Sǝsǝloŋ, ekis aElijah.” ");
INSERT INTO klv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Avan sua igam, ilav nasponts, igol epul hǝn nǝwain tokon, ale esii len nǝhai, esuhuni van hǝn aYesu hǝn b̃emuni. Ike, “Riŋi. Datebunusi bai ke, aElijah dereh tegǝm lav kuvi vi pan o teb̃uer.” ");
INSERT INTO klv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Beti aYesu ikai habat, emǝsol, imat. ");
INSERT INTO klv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Len namityal enan ŋai, nǝkaliko mǝtortor totahǝtah len naim siGot, tub̃at a mǝhat, emǝtar vǝbar naut a pan, igol nahudhut eru. ");
INSERT INTO klv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nǝboŋ nasenturion toil pǝpadaŋ len nǝhon aYesu toris ke tomat maienan, ike, “Kitin, ategai evi aNatun aGot!” ");
INSERT INTO klv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Len naut enan ikad napǝhaṽut galevis lotoil a tut dan nǝhai balbal, lotokǝta ris nǝsa tovisi. Galit galevis lovi aMeri ta Maktala; togon aMeri anan atuhJemes mai aJoses; togon aSalome. ");
INSERT INTO klv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Len naut a Kalili alatenan lohushusur aYesu, lokǝtkǝta tǝban. Napǝhaṽut tosob̃ur am lototah mai aYesu len nǝyaran san vi Jerusalem, loil ei. ");
INSERT INTO klv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nǝmariboŋ enan evi Nǝboŋ hǝn Nautautan, ale len namityal enan nǝSappat pǝpadaŋ hǝn b̃etub̃at. Nǝboŋ namityal pǝpadaŋ hǝn b̃imasur ut mǝdau, ");
INSERT INTO klv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","aJosef ta Arimatea egǝmai. AJosef evi b̃iltivanuan sua len nǝSanhitrin, itoh vir natohan pipihabǝlan aGot, ale len na-il-b̃uri-an, ivan hǝn aPilate, eus niben aYesu. ");
INSERT INTO klv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","APilate esǝhoṽut hǝn aYesu tomat tia, ŋa ekis nasenturion gǝmai, eusi ke, “AYesu imat tia ŋa?” ");
INSERT INTO klv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nasenturion ike tomat tia, ale aPilate idam̃ hǝn niben aYesu mai aJosef. ");
INSERT INTO klv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ŋa aJosef ipat kuv aYesu vi pan, ilav nǝkaliko nalinen, eruŋ gol niben len nǝkaliko enan, ale eriŋ aYesu len nab̃urhuvat nǝmatan lotota p̃up̃uli tia. Beti erib hǝn nǝvat hǝn b̃ipat gol nab̃urhuvat nǝmatan. ");
INSERT INTO klv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ale aMeri ta Maktala mai aMeri anan aJoses arokǝta ris naut lotoriŋ niben aYesu topat lan. ");
INSERT INTO klv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nǝboŋ nǝSappat tonoŋ, aMeri ta Maktala, aMeri anan aJemes, mai aSalome loṽur nǝhai pǝhas hǝn lǝb̃evǝhas niben aYesu. ");
INSERT INTO klv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Len nǝmariboŋ metǝkav hǝn nawik, dudulan som̃ilan, lovi lan nab̃urhuvat nǝmatan, ");
INSERT INTO klv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ale lous galit gabag ke, “Gidat datsǝnav. Ase terib hǝn nab̃iltivat enan dan nab̃urhuvat nǝmatan?” ");
INSERT INTO klv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Be nǝboŋ lotokǝta van hǝn nab̃iltivat enan, loris ke, naut kǝmas tovi b̃iltivat, sǝpat gol nab̃ur am, ehum avan sua torib hǝni tia. ");
INSERT INTO klv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ale nǝboŋ lotob̃is len nab̃urhuvat nǝmatan, loris nǝmantuhmar sua tobǝtah len navǝlan nǝmatu, tosun nahurabat topǝhapǝhw. Lumaŋmaŋ habat lan, lomǝtahw. ");
INSERT INTO klv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ike, “Samtemǝtahw! Mǝtudoŋ aYesu ta Nasaret tomat len nǝhai balbal. Ile mǝhat tia! Satoh gegai. Mǝtekǝta ris naut lotoriŋi topat lan. ");
INSERT INTO klv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mitivan. Mitikel mai ahai susur san gail mai aPita ke, ‘Eil a m̃o hǝn gamito vi Kalili. Dereh mǝterisi ei, hum tokel mai gamit tia.’” ");
INSERT INTO klv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Latpǝhaṽut galenan lotovivile, lupab, lodǝdarŋab̃u, lugam dan nab̃ur. Lǝsakel mai avan ideh husur lotomǝtahw. ");
INSERT INTO klv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nǝboŋ aYesu tole mǝhat dudulan som̃ilan len nǝmariboŋ metǝkav hǝn nawik, nǝvanuan tovisi hǝni metǝkav, aMeri ta Maktala. Evi aMeri enan, aYesu tohut natǝmat tomǝlevru dani. ");
INSERT INTO klv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","AMeri ivan, ikel uri mai alat lototah mai aYesu, lotololosa, lototaŋ. ");
INSERT INTO klv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nǝboŋ lotosǝsǝloŋ hǝn aYesu tomaur tǝlmam, ale aMeri toke torisi, lǝsadǝlomi. ");
INSERT INTO klv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A tahw, aYesu evisi hǝn ahai susur eru san artoyar husur nap̃isal dan naut a Jerusalem. Be len nǝboŋ enan, ehum niben totile. ");
INSERT INTO klv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Alaruenan arotǝlmam vi Jerusalem, lukel ur nǝsa tovisi mai ahai susur lotosuh ei. Be lǝsadǝlom nǝsa gǝlar am artokele. ");
INSERT INTO klv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A tahw tǝtas am, nǝboŋ ahai susur tosǝŋavur pisan tosua lotohan, aYesu evisi hǝn galito. Isor len galito husur lotopar dǝlomian mai nǝkadulit tohaihai husur lǝsadǝlom na-kel-uri-an silat lotorisi. ");
INSERT INTO klv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Beti ikel mai galito ke, “Mǝtevi lan naut p̃isi len navile a pan, mitikel ur na-kel-uri-an tovoi mai nǝvanuan gail p̃isi. ");
INSERT INTO klv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nǝvanuan todǝlom na-kel-uri-an tovoi, tobaptais, aGot dereh tilav kuvi dan nǝsaan san. Avil nǝvanuan sadǝlomi, aGot dereh tisab̃ sǝhoti ke timaspanis. ");
INSERT INTO klv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ale namerikel galegai dereh levisi mai alat lotokad nadǝlomian: len nahǝsagw dereh lehut natǝmat gail, lisor len nasoruan veveu gail. ");
INSERT INTO klv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dereh lipat nǝm̃at gail, tǝgau hǝn navǝlalito; lǝb̃emun nabehi hǝn nǝmatan, asike emǝdas galito. Dereh leriŋ navǝlalito len alat lotomǝsah, ale limaur.” ");
INSERT INTO klv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nǝboŋ Nasub̃ aYesu tokǝmaienan mai galit tonoŋ, aGot ilavi vi mǝhat vi lan nǝmav, ale ebǝtah tarhǝt len nǝmatu siGot. ");
INSERT INTO klv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Beti ahai susur gail luvan, lukel ur na-kel-uri-an tovoi len naut p̃isi. AGot eum mai galito, len namerikel gail igol imasil ke nasoruan san ekitin. ");
INSERT INTO klv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ikad nǝvanuan isob̃ur tokel ur natit gail tosarpoh len gidato, hum ahai kelkel ur gail lotokele. Lutos nǝsa nǝvanuan gail lotorisi mai lotokel uri mai ginamito. ");
INSERT INTO klv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hum ke alat len natub̃atan lotoris natit p̃isi tovisi, ale lotogǝm vi vanuan na-vi-tarhǝte-an gail hǝn nasoruan, imaienan lukel uri mai ginamito. ");
INSERT INTO klv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ginau am nunau ke, ivoi ke, notokǝta kitev natit p̃isi len natub̃atan, tuani, ale tos husuri van hǝn gaiug Nasub̃ Teofilus, ");
INSERT INTO klv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","hǝn gǝb̃elǝboi nakitinan husur aYesu, mai nǝsa lotoṽusani hǝn gaiug. Nǝb̃ol egai imagegai: ");
INSERT INTO klv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nǝboŋ aHerot tovi kiŋ len naut a Jutea, ikad ahai tutumav sua nahǝsan aSekariah. Ikad nahǝmar sua nahǝsan aApijah, aSekariah tovi galit sua. Bareab san, nahǝsan aElisapet, gai am esua len nǝpasusan siAron. ");
INSERT INTO klv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gǝlaru aruvoi, arunor len nǝhon Nasub̃ aGot bathut arugol husur masuṽ hǝn natit p̃isi tokele. ");
INSERT INTO klv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Be anatularu eb̃uer husur aElisapet ebutoh, mai arovi haṽut tia. ");
INSERT INTO klv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Boŋ sua nahǝmar siSekariah loum siGot. ASekariah eum len nǝhon aGot hum ahai tutumav. ");
INSERT INTO klv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hum naṽide sihai tutumav gail, lubar hǝn nǝvat hǝn lotosab̃ aSekariah hǝn b̃epǝŋas nǝhai pǝhas len naim siNasub̃ aGot. Boŋ sua aSekariah eb̃is lan, ");
INSERT INTO klv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","len nǝboŋ enan nab̃iltiluṽoh lusor tuṽ vivile. ");
INSERT INTO klv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ale aŋel siNasub̃ evisi hǝni, eil ben nǝmel tutumavan tarhǝt nǝmatu. ");
INSERT INTO klv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nǝboŋ aSekariah toris aŋel enan, emǝtahw, ninen epil. ");
INSERT INTO klv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ris aŋel toke, “Sagemǝtahw aSekariah, husur aGot esǝsǝloŋ hǝn na-sor-tuṽ-an sam̃. Ale asoam̃ aElisapet dereh tipas anatum̃ ulum̃an. Geriŋ nǝhes Jon lan. ");
INSERT INTO klv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ale gaiug gehǝhaṽur habat mai nǝlom̃ tivoi masuṽ hǝni. Nǝvanuan isob̃ur dereh lehǝhaṽur hǝn nǝboŋ b̃evisi, ");
INSERT INTO klv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bathut tiyalyal len nǝhon aGot balai. Asike emun nǝwain mai nǝwai todaŋ, ale tepul hǝn aNunun aGot nǝboŋ topat sal len nabǝhaṽun anan. ");
INSERT INTO klv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ale tipair tǝlmam hǝn anatun seIsrael tisob̃ur van hǝn Nasub̃, aGot salito. ");
INSERT INTO klv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Len nanunun mai nǝdaŋan siElijah, dereh teil a m̃o hǝn Nasub̃ hǝn b̃ipair tǝlmam hǝn nǝlon atǝmalit van hǝn anatulito, pair tǝlmam hǝn nǝlon alat lǝsagol husur nǝsa aGot tokele, van hǝn nap̃isal silat lotonor, lotokad namitisau hǝn nǝmauran tonor. Imaiegai, aJon dereh teutaut hǝn nǝvanuan gail hǝn lǝb̃eutaut vir Nasub̃.” ");
INSERT INTO klv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Beti aSekariah ikel mai aŋel ke, “Nelǝboi mab hǝn natgalegai? Husur novi haṽut tia mai asoagw evi bareab tia.” ");
INSERT INTO klv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aŋel isor vari ke, “Nahǝsagw aKapriel notoil len nǝhon aGot tosǝvat ginau m̃os nǝb̃isor mai gaiug, hǝn nǝb̃ikel ur na-kel-uri-an tovoi hǝn natgalegai. ");
INSERT INTO klv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Be husur gǝsadǝlom nǝsa notokele, gaiug dereh geb̃ut, gedǝdas gǝb̃isor van vǝbar nǝboŋ natgalegai b̃evisi. Natit p̃isi dereh tevisi sum̃an notokele.” ");
INSERT INTO klv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Len nǝboŋ enan naluṽoh lutoh vir aSekariah, ale lup̃aŋ lan husur evǝlo len naim siGot. ");
INSERT INTO klv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nǝboŋ tovivile, salǝboi b̃isor mai galito, ale lolǝboii ke, eris na-kǝta-risi-an sua togǝm len nǝmav len naim siGot, husur eb̃utb̃ut be ike tisor len navǝlan. ");
INSERT INTO klv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Len nǝboŋ hǝn nauman sinahǝmar san gail tonoŋ, eriŋ naut a Jerusalem, ivahim san. ");
INSERT INTO klv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Husur nǝboŋ enan abareab san, aElisapet etian ale husur nahǝbati torim esusuan gai gabag, ike, ");
INSERT INTO klv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Egai nǝsa Nasub̃ aGot togole m̃os ginau nǝboŋ tohǝhaṽur hǝn ginau. Ilav kuv nahur sasa sagw notodaŋ b̃uri len nǝhon nǝvanuan sagw gail.” ");
INSERT INTO klv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ale len nahǝbati tomǝlevtes siElisapet, aGot esǝvat aŋel Kapriel vi Nasaret, navile sua a Kalili ");
INSERT INTO klv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","hǝn b̃isor mai navensus sua, nahǝsan aMeri. Ikad avan sua len nahǝmar siTevit, nahǝsan aJosef, ale gǝlaru arukel gati ke arilah. ");
INSERT INTO klv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aŋel ivan hǝn aMeri, ike, “Ivoi. Nasub̃ aGot eputsan gaiug, itoh mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Be aMeri, nǝlon etuhatuh hǝn nasoruan en san, inau sob̃uer hǝn namilen nasoruan aŋel tokele. ");
INSERT INTO klv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Beti aŋel ikel maii ke, “Sagemǝtahw Meri, aGot ehǝhaṽur hǝn gaiug tia, eputsan gaiug. ");
INSERT INTO klv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Asike idareh gaiug dereh getian, ale gipas anatum̃ ulum̃an sua, geriŋ nǝhes Yesu lan. ");
INSERT INTO klv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Gai dereh tiyalyal balai, lekisi hǝn anatun aGot a mǝhat buni, ale Nasub̃ aGot dereh tigol tilav namilen aTevit atǝman ta sutuai tovi kiŋ. ");
INSERT INTO klv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nǝpasusan siJakop dereh litoh pipihabǝlan vi sutuai; nanoŋan han eb̃uer.” ");
INSERT INTO klv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ris aMeri tokel mai aŋel ke, “Imabe? Avan ideh sǝbar nibegw sal!” ");
INSERT INTO klv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aŋel isor vari ke, “ANunun aGot dereh tegǝm len gaiug, nǝdaŋan siGot a mǝhat buni tikabut gol gaiug hum nǝm̃ol. Husur enan ategai gǝb̃ipasi, dereh tevi siGot, ale lekisi hǝn aNatun aGot. ");
INSERT INTO klv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Geris amaheam̃ aElisapet. Alitenan am etian, ikad anatun ulum̃an naut kǝmas ke tovi bareab tia. Ale egai nahǝbati san tomǝlevtes, gai lotokisi ke tobutoh. ");
INSERT INTO klv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bathut aGot satǝtan hǝn b̃igol natideh.” ");
INSERT INTO klv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ale aMeri ike, “Ginau novi natǝbarehreh nauman siNasub̃. Ivoi len ginau hum gotokǝmaienan.” Ale aŋel ivan dani. ");
INSERT INTO klv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sǝdareh aMeri ile mǝhat, iŋad vi lan nab̃iltivile sua a Jutea, naut enan tobaŋ ṽehuh. ");
INSERT INTO klv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nǝboŋ tobar naut enan evi lohoim siSekariah, ike, “Ivoi,” mai aElisapet. ");
INSERT INTO klv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nǝboŋ aElisapet tosǝsǝloŋ hǝn na-ke-ivoi-an san, anatun ekurkur len nabǝhaṽun, ale aElisapet epul hǝn aNunun aGot. ");
INSERT INTO klv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Beti ikai habat ke, “AGot igol navoian van hǝn gaiug sǝhor alatpǝhaṽut, igol navoian am van hǝn anatum̃ gǝb̃ipasi. ");
INSERT INTO klv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Imab hǝn nategai tovisi hǝn ginau, ke anana siMasta sagw togǝm hǝn ginau? ");
INSERT INTO klv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Husur nǝboŋ notosǝsǝloŋ hǝn nadolom̃, anatugw ekurkur hǝn nahǝhaṽuran san len nabǝhaṽugw. ");
INSERT INTO klv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","AGot gatogol navoian van hǝn gaiug, husur ke gaiug godǝlomi ke tigol nǝsa tokel gati mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Beti aMeri ike: “Nǝlogw eputsan Nasub̃, ");
INSERT INTO klv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nanunugw ikemkem hǝn aGot sagw gai tolav kuv ginau dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Husur eris natǝbarehreh san tovi ut kǝmas, ale vi sutuai naur p̃isi lekiskis ginau ke alitenan navoian topat lan. ");
INSERT INTO klv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","AGot todaŋ buni igol natgalevis tovoi buni hǝn ginau, gai sǝb̃on, nahǝsan esǝhor nǝhes p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ilolosa hǝn naur p̃isi ta sutuai vi sutuai lotomǝtahw len nǝyalyalan san. ");
INSERT INTO klv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eṽusan nǝdaŋan san hǝn navǝlan tia, ehut alat lotoṽiv, lumap̃ip̃iriah, alatenan lotopatpat galit mǝhat len nǝlolito. ");
INSERT INTO klv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Isah sur alat lotoyalyal vi pan dan namilelito, ale eputsan alat lotovi ut kǝmas. ");
INSERT INTO klv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Evǝŋan alat lotomalkǝkat, luhanukub, avil esǝvat alat lotokad natit p̃isi, luvan sǝsǝlav. ");
INSERT INTO klv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Evi tarhǝt silat a Israel lotovi vanuan san gail, inau gati hǝn b̃igol nalolosaan mai navoian hǝn galito, ");
INSERT INTO klv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","hum tokel gati mai atǝmadat gail, mai aApraham mai nǝpasusan san van van vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","AMeri itoh mai aElisapet pǝpadaŋ hǝn nahǝbati itor, beti etǝlmam vahim. ");
INSERT INTO klv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Len nǝboŋ aElisapet topas naulum̃an san, ");
INSERT INTO klv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","amahean gail mai alat lototoh pǝpadaŋ hǝni, losǝsǝloŋ hǝni ke Nasub̃ aGot ivoi buni hǝni, ale lohǝhaṽur maii. ");
INSERT INTO klv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Len nǝmariboŋ tomǝlevtor logǝm hǝn lǝb̃etiv dalus anatun ale luke leriŋ nahǝsan atǝman aSekariah lan. ");
INSERT INTO klv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Avil anan ikai ke, “Aoa, nahǝsan m̃au aJon!” ");
INSERT INTO klv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ris lotokel maii ke, “Amaheam̃ gail, nǝhes enan eb̃uer len galito.” ");
INSERT INTO klv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ale lusor len navǝlalit mai aSekariah hǝn lǝb̃isab̃ nǝhes aSekariah toke tekisi hǝni. ");
INSERT INTO klv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ASekariah isor len navǝlan, eus natit hǝn b̃itos lan ale itosi ke, “Nahǝsan aJon.” Galit p̃isi lup̃aŋ lan. ");
INSERT INTO klv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Vǝha-sua ŋai elǝboi b̃isor tǝtas, ale etub̃at hǝn b̃isal suh aGot. ");
INSERT INTO klv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Alat lototoh pǝpadaŋ hǝni, lumaŋmaŋ, lomǝtahw, mai alat a Jutea, naut enan tobaŋ ṽehuh, luhol husur natgalegai. ");
INSERT INTO klv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nǝvanuan gail p̃isi lunau masuṽ hǝn nǝsa lotosǝsǝloŋ hǝni, ale luke, “Natǝtai egai dereh timabe?” Husur navǝlan aGot ipat tin lan. ");
INSERT INTO klv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Atǝman aJon, aSekariah epul hǝn aNunun aGot beti ikel ur nǝsa aGot tokel maii ke, ");
INSERT INTO klv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Noputsan nahǝsan Nasub̃ aGot seIsrael, bathut egǝm hǝn togol nǝvanuan san gail lotovi slev lotomakuv, ");
INSERT INTO klv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ale esǝvat avan sua todaŋ len nǝpasusan sivanuan nauman san, aTevit, atenan dereh tilav kuv gidato dan nǝsaan sidato. ");
INSERT INTO klv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","AGot ekǝmaienan len nabuŋon ahai kelkel ur san gail ta sutuai, ");
INSERT INTO klv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ke atenan b̃ilav kuv gidato dan aenemi sidat gail, dan navǝlan alat lotomǝtahun bun gidat habat. ");
INSERT INTO klv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ilolosa hum tokel gati mai atǝmadat ta sutuai ale inau gat na-kel-gati-an san tokitin, ");
INSERT INTO klv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na-kel-gati-an tota gati len nahǝsan mai aApraham atǝmadat ta sutuai: ");
INSERT INTO klv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","hǝn b̃ilav kuv gidato dan navǝlan aenemi sidat gail hǝn ke datb̃eum san, asike datukad namǝtahwan, ");
INSERT INTO klv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ale datb̃inor len nǝhon mai datb̃ivoi vǝbar nagilen nǝmauran sidato. ");
INSERT INTO klv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Gaiug m̃au anatugw, dereh lekis gaiug hǝn ahai kelkel ur siGot toyalyal buni; husur dereh gaiug geil a m̃o hǝn Nasub̃ hǝn gǝb̃eutaut hǝn nap̃isal san gail, ");
INSERT INTO klv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","hǝn gǝb̃ilav mai nǝvanuan san gail nalǝboian hǝn nǝ-lav-kuvi-an dan nǝsaan len narub̃atian dan nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nalolosaan mai navoian siGot sidato dereh tesun gidato sum̃an nǝyal tovisi len nǝmav, ");
INSERT INTO klv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tem̃ias alat lototoh len nǝmargobut, lotomǝtahw len nǝmatan, hǝn b̃esǝhar gidato len nap̃isal totǝm̃at.” ");
INSERT INTO klv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ale natǝtai enan Jon, etibau, egǝm idaŋ len nanunun. Itoh len naut masmas tob̃ǝb̃esw vǝbar nǝboŋ togǝm visi len alat a Israel. ");
INSERT INTO klv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Len nǝboŋ galenan Sisa Aukustus ikel buni ke, tikad nap̃uruŋan hǝn nǝvanuan p̃isi lototoh len navǝlan alat a Rom. ");
INSERT INTO klv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nap̃uruŋan enan evi nametǝkav nǝboŋ aKwirinius tovi gavna len naprovens Siria. ");
INSERT INTO klv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ale galit p̃isi lovi lan naut salit matmat hǝn lǝb̃itos gat nahǝsalito. ");
INSERT INTO klv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ŋa aJosef am eriŋ naut a Nasaret a Kalili ale evi Petlehem a Jutea lotokisi hǝn nab̃iltivile siTevit, husur gai esua len nǝpasusan siTevit. ");
INSERT INTO klv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gai mai aMeri, tokel gati ke arb̃ilah, arovi Petlehem hǝn arb̃itos gat nahǝsalaru be aMeri pǝpadaŋ hǝn b̃ipasus. ");
INSERT INTO klv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nǝboŋ artotoh len naut a Petlehem, aMeri ipasus. ");
INSERT INTO klv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ipas ahai a m̃o san tovi ulum̃an. Eruŋ gole hǝn nahudhukaliko gail. Eriŋi ipat len naut nǝhanan sinarivatǝvat gail husur nahotel epul varirihit p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Len mariug enan ikad alatevis lotosuh len nǝmarireu gail, lotokǝtkǝta tǝban navǝshǝsipsip pǝpadaŋ hǝn naut a Petlehem. ");
INSERT INTO klv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nǝboŋ lototoh magenan, aŋel siNasub̃ evisi hǝn galito mai namǝnas siNasub̃ em̃ias galito ale lomǝtahw, lom̃inm̃inikot. ");
INSERT INTO klv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ris aŋel tokel mai galito ke, “Samtemǝtahw, husur nukad na-kel-uri-an tovoi b̃igol nǝvanuan p̃isi lǝb̃ikemkem masuṽ. ");
INSERT INTO klv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bathut damǝŋai len nab̃iltivile siTevit lupas natǝtai sua b̃ilav kuv nǝsaan samito, gai evi aKristo, Nasub̃, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Egai natit mǝtb̃eris lǝboii lan, ke: dereh mitisab̃ natǝtai lotoruŋ gole hǝn nahudhukaliko gail topat len naut nǝhanan sinarivatǝvat.” ");
INSERT INTO klv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Vǝha-sua ŋai ikad nab̃iltiluṽoh hǝn aŋel hǝn nǝmav lototah maii, lotoputsan aGot ke, ");
INSERT INTO klv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nalotuan van hǝn aGot toyalyal buni, mai len navile a pan, natǝm̃at van hǝn nǝvanuan p̃isi, navoian siGot topat len galito.” ");
INSERT INTO klv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nǝboŋ aŋel gail lotoriŋ galito hǝn lǝb̃etǝlmam vi lan nǝmav, nǝvanuan nasipsip lukel mai galit gabag ke, “Ivoi ke datevi Petlehem hǝn datb̃eris nategai tovisi, Nasub̃ tokele mai gidato.” ");
INSERT INTO klv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ŋa lusaṽsaṽut van, lusab̃ aMeri mai aJosef, mai amas topat len naut nǝhanan sinarivatǝvat. ");
INSERT INTO klv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nǝboŋ lotorisi tonoŋ, lukel ur nǝsa aŋel tokel husur natǝtai enan. ");
INSERT INTO klv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ale nǝvanuan p̃isi lotosǝsǝloŋ hǝni, lup̃aŋp̃aŋ len nǝsa nǝvanuan nasipsip lotokele. ");
INSERT INTO klv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Be aMeri inau gat natgalen p̃isi, len nǝlon inaunau namilen. ");
INSERT INTO klv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Beti nǝvanuan nasipsip lotǝlmam, ale lusor sal suh nǝyalyalan siGot, loputsani husur natit p̃isi lotosǝsǝloŋ hǝni mai lotorisi. Esum̃an ŋai aŋel tokel mai galito. ");
INSERT INTO klv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nǝboŋ nǝmariboŋ tomǝlevtor simas tonoŋ, lotiv dalusi, ale loriŋ nǝhes Yesu lan. Nǝhes enan aŋel ikel uri nǝboŋ aMeri satian sal. ");
INSERT INTO klv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta sutuai aMoses itos nalo husur latpǝhaṽut lotopasus ke limastoh vir nǝmariboŋ tovi 40 ale legǝm veveu tǝtas len nǝhon aGot. Imaienan, nǝboŋ nǝmariboŋ hǝn aMeri b̃egǝm veveu buni tonoŋ, arupat aYesu vi Jerusalem hǝn arb̃eṽusani ke tovi siNasub̃ husur nalo siNasub̃ aGot aMoses totosi. ");
INSERT INTO klv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Imaiegai, len nalo siNasub̃ aGot ike, “Hai a m̃o gail p̃isi lotovi ulum̃an, levi siNasub̃ aGot. AGot itabtabuh len galito hǝn lǝb̃evi esan.”) ");
INSERT INTO klv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ale aruvan vǝpat nǝman eru hǝn natutumavan hum nalo siNasub̃ aGot tokele ke, “nǝtav eru o napijin eru.” ");
INSERT INTO klv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Len naut a Jerusalem ikad ahaṽut sua nahǝsan aSimeon. Atenan inor mai ehusur kitin hǝn nap̃isal siGot. Itoh vir avan sua b̃evi tarhǝt seIsrael, ale aNunun aGot itoh len gai. ");
INSERT INTO klv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ANunun eṽusani ke gai asike imat vǝbar b̃eris aKristo siNasub̃, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ANunun esǝhar aSimeon vab̃is len naim siGot. Nǝboŋ anan aYesu mai atǝman artopati vi lohoim hǝn arb̃igol nǝsa nalo siMoses tokele, ");
INSERT INTO klv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","aSimeon ipati len navǝlan ale isal suh aGot ke, ");
INSERT INTO klv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Masta, ginau notovi slev sam̃, gagai nǝlogw ikad natǝm̃at, riŋ ginau nimat hum nasoruan sam̃ tokele, ");
INSERT INTO klv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","husur namǝtagw eris ategai b̃ilav kuv nǝvanuan sam̃ gail vi lan nǝmauran. ");
INSERT INTO klv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Goutaut hǝni len nakǝtaan sinǝvanuan gail p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gai evi nam̃ial b̃em̃ias nap̃isal sam̃ gail m̃os alat lǝsavi Ju, gai am dereh teputsan nahǝsan nǝvanuan sam̃ gail, aIsrael.” ");
INSERT INTO klv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nǝboŋ anan mai atǝman artosǝsǝloŋ hǝn nǝsa aSimeon tohol husur aYesu, arup̃aŋ. ");
INSERT INTO klv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Beti aSimeon eus aGot hǝn b̃igol b̃ivoi hǝn gǝlaru, ale ikel mai aMeri, anan aYesu ke, “Ategai boh dereh tigol nǝvanuan tisob̃ur len naut a Israel levi ut kǝmas mai teputsan nahǝsan tisob̃ur am. Gai dereh tehum natsua nǝvanuan tosob̃ur lǝb̃isor tasi balai, ");
INSERT INTO klv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ale gai tisor vǝhot nǝnauan tosusuah len nǝlon nǝvanuan lotosob̃ur. Meri, gaiug am, dereh gelǝŋon tisa sum̃an nab̃u tokan tosar nǝlom̃.” ");
INSERT INTO klv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ikad ahai kelkel ur sua, nahǝsan aAnna, anatvavin aFanuel, len nahǝmar siAser. Alitenan ilah len nasihau emǝlevru ŋai ale asoan imat. Egǝm vi bareab tia. ");
INSERT INTO klv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Evi batunau vǝbar nǝdam̃ han tovi 84. Gai sariŋ naholǝvat todar vis naim siGot avil ilotu len nalennǝyal mai nalenmariug p̃isi. Len nalotuan san, sǝhan, isor tuṽ ŋai. ");
INSERT INTO klv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Len namityal enan ŋai egǝm pǝpadaŋ ale ike sipa vi tǝban Nasub̃ aGot, ihol husur aYesu mai alat lototoh vir aGot b̃ilav kuv a Jerusalem hǝn b̃ikad nǝmakuvan. ");
INSERT INTO klv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nǝboŋ aJosef mai aMeri artogol natit p̃isi nalo siNasub̃ aGot tokele tonoŋ, arotǝlmam vi Nasaret, navile sǝlaru len naut a Kalili. ");
INSERT INTO klv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Natǝtai etibau, egǝm idaŋ. Gai epul hǝn namitisau hǝn nǝmauran tonor mai naṽide tovoi, ale aGot ivoi buni hǝni, elǝmas buni. ");
INSERT INTO klv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Len nasihau gail p̃isi anan aYesu mai atǝman arovi Jerusalem hǝn Nǝhanan hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nǝboŋ nǝdam̃ hiYesu tosǝŋavur pisan eru, evi mǝhat vi Jerusalem mai gǝlaru sum̃an naṽide hǝn nab̃iltihanan. ");
INSERT INTO klv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nǝboŋ nǝhanan tonoŋ, lotub̃at vahim. Natǝtai, aYesu itoh a Jerusalem be arsalǝboii ");
INSERT INTO klv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","husur arunau ke, totah mai alat lototǝlmam mai gǝlaru. Nǝboŋ nǝyaran hǝn nǝboŋ enan tonoŋ, gǝlaru arokǝta doŋi len amahealar gail mai nabubur salit gail sob̃uer. ");
INSERT INTO klv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ale arotǝlmam vǝbar naut a Jerusalem hǝn arb̃ekǝta doŋi. ");
INSERT INTO klv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Husur nǝmariboŋ totor arusab̃i len naholǝvat todar vis naim siGot. Ebǝtah mai ahai p̃usan gail, esǝsǝloŋ hǝn galito ale eus galito hǝn nausian gail. ");
INSERT INTO klv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Galit p̃isi lotosǝsǝloŋ hǝn aYesu, lup̃aŋ len nalǝboian san mai na-sor-vari-an san. ");
INSERT INTO klv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nǝboŋ artorisi, arup̃aŋ ale anan ikel maii ke, “Anatugw, imabe gotogol tomaiegai hǝn ginamǝru? Geris, atǝmam̃ mai ginau namrolǝŋon isa nǝboŋ namrtokǝta doŋ gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Gai isor mai gǝlar ke, “Imabe mǝrtodoŋ ginau? Mǝrsalǝboii ke, nototoh len naim seTǝmagw ŋa?” ");
INSERT INTO klv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Avil arsalǝboi sǝhot nǝsa tokel mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naut kǝmas, be iyar vi pan mai gǝlaru vǝbar naut a Nasaret, ale igol husur nǝsa artokele. Anan inaunau natgalenan len nǝlon. ");
INSERT INTO klv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ale namitisau hǝn nǝmauran tonor mai naṽide tovoi siYesu evivi mǝhat. Etibau am ale aGot mai nǝvanuan gail lohǝhaṽur am tabtab hǝni. ");
INSERT INTO klv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Len nasihau tosǝŋavur pisan erim seTiperius tovi Sisa hǝn naut a Rom, nǝboŋ aPontius Pilate tovi gavna hǝn naprovens Jutea, nǝboŋ aHerot Antipas tovi vanuan totibau hǝn naut a Kalili, mai aṽan, nahǝsan aFilip tovi vanuan totibau hǝn naut a Iturea mai a Trakonitis, mai aLisanias tovi vanuan totibau hǝn naut a Apilin, ");
INSERT INTO klv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","nǝboŋ aAnnas mai aKaiafas artovi b̃iltihai tutumav, nasoran siGot egǝm hǝn aJon anatun aSekariah len naut masmas tob̃ǝb̃esw. ");
INSERT INTO klv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ŋa aJon iyar vi lan naut p̃isi todar vis Nawisel Jortan hǝn b̃ikel ur napisulan egai mai nǝvanuan gail ke, lipair dan nǝsaan salito mai lidam̃ hǝni ke tibaptais hǝn galito hǝn narub̃atian dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ehum ahai kelkel ur aIsaiah totosi sutuai tia husur aJon ke: “Nadoldol sua satokai len naut masmas tob̃ǝb̃esw, ‘Mǝteutaut hǝn nap̃isal m̃os Nasub̃, gol nap̃isal san gail linor, ");
INSERT INTO klv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","dereh nab̃ur madiŋdiŋ gail p̃isi tepul, naṽehuh gail p̃isi tipapav, nap̃isal tohab̃ taṽor tegǝm tinor mai nap̃isal tokutkutu temǝsoh balai. ");
INSERT INTO klv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ale nǝvanuan gail p̃isi leris lǝboi nap̃isal hǝn nǝ-lav-kuvi-an dan nǝsaan salito, aGot togolgole.’” ");
INSERT INTO klv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Imagenan aJon ikel mai naluṽoh lotogǝm hǝn b̃ibaptais hǝn galito ke, “Anatun nǝm̃at gail! Ase ikel nalǝlǝgauan mai gamito hǝn mǝtb̃igam dan nab̃iltilol paŋpaŋ b̃egǝmai? ");
INSERT INTO klv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Len nǝmauran samito, mitiṽan hǝn naṽite tinor hǝn nǝpairan samito dan nǝsaan. Ale samtetub̃at sor mai gamit gabag ke, ‘Asike datupanis husur aApraham evi atǝmadato ta sutuai.’ Husur nukel mai gamit ke aGot elǝboi b̃ilav nǝvat galegai ale gol ke legǝm vi pasusan siApraham! ");
INSERT INTO klv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","AGot esum̃an naulum̃an toutaut tia hǝn b̃itai nǝkadhuhai gail hǝn nakuvkuv; nǝhai p̃isi lǝsǝṽan hǝn naṽit tovoi, gai dereh titaii, bubulan gail vi lan nǝhab.” ");
INSERT INTO klv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ale naluṽoh lousi ke, “Beti namtigol nǝsa?” ");
INSERT INTO klv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","AJon isor var galit ke, “Avan tokad nahurabat toru, tilav tesua mai avan topar, ale avan tokad nǝhanian tigol timaienan.” ");
INSERT INTO klv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Alat lotovi vanuan nǝtaks, galevis am logǝm hǝn lǝb̃ibaptais. Ale lousi ke, “Hai p̃usan, ginamit, namtigol timabe?” ");
INSERT INTO klv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ikel mai galit ke, “Samtilav kuv nǝvat tetibau sǝhor nǝsa nǝgavmen ta Rom tokele.” ");
INSERT INTO klv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Beti nasoltia galevis lousi ke, “Be ginamit am, namtimabe?” Isor var galito ke, “Samtitaltal hǝn nǝvanuan gail hǝn lǝb̃ilav nǝvat mai gamito, samtelibliboŋ husur galito len nakotan. Mǝtehǝhaṽur hǝn nap̃urp̃uran samit ŋai.” ");
INSERT INTO klv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Len nǝboŋ enan nǝvanuan gail lopul hǝn nǝ-vatvat-viri-an. Len nǝnauan salit lousus galit ke, “AJon, gai hum ma b̃evi aKristo, aGot totabtabuh lan a?” ");
INSERT INTO klv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ale aJon isor var galit p̃isi ke, “Nubaptais hǝn gamit hǝn nǝwai ŋai. Avil avan sua todaŋ sǝhor ginau satogǝmgǝmai, ginau novi ut kǝmas ŋai, nǝsanor kasi hǝn nǝb̃isah rub̃at nǝhau hǝn naributbut san. Gai dereh tibaptais hǝn gamito hǝn aNunun aGot mai nǝhab. ");
INSERT INTO klv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gai esum̃an naulum̃an topat nǝhai rivrivhai tia hǝn b̃epǝpehun namisurhuwit dan nǝbavhut tomasmas. Dereh tib̃on hǝn namisurhuwit len natuhim han, be tepǝŋas nasugut nawit tosa len nǝhab todǝdas b̃imat.” ");
INSERT INTO klv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ŋa len naṽide tosob̃ur aJon isor idaŋ mai galito, ale ikel ur na-kel-uri-an tovoi mai galito. ");
INSERT INTO klv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Be nǝboŋ aJon tosor tas nǝvanuan totibau, aHerot Antipas, husur tolah mai aHerotias tovi asoan aṽan, ale nǝboŋ aJon tosor tasi am husur natesasa p̃isi togole tia, ");
INSERT INTO klv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","imagenan aHerot igol isa masuṽ sǝhor ta m̃o: ekǝkol gat aJon len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Loriŋ aJon len naim bǝbaŋis a tahw, be nǝboŋ nǝvanuan gail p̃isi lotobaptais, aYesu am ibaptais. Nǝboŋ aYesu tosor mai aGot, nǝmav esǝŋav, ");
INSERT INTO klv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aNunun aGot evi pan tokad niben sum̃an nǝtav, itav len aYesu, ale nadoldol egǝm len nǝmav ke: “Gaiug govi anatugw ulum̃an sagw notolǝmas bun gaiug, nohǝhaṽur masuṽ hǝn gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nǝboŋ aYesu totub̃at hǝn nauman san, nǝdam̃ han evi 30. Nǝvanuan gail lunau ke evi anatun aJosef, siHeli, ");
INSERT INTO klv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","siMattat, siLevi, siMelki, siJannai, siJosef, ");
INSERT INTO klv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","siMattatias, siAmos, siNahum, siEsli, siNakkai, ");
INSERT INTO klv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","siMaat, siMattatias, siSemein, siJosek, siJota, ");
INSERT INTO klv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","siJoanan, siResa siSeruppapel, siSealtiel, siNeri, ");
INSERT INTO klv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","siMelki, siAtti, siKosam, siElmatam, siEr, ");
INSERT INTO klv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","siJosua, siElieser, siJorim, siMattat, siLevi, ");
INSERT INTO klv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","seSimeon, seJutah, siJosef, siJonam, siEliakim, ");
INSERT INTO klv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","siMelea, siMenna, siMattata, siNatan, siTevit, ");
INSERT INTO klv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","siJesse, siOpet, siPoas, siSalmon, siNahson, ");
INSERT INTO klv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","siAmminatap, siAtmin, siArni, siHesron, siPeres, seJutah, ");
INSERT INTO klv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","siJakop, seIsak, siApraham, siTerah, siNahor, ");
INSERT INTO klv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","siSeruk, siReu, siPelek, siEper, siSelah, ");
INSERT INTO klv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","siKainan, siArfaksat, siSem, siNoah, siLamek, ");
INSERT INTO klv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","siMetuselah, siEnok, siJaret, siMahalaleel, siKenan, ");
INSERT INTO klv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","siEnos, siSet, siAtam, siGot. ");
INSERT INTO klv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nǝboŋ aYesu totǝlmam dan Nawisel Jortan, epul hǝn aNunun aGot ale aNunun esǝhari len naut masmas tob̃ǝb̃esw. ");
INSERT INTO klv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Len naut enan, len nǝmariboŋ tovi 40, natǝmat italtal ke aYesu tigol nǝsaan. AYesu sǝhan natideh, ale len namǝkot hǝn nǝboŋ galenan, nǝmal ihati. ");
INSERT INTO klv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ŋa natǝmat isor maii ke, “Gǝb̃evi aNatun aGot, kel mai nǝvat egai ke tegǝm vi bǝta.” ");
INSERT INTO klv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ale aYesu isor vari ke, “Natosian siGot ike, ‘Nǝvanuan edǝdas b̃imaur len nabǝta ŋai.’” ");
INSERT INTO klv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Beti natǝmat esǝhari vi mǝhat ale eṽusan nǝkantri p̃isi len navile a pan hǝn aYesu len namityal tom̃idol ŋai. ");
INSERT INTO klv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ale isor mai aYesu ke, “Dereh nigol gaiug gevi Masta a mǝhat hǝn natgalenan p̃isi, nǝyalyalan salito, nilavi mai gaiug, bathut nukad natgalenan tia ale nolǝboi nǝb̃ilavi mai avan ideh notolǝŋoni. ");
INSERT INTO klv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imaienan, gǝb̃etǝŋedur, lotu hǝn ginau, natit p̃isi dereh tevi esam̃.” ");
INSERT INTO klv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","AYesu isor vari ke, “Natosian siGot ike: ‘Gilotu hǝn Nasub̃ aGot sam̃ m̃au, gigol nalotuan van hǝn gai sǝb̃on.’” ");
INSERT INTO klv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Beti natǝmat esǝhari vi Jerusalem, eriŋi egilgile a mǝhat buni len naim siGot. Ikel maii ke, “Gǝb̃evi aNatun aGot, gigol gaiug gabag giteh vi pan, ");
INSERT INTO klv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","husur natosian siGot ike, ‘AGot dereh tikele hǝn aŋel san gail hǝn lǝb̃ekǝtkǝta tǝban gaiug hǝn natideh satemǝdas gaiug. ");
INSERT INTO klv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dereh lipat gaiug vi mǝhat len navǝlalito hǝn asike nariem̃ b̃esǝhot nǝvat!’” ");
INSERT INTO klv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","AYesu isor vari ke, “Ikele am ke, ‘Sagitaltal kitev nǝdaŋan siNasub̃ aGot sam̃ ke timabe.’” ");
INSERT INTO klv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nǝboŋ natǝmat totaltal sob̃uer hǝn aYesu, eriŋ aYesu vir nǝboŋ tile tovoi am. ");
INSERT INTO klv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ale aYesu etǝlmam vi Kalili len nǝdaŋan seNunun aGot, ale nǝvanuan gail luhol husur gai len naut p̃isi todar vis naut enan. ");
INSERT INTO klv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ep̃usan len naut nab̃onb̃onan seJu gail, ale galit p̃isi lusor sal suhi len naholan salito. ");
INSERT INTO klv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Evi Nasaret, naut enan gai totibau lan, ale len nǝSappat eb̃is len naim nab̃onb̃onan hum naṽide san akis. Ale eil hǝn b̃eṽuruŋ natosian siGot. ");
INSERT INTO klv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lulav nalob̃ulat tobul maii, nalob̃ulat ahai kelkel ur, aIsaiah totosi. Ale evuhe, isab̃ naut aIsaiah totosi ke: ");
INSERT INTO klv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ANunun aGot eb̃is len ginau, bathut gatovǝhas ginau hǝn b̃itabtabuh len ginau, hǝn nǝb̃ikel ur na-kel-uri-an tovoi mai namǝsal gail. Gatosǝvat ginau hǝn nǝb̃ikel ur navivilean van hǝn alat lotobǝbaŋis, nakǝtaan van hǝn ametb̃esw gail, nǝmakuvan van hǝn alat, nǝvanuan gail lotogol tosa habat hǝn galito, ");
INSERT INTO klv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mai hǝn nǝb̃ikel ur nasihau Nasub̃ aGot b̃igol b̃ivoi masuṽ van hǝn nǝvanuan san gail lan.” ");
INSERT INTO klv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nǝboŋ aYesu toṽuruŋi tonoŋ, ebul gat nalob̃ulat, ilav tǝlmam hǝni mai avanuan na-vi-tarhǝte-an, ale ebǝtah. Nǝmet p̃isi len naim nab̃onb̃onan lokǝta mǝtaltal hǝni, ");
INSERT INTO klv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ale etub̃at sor mai galit ke, “Damǝŋai len na-sǝsǝloŋ-hǝni-an samito, natosian egai siGot imadhasarpoh.” ");
INSERT INTO klv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Galit p̃isi lusor ivoi husuri. Lup̃aŋ len nasoruan togomah aYesu tokele, ale lousus galit gabag ke, “Ategai savi anatun aJosef a?” ");
INSERT INTO klv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ale aYesu isor mai galit ke, “Dereh gamit mitikel nasoruan kǝta egai mai ginau ke, ‘Hai rererer girer hǝn gaiug gimaur! Gole len naut matmat sam̃ hun namtosǝsǝloŋ hǝn gotogole len navile a Kapernaum.’” ");
INSERT INTO klv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","AYesu isor am ke, “Ganan, nukel nakitinan mai gamit ke, sǝkad ahai kelkel ur ideh lotohǝhaṽur hǝni len naut a im san, lomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nukel nakitinan ke, len nǝboŋ siElijah naut a Israel ikad nǝbatunau pǝhaṽut isob̃ur. Len naut enan ipar us len nasihau totor mai nahǝbati tomǝlevtes. Len naut p̃isi nǝhanian eb̃uer. ");
INSERT INTO klv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Be aGot sasǝvat aElijah van hǝn nǝbatunau ideh ei, ao, esǝvati van hǝn nǝbatunau sual a Sarefat pǝpadaŋ hǝn naut a Siton. ");
INSERT INTO klv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ale Len nǝboŋ siElisah tovi hai kelkel ur len naut a Israel, alat lotokad naleprosi lusob̃ur, avil aGot sagol galit ideh sǝmaur, igol aNaaman, uleSiria ŋai imaur.” ");
INSERT INTO klv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nǝboŋ alat lotosuh len naim nab̃onb̃onan lotosǝsǝloŋ hǝn tokǝmaienan, nǝlolit p̃isi ipaŋpaŋ masuṽ. ");
INSERT INTO klv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lule mǝhat, hut aYesu dan navile enan, ale sǝhari van hǝn nabuŋon hǝn naṽehuh, naut enan topat lan, hǝn lǝb̃ibar hǝni vi pan. ");
INSERT INTO klv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Be aYesu egis tur len naluṽoh, iyar vi tut. ");
INSERT INTO klv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Beti evi pan vi Kapernaum a Kalili ale len nǝSappat eṽusan nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lup̃aŋ len nap̃usanan san husur nasoruan san ikad nǝdaŋan hǝn namitisau mai na-il-a-m̃o-an. ");
INSERT INTO klv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Len naim nab̃onb̃onan ikad naulum̃an, nanunun nǝmargobut setǝmat totoh lan. Ikai habat ke, ");
INSERT INTO klv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wii! Imab gotuh gaiug hǝn ginamit, aYesu ta Nasaret? Gogǝm hǝn gǝb̃igol namteb̃uer a? Ginau nolǝboi gaiug. Gaiug govi siGot gotogǝm m̃osi!” ");
INSERT INTO klv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","AYesu isor idaŋ maii ke, “Gemǝdau! Gimakuv vi tut dan atenan!” Beti natǝmat igol iteh, taltaloŋ len tan rivuh len galito, ale eriŋ atenan sǝkad nasǝnahan. ");
INSERT INTO klv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nǝvanuan p̃isi lomǝtahw, lup̃aŋ, ale lousus galit gabag ke, “Nap̃usanan saganan? Len na-il-a-m̃o-an mai nǝdaŋan, gai isor idaŋ mai nanunun nǝmargobut gail, ale lumakuv!” ");
INSERT INTO klv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Beti na-kel-uri-an husur aYesu iperŋan naut p̃isi todar visi naut enan. ");
INSERT INTO klv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","AYesu eriŋ naim nab̃onb̃onan, evi lan naim sivan sua nahǝsan aSimon. Len nǝboŋ enan anan asoan aSimon elǝŋon isa masuṽ hǝn topud hǝn namǝsahan, ale lous aYesu hǝn b̃igol b̃imaur. ");
INSERT INTO klv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Beti aYesu eil ben alitenan, ale isor idaŋ van hǝn namǝsahan. Vǝha-sua ŋai namǝsahan inoŋ dani, ale ile mǝhat, lav nǝhanian mai galito. ");
INSERT INTO klv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nǝboŋ namityal tomasur, nǝvanuan gail losǝhar alat lotomǝsah p̃isi hǝn namǝsahan tiltile van hǝn aYesu. Eriŋ navǝlan gǝlar len galit ṽisusua, ale lumaur, ");
INSERT INTO klv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","mai natǝmat isob̃ur lumakuv. Nǝboŋ lotomakuv, lukai habat ke, “Gaiug govi aNatun aGot!” Be aYesu ikai tas galito ke salisor am husur lolǝboii ke evi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nǝboŋ nǝmav topitau, aYesu evi lan naut tob̃ǝb̃esw. Naluṽoh ludoŋi, doŋi van ale nǝboŋ lotosab̃i, loil kǝkol hǝni hǝn asike b̃eriŋ galito. ");
INSERT INTO klv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Be ikel mai galit ke, “Ginau nimasvi lan nab̃iltivile tile gail am hǝn nǝb̃ikel ur natohan pipihabǝlan aGot, bathut aGot esǝvat ginau m̃osi.” ");
INSERT INTO klv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Beti len naim nab̃onb̃onan gail a Jutea, aYesu ikel ur tabtab hǝn nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Boŋ sua aYesu toil tarhǝt nab̃iltiwai lotokisi hǝn Nab̃iltiwai Kennesaret. Naluṽoh loririhit garu lan hǝn lǝb̃esǝsǝloŋ hǝn nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ale aYesu eris nab̃ot eru artokir tarhǝwai, len naut nǝvanuan nǝsahiehan gail lotoriŋi. Galito lokǝkas nalevlev salito. ");
INSERT INTO klv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Isah len nab̃ot sivan sua nahǝsan aSimon, ale eusi ke tesul hǝni vi lau kǝkereh. Beti ebǝtah len nab̃ot, eṽusan alat lotosuh a ut. ");
INSERT INTO klv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nǝboŋ tosor tonoŋ, ikel mai aSimon ke, “Rusan nab̃ot vi lan naut tosareh am, ale bar hǝn nalevlev hǝn mǝtb̃isah hǝn naieh.” ");
INSERT INTO klv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ASimon isor vari ke, “Masta, len mariug namtohishisi sob̃uer van naut ilan. Be husur gotokǝmaienan, namtibar hǝn nalevlev tǝtas am.” ");
INSERT INTO klv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nǝboŋ lotobar hǝni, lusab̃ naieh isob̃ur lan, gol ke nalevlev etub̃at hǝn b̃emǝtar. ");
INSERT INTO klv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Imagenan lob̃ilival van hǝn alat lotosuh len nab̃ot togon hǝn lǝb̃egǝm susupah hǝni mai galito. Logǝm, usan nab̃ot gǝlar p̃isi aropul vǝtah bǝhbǝhw! ");
INSERT INTO klv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nǝboŋ aSimon Pita toris natenan, iteh bathurien aYesu ike, “Givan dan ginau Nasub̃, husur novi vanuan tosa masuṽ!” ");
INSERT INTO klv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ekǝmaienan husur gai mai alat lotosuh maii, losǝhoṽut hǝn naieh tosob̃ur lotosah hǝni. ");
INSERT INTO klv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","AJemes mai aJon, anatun aSepeti gǝlar artob̃on mai aSimon len nauman, gǝlar tu arosǝhoṽut. Beti aYesu ikel mai aSimon ke, “Sagemǝtahw; asike gosǝsahieh am, damǝŋai van dereh gisah hǝn nǝvanuan gail.” ");
INSERT INTO klv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ŋa loliv nab̃ot eru enan salito vahut, ale loriŋ natit p̃isi esuh, lohusur aYesu. ");
INSERT INTO klv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nǝboŋ aYesu totoh len nab̃iltivile sua, avan sua tokad naleprosi len niben kavkav egǝm hǝni. Nǝboŋ toris aYesu iteh len tan, ekǝta vi pan ale eŋiri ke, “Nasub̃, gǝb̃elǝŋoni, golǝboi gǝb̃igol nǝb̃imaur, nǝb̃iveveu.” ");
INSERT INTO klv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ŋa aYesu isar hǝn navǝlan, ibari ale ikel maii ke, “Nolǝŋoni. Gimaur, giveveu!” Vǝha-sua ŋai naleprosi ivan dani. ");
INSERT INTO klv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Beti aYesu ikele hǝni ke, “Sagikel nǝsa tovisi mai avan ideh. Be givan, geṽusan gaiug hǝn ahai tutumav. Ale geviol hǝn naviolan m̃os natutumavan hum aMoses tokele tia hǝn naveveuan sam̃ hǝn gǝb̃eṽusan galit ke gumaur.” ");
INSERT INTO klv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Be na-kel-uri-an husur aYesu ivan van am, ŋa nǝvanuan isob̃ur logǝm hǝn lǝb̃esǝsǝloŋ hǝni ale hǝn gai b̃igol galit lǝb̃imaur dan namǝsahan salito. ");
INSERT INTO klv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Avil aYesu eriŋ galit akis, evi lan naut tob̃ǝb̃esw sǝb̃on ale isor mai aTǝman. ");
INSERT INTO klv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Len nǝboŋ sua aYesu ep̃usp̃usan, ale naFarisi gail mai ahai p̃usan gail hǝn nalo lobǝtah ei. Logǝm len navile p̃isi a Kalili mai a Jutea mai naut a Jerusalem. Nǝdaŋan siNasub̃ eb̃is len aYesu hǝn b̃ilav kuv namǝsahan. ");
INSERT INTO klv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Len nǝboŋ enan lalum̃an galevis lupat avan sua len nǝbateh, salǝboi b̃erusan gai. Luke lipati vi lohoim hǝn lǝb̃eriŋi bathurien aYesu, ");
INSERT INTO klv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","avil lohisi sob̃uer, naim epul hǝn nǝvanuan varirihit. Beti lopǝlau vi mǝhat len navurun topapav, ludakuvi, gol nab̃ur lan, ale loriŋ tur hǝn gai mai nǝbateh san vi pan. Loriŋi rivuh len naluṽoh, a m̃o hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nǝboŋ aYesu toris lǝboi nadǝlomian salito ike, “Tegai, gaiug, nǝsaan sam̃ gail lumarub̃at.” ");
INSERT INTO klv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","NaFarisi gail mai ahai p̃usan gail hǝn nalo, nǝnauan salit imaiegai ke, “Gai evi ase tosor maiegai? Inau ke tovi aGot a? Ase elǝboi b̃erub̃at nǝsaan? AGot sǝb̃on ŋai!” ");
INSERT INTO klv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Be aYesu elǝboi nǝnauan salito ale ike, “Nǝnauan len nǝlomito satimaienan. ");
INSERT INTO klv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nǝb̃ike, ‘Norub̃at nǝsaan sam̃ gail,’ o ‘Gile mǝhat, giyar,’ nǝsa emǝdmǝdau am? ");
INSERT INTO klv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Imagenan neṽusan gamito ke aNatun Nǝvanuan ikad nǝdaŋan hǝn b̃erub̃at nǝsaan gail len navile a pan timaiegai….” Ale ikel mai atenan salǝboi b̃erusan gai ke, “Nukel mai gaiug, gile mǝhat, pat nǝbateh sam̃ ale vahim!” ");
INSERT INTO klv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vǝha-sua ŋai ile mǝhat len nǝholito, ipat nǝsa topat lan, isal suh nǝyalyalan siGot, ivahim. ");
INSERT INTO klv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Galit p̃isi lumaŋmaŋ vǝsa ale lusal suh nǝyalyalan siGot. Lumaŋmaŋ masuṽ, lomǝtahw ale luke, “Damǝŋai nǝsa dattorisi etile buni.” ");
INSERT INTO klv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Natgalenan tonoŋ, husur nǝboŋ enan, aYesu evivile ale eris nǝvanuan nǝtaks sua, nahǝsan aLevi, tobǝtah len nǝpasvalǝval hǝn nǝtaks. Ale ikel maii ke, “Gitah mai ginau, gehusur ginau!” ");
INSERT INTO klv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ale eriŋ natit gail p̃isi ipat, ile mǝhat, ehusuri. ");
INSERT INTO klv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Beti aLevi eutaut hǝn nab̃iltihanan m̃os aYesu len naim san, ale ikad nab̃iltiluṽoh hǝn alat lotoum sum̃an aLevi mai galevis am luhan mai galito. ");
INSERT INTO klv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Be naFarisi gail mai ahai p̃usan salit gail hǝn nalo, lukel mǝtmǝtan hǝn aYesu mai ahai susur san gail. Luke, “Imabe mǝttohan, mǝttomun mai nǝvanuan nǝtaks gail mai alat nǝsaan am?” ");
INSERT INTO klv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","AYesu isor var galit ke, “Savi alat lotomaur lotovan hǝn nǝvanuan nareran, be alat lotomǝsah ŋai. ");
INSERT INTO klv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ginau nǝsagǝm hǝn nǝb̃ikel alat lotonor hǝn lǝb̃ipair dan nǝsaan salito be nogǝm hǝn nǝb̃ikele mai alat nǝsaan.” ");
INSERT INTO klv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Beti lukel maii ke, “Ahai susur siJon gail, nǝboŋ isob̃ur lǝsǝhan hǝn lǝb̃isor tuṽ, mai ahai susur sinamit, naFarisi gail, lumagenan, be esam̃ gail imabe lotohan, lotomun?” ");
INSERT INTO klv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","AYesu isor var galit ke, “Nǝboŋ avan sua tolah, godǝdas gǝb̃igol nǝvanuan san gail lotob̃on maii hǝn salihan. ");
INSERT INTO klv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Be dereh tikad nǝboŋ hǝn lǝb̃esǝhar naulum̃an tolah dan nǝvanuan san gail. Len nǝboŋ enan asike luhan.” ");
INSERT INTO klv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Beti aYesu ep̃usan, ib̃ol ke, “Sǝkad avan ideh totar nap̃isihoh dan nahurabat veveu ale tosode len nahurabat tomatu. Tagole, tamǝdas nahurabat veveu ale nap̃isihoh asike tanor hǝn nahurabat tomatu. ");
INSERT INTO klv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nǝvanuan gail lǝsab̃ir nǝwain lotomadhaum hǝni len nahurhuwain tomatu. Nǝvanuan tagole, ale nǝwain veveu tatǝvah tur lan, ale nahurhuwain tapǝlaus. Nǝwain tariv dani ale nahurhuwain tǝsa. ");
INSERT INTO klv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aoa, nǝvanuan gail leb̃ir nǝwain veveu len nahurhuwain veveu. ");
INSERT INTO klv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Avil sǝkad avan ideh tomun nǝwain tomatu tolǝŋon toveveu husur ike, ‘Nǝwain tomatu ivoi sǝhori,’ ale gamit mǝtumaienan, mǝtomǝtahun natit toveveu.” ");
INSERT INTO klv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Len nǝSappat sua aYesu mai ahai susur san gail luyar tur len nǝmarireu hǝn nawit, ale ahai susur gail lotub̃at kin b̃ur nǝhavhuwit gail. Lusarsari len navǝlalito ale luhan namisurhuwit gail. ");
INSERT INTO klv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","NaFarisi galevis lousi ke, “Imabe mǝtugol nǝsa nalo tokai tasi len nǝSappat?” ");
INSERT INTO klv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","AYesu isor var galit ke, “Mǝtsaṽuruŋ lǝboi nǝsa aTevit galito lotogole nǝboŋ lotomalkǝkat a? ");
INSERT INTO klv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Eb̃is len naim nǝtap̃olen siGot, ale ilav nabǝta tolo. Ihani ale ilavi mai lalum̃an san. Be nalo ike ahai tutumav sǝb̃olit ŋai lolǝboi lǝb̃ihani.” ");
INSERT INTO klv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Beti aYesu ikel mai galito ke, “ANatun Nǝvanuan evi masta hǝn nǝSappat. NǝSappat ipat len navǝlan.” ");
INSERT INTO klv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Len nǝSappat sua tile am, aYesu evi lan naim nab̃onb̃onan, ep̃usan. Ale ikad avan sual ei, navǝlan nǝmatu totah, togǝm hum towas. ");
INSERT INTO klv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","NaFarisi gail mai ahai p̃usan gail hǝn nalo ludas p̃isal hǝn lǝb̃isab̃ nǝsaban ideh len aYesu hǝn lǝb̃ikot hǝni. Ŋa lokǝta bunusi ke b̃igol atenan b̃imaur len nǝSappat salito. ");
INSERT INTO klv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Be aYesu elǝboi nǝsa lotonau, ale ikel mai naulum̃an tokad navǝlan totah ke, “Gile mǝhat, il rivuh hǝn galit p̃isi.” Imaienan naulum̃an ile mǝhat ale eil ei. ");
INSERT INTO klv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Beti aYesu eus galit ke, “Nous gamito, len nalo nǝsa inor len nǝSappat: datb̃igol navoian o nǝsaan, datb̃etǝgau gat nǝmauran o datb̃igol b̃imasig?” ");
INSERT INTO klv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ekǝta garu len galito, beti ikel mai atenan ke, “Gisar hǝn navǝlam̃.” Igole, ale navǝlan imaur buni tǝtas. ");
INSERT INTO klv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Avil galito, lopul hǝn nǝlol paŋpaŋ vǝsa, ale lotub̃at sor utaut len galit gabag hǝn nǝsa lǝb̃igole van hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Len nǝboŋ galenan sua aYesu evi mǝhat len naṽehuh hǝn b̃isor tuṽ, ale isor mai aGot len nalenmariug kavkav. ");
INSERT INTO klv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dudulan ekis ahai susur san gail gǝmai, ale ilekis hǝn 12 dan galito. Ekis galit hǝn ahai pispisul: ikad ");
INSERT INTO klv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","aSimon (tokisi am hǝn aPita) mai aAdru aṽan, ikad aJemes, aJon, aFilip, aPartolomiu, ");
INSERT INTO klv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","aMattiu, aTomas, aJemes anatun aAlfeus, aSimon tovi naSelot sua, ");
INSERT INTO klv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","aJutas anatun aJemes mai aJutas Iskariot b̃eriŋ aYesu len navǝlan naenemi san gail. ");
INSERT INTO klv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","AYesu eput vi pan mai galito, eil len nabǝmav. Ikad naluṽoh hǝn ahai susur san ei mai nǝvanuan tosob̃ur lotogǝm a Jerusalem mai naut tosob̃ur a Jutea mai galevis ta Tair mai ta Siton. ");
INSERT INTO klv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Logǝm hǝn lǝb̃esǝsǝloŋ hǝni, ale hǝn gai b̃igol namǝsahan salit b̃inoŋ. AYesu ehut nanunun tosa gail dan galit lotokade, ale igol na-lǝŋon-isa-an salit ivoi. ");
INSERT INTO klv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Galit p̃isi lugol risi ke libari bathut nǝdaŋan egǝm len aYesu, igol galit lumaur. ");
INSERT INTO klv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","AYesu ekǝta ris ahai susur san gail ike: “Gamit mǝttom̃idol, navoian siGot igol gagai mǝtukab hǝni husur natohan pipihabǝlan aGot evi samito. ");
INSERT INTO klv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gamit mǝttomalkǝkat gagai, navoian siGot igol gagai mǝtukab hǝni husur dereh mitihanukub. Gamit mǝttotaŋ gagai, navoian siGot igol gagai mǝtukab hǝni husur dereh mitiman. ");
INSERT INTO klv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Gamit, nǝvanuan gail lotomǝtahun bun gamito, lotokai hǝn gamito, lotosor viles gamito, ale lotosor mǝdas nahǝsamit hum tosa bathut aNatun Nǝvanuan mǝttovi esan, navoian siGot igol gagai mǝtukab hǝni. ");
INSERT INTO klv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mitikemkem len nǝboŋ enan, mǝtemǝlmǝlah len nahǝhaṽuran husur nakonp̃urp̃uran samit len nǝmav gag etibau. Nǝvanuan lotogol tosa hǝn gamit maienan, losum̃an atǝmalit ta sutuai lotogol tosa maienan hǝn ahai kelkel ur gail siGot. ");
INSERT INTO klv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Avil gamit mǝttokad natit tosob̃ur, nǝmauran samit tivan tisa vǝsa batbat husur nǝsa mǝttokade evi hǝn nǝboŋ ta damǝŋai ŋai. ");
INSERT INTO klv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gamit mǝttokad nǝhanian tosob̃ur gagai, nǝmauran samit tivan tisa vǝsa batbat husur dereh mitimalkǝkat. Gamit mǝttoman gagai, nǝmauran samit tivan tisa vǝsa batbat husur dereh nǝlomit tisa, mititaŋ. ");
INSERT INTO klv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Gamit, mǝtb̃eum m̃os nǝvanuan p̃isi lǝb̃isal suh gamito, nǝmauran samit tivan tisa vǝsa batbat, husur atǝmalit ta sutuai lugol maienan hǝn ahai kelkel ur gǝgǝras gail.” ");
INSERT INTO klv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","AYesu ep̃usan am ike, “Samtimaienan. Nukel mai gamit mǝttosǝsǝloŋ hǝn ginau ke: Mǝtelǝmas bun aenemi samit gail, gol tivoi van hǝn alat lotomǝtahun bun gamito, ");
INSERT INTO klv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","us aGot hǝn b̃igol navoian van hǝn alat lotosor mǝdas gamito, sor tuṽ m̃os alat lotogol tosa hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Avan ideh b̃iṽos nǝtarhom̃, gipair hǝn nǝtarhom̃ togon van hǝni. Avan ideh b̃ilav nahurabat naut susus sam̃, gidam̃ hǝni ke tilav nǝhai susun sam̃ am. ");
INSERT INTO klv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Geviol mai galit p̃isi lǝb̃eus gaiug hǝn natideh, ale avan ideh b̃ilav natideh sam̃, sageusi ke tilav tǝlmam hǝni. ");
INSERT INTO klv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Naṽide mǝttolǝŋoni ke nǝvanuan gail ligole van hǝn gamito, mitigol naṽide enan van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mǝtb̃elǝmas bun ŋai alat lotolǝmas bun gamito, savi natideh. Husur ke alat nǝsaan am lolǝmas bun alat lotolǝmas bun galito. ");
INSERT INTO klv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mǝtb̃ivoi ŋai hǝn alat lotovoi hǝn gamito, savi natideh. Bathut alat nǝsaan am lugol tomagenan. ");
INSERT INTO klv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mǝtb̃idam̃ hǝn nǝvat ŋai mai alat mǝttonau ke lǝb̃isar gele, savi natideh. Alat nǝsaan am ludam̃ hǝn nǝvat mai galit gabag, hǝn lǝb̃isar gel nǝkabut p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Be ivoi ke gamit mǝtetile. Mǝtelǝmas bun aenemi samit gail, mitivoi hǝn galito. Mitidam̃ hǝn nǝvat mai galito, be samtitoh vir nǝ-sar-gele-an. Mǝtb̃imaienan, dereh aGot tilav nakonp̃urp̃uran totibau mai gamito ale mǝtegǝm vi anatun aGot toyalyal buni. Bathut gai ivoi hǝn alat lǝsasipa vi tǝban mai nǝvanuan nǝsaan gail. ");
INSERT INTO klv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nǝlomit timastaŋis nǝvanuan gail sum̃an aTǝmamit len nǝmav nǝlon totaŋis galito.” ");
INSERT INTO klv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","AYesu isor am ke, “Samtike nǝvanuan tile isa ale aGot asike ike mǝtusa. Samtisab̃ sǝhoti ke nǝvanuan tile timaspanis. Imagenan aGot asike isab̃ sǝhoti ke gamit mitimaspanis. Mǝterub̃at nǝsaan nǝvanuan togole hǝn gamito, imagenan dereh aGot terub̃at nǝsaan samito. ");
INSERT INTO klv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mǝteviol, imagenan dereh aGot teviol mai gamito. Gai dereh teviol hǝn tisob̃ur mai gamito, teirir hǝni, tepul sǝsǝhov variviriv. Bathut mǝtb̃eviol habat o mǝtb̃eviol kǝkereh, aGot teviol magenan mai gamito.” ");
INSERT INTO klv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","AYesu ep̃usan am, ib̃ol maiegai ke: “Ametb̃esw elǝboi b̃esǝhar ametb̃esw togon a? Aoa, gǝlar p̃isi dereh aripal suluṽi, ariteh len nab̃ur. ");
INSERT INTO klv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ahai susur, satibau sǝhor ahai p̃usan san, be avan ideh tolǝboi sǝhot p̃is nap̃usanan sihai p̃usan san, dereh tesum̃an gai. ");
INSERT INTO klv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Husur nǝsa gotokǝta kot nakumashǝhai len namǝtan aṽam̃, be gǝsǝnau nab̃iltitarhai len namǝtam̃? ");
INSERT INTO klv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Imabe gotoke, ‘Wawa, nidakuv nakumashǝhai dan namǝtam̃,’ nǝboŋ gotokad nǝtarhai gǝsarisi len namǝtam̃? Gaiug gotovi vanuan gǝgǝras, gilav kuv nǝtarhai dan namǝtam̃ bai. Gǝb̃igole b̃inoŋ nakǝtaan sam̃ dereh timasil tinor hǝn gǝb̃idakuv nakumashǝhai dan namǝtan aṽam̃. ");
INSERT INTO klv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nǝhai tovoi sǝṽan hǝn naṽit tosa. Nǝhai tosa sǝṽan hǝn naṽit tovoi. ");
INSERT INTO klv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Goris lǝboi nǝhai ideh nǝboŋ gotoris naṽite. Nǝvanuan gail lǝsavǝrus naṽit tovoi hun nafik o nakrep len nǝhau tosa tokad nasunite. ");
INSERT INTO klv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nǝvanuan tovoi igol navoian len navoian topul len nǝlon, mai nǝvanuan tosa igol nǝsaan len nǝsaan topul len nǝlon. Bathut, nǝsa nǝvanuan tokele, evivile len nǝsa topul sǝsǝhov len nǝlon. ");
INSERT INTO klv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mǝtokis ginau ke, ‘Masta, Masta,’ be mǝtsagol nǝsa notokele. Imabe? ");
INSERT INTO klv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nǝvanuan p̃isi lotogǝm hǝn ginau, lotosǝsǝloŋ hǝn nasoruan sagw mai lotogole, lumaiegai ke: ");
INSERT INTO klv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ehum avan sua toum hǝn naim, tokir sareh ale toriŋ nǝpaudesen len nǝvat mot. Nǝboŋ nilev togǝmai, nawisel tovi mǝhat, iṽas naim be sakur hǝni husur eum hǝni idaŋ habat. ");
INSERT INTO klv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Be avan ideh tosǝsǝloŋ hǝn nasoruan sagw ale sagole, esum̃an avan sua toum hǝn naim topat len tan, nǝpaudesen tob̃uer. Nǝboŋ nawisel tolev, toṽas naim enan, vǝha-sua ŋai erus, iteh vǝmasirsir.” ");
INSERT INTO klv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nǝboŋ aYesu tokǝmaienan tonoŋ, ibar naut a Kapernaum. ");
INSERT INTO klv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Len naut enan ikad nasenturion sua tokad naslev. Nasenturion enan inau ke naslev san tovoi habat. Be naslev emǝsah, hum ma b̃emǝsol. ");
INSERT INTO klv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nasenturion esǝsǝloŋ hǝn nasoruan husur aYesu, ale esǝvat alat evis lotoil a m̃o hǝn naJu gail van hǝni hǝn lǝb̃eusi ke, tegǝm hǝn b̃igol naslev san timaur. ");
INSERT INTO klv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nǝboŋ lotogǝm hǝn aYesu, loŋiri ke, “Bathut atenan inor, ivoi hǝn gǝb̃igol nategai m̃osi, ");
INSERT INTO klv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","husur elǝmas bun nǝvanuan sadit gail, ale eum hǝn naim nab̃onb̃onan sinamito.” ");
INSERT INTO klv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ŋa aYesu ivan mai galito. Nǝboŋ pǝpadaŋ hǝn b̃ibar naim enan, nasenturion esǝvat esan gail hǝn lǝb̃ikel maii ke: “Nasub̃, ivoi ke sagegǝm pǝpadaŋ am, husur ginau nǝsanor kasi hǝn gǝb̃eb̃is lohoim sagw. ");
INSERT INTO klv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Imaienan nunau ginau ke, nǝsanor kasi hǝn nǝb̃ebubur mai gaiug. Avil gǝb̃ikele ke naslev sagw b̃imaur, dereh timaur. ");
INSERT INTO klv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nokǝmaienan husur ginau nutoh pipihabǝlan alat lotoil a m̃o hǝn ginau, ale nasoltia gail lutoh pipihabǝlagw. Nǝb̃ikel mai tosua ke, ‘Givan,’ dereh tivan; nǝb̃ikel mai sual am ke, ‘Gegǝmai,’ dereh tegǝmai. Nǝb̃ikel mai naslev sagw ke, ‘Gigol nategai,’ ale dereh tigole.” ");
INSERT INTO klv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nǝboŋ aYesu tosǝsǝloŋ hǝni, ip̃aŋ lan. Ipair van hǝn naluṽoh lotohusuri ale ike, “Nukel mai gamit ke; nǝsǝsab̃ nadǝlomian todaŋ maiegai len alat seIsrael.” ");
INSERT INTO klv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Beti alat sinasenturion, gai tosǝvat galito, lotǝlmam vahim ale lusab̃i ke naslev imaur buni. ");
INSERT INTO klv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pelan han aYesu evi Nain, navile sua. Ale ahai susur san gail mai nab̃iltiluṽoh lutah maii. ");
INSERT INTO klv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nǝboŋ aYesu toyar pǝpadaŋ hǝn nametlǝkau hǝn navile, alat a Nain lupat naulum̃an sua tomat vivile, tovi aṽisusua sinan. Lupati len nǝmel. Anan evi batunau, ale nab̃iltiluṽoh a Nain luyar mai alitenan. ");
INSERT INTO klv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nǝboŋ Nasub̃ toris alitenan, nǝlon itaŋisi ale ike, “Sagitaŋ.” ");
INSERT INTO klv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Beti ivan, ibar nǝmel nǝmatan, ale alat lotopati loil. Ike, “Mantuhmar, nukel mai gaiug, gile mǝhat!” ");
INSERT INTO klv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ale nǝmantuhmar ebǝtah mǝhat, etub̃at sor. Beti aYesu eviol hǝni mai anan. ");
INSERT INTO klv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Galit p̃isi lomǝtahw, lumaŋmaŋ ale lusor sal suh nǝyalyalan siGot ke, “Ahai kelkel ur sua toyalyal evisi hǝn gidato!” Lusor am ke, “AGot egǝm hǝn b̃evi tarhǝt sidato, nǝvanuan san gail.” ");
INSERT INTO klv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na-kel-uri-an egai husur aYesu iperŋan naut p̃isi a Jutea mai naut p̃isi todar visi. ");
INSERT INTO klv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ahai susur siJon gail lukel ur natgalen p̃isi maii. Ale ekis galit eru, ");
INSERT INTO klv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","esǝvat gǝlaru van hǝn Nasub̃ hǝn arb̃eusi ke, “Gaiug govi nǝvanuan togǝmgǝmai o ivoi ke namtitoh vir sual am?” ");
INSERT INTO klv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nǝboŋ artogǝm hǝni, arousi ke, “AJon Baptais esǝvat ginamǝru gǝm hǝn gaiug, eusi ke, ‘Govi nǝvanuan togǝmgǝmai o ivoi ke namtitoh vir tile am?’” ");
INSERT INTO klv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Len nǝboŋ enan ŋai aYesu igol nǝvanuan isob̃ur lotokad namǝsahan tiltile lumaur, igol galevis, nanunun nǝmargobut gail lumakuv dan galito. Ale ilav nakǝtaan mai nametb̃esw isob̃ur. ");
INSERT INTO klv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Imagenan isor var gǝlaru ke, “Mǝretǝlmam ale kel mai aJon nǝsa mǝrtorisi mai mǝrtosǝsǝloŋ hǝni: ametb̃esw gail lukad nakǝtaan, alat narielit togau luyar, alat lotokad naleprosi lumaur, luveveu, nǝdariŋ b̃ulb̃ulol gail losǝsǝloŋ mai alat lotomat lule mǝhat dan nǝmatan. Ale alat lotopar tite losǝsǝloŋ hǝn na-kel-uri-an tovoi. ");
INSERT INTO klv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","AGot tigol tivoi hǝn avan ideh sateh dan nadǝlomian len ginau sil nǝsa notogole.” ");
INSERT INTO klv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nǝboŋ ahai pispisul siJon artovan, aYesu etub̃at sor husur aJon mai naluṽoh ke, “Nǝboŋ mǝttovi lan naut masmas tob̃ǝb̃esw, mǝtuvan varis nǝsa? Naṽiliol nǝlan toṽuvi tokurkur a? Aoa! ");
INSERT INTO klv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","B̃eb̃uer, mǝtuvan hǝn mǝtb̃eris nǝsa? Naulum̃an tosun nahurabat nǝvat halit totibau a? Aoa! Alat lotosun nahurabat tomaienan, lotokad nakontit p̃isi, galit losuh len nab̃iltiim sekiŋ gail! ");
INSERT INTO klv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","B̃imaienan, mǝtuvan hǝn mǝtb̃eris nǝsa? Ahai kelkel ur sual a? Evoi, nukel mai gamit ke savi ahai kelkel ur ŋai, iyalyal sǝhor ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Atenan evi nǝvanuan natosian siGot tokel husuri ke: ‘Geris! dereh nesǝvat ahai pispisul sagw a m̃o hǝn gaiug toutaut hǝn nap̃isal sam̃ m̃os gaiug.’ ");
INSERT INTO klv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Nukel mai gamit ke, sǝkad avan ideh napǝhaṽut topasi, tosǝhor aJon; Be len alat lototoh pipihabǝlan aGot, galit ideh tovi ut kǝmas iyalyal sǝhor aJon.” ");
INSERT INTO klv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Galit isob̃ur mai galevis lotovi nǝvanuan nǝtaks aJon tobaptais hǝn galit tia, nǝboŋ lotosǝsǝloŋ hǝn aYesu, lukel lǝboii ke, nap̃isal siGot inor. ");
INSERT INTO klv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Avil naFarisi gail mai alat lotokad namitisau hǝn nalo, aJon sǝbaptais hǝn galito, lomǝtahun p̃is nap̃isal siGot mai nalǝŋonian siGot m̃os galito.) ");
INSERT INTO klv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","AYesu isor am, ike, “Ale naur ta damǝŋai lumabe? Nolǝboi nǝb̃ike lohum nǝsa? ");
INSERT INTO klv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Losum̃an alahutai lotobǝtah len nǝmaket lotokai van hǝn galit gabag ke, ‘Namtoṽuv nab̃uvimal m̃os gamito be mǝtsǝsav; namtokǝkai hǝn nǝb̃e nǝmatan be mǝtsǝtaŋ!’ ");
INSERT INTO klv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Logǝgel hǝn nǝnauan salit tabtab. Nokǝmaienan husur nǝboŋ aJon Baptais togǝmai, sǝhan nabǝta, samun nǝwain, be mǝtuke, ‘Ikad natǝmat.’ ");
INSERT INTO klv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Avil aNatun Nǝvanuan egǝmai, ihan, emun, be mǝtuke, ‘Mǝteris! Naulum̃an tohan tǝmǝhav, tomun vatǝrog. Itah mai nǝvanuan nǝtaks mai nǝvanuan nǝsaan gail!’ ");
INSERT INTO klv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Be alat lotohusur nap̃isal siGot hǝn namitisau hǝn nǝmauran tonor, nǝmauran salito eṽusani ke nap̃isal siGot ekitin.” ");
INSERT INTO klv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ikad naFarisi sua, nahǝsan aSimon, tous aYesu hǝn b̃ihan maii, ale aYesu eb̃is lohoim san, ipat tarhǝgarin hǝn b̃ihan. ");
INSERT INTO klv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nǝboŋ napǝhaṽut nǝsaan sua len nab̃iltivile enan tosǝsǝloŋ hǝni ke aYesu tohan len naim siFarisi enan, ipat nab̃otel nǝhai pǝhas van hǝn aYesu. ");
INSERT INTO klv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eil pǝpadaŋ hǝn narien, itaŋ. Nǝboŋ totaŋ, namǝtarur san iteh len nalohrien aYesu gol arumosmos. Beti igargar narien hǝn navurun, esum̃ narien ale eb̃ir nǝhai pǝhas len narien gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","NaFarisi tous aYesu hǝn b̃ihan, eris natenan. Nǝboŋ torisi inau len gai sǝb̃on ke, “Ategai tavi ahai kelkel ur, talǝboi as tobari, ale talǝboi am naṽide san ke alitenan evi pǝhaṽut nǝsaan.” ");
INSERT INTO klv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","AYesu isor vari ke, “Simon, nukad natesua hǝn nǝb̃ikel mai gaiug.” ASimon ike, “Hai p̃usan, kele.” ");
INSERT INTO klv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","AYesu ib̃ol hǝni ke, “Ikad alaruevis. Arukabut hǝn nǝvat sivan sua todam̃ hǝni mai gǝlaru. Sua ikabut hǝn natenarius tovi 500, togon ikabut hǝn 50. ");
INSERT INTO klv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gǝlar p̃isi arsǝkad nǝvat hǝn arb̃isar gele, ŋa gai ikas kuv nǝkabut sǝlaru. Imaienan, gǝlar ta be elǝmas buni sǝhor togon?” ");
INSERT INTO klv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ASimon isor vari ke, “Hum ma atenan, nǝvanuan tokas kuv nǝkabut san totibau sǝhor togon.” AYesu ike, “Gokitin.” ");
INSERT INTO klv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Beti ipair van hǝn napǝhaṽut ale ikel mai aSimon ke, “Geris alitegai? Nǝboŋ notob̃is lohoim sam̃ gǝsǝlav nǝwai hǝn nǝb̃ekǝkas nariegw, wake namǝtarur selitegai igol nariegw imosmos hǝni ale igargari hǝn navurun. ");
INSERT INTO klv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gǝsasum̃ nǝtarhogw hǝn na-ke-ivoi-an hǝn notogǝmai, wake nǝboŋ notob̃is lohoim, alitegai sasib hǝn tosum̃ nariegw gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gǝsavǝhas nǝkadugw hǝn naoil hǝn naoliv hum naṽide sidato, wake gai eb̃ir nǝhai pǝhas len nariegw gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bathut natgalenan, nukel mai gaiug ke, nǝsaan san gail lotosob̃ur lumarub̃at tia, imaienan gai elǝmas masuṽ hǝn ginau. Avil nǝvanuan, nǝsaan san tokǝkereh tomarub̃at, gai elǝmas bun ginau, be tokǝkereh ŋai.” ");
INSERT INTO klv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Beti aYesu ikel mai alitenan ke, “Nǝsaan sam̃ gail lumarub̃at.” ");
INSERT INTO klv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Be alat lototoh maii len nǝhanan ei lusor mai galit gabag ke, “Ase gagai, torub̃at nǝsaan gail tu maiegai?” ");
INSERT INTO klv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ale aYesu ikel mai alitenan ke, “Nadǝlomian sam̃ gatolav kuv gaiug dan nǝsaan sam̃ gail. Givan, natǝm̃at tipat len nǝlom̃.” ");
INSERT INTO klv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nǝboŋ tonoŋ, aYesu iyar tur len navile gail mai nab̃iltivile gail. Ikel ur na-kel-uri-an tovoi husur natohan pipihabǝlan aGot. Ahai pispisul lotovi 12 lutah maii. ");
INSERT INTO klv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Napǝhaṽut galevis, aYesu togol galit lotomaur dan nanunun nǝmargobut mai namǝsahan, galit am lutah maii. Lovi: aMeri ta Maktala, nanunun nǝmargobut tomǝlevru lotomakuv dani tia; ");
INSERT INTO klv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aJoanna asoan aKusa toil a m̃o hǝn naim siHerot Antipas tovi kiŋ; aSusanna; mai isob̃ur am. Latpǝhaṽut galenan, len nǝsa lotokade, loviol kǝmas hǝn nǝvat salito m̃os aYesu mai nǝvanuan san gail. ");
INSERT INTO klv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nǝboŋ naluṽoh hǝn navile galevis lotogǝm hǝn aYesu, lub̃onb̃on, ale ikel nǝb̃ol p̃usan ke, ");
INSERT INTO klv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Avan sua tomabmabul namisurhut gail ivan vabubulan namisurhuwit han. Nǝboŋ tobubulani maienan, galevis luteh len nap̃isal; nǝvanuan gail lupal gat gail ale nǝman namǝsav luhan p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Galevis luteh len naut tobaŋ vat. Nǝboŋ lototov, lumayoh husur nǝwai eb̃uer len naut enan. ");
INSERT INTO klv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Galevis luteh rivuh len nǝharhǝhau tokad nasunite. Nǝboŋ artotov, nǝhau eruŋ gut bun nawit. ");
INSERT INTO klv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Namisurhuwit galevis am luteh len nǝtan tokǝnoh. Lutov ale sǝdareh luṽan vǝha-100 len nǝsa nǝvanuan tomabule.” Nǝboŋ aYesu tokǝmaienan tonoŋ, ikai ke, “Avan ideh tokad nǝdariŋan hǝn b̃esǝsǝloŋ, tesǝsǝloŋ m̃au!” ");
INSERT INTO klv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ahai susur san gail lousi ke tikel namilen nǝb̃ol p̃usan enan. ");
INSERT INTO klv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ike, “AGot idam̃ hǝni tia hǝn mǝtb̃elǝboi nǝsa tosusuah husur natohan pipihabǝlan aGot, avil nusor mai alatevis tile am hǝn nǝb̃ol p̃usan hǝn ke, “‘naut kǝmas lǝb̃ekǝta, kǝta, lǝsakǝta lǝboi nǝsa aGot togole; naut kǝmas lǝb̃esǝsǝloŋ, sǝsǝloŋ, lǝsasǝsǝloŋ lǝboi nǝsa aGot togole.’ ");
INSERT INTO klv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Namilen nǝb̃ol p̃usan imaiegai ke: Namisurhut gail evi nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Alat lototeh len nap̃isal losum̃an alat lotosǝsǝloŋ, beti natǝmat egǝm, lav kuv nasoruan dan nǝlolito hǝn asike lǝb̃ikad nadǝlomian, asike aGot b̃ilav kuv galit dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Alat lototeh len naut tobaŋ vat losum̃an alat lotolav nasoruan len nakemkeman nǝboŋ lotosǝsǝloŋ hǝni, be nǝharhǝt salit gail lǝsakir sǝdaŋ. Nadǝlomian salit sabǝlav van vǝbar nǝboŋ nǝmauran totaltal kitev nadǝlomian salit ke timabe, ale nadǝlomian salit iteh. ");
INSERT INTO klv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Alat lototeh rivuh hǝn nǝhau tosǝsǝnot, losum̃an alat lotosǝsǝloŋ be len nǝmauran salit tovan, napulan hǝn natite, na-lǝŋon-isa-an mai nahǝhaṽuran, loruŋ gut gat galito gol ke lǝsatov vabǝbau hum lǝsǝmatmatu len nadǝlomian salito. ");
INSERT INTO klv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Avil namisurhuwit gail lototeh len nǝtan tokǝnoh, losum̃an alat lotokad nǝlolit tonor mai tovoi buni. Nǝboŋ lotosǝsǝloŋ hǝn nasoruan siGot, lunau gati, ale len nǝ-daŋ-b̃uri-an, luṽan hǝn naṽit nǝmauran tovoi. ");
INSERT INTO klv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Avan ideh asike epigau nam̃ial hǝn b̃ikabut gole len nab̃iliwai o susuani pipimel. Aoa, eriŋi a mǝhat hǝn b̃em̃ial len narum̃ hǝn alat lotovi lohoim lǝb̃erisi. ");
INSERT INTO klv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Imaienan, natit p̃isi tosusuah, dereh tevisi p̃arp̃ar, natit p̃isi tokǝkol, dereh aGot tesǝŋav hǝni, tevǝhoti. ");
INSERT INTO klv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Imaienan, mǝtesǝsǝloŋ vahvahur nasoruan hǝn mǝtb̃elǝboii. Avan ideh tokad nalǝboian, dereh aGot teviol hǝni am maii, be avan ideh tomǝtahuhn b̃elǝboi nǝsa notokele, dereh aGot tilav kuv nalǝboian tonau ke tokade dani.” ");
INSERT INTO klv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Beti aṽan aYesu matmat gail mai anan logǝm hǝn lǝb̃erisi, be lodǝdas lǝb̃egǝm pǝpadaŋ hǝni husur naluṽoh. ");
INSERT INTO klv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Imaienan napisulan sua egǝm hǝni ke, “Aṽam̃ gail mai anam̃ saltoil vivile. Luke leris gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isor vari ke, “Alat lotosǝsǝloŋ hǝn nasoruan siGot ale lotogol nǝsa tokele, galito lovi anagw mai aṽagw gail.” ");
INSERT INTO klv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Boŋ sua aYesu ikel mai ahai susur san gail ke, “Datevi tarhǝte len nab̃iltiwai egai.” Ŋa lusah len nab̃ot, lugam van. ");
INSERT INTO klv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nǝboŋ lotogamgam van, aYesu ipatmari. Beti nǝlan eṽuv idaŋ len nǝwai, nab̃ot epul, pǝpadaŋ hǝn b̃emun. ");
INSERT INTO klv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ale ahai susur gail lovǝŋon aYesu, luke, “Masta, Masta, dereh datimasig!” Ale aYesu ile mǝhat, isor idaŋ van hǝn nǝlan mai nǝwai topus; ale nǝlan evi pan, nǝwai etǝm̃at. ");
INSERT INTO klv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eus galit ke, “Nadǝlomian samit gai be?” Len namǝtahwan salito lup̃aŋ lan, lousus galit gabag ke, “Ategai ase? Isor idaŋ van hǝn nǝlan mai nǝwai be gǝlaru arugol husur nǝsa tokele.” ");
INSERT INTO klv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Beti lugam kotov nab̃iltiwai dan naut a Kalili vǝbar naut silat a Kerasa. ");
INSERT INTO klv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nǝboŋ aYesu tomariŋ vahut, auleKerasa sua, nanunun nǝmargobut gail lotob̃is lan, ebubur maii. Sutuai atenan sasun nahurabat, satoh len naim, be itoh len nab̃urhuvat nǝmatan gail. ");
INSERT INTO klv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Vǝha-sob̃sob̃ur tia nanunun nǝmargobut itah gati, naut kǝmas lotobaŋis gati hǝn natsen len narien mai navǝlan ale lokǝta kǝkol hǝni, ilav kotov natsen gail ale nanunun tosa ehuti vi lan naut tob̃ǝb̃esw. Nǝboŋ toris aYesu eis habat, iteh bathurien. AYesu ikele hǝn nanunun tosa ke timakuv dan naulum̃an. Ale ikai p̃erhado ke, “Gaiug savi hǝn gǝb̃emǝdas ginau, aYesu, aNatun aGot toyalyal buni! Noŋir gaiug, sagipansem ginau m̃ud!” ");
INSERT INTO klv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ale aYesu eusi ke, “Nahǝsam̃ ase?” Isor vari ke, “Luṽoh,” husur nanunun nǝmargobut isob̃ur lob̃is lan. ");
INSERT INTO klv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ale loŋirŋiri ke satesǝvat galit vi lan nab̃ur nǝpanisan sǝkad nabutite. ");
INSERT INTO klv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ikad nab̃iltivǝshǝbuai lotosusu len naṽehuh ei. Ale nanunun tosa gail loŋiri ke tidam̃ hǝn galito lǝb̃eb̃is len nabuai gail. Idam̃ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nǝboŋ lotomakuv dan naulum̃an, lob̃is len nabuai gail, ale navǝshǝbuai lusarmar mariŋ len naṽehuh, luteh len nǝwai, lomun vǝmat. ");
INSERT INTO klv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nǝboŋ alat lotokǝtkǝta tǝban nabuai gail lotoris nǝsa tovisi, lugam mǝtahw van vakel uri len nab̃iltivile mai naut p̃isi todar visi. ");
INSERT INTO klv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ale nǝvanuan gail logǝm hǝn lǝb̃eris nǝsa tovisi. Nǝboŋ lotobar aYesu, lusab̃ naulum̃an, nanunun nǝmargobut lotomakuv dani, tobǝtah bathurien aYesu. Esun nahurabat tia, mai nǝnauan san ivoi, ale lomǝtahw. ");
INSERT INTO klv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Alat lotorisi lukel uri mai nǝvanuan gail, naṽide hǝn naulum̃an tomaur, natǝmat gail lotomakuv dani. ");
INSERT INTO klv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Imagenan alat a Kerasa p̃isi lous aYesu hǝn b̃ivan dan galit husur lopul hǝn namǝtahwan. Ŋa aYesu isah len nab̃ot hǝn b̃eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Naulum̃an, nanunun nǝmargobut gail lotomakuv dani, eŋiri ke titah maii, be aYesu esǝvati van ke, ");
INSERT INTO klv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Givahim hǝn gǝb̃ikel nǝsa aGot togole m̃os gaiug.” Ŋa atenan ivan, iyar tur len naut p̃isi len nab̃iltivile enan, ikel ur natit p̃isi aYesu togole m̃osi. ");
INSERT INTO klv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nǝboŋ aYesu totǝlmam vi Kalili, naluṽoh lohǝhaṽur hǝn natǝlmaman san husur luvatvat viri. ");
INSERT INTO klv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Beti avan sua toil a m̃o hǝn naim nab̃onb̃onan, nahǝsan aJairus, egǝm, iteh bathurien aYesu, eŋiri ke tivahim maii. ");
INSERT INTO klv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gai ikad natǝbarehreh tosua ŋai nǝdam̃ han tovi 12, be pǝpadaŋ timat. Nǝboŋ aYesu toyar maii van, len nǝyaran san naluṽoh lorihiti. ");
INSERT INTO klv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Galit sua, napǝhaṽut, nǝda han igam len nasihau tovi 12 avil avan ideh edǝdas b̃igol b̃imaur. ");
INSERT INTO klv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iyar pǝpadaŋ a tahw hǝni ale ibar nagilen nahurabat san. Vǝha-sua ŋai nǝda han sǝgam am. ");
INSERT INTO klv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","AYesu eus ke, “As tobar ginau?” Galit p̃isi luke savi galito. APita ike, “Masta, naluṽoh lorihit gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Be aYesu ike, “Avan sua ibar ginau husur nolǝboii ke nǝdaŋan ivan dan ginau.” ");
INSERT INTO klv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nǝboŋ napǝhaṽut tonau ke aYesu telǝboii, egǝm hǝni, ipab, iteh bathurien. Len nǝholito ikel maii ke hǝn nǝsa tobari mai nǝsa tovisi ke vǝha-sua ŋai imaur tǝtas. ");
INSERT INTO klv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Beti aYesu ikel mai alitenan ke, “Nadǝlomian sam̃ igol ke gumaur. Givan, nǝlom̃ tikad natǝm̃at.” ");
INSERT INTO klv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nǝboŋ aYesu tosor sal, avan sua egǝm len naim siJairus toil a m̃o hǝn naim nab̃onb̃onan, ike, “Anatvavim̃ imat ebun, sagemǝdas ahai p̃usan am.” ");
INSERT INTO klv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nǝboŋ aYesu tosǝsǝloŋ hǝni, ikel mai aJairus ke, “Sagemǝtahw, riŋ nǝlom̃ len ginau ŋai, ale dereh timaur.” ");
INSERT INTO klv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nǝboŋ tovi lohoim siJairus, sǝdam̃ hǝn avan ideh b̃eb̃is lohoim maii, be idam̃ hǝn aPita, aJemes, aJon, atǝman natǝbarehreh, mai anan, alatenan ŋai. ");
INSERT INTO klv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Len nǝboŋ enan ŋai nǝvanuan p̃isi lutaŋ vaisis hǝni. Ris aYesu toke, “Samtitaŋ, gai sǝmat, ipatmari ŋai.” ");
INSERT INTO klv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Luman sili husur lolǝboii ke imat tia. ");
INSERT INTO klv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Avil aYesu etǝgau nalohvǝlan ikai ke, “Anatugw, gile mǝhat!” ");
INSERT INTO klv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ale nanunun etǝlmam, vǝha-sua ŋai ile mǝhat. Beti aYesu ikel mai alarmisoan ke arevǝŋani. ");
INSERT INTO klv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Anan mai atǝman arumaŋmaŋ avil aYesu ikel idaŋ mai gǝlaru ke saarikel nǝsa tovisi mai avan ideh. ");
INSERT INTO klv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nǝboŋ aYesu tokis b̃onb̃on hǝn ahai pispisul san tovi 12, ilav mai galito na-il-a-m̃o-an mai nǝdaŋan hǝn lǝb̃ehut natǝmat p̃isi mai hǝn lǝb̃igol alat lotomǝsah lǝb̃imaur. ");
INSERT INTO klv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ale esǝvat galito hǝn lǝb̃ikel ur natohan pipihabǝlan aGot mai hǝn lǝb̃igol nǝvanuan gail lǝb̃imaur. ");
INSERT INTO klv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ikel mai galit ke, “Samtipat natideh hǝn nǝyaran samito. Samtipat nǝhai tǝbatehw, nǝhad sǝsǝŋon, nǝvat o nǝhai susun gǝgel. ");
INSERT INTO klv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Naim ideh mǝtb̃eb̃is lan, toh ei vǝbar nǝboŋ mǝtb̃eriŋ navile enan. ");
INSERT INTO klv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nǝvanuan gail lǝb̃emǝtahun gamito, nǝboŋ mǝtb̃eriŋ navile enan, dardar hǝn nǝmasiav dan nariemito hǝn b̃imasil ke aGot sahǝhaṽur hǝn galito.” ");
INSERT INTO klv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nǝboŋ tokǝmaienan tonoŋ lovivile, luyar husur navile ṽisusua. Len naut p̃isi lukel na-kel-uri-an tovoi ale lugol alat lotomǝsah lumaur. ");
INSERT INTO klv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Len nǝboŋ enan aHerot Antipas, tovi vanuan totibau, esǝsǝloŋ hǝn natgalenan lotovisi. Edǝdarŋab̃u lan husur galevis luke aYesu tovi aJon tole mǝhat dan nǝmatan, ");
INSERT INTO klv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","galevis luke tovi aElijah tovisi, mai galevis am luke tovi ahai kelkel ur ta sutuai sua tomaur tǝtas. ");
INSERT INTO klv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Be aHerot ike, “Nuta kotov nǝkadun aJon tia. Imaienan, ase ganan notosǝsǝloŋ hǝn natgalenan husuri?” Ale aHerot idoŋ nap̃isal hǝn b̃ebubur mai aYesu. ");
INSERT INTO klv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nǝboŋ ahai pispisul gail lototǝlmam, lukel mai aYesu nǝsa lotogole. Beti esǝhar galit vi lan nab̃iltivile Petsaita hǝn lǝb̃itoh ei sǝb̃olito, ");
INSERT INTO klv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","avil nǝboŋ naluṽoh lotosǝsǝloŋ lǝboii, lohusuri. AYesu ikel nahǝhaṽuran san mai galito, isor mai galit husur natohan pipihabǝlan aGot, ale igol alat lotomǝsah lumaur. ");
INSERT INTO klv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ut mǝdau, namityal pǝpadaŋ hǝn b̃imasur, ahai pispisul lotovi 12 logǝm hǝni, luke, “Gesǝvat naluṽoh vi tut vi lan navile mai naut gail lotodar vis naut egai hǝn lǝb̃isab̃ nǝhanian mai naut nǝpatan, husur naut egai eb̃ǝb̃esw, ipat a tut.” ");
INSERT INTO klv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ikel mai galit ke, “Gamit mitilav nǝhanian ideh mai galito!” Lusor vari ke, “Namtukad natuhbǝta erim mai naieh eru ŋai, Golǝŋon ke namtivan hǝn namtb̃eṽur nǝhanian m̃os naluṽoh p̃isi a.” ");
INSERT INTO klv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Husur ke ikad naulum̃an tovi 5,000 ei.) Avil ikel mai ahai susur san gail ke, “Mitigol ke lebǝtah hǝn b̃ikad naulum̃an len natuhluṽoh ṽisusua b̃evi 50.” ");
INSERT INTO klv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ale ahai susur gail lugole, galit p̃isi lobǝtah. ");
INSERT INTO klv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","AYesu ilav nabǝta erim mai naieh eru, ekǝta vi lan nǝmav hǝn b̃ike sipa, ale eb̃ur kotov gail. Beti ilav nahudhut gail mai ahai susur gail hǝn lǝb̃epǝpehuni mai nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nǝboŋ galit p̃isi lotohan vǝhanukub tonoŋ, ahai susur gail losǝŋon nǝhad tovi 12 hǝn nasughanian lǝsǝhani. ");
INSERT INTO klv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Len nǝboŋ sua, nǝboŋ aYesu mai ahai susur san gail lototoh sǝb̃olito, aYesu isor tuṽ. Nǝboŋ tosor tuṽ tonoŋ eus galit ke, “Naluṽoh gail, lukel ke ginau ase?” ");
INSERT INTO klv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lusor vari ke, “Galevis luke aJon Baptais, galevis am luke aElijah, galevis tǝtas am luke ahai kelkel ur ta sutuai sua tomaur tǝtas.” ");
INSERT INTO klv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ale eus ke, “Be gamito, mǝtukel ke ginau ase?” APita isor vari ke, “AKristo siGot, gai totabtabuh len gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ikai tas galito ke salikel mai avan ideh nǝsa aPita tomadhakele, ");
INSERT INTO klv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ike, “ANatun Nǝvanuan timaslǝŋon tisa vǝsa, alat lotoil a m̃o hǝn nǝvanuan gail, ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo, limasmǝtahuni, mai gai timasmat, ale len nǝboŋ b̃itor dereh timakuv dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Beti ikel mai galit p̃isi ke, “Avan ideh b̃elǝŋon ke b̃evi ahai susur sagw, satigol nǝsa b̃elǝŋoni be len nǝboŋ p̃isi timasputsan nǝhai balbal san, vusi ale husur ginau. ");
INSERT INTO klv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bathut avan ideh toke b̃etǝgau gat nǝmauran san, dereh timasig be avan ideh nǝmauran san b̃imasig m̃os ginau, dereh aGot tigol timaur vi sutuai. ");
INSERT INTO klv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Avan ideh totǝgau gat natit p̃isi len navile a pan be nǝlon imasig o nǝmauran san vi sutuai eb̃uer, gai ikad nǝsa? Esǝhor nǝsa lan? ");
INSERT INTO klv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Avan ideh b̃emǝmau hǝn ginau mai nasoruan sagw, atenan, aNatun Nǝvanuan temǝmau hǝni balai nǝboŋ b̃egǝm len nǝyalyalan san mai nǝyalyalan seTǝman mai aŋel san gail. ");
INSERT INTO klv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nokitin, galevis lotoil gegai, asike lumat vǝbar lǝb̃eris natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nǝmariboŋ tomǝlevtor husur aYesu tokǝmaienan, esǝhar aPita, aJon mai aJemes, ale lovi mǝhat len naṽehuh hǝn b̃isor mai aGot. ");
INSERT INTO klv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nǝboŋ tosorsor mai aGot, nǝhon egǝm tile mai nahurabat san egǝm pǝhapǝhw buni hun nǝkabil. ");
INSERT INTO klv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Vǝha-sua ŋai naulum̃an eru, aMoses mai aElijah arovisi ");
INSERT INTO klv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","len namǝnas nǝmav, aruhol mai aYesu. Lusor husur nǝsa aYesu b̃igole b̃isarpoh len naut a Jerusalem a tahw hǝn b̃eriŋ navile a pan. ");
INSERT INTO klv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","APita galito lupatmari. Nǝboŋ lotolele, lokǝta ris namǝnas san mai naulum̃an eru artoil maii. ");
INSERT INTO klv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nǝboŋ artosudǝlam̃ aYesu, aPita isor mai aYesu ke, “Masta, ivoi hǝn dattotoh gegai. Namteum hǝn nǝpasvalǝval titor: tesua esam̃, tesua siMoses mai tesua siElijah.” (APita salǝboi nǝsa tokele.) ");
INSERT INTO klv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nǝboŋ tosor sal, nǝmavukasw egǝm kabut gol galito, ale nǝboŋ lotob̃is len nǝmavukasw, aPita galit lomǝtahw. ");
INSERT INTO klv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nadoldol isor len nǝmavukasw ke, “Ategai evi aNatugw nototabtabuh lan; gai, mǝtesǝsǝloŋ husuri!” ");
INSERT INTO klv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nǝboŋ nadoldol tosor tonoŋ, lusab̃i ke aYesu sǝb̃on ŋai itoh. Naut ido hǝn gǝlaru. Len nǝboŋ galenan lǝsasor husur nǝsa lotorisi mai avan ideh. ");
INSERT INTO klv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pelan han, nǝboŋ lotomariŋ dan naṽehuh, nab̃iltiluṽoh lobubur mai aYesu. ");
INSERT INTO klv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naulum̃an sua len galit ikai ke, “Hai p̃usan, noŋir gaiug ke geris anatugw ulum̃an husur nukad esua ŋai. ");
INSERT INTO klv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nanunun sua itahtah gati, vǝha-sua ŋai igol ke ikai habat. Igol evinvinu, iteh taltaloŋ ŋa nabusun iyau, sǝvanvan dani be nǝboŋ tomakuv igol ke niben imap̃ulp̃ul habat. ");
INSERT INTO klv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Noŋir ahai susur sam̃ gail hǝn lǝb̃ehuti be lodǝdasi.” ");
INSERT INTO klv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","AYesu ike, “Gamit mǝtsǝkad nadǝlomian, nǝmauran samit naur ta damǝŋai ikab̃kab̃ur masuṽ. Nitoh mai gamit tebǝlav mabe? Mǝtupar dǝlomian van van van nupetǝmas hǝni. Sǝhar anatum̃ gǝmai.” ");
INSERT INTO klv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nǝboŋ natǝtai togǝm sal, natǝmat ibar hǝni len tan gol ke italtaloŋ. Be aYesu esivoh len nanunun tosa ke tevi tut, beti igol natǝtai imaur, ale eviol tǝlmam hǝni mai atǝman. ");
INSERT INTO klv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Galit p̃isi lup̃aŋ len nǝyalyalan, nǝdaŋan siGot. Nǝboŋ galit p̃isi lotop̃aŋ, lotosor husur natit p̃isi togole, aYesu ikel mai ahai susur san gail ke, ");
INSERT INTO klv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mǝtesǝsǝloŋ vahvahur nasoruan galegai: Avan sua dereh teriŋ aNatun Nǝvanuan len navǝlan nǝvanuan gail.” ");
INSERT INTO klv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Avil lotǝtan hǝn nǝsa tokele, namilen esusuah hǝn ke lodǝdas lǝb̃elǝboii ale lomǝtahw, lomǝtahun lǝb̃eusi hǝni. ");
INSERT INTO klv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ahai susur gail m̃au lotub̃at ṽitṽituh sil ke galit ta be iyalyal sǝhor galito. ");
INSERT INTO klv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","AYesu elǝboi nǝnauan salito ale esǝhar natuhtǝtai, igol eil tǝban. ");
INSERT INTO klv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ale ikel mai galito ke, “Avan ideh tohǝhaṽur hǝn natuhtǝtai sum̃an egai b̃itah maii len nahǝsagw, gai ehǝhaṽur hǝn ginau nǝb̃itah maii. Ale avan ideh tohǝhaṽur hǝn ginau nǝb̃itah maii, gai ehǝhaṽur hǝn atenan tosǝvat ginau. Husur ideh len gamito toriŋ gai a pan, gai m̃au etibau len nabunusian siGot.” ");
INSERT INTO klv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","AJon isor vari ke, “Masta, namtoris avan sua tohut nanunun nǝmargobut gail len nahǝsam̃, ale namtuke satigole husur savi ginamit ideh.” ");
INSERT INTO klv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","AYesu ike, “Samtikai tasi husur avan ideh samǝtahun gamito, gai evi tarhǝt samito.” ");
INSERT INTO klv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nǝboŋ hǝn na-vi-mǝhat-an siYesu egǝm pǝpadaŋ ŋa len nǝboŋ enan ipair hǝn nǝhon vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ale esǝvat ahai pispisul galevis luvan a m̃o. Len nǝyaran salito lob̃is len navile sua a Samaria hǝn lǝb̃eutaut viri; ");
INSERT INTO klv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","be alat navile enan lomǝtahuni husur evi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nǝboŋ ahai susur san gǝlaru, aJemes mai aJon artoris nǝsa tovisi, aruke, “Nasub̃, guke namtekis nǝhab len nǝmav hǝn b̃ihan bun galito?” ");
INSERT INTO klv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Be aYesu ipair, isor idaŋ, esivoh len gǝlaru ke arsanor, ");
INSERT INTO klv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ale lovi lan navile togon. ");
INSERT INTO klv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nǝboŋ lotoyar husur nap̃isal, avan sua ikel maii ke, “Dereh nehusur gaiug naut p̃isi gǝb̃evi lan.” ");
INSERT INTO klv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ale aYesu ikel maii ke, “Nafoks gail lukad nab̃ur patǝpat len tan, mai nǝman namǝsav gail lukad nǝhai ŋodŋod, be aNatun Nǝvanuan sǝkad naut ideh hǝn b̃ipat turuŋ lan, hǝn b̃iŋavŋav.” ");
INSERT INTO klv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ale ikel mai nǝvanuan tile ke, “Gehusur ginau!” Avil ike, “Nasub̃, gidam̃ hǝn ginau nia tavun atǝmagw bai.” ");
INSERT INTO klv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ris aYesu tosor vari ke, “Geriŋ alat lotomat litavun nǝvanuan salit gail lotomat, avil gaiug, gia kel ur natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nǝvanuan tile am ike, “Dereh nehusur gaiug, Nasub̃, be gidam̃ hǝn ginau nivahim hǝn nǝb̃esudǝlam̃ nǝbathudud sagw bai.” ");
INSERT INTO klv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","AYesu isor vari ke, “Avan ideh totǝgau gat nǝhai tivtivtan be tokǝtkǝta tǝlmam, gai sanor kasi hǝn natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Husur nǝboŋ enan, aYesu itabtabuh len ahai susur tile am lotovi 72, ale esǝvat galito lorururu a m̃o hǝni van hǝn navile mai naut p̃isi ke pǝpadaŋ b̃evi lan. ");
INSERT INTO klv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ikel mai galito ke, “Nǝhanian totov tomatu isob̃ur, be nǝvanuan nauman lovis ŋai. Imagenan, mǝteŋir aMasta hǝn nǝmatuan ke tesǝvat nǝvanuan nauman gail vi lan nǝmarireu nǝmatuan san. ");
INSERT INTO klv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mitivan! Nosǝvat gamito mǝttosum̃an natuhsipsip gail rivuh len navǝshǝlipah katkat lotovi enemi gail. ");
INSERT INTO klv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Samtilav nǝpaus van, samtitariv nǝhad, samtitariv naributbut gail; ale samtikel na-ke-ivoi-an mai alat mǝtb̃ebubur mai galit metp̃isal. ");
INSERT INTO klv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nǝboŋ mǝtb̃eb̃is lohoim ideh, mitike, ‘Gamit lohoim egai, mitikad natǝm̃at len nǝlomito.’ ");
INSERT INTO klv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","B̃ikad nǝvanuan tolǝmas natǝm̃at ei, natǝm̃at mǝttokele tipat len nǝlon; b̃eb̃uer, dereh natǝm̃at tetǝlmam van hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mititoh len naim enan ŋai, mitihan, mǝtemun natideh lotolav mai gamito bathut inor hǝn nǝvanuan nauman tikad nap̃urp̃uran hǝn nauman san. Samtelul titau vi lan naim tiltile gail. ");
INSERT INTO klv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nǝboŋ mǝtb̃evi lan navile ideh ale nǝvanuan gail lǝb̃ehǝhaṽur hǝn gamito, mitihan nǝsa lǝb̃eutaut hǝni m̃os gamito. ");
INSERT INTO klv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mitigol alat lotomǝsah limaur ale kel mai galit ke, ‘Natohan pipihabǝlan aGot egǝm pǝpadaŋ hǝn gamito.’ ");
INSERT INTO klv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wake nǝboŋ mǝrb̃evi lan navile ideh ale lǝb̃emǝtahun gamito, mǝtevi lan nametp̃isal han gail ale mitike, ");
INSERT INTO klv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Namrudardar hǝn nǝmasiav hǝn navile samito dan narienamǝru, eṽusani ke aGot sahǝhaṽur hǝn gamito. Be mitimaslǝboii ke, natohan pipihabǝlan aGot egǝm pǝpadaŋ tia hǝn gamito.’ ");
INSERT INTO klv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nukel mai gamit ke, len nǝboŋ aGot b̃epǝpehun nǝvanuan gail, nǝpanismen sinavile enan dereh tesǝhor nǝpanismen b̃ibar naut a Sotom.” ");
INSERT INTO klv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","AYesu isor am husur naut gail lotomǝtahuni ke, “Dereh tisa vǝsa hǝn gaiug, naut a Korasin, ale gaiug am, naut a Petsaita, tisa vǝsa hǝn gaiug! Husur ke nǝtagol namerikel gail len naut a Tair mai a Siton hun notogole len gamǝru, alat naut eru enan lǝtǝpair dan nǝsaan salito, asike lǝtavǝlo, lǝtasun nahurabat toharharo, lǝtabǝtah len nǝmasiav mitihab. ");
INSERT INTO klv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Be husur mǝrsǝpair dan nǝsaan samǝru, len nǝboŋ siGot, aGot tipansem gamǝru sǝhor a Tair mai a Siton. ");
INSERT INTO klv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Gaiug am, naut a Kapernaum, gunau ke aGot tipatpat gaiug mǝhat vǝbar nǝmav a? Aoa! AGot dereh tilav gaiug vi pan vi lan naut nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Beti aYesu ikel mai ahai susur san gail ke, “Avan ideh tosǝsǝloŋ hǝn gamito, gai esǝsǝloŋ hǝn ginau am; avan ideh tomǝtahun gamito, gai emǝtahun ginau am; avil avan ideh tomǝtahun ginau, gai emǝtahun atenan tosǝvat ginau.” Ale ahai susur lotovi 72 luvan. ");
INSERT INTO klv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nǝboŋ ahai susur lotovi 72 lototǝlmam, lohǝhaṽur ale luke, “Nasub̃, natǝmat gail am lugol husur nǝsa namttokele len nahǝsam̃.” ");
INSERT INTO klv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isor var galit ke, “Noris aSetan toteh dan nǝmav hun nǝkabil. ");
INSERT INTO klv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nulav nǝdaŋan tia mai gamito hǝn mǝtb̃ipal gat nǝm̃at mai naskopion gail mai hǝn mǝtb̃esǝhor aSetan mai esan gail; sǝkad natideh mǝtb̃esǝnah lan. ");
INSERT INTO klv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Imagenan samtehǝhaṽur husur nanunun nǝmargobut gail lotogol husur nǝsa mǝttokele, be mitikemkem husur aGot itos gat nahǝsamit tia len nǝmav.” ");
INSERT INTO klv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Beti aYesu, aNunun aGot togol topul hǝn nakemkeman, ike, “Nusal suh gaiug aTata gotovi Masta hǝn nǝmav mai navile a pan, husur gosusuan natgalenan dan alat lotokad nǝkadulito mai alat lotokad namitisau hǝn navile a pan, be gukel vǝhot gail mai alat lotovi ut kǝmas hum atuhlahutai. Evoi aTata, husur gohǝhaṽur hǝn tomaienan.” ");
INSERT INTO klv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","AYesu isor tǝtas ke, “ATǝmagw ilav natit p̃isi mai ginau tia. Sǝkad avan ideh tolǝboii ke ase aNatun aGot, be aTata ŋai elǝboii. Ale sǝkad avan ideh tolǝboii ke ase aTata, be aNatun ŋai elǝboii. Ale gai ilekis hǝn nǝvanuan galevis hǝn b̃evǝhot p̃arp̃ar hǝn aTata mai galito hǝn lǝb̃elǝboii.” ");
INSERT INTO klv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Beti nǝboŋ lototoh sǝb̃olito, aYesu ipair van hǝn ahai susur san gail ike, “Navoian siGot igol ke alat lotoris nǝsa mǝttorisi, lukab hǝni. ");
INSERT INTO klv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bathut nukel mai gamit ke ahai kelkel ur mai nakiŋ ta sutuai lotosob̃ur lolǝŋon ke lǝtaris nǝsa mǝttorisi be lǝsarisi, lolǝŋon ke lǝtasǝsǝloŋ hǝn nǝsa mǝttosǝsǝloŋ hǝni, be lǝsasǝsǝloŋ hǝni.” ");
INSERT INTO klv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Len nǝboŋ sua avan sua tokad namitisau hǝn nalo ile mǝhat, ike aYesu tekǝkos len nasoruan san, ale eusi ke, “Hai p̃usan, nigol nǝsa hǝn nǝb̃ikad nǝmauran vi sutuai?” ");
INSERT INTO klv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","AYesu eusi ke, “AMoses itos nǝsa len nalo? Goṽuruŋi ke ekǝmabe?” ");
INSERT INTO klv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Isor vari ke, “‘Gelǝmas bun Nasub̃ aGot sam̃ len nǝlom̃ kavkav, nanunum̃ kavkav, nǝdaŋan sam̃ kavkav mai nǝnauan sam̃ kavkav; len gaiug kavkav’; ale ‘Gelǝmas bun nǝvanuan totoh pǝpadaŋ hǝn gaiug sum̃an gotolǝmas bun gaiug gabag.’” ");
INSERT INTO klv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","AYesu ike, “Gokitin. Gigole magenan ale dereh gikad nǝmauran vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Avil ike tisor taltal gol gai gabag, ŋa eus aYesu ke, “Nǝvanuan totoh pǝpadaŋ hǝn ginau, ase lai?” ");
INSERT INTO klv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Len na-sor-vari-an san aYesu ib̃ol p̃usan ke, “Nǝboŋ aulum̃an sua tovi pan dan naut a Jerusalem vi Jeriko, nǝvanuan vǝnvǝnah gail lom̃ur van hǝni, lukolkol nahurabat san dani, luṽasi, ṽasi, ṽasi van, ale loriŋi imatmatioṽ ei, luvan dani. ");
INSERT INTO klv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ikade ke ahai tutumav sua ehusur nap̃isal enan, be nǝboŋ toris atenan, iyar tab tarhǝp̃isal dani. ");
INSERT INTO klv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Imagenan avan sua len nahǝmar aLevi am ehusur nap̃isal enan. Nǝboŋ tobar atenan erisi be iyar tab tarhǝp̃isal dani. ");
INSERT INTO klv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Avil len nǝyaran seuleSamaria sua, ibar naut atenan topat lan. Nǝboŋ torisi, nǝlon itaŋisi. ");
INSERT INTO klv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ŋa ivan hǝni, eb̃ir naoil mai nǝwain len nǝmanuŋ san gail ale ilot gol gail. Eriŋ atenan len natoŋki san, sǝhari van hǝn nahotel sua ale kǝtkǝta tǝban ei. ");
INSERT INTO klv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pelan han ilav kuv natenarius eru ale ilav nǝvat enan mai naulum̃an hǝn naim. Ike, ‘Kǝtkǝta tǝban vir natǝlmaman sagw ale dereh neṽur nǝkabut ideh san.’” ");
INSERT INTO klv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ale aYesu eusi ke, “Len nǝnauan sam̃, len alat lototor, ase itoh pǝpadaŋ hǝn naulum̃an, nǝvanuan vǝnvǝnah gail lotomǝdasi?” ");
INSERT INTO klv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naulum̃an namitisau hǝn nalo isor vari ke, “Atenan tololosa, tovoi hǝni.” Beti aYesu ike, “Givan, gigol timagenan.” ");
INSERT INTO klv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Len nǝyaran salito aYesu evi lan navile sua, apǝhaṽut sua, nahǝsan aMarta totohtoh lan. Gai ike aYesu titoh lohoim san. ");
INSERT INTO klv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ale aṽan, nahǝsan aMeri ebǝtah bathurien Nasub̃, esǝsǝloŋ hǝn nasoran san. ");
INSERT INTO klv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Be aMarta inau masuṽ hǝn naliliuman san, ŋa egǝm tǝban aYesu, eusi ke, “Nasub̃, gumabe? Aṽagw ebǝtah kǝmas be ginau sǝb̃ogw, noum p̃is nauman. Kel maii tevi tarhǝt sagw.” ");
INSERT INTO klv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Avil Nasub̃ isor vari ke, “Marta, Marta, gunau masuṽ hǝn natit tosob̃ur togol nǝlom̃ totuhatuh hǝni; ");
INSERT INTO klv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","be gupar tetesua. AMeri ilekis hǝn nǝsa tovoi am, ale asike nulav kuv naten tovoi dani.” ");
INSERT INTO klv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Boŋ sua aYesu isor tuṽ len naut sua. Nǝboŋ togole tonoŋ, sua len ahai susur san gail isor maii ke, “Nasub̃, ṽusan ginamit hǝn naṽide hǝn na-sor-tuṽ-an sum̃an aJon toṽusani hǝn ahai susur san gail.” ");
INSERT INTO klv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ikel mai galit ke, “Nǝboŋ mǝtb̃isor mai aGot, mǝtekǝmaiegai ke: “‘ATǝmanamito, nahǝsam̃ tiyalyal tabtab, gegǝmai hǝn nǝvanuan p̃isi lǝb̃itoh pipihabǝlam̃. ");
INSERT INTO klv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Geviol mai ginamito hǝn nǝhanian hǝn nǝmariboŋ ṽisusua. ");
INSERT INTO klv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gerub̃at nǝsaan sinamito, sum̃an namttorub̃at nǝsaan silat lotogole hǝn ginamito. Sagidam̃ hǝn natideh hǝn b̃italtal ke namtigol nǝsaan.’” ");
INSERT INTO klv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Beti ikel mai galit ke, “Gamit sua tǝkad nabubur san tagǝm hǝni tub̃loh len mariug ale ike, ‘Wawa, gidam̃ hǝn nabǝta titor mai ginau, ");
INSERT INTO klv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","husur nabubur sagw, len nǝyaran san, egǝm tǝban ginau, ale nǝhanian eb̃uer hǝn nǝb̃ilav maii.’ ");
INSERT INTO klv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Beti ta lohoim, togon tasor vari ke, ‘Sagigol tisa hǝn ginau. Nabopita ekǝkol hǝhaiv tia, ale anatugw gail namtupat tia. Nodǝdas hǝn nǝb̃ile mǝhat viol hǝn natideh mai gaiug.’ ");
INSERT INTO klv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nukel mai gamit ke, naut kǝmas asike ile mǝhat viol maii bathut tovi bubur san, dereh tile mǝhat, teviol hǝn nǝsa togon tolǝŋoni husur eus tabtab hǝni. ");
INSERT INTO klv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ŋa nukel mai gamit ke, usi van, dereh aGot teviol hǝni mai gamito; doŋi van, dereh mitisab̃i; deldel van, dereh nabopita tesǝŋav m̃os gamito. ");
INSERT INTO klv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Husur nǝvanuan p̃isi lotousi, dereh likade; avan ideh todoŋi, dereh tisab̃i; ale avan ideh todeldel, dereh nabopita tesǝŋav m̃osi. ");
INSERT INTO klv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gamit ideh tovi aTata, anatum̃ b̃eus naieh, gilav nǝm̃at maii a? ");
INSERT INTO klv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O anatum̃ b̃eus nǝdavurhuman, gilav naskopion maii a? ");
INSERT INTO klv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Naut kǝmas mǝttosa, gamit mǝtolǝboi mǝtb̃ilav naviolan tovoi gail mai anatumit gail. Be aTata len nǝmav eviol sǝhor gamito; dereh teviol hǝn aNunun mai alat lotous gai!” ");
INSERT INTO klv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Len nǝboŋ sua aYesu ehut natǝmat tob̃utb̃ut. Nǝboŋ natǝmat tomakuv tonoŋ, naulum̃an tob̃utb̃ut a m̃o isor, ale naluṽoh lup̃aŋ lan. ");
INSERT INTO klv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","Ale galit galevis luke ligol aYesu tisab, imaienan lousi hǝn namerikel hǝn nǝmav. Avil galevis am luke, “Gai ehut natǝmat gail len nǝdaŋan siPeelsepul, ab̃iltitǝmat setǝmat gail!” ");
INSERT INTO klv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","AYesu elǝboi nǝnauan salito, ale isor mai galit ke, “Nǝkantri, nǝvanuan han gail lotob̃alkabaŋ, dereh timasirsir, teb̃ǝb̃esw. Mai nahǝmar tob̃alkabaŋ, dereh asike evi bathudud am. ");
INSERT INTO klv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ASetan tǝb̃al mai natǝmat san gail, dereh temǝdas nǝdaŋan san, nǝnauan enan imelmel masuṽ! Nokǝmaienan husur mǝtuke nohut natǝmat gail len nǝdaŋan siPeelsepul. ");
INSERT INTO klv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ginau nǝtahut natǝmat gail len nǝdaŋan siPeelsepul, ahai susur samit gail lohut galit len nǝdaŋan sise? SiPeelsepul a? Imagenan ahai susur samit gail loṽusani ke mǝttosab. ");
INSERT INTO klv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Be nǝb̃ehut natǝmat gail len nǝdaŋan siGot, imagenan, natohan pipihabǝlan aGot ibar gamit tia. ");
INSERT INTO klv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ASetan esum̃an naulum̃an todaŋ tokad natit hǝn nǝb̃alan, tokǝta kǝkol hǝn naim san, ale natit p̃isi san losuh ivoi. ");
INSERT INTO klv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Avil nǝboŋ avan sua todaŋ sǝhori tob̃al maii, ib̃al sǝhori, beti ikol nametǝlai nǝb̃alan san dan niben, ilav kuv natit hǝn nǝb̃alan gai todaŋ lan, ale epǝpehun natit p̃isi san. ");
INSERT INTO klv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Avan ideh satoh len nǝtarhǝt sagw, avan en evi enemi sagw; ale avan ideh sasǝsǝgov mai ginau len nǝmatuan, gai igol imap̃ip̃iriah; asike b̃esǝhar nǝvanuan gail van hǝn aGot, esǝhar nǝvanuan gail van vǝsab.” ");
INSERT INTO klv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","AYesu isor tǝtas am ke, “Datusor husur nahutian hǝn natǝmat gail. Ale, nǝboŋ nanunun nǝmargobut tovan dan nǝvanuan ideh, nanunun nǝmargobut enan iyar turtur naut masmas gail hǝn b̃isab̃ naut ideh hǝn b̃iŋavŋav lan, be idoŋ sob̃uer hǝni. Beti natǝmat ikel mai gai gabag, ike, ‘Netǝlmam bai vi lan naim sagw notogam dani.’ ");
INSERT INTO klv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nǝboŋ tobar nǝvanuan gai tovan dani, nǝvanuan enan ehum naim tob̃ǝb̃esw, lotosir vahvahuri, tuan tǝlmam hǝn natit p̃isi tonor. ");
INSERT INTO klv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Beti ivan vasǝhar nanunun tomǝlevru lotosa masuṽ am sǝhor gai, ale nǝboŋ lotob̃is len nǝvanuan, lutoh tin ei. Ŋa nǝvanuan enan, nǝmauran san isa habat am sǝhor ta m̃o.” ");
INSERT INTO klv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nǝboŋ aYesu tokel natgalenan sal, apǝhaṽut sua len naluṽoh ikai van hǝni ke, “Anam̃, napǝhaṽut topas gaiug mai tovǝhasus hǝn gaiug, aGot igol ivoi hǝni!” ");
INSERT INTO klv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Avil aYesu ike, “Tarhǝt nǝsa gotokele, aGot igol ivoi am hǝn alat lotosǝsǝloŋ husur nasoruan san ale lotogole.” ");
INSERT INTO klv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nǝboŋ naluṽoh pǝpadaŋ hǝn aYesu lotosob̃ur am, ike, “Naur ta damǝŋai lusa masuṽ. Lous namerikel be ginau asike nugol namerikel ideh be nǝsa tovisi hǝn aJonah ŋai. ");
INSERT INTO klv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nǝsa tovisi hǝn aJonah eṽusan alat a Nineveh ke aGot tosǝvati. Imagenan, nǝsa b̃evisi hǝn aNatun Nǝvanuan, dereh teṽusan naur ta damǝŋai ke aGot tosǝvati. ");
INSERT INTO klv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, NaKwin hǝn naSaut dereh tile mǝhat kel kot nǝsaan sinaur ta damǝŋai, tike naur egai limaspanis. Dereh tigol timagenan husur egǝm len nǝtarhǝt navile a pan hǝn b̃esǝsǝloŋ hǝn namitisau siSolomon hǝn nǝmauran tonor, be gagai, ikad natesua gegai toyalyal sǝhor aSolomon. ");
INSERT INTO klv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Len nǝboŋ aGot b̃epǝpehun navoian dan nǝsaan, alat a Nineveh dereh leil, kel kot nǝsaan sinaur ta damǝŋai, like naur egai limaspanis. Alat a Nineveh dereh ligol naten husur ke, nǝboŋ aJonah tokel ur napisulan siGot, galit lupair dan nǝsaan salito, be gagai ikad natesua gegai toyalyal habat sǝhor aJonah. ");
INSERT INTO klv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Avan ideh, nǝboŋ topigau nam̃ial, sasusuani o sariŋi pipib̃iliwai, be eriŋi len nǝhai ririŋ mǝhat hǝn alat lotob̃is lohoim lǝb̃eris nam̃ial han. ");
INSERT INTO klv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Namǝtam̃ ehum nam̃ial tolav nam̃ial mai nibem̃. Nǝboŋ namǝtam̃ tovoi, nibem̃ kavkav epul hǝn nam̃ial. Be nǝboŋ tomǝsah, nibem̃ epul hǝn nǝmargobut. ");
INSERT INTO klv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gigole ke nam̃ial len nǝlom̃ savi margobut. ");
INSERT INTO klv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","B̃imaienan, nibem̃ kavkav b̃epul hǝn nam̃ial, sǝkad nahudhubem̃ tomotmot, dereh tepul hǝn nam̃ial hum nam̃ial nǝboŋ tom̃ias gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nǝboŋ nasoran en siYesu tomadhanoŋ, naFarisi sua eusi hǝn b̃ihan maii, ale aYesu eb̃is lohoim, ipat hǝn nǝtarhǝgarin tǝban natev, ihan. ");
INSERT INTO klv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Avil naFarisi esǝhoṽut husur aYesu sakǝkasǝval a tahw hǝn b̃ihan. ");
INSERT INTO klv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Beti Nasub̃ ikel maii ke, “Gamit naFarisi gail m̃au, mǝtokǝkas navivile hǝn nab̃iliwai mai nasiloh avil len nǝlomito mǝtopul hǝn na-lǝŋon-masuṽ-hǝn-natite-an, mai nǝsaan. ");
INSERT INTO klv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mǝtumelmel! AGot toum hǝn navivile hǝn nǝvanuan, gai eum hǝn nǝlon am. ");
INSERT INTO klv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Be dan nǝsa topat len nǝlomito, viol mai alat lotom̃idol, imagenan natit p̃isi tiveveu len gamito. ");
INSERT INTO klv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Be gamit naFarisi gail, nǝmauran samit tisa vǝsa batbat husur mǝtoviol mai aGot hǝn esua len tosǝŋavur hǝn namint, narue mai natuhluhai gail am dan nǝhol samito be mǝtsalǝŋon husur nanoran mai na-lǝmas-buni-an siGot. Mitimasgol eru enan be sa-nǝlomit tiboŋboŋ hǝn naviolan len tosǝŋavur. ");
INSERT INTO klv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Gamito naFarisi gail, nǝmauran samit tisa vǝsa batbat husur mǝtolǝŋon buni ke mǝtobǝtah a m̃o len naim nab̃onb̃onan, mǝtolǝŋon buni ke nǝvanuan len nǝmaket lukel na-ke-ivoi-an mai gamito. ");
INSERT INTO klv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nǝmauran samit tisa vǝsa batbat husur mǝtosum̃an nab̃ur nǝmatan sǝkad nab̃urhes. Nǝvanuan gail luyar lan be lotǝtan hǝni ke tokad natit tob̃o butite.” ");
INSERT INTO klv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Avan sua tokad namitisau hǝn nalo ike, “Hai p̃usan, nǝboŋ gotokǝmaienan gusor viles ginamit am bolai.” ");
INSERT INTO klv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","AYesu isor vari ke, “Gamit mǝttokad namitisau hǝn nalo, nǝmauran samit tisa vǝsa batbat. Husur mǝtoriŋ namǝlasan len nǝvanuan gail gol lodǝdas lǝb̃evusi, avil gamito mǝtsasusupah mai galito hǝn natideh sasua. ");
INSERT INTO klv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nǝmauran samit tisa vǝsa batbat husur mǝtoum hǝn nab̃urhes topǝhas m̃os ahai kelkel ur gail ke mǝtsahusur galito, atǝmamit gail ta sutuai lotoparu bubun galito. ");
INSERT INTO klv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Imagenan mǝtugol ip̃arp̃ar ke mǝttodam̃ hǝn nǝsa atǝmamit ta sutuai lotogole; galit luparu bubun ahai kelkel ur gail, ale gamit mǝtoum hǝn nab̃urhes salit gail. ");
INSERT INTO klv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bathut enan namitisau hǝn nǝmauran siGot ikele am ke, ‘Dereh nesǝvat ahai kelkel ur mai ahai pispisul gail van hǝn nǝvanuan gail. Dereh nǝvanuan gail liparu bun galevis ale lemǝdas bun galevis am.’ ");
INSERT INTO klv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Husur enan aGot dereh teriŋ nǝmatan sihai kelkel ur p̃isi ta m̃o len natub̃atan hǝn navile a pan len naur ta damǝŋai. ");
INSERT INTO klv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nǝmatan salit etub̃at len nǝda hiApel van vǝbar nǝda hiSekariah lotoparu buni rivuh hǝn nǝmel tutumavan mai naim siGot. Evoi, nukel mai gamito ke aGot tipansem naur ta damǝŋai sil nǝmatan galen p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Gamit mǝttokad namitisau hǝn nalo, nǝmauran samit tisa vǝsa batbat! Husur mǝtokǝkol gat nap̃isal hǝn nǝvanuan gail lǝb̃etǝtan hǝn aGot. Gamito mǝtsalǝboi aGot, ale mǝtomǝdas alat lotolǝŋon ke lelǝboii.” ");
INSERT INTO klv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nǝboŋ aYesu toriŋ naut enan, naFarisi gail mai ahai p̃usan gail hǝn nalo lupair dani, lotub̃at hǝn lǝb̃isor tasi vǝsa, ale lotub̃at hǝn lǝb̃eusi nausian todaŋ gail. ");
INSERT INTO klv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lusor utaut hǝn lǝb̃itah gati, luke ligol tekǝkos len nasoruan san. ");
INSERT INTO klv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nǝboŋ naluṽoh lotogǝm b̃onb̃on, lusob̃ur masuṽ, loririhit palpal rielito, ale aYesu etub̃at hǝn b̃isor mai ahai susur san gail bai, ike, “Mǝtelǝlǝgau! NaFarisi gail lohum nayis, nap̃usanan salito iperŋan nǝvanuan p̃isi be galit gabag lǝsagol nǝsa lotokele. ");
INSERT INTO klv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Natit p̃isi nǝvanuan gail lotokabut gole, dereh aGot tevuhe. Natit p̃isi lotosusuani, dereh tevǝhoti. ");
INSERT INTO klv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imaienan, nǝsa mǝttokele len nǝmargobut, dereh tegǝm len nam̃ial, ale nǝsa mǝttosor lahlah hǝni lohoim, dereh tevivile, nǝvanuan p̃isi lesǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nabubur sagw gail, nukel mai gamit ke, samtemǝtahw len alat lotogol nibemit b̃imat. Nǝboŋ lotogole tonoŋ lodǝdas lǝb̃igol natideh am. ");
INSERT INTO klv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Avil dereh neṽusan gamito hǝn ase m̃au mǝtb̃emǝtahw lan: Mǝtemǝtahw len atenan togol nibemit b̃imat mai tokad nǝdaŋan hǝn b̃ibar hǝn gamito vi lan nǝhab nǝmatan. Nokitin, mǝtemǝtahw lan! ");
INSERT INTO klv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mǝtolǝboi mǝtb̃eṽur nǝsparo erim hǝn nǝvat tokǝkereh toru a? Be nǝlon aGot saboŋboŋ hǝn ideh. ");
INSERT INTO klv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","AGot ep̃uruŋ gat nasivur ṽisusua len nǝkadumito. Samtemǝtahw, len nǝnauan siGot mǝtosǝhor masuṽ hǝn nǝsparo tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nukel mai gamito, avan ideh tokel uri ke tovi esagw len nǝhon nǝvanuan gail, aNatun Nǝvanuan dereh tikel uri ke tovi hai susur sagw kitin len nǝhon aŋel siGot gail. ");
INSERT INTO klv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Be avan ideh tokel uri ke savi esagw mai nǝvanuan gail, dereh nikel uri ke savi esagw len nǝhon aŋel siGot gail. ");
INSERT INTO klv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Avan ideh tosor tas aNatun Nǝvanuan, nǝsaan san dereh timarub̃at dani. Avil nǝvanuan tosor mǝdas aNunun aGot, aGot asike erub̃at nǝsaan enan dani. ");
INSERT INTO klv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nǝboŋ lǝb̃esǝhar gamito a m̃o hǝn nab̃onb̃onan o alat lotoil a m̃o o nǝvanuan totibau gail, samtinau masuṽ ke mitisor kitin mabe husur gamito o mitikel nǝsa, ");
INSERT INTO klv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","bathut len nǝboŋ enan ŋai aNunun aGot dereh teṽusan gamito hǝn nǝsa m̃au mǝtb̃ikele.” ");
INSERT INTO klv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Beti sua len naluṽoh ikel mai aYesu ke, “Hai p̃usan, kel mai aṽagw ke tepǝpehun nasugurun atǝmanamǝr tomat mai ginau.” ");
INSERT INTO klv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Be aYesu ikel maii ke, “Tegai, ase itabtabuh len ginau hǝn nǝb̃isab̃ sǝhot nǝsa b̃inor hǝn gamǝru? Sǝpat len ginau.” ");
INSERT INTO klv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Beti ikel mai naluṽoh ke, “Mǝtelǝlǝgau! Kǝtkǝta kǝkol hǝn gamito ke na-lǝŋon-tǝmǝhav-hǝni-an tiltile gail salibar gamito: husur nǝkadun nǝmauran sinǝvanuan sǝpat len natit tosob̃ur tokade.” ");
INSERT INTO klv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ep̃usan, ib̃ol mai galit ke, “Ikad avan sua topul hǝn nǝvat, nǝtan san topul masuṽ hǝn nǝhanian, ");
INSERT INTO klv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ale gai sǝb̃on inau ke, ‘Nigol nǝsa? Nǝsǝkad naut ideh hǝn nǝb̃etuan nǝhanian hagw b̃esuh lan.’ ");
INSERT INTO klv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Beti ike, ‘Nigol maieg hǝni. Dereh nitohtoh naim nǝhanian sagw gail ale neum hǝn ideh lǝb̃etibau am. Ale dereh netuan namisurhut gail, nǝhanian mai natit p̃isi sagw gail lan. ");
INSERT INTO klv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ale dereh nisor gabag len ginau ke, “Gukad natit tovoi isob̃ur lǝb̃esuh tebǝlav, nasihau tisob̃ur. Giŋavŋav ŋai! Han, mun vahǝhaṽur.”’ ");
INSERT INTO klv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Avil aGot ikel maii ke, ‘Gumelmel! Len mariug damǝŋai gimaslav tǝlmam hǝn nǝmauran sam̃! Ale ase tikad natgalenan gotoutaut hǝni m̃os gaiug?’ ");
INSERT INTO klv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Dereh timaienan hǝn avan ideh tosah tuan natite m̃os gai gabag, be sǝkad nǝsa aGot tolǝŋoni.” ");
INSERT INTO klv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Beti aYesu isor mai ahai susur san gail ke, “Nukel mai gamit ke, samtinau tuhatuh hǝn nǝmauran samito, nǝsa mǝtb̃ihani; samtinau masuṽ hǝn nibemito mai nǝsa mǝtb̃esuni. ");
INSERT INTO klv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nǝmauran esǝhor nǝhanian, ale nibemito esǝhor nahurabat gail. ");
INSERT INTO klv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mitinau nǝman sua, nareven: lǝsǝmabul natideh, lǝsǝlav kukuv nǝhanian, lǝsatuan nǝhanian sasuh lohoim, avil aGot evǝŋan galito. Mǝtosǝhor masuṽ hǝn nǝman gail! ");
INSERT INTO klv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mǝtolǝboi mǝtb̃igol nǝmauran samit tebǝlav am len nǝ-nau-masuṽ-hǝni-an samito a? Aoa, sǝmagenan! ");
INSERT INTO klv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mǝtb̃edǝdas mǝtb̃igol natit tokǝkereh maienan, imab mǝtunau tuhatuh hǝn natit p̃isi am? ");
INSERT INTO klv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mitinau napusihai mai naṽide hǝn natovan han. Saum, sasod nahurabat. Be nukel mai gamit ke napǝhasan hǝn napusihai enan esǝhor napǝhasan siSolomon len nahurabat bilbil san. ");
INSERT INTO klv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","AGot b̃igol napusihai naliol b̃epǝhas maienan, naut kǝmas topus damǝŋai ale pelan topaŋ len naoven; a mǝhat hǝn natenan, tikol nahurabat gail len gamit tabtab. Wereh! Nadǝlomian samit ekǝkereh! ");
INSERT INTO klv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gamito, samtinau tabtab hǝn nǝsa mǝtb̃ihani mai nǝsa mǝtb̃emuni, samtinau tuhatuh hǝni! ");
INSERT INTO klv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Samtehum naluṽoh hǝn nametb̃os len navile a pan lotoumum m̃os natgalenan. ATǝmamit len nǝmav elǝboii tia ke mǝtumaur len natgalenan. ");
INSERT INTO klv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Avil mǝtelǝŋon nǝsa aGot tolǝŋoni len natohan pipihabǝlan, ale dereh natgalenan am legǝm hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Samtemǝtahw, ahai susur sagw mǝttohum natuhvǝshǝsipsip. ATǝmamito ehǝhaṽur hǝn b̃eviol hǝn natohan pipihabǝlan mai gamito. ");
INSERT INTO klv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Mǝtb̃elǝŋon nǝsa aGot tolǝŋoni, ehum mǝttoum hǝn nǝpaus m̃os gamito len nǝmav hǝn asike emǝtartar be topul hǝn nakontit gail. Nakontit galenan, asike eb̃uer, nǝvanuan vǝnvǝnah asike evǝnohi, nǝbarm̃om asike emǝdasi. Bathut ke, naut nakontit sam̃ gail lotopat lan, dereh nǝlom̃ tu tipat tabtab lan. Imaienan mǝtep̃ur hǝn natit samit gail, ale viol hǝn nǝvat han mai namǝsal gail.” ");
INSERT INTO klv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","AYesu isor am ke, “Mǝtesun nahurabat, utaut vir nauman, gol nam̃ial samit tipaŋ tabtab. ");
INSERT INTO klv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mǝtesum̃an nǝvanuan nauman gail lototoh vir amasta salito b̃etǝlmam dan nǝhanan hǝn nǝlahan. Beti nǝboŋ b̃etǝlmam, b̃ideldel, vǝha-sua ŋai lesǝŋav hǝn nabopita m̃os gai. ");
INSERT INTO klv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Navoian tipat len slev gail nǝboŋ amasta b̃etǝlmam, b̃eris lǝboii ke lotolele, lotoutaut viri. Nokitin, gai tesun nahurabat nauman, ale tikel mai galit ke lebǝtah garu len natev, ale dereh tepǝpehun nǝhanian van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Navoian tivan hǝn naslev gail lǝb̃eutaut hǝn nagǝmaian simasta salito naut kǝmas b̃egǝm tub̃loh len mariug o nǝboŋ nǝman b̃ekǝkǝraiko.” ");
INSERT INTO klv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ale aYesu ike, “Be mitinau nategai ke: amahean naim talǝboi namityal nǝvanuan vǝnvǝnah tagǝmai, tautaut hǝn atenan asike tab̃ur naim vi lohoim. ");
INSERT INTO klv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gamit am, mitimasutaut, husur aNatun Nǝvanuan dereh tegǝm len namityal mǝtsǝvatvat viri.” ");
INSERT INTO klv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Beti aPita eusi ke, “Nasub̃, nǝb̃ol p̃usan enan, gukele mai ginamit ŋai o mai nǝvanuan p̃isi am?” ");
INSERT INTO klv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nasub̃ isor vari maiegai ke, “Ase evi nǝvanuan nauman tokad nǝkadun mai namitisau hǝn na-il-a-m̃o-an amasta san toriŋi ke teil a m̃o hǝn nǝvanuan nauman p̃isi, toke tepǝpehun nǝhanian halito len namityal nǝhanan? ");
INSERT INTO klv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amasta b̃ivahim, b̃isab̃ naslev enan togol nauman san, aslev enan dereh tehǝhaṽur habat. ");
INSERT INTO klv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nokitin ke, amasta dereh titabtabuh len naslev enan hǝn b̃ekǝtkǝta tǝban natit p̃isi san. ");
INSERT INTO klv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Avil naslev en b̃ikel mai gai gabag ke, ‘Amasta sagw evǝlo hǝn b̃egǝmai,’ ale b̃etub̃at ṽas alalum̃an mai alatpǝhaṽut nauman, b̃ihan, b̃emun vatǝrog, gai timabe? ");
INSERT INTO klv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Amasta san dereh tetǝlmam len nǝmariboŋ naslev enan sǝvatvat viri, mai namityal naslev salǝboii. Amasta tita kotovi ale riŋi mai alat lǝsǝkad nadǝlomian. ");
INSERT INTO klv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Naslev tolǝboi nalǝŋonian simasta san be sautaut, mai sagol husur nǝsa tokele, dereh amasta tiṽas masuṽ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Be naslev salǝboi nalǝŋonian simasta san ale sagol nǝsa tolǝŋoni, dereh amasta tiṽasi be savi vǝha-sob̃sob̃ur. Avan ideh aGot tolav tosob̃ur maii, aGot ike tilav tǝlmam hǝn tisob̃ur. Mai avan ideh aGot toriŋ tosob̃ur len navǝlan, aGot ike tilav tǝlmam hǝn tisob̃ur am tǝban. ");
INSERT INTO klv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ginau nogǝm hǝn nǝb̃epǝŋas navile a pan; nolǝŋon buni ke tatub̃at paŋ ma tia. ");
INSERT INTO klv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ikad nǝbaptaisan hǝn nǝb̃ibaptais lan; ale nolǝŋon isa masuṽ vir nanoŋan han. ");
INSERT INTO klv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mǝtunau ke notogǝm hǝn nǝb̃ilav natǝm̃at gǝm vi lan navile a pan? Ao! Nukel mai gamito, nulav napǝpehwan. ");
INSERT INTO klv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Damǝŋ van tikad erim len nǝbathudud lǝb̃epǝpehw dan galit gabag, eru arib̃al mai itor, itor lib̃al mai eru. ");
INSERT INTO klv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bathut len ginau, alatmitǝman lepǝpehw, atǝman tib̃al mai anatun ulum̃an, anatun ulum̃an tib̃al mai atǝman; anan tib̃al mai anatvavin, anatvavin tib̃al mai anan; avilah tib̃al mai avuŋon pǝhaṽut, avuŋon pǝhaṽut tib̃al mai avilah san.” ");
INSERT INTO klv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isor tǝtas mai naluṽoh ke, “Nǝboŋ mǝttoris nǝmarigw topit vi mǝhat len nawes, vǝha-sua ŋai mǝtuke, ‘Dereh teus,’ ale imaienan. ");
INSERT INTO klv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mai nǝboŋ nǝlan toṽuv len nasaut mǝtuke, ‘Dereh naut tepud,’ ale imaienan. ");
INSERT INTO klv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Vanuan nagǝgǝrasan gail! Mǝtokǝta lǝboi nǝtan mai nǝmav ke dereh naut timabe, imabe mǝtodǝdas mǝtb̃ekǝta lǝboi nǝsa tovisi gagai? ");
INSERT INTO klv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Imabe mǝtodǝdas mǝtb̃elǝboi nǝsa tonor? ");
INSERT INTO klv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nǝboŋ gotovi lan nakotan mai atenan tosor tas gaiug, len nap̃isal len nǝyaran samǝru gehisi ke mirikad natǝm̃at tǝtas. Asike gǝb̃igole, dereh teliv gargar gaiug vi lan nǝmatsistret, ale nǝmatsistret teriŋ gaiug len navǝlan nalipah, ale nalipah tibar hǝn gaiug len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nukel mai gaiug ke, asike govivile dani vǝbar gǝb̃eṽur p̃is nǝvat hǝn nǝpain nǝmatsistret toriŋi. Len naṽide tomaienan, gimasgol natǝm̃at mai aGot tutut, hǝn asike gǝb̃ipanis.” ");
INSERT INTO klv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ikad alatevis len nǝboŋ enan lotosor mai aYesu husur auleKalili galevis, aPilate tota bun galito, b̃on hǝn nǝda halito mai nǝda hǝn naviolan lototutumav hǝni. ");
INSERT INTO klv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","AYesu isor var galit ke, “Mǝtunau ke alaten a Kalili lusa sǝhor alat a Kalili p̃isi husur nǝmatan salit isa maienan? ");
INSERT INTO klv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ao, nukel mai gamit ke, asike mǝtb̃ipair dan nǝsaan samito, dereh mitimat hum galito. ");
INSERT INTO klv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mǝtunau alat lotovi 18 lotomat nǝboŋ naim tosahsah vi mǝhat a Siloam toteh len galito? Mǝtunau ke lusa sǝhor galit p̃isi am lotosuh a Jerusalem a? ");
INSERT INTO klv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aoa, nukel mai gamit ke, asike mǝtb̃ipair dan nǝsaan samito, gamit p̃isi dereh mitimat maienan.” ");
INSERT INTO klv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Beti aYesu ep̃usan, ib̃ol ke, “Avan sua ikad nǝhai nafik tovutani tia len nǝhol nakrep san, ale ivan vǝdas ṽite lan sob̃uer. ");
INSERT INTO klv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ŋa ikel mai naulum̃an tokǝtkǝta tǝban nǝhol ke, ‘Geris! Husur nasihau itor tia nogǝm das sob̃uer hǝn naṽit nafik len nǝhai egai. Ta b̃uri! Itov kǝmas, mabe?’ ");
INSERT INTO klv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Isor vari ke, ‘Nasub̃, riŋi tipat vir nasihau tesual am. Dereh nekir garu lan beti riŋ natib̃uluk lan. ");
INSERT INTO klv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ale b̃iṽan len nasihau b̃egǝmai, ivoi; be asike b̃iṽan, ta b̃uri!’” ");
INSERT INTO klv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Len nǝSappat sua aYesu ep̃usan len naim nab̃onb̃onan sua. ");
INSERT INTO klv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ikad abareab sual ei, nanunun tosa sua togol niben isa hǝn nasihau tovi 18. Ale etǝmadehw masuṽ, gai edǝdas b̃eil b̃inor. ");
INSERT INTO klv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nǝboŋ aYesu torisi, ekisi gǝmai ale ike, “Bareab, gumadhamakuv dan namǝsahan sam̃.” ");
INSERT INTO klv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ale eriŋ navǝlan gǝlaru lan. Vǝha-sua ŋai eil inor tǝlmam ale isor sal suh nǝyalyalan siGot van. ");
INSERT INTO klv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naulum̃an toil a m̃o len naim nab̃onb̃onan, nǝlon ipaŋpaŋ husur aYesu ilav kuv namǝsahan len nǝSappat, ale ikel mai naluṽoh ke, “Ikad nǝmariboŋ nauman tomǝlevtes. Ŋa mǝtegǝm hǝn mǝtb̃imaur len nǝmariboŋ galenan, samtegǝm len nǝSappat!” ");
INSERT INTO klv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ris Nasub̃ tosor vari ke, “Mǝtovi vanuan gǝgǝras! Gamit p̃isi mǝtsǝsah rub̃at nab̃uluk o natoŋki len nǝSappat ale mǝtsasǝhari vivile hǝn b̃emun a? ");
INSERT INTO klv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Be napǝhaṽut egai, tovi anatvavin aApraham, aSetan tobaŋis gati nasihau tovi 18, sanor hǝn b̃imakuv dan nǝbaŋisian len nǝSappat a?” ");
INSERT INTO klv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nǝboŋ aYesu tokǝmaienan, galit p̃isi lotosor tasi, nahurulit isa habat, be naluṽoh kavkav lohǝhaṽur len natit tovoi buni gai togol gail. ");
INSERT INTO klv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Beti aYesu ike, “Natohan pipihabǝlan aGot imabe? Ehun nǝsa? Nekǝmabe? ");
INSERT INTO klv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ehun namisurhumastat avan sua tobar hǝni len nǝhol san, ale itov, egǝm etibau hun nǝhai, ale nǝman namǝsav gail loum hǝn nǝhai ŋodŋod len nǝpashǝte.” ");
INSERT INTO klv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Beti isor am ke, “Nike natohan pipihabǝlan aGot ehun nǝsa? ");
INSERT INTO klv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ehun nayis, napǝhaṽut sua tolavi, tob̃undasi len nǝhad nǝflaua totor van vǝbar nǝflaua p̃isi totob.” ");
INSERT INTO klv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Beti aYesu iyar tur nab̃iltivile mai navile gail, ep̃usan ale iyar vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ale avan sua eusi ke, “Nasub̃, dereh nǝvanuan levis ŋai limakuv dan nǝpanismen siGot a? Sasob̃ur a?” Ale ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hisi hǝn mǝtb̃eb̃isutur bopita tomagugun; husur nukel mai gamit ke tisob̃ur luke leb̃is lan be lodǝdasi. ");
INSERT INTO klv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nǝboŋ amahean naim tole mǝhat, ale tokǝkol gat nabopita, dereh mǝteil vivile. Mǝtetub̃at deldel len nabopita, mitike, ‘Nasub̃, sǝŋav hǝn nabopita hǝn ginamito.’ Ale gai tisor var gamit ke, ‘Nǝsalǝboi kas gamito. Naut samit a be?’ ");
INSERT INTO klv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Beti mǝtetub̃at sor ke, ‘Namtuhan mai gaiug. Gaiug gop̃usan len nap̃isal sinamit gail.’ ");
INSERT INTO klv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Avil tike, ‘Nukel mai gamito, nǝsalǝboi kas gamito, gamit alat a be? Mǝtevi tut, gamit mǝttogolgol nǝsaan!’ ");
INSERT INTO klv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dereh gamit mititaŋ, mitidesdes batriṽoriṽ len nǝboŋ mǝtb̃eris aApraham, aIsak mai aJakop mai ahai kelkel ur p̃isi len natohan pipihabǝlan aGot be gamit sǝb̃omito, aGot tibar hǝn gamito vivile. ");
INSERT INTO klv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nǝvanuan gail dereh legǝm len nais mai nawes mai nanot mai nasaut, legǝm len naut p̃isi ale lihan len nab̃iltihanan len natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ale mǝteris! Ikad nǝvanuan kǝmas lǝb̃egǝm vi vanuan totibau gail, ale ikad nǝvanuan totibau gail lǝb̃egǝm vi ut kǝmas.” ");
INSERT INTO klv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Len nǝboŋ enan naFarisi galevis logǝm hǝni, lukel maii ke, “Geriŋ naut egai, gam yav dani husur aHerot Antipas ike tigol gimat.” ");
INSERT INTO klv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ale ikel mai galit ke, “Mitia kel mai nafoks enan ke, ‘Damǝŋai mai pelan dereh nehut natǝmat gail sal mai nigol sal nǝvanuan limaur, ale hois nesib.’ ");
INSERT INTO klv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Naut kǝmas, len nap̃isal sagw nimasvan damǝŋai, pelan mai hois, bathut ke len naut a Jerusalem ŋai ahai kelkel ur p̃isi lolǝboi lǝb̃imat. ");
INSERT INTO klv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, gaiug gugolgol ahai kelkel ur gail lumat, gotububun alat aGot tosul galit van hǝn gaiug. Len nǝboŋ isob̃ur tia nuke nihavhav hǝn alahutai sam̃ hun natopǝhaṽut tohavhav hǝn natuhman san gail pipihabǝlan, be gomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mǝteris, naut a im samit eb̃ǝb̃esw. Nukel mai gamit ke asike mǝtoris ginau am vir mǝtb̃ike, ‘AGot tigol navoian van hǝn ategai togǝm len nahǝsan Nasub̃ aGot.’” ");
INSERT INTO klv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Len nǝSappat sua, nǝboŋ aYesu tob̃is lohoim sinǝvanuan sua toil a m̃o hǝn naFarisi gail, hǝn b̃ihan, lokǝta mǝtani. ");
INSERT INTO klv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ale len nǝhon aYesu ŋai ikad naulum̃an narien mai navǝlan gǝlaru lototob. ");
INSERT INTO klv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","AYesu eus alat lotokad namitisau hǝn nalo mai naFarisi gail ke, “Inor hǝn nǝvanuan b̃igol avan ideh b̃imaur len nǝSappat a?” ");
INSERT INTO klv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Be naut eb̃ut, lǝsasor. Ŋa aYesu etǝgau atenan gol ke imaur ale esǝvati van. ");
INSERT INTO klv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Beti eus galit ke, “Gamit ideh b̃ikad anatun o nab̃uluk toteh len nab̃urhuwai, asike goliv kuv tutut hǝni, naut kǝmas tovi nǝSappat a?” ");
INSERT INTO klv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ale lodǝdas lǝb̃isor var natgalen tokele. ");
INSERT INTO klv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nǝboŋ aYesu tobunus ke alat lotogǝm hǝn nǝhanan lotolekis hǝn naut tovoi rivuh, ib̃ol, ep̃usan magegai ke: ");
INSERT INTO klv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nǝboŋ avan ideh b̃eus gaiug hǝn gǝb̃egǝm hǝn nǝlahan ideh, sagilekis hǝn naut tovoi rivuh. Husur nǝvanuan totibau hǝn nǝlahan b̃eus avan ideh totibau tosǝhor gaiug, ");
INSERT INTO klv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dereh gai b̃egǝm hǝn gaiug tike, ‘Gilav namilem̃ mai ategai.’ Ale dereh nahurum̃ tisa, gimasbǝtah vi tut. ");
INSERT INTO klv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Be nǝboŋ avan ideh b̃eus gaiug hǝn gǝb̃egǝm hǝn nǝhanan, lav naut ideh a tahw. Imagenan nǝvanuan totibau hǝn nǝhanan, hum ma b̃egǝm sor mai gaiug hǝn b̃ike, ‘Tegai, gaiug gevi rivuh hǝn gǝb̃ebǝtah b̃ivoi.’ Ale len nǝhon nǝvanuan p̃isi lotohan mai gaiug, dereh getibau. ");
INSERT INTO klv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Husur avan ideh b̃ipatpat gai mǝhat, dereh tegǝm vi ut kǝmas, be ideh b̃igol gai gabag b̃evi ut kǝmas, dereh aGot teputsani.” ");
INSERT INTO klv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Beti aYesu isor mai atenan tousi hǝn b̃ihan ke, “Nǝboŋ gǝb̃ikad nǝhanan tub̃lial o ut mǝdau, sageus nabubur sam̃ gail, aṽam̃ gail, amaheam̃ gail o alat lotosuh pǝpadaŋ lotopul hǝn natite. Gǝb̃igole maienan, dereh leus tǝlmam hǝn gaiug ale enan tevi nǝ-sar-gele-an sam̃ tegǝm hǝn gaiug. ");
INSERT INTO klv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Be nǝboŋ gǝb̃eutaut hǝn nǝhanan, us namǝsal gail, alat nahudhubelit sanor, alat narielit togau mai ametb̃esw gail; ");
INSERT INTO klv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ale aGot tigol navoian van hǝn gaiug. Naut kǝmas lodǝdas lǝb̃isar gel gaiug, dereh nǝ-sar-gele-an tegǝm hǝn gaiug len nǝboŋ alat lotonor lǝb̃ile mǝhat dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nǝboŋ galit sua, tohan maii, tosǝsǝloŋ hǝni, isor mai aYesu ke, “Avan ideh b̃ihan len nab̃iltihanan topat len natohan pipihabǝlan aGot, navoian siGot igol ikab hǝni!” ");
INSERT INTO klv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","AYesu ikel maii ke, “Avan sua eutaut hǝn nab̃iltihanan ale eus isob̃ur. ");
INSERT INTO klv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Len namityal hǝn nǝhanan esul naslev san hǝn b̃ikel mai alat tous galit ke, ‘Mǝtegǝmai, husur natit p̃isi eutaut tia.’ ");
INSERT INTO klv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Be loŋit nǝholito, logǝrasi maiegai: Esua ike, ‘Ereh! Numadhaṽur nǝtan sua ale nimasvan hǝn nǝb̃erisi.’ ");
INSERT INTO klv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sual am ike, ‘Ereh! Numadhaṽur nab̃uluk tosǝŋavur lotoum ṽiruaru ale nimasvan hǝn nǝb̃eum risi lan gail.’ ");
INSERT INTO klv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sua tǝtas am ike, ‘Ereh! Numadhalah ŋai, ŋa nodǝdas nǝb̃egǝmai.’ ");
INSERT INTO klv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ŋa naslev etǝlmam, ikel ur nǝsa lotokele mai amasta san. Beti amahean naim nǝlon ipaŋpaŋ habat ale ikel mai atenan ke, ‘Giŋad tutut vi lan nab̃iltip̃isal mai nap̃isal gail len nab̃iltivile, ale sǝhar namǝsal gail gǝmai, mai alat nahudhubelit sanor, ametb̃esw gail mai alat narielit togau.’ ");
INSERT INTO klv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sǝdareh naslev ike, ‘Nasub̃, nǝsa gotokele, nugol p̃isi, be naut kǝmas alaten lotosob̃ur, nǝhanian isob̃ur ipat sal.’ ");
INSERT INTO klv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Beti amahean naim isor vari ke, ‘Gevi lan nap̃isal, husur napisbihol gail, taltal hǝn nǝvanuan gail hǝn lǝb̃egǝm vi lan naim sagw hǝn b̃epul. ");
INSERT INTO klv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Husur nukel mai gaiug, galit ideh notous galit a m̃o, asike luhan ris nǝhanian len nǝhanan sagw.’” ");
INSERT INTO klv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nab̃iltiluṽoh luyar mai aYesu, ale ipair van hǝn galito, ike, ");
INSERT INTO klv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Avan ideh b̃egǝm hǝn ginau b̃elǝmas masuṽ hǝn ginau sǝhor nǝbathudud san sum̃an tomǝtahun bun atǝman mai anan, asoan mai anatun gail, aṽan mai aṽavinen gail, o nǝmauran san am, ale elǝboi b̃evi ahai susur sagw. ");
INSERT INTO klv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Avan ideh asike b̃ipat nǝhai balbal san ale husur ginau, gai edǝdas b̃evi ahai susur sagw. ");
INSERT INTO klv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Husur gamit ideh b̃ike b̃eum hǝn naim sahsah vi mǝhat; gai tebǝtah bai hǝn b̃ep̃uruŋ tuan nǝvat hǝn b̃elǝboii ke ihau hǝn naim b̃ihav m̃au a? ");
INSERT INTO klv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Asike b̃imaienan, tehir nǝpaudesen san be edǝdas b̃eum p̃isi, ale dereh nǝvanuan p̃isi lotorisi, letub̃at sor vilesi, ke, ");
INSERT INTO klv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Geris atenan. Etub̃at um hǝn naim be edǝdas b̃eum p̃isi.’ ");
INSERT INTO klv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O nakiŋ ta be ia gol nǝb̃alan mai nakiŋ togon be sabǝtah hǝn b̃ebunusi bai ke, nasoltia tovi 10,000 san elǝboi b̃ib̃al sǝhor togon tokad 20,000 togǝm hǝn b̃ib̃al maii m̃au a? ");
INSERT INTO klv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","B̃inau ke edǝdas b̃ib̃al sǝhori, esul avan sua san tosor m̃osi mai nakiŋ togon nǝboŋ totoh a tut sal, hǝn b̃eusi ke, ‘Nǝb̃alan tinoŋ mabe?’ ");
INSERT INTO klv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Imagenan, gamit ideh asike b̃eriŋ gab̃ulan natit p̃isi san, gai edǝdas b̃evi ahai susur sagw. ");
INSERT INTO klv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nǝtas ivoi len nǝhanian, be nabus hǝn nǝtas b̃imasig hǝn b̃edub̃e, tegǝm vi tas tǝtas am mabe? ");
INSERT INTO klv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nǝtas enan sanor hǝn b̃igol nǝtan b̃ivoi, sanor hǝn b̃igol natib̃uluk len naut sogsog b̃ivoi hǝn nǝtan, nǝvanuan p̃isi lubar hǝni ŋai. Avan ideh tokad nǝdariŋan hǝn b̃esǝsǝloŋ, tesǝsǝloŋ buni.” ");
INSERT INTO klv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Boŋ sua nǝvanuan nǝtaks gail mai alat nǝsaan logǝm tǝban aYesu hǝn lǝb̃esǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ale naFarisi gail mai ahai p̃usan hǝn nalo loŋit nǝholito, lusor mǝtmǝtan hǝni ke, “Atenan ehǝhaṽur hǝn alat nǝsaan, ale ihan tu mai galito.” ");
INSERT INTO klv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Imagenan ikel nǝb̃ol p̃usan egai mai galito, ike, ");
INSERT INTO klv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Gamit ideh b̃ikad nasipsip tovi 100 ale esua b̃imasig, timabe? Dereh teriŋ lotovi 99 len nǝmarireu ale tidoŋ tosua tomasig van vǝsab̃i. ");
INSERT INTO klv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nǝboŋ tosab̃i tonoŋ, eriŋi len nǝbathuvǝson, ikemkem. ");
INSERT INTO klv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ale nǝboŋ tovahim, ekis nabubur san gail mai alat lotosuh pǝpadaŋ, logǝm b̃onb̃on. Ike, ‘Mǝtehǝhaṽur mai ginau husur nusab̃ nasipsip sagw tomasig!’ ");
INSERT INTO klv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nukel mai gamit ke, imagenan, len nǝmav dereh tikad nakemkeman tǝban avan ideh topair dan nǝsaan van hǝn aGot b̃esǝhor nakemkeman tǝban alat lotovi 99 lotonor, o lotonau ke lotonor, ke nǝpairan dan nǝsaan sanor hǝn galito.” ");
INSERT INTO klv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ale aYesu isor am ke, “Napǝhaṽut ideh, b̃ikad nakoin lotovi silva tosǝŋavur ale esua imasig, gai timabe? Dereh tepigau nam̃ial, tesisir lohoim, ale doŋ vahvahuri van vǝsab̃i. ");
INSERT INTO klv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ale nǝboŋ tosab̃i ekis nabubur san gail mai alat lotosuh pǝpadaŋ, legǝm b̃onb̃on. Ike, ‘Mǝtehǝhaṽur mai ginau husur nusab̃ nǝvat sagw tomasig.’ ");
INSERT INTO klv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Imagenan, nukel mai gamit ke, aGot mai aŋel san gail lukemkem nǝboŋ nǝvanuan nǝsaan ideh topair dan nǝsaan san.” ");
INSERT INTO klv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ale aYesu isor tǝtas ke, “Ikad naulum̃an sua tokad anatun ulum̃an eru. ");
INSERT INTO klv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ahai a tahw ikel mai atǝman ke, ‘Tata, nahudhutite b̃evi esagw nǝboŋ gǝb̃imat, gilavi mai ginau gagai.’ Ale gai epǝpehun natit p̃isi mai anatun gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sǝdareh ahai a tahw elul hǝn natit p̃isi san, ivan iyar vi lan nǝkantri a tut. Ale len naut enan emǝdas nǝvat san len nǝmauran tosa. ");
INSERT INTO klv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nǝboŋ nǝvat p̃isi san tohav, ikad nǝboŋ nǝhanian tob̃uer len nǝkantri enan kavkav, ale atenan etub̃at par hanian. ");
INSERT INTO klv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ŋa ia tah mai nǝvanuan sua len nǝkantri enan tosǝvati vi lan nǝmarireu san gail hǝn b̃evǝŋan nabuai gail. ");
INSERT INTO klv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nǝmal ihat atenan van ike tihanukub hǝn nab̃ilit naṽit nǝhai tovǝŋan nabuai hǝni, be avan ideh sǝlav natideh maii. ");
INSERT INTO klv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nǝboŋ nǝnauan san tovan vǝmasil, ike, ‘Numabe? Alat lotoum setǝmagw lukad nǝhanian isob̃ur mai hudhuhanian tosuh, be gegai ginau numat hǝn nǝmalkǝkatan! ");
INSERT INTO klv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dereh nile mǝhat, nivan hǝn atata sagw ale nikel maii ke, “Tata, nugol nǝsaan vi tǝban aGot len nǝmav mai nugol nǝsaan vi tǝban gaiug, ");
INSERT INTO klv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","sanor hǝn gǝb̃ike anatum̃ hǝn ginau am. Gol ke nehum nǝvanuan nauman sam̃ ŋai.”’ ");
INSERT INTO klv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ale nǝboŋ tole mǝhat tonoŋ, ivan hǝn atǝman. Be nǝboŋ toyaryar a tut sal, atǝman eris lǝboii, nǝlon itaŋisi ale igam van hǝni, elugum̃ gati, esum̃ nǝtarhon. ");
INSERT INTO klv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Beti anatun isor maii ke, ‘Tata, nugol nǝsaan vi tǝban aGot len nǝmav mai nugol nǝsaan vi tǝban gaiug. Sanor kasi hǝn gǝb̃ike anatum̃ hǝn ginau am.’ ");
INSERT INTO klv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Be atǝman ikel mai naslev san gail ke, ‘Mǝtetutut, lav nahurabat tovoi buni gǝmai, ale kole lan. Siriv hǝn nariŋ len nǝŋarhuvǝlan, kol naributbut len narien gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Liv natuhb̃uluk tokǝnoh gǝmai, tibuni, utaut hǝni, ale datihan, datehǝhaṽur, ");
INSERT INTO klv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","husur anatugw egai imat tia be imaur tǝtas am, imasig tia be evisi am.’ Ale lotub̃at hǝn nahǝhaṽuran. ");
INSERT INTO klv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Len nǝboŋ enan ahai a m̃o itoh marireu. Nǝboŋ togǝm pǝpadaŋ hǝn naim, esǝsǝloŋ hǝn nǝwalan hǝn navus beltaŋ mai nǝsavan, ");
INSERT INTO klv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ŋa ekis naslev sua, ale eusi nǝsa tovisi a im. ");
INSERT INTO klv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ale isor vari ke, ‘Aṽam̃ etǝlmam, ale atǝmam̃ etibun natuhb̃uluk tokǝnoh husur aṽam̃ imaur, etǝlmam.’ ");
INSERT INTO klv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ahai a m̃o, nǝlon ipaŋpaŋ, emǝtahun b̃eb̃is lohoim ale atǝman evivile, isor ṽǝhṽǝhi. ");
INSERT INTO klv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Beti isor var atǝman ke, ‘Geris! Len nasihau isob̃ur noum sam̃, ale sǝkad nǝboŋ ideh notopair dan nǝsa gotokele. Be sǝkad nǝboŋ ideh gotolav natuhnani mai ginau hǝn nǝb̃ikad nahǝhaṽuran mai nabubur sagw gail. ");
INSERT INTO klv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Avil nǝboŋ anatum̃ togǝmai, aten boh tohan p̃is natit p̃isi sam̃ len alatpǝhaṽut lotop̃ur hǝn nibelito, gotibun natuhb̃uluk tokǝnoh m̃osi!’ ");
INSERT INTO klv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Beti isor malum̃lum̃ ke, ‘Anatugw, gaiug gutoh akis mai ginau, natit p̃isi sagw evi esam̃. ");
INSERT INTO klv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Datimasgol nahǝhaṽuran, datimaskemkem bathut aṽam̃ enan imat be gagai imaur, imasig be gagai evisi.’” ");
INSERT INTO klv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Beti aYesu isor tǝtas mai ahai susur san gail ke, “Ikad naulum̃an sua topul hǝn natit isob̃ur tokad nab̃iltivanuan nauman tokǝtkǝta tǝban natit p̃isi san. Amahean enan esǝsǝloŋ hǝn na-kel-uri-an ke nǝvanuan nauman san emǝdas natit san gail. ");
INSERT INTO klv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ale ekisi gǝmai, beti eusi ke, ‘Nǝsaganan notosǝsǝloŋ hǝni len gaiug? Gikel ur nǝsa gotogole len nauman sam̃ hǝn natit p̃isi sagw, husur nauman enan sam̃ hǝn na-kǝtkǝta-tǝban-an esib.’ ");
INSERT INTO klv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nab̃iltivanuan nauman isor len gai gabag ke, ‘Nimabe? Husur amasta sagw ibar hǝn ginau dan nauman sagw. Nǝsǝdaŋ hǝn nakiran; nahurugw isa hǝn nǝb̃eŋir nǝvanuan hǝn nǝvat. ");
INSERT INTO klv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ganan! Nolǝboi nǝsa nǝb̃igole hǝn ke, nǝboŋ nǝb̃esib hǝn nauman sagw nǝvanuan gail dereh lekis ginau vi lohoim salito.’ ");
INSERT INTO klv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Imagenan, ekis nǝvanuan ṽisusua lotokad nǝkabut simasta san. Eus esua ke, ‘Gukabut simasta sagw evis?’ ");
INSERT INTO klv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Isor vari ke, ‘Natram naoil naoliv tovi 100.’ Ale ikel maii ke, ‘Lav nǝkabut sam̃ gǝmai, gebǝtah, gitos 50 tutut.’ ");
INSERT INTO klv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Beti eus togon am ke, ‘Ale gaiug, gukad nǝkabut evis?’ Ale isor vari ke, ‘Nǝhad nawit tovi 1,000.’ Ale ikel maii ke, ‘Lav nǝkabut sam̃ gǝmai, gitos 800.’ ");
INSERT INTO klv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Naut kǝmas nab̃iltivanuan nauman sanor, amasta san isor ivoi hǝni husur elǝlǝgau hǝn gai len namitisau san. Imaienan! Naur ta damǝŋai hǝn navile a pan lukad namitisau hǝn naṽide silat lotosum̃an galito be anatun nam̃ial lǝsǝkad namitisau hǝn naṽide silat navile a pan.” ");
INSERT INTO klv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","AYesu isor am ke, “Nukel mai gamito, lav nǝvat hǝn navile a pan hǝn b̃esusupah mai nǝvanuan gail hǝn lǝb̃egǝm vi bubur samito. Ŋa nǝboŋ nǝvat b̃ihav, dereh aGot tikel nahǝhaṽuran mai gamito len naut a im vi sutuai. ");
INSERT INTO klv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Avan ideh togolgol tonor len natit tovis, gai am igolgol inor len tosob̃ur, ale avan ideh togolgol sanor len natit tovis, gai am igolgol sanor len tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asike mǝtb̃etǝgau b̃inor hǝn nǝvat mai natit gail hǝn navile a pan, asike aGot eriŋ natit tosob̃ur san len navǝlamito. ");
INSERT INTO klv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ale asike mǝtb̃inor hǝn natit sinǝvanuan tile, ase teriŋ natit len navǝlamito hǝn b̃evi samit gabag? ");
INSERT INTO klv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Naslev ideh edǝdas b̃evi slev simasta toru len nǝboŋ tosua. Dereh temǝtahun bun tesua ale telǝmas bun togon o dereh tidaŋ len tesua ale tinau ke togon tovi ut kǝmas. Mǝtodǝdas mǝtb̃eum siGot tovi amasta samito mai nǝvat tu tovi masta samito.” ");
INSERT INTO klv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nǝboŋ naFarisi gail lotolǝmas bun nǝvat lotosǝsǝloŋ hǝn natgalenan, lusor viles aYesu. ");
INSERT INTO klv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ŋa ikel mai galit ke, “Gamit boh mǝtupatpat gamit mǝhat len nǝhon nǝvanuan gail, avil aGot elǝboi nǝlomito. Husur natideh nǝvanuan gail lotodaŋ lan len nǝnauan salito, lotolǝŋon masuṽ hǝni, evi pahsago len nǝnauan siGot, emǝtahun buni.” ");
INSERT INTO klv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","AYesu isor am ke, “Nalo siMoses mai natosian sihai kelkel ur gail, lupat van vǝbar nǝboŋ siJon. Husur nǝboŋ siJon, namtukel ur na-kel-uri-an tovoi husur natohan pipihabǝlan aGot, totaltal hǝn nǝvanuan p̃isi hǝn lǝb̃eb̃is lan. ");
INSERT INTO klv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Idaŋ hǝn nǝmav mai navile a pan arb̃eb̃uer, be idaŋ sǝhori hǝn nǝmap̃irhǝt natosian hǝn nalo b̃imasig. ");
INSERT INTO klv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Naulum̃an ideh totiṽos hǝn asoan ale tolah mai napǝhaṽut tile, atenan igol naitian tob̃ur kotov nǝlahan. Ale naulum̃an ideh tolah mai napǝhaṽut asoan totiṽos hǝni tia, aulum̃an enan igol naitian tob̃ur kotov nǝlahan.” ");
INSERT INTO klv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","AYesu isor am ke, “Ikad naulum̃an sua tokad natite tosun nahurabat toboŋboŋ tokab. Len nǝboŋ p̃isi ikad nakontit tosob̃ur sǝhor nǝsa tonor hǝn nǝmauran san, ale akis ihan len nahǝhaṽuran hǝn nǝhanian tovoi ŋai. ");
INSERT INTO klv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Len nametlǝkau san loriŋ namǝsal sua tovi manus ipat, nahǝsan aLasarus. ");
INSERT INTO klv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ike tihanukub hǝn nasughanian toteh dan natev sitenan tokad natite. Nalipah gail luŋol nǝmanuŋ san gail. ");
INSERT INTO klv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nǝboŋ tobar nǝboŋ san, amǝsal imat ale aŋel gail lupati, riŋi tǝban aApraham len nǝmav. Atenan tokad natite am imat ale lutavuni. ");
INSERT INTO klv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Len nǝhab nǝmatan, len na-lǝŋon-isa-an san tovan vǝsa masuṽ, ekǝta vi mǝhat ale eris aApraham mai aLasarus tǝban. ");
INSERT INTO klv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŋa ikai van hǝni ke, ‘Tata Apraham, gilolosa hǝn ginau ale sǝvat aLasarus hǝn b̃etur nagelhǝŋarhuvǝlan len nǝwai, b̃imosmos hǝn b̃eriŋi len nameagw b̃esusus. Nibegw epǝŋas vǝsa masuṽ len nǝhab egai.’ ");
INSERT INTO klv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Avil aApraham isor vari ke, ‘Anatugw, nau gat natit sam̃ gail tovoi gotokade len nǝmauran sam̃, ale natit gail tosa aLasarus tokade. Be gagai elǝŋon ivoi am len nǝlon ale gaiug golǝŋon isa. ");
INSERT INTO klv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Natgalen imaienan, be ikad natsual am. AGot eriŋ nab̃iltib̃ur tosǝŋav tosareh hǝn b̃epǝpehun ginamito dan gamito, hǝn ke alat lotoke lǝb̃ivan dan naut egai van hǝn gamito, lodǝdasi. Ale alat lotoke lǝb̃egǝm hǝn ginamito dan naut enan lodǝdasi.’ ");
INSERT INTO klv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋa isor vari ke, ‘Beti neus gaiug, Tata, ke golǝboi gǝb̃esǝvati van hǝn nǝbathudud sagw, ");
INSERT INTO klv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","husur nukad aṽagw erim, ale elǝboi b̃ikel nalǝlǝgauan mai galito hǝn ke, salegǝm len naut na-lǝŋon-isa-an egai.’ ");
INSERT INTO klv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Be aApraham ike, ‘Lukad natosian siMoses mai ahai kelkel ur gail. Ivoi ke lesǝsǝloŋ husuri.’ ");
INSERT INTO klv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ike, ‘Aoa Tata Apraham, be avan ideh len naut nǝmatan b̃ivan hǝn galito, dereh lipair dan nǝsaan salito.’ ");
INSERT INTO klv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Beti aApraham ikel maii ke, ‘Asike lǝb̃esǝsǝloŋ husur aMoses mai ahai kelkel ur gail, asike logǝgel hǝn nǝnauan salit hǝn lǝb̃edǝlom avan ideh, naut kǝmas tole mǝhat dan nǝmatan.’” ");
INSERT INTO klv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","AYesu ikel mai ahai susur san gail ke, “Natit lototaltal hǝn nǝvanuan gail hǝn lǝb̃igol b̃isa, lǝb̃iteh dereh legǝmai, avil atenan togol lototeh, dereh nǝmauran san tisa vǝsa batbat. ");
INSERT INTO klv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Atenan, b̃igol avan ideh b̃igol nǝsaan, ivoi am hǝn atenan ke lubaŋis gat nab̃iltivat tom̃orm̃ori len naholoan ale bar hǝni len tas. ");
INSERT INTO klv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mǝtelǝlǝgau hǝn gamito. Aṽam̃ b̃igol nǝsaan, kel maii ke togol nǝsaan, ale b̃ipair dan nǝsaan san, gerub̃ati dani. ");
INSERT INTO klv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","B̃igol nǝsaan van hǝn gaiug vǝha-mǝlevru len nǝmariboŋ tosua, ale b̃etǝlmam van hǝn gaiug vǝha-mǝlevru toke, ‘Nupair dan nǝsaan sagw,’ gerub̃at nǝsaan galen dani.” ");
INSERT INTO klv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ale ahai pispisul gail lukel mai Nasub̃ ke, “Gigol nadǝlomian sinamito tetibau am!” ");
INSERT INTO klv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ŋa Nasub̃ ike, “Mǝttǝkad nadǝlomian tokǝkereh hun namisurhumastat, mǝttalǝboi mǝttakel mai nǝhai malperi egai ke, ‘Gimakuv ale gimabul gaiug len tas,’ ale dereh tǝmaienan. ");
INSERT INTO klv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mǝttǝkad naslev totivtiv nǝtan marireu o tokǝtkǝta tǝban nasipsip, nǝboŋ tovahim dan nǝmarireu, gamit ta be take, ‘Gǝm tutut, gebǝtah, gihan’? ");
INSERT INTO klv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aoa, sǝmaienan. Take, ‘Geutaut hǝn nǝhanian m̃os ginau, sun nahurabat tonor ale lav nǝhanian mai ginau vir nǝhanan mai namunan b̃inoŋ. Ale nǝboŋ gotogole b̃inoŋ golǝboi gǝb̃ihan, gǝb̃emun.’ ");
INSERT INTO klv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Amasta esipa vi tǝban naslev togol nǝsa tokele a? Aoa! ");
INSERT INTO klv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imaienan hǝn gamit am. Nǝboŋ mǝttogol natit p̃isi aGot tokel mai gamit hǝn mǝtb̃igole, mitike, ‘Namtovi naslev kǝmas ŋai; namtugol nǝsa aGot tokele ŋai.’” ");
INSERT INTO klv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Len nǝyaran san, nǝboŋ tovi Jerusalem, aYesu iyar len navilah hǝn naut a Samaria mai a Kalili. ");
INSERT INTO klv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nǝboŋ tobar navile sua, naulum̃an tosǝŋavur lotokad naleprosi lobubur maii. Loil a tut ");
INSERT INTO klv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ale lukai habat ke, “Yesu, Masta, gilolosa hǝn ginamito!” ");
INSERT INTO klv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nǝboŋ toris galito, ikel mai galit ke, “Mitia ṽusan gamit mai ahai tutumav gail.” Ale len nǝyaran salit van, lumaur, luveveu. ");
INSERT INTO klv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Galit sua, nǝboŋ toris ke tomaur, etǝlmam van, eputsan nahǝsan aGot habat. ");
INSERT INTO klv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ale iteh len tan, ekǝta vi pan bathurien aYesu ale esipa vi tǝban. Be gai evi auleSamaria. ");
INSERT INTO klv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Beti aYesu ike, “Be savi tosǝŋavur lotoveveu a? Lotomǝlapat, galit lutoh a be? ");
INSERT INTO klv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sǝkad avan ideh hǝn totǝlmam hǝn toputsan nahǝsan aGot, be ametb̃os egai ŋai a?” ");
INSERT INTO klv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Beti ikel maii ke, “Gile mǝhat, givan; nadǝlomian sam̃ igol gumaur.” ");
INSERT INTO klv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Boŋ sua naFarisi gail lous aYesu ke, “Natohan pipihabǝlan aGot tegǝm ŋais?” AYesu isor var galit ke, “Natohan pipihabǝlan aGot sagǝm len nakǝtaan. ");
INSERT INTO klv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Avan ideh asike ike, ‘Geris, ipat gegai!’ o ‘Ipat ea!’ husur natohan pipihabǝlan aGot satopat mai gamito.” ");
INSERT INTO klv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Beti ikel mai ahai susur san gail ke, “Len nǝboŋ b̃egǝmai, dereh mǝtelǝŋon ke mǝteris nǝmariboŋ ideh siNatun Nǝvanuan, avil asike mǝtorisi. ");
INSERT INTO klv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nǝvanuan gail dereh likel mai gamit ke, ‘Geris, gai sage!’ o ‘Geris, gai saga!’ Samtedǝlom galito, samtehusur galito. ");
INSERT INTO klv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Husur aNatun Nǝvanuan, len nǝboŋ san, tesum̃an nasǝm̃oropun tom̃ias nǝmav kavkav. ");
INSERT INTO klv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Be a tahw hǝn natgalen b̃evisi, timaslǝŋon tisa hǝn natit b̃isob̃ur ale naur ta damǝŋai limasmǝtahuni. ");
INSERT INTO klv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Naṽide lǝb̃ikade len nǝboŋ gail siNatun Nǝvanuan dereh lehun naṽide silat lototoh len nǝboŋ siNoah gail. ");
INSERT INTO klv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nǝvanuan gail luhan, lomun, lulah mai ludam̃ hǝn nǝlahan gail van vǝbar nǝboŋ aNoah tob̃is len nab̃iltib̃ot totibau masuṽ lotokisi hǝn nǝak. Beti nab̃iltius eus, nilev egǝm van, natit p̃isi imasig. ");
INSERT INTO klv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Imagenan len nǝboŋ gail siLot. Luhan, lomun, loṽur natite, lop̃ur hǝn natite. Lumabul tite mai loum hǝn naim gail. ");
INSERT INTO klv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Be len nǝboŋ aLot toriŋ naut a Sotom, nǝhab mai nǝsalfa aruteh dan nǝmav van, navile kavkav imasig. ");
INSERT INTO klv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Timaienan len nǝboŋ aNatun Nǝvanuan b̃evisi len nǝdaŋan san.” ");
INSERT INTO klv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","AYesu isor am ke, “Len nǝboŋ enan, avan ideh b̃itoh a mǝhat len navurun naim timasgam tutut dan naim san, satimariŋ hǝn b̃itariv natit san gail. Ale avan ideh len nǝmarireu tu satetǝlmam vahim hǝn b̃ipat natideh. ");
INSERT INTO klv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mitinau gat asoan aLot. ");
INSERT INTO klv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Avan ideh b̃igol risi ke b̃etǝgau gat nǝmauran san, dereh timasig. Be avan ideh b̃idam̃ hǝni ke b̃imasig, dereh aGot tigol timaur vi sutuai. ");
INSERT INTO klv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nukel mai gamit ke, len nalenmariug enan dereh nǝvanuan eru aripat len nǝmel b̃esua; aGot tilav kuv tesua ale togon tipat. ");
INSERT INTO klv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Napǝhaṽut eru arelis dasdas namisurhuwit len naut tesua ŋai; aGot tilav kuv tesua ale togon titoh.” ");
INSERT INTO klv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Beti ahai susur gail lousi ke, “Dereh tevisi a be, Nasub̃?” Isor var galit, isor kǝta ke, “Len naut ideh natit tomat topat lan, nab̃iltiman tohanhan natit tomat dereh lemǝlah gǝm b̃on ei. Avan tokad namǝtan elǝboi b̃erisi.” ");
INSERT INTO klv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Beti aYesu ib̃ol mai galit ke limassor tuṽ tabtab, nǝlolit sateur na-sor-tuṽ-an, letǝgau gati. ");
INSERT INTO klv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ike, “Len nab̃iltivile sua ikad nǝmatsistret samǝtahw len aGot, tonau ke nǝvanuan gail lotovi ut kǝmas. ");
INSERT INTO klv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ale len nab̃iltivile enan ikad abatunau pǝhaṽut togǝm akis hǝni hǝn b̃eŋiri ke, ‘Gigol tinor hǝn ginau hǝn asike aenemi sagw b̃emǝdas ginau am.’ ");
INSERT INTO klv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Idareh, nǝmatsistret emǝtahuni van vǝbar toke, ‘Nǝsamǝtahw len aGot, ale nǝvanuan gail lovi ut kǝmas hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Be husur ke nǝbatunau enan toŋir batriŋriŋ hǝn ginau, nupetǝmas hǝni! Dereh nigol tinor hǝni hǝn asike b̃eŋir akis hǝn ginau van nimat.’” ");
INSERT INTO klv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Beti Nasub̃ ike, “Mǝtesǝsǝloŋ hǝn nǝsa nǝmatsistret tosa tokele! ");
INSERT INTO klv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","AGot dereh tigol tinor hǝn galit totabtabuh len galito, lotokai van hǝni len nalennǝyal mai nalenmariug a? Dereh tevǝlo hǝn b̃evi tarhǝt salito a? ");
INSERT INTO klv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ao, nukel mai gamit ke dereh tigol nanoran hǝn galit tutut. Avil nǝboŋ aNatun Nǝvanuan b̃egǝmai, dereh tisab̃ nadǝlomian len navile a pan o teb̃uer?” ");
INSERT INTO klv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","AYesu ikel nǝb̃ol p̃usan egai mai galevis lotonau ke lotonor be lunau ke nǝvanuan tile gail lǝsavi natideh. Isor kǝta ke, ");
INSERT INTO klv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Naulum̃an eru arovi mǝhat vi lan naholǝvat todar vis naim siGot hǝn arb̃isor tuṽ. Gǝlar togon evi Farisi, togon evi vanuan nǝtaks. ");
INSERT INTO klv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","NaFarisi eil, isor tuṽ van hǝn gai gabag ke, ‘Got, nosipa len gaiug husur ke ginau nǝsasum̃an alat galenan, nǝvanuan gail lotogǝgǝras hǝn lǝb̃ilav kuv nǝvat, alat lǝsanor, alat lotogol naitian tob̃ur kotov nǝlahan, o sum̃an ategai am tovi nǝvanuan nǝtaks. ");
INSERT INTO klv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nǝsǝhan vǝha-ru len nawik p̃isi, noviol hǝn nahudhut tosua dan tosǝŋavur notokade.’ ");
INSERT INTO klv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Avil togon tosor tuṽ, eil a tut, salǝŋon ke tekǝta vi mǝhat vi lan nǝmav be len na-lǝŋon-isa-an san isar batut, ike, ‘Got, gilolosa hǝn ginau, rub̃at nǝsaan dan ginau notovi vanuan nǝsaan!’ ");
INSERT INTO klv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nukel mai gamit ke, atenan ivahim, nǝsaan san imarub̃at. Len nǝhon aGot, atenan inor, savi naFarisi. Bathut avan ideh b̃ipatpat gai mǝhat, dereh tegǝm vi ut kǝmas be ideh togol gai gabag tovi ut kǝmas, aGot dereh teputsani.” ");
INSERT INTO klv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nǝvanuan gail losǝhar anatulit gail am van hǝn aYesu, hǝn b̃eriŋ navǝlan len galito hǝn navoian b̃egǝm hǝn galito. Nǝboŋ ahai susur gail lotorisi, losivoh len galito. ");
INSERT INTO klv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Be aYesu ekis galit gǝmai, ike, “Mitidam̃ hǝn natuhtǝtai gail legǝm hǝn ginau, samtikai tas galito, husur natohan pipihabǝlan aGot evi silat lotosum̃an galito. ");
INSERT INTO klv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nukel nakitinan mai gamit ke, avan ideh asike b̃ehǝhaṽur hǝn natohan pipihabǝlan aGot hum natuhtǝtai, asike asike eb̃is lan.” ");
INSERT INTO klv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Naulum̃an sua toil a m̃o eus aYesu ke, “Hai p̃usan gotovoi, nimabe hǝn nǝb̃ikad nǝmauran vi sutuai?” ");
INSERT INTO klv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ale aYesu isor vari ke, “Imabe gotokis ginau ke notovoi? Sǝkad avan ideh tovoi—aGot sǝb̃on ŋai. ");
INSERT INTO klv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gaiug golǝboi nakelean todaŋ gail lotoke: ‘Sagigol naitian tob̃ur kotov nǝlahan, sagigol avan ideh timat, sagevǝnah, sagelibliboŋ—len nakotan am sageliboŋ, putsan atǝmam̃ mai anam̃ len nǝnauan sam̃.’” ");
INSERT INTO klv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Atenan ike, “Nǝboŋ notovi tuhtǝtai vǝbar damǝŋai nugol natgalenan p̃isi.” ");
INSERT INTO klv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nǝboŋ aYesu tosǝsǝloŋ hǝni, ikel maii ke, “Natesual am gupar. P̃ur hǝn natit p̃isi gotokade ale pǝpehuni mai namǝsal gail. Ale dereh gikad nakonviolan aGot totǝgau gati m̃os gaiug len nǝmav. Beti gegǝm husur ginau.” ");
INSERT INTO klv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Avil nǝboŋ atenan tosǝsǝloŋ hǝn natgalenan, nǝlon isa husur ke topul hǝn natit tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nǝboŋ aYesu tokǝta van hǝni ike, “Idaŋ masuṽ hǝn alat lotopul hǝn natite lǝb̃evi lan natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mǝtolǝboii ke idaŋ habat hǝn nǝkamel b̃eb̃is tur len nab̃urhunil sǝsod. Idaŋ sǝhori am hǝn nǝvanuan topul hǝn natite b̃eb̃is len natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Be alat lotosǝsǝloŋ hǝn natenan lousi ke, “B̃imaienan, ase teb̃is lan? Sǝkad avan ideh b̃ikad nǝmauran vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ale aYesu ike, “Natideh nǝvanuan todǝdas b̃igole, aGot elǝboi b̃igole.” ");
INSERT INTO klv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ale aPita ike, “Geris, ginamit namtoriŋ sinamit p̃isi tia hǝn namttohusur gaiug.” ");
INSERT INTO klv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ale aYesu ikel mai galit ke, “Nusor kitin mai gamit ke, avan ideh toriŋ naim o asoan o aṽan gail o tata mai nana o anatun gail m̃os natohan pipihabǝlan aGot, ");
INSERT INTO klv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dereh tikad natgalen p̃isi tisob̃ur tǝtas am len nǝboŋ eg ta damǝŋai len navile a pan. Ale len nǝboŋ b̃egǝmai len nǝmav dereh tikad nǝmauran vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","AYesu esǝhar tosǝŋavur pisan toru san lutoh sǝb̃olito, ale ikel mai galit ke, “Datovi mǝhat vi Jerusalem, ale natit p̃isi ahai kelkel ur lototosi husur aNatun Nǝvanuan, dereh lisarpoh. ");
INSERT INTO klv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Alatevis a Jerusalem leriŋi len navǝlan alat lǝsavi Ju. Dereh lisor vilesi, lisor mǝdasi, leṽulaii, ");
INSERT INTO klv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","lebilas habat hǝni ale ligol timat. Be len nǝmariboŋ titor dereh tile mǝhat tǝtas.” ");
INSERT INTO klv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ahai susur gail lǝsalǝboi natideh lan. Namilen esusuah dan galito gol ke lǝsalǝboi nǝsa aYesu tosor husuri. ");
INSERT INTO klv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nǝboŋ aYesu tovan pǝpadaŋ hǝn naut a Jeriko, ametb̃esw sua ebǝtah gǝgarhǝp̃isal, eŋir nǝvanuan gail hǝn nǝvat. ");
INSERT INTO klv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nǝboŋ tosǝsǝloŋ hǝn naluṽoh toṽot eus ke nǝsa tovisi enan. ");
INSERT INTO klv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Galit lukel maii ke, “AYesu ta Nasaret satoyar van.” ");
INSERT INTO klv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ale ikai ke, “Yesu, aNatun siTevit, nǝlom̃ titaŋis ginau, gol tivoi hǝn ginau!” ");
INSERT INTO klv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ale alat lotoyar a m̃o losivoh lan hǝn b̃emǝdau, ris tokai habat am ke, “ANatun siTevit, nǝlom̃ titaŋis ginau, gol tivoi hǝn ginau!” ");
INSERT INTO klv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ŋa aYesu eil, ale ikel ke lesǝhar atenan gǝm hǝni. Nǝboŋ togǝm pǝpadaŋ aYesu eusi ke, ");
INSERT INTO klv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Guke nigol nǝsa hǝn gaiug?” Ale ike, “Nasub̃, nuke nekǝta.” ");
INSERT INTO klv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ale aYesu isor maii ke, “Gekǝta! Nadǝlomian sam̃ igol gumaur.” ");
INSERT INTO klv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Vǝha-sua ŋai ikad nakǝtaan ale ehusur aYesu, isal suh nǝyalyalan siGot. Nǝboŋ nǝvanuan p̃isi lotorisi, galit am loputsan nahǝsan aGot. ");
INSERT INTO klv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Beti aYesu eb̃is len naut a Jeriko ale iyar tur lan. ");
INSERT INTO klv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ikad aulum̃an sual ei nahǝsan aSakias; gai eil a m̃o hǝn nǝvanuan nǝtaks gail ale epul hǝn nǝvat mai natite. ");
INSERT INTO klv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ike terisi ke aYesu ase, be husur top̃itol edǝdasi bathut ke naluṽoh lotoil kǝkol hǝn gai. ");
INSERT INTO klv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ŋa igam vi m̃o ale epǝlau len nǝhai sikam̃or hǝn b̃eris aYesu, husur ke dereh tiyar van ei. ");
INSERT INTO klv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ale nǝboŋ aYesu tobar naut enan, ekǝta vi mǝhat ale ikel maii ke, “Sakias, gimariŋ tutut. Damǝŋai nimastoh len naim sam̃.” ");
INSERT INTO klv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ŋa imariŋ vi pan tutut ale ike “Ivoi,” mai aYesu, ikemkem habat. ");
INSERT INTO klv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nǝvanuan p̃isi lotoris natenan loŋit nǝholito, lusor mǝtmǝtan hǝni ke, “Gai evi lohoim sinaulum̃an nǝsaan hǝn b̃itoh maii.” ");
INSERT INTO klv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Avil aSakias ile mǝhat, ikel mai aYesu ke, “Geris, Nasub̃, len nahudhut toru hǝn natit p̃isi sagw, gagai ŋai nulav nahudhut tesua mai namǝsal gail. Ale nǝb̃egǝras avan ideh hǝn nǝb̃evǝnah, dereh nisar gel vǝha-vat hǝni!” ");
INSERT INTO klv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Beti aYesu ikel maii ke, “Damǝŋai nǝ-lav-kuvi-an dan nǝsaan egǝm bar naim egai. Bathut ategai am evi sua len nǝpasusan siApraham. ");
INSERT INTO klv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Husur aNatun Nǝvanuan egǝm hǝn b̃idoŋ alat lotomasig, hǝn b̃ilav kuv galit dan nǝsaan.” ");
INSERT INTO klv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nǝboŋ nǝvanuan gail lotosǝsǝloŋ hǝn natgalenan, aYesu ib̃ol p̃usan, husur egǝm pǝpadaŋ hǝn naut a Jerusalem ale lunau ke natohan pipihabǝlan aGot b̃evisi ta bogai. ");
INSERT INTO klv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Imagenan aYesu ike, “Aulum̃an sua len nǝbathudud toil a m̃o len nǝkantri san eutaut hǝn b̃evi lan nǝkantri sual a tut hǝn ab̃iltikiŋ ei b̃itabtabuh lan hǝn b̃etǝlmam b̃egǝm vi kiŋ hǝn naut san. ");
INSERT INTO klv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ale ekis naslev lotovi ulum̃an tosǝŋavur gǝmai, ilav namina tosǝŋavur mai galit ṽisusua, ike, ‘Mǝteum len nǝvat galenan vir natǝlmaman sagw.’ ");
INSERT INTO klv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Be alat len nǝkantri san lomǝtahun buni ale losul galit galevis a tahw hǝni hǝn lǝb̃ikel mai nab̃iltikiŋ ke, ‘Namtsalǝŋon ategai hǝn b̃evi kiŋ sinamito.’ ");
INSERT INTO klv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Naut kǝmas, egǝm vi kiŋ ale nǝboŋ totǝlmam episul hǝn alatenan gai tolav nǝvat mai galit ke legǝmai. Ike telǝboi nǝvat lotosǝhori len nǝvat tolav mai galito. ");
INSERT INTO klv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Esua toil a m̃o egǝm ike, ‘Nasub̃, namina sam̃ episan esǝŋavur am.’ ");
INSERT INTO klv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ale ikel maii ke, ‘Nauman sam̃ ikab, govi naslev tovoi! Husur ke gotodaŋ len natenan tokǝkereh, dereh gekǝtkǝta tǝban nab̃iltivile tesǝŋavur.’ ");
INSERT INTO klv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Beti sual am egǝm ale ike, ‘Nasub̃ namina sam̃ episan erim am.’ ");
INSERT INTO klv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ŋa nakiŋ ikel maii ke, ‘Gaiug, dereh gekǝtkǝta tǝban nab̃iltivile terim.’ ");
INSERT INTO klv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Beti naslev tile am egǝm ale ike, ‘Nasub̃, namina sam̃ bogai; noruŋ gole len natuhtaol hǝn nǝb̃esusuan buni. ");
INSERT INTO klv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nomǝtahw len gaiug husur gutaltal, nǝkadum̃ ehǝhaiv, gulav kuv nǝsa gǝsariŋi, gotǝtariv nǝsa gǝsǝmabule.’ ");
INSERT INTO klv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nakiŋ isor vari ke, ‘Govi naslev tosa vǝsa! Len nasoruan sam̃ gotomadhakele, neṽusan gaiug hǝn nǝsaban sam̃. Gaiug gukele ke nudaŋ taltal, nǝkadugw ehǝhaiv, nulav kuv nǝsa nǝsariŋi mai notǝtariv nǝsa nǝsǝmabule. ");
INSERT INTO klv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","B̃imaienan, husur nǝsa gǝsariŋ nǝvat sagw len nalulutar hǝn ke nǝboŋ nototǝlmam nǝtǝlav nǝvat enan mai naintǝres han?’ ");
INSERT INTO klv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ale ikel mai alat lotoil tǝban ke, ‘Lav kuv namina dani ale lavi mai atenan tokad namina tosǝŋavur.’ ");
INSERT INTO klv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ris lotoke, ‘Nasub̃, gai ikad namina tosǝŋavur tia!’ ");
INSERT INTO klv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Isor var galit ke, ‘Nukel mai gamit ke, nǝvanuan p̃isi lotoum tovoi len nǝsa lotokade, dereh nilav natit am mai galito, avil avan ideh tom̃idol, avan ideh saum savoi len nǝsa tokade, dereh nilav kuv tokǝkereh gai tokade dani. ");
INSERT INTO klv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Be galen p̃isi lotovi enemi sagw gail, lotomǝtahun ginau notovi kiŋ salito, sǝhar galit gǝmai, ta bubun galit len nǝhogw!’” ");
INSERT INTO klv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nǝboŋ aYesu tokǝmaienan tonoŋ, iyar tab vi mǝhat vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nǝboŋ tovan pǝpadaŋ hǝn natuhvile eru, a Petfas mai a Petani, len naut lotokisi hǝn Naṽehuh Oliv, esǝvat ahai susur eru, ");
INSERT INTO klv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ike, “Mǝrevi lan navile ea topat a m̃o. Nǝboŋ mǝrb̃eb̃is lan dereh mirisab̃ natuhtoŋki totahǝtah ei, avan ideh sǝsah lan sal. Sah rub̃ati ale sǝhari gǝmai. ");
INSERT INTO klv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Avan ideh b̃eus gamǝr ke, ‘Mǝrorub̃ati hǝn nǝsa?’ mirikele ŋai ke, ‘Nasub̃ timaskade.’” ");
INSERT INTO klv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nǝboŋ aYesu tosǝvat gǝlar tonoŋ, aruvan ale arusab̃ natit p̃isi hun aYesu tokele. ");
INSERT INTO klv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nǝboŋ artosah rub̃at natuhtoŋki enan, amahean gail lous gǝlar ke, “Mǝrorub̃ati hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ale arusor var galit ke, “Nasub̃ timaskade.” ");
INSERT INTO klv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Beti arosǝhari van hǝn aYesu, arob̃ir hǝn nahurabat sǝlaru len natuhtoŋki ale arugol aYesu ebǝtah sǝŋaṽuti. ");
INSERT INTO klv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Len nǝvanan san, luṽolsan nahurabat salit gail metp̃isal. ");
INSERT INTO klv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nǝboŋ togǝm pǝpadaŋ hǝn naut nap̃isal tovi pan len Naṽehuh Oliv, naluṽoh hǝn ahai susur gail kavkav, len nahǝhaṽuran salito, lotub̃at kai, putsan nahǝsan aGot habat husur namerikel p̃isi lotorisi tia. ");
INSERT INTO klv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Lukai ke, “Got igol ivoi hǝn atenan, nakiŋ togǝm len nahǝsan Nasub̃ aGot! Natǝm̃at len nǝmav mai nalotuan tivan hǝn aGot toyalyal buni!” ");
INSERT INTO klv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Be naFarisi galevis len naluṽoh lusor mai aYesu ke, “Hai p̃usan, kai tas ahai susur sam̃ gail!” ");
INSERT INTO klv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ris aYesu tosor var galit ke, “Nukel mai gamito, naut tab̃ut hǝn galito, nǝvat galegai lǝtǝkai.” ");
INSERT INTO klv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nǝboŋ togǝm pǝpadaŋ hǝn naut a Jerusalem, toris nab̃iltivile enan, itaŋisi ");
INSERT INTO klv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ale ike, “Ivoi am ke gamit mǝttalǝboi nǝsa tǝlav natǝm̃at mai gamito nǝboŋ damǝŋai, be aoa, esusuah dan gamito. ");
INSERT INTO klv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nǝboŋ tosa dereh tegǝm hǝn gamito. Len nǝboŋ enan aenemi samit gail dereh lisah tuan nǝtan tisahsah vi mǝhat hǝn b̃ipat kǝkol hǝn nab̃iltivile samito, lidar vis gamito hǝn lǝb̃eil garu gol gamito. ");
INSERT INTO klv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ale ligol nab̃iltivile timasirsir, gamit mai anatumit mitimaienan. Ligol ke asike ikad nǝvat ideh b̃epǝlah gat togon. Dereh timagenan husur mǝtsaris lǝboi nǝboŋ aGot togǝm hǝn gamito.” ");
INSERT INTO klv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Beti aYesu eb̃is len naholǝvat todar vis naim siGot ale etub̃at hut alat lotop̃ur hǝn natit gail ei. ");
INSERT INTO klv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ikel mai galit ke, “Natosian siGot ike, ‘Naim sagw tevi naim na-sor-tuṽ-an,’ avil mǝtugol ke egǝm ‘naut susuah sinǝvanuan vǝnvǝnah gail!’” ");
INSERT INTO klv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","AYesu ep̃usan len nǝboŋ p̃isi len naholǝvat todar vis naim siGot. Ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo mai alat lotoil a m̃o hǝn nǝvanuan gail am, lohisi hǝn lǝb̃igol b̃imat. ");
INSERT INTO klv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Be lǝsǝsab̃ nap̃isal hǝn lǝb̃igole, bathut nǝvanuan p̃isi lolǝŋon buni ke lesǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Len nǝboŋ sua, nǝboŋ aYesu toṽusan nǝvanuan gail len naholǝvat todar vis naim siGot, mai tokel ur na-kel-uri-an tovoi, ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo mai alat lotoil a m̃o hǝn nǝvanuan gail, logǝm hǝni. ");
INSERT INTO klv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lukel maii ke, “Gugol natgalenan len nǝdaŋan sise? Ase ilav nǝdaŋan hǝn na-il-a-m̃o-an egai mai gaiug?” ");
INSERT INTO klv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isor var galit ke, “Neus gamit hǝn nausian sua bai. Kel mai ginau, ");
INSERT INTO klv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nǝbaptaisan siJon, egǝm len aGot len nǝmav o len nǝvanuan?” ");
INSERT INTO klv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lusor vahvah mai galit gabag ke, “Datb̃ike, ‘Egǝm len aGot,’ dereh teus, ‘Husur nǝsa mǝtsadǝlomi?’ ");
INSERT INTO klv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Be datb̃ike, ‘Nǝvanuan,’ dereh nǝvanuan p̃isi letubun gidato, husur lodǝlomi ke aJon tovi ahai kelkel ur.” ");
INSERT INTO klv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ŋa lusor vari ke, “Namtsalǝboi as tolav mai aJon.” ");
INSERT INTO klv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ale aYesu ike, “Ginau am, asike nukel mai gamito ke na-il-a-m̃o-an sise topat len ginau hǝn nǝb̃igol natgalenan.” ");
INSERT INTO klv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Beti etub̃at kel nǝb̃ol p̃usan egai mai nǝvanuan gail, ke: “Avan sua imabul nǝhol nakrep ale idam̃ hǝni van hǝn alat lotokǝtkǝta tǝban nǝhol hǝn lǝb̃irentem, ale len nǝyaran san gai ivan ebǝlav. ");
INSERT INTO klv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Len nǝboŋ nakrep tomen, esǝvat naslev sua van hǝn alat lotorentem nǝhol hǝn lǝb̃epǝpehun nakrep galevis tovi esan. Avil luṽasi, losǝvati van, sǝlav natideh. ");
INSERT INTO klv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ŋa amahean nǝhol esǝvat naslev sual am, be gai am lugol maien hǝni, luṽasi, lugol isa hǝni, ale losǝvati van, sǝlav natideh. ");
INSERT INTO klv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ŋa esǝvat sual am tǝtas ale luṽab̃ub̃uri, lubar hǝni vivile. ");
INSERT INTO klv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Amahean ike, ‘Nigol nǝsa? Nigol timaiegai ke: dereh nesǝvat anatugw ulum̃an notolǝmas buni hǝn ke hum ma nahurulit b̃isa, ale lǝb̃igol b̃inor hǝni.’ ");
INSERT INTO klv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Be nǝboŋ alatenan lotorisi, lusor utaut hǝni ke, ‘Atenan, nǝboŋ atǝman b̃imat, gai tikad nǝhol balai; datiparu buni hǝn datb̃ikad nasugsugur san p̃isi!’ ");
INSERT INTO klv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ŋa lubar hǝni dan nǝhol nakrep ale luparu buni.” AYesu isor am ke, “Amahean nǝhol dereh tigol nǝsa hǝn galito? ");
INSERT INTO klv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dereh tegǝmai, tigol alat lotorentem nǝhol limat, ale tilav nǝhol nakrep enan mai ideh tile.” Nǝboŋ nǝvanuan gail lotosǝsǝloŋ hǝn natenan, luke, “Natenan satimaienan!” ");
INSERT INTO klv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Be aYesu ekǝta inor van hǝn galito ale ike, “B̃imaienan, namilen natosian egai topat len nǝb̃e sua ta sutuai nǝsa? “‘Nǝvat, nǝvanuan na-um-im-an gail lotomǝtahuni, gai egǝm vi vat sua ŋai b̃elǝboi b̃igol naim b̃ihav mai b̃inor.’ ");
INSERT INTO klv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nǝvanuan p̃isi lǝb̃iteh len nǝvat enan, dereh limab̃urb̃ur, mai avan ideh, nǝvat b̃iteh lan, dereh tipat dole.” ");
INSERT INTO klv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Beti ahai p̃usan gail hǝn nalo mai ab̃iltihai tutumav gail ludas p̃isal hǝn lǝb̃itah gat aYesu len namityal enan ŋai bathut lolǝboii ke len nǝb̃ol p̃usan enan isor tas galito. Avil lomǝtahw len nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Beti lokǝta bunusi ale losǝvat nǝvanuan galevis lotogǝrasi ke lotokitin hǝn lǝb̃isab̃ nǝsaban len nasoran san hǝn lǝb̃eriŋi len navǝlan mai nǝdaŋan seuleRom tovi gavna. ");
INSERT INTO klv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Imagenan nǝvanuan nagǝgǝrasan gail lousi ke, “Hai p̃usan, namtolǝboii ke gaiug gotosor, gotop̃usan tonor. Naṽide sam̃ ep̃itoṽ van hǝn nǝvanuan p̃isi, ideh satile, ale gop̃usan hǝn nap̃isal siGot len nakitinan. ");
INSERT INTO klv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Inor hǝn datb̃eṽur nǝtaks van hǝn aSisa m̃au a?” ");
INSERT INTO klv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Avil aYesu ekǝta lǝboi na-sor-gǝrasi-an salito ale ikel mai galit ke, ");
INSERT INTO klv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ṽusan ginau hǝn natenarius tesua. Nǝhon mai nahǝsan ase arupat lan?” Ale luke, “ASisa.” ");
INSERT INTO klv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ikel mai galit ke, “Imagenan, lav mai aSisa nǝsa tovi seSisa, ale lav mai aGot nǝsa tovi siGot.” ");
INSERT INTO klv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ale lodǝdas lǝb̃isab̃ nǝsaban ideh len nasoran san ei len nǝhon nǝvanuan gail. Lup̃aŋ len na-sor-vari-an san, ale lǝsasor am. ");
INSERT INTO klv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","NaSattiusi galevis (lotoke na-le-mǝhat-an dan nǝmatan eb̃uer), logǝm hǝn aYesu. Lousi ");
INSERT INTO klv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ke, “Hai p̃usan, aMoses itos m̃os gidato ke, aulum̃an ideh, aṽan b̃imat be asoan b̃itoh mai anatun b̃eb̃uer, atenan timaslah mai nǝbatunau hǝn b̃ikad anatun gail m̃os aṽan. ");
INSERT INTO klv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ale boŋ sua ikad alatmiṽan lotomǝlevru. Ahai a m̃o ilah mai apǝhaṽut sua, be imat, anatun eb̃uer. ");
INSERT INTO klv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aṽan tohusur ahai a m̃o ilah mai nǝbatunau, ");
INSERT INTO klv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","beti aṽan tohusuri am imaienan. Alatmiṽan lotomǝlevru lumat maienan p̃isi, anatulit eb̃uer. ");
INSERT INTO klv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Namǝkot alitenan tu imat. ");
INSERT INTO klv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ale namtous gaiug ke, b̃imagenan, len na-le-mǝhat-an dan nǝmatan, napǝhaṽut enan dereh tevi asoan ase? Husur ke alatmiṽan lotomǝlevru p̃isi lulah maii.” ");
INSERT INTO klv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ŋa aYesu ikel mai galit ke, “Nǝvanuan len navile a pan lulah mai ludam̃ hǝn nǝlahan. ");
INSERT INTO klv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Avil alat aGot totabtabuh len galit hǝn lǝb̃itoh vi sutuai, mai hǝn lǝb̃itoh len na-le-mǝhat-an dan nǝmatan, galit, asike lulah, avan ideh asike idam̃ hǝn lǝb̃ilah. ");
INSERT INTO klv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ale lodǝdas lǝb̃imat am, husur losum̃an aŋel gail, lovi anatun aGot gail bathut togol lotole mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Be len nǝb̃olan husur nǝhai topaŋ, aMoses boh isor vǝhoti ke, alat lotomat lule mǝhat dan nǝmatan husur ekis Nasub̃ hǝn ‘aGot siApraham mai aGot seIsak mai aGot siJakop.’ ");
INSERT INTO klv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gai savi aGot silat lotomat be evi aGot silat lotomaur, husur len nabunusian siGot, galit p̃isi lumaur.” ");
INSERT INTO klv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ahai p̃usan galevis hǝn nalo lusor vari ke, “Gokitin ahai p̃usan!” ");
INSERT INTO klv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Beti avan ideh sail b̃uri hǝn b̃eusi hǝn nausian ideh am. ");
INSERT INTO klv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Be aYesu eus galit ke, “Nǝvanuan gail luke aKristo, aGot totabtabuh lan, evi anatun ulum̃an siTevit mabe? ");
INSERT INTO klv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Husur aTevit, gai ikele len nalob̃ulat hǝn Nǝb̃e gail ke: “‘Nasub̃ aGot ikel mai aMasta sagw ke, “Gebǝtah tarhǝt len nǝmatu sagw, ");
INSERT INTO klv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","vir nǝb̃eriŋ aenemi sam̃ gail pipit nariem̃ gǝlaru hǝn lǝb̃evi ut kǝmas.”’ ");
INSERT INTO klv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Imaienan aTevit b̃ekisi hǝn ‘aMasta,’ evi anatun mabe?” ");
INSERT INTO klv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nǝboŋ nǝvanuan p̃isi lotosǝsǝloŋ, aYesu ikel mai ahai susur san gail ke, ");
INSERT INTO klv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mǝtelǝlǝgau hǝn ahai p̃usan gail hǝn nalo. Lolǝmas hǝn lǝb̃iyaryar mai nahurabat tobǝlbǝlav lotosuni. Lolǝmas hǝn nǝvanuan gail lǝb̃ike, ‘Ivoi,’ mai galit len nǝmaket, lolǝmas nǝhai bǝtbǝtah tovoi ŋai len naim nab̃onb̃onan, mai lolǝmas hǝn lǝb̃ebǝtah rivuh len nǝhanan gail. ");
INSERT INTO klv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lulav kuv p̃is naim mai nasugsugur sibatunau pǝhaṽut gail, be len nagǝgǝrasan salito len nǝhon nǝvanuan gail, lusor tuṽ ebǝbǝlav. Alatenan dereh lipanis sǝhor alat lǝsǝmaienan.” ");
INSERT INTO klv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nǝboŋ aYesu tokǝmaienan tonoŋ, eris alat lotokad natite nǝboŋ lotoriŋ naviolan salito len nabokis hǝn nǝvat len naim siGot. ");
INSERT INTO klv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Beti eris nǝbatunau namǝsal sua toriŋ natuhkoin eru artovi kopa. ");
INSERT INTO klv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ike, “Nukel nakitinan mai gamit ke, nǝbatunau egai tovi mǝsal eviol sǝhor galit p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Husur galit p̃isi loviol kinit naviolan gail dan tosob̃ur lotopul hǝni, be dan tokǝkereh topar, alitegai eviol hǝn natit p̃isi san hǝn b̃imaur lan.” ");
INSERT INTO klv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nǝboŋ ahai susur san galevis lotosor husur naim siGot ke epǝhas buni hǝn nǝvat tobilbil mai naviolan gail van hǝn aGot, aYesu ike, ");
INSERT INTO klv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Natgalen mǝttorisi, dereh len nǝboŋ gail lǝb̃egǝmai, asike ikad nǝvat ideh b̃epǝlah gat togon, dereh limasirsir p̃isi.” ");
INSERT INTO klv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ŋa lousi ke, “Hai p̃usan, natgalenan levisi ŋais? Ale dereh tikad nǝsa b̃eṽusan nǝboŋ hǝn natgalenan lǝb̃isarpoh?” ");
INSERT INTO klv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isor var galit ke, “Mǝtelǝlǝgau ke avan ideh sategǝras gamito hǝn mǝtb̃isab, husur dereh tisob̃ur legǝm len nahǝsagw like, ‘Ginau boh aKristo!’ mai, ‘Pǝpadaŋ nǝboŋ tegǝmai!’ Samtehusur galito! ");
INSERT INTO klv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nǝboŋ mǝtb̃esǝsǝloŋ hǝni ke, ikad nab̃iltib̃alan gail mai nǝb̃alan tomǝtahun alat lotoil a m̃o, samtemǝtahw. Husur natgalenan limasvisi a m̃o, be nǝboŋ lǝb̃imadhavisi, savi nagilen sal.” ");
INSERT INTO klv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Beti ikel mai galit ke, “Naluṽoh hǝn nǝvanuan naut sua dereh tib̃al mai naluṽoh hǝn nǝvanuan naut tile, ale nǝvanuan sekiŋ gail dereh lib̃al mai nǝvanuan sekiŋ tile gail. ");
INSERT INTO klv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Len naut tile gail dereh tikad nab̃iltidu gail, tipar hanian mai tikad navilesir gail. Dereh tikad natit b̃evisi, nǝvanuan p̃isi ninelit b̃epil lan, mai natetǝtan toyalyal len nǝmav. ");
INSERT INTO klv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Avil a tahw hǝn natgalenan, galit dereh litah gat gamito, ale lemǝdas bun gamito. Dereh lilav gamit vi lan naim nab̃onb̃onan mai naim nǝbaŋisian gail. Dereh lesǝhar gamit vi lan nakiŋ mai gavna gail sil nahǝsagw. ");
INSERT INTO klv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Len nǝboŋ enan dereh tipat len gamito hǝn mǝtb̃ikel kot na-kel-uri-an tovoi husur ginau. ");
INSERT INTO klv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Imaienan, mitinau sǝhoti ke samteutaut hǝn mǝtb̃isor gol gamit gabag. ");
INSERT INTO klv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bathut dereh neviol mai gamito hǝn nasoran mai namitisau hǝn nǝnauan tokitin hǝn ke, aenemi samit gail ledǝdas lǝb̃isor var gamito o lǝb̃isor tas gamito. ");
INSERT INTO klv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Atǝmamit, anamit, aṽamit gail, amaheamit gail mai nabubur samit gail am dereh leriŋ gamit len navǝlan aenemi samit gail. Dereh leriŋ gamit galevis len nǝmatan. ");
INSERT INTO klv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nǝvanuan p̃isi dereh lemǝtahun bun gamito sil nahǝsagw. ");
INSERT INTO klv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Be nasivurumito dan navurumito asike imasig. ");
INSERT INTO klv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Len nǝ-daŋ-b̃uri-an samito dereh mitikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Be nǝboŋ mǝtb̃eris naut a Jerusalem, navǝshǝsoltia gail lotodar visi, len nǝboŋ enan dereh mǝtelǝboii ke pǝpadaŋ timasirsir. ");
INSERT INTO klv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Beti alat lototoh len naut a Jutea, limasgam mǝtahw dani vi lan naut tobaŋ ṽehuh. Ale alat lototoh len navile enan limasriŋi, mai alat lotosuh marireu saleb̃is lan. ");
INSERT INTO klv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Husur nǝboŋ galenan levi nǝboŋ hǝn nǝpanismen, hǝn natit p̃isi natosian gail lotokele lǝb̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nulolosa hǝn alat lǝb̃etian mai alat lǝb̃evǝhasus len nǝboŋ enan! Husur len naut egai dereh tikad na-b̃iltilǝŋon-isa-an mai nǝlol paŋpaŋ topansem nǝvanuan galegai. ");
INSERT INTO klv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nab̃u nǝb̃alan gail lita bun galito hǝni, ale aenemi salit gail dereh libaŋis gat galit beti sǝhar galit vi tut vi lan nǝkantri p̃isi. Ale nametb̃os gail dereh lipal sar nab̃iltivile Jerusalem, il a m̃o hǝni van vǝbar nǝboŋ salit b̃esib. ");
INSERT INTO klv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Natit tiltile gail levisi hǝn namityal, nahǝbati mai nam̃eso gail. Len navile a pan, nǝvanuan gail len nǝkantri gail dereh lemǝtahw, ledǝdarŋab̃u, nau tuhatuh hǝn nǝwalan hǝn nǝtas mai nahǝbasodum̃. ");
INSERT INTO klv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nǝvanuan gail dereh nǝlolit tiṽonṽon len namǝtahwan salit mai nǝ-vatvat-viri-an hǝn nǝsa b̃evisi len navile a pan. Husur nǝdaŋan gail len nǝmav dereh lekurkur. ");
INSERT INTO klv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Beti len nǝboŋ enan dereh leris aNatun Nǝvanuan b̃egǝm len nǝmavukasw, len nǝdaŋan mai nǝyalyalan totibau. ");
INSERT INTO klv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nǝboŋ natgalenan lǝb̃etub̃at visi, mǝteil gǝgat tinor husur asike idareh nǝ-lav-kuvi-an samito dan nǝmauran hǝn navile a pan, dereh tihav.” ");
INSERT INTO klv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Beti ikel nǝb̃ol p̃usan mai galit ke: “Mǝteris nǝhai nafik mai nǝhai p̃isi am. ");
INSERT INTO klv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nǝboŋ lotodum̃oh, mǝtolǝboi mǝtb̃eris lǝboii ke nǝboŋ naut pudpud b̃egǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Imagenan, nǝboŋ mǝtb̃eris natgalenan b̃evisvisi, mǝtelǝboii ke natohan pipihabǝlan aGot satogǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nukel nakitinan mai gamit ke, naur egai asike lumat vǝbar natgalen p̃isi lǝb̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nǝmav mai navile a pan dereh arimasig balai, avil nasoruan sagw asike imasig boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mǝtelǝlǝgau hǝn ke samtetǝrog, samtigol naṽide tosa len natǝrogan mai samtinau masuṽ hǝn nǝmauran len navile a pan o nǝboŋ enan dereh tegǝm ale mǝtosǝhoṽut lan hum mǝttobat len nǝhai tata. ");
INSERT INTO klv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Husur dereh tegǝmai len galit p̃isi lotosuh len navile a pan kavkav. ");
INSERT INTO klv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mǝtehulahul tabtab, ale sor tuṽ ke mǝtelǝboi mǝtb̃igam yav dan natgalen p̃isi pǝpadaŋ hǝn b̃evisi, ale mǝtb̃eil len nǝhon aNatun Nǝvanuan.” ");
INSERT INTO klv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ŋa len nalennǝyal p̃isi aYesu ep̃usan len naholǝvat todar vis naim siGot, be len mariug ivan vatoh len Naṽehuh Oliv. ");
INSERT INTO klv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ale nǝvanuan p̃isi lulele dudulan som̃ilan hǝn lǝb̃evi lan naholǝvat todar vis naim siGot hǝn lǝb̃esǝsǝloŋ hǝni. ");
INSERT INTO klv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Len nǝboŋ enan Nǝhanan hǝn Nabǝta Sǝkad Nayis lan, lotokisi hǝn nǝPasova, egǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo luke lisab̃ nap̃isal ideh hǝn lǝb̃igol aYesu b̃imat, be savi len nǝhon nǝvanuan gail husur lomǝtahw len galito. ");
INSERT INTO klv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Beti aSetan eb̃is len aJutas lotokisi hǝn aIskariot, gai tovi sua len ahai susur lotovi 12. ");
INSERT INTO klv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ale aJutas ivan hǝn ab̃iltihai tutumav gail mai alat lotoil a m̃o silat lotokǝtkǝta kǝkol hǝn naim siGot hǝn b̃isor mai galit husur nap̃isal ideh hǝn b̃eriŋ aYesu len navǝlalito. ");
INSERT INTO klv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lohǝhaṽur masuṽ ale ludam̃ hǝn lǝb̃ilav nǝvat nasilva maii. ");
INSERT INTO klv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ale aJutas idam̃, beti idas p̃isal hǝn b̃eriŋ aYesu len navǝlalito nǝboŋ naluṽoh lǝsǝtah maii. ");
INSERT INTO klv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Beti nǝmariboŋ hǝn Nǝhanan hǝn nabǝta sǝkad nayis lan egǝmai. Len nǝboŋ enan lotutumav hǝn natuhsipsip hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","AYesu esǝvat aPita mai aJon, ike, “Mirivan vautaut hǝn nǝhanian hǝn nǝPasova hǝn datb̃ihani.” ");
INSERT INTO klv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ale arousi ke, “Guke namreutaut hǝni a be?” ");
INSERT INTO klv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Isor var gǝlar ke, “Nǝboŋ mǝrb̃eb̃is len nab̃iltivile, naulum̃an sua topat nab̃iliwai topul dereh tebubur mai gamǝru. Mǝrehusuri vi lohoim tob̃is lan ");
INSERT INTO klv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ale kel mai amahean naim ke, ‘Ahai p̃usan eusi ke: “Narum̃ simetb̃os gai be? Nuke nihan Nǝhanian hǝn nǝPasova mai ahai susur sagw gail lan.”’ ");
INSERT INTO klv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Atenan teṽusan gamǝru hǝn nab̃iltirum̃ tokad natit p̃isi dattolǝŋoni. Mǝreutaut ei.” ");
INSERT INTO klv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ŋa aruvan, arusab̃ natit p̃isi hun tokel mai gǝlaru, ale aroutaut hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nǝboŋ namityal hǝn nǝhanan togǝmai, aYesu ipat hǝn nǝtarhǝgarin hǝn b̃ihan. Ale ahai pispisul san gail lub̃on maii. ");
INSERT INTO klv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ale ikel mai galit ke, “Nolǝŋon buni tia ke nihan nǝPasova egai mai gamito a tahw hǝn nǝb̃elǝŋon b̃isa. ");
INSERT INTO klv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Husur nukel mai gamit ke, asike nuhani am vir nǝsarpohan han len natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nǝboŋ tolav nab̃iliwai, tosipa hǝni, ike, “Mitilav nab̃iliwai egai ale pǝpehuni mai gamit gabag. ");
INSERT INTO klv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Husur nukel mai gamit ke, gagai van asike nomun tas nǝwain vir natohan pipihabǝlan aGot b̃egǝmai.” ");
INSERT INTO klv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nǝboŋ tolav nabǝta, tosipa hǝni, eb̃uri, beti ilavi mai galito, ike, “Egai nibegw notoviol hǝni m̃os gamito. Gol timaiegai hǝn mǝtb̃inau gat tin hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Len naṽide top̃itoṽ, nǝboŋ lotohan tonoŋ ilav nab̃iliwai ike, “Egai nab̃iliwai hǝn na-kel-gati-an veveu aGot tota gati len nǝda hagw, nǝda hagw b̃isel m̃os gamito len nǝmatan sagw. ");
INSERT INTO klv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Be atenan b̃eriŋ ginau len navǝlan aenemi sagw gail, navǝlan atenan ipat len natev mai navǝlagw. ");
INSERT INTO klv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Husur aNatun Nǝvanuan dereh tivan sum̃an aGot toriŋ gati tia, avil atenan b̃eriŋ aNatun Nǝvanuan len navǝlan aenemi san gail, dereh nǝmauran san tisa vǝsa batbat.” ");
INSERT INTO klv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Beti lotub̃at usus gabag hǝn galito ke, ase len galit tigol natenan. ");
INSERT INTO klv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lotub̃at ṽitṽituh len galit gabag husur galit ta be etibau sǝhor galito. ");
INSERT INTO klv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ŋa aYesu ikel mai galit ke, “Len navile a pan, nakiŋ hǝn nametb̃os gail, lupatpat galit mǝhat len nǝdaŋan salito; ale nametb̃os gail lokis alat lotoil a m̃o hǝn galito hǝn ‘Na-vi-tarhǝte-an salito.’ ");
INSERT INTO klv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Be gamit samtimaienan. Ideh len gamito totibau masuṽ, gai timasgǝm sum̃an ahai a tahw. Ale ideh len gamito toil a m̃o, timasgǝm sum̃an nǝvanuan toum kǝmas sinǝvanuan tile. ");
INSERT INTO klv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Husur ase etibau am, atenan tohan len natev, o atenan toum hǝn b̃ilav nǝhanian maii? Len nabunusian silat navile a pan evi atenan tohan len natev. Avil len gamito, evi ginau boh notoum kǝmas samito. ");
INSERT INTO klv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gamit boh mǝtutah mai ginau akis, naut kǝmas nap̃isal sagw todaŋ nǝboŋ nǝvanuan gail lotomǝtahun ginau. ");
INSERT INTO klv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sum̃an aTǝmagw tolav na-il-a-m̃o-an len natohan pipihabǝlan mai ginau, imaienan, gagai nulavi mai gamito. ");
INSERT INTO klv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dereh mitihan, mǝtemun len natev sagw len natohan pipihabǝlagw ale mǝtebǝtah len nab̃iltihai bǝtbǝtah gail hǝn mǝtb̃epǝpehun navoian dan nǝsaan len nahǝmar lotovi 12 seIsrael. ");
INSERT INTO klv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, geris, aSetan eus aGot hǝn b̃isab̃ gamito ke mǝtumabe, hum naulum̃an hǝn nǝhol todardar hǝn nǝhad m̃os namisurhuwit b̃iteh tur lan, be nǝsogsog p̃isi han b̃esuh. ");
INSERT INTO klv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Avil nusor tuṽ m̃os gaiug tia hǝn ke, nadǝlomian sam̃ asike iteh. Ale nǝboŋ gǝb̃ipair tǝlmam, gigol galit lotovi ahai susur gail am ke lidaŋ am.” ");
INSERT INTO klv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Be aPita ikel maii ke, “Nasub̃, noutaut hǝn nǝb̃itah mai gaiug van hǝn naim bǝbaŋis mai nǝmatan!” ");
INSERT INTO klv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ris aYesu tosor vari ke, “Nukel mai gaiug, Pita, natoulum̃an asike ekǝkǝraiko damǝŋai vǝbar gǝb̃ikel vǝha-tor hǝni ke gǝsalǝboi ginau.” ");
INSERT INTO klv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Beti aYesu ikel mai galit ke, “Nǝboŋ notosǝvat gamito, nǝpaus, nǝhad mai naributbut tob̃uer, mǝtom̃idol hǝn natideh a?” Ale lusor vari ke, “Ao.” ");
INSERT INTO klv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ikel mai galit ke, “Be gagai, atenan b̃ikad nǝpaus timaspati mai tipat nǝhad sǝsǝŋon am. Ale asike b̃ikad nab̃u nǝb̃alan, timasp̃ur hǝn nahurabat naut susus san hǝn b̃eṽur b̃esua. ");
INSERT INTO klv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Husur nukel mai gamit ke, natosian egai siGot timassarpoh len ginau ke, ‘Len nǝnauan salit loriŋi hum alat lotosa.’ Ale nǝsa lototosi husur ginau egǝm bar nǝsarpohan han ta bogai.” ");
INSERT INTO klv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŋa lukel maii ke, “Geris, Nasub̃, nab̃u nǝb̃alan toru!” Be gai ike, “Tinoŋ!” ");
INSERT INTO klv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Beti aYesu evivile, ale iyar vi lan Naṽehuh Oliv hum naṽide san. Ahai susur san gail lohusuri. ");
INSERT INTO klv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nǝboŋ tobar naut enan, ikel mai galit ke, “Mitisor tuṽ hǝn asike mǝtb̃iteh len nǝsaan totaltal ke mǝtehusuri.” ");
INSERT INTO klv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ivan dan galito vǝbar naut avan ideh b̃elǝboi b̃etuṽ hǝn nǝvat lan, etǝŋedur, ale isor tuṽ. ");
INSERT INTO klv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ike, “Ita, b̃evi nalǝŋonian sam̃, lav kuv nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an egai dan ginau. Avil nǝsa gotolǝŋoni tevisi, savi nǝsa notolǝŋoni.” ");
INSERT INTO klv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ale aŋel sua hǝn nǝmav evisi hǝni ale igole idaŋ. ");
INSERT INTO klv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Len nǝnauan san mai nǝlon totuhatuh masuṽ, isor tuṽ habat van van napilal san etub̃ hun nǝda toturtur len tan. ");
INSERT INTO klv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nǝboŋ tole mǝhat dan na-sor-tuṽ-an, etǝlmam van hǝn ahai susur gail ale isab̃i ke lotopat, nibelit emǝhav husur nalolosaan. ");
INSERT INTO klv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ŋa ikel mai galit ke, “Imabe mǝtupat? Mitile mǝhat, sor tuṽ hǝn asike mǝtb̃iteh len nǝsaan totaltal ke mǝtehusuri!” ");
INSERT INTO klv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nǝboŋ tosorsor sal, naluṽoh sua egǝmai. Ale aJutas tosua len tosǝŋavur pisan toru, gai eil a m̃o. Egǝm ben aYesu hǝn b̃esum̃ nǝtarhon, ");
INSERT INTO klv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","avil aYesu eusi ke, “Jutas, gumabe? Gaiug gosum̃ nǝtarhogw hǝn gǝb̃eriŋ ginau, aNatun Nǝvanuan len navǝlan aenemi sagw gail a?” ");
INSERT INTO klv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nǝboŋ alat lotohusur aYesu lotoris nǝsa b̃evisi, luke, “Nasub̃, namtib̃al mai galito hǝn nab̃u nǝb̃alan a?” ");
INSERT INTO klv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Beti galit sua itai naslev seb̃iltihai tutumav, ta kotov nǝdariŋan nǝmatu. ");
INSERT INTO klv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Avil aYesu ike, “Mitinoŋ, samtimagenan!” Ale ibar nǝdariŋan, gole imaur. ");
INSERT INTO klv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Beti aYesu ikel mai ab̃iltihai tutumav gail, alat lotokǝtkǝta kǝkol hǝn naim siGot mai alat lotoil a m̃o hǝn naJu gail ke, “Imabe mǝtogǝm, lav nab̃u nǝb̃alan mai nǝbatw gail gǝmai hǝn mǝtb̃itah gat ginau hum notovi vanuan nǝb̃alan toke tib̃al mai alat lotoil a m̃o? ");
INSERT INTO klv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Len nǝmariboŋ p̃isi nutoh mai gamit len naholǝvat todar vis naim siGot be mǝtsǝbar ginau. Avil gagai evi namityal samito mai namityal hǝn nǝdaŋan hǝn nǝmargobut.” ");
INSERT INTO klv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Beti lutah gat aYesu, losǝhari van vi lohoim seb̃iltihai tutumav. APita ehusur galit van, be sǝyar pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nǝboŋ lototuŋ nǝhab rivuh len naholǝvat todar vis naim ale lototitileh b̃onb̃on, aPita ebǝtah, tah mai galito. ");
INSERT INTO klv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Beti naslev tǝbarehreh erisi nǝboŋ tobǝtah ale nǝsalsalumean hǝn nǝhab tom̃iasi. Ale ekǝta mǝtaltal van hǝni, ike, “Ategai am itah mai atenan!” ");
INSERT INTO klv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Avil aPita isor tasi ke, “Litegai, ginau notǝtan hǝn gai!” ");
INSERT INTO klv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Beti sǝdareh ŋai togon torisi, ike, “Gaiug am, govi galit sua!” Avil aPita ike, “Aoa Tegai, savi ginau!” ");
INSERT INTO klv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ale husur nǝhaua tosua tovan, sual am isor sab̃i, ike, “Ategai boh itah maii, bathut gai am evi auleKalili.” ");
INSERT INTO klv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Avil aPita ike, “Tegai, notǝtan hǝn nǝsa gotokele.” Vǝha-sua ŋai, nǝboŋ tosor sal, natoulum̃an ekǝkǝraiko. ");
INSERT INTO klv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nasub̃ ipair, ekǝta inor van hǝn aPita, ale aPita inau tǝlmam hǝn nasoruan siNasub̃ nǝboŋ tokel maii ke, “A tahw hǝn natoulum̃an b̃ekǝkǝraiko damǝŋai, gaiug dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau.” ");
INSERT INTO klv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ale aPita evivile, itaŋ lolosa masuṽ. ");
INSERT INTO klv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Alat lotokǝtkǝta kǝkol hǝn aYesu lotub̃at sor vilesi van, luṽasi, ṽasi, ṽasi van, ");
INSERT INTO klv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","lubaŋis gat namǝtan ale loususi ke, “Sss Hai kelkel ur, ase toṽas gaiug?” ");
INSERT INTO klv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ale lukel natit isob̃ur am, losǝvari vǝsa tibatbat. ");
INSERT INTO klv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nǝboŋ naut tolan nǝSanhitrin lub̃onb̃on. Alat lotoil a m̃o hǝn nǝvanuan gail, ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo lobǝtah len nab̃onb̃onan enan. Ale losǝhar aYesu van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Luke, “Gǝb̃evi aKristo, aGot totabtabuh lan, kel mai ginamito.” Avil ikel mai galit ke, “Nǝb̃ekǝmaienan mai gamito, asike mǝtodǝlom ginau, ");
INSERT INTO klv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ale nǝb̃eus gamito, asike mǝtusor var ginau. ");
INSERT INTO klv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Be gagai van aNatun Nǝvanuan dereh tebǝtah len nǝmatu siGot hǝn b̃ikad nǝdaŋan.” ");
INSERT INTO klv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Galit p̃isi lousi ke, “Gaiug m̃au, aNatun aGot a?” Ale isor var galit ke, “Gamit mǝtuke ginau boh.” ");
INSERT INTO klv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Beti luke, “Datsalǝŋon avan ideh am hǝn b̃ikel ur nǝsaan ategai tokele. Husur gidat sǝb̃odato datosǝsǝloŋ hǝni len nabuŋon gabag!” ");
INSERT INTO klv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Beti, naluṽoh kavkav hǝn nǝSanhitrin lule mǝhat, sǝhari van hǝn aPilate. ");
INSERT INTO klv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lotub̃at sor tas aYesu, il hirhir lan ke, “Namtusab̃ ategai ke tosǝhar suluṽ nǝvanuan sinamit gail len nap̃isal tosa. Ikai tas na-ṽur-nǝtaks-an van hǝn aSisa, mai gai ike tovi aKristo, aGot totabtabuh lan tovi a kiŋ sua.” ");
INSERT INTO klv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ŋa aPilate eus aYesu ke, “Gaiug govi kiŋ seJu gail a?” Ale isor vari ke, “Gaiug boh gukele.” ");
INSERT INTO klv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Beti aPilate ikel mai ab̃iltihai tutumav gail mai naluṽoh gail ke, “Nusab̃i ke ategai sǝkad nǝsaban.” ");
INSERT INTO klv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Avil lutaltal ke, “Gai ipair hǝn nǝnauan sinǝvanuan gail hǝn nap̃usanan san len naut p̃isi a Jutea, gol loluṽoh b̃al taṽtaṽor. Etub̃at a Kalili vǝbar naut egai!” ");
INSERT INTO klv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nǝboŋ aPilate tosǝsǝloŋ hǝni, eusi ke gai b̃evi auleKalili. ");
INSERT INTO klv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ale nǝboŋ tosǝsǝloŋ lǝboii ke aYesu totoh pipihabǝlan aHerot Antipas, esǝvati van hǝn aHerot, gai am totoh len naut a Jerusalem len nǝboŋ enan. ");
INSERT INTO klv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nǝboŋ aHerot toris aYesu ehǝhaṽur masuṽ, husur sutuai elǝŋoni tia ke terisi, bathut esǝsǝloŋ hǝn naholan tohusuri, ale ike teris aYesu b̃igol namerikel ideh. ");
INSERT INTO klv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ŋa aHerot eusus nausian tosob̃ur be aYesu sasor vari. ");
INSERT INTO klv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ale ab̃iltihai tutumav gail mai ahai p̃usan gail hǝn nalo, lusor idaŋ, lusor lol paŋpaŋ ke aYesu tosa. ");
INSERT INTO klv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Beti aHerot mai nasoltia san gail loŋit nǝholit van hǝni hum gai tovi ut kǝmas, lusor vilesi. Lukol nahurabat bilbil lan ale losǝvati tǝlmam van hǝn aPilate. ");
INSERT INTO klv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Len nǝboŋ enan ŋai aHerot mai aPilate gǝlar gabag arogǝm vi bubur beti. Husur sutuai arovi enemi sǝlar gabag. ");
INSERT INTO klv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nǝboŋ aPilate tokis ab̃iltihai tutumav gail mai alat lotoil a m̃o mai nǝvanuan gail tonoŋ, ");
INSERT INTO klv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ikel mai galit ke, “Mǝtosǝhar ategai gǝm hǝn ginau hum ke avan sua tosǝhar suluṽ nǝvanuan gail len nap̃isal tosa. Nǝboŋ notoususi len nǝhomito, nǝsǝsab̃ nǝsaan ideh len ategai mǝttosor tasi, kel ke tosa. ");
INSERT INTO klv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","AHerot am sǝsab̃ nǝsaan ideh lan, husur aHerot esǝvat tǝlmam hǝni gǝm hǝn gidato. Ale imasil ke, ategai sagol natideh tonor hǝn b̃imat sile. ");
INSERT INTO klv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Imaienan, dereh nigol lebilas masuṽ hǝni ale telǝboi b̃ivan.” ");
INSERT INTO klv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Avil galit lub̃on, kai habat ke, “Sǝhar ategai vi tut, aParappas tevivile m̃os ginamito!” ");
INSERT INTO klv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Alat a Rom lutah gat a Parappas tia, bar hǝni len naim bǝbaŋis sil togol nǝvanuan lotoluṽoh, b̃al taṽtaṽor len nab̃iltivile hǝn lǝb̃emǝdas nǝgavmen, mai igol avan sua imat.) ");
INSERT INTO klv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","APilate isor van hǝn galit tǝtas am bathut ike teriŋ aYesu tivan. ");
INSERT INTO klv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Avil lukai habat van ke, “Timat! Timat len nǝhai balbal!” ");
INSERT INTO klv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Len na-vǝha-tor-an aPilate isor van hǝn galit ke, “Imabe? Igol nǝsa tosa? Nǝsǝsab̃ kas nǝsaan ideh lan tonor hǝn b̃imat sile. Imaienan dereh nigol ke lebilas masuṽ hǝni ale neriŋi tivan.” ");
INSERT INTO klv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Avil lukai susumar husur aYesu ke timat len nǝhai balbal, ale ludaŋ b̃ur aPilate. ");
INSERT INTO klv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ŋa aPilate eriŋi ke tigol nǝsa lotolǝŋoni. ");
INSERT INTO klv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ale atenan lotousi, aParappas totoh len naim bǝbaŋis sil togol nǝb̃alan hǝn b̃emǝdas nǝgavmen mai togol nǝmatan, eriŋi evivile. Avil eriŋ aYesu len navǝlalito hǝn lǝb̃igol nǝsa lotolǝŋoni hǝni. ");
INSERT INTO klv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nǝboŋ nasoltia gail lotosǝhari van, lutah gat aSimon, auleSairin sua toyar marireu gǝm vi lan naut a Jerusalem ale loriŋ nǝhai balbal lan hǝn b̃ipati husur aYesu. ");
INSERT INTO klv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ale nǝvanuan isob̃ur masuṽ lohusuri. Galevis lotovi alatpǝhaṽut lois, luṽosṽos nibelito, lutaŋisi. ");
INSERT INTO klv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Be aYesu ipair van hǝn galit ke, “Tob̃taJerusalem gail, samtitaŋis ginau be mititaŋis gamit gabag mai anatumit gail. ");
INSERT INTO klv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Husur len nǝboŋ b̃egǝmai nǝvanuan gail dereh like, ‘AGot igol navoian van hǝn alatpǝhaṽut lotobutoh, nǝhad hǝn natǝtai gail lǝsǝpasus, mai nasus gail lǝsavǝhasus!’ ");
INSERT INTO klv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Beti ‘dereh lisor mai nab̃iltiṽehuh gail ke, “Rus vi pan bar ginamito!” Lisor mai natuhṽehuh gail ke, “Kabut gol ginamito!”’ ");
INSERT INTO klv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Husur ke nǝvanuan gail lǝb̃igol natgalenan nǝboŋ nǝhai tomaur sal, nǝsa b̃evisi nǝboŋ nǝhai b̃iŋod?” ");
INSERT INTO klv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ikad naulum̃an eru, artob̃ur kotov nalo silat aRom, ale losǝhar gǝlaru van hǝn lǝb̃igol arb̃imat mai aYesu. ");
INSERT INTO klv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋa nǝboŋ lotobar naut lotokisi hǝn Nabǝlashukadhutǝmat, loriŋi itahǝtah len nǝhai balbal ei, gai mai naulum̃an eru artosa, esua len nǝmatu san, togon len nǝmair. ");
INSERT INTO klv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","AYesu ike, “Ita, gerub̃at nǝsaan egai dan galito, husur lǝsalǝboi nǝsa lotogole.” Beti lubar hǝn nǝvat hǝn lǝb̃isab̃i ke as tikad nahurabat san gail. ");
INSERT INTO klv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nǝvanuan gail loil, lokǝta bunusi. Ale nǝvanuan totibau salit gail lob̃it nabuŋolit van hǝn aYesu, lusor vilesi. Luke, “Gai ilav kuv nǝvanuan tile gail; b̃evi aKristo siGot, aGot totabtabuh lan, tilav kuv gai gabag!” ");
INSERT INTO klv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nasoltia gail am lusor vilesi, logǝm pǝpadaŋ, lav navinika van hǝni. ");
INSERT INTO klv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Luke, “Gǝb̃evi kiŋ seJu gail, lav kuv gaiug sǝb̃om̃!” ");
INSERT INTO klv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ale ikad natosian sua a mǝhat hǝni toke, “AKiŋ seJu gail bogai.” ");
INSERT INTO klv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gǝlar sua, tovi ulum̃an tosa totahǝtah ei, isor mǝdasi ke, “Gaiug gǝsavi aKristo aGot totabtabuh lan a? Mjǝǝ! Tǝmagenan, gilav kuv gaiug gabag, ale lav kuv ginamǝr am!” ");
INSERT INTO klv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Be togon isor lan ke, “Gǝsamǝtahw len aGot a? Ivoi ke gemǝtahw husur nǝpanismen sam̃ ep̃itoṽ hǝn esan. ");
INSERT INTO klv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ale gidaru darupanis inor husur darukad nǝpanismen tonor hǝn nǝsa dartogole, be ategai, gai sagol natideh tosa.” ");
INSERT INTO klv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ale ike, “Yesu, nau gat ginau nǝboŋ gǝb̃egǝm vi kiŋ.” ");
INSERT INTO klv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","AYesu isor vari ke, “Nukel nakitinan mai gaiug ke, damǝŋai dereh gitoh mai ginau len naut nahǝhaṽuran tovi Paratais.” ");
INSERT INTO klv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pǝpadaŋ hǝn natub̃lial nǝmargobut ikabut gol p̃is naut kavkav vǝbar namityal totor ut mǝdau, ");
INSERT INTO klv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","husur nǝyal satun am. Ale nab̃iltikaliko topǝpehun naim siGot emǝtar len nahudhut eru. ");
INSERT INTO klv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Beti aYesu ikai habat ke, “Ita, gagai noriŋ nanunugw len navǝlam̃.” Nǝboŋ tokǝmaienan tonoŋ, emǝsol, imat. ");
INSERT INTO klv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nǝboŋ nasenturion toris nǝsa tovisi, isor sal suh aGot, ike, “Kitin ategai evi nǝvanuan tonor bogai!” ");
INSERT INTO klv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Naluṽoh lub̃on hǝn lǝb̃ekǝta ris nǝsa tovisi. Nǝboŋ lotorisi, len natǝlmaman salito lulolosa, len nalolosaan salito lotuh nǝmabulito. ");
INSERT INTO klv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ale galit p̃isi lotolǝboi bun aYesu, loil a tut mai alatpǝhaṽut lotohusuri a Kalili, loris p̃is natgalenan. ");
INSERT INTO klv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ikad naulum̃an sua, nahǝsan aJosef tovi Sanhitrin sua, tovoi mai tonor. ");
INSERT INTO klv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Gai sǝdam̃ mai nǝSanhitrin, len nǝsa lotoutaut hǝni mai lotogole.) Evi uleArimatea, navile sua len naut a Jutea, totoh vir natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ivan hǝn aPilate ale eus niben aYesu. ");
INSERT INTO klv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Beti ipat kuvi vi pan, ruŋ gole len nǝkaliko tovi linen ale riŋi len nab̃urhuvat nǝmatan lotota p̃up̃uli tia. Lǝsǝtavun avan ideh len nab̃ur enan sal. ");
INSERT INTO klv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ale evi Nǝboŋ Nautautan, nǝSappat pǝpadaŋ b̃etub̃at. ");
INSERT INTO klv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Alatpǝhaṽut, lototah mai aYesu a Kalili, lohusur aJosef ale loris nab̃urhuvat nǝmatan mai naṽide toriŋ niben topǝlah lan. ");
INSERT INTO klv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Beti luvahim, loutaut hǝn natit tokad nǝb̃on tosusau mai nǝhai pǝhas gail m̃os niben. Ale len nǝSappat luŋavŋav husur nalo siMoses. ");
INSERT INTO klv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Len nǝmariboŋ metǝkav hǝn nawik, dudulan som̃ilan, alatpǝhaṽut lovi lan nab̃urhuvat nǝmatan, lutariv natit tosusau lotoutaut hǝn gail tia. ");
INSERT INTO klv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lusab̃ nǝvat nabopita torib tia dan nab̃ur nǝmatan ");
INSERT INTO klv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","avil nǝboŋ lotob̃is, lǝsǝsab̃ niben Nasub̃ aYesu. ");
INSERT INTO klv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nǝboŋ lotonau tǝtan hǝn natenan sal, be losǝhoṽut len naulum̃an toru artoil ben galito, artosun nahurabat tokabkabil. ");
INSERT INTO klv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ninelit epil vǝsa, ale lotǝŋedur kǝta vi pan be gǝlaru arukel mai galit ke, “Mǝtudoŋ mab hǝn avan tomaur len naut silat lotomat? ");
INSERT INTO klv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Atenan satoh gegai, avil aGot igol ile mǝhat tia! Mitinau tǝlmam hǝn nǝboŋ totoh len naut a Kalili sal, ");
INSERT INTO klv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","tokel mai gamit ke, ‘Nǝvanuan gail limasriŋ aNatun Nǝvanuan len navǝlan nǝvanuan nǝsaan gail, ale gai timastahǝtah len nǝhai balbal, ale len nǝmariboŋ totor timasle mǝhat tǝtas.’” ");
INSERT INTO klv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Beti lunau tǝlmam hǝn nasoruan san, ");
INSERT INTO klv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ale nǝboŋ lototǝlmam dan nab̃urhuvat nǝmatan, lukel p̃is natgalenan mai Tosǝŋavur Pisan Tosua mai ahai susur tile gail am. ");
INSERT INTO klv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Alatpǝhaṽut galenan lotokǝmaienan mai ahai pispisul gail: lovi aMeri ta Maktala, aJoanna, aMeri anan aJemes mai alat lototah mai galito. ");
INSERT INTO klv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Avil ahai pispisul gail lǝsadǝlom nasoruan enan husur lunau ke sǝkad namilen. ");
INSERT INTO klv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Be aPita ile mǝhat, igam vi lan nab̃urhuvat nǝmatan. Nǝboŋ tob̃etb̃et hǝn b̃ekǝta vi lan b̃urhuvat, eris nǝkaliko nalinen gail ŋai, ale ivahim, ip̃aŋ len nǝsa tovisi. ");
INSERT INTO klv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Len nǝmariboŋ enan ŋai ikad galit eru artovi lan navile lotokisi hǝn Emmaus, nakilomita han tovi 11 a tut dan naut a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Gǝlaru arusorsor mai gǝlar gabag husur natit p̃isi tovisi tia. ");
INSERT INTO klv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nǝboŋ artosorsor mai artohol husur natgalenan, aYesu m̃au egǝm, itah mai gǝlaru len nǝyaran sǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Be aGot igol arsakǝta lǝboii. ");
INSERT INTO klv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ale eus gǝlar ke, “Len nasoruan samǝru nǝboŋ mǝrtoyar van, mǝruhol husur nǝsa?” Ale aroil ei, len nalolosaan arusar batut. ");
INSERT INTO klv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Beti gǝlar sua, nahǝsan aKleopas isor vari ke, “Len nametb̃os p̃isi a Jerusalem, gaiug sǝb̃om̃ gǝsalǝboii nǝsa tovisi ei len nǝboŋ galeg a?” ");
INSERT INTO klv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eus gǝlar ke, “Nǝsa gail?” Arusor vari ke, “Natgalenan husur aYesu ta Nasaret, aulum̃an sua tovi hai kelkel ur todaŋ len nagolean mai nasoruan len nǝhon aGot mai nǝvanuan gail p̃isi. ");
INSERT INTO klv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Beti ab̃iltihai tutumav gail mai alat lotoil a m̃o sidato, loriŋi len navǝlan alat a Rom hǝn lǝb̃eriŋ nǝmatan lan, ale lugol itahǝtah len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Avil a m̃o namtuvatvat viri ke, tovi atenan b̃ilav kuv a Israel dan alat lototǝgau gat gidato. Be savi natenan ŋai, damǝŋai evi nǝmariboŋ totor togam gol natgalenan tovisi tia. ");
INSERT INTO klv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ale sual am, alatpǝhaṽut sinamit galevis lugol namtosǝhoṽut. Damǝŋ dudulan som̃ilan lovi lan nab̃ur nǝmatan ");
INSERT INTO klv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ale nǝboŋ lǝsǝsab̃ niben, lotǝlmam, luke lotoris na-kǝta-risi-an sual ei ke, aŋel artoke aYesu tomaur tia. ");
INSERT INTO klv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Beti galit galevis lototah mai ginamito, lovi lan nab̃ur nǝmatan ale lusab̃i hum alatpǝhaṽut lotokele, avil gai, lǝsarisi.” ");
INSERT INTO klv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","AYesu ikel mai gǝlar ke, “Nǝkadumir iṽonṽon. Idaŋ hǝn mǝrb̃edǝlom p̃is nǝsa ahai kelkel ur gail lotokele. ");
INSERT INTO klv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Evi nalǝŋonian siGot ke aKristo imaslǝŋon isa vǝsa m̃os natgalenan, beti b̃is len nǝyalyalan san.” ");
INSERT INTO klv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Beti tub̃at len aMoses mai ahai kelkel ur gail p̃isi, isor vahvah mai gǝlaru, kel natit p̃isi husur gai gabag topat len natosian siGot kavkav. ");
INSERT INTO klv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nǝboŋ lotoyar gǝm pǝpadaŋ hǝn navile artovan hǝni, aYesu iyar sum̃an b̃ivan am. ");
INSERT INTO klv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Be arutaltal hǝni ke, “Gitoh mai ginamǝru husur naut igomgom mai namityal imasur tia.” Ale eb̃is lohoim hǝn b̃itoh mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nǝboŋ topat hǝn nǝtarhǝgarin hǝn b̃ihan mai gǝlaru len natev, ilav nabǝta, esipa hǝni, eb̃uri ale ilavi mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Vǝha-sua ŋai namǝtalar esǝŋav, aroris lǝboii. Beti iyav dan gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Arousus gǝlar gabag ke, “Imabe nǝlodar imavuhos nǝboŋ tosor mai gidaru metp̃isal, tosor vahvah hǝn natosian siGot mai gidaru?” ");
INSERT INTO klv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ŋa len namityal enan ŋai arule mǝhat, arotǝlmam vi Jerusalem. Arusab̃ Tosǝŋavur Pisan Tosua lotob̃onb̃on mai alat lototah mai galito, ");
INSERT INTO klv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","lotoke tokitin ke Nasub̃ tole mǝhat mai tovisi hǝn aSimon. ");
INSERT INTO klv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Beti gǝlaru arukel ur nǝsa tovisi metp̃isal mai na-ris-lǝboii-an sǝlaru nǝboŋ aYesu tob̃ur nabǝta. ");
INSERT INTO klv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nǝboŋ artohol husur natgalenan sal, aYesu evisi, eil rivuh len galito ale ikel mai galit ke, “Nǝlomit tikad natǝm̃at.” ");
INSERT INTO klv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Be losǝhoṽut, ninelit epil, lunau ke lotoris nanunun. ");
INSERT INTO klv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Beti ikel mai galit ke, “Mǝtomǝtahw hǝn nǝsa? Imabe nǝlomit euri ke notomaur tǝtas? ");
INSERT INTO klv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mǝteris navǝlagw mai nariegw gǝlaru; ginau bogai! Bar ginau hǝn mǝtb̃elǝboi ginau, husur nanunun ideh sǝkad nabǝlasehw mai navisoh sum̃an ginau notokade.” ");
INSERT INTO klv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nǝboŋ tokǝmaienan tonoŋ eṽusan galit hǝn navǝlan mai narien gǝlaru. ");
INSERT INTO klv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Len nakemkeman mai nǝmaŋmaŋan salito nǝlolit euri sal ale ike, “Mǝtukad nǝhanian ideh geg a?” ");
INSERT INTO klv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ŋa lulav nahudhuieh lotolǝŋasi maii, ");
INSERT INTO klv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ale ilavi, ihani len nǝholito. ");
INSERT INTO klv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Beti ikel mai galit ke, “Egai nǝsa notokele mai gamit tia nǝboŋ nototoh mai gamit sal ke, natit p̃isi lototosi husur ginau len nalo siMoses mai ahai kelkel ur gail mai nǝb̃e gail limassarpoh.” ");
INSERT INTO klv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Beti esǝŋav hǝn nǝnauan salit hǝn lǝb̃elǝboi natosian siGot. ");
INSERT INTO klv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ikel mai galit ke, “Natosian ekǝmaiegai ke: AKristo, aGot totabtabuh lan, timaslǝŋon tisa vǝsa ale le mǝhat dan nǝmatan len nǝmariboŋ titor. ");
INSERT INTO klv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ale len nahǝsan dereh nǝvanuan gail likel ur nǝpairan dan nǝsaan m̃os narub̃atian dan nǝsaan van hǝn naluṽoh hǝn nametb̃os gail p̃isi, tub̃at a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamit mǝtoris natgalenan, mitia kel ur nǝsa mǝttorisi mai nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mǝteris, nosǝvat nǝsa aTǝmagw tokel gati van hǝn gamito, be gamit mititoh len nab̃iltivile vir aGot b̃ikol nǝdaŋan hǝn nǝyalyalan len gamito hum nahurabat.” ");
INSERT INTO klv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Beti esǝhar galit vǝbar naut a Petani, ale isah hǝn navǝlan vi mǝhat, eus aGot hǝn b̃igol navoian van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nǝboŋ tosorsor sal eriŋ galito ale aGot ilavi vi mǝhat vi lan nǝmav. ");
INSERT INTO klv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ŋa lulotu hǝni beti lotǝlmam vi Jerusalem, lukemkem masuṽ. ");
INSERT INTO klv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ale lutoh tin len naholǝvat todar vis naim siGot, lusor sal suh tabtab hǝn aGot. ");
INSERT INTO klv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Len natub̃atan naSoruan itoh tia, ale aSoruan itah mai aGot, aSoruan enan evi Got. ");
INSERT INTO klv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Atenan itah mai aGot len natub̃atan. ");
INSERT INTO klv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Len atenan aGot igol natit p̃isi tovisi. Atenan tab̃uer, asike tǝkad natideh. ");
INSERT INTO klv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gai evi nǝkadun nǝmauran, ale nǝmauran enan evi nam̃ial sinǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nam̃ial satom̃ial van sal len nǝmargobut be nǝmargobut sasǝhori. ");
INSERT INTO klv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aulum̃an sua egǝmai, aGot tosǝvati, nahǝsan aJon. ");
INSERT INTO klv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Atenan egǝm hum na-sor-lǝboii-an hǝn b̃ikel vǝhot nakitinan husur nam̃ial, hǝn nǝvanuan p̃isi lǝb̃edǝlom napisulan tokele. ");
INSERT INTO klv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gai gabag savi m̃ial, be egǝm hǝn b̃ikel vǝhot nakitinan husur nam̃ial. ");
INSERT INTO klv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ASoruan egaii togǝm hǝn navile a pan, gai evi nam̃ial kitin tom̃ias nǝvanuan p̃isi. ");
INSERT INTO klv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Len gai aGot igol navile a pan tovisi. ASoruan itoh len navile a pan avil navile a pan lǝsakǝta lǝboii. ");
INSERT INTO klv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Egǝm hǝn nǝvanuan gail lotovi esan matmat, avil esan gail lomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Be galit p̃isi lotohǝhaṽur hǝni, lotoriŋ nǝlolit len nahǝsan, eviol mai galit maiegai ke: evi len galito hǝn lǝb̃egǝm vi natun aGot gail. ");
INSERT INTO klv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nǝvanuan ideh sǝpas galito, lǝsavisi husur na-lǝŋon-buni-an sinǝvanuan o husur nǝnauan seulum̃an, avil nǝpasian salit egǝm len aGot. ");
INSERT INTO klv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ASoruan beti egǝm vi vanuan, itoh mai gidato. Datoris nǝyalyalan san, nǝyalyalan aSoruan tokade, husur tosua ŋai, togǝm len aTata. Epul hǝn navoian toviol kǝmas hǝni, epul hǝn nakitinan. ");
INSERT INTO klv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","AJon ikel vǝhot nakitinan husuri, ikai ke, “Ategai bogai notosor husuri ke, ‘Gai b̃egǝm a tahw len ginau, iyalyal sǝhor ginau, husur itoh sutuai tia, ginau notob̃uer sal.’” ");
INSERT INTO klv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Husur napulan hǝn navoian san, eviol kǝmas hǝn navoian mai gidato. Ale len navoian san, eviol, eviol, eviol tabtab mai gadito. ");
INSERT INTO klv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bathut len aMoses, aGot eviol hǝn nalo, avil len aYesu, aGot eviol kǝmas hǝn navoian mai nakitinan mai gidato. ");
INSERT INTO klv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Avan ideh saris aGot boŋ ideh. ANatun sǝb̃on ŋai tosua, tovi Got, gai totoh tin mai aTata, gai eris aGot, isor vǝsvǝsaii. ");
INSERT INTO klv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","NaJu gail a Jerusalem losǝvat ahai tutumav gail mai galevis len nahǝmar aLevi mai naFarisi gail hǝn lǝb̃eus aJon ke, “Gaiug ase?” Ale egai evi na-kel-koti-an siJon. ");
INSERT INTO klv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ikel vǝhoti, satǝtas gole, ikel vǝhoti ke, “Ginau nǝsavi aKristo, aGot totabtabuh lan.” ");
INSERT INTO klv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ŋa lousi ke, “Ase gaiug? AElijah la?” Ale ike, “Aoa, nǝsavi gai.” Luke, “Govi ahai kelkel ur a?” Isor var galit ke, “Ao.” ");
INSERT INTO klv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Beti lousi ke, “Gaiug ase? Gikel koti mai ginamit hǝn namtb̃ikel mai alat lotosǝvat ginamito. Gaiug gikel nǝsa husur gaiug?” ");
INSERT INTO klv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","AJon isor var galito hum ahai kelkel ur, aIsaiah ta sutuai toke, “Novi nadoldol tokai len naut masmas tob̃ǝb̃esw ke, ‘Gol nap̃isal tinor m̃os Nasub̃!’” ");
INSERT INTO klv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Beti naFarisi gail naJu lotosǝvat galit gǝmai, ");
INSERT INTO klv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","lousi ke, “Asike gǝb̃evi aKristo, asike gǝb̃evi aElijah, asike gǝb̃evi aHai kelkel ur, imabe gubaptais hǝn nǝvanuan gail?” ");
INSERT INTO klv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","AJon isor var galit ke, “Ginau nubaptais hǝn nǝwai, be ikad sua toil ben gamito, mǝtsakǝta lǝboii. ");
INSERT INTO klv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Gai toyar a tahw hǝn ginau, ginau nǝsanor kasi hǝn nǝb̃isah rub̃at nǝhau hǝn naributbut san.” ");
INSERT INTO klv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Len nǝboŋ enan aJon ibapbaptais hǝn nǝvanuan gail len naut a Petani, tarhǝwisel Jortan. ");
INSERT INTO klv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pelan han, aJon eris aYesu toyaryar gǝmai ale ike, “Mǝteris! Natuhsipsip siGot b̃ilav kuv nǝsaan sinavile a pan. ");
INSERT INTO klv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ategai bogai notosor husuri ke, ‘Dereh avan sua tegǝm a tahw len ginau, iyalyal sǝhor ginau, husur itoh sutuai tia, ginau notob̃uer sal.’ ");
INSERT INTO klv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ginau nǝsakǝta lǝboii, avil nogǝm, nubaptais hǝn nǝwai hǝn nǝb̃igol aIsrael lǝb̃elǝboii.” ");
INSERT INTO klv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Beti aJon ikel koti ke, “Nǝsakǝta lǝboi ategai, avil atenan tosǝvat ginau hǝn nǝb̃ibaptais hǝn nǝwai, ikel mai ginau ke, ‘Nǝboŋ gǝb̃eris aNunugw b̃evi pan, b̃itoh tin len avan sua, avan enan dereh tibaptais hǝn nǝvanuan gail hǝn aNunun aGot.’ Beti noris aNunun aGot tovi pan dan nǝmav hum nǝtav ale itoh tin len ategai. ");
INSERT INTO klv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ale noris natgalen tia, nukel koti ke, ateg bogai aGot totabtabuh lan.” ");
INSERT INTO klv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Len nǝboŋ tohusuri aJon eil tǝtas mai eru len ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nǝboŋ toris aYesu toṽot van ike, “Mǝteris! Natuhsipsip siGot bolai.” ");
INSERT INTO klv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nǝboŋ ahai susur artosǝsǝloŋ hǝn nǝsa tokele, arohusur aYesu. ");
INSERT INTO klv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Beti aYesu ipair, eris gǝlaru artohusuri, ale eus gǝlar ke, “Mǝrolǝŋon nǝsa?” Arusor vari ke, “Rappi (namilen ke Hai p̃usan), gutohtoh a be?” ");
INSERT INTO klv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Isor var gǝlar ke, “Gǝm, kǝta risi.” Ŋa aruvan, aroris naut totohtoh lan, ale arutah maii len namityal tovat ut mǝdau, lovurvur nǝmariboŋ enan maii. ");
INSERT INTO klv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","AAdru aṽan aSimon Pita, evi gǝlar sua tosǝsǝloŋ hǝn nǝsa aJon tokele, tohusur aYesu. ");
INSERT INTO klv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Natit metǝkav aAdru togole, isab̃ aSimon, aṽan gabag, ale ikel maii ke, “Namrusab̃ aMessiah!” (namilen tovi aKristo, aGot totabtabuh lan). ");
INSERT INTO klv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Beti aAdru esǝhar aPita van hǝn aYesu. AYesu ekǝta bunusi ale ike, “Gaiug boh aSimon, anatun aJon, dereh lekis gaiug hǝn aKefas (namilen tovi aPita).” ");
INSERT INTO klv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pelan han aYesu ike tevi lan naut a Kalili. Ebubur mai aFilip ale ikel maii ke, “Gegǝm husur ginau.” ");
INSERT INTO klv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(AFilip evi aulePetsaita tovi navile matmat siAdru mai aPita). ");
INSERT INTO klv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","AFilip isab̃ aNatanael ale ikel maii ke, “Namtusab̃ ategai aMoses totos husuri len nalo san, ahai kelkel ur gail am lutos husuri! Nahǝsan aYesu, anatun aJosef ta Nasaret.” ");
INSERT INTO klv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ANatanael eusi ke, “Natideh tovoi m̃au egǝm a Nasaret a? Eb̃uer!” AFilip ike, “Gegǝm risi.” ");
INSERT INTO klv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nǝboŋ aYesu toris aNatanael togǝm hǝni ike, “Mǝteris! AuleIsrael kitin bogai! Sǝkad nagǝgǝrasan ideh lan.” ");
INSERT INTO klv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ANatanael eusi ke, “Golǝboi mab hǝn ginau?” AYesu isor vari ke, “Noris gotobǝtah pipifik, a tahw hǝn aFilip tokis gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ANatanael esǝhoṽut len natenan, isor vari ke, “Hai p̃usan, kitin, gaiug boh aNatun aGot, gaiug boh aKiŋ seIsrael!” ");
INSERT INTO klv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","AYesu ikel maii ke, “Godǝlom natenan husur notokel mai gaiug ke notoris gotobǝtah pipifik a? Dereh geris natit gail gǝb̃ip̃aŋ lan sǝhor masuṽ hǝn natenan.” ");
INSERT INTO klv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","AYesu isor am ke, “Kitin, nokitin mai gamit ke, dereh mǝteris nǝmav b̃esǝŋav, aŋel siGot gail lǝb̃evi mǝhat ale lǝb̃evi pan len aNatun Nǝvanuan.” ");
INSERT INTO klv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hois am ikad nǝlahan len naut a Kana a Kalili. Anan aYesu itoh ei, ");
INSERT INTO klv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ale lous aYesu mai ahai susur san gail am hǝn lǝb̃egǝm hǝn nǝlahan. ");
INSERT INTO klv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Len nǝhanan, nǝboŋ nǝwain tohav, anan aYesu ikel maii ke, “Lupar wain.” ");
INSERT INTO klv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ale aYesu isor vari ke, “Litegai, savi natideh len gidaru, namityal sagw sagǝm sal.” ");
INSERT INTO klv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ale anan ikel mai nǝvanuan nauman gail ke, “Nǝsa b̃ikel mai gamito, mitigole.” ");
INSERT INTO klv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Len naut enan nab̃iltib̃iliwai nǝvat tomǝlevtes loil ei. Husur naṽide len nalo salito, naJu gail lugol galit luveveu len nǝwai enan. Nǝboŋ nab̃iltib̃iliwai ṽisusua topul ikad nalita tovi 80 o 120 lan. ");
INSERT INTO klv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","AYesu ikel mai galit ke, “B̃ir nǝwai len nab̃iltib̃iliwai galegai.” Ale lob̃ir nǝwai van vapul sǝsǝhov. ");
INSERT INTO klv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Beti ikel mai galit ke, “Vǝvaut kuv ideh, lavi van hǝn nǝmasta hǝn nǝhanan.” Ale lugole. ");
INSERT INTO klv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nǝboŋ amasta hǝn nǝhanan todamis nǝwai togǝm vi wain, ekis naulum̃an tomadhalah gǝmai. (Amasta salǝboi naut nǝwain togǝm lan, be nǝvanuan nauman gail lolǝboii). ");
INSERT INTO klv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Isor sal suh aulum̃an en tolah ke, “Nǝvanuan p̃isi lopǝpehun nǝwain tovoi a m̃o, ale nǝboŋ galit lototǝrog, lopǝpehun togon savoi masuṽ. Avil gaiug, gotǝgau gat nǝwain tovoi vǝbar gagai!” ");
INSERT INTO klv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Natenan aYesu togole len navile a Kana a Kalili evi namerikel metǝkav tokel kot aYesu, tovǝhot nǝyalyalan san. Ale ahai susur san gail loriŋ nǝlolit todaŋ lan. ");
INSERT INTO klv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nǝboŋ nǝlahan tonoŋ aYesu evi pan vi Kapernaum, gai mai aṽan gail mai anan mai ahai susur san gail, ale losuh ei hǝn nǝmariboŋ galevis. ");
INSERT INTO klv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","NǝPasova seJu gail egǝm pǝpadaŋ, ale aYesu evi mǝhat vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Len naholǝvat todar vis naim siGot eris alat lotop̃ur hǝn nab̃uluk mai nasipsip mai nǝtav gail. Eris alat lotogǝgel hǝn nǝvat lotobǝtah ei. ");
INSERT INTO klv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","AYesu ebutan b̃onb̃on hǝn nǝhau gail, beti ehut nǝvanuan p̃isi dan naholǝvat todar vis naim siGot. Ehut nasipsip mai nab̃uluk gail, idaŋdaŋ nakoin gail ale ikabsan natev gail. ");
INSERT INTO klv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ikel mai alat lotop̃ur hǝn nǝtav gail ke, “Tariv natgaleg vi tut. Samtigol naim seTǝmagw tehun naim nǝmaket!” ");
INSERT INTO klv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ahai susur san gail lunau sǝhoti ke natosian ike, “Nǝlogw ipat tabtab len naim sam̃ totǝgau gat tabtab hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nǝlon naJu gail epǝŋasi ale lousi ke, “Gukad nǝdaŋan hǝn na-il-a-m̃o-an tomabe hǝn gotolǝboi gǝb̃igol natgalenan? Gigol namerikel ideh hǝn namtb̃ekǝta lǝboi nǝdaŋan sam̃!” ");
INSERT INTO klv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","AYesu isor var galit ke, “Mitigol naim siGot egai timasirsir, ale dereh neum hǝni tile mǝhat tǝlmam len nǝmariboŋ titor.” ");
INSERT INTO klv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ale lusor vari ke, “Namtoum hǝn naim egai len nasihau tovi 46. Gunau ke golǝboi gǝb̃eum hǝni b̃ile mǝhat tǝlmam len nǝmariboŋ b̃itor mabe?” ");
INSERT INTO klv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ris aYesu tosor husur naim siGot tovi niben. ");
INSERT INTO klv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Imagenan, nǝboŋ aGot tolavi dan nǝmatan, ahai susur san gail lunau gat nategai tokele tia, ale lodǝlom natosian siGot mai nasoruan siYesu. ");
INSERT INTO klv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ale nǝboŋ aYesu totoh len naut a Jerusalem len nǝhanan hǝn NǝPasova, isob̃ur loriŋ nǝlolit len nahǝsan nǝboŋ lotoris namerikel gai togolgole. ");
INSERT INTO klv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Avil aYesu sǝkad nadǝlomian len nǝlolit lotoriŋi len gai husur elǝboi nab̃oruan nǝsaan salit gail. ");
INSERT INTO klv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Avan ideh asike b̃ikel kot nǝvanuan gail maii, savi natideh len gai, husur gai elǝboi nab̃oruan salit tia. ");
INSERT INTO klv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ikad avan sua len naFarisi gail, nahǝsan aNikotemus toil a m̃o hǝn naJu gail. ");
INSERT INTO klv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Egǝm hǝn aYesu len mariug, ale isor maii ke, “Hai p̃usan, namtolǝboii ke gaiug govi ahai p̃usan sua aGot tosǝvati gǝmai, husur sǝkad avan ideh tolǝboi b̃igol namerikel gotogolgole, asike aGot b̃itoh maii.” ");
INSERT INTO klv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","AYesu isor vari ke, “Kitin, nokitin mai gaiug ke, avan ideh asike b̃ikad nǝpasian tǝtas, edǝdas b̃eris natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ANikotemus eusi ke, “Imab hǝn nǝvanuan tovi haṽut tia b̃ikad nǝpasian tǝtas? Edǝdas b̃eb̃is tǝlmam len nǝhad hǝn natǝtai len nabǝhaṽun anan hǝn b̃ipas vǝha-ru hǝni!” ");
INSERT INTO klv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","AYesu isor vari ke, “Kitin, nokitin mai gaiug ke, nǝvanuan timaskad nǝpasian len nǝwai mai aNunun aGot, hǝn b̃elǝboi b̃eb̃is len natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Niben nǝvanuan ipas nǝvanuan tokad nǝmauran hǝn niben ŋai, aNunun aGot ipas nanunun nǝvanuan, nanunun toveveu, tokad nǝmauran toveveu. ");
INSERT INTO klv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Imaienan, sagip̃aŋ len nǝsa notokele ke, ‘Gimaskad nǝpasian tǝtas.’ ");
INSERT INTO klv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nǝlan eṽuv husur nalǝŋonian san ale gosǝsǝloŋ hǝn nǝwalan han, be gǝsalǝboi naut toṽuv gǝm lan mai naut toṽuv vi lan. Len naṽide tomaienan, gǝsaris aNunun aGot, be goris nauman san len nǝmauran silat aNunun aGot topas nanunulito toveveu.” ");
INSERT INTO klv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ANikotemus eusi ke, “Natgalenan levisi mabe?” ");
INSERT INTO klv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","AYesu isor vari ke, “Imabe? Govi ahai p̃usan totibau seIsrael, be gǝsalǝboi natgaleg a? ");
INSERT INTO klv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kitin, nokitin mai gaiug ke, namtukel ur nǝsa namttolǝboii, namtukel kot nǝsa namttorisi, avil gamito, mǝtsadǝlom na-kel-koti-an sinamito. ");
INSERT INTO klv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nǝboŋ notosor husur nǝsa tovisi len navile a pan, mǝtsadǝlom ginau. Gol ke nǝb̃isor husur nǝsa tovisi len nǝmav, asike mǝtodǝlom ginau! ");
INSERT INTO klv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sǝkad avan ideh tovi mǝhat len nǝmav tolǝboi b̃ikel ur nǝsa tovisi lan. ANatun Nǝvanuan ŋai egǝm len nǝmav, naut san matmat, ale gai ŋai elǝboi b̃ikel husuri. ");
INSERT INTO klv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Len naut tob̃ǝb̃esw, tomasmas, aMoses esuhun nǝlablab hǝn nǝm̃at len nǝhai. Len naṽide tomaienan, limassuhun aNatun Nǝvanuan len nǝhai balbal, ");
INSERT INTO klv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","hǝn ke, nǝvanuan p̃isi lǝb̃eriŋ nǝlolit lan, dereh likad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Bathut aGot elǝmas bun navile a pan maiegai ke: eviol hǝn aNatun tosua sǝb̃on hǝn avan ideh b̃eriŋ nǝlon b̃idaŋ lan, asike, asike imasig be dereh tikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Husur aGot sasǝvat aNatun vi lan navile a pan hǝn b̃eriŋi ke lipanis sil nǝsaan salito, be hǝn ke, len aNatun, aGot b̃ilav kuv galit dan nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Avan ideh tokad nadǝlomian lan, aGot sariŋi ke b̃ipanis, avil avan ideh sǝkad nadǝlomian lan, aGot eriŋi tia ke tipanis, husur sǝkad nadǝlomian len nahǝsan aNatun aGot tovi aNatun tosua sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nǝpanismen esil nategai ke: Nam̃ial eb̃is len navile a pan, be nǝvanuan lolǝmas bun nǝmargobut sǝhor Nam̃ial, husur nǝsa lotogolgole isa batbat. ");
INSERT INTO klv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Husur alat lotogolgol nǝsaan lomǝtahun bun Nam̃ial, lǝsavi lan Nam̃ial husur lomǝtahw len Nam̃ial b̃em̃ias p̃arp̃ar hǝn nǝsaan salito len nǝhon nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Be avan ideh totoh len nakitinan, egǝm hǝn Nam̃ial hǝn b̃em̃ias nǝsa togole len nǝdaŋan siGot.” ");
INSERT INTO klv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nǝboŋ natgalenan tonoŋ, aYesu mai ahai susur san gail lovi lan naprovens a Jutea. Len naut enan itohtoh mai ahai susur san gail ale ibaptais hǝn nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","AJon am ibaptais hǝn nǝvanuan gail len naut a Aenon pǝpadaŋ hǝn naut a Salim, husur nǝwai isob̃ur ei. Ale nǝvanuan gail logǝm tabtab hǝni, hǝn lǝb̃ibaptais. ");
INSERT INTO klv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Len nǝboŋ enan lǝsariŋ aJon len naim bǝbaŋis sal). ");
INSERT INTO klv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Beti ahai susur siJon galevis loṽitṽituh mai naJu sua husur naṽide hǝn nalilosan hǝn lǝb̃iveveu m̃os nalotuan. ");
INSERT INTO klv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ale logǝm hǝn aJon, luke, “Hai p̃usan, ategaii totoh mai gaiug tarhǝwisel Jortan, ategaii gotosor husuri, gagai ibaptais hǝn nǝvanuan gail, ale nǝvanuan p̃isi logǝm hǝni.” ");
INSERT INTO klv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ale aJon isor var galit ke, “Nǝvanuan elǝboi b̃ikad nǝsa ŋai aGot len nǝmav toviol hǝni maii. ");
INSERT INTO klv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamit m̃au mǝtolǝboi mǝtb̃ikel kot nǝsa notokele ke, ‘Ginau nǝsavi aKristo, aGot totabtabuh lan. Avil aGot esǝvat ginau a m̃o tia, beti atenan.’ ");
INSERT INTO klv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nǝb̃ikel nasoruan kǝta husuri, imaiegai ke, natǝbarehreh tolah evi seulum̃an tolah maii. Be naulum̃an tovi tarhǝt sitenan tolah, toil tǝban, tosǝsǝloŋ hǝni, gai ehǝhaṽur hǝn tosǝsǝloŋ hǝn nadolon aten tolah. AKristo esum̃an atenan tolah, ale nǝvanuan lotovan hǝni hǝn b̃ibaptais hǝn galito, losum̃an alitenan tolah. Ginau nosum̃an naulum̃an tovi tarhǝt sitenan. Nopul hǝn nahǝhaṽuran nǝboŋ notosǝsǝloŋ hǝn nǝvanuan gail lotovan hǝn aKristo. ");
INSERT INTO klv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","AKristo timasyalyal sǝhor ginau; ginau a pan.” ");
INSERT INTO klv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Atenan togǝm len naut a mǝhat, iyalyal sǝhor natit p̃isi; avan tovi hǝn navile a pan, evi sinavile a pan, ale isor husur natit gail sinavile a pan ŋai. Atenan togǝm len nǝmav iyalyal sǝhor natit p̃isi. ");
INSERT INTO klv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ikel kot nǝsa torisi, nǝsa tosǝsǝloŋ hǝni be sǝkad avan ideh todǝlom nǝsa tokele. ");
INSERT INTO klv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Be avan ideh todǝlom na-sor-lǝboii-an san, isab̃ sǝhoti ke aGot ekitin. ");
INSERT INTO klv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Husur atenan aGot tosǝvati ikel nasoruan siGot husur aGot eviol hǝn aNunun kavkav maii, nagilen tob̃uer. ");
INSERT INTO klv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","AGot, aTata elǝmas bun aNatun, ale eriŋ natit p̃isi len navǝlan tia. ");
INSERT INTO klv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Avan ideh toriŋ nǝlon todaŋ len aNatun aGot ikad nǝmauran vi sutuai. Avil avan ideh tomǝtahun b̃eriŋ nǝlon len aNatun aGot, asike ikad nǝmauran enan, be nǝlol paŋpaŋ siGot ipat tabtab lan. ");
INSERT INTO klv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Beti naFarisi gail losǝsǝloŋ hǝni ke aYesu tobaptais hǝn nǝvanuan lotosob̃ur hǝn lǝb̃egǝm vi hai susur san gail, lusob̃ur sǝhor siJon. ");
INSERT INTO klv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Be savi aYesu tobaptais hǝn nǝvanuan, ahai susur san gail ŋai lugole.) ");
INSERT INTO klv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nǝboŋ aYesu tolǝboi nǝsa naFarisi gail lotosǝsǝloŋ hǝni, eriŋ naut a Jutea, etǝlmam vi Kalili. ");
INSERT INTO klv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Len nǝvanan san imasyar tur len naut a Samaria. ");
INSERT INTO klv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ale ibar navile sua a Samaria, nahǝsan a Sikar, topat pǝpadaŋ hǝn nǝtan aJakop tolavi mai aJosef, anatun. ");
INSERT INTO klv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ikad nab̃urhuwai siJakop ei. Beti aYesu, niben tomatmat husur nǝyaran tobǝlav, ebǝtah tarhǝb̃urhuwai enan. Natub̃lial bolai. ");
INSERT INTO klv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Atob̃taSamaria sua egǝm hǝn b̃evǝvaut. Ale aYesu ikel maii ke, “Lav nǝwai. Nemuni.” ");
INSERT INTO klv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ebǝtah sǝb̃on husur ahai susur san gail lovi lan navile hǝn lǝb̃eṽur nǝhanian ideh. ");
INSERT INTO klv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Imagenan apǝhaṽut isor vari ke, “Be gaiug govi Ju, ginau novi tob̃taSamaria. Gous mab hǝn nǝwai hǝn ginau?” (Husur alat a Jutea lǝsab̃on mai alat a Samaria boŋ ideh). ");
INSERT INTO klv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ale aYesu isor vari ke, “Gǝtalǝboi naviolan siGot, mai ginau notokel mai gaiug, ‘Lav nǝwai. Nemuni,’ gǝtaus ginau hǝni tia, ale nǝtǝlav nǝwai nǝmauran mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Alitenan ikel maii ke, “Nasub̃, gǝsǝkad nab̃iliwai, nǝhau eb̃uer, ale nab̃urhuwai eg isareh masuṽ. Golǝboi gǝb̃evǝvaut nǝwai nǝmauran enan a be? ");
INSERT INTO klv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gaiug gunau ke gototibau sǝhor atǝmadat ta sutuai, aJakop a? Bathut gai m̃au ilav nab̃urhuwai egai mai gidato, ale gai mai anatun gail mai narivatǝvat gail lomun lan.” ");
INSERT INTO klv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","AYesu isor vari, ike, “Nǝvanuan p̃isi lotomun len nǝwai egai, dereh limaduh tǝtas. ");
INSERT INTO klv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Avil avan ideh tomun nǝwai nǝb̃ilav maii, asike imaduh boŋ ideh. Be nǝwai nǝb̃ilavi maii ehum nabǝko toṽuv vi mǝhat len nǝlon, tolav nǝmauran vi sutuai maii.” ");
INSERT INTO klv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Napǝhaṽut ikel maii ke, “Nasub̃, lav nǝwai ideh mai ginau bai, hǝn asike nǝb̃imaduh boŋ ideh, asike nǝb̃egǝm gegai hǝn navǝvautan tǝtas am.” ");
INSERT INTO klv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ikel mai alitenan ke, “Givan vakis asoam̃, mǝregǝmai.” ");
INSERT INTO klv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Apǝhaṽut isor vari ke, “Nǝsǝkad asoagw ideh.” AYesu ikel maii ke, “Nǝboŋ gotoke, ‘Nǝsǝkad asoagw ideh,’ gokitin; ");
INSERT INTO klv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","husur gulah mai asoam̃ erim tia, ale ahaṽut gotokade gagai savi asoam̃, gǝsǝlah maii. Nǝsa gotomadhakele ekitin.” ");
INSERT INTO klv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Apǝhaṽut ike, “Nasub̃, gaiug govi ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Atǝmanamit ta sutuai lulotu len naṽehuh egai, be gamit mǝttovi Ju, mǝtuke naut a Jerusalem ŋai evi naut nalotuan.” ");
INSERT INTO klv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","AYesu isor vari ke, “Litegai, gaiug gedǝlom nǝsa notokele. Nǝboŋ dereh tegǝmai hǝn ke asike evi natideh hǝn mǝtb̃ilotu hǝn aTata len naṽehuh egai o len naut a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamit a Samaria mǝtsalǝboi gai mǝttolotu hǝni; ginamito, namtulotu hǝn gai namttolǝboii, bathut nǝ-lav-kuvi-an dan nǝsaan egǝm len naJu gail. ");
INSERT INTO klv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Avil namityal dereh tegǝmai, egǝm tia, hǝn ke alat lotolotu kitin lǝb̃ilotu kitin hǝn aTata len nǝlolit kavkav, len nǝdaŋan seNunun, husur galit lovi nǝvanuan nalotuan aTata tokǝta doŋ galito. ");
INSERT INTO klv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","AGot savi nǝvanuan tokad niben gotolǝboi gǝb̃erisi, ao, ehum nanunun sua o nasuŋavŋavan gotodǝdas gǝb̃erisi be tovi nǝkadhumauran. Ale alat lotolotu hǝni limaslotu hǝn aGot hum tovi aGot kitin. Limaslotu kitin hǝn gai len nǝlolit kavkav, len nǝdaŋan seNunun.” ");
INSERT INTO klv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Apǝhaṽut ikel maii ke, “Nolǝboii ke aMessiah aGot totabtabuh lan dereh tegǝmai, aten lotokisi hǝn aKristo. Nǝboŋ b̃egǝmai dereh tikel ur natit p̃isi mai ginamito.” ");
INSERT INTO klv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","AYesu ikel maii ke, “Ginau en bogai notosor mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Len namityal enan, ahai susur san gail lotǝlmam, losǝhoṽut habat hǝn aYesu tosor mai apǝhaṽut sua, avil galit ideh saus aliten ke, “Golǝŋon nǝsa?” o saus aYesu ke, “Gusor mabe mai alitegai?” ");
INSERT INTO klv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Beti napǝhaṽut eriŋ nab̃iliwai san, etǝlmam vi lan nab̃iltivile ale ikel mai nǝvanuan gail ei ke, ");
INSERT INTO klv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mǝtegǝm ris avan sua tokel mai ginau hǝn natit p̃isi notogole. Mǝtunau ke aKristo, aGot totabtabuh lan a?” ");
INSERT INTO klv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ŋa nǝvanuan gail loriŋ nab̃iltivile, lotub̃at van hǝni. ");
INSERT INTO klv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Beti ahai susur gail lukele ke, “Hai p̃usan, gihan.” ");
INSERT INTO klv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Be ikel mai galit ke, “Nukad nǝhanian hagw gamit mǝtsalǝboii.” ");
INSERT INTO klv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Imaienan ahai susur gail lukel mai galit gabag ke, “Ase ilav nǝhanian maii?” ");
INSERT INTO klv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","AYesu ikel mai galit ke, “Nǝhanian hagw evi hǝn nǝb̃igol nalǝŋonian sitenan tosǝvat ginau hǝn nǝb̃igol vurvur nauman san. ");
INSERT INTO klv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mǝtukad nasoran sua toke, ‘Nahǝbati tivat beti nǝmatuan,’ be mǝtesǝŋav hǝn namǝtamito, mǝtekǝta ris nǝmarireu hǝn nawit tomasmas, toutaut hǝn nǝmatuan tia. ");
INSERT INTO klv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nǝvanuan tota kokotov nawit enan, tosǝgovi, gai etub̃at lav nap̃urp̃uran san, ale esǝsǝgov hǝn nawit m̃os nǝmauran vi sutuai. Igole hǝn gai tota kokotov nawit mai gai tomabule, arb̃ehǝhaṽur b̃onb̃on. ");
INSERT INTO klv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Husur nasoran egai ekitin toke, ‘Ikad avan sua tomabul, ikad togon tosǝgov tomatu.’ ");
INSERT INTO klv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nosǝvat gamit hǝn mǝtb̃esǝgov b̃onb̃on hǝn nǝsa mǝtsaum m̃osi. Galevis am loum idaŋ m̃osi. Be gamit mǝtohusur galito ale mǝtopul hǝn nǝmatuan.” ");
INSERT INTO klv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Alat a Samaria isob̃ur len nab̃iltivile a Sikar loriŋ nǝlolit len aYesu husur na-kel-uri-an sepǝhaṽut toke, “Ikel mai ginau hǝn natit p̃isi notogole.” ");
INSERT INTO klv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Beti nǝboŋ alat a Samaria lotogǝm hǝni, lousi hǝn b̃itoh mai galito, ale itoh ei vǝbar nǝmariboŋ eru. ");
INSERT INTO klv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ale husur nasoruan san, isob̃ur am lukad nadǝlomian. ");
INSERT INTO klv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Beti lukel mai napǝhaṽut ke, “Nadǝlomian sinamit len aYesu sahusur nǝsa gotokele am, bathut ginamit gabag namtosǝsǝloŋ hǝni, ale namtolǝboi sǝhoti ke ategai ilav kuv kitin hǝn navile a pan dan nǝsaan.” ");
INSERT INTO klv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nǝboŋ nǝmariboŋ toru togam gole, aYesu eriŋ naut enan, evi Kalili. ");
INSERT INTO klv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","AYesu m̃au ikel koti ke, “Len naut sihai kelkel ur ideh, lǝsaputsan atenan len nǝnauan salito.” ");
INSERT INTO klv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Imagenan, nǝboŋ aYesu tobar naut a Kalili, alat naut enan lohǝhaṽur hǝni husur loris natit p̃isi togole len nǝhanan a Jerusalem, husur galit am losuh len nǝhanan enan. ");
INSERT INTO klv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Imaienan, aYesu evi Kana a Kalili, naut togol nǝwai togǝm vi wain lan. Len naut enan ikad ab̃iltivanuan sua toum sekiŋ, anatun ulum̃an tomǝsah, topat len nǝmel len naut a Kapernaum. ");
INSERT INTO klv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nǝboŋ atenan tosǝsǝloŋ hǝn aYesu togǝm a Jutea vǝbar naut a Kalili, ivan hǝni. Eŋiri hǝn b̃egǝm vi lan naut a Kapernaum, gol anatun timaur husur pǝpadaŋ timat. ");
INSERT INTO klv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ŋa aYesu ikel maii ke, “Asike mǝtb̃eris namerikel gail o natit mǝtb̃imaŋmaŋ lan, asike mǝtukad nadǝlomian!” ");
INSERT INTO klv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ab̃iltivanuan toum sekiŋ eŋiri tǝtas ke, “Nasub̃, asike gǝb̃egǝm gagai, dereh anatugw timat!” ");
INSERT INTO klv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","AYesu isor vari ke, “Givan, anatum̃ imaur.” Edǝlom nǝsa aYesu tokel maii, ale ivan. ");
INSERT INTO klv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Len nǝyaran san vahim, naslev san gail lobubur maii, lukel uri ke, “Anatum̃ imaur tia!” ");
INSERT INTO klv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eus galit ke, “Elǝŋon ivoi len namityal sa?” Beti lusor vari ke, “Napudan san inoŋ nino len namityal tosua ut mǝdau.” ");
INSERT INTO klv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Beti atata inau sǝhoti ke, len namityal enan ŋai aYesu ike, “Anatum̃ imaur.” Ale gai mai galit p̃isi lotosuh lohoim san, logǝm vi vanuan nadǝlomian. ");
INSERT INTO klv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","AYesu evi Jutea tǝlmam vi Kalili vǝha-ru, ale egai evi namerikel na-vǝha-ru-an aYesu togole len naut a Kalili. ");
INSERT INTO klv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Husur nǝboŋ enan, aYesu evi mǝhat vi Jerusalem van hǝn nǝhanan sua seJu gail. ");
INSERT INTO klv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ale len naut a Jerusalem, pǝpadaŋ hǝn nametlǝkau lotokisi hǝn Nametlǝkau Nasipsip, ikad nab̃iltib̃urhuwai lilos tokad navǝrada torim todar visi, nahǝsan Petsata len nasoruan seIpru gail. ");
INSERT INTO klv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Nǝvanuan isob̃ur lotomǝsah lupat pipivǝrada galenan, ametb̃esw gail, galevis narielit togau mai galevis nahudhubelit tomat. ");
INSERT INTO klv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ikad esua topat ei tomǝsah len nasihau tovi 38 tia. ");
INSERT INTO klv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","AYesu eris atenan topat ei, elǝboii ke tomǝsah tobǝlav tia, ale eusi ke, “Golǝŋon ke gimaur a?” ");
INSERT INTO klv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aten tomǝsah isor vari ke, “Nasub̃, nǝsǝkad avan ideh tovi tarhǝt sagw hǝn nǝb̃evi lan nǝwai nǝboŋ toŋaluŋalw. Nǝboŋ notohisi hǝn nǝb̃evi pan lan, avan tile am akis ibar nǝwai a m̃o, beti ginau.” ");
INSERT INTO klv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","AYesu ikel mai ke, “Gile mǝhat, gebul hǝn nǝbateh sam̃, pati, ale yar van.” ");
INSERT INTO klv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vǝha-sua ŋai aten imaur. Ipat nǝbateh san ale iyaryar van, avil nǝboŋ enan evi nǝSappat. ");
INSERT INTO klv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Imaienan, alat lotoil a m̃o hǝn naJu gail lusor lan aten tomaur. Luke, “Damǝŋ nǝSappat bogai! Nǝboŋ gotopat nǝmel sam̃, gob̃ur kotov nalo tokai tas nauman!” ");
INSERT INTO klv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Isor var galit ke, “Avan togol notomaur ikel mai ginau ke, ‘Pat nǝmel sam̃, yar van.’” ");
INSERT INTO klv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Lousi ke, “Ase ikel mai gaiug hǝn gǝb̃igol maien hǝni?” ");
INSERT INTO klv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Avil aten tomaur salǝboii, husur aYesu ivan vǝmasig len naluṽoh len naut enan. ");
INSERT INTO klv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Len namityal tovan, aYesu isab̃ atenan len naholǝvat todar vis naim siGot ale ikel maii ke, “Geris, gagai gumaur, be sagigol nǝsaan am hǝn asike natideh tosa sǝhor ta m̃o b̃evisi hǝn gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Beti naulum̃an ia kel mai alat lotoil a m̃o hǝn naJu gail ke aYesu boh togole tomaur. ");
INSERT INTO klv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Imaienan lotub̃at mǝdas bun aYesu sil togol natgalenan len nǝSappat. ");
INSERT INTO klv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Be aYesu isor var galit ke, “ATǝmagw eumum van vǝbar gagai, ale ginau tu noum van.” ");
INSERT INTO klv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Imaienan, alat lotoil a m̃o hǝn naJu gail ludas p̃isal am hǝn lǝb̃igole b̃imat. Savi husur tob̃ur kotov nǝ-kai-tasi-an hǝn nǝSappat ŋai, be husur tokel ke aGot tovi aTǝman san, imaienan, ike gai gabag top̃itp̃itoṽ mai aGot. ");
INSERT INTO klv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ŋa aYesu isor var galit ke, “Kitin, nokitin mai gamit ke, aNatun aGot edǝdas b̃igol natideh sǝb̃on, elǝboi b̃igol ŋa nǝsa toris aTǝman togole. Husur nǝsa aTǝman togole, aNatun am igole. ");
INSERT INTO klv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Husur aTǝman elǝmas bun aNatun ale eṽusani hǝn natit p̃isi gai togole, ale dereh teṽusani hǝn natit gail lotosǝhor natgalenan hǝn mǝtb̃imaŋmaŋ lan. ");
INSERT INTO klv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hum ke aTǝman togol nǝvanuan lotomat lule mǝhat, tolav nǝmauran mai galito, aNatun am ilav nǝmauran mai avan ideh gai tolǝŋon b̃ilavi maii. ");
INSERT INTO klv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Husur aTata sǝsab̃ sǝhoti ke avan ideh b̃ipanis, aoa eriŋi len aNatun hǝn b̃isab̃ sǝhoti ke nǝvanuan gail lǝb̃ipanis, ");
INSERT INTO klv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","hǝn nǝvanuan p̃isi lǝb̃eputsan aNatun len nǝnauan salito hum lotoputsan aTata a mǝhat. Asike gǝb̃eputsan aNatun len nǝnauan sam̃, gǝsaputsan aTata tosǝvati len nǝnauan sam̃. ");
INSERT INTO klv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kitin, nokitin mai gamito, avan ideh tosǝsǝloŋ hǝn nasoruan sagw, tokad nadǝlomian len aGot tosǝvat ginau, gai ikad nǝmauran vi sutuai, asike eb̃is len nǝpanismen, be imakuv tia dan nǝmatan vi lan nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kitin nokitin mai gamito, len nǝboŋ b̃egǝmai, hun nǝboŋ togǝm tia, dereh alat lotomat lesǝsǝloŋ hǝn nadoldol siNatun aGot, ale alat lotosǝsǝloŋ hǝni, dereh likad nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Husur aTata tovi nǝkadun nǝmauran, gai eriŋi len aNatun am hǝn b̃evi nǝkadun nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ale eriŋ nǝdaŋan len navǝlan hǝn b̃ikot hǝn nǝvanuan gail, husur evi aNatun Nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Samtip̃aŋ len natgalenan, husur ikad nǝboŋ togǝmai hǝn alat lotomat len nab̃ur nǝmatan salito lǝb̃esǝsǝloŋ hǝn nadolon aNatun aGot, ");
INSERT INTO klv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ale dereh lile mǝhat dan nab̃ur nǝmatan. Alat lotogol tovoi, dereh lile mǝhat hǝn lǝb̃imaur tǝtas. Avil alat lotogol tosa, dereh lile mǝhat hǝn lǝb̃esǝsǝloŋ lǝboi nǝpanismen salito. ");
INSERT INTO klv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ginau nodǝdas nǝb̃igol natideh len ginau sǝb̃ogw. Nopǝpehun navoian dan nǝsaan hum aTata tokele. Ale napǝpehwan sagw inor husur nǝsagole husur nalǝŋonian sagw, be nugole husur nalǝŋonian sitenan tosǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","AYesu isor am mai naJu gail ke, “Ginau sǝb̃ogw ŋai nǝtasor lǝboi ginau, nasoruan sagw asike takitin. ");
INSERT INTO klv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Avil ikad atesual am tosor vi tarhǝt sagw, ale nolǝboii ke na-sor-lǝboii-an san husur ginau ekitin. ");
INSERT INTO klv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mǝtosǝvat galevis tia van hǝn aJon, ale gai ikel ur nakitinan. ");
INSERT INTO klv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Be nǝsariŋ gat nǝlogw len na-sor-vi-tarhǝte-an nǝvanuan tokele, ao, nusor husuri ŋai hǝn mǝtb̃imakuv dan nǝsaan samito. ");
INSERT INTO klv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","AJon ehum nam̃ial topaŋ, tom̃ial. Ale gamit mǝtulekis hǝn mǝtb̃itoh kǝkereh len nam̃ial san, hǝn mǝtb̃ehǝhaṽur. ");
INSERT INTO klv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","AJon ikel kot ginau, avil ikad na-kel-koti-an tosǝhor esan. Husur natit gail aTata tolav mai ginau hǝn nǝb̃igol p̃is gail, natgalenan notogole, loṽusan nakitinan husur ginau, ke aTata tosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ale aTata tosǝvat ginau, gai isor lǝboi ginau. Gamit mǝtsasǝsǝloŋ hǝn nadolon, mǝtsakǝta lǝboi gai tomabe. ");
INSERT INTO klv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ale nasoruan san sǝpat savoi len nǝlomito husur mǝtsadǝlom ginau, ginau boh, aTata tosǝvat ginau gǝmai. ");
INSERT INTO klv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mǝtudoŋdoŋ nǝmauran vi sutuai len natosian siGot bathut mǝtunau ke nǝmauran vi sutuai topat lan. Be natosian galenan lukel nakitinan husur ginau! ");
INSERT INTO klv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wake mǝtsalǝŋon mǝtb̃egǝm hǝn ginau hǝn mǝtb̃ikad nǝmauran enan. ");
INSERT INTO klv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nǝboŋ mǝttosal suh ginau, nǝ-sal-suhi-an samito savi natideh len ginau ");
INSERT INTO klv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","husur nolǝboi mǝtsalǝmas bun aGot len nǝlomito. ");
INSERT INTO klv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ginau nogǝm len nahǝsan aTǝmagw ale mǝtomǝtahun ginau, mǝtsahǝhaṽur hǝn ginau. Be naut kǝmas avan ideh am b̃egǝm len nahǝsan gabag ŋai, dereh mitidam̃ hǝni, mǝtehǝhaṽur hǝni. ");
INSERT INTO klv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imabe mǝtodǝdas mǝtb̃edǝlom ginau? Mǝtuke mitisal suh gamit gabag be mǝtomǝtahun nǝ-sal-suhi-an togǝm len gai tovi aGot sǝb̃on ŋai. ");
INSERT INTO klv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Samtinau ke evi ginau nǝb̃ikel kot nǝsaban samito van hǝn aTǝmagw len nakotan san. Ao, ikad atesua b̃igole, gai nǝlomit todaŋ lan, aMoses boh! Dereh gai tikel kot nǝsaban samito. ");
INSERT INTO klv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Avil mǝttadǝlom aMoses tia, mǝttadǝlom ginau tia bathut gai m̃au itos husur ginau. ");
INSERT INTO klv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Be asike mǝtb̃edǝlom nǝsa gai totosi husur ginau, mitimabe hǝn mǝtb̃edǝlom nǝsa notokele?” ");
INSERT INTO klv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Husur nǝboŋ galenan, aYesu evi Kalili, ilav tukot vi tarhǝt nab̃iltiwai lotokisi hǝn Nab̃iltiwai Kalili mai lotokisi hǝn a Tiperias am. ");
INSERT INTO klv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nab̃iltiluṽoh lohushusuri bathut ke lotokǝtkǝta ris namerikel gail gai togolgole len alat lotomǝsah. ");
INSERT INTO klv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ale aYesu etǝṽehuh vi lan naṽehuh, ebǝtah mai ahai susur san gail ei. ");
INSERT INTO klv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nǝboŋ hǝn nǝPasova tovi nǝhanan seJu gail, egǝm pǝpadaŋ. ");
INSERT INTO klv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nǝboŋ aYesu topair hǝn namǝtan, toris naluṽoh lotogǝm hǝni, eus aFilip ke, “Dateṽur nabǝta a be hǝn alateg lǝb̃ihani?” ");
INSERT INTO klv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","AYesu ep̃us kitev nǝnauan seFilip maienan hǝn b̃ebunus lǝboi aFilip, husur elǝboi tia nǝsa b̃igole ta bogai. ");
INSERT INTO klv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ale aFilip isor vari ke, “Nap̃urp̃uran hǝn nahǝbati tomǝlevtor salǝboi b̃eṽur nabǝta tonor hǝn galit ṽisusua b̃ihan kǝkereh hǝni.” ");
INSERT INTO klv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ale ahai susur sua san, aAdru, aṽan aSimon Pita isor mai aYesu ke, ");
INSERT INTO klv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ikad natǝtai sua gegai tokad natuhhanian tovi nabǝta nǝpali torim mai naieh toru. Be natuhhanian egai savi natideh len nab̃iltiluṽoh tomaiegai.” ");
INSERT INTO klv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Beti aYesu ikele ke, “Mitigol nǝvanuan gail lebǝtah.” Ŋa naulum̃an gail lotovi 5,000 lobǝtah len naut enan tobaŋ liol. ");
INSERT INTO klv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Beti aYesu ilav nabǝta, ale nǝboŋ tosipa vi tǝban aGot tonoŋ, epǝpehuni mai alat lotobǝtah. Igol tomaienan am hǝn naieh. Galit p̃isi luhan husur nalǝŋonian salito vǝhanukub. ");
INSERT INTO klv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nǝboŋ lotohanukub tonoŋ, aYesu ikel mai ahai susur san gail ke, “Mǝtesǝŋon nasughanian. Sa-ideh tesuh.” ");
INSERT INTO klv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Imagenan lusah tuan nasughanian hilat lotohan dani, losǝŋon nǝhad tovi 12 hǝn nasugut nabǝta nǝpali tosuh kǝmas! ");
INSERT INTO klv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nǝboŋ nǝvanuan gail lotoris namerikel aYesu togole, luke, “Ahai kelkel ur kitin bogai b̃egǝm vi lan navile a pan!” ");
INSERT INTO klv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bathut aYesu elǝboii len galito ke gag ŋai legǝm tah gati hǝn lǝb̃igol b̃egǝm vi kiŋ, gai ivan dan galito vi lan naṽehuh hǝn b̃itoh sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nǝboŋ namityal tomasur, ahai susur san gail lovi pan vi lan nab̃iltiwai. ");
INSERT INTO klv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Len namityal enan naut evisivis be aYesu satǝlmam van hǝn galit sal, ale lusah len nab̃ot, gam tukot vi Kapernaum. ");
INSERT INTO klv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sǝdareh nǝlan eṽuv habat gol ke nǝwai tokudkud van epus. ");
INSERT INTO klv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nǝboŋ lotovarus van hum ma tovi nakilomita torim, loris aYesu toyar len nap̃onit nǝwai, togǝm pǝpadaŋ hǝn nab̃ot, ale lomǝtahw. ");
INSERT INTO klv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Be aYesu ikai van hǝn galito ke, “Ginau bogai, samtemǝtahw!” ");
INSERT INTO klv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Imagenan lohǝhaṽur hǝn b̃isah len nab̃ot ale isah lan. Vǝha-sua ŋai nab̃ot ivahut len naut lotovi lan. ");
INSERT INTO klv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pelan han naluṽoh lotosuh tarhǝwai, ludoŋ aYesu, lunau sǝhoti ke ikad nab̃ot tosua ŋai ei. Lolǝboii ke aYesu sǝsah len nab̃ot mai ahai susur san gail, be luvan sǝb̃olit ŋai. ");
INSERT INTO klv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Beti nab̃ot galevis logǝm len naut a Tiperias, luvahut pǝpadaŋ hǝn naut Nasub̃ tosipa hǝn nabǝta lan, naut naluṽoh lotohan bǝta lan. ");
INSERT INTO klv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nǝboŋ naluṽoh lotoris lǝboii ke aYesu satoh ei, ahai susur san gail lǝsasuh, naluṽoh lusah len nab̃ot galenan, lovi Kapernaum hǝn lǝb̃idoŋ aYesu ei. ");
INSERT INTO klv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nǝboŋ nǝvanuan galenan lotosab̃ aYesu a Kapernaum, tarhǝwai, lousi ke, “Hai p̃usan, gubar naut egai ŋais?” ");
INSERT INTO klv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","AYesu isor var galit ke, “Kitin, nokitin mai gamit ke mǝtsadoŋ ginau husur mǝttoris lǝboi namerikel gail, be mǝtudoŋ ginau ŋai husur mǝtuhanukub hǝn nabǝta. ");
INSERT INTO klv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Samteum m̃os nǝhanian sǝpat sabǝlav, togǝm vi pahsago. Ao, mǝteum m̃os nǝhanian topat vi sutuai, nǝhanian hǝn nǝmauran vi sutuai aNatun Nǝvanuan dereh b̃eviol hǝni mai gamito. Husur aGot aTata itabtabuh len atenan hǝn b̃eum san m̃os b̃eviol hǝn nǝmauran enan.” ");
INSERT INTO klv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Imaienan lousi ke, “Datigol nǝsa gail hǝn datb̃igol nagolean aGot tolǝŋoni?” ");
INSERT INTO klv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","AYesu isor var galit ke, “AGot elǝŋon ke mitigol nategai ke: mǝteriŋ nǝlomit len atenan aGot tosǝvati.” ");
INSERT INTO klv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Imaienan lukel maii ke, “Gigol namerikel ideh hǝn namtb̃erisi hǝn namtb̃edǝlom gaiug. Dereh gigol nǝsa? ");
INSERT INTO klv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atǝmadat ta sutuai luhan nǝmanna len naut masmas hum aMoses totosi ke, ‘Eviol hǝn nabǝta togǝm len nǝmav mai galito hǝn lǝb̃ihani.’” ");
INSERT INTO klv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Beti aYesu ikel mai galit ke, “Kitin, nokitin mai gamit ke, savi aMoses toviol hǝn nabǝta togǝm len nǝmav mai gamito. Avil evi aTǝmagw toviol hǝn nabǝta kitin togǝm len nǝmav mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bathut nabǝta siGot evi atenan togǝm vi pan dan nǝmav, eviol hǝn nǝmauran mai nǝvanuan navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Imaienan lukel maii ke, “Nasub̃, geviol tabtab hǝn nabǝta enan mai ginamito.” ");
INSERT INTO klv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","AYesu ikel mai galit ke, “Ginau novi bǝta hǝn nǝmauran. Avan ideh b̃egǝm hǝn ginau, asike imalkǝkat. Ale avan ideh b̃eriŋ nǝlon len ginau, asike, asike imaduh boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nukel mai gamit ke, naut kǝmas mǝttoris ginau, mǝtsariŋ nǝlomit len ginau sal. ");
INSERT INTO klv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Avil alat aTǝmagw toviol hǝn galit mai ginau, dereh legǝm hǝn ginau. Ale avan ideh togǝm hǝn ginau asike nomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Husur nǝsagǝm len nǝmav hǝn nǝb̃igol nǝsa notolǝŋoni. Ao, nogǝm hǝn nǝb̃igol husur nalǝŋonian siGot tosǝvat ginau m̃osi. ");
INSERT INTO klv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ale nalǝŋonian san imaiegai ke: galit p̃isi gai toviol hǝn galito mai ginau hǝn lǝb̃evi esagw, salimasig, be len Nǝboŋ Namǝkot hǝn navile a pan dereh nigol lile mǝhat. ");
INSERT INTO klv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Husur nalǝŋonian seTǝmagw imaiegai ke: galit p̃isi lotoris aNatun, lotoriŋ nǝlolit lan, dereh likad nǝmauran vi sutuai, ale dereh nigol lile mǝhat len Nǝboŋ Namǝkot hǝn navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nǝboŋ lotosǝsǝloŋ hǝn natenan, naJu gail lukoblen husuri bathut toke, “Novi nabǝta togǝm len nǝmav,” ");
INSERT INTO klv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ale luke, “Ategai savi aYesu, anatun aJosef ŋa? Datolǝboi atǝman mai anan. Imabe toke togǝm len nǝmav?” ");
INSERT INTO klv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","AYesu isor var galit ke, “Samtikoblen mai gamit gabag. Mitinoŋ. ");
INSERT INTO klv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ikad nap̃isal tosua ŋai hǝn avan ideh b̃elǝboi b̃egǝm hǝn ginau. Nǝboŋ aTǝmagw tosǝvat ginau b̃eliv avan enan, elǝboi b̃egǝm hǝn ginau, ale dereh nigol tile mǝhat len Nǝboŋ Namǝkot hǝn navile a pan. ");
INSERT INTO klv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Len natosian sihai kelkel ur gail ike, ‘Ale aGot dereh tevi hai p̃usan salit p̃isi,’ ŋa nǝvanuan p̃isi lotosǝsǝloŋ husur aTata, lotosǝsǝloŋ lǝboi nǝsa tokele, galit logǝm hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","(Namilen sake avan ideh saris aTata. Atenan togǝm len aGot, atenan ŋai eris aTata.) ");
INSERT INTO klv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kitin, nokitin mai gamit ke, avan ideh toriŋ nǝlon len ginau, gai ikad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ginau novi nabǝta hǝn nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sutuai atǝmamit gail luhan nǝmanna len naut tob̃ǝb̃esw, be naut kǝmas natenan, lumat p̃isi. ");
INSERT INTO klv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Egai evi nabǝta togǝm len nǝmav hǝn avan ideh b̃ihani, asike imat. ");
INSERT INTO klv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ginau sǝb̃ogw ŋai novi nabǝta nǝmauran togǝm len nǝmav. Avan ideh b̃ihan nabǝta egai, dereh tikad nǝmauran vi sutuai. Husur nabǝta nǝb̃eviol hǝni evi nibegw; dereh neviol hǝni m̃os nǝmauran silat navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Beti naJu gail loṽitṽituh mai galit gabag, luke, “Ategai teviol mab hǝn niben mai gidato hǝn datb̃ihani?” ");
INSERT INTO klv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Imaienan aYesu ikel mai galit ke, “Kitin, nokitin mai gamit ke, asike mǝtb̃ihan niben aNatun Nǝvanuan, asike mǝtb̃emun nǝda han, mǝtukad nǝmauran kitin mabe? Mǝtsǝkade len gamit gabag. ");
INSERT INTO klv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Avan ideh tohanhan nibegw, tomunmun nǝda hagw, atenan ikad nǝmauran vi sutuai, ale len Nǝboŋ Namǝkot hǝn navile a pan dereh nigol tile mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Husur nibegw evi nǝhanian kitin, nǝda hagw evi nate namunian kitin. ");
INSERT INTO klv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Imaienan, avan ideh tohanhan nibegw, tomunmun nǝda hagw, atenan itoh tin len ginau ale ginau nutoh tin len gai. ");
INSERT INTO klv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ATǝmagw tovi nǝkadun nǝmauran esǝvat ginau, ale bathut aTǝmagw, ginau nutoh, nukad nǝmauran. Len naṽide tomaienan, avan ideh tohanhan ginau, bathut ginau, gai dereh titoh, tikad nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ginau novi nabǝta togǝm len nǝmav, be nabǝta egai sasum̃an nǝmanna atǝmamito ta sutuai lotohani. Luhan nǝmanna ale lumat. Avan ideh tohanhan nabǝta egai, dereh titoh, tikad nǝmauran vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","AYesu ikel natgalenan nǝboŋ top̃usan len naim nab̃onb̃onan a Kapernaum. ");
INSERT INTO klv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nǝboŋ ahai susur san gail lotosǝsǝloŋ hǝn natgalenan, luke, “Nap̃usanan enan idaŋ habat. Ase elǝboi b̃esǝsǝloŋ sǝhoti?” ");
INSERT INTO klv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","AYesu elǝboii len gai gabag ke ahai susur san gail lukoblen husur natenan, ale ikel mai galit ke, “Nateg emǝdas nadǝlomian samito a? ");
INSERT INTO klv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","B̃imagenan, imabe len gamito mǝtb̃eris aNatun Nǝvanuan b̃etǝlmam vi mǝhat? Mǝtedǝlomi beti a? ");
INSERT INTO klv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ANunun aGot ŋai elǝboi b̃eviol hǝn nǝmauran kitin mai nǝvanuan. Nǝdaŋan sinǝvanuan edǝdas b̃igol natideh. Nasoruan notokele mai gamito, evi soruan seNunun aGot toviol hǝn nǝmauran mai nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Avil gamit galevis mǝtsǝkad nadǝlomian len ginau.” (AYesu ekǝmaienan husur len natub̃atan elǝboi alat lotokad nadǝlomian lan, ale elǝboi nǝvanuan sua b̃eriŋi len navǝlan aenemi san gail.) ");
INSERT INTO klv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Beti aYesu ike, “Husur natenan nukel mai gamit ke, nǝvanuan salǝboi b̃egǝm hǝn ginau len gai sǝb̃on. ATata ŋai elǝboi b̃igol nǝvanuan b̃ikad nadǝlomian hǝn b̃egǝmai.” ");
INSERT INTO klv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Husur tokǝmaienan, ahai susur san isob̃ur lupair dani, lǝsahusuri am. ");
INSERT INTO klv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ŋa aYesu ipair van hǝn lotovi 12 ike, “Be gamit am mǝtuke mitivan a?” ");
INSERT INTO klv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ASimon Pita isor vari ke, “Nasub̃, namtivan hǝn ase? Gaiug sǝb̃om̃ ŋai gukad nasoruan toviol hǝn nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Namtoriŋ nǝlonamito len gaiug, namtolǝboii tia ke gaiug govi siGot sǝb̃on gotogǝm m̃osi.” ");
INSERT INTO klv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Beti aYesu ike, “Ganan! Ginau nulekis hǝn gamito mǝttovi 12, be gamit sua evi natǝmat.” ");
INSERT INTO klv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nǝboŋ tokǝmaienan, isor husur aJutas, anatun aSimon Iskariot, husur aJutas, esua len lotovi 12, dereh teriŋi len navǝlan aenemi san gail. ");
INSERT INTO klv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Husur nǝboŋ enan, aYesu iyaryar len naut a Kalili. Emǝtahun nǝyaran len naut a Jutea husur alat lotoil a m̃o hǝn naJu gail ludoŋdoŋi hǝn lǝb̃igol b̃imat. ");
INSERT INTO klv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ale nǝboŋ hǝn Nǝhanan hǝn Nǝpasvalǝval gail, egǝm pǝpadaŋ. Evi nǝhanan sua seJu gail. ");
INSERT INTO klv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Beti aṽan aYesu matmat gail lusor maii ke, “Geriŋ naut enan vi Jutea hǝn ahai susur sam̃ gail lǝb̃eris natit gotogol gail. ");
INSERT INTO klv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Avan ideh toke b̃etibau len nǝhon nǝvanuan gail sasusuan gai! Gǝb̃igol namerikel gail, gigol gail len nǝhon nǝvanuan p̃isi len navile a pan hǝn lǝb̃elǝboi gaiug!” ");
INSERT INTO klv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lokǝmaienan husur aṽan gail am lǝsǝkad nadǝlomian lan. ");
INSERT INTO klv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Imaienan aYesu ikel mai galit ke, “Namityal tonor hǝn ginau sagǝm sal. Be samito, namityal p̃isi inor ŋai. ");
INSERT INTO klv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nǝvanuan sinavile a pan gail lodǝdas lǝb̃emǝtahun bun gamito. Be ginau, lomǝtahun bun ginau husur nukel koti ke natit gail lotogole lusa vǝsa. ");
INSERT INTO klv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mǝtevi lan nǝhanan ea. Ginau asike novi lan Nǝhanan enan, husur namityal tonor hǝn ginau sagǝm sal.” ");
INSERT INTO klv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nǝboŋ tokǝmaienan tonoŋ, itoh a Kalili ŋai. ");
INSERT INTO klv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Be nǝboŋ aṽan aYesu gail lotovi mǝhat vi lan Nǝhanan tonoŋ, gai am evi mǝhat vi lan. Sǝyar len nǝhon nǝvanuan gail be esusuah. ");
INSERT INTO klv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Beti len Nǝhanan, alat lotoil a m̃o hǝn naJu gail, ludoŋdoŋi, lous kitevi ke, “Atenan itoh a be? Gai be?” ");
INSERT INTO klv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Len naluṽoh nǝvanuan isob̃ur lusor lahlah husuri. Galevis luke, “Evi naulum̃an sua tovoi masuṽ.” Galevis am luke, “Ao, egǝras nǝvanuan gail.” ");
INSERT INTO klv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Be sǝkad avan ideh tosor husuri len nǝhon nǝvanuan gail, husur lomǝtahw len naJu gail lotoil a m̃o. ");
INSERT INTO klv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Be nǝboŋ sua rivuh len nawik hǝn Nǝhanan, aYesu evi mǝhat vi lan naim siGot, ale etub̃at p̃usan. ");
INSERT INTO klv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Beti naJu gail lotoil a m̃o, lotosǝsǝloŋ hǝni, lup̃aŋ, luke, “Ategai elǝboi bun natosian siGot, be sǝkad avan ideh tokad namitisau top̃usan hǝni maii. Imabe?” ");
INSERT INTO klv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Imaienan aYesu isor var galit ke, “Nap̃usanan sagw savi esagw. Ao, atenan tosǝvat ginau evi nǝkadhut nap̃usanan sagw. ");
INSERT INTO klv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Avan ideh toke b̃igol nalǝŋonian siGot, dereh telǝboii ke nap̃usanan sagw egǝm len aGot o evi esagw sǝb̃ogw. ");
INSERT INTO klv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nǝvanuan tosor len nalǝboian san sǝb̃on, elǝŋon ke tipatpat gai mǝhat. Avil gai tolǝŋon ke teputsan nahǝsan atenan tosǝvati, gai ekitin, ale sǝkad nagǝgǝrasan lan. ");
INSERT INTO klv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Savi aMoses tolav nalo mai gamito a? Be gamit ideh sahusuri. Mǝtudas p̃isal hǝn mǝtb̃igol nǝb̃imat sil nǝsa?” ");
INSERT INTO klv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Naluṽoh lusor vari ke, “Gaiug gukad natǝmat! Ase idas p̃isal hǝn b̃igol gǝb̃imat?” ");
INSERT INTO klv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","AYesu ikel mai galit ke, “Nugol nauman sua len nǝSappat, nugol naulum̃an imaur, ale nǝvanuan p̃isi losǝhoṽut sil notogole len nǝSappat. ");
INSERT INTO klv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Be gamit am mǝtoum len nǝSappat nǝboŋ mǝttotiv dalus natǝtai ulum̃an husur nalo siMoses. (Be naṽide hǝn na-tiv-dalusi-an savi siMoses, evi setǝmamit ta sutuai, aApraham.) ");
INSERT INTO klv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mǝtotiv dalus natǝtai ulum̃an len nǝboŋ han, naut kǝmas tovi nǝSappat. Mǝtugole hǝn asike mǝtb̃eb̃ur kotov nalo siMoses, be evi nauman. Mǝtb̃imagenan, imabe mǝtutab̃ulol bulos ginau nǝboŋ notogol naulum̃an kavkav tomaur len nǝSappat? ");
INSERT INTO klv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sagenǝnoṽ hǝn nǝsa notogole mai na-kǝta-suluṽi-an mai nǝ-nau-suluṽi-an samit ŋai. Mitimasnǝnoṽ hǝni mai natit tonor, tokitin ŋai.” ");
INSERT INTO klv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Beti galit galevis lototoh len naut a Jerusalem lous galit gabag ke, “Savi atenan lotoke lǝb̃igole b̃imat a? ");
INSERT INTO klv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Be mǝteris! Gai boh tosorsor len nǝhon nǝvanuan gail. Lǝsakel natideh maii. Hum ma nǝvanuan na-il-a-m̃o-an gail lotolǝboi koti ke atenan evi aKristo, aGot totabtabuh lan a? ");
INSERT INTO klv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Avil datolǝboi naut atenan togǝm lan. Be nǝboŋ aKristo b̃egǝmai, asike ikad avan ideh b̃elǝboi naut togǝm lan.” ");
INSERT INTO klv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ŋa aYesu, top̃usan len naholǝvat todar vis naim siGot, ikai ke, “Mǝtunau ke mǝtolǝboi ginau a? Mǝtunau ke mǝtolǝboi naut notogǝm lan a? Savi len ginau gabag ŋai notogǝmai. Be atenan tosǝvat ginau, ekitin. Gamit mǝtsalǝboii, ");
INSERT INTO klv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","be ginau nolǝboii, husur nogǝm tǝban, gai esǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nǝboŋ lotosǝsǝloŋ hǝn natenan, alat lotoil a m̃o lohisi sob̃uer hǝn lǝb̃itah gati. Be avan ideh sǝbari husur namityal san sagǝm sal. ");
INSERT INTO klv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Avil isob̃ur len naluṽoh loriŋ nǝlolit lan. Luke, “Nǝboŋ aKristo b̃egǝmai, asike igol namerikel gail lotosǝhor natgalenan ategaii togole.” ");
INSERT INTO klv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nǝboŋ naFarisi gail lotosǝsǝloŋ hǝn natgalenan naluṽoh lotosor lahlah hǝni husur aYesu, galit mai ab̃iltihai tutumav gail losǝvat alat lotokǝtkǝta kǝkol hǝn naim siGot, hǝn lǝb̃itah gati. ");
INSERT INTO klv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ŋa aYesu ike, “Dereh nitoh kǝkereh mai gamit balai, beti netǝlmam van hǝn atenan tosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dereh mitidoŋ ginau, be asike mǝtusab̃ ginau, ale mǝtsalǝboi mǝtb̃egǝm vi lan naut nǝb̃evi lan.” ");
INSERT INTO klv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Beti alat lotoil a m̃o hǝn naJu gail, lukel mai galit gabag ke, “Ategai tiyar vi be hǝn asike datb̃isab̃i? Hum ma b̃ivan hǝn naJu gail lototoh len naut tiltile seuleKris hǝn b̃ep̃usan mai alat a Kris a? ");
INSERT INTO klv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nǝboŋ toke, ‘Dereh mitidoŋ ginau be asike mǝtusab̃ ginau,’ ale ‘Mǝtsalǝboi mǝtb̃egǝm hǝn naut nǝb̃evi lan,’ namilen evi nǝsa?” ");
INSERT INTO klv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Len nǝboŋ namǝkot len nawik hǝn Nǝhanan, len nǝmariboŋ totibau han, aYesu eil vi mǝhat, ikai ke, “Avan ideh b̃imaduh, tegǝm hǝn ginau! ");
INSERT INTO klv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Avan ideh toriŋ nǝlon len ginau, tegǝm, temun! Hum natosian siGot tokele ke, ‘Nǝwai nǝmauran dereh tisel dan nǝlon hum nawisel gail.’” ");
INSERT INTO klv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Nǝboŋ tokǝmaienan, isor husur aNunun aGot, alat lotoriŋ nǝlolit len aYesu dereh likade, be aGot saviol hǝni sal husur aGot saputsan aYesu sal hǝn nǝyalyalan san b̃ip̃arp̃ar.) ");
INSERT INTO klv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Galevis len naluṽoh lotosǝsǝloŋ hǝn nasoruan san, lusor tǝvah ke, “Ategai bogai ahai kelkel ur kitin.” ");
INSERT INTO klv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Galevis luke, “AKristo bogai, aGot totabtabuh lan.” Ris galevis am lotoke, “Eniŋan? AKristo asike egǝm a Kalili a? ");
INSERT INTO klv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Be natosian siGot ike aKristo dereh tegǝm len nǝpasusan siTevit ale lipasi len naut a Petlehem, navile matmat siTevit aKiŋ. Imaienan o sǝmaienan a?” ");
INSERT INTO klv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ŋa naluṽoh loṽitṽituh, lopǝpehw husur aYesu. ");
INSERT INTO klv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ale galevis luke litah gati, wake avan ideh sǝtah lan. ");
INSERT INTO klv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Alat lotokǝtkǝta kǝkol hǝn naim siGot lotǝlmam van hǝn ab̃iltihai tutumav mai naFarisi gail. Ale lous alatenan ke, “Imabe mǝtsǝtah gati gǝmai?” ");
INSERT INTO klv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Alatenan lusor var galit ke, “Aoa, namtsasǝsǝloŋ hǝn avan ideh sasor sum̃an atenan boŋ ideh.” ");
INSERT INTO klv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ŋa naFarisi gail lusor viles alatenan ke, “Imabe? Gai egǝras gamit am a? ");
INSERT INTO klv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mitinau nategai ke: len ginamit namttoil a m̃o mai ginamit namttovi Farisi, ikad ginamit ideh toriŋ nǝlon lan m̃au a? Eb̃uer kaskasi! ");
INSERT INTO klv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Naluṽoh loriŋ nǝlolit lan, be lǝsalǝboi natideh, lotǝtan hǝn nalo. Nasemalean tipat len galito!” ");
INSERT INTO klv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ikad naFarisi sua, nahǝsan aNikotemus, togǝm hol mai aYesu a m̃o, ale ike, ");
INSERT INTO klv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Asike datb̃ikot hǝn avan ideh hǝn datb̃isab̃ nǝsa gai togole, sanor len nalo sidato hǝn datb̃eriŋi hǝn b̃ipanis.” ");
INSERT INTO klv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","NaFarisi gail lusor vilesi ke, “Govi nauleut ta Kalili gototah mai atenan a? Gia ṽuruŋ kitevi len natosian siGot. Dereh gisab̃i ke ahai kelkel ur ideh sagǝm len naut a Kalili boŋ ideh!” ");
INSERT INTO klv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ale lopǝpehw, luvahim gail. ");
INSERT INTO klv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Be aYesu evi lan Naṽehuh Oliv. ");
INSERT INTO klv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ale nǝboŋ naut tolan evi lan naholǝvat todar vis naim siGot tǝtas. Sǝdareh nǝvanuan gail logǝm hǝni, ale ebǝtah, ep̃usan. ");
INSERT INTO klv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ahai p̃usan hǝn nalo mai naFarisi gail losǝhar apǝhaṽut sua lotosab̃i len naitian tob̃ur kotov nǝlahan. Lugol eil len nǝhon naluṽoh. ");
INSERT INTO klv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Lukel mai aYesu ke, “Hai p̃usan, alitegai, namtusab̃i len naitian tob̃ur kotov nǝlahan. ");
INSERT INTO klv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ale len nalo, aMoses ikel buni hǝn datb̃etubun alatpǝhaṽut lotosum̃an alitegai. Be gaiug, gukel nǝsa?” ");
INSERT INTO klv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Lokǝmaienan hǝn lǝb̃igol aYesu b̃ekǝkos len nasoruan san hǝn lǝb̃ikot hǝni.) Be aYesu ebǝtah, ib̃etb̃et, itos len tan hǝn nǝŋarhuvǝlan. ");
INSERT INTO klv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lous taltal hǝn b̃isor var galito, ale eil vi mǝhat, ike, “Gamit ideh topar saan, tilav nǝvat, tuṽi a m̃o.” ");
INSERT INTO klv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Beti ebǝtah tǝtas, ib̃etb̃et, tos len tan. ");
INSERT INTO klv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nǝboŋ lotosǝsǝloŋ hǝni, lotub̃at van, alat lotovi haṽut loil a m̃o. Ale aYesu itoh sǝb̃on mai alitenan. ");
INSERT INTO klv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Beti aYesu eil vi mǝhat, eusi ke, “Bareab, galito, lutoh a be? Sǝkad avan ideh toke gǝb̃ipanis a?” ");
INSERT INTO klv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ike, “Naut ido hǝn galito Nasub̃.” Ale aYesu ike, “Ginau am nǝsake gǝb̃ipanis. Givan ale gagai van sagigol nǝsaan am.” ");
INSERT INTO klv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","AYesu isor mai nǝvanuan gail tǝtas am, ike, “Ginau novi nam̃ial hǝn navile a pan; avan ideh tohusur ginau, asike, asike iyar len nǝmargobut, avil dereh tikad nam̃ial hǝn nǝmauran.” ");
INSERT INTO klv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ŋa naFarisi gail lusor tas nasoruan siYesu luke, “Gaiug gukel na-kel-koti-an husur gaiug gabag, be husur gaiug sǝb̃om̃ ŋai gotokele, na-kel-koti-an sam̃ savi natideh len nakotan, ehum sakitin.” ");
INSERT INTO klv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","AYesu isor var galit ke, “Naut kǝmas notokel na-kel-koti-an husur ginau gabag, na-kel-koti-an sagw ekitin, husur nolǝboi naut notogǝm lan mai naut notovi lan gagai. Be gamito, mǝtsalǝboi naut notogǝm lan, mǝtsalǝboi naut notovi lan. ");
INSERT INTO klv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mǝtonǝnoṽ husur nalǝboian sinǝvanuan ŋai, ginau nǝsanǝnoṽ hǝn avan ideh mai nǝsa nǝvanuan gail lotolǝboii. ");
INSERT INTO klv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nǝb̃enǝnoṽ, na-nǝnoṽ-hǝni-an sagw inor, husur savi ginau sǝb̃ogw notogole, be nugole mai atenan tosǝvat ginau, nonǝnoṽ husur nǝsa aTata tokele. ");
INSERT INTO klv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nalo samito ike, na-kel-koti-an sinǝvanuan eru arb̃ep̃itoṽ, nakotan isab̃i ke evi kitinan. ");
INSERT INTO klv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ale ikad eru artokel na-kel-koti-an husur ginau: esua, ginau notokel husur ginau gabag, togon, aTata tosǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Imaienan lotub̃at usi ke, “ATǝmam̃ gai be?” Isor var galit ke, “Husur ke mǝtsalǝboi ginau, mǝtsalǝboi aTǝmagw. Mǝttalǝboi ginau, mǝttalǝboi aTǝmagw am.” ");
INSERT INTO klv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","AYesu ekǝmaienan pǝpadaŋ hǝn nabokis hǝn nǝvat nǝboŋ top̃usan len naholǝvat todar vis naim siGot. Avan ideh sǝtah gati husur namityal san sagǝm sal. ");
INSERT INTO klv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Len namityal tile am, aYesu isor mai galito tǝtas, ike, “Gagai noriŋ gamito, nuvan, ale dereh mǝtekǝta kitev ginau van, ale mitimat len nǝsaan samito. Naut notovi lan, mǝtodǝdas mǝtb̃egǝm hǝni boŋ ideh.” ");
INSERT INTO klv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Imaienan naJu gail lotoil a m̃o lusor mai galit gabag ke, “Nǝboŋ ategai toke, ‘Naut notovi lan, mǝtodǝdas mǝtb̃egǝm hǝni boŋ ideh,’ namilen imabe? Dereh tia gol gai gabag timat a?” ");
INSERT INTO klv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ris aYesu toke, “Gamito, mǝtovi alat a pan, ginau novi aulemǝhat. Gamit hǝn navile eg a pan; ginau savi hǝn navile eg a pan. ");
INSERT INTO klv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Imaienan nuke dereh mitimat len nǝsaan samito. Husur asike mǝtb̃edǝlomi ke novi ginau notovi ginau, dereh mitimat len nǝsaan samito.” ");
INSERT INTO klv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ŋa lous taltal hǝni ke, “Be gaiug ase?” Ale aYesu isor var galit ke, “Sum̃an notokele a m̃o tia. ");
INSERT INTO klv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nukad natit isob̃ur hǝn nǝb̃ikele husur gamito, hǝn nǝb̃isab̃ sǝhoti hǝn mǝtb̃ipanis, be nǝboŋ notosor mai alat hǝn navile a pan, nosǝsǝloŋ hǝn atenan tosǝvat ginau husur gai ekitin, ale nukel ur nǝsa ŋai atenan tokele.” ");
INSERT INTO klv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Be lǝsalǝboi sal ke aYesu tosor husur aTǝman. ");
INSERT INTO klv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ŋa aYesu isor mai galit tǝtas am ke, “Nǝboŋ mǝtb̃evus aNatun Nǝvanuan vi mǝhat, dereh mǝtelǝboii ke novi ginau notovi ginau. Ale len ginau sǝb̃ogw nǝsagol natideh, avil nukel nǝsa ŋai aTǝmagw top̃usan hǝni mai ginau. ");
INSERT INTO klv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ale atenan tosǝvat ginau itoh mai ginau; sariŋ gab̃ulan ginau. Bathut nugol tabtab hǝn nǝsa gai tohǝhaṽur hǝni.” ");
INSERT INTO klv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nǝboŋ lotosǝsǝloŋ hǝn tokǝmaienan, nǝvanuan isob̃ur loriŋ nǝlolit lan. ");
INSERT INTO klv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Beti aYesu isor mai naJu gail lotoriŋ nǝlolit lan ke, “Mǝtb̃igol husur nap̃usanan sagw, mǝtovi ahai susur sagw kitin, ");
INSERT INTO klv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ale dereh mǝtelǝboi nakitinan. Ale nakitinan dereh tigol mitikad nǝmakuvan, asike mǝtovi slev am.” ");
INSERT INTO klv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lusor vari ke, “Namtovi nǝpasusan siApraham, namtsavi slev sivan ideh boŋ ideh. Imabe gotoke, ‘dereh mitikad nǝmakuvan, asike mǝtovi slev am?’” ");
INSERT INTO klv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","AYesu isor var galit ke, “Kitin, nokitin mai gamit ke, avan ideh togol nǝsaan evi slev sisaan. ");
INSERT INTO klv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Naslev savi nǝbathudud ideh simasta hǝn naim, naut kǝmas totoh mai galito. Avil anatun ulum̃an amasta evi bathudud sua vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imaienan, aNatun aGot b̃igol asike mǝtb̃evi slev am, dereh mitikad nǝmakuvan tokitin. ");
INSERT INTO klv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nolǝboii ke mǝtovi nǝpasusan siApraham gail, be mǝtoum kitev nap̃isal hǝn mǝtb̃igol nǝb̃imat husur nasoruan sagw sagol natideh len nǝlomito. ");
INSERT INTO klv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ginau nusor husur natit notoris aTata sagw togol gail. Be gamito mǝtugol nǝsa mǝttosǝsǝloŋ hǝn atǝmamit m̃au tokele.” ");
INSERT INTO klv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lusor tǝvah ke, “Atǝmanamito aApraham!” AYesu ikel mai galit ke, “Mǝttavi anatun aApraham gail, mǝttagol husur nǝsa aApraham togole. ");
INSERT INTO klv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nukel nakitinan tia notosǝsǝloŋ hǝn aGot tokele, be gagai mǝtudas p̃isal hǝn mǝtb̃igol nǝb̃imat. Apraham sagol natideh tomaienan. ");
INSERT INTO klv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gamit mǝtugol natit atǝmamito togol gail.” Beti lusor vari ke, “Namtsavi natǝtai nap̃isal. Namtukad aTǝmanamit esua ŋai, aGot.” ");
INSERT INTO klv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","AYesu ikel mai galit ke, “AGot tavi aTǝmamito, mǝttalǝmas bun ginau husur nogǝm tǝban aGot, nogǝm gegai. Savi len ginau ŋai notogǝmai, be gai esǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Imabe mǝtsalǝboi sǝhot nasoran sagw? Husur mǝtsalǝboi mǝtb̃esǝsǝloŋ husur nasoruan sagw. ");
INSERT INTO klv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Husur mǝtovi anatun atǝmamit tovi tǝmat. Mǝtuke mitigol husur nǝsa gai tolǝŋoni. Atenan igolgol nǝvanuan lumat len natub̃atan hǝn navile a pan van van sal. Gai emǝtahun nakitinan husur nakitinan eb̃uer lan. Nǝboŋ tosor libliboŋ evi nasoruan san matmat husur gai evi vanuan nalibliboŋan mai nǝkadun nalibliboŋan. ");
INSERT INTO klv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Imagenan, nǝboŋ notokel nakitinan, mǝtsadǝlom nǝsa notokele. ");
INSERT INTO klv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gamit ta be elǝboi b̃ikel vǝhoti ke notokad nǝsaan? Ale nǝb̃ikel nakitinan, imabe mǝtsadǝlom nǝsa notokele? ");
INSERT INTO klv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Avan tovi siGot esǝsǝloŋ sǝhot nasoruan san. Be gamito, mǝtsavi siGot. Husur enan mǝtsasǝsǝloŋ sǝhot nasoruan san.” ");
INSERT INTO klv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","NaJu gail lotosǝsǝloŋ hǝni lusor vari ke, “Namtukel sǝhot gaiug nǝboŋ namttoke gotovi auleSamaria gotovi ut kǝmas! Gaiug gukad natǝmat sua!” ");
INSERT INTO klv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ris aYesu toke, “Ao, nǝsǝkad natǝmat ideh. Avil noputsan nahǝsan aTǝmagw, noputsani len nǝnauan sagw. Be gamito, mǝtomǝdas nahǝsagw hum notovi ut kǝmas. ");
INSERT INTO klv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ginau nǝsadoŋ nǝyalyalan m̃os ginau gabag, be ikad atesua tolǝŋon ke nahǝsagw tiyalyal. Gai dereh tepǝpehun navoian dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kitin, nokitin mai gamit ke, avan ideh togol husur nǝsa notokele, asike imat vi sutuai.” ");
INSERT INTO klv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nǝboŋ lotosǝsǝloŋ hǝn natenan, naJu gail lusor tǝvah ke, “Gagai namtolǝboi buni ke gukad natǝmat sua. AApraham imat. Ahai kelkel ur gail tu lumat. Be naut kǝmas natenan, gaiug gukele ke, ‘Avan ideh togol husur nǝsa notokele, asike esǝsǝloŋ hǝn nabus nǝmatan vi sutuai.’ ");
INSERT INTO klv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gunau ke gotoyalyal sǝhor aApraham atǝmanamit tomat a? Mai ahai kelkel ur lotomat gail a? Gunau ke gotovi ase?” ");
INSERT INTO klv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","AYesu isor var galit ke, “Nǝtaputsan nahǝsagw gabag, nǝyalyalan enan asike tavi natideh. Be atenan toputsan ginau evi aTǝmagw, mǝttosor husuri ke, ‘Atenan evi aGot sinamit bolai.’ ");
INSERT INTO klv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Avil mǝtsalǝboii, be ginau nolǝboii. Nǝtakele ke nǝsalǝboii, nǝtavi nǝvanuan nalibliboŋan sum̃an gamito. Wake nolǝboi gai ale nugol husur nǝsa tokele. ");
INSERT INTO klv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atǝmamit aApraham ehǝhaṽur hǝn b̃ekǝta vi m̃o hǝn nǝboŋ sagw, erisi, ale ikemkem.” ");
INSERT INTO klv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Beti naJu gail luke, “Nǝdam̃ ham̃ sǝbar 50 sal. Goris mab hǝn aApraham?” ");
INSERT INTO klv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","AYesu isor var galit ke, “Kitin, nokitin mai gamit ke, a tahw hǝn aApraham tovisi, novi ginau notovi ginau.” ");
INSERT INTO klv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nǝboŋ tokǝmaienan, lotǝtariv vat gail hǝn lǝb̃etubuni, be aYesu esusuan gai dan galito, evivile dan naut enan todar vis naim siGot. ");
INSERT INTO klv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nǝboŋ aYesu toyar van eris naulum̃an sua namǝtan tob̃esw nǝboŋ lotopasi. ");
INSERT INTO klv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ahai susur siYesu lousi ke, “Hai p̃usan, nǝsaan sise igol namǝtan ategai artob̃esw nǝboŋ lotopasi? Esil nǝsaan setǝman mai sinan o esil esan sǝb̃on?” ");
INSERT INTO klv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","AYesu isor var galit ke, “Savi sil nǝsaan san o setǝman mai anan, avil evi metb̃esw hǝn nǝvanuan gail lǝb̃eris nǝdaŋan siGot b̃evisi len nǝmauran san. ");
INSERT INTO klv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nǝboŋ tovi nalennǝyal sal datimasgol nagolean siGot tosǝvat ginau. Dereh nalenmariug tegǝmai, gol ke avan ideh asike eum. ");
INSERT INTO klv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nǝboŋ nototoh len navile a pan sal, novi nam̃ial hǝn navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Beti aYesu ep̃ulai len tan, igol nǝtan evi b̃al hǝn nabusun, ale ikas namǝtan atenan artob̃esw hǝn nǝb̃al enan. ");
INSERT INTO klv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ale ikel maii ke, “Gia kǝkas nǝhom̃ len nab̃iltib̃urhuwai lotokisi hǝn Siloam.” (Nǝhes enan namilen “Sǝvati”). Ŋa aulum̃an ivan, ekǝkas nǝhon, totǝlmam, ekǝta. ");
INSERT INTO klv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Alat lototoh pǝpadaŋ hǝni, mai alat lotoris toŋirŋir nǝvanuan hǝn nǝvat a m̃o, luke, “Savi ategaii tobǝtah, usus nǝvat tabtab a?” ");
INSERT INTO klv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Galevis luke, “Gai bogai.” Galevis am luke, “Ao, be esum̃an atenan.” Ale aulum̃an enan ikel ur gai sǝb̃on ke, “Ginau ŋa bogai.” ");
INSERT INTO klv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Imaienan lousi ke, “Imabe? Nǝsa igol gokǝta?” ");
INSERT INTO klv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aulum̃an isor var galit ke, “Atenan lotokisi hǝn aYesu igol nǝb̃al, ale ikas namǝtagw hǝni. Ikel mai ginau ke, ‘Gevi Siloam, kǝkas nǝhom̃.’ Imaienan, nǝboŋ notovan, notokǝkasi, nokǝta.” ");
INSERT INTO klv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Beti lousi ke, “Atenan be?” Isor var galit ke, “Eniŋan.” ");
INSERT INTO klv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Nǝboŋ aYesu togol nǝb̃al ale togol aulum̃an tokǝta, nǝmariboŋ enan evi nǝSappat. Beti nǝvanuan gail losǝhar aulum̃an enan, tovi metb̃esw a m̃o, van hǝn naFarisi gail. ");
INSERT INTO klv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ŋa naFarisi gail am lous tǝtas hǝni, nǝsa tovisi hǝni hǝn tokǝta. Ikel mai galit ke, “Eriŋ nǝb̃al len namǝtagw ale nokǝkas kuvi, ale nokǝta.” ");
INSERT INTO klv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","NaFarisi galevis luke, “Ategaii, aYesu, sagǝm len aGot husur eum len nǝSappat.” Be galevis am luke, “B̃evi nǝvanuan nǝsaan, igol namerikel galenan mabe?” Na-sor-b̃alb̃al-an enan len nǝtarhǝt gǝlaru, igol galit lukad napǝpehwan. ");
INSERT INTO klv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Imagenan, tǝtas am lous aten tovi metb̃esw a m̃o ke, “Ategaii togol namǝtam̃ tokǝta, gusor husur mab hǝni?” Aulum̃an enan isor var galit ke, “Ahai kelkel ur sua bolai.” ");
INSERT INTO klv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nab̃iltiJu gail lǝsadǝlomi ke tovi metb̃esw a m̃o, ŋa lokis atǝman mai anan gǝmai. ");
INSERT INTO klv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ale lous gǝlaru ke, “Ategai evi anatumǝru a? Evi metb̃esw nǝboŋ mǝrtopasi a? B̃imaienan, ekǝta mabe gagai?” ");
INSERT INTO klv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Atǝman mai anan arusor var galit ke, “Namrolǝboi ategai, anatunamǝr bogai, ale nǝboŋ namrtopasi evi metb̃esw. ");
INSERT INTO klv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Namrsalǝboi nǝsa tovisi hǝni tokǝta gagai, namrsalǝboi ase tosǝŋav hǝn namǝtan. Be etibau tia, savi tǝtai am, elǝboi b̃isor husur gai gabag, mǝteusi hǝni bai.” ");
INSERT INTO klv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Arokǝmaienan husur aromǝtahw len nab̃iltiJu gail husur galit ludam̃ mai galit gabag ke, avan ideh tokel uri ke aYesu tovi aKristo, aGot totabtabuh lan, dereh lehut avan enan dan naim nab̃onb̃onan salito. ");
INSERT INTO klv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Husur enan aruke, “Etibau tia, mǝteus gai.” ");
INSERT INTO klv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Imaienan, lokis vǝha-ru hǝn atenan tovi metb̃esw a m̃o. Ale lukel maii ke, “Len nahǝsan aGot, namtukele hǝn gaiug, gikel nakitinan! Husur namtolǝboii ke aYesu evi nǝvanuan nǝsaan.” ");
INSERT INTO klv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Isor var galit ke, “B̃evi nǝvanuan nǝsaan, ginau nǝsalǝboii. Nolǝboi natesua ŋai. A m̃o namǝtagw ib̃esw, be gagai nokǝta.” ");
INSERT INTO klv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ŋa lousi ke, “Igol nǝsa hǝn gaiug? Igol namǝtam̃ arosǝŋav mabe?” ");
INSERT INTO klv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Isor var galit ke, “Nukel mai gamit tia be mǝtsasǝsǝloŋ. Mǝtuke nikel tǝtas hǝn mab hǝni am? Gamit am mǝtolǝŋon ke mǝtevi ahai susur san gail m̃au a?” ");
INSERT INTO klv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Beti losǝvar buni ale luke, “Evi gaiug gotovi ahai susur sitenan, be ginamito, namtovi ahai susur siMoses gail. ");
INSERT INTO klv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Namtolǝboii ke aGot isor mai aMoses, be atenan, aYesu, namtsalǝboi naut togǝm lan.” ");
INSERT INTO klv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ris aulum̃an enan tosor var galito, ike “Mǝtsalǝboi naut togǝm lan, be esǝŋav hǝn namǝtagw. Mǝtumabe? Nosǝhoṽut len gamito! ");
INSERT INTO klv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Datolǝboii ke aGot sasǝsǝloŋ hǝn nǝvanuan nǝsaan gail, be esǝsǝloŋ hǝn alat lotolotu van hǝni, alat lotogol nǝsa tolǝŋoni. ");
INSERT INTO klv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sutuai tia van vǝbar damǝŋai, avan ideh sasǝŋav hǝn namǝtan nǝvanuan ideh tovi metb̃esw len nǝpasian san. ");
INSERT INTO klv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Atenan asike b̃egǝm len aGot, mǝtunau ke elǝboi b̃igol natideh a? Ao, edǝdasi.” ");
INSERT INTO klv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lusor vari, luke, “Nǝboŋ lotopas gaiug, gopul hǝn nǝsaan tia, gaiug ase hǝn gǝb̃eṽusan ginamito?” Ale lubar hǝni dan naim nab̃onb̃onan, lukai hǝni. ");
INSERT INTO klv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nǝboŋ aYesu tosǝsǝloŋ hǝn lotobar hǝni vivile, isab̃ aulum̃an enan, ale eusi ke, “Goriŋ nǝlom̃ len aNatun Nǝvanuan m̃au a?” ");
INSERT INTO klv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aulum̃an isor vari, ike, “Nasub̃, ase ganan hǝn nǝb̃eriŋ nǝlogw lan?” ");
INSERT INTO klv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","AYesu ikel maii ke, “Gorisi tia. Atenan bogai tosor mai gaiug gagai, ganan.” ");
INSERT INTO klv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ŋa ike, “Noriŋ nǝlogw len gaiug, Nasub̃,” ale ilotu hǝni. ");
INSERT INTO klv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Beti aYesu ike, “Nogǝm len navile a pan m̃os napǝpehwan hǝn navoian dan nǝsaan, hǝn ametb̃esw gail lǝb̃ikad nakǝtaan, ale hǝn alat lotokǝta, lǝb̃egǝm vi metb̃esw len nǝlolito.” ");
INSERT INTO klv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","NaFarisi galevis lototah maii losǝsǝloŋ hǝn tokǝmaienan, ale lousi ke, “Gokǝmabe? Guke ginamit am namtovi metb̃esw a?” ");
INSERT INTO klv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","AYesu ikel mai galit ke, “Mǝttavi metb̃esw gail, asike mǝttanor hǝn nǝpanismen sil nǝsaan samito, be husur mǝtukele ke mǝtokǝta, mǝtunor hǝn nǝpanismen sil nǝsaan samit sal.” ");
INSERT INTO klv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","AYesu isor am, ike, “Kitin, nokitin mai gamit ke, avan ideh sab̃is len nabopita, be topǝlau sǝhor nǝhol nasipsip, evi nǝvanuan vǝnvǝnah, evi nǝvanuan toparparu vanuan m̃os navǝnohian! ");
INSERT INTO klv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Be nǝvanuan tokǝtkǝta kǝkol hǝn nabopita, esǝŋav hǝn nabopita m̃os nǝvanuan tokǝtkǝta tǝban nasipsip hǝn b̃eb̃is lan. Nasipsip gail losǝsǝloŋ lǝboi nadolon atenan tokǝtkǝta tǝban galito. Ale ekis nasipsip san sǝb̃on, ekis nahǝsalit ṽisusua ale esǝhar galit vivile. ");
INSERT INTO klv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nǝboŋ tosǝhar galit p̃isi vivile tonoŋ, iyar a m̃o ale nasipsip gail lohusuri bathut losǝsǝloŋ lǝboi nadolon. ");
INSERT INTO klv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Asike lohusur avan ideh tile, be dereh ligam dani, husur lǝsasǝsǝloŋ lǝboi nadolon atenan.” ");
INSERT INTO klv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","AYesu ikel nasoruan kǝta enan be nǝvanuan gail lǝsalǝboi nǝsa tokel mai galito. ");
INSERT INTO klv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Imaienan aYesu ikel tǝtas hǝni mai galit ke, “Kitin nokitin mai gamit ke, ginau novi bopita, hǝn nasipsip lǝb̃iyar tur lan. ");
INSERT INTO klv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Alat lotogǝm a m̃o len ginau lovi vanuan vǝnvǝnah, lovi vanuan lotoparparu vanuan m̃os navǝnohian; be nasipsip lǝsasǝsǝloŋ hǝn galito. ");
INSERT INTO klv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ginau novi bopita. Avan ideh b̃eb̃is tur len ginau, dereh tikad nǝ-lav-kuvi-an dan nǝsaan san. Len ginau dereh tegǝmai, tivan, tisab̃ nǝhanian tovoi marireu. ");
INSERT INTO klv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nǝvanuan vǝnvǝnah egǝm ŋai hǝn b̃evǝnah, b̃igol nasipsip lǝb̃imat, sah pǝpas gail. Ginau nogǝm hǝn nasipsip sagw lǝb̃ikad nǝmauran vi sutuai, nogǝm hǝn lǝb̃epul sǝsǝhov hǝni. ");
INSERT INTO klv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ginau sǝb̃ogw novi nǝvanuan nasipsip tovoi. Nǝvanuan nasipsip tovoi eutaut hǝn b̃imat m̃os nasipsip gail. ");
INSERT INTO klv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nǝvanuan nauman tokǝtkǝta tǝban nasipsip m̃os nap̃urp̃uran, savi nǝvanuan nasipsip tovi amahean nasipsip gail. Imaienan, nǝboŋ toris nalipah katkat togǝmai, eriŋ nasipsip, igam dan galito. Beti nalipah katkat ikat gat nasipsip sua, ale navǝshǝsipsip lugam pǝpehw. ");
INSERT INTO klv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nǝvanuan nauman igam dan nasipsip gail husur eum m̃os nap̃urp̃uran ŋai, savǝhvǝh nasipsip, len gai lǝsavi natideh. ");
INSERT INTO klv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ginau sǝb̃ogw novi vanuan nasipsip tovoi. Sum̃an notolǝboi aTǝmagw mai aTata tolǝboi ginau, nolǝboi nasipsip sagw gail, ale galito lolǝboi ginau. Ale noutaut hǝn nǝb̃imat m̃os galito. ");
INSERT INTO klv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ginau nukad nasipsip galevis tile lǝsavi len navǝshǝsipsip egai. Nimassǝhar galito hǝn lǝb̃evi lan navǝshǝsipsip sagw. Ale galit am dereh lesǝsǝloŋ sǝhot nadologw, ale lib̃on hǝn lǝb̃egǝm vi vǝshǝsipsip b̃esua ŋai tokad nǝvanuan nasipsip tosua. ");
INSERT INTO klv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ATata elǝmas bun ginau husur notoutaat hǝn nǝb̃imat, hǝn nǝb̃ikad tǝlmam hǝn nǝmauran sagw. ");
INSERT INTO klv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sǝkad avan ideh tolǝboi b̃ilav kuv nǝmauran sagw dan ginau, be ginau sǝb̃ogw noviol hǝni husur nalǝŋonian sagw ŋai. Ginau nukad nǝdaŋan hǝn na-il-a-m̃o-an. Ipat len navǝlagw hǝn nǝb̃eviol hǝn nǝmauran sagw, ipat len navǝlagw hǝn nǝb̃ilav tǝlmam hǝni. Natenan evi nǝsa aTǝmagw tokel buni hǝn nǝb̃igole.” ");
INSERT INTO klv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nǝboŋ tokǝmaienan tonoŋ, ikad napǝpehwan tǝtas am len naJu gail husur nasoruan san. ");
INSERT INTO klv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Isob̃ur len galito luke, “Gai ikad natǝmat sua, evinvinu, imab mǝtosǝsǝloŋ hǝni?” ");
INSERT INTO klv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Galevis am luke, “Avan ideh tokad natǝmat salǝboi b̃isor maienan. Natǝmat salǝboi b̃esǝŋav hǝn namǝtan ametb̃esw. Edǝdasi!” ");
INSERT INTO klv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Len nab̃iltivile Jerusalem, lukad Nǝhanan hǝn Na-sǝŋav-hǝni-an len nahǝbati naut susus. ");
INSERT INTO klv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ale aYesu itoh len naholǝvat todar vis naim siGot, iyar husur navǝrada siSolomon ei. ");
INSERT INTO klv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nab̃iltiJu gail ludar visi, lousi ke, “Gugol namtodǝdarŋab̃u maiegai vir ŋais? Gǝb̃evi aKristo, aGot totabtabuh lan, gikel koti mai ginamito.” ");
INSERT INTO klv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","AYesu isor var galit ke, “Nukel mai gamito tia wake mǝtsadǝlom ginau. Nǝsa notogole len nahǝsan aTǝmagw, natgalenan lukel kot ginau. ");
INSERT INTO klv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Be mǝtsadǝlom gail am, husur mǝtsavi ideh len nasipsip sagw. ");
INSERT INTO klv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nasipsip sagw gail losǝsǝloŋ sǝhot nadologw, ginau nolǝboi galito ale lohusur ginau. ");
INSERT INTO klv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noviol hǝn nǝmauran vi sutuai mai galito ale asike lumasig boŋ ideh. Avan ideh asike eliv kuv galit dan navǝlagw. ");
INSERT INTO klv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ATǝmagw toviol hǝn alaten mai ginau, aTǝmagw egaii iyalyal sǝhor natit p̃isi, ale avan ideh asike eliv kuv galito dan navǝlan. ");
INSERT INTO klv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ale ginau mai aTata namrosua ŋai.” ");
INSERT INTO klv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nab̃iltiJu gail lotǝtariv vat tǝtas hǝn lǝb̃etubuni. ");
INSERT INTO klv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","AYesu ikel mai galit ke, “Len nǝhomito nugol natit isob̃ur tovoi lotogǝm len aTata. Len natgalen notogole, mǝtuke mǝtetuṽ ginau sil ta be?” ");
INSERT INTO klv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","NaJu gail lusor vari ke, “Asike namtotuṽ gaiug sil natideh tovoi gotogole, be sil gotosor mǝdas nahǝsan aGot. Husur gaiug gotovi vanuan ŋai, gugolgol gaiug ke gotovi Got.” ");
INSERT INTO klv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","AYesu isor var galit ke, “Len natosian hǝn nalo samito, aGot isor. Ike, ‘Nukele ke mǝtovi “got” gail.’ ");
INSERT INTO klv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gamit mǝtolǝboii ke natosian siGot edǝdas b̃eb̃uer boŋ ideh. Mǝtolǝboii ke aGot tokis nǝvanuan galenan, napisulan san togǝm hǝn galito, ‘got gail.’ ");
INSERT INTO klv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ginau, aTata itabtabuh len ginau ale esǝvat ginau vi lan navile a pan. Imaienan, nǝboŋ notoke, ‘Novi aNatun aGot,’ imabe mǝttoke notosor mǝdas nahǝsan aGot? ");
INSERT INTO klv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Asike nǝb̃igol nǝsa aTata togole, samtedǝlom nǝsa notokele. ");
INSERT INTO klv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wake nǝb̃igol nǝsa togole, naut kǝmas mǝtsadǝlom nǝsa notokele, mitikad nadǝlomian len nǝsa notogole hǝn mǝtb̃elǝboi sǝhoti, hǝn mǝtb̃elǝboi tabtab hǝni ke, aTata itoh tin len ginau ale ginau nutoh tin len aTata.” ");
INSERT INTO klv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Husur tokǝmaienan, alat lotosǝsǝloŋ hǝni ludas p̃isal hǝn lǝb̃itah gati, be ivan dan galito. ");
INSERT INTO klv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nǝboŋ tovan, iloŋ tukot len Nawisel Jortan van hǝn naut aJon tobapbaptais lan a m̃o tia, ale itoh ei. ");
INSERT INTO klv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Beti nǝvanuan isob̃ur logǝm hǝni, luke, “AJon sagol namerikel ideh, be nǝboŋ tosor husur ategai, natit p̃isi tokele ekitin.” ");
INSERT INTO klv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ale tarhǝwisel Jortan ei, isob̃ur loriŋ nǝlolit len aYesu. ");
INSERT INTO klv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ikad atesua tomǝsah, nahǝsan a Lasarus. Itoh a Petani mai aṽavinen gǝlaru, aMeri mai aMarta. ");
INSERT INTO klv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Evi aMeri enan boh tob̃ir naoil pǝhas len Nasub̃, len narien gǝlaru, ale togargari hǝn navurun.) Am̃inen aMeri, aLasarus, emǝsah. ");
INSERT INTO klv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ŋa napǝhaṽut eru enan aropisul van hǝn aYesu ke, “Nasub̃, ategai gotolǝmas buni, emǝsah.” ");
INSERT INTO klv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nǝboŋ aYesu tosǝsǝloŋ hǝn napisulan enan ike, “Namǝsahan enan savi hǝn nǝmatan, ao evi m̃os nǝvanuan gail lǝb̃isal suh nǝyalyalan siGot, hǝn ke aNatun aGot b̃ikad nǝ-sal-suhi-an lan.” ");
INSERT INTO klv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Naut kǝmas aYesu tolǝmas bun aMarta, aMeri mai aLasarus, ");
INSERT INTO klv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","nǝboŋ tosǝsǝloŋ hǝn na-kel-uri-an enan, itoh len naut totohtoh lan hǝn nǝmariboŋ eru am. ");
INSERT INTO klv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Beti husur nǝboŋ toru enan, ikel mai ahai susur san gail ke, “Datevi Jutea tǝtas.” ");
INSERT INTO klv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ahai susur gail lusor vari ke, “Hai p̃usan, naJu gail lumadhadas p̃isal hǝn lǝb̃etubun gaiug, be golǝŋon gǝb̃etǝlmam tǝtas am a?” ");
INSERT INTO klv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","AYesu isor var galit ke, “Akis ikad nǝhaua tovi 12 len nalennǝyal. Avan ideh toyaryar len nalennǝyal sapes hab̃etw, husur ekǝta len nam̃ial hǝn navile eg a pan. ");
INSERT INTO klv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Avan ideh b̃iyaryar len mariug, dereh tipes hab̃etw husur sǝkad nam̃ial lan.” ");
INSERT INTO klv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Beti ikel mai galit ke, “Abubur sidato, aLasarus, ipatmari; be nia vǝŋoni.” ");
INSERT INTO klv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Imaienan, ahai susur gail lukel mai ke, “Nasub̃, gai b̃ipatmari len namǝsahan, dereh timaur dani.” ");
INSERT INTO klv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lunau ke aYesu tosor ŋai husur nǝpatmarian, ris aYesu tosor husur nǝmatan siLasarus. ");
INSERT INTO klv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Imaienan beti, aYesu ikel p̃arp̃ar hǝni mai galit ke, “ALasarus imat tia! ");
INSERT INTO klv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ŋa nunau gamito, ale nukemkem ke nǝsatoh ei, husur len natenan dereh mitikad nadǝlomian am len ginau. Ale datia ris aten beti.” ");
INSERT INTO klv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Imagenan, aTomas, namilen ke aMǝlav, ikel mai ahai susur galenan ke, “Gidato datitah mai aYesu, lǝb̃etubuni, letubun gidat maii.” ");
INSERT INTO klv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nǝboŋ aYesu togǝm pǝpadaŋ hǝn naut a Petani, lukel maii ke aLasarus topat ei len nab̃urhes hǝn nǝmariboŋ tovat tia. ");
INSERT INTO klv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(Ale navile a Petani ipat dan naut a Jerusalem len nakilomita totor ŋai, ");
INSERT INTO klv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ŋa naJu tosob̃ur logǝm hǝn aMarta mai aMeri hǝn lǝb̃igol nǝlolar b̃elǝŋon b̃ivoi am husur nǝmatan sem̃inelaru.) ");
INSERT INTO klv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Beti nǝboŋ aMarta tosǝsǝloŋ hǝni ke aYesu togǝm pǝpadaŋ, evivile hǝn b̃erisi, be aMeri salǝboii, ebǝtah lohoim. ");
INSERT INTO klv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ŋa aMarta ikel mai aYesu ke, “Nasub̃, gǝtatoh geg tia, am̃inegw asike tǝmat. ");
INSERT INTO klv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Be naut kǝmas, nolǝboii ke aGot dereh teviol hǝn natideh gǝb̃eusi hǝni mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","AYesu ikel maii ke, “Am̃inem̃ dereh tile mǝhat tǝtas.” ");
INSERT INTO klv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","AMarta isor vari ke, “Nolǝboii ke dereh tile mǝhat len na-le-mǝhat-an len Nǝboŋ Namǝkot hǝn navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","AYesu ikel maii ke, “Ginau novi na-le-mǝhat-an dan nǝmatan mai novi nǝmauran. Ginau nugol nǝvanuan lule mǝhat dan nǝmatan, ginau noviol hǝn nǝmauran mai galito. Avan ideh toriŋ nǝlon len ginau, dereh timaur, naut kǝmas b̃imat. ");
INSERT INTO klv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ale avan ideh totoh tin len ginau, toriŋ nǝlon len ginau, asike, asike imat vi sutuai. Godǝlomi a?” ");
INSERT INTO klv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Isor vari ke, “Evoi Nasub̃, nodǝlomi ke gotovi aKristo, aNatun aGot, gai tokel gati ke tegǝm vi lan navile a pan.” ");
INSERT INTO klv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nǝboŋ tokǝmaienan tonoŋ aMarta eriŋi, etǝlmam vahim. Ekis kuv aMeri, aṽan, isor sǝb̃on maii ike, “AHai p̃usan egǝmai, eus gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nǝboŋ aMeri tosǝsǝloŋ hǝn natenan, vǝha-sua ŋai ivan hǝni. ");
INSERT INTO klv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","AYesu sǝbar navile a Petani sal, be itoh len naut tobubur mai aMarta lan. ");
INSERT INTO klv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Alat a Jerusalem lototoh mai aMeri lohoim hǝn lǝb̃igol nǝlon b̃elǝŋon b̃ivoi am, loris tole mǝhat, tovan tutut. Lunau ke tovi lan nab̃urhes siLasarus hǝn b̃itaŋ ei, ale lohusuri. ");
INSERT INTO klv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nǝboŋ aMeri togǝm ris aYesu, iteh bathurien, ikel maii ke, “Nasub̃, gǝtatoh gegai, am̃inegw asike tǝmat.” ");
INSERT INTO klv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nǝboŋ aYesu toris aMeri totaŋ, eris naJu gail lototaŋ maii, ale nǝlon ipaŋpaŋ, nǝlon isa habat. ");
INSERT INTO klv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Eus galit ke, “Mǝtoriŋi a be?” Lusor vari ke, “Nasub̃, gǝm risi.” ");
INSERT INTO klv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Namǝtarur siYesu isel. ");
INSERT INTO klv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Beti naJu lotoil pǝpadaŋ luke, “Mǝteris! Gai elǝmas bun aLasarus vǝsa.” ");
INSERT INTO klv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Be galit galevis luke, “Ategai igol ametb̃esw tomaur. Imab satǝgau gat aLasarus dan nǝmatan?” ");
INSERT INTO klv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nǝboŋ aYesu tobar nab̃urhes, nǝlon isa habat tǝtas am. Nab̃urhes enan evi nab̃urhuvat sua tokad nab̃iltivat lotokǝkol gole hǝni. ");
INSERT INTO klv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","AYesu ikel mai galit ke, “Rusan nǝvat vi tarhǝte.” AMarta, aṽavinen aten tomat, ikel maii ke, “Nasub̃, gai ib̃o tia. Damǝŋai, nǝmariboŋ han ivat.” ");
INSERT INTO klv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","AYesu isor vari ke, “Nukel mai gaiug tia ke, gǝb̃eriŋ nǝlom̃ len ginau, dereh geris nǝyalyalan siGot.” ");
INSERT INTO klv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Imaienan lorusan nǝvat vi tarhǝte. Beti aYesu ekǝta vi mǝhat, ike, “Tata, sipa hǝn gotosǝsǝloŋ hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nolǝboii ke gotosǝsǝloŋ hǝn ginau akis, be nokǝmaienan m̃os alategai lotoil pǝpadaŋ, hǝn lǝb̃edǝlomi ke gotosǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Beti aYesu ikai habat ke, “Lasarus, gevivile!” ");
INSERT INTO klv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ale gai tomat evivile. Nǝkaliko ibaŋis narien mai navǝlan sal, nǝkaliko tile ibaŋis nǝhon. AYesu ikel mai galit ke, “Sah rub̃ati hǝn b̃ivan!” ");
INSERT INTO klv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Len alat lototah mai aMeri, isob̃ur loriŋ nǝlolit len aYesu husur loris nǝsa togole. ");
INSERT INTO klv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Be galevis luvan hǝn naFarisi gail, lukel ur nǝsa aYesu togole. ");
INSERT INTO klv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Beti ab̃iltihai tutumav gail mai naFarisi gail lokis nab̃onb̃onan hǝn nǝSanhitrin. Lousus galit gabag ke, “Datigol nǝsa? Ategai boh igol namerikel tosob̃ur. ");
INSERT INTO klv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Datb̃idam̃ hǝn b̃igol tomagenan van, nǝvanuan p̃isi dereh leriŋ nǝlolit lan, lehusuri hum akiŋ. Beti nasoltia ta Rom dereh legǝm mǝdas naut sidato mai lav nǝvanuan gail dan gidato.” ");
INSERT INTO klv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Beti galit sua, aKaiafas, tovi b̃iltihai tutumav len nasihau enan, ike, “Gamit mǝtsalǝboi natideh! ");
INSERT INTO klv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mǝtsǝnau sǝhoti ke, ivoi am hǝn gidat p̃isi ke, naulum̃an sua b̃imat m̃os nǝvanuan gail, sǝhor alat a Rom lǝb̃emǝdas gidat p̃isi dattovi Ju hǝn datb̃imasig.” ");
INSERT INTO klv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Nǝboŋ aKaiafas tokǝmaiean, sakel sǝb̃on hǝni, be aGot eriŋ nǝnauan sua len nǝnauan siKaiafas. Ale len namilen hum ab̃iltihai tutumav, epǝhav utaut hǝni ke, aYesu dereh timat m̃os alat lotovi Ju. ");
INSERT INTO klv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Be savi m̃os naJu gail ŋai, timat m̃os aGot b̃episan b̃onb̃on hǝn anatun gail p̃isi lotogam pǝpehw, siriv len naut gail len navile a pan.) ");
INSERT INTO klv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Imagenan, len nǝboŋ enan van, lusor utaut hǝn lǝb̃igol aYesu b̃imat. ");
INSERT INTO klv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Husur enan, aYesu sǝyaryar am len nǝhon alat a Jerusalem, be eriŋ naut enan, evi lan navile a Efraim topat pǝpadaŋ hǝn naut masmas tob̃ǝb̃esw, beti itoh ei mai ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nǝboŋ nǝPasova seJu gail togǝm pǝpadaŋ, nǝvanuan isob̃ur len naut p̃isi lotosuh dar vis naut a Jerusalem, lovi mǝhat vi Jerusalem vagol sǝb̃olit hǝn galito liveveu hum nalo tokele, utaut vir nǝhanan enan. ");
INSERT INTO klv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Lokǝtkǝta doŋ aYesu. Ale nǝboŋ lotoil len naut todar vis naim siGot lousus galit gabag ke, “Gunau ke nǝsa? Tegǝm hǝn nǝPasova o teb̃uer?” ");
INSERT INTO klv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Len nǝboŋ enan, ab̃iltihai tutumav gail mai naFarisi gail lukele hǝni ke avan ideh b̃elǝboi naut aYesu totoh lan, timaskel vǝhoti hǝn lǝb̃itah gati. ");
INSERT INTO klv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Len nǝmariboŋ tomǝlevtes sǝbar nǝPasova sal, aYesu ibar naut a Petani. Evi naut siLasarus, aten aYesu togol tole mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Loutaut hǝn nab̃iltihanian m̃osi. ALasarus mai galevis am lutah maii len natev, ale aMarta ipat nǝhanian mai galito. ");
INSERT INTO klv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Beti aMeri ilav nahudhulita hǝn nǝhai pǝhas naoil, nǝvat han totibau. Evǝhas narien aYesu hǝni ale igar kuvi dan narien gǝlaru hǝn navurun. Ale naim epul hǝn nǝb̃on naoil enan tosusau. ");
INSERT INTO klv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ikad ahai susur san sua, nahǝsan aJutas Iskariot, b̃eriŋ aYesu len navǝlan aenemi san gail. AJutas ike, ");
INSERT INTO klv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nǝvat hǝn nǝhai pǝhas egai etibau hun nap̃urp̃uran hǝn nasihau tosua! Imabe datsap̃ur hǝni, lav nǝvat han mai namǝsal gail?” ");
INSERT INTO klv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ekǝmaienan, be sǝnau namǝsal gail, husur evi vanuan vǝnvǝnah. Gai ekǝtkǝta tǝban nabokis nǝvat salito, be ilavlav kuvi m̃os gai gabag. ");
INSERT INTO klv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","AYesu isor vari ke, “Sagemǝdasi! Alitegai etǝgau gat nǝhai pǝhas egai vir nǝboŋ lǝb̃itavun ginau. ");
INSERT INTO klv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Akis namǝsal gail lutohtoh mai gamito, be ginau, asike nutoh mai gamit ebǝlav.” ");
INSERT INTO klv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nǝboŋ naJu gail lotosǝsǝloŋ hǝni ke aYesu totoh a Petani, nab̃iltiluṽoh logǝm hǝn lǝb̃erisi, be savi aYesu ŋai, luke leris aLasarus am, atenan aYesu togol tole mǝhat dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Imaienan, ab̃iltihai tutumav gail lusor utaut hǝn lǝb̃igol aLasarus am b̃imat, ");
INSERT INTO klv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","husur nǝvanuan isob̃ur lugam dan ab̃iltihai tutumav gail hǝn lǝb̃eriŋ nǝlolit len aYesu sil nǝsa tovisi hǝn aLasarus. ");
INSERT INTO klv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pelan han na-kel-uri-an ibar naut a Jerusalem ke aYesu satogǝmgǝmai. Nǝboŋ nab̃iltiluṽoh lotogǝm hǝn Nǝhanan nǝPasova lotosǝsǝloŋ hǝn na-kel-uri-an enan, ");
INSERT INTO klv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","lutariv nǝpashǝt nadet, luvan hǝn lǝb̃ebubur maii. Lukai habat ke, “Hosanna! Datisal suh aGot! Got tigol na-voi-buni-an van hǝn gai togǝm len nahǝsan Nasub̃ aGot. Got tigol na-voi-buni-an van hǝn nakiŋ naut a Israel.” ");
INSERT INTO klv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nǝboŋ aYesu tosab̃ natuhtoŋki, ebǝtah lan hum natosian siGot tokele ke, ");
INSERT INTO klv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nǝvanuan naut a Israel gail, samtemǝtahw! Mǝteris! Nakiŋ samit satogǝmai! Ebǝtah len natuhtoŋki!” ");
INSERT INTO klv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Len nǝboŋ enan ahai susur san gail lǝsalǝboi natgalen len natosian siGot. Be nǝboŋ aYesu tovi mǝhat vi lan namǝnas san, lunau tǝlmam hǝn nǝsa tovisi, ale lunau sǝhoti ke tovi nǝsarpohan hǝn nǝsa ahai kelkel ur sua totos gati.) ");
INSERT INTO klv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Nǝvanuan galenan loluṽluṽoh husur galit galevis lutoh mai aYesu nǝboŋ tokis aLasarus dan nab̃urhes hǝn b̃imaur dan nǝmatan. Ale galito, lukel ur nǝsa lotorisi mai alat lǝsarisi. Imaienan, isob̃ur lovivile hǝn lǝb̃ebubur mai aYesu, bathut losǝsǝloŋ husur namerikel enan todaŋ gai togole. ");
INSERT INTO klv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Imagenan, naFarisi gail lusor tǝvah mai galit gabag ke, “Datsǝkad nap̃isal ideh am. Mǝteris atenan, gai esǝhor gidat tia, navile a pan p̃isi lohusuri.” ");
INSERT INTO klv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Len alat lotovi Jerusalem hǝn lǝb̃ilotu len Nǝhanan nǝPasova, ikad auleKris galevis lotogǝmai. ");
INSERT INTO klv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Luvan hǝn aFilip ta Petsaita a Kalili, lousi ke, “Nasub̃, namtuke namteris aYesu bai.” ");
INSERT INTO klv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","AFilip ikel mai aAdru, ale aruvan vakel mai aYesu. ");
INSERT INTO klv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Beti aYesu isor var gǝlaru, ike, “Namityal hǝn aGot b̃evǝhot nǝyalyalan siNatun Nǝvanuan egǝm tia. ");
INSERT INTO klv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kitin, nokitin mai gamit ke, asike namisurhuwit b̃iteh hǝn b̃imat len tan, ipat sǝb̃on maien ŋai. Wake b̃iteh hǝn b̃imat len tan m̃au, dereh titov vi mǝhat, tiṽan masuṽ. ");
INSERT INTO klv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Alat lotolǝmas bun nǝmauran salito len navile eg a pan, dereh limasig vi sutuai. Avil alat lotolǝmas bun ginau sǝhor habat hǝn nǝmauran salito len navile eg a pan, dereh likad nǝmauran vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Avan ideh b̃ike b̃evi tarhǝt sagw hum nǝvanuan na-vi-tarhǝte-an, timashusur ginau, husur nǝvanuan na-vi-tarhǝte-an sagw timastoh mai ginau. Ale avan ideh b̃evi tarhǝt sagw, aTata dereh teputsani, tisal suhi. ");
INSERT INTO klv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Gagai nǝlogw etuhatuh masuṽ. Nekǝmabe beti? Dereh nike, ‘Tata gilav kuv ginau dan namityal egai, sanelǝŋon tisa vǝsa’? Ao asike nokǝmaienan husur nogǝm m̃osi. Nogǝmai hǝn nǝb̃elǝŋon b̃isa vǝsa! ");
INSERT INTO klv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata gigol nahǝsam̃ tiyalyal!” Beti nadoldol egǝm len nǝmav, ike, “Nugol iyalyal tia, ale dereh nigol tiyalyal tǝtas am.” ");
INSERT INTO klv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nǝboŋ naluṽoh lotosǝsǝloŋ hǝni, galevis luke nab̃iliurur tokurut, galevis am luke aŋel tosor maii. ");
INSERT INTO klv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Beti aYesu ike, “Nadoldol enan isor m̃os gamito, sasor m̃os ginau. ");
INSERT INTO klv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gagai evi namityal hǝn aGot b̃epǝpehun navoian dan nǝsaan len navile a pan. Gagai evi namityal hǝn aGot b̃ehut atenan toil a m̃o len navile eg a pan, tovi tǝmat. ");
INSERT INTO klv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ale ginau, nǝboŋ mǝtb̃ipat ginau vi mǝhat dan nǝtan, dereh neliv nǝvanuan p̃isi gǝm hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ekǝmaienan hǝn b̃igol naṽide hǝn nǝmatan san b̃imasil ke dereh timat len nǝhai balbal.) ");
INSERT INTO klv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Naluṽoh lous aYesu ke, “Imabe gotoke aNatun Nǝvanuan dereh timat magenan? Namtunau ke natosian siGot toke aKristo, aGot totabtabuh lan dereh titoh vi sutuai. Imagenan, aNatun Nǝvanuan egai gotosor husuri, ase ganan?” ");
INSERT INTO klv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","AYesu isor var galit ke, “Nam̃ial dereh tem̃ial len gamito tebǝlav kǝkereh am. Nǝboŋ nam̃ial b̃em̃ial sal, mitiyar lan hǝn asike nǝmargobut b̃ikabut gol gamito. Mǝtb̃iyar len nǝmargobut, asike mǝtolǝboi naut mǝtb̃evi lan. ");
INSERT INTO klv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nǝboŋ mǝttokad nam̃ial sal, mǝteriŋ nǝlomit lan, hǝn mǝtb̃egǝm vi anatun nam̃ial.” Nǝboŋ aYesu tokǝmaienan tonoŋ, evi tut, esusuan gai dan galito. ");
INSERT INTO klv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Naut kǝmas togol namerikel tosob̃ur len nǝhon nǝvanuan gail, lǝsariŋ nǝlolit lan. ");
INSERT INTO klv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Imaienan, nasoruan sihai kelkel ur aIsaiah isarpoh toke, “Nasub̃ aGot, ase edǝlom na-kel-uri-an sinamito? Nǝdaŋan sam̃, gaiug goṽusani van hǝn ase hǝn b̃eris lǝboii?” ");
INSERT INTO klv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Husur natenan lǝsalǝboi lǝb̃ikad nadǝlomian sum̃an nǝsa aGot tokele len nabuŋon aIsaiah totos tǝtas hǝni ke, ");
INSERT INTO klv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nugol namǝtalit ib̃esw nugol nǝkadulit iṽonṽon, imagenan, namǝtalit lodǝdas lǝb̃ekǝta lǝboi nǝsa notogole nǝlolit lodǝdas lǝb̃elǝboi sǝhot nǝsa notokele ale lodǝdas lǝb̃ipair van hǝn ginau hǝn nǝb̃igol lǝb̃imaur.” ");
INSERT INTO klv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah ekǝmaienan husur toris nǝyalyalan seKristo a m̃o tia, ale isor husuri. ");
INSERT INTO klv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Avil len alat lotoil a m̃o, isob̃ur loriŋ nǝlolit len aYesu. Be husur lotolǝmas nǝ-sal-suhi-an sinǝvanuan gail sǝhor nǝ-sal-suhi-an siGot, lǝsakel uri ke lotokad nadǝlomian lan bathut lomǝtahw ke naFarisi gail lǝb̃ikai tas galito hǝn asike lǝb̃ilotu len naim nab̃onb̃onan salito. ");
INSERT INTO klv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Beti aYesu ikai habat van hǝn naluṽoh ke, “Avan ideh b̃eriŋ nǝlon len ginau, gai eriŋ nǝlon kitin len aGot tosǝvat ginau gǝmai. ");
INSERT INTO klv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ale avan ideh tokǝta ris ginau, ekǝta ris atenan tosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nogǝm len navile a pan sum̃an nam̃ial hǝn ke avan ideh b̃eriŋ nǝlon len ginau asike itoh len nǝmargobut am. ");
INSERT INTO klv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Avan ideh b̃esǝsǝloŋ hǝn nasoruan sagw be sagol husuri, ginau nǝsǝsab̃ sǝhoti ke timaspanis, husur nǝsagǝm hǝn nǝb̃isab̃ sǝhoti ke navile a pan timaspanis, ao, nogǝm hǝn nǝb̃ilav kuv navile a pan dan nǝpanismen sil nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Avan ideh topair dan ginau mai nasoruan sagw, len Nǝboŋ Namǝkot hǝn navile a pan, len nǝhon aGot nasoruan sagw dereh tisab̃ sǝhoti ke avan enan timaspanis. ");
INSERT INTO klv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bathut ginau nǝsasor len nǝdaŋan hǝn na-il-a-m̃o-an sagw. Avil nusor sitenan tosǝvat ginau, aTata. Gai ikele hǝn ginau hǝn nǝsa nǝb̃imaskele nǝboŋ nǝb̃isor. ");
INSERT INTO klv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ale nolǝboii ke nǝsa aTata tokel buni, evi nǝkadun nǝmauran vi sutuai; imaienan, nukel nǝsa aTata tokel mai ginau hǝn nǝb̃ikele.” ");
INSERT INTO klv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","NǝPasova tipat pelan, ale aYesu elǝboii ke namityal togǝm hǝn b̃eriŋ navile a pan, hǝn b̃ivan hǝn aTata. Elǝmas bun alat lotohusuri len navile a pan, ale gagai eṽusan p̃arp̃ar hǝn na-lǝmas-buni-an san kavkav tǝban galito. ");
INSERT INTO klv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nǝboŋ lotohanhan ut mǝdau, natǝmat esǝhar aJutas anatun aSimon Iskariot tia, hǝn aJutas b̃eriŋ aYesu len navǝlan aenemi san gail. ");
INSERT INTO klv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","AYesu elǝboii ke aTata toriŋ natit p̃isi len navǝlan, ale elǝboii am ke togǝm len aGot, mai dereh tetǝlmam van hǝni. ");
INSERT INTO klv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ŋa ile mǝhat dan nǝhanan, ikol nahurabat san dani, ale ilav nǝtaol, epitavisi. ");
INSERT INTO klv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Beti eb̃ir nǝwai len nabesin, etub̃at kǝkas narien ahai susur gail, ale igar gail hǝn nǝtaol topitavisi. ");
INSERT INTO klv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nǝboŋ tobar aSimon Pita, aPita ike, “Nasub̃, gekǝkas nariegw a? Imabe?” ");
INSERT INTO klv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","AYesu isor vari ke, “Gagai gǝsalǝboi sǝhot nǝsa notogole, be boŋ ideh dereh gelǝboii.” ");
INSERT INTO klv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","APita ikel maii ke, “Asike gokǝkas nariegw boŋ ideh.” AYesu isor vari ke, “Asike nǝb̃ekǝkas nariem̃, darepǝpehw. Gǝsavi ahai susur sagw am.” ");
INSERT INTO klv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ASimon Pita isor tǝvah ke, “B̃imaienan, Nasub̃, sagekǝkas nariegw ŋai be gekǝkas navǝlagw mai nǝkadugw am.” ");
INSERT INTO klv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","AYesu ikel maii ke, “Avan tolilos tia iveveu, inor hǝn b̃ekǝkas narien ŋai hǝn b̃iveveu kavkav. Gamit mǝtuveveu, avil savi gamit p̃isi.” ");
INSERT INTO klv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","AYesu ekǝmaienan husur elǝboi ase b̃eriŋi len navǝlan aenemi san gail. Husur enan ike, “Savi gamit p̃isi mǝttoveveu.” ");
INSERT INTO klv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nǝboŋ tokǝkas narielit tonoŋ, esun tǝlmam hǝn nahurabat san, ale ipat tarhǝgarin tǝtas. Ikel mai galit ke, “Mǝtolǝboi nǝsa notomadhagole m̃os gamito? ");
INSERT INTO klv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mǝtokis ginau hǝn ‘Hai p̃usan’ mai ‘Nasub̃’ ale inor hǝn mǝtb̃igole husur ginau boh numaienan. ");
INSERT INTO klv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Imagenan, ginau notovi ahai p̃usan mai Nasub̃ notoil a m̃o hǝn gamito, bathut notokǝkas nariemito sum̃an naslev, gamit gabag mitimassum̃an naslev hǝn mǝtb̃evi tarhǝt samito, kǝkas nariemito. ");
INSERT INTO klv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ginau noṽusan naṽide tonor hǝn mǝtb̃igol tǝtoṽ hǝni. Natgalen notogole hǝn gamito, mitimasgol husuri. ");
INSERT INTO klv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kitin nokitin mai gamit ke, naslev satibau sǝhor amasta san, mai ahai pispisul satibau sǝhor gai tosǝvati. ");
INSERT INTO klv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mǝtolǝboi natgalen tia, ale mitigole! Mǝtb̃igol natgalenan, aGot tivoi hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nǝsasor husur gamit p̃isi. Nolǝboi bun gamit ṽisusua notolekis hǝn gamito. Avil natosian siGot timassarpoh. Ike, ‘Nǝvanuan namrtohan katǝp̃ol hǝn nabǝta, ipair dan ginau, evi enemi sagw.’ ");
INSERT INTO klv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gagai nukel nategai mai gamit hǝn ke nǝboŋ b̃evisi, dereh mǝtedǝlomi ke ginau bogai notovi ginau hum notokele tia. ");
INSERT INTO klv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kitin notokitin mai gamit ke, avan ideh tohǝhaṽur hǝn nǝvanuan notosǝvati, ehǝhaṽur hǝn ginau, ale avan ideh tohǝhaṽur hǝn ginau ehǝhaṽur hǝn gai tosǝvat ginau.” ");
INSERT INTO klv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nǝboŋ aYesu tokǝmaienan tonoŋ, elǝŋon isa vǝsa hǝni, nǝlon etuhatuh masuṽ ale isor tǝvah, ike, “Kitin, notokitin mai gamit ke gamit sua dereh teriŋ ginau len navǝlan aenemi sagw gail.” ");
INSERT INTO klv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ahai susur gail lǝsǝnau lǝboi ase tosor husuri, gol ke lobunbunus galit gabag ŋai. ");
INSERT INTO klv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Galit sua, aYesu tolǝmas buni, ipat tarhǝgarin tǝban aYesu. ");
INSERT INTO klv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Imaienan, aSimon Pita eŋit nǝhon van hǝn aten topat tǝban aYesu hǝn b̃eus aYesu ke, tosor husur ase. ");
INSERT INTO klv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Beti atenan esiŋasiŋ len nǝmabun aYesu, eusi ke, “Nasub̃, ase ganan?” ");
INSERT INTO klv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","AYesu isor vari ke, “Ateg boh nǝb̃etutur hǝn natuhbǝta len nasiloh hǝn nasup̃ hǝn nǝb̃ilavi maii, gai bogai.” Ale nǝboŋ aYesu totutur hǝn nabǝta, ilavi mai aJutas anatun aSimon Iskariot. ");
INSERT INTO klv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nǝboŋ aJutas tolav natuhbǝta enan tonoŋ, vǝha-sua ŋai aSetan eb̃is lan. Imaienan aYesu ikel maii ke, “Saṽsaṽut hǝn gǝb̃igol nǝsa gǝb̃igole.” ");
INSERT INTO klv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Galit lotopat hǝn nǝtarhǝgarilito tǝban natev lǝsalǝboi nǝsa aYesu tosor maii aJutas m̃osi. ");
INSERT INTO klv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bathut aJutas tokǝtkǝta tǝban nǝvat salito, galit galevis lunau ke aYesu tokel maii ke teṽur natit gail m̃os nǝPasova pelan o tilav natideh mai namǝsal gail. ");
INSERT INTO klv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ale nǝboŋ aJutas tohan natuhbǝta tonoŋ, vǝha-sua ŋai ivan. Evi nalenmariug. ");
INSERT INTO klv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nǝboŋ aJutas tovan, aYesu ike, “Gagai aNatun Nǝvanuan etub̃at b̃is len nǝyalyalan san, ale dereh aGot tikad nǝyalyalan len nǝsa b̃evisi hǝn ginau, aNatun Nǝvanuan. ");
INSERT INTO klv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","AGot b̃ikad nǝyalyalan len aNatun Nǝvanuan, dereh len gai gabag, aGot tilav nǝyalyalan mai aNatun Nǝvanuan, ale tilav tutut hǝni maii. ");
INSERT INTO klv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anatugw gail, dereh nitoh kǝkereh mai gamit sal a tahw hǝn nǝb̃ivan. Beti, naut kǝmas mǝtb̃idoŋ ginau, be len naut nǝb̃evi lan, asike gogǝmai, hum notokele tia mai alat lotoil a m̃o hǝn naJu gail. ");
INSERT INTO klv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nuke nikel nakelean veveu todaŋ mai gamit ke: Mǝtelǝmlǝmas bun gamit gabag! Sum̃an ŋai notolǝmas bun gamito, mǝtelǝmlǝmas bun gamit gabag. ");
INSERT INTO klv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mǝtb̃elǝmlǝmas bun gamit gabag, len naṽide tomaienan, nǝvanuan p̃isi dereh lelǝboi sǝhoti ke, mǝttovi ahai susur sagw gail.” ");
INSERT INTO klv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ASimon Pita eusi ke, “Nasub̃, gevi be?” Ale aYesu isor vari ke, “Naut nǝb̃evi lan, gaiug godǝdas gǝb̃ehusur ginau vi lan. Be dereh gehusur ginau balai.” ");
INSERT INTO klv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Beti aPita eusi ke, “Nasub̃, husur nǝsa nǝsalǝboi nǝb̃ehusur gaiug gagai ŋai? Noutaut hǝn nǝb̃imat m̃os gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","AYesu isor vari ke, “Goutaut hǝn gǝb̃imat m̃os ginau a? Ao! Kitin, nokitin mai gaiug, pelan dudulan dereh gikel vǝha-tor hǝni ke gǝsalǝboi ginau, beti natoulum̃an tekǝkǝraiko.” ");
INSERT INTO klv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","AYesu isor am ke, “Sa-nǝlomit tetuhatuh. Mǝtoriŋ nǝlomit len aGot tia, mǝteriŋ nǝlomit len ginau am. ");
INSERT INTO klv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lohoim seTǝmagw ikad narum̃ tosob̃ur, ale nuvan hǝn nǝb̃eutaut hǝn naut samit ei. Asike tǝmaienan, nǝtakel koti mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nǝboŋ nǝb̃eutaut hǝn naut samito b̃inoŋ, dereh netǝlmam, sǝhar gamit hǝn mǝtb̃egǝm toh mai ginau, hǝn mǝtb̃itoh tin mai ginau len naut nototohtoh lan. ");
INSERT INTO klv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ale mǝtolǝboi nap̃isal van hǝn naut nǝb̃evi lan.” ");
INSERT INTO klv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ATomas ikel maii ke, “Nasub̃, namtsalǝboi naut gǝb̃evi lan, namtelǝboi mab hǝn nap̃isal?” ");
INSERT INTO klv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","AYesu isor vari ke, “Ginau novi p̃isal, novi kitinan, novi mauran. Avan ideh salǝboi b̃egǝm hǝn aTata len nap̃isal ideh am, ginau sǝb̃ogw ŋai nap̃isal. ");
INSERT INTO klv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mǝttalǝboi kitin hǝn ginau, mǝttalǝboi aTǝmagw am. Ale gag van mǝtolǝboi gai, mǝtorisi tia.” ");
INSERT INTO klv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","AFilip ike, “Nasub̃, ṽusan aTata hǝn ginamito. Enan ŋai namttolǝŋoni.” ");
INSERT INTO klv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","AYesu isor vari ke, “Ginau nutah mai gamit ebǝlav, be Filip, gǝsalǝboi ginau sal a? Avan ideh toris ginau eris aTata. Imab gotoke, ‘Ṽusan aTata hǝn ginamito’? ");
INSERT INTO klv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ginau mai aTata namrosua, ale aTata mai ginau namrosua ŋai. Gǝsadǝlomi a? Nasoruan notokel mai gamito, nǝsakele len ginau sǝb̃ogw. Ao! Evi aTata totoh tin len ginau togol nauman san. ");
INSERT INTO klv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mǝtedǝlom nǝsa notokele nǝboŋ notoke ginau mai aTata namrosua, ale aTata mai ginau namrosua ŋai. Be asike mǝtb̃edǝlomi, mǝtedǝlom nǝsa notokele bathut namerikel gail mǝttoris notogole. ");
INSERT INTO klv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kitin notokitin mai gamit ke, avan ideh tokad nadǝlomian len ginau dereh tigol nǝsa top̃itoṽ hǝn nǝsa notogole. Evoi, dereh tigol natit lǝb̃esǝhor nǝsa notogole husur nuvan hǝn aTata. ");
INSERT INTO klv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ale natideh mǝtb̃eusi len nahǝsagw, dereh nigole hǝn nǝb̃eṽusan nǝyalyalan siTata. Ale len aNatun, nǝvanuan gail dereh lisal suh nǝyalyalan san. ");
INSERT INTO klv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Evoi, mǝtb̃eus natideh len nahǝsagw, dereh nigole!” ");
INSERT INTO klv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","AYesu isor am ke, “Mǝtb̃elǝmas bun ginau dereh mitigol husur nǝsa notokele. ");
INSERT INTO klv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ale dereh neus aTata, ale teviol hǝn a-Vi-tarhǝte-an ideh am mai gamito hǝn b̃itoh mai gamito van vi sutuai. ");
INSERT INTO klv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Evi aNunun nakitinan, navile a pan lǝsalǝboi lǝb̃ikade bathut lǝsakǝta risi, lǝsakǝta lǝboii. Be gamit mǝtolǝboii tia husur gagai itah mai gamito, ale dereh titoh tin len gamito. ");
INSERT INTO klv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nǝboŋ nǝb̃ivan asike noriŋ gab̃ulan gamit hǝn mǝtb̃itoh sǝb̃omito sum̃an mǝttovi milesw, dereh netǝlmam gǝm hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Asike idareh nǝvanuan navile a pan asike loris ginau am. Be nǝboŋ nǝb̃imaur tǝlmam, dereh gamit mǝteris ginau tǝtas. Bathut nǝb̃ikad nǝmauran tǝtas, gamit am dereh mitikad nǝmauran. ");
INSERT INTO klv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Len nǝboŋ enan dereh mǝtelǝboii ke nototoh len aTǝmagw ale mǝttotoh len ginau ale nototoh len gamito. ");
INSERT INTO klv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Avan ideh togol husur nakelean sagw todaŋ gail, gai elǝmas bun ginau. Ale gai tolǝmas bun ginau, aTǝmagw dereh telǝmas buni, ale ginau dereh nelǝmas bun gai, nevǝhot ginau maii hǝn b̃elǝboi bun ginau.” ");
INSERT INTO klv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ale aJutas, savi aJutas Iskariot be aJutas togon, ike, “Nasub̃, husur nǝsa gǝb̃evǝhot gaiug mai ginamit ŋai hǝn namtb̃elǝboi bun gaiug, be savi hǝn navile a pan kavkav a?” ");
INSERT INTO klv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","AYesu isor vari, ike, “Avan ideh b̃elǝmas bun ginau, dereh tigol nǝsa notokele, ale aTǝmagw telǝmas buni. Beti ginamǝru dereh namregǝm, gol naim sinamǝr maii. ");
INSERT INTO klv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Avan ideh na-lǝmas-buni-an hǝn ginau tob̃uer lan, gai asike igol nǝsa notokele. (Be natsua, nasoruan mǝttosǝsǝloŋ hǝn notokele, savi esagw sǝb̃ogw, be evi seTǝmagw tosǝvat ginau.) ");
INSERT INTO klv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nukel natgalenan gagai, ale gagai nutohtoh mai gamit sal. ");
INSERT INTO klv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Be a-Vi-tarhǝte-an tovi aNunun aGot, gai aTǝmagw b̃esǝvati len nahǝsagw, gai dereh teṽusan gamit hǝn natit p̃isi, ale tigol mitinau tǝlmam hǝn natit p̃isi notokel mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Natǝm̃at, noriŋi len nǝlomito, natǝm̃at sagw, nulavi mai gamito. Natǝm̃at notoviol hǝni sasum̃an natǝm̃at navile a pan toviol hǝni. Imaienan, sa-nǝlomit tetuhatuh, samtemǝtahw. ");
INSERT INTO klv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mitinau tǝlmam hǝn nǝsa notokele nǝboŋ notoke nivan bai, ale dereh netǝlmam gǝm hǝn gamit tǝtas. Mǝttalǝmas bun ginau, mǝttahǝhaṽur husur nuvan hǝn aTata, husur aTata etibau sǝhor ginau. ");
INSERT INTO klv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gagai nukel natgalen mai gamito, a tahw hǝn lǝb̃evisi, hǝn ke nǝboŋ lǝb̃evisi, dereh mitikad nadǝlomian am len ginau. ");
INSERT INTO klv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Asike nusor masuṽ am mai gamito, husur ategai toil a m̃o hǝn navile a pan satogǝmai. Gai sǝkad nǝdaŋan hǝn b̃igol natideh hǝn ginau, namityal sagw egǝm tia. ");
INSERT INTO klv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Be alat navile a pan limaslǝboi sǝhoti ke notolǝmas bun aTata, ale notogol nǝsa aTata tokele ŋai. “Ale, mitile mǝhat, dativan.” ");
INSERT INTO klv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","AYesu ib̃ol p̃usan, ike, “Ginau novi nǝbathuhau nakrep tin. ATǝmagw evi nǝvanuan tokǝtkǝta tǝban nǝhol nakrep. ");
INSERT INTO klv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ita kukuv nǝpashǝhau p̃isi len ginau lǝsǝṽan, ale eṽisṽis nǝpashǝhau p̃isi lotoṽan, hǝn lǝb̃iṽan masuṽ am. ");
INSERT INTO klv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamit mǝtuveveu tia bathut nasoruan notokel mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mititoh tin len ginau, ale dereh nitoh tin len gamito. Nǝpashǝhau salǝboi b̃iṽan len gai sǝb̃on. Nǝpashǝhau elǝboi b̃iṽan ŋai len nǝbathuhau. Gamit mǝtumaienan. Mǝtsalǝboi mǝtb̃iṽan len gamit sǝb̃omito, mǝtolǝboi mǝtb̃iṽan ŋai len ginau. ");
INSERT INTO klv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ginau novi nǝbathuhau nakrep tin, gamit mǝttovi nǝpashǝhau. Avan ideh totoh tin len ginau ale ginau nototoh tin lan, gai iṽan masuṽ. Husur ginau nǝb̃eb̃uer, mǝtsalǝboi mǝtb̃igol natideh. ");
INSERT INTO klv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Avil avan ideh satoh tin len ginau ehum nǝpashǝhau sǝṽan, nǝvanuan nǝhol tota kuvi, bulani hǝn b̃imasmas. Beti nǝvanuan nauman gail lusah tuan nǝpashǝhau lotomagenan, bar hǝn gail len nǝhab hǝn lǝb̃ipaŋ. ");
INSERT INTO klv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mǝtb̃itoh tin len ginau, ale nasoruan sagw gail lǝb̃ipat tin len gamito, natideh mǝttolǝŋoni, mǝteusi ale aGot dereh tigole m̃os gamito. ");
INSERT INTO klv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nǝboŋ mǝttoṽan masuṽ, mǝtovi hai susur sagw kitin. Len natenan mǝtusal suh nǝyalyalan seTǝmagw len nǝhon nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sum̃an aTǝmagw tolǝmas buni ginau, ginau am, len naṽide tomaienan, nolǝmas bun gamito. Mititoh tin len na-lǝmas-buni-an sagw. ");
INSERT INTO klv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mǝtb̃igol nǝsa notokele hǝn gamito, dereh mititoh tin len na-lǝmas-buni-an sagw, sum̃an ŋai notogol nǝsa aTǝmagw tokel buni, ale nototoh tin len na-lǝmas-buni-an san. ");
INSERT INTO klv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nukel natgalenan mai gamito hǝn nakemkeman sagw b̃ipat len gamito, ale hǝn nakemkeman samito b̃epul sǝsǝhov. ");
INSERT INTO klv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nakelean sagw todaŋ imaiegai ke: mǝtelǝmlǝmas bun gamit gabag sum̃an ŋai notolǝmas bun gamito! ");
INSERT INTO klv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sǝkad na-lǝmas-buni-an ideh tosǝhor na-lǝmas-buni-an sinǝvanuan tomat m̃os abubur san gail. ");
INSERT INTO klv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Abubur sagw gail lumaiegai: gamit mǝtb̃igol nǝsa notokele todaŋ, mǝtovi abubur sagw gail. ");
INSERT INTO klv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nǝsakis gamit hǝn naslev gail am, husur naslev gail lǝsalǝboi nǝsa amasta salit togole. Avil nokis gamit hǝn abubur sagw gail, husur nugol mǝtolǝboi tia natit p̃isi aTata tokel mai ginau. ");
INSERT INTO klv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gamit mǝtsalekis hǝn ginau, avil ginau nulekis hǝn gamito. Nutabtabuh len gamit hǝn mǝtb̃iṽan, ṽan hǝn naṽit lotopat tin; hǝn ke natideh mǝtb̃eusi hǝn aTata len nahǝsagw, dereh teviol hǝni mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nategai evi nakelean sagw todaŋ: mǝtelǝmlǝmas bun gamit gabag!” ");
INSERT INTO klv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","AYesu isor am mai ahai susur san gail ke, “Alat navile a pan lǝb̃emǝtahun bun gamito, mitinau ginau, galit lomǝtahun bun ginau a m̃o. ");
INSERT INTO klv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mǝttavi sinavile a pan, alat navile a pan lǝtalǝmas bun gamit hum salit gabag. Avil gamit mǝtsavi sinavile a pan. Ginau nulekis hǝn gamito dan navile a pan; husur enan lomǝtahun bun gamito. ");
INSERT INTO klv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mitinau tǝlmam hǝn nasoruan notokel mai gamit tia ke, ‘Naslev satibau sǝhor amasta san.’ Imaienan, lǝb̃emǝdas bun ginau notovi masta samito, dereh lemǝdas gamit am. Lǝb̃igol husur nǝsa notokele, dereh ligol husur nasoruan samit am. ");
INSERT INTO klv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Be dereh ligol natgalen p̃isi hǝn gamito sil nahǝsagw, husur lǝsalǝboi aTǝmagw tosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Asike nǝtagǝm sor mai galito, lǝtǝmabe? Tǝmaienan, asike lǝtanor hǝn nǝpanismen hǝn nǝsaan salito. Wake nogǝm sor mai galito, gol lǝsǝkad na-tǝtas-gole-an ideh hǝn nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Avan ideh tomǝtahun bun ginau, emǝtahun bun aTǝmagw am. ");
INSERT INTO klv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ginau nugol namerikel avan ideh am salǝboi b̃igol gail. Asike nǝtagol namerikel gail len nǝholito, lǝtǝmabe? Tǝmaienan, asike lǝtanor hǝn nǝpanismen hǝn nǝsaan salito. Be naut kǝmas lotoris namerikel galenan, lomǝtahun bun ginau mai aTǝmagw am. ");
INSERT INTO klv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Be natgalenan lovisi hǝn na-tos-gati-an sua len nalo salito b̃isarpoh. Ike, ‘Lomǝtahun bun ginau sil naut kǝmas ŋai.’ ");
INSERT INTO klv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Dereh nesǝvat a-Vi-tarhǝte-an, tovi aNunun nakitinan, van hǝn gamito. Dereh tegǝm len aTata van hǝn gamito, ale tikel nakitinan husur ginau. ");
INSERT INTO klv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ale gamit am mitikel nakitinan husur ginau, husur mǝtutah mai ginau len natub̃atan hǝn nap̃usanan sagw. ");
INSERT INTO klv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nukel natgalen mai gamito, hǝn asike mǝtb̃iteh len nǝsaan. ");
INSERT INTO klv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dereh lehut gamit dan galito len naim nab̃onb̃onan. Ale ikad nǝboŋ b̃egǝmai hǝn alat lǝb̃iṽabun gamito linau ke, len nǝsa lotogole loum m̃os aGot. ");
INSERT INTO klv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dereh ligol natgalen maienan bathut lǝsalǝboi aTata, lǝsalǝboi ginau boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nokǝmaienan gagai hǝn ke, nǝboŋ natgalenan lǝb̃evisi, dereh mitinau sǝhoti ke notokel nalǝlǝgauan mai gamito. “Nǝsakel natgalenan mai gamit a m̃o husur nutoh sal mai gamito, ale luke lemǝdas ginau savi gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Avil gagai nuvan hǝn atenan tosǝvat ginau, be gamit ideh saus ginau, ‘Gevi be?’ ");
INSERT INTO klv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ale husur nǝsa notokele, nǝlomit gail lop̃ul hǝn nalolosaan. ");
INSERT INTO klv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Be nukel nakitinan mai gamito. Ivoi am hǝn gamito ke nivan. Nǝb̃itoh, a-Vi-tarhǝte-an asike egǝm hǝn gamito. Be nǝb̃ivan, dereh nesǝvati gǝm hǝn gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ale nǝboŋ a-Vi-tarhǝte-an b̃egǝmai dereh tikel vǝhot nǝ-nau-suluṽi-an silat navile a pan husur nǝsaan, nanoran mai nǝpanismen b̃egǝmai. Dereh tigole hǝn nahurulit b̃isa. ");
INSERT INTO klv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lunau suluṽ nǝsaan salito ke tovoi, husur lǝsariŋ nǝlolit len ginau. ");
INSERT INTO klv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Lunau suluṽ nanoran ke sanor, husur ginau nuvan hǝn aTata, ale asike mǝtolǝboi mǝtb̃eris ginau am. ");
INSERT INTO klv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Lunau suluṽ nǝpanismen ke asike egǝmai, be aGot eriŋi tia ke atenan toil a m̃o hǝn navile eg a pan tovi aSetan, timaspanis. ");
INSERT INTO klv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nukad isob̃ur sal hǝn notoke nǝb̃ikel mai gamito, be gagai esǝhor natideh mǝttolǝboi mǝtb̃idaŋ b̃uri. ");
INSERT INTO klv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Be nǝboŋ aNunun nakitinan b̃egǝmai, dereh tigol nap̃isal hǝn nǝlomit b̃elǝboi nakitinan p̃isi. Asike isor len gai sǝb̃on be nǝsa tosǝsǝloŋ hǝn notokel maii, dereh tikele. Dereh tikel ur natit gail lǝb̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Atenan dereh tisal suh nǝyalyalan sagw husur tilav nǝsa notolav maii ale tikel uri mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Natit p̃isi aTata tokade lovi esagw. Husur enan nuke, ‘ANunun nakitinan dereh tilav nǝsa notolav maii ale tikel uri mai gamito.’” ");
INSERT INTO klv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ale aYesu ike, “Husur namityal b̃ekǝkereh, asike mǝtoris ginau am; ale husur namityal b̃ekǝkereh am, dereh mǝteris tas ginau.” ");
INSERT INTO klv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Beti ahai susur san gail lousus galito gabag ke, “Namilen nǝsa nǝboŋ toke, ‘Husur namityal b̃ekǝkereh, asike mǝtoris ginau am; ale husur namityal b̃ekǝkereh am, dereh mǝteris tas ginau?’ Ale nǝboŋ toke, ‘Nuvan hǝn aTata,’ namilen imabe?” ");
INSERT INTO klv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lukel tasi ke, “Ikel nǝsa nǝboŋ toke, ‘Namityal b̃ekǝkereh?’ Datsalǝboi nǝsa tokele!” ");
INSERT INTO klv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","AYesu elǝboi nǝsa lotoke lǝb̃eusi hǝni. Ale ikel mai galit ke, “Nuke, ‘Husur namityal b̃ekǝkereh, asike mǝtoris ginau am; ale husur namityal b̃ekǝkereh am, dereh mǝteris tas ginau.’ Mǝtousus gamit gabag hǝn namilen m̃au a? ");
INSERT INTO klv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kitin, notokitin mai gamit ke, dereh namǝtarur samit tisel, mititaŋ be navile a pan tehǝhaṽur. Dereh nǝlomit titaŋ, be nalolosaan samito tegǝm vi hǝhaṽuran. ");
INSERT INTO klv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nǝboŋ apǝhaṽut tolǝŋon nabǝhaṽun, elǝŋon epǝŋas vǝsa masuṽ, husur namityal hǝn nǝpasusan egǝmai. Be nǝboŋ anatun tovisi, alitenan sǝnau gat na-lǝŋon-isa-vǝsa-an am husur ikemkem masuṽ len anatun toviveu, tovisi len navile a pan. ");
INSERT INTO klv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Imaienan, gagai nǝlomit itaŋ be dereh neris gamit tǝtas, ale nǝlomit tehǝhaṽur. Beti nahǝhaṽuran samito, avan ideh salǝboi b̃ilav kuvi. ");
INSERT INTO klv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Len nǝboŋ enan asike mǝtous natideh hǝn ginau. Kitin notokitin mai gamit ke, natideh mǝtb̃eus aTata hǝni len nahǝsagw, dereh teviol hǝni mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Vǝbar gagai mǝtsaus natideh len nahǝsagw. Usi, dereh mitikade, ale nahǝhaṽuran samit tepul sǝsǝhov. ");
INSERT INTO klv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Natgalenan, nukel gail mai gamit len nasoruan kǝta, be namityal dereh tegǝmai ke asike nǝb̃isor mai gamit am len nasoruan kǝta. Be dereh nisor husur aTata tip̃arp̃ar mai gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Len nǝboŋ enan dereh mǝteus aTata hǝn natit gail len nahǝsagw. Nǝsakel mai gamit ke dereh neusi m̃os gamito. ");
INSERT INTO klv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Husur aTata, gai elǝmas masuṽ hǝn gamito, bathut mǝttolǝmas bun ginau, ale mǝttodǝlomi ke notogǝm len aGot. ");
INSERT INTO klv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Evoi, nogǝm len aTata, nogǝm vi lan navile a pan, ale gagai noriŋ navile a pan, notǝlmam van hǝn aTata.” ");
INSERT INTO klv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Beti ahai susur san gail luke, “Ganan! Gagai nasoruan sam̃ ip̃arp̃ar, gǝsasor am len nasoruan kǝta. ");
INSERT INTO klv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gagai namtolǝboi sǝhoti ke gotolǝboi natit p̃isi, golǝboi nǝnauan sinǝvanuan gol ke savi hǝn avan ideh b̃eus nausian ideh hǝn gaiug am. Husur enan namtodǝlomi ke gotogǝm len aGot.” ");
INSERT INTO klv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","AYesu isor var galit ke, “Gag beti mǝtukad nadǝlomian a? ");
INSERT INTO klv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Namityal egǝmai, ao egǝm tia, hǝn mǝtb̃igam pǝpehw husur nap̃isal samit ṽisusua vahim. Dereh mǝteriŋ ginau hǝn nǝb̃itoh sǝb̃ogw. Be nǝsatoh sǝb̃ogw husur aTata itoh mai ginau. ");
INSERT INTO klv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nukel natgalenan mai gamit hǝn ke, len ginau, nǝlomit b̃ikad natǝm̃at. Len navile eg a pan dereh mitikad na-lǝŋon-isa-vǝsa-an, nǝmauran samit tidaŋ. Be mǝteil b̃ur namǝtahwan samito, ginau nosǝhor navile a pan tia, nugol nǝdaŋan san imasig.” ");
INSERT INTO klv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nǝboŋ aYesu tokǝmaienan tonoŋ, ekǝta vi mǝhat vi lan nǝmav ike, “Tata, namityal egǝm tia. Geputsan aNatum̃ hǝn aNatum̃ b̃isal suh nǝyalyalan sam̃. ");
INSERT INTO klv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Husur gulav nǝdaŋan hǝn na-il-a-m̃o-an maii, hǝn b̃eil a m̃o hǝn nǝvanuan gail p̃isi, hǝn ke b̃eviol hǝn nǝmauran vi sutuai mai nǝvanuan p̃isi gotolav galit maii. ");
INSERT INTO klv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ale nǝmauran vi sutuai imaiegai ke, hǝn lǝb̃elǝboii ke gaiug gotovi Got kitin gotosǝvat ginau, aYesu Kristo. ");
INSERT INTO klv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nusal suh nǝyalyalan sam̃ len navile a pan: nauman gotolavi mai ginau hǝn nǝb̃igole, noum vurvuri. ");
INSERT INTO klv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Beti, Tata, geputsan ginau ben gaiug. Nǝyalyalan notokade mai gaiug nǝboŋ navile a pan satub̃at sal, geputsan ginau hǝni, hǝn gidar p̃isi darb̃ikade. ");
INSERT INTO klv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nukel vǝhot gaiug van hǝn alat navile eg a pan gotoviol hǝn galit mai ginau dan navile a pan. Lovi esam̃ tia. Ale goviol hǝn galit mai ginau, ale lugol husur nasoruan sam̃. ");
INSERT INTO klv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gagai lolǝboii ke natit p̃isi gotolavi mai ginau logǝm len gaiug. ");
INSERT INTO klv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Husur nasoruan gail gotolavi mai ginau, nulav gail mai galit tia. Lodǝlomi. Ale lolǝboi koti ke notogǝm len gaiug, ale lodǝlomi ke gotosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nǝsasor tuṽ m̃os navile a pan. Nusor tuṽ m̃os alat gotolav galit mai ginau, husur lovi esam̃. ");
INSERT INTO klv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Galit p̃isi lotovi esagw lovi esam̃, ale galit p̃isi lotovi esam̃ lovi esagw. Ale len galito, len nǝmauran salito nukad nǝyalyalan. ");
INSERT INTO klv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gagai ginau noriŋ navile a pan gǝm hǝn gaiug. Be galit lutoh sal len navile a pan. Tata, gaiug gotosua sǝb̃om̃, gulav nahǝsam̃ mai ginau tia. Ale len nǝdaŋan hǝn nahǝsam̃, havhav gol galito hǝn lǝb̃esua sum̃an gidaru dartosua. ");
INSERT INTO klv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Husur nǝboŋ nototoh gegai nuhavhav gol galito len nǝdaŋan hǝn nahǝsam̃ gotolavi mai ginau. Nokǝtkǝta tǝban galito, hǝn galit ideh asike b̃imasig, avil galit sua ehusur nap̃isal van hǝn b̃ekǝkos gabag, imasig. Imaienan hǝn natosian sam̃ b̃isarpoh. ");
INSERT INTO klv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gagai ginau nogǝm hǝn gaiug. Nukel natgalen p̃isi len navile a pan hǝn alategai lǝb̃ikad nakemkeman sagw b̃epul sǝsǝhov len galito. ");
INSERT INTO klv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nulav nasoruan sam̃ mai galit tia. Ale navile a pan emǝtahun bun galito tia, husur lǝsavi vanuan navile a pan, sum̃an ŋai ginau nǝsavi vanuan navile a pan. ");
INSERT INTO klv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nǝsaus gaiug hǝn gǝb̃ilav kuv galit dan navile a pan, be nous gaiug ŋai hǝn gǝb̃ihavhav gol galito dan atenan tosa vǝsa tovi tǝmat. ");
INSERT INTO klv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hum ginau nǝsavi sinavile a pan, galit am lǝsavi sinavile a pan. ");
INSERT INTO klv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gigol levi esam̃ sǝb̃om̃ len nakitinan; nasoruan sam̃ evi kitinan. ");
INSERT INTO klv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sum̃an gotosǝvat ginau vi lan navile a pan, ginau am, nosǝvat galit vi lan navile a pan. ");
INSERT INTO klv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noriŋ ginau len navǝlam̃ m̃os galito hǝn nǝb̃evi esam̃ sǝb̃om̃, hǝn ke galit am lǝb̃eriŋ galit len navǝlam̃ hǝn lǝb̃evi esam̃ sǝb̃om̃ len nakitinan. ");
INSERT INTO klv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ginau nǝsasor tuṽ m̃os alategai ŋai, avil nusor tuṽ m̃os avan ideh b̃eriŋ nǝlon len ginau boŋ ideh husur nasoruan silategai. ");
INSERT INTO klv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, nusor tuṽ ke galit p̃isi lesua. Nousi ke litoh tin len gidaru, hum gototoh tin len ginau mai nototoh tin len gaiug, hǝn ke navile a pan lǝb̃edǝlomi ke gotosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nǝyalyalan gotolavi mai ginau, nulavi mai galito, hǝn lǝb̃esua sum̃an dartosua: ");
INSERT INTO klv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ginau len galito ale gaiug len ginau. Nousi ke legǝm sua buni, hǝn navile a pan lǝb̃elǝboii ke gaiug gotosǝvat ginau, ale gotolǝmas bun galito sum̃an ŋai gotolǝmas bun ginau. ");
INSERT INTO klv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, nolǝŋoni ke alat gotolav galit mai ginau, nuke galit am litah mai ginau len naut nototohtoh lan, hǝn lǝb̃eris nǝyalyalan gotolavi mai ginau, husur gotolǝmas masuṽ hǝn ginau nǝboŋ navile a pan satub̃at sal. ");
INSERT INTO klv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata gaiug gunor buni. Naut kǝmas navile a pan lǝsalǝboi gaiug, ginau nolǝboi gaiug, ale alategai lolǝboii ke gotosǝvat ginau. ");
INSERT INTO klv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ale nugol galit lolǝboi gaiug tia, ale dereh nigol tabtab hǝni, hǝn na-lǝmas-buni-an gotolǝmas bun ginau hǝni, b̃ipat len galito, ale ginau nǝb̃itoh len galito.” ");
INSERT INTO klv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nǝboŋ aYesu tosor tuṽ tonoŋ, iyar van mai ahai susur san gail. Luyar kotov nab̃ur madiŋdiŋ Kitron ale lubar nǝhol naoliv ei. Ale gai mai ahai susur san gail lob̃is lan. ");
INSERT INTO klv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Be natsua. AJutas tolavlav aYesu vi lan navǝlan aenemi san gail, gai am elǝboi naut enan, husur aYesu ib̃onb̃on tabtab ei mai ahai susur san gail. ");
INSERT INTO klv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Beti aJutas egǝmai. Ab̃iltihai tutumav mai naFarisi gail losǝvat naluṽoh hǝn nasoltia mai alat lotokǝtkǝta kǝkol hǝn naim siGot hǝn lǝb̃itah maii, ale aJutas esǝhar galito. Lupat nam̃ial mai nǝhai tuŋtuŋ mai natit hǝn nǝb̃alan gail, ale logǝmai. ");
INSERT INTO klv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Husur aYesu tolǝboi natit p̃isi b̃evisi hǝni, ivan hǝn galito, eus galit ke, “Mǝtudoŋ ase?” ");
INSERT INTO klv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lusor vari ke, “AYesu ta Nasaret.” Ikel mai galit ke, “Ginau bogai.” (AJutas toriŋi len navǝlalito, eil mai galit). ");
INSERT INTO klv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nǝboŋ aYesu toke, “Ginau bogai,” lorus tǝlmam, luteh len tan. ");
INSERT INTO klv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Imaienan, eus tas galit ke, “Mǝtudoŋ ase?” Luke, “AYesu ta Nasaret.” ");
INSERT INTO klv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","AYesu isor var galit ke, “Nukel mai gamit tia, ginau bogai. Mǝtb̃idoŋ ginau, riŋ alateg livan.” ");
INSERT INTO klv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ikel nasoruan enan, hǝn nasoruan san b̃isarpoh nǝboŋ tosor tuṽ ke, “Alat gotoviol hǝn galit mai ginau, nǝsatǝgau suluṽ ideh sǝmasig.” ");
INSERT INTO klv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Beti ASimon Pita tokad nab̃u nǝb̃alan, eliv kuvi, ale ita kotov nǝdariŋan nǝmatu sinaslev seb̃iltihai tutumav. (Nahǝsan naslev enan aMalhus.) ");
INSERT INTO klv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Avil aYesu isor len aPita, ike, “Geriŋ tǝlmam hǝn nab̃u len nǝpaus han. Gunau ke asike nomun len nab̃iliwai hǝn na-lǝŋon-isa-vǝsa-an aTata tolavi mai ginau a?” ");
INSERT INTO klv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Beti nasoltia gail mai nakomada salito mai alat lotokǝtkǝta kǝkol hǝn naim siGot, lutah gat aYesu, lubaŋisi. ");
INSERT INTO klv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A m̃o losǝhari van hǝn aAnnas tovi avuŋon aKaiafas tovi ab̃iltihai tutumav len nasihau enan. ");
INSERT INTO klv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Be natsua; evi aKaiafas tokele a m̃o tia mai alat lotoil a m̃o hǝn naJu gail ke, “Ivoi am ke naulum̃an sua b̃imat m̃os nǝvanuan gail.”) ");
INSERT INTO klv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nǝboŋ lotosǝhar aYesu van, aSimon Pita mai ahai susur siYesu sual am arohusur aYesu. Ahai susur togon elǝboi ab̃iltihai tutumav. Imaienan, eb̃is len naholǝvat todar vis naim seb̃iltihai tutumav mai aYesu. ");
INSERT INTO klv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Avil aPita eil vivile dan nabopita. Imaienan, togon ab̃iltihai tutumav tolǝboi, etǝlmam, isor mai natǝbarehreh tokǝtkǝta kǝkol hǝn nabopita, esǝhar aPita, arob̃isutur van. ");
INSERT INTO klv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Natǝbarehreh tokǝtkǝta kǝkol hǝn nabopita eus aPita ke, “Be gaiug am gǝsavi ahai susur ideh sitenan a?” APita ike, “Ao, savi ginau.” ");
INSERT INTO klv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Naut esusus, ale naslev mai nǝvanuan nauman gail lopǝŋas naṽidurhab, lotitileh. APita eil mai galito, etitileh. ");
INSERT INTO klv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Len nalohoim enan, ab̃iltihai tutumav etub̃at us aYesu husur ahai susur san gail mai nap̃usanan san. ");
INSERT INTO klv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","AYesu isor vari ke, “Akis nusor len nǝhon nǝvanuan gail p̃isi; nop̃usan len naim nab̃onb̃onan gail mai naim siGot, naJu gail losuh b̃onb̃on len naut galenan akis. Nǝsakel susuan natideh. ");
INSERT INTO klv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gous ginau hǝn nausian galenan hǝn nǝsa? Us galit lotosǝsǝloŋ hǝn ginau. Lolǝboi nǝsa notokele.” ");
INSERT INTO klv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nǝboŋ tokel natenan, avan sua tokǝtkǝta kǝkol hǝn naim siGot iṽos aYesu, isor lan, ike, “Imab gusor var ab̃iltihai tutumav maienan?” ");
INSERT INTO klv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","AYesu isor vari ke, “Nǝb̃ikel natideh tosa, kel kot nǝsaan han. Be nǝb̃ikel nakitinan, guṽos ginau hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Beti aAnnas ikel mai alat lotokǝtkǝta kǝkol ei ke, lesǝhar aYesu lotobaŋisi, van hǝn aKaiafas, ab̃iltihai tutumav hǝn b̃ikot hǝni. ");
INSERT INTO klv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Len namityal enan aSimon Pita eil, etitileh. Lousi ke, “Be gaiug enan, gǝsavi ahai susur ideh san a?” Beti aPita ike, “Ao savi ginau.” ");
INSERT INTO klv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ale naslev sua seb̃iltihai tutumav, amahean atenan aPita tota kotov nǝdariŋan ike, “Eniŋan, be noris gaiug maii len nǝhol naoliv.” ");
INSERT INTO klv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","APita isor tǝtas ke sakitin. Vǝha-sua ŋai natoulum̃an ekǝkǝraiko. ");
INSERT INTO klv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nǝboŋ aKaiafas tokot hǝn aYesu tonoŋ dudulan som̃ilan, losǝhar aYesu van hǝn aPilate ta Rom tovi gavna len naprovens Jutea. Gai itoh len nab̃iltiim sisoltia gail. NaJu gail lǝsab̃is lohoim, hǝn asike lǝb̃eb̃iŋb̃iŋal len nabunusian husur nalo. Lǝb̃imagenan, asike lolǝboi lǝb̃ihan len nǝhanan hǝn nǝPasova. ");
INSERT INTO klv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Imaienan aPilate evivile van hǝn galito, ike, “Gamit mǝtuke ategai togol nǝsa tosa hǝn tob̃ur kotov nalo?” ");
INSERT INTO klv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Lusor vari, luke, “Ategai asike tagol natit tosa, gunau ke namttasǝhari gǝmai a? Aoa!” ");
INSERT INTO klv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","APilate ike, “B̃imagenan, sǝhari van, kot hǝni, nǝnoṽ hǝni mai nalo samit ŋai!” Alat lotoil a m̃o hǝn naJu gail lusor vari ke, “Nalo samito sǝdam̃ hǝn namtb̃igol avan ideh b̃imat.” ");
INSERT INTO klv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Natenan igol natit aYesu tokele a m̃o husur naṽide hǝn nǝmatan san, isarpoh.) ");
INSERT INTO klv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Beti aPilate etǝlmam vi lohoim, ekis aYesu gǝmai, ale eusi ke, “Gaiug nakiŋ seJu gail a?” ");
INSERT INTO klv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","AYesu eusi ke, “Nasoruan sam̃, evi nǝnauan sam̃ sǝb̃om̃ o nǝvanuan tile am isor mai gaiug husur ginau?” ");
INSERT INTO klv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","APilate isor vari ke, “Gunau ke notovi Ju sual a? Ao, nǝvanuan sam̃ gail mai ab̃iltihai tutumav gail losǝhar gaiug gǝm hǝn nakotan sagw. Imabe? Gugol nǝsa?” ");
INSERT INTO klv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","AYesu ike, “Natohan pipihabǝlagw savi hǝn navile eg a pan. Tavi sinavile a pan, alat lotohusur ginau lǝtǝb̃al hǝn avan ideh asike tariŋ ginau len navǝlan alat lotoil a m̃o hǝn naJu gail. Be natohan pipihabǝlagw savi hǝn navile eg a pan.” ");
INSERT INTO klv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ŋa aPilate eusi ke, “Beti gaiug govi nakiŋ m̃au a?” AYesu isor vari ke, “Gaiug gukele ke notovi akiŋ. Lupas ginau m̃osi. Ale nogǝm hǝn navile a pan m̃os nategai ke hǝn nǝb̃ikel kot nakitinan. Alat lotovi sinakitinan losǝsǝloŋ hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","APilate eusi ke, “Nakitinan evi sa?” Nǝboŋ tous naten tonoŋ aPilate evivile van hǝn naJu gail, ikel uri ke, “Nǝsǝsab̃ natideh lan tonor hǝn b̃ipanis. ");
INSERT INTO klv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Be ikad naṽide sua len nǝPasova p̃isi hǝn mǝttous nǝvanuan sua dan alat namttobaŋis galito, hǝn b̃evivile m̃os gamito. Mǝtolǝŋon ke nigol aKiŋ egai seJu gail tevivile van hǝn gamito a?” ");
INSERT INTO klv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Be lukai vari ke, “Aoa! Savi atenan, namtolǝŋon aParappas.” (Be natsua: aParappas evi naulum̃an tob̃al mai alat a Rom, ale lubaŋisi sile.) ");
INSERT INTO klv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Beti aPilate igol nasoltia gail lobilas habat hǝn aYesu hǝn nǝhau tokad natuhmetǝlai tosiriv lan. ");
INSERT INTO klv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ale nasoltia gail lulav nǝhau tokad nasunite, lopir garu hǝni hum nǝkraun sekiŋ, loriŋi len nǝkadun ale lukol nahurabat toboŋboŋ len aYesu. ");
INSERT INTO klv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Logǝm hǝni, lusor vilesi ke, “Ivoi! Kiŋ seJu gail!” ale luṽosi. ");
INSERT INTO klv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","APilate evivile tǝtas, ikel mai naluṽoh ke, “Mǝteris! Gagai nosǝhari vivile van hǝn gamito, hǝn mǝtb̃elǝboii ke, nǝsǝsab̃ natideh lan hǝn b̃ipanis sile.” ");
INSERT INTO klv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Imaienan, esǝhar aYesu vivile. Ikad nǝkraun hǝn nǝhau tokad nasunite len nǝkadun mai nahurabat toboŋboŋ len niben. Pilate ikel mai galit ke, “Mǝteris, ategaii bogai!” ");
INSERT INTO klv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nǝboŋ ab̃iltihai tutumav gail mai alat lotokǝtkǝta kǝkol hǝn naim siGot lotorisi, lukai, ke “P̃os gati len nǝhai balbal! P̃os gati len nǝhai balbal!” APilate ikel mai galit ke, “Ipat len gamito, gamit mitip̃os gati, husur ginau nǝsǝsab̃ natideh tosa lan hǝn b̃ipanis sile.” ");
INSERT INTO klv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nab̃iltiJu gail lusor vari ke, “Namtukad nalo sua toke timasmat, husur ekiskis gai gabag hǝn aNatun aGot.” ");
INSERT INTO klv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nǝboŋ aPilate tosǝsǝloŋ hǝn natenan emǝtahw am. ");
INSERT INTO klv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Esǝhar aYesu tǝlmam tǝtas vi lohoim sisoltia gail. Eusi ke, “Govi nǝvanuan naut a be?” Ris aYesu sasor vari. ");
INSERT INTO klv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Imagenan aPilate eusi ke, “Imabe gǝsasor mai ginau? Gǝsalǝboii ke ginau nukad nǝdaŋan hǝn nǝb̃idam̃ hǝn gǝb̃ivan, mai nǝdaŋan hǝn nǝb̃igol gǝb̃itahǝtah len nǝhai balbal a?” ");
INSERT INTO klv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Beti aYesu isor vari ke, “Gaiug, nutoh len navǝlam̃ husur ŋai aGot a mǝhat tolav nǝdaŋan mai gaiug. Imaienan, nǝvanuan toriŋ ginau len navǝlam̃ ikad nǝsaan totibau sǝhor gaiug.” ");
INSERT INTO klv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nǝboŋ aPilate tosǝsǝloŋ hǝn natenan idas p̃isal hǝn b̃eriŋ aYesu b̃ivan, be nab̃iltiJu gail lukai habat ke, “Gǝb̃eriŋi b̃ivan asike govi bubur seSisa! Avan ideh tokis gai gabag hǝn nakiŋ hum aYesu egaii togole, avan enan evi enemi seSisa!” ");
INSERT INTO klv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nǝboŋ aPilate tosǝsǝloŋ hǝn nasoran enan, esǝhar aYesu vivile tǝtas. Ale aPilate ebǝtah len nǝhai bǝtbǝtah simatsistret hǝn b̃eriŋ nǝsab̃ian san. Nǝhai bǝtbǝtah enan ipat len naut lotokisi hǝn Naut nǝvat papav be len nasoruan seIpru gail evi Kappata. ");
INSERT INTO klv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Len namityal enan evi tub̃lial len nǝmariboŋ hǝn nautautan hǝn nǝPasova. Ale aPilate ikel mai naJu gail ke, “Mǝteris, akiŋ samit bogai!” ");
INSERT INTO klv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lukai vari ke, “Tevi tut! Tevi tut! P̃os gati len nǝhai balbal!” Ale aPilate eus galit ke, “Mǝtolǝŋon ke nip̃os gat akiŋ samit len nǝhai balbal a?” Ab̃iltihai tutumav gail lukai van ke, “Namtsǝkad nakiŋ ideh, be aSisa ŋai.” ");
INSERT INTO klv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Imaienan aPilate eriŋ aYesu len navǝlalito hǝn b̃itahǝtah len nǝhai balbal. Ŋa nasoltia gail losǝhar aYesu van. ");
INSERT INTO klv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","AYesu sǝb̃on ipat nǝhai balbal, iyar van vǝbar naut lotokisi hǝn Naut hǝn Nabǝlashukadhutǝmat (lotokisi hǝn Kolkota len nasoruan seIpru gail). ");
INSERT INTO klv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Len naut enan lup̃os gati len nǝhai balbal. Lup̃os gat naulum̃an eru am hǝn arb̃itahǝtah, sua len nǝtarhǝt nǝmatu, sua len nǝmair ale aYesu rivuh. ");
INSERT INTO klv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ale aPilate itos nǝhes sua ale loriŋi len nǝhai balbal. Ike, “Yesu ta Nasaret, aKiŋ seJu gail.” ");
INSERT INTO klv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","NaJu isob̃ur loṽuruŋ nǝhes enan, husur naut aYesu totahǝtah lan ipat pǝpadaŋ hǝn nab̃iltivile, ale aPilate itos nǝhes enan len nasoruan seIpru gail mai nasoruan ta Rom mai ta Kris. ");
INSERT INTO klv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Beti ab̃iltihai tutumav gail lukel mai aPilate ke, “Sagitos ‘aKiŋ seJu gail,’ be gitosi ŋai ke, ‘Gai sǝb̃on ikele ke tovi Kiŋ seJu gail.’” ");
INSERT INTO klv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","APilate isor var galit ke, “Nǝsa nototosi tipat, nutosi tia.” ");
INSERT INTO klv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nǝboŋ nasoltia gail lotop̃os gat aYesu len nǝhai balbal tonoŋ, lopǝpehun nahurabat san gail mai galit lotovat. Lulav nǝhai susun san napǝpaian tokat udud mai sǝkad nasodean lan. ");
INSERT INTO klv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nasoltia gail lukel mai galit gabag ke, “Sadatitari. Datibar hǝn nǝvat hǝn datb̃isab̃i ke as tikade.” Natenan evisi hǝn natosian siGot b̃isarpoh toke, “Lopǝpehun nahurabat sagw len galito, lubar hǝn nǝvat hǝn lǝb̃isab̃i ke ase tikad nahurabat sagw.” Ŋa natgalenan, nasoltia gail beti lugole. ");
INSERT INTO klv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Anan aYesu eil pǝpadaŋ hǝn nǝhai balbal mai napǝhaṽut totor am. Ikad aṽan anan aYesu, mai aMeri asoan aKlopas, mai aMeri ta Maktala. ");
INSERT INTO klv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nǝboŋ aYesu toris anan toil ei ben ahai susur san tolǝmas buni, ikel mai anan ke, “Bareab, geris, anatum̃ bolai.” ");
INSERT INTO klv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ale ikel mai ahai susur enan ke, “Anam̃ sam̃ bolai.” Ale tub̃at len namityal enan, ahai susur enan esǝhar alitenan vahim, ekǝtkǝta tǝban hum tovi anan matmat. ");
INSERT INTO klv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Husur namityal enan aYesu elǝboii ke natit p̃isi ihav tia. Ale hǝn natosian siGot b̃isarpoh, ike, “Numaduh.” ");
INSERT INTO klv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nab̃iliwai topul hǝn navinika ipat ei. Loduŋ nasponts lan, riŋi len nǝpashǝt nahisop, ale losuhuni vi mǝhat van hǝn nabuŋon. ");
INSERT INTO klv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nǝboŋ aYesu todalus navinika, ike, “Ihav!” Beti isar batut, ilav nanunun mai aGot, imat. ");
INSERT INTO klv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Evi nǝmariboŋ hǝn nautautan hǝn NǝSappat ale naJu lomǝtahun nibelit lǝb̃itahǝtah len nǝhai balbal gail len nǝSappat (ale evi nab̃iltiSappat sua husur evi nǝPasova). Imagenan, nab̃iltiJu gail lous aPilate ke tidam̃ hǝn lǝb̃iṽab̃ub̃ur narielito hǝn lǝb̃imat, ale sah sur nab̃irimat gail. ");
INSERT INTO klv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ŋa nasoltia gail logǝm, ṽab̃ub̃ur narien alaruenan artotahǝtah len nǝhai balbal mai aYesu. ");
INSERT INTO klv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Be nǝboŋ lotogǝm hǝn aYesu, lusab̃i ke tomat tia, gol lǝsǝṽab̃ur narien gǝlaru. ");
INSERT INTO klv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Be nasoltia sua isar nǝgarin aYesu hǝn naṽisusua, ale vǝha-sua ŋai nǝda mai nǝwai arusel vi pan. ");
INSERT INTO klv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Nǝvanuan toris natenan ikel kot nǝsa torisi, ale na-kel-koti-an san ekitin. Elǝboii ke tokitin, ale ikel kot nakitinan hǝn mǝtb̃ikad nadǝlomian.) ");
INSERT INTO klv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Natgalenan lovisi hǝn natosian siGot b̃isarpoh toke, “Nabǝlasun ideh asike imab̃ur.” ");
INSERT INTO klv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ale natosian siGot tile am toke, “Dereh lebunus atenan lotosari.” ");
INSERT INTO klv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nǝboŋ natgalenan tonoŋ, ikad auleArimatea sua, nahǝsan aJosef. AJosef enan evi ahai susur siYesu tosusuan nadǝlomian san husur tomǝtahw len nab̃iltiJu gail. Gai ivan hǝn aPilate hǝn b̃eusi ke tidam̃ hǝn b̃ilav kuv niben aYesu. APilate idam̃ hǝni maii, ale aJosef ilav kuv niben aYesu van. ");
INSERT INTO klv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ikad avan sual am totah mai aJosef, nahǝsan aNikotemus togǝm hǝn aYesu len mariug sutuai tia. Ale ilav nakilo tovi 34 hǝn namǝr tob̃on mai nǝalos. ");
INSERT INTO klv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Husur naṽide seJu gail hǝn natǝtavunan, lupat niben aYesu van, loruŋ gole len nǝkaliko nalinen mai natit tosusau. ");
INSERT INTO klv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pǝpadaŋ hǝn naut aYesu totahǝtah lan, ikad nǝhol sua. Len nǝhol enan ikad nab̃urhuvat nǝmatan toveveu lǝsǝtavun niben avan ideh lan sal. ");
INSERT INTO klv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ale husur evi Nǝboŋ Nautautan hǝn nǝPasova seJu gail, ale husur nab̃urhuvat nǝmatan enan ipat pǝpadaŋ ei, loriŋ aYesu lan. ");
INSERT INTO klv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dudulan som̃ilan len nǝmariboŋ metǝkav hǝn nawik, naut tovisivis sal, aMeri ta Maktala evi lan nab̃urhuvat nǝmatan, ale eris nab̃iltivat torib dan nabopita hǝn nab̃urhuvat. ");
INSERT INTO klv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ŋa igam van varis aSimon Pita mai ahai susur togon aYesu tolǝmas buni. Ikel mai gǝlar ke, “Lupat kuv niben Nasub̃ dan nab̃urhuvat nǝmatan, ale namtsalǝboi naut lotoriŋi lan!” ");
INSERT INTO klv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Imaienan aPita mai ahai susur togon aruvan varis nab̃urhuvat. ");
INSERT INTO klv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Len nǝgamgaman sǝlaru van, ahai susur togon igam tutut sǝhor aPita, ale ibar nab̃urhuvat a m̃o. ");
INSERT INTO klv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ib̃etb̃et, ekǝta ris nǝkaliko nalinen lotopat ei, be gai sab̃is vi lohoim. ");
INSERT INTO klv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Beti aSimon Pita tohusuri, ibar naut enan, ale eb̃is vi lan nab̃urhuvat. Gai am eris nǝkaliko nalinen lotosuh ei. ");
INSERT INTO klv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Be natuhtaol hǝn nǝhon ipat len naut tile, hum avan sua tob̃uruŋi, riŋ sǝb̃on hǝni. ");
INSERT INTO klv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Beti ahai susur togon tobari a m̃o eb̃is lohoim, gai am erisi ale edǝlomi ke aYesu tole mǝhat. ");
INSERT INTO klv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Be mitinau, natosian siGot ike aYesu timasle mǝhat dan nǝmatan. Be arsalǝboi sǝhoti sal. ");
INSERT INTO klv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Beti alaruenan aruvahim sǝlaru.) ");
INSERT INTO klv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nǝboŋ artovan tonoŋ, aMeri enan eil taŋtaŋ sal vivile hǝn nab̃urhuvat. Ib̃etb̃et vakǝta vi lohoim. ");
INSERT INTO klv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Eris aŋel eru artosun nahurabat topǝhw gail. Arobǝtah len naut niben aYesu topat lan. Sual ebǝtah len naut toturuŋ lan, ale togon len naut tosǝsaruh vi lan. ");
INSERT INTO klv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Alaruenan arukel maii ke, “Bareab, gutaŋ hǝn nǝsa?” Isor var gǝlar ke, “Lupat kuv aMasta sagw, nǝsalǝboi naut lotoriŋi lan.” ");
INSERT INTO klv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nǝboŋ tokel natgalenan tonoŋ, ipair, eris aYesu toil ei, be sakǝta sǝhoti. ");
INSERT INTO klv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","AYesu ikel maii ke, “Bareab, gutaŋ hǝn nǝsa? Gudoŋ ase?” AMeri, tonau ke tovi nǝvanuan tokǝtkǝta tǝban nǝhol enan, ikel maii ke, “Nasub̃, gaiug gǝb̃ipati van, kel mai ginau hǝn naut gotoriŋi lan, ale dereh nivan hǝn nǝb̃ipati.” ");
INSERT INTO klv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","AYesu ike, “Meri!” AMeri ipair kǝta van hǝni, ikai ke, “Rapponi!” (tovi “Hai p̃usan” len nasoruan seIpru gail). ");
INSERT INTO klv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","AYesu ikel maii ke, “Sagibar ginau am, husur nǝsavi mǝhat van hǝn aTata sal. Avil givan hǝn na-ke-ṽan-an sagw gail. Kel mai galit ke, ‘Gagai novi mǝhat van hǝn aTata sagw mai aTata samito, van hǝn aGot sagw mai aGot samito.’” ");
INSERT INTO klv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ŋa aMeri ta Maktala ivan, ikel uri mai ahai susur gail ke, “Noris Nasub̃!” Ale ikel mai galito hǝn natit p̃isi aYesu tokel maii. ");
INSERT INTO klv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Len nǝSade ut mǝdau naut togomgom, ahai susur lub̃onb̃on lohoim. Lokǝkol gat nabopita husur lomǝtahw len nab̃iltiJu gail. AYesu egǝm il rivuh len galito. Ikel mai galit ke, “Nǝlomit tikad natǝm̃at!” ");
INSERT INTO klv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nǝboŋ tokǝmaienan eṽusan navǝlan gǝlaru mai nǝgarin hǝn galito. Ahai susur gail lukemkem masuṽ hǝn lotoris Nasub̃. ");
INSERT INTO klv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Imaienan aYesu isor tǝtas mai galit, ike, “Nǝlomit tikad natǝm̃at! Hum aTata tosǝvat ginau, ginau am nosǝvat gamito.” ");
INSERT INTO klv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Beti esuŋavŋav ale ike, “Mitikad aNunun aGot. ");
INSERT INTO klv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mǝtb̃erub̃at nǝsaan sivan ideh gail, aGot erub̃at gail tia. Asike mǝtb̃erub̃at nǝsaan sivan ideh gail, aGot sarub̃at gail.” ");
INSERT INTO klv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Len ahai susur lotovi 12, ikad aTomas, namilen ke aMǝlav. Be nǝboŋ aYesu tovisi hǝn galit am, gai satoh. ");
INSERT INTO klv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Imaienan, ahai susur gail lukel maii ke, “Ginamit namtoris Nasub̃!” Ris aTomas tosor var galit ke, “Asike nodǝlom nǝsa mǝttokele van vǝbar nǝb̃eris nab̃urhunil len navǝlan gǝlaru, mai nǝb̃esiriv hǝn nǝŋarhuvǝlagw len gǝlaru ale siriv hǝn navǝlagw len nab̃urhugarin.” ");
INSERT INTO klv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Len nǝmariboŋ tomǝlevtor tohusur nǝboŋ enan, ahai susur siYesu gail lutoh lohoim, ale aTomas evi galit sual ei. Nabopita gail lokǝkol haihai be aYesu egǝmai, eil rivuh len galito. Ike, “Nǝlomit tikad natǝm̃at.” ");
INSERT INTO klv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Beti ikel mai aTomas ke, “Siriv hǝn nǝŋarhuvǝlam̃ gegai. Geris navǝlagw gǝlaru. Siriv hǝn navǝlam̃ len nab̃urhugarigw. Nǝ-lon-uri-an sam̃ tinoŋ! Geriŋ nǝlom̃ len ginau!” ");
INSERT INTO klv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ATomas isor vari, ike, “Gaiug aMasta sagw, govi aGot sagw!” ");
INSERT INTO klv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Beti aYesu ikel maii ke, “Gaiug gukad nadǝlomian husur gotoris ginau. Alat lǝsaris ginau be lotoriŋ nǝlolit len ginau, navoian siGot igol lukab hǝni.” ");
INSERT INTO klv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Len nǝhon ahai susur san gail, aYesu igol namerikel isob̃ur am sǝhor nototos gat gail len nalob̃ulat egai. ");
INSERT INTO klv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Be nutos natgalegai hǝn mǝtb̃edǝlomi ke aYesu tovi aKristo, aGot totabtabuh lan, tovi aNatun aGot. Nutosi maienan hǝn mǝtb̃eriŋ nǝlomit lan, ale len nadǝlomian samit mǝtb̃ikad nǝmauran len nahǝsan. ");
INSERT INTO klv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Len nǝboŋ sual am aYesu evisi hǝn ahai susur san gail len Nab̃iltiwai Tiperias. Nǝsa tovisi imaiegai: ");
INSERT INTO klv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ikad aSimon Pita, aTomas namilen ke aMǝlav, aNatanael ta Kana a Kalili, alarmiṽan artovi anatun aSepeti gǝlaru, mai ahai susur eru am lototoh ei. ");
INSERT INTO klv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ASimon Pita ikel mai galit ke, “Nesǝsahieh beti.” Lukel maii ke, “Gidato.” Ale luvan, sah len nab̃ot. Nǝmargobut egǝmai. Losǝsahieh len mariug kavkav, lǝsǝsah hǝn ideh. ");
INSERT INTO klv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nǝboŋ naut tolan, aYesu eil bitas be ahai susur gail lǝsalǝboii ke tovi gai. ");
INSERT INTO klv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Beti ikai van hǝn galit ke, “Gamito! Mǝtusah hǝn naieh ideh a?” Ale lusor vari ke, “Eb̃uer!” ");
INSERT INTO klv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ikel mai galit ke, “Bar hǝn nalevlev len nǝmatu tarhǝb̃ot, ale dereh mitisab̃ ideh.” Ŋa lubar hǝni, be lodǝdas lǝb̃elivi gǝm hǝn nab̃ot, husur naieh tosob̃ur igol tomǝlas. ");
INSERT INTO klv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Beti ahai susur aYesu tolǝmas buni ikel mai aPita ke, “Nasub̃ bolai!” Nǝboŋ aSimon Pita tosǝsǝloŋ hǝni ke tovi Nasub̃, epitavis nahurabat san tokole, emǝlah vi lan nǝwai. ");
INSERT INTO klv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Galit am losuh len nab̃ot, loliv nalevlev vahut husur bitas savi a tut, namita tovi 100 ŋai. ");
INSERT INTO klv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nǝboŋ lotomariŋ vahut, loris nǝhab tominen, naieh tolǝŋas lan, mai nabǝta. ");
INSERT INTO klv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Beti aYesu ike, “Tariv naieh ideh mǝttomadhasah hǝn gail gǝmai.” ");
INSERT INTO klv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ŋa aSimon Pita ilev gargar nalevlev topul hǝn nab̃iltiieh gail vi len tan. Naut kǝmas naieh tovi 153, nalevlev sǝmarmarikot. ");
INSERT INTO klv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","AYesu ike, “Mǝtegǝm han.” Be ahai susur ideh sausi ke, “Gaiug ase?” husur lolǝboii ke tovi Nasub̃. ");
INSERT INTO klv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Beti aYesu egǝm, lav nabǝta mai galito. Igol maien hǝn naieh am. ");
INSERT INTO klv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Enan evi navisian na-vǝha-tor-an siYesu tǝban ahai susur gail tohusur na-le-mǝhat-an san dan nǝmatan. ");
INSERT INTO klv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nǝboŋ lotohan tonoŋ, aYesu ikel mai aSimon Pita ke, “Simon, anatun aJon, golǝmas masuṽ hǝn ginau sǝhor alateg a?” Isor vari ke, “Evoi Nasub̃, golǝboii ke notolǝmas gaiug.” AYesu ike, “Gevǝŋan natuhsipsip sagw gail.” ");
INSERT INTO klv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","AYesu eus tasi ke, “Simon, anatun aJon, golǝmas masuṽ hǝn ginau a?” Ikel maii ke, “Evoi Nasub̃, golǝboii ke notolǝmas gaiug.” AYesu ike, “Gekǝtkǝta tǝban nasipsip sagw gail.” ");
INSERT INTO klv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","AYesu eus tǝtas hǝni am ke, “Simon, anatun aJon, golǝmas ginau a?” Nausian na-vǝha-tor-an etunus aPita, ike titaŋ. Ikel maii ke, “Nasub̃, golǝboi natit p̃isi. Golǝboii ke notolǝmas gaiug.” AYesu ike, “Gevǝŋan nasipsip sagw gail. ");
INSERT INTO klv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nukel nakitinan, nǝboŋ gotovi mantuhmar, gosun nahurabat sam̃, govi lan naut p̃isi gotolǝŋoni. Be nǝboŋ gǝb̃evi haṽut, dereh gisar hǝn navǝlam̃ gǝlaru ale avan ideh am tikol nahurabat len gaiug, tesǝhar gaiug len naut gǝb̃emǝtahun gǝb̃evi lan.” ");
INSERT INTO klv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","AYesu ekǝmaienan, hǝn b̃ikel p̃arp̃ar hǝn nǝmatan sePita b̃imat hǝni hǝn b̃eputsan nahǝsan aGot. Nǝboŋ tokǝmaienan tonoŋ, ikel mai aPita ke, “Gehusur ginau.” ");
INSERT INTO klv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","APita ipair, ekǝta ris ahai susur aYesu tolǝmas buni toyar husur gǝlaru. Atenan evi ahai susur tosiŋasiŋ len nǝmabun aYesu len nǝhanan, tousi ke, “Nasub̃, ase b̃eriŋ gaiug len navǝlan aenemi sam̃ gail?” ");
INSERT INTO klv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nǝboŋ aPita tokǝta risi, eus aYesu hǝni ke, “Be Nasub̃, atenan timabe?” ");
INSERT INTO klv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","AYesu isor vari ke, “Nǝb̃elǝŋoni ke gai b̃itoh vǝbar nagǝmaian sagw, savi natideh len gaiug! Gaiug m̃au gehusur ginau.” ");
INSERT INTO klv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bathut natenan, nasoruan pǝpat iperŋan alat lotokad nadǝlomian ke, ahai susur enan asike imat. Be enan savi nǝsa aYesu tokele. Ike, “Nǝb̃elǝŋoni ke gai b̃itoh vǝbar nagǝmaian sagw, savi natideh len gaiug!” ");
INSERT INTO klv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ahai susur siYesu egai tokel kot natgalenan, evi gai totos gat natgalegai len nalob̃ulat egai. Ale namtolǝboii ke na-kel-koti-an san ekitin. ");
INSERT INTO klv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ikad natit isob̃ur am aYesu togole. Ale nǝvanuan lǝtatos gat ṽisusua hǝn natgalenan, nunau ke navile a pan kavkav asike tǝnav hǝn nalob̃ulat galen p̃isi lǝtǝpat lan. ");
INSERT INTO klv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus, len nalob̃ulat ta m̃o sagw nuhol husur natit p̃isi aYesu totub̃at gole mai p̃usan hǝni vǝbar nǝboŋ aGot tolavi vi mǝhat vi lan nǝmav. ");
INSERT INTO klv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Len nǝboŋ savi mǝhat sal, len nǝdaŋan seNunun aGot, aYesu ikel nap̃isal hǝn nauman mai ahai pispisul gail totabtabuh len galit tia. ");
INSERT INTO klv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Husur na-lǝŋon-isa-an mai nǝmatan san, aYesu evisi hǝn galito, be imaur. Ale eṽusan nǝmauran san hǝn galito hǝn lǝb̃eris lǝboii ke imaur kitin. Gai evisi hǝn galito vǝha-sob̃ur len nǝmariboŋ tovi 40 ale isor husur natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Boŋ sua ihanhan mai galito, ale ikel nǝ-kai-tasi-an sua, ike, “Samteriŋ naut a Jerusalem, be mititoh vir naviolan aTǝmagw tokel gati tia. Egai nǝsa notokel mai gamito, mǝttosǝsǝloŋ hǝni; ");
INSERT INTO klv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","husur aJon ibaptais hǝn nǝvanuan gail hǝn nǝwai be asike idareh aGot tibaptais hǝn gamito hǝn aNunun.” ");
INSERT INTO klv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ŋa nǝboŋ lotob̃onb̃on, lousi ke, “Nasub̃, imabe? Gagai gilav tǝlmam hǝn naut a Israel titoh pipihabǝlan nakiŋ salit gabag tǝtas am a?” ");
INSERT INTO klv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Be ikel mai galito ke, “Savi samito hǝn mǝtb̃elǝboi namityal o nǝmariboŋ aTǝmagw toriŋi len nǝdaŋan hǝn na-il-a-m̃o-an san. ");
INSERT INTO klv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dereh mitikad nǝdaŋan nǝboŋ aNunun aGot b̃egǝm len gamito. Dereh mitikel ur ginau len naut a Jerusalem, len naprovens Jutea mai naut a Samaria van vǝbar tarhǝt navile a pan.” ");
INSERT INTO klv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nǝboŋ aYesu tokǝmaienan tonoŋ, aGot ilavi vi mǝhat vi lan nǝmav. Lokǝta husuri van nǝmavukasw esusuani. ");
INSERT INTO klv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nǝboŋ tovi mǝhat lokǝtkǝta vi mǝhat, vǝha-sua ŋai nǝvanuan eru arovisi, il mai galito. Arosun nahurabat topǝhapǝhw. ");
INSERT INTO klv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aruke, “UleKalili gail, imabe mǝtokǝta vi mǝhat maienan? AYesu egaii aGot tolavi vi mǝhat dan gamito, dereh tetǝlmam sum̃an tovi mǝhat.” ");
INSERT INTO klv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Beti luyar tǝlmam dan Naṽehuh Oliv enan, vi Jerusalem. Evi nǝyaran hǝn nǝSappat, nakilomita esua ŋai. ");
INSERT INTO klv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nǝboŋ lotobar naut enan, lopǝlau vi lohoim len naim a mǝhat lototohtoh lan. Ikad aPita, aJon, aJemes, aAdru, aFilip, aTomas, aPartolomiu, aMattiu, aJemes anatun aAlfeus, aSimon tovi Selot sua, mai aJutas anatun aJemes. ");
INSERT INTO klv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Len nǝnauan sua lub̃onb̃on tabtab hǝn lǝb̃isor tuṽ, galit mai alatpǝhaṽut mai aMeri anan aYesu, mai aṽan aYesu gail. ");
INSERT INTO klv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Len nǝboŋ galen sua, APita eil rivuh len ahai susur gail. Galito lovi 120. ");
INSERT INTO klv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ike, “Bathudud sagw, sutuai aNunun aGot isor len nabuŋon aTevit husur aJutas. Nǝsa aGot tokele len natosian san isarpoh hum nasoruan san tosarpoh akis. AJutas eil a m̃o hǝn alat lototah gat aYesu, ");
INSERT INTO klv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","naut kǝmas gai tovi ginamit sua. Gai ikad nahudhuuman egai siGot sum̃an gidato.” ");
INSERT INTO klv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(AJutas eṽur nǝtan hǝn nǝvat tokade sil naṽide san tosa. Ale iteh, sueh nǝtan, nabǝhaṽun imap̃ul, ale ninen elul vivile. ");
INSERT INTO klv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nǝboŋ alat a Jerusalem p̃isi lotosǝsǝloŋ lǝboi natenan, loriŋ nǝhes len nǝtan enan. Len nasoruan salito evi Akeltama, Marireu hǝn Nǝda bolai.) ");
INSERT INTO klv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","APita isor am ike, “Len nalob̃ulat hǝn Nǝb̃e gail aTevit itosi ke, “‘Naim san timasb̃ǝb̃esw, nǝvanuan ideh satitoh lan,’ mai, “‘Ivoi ke avan sua tigel namilen.’ ");
INSERT INTO klv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Imaienan, ivoi ke alateg ideh tegǝm vi vanuan sua len gidat dattosǝŋavur pisan esua. Avan enan tevi vanuan sua toyar mai gidat akis nǝboŋ aYesu totah mai gidato, tub̃at len nǝboŋ aJon tobaptais hǝn aYesu van vǝbar aGot tolav kuvi dan gidato. Hum gidato, avan enan eris aYesu tomaur tǝtas ale timasb̃on mai gidato hǝn datb̃ikel ur na-le-mǝhat-an enan san dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ŋa nǝboŋ aPita tokel naten tonoŋ, lulekis hǝn naulum̃an eru. Esua nahǝsan aJosef lotokisi hǝn aParsappas (lokisi hǝn aJustus am), togon nahǝsan aMattias. ");
INSERT INTO klv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Beti lusor mai aGot ke, “Nasub̃, gaiug m̃au golǝboi nǝlon nǝvanuan p̃isi. Gigol p̃arp̃ar hǝn tesua len gǝlar egai gototabtabuh lan tia ");
INSERT INTO klv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hǝn b̃ilav namilen aJutas hǝn nauman san mai nauman sihai pispisul. AJutas ipair dani vǝsab.” ");
INSERT INTO klv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ale lubar hǝn nǝvat hǝn lǝb̃isab̃ ase len gǝlaru. Lusab̃ aMattias ale ib̃on mai ahai pispisul sǝŋavur pisan esua. ");
INSERT INTO klv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Len nǝboŋ hǝn naPentikost togǝmai lub̃on len naut esua. ");
INSERT INTO klv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Vǝha-sua ŋai ikad nǝwalan dan nǝmav tosum̃an nǝlan paru, ale naim lotobǝtah lan epul hǝni. ");
INSERT INTO klv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Loris natit tohun natuhuhab lotowunwun lotopǝpehw ale lupat len galit ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Galit p̃isi lopul hǝn aNunun aGot ale lotub̃at sor len nasoruan tiltile gail tonor hǝn nǝsa aNunun aGot tolavi mai galito. ");
INSERT INTO klv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Len nǝboŋ enan len naut a Jerusalem ikad naJu lotolotu hǝn aGot, nǝvanuan naut p̃isi lotohusur kitin hǝn na-lotu-hǝn-aGot-an. ");
INSERT INTO klv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nǝboŋ lotosǝsǝloŋ hǝn nǝwalan enan, naluṽoh logǝm b̃onb̃on nǝnauan salit ebutbutut husur lotosǝsǝloŋ lǝboi nasoruan salit ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lumaŋmaŋ, lup̃aŋ, luke, “Galit lotosor, lovi alat a Kalili m̃au? ");
INSERT INTO klv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Imabe datosǝsǝloŋ hǝn nasoruan lotopas gidat ṽisusua maii? ");
INSERT INTO klv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alat a Partia, a Mitia mai a Elam. Alat lotosuh a Mesopotamia, a Jutea mai a Kappatosia, a Pontus mai a Asia, ");
INSERT INTO klv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","alat a Frijia mai a Pamfilia, a Ijip mai tarhǝt a Lipia pǝpadaŋ hǝn naut a Sairin, mai galevis lovi metb̃os hǝn naut a Rom. ");
INSERT INTO klv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Gidat galevis datovi uleJutea a m̃o ale galevis datohusur nadǝlomian salito. Alat a Krit, alat a Arapia, gadit p̃isi datosǝsǝloŋ lǝboi galit lotosor len nasoruan sadit gabag. Lukel ur nǝyalyalan siGot len natit gai togol gail len nǝdaŋan san!” ");
INSERT INTO klv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Galit p̃isi lup̃aŋ mai lodǝdarŋab̃u. Lous galit gabag ke, “Namilen nategai imabe?” ");
INSERT INTO klv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wake galit galevis lusor viles ahai susur gail ke, “Lomun nǝwain toveveu ale lotǝrog.” ");
INSERT INTO klv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Be aPita eil mai esǝŋavur pisan esua, ale isor habat am hǝn tokel mai naluṽoh ke, “Gamit a Jutea mai gamit mǝttotoh a Jerusalem, ivoi ke gamit mǝtelǝboi naten tovisi; mǝtesǝsǝloŋ hǝn nasoruan sagw. ");
INSERT INTO klv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Naut kǝmas nǝsa mǝttonau maienan, alategai lǝsatǝrog husur namityal evi mǝlapat dudulan ŋai. ");
INSERT INTO klv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Natenan tomadhavisi, ahai kelkel ur siGot, aJoel ikele tia: ");
INSERT INTO klv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“AGot ikele ke, ‘Len nǝboŋ hǝn nanoŋan hǝn navile a pan, ginau dereh nevur san aNunugw hǝn nǝb̃ilavi mai nǝvanuan p̃isi. Natǝtai gail mai anatvavimito dereh likel ur napisulan sagw mantuhmar samit gail dereh leris narisian gail, ale haṽut samit gail dereh lipat ris nab̃ǝb̃er gail. ");
INSERT INTO klv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Dereh nevur san aNunugw hǝn nǝb̃eviol hǝni mai naslev sagw gail, alalum̃an mai alatpǝhaṽut, Ale galit dereh likel ur napisulan sagw. ");
INSERT INTO klv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dereh nigol namerikel gail len nǝmav mai natit len navile a pan mǝttomaŋmaŋ lan, nǝda, nǝhab mai nǝmaroṽ. ");
INSERT INTO klv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Namityal tegǝgel vamotmot mai nahǝbati tehum nǝda beti nǝmariboŋ namǝnas toyalyal siNasub̃ dereh tegǝmai. ");
INSERT INTO klv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Beti nǝvanuan p̃isi lotokai vi tǝban nahǝsan Nasub̃ hǝn b̃evi tarhǝt salito, gai dereh tilav kuv galit dan nǝpanismen sil nǝsaan salito.’ ");
INSERT INTO klv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“UleIsrael gail, mǝtesǝsǝloŋ hǝn nǝsa nǝb̃ikele: aYesu ta Nasaret, aGot itabtabuh lan. Ale aGot igol naten tomasil len nǝhomito, husur len aYesu egaii, aGot igol namerikel lotodaŋ, namerikel mǝttomaŋmaŋ len gail, mai namerikel lotokel kot aYesu. Gamit p̃isi mǝtolǝboi natgalenan tia. ");
INSERT INTO klv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nǝsa tovisi hǝn aYesu inor hǝn na-sor-utaut-an siGot sutuai tia. AGot eriŋi ke lǝb̃ilav aYesu mai gamito ale gamit mǝtup̃os gati len nǝhai balbal. Alat lǝsavi Ju losusupah mai gamit hǝn mǝttogol tomat len nǝhai balbal. ");
INSERT INTO klv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wake aGot ilavi dan nǝmatan. Igol imakuv dan na-pǝŋas-masuṽ-an hǝn nǝmatan, husur nǝmatan edǝdas b̃etǝgau gati. ");
INSERT INTO klv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Imagenan aTevit isor husuri ke, “‘Noris Nasub̃ akis a m̃o len ginau. Bathut totoh len nǝmatu sagw, asike nomǝtahw. ");
INSERT INTO klv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Husur enan nǝlogw ivoi, nasoruan sagw epul hǝn nahǝhaṽuran, ale len natohan sagw, nǝ-vatvat-viri-an sagw ipat len aGot. ");
INSERT INTO klv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Husur gaiug, Nasub̃ aGot, asike geriŋ gab̃ulan ginau len naut nǝmatan, asike geriŋ niben Nǝvanuan Sam̃ tib̃os nǝtan. ");
INSERT INTO klv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Goṽusan ginau hǝn nap̃isal gail hǝn nǝmauran; dereh gigol ginau nepul hǝn nahǝhaṽuran hǝn natohan sam̃.’ ");
INSERT INTO klv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Bathudud gail, nolǝboi nakitinan ale nukel mai gamit ke atǝmadato, aTevit imat tia. Lutavuni tia, ale nab̃urhes han ipat sal van vǝbar nǝboŋ damǝŋai. ");
INSERT INTO klv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Be evi ahai kelkel ur. Elǝboii ke aGot tota gat na-kel-gati-an sua todaŋ toke, avan sua len nǝpasusan siTevit dereh tegǝm vi kiŋ sum̃an aTevit. ");
INSERT INTO klv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ATevit elǝboi nǝsa b̃evisi balai, ale isor husur na-le-mǝhat-an seKristo dan nǝmatan. Ike, “‘Asike ipat len naut nǝmatan, asike niben ib̃os nǝtan.’ ");
INSERT INTO klv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Imagenan, aYesu egaii, aGot igol tole mǝhat dan nǝmatan tia, ginamit p̃isi namtoris lǝboi natenan. ");
INSERT INTO klv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Itoh tia a mǝhat len nǝtarhǝt nǝmatu siGot. Ale aTǝman eviol hǝn aNunun maii hum tokel gati tia. Ale aYesu evur san nǝsa mǝttomadharisi mai sǝsǝloŋ hǝni vi lan ginamito. ");
INSERT INTO klv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Husur aTevit savi mǝhat vi lan nǝmav, be gai sǝb̃on ike, “‘Nasub̃ aGot ikel mai aMasta sagw ke, “Gebǝtah tǝban ginau, len navǝlagw nǝmatu, ");
INSERT INTO klv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","vir nǝb̃eriŋ aenemi sam̃ gail pipit nariem̃ gǝlaru hǝn lǝb̃evi ut kǝmas.”’ ");
INSERT INTO klv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Imagenan, ivoi ke alat a Israel p̃isi lelǝboi koti ke aYesu egaii, mǝttoriŋi len nǝhai balbal, aGot igol etibau tia len na-il-a-m̃o-an, tovi Masta mai Kristo, aGot totabtabuh lan.” ");
INSERT INTO klv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nǝboŋ nǝvanuan gail lotosǝsǝloŋ hǝn nasoran enan, ibar nǝlolito ale lous aPita mai ahai pispisul gail ke, “Bathudud gail, namtimabe?” ");
INSERT INTO klv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","APita isor var galit ke, “Mitipair dan nǝsaan samito ale gamit p̃isi mitibaptais len nahǝsan aYesu Kristo hǝn aGot b̃erub̃at nǝsaan samito, beti aGot dereh teviol hǝn aNunun mai gamito. ");
INSERT INTO klv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Husur ke na-kel-gati-an enan evi samito mai sinaur p̃isi lǝb̃ehusur gamito, mai silat p̃isi lotosuh a tut, alatenan, Nasub̃ aGot sidato b̃ekis galit balai.” ");
INSERT INTO klv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Beti aPita isor ebǝlav, ikel nalǝlǝgauan mai galito, ikel taltal hǝni ke, “Mǝteus aGot hǝn b̃ilav kuv gamit dan nǝpanismen b̃ibar naur egai lotosa, lotomǝtahun aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Alat lotodǝlom nǝsa tokele, ahai pispisul lubaptais hǝn galito, ale 3,000 am lohusur aYesu len nǝboŋ enan ŋai. ");
INSERT INTO klv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Akis losǝsǝloŋ bun nǝsa ahai pispisul gail lotop̃usan hǝni, lub̃on len nǝmauran salito; lob̃ur nabǝta hǝn lotohan b̃onb̃on, ale lusor tuṽ. ");
INSERT INTO klv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nǝvanuan p̃isi lomǝtahw len nǝyalyalan siGot, husur len nǝdaŋan siGot ahai pispisul gail lugol namerikel isob̃ur toṽusani ke galit siGot. ");
INSERT INTO klv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Alat lotokad nadǝlomian losuh b̃onb̃on, natit p̃isi lotokade evi salit p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nǝboŋ lotopar tete sua, lop̃ur hǝn nǝtan o natit salit gail ale lopǝpehun nǝvat han mai galito lotom̃idol. ");
INSERT INTO klv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Len nǝboŋ p̃isi lub̃on tabtab len naholǝvat todar vis naim siGot ale nǝnauan salit esua. Lohusur naim ṽisusua salit gail lob̃ur nabǝta hǝn lotohan b̃onb̃on husur ke nǝlolit ehǝhaṽur, nǝlolit inor, ");
INSERT INTO klv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","lusal suh aGot ale luvoi, lunor len nǝnauan sinǝvanuan p̃isi. Len nǝboŋ p̃isi Nasub̃ ilav kuv galevis dan nǝsaan salito, gol ke alat lotokad nadǝlomian lusob̃sob̃ur am. ");
INSERT INTO klv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Boŋ sua aPita mai aJon arovi mǝhat len naim siGot len namityal hǝn na-sor-tuṽ-an, namityal totor ut mǝdau. ");
INSERT INTO klv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Len nǝboŋ enan nǝvanuan galevis lupat avan sua togau tia len nǝpasian. Lupati hǝn lǝb̃eriŋi ben nabopita len naholǝvat todar vis naim siGot, nahǝsan Nabopita Tokab. Loriŋ akis hǝni ei hǝn b̃eusus alat lotovi lohoim hǝn nǝvat. ");
INSERT INTO klv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nǝboŋ atenan toris aPita mai aJon pǝpadaŋ hǝn arb̃eb̃is len naim siGot, eus gǝlaru hǝn nǝvat. ");
INSERT INTO klv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","APita mai aJon arokǝta haihai lan, ale aPita ike, “Gekǝta bunus ginamǝru!” ");
INSERT INTO klv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ŋa ebǝtah mǝdau vir gǝlaru ke arb̃ilav natideh maii. ");
INSERT INTO klv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Be aPita ike, “Nǝsǝkad nǝvat nasilva o nagol ideh, avil nǝsa notokade dereh nilavi mai gaiug. Len nahǝsan aYesu Kristo ta Nasaret, gile mǝhat, giyar!” ");
INSERT INTO klv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Beti etǝgau gat navǝlan nǝmatu, elivi vi mǝhat. Vǝha-sua ŋai narien arudaŋ. ");
INSERT INTO klv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Emǝlah vi mǝhat, eil, iyaryar. Beti eb̃is len naholǝvat todar vis naim siGot mai gǝlaru, iyar, emǝlah, eputsan nahǝsan aGot van. ");
INSERT INTO klv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nǝvanuan p̃isi loris toyar, toputsan aGot van, ");
INSERT INTO klv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ale lokǝta lǝboii ke tovi ulum̃an enan tobǝtbǝtah usus nǝvat len Nabopita Tokab hǝn naim siGot. Losǝhoṽut, lumaŋmaŋ len nǝsa tovisi hǝni. ");
INSERT INTO klv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Len navǝrada siSolomon, aulum̃an enan etǝgau gat aPita mai aJon. Nǝvanuan p̃isi lugam van hǝn galito husur lup̃aŋ lan. ");
INSERT INTO klv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nǝboŋ aPita toris lotogǝm pǝpadaŋ, isor mai galit ke, “UleIsrael gail, imabe mǝttomaŋmaŋ len nateg tovisi? Husur nǝsa mǝttokǝta haihai len ginamǝru? Mǝtunau ke namrtogol toyar len nǝdaŋan sinamǝr ŋa o len nab̃oruan siGot namrtokade a? ");
INSERT INTO klv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ao! AGot siApraham, seIsak, siJakop, setǝmadato ta sutuai, aGot egai eputsan nǝvanuan nauman san, aYesu. Be gamito mǝtoriŋi len navǝlan alat aRom, mǝtomǝtahuni. Nǝboŋ aPilate toke teriŋi tivan, gamit mǝtukai tasi. ");
INSERT INTO klv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mǝtomǝtahun atenan tonor, atenan tovi siGot, ale mǝtous aPilate ke tidam̃ hǝn avan toṽabun nǝvanuan, timakuv. ");
INSERT INTO klv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Be nǝvanuan tovi nǝkadun nǝmauran, mǝtugol imat, be aGot igol ile mǝhat, imaur dan nǝmatan. Ale namtoris lǝboi natgalenan. ");
INSERT INTO klv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Len nadǝlomian san len nahǝsan aYesu, ategai mǝttorisi mai mǝttolǝboii, egǝm daŋ am. Ale mǝtoris ke nadǝlomian len aYesu ilav nǝmauran kavkav maii tia. ");
INSERT INTO klv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bathudud gail, imaiegai: Nolǝboii ke nǝsa mǝttogole tia ipar lǝboian lan, nǝvanuan toil a m̃o samito am lǝsalǝboii. ");
INSERT INTO klv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Be len nǝsa mǝttogole, aGot igol nǝsa tokele tia len nabuŋon ahai kelkel ur gail p̃isi isarpoh, ke aKristo san, gai totabtabuh lan, telǝŋon tisa habat. ");
INSERT INTO klv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Husur enan, mitipair dan nǝsaan, ale mitipair van hǝn aGot hǝn aGot b̃epipitas nǝsaan samito, ");
INSERT INTO klv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","hǝn Nasub̃ aGot b̃ilav nǝboŋ nǝŋavŋavan mai gamito, ale hǝn b̃esǝvat aKristo, gai totabtabuh lan m̃os gamito, tovi aYesu. ");
INSERT INTO klv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Gai timastoh len nǝmav vir aGot b̃igol natit p̃isi b̃inor hum tokel gati sutuai tia len nabuŋon ahai kelkel ur san gail. ");
INSERT INTO klv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","AMoses ike, ‘Nasub̃ aGot samito dereh tigol ahai kelkel ur sua samit b̃esum̃an ginau tile mǝhat dan gamit balai. Mitimassǝsǝloŋ hǝn natit p̃isi b̃ikel mai gamito. ");
INSERT INTO klv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Avan ideh asike b̃esǝsǝloŋ hǝn ahai kelkel ur enan, aGot dereh tidakuvi dan nǝvanuan san gail timasig.’ ");
INSERT INTO klv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Imaienan, ahai kelkel ur gail p̃isi, tub̃at len aSamuel van vǝbar damǝŋai, galit p̃isi lotosor, lukel ur nǝsa tovisi len nǝboŋ ta damǝŋai. ");
INSERT INTO klv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gamit m̃au mǝtovi natun ahai kelkel ur gail, ale nǝsa aGot tokel uri len nabuŋolito, eriŋi tipat m̃os gamit am. Ale na-kel-gati-an aGot tokel mai atǝmamito ta sutuai, ikele m̃os gamito. Ikel mai aApraham ke, ‘Len nǝpasusan tohusur gaiug navoian dereh tivan hǝn nǝvanuan naut tiltile gail len nǝbathuyah p̃isi len navile a pan.’ ");
INSERT INTO klv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nǝboŋ aGot toputsan nǝvanuan nauman san, tovi aYesu, esǝvati van hǝn gamito a m̃o hǝn b̃ivoi hǝn gamito len nǝpairan samit ṽisusua dan naṽide tosa samit gail.” ");
INSERT INTO klv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nǝboŋ aPita mai aJon artosor mai nǝvanuan gail, ahai tutumav gail, nakomada silat lotokǝtkǝta kǝkol hǝn naim siGot, mai naSattiusi gail, ");
INSERT INTO klv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","nǝlolit ipaŋpaŋ husur gǝlaru aroṽusan nǝvanuan gail mai arukel uri ke aYesu imaur dan nǝmatan san. Namilen ke nǝvanuan gail am lolǝboi lǝb̃imaur dan nǝmatan sum̃an aYesu. ");
INSERT INTO klv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ŋa lutah gat gǝlaru, be husur naut igomgom, loriŋ gǝlar len naim bǝbaŋis salit vir nǝboŋ pelan. ");
INSERT INTO klv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nǝvanuan isob̃ur lotosǝsǝloŋ hǝn nasoruan, lodǝlomi; lalum̃an p̃isi lotokad nadǝlomian, pǝpadaŋ hǝn lotobar 5,000. ");
INSERT INTO klv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pelan han, alat lotoil a m̃o hǝn ahai tutumav gail, ahai p̃usan gail hǝn nalo, mai alat lotoil a m̃o len naut a Jutea, galit lub̃onb̃on len naut a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas evi ab̃iltihai tutumav, aKaiafas mai aJon mai aAleksada, mai galevis am lotovi amahean aAnnas, lutoh ei. ");
INSERT INTO klv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nǝboŋ lotogol aPita mai aJon artoil rivuh, lous gǝlaru ke, “Mǝrugol nategai len nǝdaŋan sa o len nahǝsan ase?” ");
INSERT INTO klv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Beti aPita topul hǝn aNunun aGot ikel mai galit ke, “Gamit mǝttoil a m̃o hǝn ahai tutumav gail mai gamit mǝttoil a m̃o hǝn nǝvanuan gail, ");
INSERT INTO klv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","damǝŋai mǝtousus ginamǝru husur navoian namrtogole hǝn nǝvanuan narien tosa. Imaur mabe? ");
INSERT INTO klv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ginau nuke gamit mai nǝvanuan naut a Israel p̃isi mǝtelǝboi nategai ke, len nahǝsan aYesu Kristo ta Nasaret, mǝttop̃os gati tia len nǝhai balbal avil aGot togol tomaur dan nǝmatan, len nahǝsenan, ategai eil gegai, imaur. ");
INSERT INTO klv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Evi aYesu egaii natosian siGot tosor husuri nǝboŋ toke tovi, “‘nǝvat gamit mǝttovi vanuan na-um-im-an mǝttomǝtahuni; gai egǝm vi vat sua ŋai b̃elǝboi b̃igol naim b̃ihav mai b̃inor.’ ");
INSERT INTO klv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","AYesu ŋai ikad nǝdaŋan hǝn b̃ilav kuv nǝvanuan gail dan nǝsaan salito. Husur sǝkad nǝhes ideh am len navile a pan, sǝkad nǝhes ideh am aGot tolav mai nǝvanuan gail tolǝboi b̃ilav kuv gadito dan nǝpanismen hǝn nǝsaan sadito.” ");
INSERT INTO klv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nǝboŋ lotokǝta lǝboii ke aPita mai aJon arsamǝtahw len galito, lumadhalǝboii ke arsasǝkul mai arovi vanuan hum nǝvanuan lǝsǝkad namitisau. Lup̃aŋ, lunau lǝboii ke alaruenan arutah mai aYesu a m̃o. ");
INSERT INTO klv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Be husur lotoris aulum̃an tomaur toil tǝban gǝlaru, lǝsalǝboi lǝb̃ikel natideh. ");
INSERT INTO klv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ŋa lukel mai gǝlaru ke arevivile, bathut luke lihol husur gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Luke, “Datimab hǝn gǝlaru? Imasil len nǝvanuan gail p̃isi len naut a Jerusalem ke arugol namerikel len nǝdaŋan savi sǝlaru. Datsalǝboi datb̃ike savisi. ");
INSERT INTO klv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Be hǝn b̃igol ke satevivile len nǝvanuan gail p̃isi, ivoi ke datikai tas gǝlaru ke saarisor mai saarep̃usan am len nahǝsan aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nǝboŋ lotokis gǝlaru gǝmai, lukai tas gǝlaru ke saarisor mai saarep̃usan tǝtas am len nahǝsan aYesu. ");
INSERT INTO klv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Avil aPita mai aJon arusor var galit ke, “Inor len nabunusian siGot ke namrigol nǝsa aGot tokele o gamito? Mitinau risi! ");
INSERT INTO klv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ginamǝru, asike namresib, namrodǝdasi. Namrimaskel husur nǝsa namrtorisi mai sǝsǝloŋ hǝni.” ");
INSERT INTO klv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Beti lukel mai gǝlaru tǝtas ke arb̃isor len nahǝsan aYesu am dereh aripanis, ale lugol aruvan. Lǝsǝsab̃ nap̃isal ideh hǝn lǝb̃ipansem gǝlaru bathut nǝvanuan gail p̃isi loputsan nahǝsan aGot husur nǝsa tovisi. ");
INSERT INTO klv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Husur atenan, narien tosa a m̃o be tomaur husur namerikel, nǝdam̃ han tosǝhor 40. ");
INSERT INTO klv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nǝboŋ aPita mai aJon artokad navivilean, arotǝlmam van hǝn nǝvanuan sǝlar gail. Ale arukel ur nǝsa ab̃iltihai tutumav gail mai alat lotoil a m̃o len naut a Jutea, lotokele. ");
INSERT INTO klv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nǝboŋ nǝvanuan nadǝlomian lotosǝsǝloŋ hǝni, len nǝnauan sua lub̃on hǝn lǝb̃ikai van hǝn aGot. Luke, “O Got gotovi Masta hǝn natit p̃isi, gaiug m̃au gugol nǝmav mai navile a pan, nǝtas mai natit p̃isi lotopat. ");
INSERT INTO klv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gaiug m̃au gusor, len aNunum̃ gusor len nabuŋon atǝmanamit ta sutuai aTevit, nǝvanuan nauman sam̃, ke, “‘Imab naluṽoh hǝn nǝvanuan naut tiltile gail nǝlolit ipaŋpaŋ? Imab nǝvanuan gail lusor utaut hum lotovi enemi siNasub̃ aGot? Lusor utaut sob̃uer. ");
INSERT INTO klv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nakiŋ gail len navile a pan loutaut hǝn nǝb̃alan, alat lotoil a m̃o hǝn nǝvanuan gail lub̃on hǝn lǝb̃ib̃al mai Nasub̃ aGot mai aKristo san, gai totabtabuh lan.’ ");
INSERT INTO klv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Len nab̃iltivile egai aHerot Antipas mai aPontius Pilate arub̃onb̃on mai alat lǝsavi Ju mai alat a Israel hǝn lǝb̃emǝtahun nǝvanuan nauman sam̃ gotosǝvati, aYesu, gototabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bathut gaiug Got, gudaŋ habat, galit lugol husur nǝsa ŋai gotonau utaut hǝni, nǝsa gotonau koti sutuai tia. ");
INSERT INTO klv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nasub̃ aGot, bunus nasoran salit ke lipansem ginamito beti, ale gilav na-il-b̃uri-an mai ginamit namtovi slev sam̃ gail, hǝn namtb̃ikel ur nasoruan sam̃. ");
INSERT INTO klv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nǝboŋ namtb̃ikel uri, gigol nǝvanuan gail lǝb̃imaur mai gigol namerikel lǝb̃emaŋmaŋ len gail. Natgalenan lǝb̃evisi, dereh levisi len nahǝsan nǝvanuan nauman sam̃ gotosǝvati, aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nǝboŋ lotosor tuṽ tonoŋ, naut lotob̃onb̃on lan ekurkur; ale galit p̃isi lopul hǝn aNunun aGot mai lukel ur nasoruan siGot len na-il-b̃uri-an. ");
INSERT INTO klv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nǝvanuan nadǝlomian gail p̃isi lub̃on, len nǝnauan mai nǝlolito losua ale sǝkad avan ideh toke natideh san, evi esan ŋai, be natit p̃isi losum̃an salito. ");
INSERT INTO klv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Len nab̃iltidaŋan seNunun aGot, ahai pispisul gail lukel uri ke, aGot igol aYesu Kristo ile mǝhat dan nǝmatan. Ale aGot ivoi habat hǝn galito. ");
INSERT INTO klv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Husur sǝkad ideh len galito tom̃idol hǝn natideh. Husur alat lotokad nǝtan o naim, lop̃ur hǝn gail ale lulav nǝvat ");
INSERT INTO klv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","hǝn lǝb̃eriŋi bathurien ahai pispisul gail. Ale lopǝpehun nǝvat hǝn b̃evi tarhǝt sinǝvanuan ideh topar. ");
INSERT INTO klv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ikad avan sua, nahǝsan aJosef len nahǝmar aLevi tovi auleSaiprus. Atenan, ahai pispisul gail lokisi hǝn aParnapas, (namilen ke, “Nǝvanuan togol nǝvanuan gail lolǝŋon ivoi am len nǝlolito”). ");
INSERT INTO klv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","AParnapas ep̃ur hǝn nǝmarireu sua san ale ilav nǝvat han hǝn toriŋi bathurien ahai pispisul gail. ");
INSERT INTO klv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Naulum̃an sual am, nahǝsan aAnanias mai asoan nahǝsan aSafira arop̃ur hǝn nahudhutan. ");
INSERT INTO klv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias etǝgau gat nahudhuvat hǝn nǝtan enan mai asoan. Gǝlar p̃isi arudam̃. Beti atenan ilav nahudhuvat topat hǝn b̃eriŋi bathurien ahai pispisul gail, be sǝlav p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ale aPita ike, “Ananias, imabe nǝlom̃ topul hǝn aSetan gol ke gotogǝras aNunun aGot ale gototǝgau gat nahudhuvat hǝn nǝtan? ");
INSERT INTO klv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nǝtan gotop̃ur hǝni evi nǝtan esam̃ m̃au? Ale nǝboŋ gotop̃ur hǝni tonoŋ nǝvat ipat len navǝlam̃ m̃au? Nǝlom̃ imabe hǝn gotogol natenan? Gaiug gǝsagǝras nǝvanuan gail ŋai, gogǝras aGot!” ");
INSERT INTO klv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nǝboŋ aAnanias tosǝsǝloŋ hǝn nasoruan enan, iteh, imat. Ale galit p̃isi lotosǝsǝloŋ hǝn nǝsa tovisi lomǝtahw habat. ");
INSERT INTO klv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Beti nǝmantuhmar gail logǝm, ruŋ gol niben, pati vivile ale tavuni. ");
INSERT INTO klv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nǝhaua itor ivan husur nǝmatan enan ale asoan eb̃is, avil salǝboi nǝsa tovisi. ");
INSERT INTO klv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","APita eus aliten ke, “Gikele, nǝvat hǝn nǝtan mǝrtop̃ur hǝni imagegai a?” Ale ike, “Evoi, imagenan.” ");
INSERT INTO klv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ŋa aPita ikel maii ke, “Imabe mǝrtotaltal kitev nǝdaŋan seNunun aGot ke timabe? Geris, alat lototavun asoam̃ saltoil bopita. Galit dereh lipat gaiug tu vivile.” ");
INSERT INTO klv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vǝha-sua ŋai iteh bathurien aPita, imat. Amantuhmar gail lovi lohoim, sab̃i ke tomat tia, ale lupati vivile, lutavuni mai asoan. ");
INSERT INTO klv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Alat siYesu p̃isi lomǝtahw, galit mai alat lotosǝsǝloŋ hǝn naholan husur nǝsa tovisi. ");
INSERT INTO klv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Len navǝlan ahai pispisul gail, aGot igol namerikel gail ben nǝvanuan gail, ale galit p̃isi lotokad nadǝlomian lub̃onb̃on akis len navǝrada siSolomon. ");
INSERT INTO klv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bathut namǝtahwan, avan ideh am sǝtah mai galito. Be nǝvanuan gail loputsan galit len nǝnauan salito. ");
INSERT INTO klv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Be akis alat lotokad nadǝlomian len Nasub̃ lusob̃sob̃ur am, Lalum̃an isob̃ur mai latpǝhaṽut isob̃ur. ");
INSERT INTO klv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Imaienan, nǝvanuan gail lupat alat lotomǝsah vi lan nametp̃isal, loriŋ galito lupat len nǝmel o nǝbateh hǝn ke nǝm̃ol hePita tibar galevis nǝboŋ toṽot van. ");
INSERT INTO klv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nǝvanuan lusob̃ur logǝm dan navile gail pǝpadaŋ hǝn naut a Jerusalem, lutariv alat lotomǝsah, mai alat nanunun lotosa lotomǝdas tabtab hǝn galito. Ale galit p̃isi lumaur. ");
INSERT INTO klv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Imaienan, ab̃iltihai tutumav mai alat lototah maii, (lovi naSattiusi gail) lutab̃ulol bulos ahai pispisul gail. ");
INSERT INTO klv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Lutah gat galito ale loriŋ galito len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Avil len nalenmariug enan aŋel siNasub̃ esǝŋav hǝn nabopita hǝn naim bǝbaŋis ale esǝhar galit vivile. Ike, ");
INSERT INTO klv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mitivan, mǝteil len naholǝvat todar vis naim siGot ale kel ur p̃is nasoruan husur nǝmauran veveu egai mai galit ei, nǝmauran mǝttokade len aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dudulan som̃ilan lob̃is len naholǝvat todar vis naim siGot sum̃an aŋel tokel mai galito, ale lotub̃at ṽusan nǝvanuan gail. Nǝboŋ ab̃iltihai tutumav mai alat lototah maii lotogǝmai, lokis nǝSanhitrin hǝn lǝb̃ib̃onb̃on, galit p̃isi lotobǝtah len nab̃onb̃onan silat lotoil a m̃o len naut a Israel. Ale losǝvat nǝvanuan galevis hǝn lǝb̃esǝhar kuv ahai pispisul gail dan naim bǝbaŋis gǝmai. ");
INSERT INTO klv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Be nǝvanuan nauman galenan lǝsǝsab̃ galit len naim bǝbaŋis ŋa lotǝlmam, lukel uri ke, ");
INSERT INTO klv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Namtusab̃i ke naim bǝbaŋis ekǝkol sal, mai alat lotokǝtkǝta kǝkol hǝni, loil vivile len nabopita gail, be nǝboŋ namttosǝŋav hǝn gail, naut eb̃ǝb̃esw.” ");
INSERT INTO klv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nǝboŋ nakomada silat lotokǝtkǝta kǝkol hǝn naim bǝbaŋis mai ab̃iltihai tutumav gail lotosǝsǝloŋ hǝn na-kel-uri-an enan, nǝnauan salit ebutbutut. Lunau masuṽ hǝn ke timabe. ");
INSERT INTO klv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Beti avan sua egǝm, ike, “Mǝteris! alategaii mǝttoriŋ galit len naim bǝbaŋis, galito saltoil len naim siGot, loṽusan nǝvanuan gail!” ");
INSERT INTO klv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ale nakomada ivan mai alat lotokǝtkǝta kǝkol hǝn naim siGot hǝn lǝb̃esǝhar ahai pispisul gail. Losǝhar mǝdau hǝn galito husur lomǝtahw ke nǝvanuan gail saletubun galito. ");
INSERT INTO klv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nǝboŋ lotosǝhar galit tonoŋ, lugol loil len nǝhon nǝSanhitrin ale ab̃iltihai tutumav eus galit ");
INSERT INTO klv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ke, “Namtukai tas gamito ke samtep̃usan len nahǝsenan. Be mǝteris! Mǝtugol alat a Jerusalem lopul hǝn nap̃usanan samito, mai mǝtukel ke namtugol nǝmatan sitenan.” ");
INSERT INTO klv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","APita mai ahai pispisul gail lusor vari ke, “Ginamit namtimasgol husur nǝsa aGot tokele sǝhor nǝsa nǝvanuan gail lotokele. ");
INSERT INTO klv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","AGot setǝmadat ta sutuai igol aYesu ile mǝhat dan nǝmatan, aYesu mǝttoṽabuni, tahǝtah hǝni len nǝhai. ");
INSERT INTO klv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Atenan, aGot eputsani vi lan navǝlan nǝmatu, gol ke eil a m̃o hǝn nǝvanuan p̃isi mai elǝboi b̃ilav kuv galit dan nǝsaan salito. AGot igol nategai hǝn aYesu b̃igol gidat a Israel datb̃ipair dan nǝsaan sidato ale hǝn b̃erub̃at nǝsaan galen dan gidato. ");
INSERT INTO klv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ginamit namtoris natgalen tovisi ale namtukel uri, ginamit mai aNunun aGot, aGot toviol hǝni mai alat lotogol husur nǝsa tokele.” ");
INSERT INTO klv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nǝboŋ lotosǝsǝloŋ hǝni, nǝlolit ipaŋpaŋ masuṽ, luke letubun aPita galito. ");
INSERT INTO klv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Be naFarisi sua, nahǝsan aKamaliel, ahai p̃usan hǝn nalo, nǝvanuan p̃isi lotoputsani len nǝnauan salito, ile mǝhat, isor idaŋ ke ahai pispisul gail litoh vivile kǝkereh bai. ");
INSERT INTO klv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nǝboŋ lotovivile tonoŋ ikel p̃uli mai nǝSanhitrin ke, “UleIsrael, mǝtebunus tivoi nǝsa mǝttoke mǝtb̃igole hǝn alatenan. ");
INSERT INTO klv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mitinau! Nasihau galevis tovan tia, nǝvanuan sua tosa, aTeutas, evisi, isor patpat gai mǝhat, ale alalum̃an lovi 400 lutah maii. Be alat a Rom luṽabuni ale alat lotohusuri lopǝpehw ŋa lǝsagol natideh. ");
INSERT INTO klv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Husuri, sual am, aJutas, auleKalili evisi len nǝboŋ hǝn nap̃uruŋan hǝn nǝvanuan, ale egǝras nǝvanuan gail hǝn lǝb̃ehusuri, b̃al mai alat a Rom. Gai am luṽabuni, ale ahai susur san gail, lopǝpehw. ");
INSERT INTO klv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Imagenan, nukele hǝn gamito ke, mititoh a tut dan galito, riŋ galit livan, husur nǝ-nau-utaut-an salit mai nǝsa lǝb̃igole b̃evi sinǝvanuan, dereh lehisi sob̃uer sum̃an alaruenan. ");
INSERT INTO klv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Be b̃evi siGot, mǝtedǝdas mǝtb̃emǝdas galito; dereh mitisab̃i ke mǝttob̃al mai aGot.” ");
INSERT INTO klv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ale lohusur nakelean san. Lokis galito vi lohoim. Lugol alat lotokǝtkǝta kǝkol hǝn naim siGot lobilas galito, beti lukele hǝn galito ke salisor len nahǝsan aYesu, ale loriŋ galit luvan. ");
INSERT INTO klv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nǝboŋ ahai pispisul lotoriŋ nǝSanhitrin, lukemkem husur aGot idam̃ hǝn ke lotolǝŋon tosa m̃os nǝhes enan. ");
INSERT INTO klv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ale len nǝboŋ p̃isi len naholǝvat todar vis naim siGot lop̃usan, ale lop̃usan husur naim gail, mai lukel uri ke aKristo, aGot totabtabuh lan evi Yesu. Lǝsanoŋ hǝn nakelean enan. ");
INSERT INTO klv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Len nǝboŋ galenan ahai susur gail, alat lotokad nadǝlomian, lusob̃sob̃ur am. Ale naJu gail lotosor len nasoruan ta Kris lukoblen ke, alat lotosor len nasoruan Ipru lǝsapǝpehun nǝhanian sanor len nǝbatunau pǝhaṽut lotosor len nasoruan ta Kris. ");
INSERT INTO klv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Imagenan, ahai pispisul tosǝŋavur pisan toru lokis nǝvanuan nadǝlomian p̃isi logǝm b̃onb̃on beti luke, “Sanor hǝn ginamit namtb̃eriŋ gab̃ulan na-kel-uri-an hǝn nasoruan siGot hǝn namtb̃epǝpehun nǝhanian. ");
INSERT INTO klv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bathudud gail mitilekis hǝn temǝlevru len gamit lotopul hǝn aNunun aGot mai namitisau hǝn nǝmauran tonor. Ale dereh namteriŋ galit hǝn lǝb̃igol nauman egai. ");
INSERT INTO klv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ale ginamit dereh namtb̃idaŋ len na-sor-tuṽ-an mai na-kel-uri-an hǝn nasoruan siGot.” ");
INSERT INTO klv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Galit p̃isi lohǝhaṽur hǝn nǝnauan sihai pispisul gail. Lulekis hǝn aSteven, aulum̃an sua topul hǝn nadǝlomian mai aNunun aGot. Beti lulekis hǝn aFilip, aProkorus, aNikanor, aTimon, aParmenas mai aNikolas ta Antiok togǝm vi Ju. ");
INSERT INTO klv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Naluṽoh losǝhar galit gǝm hǝn ahai pispisul gail, ale ahai pispisul lusor tuṽ m̃os galit lotomǝlevru, loriŋ navǝlalito len nǝkadulito hǝn lǝb̃igol nauman enan. ");
INSERT INTO klv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ŋa nasoruan siGot husur aYesu iperperŋan naut. Ahai susur len naut a Jerusalem nasob̃uran halito evi mǝhat tutut, ale ahai tutumav isob̃ur lugol husur nǝsa nap̃usanan siYesu tokele. ");
INSERT INTO klv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","AGot eviol masuṽ hǝn navoian mai nǝdaŋan mai aSteven. Ale aSteven igol namerikel tǝban nǝvanuan gail. Lumaŋmaŋ len namerikel galenan ale nǝdaŋan siGot imasil len gail. ");
INSERT INTO klv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Be nǝvanuan galevis lusor tas aSteven. Galito lovi Ju hǝn naluṽoh sua lokisi hǝn Naim Nab̃onb̃onan seFriman. Lovi Ju ta Sairin, ta Aleksadria, ta Silisia, ta Asia, ale loil, lusor b̃alb̃al mai aSteven. ");
INSERT INTO klv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Be nǝboŋ tosor, aNunun aGot eviol hǝn namitisau hǝn nǝmauran tonor maii, gol ke lodǝdas lǝb̃isor vari. ");
INSERT INTO klv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ale galito lusor utaut mai nǝvanuan galevis hǝn lǝb̃isor tas aSteven ke, “Namtosǝsǝloŋ hǝn atenan tosor mǝdas aMoses mai aGot!” ");
INSERT INTO klv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Imagenan lugol nǝvanuan gail nǝlolit ipaŋpaŋ, galit mai alat lotoil a m̃o hǝn galito mai ahai p̃usan gail hǝn nalo. Beti lutah gat aSteven, lugol eil len nǝhon nǝSanhitrin. ");
INSERT INTO klv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ale losǝhar nǝvanuan galevis vi rivuh hǝn lǝb̃elibliboŋ. Luke, “Akis ategai isor tas naim egai tolo mai nalo siMoses. ");
INSERT INTO klv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Husur namtosǝsǝloŋ hǝni toke aYesu ta Nasaret egaii dereh tigol naut egai timasirsir ale tegǝgel hǝn naṽide aMoses tolav mai gidato ta sutuai.” ");
INSERT INTO klv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Alat lotobǝtah len nǝSanhitrin lokǝta bunus aSteven, loris ke nǝhon egǝm sum̃an nǝhon aŋel. ");
INSERT INTO klv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Beti ab̃iltihai tutumav eusi ke, “Natgalenan imagenan a?” ");
INSERT INTO klv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ale aSteven isor vari ke: “Wawa gail mai tata gail, mǝtesǝsǝdariŋ! AGot, tovi nǝkadun namǝnas evisi hǝn atǝmadit ta sutuai aApraham nǝboŋ totoh a Mesopotamia, be savi Haran sal. ");
INSERT INTO klv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ale aGot ikel maii ke, ‘Geriŋ naut egai, naut matmat sam̃, mai nǝbathudud sam̃, ale gevi lan naut nǝb̃esǝhar gaiug vi lan.’ ");
INSERT INTO klv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Imagenan aApraham eriŋ naut san, naut silat a Kaltea, ale iyar vi Haran, itoh ei. Nǝboŋ atǝman tomat, aGot esǝvati vi lan naut egai mǝttotohtoh lan. ");
INSERT INTO klv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Len nǝboŋ enan aGot sǝlav nǝtan ideh gegai mai aApraham hǝn b̃evi naut matmat san; sǝlav nǝmap̃irhǝtan ideh maii. Be aGot ikel gati maii ke tilav naut egai mai aApraham mai nǝpasusan san lotohusuri, naut kǝmas ke len nǝboŋ enan aApraham sǝkad anatun. ");
INSERT INTO klv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Beti aGot ekǝmaiegai ke, ‘Nǝpasusan sam̃ gail lotohusur gaiug dereh levi metb̃os gail len naut tile, naut savi salito. Dereh legǝm vi slev silat ei. Ale alat ei dereh lemǝdas galito hǝn nasihau b̃evi 400.’ ");
INSERT INTO klv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ale aGot ike, ‘Avil ginau dereh nipansem alat naut enan lotogol nǝpasusan sam̃ lotoumum kǝmas salito. Beti nǝpasusan sam̃ dereh limakuv dan naut ei, gǝm lotu hǝn ginau gegai.’ ");
INSERT INTO klv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Beti aGot ikel na-kel-gati-an mai aApraham ke aApraham mai esan gail lovi siGot. Ale aGot ikel maii ke tetiv dalus gai mai naulum̃an san gail hǝn b̃eṽusani ke lovi siGot. Ale aApraham etiv dalus aIsak, anatun len nǝboŋ san tomǝlevtor, ale aIsak egǝm vi tǝman aJakop togǝm vi tǝman atǝmadit ta sutuai lotovi 12. ");
INSERT INTO klv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Anatun aJakop galenan lutab̃ulol bulos aṽalito, aJosef, ŋa lop̃ur hǝni vi lan naut a Ijip. Be aGot itah maii, ");
INSERT INTO klv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ale aGot ilav kuvi dan na-lǝŋon-isa-masuṽ-an san. Ilav namitisau hǝn nǝmauran tonor mai aJosef gol ke aFero, tovi kiŋ len naut a Ijip, inau ke tovoi. Imagenan aFero igol ke a Ijip mai naut san gail lupat pipihabǝlan aJosef. ");
INSERT INTO klv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sǝdareh nǝhanian imat p̃isi len naut a Ijip mai naut a Kenaan. Nibelit evi pan husur lupar hanian; atǝmadit gail ta sutuai, galit am lupar hanian. ");
INSERT INTO klv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nǝboŋ aJakop tosǝsǝloŋ hǝni ke tokad nǝhanian len naut a Ijip, esǝvat atǝmadit gail len nǝyaran nametǝkav salito. ");
INSERT INTO klv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Len nǝyaran na-vǝha-ru-an salito vi Ijip, aJosef ikel mai aṽan gail ke gai tovi aṽalito, husur lǝsakǝta lǝboii. Len nǝboŋ enan aFero esǝsǝloŋ hǝn naholan husur nǝbathudud siJosef. ");
INSERT INTO klv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Beti aJosef episul hǝn atata san, aJakop, mai nǝbathudud san kavkav hǝn lǝb̃egǝmai; lovi 75 p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ale aJakop ibar naut a Ijip. Itoh tin ei, ale len naut enan imat, atǝmadit lotovi anatun gail, galit am, lumat. ");
INSERT INTO klv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nǝpasusan gail lupat tǝlmam hǝn nibelit vi Sekem ale lutavun galito len nab̃ur aApraham top̃ur kuvi dan anatun aHamor gail.” ");
INSERT INTO klv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ale aSteven isor tǝtas am ke, “Avil len nǝboŋ togǝm pǝpadaŋ hǝn aGot b̃igol nǝsa tokel gati mai aApraham, nasob̃uran hǝn atǝmadit a Ijip evivi mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nakiŋ sua tile salǝboi natideh husur aJosef, eil a m̃o len naut a Ijip. ");
INSERT INTO klv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gai emǝdas bun nǝvanuan sidato gail. Igol atǝmadit ta sutuai nǝlolit isa habat bathut italtal hǝn galit ke leriŋ gab̃ulan amas salito hǝn lǝb̃imat. ");
INSERT INTO klv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Len nǝboŋ enan lupas aMoses, ale gai ikab buni, aGot ehǝhaṽur hǝni. Anan mai atǝman arokǝtkǝta tǝban len naim sǝlaru van vǝbar nahǝbati totor han. ");
INSERT INTO klv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Beti nǝboŋ artoriŋi vivile, anatvavin aFero isab̃i, ipati van vahisi sum̃an tovi anatun. ");
INSERT INTO klv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ahai p̃usan gail lotovi uleIjip loṽusan aMoses hǝn nalǝboian p̃isi hǝn naut a Ijip, ale ikad namitisau hǝn nǝsa tokele mai nǝsa togole. ");
INSERT INTO klv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nǝboŋ nǝdam̃ hiMoses tovi 40, ike tivan hǝn b̃eris nǝbathudud san, auleIsrael gail, ke, lumabe. ");
INSERT INTO klv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nǝboŋ tovan, eris auleIjip tobilas auleIsrael, ŋa evi tarhǝt san, ale esisil hǝn auleIjip enan, etuh buni. ");
INSERT INTO klv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","AMoses inau ke auleIsrael gail lǝtalǝboii ke aGot tosǝvati hǝn b̃ilav kuv galito dan navǝlan alat a Ijip, be lǝsalǝboii. ");
INSERT INTO klv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pelan han ŋai aMoses eris auleIsrael eru artob̃al. Ike tigol arikad navoivoian mai gǝlar gabag ale ikel mai gǝlaru ke, ‘Gamǝru mǝrovi larmiṽan; imabe mǝrub̃al maiegai?’ ");
INSERT INTO klv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Be atenan togol tosa hǝn togon, ikabsan aMoses, ike, ‘Ase igol gaiug gotoil a m̃o, hǝn gǝb̃ikel ke namtunor o namtsanor? ");
INSERT INTO klv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Guke getuh bun ginau hum gototuh bun auleIjip nino a?’ ");
INSERT INTO klv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nǝboŋ aMoses tosǝsǝloŋ hǝn nasoran enan, igam yav vi Mitian. Itoh ei hum nametb̃os, ilah, ikad anatun ulum̃an eru. ");
INSERT INTO klv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Husur nasihau tovi 40 tovan, aŋel sua evisi hǝn aMoses len nǝhai sua topaŋ wunwun len naut masmas tob̃ǝb̃esw, pǝpadaŋ hǝn nab̃iltiṽehuh Sinai. ");
INSERT INTO klv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nǝboŋ aMoses torisi, imaŋmaŋ lan, ivan pǝpadaŋ hǝni hǝn b̃ekǝta bunusi, ale esǝsǝloŋ hǝn nadolon Nasub̃ aGot toke: ");
INSERT INTO klv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ginau novi Got setǝmam̃ gail ta sutuai, aGot siApraham, seIsak mai siJakop.’ Ninen aMoses epil habat ale emǝtahun b̃ekǝta husur emǝtahw masuṽ. ");
INSERT INTO klv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Beti Nasub̃ aGot ikel maii ke, ‘Dakuv naributbut sam̃ gǝlaru; nǝtan gotoil lan ilo. ");
INSERT INTO klv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nokǝta ris kitin hǝni ke alat a Ijip lomǝdas nǝvanuan sagw gail. Nosǝsǝloŋ hǝn nakiloban salito ŋa nogǝm hǝn nǝb̃ilav kuv galito. Ale gegǝmai! Nesǝvat gaiug vi Ijip.’” ");
INSERT INTO klv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ASteven isor van am ke, “Imaienan, lomǝtahun atenan, aMoses, nǝboŋ lotoke, ‘Ase igol gaiug gotoil a m̃o, gotokel ke namtunor o namtsanor?’ Be aGot m̃au esǝvat atenan hǝn b̃eil a m̃o hǝn galito ale hǝn b̃ilav kuv galito. Len nabuŋon aŋel tovisi hǝn aMoses len nǝhai topaŋ, aGot esǝvati. ");
INSERT INTO klv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","AMoses enan esǝhar galit dan naut a Ijip ale len naut a Ijip, len Nǝtas Bisibis, mai len naut masmas tob̃ǝb̃esw len nasihau tovi 40 am, igol namerikel lotomaŋmaŋ len gail, namerikel galen lugol nǝdaŋan siGot ip̃arp̃ar. ");
INSERT INTO klv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Evi aMoses boh tokel mai alat a Israel ke, ‘AGot dereh tigol ahai kelkel ur sua samito sum̃an ginau tile mǝhat dan gamit balai.’ ");
INSERT INTO klv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","AMoses enan itoh mai galito nǝboŋ lotob̃on len naut masmas tob̃ǝb̃esw, itoh mai aŋel tosor maii len nab̃iltiṽehuh Sinai, ale itoh mai atǝmadit gail; ale aGot ilav nasoruan tomaur maii hǝn b̃ilavi mai gidato. ");
INSERT INTO klv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Avil atǝmadit ta sutuai lǝsagol nǝsa aMoses tokele. Lomǝtahun lǝb̃ehusuri am, luke letǝlmam vi Ijip. ");
INSERT INTO klv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Lukel mai aAron ke, ‘Geum hǝn nagot gail m̃os gidato hǝn lǝb̃eil a m̃o hǝn gidato. Be aMoses enan tosǝhar gidato dan naut a Ijip, datsalǝboi nǝsa tovisi hǝni!’ ");
INSERT INTO klv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ale len nǝboŋ enan lugol nǝlablab sua hun natuhb̃uluk. Lotutumav hǝn naviolan salit van hǝni, ale lohǝhaṽur tǝban nǝlablab lotogole hǝn navǝlalito. ");
INSERT INTO klv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Be aGot ipair dan galito ale eriŋ gab̃ulan galit hǝn lǝb̃ilotu hǝn nǝyal, nahǝbati mai nam̃eso gail len nǝmav. Ehum ahai kelkel ur gail lotokele len nalob̃ulat salito ke, “‘Alat a Israel, mǝtotibun narivatvat gail hǝn natutumavan len nasihau tovi 40 len naut masmas be mǝtsatutumav hǝn naviolan galenan van hǝn ginau! ");
INSERT INTO klv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ao, mǝtob̃uruŋ naim nǝtap̃olen sinagot Molek, mǝtupati mai nǝlablab hǝn nam̃eso siRefan, nagot samito; mǝtugol nǝlablab eru enan hǝn mǝtb̃ilotu hǝn gǝlaru. Imagenan dereh nigol gamit mǝtemǝsev vi tut sua sǝhor naut a Papilon.’” ");
INSERT INTO klv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ASteven isor am ke, “Len naut masmas tob̃ǝb̃esw atǝmadit gail ta sutuai lukad naim nǝtap̃olen siGot togol natohan siGot mai galito top̃arp̃ar. Loum hǝni sum̃an aGot tokele mai aMoses, ale ep̃itoṽ hǝn nǝplan aMoses torisi tia len nab̃iltiṽehuh Sinai. ");
INSERT INTO klv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Beti galito lupati gǝmai nǝboŋ aJosua toil a m̃o hǝn galito. Lupati nǝboŋ lotolav nǝtan simetb̃os gail aGot tohut galit dani m̃os atǝmadit gail. Ale ipat magenan van vǝbar nǝboŋ siTevit. ");
INSERT INTO klv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","AGot ehǝhaṽur hǝni, ale aTevit eus aGot hǝn b̃eum hǝn naim natohtohan m̃os aGot siJakop. ");
INSERT INTO klv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Be aSolomon boh eum hǝn naim enan. ");
INSERT INTO klv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Wake aGot toyalyal buni satohtoh len naim nǝvanuan gail lotoum hǝni. Esum̃an Nasub̃ aGot tokele len nabuŋon ahai kelkel ur toke: ");
INSERT INTO klv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Novi kiŋ, nǝmav ehun nab̃iltihai bǝtbǝtah sagw ale navile a pan ehun nakes kǝmas notoriŋ nariegw lan. Mǝtolǝboi mǝtb̃eum hǝn naim tomabe sagw? O naut tomabe hǝn nǝb̃iŋavŋav lan? ");
INSERT INTO klv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aoa! mǝtodǝdas mǝtb̃igole husur ke ginau sǝb̃ogw ŋai nugol natgalen p̃isi.’” ");
INSERT INTO klv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ale aSteven imaris kotov nasoran san ke, “Gamit nǝkadumit ihaihai masuṽ. Nǝlomit imabe? Nǝdariŋamit eb̃ulb̃ulol! Mǝtop̃itoṽ hǝn atǝmamit gail ta sutuai. Mǝtomǝtahun aNunun aGot akis! ");
INSERT INTO klv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mǝtunau tǝlmam hǝn ahai kelkel ur ideh atǝmamit gail lǝsamǝdasi a? Ao, lomǝdas galit van van van vagol nǝmatan hǝn alat lotopǝhav utaut hǝn nagǝmaian siVanuan Nanoran. Atenan, mǝtumadhariŋi len navǝlan aenemi san gail gol ke lutahǝtah hǝni imat! ");
INSERT INTO klv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gamito mǝtukad nalo siGot aŋel gail lotolav mai gamito, be mǝtsagol husur nǝsa tokele.” ");
INSERT INTO klv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nǝboŋ nǝSanhitrin lotosǝsǝloŋ hǝn aSteven, nǝlolit ipaŋpaŋ masuṽ van lukat b̃ub̃ur nariṽolit van hǝni. ");
INSERT INTO klv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Be aSteven topul hǝn aNunun aGot, ekǝta haihai vi lan nǝmav ale eris namǝnas siGot mai aYesu toil len nǝtarhǝt nǝmatu siGot. ");
INSERT INTO klv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ike, “Mǝteris! Nokǝta ris nǝmav tosǝŋav ale aNatun Nǝvanuan toil len nǝtarhǝt nǝmatu siGot.” ");
INSERT INTO klv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lukai masuṽ, p̃on gol nǝdariŋalito, m̃ur van hǝni, ");
INSERT INTO klv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","liv gargari vi tut dan nab̃iltivile, ale tub̃at hǝn lǝb̃etuṽi. Ale alat lotosǝsǝloŋ hǝni loriŋ nahurabat salit gail len narien aSol, nǝmantuhmar sua. ");
INSERT INTO klv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nǝboŋ lototuṽtuṽi, aSteven isor tuṽ ke, “Nasub̃ aYesu, gilav nanunugw.” ");
INSERT INTO klv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Beti etǝŋedur ale ikai habat ke, “Nasub̃, sagipansem galit sil nǝsaan egai salito.” Nǝboŋ tokǝmaienan tonoŋ, imat. ");
INSERT INTO klv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ale aSol itoh ei, idam̃ mai galit lototubun aSteven. Tub̃at len nǝboŋ enan nǝvanuan gail lomǝdas tabtab hǝn alat siYesu len naut a Jerusalem. Ŋa galit p̃isi loriŋ naut enan, lugam pǝpehw vi lan naut p̃isi len naprovens Jutea mai a Samaria. Be ahai pispisul gail losuh. ");
INSERT INTO klv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Alatevis lotohusur kitin hǝn aGot lutavun aSteven mai lutaŋis habat hǝni. ");
INSERT INTO klv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Len nǝboŋ enan aSol emǝdas bun alat siYesu. Ehusur naim gail ṽisusua, ale eliv gargar alalum̃an mai alatpǝhaṽut hǝn b̃eriŋ galit len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Alat lotopǝpehw lukel ur nasoruan husur aYesu len naut p̃isi lotobari. ");
INSERT INTO klv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Galit sua, aFilip evi pan vi lan nab̃iltivile a Samaria, ale ikel uri ei ke, aYesu tovi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nǝboŋ naluṽoh gail lotosǝsǝloŋ hǝn aFilip, kǝta ris namerikel togol gail, galit p̃isi losǝsǝloŋ vahvahur nǝsa tokele. ");
INSERT INTO klv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Husur ehut nanunun tosa gail lotois habat nǝboŋ lotomakuv dan nǝvanuan tosob̃ur. Ale nǝvanuan isob̃ur lotodǝdas lǝb̃erus mai lotodǝdas lǝb̃iyar, lumaur. ");
INSERT INTO klv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Imagenan, len nab̃iltivile enan alat a Samaria lohǝhaṽur habat. ");
INSERT INTO klv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Len naut enan ikad avan sua, nahǝsan aSimon, totoh ei ebǝlav. Egǝgol behi gol ke nǝvanuan p̃isi len naut a Samaria lup̃aŋ lan. Akis isor patpat gai mǝhat hum toyalyal, ");
INSERT INTO klv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ale nǝvanuan namǝsal gail mai alat lototibau, galit p̃isi losǝsǝloŋ vahvahuri. Ale luke, “Atenan evi Daŋan siGot lotokisi hǝn aYalyal.” ");
INSERT INTO klv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lohushusuri ebǝlav bathut togol galit lotop̃aŋ len na-gol-nabehi-an san gai togolgole. ");
INSERT INTO klv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Avil nǝboŋ aFilip tokel na-kel-uri-an tovoi husur natohan pipihabǝlan aGot mai aYesu tovi aKristo, aGot totabtabuh lan, lodǝlomi. Ale lubaptais, lalum̃an mai latpǝhaṽut. ");
INSERT INTO klv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ASimon m̃au, gai am edǝlom aFilip ale ibaptais. Beti ehushusur aFilip vi lan naut gail p̃isi, ale ip̃aŋp̃aŋ len namerikel gail torisi. ");
INSERT INTO klv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nǝboŋ ahai pispisul gail len naut a Jerusalem lotosǝsǝloŋ hǝni ke alat a Samaria lotodǝlom nasoruan siGot tia, losǝvat aPita mai aJon van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nǝboŋ artobar naut a Samaria, arusor tuṽ m̃os galit lotokad nadǝlomian ke aNunun aGot tegǝm hǝn galito. ");
INSERT INTO klv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Husur aNunun aGot sab̃is len galit ideh sal; lubaptais len nahǝsan aYesu ŋai. ");
INSERT INTO klv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Beti aPita mai aJon aroriŋ navǝlalar len galit ṽisusua, ale aNunun aGot eb̃is len galito. ");
INSERT INTO klv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nǝboŋ aSimon toris ke aGot toviol hǝn aNunun nǝboŋ artoriŋ navǝlalar len galito, ilav ris nǝvat mai gǝlaru hǝn b̃eṽur nǝdaŋan enan. ");
INSERT INTO klv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ike, “Mirilav nǝdaŋan enan mai ginau hǝn ke nǝboŋ nǝb̃eriŋ navǝlagw len avan ideh aNunun aGot teb̃is lan.” ");
INSERT INTO klv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","APita isor vari ke, “Nǝvat sam̃ tib̃os nǝtan mai gaiug, husur gunau ke gotolǝboi gǝb̃eṽur naviolan siGot hǝn nǝvat! ");
INSERT INTO klv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gaiug godǝdas gǝb̃itah mai ginamito len nauman egai husur nǝlom̃ sanor len nǝhon aGot. ");
INSERT INTO klv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gipair dan nǝsaan egai, kel nalolosaan sam̃ mai aGot. Gǝb̃igole, hum ma aGot b̃erub̃at nǝnauan enan topat len nǝlom̃ dan gaiug. ");
INSERT INTO klv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bathut noris ke nǝlom̃ topul hǝn nǝ-tab̃ulol-bulosi-an ale nǝsaan ibaŋis gat gaiug tia.” ");
INSERT INTO klv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ŋa aSimon ike, “Iii! Mirisor tuṽ van hǝn Nasub̃ m̃os ginau hǝn nǝsa mǝrtokele asike b̃evisi hǝn ginau.” ");
INSERT INTO klv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nǝboŋ artokel nǝsa lotolǝboi husur aYesu mai lotokel ur nasoruan siNasub̃, aPita mai aJon arotǝlmam vi Jerusalem. Len nap̃isal sǝlaru arukel ur na-kel-uri-an tovoi len navile isob̃ur a Samaria. ");
INSERT INTO klv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Boŋ sua aŋel sua siNasub̃ ikel mai aFilip ke, “Gile mǝhat! Gehusur nap̃isal toriŋ naut a Jerusalem vi Kasa, nap̃isal tob̃ǝb̃esw.” ");
INSERT INTO klv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Imagenan aFilip iyar husur nap̃isal enan, be esǝhoṽut, eris auleItiopia sua tovi sogsog. Gai evi nab̃iltivanuan siKadake tovi kwin silat a Itiopia. Ekǝtkǝta tǝban nǝvat p̃isi sekwin. Atenan ivan hǝn naut a Jerusalem hǝn tolotu, ");
INSERT INTO klv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ale len natǝlmaman san ebǝtah len nǝkat san, eṽuruŋ natosian sihai kelkel ur, aIsaiah. ");
INSERT INTO klv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Beti aNunun aGot ikel mai aFilip ke, “Givan pǝpadaŋ hǝn nǝkat enan ale gitah maii.” ");
INSERT INTO klv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nǝboŋ aFilip togam van pǝpadaŋ hǝn nǝkat, esǝsǝloŋ hǝn toṽuruŋ natosian seIsaiah, ale eusi ke, “Goṽuruŋ lǝboi nasoruan enan a?” ");
INSERT INTO klv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Isor vari ke, “Nelǝboi mab hǝni, asike b̃ikad avan ideh hǝn b̃isor vǝsvǝsaii mai ginau.” Imagenan eus aFilip hǝn b̃isah, bǝtah tǝban. ");
INSERT INTO klv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Atenan tovi sogsog eṽuruŋ natosian egai siGot toke: “Losǝhari hun nasipsip van hǝn natibunian, sum̃an natuhsipsip sais nǝboŋ lotogut navurun, gai am sasor. ");
INSERT INTO klv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Lugol isa hǝni hum tovi vanuan naut kǝmas, len nakotan san lugol sanor hǝni. Ase elǝboi b̃isor husur anatun san gail o naur ta tahw han gail? Eb̃uer, bathut lulav kuv nǝmauran san dan navile a pan.” ");
INSERT INTO klv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Beti eus aFilip ke, “Nous gaiug, ahai kelkel ur egai isor husur ase? Gai o avan sua tile?” ");
INSERT INTO klv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ale aFilip etub̃at len natosian enan ŋai, ikel na-kel-uri-an tovoi husur aYesu. ");
INSERT INTO klv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Len nǝyaran salit husur nap̃isal lubar naut tokad nǝwai lan, ale atenan tovi sogsog ike, “Geris, nǝwai! Ikad natideh hǝn b̃ipat kǝkol hǝn nǝbaptaisan sagw a?” ");
INSERT INTO klv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ale ikel mai ahai wolwol ke tigol nǝkat teil. Beti gǝlaru arumariŋ vi pan len nǝwai ale aFilip ibaptais hǝni. ");
INSERT INTO klv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nǝboŋ artovahut, vǝha-sua ŋai aNunun Nasub̃ iyav hǝn aFilip vi tut. Ale nab̃iltivanuan sarisi am, be nǝboŋ tohusur nap̃isal san van, ikemkem habat. ");
INSERT INTO klv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Be aFilip evisi tǝtas a Asotus, ale iyar tur nab̃iltivile gail p̃isi. Ikel ur na-kel-uri-an tovoi van vǝbar naut a Sisarea. ");
INSERT INTO klv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Len nǝboŋ enan aSol emǝtahun bun ahai susur gail siNasub̃. Ikel ke temǝdas galit hǝn b̃igol galit lǝb̃imat. Italtal hǝni van vaus ab̃iltihai tutumav ");
INSERT INTO klv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","hǝn b̃itos nalob̃ulat van hǝn naim nab̃onb̃onan gail seJu len naut a Tamaskus. Ike tisab̃ alalum̃an mai alatpǝhaṽut ideh lotohusur nap̃isal siYesu ei hǝn b̃ibaŋis gat galito, ale sǝhar galit vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Len nǝyaran san, nǝboŋ togǝm pǝpadaŋ hǝn naut a Tamaskus, vǝha-sua ŋai nam̃ial sua togǝm len nǝmav ebilasi. ");
INSERT INTO klv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Iteh len tan ale esǝsǝloŋ hǝn nadoldol toke, “Sol, Sol, gomǝdas tabtab hǝn ginau hǝn nǝsa?” ");
INSERT INTO klv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ale ike, “Gaiug ase Nasub̃?” Isor vari ke, “Ginau aYesu gotomǝdas bun ginau. ");
INSERT INTO klv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Be gile mǝhat, geb̃is len nab̃iltivile, ale avan sual ei dereh tikel mai gaiug nǝsa gǝb̃imasgole.” ");
INSERT INTO klv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Alat lotoyar maii loil b̃utb̃ut, losǝsǝloŋ hǝn nadoldol be lǝsaris avan ideh. ");
INSERT INTO klv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ASol ile mǝhat, naut kǝmas namǝtan tosǝŋav saris natideh. Ale lotǝgau navǝlan, sǝhari vi lan naut a Tamaskus. ");
INSERT INTO klv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ale sakǝta len nǝmariboŋ totor, sǝhan, samun. ");
INSERT INTO klv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ikad ahai susur sua len naut a Tamaskus, nahǝsan aAnanias. Nasub̃ isor maii len narisian ke, “Ananias!” Ale aAnanias ike, “Ginau bogai.” ");
INSERT INTO klv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Beti Nasub̃ ikel maii ke, “Gile mǝhat, gevi lan nametp̃isal lotokisi hǝn Tonor, gevi lan naim seJutas, ale geus kitev auleTarsus ei, nahǝsan aSol, husur ke, gagai isor tuṽ. ");
INSERT INTO klv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ale len na-kǝta-risi-an eris avan sua, nahǝsan aAnanias togǝm, toriŋ navǝlan lan hǝn nakǝtaan san b̃etǝlmam.” ");
INSERT INTO klv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","AAnanias isor vari ke, “Nasub̃, nosǝsǝloŋ hǝn nǝvanuan isob̃ur lotosor husur atenan. Luke togol natit lotosa, tomǝdas nǝvanuan sam̃ gail a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ale ab̃iltihai tutumav gail lulav nǝdaŋan hǝn na-il-a-m̃o-an maii hǝn b̃egǝm gegai hǝn b̃ibaŋis gat alat lotokis gaiug Nasub̃.” ");
INSERT INTO klv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nasub̃ ikel mai aAnanias ke, “Naut kǝmas natenan, givan! Nutabtabuh len atenan hǝn b̃isor husur ginau mai alat lǝsavi Ju mai nakiŋ salit gail mai alat a Israel. ");
INSERT INTO klv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ginau dereh neṽusani hǝn natit p̃isi b̃igol na-lǝŋon-isa-an san m̃os ginau.” ");
INSERT INTO klv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Imagenan aAnanias evi lan naim enan ale eb̃is lan. Eriŋ navǝlan gǝlar len aSol ale ike, “Wawa Sol, Nasub̃ aYesu tovisi hǝn gaiug len nap̃isal nǝboŋ gotogǝm gegai, gai esǝvat ginau hǝn gǝb̃ikad nakǝtaan tǝtas ale hǝn gǝb̃epul hǝn aNunun aGot.” ");
INSERT INTO klv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Vǝha-sua ŋai natgalevis hun nǝgavhuieh luteh dan namǝtan aSol gǝlaru, ale ikad nakǝtaan tǝtas. Ile mǝhat ale ibaptais. ");
INSERT INTO klv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nǝboŋ tohan, idaŋ tǝtas. Len nǝmariboŋ galevis aSol itoh mai ahai susur gail len naut a Tamaskus. ");
INSERT INTO klv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Vǝha-sua ŋai len naim nab̃onb̃onan gail seJu, etub̃at kel uri ke aYesu tovi aNatun aGot. ");
INSERT INTO klv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Galit p̃isi lotosǝsǝloŋ hǝni, lup̃aŋ, lousus galit gabag ke, “Be atenan evi nǝvanuan tomǝtahun alat lotokad nadǝlomian len nahǝsenan len naut a Jerusalem. Be egǝm gegai hǝn b̃ibaŋis gat galito hǝn b̃esǝhar galit van hǝn ab̃iltihai tutumav gail. Imabe?” ");
INSERT INTO klv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Be nalǝboian siSol hǝn na-kel-uri-an evivi mǝhat ale igol alat lotosuh a Tamaskus lotovi Ju, nǝnauan salit ebutbutut, husur eṽusan koti ke aYesu tovi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Husur nǝmariboŋ tosob̃ur, alat lotovi Ju lusor utaut hǝn lǝb̃igol aSol b̃imat, ");
INSERT INTO klv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","be avan sua epǝhpǝhalu maii. Len nalennǝyal mai nalenmariug p̃isi lokǝta bunus nabopita gail hǝn nab̃iltivile hǝn lǝb̃igol aSol b̃imat. ");
INSERT INTO klv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Imaienan alat lotohusur aSol losǝhari len mariug, ale len nǝhad loriŋ aSol vi pan tur len naholǝvat todar vis nab̃iltivile. Ale igam yav vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nǝboŋ tobar naut a Jerusalem ike titah mai ahai susur gail avil lomǝtahw lan. Lǝsadǝlomi ke tovi ahai susur kitin. ");
INSERT INTO klv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Be aParnapas esǝhari van hǝn ahai pispisul gail. Ikel mai galit ke len nǝyaran siSol, eris Nasub̃ tia ale Nasub̃ isor maii. Isor husuri am ke, len naut a Tamaskus aSol ikel ur na-kel-uri-an tovoi len nahǝsan aYesu, namǝtahwan eb̃uer. ");
INSERT INTO klv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Imagenan, aSol itah mai galito, ale ivan tǝlmam, van tǝlmam len naut a Jerusalem. Len na-il-b̃uri-an, isor tabtab len nahǝsan Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ihol mai naJu gail lotosor len nasoruan ta Kris, ale isor levlev hǝn natosian siGot mai galito, avil lugol risi hǝn b̃imat. ");
INSERT INTO klv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nǝboŋ nǝbathudud nadǝlomian lotosǝsǝloŋ lǝboi natenan, losǝhari vi pan vi Sisarea ale losǝvati vi Tarsus. ");
INSERT INTO klv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Beti alat siYesu lukad natǝm̃at len naut p̃isi a Jutea, a Kalili mai a Samaria, nǝmauran salito ivoi ŋai. ANunun aGot igol galit ludaŋ am mai lolǝŋon ivoi am len nǝlolito, galit logǝm lusob̃ur am ale lutoh len namǝtahwan hǝn nǝyalyalan siGot. ");
INSERT INTO klv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nǝboŋ aPita toyar tur len naut p̃isi, ia m̃ǝdoŋ ben alat siGot lototohtoh a Litta. ");
INSERT INTO klv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Len naut ei eris avan sua, nahǝsan aAeneas, topat len nǝmel san ŋai, husur nǝtarhǝben imat len nasihau tomǝlevtor. ");
INSERT INTO klv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","APita ikel maii ke, “AAeneas, aYesu Kristo igol gumaur gagai. Gile mǝhat ale ṽolsan namilem̃.” Vǝha-sua ŋai aAeneas ile mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Galit p̃isi lototoh len navile Litta mai len nabǝmav Saron loris tomaur ale lupair van hǝn Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Len navile Joppa ikad ahai susur sua, nahǝsan alitea aTapita, lotokisi am hǝn aTorkas len nasoruan ta Kris. Gai igol ivoi akis hǝn nǝvanuan gail mai evi tarhǝt silat lotopar tite. ");
INSERT INTO klv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Len nǝboŋ enan emǝsah van, imat. Lokǝkas niben ale loriŋi len narum̃ a mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Husur naut a Litta ipat pǝpadaŋ hǝn naut a Joppa, nǝboŋ ahai susur gail lotosǝsǝloŋ hǝni ke aPita totoh a Litta, losǝvat alaruevis van hǝni, artoŋiri ke, “Gegǝm mai ginamǝru bai; sagevǝlo!” ");
INSERT INTO klv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ŋa aPita ile mǝhat, iyar mai gǝlaru, ale nǝboŋ tobar naut a Joppa losǝhari vi lohoim, vi lan narum̃ a mǝhat. Nǝbatunau pǝhaṽut p̃isi loil garu, lutaŋ ale loṽusan aPita hǝn nǝhai susun gail mai nahurabat tiltile gail aTorkas tosode nǝboŋ tomaur sal mai galito. ");
INSERT INTO klv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","APita esǝvat galit vivile; beti etǝŋedur, isor tuṽ. Ale ipair van hǝn niben, ike, “Tapita, gile mǝhat!” Alitenan esǝŋav hǝn namǝtan, eris aPita ale ebǝtah vi mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","APita etǝgau navǝlan ale elivi hǝn b̃eil. Beti ekis nǝbatunau gail mai alat siGot ale esǝhar alitenan tomaur van hǝn galito. ");
INSERT INTO klv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Len naim p̃isi a Joppa nǝvanuan gail losǝsǝloŋ hǝn natenan tovisi gol ke isob̃ur lukad nǝvanuan nadǝlomian len Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","APita itoh len naut a Joppa len nǝmariboŋ isob̃ur len naim seSimon. Simon igol natit gail hǝn nahurhurivatvat. ");
INSERT INTO klv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Len naut a Sisarea ikad avan sua, nahǝsan aKornelius, nasenturion sua toil a m̃o hǝn nasoltia tovi 100 len Navǝshǝsoltia ta Itali. ");
INSERT INTO klv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gai mai nǝbathudud san lohusur kitin hǝn nap̃isal siGot mai lomǝtahw len nǝyalyalan san; gai ilavlav nǝvat mai alat lotopar tite ale isor mai aGot akis. ");
INSERT INTO klv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Len nǝboŋ sua len namityal totor ut mǝdau, eris narisian sua. Ekǝta masil hǝn aŋel sua siGot togǝm hǝni tokel maii ke, “Kornelius!” ");
INSERT INTO klv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","AKornelius ekǝta mǝtaltal hǝni, ninen epil, eusi ke, “Golǝŋon nǝsa Nasub̃?” Aŋel isor vari ke, “Na-sor-tuṽ-an sam̃ mai naviolan sam̃ van hǝn alat lotopar tite, arohun naviolan hǝn natutumavan van hǝn aGot. Ehǝhaṽur hǝni. ");
INSERT INTO klv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Imaienan, gesǝvat alalum̃an vi Joppa hǝn lǝb̃esǝhar tǝlmam hǝn avan sua nahǝsan aSimon lotokisi hǝn aPita. ");
INSERT INTO klv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Gai itoh mai aSimon togol natit gail hǝn nahurhurivatvat, naim san ipat bitas.” ");
INSERT INTO klv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋel enan isor maii ale ivan. Nǝboŋ tovan tonoŋ, aKornelius ekis nǝvanuan nauman san eru mai nasoltia sua tokǝtkǝta tǝban, tohusur kitin hǝn nap̃isal siGot. ");
INSERT INTO klv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ikel natit p̃isi tovisi mai galito, ale esǝvat galit vi Joppa. ");
INSERT INTO klv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pelan han tub̃lial, len nǝyaran salito, logǝm pǝpadaŋ hǝn nab̃iltivile. Len nǝboŋ enan aPita epǝlau vi mǝhat len navurun naim topapav hǝn b̃isor tuṽ. ");
INSERT INTO klv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Imalkǝkat, ike tihan, ale nǝboŋ lotoutaut hǝn nǝhanian sal, ekǝta b̃erb̃er. ");
INSERT INTO klv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Eris nǝmav tosǝŋav, natit hun nab̃iltikaliko, nǝhau tovat lotobaŋis nagilen tovat, evi pan vi lan nǝtan. ");
INSERT INTO klv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Epul hǝn narivatvat tiltile gail, nǝm̃at mai namǝhob gail lotokǝlah len tan, mai nǝman namǝsav gail. ");
INSERT INTO klv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Beti nadoldol sua ikel maii ke, “Pita, gile mǝhat, paru bun namǝŋod, hani!” ");
INSERT INTO klv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Be aPita isor vari ke, “Ao Nasub̃, sanigole! Nǝsǝhanhan natideh tosa o tokolkol.” ");
INSERT INTO klv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nadoldol isor tǝtas maii ke, “Sagekis natideh ke tosa aGot togol toveveu.” ");
INSERT INTO klv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tomagenan vǝha-tor tonoŋ, vǝha-sua ŋai nǝkaliko enan evi mǝhat vi lan nǝmav. ");
INSERT INTO klv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nǝboŋ aPita tonau masuṽ hǝn namilen nǝsa torisi, alalum̃an aKornelius tosǝvat galito, lusab̃ naim seSimon ale loil len nametlǝkau. ");
INSERT INTO klv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Lukai, lous ke, “Avan sua nahǝsan aSimon Pita itoh ei a?” ");
INSERT INTO klv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nǝboŋ aPita tonau nǝsa torisi sal, aNunun aGot isor maii ke, “Simon, alalum̃an itor lous kitev gaiug. ");
INSERT INTO klv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gile mǝhat, gimariŋ vi pan. Saginau ke asike guvan, givan mai galito husur ginau nosǝvat galito.” ");
INSERT INTO klv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Imagenan aPita evi pan, ikel mai galit ke, “Ginau boh nǝvanuan mǝttous kitevi. Imabe? Mǝtogǝm m̃os nǝsa?” ");
INSERT INTO klv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Galit lusor vari ke, “AKornelius, nasenturion sua toil a m̃o hǝn nasoltia tovi 100, esǝvat ginamito. Gai evi naulum̃an sua tonor, tomǝtahw len nǝyalyalan siGot. Alat lotovi Ju p̃isi luke ivoi. Aŋel sua siGot ikele hǝni ke teus gaiug hǝn gǝb̃evi lan naim san hǝn b̃esǝsǝloŋ hǝn nǝsa gaiug gǝb̃ikele.” ");
INSERT INTO klv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Beti aPita eus galit ke levi lohoim hǝn lǝb̃itoh maii. Pelan han aPita galito loriŋ naut enan ale ahai susur galevis ta Joppa luyar maii. Lupat len mariug ale ");
INSERT INTO klv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","len nǝboŋ tohusuri aPita ibar naut a Sisarea. AKornelius itoh vir galito. Eus nǝbathudud san mai nabubur san gail hǝn lǝb̃egǝm b̃onb̃on. ");
INSERT INTO klv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nǝboŋ aPita tob̃is lohoim, aKornelius ebubur maii ale etǝŋedur bathurien aPita, ilotu hǝni. ");
INSERT INTO klv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Avil aPita elivi vi mǝhat ike, “Gile mǝhat, ginau bogai, novi vanuan ŋai.” ");
INSERT INTO klv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nǝboŋ tohol maii, aPita evi lohoim ale eris nǝvanuan lotosob̃ur lotob̃onb̃on ei. ");
INSERT INTO klv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ikel mai galit ke: “Gamit mǝtolǝboii tia ke sanor hǝn nǝ-kai-tasi-an sinamit namttovi Ju hǝn namtb̃itah mai o hǝn namtb̃em̃ǝdoŋ tǝban avan ideh savi Ju. Be aGot eṽusan ginau ke sanisor husur avan ideh ke tosa o ke aGot tomǝtahuni. ");
INSERT INTO klv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Imaienan nǝboŋ gotosǝvat galit hǝn lǝb̃esǝhar ginau, nogǝmai, nǝsake nodǝdas nǝb̃egǝmai. Nuke neus gamito, imabe mǝttous ginau ke nǝb̃egǝmai?” ");
INSERT INTO klv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ale aKornelius isor vari ke, “Evi nǝmariboŋ tovat tovan, len namityal egai totor ut mǝdau, nusor tuṽ. Vǝha-sua ŋai avan sua tosun nahurabat tobilbil eil a m̃o hǝn ginau ");
INSERT INTO klv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ike, ‘Kornelius, aGot esǝsǝloŋ hǝn na-sor-tuṽ-an sam̃ tia mai inau gat naviolan sam̃ van hǝn alat lotopar tite. ");
INSERT INTO klv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Imaienan, gesǝvat alalum̃an vi Joppa hǝn lǝb̃esǝhar tǝlmam hǝn avan sua nahǝsan aSimon lotokisi hǝn aPita. Atenan itoh mai aSimon togol natit gail hǝn nahurhurivatvat, naim san ipat bitas.’ ");
INSERT INTO klv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Husur enan, vǝha-sua ŋai nosǝvat galit hǝn lǝb̃esǝhar gaiug. Sipa len nagǝmaian sam̃. Gagai namtutoh gegai len nǝhon aGot hǝn namtb̃esǝsǝloŋ hǝn natit p̃isi Nasub̃ tokele tia ke gaiug gǝb̃ikele mai ginamito.” ");
INSERT INTO klv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Beti aPita etub̃at hǝn b̃isor ike, “Gagai nolǝboii ke tokitin ke naṽide siGot ep̃itoṽ van hǝn nǝvanuan p̃isi, ideh satile. ");
INSERT INTO klv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Imagenan, nǝvanuan naut p̃isi lototǝŋedur van hǝn aGot mai lotogol nǝsa tonor, ehǝhaṽur hǝn lǝb̃egǝm hǝni. ");
INSERT INTO klv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mǝtolǝboi napisulan aGot topisul hǝni van hǝn alat a Israel tia, napisulan tokel na-kel-uri-an tovoi toke, nǝvanuan elǝboi b̃ikad navoivoian mai aGot len aYesu Kristo tovi Masta hǝn nǝvanuan tiltile gail p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mǝtolǝboi nǝsa tovisi len naut a Jutea totub̃at a Kalili husur nǝbaptaisan aJon tokel uri. ");
INSERT INTO klv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mǝtolǝboii am ke aGot tovǝhas aYesu ta Nasaret hǝn aNunun mai nǝdaŋan, gol ke, gai iyar tur len naut p̃isi ale igol navoian mai igol alat natǝmat tobaŋis gat galito, lumaur, bathut aGot totah maii. ");
INSERT INTO klv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ale ginamit namtoris lǝboi natit p̃isi aYesu togole len naut a Jutea mai a Jerusalem. Galit lutahǝtah hǝni tomat len nǝhai sua, ");
INSERT INTO klv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","be aGot ilav kuvi dan nǝmatan len nǝmariboŋ totor, ale igol ke evisi hǝn nǝvanuan lǝb̃elǝboi lǝb̃erisi. ");
INSERT INTO klv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nǝvanuan p̃isi lǝsarisi, be ginamit aGot totabtabuh len ginamit tia, namtorisi hǝn namtb̃ikel uri. Nǝboŋ aYesu tole mǝhat dan nǝmatan, ginamit namtuhan maii, namtomun maii. ");
INSERT INTO klv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Isor idaŋ mai ginamito ke namtikel uri mai nǝvanuan gail ale kel koti ke aGot totabtabuh lan hǝn b̃epǝpehun navoian dan nǝsaan hǝn alat lotomaur sal mai alat lotomat tia. ");
INSERT INTO klv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ahai kelkel ur gail p̃isi lutos husur aYesu, lukel uri ke, len nahǝsan aYesu, nǝvanuan gail p̃isi lotoriŋ nǝlolit lan, aGot dereh terub̃at nǝsaan salit dan galito.” ");
INSERT INTO klv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nǝboŋ aPita tokǝmaienan sal, aNunun aGot eb̃is len galit p̃isi lotosǝsǝloŋ hǝn nasoruan. ");
INSERT INTO klv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nǝvanuan nadǝlomian lotovi Ju, lototah mai aPita, losǝhoṽut husur aGot tovur san aNunun len alat lǝsavi Ju am. Lolǝboii ke toviol hǝn aNunun mai galito ");
INSERT INTO klv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","husur losǝsǝloŋ hǝn galit lotosor len nasoruan tiltile gail, mai lotosor sal suh nǝyalyalan siGot. Beti aPita ike, ");
INSERT INTO klv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Avan ideh satikai tas galit hǝn lǝb̃ibaptais hǝn nǝwai, husur aGot eviol hǝn aNunun mai galito sum̃an gidato.” ");
INSERT INTO klv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ŋa ikel buni ke libaptais len nahǝsan aYesu Kristo. Beti lous aPita hǝn b̃itoh mai galito hǝn nǝmariboŋ galevis am. ");
INSERT INTO klv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ahai pispisul gail mai nǝvanuan nadǝlomian gail len naut a Jutea losǝsǝloŋ hǝni ke alat lǝsavi Ju am lodǝlom nasoruan siGot tia. ");
INSERT INTO klv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ŋa nǝboŋ aPita tobar naut a Jerusalem, alat siYesu lotonau masuṽ hǝn na-tiv-dalusi-an, lusor tasi ke, ");
INSERT INTO klv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Gaiug gob̃is len naim silat lǝsǝkad na-tiv-dalusi-an ale guhan mai galito!” ");
INSERT INTO klv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Beti aPita ikel mai galito hǝn natit p̃isi tovisi tub̃at len natub̃atan van vǝbar nagilen. Ike: ");
INSERT INTO klv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ginau nusor tuṽ sǝb̃ogw len navile Joppa, ale nokǝta b̃erb̃er, noris natit hun nab̃iltikaliko nǝhau tovat lotobaŋis nagilen tovat han, ale evi pan dan nǝmav, egǝm hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nǝboŋ notokǝta vi lan, noris narivatvat tiltile gail, galevis lotovi rivatǝvat katkat, ale nǝm̃at mai namǝhob gail mai nǝman namǝsav gail. ");
INSERT INTO klv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nosǝsǝloŋ hǝn nadoldol tokel mai ginau ke, ‘Gile mǝhat Pita, paru bun namǝŋod. Hani!’ ");
INSERT INTO klv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Be nusor vari ke, ‘Aoa Nasub̃, sanigole! Nǝsariŋ natideh tosa o tokolkol len nabuŋogw boŋ ideh.’ ");
INSERT INTO klv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nadoldol len nǝmav isor var ginau tǝtas ke, ‘Sagekis natideh ke tosa aGot togol toveveu.’ ");
INSERT INTO klv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Imagenan vǝha-tor, ale natit p̃isi evi mǝhat vi lan nǝmav. ");
INSERT INTO klv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Be mǝteris! Alalum̃an itor, aKornelius tosǝvat galito a Sisarea gǝm hǝn ginau, logǝm pǝpadaŋ hǝn naim nototoh lan. ");
INSERT INTO klv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ANunun aGot ikel mai ginau ke nivan mai galito, saninau masuṽ husur natilean salit lǝsavi Ju. Ale nuvan, alategai, lotomǝlevtes lotokad nadǝlomian, galit am lutah mai ginau, ale namtuvan, namtob̃is lohoim naim sitea a Sisarea. ");
INSERT INTO klv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ihol mai ginamito husur gai toris aŋel sua toil lohoim san toke, ‘Gesǝvat galevis vi Joppa hǝn lǝb̃esǝhar tǝlmam hǝn aSimon lotokisi hǝn aPita. ");
INSERT INTO klv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Gai tikel ur napisulan sua. Len napisulan enan, aGot dereh tilav kuv gaiug mai nǝbathudud sam̃ dan nǝsaan samito.’ ");
INSERT INTO klv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nǝboŋ notosor kǝkereh ŋai, aNunun aGot eb̃is len galit sum̃an tob̃is len gidato len nǝboŋ ta m̃o. ");
INSERT INTO klv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Len nǝboŋ enan nunau gat nǝsa Nasub̃ tokele ke, ‘AJon ibaptais hǝn nǝvanuan gail hǝn nǝwai be aGot dereh tibaptais hǝn gamito hǝn aNunun.’ ");
INSERT INTO klv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Imaienan, aGot b̃eviol mai galit naviolan top̃itoṽ hǝn nǝsa toviol hǝni mai gidato nǝboŋ dattokad nadǝlomian len Nasub̃ aYesu Kristo, ginau ase hǝn ke nǝb̃eil kǝkol hǝn aGot?” ");
INSERT INTO klv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nǝboŋ lotosǝsǝloŋ hǝn aPita tonoŋ, lǝsasor am be lusor sal suh aGot, luke, “Imagenan beti, aGot eviol hǝn nap̃isal mai alat lǝsavi Ju tu hǝn lǝb̃ipair dan nǝsaan, hǝn lǝb̃ikad nǝmauran.” ");
INSERT INTO klv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Alat lotogam pǝpehw dan na-lǝŋon-isa-an husur nǝmatan siSteven, luvan vǝbar naut a Fonisia, a Saiprus mai a Antiok. Lukel ur nasoruan husur aYesu, be lukele mai naJu gail ŋai. ");
INSERT INTO klv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Avil galit galevis, auleSaiprus mai auleSairin gail, lovi Antiok ale lotub̃at sor mai alat a Kris am. Lukel mai galit hǝn na-kel-uri-an tovoi husur Nasub̃ aYesu. ");
INSERT INTO klv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nǝdaŋan siNasub̃ ipat len galito, ŋa nǝvanuan isob̃ur lodǝlom napisulan salito ale lupair van hǝn Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na-kel-uri-an hǝn natgalenan ibar alat siYesu len naut a Jerusalem ale losǝvat aParnapas vi Antiok. ");
INSERT INTO klv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nǝboŋ tobar naut enan eris lǝboii ke aGot toviol kǝmas hǝn navoian mai galito. Ale aParnapas ikemkem hǝni, igol lolǝŋon ivoi am len nǝlolito, ikel mai galit ke lidaŋ len Nasub̃, leriŋ kot nǝlolit len Nasub̃, il gǝgat lan. ");
INSERT INTO klv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","AParnapas evi naulum̃an tovoi, topul hǝn aNunun aGot mai nadǝlomian. Nǝvanuan isob̃ur losǝsǝloŋ hǝni ale loriŋ nǝlolit len Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Beti aParnapas evi Tarsus hǝn b̃idoŋ aSol. ");
INSERT INTO klv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nǝboŋ tosab̃i, esǝhari van vǝbar naut a Antiok. Len nasihau enan kavkav gǝlaru arub̃onb̃on mai alat siYesu, mai aroṽusan galit isob̃ur. Len naut a Antiok evi metǝkav lotokis ahai susur gail hǝn naKristen. ");
INSERT INTO klv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Len nǝboŋ enan, ahai kelkel ur galevis loriŋ naut a Jerusalem lovi pan vi Antiok. ");
INSERT INTO klv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Galit sua, nahǝsan aAkapus, ile mǝhat hǝn b̃ikel ur nǝsa aGot tokel maii ke, dereh navile a pan kavkav tipar hanian buni. Natenan evisi nǝboŋ aKlautius tovi Sisa len naut a Rom. ");
INSERT INTO klv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋa ahai susur gail lunau koti ke, lǝb̃ikad nǝvat, leviol hǝn galevis mai nǝbathudud nadǝlomian lototohtoh len naprovens Jutea hǝn b̃evi tarhǝt salit ei. ");
INSERT INTO klv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Imaienan losǝvat aParnapas mai aSol hǝn lǝb̃ilav naviolan en salito mai alat lotoil a m̃o len naut a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Len nǝboŋ galenan aHerot Akrippa tovi kiŋ itah gat alat siYesu galevis husur ike temǝdas bun galito. ");
INSERT INTO klv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gai igol nasoltia ita bun aJemes, aṽan aJon hǝn nab̃u nǝb̃alan. ");
INSERT INTO klv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nǝboŋ aHerot toris ke alat lotoil a m̃o hǝn naJu gail lotohǝhaṽur hǝn natenan, esǝvat nasoltia gail hǝn lǝb̃itah gat aPita am. Igole len nǝboŋ gail hǝn Nǝhanan hǝn nabǝta sǝkad nayis lan tovi nǝhanan sua ta sutuai seJu gail. ");
INSERT INTO klv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nǝboŋ lototah gat aPita tonoŋ, aHerot eriŋi len naim bǝbaŋis, natuhluṽoh tovat hǝn nasoltia tovatvat lan lokǝtkǝta kǝkol hǝni. AHerot ike tikot hǝn aPita len nǝhon nǝvanuan p̃isi, nǝboŋ Nǝhanan hǝn nǝPasova b̃inoŋ. ");
INSERT INTO klv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ŋa lokǝtkǝta kǝkol hǝn aPita len naim bǝbaŋis, be alat siYesu lusor tuṽ tabtab van hǝn aGot m̃osi. ");
INSERT INTO klv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Len nalenmariug enan a tahw hǝn nǝboŋ aHerot b̃ikot hǝni, aPita ipat buŋbuŋol rivuh hǝn nasoltia eru, natsen eru artobaŋis gati, ale nasoltia gail am lokǝta kǝkol hǝn nabopita hǝn naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Vǝha-sua ŋai aŋel sua siNasub̃ evisi, ale nam̃ial em̃ial lohoim. Aŋel iṽas aPita tarhǝben ike, “Gile mǝhat tutut!” ale natsen aruteh dan navǝlan gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Beti aŋel ikel maii ke, “Gepitavis nǝhau tutuṽ sam̃, vǝlas naributbut gǝlaru.” Ale aPita igole. Aŋel ike, “Geruŋ gol gaiug hǝn nahurabat naut susus sam̃ ale gehusur ginau!” ");
INSERT INTO klv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ŋa aPita evivile husur aŋel be etǝtan hǝn ke nǝsa aŋel togole ekitin o sakitin. Inau ke toris na-kǝta-risi-an ŋai. ");
INSERT INTO klv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Gǝlaru aruṽot pǝpadaŋ hǝn naut eru nasoltia lotokǝtkǝta kǝkol hǝn naut toru enan len naim bǝbaŋis, ale arubar nabopita tovi metǝlai tovan hǝn nab̃iltivile. Esǝŋav sǝb̃on m̃os gǝlaru ale aruyar tur lan. Nǝboŋ artobar nagilen nap̃isal tomagugun sua, vǝha-sua ŋai aŋel eriŋ aPita. ");
INSERT INTO klv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Beti aPita tomadhalǝboii ke tovivile kitin ike, “Gagai nolǝboi koti ke Nasub̃ esǝvat aŋel san hǝn b̃ilav kuv ginau dan navǝlan aHerot mai dan natit p̃isi naJu gail lotonau ke tevisi.” ");
INSERT INTO klv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nǝboŋ aPita tonau lǝboii, evi lan naim siMeri, anan aJon nahǝsan togon aMak. Nǝvanuan tosob̃ur lub̃on ei hǝn lǝb̃isor tuṽ. ");
INSERT INTO klv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","APita ideldel len nabopita ta vivile, ale navensus tovi slev, nahǝsan aRota egǝm hǝn nabopita hǝn b̃esǝsǝloŋ. ");
INSERT INTO klv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nǝboŋ tosǝsǝloŋ lǝboi nadolon aPita, ikemkem masuṽ ŋa igam tǝlmam, sasǝŋav hǝni, ikai ke, “APita eil bopita!” ");
INSERT INTO klv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Lukel maii ke, “Gaiug govinu!” Nǝboŋ tokelkel tǝtas hǝni ke ekitin, luke, “Hum ma tovi aŋel san.” ");
INSERT INTO klv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Be aPita ideldel sal. Beti nǝboŋ lotosǝŋav hǝni, lorisi, lumaŋmaŋ habat. ");
INSERT INTO klv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","APita eb̃il hǝn navǝlan ke lemǝdau, ale isor husur nap̃isal Nasub̃ togole tolav kuvi dan naim bǝbaŋis. Ale ikel mai galit ke, “Mitikel natgalenan mai aJemes mai alat sidat gail,” beti eriŋ naut enan, evi lan naut tile. ");
INSERT INTO klv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Len nadudulan nasoltia gail lunau sob̃uer hǝn nǝsa tovisi hǝn aPita, lolǝŋon isa masuṽ. ");
INSERT INTO klv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nǝboŋ aHerot togol nadoŋian hǝn aPita sob̃uer, eus taltal hǝn alat lotokǝta kǝkol hǝn aPita husur nǝ-gam-yav-an san ale aHerot ikele hǝn nasoltia tile gail ke ligol galit limat. Nǝboŋ aHerot togole tonoŋ, eriŋ naut a Jutea evi Sisarea, ale itoh ei. ");
INSERT INTO klv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Len nǝboŋ enan nǝlon aHerot epǝŋas alat a Tair mai a Siton, eṽitṽituh mai galito. Beti galito lub̃on len nǝnauan sua hǝn lǝb̃isor maii. Nab̃iltivanuan nauman siHerot, nahǝsan aPlastus, idam̃ mai galit ke tevi tarhǝt salito, ale lous ke likad natǝm̃at mai aHerot, asike lub̃al am. Lousi maienan husur loṽur p̃is nǝhanian halito len naut siHerot. ");
INSERT INTO klv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Len nǝboŋ hǝn nab̃onan, aHerot tosun nahurabat tobilbil, ebǝtah len nab̃iltihai bǝtbǝtah san ale ikel nasoran san mai galito ei. ");
INSERT INTO klv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Alat lotob̃onb̃on ei lukaikai ke, “Nagot sua satosor, savi vanuan.” ");
INSERT INTO klv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vǝha-sua ŋai, aŋel siNasub̃ iṽas aHerot husur gai sasor gol galit, saputsan nahǝsan aGot, ŋa natugulas gail luhani, imat. ");
INSERT INTO klv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Be nasoruan siGot iperperŋan naut gail am, nǝvanuan isob̃ur am losǝsǝloŋ hǝni, loriŋ nǝlolit len aYesu. ");
INSERT INTO klv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nǝboŋ aParnapas mai aSol artolav nǝvat mai alat siYesu len naut a Jerusalem tonoŋ, arotǝlmam vi Antiok, ale aJon Mak itah mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Len alat siYesu len naut a Antiok, ikad ahai kelkel ur gail mai ahai p̃usan gail: aParnapas, aSimeon lotokisi hǝn aNiker, Lusius a Sairin, aManaen (lotohisi mai aHerot Antipas) mai namǝkot aSol. ");
INSERT INTO klv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nǝboŋ lotolotu hǝn Nasub̃ mai lǝsǝhan, aNunun aGot ike, “Mititabtabuh len aParnapas mai aSol m̃os ginau hǝn arb̃igol nauman notokis gǝlar hǝni tia.” ");
INSERT INTO klv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ŋa nǝboŋ lǝsǝhan, lotosor tuṽ tonoŋ, loriŋ navǝlalit len gǝlaru mai losǝvat gǝlaru van. ");
INSERT INTO klv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Imagenan aNunun aGot esǝvat gǝlaru van ale arovi Seleusia bitas. Arusah len nab̃iltib̃ot, aruwol vi lan naholoul Saiprus. ");
INSERT INTO klv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nǝboŋ artobar naut a Salamis, navile sual a Saiprus, arukel ur nasoruan siGot len naim nab̃onb̃onan gail seJu. Arukad aJon Mak am hǝn toum mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nǝboŋ lotolavutur len naholoul kavkav van vǝbar naut a Pafos, lusab̃ naJu sua, nǝvanuan nabehi tovi ahai kelkel ur gǝgǝras, nahǝsan aParyesu. ");
INSERT INTO klv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Gai itah mai aSerkius Paulus tovi gavna len naut a Saiprus. Agavna enan evi nǝvanuan tolǝboi natite ale episul hǝn aParnapas mai aSol gǝmai hǝn b̃esǝsǝloŋ hǝn nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Be nǝvanuan nabehi enan, nahǝsan aElimas len nasoruan ta Kris, isor tas gǝlaru ale igol risi ke agavna asike edǝlom nǝsa artokel uri. ");
INSERT INTO klv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Beti aSol, nahǝsan togon aPol, topul hǝn aNunun aGot, ekǝta mǝtaltal van hǝn aElimas ike, ");
INSERT INTO klv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Gaiug gopul hǝn nalibliboŋan mai nagǝgǝrasan, govi anatun natǝmat, govi enemi hǝn natit p̃isi tonor. Gugol nap̃isal tonor siNasub̃ ihab̃ tabtab, gesib hǝni ŋais? ");
INSERT INTO klv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gagai Nasub̃ tipansem gaiug. Dereh gevi metb̃esw. Len nǝmariboŋ galevis dereh gedǝdas gǝb̃ekǝta ris nǝyal!” Vǝha-sua ŋai namǝtan arumotmot ale itaŋtaŋ kitev avan ideh hǝn b̃etǝgau navǝlan hǝn b̃esǝhari. ");
INSERT INTO klv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nǝboŋ agavna enan toris nǝsa tovisi, ikad nadǝlomian husur ip̃aŋ len nap̃usanan husur Nasub̃. ");
INSERT INTO klv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","APol mai alat lototah maii loriŋ naut a Pafos, luwol vi Perka len naut a Pamfilia. Be aJon Mak eriŋ galito, etǝlmam vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Loriŋ naut a Perka luvahut van vǝbar naut a Antiok, navile sual a Pisitia. Len nǝSappat lob̃is lohoim len naim nab̃onb̃onan seJu ale lobǝtah. ");
INSERT INTO klv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nǝboŋ naṽuruŋian hǝn nalo siMoses mai natosian sihai kelkel ur gail tonoŋ, alat lotoil a m̃o len naim nab̃onb̃onan seJu lopisul van hǝn galit ke, “Bathudud, mǝtb̃ikad nasoruan b̃igol namtb̃elǝŋon b̃ivoi am len nǝlonamito, mitikele bai.” ");
INSERT INTO klv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ŋa aPol eil, eb̃il hǝn navǝlan ke lemǝdau ale ike, “UleIsrael gail mai gamit mǝtsavi Ju be mǝttomǝtahw len nǝyalyalan siGot, mǝtesǝsǝloŋ hǝn ginau! ");
INSERT INTO klv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","AGot silat a Israel ilekis hǝn atǝmadat ta sutuai; igol galit lusob̃ur masuṽ nǝboŋ lototohtoh hum nametb̃os gail len naut a Ijip. Len nǝdaŋan san totibau esǝhar galit dan naut enan. ");
INSERT INTO klv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Naut kǝmas lotohaihai, gai itah mai galit van vǝbar nasihau tovi 40 len naut masmas. ");
INSERT INTO klv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Beti ib̃al sǝhor p̃is naluṽoh lotomǝlevru hǝn nametb̃os len naut a Kenaan, ale epǝpehun nǝtan salit mai nǝvanuan san gail ");
INSERT INTO klv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Natgalenan evisi len nasihau tovi 450. Ale aGot itabtabuh len nǝmatsistret lotoil a m̃o hǝn galito vǝbar aSamuel tovi ahai kelkel ur. ");
INSERT INTO klv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Beti nǝvanuan gail lousi hǝn nakiŋ, ŋa aGot itabtabuh len aSol, anatun aKis, nahǝmar san tovi Penjamin, tovi kiŋ nasihau tovi 40. ");
INSERT INTO klv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Be aGot idakuv aSol, igol aTevit evi kiŋ salito. Isor ivoi husuri ke, ‘ATevit, anatun aJesse, evi naulum̃an notolǝmas buni; gai dereh tigol natit p̃isi notolǝŋoni.’ ");
INSERT INTO klv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Len nǝpasusan siTevit, aGot itabtabuh len avan sua, hum tokel gati a m̃o, hǝn tolav kuv alat a Israel dan nǝsaan salito, nahǝsan aYesu. ");
INSERT INTO klv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","A tahw hǝn nagǝmaian siYesu, aJon ikel uri tia mai alat a Israel p̃isi ke limaspair dan nǝsaan salito, limasbaptais. ");
INSERT INTO klv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nǝboŋ nauman siJon pǝpadaŋ hǝn tonoŋ aJon ike, ‘Gunau ke ginau ase? Aoa, nǝsavi atenan. Be atenan egǝm a tahw len ginau, ginau novi ut kǝmas ŋai, nǝsanor kasi hǝn nǝb̃isah rub̃at nǝhau hǝn naributbut san.’ ");
INSERT INTO klv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Bathudud siApraham mai gamit mǝtsavi Ju mǝttomǝtahw len nǝyalyalan siGot, aGot episul gǝm hǝn gidato, episul hǝn napisulan egai hǝn nǝ-lav-kuvi-an dan nǝsaan. ");
INSERT INTO klv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Alat a Jerusalem mai alat lotoil a m̃o salito lǝsakǝta lǝboi aYesu enan, ke aGot totabtabuh lan, lotǝtan hǝn nasoruan sihai kelkel ur gail lotoṽuruŋi len nǝSappat p̃isi. Ŋa lugol nǝsa ahai kelkel ur gail lotokele, isarpoh: len nǝnauan salit, timasmat. ");
INSERT INTO klv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Lǝsǝsab̃ natideh tonor hǝn b̃imat sile, be naut kǝmas natenan, lous aPilate hǝn b̃igole b̃imat. ");
INSERT INTO klv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nǝboŋ lotogol natit p̃isi ahai kelkel ur gail lototos husuri tonoŋ, lupat kuvi vi pan dan nǝhai, loriŋi ipat len nab̃urhuvat tovi b̃urhes. ");
INSERT INTO klv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Avil aGot igol ile mǝhat dan nǝmatan, ");
INSERT INTO klv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ale alat lotoyar maii gǝm a Kalili vi Jerusalem, lorisi len nǝmariboŋ tosob̃ur. Gagai galit lusor husuri mai nǝvanuan sidato, lukel ur nǝsa lotoris togole mai nǝsa lotosǝsǝloŋ hǝn tokele. ");
INSERT INTO klv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ginamǝru, namrukel mai gamito na-kel-uri-an tovoi egai ke: Nǝsa aGot tokel gati mai atǝmadat ta sutuai, ");
INSERT INTO klv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","igol isarpoh m̃os gidato, anatulito. Igole nǝboŋ tolav kuv aYesu dan nǝmatan. Sum̃an aTevit totosi len nǝb̃e na-vǝha-ru-an ke, “‘Gaiug govi aNatugw ulum̃an, damǝŋai ginau nogǝm vi Tǝmam̃.’ ");
INSERT INTO klv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","AGot igol ile mǝhat dan nǝmatan hǝn asike b̃ib̃os nǝtan. Imaienan aGot ekǝmaiegai ke, “‘Neviol mai gamito hǝn nǝsa notokel gati mai atǝmamit ta sutuai aTevit.’ ");
INSERT INTO klv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ŋa len nǝb̃e sual am aTevit ike, “‘Gǝsǝdam̃ hǝn Nǝvanuan Sam̃ b̃ib̃os nǝtan.’ ");
INSERT INTO klv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Husur nǝboŋ aTevit tomaur sal, igol p̃is nǝsa aGot tolǝŋoni, ale ipat len nǝmatan, lotavuni mai atǝman gail ta sutuai, ale niben ib̃os nǝtan. ");
INSERT INTO klv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Avil atenan aGot togol tole mǝhat dan nǝmatan, atenan sab̃os nǝtan. ");
INSERT INTO klv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bathudud, husur natgalenan, namtukel uri mai gamito hǝn mǝtb̃elǝboii ke, len aYesu, aGot elǝboi b̃erub̃at nǝsaan samito. ");
INSERT INTO klv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","AGot eriŋi ke nǝvanuan p̃isi lotokad nadǝlomian len aYesu, lunor len nǝhon, len nǝsa aYesu togole. Be nalo siMoses edǝdas b̃eriŋi ke avan ideh tonor len nǝhon aGot. ");
INSERT INTO klv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mǝtelǝlǝgau hǝn ke nǝsa ahai kelkel ur gail lotokele satevisi hǝn gamito. Lokǝmaiegai ke, ");
INSERT INTO klv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Mǝteris, gamit mǝttosor viles ginau, mitip̃aŋ ale mitimat! Dereh nigol natsua len nǝboŋ samito, ale asike mǝtodǝlomi ke tokitin, naut kǝmas avan ideh b̃ikel husuri mai gamito.’” ");
INSERT INTO klv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nǝboŋ aPol mai aParnapas artovivile, nǝvanuan gail lous gǝlaru hǝn arb̃isor husur natgalenan tǝtas len nǝSappat togon. ");
INSERT INTO klv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nǝboŋ nab̃onan tonoŋ mai lotopǝpehw, naJu tosob̃ur mai alat lǝsavi Ju lotohusur kitin hǝn aGot, lohusur aPol mai aParnapas. Arusor mai galito ale arukel mai galit ke leriŋ nǝlolit len aGot toviol kǝmas hǝn navoian mai galito. ");
INSERT INTO klv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Len nǝSappat togon pǝpadaŋ galit p̃isi len nab̃iltivile enan lub̃onb̃on hǝn lǝb̃esǝsǝloŋ hǝn nasoruan siNasub̃. ");
INSERT INTO klv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nǝboŋ alat lotoil a m̃o hǝn naJu gail lotoris naluṽoh, lutab̃ulol bulos gǝlaru ale lusor tastas nǝsa aPol tokele, lusor mǝdas nahǝsan. ");
INSERT INTO klv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Beti namǝtahwan eb̃uer, aPol mai aParnapas arusor idaŋ var galit ke, “Inor hǝn namrtokel ur nasoruan siGot mai gamit metǝkav. Be bathut mǝttomǝtahuni, gamit mǝtugol imasil ke mǝtsanor hǝn mǝtb̃ikad nǝmauran vi sutuai. Husur enan gagai namroriŋ gamito, namrulav nasoruan siGot mai alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Husur Nasub̃ aGot ikele hǝn ginamit tia ke, “‘Ginau nugol gaiug govi nam̃ial m̃os alat lǝsavi Ju, hǝn gǝb̃ikel ur nǝ-lav-kuvi-an dan nǝsaan mai nǝvanuan p̃isi len navile a pan kavkav.’” ");
INSERT INTO klv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nǝboŋ alat lǝsavi Ju lotosǝsǝloŋ hǝn natgalenan, lohǝhaṽur ale lusal suh nasoruan siNasub̃. Galit p̃isi aGot totabtabuh len galit hǝn lǝb̃imaur vi sutuai, lodǝlom nasoruan enan. ");
INSERT INTO klv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nasoruan siNasub̃ iperŋan naut p̃isi lotodar vis naut enan. ");
INSERT INTO klv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Avil alatpǝhaṽut lotoṽat nǝhes lotolotu hǝn aGot, mai alalum̃an lotoil a m̃o len nab̃iltivile enan, naJu gail lugol ke lotomǝtahun aPol mai aParnapas. Ale lomǝdas tabtab hǝn aPol mai aParnapas beti lohut gǝlaru dan naut en salito. ");
INSERT INTO klv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ŋa gǝlaru arudardar hǝn narielaru hǝn nǝmasiav naut enan b̃imakuv hǝn b̃imasil ke aGot tomǝtahun galito, dereh tipansem galito. Beti arovi Ikonium. ");
INSERT INTO klv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ale ahai susur gail lopul tabtab hǝn nakemkeman mai aNunun aGot. ");
INSERT INTO klv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Len naut a Ikonium aPol mai aParnapas arovi lan naim nab̃onb̃onan seJu hum naṽide sǝlaru. Nasoruan sǝlaru igol isob̃ur lukad nadǝlomian, naJu gail mai alat a Kris. ");
INSERT INTO klv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Be naJu galevis lotohaihai, lugol alat lǝsavi Ju nǝlolit epǝŋas nǝvanuan nadǝlomian gail. ");
INSERT INTO klv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Imaienan aPol mai aParnapas arutoh ebǝlav ei. Arsamǝtahw, arusor m̃os Nasub̃. Ale Nasub̃ igol p̃arp̃ar hǝni ke, napisulan artokele husur navoian toviol kǝmas hǝni ekitin, bathut len nǝdaŋan san arolǝboi arb̃igol namerikel gail. ");
INSERT INTO klv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Alat lototoh len navile enan lopǝpehw. Galevis lohusur nǝnauan seJu gail, galevis lohusur nap̃usanan sihai pispisul eru enan. ");
INSERT INTO klv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Alat lǝsavi Ju, naJu gail mai alat lotoil a m̃o hǝn galito, lusor utaut hǝni ke, lemǝdas gǝlaru ale letubun gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nǝboŋ artolǝboii ke b̃imaienan, arugam yav vi lan nab̃iltivile eru, a Listra mai a Terpe len naut a Likaonia. ");
INSERT INTO klv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Len nǝyaran sǝlaru pǝpadaŋ hǝn nab̃iltivile eru enan, arukelkel na-kel-uri-an tovoi mai nǝvanuan gail. ");
INSERT INTO klv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Len naut a Listra ikad avan sua tobǝtah, narien gǝlar p̃isi arugau. Nǝboŋ lotopasi, imaienan tia. Gai sǝyar boŋ ideh. ");
INSERT INTO klv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Atenan esǝsǝloŋ hǝn aPol nǝboŋ tosor. APol ekǝta van hǝni ale eris lǝboii ke tokad nadǝlomian hǝn b̃imaur. ");
INSERT INTO klv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","APol ikai habat van hǝni ke, “Gile mǝhat len nariem̃! Geil!” Ale aten emǝlah vi mǝhat, etub̃at yar. ");
INSERT INTO klv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nǝboŋ naluṽoh lotoris nǝsa aPol togole, lukai len nasoruan ta Likaonia ke, “Nagot gail logǝm vi pan hǝn gidato, logǝm vi vanuan.” ");
INSERT INTO klv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Lokis aParnapas hǝn aSeus mai aPol hǝn aHermes husur aPol tokel ur nasoruan. ");
INSERT INTO klv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ikad naim nalotuan siSeus vivile hǝn nab̃iltivile. Ahai tutumav siSeus esǝhar nab̃uluk ulum̃an gail lotowan nahorasal van hǝn nametlǝkau hǝn nab̃iltivile, husur gai mai naluṽoh luke letutumav van hǝn gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Avil nǝboŋ ahai pispisul eru, aParnapas mai aPol artosǝsǝloŋ hǝn natenan, arutar nahurabat sǝlaru, arom̃ur van hǝn naluṽoh, arukai ke, ");
INSERT INTO klv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Lalum̃an, imabe mǝtugol nategai? Namrovi vanuan ŋai sum̃an gamito. Namrogǝm hǝn namrb̃ikel na-kel-uri-an tovoi mai gamit hǝn mǝtb̃ipair dan natgaleg lotodǝdas lǝb̃evi tarhǝt samito, van hǝn aGot tovi nǝkadun nǝmauran. Gai igol nǝmav mai nǝtan mai nǝtas mai natit p̃isi lotosuh len gail. ");
INSERT INTO klv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sutuai tia idam̃ hǝni ke naluṽoh hǝn nǝvanuan tiltile gail lotohusur nap̃isal salit ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Naut kǝmas natenan, igol nǝvanuan p̃isi lolǝboi lǝb̃eris lǝboi gai len navoian togole. Eviol hǝn naus togǝm len nǝmav, eviol hǝn nǝhanian toṽan len nǝboŋ han; igol ke mǝttopul hǝn nǝhanian mai nǝlomit topul hǝn nakemkeman.” ");
INSERT INTO klv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Be naut kǝmas artokǝmaienan, arusab̃i ke idaŋ hǝn arb̃igol ke lǝb̃esib hǝn natutumavan salito. ");
INSERT INTO klv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Beti len nǝboŋ tile naJu galevis logǝm len naut a Antiok mai a Ikonium, ale lupair hǝn nǝnauan sinaluṽoh van hǝn galito. Lotuṽ aPol ke timat ale loliv gargari vivile len nab̃iltivile husur lunau ke tomat. ");
INSERT INTO klv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Be nǝboŋ ahai susur gail lotob̃on il garu hǝn aPol, ile mǝhat, iyar tǝlmam van hǝn nab̃iltivile. Pelan han aPol mai aParnapas aroriŋ naut a Listra, arovi Terpe. ");
INSERT INTO klv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Arukel na-kel-uri-an tovoi len naut a Terpe ale lusob̃ur logǝm vi hai susur siYesu gail. Beti arotǝlmam vi Listra, Ikonium mai Antiok. ");
INSERT INTO klv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Arugol ahai susur gail ludaŋ am, arugol lolǝŋon ivoi am len nǝlolito hǝn lǝb̃eil gǝgat len nadǝlomian. Aruke, “Datimasdaŋ b̃ur na-lǝŋon-isa-an tosob̃ur hǝn datb̃eb̃is len natohan pipihabǝlan aGot.” ");
INSERT INTO klv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","APol mai aParnapas arutabtabuh len ahaṽut galevis hǝn lǝb̃eil a m̃o hǝn alat siYesu len naut ṽisusua. Arusor tuṽ, arsǝhan, ale aroriŋ galit len navǝlan Nasub̃, gai lotoriŋ nǝlolit lan. ");
INSERT INTO klv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nǝboŋ artoyar tur len naut gail a Pisitia, arubar naut a Pamfilia. ");
INSERT INTO klv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ale len naut enan, nǝboŋ artokel ur nasoruan len nab̃iltivile Perka tonoŋ, arovi pan vi Attalia bitas. ");
INSERT INTO klv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Aroriŋ nab̃iltivile Attalia, aruwol tǝlmam vi Antiok. Evi alat siYesu len naut a Antiok lotoriŋ gǝlaru len navǝlan aGot m̃os nauman artomadhaum vurvuri. ");
INSERT INTO klv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nǝboŋ artobar naut a Antiok, arous alat siYesu ei hǝn lǝb̃ib̃onb̃on, ale arukel ur mai galit natit p̃isi aGot togole len nab̃onan sǝlaru maii. Arukel husur nap̃isal aGot togole hǝn b̃esǝŋav hǝn nabopita hǝn nadǝlomian m̃os alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Beti arutoh mai ahai susur gail ei ebǝlav. ");
INSERT INTO klv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Alatevis lotovi Ju logǝm a Jutea vi Antiok. Loṽusan nǝvanuan nadǝlomian gail ei maiegai ke, “Asike lǝb̃etiv dalus gamito mǝttovi lalum̃an, hum naṽide siMoses, aGot asike ilav kuv gamit dan nǝsaan samito.” ");
INSERT INTO klv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","APol mai aParnapas arusor tas nap̃usanan salito ale arusor b̃alb̃al mai galito. Ŋa alat siYesu lutabtabuh len aPol mai aParnapas mai galevis am hǝn lǝb̃evi Jerusalem hǝn lǝb̃isor mai ahai pispisul gail mai alat lotoil a m̃o hǝn alat siYesu husur nap̃usanan enan. ");
INSERT INTO klv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ale alat siYesu losǝvat galit vi Jerusalem. Luyar tur len naut gail a Fonisia mai a Samaria, ale len nǝyaran salito lusor husur nǝpairan van hǝn aGot silat lǝsavi Ju. Na-kel-uri-an enan igol nǝvanuan nadǝlomian gail lukemkem masuṽ. ");
INSERT INTO klv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nǝboŋ lotobar naut a Jerusalem, alat siYesu, ahai pispisul gail mai alat lotoil a m̃o luke, “Ivoi,” mai galito. Beti lukel mai alat a Jerusalem natit p̃isi aGot togole len nab̃onan salit maii. ");
INSERT INTO klv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nǝvanuan nadǝlomian galevis lotovi Farisi gail, lule mǝhat, luke, “Alat lǝsavi Ju limaskad na-tiv-dalusi-an mai namtimassor tidaŋ mai galito ke, limasgol husur nalo siMoses.” ");
INSERT INTO klv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ahai pispisul gail mai alat lotoil a m̃o lub̃onb̃on hǝn lǝb̃isor husur natenan. ");
INSERT INTO klv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nǝboŋ lotosor b̃alb̃al sil naten tobǝlav, aPita ile mǝhat, isor mai galit ke, “Bathudud, mǝtolǝboii ke len nǝboŋ ta m̃o aGot itabtabuh len ginau, hum gidat sua, hǝn nǝb̃ikel na-kel-uri-an tovoi mai alat lǝsavi Ju, hǝn lǝb̃esǝsǝloŋ hǝni ale dǝlomi. ");
INSERT INTO klv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","AGot tolǝboi nǝlon nǝvanuan p̃isi, igol imasil ke tolekis hǝn galito, husur ke toviol hǝn aNunun mai galito sum̃an toviol hǝni mai gidat dattovi Ju. ");
INSERT INTO klv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","AGot igol ke lǝsatile len gidato. Len nadǝlomian salito igol nǝlolit iveveu. ");
INSERT INTO klv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Imabe mǝtsǝdam̃ hǝn nǝsa aGot togole tia? Mǝtuke nǝlon aGot tipaŋpaŋ a? Imabe mǝtoriŋ na-gol-husur-nalo-an tomǝlas habat len alat lǝsavi Ju, be gidato mai atǝmadat gail ta sutuai datodǝdas datb̃evusi? ");
INSERT INTO klv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Satimaienan! Datolǝboii ke len navoian aYesu toviol kǝmas hǝni mai gidato, aGot ilav kuv gidato dan nǝsaan sidato. Ep̃itoṽ hǝn alatenan lǝsavi Ju.” ");
INSERT INTO klv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Galit p̃isi len nab̃onb̃onan lǝsasor, losǝsǝloŋ nǝboŋ aParnapas mai aPol artosor husur namerikel gail aGot togol ke arugole len alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nǝboŋ artosor tonoŋ, aJemes isor ike, “Mǝtesǝsǝloŋ hǝn ginau. ");
INSERT INTO klv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Mitinau gat nǝboŋ aSimon tosor vǝsvǝsai mai gidato, nap̃isal nametǝkav aGot togole nǝboŋ togǝm tǝban alat lǝsavi Ju, hǝn b̃ilav dan galito naluṽoh sua hǝn lǝb̃evi esan sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nasoruan sihai kelkel ur gail inor hǝn nǝsa aSimon Pita tokele, hum lototos nasoruan siGot ke, ");
INSERT INTO klv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Len nǝboŋ enan dereh netǝlmam ale neum tǝlmam hǝn naim nǝtap̃olen siTevit tomaruŋruŋ, nǝsa tomǝtartar dereh neum tǝlmam hǝni ale nigole tehun ta m̃o, nǝpasusan siTevit dereh tegǝm vi kiŋ tǝtas. ");
INSERT INTO klv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Imaienan galit p̃isi am, nǝvanuan naut tiltile gail nahǝsagw topat len galito, dereh leusus kitev ginau hǝn lǝb̃elǝboi ginau. Nasub̃ aGot togol ke, nǝvanuan gail lolǝboi natgalenan sutuai tia, gai ekǝmaienan.’” ");
INSERT INTO klv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","AJemes isor am ke, “Noriŋi timaiegai ke: sadatigol tidaŋ hǝn alat lǝsavi Ju lotopair van hǝn aGot. ");
INSERT INTO klv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Avil gidat datitos nalob̃ulat van hǝn galit b̃ike, salihan namǝŋod lototutumav hǝni van hǝn nǝlablab ideh, saligol naitian tosa, salihan namǝŋod lotobaŋis bun navǝdolon mai salihan o mun nǝda. ");
INSERT INTO klv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Husur ta sutuai lukel ur nǝsa aMoses totosi len navile p̃isi mai loṽuruŋi len naim nab̃onb̃onan seJu gail len nǝSappat p̃isi.” ");
INSERT INTO klv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Beti ahai pispisul gail, alat lotoil a m̃o mai alat siYesu p̃isi, lusor sab̃i ke litabtabuh len galit galevis hǝn lǝb̃esǝvat galito vi Antiok mai aPol mai aParnapas. Losǝvat galit eru artoil a m̃o hǝn alat siYesu ei. Nahǝsalaru aJutas (lokisi hǝn aParsappas) mai aSilas. ");
INSERT INTO klv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Arulav nalob̃ulat egai: Ginamit, ahai pispisul gail, alat lotoil a m̃o mai alat siYesu, namtutos nalob̃ulat egai van hǝn gamit mǝttovi nǝbathudud siYesu mǝtsavi Ju len naut a Antiok, a Siria mai naprovens Silisia; namtuke “Ivoi!” mai gamito. ");
INSERT INTO klv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Namtosǝsǝloŋ hǝni ke ginamit galevis luvan hǝn gamito, be nǝ-dam-hǝni-an sinamit eb̃uer. Lugol gamit nǝlomit isa mai nǝnauan samit ebutbutut husur nǝsa lotokele. ");
INSERT INTO klv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Imaienan ginamit p̃isi namtusor sab̃i ke namtitabtabuh len naulum̃an galevis hǝn namtb̃esǝvat galito van hǝn gamito. Lutah mai aParnapas mai aPol, namttolǝmas bun gǝlaru, ");
INSERT INTO klv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","artodam̃ hǝn nǝmauran sǝlaru m̃os nahǝsan aMasta sidato, aYesu Kristo. ");
INSERT INTO klv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Imagenan namtosǝvat aJutas mai aSilas hǝn gǝlar arb̃ikel natgalegai mai gamito top̃itoṽ hǝn namttotosi. ");
INSERT INTO klv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ANunun aGot mai ginamito namtukad nǝnauan esua ke, ivoi ke asike mǝtovus na-gol-husur-nalo-an tomǝlas habat, avil nalo galegai tovis ŋai ke: ");
INSERT INTO klv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Samtihan namǝŋod lototutumav hǝni van hǝn nǝlablab ideh, samtihan nǝda. Samtihan namǝŋod lotobaŋis bun navǝdolon mai samtigol naitian tosa. Mǝtb̃ehusur nǝ-kai-tasi-an galenan, mitigol nǝsa tovoi. Enan ŋai, pelan. ");
INSERT INTO klv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Alat siYesu a Jerusalem losǝvat ahai pispisul gail vi Antiok. Nǝboŋ lotobar naut enan, lugol alat siYesu lub̃onb̃on ale lulav nalob̃ulat mai galito. ");
INSERT INTO klv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nǝboŋ nǝvanuan gail lotoṽuruŋ nalob̃ulat enan, lukemkem masuṽ husur igol lolǝŋon ivoi am len nǝlolito. ");
INSERT INTO klv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","AJutas mai aSilas, gǝlaru artovi hai kelkel ur, arusor habat hǝn arb̃igol alat lotokad nadǝlomian lǝb̃elǝŋon b̃ivoi am len nǝlolito mai lǝb̃idaŋ am. ");
INSERT INTO klv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Nǝboŋ artotoh len nǝmariboŋ galevis, nǝvanuan nadǝlomian gail losǝvat gǝlar tǝlmam vi Jerusalem len navoian hǝn arb̃etǝlmam van hǝn alat lotosǝvat gǝlar vi Antiok. ");
INSERT INTO klv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Be aPol mai aParnapas arutoh len naut a Antiok. Gǝlaru mai isob̃ur am lop̃usan, lukel ur nasoruan siNasub̃. ");
INSERT INTO klv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Husur nǝmariboŋ galevis, aPol isor mai aParnapas ke, “Daretǝlmam vi lan nab̃iltivile p̃isi dartokel ur nasoruan siNasub̃ lan hǝn darb̃eris alat lotokad nadǝlomian ke lumabe.” ");
INSERT INTO klv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","AParnapas ike tesǝhar aJon lotokisi hǝn aMak mai gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Avil aPol idaŋ ke, husur atenan togam dan gǝlaru len naut a Pamfilia ale sǝtah mai gǝlar len nauman, saaresǝhari. ");
INSERT INTO klv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Arusor b̃alb̃al habat ŋa aropǝpehw, ale aParnapas esǝhar aMak, aruwol vi Saiprus. ");
INSERT INTO klv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Be aPol ilekis len aSilas, ale nǝboŋ ahai susur gail lotoriŋi len navǝlan aGot, eriŋ naut enan. ");
INSERT INTO klv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","APol mai aSilas aruyar tur len naut gail a Siria mai naprovens Silisia, arugol alat siYesu gail ludaŋ am. ");
INSERT INTO klv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","APol iyar van vǝbar naut a Terpe mai a Listra. Len naut a Listra ikad ahai susur sua nahǝsan aTimoti, anan evi Ju tokad nadǝlomian, be atǝman evi uleKris. ");
INSERT INTO klv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Alat lotokad nadǝlomian len naut a Listra mai a Ikonium luke gai evi vanuan tovoi. ");
INSERT INTO klv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","APol ike aTimoti titah maii len nǝyaran san, ale esǝhari hǝn b̃etiv dalusi bathut naJu gail lotosuh len naut galenan, husur galit p̃isi lolǝboii ke atǝman evi uleKris. ");
INSERT INTO klv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Len nǝ-yar-tur-an salito len nab̃iltivile gail, lukel mai alatenan nǝ-kai-tasi-an hǝn lǝb̃igol husuri, nǝ-kai-tasi-an ahai pispisul gail mai alat lotoil a m̃o len naut a Jerusalem lotodam̃ hǝni. ");
INSERT INTO klv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Imagenan alat siYesu len naut gail ludaŋ am len nadǝlomian salito mai logǝm lusob̃ur am len nǝmariboŋ ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol galito luyar tur len naut gail a Frijia mai a Kalatia husur aNunun aGot ekǝkol hǝn nap̃isal hǝn lǝb̃ikel ur nasoruan len naprovens Asia. ");
INSERT INTO klv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nǝboŋ lotobar naut a Misia, lugol risi ke levi lan naprovens Pitinia be aNunun aYesu ip̃on gol galito. ");
INSERT INTO klv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ŋa luyar tur naut gail a Misia, lovi pan vi Troas bitas. ");
INSERT INTO klv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Len mariug aPol eris na-kǝta-risi-an togǝm len nǝmav. Ikad auleMasetonia toil ŋiri ke, “Gegǝm vi Masetonia hǝn gǝb̃evi tarhǝt sinamito.” ");
INSERT INTO klv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nǝboŋ toris na-kǝta-risi-an tonoŋ, vǝha-sua ŋai eutaut hǝn namtb̃evi Masetonia husur inau sǝhoti ke aGot ike namtikel ur na-kel-uri-an tovoi mai galit ei. ");
INSERT INTO klv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nǝboŋ namttoriŋ naut a Troas, namtuwol inor vi lan naholoul Samotras. Pelan han namtuvahut len naut a Neap̃olis. ");
INSERT INTO klv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Namtoriŋ naut enan, namtuyar vi Filippi, alat a Rom lotoum hǝni vatoh lan. Evi nab̃iltivile sua toil a m̃o len naprovens Masetonia. Namtutoh ei len nǝmariboŋ galevis. ");
INSERT INTO klv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Len nǝSappat namtovivile metlǝkau hǝn navile tarhǝt hǝn nawisel. Namtunau ke ikad naut hǝn na-sor-tuṽ-an ei, ale namtobǝtah, namtusor mai alatpǝhaṽut lotob̃onb̃on ei. ");
INSERT INTO klv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ikad apǝhaṽut sua, nahǝsan aLitia, tolotu hǝn aGot, tosǝsǝloŋ hǝn ginamito. Evi tob̃taTiatira top̃ur hǝn nǝkaliko toboŋboŋ. Nasub̃ eb̃ur nǝlon hǝn b̃esǝsǝloŋ husur nǝsa aPol tokele. ");
INSERT INTO klv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nǝboŋ gai mai alat lototoh maii lotobaptais tonoŋ, eus ginamit ke, “Mǝtb̃isab̃ sǝhoti ke notodǝlom kitin len Nasub̃, mǝtegǝm hǝn mǝtb̃itoh len naim sagw.” Ale igol ke namtudam̃ hǝni. ");
INSERT INTO klv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Len nǝboŋ sua namtovi lan naut na-sor-tuṽ-an enan ale natǝbarehreh sua tovi slev, ebubur mai ginamito. Gai ikad natǝmat togol ke, ikel ur nǝsa b̃evisi. Imagenan alat lotokad naslev enan lulav nǝvat isob̃ur lan. ");
INSERT INTO klv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Alitenan ehusur aPol mai ginamito, ikaikai ke, “Lalum̃an galegai lovi slev siGot toyalyal buni. Lukel uri mai gamito nap̃isal hǝn nǝ-lav-kuvi-an dan nǝsaan samito.” ");
INSERT INTO klv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ehisi imagenan len nǝboŋ tosob̃ur. Be igol nǝlon aPol ipaŋpaŋ, ipair van hǝni, ikel mai natǝmat ke, “Nukele idaŋ mai gaiug len nahǝsan aYesu Kristo, gimakuv dani.” Vǝha-sua ŋai imakuv. ");
INSERT INTO klv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Be nǝboŋ alat lotokad naslev enan lotolǝboii ke alitenan edǝdas b̃ilav nǝvat ideh am m̃os galito, lutah gat aPol mai aSilas, liv gargar gǝlaru vi lan nǝmaket hǝn lǝb̃eriŋ gǝlaru len nǝhon alat lotoil a m̃o len nab̃iltivile. ");
INSERT INTO klv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nǝboŋ lotosǝhar gǝlaru van hǝn nab̃iltimatsistret gail, luke, “Alaruegai arugol nǝ-b̃al-taṽtaṽor-an len nab̃iltivile sidato. Arovi uleJutea, ");
INSERT INTO klv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ale arukel ur naṽide gail nalo sidat toke sanor hǝn datb̃idam̃ hǝni mai datb̃ehusuri, husur datovi uleRom gail.” ");
INSERT INTO klv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Naluṽoh am lomǝtahun gǝlaru ale nab̃iltimatsistret gail lukel mai nasoltia ke, litar sil nahurabat sǝlaru ale ṽas gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nǝboŋ lotoṽas gǝlaru vǝha-sob̃ur, lubar hǝn gǝlar len naim bǝbaŋis. Ale lukele hǝn naulum̃an hǝn naim bǝbaŋis ke tekǝtkǝta kǝkol gat gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Igol nǝsa lotokele, eriŋ gǝlaru len narum̃ lohoim buni ale ibaŋis gat narielaru len nǝhai. ");
INSERT INTO klv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tub̃loh len mariug aPol mai aSilas arusor tuṽ mai arokǝkai hǝn nǝb̃e gail van hǝn aGot, ale alat lotosuh len naim bǝbaŋis losǝsǝloŋ hǝn gǝlaru. ");
INSERT INTO klv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Losǝhoṽut, nadu todaŋ ekur hǝn nǝpaudesen hǝn naim bǝbaŋis. Vǝha-sua ŋai nabopita gail losǝŋav ale natsen salit p̃isi lumarub̃. ");
INSERT INTO klv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nǝboŋ naulum̃an hǝn naim bǝbaŋis tolele, toris nabopita lotosǝŋav, eliv kuv nab̃iltib̃u san hǝn b̃isar bun gai gabag, husur inau ke alat lotosuh ei lugam yav tia. ");
INSERT INTO klv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Be aPol ikai habat ke, “Sagisar gaiug! Gidat p̃isi datosuh gegai.” ");
INSERT INTO klv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Naulum̃an enan eus nam̃ial, igam lohoim, ale ipab, etǝŋedur bathurien aPol mai aSilas. ");
INSERT INTO klv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Beti esǝhar gǝlaru vivile, eus gǝlar ke, “Nasub̃ gǝlaru, nigol nǝsa hǝn asike nǝb̃ipanis sil nǝsaan sagw?” ");
INSERT INTO klv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Arusor vari ke, “Gikad nadǝlomian len Nasub̃ aYesu ale dereh tilav kuv gaiug dan nǝsaan sam̃. Imagenan hǝn alat lotosuh len naim sam̃ am.” ");
INSERT INTO klv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ale arukel nasoruan siNasub̃ mai atenan, mai alat lotosuh len naim san. ");
INSERT INTO klv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Len namityal enan len mariug, ekǝkas nahurhubelaru tomap̃ulp̃ul, beti gai mai nǝbathudud san lubaptais. ");
INSERT INTO klv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Esǝhar gǝlaru vi lohoim ale eriŋ nǝhanian a m̃o hǝn gǝlaru ale gai mai galit p̃isi lotosuh maii lukemkem masuṽ bathut nadǝlomian lotomadhakade len aGot. ");
INSERT INTO klv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Len naut tolan nǝmatsistret gail losǝvat alipah gail hǝn lǝb̃ike, “Sah rub̃at alaruenan arivan.” ");
INSERT INTO klv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ale naulum̃an hǝn naim bǝbaŋis ikel mai aPol ke, “Nǝmatsistret gail lopisul ke nǝb̃erub̃at gamǝru. Imagenan mǝrolǝboi mǝrb̃eriŋ naut egai. Mirivan mǝdau.” ");
INSERT INTO klv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Avil aPol ikel mai alipah gail ke, “Lobilas ginamǝru len nǝhon nǝvanuan gail be lǝsakot hǝn ginamǝru. Naut kǝmas namrovi uleRom, lubar hǝn ginamǝru len naim bǝbaŋis. Galit lunau ke lesǝvat ginamǝru vi tut hǝn ke nǝvanuan gail asike lǝb̃elǝboii a? Aoa! Ivoi ke galit sǝb̃olit m̃au legǝm sǝhar kuv ginamǝru.” ");
INSERT INTO klv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Alipah gail lukel ur nasoruan enan mai nǝmatsistret gail. Lomǝtahw nǝboŋ lotosǝsǝloŋ hǝni ke gǝlaru artovi uleRom. ");
INSERT INTO klv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ŋa luvan vaus gǝlaru ke saarinau gat nǝsa lotogol tosa hǝn gǝlaru. Beti losǝhar gǝlaru vivile ale lous gǝlaru hǝn arb̃eriŋ nab̃iltivile enan. ");
INSERT INTO klv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nǝboŋ artoriŋ naim bǝbaŋis, arovi lan naim seLitia, ale nǝboŋ artoris nǝvanuan nadǝlomian gail, arugol lolǝŋon ivoi am len nǝlolito, beti aruvan. ");
INSERT INTO klv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nǝboŋ aPol galit lotoyar tur len naut a Amfip̃olis mai a Ap̃ollonia, lubar naut a Tessalonika, naut enan tokad naim nab̃onb̃onan seJu gail. ");
INSERT INTO klv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Sum̃an naṽide san, aPol eb̃is lan ale len nǝSappat itor ikel ur mai galito nǝsa natosian siGot tokele. ");
INSERT INTO klv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Isor vahvah mai galito hǝn b̃eṽusan len natosian siGot ke, aKristo, aGot totabtabuh lan imaslǝŋon isa vǝmat mai imasle mǝhat dan nǝmatan. Ale aPol ike, “AYesu egaii notokel uri mai gamito, evi aKristo boh.” ");
INSERT INTO klv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Galit galevis lodǝlom nǝsa aPol tokele ale lub̃on mai aPol mai aSilas. Isob̃ur am lutah mai gǝlaru: alat a Kris lotolotu hǝn aGot, mai alatpǝhaṽut lotoil a m̃o len nab̃iltivile enan. ");
INSERT INTO klv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Be naJu lǝsadǝlom nasoruan siPol lutab̃ulol bulos gǝlaru, ale losǝhar naulum̃an galevis lotosa dan nǝmaket, lugol nǝvanuan gail loluṽoh hǝn lǝb̃ib̃al taṽtaṽor, mǝdas natit gail len nab̃iltivile enan. Lom̃ur van hǝn naim siJason hǝn lǝb̃idoŋ aPol mai aSilas hǝn lǝb̃ipat kuv gǝlaru vivile van hǝn naluṽoh. ");
INSERT INTO klv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nǝboŋ lǝsǝsab̃ gǝlaru, loliv gargar aJason mai nǝvanuan nadǝlomian gail tile van hǝn alat lotoil a m̃o len nab̃iltivile enan. Lukai habat ke, “Nǝvanuan galegai lotomǝdas naut p̃isi, gagai logǝm gegai. ");
INSERT INTO klv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ale Jason egai ehǝhaṽur hǝn lototoh lohoim san. Galit p̃isi lob̃ur kotov nalo seSisa a Rom, luke ikad nakiŋ tile, nahǝsan aYesu!” ");
INSERT INTO klv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nǝboŋ naluṽoh mai alat lotoil a m̃o lotosǝsǝloŋ hǝn natgalenan, lodǝdarŋab̃u masuṽ. ");
INSERT INTO klv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Imagenan lugol ke aJason mai nǝvanuan nadǝlomian gail lulav nǝvat mai galito hum na-kel-gati-an ke asike lomǝdas naut tǝtas am, ale loriŋ galito luvan. ");
INSERT INTO klv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Len mariug enan ŋai nǝvanuan nadǝlomian gail losǝvat aPol mai aSilas vi Perea. Nǝboŋ artobar naut enan arob̃is len naim nab̃onb̃onan seJu gail. ");
INSERT INTO klv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Len nab̃oruan salito, alat a Perea lohǝhaṽur hǝn lǝb̃esǝsǝdariŋ sǝhor alat a Tessalonika. Lolǝŋon masuṽ hǝn lǝb̃esǝsǝloŋ hǝn nasoruan. Len nǝboŋ p̃isi lobunus tas natosian siGot hǝn lǝb̃isab̃i ke aPol tokitin o sakitin. ");
INSERT INTO klv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Imagenan galit lusob̃ur lodǝlom nasoruan siGot; galevis lotovi tob̃taKris lotoṽat nǝhes mai auleKris isob̃ur. ");
INSERT INTO klv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Be nǝboŋ naJu gail len naut a Tessalonika lotosǝsǝloŋ lǝboii ke aPol tokel ur nasoruan siGot mai alat a Perea, luvan ei ale lusor tas aPol len naluṽoh, gol nǝlol paŋpaŋ mai nab̃iltidǝdarŋab̃uan len navile enan. ");
INSERT INTO klv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Beti vǝha-sua ŋai nǝvanuan nadǝlomian gail losǝvat aPol vi tut, vi lau len nabitas, be aSilas mai aTimoti arutoh. ");
INSERT INTO klv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Alat lotosǝhar aPol luyar maii vǝbar naut a Atens ale nǝboŋ lototǝlmam, lulav napisulan siPol ke, aSilas mai aTimoti aregǝm tah mai aPol tutut. ");
INSERT INTO klv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nǝboŋ aPol totoh vir gǝlaru len naut a Atens, nǝlon isa bathut eris ke nab̃iltivile epul hǝn nǝlablab tiltile lotolotu hǝni. ");
INSERT INTO klv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ŋa isor vahvah len naim nab̃onb̃onan mai naJu gail mai alat lǝsavi Ju lotolotlotu hǝn aGot. Ale len nǝboŋ p̃isi len nǝmaket ihol mai alat lototoh ei. ");
INSERT INTO klv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ahai p̃usan gail, lotokis galit hǝn Epikurian mai Stoik, lusor levlev mai aPol. Galevis luke, “Ategai tosor tavtav, gai ike tikel nǝsa?” Galevis am luke, “Esum̃an tovi ulum̃an na-kel-uri-an hǝn nagot dattotǝtan hǝn gail.” (Lokǝmaienan husur ikel ur aYesu mai na-le-mǝhat-an dan nǝmatan.) ");
INSERT INTO klv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ŋa losǝhar aPol van hǝn nǝkaunsel hǝn nǝAreopakus. Nǝmatsistret gail lotobǝtah lan lousi ke, “Namtuke namtelǝboi nap̃usanan veveu gotokel uri. ");
INSERT INTO klv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Namtosǝsǝloŋ hǝn natgalevis lototile masuṽ ale namtuke namtelǝboi namilelito.” ");
INSERT INTO klv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Alat a Atens mai nametb̃os gail lototoh ei, lusorsor husur mai losǝsǝloŋ tabtab hǝn nǝnauan ideh toveveu. ");
INSERT INTO klv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Beti aPol eil rivuh hǝn nǝAreopakus ike, “Alat a Atens, noris ke, mǝttonau masuṽ hǝn nalotuan van hǝn nagot samit gail. ");
INSERT INTO klv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Husur nǝboŋ notoyar tur len naut egai, nokǝta bunus natit mǝttolotu hǝn gail. Ale nusab̃ nǝmel tutumavan sua tokad natosian lan. Ike, ‘Van hǝn Nagot Datsalǝboii.’ Nǝsa mǝttolotu hǝni be mǝtsalǝboii, ategai nikel uri mai gamito. ");
INSERT INTO klv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","AGot togol navile a pan mai natit p̃isi lan, atenan tovi Nasub̃ hǝn nǝmav mai navile a pan, gai satoh len naim nalotuan nǝvanuan lotoum hǝn gail. ");
INSERT INTO klv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mai nǝvanuan gail lǝsalǝboi lǝb̃evi tarhǝt san husur gai sǝpar titideh bathut gai sǝb̃on eviol mai nǝvanuan p̃isi hǝn nǝmauran, nasuŋavŋavan mai natit p̃isi am. ");
INSERT INTO klv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Len nǝvanuan esua ŋai igol naluṽoh p̃isi hǝn nǝvanuan tiltile gail, hǝn lǝb̃itoh len navile a pan kavkav. Ale eriŋ gat nǝboŋ hǝn natohan salito mai naut a im salito. ");
INSERT INTO klv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Igol natgalenan hǝn lǝb̃iyar kitev aGot, mai hum ma lǝb̃itaŋtaŋ kitevi ale sab̃i, naut kǝmas ke satoh a tut dan gidat ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bathut “‘Len gai datukad nǝmauran, datugol natideh dattogole mai datukad natohan.’ Hum galevis silat lototos nǝb̃e samito luke, “‘Gidat am datovi natun gail.’ ");
INSERT INTO klv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Imagenan, husur ke dattovi anatun aGot gail, sadatinau ke esum̃an nǝlablab hǝn nagol, nasilva o nǝvat mot, nǝlablab nǝvanuan toum hǝni len namitisau mai nǝnauan san. ");
INSERT INTO klv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A m̃o aGot sǝpansem alat lototǝtan hǝn nakitinan husuri. Ehum tokǝta sǝhor natǝtanan enan. Be len nǝboŋ ta damǝŋai van, isor idaŋ mai nǝvanuan p̃isi len naut p̃isi ke, lipair dan nǝsaan salito. ");
INSERT INTO klv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bathut aGot ilekis hǝn nǝboŋ tia hǝn ke, len nanoran gai dereh tikot hǝn nǝvanuan p̃isi len navile a pan. AGot gatotabtabuh len avan sua hǝn b̃ikot hǝn galito. Ale igol avan enan ip̃arp̃ar nǝboŋ togol tole mǝhat dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nǝboŋ lotosǝsǝloŋ hǝn aPol tosor husur na-le-mǝhat-an dan nǝmatan, galevis lusor vilesi, luman sili, be galevis am luke, “Namtuke namtesǝsǝloŋ hǝn gaiug tǝtas husur natenan.” ");
INSERT INTO klv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Imagenan aPol eriŋ galito. ");
INSERT INTO klv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Be galit galevis lutah maii, ale lukad nadǝlomian len aYesu: ikad aTionisius, tobǝtah len nǝAreopakus; apǝhaṽut sua, nahǝsan aTamaris, mai nǝvanuan galevis am. ");
INSERT INTO klv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Husur nǝboŋ enan aPol eriŋ naut a Atens, evi Korint. ");
INSERT INTO klv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Len naut enan ebubur mai naJu sua, nahǝsan aAkwila tovi ulePontus. Gai imadhagǝm a Itali mai asoan, aPrisilla, husur Klautius Sisa ikai hǝn naJu gail ke leriŋ naut a Rom. APol ia ris gǝlaru, ");
INSERT INTO klv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ale bathut nauman san inor hǝn sǝlaru, itoh mai gǝlaru ale loum b̃onb̃on. Galit p̃isi losǝsod im nǝtap̃olen. ");
INSERT INTO klv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Len nǝSappat p̃isi isor vahvah len naim nab̃onb̃onan seJu hǝn b̃igol naJu gail mai alat a Kris lelǝboi sǝhot nakitinan husur aYesu. ");
INSERT INTO klv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nǝboŋ aSilas mai aTimoti artogǝm len naprovens Masetonia tah mai aPol a Korint, aPol igol tabtab hǝn na-kel-uri-an ŋai, ikel uri mai naJu gail ke, aYesu evi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nǝboŋ lotomǝtahun aPol, sor mǝdas nahǝsan, aPol ekur hǝn nahurabat san hǝn b̃imasil ke, aGot sahǝhaṽur hǝn galito, ike, “Nǝsa b̃evisi hǝn gamito tipat len gamito! Asike ipat len ginau am. Gagai van nivan hǝn alat lǝsavi Ju.” ");
INSERT INTO klv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Beti eriŋ naim nab̃onb̃onan enan vi lan naim seTitius Justus, tolotu hǝn aGot; naim san ipat tarhǝt naim nab̃onb̃onan seJu. ");
INSERT INTO klv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","AKrispus, toil a m̃o hǝn naim nab̃onb̃onan, ikad nadǝlomian len Nasub̃ aYesu, gai mai alat lototoh maii. Isob̃ur len naut a Korint lotosǝsǝloŋ hǝn nasoruan siPol, lodǝlom na-kel-uri-an tovoi ale lubaptais. ");
INSERT INTO klv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Len nalenmariug sua Nasub̃ isor mai aPol len na-kǝta-risi-an sua ke, “Sagemǝtahw, be gisor, sagipat b̃utb̃ut; ");
INSERT INTO klv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","bathut nutoh mai gaiug. Ale sǝkad avan ideh hǝn b̃emǝdas gaiug hǝn b̃igol gǝb̃ikad nasǝnahan, husur nǝvanuan isob̃ur len nab̃iltivile egai lovi esagw.” ");
INSERT INTO klv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ale itoh ei nasihau esua mai nahǝbati emǝlevtes, eṽusan galito hǝn nasoruan siGot. ");
INSERT INTO klv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nǝboŋ aKallio tovi gavna len naprovens Akaia, naJu gail lub̃on, lutah gat aPol, ale lukot hǝni. ");
INSERT INTO klv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Luke, “Ategai italtal hǝn nǝvanuan gail hǝn lǝb̃ilotu hǝn aGot len naṽide sanor hǝn nalo.” ");
INSERT INTO klv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","APol esǝŋav hǝn nabuŋon hǝn b̃isor be aKallio isor kǝkol hǝni, ikel mai naJu gail ke, “Gamit mǝttasor husur nǝsaban ideh o natit tosa togole, tanor hǝn nǝb̃esǝsǝloŋ hǝn na-sor-tasi-an samit mǝttovi Ju. ");
INSERT INTO klv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Avil husur ke nǝbathut na-sor-b̃alb̃al-an evi nasoruan gail mai nǝhes gail mai nalo samito, gamit m̃au mitigole tinor, husur ginau nomǝtahun nǝb̃evi nǝmatsistret hǝn natgalenan.” ");
INSERT INTO klv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ale igol ke nǝvanuan nakotan lohut galit dan nakotan. ");
INSERT INTO klv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Beti galit p̃isi lutah gat aSostenes toil a m̃o hǝn naim nab̃onb̃onan seJu ale luṽasi a m̃o hǝn nakotan, be aKallio sǝnau masuṽ hǝn natgalenan. ");
INSERT INTO klv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","APol itoh ebǝlav kǝkereh a Korint. Beti esudǝlam̃ nǝvanuan nadǝlomian gail ei, ale iwol vi Siria mai alarmisoan, aPrisilla mai aAkwila. Len naut a Kenkrea esir p̃is navurun husur na-kel-gati-an sua san tokele mai aGot. ");
INSERT INTO klv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nǝboŋ lotobar naut a Efesus, aPol eriŋ gǝlar ei be gai sǝb̃on eb̃is len naim nab̃onb̃onan seJu hǝn b̃isor levlev mai naJu gail. ");
INSERT INTO klv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nǝboŋ lotousi hǝn b̃itoh kǝkereh am, sǝdam̃. ");
INSERT INTO klv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Be nǝboŋ tosudǝlam̃ galito tonoŋ ike, “AGot b̃elǝŋoni dereh netǝlmam van hǝn gamito.” Beti iwol dan naut a Efesus. ");
INSERT INTO klv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ale nǝboŋ tomariŋ len naut a Sisarea, evi mǝhat vi Jerusalem, ike, “Ivoi,” mai alat siYesu ei, ale evi pan vi Antiok. ");
INSERT INTO klv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nǝboŋ totoh ei ebǝlav kǝkereh, ivan tǝtas, iyar tur len naut gail a Kalatia mai a Frijia hǝn b̃igol ahai susur p̃isi, ludaŋ am. ");
INSERT INTO klv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","NaJu sua tovi auleAleksadria egǝm vi lan naut a Efesus, nahǝsan aAp̃ollos. Evi naulum̃an tokad namitisau hǝn b̃igol nasoran b̃ihol, ale elǝboi bun natosian siGot. ");
INSERT INTO klv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Atenan esǝsǝloŋ lǝboi nap̃isal siNasub̃ tia, ale nǝlon idaŋ hǝn tosor mai p̃usan tonor husur aYesu, be elǝboi nǝbaptaisan siJon ŋai. ");
INSERT INTO klv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Etub̃at hǝn nasoran len naim nab̃onb̃onan seJu, namǝtahwan eb̃uer. Be nǝboŋ aPrisilla mai aAkwila artosǝsǝloŋ hǝni, arusor mai gai sǝb̃on, arusor vahvah hǝn nap̃isal siGot tonor am maii. ");
INSERT INTO klv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nǝboŋ toke tevi lan naprovens Akaia, nǝvanuan nadǝlomian gail lugol elǝŋon ivoi am len nǝlon, ale lutos nalob̃ulat van hǝn ahai susur gail ei ke, lehǝhaṽur hǝn nagǝmaian san. Nǝboŋ tobar naut a Akaia evi tarhǝt habat silat lotokad nadǝlomian bathut navoian aGot toviol kǝmas hǝni. ");
INSERT INTO klv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Len nǝhon nǝvanuan p̃isi, len natosian siGot, isor idaŋ, ṽusani ke naJu gail lusab, be aYesu evi aKristo, aGot totabtabuh lan. ");
INSERT INTO klv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nǝboŋ aAp̃ollos totoh len naut a Korint, aPol iyar tur len naut gail a ut vǝbar naut a Efesus. Isab̃ ahai susur galevis ei, ");
INSERT INTO klv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ale eus galit ke, “Mǝtukad aNunun aGot nǝboŋ mǝttogǝm vi vanuan nadǝlomian a?” Lusor vari ke, “Ao, b̃ikad aNunun aGot, namtsasǝsǝloŋ hǝn natideh husuri.” ");
INSERT INTO klv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Beti aPol eus ke, “Mǝtukad nǝbaptaisan tomabe?” Lusor vari ke, “Nǝbaptaisan siJon.” ");
INSERT INTO klv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ale aPol ike, “Nǝbaptaisan siJon evi nǝbaptaisan hǝn nǝpairan dan nǝsaan. AJon ikel mai nǝvanuan gail ke, leriŋ nǝlolit len ategaii b̃ehusuri. AJon isor husur aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nǝboŋ lotosǝsǝloŋ hǝn nasoruan enan, lubaptais len nahǝsan Nasub̃ aYesu. ");
INSERT INTO klv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ale nǝboŋ aPol toriŋ navǝlan gǝlar len galit ṽisusua tonoŋ, aNunun aGot eb̃is len galito, ale lusor len nasoruan tiltile mai lukel ur nǝsa aGot tokel mai galito. ");
INSERT INTO klv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Galit p̃isi lovi 12. ");
INSERT INTO klv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","APol eb̃is len naim nab̃onb̃onan seJu ale len nahǝbati itor isor ei namǝtahwan eb̃uer. Isor levlev mai isor vahvah husur natohan pipihabǝlan aGot. ");
INSERT INTO klv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Be nǝboŋ galevis lotohaihai, lǝsadǝlomi, lotosor isa hǝn nap̃isal siNasub̃ van hǝn nab̃onb̃onan, aPol eriŋ galito. Esǝhar ahai susur gail maii, ale isor levlev akis len naim namitisau seTirannus. ");
INSERT INTO klv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Imagenan tabtab len nasihau eru hǝn ke, galit p̃isi lototoh len naprovens Asia, naJu gail mai alat a Kris p̃isi, losǝsǝloŋ hǝn nasoruan siNasub̃. ");
INSERT INTO klv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Len navǝlan aPol aGot igol namerikel gail sahun togolgole akis. ");
INSERT INTO klv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Natuhtaol o nahurabat gail lotobar aPol, nǝboŋ lotolav gail mai alat lotomǝsah, lumaur, mai nanunun nǝmargobut gail lumakuv. ");
INSERT INTO klv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Beti naJu galevis lotoyar titau hǝn lǝb̃ehut nanunun tosa gail, lukel ris nahǝsan Nasub̃ aYesu van hǝn alat lotokad nanunun nǝmargobut gail ke, “Len nahǝsan aYesu, aPol tokel uri, gimakuv!” ");
INSERT INTO klv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ikad ab̃iltihai tutumav tovi Ju, nahǝsan aSkeva, tokad anatun ulum̃an tomǝlevru togol magenan hǝni. ");
INSERT INTO klv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Avil nǝboŋ lotogole, nanunun nǝmargobut isor var galit ke, “Nolǝboi aYesu! Nǝsatǝtan hǝn aPol, avil gamit ase?” ");
INSERT INTO klv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Beti naulum̃an tokad nanunun nǝmargobut emǝlah van hǝn galito, idaŋ masuṽ, esǝhor galito gol ke lugam dan naim enan b̃urmalmal mai nǝda halit isel. ");
INSERT INTO klv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nǝboŋ alat lototoh a Efesus, naJu gail mai alat a Kris p̃isi, lotosǝsǝloŋ lǝboi natenan, galit p̃isi lumaŋmaŋ lan ale loputsan nahǝsan Nasub̃ aYesu. ");
INSERT INTO klv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Galit lusob̃ur lotogǝm vi vanuan nadǝlomian, lusor tǝvah, lukel vǝhot nǝsa tosa lotogole. ");
INSERT INTO klv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Galit galevis lotogolgol nabehi a m̃o, lusah tuan nalob̃ulat na-golgol-behi-an salit gail, ale lopǝŋas p̃isi len nǝhon nǝvanuan gail. Lǝtake lǝtap̃ur hǝn nalob̃ulat gail, nǝvat halit tavi nakoin nasilva tavi 50,000. ");
INSERT INTO klv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Len naṽide tomagenan aGot eṽusan nǝdaŋan san, ŋa nǝvanuan lusob̃ur am losǝsǝloŋ hǝn nasoruan siNasub̃ tobar nǝlolit am. ");
INSERT INTO klv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nǝboŋ natgalenan lotonoŋ, len nanunun aPol inau ke tiyar tur len naprovens Masetonia mai a Akaia vi Jerusalem. Ike, “Nǝboŋ nǝb̃ivan ei b̃inoŋ nimasvi Rom am.” ");
INSERT INTO klv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ŋa esǝvat nǝvanuan na-vi-tarhǝte-an san eru, aTimoti mai aErastus vi Masetonia, be gai sǝb̃on itoh ebǝlav kǝkereh am len naprovens Asia. ");
INSERT INTO klv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Len nǝboŋ enan, len nab̃iltivile Efesus ikad nab̃iltib̃alan tomǝdas alat lotohusur nap̃isal siNasub̃. ");
INSERT INTO klv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ikad naulum̃an sual ei, nahǝsan aTemetrius toum hǝn natuhlablab hǝn naim nalotuan siArtemis hǝn nasilva. Eliv nǝvat isob̃ur m̃os alat lotoum len nasilva. ");
INSERT INTO klv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Igol esan gail lub̃onb̃on mai alat lotoum len nasilva am, ale ike, “Lalum̃an, mǝtolǝboii ke dattolav nǝvat tosob̃ur len nabisnis egai. ");
INSERT INTO klv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mǝtoris lǝboii, mǝtosǝsǝloŋ lǝboii ke, savi geg a Efesus sǝb̃on ŋai, be len pǝpadaŋ hǝn naprovens Asia kavkav, atenan, aPol, esǝhar nǝvanuan isob̃ur. Egǝras galit ke nagot gail, nǝvanuan lotoum hǝni, lǝsavi got kitin. ");
INSERT INTO klv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ehum nǝhes hǝn nauman sidato b̃egǝm b̃isa, mai len nǝnauan salit p̃isi ehun naim nalotuan siArtemis, nagot tovi pǝhaṽut toyalyal, b̃egǝm vi ut kǝmas. Alitenan, nǝyalyalan san dereh timasig len nǝnauan silat a Asia mai navile a pan lotolotu hǝni!” ");
INSERT INTO klv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nǝboŋ lotosǝsǝloŋ hǝni, nǝlolit ipaŋpaŋ masuṽ, lukai habat ke, “Artemis ta Efesus iyalyal buni!” ");
INSERT INTO klv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sǝdareh nab̃iltivile enan epul hǝn nadǝdarŋab̃uan mai nǝlol paŋpaŋ. Naluṽoh lom̃ur vi lan naut hǝn nab̃iltib̃onb̃onan, loliv gargar aKaius mai aAristarkus, auleMasetonia gǝlaru artoyar mai aPol. ");
INSERT INTO klv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Be nǝboŋ aPol toke tivan hǝn b̃isor mai naluṽoh, ahai susur gail lomǝtahusi. ");
INSERT INTO klv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Beti galevis am, lotoil a m̃o len naprovens Asia, lotolǝmas aPol, lopisul van hǝni ke, satevi lan nab̃iltib̃onb̃onan. ");
INSERT INTO klv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Len naut enan galevis lukai hǝn natsua, galevis am lukai hǝn natsua tile am husur nab̃onb̃onan edǝdarŋab̃u, ale isob̃ur lǝsalǝboii ke nab̃onb̃onan salit m̃os nǝsa. ");
INSERT INTO klv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","NaJu gail lorusan aAleksada vi m̃o ale galevis len naluṽoh lukel maii hǝn nǝsa b̃ikele. Beti eb̃il hǝn navǝlan hǝn lǝb̃emǝdau hǝn b̃isor gol gai gabag. ");
INSERT INTO klv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nǝboŋ naluṽoh lotokǝta lǝboii ke aAleksada tovi Ju, lomǝtahuni, lub̃on hǝn lotokai ke, “Artemis ta Efesus iyalyal buni!” Imaienan hǝn nǝhaua toru. ");
INSERT INTO klv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nǝboŋ aklak hǝn nab̃iltivile tosor ṽǝhṽǝh naluṽoh hǝn lǝb̃emǝdau ike, “Lalum̃an a Efesus, nǝvanuan p̃isi lolǝboii ke nab̃iltivile Efesus ekǝtkǝta tǝban naim nalotuan siArtemis toyalyal mai nǝvat mot san toteh dan nǝmav. ");
INSERT INTO klv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Husur ke sǝkad avan ideh hǝn b̃ike natgalenan lǝsakitin, mǝtemǝdau, samtigol natit tomelmel. ");
INSERT INTO klv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mǝtosǝhar alaruenan gǝm gegai be arsavi vanuan navǝnvǝnahan gǝlaru hǝn naim nalotuan mai arsasǝvar nagot pǝhaṽut sidato. ");
INSERT INTO klv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ATemetrius mai alat lotoum len nasilva maii lǝb̃isor mǝtahun avan ideh, nakotan gail losǝŋav, ikad nǝmatsistret gail; ivoi ke leriŋ nakoblenan salito len nakotan galen ideh. ");
INSERT INTO klv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mǝtb̃elǝŋon natideh am, datib̃onb̃on tivoi hum nalo tokele, hǝn datb̃igole tinor. ");
INSERT INTO klv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Husur nǝsa tovisi damǝŋai, hum ma alat a Rom lǝb̃isor tas gidato husur na-b̃onb̃on-b̃unoh-an sidato top̃erhado, bathut savi m̃os natideh.” ");
INSERT INTO klv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nǝboŋ tokǝmaienan tonoŋ, esǝvat galit ke livan. ");
INSERT INTO klv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nǝboŋ nǝwalan hǝn nadǝdarŋab̃uan enan tonoŋ, aPol ekis ahai susur gail gǝmai. Nǝboŋ togol lotolǝŋon tovoi am len nǝlolito, esudǝlam̃ galito ale evi Masetonia. ");
INSERT INTO klv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Iyar tur len naut gail a Masetonia, isor habat mai nǝvanuan nadǝlomian gail ei gol lolǝŋon ivoi am len nǝlolito. Beti ibar naut a Kris. ");
INSERT INTO klv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Itoh ei hǝn nahǝbati itor. APol eutaut hǝn b̃iwol vi Siria nǝboŋ tosǝsǝloŋ hǝni ke tokad na-sor-utaut-an seJu lotovi enemi san gail hǝn lǝb̃emǝdasi. Imagenan egǝgel hǝn nǝnauan san, inau ke tiyar tur len naprovens Masetonia vi Siria. ");
INSERT INTO klv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nǝvanuan galevis lutah mai aPol, ikad aSopata tovi anatun aPirrhus ta Perea, aAristarkus mai aSekudus ta Tessalonika, aKaius ta Terpe, aTimoti mai alaruevis ta Asia, aTikikus mai aTrofimus. ");
INSERT INTO klv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Alatenan lotovan a m̃o lutoh vir ginamito len naut a Troas. ");
INSERT INTO klv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Husur nǝboŋ hǝn Nǝhanan hǝn nabǝta sǝkad nayis lan, namtoriŋ naut a Filippi, namtuwol vi Troas len nǝmariboŋ erim. Namtub̃on tǝtas mai galito ale namtutoh ei nawik esua. ");
INSERT INTO klv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Len nǝmariboŋ nametǝkav hǝn nawik, namtub̃on mai nǝvanuan nadǝlomian gail hǝn namtb̃ihan b̃onb̃on. APol isor van hǝn galito vǝbar tub̃loh len mariug husur pelan han dereh tivan. ");
INSERT INTO klv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Len narum̃ a mǝhat namttob̃onb̃on lan, ikad nam̃ial isob̃ur. ");
INSERT INTO klv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Amantuhmar sua, nahǝsan aEutikus, ebǝtah len natuhbopita tosǝŋav. Ale nǝboŋ aPol tosorsor van, namǝtan atenan inoṽ van vǝbar ipat buŋbuŋol, iteh dan naim nastori totor vi pan. Nǝboŋ lotopat risi lusab̃i ke tomat. ");
INSERT INTO klv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Be aPol evi pan, ipat husuri, eriŋ navǝlan garu lan, ale ike, “Samtinau masuṽ hǝni, imaur tia!” ");
INSERT INTO klv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Beti galit p̃isi lotǝlmam vi mǝhat, aPol ilav nabǝta, eb̃uri ale luhan b̃onb̃on hǝni. Nǝboŋ lotohani tonoŋ, aPol isor tǝtas vǝbar nǝmav topitau, ale ivan. ");
INSERT INTO klv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Beti galit losǝhar nǝmantuhmar tomaur vahim. Lolǝŋon ivoi habat am len nǝlolito. ");
INSERT INTO klv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Namtovi m̃o vi lan nǝwag wol ale namtuwol vi Assos hǝn namtb̃eusan aPol ei husur isor utaut maienan hǝn b̃iyar vi Assos len tan sǝb̃on. ");
INSERT INTO klv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nǝboŋ tobubur mai ginamito len naut a Assos, namtousani ale namtuwol vi Mitilin. ");
INSERT INTO klv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Pelan han namtoriŋ naut enan, namtuwol van salsal a tut hǝn naholoul Kios. Pelan han am namtubar naholoul Sam̃os ale pelan tǝtas am namtubar navile a Miletus. ");
INSERT INTO klv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","APol ike tiwol tukot a Efesus hǝn asike b̃itoh b̃ebǝlav len naprovens Asia, husur etutut hǝn ke hum ma b̃ibar naut a Jerusalem a tahw hǝn nǝboŋ hǝn naPentikost. ");
INSERT INTO klv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Len naut a Miletus episul vi Efesus, eus ke alat lotoil a m̃o silat siYesu ei legǝm risi. ");
INSERT INTO klv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nǝboŋ lotogǝm hǝni ikel mai galit ke, “Mǝtolǝboi naṽide hǝn nǝmauran sagw len nǝboŋ metǝkav notobar naprovens Asia, ale nototah mai gamit len natohan sagw ei kavkav. ");
INSERT INTO klv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Noum siNasub̃. Len na-lǝŋon-isa-an sagw, nǝlogw emǝdau, nǝsǝnau ginau, namǝtarur sagw isel, be nudaŋ b̃uri naut kǝmas natit p̃isi tosa naJu gail lotogole nǝboŋ lotosor utaut hǝn lǝb̃emǝdas ginau. ");
INSERT INTO klv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nǝsatǝgau gat natideh b̃evi tarhǝt samito, nusor vǝhot na-kel-uri-an tovoi, noṽusan gamito len nǝhon nǝvanuan p̃isi mai len naim ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nukel p̃uli mai naJu gail mai alat a Kris ke lipair m̃au dan nǝsaan van hǝn aGot, ale leriŋ nǝlolit m̃au len aYesu, aMasta sidato. ");
INSERT INTO klv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Gagai aNunun aGot italtal hǝn ke, ginau nǝb̃evi Jerusalem naut kǝmas ke nǝsalǝboi nǝsa b̃evisi hǝn ginau ei. ");
INSERT INTO klv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nolǝboii ŋai ke, len navile p̃isi notovi lan aNunun aGot ikel nalǝlǝgauan mai ginau ke, nǝvanuan gail dereh leriŋ ginau len naim bǝbaŋis mai ligol ginau nelǝŋon tisa masuṽ. ");
INSERT INTO klv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Avil nunau ke nǝmauran sagw evi ut kǝmas hǝn ginau. Nolǝŋon ŋai ke nibar nagilen nǝgaman sagw, ale um vurvur nauman Nasub̃ aYesu tolavi mai ginau, ke, nikel kot na-kel-uri-an tovoi hǝn navoian aGot toviol kǝmas hǝni. ");
INSERT INTO klv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Len nǝyaran sagw, nukel ur natohan pipihabǝlan aGot mai gamito, be gagai nolǝboii ke asike mǝtoris nǝhogw am. ");
INSERT INTO klv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Imaienan nukel koti mai gamit ke, len nǝboŋ damǝŋai nǝsa b̃evisi hǝn gamit tipat len gamito! Asike ipat len ginau am, ");
INSERT INTO klv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bathut nǝsatǝgau gat natideh hǝn nǝb̃esusuani dan gamito. Nukel nalǝŋonian kavkav siGot mai gamito. ");
INSERT INTO klv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mǝtelǝlǝgau hǝn gamito, mǝtekǝtkǝta tǝban navǝshǝsipsip samito lotovi alat siYesu. ANunun aGot igol ke mǝttoil a m̃o hǝn alat siGot, aGot toṽur galit hǝn nǝda hiNatun san. ");
INSERT INTO klv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ginau nolǝboii ke, nǝboŋ nǝb̃ivan tia dereh galevis legǝm len gamito sum̃an nalipah katkat gail. Dereh lemǝdas navǝshǝsipsip siYesu. ");
INSERT INTO klv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Gamit galevis, dereh lile mǝhat, pair hǝn nakitinan hǝn lǝb̃egǝras ahai susur gail, hǝn ahai susur gail lǝb̃ehusur galito. ");
INSERT INTO klv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Imagenan mǝtehulahul! Mitinau gati ke, len nasihau totor nǝsǝŋavŋav be nukel nalǝlǝgauan tabtab mai gamit ṽisusua len nalennǝyal mai nalenmariug. Vǝha-sob̃sob̃ur nutaŋis gamit p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gagai neriŋ gamit len navǝlan aGot. Mitinau gat nasoruan husur navoian san tolǝboi b̃igol mǝtb̃idaŋ am mai b̃eviol mai gamit hǝn nǝsa b̃evi samit balai, gamit mǝttovi siGot. ");
INSERT INTO klv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nǝsalǝŋon nagol, nasilva o nahurabat sivan ideh. ");
INSERT INTO klv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gamit, mǝtolǝboii ke, noum hǝn navǝlagw hǝn ke ginau mai alat lototah mai ginau, namtsǝpar titideh. ");
INSERT INTO klv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Len natit p̃isi notogole, noṽusani ke datimasum tidaŋ magenan hǝn datb̃evi tarhǝt silat lǝsǝdaŋ. Mitinau gat nasoruan siNasub̃ aYesu toke, ‘AGot tigol navoian van hǝn alat lotoviol sǝhor alat lotolav naviolan.’” ");
INSERT INTO klv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nǝboŋ aPol tosor tonoŋ, etǝŋedur, gai mai galit p̃isi ale isor tuṽ. ");
INSERT INTO klv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Galit p̃isi lutaŋ habat; lolugum̃ gat aPol, losum̃ nǝtarhon. ");
INSERT INTO klv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lulolosa masuṽ bathut nǝsa tokele ke, asike lorisi am. Beti losǝhari vi lan nǝwag wol. ");
INSERT INTO klv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nǝboŋ namttoriŋ galit tia, namtuwol inor van vǝbar naut a Kos, ale pelan han namtubar naholoul Rotes, beti namtovi Patara. ");
INSERT INTO klv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nǝboŋ namttosab̃ nǝwag wolwol b̃evi Fonisia, namtusah lan, namtuwol. ");
INSERT INTO klv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Namtoris naholoul Saiprus, ale nǝboŋ namttowol dani len nǝmair sinamito namtuwol vi Siria. Namtubar naut a Tair husur nǝwag wol tedǝdaŋ tite ei. ");
INSERT INTO klv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Namtusab̃ ahai susur galevis, ale namtutoh ei nǝmariboŋ emǝlevru. Len aNunun aGot galit lukel mai aPol ke satevi mǝhat vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nǝboŋ namttotoh ei tonoŋ, namtoriŋ naut enan len nǝyaran sinamito. Galit p̃isi mai asoalit mai anatulit luyar mai ginamito vi lan nǝtarhǝvile. Len nabitas ei ginamit p̃isi namtotǝŋadur, namtusor tuṽ, ");
INSERT INTO klv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ale namtosudǝlam̃ ginamit gabag. Namtusah len nǝwag wol, be galito luvahim. ");
INSERT INTO klv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Namtuwol a Tair van vǝbar naut a Ptolemais. Len naut enan namtuke, “Ivoi,” mai nǝvanuan nadǝlomian gail ale namtutoh mai galito hǝn nǝmariboŋ esua. ");
INSERT INTO klv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pelan han namtovi Sisarea ale namtutoh mai a Filip tokelkel ur na-kel-uri-an tovoi, tovi vanuan sua len natikon lotomǝlevru. ");
INSERT INTO klv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Gai ikad anatvavin ivat lotovi vensus lotokel ur nǝsa aGot tokel mai galito. ");
INSERT INTO klv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nǝboŋ namttotoh ei len nǝmariboŋ galevis, ahai kelkel ur sua, nahǝsan aAkapus egǝm len naut a Jutea gǝm vi pan. ");
INSERT INTO klv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Egǝm hǝn ginamito, ilav nǝhau tutuṽ siPol ale ibaŋis gat gabag narien mai navǝlan p̃isi hǝni. Ike, “ANunun aGot ekǝmaiegai ke, ‘Naulum̃an nǝhau tutuṽ egai tovi esan, alat a Jutea len naut a Jerusalem dereh libaŋis gati hǝn lǝb̃eriŋi len navǝlan alat lǝsavi Ju.’” ");
INSERT INTO klv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nǝboŋ namttosǝsǝloŋ hǝn natgalenan, ginamit mai alat lotosuh ei namtoŋiri ke, aPol satevi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Beti aPol isor var ginamit ke, “Mǝtumabe? Mǝtutaŋ, ale nǝlogw itaŋis habat hǝn gamito. Be savi nǝ-baŋis-gati-an ŋai notoutaut hǝni, noutaut hǝn nǝb̃imat len naut a Jerusalem sil nahǝsan Nasub̃ aYesu.” ");
INSERT INTO klv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Husur namttohisi sob̃uer, namtsasor am be namtuke, “Nǝsa Nasub̃ tolǝŋoni m̃au tevisi.” ");
INSERT INTO klv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Husur nǝboŋ galenan namtoutaut ale namtovi mǝhat vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ahai susur galevis a Sisarea lutah mai ginamito, ale losǝhar ginamit vi lan naim siMnason, auleSaiprus sua tovi ahai susur a m̃o tia, ale namtutoh maii. ");
INSERT INTO klv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nǝboŋ namttobar naut a Jerusalem, nǝvanuan nadǝlomian gail lohǝhaṽur hǝn namttogǝmai. ");
INSERT INTO klv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pelan han namtutah mai aPol hǝn namtb̃eris aJemes, ale alat lotoil a m̃o silat siYesu logǝmai. ");
INSERT INTO klv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","APol ikel na-ke-ivoi-an mai galito, ale isor husur natit p̃isi ṽisusua aGot togole len alat lǝsavi Ju nǝboŋ aPol toum m̃os galito. ");
INSERT INTO klv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Alat lotosǝsǝloŋ hǝn natgalenan lusor sal suh aGot ale lukel mai aPol ke, “Wawa, goris lǝboii ke naJu gail lusob̃ur masuṽ logǝm vi vanuan nadǝlomian gail. Galit p̃isi lolǝŋon buni ke lehusur nalo. ");
INSERT INTO klv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Losǝsǝloŋ hǝn na-kel-uri-an husur gaiug ke, gotoṽusan naJu gail lotosuh mai alat lǝsavi Ju ke lipair dan aMoses, saletiv dalus anatulit gail ale salehusur naṽide seJu gail. ");
INSERT INTO klv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Dereh lesǝsǝloŋ hǝn gotogǝmai, ale namtigol nǝsa? ");
INSERT INTO klv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gigol nǝsa namttokel mai gaiug bai. Ikad ivat len ginamito lotogol na-kel-gati-an van hǝn aGot. ");
INSERT INTO klv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gitah mai galito, gigol giveveu len nǝhon aGot mai galito, ale lav nǝvat mai galit hǝn lǝb̃esir nǝkadulito. Imagenan nǝvanuan p̃isi dereh lelǝboii ke, nǝsa lotosǝsǝloŋ hǝni husur gaiug sakitin, avil ke gaiug gugol husur nalo siMoses. ");
INSERT INTO klv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Be tarhǝt alat lǝsavi Ju, namtutosi tia ke salihan namǝŋod tovi violan len natutumavan van hǝn nǝlablab, salihan nǝda o namǝŋod nǝhau tobaŋis bun navǝdolon mai saligol naitian tosa.” ");
INSERT INTO klv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pelan han aPol esǝhar alalum̃an ale lugol luveveu. Beti eb̃is len naholǝvat todar vis naim siGot hǝn b̃ikel ur nǝboŋ hǝn nanoŋan hǝn naveveuan salito, nǝboŋ ahai tutumav b̃etutumav hǝn naviolan m̃os galit ṽisusua. ");
INSERT INTO klv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nǝboŋ nǝmariboŋ tomǝlevru pǝpadaŋ hǝn tonoŋ, naJu galevis ta Asia loris aPol len naholǝvat todar vis naim siGot. Nasoran salito igol naluṽoh kavkav nǝlolit ipaŋpaŋ van lutah gat aPol, ");
INSERT INTO klv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","lukai ke, “UleIsrael gail, mǝtevi tarhǝt sinamito! Ategai evi naulum̃an toṽusan nǝvanuan p̃isi len naut p̃isi. Len nap̃usanan san isor tas nǝvanuan sidat gail, nalo sidato mai naut egai. A mǝhat hǝn natgalenan, esǝhar auleKris gail vi lan naut siGot, gol ke naut tolo egai eb̃iŋb̃iŋal len nǝhon aGot.” ");
INSERT INTO klv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Lokǝmaienan husur lotoris aTrofimus ta Efesus tia totah mai aPol len nab̃iltivile. Ale lunau ke aPol tosǝhari vi lan naholǝvat todar vis naim siGot.) ");
INSERT INTO klv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Beti nǝvanuan len nab̃iltivile kavkav, nǝlolit ipaŋpaŋ, lom̃ur b̃onb̃on, tah gat aPol, liv gargari dan naholǝvat todar vis naim siGot, ale vǝha-sua ŋai nabopita gail lokǝkol. ");
INSERT INTO klv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nǝboŋ lotohisi hǝn lǝb̃iṽabuni, na-kel-uri-an ibar nakomada toil a m̃o hǝn nasoltia gail p̃isi siRom ei, ke len naut a Jerusalem kavkav ikad nǝ-b̃al-taṽtaṽor-an tomǝdas natit gail. ");
INSERT INTO klv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Vǝha-sua ŋai esǝhar nasoltia mai nasenturion gail, lugam vi pan van hǝn naluṽoh. Nǝboŋ naluṽoh lotoris nasoltia gail mai nakomada toil a m̃o, lǝsǝṽas aPol am. ");
INSERT INTO klv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Beti nakomada egǝm hǝn aPol, itah gati, ale ikel mai nasoltia gail ke, libaŋis gati hǝn natsen teru. Ale eus naluṽoh ke nahǝsan ase mai igol nǝsa. ");
INSERT INTO klv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Galevis len naluṽoh lukai hǝn natsua, galevis am lukai hǝn natsual am. Ale husur edǝdas b̃elǝboi nǝsa tovisi bathut nǝwalan, ike nasoltia gail lesǝhar aPol vi lan naim sisoltia gail. ");
INSERT INTO klv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nǝboŋ aPol tobar na-mel-pǝlpǝlau-an hǝn naim sisoltia gail, lupati husur nab̃iltilol paŋpaŋ sinaluṽoh. ");
INSERT INTO klv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Naluṽoh lotohusur galito lukaikai ke, “Ṽabuni! Ṽabuni!” ");
INSERT INTO klv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nǝboŋ lotosǝhsǝhar aPol vi lohoim sisoltia gail, aPol eus nakomada ke, “Nolǝboi nǝb̃isor mai gaiug?” Atenan isor vari ke, “Golǝboi nasoruan ta Kris a? ");
INSERT INTO klv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Be gaiug gǝsavi uleIjip togol nǝb̃alan mai a Rom a m̃o, ale tosǝhar alalum̃an lotogolgol nǝmatan lotovi 4,000 vi lan naut masmas a?” ");
INSERT INTO klv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","APol ike, “Ao, ginau novi naJu, auleTarsus a Silisia, naulum̃an hǝn nab̃iltivile enan. Nous gaiug ke, nolǝboi nǝb̃isor mai nǝvanuan galeg bai a?” ");
INSERT INTO klv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nǝboŋ todam̃ hǝni aPol eil len na-mel-pǝlpǝlau-an ale eb̃il hǝn navǝlan van hǝn naluṽoh. Nǝboŋ naut tob̃ut, isor mai galit len nasoruan seIpru gail ke, ");
INSERT INTO klv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Lalum̃an, aṽagw gail mai atǝmagw gail, mǝtesǝsǝloŋ hǝn na-sor-gole-an sagw tokitin.” ");
INSERT INTO klv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nǝboŋ lotosǝsǝloŋ hǝni ke tosor len nasoruan seIpru gail, naut eb̃ut habat ale ike, ");
INSERT INTO klv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ginau novi Ju sua, anagw ipas ginau len naut a Tarsus a Silisia. Notibau len nab̃iltivile egai. Nǝboŋ notosǝkul, ahai p̃usan sagw aKamaliel. Len nap̃usanan san nosǝkul lǝboi bun nalo setǝmadit ta sutuai. Nolǝŋon masuṽ hǝn notohusur aGot sum̃an gamit p̃isi damǝŋai. ");
INSERT INTO klv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ginau nomǝdas tabtab hǝn alat lotohusur nap̃isal siNasub̃, nugol isa hǝn galito van vǝbar nǝmatan salito. Nubaŋis gat alalum̃an mai alatpǝhaṽut, bar hǝn galit len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ab̃iltihai tutumav mai alat lotoil a m̃o seJu gail lolǝboi lǝb̃ikel koti m̃os ginau ke notokitin. Galit lulav nalob̃ulat napisulan gail mai ginau van hǝn naJu gail a Tamaskus. Ale nuvan hǝn nǝb̃ibaŋis gat alat lototoh ei, sǝhar tǝlmam hǝn galit vi Jerusalem hǝn lǝb̃ipanis. ");
INSERT INTO klv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nǝboŋ notoyar van, pǝpadaŋ hǝn naut a Tamaskus tub̃lial, vǝha-sua ŋai nam̃ial togǝm len nǝmav tom̃ial habat ebilas ginau. ");
INSERT INTO klv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ale nuteh len tan, nosǝsǝloŋ hǝn nadoldol tous ginau ke, ‘Sol, Sol, gomǝdas tabtab hǝn ginau hǝn nǝsa?’ ");
INSERT INTO klv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nusor vari ke, ‘Gaiug ase Nasub̃?’ Beti ikel mai ginau ke, ‘Ginau aYesu ta Nasaret gotomǝdas bun ginau.’ ");
INSERT INTO klv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Alat lototah mai ginau loris nam̃ial tom̃ial habat be lǝsasǝsǝloŋ hǝn nadoldol tosor mai ginau. ");
INSERT INTO klv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nousi ke, ‘Nasub̃, nigol nǝsa bai?’ Nasub̃ ikel mai ginau ke, ‘Gile mǝhat, geb̃is len nab̃iltivile a Tamaskus. Avan sual ei dereh tikel mai gaiug natit p̃isi notoriŋi len gaiug hǝn gǝb̃igole.’ ");
INSERT INTO klv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nodǝdas nǝb̃ekǝta sil nam̃ial enan tobilas ginau. Ŋa alat lototah mai ginau lotǝgau navǝlagw, losǝhar ginau vi lan naut a Tamaskus. ");
INSERT INTO klv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Naulum̃an sua, nahǝsan aAnanias egǝm hǝn ginau. Evi vanuan tohusur kitin hǝn nap̃isal siGot mai tohusur nalo, ale naJu gail ei luke tovoi. ");
INSERT INTO klv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Eil tǝban ginau ale ike, ‘Wawa Sol, gekǝta vi mǝhat, nakǝtaan sam̃ etǝlmam!’ Vǝha-sua ŋai nokǝta vi mǝhat, norisi. ");
INSERT INTO klv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Beti ike, ‘AGot setǝmadit ta sutuai itabtabuh len gaiug hǝn gǝb̃elǝboi nalǝŋonian san, hǝn gǝb̃eris Nǝvanuan Nanoran mai hǝn gǝb̃esǝsǝloŋ hǝn nadolon. ");
INSERT INTO klv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Husur dereh gevi vanuan san hǝn gǝb̃ikel kot nǝsa gotorisi mai gotosǝsǝloŋ hǝni mai nǝvanuan p̃isi. ");
INSERT INTO klv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ale govǝlo hǝn nǝsa? Gile mǝhat, gibaptais, ale gisor mai Nasub̃ hǝn b̃ekǝkas kuv nǝsaan sam̃ gail.’ ");
INSERT INTO klv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Notǝlmam vi Jerusalem ale nǝboŋ notosor tuṽ len naholǝvat todar vis naim siGot, noris na-kǝta-risi-an sua togǝm len nǝmav ei. ");
INSERT INTO klv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Noris aYesu tokel mai ginau ke, ‘Getutut, gam dan naut a Jerusalem husur asike lodǝlom na-kel-koti-an sam̃ husur ginau.’ ");
INSERT INTO klv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ale nuke, ‘Nasub̃, galit lolǝboii ke, len naim nab̃onb̃onan p̃isi seJu nubaŋis gat alat lotoriŋ nǝlolit len gaiug ale nuṽas galito. ");
INSERT INTO klv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ale nǝboŋ nǝda hiSteven tosel, gai tosor vi tarhǝt sam̃, ginau noil pǝpadaŋ, nudam̃ mai alat lototubuni. Nokǝta tǝban nahurabat salito.’ ");
INSERT INTO klv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Beti ikel mai ginau ke, ‘Givan, nesǝvat gaiug vi tut van hǝn naluṽoh hǝn nǝvanuan naut tiltile gail.’” ");
INSERT INTO klv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Naluṽoh losǝsǝloŋ hǝn aPol vǝbar tokǝmaienan. Be nǝboŋ toke aGot tosǝvati van hǝn alat lǝsavi Ju, lukai habat ke, “Lav kuvi dan navile a pan! Sanor ke b̃imaur am.” ");
INSERT INTO klv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Lukai van ale lubarbar hǝn nahurabat salit gail mai nǝmasiav vi mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nakomada ikel mai nasoltia gail ke, lesǝhar aPol vi lohoim salito ale bilasi, usi hǝn lǝb̃isab̃i ke, husur nǝsa naluṽoh lotokai van hǝni maienan. ");
INSERT INTO klv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Avil nǝboŋ lotoliv gat navǝlan mai narien aPol, baŋis gat gail hǝn lǝb̃ebilasi, eus nasenturion toil tǝban ke, “Inor ke mǝtebilas auleRom sua nakotan sǝsab̃i ke tosab?” ");
INSERT INTO klv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nǝboŋ nasenturion tosǝsǝloŋ hǝn natenan, ivan hǝn nakomada ale ikel maii ke, “Guke gigol nǝsa? Atenan evi auleRom.” ");
INSERT INTO klv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nakomada egǝm hǝn aPol, eusi ke, “Kel mai ginau, govi auleRom m̃au?” Ale ike, “Evoi.” ");
INSERT INTO klv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Beti nakomada ike, “Nulav nǝvat tosob̃ur mai alat a Rom hǝn notogǝm vi uleRom.” Ris aPol toke, “Be ginau boh, nǝboŋ lotopas ginau novi uleRom.” ");
INSERT INTO klv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Vǝha-sua ŋai alalum̃an pǝpadaŋ hǝn lǝb̃ebilas aPol mai lǝb̃eusi hǝn nausian gail, lovi tut dani. Nakomada am emǝtahw husur inau lǝboii ke, tobaŋis gat aPol tovi uleRom kitin hǝn natsen. ");
INSERT INTO klv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Pelan han nakomada ike telǝboii ke alat lotoil a m̃o seJu gail lukot hǝn aPol hǝn nǝsa. Ale isah rub̃at aPol, ale ikele idaŋ ke ab̃iltihai tutumav mai nǝSanhitrin kavkav lebǝtah. Beti esǝhar aPol vi pan, gol ke eil a m̃o len nǝholito. ");
INSERT INTO klv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Nǝboŋ aPol tokǝta mǝtaltal van hǝn nǝSanhitrin ike, “Lalum̃an, aṽagw gail, len nǝmauran kavkav sagw len nǝhon aGot nǝlogw imasil vǝbar damǝŋai.” ");
INSERT INTO klv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Beti ab̃iltihai tutumav, aAnanias ikel mai alat lotoil tǝban aPol ke liṽos nabuŋon. ");
INSERT INTO klv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","APol ipair van hǝni ike, “AGot tiṽas gaiug, gohum napisbile tob̃iŋb̃iŋal gotopiti topǝhapǝhw! Gobǝtah ei, gusab̃ sǝhoti ke nǝsagol husur nalo siGot, avil gaiug gob̃ur kotov nalo nǝboŋ gotokel mai alatenan ke liṽos ginau.” ");
INSERT INTO klv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Alat lotoil tǝban luke, “Imabe gotosor tosa hǝn ab̃iltihai tutumav siGot?” ");
INSERT INTO klv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ale aPol ike, “Aṽagw gail, nǝsalǝboii ke tovi b̃iltihai tutumav, husur len natosian siGot ike, ‘Sagisor tisa hǝn avan ideh toil a m̃o hǝn nǝvanuan sam̃ gail.’” ");
INSERT INTO klv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nǝboŋ aPol tokǝta lǝboii ke galevis lovi Sattiusi, galevis am lovi Farisi, ikai van hǝn nǝSanhitrin ke, “Aṽagw gail, novi Farisi sua, notovi anatun siFarisi gail. Lukot hǝn ginau husur nǝ-vatvat-viri-an mai na-le-mǝhat-an dan nǝmatan!” ");
INSERT INTO klv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nǝboŋ tokǝmaienan, naFarisi gail mai naSattiusi gail lotub̃at sor b̃alb̃al ale nab̃onb̃onan egǝm nǝtarhǝt eru. ");
INSERT INTO klv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(NaSattiusi gail luke sǝkad na-le-mǝhat-an dan nǝmatan, sǝkad aŋel ideh o nanunun ideh, be naFarisi gail lodǝlomi ke ikad galen p̃isi.) ");
INSERT INTO klv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Na-sor-b̃alb̃al-an iwal habat. Galevis lotovi hai p̃usan hǝn nalo siMoses lotovi Farisi am, lule mǝhat, lusor b̃al habat ke, “Namtsǝsab̃ natideh tosab len ategai. Hum ma nanunun ideh o aŋel ideh m̃au tosor maii.” ");
INSERT INTO klv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nǝboŋ lotosor b̃alb̃al van, nakomada emǝtahw ke, dereh lisah pǝpas aPol, ale ikel mai nasoltia gail ke, levi pan, ale len nǝdaŋan salito lesǝhar kuvi dan nǝSanhitrin vi lan naim sisoltia gail. ");
INSERT INTO klv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Len mariug enan Nasub̃ eil tǝban aPol ike, “Gitah gat nǝlom̃! Gukel kot natit gail husur ginau len naut a Jerusalem, imagenan gimaskel koti len naut a Rom am.” ");
INSERT INTO klv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Len nadudulan naJu gail lub̃onb̃on, luta gat na-kel-gati-an ke lukolkol hǝn nǝhanan mai namunan van vǝbar nǝboŋ lǝb̃igol aPol b̃imat. ");
INSERT INTO klv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nǝvanuan lotob̃onb̃on len na-sor-utaut-an enan lusob̃ur sǝhor 40. ");
INSERT INTO klv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Luvan hǝn ab̃iltihai tutumav gail mai alat lotoil a m̃o seJu gail ale luke, “Namtukel gati ke sanamtihan ris natideh vir namtb̃igol aPol b̃imat. ");
INSERT INTO klv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Imaienan, gamito mai nǝSanhitrin, mitikel mai nakomada ke, tesǝhar aPol van hǝn gamito sum̃an ke mǝtb̃ike mǝtb̃isab̃ nakitinan am husuri. Namtoutaut hǝn namtb̃igole b̃imat a tahw hǝn b̃ibar gamito.” ");
INSERT INTO klv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nǝboŋ ailoan ulum̃an matmat siPol tosǝsǝloŋ hǝn na-sor-utaut-an enan, evi lan naim sisoltia gail, eb̃is lan ale ikel uri mai aPol. ");
INSERT INTO klv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","APol ekis nasenturion sua gǝmai ale ike, “Gesǝhar nǝmantuhmar egai van hǝn nakomada samito hǝn b̃ikel ur natsua mai atenan.” ");
INSERT INTO klv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ŋa esǝhari van hǝn nakomada. Nasenturion ikel maii ke, “APol, dattotah gati len naim sidato, ekis ginau, ale eus ginau ke nesǝhar nǝmantuhmar egai gǝm hǝn gaiug. Ikad natsua hǝn b̃ikele mai gaiug.” ");
INSERT INTO klv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nakomada etǝgau navǝlan ailoan aPol, elivi hǝn arb̃isor sǝb̃olaru. Eusi ke, “Guke gikel ur nǝsa mai ginau?” ");
INSERT INTO klv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Isor vari ke, “NaJu gail ludam̃ mai galit gabag ke, pelan dereh leus gaiug hǝn gǝb̃esǝhar aPol vi pan van hǝn nǝSanhitrin hǝn lǝb̃isab̃ nakitinan am husuri, be logǝgǝras. ");
INSERT INTO klv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Sagedǝlom galito. Lalum̃an lotosob̃ur sǝhor 40 losusuah, toh vir nagǝmaian siPol. Lukel gati ke salihan, salemun vǝbar lǝb̃igol aPol b̃imat. Gagai loutaut vir gaiug ke gǝb̃idam̃ hǝn nǝsa lotousi.” ");
INSERT INTO klv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Imagenan, nakomada enan ike nǝmantuhmar tivan, ale ikel maii ke, “Sagikel mai avan ideh ke gotokel ur nategai mai ginau.” ");
INSERT INTO klv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Beti ekis nasenturion eru gǝmai, ike, “Mǝreutaut hǝn nasoltia lotovi 200, nasoltia nahos lotovi 70 mai nasoltia nǝsaran lotovi 200 hǝn lǝb̃evi Sisarea len namityal tomǝlapat damǝŋ len mariug. ");
INSERT INTO klv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mǝreutaut hǝn nahos vir aPol, ale sǝhar aPol van hǝn aFeliks tovi gavna ei.” ");
INSERT INTO klv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Itos nalob̃ulat maiegai ke: ");
INSERT INTO klv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ginau notovi Klautius Lisias nutos nategai van hǝn aGavna tovoi, aFeliks: Ivoi. ");
INSERT INTO klv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","NaJu gail lutah gat ategai hǝn lǝb̃iṽabuni. Nǝboŋ notosab̃i ke tovi uleRom, ginau mai nasoltia gail namtuvan hǝni ale nulav kuvi dan galito. ");
INSERT INTO klv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Husur ke notoke nelǝboi nǝsaan lotoke togole, nosǝhari van hǝn nǝSanhitrin salito. ");
INSERT INTO klv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nusab̃i ke lotokot hǝni husur na-sor-b̃alb̃al-an hǝn nalo salito, be nǝmatan o naim bǝbaŋis sanor hǝn nǝsa lotoke togole. ");
INSERT INTO klv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nǝboŋ notosǝsǝloŋ hǝni ke tokad na-sor-utaut-an hǝn lǝb̃emǝdas ategai, vǝha-sua ŋai nosǝvati van hǝn gaiug. Nukel mai alat lotosor tas ategai ke likel mai gaiug nǝsaan lotonau ke togole. Sipa. ");
INSERT INTO klv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Imagenan nasoltia gail lugol husur nakelean sinakomada salito. Len mariug losǝhar aPol vi Antipatris. ");
INSERT INTO klv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pelan han nasoltia gail lotoyar, lotǝlmam vi lan naim sisoltia gail, be nasoltia nahos gail luvan mai aPol sal. ");
INSERT INTO klv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nǝboŋ lotobar naut a Sisarea lulav nalob̃ulat napisulan mai aFeliks tovi gavna ei, ale loriŋ aPol len navǝlan. ");
INSERT INTO klv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nǝboŋ aFeliks toṽuruŋ nalob̃ulat, eus a Pol ke naut san matmat a be. Ale nǝboŋ tosǝsǝloŋ hǝni ke tovi uleSilisia, ");
INSERT INTO klv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ike, “Dereh nikot hǝn gaiug nǝboŋ alat lotosor tas gaiug lǝb̃ibar naut egai.” Beti ikel mai nasoltia galevis ke lekǝtkǝta kǝkol hǝn aPol len nab̃iltiim siHerot, gai toum hǝni tia sutuai. ");
INSERT INTO klv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Len nǝboŋ torim tohusur enan, ab̃iltihai tutumav, aAnanias, egǝm mai galevis lotoil a m̃o seJu mai avan sua, nahǝsan aTertullus tovi ulum̃an tokad namitisau hǝn nalo. Ale lukel uri mai agavna nǝsa lotoke likot hǝn a Pol sile. ");
INSERT INTO klv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nǝboŋ lotokis aPol vi lohoim, aTertullus etub̃at sor tas aPol, ike, “AFeliks gotovi gavna, bathut namitisau sam̃ hǝn nautautan namtohǝhaṽur hǝn natǝm̃at topat tobǝlav mai natgalevis gotogǝgel hǝni tovoi len nǝkantri egai. ");
INSERT INTO klv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Akis len naut p̃isi namtosipa hǝn nǝsa gotogole, aFeliks gotoyalyal. ");
INSERT INTO klv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nomǝtahun nǝb̃igol gǝb̃ivekan. Imagenan, nous ke, gaiug gesǝsǝloŋ kǝkereh hǝn ginamito len navoian gotokade tabtab. ");
INSERT INTO klv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Ategai, namtusab̃i ke tovi ulum̃an namǝdasian togol nǝ-b̃al-mǝtahuni-an len naJu p̃isi len navile a pan kavkav. Eil a m̃o hǝn naluṽoh lotosab, lotohusur ahai p̃usan ta Nasaret. ");
INSERT INTO klv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Ategai igol risi hǝn tomǝdas naim siGot hǝn tob̃iŋb̃iŋal len nǝhon aGot, imagenan namtutah gati. Nǝboŋ gǝb̃eusi, dereh gisab̃i ke, natit p̃isi namttokel mai gaiug ke aPol tosa lan, ekitin.” ");
INSERT INTO klv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","NaJu gail ei lub̃on mai aTertulus, luke nǝsa tokele ekitin. ");
INSERT INTO klv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nǝboŋ agavna totinuh van hǝn aPol hǝn b̃isor, aPol ikel maii ke, “AFeliks aGavna, nolǝboii ke, len nasihau tosob̃ur gotopǝpehun nanoran dan nǝsaban len nǝkantri egai tia. Imaienan nohǝhaṽur hǝn nǝb̃isor husur natgalenan lotokel ke notogol tosa be sakitin. ");
INSERT INTO klv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Sǝdaŋ hǝn gǝb̃isab̃i ke, sǝbar nǝmariboŋ tovi 12 tovan, novi mǝhat vi Jerusalem hǝn nǝb̃ilotu. ");
INSERT INTO klv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Naut kǝmas nǝsa lotokele, lǝsǝsab̃i ke notosor b̃alb̃al mai avan ideh, lǝsǝsab̃i ke notogol nadǝdarŋab̃uan len naluṽoh len naholǝvat todar vis naim siGot, len naim nab̃onb̃onan seJu ideh o len naut ideh len nab̃iltivile. ");
INSERT INTO klv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Lukel mai gaiug ke notogol tosa, be lodǝdas lǝb̃eṽusan nakitinan hǝn nǝsa lotokele. ");
INSERT INTO klv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nukel lǝboi nategai mai gaiug ke, nulotu hǝn aGot setǝmanamit ta sutuai hǝn Nap̃isal siNasub̃ alategai lotoke tosab. Nodǝlom natit p̃isi len nalo siMoses mai len natosian sihai kelkel ur gail. ");
INSERT INTO klv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sum̃an nǝsa alategai ma lotodǝlomi, ginau nuvatvat vir nǝboŋ aGot b̃igol na-le-mǝhat-an dan nǝmatan hǝn alat lotonor mai lǝsanor. ");
INSERT INTO klv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Imaienan nohisi ke nǝlogw imasil len nǝhon aGot mai nǝvanuan p̃isi tabtab. ");
INSERT INTO klv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Husur nasihau tosob̃ur notǝlmam hǝn nǝb̃eviol hǝn nǝvat mai nǝvanuan sagw gail lotom̃idol ale hǝn nǝb̃etutumav. ");
INSERT INTO klv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nǝboŋ notogol natenan mai notogol ginau notoveveu tia, lusab̃ ginau len naholǝvat todar vis naim siGot, be sǝkad naluṽoh, sǝkad nadǝdarŋab̃uan ideh. ");
INSERT INTO klv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Avil ikad naJu galevis a Asia ei. Galit, lǝb̃elǝboi natideh notogol tosa, ivoi hǝn lǝb̃itoh gegai len nǝhom̃. ");
INSERT INTO klv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Galit gabag m̃au, likel mai gaiug natideh sanor lotosab̃i len ginau nǝboŋ notoil len nǝhon nǝSanhitrin salito! ");
INSERT INTO klv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Sum̃an ma tovi nategai notokai habat hǝni nǝboŋ notoil len nab̃onb̃onan salit ke, ‘Lukot hǝn ginau damǝŋai husur nuvatvat vir na-le-mǝhat-an dan nǝmatan!’” ");
INSERT INTO klv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Beti aFeliks tolǝboi masuṽ hǝn Nap̃isal siNasub̃, igol nakotan evǝlo, ike, “Nǝboŋ aLisias, nakomada b̃egǝmai, neriŋ na-sor-sab̃i-an sagw husur gaiug.” ");
INSERT INTO klv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ale ikel mai nasenturion ke, tekǝtkǝta kǝkol hǝn aPol be teriŋi hǝn b̃iyaryar kǝkereh, ale tidam̃ hǝn nǝvanuan siPol gail lekǝtkǝta tǝban. ");
INSERT INTO klv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nǝmariboŋ galevis tohusuri aFeliks egǝm mai asoan, nahǝsan aTrusilla, tovi Ju sua. Episul hǝn aPol b̃egǝm hǝni ale esǝsǝloŋ hǝn tosor husur nadǝlomian len aYesu Kristo. ");
INSERT INTO klv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","APol ihol husur nanoran, mai nǝdaŋan hǝn avan ideh b̃ike, “Aoa,” hǝn nǝsaan, mai nǝboŋ aGot b̃ikot hǝn nǝvanuan p̃isi. Nǝboŋ tokǝmaienan, aFeliks emǝtahw, ike, “Givan bai, nǝb̃isab̃ nǝboŋ ideh am, dereh nepisul hǝn gaiug hǝn gǝb̃egǝmai.” ");
INSERT INTO klv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Bathut aFeliks tonau ke hum ma aPol b̃ilav nǝvat maii hǝn b̃imakuv, episul vǝha-sob̃sob̃ur hǝni hǝn b̃egǝm hol maii. ");
INSERT INTO klv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nǝboŋ nasihau toru togam gole tonoŋ aPorsius Festus ilav namilen aFeliks. Ale husur aFeliks tolǝŋon ke naJu gail lehǝhaṽur hǝni, eriŋ aPol totoh tin len naim bǝbaŋis. ");
INSERT INTO klv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Len nǝmariboŋ itor husur nagǝmaian san len naut a Jutea, aFestus eriŋ naut a Sisarea vi mǝhat vi Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Len naut enan ab̃iltihai tutumav gail mai alat lotoil a m̃o seJu gail, lukel uri mai aFestus nǝsa lotoke aPol togol tosa. Ale loŋiri ke, ");
INSERT INTO klv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","b̃ike lǝb̃ehǝhaṽur hǝni, tilav aPol gǝm vi Jerusalem. (Lusor utaut hǝni tia ke ligol aPol timat len nap̃isal.) ");
INSERT INTO klv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","AFestus isor var galit ke, “Namtotǝgau gat aPol a Sisarea, ale asike idareh ginau nivan ei. ");
INSERT INTO klv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Imaienan, alat lotoil a m̃o hǝn gamito, litah mai ginau. B̃ikad natideh tosa len atenan, likel ur nǝsa togol tosa len nakotan sagw ei.” ");
INSERT INTO klv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","AFestus itoh mai galit len naut enan len nǝmariboŋ sasǝhor tomǝlevtor o tosǝŋavur ale evi pan vi Sisarea. Pelan han ebǝtah len nakotan ale ike lesǝhar aPol gǝmai. ");
INSERT INTO klv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nǝboŋ aPol togǝmai tonoŋ, naJu gail lotogǝm a Jerusalem loil dar vis aPol, lukel ur nǝsa lotoke aPol togol tosa avil lodǝdas lǝb̃eṽusan sǝhoti ke tovi kitinan. ");
INSERT INTO klv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","APol isor vi tarhǝt san gabag ke, “Nǝsagol natideh tob̃ur kotov nalo seJu gail, tomǝdas naim siGot o tomǝdas aSisa.” ");
INSERT INTO klv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Be husur aFestus toke tigol naJu gail lehǝhaṽur, eus aPol ke, “Guke gevi Jerusalem hǝn nǝb̃ikot hǝn gaiug ei sil natgalegai a?” ");
INSERT INTO klv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ale aPol isor vari ke, “Gagai noil a m̃o len nǝhai bǝtbǝtah nakotan tovi nakotan seSisa; ale egai nakotan tonor hǝn nǝb̃ikot lan. Gaiug golǝboi buni tia ke nǝsagol natideh tosab van hǝn naJu gail. ");
INSERT INTO klv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nǝb̃igol natideh tosa, tonor hǝn nǝb̃imat sile, asike nugam dan nǝmatan enan, avil nǝsa naJu galegai lotokel ke notogol tosa asike b̃ekitin, sǝkad avan ideh tolǝboi b̃eriŋ ginau len navǝlalito. Nous ke aSisa tebǝtah len nakotan sagw.” ");
INSERT INTO klv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Beti nǝboŋ aFestus tosor husur natenan mai esan gail lotokad namitisau, isor var aPol ke, “Gous ke aSisa tebǝtah len nakotan sam̃, ale dereh givan hǝn aSisa.” ");
INSERT INTO klv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nǝboŋ nǝmariboŋ galevis tovan, aAkrippa aKiŋ mai aPernis tovi aṽavinen arogǝm hǝn naut a Sisarea hǝn arb̃ike, “Ivoi,” ale arb̃elǝlav mai aFestus. ");
INSERT INTO klv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Arutoh ei nǝmariboŋ isob̃ur ale len natohan sǝlaru aFestus isor husur nakotan siPol mai akiŋ, ike, “Ikad avan sua aFeliks toriŋi len naim bǝbaŋis gegai. ");
INSERT INTO klv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ale nǝboŋ nototoh len naut a Jerusalem, ab̃iltihai tutumav mai alat lotoil a m̃o seJu gail, lukel mai ginau nǝsa lotoke aten togol tosa ale lous ke ginau nisab̃ sǝhoti ke timaspanis. ");
INSERT INTO klv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nukel mai galit ke, savi naṽide silat aRom hǝn lǝb̃eriŋ avan ideh len navǝlan alat lotoke tipanis. Be len nakotan atenan timaskad nab̃onb̃onan mai alat lotosor tasi hǝn b̃isor vi tarhǝt san gabag. ");
INSERT INTO klv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Imaienan nǝboŋ lotogǝm b̃on gegai, nǝsavǝlo be pelan han ŋai nobǝtah len nakotan, ale nukele ke lesǝhar aPol gǝmai. ");
INSERT INTO klv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nǝboŋ alat lotosor tasi lotoil, lǝsakel ur natideh gai togol tosa hum notovatvat viri. ");
INSERT INTO klv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Be lusor tastasi husur nǝbathut nalotuan galevis salito, mai avan sua tomat, nahǝsan aYesu, aPol toke tomaur. ");
INSERT INTO klv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Husur nǝsalǝboii ke timabe hǝn nǝb̃ep̃usp̃us kitev nakitinan husur natgalenan, nous aPol ke b̃ehǝhaṽur m̃au ke tevi Jerusalem hǝn b̃ikot ei sil na-sor-tastasi-an galenan. ");
INSERT INTO klv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Avil nǝboŋ aPol tous ke titoh vir nakotan seSisa, nukele ke letǝgau gati vir nǝb̃esǝvati van hǝn aSisa.” ");
INSERT INTO klv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","AAkrippa ikel mai aFestus ke, “Ginau am nuke nesǝsǝloŋ hǝn atenan.” AFestus ike, “Pelan beti gesǝsǝloŋ hǝni.” ");
INSERT INTO klv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ŋa pelan han aAkrippa mai aPernis arogǝm len naṽivan totibau hǝn arb̃ipat gǝlar mǝhat, arob̃is len narum̃ hǝn nab̃onb̃onan. Nakomada gail mai nǝvanuan totibau gail len navile, lutah mai gǝlaru. Beti aFestus ikele ke lesǝhar aPol gǝmai. ");
INSERT INTO klv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ale aFestus ike, “Akrippa aKiŋ mai galit lototoh mai ginamito, mǝtoris ategai. NaJu gail p̃isi lous taltal hǝn ginau len naut a Jerusalem mai gegai hǝni, lukai ke sanor hǝn b̃imaur am. ");
INSERT INTO klv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nǝsǝsab̃i ke togol natideh hǝn b̃imat sile. Ale nǝboŋ toke tivan hǝn aSisa, noriŋi ke nesǝvati van. ");
INSERT INTO klv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Avil nǝsalǝboii ke nitos nǝsa husur ategai van hǝn aSisa. Imaienan nosǝhari gǝm a m̃o len nǝhomit p̃isi, mai gaiug m̃au Akrippa aKiŋ. Nǝboŋ namtb̃eus nausian gail van hǝni hum ma nǝb̃isab̃ natideh hǝn nǝb̃itos gati. ");
INSERT INTO klv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Husur len nǝnauan sagw sanor savoi hǝn nǝb̃esǝvat avan ideh notobaŋis gati van, be na-tos-gati-an hǝn nǝsa togol tosa eb̃uer.” ");
INSERT INTO klv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","AAkrippa ikel mai aPol ke, “Gisor m̃os gaiug gabag bai.” Ale aPol ibar hǝn navǝlan, etub̃at sor vi tarhǝt san gabag ke, ");
INSERT INTO klv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Len nǝhom̃ damǝŋai, nohǝhaṽur hǝn nǝb̃isor vi tarhǝt sagw gabag. Nisor tas nǝsa naJu gail lotokel ke notogol tosa. ");
INSERT INTO klv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nohǝhaṽur husur gaiug, aAkrippa aKiŋ, golǝboi naṽide p̃isi mai na-sor-b̃alb̃al-an seJu gail. Imagenan noŋir gaiug ke, gesǝsǝloŋ mǝdau vir ginau. ");
INSERT INTO klv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","NaJu p̃isi lolǝboi naṽide hǝn nǝmauran sagw nǝboŋ notokǝkereh vǝbar damǝŋai, len natub̃atan len nǝmauran sagw nǝboŋ nototoh mai nǝvanuan sagw gail, ale len naut a Jerusalem. ");
INSERT INTO klv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Galit lǝb̃ike lǝb̃ikel uri, lolǝboi ebǝlav tia ke notovi Farisi sua ale naFarisi gail ludaŋ hǝn lǝb̃ehusur p̃is naṽide hǝn nalotuan seJu gail. ");
INSERT INTO klv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Damǝŋai noil len nakotan husur nǝ-vatvat-viri-an sagw len nǝsa aGot tokel gati mai atǝmadat ta sutuai. ");
INSERT INTO klv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Na-kel-gati-an enan, nahǝmar tovi 12 sidato luvatvat viri ke tisarpoh, ale ludaŋ len nalotuan van hǝn aGot tabtab m̃osi. Bathut nǝ-vatvat-viri-an enan, naJu gail lukot hǝn ginau, aKiŋ. ");
INSERT INTO klv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Imab mǝtsalǝboi mǝtb̃edǝlomi ke aGot togol alat lotomat lule mǝhat dan nǝmatan? ");
INSERT INTO klv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","A m̃o ginau am nunau ke nimasgol natit tisob̃ur hǝn nǝb̃emǝdas nahǝsan aYesu ta Nasaret. ");
INSERT INTO klv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ale len naut a Jerusalem nugole imaienan. Ab̃iltihai tutumav gail lulav nǝ-dam-hǝni-an mai ginau ale nokǝkol gat alat siGot len naim bǝbaŋis, ale len nakotan nudam̃ hǝn nǝmatan hum nǝpanismen salito. ");
INSERT INTO klv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Len naim nab̃onb̃onan p̃isi seJu nupansem galito vǝha-sob̃sob̃ur, nohisi ke galit ideh lǝb̃isor mǝdas nahǝsan aYesu. Nǝlogw epǝŋas galit hum notovinvinu ale nomǝdas tabtab hǝn galito van vǝbar nab̃iltivile gail a tut. ");
INSERT INTO klv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Len nǝyaran galen sual a tut, novi Tamaskus len nǝdaŋan seb̃iltihai tutumav gail ale nukad nalob̃ulat hǝn nǝ-dam-hǝni-an salito. ");
INSERT INTO klv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","AKiŋ, len natub̃lial, nǝboŋ notohusur nap̃isal, noris nam̃ial togǝm len nǝmav tom̃ial sǝhor namityal, tom̃ias ginau mai alat lotoyar mai ginau. ");
INSERT INTO klv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ginamit p̃isi namtuteh len tan, beti nosǝsǝloŋ hǝn nadoldol tosor mai ginau len nasoruan seIpru gail ke, ‘Sol, Sol, gomǝdas tabtab hǝn ginau hǝn nǝsa? Nǝboŋ gotomǝtahun ginau, gaiug sǝb̃om̃ gosǝnah hun nab̃uluk tosǝvat nǝhai tokan, amahean toturi hǝni hǝn b̃iyar b̃inor.’ ");
INSERT INTO klv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nousi ke, ‘Gaiug ase Nasub̃?’ Ale Nasub̃ ike, ‘Ginau aYesu gotomǝdas bun ginau! ");
INSERT INTO klv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Be gile mǝhat, geil len nariem̃ gǝlaru. Novisi hǝn gaiug hǝn nǝb̃itabtabuh len gaiug hǝn gǝb̃evi vanuan nauman sagw, ale hǝn gǝb̃ikel kot natit gail gotorisi husur ginau mai natit gail nǝb̃evisi hǝn gaiug lan. ");
INSERT INTO klv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Dereh netǝgau gat gaiug, nilav kuv gaiug dan alat lotomǝtahun gaiug, nǝvanuan sam̃ gail mai alat lǝsavi Ju notosǝvat gaiug van hǝn galit gagai. ");
INSERT INTO klv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nosǝvat gaiug van hǝn galit hǝn gǝb̃esǝŋav hǝn namǝtalito ale hǝn gǝb̃ipair hǝn galit dan nǝmargobut van hǝn nam̃ial, dan nǝdaŋan siSetan van hǝn aGot. Timagenan hǝn lǝb̃ikad narub̃atian dan nǝsaan, ale hǝn lǝb̃ikad namilelit len alat lotoveveu husur nadǝlomian salit len ginau.’ ");
INSERT INTO klv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Imaienan, aAkrippa aKiŋ, nosǝsǝloŋ husur atenan togǝm len nǝmav, ale nugol nǝsa tokele. ");
INSERT INTO klv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nukel ur mai nǝvanuan p̃isi ke, lipair dan nǝsaan salit van hǝn aGot, ale nǝsa lǝb̃igole timasnor hǝn nǝpairan dan nǝsaan. Nukel ur naten len naut a Tamaskus metǝkav, beti len naut a Jerusalem, ale len naut a Jutea kavkav. Ale nuvan hǝn alat lǝsavi Ju, nukel uri mai galit am. ");
INSERT INTO klv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Husur natenan, naJu gail lutah gat ginau len naholǝvat todar vis naim siGot, ale lugol risi ke, ligol nimat. ");
INSERT INTO klv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Vǝbar damǝŋai aGot evi tarhǝt sagw. Ale noil gegai, nukel ur nǝsa notorisi mai nǝvanuan kǝmas gail mai nǝvanuan gail lotoyalyal. Nǝsa notokele ep̃itoṽ ŋai hǝn nǝsa ahai kelkel ur gail mai aMoses lotokele ke tevisi. ");
INSERT INTO klv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Luke aKristo, aGot totabtabuh lan, telǝŋon tisa, ale husur ke tevi nametǝkav hǝn na-le-mǝhat-an dan nǝmatan, tikel ur nam̃ial mai nǝvanuan sidat gail mai alat lǝsavi Ju!” ");
INSERT INTO klv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nǝboŋ aPol tosor vi tarhǝt san gabag sal aFestus isor habat kǝkol hǝni ke, “Pol govinu! Na-b̃iltilǝboi-sǝhoti-an sam̃ igol ke gotovinvinu!” ");
INSERT INTO klv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Be aPol ike, “Nǝsavinvinu, aFestus gotoyalyal, avil nukel kot nasoruan tokitin, tokad nǝnauan tovoi. ");
INSERT INTO klv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","AKiŋ elǝboi natgalenan tia, husur enan nolǝboi nǝb̃ekǝmaienan maii. Nunau lǝboii ke natideh gail sasusuah lan, husur natgalenan lǝsavisi hum lotosusuah be lovisi p̃arp̃ar. ");
INSERT INTO klv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Akrippa aKiŋ, godǝlom nǝsa ahai kelkel ur gail lototos gati a? Nolǝboii ke gotodǝlomi.” ");
INSERT INTO klv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","AAkrippa ikel mai aPol ke, “Len namityal tom̃idol maiegai, gunau ke gotolǝboi gǝb̃igol ke nǝb̃egǝm vi Kristen a?” ");
INSERT INTO klv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","APol isor vari ke, “Nous aGot ke len namityal tom̃idol o tobǝlav, savi gaiug ŋai be galit p̃isi am lotosǝsǝloŋ hǝn ginau damǝŋai, legǝm sum̃an ginau! Avil natsen galegai eb̃uer.” ");
INSERT INTO klv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Beti aKiŋ, aGavna mai aPernis, mai alat lotobǝtah mai galito, galit p̃isi lule mǝhat. ");
INSERT INTO klv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nǝboŋ lotoriŋ narum̃ enan lukel mai galit gabag ke, “Atenan sagol natideh tonor hǝn b̃imat o b̃itoh len naim bǝbaŋis.” ");
INSERT INTO klv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","AAkrippa ikel mai aFestus ke, “Atenan, asike tausi ke tavi lan nakotan seSisa, talǝboi tavivile.” ");
INSERT INTO klv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nǝboŋ aFestus toriŋi ke namtb̃iwol vi Itali, loriŋ aPol mai galevis lotobǝbaŋis am len navǝlan nasenturion sua, nahǝsan aJulius, tovi gai sua len Nab̃iltiluṽoh Nasoltia SeSisa. ");
INSERT INTO klv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Namtusah len nǝwag wol ta Atramittium toke b̃iwol vi lan navile gail bitas len naprovens Asia, ale namtotub̃at wol. AAristarkus, auleMasetonia sua ta Tessalonika, itah mai ginamito. ");
INSERT INTO klv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pelan han namtubar naut a Siton, ale aJulius, tovoi hǝn aPol, idam̃ hǝn ke aPol b̃ivahut van hǝn nabubur san gail hǝn lǝb̃ekǝtkǝta tǝban. ");
INSERT INTO klv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Namtovi lau dan naut enan ale namtuwol susuah tarhǝbab a Saiprus husur nǝlan eṽuv gol ginamito. ");
INSERT INTO klv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nǝboŋ namttowol tukot husur naut a Silisia mai a Pamfilia tonoŋ, namtubar naut a Mira a Lisia. ");
INSERT INTO klv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Len naut enan nasenturion isab̃ nǝwag wolwol sua ta Aleksadria toke tevi Itali ale eusan ginamit lan. ");
INSERT INTO klv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Len nǝmariboŋ isob̃ur namtuwol manmaneh. Namtohusur nabitas a Knitus be nawolan idaŋ masuṽ. Pǝpadaŋ hǝn naut a Knitus nǝlan eṽuv gol nǝgaman sinamito ale namtuwol tarhǝholoul a Krit sǝhor nabuŋon a Salm̃one. ");
INSERT INTO klv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nawolan sinamit husur nabitas enan idaŋ vǝbar naut sua nahǝsan tovi Naut Susuahan Tokab, pǝpadaŋ hǝn nab̃iltivile a Lasea. ");
INSERT INTO klv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nǝmariboŋ isob̃ur ivan tia, ale nǝtas isa hǝn nawolan husur Nǝboŋ hǝn Nabǝbaŋan tu ivan tia. Imaienan aPol ikel nalǝlǝgauan mai galit ");
INSERT INTO klv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ke, “Lalum̃an, noris ke dereh nawolan egai tidaŋ habat ale natit tisob̃ur timasig, savi nǝkako mai nǝwag ŋai, be nǝmauran tisob̃ur am.” ");
INSERT INTO klv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Avil nasenturion sadǝlom masuṽ hǝn nǝsa aPol tokele, esǝsǝloŋ hǝn ahai wolwol mai amahean nǝwag wol ŋai. ");
INSERT INTO klv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Husur ke naut hǝn nasusuahan enan sanor hǝn namtb̃itoh lan len nahǝbati naut susus, isob̃ur len galit p̃isi luke namtiwol dani hǝn hum ma namtb̃ibar naut a Finiks hǝn namtb̃itoh ei len nahǝbati naut susus. Naut enan evi naut susuahan tokǝta vi nǝsautwes mai nanotwes. ");
INSERT INTO klv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nǝboŋ nǝlan toṽuv kǝkereh len nasaut, lunau ke lǝb̃ibar naut a Finiks ŋa loliv naga, lotub̃at wol tukot pǝpadaŋ hǝn naholoul a Krit. ");
INSERT INTO klv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Avil sǝdareh nǝlan paru, nahǝsan aNotis, eṽuv idaŋ tukot len naholoul a Krit gǝmai. ");
INSERT INTO klv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Husur nǝlan iṽas nǝwag wol gol ke edǝdas b̃iwol len nǝlan topat gol nǝhon maienan, namtupair, sarmar mai nǝlan. ");
INSERT INTO klv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nǝboŋ namttogam tarhǝbab len natuhholoul, nahǝsan a Kauta, namtolǝboi namtb̃eliv natuhb̃ot vi mǝhat len nǝwag wol, naut kǝmas ke todaŋ, ale namtubaŋis gati. ");
INSERT INTO klv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nǝboŋ tovi mǝhat tonoŋ, lopis garu hǝn nǝwag wol hǝn nab̃iltihau hǝn asike b̃imap̃ul. Beti husur lomǝtahw ke likos len nasǝhau a Sirtis, lubar hǝn nǝlai tovi aga, ale nǝtas isar hǝn galito, nǝwag wol igam mǝdau. ");
INSERT INTO klv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nǝtas ekur habat hǝn ginamito gol ke pelan han lotub̃at bubulan nǝkako len tas. ");
INSERT INTO klv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ale len nǝmariboŋ totor han lubar hǝn nahudhutit hǝn nǝwag len tas hǝn navǝlalit ŋai hǝn lǝb̃imaur. ");
INSERT INTO klv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Len nǝmariboŋ isob̃ur namityal mai nam̃eso gail lǝsavisi. Nǝlan paru iṽas habat hǝn ginamito van gol ke namtsadǝlomi am ke namtb̃imaur. ");
INSERT INTO klv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nǝboŋ ebǝlav lǝsǝhan, beti aPol ile mǝhat, ikel mai galit ke, “Lalum̃an, ivoi mǝttasǝsǝloŋ hǝn nalǝlǝgauan sagw. Asike mǝttawol dan naut a Krit, natit gail hǝn nǝwag asike lǝtǝmap̃ulp̃ul, asike lǝtǝmasig. ");
INSERT INTO klv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Be nukel mai gamit ke, ivoi mǝtetǝgau gat nǝlomito husur nǝmauran samito asike imasig, nǝwag wol ŋai dereh timasig. ");
INSERT INTO klv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","AGot tovi esagw notoum san, nino len mariug aŋel san eil tǝban ginau ");
INSERT INTO klv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ike, ‘Sagemǝtahw Pol. Dereh gimaur, geil m̃au len nakotan seSisa, ale aGot eviol hǝni mai gaiug tia hǝn nǝmauran salit p̃isi lotosah len nǝwag wol mai gaiug.’ ");
INSERT INTO klv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Imagenan, lalum̃an, mǝtelǝŋon tivoi am len nǝlomito husur nukad nadǝlomian len aGot ke dereh tesum̃an nǝsa tokele mai ginau. ");
INSERT INTO klv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Be datimaskos len naholoul ideh bai.” ");
INSERT INTO klv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nǝboŋ nawik eru togam gole, len mariug, nǝboŋ nǝtas tosar hǝn ginamit tukot len Nǝtas Atria, tub̃loh len mariug alat lotoum len nǝwag wol lunau ke lusal gǝm pǝpadaŋ hǝn naut ideh. ");
INSERT INTO klv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lugol ris nǝsarehan hǝn nǝtas, sab̃i ke namita han tovi 37. Sǝdareh lugol ris nǝsarehan tǝtas, sab̃i ke namita han tovi 27. ");
INSERT INTO klv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Lomǝtahw ke hum ma namtb̃ikos len nǝvat, ale lubar hǝn naga ivat bathuwag beti lusor tuṽ vir nalennǝyal b̃egǝmai. ");
INSERT INTO klv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Galevis lotoum len nǝwag wol lohisi ke ligam dan nǝwag, ale loriŋ natuhb̃ot vi pan gǝras ke libar hǝn naga gail dan nǝmashuwag. ");
INSERT INTO klv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Be aPol ikel mai nasenturion mai nasoltia gail ke, “Alatenan asike lǝb̃itoh len nǝwag wol, asike mǝtolǝboi mǝtb̃imakuv dan nǝmatan.” ");
INSERT INTO klv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Beti nasoltia gail luta kotov nǝhau totah gat natuhb̃ot, gol ke isal. ");
INSERT INTO klv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pǝpadaŋ hǝn naut b̃ilan aPol eŋir galit p̃isi ke lihan, ike, “Damǝŋ nǝmariboŋ evi 14 mǝttotoh van mǝtsǝhan, ale nǝhanan samit eb̃uer. ");
INSERT INTO klv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Imaienan, ivoi ke mitihan natideh hǝn b̃evi tarhǝt samito. Mitimasgole hǝn mǝtb̃imaur. Husur nasivur ideh len nǝkadumit asike imasig.” ");
INSERT INTO klv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nǝboŋ tokǝmaienan tonoŋ, len nǝholit p̃isi ilav nabǝta, esipa len aGot, eb̃ur nabǝta ale etub̃at hani. ");
INSERT INTO klv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Galit p̃isi lolǝŋon ivoi am len nǝlolito ale luhan. ");
INSERT INTO klv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(Ginamit p̃isi len nǝwag wol enan namtovi 276.) ");
INSERT INTO klv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nǝboŋ lotohanukub tonoŋ, lobubulan nawit len tas hǝn b̃igol nǝwag wol b̃emǝlala. ");
INSERT INTO klv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nǝboŋ naut tolan, lǝsaris lǝboi naut be lokǝta bunus nab̃urhuut sua tokad nabion lotoke ligol nǝwag wol tikos lan, be lǝsalǝboii ke timaienan o ledǝdasi. ");
INSERT INTO klv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŋa luta kokotov nǝhau hǝn naga gail hǝn lǝb̃ipat butitas. Nǝboŋ lotogol nauman en sal, lusah rub̃at nǝhau gail lotopis gat nǝṽos wolwol gǝlaru hǝni. Beti loliv nǝlai mashuwag vi mǝhat hǝn nǝlan b̃eṽuvi, ale luwol vahut bitas. ");
INSERT INTO klv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lubar naut nawilel tolev ale lukos. Nǝmashuwag edǝdas b̃erus be nab̃iltitas iṽas nǝbathuwag van van vǝmap̃ulp̃ul. ");
INSERT INTO klv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Nasoltia gail lusor utaut hǝn lǝb̃igol alat lotobaŋis gat galito limat hǝn asike lǝb̃egǝgar yav. ");
INSERT INTO klv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Avil nasenturion ike aPol timaur, ale ikai tas na-sor-utaut-an enan. Ikele ke, alat lotolǝboi nagǝgaran lemǝlah len tas a m̃o, gǝgar vahut. ");
INSERT INTO klv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ale ikel mai alat lotosuh ke, ideh litah gat nǝtarhai, ideh litah gat nahudhuwag. Imagenan galit p̃isi lubar nabitas, lumaur. ");
INSERT INTO klv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nǝboŋ namttovahut namtusab̃i ke nahǝsan naholoul enan evi Malta. ");
INSERT INTO klv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Husur naus eus mai naut esusus, alat lotosuh ei luvoi habat hǝn ginamito. Lotuŋ nǝhab, ale lukel nahǝhaṽuran salito mai ginamito. ");
INSERT INTO klv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","APol itariv nǝhab galevis, be nǝboŋ toriŋi len nǝhab, nǝm̃at sua, nǝvaipa, imakuv dan naut topud, hat navǝlan. ");
INSERT INTO klv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nǝboŋ alat a Malta lotoris nǝm̃at totahǝtah len navǝlan, lusorsor mai galit gabag ke, “Ategai evi naulum̃an togol nǝmatan. Naut kǝmas gai sǝmat len tas, nagot pǝhaṽut sidato, aNoran, asike idam̃ ke timaur am.” ");
INSERT INTO klv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Be aPol ekur kuv nǝm̃at vi lan nǝhab ale aPol imaur sal. ");
INSERT INTO klv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Luvatvat viri ke dereh aPol titob o titeh tutut timat. Avil lutoh viri ebǝlav sob̃uer. Natideh savisi hǝni. Ale logǝgel hǝn nǝnauan salito, lotub̃at kele ke evi nagot sua. ");
INSERT INTO klv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pǝpadaŋ hǝn naut enan ikad nǝtan sinǝvanuan totibau hǝn naholoul, nahǝsan aPuplius. Gai ike, “Ivoi,” mai ginamito ale ekǝtkǝta tǝban ginamit len nǝmariboŋ itor. ");
INSERT INTO klv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Len nǝboŋ enan atǝman aPuplius emǝsah. Ipat len nǝmel, epud mai ep̃irp̃ir. APol ivan hǝni, isor tuṽ. Nǝboŋ tonoŋ eriŋ navǝlan gǝlar lan ale imaur. ");
INSERT INTO klv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Husur natenan, galit p̃isi len naholoul lotomǝsah, logǝm hǝn aPol ale lumaur. ");
INSERT INTO klv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Loputsan ginamit hum namttovi vanuan toyalyal gail. Ale nǝboŋ namttoutaut hǝn namtb̃iwol vi lau, lousan natit p̃isi b̃evi tarhǝt sinamit len nawolan sinamito. ");
INSERT INTO klv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Husur nahǝbati itor namtovi lau len nǝwag wolwol ta Aleksadria tokir len naholoul enan len nahǝbati naut susus. Ikad Namǝlav Larmiṽan tovi namǝlauah han. ");
INSERT INTO klv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Namtubar naut a Sirakus, ale namtutoh ei nǝmariboŋ itor. ");
INSERT INTO klv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Beti namtoriŋ naut enan namtubar naut a Rekium. Pelan han nǝlan len nǝsautwes etǝvah, namtoriŋ naut enan, ale hois han namtubar naut a Puteoli. ");
INSERT INTO klv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Len naut enan namtusab̃ nǝvanuan nadǝlomian lotous ginamit hǝn namtb̃itoh mai galito len nawik esua. Imagenan namtogǝm vǝbar naut a Rom. ");
INSERT INTO klv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nǝboŋ nǝvanuan nadǝlomian gail ei lotosǝsǝloŋ hǝni ke namttogǝmai, logǝm van vǝbar Nǝmaket siAppius mai Naim Ŋavŋav Itor hǝn lǝb̃ebubur mai ginamito. Nǝboŋ aPol toris galito, elǝŋon ivoi am len nǝlon, ale esipa vi tǝban aGot. ");
INSERT INTO klv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nǝboŋ namttobar naut a Rom, ludam̃ hǝn aPol b̃itoh sǝb̃on len naim sua mai nasoltia tokǝtkǝta kǝkol hǝni. ");
INSERT INTO klv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Len nǝmariboŋ totor tohusuri, aPol ekis naJu gail lotoil a m̃o gǝmai. Nǝboŋ lotob̃onb̃on ikel mai galit ke, “Lalum̃an, aṽagw gail, naut kǝmas nǝsagol natideh tomǝdas nǝvanuan sidat gail mai naṽide setǝmadat ta sutuai, naJu gail lutah gat ginau len naut a Jerusalem ale loriŋ ginau len navǝlan alat a Rom. ");
INSERT INTO klv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nǝboŋ lotous nausian gail mai ginau, luke leriŋ ginau nivan husur lǝsǝsab̃ natideh tonor hǝn nǝb̃imat. ");
INSERT INTO klv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Avil nǝboŋ naJu gail lotosor mǝtahuni, igol ke nous ke nikot len nakotan seSisa, naut kǝmas nǝsǝkad natideh hǝn nab̃ikot hǝn nǝvanuan sagw gail sile. ");
INSERT INTO klv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Bathut natgalenan, nokis gamit gǝmai hǝn nǝb̃eris gamit mai sor mai gamito. Nukad natsen galegai sil nǝ-vatvat-viri-an seIsrael, tovi aKristo.” ");
INSERT INTO klv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ale lusor vari ke, “Namtsǝlav nalob̃ulat ideh a Jutea tosor husur gaiug, mai avan ideh tobar naut egai sakel uri o sakel natideh tosa husur gaiug. ");
INSERT INTO klv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Be namtuke namtesǝsǝloŋ hǝn nǝnauan sam̃ gail, husur namtolǝboii ke, nǝvanuan gail len naut p̃isi lusor tas naluṽoh egaii hǝn nalotuan totile.” ");
INSERT INTO klv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Loriŋ gat nǝboŋ sua vir aPol ale galit isob̃ur logǝm vi lan naim totoh lan. Tub̃at dudulan vǝbar nalenmariug aPol isor vahvah mai galito, ikel ur natohan pipihabǝlan aGot ale len nalo siMoses, mai natosian sihai kelkel ur gail, ikel natgalenan hǝn lǝb̃egǝgel hǝn nǝnauan salit husur aYesu. ");
INSERT INTO klv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Galevis lunau ke aPol ekitin, galevis am lǝsadǝlomi. ");
INSERT INTO klv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Husur nǝnauan salit sasua, lotub̃at riŋ naut enan. Ale aPol isor tǝtas am ke, “ANunun aGot ekitin nǝboŋ tokel mai atǝmadat ta sutuai len ahai kelkel ur, aIsaiah, ");
INSERT INTO klv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ke, “‘Givan hǝn nǝvanuan galegai, gike, “Len nasǝsǝloŋan samito, dereh mǝtesǝsǝloŋ be asike mǝtosǝsǝloŋ lǝboi nǝsa notokele, ale len nakǝtaan samito, dereh mǝtekǝta be asike mǝtokǝta lǝboi nǝsa notogole.” ");
INSERT INTO klv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Husur nǝkadun alategai egǝm ṽonṽon, pǝpadaŋ nǝdariŋalit eb̃ulb̃ulol, ale namǝtalit ib̃er. Asike lǝtǝmagenan, namǝtalit takǝta ris nǝsa notogole, nǝdariŋalit tasǝsǝloŋ hǝn nǝsa notokele, nǝlolit talǝboi natgalenan, ale lǝtǝpair van hǝn ginau, ale nǝtagol galit lǝtǝmaur.’ ");
INSERT INTO klv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","“Ale ginau nuke mǝtelǝboii ke, nǝ-lav-kuvi-an enan dan nǝsaan, aGot esǝvati tia van hǝn alat lǝsavi Ju, ale galit dereh lesǝsǝloŋ balai!” ");
INSERT INTO klv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Len nasihau eru aPol itoh ei len naim gai torentem, ale ehǝhaṽur hǝn nǝvanuan p̃isi lotogǝm hǝni. ");
INSERT INTO klv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ikel ur natohan pipihabǝlan aGot, ep̃usan husur Nasub̃ aYesu Kristo len na-il-b̃uri-an, ale sǝkad avan ideh tomǝdasi. ");
INSERT INTO klv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ginau, aPol, nutos nalob̃ulat napisulan egai. Novi naslev sua seKristo, aYesu, aGot totabtabuh len ginau hǝn nǝb̃evi hai pispisul m̃os na-kel-uri-an san tovoi. ");
INSERT INTO klv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Sutuai, nǝboŋ aYesu savisi sal, aGot ikel gati ke dereh tikel vǝhot na-kel-uri-an san tovoi. Ale ikel vǝhoti len nǝsa ahai kelkel ur gail lototosi len natosian siGot. ");
INSERT INTO klv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Na-kel-uri-an tovoi ehusur aNatun aGot, aYesu. Len nǝmauran san len navile a pan, ikad nǝpasian len nǝbathuyah siTevit tovi Kiŋ. Ale aNunun aGot ikel uri ke tovi aNatun aGot len nǝdaŋan nǝboŋ togol tole mǝhat dan nǝmatan. Gai evi aYesu Kristo, aMasta sidato. ");
INSERT INTO klv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Len gai, aGot eviol kǝmas hǝn navoian mai ginau, hǝn nǝb̃evi ahai pispisul m̃os nahǝsan aKristo, hǝn nǝb̃ekis nǝvanuan dan naluṽoh hǝn nǝvanuan naut tiltile p̃isi, hǝn lǝb̃igol husur nǝsa tokele bathut nadǝlomian lotokade lan. ");
INSERT INTO klv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Gamit a Rom, mǝtovi galit galevis. AGot ekis gamit am hǝn mǝtb̃evi seKristo. ");
INSERT INTO klv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ginau aPol, nutos nalob̃ulat napisulan egai van hǝn gamit p̃isi a Rom, aGot tolǝmas bun gamito, gai tokis gamit hǝn mǝtb̃evi esan sǝb̃on. AGot atǝmadato mai Nasub̃ aYesu Kristo areviol kǝmas hǝn navoian mai gamito, arigol nǝlomit tikad natǝm̃at. ");
INSERT INTO klv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nuke nikele bai ke, len aYesu Kristo, nosipa vi tǝban aGot hǝn gamit p̃isi, husur nǝvanuan gail lukel ur nadǝlomian samito len navile a pan kavkav. ");
INSERT INTO klv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","AGot notoum san len nǝlogw kavkav nǝboŋ notokel ur na-kel-uri-an tovoi husur aNatun ulum̃an, aGot elǝboii ke notokitin nǝboŋ notokel ke notosor tuṽ m̃os gamit tabtab. ");
INSERT INTO klv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Akis vǝbar damǝŋai len na-sor-tuṽ-an sagw, nous aGot ke, b̃elǝŋoni, dereh tigol nap̃isal ideh hǝn nǝb̃em̃ǝdoŋ tǝban gamito. ");
INSERT INTO klv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Husur nolǝŋon masuṽ hǝn nǝb̃eris gamito, hǝn ke, len nagǝmaian sagw, mǝtb̃ikad naviolan ideh seNunun aGot hǝn b̃igol mǝtb̃idaŋ am. ");
INSERT INTO klv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nolǝŋon masuṽ hǝn nǝb̃eris gamito hǝn datb̃igol datb̃elǝŋon b̃ivoi am len nǝlodat gabag, nuke nevi tarhǝt samit len nadǝlomian samito mai gamit am mǝtevi tarhǝt sagw len nadǝlomian sagw. ");
INSERT INTO klv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bathudud nadǝlomian gail, nuke mǝtelǝboii ke notonau utaut hǝn nǝb̃em̃ǝdoŋ tǝban gamito. Nugol vǝha-sob̃ur hǝni be natgalevis lupatpat gol ginau vǝbar damǝŋai. Nuke neum samito ale nauman sagw len gamito tikad naṽite hum notokade len alat lǝsavi Ju len naut tiltile gail am. ");
INSERT INTO klv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nolǝboii ke aGot eriŋ nauman len ginau ale nimasgole m̃os nǝvanuan gail p̃isi, nǝvanuan nab̃iltivile gail mai auleut gail, alat lotokad nalǝboian mai alat lototǝtan hǝni. ");
INSERT INTO klv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Husur natenan, noutaut, nolǝŋon nǝb̃ikel ur na-kel-uri-an tovoi mai gamit a Rom am. ");
INSERT INTO klv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nahurugw sǝsa hǝn na-kel-uri-an tovoi. Evi nǝdaŋan siGot m̃os nǝ-lav-kuvi-an dan nǝsaan silat lotokad nadǝlomian: m̃os naJu gail a m̃o, beti alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Husur na-kel-uri-an tovoi ikel vǝhot nap̃isal hǝn aGot b̃igol datb̃inor len nǝhon. Nap̃isal enan etub̃at len nadǝlomian van van, inoŋ len nadǝlomian. Hum natosian siGot toke, “Len nadǝlomian nǝvanuan nanoran ikad nǝmauran.” ");
INSERT INTO klv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","AGot len nǝmav evǝhot nǝlol paŋpaŋ san. Nǝlon epǝŋas nǝsaan silat lotomǝtahun aGot, lotopul hǝn nǝsaan. Galit, len nǝsaan salito, losusuan nakitinan. ");
INSERT INTO klv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Galit lolǝboi nakitinan husur aGot, bathut igol ip̃arp̃ar hǝn galito. ");
INSERT INTO klv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Naut kǝmas lotodǝdas lǝb̃eris nǝdaŋan san topat vi sutuai mai nab̃oruan san hum aGot; be nǝdaŋan mai nab̃oruan san arup̃arp̃ar len natit p̃isi togole. Husur len natub̃atan nǝboŋ aGot togol navile a pan, van vǝbar damǝŋai, nǝvanuan gail loris natit aGot togol gail. Imaienan lǝsalǝboi lǝb̃etǝtas gol galito. ");
INSERT INTO klv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Husur ke, naut kǝmas lotolǝboi aGot maienan, lǝsǝsal suh nǝyalyalan san sum̃an tovi Got, lǝsasipa vi tǝban. Be nǝnauan salito egǝm vi ut kǝmas, nǝnauan salit sǝkad nǝ-nau-lǝboii-an lan, lopul hǝn nǝmargobut ŋai. ");
INSERT INTO klv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Lukel ke lotokad namitisau hǝn nǝmauran tonor, be logǝm vi hoṽon gail. ");
INSERT INTO klv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Lugel nǝyalyalan siGot totoh vi sutuai hǝn nǝlablab gail lotokad nǝnahǝnah hǝn nǝvanuan lǝb̃imat, nǝman namǝsav gail, narivatvat gail mai natit lotokǝlkǝlah. ");
INSERT INTO klv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Imagenan, aGot eriŋ gab̃ulan galito hǝn lǝb̃igol natideh lotolǝŋoni len nǝlolito, gol ke, len nab̃iŋb̃iŋalan salito, lomǝdas nibelit gabag len naitian tosa lotogolgole. ");
INSERT INTO klv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Lugel nakitinan husur aGot hǝn nalibliboŋan. Ale lulotu hǝn natit aGot togol gail, lugol lotovi slev salit gail. Lǝsalotu hǝn aGot togol natgalenan, be gai inor hǝn nǝ-sal-suhi-an van vi sutuai. Ganan! ");
INSERT INTO klv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Husur lotogol natgalenan aGot eriŋ gab̃ulan galito hǝn lǝb̃igol naṽide tob̃iŋb̃iŋal ideh lotolǝŋoni. Alatpǝhaṽut salit tu lupair dan nap̃isal hǝn naitian mai asoalit gail hǝn lǝb̃igol naitian mai galit gabag. ");
INSERT INTO klv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Len naṽide tomaienan alalum̃an lupair dan naitian mai alatpǝhaṽut, nǝlolit isahsah len galit gabag. Alalum̃an lob̃ur kotov naṽide tonor, lugol tob̃iŋb̃iŋal mai galit gabag. Ale sil nǝsaan lotogol gail, nǝpanismen tonor hǝn nǝsa galit sǝb̃olit lotogole ibar galito. ");
INSERT INTO klv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Bathut lotonau ke na-lǝboi-aGot-an savi natideh, aGot eriŋ gab̃ulan galit hǝn lǝb̃itoh len nǝ-nau-sabsab-an salito. Imaienan lugol nǝsa sanor hǝn lǝb̃igole. ");
INSERT INTO klv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Logǝm pul hǝn nǝsaan tiltile gail: nab̃oruan sasa, na-lǝŋon-masuṽ-hǝn-natite-an hǝn natite, nǝsasaan, lutab̃ulol bulos avan ideh husur nǝsa tokade. Lugolgol nǝmatan, lopul hǝn naṽitṽituhan mai nagǝgǝrasan. Lohǝhaṽur hǝn lǝb̃igol na-lǝŋon-isa-an len nǝvanuan gail, lukel nǝmadun nǝvanuan gail, ");
INSERT INTO klv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","lusor mǝdas nahǝsalito. Lomǝtahun bun aGot, len naṽivan salit lǝsǝnau avan ideh am. Nǝholit ileleah ale lusor patpat galit mǝhat. Lukad namitisau hǝn lǝb̃inau tabtab hǝn nap̃isal toveveu hǝn lǝb̃igol nǝsaan. Lǝsagol nǝsa atata mai anana artokele. ");
INSERT INTO klv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Len naṽide hǝn nǝmauran salito ehum lotomelmel, lob̃ur kotov na-kel-gati-an salit gail, na-lǝmas-buni-an eb̃uer len galito, nǝlolit sǝtaŋis avan ideh, ehum lǝsǝkad nalolosaan ideh. ");
INSERT INTO klv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Lolǝboii ke, bathut aGot tonor, ikele ke, nǝvanuan gail lotogol naṽide lotomaienan limasmat. Avil lohusur naṽide galen sal. Savi natenan ŋai, be lohǝhaṽur hǝn lǝb̃eris nǝvanuan gail am lǝb̃ehusur naṽide salito. ");
INSERT INTO klv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Gaiug gotosab̃ sǝhoti ke nǝvanuan tile am timaspanis, gǝsalǝboi gǝb̃etǝtas gol gaiug, husur gaiug am gusa sum̃an galito. Nǝboŋ gotosab̃ sǝhoti ke avan ideh timaspanis husur nǝsaan san, be gaiug gusab̃ sǝhoti ke gaiug am gimaspanis, husur gaiug gugol nǝsaan top̃itp̃itoṽ. ");
INSERT INTO klv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Datolǝboii ke, nǝboŋ aGot tosab̃ sǝhoti ke nǝvanuan limaspanis sil lotogol natenan, nǝ-sab̃-sǝhoti-an san inor hǝn nakitinan. ");
INSERT INTO klv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Imagenan, gaiug, nǝboŋ gotosab̃ sǝhoti ke galit limaspanis be gaiug gohusur naṽide top̃itoṽ hum galito, gunau ke gotolǝboi gǝb̃igam yav dan nǝpanismen siGot a? Ao! ");
INSERT INTO klv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Gǝsalǝboii ke aGot tovoi masuṽ hǝn gaiug a? Gai satutut hǝn b̃emǝtahun gaiug; len nasusumaran, itoh mǝdau mai gaiug. Gǝsalǝboii a? Hum ma natgalenan lǝsavi natideh len gaiug. AGot ivoi hǝn gaiug hǝn b̃esǝhar gaiug van hǝn nǝpairan dan nǝsaan, gǝsǝnau sǝhoti a? ");
INSERT INTO klv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Be gaiug guhaihai, nǝkadum̃ iṽonṽon, gomǝtahun gǝb̃ipair dan nǝsaan sam̃. Bathut gotomaienan gugol ke nǝpanismen sam̃ gabag evivi mǝhat am, husur nǝboŋ hǝn nǝlol paŋpaŋ dereh tegǝmai. Evi nǝboŋ aGot b̃ikel vǝhot nǝ-sab̃-sǝhoti-an san tonor, mai nǝpanismen. ");
INSERT INTO klv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","AGot dereh tilav nap̃urp̃uran mai nǝvanuan p̃isi tinor hǝn nǝsa lotogole. ");
INSERT INTO klv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Dereh tilav nǝmauran vi sutuai mai alat lotosusumar hǝn lǝb̃igol navoian, lotodaŋ len aGot hǝn b̃eviol hǝn nǝyalyalan, nǝ-sal-suh-galito-an mai nǝmauran topat vi sutuai. ");
INSERT INTO klv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Be len nab̃iltilol paŋpaŋ san, dereh nǝlon aGot tepǝŋas alat lotonau galit sǝb̃olito ŋai, lǝsagol nǝsa nakitinan tokele, be lotopul hǝn nǝsaan len nǝmauran salito. ");
INSERT INTO klv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Na-lǝŋon-isa-vǝsa-an mai nǝmauran todaŋ dereh aribar nǝvanuan p̃isi lotogolgol nǝsaan: naJu gail a m̃o, beti alat lǝsavi Ju. ");
INSERT INTO klv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Be alat lotogolgol navoian, dereh aGot tisal suh galito, teputsan nahǝsalito, teriŋ natǝm̃at len nǝlolito: naJu gail a m̃o, beti alat lǝsavi Ju. ");
INSERT INTO kl