﻿USE sofia;
DROP TABLE IF EXISTS sofia.klt_vpl;
CREATE TABLE klt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES klt_vpl WRITE;
INSERT INTO klt_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Uláp rám ámna yáilá yá Israel pin yáni tángga áturáng hára, pana ore káman wahára kesák maming táwi Israel káwak káin tunggafiuk. Rám wahára ámna káman it Betlehem Juda ále káinnan dá kung hánámá Moab káwak káin rám kimo árin ingga áwáná nanggená yará yot kámuk kuráng. ");
INSERT INTO klt_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ámna wata kutná ku Elimelek, hang áwáná kutná ku Naomi, iná nanggená yará wata kut yándi ku Malon káling Kilion. Wawu hun yáni ku Efrata háranan, it Betlehem Juda ále káinnan, watá kung Moab káwak káin átkiuráng. ");
INSERT INTO klt_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Átang Naomi náulá Elimelek ká kámurán du áwáná yá nanggená yará yot yáni rewe áturáng. ");
INSERT INTO klt_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nanggená yará yá Moab náráwa yará áwá yándi ya ihumálák. Káman da kutná ku Rut, hang nukngá wata kutná ku Orpa. Kulá wakáin yara 10 hám wáina áturáng. ");
INSERT INTO klt_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Kulá Malon káling Kilion dá hányon kámurán du, Naomi wu náulá me nanggená yará wa muná. ");
INSERT INTO klt_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Átang árongga Naomi yá naruk ku Juda ále káin Táwi yá rám álosim ámna náráwaná yámán sungngi yáni yá tunggafengga árán du málám Moab káwak wa nambáná yará yot sangga kukuya tiktiyawik táuráng. ");
INSERT INTO klt_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Kulá málám ále átuk wa sangga nambáná yará yot Juda ále ya kukuya kálu hulátiuráng. ");
INSERT INTO klt_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kungga átang, Naomi yá nambáná yará wa yánuk, “Mamam sándi yan it hulá ya son sándi kundimálák. Táwi yá sán sáháng tolinek, náuta sándá nánáun sándi há kámutumálák wa iháng toliumálák me nák neháng tolingga áwánggoemálák wáinanyon. ");
INSERT INTO klt_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Wáina wata ku Táwi yá háláng sámán du, nánáun sándi nukngá ihángga watán it káin álosim átkuineráng.” Wáina yánángga ku, árong Naomi yá kápáng kumen kutkáyawát táwi hánám táuráng. ");
INSERT INTO klt_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Wáina tángga sangga nambáná yará yá son inumálák, “Muná, nát tu kákkot kákkán tombongga há hánám kuinemán.” ");
INSERT INTO klt_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Enendu Naomi yá miuk, “Son kundimálák, uriwana yará. Náuta ku nákkot kuinemán? No nangge son iháng te sán nánáun sándi háháleyan tárák ma árat, ");
INSERT INTO klt_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","wata ku son sándi kundimálák, uriwana yará. Nák ku náráwa há hálet, son náunna ma táindát. Kálu kámá ing árán iná ku ing tátáyan, kula yáungán no náunna tángga, wahára kungga nángánanggena iháng te ");
INSERT INTO klt_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","sándá háleng yámángga árán watá titiha wawu káluná muná. Sándá nánáun sándi muná átnát tán tárák ku muná. Uriwana yará, pahán márapmá náni wu tárák wáina re, enendu nákkán du táwi hánám. Táwi yá neháng wáik tán átkoet.” ");
INSERT INTO klt_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Naomi yá wáina yánán son kutkáyawát táwi hánám táuráng. Kulá Orpa yá ku nambáná sangga kukuya pukon kang kumiuk, iná Rut tá ku nambáná káto poláng mángga tángga átuk. ");
INSERT INTO klt_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Wáina tángga árán du Naomi yá inuk, “Kang, nukka wu son há koek, málámbán tombong me málámbán ánutuná ya, máriná ya isutang kung.” ");
INSERT INTO klt_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Wáina inán, Rut tá miuk, “Kepmangga son kukuya ma nanáng seindalák. Ko rekáin kuinelák, nák ku wakáin kuinet; me rehára átnelák, nák ku wakáin átnet. Kákkán tombong wawu nákkán tombong, me kákkán Ánutu wawu nákkán Ánutu. ");
INSERT INTO klt_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ko rekáin kámutnelák, nák ku wakáin yon kámure neháng usineráng. Náut kámá káman dá ma náháng horeindák. Kátkámut tá rewe náháng horeinek. No mena ná met ná ma isure hálendu Táwi yá álo neháng wáik hánám táinek.” ");
INSERT INTO klt_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kulá Naomi yá kan Rut tá kikilingga málám bot kukuya tán kangga ku, Naomi yá me kámá son ma inuk. ");
INSERT INTO klt_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yándi wu yayará kungga kungga Betlehem káin kung hiumálák. Rám it wahára kung hiumálák hára, it pálak hárámutang áwáng kápángga ku náráwa yá miuráng, “Kák ka Naomi puk me?” ");
INSERT INTO klt_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Wáina met, Naomi yá yánuk, “Naomi ing ma mantáng namindaráng. Ináku Mara ing mantáng namineráng, náuta Ánutu Uliháláng Márumá watá neháng wáik tán watá pahánna kinan ukuro hánám átak. ");
INSERT INTO klt_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","No kut wawu kutná kutná na pálak, iná Táwi yá nangot áwáng sáek wawu kutná kutná na muná. Náuta Naomi ing mantáng nameráng? Táwi Uliháláng Márumá yá neháng wáik tán márapmá yá nákkot átak.” ");
INSERT INTO klt_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Náwu Naomi yá Moab káwak sangga áwuk watán pingnga. Nambáná Moab náráwa Rut watyot áwumálák. Wa áwumálák wawu bali mamará hulátitiná kálu. ");
INSERT INTO klt_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Kulá Naomi káungáná káman kutná ku Boas. Ámna wawu Elimelek kán hun háranan, hun wata kinan ámna kutná pálak átnándak. ");
INSERT INTO klt_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kulá hang Moab náráwa Rut watá Naomi ing inuk, “Nepmatá hái káin kungga bali kátu yákyákmak táená wa kámolin. Káman niyá nahángga álo ingga nanán hálendu kámonet.” Wáina men Naomi yá inuk, “Álo kuinelák, uriwana.” ");
INSERT INTO klt_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Wáina inán Rut málám kungga hái káin yáup ámna yá bali marángga ihángga kut márin yáni ya kátu yákyákmak táená wa kámondang kuk. Kulá Rut tá hái wawu Boas yan ingga ma narená kuk, iná Boas wawu Elimelek kán hun háranan. ");
INSERT INTO klt_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Rám waháranyon, Boas yá Betlehem kálu áwángga yáup ámnaná yánuk, “Táwi yá sányot átnek.” Ing yánán watá inuráng, “Táwi yá kuram táng kaminek.” ");
INSERT INTO klt_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Wáina inát átang sangga, kulá Boas yá yáup ámnaná táwi yáni ya átuk wa ináng suliuk, “Náráwa máto áning gu niyan hun háranan?” ");
INSERT INTO klt_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Wáina inán yáup ámna táwi yáni watá inuk, “Wawu Moab náráwa máto Naomi yot Moab ále káwak sangga áwumálák. ");
INSERT INTO klt_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Náráwa watá ing nanek, ‘Álo satá no yáup ámna yá bali marángga hárotang tingga kungga árát, márin yáni káin yákyákmak táená wa kámondang urum tinet me?’ Iná náráwa wawu yáup hára re átak, hilápmá hánám áwángga inggálu. Rám hátetná kimo re sima kinan putung hangga sek narek.” ");
INSERT INTO klt_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Kulá Boas yá kung Rut wáina inuk, “Náráwa máto, kándáng narinelák. Ko kung hái nukngá káin bali ma kámonándalák. Hái ná sangga ma kuindalák. Nákkán yáup náráwa yot nahára átneráng. ");
INSERT INTO klt_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Hálengga katá hái rehára yáup ámna yá marángga árát tu nákkán yáup náráwa yásutang wakáin kungguinelák. No yáup ámna na há yánáng rákit táet, kák keháng lem ma tátáya. Sala yá manmanin du, umi yáup ámna yá kátnáwáng kulená kárangngá káin átak kungga waháranan náinelák.” ");
INSERT INTO klt_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Wáina inán Rut tá turingga hangga kurákmáta táng hang káwak káin tingga Boas inuk, “Nák ku áwená. No náut álosim kákkán kálu táng tunggap táe ko nák nahángga neháng tolelák?” ");
INSERT INTO klt_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Wáina inán Boas yá hurik tángga ing inuk, “Ko náula yá kámurán nan mamya me it káwakka yápmangga áwulák ngáyá áwáng ámna náráwa uláp ma naráng yámená watyot átang nambáka ya rina rina táng mángga áwánggoelák, wawu erek hánám há met narut. ");
INSERT INTO klt_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Táwi Israel yan Ánutu ya hitná tárang káin árátá watá pinya tátáya áwulák. Táwi yá álosim rina táulák wáinanyon tán sambe yá kákkán káin táwi hánám tunggafeinek.” ");
INSERT INTO klt_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Wáina inán Rut tá inuk, “Táwina, nák ku yáup náráwa ka waháranan muná, me kutna muná, enendu ko nák nahángga neháng tolelák. Ko sutna táng láláp táelák, hang ko me nuk hára naháng melák.” ");
INSERT INTO klt_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kulá sungngi nana rám hára ku Boas yá Rut inuk, “Nákáin áwángga másáng kámá ihángga másáng kátu kimo satá wáin ingirángngá kinan han nang.” Kulá Rut tá yáup ámna tangtang putung han Boas yá bali sená kámá imán Rut tá nangga kawilá hahatin kátu yápman áturáng. ");
INSERT INTO klt_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Wáina tángga ku Rut tá tárutang yáup káin kun, Boas yá yáup ámna náráwaná yánuk, “Sat Rut tá bali máran tangtang álo kámonek, ma me táng mindaráng. ");
INSERT INTO klt_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Hang sándá bali kámá hárorená waháranan watán da uying hirarát han áwáng ihán kangga ku ma me táng mindaráng,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Kulá Rut tu hái káin bali kámondang átnárán du it tá yonyon tin kangga ku málám bali kámonduk wa kátingga páliná ihuk, wata márapmá náwu isikimo muná táwi sim, kilo náwu 10 kilo wáina ina. ");
INSERT INTO klt_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rut tá árong bali bek wa táng hip tánggatang it Betlehem káin son kun, nambáná yá bali kámondang ihángga kuk wa káuk. Hang káen sungngi náukngá kátu ihángga kuk wa Naomi imuk. ");
INSERT INTO klt_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Wáina tán kangga nambáná yá inuk, “Kula rekáin yáup tángga bali táwi hánám kámondalák? Ni ámna yá kaháng tunggap tángga keháng tolek wawu Táwi yá kuram táng minek.” Kulá wahára ku Rut tá niyan hái káin yáup táuk wa nambáná inuk, “Ámna kutná niyan hái káin no kula yáup táet wawu Boas.” ");
INSERT INTO klt_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Wáina inán Naomi yá nambáná inuk, “Táwi yá kuram táng minek. Málámbá há átaráng me há kámurená álosimmá wa hiták nálengngátak.” Wáina inángga son hang miuk, “Ámna wawu nánin sip kátu, watá kák kehángga náula kámutuk wata kutná meng mirak tátáyan álo kámá.” ");
INSERT INTO klt_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kulá Moab náráwa Rut watá miuk, “Me nukngá káman Boas yá ing nanek, ‘Kák ku nákkán yáup ámna náráwa tangtang rewe árátá kungga bali yot wit mamará watán rám bá sáliknginek.’” ");
INSERT INTO klt_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Wáina inán Naomi yá nambáná Rut inuk, “Wawu álosim, uriwana, ko watán yáup náráwa watyot re átnelák. Hái kámá káin kungngárá keháng lem tánirot.” ");
INSERT INTO klt_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wáina inuk wata ku Rut tá Boas yan yáup náráwa watyot átang bali yot wit kánkámon tángga átningngárán bali yot wit mamará watán rám bá sálikngiuk. Kulá rám ore wahára Rut tá nambáná yot átkiumálák. ");
INSERT INTO klt_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Rám káman Naomi yá Rut inuk, “Uriwana, no kák pinya tátáyan da sulindet, watá ku pinya táinek. ");
INSERT INTO klt_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kulá Boas wawu nánin hun háranan ámna ni watán yáup náráwa yot ko yáup tángngátalák. Kula yáungán wawu bali komená káin bali kipmá kotnándek. ");
INSERT INTO klt_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Wata ku umi kuhángga sutya oel mungnganá kikiná kuhángga lap álosim wa tawinelák. Wáina táng hálingga ku bali itná káin hang heinelák. Enendu ámna wata rahálá hára ma tunggafená árátá umi sungnginá wa erek nang hálinek. ");
INSERT INTO klt_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Kulá rám watá pándák hangga ruhán, ko ále rehára ruhek wa kándáng káinelák, kulá wahára ku kuinelák ngáyá hárammá kálu tek yaling mángga hang pándák átnelák. Wahára ku rina rina tátá wa watá kaninek.” ");
INSERT INTO klt_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Wáina inán Rut tá Naomi inuk, “Rina rina nanelák wawu álo isutang táinet.” ");
INSERT INTO klt_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kulá Rut tá bali itná káin kung hangga nambáná yá rina rina tátáya inuk wa erek hánám táng háliuk. ");
INSERT INTO klt_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Kulá Boas yá umi sungnginá nang hálingga pahálá yá álosim hálen málám ruruháya bali tená tangtang káin kung háuk. Wáina kangga Rut tá kilakkon hánám kuk ngáyá hárammá kálu tek yaling mángga hang hárammá hulá káin pándák átuk. ");
INSERT INTO klt_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kálu wa tunggafiuk wawu yáung táitná Boas yá ruhángga átnárán náut kámá yá táng mirak tán hurik tángga numkálu hangga káuk ku náráwa káman dá hárammá hulá káin pándák árán ikik hárámutuk. ");
INSERT INTO klt_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Wáina kangga Boas yá inuk, “Kák ku ni?” Ing inán náráwa watá inuk, “Nák ku Rut, kangán yáup náráwa. Kák ku Elimelek sipmá kátu wata ku ko nák nehángga náunna kámutuk wata kutná meng mirak táinelák.” ");
INSERT INTO klt_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Wáina inán Boas yá inuk, “Náráwa máto, Táwi yá kuram táng kaminek. Ko náwu kangán álosim wa pukon náula yan hun wa elelák. Álosim wa kálak táulák wawu wáina sim, iná kula pálik táelák nátá ku álosim hánám, náuta ko ámna máto kutná kutná yáni pálak me kutná kutná yáni muná yan káin ma kulák. ");
INSERT INTO klt_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Wáina ta ku, náráwa máto, ma pitáindalák. No kákkán kálu sareng kaminet. Tárák rina tángngátalák watá ku it náta kinan nan ámna náráwa kámuk watá kák ku náráwa kándáng hánám ingga naráng kameráng. ");
INSERT INTO klt_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Wawu pálipuk nák ku kákkán hun tangtang nan no álo pinya tánggem, enendu nák ku mulangán sim, iná ámna káman sip kátu hánám átak. ");
INSERT INTO klt_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Yáungán nahára álo átnelák. Hilápmá no ámna wa ine káinemán. Watá álo háláng kamámáyan hálendu álo wáina táinek, iná watá ma háláng kaminán men, wawu no álo háláng kaminet pálipuk Táwi rahálá hára. Álo son pándák átnárá it tá háinek.” ");
INSERT INTO klt_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Wáina inán Rut tá son Boas hárammá hulá káin pándák átnárán it tá háiháiya tángga átuk kálu Rut tá tárutuk hára yáup ámna ruhángga áturáng watá kámá ma káuráng. Wáina tárurán du Boas yá inuk, “Náráwa yá bali itná káin áwelák ka ku ni kámá káman dá ma hánám narindak.” ");
INSERT INTO klt_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ing inángga son Boas yá miuk, “Lap kátu yáila káin uselák wa táng áwáng táng hálak tángga álák.” Ing inán wáina tángga árán, Boas yá bali 20 kilo hám wáina kulin wata kinan han, háláng mángga táng hip tángga málámba ketnán tin du háná kuk. Kulá wata torong hára ku Boas yá hangga it táwi káin kuk. ");
INSERT INTO klt_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut tá nambáná yá átuk káin kung hen kangga Naomi yá ináng suliuk, “Uriwana, kuelák ka rina hánám hálek?” Ing inán Rut tá me pingnga Boas yá me rina rina inuk wa erek hánám Naomi ináng háliuk. ");
INSERT INTO klt_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Kulá son Rut tá ing miuk, “Boas yá ing nanek, ‘Ketya páliná muná nambáka yan káin ma kuindalák,’ ing mengga, bali 20 kilo hám wáina ná namán tángga áwet.” ");
INSERT INTO klt_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wáina inán Naomi yá miuk, “Uriwana, me yá rina kuinek wata hálengga yolop átnárá, náuta Boas yá emá me yáupmá tángga árán kungga kula re me yá kándáng háleindek.” ");
INSERT INTO klt_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Kulá hang Boas yá it Betlehem kumbi kálu mungnganá káin árongga wahára putung háuk. Waháranyon sip kátu ni Boas yá miuk watá áwán kangga Boas yá mantángga inuk, “Nukna, áwángga nahára putung hang.” Wáina mantángga inán ámna watá áwáng putung háuk. ");
INSERT INTO klt_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boas yá ámna yáilá 10 it waháranan watá áwát ing yánuk, “Áwáng nahára putung haniráng.” Wáina yánán áwáng wahára málám bot putung áturáng. ");
INSERT INTO klt_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kulá Boas yá sipmá kátu wa inuk, “Naomi, ni Moab ále káwak sangga áwuk, watán káwak kátu káman yuyuwáyan átak wawu náti ya sip náti kátu Elimelek watán hára. ");
INSERT INTO klt_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Wata ku kák kaninet ingga naret wa kanin, káwak wawu ko yuwinelák. No mená met náwu ámna náráwa me ámna yáilá putung átaráng wata rahán yáni hára. Álo yuyuwáya hálendu, ko yuwáng. Iná muná hálendu, nanátá no narin. Nukngá yá wáina tátáyan muná wawu ko rewe yuwinelák, enendu ko muná ing metá ámna nukngá wa yuyuwáyan wawu nák.” Wáina inán du Boas yan sip kátu watá miuk, “Álo no yuwinet.” ");
INSERT INTO klt_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Wáina men Boas yá miuk, “Rám rina hára ko káwak kátu Naomi ketná hára átak wa yuwinelák, waháranyon Rut kámurená kawátná wa áwáka ya táinelák, wáina tátá ku kámurená wata kutná me watán káwak watá hiták átneráng.” ");
INSERT INTO klt_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Wáina men kangga sipmá kátu watá miuk, “Nák ku ma yuwindát, náuta no kutná kutná na wa horengga naya nángánanggena wa yámángga kátu nangge nukngá yáyámáya takta naret. Ko kaya yuwáng, náuta no ma yuwindát wata.” ");
INSERT INTO klt_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Uláp Israel káwak káin kutná kutná son yuyuwá me imán kamán tátá mená watá sálikngek ingga wawu ámna káman dá málámbán sendol yalingga táng nukngá imánggiuk. Kálu watá ku Israel káin hiták meng tunggap tánggiuk me yá sopsowek ingga.) ");
INSERT INTO klt_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kulá hang ámna sip kátu watá Boas inuk, “Ka yuwinelák.” Wáina mengga sendol ná yalingga táng Boas imuk. ");
INSERT INTO klt_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kulá Boas yá ámna yáilá me ámna náráwa kámuk yánuk, “Náwu sándá wa há káeráng, no Naomi ketná hára kutná kutná Elimelek kán me Kilion káling Malon dán hára átak wa há yuwet wata ku sárumna káin namáng rosingga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Wata kátu háranyon, no Moab náráwa Rut wa hányon táinet, Malon kawátná wa áwána háleinek, watá ku kámurená yan kut me watán káwak ká hiták átneráng, hang kámurená kutná watá ma muná kuindák, hunná hára me itná hulá nahára. Sán du háláng namámáya átneráng.” ");
INSERT INTO klt_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ámna náráwa kámuk urum wahára áturáng me ámna yáilá watá miuráng, “Nán du háláng kakamá. Táwi yá tán náráwa ni kákkán it káin áwáng háinek wawu Resel káling Lea ina háleinek, yarán watá tombong Israel táng tunggap táumálák wáina. Iná kák ku ámna kutná kutná pálak Efrata hun hára it Betlehem kinan kutya táwi átnelák. ");
INSERT INTO klt_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Hang Táwi yá ráulaka kaminek, náráwa máto wata kinan nan wawu Juda káling Tamar nangge yándi Peres yan hun ina.” ");
INSERT INTO klt_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kulá hang Boas yá Rut tu áwáná ya táuk. Tángga Boas yá Rut yot káman hálen Táwi yá táng álolo tán kawilá átang nanggená ámnaná táng tiuk. ");
INSERT INTO klt_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kulá hang náráwa yá Naomi inuráng, “Táwi kutná meng tárut tánin, Táwi yá eka káman háláng kakamáya kamek. Nangge wata kutná yá Israel kinan táwi hánám háleinek. ");
INSERT INTO klt_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nángánanggeka ámnaná 7 dá átang keháng tolinggalát wawu hangga sim, iná nambáka watá kák ka kikiná narángga mángngátak wawu táwi hánám. Iná nambáka yá nanggená táng tek, wata ku nangge watá kákkán átkuku táng mirak táinek, me tátáwi háletá pinya táinek.” ");
INSERT INTO klt_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kulá Naomi yá nangge kimo wa tángga táng poláng mángga pinna kándáng tángga átkiuk. ");
INSERT INTO klt_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Náráwa nuknukngá wahára árená watá ing miuráng, “Naomi yan nangge ámnaná káman tunggafeng mek!” Iná nangge kimo wata kutná ku Obed ing mantáuráng. Obed wawu Jesi naning, iná Jesi wawu Devit naning. ");
INSERT INTO klt_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Kulá náwu Peres yan hun tombong: Peres wawu Hesron naning, ");
INSERT INTO klt_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","iná Hesron wawu Ram naning, iná Ram wawu Aminadap naning, ");
INSERT INTO klt_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","iná Aminadap wawu Nason naning, iná Nason wawu Salmon naning, ");
INSERT INTO klt_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","iná Salmon wawu Boas naning, iná Boas wawu Obed naning, ");
INSERT INTO klt_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","iná Obed wawu Jesi naning, iná Jesi wawu Devit naning. ");
INSERT INTO klt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Náwu Ánutu Nanggená Jesu Ámna Náráwaná Son Iháhá watán me pingnga álosim watá hulátek. ");
INSERT INTO klt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ánutu yá Nanggená me ing inán Aisaia yá me wanyon uyiuk ngá ná: “Naráng. No ámna niyá me tángga kung áwáng tátá wa kálak suring me kuinek, watá kálu tiyawing kaminek,” ");
INSERT INTO klt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","wawu “man dá ále komkomá páliná muná káin ing mantáinek, ‘Táwi yan kálu tiyawineráng, kálu kándáng hánám wa táng toling mineráng,’” wáina uyiuk. ");
INSERT INTO klt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kulá me wa isutang gu Jon Umi Kuháng Yámámá yá ále komkomá páliná muná káin áwángga yánuk, “Pahán hurik tángga áwáng umi kuhát tu Ánutu yá mukmuro sáni wa yawonek.” ");
INSERT INTO klt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wáina yánán du Judia ále káinnan me Jerusalem ámna náráwa táup hánám watá watán káin kuráng ngáyá kung mukmuro yáni meng tunggap tángga Jodan umi kinan árát Jon dá umi kuháng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon dá kutná kutná mongiuk wawu kamel rommá yá táng tolená, iná let songgo kepmá yá táng tolená watá ku pánápmá hára táng kik tángga, sungnginá ya wu yot maming tátáwi watyot kitembong páyom tunggun yáni wa nanggiuk. ");
INSERT INTO klt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kulá watán me wu ná: “Nák torong káin ámna káman áwinek wata hálángngá wu nák neháng hátek, hang ámna nák ina tá turing hang watán sendol páupmá yayaliyan tárák muná. ");
INSERT INTO klt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","No ku umi hánám watá kuháng sámet, iná watá ku Iruk Káungá watá kuháng sáminek.” ");
INSERT INTO klt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rám wahára Jesu wu it Nasaret ále Galili kálu áwáng kung Jodan umi kinan han Jon dá umi kuháng muk. ");
INSERT INTO klt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Rám Jesu yá umi sangga kep káin árángga áwuk, wahára hánám Jesu yá káuk ku alek ká ang tán Iruk ká iráp tánarám bá ina kahet hang málám hára ep tángga árán, ");
INSERT INTO klt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","rám waháranyon me káman alek kálu ing háuk: “Kák ku nák Nanggena. No kák ka kikiná hánám naret. No kák ka pahánna álosim hánám naret.” ");
INSERT INTO klt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rám waháranyon Iruk ká Jesu suring mán ále komkomá páliná muná káin kung ");
INSERT INTO klt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","rám 40 átuk wata kinan Satan dá ingirungngingga kungga átuk. Málám songgo páyom bá árená káin wa árán angelo yá pinná tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kulá Jon táng it káto káin tit wata torong káin du Jesu yá Galili ále káin son kungga Ánutu yan pingnga álosim wa meng tárut tángga kuk. ");
INSERT INTO klt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Kulá rám bu áwek, Ánutu yan átkuku wu enanggon áwek. Pahán hurik tángga pingnga álosim wa narángga pahán sáni káin káto tingga átkuineráng!” ing yánuk. ");
INSERT INTO klt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kulá Jesu málám umi pátum Galili wata tákto kálu kungga kápuk ku Saimon yot kulaná Endru wu umben san umi pátum kinan han átnárán, náuta yándi wu káut iháhá ámna. ");
INSERT INTO klt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wa kápángga Jesu yá yánuk, “Áwáng nák nasurán du no sále ámna nangge iháháyan háleinemálák.” ");
INSERT INTO klt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wáina yánán waháranyon yándi wu umben yápmangga Jesu isutang kumálák. ");
INSERT INTO klt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Málám kimo hásák sim kungga kápuk ku Sebedi nanggená Jeims yot kulaná Jon du bot kinan umben yándi iháng toktolik tángga átnárán, ");
INSERT INTO klt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","málám kung ma táng husiuk ináku háng hánám mantáng yámán, nan yándi Sebedi san bot kinan ámna iháng yuwán áwuráng watyot árát, yándi wu Jesu isutang kumálák. ");
INSERT INTO klt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wahára átang gu it Kapaneam káin kung wakáin átang Sabat hára Jesu yá kungga miti itná kinan hangga Táwi yan me yánáng toliuk. ");
INSERT INTO klt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rám Jesu yá wa yánáng tolingga átuk wahára ámna náráwa wa narángga áturáng watá kangga hárámuturáng, náuta Jesu káuráng wawu ámna kutná pálak ká ina yánáng tolingga átuk, lo yan tiksa yá yánáng tolingngátaráng wáina muná. ");
INSERT INTO klt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Waháranyon ámna káman iruk wáik ká ep táená miti itná wata kinan yon átuk watá mantáuk, ");
INSERT INTO klt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesu Nasaret nan, rina táng námámáya áwelák? Kák ka nán hám náháng lem tátáya áwelák? Nák ku há naret kák ku wa ingga, kák ku káungá hánám Ánutu yan káinnan dá áwelák!” ");
INSERT INTO klt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wáina inán Jesu yá ing me táng muk, “Yolop átang ámna wa sangga hang!” ");
INSERT INTO klt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wáina inán iruk wáik watá ámna wa muwantang manná mantángga sangga hangga kuk. ");
INSERT INTO klt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wáina kangga ámna náráwa watá hárámutang yáni meme táuráng, “Náwu rina? Me náwu hurápmá hálángngá pálak! Iruk wáik me yánán watán milun suweráng,” ingga yáni miuráng. ");
INSERT INTO klt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kulá wata pingnganá watá sokmuná hánám Galili ále wa kung hilák táuk. ");
INSERT INTO klt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kulá rám miti itná wa sangga Saimon káling Endru yan it káin kuráng, wahára wu Jeims káling Jon du káman kuráng. ");
INSERT INTO klt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rám wahára wu Saimon silummá wu ilalák tángga sutná yá ángárángin kome káin átak ingga Jesu inát naruk. ");
INSERT INTO klt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wáina hálendu kung ketná hára tángga táng tárut tán, ilalák watá san náráwa málám sungngi tiyawing yámuk. ");
INSERT INTO klt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kulá yonyon kálu káe yá kung han it tá pup táuk kálu, ámna náráwa yá ilalák mara me iruk wáik ká ep ihená wa ihángga Jesu yan káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","It waháranan táup hánám watá áwáng it kálu mungnganá kálu tuwatang áturáng. ");
INSERT INTO klt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ámna náráwa táuppon áwát Jesu yá ilalák yáni hulá hulá wa iháng toliuk. Hang iruk wáik ká ep ihená wa táuppon yásut yámuk, iná iruk wáik ká kutná hiták meng tunggap tátá wa olet yáni máuk, náuta há naráng meráng wata. ");
INSERT INTO klt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hilápmá hánám it tá páyung átuk kálu Jesu yá tárutang it sangga ále rákit ore káman káin kung sáponga táuk. ");
INSERT INTO klt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Átang sim bu Saimon yot nuknukngá watá suling muráng. ");
INSERT INTO klt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yáni waku kung kangga sat warán du inuráng, “Kámuk hánám kák ka sulingga átaráng!” ");
INSERT INTO klt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wáina inát tu Jesu yá yánuk, “Wa sat nándá ku rehára kámá kunin — it kámá enang nákáin — náuta wakáin me pingnga hányon yáninet. Wata hánám bu no áwut.” ");
INSERT INTO klt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wáina mengga hangga Galili ále kinan átkungga miti itná kinan Táwi yan me pingnga yánángga, hang iruk wáik yásut yámángga kuk. ");
INSERT INTO klt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ámna káman ilalák lepra pálak watá áwáng tulá hára imángga hangga kiling muk, “Ko narátá álo hálendu neháng tolitá no Táwi rahálá hára rongrongngá hálin.” ");
INSERT INTO klt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ing inán Jesu málám pahán ukuro pálak ketná kálan kung tánggangga inuk, “No pahán kamet, rongronging!” ");
INSERT INTO klt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wáina inán waháranyon ilalák lepra watá san sutná yá rongrongiuk. ");
INSERT INTO klt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wáina tángga Jesu yá suring mán háná kuinán tán ing inuk, ");
INSERT INTO klt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kándáng narinelák, ko ni kámá káman ma inindalák, ináku kung sutya wa pris káman elengga ku Ánutu ya towet sing mámáya Moses yá ilalák ká álo hálen rina tátáya miuk wáina tátá ku kámá yá kahángga ku ilalákngá yá álo hálek ingga kahineráng.” ");
INSERT INTO klt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Enendu ámna watá kuk ngáyá kung me wa raták yánáng halingga kuk. Hulá wata ku Jesu yá itná itná áturáng watán káin raták kung áwáng tátá wawu muná, ináku ále rákit wakáin re átuk, enendu ámna náráwa wakáinnan wakáinnan watá watán káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rám kámá átang sangga Jesu yá it Kapaneam kinan son kung hen ámna náráwa yá wáina áwángga it káman da kinan átak ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wáina hálen táup hánám watá áwáng it pahálá kinan me kep káin wa áwáng tuwatang árát Jesu málám wahára Táwi yan me yánuk. ");
INSERT INTO klt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Waháranyon, ámna káman kuratná náut wawu erek kámut hálená wawu málám re áwáwáyan muná, wata ku ámna 4 yá sum tát kámuk áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Áwángga káuráng gu Jesu rupmá káin kung heheyan du muná náuta ámna náráwa yá kik hánám árát, áwáng it ketnán árángga kung it hungnganá yalingga wakálu kangkang pálak sat Jesu rupmá hára háuk. ");
INSERT INTO klt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wáina tát Jesu yá málámba naráng háting muráng wa kangga ku ket hárammá wáik wa inuk, “Nanggena, no mukmuroka wa yawondat.” ");
INSERT INTO klt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wáina inán lo yan tiksa kámá wahára áturáng watá kangga ku ing narángga átkiuráng, ");
INSERT INTO klt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Náuta ku ámna nátá wáina menggoek? Ánutu yan kome táin ingga hám tánggoek! Ámna káman dá kátu sasayan tárák kámá muná, Ánutu yá rewe ku wáina tátáyan.” ");
INSERT INTO klt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Waháranyon Jesu málám pahálá yá há naruk, pahán yáni káin wáina narángga átaráng ingga hálendu yánuk, “Náuta ku wáina naráng háteráng? ");
INSERT INTO klt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ilalák mara inánáyan du me rina ku tiyapmá hánám ininet? ‘Mukmuroka ku yawondat,’ me ‘Tárutang kangkangga tángga hangga kung’? ");
INSERT INTO klt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Enendu ing narineráng Ámna Nanggená watá káwak náta ketnán kátu sasa watán háláng tángga átak.” Wáina yánángga son ilalák mara wa inuk, ");
INSERT INTO klt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“No kanin, tárutang kangkangga tángga itya ya kung.” ");
INSERT INTO klt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wáina inán waháranyon málám tárutang kangkangngá tánggatang rahán yáni hára hangga kuk. Wa kangga kámuk hárámutang Ánutu kutná meng tárut tángga ing miuráng, “Tárák kámá ing ma hánám káumán!” ");
INSERT INTO klt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kulá son Jesu málám umi pátum tákto kálu kungga árán, ámna náráwa kik hánám watá áwát málám wahára Táwi yan me pingnga yánuk. ");
INSERT INTO klt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wahára átang son kungga káuk ku Liwai Alfius nanggená wu takis iháhá itná hára putung átnárán kangga ku inuk, “Áwángga nák nasulák,” Wáina inán Liwai málám tárutang isutang kuk. ");
INSERT INTO klt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kulá rám Jesu yá Liwai yan it káin kungga disaepelná yot sungngi nangga áturáng, wahára wu takis iháhá me “mukmuro mara” táup hánám Jesu isutang áwuráng watyot kámuk átang sungngi náuráng. ");
INSERT INTO klt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wahára tombong Farisi wata kinan nan lo yan tiksa watá kat Jesu yá takis iháhá me “mukmuro mara” watyot sungngi nangga árát, árong disaepelná wa yánuráng, “Náuta ku Jesu yá takis iháhá me mukmuro mara yot sungngi náeráng?” ");
INSERT INTO klt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wáina met Jesu yá narángga yánuk, “Ámna káman ilalákngá muná yá dokta yan káin ma kungngátak, ináku ilalákngá pálak watá ku dokta yan káin kungngátak. No áwut wawu ámna náráwa kándáng árená wa mantáng yámámáya ma áwut, ináku mukmuro mara wa mantáng yámámáya áwut.” ");
INSERT INTO klt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kulá rám káman Jon dán disaepel yot Farisi wu sungngi sangga árát, ámna náráwa kámá yá áwáng Jesu inuráng, “Jon dán disaepel yot Farisi yan disaepel yá ku sungngi sanggoeráng, iná kákkán du muná.” ");
INSERT INTO klt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wáina inát Jesu yá yánuk, “Ámna káman dá náráwa káman yot ket tántán tátáya átang nuknukngá men áwánggalát watá watyot átang sungngi álo sanggalát me muná? Wáina kámá ma árak. Rám ore watá watyot átgalát wahára wu herongnge átnát tán rám. ");
INSERT INTO klt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Iná rám káman áwinek wahára wu ámna ni náráwa tátáya táinek wa áwáng há tángga kuineráng, wahára wu wáina nuknukngá yá sungngi sanggalát. ");
INSERT INTO klt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hang káman dá lap kátu mirak táng kakngá ya hinangngá ma rákárenggim. Iná wáina tánggim wawu mirak watá kakngá wa uyin hinangngá maming táwi hálenggim. ");
INSERT INTO klt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hang káman dá wáin mirak wa táng meme kepmá kakngá hára ma kulinggim. Iná wáina tánggim wawu wáin mirak wata mulá yá meme kepmá wa ráráhánggim, wáina tán du yayará wáin yot meme kepmá wawu yáup yándi muná hálenggalán, wáina wata ku wáin mirak wawu meme kepmá mirak háranyon kukuliyan.” ");
INSERT INTO klt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Rám káman Sabat hára Jesu yá disaepelná yot yáni waku wit hái orek yáni kálu kunggatang disaepelná yá wit páliná wa kámá kátungga ihuráng. ");
INSERT INTO klt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kulá Farisi yá wa kápángga Jesu inuráng, “Kang, náuta ku disaepelka yá Sabat hára kálu wáina ma tátáya mená wa táeráng?” ");
INSERT INTO klt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wáina met narángga Jesu yá yánuk, “Sán kámá Devit tá tombongngá yot háing yámán táuráng wa sángingngátaráng me muná? ");
INSERT INTO klt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pris táwi yáni kutná Abiata watán rám hára Devit málám kung Ánutu yan it kinan hang, másáng horengga Ánutu yan tit káungá hánám hálená wa pris káman inán másáng wa imán náuk, wawu kálu hitik táuk, pris yá re nanaya mená wa, kámá iháng imán tombongngá yámángga náuráng. Devit tá wáina táuk, enendu Táwi yá kandák táelák ingga ma inuk.” ");
INSERT INTO klt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Waháranyon ing yánuk, “Ánutu yá ámna nangge háláng yáyámáya Sabat táng tunggap táuk; ámna nangge yá Sabat háláng imámáya ma táng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wata ku Ámna Nanggená wawu Táwi, Sabat tán hányon.” ");
INSERT INTO klt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Rám káman Jesu yá kung miti itná kinan háuk, wahára wu ámna káman ketná kámurená wakáin hányon árán, ");
INSERT INTO klt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ámna kátu wu Jesu yá tárák rina tán kangga táng me hára tinin ingga áwáng áturáng, wáina hálendu Sabat hára ná ámna wa táng tolin kanin ingga kangga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kulá Jesu málám ámna ketná kámurená wa inuk, “Wa átaráng wata kondon yáni hára wa hetang álák.” ");
INSERT INTO klt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wáina inángga son wahára áturáng ngá wa yánuk, “Retá ku Sabat hára kálu kándáng hálek, álosim táinemán me wáik táinemán? Háláng yámámá me ráháng kámut tátá?” Wáina yánán wahára áturáng watá náng ingmen áturáng. ");
INSERT INTO klt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Málám kuk hánám kárek hálengga pahán yáni káto wa kangga pahálá márawin ámna wa inuk, “Ketya wa uying ráng táng.” Ing inán ketná uying ráng tán ketná yá álosim háliuk. ");
INSERT INTO klt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kulá waháranyon Farisi yáni waku hangga kungga Herot tán tombong kápángga Jesu utkámut tátáya me hulátingga hároturáng. ");
INSERT INTO klt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu málám disaepelná yot hangga umi pátum káin kut ále Galili nan ámna náráwa urum táwi watá yásutang kuráng. ");
INSERT INTO klt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Wáina wáina tánggoek ingga naruráng hára wu ámna náráwa táup táwi hánám ále Judia kálu, it yáilá Jerusalem kálu, ále Idumea kálu, me umi Jodan numkálu, hang it yáilá Tair me it yáilá Saidon kálu nan dá Jesu yan káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ámna náráwa yá kik hánám hálen kome muná kangga disaepelná yánuk, “Bot káman tiyawing namániráng, náuta ámna náráwa yá neháng kik pásinirot.” ");
INSERT INTO klt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Táup hánám há iháng toliuk hálen, ilalák pálak watá há tángganin ingga málám hára re seng inisurán tángga áwáng kik hánám áturáng. ");
INSERT INTO klt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Rám iruk wáik ká kanggiuráng hára wu iháng hang kondolá hára kátingga ing mantánggiuráng, “Kák ku Ánutu Nanggená!” ");
INSERT INTO klt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ing menggiuráng, enendu me káto mengga yánánggiuk, “Nák ku wa ingga ma meindaráng.” ");
INSERT INTO klt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Rám káman Jesu málám ále yáilá káin áráng átang málámbá niya narek wa mantáng yámán málámbán káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Málám ámna 12 iháng tunggap tángga kut aposel yámángga yánuk, “Sán du nákkot átneráng. Rám kámá wu suring sáme Táwi yan me wa yánángga átningguineráng, ");
INSERT INTO klt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","me háláng tángga iruk wáik wa yásut kuineráng.” ");
INSERT INTO klt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ámna 12 iháng tunggap táuk wawu: Saimon, Jesu yá kut nukngá Pita imuk wa, ");
INSERT INTO klt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hang Jeims wu Sebedi nanggená hang kulaná Jon (yarán wawu Boanerges ing mantáng yámuk wawu wata hulá wu punam bá ina táinemálák), ");
INSERT INTO klt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","hang Endru, Filip, Batolomiu, Matyu, Tomas hang Jeims Alfius nanggená, Tadius hang Saimon wawu tombong káman kutná Selot waháranan, ");
INSERT INTO klt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hang Judas Iskariot, wawu ámna niyá Jesu táng káyam ket yáni hára tiuk wa. ");
INSERT INTO klt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesu málám it káman da kinan kung hang átnárán, ámna náráwa kik táwi watá son áwáng hiuráng, wáina hálendu málám disaepelná yot yáni re átang sungngi yáni nanayan du muná. ");
INSERT INTO klt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wáina tát Jesu sipmá kátu yá wa naruráng hára wu “Ámna wawu hohek, wata ku kung engotang áwánin,” ing mengga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hang lo yan tiksa Jerusalem kálu átang háuráng watá ing miuráng, “Iruk wáik yáin yáni, Belsebul, watá ep tán tánggoek, hang watán háláng hára kungga nuknukngá wa yásutkoek.” ");
INSERT INTO klt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wáina mengga árát tu Jesu yá mantáng yámán áwát me tárák hára yánuk, “Rina tángga ku Satan dá Satan isurán kuinek? ");
INSERT INTO klt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Káwak káman hára árená yá yáni yon honhoren tánggalát wawu káwak watá kándáng ma átgim. ");
INSERT INTO klt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hang amba káman hára árená yá yáni yon honhoren tánggalát wawu amba watá kándáng ma átgim. ");
INSERT INTO klt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hang Satan dán tombong gá yáni yon honhoren tánggalát wawu kándáng ma átgalát, tombong wawu há sáliknginggim. ");
INSERT INTO klt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iná ámna káman dá ámna hánghálángngá yan it kinan raták kung hang kutná kutná wakáin ma ihángga kunggim, ináku ámna hánghálángngá wa kálak ket hárammá hárotang tingga ku wáina álo tánggim. ");
INSERT INTO klt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","No pálipuk hánám ing sánin, Táwi yá ámna yan mukmuro me sárum meme táená wawu álo yawon yáminek. ");
INSERT INTO klt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iná káman dá Iruk Káungá wata sárum meme táinek wawu kátuná wa ma sáindák, márapmá ná wawu rámá rámá átang kuinek.” ");
INSERT INTO klt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ámna wawu iruk wáik ká watyot átkoek,” ing miuráng wata ku wa yánuk. ");
INSERT INTO klt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kulá Jesu maming got yakukula watá áwáng kep káin átang ámna káman suring mát kung it kinan Jesu inán áwáng kep káin kápápáya kung han, ");
INSERT INTO klt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ámna náráwa kik táwi áwálák áturáng watá inuráng, “Mamya yot yakukulaka wu kák ka sulingga áwáng kep káin átaráng.” ");
INSERT INTO klt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ing inát watá miuk, “Mamna me yakukulana wu ni?” ");
INSERT INTO klt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wáina mengga áwálák háleng sulingga wahára putung áturáng wa yánuk, “Kaniráng! Nahára átaráng sándu mamna me yakukulana! ");
INSERT INTO klt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Niyá Ánutu yan me isutang átningguinek wawu nák yakukulana me yit ilomna me mam ilomna.” ");
INSERT INTO klt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Son Jesu yá umi pátum tákto káin átang Táwi yan me yánáng tolingga átnárán ámna náráwa yá áwáng táup hánám tuwarát kápángga bot káman umi ketnán átuk wata ketnán Jesu yá áráng putung árán ámna náráwa yá áwáng umi pátum tákto káin áturáng. ");
INSERT INTO klt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Málám me wa táwi hánám tárák hára tingga yánáng tolingga kungga átang yánuk, ");
INSERT INTO klt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sándá narániráng! Ámna káman dá iritná táulá halin ingga kuk. ");
INSERT INTO klt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Málám halingga kungngárán kámá yá kálu hára hat, iráp pá áwáng erek nang háliuráng. ");
INSERT INTO klt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iná kámá yá ále sup kárák hára háuráng watá ku sopmuná hánám áráng hiuráng náuta kung káwak kinan ma háuráng. ");
INSERT INTO klt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kulá káe yá háliuk wahára wu kápán há roningga háuráng, náuta ráhun yáni muná wata. ");
INSERT INTO klt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Táulá kámá yá wu ále uran kánggárángngá kinan kung háuráng hálendu áruráng, enendu árángga pálin yáni sásáyan tárák ku muná, náuta uran kánggárángngá watá iháng usuk. ");
INSERT INTO klt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hang táulá kámá yá ku káwak álosim hára háuráng hálendu áráng hengga pálin yáni álo kámá hánám wa sángga áturáng. Kámá yá pálin yáni táwi simsim tit, kámá yá tátáwi tit, kulá kámá yá ku maming tátáwi hánám tiuráng.” ");
INSERT INTO klt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hang Jesu yá ing yánuk, “Káman ni kárámanná pálak hálendu watá me ná narinek.” ");
INSERT INTO klt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kulá ámna náráwa yá erek kung háliuráng, wahára wu disaepelná 12 watyot kámá rupmá tangtang áturáng watá me tárákngá yánuk wata hulá ya ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Ináng sulit tu yánuk, “Kámá kep káin átaráng wawu me tárákngá kálu re yánáná wáina hálendu ‘rendá rahán yáni hálengga átneráng enendu páliná wu ma káindáráng, me rendá narineráng enendu wata hulá hánám bu wáina ingga ma narindáráng. Wáina tángga átninggan pahán yáni hurik tát Táwi yá kátu yáni saiwon.’ Iná sáni wu Ánutu yan átkuku watán me kilakngá wata hulá hánám wawu Ánutu yá sán há sáliuk.” ");
INSERT INTO klt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Son Jesu yá ing yánuk, “Sándu me tárákngá náwu ma naráráng me rina? Rina tángga wu me tárákngá nukngá wata hulá wa narineráng? ");
INSERT INTO klt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ámna káman dá irit táulá halingngátak wawu káwak náta ketnán Táwi yan me halingngátak. ");
INSERT INTO klt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ámna kámá wu irit táulá yá kálu hára hangngátaráng wáina, rám Táwi yan me narángngátaráng waháranyon du Satan dá áwáng me narángngátaráng wa táng hirarán kung yámángngátak. ");
INSERT INTO klt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iná kámá wu irit táulá yá sup kárák hára hangngátaráng wáina, Táwi yan me wa narángga sopmuná hánám tángga wata herongnge hánám tángngátaráng, ");
INSERT INTO klt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","enendu ráhun yáni ma koená wata tángga wu rám hátetná kimo re átnárát márapmá me tárák wáik rina rina yá Táwi ya naráng háting meráng wakálu áwángngátak, wahára wu sopmuná hánám naráng hákhátik yáni sangngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hang kámá wu irit táulá yá ále uran kánggárángngá hára hangngátaráng wáina Táwi yan me wa há narángngátaráng, ");
INSERT INTO klt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","enendu káwak kán kutná kutná wata narángpak tángngátaráng, me kikiná hulá hulá watá yángyárungngingngátak, me kutná kutná kápáng narángngátaráng. Watá iháng usán Táwi yan me watá páliná ma sángngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iná kámá wu irit táulá káwak álosim hára hangngátaráng wáina, wata tángga Táwi yan me wa narángga tángga páliná sángngátaráng wawu kámá yá pálin yáni táwi simsim tit, kámá yá tátáwi tit, kulá kámá yá ku maming hánám tátáwi tingngátaráng.” ");
INSERT INTO klt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu yá ing yánuk, “Káman dá lam kasingga tángga áwánggim wawa baket kinan káin me tebol tárang káin hám tinggim? Wáina muná. Ináku tebol ketnán tinggim watá ku álo. ");
INSERT INTO klt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Me kámá tum táená wawu hiták háleineráng, hang me kámá kilak átaráng wawu hiták meng tunggap táineráng. ");
INSERT INTO klt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Káman dá me nanaráyan kárámanná pálak hálendu watá me ná narinek.” ");
INSERT INTO klt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Waháranyon sengsáráp tingga ku ing miuk, “Me rina nareráng wa kándáng hánám wa naráng hátingga átneráng. Tárák rina tánggoeráng wawu Ánutu yá wáinanyon táng sámángga, wata ketnán nukngá sengsáráp táng sáminek. ");
INSERT INTO klt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Káman niyá me páliná watá átmek hálendu Ánutu yá wata ketnán nukngá yot tingga iminek. Iná káman niyá me páliná wa ma átmák hálen wawu isikimo rina átmek watyot imáng hutang ihinek.” ");
INSERT INTO klt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hang ing hányon yánuk, “Ánutu yan átkuku wawu ing ina: ámna káman dá irit táulá káwak káin halingga sangga, ");
INSERT INTO klt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","yáungán ruhinek me káen sengsulingga átkuinek, wahára rina rina áráng hengga árángga átaráng wawu ma narángngátak. ");
INSERT INTO klt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Káwak málámbáyon du muk yámán árángngátaráng, hulátingga murán yáni, hang yumin yáni, hang yumin yáni kinan du pálin yáni tingngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Áráng hengga kungga pálin yáni sángga álikngingga árát tu pálin yáni mamaráyan rám hálengngátak, wahára wu márumá yá áwángga marángga ihángngátak.” ");
INSERT INTO klt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Son Jesu yá yánuk, “Ánutu yan átkuku wata wu náut ina ingga mengga sáninet, me tárák ku náut hára mengga sáninet? ");
INSERT INTO klt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ánutu yan átkuku wawu mastet táulá ina isik hánám kimo káwak kinan halingngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Enendu rám watá áráng hengga tihangngátak wahára wu hái káin kutná kutná hená wa iháng hátingga maming táwi hánám wa tihangngátak. Ketná palá tingga árán alek káin iráp pá kahetang áwáng wahára tángga sek narángga yongnga ya átnándaráng.” ");
INSERT INTO klt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rám máro yon Jesu yá Táwi yan me wa tárákngá wáina re tárák hára yánuk. Watá nanará yáni káin álo nanaráyan kálu wahára yánánggiuk. ");
INSERT INTO klt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Málám me kámuk yánánggiuk wawu tárák hára re tingga yánánggiuk, iná máriya málám re disaepelná yot átang wahára ku wáina wáina ingga hulá yot kándáng hánám yánáng tolinggiuk. ");
INSERT INTO klt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Rám wahára it tá yonyonlingga áwán du Jesu yá disaepelná yánuk, “Umi pátum tákto numkálu kunin,” ");
INSERT INTO klt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ing yánán disaepel yá Jesu yá bot átuk wata kinan re áráng árát ámna náráwa káwan táwi wa yápmangga kuráng, waháranyon bot kámá watyot hányon kuráng. ");
INSERT INTO klt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kungga átnárát, iruk maming táwi yá tán umi pátum punggilá yá hilák singga bot ketnán hanghang tángga árát, bot tá hála umi pátum kinan háin ingga tángga átuk. ");
INSERT INTO klt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kulá Jesu wu bot yangngá káin miung ketnán ruhángga árán disaepelná yá táng mirak tángga inuráng, “Tiksa, náni ya urák náni wa naránggoelák me? Hang suwindemán!” ");
INSERT INTO klt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wáina inát, málám tárutang iruk wa me táng mángga umi pátum punggilá wa yánuk, “Kilak! Yolop hánám átniráng!” Wáina yánán iruk ká san umi yá láláwingga hánám wa átuk. ");
INSERT INTO klt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kulá hang disaepelná wa yánuk, “Náuta ku pitánggoeráng? Sánda naráng hákhátik sáni wa muná hánám puk me?” ");
INSERT INTO klt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wáina yánán, yáni waku hárámutang pikpito narángga yáni meme táuráng, “Náwu ni? Iruk kot umi pátum punggilá yá watán me naránggoeráng náwu!” ");
INSERT INTO klt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu yá disaepelná yot Galili umi pátum wa hitik tángga Gerasen ále káin kung hengga, ");
INSERT INTO klt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","rám Jesu yá bot sangga háuk waháranyon ámna káman iruk wáik ká ep táená watá tanggán káin átang kakaya áwáng hiuk. ");
INSERT INTO klt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ámna wawu tanggán káin átnándak, wahára ámna káman dá ámna wa háthárot tán tárák ku muná, sen dá enendu muná yon. ");
INSERT INTO klt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Rám kámá sen dá ket hárammá káto hárotnándaráng, enendu sen uying rákrákit tángngátak. Káman dá hálángngá táng hang titiyan du muná. ");
INSERT INTO klt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rámá rámá káen me yáungán wawu ále yáilá káin tanggán dá átak wakáin re átang huhumenman pálak málámbáyon sutná sutná wa sup pá marángngátak. ");
INSERT INTO klt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Málám mulangán káin átang Jesu kangga hururung ingmen kung kondolá hára tulá hára imángga han, ");
INSERT INTO klt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesu yá inuk, “Iruk wáik, ámna wa sangga hang!” Wáina inán narángga hahatingga ingmen ing mantáuk, “Jesu, Ánutu Árená Hánám wata Nanggená, rina táng namindelák? Ma keháng lem táindát ingga Ánutu rahálá hára nanáng!” ");
INSERT INTO klt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ing inán Jesu yá inuk, “Kutya ku ni?” Ing inán, watá miuk, “Nák ku iruk wáik tombong hásák wata táwi yáni ya átnándat, wáina wata ku kutna wu Tombong Hásák.” ");
INSERT INTO klt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wáina inángga ále nahára ma násutnándalák ingga kiling muk. ");
INSERT INTO klt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Put urum táwi káman du ále yáilá isikimo wata álatná kálu enang waháranyon sungngi nangga árát. ");
INSERT INTO klt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kulá iruk wáik watá Jesu kiling muráng, “Suring námátá put wa átaráng wata kinan kung hanin.” ");
INSERT INTO klt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wáina ing met, Jesu yá álo ingga yánán iruk wáik watá ámna waháranan áráng hengga kung put wa áturáng wata kinan háuráng. Put káwan táwi wata sale yáni wu 2000 watá hururung ingmen ámuta re hangga umi máta porá isikimo hára hitangga kung umi pátum kinan hangga umi nangga kámuturáng. ");
INSERT INTO klt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wáina tát, ámna put wa pin yáni táená watá wa kangga pitángga kungga pingnga wa it kinan me ále wata kátu káin yánát ámna náráwa yá rina tunggafek ingga kakaya kuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Rám ámna náráwa yá Jesu yá átuk káin wa áwángga káuráng gu ámna iruk wáik ká ep táená táng toliuk wawu sutná kándáng tánggánengga, nanaráná yá kándáng hálen, wahára putung árán, kangga pitáuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kulá rendá wahára átang rahán yáni yá káuráng watá wu ámna iruk wáik ká ep táená wawu wáina wáina ingga áwuráng wa yánuráng, hang put tu wáina táeráng ingga hányon yánuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kulá me pingnga wa narángga ámna náráwa yá ále ná sangga kung ingga sonson Jesu yolopon kiling muráng. ");
INSERT INTO klt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kulá Jesu málám bot ketnán áruk wahára wu ámna iruk wáik ká ep táená táng toliuk watá káman kunin ingga Jesu kiling muk. ");
INSERT INTO klt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Enendu Jesu yá álo ingga ma inuk, ináku ing inuk, “Itya káin kung sipya kátu Táwi yá urákka narángga kutná táwi rina táng kamek wa wáina ingga yáninelák.” ");
INSERT INTO klt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wáina inán du ámna watá kung Dekapolis ále káin wáina ingga Jesu yá kutná táwi rina táng muk wa yánángga kun ámna náráwa yá wa narángga ikik hárámuturáng. ");
INSERT INTO klt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Rám Jesu yá bot ketnán umi pátum wa son hitik tángga kung numkálu átuk, wahára ámna náráwa yá kik hánám wa áwáng áwálák táuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wáina tát átnárán, miti itná yan ámna yáilá káman kutná Jairus watá áwáng Jesu kangga tulá hára imángga hangga ");
INSERT INTO klt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","inángga pahálá yot hánám kiling muk, “Uriwana máto yá kámutnándek. Ko áwáng ketya yá tánggatá álo hálengga tárutang há átnek.” ");
INSERT INTO klt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wáina inán du Jesu yá watyot kun, ámna náráwa táwi hánám watá isutang kungga uying kákkárik táng mángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kulá náráwa káman wahára átuk wawu yara 12 wata kinan yipitná ya rámá rámá kungga rewe átnándak. ");
INSERT INTO klt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Málám dokta máro hánám watán káin kun háláng imánin ingga tángngátaráng, enendu sut láwit táwi hánám imángngátaráng, me supmá kámuk hánám sáuk, enendu ilalákngá yá álo hálená ina ku ilalák watá táwi hánám wa hálengga átnándak. ");
INSERT INTO klt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Málám Jesu yá wáina wáina tángngátak ingga met narángga ku, sárumá ya káwan táwi kungga áturáng wata kinan kung lapmá hásák hára wa tánggáuk, ");
INSERT INTO klt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","náuta, “Na hánámá lapmá hásák káin tánggáinet wawu há álo háleinet,” ingga narángga átuk wata. ");
INSERT INTO klt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Waháranyon hánám sip pá hangga átnándak watá sálikngin málám sutná káin naruk ku sutná márawingga átnándak watá pukon sálikngingga kun, ");
INSERT INTO klt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","waháranyon Jesu yá naruk ku hálángngá kátu yá sangga kun málám hurik tángga kik táwi kunggaturáng wa yánuk, “Niyá nákkán lap tánggaek?” ");
INSERT INTO klt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ing men disaepelná yá inuráng, “Kang, ámna náráwa kik hánám keháng rosingga koeráng, enendu ko ku melák, ‘Niyá nehánggaek?’ ingga melák.” ");
INSERT INTO klt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wáina inuráng, enendu Jesu málám emá re niyá nehánggaek ingga áwálák hálengga kuk. ");
INSERT INTO klt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jesu yá wáina tán kangga náráwa ni ilalákngá yá álo hálen naruk, málám pitángga yángyáng pálak áwáng hárammá hulá hára turingga hangga wáina wu pálipuk ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wáina wáina ingga inán Jesu yá inuk, “Uriwana, naráng hákhátikka watá keháng tolek. Pahán láláp hára kuinelák, iná ilalák wawu pukon kepmáek.” ");
INSERT INTO klt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu yá wa inángga emá me tángga átnárán, ámna kámá miti itná yan ámna yáilá watán it káinnan dá áwáng inuráng, “Uriwaka wawu há kámutak. Márapmá watyot tiksa ma imindalák.” ");
INSERT INTO klt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wáina inát Jesu málám watán me wa kárámatingga há naruk, enendu ámna yáilá wa inuk, “Ma narángpak táindalák, ináku naráng hákhátik hára káto átnelák.” ");
INSERT INTO klt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wáina inángga málám yánán kámá yá ma isutang kuráng, ináku Pita, Jeims hang Jon, Jeims kulaná, watyot re kuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yáni wu rám miti itná yan ámna yáilá watán it káin kung hengga Jesu yá kápuk ku huhumenman tángga kutkáyawát wa irawa hára ingmen tánggarát. ");
INSERT INTO klt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Málám kung it kinan hangga yánuk, “Náuta wu kut me huhumenman ná tángga átkoeráng? Nangge náwu ma kámurak, ináku ruhángga átak.” ");
INSERT INTO klt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wáina yánán watá yut mángga árát málám yánán erek ingmen kep káin hat, naning maming got disaepelná káman áturáng wa ihángga nangge ting sat átuk wakáin kung háuráng. ");
INSERT INTO klt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Málám hang nangge wata ketná hára tángga inuk, “Talita kum” (wawu ing “Náráwa kimo, no kanet ‘Tárulák!’”). ");
INSERT INTO klt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Waháranyon hánám náráwa máto watá tárutang kung áwáng tán kangga ikik hánám hárámuturáng. Náráwa kimo wawu yaraná wu 12. ");
INSERT INTO klt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Waháranyon málám sungngi kámá imát náik ingga yánángga ku kungga kámá wáina táek ingga ma yáyánáya olet yáni máuk. ");
INSERT INTO klt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kulá Jesu málám rehára átuk wa sangga itná hulá káin disaepelná watyot kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rám Sabat tá áwáng hiuk hára wu miti itná káin Táwi yan me yánáng tolingga árán, urum táwi wa narángga áturáng wata kinan máro hánám bá yon hárámutang me keke ing miuráng, “Ámna nátá nanará wawu rekáinnan ihuk? Nanará álosim náwu niyá imuk ngáya tángga tárák hulá hulá wa hányon tánggoek? ");
INSERT INTO klt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Náwu kapenda me náut? Náwu Maria nanggená Jeims, Josep, Judas hang Saimon wata tat yáni me rina? Hang yitná ilommá nahára nányot há átnándamán.” Wáina mengga kuk táng mángga watán me wa pálipuk ingga ma naruráng. ");
INSERT INTO klt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wáina met Jesu yá yánuk, “It yáni hulá me málámbán hun kinan me málámbán itná pahálá kinan rewe ku profet tu kut yáni árená muná.” ");
INSERT INTO klt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Jesu málám naráng hákhátik yáni muná wa kangga hárámutuk, wata ku málám wahára ket tárák kámá táwi sim ma táuk, ináku ilalák mara yarákimo wahára ketná yá ihánggápán álo háliuráng wa rewe. Wáina tángga Jesu málám itná itná kungga Táwi yan me wa yánáng tolingga átkuk. ");
INSERT INTO klt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Málám disaepelná 12 wa mantáng yámán áwát, iruk wáik yásusut watán háláng wa yámángga yará yará suring yámán kukuya ing yánuk, ");
INSERT INTO klt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Náut kámá káman kálu watán ma ihindaráng ináku to rewe ihineráng. Másáng ma ihindaráng, yák ma ihindaráng me sup kámá tumá kinan árát ma ihindaráng. ");
INSERT INTO klt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sendol re moneráng, iná sut tátámot tán hánámá kámá ma ihindaráng. ");
INSERT INTO klt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","It rehára ruhineráng watá wahára re átang kungga it kapme wa sáineráng. ");
INSERT INTO klt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iná it káman dá herongnge ma táng sámángga ma sáhená yan tárák árát, me sándán me ma narát, wawu háram sáni káin káwak káhumá wa káting halit wahára han du kuineráng, watá ku watyot me yá átak háleinek,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kulá disaepel watá hangga kungga pahán hurik táineráng ingga ámna náráwa yánángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yáni waku iruk wáik táuppon yásut yámángga ilalák mara táuppon oel kulingga kuháng yámángga ku ilalák yáni háranan iháng tárut tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kulá Jesu kutná yá táwi hánám hálengga kungga árán du King Herot tá rina rina tunggafengga átuk wa naruk. Kátu kámá yá wu ing mengga kunggarát, “Jon Umi Kuháng Yámámá kámutuk watá son hám tárutuk wáina hálendu ket tárák hulá hulá tátáyan háláng wawu wahára átak.” ");
INSERT INTO klt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kulá kátu kámá yá wawu Elaija ingga menggaturáng, iná kátu kámá yá wu profet uláp hánám átkiuráng waháranan ina ingga menggaturáng. ");
INSERT INTO klt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Iná Herot tá ku wa narángga wu ing miuk, “No yáne Jon salá maruráng watá son tárutuk!” ");
INSERT INTO klt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jon wawu huphuráp Herot málámbá yánán kung ket tángga hárotang táng it káto kinan tiuráng. Wa táuk wawu náuta kulaná Filip áwáná Herodias wa Herot tá áwáná ya tán, ");
INSERT INTO klt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","wata ingga ku Jon dá ing mengga sonson tángga árán, “Herot ko kulakka áwáná áwáka ya táulák wawu kandák.” ");
INSERT INTO klt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wáina inángga sonson tángga áwán du Herodias yá pahálá kuk hánám naráng mángga áwánggiuk, enendu utkámut tátáyan kálu kámá ma tunggafenggiuk, ");
INSERT INTO klt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","náuta Herot tá Jon da naráng mánggiuk wawu ámna kándáng rongrongngá, wata ku Jon da hányon pitáng mángga kándáng hánám pinná tánggiuk. Rám Herot tá Jon dán me naránggiuk hára wu naráng yakyawák tángga narángpak hánám tánggiuk, enendu son Jon dán me nanará ya wu kikiná naránggiuk. ");
INSERT INTO klt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pukon da ku Herodias yan rám álosim káman dá áwuk wawu Herot tá tunggafiuk watán rám. Wata ku umi sinak maming táwi tátáya kapman dán ámna yáin yáni me tewe ámna yáin yáni watyot ále Galili yan ámna yáilá wa iháng uyiuk. ");
INSERT INTO klt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Rám wata kinan du Herodias uriwa yá áwáng rahán yáni hára wa táit pánáp tángga árán Herot yot ámna hulá hulá watá kangga álosim naruráng. Wáina hálendu king gá náráwa wa inuk, “Ko náuta kámá narángga naninelák wawu no há hánám kaminet.” ");
INSERT INTO klt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ing inángga me káto hánám mengga miuk, “Pálipuk hánám ko náuta narángga naninelák wawu no há kaminet wata tárákngá ku ále káwak no pinna táet wa huk tángga numkálu kamánggem wáina.” ");
INSERT INTO klt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wáina inán náráwa málám hangga kuk ngáyá kung maming inuk, “Náut nanamáya ininet?” Ing inán maming gá inuk, “‘Jon Umi Kuháng Yámámá wata yáilá ya naret,’ ingga ininelák.” ");
INSERT INTO klt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wáina inán náráwa málám sokmuná hánám son kung king inuk, “Nák ku ko kula pálik hánám nahára Jon Umi Kuháng Yámámá wata yáilá wa tera hára tingga táng áwáng naminelák ka naret.” ");
INSERT INTO klt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wáina inán king gá narángpak táwi hánám táuk, enendu me káto hánám mengga inuk me ámna yáilá sungngi nanaya áwuráng wata rahán yáni hára hálendu milunná ma yaliuk. ");
INSERT INTO klt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ináku waháranyon yáup ámnaná suring mán Jon yáilá tángga áwáwáya kuk. Ámna watá kung Jon it káto káin átuk wakáin salá ták marángga ");
INSERT INTO klt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","táng tera hára tingga táng áwáng náráwa wa imán watá táng kung maming imuk. ");
INSERT INTO klt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wa narángga Jon dán disaepel yá áwáng tambun wa táng kung tanggán káin usuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel kuráng watá átkut sálin áwáng Jesu rupmá áwálák átang wáina wáina táumán me wáina yánáng toliumán ingga erek ingmen inuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Rám ore waháranyon du ámna náráwa watá táup hánám kung áwáng tángga árát tu Jesu yá aposelná yot sungngi yáni nanayan tárák muná hálendu yánuk, “Sáni re hánám áwát nákkot kungga ále rákit kangga wakáin sek naránin.” ");
INSERT INTO klt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ing yánángga yáni re hánám bot hára árángga ále rákit káman káin kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Enendu táup hánám bá há kápuráng wáina hálendu wakáin koeráng ingga há narángga it ále ore wakáinnan watá háram kálu hururung ingmen watá kálak kung hiuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu yá kung hengga kápuk ku ámna náráwa táup hánám watá árát kápángga urák yáni naruk, náuta sipsip márum yáni muná ina hálendu málám Táwi yan me táwi hánám wa yánáng toliuk. ");
INSERT INTO klt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kulá it tá há yonyon tin kangga disaepelná yá áwáng inuráng, “Nákáin du ále páliná muná káin átnáne há yonyon tek. ");
INSERT INTO klt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wáina wata ku ámna náráwa álo suring yámátá it kámá káin há yáni kungga sungngi yáni kangga yungga nanggalát me?” ");
INSERT INTO klt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ingga inát Jesu yá yánuk, “Náut kámá nanayan wawu sáni kangga yámineráng.” Ing men watá inuráng, “Ámna káman dá yáup yap 8 tángga sup ihángngátak, wáina watá ku álo kung másáng yungga yámátne nanggalát.” ");
INSERT INTO klt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ing met Jesu yá yánuk, “Másáng tum pa rina tá átaráng ingga kaniráng.” Ing men kungga kangga ku inuráng, “Másáng tum 5 hang káut yará yá átaráng.” ");
INSERT INTO klt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wáina inát tu Jesu yá yánán ámna náráwa wa disaepel yá iháng urum kámá kámá tit kepang álo kámá hára wa putung háuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kulá putung áturáng wawu urum kámá 50 kámá 100 wáina wáina re áturáng. ");
INSERT INTO klt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wáina árát Jesu málám másáng tum 5 watyot káut yará wa ihángga átang alek kálu hálengga Táwi yan káin sáponga tángga másáng wa hikhuk tángga iháng disaepelná yámán ámna náráwa ya ting yámángga kut, málám káut yará wa wáinanyon tángga yámán kámuk ting yámángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wa yámát nangga kámuk hánám kawin yáni hahatin, ");
INSERT INTO klt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","disaepel yá másáng me káut káhumá áturáng wa iháng rápmám 12 wa tuwat hánám monduráng. ");
INSERT INTO klt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iná ámna náráwa sungngi wa náuráng wata sale yáni wu táup hánám, iná 5,000 wawu ámna sale yáni re. ");
INSERT INTO klt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kulá waháranyon Jesu yá disaepelná sokmuná kuniráng ingga suring yámán watá kálak umi pátum numkálu it Betsaida káin kukuya bot ketnán árángga kut, málám ámna náráwa urum wa yánán sansan tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Watá kung hálit kápángga málám ále yáilá álatná káin sáponga tátáya áruk. ");
INSERT INTO klt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rám it tá pup táuk wakálu ku bot tá umi pátum táitná káin kunggatuk, iná Jesu yá ku málám re ále yáilá káin há átuk. ");
INSERT INTO klt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Málám hálengga kápuk ku iruk maming táwi hánám hásingga árán du disaepelná yá pul tángga kukuya iháng husingga árát. It háiháiya kálu málám umi ketnán yángyáreng iháng hátin ingga tángngárán du, ");
INSERT INTO klt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","disaepelná yá hálengga káuráng gu umi ketnán tangtareng áwángga árán yáni wu kangga utni ingga ohok táuráng, ");
INSERT INTO klt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","náuta disaepel kámuk kangga pikpito hánám naruráng, enendu waháranyon ing yánuk, “Káto háleineráng! Náwu na áwet. Ma pitáindaráng.” ");
INSERT INTO klt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wáina yánángga málám árángga bot ketnán káin kun waháranyon iruk watá sangga hang náng ingmen árán kangga ikik hánám hárámuturáng, ");
INSERT INTO klt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","náuta nanará yáni yá kándáng ma naráng rákit táuráng hálendu másáng gá sambe tiuk wata wu manyon naráng hátiuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kulá yáni wu umi pátum wa hitik tángga Genesaret káin kung hengga bot wa wahára puting sat átuk. ");
INSERT INTO klt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kulá bot káinnan dá sangga káwak káin háuráng waháranyon ámna náráwa yá Jesu kangga há naráng hátiuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wáina hálendu yáni waku hururung ingmen it yáni it yáni kungga ilalák mara wa iháng kangkang hára tingga ihánggatang Jesu yá rehára átak wa nangnaráng wakáin kunggiuráng. ");
INSERT INTO klt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hang ále rehára rehára kunggiuk wahára wu itná itná kámuk it yáilá me it nanggená waháranan dá ilalák mara iháng áwáng urum komená yáni hára tingting tánggiuráng. Wáina ting sat árán du kiling mát tu álo san watá lapmá ilungngá re kimo tánggagaya, iná niyá wáina há tángganggiuráng wawu há álo hálenggiuráng. ");
INSERT INTO klt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Rám káman Farisi yot lo yan tiksa yá Jerusalem káin átang áwuráng watá áwáng Jesu kang áwálák tángga ");
INSERT INTO klt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","kápuráng gu Jesu yan disaepel kátu yá ket yáni kálak ma yawolená sungngi nangga árát. ");
INSERT INTO klt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi me Juda kámuk wawu tátáwi yáni yan kálu káman wáina isutnándaráng wawu ing, rámá rámá ket yáni kálak yawondang gu sungngi nangngátaráng, iná ket yáni ma yawolená sungngi ma nangngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rám maket komená sangga it káin áwángngátaráng hára wawu áwáng ket yáni kálak yawondang gu sungngi nangngátaráng, me tátáwi yáni yan kálu hulá hulá isurená wa isutnándaráng. Kálu káman du ing kap me umi kárangngá me tipot yanyawon táená wa. ");
INSERT INTO klt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wáina hálendu Farisi yot lo yan tiksa watá Jesu inuráng, “Rina tángga ku disaepelka yá tátáwi náni yan kálu wa isutang ket yáni rongrongngá ma hálen sungngi nanggoeráng?” ");
INSERT INTO klt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wáina inát tu Jesu yá yánuk, “Ámna kusákngá sánda puk hánám Ánutu yá profet Aisaia inán kándáng hánám ing mengga uyiuk: ‘Ámna náráwa náwu milun dá re meng toling namángngátaráng, iná pahán yáni wu nepmang kung mulangán hánám átaráng. ");
INSERT INTO klt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hánámá sut tá re nanáng sákngingngátaráng, hang me mengngátaráng wawu ámna yan meng rákit mená wa rewe Táwi yan me ina yánángngátaráng.’ ");
INSERT INTO klt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sándu Ánutu yá meng rákit me tiuk wa sat kun du ámna nangge yan kálu wa re káto tángga átkoeráng.” ");
INSERT INTO klt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hang ing yánuk, “Sándu álo kámá hánám ing tánggoeráng! Ánutu yan meng rákit me wa iháng numkálu tingga ku ámna sánin kálu wa rewe isutang átkoeráng! ");
INSERT INTO klt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kulá Moses yá ing miuk, ‘Mam nan sáni ya tárang káin átneráng,’ iná, ‘Niyá naning maming me wáik yáninek wawu utkámut táineráng.’ ");
INSERT INTO klt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Enendu, ket tárák sáni wawu hulá kámá. Sándá ku ing mengngátaráng, ámna káman dá naning me maming ing yánánggim, ‘Sup me kutná kutná náwu sán sámánggem, enendu Ánutu yan pingnga ingga há miut, wata ku ma sámindát,’ ");
INSERT INTO klt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","wáina tángga ku sat naning me maming ma háláng yámángngátak. ");
INSERT INTO klt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wáina tángga ku tátáwi sáni yan kálu wa uying sat áwán Ánutu yan me wa táng hang tinggoeráng, hang kálu wáinanyon nukngá kámá hányon tánggoeráng.” ");
INSERT INTO klt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hang son Jesu yá urum táwi wa mantáng yámán málámbán káin áwát yánuk, “Sán kámuk nákkán me ná kárámatingga kándáng hánám narineráng. ");
INSERT INTO klt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Náut kámá káman kep káinnan dá kung ámna me náráwa káman da kinan hangga watá tán mukmuro pálak ma hálenggim, ináku náutá ámna me náráwa kinan káinnan dá áwáng kep káin hangngátak watá tán du mukmuro pálak hálengngátak.” ");
INSERT INTO klt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kulá máriya urum táwi áturáng wa sangga kung it kinan háuk, wahára ku disaepelná yá me tárákngá wa yánuk wata hulá nanaráya ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wáina ináng sulit Jesu yá yánuk, “Sánda nanará sáni muná yon me? Ing wa ma kangngátaráng me? Náut kámá káman kep káinnan dá kung ámna me náráwa sut kinan hangngátak, watá tán ámna me náráwa watá mukmuro pálak ma hálengngátak. ");
INSERT INTO klt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Náuta watá kung pahán kinan ma hangngátak, ináku kung kombán káin hangga ku kámun kálu ámna nangge sut sangga kep káin kungngátak.” (Wa men du disaepel yá naruráng sungngi kámuk hánám wawu rongrongngá.) ");
INSERT INTO klt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Waháranyon kungga ku ing miuk, “Náutá ámna me náráwa sut kinan átang áwáng kep káin hangngátak watá tán du mukmuro pálak hálengngátak. ");
INSERT INTO klt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kulá ámna me náráwa pahán kinan nan dá áwáng hangngátak ku nanará wáik, márámamák, manek, ámna nangge utnut, náun áwán dá ámna náráwa nukngá yot márámamák tátá, ");
INSERT INTO klt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","há árán nukngá ya mengmeng, ket tárák kandák kámá yáyále, me kusák, put ang gán ket tárák, kápáng naknarák, mengmán mengmán, kaya narátá árená háhále, hang hohonáyan ket tárák. ");
INSERT INTO klt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wáina watá hánám bu pahán kinan nan dá áwáng hangga ámna me náráwa táng wáik tángngátak.” ");
INSERT INTO klt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu yá ále wa sangga Tair ále káin kuk ngáyá kung it káman da kinan kung hangga ku káman dá Jesu wáina átak ingga nanará watá taktak mán kilak árin ingga átuk, enendu kilak átnát tán tárák muná. ");
INSERT INTO klt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kulá náráwa káman uriwa iruk wáik ká ep táená watá Jesu yá wáina áwek ingga pingnganá narángga waháranyon áwáng hárammá hulá hára tulá hára imángga turingga háuk. ");
INSERT INTO klt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Náráwa wawu ále Fonisia Siria káwak káin tunggafiuk, iná málám wawu hun Juda waháranan muná. Watá áwáng iruk wáik ká uriwa ep táená wa isurátá kuik ingga Jesu kiling muk. ");
INSERT INTO klt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wáina inán Jesu yá inuk, “Hulátingga hánám bu satá nangge yá náuta nareráng wa kálak naniráng. Nangge yan sungngi wa iháng ang yáni yámátne kándáng ma háleindák.” ");
INSERT INTO klt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ingga Jesu yá inán náráwa watá miuk, “Pálipuk, ámna hulá, enendu ang gu tebol tárang káin nangge yá sungngi náená káhumá watá hat hányon nangngátaráng.” ");
INSERT INTO klt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wáina men Jesu yá inuk, “Wáina melák wata ku álo kung. Iruk wáik wawu uriwaka sangga há koek.” ");
INSERT INTO klt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kulá náráwa wawu hangga itná káin son kungga káuk ngá ku uriwa wu iruk wáik ká sangga kun kome hára hang pándák árán. ");
INSERT INTO klt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kulá Jesu yá Tair ále wa sangga Saidon ále kálu kungga hangga Dekapolis ále kálu kungga umi pátum Galili káin kung hiuk. ");
INSERT INTO klt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wakáin kungngárán ámna káman kárámanná tungngá yot tu meme tátáya táng husingngátak wa engotang áwuráng ngáyá áwáng Jesu rupmá hára sangga ketná yá ámna wa tánggagaya kiling muráng. ");
INSERT INTO klt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wáina inát Jesu málám ámna wa engotang urum táwi wa yápmangga kep sim kungga ketná kálongngá numnum iháng kárámanná hinangngá numnum ihánggápángga, son alupmá murán ketná káin han táng ámna watá elákngá káin tánggangga ");
INSERT INTO klt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","málám hálen alek kálu árán pahálá yot urákngá narángga irukngá uyingga inuk, “Efata!” (wata hulá ku ing, “Yaling!”). ");
INSERT INTO klt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wáina tán rám waháranyon ámna wata kárámanná yá ruwarán elákngá yá álo hálen wahára átang gu hiták meme tánggatuk. ");
INSERT INTO klt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kulá wahára átang Jesu yá olet yáni káto hánám tángga ni kámá káman ma inindaráng ingga yánángga sonson táuk, enendu ámna náráwa yá meng isurát kungga táwi hánám háliuk. ");
INSERT INTO klt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ámna náráwa yá wa narángga ikik hánám hárámutang ing miuráng, “Kutná kutná wu kándáng hánám wa tánggoek. Watá tán káráman yáni tungngá yá ruwarát, me yáni muná yá meme tánggoeráng.” ");
INSERT INTO klt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Rám ore wahára ámna náráwa urum táwi kámá yá áwáng árát, Jesu yá wa kápán sungngi yáni muná hálen disaepelná mantán áwát yánuk, ");
INSERT INTO klt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ámna náráwa nátá áwáng nákkot árát rám kaláhu hálek ka náut kámá kámá nanayan ma átyámák, wata ku urák yáni naret. ");
INSERT INTO klt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iná no hánámá hánám suring yáme kuineráng wawu kálu hára hálet yángom tin háineráng, náuta kámá wu kálu mulangán hánám áwuráng.” ");
INSERT INTO klt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wáina yánán disaepelná yá inuráng, “Enendu náwu ále rákit káin átamán, ni hánám bá ku sungngi tárák hára ihángga áwán yámátne nanggalát?” ");
INSERT INTO klt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wáina ingga met Jesu yá yánuk, “Másáng tum ba rina tá átaráng?” Ing yánán, “Másáng tum bu 7 dá átaráng,” ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wáina inát Jesu málám ámna náráwa wa yánán káwak hára wa putung hang árát, málám másáng tum ihángga átang sáponga tángga hikhuk tángga iháng disaepelná yámán ámna náráwa ya ting yámángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hang káut isikikimo yarákimo hányon árát, wata sáponga hányon tángga iháng disaepelná yámán watyot ámna náráwa ya ting yámángga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kulá ámna náráwa yá nangga álo náemán ingga kátu yápmat, disaepel yá kátu kátu wa iháng rápmám 7 wa tuwat hánám monduráng. ");
INSERT INTO klt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ámna náráwa sale yáni wu 4000 náut wáina watá árát suring yámán kut ");
INSERT INTO klt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","waháranyon málám bu disaepelná yot bot ketnán árángga Dalmanuta ále kálu kuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi yá áwuráng ngáyá áwáng Jesu yot me inán kanán tángga ingirungnginin ingga ing inuráng, “Alek kálu nan tárák kámá náleng.” ");
INSERT INTO klt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ing inát Jesu málám narán márawin yánuk, “Náuta ku rám nátán ámna náráwa yá tárák yáyáleya nanánggoeráng? No pálipuk ing sánin, tárák káman ma hánám káindáráng.” ");
INSERT INTO klt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wáina yánángga kung bot ketnán árángga son umi pátum hitik tángga numkálu kuk. ");
INSERT INTO klt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rám disaepel yá bot ketnán kuráng wahára wu kalot yámán másáng kámá ma ihená kuráng, iná káman re yá ku bot kinan átuk. ");
INSERT INTO klt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kungga átang Jesu yá yánuk, “Kándáng gon átneráng. Farisi yot Herot tán yis ya háleng rákit tánggatneráng.” ");
INSERT INTO klt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wáina yánán yáni inán kanán tángga ku miuráng, “Náwu másáng muná wata nánek.” ");
INSERT INTO klt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kulá Jesu málám wáina wata puk me táeráng ingga ku yánuk, “Náuta ku másáng muná wata mená tánggoeráng? Sánda pálipuk ma kangguráng me ma naráng hátingguráng? Pahán sáni wa káto me? ");
INSERT INTO klt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sándu rahán sáni pálak enendu ma kangguráng, me káráman sáni pálak enendu ma narángguráng. Ket tárák rina rina tángngátat wawa sánda ma naráng hátingguráng me? ");
INSERT INTO klt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Rám no másáng tum 5 wa 5000 dán da hikhuk táut hára nat kátu árát rápmám rina molát tuwaturáng?” Ing yánán “12” ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Iná rám no másáng tum 7 wa 4000 dán da hikhuk táut hára nat kátu árát rápmám rina molát tuwaturáng?” Ing yánán “7” ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kulá Jesu yá yánuk, “Wáina kangga ku rina tángga kámá ma re naráng hátingguráng?” ");
INSERT INTO klt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kulá it Betsaida káin áwáng árát ámna náráwa urum káman dá ámna rahálá kunángngá káman engotnáwáng tánggang ingga Jesu kiling muráng. ");
INSERT INTO klt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wáina inát Jesu málám rahálá kunángngá wa ketná hára tángga it kapme wa sangga kep káin kung átang ámna wata rahálá káin alupmá murángga ketná yá tánggangga inuk, “Náut kámá kámá hálengga káelák me?” ");
INSERT INTO klt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ing inán ámna watá háleng san kun miuk, “Ámna náráwa kápet tu káráp pá ina kung áwáng tángga árát.” ");
INSERT INTO klt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wáina men Jesu yá son ketná iháng ámna wata rahálá numnum tin rahálá yá rongrongngá hánám hálengga kándáng árená wáina hálen kutná kutná wa kándáng kápuk. ");
INSERT INTO klt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wáina tán Jesu yá itná ya suring mán kun ing inuk, “Kungga it kapme táwi káin ma átkuindalák.” ");
INSERT INTO klt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu yá disaepelná yot yáni wu kungga it yáilá Sisaria Filipai watán it nanggená kinan kinan átningga ku kálu hára kunggatang gu yánáng suliuk, “Nákka ámna náráwa yá ni ingga menggoeráng?” ");
INSERT INTO klt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ing yánán watá inuráng, “Kámá yá ku ‘Jon Umi Kuháng Yámámá,’ ingga menggoeráng, iná kámá yá ku ‘Elaija,’ ingga menggoeráng, iná kámá yá ku ‘profet nukngá’ ingga menggoeráng.” ");
INSERT INTO klt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wáina inát Jesu yá yánuk, “Iná sáni wu nákka ni ing menggoeráng?” Wáina yánán Pita yá miuk, “Kák ku Ánutu yá ámna suring mán hangga ámna náráwaná son iháháya miuk wa.” ");
INSERT INTO klt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wáina inán Jesu yá ni kámá kámá wáina ingga ma yánindaráng ingga káto táng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kulá Jesu málám disaepelná yot átang gu Ámna Nanggená wawu sut láwit táwi hánám narinek, me ámna yáilá, lo yan tiksa me pris tátáwi yáni watá táng kep tit utkámut táineráng ngáyá rám kaláhu átang gu son tárutnek ingga wáina yánuk. ");
INSERT INTO klt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Málám me wa hiták hánám yánán kangga wata ingga Pita yá engot hang kep kálu átang me táng muk. ");
INSERT INTO klt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Enendu Jesu yá hurik tángga disaepelná kápánggatang Pita me táng mángga miuk, “Satan, sárumna káin kung! Kák ku Ánutu yan nanará wa ma isuralák, ináku ámna yan nanará isutalák.” ");
INSERT INTO klt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wáina inángga ku ámna náráwa urum táwi mantáng yámán áwáng disaepelná yot árát tu yánuk, “Káman dá nák natnasut ta ku málámbán pahán wa sang hálingga málámbán maripong sungga tánggatang gu nák nasutnek. ");
INSERT INTO klt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iná niyá málámbán átkuku wata narángpak táinek wawu átkukuná watá muná kuinek, iná káman niyá nák me, me pingnga álosim wata ingga átkukuná wa sáinek wawu átkukuná watá ma muná kuindák. ");
INSERT INTO klt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ámna káman dá káwak kán kutná kutná álosim erek átmánggim, enendu átkuku sásáliná muná wa ma tánggim, wahára ku kutná kutná watá ku rina hánám háláng imánggim? ");
INSERT INTO klt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Irukngá watá átkuku tátáya narángga wata yumnakngá Ánutu náut imánggim? ");
INSERT INTO klt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Rám nátán ámna náráwa wawu ámna mukmuro hang Ánutu ya kalot yámená. Sán háranan káman dá nák me nákkán me wata reprepmá tánggim, máriya rám kálu Ámna Nanggená yá Naning gán yamá hálángngá pálak wata kinan angeloná káungá watyot áwánggim wahára wu reprepmá yon kanggim.” ");
INSERT INTO klt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hang ing hányon yánuk, “No pálipuk hánám ing sánin, kámá sán nahára átaráng wawu ma kámurená átnárát Ánutu yan átkuku watá hálángngá pálak áwán káineráng.” ");
INSERT INTO klt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rám 6 átang gu Jesu yá Pita, Jeims hang Jon yángotang ále yáilá hásák táwi káin yáni kámuk hánám wa áráng áturáng. Áráng wakáin átang gu kondon yáni kálu sutná watá hulá kámá hánám wa hálen káuráng. ");
INSERT INTO klt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kutná kutná tánggánengga átuk watá hakokowak hánám sireretná pálak háliuráng, wawu káwak ketnán ámna káman dá tán wáina ma tunggafenggim. ");
INSERT INTO klt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Átang kangngárát tu waháranyon Moses káling Elaija yá kondon yáni kálu wa tunggafengga Jesu yot me inán kanán tánggaturáng. ");
INSERT INTO klt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wáina kangga Pita yá Jesu inuk, “Tiksa, nándá nahára átamán wawu álosim hánám, wata ku sima kaláhu usinemán, káman kákkán káman Moses yan hang káman Elaija yan.” ");
INSERT INTO klt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Disaepel kaláhu wawu pikpito hánám narángga áturáng, wata ku Pita yá wáina meinet ingga ma narená hánámá miuk. ");
INSERT INTO klt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wáina men átnárát mukam bá tunggafengga áwáng iháng támotuk, wata kinan du me káman ing áwuk, “Náwu nák Nanggena, no wata kikiná hánám naret. Watán me narineráng!” ");
INSERT INTO klt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wa narángga waháranyon háleng sulingga káuráng gu ni kámá káman yáni yot wahára wu ma árán káuráng, ináku Jesu yá re wahára árán káuráng. ");
INSERT INTO klt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Rám ále yáilá káin átang áwáng hanggaturáng wahára wu Jesu yá me káto mengga ing yánuk, “Náut káeráng wawu ni kámá káman ma hánám inindaráng, ináku árát kungga Ámna Nanggená yá kámurená háranan tárutnek.” ");
INSERT INTO klt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wáina yánán yáni waku rina káuráng wa sat yáni yot re árán du “kámurená háranan dá tárutnek” wata hulá ya yáni inán kanán táuráng ");
INSERT INTO klt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ngáyá ku ing ináng suliuráng, “Náuta ku lo yan tiksa yá menggoeráng Elaija yá kálak hánám áwinek?” ");
INSERT INTO klt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wáina inát Jesu yá yánuk, “Wawu pálipuk Elaija yá kálak áwáng kutná kutná wa kámuk son iháng tolinek. Enendu me káman ing uyená átak wa háting márák tángga narineráng. Ámna Nanggená wu láwit táwi hánám wa narinek me wa kat hánámá háleinek. ");
INSERT INTO klt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","No ing sánin, Elaija wu há áwuk wahára ámna yá yánin pahán isutang rina rina wa há táng muráng, wawu Ánutu yan me hára wata rina uyená wa isutang.” ");
INSERT INTO klt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Disaepel nukngá yá áturáng wakáin áwáng hengga kápuráng gu ámna náráwa táwi hánám watá iháng áwálák tánggarát lo yan tiksa yá watyot menmen tánggarát, ");
INSERT INTO klt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ámna náráwa táwi watá Jesu yá áwáng hen kangga ku waháranyon ikik hánám hárámutang kang memeya rupmá káin hururung ingmen kuráng. ");
INSERT INTO klt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kut Jesu yá yánuk, “Náuta menmen tángga átkoeráng?” ");
INSERT INTO klt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ingga yánángga átnárán ámna káman urum táwi wata kinan átuk watá topmá inuk, “Tiksa, no nanggena iruk wáik ká ep tángga milunná pop táená wa engotang áwet. ");
INSERT INTO klt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Rám rina hára watán rám hálengngátak wahára wu káto tánggatang táng san káwak hára han máta sángátin árán pululu yá áráng hekhek tángga sutná yá kándáng nangga átnándak. Isutniráng ingga disaepelka yánet, enendu tát men sáeráng.” ");
INSERT INTO klt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wáina inán Jesu yá yánuk, “Ámna náráwa sándu naráng hákhátik sáni muná. Sányot rám rina átkuinet? Rám rina sándá márapmá namineráng? Nangge wa tángga nákkán káin áwániráng.” ");
INSERT INTO klt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wáina yánán nangge wa tángga Jesu yan káin áwát iruk wáik watá Jesu káuk hára wu nangge wa tán hárikhárik tángga árán háting san káwak hára hangga kinkiwon tángga pululu yá máta kálu áráng hekhek tánggatuk. ");
INSERT INTO klt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wa kangga Jesu yá nangge wata naning inuk, “Rina hára hulátingga wu tárák ing tángga áwuk?” “Nangge kimo háranyon hulátiuk,” ingga naning gá inuk. ");
INSERT INTO klt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Rám kámá wu háting se káráp káin me umi káin hangga kámurik ingga tángngátak, wata ku ko álo rina kámá tánggim me, urák náni narángga álo háláng námánggim me rina?” ");
INSERT INTO klt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wáina inán Jesu yá inuk, “Náuta ku wáina melák, ‘Ko álo me’? Káman niyá naráng hákhátik hára átnek wawu kutná kutná erek álo táinek.” ");
INSERT INTO klt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wáina men nangge wata naning gá waháranyon mantáuk, “Naráng hákhátikna wu átak, enendu isikimo, wata ku ko háláng namángga tátá táwi háleinek.” ");
INSERT INTO klt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu yá káuk ku ámna náráwa táup hánám watá wakáin hururung re uyingga kut wata tángga ku málám iruk wáik wa me táng muk, “Kák ku káráman yot milun mátap yongutut watán iruk, no kanet nangge wa sangga áráng hengga kungga ku son áwáng waháranyon ma háindalák.” ");
INSERT INTO klt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wáina inán iruk wáik watá mantáng pilingga hárikhárik táwi hánám tángga nangge wa sangga áráng hengga kuk. Ámna náráwa táup táwi yá kat tambun dá ina árán du nangge wawu há kámutak ingga káuráng. ");
INSERT INTO klt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Enendu Jesu yá ketná hára tánggatang táng hip tángga san hetang átuk. ");
INSERT INTO klt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wata torong hára it kinan kung hangga yáni kámuk hánám átang gu disaepel yá Jesu inuráng, “Rina ta ku nándá ma isurátne kuk?” ");
INSERT INTO klt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wáina inát Jesu yá yánuk, “Wáina wawu sáponga hára re kungga ku watá áráng hengga kuineráng.” ");
INSERT INTO klt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Kulá yáni wu ále wa sangga Galili kálu kuráng, wahára wu Táwi yan me wa disaepelná re yánáng tolinggatuk, wata ku wakálu átaráng ingga káman dá nanará wata Jesu yá taktak muk. Wata kinan ing yánuk, “Ámna Nanggená wawu táng káyam ket yáni hára tit utkámut táineráng, enendu rám kaláhu átang gu son tárutnek.” ");
INSERT INTO klt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wáina yánuk enendu disaepel yá wáina wata nánek ingga ma naráng ruwat táuráng, me wata hulá ya ináng susuliya wu hányon pitáuráng. ");
INSERT INTO klt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rám káman it Kapaneam káin áwáng hiuráng wahára wu áwáng it káman da kinan átang gu Jesu yá yánáng suliuk, “Kálu káin náuta menmen tángga áweráng?” ");
INSERT INTO klt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kálu káin du niyá máta átgim ingga mengga wata menmen ná tángga áwuráng, wata ku mátan ma táená áturáng. ");
INSERT INTO klt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kulá putung átang gu Jesu yá disaepelná 12 wa mantán áwát tu yánuk, “Iná káman dá máta átnát ta narángga wu málám táng mári pukon da tingga kámuk kán yáup nangge hálengga átnek.” ");
INSERT INTO klt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wáina yánángga Jesu málám nangge kimo káman táng áwáng yáni yot ting san árán poláng mángga átang yánuk, ");
INSERT INTO klt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Káman niyá nák kutna hára nangge kimo ná táng álolo táinek wawu nák neháng álolo táinek, hang káman niyá nák neháng álolo táinek wawu nák neháng álolo ma táindák, ináku niyá nák suring namuk wata táng minek.” ");
INSERT INTO klt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kulá Jon dá Jesu inuk, “Tiksa, nándá káumán du ámna káman dá kák kutya hára iruk wáik yásutang árán, kangga wáina ma táindalák ingga káto táng mumán, náuta wawu nándán tombong muná.” ");
INSERT INTO klt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Wáina men Jesu yá miuk, “Ma káto táng mindaráng. Káman niyá nánda káyam ma táng námindák wawu nánda nuk náni, wata ku ni kámá káman nák kutna hára ket tárák hulá hulá táinek watá torong hára nákka me kandák kámá ma meindák. ");
INSERT INTO klt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No pálipuk hánám ing sánin, káman niyá nákka narángga sáhán sán du Son Iháháyan Ámna watán pingnga hálen umi kátang sáminek wawu wata yumnakngá watá ma yakyawing mindák. ");
INSERT INTO klt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Hang sup maming táwi táng kák sala hára putingga sat kung táp kinan hangga há kámutgim enendu kákkán márapmá wawu isikimo. Iná ko tátá nangge kikimo naráng hákhátik yáni nák hára átak waháranan káman dá kung mukmuro tánggim wawu kákkán márapmá wu maming hánám táwi. ");
INSERT INTO klt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Hang ketya káman dá kangorán kandák tángga wu wa marángga satá kuinek. Kungga átkuku kinan hahaya ku ketya káman re yá wu álo kámá, náuta ketya yará pálak árán kung sup pora káráp lánggop sásáliná muná kinan háilon. ");
INSERT INTO klt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Hang háramya káman dá kangorán kung kandák tángga wu marángga satá kuinek. Kungga átkuku kinan hahaya ku háramya káman re yá wu álo kámá, náuta háramya yará pálak árán keháng sat kung sup pora kinan háilon. ");
INSERT INTO klt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hang rahála káman dá kangorán kandák tángga wu rahála káman wa holengga satá kuinek. Kungga Ánutu yan átkuku kinan hahaya ku rahála káman re yá wu álo kámá, náuta rahála yará pálak árán keháng sat kung sup pora káin háilon. ");
INSERT INTO klt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sup pora ‘watán umbeng wawu ma kámutnándaráng, me káráp lánggop wawu ma sálikngindák.’ ");
INSERT INTO klt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Táwi yan káin towet sinin ingga ku sol tingga ku táng káráp singngátaráng. Ámna náráwa kámuk ku wáinanyon háleineráng. ");
INSERT INTO klt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol tu álosim hánám, enendu rám kikngá watá sálinek wahára wu rina tátá wu kikngá yá son tunggafeinek? Ka tátá sol yá ina átnek, me nangge nuknukka yot orek sáni hára pahán káman re átneráng.” ");
INSERT INTO klt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kulá Jesu yá ále wa sangga Judia ále kálu kungga Jodan umi wa hitik tángga kung numkálu árán du ámna náráwa táwi hánám watá watán káin áwáng het tu málámbá tángngátak wáina son Táwi yan me wa yánáng toliuk. ");
INSERT INTO klt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wáina tángga átnárán du Farisi kámá yá áwuráng ngáyá ku ingirungngingiya ináng suliuráng, “Nánin me páilák wahára ámna káman dá áwáná isutgim wawa kándáng me?” ");
INSERT INTO klt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wáina inát Jesu yá yánuk, “Moses yá me páilák rina sánuk?” ");
INSERT INTO klt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wáina yánán watá inuráng, “Moses wu ing miuk, ‘Ámna yá papia kátu kimo sansan tátáyan uyingga náráwa imángga ku álo isurán kuinek.’” ");
INSERT INTO klt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wáina inát tu Jesu yá yánuk, “Tátáwi sáni yot sándu yáin sáni wu káto hánám, wata ku Moses yá meng rákit me wa uyiuk. ");
INSERT INTO klt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Enendu hulátingga hánám Ánutu yá kutná kutná iháng tunggap táuk, waháranyon ‘ámna me náráwa iháng toliuk.’ ");
INSERT INTO klt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Wáina wata ku ámna yá naning maming yápmangga áwáná yot káman hálengga, ");
INSERT INTO klt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yará watá sut káman háleinemálák.’ Wáina wata ku yándin yándin ma átnándamálák, ináku káman hánám re átnemálák. ");
INSERT INTO klt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wata tángga wu Ánutu yá náut iháng tántápin táuk wawu ámna yá ma káting rákit táindaráng.” ");
INSERT INTO klt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kulá it kinan áturáng wahára wu disaepel yá wata son Jesu ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Inát tu yánuk, “Káman niyá áwáná isutang náráwa nukngá táinek wawu áwáná kakngá wa pahálá táng wáik tángga málámbá márámamák kálu wahára kung hang átnek. ");
INSERT INTO klt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hang káman niyá náulá isutang ámna nukngá táinek wawu márámamák há táinek.” ");
INSERT INTO klt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rám káman ámna náráwa yá nangge kikimo ihángga Jesu yá ihánggápik ingga watán káin áwángngárát, disaepel yá me táng yámuráng. ");
INSERT INTO klt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wáina tát kápángga Jesu málám pahálá wáin yánuk, “Sat nangge kikimo watá nákkán káin áwániráng, ma kung háting yámindaráng, náuta Ánutu yan átkuku kinan kung haha wawu ámna niyan pahán dá nangge kikimo ná ina átnek watán. ");
INSERT INTO klt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No pálipuk ing sánin, káman niyá Ánutu yan átkuku wa nangge kikimo yá tángga átaráng wáina ma táindák, wawu kung átkuku wata kinan ma kung háindák.” ");
INSERT INTO klt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wáina yánángga hang nangge wa iháng poláng yámángga ketná yá yáin yáni hára usáng hang tingga kuram táng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu yá tárutang kálu hulátingga kunggatuk wahára ámna káman dá hururung áwáng tulá hára imángga Jesu kondolá hára hangga inuk, “Tiksa álosim, rina tángga ku átkuku sásáliná muná wa táinet?” ");
INSERT INTO klt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wáina inán Jesu yá inuk, “Náuta ku ámna álosim ing nanelák? Ni kámá káman álosim muná, Ánutu káman dá re ku álosim. ");
INSERT INTO klt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Meng rákit mená wu há narelák wa, ‘ámna ma utnándalák, márámamák ma táindalák, manek ma táindalák, nangge nukka ya me kusák ma meindalák, kámá iháng yakyawák tángga kutná kutná ma iháng yámindalák, hang nanya me mamya tárang káin re átnelák.’” ");
INSERT INTO klt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wáina inán ámna watá inuk, “Tiksa, nangge kimo hára átang áwáng ná átat hára wu meng rákit mená wawu erek hánám há isutnándat.” ");
INSERT INTO klt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wáina inán Jesu yá kan kikinin inuk, “Kák ku náut kámá káman da re kesák táelák. Wawu kungga kutná kutná átyamek wa erek iháng yumnak tángga sup wa iháng ukuro átaráng wa yámángga ku nák nasutnelák. Wáina tángga ku alek kán átkuku álosim wa táinelák.” ");
INSERT INTO klt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wáina inán narángga kurákmáta yá wáik hálen pahálá yá márawin hangga háná kuk, náuta kutná kutná ná táwi hánám átmuráng wata. ");
INSERT INTO klt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Watá kun Jesu yá háleng kung disaepelná kárek kápángga yánuk, “Ámna niyá kutná kutná ná táup hánám watá kungga Ánutu yan átkuku kinan haha wawu háláng hánám!” ");
INSERT INTO klt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesu yá wa yánán narángga disaepelná yá hárámurát kápángga Jesu yá son yánuk, “Nángánanggena, Ánutu yan átkuku kinan kung haha wawu háláng hánám! ");
INSERT INTO klt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Samap hinangngá hára kamel yá huruk kuku watán márapmá wawu maming táwi, enendu ámna kutná kutná ná pálak ká kung Ánutu yan átkuku kinan haha watán márapmá watá wa táng hátek.” ");
INSERT INTO klt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wa men narángga disaepelná yá ikik hánám hárámutang yáni inán kanán tángga miuráng, “Kulá wáina wata ku niyá hánám bu átkuku sásáliná muná wa táinek?” ");
INSERT INTO klt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wáina met Jesu yá kárek hánám kápángga yánuk, “Ámna nangge yá rewe wu ma tátáyan, enendu Ánutu yá ku álo. Kutná kutná kámuk wawu Ánutu yá re ku álo táinek.” ");
INSERT INTO klt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wáina yánán Pita yá ing inuk, “Naráng, nándu kutná kutná náni erek hánám yápmang hálingga ku kák kasutumán!” ");
INSERT INTO klt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wáina inán Jesu yá yánuk, “No pálipuk hánám ing sánin, kámá niyá nák me, me pingnga álosim wata ingga itná, yakukula, málám ilommá, maming naning, yanángánangge, me ále háiná yápmáinek, ");
INSERT INTO klt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wata tángga ku náut yápmáinek wata topmá 100 torong hára tingga yáminek. Rám ná átang kuinemán háranyon Ánutu yá it me yakukulak, málám ilom, nan mam, nángánangge me ále hái táup hánám wa yáminek, hang kámá yá iháng káyam hányon táineráng. Kulá máriya rám kálu wu átkuku sásáliná muná wa táineráng. ");
INSERT INTO klt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iná kámá rendá máta átaráng wawu mári káin háineráng, iná kámá rendá mári átaráng watá máta káin kuineráng.” ");
INSERT INTO klt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kulá Jesu málám kálu máta yárengga disaepelná yot árángga Jerusalem kálu kuráng. Disaepel wu narángpak pálak kunggarát tu ámna náráwa káman kuráng wawu pingpitáng kungga átkiuráng. Kulá kunggatang gu Jesu yá son disaepelná 12 wa rewe iháng kung kep sim átang gu málám hára rina tunggafeinek wata yánuk. ");
INSERT INTO klt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ing yánuk, “Kaniráng, nán ná áwemán náwu árángga Jerusalem káin kuindemán, wakáin du Ámna Nanggená wawu táng pris yáin yáni me lo yan tiksa wata ket yáni hára tineráng. Watá wu táng me hára tingga utkámut tátáya me hárotneráng ngáyá wu son táng ámna ále kámá káinnan da ket yáni hára tineráng. ");
INSERT INTO klt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wáina tit tu watá ku ináng kekkek tángga alup yáni málámba ketnán uráhángga honggem bá utang táng kung utkámut táineráng, enendu rám kaláhu átang gu son tárutnek.” ");
INSERT INTO klt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kulá Sebedi nanggená yará, Jeims káling Jon, watá Jesu yan káin áwáng ing inumálák, “Tiksa, nátá rina táng nánámáya kaninemát wa isutang ko wáina hánám táng nánámáya naremát.” ");
INSERT INTO klt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ingga inán Jesu yá yánuk, “No rina táng sáminet ta naremálák?” ");
INSERT INTO klt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wáina yánán watá inumálák, “Ko kut táwi hánám tángga átang gu nát háranan káman táng ketya álák kálu hang káman táng ketya kandák kálu náháng ting satá putung átnemát.” ");
INSERT INTO klt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wáina inán Jesu yá ing yánuk, “Sán du náuta memát ingga wu ma narámálák. Sánda kap no náinet hára wa álo náinemálák, me umi no kuhinet wawa álo kuhinemálák me?” ");
INSERT INTO klt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ing yánán watá miumálák, “Nát tu álo.” Ing men Jesu yá yánuk, “Sán du no kap náinet wahára há náinemálák, me umi no kuhinet wahára há kuhinemálák, ");
INSERT INTO klt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","enendu ketna álák kálu me kandák kálu putung átnát wawu no wáina ingga ma mindát, ináku kome wawu Ánutu yá niyan tiyawiuk watán.” ");
INSERT INTO klt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kulá disaepel nukngá 10 watá wa naruráng hára wu Jeims káling Jon da kuk táng yámuráng. ");
INSERT INTO klt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kulá Jesu yá kámuk mantáng yámán áwát tu yánuk, “Sáni há nareráng wa, ále kámá káinnan dán yáin yáni átnándaráng, watá ku yáni ya narát árená hálen yáin yáni hánám átnándaráng. Hang ámna hulá hulá tátáwi watá kálu rina tingga táng káto tát tu ámna náráwa yá wa rewe isutnándaráng. ");
INSERT INTO klt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wáina watá sányot ma átnándak. Niyá orek sáni hára ámna hulá átnát ta ku sándán yáup nangge átnek, ");
INSERT INTO klt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","hang niyá máta átnát ta ku kámuk kán yáup nangge háleinek. ");
INSERT INTO klt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sándá ku no ket tárák rina sálengga áwánggoet wáinanyon tángguineráng. Ámna Nanggená málámbáyon áwuk wawu ámna náráwa yá yáup tángga wa háláng imámáya muná, ináku watá yáup tángga ku wa háláng yámámáya me málámbán átkuku wa ámna náráwa máro hánám wa son iháháya sáinek wata áwuk.” ");
INSERT INTO klt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kulá Jesu me disaepelná yáni wu Jeriko hára áwáng hiuráng ngáyá ámna náráwa urum táwi watyot it yáilá wa sangga kungga káuráng gu ámna rahálá kunángngá kutná Batimeus, Timeus nanggená, wawu kálu tákto káin putung átang ámna náráwa sup pa mantáng yámángga árán. ");
INSERT INTO klt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Watá rám wahára Jesu Nasaret nan wawu kálu wa isutang áwek ingga narángga ku mantáuk, “Jesu, Devit Nanggená, nákka urákna naráng!” ");
INSERT INTO klt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wáina mantán du ámna táup hánám watá me táng mángga inuráng, “Yolop álák!” ing inuráng, enendu emá re hánám hahatingga mantángga átuk, “Devit Nanggená, nákka urákna naráng!” ");
INSERT INTO klt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wáina narángga Jesu yá tareng kátingga yánuk, “Mantáng mát áwik.” Ing yánán mantángga rahálá kunángngá wa inuráng, “Kák ka mantáek. Herongnge narángga tárutang áwáng!” ");
INSERT INTO klt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wáina inát málám lap hásák torong káinnan wa yalingga san kun sokmuná hánám tárutang Jesu yan káin áwuk. ");
INSERT INTO klt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Áwán Jesu yá inuk, “No rina táng kakamáya narelák?” Ing inán rahálá kunángngá watá inuk, “Tiksa, rahánna háháleya naret.” ");
INSERT INTO klt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wáina inán Jesu yá inuk, “Kung, naráng hákhátikka yá keháng tolek.” Ing inán waháranyon rahálá yá álo hálen Jesu sárummá ya isutang kuk. ");
INSERT INTO klt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kulá Jesu yá disaepelná yot Jerusalem tangtang ále yáilá Olif káin it Betfage yot it Betani káin kung heheya átang gu Jesu yá disaepelná yará suring yámángga yánuk, ");
INSERT INTO klt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kungga it áning hára kung hengga waháranyon káinemálák ku donki máto káman wahára puting sat átak wawu káman dá wata ketnán putung átang ma kung áwáng táená wa páupmá yaling mángga ku engotang áwinemálák. ");
INSERT INTO klt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Iná káman dá sáhángga sáninek, ‘Náuta ku wáina tánggoemálák?’ ing sánán du ing ininemálák, ‘Táwi yá wata narek, ka ku rám hátetná kimo yáup imángga ku son san áwinek.’” ");
INSERT INTO klt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wáina yánán disaepelná yará yá kungga káumálák ku donki máto wu kep káin kálu hára it kálu mungnganá tangtang puting sat árán, yándi wu yalinggarán kápángga, ");
INSERT INTO klt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ámna wahára hetang áturáng watá yánuráng, “Sán du náut tánggoemálák, donki páupmá wa yalingga rina táng mindemálák?” ");
INSERT INTO klt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wáina yánát yándi wu Jesu yá rina yánuk wáina yánán du yápmat donki wa engotang kumálák. ");
INSERT INTO klt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yándi wu engotang Jesu yan káin áwángga lap yándi hákhásák sut yándi háranan wa yalingga iháng Jesu yá putung átnát ta donki ketnán tiumálák. ");
INSERT INTO klt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kulá wáina tin Jesu yá donki ketnán putung átang áwángga átuk wahára kátu táwi watá lap yáni hásák wa yalingga iháng kálu hára eliuráng, iná kámá yá wu kándumá ina wata ilángá ále wahára árená maruráng wa iháng kálu hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kámá máta kuráng me kámá mári isutang áwuráng watá ohok menman tángga mangmantáng kuráng, “Táwi kutná meng tárut tánin!” “Niyá Táwi kutná hára áwek wawu Ánutu yá há táng álolo táená watá áwek!” ");
INSERT INTO klt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Nan náni Devit háranan átkuku álosim watá áwek wawu Ánutu yá há táng álolo táená watá áwek!” “Táwi alek káin átnándak wata kutná meng tárut tánin!” ");
INSERT INTO klt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wáina mantángga engotang kungga árát Jesu málám Jerusalem kinan hangga kungga Táwi yan it káungá hánám wakáin kuk. Málám kung háleng sulingga kutná kutná wa erek hánám kápángga sangga it tá há yonyoliuk hálendu Betani ya disaepelná 12 watyot son kuráng. ");
INSERT INTO klt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kulá son tembát náya Betani sangga kungkung gu Jesu wu háing muk. ");
INSERT INTO klt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wáina narángga málám háleng kung káráp fik káman da ilángá kangga wata hulá káin páliná pálak me muná ingga kakaya kuk. Málám hulá káin kungga káuk ku páliná ku muná ilángá re, náuta wawu watá páliná sásáyan rámá muná. ");
INSERT INTO klt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Málám wáina kangga ku káráp wa inuk, “Son pálinya ma hánám titá náindáráng.” Wáina inán disaepelná yá me wa há naruráng. ");
INSERT INTO klt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kulá Jerusalem káin kung hengga ku Jesu málám Táwi yan it káungá hánám ba kapmená káin kung hangga rendá kutná kutná tingga yungga tángga átnándaráng wa yásutang tebol sup imán kamán tángga átnándaráng me ámna iráp kikimo yumnak táená watán tongtong wa iháng hurik tángga sungguling yámuk. ");
INSERT INTO klt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wáina tángga ku kutná kutná yumnak tátáyan wa ihángga Táwi yan it káungá hánám kapme kálu wa kung áwáng tátáya káto táng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wáina tángga ku ing yánuk, “Me ing uyená yá átak, ‘“Táwi yan it wawu wáina árán káwakngá káwakngá watá áwáng urum tángga sáponga tátáyan it,” ingga mengguineráng,’ enendu sándá tát tu ‘manek mara yan ále kilakngá ina’ hálenggoek.” ");
INSERT INTO klt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wáina yánán narángga ámna náráwa táwi watá hárámutang me yánáng toliuk wa narát kikiniuk. Wáina tát kápángga pris yáin yáni me lo yan tiksa watá Jesu ya pitáng mángga kálu rehára kungga utkámut tánin ingga kálu ya suliuráng. ");
INSERT INTO klt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kulá árát yonyon tin du Jesu yá disaepelná yot it yáilá wa sangga hangga kuráng. ");
INSERT INTO klt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tembát náya hilápmá Jesu yot disaepelná yáni wu kunggatang káuráng gu káráp fik ku ulapmá káin átang kung hang ráhulá káin du kumkumengga árán. ");
INSERT INTO klt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita málám kangga naráng hátingga ku Jesu inuk, “Tiksa, kang! Káráp fik kuip me táng málák wawu kumkumengga átak!” ");
INSERT INTO klt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wáina inán Jesu yá ing yánuk, “Ánutu ya naráng háting mineráng. ");
INSERT INTO klt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","No pálipuk ing sánin, ni kámá káman dá pahán yará hára muná ináku ‘Ánutu yá wáina táinek’ ingga naráng hátingga ále yáilá ná inánggim, ‘Hiring ingmen táp káin hitang,’ ingga inánggim wawu wa isutang wáina tánggim. ");
INSERT INTO klt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wata ku ing sánin, náuta narángga sáponga hára Ánutu ininemán ingga narineráng wahára pálipuk wáina há náminek ingga narángga inineráng wata tángga pálipuk há sáminek. ");
INSERT INTO klt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Hang rám hetang átang sáponga táineráng wahára narát nuk sáni káman yot orek sáni hára honhoren dá árán, wawu watán kátu wa sat tu Nan sáni alek káin watá hányon sándán kátu wa sáinek.” ");
INSERT INTO klt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Jesu yá disaepelná yot yáni wu son Jerusalem káin kuráng ngáyá kung Táwi yan it káungá hánám watán kapme káin sengsulingga árán pris yáin yáni, lo yan tiksa me ámna hulá hulá watá watán káin áwáng ináng suliuráng, “Kák ku háláng náwu rekáinnan táng gu ket tárák hulá hulá wa tánggoelák? Háláng náwu niyá kamuk?” ");
INSERT INTO klt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wáina inát tu Jesu yá miuk, “No me káman sánáng sulindet, wa topmá nanát tu no niyá háláng namán wa tánggoet ingga sáninet. ");
INSERT INTO klt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon dá umi kuháng yámánggiuk wawu alek kálu nan me ámna yan káinnan? Wata nanániráng!” ");
INSERT INTO klt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wáina yánán yáni yon inán kanán tángga ku miuráng, “Nándá ‘alek kálu nan,’ ingga ininemán wawu náninek, ‘Náuta ku Jon dán me wa pálipuk ingga ma naráng háting kuráng?’ ingga náninek. ");
INSERT INTO klt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iná nándá ‘ámna yan káinnan,’ ing meinemán wawu kandák náhineráng.” Wáina miuráng, náuta ámna náráwa kámuk hánám Jon wawu pálipuk profet káman ingga há nareráng, wata ku pitáng yámuráng. ");
INSERT INTO klt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wáina mengga ku Jesu inuráng, “Nán ma narámán.” Wáina inát Jesu yá yánuk, “Nák ku wáinanyon ma sánindát háláng wawu niyá namán du ket tárák wa tánggoet ingga.” ");
INSERT INTO klt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kulá wahára átang gu Jesu yá me tárák hára tingga ámna náráwa yánuk. “Ámna káman dá wáin hái káman hingga kumbiná táng hálingga, wáin táulá yáreng hikhilák tátáyan árám pingga, hang it hásák káman átang háleng rákit tátáyan tángga ku hái wa táng ámna kámá yá wahára sup yáupmá tátáya ket yáni hára sangga ku málám hangga mulangán hánám káin kuk. ");
INSERT INTO klt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Málám wáin dá páliná tená rám kálu ku yáup nangge káman suring mángga ing inuk, ‘Kungga wáin hái pinná tángngátaráng ámna wa yánátá ku wáin páliná kámá kamát ihángga áwáng,’ ingga inán kuk, ");
INSERT INTO klt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","enendu ámna hái pinná tángga áturáng watá káto tángga utang ketná páliná muná hánámá son suring mát kuk. ");
INSERT INTO klt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wáina kangga son yáup ámna nukngá suring mán kung hen kangga wa wáinanyon yáilá hára kátingga táng wáik tát reprepmá narángga kun, ");
INSERT INTO klt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","son nukngá suring mán kuk, wawu kung hen pukon utkámut táuráng. Enendu nukngá táuppon emá re suring yámán kunggiuráng wawu kámá hánámá ráhángga kámá ráháng kátkámut tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kulá káman re pukon suring mámáyan dá átuk, wawu nanggená málámbá wata kikiná hánám narángga átnándak wa suring muk wawu ing mengga, ‘Watán me álo narineráng, me watán milun álo suwineráng.’ ");
INSERT INTO klt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Wáina mengga suring muk, enendu nanggená watá kung hen kangga ámna hái káin yáup tángga áturáng watá yáni meme táuráng, ‘Ámna wa áwek watá ku máriya naning gán kutná kutná ihinek. Áwát utkámut tángga ku kutná kutná ná wawu náni ya ihinemán.’ ");
INSERT INTO klt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wáina mengga árong káto tángga átang utkámut tángga mangga sat wáin hái kep káin kuk. ");
INSERT INTO klt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kulá wáin hái wata márumá yá wu rina hánám táinek? Málám áwinek watá áwáng ámna wáin hái káin sup yáupmá tángga árená wa erek ingmen ráháng kátkámut tángga ku wáin hái wa táng kámá yá pinná tátáya ket yáni hára tinek. ");
INSERT INTO klt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ánutu yan me ing uyená wa kámá sángingga kangngátaráng me muná? ‘It tátá yá sup wáik ingga kangga táng sat kuk, watá inggálu it hálángngá ya káto hánám átkoek. ");
INSERT INTO klt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Táwi málámbá wa táuk wa nándá katne álosim hánám hálenggoek.’” ");
INSERT INTO klt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kulá Juda yan ámna hulá wa wáina yánán me tárákngá náwu náni ya mek ingga há narángga ku rina tángga Jesu ket tánin ingga kálu ya suliuráng. Enendu ámna náráwa urum táwi wata hányon pitáuráng, wáina hálendu sangga há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Máriya ku Farisi kámá yot Herot tán tombong kámá yot suring yámát Jesu yan káin kung ingirungngitne me kandák kámá rina men kanin ingga wata kuráng. ");
INSERT INTO klt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yáni wu kung Jesu inuráng, “Tiksa, há naremán kák ku me kándáng re menggoelák. Kut yáni háená me árená wawu me tárák káman re yánánggoelák. Me pálipuk wahára re ámna náráwa Ánutu yá tirik tárák rina ta narek wa yánáng tolinggoelák. Kulá rina narelák? Takis Sisa imámá wa kándáng me muná? ");
INSERT INTO klt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Álo iminemán me ma imindámán?” Wáina inát Jesu málám nangnarungngeráng ingga há narángga yánuk, “Náuta ku nák nangnarungnging goeráng?” Ing yánángga ku yánuk, “Sup táulá wa tángga áwát no káin.” ");
INSERT INTO klt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wáina yánán sup táulá wa táng áwáng imát kangga ku yánuk, “Náwu ni utniná me ni kutná?” Ingga yánán yáni wu inuráng, “Sisa yan.” ");
INSERT INTO klt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wáina inát tu Jesu yá yánuk, “Náut Sisa yan wa Sisa imángga, náut Ánutu yan wa Ánutu imineráng.” Wáina yánán kangga hárámuturáng. ");
INSERT INTO klt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kulá ámna urum káman kut yáni Sadyusi wawu ámna náráwa kámurená wu ma tárutnándáráng ingga narángngátaráng watá Jesu ináng sulinin ingga Jesu yan káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Áwáng átang ináng suliuráng, “Tiksa, Moses yá me ing uyingga ting námuk, ámna káman dá kámutang áwáná nanggená muná sáinek wawu kulaná yá náráwa wa tángga tatning gán da nangge marángga tinek. ");
INSERT INTO klt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Rám káman tatning kukulak sewen dá átkiuráng. Átang tat yáni táwi watá áwáná káman táuk enendu nanggená muná átang kámutuk. ");
INSERT INTO klt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wáina hálendu son kulaná wata hangga hára watá náráwa kawát wa táuk wa wáinanyon kámurán, son wata hangga hára watá táuk wa wáinanyon kámutuk. ");
INSERT INTO klt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wáina re táng kung táng kung tatning kukulak sewen wa nangge yáni muná re átang kámut háliuráng, hang pukon da ku náráwa kawát yáni watá hányon kámutuk. ");
INSERT INTO klt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tatning kukulak sewen wata áwá yáni háliuk, wata ku máriya tátárut kálu ku ni hánám ba áwáná ku wa háleinek?” ");
INSERT INTO klt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wáina inát Jesu yá yánuk, “Táwi yan me uyená me Ánutu yan háláng wa ma naráráng me rina, hálendu kandák wa menggoeráng? ");
INSERT INTO klt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rám kámurená yá tárutneráng wahára wu náun áwán ma átnándáráng, ináku angelo yá alek káin átnándaráng wáina átneráng. ");
INSERT INTO klt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hang ámna náráwa kámurená yá tárutneráng watán me wu Moses yan papia káin pingnga káman ma hám sángingga kangngátaráng. Káráp isikimo hára káráp pá ranggatuk rám wahára Ánutu yá Moses inuk, ‘Nák ku Abraham, Aisak me Jekop watán Ánutu.’ ");
INSERT INTO klt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ánutu wawu kámurená yan Ánutu muná, ináku ámna átkuku yáni pálak watán Ánutu. Iná sándá wa meráng wawu kandák hánám hálek!” ");
INSERT INTO klt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lo yan tiksa káman áwángga naruk ku Sadyusi yá Jesu yot meme tánggarát, málám naruk ku me hurikngá Jesu yá álo kámá hánám yánángga árán narángga málám hang wáinanyon inuk, “Ánutu yá meng rákit mená nándá isusut ta miuk wahára ku resim bá ku meng rákit mená kátu wa iháng hátek?” ");
INSERT INTO klt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wáina inán Jesu yá miuk, “Táwi hánám bu ná: ‘Israel sán kámuk hánám narineráng, Táwi Ánutu náni wu káman re. ");
INSERT INTO klt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Táwi Ánutu ka wata pahála yot, irukka yot, hálángga yot me nanaráka yot kámuk hánám kikiná wata narinelák.’ ");
INSERT INTO klt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hang wata hangga ná ku ná: ‘Kaya kikiná narángngátalák, wáinanyon nangge nukka ya kikiná narinelák.’ Me nukngá náta torong káin ma árak.” ");
INSERT INTO klt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wáina inán lo yan tiksa watá miuk, “Kándáng hánám melák, tiksa. Ánutu wu nukngá kámá muná, málám káman re ingga pálipuk hánám melák. ");
INSERT INTO klt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ánutu ya pahán náni yot, nanará náni yot me háláng náni yot kámuk hánám kikiná narinemán, me náni ya kikiná narángngátamán wáinanyon nangge nuk náni ya kikiná narinemán, watá ku kutná kutná Ánutu ya towet sing mát káráp pá rang hálingngátak me taha hulá hulá ting mángngátaráng wa iháng hátek.” ");
INSERT INTO klt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu yá káuk ku me wa kándáng hánám narángga topmá inán kangga inuk, “Kák ku Ánutu yan átkuku wa sang kung mulangán ma áralák.” Wáina inán kangga ku wahára átang gu ámna yá me nukngá ináng susuliya pitáng muráng. ");
INSERT INTO klt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu yá Táwi yan it káungá hánám kumbiná kinan me yánáng tolingga kungga átang gu yánuk, “Rina ta ku lo yan tiksa yá ku ing menggoeráng, ‘Ámna ni Ánutu yá ámna náráwaná son iháháya miuk wawu Devit nanggená’? ");
INSERT INTO klt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Iruk Káungá yá Devit málámba pahálá kinan átang pahálán hangga árán ing miuk, ‘Táwi Ánutu yá Táwina ing inuk, “Ketna álák kálu putung árátá, no káyamya wa ráhángga iháng hang ting se árát ko wa iháng hátingga átnelák.”’ ");
INSERT INTO klt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Devit málámbá ku Táwina ingga miuk, rina tángga ku son du nanggená?” Wáina men ámna náráwa urum tái áturáng watá narángga herongnge hánám naruráng. ");
INSERT INTO klt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wáina mengmeng gu yánuk, “Lo yan tiksa wa kándáng kánggápáng átneráng. Lap hákhásák tánggánengga sengsulingga átning kungngátaráng, hang náhángga meng tárut táng námániráng ingga maket álele wa átning kungngátaráng, ");
INSERT INTO klt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","me umi sinak táená káin me miti itná káin kome máta káin átnin ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hang yáni wu náráwa kawát wa yángyárungngingga it yáni náut wa yáni ya ihángngátaráng, hang náhániráng ingga sáponga wawu hásák hánám wa tángngátaráng. Máriya rám kálu ámna wáinaná wawu márapmá táwi hánám wa ihineráng.” ");
INSERT INTO klt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu málám Ánutu yan sup titi komená tangtang putung átang gu áwáng sup tingga kungkung tángga árát tu wa kápángga átkiuk. Sup yáni pálak ámna máro hánám bá yon áwáng sup tátáwi yon tingga kunggiuráng. ");
INSERT INTO klt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kulá waháranyon ukuro kawát káman dá áwáng sup isikimo yará tárákngá wu wan toea ina wa tiuk. ");
INSERT INTO klt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wa kangga Jesu málám disaepelná mantán áwát yánuk, “No pálipuk hánám ing sánin, náráwa kawát ukuro watá ku sup táwi hánám wa kátu iháng hátingga Ánutu yan pingnga tek. ");
INSERT INTO klt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kátu táwi wawu há átyámek háranan kátu re ihángngáwáng teráng, iná wa wawu kámá málám háláng imán átnát wawu muná, pukon du wa tángngáwáng tek wa rewe.” ");
INSERT INTO klt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Rám Jesu yá Táwi yan it káungá hánám wa sangga háuk, waháranyon du disaepelná káman dá Táwi yan it káungá hánám táená wa kangga inuk, “Kang, tiksa! It álo kámá hánám ba kápáng! Hang it rámán yáni ya sup maming tátáwi hánám tingga árángga koená ya kápáng!” ");
INSERT INTO klt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ing inán Jesu yá inuk, “It tátáwi kápelák watán sup káman dá nukngá ya ketnán ketnán du ma átnándáráng, ináku erek táng hirarát háineráng.” ");
INSERT INTO klt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wáina yánángga Jesu yá disaepelná yot kungga ále yáilá Olif káin kung hengga putung átang Táwi yan it káungá hánám wa kangga átang, kulá Pita, Jeims, Jon hang Endru watá kilakon ináng suliuráng, ");
INSERT INTO klt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nán nánáng rina hára ku kutná kutná watá tunggafeineráng? Me tárák kolem bu rina rina tunggafengga kungga ku watá tunggafeineráng?” ");
INSERT INTO klt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wáina inát Jesu yá yánuk, “Kándáng hánám kangkang átneráng, kámá yá áwáng sángsárungnginirot. ");
INSERT INTO klt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kámá yá ku áwáng nák kutna mengga ku ‘Nák ku wa,’ ing mengga ámna náráwa máro hánám wa sángsárungngineráng. ");
INSERT INTO klt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hang kun erawák tát me kun erawák kán iruk me wa narángga ku hárámutang ma pitáindaráng. Ále márapmá watá álo tunggafeineráng, enendu rám bá sálikngingi wa ma hálená átnek. ");
INSERT INTO klt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","It kámá yá it kámá yot erawineráng, me king tombong kámá yá king tombong kámá yot erawineráng. Hang kánggáning gá it káwak kámá kámá káin táinek, me sungngi kesák tunggafeinek. Wawu náráwa yá kawin átang nangge tátáya hánámá uláng yámángngátaráng wáina. ");
INSERT INTO klt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Háleng rákit tángga tiyawingga átneráng. Sáháng ámna yáilá yan káin me hára tineráng, me miti itná kinan honggem bá sáráhineráng. Me nákka ingga tángga sáháng kapman táwi me king rahán yáni hára tit hetang átang me pingnga álosim yánineráng. ");
INSERT INTO klt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iná Táwi yan me pingnga álosim wawu wa kálak meng isurát káwakngá káwakngá erek kung hilák táinek. ");
INSERT INTO klt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kulá rám rina hára sáháng kung me hára titiya sáhángga kut wawu rina meinemán ingga narángpak ma táindaráng. Ináku rám waháranyon Ánutu málámbá rina sáminek wa meineráng, náuta wawu sáni ma meindáráng ináku Iruk Káungá watá meinek. ");
INSERT INTO klt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ámna náráwa kámá yá tatning kulak me tatning yit iháng káyam ket yáni hára tit ráháng kátkámut táineráng, hang nanan yáni yá nángánangge yáni wáinanyon táineráng, hang nangge yá nan mam yáni iháng káyam tángga kámá yánát ráháng kátkámut táineráng. ");
INSERT INTO klt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Me nákka ingga tángga ámna táup pá hánám bon sánda taktak yáminek. Enendu niyá káto árán kungga rám bá sáliknginek kálu wawu Ánutu yá iháng kung málámbán pingnga tinek,” ingga Jesu yá miuk. ");
INSERT INTO klt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kulá niyá me ná sánginek watá kándáng hánám narinek. Jesu yá ing miuk, “Sándá káineráng gu ‘náut kámá wáik maming táwi hánám’ watá ále káungá árená wa áwáng táng lem tángga táng wáik wáik pukon hánám táng san árán, wahára wu niyá Judia ále hára átneráng wawu pitángga ále yáilá káin kuineráng. ");
INSERT INTO klt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ni kámá káman dá itná hungnganá ketnán átnek watá itná pahálá kinan hangga náutná kámá káman ma tángga kuindák. ");
INSERT INTO klt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hang ni kámá káman dá háiná káin átnek watá son kung itná káin sutná tánggáneneyan lap hásák wa ma táindák. ");
INSERT INTO klt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Rám wahára náráwa kawin pálak me nangge kongakngá muk yámángga átneráng wata ku urák yáni narinet. ");
INSERT INTO klt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sáponga tángga árát tu rám watá kotkotná me ále rámá kálu ma tunggafeindak, ");
INSERT INTO klt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","náuta rám wawu rám wáik hánám wata. Hulátingga Ánutu yá kutná kutná men tunggafiuráng wahára átang áwáng rám nahára wáina kámá ma tunggafiuk, hang rám wáik wa tunggafeinek wata torong káin máriya rám wáinanyon kámá ma tunggafengguindák. ");
INSERT INTO klt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iná Táwi yá ‘Rám wa ma táng hátet táin,’ ingga miuk iná wu ámna náráwa káman kámá ma átgim, enendu ámna náráwa málámbá nakán ingga há kangaliuk wata narángga ku ‘Rám wa táng hátet táin,’ ingga miuk. ");
INSERT INTO klt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Rám wahára ku ni kámá káman dá sáninek, ‘Kaniráng, ámna Ánutu yá málámbán ámna náráwa son iháháya miuk wawu nákáin ná átak’, me ‘Áning káin átak’ ingga sánát tu pálipuk ingga ma narindaráng. ");
INSERT INTO klt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kámá yá áwáng gu ing sángsárungngineráng, ‘Nák ku Ánutu yá málámbán ámna náráwa son iháháya miuk wa’, me ‘Nák ku profet káman,’ ing mengga ket tárák kolem hulá hulá met tunggafen Ánutu yá ámna náráwa nakán ing mengga kangaliuk wa wáina álo tánin ingga álo iháng yakyawák tánggalát. ");
INSERT INTO klt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wata ku kándáng hánám háleng rákit tángga átneráng, rina rina tunggafeinek wawu há sánáng hálet wa. ");
INSERT INTO klt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Iná rám wáik tunggafeinek wata sárumá káin du ‘káe yamá watá páyung tin yap pá yamá ma máindák. ");
INSERT INTO klt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kulá alek káin hitung gá sohingga hat alek kán kutná kutná watá yángyáng táineráng.’ ");
INSERT INTO klt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Rám wahára ámna náráwa yá káineráng gu Ámna Nanggená yá mukam kinan ulihálángngá yot sireretná mangga áwinek, ");
INSERT INTO klt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ngáyá angeloná suring yámán ámna náráwa málámbán pingnga ingga kangaliuk wa kámoneráng, káwak tákto numnum ánuta ámuta wata ore kinan ámna náráwa kámuk hánám kámoneráng. ");
INSERT INTO klt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Sándá wu káráp fik wahára tárák tingga narineráng. Pan yáni hára puto tingga kungga iláng yáni mirak ká áráng hekhek tát kangga ku káe rámá háleindek ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wáinanyon ále watá tunggafen kangga ku Ámna Nanggená wu áwáng hálingga kálu mungnga káin átak ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No pálipuk hánám ing sánin, ámna náráwa rám ore nátán watá manyon kámurená árát tu ále watá kámuk tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Alek me káwak wawu sáliknginek, iná nákkán me wawu ma sálikngindák.” ");
INSERT INTO klt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ni kámá káman dá hulá hulá wa tunggafeinek watán rám wa ma narák, alek káin angelo me Nanggená wa manyon naráráng, ináku Nan málámbá re narángga átak. ");
INSERT INTO klt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tiyawingga hálengga átneráng! Náuta sándu rám rina hára wu rám watá tunggafeinek wawu ma naráráng. ");
INSERT INTO klt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wawu ing ina, ámna káman dá itná sangga kálu mulangán káin kukuya yáup horengga yáup ámna yánin yánin yámángga ku ámna kálu mungnga pinná tátá wa kándáng hánám hálengga átnelák ingga inánggim wáina. ");
INSERT INTO klt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Wata ku rámá rámá sándu hálengga átneráng, náuta rina hára it márumá yá son áwinek wawu sándu ma naráráng. Yonyon kálu me yáung táitná me hurák ká mantángga árát wahára me hilápmá hánám wawu ma naráráng. ");
INSERT INTO klt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kámá emá re ruhángga átnárát sopmuná hánám áwángga sáhiwon. ");
INSERT INTO klt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Me rina sán sánet wawu ámna náráwa erek hánám wa yánet, wata ku háleng rákit tángga átneráng!” ");
INSERT INTO klt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Angelo yá Iháng Hátiuk hang Israel yá Másáng Yisná Muná Náená watán rám káungá wata naráng hátingga umi sinak tátá watán rám yará yá árán du pris tátáwi yáni me lo yan tiksa watá kálu rekálu kilakon Jesu ket tángga utkámut tánin ingga suliuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Enendu ing miuráng, “Rám umi sinak rámá hára muná náuta ámna náráwa yá náhángga kuk tángga kun táng hilák tánirot.” ");
INSERT INTO klt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wahára wu Jesu wu it Betani káin ámna Saimon huphuráp ilalák lepra tángga átkiuk watán it káin sungngi nangga átnárán, náráwa káman áwuk watá máruk káman sup álosim hánám kutná alabasta watanan dá táng tolená wata kinan oel mungnganá kikiná ále kánang kutná nad wata uminá yá táng tolená yumnakngá táwi hánám bá yuyuwáyan tárák wa táng áwáng káting márák tángga oel wa Jesu yáilá káin kulin háuk. ");
INSERT INTO klt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wáina tán kangga ámna kámá wahára áturáng háranan watá pahán káráp hára yáni meme táuráng, “Náuta ku oel álo kámá wa táng lem tánggoek? ");
INSERT INTO klt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Oel wata supmá yá yara ore káman ni ukuro árená álo háláng yámámáyan tárák. Nándá wa táng yumnak tángga supmá wa iháng ni ukuro wa yámátne ku kándáng hálenggim,” wáina mengga náráwa wa me káto inángga me táng muráng. ");
INSERT INTO klt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wáina inát kangga Jesu yá yánuk, “Sat árik, náuta ku pahán márap imánggoeráng? Watá nák álo kámá hánám neháng tolek. ");
INSERT INTO klt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ni ukuro wawu rámá rámá sáni yot átneráng. Rina háláng yáminán du rám kámá wu wáina háláng yámineráng. Iná nák ku rámá rámá sányot ma átnándát. ");
INSERT INTO klt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Náráwa nátá álo tátáyan wawu wa táek. Watá oel sutna káin tek wawu árám kinan rám rina átnát wata tiyawing namek. ");
INSERT INTO klt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No pálipuk hánám ing sánin, káwakngá káwakngá Táwi yan me pingnga álosim meng isurát rehára rehára kuinek wawu náráwa nátá rina táek wa hányon mengga narángguineráng.” ");
INSERT INTO klt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wáina yánáng hálin du disaepelná 12 wata orek yáni háranan Judas Iskariot watá pris tátáwi yáin yáni yan káin Jesu táng yámán ket tátáya hangga kuk. ");
INSERT INTO klt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pris yáin yáni yá Judas yan me wa narángga herongnge hánám tángga sup kaminemán ing inuráng. Kulá Judas málámbá ku wahára átang gu kálu rekálu ku Jesu táng ket yáni hára tin ingga kálu ya suliuk. ");
INSERT INTO klt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kulá Israel yá Másáng Yisná Muná Náená watán rám hulátitiná wahára wu sipsip nanggená utang singga Angelo yá Iháng Hátiuk wata naráng hátingngátaráng, wahára wu disaepel yá Jesu inuráng, “Nándá rekáin kungga ku rám táwi watán sungngi tiyawitne ku nanaya narelák?” ");
INSERT INTO klt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wáina inát tu Jesu yá disaepelná yará suring yámángga yánuk, “Sán du it yáilá wata kinan kung hangga káinemálák ku ámna káman dá umi kátang tánggatang áwáng kálu hára sáháng tunggap táinek, wa isutang kuinemálák. ");
INSERT INTO klt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kungga it reta kinan han kangga ku it wata márumá ininemálák, ‘Tiksa yá ing mek, “Nákkán it pahálá ku re, wahára ku no disaepelna yot sungngi nangga Angelo yá Iháng Hátiuk ngá rám wata naráng hátinemán?”’ ");
INSERT INTO klt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wáina inán du it pahálá táwi torong káin kutná kutná wakáin erek tiyawená wa sálen du wakáin sungngi náni nanayan wa tiyawinemálák.” ");
INSERT INTO klt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wáina yánán disaepel yará yándi wu kumálák ngáyá it yáilá kinan káin wa kungga káumálák ku kutná kutná wu Jesu yá yánuk wáina hánám re há tunggafen kangga ku yándi wu sungngi wa há tiyawing háliumálák. ");
INSERT INTO klt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kulá it tá pup táuk wahára ku Jesu yá disaepelná 12 watyot áwáng hiuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kulá rám sungngi nangga áturáng wahára ku Jesu yá yánuk, “No pálipuk hánám ing sánin, káman nahára sungngi nangga átamán orek náni háranan káman dá ku nák neháng káyam ket yáni hára tin ket nehineráng.” ");
INSERT INTO klt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wáina yánán disaepelná yá narángga pahán yáni yá márawin yáni káman káman inuráng, “Nákka hám melák?” ");
INSERT INTO klt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wáina inát, Jesu yá yánuk, “12 sán háranan káman. Másáng iháng rápmám kinan nákkot satne háinek wata orek sáni háranan káman. ");
INSERT INTO klt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ámna Nanggená ya sutná hára rina tunggafefeya uyená wawu wáina há tunggafeinek. Iná ukuro hánám bu ni ámna yá Ámna Nanggená táng káyam ket yáni hára tinek wa, watán márapmá wawu táwi tái hánám, iná maming gá ámna wa ma táng tiuk iná wawu álo kámá,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kulá rám sungngi nangga áturáng wahára ku Jesu yá másáng táng Ánutu yan káin sáponga tángga hikhuk tángga disaepelná yámángga yánuk, “Ná ihániráng, náwu nák yánumna.” ");
INSERT INTO klt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wáina yánángga son hang wáin kap tángga Ánutu yan káin sáponga tángga yámán wahára erek nang hálit tu ");
INSERT INTO klt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","yánuk, “Náwu nák sipna ámna náráwa máro hánám bá Ánutu yot pahán káman háháleyan kule háek. ");
INSERT INTO klt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No pálipuk hánám ing sánin, no wáin son ma náindát, ináku máriya Ánutu yan átkuku mirak káin du wáin hurápmá wa náinet,” wáina ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kulá hang kap káman mantángga sangga ku hangga ále yáilá Olif káin kuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu yá disaepelná yánuk, “Sán erek hánám naráng hákhátik sáni yá han pitángga kuineráng, náuta me ing uyená yá átak, ‘No pin yáni tátá utkámut táe sipsip pá hánghánáng táineráng.’ ");
INSERT INTO klt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Enendu máriya tárutang sangga ku no kálak Galili káin kuinet.” ");
INSERT INTO klt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wáina men Pita yá miuk, “Iná kátu kámuk wata naráng hákhátik yáni yá han kepmáineráng hálen, nák ku ma kepmáindát.” ");
INSERT INTO klt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wáina men son Jesu yá Pita inuk, “Pálipuk hánám kanin, kula yáung nahára hurák ká rám yará ma mantáená árán du ko hánám puk ‘nák Jesu ma naráng mát’ ingga rám kaláhu meinelák,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Enendu Pita yá táng hángháláng tángga sonson ing miuk, “Nák ku kákkot álo kámutnet. Kák ka ma naráng kamát ingga ma meindát,” ing men disaepel kámuk árong wáina re miuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kulá ále kutná Getsemani káin kuráng ngáyá ku Jesu yá disaepelná yánuk, “Nahára putung átnárát no kung sáponga táin.” ");
INSERT INTO klt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wáina yánángga ku kátu yápmangga Pita, Jeims yot Jon wa re ihángga málám bot kunggatang pahálá yá káto hálengga márawiuk. ");
INSERT INTO klt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wáina hálendu yánuk, “Irukna yá táwi hánám márawin wata márapmá ná yá hála nutnándek. Nahára átang gu háleng rákit tángga átnárát.” ");
INSERT INTO klt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wáina yánángga Jesu málám isikimo kungga sim bu táng hang káwak hára kátingga sáponga táuk, wawu kálu kámá átak hálendu rám wáik watá táng háháti wáina ta. ");
INSERT INTO klt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Aba, Nanna,” ing miuk, “ko rina rina wawu álo tánggim re. Nák hára márapmá wa táng satá kuik. Enendu ko nákkán pahán ma isutnándalák ináku kakán pahán isutnelák.” ");
INSERT INTO klt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kulá son málám hurik tángga disaepelná yan káin áwángga kápuk ku ruhángga árát, Pita inuk, “Saimon, kák ka ruhángga átkoelák me? Rám hátetná kimo ma háleng rákit tángga átgim me? ");
INSERT INTO klt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hálengga sáponga tángga átneráng watá ku ingirungngi hára ma háindáráng. Pálipuk, pahán dá ku álo táinemán ingga narángngátaráng, enendu sut tá ku hálángngá muná.” ");
INSERT INTO klt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wáina mengga Jesu málám kung sáponga wanyon son táng hálingga sangga, ");
INSERT INTO klt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","son áwángga kápuk ku rahán yáni yá márawin ruhángga árát, málám iháng tárut táuk wahára wu wáina ininemán ingga kámá ma naráng hátiuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Málám son kuk ngáyá rám kaláhuná hára son áwuk wahára wu yánuk, “Sánda emá re ruhángga sek narángga átkoeráng me? Álo ruheráng! Rám bu áwek. Kaniráng, Ámna Nanggená táng mukmuro ámna ket yáni hára tinderáng. ");
INSERT INTO klt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tárurát kunin! Nák neháng ket yáni hára titi wawu ná áwek ná.” ");
INSERT INTO klt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Emá me yánángga átnárán du disaepelná 12 háranan Judas yá waháranyon há áwáng hiuk. Pris tátáwi yáni, lo yan tiksa me ámna hulá hulá watá suring yámát ámna tombong hásák táwi watá ket yánin du kápik honggem bot ihángga watyot áwáng hiuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ámna Jesu táng yámámáya tiyawiuk watá ku tárák ing táinet ingga huphuráppon ing há yánuk, “Ámna káman no kang kumeinet wawu Jesu ku wa, ket tángga pinná kándáng tángga ku tángga kuineráng.” ");
INSERT INTO klt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kulá Judas málám sopmuná ingmen Jesu rupmá káin kungga, “Tiksa!” ing inángga árong há kang kumiuk. ");
INSERT INTO klt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wáina tán kangga ámna tombong táwi watá ket tángga káto táuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kulá ámna káman enanggon hetang átuk watá árong kápikngá uyingga táuk ngáyá mangga pris táwi yáni yan yáup ámna hára kátin kápik ká kárámanná numkálu sating san háuk. ");
INSERT INTO klt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kulá Jesu yá wáina yánuk, “Nák ku tewe ámna tombong káman da máta yáreng yámámá hám, wáina hálendu sándá kápik kot honggem bot ihángga átang gu nák ket nehángga kunin ingga áweráng? ");
INSERT INTO klt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rámá rámá wu sáni yot há átkoet, Táwi yan it káungá hánám bán kumbi kinan me sánáng tolingga átninggoet, wakáin du ket ma neháng kuráng. Enendu Ánutu yan me yá rina mek watá kungga kándáng re háleinek,” ing yánuk. ");
INSERT INTO klt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kulá wahára átang gu disaepelná yá erek hánám sangga hárátiuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Rám wahára wu ámna máto káman lap káman re sutná hára tawángga Jesu isutang kungngárán, wa árong ket tángngárát ");
INSERT INTO klt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lap wa sangga muláng pitákngá kuk. ");
INSERT INTO klt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesu ket tángga sat warán tánggatang pris táwi yáni watán káin kut pris tátáwi yáni me ámna hulá hulá me lo yan tiksa watá kámuk áwáng háwuru táuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita málám Jesu isutang kuk, enendu kung mulangán sim átuk. Málám kung pris táwi yáni yan it kumbiná kinan káin kungga it pinná tátá yá káráp singga elengga árát tu watyot putung átang kárápmá elengga átuk. ");
INSERT INTO klt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kulá pris tátáwi yáni me kaunsel kámuk watá hulá rehára kungga ku Jesu utkámut tánin ingga hulá ya suliuráng, enendu hulá ya sulit men sáuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ámna máro hánám watá áwáng me kusák wa iháng tingga miuráng, enendu me yáni iháng áwáng miuráng watá kámá kámá háliuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kulá kámá yá ku tárutang Jesu ya me kusák ing miuráng, ");
INSERT INTO klt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ing men narumán, ‘No ámna yá Táwi yan it káungá hánám táená wa káting márák tángga son rám kaláhu kinan re nukngá táng tárut táinet wawu ket tá ma táindát.’” ");
INSERT INTO klt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enendu me yáni iháng áwáng miuráng watá wáinanyon kámá kámá háliuráng. ");
INSERT INTO klt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kulá pris táwi yáni watá kaunsel rahán yáni hára tárutang Jesu inuk, “Me hulá hulá kák ka menggoeráng wa rina? Kák ka me topmá kámá meinelák me muná?” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Enendu Jesu yá me topmá kámá ma yánuk, ináku náng ingmen átuk. Wáina árán pris táwi yáni watá son inuk, “Kák ku ámna Ánutu yá ámna náráwaná son iháháya miuk wa me? Ánutu nándá ináng sákngingngátamán wata Nanggená me?” ");
INSERT INTO klt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wáina inán du Jesu yá miuk, “Wawu nák. Hang káineráng gu Ámna Nanggená wu Ánutu Uliháláng Márumá wata ketná álák kálu putung átnek ngáyá alek kán mukam wata ketnán áwinek.” ");
INSERT INTO klt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wáina men narángga pris táwi yáni watá sutná káin lapmá tánggánengga átuk wa ráráhángga miuk, “Náuta ku me nukngá met nanaráya háleinemán? ");
INSERT INTO klt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Táwi yan kome tángga me mukmuro hánám wa há men naremán wata ku rina nareráng?” Wáina yánán kámuk hánám miuráng, “Me mukmuro hánám mek wata álo kámá ku kámurán sáliknginek.” ");
INSERT INTO klt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wáina mengga ku alup yáni málámba ketnán uráhángga lap pá rahálá pop tángga hárot kik táng sat árán, ket yáni mukátang utang gu inuráng, “Profet me meng, niyá nutak ingga!” Kulá waháranyon du it pinná tátá yá táng kung hányon uturáng. ");
INSERT INTO klt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita málám it ámang kálu kumbi kinan káin átang káráp elengga átnárán, pris táwi yáni yan yáup náráwa káman dá wahára áwuk ngáyá ");
INSERT INTO klt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita kárek ingmen kangga ku ing inuk, “Kák ku Jesu Nasaret nan watyot hányon átningngátalák.” ");
INSERT INTO klt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ing inán Pita yá oleng mángga inuk, “Pálipuk hánám ko náuta melák wawu nák ma narát.” Ingga inángga sangga málám kumbi kálu mungnganá tangtang kun waháranyon hurák káman dá mantáuk. ");
INSERT INTO klt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kulá son yáup náráwa watá káuk ku wahára árán, kangga ku ámna ále wahára hetang áturáng wa son yánuk, “Ámna náwu Jesu yan tombong.” ");
INSERT INTO klt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wáina men Pita yá son olengga, “Nák muná” ing miuk. Kulá isikimo átang sim bu ámna wahára hetang áturáng watá Pita inuráng, “Pálipuk kák ku Jesu yan tombong, náuta kák ku Galili nan yon.” ");
INSERT INTO klt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wáina inát tu Pita yá yánuk, “Pálipuk hánám Ánutu rahálá hára met, nák Jesu ma naráng mát! Kandák me hálendu Ánutu yá álo neháng lem táinek. Ámna wa menggoeráng wawu nák ma naráng mát!” ");
INSERT INTO klt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wáina yánángga árán waháranyon hurák ká son mantáuk. Kulá Pita yá Jesu yá me rina inuk wa naráng hátiuk: “Hurák ká rám yará ma mantáená árán du ko nák wa ma naráng mát ingga rám kaláhu meinelák.” Kulá wahára wu Pita yá pahálá utang táwi hánám wa kutuk. ");
INSERT INTO klt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kulá hilápmá hánám pris tátáwi yáni me ámna hulá hulá me lo yan tiksa hang kaunsel kámuk watá urum tángga rina tátá wa meng tolingga sat warán Jesu páup pá hárotang tángga kungga táng Pailat ketná hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wáina tát tu Pailat tá inuk, “Kák ku Juda yan king me?” Ing inán watá miuk, “Wa melák wáina,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kulá wahára wu pris tátáwi yáni watá me hulá hulá wa metne Jesu yá márapmá há suwik ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wa met Pailat tá son inuk, “Me kámá meinelák me? Kang, me wu rina kámá ingmen meng sat áwáng kákkán kálu átak.” ");
INSERT INTO klt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wáina inuk, enendu Jesu yá me topmá kámá ma inán Pailat tá hárámutuk. ");
INSERT INTO klt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kulá wahára wu Pailat tán kálu káman ing isutnándaráng, Angelo yá Iháng Hátiuk rám wahára wu Pailat tá ámna náráwa yan milun isutang it káto kinan nan ámna káman ni yáni kutná met tu wa yaling mán kep káin hangngátak. ");
INSERT INTO klt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rám wahára wu it káto kinan ámna káman kutná Barabas yot tu nuknukngá niyá Rom bán kapman yot honhoren tángga ámna kámá yot erawángga ráháng kátkámut táuráng watá árát, ");
INSERT INTO klt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ámna náráwa urum táwi watá áwáng Pailat inuráng, “Álo ka tángngátalák wáina táinelák me?” ");
INSERT INTO klt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wáina inát tu Pailat tá yánuk, “Juda yan king ná sáe kuinek ka nareráng me rina?” ");
INSERT INTO klt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wáina yánuk náuta watá ku há naruk pris tátáwi yáni watá Jesu málámbán yáup pa kalán yon táng áwáng ketná hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Enendu pris tátáwi yáni watá ámna náráwa pahán yánin hangga yánát tu Barabas ya re miuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wáina met tu Pailat tá yánuk, “Kulá Juda yan king ingga sáni menggoeráng náwu rina táng minet?” ");
INSERT INTO klt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wáina yánán, “Maripong hára kátiti!” ingga mantáuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wáina mantát Pailat tá yánuk, “Wawu náuta? Kandák rina táuk ka?” ing yánán narángga hahatingga hánám ing mantánggaturáng, “Maripong hára kátiti!” ");
INSERT INTO klt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kulá ámna náráwa urum táwi watá herongnge nanaráya wu Barabas yaling mán watán káin kun tewe ámna yánán honggem bá kálak Jesu urát tu maripong hára kátitiya sang yámuk. ");
INSERT INTO klt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kulá tewe ámna yáni waku Jesu engotang kapman dán it álosim kumbiná kinan kung hang átang tewe ámna áturáng wa erek ingmen mantát áwát tu ");
INSERT INTO klt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","lap sipsipmá hásák káman táng tánggáneng mángga páup rimrim ina táng áwáng king gán kálaháng ina yáilá yan tárák mang pondang yáilá káin sat hang átuk. ");
INSERT INTO klt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wáina erek ingmen tánggáneng máng sat árán du me kekkek sonson ing inuráng, “Juda yan king, kák ku kutya árená hánám!” ");
INSERT INTO klt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wáina inángga ku sonson ingmen honggem táng yáilá hára wa kátingga alup yáni málámba ketnán uráhángga áturáng. Yáni wu tun yáni hára imángga hangga ináng sákngingiya ina táuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wáina tángga ináng kekkek táng hálingga ku lap sipsipmá tánggáneng muráng wa yaling mángga ku málámbán hánám wa iháng son tánggáneng mángga ku maripong hára kátitiya engotang kuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ámna káman it yáilá Sairini nan kutná Saimon wawu Aleksenda káling Rufus nan yándi. Watá it yáilá Jerusalem kinan kung háin ingga tángngárán inángga suring mát Jesu yan maripong wa táng mángga kuk. ");
INSERT INTO klt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wáina tángga ku Jesu wu engotang ále káman kutná Golgata wakáin kuráng (kut wata hulá wu yáin kuratná watán ále). ");
INSERT INTO klt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kulá wakáin kung gu wáin táng kuram nukngá sut táng láláp tátáyan watyot táng yawák táená wa imuráng, enendu Jesu yá wa ma náuk. ");
INSERT INTO klt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wáina tán du táng maripong há kátená wahára ránam ting sat árán piring gá kátiuráng. Iná sut tánggánene wawu iháng horengga ting sat árán du kakarák laki wa tángga niyá ku náut ihinek wa kangga iháháya táuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesu táng piring gá kátiuráng wawu rám bu hilápmá 9 kilok hálengga árán, ");
INSERT INTO klt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","hulá resim hára táng me hára tiuráng wa uyingga táng maripong hára kátiuráng wawu ing: Náwu Juda yan King. ");
INSERT INTO klt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Rám wahára wu manek mara yará yot iháng wáinanyon maripong hára kátiuráng, káman ketná álák kálu hang káman ketná kandák kálu. ");
INSERT INTO klt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iná rám Jesu wa káting sat átuk wahára ámna náráwa niyá kálu wakálu áwángga kanggiuráng wawu me keke inángga yáin yáni kahondang gu menggiuráng, “Kulá! Kák ku Táwi yan it káungá hánám káting márák tángga rám kaláhu kinan re son táng tárut tátáya miulák. ");
INSERT INTO klt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kulá kayon ka háláng imángga maripong sangga hang,” ingga inánggiuráng. ");
INSERT INTO klt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iná pris tátáwi yáni me lo yan tiksa watá wu wáinanyon me keke ing mengga yáni inán kanán táuráng, “Kámá háláng yámángngátak, wáinanyon málámbá málámbon háláng imámáyan du muná! ");
INSERT INTO klt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pálipuk Ánutu yá ámna náráwaná son iháháya san áwuk, me pálipuk Israel yan king hálendu, maripong hára káting sat átak wa sangga han kangga ku nándá pálipuk ingga naráng háting minemán.” Ing met ámna yará Jesu inanyon káting sat átumálák watá wáinanyon ináng kekkek kon tángga átumálák. ");
INSERT INTO klt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kulá 12 kilok hálengga árán du ále káwak watá kámuk páyung tingga árán kungga yonyon kálu 3 kilok háliuk. ");
INSERT INTO klt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hang 3 kilok hálengga árán du Jesu yá hahatingga hánám ing mantáuk, “Eloi, Eloi lama sabatani?” Wata hulá wu ing, “Ánutuna, Ánutuna, náuta nepmáelák?” ");
INSERT INTO klt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wáina mengga mantán narángga ku kámá enanggon wahára hetang áturáng watá ku ing miuráng, “Narániráng, Elaija ya mantáng máng tek ka.” ");
INSERT INTO klt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kulá ámna káman dá ku hururung ingmen kung matres kátu ina táng wáin hára tin pumen táng kári hára yuwingga táng Jesu yá nanaya imángga ku miuk, “Sat málám re árán kanin, Elaija yá áwáng táng san háinek hám,” ingga miuk. ");
INSERT INTO klt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kulá Jesu yá hahatingga hánám mantángga ku kámutuk. ");
INSERT INTO klt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kulá Táwi yan it káungá hánám kinan lap maming táwi watá ku torong káin átang kung tárang káin pana huk ingmen ráráhángga numnum kuk. ");
INSERT INTO klt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iná tewe ámna táwi yáni wu Jesu kondolá kálu wahára átang Jesu yá mantáuk wa naruk me rina kámutuk wa kangga miuk, “Pálipuk hánám ámna náwu Ánutu Nanggená!” ");
INSERT INTO klt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hang rám wahára wu náráwa kámá hányon áwáng mulangán sim hetang átang kangga áturáng. Orek yáni hára wu Maria it Makdala nan, hang Maria ámna máto Jeims káling Joses mam yándi, hang káman du Salome. ");
INSERT INTO klt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Huphuráp Galili káin du náráwa urum watá hánám bu Jesu isutang átningga ku hahaná rina hálenggiuk wawu watá háláng imánggiuráng. Iná náráwa kámá wahára máro yon áturáng wawu Jesu málám bot Jerusalem káin wa áwuráng watá áturáng. ");
INSERT INTO klt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kulá rám tembát tu Sabat ingga ku tiktiyawik tátá rámá wáina hálendu yonyon há hálen kangga ku ");
INSERT INTO klt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep it Arimatea nan wawu málám bu kaunsel me ámna náráwa yá ámna álosim ingga há naráng meráng, iná málám wawu Ánutu yan átkuku wata hálengga átnándak. Josep pu ma pitáuk ináku Pailat rupmá káin kung hengga Jesu yan káwak sut wa namáng ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wáina inán Pailat tá Jesu wu há kámutak wa narángga hárámutang gu tewe ámna táwi yáni wa mantán áwán inuk, “Jesu wa pálipuk há kámutak me?” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kulá Pailat málám tewe ámna táwi yáni watán káin pálipuk ingga kándáng narángga sangga ku káwak sut wa álo táinelák ingga Josep inuk. ");
INSERT INTO klt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wáina inán Josep málám lap hásák káman yungga táng kung Jesu tambun wa táng hang lap watá kámuk pondang táng kung sup hinangngá káling tolená wakáin tingga, árong sup táwi káman kiwolán áwáng hinangngá wa pop tángga átuk. ");
INSERT INTO klt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kulá Maria it Makdala nan me Maria Joses maming wawu há átang gu Jesu tambun táng rehára teráng ingga wawu há kápumálák. ");
INSERT INTO klt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat hára sek nanará rámá watá sálin du Maria it Makdala nan, Maria Jeims maming hang Salome watá kutná kutná mungngan yáni kikiná wa yungga ihángga kung Jesu sutná káin kuháng mámáya tiyawiuráng. ");
INSERT INTO klt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sonda hulátitiyan rám hulátiuk wahára wu káe yá áráng hen waháranyon tanggán káin kuráng. ");
INSERT INTO klt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kálu káin kungga átang gu yáni inán kanán táuráng, “Tanggán hinangngá hára sup táwi wawu niyá kiwolán kuinek?” ");
INSERT INTO klt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wáina mengga kung hengga tanggán hinangngá hára hálengga káuráng gu sup maming táwi wawu há kiwon hong tená. ");
INSERT INTO klt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kulá tanggán hinangngá hára kung hangga káuráng gu ámna máto káman lap hásák haknga tánggánená watá ket álák kálu putung árán kangga ikik hárámutang pitáuráng. ");
INSERT INTO klt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wáina tát kápángga watá yánuk, “Ma pitáindaráng. Sán du Jesu Nasaret nan táng maripong hára kátiuráng wata suleráng. Wawu son há tárutang koek! Nahára ma árak. Áwángga táng tiuráng ngá komená wata kaniráng. ");
INSERT INTO klt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kulá kungga ku Pita yot disaepelná nukngá yánineráng, ‘Jesu wu watá kálak Galili káin koek. Málámbá me rina sánuk wa isutang Galili káin kungga káineráng.’” ");
INSERT INTO klt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wáina yánán nanará yáni yá yakyawin yángyáng pálak náráwa kaláhu wawu hangga tanggán wa sangga hururung ingmen kuráng ngáyá kung pikpito narángga ni kámá káman ma inuráng. ");
INSERT INTO klt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rám sonda hulátitiná hára ku Jesu yá son tárutang kungga hulátingga hánám bu Maria it Makdala nan watán káin kálak tunggafiuk. Náráwa wawu huphuráp Jesu yá iruk wáik 7 yásut muk wa. ");
INSERT INTO klt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Náráwa málám kuk watá kung nini Jesu yot átninggiuráng watá pahán yáni márapmá narángga kutang átkuráng wa ing yánuk, ");
INSERT INTO klt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jesu ku son tárutak, no há káet,” ingga yánuk, enendu watán me wawu kusák ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kulá máriya ku Jesu yá málámbán tombong háranan ámna yará yá Jerusalem sangga kálu hára kungga átnárán tárák kámá hálengga watán káin tunggafeng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wáina kangga ámna yará watá son áwáng wáina káemát ingga nuknuk yándi wa yánumálák, enendu watán me wa kusák kon ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Máriya ku Jesu yá disaepelná 11 dá sungngi nangga átnárát watán káin tunggafeng yámángga, naráng hákhátik yáni káto muná hang kámutang son tárurán há káemán ingga yánát kusák ingga naruráng wata me táng yámuk. ");
INSERT INTO klt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Málám ing yánuk, “Kuineráng watá kungga káwakngá káwakngá erek ingmen kung hálingga ámna náráwa erek ingmen me pingnga álosim ná yánángga kuineráng. ");
INSERT INTO klt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ámna náráwa niyá nákka naráng háting namángga umi kuhinek wawu Ánutu yá son tán málámbán pingnga hálinek. Iná niyá nákka ma naráng háting namindák wawu Ánutu yá isurán átkuku wa ma táindák. ");
INSERT INTO klt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kulá Ánutu ya naráng háting mángga átneráng wawu tárák ing tát kápineráng: Nák kutna hára iruk wáik yásut yámángguineráng, me nukngá kámá ma narená wa álo me tángguineráng, ");
INSERT INTO klt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kunap ket yáni yá ihángguineráng, náut kámá ámna iháng lem tátáyan náineráng enendu watá ma iháng lem táindák, hang ket yáni yá ilalák mara ihánggápát ilalák ká álo háleng yámángguinek.” ");
INSERT INTO klt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Táwi Jesu yá me wa yánáng hálingga árán du Ánutu yá tángga árángga alek káin kungga ketná álák kálu ting san putung átkoek. ");
INSERT INTO klt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kulá wahára átang gu disaepel yá hangga itná itná erek ingmen kungga me pingnga álosim wa yánángga kuráng. Táwi málámbá disaepel yot átang háláng yámángga me menggiuráng wa táng káto táng yámámáya ket tárák hulá hulá wata ket yáni hárá tánggiuk. ");
INSERT INTO klt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ámna táup pá yon tárák ka Ánutu yá yáup rina táuk watán me pingnga uyiuráng watá áwáng rám nahára páliná yá hiták tunggafen kanggoemán. ");
INSERT INTO klt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hulátingga hánám niyá rahán yáni yá kangga Ánutu yan me watán yáup nangge hálengga áturáng watá yon meng isurát áwángga nándán káin áwuk wanyon uyiuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wáina kangga ku na hulátingga kándáng hánám yánáng sulingga narut ná wa, álo kámá ku no hányon uyin ingga narángga ku wa táng tombong hára tingga, ámna hulá Tiofilas, kákkán da uying kamet. ");
INSERT INTO klt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wa kangga ku me rina narulák wawu pálipuk ingga narinelák. ");
INSERT INTO klt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia yan king kutná Herot watán rám hára pris káman kutná Sekaraia wawu pris Abiya watán tombong háranan, iná áwáná Elisabet wawu Aron dán tombong háranan. ");
INSERT INTO klt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yándi wu Ánutu rahálá hára kándáng hánám wa átnándamálák, me Táwi yan meng rákit mená rina átaráng wa kándáng hánám isutnándamálák. ");
INSERT INTO klt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Enendu nangge yándi wu muná. Elisabet wawu náráwa kátoná hálendu nangge ma iháng tingngátak, wata ku yayará hánámá átang kungga ku há tátáwi háliumálák. ");
INSERT INTO klt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Rám káman Sekaraia yan tombong gá pris yáup tátáya kuráng ngáyá ku Sekaraia málám Ánutu rahálá hára átang yáup táuk. ");
INSERT INTO klt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kulá pris yá kakarák káman satu wa tát Ánutu yá wahára kungga Sekaraia táng tunggap tán du Táwi yan it káungá hánám kinan hangga towet mungnganá kikiná sinek ka. ");
INSERT INTO klt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Towet sisi rám wahára wu ámna náráwa táup hánám watá Táwi yan it káungá hánám kep káin urum átang sáponga tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rám wahára ku Táwi yan angelo yá tunggafeng mángga towet sisiyan tingnaknak tákto ket álák kálu hetang átuk. ");
INSERT INTO klt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wáina kangga Sekaraia málám ikik ingmen hárámutang pikpito hánám naruk, ");
INSERT INTO klt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","enendu angelo yá ing inuk, “Sekaraia, ma pitáindalák. Ánutu yá kákkán sáponga wawu há naruk. Áwáka Elisabet wawu nanggeka ámnaná táinek, wata kutná ku Jon mantáinelák. ");
INSERT INTO klt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Watá ku pahála táng láláp tán álo kámá hánám narángga heronge háleinelák, iná ámna náráwa táup hánám watá Jon dá tunggafeinek wata heronge táineráng, ");
INSERT INTO klt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","náuta Táwi rahálá hára wu Jon kutná yá táwi hánám háleinek. Watá wáin me umi káto nukngá átaráng wa ma nang kuindák, iná nangge wawu manyon tunggafená mam kinan átnek waháranyon Iruk Káungá watá watyot átnek. ");
INSERT INTO klt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Watá tán Israel nan ámna náráwa táup hánám watá pahán yáni hurik tángga Táwi yáni Ánutu yan káin kuineráng. ");
INSERT INTO klt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Watá Elaija yan tárák me háláng wa tángga watá kálak áwán du Táwi yá áwinek. Wáina tán du nanan yáni yan pahán wa táng hurik tán nángánangge yáni ya pahán yámineráng, me milun yayali ámna náráwa watá nanará álosim tángga ámna náráwa kándáng hálineráng, hang ámna náráwa tiyawing yámán Táwi ya háleng mineráng.” ");
INSERT INTO klt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wáina inán Sekaraia yá angelo wa inuk, “No rina tángga ku kákkán me ná pálipuk ingga narinet? Nawu tátáwi hánám me áwána wu wáinanyon tátáwi yon.” ");
INSERT INTO klt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kulá angelo yá inuk, “Nák ku Gabriel. Ánutu kondolá hára hetang átnándat wa suring namán me pingnga álosim ná kák kakanáya áwet. ");
INSERT INTO klt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wata kula wu me ma me táená árátá kungga rám rina hára me kanet náta páliná yá tunggafeinek, náuta ko nákkán me ná pálipuk ingga ma narálák wata, me náwu pálipuk hánám há tunggafeinek rámá wu Ánutu yá narek hára wa,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iná ámna náráwa yá ku Sekaraia ya hálengga átang gu narángpak tángga átkiuráng rina tángga ku Táwi yan it káungá hánám kinan rám hásák átkoek ingga. ");
INSERT INTO klt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wáina átang áwáng kep káin háuk wahára káuráng gu ma kápáng mená ket tárák re tángga átuk, wáina hálendu it káungá kinan káin tárák kámá káek ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wáina re átang kungga watá yáup tátá watá sálikngin du hangga itná ya kuk. ");
INSERT INTO klt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wata sárummá káin átang árongga áwáná Elisabet tu kawilá átuk hálendu yap 5 wata kinan wawu kilakngá re átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iná Elisabet tá ku miuk, “Táwi yá yon men du nátá tunggafeng namek. Málámbá pahán láláp namán ámna náráwa rahán yáni hára reprepmá watá sáliknging namek.” ");
INSERT INTO klt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet tá kawin yap 6 há árán du Ánutu yá angelo Gabriel wa suring mán ále Galili kinan it Nasaret wakáin kuk, ");
INSERT INTO klt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","wawu kungga náráwa máto hurup hánám káman kutná Maria watán káin kuk. Iná náráwa máto wawu ámna kutná Josep wa tátáya pingnganá meng sat árán, ámna wawu Dewit tán tombong háranan. ");
INSERT INTO klt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelo Gabriel watá Maria yan káin kungga ku inuk, “Káe álo, náráwa kák, kák ku Táwi yá kákkot átang pahán kamek.” ");
INSERT INTO klt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wáina inán narángga Maria yá hárámutang narángpak tángga ing naruk, “Me náwu rina hánám?” ");
INSERT INTO klt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wáina tán kangga angelo yá inuk, “Maria, ma pitáindalák. Ánutu yá pahán álosim kák ka naráng kamek. ");
INSERT INTO klt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Narelák, kák ku kawila átang nangge ámnaná táng tinelák, wata kutná wu Jesu ing mantáinelák. ");
INSERT INTO klt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Watá kutná yá táwi hánám hálengga kungga árán du Ánutu yá kut ing iminek, Ánutu Árená Hánám wata Nanggená. Táwi Ánutu málámbá táng táwiná Dewit tá kut táuk kut wáinanyon wa imán ");
INSERT INTO klt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","watá wu Jekop pán tombong gán king hálengga rámá rámá átang kungga ámna náráwa pin yáni tátáyan háláng wa tángga átang kung kuinek.” ");
INSERT INTO klt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wáina inán Maria yá inuk, “Rina tángga ku wáina tunggafeinek? Nák ku máto hurup hánám átat.” ");
INSERT INTO klt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wáina inán angelo yá inuk, “Iruk Káungá watá kákkán káin áwán du Ánutu Árená Hánám watán háláng watá kák keháng támorán du rongrongngá káungá hánám máriya tunggafeinek wawu Ánutu Nanggená ing mantáng mineráng. ");
INSERT INTO klt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wáinanyon Elisabet sipya kátu wawu náráwa kátoná nangge ma tátáyan tátáwi watá kawilá árán yap 6 hálengga átak wawu nangge ámnaná táng tinek. ");
INSERT INTO klt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ánutu yá náut kámá káman ma tátáyan kámá ma árak.” ");
INSERT INTO klt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wáina inán Maria yá inuk, “Nák ku Táwi yan yáup náráwa. Nák hára rina tunggafefeya melák wawu wáina álo tunggafeinek,” ingga inán du angelo yá sangga kuk. ");
INSERT INTO klt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Rám wahára Maria yá sopmuná ingmen tiyawingga it káman Judia ále káin ále yáilá isikikimo átaráng wakáin kuk ");
INSERT INTO klt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ngáyá kung Sekaraia yan it kinan hangga heronge me Elisabet inuk. ");
INSERT INTO klt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wáina inán Elisabet tá Maria yan me wa naruk waháranyon nangge kawin kinan átuk watá háták árángga han du Elisabet wawu Iruk Káungá watá áwáng ep táuk. ");
INSERT INTO klt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wáina tán du hahatingga hánám mantáuk, “Táwi yá álo kámá hánám keháng tolingga kuram kák kamuk watá kuram náráwa kámá yámuk wa iháng hátek, me nangge táinelák wawu kuram hányon imuk! ");
INSERT INTO klt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Enendu nák ku rinaná hálendu Táwina wata maming gá nákkán káin áwek? ");
INSERT INTO klt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rám ko heronge me nanelák watá kung kárámanna káin háek waháranyon nangge kawinna kinan watá heronge tángga háták árángga háek. ");
INSERT INTO klt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Táwi yá wáina tunggafeinek ingga kanán pálipuk ingga narulák, wata ku kákkán káin kuram bá kuinek!” ");
INSERT INTO klt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria yá ing miuk, “Pahánna yá Táwi kutná meng tárut táet, ");
INSERT INTO klt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iná irukna yá ku Ánutu háláng nanamá wata heronge táng mek, ");
INSERT INTO klt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","náuta nák ku ále hánám ina enendu yáup náráwaná nák, málámbá neháng toktolik tángngátak. Rám inggálu me máriya átang kuinek kálu ámna náráwa kámuk ká, ‘Ánutu yá kuram álosim wáina táng muk,’ ingga mengguineráng, ");
INSERT INTO klt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","náuta Ánutu Ulihálángngá Pálak watá kutná táwi hánám nákka táng namek. Kutná watá káungá hánám átang kuinek. ");
INSERT INTO klt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Watán ukuro watá kung nini wata naráng háting mángga átaráng watyot átnek, ámna náráwa rám nahára átaráng me ámna náráwa máriya tunggafengga áruineráng. ");
INSERT INTO klt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ketná yá yáup tátáwi hánám wa tángga, ámna niyá nák ku árená ingga átnándaráng wa iháng hánghánáng tán káman káman táuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Watá king tátáwi wa iháng hang tingga ámna kut yáni muná wa ihángngáráng tiuk. ");
INSERT INTO klt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ámna niyá háing yámán áturáng wa kutná kutná álosim sing yámán nangga kawin yáni háhátiuk, iná niyá kutná kutná yáni pálak áturáng wawu yásurán hangga hánámá há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ánutu yá táwi ilom náni me rina yánuk wa isutang yáup nángánanggená Israel nán háláng námuk, me pahán káman mená rina miuk wa naráng hátingga Abraham bot ráulaná nán urák náni naruk.” Maria yá me wáina meng háliuk. ");
INSERT INTO klt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria málám Elisabet yot yap kaláhu náut wáina átang sangga ku son itná hulá ya kuk. ");
INSERT INTO klt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kulá Elisabet tá nangge tátáyan rámá yá há áwán du nanggená ámnaná táng tiuk. ");
INSERT INTO klt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet tán it hulá me sipmá kátu watá Táwi yá pahán ukuro táwi hánám wáina naráng mek ingga pingnga naruráng hára ku kámuk áwáng háláng imángga wata herongená táuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yáni wu árát kungga rám 8 hálendu kepmá mamaráya áwuráng ngáyá ku áwáng nangge wata kutná wu Sekaraia naning kutná wanyon imánin ingga táuráng, ");
INSERT INTO klt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","enendu maming gá ing yánuk, “Muná! Kutná ku Jon mantáinemán.” ");
INSERT INTO klt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wáina men nuknukngá watá inuráng, “Náula yot sándán hun me tombong háranan káman da kut ná kámá wáina muná.” ");
INSERT INTO klt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wáina hálendu son naning ga ket tárák táng muráng, nangge wata kutná wa ni ing meinek ingga. ");
INSERT INTO klt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kulá naning málám árong náut kámá káman kolem uyiyiyan da yánán táng imát uyiuk ku, “Kutná wu Jon,” ingga uyin kangga hárámutang nangnga yáni háuk. ");
INSERT INTO klt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Waháranyon du son mená me tángga Ánutu kutná meng tárut táuk. ");
INSERT INTO klt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wáina tán kangga ku itná hulá watá nangnga yáni han pahán yáni kinan pikpiták táuráng, hang waháranyon pingnga watá ále yáilá isikikimo Judia kinan erek kung hálin narángga wáina wáina ingga mengga narángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kulá ámna náráwa niyá pingnga wa naruráng watá ku hárámutang nanará yáup táwi tángga ku yáni meme táuráng, “Nangge wawu máriya ámna rinaná hánám háleinek?” Táwi yan háláng watá watyot átuk, wata ku wáina miuráng. ");
INSERT INTO klt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kulá Iruk Káungá watá nangge wata naning Sekaraia hára ep táwi tán du watá profet me ing miuk, ");
INSERT INTO klt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Táwi Israel yan Ánutu wata kutná meng tárut tánin, náuta watá áwáng ámna náráwaná son há ihinek. ");
INSERT INTO klt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yáup nanggená Dewit tán tombong hára kungga ku ámna hánghálángngá táwi káman háláng nánámáyan da námuk, ");
INSERT INTO klt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","wawu uláp profet káungá milun yáni hára me miuk wanyon isutang háláng námángga kuinek. ");
INSERT INTO klt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Káyam ket yáni hára me rendá pahán ma námáráng wata ket yáni hára son há náhinek, ");
INSERT INTO klt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","wawu uláp tátáwi náni urák yáni narángga pahán káman mená káungá hánám tiuk wa naráng hátingga isutang átkoek. ");
INSERT INTO klt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Me káto hánám málámba kutná háranyon mengga táwi náni Abraham inuk, ");
INSERT INTO klt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","wawu káyam ket yáni háranan son nánáháya, wáina tán du nándá rámá rámá málámba rahálá hára rongrongngá kándáng re átang watán yáup tátáya, narángpak me pikpiták tángga átnát ta muná. ");
INSERT INTO klt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Iná nanggena kák ku máriya Ánutu Árená Hánám watán profet ing mantáng kamineráng, náuta ko kálak kungga ku Táwi yan kálu sareng mángga kuinelák. ");
INSERT INTO klt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ko kátu náni sasa wahára kungga son náhinek ingga nanará wa metá narinemán, ");
INSERT INTO klt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","náuta Ánutu yá pahán yot ukuro naráng námángngátak, wáina wata ku alek káin káe yá áráng hengga yamá wa man káwak káin nándán da háinek. ");
INSERT INTO klt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yamá wa háinek wawu hang niyá páyung hára me kátkámut tán yongnga hára átaráng wa átkuku yan kálu yálen wa isutang kuineráng.” Sekaraia yá profet me wáina meng háliuk. ");
INSERT INTO klt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kulá máriya ku nangge watá tihangga iruk hára káto hálengga kuk ngáyá ále komkomá ámálum re káin wa átkiuk. Átang kungga rámá hálendu áwángga Israel rahán yáni hára hiták háliuk. ");
INSERT INTO klt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Rám wahára it yáilá Rom watá ále káwak pin yáni tángga áturáng, me Kuirinius yá provins Siria yan kawana átuk. Wata kinan Sisa Ogastas yá meng rákit me káman tiuk wawu ing, ámna náráwa kut yáni erek hánám wa uying hálineráng, wáina hálendu ámna náráwa yá it yáni hulá hánám káin kung árát tu kut yáni iháháya miuk. Wawu Rom bá hulátingga hánám ámna náráwa kut yáni uyiuráng. ");
INSERT INTO klt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kulá Josep wawu hunná wu Dewit háranan itná hulá Betlehem, wáina wata ku it Nasaret ále Galili káin átuk wa sangga it Betlehem ále Judia ya kuk. ");
INSERT INTO klt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep málám kukuya ku árong Maria áwáná ya tátáya pingnganá há ináng sat átuk watyot kumálák. Iná Maria wawu kawilá pálak. ");
INSERT INTO klt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kulá rám kung Betlehem káin átumálák wahára wu Maria yá nangge tátá rámá yá áwán, ");
INSERT INTO klt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","nangge yáilá táng tiuk wawu nangge ámnaná. Málám nangge tángga táng lap kuliná yá támotang táng bulmakau yá sungi náená rápmám wata kinan ting san átuk, náuta lombu it wawu há tuwaturáng. ");
INSERT INTO klt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kulá ore waháranyon du sipsip pin yáni tátá wawu it Betlehem tangtang káin yáungán sipsip yáni pin yáni tángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kimo átang káuráng gu Táwi yan angelo yá tunggafiuk wahára wu Táwi yamá yá yáni yot iháng támotang árán kangga pikpito táwi hánám narángngárát tu ");
INSERT INTO klt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","angelo yá yánuk, “Ma pitáindaráng. No me pingnga álosim tángga áwet. Ámna náráwa kámuk hánám bá pingnga ná narángga ku heronge táwi hánám táineráng. ");
INSERT INTO klt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kula Dewit tán it káin náráwa káman dá nangge táng tek. Nangge watá wu máriya sán kámuk háláng sáminek, wawu Táwi, ámna náráwaná son iháháya háek. ");
INSERT INTO klt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iná tárák ku ing káineráng, nangge káman lap kuliná yá támotang táng bulmakau yá sungi náená rápmám wata kinan ting sat átnek.” ");
INSERT INTO klt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wáina meng hálin waháranyon angelo alek káinnan tombong hásák ká yon hang sengsáráp tit kámuk Ánutu kutná ing meng tárut táuráng, ");
INSERT INTO klt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ánutu Árená Hánám, kutná meng tárut tánin, iná káwak káin ámna náráwa nini Ánutu yá pahán yámán átaráng watá pahán láláp átneráng.” ");
INSERT INTO klt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kulá angelo watá yápmangga alek káin kut tu sipsip pin yáni tátá watá yáni meme tángga ing miuráng, “Betlehem káin kungga náutá tunggafek ngáya Táwi yá nánek wata kanin.” ");
INSERT INTO klt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ing mengga sopmuná ingmen hangga kungga suling kung káuráng gu Maria káling Josep pot nangge wawu bulmakau yá sungi náená rápmám wata kinan pándák ting san árán. ");
INSERT INTO klt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yáni wu kung há kangga sangga ku nangge wata angelo yá rina yánuk wa meng isurát kuk, ");
INSERT INTO klt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","iná ámna náráwa niyá sipsip pin yáni tátá yá me wa met naruráng watá ku hárámutang nangnga yáni háuk. ");
INSERT INTO klt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Iná Maria yá ku me, me tárák rina rina nangge watán kálu tunggafiuk wa erek iháng pahálá káin tingga ku naráng hátingga átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kulá sipsip pin yáni tátá yáni wu angelo yá me rina yánán naruráng wa isutang kung rahán yáni yá wáina hánám há kangga ku Ánutu ya heronge táng máng táng máng son kuráng. ");
INSERT INTO klt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesu yá tunggafengga rám 8 árán du kepmá marángga ku kut Jesu wa imuráng. Kut wawu huphuráp ma tunggafená árán yon angelo yá Maria há inuk. ");
INSERT INTO klt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kulá Moses yan meng rákit me wa isutang rám rina átang Táwi rahálá hára rongrongngá háháleya tená watá sálikngin du Josep káling Maria yá Jesu nangge wa tángga Jerusalem káin Táwi imámáya kumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wa kumálák wawu Táwi yan meng rákit me ing uyená wa isutang, “Nangge ámnaná hulátingga hánám náráwa káman dá táng tinek wawu táng Táwi yan pingnga tineráng.” ");
INSERT INTO klt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hang Táwi yan meng rákit me ing uyená, “iráp balu yará me kámut máto yará waháranan yará,” iháháya mená wa isutang iráp yará yot ihángga Táwi ya taha ting mámáya kumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iná Jerusalem káin ámna káman wakáin átnándak wawu kutná ku Simion. Ámna wawu kándáng hánám átang rámá rámá Táwi yot ronrosin hánám árán Iruk Káungá watá watyot átnándak. Simion wawu Ánutu yá Israel pahán láláp yáyámáya miuk wata hálengga átnándak. ");
INSERT INTO klt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iruk Káungá watá há inuk, “Kák ku ma kámurená átang Táwi yá ámna náráwaná son iháháya ámna san áwáwáya miuk wa há káinelák.” ");
INSERT INTO klt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kulá Iruk Káungá watá engorán málám kungga Táwi yan it káungá hánám kumbiná wata kinan kung háuk. Rám Jesu naning maming gá meng rákit me yá rina mek wa tátáya tángga áwán, ");
INSERT INTO klt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion málám árong nangge wa táng poláng mángga átang Ánutu kutná ing meng tárut táuk, ");
INSERT INTO klt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Táwi, nák ku yáup nanggeka. Uláp miulák wáina nepmatá no kung pahán láláp hára átang kámutnet. ");
INSERT INTO klt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ko kálu rina tángga son nánáháya táulák wawu na rahánna yá há káet. ");
INSERT INTO klt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ko ámna náráwa rahán yáni táwi hára wa tiyawing námulák ");
INSERT INTO klt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","wawu kup, kup watá yamá mangga Ánutu yan átkuku wa ámna náráwa káwak kámá káinnan wa yáleinek, me kákkán ámna náráwa hánám Israel wata kut yáni meng tárut táinek.” ");
INSERT INTO klt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wáina men narángga nangge wata naning maming gá hárámutang nangnga yándi háuk, ");
INSERT INTO klt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","enendu Simion dá kuram táng yámángga sangga nangge wata maming Maria inuk, “Ánutu yá nangge ná táng tunggap táuk watá tán Israel nan táup hánám naráng hákhátik yáni muná átaráng watá háineráng, hang táup hánám naráng hákhátik yáni pálak watá árángga kung átneráng. Iná nangge wahára ku Ánutu yan tárák watá wahára árán kangga ámna náráwa táup hánám watá meng mineráng. ");
INSERT INTO klt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wáina wata ku ámna táup hánám watán pahán káin kilak árená wa táng hiták tit, kawu kápik ká pahála káin keháng topmet ina narinelák,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Kulá profet náráwa káman átkiuk kutná wu Ana wawu Fanuel uriwa Aser yan tombong háranan. Iná málám bu náulá yot ket tántán tángga yara 7 rewe átang náulá yá kámurán du náráwa kawát átang kungga tátáwi hánám háliuk wawu yaraná 84. Málám bu Táwi yan it káungá hánám ma sangngátak, káen yáungán Táwi ináng sákngingga átnándak. Iná rám kámá ku sungi sangga sáponga tángtáng tángngátak. ");
INSERT INTO klt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Rám waháranyon hánám hiták áwáng hengga Ánutu ya heronge táng mángga ku ámna náráwa Jerusalem hára Ánutu yá háláng námik ingga hálengga áturáng wa nangge wata yánángga kuk. ");
INSERT INTO klt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kulá Josep káling Maria yá Táwi yan meng rákit me yá rina tátáya mená wa erek táng hálingga ku son hurik tángga ále Galili káin it yáni Nasaret ta kuráng. ");
INSERT INTO klt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iná nangge watá ku hánghálángngá tingtihang nanaráná yá álosim hánám hálengga árán, Ánutu yá kuram táng mángga kungga átuk. ");
INSERT INTO klt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yaraná yaraná wu Jesu naning maming gu Jerusalem káin rám táwi Angelo yá Iháng Hátiuk wa kakaya kungngátamálák. ");
INSERT INTO klt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hang Jesu wawu yaraná 12 hálengga átuk wahára wu kálu rina isutnándaráng wanyon isutang Jerusalem káin rám yáni táwi wa kakaya kuráng. ");
INSERT INTO klt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Rám táwi watá sálikngiuk wahára wu nangge máto Jesu wawu Jerusalem káin há árán naning maming gu wáina ingga ma narená sangga kumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yándi wu nuknuk yáni watyot há koeráng ingga narángga ku káe káman wa há kuráng ngáyá ku sip yáni kátu me nuknuk yáni watyot áweráng ingga wata orek yáni káin wa táng sulingga kumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yándi wu táng sulin men du son kungga Jerusalem káin sulindin ingga wakáin kumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kulá yándi wu sulingga átkun rám kaláhu hálendu kungga káumálák ku nangge yándi Jesu wu Táwi yan it káungá hánám kumbiná kinan káin wa tiksa orek yáni káin putung átang me met narángga son yánáng sulingga árán, ");
INSERT INTO klt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ámna wahára áturáng watá watán me wa narángga hárámuturáng, náuta nanaráná me, me táng hurik táng yámángga átuk wa kangga. ");
INSERT INTO klt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kulá naning maming gá káumálák hára wu nangnga yándi han maming gá inuk, “Nanggena, náuta ket wáina nálelák? Nanya yot nátá kák ka narángpak tángga suling kamángga átninggoemát.” ");
INSERT INTO klt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ing inán Jesu yá ing yánuk, “Sándu náuta wu nák ka suling namángga átninggoemálák? Álo kámá ku no Nanna yan it káin átnet wa naremálák me muná?” ");
INSERT INTO klt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wáina yánuk enendu naning maming gá wáina ta nánek ingga wu ma naráng rákit táumálák. ");
INSERT INTO klt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kulá wahára átang gu naning maming got Nasaret káin kuráng ngáyá ku milun susuwá re táng yámángga átninggiuk, iná maming gu me, me tárák rina rina tunggafiuk wa iháng pahálá káin tingga ku naráng hátingga átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iná Jesu málám bu táwi hángháleng nanaráná yá álo kámá hánám háliuk. Ánutu yá wa kan álo kámá hánám háliuk, wáinanyon ámna náráwa yá kat álo kámá yon háliuk. ");
INSERT INTO klt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiberius yá Rom bán king hálengga yara 15 átuk wahára wu Pontius Pailat tá provins Judia yan kawana árán, Herot tá distrik Galili pinná tán kulaná Filip pá distrik Ituria yot Trakonitis pin yándi tán du Lisanias yá distrik Abilene pinná táuk. ");
INSERT INTO klt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kulá Anas káling Kaiafas yá ku pris yáin yáni ya átumálák, wahára ku Sekaraia nanggená Jon wawu ále komkomá ámálum re káin wa árán Ánutu yá áwáng málámbán me wa wakáin Jon inuk. ");
INSERT INTO klt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Inán hangga kuk watá kungga Jodan umi tangtang káin áturáng wa yánuk, “Sándá pahán hurik tángga áwáng umi kuhát tu Ánutu yá mukmuro sáni wa yawonek.” ");
INSERT INTO klt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kálu wa tunggafiuk wawu profet Aisaia yá Ánutu yan me ing uyiuk wa isutang: “Man dá ále komkomá páliná muná káin ing mantáinek, ‘Táwi yan kálu tiyawineráng, kálu kándáng hánám táng toling mineráng. ");
INSERT INTO klt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ále pahálá átaráng wa erek ingmen molát tuwarát, ále yáilá me ále kangkandángngá átaráng wa erek ingmen ping yanyawon táineráng. Kálu tulátulá árená wa tát kándáng re hálet, kálu wáik wa táng toktolik tát kándáng re hálineráng. ");
INSERT INTO klt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wáina hálendu ámna náráwa kámuk hánám watá Ánutu yá son ihinek wa hiták káineráng,’” ingga wáina uyiuk. ");
INSERT INTO klt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kulá Jon dá ámna náráwa káwan táwi umi kuháng námik ingga áwuráng wa yánuk, “Sán kunap wáik nángánangge, Ánutu yá pahán káráp táng sámángga sáháng lem táinek. Niyá sánán pitángga kungga rám wáik sándán káin tunggafein ingga táek wa táng háhátiya táeráng? ");
INSERT INTO klt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sándá pálipuk pahán hurik hánám táeráng hálendu tirik tárák sáni watá meinek. Hang sáni ya mengga, ‘Nándu Abraham e ilommá,’ ingga ma meindaráng. No ing sánin, Ánutu yá sup ná átaráng háranan men álo Abraham e ilommá háleineráng. ");
INSERT INTO klt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Káráwasi wu káráp hulá káin há átak. Káráp retá páliná kándáng ma sáindák wawu marángga táng káráp lánggop kinan san kuinek.” ");
INSERT INTO klt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wáina yánán ámna náráwa watá inuráng, “Iná nándu rina táinemán?” ");
INSERT INTO klt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wáina inát tu Jon dá yánuk, “Ámna káman dá siot ná yará pálak árán du káman táng ni siot ná muná wa iminek, hang niyá sunginá pálak hálendu wáinanyon táinek,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hang takis iháhá ámna kámá hányon umi kuháng námik ingga áwuráng watá inuráng, “Tiksa, nándu rina táinemán?” ");
INSERT INTO klt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ing inát Jon dá yánuk, “Takis sup ihinán du kapman dá rina iháháya mená wáina re ihineráng,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kulá tewe ámna yá hányon inuráng, “Iná nándu rina táinemán?” Wáina inát watá yánuk, “Ámna nukngá iháng piták tángga sup yáni manek ma iháng yámindaráng, me kámá ya me kusák hára ma meng yámindaráng. Sup rina sáháng yunggoeráng wawu sáni wu tárák hára álo ingga narineráng,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ámna náráwa yá ále wa tán kangga pahán yáni tárurán nanará yáup táuráng, “Jon wawu ámna Ánutu yan ámna náráwa son iháhá wa hám,” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iná Jon dá ku yánuk, “No ku umi yá kuháng sámet, iná káman máriya áwinek wata hálángngá wu nák neháng hátek, hang ámna wáik nák ina tá watán sendol páupmá yayaliyan tárák muná. Watá wu Iruk Káungá yot káráp lánggop pot kuháng sáminek. ");
INSERT INTO klt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Málám sarak tángga áwinek ngáyá áwáng wit horengga páliná álosim wa iháng itná kinan tingga kepmá wawu iháng káráp sásáliná muná hára wa sin rang hálineráng.” ");
INSERT INTO klt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon málám wáina yánángga me kámá yot me pingnga álosim watyot yánángga pahán yáni táng tárut táuk. ");
INSERT INTO klt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rám káman Jon málám kapman dán ámna yáilá káman Herot wa me táng muk, náuta kulaná ya áwáná Herodias táuk, me kálu kandák nukngá kámá hányon átmeráng wata ingga. ");
INSERT INTO klt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wata me táng mán du Herot tá kandákngá nukngá waháranyon sengsáráp tiuk wawu Jon táng kalabus it kinan tingga kálu káto táng muk. ");
INSERT INTO klt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kulá Jon dá ámna náráwa kámuk hánám umi kuháng yámuk waháranyon du Jesu ya umi hányon kuháng muk. Wáina kuháng mán du Jesu málám sáponga tángga átnárán waháranyon alek ká ang tán, ");
INSERT INTO klt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iruk Káungá watá hang málám hára ep tángga árán káuráng wawu iráp tánarám ina. Kulá waháranyon me káman alek kálu wáina háuk, “Kák ku nák Nanggena. No kák ka kikiná hánám naret. No kák ka pahánna álosim hánám naret.” ");
INSERT INTO klt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Rám wahára wu Jesu málám bu yaraná 30 hám wáina hálengga árán miti yáup hulátiuk. Kulá ámna náráwa yá ku Josep nanggená ingga káuráng, iná Josep wawu Heli nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","iná Heli wawu Matat nanggená, iná Matat wawu Liwai nanggená, iná Liwai wawu Melki nanggená, iná Melki wawu Janai nanggená, iná Janai wawu Josep nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","iná Josep wawu Matatias nanggená, iná Matatias wawu Amos nanggená, iná Amos wawu Nahum nanggená, iná Nahum wawu Esli nanggená, iná Esli wawu Nagai nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","iná Nagai wawu Mat nanggená, iná Mat wawu Matatias nanggená, iná Matatias wawu Semen nanggená, iná Semen wawu Josek nanggená, iná Josek wawu Joda nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","iná Joda wawu Joanan nanggená, iná Joanan wawu Resa nanggená, iná Resa wawu Serubabel nanggená, iná Serubabel wawu Sealtiel nanggená, iná Sealtiel wawu Neri nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","iná Neri wawu Melki nanggená, iná Melki wawu Adi nanggená, iná Adi wawu Kosam nanggená, iná Kosam wawu Elmadam nanggená, iná Elmadam wawu Er nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","iná Er wawu Josua nanggená, iná Josua wawu Eliesa nanggená, iná Eliesa wawu Jorim nanggená, iná Jorim wawu Matat nanggená, iná Matat wawu Liwai nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","iná Liwai wawu Simion nanggená, iná Simion wawu Juda nanggená, iná Juda wawu Josep nanggená, iná Josep wawu Jonam nanggená, iná Jonam wawu Eliakim nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iná Eliakim wawu Melea nanggená, iná Melea wawu Mena nanggená, iná Mena wawu Matata nanggená, iná Matata wawu Natan nanggená, iná Natan wawu Dewit nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","iná Dewit wawu Jesi nanggená, iná Jesi wawu Obed nanggená, iná Obed wawu Boas nanggená, iná Boas wawu Salmon nanggená, iná Salmon wawu Nason nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","iná Nason wawu Aminadap nanggená, iná Aminadap wawu Atmin nanggená, iná Atmin wawu Arni nanggená, iná Arni wawu Hesron nanggená, iná Hesron wawu Peres nanggená, iná Peres wawu Juda nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","iná Juda wawu Jekop nanggená, iná Jekop wawu Aisak nanggená, iná Aisak wawu Abraham nanggená, iná Abraham wawu Tera nanggená, iná Tera wawu Nahor nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","iná Nahor wawu Seruk nanggená, iná Seruk wawu Reu nanggená, iná Reu wawu Pelak nanggená, iná Pelak wawu Eber nanggená, iná Eber wawu Sela nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","iná Sela wawu Kainan nanggená, iná Kainan wawu Arpaksat nanggená, iná Arpaksat wawu Siem nanggená, iná Siem wawu Noa nanggená, iná Noa wawu Lamek nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","iná Lamek wawu Metusela nanggená, iná Metusela wawu Enok nanggená, iná Enok wawu Jaret nanggená, iná Jaret wawu Mahalalel nanggená, iná Mahalalel wawu Kenan nanggená, ");
INSERT INTO klt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","iná Kenan wawu Enos nanggená, iná Enos wawu Set nanggená, iná Set wawu Adam nanggená, iná Adam wawu Ánutu nanggená. ");
INSERT INTO klt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iruk Káungá yá Jesu hára hánghálángngá hánám ep tán málám Jodan umi wa sangga son hurik tángga kuk. Kulá Iruk Káungá yá engotang ále komkomá ámálum re káin kuk. ");
INSERT INTO klt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jesu yá wakáin kung árán rám 40 wata kinan Satan dá áwáng ingirungngingga átuk. Rám ore wahára Jesu wawu sungi ma náená átkuk hálendu rám 40 wata sásáliná káin du táup hánám háing mángga átuk. ");
INSERT INTO klt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kulá Satan dá wáina kangga ku áwáng inuk, “Pálipuk kák ku Ánutu Nanggená hálendu sup wa metá másáng háleik,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Enendu Jesu yá me táng hurik tángga ing inuk, “Me ing uyená átak, ‘Ámna náráwa wu sungi yá re háláng yámán ma átkuindáráng.’” ");
INSERT INTO klt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wáina inán wahára átang gu Satan dá son Jesu engotang árángga kungga wakáin átang káwakngá káwakngá kámuk wa sokmuná hánám eliuk. ");
INSERT INTO klt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wáina átang elen kan du inuk, “No háláng wa kame ko wa pin yáni tángga átang kutya árená hánám wáina átnelák. Ále kutná kutná wawu nákkán há háliuk, wata ku no ni imin ingga wawu iminet. ");
INSERT INTO klt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wáina wata ku ko nák nanáng sákngitá ku no ále kutná kutná wa kaya kaminet.” ");
INSERT INTO klt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wáina inán Jesu yá inuk, “Ánutu yan me ing uyená átak, ‘Táwika Ánutu káman re ináng sákngingga wata tárang káin átnelák.’” ");
INSERT INTO klt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ingga wáina inán Satan dá Jesu engotang Jerusalem káin kuk ngáyá kung Táwi yan it káungá hásák hánám wata hungnganá káin san árán du inuk, “Pálipuk kák Ánutu Nanggená hálendu, nahára átang hitangga hang, ");
INSERT INTO klt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","náuta Ánutu yan me ing uyená, ‘Málámbá angeloná yánán kándáng hánám pinya táineráng. ");
INSERT INTO klt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Watá ket torong kehát tu háramya káin sup pá ma kutnándák.’” ");
INSERT INTO klt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wáina inán Jesu yá inuk, “Ánutu yan me yá ing mek, ‘Ko Táwi Ánutu ka wa táng ingirungngingi hára ma tindalák,’” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kulá Satan dá me wa mengga Jesu ingirungngin men du sangga rám nukngá ya háleng muk. ");
INSERT INTO klt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu málám Iruk Káungá yan háláng hára Galili ále káin son kun, wáina áwek ingga kut pingnganá watá ále ore wakáin erek ingmen kung háliuk. ");
INSERT INTO klt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Málám miti itná wahára wahára me yánáng tolingga kun kangga ámna náráwa táup tái watá Jesu málámba kutná meng tárut tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wáina tángga árát tu Jesu málám bu it Nasaret káin kuk, iná Jesu wu huphuráp it wahára átang táwi háliuk. Sabat hára wu rámá rámá tángngátak wáina málám miti itná káin kung háuk ngáyá ku Ánutu yan me wa sángin ingga tárutuk. ");
INSERT INTO klt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kulá yáni wu profet Aisaia yan papia táng imát málám wa kot kung me rina naruk wa uyená wa káuk: ");
INSERT INTO klt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Táwi yan Iruk ká nákkot átak, náuta Táwi málámbá neháng tunggap tángga me pingnga álosim wa ámna náráwa ukuro átaráng wa yánánáya suring namuk. Hang ámna náráwa kalabus it kinan átaráng wa men along kukuya me rahán yáni wáik wa men rahán yáni yá álo háháleya, hang ámna nukngá yá iháng hang tingga iháng lem tánggoeráng wa háláng yámámáya, ");
INSERT INTO klt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","hang ‘Táwi yá ámna náráwaná iháng álolo tátáyan rám hálek,’ ingga meng tunggap tátáya suring namuk.” ");
INSERT INTO klt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wáina sánging hálingga Jesu málám papia wa táng pop tángga ámna papia pinná tátá wa imángga ku putung háuk. Iná ámna náráwa miti itná kinan áturáng watá rahán yáni wu Jesu hára re árát tu ");
INSERT INTO klt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ing yánuk, “Ánutu yan me sánge nareráng watá páliná kulapálik nahára páliná yá há tunggafek,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kulá wahára áturáng watá kámuk kutná meng tárut tángga me álolo sim táwi milunná káinnan háukngá naruráng wata hárámutang yáni meme táuráng, “Náwu Josep nanggená ingga há naremán watá ku rina tángga ku me táwi wáina wa mek?” ");
INSERT INTO klt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wáina met Jesu yá yánuk, “Sándá ku nák ing hám naninderáng, ‘Dokta, ko kaya sutya kálak táng toling! It Kapaneam káin rina tátá pingngaka narumán, wáinanyon itya hulá hára ná táng.’” ");
INSERT INTO klt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hang ing yánuk, “Pálipuk hánám ing sánin, profet káman itná hulá hánám watá ku pahán ma imángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No ing pálipuk sánin, Elaija yan rám hára wu Israel kinan náráwa kawát tu táup hánám wa áturáng. Rám wahára wu ále yá ma táená árán yara kaláhu yap 6 hálen káwak ketnán sungi yá kesák táwi háliuk. ");
INSERT INTO klt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Enendu wahára wu Ánutu yá Elaija suring mán Israel náráwa kawát káman dán káin ma kuk, ináku suring mán kawát káman it Sarepat, Saidon ále káin wa kuk. ");
INSERT INTO klt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hang profet Elaisa yan rám hára wu Israel kinan ilalák lepra pálak ku táup hánám wa áturáng, enendu káman waháranan da sutná yá ma rongrongiuk, ináku káwak Siria nan ámna kutná Naman wata sutná yá re ku rongrongiuk.” ");
INSERT INTO klt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wáina yánán narángga ámna náráwa miti itná kinan áturáng watá kámuk hánám kuk táwi táuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yáni wu tárutang seng isutang táng uyingga it kep káin kuráng. It yáni wawu ále yáilá isikimo káman hára hálendu engot kung porá hára satne háik ingga táuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Enendu málám orek yáni hára wa yolopon kungga háná kuk. ");
INSERT INTO klt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesu málám kuk ngáyá kungga ále Galili kinan it Kapaneam wakáin háuk ngáyá Sabat hára wu ámna náráwa Táwi yan me yánáng tolingga árán ");
INSERT INTO klt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ámna náráwa yá káuráng gu ámna kutná pálak me hálángngá pálak ká ina yánángga árán narángga wata hárámuturáng. ");
INSERT INTO klt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kulá miti itná kinan ámna káman iruk wáik ká ep táená watá átang hahatingga hánám ing mantáuk, ");
INSERT INTO klt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hae! Jesu Nasaret nan, rina táng námámáya áwelák? Kák ka nán hám náháng lem tátáya áwelák? Kák ku wa ingga nák ku há naret, kák ku rongrongngá hánám Ánutu yan káinnan áwelák!” ");
INSERT INTO klt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wáina inán Jesu yá ing me táng muk, “Yolop átang ámna wa sangga hang!” Wáina inán iruk wáik watá ámna wa orek yáni hára táng san han áráng hengga kuk, enendu ámna wa kámá ma táng lem táuk. ");
INSERT INTO klt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wáina tán kangga ámna náráwa wahára áturáng watá hárámutang yáni inán kanán táuráng, “Nanggula, me náwu rinaná!? Iruk wáik yánánggoek wawu ámna kutná pálak me hálángngá pálak ká ina yánán áráng hengga kunggoeráng!” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kulá wáina tángga árán kut pingnganá watá ále wata kinan it kámuk kung hilák táuk. ");
INSERT INTO klt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu málám miti itná wa sangga Saimon dán it káin kuk. Rám wahára wu Saimon silummá wu ilalák tángga sutná watá ángárángngá hánám wáina árán du háláng imáng ingga Jesu inuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wáina inát Jesu yá kung náráwa wata rupmá tangtang átang ilalák wa me táng mán ilalák watá wahára re san náráwa wawu waháranyon tárutnáráng sungi tiyawing yámuk. ");
INSERT INTO klt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kulá yonyon tin káe yá kung hangga átuk kálu wu ámna náráwa yá nuknuk yáni ilalák hulá hulá yá ihená wa ihángga Jesu yan káin áwát Jesu yá ketná yá ihánggápán álo hángháleng táuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jesu yá men iruk wáik máro hánám watá ámna náráwa yápmangga áráng hengga hahatingga ing mantánggiuráng, “Kák ku Ánutu Nanggená!” Wáina met kangga ku málám me táng yámángga olet yáni káto tán watá me kámá ma me tánggiuráng, náuta há naruráng wawu Ánutu yá ámna náráwaná son iháháya suring mán áwuk. ");
INSERT INTO klt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hilápmá hánám Jesu wu hangga ále rákit káman káin kung árán ámna náráwa yá suling kung ále re káin átuk wakáin kangga táng putitne ma nápmangga kuindak ingga táuráng. ");
INSERT INTO klt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Enendu Jesu yá yánuk, “Nák ku kungga Ánutu yan átkuku watán me pingnga álosim wa it kámá káin hányon yáninet, náuta nák ku yáup wa tátáya Ánutu yá suring namán áwut.” ");
INSERT INTO klt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wáina yánángga ku Judia ále káin miti itná yáni kinan Ánutu yan me wa yánángga átkuk. ");
INSERT INTO klt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rám káman Jesu wu umi pátum Genesaret tákto káin hetang átang Ánutu yan me wa yánángga árán ámna náráwa urum táwi watá áwáng me wa naránin ingga málám kang áwálák tángga kik hánám wa áturáng. ");
INSERT INTO klt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wáina árát Jesu málám hálengga kápuk ku bot yará wu umi tangtang sán káin wa árán, iná ámna káut iháhá wawu bot yápmang hang kep káin átang umben yáni wa yawondang árát. ");
INSERT INTO klt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wáina kápángga málám bot káman da ketnán árángga kuk, iná bot wawu Saimon dán. Áráng wata ketnán átang gu Saimon inuk, “Upme sim tátá sán sangga sim kuik,” ing inán wáina tán kun du wata ketnán putung átang Ánutu yan me wa ámna náráwa yánáng toliuk. ");
INSERT INTO klt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Me wa yánáng hálingga ku Saimon inuk, “Kulá pul tángga hásák káin kungga ku umben wa hirarát umi kinan hat tu káut ihineráng.” ");
INSERT INTO klt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wáina inán Saimon dá inuk, “Táwina, yáungán yáup háláng hánám táemán, wawu káut kámá ma ihámán, enendu álo ko há melák wata ku álo umben hirarátne háineráng.” ");
INSERT INTO klt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wáina tángga káuráng gu káut watá umben kinan rina kámá hánám hang árát umben dá tikták rákitang áturáng. ");
INSERT INTO klt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wáina kangga ku nuknuk yáni bot nukngá káin áturáng wa ket tárák táng yámát áwáng háláng yámát tu káut wa iháng bot yará hára wa molát tuwatang márawingga bot tá hála umi pátum kinan hang sungga átumálák. ");
INSERT INTO klt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kulá Saimon Pita yá tárák wa káuk hára wu Jesu hárammá hulá káin tulá hára imángga inuk, “Táwi, nepmangga háka kung, náuta nák ku ámna mukmuro!” ");
INSERT INTO klt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wáina inuk náuta málám bu yanuknukngá yot káut ihuráng wa kangga nangnga yáni han pikpito naruráng wata. ");
INSERT INTO klt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iná Saimon nukngá Sebedi nanggená yará Jeims káling Jon wawu Saimon dá naruk wáinanyon narumálák. Kulá wahára wu Jesu yá Saimon inuk, “Ma pitáindalák. Rám kula hulátingga áruinek wahára wu ámna nangge iháháyan háleinelák.” ");
INSERT INTO klt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wáina inángga sangga yáni wu bot yáni wa pul tát sán káin áwán kutná kutná wa wahára erek yápmang hálingga ku Jesu isutang kuráng. ");
INSERT INTO klt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Rám káman Jesu wu it káman hára átnárán ámna káman watán káin áwuk wawu sutná wu ilalák lepra watá táng wáik hánám táená watá áwáng Jesu kangga tulá hára imángga kurákmáta táng káwak káin tingga inuk, “Táwi, ko narátá álo hálendu neháng tolitá no Ánutu rahálá hára rongrongngá hálin.” ");
INSERT INTO klt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wáina inán Jesu yá ketná kálan kung tánggangga inuk, “Álo, no háláng kame rongronging!” Wáina inán wahára re hánám ilalák lepra watá álo háleng mán sutná yá rongrongiuk. ");
INSERT INTO klt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kulá wahára wu Jesu yá me káto inángga oletná mangga ing inuk, “Kungga ni kámá káman ma inindalák, ináku kung sutya wa pris elengga ku ilalák ká álo hálen Ánutu ya towet sing mámáya Moses yá rina tátáya miuk wáina tátá ku kámá yá kahángga ku ilalákngá yá álo hálek ingga kahineráng.” ");
INSERT INTO klt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wáina inuk, enendu Jesu yá rina táuk wata pingnganá yá erek ingmen kung hilák tán ámna náráwa káwan táwi hánám watá me men naránin ingga áwánggiuráng, iná waháranan kámá yá ku ilalák náni tán álo hálenin ingga wata áwánggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Rám ore kámá hára wu Jesu málám yolopon ingmen hangga ále nángnángngá káin sáponga tátáya kunggiuk. ");
INSERT INTO klt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rám káman Jesu wu Táwi yan me wa ámna náráwa yánáng tolingga átnárán, ále Galili káin it waháranan waháranan me Judia nan me Jerusalem nan Farisi me lo yan tiksa yá áwuráng ngáyá wahára putung áturáng. Rám wahára wu Táwi yan káinnan ilalák mara iháng totoliyan háláng watá hang Jesu yot átuk. ");
INSERT INTO klt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kulá ámna urum káman dá nuk yáni káman tángga áwuráng wawu ket hárammá kámut hálená wa táng kangkang ketnán tit árán tángga áwáng it kinan hang Jesu kondolá hára tinin ingga áwuráng. ");
INSERT INTO klt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Enendu pahán tingga áwuráng wa isutang tátáyan du káluná muná, náuta ámna náráwa yá kik hánám árát kápángga ku son tánggatang it ketnán árángga it hungnganá yalingga páup pá kangkang hára putingga sat wakálu it kinan hangga Jesu kondolá hánám hára háuk. ");
INSERT INTO klt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wáina tát tu Jesu yá naráng hákhátik yáni wa kangga ku miuk, “Nukna, no mukmuroka wa yawondat.” ");
INSERT INTO klt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kulá Farisi yot lo yan tiksa watá kangga ku ing narángga átkiuráng, “Ámna náwu niyá ku Ánutu yá menggim ina wu watá menggoek? Ámna káman dá mukmuro yanyawon dán tárák kámá muná, Ánutu yá rewe ku wáina tátáyan.” ");
INSERT INTO klt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu wu wáina narángga átaráng ingga há narángga ku yánuk, “Náuta ku nanará sáni káin wáina naráng háteráng? ");
INSERT INTO klt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Me rina ku tiyap hánám meinet? ‘Mukmuroka ku yawondat,’ me ‘Tárutang kung’? ");
INSERT INTO klt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Enendu ing narineráng, Ámna Nanggená watá káwak náta ketnán mukmuro yanyawon watán háláng tángga átak.” Wáina yánángga son ilalák mara wa inuk, “No kanin, tárutang kangkangga tángga itya ya kung.” ");
INSERT INTO klt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wáina inán waháranyon orek yáni hára málám tárutang kangkangngá tángga átang Ánutu kutná meng tárut tángtáng hangga itná ya kuk. ");
INSERT INTO klt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kulá ámna náráwa kámuk watá wa kangga hárámutang Ánutu kutná meng tárut táuráng. Yáni wu “Kula wu hulá kámá káman wáina káemán,” ingga mengga nangnga yáni háuk. ");
INSERT INTO klt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wata máriná káin du Jesu yá kungga káuk ku takis iháhá ámna káman kutná ku Liwai wawu takis iháhá itná hára putung átnárán kangga ku inuk, “Áwángga nák nasulák.” ");
INSERT INTO klt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wáina inán Liwai málám tárutang kutná kutná wa erek yápmang hálingga Jesu isutang kuk. ");
INSERT INTO klt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kulá Liwai málám Jesu ya sinak táwi táng mámáya itná káin sungi tiyawing san árán, takis iháhá nuknukngá táup hánám bot ámna kámá yot men áwát sungi wa náuráng. ");
INSERT INTO klt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kulá tombong Farisi kinan nan lo yan tiksa kámá yot Farisi kámá watá áwáng Jesu yan disaepel ing me táng yámuráng, “Náuta ku sándá takis iháhá ámna yot me mukmuro táená yot umi sungi nana tánggoeráng?” ");
INSERT INTO klt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wáina met tu Jesu yá yánuk, “Ámna káman ilalákngá muná yá dokta yan káin ma kungngátak, ináku ilalákngá pálak watá ku dokta yan káin kungngátak. ");
INSERT INTO klt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","No áwut wawu ámna náráwa kándáng árená wa mantáng yámámáya ma áwut, ináku mukmuro pálak wa mantáng yáme pahán yáni hurik tángga áwáwáya áwut.” ");
INSERT INTO klt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ámna yá Jesu inuráng, “Jon dán disaepel yá sungi sangga sáponga tángngátaráng, me Farisi yan disaepel wu wáinanyon tángngátaráng, iná kákkán disaepel wu raták hánám átningga umi sungi wa tángga nangga átninggoeráng.” ");
INSERT INTO klt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wáina inát Jesu yá yánuk, “Ámna káman dá náráwa tátáya átang nuknukngá men áwánggalát watá watyot árát, sándá yánát rám ámna watá yáni yot há átgim wahára álo sungi sanggalát me? Wáina kámá ma árak. ");
INSERT INTO klt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Iná rám káman áwinek wahára wu ámna náráwa tátáya táinek wa áwáng há tángga kuineráng, wahára ku wáina nuknukngá yá sungi sanggalát.” ");
INSERT INTO klt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hang me tárákngá káman ing yánuk, “Lap kakngá káman dá ráráhángga hinangngá yá árán ámna káman dá lap mirak káman ráráhángga kátu táng kakngá wata hinangngá ma rákárenggim. Wáina tánggim wawu lap mirak wa táng lem tánggim, me kátu mirak wawu kakngá inanyon muná. ");
INSERT INTO klt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hang káman dá wáin mirak wa táng meme kepmá kakngá hára ma kulinggim. Wáina tánggim wawu wáin mirak wata mulá yá meme kepmá wa ráráhán wáin dá sunggulingga hanggim. ");
INSERT INTO klt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kulá wáina wata ku wáin mirak wa táng gu meme kepmá mirak háranyon kukuliyan. ");
INSERT INTO klt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iná káman dá wáin kakngá wa há nanggim wawu torong hára mirak nanaya ku ma naránggim, ináku ing menggim, ‘Kakngá wawu kikngá álosim hánám.’” ");
INSERT INTO klt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Rám káman Sabat hára Jesu yá disaepelná yot yáni wa ku wit hái orek yáni kálu kungga átang disaepel yá wit páliná wa iháng ket yáni yá husit kepmá watá sohit tu páliná wa há yáni náuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wáina tát kápángga Farisi kámá yá miuráng, “Náuta ku sándá Sabat hára kálu wáina ma tátáya mená wa táeráng?” ");
INSERT INTO klt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wáina met narángga Jesu yá yánuk, “Sán kámá Dewit yot tombongngá yá háing yámán táuráng wata pingnga yáni wa sángingga narángngátaráng me muná? ");
INSERT INTO klt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewit málám kung Ánutu yan it kinan hang másáng horengga Ánutu yan pingnga tit káungá hálená wa kálu hitik tángga pris káman inán másáng wa táng imán náuk, másáng wawu pris yá re nanaya mená. Wáina nangga kámá iháng tombongngá yámán náuráng.” ");
INSERT INTO klt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Waháranyon Jesu yá ing yánuk, “Ámna Nanggená wawu Sabat tán Táwi.” ");
INSERT INTO klt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat káman hára wu Jesu málám kungga miti itná kinan kung hangga ku Táwi yan me yánáng tolingga átuk, wahára wu ámna káman ketná álák kálu kámurená watá wahára hányon átuk. ");
INSERT INTO klt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rám wahára wu Farisi me lo yan tiksa wu hulá rehára kungga Jesu táng me hára tinin ingga áturáng hálendu Sabat hára ámna nangge kámá iháng tárut táinek me rina ingga kangga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iná Jesu yá ku wáina narángga átaráng ingga há kápángga ku ámna ketná kámurená wa inuk, “Tárutang kondon yáni hára wa hetang álák.” Wáina inán du ámna wawu tárutnáráng inuk wáina kondon yáni hára hetang átuk. ");
INSERT INTO klt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kulá wáina árán du Jesu yá yánuk, “Retá ku Sabat hára kálu kándáng hálek: álosim táinemán me wáik táinemán? Háláng yáminemán me ráháng kátkámut táinemán?” ");
INSERT INTO klt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu málám háleng sulingga erek ingmen kápáng háling san árán du ámna ketná kámurená wa inuk, “Ketya wa uying ráng táng.” Ámna wawu Jesu yan me narángga rina inuk wa isutang wáina tángga wahára re ketná watá álosim háliuk. ");
INSERT INTO klt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kulá Farisi yot lo yan tiksa watá wa káuráng hára wu pahán káráp hánám wa tángga ku Jesu náwu rina táng minemán ingga yáni inán kanán táuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wáina tángga sangga rám káman Jesu málám sáponga tátáya kuk watá kungga ále yáilá káman káin áráng átang Ánutu yan káin sáponga tángga árán kungga it tá háiuk. ");
INSERT INTO klt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kulá it tá háin du disaepelná mantáng yámán málámbán káin áwát tu 12 iháng tunggap tángga kut aposel wa yámuk. ");
INSERT INTO klt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kut yáni wu Saimon, Jesu málámbá kut Pita imuk wa, hang Endru Pita kulaná, Jeims, Jon, Filip, Batolomiu, ");
INSERT INTO klt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jeims Alfius nanggená, Saimon tombong Selot háranan, ");
INSERT INTO klt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jeims nanggená, hang Judas Iskariot máriya Jesu táng káyam ket yáni hára tiuk wa. ");
INSERT INTO klt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu málám kung hangga ále pahálá káman káin hetang átuk, wakáin du disaepelná káwan táwi yot ámna náráwa Judia kinan nan, Jerusalem kinan nan me táp kurat káin it táwi Tair káinnan hang it táwi Saidon nan watá áwáng áturáng. ");
INSERT INTO klt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wa áwáng áturáng wawu Jesu yan káinnan me nanaráya me ilalák yáni tán álo háhále wata ingga áwuráng. Hang iruk wáik ká ámna náráwa kámá ep ihená wa iruk wáik wa yásut yámuk. ");
INSERT INTO klt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kulá wahára wu háláng wawu watán káinnan dá áwáng gu kámuk iháng tárut tánggiuk wáina hálendu ámna náráwa yá ku tánggagaya re tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kulá Jesu málám disaepelná kápángga ku ing yánuk, “Sán niyá ukuro átaráng watá heronge táineráng, náuta Ánutu yan átkuku wawu sándán. ");
INSERT INTO klt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sán niyá inggálu háing sámán átaráng watá heronge táineráng, náutá máriya wu nangga kawin sáni yá hahatin átneráng. Sán niyá inggálu kut hára átaráng watá heronge táineráng, náuta máriya wu yut hára átneráng. ");
INSERT INTO klt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ámna yá sáháng káyam táineráng, sásutang kep tineráng, meng sámineráng me kut sáni mengga sáháng wáik táineráng wata sándá heronge narineráng, náuta Ámna Nanggená yan yáup hára átneráng wata ku sáháng wáina táineráng. ");
INSERT INTO klt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Wáina táng sámát tu rám wahára heronge tángga ku hiring árángga háineráng, náuta yumnakngá táwi hánám alek káin háleng sámángga átak. Uláp táwi yáni yá profet wawu iháng wáinanyon tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Iná sán niyá sup me kutná kutná álo ingga átaráng sándu káwak káin heronge há tángga átaráng, wata ku máriya márapmá yá sáhinek. ");
INSERT INTO klt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iná sán niyá inggálu nangga kawin sáni hahatin átaráng sándu máriya márapmá yá sáhán háing sáminek. Iná sán niyá inggálu yutang heronge tángga átaráng sándu máriya márapmá yá sáhán kutkáyawát hára átneráng. ");
INSERT INTO klt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iná sán nini meng toling sámánggoeráng sándu máriya márapmá yá sáhinek, náuta uláp tátáwi yáni yá profet kusák wawu wáinanyon meng toling yámánggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sán niyá nákkán me ná narángga átaráng sán sánindet: Káyam sáni wa kikiná kápineráng, me niyá sánda taktak yámán wawu sándá iháng nuk táineráng. ");
INSERT INTO klt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Niyá tará me sánát tu sándá kuram me yánineráng, me rendá sáháng lem tát tu sáponga wata táng yámineráng. ");
INSERT INTO klt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Káman niyá kingkila numkálu kátin du hurik tángga numkálu hányon sang mátá kátinek, iná káman niyá saketya tán du siotya álo yon sang mátá táinek ma táng marindalák. ");
INSERT INTO klt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Káman niyá kutná kutná yámámáya kanát tu álo yáminelák, iná káman niyá náut kámá káman kákkán hára tán du son tátáya ma inindalák. ");
INSERT INTO klt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sándá kámá yá rina táng sámámáya narángngátaráng, sándá wáinanyon kámá ya táng yámineráng. ");
INSERT INTO klt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Iná rendá sán kikiná sáhát wáinanyon wa kikiná kápineráng wawu Ánutu yá wáina tát sáhángga wata álosim sáhánggim me? Wa muná rewe. Mukmuro mara wawu wáinanyon niyá kikiná kápek wanyon kikiná kangngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iná sán rendá sáháng álolo tát wáinanyon wa iháng álolo táineráng wawu Ánutu yá wáina tát sáhángga wata álosim sáhánggim me? Wa muná rewe. Mukmuro mara wawu wáinanyon niyá iháng álolo tán wanyon iháng álolo tángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iná sándá topmá iháháya nangnaráng náut kámá yámineráng wawu Ánutu yá wáina tát sáhángga wata álosim sáhánggim me? Wa muná rewe. Mukmuro mara wawu wáinanyon topmá ihinemán ingga nangnaráng gu náut kámá iháng nuknuk yáni yáni inanyon wa yámángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Káyam sáni wa kikiná kápángga iháng álolo táineráng, hang náut kámá topmá iháháya nangnaráng ma yámindaráng. Wáina táineráng watá ku máriya yumnakngá táwi hánám ihineráng, hang Ánutu Árená Hánám wata nángánangge háleineráng, náuta Ánutu ya heronge ma táng mángngátaráng me kandák tángngátaráng, enendu watá ku ket tárák álosim re táng yámángngátak. ");
INSERT INTO klt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nan sáni yá ukuro kápángngátak wáinanyon sándá ukuro kápineráng.” ");
INSERT INTO klt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesu yá ing miuk, “Kámá yan ket tárák wa kangga wawu wáina ingga ma meng yámindaráng, náuta watá sándán ket tárák wata wáinanyon meng sámánirot. Kámá ya kandák táeráng ingga ma yánindaráng, máriya sáni kandák táeráng ingga wáinanyon sánánirot. Kámá yan kátu wa sat tu kátu sáni sasa yá tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sándá yámát tu sásámáyan dá tunggafeinek. Ánutu yá horengga táng tolingga kándáng hánám tinek wawu mondang árán tuwatang máta hándáp hálen isut hang tiktik tán sunggulingga hangga árán sáminek. Kámá tárák rina yámineráng wawu Ánutu yá tárák wáinanyon sáminek.” ");
INSERT INTO klt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kulá Jesu yá me tárákngá káman ing yánuk, “Ámna rahálá kunángngá káman dá rahálá kunángngá yon da álo engotang kunggim me? Wa muná, yayará kungga árám hára hanggalán. ");
INSERT INTO klt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul nangge káman dá tiksaná torong káin ma átgim, ináku skul ya kándáng hangga kungga ku tiksaná ina hálenggim. ");
INSERT INTO klt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Rina ta ku nangge nukka ya rahálá káin sinsin káhumá isikimo wa rewe kangga ku kaya rahála káin palang táwi wata ma naráng kulák? ");
INSERT INTO klt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Náuta ku nangge nukka inánggim, ‘Nukna, satá no sinsin rahála káin wa táng se kuik,’ wáina inángga ku kaya rahála káin palang táwi wawu ma kanggulák? Kák ku ámna kusákngá, ko hulátingga kaya rahála káin palang táwi wa táng satá kun du hálengga kándáng kangga ku nukka ya rahálá káin sinsin káhumá isikimo wa táng satá kuinek. ");
INSERT INTO klt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Káráp álosim watá páliná wáik kámá ma tindák, wáinanyon káráp wáik watá páliná álosim kámá ma tindák. ");
INSERT INTO klt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Káráp erek hánám bu páliná hára kápángga ku káráp wáik me álosim ingga narángngátaráng. Káman dá kung páup kánggárángngá hára fik páliná ma ihánggim, me kung wáin páliná káráp kárángngá pálak hára ma ihánggim. ");
INSERT INTO klt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ámna álosim káman dá nanará álosim watá pahálá káin árán wawu ket tárák álosim wa tángga átkuinek. Iná ámna wáik káman dá nanará wáik watá pahálá káin árán wawu ket tárák wáik wa tángga átkuinek. Ámna pahán káin nanará rina átak wawu milun dá ku wa hiták meng tunggap tángngátak. ");
INSERT INTO klt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Náuta ku ‘Táwi, Táwi,’ ing mantáng namánggoeráng ngáyá ku no me sánánggoet wawu ma isutkuráng? ");
INSERT INTO klt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","No ing sánin, káman dá nákkán káin áwáng nákkán me narángga táng ket tárák hára tingga isutang átkuinek wawu ing, ");
INSERT INTO klt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ámna káman dá itná tátáya ku árám hásák pingga kumam mangga sup pot kikkik topmengga ku itná wata ketnán tánggim wáina. Kulá umi sip pá áwánggim watá áwáng kátinggim, enendu it wa ma káting hulát tánggim, náuta kumam hulá há káto táená wata. ");
INSERT INTO klt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iná káman nákkán me ná narángga ma isutnándák wawu ing, ámna káman dá itná wa kumam hulá kándáng ma káto tánggim wáina. Kulá umi sip pá áwánggim watá áwáng há káting hulát tán han du táng wáik tánggim.” ");
INSERT INTO klt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kulá Jesu málám me wa yánán ámna náráwa yá erek ingmen naráng hálit tu málám kung it Kapaneam kinan kungga kung háuk. ");
INSERT INTO klt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wakáin du tewe ámna 100 wata yáin yáni watán yáup nangge káman málámbá álosim kangngátak watá ilalák tángga hála hánám kámutang árán. ");
INSERT INTO klt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kulá ámna kámá yá Jesu wu wáina wáina tángngátak ingga met tewe ámna yáin yáni watá narángga sangga árong Juda yan ámna yáilá wahára kámá suring yámán kung Jesu inát áwáng ilalák ámna wa táng totoliya kuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rám ámna yáilá watá Jesu yan káin kung hengga sat warán du inuráng, “Ámna wawu ámna álosim hánám wata ku ko kung rina hánám tátáya narek wa wáina táng minelák. ");
INSERT INTO klt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ámna wawu Juda nánda kikiná hánám narángngátak, hang nándán miti itná wawu watá táuk.” ");
INSERT INTO klt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wáina inángga ku Jesu yá tárurán hangga káman yáni kuráng. Málám it tangtang kung hálingga árán du tewe ámna yáin yáni watá nuknukngá kámá suring yámán kung inuráng, “Táwi, ko yáup háláng ma táindalák. Nák ku ámna álosim muná, kák ina tá nákkán it kinan áwáwáyan tárák muná. ");
INSERT INTO klt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nák ku ámna álosim muná wata ku rupya káin ma kuindát, ináku me rewe metá ku nákkán yáup nangge watá álo háleik. ");
INSERT INTO klt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","No wáina met wawu náuta nák enendu kámá ya tárang yáni káin árená, hang tewe ámna urum káman dá nák tárang káin átaráng, iná no káman ‘ko kung’ ingga inángngátat wawu kungngátak, iná nukngá ‘ko áwáng’ ingga inángngátat wawu áwángngátak, hang yáup nangge ‘yáup wáina táng’ ingga inángngátat wawu wáina tángngátak.” ");
INSERT INTO klt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Rám ámna watá me wa miuk wahára wu Jesu yá narángga hárámutang málám hurik tángga ámna náráwa káwan táwi isutang kungga áturáng wa yánuk, “No ing sánin, Israel kinan ámna naráng hákhátik ngá táwi ing kámá ma káut,” ingga wáina yánuk. ");
INSERT INTO klt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kulá ámna tewe ámna yáin yáni yá suring yámán áwuráng watá son hurik tángga it káin kungga yáup nangge wawu ilalákngá yá há sálikngin álo hálengga árán káuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Átang árongga Jesu málám it kutná Nain wakáin kun disaepelná yot ámna náráwa tombong hásák táwi watá watyot kuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Rám Jesu yá it watán kumbi wata kálu mungnganá hára áwáng hiuk waháranyon du ámna kámurená tambun káman tángga áwáng kep káin háuráng. Ámna kámurená wawu náráwa kawát káman da nanggená ámnaná káman wa hánám rewe. Ámna náráwa urum táwi hánám watá ku náráwa kawát watyot áwánggaturáng. ");
INSERT INTO klt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Táwi yá náráwa wa kangga urákngá táwi hánám wa narángga ku inuk, “Ma kutnándalák.” ");
INSERT INTO klt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wáina inángga Jesu málám enanggon kung kámurená palang pálak tángga kuráng wa tánggan kangga ámna tángga kuráng watá tareng kátit tu kámurená wa inuk, “Nangge máto, no kanet, tárulák!” ");
INSERT INTO klt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wáina inán ámna kámurená watá tárutnáráng putung átang meme tángga árán Jesu yá táng maming imuk. ");
INSERT INTO klt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ámna náráwa urum táwi watá wa kangga nangnga yáni han Ánutu kutná meng tárut tángga ing miuráng, “Náwu profet táwi káman orek náni hára tunggafek. Ánutu yá ámna náráwaná háláng yámámáya suring mán áwek,” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kulá ámna náráwa yá Judia ále kinan me it kámá kámá káin wa kungga Jesu yan me pingnga wa meng isurát kuk. ");
INSERT INTO klt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon dán disaepel yá Jesu yá wáina tánggoek ingga inát narángga ku málám disaepelná yará mantáng yámán áwán du ");
INSERT INTO klt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Táwi ing inánáya suring yámuk, “Kák ku ámna Ánutu yá suring mán áwáwáya miuk wa, me nukngá yá áwinek ka háleinemán?” ");
INSERT INTO klt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kulá rám ámna Jon dá suring yámuk watá Jesu yan káin kung hengga ku ináng suliumálák, “Jon Umi Kuháng Yámámá yá suring námángga ku kák ing kakanáya mek, ‘Kák ka Ánutu yá ámna suring mán áwáwáya miuk wa, me ku nukngá yá áwinek ka háleinemán?’” ");
INSERT INTO klt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wáina ináng suliumálák wata topmá Jesu yá ma yánená átang ámna náráwa táup táwi ilalák hulá hulá yá ihená wa iháng tolingga, iruk wáik ká ep ihená táup táwi wa yásut yámángga ku rahán yáni kunángngá táup táwi wa hányon iháng toliuk. ");
INSERT INTO klt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kulá Jesu yá wáina táng hálingga sangga ku Jon dán disaepel yará wa yánuk, “Son kungga ku rina káemálák me naremálák wa Jon ininemálák: Rahán yáni wáik ká kándáng hálet, háram yáni wáik ká kándáng taret, ilalák lepra pálak ká sut yáni rongrongit, káráman yáni tungngá yá kándáng narát, kámurená yá son tárurát, ukuro árená yá me pingnga álosim wa nareráng. ");
INSERT INTO klt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Niyá nák nahángga naráng hákhátik yáni yá ma hak watá heronge narineráng.” ");
INSERT INTO klt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wáina yánán Jon dán disaepel yará watá hangga há kun du Jesu yá ámna náráwa urum táwi wa Jon da yánuk, “Sándu rám ále komkomá ámálum re káin wa kuráng wawu náut kakaya? Iruk ká pálalong hásin kakaya hám? ");
INSERT INTO klt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Muná hálendu náut kakaya hánám kuráng? Ámna káman kutná kutná álosim tánggánengga árená kakaya me? Wa muná, ámna kutná kutná álosim tánggánená me káwak kán kutná kutná álosimmá pálak wawu king gán it káin átnándaráng. ");
INSERT INTO klt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ináku náut kakaya kuráng? Profet káman me? Wawu pálipuk, profet, enendu ing sánin, profet watá profet kátu wa erek hánám iháng hátek. ");
INSERT INTO klt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ámna wata hánám bu Ánutu yan papia káin ing uyená: ‘Naráng. No ámna niyá me tángga kung áwáng tátá wa kálak suring me kuinek, watá kálu tiyawing kaminek.’ ");
INSERT INTO klt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No ing sánin, káwak ketnán ámna átaráng waháranan káman dá Jon ma táng hátik. Ináku niyá Ánutu yan átkuku kinan nangge kimo yá ina átnek watá ku Jon táng hátinek,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ámna náráwa erek hánám me takis iháhá watá Jon dán me narángga ku ing miuráng, “Ánutu yan nanará wu álosim hánám,” wata ku yáni wu Jon ketná hára umi kuhuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iná Farisi yot lo yan hulá nanará wawu Ánutu yá kálu álosim rina yáliuk wawu sárum imuráng, wata ku Jon dá umi ma kuháng yámuk. ");
INSERT INTO klt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kulá son Jesu yá ing miuk, “Náut hára mengga tárák tinet, rám nátán ámna náráwa wu wáina ingga wu? Wawu náut ina ingga menggem? ");
INSERT INTO klt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rám nátán ámna náráwa wu nangge kikimo yá kapme hára átang yáni inán kanán tángngátaráng ina, ‘Sándá kap utniráng ingga nándá pilut hásiumán, enendu kap ma uturáng. Sándá kutniráng ingga kap ukuro mantáumán, enendu ma kuturáng.’ ");
INSERT INTO klt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Rám nátán ámna náráwa wawu wáina, náuta Jon Umi Kuháng Yámámá yá áwuk ngáyá áwáng másáng ma nan me wáin ma nan, kangga ku sándá ku miuráng, ‘Iruk wáik ká watyot átak,’ ing miuráng. ");
INSERT INTO klt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iná Ámna Nanggená yá áwáng umi sungi nangga árán du menggoeráng, ‘Kaniráng, ámna wawu sungi táup hánám nanggoek me wáin táup hánám nanggoek, wawu takis iháhá me “mukmuro mara” nuk yáni.’ ");
INSERT INTO klt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sándá ku wáina menggoeráng, enendu niyá tirik tárák álosim wa kangga ku kálu kándáng waháranan dá áwek ingga narineráng,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi káman dá Jesu pin ting mán sungi nanaya itná káin kuk. ");
INSERT INTO klt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kung wakáin átnárán náráwa káman it ále waháranan wawu ket tárákngá wu kandák watá Jesu wu Farisi yan it káin átak ingga narángga ku botol káman sup álosim hánám kutná alabasta wata nan dá táng tolená wata kinan oel mungnganá kikiná wa tánggatang kuk ");
INSERT INTO klt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ngáyá kung Jesu sárummá káin hárammá tangtang hetang átang gu kutang átkiuk. Kulá rahálá uminá yá hang gu Jesu hárammá sárummá táng pumpum tán du málámba yáilá rommá yá ránángtang tángga ku hárammá sárummá káin kang kumengga árong oel wa kulin hárammá sárummá ketnán káin wa háuk. ");
INSERT INTO klt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wáina tán kangga Farisi niyá Jesu pin ting mán kuk watá ku ing naruk, “Ámna náwu profet ináku náwu niyá nehángganggoek me náráwa náwu mukmuro mara ingga naránggim,” ingga naruk. ");
INSERT INTO klt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kulá Jesu yá ku ámna wata nanaráná káin há kangga ku inuk, “Saimon, no me káman kanindet.” Ing inán du ámna watá inuk, “Tiksa, nanáng.” ");
INSERT INTO klt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ing men Jesu yá inuk, “Ámna yará yá ámna káman dán káin dinao táumálák, káman dá 5,000 kina hang káman dá 500 kina. ");
INSERT INTO klt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kulá yará waháranan káman dá topmá titiyan tárák ku muná hálendu ámna dinao iháng mumálák watá miuk, ‘Wáinaná topmá ma tindamálák,’ ing yánuk. Kulá resim bá ku ámna wata álo kámá hánám naráng muk?” ");
INSERT INTO klt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wáina men Saimon dá miuk, “No naret tu sup táwi ihuk ngá ku topmá ma titiya inuk watá.” Ing men Jesu yá miuk, “Kándáng hánám melák.” ");
INSERT INTO klt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wáina inángga málám hurik tángga náráwa wa kangga Saimon son inuk, “Ko náráwa ná kangga naráng. No itya kinan áwet enendu háramna yanyawon da umi kámá ma namálák, iná náráwa nátá ku háramna rahálá uminá yá táng pumpum tángga yáilá rommá yá ránángtang táek. ");
INSERT INTO klt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ko ma naháng kumelák, iná náráwa náwu hulátingga it kinan áwet hára átang áwángga inggálu wu emá rewe háramna hára naháng kumengga átak. ");
INSERT INTO klt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ko oel kámá yáinna káin ma kulilák, iná náráwa nátá ku háramna káin oel mungnganá kikiná wa kulek. ");
INSERT INTO klt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wáina wata ku, no ing kanin, náráwa watán mukmuro táwi hánám Ánutu yá yawondak. Wáina tán watá ku nákka kikiná táwi hánám narek. Iná káman niyá mukmuro isikimo tán Ánutu yá mukmuroná wa yawonek wawu watá Ánutu ya kikiná isikimo narinek.” ");
INSERT INTO klt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wáina inángga sangga ku náráwa wa inuk, “Kákkán mukmuro wawu há yawondat.” ");
INSERT INTO klt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wáina inán kátu wahára áturáng watá wa narángga ku yáni meme táuráng, “Ámna náwu ni hálendu mukmuro yawongoek?” ");
INSERT INTO klt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wáina mengga árát tu Jesu yá ku náráwa wa inuk, “Naráng hákhátikka yá keháng tolek. Pahán láláp hára kuinelák.” ");
INSERT INTO klt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wata máriná káin Jesu málám disaepelná 12 watyot it kámá hára kungkung tángga Jesu yá Ánutu yan átkuku watán me pingnga álosim wa yánángga átkuk. ");
INSERT INTO klt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hang náráwa huphuráp Jesu yá iruk wáik yásut yámuk me ilalák háranan iháng toliuk watyot átkuráng, wata kut yáni ku Maria it Makdala háranan Jesu yá iruk wáik 7 yásut muk wa; ");
INSERT INTO klt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herot tán it pinná tátá wata táwi yáni ámna kutná Kusa wata áwáná Joana; hang Susana watyot tu kámá nukngá hányon. Jesu yot disaepelná wawu náráwa urum watá ku kutná kutná yánin háranan háláng yámángga átninggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kulá it waháranan waháranan ámna náráwa urum táwi hánám watá áwáng áturáng wahára wu Jesu yá me tárákngá ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ámna káman dá iritná táulá haliliya kuk. Málám halingga kun kámá yá kálu hára hat ámna nangge yá kung áwáng tángga taret, kámá ku iráp pá kahet hang erek nang háliuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kámá yá káwak sup kárák hára hangga áráng hiuráng, enendu umi muná hálendu erek hánám kumkumiuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kulá kámá yá ku páup kánggárángngá kinan hangga áráng hiuráng, enendu páup kánggárángngá watá árángga iháng usán muná kuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iná kámá yá ku káwak álosim hára háuráng hálendu álo kámá hánám áráng hengga pálin yáni táup hánám tiuráng.” Jesu málám me wa meng hálingga sangga ku mantáuk, “Káman ni kárámanná pálak hálendu watá me ná narinek.” ");
INSERT INTO klt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wáina meng hálin narángga ku disaepelná yá wata hulá wu rina ingga ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Inát tu yánuk, “Ánutu yan átkuku watán nanará kilakngá wawu málámbá sán há sáliuk, iná kátu wawu me tárákngá kálu re yánángngátat, wáina hálendu ‘kámá yá rahán yáni hálengga átneráng enendu ma káindáráng, me kámá yá narineráng enendu wata hulá hánám bu wáina ingga ma naráng ruwat táindáráng.’ ");
INSERT INTO klt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Me tárákngá wata hulá wu ing, irit táulá wawu Ánutu yan me. ");
INSERT INTO klt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iná kálu hára háuráng ga tárákngá wawu kámá yá há narineráng, enendu Satan dá áwáng pahán yáni káin me wa táng hirarán kung yáminek, náuta me wa narángga káto tángga isutang átkut Ánutu yá son ihiwon wata. ");
INSERT INTO klt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Iná káwak sup kárák hára háuráng ga tárákngá wawu kámá yá me wa narángga heronge hánám táineráng, enendu wawu irit ráhun yáni watá káwak kinan ma koená wáina. Álo kámá há táineráng, enendu rám hátetná kimo átang ingirungngi yá áwinek wahára wu naráng hákhátik yáni wa sáineráng. ");
INSERT INTO klt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iná páup kánggárángngá kinan háuráng ga tárákngá wawu kámá yá me wa há narineráng, enendu kálu hára kungga átang rina átnát tán narángpak, sup hang káwak kán kutná kutná álosim átak watá nanará yáni táng yawák tán naráng hákhátik yáni yá maming tái ma háleindák. ");
INSERT INTO klt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Iná irit táulá káwak álosim hára háuráng ga tárákngá wawu kámá yá me wa narángga káto tángga pahán yáni yá kándáng árán káto hálengga átang watá ku pálin yáni kándáng tingga átneráng. ");
INSERT INTO klt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ámna káman dá lam kasingga táng baket kinan me tebol tárang káin ma tinggim, ináku táng tutuháná hára tuháng san árán du káman niyá it kinan áwáng hanggim wata yamá kanggim. ");
INSERT INTO klt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Me kámá kilak átaráng wawu máriya erek hánám hiták háleineráng, me me kámá rina támotang tená wawu máriya tumá yalit hiták hálet ámna náráwa yá wáina ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wáina wata ku nákkán me wa kándáng naráng kuineráng. Káman niyá náut kámá káman átmek hálendu waháranyon Ánutu yá táup hánám wa iminek. Iná káman niyá ma átmák wawu rina átnamek ingga narek wa imáng hutang ihinek,” ingga wáina yánuk. ");
INSERT INTO klt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu maming got tu yakukula watá kanin ingga áwuráng, enendu rupmá káin kungga ma kakayan, náuta ámna náráwa watá kik hánám wa áturáng. ");
INSERT INTO klt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wáina hálendu ámna káman dá inuk, “Mamya yot yakukulaka yá kák kakaháya áweráng ngá kep káin háleng kamángga átaráng.” ");
INSERT INTO klt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ingga inán Jesu yá miuk, “Nák mamna me yakukulana wawu ni Ánutu yan me narángga táng tárák hára tingga isutneráng wa.” ");
INSERT INTO klt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rám káman Jesu yá disaepelná yánuk, “Umi pátum numkálu kunin.” Ing yánángga ku bot ketnán árángga ku kuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kungga átang gu bot ketnán Jesu wu rapmung gá sán du árong háná ruhuk. Wahára wu iruk táwi hánám watá áwáng umi táng hirarán bot ketnán hanghang tángga bot tá hála tuwarán há hánám yakyawinin ingga tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kulá disaepel yáni wu wáina kangga ku Jesu táng mirak tángga inuráng, “Táwi, Táwi, hang suwindemán!” Wáina inát Jesu málám tárutang san warán árong iruk me umi punggilá tátáwi wa me táng yámán iruk ká san umi yá láláwingga hánám wa átuk. ");
INSERT INTO klt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wáina tángga Jesu yá árong disaepelná yánuk, “Naráng hákhátik sáni wa muná me?” Kulá disaepel yáni wu wa kangga hárámutang pitángga nangnga yáni han du yáni meme táuráng, “Náwu ni hálendu iruk me umi wa me táng yámán narángga watán milun suwemálák?” ");
INSERT INTO klt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesu yá disaepelná yot yáni wa ku Galili umi pátum wa pana háng kungga it Gerasen dán ále káin kung hiuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kulá Jesu yá sán káin sung hang tarengga átnárán ámna káman it waháranan iruk wáik ká ep táená watyot kankan táumálák. Rám hásák hánám ámna wawu sutná ma pop táená átang áwánggiuk, me it kinan kámá ma átkiuk, ináku tanggán káin átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Rám táuppon iruk wáik ká ep tánggiuk, wata ku ámna kámá yá pinná tángga ket hárammá sen dá putingga sat átkiuk, enendu sen wa uying rákrákit tángga iruk wáik watán nanará isutang kung ále ámna nangge muná káin wa átkiuk. Ámna watá Jesu káuk wahára wu mantángga táng hang hárammá hulá hára kátiuk. Wáina tán Jesu yá iruk wáik wa ing inuk, “Ámna wa sangga hang!” Ingga wáina inán ámna watá hahatingga hánám mantáuk, “Jesu, Ánutu Árená Hánám wata Nanggená, rina táng namindelák? No ing kanin, neháng lem ma táindalák!” ");
INSERT INTO klt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wáina mantángga inán Jesu yá iruk wáik wa inuk, “Kutya ku ni?” Ing inán watá inuk, “Nák kutna ku Tombong Hásák,” ingga inuk, náuta iruk wáik táup hánám watá kung hang ámna wata pahálá kinan káin átnándaráng. ");
INSERT INTO klt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Rám waháranyon iruk wáik watá Jesu inuráng, “Násurátá kungga árám yuwitná muná káin wa ma háindamán,” ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iná put urum táwi káman du ále yáilá isikimo wata álatná kálu sungi nangga árát tu iruk wáik watá Jesu inuráng, “Násurátá kungga wata kinan hanin,” ingga inát tu álo ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kulá iruk wáik watá ámna wa sangga háuráng ngáyá ku kung put wata kinan háuráng. Kulá put watá wahára átang hururung ingmen ámuta re hangga umi máta porá isikimo hára hitangga kung umi pátum kinan hangga umi nangga kámuturáng. ");
INSERT INTO klt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wáina tát ámna kámá put wa pin yáni táená watá wa kangga pitángga kungga pingnga wa it kinan me ále wata kátu káin yánángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iná ámna náráwa yá pingnga wa narángga kanin ingga kungga ku ámna iruk wáik ká ep táená táng toliuk wawu nanaráná yá kándáng hálen sutná kándáng tánggánengga Jesu hárammá hulá hára putung árán kangga pitáuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kulá ámna niyá wahára há átang káuráng watá ku áwuráng ngá wa Jesu yá ámna iruk wáik ká ep táená wa wáina táng tolek ingga pingnga yánuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wáina kangga narángga ámna náráwa Gerasen ále háranan watá pikpito hánám narángga ále ná sangga kung ingga Jesu inuráng, wáina hálendu Jesu wu bot ketnán árángga son há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ámna iruk wáik ká sangga kuráng watá ku Jesu yá kuin ingga táuk wahára isutang káman kukuya inuk, enendu Jesu yá suring mángga inuk, ");
INSERT INTO klt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Itya káin kungga ku Ánutu yá rina háláng kamek wata pingnga yáninelák.” Wáina inán du ámna wawu kung it kinan Jesu yá rina táng mán álo háliuk wata yánángga kuk. ");
INSERT INTO klt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kulá Jesu yá son umi pátum numkálu kung hengngárán du ámna náráwa urum táwi watá heronge hánám naráng muráng, náuta málámba hánám hálengga átnárát kung hiuk wata. ");
INSERT INTO klt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Waháranyon ámna kutná Jairus wawu miti itná watán ámna yáilá watá áwáng Jesu hárammá hulá hára hangga Jesu yá itná káin kukuya inuk, ");
INSERT INTO klt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","náuta uriwa káman re hánám yaraná 12 hám watá hála hánám kámutang árán. Kulá Jesu wu wakáin kuin ingga kuk wahára wu ámna náráwa yá pánpásin hánám árát kuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kulá náráwa káman wahára átuk wawu yara 12 wata kinan yipitná ya rámá rámá kungga rewe átnándak. Káman dá táng totoliyan tárák ku muná. ");
INSERT INTO klt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Málám Jesu sárummá kálu áwuk ngáyá áwáng lapmá hásák wata ilungngá káin tánggáuk wahára re sip hangga átuk watá sálikngiuk. ");
INSERT INTO klt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wáina tán Jesu yá ing yánáng suliuk, “Niyá nehánggáek?” Wáina yánuk, enendu watá kámuk nák muná nák muná ingga inát tu Pita yá ku miuk, “Táwi, ámna náráwa wu kik hánám hálendu áwáng kák hára rosingga koeráng.” ");
INSERT INTO klt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wáina inán Jesu yá miuk, “Ni kámá káman dá nehánggáek, náuta hálángna kátu yá sutna hára sohingga kun naret.” ");
INSERT INTO klt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wáina men du náráwa wawu kilak átnát tán tárák muná hálendu yángyáng pálak áwáng rahán yáni hára Jesu hárammá hulá hára hangga ku inuk, “Ilalákna wáina wata ku áwáng kehánggangga ku wahára re wáina álo hálet,” ingga men du ");
INSERT INTO klt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesu yá inuk, “Uriwana, naráng hákhátikka yá háláng kamek. Wata ku pahán láláp hára kung.” ");
INSERT INTO klt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu yá wa inángga emá me tángga átnárán ámna káman dá miti itná yan ámna yáilá kutná Jairus watán it káin wa átang áwuk watá áwáng Jairus inuk, “Uriwaka wu há kámutak. Márapmá wa tiksa ma imindamán.” ");
INSERT INTO klt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wáina inán narángga Jesu yá Jairus inuk, “Ma pitáindalák, ináku naráng hákhátik hára káto árátá ku álo háleinek,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kulá Jesu málám Jairus yan it káin áwáng hiuk hára wu kátu wa erek káto táng yámángga ku Pita, Jon hang Jeims watyot nangge wata naning maming wa rewe ihángga ku kung it kinan háuráng. ");
INSERT INTO klt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","It kinan kung hangga kápuk ku ámna náráwa it kinan áturáng wawu nangge wata urákngá narángga kutkáyawát tángga árát tu Jesu yá yánuk, “Ukuro ma tániráng, náuta wawu ma kámurak ináku ruhángga átak.” ");
INSERT INTO klt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jesu yá wáina yánán narángga yut muráng, náuta náráwa kimo wawu pálipuk há kámutang átak ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Enendu Jesu yá árong nangge kámurená wata ketná hára tángga inuk, “Nanggena, tárulák!” ");
INSERT INTO klt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wáina inán du kámurená wata irukngá yá son áwán waháranyon tárurán du Jesu yá yánuk, “Náut kámá nanayan kámá imát náik.” ");
INSERT INTO klt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iná nangge wata naning maming gá wa kangga nangnga yándi han átumálák, enendu Jesu yá olet yándi mangga, “Ni kámá káman wáina tunggafek ingga ma inindamálák,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu málám disaepelná 12 wa kámuk hánám mantáng yámán áwát iruk wáik yásusut tán me ilalák hulá hulá wa iháng totoliyan háláng káto wa yámuk. ");
INSERT INTO klt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wáina tángga ku kung Ánutu yan átkuku wata yánángga ilalák mara wa iháng totoliya suring yámuk. ");
INSERT INTO klt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesu málám ing yánuk, “Kálu wa kuineráng hára náut kámá káman ma táindaráng, to me yák me másáng me sup ma ihindaráng, hang sut tátámot tán nukngá kámá hánámá ma ihindaráng. ");
INSERT INTO klt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","It reta kinan ruhineráng watá wahára re átang kungga it kapme wa sangga it kámá káin kuineráng. ");
INSERT INTO klt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iná it kapme káman hára kung het ma sáháng tolit wawu háram sáni káin káwak káhumá wa káting hakhalik tát wahára hat tu it kapme wa sangga kuineráng, watá ku watyot me yá átak háleinek.” ");
INSERT INTO klt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kulá wahára átang gu disaepel yá itná itná wa kungga me pingnga álosim wa yánángga ilalák mara iháng tárut tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Rám wahára kapman táwi átuk kutná Herot watá Jesu yá wáina wáina tánggoek ingga pingnganá narángga árán kámá yá ku menggiuráng, “Jon kámutuk watá son tárutang áwek,” iná kámá yá ku menggiuráng, “Elaija yá son tunggafek,” iná kámá yá ku menggiuráng, “Uláp profet áturáng waháranan káman dá son tárutang áwek,” ingga mengga árát tu, Herot tá wata narángpak táwi hánám wa tángga átang gu ");
INSERT INTO klt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ing miuk, “Jon wawu no yáne salá há maruráng. Iná náwu ni hánám bá ku tárák hulá hulá wa tán met naránggoet?” Wáina mengga ku málámbáyon Jesu kakaya naruk. ");
INSERT INTO klt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kulá aposel yá son áwáng hengga ku wáina wáina tángga átningga áwemán ingga Jesu inuráng. Inát Jesu málám aposelná ihángga ámna náráwa kámuk yápmangga yáni kámuk hánám it kutná Betsaida wakáin kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Enendu ámna náráwa urum táwi watá wáina koek ingga há narángga isutang wakáin kuráng. Kung het kápángga álo áwániráng ingga yánángga árong Ánutu yan átkuku wata yánángga kámá ilalák yáni pálak áwuráng wa iháng toliuk. ");
INSERT INTO klt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yonyon kálu hánám bu disaepelná 12 watá Jesu yan káin áwángga inuráng, “Ámna náráwa wa suring yámátá há yáni kungga it enanggon enanggon káin wa kungga ku it me sungi yáni ya suliniráng, náuta náwu ále páliná muná káin átamán.” ");
INSERT INTO klt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wáina inát tu Jesu yá yánuk, “Sáni sungi yámániráng.” Ing yánán watá inuráng, “Nándu másáng tum 5 bot tu káut yará yá re átaráng. Kulá nándá kung ámna náráwa káwan táwi nátán sungi yuwáwáyan tárák ku muná,” ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iná urum táwi wa áturáng waháranan ámna wu 5,000 wáina tá áturáng. Wáina árát Jesu yá disaepelná yánuk, “Kulá ámna náráwa wa iháng 50 ina yá urum káman káman erek tit putung átniráng.” ");
INSERT INTO klt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kulá disaepel yá Jesu yá rina yánuk wáina tát erek hánám wa putung áturáng. ");
INSERT INTO klt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wáina árát tu Jesu málám másáng tum 5 watyot káut yará wa ihánggatang alek kálu hálengga Táwi ya heronge me inángga sungi wa ketná yá hikhuk tángga iháng disaepelná yámán ámna náráwa ya ting yámángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wa yámát nangga kámuk hánám kawin yáni hahatin du disaepel yá sungi káhumá áturáng wa iháng rápmám 12 wa tuwat hánám monduráng. ");
INSERT INTO klt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Rám káman Jesu yá disaepelná yot yáni wu ále káman káin yáni re átang Jesu yá sáponga tángga sangga ku yánuk, “Ámna náráwa yá nákka ku ni ingga menggoeráng?” ");
INSERT INTO klt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wáina yánán du watá inuráng, “Kámá yá ku Jon Umi Kuháng Yámámá ing met, kámá yá ku Elaija ing met, kámá yá ku uláp profet áturáng waháranan káman dá son tárutang áwek ing menggoeráng.” ");
INSERT INTO klt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Iná sáni wu nákka ni ing menggoeráng?” Wáina yánán Pita yá miuk, “Kák ku Ánutu yá suring mán hangga ámna náráwaná son iháháya miuk wa.” ");
INSERT INTO klt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ing inán du ni kámá kámá ma yánindaráng ingga Jesu yá olet yáni máuk. ");
INSERT INTO klt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kulá Jesu yá ing yánuk, “Ámna Nanggená wawu sut láwit táwi hánám narinek. Ámna yáilá me pris tátáwi yáni me lo yan tiksa yá táng kep tit utkámut táineráng ngáya rám kaláhu átang gu Ánutu yá son táng tárut táinek.” ");
INSERT INTO klt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hang ámna náráwa kámuk hánám ing yánuk, “Káman dá nák natnasut ta ku málámbán pahán wa sang hálingga rámá rámá málámbán maripong wa sungga tánggatang gu nák nasutnek. ");
INSERT INTO klt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iná niyá málámbán átnát wata narángpak táinek wawu átkukuná watá muná kuinek. Iná káman dá nákka narángga átnát ná wa sáinek wawu átkukuná watá ma muná kuindák. ");
INSERT INTO klt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kulá ámna káman káwak nátán kutná kutná álosim wa erek átmánggim hára átkukuná yá muná kunggim, wahára wu kutná kutná átmánggim watá ku rina háláng imánggim? ");
INSERT INTO klt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iná ámna káman dá nák me nákkán me wata reprepmá tánggim wawu máriya rám kálu Ámna Nanggená yá málámba yamá me Naning ga yamá me angelo káungá ya yam yáni kinan áwánggim wahára wu reprepmá yon kanggim. ");
INSERT INTO klt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No pálipuk hánám ing sánin, kámá sán nahára átaráng wawu ma kámurená átang Ánutu yan átkuku wa káineráng.” ");
INSERT INTO klt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesu yá wa mengga sangga hang rám 8 náut wáina átang gu Pita, Jon hang Jeims wa ihángga ále yáilá káin sáponga tátáya árángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Málám sáponga tángga átuk wahára wu kurákmáta watá hulá kámá hálen kutná kutná sutná tánggániuk watá hakokowak hánám háliuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Rám wahára wu ámna yará Moses káling Elaija yá tunggafengga Jesu yot áturáng. ");
INSERT INTO klt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yándi wu yamá táwi watyot tunggafengga átang Jerusalem káin Jesu yá rina táinek ka Ánutu yá miuk wa táng hálingga sangga torong káin du káwak sangga alek káin kuinek wata mená me tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wahára wu Pita yot disaepel nukngá yará wawu rapmung gá yángen ránáng táriuráng ga son rahán yáni rong hánám hálengga ku Jesu yan yamá táwi watá yamá mangga árán du ámna yará watá Jesu yot árát kápuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kulá ámna yará watá Jesu sangga kukuya tángga árán du Pita yá Jesu inuk, “Táwi, nándá nahára há átamán wawu álosim. Kulá sima kaláhu usinemán wawu káman kákkán, káman Moses yan hang káman Elaija yan.” Pita yá wáina meinet ingga ma narená hánámá miuk. ");
INSERT INTO klt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita yá me wa mengga átnárán waháranyon du mukam bá áwáng iháng támorán disaepel yáni wu pikpito hánám wa naruráng. ");
INSERT INTO klt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kulá mukam kinan du me káman dá ing áwuk, “Náwu nák Nanggena. Na nakán yáup tátáya táng tunggap táut. Watán me narineráng.” ");
INSERT INTO klt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Me wa meng hálin hálengga káuráng gu Jesu yá málám re árán. Kulá ále yáilá káin átang háuráng rám wahára wu tárák wáina káemán ingga nukngá kámá ma yánuráng, ináku yáni hára re átuk. ");
INSERT INTO klt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ále yáilá káin áruráng wata tembátnáya hangngárát ámna náráwa urum táwi hánám watá Jesu yan káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ámna náráwa urum táwi áturáng wata orek yáni káin du ámna káman dá mantáuk, “Táwi, no ing kanindet, ko nák nanggena ya káinelák. Nák ku nanggena wu káman ná rewe. ");
INSERT INTO klt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rám iruk wáik ká ep tángngátak hára ku huhu tángga mantángga átnándak. Watá wáina tán du yángyáng tángga alupmá yá máta kálu num ángáráng tángga átnándak. Iruk watá ma sangga koená átang sutná wa táng wáik hánám tángngátak. ");
INSERT INTO klt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iruk wáik ná isutniráng ingga disaepelka há yánut, enendu wata isutsut tán tárák muná.” ");
INSERT INTO klt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wáina inán Jesu yá miuk, “Ámna náráwa sándu naráng hákhátik sáni wu muná. Rám rina sányot áre sándá márapmá namineráng? Nanggeka wa tángga nákáin áwáng.” ");
INSERT INTO klt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kulá nangge watá Jesu yan káin áwángga átuk, wahára wu iruk wáik watá nangge wa táng san káwak hára wa hang yángyáng tángga árán du Jesu yá iruk wáik wa me táng mángga nangge wa táng tolingga táng naning imuk. ");
INSERT INTO klt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ánutu yá ket tárák táwi wa tán kangga ámna náráwa urum táwi watá nangnga yáni han árát tu Jesu yá disaepelná yánuk, ");
INSERT INTO klt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kárámatingga kándáng hánám narineráng. Ámna Nanggená wawu táng káyam ket yáni hára tineráng.” ");
INSERT INTO klt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wáina yánuk, enendu disaepelná yá hulá wáina ta nánek ingga ma hánám naráng rákit táuráng. Me wata hulá wu kilak átuk hálendu disaepel yá ma naráng ruwat táuráng. Kulá me wata hulá wa naránin ingga ináng susuliya wu hányon pitáng muráng. ");
INSERT INTO klt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Rám káman disaepel yáni wu niyá ku máta hánám átgim ingga wata menmen táuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu málám pahán yáni káin wáina átak ingga há narángga sangga málám nangge kimo káman táng áwáng rupmá hára ting san árán du ");
INSERT INTO klt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yánuk, “Káman niyá nák ka narángga nangge kimo ná táng tolinek wawu nák neháng tolinek, hang káman niyá nák neháng tolinek wawu Nanna niyá nák suring namuk wa táng tolinek. Sán wa átaráng wata rahán sáni hára niyá isikimo hánám átak watá ku Táwi rahálá hára ku táwi hánám átak.” ");
INSERT INTO klt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wáina men narángga ku Jon dá miuk, “Táwi, nándá káumán du ámna káman dá kák kutya hára iruk wáik yásutang árán kangga wáina ma táindalák ingga káto táng mumán, náuta wawu nándán tombong muná.” ");
INSERT INTO klt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wáina men du Jesu yá ing inuk, “Ma káto táng mindaráng. Ámna niyá káyam ma sáhindák wawu nuk sáni ku wa.” ");
INSERT INTO klt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ánutu yá Jesu tángga alek káin kukuyan rám watá hátewin du Jesu yá pahálá me nanaráná watá Jerusalem káin há kuin ingga pahán tiuk. ");
INSERT INTO klt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wáina hálendu ámna kámá suring yámán watá kálak kung Samaria ále káin it káman hára kutná kutná tiyawing mámáya kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Enendu it waháranan ámna yá Jesu wu Jerusalem kukuya áwek ingga há naruráng, wata ku watá áwáng watán it hára átnát ta taktak yámuk. ");
INSERT INTO klt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wáina ingga há narángga disaepel yará Jeims káling Jon watá Jesu inumálák, “Táwi, ko rina narelák, alek káinnan káráp lánggop metne hang iháng lem táik me rina?” ");
INSERT INTO klt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wáina inán Jesu yá hurik tángga me táng yámán du ");
INSERT INTO klt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","it wa sangga it nukngá káin kuráng. ");
INSERT INTO klt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kulá kálu hára kungga áturáng wahára wu ámna káman dá Jesu inuk, “Nák ku ko rehára rehára kuinelák wawu kákkot káman re átkuinemát.” ");
INSERT INTO klt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wáina inán Jesu yá inuk, “Ang páyom bu káwak káin hinang yáni átaráng, hang iráp pu it yáni pálak, iná Ámna Nanggená wawu ruruháyan komená kámá ma árak.” ");
INSERT INTO klt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kulá Jesu yá ámna káman inuk, “Nák nasulák.” Wáina inán ámna watá inuk, “Táwi, hulátingga ku satá no kung nanna yot áre watá kámurán wa usángga ku wáina kák kasutnet.” ");
INSERT INTO klt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wáina men Jesu yá inuk, “Wáinaná satá kámurená yá ku nuk yáni kámurená wa iháng usángguineráng, iná kák ku kungga Ánutu yan átkuku wata meng tunggap tángga yánángga kuinelák.” ");
INSERT INTO klt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kulá ámna nukngá yá ku Jesu inuk, “Táwi, nák ku kák kasutnet, enendu hulátingga ku satá no kung nanna mamna wáina ingga yánángga sangga ku áwáng kák kasutang kuinet.” ");
INSERT INTO klt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wáina inán Jesu yá inuk, “Káman dá Táwi yan yáup táin ingga ku hurik tángga sárummá kálu ma háleindak, ámna wáinaná watá Ánutu yan átkuku watán yáup tátáyan tárák ku muná.” ");
INSERT INTO klt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Átang árongga ku Táwi yá ámna 72 nukngá iháng tunggap tángga yará yará suring yámán watá kálak it tátáwi me it isikikimo rehára kukuya naruk wakáin kukuya yánuk. ");
INSERT INTO klt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kulá ámna watá kuinán tát tu ing yánuk, “Hái káin sungi tánang kukuyan du táup hánám, iná yáup ámna wa tánang kukuyan du táup muná, wata ku Táwi, hái márumá, watán káin sáponga tát tu yáup ámna suring yámán háiná káin kungga sungi álikngená wa tánang kuineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kulá ing narángga ku kuineráng, no wa suring sáme kuineráng wawu sipsip nángánangge yá ina ang páyom orek yáni káin kuineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sup tumá me yák me sendol ma ihindaráng me ni kámá káman kálu hára kangga ma kangmeindaráng. ");
INSERT INTO klt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kung it káman hára árángga ku hulátingga ku ing meineráng, ‘Pahán láláp pá it náta kinan átnek.’ ");
INSERT INTO klt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ámna káman pahán láláp pán dá it wata kinan átnek hálendu sándán pahán láláp me watá hang wahára ep táinek, iná muná hálendu son hurik tángga sánin káin áwinek. ");
INSERT INTO klt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","It wata kinan átang sungi me umi sámát tu álo náineráng. Ámna niyá yáup táinek watá ku yumnakngá ihinek wawu álo kámá. It kámá hára árángga kungkung ma táindaráng. ");
INSERT INTO klt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Rám kámá it káman hára kut watá heronge tángga sáhángga ku sungi ihángngáwáng sámineráng wa álo náineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hang ilalák mara waháranan wa iháng tolingga ku yánineráng, ‘Ánutu yan átkuku wu sáni ya tangtang átak,’ ingga yánineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iná it káman hára kut ma sáhát tu kung it wata káluná hára átang gu ing meineráng, ");
INSERT INTO klt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘It nátán káwak ká nán háram náni káin tápingga átaráng wa son nándá káting hiratne háek wawu sándá kangga ku ing narineráng, sándá ma náháráng wawu kandák táeráng. Hang kándáng hánám ing narineráng, Ánutu yan átkuku wawu enanggon átak,’ ingga yánineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","No ing sánin, máriya rám kálu it Sodom bá márapmá suwinek wawu maming táwi yon, enendu it watá márapmá suwinek wawu wa táng hátinek. ");
INSERT INTO klt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ukuro táwi, ámna náráwa it Korasin me it Betsaida nan! No ket tárák sándán káin há táut, enendu sándá pahán hurik ma táuráng. Iná no ket tárák sándán káin táut wáinanyon Tair me Saidon dán ámna náráwa káin táe ináku uláppon pahán hurik há tángga ukuro yan lap wáik wa tánggánengga kuhi kuhángga átgalát. ");
INSERT INTO klt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rám Ánutu yá narek ngá wahára, ámna náráwa yá me hára átneráng wawu Tair me Saidon dá márapmá suwinemálák wawu maming táwi yon, enendu sándá márapmá suwineráng wawu wa táng hátinek. ");
INSERT INTO klt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iná it Kapaneam bu Ánutu yá iháng áráng alek káin tinek me? Wa muná yon, wawu iháng hang káráp lánggop káin tinek. ");
INSERT INTO klt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Niyá sándán me narinek wawu nákkán me narinek, iná niyá sánda taktak minek wawu nákka taktak minek, hang nákka taktak minek wawu niyá nák suring namuk wata taktak minek.” ");
INSERT INTO klt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wáina yánán ámna 72 Jesu yá suring yámuk watá kuráng ngáyá son heronge hánám áwángga miuráng, “Táwi, kák kutya hára yánátne iruk wáik ká nándán me narángga isutkiuráng.” ");
INSERT INTO klt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wáina inát Jesu yá yánuk, “No kangngáre Satan dá alek káin átnárán Ánutu yá isurán pikpirik ká sokmuná hánám hangngátak wáinanyon rákitang háuk. ");
INSERT INTO klt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","No háláng wa há sámut wawu sándá kunap me utni yan kálung wa álo yáreng kátkámut táineráng, káman dá ma sángeindák. Iná háláng nukngá sámut wawu káyam sáni Satan dán háláng wa táng hang tineráng, me náut kámá káman dá sáháng lem ma táindák ka. ");
INSERT INTO klt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kulá sándá ku iruk wáik ká nándán milun suweráng ingga heronge ma táindaráng, ináku Ánutu yá kut sáni alek káin papianá káin uyiuk wata heronge narineráng.” ");
INSERT INTO klt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Rám wahára Iruk Káungá watá Jesu táwi hánám imáng rosingga árán málám pahálá heronge narángga ku ing miuk, “Nan, alek me káwak kán Táwi, no kutya meng tárut táin, náuta ko me álo kámá ná ámna álosim nanará pálak átaráng wata kilak ting yámángga ku niyá nangge kimo yá ina átaráng wa yálenggoelák. Nan, pálipuk ko kangán nanará isutang wáina tánggoelák.” ");
INSERT INTO klt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesu yá wáina inángga ku ing miuk, “Nanna yá nanará me háláng wawu kámuk hánám iháng nák ketna hára tiuk. Ni kámá káman dá Nangge wawu wa ingga ma naráng mák, ináku Nan dá ku naráng mek, hang ni kámá káman dá Nan wawu ma naráng mák, ináku Nanggená watá ku naráng mek me ámna náráwa nini Nanggená yá yáliuk watá ku naráng meráng.” ");
INSERT INTO klt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kulá son hurik tángga disaepelná yáni re yánuk, “Sándá náut kanggoeráng wa ámna náráwa kámá yá káineráng wahára wu watá heronge narineráng. ");
INSERT INTO klt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No ing sánin, uláp profet me king áturáng watá sándá náut kanggoeráng wa kanin ingga naránggiuráng, enendu ma kanggiuráng, hang sándá me rina naránggoeráng wa naránin ingga tánggiuráng, enendu ma naránggiuráng.” ");
INSERT INTO klt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Rám káman lo yan nanará ámna káman dá Jesu ingirungngin ingga tárutang inuk, “Tiksa, no rina tángga ku átkuku álosim sásáliná muná wa táinet?” ");
INSERT INTO klt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wáina inán Jesu yá inuk, “Meng rákit mená káin rina uyená yá átak? Rina sángingga narángngátalák?” ");
INSERT INTO klt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jesu yá wáina inán du ámna watá miuk, “‘Táwi Ánutu wata pahála yot, irukka yot, hálángga yot me nanaráka yot kikiná hánám wa narinelák.’ Hang ‘kaya kikiná narángngátalák wáinanyon nangge nukka ya kikiná narinelák.’” ");
INSERT INTO klt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wáina men Jesu yá inuk, “Kándáng hánám wa melák. Wáina tángga ku átkuku álosim wa táinelák.” ");
INSERT INTO klt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jesu yá wáina inán du lo yan nanará ámna watá Jesu yá nanaráná kandák ingga nahiwon ingga ku son inuk, “Meng rákit mená yá nukna ya mek wawu nukna ku ni?” ");
INSERT INTO klt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wáina inán du Jesu yá inuk, “Ámna káman dá Jerusalem káin átang gu Jeriko káin kung háin ingga kungngárán manek mara yá ket táuráng. Wáina tángga táup utang lap tánggániuk wa yaling mángga kutná kutná ná erek iháng mángga yáni wu sangga kut kálu hára wa hála kámutang átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wáina árán pris káman du kálu wanyon isutang kung háuk ngáyá hang wáina kangga málám kálu tákto numkálu kang yálingga háná kuk. ");
INSERT INTO klt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kang yálingga kun son tombong Liwai waháranan káman dá kálu wanyon kungga wáinanyon árán káuk, enendu kang yálingga kálu tákto numkálu kungga háná kuk. ");
INSERT INTO klt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kulá Samaria nan ámna káman dá áwángga ámna watá átuk wahára áwáng hengga kangga urákngá narángga ");
INSERT INTO klt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","rupmá tangtang kungga ámna wata putulá káin oel yot wáin kuling mángga ku putulá wa hárot muk. Wáina tángga ku málám ámna wa táng hip tángga táng málámbán donki ketnán tingga táng kung lombu it káman hára tingga ku kándáng hánám pinná táuk. ");
INSERT INTO klt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kulá tembátnáya ku sup silva táulá yará iháng lombu it wata márumá wa imángga ku inuk, ‘Ámna ná kándáng pinná tángga átnelák. No son áwángga ku sup kátu rina kakán hára ámna ná háláng mámáya sáinelák wa topmá kaminet.’” ");
INSERT INTO klt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wáina meng hálingga ku Jesu yá nanará ámna wa inuk, “Ámna kaláhu waháranan du retá ku ámna manek mara yá uturáng wa kangga nuk táng muk?” ");
INSERT INTO klt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wáina inán nanará ámna watá miuk, “Ámna retá urákngá narángga háláng muk wa.” Ing men du Jesu yá inuk, “Ko kungga ku tárák wáinanyon táinelák.” ");
INSERT INTO klt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu yá disaepelná yot kungga it káman hára kung het tu it waháranan náráwa káman kutná Mata watá Jesu engotang itná káin kuk. ");
INSERT INTO klt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Náráwa wata yitná kutná Maria watá ku áwáng Táwi hárammá hulá hára putung átang me rina menggatuk wa kárámatingga átuk. ");
INSERT INTO klt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kulá Mata wu sungi tiktiyawik tánggatang káuk ku yáup pá táwi hálen wata narángpak tángga ku kung Jesu inuk, “Táwi, yitna yá nepman na rewe sungi tiktiyawik wa tángga átat, kák ka wawa kanggoelák me? Ko inátá kámá háláng namik!” ");
INSERT INTO klt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wáina inán du Táwi yá inuk, “Mata, Mata, kák ku kutná kutná táup hánám wata narángpak tángga pahán márap táelák. ");
INSERT INTO klt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ináku káman da re narinelák. Maria yá náut tátáya átak wawu álo kámá hánám, wawu táng sat kukuyan du muná.” ");
INSERT INTO klt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Rám káman Jesu málám ále ore káman káin átang sáponga táng hálin du disaepelná káman dá inuk, “Táwi, sáponga tátáyan káluná kámá nánáng toling, Jon dá disaepelná yánáng toliuk wáinanyon.” ");
INSERT INTO klt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wáina inán du Jesu yá yánuk, “Rám sándá sáponga tángga ku ing mengguineráng: ‘Nan, kutya yá káungá hánám wa átkuinek, kákkán átkuku watá nándán káin áwinek. ");
INSERT INTO klt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rám káman káman dán sungi wa málámbán málámbán námángguinelák. ");
INSERT INTO klt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ko nándán kandák wa kátu náni sáinelák, náuta nándá kámá yá kandák rina táng námená wa kátu yáni sangngátamán wáinanyon. Ko metá ingirungngingi yá nándán káin ma tunggafeindak.’” ");
INSERT INTO klt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wáina mengga ku ing yánuk, “Sán háranan káman dá yáung táitná hánám kung nukngá káman inánggim, ‘Nukna, másáng kaláhu namáng, ");
INSERT INTO klt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","náuta ámna nukna káman dá kálu mulangán áwángga nákkán káin áwek, enendu no sungi káman táng wa imámáyan du muná.’ ");
INSERT INTO klt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Kulá wáina inán du nukngá it kinan káin átgim watá ku inánggim, ‘Ko nák yáup ma namindalák. Kálu káto tángga nángánanggena yot kome káin há ruruháya tángga átamán. No tárutang náut kámá káman ma kamindát,’ ingga inánggim. ");
INSERT INTO klt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No ing sánin, it márumá watá tárutgim ngáyá ku kutná kutná nukngá yá náuta naránggim wa erek ingmen imánggim. Watá nukna háláng imin ingga ma imánggim, ináku nukngá watá áwáng sonson mantáng mángga átnát wata taktak mán du wáina tánggim. ");
INSERT INTO klt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Wata ku no ing sánin, Táwi inát tu sáminek, sulingga ku káineráng, károk károk kátit tu kálu yaling sáminek. ");
INSERT INTO klt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ámna niyá Ánutu inángngátaráng watá ku páliná kangngátaráng, ámna niyá sulingngátaráng watá ku kang tunggap tángngátaráng, hang ámna niyá kálu hára kátingngátaráng watá ku Ánutu yá kálu yaling yámángngátak. ");
INSERT INTO klt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ámna káman dá ku nanggená yá káut ta inán da kunap pa álo imánggim? ");
INSERT INTO klt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Me nanggená yá hurák tunggulá ya inán da naning gá utni yan kálung ga álo imánggim? ");
INSERT INTO klt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kulá nangge nanan yáni sándu kandák táwi hánám tángngátaráng, enendu nángánangge sáni yá náut álosim ba sánát tu há yámángngátaráng. Iná Nan sáni alek káin átak wawu álosim hánám, niyá inán Iruk Káungá wa imámáya wu heronge hánám narángngátak.” ");
INSERT INTO klt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kulá ámna káman iruk wáik ká tán mená ma me tángngátak watá átnárán, iruk wáik wa Jesu yá isurán du ámna wa sangga kun du ámna watá kándáng hánám meme tángga árán kangga ámna náráwa yá hárámuturáng. ");
INSERT INTO klt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iná kámá yá ku miuráng, “Iruk wáik táwi yáni Belsebul watán háláng hára iruk wáik wa yásutkoek.” ");
INSERT INTO klt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hang kámá yá ku ingirungngingga ináng sulitne tárák kámá tán kangga wawu alek káinnan me muná ingga kakaya wahára átang ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesu málám pahán yáni káin wáina átak ingga há narángga ku yánuk, “Káwak káman hára árená yá yáni yon honhoren tánggalát wawu káwak watá wáik hálenggim. Hang amba káman hára árená yá yáni yon honhoren tánggalát wawu amba watá kándáng ma átgim. ");
INSERT INTO klt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hang Satan dán tombong gá yáni yon honhoren tánggalát wawu rina tángga ku kutná kutná yáni watá kándáng átgalát? No ná met wawu náuta sándá no Belsebul yan háláng hára ku iruk wáik yásutkoet ing meráng wata. ");
INSERT INTO klt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No Belsebul yan háláng hára iruk wáik wa yásutkoet hálendu sándán tombong gá ku niyan háláng hára iruk wáik yásutkoeráng? Sánin tombong watá yon du hulá sáni yalineráng sánin me wawu kandák ingga. ");
INSERT INTO klt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iná no iruk wáik wa Ánutu yan háláng hára yásutkoet hálen wawu Ánutu yan átkuku watá sándán káin há áwek. ");
INSERT INTO klt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ámna hánghálángngá káman dá kutná kutná máta ángárángngá ihángga itná pinná tángga kandingga átgim wawu kutná kutná itná pahálá kinan watá kándáng re átgim. ");
INSERT INTO klt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Iná ámna káman hánghálángngá hánám watá áwáng it márumá watyot erawángga watá re hahatinggim hára wu náut máta ángárángngá háláng imámáya ihángga átgim wa iháng mángga itná kinan kutná kutná ná wa horengga iháng mánggalát. ");
INSERT INTO klt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Káman ni nák nukna muná wawu nák neháng káyam tángngátak, iná káman niyá nák háláng namángga ámna náráwa iháng urum ma tingngátak wawu yásurán hangga káman káman kungngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Rám iruk wáik ká ámna nangge sangga kungngátak wahára wu kungga ále manmanná káin rehára átnet ingga kome ya sulingngátak. Sulingga átkun men du, ‘Satá son kungga it sangga áwut wakáin yon árin,’ ing mengngátak. ");
INSERT INTO klt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wáina mengga málám áwángga kangngátak ku ámna sangga kuk wata pahálá wawu it pahálá ina sinsin hiratang kutná kutná it kinan wa iháng tolingga kándáng tená wáina. ");
INSERT INTO klt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wáina hálendu málám kuinek ngáyá kung iruk wáik 7 watá mukmuro táwi hánám tángngátaráng wa kápángga yángotnáwáng gu kung hang átneráng. Kulá wahára ámna watán átnát wa káinelák ku huphuráp átkiuk wa táng hátingga wáik hánám háleinek.” ");
INSERT INTO klt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu yá me wa menggatuk waháranyon du ámna náráwa urum táwi orek yáni kinan káin náráwa káman dá mantáuk, “Náráwa niyá kák keháng tiuk me muk kamuk watá heronge hánám átang átkuinek.” ");
INSERT INTO klt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wáina mantán Jesu yá miuk, “Wáina muná, ináku ámna náráwa niyá Ánutu yan me wa narángga isutang átang átkuineráng watá heronge hánám átang átkuineráng.” ");
INSERT INTO klt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ámna náráwa yá uyingga Jesu yan káin emá re áwángga árát tu Jesu yá yánuk, “Rám nátán ámna náráwa wawu wáik hánám, watá ku tárák ká tunggafen kakaya re menggoeráng, enendu kámá ma káindáráng, iná tárák káineráng wawu profet Jona yan wa. ");
INSERT INTO klt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Uláp Ánutu yá tárák Jona hára Niniwe ámna náráwa yáliuk, wáinanyon du Ámna Nanggená hára Ánutu yá rám nátán ámna náráwa wa yáleinek. ");
INSERT INTO klt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Rám Ánutu yá ámna náráwa iháng me hára titiyan rám bá áwinek wahára wu Kuin káwak ámuta káinnan watá tárutang rám nátán ámna náráwa yan ket tárák wáik wata meng tunggap táinek. Kuin wawu it mulangán hánám káinnan Solomon dá nanaráná álosim wa men narin ingga áwuk, enendu ámna káman Solomon torong káin átak wawu nahára há átak, watán me wawu ma narángguráng. ");
INSERT INTO klt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ánutu yá ámna náráwa iháng me hára titiyan rám hára wu Niniwe ámna yá tárutang rám nátán ámna náráwa watán ket tárák wáik wata meng tunggap táineráng, náuta Niniwe yá ku me Jona yá meng tunggap táuk wa narángga pahán hurik há táuráng, enendu ámna káman Jona torong káin átak wawu nahára há átak, watán me wawu ma narángguráng.” ");
INSERT INTO klt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesu yá ing miuk, “Ámna káman dá lam kasingga táng susuná káin ma tingngátak, me táng baket kinan káin ma tingngátak. Ináku táng tutuháná hára tuhángga san árán du niyá it kinan áwinek watá ku yamá wa káinek. ");
INSERT INTO klt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Rahála wawu sutya watán lam, rahála watá álosim átnek wahára wu sutya kámuk hánám wawu yamá yá átnek, iná rahála yá wáik háleinek wahára wu sutya kámuk hánám páyung tingga átnek. ");
INSERT INTO klt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wata ku kándáng hánám átnelák, ko páyung watá kaya kinan árán yamá yá naya kinan átak ingga narilon. ");
INSERT INTO klt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iná yamá yá sutya kámuk hánám wata kinan átnek wahára wu sutya kátu káin páyung gá ma átnándák, ináku lam yamá yá ka hára yamá mangga átnándak wáinanyon átnelák.” ");
INSERT INTO klt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kulá Jesu yá me wa erek meng hálin du Farisi káman dá nákkán it káin sungi nandin ing inángga kumálák watá kung Jesu yá tebol hára putung átuk. ");
INSERT INTO klt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wáina átang gu Jesu yá ketná kálak ma yawolená sungi nangga árán kangga Farisi watá hárámutuk. ");
INSERT INTO klt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wáina hárámurán kangga Táwi yá inuk, “Farisi sándán ket tárák wawu kap me tera sutná káin re yawolát, pahán yáni káin konep pá ku há átnándaráng wáina. Sáni wu sut sáni káin re yawonándaráng, iná pahán sáni kinan du kápáng naknarák me wáik wáina watá táwi hánám átnándak. ");
INSERT INTO klt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sán du hohoná! Ánutu yá kep káin sáháng tolingga ku kinan kálu ma hám sáháng toliuk? ");
INSERT INTO klt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Náutá tera kinan átaráng wa iháng niyá ukuro átaráng wa yámát tu kutná kutná yá Ánutu rahálá hára rongrongngá re átsámineráng. ");
INSERT INTO klt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisi sán du ukuro táwi narineráng, náuta hái káinnan tának me sungi táng kikik tátáyan wawu horet 10 hálen urum káman táng Ánutu ya ting mángngátaráng, enendu nangge nuk sáni háláng yámámá yot Ánutu ya pahán káin kikiná nanará wawu sangngátaráng. Ket tárák ná ma sáindaráng, ináku wa há tángga átang gu kutná kutná hohoreyan mek wa hányon isutneráng. ");
INSERT INTO klt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisi sán du ukuro táwi narineráng, náuta miti itná káin du tongtong máta káin átnát ta narángngátaráng, me urum komená káin du ámna kámá yá sáhángga heronge táng sásámá wata narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ukuro táwi narineráng, náuta sán du tanggán hára keho ma hená ina árát ámna yá wata ketnán ma kápená kung áwáng tángngátaráng.” ");
INSERT INTO klt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesu yá me wa yánán lo yan hulá nanará káman dá Jesu ing inuk, “Tiksa, ko Farisi me wa yánángga ku nánda yanyawon hányon táng námánggoelák.” ");
INSERT INTO klt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wáina men Jesu yá miuk, “Iná sán lo yan hulá nanará, ukuro táwi narineráng, náuta márapmá táwi ma susuwáyan wa ámna náráwa yámángga ku ket sáni táng hip tángga kimo ma háláng yámángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Sán du ukuro táwi narineráng, náuta táwi ilom sáni yá profet ráháng kátkámut táuráng watán tanggán wa tánggáneng sat álosim hánám árán du ");
INSERT INTO klt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","kálu wahára wu ámna rahán yáni hára táwi ilom sáni yá profet ráháng kátkámut táuráng wawu álosim ingga naránggoeráng, wata ku watán tanggán wa tánggánenggoeráng. ");
INSERT INTO klt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wata ku Ánutu yá málámbán nanará me kálu kándáng wahára kungga ku ing miuk, ‘No profet yot aposel suring yáme sándán káin kut tu kámá ráháng kátkámut tángga ku kámá iháng lemlem táineráng.’ ");
INSERT INTO klt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wáina wata ku hulátingga Ánutu yá káwak táng tunggap táuk hára átang áwáng rám nahára ámna yá profet ráháng kátkámut táuráng watán márapmá wu rám nátán ámna náráwa sányot átnek. ");
INSERT INTO klt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Uláp profet ráháng kátkámut táuráng, wawu hulátingga Abel hára átang áwáng Sekaraia ni Táwi yan it káungá hánám bot tingnaknak orek yándi hára utkámut táuráng. Kulá watán márapmá táwi wawu rám nátán ámna náráwa sányot átnek. ");
INSERT INTO klt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Lo yan nanará ámna sán du ukuro táwi narineráng, náuta kálu mungnga hutang kung hang nanará álosim tátá watán ki wawu sándá há táng sat kuk. Sáni kung ma háená átkoeráng ngáyá ámna náráwa kámá yá kung hanin ingga tángngárát tu sándá kálu susuwá táng yámánggoeráng.” ");
INSERT INTO klt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Kulá Jesu yá wáina yánáng hálingga ku it wa sangga kuk. Wahára átang hulátingga ku Farisi yot lo yan hulá nanará ámna watá Jesu ya pahán káráp táng mángga ingirungngitne me kandák kámá men kangga ku táng me hára tinin ingga sonson ináng suksulik tángga átang áruráng. ");
INSERT INTO klt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Rám ore waháranyon ámna náráwa táup hánám rina kámá tausen watá áwáng kik hánám átang kámá yá kámá ya háram yáni ketnán tandaren tángga árát tu Jesu yá disaepelná kálak ing yánuk, “Farisi yan yis wata kándáng hánám háleng rákit tángga átkuineráng. Táwi ya naráng háting memán ing mengngátaráng, enendu pálipuk hánám bu Táwi ya ma naráng háting mángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Me kámá tum táená wawu hiták háleineráng, hang me kámá kilak átaráng wawu hiták narineráng. ");
INSERT INTO klt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iná me rina kilak sándá menggoeráng wawu ámna náráwa kámuk ká hiták narineráng, hang me rina me kotkot kálu káráman hára re it kinan met naránggoeráng wawu it kapme hára átang hahatingga meng tunggap tát ámna náráwa yá narineráng. ");
INSERT INTO klt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yanuknukna, no ing sánin, káman niyá káwak sut re utkámut tángga máriná káin rina kámá kámá ma táindák wata ma pitáindaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","No niya pitáng mineráng wa hiták sánin, wawu niyá káwak sut utkámut tátá me sáháng sup pora káin hirarán hahayan háláng watá watyot átak. Wata ku pálipuk hánám ing sánin, wata pitáng mineráng. ");
INSERT INTO klt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ámna yá iráp isikikimo 5 wawu supmá háená hánám bá yungngátaráng, enendu Ánutu yá iráp waháranan káman da ma kalot mángngátak. ");
INSERT INTO klt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iná sándu iráp isikikimo wa iháng háteráng. Hang yáin sáni rommá wawu salená wáina ingga Ánutu yá há narek, wata ku ma pitáindaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“No ing sánin, káman niyá málám ba Jesu yan tombong hára átat ingga ámna náráwa yánáng kuinek wawu Ámna Nanggená yá wáinanyon Ánutu yan angelo rahán yáni hára wawu nákkán tombong ingga meng tunggap táinek. ");
INSERT INTO klt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iná ámna káman dá málám ba Jesu yan tombong hára ma árat ingga ámna náráwa yánáng kuinek wawu no wáinanyon wawu nákkán tombong muná ingga Ánutu yan angelo rahán yáni hára meng tunggap táinet. ");
INSERT INTO klt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hang ámna káman dá Ámna Nanggená ya sárum meme táinek wawu Ánutu yá watán kátu wa sáinek, iná káman niyá Iruk Káungá ya sárum meme táinek wawu Ánutu yá watán kátu wa ma sáindák. ");
INSERT INTO klt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Iná ket sáhángga miti itná káin me kapman dán káin me ámna yáilá yan káin kung rahán yáni hára sáháng me hára tit tu me rina meinemán ingga narángpak ma táindaráng, ");
INSERT INTO klt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","náuta Iruk Káungá watá rina meineráng wawu rám waháranyon sáninek.” ");
INSERT INTO klt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wáina yánán urum táwi áturáng wata kinan káin ámna káman dá Jesu inuk, “Tiksa, nanna wu há kámutuk, wata ku tatna inátá ku nan dá kámutang kutná kutná yápmáuk ngá wa kátu horengga nák naminek.” ");
INSERT INTO klt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wáina inán Jesu yá inuk, “Nukna, niyá ku sándán me nanará ya nák neháng tunggap táuk ka ku no ore hára átang sándán kutná kutná wa horeng sáminet?” ");
INSERT INTO klt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wáina mengga ku ámna náráwa ing yánuk, “Kándáng háleng rákit tángga átneráng. Kutná kutná wa kápángga kápáng naknarák tánirot. Kutná kutná ka táup hánám enendu kutná kutná watá háláng kamát kung átkuku wa ma táindálák.” ");
INSERT INTO klt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hang me tárákngá ing mengga yánuk, “Ámna supmá pálak káman dán hái yá páliná táwi hánám wa tingga árán kangga ");
INSERT INTO klt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","málám ing naruk, ‘Rina táinet? Kome kámá sungi wa iháng titiyan kámá ma árak.’ ");
INSERT INTO klt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Wáina narángga átang gu ing naruk, ‘Wata ku ing táinet, sungi itná isikikimo átaráng wa erek yalingga ku son sungi itná maming tátáwi táinet. Tángga ku sungi me ále kutná kutná na wa iháng wata kinan tinet. ");
INSERT INTO klt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wáina tángga ku nayon na ing ininet, “Kák ku kutná kutná ka álosim táup hánám átyameráng watá háláng kamán yara táup hánám wáina átnelák. Kula wu sek narángga átang rámá rámá sungi tátáwi sinangga heronge torong hára átnelák.”’ ");
INSERT INTO klt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Wáina naruk enendu Ánutu yá inuk, ‘Kák ku ámna hohoná! Kula yáungán nahára ku há kámutnelák. Iná wáina tátá ku kutná kutná táwi tiyawingga satá nakán ingga átak wawu niyá ihinek?’” ");
INSERT INTO klt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wáina mengga ku Jesu yá ing yánuk, “Káman niyá kutná kutná me supmá táwi hánám iháng urum ting san átminek, enendu Táwi yan kálu ma naráng hátingngátak, wata ku Ánutu rahálá hára ku kutná kutná ná muná hánám, ámna sup mara yá hohiuk wáinanyon hohinek.” ");
INSERT INTO klt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wáina yánángga Jesu yá disaepelná ing yánuk, “Wata ku átnát sáni álosim ba ma narángpak táindaráng, me sungi náut náinemán me sut náni káin náut tánggáneinemán ingga ma narángpak táindaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Átkuku álosim wawu sungi natne háláng námán átnándamán wáina muná, hang káwak sut watá ku kutná kutná sut tánggánene wa táng hátek. ");
INSERT INTO klt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Iráp otot wata narániráng. Sungi kámá ma hingngátaráng me sungi kámondang titiyan it yáni kámá ma árak, enendu Ánutu yá sing yámángngátak, iná ámna náráwa sándu Ánutu rahálá hára wu kutná táwi hánám iráp wa iháng háteráng. ");
INSERT INTO klt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iná sán háranan káman dá rina tángga ku kándáng átnet ingga narángpak tánggim wawa narángpak ngá watá háláng imán átnát ná wa rám kimo sengsáráp tán hásák áronggim me rina? Wawu muná hánám. ");
INSERT INTO klt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wata ku sándá isikimo wa mek wáina wa ma tátáyan wawu náuta ku sándá kutná kutná kátu wata narángpak tánggoeráng? ");
INSERT INTO klt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Sándá álesak yuminá wata narániráng. Yáup kámá ma tángngátaráng, me lap kámá ma iháng tolingngátaráng, enendu, no ing sánin, uláp King Solomon dá lap álolosim hulá hulá hánám iháng sutná tánggánenggiuk wawu álesak watán kolemá watá wu Solomon dá tánggánenggiuk wa táng hátek. ");
INSERT INTO klt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ále kánang wa átaráng wawu tembát ámna yá marángga káráp sineráng. Ále kánang hánámá, enendu Ánutu yá iháng tánggáneng yámángngátak, iná sándu pálipuk hánám Ánutu yá hányon sáháng tánggáneng sáminek. Náuta tángga ku naráng hákhátik sáni wawu isikimo? ");
INSERT INTO klt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Iná sándu sungi náut náinemán me umi náut náinemán ingga narángpak me nanará yáup táup ma táindaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Káwak ketnán ámna náráwa Ánutu ma naráng máráng watá ku kutná kutná wáina kápáng tunggap tátáya narángpak tángngátaráng. Iná sándu Nan sáni yá ku náuta kesák táeráng wawu há sáhángga narángngátak. ");
INSERT INTO klt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wata ku sándá Ánutu yan átkuku wata sulineráng ngáya ku kutná kutná wata kátu hányon sáminek. ");
INSERT INTO klt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sándu sipsip tombong isikimo, Nan sáni yá málámbán átkuku wa sásámáya heronge narek, wata ku ma pitáindaráng. ");
INSERT INTO klt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kutná kutná sáni wa yánát yuwát tu supmá wa iháng niyá wata kesák táeráng wa yámineráng. Sándá ku sup tumá ma wáik hálengngátak wata nan ihineráng, me alek kán kutná kutná álosim wa kánkámon tángga átkuineráng. Alek káin du kutná kutná yá ma wáik hálengngátaráng, me manek mara yá manek ma ihindáráng me yákárum bá ma iháng wáik táindáráng. ");
INSERT INTO klt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kutná kutná sáni kikiná rekáin átak wakáinyon pahán sáni yá wakáin átnek. ");
INSERT INTO klt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Sándu tiyawingga átang hákhálek tángga átkuineráng. Me tárákngá káman ing sánin, rám káman ket tántán tángga wata sinakngá tát ámna yáilá káman dá wakáin kunggim. Wáina kun yáup nanggená yá átang kup yáni kasingga lap yáni kándáng tawángga yáup tátáya tiyawingga táwi yáni ya háleng mángga átgalát. Kulá táwi yáni watá son áwáng kálu káin károk károk kátinggim waháranyon du sokmuná ingmen árong kálu yaling mánggalát. ");
INSERT INTO klt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Rám táwi yáni watá áwáng hengga kápán yáup nanggená yá ma ruhená átgalát, wahára wu heronge naráng yámánggim. No pálipuk hánám ing sánin, táwi yáni watá lapmá kándáng tawángga áwáng yáup nanggená wa yángotnáwáng tebol hára tingga málámbá sungi sing yámánggim. ");
INSERT INTO klt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yáup nangge niyá ma ruhená tiyawingga átgalát wawu táwi yáni yá álosim naráng yámánggim. Árát táwi yáni yá yáung táitná me it háiháiya tángga átgim kálu áwángga há tiyawingga árát kápánggim wawu heronge tánggim. ");
INSERT INTO klt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ing narániráng, it káman da márumá yá manek mara wu rám wahára áwinek ingga há naránggim, wahára wu it márumá watá manek mara wa san áwáng itná káting márák tángga kung kinan ma hanggim. ");
INSERT INTO klt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wáina wata ku sándá ku rámá rámá tiyawingga háleng rákit tángga átkuineráng, náuta Ámna Nanggená wu rám wahára áwinek ingga sán dá rám ma narená átneráng rám wahára áwinek.” ");
INSERT INTO klt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wáina men Pita yá inuk, “Táwi, me tárákngá náwu nándán da re nánánggoelák, me ámna kámuk kán da?” ");
INSERT INTO klt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wáina inán Táwi yá miuk, “Yáup pinná tátá niyá nanaráná álosim tingga yáupmá kándáng hánám tánggim, wawu yáup márumá yá yáup pinná tátá wa táng yáup nangge pin yáni tátáya tin yáup márumá yá rám tinggim wa re isutang sungi iháng yáup nangge yámánggim. ");
INSERT INTO klt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yáup ámna wawu rám táwiná yá áwángga kan kándáng hálenggim, wahára wu heronge tánggim. ");
INSERT INTO klt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kulá no pálipuk hánám ing sánin, táwiná yá táng tin kutná kutná ná kámuk ingmen táng yáup ámna wata ketná hára tin watá pin yáni tánggim. ");
INSERT INTO klt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Iná yáup ámna watá málámbáyon du ing naránggim, ‘Táwina wu sokmuná ma áwindák,’ wáina narángga ku yáup ámna náráwa wa ráhángga árong sungi nangga umi káto nangga ku hohinggim. ");
INSERT INTO klt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wáina tánggim wawu táwiná watá rám káman yáup ámna watá ma tiyawená átgim me ma narená átgim wahára áwáng táup hánám utang táng ámna milun yayali táená watyot tinggim. ");
INSERT INTO klt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kulá yáup nangge káman dá táwiná yan nanará káin du wáina ingga há naránggim watá kutná kutná ma tiyawinggim me táwiná yan nanará ma isutgim wawu táwiná yá táup hánám wa utgim. ");
INSERT INTO klt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iná yáup nangge káman dá táwiná yan nanará wu wáina ingga ma narená ku márapmá susuwáyan kálu wa isutgim wawu táwiná yá isikimo utgim. Káman niyá kutná kutná táup ihinek watá ku topmá táuppon tinek, iná Táwi yá kutná kutná táup hánám iháng káman da ketná hára tiuk hálendu inán kutná kutná táup hánám bon topmá iminek. ");
INSERT INTO klt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“No háut wawu káwak káin káráp tángga háut. No káráp watá sokmuná rang háháleya naret. ");
INSERT INTO klt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iná umi nukngá káman no kukuháyan átak wawu sut láwit nanará wa, wata pahánna yá márawingga árán átang kungga umi wa pukon kuhe sáliknginek. ");
INSERT INTO klt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","No káwak káin háut wawu sándá ámna náráwa yá pahán káman átnát ta háuk ingga naránggoeráng hám? Wawu muná. No ing sánin, nák ku ámna náráwa yá honhoren táineráng ga háut. ");
INSERT INTO klt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rám kula átang áruinek hára wu it káman da kinan 5 bá átang hálendu horengga yará háleinek. Kaláhu yá yará ya káyam táng yámát, yará yá kaláhu ya káyam táng yáminemálák. ");
INSERT INTO klt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hang naning urim bá kámkáyam táineráng, maming urim bá kámkáyam táineráng, hang neng nambán dá kámkáyam táineráng.” ");
INSERT INTO klt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu yá ámna náráwa urum táwi wa yánuk, “Sándá kangngárát káe yá kung haha kálu mukam bá tán du ing mengngátaráng, ‘Ále yá taindek,’ wáina mengngárát tu pálipuk ále yá há tangngátak. ");
INSERT INTO klt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iná iruk ká ámuta kálu áwán du ing mengngátaráng ‘Ále yá álo kámá átnándek,’ wáina mengngárát tu pálipuk álo kámá átnándak. ");
INSERT INTO klt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sándu ámna kusákngá! Kutná kutná káwak káin me alek káin tunggafenggoeráng gu há kang rákit tánggoeráng. Kulá rina tángga ku rám ore nahára áwángga tárák hulá hulá yá tunggafenggoeráng wawu ma kang rákit tángguráng? ");
INSERT INTO klt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Sándu rina tángga ku sáni yon kálu kándáng gu resim ingga ma kang rákit tángguráng? ");
INSERT INTO klt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iná ko ámna káman yot kámkáyam sim tángga keháng me hára tinán kálu hára kunggatang gu, neháng me hára tiwon ingga sokmuná me táng tolinemálák. Me ma táng tolená kungngárá keháng ámna me nanará wata ketná hára tiwon. Wáina tin watá keháng kalabus pinná táená ketná hára tin son watá keháng kalabus it kinan tiwon. ");
INSERT INTO klt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No ing kanin, kák ku kalabus it kinan átang árongga sup rina titiya kanená wa erek ting háleinelák.” ");
INSERT INTO klt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesu yá me wa meng hálin du ámna kámá áwáng wahára áturáng watá Jesu ing inuráng, “Ánutu ya towet sing mámá rámá hára Pailat tá tewe ámna yánán Galili nan ámna kámá ráháng kátkámut tát sip yáni yá Ánutu ya towet sisiyan songgo sipmá ketnán yon háuráng.” ");
INSERT INTO klt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wáina inát Jesu yá ing yánuk, “Sándá ku rina nareráng, Galili ámna wa ráhuráng watá mukmuro tángngátaráng, watá ku Galili ámna kátu yá mukmuro tángngátaráng wa iháng hátek ngáya ku márapmá watán káin wáina tunggafiuk hám? ");
INSERT INTO klt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","No ing sánin, wawu muná hánám! Iná sán niyá pahán hurik ma táindáráng wawu tárák wáina watá yon sándán káin tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hang ámna 18 it hásák ká it yáilá Jerusalem kinan Siloam hára táwatang yáni ya ketnán hangga iháng usáng kátkámut táuk, wata sándá rina nareráng? Watán mukmuro watá ámna kátu Jerusalem káin áturáng wa iháng hátek me rina? ");
INSERT INTO klt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No ing sánin, wawu muná hánám! Iná sán niyá pahán hurik ma táindáráng wawu tárák wáina watá yon sándán káin tunggafeinek.” ");
INSERT INTO klt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wáina yánángga ku me tárákngá káman ing yánuk, “Ámna káman dá wáin hái ore kinan káin káráp fik káman hinggim ba rám kámá ku páliná kámá átak me muná ingga kung áwáng tángga kanggim bu páliná kámá muná re. ");
INSERT INTO klt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kulá rám káman du hái márumá watá kung hái pinná tángga átgim wa inánggim, ‘Yara kaláhu wata kinan káráp fik náta páliná kámá káin ingga kang hákhálek táe men sanggoet. Káráp ná hoseng satá háik! Náuta ku satne hánámá átang káwak karo nang hálingga átnek?’ ");
INSERT INTO klt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Wáina men hái pinná tángga átgim watá inánggim, ‘Ámna hulána, satá yara káman nátyot son árán no hulá wa káwak pingga usáng pálák táinet. ");
INSERT INTO klt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wáina táe yara nukngá ya páliná tin hálendu álo kámá! Iná muná hálendu wawu hoseng satne háinek.’” ");
INSERT INTO klt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Rám káman Sabat hára Jesu wu miti itná káman da kinan ámna náráwa me yánáng tolingga átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kulá wahára náráwa káman iruk wáik ká táng lem tángga árán yara 18 háliuk watá hányon átuk. Iruk wáik watá táng lem tán turingga re átkiuk, kándáng átnát tán tárák ku muná. ");
INSERT INTO klt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu málám wáina kangga ku mantán áwán inuk, “Náráwa, no keháng tole ilalákka yá álo háleindek.” ");
INSERT INTO klt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wáina inángga ketná kálandang sutná hára tánggan wahára re ilalákngá watá pukon álo hálen áráng kándáng átang Ánutu kutná mengga heronge táng muk. ");
INSERT INTO klt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu yá wáina tán kangga miti itná yan ámna yáilá watá Sabat hára wáina táek ingga kuk táwi tángga ámna náráwa wa yánuk, “Yáup tátáyan rám bu 6 rewe Táwi yá iháng tunggap táuk, wahára áwát tu wáina sáháng tolingguinek, iná Sabat hára wu muná.” ");
INSERT INTO klt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wáina yánán Táwi yá ámna yáilá wa inuk, “Sándu ámna kusákngá! Sabat hára kumbi sáni káin kung bulmakau me donki sáni páup yáni yaling yámángga yángot kung umi yámát nangngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iná náráwa náwu Abraham uriwa. Satan dán háláng gá káto táng san yara 18 átuk. Kulá no iruk wáik ká wa káto tángga árená wa Sabat hára yaling mámá wawu muná me rina?” ");
INSERT INTO klt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu yá wáina yánuk hára wu káyammá ingga wawu rep yáni wáin áturáng, iná ámna náráwa táwi watá ku náut álosim tángngátak wata heronge tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesu yá ing miuk, “Ánutu yan átkuku wawu náut ina? Náut hára mengga tárák te ku kándáng háleinek? ");
INSERT INTO klt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ánutu yan átkuku wawu mastet táulá ina. Mastet táulá wawu isikimo hánám. Ámna káman dá táng kung háiná káin halin árángga kungga maming táwi hálengga árán du iráp pá áwáng ketná palá hára ep tángga átnándaráng.” ");
INSERT INTO klt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hang son yánuk, “Ánutu yan átkuku wawu náut hára tárák tingga me ku kándáng háleinek? ");
INSERT INTO klt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wawu yis ina, náráwa yá yis táng flaua táwi hánám watyot iháng yakyawák tángga árát kungga flaua watá tihangngátak.” ");
INSERT INTO klt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu yá Jerusalem kuin ingga it tátáwi me it isikikimo kálu hára árená wakáin Táwi yan me pingnga wa yángyánáng gu Jerusalem ba kuk. ");
INSERT INTO klt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wa kunggatuk wahára wu ámna káman dá ináng suliuk, “Táwi, Ánutu yá ámna káman káman re wu son ihinek hám?” Wáina inán Jesu yá yánuk, ");
INSERT INTO klt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Sándu hánghálángngingga hánám bon du kung kálu isikimo hára wa kung háineráng. No ing sánin, táup hánám watá kung hahaya táineráng enendu ma kung háindáráng. ");
INSERT INTO klt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Rám it márumá yá tárutang kálu káto táinek wahára wu sándu áwáng kep káin átang kálu káin károk károk kángkáting kikilik ing táng mineráng, ‘Táwi, kálu yaling námáng.’ “Enendu watá ing sáninek, ‘Nák ma naráng sámát. Sándu rekáinnan?’ ");
INSERT INTO klt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Wáina sánán du inineráng, ‘Nándu kákkot umi sungi nangga áwánggiumán, hang kák ku nándán it kapme hára me pingnga nánáng tolingga áwánggiulák.’ ");
INSERT INTO klt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Wáina inineráng, enendu watá ing sáninek, ‘Nák ma naráng sámát. Sándu rekáinnan? Nepmangga há sáni kuniráng! Sándu mukmuro táup hánám tángngátaráng,’ ingga sáninek. ");
INSERT INTO klt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kulá hálengga káineráng gu Abraham, Aisak hang Jekop pot profet kámuk hánám bu Ánutu yan it kapme álosim káin wa árát. Iná sáni wu sáháng hirarán kung kep káin átang kutang mátap sáni kirikkárák tángga átneráng. ");
INSERT INTO klt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ámna náráwa yá káe yá áráng hehe kálu, me káe yá kung haha kálu, me ánuta kálu, me ámuta kálu áwineráng ngáyá áwáng Ánutu yan átnát káin umi sinak táwi hára wa áwáng kome yáni ihángga átneráng. ");
INSERT INTO klt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kulá me ná kándáng narineráng, ámna kámá pukon káin átaráng watá máta káin átneráng, iná máta káin átaráng watá ku pukon káin átneráng.” ");
INSERT INTO klt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Rám wahára Farisi kámá yá áwuráng ngáyá ku Jesu inuráng, “Ále ná sangga ku ále kámá káin kuinelák, náuta Herot tá kák kutkámut tátáya mek.” ");
INSERT INTO klt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wáina ingga inát tu Jesu yá yánuk, “Sándá kungga ku ang páyom wa ing inineráng, nák ku kula me tembát tu iruk wáik yásutang hang ilalák mara kámá iháng tolinet. Iná rám kaláhu átang gu yáupna wa táe sáliknginek. ");
INSERT INTO klt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kula me tembát árongga wu há kuinet, náuta profet wawu it kámá káin árán ma utkámut táindaráng, ináku Jerusalem káin árán du wáina utkámut táineráng. ");
INSERT INTO klt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, ko profet ráháng kátkámut tángngátalák, hang Ánutu yá ámna suring yámán kákkán káin áwángngátaráng wawu ráháng kátkámut táin ingga sup iháng yáni ya mangngátalák. Rámá rámá nángánanggeka wa hurák ká nángánangge yáni iháng urum tingngátaráng wáina tin ingga tánggoet, enendu watá ku taktak yámánggoek. ");
INSERT INTO klt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaniráng, it sáni wu wáik hálengga hánámá átnek. No ing sánin, sándu son nák ma nahená átang kungga ing meineráng, ‘Ánutu yá ámna ni málámba kutná hára áwáng átak wa táng álolo táinek.’” ");
INSERT INTO klt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Rám káman Sabat hára Jesu yá Farisi yan ámna yáilá káman dán it káin kung watyot sungi nangga áturáng. Wa kung átuk hára ámna yá kandák kámá rina tán kanin ingga kangga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iná rám wahára wu ámna káman du ilalák sut tiháená wata nan pálak watá Jesu kondolá hára átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kulá Jesu málám Farisi me lo yan hulá nanará wahára áturáng wa ing yánáng suliuk, “Sabat hára wa ilalák mara álo iháng totoliyan me muná?” ");
INSERT INTO klt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wáina yánuk, enendu watá mátan ma táená nángnángingga árát tu Jesu málám ámna wa tánggangga táng tolingga ku ámna wa inán háná kuk. ");
INSERT INTO klt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wáina tángga ku yánáng suliuk, “Sán háranan káman dá kanggim bu nanggená ámnaná me bulmakauná yá Sabat hára hang umi árámmá pená kinan árán da rina tánggim? Rám waháranyon da álo táng satá áráng henggim me muná? Pálipuk hánám wáina wu há tánggim.” ");
INSERT INTO klt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wáina yánuk, enendu watá topmá kámá ma inánáyan. ");
INSERT INTO klt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Son hang Jesu málám ámna yá sinak hára sungi nanaya áwuráng wa kápuk ku áwáng kome máta káin re átnát ta táup tát kápángga ku me tárákngá ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Rám káman ámna káman dá náráwa tátáyan sinak rámá hára mantáng kamán kungga ku kome máta káin du ma putung átkuindalák. Kome wa kámá ámna káman kák keháng hátingga átak kutná pálak wa mantáng mán áwinek watán há meng san áriwon. ");
INSERT INTO klt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wáina árátá kahángga ku ámna sán yayará mantáng sámánggim watá áwáng kanánggim, ‘Kome wa ámna náta sang máng,’ ing kanán kák ku reprepmá táwi narángga kung kome mári pukon káin putung átgim. ");
INSERT INTO klt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wáina wata ku rám wáina hára mantáng kamát wawu kung kome mári pukon káin putung átkuinelák. Wáina árátá ku sinak márumá yá áwáng kahángga ku kanánggim, ‘Nukna, áwáng kome álo kámá káin ná álák,’ ing kanán du ámna náráwa káman átgalát watá kahát kutya pálak hálenggim. ");
INSERT INTO klt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Káman niyá málámba kutná tángga árinek wawu Ánutu yá kutná tángga háinek, iná niyá málámba kutná tángga háinek wawu Ánutu yá kutná tángga árinek.” ");
INSERT INTO klt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wáina yánángga ku ámna niyá sungi nanaya mantáng mán áwuk wa inuk, “Ko sinak tángga ku nuknukka me tat kulakka me sipya kátu me kaya tangtang árená sup yáni pálak wa ma mantáng yámátá áwindaráng. Wáina táinelák wawu máriya watá son topmá mantáng kamát tu topmán topmán háleinek. ");
INSERT INTO klt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ináku sinak tángga ku ukuro mara me sut yáni wáik hálená me háram yáni wáik hálená me rahán yáni kotná, wa mantáng yámángguinelák. ");
INSERT INTO klt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wáina tátá ku watá wata topmá ma kamindáráng ga ku kuram bá kákkán káin áwinek. Wata topmá ku Ánutu yá máriya ámna kándáng átang kámuturáng watá tanggán káin átang tárutneráng rám wakáin du kaminek.” ");
INSERT INTO klt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wáina yánán narángga ámna káman tebol hára kámuk átang sungi nangga áturáng watá Jesu inuk, “Ámna náráwa niyá Ánutu yan átnát álosim kinan átang sungi náineráng watá ku heronge narineráng!” ");
INSERT INTO klt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wáina inán du Jesu yá ing inuk, “Ámna káman dá sinak táwi tátáya narángga ku ámna táup hánám bá áwáng sungi nanaya mantáng yámuk. ");
INSERT INTO klt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kulá sinak rámá hánám wahára wu ámna watá yáup nanggená káman suring mán ámna yánáng sáuk ngá watán káin kungga sungi wu há tiyawingga átak ingga yáninán kuk. ");
INSERT INTO klt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Kung yánángga kuk, enendu ámna watá erek hánám meng pilingga ‘nándu ma kuindámán’ ing mengga kuráng. Káman dá ku inuk, ‘Nák ku káwak kátu káman yuwát, wata ku kungga wa káinet. Wáina wata ku ukuro táwi, nák ku ma áwindát.’ ");
INSERT INTO klt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Iná nukngá yá ku inuk, ‘Nák ku bulmakau 10 dá yáupna táng namineráng ga yuwát, wata ku kung wa iháng tárák tángga káinet. Wáina wata ku ukuro táwi, nák ku ma áwindát.’ ");
INSERT INTO klt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Hang káman dá ku inuk, ‘Nák ku náráwa emá tángga átat, wáina hálendu ma áwindát.’ ");
INSERT INTO klt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Wáina inát narángga ku yáup nangge watá son kuk watá kung táwiná sinak márumá wa wáina meráng ingga inán du kuk narángga yáup nanggená wa inuk, ‘Sokmuná ingmen it nátán kálu isikikimo me maming tátáwi káin kungga ukuro mara me sut yáni wáik hálená me rahán yáni kotná me háram yáni wáik hálená wa yángotang áwáng.’ ");
INSERT INTO klt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Wáina inán yáup nangge watá kung rina inuk wáina há táng hálingga ku son áwángga inuk, ‘Ámna hulána, melák wáina há táet, enendu it pahálá wu ma tuwarak, kome wu along re átak.’ ");
INSERT INTO klt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Wáina inán du sinak márumá watá inuk, ‘Kungga it kapme sangga kálu káin wa ni ámna me náráwa kápángga ku há hánám áwániráng ingga yánáng pákpálák hánám tátá áwát nákkán it pahálá yá tuwarik. ");
INSERT INTO klt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No ing sánin, ámna huphuráp mantáng yámut waháranan káman dá nákkán sungi kátu káman ma hánám náindák.’” ");
INSERT INTO klt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ámna náráwa táup hánám watá Jesu isutang kungga árát tu málám hurik tángga ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Káman niyá nákkán káin áwinek watá naning, maming, málámba áwá nanggená, tatning kulaná, málám ilommá me málámbán átnát ná wata ma taktak mindák, wáina watá nákkán disaepel ma háleindák. ");
INSERT INTO klt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hang káman niyá málámbán maripong wa sungga tánggatang nák ma nasutnándák, wáina watá nákkán disaepel ma háleindák. ");
INSERT INTO klt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Iná ámna káman dá it maming táwi tátáya wu wa táng háliliyan sup pa álo átak me rina ingga kándáng kangga san árán du it wa tánggim. ");
INSERT INTO klt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Iná wáina ma táená kumam kálak hirarán han tángga kungga kutná kutná kátu ya kesák tángga san átgim wawu kámá niyá áwáng wáina kanggalát watá ku ináng kekkek tángga ");
INSERT INTO klt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ing menggalát, ‘Ámna náwu it álo táng hálinet ingga táuk, enendu ma táng háliuk.’ ");
INSERT INTO klt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Iná king káman dá king nukngá yot erawáwáya wu málám kándáng hánám narángga málámbáyon ing menggim, ‘Nákkán tewe ámna wu 10,000 rewe, iná nukngá watán tewe ámna wu 20,000. Wawa álo erawángga táng hátinet me rina?’ ingga menggim. ");
INSERT INTO klt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iná málám narán hálángngá muná hálendu wawu king nukngá watá mulangán yon árán pahán káman háháleya me san kunggim. ");
INSERT INTO klt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kálu wáinanyon, sán háranan káman dá kutná kutná ná kámuk hánám wa ma sárum yámindák wawu nákkán disaepel ma átnándák. ");
INSERT INTO klt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol wawu álo kámá, iná kikngá watá sálikngin du son rina táng mátne ku kikngá pálak hálenggim? ");
INSERT INTO klt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol wáinaná watá hái káin sungi ma háláng yámán áráng henggalát, me wa táng bulmakau kámulá yot táng hái káin ma tinggalát. Ináku susut káin táng hirarát kunggim. “Káman niyá kárámanná pálak hálendu watá me ná narinek.” ");
INSERT INTO klt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kulá ámna takis iháhá yot mukmuro táená watá Jesu yá me men naránin ingga áwáng Jesu rupmá áwálák áturáng. ");
INSERT INTO klt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wa kápángga Farisi yot lo yan tiksa watá pahán yáni wáik hálen ing miuráng, “Ámna náwu mukmuro táená wa iháng nuk tángga watyot sungi nanggoeráng.” ");
INSERT INTO klt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wáina met tu Jesu yá me tárákngá ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sán háranan káman sipsipmá 100 tá átmán máriya kanggim bu káman du komená. Wáina kangga málám 99 wa san ále rákit káman káin árát málám kung káman komená átgim wata suling kung suling kung kang tunggap tánggim. ");
INSERT INTO klt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Há kang tunggap tángga ku heronge nangnaráng táng pátángngán sungga tánggatang itná káin kunggim. ");
INSERT INTO klt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kulá itná káin kung nuknukngá mantán áwát tu yánánggim, ‘Sipsipna káman komená káut wawu suling kung há kang tunggap táet, wata ku nákkot heronge tánin,’ ingga yánánggim. ");
INSERT INTO klt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No ing sánin, alek káin wáinanyon heronge táwi tunggafeinek wawu rám mukmuro táená káman dá pahálá hurik táinek wahára. Pálipuk ámna 99 kándáng átang pahán hurik tátáyan tárák ká ma áraráng wata heronge táng yámámá wawu isikimo hánám, enendu mukmuro táená káman dá pahán hurik táinek wata herongená wawu maming táwi hánám. ");
INSERT INTO klt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Náráwa káman dá supmá táwi hánám 10 waháranan káman komená kangga ku rina tánggim? Málám kup kasingga tánggatang it kinan sinsin hithirat tángga kahát hánám suling kung suling kung kang tunggap tánggim. ");
INSERT INTO klt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Há kangga sangga ku nuknukngá mantán áwát tu yánánggim, ‘No supna táulá káman komená káut wawu suling kung há kang tunggap táet, wata ku nákkot heronge tánin,’ ingga yánánggim. ");
INSERT INTO klt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No ing sánin, wáinanyon rám ámna mukmuro táená káman dá pahálá hurik táinek wahára wu Ánutu yá angeloná yot heronge maming táwi táineráng.” ");
INSERT INTO klt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hang Jesu yá waháranyon sengsáráp tángga ing yánuk, “Ámna káman du nanggená ámnaná yará. ");
INSERT INTO klt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kulá nanggená táwi ya kondolá háranan watá ku naning inuk, ‘Nan, nák ku ing naret, ko tatna yot nát kakán hára kutná kutná horengga námámáyan wa horengga nákkán pingnga wa namáng.’ Wáina inán du nan yándi yá kutná kutná wa horengga ting yámuk. ");
INSERT INTO klt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Rám kimo átang sangga kulaná yá kutná kutná málámbán pingnga ihuk wa yánán erek yung hálit tu supmá wa ihángga átang it táwi káman mulangán káin kuk watá kung ket tárák kandák hára wa supmá wa erek hánám sang háliuk. ");
INSERT INTO klt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Málám wáina tán supmá watá erek sálikngin átang gu rám ore wakáin sungi kesák táwi watá ále wakáin tunggafen kutná kutná ná ya kesák tángga málám niyá háláng namánggim ingga narángpak tángga átuk. ");
INSERT INTO klt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Átang kuk ngáyá kung it márumá káman dán káin yáup nangge átnát ta inán ámna watá yáup káman imuk wawu put pin yáni tátáya suring mán put kumbiná káin kuk. ");
INSERT INTO klt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kung átang kápuk ku put tá sayo kepmá wa nat kápángga málám táup hánám háing mán wáinanyon nanggem ingga naruk, enendu káman dá sungi kimo káman ma imuk. ");
INSERT INTO klt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wáina átang málám nanará álosim bá tán du naráng hátiuk, ‘Nanna yan yáup nangge yá enendu sungi yáni táup hánám árán nangga átaráng, iná nák ku nákáin átat wawu sungi ya háing namán kámutnándet. ");
INSERT INTO klt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Satá son na kuinet watá kung nanna ku ing ininet, “Nan, no Ánutu rahálá hára me kák rahála hára kandák táut. ");
INSERT INTO klt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kulá wata ku nák ku ámna álosim muná, wáina wata ku ko nák ka nanggena ingga memeyan tárák muná. Wáina wata ku kula wu satá yáup nanggeka káman hálengga átnet.”’ ");
INSERT INTO klt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Málám nanará wáina naráng hátingga ku tárutang hangga naning gán káin kuk. “Kulá málám mulangán káin emá yon kungga átuk wahára naning gá kangga urákngá táwi hánám narángga hururung kung poláng mángga kang kukumek táuk. ");
INSERT INTO klt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Wáina tán nanggená yá inuk, ‘Nan, no Ánutu rahálá hára me kák rahála hára kandák táut. Wata ku nák ku ámna álosim muná, wáina wata ku ko nák ka nanggena ing memeyan tárák muná.’ ");
INSERT INTO klt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Wáina inán naning gá yáup nanggená yánuk, ‘Sokmuná yon kung lap hásák álosim wa táng áwáng tawáng mángga ring táng áwáng ketná kálongngá káin ting mángga, hang sendol táng áwáng hárammá káin mon mániráng. ");
INSERT INTO klt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wáina tángga ku kung bulmakau nanggená tutuwatná wa táng áwáng utang sit sinak tángga heronge tánin. ");
INSERT INTO klt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Náuta nanggena náwu há kámurená háranan dá kula son áwek. Há yakyawiuk, enendu kula son áwán káemán.’ “Kulá wata ingga ku sinak táwi tángga ku heronge tángga átnárát ");
INSERT INTO klt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","nanggená táwi wawu hái káin átuk ngáya rám waháranyon it tangtang áwángga naruk ku kap mantángga heronge tángga árát. ");
INSERT INTO klt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Málám yáup nangge káman mantáng mán áwán du ináng suliuk, ‘Wawu rina tángga átkoeráng?’ ");
INSERT INTO klt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wáina inán watá inuk, ‘Kulakka sutná yá kándáng re árán son áwán wata nanya yá kangga heronge pálak kulakka tángga ku bulmakau nanggená tutuwatná wa utang sek.’ ");
INSERT INTO klt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Wáina inán nanggená táwi watá wa narángga kuk tángga it kinan ma árángga kun kangga naning gá kep káin hangga pahán láláp mená inuk, ");
INSERT INTO klt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","enendu nanggená yá ing inuk, ‘Kang, yara máro hánám bon du no yáup nangge yá ina kákkán yáup tángga áwut, hang me nanátá milunya kámá ma yaliut. Wata ingga rám káman meme nanggená káman kámá namátá no nuknukna yot heronge kámá ma táumán. ");
INSERT INTO klt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iná nanggeka náráwa kálu háranan yot átningga kutná kutná ka raták raták tán sálin son áwek wata ingga ku bulmakau nanggená tutuwatná wa utang sing melák!’ ");
INSERT INTO klt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wáina inán naning gá inuk, ‘Nanggena, kák ku rámá rámá nayot átnándalák, wata ku kutná kutná nákkán átak wawu kákkán. ");
INSERT INTO klt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ináku kula wu heronge tángga pahán álosim narinemán, náuta kulakka wawu kámurená háranan dá kula son áwek. Há yakyawiuk, enendu son áwán káemán.’” ");
INSERT INTO klt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu yá disaepelná ing yánuk, “Ámna káman supmá táwi hánám átmángngátak watán yáup ámna káman átnándak. Kulá ámna kámá yá áwángga ku ámna supmá táwi wa inuráng, ‘Yáup ámna ka wawu kákkán kutná kutná wa iháng yakyawák táng kamánggoek.’ ");
INSERT INTO klt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wáina inát tu supmá táwi watá yáup ámnaná wa mantáng mán áwán du inuk, ‘Kák ka me wáina wáina met naret, wata ku kungga nákkán kutná kutná kák ketya hára átak watán hulá rina rina wa kándáng táng tolingga táng áwáng namáng. Kák ku nákkán yáup ámna son ma átnándalák.’ ");
INSERT INTO klt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Wáina inán du yáup ámna watá málám meme ing táuk, ‘Kulá rina táinet? Táwina yá yáup hára nasutnándek. No káman dán yáup nangge hálengga káwak pipi wata nare hálángna muná hálek, me sup pa kesák tángga kámá yánáng sulingga átkuku wata reprepmá naret. ");
INSERT INTO klt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kulá kula wu kálu káman naret, wáina táe ku máriya táwina yá yáup nahára nasurán du ámna watá ku nangotang it yáni káin kut átnemán.’ ");
INSERT INTO klt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nanará wa tingga sangga ku málám ámna nini yá táwiná yan káin kutná kutná ihená ya topmá titiyan átuk wa mantáng yámán áwát tu hulátingga áwuk wa inuk, ‘Kák ku táwina yan káin topmá ku rina titiyan átak?’ ");
INSERT INTO klt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ing inán watá inuk, ‘Nákkán du olif karo kárang maming tátáwi 100,’ wáina inán yáup ámna watá inuk, ‘Sokmuná ingmen putung átang gu papia wa táng totoli nahára wawu 50 rewe uying.’ ");
INSERT INTO klt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Wáina inán uyin du son kámá áwuk wa inuk, ‘Iná kák ku topmá rina titiyan átak?’ “Wáina inán watá inuk, ‘Nákkán du wit bek maming tátáwi 100,’ ingga ámna watá inán du yáup ámna watá inuk, ‘Papia wa táng totoli nahára wawu 80 bek rewe uying.’ ");
INSERT INTO klt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Wáina inán uyin átang máriya táwiná watá wáina táek ingga naruk hára wu yáup ámna wáik wata kutná meng tárut táuk, náuta ámna nanaráná pálak hálen du wáina táuk. Káwak nátán ámna wu nanará kándáng tingga ket tárák álosim wa kámá ya táng yámángngátaráng, watá ku ámna yamá hára átaráng wa iháng háteráng. ");
INSERT INTO klt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","No ing sánin, káwak kán kutná kutná álosim wa iháng nuk iháng tunggap táineráng, wata ku rám kálu kutná kutná watá sáliknginek hára wu watá yon sángot kung it álosim kinan tit rámá rámá álosim átang kuineráng. ");
INSERT INTO klt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Iná káman niyá náut kámá káman isikimo wa kándáng hánám pinná tánggim, wawu náut kámá maming táwi wa wáinanyon kándáng pinná tánggim. Hang káman dá náut kámá káman isikimo wa kálu kandák hára pinná tánggim, wawu wáinanyon náut kámá maming táwi wa kálu kandák hára pinná tánggim. ");
INSERT INTO klt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kulá sándá káwak nátán kutná kutná kikiná wa kándáng ma pin yáni tánggalát, wawu niyá sáhángga ku iruk kán kutná kutná wa sang sámán pin yáni tánggalát? ");
INSERT INTO klt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hang kámá yan kutná kutná wa kándáng ma pin yáni tánggalát wawu niyá ku kutná kutná sánin hánám sámánggim? ");
INSERT INTO klt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yáup nangge káman dá ámna huláná yará ya tárang káin ma átgim. Wáina átgim wawu káman álo kámá kangga ku káman du takta kanggim. Hang káman da ku milun susuwá táng mángga káman da ku milun yayali táng mánggim. Ko rám káman hára re moneng got Ánutu yan yáup nangge ma átgim.” ");
INSERT INTO klt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wáina men narángga Farisi kámá wahára áturáng wawu sup pa kikiná hánám narángngátaráng wata tángga ku Jesu ya yanyawon táwi táng muráng. ");
INSERT INTO klt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wáina tát Jesu yá ing yánuk, “Sáni wu ing naránggoeráng, ‘Ámna wawu kálu kándáng re isutnándaráng ingga náhániráng,’ ingga naránggoeráng, enendu Ánutu yá ku pahán sáni káin wáina ingga há sáhek. Náut kámá ámna yá álosim hánám ingga naránggoeráng wawu Ánutu rahálá hára wu wáik hánám. ");
INSERT INTO klt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lo yot profet tán me wawu átang áwángga Jon dán rám hára sálikngiuk. Kulá wahára átang áwek wakáin du Ánutu yan átkuku watán me pingnga álosim wa met naránggoeráng, wáina hálendu ámna táup táwi yá hahatingga kung wata kinan hanin ingga tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Enendu lo wawu ále hánám ingga ma narindaráng. Alek káling káwak wawu muná kuinek, iná Ánutu yan lo wata kátu kimo káman du ma hánám muná kuindák. ");
INSERT INTO klt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Hang ámna káman dá áwáná isutang náráwa nukngá táinek wawu márámamák há táinek, hang náulá yá áwáná isurán málám re hánámá árán ámna káman niyá wa táinek wawu márámamák há táinek. ");
INSERT INTO klt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ámna káman supmá táwi hánám árán lap yányáhán sipmá álolosim wa ihánggánengga átang rámá rámá sungi kikiná nangga átnát ná yá álosim hánám wahára átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Itná kapme yan kumbi kálu mungnganá hára wu ukuro ámna káman kutná Lasarus wa táng áwáng rámá rámá tingting tát átkiuk. Lasarus wawu sutná kámuk hánám putulá re. ");
INSERT INTO klt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wáina átang gu málám supmá pálak watán sungi káhumá tebol tárang káin háená wa há hánám nanggem ingga narángga átnándak. Kulá ang gá áwáng gu putulá wa elowatnándaráng. ");
INSERT INTO klt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Rám káman du ukuro ámna watá kámurán angelo yá irukngá wa táng kung Abraham bot tit átumálák. Iná ámna supmá táwi wawu hányon kámurán ámna kámá yá táng kung árám pingga usuráng. ");
INSERT INTO klt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kulá ámna málám káráp lánggop kinan sut láwit maming táwi hánám hára átang hálengga káuk ku Abraham bá mulangán hánám káin Lasarus yot árán. ");
INSERT INTO klt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wáina kangga ku mantáng muk, ‘Nan Abraham, ko urákna narángga Lasarus inátá kung ketná mángok ilungngá táng umi utang táng áwáng elákna káin tin elákna yá láláwik, náuta nák ku káráp lánggop náta kinan láwit maming táwi hánám hára átat.’ ");
INSERT INTO klt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wáina inán Abraham bá inuk, ‘Nanggena, naráng, ko káwak sut pálak átulák wahára wu kutná kutná ka álosim wa há ihángga átulák. Iná Lasarus yá ku wáik hánám átuk, wata ku nákáin du watá álosim árán du ko sut láwit hára átalák. ");
INSERT INTO klt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hang nukngá ku ing, sán me nán orek náni hára ku kániráp maming táwi hánám Ánutu yá tiuk. Wáina hálendu nákáinnan da wakáin kuku wawu muná, me wakáinnan da nákáin áwáwá wawu muná.’ ");
INSERT INTO klt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Abraham bá wáina inán du supmá táwi watá miuk, ‘Wáina hálendu ko Lasarus inátá nák nanna yan it káin kungga ");
INSERT INTO klt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wakáin yakukulana faip pá átaráng wa wáina ingga yáninek ngáya ku waháranan káman dá sut láwit nanaráyan ále káin ná ma áwindak.’ ");
INSERT INTO klt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Wáina inán du Abraham bá inuk, ‘Moses yan me hang profet tán me wawu há átyámek, wata ku watá wa narineráng.’ ");
INSERT INTO klt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Wáina inán du supmá táwi watá miuk, ‘Nan Abraham, wáina muná. Kámurená káman dá watán káin kungga yánán du pahán yáni hurik táineráng.’ ");
INSERT INTO klt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Wáina inán Abraham bá inuk, ‘Moses me profet tán me ma narángngátaráng wawu há kámurená káman dá son tárutang kungga yánánggim enendu wa narángga pahán hurik ku manyon tánggalát.’” ");
INSERT INTO klt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu yá disaepelná ing yánuk, “Kálu kandák hulá hulá tunggafengga áwinek wa kangga ámna náráwa yá yáni táng kung kandák kálu wa tineráng. Iná niyá narán kálu kandák hulá hulá watá tunggafeinek watá wu márapmá táwi hánám suwinek. ");
INSERT INTO klt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sup maming táwi táng kák sala hára putingga sat kung táp kinan hangga há kámutgim enendu kákkán márapmá wawu isikimo. Iná ko tátá nangge kikimo waháranan káman dá kung mukmuro tánggim wawu kákkán márapmá wu maming táwi. ");
INSERT INTO klt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wata ku kák ku kándáng gon átnelák. “Nukka káman dá mukmuro tán du inátá ku son átkukuná wa táng tolinek. Watá pálipuk ing mengga pahálá hurik tán du ko watán kátu wa sáinelák. ");
INSERT INTO klt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Káman dá kákkán káin mukmuro tángga sangga áwáng ‘pálipuk kandák táet’ ingga kanáng tunggap tángtáng tán káe káman hára rám 7 hálendu ko watán kátu wa sáinelák.” ");
INSERT INTO klt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Táwi yá me wa yánán aposelná yá inuráng, “Naráng hákhátik náni wa tátá maming táwi háleik!” ");
INSERT INTO klt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wáina inát Táwi yá yánuk, “Sándá naráng hákhátik sáni isikimo mastet táulá ina watá káráp ná inánggalát, ‘Ko ráhula yot kámuk hutang kung táp kinan hená yá ina álák,’ ingga inát sándán me wa isutang wáina álo tánggim. ");
INSERT INTO klt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kulá sán háranan káman dá yáup nanggená káman inán hái káin káwak pingga me sipsip pin yáni tángga átang it káin áwán du ing hám inánggim, ‘Áwáng putung hangga sungi nang’? Wa muná. ");
INSERT INTO klt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ináku ing inánggim, ‘Nákkán sungi kálak tiyawingga lapya kándáng tánggánengga pinna tángga árátá no umi sungi na nang hále ku ko umi sungi ka náinelák.’ ");
INSERT INTO klt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pahálá káin náuta narángga inánggim wawu yáupmá nangge yá há táng mánggim, wata ku ámna watá yáup nanggená wa heronge mená inánggim hám? Wa muná. ");
INSERT INTO klt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wata ku sán du hányon náut rina tátáya Táwi yá miuk wa erek táng hálingga ku meineráng, ‘Nándu hánámá yáup nangge rewe, nándu yáup náni tátáyan wa há táemán.’” ");
INSERT INTO klt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu yá Jerusalem kuin ingga málám ále Samaria yot ále Galili orek yándi kálu wa kuk. ");
INSERT INTO klt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Málám it káman káin kung hiuk wahára ámna 10 ilalák lepra yáni pálak watá áwáng kangga mulangán káin hetang átang ");
INSERT INTO klt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hahatingga hánám ing mantáuráng, “Jesu, Ámna Hulá, urák náni narinelák!” ");
INSERT INTO klt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wáina inát Jesu málám wa kápángga ku ing yánuk, “Pris yan káin kut tu watá sáhineráng.” Wáina yánán pris yan káin kunggaturáng wahára re sut yáni yá rongrongngá háliuk. ");
INSERT INTO klt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kulá orek yáni hára ámna káman dá káuk ku ilalákngá yá álo hálen kangga ku hahatingga Ánutu kutná mengga heronge tángtáng son áwuk ngáyá ");
INSERT INTO klt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","áwáng Jesu hárammá hulá káin tulá hára imángga turingga hangga kurákmáta táng hang káwak káin tingga heronge mená inuk. Iná ámna málám wawu Samaria nan. ");
INSERT INTO klt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wáina tán Jesu yá ámna wa kangga ku miuk, “Ámna 10 dá rongrongeráng, iná ámna 9 du rekáin átaráng? ");
INSERT INTO klt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kámuk áwángga Ánutu kutná meng tárut tátáyan du muná hám, enendu ále kámá káinnan nátá re áwek?” ");
INSERT INTO klt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wáina mengga ku inuk, “Tárutang kung. Naráng hákhátikka yá tán álo hálelák.” ");
INSERT INTO klt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Rám káman Farisi yá Jesu ing ináng suliuráng, “Rina hára ku Ánutu yan átkuku watá áwinek?” Wáina inát tu Jesu yá yánuk, “Ánutu yan átkuku watá áwinek wawu ámna náráwa yá wáina ingga ma káindáráng. ");
INSERT INTO klt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hang ámna náráwa yá ‘Wawu nákáin,’ me ‘Wawu áring káin átak ka kaniráng,’ ingga ma meindáráng. Kaniráng, Ánutu yan átkuku wawu sáni ya orek sáni hára há átak.” ");
INSERT INTO klt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wáina yánángga sangga ku hang disaepelná yánuk, “Máriya rám káman áwinek wahára Ámna Nanggená yá son áwinek wawu kakaya kikiná hánám narineráng, enendu ma káindáráng. ");
INSERT INTO klt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kulá ámna yá ku sánineráng, ‘Kungga kaniráng, árongnga káin átak!’ me ‘Kaniráng, nákáin átak!’ ingga sánát tu watán me wa ma isutnándaráng. ");
INSERT INTO klt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iná Ámna Nanggená yá áwinek hára wu pikpirik ká pák táng san alek numkálu átang kung numkálu sálikngingngátak wáinanyon táinek. ");
INSERT INTO klt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Enendu hulátingga málám bá ku sut láwit táwi narinek, hang rám nátán ámna watá ku wata taktak yáminek. ");
INSERT INTO klt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noa yan rám hára ámna náráwa yá kálu rina táuráng wáinanyon du Ámna Nanggená yá áwinán táinek hára tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa yan rám hára wu umi sungi nangga ámna yá náráwa yot ket tántán tángga átnárát tu Noa yá kungga kilang kinan háuk. Kung há han du umi sip pá áwáng ámna náráwa erek hánám ráháng kátkámut táng háliuk. ");
INSERT INTO klt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Hang Lot tán rám hára wu wáinanyon ámna yá umi sungi nangga kutná kutná yumnak tángga ále hái hingga it tátá tángga átnárát ");
INSERT INTO klt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot tá it Sodom sangga kuk rám waháranyon káráp lánggop pá sup hára rangga árená yá alek kálu ále yá ina hangga ámna náráwa iháng rang kátkámut táng háliuk. ");
INSERT INTO klt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Iná Ámna Nanggená yá hiták áwáng heinek rám wahára wu wáinanyon tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Rám wahára káman dá itná hungnganá ketnán átnek watá hang itná kinan kutná kutná ná ma ihindak, me káman dá hái káin átnek watá kung it káin kutná kutná ná manyon ihindak. ");
INSERT INTO klt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot áwáná hára tárák tunggafiuk wa narineráng. ");
INSERT INTO klt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Niyá málámbán átnát náya narángpak táinek wawu átkukuná watá muná kuinek. Iná káman dá átnát náya narángpak ma táindák wawu átkukuná watá ma muná kuindák. ");
INSERT INTO klt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No ing sánin, yáung wahára Ámna Nanggená yá áwinek hára wu yará yá kome káman hára re ruhángga átnemálák wawu Ánutu yá káman sangga káman táinek. ");
INSERT INTO klt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Náráwa yará yá másáng táng totoliya wit táulá husing mánmán tángga átnemálák wawu káman sangga káman táinek.” ");
INSERT INTO klt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Me wa yánán narángga disaepel yá Jesu ináng suliuráng, “Táwi, ále rekáin du wáina tunggafeinek?” ing inát tu Jesu yá yánuk, “Ále rekáin káwak sut tá kámutang hásingga átnándaráng wakáin du tále katkat tá áwáng urum tángngátaráng.” ");
INSERT INTO klt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kulá Jesu yá rámá rámá sáponga tátáya háláng haha ma táindaráng ingga me tárákngá disaepelná ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“It káman hára jas káman átkiuk wawu Ánutu ya ma pitáng mánggiuk, me ámna nuknukngá wawu kápán ále hánám ina hálenggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","It waháranyon náráwa kawát káman átkiuk watá ku rámá rámá jas watán káin áwáng gu ing inánggiuk, ‘Káyam bá neháng lem tátáya tánggoeráng, wata ku ko me kot hára háláng naminelák.’ ");
INSERT INTO klt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Wáina inán du hulátingga ku háláng imámáya takta naruk, enendu máriya ku málám átang gu ing naruk, ‘Ánutu ya ma pitáng mángngátat me ámna nuknukna wawu kápe ále hánám ina hálengngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Enendu rámá rámá wu náráwa kawát nátá yámbánek táng namángga áwánggoek. Wáina wata ku me kot hára háláng me ku son nákkán káin áwángga yámbánek ma táng namindak,’ wáina naruk.” ");
INSERT INTO klt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wáina mengga ku Táwi yá son disaepelná yánuk, “Sándá jas wáik watá me miuk wa narániráng. ");
INSERT INTO klt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kulá rina? Ánutu yá ámna náráwa nakán ingga iháng tunggap tán rámá rámá káen yáungán málámbán káin pahán yot inángga átnándaráng wa sokmuná ma háláng yámánggim me? Wa muná. ");
INSERT INTO klt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No ing sánin, wawu sokmuná ingmen háláng yáminek. Enendu rám Ámna Nanggená yá áwinek wahára ámna náráwa káwak ketnán átaráng wa málámba naráng háting mángga átaráng me muná ingga kápinek.” ");
INSERT INTO klt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ámna kámá yá náni wu kándáng rewe hánám átang átningngátamán ingga narángga kámá wu kápát háená hálengngátaráng wata tángga Jesu yá me tárák hára tingga ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ámna yará yá Táwi yan it káungá hánám káin sáponga tátáya árumálák. Káman du Farisi iná káman du takis iháhá. ");
INSERT INTO klt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kulá Farisi watá hetang átang málámba sáponga táuk, ‘Ánutu, no heronge mená meng se kákkán káin koek, náuta nák ku ámna kátu ina muná - manek tángngátaráng, nanará kandák isutnándaráng, márámamák tángngátaráng me enang takis iháhá ná ina muná. ");
INSERT INTO klt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nák ku sungi sangga sáponga yáup hára sonda káman da ore hára rám yará átnándat, me kutná kutná ihángngátat wawu hore 10 hálen urum káman kákkán pingnga tingngátat.’ ");
INSERT INTO klt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Iná takis iháhá watá ku mulangán sim hetang átang alek kálu ma háliuk, ináku pahán márapmá narángga muyipmá kátingga turingga hangga ku miuk, ‘Ánutu, nák ku mukmuro ámna. Ko nákkán kátu sáinelák,’ ingga wáina sáponga táuk. ");
INSERT INTO klt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ámna niyá málám tángga árinek wawu Ánutu yá táng hang tinek, iná niyá málám tángga háinek wawu Ánutu yá táng áráng tinek, wáina wata ku no ing sánin, rám takis iháhá watá itná káin kuk wahára wu ámna watá re ku Ánutu rahálá hára ámna kándáng háliuk, iná Farisi wawu muná.” ");
INSERT INTO klt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ámna náráwa yá nángánangge yáni isikikimo wa Jesu yá há ihánggápik ingga Jesu yan káin ihángga áwángga árát disaepel yá wa kápángga me táng yámuráng. ");
INSERT INTO klt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wáina tát kápángga Jesu yá nangge kikimo wa mantán málámbán káin áwát tu disaepelná yánuk, “Sat nangge kikimo watá nákkán káin áwániráng, ma kung hákhátik táng yámindaráng, náuta Ánutu yan átkuku kinan kung haha wawu ámna náráwa niyan pahán dá nangge kikimo ná ina átnek watán. ");
INSERT INTO klt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No pálipuk ing sánin, ámna káman dá Ánutu yan átkuku wa nangge kikimo yá tángngátaráng wáina ma táindák wawu kung átkuku wata kinan ma háindák.” ");
INSERT INTO klt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kulá ámna yáilá káman dá Jesu inuk, “Tiksa álo kámá, rina tángga ku rámá rámá átkuku álosim wa táinet?” ");
INSERT INTO klt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wáina inán Jesu yá inuk, “Náuta ku nák ku álo kámá ingga nanelák? Ánutu káman re ku álo kámá. ");
INSERT INTO klt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Meng rákit mená wu há narelák wa: ‘ámna ma utnándalák, márámamák ma táindalák, manek ma táindalák, nangge nukka ya me kusák ma meindalák, hang nanya me mamya ya tárang káin re átnelák.’” ");
INSERT INTO klt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wáina inán ámna watá inuk, “Nangge kimo átut hára átang áwáng ná átat hára wu meng rákit mená wawu erek hánám há isutnándat.” ");
INSERT INTO klt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wáina inán narángga ku Jesu yá inuk, “Kák ku náut kámá káman da re kesák táelák, wawu kungga kutná kutná átyamek wa erek iháng tingga yánátá yuwát sup wa iháng ukuro átaráng wa yámángga ku nák nasutnelák. Wáina tángga ku alek kán átkuku álosim wa táinelák.” ");
INSERT INTO klt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Rám Jesu yá wáina inuk wahára wu ámna watá kutná kutná ná táup táwi wata narángpak tángga pahálá yá márawiuk. ");
INSERT INTO klt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wáina tán kangga Jesu yá ámna wa inuk, “Ámna ni kutná kutná ná táup hánám watá kungga Ánutu yan átkuku kinan haha wawu yáupmá háláng hánám. ");
INSERT INTO klt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Samap hinangngá hára kamel yá huruk kuku watán márapmá wawu maming táwi, enendu ámna kutná kutná ná pálak ká kung Ánutu yan átkuku kinan haha watán márapmá watá wa táng hátek.” ");
INSERT INTO klt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wáina inán ámna niyá me wa naruráng watá ku Jesu inuráng, “Kulá wáina wata ku niyá hánám bu rámá rámá átkuku álosim wa táinek?” ");
INSERT INTO klt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wáina inát tu Jesu yá yánuk, “Náut kámá káman ámna nangge yá ma tátáyan wawu Ánutu yá álo tánggim.” ");
INSERT INTO klt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wáina yánán Pita yá ing inuk, “Naráng, nándu kutná kutná náni erek hánám yápmang hálingga ku kák kasutumán!” ");
INSERT INTO klt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wáina inán Jesu yá yánuk, “No pálipuk hánám ing sánin, ámna niyá Ánutu yan átkuku wata narángga itná, áwáná, tatning me kulaná, maming naning me nángánangge yápmáinek ");
INSERT INTO klt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wawu náut rina rina yápmáinek wa táng hátingga Ánutu yá káwak ketnán naháranyon nukngá táuppon iminek. Hang máriya rám kálu ku átkuku álosim wa táinek.” ");
INSERT INTO klt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu yá urum táwi wa yápmangga disaepelná 12 wa yángot kung kep sim átang yánuk, “Narániráng, náwu Jerusalem káin árángga kunggatkoemán, iná rina rina Ámna Nanggená hára tunggafefeya profet tá uyiuráng wawu wáina hánám há tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ámna Nanggená wawu táng ámna ále kámá káinnan da ket yáni hára tit ináng kekkek tángga ket tárák wáik elengga alup yáni málámba ketnán uráhineráng. ");
INSERT INTO klt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wáina tángga ku honggem bá lahot mángga táng kung utkámut táineráng. Kulá rám kaláhu átang gu son tárutnek.” ");
INSERT INTO klt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesu yá me wa yánuk, enendu me wata hulá watá kilak árán disaepelná yá ku hulá wáina ta nánek ingga kámá ma naráng rákit táuráng. ");
INSERT INTO klt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kulá rám Jesu yá Jeriko it hára áwáng hein ingga tángga átuk wahára wu ámna rahálá kunángngá káman dá kálu tákto káin putung átang ámna náráwa sup pa mantáng yámángga átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Átang naruk ku táup hánám watá áwáng tát narángga ku yánáng suliuk, “Rina tánggoeráng?” ");
INSERT INTO klt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wáina yánán du inuráng, “Jesu Nasaret nan watá áwángga átak.” ");
INSERT INTO klt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ingga inát tu málám mantáuk, “Jesu, Dewit Nanggená, nákka urákna naráng!” ");
INSERT INTO klt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wáina mantán narángga ámna watá kálak áwángga áturáng watá me táng mángga ing inuráng, “Yolop álák!” ingga inuráng, enendu málám hahatingga hánám mantángga Jesu inuk, “Dewit Nanggená, nákka urákna naráng!” ");
INSERT INTO klt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wáina mantán narángga Jesu málám tareng kátingga átang ámna wa engotang rupmá káin áwáwáya yánán engotang áwát tu ámna wa inuk, ");
INSERT INTO klt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“No rina táng kaminet ta narelák?” Ingga inán du watá inuk, “Táwi, rahánna háháleya naret.” ");
INSERT INTO klt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wáina inán du Jesu yá inuk, “Nák ka naráng háting namelák watá tán du rahála yá álo háleik.” ");
INSERT INTO klt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wáina inán rám waháranyon hánám bu rahálá yá hálengga kangkang gu Ánutu kutná mengga meng tárut tángtáng Jesu isutang kuk. Iná ámna náráwa kámuk hánám wa káuráng hára wu wáinanyon Ánutu kutná mengga meng tárut táuráng. ");
INSERT INTO klt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu málám Jeriko it kinan hangga ku kálu isutang it sangga kuin ingga kungga árán, ");
INSERT INTO klt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ámna káman wahára átkiuk wata kutná wu Sakias. Ámna wawu takis ihángngátaráng wata táwi yáni, hang málám bu supmá wu táwi hánám wáina átmánggiuk. ");
INSERT INTO klt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakias málám Jesu wu ni ingga kakaya naruk, enendu málám wawu ámna hátetná wáina hálendu ámna náráwa watá kik hánám átang ting sungga árát tu Jesu ma káuk. ");
INSERT INTO klt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wáina hálendu Jesu wu kálu wa isutang áwinek ingga há narángga sangga watá kálak hururung ingmen kuk ngáyá kung káráp fik káman da ketnán árángga kuk. ");
INSERT INTO klt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kulá Jesu málám kálu wa isutang káráp hulá hára kung hengga ku háleng san káráp ketnán árán du inuk, “Sakias, sokmuná hánám hang. Nák ku kula kákkán it káin átnet.” ");
INSERT INTO klt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wáina inán málám sokmuná hánám hangga heronge hánám kang mengga itná káin engotang kuk. ");
INSERT INTO klt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wáina tán kangga ámna náráwa yá kuk narángga Jesu ya ing meng muráng, “Ámna mukmuro mara yan it káin koek.” ");
INSERT INTO klt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kulá Sakias málám tárutnáráng Táwi ing inuk, “Táwi, kang, no kutná kutná na wa pana huk tángga numkálu wa iháng ukuro mara wa yáminet, hang káman ni ingirungngingga sup rina tená wa táng hátingga iháng mut wawu son wata ketnán nukngá te 4 hálen iminet. Wáina pálipuk hánám táinet.” ");
INSERT INTO klt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Wáina inán Jesu yá inuk, “Rám kula Ánutu yá ámna náráwa it náta kinan nan wa son ihek. Ámna náwu Abraham nanggená yon. ");
INSERT INTO klt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ámna Nanggená yá áwuk wawu niyá yakyawená wa sulingga son iháháya áwuk.” ");
INSERT INTO klt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kulá Jesu málám bu Jerusalem tangtang kung hálingga árán du ámna náráwa Jesu yan me narángga áturáng watá Ánutu yan átkuku wawu kula há hiták háleindek ingga narángga áturáng. Wáina narángga árát tu Jesu yá me tárákngá káman ing yánuk, ");
INSERT INTO klt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ámna hulá káman dá málámba ing naruk, ‘Itna sangga ále kámá mulangán káin koe ku king táwi yáni ya árená watá ále káwak na yan king neháng tunggap tán du itna káin son áwángga ámna náráwana pin yáni táinet.’ ");
INSERT INTO klt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wáina narángga ku yáup nanggená 10 wa mantán áwát tu supmá kátu horengga káman káman yámángga ku yánuk, ‘Sup ná iháng kung tambáng ma tená ku yáupmá tát táwi tái hálengga kungga árán du no son áwinet.’ ");
INSERT INTO klt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kulá ámna hulá watá itná sangga há kun du itná hulá watá ámna kámá suring yámát kungga king táwi yáni wa ing inuráng, ‘Nándu ámna hulá watá nándán king háháleya taktak námek.’ ");
INSERT INTO klt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wáina ingga inuráng, enendu king táwi yáni watá ámna hulá wa kut king há imán du son itná káin áwáng átang gu yáup nangge watá áwát sup yámuk wata ketnán rina hánám táng tunggap táuráng ingga kápápáya me san kun áwuráng. ");
INSERT INTO klt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Áwángga ku ámna hulátingga áwuk watá áwáng inuk, ‘Ámna hulá, nák ku sup táwi namulák watá yáupmá táe sup 10 dá tunggafen wa iháng wata ketnán tiut.’ ");
INSERT INTO klt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Wáina inán ámna huláná watá inuk, ‘Álo kámá táulák! Kák ku yáup nanggena álosim. Ko isikimo wa kándáng hánám pinná táulák wata ku it táwi 10 wa pin yáni táinelák,’ ingga inuk. ");
INSERT INTO klt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kulá son ámna nukngá káman dá áwáng inuk, ‘Ámna hulá, nák ku sup táwi namulák watá yáupmá táe sup 5 bá tunggafen wa iháng wata ketnán tiut.’ ");
INSERT INTO klt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Wáina inán du ámna huláná watá inuk, ‘Kák ku it táwi 5 wata pin yáni táinelák.’ ");
INSERT INTO klt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Kulá ámna nukngá káman dá áwáng gu inuk, ‘Ámna hulána, kák ku ámna ángárángngá hánám. Náut kámá káman kámá yan hára ihángngátalák, me kámá yá irit hená wata páliná hányon ihángngátalák. Wáina wata ku pitáng kamángga ku supya wawu lap kátu yá támotang se átnándak. Kang, supya namulák wawu ná.’ ");
INSERT INTO klt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Wáina inán táwiná yá inuk, ‘Kák ku yáup nangge wáik! Kangán me wanyon isutang keháng me hára tinet. Ka há narelák wa, nák ku ámna ángárángngá hánám. Náut kámá káman kámá yan hára ihángngátat, me kámá yá irit hená wata páliná hányon ihángngátat. ");
INSERT INTO klt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nák ku ámna wáina ná ingga há naráng namelák, watá ku rina tángga ku nákkán sup ná táng sup itná káin ma tiulák? Wáina tinggim watá ku son áwánggem wahára ku sup kámá wata torong hára tit watyot ihánggem.’ ");
INSERT INTO klt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wáina inángga ku kámá wahára áturáng wa yánuk, ‘Sup wa táng ámna niyá sup 10 ihuk wa imániráng.’ ");
INSERT INTO klt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Wáina yánán watá ing inuráng, ‘Ámna hulá, ámna wawu sup 10 wa há átmek!’ ");
INSERT INTO klt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Wáina inát tu watá yánuk, ‘No ing sánin, káman niyá táup há ihángga átnek wawu no kutná kutná kámá yot iminet, iná káman niyá náut kámá ma ihángga átnándák wawu no náut isikimo tángga átnek wa imáng hutang ihinet. ");
INSERT INTO klt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kulá nák káyamna no watán king háháleya ma naruráng wa iháng áwáng nahára nák rahánna hára ráháng kátkámut tániráng.’” ");
INSERT INTO klt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu yá me wa yánáng hálingga sangga ku son kálu hulátingga árángga Jerusalem ba kuk. ");
INSERT INTO klt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Málám bu kung ále yáilá Olif káin átuk, it Betfage yot it Betani tangtang. Wahára átang gu disaepelná yará suring yámángga yánuk, ");
INSERT INTO klt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kungga it áning hára kung hengga waháranyon káinemálák ku donki máto káman wahára puting sat átak wawu ni kámá káman dá wata ketnán putung átang ma kung áwáng táená wa páupmá yaling mángga ku engotang áwinemálák. ");
INSERT INTO klt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iná káman dá sáhángga sáninek, ‘Náuta ku donki páupmá yaling mánggoemálák?’ ingga sánán du ing ininemálák, ‘Táwi yá wata narek.’” ");
INSERT INTO klt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wáina yánán du disaepelná yará yá kungga káumálák ku rina yánuk wáina hánám re há árán. ");
INSERT INTO klt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kulá yándi wu donki wa páupmá yaling mángga átnárán du márumá yá áwáng yánáng suliuráng, “Náuta ku donki páupmá wa yaling mánggoemálák?” ");
INSERT INTO klt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wáina yánáng sulit tu yánumálák, “Táwi yá wata narek.” ");
INSERT INTO klt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wáina yánángga donki wa engotang Jesu yan káin áwángga lap yándi hákhásák sut yándi háranan wa yalingga iháng donki ketnán tin du Jesu yá áráng wata ketnán putung átuk. ");
INSERT INTO klt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kulá Jesu yá donki wata ketnán kungga átuk wahára wu ámna náráwa yá lap yáni hákhásák wa yalingga iháng kálu hára elengga kut tu wata ketnán yángyáreng kuk. ");
INSERT INTO klt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesu yá kálu isutang Jerusalem tangtang áwángga ále yáilá Olif kálu háená wahára kungga átuk hára wu ket tárák hulá hulá tán kangngátaráng wata disaepelná urum táwi watá hulátingga heronge táwi tángga hahatingga Ánutu kutná meng tárut tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ing mantángga kuráng, “King nátá Táwi kutná hára áwek wawu Ánutu yá há táng álolo táená watá áwek!” “Ánutu kutná meng tárut tátne irawa káin árik! Ánutu yá ámna náráwaná yot orek yáni hára pahán káman dá átkoek!” ");
INSERT INTO klt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wáina mantángga árát urum táwi wata kinan du Farisi kámá yá ku Jesu inuráng, “Tiksa, ko disaepelka wáina ma táindaráng ingga me táng yámáng!” ");
INSERT INTO klt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wáina inát tu Jesu yá yánuk, “No ing sánin, watá sangga nángnángingga átgalát wawu sup watá álo menman yáni tánggalát.” ");
INSERT INTO klt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kulá Jesu yá Jerusalem tangtang áwáng hengga ku it yáilá wa kangga kut mángga ");
INSERT INTO klt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ing miuk, “Jerusalem, káe kula rina tángga ku álosim me heronge átnelák ingga naret, enendu náutá tán wáina átnát tán wawu kilak átak, ko ma kakayan. ");
INSERT INTO klt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Rám káman tunggafeinek wahára wu káyam bá áwáng keháng áwálák tángga káwak iháng áwáng kumbika hulá áwálák tingga árángga kut hátewin kung hangga ámna náráwa ka ráháng kátkámut táineráng. ");
INSERT INTO klt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rám wahára keháng káting mánmán táng sat hatá ka yot nángánanggeka kák kinan átaráng wa sáháng lem hánám táineráng. Hang kákkán sup káman sat nukngá ya ketnán ma átnándák, náuta ko rám Ánutu yá kákkán káin áwuk wa ma kang rákit táulák wata.” ");
INSERT INTO klt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kulá Jesu málám Táwi yan it káungá hánám wata kumbiná kinan kung hangga wata kinan ámna sup yáupmá tángga áturáng wa yásutuk. ");
INSERT INTO klt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wáina tángga málám ing yánuk, “Ánutu yan me ing uyená yá átak, ‘Táwi yan it wawu sáponga tátáyan it’, enendu sándá tát tu ‘manek mara yan ále kilakngá ina’ hálenggoek.” ");
INSERT INTO klt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kulá málám bu rámá rámá Táwi yan it káungá hánám wahára ámna náráwa me pingnga álosim wa yánáng tolingga átkiuk. Iná pris tátáwi yáni me lo yan tiksa me ámna náráwa yan ámna yáilá hulá hulá watá ku kálu rekálu kungga utkámut tánin ingga kálu ya sulinggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Enendu wata wáina tátáyan kálu kámá ma káuráng, náuta ámna náráwa urum táwi watá watán me wa naránin ingga káto hánám hálengga áturáng wata. ");
INSERT INTO klt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Rám káman Jesu málám Táwi yan it káungá hánám kapmená káin wa átang ámna náráwa me yánáng tolingga ku Ánutu yan me pingnga álosim wa yánángga átnárán du pris tátáwi yáni, lo yan tiksa me ámna hulá hulá watá watán káin áwuráng ");
INSERT INTO klt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ngáyá ku ináng suliuráng, “Kulá nánáng, kák ku háláng wawu rekáinnan táng gu ket tárák tánggoelák? Háláng wawu niyá kamuk?” ");
INSERT INTO klt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wáina inát tu yánuk, “No me káman hányon sánáng sulindet ta ku topmá nanineráng. ");
INSERT INTO klt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon dá umi kuháng yámánggiuk wawu alek kálu nan me ámna yan káinnan?” ");
INSERT INTO klt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wáina yánán yáni yon inán kanán tángga ku miuráng, “Nándá ‘Alek kálu nan,’ ingga ininemán wawu náninek, ‘Náuta ku Jon dán me wa pálipuk ingga ma naráng háting kuráng?’ ingga náninek. ");
INSERT INTO klt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iná nándá ‘Ámna yan káinnan,’ ingga ininemán wawu ámna náráwa táwi nátá sup mangga náráháng kátkámut táineráng, náuta Jon wawu profet káman ingga há nareráng wata.” ");
INSERT INTO klt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wáina mengga ku Jesu inuráng, “Wakáinnan ingga nán ma narámán.” ");
INSERT INTO klt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wáina inát tu Jesu yá yánuk, “Nák ku wáinanyon ma sánindát, háláng wawu niyá namán du ket tárák wa tánggoet ingga.” ");
INSERT INTO klt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kulá wahára átang gu me tárákngá káman Jesu yá ámna náráwa yánuk, “Ámna káman dá wáin hái káman hingga ku málám hái wa táng ámna kámá yá wahára sup yáupmá tátáya ket yáni hára tingga sangga ku kung it mulangán káin rám hásák átuk. ");
INSERT INTO klt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kulá rám wáin dá páliná tená kálu ku málám yáup nangge káman suring mángga ing inuk, ‘Kungga wáin hái pinná tángngátaráng ámna wa yánátá ku wáin páliná kámá kamát ihángga áwáng,’ ingga inán kuk, enendu ámna hái pinná tángga áturáng watá utang sonson tángga isurát hánámá ketná páliná muná son kuk. ");
INSERT INTO klt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wáina kangga yáup nangge nukngá suring mán son kuk, enendu wa wáinanyon utang sonson tángga táng wáik tát reprepmá narán isurát hánámá ketná páliná muná son kuk. ");
INSERT INTO klt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wáina kangga málám yáup nangge nukngá suring mán son kun du rám kaláhu háliuk, enendu wawu wáinanyon táup hánám sip pálak utang sonson tángga táng sat kep káin háuk. ");
INSERT INTO klt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Wáina tát kangga ku hái márumá watá miuk, ‘Rina táinet? Satá nanggena na kikiná hánám narángga átnándat wa suring me kuinek. Kámá watá kun du watán me álo hám narineráng.’ ");
INSERT INTO klt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Kulá nanggená yá kung hen kangga ámna hái káin yáup tángga áturáng watá yáni meme táuráng, ‘Ámna wa áwek watá ku máriya naning gán kutná kutná ihinek. Satá wa utkámut tángga ku hái náwu nánin háleinek.’ ");
INSERT INTO klt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wáina mengga ku táng mangga sat hái kep káin han du utkámut táuráng. “Kulá ámna hái márumá watá ku rina táng yáminek? ");
INSERT INTO klt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Málám áwinek watá áwáng ámna hái káin yáup tángga átneráng wa erek ingmen ráháng kátkámut tángga ku hái wa táng ámna nukngá ya ket yáni hára tinek.” Jesu yá wáina yánán ámna náráwa yá me wa narángga, “Wáina ma tunggafeindak!” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wáina met Jesu yá kárek hánám kápángga átang miuk, “Me ing uyená wata hulá ku rina? ‘Ámna it tátá yá sup wáik ingga kangga táng sat kuk, watá inggálu it hálángngá ya káto hánám átkoek.’ ");
INSERT INTO klt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Káman dá sup wata ketnán iháng hang kátinek wawu málámbáyon káting mákmárák tángga kimo kimo háleinek, iná sup watá káman da ketnán háinek wawu káting pákpálák táinek.” ");
INSERT INTO klt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wáina yánán me tárákngá náwu náni ya mek ingga há narángga ku lo yan tiksa me pris tátáwi yáni watá rina tángga Jesu ket tánin ingga kálu ya suliuráng, enendu ámna náráwa ya pitáng yámuráng. ");
INSERT INTO klt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kulá pris tátáwi yáni me lo yan tiksa watá Jesu wawu kándáng hánám kang tantan tánggiuráng. Wáina tángga ku ámna kámá suring yámát kilak átang watán me wa naránin ingga kusák pilengga átningga ku me kámá rina kandák men narángga ku táng kapman táwi ya ketná hára tit tu watá táng me hára titiya. ");
INSERT INTO klt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wáina tángga ku ámna kilak kang tantan táuráng watá inuráng, “Tiksa, nándá kák ku me kándáng rewe mengga ku kálu kándáng wa rewe nánáng tolinggoelák ingga há naremán. Ámna háená me árená wawu tárák káman re yánánggoelák, iná me páliná wahára re ku Ánutu yá tárák rina átnát ta narek wa nálenggoelák. ");
INSERT INTO klt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wata ku rina narelák? Takis Sisa álo iminemán me muná?” ");
INSERT INTO klt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wáina inát tu Jesu yá nangnarungngeráng ingga há narángga ku yánuk, ");
INSERT INTO klt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sup táulá káman namát no káin. Wahára ni utniná me ni kutná yá átak?” ");
INSERT INTO klt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wáina yánán du inuráng, “Sisa yan,” ingga inát tu Jesu yá yánuk, “Wáina wawu náut Sisa yan wa Sisa imángga náut Ánutu yan wa Ánutu imineráng.” ");
INSERT INTO klt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kulá káuráng gu watá me ámna náráwa rahán yáni hára wa miuk wata ingga táng me hára titiyan du káluná muná. Yáni wu hurikngá rina yánuk wa narángga hárámutang gu nángnángingga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kulá ámna urum káman kut yáni wu Sadyusi watá ámna náráwa kámurená wawu ma tárutnándáráng ingga narángngátaráng waháranan kámá yá Jesu ináng sulinin ingga Jesu yan káin áwuráng. Áwáng átang ing ináng suliuráng, ");
INSERT INTO klt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tiksa, Moses yá me ing uyingga ting námuk, ámna káman dá kámutang áwáná nanggená muná sáinek wawu kulaná yá náráwa wa tángga tatning gán da nangge táng tinek. ");
INSERT INTO klt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Rám káman tatning kukulak 7 dá átkiuráng. Átang tat yáni táwi watá áwáná káman táuk enendu tat yáni watá nanggená muná átang kámutuk. ");
INSERT INTO klt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wáina hálendu son kulaná wata hangga hára watá náráwa kawát wa táuk wa wáinanyon kámurán, ");
INSERT INTO klt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","son wata hangga hára watá táuk wa wáinanyon kámutuk. Wáina re táng kung táng kung tatning kukulak 7 wa nangge yáni muná re átang kámut háliuráng, ");
INSERT INTO klt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","hang pukon da ku náráwa kawát yáni watá hányon kámutuk. ");
INSERT INTO klt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kulá wáina wawu máriya tátárut kálu ku ni hánám ba áwáná ku wa háleinek, náuta tatning kukulak 7 wata áwá yáni há háliuk wata?” ");
INSERT INTO klt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wáina inát tu Jesu yá yánuk, “Káwak ketnán du náun áwán hálengga átnándaráng. ");
INSERT INTO klt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Iná ámna náráwa ni Ánutu yá álo son tárutang átkuku sásáliná muná táineráng ingga narek watá wu alek káin du náun áwán hálengga ma átnándáráng. ");
INSERT INTO klt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Náuta wawu son ma kámutnándáráng, ináku angelo yá ina átneráng. Ánutu yá kámurená yan ále káinnan há iháng tárut tán du málámba nángánangge hálengga átneráng. ");
INSERT INTO klt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hang ámna kámurená wu hányon tárutneráng ingga Moses yá me wa uyingga táng hiták ting námuk. Káráp isikimo hára káráp pá ranggatuk watán pingnga hára wu ing uyiuk, ‘Táwi wawu Abraham, Aisak me Jekop watán Ánutu.’ ");
INSERT INTO klt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Watá ku ing nánek, Ánutu wawu kámurená yan Ánutu muná, ináku ámna átkuku yáni pálak watán Ánutu. Iná Ánutu rahálá hára wu ámna náráwa kámuk ku ma kámurená há átaráng.” ");
INSERT INTO klt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wáina yánán narángga lo yan tiksa kámá yá Jesu inuráng, “Tiksa, kákkán me wawu kándáng hánám.” ");
INSERT INTO klt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wáina hálendu ámna yá Jesu ináng susuliya hányon pitáuráng. ");
INSERT INTO klt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kulá Jesu yá ámna náráwa yánáng suliuk, “Rina tángga ku ámna náráwa yá ing menggoeráng, ‘Ámna ni Ánutu yá ámna náráwaná son iháháya miuk wawu Dewit nanggená’? ");
INSERT INTO klt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dewit málámbá Kap Papia hára ku ing miuk, ‘Táwi Ánutu yá Táwina ing inuk, “Ketna álák kálu putung árátá kungga ");
INSERT INTO klt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","no káyamya wa ráhángga iháng hang ting se árát ko wa iháng háting áráng átnelák.”’ ");
INSERT INTO klt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit tá ku Táwina ingga miuk, rina tángga ku son du nanggená?” ");
INSERT INTO klt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wáina yánán ámna náráwa yá kárámatingga árát tu Jesu yá disaepelná yánuk, ");
INSERT INTO klt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lo yan tiksa wa kándáng kánggápáng átneráng. Lap hákhásák tánggánengga sengsulingga átningngátaráng, hang náhángga kut náni meng tárut táng námániráng ingga maket álele wa átningngátaráng, hang umi sinak táená káin me miti itná káin kome máta káin átnin ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hang yáni wu náráwa kawát wa yángyárungngingga it yáni náut wa yáni ya ihángngátaráng, hang náhániráng ingga sáponga wawu hásák hánám wa tángngátaráng. Máriya rám kálu ámna wáinaná wawu márapmá táwi hánám wa ihineráng.” ");
INSERT INTO klt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu málám hálengga átang kápuk ku ámna náráwa sup yáni pálak watá áwáng taha yáni Táwi yan it káungá hánám watán sup titi komená hára wa tingga árát. ");
INSERT INTO klt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Málám káuk ku ukuro kawát káman dá áwáng sup isikimo yará wa ihángngáwáng tin, ");
INSERT INTO klt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","wa kangga ku Jesu yá yánuk, “No pálipuk hánám ing sánin, náráwa kawát ukuro watá áwáng gu sup táwi hánám wa kátu iháng hátingga Ánutu yan pingnga tek. ");
INSERT INTO klt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ámna náráwa watá ku táwi átyámek háranan kátu re ihángngáwáng teráng, iná náráwa wawu kesák hánám táek enendu kimo átmek wa kámuk hánám tek. Máriya málám háláng mámáyan da ku ma narák.” ");
INSERT INTO klt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Disaepel kámá yá ku Táwi yan it káungá hánám wa kangga ku ing miuráng, “Náwu sup álolosim hánám me kutná kutná álosim Ánutu ya ting mená wa iháng gu itná tánggánená.” Wáina met tu Jesu yá yánuk, ");
INSERT INTO klt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nahára náut káeráng wata sánindet, wawu rám káman tunggafeinek wahára wu sup káman dá nukngá ya ketnán ma átnándák, ináku erek hánám káting mákmárák tángga táng hirarát háineráng.” ");
INSERT INTO klt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wáina yánán du inuráng, “Tiksa, rám bu rina hára ku watá tunggafeinek? Me tárák ku rina tunggafen kangga ku wáina táindek ingga narinemán?” ");
INSERT INTO klt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wáina inát tu Jesu yá yánuk, “Kándáng hánám háleng rákit tángga átneráng, sángsárungnginirot ta ku. Náuta ámna máro yá yon du nák kutna hára áwángga ‘nák ku wa’ ingga sánineráng me ‘rám bu hátewek’ ingga sánineráng, enendu sándá watán me wa ma narindaráng. ");
INSERT INTO klt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kun erawák ká tunggafen met narineráng, enendu wata ma pitáindaráng. Wáina wawu watá kálak há tunggafeinek, enendu rám wawu sokmuná ma tunggafeindák.” ");
INSERT INTO klt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wáina yánángga ku yánuk, “It kámá yá it kámá yot erawineráng, me king tombong kámá yá king tombong kámá yot erawineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hang itná itná káin kánggáning maming tátáwi yá táineráng me sungi kesák me ilalák káto yá tunggafeineráng, hang alek káin du tárák hulá hulá watá tunggafengga sáháng piták táineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Iná ále watá ma tunggafená árán du ket sáhángga sáháng lemlem táineráng. Miti itná kinan sáháng me hára tineráng ngáyá ku sáháng hirarát kalabus káin kuineráng, me sáháng kung king me kapman rahán yáni hára tineráng. Wáina táineráng wawu nákkán tombong ingga átneráng wata. ");
INSERT INTO klt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sáháng wáina táineráng watá ku sándá me pingnga álosim wa yánánáyan kálu álosim táng tolineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Enendu sándá narángpak tángga me wa rina meinemán ingga ma narindaráng, ");
INSERT INTO klt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","náuta nayon nanará álosim sámángga me wáina meineráng ingga sánáng tole met káyam bá sándán me wa káting hang titiyan tárák ma háleindák. ");
INSERT INTO klt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hang nan mam sáni me tat kulak sáni me sip sáni kátu me nuknuk sáni yá yon sáháng káyam ket yáni hára tit kámá sán háranan ráháng kátkámut táineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nák ka tángga ámna kámuk hánám watá sánda taktak yáminek, ");
INSERT INTO klt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","enendu yáin sáni rommá káman dá ma yakyawindák. ");
INSERT INTO klt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sáni káto hánám hálengga átneráng watá ku átkuku wa tángga álosim hánám átneráng. ");
INSERT INTO klt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sándá kat tewe ámna yá áwáng Jerusalem pondang átneráng wahára wu it yáilá yá wáik háháleyan rám bu wa ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Rám wahára ku ámna náráwa Judia kinan átaráng watá pitángga árángga ále yáilá káin kuineráng, hang ámna náráwa it yáilá kinan átaráng watá sangga kep káin há háineráng. Iná ámna náráwa kep káin átaráng watá ku kung it yáilá kinan ma háindaráng. ");
INSERT INTO klt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Rám wawu mukmuro táená wata Ánutu yá márapmá yáminek ka ku Ánutu yan papia káin me rina mek watá pálipuk re tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Náráwa kawin pálak me nangge kongakngá muk yámángga átneráng wawu ukuro hánám táineráng! Rám wahára wu Ánutu yá pahán káráp tángga márapmá táwi hánám káwak káin ná ámna náráwa yáminek. ");
INSERT INTO klt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Káyam bá áwáng kámá kápik ká ráháng kátkámut tángga kámá ihángga káwakngá káwakngá káin kalabus it kinan ting sat átnát ta hirarát kuineráng. Iná Jerusalem bu ále kámá káinnan ámna yá áwáng kome tángga átang háram yáni yá tareng pákpálák tángga árát kungga Ánutu yá ále kámá káinnan ámna yá Jerusalem pinná tátáya miuk watá sáliknginek. ");
INSERT INTO klt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Rám wahára wu tárák hulá hulá yá káe, yap me hitung hára tunggafeinek. Iná káwak káin du táp pá wáik hálengga punggilá maming tátáwi yá hiláksingga átneráng wa narángga ámna yan nanará watá yakyawin narángpak tángga pikpiták táwi hánám táineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ámna náráwa táup hánám watá káwak káin rina tunggafeinek wata pikpito narángga narángpak táwi tángga hálet komkolem sin iháng hang kátineráng, náuta alek kán kutná kutná watá yángyáng táineráng wata. ");
INSERT INTO klt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Rám wahára káineráng gu Ámna Nanggená yá mukam kinan hálángngá táwi watyot yamá pálak áwinek. ");
INSERT INTO klt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ále wáina watá tunggafeinek wahára wu káto átang ma pitáindaráng, náuta Ánutu yá son sásáháyan rám wawu enanggon há áwinek.” ");
INSERT INTO klt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kulá Jesu yá me tárákngá ing yánuk, “Kulá káráp fik watyot tu káráp kámuk kápineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Káráp pá ilángá nukngá tit tu káe yá álosim átnándek ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wáinanyon ále wa kat tunggafen du Ánutu yan átkuku wawu enanggon áwáng hálek ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“No pálipuk hánám ing sánin, rám nátán ámna náráwa wu há árát tu ále watá tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Alek me káwak ku sáliknginek, iná nákkán me náwu ma sálikngindák. ");
INSERT INTO klt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kándáng átneráng. Umi nangga hohingga rámá rámá ket tárák wáik wa tángga átning kunirot, me sut tán kutná kutná ya narát páliná háleiwon. Iná wáina watá sáháng hang tingga átnek, wawu Táwi yan rám watá punggip pá ina sokmuná ingmen tunggafengga sáháng wáik táinek. ");
INSERT INTO klt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Rám wa tunggafeinek wawu ámna náráwa kámuk hánám káwak ketnán átaráng watán káin tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rámá rámá háleng rákit tángga sáponga tángga árát tu Ánutu yá háláng sámán rina rina tunggafefeya tángga átak wa táng hátingga ku Ámna Nanggená wata kondolá hára hetang átneráng.” ");
INSERT INTO klt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kulá Jesu málám rám ore wahára wu rámá rámá Táwi yan it káungá káin me wa yánáng tolingga sangga ku it tá páyung tinán tánggiuk kálu ku ále yáilá kutná Olif wakáin ruruháya kunggiuk. ");
INSERT INTO klt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kulá hilápmá hánám bu ámna náráwa táup hánám watá it káungá káin Jesu yan me nanaráya áwánggiuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Israel yá Másáng Yisná Muná Nana yot Angelo yá Iháng Hátiuk watán rám káungá wata naráng hátingga umi sinak tátá watán rám watá enanggon áwáng hálingga árán du ");
INSERT INTO klt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pris tátáwi yáni me lo yan tiksa watá kálu rekálu kungga Jesu utkámut tánin ingga suliuráng, enendu rahán táwi hára tángátne kun erawák ká tunggafeiwon ingga ámna náráwa ya hányon pitáuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kulá rám waháranyon du Satan dá Jesu yan disaepel 12 waháranan káman da pahálán háuk. Ámna wawu Judas, Iskariot ing menggiuráng wa. ");
INSERT INTO klt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wáina hálendu Judas málám kuk watá kung pris tátáwi yáni yot tu Táwi yan it káungá hánám pinná tátá wa kápángga Jesu wu wáina tángga ku táng sán ket sáni hára tinet ingga yánángga me hároturáng. ");
INSERT INTO klt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wáina yánán ámna urum watá heronge hánám narángga ku sup kaminemán ingga Judas inuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kulá wáina inát tu Judas málám ámna urum watyot pahán káman hálendu hangga kuk. Rám káman no káe ámna náráwa táup pá Jesu yot ma átnándáráng, wahára wu táng yáminet ingga narángga átkuk. ");
INSERT INTO klt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kulá rám Másáng Yisná Muná Nana watá áwáng hen du sipsip nanggená utang singga Angelo yá Iháng Hátiuk wata naráng hátingga sinak tátá watán rám háliuk. ");
INSERT INTO klt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Wáina wata ku Jesu yá Pita káling Jon suring yámángga ing yánuk, “Sándá kungga ku rám táwi watán sungi náni wa tiyawindimálák.” ");
INSERT INTO klt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wáina yánán du watá inumálák, “Sungi wawu rehára rina tiyawinemát ta narelák?” ");
INSERT INTO klt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wáina inán du Jesu yá yánuk, “Sándi wu kung it yáilá wata kinan háinemálák wahára wu ámna káman umi kátang tánggatang áwáng kálu hára sáháng tunggap táinek. Wáina tán du ámna wa isutang kungga watá it reta kinan han du wata kinan yon hangga ku ");
INSERT INTO klt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","it márumá wa ing ininemálák, ‘“No disaepelna yot sungi nangga rám Angelo yá Iháng Hátiuk wata naráng hátinemán wawu it pahálá ku rehára?” ingga Tiksa yá wáina mek.’ ");
INSERT INTO klt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wáina inán du it pahálá táwi káman torong káin átak wakáin du kutná kutná erek tiyawená wa sálen du sungi wa wahára tiyawinemálák.” ");
INSERT INTO klt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wáina yánán du yándi wu kungga káumálák ku kutná kutná wu Jesu yá yánuk wáina hánám re tunggafeng yámán du sungi nangga átnát wa tiyawiumálák. ");
INSERT INTO klt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kulá sungi nanayan rám hálendu Jesu wu aposelná yot tebol hára putung áturáng. ");
INSERT INTO klt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Átang gu Jesu yá yánuk, “Nák ku sányot rám Angelo yá Iháng Hátiuk nahára sungi nanaya kikiná hánám narángngátat. Wa nangga sangga máriya ku wáina sut láwit narinet. ");
INSERT INTO klt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kulá no ing sánin, nák ku sányot rám táwi nátán sungi son ing ma náená áre kungga Ánutu yan átkuku kinan káin rám nátán hulá hánám wa málámbá tán hiták háleinek.” ");
INSERT INTO klt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wáina yánángga málám árong wáin kap tángga átang sáponga tángga sangga ku ing miuk, “Wáin kap ná táng sándá erek naniráng. ");
INSERT INTO klt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","No ing sánin, nák ku son wáin ma náená áre kungga Ánutu yan átkuku watá tunggafeinek.” ");
INSERT INTO klt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wáina yánángga málám másáng káman táng sáponga tángga ulángga yámángga yánuk, “Náwu naya yánumna, sán háláng sásámáya sámindet. Sándá inggon tángga nangga ku nákka naráng hátingguineráng.” ");
INSERT INTO klt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kulá sungi nang hálingga sangga málám kap wáin pálak wa táng wáinanyon tángga ku ing miuk, “Wáin kap náwu Ánutu yá ámna náráwa yot pahán káman háleineráng wata tárákngá. Pahán káman náwu Ánutu yá uláp ámna náráwa yot pahán káman háliuráng wáina muná. Iná nák sipna yá ku pahán káman wa táng tunggap táinek. Nák sipna yá sunggulingga háinek watá ku sán háláng sáminek. ");
INSERT INTO klt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kulá narineráng, káman niyá nák neháng káyam ket yáni hára tinek wawu nákkot nahára tebol hára átamán. ");
INSERT INTO klt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ámna Nanggená wawu uláp Ánutu yá kálu isusut ta miuk wa isutang há kuinek. Iná ámna niyá wa táng káyam ket yáni hára tinek wawu ukuro táwi hánám.” ");
INSERT INTO klt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wáina yánán disaepelná yá yáni inán kanán táuráng, “Niyá hánám bu kálu wáina táinek?” ");
INSERT INTO klt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kulá disaepel yáni wu niyá hánám bu orek yáni hára kutná árená hánám átak ingga yáni yon menmen táuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wáina tángga árát tu Jesu yá yánuk, “Ále kámá káinnan king ingga átnándaráng watá ku yáni ya narát kut yáni árená hálen yáin yáni hánám átnándaráng. Hang meng toling námániráng ingga ket tárák álosim tángngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iná sándá ku wáina ma háleindaráng, ináku káman dá kutna árená hálein ingga wawu nangge kimo yá ina átnek. Hang káman kutná árená átnek wawu sándán yáup nangge háleinek. ");
INSERT INTO klt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kulá ni wu kutná árená yá átnek, káman tebol hára átnek wa, me káman ni yáup nangge ya átang tiriktárák tángga átnek wa? Káman ni kutná árená átnek wawu tebol hára átnek wa, iná nák wawu orek sáni káin yáup nangge watá ina átkoet. ");
INSERT INTO klt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Sán du ingirungngi rina rina nákkán káin áwángga átuk wahára wu nákkot ronrosin áturáng. ");
INSERT INTO klt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nan dá háláng táwi nák namuk, wáinanyon no háláng táwi wa sán sáminet. ");
INSERT INTO klt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wáina sáminet ta ku nákkán átkuku wata kinan nákkán tebol hára átang umi sungi nangga kome álosim hára king gá ina átang Israel yan tombong 12 wa pin yáni tángga átneráng.” ");
INSERT INTO klt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wáina yánángga ku miuk, “Saimon, Saimon, Satan dá áwáng sán sángsárungnginán miuk, wit páliná yá haniráng ingga wit seng hip tángga hirarát árángngátaráng wáinanyon. ");
INSERT INTO klt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wáina hálendu no kákka sáponga há táng kamánggoet, naráng hákhátikka yá ma háindák. Rám ko hurik tángga son áwinelák wahára wu yanuknukka wa iháng káto tángga átnelák.” ");
INSERT INTO klt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jesu yá wáina inán du Saimon dá inuk, “Táwi, nák ku kákkot kungga kalabus kinan hahaya me kákkot kungga kátkámut ta tiyawingga átat.” ");
INSERT INTO klt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wáina inán Jesu yá inuk, “Pita, no ing kanin, kula hurák ká ma mantáená átnek wahára wu rám kaláhu nák ku Jesu ma naráng mát ingga meinelák.” ");
INSERT INTO klt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wáina inángga ku son kámuk yánuk, “No nakán yáup tátáya suring sámut wahára wu sup tumá me yák me sendol kámá ma ihángga kuráng, wahára kutná kutná ya kámá kesák táuráng me muná?” ingga yánán watá muná ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wáina inát tu Jesu yá yánuk, “Kulá nahára ku niyá supmá tumá yá átmán wawu táinek, me yákngá yá átmán wawu hányon táinek. Iná káman ni kápikngá muná hálen wawu lapmá hásák táng tin yuwáng mát tu sup wanyon táng kápikngá káman yuwinek. ");
INSERT INTO klt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Náuta Ánutu yan papia káin ing uyená, ‘Ámna náráwa yá ámna wáik ingga káuráng.’ Wáina mená watá nák hára pálipuk tunggafeindek. Ánutu yan papia káin nákka rina uyená watá pálipuk tunggafeindek.” ");
INSERT INTO klt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wáina yánán disaepel yá Jesu inuráng, “Táwi, kang, kápik yará ná,” ing inát tu Jesu yá yánuk, “Wa rewe álo.” ");
INSERT INTO klt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesu málám hangga ále yáilá Olif káin rám nukngá kungngátak wáinanyon kun disaepelná yá isutang kuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kung hengga ku disaepelná yánuk, “‘Ingirungngi yá nándán káin tunggafen wahára ma pálingga háindámán,’ ingga wata sáponga tángga átneráng.” ");
INSERT INTO klt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wáina yánángga málám yápmangga kung sup káman matne kungga rehára hanggim, ále mulangán ná tárák wáina hára kung tulá hára imángga átang sáponga táuk, ");
INSERT INTO klt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Nan, ka narángga márapmá ná namáng hutang táin ingga wawu álo, enendu ko nákkán pahán ma isutnándalák, ináku kakán pahán isutnelák.” ");
INSERT INTO klt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wáina sáponga tángga árán alek káinnan angelo káman dá hang háláng imuk. ");
INSERT INTO klt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kulá málám sutná wa narán márapmá hánám hálen du sáponga hánghálángngá tángga árán nunggup káto watá rina kámá ingmen utang sip pá ina sárorok káwak káin hangga átuk. ");
INSERT INTO klt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kulá sáponga táng hálingga sangga kungga kápuk ku disaepelná wu pahán márap táwi hánám tángga átkuráng hálendu háláng yáni han há yáni ruhángga árát. ");
INSERT INTO klt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wáina kápángga Jesu yá yánuk, “Náuta ku ruhángga átkoeráng? Tárutang ‘ingirungngi yá nándán káin tunggafen wahára ma pálingga háindámán,’ ingga sáponga tángga átniráng.” ");
INSERT INTO klt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu yá disaepelná yánángga emá me tángga átnárán du ámna urum táwi watá áwáng hiuráng. Judas Jesu málámbán disaepel 12 waháranan watá máta yárengga yángotang áwáng hengga ku Jesu kang kumein ingga rupmá káin áwuk. ");
INSERT INTO klt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wáina áwán du Jesu yá inuk, “Judas, kák ku Ámna Nanggená táng káyam ket yáni hára titiya ku kang kumindelák hám?” ");
INSERT INTO klt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kulá Jesu yan disaepel yá wáina tunggafeindek ingga kangga ku inuráng, “Táwi, nándá kápik ká álo ráhinemán ingga narelák me?” ");
INSERT INTO klt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wáina inángga ku káman dá kápik táng pris yáin yáni yan yáup nangge wata kárámanná álák kálu sating san háuk. ");
INSERT INTO klt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wáina tán kangga Jesu yá inuk, “Wáina ma táindalák!” ingga inángga yáup nangge kárámanná wa táng son komenon ting muk. ");
INSERT INTO klt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wáina tángga ku Jesu málám árong pris tátáwi yáni me Táwi yan it káungá hánám pinná tátáyan yáup ámna me ámna hulá ingga málám ket tátáya áwuráng wa yánuk, “Nák ku tewe ámna tombong káman da máta yáreng yámámá hám, wáina hálendu sándá kápik kot honggem bot ihángga áweráng? ");
INSERT INTO klt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rámá rámá nák ku sáni yot Táwi yan it káungá hánám kumbiná kinan átnándat wahára wu ket ma nehángngátaráng. Iná kula wu sándán rám, páyung gán háláng gá tunggafek.” ");
INSERT INTO klt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wáina yánán du káyam áwuráng watá Jesu ket tánggatang pris yáin yáni yan it káin kuráng. Iná Pita wu yásutang kuk, enendu kimo mulangán sim kungga átkiuk. ");
INSERT INTO klt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pris yáin yáni yan it kumbiná kinan kapme táitná hánám hára wu ámna kámá yá káráp sit ran du wa elengga árát Pita wu kung wahára kámuk yáni putung átkiuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Wáina árán káráp yamá yá Pita hára man du yáup náráwa káman wahára áturáng watá kárek hánám kangga átang miuk, “Ámna náwu Jesu yan tombong waháranan.” ");
INSERT INTO klt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wáina men Pita yá olengga inuk, “Náráwa, ámna wa melák wawu nák ma naráng mát.” ");
INSERT INTO klt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wáina inángga átang sim bu son ámna káman dá kangga miuk, “Kák ku ámna watán tombong háranan.” Ingga inán Pita yá miuk, “Nák muná!” ");
INSERT INTO klt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wáina inángga kimo átang sangga ku ámna káman dá áwáng kangga miuk, “Pálipuk hánám, ámna náwu watyot átningngátak, náuta ámna náwu Galili nan yon.” ");
INSERT INTO klt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wáina men Pita yá miuk, “Ko náuta melák wawu nák ma narát.” Wáina inángga árán du waháranyon hurák ká mantáuk. ");
INSERT INTO klt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kulá wahára re ku Táwi Jesu yá hurik tángga kárek hánám Pita kan du Pita yá Jesu kangga me ing inuk wa naráng hátiuk: “Kula hurák ká ma mantáená átnek hára rám kaláhu nák Jesu ma naráng mát ingga meinelák.” ");
INSERT INTO klt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Málám Jesu yan me wa naráng hátingga ku kep káin kung hangga kandák rina táuk wata narángga kutkáyawát táuk. ");
INSERT INTO klt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kulá ámna Jesu pinná tángga áturáng watá ináng kekkek tángtáng uturáng. ");
INSERT INTO klt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yáni wa ku lap táng rahálá pop táng sat árán du ut táng ut táng gu inánggiuráng, “Kulá niyá nutak ingga profet me meng.” ");
INSERT INTO klt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wáina inángga ku me keke hulá hulá táwi inuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hilápmá it tá háing hang átuk wahára wu ámna hulá hulá watá kámuk ingmen káman hálengga urum táuráng. Urum kinan wahára wu lo yan tiksa me pris tátáwi yáni watá árát tu Jesu engotang urum wahára áwuráng. ");
INSERT INTO klt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wáina engot áwáng sat árán du Jesu ináng suliuráng, “Kulá nánáng, kák ku ámna náráwa son iháhá wa me?” Wáina inát tu Jesu yá yánuk, “Iná no sáninet wawu sándá nákkán me wa narát kusák háleinek. ");
INSERT INTO klt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iná no sánáng sulinet wawu sándá wata topmá ma nanindáráng. ");
INSERT INTO klt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Rám kula átang hulátingga ároinek wakáin du Ámna Nanggená wawu Ánutu Hálángngá Pálak wata ketná álák kálu putung átnek.” ");
INSERT INTO klt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wáina yánán du inuráng, “Wáina wata ku, kák ku Ánutu Nanggená hám?” Wáina inát tu Jesu yá yánuk, “Wawu pálipuk hánám meráng.” ");
INSERT INTO klt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wáina men du ámna hulá hulá watá yáni meme táuráng, “Náuta ku me hulá nukngá met naránin ingga sulinemán? Me wu málámba milunná hánám háranyon há men naremán wa rewe.” ");
INSERT INTO klt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ámna hulá urum táuráng watá kámuk tárutang Jesu engotang Pailat tán káin kuráng ngáyá ");
INSERT INTO klt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","kung táng me hára tinin ingga ing miuráng, “Ámna náwu Israel ámna náráwa yángotang kálu kandák kálu kukuya tángga ing menggoek, ‘Takis Sisa ma imindaráng,’ hang ‘Nák ku king, Ánutu yá ámna náráwaná son iháháya miuk wawu nák,’ ingga menggoek.” ");
INSERT INTO klt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wáina met tu Pailat tá Jesu inuk, “Kák ka Juda yan king me?” Ingga inán du inuk, “Wawu pálipuk wa melák wáina.” ");
INSERT INTO klt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wáina inán du Pailat tá pris tátáwi yáni me ámna náráwa urum táwi wa yánuk, “No ámna ná táng me hára titiyan káluná kámá ma kat.” ");
INSERT INTO klt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wáina yánuk, enendu watá áráng hákhátik tángga miuráng, “Watá Judia ále káwak kámuk káin wa ámna náráwa me hulá hulá yánángga pahán yáni seng tárut tán wáik tánin ingga tánggoeráng. Wa hulátiuk wawu Galili ále káin átang áwángga nákáin.” ");
INSERT INTO klt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wáina inát narángga Pailat tá yánáng suliuk, “Ámna ná wa Galili nan me?” wáina yánáng sulin du ing inuráng, “Wawu pálipuk.” ");
INSERT INTO klt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wáina ingga inát tu Pailat tá naruk ku ámna wawu ále káwak Herot tá pinná táená káinnan hálendu suring yámán Herot tán káin engotang kuráng. Rám wahára wu Herot tu Jerusalem káin wanyon átuk. ");
INSERT INTO klt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot tá Jesu yá rina rina tán met narángngátak, wata ku rám hásák simbon wa kakaya narángga áwángngátak, enendu ma kangngátak. Wáina hálendu Jesu yá áwáng hiuk hára wu kangga heronge naruk. Watá ket tárák kámá tán kakaya narángga wata hálengngátak. ");
INSERT INTO klt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wáina áwáng hen du Herot tá táup hánám ináng suksulik táuk, enendu Jesu yá wata topmá kámá ma inuk. ");
INSERT INTO klt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pris tátáwi yáni yot lo yan tiksa wawu wahára kámuk átang hahatingga átang Jesu táng me hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Wáina tángga sat tu Herot tá tewe ámnaná yot yáni wa ku ináng kekkek tángga lap álosim tawáng mángga son suring yámán engotang Pailat tán káin kuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Uláp pu Herot káling Pailat wawu kámkáyam átkiumálák, iná rám wahára re átang gu nuknuk tángga átang ároumálák. ");
INSERT INTO klt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat tá pris tátáwi yáni kámá yot ámna hulá hulá me ámna náráwa mantán áwát tu yánuk, ");
INSERT INTO klt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Sándá ámna ná engotang nákkán káin áwángga ku ing miuráng, ámna náráwa yángotang kálu kandák kálu kukuya tánggoek ingga miuráng, enendu no sáni yot há átang ináng sulingga káet tu me rina meráng wawu watá wáina kámá ma táuk hálek. ");
INSERT INTO klt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Iná Herot tu wáinanyon kangga ku suring mán nándán káin áwek. Ing narineráng, kandák kámá táuk ka no utkámut tátáya álo ing ma meindát. ");
INSERT INTO klt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Wáina wata ku yáne hánámá lahot mát tu se hangga háná kuinek.” ");
INSERT INTO klt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wáina yánán du kámuk hánám milun yáni káman hálen ing mantáuráng, “Ámna wa utkámut táinelák, iná Barabas wu satá nándán káin áwik!” ");
INSERT INTO klt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas wawu ámna káman kapman tárang káin átnát ta takta narángngátak, wata ku málámbot ámna kátu yá it yáilá kinan káin kun táng hilák tángga ámna káman utkámut tán du wata táng kalabus it kinan tiuráng.) ");
INSERT INTO klt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kulá Pailat tá son, “Jesu sáe kukuya naret,” ingga yánuk, ");
INSERT INTO klt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","enendu kámuk hánám watá ing mantángga áturáng, “Maripong hára kátiti! Maripong hára kátiti!” ");
INSERT INTO klt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wáina mantángga árát tu rám kaláhuná hára ku ing yánuk, “Náuta? Ámna nátá márapmá kámá rina táuk? No ámna nátá márapmá kámá táuk wahára kungga utkámut tátá ingga memeyan káluná kámá ma kat. Wáina wata ku hánámá lahot mángga satne hangga háná kuinek.” ");
INSERT INTO klt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wáina miuk enendu áráng hákhátik tángga ing mantáuráng, “Maripong hára kátiti!” ingga sonson hahatingga mantángga árát watán man watá re Pailat tán me wa hálángngá tángga háuk. ");
INSERT INTO klt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wáina tángga árát tu Pailat tá watán milun isutang gu Jesu yá kámutnek ing miuk. ");
INSERT INTO klt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wáina mengga ámna huphuráp kun táng hilák tángga ámna utkámut tán táng kalabus it kinan tená wa yaling mán kep káin hahaya inuráng wata met wa yaling mán kep káin háuk. Iná Jesu wu watán milun isutang táng tewe ámna ket yáni hára tiuk. ");
INSERT INTO klt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kulá tewe ámna yá Jesu engotang kungga átnárát tu ámna káman it yáilá Sairini nan kutná Saimon watá it yáilá Jerusalem kinan kung háin ingga áwángngárán kangga maripong ná tángga kung ingga inángga ku imát sungga tánggatang Jesu sárummá ya isutang kuk. ");
INSERT INTO klt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wahára wu ámna náráwa táup hánám watá isutang kuráng wata kinan náráwa kámá yá ukuro narángga kutkáyawát pálak isutang kunggarát tu ");
INSERT INTO klt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu yá hurik tángga náráwa kut pálak kuráng wa yánuk, “Jerusalem yáuriwa, nákka ma kut namindaráng, ináku sáni ya kutkut sáni kutneráng, me nángánangge sáni ya kut yámineráng. ");
INSERT INTO klt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Rám káman áwinek wahára ku meineráng, ‘Náráwa nangge ma iháháyan me ma ihená watyot nangge muk ma yámená watá ku heronge táineráng!’ ");
INSERT INTO klt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Rám wahára ku ‘ále yáilá yánineráng, “Hulátang nán ketnán haniráng!” iná ále kandángngá wu yánineráng, “Náháng usáng hang tiniráng!”’ ");
INSERT INTO klt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kulá ámna yá káráp mirak árená hára wáina tángga ku káráp kumkumená hára wu rina tánggalát?” ");
INSERT INTO klt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kulá ámna yará kandák táená wawu Jesu yot ráháng kátkámut tátáya ihángga kuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jesu wu engotang kungga ále káman kutná Yáin Kuratná wahára kung hengga ku táng maripong hára tingga kátiuráng. Ámna yará kandák táená watyot iháng wáinanyon kátiuráng, káman táng ket álák kálu, káman táng ket kandák kálu. ");
INSERT INTO klt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wáina átang gu Jesu yá miuk, “Nan, ko watán kátu wa sáinelák. Rina táeráng wawu ma naráráng.” Iná tewe ámna yá ku lap Jesu yá sutná tánggánená wa horengga iháháya ting sat árán niyá ku resim ihinek ingga kakarák satu táuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iná ámna náráwa yá ku hetang átang kápángga árát ámna yáilá yá ku me keke hulá hulá mengga átkiuráng, “Kámá háláng yámánggoek wáinanyon du sat málámbáyon málám háláng iminek. Pálipuk hánám ámna Ánutu yá ámna náráwa son iháháya táng tunggap táuk hálendu málámbáyon málám háláng iminek.” ");
INSERT INTO klt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iná tewe ámna yá áwuráng ngáyá ku ináng kekkek tángga wáin ingirángngá imuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wáina tángga ku inuráng, “Pálipuk kák ku Juda yan king hálendu kayon ka háláng iminelák.” ");
INSERT INTO klt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kulá ámna kámá yá me káman uyiuráng wa táng Jesu yáilá torong hára káting sat átuk wawu ing: Náwu Juda yan King. ");
INSERT INTO klt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ámna kandák táená yará iháng káting sat átumálák waháranan káman dá Jesu ináng kekkek tángga ku ing ináng sengga átkiuk, “Kák ku Ánutu yá ámna náráwaná son iháháya miuk wa hám, wata ku ko kayon ka háláng imángga ku nátyot háláng námáng!” ");
INSERT INTO klt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wáina inán du nukngá watá me táng mángga ku ing inuk, “Kák ku ámna watá márapmá suwek wáinanyon suwelák, enendu kák ku Ánutu ya ma hám pitáng málák? ");
INSERT INTO klt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nát náráháng kátkámut táinderáng wawu kándáng re há hálek, náuta nátá márapmá suwemát wawu kandák táumát wata tárákngá hára álo. Iná ámna náwu kandák kámá ma táuk.” ");
INSERT INTO klt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wáina mengga ku ing miuk, “Jesu, ko átnát ya káin kung king hálengga átang gu nákka narinelák.” ");
INSERT INTO klt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wáina inán Jesu yá inuk, “No pálipuk hánám ing kanin, kula wu kák ku nákkot átnát álosim káin átnemát.” ");
INSERT INTO klt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Rám bá 12 kilok hálengga árán káe yamá watá sálikngin du ále watá páyung tingga káwak usángga árán kungga 3 kilok háliuk. Iná Táwi yan it káungá hánám kinan lap hásák táwi watá ku táitná háng ráráhángga yará háliuk. ");
INSERT INTO klt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kulá wahára ku Jesu yá hahatingga ingmen mantángga ing miuk, “Nan, no irukna táng kák ketya hára tet.” Wáina mengga ku pukon árong sun háuk. ");
INSERT INTO klt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wáina tán kangga tewe ámna yáin yáni watá Ánutu kutná meng tárut tángga ing miuk, “Pálipuk hánám ámna náwu ámna kándáng.” ");
INSERT INTO klt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wáina kangga ámna náráwa rahán da kákápáya áwuráng watá rina tunggafiuk wa kangga pahán yáni yá káto hálen tungturing há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iná náráwa nini yá Galili kálu Jesu isutang áwuráng watyot kámá ni Jesu naráng meráng watá ku kung mulangán káin átang rina tunggafiuk wa kangga áturáng. ");
INSERT INTO klt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kulá ámna káman Judia yan it kutná Arimatea wakáinnan kutná Josep wawu ámna álo kámá kándáng re átkungngátak. Ámna wawu Ánutu yan átkuku wata hálengga átnándak. Iná málám wawu kaunsol. Ámna watá ku kaunsol nuknukngá watá Jesu utkámut tátáya nanará tiuráng wata narán kándáng ma háliuk. ");
INSERT INTO klt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ámna watá Pailat tán káin kuk watá kung “Jesu yan káwak sut wa álo tángga kuinet me?” ingga inuk. Wáina inán álo ing men du ");
INSERT INTO klt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","málám wa táng hang lap álosim bá pondang táng kung tanggán sup hinangngá káling tolená káman uláp káwak sut káman táng wahára ma tiuráng wahára táng tiuk. ");
INSERT INTO klt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iná Sabat tu há áwáng hálingga átuk, wata ku rám wawu Sabat ta tiktiyawik tátá rámá. ");
INSERT INTO klt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kulá náráwa Jesu yot Galili kálu áwuráng watá ku Josep isutang kungga sup hinangngá rehára káwak sut wa táng tiuk wa káuráng. ");
INSERT INTO klt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yáni wu rina rina wa kangga sangga ku it yáni ya kuráng ngáyá kung oel me kuram mungngan yáni kikiná wa tiyawiuráng. Iná Sabat hára wu meng rákit mená yá rina rina ma tátáya mek wáina wata ku sek naruráng. ");
INSERT INTO klt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sonda ore nukngá ya hulátitiná hára ku hilápmá hánám náráwa watá yon kuram mungngan yáni kikiná tiyawingga tiuráng wa ihángga tanggán káin kuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yáni wu kungga káuráng gu sup táwi sup hinangngá pop táená wawu ni kámá yá kiwolán kung kep káin árán. ");
INSERT INTO klt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wáina hálendu kuráng watá re kungga kinan hangga káuráng gu Táwi Jesu yan káwak sut wawu wakáin ma árán. ");
INSERT INTO klt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wáina kangga wata narángpak tángga átnárát tu ámna yará sut yándi tánggánená wawu hakokowak hánám bá ku sireretná pálak watá kandáng yáni kálu hetang átumálák. ");
INSERT INTO klt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wáina árán kápángga yáni wu pikpito hánám wa narángga tun yáni hára imángga kurák mátap yáni iháng hang káwak káin tit ámna yará watá yánumálák, “Náuta ku sándá ámna átkukuná pálak wata kámurená orek yáni káin ná sulingga átninggoeráng? ");
INSERT INTO klt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wawu nahára ma árak, ináku há tárutak! Málámbá sáni yot Galili káin áturáng wahára me ing sánuk wa naráng hátineráng, ");
INSERT INTO klt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ámna Nanggená wawu táng kung ámna mukmuro táená wata ket yáni hára tit, watá táng maripong hára kátineráng, enendu rám kaláhu átang gu son tárutnek.’” ");
INSERT INTO klt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wáina yánán du me rina Jesu yá yánuk wa naráng hátiuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kulá náráwa yáni wu tanggán wa sangga kuráng watá kung disaepel 11 watyot nini yá áturáng wa yánuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Náráwa wawu Maria it Makdala nan wa, Joana, hang Maria Jeims maming watyot tu náráwa kámá watá áwáng gu aposel yánuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Áwáng pingnga wa yánuráng, enendu watá watán me wawu kusák hánámá iruk me ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iná Pita yá ku tárutang málám hururung ingmen tanggán káin wa kung turingga hangga kápuk ku lap kuliná watá re árát kápángga ku rina ingga narángpak tángtáng hangga háná kuk. ");
INSERT INTO klt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Káe waháranyon du disaepel yará yándi wu it kutná Emeus wakáin kundin ingga kumálák, iná it wawu Jerusalem sangga 11 kilomita wáina kungngátaráng. ");
INSERT INTO klt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yándi wu kálu wa kungga átkiumálák wawu Jerusalem káin rina tunggafiuk wata mená tángga yándi inán kanán tángga kungga átkiumálák. ");
INSERT INTO klt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wáina tángga kungga árán du Jesu málámbá wahára áwán káman yáni kuráng, ");
INSERT INTO klt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","enendu yándi wu náut kámá yá rahán yándi wa ting suwán wawu Jesu ingga ma káumálák. ");
INSERT INTO klt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Wáina áwán kámuk yáni kungga átang gu yánáng suliuk, “Sándu náut mená tángga áwángga átkoemálák?” Wáina yánán du yándi wu tareng kátingga kurák mátap yándi yá ukuro hálen átumálák. ");
INSERT INTO klt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wáina átang gu káman kutná Kliopas watá inuk, “Jerusalem káin lombu táwi hánám áwáng átaráng. Waháranan du ko káman dá re ku rám nahára rina tunggafengga átak wawu ma hám narálák?” ");
INSERT INTO klt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wáina inán du Jesu yá yánuk, “Náutá rina tunggafengga átak?” ing men du watá inumálák, “Jesu Nasaret nan wawu profet káman Ánutu rahálá hára me ámna náráwa rahán yáni hára mená menggoek me ket tárák tánggoek wawu hálángngá pálak, nát tu wata menggoemát. ");
INSERT INTO klt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pris tátáwi yáni me nándán ámna hulá ingga átaráng watá táng kapman ketná hára tit, watá kámutnek ingga men du táng maripong hára kátit kámutuk. ");
INSERT INTO klt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Huphuráp pu nándu watá ku Israel ámna náráwa son ihinek ingga naránggiumán. Iná káman du ing, Jesu wa uturáng wawu káe kula árátne ku rám kaláhu hálek. ");
INSERT INTO klt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kulá waháranyon du náni háranan náráwa kámá hilápmá hánám tanggán káin kungga sangga áwáng gu náháng hárámut táeráng wawu ing, ");
INSERT INTO klt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tanggán káin wa káeráng gu Jesu yan káwak sut wawu ma árán. Wakáin du angelo yá re árán kápángngárát tu Jesu wu há tárutnáráng mirak átak ingga yánemálák ka náneráng. ");
INSERT INTO klt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wáina narángga náni háranan yará yá tanggán káin kungga káemálák ku pálipuk náráwa yá meráng wáina, iná Jesu málám bu kámá ma kamálák.” ");
INSERT INTO klt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wáina men du Jesu yá yánuk, “Nanará sándi muná, profet tán me wa há narángngátamálák, enendu naráng hákhátik sándi wu isikimo. ");
INSERT INTO klt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ámna náráwa son iháháya háuk wawu márapmá wa suwinek ka ku Ánutu yá kut táwi hánám iminek wáina wa naremálák me muná?” ");
INSERT INTO klt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kulá wáina yánángga ku Moses hára átang hulátingga árongga profet kámuk kán káin málámba rina mená miti papia káin átak wa erek yánáng tolingga kuk. ");
INSERT INTO klt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wa yángyánáng kungga ku it átnát ta kumálák wata tangtang kung hengga ku Jesu yá it wa táng hátingga kuin ingga táuk. ");
INSERT INTO klt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wáina tán ámna yará watá ma kuindalák ingga oletná mangga inumálák, “It tá yonyon hálengga páyung tindek, wata ku nátyot átang tembát tu wáina kuinelák,” ingga inán du watyot it kinan háuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hang tebol hára putung átang másáng táng sáponga tángga ulángga yámuk. ");
INSERT INTO klt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wáina tán du naráng hátingga rahán yándi yá ruwarán du wahára re pikpiliuk. ");
INSERT INTO klt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wáina kun du yándi meme táumálák, “Pálipuk hánám kálu káin Ánutu yan me wa hulá yot mengga nánáng tolingga áwek hára pahán náti yá táwi hánám tárutak.” ");
INSERT INTO klt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wáina tángga ku yándi wu tárutang Jerusalem káin son kumálák. Kung disaepel 11 wa kápángga kámá watyot áturáng watyot káman átang gu ");
INSERT INTO klt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ámna yará wa ing yánuráng, “Wawu pálipuk hánám! Táwi wu há tárutang kungga Saimon dán káin tunggafek.” ");
INSERT INTO klt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wáina yánát tu ámna yará watá ku kálu káin tunggafeng yámuk me másáng ulángga yámán kangga naráng hátiumálák wata yánumálák. ");
INSERT INTO klt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wáina yánángga wata mená tángga átnárát tu Jesu málámbá orek yáni hára wa hetang átang yánuk, “Pahán láláp pá sányot átnek.” ");
INSERT INTO klt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wáina yánuk, enendu disaepel urum áturáng watá kangga hárámutang náwu utni káemán ingga pikpito naruráng. ");
INSERT INTO klt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wáina kápángga ku yánuk, “Náuta hárámutang gu nanará sáni káin wa nangnaráng táeráng? ");
INSERT INTO klt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ketna me háramna ná kaniráng. Pálipuk náwu na! Nehánggangga narániráng. Utni wu yánum yáni me kurat yáni nák hára átak wáina muná.” ");
INSERT INTO klt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesu málám wáina yánángga ku ket hárammá káin párángngá wa yáliuk. ");
INSERT INTO klt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wáina yálen kangga heronge táuráng, enendu wa narát kándáng ma hálen narángpak yáni watá emá re há átuk. Wáina kápángga ku yánuk, “Sán náut kámá kámá nanayan nahára teráng ngá kámá átak me muná?” ");
INSERT INTO klt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ingga yánán du yáni wu káut kátu singga tená wa táng imát tu ");
INSERT INTO klt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","rahán yáni hára náuk. ");
INSERT INTO klt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wa nangga ku yánuk, “Náwu no sáni yot átang rina tunggafeinek ka há sánut wáina. Me rina nákka Moses yan meng rákit me káin, profet tán papia káin me Kap Papia káin uyená wata páliná yá tunggafek.” ");
INSERT INTO klt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wáina yánángga ku nanará yáni yan káluná wa yalin du Ánutu yan me rina uyená wa naráng hátiuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wáina tángga ku ing yánuk, “Náwu ing uyená wa: Ámna náráwa son iháhá wawu márapmá sungga kámutang rám kaláhu átang gu son tárutnek. ");
INSERT INTO klt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wata ku pahán hurik tángga watán káin kut tu Táwi yá mukmuro sáni yawonek ingga Jerusalem hára átang hulátingga wata kutná hára mengga meng isurát kungga káwakngá káwakngá kámuk kuinek. ");
INSERT INTO klt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iná sándu sáni rahán sáni yá há káeráng, wata ku wa meng isurát kuinek. ");
INSERT INTO klt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","No ku náut Nanna yá sásámáya miuk wa se áwáng sáminek, iná sándu it yáilá hára ná re árát kungga ku alek káinnan háláng watá hang sáháng támotnek.” ");
INSERT INTO klt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kulá Jesu málám disaepelná yángot kung it Betani tangtang káin átang gu ketná iháng hip tángga átang disaepelná kuram táng yámuk. ");
INSERT INTO klt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kuram táng yámángga átnárán waháranyon du Ánutu yá tángga alek káin árángga kuk. ");
INSERT INTO klt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesu yá yápmangga kun du yáni wu ináng sákngingga sangga ku heronge pálak Jerusalem káin son kuráng. ");
INSERT INTO klt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kung rámá rámá Táwi yan it káungá hánám wata kapmená hára átang Ánutu kutná meng tárut tángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilas, no papia huphuráp uying kamut wawu Jesu yá hulátingga yáup rina rina táuk me rina yánáng toliuk wahára átang áwángga áwáng ");
INSERT INTO klt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","rám Ánutu yá tángga alek káin kuk watán me pingnga wa erek hánám uyiut. Jesu yá alek káin manyon koená átang aposel iháng tunggap táuk wa yáup wáina wáina há táineráng ingga Iruk Káungá yan háláng hára yánuk. ");
INSERT INTO klt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Málámbá sut láwit naruk wata torong káin du rina táe ku aposelna yá pálipuk son tárutut ingga nahániráng ingga watán káin tunggafengga rám táup pon tárák hulá hulá tángga málám yálenggiuk. Wáina tángga rám 40 wata kinan du aposelná yan káin tunggafengga Ánutu yan átkuku wata yánánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Rám káman aposelná yot átang gu yánuk, “Jerusalem sangga ma kuindaráng, ináku nahára átang hálengga árongga árát Nanna yá náut há hánám sásámáya miuk wata no sáne naruráng wa sáminek. ");
INSERT INTO klt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon dá ku umi yá kuháng yámánggiuk, iná rám hátetná kimo átang gu Ánutu yá ku Iruk Káungá yá kuháng sáminek.” ");
INSERT INTO klt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kulá Jesu yá aposelná yot háwuru tángga átang gu inuráng, “Táwi, uláp Israel yá kutná pálak átang káto hánám hálengga átkiuk wáinanyon rám nahára ko tátá wáinanyon son álo átgim me?” ");
INSERT INTO klt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wáina inát tu watá yánuk, “Rám wáina wa, wawu Nanna yá málámbán háláng wahára kungga tiuk, wata ku sándá nanaráyan tárák ku muná. ");
INSERT INTO klt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iná sándu Iruk Káungá watá áwáng ep sáhán watán háláng há táineráng, wata ku sándá Jerusalem hára ná, me ále Judia kámuk, me ále Samaria hang káwakngá káwakngá káin erek hánám rina kanggoeráng me naránggoeráng wa yánáng tolingga kuineráng.” ");
INSERT INTO klt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesu yá me wa yánáng hálin du rahán yáni hára Ánutu yá tán du árángga mukam kinan kungga alek káin kun ma káuráng. ");
INSERT INTO klt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Árángga kun yáni wu alek kálu re kárek hánám hálengga átnárát tu ámna yará lap yándi haknga re tánggánená watá tunggafengga káman yáni wahára átang gu ");
INSERT INTO klt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","yánumálák, “Galili ámna, náuta ku nahára átang alek kálu re hálengga átkoeráng? Jesu wa, wawu Ánutu yá kula tán du alek kinan káin sápmangga kun káeráng wawu son áwinek. Alek kinan káin rina árángga kun káeráng tárák wáinanyon son áwinek.” ");
INSERT INTO klt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wáina yánán du aposel yáni wu ále yáilá Olif wa sangga Jerusalem káin kuráng. Jerusalem wawu mulangán muná ináku enanggon. ");
INSERT INTO klt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","It yáilá káin kung hengga ku áráng it pahálá torong káin yáni átnándaráng wakáin áturáng. Ámna wahára áráng áturáng wawu Pita, Jon, Jeims, Endru, Filip, Tomas, Batolomiu, Matyu, Jeims Alfius nanggená, Saimon tombong Selot háranan, hang Judas Jeims nanggená. ");
INSERT INTO klt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ámna urum watá ku rámá rámá pahán káman hálen urum átang sáponga tángga átkiuráng. Rám wahára wu náráwa kámá hányon áturáng, hang Maria Jesu maming me Jesu yakukula watyot kámuk átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Rám ore wahára ku ámna náráwa ni Jesu ya naráng háting mená wata sale yáni wu ále 120 náut wáina watá árát tu orek yáni hára Pita yá tárutang gu ing miuk, ");
INSERT INTO klt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Yanuknuk, uláp Iruk Káungá watá Dewit milunná hára me meng tunggap táuk. Kulá me wawu Táwi yan papia hára ing uyená átnándak, wawu Judas ya miuk. Ámna watá ku kálu yálen Jesu táng káyam ket yáni hára tineráng ingga miuk. Kulá me wata páliná yá ku há tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Huphuráp Judas wawu nánin tombong gon átkiuk, iná yáupmá ku náni tánggoemán wáinanyon tánggiuk,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas wawu kálu kandák táuk wata yumnakngá sup ihuk watá ku káwak káman yuwuk. Rám kámá átang gu málám káwak wahára táng hang kátingga kawilá yá hiláksin du kámun pahálá yá kámuk ingmen sunggulingga áwáng kep káin háuráng. ");
INSERT INTO klt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wáina tán du Jerusalem kinan ámna náráwa áturáng watá pingnganá wa narángga ku káwak wata kutná ku yánin me kálu Akeldama ing miuráng. Kut wata hulá ku Káwak Sip Pálak. ");
INSERT INTO klt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita yá ing hányon miuk, “Kap Papia hára Dewit tá Judas ya ing mengga uyiuk, ‘Watán tum kome watá hánámá átnek, káman dá watán tum kome hára ma átnándak,’ hang wata kátu yon ing uyená yá átak, ‘Nukngá yá watán yáup komená wa álo táinek.’ ");
INSERT INTO klt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Wáina wata ku álo kámá ku ámna káman orek náni háranan táng tunggap táinemán. Ámna wawu ing táená kangga, hulátingga Jon dá umi kuháng yámuk wahára átang árongga Jesu yá alek káin kuk wahára Táwi Jesu yot átninggiumán waháranan káman. Ámna wáina watá ku rahálá yá há káuk, wata ku nán háláng námángga Jesu yá tárutuk wata meng isurán kungguinek.” ");
INSERT INTO klt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita yá wáina men du ámna yará ná háranan káman dá átgim ingga miuráng, ámna káman du Josep kutná nukngá Barsabas hang kutná nukngá Jastus, hang ámna káman du Matias. ");
INSERT INTO klt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Wáina tángga ku sáponga tángga Táwi ing inuráng, “Táwi, ko ámna kámuk ka pahán yáni wa há káelák, wata ku ko ámna yará ná háranan du ni ámna yá ku Judas yan kome tángga aposel yáup wa táinek ka táng tunggap táet ingga álo nálenggim me? Judas yá yáupmá wa sangga márapmá táuk wata tárákngá isutang átnát ná rekáin átak wakáin há kuk.” ");
INSERT INTO klt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wáina inángga ku Ánutu yá ni táng tunggap táinek ingga sup hirarát kun du Matias yan sup watá kung kándáng átuk, wata ku Matias táng aposel 11 watyot tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kulá Juda yan rám táwi kutná Pentikos watá tunggafiuk hára wu ámna náráwa Jesu ya naráng háting mená watá kámuk hánám káman hára re urum árát, ");
INSERT INTO klt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","waháranyon du narángngárát iruk yatná yá iruk táwi tángga hásingngátak wáinanyon alek kálu hangga wata timtáummá watá re it pahálá putung áturáng wata kinan táwi hánám tángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wáina tán narángga kangngárát tu káráp lánggop ina watá tunggafengga ku ámna nangge elák yáni ina watá ku horengga kung káman káman yáin yáni ketnán áturáng. ");
INSERT INTO klt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wáina tát tu yáni wu Iruk Káungá watá kámuk ep ihán du watán háláng hára me hulá hulá metángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kulá rám wahára wu Juda kámá Ánutu ya naráng háting mángngátaráng, wawu káwakngá káwakngá káin árená watá áwáng Jerusalem káin áturáng. ");
INSERT INTO klt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iruk maming tái yatná ina wa narángga ku ámna náráwa táup táwi watá áwáng urum tángga átang naruráng gu yánin me káman káman kálu metát narángga ku hárámutang wa nangnaráng tángga ");
INSERT INTO klt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","nangnga yáni han du miuráng, “Ámna náráwa náwu Galili nan rewe, ");
INSERT INTO klt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","enendu rina tángga ku nán átamán watá ku náni káman káman dá nánin me kálu hánám me metát naránggoemán? ");
INSERT INTO klt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nán du káwak wakáinnan wakáinnan dá áwená. Nán du káwak Patia, Midia, me Elam, me Mesopotemia ále, me Judia ále, me provins Kapadosia, Pontus me Esia káinnan dá áwumán. ");
INSERT INTO klt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Me nán du distrik Frigia me Pamfilia, me káwak Isip, me ále Libia kátu it yáilá Sairini tangtang wakáinnan dá áwumán. Me nán Juda me kámá káinnan Juda yan naráng hákhátik isurená Rom káwak káin árená, me ailan Krit me ále Arebia wakáinnan dá áwumán. Nán du káwak wakáinnan wakáinnan dá áwená, enendu watá me metát naremán wawu Ánutu yá yáup maming táwi hánám táuk wata náni káman káman dá nánin me kálu hánám met naremán!” ");
INSERT INTO klt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wáina met tu kámuk hárámutang wa nangnaráng tángga ku yáni inán kanán ing táuráng, “Náwu rina hánám tunggafenggoek?” ");
INSERT INTO klt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iná kámá yá ku wata mengga táng suksuk tángga ku ing miuráng, “Wawa wáin táwi hánám hám náeráng hálendu watá ku wáina tángga átaráng.” ");
INSERT INTO klt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wáina met tu Pita yá ku aposel 11 watyot tárutang gu san táng hip tángga hahatingga urum táwi áturáng wa me ing yánuk, “Yanuknukna Juda me ámna náráwa kámuk Jerusalem hára átaráng sándu, kándáng kárámatingga nákkán me ná narángga ku náut nahára káeráng wata hulá ya narineráng. ");
INSERT INTO klt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sándá ámna náráwa náwu umi káto nangga hohingga wáina táeráng ingga meráng, enendu wáina muná. Inggálu ku emá hilápmá 9 kilok hálek. Rám wáina hára ámna yá sipak ma tángngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wa meráng wáina muná, ináku ná tunggafek náwu huphuráp profet Joel yá ing miuk wa, ");
INSERT INTO klt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ánutu yá ing mek, “Rám bá sálikngingga árán du no Irukna wa suring me ámna náráwa kámuk kán káin han nángánangge sáni me yáuriwa sáni yá nákkán me wawu profet tá ina mengguineráng. Ámna máto sáni yá tárák ára ina kápát tu ámna tátáwi sáni yá ára kangguineráng. ");
INSERT INTO klt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yáup nangge me yáup náráwa na hánámá yáup táená, enendu rám wahára wu no Irukna wa hányon suring me watán káin han nákkán me wa profet tá ina mengguineráng. ");
INSERT INTO klt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","No me hulá kámá watá alek káin ánu tunggafen, káwak káin ámu wu tárák hulá kámá yá tunggafen du rám bu wa ingga narineráng. Sip me káráp lánggop me towet maming tái watá tunggafeineráng. ");
INSERT INTO klt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Káe yá hurik tángga páyung tin du yap pá hurik tángga sip ina háleinek. Wáina tát sálikngin du Táwi yan rám háleinek, wahára wu Táwi yá yamá me hálángngá watyot áwinek. ");
INSERT INTO klt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kulá nini Táwi yá háláng yámámáya inineráng watá ku son há ihán álo átneráng.”’ Joel yá profet me wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel ámna náráwa, kárámatingga nákkán me ná narineráng. Sáni há nareráng wa, Jesu Nasaret nan wawu Ánutu málámbá háláng imán ket tárák hulá hulá hálángngá pálak sáni yot átang tánggiuk wawu wáina tán du sándá kangga Ánutu málámbá suring mán áwuk ingga kangga nanaráya tánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kulá Ánutu yá yon du táng sán ket sáni hára tiuk wawu uláp wáina táinet ingga há naruk wa isutang wáina táuk. Wáina tán ámna wáik watá háláng sámát tu maripong hára tingga piring gá kátit tu kámutuk. ");
INSERT INTO klt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Enendu Ánutu yá ámna wa kátkámut tán háláng waháranan imáng hutang tángga táng tárut táuk, náuta kátkámut tán háláng watá wa káto tángga átnát tán tárák muná. ");
INSERT INTO klt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","King Dewit tá wata ing miuk, ‘No káet tu Táwi yá rámá rámá nák tangtang hánám átkoek. Watá háláng nanamáya naya tangtang hánám átkoek wata ku náut kámá yá neháng kongkong tán ma háindát. ");
INSERT INTO klt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wáina wata ku pahánna yá álosim hálen milunna yá heronge táet. Táwi yá káwak sutna táng álolo táinek wata hálengga átkoet, ");
INSERT INTO klt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","wawu satá no kámurená yan ále káin ma átnándát, hang ko ámna rongrongngá hánám nangán ingga narelák wa satá ma pálikngindat. ");
INSERT INTO klt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ko kálu kungga átkuku tátáyan wa há naliulák. Ko rámá rámá nákkot árátá no heronge hánám átnet.’ Dewit tá me wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Yanuknukna, no pálipuk hánám há naret wa, ing sánin, pem náni Dewit wawu há kámurán usuráng, hang tanggálá wawu Jerusalem hára ná há átak. ");
INSERT INTO klt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iná Dewit wawu profet hálendu há narek Ánutu yá pálipuk hánám ing inuk, ‘Máriya ku kák kinan nan káman dá king kák inanyon átnek.’ ");
INSERT INTO klt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dewit tá máriya rina tunggafeinek wa kangga ku Jesu Son Iháhá yá tárutnek wata ing miuk, ‘Kámurená yan ále káin ma átnándák me ma pálikngindák.’ ");
INSERT INTO klt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ánutu yá Jesu wawu há táng tárut tán mirak átak. Nándu náni rahán náni yá há kangga ku wata menggoemán. ");
INSERT INTO klt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iná Jesu wawu há árángga kungga Ánutu ketná álák kálu átak. Wáina átang gu Nan dá Iruk Káungá imámáya miuk wa ketná hára há tángga ku suring mán háek ngá ku há kangga nareráng wa. ");
INSERT INTO klt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kulá Dewit tá alek káin kuk wawu Jesu yá kuk wáinanyon muná, wata ku nándá ing narángguinemán, Dewit tá me ing miuk wawu málámba ma miuk, ináku nukngá ya miuk, ‘Táwi Ánutu yá Táwina ing inuk, “Ketna álák kálu putung árátá kungga ");
INSERT INTO klt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","no káyamya wa ráhángga iháng hang ting se árát ko wa iháng hátingga átnelák.”’ ");
INSERT INTO klt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Dewit tá wáina miuk, wata ku Israel sándá ku náwu pálipuk hánám ing narineráng, ámna Jesu sándá táng maripong hára kátiuráng wawu Ánutu yá táng Táwi átnát ta táng tunggap táuk, hang táng málámbán ámna náráwa son iháháyan ting san átak.” ");
INSERT INTO klt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita yá me wa men narángga ku ámna náráwa yá pahán yáni yángen du Pita yot aposel kátu wa yánuráng, “Yanuknuk, rina táinemán?” ");
INSERT INTO klt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wáina yánát tu Pita yá yánuk, “Sán kámuk hánám pahán sáni hurik tángga ku Jesu ámna náráwa son iháhá kutná hára umi kuhát tu Ánutu yá mukmuro sáni yawondang gu Iruk Káungá wa sáminek. ");
INSERT INTO klt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ánutu yá Iruk Káungá sásámáya miuk wawu sán me nángánangge sáni me kámá ni mulangán átaráng wa kámuk sáminek. Táwi Ánutu náni yá ni ámna náráwa mantáng yáminek, wawu uláp Iruk Káungá yámámáya miuk wa kámuk yáminek.” ");
INSERT INTO klt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wáina yánángga ku me kámá táup pon pahálá yot yánángga ing yánuk, “Kándáng hánám háleng rákit tángga átneráng, rám nátán ámna mukmuro watyot márapmá ihánirot.” ");
INSERT INTO klt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kulá Pita yá me wa yánán watán me watá ámna náráwa táup hánám wa ihánggápán du áwáng umi kuhuráng. Rám wahára ámna náráwa sale yáni 3,000 náut wáina tá pahán hurik tángga áwáng Jesu yan tombong háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ámna náráwa yá káman háhále, me aposel yan me wa nanará, me áwáng urum tángga sungi nana, hang sáponga tátá wata káto hálengga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Wáina tángga árát Ánutu yá aposel ket yáni hára tárák táup hánám wáina tán ámna náráwa niyá wa kápuráng watá hárámutang pitáuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ámna náráwa Jesu ya naráng háting mená watá pahán káman re hánám átang kutná kutná yáni wa kat kámuk yáni yan háliuk. ");
INSERT INTO klt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yáni wu káwak me kutná kutná yáni kámá wa iháng yumnak tángga sup ihángga ku iháng káman niyá náuta kesák tán wa imánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rámá rámá wu Táwi yan it káungá hánám wata kumbiná kinan urum tánggiuráng. Pahán yáni wu álosim hánám árán heronge hára kámá yan it káin kungkung tángga sungi nangnang tángga átninggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Táwi kutná meng tárut tángga átkut tu ámna náráwa kámá yá ku kápángga pahán álosim naráng yámánggiuráng. Rámá rámá wu Táwi yá ámna náráwa kámá yot ihán du Jesu ya naráng háting mená wata sale yáni yá wu táwi hánám hálenggiuk. ");
INSERT INTO klt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","3 kilok wawu sáponga tátáyan rám, wata ku rám káman yonyon kálu 3 kilok hálengga árán du Pita káling Jon dá sáponga tátáya Táwi yan it káungá hánám káin árángga kumálák. ");
INSERT INTO klt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kungga káumálák ku waháranyon ámna káman mam kinan átang hárammá wu wáik hálená tunggafiuk wa tángga it káungá kumbi kálu mungnganá kutná ku Álosim Hánám wahára áwuráng. Rámá rámá wawu wáina re táng áwáng wahára sat átang ámna náráwa yá it káungá kumbiná kinan hangngátaráng hára sup pa yánángga re átnándak. ");
INSERT INTO klt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Málám kápuk ku Pita káling Jon dá kung háinán tán du kápángga ku sup kámá namándimálák ingga sonson yánuk. ");
INSERT INTO klt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wáina yánán du yándi wu kárek hánám hálengga kangga ku Pita yá inuk, “Nát náháng!” ");
INSERT INTO klt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wáina inán du ámna watá kápángga ku sup kámá há hám namindemálák ingga naruk. ");
INSERT INTO klt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wáina narángga kápángngárán Pita yá inuk, “Sup silva me gol wawu nákkán káin ma árak, ináku náut nákkán káin átak wa kamindet. Jesu Nasaret nan ámna náráwa son iháhá wata kutná hára ing kanin, tárutang tarengga kung.” ");
INSERT INTO klt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wáina inángga ku ketná álák kálu tángga háláng imán tárurán du waháranyon kándumá yot hárammá sárummá watá álo háliumálák. ");
INSERT INTO klt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wáina tán du málám hiring árángga hangga ku tarengga kung áwáng táuk. Wáina tángga ku málám káman yáni kung it káungá kumbiná wata kinan hangga ku kung áwáng tángga hiring hiring tángga Ánutu kutná meng tárut tángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Wáina tán kangga ámna náráwa yá ámna wawu it káungá kumbiná kálu mungnganá kutná ku Álosim Hánám wahára átang sup pa nánángga átnándak wa ingga kangga há naráng hátiuráng. Wáina hálendu yáni wu rina tángga álo hálek ingga ikik hárámutang nangnga yáni háuk. ");
INSERT INTO klt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ámna náráwa yá ámna wa kangga hárámutang hururung áwángga káuráng gu ámna wawu Táwi yan it káungá kumbiná kinan wata parandaná kutná Solomon dán paranda hára Pita káling Jon pengga ihángga árán. ");
INSERT INTO klt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wáina tát kápángga ku Pita yá yánuk, “Israel ámna náráwa, náuta ku tárák wa kangga hárámutaráng? Me náuta ku káto náhánggoeráng? Tárák ná kangga yándin háláng hára wáina táemálák, me Ánutu rahálá hára kándáng átnándamálák wata ku ámna ná táng tárut tán tarengga kung áwáng táek ingga ma narindaráng. ");
INSERT INTO klt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak, Jekop hang táwi ilom náni yan Ánutu watá yáup nanggená Jesu wa kut táwi imuk, enendu sándá ámna wa táng káyam ket yáni hára tiuráng. Pailat tá san háná kukuya miuk, enendu sándá Pailat rahálá hára nándán king muná ingga mengga utkámut tátáya miuráng. ");
INSERT INTO klt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ámna wawu rongrongngá kándáng hánám, enendu sándá wa sárum imángga ku Pailat ing inuráng, ‘Ámna ráháng kátkámut táená wa satá háná kuik,’ ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ámna nángot kung átkuku nánámá wawu utkámut táuráng wa, enendu Ánutu yá son táng tárut táuk ngá ku nát tu rahán náti yá há káumát hálendu wata sán sánánggoemát. ");
INSERT INTO klt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ámna náwu huphuráp pu hárammá wáik átkiuk ngá sáni há naráng meráng wa, enendu nán du Jesu ya naráng háting mángngátamán wata ku Jesu kutná háranyon du nátá táte wa álo hálek. Jesu málámbá yon naráng hákhátik náni wa táng káto táng námán du naráng hákhátik watá yon du ámna ná pukon hánám táng tolin álo hálengga wa árán káeráng wa. ");
INSERT INTO klt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yanuknukna, no pálipuk ing há naret, sán me ámna hulá hulá sáni yot wa táuráng wawu wáina ingga ma narená táuráng. ");
INSERT INTO klt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Enendu wawu Ánutu yá uláp wáina há tunggafeinek ingga miuk wata ku sándá wa táuráng. Profet tá ing miuráng, ámna náráwa son iháhá wawu láwit táwi narinek ing miuráng wata ku wa tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wata ku nanará sáni kandák wa táng tolingga ku pahán sáni hurik tát tu Ánutu yá mukmuro sáni wa yawon sáminek. Wáina tát tu Ánutu yá háláng sámángga sáháng káto tángga ");
INSERT INTO klt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ámna náráwa son iháháya táng tunggap táuk, Jesu wa suring mán sándán káin son áwinek. ");
INSERT INTO klt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesu wawu alek káin árán kungga Ánutu yá kutná kutná kámuk hánám iháng tolin son kándáng hálet tu wahára ku Jesu yá son áwinek. Wawu Ánutu yá uláp profet káungá milun yáni hára wáina táinet ingga miuk wa isutang táinek. ");
INSERT INTO klt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses yá ing miuk, ‘Táwi Ánutu sáni watá profet káman sáni háranan yon táng tunggap tángga tán nák ina profet háleinek. Wata ku watá rina meinek wa kándáng narángga isutneráng. ");
INSERT INTO klt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Káman niyá watán me wa narángga ma isutnándák wawu málámbán tombong háranan Ánutu yá pukon hánám isurán kungga kámutnek,’ Moses yá wáina ingga miuk. ");
INSERT INTO klt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Hang uláp profet hulátingga Samuel hára átang áwek watá Ánutu yan me mengga rám náta miuráng, wawu rám bu ná tunggafek ná. ");
INSERT INTO klt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sándu profet wata nángánangge yáni, wata ku profet tá me rina miuráng wata páliná wawu sándá táineráng. Hang uláp Ánutu yá táwi ilom sáni yot pahán káman háliuk wawu sándá ku páliná táineráng. Ánutu yá Abraham ing inuk, ‘Kák ráula háranan káman hára kungga ámna náráwa kámuk hánám káwak ketnán watán káin sambe yá tunggafengga kuinek.’ ");
INSERT INTO klt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kulá rám Ánutu yá yáup nanggená wa káwak káin suring mán háuk wahára wu suring mán sándán káin kálak áwángga ku sáháng álolo tán du sándá ket tárák sáni kandák wa sasaya suring muk.” ");
INSERT INTO klt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kulá Pita káling Jon yándi wu ámna náráwa me emá yánángga átnárán du pris yan tombong háranan kámá, me Sadyusi yan tombong háranan kámá, me it káungá pinná tátáyan táwi yáni watá áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Áwáng átnárát tu aposel yá Jesu wu há tárutuk wata ku kámurená wawu wáinanyon há tárutneráng ingga ámna náráwa yánángga árán áwuráng watá kuk hánám narángga ku ");
INSERT INTO klt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pita káling Jon ket ihángga ku há yonyon tiuk hálendu iháng kalabus it kinan ting sat árán kungga tembátnáya háliuk. ");
INSERT INTO klt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wáina táuráng enendu ámna náráwa táup hánám bá yon me wa há naruráng hálendu Jesu ya há naráng háting muráng watyot sale yáni yá kungga 5,000 náut wáina háliuk. ");
INSERT INTO klt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kulá tembátnáya ku Juda yan pris tátáwi yáni, ámna yáilá me lo yan tiksa watá Jerusalem hára urum táuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Waháranyon du pris yáin yáni Anas watyot Kaiafas, hang Jon káling Aleksenda watyot tu pris yáin yáni wata sip yáni kátu kámá yot watá kámuk hánám áwáng wahára áturáng. ");
INSERT INTO klt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wáina áwáng átang gu ámna kámá yánát Pita káling Jon iháng áwáng sat urum tángga áturáng wata rahán yáni hára hetang árán du ing yánáng suliuráng, “Sándu náut háláng hára me náut kutná hára ku kuip tárák wa támálák?” ");
INSERT INTO klt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wáina yánát tu Pita málám Iruk Káungá watá ep táwi tángga háláng imángga árán du ing yánuk, “Juda ámna náráwa yan pris tátáwi yáni me ámna yáilá, ");
INSERT INTO klt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","sándu nát tá ámna hárammá wáik wawu kálu rina kálu kungga táng tolin álo hálek ingga wata hám nanaráya nánáng sulinggoeráng? ");
INSERT INTO klt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wáina hálendu sán me Israel ámna náráwa kámuk sáni hánám ing narineráng, Jesu Nasaret nan, ámna náráwa son iháhá wata kutná hára ku ámna rahán sáni hára ná hetang átak wawu kuip álo hálek wa. Jesu wawu sándá maripong hára kátit tu há kámutuk, enendu Ánutu yá son táng tárut táuk. ");
INSERT INTO klt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu wawu sup ina, ‘ámna it tátá sándá sup wáik ingga kangga táng sat kuk watá ku inggálu it hálángngá ya káto hánám átkoek.’ ");
INSERT INTO klt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ni kámá nukngá káman dá ámna náráwa son iháháyan tárák ku muná. Káwak náta ketnán kut nukngá kámá ma árak, ináku Ánutu yá kut káman námuk, wawu Jesu. Kut watá re ku ámna náráwa son ihinek.” ");
INSERT INTO klt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita yá wáina yánán ámna hulá watá kápángga ing naruráng, Pita káling Jon wawu hánámá árená, me nanará itná káin kámá ma koená, enendu ma pitáená kándáng hánám wa memálák. Wáina kápángga ku hárámutang gu ámna yará náwu uláp Jesu yot káman átninggiuráng ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kulá káuráng gu ámna táng toliumálák watá yándi yot wahára hetang árán du watá me kámá topmá yánánáyan káluná ma tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wáina tángga ku yánát kaunsol yan urum itná wa sangga kep káin hat tu yáni ing inán kanán táuráng, ");
INSERT INTO klt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ámna yará náwu rina táng yámánggatnem? Watá tárák káman maming tái hánám há tán Jerusalem kinan ámna náráwa watá wáina ingga há nareráng wawu nándá táng kilak titiyan muná. ");
INSERT INTO klt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kulá nándá ku me watá emá re kungga áriwon, wata ku yánátne ámna yará watá kut wahára ámna náráwa ma yánindamálák.” ");
INSERT INTO klt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wáina mengga ku yáni wu son mantáng yámát it kinan áwán du Jesu kutná hára me wáina ámna náráwa ma yánáng tolindamálák ingga yánuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wáina yánát tu Pita káling Jon dá ku ing yánumálák, “Kulá sándá ku rina nareráng, Ánutu yan me isusut watá kándáng hálek, me sándán me isusut watá kándáng hálek? ");
INSERT INTO klt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nátá milun náti pop tátáyan tárák ku muná. Nát tu náti rina káumát me rina narumát wa há mengga yánángga átkuinemát.” ");
INSERT INTO klt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Wáina yánán kápángga ku ámna yáilá yá olet yándi mangga wáina son ma meindamálák ingga yánáng piták tángga ku yápmat hangga kumálák. Kulá ket tárák rina tán ámna náráwa yá káuráng wata ingga Ánutu kutná há meng tárut tángga áturáng, wata ku ámna yáilá yá márapmá yámámáyan káluná kámá ma kang tunggap táuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Iná ámna táng toliumálák wawu yaraná 40 táng hátingga árán du yarán dá ket tárák wa tán álo háliuk. ");
INSERT INTO klt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kulá Pita káling Jon yápmat hangga kumálák watá kungga ku nuknuk yándi kápángga ku pris tátáwi yáni me tombong Juda yan ámna hulá yá me rina yánuráng wa yánumálák. ");
INSERT INTO klt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Me rina wa yánán naráng hálingga ku kámuk pahán káman hálen Ánutu yan káin sáponga ing táuráng, “Táwi, ko alek káwak me táp hang wata kinan kutná kutná metá tunggafiuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uláp Iruk Káungá watá nan náni Dewit, kákkán yáup nangge, wata milunná hára ing miulák, ‘Náuta ku káwakngá káwakngá watá pahán káráp táup tánggoeráng? Náuta ku ámna náráwa nátá ket tárák wáik tátáya hánámá me hárotkoeráng? ");
INSERT INTO klt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Káwakngá káwakngá king me ámna yáilá átaráng watá káman hálengga tiktiyawik tánggoeráng. Wáina tángga ku erawángga Táwi Ánutu yot tu ámna náráwa son iháháya mená wa iháng hang titiya tánggoeráng.’ ");
INSERT INTO klt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dewit tán me ánu watá pálipuk hánám tunggafiuk wawu ing, it yáilá nahára Herot káling Pontius Pailat tá ále kámá káinnan ámna me Israel ámna náráwa yot káman hálengga Jesu, kangán yáup nangge káungá hánám, wa táng hang titiya me hároturáng, wawu ka uláp nangán yáup wa táinek ingga há miulák wa. ");
INSERT INTO klt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Watá wáina táuráng wawu kangán nanará me pahán rina táineráng ingga narulák wa táuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kulá Táwi, kula wu ko me rina mengga nán náháng piták tátáya táeráng wa kangga ku yáup nángánangge ka nán háláng námátá ku nándá ma pitáená hánghálángngingga kangán me wa mengga kuinemán. ");
INSERT INTO klt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ko yáup nanggeka káungá Jesu wata kutná hára ketya kálandang ilalák mara iháng tárut tángga ket tárák hulá hulá wa tángguinelák.” ");
INSERT INTO klt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kulá Jesu yan tombong gá yáni wu sáponga táng hálingga árát tu waháranyon it áturáng watá muwalán Iruk Káungá watá hang ep ihán du Ánutu yan me memeya ma pitáená átninggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ámna náráwa Jesu ya naráng háting mená watá kámuk hánám pahán me nanará yáni káman tiuráng. Ámna káman dá kutná kutná ná kan málámbán hánám re ma háliuk, ináku kámuk kán háliuk. ");
INSERT INTO klt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kulá aposel yáni wu Táwi Jesu yá son tárutuk wata hánghálángngá hánám yánángga kut Ánutu yá pahán álosim naráng yámángga táwi hánám háláng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Orek yáni hára wu káman dá náut kámá ya kesák ma tánggiuk. Káman niyá káwak me itná yá átmánggiuk wawu men yuwát tu sup wa iháng áwáng ");
INSERT INTO klt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposel ket yáni hára tit tu watá horengga rendá kesák irená wa yámánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kulá ámna káman átuk wata kutná wu Josep, iná aposel yá kut imuráng gu Banabas. Kut Banabas wata hulá wu pahán táng káto tátá. Wawu tombong Liwai háranan, itná hulá ku ailan Saiprus. ");
INSERT INTO klt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ámna watá ku káwak káman men yuwát tu sup ihuk wa táng áwáng aposel ket yáni hára tiuk. ");
INSERT INTO klt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kulá ámna káman kutná Ananaias watá áwáná Safaira watyot káwak yándi kátu káman hányon yuyuwáya men ámna káman dá yuwuk. ");
INSERT INTO klt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Káwak wa wáina yuwán yándi wu pahán káman tingga ku sup kátu táng ting san árán du Ananaias yá sup kátu rewe táng kung aposel ket yáni hára tingga yángyárungngingga sup pu kámuk ná iháng áwáng ná tet ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wáina tán du Pita yá inuk, “Ananaias, rina tángga ku satá Satan dá pahálan han du Iruk Káungá wa ingirungngingiya tángga káwak yuwená sup kátu wa táng kangán da tingga ku kátu rewe tángga áwelák? ");
INSERT INTO klt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ko káwak wa metá yuwuk wawu kakán pahán isutang táulák. Sup ihulák wa ka rina tátáya wu álo tánggim. Rina tángga ku nanará kandák wa táulák? Ko ámna nangge yángyárungnget ingga narelák, enendu ámna nangge muná, ináku Ánutu málám ingirungngingiya táelák.” ");
INSERT INTO klt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Wáina inán Ananaias málám wa narángga waháranyon pukon kámutang táng hang kátingga árán du tambun wawu ámna máto kámá yá áwáng lap pá pondang táng kung usuráng. Kulá kámá niyá wáina táek ingga pingnganá narángga ku pikpito hánám naruráng. ");
INSERT INTO klt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kulá 3 aua náut wáina átang sangga ku áwáná yá náulá yan káin rina tunggafiuk wawu ma narená wahára áwáng hiuk. ");
INSERT INTO klt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wáina áwáng hen du Pita yá ináng suliuk, “Ko nanáng, Ananaias yot sándá káwak men yuwuk wata supmá wa ná rewe me?” Ingga inán watá miuk, “O, wa rewe.” ");
INSERT INTO klt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wáina inán du Pita yá inuk, “Náuta ku sándá Táwi yan Iruk ingirungngingiya pahán káman hálemálák? Kang! Náula useráng wawu kálu mungnga hára átaráng watá ku kák hányon kehángga kuineráng.” ");
INSERT INTO klt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wáina inán waháranyon pukon kámutang hárammá hulá hára táng hang kátingga árán du ámna máto yáni wu it kinan áwángga wáina kangga ku tambun wa táng kung náulá tangtang usuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kulá náunáwán yará watán káin wáina tunggafek ingga narángga ku Jesu yan tombong me ámna náráwa kátu watá pikpiták táwi hánám wa táuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel yáni wu ket tárák hulá hulá ámna náráwa orek yáni kinan táup hánám táuráng. Ámna náráwa Táwi ya naráng háting mená yáni wu pahán káman hálen du it káungá kumbiná kinan hangga kung paranda kutná Solomon dán paranda hára urum tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ámna náráwa niyá Jesu ya ma naráng háting mená watá ku Jesu yan tombong wata kut yáni meng tárut tánggiuráng, enendu yáni áwáng watyot átnát ta ku pitánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wáina tánggiuráng, enendu ámna náráwa táup pá yon watá Táwi ya naráng háting mángga ku áwáng watán tombong hára sengsáráp tángtáng tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ket tárák wáina tánggiuráng wa kangga ku ámna náráwa yá ilalák mara wa iháng áwáng kálu hára káwam iháng áwáng elengga wata ketnán tinggiuráng. Wáina titne ku Pita yá kun yongnganá yá re ihánggápán álo háleniráng ingga wáina iháng kung tinggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","It yáilá Jerusalem tangtang it átaráng waháranan táup hánám watá ilalák mara me iruk wáik ká iháng lem táená wa hányon ihángga áwánggiuráng wawu kámuk álo hálenggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kulá wáina tángga árát kápángga ku pris yáin yáni yot tombong Sadyusi háranan kámá yáup káman tánggiuráng watá aposel wa kápángga pahán suksuk hánám naráng yámánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wáina narángga ku aposel wa ket ihángga kalabus itná kinan ámna wáik ká árená wakáin tiuráng, ");
INSERT INTO klt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","enendu yáungán Táwi yan angelo káman dá kalabus it watán kálu mungnga wa yaling yámángga yángotang kep káin hangga ku ");
INSERT INTO klt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yánuk, “Kungga it káungá watán kumbi kinan káin átang gu Táwi yan átkuku watán me pingnga wa kámuk hánám ámna náráwa yánineráng.” ");
INSERT INTO klt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wáina yánán yáni wu hilápmá hánám bu angelo yá rina yánuk wa isutang kung it káungá kumbiná kinan átang ámna náráwa me wa yánáng tolingga áturáng. Kulá pris yáin yáni watá ámna yáup káman tánggiuráng watyot áwángga ku kaunsol kinan nan Israel yan ámna yáilá wa kámuk hánám met áwuráng. Áwáng káman hálengga ku ámna kámá suring yámát kalabus itná káin aposel yángotang áwáwáya kuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wáina kuráng enendu aposel wu ma árát kápángga ku son áwángga ámna yáilá ing yánuráng, ");
INSERT INTO klt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kalabus itná wawu kálu kámuk káto sung sat árát ámna kálu pin yáni tátá watá pin yáni tángga átaráng. Wáina árát kálu yalemán enendu ni kámá káman it kinan ma árán kamán.” ");
INSERT INTO klt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wáina yánát narángga ku it káungá pinná tátá wata táwi yáni me pris tátáwi yáni watá narángpak tángga son du náutá tunggafeinek ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wáina narángga átnárát ámna káman dá áwángga yánuk, “Sándá narániráng! Ámna iháng kalabus itná kinan tiuráng wawu it káungá kumbiná kinan hetang átang ámna náráwa me yánáng tolingga átaráng.” ");
INSERT INTO klt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wáina yánán du it káungá pinná tátá wata yáin yáni watá tewe ámna ná watyot kung aposel wa yángotang áwuráng. Yáni wu kung táng hángháláng tángga ma yángotang áwuráng, ináku yolopon yángotang áwuráng, náuta ámna náráwa yá sup mangga náráháng kámut tánirot ingga narángga ku wáina táuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kulá aposel yángotang áwángga ku iháng sat kaunsol rahán yáni hára árát tu pris yáin yáni yá yánuk, ");
INSERT INTO klt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nándá ámna wata kutná mengga ámna náráwa me pingnga yánáng totoli wata há káto táng sámumán, enendu sándá emá re yánáng tolingga árát tu ámna náráwa táup hánám Jerusalem kinan átaráng watá há narángga átaráng. Iná ámna wa utkámut táuráng watán márapmá wu nányot átak ingga hánámá sáni menggoeráng.” ");
INSERT INTO klt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wáina yánán du Pita yot aposel nukngá watá inuráng, “Nándu Ánutu yan me wawu há isutnemán, iná káwak ámna yan me wawu ma isutnándámán. ");
INSERT INTO klt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sándá Jesu maripong hára kátingga utkámut táuráng, enendu táwi ilom náni yan Ánutu watá há kámutuk háranan son táng tárut táuk. ");
INSERT INTO klt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wáina tángga táng áráng ting san ketná álák kálu átangguinek. Kulá Ánutu málámbá yon Jesu kut táng hip tán watá Táwi náni me Son Iháhá wáina átangguinek. Watá ku háláng námán Israel nándá pahán hurik tátne nándán mukmuro yawonek. ");
INSERT INTO klt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kulá nándu Ánutu yá wa táuk wawu há káumán wata ku meng isurátne kuinek, iná Iruk Káungá yá ku wata hányon meng isurán kuinek. Niyá me wa narángga isutnek wawu Ánutu yá Iruk Káungá wa iminek.” ");
INSERT INTO klt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pita yá wáina yánán naruráng hára wu ámna yáilá watá kuk hánám narángga aposel wa ráháng kátkámut tátáya naruráng. ");
INSERT INTO klt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wáina narángga árát tu tombong Farisi háranan ámna káman kutná Gamaliel wawu ámna náráwa kámuk hánám bá meng toling mángngátaráng hang ámna wawu lo yan tiksa, watá kaunsol rahán yáni hára tárutang gu ámna kámá yánán aposel wa ihángga kep káin hang rám kimo átniráng ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wáina yánán du ámna kámá yá aposel wa yángot hang kep káin árát tu Gamaliel yá ámna yáilá wa yánuk, “Israel ámna, sándu ámna ná rina kámá táng yáminán du hulátingga kándáng nangnaráng táineráng. ");
INSERT INTO klt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sándu ing há nareráng, rám hásák ma hálek ámna káman kutná Teudas yá tárutang nákku ámna hulá kutna pálak ingga men ámna 400 náut wáina tá kung watyot áturáng, enendu kapman dá utkámut tán watán tombong wawu hárátingga káman káman kuráng. Wáina tát tu yáup yáni wawu hánámá háliuk. ");
INSERT INTO klt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wata máriná káin du ámna náráwa kut yáni erek hánám wa uying háháli rámá hára ámna káman kutná Judas Galili nan watá tárutuk. Wáina tárutang gu ámna kámá ihángga ku kapman isusut ta kun erawák táuráng, enendu kapman dá ámna wa hányon utkámut tán watán tombong wawu hárátingga káman káman kuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wáina wata ku kula wu ing sánin, sándá ámna ná rina kámá ma táng yámindaráng, ináku yápmat há yáni kuineráng. Yáup yáni wa tánggoeráng wawu ámna yan nanará re hálen wawu tát kungga yáup yáni watá pana háinek. ");
INSERT INTO klt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iná pálipuk yáup yáni náwu Ánutu yan yáup hálen wawu sándá káto táng yámámá yan tárák muná. Ánutu yot erawánirot.” ");
INSERT INTO klt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel yá wáina yánán narát pálipuk hálendu aposel ya met áwát tu yánát hánámá lahot yámát Jesu kutná hára son ma yánáng tolindaráng ingga yánángga ku yápmat há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wa yápmangga kungga aposel yáni wu Ánutu yá naráng hákhátik yáni tárákngá kangga ku Jesu yan yáup tát wata ingga ámna kámá yá iháng lem tát tu reprepmá álo táineráng ingga narángga yánuk wata heronge nangnaráng kuráng. ");
INSERT INTO klt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yáni wu kung átang gu rámá rámá wu Táwi yan it káungá hánám kumbiná kinan me it wahára wahára kungga Jesu wawu ámna náráwa son iháhá ingga mengga me pingnga álosim wa yánáng tolingga átninggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kulá rám wahára Juda nan ni Jesu naráng háting mená sale yáni yá táwi hánám wáina hálengga árán du waháranan kámá Grik me metáená watá ku kámá Aram me metáená wata kuk táng yámángga ing yánuráng, “Sándu rámá rámá sánin kálu rewe náráwa kawát niyá sungi ya kesák tánggoeráng wa háláng yámánggoeráng, iná nándán kálu náráwa kawát wawu ma háláng yámángguráng.” ");
INSERT INTO klt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wáina yánát tu aposel 12 watá disaepel kámuk ka met áwát tu ing yánuráng, “Kulá nándá Ánutu yan me wa mengga ámna náráwa yánáná wa sangga ku sungi silip tátá hára átnemán wawu kándáng ma háleindák. ");
INSERT INTO klt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wáina wata ku, yanuknuk, sándá ámna 7 ni Iruk Káungá yan háláng hára re árená me nanará yáni álosim hára árená me orek sáni hára kut yáni álosim átnándaráng, wáina wa kápángga iháng tunggap tát nándá wa iháng yáup wahára titne ku watá yáup wa pinná tángga átneráng. ");
INSERT INTO klt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iná náni wu rámá rámá sáponga tángga Ánutu yan me rewe yánángga átningguinemán.” ");
INSERT INTO klt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wáina met ámna náráwa kámuk watá me wa narát álosim hálendu Stiwen wawu ámna ni Jesu ya pahán yot naráng háting mángngátak me Iruk Káungá watá ep táwi hánám tán átnándak wa táng tunggap táuráng. Hang Filip, Prokorus, Nikanor, Timon, Pamenas hang Nikolas wawu hányon iháng tunggap táuráng. Iná Nikolas wawu it yáilá Antiok nan Juda ámna muná, enendu Juda yan miti kinan átnándak. ");
INSERT INTO klt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kulá yáni wu ámna 7 wa yángot áwáng aposel rahán yáni hára tit tu aposel yá yáup yáni wahára iháng káto táng yámámáya sáponga táng yámángga ket yáni yá yáin yáni hára usáng hang tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iná rám wahára ku Ánutu yan me wa meng isurát kun ámna náráwa táup hánám watá Jerusalem hára Jesu yan tombong háliuráng. Pris táup táwi yá yon Jesu yan me pingnga álosim wa narángga naráng hákhátik kálu wahára áturáng. ");
INSERT INTO klt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kulá Stiwen wawu Ánutu yá pahán imángga málámbán háláng wa imán ket tárák hulá hulá tátáwi hánám ámna náráwa orek yáni káin tángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wáina tángga árán du Juda yan miti itná káman kutná Along Koená wahára hangga árená ámna watá watyot menmen táuráng. Ámna urum wawu it yáilá Sairini, it yáilá Aleksandria hang provins Silisia yot Esia wakáinnan. ");
INSERT INTO klt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wáina menmen táuráng, enendu Stiwen wawu Iruk Káungá watá nanará imángga átuk hálendu ámna urum watá me hára wu ma táng hang tinggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wáina hálendu yáni wu kilak átang ámna kámá pahán yánin hat tu watá kusák pilengga ing miuráng, “Stiwen dá Ánutu me Moses ya me kandák men narumán,” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kulá wáina tángga kungga ku ámna náráwa, ámna yáilá me lo yan tiksa watá pahán yáni táng tárut tát tu kung Stiwen ket tángga táng áwáng kaunsol ket yáni hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wáina ting sat árán du ámna kámá yánát tu watá áwáng me kusák ing miuráng, “Ámna nátá Táwi yan it káungá nátyot Ánutu yan meng rákit me wata me kandák menggoek. ");
INSERT INTO klt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Rám káman ing men narumán, ‘Jesu Nasaret nan watá Táwi yan it káungá ná yalingga ku kálu rina isusut ta Moses yá námuk wa yawondang gu kálu kámá isusut ta náninek,’ Stiwen dá wáina miuk,” ingga ámna kámá watá miuráng. ");
INSERT INTO klt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iná ámna náráwa kaunsol it hára áturáng watá kámuk hálengga Stiwen kárek káuráng gu Stiwen kurák máta wawu angelo kurák máta ina. ");
INSERT INTO klt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kulá wáina meng hálit tu pris yáin yáni watá Stiwen inuk, “Me wa meng sat kákkán káin áwek wa pálipuk me?” ");
INSERT INTO klt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wáina inán du Stiwen dá miuk, “Yanuknukna me nan ilomna, nákkán me ná kárámatingga narineráng! Sisi náni Abraham watá it táwi Haran káin ma koená Mesopotemia ále káin há árán Ánutu yamá hálángngá pálak watá watán káin tunggafengga inuk, ");
INSERT INTO klt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ko káwakka me sipya kátu wa yápmangga ku no káwak kaleinet káin wa kuinelák.’ ");
INSERT INTO klt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Wáina inán du Kaldia ámna náráwa yan káwak wa sangga kung gu it táwi Haran káin itná hulá ya átuk. Átang árongga naning gá kámurán du Ánutu yá suring mán áwáng káwak átamán nahára áwuk. ");
INSERT INTO klt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wa áwuk hára Ánutu yá káwak kátu kimo 1 mita ina káman málámbán tombong gá átnát ta kámá ma imuk. Ináku ing inuk, ‘Máriya ku káwak wa kaminet wawu ka me kák ráulaka watán káwak háleinek,’ ingga inuk. Rám wahára wu Abraham bu nanggená muná árán wáina inuk. ");
INSERT INTO klt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iná ‘Kák ráulaka wawu kung ámna kámá yan káwak káin watán yáup nangge hánámá hálet tu iháng wáik táng sat árát kungga yara 400 háleinek. ");
INSERT INTO klt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Iná watá rendán yáup nangge hálengga átneráng wawu na márapmá yáme wata máriná káin du ráulaka yá káwak wa sangga áwáng ále nákáin du na nanáng sákngineráng.’ ");
INSERT INTO klt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wáina inángga ku pahán káman mená inángga ku pahán káman dán tárák ku kip mamará watá átnek ingga inuk. Wata torong káin Abraham nanggená Aisak ká tunggafengga rám 8 árán du málám nanggená kipmá maruk. Kulá wata torong káin átang gu Aisak ká Jekop naning hálengga átang árongga torong káin du Jekop pá táwi ilom náni 12 wata nan yáni háliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kulá táwi ilom náni watá Josep pa pahán suksuk narángga ku táng yáup nangge hánámá ya ámna kámá yánát yungga tángga Isip káin kuráng, enendu Ánutu yá watyot átkiuk. ");
INSERT INTO klt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wáina átang gu márapmá rina watán káin áwánggiuk wa kung rákit tángga nanará álosim imán du Isip pán king Fero yá kan álosim hálen heronge naráng mángga Isip pán ámna hulá yáin yáni ya táng tunggap tángga tin árán du inán málámbán kutná kutná wa pin yáni tángga átkiuk. ");
INSERT INTO klt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kulá wata torong káin sungi kesák táwi hánám bá Isip káwak me Kenan ále káin wa kámuk hánám tunggafengga márapmá táwi hánám yámán táwi ilom náni yan káin sungi yá muná kuk. ");
INSERT INTO klt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wáina kangga ku Jekop pá sungi Isip káin átak ingga met narángga ku hulátingga táwi ilom náni wa suring yámán wakáin kuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kungga áwáng átang sangga son suring yámán kuráng wahára ku Josep pá nák ku wa ingga tatning ilommá watyot kulaná wa yánuk. Wahára kungga ku Fero yá Josep sipmá kátu wa naráng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Wáina tángga ku Josep pá naning Jekop me sipmá kátu kámuk hánám wata me san kun Isip káin kuráng, wata sale yáni ku 75. ");
INSERT INTO klt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kulá Jekop málám Isip káin átang kungga ku málám bot táwi ilom náni wawu kámuk wakáin kámuturáng. ");
INSERT INTO klt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kámurát tu iháng kung Sekem káin tanggán káman Abraham bá Hamor nángánangge yan hára sup silva yá yuwuk wakáin tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kulá Isip káin rám hásák átang gu Israel ámna náráwa watá táwi hánám wáina máringga áturáng. Ánutu yá háláng yámámá rámá yá hátewingga átuk, wawu huphuráp Abraham me rina inángga me hárotuk wa isutnán. ");
INSERT INTO klt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Rám wahára wu king nukngá Josep ma naráng mák watá Isip pán king háliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King watá ku tombong náni wa yángyárungngingga ku ket tárák wáik yálenggiuk. Wata kinan káman du ing, me káto hánám mengga yánán nángánangge yáni kongakngá wa kámutniráng ingga iháng kung ále wahára wahára raták yápmanggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Kulá rám wahára ku Moses maming gá Moses táng tin du Ánutu yá nangge wata álosim naruk. Iná nangge wawu maming gá it kinan kilak pinná tángga árán yap kaláhu háliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Torong káin du táng kep káin sat árán du Fero uriwa yá áwáng kangga ku táng kung málámba nanggená ya sing muk. ");
INSERT INTO klt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wáina tán átang gu Moses wawu Isip pán nanará itná káin kungga nanará álosim wa tángga ku me metátá me yáup tátá ná wawu hálángngá pálak háliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kulá Moses wu yaraná 40 hálen átang gu sipmá kátu Israel wa kápápáya naráng hátiuk. ");
INSERT INTO klt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wáina naráng hátingga kungga káuk ku Isip ámna káman dá Israel ámna káman táng wáik tán kangga ku málám kung nukngá Israel ámna wa háláng imángga wata topmá tángga Isip ámna wa urán kámutuk. ");
INSERT INTO klt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses málám wáina táek ku Israel ámna náráwa yá kálu wakálu kungga ku Ánutu yá háláng námán nápmat along kuinán táek ingga káineráng ingga naruk, enendu watá kálu wa ma kang rákit táuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tembátnáya ku Moses málám kungga kápuk ngá ku Israel ámna yará erawángga árán du iháng hore pahán káman hálendimálák ingga ing yánuk, ‘Yarán, sándu sip káman, náuta ku sándi yon erawánggoemálák?’ ");
INSERT INTO klt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Wáina yánán ámna márapmá márumá watá Moses háting san kun du inuk, ‘Kák ku niyá nándán me nanaráyan ámna yáilá keháng tunggap táuk? ");
INSERT INTO klt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kuip Isip ámna utkámut tálák wáinanyon nák nutkámut táin ingga tánggoelák me?’ ");
INSERT INTO klt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wáina inán Moses málám me wa narángga ku piták ngá kungga lombu ya ále Midian káin átuk. Átang kungga áwáná tángga ku nangge yándi ámnaná yará iháng tiumálák. ");
INSERT INTO klt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wakáin árán kungga yara 40 yá sálin du ále yáilá Sainai tangtang ále komkomá ámálum re wakáin angelo káman dá káráp isikimo rangga átuk watán lánggop kinan tunggafeng muk. ");
INSERT INTO klt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses málám wáina kangga nangnganá han rinaná ingga kándáng kakaya rupmá káin kunggatang gu Táwi salá naruk, ");
INSERT INTO klt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nák ku táwi ilomya yan Ánutu, Abraham, Aisak me Jekop watán Ánutu.’ Wáina inán narángga Moses yá yángyáng tángga kakaya pikpito hánám naruk. ");
INSERT INTO klt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Wáina tán du Táwi yá inuk, ‘Ko káwak hetang átalák wawu káungá hánám, wata ku háramya káin sendol wa yaling. ");
INSERT INTO klt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","No Isip káin nangán ámna náráwa ket tárák kandák rina táng yámángga átaráng wawu há kápángga átkoet. Watá márapmá táwi hánám sunggoeráng wa há kápángga ku wa Isip ket yáni hára son iháháya kula háet. Wáina wata ku no suring kame tárutang Isip káin son kuinelák,’ ingga inuk. ");
INSERT INTO klt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Huphuráp Israel yá Moses yá Israel yan ámna yáilá átnát ta takta narángga inuráng, ‘Kák ku niyá nándán me nanaráyan ámna yáilá keháng tunggap táuk?’ ingga inuráng, enendu Ánutu yá ámna wanyon suring mán ámna yáilá hálengga Isip ket yáni hára Israel son iháháya kuk. Káráp isikimo hára angelo tunggafeng muk wata ketná hára Ánutu yá hálángngá wa imuk. ");
INSERT INTO klt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wáina háláng imán du málám Isip káin ket tárák hulá hulá wa tángga Israel yángotang Isip sangga kungga Táp Sipmá káin me ále komkomá ámálum re káin yara 40 wata kinan ket tárák hulá hulá tángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses watá yon du Israel ámna náráwa ing yánuk, ‘Ánutu yá sáni háranan yon profet káman nák ina táng tunggap táinek,’ ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses yá ále komkomá ámálum re káin táwi ilom náni yot átang áráng ále yáilá Sainai káin angelo yá me átkukuná pálak wa imán táng áwáng yámukngá náni yot átkoek. ");
INSERT INTO klt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Enendu táwi ilom náni yá watán me wa isutnán taktak yámuk, me ámna yáilá yáni átnát ta takta narángga ku pahán yáni káin du son hurik tángga Isip pa kukuya naruráng. ");
INSERT INTO klt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wáina tángga ku Aron inuráng, ‘Ámna Moses watá nángorán Isip sangga áwumán wawu náutá rina táng muk wawu ma narámán, wata ku ko ánutu náni kámá iháng toling námátá ku watá kálu máta yárengga nángotang kuineráng.’ ");
INSERT INTO klt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wáina mengga rám wahára ku ánutu yáni káman bulmakau nanggená utniná yáni táng tolingga ku wata heronge tángga taha yáni watán káin ihángga kungga ting muráng. ");
INSERT INTO klt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wáina tát tu Ánutu yá sárum yámán yánin pahán isutang káe, yap me hitung alek káin átaráng wa yánáng sákngingga áturáng. Wa táuráng wawu profet tá me rina papia hára ing uyiuk wáinanyon ina: ‘Israel ámna náráwa sándá ále komkomá ámálum re káin yara 40 áturáng wahára taha sáni me towet sisiya kutná kutná wa nákkán da ihángga áwánggiuráng me? Wawu muná hánám. ");
INSERT INTO klt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Miti ya hahayan sel it tángga átninggiuráng wawu nákkán muná, ináku wawu ánutu kusák kutná Molek watán. Hang ánutu kusák kutná Refan watán hitung utniná wa hányon tángga átkuráng. Ánutu kusák wa yánáng sákngingiya ku wata utni yáni wa iháng toliuráng, wata ku no sásure káwak sáni wa sangga kung Babilon táng háting kung numkálu káwak átak wakáin átneráng.’ Ingga profet tá wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Táwi ilom náni yá ále komkomá ámálum re káin átninggiuráng wahára wu Ánutu yan sel it watá átyámán wa kangga ku Ánutu yá nányot átak ingga naránggiuráng. Kulá sel it wa táuráng wawu Ánutu yá Moses wáina táineráng ingga inán wa isutang wáina táuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wa táuráng watá há árán du táwi ilom náni wata nángánangge yáni yá Josua yan rám hára tángga kungga árát Ánutu yá káwak márumá yásurán káwak wa yáni ya táuráng. Wáina tángga ku sel it wa wakáin táng tiuráng watá há árán kungga king Dewit tán rám háliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Iná Dewit wawu Ánutu yá táng álolo táng mánggiuk. Watá sáponga tángga it álosim káman Jekop e ilommá watá kung Ánutu ináng sákngingiyan álo tátáyan me rina ingga Dewit tá ináng suliuk. ");
INSERT INTO klt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wáina inuk enendu nanggená Solomon dá ku Ánutu yan it wa táuk. ");
INSERT INTO klt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“It wa há táuk, enendu Ánutu Árená Hánám wawu it ámna nangge yá táená wahára wu ma átnándak, ingga profet tá me wáinanyon ing miuk: ");
INSERT INTO klt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Táwi yá ing mek, “Alek wawu no putung átang pin yáni tátáyan kome, iná káwak wawu no háramna titiyan kome, wata ku sándá it rinaná hánám tát tu no wahára sek narinet? Wawu káluná muná. ");
INSERT INTO klt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Naya ketna yá yon du ále kutná kutná kámuk hánám wa iháng toliut.”’ Ingga Táwi yá wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Sándu yáin sáni káto hánám, pahán nanará sáni wawu Ánutu ma naráng mená ina. Káráman sáni wu yongurená hálendu Ánutu yan me wa ma narángngátaráng. Rámá rámá wu Iruk Káungá watán me wa ma isutkuráng, táwi ilom sáni yá tánggiuráng wáinanyon tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Uláp táwi ilom sáni yá profet kámuk hánám iháng wáik táuráng. Ámna Kándáng gá áwinek ingga meng tunggap táuráng wawu táwi ilom sáni yá hányon ráháng kátkámut táuráng, me sándá kálu wanyon isutang ámna áwinek ingga miuráng wawu táng káyam ket yáni hára tingga táng kung utkámut táuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ánutu yan meng rákit me wa angelo yá táwi ilom sáni ket yáni hára há tiuráng, enendu sándá ku ma isutnándaráng,” ingga Stiwen dá yánuk. ");
INSERT INTO klt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kulá Stiwen dá me wa yánán kaunsol yáni wu kuk hánám narángga mátap yáni kirikkárák táuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Iná Stiwen wawu Iruk Káungá watá ep táwi tán alek kálu hálen árán káuk ku Ánutu yamá sireretná pálak wata kinan Jesu wu ketná álák kálu hetang árán. ");
INSERT INTO klt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wáina kangga ku yánuk, “Narániráng, no káet tu alek ká ang tán Ámna Nanggená wawu Ánutu ketná álák kálu hetang árán káet.” ");
INSERT INTO klt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wáina men narángga ku hahatingga ohok maming tái hánám tángga káráman yáni yongutang kámuk tárutang hururung kung Stiwen usángga táuráng. ");
INSERT INTO klt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wáina tángga ku háráráng táng uyingga it yáilá kumbiná kep káin hangga ku utkámut tátáya sup mangga utang árát, ámna huphuráp Stiwen da me kusák miuráng watá lap yáni hákhásák torong káin molená wa yalingga iháng ámna máto káman wahára átuk wata hárammá hulá hára urum tit watá pin yáni tángga árán yáni sup máuráng. Ámna máto wata kutná wu Sol. ");
INSERT INTO klt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kulá sup mangga utang árát wata kinan Stiwen dá sáponga ing táuk, “Táwi Jesu, ko irukna táng.” ");
INSERT INTO klt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wáina mengga ku tulá hára imángga hahatingga hánám ing mantáuk, “Táwi, ko watán kandák yáni wata topmá ma táindalák.” Wáina mengga sangga ku há kámutuk. ");
INSERT INTO klt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kulá Stiwen utkámut tát tu ámna kámá Ánutu yan kálu kándáng isutang átnándaráng watá kutkáyawát táwi hánám táng mángga ku táng kung usuráng. Káe waháranyon átang hulátingga ku ámna náráwa Jesu yan tombong Jerusalem hára áturáng wa iháng wáik tángga árát tu kámuk hánám pitángga hánghánáng tángga Judia ále kálu me Samaria ále kálu kut, aposel yá re ku Jerusalem káin áturáng. Stiwen utkámut táuráng wawu Sol yá kápángga ku álo kámá táeráng ingga kápuk. ");
INSERT INTO klt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wáina kápángga Sol yá ku hulátingga Jesu yan tombong iháng lem táe sálikngik ingga it kinan áráng hak tángga ámna náráwa wa raták hánám háráráng iháng uying kung kalabus itná kinan tingting tángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kulá ámna náráwa pitángga kuráng watá kung it rehára áturáng, wakáin átang Táwi yan me pingnga álosim wa mengga yánángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip pá ku kungga Samaria ále káin hangga it káman hára Jesu wawu ámna náráwa son iháhá ingga yánán du ");
INSERT INTO klt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ámna náráwa táup táwi yá yon watán me narángga ket tárák rina tánggiuk wa kangga ku me rina yánánggiuk wa kándáng kárámatingga narángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip málám ámna náráwa táup pon iruk wáik ká ep ihená wa yásut yámán iruk wáik watá ohok pálak ámna náráwa yápmangga kunggiuráng. Iná kámá wu kurat yáni kámurená watá álo hálet kámá wu háram yáni wáik hálená watá álo hálenggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Wáina tunggafengga átuk hálendu it waháranan ámna náráwa watá heronge maming táwi hánám tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kulá ámna káman sárummá pálak it wahára átnándak wawu kutná wu Saimon, watá huphuráp pon átang me tárák kolem hulá hulá tángga nawu kutna pálak nahániráng ingga tán wa kangga Samaria ámna náráwa yá nangnga yáni hanggiuk. ");
INSERT INTO klt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wáina hálendu ámna náráwa yáilá me ámna náráwa hánámá watá kámuk hánám watán me narát álo kámá hálen du ing menggiuráng, “Ámna náwu Ánutu ina, wata kutná ku Ulihálángngá Pálak.” ");
INSERT INTO klt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rám hásák kon yáni yot átang káwak kán nanará hára ket tárák hulá hulá wa tángga átkun kangga nangnga yáni hanggiuk, wata ku ámna náráwa kámuk ká watán me naránggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ámna náráwa watá yon Filip pá Ánutu yan átkuku watán pingnga álosim watyot Jesu Son Iháhá wata mengga yánángga kun narángga wawu pálipuk hánám ing mengga ku umi kuhuráng. ");
INSERT INTO klt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kulá Saimon málám enendu pálipuk hánám ingga narángga umi kuhuk. Wáina tángga ku Filip isutang káman yándi átningga Filip pá tárák hulá hulá táwi wa tán kangga nangnganá han átninggiuk. ");
INSERT INTO klt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kulá aposel Jerusalem káin áturáng watá Samaria ále káin du ámna náráwa yá Ánutu yan me narángga káto tánggoeráng ingga met naruráng hára wu Pita káling Jon suring yámát watán káin kumálák. ");
INSERT INTO klt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Yándi wu watán káin kungga káumálák ku Jesu ya naráng háting mángga umi kuhuráng enendu Iruk Káungá watá ma áwáng ep ihená árán, wata ku Iruk Káungá watá ep ihik ingga sáponga táng yámumálák. ");
INSERT INTO klt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wáina tángga ku Pita káling Jon dá ket yándi yá yáin yáni hára usáng hang tin du wahára ku Iruk Káungá watá Samaria ámna náráwa watán káin áwuk. ");
INSERT INTO klt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kulá Saimon málám kápuk ku aposel yará watá ket yándi yá ámna náráwa yáin yáni hára usáng hang tin Iruk Káungá watá watán káin áwán kápángga, málám sup pá Iruk Káungá yuyuwáya ing yánuk, ");
INSERT INTO klt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Sándá háláng wa nák namán du no ketna yá wáinanyon táe Iruk Káungá wa hányon táineráng.” ");
INSERT INTO klt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wáina yánán Pita yá inuk, “Saimon, supya wawu kayot káráp pán pingnga háleinek! Ánutu yá málámbán pahán isutang gu wáina yámángngátak wawu ko ku sup pá álo yunggem ingga narelák? Wáina kámá ma árak. ");
INSERT INTO klt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Táwi rahálá hára pahála kinan du kandák átak. Wáina wata ku nándá Ánutu yan yáup tánggoemán wata kinan kák ku ma áralák. ");
INSERT INTO klt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wata ku kandákka wa sangga ku pahála hurik tángga ku Táwi ya sáponga táng mátá ku nanará kandák pahála káin átak wa yawon yaminek hám. ");
INSERT INTO klt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","No wáina kanet wawu náuta no kahet tu nándá ket yáup tánggoemán wa kang naránggoelák, hang mukmuroka watá keháng kik hárorán átalák.” ");
INSERT INTO klt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Wáina inán du Saimon dá miuk, “Sándá nák ka Táwi yan káin sáponga tán du rina memálák watá nákkán káin ma tunggafeindak,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kulá yándi wu Táwi yan me wa mengga Jesu yá rina tán káumálák wa ámna náráwa yánángga ku it wa sangga kungga Táwi yan me pingnga álosim wa it máro yon Samaria kinan yánáng yánáng Jerusalem ba kumálák. ");
INSERT INTO klt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kulá Táwi yan angelo yá Filip inuk, “Kák ku tárutang ámuta kálu kungga ku kálu Jerusalem hára átang kungga it Gasa káin kung hená wa isutang kuinelák,” wáina ingga inuk. Kálu wawu ále komkomá páliná muná átak wakálu. ");
INSERT INTO klt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Wáina inán du Filip pu wakálu kunggatang gu Itiopia káwak káinnan ámna káman káuk. Ámna wawu Kuin kutná Kandasi yan kapman watán ámna yáilá waháranan. Kuin watán sup pinná tángngátak, iná ámna wawu tunggulá ránená. Watá Jerusalem káin miti ya hangga ku ");
INSERT INTO klt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","son itná ya kukuya ku karis ná ketnán putung átang gu profet Aisaia yan papia wa sángsánging kungga átkiuk. ");
INSERT INTO klt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wáina kungga árán du Iruk Káungá yá Filip inuk, “Kungga karis wata tangtang kungga álák.” ");
INSERT INTO klt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wáina inán du Filip málám hururung karis wata tangtang kungga naruk ku ámna wawu profet Aisaia yan papia wa sángingga árán. Wáina narángga ku Filip pá inuk, “Kák ka wa sánginggoelák wata hulá wa kámá wáina ingga narelák me?” ");
INSERT INTO klt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wáina inán ámna watá miuk, “Rina narinet? Káman dá nanáng tolin du álo naránggem.” Wáina mengga ku Filip inán áráng málám bot putung átumálák. ");
INSERT INTO klt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ámna wawu Táwi yan me ing uyená wa sángingga átkiuk: “Watá me kámá ma miuk, ináku yolopmá átang sipsip utkámut tátáya tángga koená yá ina, me sipsip nanggená rommá mamaráya tángga koená yá ina átkoek. ");
INSERT INTO klt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ámna táng me hára tiuráng watá márapmá suwik ingga kusák pilengga táng hang tit reprepmá táwi hánám naruk. Wawu nángánangge muná hálendu ámna náráwa yá nángánangge wata me pingnga yánánáyan tárák ku muná. Watán átkuku wa káting rákit tát tu watá káwak ketnán ma árak.” ");
INSERT INTO klt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kulá ámna watá me wa sángingga sangga ku Filip inuk, “Ko nanáng, profet tá ku niya miuk, málámba miuk me ámna nukngá ya miuk?” ");
INSERT INTO klt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wáina inán du Filip pá hulátingga miti papia ámna watá sángiuk wata hulá kálak inángga ku Jesu yan me pingnga álosim wa inuk. ");
INSERT INTO klt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Kulá yándi wu kálu wa kungga átang gu umi káman hára kung hengga ku ámna watá miuk, “Kang, umi ku wa átak. Náutá kálu sung namán du no umi ma kuhánggem?” ");
INSERT INTO klt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wáina mengga ku karis engotang kuku wa inán karis watá tareng kátin Filip pá ámna watyot yayará yándi hangga kung umi kinan hangga ku Filip pá ámna wa umi kuháng muk. ");
INSERT INTO klt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wáina kuháng mángga sangga ku yándi wu umi sangga kep káin áwumálák waháranyon Táwi yan Iruk ká Filip tángga kun pikpilin du ámna watá ma káuk. Iná ámna wawu heronge pálak kálu wa isutang itná ya kuk. ");
INSERT INTO klt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iná Filip pá káuk ku málám bu it táwi Asotus wakáin átuk. Kulá it wahára wahára átningga Jesu yan me pingnga álosim wa ámna náráwa yánángga kuk. Wáina tángtáng kungga it yáilá Sisaria káin kung hiuk. ");
INSERT INTO klt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kulá rám wahára wu Sol yá Jesu yan tombong wa iháng lem tángga ráháng kátkámut tátáya mengga átuk. Málám kung pris yáin yáni ");
INSERT INTO klt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wa inuk, “Juda yan miti itná yan ámna yáilá kámá yá háláng nanamáya papia álo uyingga namánggim me? Ko álo ingga metá ku táng kung it yáilá Damaskas káin ámna náráwa Jesu yan tombong wa kápángga ket ihánggatang Jerusalem káin kuinet,” ingga inuk. Wáina inán álo ingga inángga ku papia uyingga imuk. ");
INSERT INTO klt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol málám Damaskas tangtang kung hálingga átnárán du waháranyon alek kálu yamá maming táwi watá málám hára manggatuk. ");
INSERT INTO klt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wáina tán Sol málám táng hang káwak káin kátingga ku me káman ing mengtán naruk, “Sol, Sol, náuta ku nák neháng wáik tánggoelák?” ");
INSERT INTO klt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wáina narángga ku Sol yá inuk, “Ámna hulá, kák ku ni?” ingga inán du miuk, “Nák ku Jesu, ni ko táng wáik tánggoelák wa. ");
INSERT INTO klt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kulá kula wu tárutang it yáilá kinan kutá ku rina táinelák wawu ámna káman dá wakáin kaninek,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Iná ámna Sol yot kungga áturáng wawu wahára hárámutang nángnángingga áturáng. Me wu há naruráng enendu watá niyá metáek ingga wu ma káuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kulá Sol málám tárutang rahálá háliuk enendu náut kámá kámá ma káuk. Wáina hálendu ketná hára tángga ku Damaskas káin kuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kung wakáin du rám kaláhu wu rahálá ma hálená wáina re átuk. Rám wahára sungi me umi kámá ma náuk. ");
INSERT INTO klt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kulá Damaskas káin du naráng hákhátik ámna káman átuk wata kutná ku Ananaias. Ámna watá átnárán du Táwi yá ára hára ina áwáng “Ananaias!” ingga mantáng mán du “Táwi, átat,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wáina inán du Táwi yá inuk, “Tárutang kungga kálu kutná Kálu Kándáng wakáin Judas yan it káin ámna káman it yáilá Tasus nan kutná Sol wa káinán áwet ingga yáninelák. Ámna wawu sáponga tángga átak. ");
INSERT INTO klt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol wu rahálá kunángngá enendu ára hára ina káek ku ámna kutná Ananaias watá áwáng ketná yá yáilá káin usáng hang tin du rahálá yá kándáng hálengngárán káek.” ");
INSERT INTO klt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wáina inán Ananaias yá miuk, “Táwi, nák ku kákkán ámna náráwa káungá hánám wa Jerusalem káin rina iháng wáik wáik tánggoek wata ámna watán pingnga wu há met naránggoet. ");
INSERT INTO klt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iná nákáin áwuk wawu pris tátáwi watá wáina álo táinelák ingga inát tu ámna náráwa kaya naráng háting kamená me sáponga táng kamángngátaráng wa ket iháháya áwuk.” ");
INSERT INTO klt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wáina men du Táwi yá Ananaias inuk, “Kung! Ámna wawu kula wu nákkán yáup ámna háháleya táng tunggap há táet. Ámna watá wu kungga ámna náráwa ále kámá káinnan me king máro átaráng me Israel ámna náráwa yan káin kungga nangán me pingnga wa yánángga átkuinek. ");
INSERT INTO klt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naya kutna meng tárut tángga kungga márapmá rina suwinek me láwit rina narinek wawu na ininet.” ");
INSERT INTO klt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wáina inán Ananaias málám kungga it kinan árángga kungga ketná yá Sol yáilá káin usáng hang tingga ku ing inuk, “Nukna Sol, Táwi Jesu ni nákáin áwángga átnárá tunggafeng kamuk watá suring namán áwet wawu ko rahála kándáng háháleya, me Iruk Káungá watá áwáng kák hára ep táwi hánám kekeháya.” ");
INSERT INTO klt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wáina inán waháranyon du náut kámá purungngá ina watá sohingga Sol rahálá sangga han du rahálá kándáng háliuk. Wáina tángga ku tárurán du Ananaias yá umi kuháng muk. ");
INSERT INTO klt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wáina tán du sunginá kámá nangga ku hálángngá tiuk. Sol yá rám kámá ku Jesu yan ámna náráwa Damaskas káinnan watyot wakáin áturáng. ");
INSERT INTO klt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Rám waháranyon Juda yan miti itná káin kung hanghang tángga ku Jesu wawu Ánutu Nanggená ingga yánángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iná Sol yan me naruráng watá ku hárámutang gu ing miuráng, “Ámna nátá hánám bu ámna náráwa Jesu ya naráng háting mená me sáponga táng mángngátaráng wa iháng lem tángngátak. Jerusalem káin wáina tángngátak watá ku inggálu ku son nákáin wa ket ihángga ku pris tátáwi yáni watán káin ihángga kukuya áwuk,” wáina ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kulá Sol yá me metátáyan hálángngá watá táwi hánám wáina hálen Juda ámna náráwa it yáilá Damaskas káin áturáng wa kándáng hánám wa Jesu wawu Ánutu yá ámna náráwa son iháháya táng tunggap táuk ingga yánuk. Wáina yánán du Juda yá watán me wa narángga hárámutang watán me káting hang titiya me kámá ma miuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kulá rám máro yon watá há kun átang wata torong káin du Juda yá urum tángga Sol utkámut tátáya me hárotang ");
INSERT INTO klt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","káen me yáungán it yáilá kumbiná yan kálu mungnganá wa erek kandingga áturáng, enendu Sol málám wáina tángga átaráng ingga há naruk. ");
INSERT INTO klt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Rám káman yáungán du Jesu yan ámna náráwa yá engotang it yáilá kumbiná wata ketnán árángga kungga ku inát yák wáina tán hára wata kinan putung árán páup putingga wahára tángga átang yolopon sat kumbi kep kálu hangga kuk. ");
INSERT INTO klt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wata torong káin du Jerusalem káin kungga Jesu yan ámna náráwa watyot sengsáráp tátáya tán kangga watá erek pitáng muráng, náuta watán nanará káin du ámna wa pálipuk Jesu ya naráng háting mánggoek me rina ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iná Banabas yá ku engotang gu aposel yan káin kuk. Málám kung wakáin du Sol wawu Damaskas káluná káin Táwi yá wáina tunggafeng mángga wáina wáina inuk, me Damaskas káin ma pitáená Jesu kutná mengga Táwi yan me yánánggiuk ingga aposel yánuk. ");
INSERT INTO klt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wáina tán du Sol yá watyot Jerusalem káin átang átninggiuráng. Rám wahára wu Sol yá ma pitáená Táwi yan me pingnga álosim wa ámna náráwa yánángga átninggiuk. ");
INSERT INTO klt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wáina tángga átkun kangga Juda kámá Grik me narená watá Sol yot me metángga wata menmenná táuráng. Wáina tángga ku watá kálu rekálu kungga Sol wa utkámut tánin ingga táuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wáina tát tu nuknukngá yá wáina ingga há narángga ku engotang hangga it yáilá Sisaria káin kungga ku suring mát it yáilá Tasus káin kuk. ");
INSERT INTO klt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kulá Judia ále kinan, Galili ále kinan me Samaria ále kinan Jesu yan ámna náráwa wa ma iháng wáik tát kándáng álo áturáng. Táwi tárang káin árát tu Iruk Káungá watá pahán yáni táng káto tán ámna náráwa táup hánám watá áwáng Jesu yan tombong hára sengsáráp tángtáng tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kulá Pita wu miti yáup tángga itná itná átningga ku kung Táwi yan ámna náráwa it Lida káin wa kápin ingga wakáin háuk. ");
INSERT INTO klt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wakáin du ámna káman kutná Ainias wa káuk wawu kuratná kámurená kome hára re yara 8 wata kinan pándák re átnándak. ");
INSERT INTO klt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wáina kangga ku Pita yá inuk, “Ainias, rám kula wu Jesu ámna náráwa son iháhá watá keháng tolindek. Tárutang komeka táng toling.” Wáina inán wahára re Ainias yá tárutuk. ");
INSERT INTO klt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kulá it Lida nan me ále pahálá Saron nan ámna náráwa kámuk watá Ainias yá álo hálen kangga ku pahán yáni hurik tángga Táwi ya naráng háting muráng. ");
INSERT INTO klt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kulá it Jopa káin du disaepel náráwa káman kutná Tabita watá átkiuk. Kut Tabita wawu Grik me kálu ku Dokas. Rámá rámá ket tárák álosim tángga ukuro árená wa háláng yámángga átnándak. ");
INSERT INTO klt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Rám Pita yá it Lida káin átuk wahára wu Tabita yá ilalák tángga kámurán du tambun wa umi kuháng mángga táng it pahálá torong káin ting sat átuk. ");
INSERT INTO klt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","It Lida wawu it Jopa tangtang gon wáina hálendu Jesu yan ámna náráwa yá Pita wawu it Lida káin átak ingga met narángga ku ámna yará suring yámát kungga Pita inumálák, “Ámna hulá, ko it Jopa káin sopmuná hánám áwáwáya naremán.” ");
INSERT INTO klt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Wáina inán du Pita yá watyot kuráng ngáyá kung het tu engotang it pahálá torong káin áruráng. Kulá náráwa kawát watá kámuk áwáng Pita rupmá áwálák átang kut káyawát pálak lap hákhásák kot lap kámá yot Tabita yá yáni yot átang iháng toliuk ngá wa iháng áwáng Pita yá kápápáya engeleng táuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita málám ámna náráwa kámuk yánán kep káin kut tu málám tulá hára imángga sáponga tángga ku hurik tángga náráwa kámurená watán kálu kungga ku miuk, “Tabita, tárulák.” Wáina men du náráwa watá rahálá hálengga Pita kangkang gu tárutnáráng putung átuk. ");
INSERT INTO klt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wáina tán du Pita yá háláng imángga ketná hára tán du tárutang hetang átuk. Wáina árán du málám náráwa kawát yot Jesu naráng háting mená kámá yot wa mantán áwángga ku náráwa kámurená yá son há tárutak ingga káuráng. ");
INSERT INTO klt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kulá pingnga watá it Jopa kinan wa erek hánám kung hálin du ámna náráwa táup hánám watá Táwi pálipuk ingga naráng háting muráng. ");
INSERT INTO klt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iná Pita wu it Jopa káin rám hásák kon ámna kutná Saimon watán it hára átkiumálák. Ámna Saimon wawu bulmakau kepmá wa yáup hulá hulá imámáyan da iháng tolingga tingngátak. ");
INSERT INTO klt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kulá it yáilá Sisaria káin du ámna káman átkiuk wawu kutná wu Konilius. Iná Konilius wawu káwak Rom wakáinnan tewe ámna 100 kutná Itali yan tewe ámna wata yáin yáni. ");
INSERT INTO klt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ámna málám me ámna náráwa kámuk hánám watán it hára átnándaráng wawu Ánutu yá rina átnát ta narek wa isutang Ánutu tárang káin rewe átnándaráng. Iná málám bu ni ukuro ámna náráwa átnándaráng wa táwi hánám háláng yámángga átnándak, me rámá rámá Ánutu yan káin sáponga tángga átnándak. ");
INSERT INTO klt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rám káman du yonyon kálu 3 kilok náut wáina hálengga árán du ára hára ina kangngárán hiták hánám Ánutu yan angelo yá áwáng mantáng mángga inuk, “Konilius!” ");
INSERT INTO klt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wáina tán Konilius málám kárek hánám kangga pingpitáng gu miuk, “Ámna hulána, rina?” Wáina inán du angelo yá inuk, “Ánutu yá ko sáponga tángngátalák wawu há narángngátak, me kutná kutná ukuro árená yámángngátalák wawu há kahángngátak. Wáina tángngátalák wawu tahaka ina titá kangga heronge naráng kamángngátak. ");
INSERT INTO klt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kulá rám kula wu ámna kámá suring yámátá kungga it Jopa káin ámna káman kutná Saimon kutná nukngá Pita wa engotang áwineráng. ");
INSERT INTO klt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ámna wawu ámna káman kutná Saimon yon watán it tu táp tangtang káin árán wahára átak. Ámna nukngá Saimon wawu bulmakau kepmá iháng yáup kámá tángngátak.” ");
INSERT INTO klt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wáina inángga kun du Konilius yá yáup nanggená yará yot tu tewe ámna káman men áwuráng. Tewe ámna wawu Ánutu yá pahálá káin rina isutsut ta narek wáina isutang átnándak, me Konilius málám bot tu rámá rámá átnándamálák. ");
INSERT INTO klt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wáina men ámna kaláhu watá áwát tu tárák wáina káet ingga erek hánám yánángga ku suring yámán it Jopa káin Pita kangga inángga áwáwáya kuráng. ");
INSERT INTO klt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wáina kuráng ngáya tembátnáya ku káe táitná hálengga árán du it Jopa hára kung heheya tángga áturáng wahára ku Pita wu it hungnganá káin sáponga tátáya árángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Áráng sáponga tángga átang gu háing mán sungi kámá nanaya naruk, enendu sungi emá tiyawingga áturáng. Rám wahára wu málám ára ina káman káuk ku ");
INSERT INTO klt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","alek ká ang tán lap maming táwi ina hahala táwi wa ilungngá 4 hára wa táng kik táená watá yolopon hang árán, ");
INSERT INTO klt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","songgo háram yáni 4 me ále málisám me kunap náut watanan me iráp kahetang átninggoená watá lap wata kinan árát kápuk. ");
INSERT INTO klt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wáina kápángga átnárán du me káman dá ing inuk, “Pita, tárutang kámá ráhángga sinang.” ");
INSERT INTO klt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wáina inán Pita yá miuk, “Táwi, wáina wu muná hánám! Nák ku songgo ma nanaya mená me kák rahála hára rongrongngá muná wawu ma nangngátat.” ");
INSERT INTO klt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pita yá wáina men me watá ing inuk, “Ko náut kámá káman Ánutu yá rongrongngá ingga mená wa ko rongrongngá muná ma nanayan ingga ma meindalák.” ");
INSERT INTO klt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kulá me wanyon rám kaláhu pálak men narán du waháranyon lap ina kutná kutná pálak watá alek káin son árángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wáina tángga ku Pita málám ára ina wa káuk wata hulá ya nanará yáup tángga átkiuk. Wáina tángga átnárán du ámna Konilius yá suring yámán kuráng watá yánáng sulit Saimon dán it tu wahára átak ingga yánát há narángga ku kung it kumbiná kálu mungnganá hára hetang áturáng. ");
INSERT INTO klt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wahára hetang átang gu ing miuráng, “Saimon kutná nukngá Pita wa it nahára átak me?” ingga miuráng. ");
INSERT INTO klt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kulá rám waháranyon du Pita wu ára ina káuk wata emá nanará yáup tángga átnárán du Iruk Káungá yá inuk, “Saimon, ámna kaláhu yá kák ka sulingga áweráng. ");
INSERT INTO klt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wáina wata ku tárutang hangga kápáng. Watyot kukuya narángpak ma táindalák. Wa áweráng wawu na suring yáme áweráng.” ");
INSERT INTO klt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wáina inán Pita málám tárutang hangga ámna wa yánuk, “Nák ku ámna sándá suling mángga áweráng wa. Náuta suling namángga áweráng?” ");
INSERT INTO klt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wáina yánáng sulin du ámna watá inuráng, “Nándu Konilius tewe ámna yáin yáni watá suring námán áwemán. Ámna wawu kándáng re átang Ánutu tárang káin átnándak. Juda kámuk ká ámna wawu ámna álosim ingga mengngátaráng. Ánutu yan angelo káman dá ko kung itná káin me kámá inátá nanaráya inán du wata suring námán kák ka áwemán.” ");
INSERT INTO klt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wáina inát tu Pita yá yángotang it kinan hangga yáungán du wahára watyot ruhuráng. Kulá tembátnáya ku tárutang hangga ámna kaláhu watyot kuráng. Wáina kut tu Jopa nan Jesu ya naráng háting mená watá hangga yásutang watyot káman yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kulá tembátnáya ku Pita wu Sisaria káin kung hiuk. Konilius wu wáina áwinderáng ingga narángga ku sipmá kátu me yanuknukngá yánán áwát káman átang háleng yámángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kulá Pita yá Konilius yan it kinan káin kung háuk wahára wu Konilius málám hárammá hulá hára turingga hangga ináng sákngin ingga táuk. ");
INSERT INTO klt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wáina tán Pita yá táng tárut tángtáng inuk, “Tárulák, ko nák ma nanáng sákngindalák, nák ku ámna nangge, ka inanyon.” ");
INSERT INTO klt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kulá Pita yá watyot me metángtáng kung it kinan hangga kápuk ku ámna náráwa táup hánám watá árát. ");
INSERT INTO klt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wáina árát kápángga ku Pita yá yánuk, “Sáni há nareráng wa, Juda nándá ámna ále kámá káinnan sányot káman háhále me kungga sásáhá wawu meng rákit mená yá wáina ma tátáya káto hánám tená yá átak. Enendu Ánutu yá há naliuk wawu no ámna káman rongrongngá muná ingga ma memeyan. ");
INSERT INTO klt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wáina wata ku nák ka ingga há suring yámeráng wata no rina kámá ma tát ináku há áwet. Wata ku no ing sánin, hulá náuta hánám bu nák ka pin tit no áwet?” ");
INSERT INTO klt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Wáina yánán Konilius yá inuk, “Rám kaláhu átang áwemán wata ámang káin yonyon kálu 3 kilok inggon hálengga átuk hára nawu itna káin sáponga tángga átkiut. Kulá waháranyon hánám ámna káman kutná kutná ná hakokowak hánám tánggánená watá tunggafengga rupna hára hetang átuk. ");
INSERT INTO klt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wáina hetang átang gu nanuk, ‘Konilius, Ánutu yá ko sáponga tángngátalák wawu há narángngátak, me kutná kutná ukuro árená yámángngátalák wawu há kahángngátak. ");
INSERT INTO klt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wáina wata ku ámna kámá suring yámátá kungga it Jopa káin ámna káman kutná Saimon kutná nukngá Pita wa engotang áwineráng. Ámna wawu ámna káman kutná Saimon yon watán it tu táp tangtang káin árán wahára átak. Ámna nukngá Saimon wawu bulmakau kepmá iháng yáup kámá tángngátak.’ ");
INSERT INTO klt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wáina nanán du waháranyon du no kák ka pin se kung kamán ko wa narángga há áwátá no kák ka heronge naráng kamet. Kulá kula wu nán kámuk Ánutu rupmá hára há átamán da ku Táwi yá rina nánánáya kanuk wa nánátá narindemán.” ");
INSERT INTO klt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Wáina inán du Pita yá ing yánuk, “Kula wu há naret, pálipuk hánám Ánutu yá tárák káman re it wakáinnan wakáinnan wa nálenggoek. ");
INSERT INTO klt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wakáinnan wakáinnan wawu niyá málámba tárang káin átang kálu kándáng wa isutang átnándaráng wata wu heronge naráng yámángga álo ing mengga son ihánggoek. ");
INSERT INTO klt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ánutu yá Israel nán me nánuk wa há narángga átaráng wawu me pingnga álosim ing miuk, Jesu ámna náráwa son iháhá wawu ámna náráwa kámuk ka Táwi yáni. Wahára kungga ku Ánutu yá nányot pahán káman hálek. ");
INSERT INTO klt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Judia ále kinan rina tunggafiuk wawu sáni há nareráng wa, Galili ále hára átang hulátiuk wawu Jon Umi Kuháng Yámámá watá umi kukuháya mená menggiuk wata torong kálu ");
INSERT INTO klt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ánutu yá Jesu Nasaret nan Iruk Káungá yot háláng táwi hánám wa imángga ku málámbá watyot árán du itná itná átningga ámna náráwa háláng yámángga Satan dá iháng lem táená wa iháng tolingga átninggiuk. ");
INSERT INTO klt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kulá nán aposel wawu Juda nánin ále káin me it yáilá Jerusalem káin rina rina tán rahán náni yá há káumán wata meng isurátne kunggoek. Jesu wawu táng maripong hára kátit tu kámutuk, ");
INSERT INTO klt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","enendu rám kaláhu átang gu Ánutu yá son táng tárut tángga hiták tin ámna náráwa yá rahán yáni yá há káuráng. ");
INSERT INTO klt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wawu kámuk hánám bá ma káuráng, ináku ámna nán uláp Ánutu yá málámbán me wa meng isusut tán náháng tunggap táuk, nándán káin tunggafeng námuk. Kulá kámutang tárutuk wata torong káin du nándá watyot sungi me umi há náumán. ");
INSERT INTO klt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wata ku ámna náráwa Ánutu yan me yánángga hiták ing memeya nánuk, Ánutu yá kámurená me ma kámurená watán átkuku yáni tárákngá hára re horengga nanará wawu Jesu wa rewe táng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Uláp profet kámuk hánám bá Jesu ya ing miuráng, Jesu málámba kutná hára re ku ámna niyá Ánutu ya naráng háting meráng watán mukmuro yawon yáminek.” ");
INSERT INTO klt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kulá Pita yá me wa yánángga átuk waháranyon Iruk Káungá watá áwáng ámna náráwa me wa narángga áturáng wa ep ihuk. ");
INSERT INTO klt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Wáina ep ihán du watá me hulá kámá kámá metángga Ánutu kutná meng tárut tángga áturáng. Wáina tát kangga Juda ámna Jesu ya naráng háting mená yá Pita yot áwuráng watá hárámuturáng, náuta Iruk Káungá watá ále kámá káinnan watán káin hányon áwáng ep ihuk wata. Wáina kangga Pita yá ku miuk, ");
INSERT INTO klt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ámna náráwa náwu Iruk Káungá wa Juda náni táumán wáinanyon há táeráng, wata ku ni kámá káman dá umi ma kuhindáráng ingga ma menggim.” ");
INSERT INTO klt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wáina mengga umi kuhineráng ingga yánán álo ingga inát tu Jesu Son Iháhá wata kutná hára umi kuháng yámuk. Wáina tángga sangga ku inát rám kámá wahára watyot átuk. ");
INSERT INTO klt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kulá aposel me Jesu naráng háting mená Judia ále kinan áturáng watá ámna ále kámá káinnan watá Ánutu yan me wa hányon táuráng ingga met naruráng. ");
INSERT INTO klt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wáina hálendu Pita yá árángga Jerusalem káin kuk hára wu Juda ámna Jesu ya naráng háting mená watá áwáng ing me táng muráng, ");
INSERT INTO klt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Pita, ko kungga ámna ále kámá káinnan watán it kinan árángga kápulák me watyot sungi náulák, wawu kandák táulák.” ");
INSERT INTO klt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wáina inát tu Pita yá rina rina tunggafiuk wawu kándáng hánám ing yánuk, ");
INSERT INTO klt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nák ku it Jopa káin sáponga tángga átang ára ina hára kangngáre ku lap táwi ina káman ilungngá 4 hára wa táng kik táená watá alek kálu hangga ku na átut wahára háuk. ");
INSERT INTO klt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wáina han wawu náut ingga kándáng káut tu songgo háram yáni 4 me songgo páyom me ále málisám kunap náut watanan me iráp kahetang átninggoená watá lap ina wata kinan árát káput. ");
INSERT INTO klt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Wáina kápángga átnáre ku me káman dá ing nanuk, ‘Pita, tárutang kámá ráhángga sinang.’ ");
INSERT INTO klt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Wáina nanán no inut, ‘Táwi, wáina wu muná hánám! Nák ku songgo ma nanaya mená me kák rahála hára rongrongngá muná watá nák pahánna kinan ma hangngátak.’ ");
INSERT INTO klt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Wáina me ku alek kálu nan me watá ing nanuk, ‘Ko náut kámá Ánutu yá rongrongngá ingga mená wa ko rongrongngá muná ma nanayan ingga ma meindalák.’ ");
INSERT INTO klt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kulá me wanyon rám kaláhu pálak men nare ku lap ina kutná kutná pálak wa son uying san alek káin áruk. ");
INSERT INTO klt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kulá rám waháranyon du ámna káman dá ámna kaláhu me nananáya suring yámán Sisaria kálu áwuráng watá áwáng it nándá átumán wahára áwáng hiuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iná Iruk Káungá watá ku nanuk, ‘Narángpak ma táená ku watyot kuineráng,’ ingga nanán du há kumán. Iná nuknuk náni ámna 6 náwu nákkot káman kungga ámna watán it kinan kumán. ");
INSERT INTO klt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kutne ku ámna watá ing nánuk, ‘No kangngáre angelo yá itna kinan káin tunggafeng namángga nanuk, “Me satá Jopa káin ámna kutná Saimon kutná nukngá Pita wata kuik. ");
INSERT INTO klt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kulá ámna watá ku ka me kákkán it hára ámna náráwa átaráng wa kámuk Ánutu yá son sásáháyan me táng áwáng sáminek,” ingga nanuk.’ ");
INSERT INTO klt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ámna watá wáina nanán du no me emá yánángga átnáre waháranyon Iruk Káungá watá hulátingga náni ep náhuk wáinanyon ep ihuk. ");
INSERT INTO klt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wáina tán du son no Táwi yá rina miuk wa naráng hátiut wawu ing, ‘Jon dá ku umi yá kuháng yámángngátak, iná sándu Iruk Káungá watá kuháng sáminek.’ ");
INSERT INTO klt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wata ku uláp Táwi Jesu Son Iháháya naráng háting mátne ku Ánutu yá Iruk Káungá wa nán námuk wáinanyon inggálu ku wa yámánggoek. Wáina wata ku no Ánutu yan nanará wa ma káto táng mánggem. Nák ku ámna nangge rewe.” ");
INSERT INTO klt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kulá Pita yá me wa yánán narángga pahán káman hálen kuk táng muráng wa sangga Ánutu ya heronge táng mángga ku ing miuráng, “Kulá Ánutu yá ále kámá káinnan wa tán watá pahán hurik tángga átkuku tátáyan kálu hára átaráng.” ");
INSERT INTO klt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kulá Stiwen utkámut táuráng wahára ku ámna náráwa kámá Jesu naráng háting mená wa hányon iháng lem tát pitángga hárátingga ále wahára wahára kuráng. Kámá yá ku Fonisia ále káin kuráng, iná kámá yá ku ailan Saiprus káin kuráng, iná kámá yá ku it yáilá Antiok káin kuráng. Ámna náráwa wa kuráng watá ku Jesu yan me pingnga wa yánángga kuráng, enendu ámna ále kámá káinnan muná, ináku Juda nan ámna náráwa wakáin árená watán káin re. ");
INSERT INTO klt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Iná ámna kámá orek yáni hára kuráng wawu Saiprus nan me it yáilá Sairini nan watá Antiok káin kungga Táwi Jesu yan me pingnga álosim wa Grik ámna náráwa hányon yánángga kuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wáina tát Táwi yan háláng watá watyot átuk hálendu ámna náráwa táup hánám watá watán me narángga pahán hurik tángga Táwi yan tombong háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wáina tángga átaráng ingga pingnga watá miti ámna náráwa Jerusalem káin áturáng wata káráman yáni káin han naruráng hára ku Banabas suring mát Antiok káin kuk. ");
INSERT INTO klt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Banabas wawu ámna álo kámá, Iruk Káungá watá wahára ep táwi hánám tángga árán naráng hákhátik ngá yá káto hánám hálengga átuk. Málám wakáin kungga káuk ku Ánutu yá pahán yámángga háláng yámángga árán kangga heronge hánám naruk. Wáina narángga ku rámá rámá Táwi isutang átkuineráng ingga kámuk pahán yáni iháng tárut tángga kuk. Wáina tángga ku ámna náráwa táup hánám watá Táwi yan tombong kinan áwáng háuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kulá wahára átang gu Banabas málám it yáilá Tasus káin Sol ya susuliya kuk. ");
INSERT INTO klt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Málám suling kung kang tunggap tángga ku engotang Antiok káin kumálák. Yándi wu kung wakáin yara ore káman kámuk Jesu yan ámna náráwa yot átang Táwi yan me wa ámna náráwa táup hánám yánáng toliumálák. Kut Kristen wawu Antiok hára kálak ámna náráwa Jesu yan tombong wa yámuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Rám ore wahára profet kámá Jerusalem káin átang kung Antiok káin háuráng. ");
INSERT INTO klt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kulá profet waháranan káman da kutná wu Agabus watá hetang átang Iruk Káungá yá pahálán han ing miuk, “Káwakngá káwakngá erek hánám sungi kesák táwi hánám bá tunggafeinek,” wáina ingga miuk. Wata torong káin Rom bán king Klaudius watán rám hára sungi kesák watá tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kulá Jesu yan ámna náráwa áturáng watá nuknuk yáni Judia ále káin áturáng wa tárák yáni hára háláng yámámáya me hárotang gu ");
INSERT INTO klt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","sup iháng Sol káling Banabas yámát tu watá iháng kung Judia káin Jesu yan tombong watán ámna yáilá yámán du watá ámna náráwa yámuráng. ");
INSERT INTO klt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Rám ore wahára King Herot tá Jesu yan ámna náráwa kámá ket ihángga iháng lem táuk. ");
INSERT INTO klt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herot tá yánán Jon tatning Jeims wawu kápik ká utkámut táuráng. ");
INSERT INTO klt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kulá Herot tá wáina tán kangga Juda yá wata heronge narát kápángga ku Pita hányon ket táuk. Wáina táuk wawu rám táwi Israel yá Másáng Yisná Muná Náená rám wahára. ");
INSERT INTO klt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita wu Herot tá yánán ket há tángga wata torong káin du táng kung kalabus kinan tewe ámna urum 4 watá pinná tátáya tiuk. Tewe ámna urum 4 wata kinan 4 yá urum káman káman hára átnándaráng, kámuk ku 16. Wáina árán kungga rám táwi Angelo yá Iháng Hátiuk watá sálikngin du táng áwáng rahán yáni hára me hára titiya naruk. ");
INSERT INTO klt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Wáina hálendu Pita wawu táng ting sat kalabus kinan átuk. Wakáin árán du Jesu yan ámna náráwa yá ku rámá rámá sáponga tángga Ánutu yá Pita háláng imámáya inánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kulá tembát tu Herot tá Pita táng me hára titi ingga miuk. Iná yáungán du Pita wu sen yará yá táng kik táng sat árená wa pálak táng tewe ámna yará ya orek yándi hára tit tu ruhángga átuk. Iná tewe ámna kámá yá ku kálu mungnga pinná tángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wáina átnárát waháranyon hánám Táwi yan angelo yá tunggafengga yamá yá kalabus itná kinan wa man angelo watá Pita katná kálu wa kátinggakak tángga táng mirak tángga ing inuk, “Sopmuná tárulák!” ingga inán wahára re sen ketná háranan watá sohingga háumálák. ");
INSERT INTO klt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wáina sohingga han du angelo watá inuk, “Lapya káto táng kik tángga sendol ka molák,” ingga inán Pita yá wáina tán du angelo yá inuk, “Lapya hásák wa mondang gu nák nasutang áwátá kundin.” ");
INSERT INTO klt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","10","Wáina inán Pita yá angelo wa isutang káman kungga it pahálá átuk wa sangga kungga tewe ámna kinan áturáng wa iháng hátingga kungga tewe ámna máta káin áturáng wa iháng hátingga kungga ku kalabus itná wa sangga it yáilá kálu koená kálu mungnganá ain da táená wahára kung hen du kálu watá málám re yalingga kun kalabus itná wa sangga kumálák. Iná Pita yá ku angelo yá ále wa tánggiuk wawu pálipuk ingga ma naránggiuk, ináku wawu ára káet ingga naránggiuk. Kulá yándi wu orek káman isikimo sim kungga ku angelo yá waháranyon pikpilingga kun du Pita wu málám re átuk. ");
INSERT INTO klt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kulá Pita yá málám re átang gu nanará ná yá kándáng hálendu ing naruk, “Kulá kula ku pálipuk hánám ing há naret, Táwi yá angelo ná suring mán áwáng Herot ketná hára me Juda yá rina rina táng namámáya tiyaweráng waháranan son nehek.” ");
INSERT INTO klt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wáina narángga ku Maria Jon maming watán it káin kuk. Jon wata kutná nukngá ku Mak. It wakáin du ámna náráwa táup hánám watá urum tángga sáponga tángga átnárát tu ");
INSERT INTO klt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","málám kuk watá kung it kapme yan kumbi kálu mungnganá hára károk károk kátin yáup náráwa kutná Roda watá kálu yalin ingga áwuk. ");
INSERT INTO klt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wáina yalin ingga áwán Pita yá metán salá narángga ku málám kálu ma yalená heronge pálak son hururung kung it kinan hangga ku yánuk, “Pita ku áwáng kálu mungnga káin átak!” ");
INSERT INTO klt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wáina yánán watá inuráng, “Kák ku hohelák hám.” Wáina inát watá táng hángháláng tángga yánuk, “Pálipuk hánám málámbá puk áwáng átak,” ingga yánán du ing miuráng, “Wawa angeloná hám.” ");
INSERT INTO klt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wáina mengga árát Pita málám károk károk wa emá re kátingga árán kung kálu yalingga kangga ku hárámuturáng. ");
INSERT INTO klt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wáina tát kápángga ku kilak átneráng ingga ket tárák táng yámángga ku Táwi yá wáina wáina tángga kalabus kinan káinnan nangotang áwek ingga yánángga ku Jeims Táwi kulaná yot yanuknuk náni wa wáina ingga yánineráng ingga yánángga sangga ku yápmangga it nukngá káin kuk. ");
INSERT INTO klt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kulá hilápmá ku tewe ámna yá káuráng gu Pita wu ma árán du hárámutang narángpak tángga ku yáni ing inán kanán táuráng, “Pita náwa rekálu koek?” ");
INSERT INTO klt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kulá Herot málám Pita ku ma árak ingga met narángga ku ámna suring yámán kung Pita ya suliuráng, enendu ma káuráng. Wáina hálendu málám tewe ámna Pita pinná táuráng wa men áwát tu rina hánám tángngárát Pita yá koek ingga yánáng suliuk, enendu kándáng ma inát tu sándu há kámutneráng ingga miuk. Kulá wata torong káin Herot tu Judia ále wa sangga hang it yáilá Sisaria wakáin átkiuk. ");
INSERT INTO klt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","King Herot tá it táwi Tair yot Saidon wata kuk táwi táng yámángga átuk. Yáni wu ále Herot tá pinná tángga átuk wakáin sungi iháng nangngátaráng, wáina wata ku yáni kámuk áwáng urum káman hálengga ku pahán káman dá tunggafeik ingga Herot kakaya áwuráng. Herot kanin ingga yáni wu Herot tán ámna hulá káman kutná Blastus watyot kálak háláng yámámáya me tát álo hálen du wata torong hára kung king kangga ku pahán láláp tángga ku kuk táelák wa sang ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wáina inát Herot tá rám káman me tátá ingga tiuk. Kulá rám wahára ku málám king gán kutná kutná wa tánggánengga ku king gán sia hára putung átang me táwi yánuk. ");
INSERT INTO klt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wáina yánángga árán du ámna náráwa yá ing mantángga áturáng, “Me náwu ánutu káman dán me, náwu ámna yan me muná!” ");
INSERT INTO klt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wáina mengga Herot kutná meng tárut tángga árát narángga, málám Ánutu kutná meng tárut tátáya takta narán waháranyon hánám Táwi yan angelo yá kangga áwáng urán du ilalák wáik ká tunggafeng mán du umbeng gá pahálá kinan sáng rákrákit tángga árát kungga kámutuk. ");
INSERT INTO klt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iná Táwi yan me watá ku táwi hánám hálengga kungga it kámá kámá káin kung háliuk. ");
INSERT INTO klt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kulá Banabas káling Sol yá Jerusalem káin yáup yándi wa táng hálingga ku son Antiok káin kumálák. Wakáin kukuya ku Jon kutná nukngá Mak wa engotang káman yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jesu yan ámna náráwa it yáilá Antiok káin áturáng wata kinan profet kámá me Táwi yan me yánáng tolingngátaráng ámna kámá hányon áturáng wata kut yáni ku Banabas, Simion kutná nukngá Niga (kut Niga wata hulá ku sutná yángomá), Lusius it yáilá Sairini nan, Manain (ámna Manain wawu ámna yáilá Herot yot káman sing yámená) hang Sol. ");
INSERT INTO klt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kulá rám káman sungi sangga Táwi kutná meng tárut tángga átnárát tu Iruk Káungá yá ing yánuk, “Banabas káling Sol wa iháng tunggap tát no náut yáup tátáya mantáng yámut wa tátáya yándin kámá átnemálák.” ");
INSERT INTO klt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wáina yánuk hálendu sungi sasa táuráng me sáponga táuráng watá sálikngin du ket yáni yá yáin yándi hára usáng hang tingga iháng káto tángga ku suring yámát kumálák. ");
INSERT INTO klt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iruk Káungá yá suring yámán kungga ku it táwi Selusia wakáin kung háumálák. Kulá Selusia káin du kilang kinan árángga kun du watá iháng kung ailan Saiprus kálu kungga ");
INSERT INTO klt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","it yáilá Salamis káin tin du kung Juda yan miti itná kinan hangga Ánutu yan me wa mengga yánángga kumálák. Ámna Jon kutná nukngá Mak wawu káman yáni átningga ku háláng yámángga átninggiuk. ");
INSERT INTO klt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yándi wu wáina yángyánáng kungga ku ailan numkálu it táwi Pafos káin kung hiumálák. Pafos káin kung hengga káumálák ku tombong Juda waháranan ámna sárummá pálak káman wawu profet kusák wata kutná ku Bar-Jesu. ");
INSERT INTO klt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iná ámna wawu kawana kutná Sergius Paulus watyot átnándamálák. Sergius Paulus wawu nanará ná álo kámá hálendu Banabas káling Sol mantáng yámán málámbán káin áwumálák, náuta Ánutu yan me wa há nanaráya naruk wata. ");
INSERT INTO klt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ámna sárummá pálak wawu Grik me kálu kutná ku Elimas. Kulá ámna watá ku kawana watá Jesu ya naráng háting mámá wata taktak mán du Banabas káling Sol yan yáup wa yanyawon táng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Wáina tán Iruk Káungá yá Sol kutná nukngá Pol wa ep tán kárek hánám Elimas kangga átang inuk, ");
INSERT INTO klt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Kák ku Satan nanggená me tirik tárák álosim wata káyammá! Kák ku me kusák me ket tárák wáik watá ep táwi hánám kehángga árán átalák. Kák ku Táwi yan káinnan kálu kándáng isusut wa táng yakyawák tánggoelák. Kálu wáina wa sasaya wu ma hám naránggulák? ");
INSERT INTO klt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wata ku ing narinelák, rám nahára wu Táwi ketná yá káyamya hálengga keháng lem tán du rahála yá páyung tin káe yamá ma káená rám hásák sim átnelák.” Wáina inán waháranyon páyung watá áwáng rahálá wa pop tán hangga kungga ámna ketnán tán átning kuku wata sulingga kuk. ");
INSERT INTO klt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iná kawana watá Táwi yan me narángga tárák wáina kangga ku nangnga ná han Jesu pálipuk ingga naráng háting muk. ");
INSERT INTO klt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kulá Pol yá ámna málámbot kuráng watyot kilang hára árángga ku Papos sangga Pamfilia distrik káin it yáilá Pega wakáin kuráng. Kung wakáin átang gu Jon kutná nukngá Mak ká yápmangga Jerusalem ba son kuk. ");
INSERT INTO klt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kulá Pol káling Banabas watá Pega wa sangga ku kungga Pisidia distrik káin it yáilá Antiok káin wa kumálák. Iná Sabat hára wu kung Juda yan miti itná kinan hangga putung átumálák. ");
INSERT INTO klt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wáina árán miti itná yan ámna yáilá watá Ánutu yan meng rákit mená me profet tán me wa sánging hálingga ku Pol káling Banabas ing yánuráng, “Nuk náni yara, sándá me kámá nánángga náháng káto tátáya naremálák hálendu álo náninemálák.” ");
INSERT INTO klt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Wáina yánát tu Pol yá tárutang yolop átniráng ingga ket tárák tángga yánuk, “Sán Israel ámna náráwa me kámá káinnan ni Ánutu ináng sákngingngátaráng, kárámatingga nákkán me ná narineráng! ");
INSERT INTO klt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tombong Israel nándán Ánutu watá táwi ilom náni ya nangán pingnga hánám átneráng ingga miuk. Watá ále káwak yáni wa sangga Isip káwak káin kung áturáng wahára wu háláng yámángga árán táwi hánám wa máriuráng. Wata torong káin málámbán háláng táwi hánám wahára kungga ku Isip káinnan yángotang áwuk. ");
INSERT INTO klt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kulá ále komkomá ámálum re káin yara 40 wáina hám áturáng wahára wu Ánutu sárum imánggiuráng, enendu ma yápmanggiuk. ");
INSERT INTO klt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Iná Kenan káwak káin du Ánutu yá Israel háláng yámán ámna náráwa tombong 7 wa ráhángga ku káwak yáni wa yáni ya pukon ihuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ále wa tunggafiuk wawu yara 450 wáina hám wata kinan. “Wata torong hára ku Táwi yá ámna yáilá iháng tunggap tán watá Israel pin yáni tángga árát kungga profet Samuel yan rám háliuk. ");
INSERT INTO klt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Kulá rám wahára wu ámna náráwa yá king gá pin náni táinek ingga met tu Ánutu yá ámna Sol Kis nanggená tombong Benjamin háranan wa yámán du watá pin yáni tángga árán kungga yara 40 háliuk. ");
INSERT INTO klt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kulá wata torong hára king Sol wa yáupmá hára isutang gu Dewit táng watán king tin watá pin yáni tángga átuk. Ánutu yá ámna wata ing yánuk, ‘No Jesi nanggená Dewit wa kangga pahánna álosim naret. Watá ku nákkán pahán káin rina átak wa álo isutnek.’ ");
INSERT INTO klt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kulá ámna watán hun hára kungga ku Ánutu yá Israel son iháháya há miuk wa isutang Jesu san áwuk. ");
INSERT INTO klt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iná Jesu wu yáupmá ma hulátená átuk wahára wu Jon dá pahán hurik tángga umi kuhineráng ingga Israel ámna náráwa yánángga átkuk. ");
INSERT INTO klt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kulá Jon dá yáupmá tángga áwuk watá sálikngingiya tángga átuk wahára ku ing miuk, ‘Nák ku ni ingga naránggoeráng? Nák ku sándá ámna háleng mángga átkoeráng wa muná, ináku ámna wawu nák sárumna káin emá áwinek. Ámna wawu kutná pálak, iná nák ku ámna hánám re, wata ku no watán sendol páupmá wa yayaliyan tárák muná.’ ");
INSERT INTO klt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Yanuknukna, Abraham e ilommá me kámá káinnan Ánutu naráng háting mángngátaráng, sándu ing narineráng, Ánutu yan me watá ámna náráwa son iháháya miuk wawu há san nándán káin áwuk. ");
INSERT INTO klt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem bán ámna náráwa me watán ámna yáilá watá ámna wa kándáng ma naráng muráng, hang profet tá me rina miuráng ga Sabat hára sángingngátaráng wa kándáng hánám ma naruráng. Wáina hálendu kámutnek ingga miuráng, wahára kungga ku uláp profet tá me rina miuráng wata páliná yá pálipuk há tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Watán káin kandák kámá ma káuráng, enendu hánámá táng me hára tingga kámutnek ingga Pailat inuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kulá yáni wu rina rina wa erek tát sálikngiuk wahára kungga ku Jesu hára profet tá rina tunggafeinek ka uyená wata páliná yá kándáng re há tunggafiuk. Wáina táng hálingga ku maripong hára táng sat han du táng kung tanggán káin tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wáina táuráng, enendu há kámutuk waháranan Ánutu yá son táng tárut táuk. ");
INSERT INTO klt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wáina táng tárut tán du ámna náráwa málámbot huphuráp Galili ále sangga Jerusalem káin káman kuráng watá rám máro hánám son káuráng. Kulá rám nahára wu ámna watá ku wáina kanggiumán ingga Juda ámna náráwa yánánggoeráng. ");
INSERT INTO klt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Iná nátá me pingnga álosim sánindemát wawu ing, Ánutu yá ámna náráwa son iháháyan ámna wa táwi ilom náni yámámáya uláp miuk. ");
INSERT INTO klt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Wáina wata ku málámbá Jesu táng tárut táuk wahára kungga ku mená uláp miuk wa tán wata páliná yá nángánangge yáni nándán káin tunggafiuk. Me nányon du Kap Papia sapta 2 hára ing uyená, ‘Kák ku nák Nanggena, kula wu no Nanya hálet.’ ");
INSERT INTO klt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ánutu yá tanggán káinnan há táng tárut táuk, wata ku son kámutang ma pálikngindák, ingga uláp Ánutu yá ing miuk, ‘Na pálipuk hánám sáháng tolingga háláng sáminet, ingga uláp king Dewit wáina táinet ingga há inut.’ ");
INSERT INTO klt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kulá me nukngá káman Kap Papia káin uyená ing átak, ‘Ko ámna rongrongngá hánám nangán ingga narelák wa satá ma pálikngindák.’ ");
INSERT INTO klt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Kulá há naremán, me náwu Dewit ta ma mek. Dewit tá há átuk wahára wu Ánutu yan pahán wa isutang átuk, enendu máriya kámutuk wahára wu táng kung sisi ilommá watán tanggán káin usát tu káwak sut wawu wakáin pálikngiuk. ");
INSERT INTO klt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Iná ámna Ánutu yá tanggán káinnan táng tárut táuk wata sutná wu ma pálikngiuk. ");
INSERT INTO klt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Wáina wata ku, yanuknukna, nátá me ing sánindemát, Jesu yá áwuk wawu mukmuro náni yanyawon da. ");
INSERT INTO klt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ámna wahára kungga ku káman niyá Ánutu naráng háting mineráng wa ámna náráwa kándáng ingga mantáng yáminek, Moses yan meng rákit mená wahára kungga muná. ");
INSERT INTO klt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Wáina wata ku kándáng hánám narángga átneráng, uláp profet tá ing miuráng watá sán hára tunggafeiwon: ");
INSERT INTO klt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ámna me keke nanángngátaráng sán kándáng narineráng, no hulá kámá táe sán orek sáni hára tunggafeinek. Wáina táe kangga hárámutang nangnga sáni han du wáik hálengga kámutneráng. Iná ámna káman dá no wáina táinet wata sánánggim wawu sándu watán me wawu kusák ingga naránggalát.’” ");
INSERT INTO klt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol yá wáina yánángga sangga ku Banabas yot yándi wu miti itná wa sangga kundin ingga tángngárán ámna náráwa yá ing yánuráng, “Sabat nukngá ánu hára wu me wata kátu son náninemálák.” ");
INSERT INTO klt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wáina yánángga miti itná sangga kungga ku tombong Juda háranan me ále kámá káinnan Juda yan miti wa isurená táup hánám watá Pol káling Banabas yásutang kut tu watá Ánutu yá pahán sámánggoek wata naráng hákhátik sáni táng wahára tingga káto hálengga átneráng ingga yánángga iháng káto táumálák. ");
INSERT INTO klt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kulá Sabat nukngá hára wu hála it yáilá waháranan ámna náráwa watá kámuk ingmen miti itná káin Táwi yan me wa nanaráya áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wáina áwáng árát kápángga wata kalán Juda yá pahán yáni wáik hálen du Pol yan me wa táng hang tingga ku me keke miuráng. ");
INSERT INTO klt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wáina tát kápángga ku Pol káling Banabas yá ma pitáená ing yánumálák, “Ánutu yá ing nánuk, ‘Me wawu Juda kálak yáninemálák,’ wata ku wáina há táumát, enendu sándá ku me wa sárum imángga átkuku sásáliná muná tátáya takta naránggoeráng, wata ku nát tu Juda sán sápmangga hurik tángga kámá káinnan watán káin kungga Táwi yan me wa yáninemát. ");
INSERT INTO klt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wáina táinemát wawu náuta Táwi málámbá ing nánuk wata, ‘No táe kák ku ámna náráwa ále kámá káinnan watán yamá ya átnelák. Wáina árátá ku káwakngá káwakngá yan ámna náráwa yá kangga ku no son iháháyan kálu wa narineráng.’” ");
INSERT INTO klt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wáina men ámna náráwa kámá káinnan watá me wa narángga pahán yáni álosim hánám hálen Táwi yan me wata heronge hánám narángga áturáng. Wáina narángga átang gu ámna náráwa Ánutu yá átkuku sásáliná muná wa há táineráng ingga iháng tunggap táuk watá ku Táwi ya naráng háting muráng. ");
INSERT INTO klt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kulá wahára átang gu Táwi yan me watá ále ore wakáin erek ingmen kung háliuk. ");
INSERT INTO klt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wáina kangga ku Juda ámna yá náráwa kut yáni árená Juda yan miti isutang háená, me it yáilá yan ámna yáilá waháranan wa pahán yáni seng tárut tát tu Pol káling Banabas iháng káyam tángga ku ále wahára yásuturáng. ");
INSERT INTO klt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wáina tát kápángga ku ámna náráwa yá me yá nányot átak ingga nanará wata yándi wu háram yándi káin káwak káhumá wa káting halin han du hangga it táwi Aikoniam ba kumálák. ");
INSERT INTO klt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kulá ámna yará wawu hangga kumálák, enendu Iruk Káungá yá Antiok ámna náráwa Jesu ya naráng háting mená wa ep táwi hánám ihán heronge hánám naruráng. ");
INSERT INTO klt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol káling Banabas yá Aikoniam káin du Antiok káin táumálák wáinanyon Juda yan miti itná kinan árángga Táwi yan me kándáng hánám yánán Juda me Grik ámna náráwa táup hánám watá Jesu ya naráng háting muráng. ");
INSERT INTO klt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kámá yá wáina tát Juda kámá Jesu ya ma naráng háting muráng watá ámna náráwa kámá káinnan wata pahán yánin hat tu watá ni Jesu ya naráng háting muráng wata pahán káráp táng yámuráng. ");
INSERT INTO klt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol káling Banabas wu Aikoniam káin rám hásák sim átang ma pitáená Táwi yá ámna náráwa pahán yámánggoek wata yánángga árán du Táwi málámbá háláng yámán ket tárák hulá hulá táumálák. Wahára kungga ku Táwi yá ámna yará watán me wu pálipuk ingga ámna náráwa yálenggiuk. ");
INSERT INTO klt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wáina yálenggiuk, enendu it watán ámna náráwa watá ku horengga kámá yá Juda yot árát kámá yá ku aposel yará watyot áturáng. ");
INSERT INTO klt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wáina tángga átang gu Juda yá ámna yáilá yáni yot hang ámna kámá káinnan watá aposel yará wa ket ihángga sup mangga ráháng kátkámut tánin ingga me hároturáng. ");
INSERT INTO klt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wáina tángga árát tu ámna yará wawu wáina ingga met há narángga ku sokmuná hánám it yáilá sangga kungga Likonia distrik kán it táwi yará Listra yot Debe wakáin kumálák. Wakáin du it táwi yará watyot it nukngá wata tangtang káin átaráng ");
INSERT INTO klt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","wahára me pingnga álosim wa yánángga átkumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kulá Listra káin du ámna káman hárammá kámurená átnándak. Ámna wawu mam kinan átang tunggafiuk ngáyá wáina re átang kung áwáng kámá ma tángngátak. ");
INSERT INTO klt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pol málám Táwi yan me mengga árán ámna watá watán me narángga átnárán Pol yá kárek ingmen káuk ku álo háháleyan naráng hákhátik wahára árán kangga ku ");
INSERT INTO klt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","mantángga inuk, “Tárulák!” ing inán du wahára re ámna watá hip hánám tárutang kung áwáng táuk. ");
INSERT INTO klt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kulá ámna náráwa káwan táwi watá Pol yá rina táuk wa kangga ku Likonia me kálu ing mantáuráng, “Ánutu náni yá ámna nangge hálengga alek kálu nándán káin háemálák!” ");
INSERT INTO klt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wáina mengga ku Banabas ya ing miuráng, “Wawu ánutu yáin yáni Sus wa hám.” Iná Pol ya ing miuráng, “Ámna wawu me yan, wata ku ánutu Hermes wa hám.” ");
INSERT INTO klt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ánutu Sus watán miti itná wu it táwi watán kumbi tangtang kep kálu wahára átnándak. Kulá Sus watán pris yot ámna náráwa yá ámna yará wata towet sing yámánin ingga mengga sat árán pris yá kung bulmakau ámnaná kámá yot álesak kámá ihángga it táwi watán kálu mungnga káin áwuk. ");
INSERT INTO klt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wáina tát aposel yará Banabas káling Pol yá wáina táinderáng ingga narángga hárámutang lap yándi tánggánená wa ráráhángga hururung ingmen urum táwi áturáng wata orek yáni káin kungga ing mantángga yánumálák, ");
INSERT INTO klt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yanuknuk, wa saniráng! Náuta ku wáina tánggoeráng? Nát tu sáni inanyon ámna nangge re. Nát tu me pingnga álosim sánáte ku sándá kutná kutná átkuku yáni muná ále hánám wa yápmangga ku Ánutu átkukuná pálak watán káin kukuya tánggoemát. Watá ku alek, káwak me táp wa men tunggafet wata kinan kutná kutná wa men tunggafiuráng. ");
INSERT INTO klt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Uláp ámna náráwa káwakngá káwakngá átaráng wa yápman watá yánin pahán isutang átkuráng. ");
INSERT INTO klt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wáina áturáng enendu málámbá málám táng kilak ma san átuk. Rámá rámá wu ket tárák álosim wa sálenggoek wawu ing, ále yá tangga áwánggoek me sungi tán álosim áráng het tu sungi táup hánám átsámánggoek, wata pahán sáni yá heronge naránggoeráng,” wáina ingga yánumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kulá yándi wu me wa há yánumálák, enendu yándi ya towet sing yámámáya káto hálengga árát tu olet yáni man sasaya wu yáup háláng hánám wa táumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kulá átang árongga ku Juda kámá it yáilá Antiok me Aikoniam nan áwuráng ngáyá áwáng it táwi Listra nan ámna náráwa wa pahán yánin hat tu Pol táng káyam táuráng. Wáina tángga sup mangga Pol utang sat han há kámutak ingga narángga ku Pol táng uyingga táng kung it kumbiná kep káin tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wáina sat árán du ámna náráwa Jesu ya naráng háting mángga áturáng watá áwáng áwálák hetang árát tu Pol yá tárutang kung it táwi wata kinan son kung háuk. Kulá tembátnáya ku Pol málám Banabas yot it táwi Debe ya kumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kulá Debe káin du me pingnga álosim wa yánán du ámna náráwa táup hánám watá narángga Táwi yan ámna náráwa háliuráng. Wáina tát tu yándi wu son Listra, Aikoniam me Antiok ka kumálák ");
INSERT INTO klt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ngáyá kung wakáin Táwi yan ámna náráwa wa iháng káto tángga ku naráng hákhátik hára káto átneráng ingga mengga ing yángyánáng kumálák, “Ánutu yan átkuku wata kinan hahaya ku márapmá táwi yon kálak sungga ku kung háinemán.” ");
INSERT INTO klt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol káling Banabas yá ámna yáni hulá miti itná káman káman dán iháng tunggap táng yámumálák. Wáina tángga ku sungi sangga sáponga táumálák wahára kungga ku ámna yáni hulá wa iháng Táwi ketná hára tiumálák. Wáina táumálák, náuta ámna yáni hulá yá Táwi ya naráng háting muráng wata. ");
INSERT INTO klt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Yándi wu wáina tángga sangga ku Pisidia distrik wa sangga Pamfilia distrik káin kumálák ");
INSERT INTO klt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ngáyá it yáilá Pega káin Táwi yan me wa yánángga sangga ku kung it táwi Atalia káin háumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia káin átang gu kilang hára árángga Antiok ka kumálák. It waháranan dá ku huphuráp Ánutu yá pahán yámángga háláng yámán yáup tángga átkuku ya yándi iháng Ánutu ketná hára tiuráng. Iná yándi wu yáup yándi táng hálingga ku wakáin yon son áwumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kulá wahára átang gu ámna náráwa Jesu ya naráng háting mená wa men áwát tu Ánutu yá háláng yámán rina táumálák, me málámba naráng hákhátik kán kálu sareng yámán ámna náráwa kámá káinnan watá álo isusut wata yánumálák. ");
INSERT INTO klt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wáina tángga ku it wahára rám hásák kon watyot átumálák. ");
INSERT INTO klt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ámna kámá Judia kálu hangga it yáilá Antiok wata kinan Táwi yan ámna náráwa ing yánáng tolingga kuráng, “Sándá Moses yan kálu wa isutang kep sáni marineráng wawu álo kámá, iná ma marindáráng wawu Ánutu yá sán son ma sáhindák.” ");
INSERT INTO klt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wáina yánángga kut Pol káling Banabas yá wa kan kándáng ma hálen wata menmen ná táwi táuráng. Wáina tát tu Táwi yan ámna náráwa yá Pol káling Banabas iháng tunggap tát it márumá Táwi yan pingnga áturáng waháranan kámá yot Jerusalem káin aposel yot miti itná yan ámna yáilá kápángga me wa táng totoliya árángga kuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Táwi yan ámna náráwa yá ámna yará wa suring yámát Fonisia ále kálu kungga Samaria ále kálu kungkung gu kálu ya Táwi yan ámna náráwa wakáin Ánutu yá ále kámá káinnan pahán yáni iháng hurik táuk ingga yánángga kun narát álosim hánám háliuk. ");
INSERT INTO klt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kungga Jerusalem káin kung hiuráng wahára wu Táwi yan ámna náráwa me aposel me ámna yáilá wakáin áturáng watá heronge me yánángga yángot kung tiuráng. Kulá wahára átang gu Pol káling Banabas yá Ánutu yá háláng yámán tárák rina rina tángngátamálák wa wáina ingga pingnga yánumálák. ");
INSERT INTO klt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wáina yánán narángga ku Táwi yan ámna kámá tombong Farisi háranan watá tárutang miuráng, “Ále kámá káinnan dá Táwi yan tombong háháleya ku kep yáni marángga ku áwáng nán kinan hangga ku Moses yan meng rákit mená átaráng wa kámuk hánám isutneráng.” ");
INSERT INTO klt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iná aposel yot ámna yáilá yá ku urum tángga me retá ku kándáng ingga wa táng totoliya táuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ámna urum bá me hásák metángga inán kanán táng hálingga sangga wu Pita yá tárutang yánuk, “Yanuknukna, sáni há nareráng wa, huphuráp Ánutu yá tombong nán háranan yáup káman tátáyan neháng tunggap tángga nanuk wawu ing, ‘Kák milunya káinnan du nákkán me pingnga álosim wa ále kámá káinnan dá narángga ku nák ka naráng háting namineráng,’ ingga nanuk. ");
INSERT INTO klt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ánutu wawu ámna náráwa kámuk ka pahán yáni wa kangngátak, wata ku málám ále kámá káinnan da pahán yáni wa kang hálingga ku Iruk Káungá wa yámuk, wawu nán námuk wáinanyon. Tárák watá ku ing hiták hánám náliuk, Táwi yá wata pahálá heronge naráng yámángga ku málámbán pingnga háháleya ihuk. ");
INSERT INTO klt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Málám nán me wa orek náni hára tárák nukngá kámá ma táuk, ináku tárák wáina re táuk. Yáni málámba naráng háting muráng wata tángga ku pahán yáni yawolán málámba rahálá hára rongrongngá háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Wáina wata ku kula wu rina tángga ku kandák ingga há nangnaráng gu Ánutu yá tárák rina tán kanin ingga tánggoeráng? Márapmá táwi uláp táwi ilom náni áturáng watá ma susuwáyan me náni hányon ma susuwáyan wa táng Táwi yan ámna náráwa hit yáni hára ma suwáng yámindaráng. ");
INSERT INTO klt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wáina tátáyan du ma hánám árak! Náni ing há naremán wa, Táwi náni Jesu yá pahán námuk wata tángga ku Ánutu yá son náhuk, wáinanyon ámna náráwa ále kámá káinnan wa son ihuk.” ");
INSERT INTO klt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita yá wáina men du Banabas káling Pol yá Ánutu yá háláng yámán tárák rina rina ále kámá káinnan da orek yáni káin táumálák wata urum wa yánumálák. Ámna kaláhu watá me wa yánángga áturáng wahára wu ámna náráwa áturáng watá me yáni ma me táená náng hánám átang narángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kulá watá meng hálin du Jeims Táwi kulaná yá yánuk, “Yanuknukna, kárámatingga narániráng. ");
INSERT INTO klt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ánutu yá hulátingga ále kámá káinnan ámna náráwa kámá urák yáni narángga ihán málámbán pingnga háliuráng ngáya Saimon dá há sánán nareráng. ");
INSERT INTO klt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hang profet kámuk kán me wu wáinanyon uyená. Profet waháranan káman dá ku ing uyiuk, ");
INSERT INTO klt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Dewit ráula wawu sel it tá ina táwatang háená. Máriya son áwinet wahára wu sel it wa son táng tárut tángga táng tolinet. Kámuk hánám wáik hálengga táwatang háuk wa son tárákngá wáinanyon hánám táng tolinet. ");
INSERT INTO klt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Wáina táe ku ámna náráwa ále kámá káinnan átaráng, nini no nangán ingga iháng tunggap táut, watá ku naya suling namineráng. Me náwu Táwi yan me. Málámbáyon du ále wa tán tunggafenggoeráng.’ ");
INSERT INTO klt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Uláp hánám bon wáina tunggafeinek ingga há men ámna náráwa yá naruráng. Ingga profet tá wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Wata ku nákkán nanará ku ing, nándá tátne ále kámá káinnan dá hurik tángga Ánutu yan káin áwángga átaráng watán kálu yá susuwá ná ma háleindak. ");
INSERT INTO klt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Iná nándá ku me uyingga satne watán káin kun du ing yáninemán, sungi songgo ánutu kusák ka towet sing mená ma náindaráng, márámamák hára ma kuindaráng, hang songgo san yáni hára iháng kátkámut táená wata yánum yáni me songgo yánumá hára sip pá há árán kangkang wa ma náindaráng. ");
INSERT INTO klt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kálu wáina isutneráng wawu uláp hánám átang áwángga it wakáin wakáin Moses yan meng rákit me há mengga narángngátaráng wata, me inggálu rámá rámá Sabat hára miti itná átaráng wata kinan há sángingga naránggoeráng wata.” ");
INSERT INTO klt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kulá aposel yá ámna yáilá yot ámna náráwa Jesu yan tombong háliuráng watyot yáni háranan ámna yará iháng tunggap tát tu watá Pol káling Banabas yot Antiok káin kuráng. Ámna yará iháng tunggap táuráng wawu Judas kutná nukngá Barsabas watyot Sailas. Ámna yará wawu ámna yáilá áturáng waháranan. ");
INSERT INTO klt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Papia ku ing uyiuráng: Nán aposel me ámna yáilá yanuknuk sáni watá papia ná uyingga satne yanuknuk náni ále kámá káinnan Antiok kinan me Siria provins yot Silisia provins káin átaráng sándán káin koek. Káe álo, yanuknuk náni. ");
INSERT INTO klt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Pingnga ing narumán, Juda nán háranan ámna kámá yá kung me sánuráng watá sán nanará sáni táng yakyawák táuk. Wáina táuráng wawu nándá wáina táineráng ingga ma yánumán. ");
INSERT INTO klt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pingnga wa narángga ku nándá pahán káman hálendu ámna yará ná iháng tunggap tángga ku suring yámátne nuk náni yará álosim Banabas káling Pol yot sándán káin koeráng. ");
INSERT INTO klt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabas káling Pol wawu kátkámut ta ma pitáená Táwi náni Jesu ámna náráwa son iháhá wata kutná meng tárut tátáya átningngátamálák. ");
INSERT INTO klt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wáina wata ku nándá Judas káling Sailas suring yámátne kung yándi ya milun yándi hára hánám me rina uyemán wa pálipuk ingga sáninemálák. ");
INSERT INTO klt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Iruk Káungá watá nándán káin árán du nándá me ing hárotamán, wawu nándá márapmá táwi wa táng sán ketnán ma tindámán, ináku kálu ing wa rewe isutneráng. ");
INSERT INTO klt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sungi songgo ánutu kusák ka towet sing mená ma náindaráng, songgo yánumá hára sip pá há árán kangkang wa ma náindaráng, songgo san yáni hára iháng kátkámut táená wata yánum yáni wa ma náindaráng, hang márámamák hára ma kuindaráng. Kálu wáina wa kápángga iháng hátineráng watá ku álosim. Nándán me ku wa rewe. Kándáng gon átneráng. ");
INSERT INTO klt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kulá yáni wu ámna wa suring yámát kung Antiok káin hangga ámna náráwa Jesu yan tombong wa iháng urum tángga ku papia wa yámuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Yámát ámna náráwa yá papia wa sángingga naruráng wawu yáni iháng káto tátáyan mená hálendu heronge hánám wa táuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas káling Sailas yándi wu profet hálendu me álolosim kámá yanuknuk yándi wa yánángga iháng káto táumálák. ");
INSERT INTO klt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Wahára rám kámá átang sangga ku pahán láláp me watyot yanuknuk yándi watá son suring yámát rendá suring yámát áwumálák wakáin yon kumálák. ");
INSERT INTO klt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Iná Pol káling Banabas wu Antiok káin átang gu ámna táup pot Ánutu yan me ámna náráwa yánáng tolingga me pingnga álosim wa yánángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Rám kámá átang sangga ku Pol yá Banabas ing inuk, “Náti wu son kungga yanuknuk náti it rehára rehára Ánutu yan me yánángga átkumát wa rina átaráng ingga kápángga átkundin.” ");
INSERT INTO klt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Wáina inán Banabas yá ku Jon kutná nukngá Mak wa tángga watyot káman yáni kukuya narángga ku miuk, ");
INSERT INTO klt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","enendu Pol yá wa narán kándáng ma háliuk, náuta huphuráp Mak kot káman kungga Pamfilia distrik káin kung hiuráng wahára wu Mak ká yáup káman tángga átkunin ingga ma narená ámna yará wa yápmangga hánámá ná hálen há káuk wata. ");
INSERT INTO klt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wáina hálendu yándi wu wata menmen ná tángga sangga ku horengga Banabas yá Mak kot kilang tángga ailan Saiprus ya kumálák, ");
INSERT INTO klt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","iná Pol yá ku Sailas táng tunggap tángga málámbot káman kukuya tán du Táwi yan ámna náráwa watá yánuráng, “Táwi yan pahán láláp watá sányot átnek,” ingga yánuráng. ");
INSERT INTO klt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yándi wu kungga Pol yá Siria me Silisia provins káin Jesu yan tombong hálengga áturáng wa iháng káto tángga átkuk. ");
INSERT INTO klt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol málám it yáilá Debe káin kung átang sangga ku kungga it táwi Listra káin kuk. Disaepel káman kutná Timoti wawu Listra wakáin átnándak. Maming gu Juda náráwa Jesu ya hányon naráng háting mángngátak, iná naning gu tombong Grik háranan. ");
INSERT INTO klt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ámna náráwa Táwi yan pingnga hálengga árená Listra nan me Aikoniam nan watá Timoti wawu ámna álosim ingga meng toling mángngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol yá Timoti yot kukuya narángga ku Timoti kipmá maruk, náuta Juda ámna náráwa ále wakáin átaráng wawu há nareráng Timoti naning wawu Grik nan ingga. Wáina maráng mángga átang sangga ku káman yáni átkuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kulá yáni wu it wahára kungkung tángga átkuráng wahára wu aposel me ámna yáilá yá Jerusalem káin Táwi yan ámna náráwa yá me rina isusut ta hároturáng wa yánángga átkuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Wáina tángga átkut tu Jesu yan pingnga áturáng wata naráng hákhátik yáni yá káto hálen du rámá rámá ámna náráwa yá áwáng waháranyon sengsáráp tit tu tombong hásák hálengga átuk. ");
INSERT INTO klt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol, Sailas, me Timoti watá kungga ále Frigia yot Galesia wata kinan átkuráng, náuta Iruk Káungá watá Esia provins wata kinan Táwi yan me wa ma yánánáya káto táng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yáni wu kungga distrik Misia yan tawon hára kung hengga ku kung Bitinia provins kinan kung hanin ingga táuráng, enendu Jesu yan Iruk watá káto táng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Wáina hálendu Misia kálu kungga it táwi Troas káin kung háuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kulá yáungán du Pol yá ára hára ina káuk ku Masedonia provins ámna káman dá hetang átang ukuro kálu Pol ing inuk, “Táp táng hátingga Masedonia káin ná áwángga ku nán háláng námáng.” ");
INSERT INTO klt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol yá ára ina wa kan du nándá Ánutu yá málámbán me pingnga álosim wa Masedonia káin yánánáya mantáng námek ingga narángga ku sopmuná ingmen wakáin kukuya tiyawiumán. ");
INSERT INTO klt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wáina tiyawing hálingga ku kilang kinan árángga kutne ku kilang gá náhángga Troas sangga ailan Samotres káin kándáng hánám kuk ngáya ku tembátnáya ku it táwi Neapolis káin náháng kung nápmáuk. ");
INSERT INTO klt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kulá waháranan dá ku Filipai káin kung hiumán, it yáilá wawu huphuráp pon Rom ámna náráwa yá áwáng wahára átkiuráng. Iná it yáilá Filipai wawu Masedonia provins yan distrik káman wata kinan du it yáilá táwi hánám. It yáilá wahára rám máro yon átumán. ");
INSERT INTO klt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kulá Sabat hára wu kome kámá kangga sáponga tátáya it yáilá yan kumbi kálu mungnganá táwi hára kungga kep káin hangga umi kurat káman káin kumán. Umi káin wa kungga ku náráwa kámá umi kurat tákto káin urum árát kápángga ku watyot putung átang meme tángga átang gu wakáin Táwi yan me pingnga álosim wa yánumán. ");
INSERT INTO klt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Me wa yánángga árátne ku wa kárámatingga áturáng waháranan náráwa káman kutná Lidia wawu káman yáni átang me wa narángga átkiuk. Náráwa Lidia wawu it táwi Taiataira nan. Málám lap sipmá yá sup yáupmá tángngátak. Iná málám bu Ánutu ináng sákngingga átnándak. Rám wahára Táwi yá pahálá yan kálu yalin málám Pol yá me yánuk wa narángga pahálá hurik táuk. ");
INSERT INTO klt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Málám me niyá málámbot itná kinan átnándaráng watá kámuk umi kuhángga ku nándá itná káin kukuya nánuk, “Sándá nák ka pálipuk Táwi ya naráng háting mek ingga narángga ku áwát nákkot nákkán it káin átnemán,” wáina men nándá álo kuinemán ingga inumán. ");
INSERT INTO klt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Rám káman nándá sáponga tátáyan komená káin son kungga átang gu yáup náráwa káman kálu hára káumán. Náráwa wawu iruk káman dá tán máriya kutná kutná rina tunggafeinek wa meng tunggap tángngátak. Ámna ren wa pinná tángngátaráng watá náráwa watá yáup wáina tán du wahára kungga sup táwi hánám ihángngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Náráwa watá Pol yot nán násutang kunggatang gu ing mantángga kuk, “Ámna náwu Ánutu Árená Hánám watán yáup nangge, watá ku kálu rekálu Ánutu yá son sáhánggim wata menggoeráng.” ");
INSERT INTO klt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kulá náráwa watá rám máro hánám wáina re tángngárán du Pol yá taktak mán hurik tángga ku iruk wa inuk, “Jesu ámna náráwa son iháhá wata kutná hára ing kanin, ko náráwa wa sangga kung!” Wáina inán rám waháranyon iruk watá náráwa wa sangga kuk. ");
INSERT INTO klt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wáina kangga náráwa wata márumá hálengga átang yáup náráwa watá yáup tán sup ihángga átnándaráng watá muná hálen kangga ku Pol káling Sailas ket ihángga iháng uyingga átang maket komená káin ");
INSERT INTO klt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","me nanará ámna yan káin kungga ku ing yánuráng, “Ámna yará náwu Juda nan watá áwáng nándán it yáilá náta kinan márapmá hulá hulá wa tán tunggafenggoek. ");
INSERT INTO klt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hang ámna náráwa kámá iháng uying kung kálu kámá Rom ámna náráwa nándá ma tátáya mená wahára tinggoemálák.” ");
INSERT INTO klt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wáina met ámna náráwa áwáng wahára urum táuráng watá me kusák wa mengga iháng wata ketnán yon tit tu me nanará ámna yá ámna kámá yánát sut yándi tánggánená wa yaling yámángga ku honggem bá táup hánám ráhuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wáina ráhát tu me nanará ámna yá yánát iháng kalabus kinan tiuráng. Wáina tingga ku me káto hánám kalabus wa pinná tátá ing inuráng, “Ámna yará wa kándáng hánám pin yándi táinelák.” ");
INSERT INTO klt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Me nanará ámna yá me wáina inát tu kalabus pinná tátá watá iháng it pahálá kinan hánám káin wa tingga ku háram yándi wa iháng palang got tingga káto hárotuk. ");
INSERT INTO klt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Wáina átang gu Pol káling Sailas yándi wu kap sáponga tán Ánutu yan káin kungga árán kungga yáung táitná hánám hálengga átuk. Wáina tángga árán du ámna kalabus kinan ting sat árená watá wa narángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wáina narángga átnárát tu kánggáning maming táwi hánám bá tángga kalabus itná tátáya hulátingga sup hálángngá ya tená wa muwalán it kálu mungnganá yá hung yalingga kut kalabus wata kinan ámna sen dá káto iháng hárorená sen watá sohiuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Waháranyon kalabus itná wa pinná tátá málám ruhángga átang tárutang káuk ku it kálu mungnganá yá ang re tángga árát tu ámna wakáinnan du erek hangga kung háleráng ingga narángga ku kápik táng málámbon topmeng kámut táin ingga táuk. ");
INSERT INTO klt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wáina tán kangga Pol yá mantáuk, “Ko kayon sutya ma utnándalák! Nán kámuk há átamán!” ");
INSERT INTO klt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kalabus it wa pinná tátá málám kup tángga áwániráng ingga ámna kámá mantángga yánángga ku sopmuná ingmen it pahálá Pol káling Sailas yá átumálák wakáin pitángga yángyáng pálak kung háram yándi hulá hára turingga háuk. ");
INSERT INTO klt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wáina tángga ku kalabus it pinná tátá málám ámna yará wa yángotang kalabus itná sangga kep káin hangga ku yánuk, “Ámna hulá yará, rina táe ku Ánutu yá son nehinek?” ");
INSERT INTO klt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wáina yánán du watá inumálák, “Táwi Jesu wa naráng háting mátá ku Ánutu yá son kehinek, ka me tombongga itya káin átaráng watyot kámuk sáhinek.” ");
INSERT INTO klt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wáina inángga ku Táwi yan me wa inumálák, me tombongngá itná káin átnándaráng watá áwát wa hányon yánumálák. ");
INSERT INTO klt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yáungán wahára re ku yángot kung putun yándi wa yawon yámáng hálin du Pol káling Sailas yá málám me tombongngá wa kámuk umi kuháng yámumálák. ");
INSERT INTO klt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wáina tángga ku kalabus pinná tátá watá yángotang kungga itná kinan hangga sungi singga yámuk. Málám me tombongngá yot kámuk hánám Ánutu ya naráng háting muráng wata ingga heronge hánám tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hilápmá yon du me nanará ámna yá lap yáni hátetná suring yámát áwáng kalabus pinná tátá wa inuráng, “Me nanará ámna yá ing meráng, ‘Ámna yará wa yaling yámátá há yándi kundimálák,’” ingga inát tu ");
INSERT INTO klt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","watá Pol inuk, “Me nanará ámna yá ing meráng, ‘Sailas yot sán du álo há sándi kundimálák,’ ing meráng wata ku pahán láláp hára kundimálák.” ");
INSERT INTO klt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wáina yánán du Pol yá lap yáni hátetná wa ing yánuk, “Nát tu Rom ámna, náuta ku ámna me nanará yá hulá wa kándáng ma káená ku rahán hára wa náráhángga náháng kung kalabus kinan tiráng? Kulá kula ku kilak kon nápmat kukuya meráng me? Wa muná hánám! Yáni yon áwángga ku nángotang kep káin háineráng.” ");
INSERT INTO klt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wáina yánán lap yáni hátetná watá son kung me nanará ámna yánát watá Pol káling Sailas wawu Rom nan ingga naruráng hára wu pitáuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Wáina tángga ku me nanará ámna yáni wu kung ukuro me yánángga ku yolopon yángot hang kep káin du it yáilá wa sangga kukuya yánuráng. ");
INSERT INTO klt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kulá Pol káling Sailas yándi wu kalabus wa sangga hangga ku Lidia yan it káin kung nuknuk yándi Táwi yan ámna náráwa wa kápángga me yánángga iháng káto tángga ku hangga há yándi kumálák. ");
INSERT INTO klt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol káling Sailas yándi wu kumálák watá kungga it táwi Amfipolis wahára kung hiumálák ngáyá son sangga kungga it táwi Apolonia káin kung hiumálák ngáyá wa sangga ku son it yáilá Tesalonaika káin kung hiumálák, wakáin du Juda yan miti itná káman átnándak. ");
INSERT INTO klt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kulá wahára ku Pol yá málámbá tángngátak wáina ku kung Sabat kaláhu wawu Juda yot miti itná wata kinan hangga Ánutu yan me wa wáina wáina ingga yánángga inán kanán táuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Málám Ánutu yan me wata hulá wa yánángga ku miuk, “Ánutu yá ámna náráwa son iháháya miuk ámna wawu márapmá sungga kungga kámutang son tátárut ta mená wa isutang wáina há táuk. Iná Jesu wawu Ánutu yá ámna náráwa son iháháya miuk ngáya me pingnganá sánánggoet wa,” ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wáina yánán du Juda áturáng waháranan kámá yá wa narángga pahán yáni hurik tángga Pol káling Sailas hára sengsáráp táuráng. Kulá rám waháranyon Grik nan ámna náráwa táup táwi yon Ánutu ya naráng háting mená watyot náráwa kut yáni árená wáinanyon dá áwáng sengsáráp táuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Iná Juda yáni wu kápuráng gu ámna náráwa táup hánám watá áwáng sengsáráp tát kápángga ku pahán suksuk narángga ámna wáik maket komená káin átnándaráng watyot ámna náráwa kámá yot urum tángga yáni kat táup hálendu pahán yáni seng tátárut tángga kungga kun tátáya menman tángga áturáng. Yáni wu Jeson dán it káin kung Pol káling Sailas kápángga iháng áwáng ámna urum táwi wa yámánin ingga kung it wata kálu mungnganá káting márák táuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Yáni wu wáina tángga ma kápángga ku Jeson yot Jesu yan tombong ámna nukngá wa ket ihángga háting hirat kungkung tángtáng it yáilá watán ámna hulá hulá yan káin kuráng. Kung hengga ku ing mantáuráng, “Ámna yará wawu itná itná káin márapmá hulá hulá táwi tángngátamálák watá rám ore nahára ku áwáng it náni yáilá náta kinan átkoemálák. ");
INSERT INTO klt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Hulátingga áwáng hen du Jeson dá yángot kung itná kinan tiuk. Ámna tombong watá ku Sisa yan meng rákit mená wa yalingga ku king nukngá átak wata kutná ku Jesu ingga menggoeráng.” ");
INSERT INTO klt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wáina yánát it yáilá watán ámna hulá hulá me ámna náráwa urum watá kámuk me wa naruráng hára wu hárámutang menman tángga kuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yáni wu wáina tángga ku Jeson yot nuknukngá ihángga áwuráng wa yánát sup tit tu yápmat kuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kulá it tá yongin du ámna Táwi yan pingnga áturáng watá Pol káling Sailas suring yámát it táwi Beria káin kumálák. Wakáin kung hengga ku yándi wu Juda yan miti itná káin kumálák. ");
INSERT INTO klt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria káin Juda ámna náráwa wawu álo kámá hánám wáina hálendu ket tárák yáni wawu Tesalonaika ámna náráwa iháng hátek, wáina hálendu Pol yan me wa pahán yáni yot kikiná hánám narángga rámá rámá wu Pol yá menggiuk wa pálipuk me rina ingga kakaya Ánutu yan me papia kinan káin sángingga naránggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kulá rám ore wahára ku Juda ámna náráwa táup hánám, hang Grik náráwa kut yáni pálak táup pon, me Grik ámna táup pon watá Jesu ya naráng háting muráng. ");
INSERT INTO klt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Juda ámna Tesalonaika káin átnándaráng watá Pol ku Beria káin Ánutu yan me yánáng tolinggoek ingga met naruráng hára wu wakáin hányon kung ámna náráwa pahán yáni iháng yakyawák tát tu Pol ya kuk naráng mángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wáina tát tu Jesu yan tombong wakáin watá Pol suring mát it káman táp tangtang káin kilang tángga kukuya ámna kámá yot kuráng, iná Sailas káling Timoti yá ku Beria káin há átumálák. ");
INSERT INTO klt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ámna kámá Pol engotang kuráng watá ku engot kung kilang káman hára árángga kungga it yáilá Atens káin kung hiuráng. Kung hengga sangga son kuinán tát tu Pol yá Sailas káling Timoti yá sopmuná hánám áwinemálák ingga yánán du Beria káin son kuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol málám Atens káin háleng yámángga átuk wahára wu pahálá yá táup hánám wáik háliuk, náuta it yáilá wata kinan du ánutu kusák iháng tolená watá táup hánám árát wata. ");
INSERT INTO klt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Wáina hálendu málám kung Juda yan miti itná káin Juda me Grik Ánutu ya naráng háting mená wa Táwi yan me wa wáina wáina ingga yánángga inán kanán tánggiuráng, me rámá rámá kung maket káin áwánggiuráng wa wáinanyon yánángga inán kanán tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nanará ámna urum yará kut yándi Epikurian me Stoik watá áwáng Pol yot menmen tángga ku waháranan kámá yá ing miuráng, “Mená lamlam me táená náwu rina mein ingga me tánggoek?” wáina met waháranan kámá yá ku ing miuráng, “It kámá yan ánutu watán kálu hám átang menggoek,” wáina ingga miuráng wawu náuta Pol yá Jesu yan me pingnga álosim watyot Jesu yá kámutang tárutuk ngáya yánángga átninggiuk wata. ");
INSERT INTO klt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kulá yáni wu Pol engotang kaunsol yan urum kutná Areopagus hára kungga ku ing ináng suliuráng, “Me hurápmá mengga nánáng tolinggoelák wata hulá wa álo nánánggim me rina? ");
INSERT INTO klt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kák ku me hurápmá kámá nán káráman náni káin metá naránggoemán, wata ku me wata hulá ya kándáng nánátá naránin,” ingga wáina ináng suliuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ámna náráwa Atens it márumá me it kámá káinnan áwáng wahára árená watá hánámá yáni átang me hurápmá rina narángngátaráng wata re meme tángga átnándaráng. ");
INSERT INTO klt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wáina met narángga Pol málám Areopagus káin urum tángga áturáng hára wa tárutang miuk, “Atens ámna, no sáhet tu kálu hulá hulá kálu tirik tárák sáni wu ánutu kámá kámá yánáng sákngingi wata tárákngá yá sándán káin táwi hánám árán kanggoet. ");
INSERT INTO klt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","No átningga kutná kutná yánáng sákngingngátaráng wahára kándáng kápángga áwánggoet wahára wu tingnaknak káman árán no kolem káman wahára uyená káut tu ing, ‘Tingnaknak náwu ánutu ma naráng mángmán watán tingnaknak,’ wáina uyená wa sángingga káut. Kulá kula ku no Ánutu ma naráng mená hánámá ináng sákngingngátaráng watán me hiták hánám ing sánindet. ");
INSERT INTO klt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ánutu ni alek me káwak me kutná kutná wata ketnán iháng tunggap táuk wawu alek me káwak kán Táwi. Wáina wata ku ánutu yan it káungá ku ámna yá ket tá táená hára ma átnándak. ");
INSERT INTO klt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Iná wawu náut kámá káman da kesák tán ámna ket tá háláng imámáyan muná, náuta ámna náráwa átkuku me iruk uyiyi me kutná kutná átaráng wawu málámbáyon námángngátak. ");
INSERT INTO klt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hulátingga ku ámna káman dá re árán waháranan du Táwi yá tán ámna náráwa tombong kámuk hánám watá tunggafiuráng. Málámbáyon iháng káwak wakáin wakáin erek ting hálingga ku rám wahára ku háláng yáni tin tárutneráng me háláng yáni han háineráng ingga rám wa ting yámángga ku ále ore wahára wahára átneráng ingga tawon ting yámámá táuk. ");
INSERT INTO klt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ánutu yá wáina táuk wawu ámna náráwa kámá yá málámba suling kung kang tunggap tátáya táineráng me kálan suling kung tánggagaya táineráng, enendu málám bu nán káman káman nápmang kung mulangán káin ma árak. ");
INSERT INTO klt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Ma átnát háranan watá pálipuk há átang iháng kongkong tángga átkoemán watá hulá ku málám re.’ Sánin nanará ámna kámá yá ing há miuráng wáina, ‘Nándu málám háranan tunggafená.’ ");
INSERT INTO klt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kulá nándu Ánutu háranan tunggafená wata ku nándá málám wawu gol, silva me sup ina ingga ma narindamán, me málám wawu ámna nangge yá náut kámá utniná yánin nanará isutang táng tolená ina ingga ma narindamán. ");
INSERT INTO klt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Uláp pu ámna yá Ánutu wáina átak ingga ma naráng mená átang gu ket tárák rina rina tánggiuráng wata mená ma tánggiuk. Iná inggálu wawu itná itná káin ámna náráwa átaráng watá pahán hurik há hánám táineráng ingga menggoek. ");
INSERT INTO klt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Málámbá rám káman há táng tunggap táuk wahára ku ámna há táng tunggap táuk watá kálu kándáng wahára re ámna náráwa kámuk hánám iháng horeinek. Ánutu málámbá ámna wa há kámutuk háranan táng tárut tán nándá kangga ku Ánutu yá ámna wawu yáup wa tátáya imuk ingga nanaráya wáina táuk.” ");
INSERT INTO klt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wáina yánán me kámurená háranan dá tárutuk wa naruráng hára wu kámá yá ináng hikhilek tát kámá yá ku me wata hulá rám nukngá son metá narinemán ingga inuráng. ");
INSERT INTO klt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wáina inát tu Pol yá kaunsol wa yápmangga hangga háná kuk. ");
INSERT INTO klt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Urum wahára ku ámna náráwa kámá yá Pol yá me miuk wa narángga Pol hára sengsáráp tángga Jesu ya naráng háting muráng. Ámna káman kutná ku Dionisius ámna wawu kaunsol urum waháranan, hang náráwa káman kutná Damaris watyot ámna náráwa kámá hányon watá Jesu yan tombong háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Máriya ku Pol yá Atens sangga it yáilá Korin káin kuk. ");
INSERT INTO klt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pol málám wakáin kung Juda ámna káman kutná Akuila watyot áwáná kutná Prisila wa kápuk. Ámna watán it hulá ku Pontus provins wakáinnan. Huphuráp sim Rom bán king Klaudius yá Juda sán kámuk hánám it yáilá Rom sangga há sáni kung hálineráng ingga yánuk, wata ku Akuila káling Prisila yá káwak Itali sangga áwáng Korin hára átnándamálák. ");
INSERT INTO klt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kulá Pol wu it tátáyan sel rákákáre wawu há narek. Ámna náráwa yará wawu wáinanyon wáina hálendu Pol yá kung watyot átang yáup wa tángga átnándaráng. ");
INSERT INTO klt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Rámá rámá Sabat hára wu Juda yan miti itná káin kung Juda me Grik pahán yáni seng tárut tán du Jesu ya naráng háting mámáya ingga Táwi yan me yánáng tolinggiuk. ");
INSERT INTO klt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kulá Sailas káling Timoti yá Masedonia provins káin átang áwán du Pol yá son rámá rámá Táwi yan me wa ámna náráwa yánángga átkiuk. Málám Juda wa ing yánánggiuk, “Jesu wawu Ánutu yá ámna náráwaná son iháháya suring mán áwuk.” ");
INSERT INTO klt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wáina yánángga árán Juda yá watán me wa nanaráya táng taktak tángga táng káyam tángga ináng kekkek tát tu málám lapmá káin sinsin wa irung hirarán han du ing yánuk, “Iná sándá muná kuineráng wawu sáni hára re átak, wata kátu yá nák ma nehindák. Rám kula hulátingga ku sápmangga kungga ámna náráwa tombong kámá káinnan watán káin kuinet.” ");
INSERT INTO klt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wáina yánángga ku Pol málám miti itná wa sangga ámna káman kutná Titius Jastus watán it tá miti itná tangtang árán du wahára kuk. Ámna wawu Ánutu ináng sákngingngátak. ");
INSERT INTO klt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ámna káman kutná Krispus wawu Juda yan miti itná watán ámna yáilá. Málám me itná káin ámna náráwa árená watyot Táwi ya naráng háting muráng. Hang Korin nan táup pá yon Pol yan me narángga Táwi ya naráng háting mángga umi kuhuráng. ");
INSERT INTO klt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Rám káman du yáungán ára hára ina Táwi yá Pol ing inuk, “Ma pitáindalák. Táwi yan me há re mengga kungga átnelák, me ma nángnángingga átnándalák. ");
INSERT INTO klt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nák ku kákkot átat. Káman dá áwáng kák keháng lem ma táindák, náuta nákkán ámna náráwa táup hánám watá it yáilá nahára átaráng.” ");
INSERT INTO klt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Wáina inán du Pol málám wahára yara káman yap 6 wáina átang Ánutu yan me wa yánáng tolingga átuk. ");
INSERT INTO klt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kulá ámna kutná Galio watá Akaia provins watán kawana hálengga átuk hára wu Juda yá káman hálengga Pol táng káyam tángga ku táng kung me hára titiya kawana Galio yan káin kuráng. ");
INSERT INTO klt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kung wakáin du ing miuráng, “Ámna nátá ku meng rákit me yá rina mek wa sangga ku Ánutu ya tárák kámá kálu ináng sákngingiya ámna náráwa yánánggoek.” ");
INSERT INTO klt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Wáina met Pol yá me mein ingga táuk waháranyon du Galio yá Juda yánuk, “Juda sándá ámna nátá Rom bán me páilák hitik tán me márapmá táwi kámá tán wata met hálen wawu no sándán me narinet. ");
INSERT INTO klt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Iná ámna ná engotang áweráng wawu ing wata, Juda sánin me, hang kut kámá sánin miti kinan mená, hang sánin meng rákit me wata menmen ná watyot tángngátaráng, wata ku no yáilá átang sándán me ná ma narindát. Sáni re átang gu wa táng tolineráng.” ");
INSERT INTO klt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wáina yánángga ku me nanará komená sangga há sáni kuniráng ingga yánángga yásutnárán, ");
INSERT INTO klt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","waháranyon Korin ámna yá ámna kutná Sostenes Juda yan miti itná yan ámna hulá wa me nanará kapme hára káto tángga uturáng. Wáina tát kápuk enendu Galio yá wata urákngá kámá ma narená yolopmá yon átang kápángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol málám rám táwi sim bon Korin káin átang sangga ku Táwi yan ámna náráwa wakáin wa yápmangga kuk. Kulá Siria provins ya kukuya tángga ku Prisila káling Akuila yot kung it táwi Senkria káin kilang hára árángga kunin ingga kuráng. Kung wahára átang gu Pol yá Ánutu yan káin me káto káman miuk ngáya wata ingga yáilá rommá san átnándak wa maruk. Wáina tát tu kilang hára árángga ku kuk. ");
INSERT INTO klt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kulá it yáila Efesus káin kung hengga ku Prisila káling Akuila yápmangga málám re kung Juda yan miti itná kinan hangga Táwi yan me yánángga inán kanán táuráng. ");
INSERT INTO klt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wáina tán du watá nányot rám kimo átang kuinelák ingga inuráng, enendu Pol yá muná ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Málám kuin ingga ku yánuk, “Ánutu yá álo ingga men hálendu kungga son áwinet.” Wáina yánángga ku kilang hára árángga Efesus sangga kuk. ");
INSERT INTO klt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Málám it yáilá Sisaria káin kung hengga ku árángga Jerusalem káin kung Táwi yan ámna náráwa wakáin wa pahán láláp mená yánángga sangga ku Antiok káin kung háuk. ");
INSERT INTO klt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol yá kung Antiok káin rám hásák sim átang sangga ku ále Galesia yot Frigia kinan it wahára wahára kungkung tángga Táwi yan ámna náráwa wa iháng káto tángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Rám ore waháranyon Juda ámna káman kutná Apolos wawu itná hulá ku it yáilá Aleksandria waháranan watá ku Efesus káin kuk. Ámna wawu nanaráná álosim hang Ánutu yan me wa kándáng hánám narek. ");
INSERT INTO klt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ámna wawu Táwi yan kálu wa kándáng hánám ináng tolená, iná ámna wawu kámá yánáng totoliya kikiná narángga ku Jesu yá rina táuk wa rewe kándáng hánám yánángngátak, enendu Jon dá umi yá kuháng yámuk wa rewe narek. ");
INSERT INTO klt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos málám ma pitáená kung Juda yan miti itná káin wáina ingga yánánggiuk. Rám káman Prisila káling Akuila yá wáina men narángga ku mantáng mán it yándi káin kun Ánutu yan kálu ku wáina ingga kátu kánkáman ma narák wa kándáng hánám ináng toliumálák. ");
INSERT INTO klt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kulá Apolos yá Akaia provins káin kuin ingga táuk hára wu Táwi yan ámna náráwa watá táng káto tángga Táwi yan ámna náráwa Akaia káin árená wata kolem ing uying yámuráng, “Ámna wa heronge mená inángga kándáng pinná táineráng.” Apolos málám wakáin kuk watá kung ámna náráwa Ánutu yá urák yáni narángga háláng yámán málámba naráng háting muráng wa táwi hánám háláng yámánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Málám hahatingga átang rahán hára Juda yá me kandák rina menggiuráng wa káting hang tingting tánggiuk. Ánutu yan me papia káin uyená wa yánáng tolin me watá pálipuk hánám ámna náráwa son iháhá wawu Jesu ingga hiták yálenggiuk. ");
INSERT INTO klt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos yá Korin káin átuk hára wu Pol yá ále yáilá kálu háram kálu re átninggan kungga it yáilá Efesus káin kung hiuk. Málám Efesus káin kungga wakáin ámna Ánutu yan pingnga hálená wa kápángga ku ");
INSERT INTO klt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ing yánáng suliuk, “Rám sándá Jesu ya naráng háting muráng wahára Iruk Káungá kámá táuráng me muná?” Wáina yánáng sulin watá inuráng, “Muná, nándu Iruk Káungá wáina átak ingga ma narángngátamán.” ");
INSERT INTO klt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wáina inát tu Pol yá yánuk, “Iná umi wu rina kuhuráng?” ingga yánán du watá inuráng, “Jon dá umi kukuháya miuk wáina kuháng námuráng.” ");
INSERT INTO klt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Wáina inát tu Pol yá yánuk, “Jon dá umi kukuháya miuk wawu pahán hurik tátáyan da kukuhá. Ináku ámna náráwa yá ámna nukngá Jon torong káin áwinek wata naráng háting mámáya yánuk wawu Jesu.” ");
INSERT INTO klt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pol yá wáina yánán narángga ku Táwi Jesu kutná hára umi kuhuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kulá Pol yá ketná yá yáin yáni hára usáng hang tingga sáponga táuk waháranyon Iruk Káungá watá áwáng ep ihán du me hulá hulá me tángga ku profet me miuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ámna wata sale yáni ku 12 hám wáina. ");
INSERT INTO klt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kulá yap kaláhu wata kinan du Pol yá wakáin ma pitáená káto hálengga átang Juda yan miti itná kinan hangga me pingnga álosim wa yánángga átkiuk. Ánutu yan átkuku wawu wáina ingga yánángga inán kanán tángga Táwi yan me hulá ku wáina wáina ingga pahán yáni seng tárut tánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Iná kámá yá ku pahán yáni káto hánám hálendu pálipuk ingga ma naránggiuráng, ináku rahán táwi hára ku Táwi isutsut tán kálu wata wu kandák ingga menggiuráng. Wáina tát tu Pol yá wa yápmangga ni ámna náráwa Táwi ya naráng háting mená wa rewe ihángga me rina wa mengga inán kanán tángga nanaráya wu rámá rámá ámna káman kutná Tiranus watán it káman nanará yánáng totoliyan wakáin kunggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Yara yará wata kinan du wáina re tángga kungga árát tu Juda me Grik ámna náráwa Esia provins kinan árená watá kámuk hánám Táwi yan me wa naráng háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ánutu yá Pol háláng imán tárák hulá kámá kámá tátáwi hánám wáina tánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ámna náráwa yá lap me angkesip yáni iháng kung Pol sutná hára tánggangga ku wa iháng kung ilalák mara usáng yámát tu ilalák yáni yá álo hálenggiuk me iruk wáik ká ep ihángga árená watá yápmangga kunggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kulá Juda kámá yá ku sup yáupmá ya iruk wáik yásutang átninggiuráng. Tárák tángga kakaya Táwi Jesu kutná hára mengga wahára ámna náráwa yan káin iruk wáik yásusut ta tángga ku ing menggiuráng, “Jesu Pol yá menggoek wata kutná hára, no ing kanin, áwáng kep káin hang.” ");
INSERT INTO klt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kulá Juda yan pris táwi yáni káman kutná Skewa wata nángánangge ámnaná 7 watá ku kálu wáinanyon isutkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Rám káman wáina tángngárát tu iruk wáik káman dá ing yánuk, “Jesu wawu há naráng met, me Pol wawu há naráng met, iná sán du ren?” ");
INSERT INTO klt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wáina yánángga ku ámna iruk wáik ká ep táená watá yáni ya ketnán hiring hitangga árángga kámá hára kungkung tángga háláng yáni tángga hangga táup hánám ráhán du muláng re sip hanghaling it wa sangga hururung re há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kulá pingnga wa Juda me Grik Efesus hára árená watá naruráng hára wu pikpiták táwi hánám tángga ku Táwi Jesu kutná wa meng tárut tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ámna náráwa táup hánám Jesu ya naráng háting muráng watá áwángga ku átkuku náni kandák ku wáina wáina ingga hiták hánám meng tunggap táuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ámna náráwa sárum yáni pálak táup sim bá yon kutná kutná ya yambo yáni táená, me tará hulá hulá táená, me yáikuram kandák kálu táená wata mená papia hára uyená wa iháng áwáng rahán hára káráp siuráng. Iná papia wata yumnak yáni wu sup táulá silva 50,000 dá yuyuwáyan tárák wáina. ");
INSERT INTO klt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kálu wa táuráng wahára kungga ku Táwi yan me watá hálángngá pálak hánám ámna náráwa yan káin kung hilák tángga kuk ngáyá emá re kunggatuk. ");
INSERT INTO klt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wáina tunggafen kangga sangga ku Pol málám Masedonia yot Akaia provins kálu kungga Jerusalem káin kukuya naruk. Wáina narángga ku Jerusalem káin kungga sangga ku it yáilá Rom káin hányon kuinet ingga naruk. ");
INSERT INTO klt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Málám háláng imámá ámna yará Timoti káling Erastus suring yámán watá kálak Masedonia káin kun du málám bu Esia provins káin rám hásák sim átuk. ");
INSERT INTO klt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Rám ore wahára ku ámna kámá yá Táwi isutsut tán kálu wata ingga kámkáyam tángga wata mená táwi hánám táuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ámna káman kutná Demitrius wawu sup yáupmá ku silva yá kutná kutná iháng tolingngátak. Wata kinan yon yáupmá tángngátak wawu ánutu náráwa kutná Atemis watán miti itná wata tárákngá wa ina isikikimo silva yá iháng tolingngátak. Ámna kámá yá wáinanyon iháng tolit tu Demitrius yá kálu ná iháng toling yámán yuwát tu sup táwi hánám ihánggiuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kulá Demitrius málám ámna wáina iháng tolinggiuráng watyot ámna kámá wáinanyon Atemis yan kutná kutná wata tárákngá iháng tolinggiuráng wa men áwát tu yánuk, “Ámna nuknukna, ing há nareráng wa, yáup wa tángngátamán wata supmá álo kámá hánám wa uyingngátamán. ");
INSERT INTO klt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Enendu ámna Pol watá ámna náráwa táup hánám wa iháng uyin kun du ing yánánggoek, ánutu ámna ket yáni yá iháng tolená wawu kusák ingga yánángga iháng yakyawák tánggoek, Efesus kinan re muná ináku Esia provins kinan kámuk. ");
INSERT INTO klt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wata wáina tán du nándá sup yáupmá tátá wata kutná yá hahaná háleiwon, me ánutu náráwa kutná árená hánám Atemis watán miti itná wa kat ále hánám háleiwon. Ámna náráwa Esia provins re muná ináku káwak ketnán kámuk watá Atemis ináng sákngingngátaráng, enendu Pol yan me watá tán du Atemis kutná watá ále hánám háleinek.” ");
INSERT INTO klt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Me wa wáina yánán narángga ku ámna watá pahán suksuk hánám narángga “Efesus yan ánutu Atemis wawu kutná árená hánám!” ingga mangmantáng kuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wahára re it yáilá hára árená watá kámuk káman hálengga menman táwi tángga kung Pol nuknukngá ámna yará Masedonia nan Gaius káling Aristakus wa ket ihángga iháng uyinggatang urum komená káin kuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Wáina tát Pol málám urum wakáin kuin ingga tángngárán Jesu yan tombong háranan dá oletná mat tu há átuk. ");
INSERT INTO klt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Provins watán ámna yáilá kámá Pol yanuknukngá hálendu watá urum komená káin wa ma hánám áwindalák ingga me hányon sat kung muk. ");
INSERT INTO klt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ámna náráwa urum táwi watá naráng yakyawák tángga kámá yá kámá kámá menman tángga kunggiuráng. Táup hánám watá ku náuta kung átamán ingga ma naráng rákit táuráng. ");
INSERT INTO klt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juda yá ku kuk wata hulá ku wáina wáina ingga yánáng ingga ámna káman kutná Aleksenda wa seng isurát kung máta ya átuk. Wáina árán du ámna kámá urum kinan áturáng watá wáina wáina meng ingga inánggaturáng, enendu watá yolop árát no me mein ingga ket tárák táng yámuk. ");
INSERT INTO klt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Enendu ámna wawu Juda ingga há kangga ku wata watán me ma naruráng, ináku milun káman hálen sonson ing mantángga re árát kungga aua yará háliuk, “Efesus yan ánutu Atemis wawu kutná árená hánám!” ");
INSERT INTO klt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wáina tángga árát it yáilá watán kolem uyiyi ámna watá áwáng yolop átniráng ingga yánángga ku ing yánuk, “Efesus ámna, káwakngá káwakngá kámuk hánám bá ing há nareráng, ánutu náráwa kutná árená hánám Atemis watán it káungá wawu Efesus ámna náráwa nándá re pinná tángngátamán ingga há nareráng, hang sup káungá alek kálu háuk watyot pinná tángngátamán ingga hányon nareráng. ");
INSERT INTO klt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Wata ku káman dá me náta kusák ingga ma menggim. Sándá yolop átneráng. Rina kámá sopmuná ma táindaráng. ");
INSERT INTO klt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Sándá ámna yará ná ihángga áweráng wawu watá náut kámá kámá miti itná kinan káinnan manek ma ihángga áwángngátamálák me nándán ánutu náráwa Atemis wata rina kámá ma mengga áwángngátamálák. ");
INSERT INTO klt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Iná Demitrius yot yáup káman yáni tángngátaráng watá ámna kámá yan káin me yá átak hálen wawu me nanará ámna rahán yáni hára átang gu wahára me yáni wa met me nanará wata horengga narineráng. ");
INSERT INTO klt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Iná sándán káin me nukngá kámá átak hálendu máriya urum táwi tángga ku urum hára me wa táng tolineráng. ");
INSERT INTO klt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Wáina wata ku ing narinemán, iná kapman dán ámna yáilá yá kula nándá rina táemán wa nareráng, hám ináku márapmá táwi táng tunggap táeráng ingga náháng me hára tinggalát. Hulá kámá muná hánámá hánám wa táemán, wata nánáng sulit tu rina menggatnem?” ");
INSERT INTO klt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ámna watá me wa wáina yánáng hálingga sangga ku yánán há yáni kuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ámna náráwa yá ohok menman tángga áturáng watá sálikngin du Pol yá me san Jesu yan tombong ingga áturáng wata kun áwáng árát tu me yánángga iháng káto tángga sangga ku Masedonia provins káin kuindet ingga yánángga ku kuk. ");
INSERT INTO klt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Málám Masedonia kinan átningga me yánángga iháng káto tángtáng kuk. Wáina táng hálingga ku Masedonia sangga káwak Grik káin kung hiuk. ");
INSERT INTO klt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Káwak Grik káin kung yap kaláhu átang sangga ku kilang hára árángga Siria provins káin kuin ingga naruk wahára ku Juda yá utkámut tátáya me hárotang átaráng ingga met narángga sangga ku málám son Masedonia kálu kukuya naráng hátiuk. ");
INSERT INTO klt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ámna 7 watá Pol yot kuráng wata kut yáni ku ná, Pirus nanggená Sopata wawu it táwi Beria nan, Aristakus káling Sekundus wawu it yáilá Tesalonaika nan, Gaius it yáilá Debe nan, Tikikus káling Trofimus Esia provins nan hang Timoti watá watyot kuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Watyot kungga ku ámna watá kálak kuráng ngáyá kung it táwi Troas káin háleng námángga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Iná nándu rám táwi Másáng Yisná Muná Náená wa it yáilá Filipai káin kangga sangga ku kilang hára kungga árátne rám 5 hálen Troas káin kung hengga ku kápángga rám 7 wahára átumán. ");
INSERT INTO klt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kulá sonda ore hulátitiná hára ku Táwi sip yánumá nanaya urum táumán. Wahára ku Pol yá me emá re nánángga árán kungga yáung táitná háliuk, náuta tembát tu há kuinet ingga wata wáina táuk. ");
INSERT INTO klt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kulá it pahálá torong hánám káin nándá átumán wahára wu lam táup hánám watá rang hálengga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wahára wu nangge máto káman kutná Yutikus wawu windua hára putung átang gu Pol yá rám hásák me emá re nánángga árán du kárámatingga átang rapmung gá sán du hundup hánám há ruhuk. Wáina ruhángga átang gu sohing hang káwak káin kátin hangga tángga káumán du há kámurená, náuta it pahálá yará wata torong káin kaláhuná káin átang háuk wata. ");
INSERT INTO klt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Wáina hálendu Pol málám háuk watá hang ámna máto wata torong hára pándák hangga poláng mángga átang gu ámna náráwa yánuk, “Ma pitáindaráng, ma kámurak, há átak.” ");
INSERT INTO klt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ingga wáina yánán du son árángga it kinan kungga Táwi yan sip yánumá natne ku Pol yá me nánángga árán kungga it tá háin du yápmangga kuk. ");
INSERT INTO klt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iná ámna náráwa yá ku ámna máto wawu son tárutang há árán pahán yáni álosim nangnaráng engotang it yáni ya kuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kulá Pol málámbá háram kálu it táwi Asos káin kukuya narángga ku sándá kálak kilang hára kungga it wakáin kuineráng ngáyá ku wakáin átang nák ka háleng namángga átneráng ingga nánuk. Pol yá nánuk wáina há kungga sangga ku háleng mángga árátne ");
INSERT INTO klt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pol yá áwáng hen Asos káin kankan tángga kámuk náni kilang hára árángga it táwi Mitilini káin kumán. ");
INSERT INTO klt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tembátnáya ku wahára átang kungga ailan Kios wata tangtang kálu kumán. Wata tembátnáya ku kungga ailan Samos wata tangtang kálu kumán, iná wata tembátnáya ku kungga it táwi Miletus káin kumán. ");
INSERT INTO klt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol málám Esia provins káin áre rám bá ma sálikngindak, ináku sopmuná kungga rám táwi Iruk ká Háuk wawu Jerusalem káin káinet ingga nangnaráng átkuk, wata ku it yáilá Efesus táng hátingga kukuya naruk. ");
INSERT INTO klt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Wáina narángga ku Miletus káin átang gu Pol yá áwángga málám kakaya me san Efesus miti itná yan ámna yáilá yan káin kung yámuk. ");
INSERT INTO klt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ámna yáilá watá Pol yan káin áwáng het tu ing yánuk, “Esia provins kinan hulátingga hánám áwáng hiut waháranyon átang áwángga sápmáut hára, no sányot átang tárák rina tángga átut wawu sáni há nareráng wa. ");
INSERT INTO klt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Rám máro hánám Juda yá neháng hang tingga nutkámut tátáya me hárotnándaráng. Wáina tát no pahán márapmá táwi hánám tángga kut káyawát tángngátat, enendu naya kutná tángga hangga Táwi yan yáup tángga átningngátat. ");
INSERT INTO klt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ing há nareráng wa, no sán háláng sásámáya ma pitáená Táwi yan me menggiut, rahán hára me it sáni kinan káman káman sánángga kunggiut. ");
INSERT INTO klt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","No hiták Juda me Grik ámna náráwa ing yánut, pahán hurik tángga Ánutu yan káin kungga ku Táwi náni Jesu naráng háting mineráng. ");
INSERT INTO klt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Iná rám ore nahára wu Iruk ká neháng tiyap táek, wata ku Jerusalem káin há kuinet. Wakáin koe nák sutná hára rina tunggafeinek wawu ma narát. ");
INSERT INTO klt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ing rewe ku há naret, it yáilá kámuk wakáin kung hengngátat hára wu Iruk Káungá yá kalabus me márapmá táwi watá háleng kamángga átak ingga nanángngátak. ");
INSERT INTO klt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Enendu na ku ing naránggoet, nangán átnát wata nare hánámá hálenggoek, ináku Táwi Jesu yá yáup rina namuk wa tángga koe kungga tárákngá hára sáliknginek. Yáup rina namuk wawu me pingnga álosim wa ing yánánggoet, Ánutu yá ukuro naráng námángngátak ingga yánánggoet wa. ");
INSERT INTO klt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kulá no ing há naret, huphuráp no orek sáni hára átang Ánutu yan átkuku wata mená sánánggiut, enendu máriya ku sándá son inamna ma nahindáráng. ");
INSERT INTO klt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Wáina wata ku hiták ing sánin, no Ánutu yan hulá wa kátu táng kilak tingga ma sánut, wata ku orek sáni hára ámna káman dá Ánutu ya ma naráng háting mindák hálen wawu wata hulá ku nák ma háleindák. ");
INSERT INTO klt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sándá ku sáni me Ánutu yan ámna náráwa kámuk wata kándáng háleng rákit tángga átneráng. Ámna náráwa wawu Nanggená sipmá yá há iháng yuwángga ihuk. Iná Iruk Káungá yá ku sipsip wa pin yáni tátáya sán há sáháng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ing há naret, no sápmangga kuinet wahára wu ámna yá ang páyom wáik ina watá áwáng Ánutu yan sipsip sán wa sáháng wáik táineráng. ");
INSERT INTO klt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sánin tombong waháranan dá yon tárutang gu me kusák wa mengga Ánutu yan ámna náráwa wa iháng uyin yásutang kuineráng. ");
INSERT INTO klt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Wata ku kándáng háleng rákit tángga átneráng. Yara kaláhu wata kinan rámá rámá káen me yáungán rahánna uminá kinan re átang sánáng rákit tángga átut wata naráng hátineráng. ");
INSERT INTO klt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kulá sáháng Ánutu ketná hára te ku málámbán me yá ukuro naráng sáminek ingga mek watá ku pin sáni táinek. Me watá yon du sáháng káto tángga Ánutu yá náut málámbán ámna náráwa yámámáya tiyawingga san átak wa sán hányon sáminek. ");
INSERT INTO klt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","No ámna káman dán hára silva me gol me lap kámá ma kápáng narut. ");
INSERT INTO klt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sáni ing há nareráng wa, no naya ketna nátá yon du na háláng imánggiut me niyá nákkot átkiuráng wa háláng yámánggiut. ");
INSERT INTO klt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","No rina rina tánggiut wawu sándá ing tángguineráng ingga wata sálenggiut, sándá yáup háláng wáinanyon há tángga ku ámna náráwa ukuro háláng yáni muná wa háláng yámámáya tángguineráng. Táwi Jesu yan me ing wa naráng hátineráng, ‘Ámna niyá kutná kutná yáminek watán heronge yá ámna niyá kutná kutná ihinek watán heronge wa táng hátek.’” ");
INSERT INTO klt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol málám me wa yánángga sangga ku ámna yáilá watyot tun yáni hára imánggatang sáponga táuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sáponga tát sálin du kámuk yáni kutkáyawát tángga poláng mángga tánggatang kang kumiuráng. ");
INSERT INTO klt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Táup hánám ukuro táuráng wawu inamna son ma káindáráng ingga yánuk wata. Wáina tángga ku kámuk ingmen engot kung kilang káin sáuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kulá ámna yáilá wa yápmangga kilang kinan árángga kutne ku kilang gá it wa sangga kungga ailan Kos káin kándáng hánám kuk. Iná tembátnáya ku ailan Rodes káin kumán náyá wata tembátnáya ku kungga it táwi Patara káin kumán. ");
INSERT INTO klt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wahára káumán du kilang káman dá ále Ponisia káin kukuya tán kangga ku son kilang wahára árángga ku kumán. ");
INSERT INTO klt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kulá ailan Saiprus wawu ket kandák kálu árán kangkang kungga ku Siria provins káin it táwi Tair wahára kung hengga it watán kutná kutná kilang watá ihán kumán wa hirarán hahaya tán du kilang sangga kep káin háumán. ");
INSERT INTO klt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","It wahára hangga kung Ánutu yan ámna náráwa wa táng suling kung kápángga watyot rám 7 átumán. Kulá wahára ku Iruk ká pahán yánin han du Jerusalem káin ma kuindalák ingga Pol inángga son son táuráng, ");
INSERT INTO klt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","enendu kilang gá son kuinán tán du kilang gá átuk káin wa kukuya tátne ku Ánutu yan ámna watá áwá nangge yáni yot kámuk nángotang it wa sangga sán káin kung tun náni hára imángga átang sáponga táumán. ");
INSERT INTO klt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Wáina tángga sangga ku ket yánin tángga nándá kilang kinan kutne ku watá son it yáni ya kuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kulá Tair sangga kungga ku it táwi Tolemes káin hangga ku Ánutu yan ámna náráwa wakáin kápángga watyot rám káman átumán. ");
INSERT INTO klt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tembátnáya ku Tolemes sangga kungga ku it yáilá Sisaria káin ámna káman kutná Filip watán it káin átumán. Ámna wawu Táwi yan me wa yánángga átningngátak, me málám wawu huphuráp ámna 7 aposel yá iháng tunggap tát náráwa kawát háláng yáyámáya yáup yámuráng waháranan. ");
INSERT INTO klt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ámna wata yáuriwa máto 4 watá wu profet me mengngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nándá wahára rám kámá há árátne ku profet káman kutná Agabus watá Judia ále kálu áwáng háuk. ");
INSERT INTO klt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kulá ámna watá nándán káin áwuk watá áwáng Pol yan let wa táng málámba ketná hárammá wa hárotang gu ing miuk, “Iruk Káungá yá ing mek, tárák ná táet wáinanyon du Juda ámna Jerusalem káin átaráng watá let náta márumá wa hárotang táng ámna kámá káinnan da ket yáni hára tineráng.” ");
INSERT INTO klt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wáina men narángga ku nán me ámna náráwa wahára átumán watá Jerusalem káin ma árindalák ingga inángga son son táumán. ");
INSERT INTO klt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wáina inátne ku Pol yá ing nánuk, “Sándu náuta ku kutang nák pahánna táng hang tiktik tánggoeráng? Nák ku Táwi Jesu kutná meng tárut tánggoet wata ket háramna álo hárotneráng, me Jerusalem káin nutkámut tátáya hálendu álo wáina táineráng. Nák ku kátkámut ta há tiyawingga átkoet.” ");
INSERT INTO klt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wáina nánán du nándá káumán du nándá watán pahán káin átuk wa táng yakyawák tátáyan tárák muná hálendu ing miumán, “Táwi yá rina tunggafefeya narek wáina álo tunggafeinek.” ");
INSERT INTO klt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Wata torong káin du náni tiyawingga ku Táwi yan tombong kámá Sisaria nan watyot kámuk náni árángga kungga Jerusalem káin kumán. Wakáin kutne ku nángot kung ámna káman Saiprus nan kutná Nason watán it káin nápmáuráng. Nason wawu huphuráp pon hánám Táwi yan tombong háliuk. ");
INSERT INTO klt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kulá rám nándá Jerusalem káin kung hiumán wahára wu Táwi yan tombong watá heronge pálak áwángga náhuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kulá tembátnáya ku Jeims Táwi kulaná wa kakaya Pol yot kutne ku miti yan ámna yáilá watá kámuk ingmen wakáin áwát tu átumán. ");
INSERT INTO klt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kung átang gu Pol yá heronge me yánángga ku málámba ketná hára Ánutu yá ket tárák rina ámna náráwa kámá káinnan watán káin táuk wata pingnganá kándáng hánám wáina yánuk. ");
INSERT INTO klt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pingnga wa yánán naruráng hára wu yáni wu Ánutu kutná meng tárut tángga ku Pol inuráng, “Kang, nuk náni, Juda ámna náráwa Jesu ya naráng háting mená táup hánám táwi watá Moses yan meng rákit mená wawu táwi hánám ingga narángga isutkoeráng. ");
INSERT INTO klt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ámna náráwa kátu yá yánát tu kák ka ing menggoeráng, ‘Pol yá Juda ámna kámá káinnan da orek yáni káin átaráng wa Moses yan me wa ma isutnándaráng, me nángánangge sáni kep yáni ma marindaráng, me táwi ilom náni yan kálu wa ma isutnándaráng ingga yánánggoek,’ ingga wáina menggoeráng. ");
INSERT INTO klt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kulá wáina áwelák ingga há narinderáng, wata ku rina táinemán? ");
INSERT INTO klt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ko naráng, nanará káman nándá naremán wáina isutnelák wawu ing, Jesu yan tombong waháranan ámna 4 yá Ánutu yan káin me káto há miuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ámna 4 nátyot kungga ku watá Ánutu rahálá hára rongrongngá háháleya Moses yan meng rákit mená isutang rina táineráng, ko ku wáinanyon táinelák. Watán towet sisiyan kutná kutná wa yuwáng yámátá ku watá yáin yáni rommá wa komkomá hárineráng. Wáina tátá kámá yá kahángga ku me kák ka rina mená wawu kusák ingga narineráng, iná kaya ku meng rákit me wa isutnándalák ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Iná ámna náráwa kámá káinnan Jesu ya naráng háting mená watán káin du me kak mená wa isutang papia ing há uyingga satne kung yámuk, sungi songgo ánutu kusák ka towet sing mená ma náindaráng, songgo yánumá hára sip pá há árán kangkang wa ma náindaráng, songgo san yáni hára iháng kátkámut táená wata yánum yáni wa ma náindaráng, hang márámamák hára ma kuindaráng.” ");
INSERT INTO klt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Wáina inát tu tembátnáya ku Pol yá ámna watyot kungga ku rina tángga rongrongngá háháleya mená wáina táuráng. Wáina tángga sangga ku málám Táwi yan it káungá hánám kapmená káin kungga ku rám bu rina hára rongrongngá háháleyan watá sálikngin du watán towet sisi wa ihángga áwinemán ingga pris yánuk. ");
INSERT INTO klt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kulá rám 7 watá sálin ingga tángga átuk wahára ku Juda ámna kámá Esia provins káinnan watá Pol ku it káungá kapmená káin wa kangga ku ámna náráwa kátu wata pahán yánin hat Pol ya kuk táng mát tu Esia ámna watá kung ket tángga ku ");
INSERT INTO klt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ing mantáuráng, “Israel ámna, áwáng háláng námániráng. Ámna náwu ále rehára rehára átningga ámna náráwa ing yánáng tolingngátak, nándán ámna náráwa, nándán meng rákit mená me nándán it káungá wawu wáik hánám ingga yánángngátak. Kulá kámá ku ing táuk, Grik yángot áwáng it káungá ná táng konep táuk.” ");
INSERT INTO klt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wáina miuráng wawu ing wata, rám káman Trofimus Efesus nan watá it yáilá Jerusalem wata kinan Pol yot seng sulingga átninggun kápuráng hálendu Pol yá it káungá kapmená káin engotang kuk hám ingga wata narángga miuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Me yá wáina kun narángga ámna náráwa yá hárámutang nangnga yáni han wakáinnan wakáinnan áwáng áturáng watá áwáng Pol káto tángga táng uyingga tánggatang it káungá yan kumbi kep káin hangga ku kálu mungnganá wa sokmuná hánám káto táng háliuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Yáni wu táng kung utkámut tánin ingga tángga árát tu Jerusalem ámna wu kun tátáya menman tángga átaráng ingga me watá Rom bán tewe ámna yáin yáni táwi watán káin kuk. ");
INSERT INTO klt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kun narángga málám sopmuná ingmen málámba tárang hára átnándak tewe ámna urum kámá ya yáin yáni watyot tewe ámna ihángga urum áturáng káin wa hat kápángga ku ámna urum táwi watá Pol utang áturáng wa sáuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tewe ámna yáin yáni táwi watá áwuk ngáya áwáng Pol ket tángga tewe ámna yánán sen yará yá hároturáng. Wáina tát tu málám “Ámna náwu ni, me kandák ku rina táek?” ingga yánáng suliuk, ");
INSERT INTO klt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wáina yánáng sulingga árán du ámna kámá yá mantángga kámá kámá ingináng tángga táng kukulák tát tu hulá resim hánám ingga ku kándáng ma naruk. Wáina hálendu málám Pol engotang yánin átnát káin kukuya tewe ámna yánuk. ");
INSERT INTO klt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wáina yánán Pol engotang tirak hulá hára kung hengngárát ámna náráwa yá utkámut tátáya táup hánám tát kápángga ku tewe ámna yá árong Pol wa táng hip tángga árángga kuráng. ");
INSERT INTO klt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wáina tángga kut ámna náráwa urum táwi yásutang kuráng watá “Utkámut tániráng! Utkámut tániráng!” ingga sonson mantángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kulá tewe ámna yá Pol tángga kung it yáni kinan hanin ingga tát tu Pol yá tewe ámna yáin yáni táwi wa inuk, “No me káman álo kanánggem me?” ingga inán du watá inuk, “E! Kák ku Grik me há me tángngátalák. ");
INSERT INTO klt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nák ka kák ku Isip ámna huphuráp sim kapman yot erawángga ámna kápik ká erawená 4,000 wa ihángga ále komkomá ámna muná káin kuk wa ingga naránggoet,” ingga inuk. ");
INSERT INTO klt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Wáina inán Pol yá inuk, “Nák ku wa muná. Nák ku Juda ámna it yáilá Tasus Silisia provins nan. Nákkán it yáilá wawu kutná pálak. Ko álo nepmatá no me kámá ámna náráwa álo yánánggem me?” ");
INSERT INTO klt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wáina inán tewe ámna yáin yáni watá álo ingga inán du Pol málám tirak hára hetang átang ketná yá urum táwi áturáng wa yolop átniráng ingga tárák tán kangga yolop ingmen árát tu Hibru me kálu yánuk. ");
INSERT INTO klt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Yanuknukna me nan ilomna, no naya áráng hákhátik naya ing sánin, no kandák kámá ma táut,” ingga wáina yánán ");
INSERT INTO klt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","urum táwi áturáng watá naruráng gu Hibru me kálu yánán narángga ku yolop hánám áturáng. ");
INSERT INTO klt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Wáina árát tu Pol yá yánuk, “Nák ku Juda ámna, it yáilá Tasus Silisia provins káin wa tunggafiut, enendu it yáilá nahára átang tiháut. Nák ku tiksa Gamaliel watá táwi ilom náni yan meng rákit me kándáng hánám wa nanáng toktolik tán du no Táwi yan me wa táng káto táin ingga tánggiut, nahára átaráng sáni há tánggoeráng wáina. ");
INSERT INTO klt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nák ku Jesu isutnárát wa iháng wáik tángga átninggiut. Ámna me náráwa hányon iháng sen dá hárotang kalabus kinan tinggiut, me ihángga iháng ráháng kátkámut tánggiut. ");
INSERT INTO klt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pris yáin yáni me ámna Juda yan kaunsol urum hára átnándaráng watá no rina tánggiut wawu há nareráng, watá wáina ingga álo sánánggalát. Yáni nák háláng nanamáya ku nuknuk yáni it yáilá Damaskas káin átaráng watán papia uyingga namuráng. Kulá papia wa tángga kung yáme wakáin Jesu yan ámna náráwa átaráng wa ket háram yáni hárotang iháng áwáng Jerusalem káin yáup káto tátáya Damaskas ya kut. ");
INSERT INTO klt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Kungga átnáre káe táitná hám wáina kálu ku Damaskas tangtang yamá káman sireretná pálak alek kálu máuk watá mangga rang hálengga neháng támotuk. ");
INSERT INTO klt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Wáina tán káwak káin táng hang káte ku me káman dá ing nanuk, ‘Sol! Sol! Náuta ku nák neháng lem tánggoelák?’ ");
INSERT INTO klt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ingga nanán narángga ku no ing inut, ‘Ámna hulá, kák ku ni?’ “Wáina ine ku watá nanuk, ‘Nák ku Jesu Nasaret nan, ko neháng lem tánggoelák wa,’ ingga wáina nanuk. ");
INSERT INTO klt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nuknukna káman átumán watá yamá wawu há káuráng, enendu me yá áwuk wawu ma naruráng. ");
INSERT INTO klt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Wáina nanán du no ing inut, ‘Táwi, no rina táinet ta narelák?’ wáina ine ku watá nanuk, ‘Tárutang it yáilá Damaskas káin kutá ku ámna káman dá ko yáup rina táinelák ka naret wawu watá wakáin kaninek,’ ingga nanuk. ");
INSERT INTO klt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kulá yamá watá hálángngá wu rina kámá hánám wa man no náut kámá kákápáyan du muná hálendu wahára átang gu nuknukna káman kumán watá ketnan tát tu kungga it yáilá káin kung hiumán. ");
INSERT INTO klt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kung hetne ku ámna káman kutná Ananaias watá nanaháya áwuk. Ámna wawu Ánutu tárang káin hánám átang meng rákit mená wa kándáng hánám isutnándak. Juda Damaskas hára wa árená watá ámna wawu álo kámá ingga mengngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ámna watá áwáng nák rupna tangtang hetang átang gu ing nanuk, ‘Nukna Sol, rahála yá álo háleik,’ ingga men du wahára re rahánna yá álo hálen hálengga ámna wa káut. ");
INSERT INTO klt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Wáina káe ku nanuk, ‘Táwi ilom náni yan Ánutu watá málámba pahálá káin rina átak wa kakaleya keháng tunggap táuk, me Ámna Kándáng wa kangga málámbá milunná yá rina kaninek wa nanaráya keháng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ko ku wa háláng imángga rina káelák me narelák wa meng tunggap tángga ámna náráwa táup táwi yáninelák. ");
INSERT INTO klt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kulá náuta hálenggoelák? Tárutang Táwi kutná mengga umi kuhátá ku mukmuroka yawonek,’ ingga Ananaias yá nanuk. ");
INSERT INTO klt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Wáina nanán du rina tátáya nanuk wáina tángga son Jerusalem káin kung Táwi yan it káungá hánám kinan káin sáponga tángga átang gu ára hára ina kangngáre ");
INSERT INTO klt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Táwi yá ing nanuk, ‘Jerusalem nan ámna náráwa yá ko nákka rina yáninelák wawu ma narindáráng, wata ku sopmuná ingmen it yáilá ná sangga kung.’ ");
INSERT INTO klt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Wáina nanán du no inut, ‘Táwi, ámna náráwa wu no Juda yan miti itná átaráng wahára kámá hára kungkung tángga ámna náráwa kákka naráng hátingga árená wa ráhángga iháng kung kalabus káin tingting tánggiut wawu há nareráng. ");
INSERT INTO klt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Hang Stiwen wawu kangán me wa meng tunggap tángga yánángga átkungngátak wata ingga utkámut táuráng rám wahára wu nák ku hányon átang wawu álo kámá táeráng ingga kápángga átang lap yáni hákhásák wata pin yáni tángga átut wawu hányon nareráng.’ ");
INSERT INTO klt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Wáina ine ku Táwi yá nanuk, ‘Kung, kák ku suring kame mulangán hánám ámna náráwa ále kámá káinnan watán káin wa kuinelák.’” ");
INSERT INTO klt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Juda ámna náráwa urum táwi watá kárámatingga árát kungga Pol yá ámna ále kámá káinnan da miuk hára wawu pahán káráp tángga san yáni táng hip tángga hahatingga ing mantáuráng, “Utkámut tániráng! Ámna wáinaná watá átnát tán tárák muná!” ");
INSERT INTO klt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wáina mantángga lap yáni hákhásák wa yalingga hirarát kun ámálum ihángga hirarát alek kálu árán ");
INSERT INTO klt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","kangga ku tewe ámna yáin yáni táwi watá tewe ámna yánán Pol tángga yánin it káin kuráng. Tewe ámna yáin yáni yá hulá ku náuta ingga pahán káráp tángga Pol ya ohok menman táng meráng ingga nanaráya tewe ámna yánán lahot mángga ku wáina wata ingga nánik ingga ináng susuliya yánuk. ");
INSERT INTO klt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pol lahot mámáya ket hárammá hárotang kándáng ting sat árán du tewe ámna yáin yáni káman dá Pol rupmá tangtang hetang árán Pol yá wa inuk, “Rom ámna káman ma ináng sulingga hulá ma narená hánámá lahot mámá watán meng rákit mená kámá átak me?” ");
INSERT INTO klt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wáina inán tewe ámna yáin yáni watá wa narángga ku son yáin yáni watán káin kung wáina mek ingga inángga ku inuk, “Ámna wawu Rom ámna, wata ku rina táng minelák?” ");
INSERT INTO klt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Wáina inán du tewe ámna yáin yáni táwi yá málámbáyon Pol yan káin kungga inuk, “Nanáng, kák ka pálipuk Rom ámna me?” ing inán du Pol yá inuk, “O, nák ku Rom ámna.” ");
INSERT INTO klt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Wáina inán du tewe ámna yáin yáni táwi watá inuk, “No Rom ámna háháleya ku supna táwi hánám wa sáut,” ing inán du Pol yá inuk, “Iná nák ku mamna yá Rom ámna hánám wa neháng tiuk.” ");
INSERT INTO klt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wáina men narángga waháranyon du tewe ámna kámá lahot mámáya narángga áturáng watá yolopon sáuráng. Kulá tewe ámna yáin yáni táwi watá Pol Rom ámna wa táng sen dá hárotuk wawu Rom bán meng rákit mená wa hitik táuk wáina hálendu Pol yá nák ku Rom ámna ing men narángga ku hárámutang pitáuk. ");
INSERT INTO klt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kulá tembátnáya ku tewe ámna yáin yáni málám hulá náuta ku Juda yá Pol táng káyam táráng ingga hulá wa kakaya ku Juda yan ámna hulá hulá me pris tátáwi yáni wa men áwát tu Pol engot kung orek yáni hára tiuk. ");
INSERT INTO klt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol yá ámna hulá hulá wa kárek hánám kápángga átang yánuk, “Yanuknukna, nák ku Ánutu rahálá hára yáup rina tátáya namená wawu há tángga áwángga átkoet wata pahánna álosim hánám hálek. Nawu kandák kámá ma táut ingga naret.” ");
INSERT INTO klt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Wáina men pris yáin yáni Ananaias yá ámna niyá Pol rupmá tangtang áturáng wa milunná káting pálák tátáya yánuk. ");
INSERT INTO klt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Wáina yánán Pol yá inuk, “Ánutu yá kák kutnek! Kák ku kumbi wáik pen haknga yá kuháng mená wáina, kák pahála kinan káin du wáinanyon wáik hálengga árená wa ámna náráwa yá ma kangngátaráng. Kák ku meng rákit me wa isutang gu nák neháng me hára titiya áwáng putung átalák, iná kawu meng rákit me wa táng hátingga ku nák nutnut ta yánelák.” ");
INSERT INTO klt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wáina inán ámna rupmá tangtang áturáng watá Pol inuráng, “Ko Ánutu yan yáup ámna pris yáin yáni wata mátan táelák watá kandák hálek.” ");
INSERT INTO klt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Wáina inát tu Pol yá yánuk, “Yanuknukna, nák ku pris yáin yáni ingga ma narát. No kandák táet, náuta Táwi yan me ing uyená átak, ‘Ámna hulá ka káman da me kandák ma meindalák.’” ");
INSERT INTO klt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Wáina mengga ku Pol málám ámna hulá hulá áwáng áturáng wawu wáina ingga há kápuk wawu kámá wu Sadyusi iná kámá wu Farisi ingga há kápángga ku wa ing yánuk, “Yanuknuk, nák ku Farisi, hang nanna wu Farisi yon. Nák ku kámutang tátárut wata naráng hátingngátat. Hulá wata hánám bu neháng me hára teráng.” ");
INSERT INTO klt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kulá me wa men narángga ku Farisi yá Sadyusi yot orek yáni hára menmen tángga urum káman áturáng watá horet yará háliuk. ");
INSERT INTO klt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadyusi yá ku há kámurená yá son tátárut wawu wáina ma árak ingga narángngátaráng, hang angelo me iruk hulá hulá kámá ma áraráng ingga narángngátaráng. Iná Farisi yá ku kámuk wáina há átaráng ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kulá menmen dá táwi hánám wa tunggafen du lo yan tiksa kámá wu tombong Farisi wata kinan áturáng watá tárutang me hahatiná kálu ing miuráng, “Ámna nátán káin kandák kámá ma árán kamán. Me menggoek wawu kámá angelo yá me iruk ká inát meng kuiwon.” ");
INSERT INTO klt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Wáina mengga menmen tángga hála erawinán tát kápángga tewe ámna yáin yáni táwi málám Pol unuyin tát rákitang kámuriwon ingga pikpito hánám narángga ku tewe ámna yánán hahatingga hang orek yáni hára Pol tángga engotang yánin it káin kuráng. ");
INSERT INTO klt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kulá rám waháranyon yáungán du Táwi yá áwáng Pol tangtang átang gu inuk, “Ma pitáindalák, káto yon háleinelák. Nákkán me Jerusalem káin yánulák, wáinanyon Rom káin yáninelák.” ");
INSERT INTO klt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kulá tembátnáya hilápmá ku Juda ámna kámá yá kilak urum tángga Pol utkámut tátáya me hároturáng. Urum yáni hára wu Ánutu rahálá hára me káto hánám ing miuráng, “Kula wu pálipuk hánám Pol wawu utkámut táinemán. Wáina ma táená átamán hára wu sungi me umi ma náená hánámá átnemán.” ");
INSERT INTO klt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ámna urum me wa hároturáng wawu sale yáni wu 40 torong káin náut wáina. ");
INSERT INTO klt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yáni wu pris tátáwi yáni me ámna hulá hulá yáni yan káin kung ing yánuráng, “Nándu Ánutu rahálá hára me káto hánám há memán, náut kámá káman ma náená átang kungga Pol utkámut táinemán. ");
INSERT INTO klt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Wáina wata ku sányot kaunsol ingga átaráng watá tewe ámna yáin yáni táwi wa ingirungngit tu Pol engotang áwát málámbán hulá wa kándáng men kanin ingga inát tu wáina táinek. Nándu tiyawingga hálengga átnemán da ku sándán káin ma áwindák waháranyon há utkámut táinemán.” ");
INSERT INTO klt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Wáina mengga árát tu Pol táripmá yá me wa met narángga ku sopmuná ingmen tewe ámna yan it káin kung me wáina hárotaráng ingga Pol inuk. ");
INSERT INTO klt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wáina inán Pol yá tewe ámna yáin yáni káman men áwán du inuk, “Nangge máto ná engotang yáin sáni yan káin kutá watán me tángga átak wa ininek,” ingga wáina inán du ");
INSERT INTO klt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ámna watá engotang kung tewe ámna yáin yáni táwi wa inuk, “Pol kalabus kinan átak watá men koe ku nangge máto ná engotang kákkán káin áwáwáya nanán du engotang áwet, náuta kákkán me kámá watá tángga átak.” ");
INSERT INTO klt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Wáina inán du tewe ámna yáin yáni táwi watá nangge máto wa ketná hára tángga tákto kálu hangga ku ináng suliuk, “Kulá me ku rina naninán áwelák?” ");
INSERT INTO klt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Wáina inán du nangge máto watá inuk, “Juda ámna yá pahán káman hálendu ko tembát Pol engotang kaunsol rahán yáni hára kutá ku málámbán hulá wa kándáng yáninek ka meráng. ");
INSERT INTO klt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wáina áwáng kanineráng, enendu wawu kanggarungngineráng, wata ku ma engotang kuindalák. Ámna sale yáni 40 torong káin náut wáina watá kilak átang hálengga átneráng. Yáni wu Ánutu rahálá hára me káto ing meráng, sungi me umi ma náená átang kungga Pol utkámut táineráng. Wáina tátáya há tiyawingga átang gu ko álo wáina táinet ingga minelák wata hálengga átaráng.” ");
INSERT INTO klt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Wáina inán du tewe ámna yáin yáni táwi watá nangge máto wa oletná mangga ku ing inuk, “Kungga ámna káman me ná ámna wa wáina inet ingga ma yánindalák.” Wáina inángga ku suring mán háná kuk. ");
INSERT INTO klt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wáina inán kun du tewe ámna yáin yáni yará yánuk, “Sándu tewe ámna 200, tewe ámna hos ketnán árená 70, hang yokyok ihená 200 wa ihángga yáungán 9 kilok hára Sisaria káin kuineráng. ");
INSERT INTO klt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pol yan hos tiyawing mángga márapmá yá táiwon da ku kándáng gon pinná tángga engotang kawana Feliks yan káin kuineráng.” ");
INSERT INTO klt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Wáina yánángga ku papia káman ing uyiuk: ");
INSERT INTO klt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nák ku Klodius Lisias no papia ná ámna hulá kawana táwi Feliks kákkán da uyet. Káe álosim. ");
INSERT INTO klt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Juda ámna yá ámna ná ket tángga táng utkámut tátáya tát kápángga ku Rom ámna ingga há kangga ku nangán tewe ámna yáne kung káyam ket yáni háranan yámáng hutang tángga áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Hulá wu náuta utnut ta tánggoeráng ingga engotang kaunsol yáni yan káin háut. ");
INSERT INTO klt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Rám wahára káut tu yánin meng rákit mená wahára kungga wata ingga mengga utnut ta tángga áturáng, iná hulá káman wa utkámut tátáyan me táng kalabus hára titiyan du muná. ");
INSERT INTO klt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kulá son du utkámut tátáya me kilak hárotang árát tu káman dá kilak áwáng nanán narángga ku sopmuná ingmen tewe ámna yáne kákkán káin engotang áweráng. Ámna niyá wata rina menggoeráng wawu hányon suring yáme kákkán káin áwineráng. ");
INSERT INTO klt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wáina uyingga yámán du tewe ámna yá yáin yáni watán milun isutang yáungán wahára ku Pol engotang kungga it táwi Antipatris káin kung hiuráng. ");
INSERT INTO klt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kulá tembátnáya ku ámna hos ketnán árená watá engotang Sisaria káin kut tu kátu watá ku son hurik tángga Jerusalem káin it yáni ya áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Iná ámna hos ketnán putung árená watá Sisaria káin kung hengga ku Pol engot kung kawana Feliks ya sangga ku papia wa táng imuráng. ");
INSERT INTO klt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wáina imát tu kawana yá papia wa sángingga ku Pol ináng suliuk, “Kák ku ren provins nan?” ingga inán du Pol yá inuk, “Nák ku Silisia provins káinnan.” ");
INSERT INTO klt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Wáina inán du watá inuk, “Kákkán márapmá wawu máriya rendá kákkán kálu me rina tángga átaráng watá nahára áwáng het tu wáina káinet,” wáina inángga ku Pol táng it álosim hánám Herot tá táuk wata kinan tingga tewe ámna yánán pinná tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Rám 5 átang sangga ku pris yáin yáni Ananaias watá ámna yáilá kámá yot lo yan hulá nanará kutná Tertulus watyot kámuk Sisaria káin Pol táng kawana rahálá hára me hára titiya áwáng háuráng. ");
INSERT INTO klt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kulá kawana Feliks yá Pol ya men áwán du Tertulus yá Feliks rahálá hára Pol táng me hára titiya ing miuk, “Feliks kák ku ámna álosim hánám. Nán Juda ámna náráwa wawu kák tárang káin átang rám hásák kun erawák ma táená álo kámá hánám átang áwánggoemán, me kákkán nanará álosim wa isutang kálu kandák kámá kak rina árená wa sangga kálu kándáng wa rewe isutkoemán. ");
INSERT INTO klt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ále rekáin rekáin watá kálu rina rina me nanará kákkán káinnan kunggoek wa kangga pahán álosim hánám wa naránggoemán. ");
INSERT INTO klt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kulá nándá kákkán rám ma táng uyindámán, ináku ko nán pahán námángga nándán me hátetná kimo ná narinelák wawu ing, ");
INSERT INTO klt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","nándá káemán du ámna nátá tán márapmá hulá hulá yá tunggafenggoek. Itná itná káin Juda ámna náráwa átaráng wata orek yáni káin ámna nátá tán kuk tángga menman tángga kun erawák tángngátaráng. Ámna wawu Juda nán nápmangga tombong káman kutná Nasaret ing menggoeráng wata táwi yáni ya átkoek. ");
INSERT INTO klt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Hang Táwi yan it káungá hánám wa hányon táng konep tátáya tán kangga ku wata ket táumán. Wata ku ko kayon ináng sulitá málámbá milunná hára men kangga ku nándá me rina memán wawu pálipuk ingga káinelák.” ");
INSERT INTO klt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kulá wáina men Juda yáni wu kámuk hánám me wawu pálipuk ingga Tertulus háláng imángga miuráng. ");
INSERT INTO klt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Watá met sálin du Pol yá me metátáya Feliks yá ket tárák hára inán du Pol yá ing miuk, “Há naret, kák ku yara táup pon ále nátán ámna náráwa yan me horengga nanará ámna átnándalák, wata ku no pahánna yá álo kámá nangnaráng nangán kálu áráng hákhátik naya ku ing meindet. ");
INSERT INTO klt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","No Ánutu ináng sákngin ingga Jerusalem káin árut náya áwáng rám nahára átat wawu rám kula ku 13 hálengga átak. Ko ámna kámá yánáng sulingga káulák ináku wata pálipuk ingga kanát naránggim. ");
INSERT INTO klt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Rám Jerusalem káin átut wahára wu no it káungá káin wa ámna káman yot menmen kámá ma tángga áre nahuráng, me it yáilá wata kinan me Juda yan miti itná kinan wakáin ámna iháng urum tángga pahán yánin haha kámá ma tángga áre nahuráng. ");
INSERT INTO klt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Iná me ná mengga nák neháng me hára teráng wawu kusák rewe. Watá me yáni wawu pálipuk ingga mengga kálu kámá kák kakaleyan wawu muná. ");
INSERT INTO klt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Me meráng wahára káman wawu pálipuk, no Jesu yan kálu wa isutnándat, wawu miti kusák ing meráng wa. Wata kinan yon nák ku táwi ilom náni yan Ánutu wa ináng sákngingngátat. Hang meng rákit me yá rina mek me profet tá rina uyená kámuk hánám pálipuk ingga narángga isutnándat. ");
INSERT INTO klt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Iná nák ku pahánna káin du Juda ámna nahára átaráng nátán káin átak wáinanyon átak, wawu máriya Ánutu yá ámna há kámurená wa iháng tárut táinek, ámna kándáng me ámna mukmuro táená wa kámuk. ");
INSERT INTO klt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kulá wáina wata ku na rina tángga ku rámá rámá Ánutu rahálá hára pahánna watá kándáng re árik me ámna náráwa rahán yáni hára ket tárákna yá kándáng re árik ingga yáupmá háláng tángngátat. ");
INSERT INTO klt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yara táup simbon it kámá káin átningga sangga ku nangán tombong hára ukuro mara wa sup yámámáya me taha titiya Jerusalem káin áwut. ");
INSERT INTO klt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kulá wáina táin ingga Táwi yan it káungá hánám káin kung áre nahuráng. Rám wahára wu Táwi rahálá hára rongrongngá há átut. Wahára no ámna urum kámá yot átang márapmá kámá ma táumán. ");
INSERT INTO klt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Enendu Juda kámá Esia provins káin árená watá áwáng nahángga kuk táng namángga me táng namuráng. Wáina wata ku ámna Esia nan watá neháng me hára titiya narángga hálendu yáni yon áwáng kák rahála hára hulá rina wa kándáng kanineráng. ");
INSERT INTO klt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Iná muná hálendu Juda yan kaunsol ámna nahára átaráng watá kaunsol rahán yáni hára me kandák rina me nahuráng wa yáni meineráng. ");
INSERT INTO klt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","No me káman ing mengga orek yáni hára hetang átang mantáe narángga nák ka heronge ma naráng namuráng wata hám, ‘Nák ku ing naráng hátingngátat, kámurená wawu son tárutneráng. Hulá wata ku neháng áwáng me hára ná ting sat átat,’ kaunsol rahán yáni hára wáina mantáut,” Pol yá me pukon Feliks wáina inuk. ");
INSERT INTO klt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks yá Jesu isusut tán kálu me rina rina naráng háting mángngátaráng wawu kándáng hánám há narek. Kulá Pol yá me meng háliuk rám wahára wu Feliks yá Juda ámna ing yánuk, “Sándá kung yolop átnárát, rám tewe ámna yáin yáni táwi Lisias watá áwáng han du wáina sándán me ná táng tolinet.” ");
INSERT INTO klt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wáina yánángga ku tewe ámna yáin yáni káman inán Pol táng it kinan tingga pinná tángga ku kimo san along sim árán nuknukngá yá náut kámá kámá háláng iminán du álo háláng imineráng ingga inuk. ");
INSERT INTO klt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Rám kámá átang sangga ku Feliks málám áwáná Drusila Juda náráwa watyot Pol ya pin tin áwáng Jesu ámna náráwa son iháhá wata naráng háting mámá wata men narumálák. ");
INSERT INTO klt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kulá Pol yá me mengga Ánutu rahálá hára kándáng átnát, me ámna náráwa yá yánin átkuku wa kándáng pinná tátá, hang Ánutu yá máriya me hára ámna náráwa iháng tinek wata men naruk hára wu Feliks yá pitángga ku Pol inuk, “Kula yan me ku wa rewe. Há ka kung máriya no rám nukngá tingga ku son pin te áwinelák.” ");
INSERT INTO klt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Rám wahára wu Feliks málám bu Pol yá sup kámá namán sáe along kuinek ingga narángga ku rám máro yon Pol ya pin san kun áwán du meme yándi tángga átkiumálák. ");
INSERT INTO klt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kulá yara yará yá sálikngin du ámna káman kutná Posius Festus watá Feliks yan kome tángga kawana háliuk. Iná Pol wawu Feliks yá Juda ámna iháng heronge tátáya ku san kalabus kinan há átkiuk. ");
INSERT INTO klt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus yá Judia ále káin áwáng it yáilá Sisaria hára rám kaláhu átang sangga ku Jerusalem káin árángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kulá wakáin du pris tátáwi yáni me Juda yan ámna hulá hulá watá áwáng me hulá hulá inángga Pol táng me hára titi wata inuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wáina inángga ku son ing hányon inuráng, “Ko nán náháng heronge tátáya ku tewe ámna yánátá Pol engotang Jerusalem káin áwineráng. Ko wáina wu há hánám táinelák ingga naremán,” ingga inuráng. Wáina inuráng wawu náuta ámna kámá yánát kálu káin kandingga átang Pol utkámut tátáya me hároturáng wata. ");
INSERT INTO klt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Wáina inát tu Festus yá ing yánuk, “Pol wawu Sisaria káin kalabus kinan átnándak, iná nawu nahára rám hátetná kimo átang gu wakáin há kuinet. ");
INSERT INTO klt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Wáina wata ku ámna hulá hulá sán háranan kámá yá áwát nákkot kungga ku kandák kámá táuk hálendu sándá táng wakáin me hára tineráng.” ");
INSERT INTO klt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wáina yánángga ku Festus málám Jerusalem káin rám 8 me 10 hám wáina átang sangga ku son Sisaria káin háuk. Kulá tembátnáya ku me nanará komená hára kung átang Pol ya yánán tewe ámna yá engotang watán káin áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol engotang áwát tu Juda ámna Jerusalem kálu áwáng háuráng yáni wu áwáng áwálák tángga hetang átang gu kandák ku wáina wáina táuk ingga táwi hánám miuráng, enendu me yáni wata páliná yá kándáng álo ma háliuk. ");
INSERT INTO klt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wáina tát tu Pol yá málámba áráng hákhátik ngá tángga ku Festus ing inuk, “Nák ku kandák kámá ma táut. Juda yan meng rákit mená, me Táwi yan it káungá yan meng rákit mená, me Sisa yan meng rákit mená kámá ma yaliut.” ");
INSERT INTO klt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Wáina inuk, enendu Festus málám Juda ámna wa pahán álosim yámámáya narángga ku Pol ing inuk, “Álo Jerusalem káin árángga me ná wakáin no kangga táng totoliya narelák me rina?” ");
INSERT INTO klt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Wáina inán Pol yá inuk, “Muná, náwu Rom bán me nanará itná hára hetang átat. Nák ku Rom ámna, wáina wata ku nákkán me nahára nanará wawu álo. Ka kándáng hánám há naráng namelák wa, Juda ya kandák kámá ma táng yámángngátat. ");
INSERT INTO klt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Pálipuk no kandák kámá rina táut hálen wawu álo neháng kung kátkámut tán kálu hára tin kámutnet. Iná Juda yá nák ka rina rina meráng wawu kusák re, wata ku káman dá nák neháng ket yáni hára titi wawu muná. Nák ku Sisa málámbá hánám nákkán me ná narinek ka naret.” ");
INSERT INTO klt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Wáina inán Festus málám ámna niyá nanará imángngátaráng watyot me metáng hálingga ku inuk, “Ko Sisa yá kákkán me nanaráya melák, wata ku Sisa yan káin kuinelák!” ");
INSERT INTO klt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Rám kámá átang sangga ku King Agripa yot yitná Benaisi watá Sisaria káin Festus kangga pahán káman átang yáup tángga átnát wata áwumálák. ");
INSERT INTO klt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yándi wu Festus yot rám máro yon wakáin átumálák hálendu Pol ya wáina wáina ingga King Agripa inuk, “Feliks yá uláp pon ámna káman táng kalabus káin tiuk wawu inggálu há re átak. ");
INSERT INTO klt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kulá no Jerusalem káin kut hára wu pris tátáwi yáni me Juda yan ámna hulá hulá yáni yá no watán me narángga táng me hára tingga márapmá kámá imámáya nanuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Wáina nanát tu no ing yánut, ‘Rom bán kálu ku wáina muná. Ámna káman dá me hára átang wawu ámna niyá táng me hára tineráng watyot kot hára káman átneráng. Wáina átang rám kámá imátne me rina watán kálu meineráng wata topmá men narinemán.’ ");
INSERT INTO klt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kulá rám ámna watá nákáin áwuráng wahára ku no ma táng husiut, ináku tembátnáya ku me nanará komená hára átang yáne ámna wa engotang áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wáina engotang áwát Juda ámna yá tárutnáráng me miuráng wawu náut kámá káman táwi táená no naret wáina wata kámá ma miuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ináku watá miuráng wawu yánin miti wa isusut wata honhorená yot tu ámna káman há kámutuk kutná Jesu wawu Pol yá son tárutuk ingga mengngátak wata. ");
INSERT INTO klt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Wáina hálendu no me wata hulá kándáng narin ingga táut, enendu naráng yakyawák tángga ku kándáng ma naráng rákit táut, wáina hálendu ing inut, ‘Álo Jerusalem káin árángga me ná wakáin no kangga táng totoliya narelák me rina?’ ");
INSERT INTO klt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wáina ine ku Pol yá muná nák ku Sisa yá ku nákkán me narinek ingga men du inut, ‘Wáina hálendu kalabus kinan átnárá suring kame yáin náni Sisa yan káin kuinelák,’ ingga inut.” ");
INSERT INTO klt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Festus yá wáina inán du Agripa yá inuk, “No ámna watán me nanaráya naret,” ing inán du Festus yá inuk, “Álo tembát tu ko watán me narinelák.” ");
INSERT INTO klt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wáina hálendu tembátnáya ku Agripa káling Benaisi yándi wu kutná kutná álosim wa tánggánengga áwán ámna náráwa yá heronge táng yámát tu tewe ámna yáin yáni táwi yot it yáilá watán ámna yáilá watyot kung urum tátáyan it pahálá kinan háuráng. Wáina hat tu Festus yá tewe ámna yánán Pol engotang áwuráng. ");
INSERT INTO klt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pol engotang áwát tu Festus yá ing yánuk, “King Agripa yot ámna ni nányot átaráng, sándá ámna ná káeráng wawu Juda kámuk hánám watá Jerusalem káin me nákáin kandák wáina wáina tánggoek ingga mengga menman táwi tángga ‘ma átnándák ináku há kámutnek’ ingga mantángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Enendu no káut wawu náut kámá kandák táwi káman táuk ngáya wata ingga utkámut tátáyan tárák ku muná. Málámbá ku nák ku Sisa yá nákkán me narinek ingga miuk, wata ku no Rom káin kuinek ingga miut. ");
INSERT INTO klt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","No me rina uyingga ku hulá wata ingga mengga suring me yáin náni Sisa yan káin kuinek wawu kándáng ma narát. Wáina wata ku no King Agripa kák rahála hára me ámna wa átaráng sán rahán sáni hára ámna ná táng áwáng tet, wawu watá rina men narángga ku sándá háláng namát me wata hulá no kándáng narángga ku wáina kolem uyingga se yáin náni yan káin kuinek. ");
INSERT INTO klt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kalabus kinan nan ámna káman suring me ámna yáilá náni yan káin kukuya hulá wáina ta me hára tiuráng ingga ma uyindát wawu watá kándáng ma háleindák.” ");
INSERT INTO klt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Festus yá wáina men du Agripa yá Pol inuk, “Ko kangán kálu me metátáyan du along átak,” ingga inán du Pol yá ketná hip tángga ku málámbán kálu ing miuk, ");
INSERT INTO klt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, Juda yá nákka rina miuráng wata hulá ya no ing kanin. Álo kámá ku ko nákkán me ná narindelák, ");
INSERT INTO klt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","náuta kák ku Juda yan kálu wa erek hánám narelák, me náuta menmenná tángngátamán wa erek kon narelák. Kulá wáina wata ku ko yolop átang nákkán me ná narinelák. ");
INSERT INTO klt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Uláp nangge kimo hára nangán káwak káin me Jerusalem káin rina átang áwut, wawu Juda wu erek hánám naráng nameráng. ");
INSERT INTO klt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Rám hásák hánám há naráng namángga áwuráng. Yáni kakanáya narángga hálendu álo ing kanánggalát, nák ku uláppon átang gu tombong Farisi wata kinan átang me káto rina rina mengga tená wa isutang átkiut. ");
INSERT INTO klt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Iná me hára ná átat náwu Ánutu yá táwi ilom náni me rina yánuk wata naráng hátingga átnándat, wata ingga tángga ku me hára ná átat ná. ");
INSERT INTO klt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Israel tombong 12 wawu káen me yáungán Ánutu wu pahán yot ináng sákngingga átang gu me rina yánuk wata páliná yá tunggafen kanin ingga hálengga átnándaráng. King, nák ku wáinanyon wata naráng hátingga hálengga átnándat wata ingga ku Juda ámna yá neháng me hára ná tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Hulá náuta ku sán háranan kámá yá Ánutu yá kámurená háranan iháng tárut tángngátak wawu pálipuk ingga ma naráng háting kuráng? ");
INSERT INTO klt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Nák ku uláp pon Jesu Nasaret nan kutná wa táng hang titiya yáupmá táwi hánám táin ingga naránggiut. ");
INSERT INTO klt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Wáina narángga ku Jerusalem káin wáina há tánggiut. Wáina tángga ku pris tátáwi yáni yá háláng wa namát wa tángga átang gu Táwi yan ámna náráwa táwi hánám wa iháng kalabus kinan tinggiut. Iná Juda yan ámna yáilá yá watá kámutneráng ingga menggiuráng wawu nák ku wáina hányon menggiut. ");
INSERT INTO klt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Hang rám táuppon miti itná táup táwi káin yon hangga ket ihángga iháng lem tánggiut. No wáina táe Táwi kutná wa sangga wa me wáik inániráng ingga yáupmá táwi hánám tánggiut. Táwi yan ámna náráwa wata kuk táwi hánám wa naráng yámánggiut hálendu it mulangán káin suling kung kápángga iháng lem tánggiut. ");
INSERT INTO klt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Rám ore waháranyon du pris tátáwi yáni watá wáina táinelák ingga háláng wa namát tu Damaskas káin kuin ingga kut. ");
INSERT INTO klt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","King, káe táitná náut wáina hálengga árán du kunggatang kangngáre alek kálu nan yamá hak hánám káe yamá ina muná wa táng hátek watá na me tombongna nákkot kumán wa náháng támotuk. ");
INSERT INTO klt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wáina tán du nán kámuk hánám iháng hang káwak hára kátingga árátne me káman Hibru me kálu ing mengtán narut, ‘Sol, Sol, náuta ku nák neháng lem tánggoelák? Ko Ánutu táng lem táet ingga kayon ka táng lem tánggoelák.’ ");
INSERT INTO klt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Wáina mengtán narángga ku no inut, ‘Ámna hulá, kák ku ni?’ ingga me ku Táwi yá nanuk, ‘Nák ku Jesu, ko neháng lem tánggoelák wa. ");
INSERT INTO klt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kulá tárutang hetang álák. No kákkán káin tunggafet wawu kák keháng tunggap táe ko yáup nangge háleinelák wata, me ko ku náutá kákkán káin tunggafek wa, me náut kaleinet wa wáina ingga yáninelák wata. ");
INSERT INTO klt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Rám kangán tombong me ále kámá káinnan watá kutkámut tánin ingga táineráng wahára ku no háláng kame álo átkuinelák. No suring kame Juda me ále kámá káinnan watán káin kuinelák, ");
INSERT INTO klt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","wawu kung rahán yáni yawondang páyung hára árená wa iháng hurik tátá yamá káin kuineráng, me Satan dán háláng tárang káin átaráng watá Ánutu yan háláng tárang káin kuineráng. Wáina wata ku Ánutu yá mukmuro yáni yawon yámán du nákka naráng háting namángga rongrongngá hálená waháranyon sengsáráp tángga Ánutu yan ámna náráwa háleineráng,’ wáina ingga Táwi yá nanuk. ");
INSERT INTO klt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“King Agripa, nák ku alek kálu ára hára ina wa men narut watán milun ma yaliut, ");
INSERT INTO klt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ináku hulátingga ku Damaskas káin Táwi yan me yánángga ku Jerusalem ámna náráwa, Judia ále yan ámna náráwa, me ámna náráwa ále kámá káinnan watán káin hányon kungga Táwi yan me yánángga kut. Pahán hurik tángga Ánutu yan káin kuineráng ingga yánángga ku pahán hurik táineráng wata páliná ku ket tárák sáni hára hiták tunggafeinek ingga yánánggiut. ");
INSERT INTO klt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kulá Juda yá it káungá kapmená káin ket nehángga ku nutkámut tánin ingga táuráng wawu hulá ku wa met wata. ");
INSERT INTO klt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Wáina táuráng enendu Ánutu yá háláng namán átang áwángga kula ná átang gu ámna hulá me ámna hánámá sán me wa sánet. No me sánet wawu Moses me profet tá rina tunggafeinek ingga miuráng wanyon sánet, ");
INSERT INTO klt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","wawu ámna Ánutu yá ámna náráwaná son iháháya miuk watá ku márapmá sungga ku kámurená háranan tátárut wawu watá kálak son tárutang gu Ánutu yan yamá wata málámbán tombong Juda me ámna ále kámá káinnan wa yánángga kuk.” ");
INSERT INTO klt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol yá me emá mengga átnárán du Festus yá me hahatiná kálu ing inuk, “Pol, kák ku hohoná. Kák ku nanará táwi táulák watá tán du wa hohelák.” ");
INSERT INTO klt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Wáina inán du Pol yá ing inuk, “Festus ámna álo kámá, nák ma hohit. No me rina menggoet wawu pálipuk hulá pálak menggoet. ");
INSERT INTO klt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King Agripa wawu no me wa menggoet wawu wáina ingga há naráng hálek, wata ku no wa kándáng inánáya ma pitát. Ing há naret, no me wa met wawu king gu há narek ngá met, náuta wa táuráng wawu rahán táwi hára táuráng.” ");
INSERT INTO klt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wáina Festus inángga ku king ing inuk, “King Agripa, kák ku profet tán me wawa pálipuk ingga narelák me rina? Há naret, kák ku pálipuk ingga narelák.” ");
INSERT INTO klt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Wáina inán du king gá inuk, “Rám hátetná kimo nahára ko me nanátá no nare álo hálen Jesu yan tombong álo hálenggem ingga ma narindalák.” ");
INSERT INTO klt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Wáina inán du Pol yá topmá ing inuk, “Rám hátetná me hásák, no Ánutu ya sáponga táng mángngátat wawu watá tán kák me ni nákkán me ná narángga átaráng watá nák inanyon háleineráng, enendu sen náta nan dá ket sáni hárotnirot wata takta naret.” ");
INSERT INTO klt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kulá Pol yá wáina men du King Agripa, kawana Festus, Benaisi me ámna wahára kámuk áturáng watá tárutang ");
INSERT INTO klt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","it pahálá wa sangga kungga ku yáni meme ing táuráng, “Pálipuk hánám ámna nátá kandák káman táuk ka táng kalabus kinan titiyan tárák me táng utkámut tátáyan tárák kámá ma hálek.” ");
INSERT INTO klt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Iná Agripa yá ku Festus inuk, “Ámna náwu Sisa yá watán me nanaráya ma miuk ináku satá along háná kunggim.” ");
INSERT INTO klt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kulá Pol pinná tángga áturáng watá nándá káwak Itali káin kukuya me hárotang sat árán du Pol yot kalabus kinan nan ámna kámá yot iháng tewe ámna urum káman da táwi yáni kutná Julius watá yángotang kukuya ketná hára tiuráng. Ámna wawu Sisa yan tewe ámna tombong háranan. ");
INSERT INTO klt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kulá kilang káman it táwi Adramitium wakáinnan dá áwán wahára árángga kungga ku Esia provins wata kinan táp tangtang it táwi átaráng wahára hanghang tángga kukuya ku hulátingga kumán. Ámna káman kutná Aristakus wawu Masedonia provins nan it yáilá Tesalonaika káin átnándak watá nányot kumán. ");
INSERT INTO klt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tembátnáya ku it táwi Saidon káin kung hengga ku Julius yá Pol háláng imámáya narángga ku Pol san kungga nuknukngá kápán náuta kesák táuk wa háláng imámáya kuk. ");
INSERT INTO klt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulá wahára átang gu Saidon sangga kungga kálu kukuya kumán wawu iruk ká hásingga kálu maráng námán du ailan Saiprus numkálu kumán. ");
INSERT INTO klt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Táp táitná háng tángga kungga ku Silisia provins yot Pamfilia distrik kán táp isutang kungga Lisia provins káin it yáila Maira káin kung hiumán. ");
INSERT INTO klt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kung wakáin du tewe ámna yáin yáni watá káuk ku it yáilá Aleksandria yan kilang káman dá Itali kukuya tán kangga ku kilang wahára árángga ku Itali ya kumán. ");
INSERT INTO klt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kulá wahára átang gu iruk ká táwi hánám náhángga árán du rám máro yon tumtumá hánám kumán. Wáina kungga yáup háláng hánám tángga it Nidus tangtang kálu kumán, enendu iruk ká táwi hánám tán wakálu ma kukuyan hálendu son hurik tángga ailan Krit kálu kungga wu Salmone kuro ták táng hátingga kungga ailan Krit numkálu kumán. ");
INSERT INTO klt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Wáina kungga ku Krit tán táp hulá wa isutang kumán wawu háláng háláng hánám wáina kungga ku ále ore káman kutná Pasis Álo Kámá wahára kung hiumán. Ále wawu it Lasea wata tangtang káin. ");
INSERT INTO klt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Rám máro hánám watá há kun du Juda yá rám sungi sangngátaráng wawu há táng hátiuráng. Táp pá wáik hálengga árán kálu kukuyan watá pikpito háliuk hálendu Pol yá yánuk, ");
INSERT INTO klt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ámna náut, no káet tu kálu ná áwemán wawu kungga márapmá táwi hánám hára kukuyan tárák hálengga átak. Náni me kutná kutná me kilang kot kámuk yakyawinemán dán tárák.” ");
INSERT INTO klt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pol yá wáina yánuk, enendu tewe ámna yáin yáni watá ku Pol yan me wa ma narená ku kilang gán kepten me kilang márumá watán nanará isutuk. ");
INSERT INTO klt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pasis wa áturáng wawu iruk rámá hára átnát tán tárák muná wáina hálendu táup hánám watá ku pasis wa sangga ku kung it táwi Finiks yan pasis káin árátne iruk rámá watá sálikngik ingga miuráng. Finiks yan pasis wawu ailan Krit káin átnándak, káe yá haha irang kálu along álo kukuyan me káe yá haha ámang kálu along wáinanyon kukuyan. ");
INSERT INTO klt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kulá ámuta kálu nan iruk isikimo yá hásiuk wahára wu watá nángorán rehára kukuya miumán wakáin álo kuinemán ing mengga sangga ku anka uying sat árán du Krit tán táp hulá isutang kumán. ");
INSERT INTO klt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kungga átumán enendu rám isikimo emá kungga átnáne iruk maming hánám táwi watá ailan torong kálu hásingga háuk. Iruk wawu ánuta yan iruk ing mengngátaráng. ");
INSERT INTO klt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Iruk watá áwáng kilang wa táwi hánám tán du kilang pinná tátá watá kilang wa táng hurik tátáya tát men du sat iruk watá kilang wa hásingga tángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wáina tán du ailan isikimo kutná Kauda wata susuya kung árátne iruk ká hálángngá han du bot isikimo uying satne kilang wata kinan áwik ingga ku yáup háláng hánám wa tángga átang gu uying satne árán páup pá káto hárotumán. ");
INSERT INTO klt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kulá wáina tángga ku kilang wa káto hárot táng sat átnát ta páup maming tátáwi hirarát kilang tárang kálu kut tu iháng kik táuráng. Iruk ká iháng kung táp káin ále ore káman kutná Sitis wawu sán dá táp kinan yamán dá ina átaráng wata ketnán tiwon ingga pikpito naruráng, wáina hálendu lap kilang káin putená wa uying hirarát hat, hang palang maming tái anka ina putingga sat táp kinan han du kilang gá ku tumtumá kuk. Wáina tángga ku sat tu iruk ká kilang wa tángga kuk. ");
INSERT INTO klt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tembátnáya ku iruk me táp watá táwi hánám wa tángga náháng sunggulinán tán kangga ku kilang pinná tátá yá wu yumnak tátáyan kutná kutná kilang kinan nan wa táng hirarát táp kinan háuráng. ");
INSERT INTO klt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Wáina tángga árán rám kaláhu hálengga árán du kilang pinná tátá watá kutná kutná kilang tán kándáng kuku wa táng hirarát táp kinan háuráng. ");
INSERT INTO klt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wáina tángga rám máro hánám wa káe me hitung kámá ma kápumán, hang táp me iruk táwi tángga átuk wáina hálendu kungga kep káin kukuyan nanará wa nápmangga kun du muná kuku wahára pahán tingga itumán. ");
INSERT INTO klt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kulá ámna yá sungi ma náená rám hásák árát tu Pol yá orek yáni hára tárutang gu yánuk, “Sándá nákkán milun isutang ailan Krit káin há átumán ináku rám wáik ing ma kanggatnem me kutná kutná tái nátá ing ma yakyawinggalát. ");
INSERT INTO klt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Enendu pahán sáni ma háindak, náuta orek náni hára káman dá ma yakyawindák, ináku kilang gá re ku wáina márikngingga háinek. ");
INSERT INTO klt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kuip yáungán Ánutu ni nák nangot koek me no naráng háting mánggoet watán angelo yá áwáng kondonna hára árán kangngáre ");
INSERT INTO klt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ing nanák, ‘Pol, ma pitáindalák. Há átang kungga Sisa rahálá hára ku há átnelák. Ánutu yá kák pahán kamek wata tángga ku ámna kilang hára átaráng waháranan káman du ma yakyawindák.’ ");
INSERT INTO klt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Wáina nanák wata ku pahán sáni ma háindak. No ing hánám há naret, Ánutu yá rina nanák wawu wáina há táinek. ");
INSERT INTO klt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wáina táinek enendu kilang wawu kung rehára kámá ailan hára kátingga wáik háleinek.” ");
INSERT INTO klt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kulá yáung 14 wahára ku Mediterenian táp wakálu iruk ká náhán kungga átumán. Yáung táitná náut wáina kálu kilang pinná tátá yá “kámá káwak tangtang hám áwemán,” ingga mengga ku ");
INSERT INTO klt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","yáni wu náut kámá márapmá páup pá putená wa táp kinan sat han táp hásákngá wa káuráng gu 40 mita kangga son isikimo sim kungga son sat han káuráng gu 30 mita. ");
INSERT INTO klt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Yáni wu kungga sup ketnán áráninggom ingga pitángga ku anka 4 hirarát sárummá kálu han du álo árátne kungga it tá háinek ingga wata sáponga tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kilang pinná tátá yá bot isikimo hára árángga kilang sangga kunin ingga ku bot isikimo páupmá yalit táp káin han du kusák pilengga kilang kuro káin anka hiratne hangga átaráng ingga tángga áturáng. ");
INSERT INTO klt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Wáina tát kápángga Pol yá tewe ámna yáin yáni yot tewe ámna wa yánuk, “Ámna nátá kilang káin ma átnándáráng wawu sándu yakyawineráng.” ");
INSERT INTO klt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Wáina ingga yánán du watá páup bot putená wa maráng rákrákit tát tu bot watá hánámá kuk. ");
INSERT INTO klt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kulá káe yá áráng heinán tángga átuk kálu ku sungi kámá nanaya Pol yá me káto ing yánuk, “Rám hásák hánám átnemán me kámutnemán ingga pahán sáni sángen sungi ma náená árát rám 14 hálengga átak. ");
INSERT INTO klt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Wata ku sungi náineráng watá ku háláng sáminek. Ing narineráng, sándu rina kámá ma táindáráng. Sán kámuk ku álo rewe átneráng.” ");
INSERT INTO klt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wáina yánángga ku másáng táng rahán yáni hára sáponga tángga ulángga náuk. ");
INSERT INTO klt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wáina tán kangga kámuk hánám pahán yáni álosim hálen narángga ku sungi yáni iháng náuráng. ");
INSERT INTO klt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kilang kinan átumán wata sale náni kámuk ku 276. ");
INSERT INTO klt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yáni wu sungi tárák yáni hára álo nangga ku wit bek kilang kinan árená wa táng hirarát táp kinan hat tu kilang gá tiyawingga áruk. ");
INSERT INTO klt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kulá it tá háiuk hára hálengga káwak ku enanggon árán há káuráng, enendu wahára áwemán ingga ma naruráng. Ále wahára áwemán ingga ma narená pasis káman sán dá re álo kámá árán kangga ku kung wahára álo hám hanggatnem ingga ku kilang wa raták tátne wahára kuik ingga naruráng. ");
INSERT INTO klt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wáina nangnaráng gu anka páup yáni wa marángga ku yápmat táp kinan hat tu waháranyon kilang táng hukhurik tátá yangngá káin átnándamálák wata páup yándi yalingga sel kuro tangtang árená wa uyit árán iruk ká wahára hásingga árán du sán káin hanin ingga kuráng. ");
INSERT INTO klt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Enendu kilang kuro watá kung táp kinan sán ketnán árángga káto hálengga árán táp punggilá yá áwáng kilang yangngá wa káting mákmárák tángtáng tángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wáina tángga árán kangga ku tewe ámna yá ku kalabus kinan nan ámna wa ráháng kátkámut tátáya me táuráng, náuta táp kinan hangga pipiya tángga há yáni kunirot ingga wata. ");
INSERT INTO klt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tewe ámna yá nanará wáina tiuráng, enendu tewe ámna yáin yáni watá Pol yan átkuku wa ma táng hátek tátáya naruk, wáina wata ku watá kalabus kinan árená wa ma ráháng kátkámut táindaráng ingga yánuk. Niyá pipiya álo tátáyan watá kálak kilang sangga hitangga pipiya tángga sán káin kuniráng ingga yánuk. ");
INSERT INTO klt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Iná kátu yá ku palang me kilang márikngená kátu hára tángga átang gu sán káin kuniráng ingga yánuk. Wáina yánán du watán me isutang kámuk hánám sán káin há kumán. Orek náni hára káman kámá ma yakyawiuk. ");
INSERT INTO klt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kung sán káin álo re hangga káumán du ailan wawu Malta. ");
INSERT INTO klt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Iná ailan waháranan watá náhángga áwáng rina kámá ma táuráng ináku heronge náháng mengga ku ále yá tangga átang kotkoringga átuk hálendu káráp sing námuráng. ");
INSERT INTO klt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol yá kung káráp kámá kámondang iháng áwáng singngárán kunap wáik káman káráp kinan átuk watá káráp yamá yá kan áwáng Pol ketná hára sángga tuhángga átuk. ");
INSERT INTO klt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wáina kangga ámna náráwa ailan waháranan dá yáni meme táuráng, “Ámna náwu ámna ráháng kátkámut tángngátak hám, wata ku márapmá táwi wata kinan hanggoek. Táp káin márapmá kinan háuk, enendu ma kámurak, kulá hang márapmá nukngá yá ku táp tangtang káin son táek. Ánutu náni kutná Topmá Tátá watá ámna nátá ma hám átnát ta narek.” ");
INSERT INTO klt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","6","Wáina mengmeng átang káuráng gu Pol yá kunap wa káting san kung káráp rangga árená wata kinan háuk. Kulá ámna náráwa yá ku Pol ketná yá tiháinek me kámutang táng hang kátinek ingga rám hásák kangga áturáng, enendu rina kámá kámá Pol sutná hára ma tunggafiuk. Wáina ma tunggafen kangga ku nanará wa sangga son ámna náwu ánutu káman ing miuráng. ");
INSERT INTO klt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kulá it kapme táwi káman enanggon wahára átuk wata márumá ku ámna káman kutná Puplius. Ámna wawu ailan watán ámna hulá táwi. Ámna watá heronge mená nánángga nángot kung itná káin tingga pin náni kándáng tán watyot rám kaláhu átumán. ");
INSERT INTO klt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Iná ámna wata naning gu ilalák tángga kámun táptáráp sippot sippot tángga sutná yá ángárángin átuk. Wáina árán Pol málám kung wa kangga sáponga táng mángga sangga ku ketná yá yáilá hára usáng hang tin álo háliuk. ");
INSERT INTO klt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wáina álo hálek ingga met narángga ku ilalák mara ailan wahára árená watá kámuk Pol yan káin áwángga álo hángháleng táuráng. ");
INSERT INTO klt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wáina hálendu kut náni meng toling nángnámáng kándáng hánám wa náháng tolingga árát kungga nándá kukuya táumán wahára wu kutná kutná náuta kesák táumán wa háláng námuráng. ");
INSERT INTO klt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ailan wahára yap kaláhu átumán. Kulá it yáilá Aleksandria yan kilang káman ailan wahára iruk rámá watá sálin kuin ingga háleng mángga átuk. Iruk rámá watá há sálikngin du kilang wahára kumán. Kilang wata kuro káin du ánutu kusák yará wawu punpuran Kasto káling Poluks wata utni yándi yá átumálák. ");
INSERT INTO klt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kungga ku it táwi Sirakyus wakáin kung rám kaláhu wahára átumán. ");
INSERT INTO klt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulá waháranan dá ku kungga it táwi Regium káin kung hiumán. Iná tembátnáya ku káwak ámuta yan iruk watá tárutang háláng námán du Regium sangga kungga rám nukngá hára wu it táwi Puteoli wakáin kung hiumán. ");
INSERT INTO klt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","It wakáin du Jesu yan tombong kámá wakáin kápátne ku watá sonda orek kámá nányot átneráng ingga nánángga nángorát kumán. Kulá waháranan dá ku háram kálu kungga it yáilá Rom ba kumán. ");
INSERT INTO klt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kulá Jesu yan tombong Rom káin áturáng watá wáina áwángga átkoeráng ingga met naruráng hára wu kálu pana nánáháya áwuráng. Wáina áwát nándu kungga Apius yan maket wahára kámá kápángga ku son kungga it kutná Lombu It Kaláhu wahára kámá kápumán. Wa kápángga ku Pol yá Ánutu heronge táng mángga ku pahálá kinan háláng táuk. ");
INSERT INTO klt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kulá Rom káin kung hiumán hára wu tewe ámna yáin yáni yá álo ingga men Pol wu it hánámá káman sang mát tu tewe ámna káman táng tin wata pinná átuk. ");
INSERT INTO klt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kung Rom káin rám kaláhu átang sangga ku Pol yá Juda wakáin árená wata yáin yáni watá áwineráng ingga men áwát tu yánuk, “Yanuknukna, no ámna náráwa náni Juda ya rina kámá ma táut, me táwi ilom náni yan kálu wa kámá ma hitik táut, enendu Jerusalem káin ket nehángga neháng Rom ket yáni hára tiuráng. ");
INSERT INTO klt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Wáina tát Rom bá nákkán me wa narángga káuráng gu no rina kámá káman táut náya kátkámut tán tárák ku muná. Wáina hálendu nepmat along kukuya táuráng, ");
INSERT INTO klt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","enendu Juda yá no along kuku wata taktak yámán du wáina ma tátá ingga Rom yánuráng, wata ku no Sisa yá nákkán me narinek ingga miut. No wáina miut wawu náuta no nare há átnát tán káluná muná. Wáina miut wawu no tombongna Juda wa iháng Rom rahán yáni hára me hára titiya muná. ");
INSERT INTO klt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Wáina hálendu me wa sásánáya ku pin te áweráng. Ánutu yá ámna náráwaná son iháhá watá áwinek ingga Israel nán uláp nánuk. No me wa pálipuk ingga naráng hátingngátat wáina hálendu sen dá ná káto nehángga átak ná.” ");
INSERT INTO klt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wáina yánán du Juda áturáng watá inuráng, “Nándu papia kámá Judia kálu nan kák ka wáina ingga kámá ma sat áwán káumán, hang nuknuk náni kámá wakálu áwuráng watá kák ka me kandák kámá ma met narumán. ");
INSERT INTO klt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ináku inggálu ku ámna náráwa itná itná watá miti mirak tunggafen wata wawu wáik ingga menggoeráng, wata ku ko rina hánám wa kándáng metá narinemán.” ");
INSERT INTO klt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Wáina inángga ku rám káman tingga wahára áwinemán ingga miuráng. Rám wahára ku ámna táup hánám watá it Pol yá átuk wakáin hilápmá kálu áwáng árát kungga yonyon tiuk. Wahára wu málám Ánutu yan átkuku wata wáina ingga hiták hánám yánángga ku Moses yan meng rákit me, me profet tán me wa kámá mengga ku me wahára kungga kándáng narángga Jesu ya naráng háting mániráng ingga kándáng hánám yánáng toktolik táuk. ");
INSERT INTO klt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wáina yánán du kámá yá ku Pol yá rina miuk wawu pálipuk ingga naruráng, iná kámá yá ku pálipuk ingga ma naruráng. ");
INSERT INTO klt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Wa nangnaráng tángga ku kunin ingga tángngárát tu Pol yá ing miuk, “Iruk Káungá watá profet Aisaia wata milunná hára táwi ilom náni wa me pálipuk hánám yánuk, wawu ing, ");
INSERT INTO klt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ko kungga ámna náráwa wa ing yánáng, “Sándu narineráng enendu wata hulá hánám bu wáina ingga ma narindáráng, me rahán sáni hálengga átneráng enendu páliná wu ma káindáráng,” wáina ingga yánáng. ");
INSERT INTO klt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ámna náráwa wata pahán yáni wu há káto háliuk, iná káráman yáni yá me nanará ya taktak yámán yáni yon rahán yáni ruháng táringga átaráng. Wáina táuráng, náuta rahán yáni yá kangga káráman yáni yá narángga wata hulá wáina ingga pahán yáni káin narángga ku pahán yáni hurik tát no iháng totoliya takta naruráng wata.’ Aisaia yá ku me wáina miuk. ");
INSERT INTO klt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","“Kulá wata ku sándá ing narineráng, Ánutu yá ámna náráwa son iháháya miuk watán me wawu san ámna náráwa ále kámá káinnan watán káin há kuk wa watá ku narineráng.” ");
INSERT INTO klt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kulá Pol málám bu yara yará it káman hára átkiuk. Átang gu it wahára átnát ta it wata márumá sup kámá imánggiuk. Káman niyá kakaya áwánggiuk wawu iháng heronge tánggiuk. ");
INSERT INTO klt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Táwi yan me yánáng tolinggiuk wahára wu náut kámá káman dá káto táng mámáyan du muná. Málám ma pitáená Ánutu yan átkuku wata yánángga ku Táwi Jesu Son Iháhá wawu wáina wáina ingga yánáng tolinggiuk. ");
INSERT INTO klt_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Nák ku aposel Pol. Ámna káman dá aposel yáup ná tátáya ma suring namuk, me ámna káman dá aposel yáup wa táinelák ingga ma neháng tunggap táuk. Jesu Son Iháhá me Nan Ánutu ni Jesu há kámurená háranan táng tárut táuk watá yáup ná namumálák. ");
INSERT INTO klt_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Yanuknukna nayot átamán nándá papia ná satne Jesu yan tombong Galesia provins káin átaráng sándán da áwek. ");
INSERT INTO klt_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Nan náni Ánutu yot Táwi Jesu Son Iháhá watá pahán sámán du pahán láláp pá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Jesu yá Nan náni Ánutu yan pahán isutang nándán mukmuro yanyawon da málámbán átkuku wa sáuk. Wáina tángga káwak nátán mukmuro hulá hulá táwi hánám wata kinan nan son náhuk. ");
INSERT INTO klt_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Wáina wata ku rámá rámá Ánutu kutná meng tárut tángga átkuinemán. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Nák ku pahánna kinan yon táwi hánám hárámutut náyá wáina re átang áwánggoet, náuta sándu Jesu Son Iháhá watá pahán sámángga yáup rina táuk wahára kungga ku Ánutu yá málámbán ámna náráwa háháleya mantáng sámuk, enendu sándá sopmuná hánám wa sangga me pingnga hulá kámá wa isutkoeráng. ");
INSERT INTO klt_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Wáina tánggoeráng enendu me pingnga álosim wawu káman dá re hánám átak, nukngá kámá ma árak. Ámna kámá yá nanará sáni wa táng yakyawák tángga ku me hulá kámá wa iháng áwáng Jesu Son Iháhá yan me pingnga álosim wa táng hukhurik tát kámá kámá kunggoek. ");
INSERT INTO klt_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Iná nán háranan ámna káman me alek káinnan angelo káman me ámna nukngá kámá yá áwáng me pingnga álosim nándá uláp sánumán wa sangga me nukngá kámá sáninemán hálendu ámna niyá kálu wáina táinek wawu káráp lánggop sásáliná muná watán pingnga háleinek! ");
INSERT INTO klt_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Me há miumán wa son meinándet. Káman niyá áwáng me pingnga álosim sándá uláp táuráng wa sangga me nukngá kámá sáninek hálen ámna wawu káráp lánggop sásáliná muná watán pingnga háleinek! ");
INSERT INTO klt_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Kulá no me wa met wawu ámna yá naráng namát álosim háháleya, me Ánutu yá naráng namán álosim háháleya me? Me hánámá ámna pahán yáni táng heronge tátáya re hám tánggoet? Muná. Uláp pu met wáina tánggiut, iná inggálu pálipuk no hánámá ámna pahán yáni táng heronge tátáya re tánggoet hálen wawu nák ku Jesu Son Iháhá watán yáup nangge muná. ");
INSERT INTO klt_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Yanuknukna, no pálipuk hánám ing sánin, no Jesu yan me pingnga uláp sánut wawu ámna nangge yá ma táng tunggap táená. ");
INSERT INTO klt_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","No me pingnga álosim wa ámna káman dán hára ma táut, me káman dá ma nanáng toliuk. Ináku Jesu Son Iháhá málámbá ku me pingnga álosim wa meng tunggap tán hiták hálen no wa táut. ");
INSERT INTO klt_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Uláp no Juda yan miti hára kálu ket tárák rina isutkiuráng wa isutang átang Jesu yan ámna náráwa wa iháng wáik tánggiut wawu sáni pingngana há nareráng wa. No Jesu yan tombong iháng lem hánám tángga ku wa iháng wáik táe pukon muná kukuya tánggiut. ");
INSERT INTO klt_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","No táwi ilomna yan kálu wa isusut wata táup hánám káto hálenggiut. Juda yan miti káluná isusut wawu no ámna tunggafefe náni káman nákkán tombong Juda nan áturáng wa iháng hátingga kándáng hánám isutkiut. ");
INSERT INTO klt_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Wáina tánggiut enendu uláp mam kinan átut waháranyon Ánutu yá há neháng tunggap tángga ku málámbá pahán namángga mantáng namángga neháng málámbán pingnga ya tiuk. Málámbán pahán isutang ");
INSERT INTO klt_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Nanggená wa wáina ingga hiták naliuk wawu náuta, no Jesu yan me pingnga álosim wa ámna náráwa ále kámá káinnan wa yánángga átkukuya. Kulá Ánutu yá wa naliuk wahára wu Jesu ya naráng mámáya no kung ámna kámá ma yánáng suliut, ");
INSERT INTO klt_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","hang no Jerusalem káin kung ámna aposel kut watá kálak tát no táut wa yánáng sulingga nanaráya manyon kut. Ináku waháranyon kung ále Arebia káin átang gu máriya ku son it yáilá Damaskas káin kut. ");
INSERT INTO klt_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Kulá Jesu ya naráng háting mángga áre yara kaláhu hálendu Jerusalem káin Pita kangga kámá yá kámá ya narángmán narángmán tátáya wata kut. Kung wakáin watyot rám 15 átumát. ");
INSERT INTO klt_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Enendu rám wa átut wahára aposel kátu wa ma káput, Táwi Jesu kulaná Jeims wa rewe ku káut. ");
INSERT INTO klt_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Ánutu rahálá hára no ing sánin, no me pingnga wa uying sámángga átat wawu pálipuk hánám, ma sángsárunginggut. ");
INSERT INTO klt_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Kulá wata torong káin du provins Siria yot Silisia káin kut. ");
INSERT INTO klt_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Iná Jesu Son Iháhá yan ámna náráwa Judia ále hára it wakáin wakáin áturáng watá ku nák kurák mátapna wáina ingga ma rewe káená áturáng. ");
INSERT INTO klt_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Ináku pingngana rewe ku ing naránggiuráng, “Huphuráp pu ámna watá náháng wáik tángga Jesu yan me pingnga álosim wa táng wáik tánggiuk, enendu inggálu ku wanyon meng isutang átninggoek.” ");
INSERT INTO klt_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Ánutu yá nák neháng rina táuk wa narángga ku wata Ánutu kutná meng tárut tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Yara 14 átang sangga ku Banabas yot nát tá Jerusalem káin son árángga kukuya no Taitus ine nátyot káman kumán. ");
INSERT INTO klt_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Kulá Táwi málámbá wakáin kuinelák ingga há nanán du kut watá kung Jerusalem káin átang gu Jesu yan ámna náráwa yáin yáni wa rewe ku me pingnga álosim ámna ále kámá káinnan yánángngátat wata yánut. Yáup rina tánggoet me uláp tánggiut watá hánámá háleiwon ingga ku wata yánut. ");
INSERT INTO klt_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Rám wahára wu Taitus yot káman átumát. Wawu Grik ámna, enendu Juda yan kálu isutang kipmá mamaráya kámá ma miuráng. ");
INSERT INTO klt_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Kip mamará mená watá tunggafiuk wawu ámna kámá Jesu yan tombong ingga kusák pilengga átningngátaráng watá náháng hang titiya nanará yáni káin kilak árán wa pálak áwáng nándán urum wata kinan áturáng. Kálu kándáng Jesu Son Iháhá yá námuk wawu meng rákit me yan kumbi kinan árená waháranan náháng along tiuk wa ámna watá son tát kung watán kumbi kinan átnát ta naruráng. ");
INSERT INTO klt_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Wáina miuráng enendu nándá watán me kátu kimo káman wahára miuráng waháranan narángga ma hánám táumán. Wáina táumán wawu nándá ku me pingnga álosim watán me páliná watá wáina re sányot átnát wata. ");
INSERT INTO klt_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Ámna kámá wu miti yáup watán ámna yáilá ya átaráng, enendu nákkán nanará káin wawu ámna kut yáni pálak me ámna hánámá watá kutná táwi ma hálek. Ánutu yá ámna nangge sut me kut ihená ma kangngátak, ináku pahán yáni kinan kangngátak. Ámna yáilá ingga wahára áturáng watá no me pingnga álosim yánángga átningngátat wata yáne watá rina kámá kámá wata ketnán ma miuráng. ");
INSERT INTO klt_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Watá káuráng gu Ánutu yá yáup nák namuk wawu no Jesu yan me pingnga wa ámna náráwa ále kámá káinnan yánánáyan, hang káuráng gu Pita wu yáup wáinanyon imuk wawu Juda ámna náráwa wa me pingnga álosim yánánáyan. ");
INSERT INTO klt_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Pálipuk, Ánutu yá háláng wa Pita imán Juda ámna náráwa orek yáni káin aposel yáup tánggoek, wáinanyon du nák háláng namán no ámna náráwa ále kámá káinnan orek yáni káin aposel yáup tánggoet. ");
INSERT INTO klt_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Kulá Jeims, Pita me Jon wawu ámna náráwa yá kápát miti yan ámna yáilá hálengngátak watá nák nahángga ku Ánutu yá pahán imángga ku yáup wa imán tánggoek ingga narángga Banabas yot ket nátin tángga nuk náni ingga náhuráng. Wáina náhát watyot pahán káman hálengga ku nát tá ále kámá káinnan watán káin yáup táte ku yáni wu Juda yan káin yáup táineráng ingga me hárotumán. ");
INSERT INTO klt_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Me káman re nánuráng wawu ámna náráwa ukuro árená wa háláng yámángga átningguinemálák ingga nánuráng. Yáup wáina wawu uláp há tángga áwánggiut náyá emá re há tángga átkuinet wata heronge naránggoet. ");
INSERT INTO klt_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Pita yá it yáilá Antiok káin áwáng átang gu kálu kandák hiták hánám tán kangga rahán táwi hára me táng mut. ");
INSERT INTO klt_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Pita yá kandák táuk wata pingnganá ku ing, huphuráp pu ámna ále kámá káinnan Jesu yan tombong hálengga árená watyot káman átang sungi nanggiuráng. Máriya ku Jeims yá ámna kámá suring yámuk watá Antiok káin áwáng árát tu Pita yá wa kápángga pitáng yámángga ku ámna ále kámá káinnan watyot sungi káman nana wata pahán yará tángga árongga átang yápmang kung Juda ámna yot rewe átuk. Wa pitáng yámuk wawu Juda ámna Jesu ya naráng háting mená kátu yá ku ámna Jesu yan tombong hálená wawu kámuk hánám kip yáni há mamará háleinek ingga mengngátaráng wata. ");
INSERT INTO klt_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Kulá Pita yá ket tárák kandák wáina tán kangga Juda kámá Antiok káin árená watá wa isutang wáinanyon tánggiuráng. Wáina tángga árát tu Banabas wawu watán ket tárák kandák watá hányon uying san kung wata kinan háuk. ");
INSERT INTO klt_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Wáina tángga árát no káput wawu me pingnga álosim watán me páliná hánám wa kándáng ma isurát tu rahán yáni hára Pita ing inut, “Kák ku Juda ámna, enendu ko ket tárák tánggoelák wawu ále kámá káinnan dá ina tánggoelák, Juda ámna yá ina ma tánggulák. Wáina há tánggoelák ngáyá ku náuta ále kámá káinnan yánátá watá Juda yan kálu wa isusut ta káto hálenggoelák? ");
INSERT INTO klt_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","“Juda nán wawu tombong Juda waháranan hánám tunggafená, wata ku Moses yan meng rákit me rina wa há naremán. Nándu ále kámá káinnan meng rákit mená wa ma narená waháranan muná. ");
INSERT INTO klt_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Enendu ing narinemán, ámna niyá Moses yan meng rákit me wa rewe isutnek wata Ánutu yá ámna kándáng ingga ma meindák, ináku niyá Jesu Son Iháhá wata naráng háting minek wa rewe ku Ánutu yá ámna kándáng ingga meinek. Nándu Jesu ya naráng háting mánggoemán, kálu wahára re wu Ánutu yá ámna kándáng ingga náninek, meng rákit me káluná wahára muná. Ámna káman dá meng rákit me wa kándáng hánám isurán Ánutu yá ámna kándáng ingga ma meindák. ");
INSERT INTO klt_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","“Nándá Jesu Son Iháhá wata naráng háting mámá káluná wahára árátne ku Ánutu rahálá hára kándáng háliuk. Nándu naráng hákhátik kálu isutang átkoemán iná meng rákit me yan kálu wa ma isutkumán, wata ku Juda ámna yá sándu kandák tánggoeráng ingga mengngátaráng. Wáina mengngátaráng, wata ku Jesu málámbá ku kálu kandák táená wa táng káto tánggoek ingga ku álo hám menggatnem? Wawu muná hánám, wáina ma meindamán. ");
INSERT INTO klt_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Iná meng rákit me isusut wa nayon há yawondang gu máriya son táng tárut táinet wawu kandák há táinet. ");
INSERT INTO klt_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Uláp nák ku meng rákit me wata tárang káin átkiut, iná inggálu ku meng rákit me káluná wa há sangga ku Ánutu yan átnát álosim wata kinan káin átang málámba tárang káin átkoet. ");
INSERT INTO klt_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Maripong hára Jesu Son Iháhá yot há kámutang átkuku mirak wa há táut. Enendu átkuku wawu nákkán muná, ináku Jesu yan átkuku álosim wawu nák kinan átak, wáina hálendu no káwak ketnán ket tárák rina tánggoet wawu Ánutu Nanggená ya naráng háting mámá kálu wahára. Watá nák ka kikiná hánám narángga káwak sutná wa nák háláng namámáya sáuk. ");
INSERT INTO klt_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Ánutu yá nák pahán namánggoek wa káe wu ále hánám ma háleindak. Iná no meng rákit me wa isutang Ánutu rahálá hára álo ámna kándáng háleinet hálen wawu Jesu Son Iháhá wawu hánámá kámutuk ina háleinek.” ");
INSERT INTO klt_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Galesia sándu ámna náráwa hohoná! Nándá Jesu Son Iháhá wawu maripong hára kátiuráng ingga há sánátne naruráng. Niyá sán nanará sáni táng yakyawák tánggoek? ");
INSERT INTO klt_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","No me káman re ing sánáng sulin, sánda Iruk Káungá wawa kálu rekálu táuráng? Sándá Iruk Káungá wa táuráng wawu Moses yan meng rákit me wa isutang átang me, me pingnga álosim wa narángga ku Jesu ya naráng háting mángga ku wa táuráng? ");
INSERT INTO klt_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Sándu há hohinggoeráng! Hulátingga Táwi yan ámna náráwa háliuráng wawu Iruk Káungá watán háláng hára átninggiuráng, enendu inggálu ku son ámna yan háláng hára átkukuya tánggoeráng me? ");
INSERT INTO klt_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Wawu rina, uláp márapmá táwi hánám suwánggiuráng wawu hánámá suwánggiuráng hám? No naret wawu watá hánámá ma háháleya. ");
INSERT INTO klt_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Ánutu yá Iruk Káungá wa sámángga ku orek sáni káin ket tárák hulá hulá tán tunggafenggoek wawu rina ta ku wáina tánggoek? Ánutu yá wáina tánggoek wawu sándá meng rákit me wa isutang árát tu wata tánggoek, me sándá me pingnga álosim wa narángga naráng hákhátik hára árát tu wata tánggoek? ");
INSERT INTO klt_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Kulá sándá Abraham ba narániráng. Ánutu yan papia káin me ing uyená yá átak, “Abraham bá ku Ánutu pálipuk ingga naráng háting muk, wáina wata ku Ánutu yá ámna kándáng ingga miuk.” ");
INSERT INTO klt_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Wáina wata ku ing narineráng, niyá me pingnga álosim wa narángga naráng hákhátik hára káto hálengga átkuineráng wawu Abraham nángánangge páliná hánám. ");
INSERT INTO klt_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Ánutu yá uláppon ing há naruk, ámna náráwa ále kámá káinnan dá me pingnga álosim wa narángga naráng hákhátik hára árát tu no ámna náráwa kándáng ingga meinet ingga naruk. Wáina hálendu uláppon me pingnga álosim wa Abraham há inuk, wawu málámbán papia káin ing mek, “Kák hára kungga ku Ánutu yan sambe yá ámna náráwa kámuk kán káin tunggafengga kuinek.” ");
INSERT INTO klt_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Abraham wawu naráng hákhátik hára átuk hálendu Ánutu yá kuram táng muk, wáinanyon du ámna náráwa niyá naráng hákhátik hára átneráng wawu Ánutu yá kuram táng yáminek. ");
INSERT INTO klt_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Iná ámna náráwa kámá yá meng rákit me wa isutang átang Ánutu rahálá hára kándáng átninggoemán ingga narángngátaráng, enendu wawu muná. Ináku yáni wu mukmuro pálak háleineráng, náuta Ánutu yan me papia káin ing átak, “Ámna niyá meng rákit me papia káin átak wa kámuk hánám ma isutang átkungngátaráng wawu mukmuro yáni pálak, wata ku Ánutu yá márapmá yáminek.” ");
INSERT INTO klt_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Kulá Ánutu yan papia káin me ing átak, “Ámna niyá naráng hákhátik hára átnek wawu Ánutu yá ámna kándáng ingga men átkuku álosim wata kinan átneráng.” Wáina wata ku me yá ku hiták ing nálek, káman dá meng rákit me wa isurán wata ingga Ánutu yá ámna kándáng ingga meme wawu káluná muná. ");
INSERT INTO klt_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Meng rákit me isusut watá naráng hákhátik watyot imáng ronrosin tángga ma áramálák. Ánutu yan me yá papia káin du ing mek, “Ámna niyá meng rákit me wa isutang átkuinek wawu meng rákit me watá átkukuná wa pinná tán átkuinek.” ");
INSERT INTO klt_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Ánutu yan papia yá ing mek, “Ámna ni táng káráp hára tuháng sat átnek wawu ámna mukmuro pálak, wata ku watá márapmá ihinek.” Rám Jesu Son Iháhá watá maripong hára kámutuk wawu nándán kome tángga ku kut “ámna mukmuro pálak” wa tángga kámutuk, wahára kungga ku meng rákit me isutang ámna mukmuro pálak háhále wata kinan átkutne son náhuk. ");
INSERT INTO klt_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Ánutu yá Abraham kuram táng mángga ku ámna náráwa kámuk kán káin sambe yá tunggafengga kuinek ingga inuk. Wáina hálendu Jesu Son Iháhá watá yáup táuk wahára kuram wa tiuk wata páliná yá ámna náráwa ále kámá káinnan watán káin tunggafiuk. Wáina wata ku nándu naráng hákhátik náni wahára kungga ku uláp Ánutu yá miuk wa isutang Iruk Káungá yá ep náhuk. ");
INSERT INTO klt_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Yanuknukna, no ámna nangge nánin átkuku hára tárák káman ing tin, ámna kámá yá me rina hárotang tinggalát wawu nukngá kámá yá me rina hárotgalát wa sengsáráp tángga me nukngá ma tinggalát me, me rina menggalát wa ma yawongalát. Ámna yá me káto wáina táinemán ingga mengga isutnándaráng wáinanyon du Ánutu yá Abraham inuk wa. ");
INSERT INTO klt_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Uláp Ánutu yá me káto wáina táinet ingga miuk wawu Abraham enot tán. Táwi yan me ná uyená watá “e ilomya” ingga ma mek me ámna náráwa táup táwi hánám wata ma mek. Ináku “eka” ingga mek wawu káman re, Jesu Son Iháhá wata mek. ");
INSERT INTO klt_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Nákkán me wata hulá wu ing, Ánutu yá Abraham bot pahán káman mená wa hárotumálák wahára átang yara 430 wata torong káin du meng rákit mená wa Moses ketná hára tiuk. Kulá meng rákit mená máriya tunggafiuk watá pahán káman mená uláp tiuk wa yawondang me káto wáina táinet ingga há miuk wa tán ále hánámá ma háliuk. ");
INSERT INTO klt_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Kulá nándá meng rákit me wa isutang wahára kungga ku Ánutu yá kuram táng nánámáya miuk wa álo ihinemán hálen wawu me káto wáina táinet ingga miuk wahára kungga muná. Ináku ing há naremán, Ánutu yá me káto wáina táinet ingga Abraham inuk wahára kungga ku kuram wa imámáya pahán imángga inuk. ");
INSERT INTO klt_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Kulá wáina wawu náuta ku meng rákit me watá átak? Wawu ing, ámna náráwa yá mukmuro náni wawu táwi hánám ingga kangga kándáng naráng rákit tátáya Ánutu yá meng rákit me wa Moses imuk. Wáina imuk wawu Abraham me káto wáina táinet ingga inuk wata torong káin. Meng rákit me watá árán kungga ku Nanggená yá tunggafen du meng rákit me watá sáliknginek ka naruk. Uláp kuram Abraham imámáya me káto wáina táinet ingga inuk wata páliná ku Nanggená yá tunggafiuk wa. Kulá Ánutu yá meng rákit mená wa angelo yámán watá táng Moses ámna ore háranan wa imát tu watá táng Israel yámuk. ");
INSERT INTO klt_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Ámna káman dá málám re yáup táin ingga wawu málám yáup wa táng ámna ore háranan wa ma imánggim. Iná Ánutu wawu málám káman re watá ku kuram wa Abraham imámáya me káto wáina táinet ingga miuk. ");
INSERT INTO klt_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Wáina wata ku meng rákit me watá Ánutu yá kuram nánámáya me káto wáina táinet ingga miuk wa táng káyam táek hám? Wáina muná. Iná Táwi yá meng rákit me wa hulá kámá námán watá átkuku álo námámáyan hálen wawu niyá meng rákit me wa isutgim wata ámna kándáng ingga álo memeyan. Enendu wáina kámá ma árak. ");
INSERT INTO klt_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Iná Ánutu yan me papia káin uyená watá ku ing mek, ámna náráwa kámuk hánám káwak ketnán átaráng wawu mukmuro yan kumbi kinan átaráng, wáina hálendu niyá Jesu Son Iháhá wata naráng háting minek watá ku Ánutu yá átkuku sásáliná muná wa yámámáya me káto wáina táinet ingga miuk wa isutang yáminek. ");
INSERT INTO klt_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Uláp Jesu ya naráng háting mámá wata káluná watá ma tunggafená átuk wahára wu meng rákit me watán kumbi kinan átkiumán. Wáina árátne áwángga ku Jesu ya naráng háting mámá wata káluná yá hiták háliuk. ");
INSERT INTO klt_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Meng rákit me watá ku hánámá pin náni tángga átang áwángga ku Jesu Son Iháhá watán rám káin áwán du nándá me pingnga álosim wata naráng hátitne ku Ánutu yá ámna náráwa kándáng ingga nánuk. ");
INSERT INTO klt_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Kulá rám nahára wu naráng hákhátik watá há áwuk, wata ku meng rákit me watá pin náni tán ma átninggumán. ");
INSERT INTO klt_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Sándu Jesu Son Iháhá wata naráng háting mámá kálu wahára kungga ku kámuk Ánutu nángánangge háliuráng, ");
INSERT INTO klt_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","me umi kuhángga ku Jesu Son Iháhá watyot tántápin tángga kutná wa táng sut sáni tánggániuráng. ");
INSERT INTO klt_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Kulá Jesu yan tombong hára ku Juda nan me Grik nan, yáup nangge hánámá me yáup nangge muná along árená, me ámna me náráwa watá rina kámá ma hálek. Jesu Son Iháhá watyot tántápin tánggoeráng, wata ku sán kámuk ku káman re átaráng. ");
INSERT INTO klt_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Wáina wata ku sándá Jesu Son Iháhá watán tombong átaráng hálen wawu sándu Abraham nángánangge yá re átaráng. Wata ku Ánutu yá náut Abraham imámáya me káto wáina táinet ingga mengga inuk wawu sándá hányon ihineráng. ");
INSERT INTO klt_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Waháranyon du ing, ámna káman da nanggená káman átgim watá ku máriya naning gán kutná kutná wa ihánggim. Kutná kutná wawu nangge watán pingnga ingga há átgim, enendu nangge wawu isikimo wáina hálendu kutná kutná wa ma pin yáni tátáyan tárák, wata ku yáup nangge yá inanyon átgim. ");
INSERT INTO klt_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Nangge málám bu naning gá ámna nini yá málám me kutná kutná wa pin yáni tátáya iháng tunggap tánggim wata tárang káin árán kungga naning gá rám naránggim wahára ku wáina. ");
INSERT INTO klt_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Nándu wáinanyon, nangge kikimo nanará náni muná yá ina átang káwak nátán kálu hulá hulá átaráng me iruk wáik hulá hulá watán yáup nangge hálengga átkiumán. ");
INSERT INTO klt_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Wáina átkiumán enendu Ánutu yá rám tiuk wahára hánám bu Nanggená suring mán áwuk. Áwuk wawu ing, náráwa yá wa tángga táng tin ámna nangge hálengga Juda yan meng rákit me wata tárang káin yon átuk. ");
INSERT INTO klt_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","Wáina áwuk watá ku ámna náráwa nándá meng rákit me wata tárang káin átumán waháranan son náhán Ánutu nángánangge háliumán. ");
INSERT INTO klt_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Nándu Ánutu nángánangge átkoemán, wata tángga ku Nanggená yan Iruk wa suring mán pahán náni kinan háuk. Wáina hang átang gu pahán yot ing mantángga san kunggoek, “Aba, Nan.” ");
INSERT INTO klt_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Wáina wata ku sándu son yáup nangge hánámá ma áraráng, ináku Ánutu yá tán sándu málámba nángánangge háliuráng, wata ku málámbá náut álosim tiyawiuk wawu sándán. ");
INSERT INTO klt_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Uláp pu sándu Ánutu ma naráng mená áturáng wáina hálendu ánutu kusák watán yáup nangge hálengga átkiuráng. ");
INSERT INTO klt_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Iná inggálu wu Ánutu há naráng meráng - son ing mein, Ánutu yá há naráng sámek. Wáina enendu rina tángga ku son hurik tángga káwak nátán kálu hulá hulá me iruk wáik háláng yáni muná watán káin kungga ku son watán yáup nangge háleinán tánggoeráng? ");
INSERT INTO klt_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Rámá rámá wu miti ya hahayan rám táwi, yap mirak kán rám táwi me yara mirak kán rám táwi wahára rina isusut ta mená wa há isutnemán ingga naránggoeráng. ");
INSERT INTO klt_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","No sándán ket tárák wata narángga ku pitánggoet, náuta no yáup rina sán orek sáni káin táut watá hánámá yakyawiwon wata. ");
INSERT INTO klt_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Yanuknukna, no pahánna yot ing sánin, nawu uláp meng rákit me isusut wa sangga sán inanyon háliut, wáinanyon inggálu ku sándá nák inanyon háleineráng. Sándá nákka kandák kámá ma táng namuráng. ");
INSERT INTO klt_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Sáni há nareráng wa, sutna ilalák pálak wata ku hulátingga hánám kung sándán káin me pingnga álosim wa mengga kut. ");
INSERT INTO klt_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Rám wahára wu sutna ilalák pálak kut hálendu no sándá sárum namángga nákka taktak sáminek ingga narut, enendu wáina ma táuráng. Ináku sándá nák ku Ánutu yan angelo me Jesu Son Iháhá táng tolinggalát ina nák neháng toliuráng. ");
INSERT INTO klt_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Rám wahára wu heronge hánám tángga nák pahán namuráng, enendu inggálu ku heronge wawu rekálu kuk? Pálipuk ing sánin, rám wahára wu nák háláng namámáya álo kámá hánám táuráng. Rám wahára sándá rahán sáni holengga namámáya wu álo yon holengga namánggalát. ");
INSERT INTO klt_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Kulá inggálu ku rina? No me páliná wa sánánggoet wata ku sándá nák káyamna hálenggoeráng me? ");
INSERT INTO klt_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Ámna wawu hahatingga pahán sáni haha tángga ku sán sáhát watán tombong háhále wata tánggoeráng, iná watán káin du sán háláng sámámáyan nanará kámá ma átyámák. Watán nanará káin wawu sán sáháng horet sándá nák nepmangga ku yáni yot káman hálengga átnát wata tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Ámna káman dá nanará álosim sánáng tolin narángga ku wa álo isutneráng. Rámá rámá wu wáina tángga átkuineráng, no sányot átnet wahára rewe muná. ");
INSERT INTO klt_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Yanángánanggena, no láwit naránggoet wawu nangge yá tunggafeinán tát mam yáni yá láwit narángngátaráng wáinanyon narángga áre kungga Jesu Son Iháhá yan átkuku watá sándán pahán kinan táwi hánám háleinek. ");
INSERT INTO klt_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Ukuro hánám bu no rám nahára sányot ma árat wata. Iná na sányot há átang ináku me wa tángga hangga káluná hára mengga sánánggem. No sánda narángpak hánám tángngátat, enendu no mulangán káin átnándat hálendu rina háláng sámánggem wawu ma narát. ");
INSERT INTO klt_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Kulá sán niyá Juda yan meng rákit me wata tárang káin átnát ta nareráng watá nanániráng, sánda meng rákit me wa ma hám naráráng? ");
INSERT INTO klt_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Táwi yan me wu ing uyená yá átak, Abraham wawu nanggená ámnaná yará. Káman wawu yáup náráwa hánámá yan, hang káman wawu áwáná hánám along átuk watán. ");
INSERT INTO klt_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Nanggená yáup náráwa hánámá watán wawu kálu rehára nangge yá tunggafengngátaráng wa isutang tunggafiuk, iná áwáná hánám along átuk wata nanggená wawu Ánutu yá me káto wáina táinet ingga mengga Abraham inuk wa isutang gu watá tunggafiuk. ");
INSERT INTO klt_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Kulá pingnga wata kinan du me tárákngá yá átak wawu ing, náráwa yará watá ku pahán káman me yará Ánutu yá káman Abraham imuk, káman Moses imuk wata tárákngá. Hagar yá ku ále yáilá Sainai káin pahán káman me imuk wata tárákngá. Pahán káman me wawu ing, ámna náráwa yá rámá rámá meng rákit me wa kámuk hánám isutang átningga ku meng rákit me watán yáup nangge hálengga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Hagar watá ku ále Arebia káin ále yáilá Sainai watyot Jerusalem nahára átak wata tárákngá. Jerusalem wawu hánámá yáup náráwa, iná yanángánanggená wawu yáup nangge rewe. ");
INSERT INTO klt_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Iná Jerusalem kámá irawa káin átak wawu mam náni. Wawu meng rákit me watán yáup náráwa muná, áwáná hánám Sara ina. ");
INSERT INTO klt_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Táwi yan me hára ing uyená, “Náráwa kátoná kák niyá nangge ma iháng tingngátalák, heronge táinelák. Náráwa kák niyá nangge iháng tingga láwit narená wa ma narulák, kák ku pahán álosim narángga hahatingga yon mantáinelák. Náuta náráwa kátoná yá nangge iháng tinek wawu náráwa nánáun yáni pálak ká nangge iháng tingngátaráng wa iháng hátingga táup hánám iháng tinek.” ");
INSERT INTO klt_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Kulá yanuknukna sándu Aisak inanyon Táwi yá me káto wáina táinet ingga mengga Abraham inuk wata nángánangge. ");
INSERT INTO klt_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Rám wahára nangge Ismael wawu kálu rehára nangge yá tunggafengngátaráng wa isutang tunggafiuk watá ku nangge Aisak Iruk Káungá yan háláng hára tunggafiuk wa táng lem tánggiuk. Rám nahára wu tárák wáinanyon. ");
INSERT INTO klt_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Wáina átkoek enendu Ánutu yan me yá rina mek? “Yáup náráwa hánámá wata nangge not wa yásurátá kundimálák, náuta máriya yáup náráwa wata nanggená yá áwáná hánám along átuk wata nanggená watyot naning gán kutná kutná wa ma horengga ihindámálák.” ");
INSERT INTO klt_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Wáina wata ku, yanuknukna, nándu yáup náráwa wata nángánangge muná, ináku áwáná hánám along átuk wata nángánangge. ");
INSERT INTO klt_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Jesu Son Iháhá watá náháng along tiuk wáina hálendu meng rákit me wata tárang káin ma áramán. Wáina wata ku káto hálengga átang gu sáni táng kung son meng rákit me yan yáup nangge háhále wakáin ma tindaráng. ");
INSERT INTO klt_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Narániráng! Nák ku Pol no ing sánindet, kep sáni marángga ku Ánutu rahálá hára rongrongngá háleinemán ingga nareráng hálen, wawu Jesu Son Iháhá watán yáup watá sán háláng sásámáyan wawu káluná muná hánám. ");
INSERT INTO klt_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Sán ámna nini yá nándu Ánutu yot pahán káman háleinemán ingga sáni álo ing met kep sáni marineráng, wawu son hiták ing sánindet, wáina há táineráng, wata ku meng rákit me rina átak wa kámuk hánám kándáng isutneráng. ");
INSERT INTO klt_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Iná sándá meng rákit me wa isurátne ku Ánutu yá ámna kándáng ingga náhinek ingga narángga átninggoeráng hálendu wawu Jesu Son Iháhá háranan horengga Ánutu yá pahán námuk wa sangga kunggoeráng. ");
INSERT INTO klt_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Iná nándu Iruk Káungá yá háláng námán Ánutu yá náut álosim námámáya miuk wata hálengga átkoemán. Náut álosim wata hálengga átkoemán wawu málámbá ámna náráwa kándáng hánám ingga náninek wa, náuta nándu Jesu Son Iháhá ya naráng háting mánggoemán wata. ");
INSERT INTO klt_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Káman dá Jesu Son Iháhá watyot átak hálen wawu kepmá marená me kepmá ma marená watá ále hánám hálek. Iná káman dá Jesu ya naráng háting mámá kálu wahára káto átnek watá ku páliná hánám hálek. Naráng hákhátik watá ku kámá ya kikiná nanará wa tán ámna watán átkuku káin tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Hulátingga ku kálu kándáng wahára re há kungga áturáng, enendu niyá hánám bu pana hangga kálu sung sámán du me páliná wa ma isutkuráng? ");
INSERT INTO klt_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Kálu kándáng sasayan me karo wawu Ánutu niyá mantáng sámángga átkoek watán káinnan muná. ");
INSERT INTO klt_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Ing narineráng, yis isikimo watá tán másáng watá kámuk tihangngátak wáinanyon du me kusák isikimo watá ámna náráwa táup táwi iháng wáik tángngátak. ");
INSERT INTO klt_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Nák nanarána káin du ing hánám narángga átat, Táwi yá álo háláng sáminek ingga naret wawu ing, sándu ámna kámá yan me ma isutnándáráng, ináku nákkán me ná rewe isutneráng. Iná ámna káman ni, kutná táwi me ámna hánámá, watá sán sáháng yakyawák tángga átninggoek wa, wawu málámbá kandák wa tánggoek wata watán márapmá táwi suwinek. ");
INSERT INTO klt_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Yanuknukna, pálipuk no Táwi yot pahán káman háháleya kep marineráng ingga yánángga átninggoet hálen wawu náuta ku Juda yá emá re nák neháng lem tángga átkoeráng? Iná no watán nanará wata álo ingga mengga Juda yan meng rákit me isutnemán ingga sánánggem wawu Juda yá wata neháng lem ma tánggalát, me Jesu yá maripong hára kámutuk wata me wáik ma menggalát. ");
INSERT INTO klt_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Ámna niyá nanará sáni táng yakyawák tánggoeráng wawu káto hálengga kep mamará kálu wa isusut ta sánánggoeráng, wáina hálendu álo kámá wawu yáni wu yáni ya kep yáni wa marángga ku ponggon yáni wa hányon ránineráng! ");
INSERT INTO klt_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Yanuknukna, pálipuk sándá along átneráng ingga ku Ánutu yá mantáng sámuk. Enendu sándá along átamán ingga kung pahán kakngá isusut kálu wahára hanirot, ináku sán káman káman wawu Táwi yan ámna náráwa wa kikiná kápángga watán yáup nangge hálengga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Meng rákit me isusut wata mená wu wahára erek áthálek wawu ing, “Kaya kikiná rina narángngátalák wáinanyon nangge nuknukka ya kikiná narinelák.” ");
INSERT INTO klt_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Iná sándá kuk tángmán tángmán tángga orek sáni hára kámkáyam átkoeráng hálendu wawu ing naráng rákit táineráng, wáina táená wata kámuk naráng hákhátik sáni yá sohingga hangga wáik háleiwon. ");
INSERT INTO klt_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Wáina wata ku no ing sánin, sándu Iruk Káungá watán kálu wahára átkuineráng, watá ku pahán kakngá yan kikiná wa ma isutang átkuindáráng. ");
INSERT INTO klt_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Há naremán wa, pahán kakngá watá Iruk Káungá wa táng hang tin ingga tán, Iruk Káungá watá pahán kakngá wa táng hang tinán yon tán du yándi honhoren átnándamálák, wáina wata ku rina tátáya narineráng enendu ma táindáráng. ");
INSERT INTO klt_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Iná Iruk Káungá watá sán sángorán átninggoeráng hálen wawu sándu meng rákit me wata tárang káin ma áraráng. ");
INSERT INTO klt_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Kulá pahán kakngá yan ket tárák wawu hiták ing átak, márámamák, ket tárák reprepmá, put ang gán ket tárák, ");
INSERT INTO klt_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ánutu kusák ináng sákngingi, iruk wáik kán nanará isusut, kámkáyam tátá, menmen tátá, kámá yan kutná kutná kápáng naknarák, pahán káráp tángga kuk tátá, ka rewe háláng kamán átnát tán nanará, honhoren tátáyan nanará, kámá yá kámá táng hang titiyan nanará, ");
INSERT INTO klt_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","álo kámá árát kápángga pahán káráp táng yámámá, umi káto nat ip ráráhá, umi sinak táená kinan ket tárák kandák tátá, me ále ket tárák wáina wa. Uláp há sánut enendu son wanyon ing sánindet, ámna niyá ket tárák wáina tángga átkuinek wawu kungga Ánutu yan átkuku wata kinan ma háindák. ");
INSERT INTO klt_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Iná Iruk Káungá yá ámna káman da pahálá kinan árán du átkukuná káin páliná ing tunggafen káineráng, kámá ya narán kikiná háhále, pahán heronge, pahán láláp, pahán káráp sopmuná ma tátá, kámá háláng yámámá, ket tárák álosim tátá, rámá rámá kándáng re árán kangga meng toling mángngátaráng, ");
INSERT INTO klt_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","hangga yolopon átkuku, hang átkukuná kándáng pinná tátá. Meng rákit me káman dá ket tárák wáina wa ma táng hang tindák. ");
INSERT INTO klt_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Ámna náráwa ni Jesu Son Iháhá watán pingnga watá pahán kakngá watyot watán kikiná wa iháng maripong hára kátit há kámutuk. ");
INSERT INTO klt_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Iruk Káungá watá átkuku páliná námuk, wata ku nándá satne Iruk Káungá watá nángorán átkuinemán. ");
INSERT INTO klt_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Nándá náni ya kut náni ma tángga árindamán, kámá ya pahán yánin hatne watá kuk ma táindaráng, me kámá yan kutná kutná wa ma kápáng narindamán. ");
INSERT INTO klt_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Yanuknukna, nuk sáni káman dá kandák tán wáina táek ingga narángga hálendu sán ni Iruk Káungá yá sángorán átaráng sándá yolopon kungga inángga kut tu watá kandák rina táuk wa táng tolinek. Wáina tángtáng gu sáni wu kándáng gon háleng rákit tángga átkuineráng, sáni kung ingirungingi wáina háranyon hanirot. ");
INSERT INTO klt_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Kámá háláng imán imán tángga márapmá sáni wa suwineráng. Kálu wáina isutneráng watá ku Jesu Son Iháhá yan kálu rina átak wa tát kándáng háleinek. ");
INSERT INTO klt_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Kulá ámna káman du kutná muná, enendu málámbá nawu kutna árená ingga narángga átninggim, wawu nanaráná watá málám ingirunginggim. ");
INSERT INTO klt_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Ámna náráwa káman káman dá málámbán átkukuná rina wa kangga narán álo hálendu wata herongená táinek. Watá málámbán átkuku watyot táng kámá yan átkuku yot tingga ma káindak, ");
INSERT INTO klt_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","náuta álo kámá ku ámna káman káman dá málámbán átkuku wata narángga pinná tángga átkuinek. ");
INSERT INTO klt_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Ámna káman niyá Ánutu yan me wa sánáng tolin du sándá kutná kutná sáni álosim wa kátu horengga iháng niyá sánáng tolinek wa imineráng. ");
INSERT INTO klt_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Ámna káman dá málámbon ingirungingga no Ánutu álo ingirunginet ingga nariwon. Wáina kámá ma tátáyan. Náut sungi itná hinek wawu máriya wu páliná watanan yon ihinek. ");
INSERT INTO klt_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Niyá pahán kakngá ya heronge naráng mángga watán ket tárák wáik táinek wawu pahán kakngá watá páliná wáik táng tunggap táng mán máriya wáik hálengga muná kuinek. Iná niyá Iruk Káungá ya heronge naráng mángga watán ket tárák álosim wa táinek wawu Iruk Káungá watá páliná álosim táng tunggap táng mán máriya átkuku sásáliná muná wa táinek. ");
INSERT INTO klt_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Wáina wata ku ket tárák álosim wa tángga kungga átang háláng haha ma táindaráng. Nándá ket tárák álosim wa tátáya háláng haha ma táindámán hálendu Ánutu yá rám tiuk wahára wu páliná álosim wa ihinemán. ");
INSERT INTO klt_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Wáina wata ku rám rina hára ket tárák álosim wa kámá ya táng yámámáyan hálen kangga ku wahára táinemán. Ámna náráwa kámuk ka ket tárák álosim táng yáminemán, iná ámna náráwa Táwi ya naráng háting mángga átaráng wawu hun káman ina átamán, wáina wata ku wa kálak hánám bu wáina táng yáminemán. ");
INSERT INTO klt_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Me kátu kimo náwu no nayon uyingga átat. Ná kaniráng, no kolem maming táwi kálu mena ná uyingga átat. ");
INSERT INTO klt_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Ámna niyá kep sáni marineráng ingga táup sánánggoeráng wawu wáina tángga ku Juda ámna ya rahán yáni hára kut náni árená hálengga átnin ingga wata wáina tánggoeráng. Jesu Son Iháhá yan maripong wata naráng háting mánggoeráng ing mengga náháng wáik tánirot ingga narángga ku wáina tánggoeráng wa. ");
INSERT INTO klt_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Ámna kámá kep yáni há maruráng watá meng rákit me yáni wa kándáng ma isutnándaráng. Enendu sándá kep sáni marineráng ingga sánángga ku sán sut sáni hára rina táineráng wata ingga kut táwi ihineráng wata tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Iná no ku naya kutna me ni kámá káman da kutná ma táng hip táindát, ináku Táwi náni Jesu Son Iháhá yá maripong hára kámutuk, wata tángga ku no wata kutná wa rewe táng hip táinet. Jesu yá maripong hára yáup táuk watá ku káwak nátán kálu rina rina watá nák nanarána káin há sálikngek hálek, me no nawu maripong hára há kámutut ina hálek, wata ku káwak kán kálu rina rina wa ma isutnándát. ");
INSERT INTO klt_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Kep mamará me muná wawu rina kámá ma hálek. Iná Ánutu málámbá tán nándu ámna náráwa mirak háliumán watá ku kutná táwi hálek. ");
INSERT INTO klt_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Ánutu yá málámbán ukuro me pahán láláp wa san niyá me wa narángga isutang átaráng watyot átnek, ámna náráwa wa, wawu Ánutu yan ámna náráwa hánám bu wa. ");
INSERT INTO klt_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Ámna yá nuturáng ga sutna káin párángna yá há átaráng, kámá yá párángna wa kangga nák ku Jesu yan yáup ámna páliná ingga nareráng. Wáina wata ku rám nahára átang kuinek hára ámna káman dá nák pahán márapmá son ma namindak. ");
INSERT INTO klt_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Yanuknukna, Táwi náni Jesu Son Iháhá yá pahán sámángga iruk sáni káman káman watyot átnek. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Nák ku Pol, Jesu Son Iháhá watán aposel. Ánutu yá málámbán pahán isutang gu nák neháng tunggap tángga aposel yáup tátáya tiuk. Kulá no me ná uyingga se Ánutu yan ámna náráwa Efesus it yáilá káin Jesu Son Iháhá ya naráng háting mángga isutang átkoeráng sándán káin koek. ");
INSERT INTO klt_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Nan náni Ánutu yot Táwi Jesu Son Iháhá watá pahán sámán pahán láláp watá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Ánutu kutná meng tárut tánin, málám wawu Táwi náni Jesu Son Iháhá watán Ánutu, me wata Naning. Jesu Son Iháhá wahára kungga ku alek kán kutná kutná álosim wa iruk náni káman káman háláng imámáya námánggoek. ");
INSERT INTO klt_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Káwak ná ma táng tunggap táená átang málámbá Jesu hára kungga rahálá hára rongrongngá átang me muná kándáng re átnát wata náháng tunggap tán málámbán pingnga háliumán. ");
INSERT INTO klt_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Uláppon nánda kikiná narángga ku Jesu Son Iháhá watá náháháya yáup táinek wahára kungga ku málámba nángánangge háháleya náháng tunggap táuk. Ánutu yá málámbán pahán isutang wáina táuk. ");
INSERT INTO klt_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Málámbá nanggená wata kikiná narángngátak. Nanggená wahára kungga ku pahálá nán námuk wawu táwi hánám. Wáina táuk wata nándá málámba kutná meng tárut tángga átkuinemán. ");
INSERT INTO klt_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Ánutu yá pahán námuk wawu táwi hánám, wáina hálendu maripong hára Jesu sipmá yá háuk wahára kungga ku náháng yuwángga mukmuro náni yawonduk. ");
INSERT INTO klt_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Wáina tángga pahálá káinnan náut nán náminán naruk wawu táwi hánám kulin háuk waháranan du nanará hulá hulá álolosim wa námuk. ");
INSERT INTO klt_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Ánutu yá kálu rina isusut ta nanará tiuk wawu uláp káwak ámna nándá ma kakaya táng kilak ting san átuk, enendu rám nahára ku nanaráná álosim wa há nálen kangga átamán, wawu Jesu Son Iháhá wahára. ");
INSERT INTO klt_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Watán nanará wu rám málámbá narángga átak wahára wu kutná kutná alek káin me káwak káin wa iháng ámna yáilá káman wata tárang káin tinet ingga naruk, wawu Jesu Son Iháhá wa. ");
INSERT INTO klt_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Ánutu yá málámbán pahán isutang gu rina rina wa tán tunggafengngátaráng, wáinanyon du Juda nán náháng tunggap tán málámbán ámna náráwa háliumán. Wáina táuk wawu uláp hánám wáina táinet ingga há naruk wa isutang táuk. ");
INSERT INTO klt_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Wáina náháng tunggap táuk wawu Juda nándá kálak hánám bu Jesu Son Iháhá wata naráng háting mángga isutnemán, wata ku Ánutu yan yamá me hálángngá táwi wata narángga kutná meng tárut tángga átkuinemán. ");
INSERT INTO klt_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Kulá ámna náráwa kámá káinnan sándu me páliná wa há naruráng wawu Ánutu yá son há sáhuk watán me pingnga álosim wa. Wata ku sándu Jesu Son Iháhá ya naráng háting mángga watyot hányon tápingga átkoeráng. Kulá Ánutu yá ku uláp me káto miuk wa isutang gu Iruk Káungá wa sámuk watá sánggit ta árán du málámbán ámna náráwa hánám bá átaráng ingga naránggoeráng. ");
INSERT INTO klt_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Nándu Iruk Káungá wa há táumán wata ku ing há naremán wa, máriya ku Ánutu yá málámbán ámna náráwa wa náut álosim yámámáya miuk wawu hányon ihinemán. Jesu yá son áwángga náháng yuwán málámbot átnemán wahára ku kutná kutná wa ihinemán. Wáina táuk wata ku nándu wata yamá me hálángngá táwi wata narángga kutná meng tárut tángguinemán. ");
INSERT INTO klt_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","No sándán pingnga ku ing met narut, sándu Táwi Jesu wata naráng háting mángga Ánutu yan ámna náráwa wa kámuk hánám pahán yámángga kikiná naráng yámánggoeráng. ");
INSERT INTO klt_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Wáina wata ku rámá rámá no sáponga tánggoet wahára sánda narángga ku Ánutu heronge mená inángga sáponga tánggoet. ");
INSERT INTO klt_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","No rámá rámá sáponga hára Táwi náni Jesu Son Iháhá watán Ánutu, Nan náni yamá pálak wa inánggoet wawu Iruk kán nanará álosim sámán du sándá málámbán me wata hulá wa kándáng narineráng, wahára ku málámba kándáng naráng mineráng. ");
INSERT INTO klt_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","No sáponga tánggoet wawu málámbá pahán sáni watán kálu yalin yamá man du sán náut álosim sásámáya mantáng sámánggoek wata naráng yámineráng, wawu alek kán kutná kutná iháháya háleng yámángga átaráng wa. No sáponga tánggoet wawu sándá kutná kutná álolosim Ánutu yá ámna náráwaná sándán tiyawiuk wata naráng yámineráng wata. ");
INSERT INTO klt_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Hang no sáponga tánggoet wawu Ánutu yan háláng watá ku ámna náráwa niyá wata naráng háting memán wa táwi hánám wa háláng námángga átkoek wata naráng yámineráng wata. Ánutu yan háláng táwi watá kutná kutná kámuk kán háláng wa iháng hátingga átak. Watán háláng táwi nándán káin yáup tánggoek, ");
INSERT INTO klt_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","watá yon uláp Jesu Son Iháhá hára yáup tán Jesu yá há kámutuk háranan son hálángngá táwi watá táng tárut tángga táng áráng alek káin ketná álák kálu tiuk. ");
INSERT INTO klt_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Wáina tán irawa káin hánám árán du iruk káto káto háláng yáni pálak, ámna yáilá yáni, kapman kámuk, me kutná kutná háláng yáni pálak watá Jesu Son Iháhá wata tárang káin re átaráng. Ámna me iruk kut yáni pálak inggálu átaráng me máriya átneráng watá málámba tárang káin re átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Ánutu yá kutná kutná wa iháng Jesu Son Iháhá wata tárang káin tingga málám táng tin wata yáin yáni átak, wata ku kálu wahára kungga ku miti yan ámna náráwa wata yáin yáni átak. ");
INSERT INTO klt_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Táwi yan ámna náráwa wawu Jesu Son Iháhá wata sutná, iná Jesu yan átkuku watá ku kutná kutná kámuk wata kinan tuwat hánám átnándak, hang málámbán ámna náráwa wata kinan wáinanyon átnándak. ");
INSERT INTO klt_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Uláp sándu mukmuro hulá hulá wa tángga átang gu iruk sáni wawu há kámurán áturáng. ");
INSERT INTO klt_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Rám wahára wu káwak nátán kálu kandák hulá hulá wata kinan átang alek táitná hára iruk wáik yáin yáni watán nanará isutang átkuráng. Iruk wáik watá emá re hánghálángngá hánám ámna kámá niyá Ánutu yan milun yayali tángngátaráng watán pahán kinan káin yáup tángga átkoek. ");
INSERT INTO klt_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Uláp pu nán kámuk tombong wahára átang pahán wáik kakngá watán kikiná wa isutang átninggiumán. Átang gu pahán náni kakngá watyot tu nánin nanará watán milun sungga átkumán. Wa átkumán wáina re átang ináku Ánutu yá wáina átang yumnakngá wáik rina iháháya tiyawiuk wa ihánggatnem. ");
INSERT INTO klt_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","5","Mukmuro náni watá náháng lem tán há kámutang átumán, enendu málámbá nánda kikiná hánám narángga urák náni táwi naruk hálendu náháng tárut tán Jesu Son Iháhá watyot tárutang átninggoemán. Málámbá pahán táwi hánám námángga ku wáina tángga son náhuk. ");
INSERT INTO klt_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Ánutu yá Jesu Son Iháhá watyot náháng tárut tángga ku náháng alek káin átang kutná kutná pin yáni tátáyan kome wahára Jesu yot tin átninggoemán. ");
INSERT INTO klt_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Ánutu yá wáina táuk wawu inggálu me máriya málámbá pahán námuk wa hiták táng tunggap táin ingga táuk. Pahán rina námánggoek wawu táwi hánám kutná kutná kátu wa iháng hátingga hánám námánggoek wahára kungga ku náháng álolo tán Jesu Son Iháhá watyot ronrosin átkoemán. ");
INSERT INTO klt_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ánutu yá pahán sámámáya naruk wa isutang gu son sáhuk. Sándá náut kámá káman táuráng ga wata ingga tángga Ánutu yá ma sáhuk. Ináku Jesu ya naráng háting mámá kálu wahára re Ánutu yá hánámá ná hánám wáina táuk. ");
INSERT INTO klt_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Wáina táuk wawu sándá náut kámá yáup káman táng mát wata yumnakngá ya muná, wata ku káman dá málámba kutná tángga árángga kukuyan du muná. ");
INSERT INTO klt_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Jesu Son Iháhá wahára kungga ku Ánutu yá tán ámna náráwa mirak háliumán. Wáina hálengga átang gu yáup álosim nándá tátáya uláppon há tiyawing námuk wa tángga átkukuya. ");
INSERT INTO klt_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Kep yáni marená watá sándu kep sáni ma marená wata ku sándu Ánutu yan tombong wata kinan ma áraráng ing sánángngátaráng. Wáina wawu ámna nangge yá re ket tá káwak sut hára tángngátaráng. Ing narineráng, uláp wawu sándu kámá káinnan tunggafená hálendu ");
INSERT INTO klt_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Jesu Son Iháhá watán tombong hára ma áturáng, ináku mulangán áturáng. Hang Israel ámna háháleyan káluná muná, me pahán káman átnát mená Ánutu yá hárotuk, me Israel iháng álolo tátáyan me káto wáina táinet ingga mená wata kinan ma áturáng. Sándu káwak ketnán Ánutu yá náut kámá álosim káman sásámáya miuk ka wata ma hálengga áturáng, me Ánutu ya ma naráng mená áturáng. ");
INSERT INTO klt_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Uláp pu mulangán hánám káin áturáng, enendu inggálu ku Jesu Son Iháhá wata sipmá watá sáháng áwáng málámbot tin du Ánutu tangtang hánám wáina átaráng. ");
INSERT INTO klt_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Jesu Son Iháhá málámbá pahán láláp wa táng hang Juda me ále kámá káinnan orek náni hára tin du pahán káman háliumán. Uláp pu kumbi ina watá Juda me kámá káinnan wa náháng horen kámkáyam tángga átumán. Iná inggálu ku Jesu Son Iháhá watá kumbi ina wa yalingga ku kámkáyam tángga tombong yara átumán waháranan son náhán káman re háliumán. ");
INSERT INTO klt_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Jesu yá kámutuk wahára kungga ku Moses yan meng rákit me wa yawondang gu tombong yará wa tán tombong káman re mirak háliuk. Wáina táuk wahára kungga ku Juda me ále kámá káinnan wa náhán pahán káman háliumán. ");
INSERT INTO klt_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Jesu yá tombong yará árená wa tán tombong káman re hálengga Ánutu nuknukngá háliuráng wawu málámbá maripong hára kámutuk wahára. Wáina táuk watá ku kámá yot kámkáyam tátá wa tán sálikngiuk. ");
INSERT INTO klt_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Jesu yá káwak káin hangga me pingnga álosim wa mengga ing miuk, “Pahán káman dá orek sáni hára átnek.” Sán ámna kámá káinnan Ánutu tangtang ma áturáng sányot Juda nán Ánutu tangtang átumán wa me pingnga álosim ná nánuk. ");
INSERT INTO klt_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Jesu Son Iháhá wahára kungga ku Iruk Káungá káman watá rewe kámuk Juda me kámá káinnan wa háláng námán Nan náni wata rupmá káin kumán. ");
INSERT INTO klt_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Wáina wata ku sándu áwená ina muná, ináku sándu Ánutu yan ámna náráwa watyot tombong káman re átaráng. Sándu Ánutu yan ámna náráwa pánpáliná hánám átaráng. ");
INSERT INTO klt_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Sándu it Ánutu yá tánggim ina. Málámbá nán aposel yot profet náháng kumammá ya mangga ku Jesu Son Iháhá málám bu táng kumam káto ya ore hára man watá it hálángngá ya átang it káto tángga átgim wáina. ");
INSERT INTO klt_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","It kuratná watá kámuk hánám Jesu hára sengsáráp tángga átang it wa tát Táwi yan it káungá káto hánám maming táwi hálengga átkoek. ");
INSERT INTO klt_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Sándu Jesu hára hányon sengsáráp tángga átaráng, wata ku Ánutu yá kámuk sáhán málámbán it táwi hánám ina hálengga árát tu málámbán Iruk Káungá watá it wata kinan átkuinek. ");
INSERT INTO klt_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Hulá wata ku nák Pol no Ánutu yan káin sáponga tánggoet wawu sán háláng sásámáya. Me pingnga álosim wa ále kámá káinnan sándán káin mengga kunggoet wawu Jesu Son Iháhá watán yáup tánggoet wata tángga ku neháng kalabus kinan tit átat. ");
INSERT INTO klt_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","No ku ing naret, sándá nareráng wawu Ánutu yá pahán namángga ku nák neháng tunggap tángga ále kámá káinnan sándán káin me pingnga álosim wa meng tunggap tángga kukuya yáup namuk. ");
INSERT INTO klt_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Iná Ánutu yá yáup wáina táinet ingga naruk wata mená wawu uláp pu kilak átuk, enendu Ánutu málámbá nák há naliuk, wa no kátu isikimo rewe ná uyet. ");
INSERT INTO klt_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Wáina wata ku sándá me wa sángingga ku ing káineráng, nák ku me kilakngá Jesu Son Iháhá watán kálu wawu kándáng hánám há naret. ");
INSERT INTO klt_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Uláp rám káman Ánutu yá mená ná táng hiták kámá ma tiuk. Iná rám nahára wu Ánutu yá Iruk Káungá yan háláng hára me wa táng aposel yot profet ná káungá nándán káin hiták tiuk. ");
INSERT INTO klt_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Kulá me wawu ing, me pingnga álosim wahára kungga ku sán kámá káinnan me nán Israel watá tombong káman hálengga sut káman háliumán. Wata ku nán kámuk ká kutná kutná álosim Ánutu yá náminek ka miuk wa Jesu Son Iháhá wahára kungga ihinemán. ");
INSERT INTO klt_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Ánutu yá tán du no me pingnga álosim wa meng tunggap tátáyan yáup nangge háliut. Málámbá pahán namángga málámbán háláng wa namán no wahára kungga ku yáup wa tánggoet. ");
INSERT INTO klt_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Nák ku ámna wáik Ánutu yan ámna náráwa wata márin yáni káin átat, enendu málámbá pahán namángga yáup táwi ná namuk, wawu no ámna náráwa ále kámá káinnan watán káin Jesu yan me páliná wa yánánáya. Me páliná watá ing mek, Jesu Son Iháhá watán kutná kutná álosim wawu kut yáni táwi árená hánám, wáina hálendu ámna náráwa nándá sángingga ma naráng háháliyan. ");
INSERT INTO klt_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Ánutu niyá kutná kutná iháng tunggap táuk watá uláp pon ámna náráwa yan káin rina tátáya nanará tiuk wa táng kilak tiuk. Iná inggálu ku yáup ná nák namángga málámbá nanará rina táng kilak tiuk wa no meng tunggap tángga ku Ánutu yá wáina tángngátak ingga yánáná wata yáup wa namuk. ");
INSERT INTO klt_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Ánutu yá yáup wa namuk wawu miti ámna náráwa hára wa kungga ku angelo yot iruk wáik watá wawu Ánutu yan nanará hulá hulá álosim ingga kakaya. ");
INSERT INTO klt_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Alek káwak ká ma tunggafená árán yon nanaráná káin wáina táinet ingga nanará há tiuk, wáina hálendu áwángga Táwi náni Jesu Son Iháhá watá yáup táuk wahára ku tán hiták háliuk. ");
INSERT INTO klt_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Wáina hálendu nándá Jesu ya naráng háting mánggoemán wahára ku nándá Ánutu kondolá hára kungkungngá kunggoemán. ");
INSERT INTO klt_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Wáina wata ku ing sánin, no sán háláng sásámáya láwit rina narángga átat wata sándá nák ka narángpak tángga háláng haha ma táindaráng. No wáina tángga átat watá háláng sámán Ánutu yot átkoeráng, wata ku sándá heronge narineráng. ");
INSERT INTO klt_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Nan Ánutu yá rina rina tánggoek wata há sánet wata naráng hátingga ku kondolá hára átang tunna hára imángga turingga hanggoet. ");
INSERT INTO klt_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Alek káin angelo me káwak káin ámna náráwa átaráng watán tunggafefe yáni hulá wawu Ánutu rewe. ");
INSERT INTO klt_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Nák ku ing sáponga tánggoet, Nan dá kutná kutná álolosim táwi hánám wa sásámáya tiyawiuk, wata ku málámbán Iruk Káungá wa pahán sáni kinan molán tuwatang gu sáháng káto tán átneráng. ");
INSERT INTO klt_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Wáina árát tu Jesu Son Iháhá wata naráng háting mánggoeráng wahára kungga ku watá pahán sáni káin kome táinek. Son ing sáponga tánggoet, nangge nuk ka kikiná nanará watá átkuku sáni káin káto hánám átnek, wawu káráp pá ráhulá san káwak kinan kun káto átnándak wáinanyon átneráng. ");
INSERT INTO klt_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Átang gu Ánutu yá málámbán ámna náráwa yot sán kámuk nanará sámán du nanará watá háláng sámán Jesu Son Iháhá yá nánda narán kikiná háliuk wata hulá ing wa narineráng, wawu hahala hánám, hásák hánám, irawa káin hánám, me kinan hánám koek wáina. ");
INSERT INTO klt_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","No sáponga ing tánggoet, ámna káman dá Jesu Son Iháhá watá nánda kikiná wáina naruk ingga ma nanaráyan, enendu sándá ku há naráng mineráng. Wáina wata ku kutná kutná álosim Ánutu yan káin átak watá sándán káin hányon átnek. ");
INSERT INTO klt_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Ánutu yan háláng watá pahán náni kinan yáup tángngátak. Háláng wawu nándán nanará wa táng hátek. Nándá rina tátáya narángga inángngátamán watán háláng watá Ánutu yan háláng wa ma táng háhátiyan. ");
INSERT INTO klt_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Wáina wata ku ámna náráwa yá Jesu Son Iháhá watyot málámbán ámna náráwa wa kápángga wata Ánutu kutná mengga meng tárut tángga átnemán, inggálu me rámá rámá, wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Nák ku Táwi yan yáup tángngátat wata ku kalabus kinan átat. No me káto mengga ing sánin, Ánutu yá sándá kálu kándáng wahára re átkuku wata mantáng sámuk, wata ku sándu málámbá rina átkukuya narek wahára re átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Rámá rámá sándu kámá ya tárang káin átang pahán láláp hára re ket tárák sáni ku yolopon hára wa yáleineráng. Pahán káráp sopmuná ma táng yámindaráng, ináku kikiná naráng yámángga ku márapmá rina sámineráng wa sungga átneráng. ");
INSERT INTO klt_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Pahán káman átnát wawu Iruk Káungá watá námuk, wata ku rina tángga ku kálu wáina wa tángga pahán láláp wata kinan urum káman hálengga átnin ingga wata yáupmá háláng hánám táineráng. ");
INSERT INTO klt_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Kulá Jesu ya naráng háting mená nándu sut káman dá re ina átang Iruk Káungá káman wa rewe táumán. Kálu wáinanyon du nán kámuk wawu náut kámá káman re Ánutu yá námámáya miuk wata hálengga átnát ta mantáng námuk. ");
INSERT INTO klt_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Nán kámuk wawu Táwi náni káman re, naráng hákhátik káluná káman re, hang umi ku tárák káman re kuhumán. ");
INSERT INTO klt_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Ánutu káman re átak, wawu nán kámuk ka Nan náni. Táwi yan ámna náráwa kámuk ka yáin náni átang, nán kámuk ka kinan átang, nán kámuk hára kungga yáup tángngátak. ");
INSERT INTO klt_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Iná Jesu Son Iháhá watá málámbán pahán isutang gu Iruk kán yáup hulá hulá wa horengga yáup tátáyan háláng watyot nán káman káman námán tánggoemán. ");
INSERT INTO klt_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Wáina wata ku Ánutu yan me yá ing mek: “Irawa káin árángga kun du ámna ket ihená watá sárummá ya isutang árángga kut tu málámbá ámna náráwa yan kutná kutná álosim tiyawiuk wa yámuk.” ");
INSERT INTO klt_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","“Irawa káin árángga kuk,” me wata hulá wawu rina? Wata hulá wawu ing, hulátingga wu ámu káin káwak kinan háuk. ");
INSERT INTO klt_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Ámna watá hulátingga ámu káin háuk ngáya ku árángga alek kinan irawa káin hánám kungga ku málámbán háláng watá rekáin rekáin wa kámuk hánám átnát wata. ");
INSERT INTO klt_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Watá yon du kámá profet yáup tátáya yámángga, kámá aposel yáup tátáya yámángga, kámá evenselis yáup tátáya yámángga, kámá pasto yáup tátáya yámángga ku kámá wu Táwi yan me pingnga álosim wa yánáng totoliyan yáup wa yámuk. ");
INSERT INTO klt_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Jesu yá yáup wa yámuk wawu watá Ánutu yan ámna náráwa wa háláng yámát tu watá yáup álosim wa álo tángga ku ámna náráwa Jesu Son Iháhá wata sutná ina watá káto hálengga kándáng átnek wata. ");
INSERT INTO klt_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Yáup wawu wáina re árán kungga nán kámuk ká Ánutu Nanggená wata naráng háting mángga málámba kándáng hánám naráng minemán. Wahára kungga ku pahán káman hálengga árátne ku naráng hákhátik náni yá káto hálen Jesu Son Iháhá watán káin ket tárák rina rina átaráng watá nándán káin hányon átneráng. ");
INSERT INTO klt_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Nándá wáina átang gu nangge kikimo yá ina ma átnándamán. Iná wáina átnemán wahára wu ámna me karo táng námángga nángnárungingi yan me meineráng watá náháng wáik táinek. Wáina watá ku táp punggilá me iruk ká bot tángga wakálu wakálu tán ále rehára kukuya kunggim watá wakáin ma kunggim wáinanyon du nándá ma kuindámán. ");
INSERT INTO klt_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Wáina ma átnándamán, ináku me pálipuk wahára re átang kámá ya kikiná nanará kálu wahára átnemán. Wáina átang gu naráng hákhátik náni watá tihangga táwi hálen Jesu Son Iháhá watán ket tárák wahára re rina rina wa tángga átnemán. Jesu wawu káwak sut káman da yáilá tiuk wáina, málámbán ámna náráwa nánda yáin náni, ");
INSERT INTO klt_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","iná nán kámuk wawu wata sutná ina. Káwak sut tán kurat me ulin watá áwáng gu sut wahára seng kunkun tángga ku káto átnándaráng. Wáinanyon du nán Táwi yan ámna náráwa yá nuk náni kámá kikiná kápángga háláng imán imán tángga káto átnándamán. Sut kátu káman káman watá yánin yáup wa kándáng táineráng wahára wu sut kámuk watá káto átneráng. ");
INSERT INTO klt_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","No Táwi kutná hára me káto mengga ing sánindet, sándá Ánutu ma naráng mená yá ina átninggoeráng wawu sáineráng. Nanará yáni káin rina narángga átninggoeráng watá kámá ma háláng yámindák. ");
INSERT INTO klt_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Pahán yáni wu káto hánám, wáina hálendu Ánutu ya ma naráng máráng. Wáina wata ku nanará yáni wawu páyung árán Ánutu yan átkuku wata kinan ma áraráng. ");
INSERT INTO klt_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Watá rina rina tángngátaráng wata reprepmá ma narángngátaráng. Yáni wu ket tárák wáik hánám wa tángga wata kinan hánám hangga átninggoeráng. Rámá rámá wáina re tátáya narát táwi hánám hálengngátak. ");
INSERT INTO klt_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Iná sándu Jesu Son Iháhá wata há naráng muráng wawu wáina tátáya ma háiná táuráng. ");
INSERT INTO klt_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Pálipuk sán wawu Jesu ya naráng muráng wahára wu Jesu yan me páliná wa re isutang há sánáng toliuráng. ");
INSERT INTO klt_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Uláp pahán kakngá isutang átninggiuráng wawu me kusák hára kungga náut kámá wáik wa tátáya pahán tátárut tát watá sáháng lem tánggiuk, enendu ing sánáng toliuráng, pahán kakngá isusut wa sangga átang gu ");
INSERT INTO klt_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","sat Ánutu yá nanará sáni wa tán mirak háleinek. ");
INSERT INTO klt_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Ánutu yá tán sándá ámna náráwa mirak málám inanyon rongrongngá hánám hálengga kándáng hánám re átneráng. ");
INSERT INTO klt_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Wáina wata ku sáni káman káman dá me kusák wahára ma átkuindaráng, iná nuknuk sáni yáninán du me pálipuk rewe yánineráng, náuta náni wu sut káman da kátu rewe. ");
INSERT INTO klt_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Pahán káráp tángga hálendu kandák ma táindaráng. Pahán káráp emá re tángga átnárát káe yá kung ma háindak. ");
INSERT INTO klt_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Wáina hára Satan da tirak hing mát áwáng sángorán kandák tánirot. ");
INSERT INTO klt_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Niyá manek tángngátak hálendu son ma táindak, ináku ketná yá hánám yáup álosim táinek ka ku niyá kesák táinek wawu waháranan iháng háláng yáminek. ");
INSERT INTO klt_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Pahán táng wáik tátáyan me káman dá sán milun sáni kálu ma áwáng háindak, ináku pahán táng káto tátáyan me watá re ku wáina áwáng háinek. Rám wa átneráng hára me álosim rina memeyan wa rewe mengguineráng watá ku niyá me wa narineráng wa háláng yáminek. ");
INSERT INTO klt_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Rina kámá tát Ánutu yan Iruk Káungá watá pahán márap táiwon. Ánutu yá Iruk Káungá wa sámuk wawu sán hára sánggit tingga sándu nákkán ingga mengga son sáhán along átneráng ingga ku wáina táuk. ");
INSERT INTO klt_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Pahán suksuk, kuk nanará, pahán káráp, menmen, mengmán mengmán, me ket tárák kandák hulá hulá tátá wa erek sang hálineráng. ");
INSERT INTO klt_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Ámna náráwa ya urák yáni narángga ket tárák álosim wa táng yámángga átneráng. Wáina átang gu kátu yáni sáineráng, Ánutu yá Jesu Son Iháhá watán yáup wahára kungga ku kátu sáni sáuk wáinanyon. ");
INSERT INTO klt_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Ánutu yá málámba nángánangge sánda kikiná táwi hánám naráng sámánggoek, wata ku watá ket tárák rina tángngátak wáinanyon táineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Kámá ya kikiná naráng yámámá kálu wahára átningguineráng, Jesu Son Iháhá watá nánda kikiná narángga átkukuná wa nán háláng námámáya sáuk wáinanyon. Átkukuná wa táng Ánutu ya taha mungnganá kikiná ting muk wáinanyon. ");
INSERT INTO klt_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Sándu márámamák ma táindaráng, ket tárák reprepmá ma táindaráng, hang há árán nukngá ya mekmek ma táng kuindaráng. Ket tárák kátu kimo káman wáina kálu tát wata ingga meng sámánirot. Ánutu yan ámna náráwa sándá kálu wáina ma táng kuindaráng. ");
INSERT INTO klt_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Sándá me wáik, me kandák me, me kakarák wáik wáina ma táindaráng. Ket tárák wáik wáina wawu nándá ma táng kuindamán, iná nándá wu heronge me rewe Ánutu inángga átkuinemán. ");
INSERT INTO klt_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Sándu kándáng ing narineráng, niyá márámamák táinek, ket tárák reprepmá táinek, me há árán nukngá ya mekmek táinek wawu ánutu kusák ináng sákngená wáinanyon. Wáina pálak watá Ánutu yot Jesu Son Iháhá watán átkuku wata kinan kung hahayan tárák ku muná. ");
INSERT INTO klt_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Kándáng háleng rákit táineráng, ámna yan me kandák watá sángsárungingga sáháng uyin kung mukmuro wa tánirot. Ánutu yá milun yayali ámna wata pahán káráp táng yámángngátak wawu ket tárák wáina tángngátaráng wata hánám. ");
INSERT INTO klt_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Wáina wata ku ámna wáinaná watyot nuknuk ma átnándaráng. ");
INSERT INTO klt_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Uláp pu páyung kinan áturáng, enendu inggálu ku Táwi yá sáháng yamá hára ting san átaráng, wata ku inggálu wawu yamá yan ámna náráwa yá ina átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Sándá yamá hára átkut tu watá wata páliná álosim ing táng tunggap táinek, ket tárák álosim, kándáng re átkuku, hang me páliná isutang átkuku. ");
INSERT INTO klt_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Táwi Ánutu yá rina átkukuya kikiná narek wa naráng rákit táineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Sándá ámna niyá páyung gán ket tárák tángga átkut watyot nuk ma táindaráng, ináku sándá ku ket tárák wáina wawu kandák ingga meng tunggap tát ámna náráwa yá káineráng. Ket tárák wáina watá páliná álosim ma tindák. ");
INSERT INTO klt_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Milun yayali ámna watá ket tárák kilak tángngátaráng wa mengga nanarán tátáyan wawu reprepmá. ");
INSERT INTO klt_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Iná yamá watá ku ket tárák rina rina wa iháng hiták tin du ámna náráwa yá wawu wáik ingga kápángngátaráng. ");
INSERT INTO klt_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Yamá watá tán náut kámá káman dá hiták átang wawu watá hányon yamá mangga átnándak, wata ku me ing átak: “Ni ámna kák ruhángga átalák, kák ku miráingga tárutnelák. Tanggán káinnan dá tárurátá ku Jesu Son Iháhá wata yamá yá kák hára yamá máinek.” ");
INSERT INTO klt_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Wáina wata ku átkuku sáni káin kándáng hánám wa átkuineráng. Hohoná yá ina ma átkuindaráng, ináku nanará sáni pálak ká ina átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Sándá rám nahára átkuineráng wawu Ánutu yan káinnan ket tárák álosim wa kándáng táineráng, náuta rám náwu wáik hára átamán, wata ku kándáng hánám átneráng, rám watá hánámá sálikngiwon. ");
INSERT INTO klt_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Hohoná yan tárák wa ma táená ku Táwi yan pahán káin rina átak wa kándáng naráng rákit táineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Umi káto táup nangga ma hohindaráng, kálu wáina watá sángorán ket tárák kandák wahára kunirot. Ináku sat Iruk Káungá watá ep káto sáhinek. ");
INSERT INTO klt_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Kámá ya kap mantáng yámineráng wawu Kap Papia káinnan, me miti kap waháranan, me Iruk Káungá yá pahán sáni káin kap rina sánáng tolinek waháranan mantáng yámineráng. Táwi yan káin kap milun sáni hára me pahán sáni kinan mantángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Rámá rámá Táwi náni Jesu Son Iháhá wata kutná hára rina rina tunggafeng sámángngátak wata Ánutu heronge mená inineráng. ");
INSERT INTO klt_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Jesu Son Iháhá wawu Táwi náni ingga narángga ku náni tángga hangga nuknuk náni wata tárang káin átkuinemán. ");
INSERT INTO klt_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Náráwa sándu, nánáun sáni ya tárang káin átneráng, Táwi ya tárang káin átnándaráng wáinanyon, ");
INSERT INTO klt_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","náuta ámna yá ku áwáná ya yáilá átak, wawu Jesu Son Iháhá watá miti ámna náráwaná wata yáin yáni ya átak wáinanyon. Miti ámna náráwa wawu Jesu sutná kátu, ni Jesu málámbá son ihuk wa. ");
INSERT INTO klt_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Miti ámna náráwa yá Jesu Son Iháhá wata tárang káin átaráng wáinanyon du náráwa sándá rámá rámá nánáun sáni ya tárang yáni káin átneráng. ");
INSERT INTO klt_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Ámna sándu áwáwá sáni ya kikiná hánám narineráng, Jesu Son Iháhá watá miti ámna náráwaná ya kikiná hánám narángga átkukuná wa háláng yámámáya sáuk wáinanyon. ");
INSERT INTO klt_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Wa tán rongrongngá háháleya wu umi yot málámbán me watá ku miti ámna náráwaná wa iháng yawolán málámba rahálá hára rongrongngá háliuráng. ");
INSERT INTO klt_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Wáina táe ku rahánna hára álosim hánám konep muná sinsin muná me kandák muná rong hánám átniráng ingga narángga wáina táuk. ");
INSERT INTO klt_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Wáina wata ku ámna sándá áwáwá sáni wa kikiná hánám kápineráng, sáni ya sut sáni ya kikiná nareráng wáinanyon. Ámna niyá áwáná ya kikiná narek wawu málámba kikiná narek. ");
INSERT INTO klt_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Ing há naremán, káman dá málámba sutná táng káyam ma tánggim, ináku sungi sing mángga ku pinná kándáng tánggim, Jesu Son Iháhá watá miti ámna náráwaná wata tángngátak wáinanyon, ");
INSERT INTO klt_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","náuta nándu Jesu Son Iháhá wata sutná kátu. ");
INSERT INTO klt_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Ánutu yan me yá ing mek, “Hulá náta ku ámna yá naning maming yápmangga áwáná yot káman hálengga yará watá sut káman háleinemálák.” ");
INSERT INTO klt_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Me kilakngá náwu hulá táwi hánám, enendu no naret wawu Jesu Son Iháhá watyot miti ámna náráwaná málámbán há hálená wata mek. ");
INSERT INTO klt_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Iná me nátá wu ámna káman káman watá sáni ya kikiná nareráng wáinanyon áwáwá sáni ya kikiná narineráng ga mek. Hang náráwa sándá nánáun sáni ya kekendik táng yámineráng ga mek. ");
INSERT INTO klt_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Nangge sándu Táwi yan pingnga yá átaráng, wata ku nan mam sáni yan milun susuwá hára átneráng. Kálu wáina táineráng watá ku kándáng hálek. ");
INSERT INTO klt_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Táwi yan me yá ing mek, “Nan mamya tárang káin átnelák,” ingga meng rákit me hára hulátek watá wáina mek wawu málámbán me káto wáina tunggafeinek ingga miuk watá wata kinan átak. ");
INSERT INTO klt_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","Me káto wawu ing, “Wáina átnelák wawu káwak ketnán átkuku ka yá kándáng re árán rám hásák átang átkuinelák.” ");
INSERT INTO klt_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Nangge nanan yáni sándu nángánangge sáni wa iháng wáik tát watá sánda pahán káráp ma táindaráng. Ináku pin yáni kándáng tángga ku iháng tolingga Táwi yan me kálu yánáng tolingguineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Sán niyá yáup nangge hánámá ingga átaráng, sándu ámna hulá sáni ingga niyá átaráng wata tárang yáni káin átang pahán sáni yot watán milun suwineráng. Rahán yáni hára kandák táninggom ingga ku Jesu Son Iháháya tárang káin rina átnándaráng wáinanyon átneráng. ");
INSERT INTO klt_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Sándá ámna hulá sáni ingga átaráng yáni sáhángga árát watá álo kámá náhániráng ingga rahán yáni hára re yáup hánghálángngá ma táindaráng, ináku nándu Jesu Son Iháhá watán yáup nangge ingga narángga ku pahán sáni káin Ánutu yan nanará wa isusut wata yáup táineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Ámna yan yáup táemán ingga ma narindaráng, ináku Táwi yan yáup táemán ingga nangnaráng gu pahán heronge hára re átang yáup táineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Sándu ing narineráng, ámna káman dá yáup álosim táinek wawu Táwi yá yumnakngá álosim iminek, yáup nangge hánámá me yáup nangge muná along árená wawu tárákngá káman wáina re yáminek. ");
INSERT INTO klt_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Kulá ámna hulá yáni ingga átaráng, sándu yáup nangge me rina yánet wa, sándá wata wáinanyon táng yámineráng. Yáup ma tát tu sáráhinet ingga yánángga iháng piták ma táindaráng, náuta wa me sándán Táwi wu alek káin átak. Málámbá re ku ámna náráwa kámuk kán átkuku hára wáina wáina ingga kápángga ku tárák káman re horeinek. ");
INSERT INTO klt_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Pukon da ku ing sánindet, sándá ku Táwi yot tántápin tángga árát tu málámbán háláng táwi watá sányot árán wahára kungga ku káto hálengga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Káto átang Ánutu yá tewe ámna yan kutná kutná sut tátámot tán káto káto náminek wa tánggánengga átang gu Satan dá kilak átang rina rina nángnárungin ingga táinek wa iháng hátinemán. ");
INSERT INTO klt_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Nándu ámna náráwa yot ma erawánggumán, ináku iruk káto káto, me kutná kutná háláng yáni pálak rám nahára káwak ketnán páyung wa pinná táeráng watyot, hang ále táitná ánu hára iruk wáik átaráng watyot erawánggoemán. ");
INSERT INTO klt_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Wáina wata ku Ánutu yá tewe ámna yan kutná kutná sut tátámot tán rina sámángga átkoek wa kámuk ihánggáneineráng. Wa ihánggánengga ku rám wáik hára wu iruk wáik kot erawáwá hára káto hálengga átneráng, me erawáwá watá sáliknginek enendu emá re káto hálengga átneráng. ");
INSERT INTO klt_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Sándá káto hálengga átnán wawu me páliná wa táng let sáni ina pánáp sáni hára táng kik tángga, kálu kándáng átkuku wa táng siot káto ina muyip sáni pop táineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Me pingnga álosim watá ing mek, Ánutu yá ámna náráwa yot pahán káman hálenggoeráng. Sándá wata naráng hátinggoeráng wawu erawáwáyan tiyawingga ku su mongoeráng ina hálek. ");
INSERT INTO klt_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Wata kátu yon du naráng hákhátik hára átkuku wa táineráng watá ku palang kátu yá ina árán du Satan dá sáut lánggop pálak wa mulán áwineráng watá wahára kátingga háineráng. ");
INSERT INTO klt_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Ánutu yá son há náhuk ingga narát tu watá at káto yá ina átsáminek. Iná Ánutu málámbán me watá ku Iruk Káungá yan kápik ká ina átsáminek. ");
INSERT INTO klt_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Hang Iruk Káungá watán háláng hára ku sáponga tángguineráng. Rámá rámá sáponga tángga háláng námáng ingga Ánutu inángguineráng. Wáina tángga ku háleng rákit tángga átang Ánutu inát tu málámbán ámna náráwa wa háláng yámángga átnek. Kálu wáina wa ma sáindaráng. ");
INSERT INTO klt_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Sándá sáponga tángga Ánutu inát nák hányon háláng namángga me wa táng nák milunna káin tin no ma pitáená me pingnga álosim watán me kilakngá wa meng tunggap tángga átkuinet. ");
INSERT INTO klt_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Ánutu málámbá me pingnga álosim wa memeya suring namuk ka wata hánám bu no kalabus kinan átat. No me álosim wa memeyan yáup pá átak, wata ku sándá sáponga hára Ánutu inát tu watá háláng naminek, watá ku no ma pitáená ámna náráwa yan káin me álosim wa meng tunggap tángga átkuinet. ");
INSERT INTO klt_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tikikus yá ku no átkoet me rina rina tángga átkoet wata pingnganá sáninek. Málám wawu nuk náni Táwi yan yáup ámna álosim, no málámba kikiná naráng mánggoet. ");
INSERT INTO klt_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","No wa suring me sándán káin áwángga ku nándá rina átkoemán wata sánán narineráng, hang waháranyon du sáni sáháng káto táinek. ");
INSERT INTO klt_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Nan Ánutu yot Táwi Jesu Son Iháhá watá yanuknukna sán pahán láláp sámángga sáháng káto tán du sándá naráng hákhátik hára káto átang kámá ya narát kikiná hálengguinek. ");
INSERT INTO klt_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Ámna náráwa niyá Táwi náni Jesu Son Iháhá wata kikiná táwi hánám narángga ma sangguráng wawu Ánutu yá pahán sáminek. ");
INSERT INTO klt_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Nák ku Pol, Timoti yot nát tu Jesu Son Iháhá watán yáup nangge. Kulá na Pol no papia ná uye ku sate Jesu Son Iháhá watán ámna náráwa it yáilá Filipai káin átaráng sándán káin áwek. Hang wata kinan ámna ni miti ámna náráwa pin yáni tátáyan, me ámna náráwa ni miti ámna náráwa háláng yámámáyan watán káin hányon áwek. ");
INSERT INTO klt_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Nan náni Ánutu yot Táwi Jesu Son Iháhá watá pahán sámán du pahán láláp pá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Nák ku Pol no rám kámá sánda naráng hátinggoet wahára wu heronge me Ánutuna inánggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","No Ánutu yá sán kámuk háláng sásámáya sáponga tángga inánggoet wahára wu pahánna álosim hánám nangnaráng inánggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Hulátingga sándá Jesu yan tombong háliuráng wahára átang inggálu áwángga átkoeráng wahára sándá nák háláng namángga me pingnga álosim wa ámna náráwa yánánggoeráng wata no álosim hánám naráng sámánggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","No ing hánám há naret, Ánutu málámbáyon iruk sáni kinan káin yáup álosim tátáya huláting sámuk wawu málámbá wáina re tángga árán kungga Jesu Son Iháhá watán rám háleinek wahára wu yáup wa pukon tán sáliknginek. ");
INSERT INTO klt_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Sándu pahánna kinan hánám átaráng, wata ku no sánda álosim hánám naránggoet wawu kándáng hálek. No kalabus kinan átkoet me, káyam bá me páliná táng hang titiya tát áráng hákhátik tángga me pingnga álosim wawu pálipuk hánám ingga ámna náráwa yánánggoet wahára wu Ánutu yá nák pahán namuk, wáinanyon du sán kámuk pahán sámuk. Pahán wa námuk wahára kungga ku málámbán yáup wa tánggoemán. ");
INSERT INTO klt_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Ánutu málámbá ing wawu pálipuk ingga narángga átak, Jesu Son Iháhá yá sánda kikiná naránggoek wáinanyon du no sánda kikiná narángga ku pahánna káin sán sásáháya táwi hánám naránggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Rámá rámá no sáponga tánggoet wawu Ánutu ya kikiná nanará káluná me nukngá ya kikiná nanará káluná watá sándán átkuku káin emá rewe táwi hánám hálengga kungga átkuinek, hang iruk kán kálu nanará sáni yá táwi hálen kándáng gu wáina kandák ku wáina ingga naráng rákit tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Wáina wata ku ket tárák kámuk wa sándá kándáng kápáng rákit tángga ku resim bu álosim hánám wa ihángguineráng. Wáina wata ku Jesu Son Iháhá watá son áwinek rám wahára wu Ánutu rahálá hára kandák ká sán hára ma átnándák ináku rongrongngá hánám átneráng. ");
INSERT INTO klt_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Wáina átang Jesu Son Iháhá yan háláng wahára kungga ku ket tárák álosim bán páliná watá sándán káin tuwatang átnek. Iná ámna náráwa yá ku wa kangga ku Ánutu kutná meng tárut táineráng. Sáponga ku wáina kálu táng sámángga áwánggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Yanuknukna, sándá ing narineráng, nák hára rina tunggafiuk watá Táwi yan me pingnga álosim watán kálu wa ma suwuk, ináku watá háláng imán du me pingnga álosim watá káto hálengga átkoek. ");
INSERT INTO klt_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Wáina wata ku tewe ámna kámuk Rom bán ámna yáilá Sisa yan it pinná tátá me ámna náráwa táwi yon watá no Jesu Son Iháhá watán yáup tánggoet wata ku ámna kámá yá neháng kalabus kinan tiuráng ingga há nareráng. ");
INSERT INTO klt_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Táwi yan ámna náráwa táup táwi hánám bá yon du no kalabus kinan átkoet wata pingngana naránggoeráng. Kulá nák pingngana watá ku pahán yáni táng káto tán Táwi yan káin naráng hákhátik tátá watá káto hálengga átkoek. Wáina tángga ku pikpito ma narená hánghálángngingga átang Ánutu yan me wa meng tunggap tángga kunggoeráng. ");
INSERT INTO klt_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","16","Ámna kámá yá ku nanará álosim wahára átang nák háláng namámáya narángga ku Jesu Son Iháhá watán me pingnga álosim wa meng tunggap tángga kunggoeráng. Ámna wawu ing há nareráng, no kalabus kinan átkoet wawu me pingnga álosim wa táng káto tátáya, wáina hálendu nák ka kikiná hánám naráng namángga ku Táwi yan me wa mengga átninggoeráng. Iná ámna kámá yá ku no yáup tánggoet wata kalán nán yon du nákka pahán kandák naráng namángga ku neháng hang tingga yáni ya kut yáni táng hip tátáya, wata ku Jesu Son Iháhá watán me pingnga álosim wa meng tunggap tángga kunggoeráng. ");
INSERT INTO klt_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Ámna wawu yáni rina átnát wata narángga wata ingga ku wáina tánggoeráng, hang wawu nanará kándáng watá watyot árán ma táng kuráng. Márapmá suwánggoet wawu kalabus kinan átkoet wa, son du márapmá nukngá nák ketnán tinin ingga wata wáina tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Wáina tánggoeráng enendu káman niyan káin nanará álosim watá átmán Jesu Son Iháhá yan me menggoek, me nanará kandák watá átmán Jesu Son Iháhá yan me menggoek wawu álo kámá re. Ámna kámuk wáina tánggoeráng wawu Jesu Son Iháhá watán me pingnga álosim wa mengga kunggoeráng. Wáina tát tu no heronge hánám naránggoet. ");
INSERT INTO klt_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Nák ku heronge hára rewe átnet, náuta sándá sáponga tángga nák háláng nanamáya Ánutu inánggoeráng, me Jesu Son Iháhá watán Iruk watá neháng káto tánggoek wata. Na ku ing há naret, márapmá rina tá nehángga átkoek, enendu kálu yará wa met wahára kungga ku Ánutu yá háláng namángga káyam ket yáni háranan son nehinek. ");
INSERT INTO klt_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Wáina wata ku no pahánna yot hánám ing naret, no hánghálángngingga átang gu náut kámá kandák káman ma táindat. Kandák káman tángga ku Ánutu rahálá hára reprepmá naringgom. Inggálu me máriya wawu pikpito ma narená káto re átang ket tárák álosim rámá rámá tángngátat wa rewe tángga átnet. Kámutnet me átnet wawu rina rina tánggoet watá ku Jesu Son Iháhá wata kutná meng tárut táinek. ");
INSERT INTO klt_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Iná nákkán nanará káin wawu ing, no ma kámurená átnet wata hulá wawu Jesu Son Iháhá wata kutná meng tárut tángga átnet, iná há kámutnet wawu álosim hánám, náuta Jesu yot átnemát. ");
INSERT INTO klt_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Iná no ma kámurená átnet wawu yáup tángga áre yáupna wata páliná yá álo kámá sángga átnek. Kámutnet me há átnet wawu álosim re, enendu resim bu álosim hánám? Wawu ma narát. ");
INSERT INTO klt_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Yayará wawu álosim rewe. No kung Jesu Son Iháhá watyot átnet wawu álosim hánám ingga naret. Kámutang kung Jesu yot átnet watá ku káwak káin átnát wa táng hátek. ");
INSERT INTO klt_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Wáina enendu káwak káin há átang sán háláng sáminet wawu kutná táwi hánám. ");
INSERT INTO klt_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","No me wawu pálipuk ingga narángga átkoet, wata ku no ing há naret, no káwak ketnán há átang yáup tángga háláng sáme naráng hákhátik sáni yá káto hálen heronge átneráng. ");
INSERT INTO klt_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Wáina táe ku rám no son sásáháya sándán káin áwinet wahára ku sándá nák nahángga ku Jesu Son Iháhá wata heronge táwi hánám táng mángga ku kutná meng tárut táineráng. ");
INSERT INTO klt_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Kutná táwi hánám wawu átkuku sáni yá kándáng re árán Jesu Son Iháhá watán me pingnga álosim wa rewe isutang átkuineráng wa. Wáina árát tu no áwángga sáhinet, me pingnga sáni re narinet wahára ku no ing há narinet, sándu káto hálengga pahán káman me nanará káman hára re átang gu hánghálángngingga ámna náráwa yan naráng hákhátik káin me pingnga álosim wa táng káto táng yámineráng. ");
INSERT INTO klt_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Niyá yáup wata ingga sáháng káyam tát tu ma pitáindaráng. Wáina tát sáhángga ku káyam bá ku ing narineráng, nándu Ánutu yá náháng lem há táinek, iná sándu málámbá háláng sámángga son sáhinek ingga sáhángga ku wáina narineráng. Ánutu málámbá ku wáina hánám táinek. ");
INSERT INTO klt_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Ánutu yá Jesu Son Iháhá wata naráng háting mámáyan káluná wa táng toling sámuk waháranyon du Táwi ya naráng háting mánggoeráng wata ku wa isutang gu márapmá susuwáyan káluná wa hányon mengga ting sámuk. ");
INSERT INTO klt_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Sándá márapmá rina suwánggoeráng wawu no sáni yot wakáin átang suwánggiut wáinanyon, hang rám nahára kalabus kinan átang suwángga átkoet wáinanyon. ");
INSERT INTO klt_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Sándá Jesu Son Iháhá watyot tántápin tángga átkoeráng, wata ku málámbá pahán sáni táng tárut tángga átkoek. Me Jesu yá sánda kikiná hánám naránggoek, wata ku sándá pahán láláp tángga átkoeráng. Me sándá Iruk Káungá watyot pahán káman átkoeráng. Hang Ánutu yá sánda urák sáni narángga sáháng álolo tánggoek. ");
INSERT INTO klt_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Sáni wáina átang gu nanará káman re kámá ya kikiná narángmán narángmán tátá watá orek sáni hára árán pahán káman re átneráng. Iná sándá wáina átneráng hálen wawu nák pahánna yá álosim hánám háleinek. ");
INSERT INTO klt_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Rina rina táineráng wahára wu sáni ya re narát árená hálen kut sáni táng hip ma táindaráng, ináku sáni ya narát háená hálen kámá kápát kut yáni táwi ina háleineráng. ");
INSERT INTO klt_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Sán káman káman dá sánin pahán káin rina átak wata re ma narindaráng, ináku ámna náráwa nukngá yan pahán káin rina átak wa háláng yámánin ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Pahán nanará sáni wu Jesu Son Iháhá watá pahán nanará rina tingga átkoek wáinanyon tingga átkuineráng. Kulá pahán du ing tingga átkoek: ");
INSERT INTO klt_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Málám bu Ánutu yon, enendu watá Ánutu yan uliháláng nák hára átak wa káto tángga árin ingga ma naruk. ");
INSERT INTO klt_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Ináku málámbán kut táwi wa wáina san árán málám tán ále hánám háliuk. Ámna nangge hánám hálengga yáup nangge hánámá kutná muná ina háliuk. ");
INSERT INTO klt_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Ámna nangge hánám wáina hálengga ku málám tángga hangga Ánutu yan nanará isutang kámutuk. Wa kámutuk wawu hulá kámá hánám, wawu maripong hára kámutuk wa. ");
INSERT INTO klt_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Hulá wata hánám bu Ánutu yá Jesu táng hip táng áráng tin árená hánám árán, kut káman imuk wawu álo kámá hánám, kut watá ku kut kátu wa erek hánám iháng hátek. ");
INSERT INTO klt_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Ánutu yá wáina tán du alek káinnan, me káwak káinnan, me káwak tárang káinnan watá kámuk hánám turingga hangga tun yáni hára imángga Jesu kutná meng tárut tángga wata tárang káin re átneráng, ");
INSERT INTO klt_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","hang milun kámuk ká ing meng tunggap táineráng, “Jesu Son Iháhá wawu Táwi” ingga meineráng. Wáina meineráng wawu Nan Ánutu kutná meng tárut táineráng. ");
INSERT INTO klt_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Wáina hálendu, yanuknukna pánpáliná, sándá ku rámá rámá Ánutu yan milun isutnándaráng, wáinanyon du inggálu wáina re isutang átkuineráng. No sányot áre wahára re ma isut kuindaráng, ináku sányot átnet me ma átnándát wawu sándá ku kándáng re átang átkuineráng. Ánutu yá son sáhángga ku sándá málámba rahálá hára rongrongngá hánám háháleya ku wata yáupmá tángga átkoek, wata ku wata narángga sáni tángga hangga Ánutu tárang káin átang gu mukmuro táninggom ingga wata pikpito narángga hánghálángngingga átang ket tárák álosim wa rewe tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Ánutu málámbá pahán sáni kinan káin yáup tángga árán pahán sáni tárurán du sándá rina tátáya narek wawu málámbá háláng sámán wa tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Sándá rina rina táineráng wata mená yon táwi tángga menmenná pálak ma táng kuindaráng. ");
INSERT INTO klt_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","16","Wáina tángga ku Ánutu nángánangge yá ina átang ámna náráwa rahán yáni hára kandák ma árená rongrongngá kándáng re átneráng. Me átkukuná pálak wa tángga átang ámna náráwa yámámáya tángguineráng, hang ámna náráwa niyá kálu kándáng wa sangga kandák hánám átaráng wata orek yáni hára alek káin hitung gá yam yáni mangga átnándaráng sándá wáinanyon átkuineráng. Wáina átneráng watá ku Jesu Son Iháhá watá son áwinek rám wahára wu no sándá ket tárák álosim tánggoeráng wata heronge narángga meng toling sámángga ku ing narinet, no yáup táwi rina tánggiut watá hánámá ma háliuk ingga narinet. ");
INSERT INTO klt_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","No Táwi yan yáup tánggoet wata ámna kámá yá nák nutkámut tátáya tánggoeráng. Sándá Jesu ya naráng háting mánggoeráng, wawu átkuku sáni wa taha sáni ina Ánutu yan alta káin tinggoeráng. Iná nák há nutkámut tát hálendu nák sipna watá ku taha titiya wáin kulená wa ina hálendu sándá átkuku sáni táng taha ina tinggoeráng wata ketnán kukuliyan wáina háleinek. Wáina tunggafeinek enendu nák ku heronge rewe átang átkuinet, hang no sányot heronge tángga átang átkuinet. ");
INSERT INTO klt_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Kulá wáinanyon du sándá heronge rewe táineráng, hang sándá nákkot heronge tángga átkuinemán. ");
INSERT INTO klt_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Táwi Jesu yá narán álo hálen wawu Timoti suring me sándán káin kungga rám rina hára nákkán káin son áwinek wahára ku sándán me pingnga nanán narángga ku no heronge narinet. ");
INSERT INTO klt_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Ámna nukngá kámá wa ina nákkot nahára kámá ma árak, iná ámna málám náwu nákkot pahán káman hálen sán háláng sásámáya pahán yot yáup tánggoemát. ");
INSERT INTO klt_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ámna nukngá kámá wu yánin pahán káin rina átak wata rewe narát árená hálendu Jesu Son Iháhá yan yáup wa meng isurát kuku wata ma narángguráng. ");
INSERT INTO klt_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Iná Timoti yan ket tárák álosim wawu sáni kangga ku yáup ámna álosim ingga sáni há kangngátaráng wa. Sáni há nareráng wa, watá háláng namán du me pingnga álosim wata yáupmá tánggoemát wawu nangge káman dá naning háláng imángngátak tárák wáinanyon. ");
INSERT INTO klt_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Wáina wata ku no sopmuná ingmen suring me sándán káin áwánggim, enendu hulátingga hánám bu nák hára rina tunggafen káin ingga wata hálet. ");
INSERT INTO klt_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Iná nák ku ing hánám há narángga átat, Táwi yá kálu táng toling namán du máriya sim bu hányon áwángga sáhinet. ");
INSERT INTO klt_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Kulá hang nanará káman du ing naret, Epafrotitus kálak há suring me sándán káin son áwinek. Ámna wawu nák nukna me yáup nákkot káman tángngátamát, hang ámna wawu tewe ámna yá hánghálángngingga erawángngátaráng tárák wáinanyon du miti yáup tánggoek. Ámna wawu sáni suring mát áwáng sánin me nanuk. No náut ta kesák táut wahára háláng namámáya suring mát áwuk. ");
INSERT INTO klt_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Ámna málám wawu sán sásáháya táup tángga átak, hang ing hányon naruk, málámbá ilalák táuk wawu sándu há naruráng, enendu málám bu álo háliuk me muná wawu sándu ma naráráng, wata ku pahán márap táwi hára átak. Wáina hálendu, no suring me sándán káin kuinek. ");
INSERT INTO klt_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Wawu pálipuk, ilalák márapmá hánám tángga hála kámutuk, enendu Ánutu yá urákngá narángga ku ilalákngá wa tán álo háliuk. Ánutu yá wata re urákngá ma naruk, ináku nák ka urákna hányon naruk, wawu márapmá táwi nukngá yá nákkot átnát ta ma naruk. ");
INSERT INTO klt_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Wáina wata ku no há hánám suring me áwán du sándá kat álo árán kangga heronge narineráng, me no sánda ingga narángpak ma táindát. ");
INSERT INTO klt_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Rám Epafrotitus yá sándán káin áwáng hinek wahára wu sándá ku wa Táwi kutná hára álo kámá áwelák ingga inángga heronge táwi hánám táng mineráng. Sándá ámna wáinaná wawu kut yáni táng hip tángguineráng. ");
INSERT INTO klt_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Jesu Son Iháhá watán yáup pa ingga átkukuná hála sáuk. Málámbán átkuku wata narán táwi ma háliuk, ináku nák háláng nanamá wata narán táwi háliuk. Sándá háláng nanamáyan wawu káluná muná, wáina wata ku Epafrotitus yá sándán kome tángga nák háláng namánggiuk. ");
INSERT INTO klt_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Yanuknukna, me nukngá ing sánin, Táwi ya heronge hánám naráng mineráng. No me ing son uying sámámáya takta ma narát, náuta me nátá ku háláng sámán álo kámá átneráng. ");
INSERT INTO klt_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Ámna kámá ang páyom bá ina ket tárák wáik tángga átninggoeráng ga ku sándá háleng rákit kándáng tángga átkuineráng. Ámna wáinaná watá ku ámna ing yánáng tolinggoeráng, “Sándá átkuku sásáliná muná wa tánin ingga wawu kip sáni wa mamará háleinek.” Me wáina yánángga átninggoeráng, enendu me wawu kusák hánám. ");
INSERT INTO klt_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Iná nándu Ánutu yan ámna náráwa pánpáliná hánám. Nándu Iruk Káungá watán háláng hára Ánutu ináng sáknginggoemán. Nándu Jesu Son Iháhá watán yáup hára re ku Ánutu yá son náhuk wata heronge hánám narángga Jesu kutná meng tárut tánggoemán, wáina wata ku, ing há naremán, ámna yá yáni ya sut yáni hára tárák hulá hulá rina tángngátaráng watá kámá ma háláng yámindák. ");
INSERT INTO klt_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Iná sut tán kutná kutná watá álo háláng nánámáyan iná wawu nák ku álo kámá hánám wáina átgem. Ámna kámá yá sut tán kutná kutná hára háláng yáni tin átaráng wáina no átang iná wawu no erek hánám iháng hátinggem. ");
INSERT INTO klt_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Nák ku tunggafengga rám 8 áre ku kepna maruráng. Iná nák ku Israel ámna náráwa waháranan, me tombong Benjamin waháranan, me nanna me mamna wawu tombong Hibru hánám wata ku nawu Hibru hánám bon. Nák ku tombong Farisi hálendu Moses yan meng rákit me wa kándáng hánám isutnándat. ");
INSERT INTO klt_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Uláp pu no Jesu yan ámna náráwa wawu Ánutu káyammá ingga naránggiut, wata ku Ánutu kutná meng tárut táin ingga ku wa iháng lem táup hánám tánggiut. Iná ámna náráwa yá meng rákit me wahára ting kung nákkán átkuku wa káineráng wawu nákkán kandák kámá ma káindáráng. ");
INSERT INTO klt_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","No uláp pu ále hulá hulá wáina táe Ánutu yá wa kápángga ku neháng álolo táinek ingga wáina tánggiut, enendu inggálu ku Jesu Son Iháhá wata naráng háting mánggoet, wata ku sut hára hulá hulá wáina tátá wawu nare ále hánám hálenggoek. ");
INSERT INTO klt_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Wata kátu háranyon du ing, no naret tu Táwina Jesu Son Iháhá wata naráng háting mámá wawu kutná táwi hánám, wata ku kutná kutná kámuk hánám wawu kápe ku ále hánám hálenggoeráng. Nák ku Jesu ya naráng háting mángga ku kutná kutná kámuk wawu erek hánám há sang háliut. No wa kápe ku susut ina hálet Jesu Son Iháhá wa rewe káto tángga ");
INSERT INTO klt_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","watyot ronrosin átkuinemát. No meng rákit me watán kálu wa isutnet wata re ámna kándáng ma háleindát. Ináku ámna kándáng háháleyan káluná wawu Jesu Son Iháhá ya naráng háting mámá wa rewe. Jesu ya naráng háting mátne ku Ánutu yá ámna náráwa kándáng ingga náninek. ");
INSERT INTO klt_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","No Jesu Son Iháhá wata kándáng hánám naráng minán naret. Jesu yá há kámurán Ánutu yan háláng watá son táng tárut táuk. Ánutu yan háláng watá nákkot átnek wata naret. Rám na márapmá suwánggoet wahára ku naráng kung Jesu yá márapmá hányon suwuk wa narángga ku watá neháng káto tánggoek, hang no ku Jesu yan yáup wa háláng imámáya kátkámut ta tiyawinet, tárák wáinanyon du Jesu yá nák háláng namámáya kámutuk. ");
INSERT INTO klt_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","No me wa mengga háet wata páliná yá há tunggafeineráng ga naret, náuta máriya ku Ánutu yá kátkámut háranan son há neháng tárut táinek ingga naret wata. ");
INSERT INTO klt_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Jesu Son Iháhá watán ket tárák ká átak wáinanyon hánám nákkán ket tárák watá kung wahára hánám ma árak, wata ku nawu kándáng álo átat ingga ma menggem, ináku rámá rámá wu yáup háláng hánám tángga Jesu inanyon háháleya yáupmá tánggoet. Jesu yá no málám inanyon átnát ta narángga málámbán pingnga ya há nehuk. ");
INSERT INTO klt_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Yanuknukna, nawu ket tárák wáina hánám há tángga átat ingga ma narát, iná no nanará káman naránggoet, wawu uláp rina tánggiut wata ma naránggut, ináku yáup háláng tángga ku máriya rina tunggafeinek wa tátá wata nanará tinggoet. ");
INSERT INTO klt_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Nák ku yumnak álosim wa táin ingga tawon tená wahára kung heheya hururung hánám kungga átkoet. Yumnak wawu ing, Jesu Son Iháhá watá yáup táuk wahára kungga ku no áráng alek káin Ánutu málámbot álo kámá átnát ta wata ingga mantáng namuk. ");
INSERT INTO klt_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Kulá sán niyá naráng hákhátik hára há káto hálengga átaráng hálendu sándá ku nanará álosim no wa met wawu pálipuk ingga narángga ku wa isutneráng. Iná nanará sáni yá kámá átak hálen wawu Ánutu málámbá ku nanará sáni wa táng tolingga táng kándáng ting sáminek. ");
INSERT INTO klt_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Iná kutná táwi hánám wawu ing, nándu Ánutu yá nanará páliná há námán kangga táumán wa káto tángga átang wa isutnemán. ");
INSERT INTO klt_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Yanuknukna, sándá ku nákkán ket tárák rina wa há káuráng, wata ku kung nuknuk sáni hára sengsáráp tángga ku nákkán ket tárák watá isutkoeráng wáinanyon sándá ku hányon isutneráng. Sándá ku ámna náráwa niyá nándán ket tárák wa kangga wáinanyon isutkoeráng wa kápángga ku wáinanyon isutkuineráng. ");
INSERT INTO klt_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Wawu náuta, ámna táup pá yon Jesu Son Iháhá watán maripong wata káyammá hálengga átaráng wata. Me náwu rám máro hánám há sánángga áwut, wanyon du kula ku rahánna uminá kinan átang wa son sánet. ");
INSERT INTO klt_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Ámna wawu sut tán kikiná wa rewe isutkoeráng, wata ku sut tán kikiná watá ánutu yáni hálenggoek. Káwak kán kutná kutná wata re narát árená hálen káwak kán tirik tárák reprepmá átaráng wa isusut ta reprepmá ma narángguráng, ináku wa tátáya heronge hánám narángga wáina tánggoeráng. Ámna wáinaná wawu Ánutu yá iháng lem tán muná kuineráng. ");
INSERT INTO klt_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Iná náni wu it náni hulá wu alek, wata ku Táwi Jesu Son Iháhá watá alek kálu hangga ku son náhinek wata pahán yot hánám háleng mángga átamán. ");
INSERT INTO klt_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Málámbán háláng hára kutná kutná kámuk hánám wa tán málámba tárang káin árát tu háláng watá yon du káwak sut náni nátá márapmá suwánggoeráng wa tán kokolingga hulá kámá hálengga ku málámba sutná yá átak ina álosim hánám háleineráng. ");
INSERT INTO klt_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Wáina wata ku, yanuknukna, sándá ku wáina re átang gu Táwi hára káto yáreng kátingga átkuineráng. Nák ku sánda kikiná hánám narángga ku sán son sásáháya álo kámá hánám naránggoet. No yáup háláng rina táut wata páliná wu sán, wata ku no sánda heronge hánám naráng sámánggoet. ");
INSERT INTO klt_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Yuodia káling Sintike, no ing há táinemálák ka naret, sándá ku menmen ma táená ku pahán káman átkuinemálák, náuta sán yayará wu Táwi yan yáup náráwa. ");
INSERT INTO klt_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Iná yáup náti káman hánám tángga árená kák ku ing kanindet, ko ku náráwa yará wa háláng yámátá ku watá pahán káman átkuinemálák. Náráwa yará watá nákkot káman átang yáup háláng tángga Jesu yan me pingnga álosim wa ámna náráwa yánángga átkumán. Náráwa yará wa, me Klemen yot tu ámna náráwa nukngá kámá átaráng watyot kámuk náni káman átang gu me pingnga álosim wa yánángga átkumán. Ánutu yá átkuku yan papia hára kut yáni há uying san átaráng. ");
INSERT INTO klt_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Rámá rámá Táwi ya heronge naráng mineráng. Son me wanyon ing meindet, heronge naráng mineráng! ");
INSERT INTO klt_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Sándá ámna náráwa kámuk iháng pahán láláp táng yámát tu pahán láláp sáni wa hiták káineráng. Táwi yá áwáwáyan rám wawu hátewingga átak. ");
INSERT INTO klt_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Náut kámá káman da narángpak ma táindaráng, ináku rámá rámá náut ta narángga ku sáponga tángga Ánutu heronge me inángga ku háláng sásámáya inángguineráng. ");
INSERT INTO klt_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Wáina tángga ku pahán láláp Ánutu yá námánggoek watá pahán nanará sáni kándáng pinná tángga átnek. Ánutu yá pahán láláp námánggoek wawu Jesu Son Iháhá wata naráng háting mánggoemán wata. Ánutu yan pahán láláp wawu álosim hánám, ámna nangge yá wata hulá wa nanaráyan tárák ku muná hánám. ");
INSERT INTO klt_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Yanuknukna, me nukngá kámá ing sánin, rámá rámá ku ing narángga átkuinemán, me pálipuk re isusut, kámá iháng totoli, kálu kándáng isusut, rongrongngá re átkuku, náut kámá álosim ba kikiná nanará, kámá yá álosim rina tát kákápá, álo kámá rewe átnát, me álosim tátne kámá yá wa kangga Ánutu kutná meng tárut tátá, wa hánám narángga wahára re átang átkuinemán. ");
INSERT INTO klt_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Wáina átang gu no me rina sánáng tole táuráng me nákkán hára rina naruráng me nákkán hára rina káuráng wa iháng tárák hára tit tu Ánutu pahán láláp márumá watá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Kulá rám hásák sim átang áwuráng wahára sándá ma háláng namuráng. Iná rám nahára nák háláng namámáya son naráng hátit no Táwi ya heronge táwi hánám naráng mánggoet. Pálipuk uláp pu háláng nanamáya naránggiuráng, enendu háláng nanamáyan káluná wawu muná. ");
INSERT INTO klt_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","No wáina sánet wawu no kutná kutná ya kesák tángga átang wata ingga ma sánát. Nák ku átnátna káin náutá rina tunggafengngátak wawu álo rewe ingga narángngátat. ");
INSERT INTO klt_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Kesák átnát rámá me kutná kutná pálak átnát rámá wawu nákkán káin há tunggafeng namuk. Rina rina nákkán káin tunggafeinek wawu álo rewe ingga há narinet. Sungi na pálak me sungi na muná, hang kutná kutná na pálak me kutná kutná na muná átnet wawu álo rewe ingga narinet. ");
INSERT INTO klt_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Jesu Son Iháhá watá neháng káto tánggoek, wata ku watán háláng hára ku no kálu rina rina watá nákkán káin tunggafeinek wawu álo rewe átnet ingga naret. ");
INSERT INTO klt_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Enendu no sándá háláng namángga márapmá rina sungga átkoet wa táng láláp táuráng wata heronge naráng sámet. ");
INSERT INTO klt_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Kulá Filipai ámna náráwa sáni ing há nareráng, Jesu yan me pingnga álosim watá hulátingga sándán káin áwuk wahára átang árongga no Masedonia provins wa sáut wahára wu sándá re ku sup pán kálu nák háláng namuráng, Jesu yan ámna náráwa urum kámá yá ku muná. ");
INSERT INTO klt_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Hang it yáilá Tesalonaika wakáin átang kesák tángga átkiut wahára wu sándá rám máro sim bon nák háláng namámáya sup hirarát nákkán káin áwánggiuk. ");
INSERT INTO klt_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Sándá sup nukngá wáinanyon háláng nanamáya narineráng ingga narángga wata ma sánát, ináku ket tárák álosim wáina wa tángga re árát tu Ánutu yá sáháng álolo táng sáminek ingga naret. ");
INSERT INTO klt_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Kulá sup táwi Epafrotitus imát ihángga áwuk wawu há namuk, iná sup wa sat áwuk watá ku nákkán kesák rina wa erek hánám táng tolin du álo rewe átat. Iná sup wa sat áwuk watá ku Ánutu ya towet sing mát mungnganá kikiná hásin álosim narángngátak wáina. ");
INSERT INTO klt_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Ánutuna wawu kutná kutná kámuk hánám wata márum yáni. Wáina wata ku málámbá náuta kesák tángga átkoeráng wa sáhángga ku Jesu Son Iháhá yan yáup wahára kungga ku wa sámángguinek. ");
INSERT INTO klt_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Nan náni Ánutu wawu rámá rámá sásáliná muná kutná meng tárut tángga átkuinemán. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Sándá nákkán káe álo táng kung Jesu Son Iháhá watán ámna náráwa kámuk yánineráng. Hang nuknukna nákkot átaráng watá káe álo yáni hányon meng sat sándán káin áwek. ");
INSERT INTO klt_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Jesu yan ámna náráwa it yáilá nahára átaráng watá káe álo yáni meng sat sándán káin áwek, me Jesu naráng mená Rom bán ámna yáilá Sisa watán it kinan yáup tángga átkoeráng watá káe álo yáni pahán yot hánám meng sat sándán káin áwek. ");
INSERT INTO klt_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Táwi Jesu Son Iháhá watá pahán sámángga iruk sáni yot átnek. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Nák ku Pol, Jesu Son Iháhá watán aposel. Ánutu yá málámbán pahán isutang gu no aposel yáup tátáya neháng tunggap táuk. Nuk náni Timoti ku nákkot átamát. ");
INSERT INTO klt_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","No papia ná uye ku sate nuknuk náti sán it yáilá Kolosi hára átaráng sándán káin áwek. Sándu rongrongngá hánám átang Jesu Son Iháhá wata naráng háting mángga ku naráng hákhátik sáni ma sáená káto hánám tángga átkoeráng. Nan náni Ánutu yá pahán sámán pahán láláp pá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Nát tá sáponga tánggoemát wahára wu rámá rámá sánda narángga Táwi náni Jesu Son Iháhá wata Naning Ánutu wa heronge me inánggoemát. ");
INSERT INTO klt_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Sándá Jesu Son Iháhá wata naráng háting mángngátaráng, me Jesu yan ámna náráwa wata kikiná naráng yámángngátaráng wata ingga met narángga ku wáina tánggoemát. ");
INSERT INTO klt_vpl VALUES ("CL1_5","081_1_5","COL","1","5","6","Rám me páliná, me pingnga álosim, watá sándán káin áwuk wahára ku Ánutu yá alek kán kutná kutná álosim málámbán ámna náráwa yámámáya tiyawingga san átak wata sánát naruráng. Kulá inggálu sándá pálipuk há hánám táinemán ingga narángga wa tátáya hálengga átkoeráng, wata ku Jesu ya naráng háting mángga kámá ya kikiná naráng yámánggoeráng. Káwakngá káwakngá me pingnga álosim wa mengga kut narángga ámna náráwa yá wa isutang árát me páliná watá páliná álosim sángga kungga átkoek. Kulá sándu wáinanyon, hulátingga hánám Ánutu yá pahán námánggoek watán me páliná wa kándáng hánám há narángga wa táuráng hára átang áwángga inggálu sán hára wáinanyon páliná sángga átkoek. ");
INSERT INTO klt_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Epafras yá me pingnga álosim wa sánáng tolin du wa narángga táuráng. Epafras wawu Jesu Son Iháhá watán yáup ámna álosim, nányot yáup káman táená. Nándá wata kikiná hánám naráng mánggoemán. Watá nán kurák mátap náni tángga sándán káin kungga Jesu yan me pingnga álosim wa sánuk. ");
INSERT INTO klt_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Ámna watá ku sándu Iruk Káungá watán háláng wahára kungga Ánutu yan ámna náráwa wata kikiná narángngátaráng ingga nánuk. ");
INSERT INTO klt_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Wáina wata ku hulátingga sándán pingnga wa narumát wahára átang áwángga inggálu átamát wahára ku rámá rámá sáponga tángga Ánutu inánggoemát wawu sán háláng sámán du málámbá sándá rina átnát ta narek wa kándáng narát tu Iruk Káungá watá nanará álosim wa sámán nanará watá sándán káin táwi tái háháleya. ");
INSERT INTO klt_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Wáina sáponga tánggoemát wawu nát tá ing narángga wata, sándá ket tárák álosim Táwi yá sándá rina átnát ta narek wa há hánám tángga átang gu Ánutu málámba kándáng naráng mángga árát nanará sáni watá táwi hálengga kungga árán du sándá ket tárák álosim kámuk wa tángga árát watá páliná álosim sángga árát tu málámbá wa kangga álosim naráng sáminek. ");
INSERT INTO klt_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Hang sáponga ing hányon tánggoemát, Ánutu yan háláng wawu táwi hánám yamá sireretná pálak emá re átang watá háláng sámán du sándá káto átang márapmá hulá hulá wata kinan háineráng enendu heronge rewe pahán láláp hára átang márapmá wa suwángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Wáina átang gu Nan náni heronge me inángguineráng. Málámbáyon tán du sándá málámbán ámna náráwa páliná háliuráng, wata ku ámna náráwa sán yamá kinan átaráng watá alek kán kutná kutná álosim sásámáyan tiyawiuk wawu álo ihineráng ingga miuk. ");
INSERT INTO klt_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Páyung watán háláng wata tárang káin árátne watá pin náni tángga átkiuk, enendu Ánutu málámbá son náhángga náháng málámba Nanggená kikiná hánám naráng mángngátak watán kumbi kinan tingga málámbá pin náni tángga átkoek. ");
INSERT INTO klt_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Nanggená watán yáup wahára kungga ku Ánutu yá son náháng yungga nándán mukmuro wa yawonduk. ");
INSERT INTO klt_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Nándá Ánutu ma kakayan, enendu Nanggená wawu Ánutu málámbon, wata ku Jesu há naráng memán hálendu Ánutu há naráng memán hálek. Nanggená yáilá ku wa, wata ku kutná kutná málámbá narán tunggafiuráng wata yáin yáni ku málám wa rewe. ");
INSERT INTO klt_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Nanggená wahára kungga ku Ánutu yá kutná kutná kámuk hánám wa iháng tunggap táuk. Alek káin me káwak káin, rahán dá kakayan me ma kakayan, angelo me iruk hulá hulá átaráng me kutná kutná uliháláng yáni pálak átaráng wawu Ánutu yá Nanggená wahára kungga ku Nanggená málám watán da iháng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Nanggená wawu há árán torong káin du ále kutná kutná watá tunggafiuráng, hang watá tán kutná kutná kámuk hánám watá kándáng re átkoeráng. ");
INSERT INTO klt_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Nanggená málám bu miti ámna náráwa wata yáin yáni, hang miti ámna náráwa wawu wata sutná. Watá yon du miti ámna náráwa watán átkuku wata hulá, me kámurená háranan dá son tátárut wawu málámbá kálak máta yáriuk, wata ku kutná kutná kámuk hánám ba yáin yáni háliuk. ");
INSERT INTO klt_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Ánutu málámbán káin nanará me háláng me átkuku rina átaráng watá erek hánám Nanggená wahára átneráng ingga miuk, wata ku Ánutu málám bu Nanggená wahára átak. ");
INSERT INTO klt_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Jesu yá yáup táuk wahára kungga ku Ánutu yá alek káin me káwak káin kutná kutná kámuk hánám átaráng watá málámbot pahán káman háháleyan káluná wa sariuk. Kálu wawu ing, Jesu yá maripong hára kámurán sipmá yá sungguliuk wahára kungga ku Ánutu yot pahán káman háliumán. ");
INSERT INTO klt_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Uláp pu sándu Ánutu yot sansan átang gu nanará kandák me ket tárák wáik wa tánggiuráng wahára kungga ku wata káyammá átkiuráng. ");
INSERT INTO klt_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Wáina átkiuráng, enendu inggálu ku Jesu Son Iháhá watá málámbán káwak sut wa táng kung kátkámut kálu hára tiuk wahára kungga ku Ánutu yá tán du sándá málámbot pahán káman há háliuráng. Wáina tán du rahálá hára rongrongngá káungá hánám árát sán sáháng áwáng kondolá hára tin du ni kámá káman dá me hára sáháng titiyan tárák kámá muná. ");
INSERT INTO klt_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Kulá sándu naráng hákhátik wa káto tángga kándáng átkuineráng. Ánutu yan me pingnga álosim watá ku nanará káman ing nánáng toliuk, nándá ku Ánutu yá alek kán kutná kutná álosim wa náminek ingga hálengga átnemán. Náut kámá káman dá sángsárungingga sáháng uyingga kun nanará wa sanirot. Me pingnga álosim wawu káwak ketnán ámna náráwa kámuk hánám átaráng watán káin meng isurát kuk, hang nák Pol nák ku me pingnga álosim watán yáup ámna hányon háliut. ");
INSERT INTO klt_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Nák ku sán háláng sásámáya márapmá suwánggoet wata heronge narángga átat. Jesu Son Iháhá watá márapmá me láwit rina rina no susuwáyan da mengga tiuk wawu málámbá márapmá rina suwuk wáinanyon no kámuk hánám ma suwut, wata ku yáup emá re tángga átang kungga sutna hára márapmá rina wa erek hánám sung hálinet. No wáina tánggoet wawu miti ámna náráwa wa háláng yámámáya tánggoet, wawu Jesu málámba sutná wa. ");
INSERT INTO klt_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Ánutu málámbá neháng tunggap tán du no Jesu yan ámna náráwa háláng yámámáyan yáup ámna háliut. Nákkán yáup wawu Ánutu yan me erek hánám sánáng tolinggoet wa. ");
INSERT INTO klt_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Málámbán me náwu Ánutu málámbá uláp pon táng kilak ting san rám hásák hánám átang áwuk, wáina hálendu ámna náráwa yá ma narená átkiuráng. Iná inggálu wawu Ánutu málámbáyon Jesu yan ámna náráwa rahán yáni hára me wa táng hiták tiuk. ");
INSERT INTO klt_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Ánutu yá málámbán pahán isutang gu me kilak átuk wa táng hiták tiuk. Me wawu álosim hánám watá ámna náráwa káwakngá káwakngá átamán wa kámuk hánám álo háláng náminek. Me wawu ing, Jesu Son Iháhá wawu pahán sáni kinan káin átak, wata ku watá sángot kung alek káin kutná kutná álosim tiyawing sámuk wa sáminek ka wata hálengga átkoeráng. ");
INSERT INTO klt_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Nándu pahán náni káin ing naránggoemán, ámna náráwa yá Jesu Son Iháhá wata naráng hákhátik hára káto hánám hálengga árát tu nándá yángot kung Ánutu rahálá hára tinemán. Wáina naránggoemán, wata ku nándá me pingnga álosim wa meng tunggap tángga ámna náráwa káman káman yánánggoemán. Wáina tángga ku ámna náráwa kámuk hánám rina kákámá ma tátáya mená yánángga nanará álosim Ánutu yá námená wa isutang yánáng tolinggoemán. ");
INSERT INTO klt_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Wáina wata ku no hánghálángngingga átang yáup wa tánggoet. Jesu Son Iháhá yá málámbán háláng táwi wa namánggoek wahára kungga ku wáina tánggoet. ");
INSERT INTO klt_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","No sándá ing narineráng ga naret, no sán me ámna náráwa it táwi Laodisia káin átaráng wa, me ámna náráwa kátu nák kurák mátapna ma naráráng wa háláng sásámáya hánghálángngingga átang yáup wa tánggoet. ");
INSERT INTO klt_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Yáup wa tánggoet wawu sán pahán sáni táng káto tátáya, me pahán sáni seng tárut táe Ánutu yan ámna náráwa kikiná kápángga pahán káman átnát wata. Sándá no me wa met wáina átang gu Ánutu yan me pingnga álosim wa kándáng hánám naráng rákit tángga wahára kungga ku iruk kán kálu kutná kutná álosim hulá hulá átaráng wa ihineráng. Wáina tángga ku Ánutu yan me kilakngá wata hulá wawu Jesu Son Iháhá wa ingga narineráng. ");
INSERT INTO klt_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Jesu Son Iháhá watá rewe ku álo háláng námán nanará álosim tángga Ánutu yan me maming tái álosim hánám wa kándáng hánám naráng rákit táinemán. ");
INSERT INTO klt_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Ámna kámá yá sángsárungingga me karo táng sámánirot ingga no me ná sánet. ");
INSERT INTO klt_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Nák ku sányot ma árat, enendu iruk kálu ku sányot há átat, hang sándá ket tárák álosim tángga naráng hákhátik sáni Jesu Son Iháhá hára káto hálengga átaráng wa met narángga heronge naráng sámánggoet. ");
INSERT INTO klt_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Wáina wata ku Jesu Son Iháhá wawu sáni Táwi náni ingga há táuráng, wata ku watyot emá re átkuineráng. ");
INSERT INTO klt_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Káráp pá káwak uminá pálak hára ráhulá kun áráng hengga átnándak wáinanyon du sándá Jesu hára káto hálengga átneráng. Me pingnga álosim sánuráng wahára káto yárengga árát tu naráng hákhátik sáni watá káto hálengga árán du Ánutu heronge me táwi hánám inángguineráng. ");
INSERT INTO klt_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Kándáng hánám háleng rákit tángga átneráng! Ámna kámá yá miti yan kálu nanará kusák me, me hánámá hánámá wa sánát tu sándá watán nanará wa ma isutnándaráng. Ámna wáinaná wawu Jesu Son Iháhá watán nanará ma isutnándaráng, ináku ámna nangge yan nanará yot káwak kán nanará wa isutnándaráng. ");
INSERT INTO klt_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Jesu Son Iháhá wawu ámna nangge hánám háliuk, ngáyá ku Ánutu málámbon. Ánutu málámbán káin nanará me háláng me átkuku rina átaráng watá wahára erek hánám átháleráng. ");
INSERT INTO klt_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Angelo me iruk hulá hulá átaráng me kutná kutná uliháláng yáni pálak átaráng wata yáin yáni ku málám wa rewe, iná sándu watyot tántápin há táuráng, wata ku Ánutu yá átkuku wa sámán du átkuku álosim watá sányot táwi hánám wa átang kuinek. ");
INSERT INTO klt_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Sándu Jesu yot ronrosin átang gu kep mamará watán hulá kándáng hánám nareráng. Wawu ámna yá ket yáni yá sándán káwak sut mamará hálengngátak wáina muná, ináku Jesu Son Iháhá watán yáup wahára kungga ku pahán kakngá wa yalingga táng san kuk hálek. Kep mamará wata hulá hánám bu wa. ");
INSERT INTO klt_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Jesu kutná hára umi kuhuráng rám wahára wu Jesu tanggán káin usuráng wáinanyon sándu Ánutu yá tanggán káin sáháng usuk ina hálek. Wáina tán du Ánutu yá kátkámut kálu wahára Jesu son táng tárut táuk wáinanyon du sándá watán háláng wata naráng hátinggoeráng wahára kungga ku Ánutu yá Jesu yot son sáháng tárut táuk ina hálek. ");
INSERT INTO klt_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Uláp pu sándu mukmuro hulá hulá wa tángga pahán kakngá wa isutang átkiuráng rám wahára wu há kámurená yá ina átkiuráng, enendu Ánutu málámbá tán sándu átkuku mirak wa tángga Jesu Son Iháhá watyot ronrosin átkoeráng. Ánutu yá mukmuro náni kámuk hánám wa yawonduk. ");
INSERT INTO klt_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Meng rákit me watá náháng me hára tingga mukmuro náni wa iháng hiták tin du nándá watán háláng wata tárang káin átkiumán, enendu Ánutu yá me retá náháng me hára titi wa yawondang gu meng rákit me watán háláng wa táng hang tingga táng Jesu yot maripong hára kátiuk. ");
INSERT INTO klt_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Jesu yá maripong hára kámutuk wahára kungga ku Ánutu yá iruk hulá hulá me kutná kutná háláng yáni pálak watán háláng wa rahán táwi hára iháng hang tingga táe ále hánám háleráng ingga táng hiták yáliuk. ");
INSERT INTO klt_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Wáina wata ku ámna kámá yá umi sungi nanayan meng rákit me, me miti yan kálu rám táwi kákápáyan meng rákit me, hang yap mirak kán rám me Sabat tán rám watán meng rákit me wa sándá ma isutkuráng ingga meng sámát watán me wa ma narindaráng. ");
INSERT INTO klt_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Ále meng rákit me wa meme hálek wawu yongnga rewe. Uláp Ánutu yá meng rákit me wa málámbán ámna náráwa yámuk wawu Jesu Son Iháhá yá máriya áwinek ingga wata tárákngá ya ku wa yámuk. Wata ku meng rákit me wata hulá hánám bu Jesu Son Iháhá málám. ");
INSERT INTO klt_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Iná ámna kámá yá kusák hára kungga yáni tángga hangga angelo yánáng sáknginggoeráng. Wáina tángga ku sándá wáinanyon há tániráng ingga wata sánánggoeráng. Sándá ámna wáinaná wa yápmat watá sángot kung ket tárák wáik wa tángga átang yumnak álosim Ánutu yá sásámáya tiyawing san átak wa ma ihánirot. Ámna wáinaná wawu ára rina kangngátaráng wahára yárengga átang gu náni wu kut náni pálak ingga narángngátaráng. Iruk Káungá watán nanará wa ma isurená náni wu nanará náni pálak ingga narángngátaráng, enendu nanará yáni wawu ále hánámá rewe. ");
INSERT INTO klt_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Wáina átang gu yáin náni Táwi Jesu wahára ma rosená átkungngátaráng. Káwak sut káman da yáilá yá átang gu sutná kátu wa háláng yámángga árán du ulin watá tán du sut seng kunkun táená wa iháng káto tángga átnándaráng. Wáinanyon du yáin náni Jesu watá málámbán ámna náráwa wa háláng yámángga árán du málámbot káman hánám átkoeráng. Wáina átang gu Ánutu yan háláng hára Jesu sutná watá tihangga kungga átkoek. ");
INSERT INTO klt_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Sándu Jesu Son Iháhá watyot há kámuturáng, wata ku káwak kán nanará wata tárang káin ma átnándaráng. Rina ta ku káwak ámna yá ina átninggoeráng? Rina ta ku me wáina isutneráng ingga meng rákit me kámá ing tená wa isutkoeráng, ");
INSERT INTO klt_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“Ma ihindalák, ma náindalák, ma ihánggápindalák”? ");
INSERT INTO klt_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Meng rákit me wáina watá ku káwak ketnán kutná kutná ku sopmuná wáik háleineráng wata rewe mek. Meng rákit me wáina wawu ámna yá re narát tunggafen du wáina isusut ta nánená, wata ku sándá wa ma isutnándaráng. ");
INSERT INTO klt_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Meng rákit me wáina wawu ing, miti yan kálu meng rákit mená hulá hulá, me kusák hára kungga yáni tángga haha, hang káwak sut hára kálu rina rina kandák táe Ánutu yá nahángga álosim naráng námik ingga tátá. Kámá yá ku me wáina wawu pálipuk nanará álosim ingga narángga átkoeráng, enendu me wáina watá háláng námán pahán kakngá yá ket tárák wáik táin ingga naránggoek wata hálángngá tángga hahayan tárák ku muná. ");
INSERT INTO klt_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ánutu yá Jesu Son Iháhá watyot kámurená háranan son sáháng tárut táuk, wata ku alek kán kutná kutná álosim wata pahán kinan hánám kikiná narángguineráng. Alek káin irawa wawu Jesu Son Iháhá watá Ánutu ketná álák kálu putung átkoek. ");
INSERT INTO klt_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Rámá rámá nanará sáni wu alek kán kutná kutná rina átaráng wata re nanará sáni kinan káin narángga átkuineráng. Iná sándá ku káwak kán kutná kutná rina rina átaráng wata ma narángga átkuindaráng. ");
INSERT INTO klt_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Sándán pahán kakngá wawu há kámurán du átkuku sáni wawu Jesu Son Iháhá watyot kilak árán Ánutu hára tápingga átkoeráng. ");
INSERT INTO klt_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Jesu Son Iháhá wawu átkuku sáni wata hulá, wata ku rám Jesu yá hiták háleinek wahára ku sándu watyot yamá hálángngá pálak wahára hányon hiták háleineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Wáina wata ku káwak kán ket tárák rina sányot átak wa erek yápmang hálineráng. Ket tárák ing wata met, márámamák, ket tárák reprepmá, pahán dá tárurán ket tárák kandák tátá, me há árán nukngá ya mekmek. Há árán nukngá ya mekmek wawu ánutu kusák ináng sákngená wáinanyon. ");
INSERT INTO klt_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Ket tárák kandák wáina táená wawu Ánutu yan milun yalingngátaráng, wata ku málámbán pahán káráp watá ihinek. ");
INSERT INTO klt_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Sándu uláp Jesu ya ma naráng háting muráng wahára wu ket tárák kandák wáina wa há tánggiuráng. ");
INSERT INTO klt_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Iná rám nahára ku ket tárák ing wa erek sang hálineráng, kuk tángmán tángmán, pahán káráp, ket tárák kandák kámá yáyále, mengmán mengmán me, me wáik meme. ");
INSERT INTO klt_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Me kusák nangge nuk sáni ya ma mengguindaráng, náuta sándu pahán kakngá isusut wawu há sáuráng. ");
INSERT INTO klt_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","Iná sándu ámna náráwa mirak há hálengga átninggoeráng. Ánutu málámbáyon tán mirak hálengga átkut rámá rámá málámba kándáng naráng mámá wa sámán átninggoeráng, hang málámbá tán málám inanyon hálengga átninggoeráng. ");
INSERT INTO klt_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Kulá nán ámna náráwa mirak háliumán wawu tárák káman re átninggoemán. Tombong Grik me tombong Juda háranan, kep marená me ma marená me, me kámá kámá káinnan, me káwak kámá kámá káinnan, me yáup nangge hánámá tirik tárák kán me yáup nangge muná along árená, wáina wawu kutná táwi ingga ma narindamán. Ináku kutná táwi hánám wawu Jesu Son Iháhá wa rewe, iná málám wawu nán kámuk ka kinan átak. ");
INSERT INTO klt_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Ánutu yá sándu nangán pingnga ingga sáháng há kankalingga ku sánda kikiná hánám naráng sámánggoek. Wáina wata ku sándu ket tárák ing wa tángga átneráng, kámá ya urák yáni narángga kándáng iháng totoli, sáni tángga haha, pahán yámámá, sopmuná pahán káráp ma tátá. ");
INSERT INTO klt_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Sándá nangge nuk sáni káman dá ket tárák káman tán wa kangga takta narángga hálen wata pahán káráp ma táng mindaráng, iná sándá ku wata pahán láláp táng mineráng. Hang sánda kandák káman táng sámán hálen wawu watán kátu wa sáineráng. Táwi yá sándán kátu wa sáuk, wata ku sándá wáinanyon nangge nuk sáni yan kátu wa sáineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Kámá kikiná kápineráng, watá ku ket tárák álosim kátu átaráng wa erek iháng hátingga ku wa iháng káto tán háláng yáni pálak átaráng. ");
INSERT INTO klt_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Sándu sut káman dá re ina átkoeráng, hang pahán káman átnát ta Ánutu yá mantáng sámuk, wata ku sat Jesu Son Iháhá watá pahán láláp sámánggoek watá ku pahán sáni pinná tángga átnek. Rámá rámá Ánutu heronge me inángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Jesu Son Iháhá watán me wa táng pahán sáni káin káto ting sat árán nangge nuk sáni wa rina kákámá ma tátáya mená wa yánángga ku nanará álosim watá sányot árán wa yánáng tolit tu watá ket tárák álosim wa rewe tángga átkuineráng. Pahán sáni káin Ánutu heronge me inángga ku Kap Papia káinnan, me miti kap waháranan, me Iruk Káungá yá pahán sáni káin kap rina sáminek wa mantáng kuineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Me rina mengguineráng, me yáup rina tángguineráng, me ket tárák kámuk rina tángguineráng wawu Táwi Jesu kutná hára rewe tángguineráng, hang Jesu kutná háranyon du Nan náni Ánutu heronge me inángguineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Náráwa sándu, nánáun sáni ya tárang káin átkuineráng, náuta kálu wáina watá ku Táwi rahálá hára kándáng hálek. ");
INSERT INTO klt_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Ámna sándu, áwáwá sáni wa kikiná kápángga ku pahán yáni táng wáik ma táindaráng. ");
INSERT INTO klt_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Nangge sándu, nan mam sáni tárang káin átang rina rina met milun yáni suwángga átkuineráng, náuta Táwi wawu ket tárák wáina wata heronge narek. ");
INSERT INTO klt_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Iná nanan yáni sándu, nángánangge sáni yá rina kákámá tát táup hánám ma yánáng seindaráng. Wáina tát pahán káráp tángga pahán yáni yá han ket tárák álosim ma tánggatnem ingga naránirot. ");
INSERT INTO klt_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Yáup nangge hánámá sándu, ámna hulá sáni tárang káin átang rina rina met milun yáni suwángga átneráng. Yáni sáhángga árát wahára re ku yáup álosim tátne ku ámna hulá náni yá náhángga álosim naráng námániráng ingga ma narindaráng, ináku rámá rámá wu yáup kándáng tánin ingga narángga yáup tángga átkuineráng. Jesu wawu Táwi náni ingga narángga ku sáni tángga hangga pahán yot hánám yáup táng yámángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Yáup rina rina wawu pahán yot hánám tángga átkuineráng. Yáup wa tángga átkuineráng wawu kat ámna háláng yámámáyan ina ma háleindak, ináku Táwi háláng imámáyan ina háleinek. ");
INSERT INTO klt_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Máriya Táwi yá wata yumnakngá sáminek wawu sáni há nareráng. Yumnak wawu alek kán kutná kutná álosim málámbán ámna náráwa watán da há tiyawingga ting san átaráng. Sándu Táwi Jesu Son Iháhá watán yáup nangge átang málámbán yáup wa tángga átkoeráng. ");
INSERT INTO klt_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Iná ámna niyá kandák táinek watá ku kandákngá wata yumnakngá táinek. Ánutu yá ámna náráwa yan me horengga narinek wawu tárák káman rewe. ");
INSERT INTO klt_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Sán niyá yáup nangge hánámá yan ámna hulá ya átaráng, sándá ket tárák álosim me kálu kándáng wa rewe yáup nangge sáni ya táng yámineráng. Náuta sáni ing há nareráng, Ámna Hulá náni alek káin hányon átak. ");
INSERT INTO klt_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Sáponga tángga átkuku yan kálu wa káto tángga átkuineráng, me kándáng narát kátin du sáponga tángga Ánutu heronge me inángguineráng. ");
INSERT INTO klt_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Ánutu yá nán háláng námángga kálu yalin nándá Jesu Son Iháhá watán me wa meng tunggap tátá wata hányon sáponga tángguineráng. Me wawu uláp pu kilak átkiuk, iná inggálu ku hiták hálengga átkoek. Ámna kámá yá me wa nanará wata taktak yámán du nák neháng kalabus kinan ting sat átkoet. ");
INSERT INTO klt_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Sándá ku sáponga hára háláng namát tu no Jesu yan me wa kándáng meng tunggap tángguinet, Ánutu yá no rina táinet ta narek wáina. ");
INSERT INTO klt_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Sándá ámna náráwa Jesu ya ma naráng háting mená watyot átneráng wahára wu nanará álosim wa tángga kálu kándáng wa re isutkuineráng. Rámá rámá Jesu Son Iháhá watán ket tárák álosim wa yáyále wata tiyawingga átningguineráng. Kándáng hánám átneráng, rám watá hánámá sálikngiwon. ");
INSERT INTO klt_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Ámna yá sungi hára táp tit tu sungi yá kikiningngátak wáinanyon du sándá rámá rámá ámna náráwa me yánánáya ku watá kikiná nanaráyan wahára me tángga átningguineráng. Wáina tát tu rám me pingnga álosim wata sánáng sulineráng wahára wu sándá ku kándáng álo há naráng rákit tángga ku me wata hurikngá kándáng yánineráng. ");
INSERT INTO klt_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Tikikus yá ku nákkán pingnga sáninek. Ámna watá ku nányot yáup káman tánggoemán wawu nánda nuk náni pánpáliná hánám. Málám wawu Táwi yan yáup ámna álo kámá. ");
INSERT INTO klt_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","No wa suring me áwinek wata hulá wawu nákáin rina átkoemán wa sásáná wata, hang sán pahán sáni táng káto tátá wata. ");
INSERT INTO klt_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Iná no Onesimus hányon suring me Tikikus yot wakáin kuinemálák. Onesimus wawu sáni hárananyon. Málám wawu nán nuk náni pánpáliná hánám, hang wawu Táwi yan yáup ámna álo kámá. Ámna yará watá ku nákáin rina tunggafenggoek wata pingnganá sáninemálák. ");
INSERT INTO klt_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristakus wawu nákkot kalabus kinan átnándamát watá káe álo ná san sándán káin koek. Iná Mak wawu Banabas yan sip kátu watá káe álo ná san sándán káin hányon koek. Iná watá sándán káin hányon áwán hálen du heronge hára kang meineráng, uláp wata ingga me há se sándán káin áwuk wáina. ");
INSERT INTO klt_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Hang ámna kutná Jesu kutná nukngá Jastus watá káe álo ná sándán káin hányon san koek. Tombong Juda háranan du ámna kaláhu watá re ku nák háláng namát Ánutu yan átkuku wata kinan rina átang átkuku wata mengga táng káto tánggoemán. Watá ku nák pahánna táng káto tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Epafras yá káe álo ná san sándán káin koek. Ámna wawu sáni hárananyon, hang Jesu Son Iháhá watán yáup ámna. Rámá rámá hánghálángngingga átang Ánutu yá sán háláng sásámáya sáponga tánggoek. Wáina háláng sámán du sándá naráng hákhátik hára káto hálengga átang gu Ánutu yá ket tárák álosim rina sándá tátáya narek wa kándáng hánám naráng rákit táineráng. ");
INSERT INTO klt_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","No pálipuk hánám ing sánin, ámna watá ku Kolosi sányot tu it táwi yará Laodisia me Hierapolis kinan Jesu ya naráng háting mená ámna náráwa sán háláng sásámáya yáupmá háláng hánám tánggoek. ");
INSERT INTO klt_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Hang nuk náni pánpáliná hánám dokta Luk watyot tu Demas watá káe álo yándi meng san sándán káin koek. ");
INSERT INTO klt_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Sándá nákkán káe álo wa táng kung yanuknukna Laodisia káin átaráng wa yánineráng, hang káe álo na wa táng kung yáup náráwa Nimfa yot miti ámna náráwa niyá watán it hára urum tángngátaráng wa yánineráng. ");
INSERT INTO klt_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Sándá papia ná há sángingga narángga sangga ku sat miti ámna náráwa Laodisia watán káin kun du watá hányon sángineráng. Iná papia no Laodisia yan da se kuk wawu sándá ku hányon sángingga narineráng. ");
INSERT INTO klt_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Iná Akipus wawu ing inineráng, yáup rina Táwi yá imán táuk wawu pukon táng hálinek, kátu ma sáindak. ");
INSERT INTO klt_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Nák Pol, no nayon ketna yá káe álo na ná uying sámet. Nák ku kalabus kinan re há átkoet, wata ku naráng háting namineráng. Ánutu yá pahán sámángguinek. ");
INSERT INTO klt_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Nák ku Pol yá Sailas káling Timoti yot átang no papia ná uye ku satne Jesu yan tombong it yáilá Tesalonaika hára átaráng sándán káin koek. Ámna náráwa sándu Nan Ánutu yot Táwi Jesu Son Iháhá wahára tápingga átkoeráng. Ánutu málámbá pahán sámán pahán láláp watá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Rám nándá sáponga tánggoemán wahára wu sánda narángga kut sáni mengga sáponga náni hára tingga rámá rámá Ánutu heronge me inánggoemán. ");
INSERT INTO klt_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Naráng hákhátik sáni yá sángorán ket tárák álosim tánggoeráng, nangge nuk sáni ya kikiná naráng yámánggoeráng watá sángorán yáup álosim tánggoeráng, me Táwi náni Jesu Son Iháhá watá son áwinek wata háleng mángga áwánggoeráng watá sángorán naráng hákhátik hára káto átkoeráng wata narángga nándá Nan náni Ánutu heronge me inánggoemán. ");
INSERT INTO klt_vpl VALUES ("H11_4","082_1_4","1TH","1","4","6","Yanuknuk, Ánutu yá sánda kikiná hánám naránggoek. Me pingnga álosim nándá sándán káin tángga áwumán wahára me hánámá yá ina ma áwuk, ináku háláng got tu Iruk Káungá watyot áwuk. Iná nándu me rina sánumán wawu pálipuk hánám ingga narángga ku sán sánátne nándán naráng hákhátik wa sáni há káuráng. Hang nándá sányot átang sáni háláng sásámáya ket tárák rina táumán wawu sáni há káuráng wa. Rám Jesu yan me watá sándán káin áwuk wahára wu sándá Iruk Káungá watá tán watán heronge hára me wa táuráng, wata ingga ku sándán káin márapmá hulá hulá watá tunggafeng sámuk, enendu sándá nándán ket tárák me Táwi yan ket tárák wanyon táuráng. Wa memán wa kápángga ku nándá naremán du sándu Ánutu yá málámbán pingnga ya há kankaliuk. Wáina wata ku Ánutu heronge me inánggoemán. ");
INSERT INTO klt_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Sándá wáina tát met narángga ku Jesu ya naráng háting mená Masedonia me Akaia provins káin átaráng watá sándán ket tárák álosim wanyon táuráng. ");
INSERT INTO klt_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Táwi yan me watá wáum manná yá ina yatná sungga kungga átuk. Iná man watá kuk wawu kungga Masedonia me Akaia kinan re ma kuk, ináku kungga it táup táwi káin kung hálin sándá Ánutu ya rina naráng háting mánggoeráng wata há naruráng, wata ku nándá sánda wáina ingga yánánáyan tárák muná. ");
INSERT INTO klt_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Yáni yon du nándá sándán káin kutne rina tunggafiuk wata pingnganá met naránggoemán, yáni yon du sándá ánutu kusák wa yápmangga pahán hurik tángga Ánutu pálipuk átkukuná pálak watán káin kungga watán yáup nangge háliuráng ingga met naránggoemán, ");
INSERT INTO klt_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","hang Nanggená kámurán son táng tárut táuk watá alek sangga son áwinek wata hákhálek tángga átkoeráng ingga met naránggoemán. Nanggená Jesu watá son náhuk, wata ku máriya Ánutu yan pahán káráp pá tunggafeinek hára wawu álo kámá re átnemán. ");
INSERT INTO klt_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Yanuknuk, nándá sányot átang yáup táumán watá hánámá ma háliuk ingga sáni há nareráng. ");
INSERT INTO klt_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Nándá sándán káin ma áwená it yáilá Filipai káin átumán wahára náháng lem tángga me keke nánuráng. Sáni há nareráng wáina, sándán káin áwumán hára wu káyam bá nándán me káting hang tiktik táwi táuráng, enendu Ánutu náni watá pahán náni táng káto táng námán ma pitáená káto hálengga átang Ánutu yan me pingnga álosim wa sándán káin miumán. ");
INSERT INTO klt_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Kulá nándá Jesu ya naráng háting mineráng ingga ámna náráwa yánángngátamán wahára me kandák kámá ma yánángngátamán, hang me kámá táng tingga wahára meng pilingga ma átningngátamán, me yángyárungingiya ma átningngátamán. ");
INSERT INTO klt_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Ánutu málámbá náhán kándáng hálen du yáup álo táineráng ingga narángga ku me pingnga álosim wa mengga kukuya yáup námuk. Nándá ku ámna náráwa yá nándán yáup wa kangga heronge naráng nánámáya yáup ma tánggumán. Ináku Ánutu málámbá pahán náni wa kangga heronge naráng náminek ka wata yáupmá tánggoemán. ");
INSERT INTO klt_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Sáni há nareráng wáina, nándá me karo kámá ma táng sámumán, hang nándá há árán nukngá ya nanará káluná wahára kungga sándán kutná kutná wa ihánin ingga ma sángsárungiumán. Rina rina táumán wawu kándáng re ingga Ánutu yá há narek. ");
INSERT INTO klt_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Nándá sándán káin me ámna náráwa kámá yan káin kut táwi tánin ingga wata yáupmá ma táumán. ");
INSERT INTO klt_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Nándu Jesu Son Iháhá watán aposel, wata ku nán kut náni meng tárut tániráng ingga narángga iná wu sánátne álo wáina tánggalát. Enendu wáina ma táumán, ináku rám sányot átumán wahára wu nangge maming gá nanggená isikimo pinná tángga átnándak wáina ina yolop náni hánám átumán. ");
INSERT INTO klt_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Nándá sánda kikiná táwi hánám narángga ku Ánutu yan me pingnga álosim wa sámánin ingga heronge rewe átumán. Hang sándá nán nuknuk náni hánám háliuráng, wata ku nándá kutná kutná náni kámuk hánám sán háláng sásámáya yápmanin ingga heronge rewe átumán. ");
INSERT INTO klt_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Yanuknuk, nándá sányot átang Ánutu yan me pingnga álosim wa sánumán wahára nánin átnát kálu rina átnát wata yáupmá táumán wawu sáni há nareráng wa. Sándá re háláng pin náni tánirot ingga ku wata káen me yáungán yáup háláng hánám tángga átkumán. ");
INSERT INTO klt_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Ámna náráwa Jesu ya naráng háting mená sányot átumán rám wahára nándá ket tárák rina táumán wawu sáni há nareráng me Ánutu yá hányon narek. Nándu Ánutu rahálá hára rongrongngá átang ket tárák kándáng wa rewe táumán, watá kandák kámá ma háliuk. ");
INSERT INTO klt_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Sáni há nareráng wáina, nan dá nángánanggená ya ket tárák rina tángngátak wáinanyon du nándá sán káman káman da táumán, ");
INSERT INTO klt_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","wahára ket tárák wata kinan du me sán sámáng rorosi watyot pahán sáni táng káto tátá wa sánángga átumán, hang sándá ket tárák álosim Ánutu yá rina átnát ta narek wa há hánám tángga átnát ta sánángga átumán. Ánutu yá mantáng sámángga átkoek wawu málámbán ámna náráwa pánpáliná hánám hálengga málámbán yamá sireretná pálak wata kinan árát málámbá pin sáni tángga átkuinek wata ingga mantáng sámánggoek. ");
INSERT INTO klt_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Sándá nán milun náni káinnan Ánutu yan me wa narángga táuráng wawu ámna yan me ina ma táuráng, ináku Ánutu yan me páliná ingga táuráng, wata nándá rámá rámá Ánutu heronge me hányon inánggoemán. Me watá ku niyá naráng hákhátik hára átaráng sánda pahán sáni káin átang yáup tángga átkoek. ");
INSERT INTO klt_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Yanuknuk, sándu miti ámna náráwa Judia ále káin átaráng wáinanyon háliuráng, ámna náráwa wakáin wawu Jesu Son Iháhá watyot ronrosin átaráng. Nuknuk sáni Táwi ya ma naráng háting mená watá márapmá sámuráng wáinanyon du Juda ámna kámá yá Judia ále káinnan ámna náráwa márapmá yámuráng. ");
INSERT INTO klt_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Juda ámna yá profet ráháng kátkámut táuráng me Táwi Jesu utkámut táuráng ngáyá hang nán hányon násurát kungngátamán. Wáina tát tu Ánutu yá takta kápángngátak. Ámna watá yon du ámna kámuk iháng káyam tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Ánutu yá ámna náráwa ále kámá káinnan wa son ihik ingga nándá watán káin me álosim wa mengga kunin ingga tánggoemán, enendu Ánutu yá wáina ma táindak ingga Juda ámna yá nándán kálu susuwá tánggoeráng. Wáina tángga ku mukmuro yáni wa ketnán ketnán tit maming táwi hálengga árángga kunggoek, wata ku Ánutu yan pahán káráp watá watyot há átak. ");
INSERT INTO klt_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Yanuknuk, Juda yá kandák tát nándá sán sápmangga kung mulangán káin rám hátetná kimo átang gu sán sásáháya kikiná naránggiumán. Kurák mátap sáni ma kanggiumán, enendu pahán náni wu sányot átkiuk. Nándá son áwángga sásáhá wata kikiná hánám narángga kálu ya háláng hánám sulinggiumán. ");
INSERT INTO klt_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Nándá sándán káin kunin ingga narángga no rám máro hánám kálu ya sulinggiut, enendu Satan dá kálu sung námánggiuk. ");
INSERT INTO klt_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Kulá rám Táwi náni Jesu yá son áwinek wahára wu náutá ku náháng káto tán du málámba rahálá hára átang heronge tángga átnemán? Náut ihángga ku kung Jesu elengga átang yáup náni kándáng táumán ingga ininemán? Wawu sán. Sándá naráng hákhátik hára káto hálengga átneráng ingga há naremán, wata ku rám wahára Jesu rahálá hára nándá heronge táinemán. ");
INSERT INTO klt_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Pálipuk, nándu sánda heronge táwi naránggoemán. Sándá tát tu nándá pahán láláp hára átkoemán. Hulá wata hánám bu nándá son áwángga sán sásáhá wata kikiná hánám naránggoemán. ");
INSERT INTO klt_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Nándá sándu rina átaráng ingga narángpak hánám tángga átang rám hásák ma táng uyindámán ing mengga ku nát tá Atens káin átang gu ");
INSERT INTO klt_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Timoti suring máte sándán káin kuk. Nuk náni Timoti wawu Ánutu yan yáup ámna Jesu Son Iháhá watán me pingnga álosim wa meng tunggap tátáyan ámna. Nát tá wa suring mumát wawu sán sáháng káto tángga sándán naráng hákhátik wa háláng imámá wata. ");
INSERT INTO klt_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Márapmá rina sunggoeráng watá tán naráng hákhátik sáni yá háiwon, wata ku wáina táumát. Sáni ing há nareráng wa, Ánutu yá márapmá wáina suwineráng ingga mantáng námuk. ");
INSERT INTO klt_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Nándá sányot átang gu márapmá hulá hulá watá náhinek ingga há sánánggiumán. Rina sánánggiumán wawu wa tunggafenggoek wa ingga há kangga naránggoeráng. ");
INSERT INTO klt_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Hulá wata hánám bu narángpak na watá táwi hánám háliuk, hang no sándá rina átaráng ingga nanaráya ma háleindát ingga narut. Wáina wata ku no sándán naráng hákhátik wata Timoti yá men nanaráya ingga suring me sándán káin kuk. Satan dá sángsárungin nándán yáup watá páliná muná hánámá háleiwon ingga naránggiut. ");
INSERT INTO klt_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Iná Timoti wu sán sápmangga áwuk watá nákáin áwángga sándá naráng hákhátik hára rina átang kámá ya narát kikiná hálen átninggoeráng wata me pingnga sáni álosim nánuk. Hang sándá nánda narángga pahán álosim naráng námánggoeráng, me sándá inam náni nánáháya kikiná hánám naránggoeráng, wáinanyon du nándá inam sáni sásáháya kikiná hánám naránggoemán ingga nánuk. ");
INSERT INTO klt_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Yanuknuk, sándu naráng hákhátik hára káto hánám átaráng ingga pingnga sáni narumán wahára wu me pingnga sáni watá ku márapmá rina suwánggoemán wata pahán náni táng káto táng námánggoek. ");
INSERT INTO klt_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Sándá Táwi yot ronrosin tángga káto hánám átaráng wa narángga ku pahán náni me sut náni yá láláwingga átak. ");
INSERT INTO klt_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Rám nándá sáponga tánggoemán wahára wu sánda Ánutu heronge me inánggoemán, náuta sándán pingnga wa naráng hátingga ku wata heronge táwi hánám wa naráng sámánggoemán. Heronge ná Ánutu yá námánggoek wawu táwi hánám, enendu nándá Ánutu heronge me rina inánggoemán wawu watán tárák muná isikimo rewe. ");
INSERT INTO klt_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Káen yáungán pahán yot sáponga hára re átkoemán wawu Ánutu yá naráng námán kungga sán sáhánin ingga wata, hang sándán káin naráng hákhátik kálu kesákngá kámá átak hálendu nándá wáina kungga ku táng káto táinemán wata. ");
INSERT INTO klt_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Nándá sáponga tánggoemán wawu Nan náni Ánutu yot Táwi náni Jesu watá kálu sareng námán sándán káin kuinemán ingga wata. ");
INSERT INTO klt_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Táwi Jesu málámbá tán málámbán ámna náráwa wata narát kikiná háhále watá sándán káin káto hánám átnek, hang nándá sán pahán sámánggoemán wáinanyon sáni káman káman dá Ánutu yan ámna náráwa me ámna náráwa kámuk wa pahán yámineráng ga sáponga tánggoemán. ");
INSERT INTO klt_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Kálu wahára ku Ánutu yá pahán sáni táng káto tán árát tu rám Táwi náni Jesu yá rongrongngá árená yot son áwineráng, wahára wu rongrongngá kándáng re Nan náni Ánutu rahálá hára átneráng. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Yanuknuk, me pukon du ing sánin, ket tárák rina tángga árát Ánutu yá álosim sáhinek ingga há sánáng toliumán wáina hánám isutang tánggoeráng. Kula rina tánggoeráng wa emá re tángga árát táwi hánám hálengga kuinek ingga wata Táwi Jesu kutná hára sánángga sáháng káto táemán. ");
INSERT INTO klt_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Me rina rina Táwi Jesu málámbá námán sánumán wawu há nareráng wáina. ");
INSERT INTO klt_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Ánutu yan pahán káin wawu sándá málámbán ámna náráwa hánám átang kándáng hánám ing átneráng, márámamák ma táindaráng, ");
INSERT INTO klt_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","hang sáni káman káman dá sut sáni kándáng pinná tángga ku ket tárák rongrongngá ámna náráwa yá álosim ingga kangga meng tolineráng wa rewe tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Nanará kandák ká sángorán kung Ánutu ma naráng mená yá ina márámamák tánirot. ");
INSERT INTO klt_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Nuknuk sáni Jesu naráng mená kámá yángyárungingga kálu hitik tángga kung wata áwáwá yáni me nánáun yáni yot márámamák tánirot. Káman niyá kálu wáina táinek wawu Táwi yá márapmá iminek ingga uláp há sánáng rákit táumán. ");
INSERT INTO klt_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ánutu yá kálu kandák wáina wa tátáya ma mantáng námuk, ináku Ánutu yá nándá káungá átang átkuku wata ingga mantáng námuk. ");
INSERT INTO klt_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Kulá káman niyá me náta taktak minek wawu ámna yan me ya ma taktak mindák, ináku Ánutu málámbá málámbán Iruk Káungá sámánggoek watán me wata taktak minek. ");
INSERT INTO klt_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Kulá nuknuk sáni Jesu naráng háting mená wa pahán yámineráng ingga no papia kámá ma uying sámindát, náuta Ánutu yá kálu wáina isutneráng ingga wu há sánáng toliuk. ");
INSERT INTO klt_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Pálipuk hánám, sándá nuknuk sáni Jesu naráng háting mená Masedonia provins káin átaráng wa pahán há yámángngátaráng, enendu, yanuknuk, sáháng káto tátne ku ket tárák wáina wa emá re tángga árát táwi hánám hálengga kuinek ingga wata sánángga sáháng káto táemán. ");
INSERT INTO klt_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Sáni yolop átang gu kámá yan yáup me márapmá wata márumá ma hálená ket sáni yá sánin yáup rina rina wa tát tu watá yon sáni háláng sáminek ka uláp sánumán wa rewe káto tángga isutang átneráng. ");
INSERT INTO klt_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Wáina tángga átang gu rámá rámá kutná kutná ya kesák tángga kámá yan háláng hára ma átnándaráng. Wáina átneráng wahára wu ámna ni Jesu ma naráng háting mená watá sáhángga ku álosim narineráng. ");
INSERT INTO klt_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Yanuknuk, ámna náráwa há kámurená átaráng watán káin rina tunggafeng yáminek, wata sándá kándáng ing naráng yámineráng ga naremán. Ámna náráwa kámá yá Ánutu ya ma naráng háting mángngátaráng me tanggán káin tátárut wata narát kusák hálengngátak watá nuk yáni káman dá kámurán du ukuro maming táwi tángngátaráng. Iná sándá ku watá ina ma táindaráng. ");
INSERT INTO klt_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Jesu yá kámurená háranan son tárutuk wawu pálipuk ingga naránggoemán, wata ku Ánutu yá ni Jesu naráng háting mángga átang kámuturáng wa iháng tárut tán Jesu yot son áwineráng wawu pálipuk ingga naránggoemán. ");
INSERT INTO klt_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Táwi yá me rina miuk wanyon ing sánindemán, rám Táwi yá son áwinek wahára wu nán ma kámurená nándá kálak kámurená wata máta yáreng yámángga árángga kungga Jesu ma káindámán. ");
INSERT INTO klt_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Man káman dá hahatingga hálángngá pálak mantán angelo máta yáyáre watá mená metán Ánutu yan támun watá mantáinek, waháranyon du Táwi yá alek sangga han, niyá Jesu Son Iháhá wata naráng háting mángga átang kámuturáng watá kálak tárutneráng. ");
INSERT INTO klt_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Wata torong hára ku ámna náráwa ma kámurená há átamán wawu árángga mukam kinan ámna náráwa kámutang tárurená watyot kungga alek táitná ále páliná muná wahára Táwi yot kankan tángga ku kungga rámá rámá watyot átkuinemán. ");
INSERT INTO klt_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Wáina wata ku sándá me ná Jesu yan ámna náráwa nukngá átaráng wa yánángga ku iháng káto tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Kulá, yanuknuk, nándá rám rina hára watá wáina tunggafeinek ingga sásánáyan wawu muná. ");
INSERT INTO klt_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Sáni há nareráng wáina, Táwi yá áwáwáyan rám wawu manek mara yá yáungán áwángngátaráng wáinanyon áwinek. ");
INSERT INTO klt_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Ámna náráwa yá ing meineráng, “Kula wu rám álosim hánám,” wáina mengga átneráng wahára wu rám wáik watá watán káin tunggafengga iháng lem táinek, wawu náráwa yá kawin átang nangge iháháya láwit narángngátaráng wáina watá sopmuná hánám ámna náráwa watán káin tunggafen watá wa táng háhátiyan káluná yá ma tunggafeindák. ");
INSERT INTO klt_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Iná yanuknuk sándu páyung kinan ma áraráng, wata ku rám watá tunggafen kangga káman dá manek mara kápángga hárámutgim wáina ma hárámutnándaráng. ");
INSERT INTO klt_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Sándu erek yamá me haknga wata nángánangge. Nán me sán kámuk náni wu páyung me yángomá watán muná. ");
INSERT INTO klt_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Wáina wata ku ámna náráwa kámá yá ruhángga átaráng wáinanyon ruhángga átninggom. Ináku náni wu rahán náni hálengga nanará náni yá ruwarán átang náni ya pin náni kándáng tángga átnemán. ");
INSERT INTO klt_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Há naremán wáina, yáungán du ruháháyan rám, hang ámna umi káto nat ip ráháháyan watá yáungán umi káto nat ip ráhán átnándaráng. ");
INSERT INTO klt_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Iná nándu haknga yan, wata ku nanará náni yá ruwarán átang Jesu ya naráng háting mámá me kámá ya kikiná nanará wa iháng siot káto ya mondang átnemán, me Ánutu yá son náhinek wawu pálipuk ingga narángga ku wata hálengga átnát wa táng at káto ya usángga átnemán. ");
INSERT INTO klt_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Ánutu yá málámbán pahán káráp wa kakaya ma náháng tunggap táuk. Watá náháng tunggap táuk wawu Táwi náni Jesu Son Iháhá watá son náhinek wata ingga náháng tunggap táuk. ");
INSERT INTO klt_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Jesu wu nán háláng námámá wata kámutuk, wata ku kámutnemán me átnemán wawu málámbán átkuku wa tángga málámbot átnemán. ");
INSERT INTO klt_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Wáina wata ku sándá Jesu yan ámna náráwa wa pahán yáni táng káto tángga háláng yámát naráng hákhátik yáni yá káto háleinek. Wa tánggoeráng wáina re tángga átang átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Kulá, yanuknuk, nándá ing sánánin, ámna yáilá ingga átaráng wawu yáup háláng hánám tángga Táwi ya naráng háting mámá kálu pin sáni tángga sándán átkuku wa táng tolingga átkoeráng, wáina wata ku sándá wata kekendik táng yámángga ku meng toling yámineráng. ");
INSERT INTO klt_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Sándu watá yáup rina tánggoeráng wata narángga pahán yámángga meng toling yámángga kikiná kápineráng. Iná sáni wu pahán káman re átang átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Yanuknuk, sándá ku ámna niyá yáup tátáya taktak yámán hánámá átninggoeráng wa yánát tu ket tárák wa sangga yáup táineráng, me pitángga átninggoeráng wa pahán yáni táng káto táineráng, me naráng hákhátik yáni káto ma áraráng wa háláng yámineráng. Wáina há táineráng ingga wata pahán sáni táng tárut táemán. Yolopon átang ámna náráwa wa kámuk wáina re táng yámineráng. ");
INSERT INTO klt_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Ámna kámá yá sáháng wáik tát hálen wawu wata topmá wáinanyon ma táindaráng. Sán háranan káman dá wáina táinán tán du sándá ku wata topmá ma táindalák ingga inineráng. Rámá rámá wu káto hálengga átang Ánutu yan ámna náráwa me ámna náráwa kámá wa kámuk ket tárák álosim wa táng yámineráng. ");
INSERT INTO klt_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Rámá rámá heronge rewe átang ");
INSERT INTO klt_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","sáponga tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Kálu rina rina tunggafeng sámán kangga ku Ánutu heronge me inángguineráng. Ámna náráwa niyá Jesu Son Iháhá watyot ronrosin átaráng watá wáina hánám wa tángga átneráng ga Ánutu yá narek. ");
INSERT INTO klt_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Iruk Káungá watá rina tátáya pahán sáni táng tárut tán wawu sándá wa oletná ma táng mindaráng. Wáina táineráng wawu Iruk Káungá yá káráp sinek wa káting kámut táineráng. ");
INSERT INTO klt_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Ámna káman dá profet me sánán du sándá wata pahán kandák ma naráng mindaráng. ");
INSERT INTO klt_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Ináku me rina rina sáninek wa kándáng kangga naráng rákit tángga ku me páliná rina meinek wa káto táineráng. ");
INSERT INTO klt_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Wáina tángga wáik ku rina wa kangga táng hátineráng. ");
INSERT INTO klt_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Nándá Ánutu yá ing táng sámámáya naremán, Ánutu pahán láláp márumá málámbáyon tán du sándá káungá hánám háleineráng. Wáina hálet iruk sáni yot sut sáni wa pin yándi kándáng tángga árán kungga Táwi náni Jesu Son Iháhá watá áwinek, wahára sáhán kandák kámá ma háleindák. ");
INSERT INTO klt_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Ánutu mantáng sámuk watá me rina miuk wáina hánám há isutnándak, wata ku wáina táng sáminek. ");
INSERT INTO klt_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Yanuknuk, sándá Ánutu yan káin sáponga tát tu watá nán háláng náminek. ");
INSERT INTO klt_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Nuknuk sáni yot kankan tángguineráng hára wu nuknuk sáni ya heronge táng yáminán du ket yánin tángga kápáng kumeineráng. ");
INSERT INTO klt_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Ing hánám há táineráng ingga Táwi kutná hára sánindet, papia náwu táng Ánutu yan ámna náráwa ingga átaráng wata kámuk hánám sánging yámineráng. ");
INSERT INTO klt_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Táwi náni Jesu Son Iháhá watá pahán sáminek. ");
INSERT INTO klt_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Nák ku Pol yá Sailas káling Timoti yot átang no papia ná uye ku satne Jesu yan tombong it yáilá Tesalonaika hára átaráng sándán káin áwek. Ámna náráwa sándu Nan náni Ánutu yot Táwi Jesu Son Iháhá wahára tápingga átkoeráng. ");
INSERT INTO klt_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Nan náni Ánutu yot Táwi Jesu Son Iháhá watá pahán sámán pahán láláp watá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Yanuknuk, nándu rámá rámá sánda narángga Ánutu heronge me inánggoemán. Nándá wáina tánggoemán wawu álosim, náuta sándán naráng hákhátik watá táwi hálengga kunggoek, hang sán káman káman kámuk sáni Jesu yan tombong kápát kikiná háhále kálu watá táwi hálengga átkoek wata. ");
INSERT INTO klt_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Hulá wata hánám bu nándá it kámá káin Ánutu yan tombong gá átaráng wakáin kunggoemán wahára wu sánda meng toling sámánggoemán. Ámna náráwa yá rina sáháng wáik tángngátaráng me sándá márapmá rina suwángngátaráng, enendu sándá káto hálengga naráng hákhátik hára átnándaráng wata ingga yánánggoemán. ");
INSERT INTO klt_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Márapmá rina sán hára tunggafen káto hálengga átkoeráng wata ku Ánutu yá kálu kándáng re isutang ámna náráwa kámuk kán me horengga narinek ingga naremán. Sándá Ánutu yan átkuku wa táng tárut tánggoeráng, wata ku wata ingga márapmá hányon suwánggoeráng. Wáina wata ku sándu Ánutu yan átkuku wata kinan álo átnát tán tárák hánám ingga Ánutu málámbá minek. ");
INSERT INTO klt_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Ánutu yá kálu kándáng táinek wawu ing, niyá márapmá sán sámánggoeráng wa wáinanyon márapmá yámángga ku ");
INSERT INTO klt_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","sán hára márapmá rina tunggafenggoek wa tán sálin du sándá ku sek narineráng, iná nándu wáinanyon sek narinemán. Ánutu yá wáina táinek wawu Táwi Jesu yá káráp lánggop pot angeloná háláng yáni pálak watyot alek sangga hiták háleineráng rám wahára. ");
INSERT INTO klt_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Rám wahára ku ámna niyá Ánutu ya ma naráng háting mená átninggoeráng me Táwi náni Jesu yan me pingnga álosim wa ma isurená átninggoeráng wata Jesu yá iháng lem táinek. ");
INSERT INTO klt_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ámna watá márapmá suwineráng wawu ing, yáni wu Táwi yamá yot hálángngá táwi wa ma káindáráng, ináku Táwi yot átnát tán wa pukon yásurán kung mulangán átang gu rámá rámá wáik hálengga átneráng. ");
INSERT INTO klt_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Kulá Táwi yá áwinek wawu málámbán ámna náráwa ni málámba naráng háting mená watá kangga ku málámbán ámna náráwa iháng álolo tánggoek wata narángga málámba kutná meng tárut tángga Táwi yá rina tánggoek wa kangga nangnga yáni háinek ka watá áwinek. Iná sáni wu wáinanyon watyot átneráng, náuta nándá me rina sánumán wa narángga káto há tángga isutang átninggoeráng wata. ");
INSERT INTO klt_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Nándá wáina tunggafeinek wata narángga ku Ánutu náni yá háláng sásámáya sáponga táng sámánggoemán. Sándá átkuku álosim tátáya mantáng sámuk, wata ku sáhángga álo táineráng ingga meinek wata sáponga tángga inánggoemán. Málámbá háláng sámán naráng hákhátik sáni isutang álosim rina tátáya narángngátaráng wáina há táineráng wata ingga ku inánggoemán. ");
INSERT INTO klt_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Wáina inánggoemán wawu ámna náráwa nukngá yá Táwi yá sán rina sáháng álolo tánggoek wa kangga Táwi náni Jesu kutná meng tárut táineráng ga ku Táwi yá wáinanyon sán kut sáni meng tárut táinek. Ánutu náni yot Táwi Jesu Son Iháhá watá pahán sámángga rina sánemán wa tán sándán káin tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Kulá, yanuknuk, Táwi náni Jesu Son Iháhá watá son áwán náni watyot urum átnemán wata sánindemán, wata ku kándáng narineráng. ");
INSERT INTO klt_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Táwi yan rám bu há tunggafiuk ingga kámá yá sánát naránggoeráng, enendu hárámutang wata narát ma márawindak. Iná ámna káman dá ing meinek, “Iruk Káungá yá ing nanek, rám bu há tunggafiuk,” me ámna káman dá wáina met narut ingga meinek, me ámna káman dá ku nándá papia uyingga kungga ku me wáina wata kinan uyiumán ingga meinek, enendu me wawu kusák rewe, wata ku sándá wa narángga sokmuná hárámutang narát ma márawindak. ");
INSERT INTO klt_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Ámna káman dá me wáina mengga ma sángsárungindak. Rám watá hánámá ma tunggafeindák, ináku hulátingga ku ámna náráwa táup hánám watá árená tángga Ánutu sárum imineráng watyot Milun Yayali Ámna watá hiták háleinek. Iná ámna wawu Táwi yá káráp lánggop pán pingnga ingga há táng tiuk, wata ku wakáin pukon muná kuinek. ");
INSERT INTO klt_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Ámna watá ku ámna náráwa yá ánutu kusák yánáng sákngingngátaráng wa, me Ánutu ni pálipuk wa, iháng káyam tángga málámba kutná táng tárut tángga rina rina menggoeráng wa iháng hang tinek. Wáina tángga ku Ánutu yan it káungá hánám kinan wa kung hang kome tángga átang gu ing meinek, “Nák ku Ánutu.” ");
INSERT INTO klt_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","No rám sányot átut wahára wu wáina wata ku há sánánggiut, enendu kalot sámuk hám? ");
INSERT INTO klt_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Sándu rám nahára náutá Milun Yayali Ámna wa kik tángga árán watá hiták ma hálengguk wawu há nareráng. Ánutu yá rám ting muk wahára ku wáina watá hiták háleinek. ");
INSERT INTO klt_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Rám nahára wu milun yayaliyan háláng watá kilak há yáup tángga árán ámna náráwa yá Ánutu yan meng rákit me wa yalinggoeráng. Wawu kilak wáina re árán kungga niyá Milun Yayali Ámna wa kik tángga átnándak wa Ánutu yá yaling mán du ");
INSERT INTO klt_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Milun Yayali Ámna watá hiták háleinek. Hiták hálengga átang árongga árán du máriya ku Táwi Jesu yá yamá táwi watyot áwángga ku máta mulá yáre Milun Yayali Ámna táng lem tángga yamá watá yon tán du muná kuinek. ");
INSERT INTO klt_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Kulá Milun Yayali Ámna yá hiták hálengga átnek wahára wu Satan dán háláng hára ket tárák hulá kákámá hálángngá pálak hánám wáina táinek, enendu wawu kusák rewe. ");
INSERT INTO klt_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Wáina tángga ku niyá muná kukuyan kálu hára há átaráng wa ket tárák wáik hulá hulá wahára yángyárungingga ihinek. Muná kukuyan kálu hára átaráng wawu Ánutu yá me páliná wa yánángga ku son iháháya táuk, enendu watá me wa narángga átkuku álosim wa tátáya takta naruráng. ");
INSERT INTO klt_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Hulá wáina wata ku Ánutu yá nanará yáni wa táng yawák táwi hánám tán du watá me kusák wa me páliná ingga kangga isutkoeráng. ");
INSERT INTO klt_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Ámna niyá me páliná wata narát ále hánám hálen kálu kandák wa isusut wata heronge tánggoeráng wawu kámuk Ánutu rahálá hára, me hára átang kandák yáni watán márapmá ihineráng. ");
INSERT INTO klt_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Kulá, yanuknuk, Táwi yá sánda kikiná naránggoek. Nándá sánda narángga ku Ánutu heronge me inánggoemán. Nándá wáina tánggoemán wawu álosim, náuta málámbá hulátitiná káin yon son sáhinek ka há sáháng kankaliuk, hang me páliná wata narát pálipuk háliuk me Iruk Káungá watá tán rongrongngá hálenggoeráng, wahára kungga ku Ánutu yá son sáhuk. ");
INSERT INTO klt_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Ánutu yá wáina watá sándán káin tunggafefeya há naruk, wáina hálendu málámbáyon nán suring námán kung me pingnga álosim wa sánumán. Wahára kungga ku Ánutu yá mantáng sámuk wawu sándá Táwi náni Jesu Son Iháhá watán yamá me háláng wata kinan átkuineráng wata. ");
INSERT INTO klt_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Wáina wata ku, yanuknuk, káto hálengga átang Ánutu yan me rina sánáng tolingngátamán wa narineráng. Me hára mengga sánumán me papia hára uyingga sámánggoemán wa naráng hátingga isutang átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Nan náni Ánutu yá kikiná naráng námángga ku pahán námánggoek wahára kungga ku háláng námán rámá rámá káto átang Ánutu yá náháng álolo táinek wata hálengga átkoemán. Ánutu yot Táwi náni Jesu Son Iháhá watá pahán sáni táng káto táng sámángga háláng sámán kálu kándáng isutang me álosim re mengga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Yanuknuk, me pukon du ing sánindemán, sándá sáponga tángga Ánutu inát háláng námán du nándá Táwi yan me pingnga wa meng isurátne itná itná káin sokmuná kungga táwi hálinek, sán orek sáni káin táwi háliuk wáinanyon. ");
INSERT INTO klt_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Ámna náráwa táup hánám bu naráng hákhátik yáni Jesu hára ma áraráng, wata ku Ánutu yan káin sáponga tát tu málámbá ámna wáik hánám wata ket yáni háranan náhinek. ");
INSERT INTO klt_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Iná Táwi wu me rina mengngátak wawu kándáng hánám isutnándak. Wata ku málámbá sáháng káto tángga pin sáni tángga árán ámna wáik Satan watá sán hára rina kámá kámá ma táindák. ");
INSERT INTO klt_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Táwi málámbá tán nándá kándáng hánám ing há naremán, sándu nándá rina tátáya sánánggoemán wa há tángga átkoeráng, hang máriya wu wáina re tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Táwi málámbá pahán sáni wa táng tolingga árán du sándá Ánutu yá ámna náráwa ya narán kikiná háhále wa ingga narineráng. Hang Jesu Son Iháhá yá káto hálengga márapmá rina suwuk sándá tárák wáinanyon suwineráng wáina sáponga táng sámánggoemán. ");
INSERT INTO klt_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Yanuknuk, Táwi náni Jesu Son Iháhá wata kutná hára nándá ing sánindemán, nuknuk sáni kámá yá hánámá átang me rina sánumán wa ma isutnándáráng, wawu sándá ámna náráwa wáinaná wa yápmangga kung mulangán átneráng, ");
INSERT INTO klt_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","náuta sáni há nareráng wa, nándá sáni yot átang ket tárák rina tátne náhuráng sándá ku wáinanyon tángguineráng. Nándá sányot átumán wahára táng taktak kámá ma táumán, ");
INSERT INTO klt_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","me sándán sungi káman hánámá ma náumán, ináku yungga yon du nanggiumán. Nándá káen me yáungán yáup háláng hánám wáina tánggiumán wawu sán márapmá sámáninggom ingga wata. ");
INSERT INTO klt_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Nándá wáina tánggiumán wawu sándá kutná kutná námát nándá ma iháháya muná, ináku nándu Táwi yan yáup ámna wata ku sándá há háláng námát ihátne kándáng hálenggim, enendu kálu álosim wáina átak ingga sán sáletne sándá wáinanyon isusut, wata ku wáina tánggiumán. ");
INSERT INTO klt_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Nándá sáni yot há átumán wahára me káto ing mengga sánángga átkiumán, káman dá yáup ma táindák wawu sungi ma ihángga náindák. ");
INSERT INTO klt_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Wáina sánángga átkiumán enendu inggálu wu sán háranan kámá wu yáup ma táená hánámá yáni átkoeráng ingga met naremán. Yáni wu hánámá átang kámá yan kutná kutná wata mená tángga átkoeráng. ");
INSERT INTO klt_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Kulá Táwi Jesu Son Iháhá wata kutná hára nándá ámna niyá hánámá átkoeráng wa me káto ing mengga sánindemán, ket tárák wáik wáina wa sangga kándáng átang yáup tángga átneráng ga ku sungi sáni kangga nangga watá háláng sámán átneráng. ");
INSERT INTO klt_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Yanuknuk, iná sándá ku ket tárák álosim wa tátáya ma taktak sámindak. ");
INSERT INTO klt_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ámna kámá yá nándá papia hára me ná uyingga satne áwek wa ma isurát hálendu miti ámna náráwa rahán yáni hára ámna ku wa ingga mengga yápmang kung mulangán árát sáhángga ku yáni rina táená wata reprepmá narineráng. ");
INSERT INTO klt_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Sándá nuknuk sáni wa káyam sáni ina kákápáya ma sánámán, ináku nangge nuk sáni ina kápángga ku kandák yáni wa re iháng totoliya me yánineráng ga sánemán. ");
INSERT INTO klt_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Táwi pahán láláp márumá málámbá tán kutná kutná kámuk hára rámá rámá pahán láláp hára re átneráng. Táwi yá rámá rámá sán kámuk kot átkuinek. ");
INSERT INTO klt_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Nák Pol no nayon ketna yá kolem ná uyingga káe álo ing sánet. No papia uyingngátat hára wu me tárákngá ing rewe uyená kangngátaráng wawu no na hánám papia ná se áwek ingga káineráng wata ingga tángngátat. ");
INSERT INTO klt_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Táwi náni Jesu Son Iháhá yá sán kámuk pahán sáminek. ");
INSERT INTO klt_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Nák ku Pol, Jesu Son Iháhá watán aposel. Ánutu son nánáhá watyot tu Jesu Son Iháhá watá yándi neháng tunggap tán aposel háliut. Nándá Jesu Son Iháhá yá náháng álolo táinek ingga há narángga ku wata háleng mángga átkoemán. ");
INSERT INTO klt_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Timoti, no papia ná uyingga se kákkán da áwek. Kák ku Jesu Son Iháhá wata naráng háting mánggoelák wata hánám bu kák ku nák nanggena ina átalák. Nan náni Ánutu watyot Táwi náni Jesu Son Iháhá watá urákka narángga pahán kamán pahán láláp hára átnelák. ");
INSERT INTO klt_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Uláp Masedonia provins káin kuin ingga me rina kanut wáinanyon ing kanindet, ko it yáilá Efesus káin átang ámna kámá Ánutu yan me mengga ámna náráwa me kusák watyot yánáng tolingngátaráng wa wáina ma tátáya áráng hákhátikngá tángga átnelák. ");
INSERT INTO klt_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Hang wa yánátá ku uláp pán me pingnga hánámá hánámá tánggoeráng me táwi ilom yáni kut yáni wata ingga mengga kunggoeráng wa sáineráng. Me wáina watá tán du menmen tángga honhoren tánggoeráng. Me wáina watá Ánutu yan yáup rina tátáyan wa ma háláng mindák. Ináku naráng hákhátik ká ku Ánutu yan yáup wa háláng iminek. ");
INSERT INTO klt_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Me wawu hulá ing wata kanet, kámá ya kikiná narángmán narángmán tátá watá táwi hálengga kuinek wata ingga kanet. Jesu ya pálipuk hánám naráng háting mámá, pahán rongrongngá átnát, me náni ket tárák rina táinemán wa narátne kándáng háhále, kálu wáina watá háláng yámán du kámá kápát kikiná háleinek. ");
INSERT INTO klt_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Ámna kámá wu ket tárák wáina wa sangga me hánámá hánámá wahára re hangga átninggoeráng. ");
INSERT INTO klt_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Yáni wu Ánutu yá meng rákit mená Moses imuk watán tiksa háháleya naránggoeráng, hang me náni wu pálipuk rewe ingga naránggoeráng. Enendu yáni wu me rina menggoeráng wata hulá wawu wáina ingga ma narángguráng. ");
INSERT INTO klt_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Há naremán wáina, Ánutu yan meng rákit me wawu álo kámá re átnek, rám tiksa yá kándáng re yánáng tolineráng wahára. ");
INSERT INTO klt_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Hang ing hányon naremán wáina, Ánutu yá meng rákit mená wa námuk wawu ámna náráwa ni kándáng há átaráng wa ma iháng totoliya. Ináku wawu niyá kálu hitik táená, ámna yáilá yáni me nan mam yáni tárang káin ma árená, Ánutu sárum imená, mukmuro táená, Ánutu yan ket tárák álosim wa sangga káwak kán nanará isurená, nan mam yáni me ámna kámá ráháng kátkámut táená wa iháng totoliya. ");
INSERT INTO klt_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Hang márámamák táená, ámna yá ámna yot átninggoená, náráwa yá náráwa yot átninggoená, ámna manek ihángga iháng yáup nangge yáni ya tená, me kusák mená, me hára átnát tán rám hára me kusák mená, me káman niyá me páliná wa táng káyam táená wa iháng totoliya. ");
INSERT INTO klt_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Me páliná náwu me pingnga álosim Ánutu yá meng tunggap tángga ámna náráwa yánánáya namuk wáinanyon. Me pingnga álosim watá ku ing nánánggoek, Ánutu wawu kutná táwi hánám yamá yot hálángngá táwi wata kinan átkoek, álo kámá ku nándá kutná há meng tárut táinemán. ");
INSERT INTO klt_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Táwi náni Jesu Son Iháhá watá no watán yáup ná álo táinek ingga narángga neháng tunggap tángga háláng namuk wata no heronge mená inánggoet. ");
INSERT INTO klt_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Pálipuk uláp pu me mukmuro Jesu inángga málámbán ámna náráwa iháng lem tángga ráhánggiut, enendu há naruk no rina rina tánggiut wawu wáina táet ingga ma narená me málámba ma naráng háting mená átut hára wáina tánggiut, wata ku Jesu yá urákna narángga nákkán kátu sáuk. ");
INSERT INTO klt_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Táwi náni Jesu Son Iháhá watá pahán táwi hánám namángga neháng tárut tán málámba naráng háting mánggoet me kámá ya naráng yáme kikiná hálenggoek. ");
INSERT INTO klt_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Jesu Son Iháhá watá mukmuro táená wa son náháháya ku káwak káin háuk. Me náwu pálipuk hánám wata ku ámna náráwa kámuk hánám watá narángga káto tángga átkuineráng. Kulá uláp pu no ámna kámuk iháng hátingga kandák táwi hánám tánggiut. ");
INSERT INTO klt_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Wáina enendu Jesu Son Iháhá watán pahán káin du ámna náráwa kámuk ká málám wawu yolopon narán kátin átang ámna náráwa ya kutná kutná táng yámángngátak ingga naráng mineráng ga narek. Wáina hálendu nák ku kandák táwi hánám táená, enendu urákna narán du no tárák ka áre nák hára rina táuk wa kangga ku naráng háting mángga átkuku álosim sásáliná muná wa táineráng. ");
INSERT INTO klt_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Kulá Ánutu wawu rámá rámá king átang ma kátkámut tán, hang ámna náráwa yá ku manyon kakayan. Málám wa re wawu Ánutu pálipuk. Wáina wata ku nándá rámá rámá kutná meng tárut tángga táng álolo tángguinemán. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Nanggena Timoti, no uláp profet me kák ka miuráng wata narángga ku ko rina táinelák wata me ná kanet. No wáina kane ku profet me watá keháng káto tán Ánutu yan tewe ámna yá ina erawángga wáik rina wa iháng hang tinelák. ");
INSERT INTO klt_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Wáina tángtáng gu wata kinan du Jesu ya naráng háting mángga átang Ánutu rahálá hára kándáng átat ingga narángga átnelák. Kámá yá kálu kándáng gu wáina ingga há kanggoeráng, enendu sárum imánggoeráng, wata ku naráng hákhátik yáni watá pukon wáik hálenggoek, kilang gá yamán ketnán kungga wáik hálengngátak wáina tánggoeráng. ");
INSERT INTO klt_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Ámna urum wáina táená orek yáni háranan yará ku Himeneus káling Aleksenda. Ámna yará watá ku Ánutu ya me wáik mengngátamálák, wata ku no iháng kumbi kep káin tiut wawu Satan ketná hára ina tiut. Wáina táe ku kang rákit tángga nanará álosim bá ihán du Ánutu ya me wáik son ma mindamálák ingga wata wáina táut. ");
INSERT INTO klt_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Kulá kutná táwi hánám sándá wa kálak tángguineráng wawu ing, ámna náráwa kámuk ka narángga ku Ánutu yan káin sáponga tángga heronge me inángga ku inát háláng yámángguinek. ");
INSERT INTO klt_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Ámna yáilá me kapman dán yáup ámna átaráng wata yot Ánutu yan káin sáponga táng yámát háláng yámán du pahán láláp pá orek sáni hára árán sáni kámuk Ánutu yá sándá rina átang átkukuya narek wáina átang átkuineráng. ");
INSERT INTO klt_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Sáponga wáina táineráng wawu Ánutu Son Náhuk wata rahálá hára wu álosim hánám, watá sáponga wáina wata kikiná hánám narek. ");
INSERT INTO klt_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Málámbá ámna náráwa kámuk son ihán me páliná wata hulá wa narineráng ga narek. ");
INSERT INTO klt_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Ánutu wu káman dá re átak. Hang ámna ore háranan káman dá re átak, Ánutu yot ámna náráwa ya orek yáni hára wawu Jesu Son Iháhá watá átak. ");
INSERT INTO klt_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Rám Ánutu yá tiuk hára wu, Jesu Son Iháhá watá átkukuná wa ámna náráwa kámuk son yungga iháháya sáuk. Kulá kálu wahára wu Ánutu yá ámna náráwa kámuk son ihin ingga náliuk. ");
INSERT INTO klt_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Wáina wata ku Ánutu yá aposel neháng tunggap táuk ngáya ku nákkán yáup pu málámbán me wa mengga kuku wa. Pálipuk hánám sánet, kusák ma pilet. Málámbá ámna náráwa ále kámá káinnan wa me páliná yánáng tolingga koe Jesu Son Iháhá wata naráng háting mámáya yáup ná namuk. ");
INSERT INTO klt_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Wáina wata ku itná itná káin ámna yá átkuku yáni wa Ánutu imángga rongrongngá átang ket yáni táng hip tánggatang sáponga tángguineráng ga naret. Pahán káráp me honhoren wa sángga ku pahán káman átang sáponga re tángguineráng. ");
INSERT INTO klt_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","No ing wata hányon naret, náráwa yá sut yáni tánggáneinán wawu yáni ya sut yáni tángga árángga ma tánggáneindaráng, me ámna pahán yáni táng wáik tátá káluná hára kutná kutná ma tánggáneindaráng, hang kutná kutná tánggáneinán du káluná kándáng rina átak wahára rewe tánggáneineráng. Álo kámá náhániráng ingga sut sáni tánggánene kálu ma tánggáneindaráng. ");
INSERT INTO klt_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Náráwa niyá Ánutu isutkoemán ingga mengngátaráng wawu yáup álosim hulá hulá wa táineráng, watá ku náráwa watán tánggánek álosim ina háleinek. ");
INSERT INTO klt_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Miti mengguineráng hára wu náráwa yá yolop átang yáni tángga hangga ku Ánutu yan me wa narángguineráng. ");
INSERT INTO klt_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","No náráwa yápmáe áráng átang ámna pin yáni tángga Ánutu yan me wa ámna ma yánángngátaráng. Muná. Náráwa yá yolop átang gu me rewe narángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","No wáina met wawu náuta, Ánutu yá Adam kálak táng tolingga ku máriya wu If táng toliuk, ");
INSERT INTO klt_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","hang Adam bá Satan dán me kusák wa narán pálipuk ma háliuk, ináku náráwa yá me kusák wa narán pálipuk hálen du mukmuro náráwa háliuk wa narángga ku wata wáina met. ");
INSERT INTO klt_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Kulá náráwa yá ku nangge iháhá yáup wa táineráng. Wáina tángga átang gu Jesu ya naráng háting mángga, rámá rámá rongrongngá átang, kámá ya narát kikiná hálen, tirik tárák álosim wa tángga átkuineráng hálendu Ánutu yá son ihinek. ");
INSERT INTO klt_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Me náwu pálipuk hánám. Káman niyá miti yan ámna náráwa pin yáni tátáya átnán kikiná narángga ku yáup wawu álosim ingga narinek. ");
INSERT INTO klt_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Miti yan ámna yáilá yá kálu kándáng wa rewe isutang árán du ámna náráwa yá ámna yáilá wahára kandák kámá ma káindáráng. Áwáná káman yot re kándáng átnek, málámbán átkuku wa kándáng pinná tángga átnek, kámá yá itná káin áwát pin yáni táinek, me Ánutu yan me wa ámna náráwa yánáng tolinek. Wáina tán du kámá yá watán ket tárák wa kangga álo kámá ingga mengga kutná meng toling mineráng. ");
INSERT INTO klt_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Ámna wawu umi káto yá táng hoho ma táindak, menmen ininán ma táindak, me pahán káráp tángga ámna náráwa kámá ma ráhindak, ináku pahán láláp hára re átnek. Hang sup pa kikiná táup ma narindak. ");
INSERT INTO klt_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Málámba áwá nangge wa kándáng pin yáni tángga nángánangge me yánán narángga isutang málámba tárang káin re átneráng. ");
INSERT INTO klt_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Ámna niyá áwá nangge wa kándáng ma pin yáni táindák watá Ánutu yan ámna náráwa pin yáni tátáyan yáup wa ma táindak. ");
INSERT INTO klt_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Ámna mirak ká áwáng Jesu yan tombong hálengga miti yan ámna náráwa pin yáni tátáyan yáup wa ma táindak. Nák ku ámna álosim ingga árená tán Ánutu yá táng me hára Satan táng tiuk wáinanyon tiwon. ");
INSERT INTO klt_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Ámna miti kinan ma árená yá kat miti yan ámna yáilá káman ni kutná yá álosim re átnándak watá re ku ámna yáilá álo háleinek. Iná kat kutná yá álosim ma átnándak wawu ámna yá wata me wáik mengga yánángga átkut tu Satan dán punggip pá táinek. ");
INSERT INTO klt_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Kulá wáinanyon du miti ámna náráwa háláng yámámáyan yáup ámna watá yáup yáni kándáng isutang árát ámna náráwa yá kápát álosim hálen meng toling yámineráng. Watá me yáni yará pálak ma háleindaráng. Watá umi káto táwi nangga ma hohing kuindaráng, me sup táwi hánám ihinán narángga ku kálu kandák hára kungga kámá yan hára sup ma ihindaráng. ");
INSERT INTO klt_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Yáni wu Ánutu yá málámbán me páliná táwi hánám táng hiták tiuk wa rewe káto tángga átneráng. Rám wáina táineráng wahára ku yáni wu pahán náni kinan kandák káman ma árak ingga kangga narineráng. ");
INSERT INTO klt_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Hulátingga ku átnát yáni hára wa tárák yáni ya kápineráng, kápát álo hálen wawu sat miti ámna náráwa háláng yámámáyan yáup wa álo tángga átneráng. ");
INSERT INTO klt_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Áwáwá yáni watá wáinanyon yáup yáni kándáng isutang árát ámna náráwa yá kápát álosim hálen meng toling yámineráng. Watá átkuineráng hára kámá ya ma meng yámángga átkuindaráng. Átkuku yáni wa kándáng pinná tángga árát yáup rina tátáya yámená wa álo táineráng ingga ámna náráwa yá kápát átneráng. ");
INSERT INTO klt_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Miti ámna náráwa háláng yámámáyan yáup ámna wawu áwáná káman watyot rewe átang gu málámba áwá nangge wa kándáng pin yáni tángga átnek. ");
INSERT INTO klt_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Ámna niyá yáup wáina wa kándáng tángga átnek wata ku kut táwi táinek. Wáina átang gu naráng hákhátik yáni Jesu Son Iháháyan káin rina átak wa meng tunggap tátáya ma pitáindáráng. ");
INSERT INTO klt_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","No sopmuná kungga kák kahin ingga tánggoet, enendu álo kámá wu me ná uyingga kaninet ingga uyet. ");
INSERT INTO klt_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Wáina wata ku no sopmuná ma koe hálendu papia ná kangga ku ket tárák álosim rina Ánutu yan tombong hára átaráng sándá tángguineráng wa há narineráng. Nándu Ánutu átkukuná pálak watán tombong. Kumam káto yá it káto tángga átnándak wáinanyon du Ánutu yan tombong nándá ku me páliná wa táng káto tángga átnemán. ");
INSERT INTO klt_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Pálipuk há naremán wáina, Ánutu yan me páliná wata hulá wawu kutná táwi hánám. Me wata hulá Ánutu yá nálek wawu ing, pálipuk ámna nangge háliuk, Iruk Káungá yá málám wawu ámna náráwa son iháháyan ámna ingga yáliuk, angelo yá káuráng, Ánutu yá tángga alek káin irawa kung málámbot árán kut táwi hánám tángga átak, káwakngá káwakngá káin kungga watán me pingnga wa yánángga kuráng, hang káwak ketnán ámna náráwa watá wata naráng háting mángngátaráng. ");
INSERT INTO klt_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Iruk Káungá watá hiták hánám ing mek, rám bá sálikngin ingga tángga átnek wahára wu ámna kámá wu naráng hákhátik yáni wa sangga iruk wáik ámna náráwa yángyárungingiyan wata kárámating yámángga watán me narángga isutneráng. ");
INSERT INTO klt_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Ámna kusák watá iruk wáik kán me wa ámna náráwa yánineráng. Ámna watá ku ing meineráng, “Nándán me wawu pálipuk hánám,” enendu kandák yáni wawu ma kang rákit táindáráng, náuta nanará yáni álosim wawu há kámutuk wata. ");
INSERT INTO klt_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Ámna watá ámna náráwa yá ihán kehán ma tátáya me sungi kámá wa ma nanaya yánángngátaráng, Ánutu yá málámba naráng háting mená me, me páliná wa narená watá nangga málámba heronge táng mámáya iháng toliuk wa. ");
INSERT INTO klt_vpl VALUES ("T14_4","084_4_4","1TI","4","4","5","Há naremán wa, kutná kutná kámuk Ánutu yá iháng toliuk wawu álosim rewe. Ánutu málámbán me watyot nánin sáponga watá tán du sungi kámuk hánám watá Ánutu rahálá hára rongrongngá hálengngátaráng. Nándá kápátne wáik ma háleindak, ináku nándá ku Ánutu heronge me inángga ku sungi wa iháng náinemán. ");
INSERT INTO klt_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ko me ná táng nuknuk náni wa yánátá ku me álosim rina naráng háting mánggoemán me nanará álosim narángga isutkoelák watá ka keháng káto táinek. Wáina tángga ku Jesu Son Iháhá watán yáup ámna álosim hálengga átkuinelák. ");
INSERT INTO klt_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Pingnga hánámá hánámá me, me hánámá hánámá wa sárum iminelák. Me wáina wawu Ánutu yan pahán káinnan muná watá kámá ma háláng námindák. Ináku Ánutu yan tirik tárák rina tátáyan átak wa re háiná táinelák. ");
INSERT INTO klt_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Ing narinelák, sut náni tátne káto árik ingga háiná tángngátamán, enendu watá ku isikimo háláng námángngátak. Iná nándá Ánutu yan ket tárák watá nán hára káto árik ingga wata háiná táinemán wawu watá táwi hánám háláng náminek. Watá ku átkuku káwak ketnán ná átninggoemán me máriya átkuku sásáliná muná táinemán wahára kándáng hánám háláng námánggatnek. ");
INSERT INTO klt_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Me náwu pálipuk hánám, wata ku ámna náráwa kámuk hánám watá narángga káto tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Ánutu átkukuná pálak ámna náráwa kámuk son iháhá watá málámba naráng háting mená nán son náhuk. Nándá Ánutu ya naráng háting mángga náháng tolik ingga háleng mángga átkoemán wata ingga ku yáup háláng hánám tánggoemán. ");
INSERT INTO klt_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ko me ná ámna náráwa yánángga ku yánáng tolitá me yá rina mek wa isutneráng. ");
INSERT INTO klt_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Kák ku ámna máto, wata watá kahát kák ku ámna hánámá ma háleindak. Ko ket tárák álosim wa rewe tángga átkutá Jesu yan ámna náráwa watá kák kahángga ku wáinanyon átkuineráng. Ko ket tárák álosim yáleinelák wawu meka me táinelák, tirik tárákka rina táinelák, kámá kápátá kikiná háleinek, naráng hákhátik hára átang átkuinelák, me Ánutu rahálá hára rongrongngá átang átkuinelák hára wa. ");
INSERT INTO klt_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Ko Ánutu yan papia wa pahála yot hánám ámna náráwa ya sánging yámángga wata hulá wa yánángga Ánutu yá átkuku rina ta narek wa yánáng tolingga átnárát kungga no áwinet. ");
INSERT INTO klt_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Ko Ánutu yá háláng rina kamuk watá yáup tátáya táng taktak ma táindalák, háláng wawu miti yan ámna hulá yá ket yáni yáila hára usáng hang tit ámna káman dá profet me kák ka miuk wahára táulák. ");
INSERT INTO klt_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Yáupya wa pahála yot kándáng pinná tángga árátá ku ámna náráwa kámuk hánám watá kahát ko yáup álosim tánggoelák wa emá re tángga árátá táwi hánám hálengga kuinek. ");
INSERT INTO klt_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Táwi yan me yánáng tolinelák me ket tárákka rina táinelák wahára wu kándáng nangnaráng átang tángga átkuinelák. Ko káto hálengga yáup álosim wáina tángga átkuinelák wata tángga Ánutu yá son kehángga ámna náráwa niyá kákkán me narineráng watyot son ihinek. ");
INSERT INTO klt_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ko ámna tátáwi wa me hahatiná kálu ma metáng yámindalák, ináku me láláp hára nanya inángngátalák wáinanyon yánángga iháng tolinelák. Yakukulaka ya ket tárák álosim táng yámángngátalák wáinanyon ámna máto wata ket tárák wanyon táng yáminelák. ");
INSERT INTO klt_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Mamya ya ket tárák álosim táng mángngátalák wáinanyon náráwa tátáwi wata ket tárák wanyon táng yáminelák. Hang málám ilomya ya ket tárák álosim táng yámángngátalák wáinanyon náráwa máto wata ket tárák wanyon táng yáminelák, wáina wawu Ánutu rahálá hára kálu kándáng álosim. ");
INSERT INTO klt_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Náráwa kawát kámá niyá yáni re ukuro hánám árát kápángga ku wa háláng yámángguinelák. ");
INSERT INTO klt_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Iná kawát káman dá nángánangge me e ilommá pálak árán du yánáng tolitá Ánutu rahálá hára naráng hákhátik isutang yáup páliná hánám táineráng wawu mam pawo yáni kawát wa pinná táineráng. Wáina tát tu uláp yáni rina pin yáni táená wata topmá háleinek. Ánutu yá kálu wáina wata wu álosim narek. ");
INSERT INTO klt_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Kawát kámá niyá yáni re ukuro átang wawu ing tángga átkungngátaráng, Ánutu yá iháng álolo táng yámámáya háleng mángga káen me yáungán wawu sáponga tángga Ánutu yá háláng yámámáya inángga átkungngátaráng. ");
INSERT INTO klt_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Iná náráwa kawát káman dá sut tán kutná kutná wata re narán páliná hálen átnándak, náráwa wawu há kámurená yá ina átnándak. ");
INSERT INTO klt_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Me wáina yánátá kálu kándáng re isutang árát tu ámna náráwa yá ma meng yámindáráng. ");
INSERT INTO klt_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ámna káman dá sipmá kátu wa ma pin yáni táindák wawu kandák. Hang ámna káman dá naning maming, málám ilommá, tat kulaná, áwáná me yanángánanggená wa ma pin yáni táindák wawu kandák táwi hánám. Ámna káman dá ket tárák wáina táinek wawu ket tárákngá watá ku hiták Jesu ya ma naráng háting mángngátak hálek. Watán ket tárák wawu ni Jesu ma naráng háting máráng wata tárang káin átak. ");
INSERT INTO klt_vpl VALUES ("T15_9","084_5_9","1TI","5","9","10","Náráwa kawát kut yáni uyinán du yara yáni 60 hára átang torong kálu koek ngá, nánáun yáni yot rewe kándáng árená, hang álosim rina rina tángngátaráng ngáya kámuk ká naráng yámángngátaráng wáina wa rewe uyinelák. Tárák álosim wawu ing wata menggoet, nangge pin yáni táineráng, lombu pin yáni táineráng, Táwi yan ámna náráwa háram yáni yanyawon táineráng, niyá márapmá hára árán háláng yámineráng me hahatingga átang kámá rina rina wa tángga nukngá háláng yámineráng wa. Wáina táená wa rewe kut yáni uyinelák. ");
INSERT INTO klt_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Kulá náráwa kawát máto wawu kut yáni papia káin ma tindalák, náuta watá náun áwán háhále watán nanará watá áwinek wahára wu Jesu Son Iháhá yan yáup rewe tángga átnemán ingga me káto mengngátaráng wa sangngátaráng wata. ");
INSERT INTO klt_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Wáina tángga ku me káto há mená wa yalineráng wata ingga ku me hára átneráng. ");
INSERT INTO klt_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Iná ko miti ámna náráwa yá háláng yáminán náráwa kawát máto kut yáni uyinelák wawu yáni táng taktak tángga it wahára kungkung tángga átang kámá yá rina táineráng wa met narángga wata meng yámángga watá ma hánám memeyan wa mengga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Wata ku no naret tu álosim wawu kawát máto ingga átaráng watá ku ámna ihángga nángánangge yáni iháng tingga ku wata pin yáni tángga átneráng, wata ku káyam bá wa kápángga ku nán Jesu yan tombong ga ma meng námindáráng. ");
INSERT INTO klt_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","No me wáina met wawu náuta, kawát máto kámá wu Táwi sangga kung Satan isutang há átninggoeráng. ");
INSERT INTO klt_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Kulá naráng hákhátik náráwa káman niyá sipmá kátu káman náráwa kawát hálendu watá wa háláng iminek. Watá miti ámna náráwa nukngá yá yáup watyot tátáya yáup háláng ma yámindak. Iná náráwa watá sipmá kátu wa há háláng iminek hálendu nukngá watá ku kawát niyá yáni re ukuro hánám átaráng wa álo háláng yámámáya narineráng. ");
INSERT INTO klt_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Niyá miti yan ámna yáilá ingga átang miti yáup kándáng tángga árát tu Táwi yan ámna náráwa watá kut yáni meng tárut tángga háláng yámineráng. Iná nini yá Ánutu yan me pingnga mengga yánáng tolingga átkuineráng wawu táwi hánám háláng yámángga kut yáni meng tárut táineráng. ");
INSERT INTO klt_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Wáina táineráng wawu náuta, Ánutu yan me ing uyená yá átak, “Bulmakau yá wit páliná ketnán tarengga árán kepmá yá sohit wit ma nanaya milunná ma hárotnándaráng.” Hang ing hányon, “Ámna niyá yáup táinek watá ku yumnakngá ihinek wawu álo kámá.” ");
INSERT INTO klt_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Káman dá ing meinek, “Miti yan ámna yáilá nátá kandák táek,” ing men wawu watán me wa ma narindalák. Ináku ámna yará me kaláhu yá me wa rewe met wawu kárámanya yá narángga me wa ting tantan tángga káinelák. ");
INSERT INTO klt_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Ámna yáilá káman dá kandák tán wawu táng rahán táwi hára me hára titá ku ámna yáilá nukngá yá wa kangga mukmuro táninggom ingga pitáineráng. ");
INSERT INTO klt_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Ánutu, Jesu Son Iháhá me Ánutu yan angelo málámbá há kankaliuk ngá átaráng wata rahán yáni hára ing kanindet, ko me há kanet wa kándáng isutnelák. Wa isutnelák wahára wu ámna náráwa kámuk ket tárák káman re yáleinelák, nuknukka me ámna kámá ket tárák kámá kámá ma yáleindalák. ");
INSERT INTO klt_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Ko ámna káman dá miti yan ámna yáilá háleik ingga sopmuná ketya yáin yáni hára usáng hang ma tindalák, náuta watá mukmuro tán watán márapmá watá kák hányon kehiwon. Kawu Ánutu rahálá hára rongrongngá átkuinelák. ");
INSERT INTO klt_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Umi hánám rewe ma náindalák, ináku wáin isikimo kulingga ku hányon natá watá kawila kinan ilalákka rámá hára tunggafengfeng tángngátak wa táng láláp táinek. ");
INSERT INTO klt_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Ámna kámá yan mukmuro wawu hiták átnándak, ko ting tantan tángga ma kápindálák enendu kandák yáni wawu wáina ingga há naráng yáminelák. Iná kámá wu kilak árán ma narená árátá kungga rám hásák hálendu hiták háleinek. ");
INSERT INTO klt_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Kulá wáinanyon du ámna kámá yá álosim rina táineráng wawu kámuk ká hiták kangga narineráng. Iná kámá yá álosim rina táineráng wawu waháranyon du hiták ma háleindák, ináku kilak átang kungga máriya ku wáina hiták háleinek. ");
INSERT INTO klt_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Ámna ni yáup nangge ya hánámá árená Táwi ya naráng háting mená átaráng watá wu yáni tángga hangga ku márum yáni wata tárang káin átneráng. Ket tárák álosim wáina tát kápángga ku ámna náráwa yá Ánutu kutná ma táng lem táindáráng, me nándá Táwi yan me yánená wa yanyawon ma táindáráng. ");
INSERT INTO klt_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Iná yáup nangge hánámá káman da márumá yá Táwi ya naráng háting mená hálendu yáup nangge watá wata narán nukna hánámá wata ku wata tárang káin ma árin ingga ma narindak. Ináku ing narinek, “Yáup ná tánggoet wawu Táwi ya naráng háting mená káman háláng imánggoet, me wa káe kikiná háleinek, wata ku kámá yá márum yáni Táwi ya ma naráng háting mená ya yáup táng mángngátaráng wa táng hátingga yáup kándáng hánám táng minet,” wáina hánám narinek. Me ná uyená náwu Táwi yan ámna náráwa wa yánáng tolingga yánátá wa há hánám isutneráng. ");
INSERT INTO klt_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Ámna kámá wu me kusák wa sánáng tolinggoeráng. Me rina menggoeráng watá kung Táwi náni Jesu Son Iháhá watá rina kándáng nánáng toliuk watyot káman ma hálengguk, me rina menggoeráng watá ámna náráwa háláng yámán Ánutu isusut wahára ma kungguráng. ");
INSERT INTO klt_vpl VALUES ("T16_4","084_6_4","1TI","6","4","5","Ámna wáinaná wawu yáni ya narát árená hálenggoek, enendu watá náut kámá káman wáina ingga ma naráráng. Watá tárák kandák ing wata heronge narángga átkoeráng, kámá yot me hánámá hánámá wata hulá ya menmen ná tángga átninggoeráng. Wáina watá ku ámna náráwa yángot kung gu kápáng naknarák, menmen, mengmán mengmán, kámá ya kep kotkot táng yámámá, me honhoren káluná wahára tinggoeráng. Ámna wáinaná watán nanará wawu kandák hánám. Kámá ya me páliná wa táng yakyawák táng yámángngátaráng, hang Ánutu yan yáup hulá hulá tángga ku kutná kutná táwi ihinemán ingga narángngátaráng. ");
INSERT INTO klt_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Iná ámna káman dá Ánutu yá ket tárák rina tátáya narek wa rewe isutang átnek wahára wu kutná kutná táwi átminek me isikimo átminek wawu álo rewe ingga narinek. Ámna káman dá wáina táinek wawu Ánutu yan átkuku watá watyot táwi hánám átnek. ");
INSERT INTO klt_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Mam kinan átang tunggafiumán wahára wu náut kámá káman ma táená áwumán, hang káwak sangga kuinemán wahára wu náut kámá káman tánggatang ma kuindámán. ");
INSERT INTO klt_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Wáina wata ku sungi me sut tánggánene yá há átnámát wawu álo átnámek ingga narángguinemán. ");
INSERT INTO klt_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Káman niyá sup táup ihin ingga narinek wawu ingirungingi yá engot kung punggip hára tinek. Pahán yáni watá ket tárák hohoná me wáik hulá hulá tátáya táwi hánám tárurán watá márapmá táwi hánám yámángga iháng lem táinek. ");
INSERT INTO klt_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Sup pa kikiná nanará wawu mukmuro hulá hulá wata hulá. Ámna kámá wu sup pa kikiná hánám naruráng, wata ku watá iháng yawák tán naráng hákhátik hára átnát wa há sangga ku márapmá táwi sungga átaráng. ");
INSERT INTO klt_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Kák ku Ánutu yan ámna, ket tárák kandák wata pitáng mángga mulangán átnelák. Wáina tángga ku kálu kándáng átkuku, Ánutu yan pahán isusut, naráng hákhátik hára átkuku, kámá kápátá kikiná háhále, káto hálengga átang márapmá rina rina wa sungga átnát, me nangge nuk kot yolop átnát wawu yáupmá hálánggon tángga ku ihángguinelák. ");
INSERT INTO klt_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Tewe ámna yá hánghálángngingga átang erawángngátaráng wáinanyon du ko káto hálengga Ánutu ya naráng háting mángga milunná sungga átnelák. Ka Táwi ya naráng háting mángga ku Jesu ya naráng háting met ingga rahán táwi hára há yánulák rám wahára Ánutu yá átkuku sásáliná muná tátáya mantáng kamuk, wata ku átkuku wa káto táinelák. ");
INSERT INTO klt_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Ánutu kutná kutná átkuku yáni yámángngátak wata rahálá hára me Jesu Son Iháhá watá Pontius Pailat rahálá hára me pálipuk miuk wata rahálá hára no me ing kane ko me wa há hánám isutnelák, ");
INSERT INTO klt_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Táwi yan me rina narulák wa kándáng re isutnelák, wata kinan kámá yá kák hára kandák kámá ma káindaráng, ináku rongrongngá re árátá kungga Táwi náni Jesu Son Iháhá watán rám bá tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Wa tunggafeinek wawu Ánutu yá rám narek wahára. Ánutu wawu kutná kutná álosim kámuk hánám wata márumá, hang málámbá re ku kutná kutná kámuk wata pin yáni tángga átnándak. Málám bu king átaráng watán King, me táwi átaráng watán Táwi. ");
INSERT INTO klt_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Málám watá re ku ma kátkámut tán, hang málám bu yamá maming táwi kinan átnándak, wata ku káman dá wata tangtang áwáwáyan tárák ku muná. Káman dá ma káuk me káman dá álo kakayan tárák ku muná. Ánutu yan uliháláng wawu sásáliná muná, wata ku kutná meng tárut tángga átkuinemán. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ámna kámá niyá kutná kutná ná álo árán káwak ketnán rám nahára álosim átat ingga átaráng wa ing yáninelák, yáni ma tángga árángga kuindaráng, hang sup rina átyámek watá álo háláng náminek ingga ma narindaráng, náuta sup yáni watá rám náut hára muná kuinek wawu ma naráráng. Yánátá ku Ánutu yá re ku álo háláng náminek ingga narineráng, watá re ku heronge tátáyan kutná kutná álosim táup táwi wa háláng námángngátak. ");
INSERT INTO klt_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Yánátá ku kámá háláng yámámáya tárák álosim táup táwi yon há tángguineráng. Kutná kutná rina átyámek wa iháng niyá kesák táeráng wa ilap tángga yámineráng. ");
INSERT INTO klt_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Wáina táineráng wawu máriya rám bá áwinek wahára watá háláng yámámáyan kutná kutná álosim hánám wa ihineráng. Wáina tángga ku átkuku álosim wa táineráng, wawu átkuku páliná hánám. ");
INSERT INTO klt_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timoti, kák ku yáup rina Ánutu yá kamuk wa hánám táinelák. Me hánámá hánámá Ánutu yan nanará káin ma áraráng wa sárum yáminelák. Ámna kámá yá ku nándán nanará wu kándáng ingga narángga meineráng, enendu watán nanará wawu Ánutu yá kandák ingga narek, wata ku ko wa yápmang kung kámá átnelák. ");
INSERT INTO klt_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Ámna náráwa kámá Jesu yan tombong háliuráng, enendu nanará kandák wáina wa isutang átningga ku Jesu yan me páliná wa sáuráng. Ánutu yá pahán sámángguinek. ");
INSERT INTO klt_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Nák ku Pol, Jesu Son Iháhá watán aposel. Ánutu yá málámbán pahán isutang yáup wa tátáya neháng tunggap táuk. No aposel hálengga Ánutu yá ámna náráwa niyá Jesu ya naráng háting mángga átneráng watá átkuku álosim táineráng ingga há miuk wa yánánáya ingga wáina táuk. ");
INSERT INTO klt_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Timoti kák ku nanggena ina, kák ka kikiná hánám naráng kamánggoet. No papia ná uyingga se kákkán da koek. Nan náni Ánutu watyot Táwi náni Jesu Son Iháhá watá urákka narángga pahán kamán pahán láláp hára átnelák. ");
INSERT INTO klt_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Uláp pu táwi ilomna yá Ánutu ináng sáknginggiuráng, iná inggálu ku no nanarána kinan káin du kálu kándáng hára rewe isutang átkoet ingga narángga wáinanyon Ánutu ináng sáknginggoet. Rámá rámá káen me yáungán kák ka naráng hátinggoet wahára wu Ánutu heronge me inángga málámbán káin kák ka sáponga táng kamánggoet. ");
INSERT INTO klt_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","No átang uláp náti sansan táumát hára rahála uminá hirarátá háuk wata naráng hátingga son kakaháya kikiná hánám wa naránggoet. Son kahinet wahára ku pahánna yá álosim hánám háleinek. ");
INSERT INTO klt_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Uláp pawoka Lois me mamya Yunis yá pahán hurik tángga Jesu yan tombong háliumálák wáinanyon ko pahán hurik tángga Jesu ya pálipuk naráng háting mángga málámbán tombong háliulák wawu pálipuk hánám ingga naránggoet. No naráng hákhátikka káto wata naránggoet, ");
INSERT INTO klt_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","wata ku no son pahála táng tárut táet wawu uláp no ketna yá yáila hára usáng hang tiut wahára wu Ánutu yá náut háláng málámbán yáup tátáyan wa kamuk. Ko wata narángga yáupmá tátá watá átkukuka káin káto átkuinek, ámna nangge yá káráp kátu kátu iháng urum tingga hásit lánggop pá rang hálengngátak wáinanyon rang háleinek. ");
INSERT INTO klt_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ánutu yá Irukngá námuk wawu Iruk watá pahán náni táng piták tátáyan muná, watá ku háláng námángga náháng káto tán átkuku, me nangge nuk ka narátne kikiná háhále, me náni kálu kándáng nálen kangga átkuku náni pinná tángga isusut wata Iruk wa námuk watá ku wáina háláng námángga átkoek. ");
INSERT INTO klt_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Wáina wata ku ko Táwi yan me ámna náráwa yánánáya reprepmá ma narindalák, me no kalabus kinan átkoet wata ingga iháng reprep ma táindalák. Kalabus kinan átkoet wawu Táwi yan yáup tánggoet wata. Reprepmá ma narindalák, ináku Ánutu yan háláng wa tángga no uláp Táwi yan me pingnga álosim yánángga kungga márapmá rina sunggiut wáinanyon ko me pingnga álosim wa yánángga átningga márapmá sungga átningguinelák. ");
INSERT INTO klt_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Ánutu yá mantáng námángga son náhuk wawu rongrongngá káungá hánám átnát wata. Nándá náut kámá álosim káman tátne wata ingga wáina ma táuk, ináku málámbá pahán námángga málámbán pahán isutang wáina táuk. Uláp pon alek káwak ma iháng tunggap táená yon átang pahán námángga ku Jesu Son Iháhá yá yáup wáina táinek ingga wu Ánutu yá há naruk. ");
INSERT INTO klt_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Inggálu ku Jesu Son Iháhá watá káwak káin hangga son náhuk wahára kungga ku Ánutu yá pahán námuk watá hiták há háliuk. Jesu yá kátkámut tán háláng wa táng wáik tángga málámbán me pingnga álosim watá átkuku sásáliná muná wa táng áwáng hiták tiuk. ");
INSERT INTO klt_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Ánutu yá nák neháng tunggap táuk wawu no yáup ing tátáya, me pingnga álosim wa ámna náráwa yánánáya, aposel háháleya, hang ámna náráwa yánáng totoliya. ");
INSERT INTO klt_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Ánutu yá yáup wa tátáya neháng tunggap táuk, wata ku no márapmá ná sunggoet, enendu no wata reprepmá ma naránggut, náuta ni naráng háting mánggoet wawu há naret, hang no ing há hánám naret, málámbá yáup wa ketna hára tiuk wa pinná tángga árán kungga Jesu Son Iháhá yan rám táwi watá tunggafeinek. ");
INSERT INTO klt_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Ko ku me páliná ka rina kanut wa kándáng hánám naráng hátingga ku me wáina hánám bon du ámna náráwa yánáng tolingguinelák. Rám wáina tángguinelák wahára ku Jesu Son Iháhá naráng háting mángga kámá kápátá kikiná hálengguinek. ");
INSERT INTO klt_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Ánutu yá me pingnga álosim wa ketya hára tiuk wawu kándáng pinná táinelák. Me kusák watá táng yakyawák táiwon da ku káto hálengga átnelák. Iruk Káungá náni ya kinan átak watá háláng kamán du me páliná wa kándáng pinná táinelák. ");
INSERT INTO klt_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Ing há narelák wa, ámna náráwa táuppon Esia provins kinan átaráng watá sárum há namángga átaráng, wata kinan ámna yará Fikelus káling Hemokenes watá wáinanyon sárum namángga átamálák. ");
INSERT INTO klt_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Iná Onesiforus wawu nukna pánpáliná. Rám máro áwáng nahángga háláng namánggoek, me sen dá neháng kik táená me kalabus kinan átkoet enendu wata iháng reprep ma tángguk, wata ku no Táwi yan káin sáponga táe ámna náráwa itná kinan átaráng wa, me málám iháng álolo táinek. ");
INSERT INTO klt_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Málám Rom káin áwuk wahára wu nák ka yáup háláng hánám suling namángga átninggan nahuk. ");
INSERT INTO klt_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","No Táwi yan káin ing sáponga tánggoet, Jesu yan rám táwi tunggafeinek rám wahára wu Ánutu yá Onesiforus urákngá narinek. No Efesus káin áre háláng namámáya yáup máro yon tánggiuk wawu ka há narelák wa. ");
INSERT INTO klt_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Nanggena Timoti, kák ku Jesu Son Iháhá málámbá háláng kamánggoek, wata ku káto hálengga átnelák. ");
INSERT INTO klt_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Ámna náráwa táup táwi ya rahán yáni hára me rina yáne narulák me wanyon táng ámna náráwa niyá Táwi yan me káto tángga átaráng wa ket yáni hára tinelák, wata ku watá wanyon táng kung ámna náráwa nukngá yánáng tolineráng. ");
INSERT INTO klt_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Jesu Son Iháháyan tewe ámna álosim bá ina átnelák. Wáina átang márapmá rina áwinek wahára nándá káto hálengga márapmá suwánggoemán wáinanyon káto hálengga átang márapmá suwinelák. ");
INSERT INTO klt_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Tewe ámna káman dá yáupmá hára átang waháranyon yáup nukngá ma tángngátak. Ináku táwiná pahán álosim imámáya ku náut yáup imená wa rewe tángngátak. ");
INSERT INTO klt_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Wáinanyon ámna káman dá hururung kuku wahára watán káluná rina tingga hururung koená wa táng hátingga kandák kunggim wawu wata yumnakngá ma ihánggim. ");
INSERT INTO klt_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Yáup mara káman dá hái hinek, wata páliná watá áliknginek wawu watá kálak náinek. ");
INSERT INTO klt_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","No me tárákngá kanet wata narátá ku Táwi yá háláng kamán wata hulá kámuk narinelák. ");
INSERT INTO klt_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Rámá rámá Jesu Son Iháhá wata naráng hátingguinelák. Ánutu yá há kámutuk háranan son táng tárut táuk, iná málám wawu king Dewit tán hun háranan. No me pingnga álosim yánánggoet wawu wa. ");
INSERT INTO klt_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","No márapmá sungga átkoet wawu me pingnga wa ámna náráwa yánáng tolingngátat wata. Hulá wata hánám bu sen dá neháng kik tángga kalabus kinan manek ámna ina ting sat átkoet, iná Ánutu yan me wawu sen dá táng kik ma tátáyan. ");
INSERT INTO klt_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Wata ku no káto hálengga átang márapmá hulá hulá suwángga átkoet, wawu no ámna náráwa Ánutu yá nakán ingga iháng tunggap táuk wa háláng yámámáya. Wáina háláng yáme ku Jesu Son Iháhá wata naráng háting mángga árát tu Jesu yá son ihán rámá rámá yamá táwi wata kinan átneráng. ");
INSERT INTO klt_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Me ná meindet náwu pálipuk hánám, Iná nándá Jesu yot kámutumán hálen wawu málámbot há átkuinemán. ");
INSERT INTO klt_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Iná nándá káto hálengga átang márapmá sungga átnemán wawu máriya ámna náráwa hulá hálengga watyot kutná kutná pin yáni tátáyan kome wahára átnemán. Iná nándá Jesu ma naráng mámán ingga meinemán wawu Jesu yá wáinanyon ma naráng sámát ingga meinek. ");
INSERT INTO klt_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Iná nándá Jesu yan me há isutnemán ingga mengga sangga wáina meinemán wa ma isutnándámán, enendu Jesu yá pahán sáminet ingga miuk wa há isutnek, náuta me wáina táinet ingga mengngátak wawu ma sangngátak. ");
INSERT INTO klt_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Ko Jesu yan ámna náráwa me ná kanet ná sonson yánángguinelák. Ánutu rahálá hára me káto yánángga ing yáninelák, kámá yot me hánámá hánámá wata hulá nanaráya menmen ná ma tángguindaráng. Me wáina watá ámna káman ma háláng imindák, ináku niyá me wa narinek watán naráng hákhátik wa táng yakyawák táinek. ");
INSERT INTO klt_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Ko hánghálángngingga átang yáupya wa tángga átkuinelák wawu Ánutu yá yáupya wa kangga yáup ámna álosim ingga kahángga árán ko málámba rahálá hára átnát ta reprepmá ma narindálák. Wáina átang gu ko me páliná wa kándáng re kámá yánáng tolingguinelák. ");
INSERT INTO klt_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Me hánámá hánámá Ánutu yan nanará káin ma áraráng wa sárum yáminelák. Ámna náráwa niyá me kandák wáina mengngátaráng wawu yolop yolop Táwi sangga mulangán kungga kungga átang kandák yáni watá táwi hánám hálengngátak. ");
INSERT INTO klt_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Me wáina wawu putun dá sippot sippot ámna nangge iháng wáik tátáya tángngátak wáina. Ámna wáinaná waháranan ámna yará ku Himeneus káling Filetus. ");
INSERT INTO klt_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Ámna yará wawu me páliná isusut wa há sáumálák. Ámna náráwa yá há kámutang son tátárut wawu há sálikngiuk ingga mengga ámna náráwa kátu yan naráng hákhátik wa há iháng wáik tánggoemálák. ");
INSERT INTO klt_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Iná Ánutu yan ámna náráwa wawu kumam káto ina ma kongkongngindáráng wata táit yáni hára ku me ing uyingga tiuk, “Táwi yá ámna náráwaná wa kándáng hánám há naráng yámek.” Hang ing hányon uyiuk, “Ámna náráwa niyá nándu Táwi isutnándamán ingga meineráng watá ku mukmuro rina rina wa erek sárum imineráng.” ");
INSERT INTO klt_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","It maming tátáwi kámá ya kinan káin du rápmám me rápmám ina hulá hulá yá átaráng. Kámá gol yá iháng tolená me kámá silva yá iháng tolená yá átaráng wawu yáup álosim yámámáyan. Iná kámá káráp pá hoseng tolená me kámá káwak ká iháng tolená yá átaráng wawu yáup hánámá hánámá yámámáyan. ");
INSERT INTO klt_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Wáinanyon du ámna náráwa kámá yá ket tárák yáni wáik wa sang hálineráng wawu rápmám wa iháng yáup álosim imámáyan dá ina átneráng. Ámna wáinaná wawu rongrongngá hánám átneráng, wata ku Táwi yáni yá náut yáup álosim yáminek wawu yáup tátáya há tiyawingga átneráng, wata ku yáup wa kándáng hánám há táineráng. ");
INSERT INTO klt_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Wáina wata ku nenggimo yan kikiná wáik pahán kinan káin tunggafengngátak wata pitáng máng kung átang gu káto hálengga ing wa ihinán táinelák, kándáng átnát, naráng hákhátik hára átnát, kámá kápátá kikiná háhále me pahán láláp hára átnát wa. Wáina ihinán wawu ámna náráwa niyá Táwi rahálá hára rongrongngá átang sáponga tángga ináng sákngingngátaráng watyot ket tárák wáina wa ihinán táineráng. ");
INSERT INTO klt_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Ámna náráwa yá me páliná muná wata menmen ná tát ko ka táng kung wata kinan ma tindalák, náuta watá kangot kung honhoren tátá kálu wahára tiwon. ");
INSERT INTO klt_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Wáina narinelák, Táwi yan yáup nangge nándu káman yot honhoren ma átnándamán. Iná nándá ku ámna náráwa kámuk hánám iháng álolo tángga ku me páliná yánáng totoli káluná wahára átang kámá yá náháng lem tát nándá ku pahán láláp re yáminemán. ");
INSERT INTO klt_vpl VALUES ("T22_25","085_2_25","2TI","2","25","26","Ámna kámá wawu Satan dá iháng málámbán kumbi kinan tin málámbán yáup kandák hulá hulá wa tángngátaráng. Ámna wáinaná watá nányot kámkáyam táineráng wawu nándá ku yolopon hára yánáng tolitne ku Ánutu yá pahán yáni kinan yáup tán álo hám pahán hurik tángga ku me páliná wawu wáina ingga naráng rákit táineráng. Wáina tángga ku nanará álosim watá ihán Satan dán punggip háranan dá sohingga áwineráng. ");
INSERT INTO klt_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Ing narinelák, rám bá sálikngin ingga tángga átnek wahára wu márapmá wáik hánám watá tunggafeineráng, ");
INSERT INTO klt_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","náuta ámna náráwa yá ing táineráng wata, yáni ya rewe narát kikiná háleineráng, sup pa narát kikiná háleineráng, yáni ya tungtung yáni táineráng, yáni ya narát árená háleineráng, me kandák yánángga iháng hang tiktik táineráng, nan mam bán milun ma isutnándáráng, kámá niyá háláng yámineráng wata ma narindáráng, Ánutu yan ket tárák álosim wa sangga káwak kán nanará isutneráng, ");
INSERT INTO klt_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","kámá kápát ále hánámá ina háleineráng, kámá ya kátu sang yáyámá ma táindáráng, kámá yá kámá ya wáina táek ingga kusák pileineráng, yánin átkuku wa pinná ma táindáráng, ámna ángárángngá hánám átang kámá yot álo erawángga iháng wáik táineráng, kálu kándáng wata taktak yámineráng, ");
INSERT INTO klt_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","nuknuk yáni wa iháng káyam ket yáni hára tineráng, sopmuná ingmen nanará yáni kandák wa isutneráng, sut yáni tángga árárá táineráng, káwak nátán heronge wata narát kikiná háleineráng, iná Ánutu ya ku kikiná ma narindáráng. ");
INSERT INTO klt_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Yáni wu Ánutu ináng sákngená yan tárák wahára átkuineráng, iná Ánutu yan háláng gá átkuku yáni wa táng totoliya wu taktak yáminek. Wáina wata ku ámna wáinaná watyot káman hálengga ma átkuindalák. ");
INSERT INTO klt_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Ámna wáinaná watá it kinan kung hanin ingga yángyárungingga kálu ya sulingga kangga kung hangngátaráng. Wakáin kung hangga ku náráwa me háting márák tángga nanaráyan tárák muná watán nanará wa pin yáni tángga wáina wáina tániráng ingga yánángngátaráng. Iná náráwa wawu pahán yáni káin kandák wa táwi hánám tátáya narángga mukmuro táwi hánám wa tát watá iháng usángga átnándak, ");
INSERT INTO klt_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","hang rámá rámá nanará mirak wa iháháya kikiná naránggoeráng, iná Jesu yan me páliná wawu kándáng ma naráng rákit tángngátaráng. ");
INSERT INTO klt_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Uláp ámna yará Janes káling Jambres yá Moses táng káyam táumálák wáinanyon du ámna watá me páliná wa táng káyam tánggoeráng. Nanará yáni watá wáik hánám árán Ánutu ya naráng háting mámáyan káluná watá kándáng ma hálen du Ánutu yá sárum yámánggoek. ");
INSERT INTO klt_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Wáina táineráng enendu ámna náráwa yángyárungingi watá táwi ma hálengga kuindák, ináku ámna náráwa yá watán ket tárák wawu hohoná yan ket tárák ingga hiták káineráng, uláp Janes káling Jambres yan ket tárák wawu kandák ingga káuráng wáinanyon. ");
INSERT INTO klt_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Iná kawu no ket tárák rina tángngátat wa kándáng hánám há naráng namelák wáina, wawu ámna náráwa rina yánáng tolingngátat, átnátna rina átnándat, Ánutu ya naráng háting mámá hára káto átnándat, pahán láláp hára átang yáup tángngátat, kámá ya nare kikiná hálengngátak, hang káto hálengga átang márapmá suwángngátat. Iná kák ku há narelák, hulá náuta ku no wáina tángngátat. ");
INSERT INTO klt_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Ámna yá ket tárák wáik rina táng namuráng me márapmá rina Antiok káin, Aikoniam káin me Listra káin suwut wawu ka há narelák. Enendu Táwi yá háláng namán du márapmá rina rina nák hára tunggafiuk wawu álo rewe átut. ");
INSERT INTO klt_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Pálipuk hánám, káman niyá Jesu Son Iháhá watyot tántápin átang Ánutu yan ket tárák wa isurin ingga táinek wawu ámna kámá yá ku táng lemlem táineráng. ");
INSERT INTO klt_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Iná ámna wáik táená yot ámna kusákngá watán mukmuro watá ku táwi hánám hálengga kuinek. Watá kámá yángyárungingngárát tu ámna nukngá yá yáni yángyárungineráng. ");
INSERT INTO klt_vpl VALUES ("T23_14","085_3_14","2TI","3","14","15","Iná kawu me wa kanáng toliumán wawu há naráng námelák, hang kawu nangge isikimo átulák waháranyon átang hulátingga papia káin Ánutu yan me uyená wa há narángga áwángga átkoelák, wata ku kák ku me rina kanená wa pálipuk hánám ingga há narulák wa káto tángga átkuinelák. Papia watá ku ámna náráwa nanará álosim yámán du Jesu Son Iháhá wata naráng háting mát Ánutu yá son ihánggoek. ");
INSERT INTO klt_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Ánutu yan me wawu Ánutu málámbáyon ámna yan nanará káin tin du wa uyiuráng, wata ku álo kámá háláng yámámáyan. Me watá ku me páliná wa yánáng tolinggoek, ámna kandák táená wa me táng yámánggoek, iháng tolingga iháng kándáng tinggoek, hang Ánutu yá tirik tárák álosim rina ta narek wa tátáya yánáng toktolik tánggoek. ");
INSERT INTO klt_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Wáina wata ku Ánutu yan me watá málámbán ámna náráwa wa háláng yámán tiyawingga átang gu yáup álosim hulá hulá wa táineráng. ");
INSERT INTO klt_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Jesu Son Iháhá yá son áwángga ku árená me kámurená wa me yáni narángga iháng horeinek. Rám wahára wu ámna náráwa kámuk hánám watán ámna hulá táwi hánám wáina hálengga átnek. Wáina wata ku Ánutu rahálá hára me Jesu rahálá hára no me káto hánám ing kanin, ");
INSERT INTO klt_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ko Táwi yan me wa há yánángguinelák, rám ámna náráwa yá kákkán me nanaráya heronge táineráng wahára, me táng taktak táineráng wahára me yánáná wata tiyawingga átnelák. Ámna náráwa yánángga iháng tolingga me táng yámángga iháng káto tángguinelák. Yolop hánám átang Táwi yan me káluná kándáng wahára re yánáng tolingguinelák. ");
INSERT INTO klt_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Me páliná wawu inggálu yon yánángguinelák, máriya kálu wawu ámna náráwa yá me páliná wa nanaráya taktak yámán yánin pahán kandák wa isutneráng. Yáni wu ámna máro yánát áwáng yáni me kusák rina nanaráya kikiná narángngátaráng wa yánáng tolit wa nanaráya heronge táineráng. ");
INSERT INTO klt_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Me páliná wa sárum imángga ku me pingnga kusák wa nanaráya heronge táineráng. ");
INSERT INTO klt_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Iná kawu rámá rámá nanaráka yá kándáng re árán átkukuka kándáng pinná tángga átkuinelák, márapmá yá áwinek wawu káto hálengga átkuinelák, ámna náráwa Táwi yan me pingnga álosim wa yánángguinelák, me Ánutu yá yáup rina rina tátáya kamuk wa kándáng hánám tángga átkuinelák. ");
INSERT INTO klt_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Wáina wu há táinelák, náuta nák ku kátkámut na rámá yá há hátewin átat. Sipna yá wáin kulit Táwi yan taha ya hangngátak wáina kulingga háinek. ");
INSERT INTO klt_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Erawáwá álosim wahára há erawáng háliut. Hururung kuku wahára hururung há kung háliut. Naráng hákhátik káluná wa kándáng hánám há pinná táut. ");
INSERT INTO klt_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Kulá nák ku hururung kut wawu kung sásáliná káin há kung hiut wata watán yumnakngá wawu tiyawing namáng san átak. Yumnakngá wawu Táwi yá nák ku kut ámna kándáng wa naminek. Yumnakngá wa naminek wawu Táwi yá ámna náráwa iháng káluná kándáng hára horeinek rám wahára. Wawu nák rewe muná, ináku kámá niyá málámbá hiták hálen kakaya pahán yot hánám átang háleng mángga átaráng wa hányon yáminek. ");
INSERT INTO klt_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Kálu kámá há hánám kang tunggap tángga ku nákkán káin sopmuná áwinelák. ");
INSERT INTO klt_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","No wáina kanet wawu náuta Demas wawu káwak kán kutná kutná wata narán kikiná hálengngátak, wata ku nák nepmangga it yáilá Tesalonaika káin há kuk, iná Kresens yá ku Galesia provins káin kun, Taitus yá ku Dalmesia provins káin kuk wata ingga ku wáina kanet. ");
INSERT INTO klt_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Nákáin du Luk ká rewe ku nákkot átamát. Ko ku Mak kangga káman sándi áwinemálák, náuta wawu no miti yáup tánggoet wahára háláng nanamáyan ámna álo kámá. ");
INSERT INTO klt_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Iná Tikikus wawu suring me Efesus káin kuk. ");
INSERT INTO klt_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Ko áwinelák wahára ku nákkán kolsiot hásák it táwi Troas káin Karpus yan it kinan uláp tingga sangga áwut wa tángga áwinelák. Hang papia na watyot ihángga áwinelák. Papia songgo kepmá yá iháng tolená wa hánám bu há ihángga áwinelák. ");
INSERT INTO klt_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Aleksenda wawu ain dá kutná kutná iháng tolingngátak ámna watá nák neháng wáik hánám táuk, wata ku máriya Táwi yá topmá wáinanyon táng lem táinek. ");
INSERT INTO klt_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Ámna watá Táwi yan me wa táng hang titiya táup hánám yáilá káto hálenggiuk, wata ku ko ámna wa hányon kándáng kangkang átkuinelák. ");
INSERT INTO klt_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","No me hára kung áwáng táut wata hulátitiná káin káman dá áwáng nákkot átang háláng namángga me kámá ma metáuk, ináku erek ingmen nepmangga kuráng. Wata no sáponga tángga watán kátu sasaya Ánutu inánggoet. ");
INSERT INTO klt_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Iná no me hára átut wahára ku Táwi málámbá nákkot átang háláng namuk hálendu me pingnga álosim wa kámuk hánám yánáng hále ámna náráwa ále kámá káinnan watá naruráng. Iná rám wa átut wahára wu Ánutu yá háláng namuk hálendu kámutnek ingga ma miuráng. ");
INSERT INTO klt_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Káyam bá ket tárák wáik rina wa nák sutna hára tánirot ingga Táwi yá nák há háláng namánggoek, wata ku nák ku álo átkuinet, hang neháng kung átkuku álosim alek káin átak wakáin tinek. Rámá rámá kutná meng tárut tángga átkuinemán. Wa pálipuk. ");
INSERT INTO klt_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Ko nákkán káe álo táng kung Prisila yot tu náulá Akuila yáninelák, hang Onesiforus yot málámbán it kinan átaráng wa nákkán káe álo hányon yáninelák. ");
INSERT INTO klt_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erastus wawu it yáilá Korin káin há átak, nákkot ma áwuk, iná Trofimus wu it táwi Miletus káin ilalák tángga árán sangga áwut. ");
INSERT INTO klt_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Kálu kámá há hánám kang tunggap tángga ku sopmuná áwinelák, wakáin átnárá kotkotná yot iruk táwi wata rámá yá áwiwon. Yubulus, Pudens, Linus, Klodia hang Táwi yan ámna náráwa nahára átaráng watá káe álo yáni sat kákkán da koek. ");
INSERT INTO klt_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Táwi yá pahán kamángga kákkán iruk kot átnek. ");
INSERT INTO klt_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Nák ku Pol, Ánutu yan yáup nangge, Jesu Son Iháháyan aposel. Ánutu yá ámna náráwa málámbán pingnga ya iháng tunggap táuk watán naráng hákhátik wa táng káto tátáya yáup namuk. Wáina háláng yáme watá me páliná wa narát me watá yángorán Ánutu yan kálu kándáng wa isutang átkuineráng. ");
INSERT INTO klt_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Yáni wu me páliná wa narángga Ánutu ya naráng háting mángga ku átkuku sásáliná muná wawu pálipuk há hánám táinemán ingga narángga hálengga átneráng. Ánutu ma kusák pilengngátak watá uláp pon hánám kutná kutná ma iháng tunggap táená átang gon málámbán átkuku wa há námámáya miuk. ");
INSERT INTO klt_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Wáina mengga ku rám há tiuk wa isutang gu málámbán me wa meng tunggap tátáya nák yáup namuk hálendu wahára kungga ku Ánutu yan me watá ámna náráwa yan káin hiták háliuk. Ánutu ámna náráwa nán son náhuk watá men du no yáup wa táut. ");
INSERT INTO klt_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Taitus, papia náwu no kákkán da uyingga se kung kamek. Kákkán naráng hákhátik Jesu hára átak wawu nákkán inanyon, wata ku kák ku nák nanggena ina. Nan náni Ánutu yot Jesu Son Iháhá ámna niyá son náhuk watá pahán kamán watán pahán láláp pá kákkot átnek. ");
INSERT INTO klt_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Rám no Krit sáut wahára, ko wakáin há átang gu yáup kátu ma táng háliumát wa táng hálinelák ingga kanángga ku kepmangga kut. Wáina wata ku ko it káman káman háranan miti yan ámna yáilá kámá iháng tunggap táinelák, uláp kanut wáina. ");
INSERT INTO klt_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Ámna yáilá ku ing árená kápángga iháng tunggap táinelák, ámna náráwa rahán yáni hára kandák kámá ma árená, áwáná káman yot re kándáng árená, ámna wáina wata nángánangge yáni wu Jesu re naráng háting mángga átang yáni tángga hangga hohoná yá ina tirik tárák kandák ma táená. ");
INSERT INTO klt_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Miti yan ámna yáilá ingga átaráng wawu Ánutu yan yáup wa pinná tángga átnándaráng. Wáina wata ku ámna náráwa rahán yáni hára kandák kámá ma árená. Niyá ámna yáilá átnek watá ku nák ku kutna táwi ingga narángga ámna náráwa raták ma pin yáni táindak, pahán káráp sokmuná ma táindak, umi káto yá táng hoho ma táindak, kun erawák ma táindak, hang sup iháháyan kálu, kálu kandák ma táindak. ");
INSERT INTO klt_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ináku ing átnek, kámá yá itná hára áwineráng wawu kándáng hánám pin yáni táinek, ket tárák álosim wata kikiná narángga átkukuná wa kándáng pinná táinek, hang kálu kándáng wa rewe isutang rongrongngá átang málámbán pahán dán kikiná kálu wa kándáng hánám pinná táinek. ");
INSERT INTO klt_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Táwi yan me páliná ináng toliumán wa káto tángga átang kándáng isutang átnek. Wáina tángga átnek watá ku málám háláng imán ámna náráwa me páliná wa kándáng yánáng tolingga pahán yáni iháng káto tán wa isutang átneráng, hang watá ku málám hányon háláng imán ámna yá me páliná wa táng hang tineráng wawu wáina meráng ingga há narángga me wa kandák meráng ingga yánángga iháng tolingguinek. ");
INSERT INTO klt_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ko ámna kanet wáinaná wa iháng tunggap táinelák wawu náuta ámna táup hánám watá milun yayali tángga me hánámá hánámá wa mengga ámna náráwa yángyárunginggoeráng wata. Ámna wáinaná wawu táwi hánám bu Juda ámna. ");
INSERT INTO klt_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Ámna wáinaná watá ket tárák ma tátáyan wa yánáng tolingga ku ámna náráwa táuppon naráng hákhátik yáni iháng yakyawák tángngátaráng. Wáina tángngátaráng wawu sup ihánin ingga wata. Wáina wata ku milun yáni pop tátá me ma metángguindaráng. ");
INSERT INTO klt_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Uláp Krit káinnan nanará ámna káman dá ing miuk, “Krit wawu ámna kusákngá rewe, ámna wáik hánám ang páyom ina. Sungi táwi hánám nanaya narángga táng taktak tángga átningngátaráng,” ingga miuk. ");
INSERT INTO klt_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Me wawu pálipuk hánám, wata ku me hátup kálu yánátá ku Jesu yan me páliná wa kándáng naráng hátineráng. ");
INSERT INTO klt_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Juda yan pingnga hánámá wata ma kárámating yámindaráng, hang ámna niyá Táwi yan me páliná wa sárum imángngátaráng watá yánin nanará hára meng rákit me kámá met watán me ma narindaráng. ");
INSERT INTO klt_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Ámna náráwa niyá Ánutu rahálá hára rongrongngá átneráng wawu ále umi sungi yáni watá wáinanyon árát álo ihineráng. Iná ámna náráwa niyá pahán yáni yá wáik hánám hálen átang Jesu ya ma naráng háting mindáráng wawu ále umi sungi yáni watá wáinanyon rongrongngá ma átnándáráng. Pahán nanará yáni yá wáik hánám hálengga árán wáina táemán me memán wawu kandák ingga ma naráng hátingngátaráng. ");
INSERT INTO klt_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Milun yáni yá ku Ánutu há naráng memán ingga mengngátaráng, enendu ket tárák yáni yá ku Ánutu sárum há imená hálengngátak. Wawu milun yayali ámna, watá ket tárák álosim kámá tátáyan tárák ku muná. Tirik tárák yáni wawu Ánutu yá kápángga takta narángngátak. ");
INSERT INTO klt_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Iná ko ku Ánutu yan me páliná wa kándáng hánám isutneráng ingga ámna náráwa yánáng tolingguinelák. ");
INSERT INTO klt_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Ko ku ámna tátáwi ing yáninelák, átkuku yáni wa kándáng hánám pinná tángguineráng, átnát yáni hára kándáng árát ámna náráwa yá kápát álosim hálen meng toling yámángguineráng, nanará álosim isutang átningguineráng, Ánutu yan me páliná hára naráng hákhátik kálu káto átkuineráng, kámá ya narát kikiná háhále wahára átkuineráng, hang káto átang márapmá susuwá wahára átkuineráng. ");
INSERT INTO klt_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Wáinanyon du náráwa tátáwi ing yánáng tolinelák, Ánutu tárang káin árát tu tirik tárák yáni watá ku wáina átamán ingga hiták meng tunggap tángguinek, nuknuk yáni ya ma meng yámáng kuindaráng, hang umi káto nanayan nanará watá átkuku yáni wa ma pinná táindak, ináku kálu rina ku álosim wa nuknuk yáni yánáng tolingga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Iná wáina há tángga átkuineráng watá ku náráwa máto álo yánáng totoliyan tárák. Kulá náráwa máto ing yánáng tolineráng, nánáun yáni me nángánangge yáni wa kápát kikiná háleinek, ");
INSERT INTO klt_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","átkuku yáni wa kándáng pinná tángga Ánutu rahálá hára rongrongngá átkuineráng, it yáni káin yáup rina rina átak wa kándáng tángga átkuineráng, nuknuk yáni ket tárák álosim wa yálengguineráng, hang nánáun yáni ya tárang káin átkuineráng. Wáina tángga árát tu káman dá Ánutu yan me wata me wáik ma meindák. ");
INSERT INTO klt_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Wáinanyon du ámna máto wa ing yánángga iháng káto táinelák, átkuku yáni wa kándáng pinná tángga átkuineráng. ");
INSERT INTO klt_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Ket tárák kámuk hára táinán du ka álosim wa tátá kahángga ku watá wáinanyon táineráng. Ko rám Ánutu yan me wa ámna náráwa yáninelák wahára me kusák ma meindalák, hang me wa táng kakarák hára ma yánáng tolindalák. ");
INSERT INTO klt_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Ko me kándáng wa rewe minelák wawu niyá keháng káyam tánggoeráng watá me meinelák wa narát kándáng re hálen rina kámá káman náni ya me wáik memeya reprepmá narineráng. ");
INSERT INTO klt_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Yáup nangge hánámá tirik tárák kán wa ing yánáng tolinelák, ámna hulá yáni yá rina meineráng wa rewe isutang tirik tárák álosim tángga árát tu heronge kápángguineráng. Ámna hulá yáni wa mátap yánin ma tángguindaráng. ");
INSERT INTO klt_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Ámna hulá yáni yan hára kutná kutná manek ma ihángguindaráng, ináku kándáng re árátne álosim náhineráng ingga narángga ku wáina átkuineráng. Wáina tát tu rina rina táineráng watá ámna náráwa iháng tárut tán Ánutu Son Nánáhá wata me menggoemán wawu narát páliná háleinek. ");
INSERT INTO klt_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Ánutu yá ámna náráwa nán pahán námuk wawu hiták há háliuk, wata ku ámna náráwa kámuk son álo náhinek. ");
INSERT INTO klt_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Ánutu yá pahán námuk watá ku kandák wa sárum imámáya nánáng tolinggoek, wawu ná, Ánutu sárum imámá, hang káwak nátán kikiná hulá hulá watá nanará náni pinná tátá. Iná Ánutu yá pahán námuk watá ku ing hányon nánáng tolinggoek, rám ná átamán háranyon nánin átkuku kándáng pinná tángga ket tárák náni yá kándáng árán Ánutu yan pahán káin átak wa isutnemán. ");
INSERT INTO klt_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Wáina tángga álosim bá nándán káin tunggafeinek wata háleinemán wawu Jesu yá son áwinek. Jesu Son Iháhá wawu Ánutu náni káto, ámna náráwa son nánáhá. Máriya wu málámbá yamá hálángngá pálak watyot son áwángga hiták háleinek. ");
INSERT INTO klt_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Jesu yá kandák kán kumbi kinan son náhángga mukmuro náni wa yanyawon da átkukuná wa sáuk, wata ku málámbán tombong hára rongrongngá hánám átang átkuinemán. Wáina átang gu ket tárák álosim wa heronge hára tángga átang átkuinemán. ");
INSERT INTO klt_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Kulá ko ku no me wa kanet wawu Jesu ya naráng háting mená ámna náráwa wa yánáng tolingguinelák ka naret. Iháng káto tángga yánátá me wa isutneráng, hang niyá wáina ma tát tu wa metáng yámángga iháng tolinelák. Kák ku wáina memeyan kutya pálak, wata ku ko yápmatá káman dá kákkán me náwu ále hánám ingga ma káindak. ");
INSERT INTO klt_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Jesu ya naráng háting mená wa ing yánángga árátá ku kapman me it tán ámna yáilá yáni wata tárang káin átang milun susuwá hára re átkuineráng, ket tárák álosim wa tátáya rámá rámá tiyawingga átkuineráng, ");
INSERT INTO klt_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","nangge nuknuk yáni ya ma meng yámindaráng, menmen ininán ma táindaráng, hang yáni tángga hangga ket tárák álosim wa rewe ámna náráwa kámuk yálengga átkuineráng ingga yánángga átkuinelák. ");
INSERT INTO klt_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Uláp nándu wáinanyon nanará álosim hára ma árená milun yayali hára re átkiumán. Ámna wáik watá nángnárungin watán milun wa isutkiumán. Mukmuro yan kumbi kinan árátne pahán tátárut tán ket tárák wáik kot tu sut tán kikiná hulá hulá watá átkuku náni wa pinná tángga átkiumálák. Káyam tátá yot kápáng naknarák wahára átkiumán. Kámá yá nán takta náhát nándá wáinanyon takta kápángga átkiumán. ");
INSERT INTO klt_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Wáina tángga átkiumán, enendu Ánutu ámna náráwa son nánáhá watá nánda kikiná narángga ku náháng álolo tángga ");
INSERT INTO klt_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","son náhuk. Wáina táuk wawu nándá ket tárák álosim tátne wata muná, ináku málámbáyon urák náni narángga ku wáina táuk. Wawu ing wahára kungga ku Ánutu yá son náhuk, Iruk Káungá yá náháng yawolán nangge kongakngá yá ina átkuku mirak táumán wahára. ");
INSERT INTO klt_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Jesu Son Iháhá, ámna ni nán son nánáhá, watán yáup hára kungga ku Ánutu yá Iruk Káungá watán háláng táwi wa kulin nándán káin háuk ngá nányot átkoek. ");
INSERT INTO klt_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Ánutu yá pahán námán málámba rahálá hára ámna náráwa kándáng átkoemán. Kulá kálu wahára kungga ku Ánutu nángánangge háliumán hálendu átkuku sásáliná muná wa tátáya hálengga átkoemán wa táinemán. ");
INSERT INTO klt_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","No me wa uying kamet wawu pálipuk ingga narángga ku Jesu ya naráng háting mená wa me wawu táwi hánám ingga yánángguinelák. Yánátá ku niyá Ánutu pálipuk ingga nareráng watá ku káto hálenggatang ket tárák kándáng wa tángga átkuineráng. Ket tárák wáina wawu álosim hánám, niyá wa isutnek wawu watá álo háláng iminek. ");
INSERT INTO klt_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Iná ko ku me kandák ing wata ma kárámating yámindalák, hánámá hánámá menmen ininán tátá, táwi ilom yáni kut yáni wata ingga mengga kuku, me Moses yan meng rákit me wata menmenná. Me hánámá hánámá wáina watá manyon háláng námindák. ");
INSERT INTO klt_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Iná ko katá káman dá ámna náráwa iháng hohoreya tán du ket tárák wáina ma táindalák ingga kándáng hánám ininelák. Iná kákkán me wa ma narán wawu son ininelák, hang kákkán me wa rám yará ma narán du ámna wáinaná wawu sárum iminelák. ");
INSERT INTO klt_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Ko ku ing narinelák, ámna wáinaná wawu káráp henghentongngá ina mukmuroná táwi hánám bá átak. Málámbán átkuku kandák watá yon du táng me hára há ting san átak. ");
INSERT INTO klt_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","No Atemas káling Tikikus waháranan káman suring me kákkán káin kung hinek rám waháranyon du ko áwángga it táwi Nikopolis káin nák nanaháya kálu kámá há hánám kang tunggap tángga ku wakálu áwinelák. Iruk kot kotkotná rámá wawu nák ku wakáin kung átnát ta naret. ");
INSERT INTO klt_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Apolos káling lo yan nanará ámna Senas watá kálu kukuya tán du kálu yan kutná kutná wa háláng yáminelák ka ku kálu káin kutná kutná ya kesák ma táindámálák. ");
INSERT INTO klt_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Ko ku ámna náráwa náni ing yánáng tolinelák, káto hálenggatang ket tárák kándáng wa tángga átkuineráng wahára ku nuknuk yáni niyá kutná kutná náut hánám ba kesák tát wa álo háláng yámát tu ket tárák yáni yá ku páliná álosim sángga átkuinek. ");
INSERT INTO klt_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Ámna náráwa nákkot átaráng watá káe álo yáni sat kákkán da koek. Kulá ko ku nándán káe álo wa ni Jesu naráng háting mángga nánda kikiná naráng námángga átkoeráng wa yáninelák. Ánutu yá sán kámuk pahán sáminek. ");
INSERT INTO klt_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Nák ku Pol, Jesu Son Iháhá watán yáup tánggoet wata neháng kalabus kinan ting sat átkoet. No papia ná uye nuk náni Timoti yot sate Filemon kákkán káin koek. Kák ku nát nuk náti hánám, nát tá miti yáup rina tánggoemát wáinanyon tánggoelák. ");
INSERT INTO klt_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Nátán heronge me yá málám náni Apia yan káin koek, me yáup náni káman táená Akipus ni tewe ámna yá ina hánghálángngingga erawángngátaráng tárák wáinanyon du miti yáup tánggoek watán káin hányon koek, hang miti ámna náráwa kákkán it káin áwáng miti ya hangngátaráng watán káin hányon koek. ");
INSERT INTO klt_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Nan náni Ánutu yot Táwi Jesu Son Iháhá watá pahán sámán pahán láláp watá sányot átnek. ");
INSERT INTO klt_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","No sáponga táng kamánggoet wahára wu kákka ingga Ánutuna heronge me inángga átkoet. ");
INSERT INTO klt_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","No wáina tángga átkoet wawu kámá yá ing met naránggoet, kák ku Táwi Jesu ya naráng háting mánggoelák, me Ánutu yan ámna náráwa wata kikiná hánám naráng yámánggoelák. Wáina met naránggoet wata ku Ánutu heronge me inángga átkoet. ");
INSERT INTO klt_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","No Ánutu yan káin ing sáponga tánggoet, kák ku nányot Jesu Son Iháhá wata naráng hákhátik táng mámá wakálu kámuk náni átnemán. Wáina átang naráng hákhátikka watá ku nanará álosim táng tunggap táng kaminek, me iruk kán kálu nanará álosim kámuk Jesu yá námánggoek wa hiták káinelák. Wata hánám sáponga táng kamánggoet. ");
INSERT INTO klt_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Nukna, ko kámá ya kikiná naráng yámángga ket tárák álosim yálenggoelák wahára kungga ku Ánutu yan ámna náráwa watán pahán wa son táng káto tánggoelák. Ko wáina tánggoelák kálu wahára ku nák pahánna táng káto tátá no heronge táwi hánám naránggoet. ");
INSERT INTO klt_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Wáina wata ku ko náut kámá káman táinelák wata naret. Wa táinelák wawu álo kámá. Nák ku Jesu Son Iháhá watán aposel máta yáyáre ámna, wata ku no wáina táng ingga kanánggem, enendu no wáina táng ingga ma kanindát. ");
INSERT INTO klt_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Ináku no há naret tu nangge nukka kikiná naránggoelák, wata ku no me láláp hára kanindet. Nák ku Pol, ámna tátáwi há hálet me nák ku ámna ni Jesu Son Iháhá watán yáup tánggoet wata neháng kalabus káin ting sat átkoet wa. ");
INSERT INTO klt_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","No me láláp hára ing kanindet wawu ko ket tárák káman Onesimus ya táng minelák ka naret. Neháng kalabus kinan tiuráng wata torong hára Onesimus yá nákkán káin áwán Jesu yan me pingnga álosim ine Ánutu yan káinnan átkuku mirak táuk, wata ku nák nanggena ina háliuk. ");
INSERT INTO klt_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Uláp Onesimus yá kák háláng kakamáya yáup kándáng ma tánggiuk, iná inggálu ku watán tirik tárák álosim watá kák me nák álo háláng námámáyan tárák hálengga átak. ");
INSERT INTO klt_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","No Onesimus ya pahánna kikiná hánám naret, enendu kákkán káin son suring me áwek. ");
INSERT INTO klt_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Jesu yan me pingnga álosim yánánggoet wata ingga neháng kalabus káin ting sat átkoet, wata ku no Onesimus yá nákkot átang kákkán kome tángga nák háláng namángga átgim ingga naret. ");
INSERT INTO klt_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Wáina naret enendu no kane ko álo ingga nananáyan káluná ku muná, wata ku no suring me kákkán káin son áwek. Ko rina tátáyan wawu no wáina táng ingga ma kanindát, ináku ko nák pahánna táng heronge táinán du rina táinelák wawu ko kangán nanará isutang táinelák. ");
INSERT INTO klt_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Kámá Ánutu yá narán hám Onesimus yá kepmangga kung rám isikimo átuk. Wáina hálen wawu wata hulá ku ing, Onesimus yá Jesu ya naráng háting mángga ku son kákkán káin áwángga rámá rámá Filemon kákkot átkuinek. ");
INSERT INTO klt_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Kákkán káin son áwán du ko wa katá yáup nangge hánámá re ina ma háleindak. Watá ku yáup nangge hánámá wa iháng hátingga áráng árená ina háliuk, wawu Jesu ya naráng háting mená, wata ku ko wa katá nukka ina hálendu kikiná káinelák. No wa kanggoet tu nukna hánám hálendu no pahán imánggoet, iná ko ku no pahán imánggoet wa táng hátingga pahán táwi hánám iminelák. Onesimus yá yáup nangge hánámá yan yáup wa tángga átkuinek wawu álo kámá ingga kangga heronge narángguinelák, hang Táwi Jesu hára wawu katá ku nukka hálendu kikiná káinelák. ");
INSERT INTO klt_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Wáina wata ku ko nák nahátá nukka Jesu yan yáup káman tángngátamát hálendu Onesimus son táinelák wawu nák nehánggim tárákngá ku wáinanyon hánám táinelák. ");
INSERT INTO klt_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Onesimus yá kákka kandák kámá táng kamuk hálen wawu no kangga táng tolinet, me kákkán hára náut kámá káman táuk hálendu wata topmá ku no kaminet. ");
INSERT INTO klt_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Nák ku Pol nayon ketna yá kolem ná uyingga kanet. Topmá ku no álo kaminet. Ko ku ing narinelák, ko nákkán káin topmá nanamáyan hányon átak, ko topmá nanamáyan wawu no Táwi yan me pingnga álosim wa kane ko átkuku mirak táulák. Ko wata kalot yamiwon. ");
INSERT INTO klt_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Nukna, ko Táwi kutná hára no rina kanet wa wáina táinelák ingga naret. Nát tu Jesu Son Iháhá watán ámna yá átamát, wata ku rina kanet wáina tángga ku nák pahánna son táng káto táinelák. ");
INSERT INTO klt_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","No ing há naret, ko nákkán me há isutnelák, wata ku papia ná uying kamet. Pálipuk ing há naret, ko tárák álosim wata táng minelák wawu no rina kanet wa táng hátingga táng minelák. ");
INSERT INTO klt_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","No me nukngá kámá kanindet wawu ing, no ing hánám há narángga átat, Táwi yá sándán me sáponga narán hálendu no sándán káin son kuinet. Wata ku ko itya kinan it pahálá káman nákkán da tiyawingga satá átnek. ");
INSERT INTO klt_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Ámna Epafras wawu nákkot kalabus káin káman átkoemát, Jesu Son Iháhá watán me pingnga álosim mengngátak wata. Ámna watá sándán káin káe álo meng san áwek. ");
INSERT INTO klt_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Me hang yáup nákkot káman táená átaráng, Mak, Aristakus, Demas yot Luk watá sándán káin káe álo yáni hányon meng sat áwek. ");
INSERT INTO klt_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Táwi Jesu Son Iháhá watá pahán sámángga iruk sáni yot átnek. ");
ALTER TABLE klt_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
