﻿USE sofia;
DROP TABLE IF EXISTS sofia.klg_vpl;
CREATE TABLE klg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES klg_vpl WRITE;
INSERT INTO klg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ini ya tultulanen sa manga tyugbulan ni Jisu-Kristu: Si Jisus lekat adti buwadbuwad na hari' na si Dabid, aw si Dabid lekat adti buwadbuwad ni Abraham. ");
INSERT INTO klg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na, si Abraham, yan ya ama ni Isaak, aw si Isaak, yan ya ama ni Jakub. Aw si Jakub, yan ya ama ni Juda aw manga inulug nan. ");
INSERT INTO klg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda, yan ya ama ni Paréz aw si Zéra na pingin na alag eseg. Si Tamar ya ina nilan. Aw si Paréz, yan ya ama ni Hézron, aw si Hézron, yan ya ama ni Aram. ");
INSERT INTO klg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram, yan ya ama ni Aminadab, aw si Aminadab, yan ya ama ni Na-asyon. Aw si Na-asyon, yan ya ama ni Salmon. ");
INSERT INTO klg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Aw si Salmon, yan ya ama ni Boaz. Aw ya ina ni Boaz si Rahab. Aw si Boaz, yan ya ama ni Obéd. Aw ya ina ni Obéd si Ruth. Si Obéd, yan ya ama ni Jési, ");
INSERT INTO klg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","aw si Jési, yan ya ama ni Dabid. Aw si Dabid nya-imo' hari' na banwa na Isra-él. Aw si Dabid, yan na ama ni Solomon magi sa ka͡ubayan ni Uriyas. ");
INSERT INTO klg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon, yan ya ama ni Robowam, aw si Robowam, yan ya ama ni Abiyas. Aw si Abiyas, yan ya ama ni Asa. ");
INSERT INTO klg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aw si Asa, yan ya ama ni Josapat, aw si Josapat, yan ya ama ni Joram. Aw si Joram, yan ya ama ni Usiyas, ");
INSERT INTO klg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","aw si Usiyas, yan ya ama ni Jotam. Aw si Jotam, yan ya ama ni Akas, aw si Akas, yan ya ama ni Hézékyas. ");
INSERT INTO klg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aw si Hézékyas, yan ya ama ni Manasés, aw si Manasés, yan ya ama ni Amon. Si Amon, yan ya ama ni Josiyas, ");
INSERT INTO klg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","aw si Josiyas, yan ya ama ni Jékonyas aw ya manga mangkangud nan. Na, dun ni manga allaw nilan, ya madég na manga utaw na sakup na Juda pigtaban na manga taga Babiloniya. ");
INSERT INTO klg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aw dun ni banwa yan, si Jékonyas ya ama ni Salati-él. Aw si Salati-él, yan ya ama ni Zérubabél. ");
INSERT INTO klg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aw si Zérubabél, yan ya ama ni Abiyud. Aw si Abiyud, yan ya ama ni Éliyakim, aw si Éliyakim, yan ya ama ni Azor. ");
INSERT INTO klg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor, yan ya ama ni Zadok, aw si Zadok, yan ya ama ni Akim. Aw si Akim, yan ya ama ni Éliyud, ");
INSERT INTO klg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","aw si Éliyud, yan ya ama ni Éliyazar. Si Éliyazar, yan ya ama ni Matan, aw si Matan, yan ya ama ni Jakub. ");
INSERT INTO klg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aw si Jakub, yan ya ama ni José, aw si José, yan ya eseg ni Maria. Aw adti kan Maria ka͡utaw si Jisus. Aw si Jisus, yan ya pigtawag na Misiyas. ");
INSERT INTO klg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yanagaw awun sampulu' tag upat ka alintuwad ya buwadbuwad lekat kan Abraham menda' adti kan Dabid. Aw awun sampulu' tag upat uman ka alintuwad ya buwadbuwad lekat kan Dabid menda' sa allaw na pigtaban na manga taga Babilonya ya manga utaw na Juda. Aw awun sampulu' tag upat ka alintuwad lekat na allaw na pagtaban menda' sa pagka͡utaw na Misiyas. ");
INSERT INTO klg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ini ya nya-imo' dun ni pagka͡utaw ni Jisu-Kristu: Ya ina nan si Maria na tawas ni José. Manang sa wala' pa silan pag-ipid, kya-ede-an da ni Maria na nyabdes sakanan magi sa Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na, si José gayed sakanan dyumalug sa Uldin na manga Judiyu. Aw dili' sakanan malim na mulamula͡en ya tawas nan adti asdangan na manga utaw. Yanagaw migpalpa sakanan na atagan nan na papilis sa pag-ayaw na wala' ya utaw na maka-ede'. ");
INSERT INTO klg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Manang sa gayed pa nan yeiy pig-anenganeng, awun anghil na Tyumanem na migpakita' kanan magi sa tagaynep aw law nan, “We... José na buwadbuwad ni Dabid. Dili' kaw magduwaduwa magpanga͡ubayan kan Maria. Kay ya pagkabdes nan, magi saba sa Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aw ka͡utawan sakanan sa ise' na eseg. Aw ngalanan mu ya ise' na ‘Jisus’ kay un nan paluwa-en ya kanan manga utaw lekat adti manga sala' na mig-allang kanilan.” ");
INSERT INTO klg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, dun ni kadég yeiy na nya-imo', nyatuman da ya pigpasulat na Tyumanem magi sa propita nan asini muna: ");
INSERT INTO klg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pakanyegi! Awun sambuk na dalaga na mabdes pangkay wala' pa ka-ilabeti, aw mag-ise' sakanan sa ise' na eseg aw pagtawagen nilan sakanan na Imanwél na ya kakawasan: Ya Tyumanem asini sayid tadun.” ");
INSERT INTO klg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sa pagmata ni José, pigtuman nan ya piglong kanan na anghil, aw pigpanga͡ubayan nan si Maria. ");
INSERT INTO klg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Manang wala' pa nan ipidi menda' na kya͡utawan da si Maria sa ise' nan na eseg. Aw pigngalanan ni José ya ise' yeiy na “Jisus.” ");
INSERT INTO klg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aw sa pagka͡utaw da ni Jisus adti Bitléhém na sakup na Judiya, si Hérodés ya hari' dun ni manga allaw yan. Aw awun manga utaw na lekat adti silatan na dyumateng dun ni syudad na Jérusalim, aw to-o dakula' ya kya-ede-an nilan sa manga bitun. ");
INSERT INTO klg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Aw nyusip silan, “Ayin ya ise' na nya͡utaw na un ma-imo' hari' na manga Judiyu? Kay kyinita' nami ya kanan bitun adti silatan na yan ya pangilala sa pagka͡utaw nan. Yanagaw nyadi kami kay un nami sakanan simba͡en.” ");
INSERT INTO klg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sa pagdengeg ni Hérodés sa piglong nilan, wala' katingen ya anenganeng nan, aw maynan uman ya manga utaw dun ni Jérusalim. ");
INSERT INTO klg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yanagaw pigpatawag nan ya kadég na manga mangkatas na magdadugsu-ay aw ya manga magpalna-uway uman sa Uldin na manga Judiyu. Aw pig-usip nan silan kun ayin ka͡utaw ya Misiyas. ");
INSERT INTO klg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aw tyumubag silan kanan, “Adti Bitléhém, sakup na Judiya. Yeiy ya pigpasulat na Tyumanem magi sa propita nan: ");
INSERT INTO klg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ikaw kay Bitléhém na sakup na Juda, pangkay tagbi' ya dengeg mu adun asuntu na tagbi' kaw na baranggay, manang kagaya moli na allaw to-o magkatas ya dengeg mu adti manga migdumala sa manga utaw na Juda. Kay dun ni kanmu ka͡utaw ya sambuk na un ma-imo' magdumala na dayaw magdiyaga sa kanak manga utaw na Isra-él, kasiling na magdadiyaga͡ay sa manga karniro.” ");
INSERT INTO klg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sa pagdengeg ni Hérodés sa tubag nilan, pigpatawag nan ya manga utaw na lyumekat adti silatan na wala' ya nyaka-ede', aw pig-usip nan silan kun kanu nilan tagna' kita-a ya bitun yan. ");
INSERT INTO klg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatigkas yan, pigpakadtu silan ni Hérodés adti Bitléhém aw piglongan nan silan, “Kadtu la kamu aw paninawa mayu ya ise'. Kun kita-en da mayu, liku' kamu adi aw ubati aku mayu pada madtu aku uman aw magsimba kanan.” ");
INSERT INTO klg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na, sa pagdengeg nilan sa piglong ni Hérodés, nyanaw da silan. Aw sa talana nilan nyanaw, kyinita' da nilan uman ya bitun na migma-una kanilan, menda' na tyumeneng dun ni tas na pig-eya-an na ise'. ");
INSERT INTO klg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aw sa pagkita' nilan sa bitun yan, to-o silan migleya. ");
INSERT INTO klg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aw sa pagseled nilan adti balay, kyinita' nilan ya ise' eped ni Maria na ina nan. Aw lyumuhud silan adti asdangan na ise' aw pigsimba nilan sakanan. Aw pagkatigkas yan, pig-uwangan nilan ya kanilan manga kaban aw pigkamang nilan ya kanilan dala͡enen sa ise': bulawan, aw manga lana na mangkanimbo' na pigngalanan na insénso aw mirra na alag to-o dakula' ya alaga'. ");
INSERT INTO klg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aw pigpa-ede' silan na Tyumanem magi sa tagaynep na dili' silan lumiku' adti kan Hérodés. Yanagaw dun ni pag-uli' nilan, wala' da silan agi adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na, sa wala' da dun ya manga utaw na lekat adti silatan, awun anghil na Tyumanem na migpakita' kan José magi sa tagaynep, aw miglong ya anghil, “Kay José, pagbangun kaw aw pa-agadan ya ise' aw ya ina nan aw palaguy kamu adti banwa na Ihiptu! Aw pag-eya' pa kamu dun menda' na paglongun ta kaw. Kay un ni Herodes papaninaw ya ise' pada patayen.” ");
INSERT INTO klg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aw maksay migbangun si José, aw pigpa-agad nan ya ise' aw ina aw nyalaguy silan na gabi yan adti Ihiptu. ");
INSERT INTO klg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aw nyatingen pa silan dun menda' na nyatay da si Hérodés. Aw nyatuman ya pigpasulat na Tyumanem magi sa sambuk na propita nan asini muna na miglong, “Pigpatawag ku ya kanak Ise' lekat dun ni Ihiptu.” ");
INSERT INTO klg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na, pagka-ede' ni Hérodés na pig-akalan sakanan na manga utaw na lekat adti silatan, to-o sakanan nyadaman. Manang kya-ede-an nan lekat adti kanilan kun kanu ya tagna' na pagkita' nilan sa bitun. Yanagaw pigsugu' nan ya kanan manga sundalu adti Bitléhém na un pamatayen ya kadég na ise' na eseg na wala' pa dateng adti duwangka͡umay dun ni Bitléhém aw banwa na nyakapalibed dun. ");
INSERT INTO klg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aw yanagaw nyatuman ya pigpasulat na Tyumanem asini muna magi sa propita nan na si Jérémiyas: ");
INSERT INTO klg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dyengeg ya pagsasugaway dun ni banwa na Ramah. Madég ya manga migpansi-engge' aw migpansimatay, kay to-o pigsugawan na buwadbuwad ni Rakél ya manga mangayse' nilan. Aw dili' silan malim lala͡en kay pyangkamatayan beg silan sa mangayse' nilan.” ");
INSERT INTO klg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, dyumateng ya allaw na nyatay da si Hérodés, aw migtagaynep da uman si José adti banwa na Ihiptu aw migpakita' kanan ya anghil na Tyumanem, ");
INSERT INTO klg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aw miglong ya anghil kanan, “Kay José, pagbangun kaw aw pa-agadan ya ise' aw ya ina nan, aw uli' kamu adti banwa na Isra-él. Kay nyatay da ya utaw na un galu magpatay sa ise'.” ");
INSERT INTO klg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yanagaw nyindeg si José aw pya-agad nan ya ise' aw si Maria, aw nyuli' silan adti banwa na Isra-él. ");
INSERT INTO klg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Manang pagpakadateng da nilan dun ni Isra-él, wala' da silan dun pag-eya' adti probinsya na Judiya. Kay dyengeg ni José na si Arkilaw ya nyakasayu sa ama nan na si Hérodés sa pagdumala sa Judiya, yanagaw nyallek si José meya' dun. Aw awun pigpa-ede' kanan na Tyumanem magi sa tagaynep. Yanagaw lyumiku' silan baling adti probinsya na Galilya ");
INSERT INTO klg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","aw dun da silan pag-eya' ni lunsud na Nazarit. Aw nyatuman ya pigpa-ede' na manga propita na si Jisus pagtawagen na Nazaritiyanen. ");
INSERT INTO klg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Paglabay da na madég na umay, si Juan na Magba͡utismuway migpalekat mig-ubat-ubat adti kaligbinan dun ni probinsya na Judiya, aw miglong sakanan adti manga utaw, ");
INSERT INTO klg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pagselsel kamu sa manga sala' mayu! Kay ya Paghari' na Tyumanem sa Kasakupan nan malapit da.” ");
INSERT INTO klg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan saba ya pyalabet asini muna na propita na si Isayas na miglong, “Awun utaw na magtatawag adti kaligbinan. Aw yeiy ya un nan paglongun: ‘Tagilana mayu ya un agiyan na kanaten Tyumanem! Pakadyawa mayu ya dalan na un nan agiyan!’ ” ");
INSERT INTO klg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na, ya pigsut ni Juan pig-imo' lekat adti bulbul na kamilyo, aw ya elen nan uman lekat adti kindal na baka. Aw ya kanan pagkanen, yan ya dulun aw dega'. ");
INSERT INTO klg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aw madég ya utaw na nyadtu ni kan Juan na lekat adti Jérusalim aw ya kadakula' na probinsiya na Judiya aw kadég na banwa na nyakapalibed adti tubig na Jordan. ");
INSERT INTO klg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aw pig-ubat nilan ya kanilan manga sala' adti Tyumanem aw pigba͡utismuwan silan ni Juan dun ni tubig na Jordan. ");
INSERT INTO klg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Manang dyumateng dun uman ya madég na utaw na Parisiyo aw Sadusiyo pada magpaba͡utismu silan kan Juan. Aw sa pagkita' nan kanilan, pig-usip nan silan, “Singalan ka' ya miglong kamayu na makapalaguy kamu lekat adti pa-emel-emel na Tyumanem na malapit da dumateng? Ya bet mayu, kasiling saba na bet na kamugung na gayed maggaway! ");
INSERT INTO klg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kun kaliman mayu makaluwa' dun ni pa-emel-emel na Tyumanem, pakita͡an mayu ya bunga na kamayu pagselsel. ");
INSERT INTO klg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Unu ka', mig-anenganeng kamu na dili' kamu nan pa-emel-emelen asuntu na buwadbuwad kamu ni Abraham? Paglongun ta kamu: Mabatug saba na Tyumanem ya pag-imo' sa manga batu ini na palangad mangayse' ni Abraham na un pagsayu kamayu! ");
INSERT INTO klg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aw pangkay adun, pigtagilan da ya palakul na un pagsakap sa manga kawuy na wala' pamunga sa madyaw, aw agbel adti atulun. ");
INSERT INTO klg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aku ya magba͡utismu kamayu magi sa tubig na yan ya pangilala na migselsel da kamu sa kamayu manga sala'. Manang awun pa sambuk na makamoli kanak, aw yan ya magba͡utismu kamayu sa Ispiritu Santo aw atulun. Yan ya to-o pa kanak matas, aw dili' aku makatumbuk kanan. Pangkay ya sandal nan dili' aku umba' magbitbit. ");
INSERT INTO klg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aw dun ni pag-ukum nan, taniyen nan ya kanan manga utaw, kasiling saba na utaw na migbulus sa trigu. Magi dun ni pagbulus nan, matani ya tipig aw matani uman ya awun seled. Panimunun nan ya awun seled aw dayaw betang adti pul. Manang ya tipig, ubusun nan panimunun aw asag adti atulun na dili' pagkapatayan.” ");
INSERT INTO klg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Talana ni Juan migba͡utismu sa manga utaw dun ni tubig na Jordan, dyumateng si Jisus lekat adti banwa na Galiliya na un magpaba͡utismu kanan. ");
INSERT INTO klg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Manang si Juan dili' galu malim magba͡utismu kan Jisus, aw miglong sakanan, “Aku galu ya ka-ilangan ba͡utismuwan mu. Ananga' na ikaw da baling ya ba͡utismuwan ku?” ");
INSERT INTO klg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aw tyumubag si Jisus kanan, “Imo-a la adun yeiy, pada matuman ya piglong na Tyumanem.” Yanagaw tyumande' si Juan, aw pigba͡utismuwan nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatigkas na pagba͡utismu kan Jisus, tyumaklang sakanan lekat adti tubig. Aw tigkan nyabeka' ya langit. Aw kyinita' nan ya Ispiritu Santo na lekat adti tas na kasiling na kalupati na maputi' na lyumugsad adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aw awun tingeg na lekat adti tas na langit na miglong, “Yeiy saba ya kanak Ise' na to-o ku pigginawa͡an, aw to-o aku kyatutukan kanan.” ");
INSERT INTO klg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatigkas yan, pigpa-agad na Ispiritu Santo si Jisus adti kaligbinan na laganasen pada tanda-en ni Satanas. ");
INSERT INTO klg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aw migpuwasa si Jisus seled na kapatan ya allaw aw kapatan ya gabi, aw pagkatigkas yan, to-o sakanan nyagetem. ");
INSERT INTO klg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yanagaw, dyumulud kanan si Satanas aw piglongan nan, “Kun Ise' kaw na Tyumanem, na, paglonga ya manga batu ini na ma-imo' pan.” ");
INSERT INTO klg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Manang tyumubag si Jisus kanan, “Ini ya pigpasulat na Tyumanem: ‘Beke' olo' na kakan ya makamataw sa utaw. Manang ya tengteng makamataw sa utaw, yan ya kadég na manga tingeg na piglong na Tyumanem.’ ” ");
INSERT INTO klg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatigkas yan, pigpa-agad ni Satanas si Jisus adti Jérusalim na yan ya pigtani la dadan na Tyumanem na kanan syudad. Aw pigpa-indeg nan adti katasan na Témplo. ");
INSERT INTO klg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aw piglongan nan si Jisus, “Kun Ise' kaw na Tyumanem, kawas kaw adti dalem, kay yeiy ya pigpasulat asini muna: ‘Sugu-un nan ya kanan manga anghil adti kanmu na salu-un kaw nilan pada dili' kapali-an ya manga siki mu na batu.’ ” ");
INSERT INTO klg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aw tyumubag si Jisus, “Pigpasulat uman na Tyumanem: ‘Dili' mu pagtanda-en ya Tyumanem na kanmu Pangulu.’ ” ");
INSERT INTO klg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pigpa-agad da uman ni Satanas si Jisus adti to-o matas na buntud aw pigpatandaw kanan ya kadég na kasakupan asini tas na lupa' dala ya kanenggeya nilan. ");
INSERT INTO klg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aw piglongan nan, “Kun lumuhud kaw aw magsimba kanak, atag ku kanmu ya pagdumala sa kadég yeiy.” ");
INSERT INTO klg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Manang tyumubag si Jisus, “Kay Satanas, pagpakawat kaw kanak! Pigpasulat da saba: ‘Ya Tyumanem na kanmu Pangulu, yan olo' ya kanmu simba͡en aw yan ya kanmu ka͡agadan.’ ” ");
INSERT INTO klg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yanagaw pig-indegan ni Satanas si Jisus. Aw dyumateng adti kan Jisus ya manga anghil, aw pigsanggila' nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, sa pagdengeg ni Jisus na pigdakep aw nyakalabusu si Juan, pig-indegan nan ya banwa na Judiya aw nyuli' sakanan adti Galiliya. ");
INSERT INTO klg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tigkas yan, pig-indegan nan uman ya lunsud na Nazarit aw adtu la sakanan pag-eya' ni lunsud na Kapirna-um. Na, ya Kapirna-um malapit adti dulug na dakula' na Danaw na Galiliya, dun ni banwa na pig-eya-an asini muna na manga buwadbuwad ni Zébulun aw ni Néptali. ");
INSERT INTO klg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aw dun da katuman ya pigpasulat na Tyumanem asini muna magi sa propita nan na si Isayas: ");
INSERT INTO klg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ya manga nyeya' adti manga banwa na Zébulun aw Naptali, dala ya adti kilid na ‘Dalan na Pasinan adti Dagat,’ aw adti dipag na tubig na Jordan apit adti silatan, aw pangkay ya pig-eya-an na manga Héntil dun ni banwa na Galiliya, ");
INSERT INTO klg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kasiling na nyeya' silan dun ni kangitngitan, kay wala' ya Tyumanem adti kanilan. Idtu na muna, wala' da ya pag-iman nilan. Yan da olo' ya pigtagadan nilan ya kamatayen. Manang adun, syumilat da adti kanilan ya bagu na kalalamdag.” ");
INSERT INTO klg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na, dun ni manga allaw yan, migpalekat si Jisus mig-ubat-ubat na maglong: “Pagselsel kamu! Kay ya Paghari' na Tyumanem sa Kasakupan nan malapit da.” ");
INSERT INTO klg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na, sambuk na allaw, nyanaw si Jisus adti baklayan na Danaw na Galiliya, aw kyinita' nan si Simon na pigngalanan uman na Pédro aw ya inulug nan na si Andrés. Nyamiyala silan adti danaw, kay mangisda-ay saba silan. ");
INSERT INTO klg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aw miglong si Jisus adti kanilan, “Agad kamu kanak kay imo-un ta kamu mangisda-ay sa manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aw maksay nilan pig-ayawan ya kanilan manga biyala, aw nyagad silan kanan. ");
INSERT INTO klg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aw migpadeleg si Jisus nyanaw adti baklayan na danaw, aw kyinita' pa nan uman si Santiago aw ya inulug nan na si Juan. Pig-uman nilan ya kanilan manga biyala dun ni seled na balangay, eped nilan ya kanilan ama na si Zibidiyo. Aw piglongan ni Jisus ya duwa ya maylug, “Agad kamu kanak!” ");
INSERT INTO klg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aw maksay nilan pig-ayawan ya kanilan talabahu dun ni balangay aw ya ama nilan, aw nyagad silan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, piglegeb ni Jisus ya kadakula' na Galiliya, aw migpalna-u sakanan dun ni manga sinagoga. Aw pigpa-ede' nan adti manga utaw ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem. Aw pigpangguli' nan uman ya kadég na manga magkedel na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yanagaw nyabekkal ya dengeg nan pangkay adti banwa na Sirya, aw pigpandala adti kanan ya madég na utaw na pyangkedelan aw ya manga to-o pyangkatigda-an, aw manga utaw na syeledan na busaw, aw ya manga gayed pigtakigan, aw manga pulid aw manga kapig. Aw pigguli' ni Jisus ya kadég nilan. ");
INSERT INTO klg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aw to-o madég ya manga utaw na dyumalug kanan na lekat adti Galiliya, aw ya eped lekat adti Dékapolis, aw adti Jérusalim, aw adti Judiya, aw manga banwa adti dipag na tubig na Jordan. ");
INSERT INTO klg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sa pagkita' ni Jisus sa to-o madég na manga utaw na dyumalug kanan, tyumukud sakanan tagbi' dun ni buntud aw nyingkud dun. Aw dyumulud uman ya kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aw pigpalekat nan ya pagpalna-u kanilan, miglong sakanan, ");
INSERT INTO klg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Madyaw ya kana manga utaw na nyaka-ede' na kun wala' ya Tyumanem wala' ya mabatug nilan. Kay nyaka-akup da silan adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Madyaw ya kana manga utaw na migkalat ya ginawa nilan adun, kay lala͡en saba silan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Madyaw ya kana manga utaw na gayed migpadalem, kay matagtun nilan ya kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Madyaw ya kana manga utaw na migtibagseg dyumalug sa pagkaliman na Tyumanem. Kay tabangan nan saba silan pada matuman ya kanilan pigtibagsegan. ");
INSERT INTO klg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Madyaw ya kana manga utaw na magkallat sa eped, kay kallatan silan uman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Madyaw ya kana manga utaw na wala' ya un pagsala' sa bet nilan asuntu na malinis ya kanilan anenganeng. Kay kita-en saba nilan ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Madyaw ya kana manga utaw na gayed migpa-iyuli' sa manga eped. Kay ya manga utaw na migpa-iyuli', tawagen silan na mangayse' na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Madyaw ya kana manga utaw na pyamulayaman asuntu na pig-imo' nilan ya pagkaliman na Tyumanem. Kay nyaka-akup da silan adti Kasakupan na Pighari-an nan. ");
INSERT INTO klg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Madyaw ya kamayu kun pigsupla kamu na manga utaw aw pigpamulayaman kamu nilan aw pigtanemtaneman kamu na tingeg asuntu sa pagdalug mayu kanak. ");
INSERT INTO klg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yanagaw pagleya kamu, kay dakula' saba ya madawat mayu na pigtagilan da adti tas na langit. Pangkay ya manga propita na Tyumanem asini muna, pigpamulayaman uman silan.” ");
INSERT INTO klg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Migpadeleg si Jisus miglong, “Asini tas na lupa', kasiling kamu na asin. Kun ya asin kalagakan sa nanam, dili' da makaliku' ya ka͡asin nan, yanagaw salabel da adti luwa' aw gina-gina-an na manga utaw. Maynan uman, kun malagak ya palangad ka͡asin mayu wala' ya ma-untung na manga utaw adti kamayu. ");
INSERT INTO klg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kasiling kamu uman na saleng na syumiga aw nyatag sa kalalamdag adti kadég na manga utaw. Aw ya syudad na adti tas na buntud, dili' saba kasalibenan. ");
INSERT INTO klg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aw wala' ya utaw na magsulu' sa salengan pada sangkuban nan. Manang betang nan baling adti bantawanan pada ka-ilawan ya kadég na awun ni seled na balay. ");
INSERT INTO klg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Maynan uman, pakita-an mayu ya kamayu imo-unun na madyaw kasiling na kalalamdag na pagkita-en na manga utaw. Aw magi sa pigpan-imo' mayu, deyen nilan ya Ama mayu na adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ya-i mayu pag-anenganenga na nyadi aku na un sayuwan ya Uldin aw ya pigsulat na manga propita na Tyumanem asini muna, kay beke' na maynan ya tud ku. Yan saba ya pigkadi ku na un tumanen ya pigsulat nilan. ");
INSERT INTO klg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Matinaw ya un ku paglongun kamayu: Talana na ini pa ya langit aw ya lupa', dili' ma-uman ya pangkay tagbi' na kulis na pigpasulat dun ni Uldin, menda' na matuman ya kadég. ");
INSERT INTO klg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pangkay singalan ya dili' magbetang sa ginawa sa pangkay sambuk na sugu' na awun ni Uldin aw kun palna-u nan uman ya maynan adti manga eped, yan na utaw to-o tagbi' ya kanan dengeg adti Kasakupan na Pighari-an na Tyumanem. Manang ya utaw na dumalug sa manga sugu' dun ni Uldin aw palna-u nan adti manga eped, matas ya dengeg nan dun ni Kasakupan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yanagaw paglongun ta kamu na dun ni pagdalug mayu sa pagkaliman na Tyumanem, labawan pa mayu ya pagtibagseg na manga Parisiyo aw manga magpalna-uway sa Uldin. Kay kun dili' mayu kalabawan, dili' kamu maka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Na, kya-ede-an da mayu saba ya pigpalna-u adti manga mangkabaklegay tadun lekat pa idtu muna: ‘Dili' kamu magpatay sa eped na utaw,’ aw ‘Pangkay singalan ya magpatay, yan ya pasala-en adti pag-usay.’ ");
INSERT INTO klg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Manang ini ya kanak paglongun kamayu: Pangkay singalan ya to-o madaman adti eped nan na wala' ya tengteng indeganan, yan uman ya pasala-en adti pag-usay. Aw pangkay singalan ya maglong sa malatay adti eped nan, pasala-en uman sakanan adti matas na usayanan. Aw pangkay singalan ya maglong adti eped nan na ‘Wala' ya utuk mu!’, yan ya datengan na utaw yan, ya atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yanagaw pangkay kinunu kaw pagdugsu' dun ni Témplo na Tyumanem aw ka-anenganengi mu na awun kadi' eped na migdiklamu kanmu, ");
INSERT INTO klg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dili' pa mu pagdugsu' adti Tyumanem ya pigdala mu. Ayawan pa mu malapit dun ni dugsu-anan, aw kadtuwi ya utaw na awun diklamu kanmu, aw una kamu pag-uli-uli-ay. Tigkas yan, liku' kaw aw dugsu-an da adti Tyumanem ya pigdala mu. ");
INSERT INTO klg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aw kun limanda kaw na sambuk na utaw aw dala͡en kaw nan adti usayanan, madyaw pa na maksay kamu magkakadyaway talana na wala' pa kamu dateng adti usayanan. Pagaw kun dumateng kamu dun, padakep kaw baling na mag-usayay aw pakalabusu kaw nan. ");
INSERT INTO klg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Matinaw saba ya paglongun ku: Kun makalabusu la kaw, dili' pa kaw paluwa-en kun dili' mu kabayadan ya kadakula' na sala' na nya-imo' mu. ");
INSERT INTO klg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Aw kya-ede-an da mayu saba ya pigpalna-u lekat pa idtu muna: ‘Dili' kamu maglakadenen.’ ");
INSERT INTO klg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Manang ini ya kanak paglongun kamayu: Pangkay singalan esega ya minunu sa eped na ka͡ubayan na awun pagkaybeg, na, miglakadenen da sakanan adti anenganeng nan. ");
INSERT INTO klg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Yanagaw kun ya pag-inunu mu aw ya pag-awid mu, yan ya du-an na maka-imo' kaw sa sala', madyaw pa baling na magpakawat kaw sa pangkay unu ya makapabuyu kanmu adti pag-imo' sa sala'. Pangkay pa kun lugiten mu ya kanmu mata aw pangkay pa kun utudun mu ya kanmu taklayan, madyaw pa na awun malagak dun ni kanmu lawas kay sa pa-emel-emelen ya kadakula' na lawas mu adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aw kya-ede-an da mayu ya pigpalna-u lekat pa idtu muna: ‘Pangkay singalan esega ya mayaw sa ka͡ubayan nan, matag sakanan una sa sulat na yan ya magmatinaw na mag-ayaw silan.’ ");
INSERT INTO klg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","“Manang ini ya kanak paglongun kamayu: “Kun awun eseg na ayawan nan ya kanan ka͡ubayan na wala' pagkasala-enen adti sambuk na eseg, aw kun mangugnan ya ka͡ubayan nan salut, liwan na yan ya migtulud sa ka͡ubayan nan adti paglakadenen. Aw ya eseg na nyangugnan sa ka͡ubayan na pig-ayawan miglakadenen uman sakanan. ");
INSERT INTO klg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Aw kya-ede-an da mayu ya pigpalna-u lekat pa idtu muna: ‘Kun magsapa' kaw adti Tyumanem, ya-i pagkalata ya pigsapa' mu, manang tumana baling ya pigsapa' mu.’ ");
INSERT INTO klg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Manang ini ya kanak paglongun kamayu: Dili' da kamu magsapa'. Aw dili' mayu pagpamatinawun ya adti tas na langit kay yan ya trunu na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aw dili' mayu uman pagpamatinawun ya kadakula' na banwa kay yan ya gina-anan na siki nan. Aw dili' mayu uman pagpamatinawun ya syudad na Jérusalim kay dun paghari' ya Misiyas kagaya moli na allaw. ");
INSERT INTO klg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aw dili' kamu magsapa' magi sa kamayu pagka-utawun, kay beke' mayu ya magbaya' sa kamayu ginawa asini tas na lupa'. Pangkay ya sambulus na batang na kamayu lugay, dili' mayu saba mabatug paputi-en aw pakaytemen. ");
INSERT INTO klg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yanagaw adti paglong mayu, ya e-e imo-a na ‘E-e.’ Manang ya dili', imo-a na ‘Dili'’. Kay kun dugangan mu na sapa' ya piglong mu, kan Satanas da yan. ");
INSERT INTO klg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kya-ede-an mayu uman ya pigpalna-u lekat pa idtu muna: ‘Kun makabuta ya utaw sa eped nan, buta͡en uman sakanan. Kun maka-­ipu' ya utaw sa untu na eped nan, ipu‑­un uman ya kanan.’ ");
INSERT INTO klg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Manang ini ya kanak paglongun kamayu: Dili' kamu magmalit sa utaw na migpakalat kamayu. Kun awun magmulamula kanmu aw sampalen nan ya gya mu, pasampalan uman kanan ya sangkilid. ");
INSERT INTO klg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Maynan uman, kun awun maglimanda kanmu adti usayanan aw kaliman nan kamangen ya sambuk na kadégkadég mu na palangad multa, na, atagan kanan ya pigkaliman nan aw dugangi pa uman na sambuk. ");
INSERT INTO klg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aw kun awun sundalu na leges nan pababa kanmu ya kabil nan na sangka kilomitro, dala͡en mu adti duwangka kilomitro. ");
INSERT INTO klg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yanagaw, kun awun utaw na magsekat adti kanmu, dili' mu pagdemetan. Aw kun awun utaw na meles adti kanmu, dili' mu uman pagtalikudan. ");
INSERT INTO klg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kya-ede-an mayu uman ya paglongun na eped na utaw: ‘Ginawayi ya kanmu manga ubaybay aw dumutan mu ya kanmu manga po-on.’ ");
INSERT INTO klg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Manang ini ya kanak paglongun kamayu: Ginawayi mayu baling ya kamayu manga po-on, aw panawagtawagi mayu adti Tyumanem ya manga nyamulayam kamayu. ");
INSERT INTO klg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kun maynan ya imo-un mayu, dun da ka-ede-i na kamu ya tengteng na mangayse' na Tyumanem na Ama tadun na awun ni tas na langit. Kay pyasilatan nan ya kadég na manga utaw, pangkay ya mangkalatay ya bet aw pangkay ya mangkadyaw ya bet. Aw pya-ulanan nan uman ya kadég na manga utaw pangkay ya dyumalug sa pagkaliman nan aw pangkay uman ya wala' dalug. ");
INSERT INTO klg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kun yan olo' ya ginawa͡an mu ya gyuminawa kanmu, ayin da ya kadyaw na pig-imo' mu? Pangkay ya manga mangangubla͡ay sa buwis, pigginawa͡an nilan saba ya kanilan manga ubaybay. ");
INSERT INTO klg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aw kun yan olo' ya pakadyawun mu ya gyuminawa kanmu, na unu ka', awun kadyaw na pig-imo' mu? Pangkay ya manga utaw na wala' pangintu-u sa Tyumanem, pigpakadyaw nilan ya kanilan manga ubaybay. ");
INSERT INTO klg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Yanagaw, dun ni kadég na imo-unun mayu, dayaw silingi ya bet na Ama mayu na awun ni tas na langit, kay wala' ya sala' dun ni kanan.” ");
INSERT INTO klg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Na, magpakatadeng kamu pagaw yan olo' ya tud mayu ya magpakita-kita' adti manga eped sa kadyaw na pig-imo' mayu. Kun maynan ya tud mayu, wala' ya un mayu madawat lekat adti Tyumanem na Ama na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yanagaw pangkay kinunu kaw pag-atag adti makalalat, dili' kaw magsiling sa manga migtallalingu. Kun mag-atag silan, una silan magpa-uni sa trumpita adti seled na sinagoga aw adti dalan pada pa-ede' na un silan matag. Kay kaliman nilan na to-o saya' na manga utaw asuntu sa kadyaw na kanilan pig-imo'. Matinaw ya un ku paglongun kamayu na nyakamang da nilan dun ni pagsaya' na manga utaw ya palangad tandan kanilan. ");
INSERT INTO klg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Manang kun matag kaw sa tabang adti manga makalalat, dili' da mu pagpa-ede' adti eped na utaw, pangkay adti kanmu tengteng ubaybay. ");
INSERT INTO klg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Madyaw kun dili' ka-ede-an ya kanmu pag-atag. Kay ya Ama mu na awun ni tas na langit, kita-en nan saba ya pig-atag mu aw yanagaw pakadyawun kaw nan. ");
INSERT INTO klg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aw dun ni pagpanawagtawag mayu adti Tyumanem, dili' kamu magsiling sa manga utaw na migtallalingu. Kay yan ya pagkaliman nilan ya mag-indeg adti seled na sinagoga aw dun ni suwayan na manga dalan, pada kita-en na manga utaw ya pagpanawagtawag nilan. Matinaw ya un ku paglongun kamayu: Kasiling na nyadawat da nilan ya palangad tandan magi dun ni pagsaya' na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Manang kun manawagtawag kaw adti Tyumanem, adtu kaw ni tambi' mu aw dayaw takepi ya suwangan pada dili' kaw kita-en na eped na utaw, aw panawagtawag kaw adti Ama. Kay kita-en nan saba ya pig-imo' mu aw pakadyawun kaw nan. ");
INSERT INTO klg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Aw dun ni kamayu pagpanawagtawag adti Tyumanem, ya-i mayu pagsalutsaluta ya manga tingeg kasiling na pig-imo' na manga utaw na Héntil na wala' paka-ede' sa tengteng na Tyumanem. Kay mig-anenganeng silan na kun salutsalutun nilan ya kanilan pagpanawagtawag pakanyegan silan. ");
INSERT INTO klg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aw yanagaw dili' mayu silan pagsilingan. Kay ya Ama mayu na awun ni tas na langit, kya-ede-an da nan saba dadan ya pigkapelek mayu pangkay wala' pa kamu pagsekat adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Yanagaw maynini ya pagpanawagtawag mayu adti Tyumanem: ‘Kay Ama nami na awun ni tas na langit, pagbasa͡an na kadég na utaw ya kanmu ngalan. ");
INSERT INTO klg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Migsekat kami na dumateng adi kanami ya Kasakupan na Pighari-an mu, aw matuman ya kanmu pagbaya' asini tas na lupa' kasiling na pagkatuman da adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sambata beg ya kanami pagkan adun na allaw yeiy. ");
INSERT INTO klg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aw lanasa beg ya kanami manga sala', kasiling na pigpasinsiya͡an da nami ya sala' na pig-imo' na eped nami. ");
INSERT INTO klg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aw dili' mu beg kami pagpabaya-an adti pagtanda' na dili' nami mabatug, manang tabangi kami beg na dili' kami degen na malatay na lekat adti kan Satanas.’ ” ");
INSERT INTO klg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pigpadeleg ni Jisus ya pagpalna-u sa manga utaw, law nan, “Kun pigpasinsiya͡an mayu ya eped na utaw na nyakasala' kamayu, lanasen uman na Ama mayu na awun ni tas na langit ya kamayu manga sala'. ");
INSERT INTO klg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Manang kun dili' mayu silan pasinsiya͡an sa manga pig-imo' nilan kamayu na malatay, dili' uman lanasen na Ama ya kamayu manga sala'. ");
INSERT INTO klg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aw dun ni pagpuwasa mayu, dili' kamu magtimbegat sa gya mayu kasiling na pig-imo' na manga migtallalingu. Dili' silan magkulamus aw dili' silan magpanuwat, kay kaliman nilan na kita-en silan na manga utaw na migpuwasa silan. Matinaw ya un ku paglongun kamayu: Kasiling na nyadawat da nilan ya palangad tandan magi dun ni pagsaya' na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Manang kun magpuwasa kamu, pagkulamus kamu aw dayaw kamu panuwat, ");
INSERT INTO klg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pada wala' ya utaw na maka-ede' na migpuwasa kamu. Yan olo' ya maka-ede' ya kamayu Ama na awun ni tas na langit. Pangkay dili' sakanan pagkita-en, manang pigkita' nan saba ya pig-imo' mu aw pakadyawun kaw nan. ");
INSERT INTO klg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dili' kamu magluduk sa manga ka-unan asini tas na lupa'. Pagkalalingen aw pagkalaten saba na manga anay, aw pagtakawun na mangkatakaw. ");
INSERT INTO klg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pagluduk kamu baling sa ka-unan adti tas na langit. Wala' saba ya manga mannanap na un kuman, aw dili' pagkalalingen aw dili' madala na mangkatakaw. ");
INSERT INTO klg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kay kun ayin ya kanmu ka-unan, adtu uman ya kanmu anenganeng. ");
INSERT INTO klg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya mata na utaw yan ya kalalamdag na lawas nan. Yanagaw, kun madyaw ya pag-inunu mu, awun kalalamdag na maka-ilaw sa kanmu anenganeng. ");
INSERT INTO klg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Manang kun dili' madyaw ya pag-inunu na mata mu, dakula' ya kangitngit na awun ni kanmu. Yanagaw kun dili' sumiga ya kalalamdag na awun ni kanmu, kasiling kaw na awun ni kangitngitan. ");
INSERT INTO klg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wala' ya allang na makadalug sa duwa ya tagtun, kay pakalaten nan ya sambuk aw ginawa͡an nan ya sambuk. Maynan uman, dalugun nan ya sambuk aw palipaslipasan nan baling ya sambuk. Dili' saba mabatug na utaw pagdenganen ya pagginawa sa kuwalta aw ya pagdalug sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yanagaw paglongun ta kamu: Dili' magkakamang ya kamayu ginawa sa kadég na kamayu kapelekan asini tas na lupa', kun unu ya un mayu kanen aw inemen, aw kun unu uman ya un mayu sutun. Kay ya pag-eya' na utaw asini tas na lupa', beke' olo' na makan aw beke' olo' na kadégkadég. ");
INSERT INTO klg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Inunuwa mayu ya manga langgam. Wala' silan pananem, aw wala' silan uman pag-ani. Aw wala' ya pul na un nilan pagludukan sa kanilan makan. Manang pigpakan silan saba na Ama mayu na awun ni tas na langit. Aw asuntu na to-o pa saba dakula' ya alaga' mayu kay sa kanilan, yanagaw atagan kamu nan sa kadég na kamayu kapelekan! ");
INSERT INTO klg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aw singalan ka' kamayu ya makasugpat sa kamayu ginawa asini tas na lupa' magi sa pagkaypeng mayu? Wala' saba! ");
INSERT INTO klg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aw ananga' uman magkakamang ya ginawa mayu sa un mayu sutun? Inunuwa mayu ya manga sagbet na magpamulak na tyumulin adti magalet. Wala' silan pagtalabahu aw wala' silan uman pagté'. ");
INSERT INTO klg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Manang paglongun ta kamu: Si Solomon, to-o dengganen ya pagkahari' nan asini muna aw syumut sakanan sa kadégkadég na to-o manenggeya, manang to-o pa dun manenggeya ya manga bulak yeiy. ");
INSERT INTO klg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ya manga sagbet adti magalet mamulak adun, pagkakunallaw malanes aw sangaben da. Aw pangkay tagbi' ya alaga' nilan, manang to-o silan pigpakanenggeya na Tyumanem. Aw atagan kamu nan saba sa un mayu sutun. Tay, sa katagbi' na pagpangintu-u mayu! ");
INSERT INTO klg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yanagaw dili' magkakamang ya ginawa mayu aw dili' kamu gayed maglong, ‘Unu ya un tadun kanen aw unu uman ya un tadun inemen? Aw unu uman ya un tadun sutun?’ ");
INSERT INTO klg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ya kadég yeiy, gayed pigtibagsegan na matagtun na manga utaw na wala' pangintu-u sa tengteng Tyumanem. Manang kamu, wala' ya du-an na makamang ya ginawa mayu, kay kya-ede-an da saba na Ama mayu na awun ni tas na langit kun unu ya kamayu kapelekan. ");
INSERT INTO klg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tibulluka mayu baling ya kamayu anenganeng adti kadég na awun ni Kasakupan na Pighari-an na Tyumanem, aw imo-a mayu ya kanan pagkaliman. Kun maynan ya imo-un mayu, sambaten nan ya kadég na kamayu kapelekan. ");
INSERT INTO klg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yanagaw dili' gayed magkakamang ya kamayu ginawa sa unu ya un dumateng kunallaw, kay umba' da olo' ya manga kalugan adun na allaw yeiy. Saligan da mayu baling ya kadég yeiy adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dili' kamu mag-ukum sa eped na utaw, pada dili' kamu uman ukuman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay kun unu ya sukud mayu sa kamayu manga eped, maynan uman ya sukud kamayu. ");
INSERT INTO klg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ananga' kaw magtulli' sa puling na awun ni mata na kanmu eped manang pyabaya-an mu baling ya dakula' na batang na nyakabalabag dun ni kanmu mata? ");
INSERT INTO klg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ananga' kaw maglong sa eped mu, ‘Nate' kamangen ya kanmu puling.’ Manang dili' mu mabatug kamangen asuntu sa dakula' na batang na nyakabalabag awun ni kanmu mata! ");
INSERT INTO klg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Migtallalingu kaw! Una͡a saba kamanga ya batang na awun ni kanmu mata pada mabangal ya kanmu pag-inunu aw mabatug da mu ya pagkamang sa puling na eped mu.” ");
INSERT INTO klg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pagkatigkas yan, miglong pa uman si Jisus, “Dili' madyaw na agbel adti idu' ya manga pametang na pigtani la kay wala' ya untung adti kanilan aw pagaw banga-en kamu baling nilan. Aw dili' uman madyaw na agbel ya kamagi adti manga taku' pagaw taguna-an nilan. Yanagaw dili' kamu magpalna-u sa manga utaw na gayed kyumele sa tingeg na Tyumanem aw dili' malim magpakanyeg kamayu.” ");
INSERT INTO klg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pagsekat kamu adti Tyumanem, aw atagan kamu nan. Tibagsegi mayu ya pagpaninaw, aw pakita' nan kamayu. Pagtatawag kamu adti kanan, aw uwangan kamu nan. ");
INSERT INTO klg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kay ya kadég na magsekat adti Tyumanem, un saba silan atagan. Aw ya kadég uman na maninaw, awun saba kita-en nilan. Aw ya kadég na magtatawag adti kanan, un saba silan uwangan. ");
INSERT INTO klg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Alimbawa', kamu na manga ama, kun magsekat ya ise' mu sa kakan, unu, atagan mu baling na batu? ");
INSERT INTO klg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aw kun magsekat uman sa isda', unu, atagan mu na ulud? Dili' saba! ");
INSERT INTO klg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yanagaw, pangkay makasasala' kamu, manang kya-ede-an mayu kun unu ya madyaw na atag adti kamayu mangayse'. Na, to-o pa dun ya kamayu Ama na awun ni tas na langit, kay atag nan saba ya to-o madyaw adti utaw na magsekat kanan! ");
INSERT INTO klg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kun kaliman mayu pakadyawun na manga eped na utaw, na, una͡a mayu silan pakadyawa. Yan ya tengteng na kakawasan na Uldin na Tyumanem aw ya pigpalna-u na manga propita. ");
INSERT INTO klg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kun kaliman mayu makaseled adti kasakupan na Tyumanem, agi kamu adti suwangan na mapeyet. Kay ya suwangan na malakbang, pangkay maluwag ya dalan aw molas agiyan, aw madég ya manga utaw na nyagi dun, manang ya dalan yeiy pasinan adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Manang ya suwangan na mapeyet, malug agiyan aw tabay olo' ya kyumita' sa dalan yeiy, manang yeiy ya dalan pasinan adti tengteng ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magpakatanaw kamu sa manga utaw na sallong kunu manga propita. Ya pigpakita' nilan kasiling na bet na karniro, manang ya tengteng na bet nilan kasiling na idu' na to-o mangkabulut. ");
INSERT INTO klg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka-ede-an mayu silan magi sa bunga na manga imo-unun nilan. Dili' kaw maka-ipu' sa bunga na igira adti suksukun na kawuy aw dili' mu uman kita-en ya bunga na paras adti sampinit. ");
INSERT INTO klg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ya kawuy na madyaw, madyaw uman ya bunga nan. Manang kun dili' madyaw ya kawuy, dili' uman madyaw ya bunga nan. ");
INSERT INTO klg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya madyaw na kawuy dili' mamunga sa malat, aw ya malat na kawuy dili' uman mamunga sa madyaw. ");
INSERT INTO klg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ya kadég na kawuy na dili' mamunga sa madyaw, pamila͡en silan baling aw agbel adti atulun. ");
INSERT INTO klg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yanagaw ka-ede-an mayu ya manga sallong kunu propita magi sa manga imo-unun nilan. ");
INSERT INTO klg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aw awun madég na utaw na pagtawagen aku nilan na ‘Pangulu.’ Manang ya manga eped kanilan dili' maka-akup adti Kasakupan na Pighari-an na Tyumanem. Yan olo' ya maka-akup dun, ya utaw na mig-imo' sa pagkaliman na kanak Ama na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aw dun ni allaw na pag-ukum, awun madég na utaw na maglong kanak, ‘Kay Pangulu, paseleda beg kami! Madég ya pigpan-imo' nami magi dun ni kanmu ngalan. Pig-ubat-ubat nami ya tingeg mu, aw pig-alilinan nami ya manga busaw na syumeled adti manga utaw, aw mig-imo' kami sa madég na milagru!’ ");
INSERT INTO klg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Manang paglongun ku baling silan, ‘Wala' ta kamu kilala͡a. Pagpakawat kamu kanak, kadég mayu na mag-imo-ay sa malatay!’ ");
INSERT INTO klg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ya utaw na migpakanyeg sa palna-u ku aw pigdalug nan, kasiling sakanan na utaw na to-o matadeng na migtulluk sa balay nan adti tas na batu na sumalem. ");
INSERT INTO klg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dyumateng ya dakula' na ulan aw nyuntul ya ba', aw to-o mabandes ya samet na kyumeleg adti balay, manang wala' kalukad ya balay kay to-o saba masalig ya kyatullukan nan. ");
INSERT INTO klg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Manang pangkay singalan ya dyumengeg sa manga palna-u ku aw wala' nan daluga, kasiling sakanan na utaw na wala' ya katadeng na migtulluk sa balay nan adti tas na pantad. ");
INSERT INTO klg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dyumateng ya dakula' na ulan aw nyuntul ya ba', aw to-o mabandes ya samet na kyumeleg adti balay. Aw dayaw nyalukad ya balay aw migkalat!” ");
INSERT INTO klg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatigkas ni Jisus magpalna-u sa to-o madég na manga utaw dun ni buntud, to-o silan nya-enneng-enneng ");
INSERT INTO klg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kay awun katulus na kanan pagpalna-u na dili' kasiling na pagpalna-u na manga magpalna-uway sa Uldin na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagkatigkas ni Jisus migpalna-u, tyumubang sakanan aw nyagad kanan ya madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aw awun dyumulud kanan na sambuk na eseg na ibungun. Lyumuhud sakanan aw to-o nyanginayu', aw miglong sakanan, “Kay Sir, kun malim kaw beg, guli-a ya ibung ku, pada kalinisan da ya lawas ku.” ");
INSERT INTO klg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aw pig-awidan ni Jisus ya eseg yan, aw piglongan nan, “Kaliman ku saba. Kalinisan da kaw!” Aw dayaw nyalanas ya ibung nan. ");
INSERT INTO klg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pagkatigkas yan, miglong si Jisus kanan, “Ya-i pag-ubatan adti pangkay singalan utawa ya nya-imo' adun! Manang kadtu kaw baling ni Témplo aw patanawan ya lawas mu adti magdadugsu-ay, aw yan ya magmatinaw na kyaguli-an da kaw sa kanmu ibung. Aw dala͡en mu kanan ya umba' na pagdugsu' na pigsugu' ni Moysis, pada ka-ede-an na manga utaw na kyalinisan da kaw.” ");
INSERT INTO klg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pagdateng ni Jisus adti lunsud na Kapirna-um, lyumagbet kanan ya sambuk na kapitan sa manga sundalu aw nyanginayu' sakanan kan Jisus sa tabang, ");
INSERT INTO klg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","miglong sakanan, “Kay Sir, kyedelan beg ya sugu-anen ku. Gayed da sakanan kyumulang kay dili' da magpaka-inang, aw tengteng na migti-is.” ");
INSERT INTO klg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aw miglong si Jisus kanan, “Magad aku kanmu adti kanmu balay aw guli-en ku ya magkedel nan.” ");
INSERT INTO klg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Manang tyumubag ya kapitan, “Kay Sir, dili' aku makatumbuk magpapanik kanmu adti balay ku. Manang pangkay olo' da tingeg mu, kaguli-an saba ya magkedel na kanak sugu-anen. ");
INSERT INTO klg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kya-ede-an da ku ya utaw na matas ya katundanan. Kasiling ku uman, pagka͡agadan ku ya matas pa kanak. Aw awun katundanan ku sa manga sundalu na madalem pa kanak. Kun sugu-un ku ya sambuk na ‘Kadtu kaw!’, na, maksay sakanan madtu. Aw kun paglongun ku uman ya sambuk na ‘Adi kaw!’, madi sakanan. Aw pangkay unu ya paglongun ku adti kanak sugu-anen, ka͡agadan nan saba. Yanagaw, kya-ede-an ku na kun olo' kaw maglong pangkay mawat kaw, kaguli-an ya magkedel na kanak sugu-anen.” ");
INSERT INTO klg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sa pagdengeg ni Jisus sa piglong na kapitan, miglong sakanan, “Tay sa kadakula' na pangpangintu-u na utaw yeiy!” Aw piglongan nan ya manga utaw na nyagad kanan, “Matinaw ya un ku paglongun kamayu: Ya eseg ini pangkay Héntil sakanan, manang wala' pa ku kita-a asini manga utaw na Isra-él ya maynini na pagpangintu-u. ");
INSERT INTO klg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paglongun ta kamu uman na adtu kagaya ni moli na allaw awun madég na utaw na Héntil na un lumekat adti manga banwa apit adti silatan aw adti sallepan. Aw mingkud silan adti tampid na tyugbulan tadun na si Abraham aw si Isaak aw si Jakub adti dakula' na katipun dun ni Kasakupan na Pighari-an na Tyumanem adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Manang ya manga buwadbuwad ni Isra-él na maka-akup galu adti kasakupan nan, ya eped kanilan agbel baling adti banwa na kangitngitan na adti luwa'. Aw dun ni banwa yan, magpanpanguliteb ya manga untu nilan aw magpansisugaw.” ");
INSERT INTO klg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pagkatigkas yan, miglong si Jisus adti kapitan, “Uli' da kaw. Asuntu sa pagpangintu-u mu kanak, atag ku saba ya pigpanginayu' mu.” Aw dun ni udas yan, dayaw kyaguli-an ya sugu-anen nan. ");
INSERT INTO klg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aw wala' kadugay nyadtu si Jisus ni balay ni Pédro aw kyinita' nan dun na kyumulang ya ugangan ni Pédro na ka͡ubayan kay to-o migkapasu' asuntu na kyedelan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aw pig-awidan ni Jisus ya bekten nan aw dayaw sakanan pig-uwasan sa kapasu-an nan. Tigkas yan, migbangun sakanan aw pigsanggila' nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagsallep da na sega, pigpandala adti kan Jisus ya madég na utaw na pyanseledan na busaw. Aw pig-alilinan nan ya manga busaw magi dun ni tingeg nan. Aw pigpangguli' nan uman ya magkedel na kadég na manga utaw na pigpandala adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aw dun ni pigpan-imo' nan, nyatuman da ya pigpasulat na Tyumanem magi sa propita na si Isayas asini muna: “Kyamang da nan ya kadég na pagti-is tadun aw ya kanaten magkedel.” ");
INSERT INTO klg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pagkita' ni Jisus sa to-o madég na utaw na migkalimpung kanan, piglongan nan ya kanan manga umagakan, “Naten tumalipag sa danaw.” ");
INSERT INTO klg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Manang sa wala' pa silan pakasakay sa balangay, dyumulud kanan ya sambuk na magpalna-uway sa Uldin na manga Judiyu. Aw piglongan nan si Jisus, “Kay Magpalna-uway, magad aku kanmu pangkay ayin kaw pasinan.” ");
INSERT INTO klg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Manang miglong si Jisus kanan, “Ya manga mile' awun pugala' na kanilan pagka-eya-an, aw ya manga langgam awun pugad nilan. Manang ya Ise' na Utaw, wala' ya balay na un nan kabantukan.” ");
INSERT INTO klg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aw awun pa uman sambuk na utaw na malim magad kan Jisus, aw miglong sakanan, “Kay Magpalna-uway, tumbayan pa beg kanake' na muli' aku adti kanami kay una pa nami lebeng ya ama ku.” ");
INSERT INTO klg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Manang miglong si Jisus kanan, “Agad da kaw kanak. Pabaya-an da sa manga utaw na wala' pangintu-u ya paglebeng sa nyatay.” ");
INSERT INTO klg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pagkatigkas yan, syumakay si Jisus adti balangay, aw nyagad uman ya kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Talana pa nilan dun ni tenga-tenga' na danaw, wala' nilan imanmana bigla' dyumateng ya to-o mabandes na samet, aw syalampawan na manga baled ya balangay na pigsakayan nilan. Manang kenne' baling ni Jisus nyakatulug. ");
INSERT INTO klg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yanagaw pigpukaw sakanan na manga umagakan nan, aw miglong silan, “Kay Magpalna-uway, tabangi beg kami! Kay agpet da kitadun mangkamatay!” ");
INSERT INTO klg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Manang miglong si Jisus kanilan, “Ananga' kamu mangkallek? Tay, sa katagbi' na pagsalig mayu kanak!” Aw migbangun si Jisus aw piglongan nan ya samet aw manga baled, “Tangke' kamu!” Aw dayaw migkalinaw ya kadég. ");
INSERT INTO klg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aw to-o nya-enneng-enneng ya manga umagakan nan, aw miglong silan, “Singalan ka' ya utaw yeiy? Pangkay ya samet aw ya manga baled magka͡agad sa sugu' nan!” ");
INSERT INTO klg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aw sa pagdateng ni Jisus adti dipag na danaw dun ni sakup na Gadara, syumungun kanan ya duwa ya utaw na pigseledan na manga busaw. Nyeya' silan adti manga ilib na paglebengan sa manga utaw. Aw to-o silan mabulut, yanagaw pigkallekan silan na manga utaw aw wala' ya magpaka-agi dun. ");
INSERT INTO klg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkita' nilan kan Jisus, miglong silan sa mabagseg na tingeg, “We... Ise' na Tyumanem, unu ya pigkadi mu? Unu, pamulayaman da mu kami pangkay wala' pa dateng ya allaw na un kami pa-emel-emelen?” ");
INSERT INTO klg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, awun madég na manga taku' na nyangaliwad na dili' to-o mawat lekat dun ni kanilan. ");
INSERT INTO klg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yanagaw nyanginayu' ya manga busaw kan Jisus, law nilan, “Kun alilinan mu kami, adtu mu beg kami paseleda dun ni manga taku' iyan!” ");
INSERT INTO klg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aw piglongan ni Jisus ya manga busaw, “Luwa' da kamu dun!” Yanagaw lyumuwa' silan adti duwa ya eseg aw syumeled silan adti manga taku'. Aw nyampamalaguy ya kadég na manga taku' dun ni kakayaban aw pyangkawasan nilan ya pangpang adti ligad na danaw aw nyabus silan nyangkalemes. ");
INSERT INTO klg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aw ya manga magdadiyaga͡ay sa manga taku', nyalaguy silan adti lunsud aw pig-ubat-ubatan nilan ya manga utaw sa kadég na nyangka-imo' dun ni duwa ya utaw na kyaguli-an da. ");
INSERT INTO klg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pagdengeg na manga utaw adti lunsud sa kadég na pig-imo' ni Jisus, madég kanilan ya nyadtu ni kanan. Aw sa pagkita' nilan kan Jisus, nyanginayu' silan na indegan nan ya banwa nilan. ");
INSERT INTO klg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sa pagkatigkas na pig-imo' ni Jisus dun ni Gadara, syumakay sakanan sa balangay aw lyumiku' adti lunsud na Kapirna-um na pig-eya-an nan. ");
INSERT INTO klg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sa pagdateng da nan, piglagbet sakanan na manga utaw na migtingga sa pulid. Sa pagkita' ni Jisus sa pagpangintu-u nilan na mabatug nan guli-en ya utaw yan, piglongan nan ya pulid, “Kay Lew, pakabagsega ya kanmu ginawa, kay ya manga sala' mu adti Tyumanem piglanas da.” ");
INSERT INTO klg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aw dun uman ya manga eped na magpalna-uway sa Uldin, aw dyengeg nilan ya piglong ni Jisus. Yanagaw mig-anenganeng silan, “Ya utaw yeiy, migpa-unawa sakanan sa Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Manang kya-ede-an ni Jisus ya kanilan anenganeng aw yanagaw piglongan nan silan, “Ananga' kamu mag-anenganeng sa malatay? ");
INSERT INTO klg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ayin ka' ya molas paglongun adti eseg na pulid, ‘Ya manga sala' mu nyalanas da,’ aw kun paglongun ku sakanan, ‘Pagbangun kaw aw panaw da kaw’? ");
INSERT INTO klg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Manang matinawun ku adti kamayu na ya Ise' na Utaw awun katundanan nan maglanas sa manga sala' na manga utaw.” Tigkas yan, miglong si Jisus adti eseg na pulid, “Pagbangun kaw! Dala͡a ya pigtingga nilan kanmu aw uli' da kaw!” ");
INSERT INTO klg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aw maksay nyindeg ya pulid aw nyuli' sakanan adti balay. ");
INSERT INTO klg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sa pagkita' da na madég na manga utaw sa pig-imo' ni Jisus, to-o silan nya-enneng-enneng. Yanagaw pigdeyen nilan ya Tyumanem na nyatag sa katulus adti utaw na maka-imo' sa maynan. ");
INSERT INTO klg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na, nyindeg si Jisus lekat dun, aw kyinita' nan ya sambuk na utaw na nyingkud adti bayadanan sa buwis kay mangungubla͡ay sakanan. Aw ya ngalan nan si Matiyo. Aw miglong si Jisus kanan, “Agad kaw kanak!” Aw nyindeg si Matiyo aw nyagad kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wala' kadugay, migpa-imo' si Matiyo sa dakula' na kakan adti balay nan. Kyuman dun si Jisus aw ya kanan manga umagakan. Aw madég uman ya dyumateng dun na manga mangungubla͡ay sa buwis aw ya eped pa na manga makasasala'. ");
INSERT INTO klg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagkita' na manga Parisiyo seiy, piglongan nilan ya umagakan ni Jisus, “Ananga' sumambuk kuman ya magpalna-uway mayu sa manga mangungubla͡ay sa buwis aw manga utaw na makasasala'?” ");
INSERT INTO klg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Manang dyengeg ni Jisus ya piglong nilan, yanagaw pigtubag nan silan magi sa pundinganan, law nan, “Ya manga utaw na mangkadyaw ya lawas, dili' nilan ka-ilangan ya doktor. Manang ya manga utaw na awun magkedel, silan ya awun ka-ilangan sa doktor. ");
INSERT INTO klg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sadsadi mayu ya kakawasan na ini: ‘Ya kanak tengteng pagkaliman, na awun pagkallat mayu adti eped na utaw, aw beke' na dugsu' mayu na pagsangaben.’ Ya pigkadi ku asini tas na lupa', yan ya pagtawag sa manga utaw na nyaka-ede' sa manga sala' nilan, pada magselsel silan aw dumalug silan kanak. Manang ya manga utaw na iman nilan aw wala' ya kanilan sala' adti Tyumanem, beke' nilan saba ya pigtawag ku.” ");
INSERT INTO klg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aw pagkatigkas yan, dyumulud kan Jisus ya manga umagakan ni Juan na Magba͡utismuway, aw nyusip silan kanan, “Ananga' gayed kami migpuwasa aw ya manga Parisiyo, manang ya kanmu manga umagakan, wala' silan pagpuwasa?” ");
INSERT INTO klg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aw tyumubag si Jisus kanilan magi sa pundinganan, “Enda', kun awun kasal, dili' magkalat ya ginawa na manga tyumambung talana na kenne' pa dun ni sayid nilan ya eseg na migpanamung? Manang dumateng ya allaw na kamangen sakanan adti kanilan. Aw lekat dun ni allaw yan, magpuwasa la silan. ");
INSERT INTO klg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Aw kasiling uman na kadégkadég, ya bagu na téla dili' pagleneb adti dadan na téla na malungu la. Kay kun maleneb da aw gayed bugsakan, dili' madugay kumeteng ya bagu aw to-o la baling magkadakula' ya kakisayan. ");
INSERT INTO klg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aw maynan uman, dili' pag-asag ya bagu na bino adti dadan na betanganan na pig-imo' lekat adti kindal na ayep. Kay kun asag ya bino dun aw sumubuk, mutu baling ya betanganan, aw masapad ya bino, aw magkalat ya betanganan. Manang ya bagu na bino, pag-asag adti bagu na betanganan na kindal na ayep. Aw yanagaw dili' magkalat ya betanganan aw dili' uman masapad ya bino.” ");
INSERT INTO klg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sa talana pa ni Jisus miglong adti manga umagakan ni Juan, dyumulud kanan ya sambuk na pagsaligan adti sinagoga. Aw lyumuhud sakanan adti asdangan ni Jisus, aw to-o nyanginayu', law nan, “Ya ise' ku na dalagita, baya' pa beg nyapalus ya ginawa nan. Manang kya-ede-an ku na kun magad kaw kanak adti balay aw pandungan mu sakanan na kanmu palad, mataw saba sakanan.” ");
INSERT INTO klg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yanagaw nyagad si Jisus sa utaw yan, aw nyagad uman ya manga umagakan nan. ");
INSERT INTO klg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Talana nilan nyanaw, awun ka͡ubayan na dyumulud kan Jisus apit adti bagakwang nan. Na, ya ka͡ubayan yeiy, gayed pigdugu-dugu' seled na sampulu' tag duwa ya umay. Aw yanagaw pig-awidan nan ya pangaway na pigsut ni Jisus, ");
INSERT INTO klg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kay mig-anenganeng sakanan, “Kun ka-awidan ku olo' ya pangaway na pigsut nan, kaguli-an da aku.” ");
INSERT INTO klg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aw maksay nyatubang si Jisus aw kyinita' nan ya ka͡ubayan, aw piglongan nan, “Kay Dé', pakabagsega ya kanmu ginawa. Asuntu sa pagpangintu-u mu kanak, yan ya nyakaguli' kanmu.” Aw dayaw kyaguli-an ya ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na, pagdateng ni Jisus dun ni balay na utaw na pagsaligan adti sinagoga, kyinita' nan ya madég na utaw adti luwa' na migpanmatay aw ya manga utaw na migpansi-eyep sa sileli. ");
INSERT INTO klg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yanagaw piglongan nan silan, “Luwa' pa kamu! Wala' saba kamatay ya ise'. Olo' sakanan nyakatulug!” Manang nyaka-ikel baling silan sa piglong nan. ");
INSERT INTO klg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aw sa pagpakaluwa' da na manga utaw, syumeled sakanan adti pigpakulangan sa ise' aw pig-awidan nan ya bekten na ise', aw dayaw migbangun sakanan. ");
INSERT INTO klg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aw ya ubat-ubat sa pig-imo' ni Jisus nyabekkal adti palibed na banwa yan. ");
INSERT INTO klg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sa pag-indeg da ni Jisus adti balay yan, awun duwa ya eseg na buta na gayed dyumalug kanan. Aw pigtatawag nilan si Jisus, “We....Buwadbuwad ni Dabid, kallati beg kami!” ");
INSERT INTO klg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sa pagdateng ni Jisus adti pigbantukan nan, dyumulud kanan ya duwa ya buta. Aw nyusip si Jisus kanilan, “Unu, nyangintu-u kamu na mabatug ta kamu guli-en?” Aw tyumubag silan kanan, “E-e, kay Sir. Nyangintu-u kami.” ");
INSERT INTO klg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aw pig-awidan ni Jisus ya manga mata na tagsambuksambuk kanilan, aw piglongan nan silan, “Asuntu sa pagpangintu-u mayu kanak, kaguli-an da kamu!” ");
INSERT INTO klg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aw dayaw silan kyumita'. Aw miglong si Jisus kanilan, “Dili' mayu yeiy pag-ubat-ubat adti pangkay singalan.” ");
INSERT INTO klg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Manang sa pagpanaw da nilan, pig-ubat-ubat baling nilan ya pagpaguli' ni Jisus kanilan. Aw nyabekkal ya ubat-ubat yeiy adti manga banwa na nyakapalibed dun. ");
INSERT INTO klg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sa pagpanaw da na duwa ya eseg na baya' kyumita', wala' kadugay awun da uman manga utaw na dyumateng dun na migpa-agad sa sambuk na utaw na nya-umu kay pigseledan na busaw. ");
INSERT INTO klg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aw sa pagkatigkas da ni Jisus alilinan ya busaw na syumeled adti utaw yan, dayaw nyakapaglong ya umu. Aw ya nya-enneng-enneng ya kadég na utaw dun, aw miglong silan, “Wala' pa tadun kita-a ya maynini asini kadakula' na Isra-él!” ");
INSERT INTO klg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Manang miglong ya manga Parisiyo, “Magi saba sa katulus na pangulu na manga busaw kya-alilinan nan ya manga busaw!” ");
INSERT INTO klg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Piglegeb ni Jisus ya kadég na lunsud aw manga baranggay na banwa yan, aw migpalna-u sakanan adti manga sinagoga, aw pigpa-ede' nan ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem. Aw pigpangguli' nan uman ya kadég na manga magkedel na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aw sa pagkita' nan sa madég na manga utaw, to-o nyallat si Jisus kanilan kay madég ya nyakalinggal sa anenganeng nilan aw wala' ya un makatabang kanilan. Kasiling silan na manga karniro na wala' ya magdadiyaga͡ay. ");
INSERT INTO klg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tigkas yan, miglong si Jisus adti kanan manga umagakan, “Dakula' to-o ya aniyenen, manang tabay ya mag-aniyay. ");
INSERT INTO klg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yanagaw panawagtawag kamu adti Tyumanem na yan ya tagtun sa palangad aniyenen, na magpadala sakanan sa manga mag-aniyay pada tumabang mag-ani.” ");
INSERT INTO klg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yanagaw pigpatawag ni Jisus adti sayid nan ya sampulu' tag duwa ya umagakan na dadan da nan pigpamalli'. Aw pig-atagan nan silan na katulus na un mag-alilin sa manga busaw aw magguli' sa kadég na punganan na magkedel na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, ini ya manga ngalan na sampulu' tag duwa ya apostolés: Ya tagna' si Simon na pigngalanan uman na Pédro aw ya inulug nan na si Andrés, aw si Santiago aw ya inulug nan na si Juan na alag ise' ni Zibidiyo, ");
INSERT INTO klg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aw si Pilipi aw si Bartolomé, aw si Tomas aw ya mangungubla͡ay sa buwis idtu na muna na si Matiyo, aw si Santiago na ise' ni Alpiyo, aw si Tadiyo, ");
INSERT INTO klg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aw si Simon na Kananiyo aw si Judas Iskariyoti na yan ya un maglubid kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na, sa wala' pa ni Jisus papanawa ya sampulu' tag duwa yeiy, piglongan nan silan, “Sugu-un ta kamu adti manga utaw, manang dili' pa mayu adun pagkadtuwan ya manga banwa na manga Héntil aw ya manga lunsud na manga Samariyanen. ");
INSERT INTO klg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yan baling ya kadtuwi mayu adun ya manga buwadbuwad ni Isra-él, kay kasiling silan na manga karniro na migkabuluy. ");
INSERT INTO klg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dun ni pagpanaw mayu, ubat-ubati mayu silan na ya Paghari' na Tyumanem sa Kasakupan nan malapit da. ");
INSERT INTO klg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aw pangguli-a mayu ya manga magkedel na utaw, aw matawa mayu ya baya' nyatay, aw pangguli-a mayu ya manga ibungun pada magkalinis da silan, aw alilini mayu ya manga busaw na syumeled adti utaw. Aw dili' mayu pagkalingawan na madég ya nyadawat mayu na wala' ya bayad, yanagaw dili' kamu magsekat sa bayad sa manga pig-imo' mayu. ");
INSERT INTO klg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dun ni pagpanaw mayu, dili' kamu magdala sa kuwalta. ");
INSERT INTO klg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aw dili' kamu magdala sa kabil aw ilisan aw sandal, aw pangkay bangka'. Kay ya manga utaw na un mayu ubat-ubatan, silan galu ya matag sa kamayu kapelekan. Kasiling kamu saba na magtalabahuway na umba' atagan sa kapelekan. ");
INSERT INTO klg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yanagaw pangkay unu lunsuda aw baranggay ya datengan mayu, pangusip kamu kun singalan ya utaw dun na madyaw magpamasa. Aw yan ya bantuki mayu ya kanilan balay, aw pag-eya' pa kamu dun ni tampid nilan menda' sa allaw na indegan mayu ya lunsud yan. ");
INSERT INTO klg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sa pagseled mayu adti kanilan balay, paglonga mayu ya manga utaw na nyeya' dun, ‘Atagan na kalinaw ya kadég na utaw asini balay ini.’ ");
INSERT INTO klg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kun dawaten kamu nilan, atagan saba silan na Tyumanem na kalinaw. Aw kun dili' nilan dawaten, bawi-a la ya piglong mayu kanilan. ");
INSERT INTO klg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aw dun ni banwa na pigdatengan mayu, kun dili' silan malim dumawat kamayu aw dili' uman malim magpakanyeg sa pag-ubat-ubat mayu, na, sa pag-indeg mayu adti kanilan, taptapa ya alikabuk na siki mayu. ");
INSERT INTO klg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Matinaw saba ya un ku paglongun kamayu: Pagdateng da na allaw na pag-ukum, to-o pa mabegat ya pa-emel-emel kanilan kay sa manga utaw na nyeya' dun ni syudad na Sodoma aw Gomora. ");
INSERT INTO klg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Manang pakanyegi ya un ku kamayu paglongun: Sugu-un ta kamu adti manga utaw na mangkalatay ya bet. Masiling kamu saba na manga karniro na piglibedan na manga malyaw na idu' na to-o mangkabulut. Yanagaw pagpakatanaw kamu to-o na wala’ ya dumeg kamayu aw wala' uman ya un pagsala' kamayu. ");
INSERT INTO klg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Magpakatanaw kamu sa manga utaw na malim maglimanda aw magdala kamayu adti usayanan. Aw badasan kamu nilan na lalabet dun ni seled na manga sinagoga nilan. ");
INSERT INTO klg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aw asuntu sa pagpangintu-u mayu kanak, un kamu nilan pa-indegen adti asdangan na manga gubirnador aw manga hari'. Aw dun da kamu pakaselat pagpa-ede' kanilan sa Madyaw na Ubat-ubat kanak aw adtu uman ni manga utaw na Héntil. ");
INSERT INTO klg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kun tumbay kamu nilan adti asdangan na mag-usayay aw pan-usipen kamu nilan, dili' magkakamang ya ginawa mayu kun unu ya un mayu tubag kanilan. Kay dun ni udas yan, ya Ispiritu na Ama yan ya maggagad sa kamayu anenganeng sa un mayu tubag kanilan. ");
INSERT INTO klg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aw ya paglongun mayu kanilan beke' na lekat adti kamayu, manang lekat adti Ispiritu na Ama. ");
INSERT INTO klg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aw beke' yeiy olo' ya un ma-imo'. Dili' madugay awun manga mangkaylug na magtumbay sa inulug nan adti manga po-on pada patayen. Aw awun uman manga ama na magtumbay sa kanilan ise' na patayen. Aw awun manga ise' na matu sa mangkatikadeng nilan aw magtumbay kanilan adti manga po-on pada patayen. ");
INSERT INTO klg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aw dumutan kamu na madég na manga utaw asuntu sa pagdalug mayu kanak. Manang pangkay singalan ya magpadeleg dun ni pagpangintu-u nan kanak taman adti katigkasan, yan saba ya utaw na paluwa-en na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kun pamulayaman kamu adti sambuk na lunsud, palaguy kamu adti eped na lunsud. Matinaw saba ya un ku paglongun kamayu: Sa dili' pa mayu matigkas ya imo-unun adti kadég na lunsud na Isra-él, lumiku' da ya Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ya pigpalna-uwan dili' matas sa migpalna-u kanan. Aw wala' ya sugu-anen na matas pa sa amu nan. ");
INSERT INTO klg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umba' da sa pigpalna-uwan ya magkatadeng kasiling na migpalna-u kanan. Aw maynan uman ya allang masiling na tagtun kanan. Yanagaw kun aku ya tagtun sa balay aw pigtawag aku na manga utaw na ‘Bilsibul’, na, to-o pa dun baling malatay ya pagtawag nilan sa kanak ka-epedanan dun ni balay. ");
INSERT INTO klg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Yanagaw dili' kamu magkallek sa manga utaw. Kay ya kadég na pigpan-imo' da nilan na malatay, alag saba ka-ede-an. Wala' ya nyatagu' adun na dili' kagaya kabukasan. ");
INSERT INTO klg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya piglong ku kamayu na gabi, ubat-ubatan da mayu magi sa dakula' na tingeg lekat adti tas na atep kun magkalalamdag da. ");
INSERT INTO klg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aw dili' kamu magkallek sa manga utaw na un magpatay sa lawas mayu, kay dili' nilan saba mabatug patayen ya kamayu kalaluwa. Yan baling ya kalleki mayu ya Tyumanem. Kay alag nan mabatug kalaten ya lawas aw ya kalaluwa na utaw adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Anenganenga mayu na tagbi' to-o ya pagbayad sa duwa ya langgam na maya, manang wala' ya pangkay sambuk kanilan na molug na dili' ka-ede-an na Ama mayu. ");
INSERT INTO klg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aw kamu uman, kya-ede-an da saba na Tyumanem kun pila ya kadég na lugay mayu. ");
INSERT INTO klg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yanagaw dili' kamu magkallek kay to-o pa dakula' ya alaga' mayu kay sa madég na manga maya! ");
INSERT INTO klg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pangkay singalan ya maglong adti asdangan na manga utaw, ‘Umagakan aku ni Jisus’, maynan uman paglongun ku adti asdangan na Ama ku na awun ni tas na langit, ‘Umagakan ku uman sakanan.’ ");
INSERT INTO klg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Manang pangkay singalan ya magbalyaw kanak adti asdangan na manga utaw, balyaw ku uman sakanan adti asdangan na Ama na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Dili' kamu mag-anenganeng na nyadi aku pada dumala sa kalinaw asini tas na lupa'. Ya pagkadi ku, yan baling ya du-an na magtanam ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Asuntu sa pagkadi ku, tanamen na ise' na eseg ya kanan ama. Aw ya ise' na ka͡ubayan tanamen nan uman ya kanan ina. Aw ya makeye' na ka͡ubayan tanamen nan ya ugangan nan na bubay. ");
INSERT INTO klg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yanagaw ya eped mayu dun ni seled na balay, yan da baling ya eped mu magtanam. ");
INSERT INTO klg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ya utaw na to-o gyuminawa sa kanan ama aw ina manang tagbi' ya pagginawa nan kanak, yan ya utaw na dili' umba' ma-imo' kanak umagakan. Aw ya utaw na to-o gyuminawa sa kanan ise' na eseg aw ise' nan na ka͡ubayan manang tagbi' ya pagginawa nan kanak, dili' uman umba' ma-imo' kanak umagakan. ");
INSERT INTO klg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aw ya utaw na dili' malim magpisan sa kanan krus aw dumalug kanak, ya utaw yan dili' umba' ma-imo' kanak umagakan. ");
INSERT INTO klg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aw pangkay singalan ya gyuminawa sa kanan pagka-utawun asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay, matagtun nan ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Pangkay singalan ya dumawat kamayu, kasiling na aku ya pigdawat nan. Aw pangkay singalan ya dumawat kanak, dun da nan uman dawata ya Ama na migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aw pangkay singalan utawa ya mamasa sa propita asuntu sa pagpa-ede' nan sa tingeg na Tyumanem, dumawat ya utaw yan sa kasiling na un dawaten na propita. Aw kun singalan ya mamasa sa utaw na gayed mig-imo' sa pagkaliman na Tyumanem, dawaten nan uman ya kasiling na un atag sa manga utaw yan. ");
INSERT INTO klg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aw matinaw saba ya un ku paglongun kamayu: Pangkay singalan utawa ya magkallat sa umagakan ku na madalem aw matag sa pangkay sangkatabu' ya tubig, yan ya utaw na dumawat sa tandan kagaya.” ");
INSERT INTO klg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aw pagkatigkas ni Jisus paglongan ya sampulu' tag duwa ya umagakan nan, nyanaw sakanan lekat dun pada magpalna-u aw mag-ubat-ubat adti manga utaw dun ni manga lunsud nilan. ");
INSERT INTO klg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, sa talana pa ni Juan dun ni kalabusuwanan, dyengeg nan ya manga pigpan-imo' ni Jisu-Kristu. Yanagaw pyakadtu nan ya kanan manga umagakan kay awun usip nan ");
INSERT INTO klg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","adti kan Jisus, aw nyusip silan kanan, “Unu, ikaw ya pigpakang na Tyumanem asini muna na un madi? Aw kun awun pa eped na imanen nami?” ");
INSERT INTO klg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aw tyumubag si Jisus kanilan, “Liku' kamu adti kan Juan aw ubat-ubatan mayu kanan ya manga dyengeg mayu aw ya manga kyinita' mayu: ");
INSERT INTO klg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ya manga dili' magkita', kyumita' da. Ya manga pulid, nyakapanaw da. Ya manga ibungun, pyangkaguli-an aw malinis da. Ya manga bengel, dyumengeg da. Awun manga nyangkamatay na nyataw da. Ya manga tagitu' na utaw, kya-ubatan da sa Madyaw na Ubat-ubat. ");
INSERT INTO klg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aw madyaw ya kana manga utaw na wala' pagduwaduwa na aku ya Pigpadala na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sa pagpanaw da na manga umagakan ni Juan, pig-usip ni Jisus ya madég na utaw na migkatipun dun, law nan, “Sa pagkadtu mayu adti kan Juan dun ni kaligbinan idtu muna, unu ka' ya pig-iman mayu na du-an mayu pyaninaw sakanan? Pagaw nyadtu kamu na olo' magtandawtandaw sa utaw na kasiling na tigbaw na pig-eyeng-eyeng na samet. Beke' saba na maynan si Juan! ");
INSERT INTO klg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Manang ananga' kamu madtu ni kaligbinan? Pagaw iman mayu aw kumita' kamu sa utaw na syumut sa kadégkadég na mayaman. Ya utaw na maynan, adtu sakanan pagkita-en ni palasyo. Manang beke' saba na maynan si Juan! ");
INSERT INTO klg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yanagaw unu ka' ya pig-iman mayu na un mayu kita-en dun ni kaligbinan? Pig-iman gya mayu na kumita' sa propita. Matinaw saba na propita sakanan, manang paglongun ta kamu na matas pa si Juan sa manga muna propita. ");
INSERT INTO klg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aw si Juan yeiy, yan ya pigkasampetan dadan dun ni pigpasulat na Tyumanem asini muna: ‘Na, un ku pa-una͡en kanmu ya kanak mag-ubat-ubatay pada tagilanen nan ya un mu agiyan.’ ");
INSERT INTO klg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Matinaw ya un ku paglongun kamayu: Ya kadég na utaw na nya͡utaw asini tas na lupa' taman adun, wala' ya pangkay sambuk na matas pa kan Juan na Magba͡utismuway. Manang ya to-o madalem na utaw na nyaka-akup adti Kasakupan na Pighari-an na Tyumanem, matas pa sakanan kan Juan. ");
INSERT INTO klg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na, lekat na allaw na migpalekat mig-ubat-ubat si Juan na Magba͡utimuway, menda' adun, ya Kasakupan yan to-o pa baling migkadakula' pangkay awun manga migbalabag sa pag-ubat-ubat aw nyamulayam sa manga nyaka-akup da. Aw awun uman mangkabulut na utaw na kaliman nilan sulungun aw agawun galu ya Kasakupan yan. ");
INSERT INTO klg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kay ya kadég na manga propita aw ya Uldin migpa-ede’ alag sa paghari' na Tyumanem. Tigkas yan, migpalekat si Juan mig-ubat-ubat. ");
INSERT INTO klg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aw kun malim kamu dumawat sa piglong nilan asini muna, si Juan saba ya propita na pigkasampetan nilan na un dumateng na kasiling ni Éliyas. ");
INSERT INTO klg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Migpadeleg si Jisus miglong, “Unu ya un ku kapa-unawa͡an sa manga utaw adun na gayed kyumele sa palna-u na dyengeg nilan? Kasiling silan na mangayse' na mangkategel na nyan-ingkud adti pamanag na palingki. Dili' silan malim magad magdanga pangkay pigtatawag silan na kanilan manga eped na miglong: ");
INSERT INTO klg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Naten magdanga! Migpasonata kami sa pangkasal, manang wala' kamu sayaw! Aw migpansi-engge' kami manang wala' kamu pagsugaw.’ ");
INSERT INTO klg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maynan uman, madég kamayu ya gayed migdiklamu. Kay dyumateng si Juan aw wala' sakanan kita-a na kyuman aw nyinem adti sayid na manga utaw. Aw miglong kamu, ‘Syeledan sakanan na busaw!’ ");
INSERT INTO klg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tigkas yan, dyumateng ya Ise' na Utaw. Kyinita' sakanan kyuman aw nyinem eped nan ya madég na manga utaw. Manang miglong kamu baling, ‘Tanawa mayu ya utaw yeiy! To-o sakanan kyuman aw to-o nyinem sa bino, aw mig-ubaybay sa manga mangangubla͡ay sa buwis aw eped pa na makasasala'!’ Pangkay miglong kamu seiy, manang ya palna-u ku aw ya palna-u ni Juan, alag saba pigmatinaw dun ni pigpan-imo' na kadég na utaw na dyumalug sa palna-u nami.” ");
INSERT INTO klg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aw pagkatigkas yan, pigpalekat ni Jisus ya pagsala' sa manga eped na manga utaw na nyeya' dun ni manga lunsud na kya-imo-an nan sa madég na milagru, kay wala' silan pagselsel. ");
INSERT INTO klg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yanagaw miglong si Jisus kanilan, “Kadég mayu na taga lunsud na Korazin aw Bétsayda, malatay ya un mayu datengan! Kay kyinita' da mayu ya manga milagru na pig-imo' ku, manang tabay kamayu ya migselsel. Kun pig-imo' pa ku yeiy adti manga lunsud na Tiro aw Sidon, madugay da galu silan magselsel aw mangawak sa kalapeng aw magsabug sa abu adti kanilan ulu na yan ya pangilala sa kanilan pagselsel. ");
INSERT INTO klg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Manang paglongun ta kamu: To-o pa baling mabegat ya pa-emel-emel kamayu na Tyumanem dun ni allaw na pag-ukum kay sa manga utaw na nyeya' dun ni Tiro aw Sidon. ");
INSERT INTO klg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aw kamu na nyeya' dun ni Kapirna-um, unu, iman mayu aw ya pagkadengganen mayu dyumateng adti tas na langit aw wala' ya maka-unawa kamayu? Padalemen kamu saba, aw dala͡en kamu adti banwa na Kaludukan. Kay kun pigpan-imo' pa ku dun ni Sodoma ya manga milagru kasiling na pig-imo' ku dun ni kamayu, kenne' pa galu na syudad yan adun. ");
INSERT INTO klg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Manang paglongun ta kamu: Pagdateng da na allaw na pag-ukum, to-o pa baling dun mabegat ya pa-emel-emel na Tyumanem kamayu kay sa manga utaw na nyeya' dun ni Sodoma!” ");
INSERT INTO klg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dun ni udas yan, nyanawagtawag si Jisus adti Ama, “Kay Ma', ikaw ya tagtun sa kadég na awun ni tas na langit aw asini kadakula' na banwa. Pigpasalamatan ta kaw kay pigtagu' mu ya kanmu palpa lekat adti manga utaw na matas kunu ya katadeng manang pigbukasan mu baling adti manga utaw na syumalig kanmu kasiling na tagbi' na ise'. ");
INSERT INTO klg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yeiy saba kay Ma' ya kanmu pagkaliman.” ");
INSERT INTO klg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Pigtumbay da na Ama ya kadég adi kanak. Aw ya kanaken Ama, yan olo' ya tengteng nyaka-ede' kanak. Aw aku olo' ya nyaka-ede' kanan. Aw pangkay singalan ya tumbay ku na maka-ede' sa Ama, bukasan adti kanilan ya pagpaka-ede' kanan. ");
INSERT INTO klg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yanagaw, ya kadég mayu na migkalumay da ya ginawa aw to-o kyabegatan, kadi kamu ni sayid ku kay palagdengen ta kamu. ");
INSERT INTO klg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Daluga mayu ya palna-u ku. Aw pagsiling kamu kanak, kay migpadalem aku aw pakaganen ku saba ya kamayu ginawa aw palagdengen ku uman ya kamayu anenganeng. ");
INSERT INTO klg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kay ya manga sugu' ku molas saba dalugun aw dili' malug imo-un. ");
INSERT INTO klg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sambuk na allaw yan, nyanaw si Jisus aw ya kanan manga umagakan dun ni dalan na nyaka-agi adti tenga' na pawa' na awun trigu na agpet da aniyen, aw yeiy uman ya Allaw na Paglagdeng. Aw nyagetem ya manga umagakan nan, yanagaw nyanaplus silan sa trigu aw pigtebteb nilan. ");
INSERT INTO klg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Manang pagkita' na manga Parisiyo sa pig-imo' nilan, piglongan nilan si Jisus, “Inunuwa ya pig-imo' na kanmu manga umagakan! Kyalakadan nilan baling ya Uldin! Wala' saba tumbayan adti Allaw na Paglagdeng ya pag-ani!” ");
INSERT INTO klg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Manang tyumubag si Jisus kanilan, “Unu, wala' pa ka' mayu kabasa ya pigpasulat na Tyumanem asini muna sa pig-imo' ni Dabid? Sa pagkagetem nan aw manga eped nan, ");
INSERT INTO klg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","syumeled sakanan adti Balay na Tyumanem aw pigkan nan ya pan na pig-atag da adti Tyumanem. Aw pig-atped-atped nan uman ya manga eped nan pangkay yan saba olo' ya makakan ya manga magdadugsu-ay. Aw dun da baling nilan kalakadi ya Uldin. ");
INSERT INTO klg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Unu, wala' mayu uman kabasa dun ni Uldin na gayed migtalabahu ya manga magdadugsu-ay adti Témplo kada Allaw na Paglagdeng? Dun ni pagpan-imo' nilan, gayed nilan kyalakadan ya Uldin manang wala' silan pakasala'. ");
INSERT INTO klg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Paglongun ta kamu na pangkay awun katundanan na Témplo manang adun asini ni sayid mayu ya to-o pa matas. ");
INSERT INTO klg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aw kun kya-ede-an pa mayu ya tengteng kakawasan na pigpasulat na Tyumanem asini muna, dili' mayu pasala-en ya manga utaw na wala' pag-imo' sa sala'. Kay ini ya pigpasulat nan: ‘Ya kanak tengteng pagkaliman, na awun pagkallat mayu adti eped na manga utaw, aw beke' na dugsu' mayu na pagsangaben.’ ");
INSERT INTO klg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aw pig-atag da adti Ise' na Utaw ya pagbaya' sa unu ya madyaw imo-un sa Allaw na Paglagdeng.” ");
INSERT INTO klg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aw nyanaw si Jisus aw syumeled adti kanilan sinagoga. ");
INSERT INTO klg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aw dun uman ni seled na sinagoga awun sambuk na eseg na kimay ya sangkilid na bekten nan. Aw nyusip ya manga Parisiyo kan Jisus, “Unu ka', pigtumbay na Uldin tadun ya pagpaguli' dun ni Allaw na Paglagdeng?” Kay kaliman nilan na awun puliba nilan maglimanda kanan adti usayanan. ");
INSERT INTO klg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Manang tyumubag si Jisus kanilan, “Alimbawa', kun awun karniro mu na molug adti malalem na gawang dun ni Allaw na Paglagdeng, na, unu ya imo-un mayu? Maksay mayu saba tabangan aw engaten lekat adti gawang. ");
INSERT INTO klg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yanagaw ayin ya dakula' ya alaga', ya utaw aw ya karniro? Ya utaw saba! Yeiy ya du-an na pigtumbay na Tyumanem ya madyaw na imo-unun pangkay Allaw na Paglagdeng.” ");
INSERT INTO klg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aw tigkas yan, piglongan ni Jisus ya eseg na kimay, “Ulada ya bekten mu.” Aw pig-ulad nan ya bekten nan, aw dayaw kyaguli-an. Aw migkadyaw da kasiling na sangkilid na bekten nan. ");
INSERT INTO klg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Manang pagkita' na manga Parisiyo sa pig-imo' ni Jisus, lyumuwa' silan aw migpalekat silan migpalpa sa pagpapatay kanan. ");
INSERT INTO klg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Manang nya-ede' si Jisus sa pigpalpa nilan, yanagaw nyanaw sakanan lekat dun. Aw dyumalug kanan ya to-o madég na utaw. Aw pigpangguli' nan ya kadég na awun manga magkedel ");
INSERT INTO klg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aw piglongan nan silan na dili' mag-ubat-ubat adti eped kun singalan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yanagaw nyatuman da ya pigpasulat na Tyumanem asini muna magi sa propita nan na si Isayas: ");
INSERT INTO klg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tanawa! Ini la saba ya sugu-anen na kanak pigpadala. To-o ku sakanan pigginawa͡an aw kyatutukan aku kanan. Ya kanak Ispiritu, yan ya maggagad kanan, aw ubat-ubat nan adti manga nasud ya kanak pagbaya' na alag matinaw. ");
INSERT INTO klg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dili' sakanan mati-ayil aw dili' uman magpamuligsa' adti asdangan na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pangkay ya tin tigbaw na baluk, dili' nan lepeden, aw pangkay ya salengan na dakman mag-ulileng, dili' nan saba eyepen. Manang pagkallatan nan baling ya manga utaw na to-o makalalat. Padelegen nan ya kanan imo-unun menda' na matuman da ya kadég na pigpalpa na Tyumanem aw degen nan ya malatay. ");
INSERT INTO klg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aw dun ni kanan ngalan awun imanen na kadég na utaw asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pagkatigkas yan, pigpa-agad adti kan Jisus ya sambuk na utaw na dili' magkita' aw nya-umu kay pigseledan na busaw. Aw pig-alilinan ni Jisus ya busaw, aw kyaguli-an ya utaw yan aw dayaw nyakapaglong aw kyumita' da. ");
INSERT INTO klg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aw to-o nya-enneng-enneng ya kadég na manga utaw dun, aw miglong silan, “Pagaw yeiy da ya buwadbuwad ni Dabid na pigtagadan tadun.” ");
INSERT INTO klg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Manang pagdengeg na manga Parisiyo sa piglong na manga utaw, miglong silan, “Ya utaw yan, mig-alilin sa manga busaw magi sa katulus ni Bilsibul na pangulu na manga busaw.” ");
INSERT INTO klg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Manang kya-ede-an ni Jisus ya adti anenganeng nilan, yanagaw piglongan nan silan, “Ya kasakupan na nyatenga-tenga', dili' yan magpadeleg na madugay. Aw maynan uman ya lunsud na awun pagkatenga-tenga' aw pangkay uman dun ni seled na balay. ");
INSERT INTO klg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aw kun si Satanas ya mig-alilin sa manga sakup nan, na, kasiling na pigtanam nan ya kanan pagka-utawun. Aw magkalat saba ya pagdumala nan, aw dun da sakanan dega. ");
INSERT INTO klg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aw kun kan Bilsibul katulus ya kanak pag-alilin sa manga busaw, na, usipen ta kamu: Ya kamayu uman manga sakup na mag-alilin sa manga busaw, ayin ka' lekat ya katulus na pig-atag kanilan? Silan saba ya magmatinaw na galu' ya piglong mayu! ");
INSERT INTO klg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Manang kun magi sa Ispiritu Santo ya pag-alilin ku sa manga busaw, na, dun da mayu ka-ede-i na asini la ni kamayu ya Pigpadala na Tyumanem na un mag-imo' sa kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Si Satanas kasiling na utaw na to-o mabagseg na tagtun sa balay. Wala' ya pangkay sambuk na makaseled adti balay nan pada takawun ya kanan ka-unan kun dili' una gapusun ya tagtun. Manang kun magapus da ya tagtun, mabatug da kamangen ya manga ka-unan nan. ");
INSERT INTO klg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ya utaw na wala' pagpasakup kanak, yan baling ya gayed migbalabag sa kanak manga imo-unun. Aw kun awun dili' tumabang maggagad sa manga utaw adi kanak, yan ya mig-ampang kanilan adti kanak kasakupan. ");
INSERT INTO klg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yanagaw paglongun ta kamu: Pangkay unu ya sala' na utaw adti Tyumanem, aw pangkay unu ya paglongun nan na malatay adti eped nan, mabatug na Tyumanem lanasen ya sala' na utaw yan. Manang dili' nan lanasen ya sala' na utaw na maglong sa malatay adti Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pangkay singalan ya maglong sa malatay adti Ise' na Utaw, mabatug uman na Tyumanem lanasen ya sala' na utaw yan. Manang kun singalan ya maglong sa malatay adti Ispiritu Santo, yan ya sala' na dili' mabatug lanasen. Aw ya sampetan na sala' yeiy, pa-emel-emelen sakanan na Tyumanem na wala' ya tyamanan.” ");
INSERT INTO klg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Migpadeleg si Jisus miglong adti manga Parisiyo, “Kun madyaw ya kawuy, madyaw uman ya bunga nan. Manang kun dili' madyaw ya kawuy, dili' uman madyaw ya bunga nan. Yanagaw ya kawuy na madyaw, ka-ede-an saba magi dun ni bunga nan. ");
INSERT INTO klg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Manang kamu, kasiling na kamangayse-anan na kamugung! Unun mayu ya paglong sa madyaw kun malatay ya adti anenganeng mayu? Kay pangkay unu ya awun ni anenganeng na utaw, yan uman ya paglongun nan. ");
INSERT INTO klg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kun gayed madyaw ya pig-anenganeng na utaw, madyaw uman ya imo-unun aw paglongun nan. Manang kun malatay ya pig-anenganeng nan, malatay uman ya imo-unun aw paglongun nan. ");
INSERT INTO klg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aw miglong aku kamayu na dun ni allaw na pag-ukum, awun saba tubagenen na tagsambuksambuk kamayu sa piglong mayu na wala' ya ma-untung. ");
INSERT INTO klg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay magi sa kanmu paglong, yan ya magmatinaw kun umba' kaw pa-emel-emelen aw ya dili'.” ");
INSERT INTO klg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na, awun manga magpalna-uway sa Uldin aw manga Parisiyo dun, aw piglongan nilan si Jisus, “Kay Sir, kaliman nami kumita' sa pangilala na yan ya magmatinaw na pigpadala kaw na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Manang miglong si Jisus kanilan, “Tay sa kalatay na manga utaw adun na manga allaw yeiy. Pigtalikudan nilan ya Tyumanem, aw kasiling silan na ka͡ubayan na miglakadenen. Gayed silan migsekat sa pangilala, manang ya pangilala na un ku atag kanilan, yan olo' ya kasiling na nya-imo' kan Jonas na propita na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kay seled na tulungallaw aw tulunggabi ni Jonas dun ni buntit na dakula' na isda', aw maynan uman seled na tulungallaw aw tulunggabi na Ise' na Utaw adti dalem na lupa'. ");
INSERT INTO klg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pagdateng na allaw na pag-ukum, ya manga utaw dun ni syudad na Ninibé selselen nilan ya kadég mayu. Kay sa pagpakanyeg nilan sa pag-ubat-ubat ni Jonas, migselsel silan sa kanilan manga sala'. Manang kamu, pangkay ini tampid mayu ya to-o pa matas kan Jonas, manang wala' mayu baling pangintu-uwi aw wala' kamu uman pagselsel! ");
INSERT INTO klg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aw dun ni allaw na pag-ukum, ya réyna na migdumala asini muna sa banwa na Syiba, selselen nan uman ya kadég mayu. Kay nyanaw sakanan lekat adti mawat na banwa pada magpakanyeg sa katadeng na hari' na si Solomon. Manang paglongun ta kamu na pangkay ini tampid mayu ya to-o pa matas kan Solomon, manang wala' mayu sakanan pakanyegi. ");
INSERT INTO klg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na, kun awun busaw na lumuwa' adti utaw, maglegeblegeb yan adti kaligbinan na wala' ya tubig aw maninaw sa un nan ka-eya-an manang wala' ya kita-en nan dun. ");
INSERT INTO klg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yanagaw maglong adti anenganeng nan, ‘Un ku baling liku-an ya muna pig-eya-an ku.’ Aw sa pagliku' nan, kita-en nan na wala' pa ya mig-eya' dun aw malinis da ya pig-indegan da nan idtu muna, kasiling na balay na dayaw pyamunasan aw nyatigpes da. ");
INSERT INTO klg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aw tigkas yan, mangay sakanan sa pitu ya eped nan na to-o pa baling malatay. Aw sumeled silan adti utaw yan, aw dun da silan pag-eya'. Aw to-o pa malatay ya kabetangan na utaw yan kay sa idtu muna. Aw kasiling uman na maynan ya un kagamakan na manga utaw na malatay adun na manga allaw yeiy.” ");
INSERT INTO klg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aw talana pa ni Jisus miglong adti madég na manga utaw dun, dyumateng ya ina nan aw manga inulug nan. Aw nyan-indeg silan adti luwa' na balay kay kaliman nilan magbalawbalaw kanan. ");
INSERT INTO klg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aw awun utaw na miglong kan Jisus, “Awun ni luwa' ya ina mu aw manga inulug mu, aw kaliman nilan magbalawbalaw kanmu.” ");
INSERT INTO klg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aw tyumubag si Jisus kanan, “Awun pa saba uman pigsiling ku na kanak ina aw kanak manga inulug.” ");
INSERT INTO klg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aw pigtulli' ni Jisus ya manga umagakan nan, aw miglong sakanan, “Inunuwa mayu! Ya manga utaw ini, silan uman ya kasiling na ina ku aw kanak manga inulug! ");
INSERT INTO klg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pangkay singalan ya mag-imo' sa pagkaliman na kanak Ama na awun ni tas na langit, silan uman ya kanak manga inulug aw manga bubay aw ina ku.” ");
INSERT INTO klg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aw dun ni allaw yan, lyumuwa' si Jisus adti balay aw nyingkud adti dulug na danaw. ");
INSERT INTO klg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aw wala' kadugay, migkalimpung kanan ya to-o madég na manga utaw. Yanagaw mig-alin si Jisus adti balangay na malapit dun ni baklayan aw nyingkud sakanan na un magpalna-u kanilan. Aw nyan-indeg ya manga utaw dun ni baklayan kay kaliman nilan magpakanyeg sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aw migpalekat sakanan migpalna-u kanilan magi sa manga pundinganan, law nan, “Pakanyegi mayu ya un ku paglongun! Awun sambuk na utaw na nyadtu ni pawa' nan na un magsabug sa manga bini'. ");
INSERT INTO klg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa pagsabug nan sa manga bini', awun eped na nyakasabug adti kilid na dalan. Aw nyangkawun ya manga langgam aw pyanubug nilan ya manga bini'. ");
INSERT INTO klg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aw awun manga eped na nyakasabug adti kabatuwan aw maksay gyumiti' kay wala' abay ya lupa'. ");
INSERT INTO klg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Manang pagsilat da na sega, nyangkalanes baling ya manga tanem kay wala' to-o pakadalid. ");
INSERT INTO klg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ya eped na manga bini' nyakasabug adti magalet na suksukun. Gyumiti' ya manga bini', manang asuntu na tyumulin uman ya magalet, nyalemes baling ya manga tanem. ");
INSERT INTO klg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ya eped na manga bini' nyakasabug adti mataba' na lupa', aw tyumulin aw to-o nyamunga. Awun nyunga na tag sanggatus, aw awun nyunga na tag ka͡eneman, aw awun uman nyunga na tag katluwan. ");
INSERT INTO klg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sa pag-uli' da na madég na manga utaw, dyumulud kan Jisus ya kanan manga umagakan, aw nyusip silan kanan, “Ananga' magi sa manga pundinganan ya pagpalna-u mu sa manga utaw?” ");
INSERT INTO klg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aw tyumubag si Jisus kanilan, “Pigtumbay da kamayu na Tyumanem ya pagka-ede' sa manga pigtagu' idtu muna sa Kasakupan na Pighari-an nan. Manang awun manga eped na pangkay dyengeg da nilan ya pundinganan ku manang wala' tumbayan adti kanilan ya pagpakalabet sa kakawasan. ");
INSERT INTO klg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kay ya utaw na dyumalug sa pigpalna-u la kanan, dugangan pa ya kyalabetan nan aw magkadakula' pa. Manang ya utaw na wala' dalug sa palna-u yan, kamangen baling adti kanan anenganeng ya pangkay tagbi' na kyalabetan da nan. ");
INSERT INTO klg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yeiy ya du-an na ya kanak pagpalna-u pigpa-agi ku sa manga pundinganan. Pangkay gayed nilan inunuwun manang dili' nilan kalabetan ya kyinita' nilan. Aw pangkay gayed nilan dengegen manang dili' nilan uman kalabetan ya kakawasan na dyengeg nilan. ");
INSERT INTO klg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aw dun ni kanilan katuman ya pigpasulat na Tyumanem magi sa propita nan na si Isayas asini muna: “Pangkay pakanyegan mayu, manang dili' mayu saba kalabetan, aw inunuwun mayu manang dili' mayu uman kita-en. ");
INSERT INTO klg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay mangkategel da ya anenganeng na manga utaw yeiy. Pigsengseng da nilan ya kanilan manga talinga pada dili' silan makadengeg, aw pigpileng da nilan ya kanilan manga mata pagaw kita-en nilan ya matinaw aw ka͡apetan na anenganeng nilan, aw dili' silan malim magselsel sa manga sala' nilan pada paluwa-en ku silan.” ");
INSERT INTO klg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Manang madyaw ya kamayu kay kyinita' da mayu aw kyalabetan da mayu ya kakawasan na kamayu pigdengeg! ");
INSERT INTO klg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aw matinaw ya un ku paglongun kamayu: Awun madég na manga propita aw manga utaw na dyumalug sa pagkaliman na Tyumanem asini muna na kaliman galu nilan kumita' sa kyinita' da mayu, aw kaliman nilan uman galu dengegen ya dyengeg da mayu. Manang wala' nilan kita-a aw wala' nilan uman dengega. ");
INSERT INTO klg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, pakanyegi mayu to-o ya kakawasan na pundinganan sa migsabug sa manga bini': ");
INSERT INTO klg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ya kilid na dalan na kyasabugan sa manga bini’, yan ya manga utaw na dyumengeg da sa ubat-ubat sa Kasakupan na Pighari-an na Tyumanem manang dili' nilan kalabetan ya tengteng kakawasan. Yanagaw dumateng si Satanas aw dampasen nan adti kanilan ya tingeg na Tyumanem na dyengeg da nilan. ");
INSERT INTO klg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Aw ya kabatuwan na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg sa tingeg na Tyumanem aw maksay nilan pigdawat na awun pagleya ");
INSERT INTO klg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","manang dili' to-o makadalid ya pagpangintu-u nilan. Kun awun dumateng na manga kalugan aw manga pagpamulayam asuntu sa tingeg na Tyumanem na dyengeg nilan, maksay nilan ayawan ya kanilan pagpangintu-u. ");
INSERT INTO klg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Aw ya magalet na sukusukun na kyasabugan uman sa manga bini', yan ya manga utaw na dyumengeg da sa tingeg na Tyumanem manang ya kanilan anenganeng nyatmu' na kakaypengan sa pagpakabetang nilan, aw sa pag-anenganeng na ma-imo' mayaman. Aw ya sampetan yan, dili' makabunga ya pagpangintu-u nilan. ");
INSERT INTO klg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Manang ya mataba' na lupa' na kyasabugan sa manga bini', yan ya manga utaw na migpakanyeg sa tingeg na Tyumanem aw kyalabetan nilan ya tengteng kakawasan. Aw mamunga silan sa madég. Ya sambuk, mamunga na sanggatus, aw ya eped, ka͡eneman, aw ya eped, katluwan.” ");
INSERT INTO klg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aw pig-ubat-ubatan pa silan ni Jisus sa sambuk na pundinganan, law nan, “Ya Kasakupan na Pighari-an na Tyumanem, kasiling na maynini: Awun utaw na migpatanem adti pawa' nan. ");
INSERT INTO klg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Manang sa pagkagabi la, talana nyampakatulug ya kadég, nyawun ya kanan po-on dun ni pawa'. Aw pigsabugan nan uman na manga bini' na sagbet, aw tigkas yan nyanaw sakanan. ");
INSERT INTO klg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Na, sa paggiti' da na manga trigu, gyumiti' uman ya manga sagbet. Aw sa pagbunga la na trigu, dun da ka-ede-i na awun kadi' sagbet na nyakadali'. ");
INSERT INTO klg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aw nyadtu ya manga magtalabahuway adti tagtun sa pawa', aw miglong silan, ‘Kay Amu, madyaw ya bini' na pigpatanem mu kanami dun ni kanmu pawa'. Ananga' awun sagbet na nyakadali' aw ayin uman lekat ya manga sagbet yan?’ ");
INSERT INTO klg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Aw tyumubag kanilan ya tagtun, ‘Yeiy saba ya pag-imo-un na po-on.’ “Yanagaw nyusip silan kanan, ‘Kay Amu, unu, panggabutun nami ya manga sagbet?’ ");
INSERT INTO klg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Manang tyumubag ya amu nilan, ‘Ya-i mayu paggabuta pagaw maka-agad baling ya manga trigu! ");
INSERT INTO klg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabaya-i la ya trigu aw manga sagbet na magdengan tumulin menda' na dumateng ya allaw na aniyen da. Aw dun ni allaw yan, paglongun ku ya manga mag-aniyay, ‘Una͡a mayu panimuna ya manga sagbet aw pamanggeti aw agbelan adti atulun. Aw tigkas yan, panimuna mayu uman ya trigu aw betangan adti kanak pul.’ ” ");
INSERT INTO klg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aw pig-ubat-ubatan pa uman silan ni Jisus sa sambuk na pundinganan, law nan, “Ya Kasakupan na Pighari-an na Tyumanem, kasiling uman na sambuk na bini' na mustardo na pigtanem na utaw adti pawa' nan. ");
INSERT INTO klg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pangkay yan ya to-o tagbi' sa kadég na punganan na manga bini', manang kun tumulin yeiy, matas pa sa eped na manga tanem. Kasiling saba na kawuy na umba' kapugadan na manga langgam ya manga sanga nan.” ");
INSERT INTO klg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aw miglong pa uman si Jisus kanilan sa eped na pundinganan, law nan, “Ya Kasakupan na Pighari-an na Tyumanem kasiling uman na tagbi' na patulinay na pigdali' na ka͡ubayan adti dakula' na harina, aw pigtagadan nan na mabus tumulin ya kadakula' na harina na pigmasa nan.” ");
INSERT INTO klg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ya kadég yeiy na pigpalna-u ni Jisus adti madég na manga utaw, pigpa-agi nan sa manga pundinganan. Wala' nan silan palna-uwi na beke' na magi sa pagpundinganan. ");
INSERT INTO klg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aw dun ni kan Jisus katuman ya pigpasulat na Tyumanem asini muna sa sambuk na propita: “Magi sa manga pundinganan ya pagpalna-u ku. Bangalen ku ya manga nyatagu' asini muna lekat pa na pagka-imo' na kadakula' na banwa.” ");
INSERT INTO klg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatigkas ni Jisus migpalna-u, pig-indegan nan ya manga utaw aw syumeled sakanan adti balay. Aw nyagad uman ya kanan manga umagakan, aw miglong silan, “Ubati kami sa kakawasan na pundinganan sa manga sagbet adti pawa'.” ");
INSERT INTO klg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aw miglong si Jisus kanilan, “Ya utaw na pyalabet dun na migtanem sa madyaw na bini', yan ya Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya pawa', yan ya kadakula' na banwa na pig-eya-an na manga utaw. Aw ya mangkadyaw na bini', yan ya manga utaw na nyaka-akup dun ni Kasakupan na Pighari-an na Tyumanem. Manang ya manga sagbet, yan ya manga utaw na awun ni kasakupan ni Satanas. ");
INSERT INTO klg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aw ya po-on na migsabug sa manga bini' na sagbet, yan si Satanas. Aw ya pag-ani, yan ya un ma-imo' adti kamoliyan na manga allaw. Aw ya manga mag-aniyay, yan ya manga anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yanagaw, kasiling na manga sagbet na pigbanggetan da aw sangaben adti atulun, maynan uman ya ma-imo' kagaya dun ni kamoliyan na manga allaw. ");
INSERT INTO klg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aw aku na Ise' na Utaw, sugu-un ku ya kanak manga anghil, aw alilinan nilan lekat adti kanak kasakupan ya kadég na migbuyu sa manga utaw adti pag-imo' sa manga malatay aw ya kadég na gayed migpakasala'. ");
INSERT INTO klg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aw alag silan pan-agbel adti atulun na dili' pagkapatayan. Aw adtu silan pagpansisugaw aw magpansipanguliteb ya manga untu nilan. ");
INSERT INTO klg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pagkatigkas yan, ya manga utaw na dyumalug sa pagkaliman na Tyumanem, sumilat silan kasiling na sega adti Kasakupan na Pighari-an na kanilan Ama. “Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu. ");
INSERT INTO klg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Na, ya Kasakupan na Pighari-an na Tyumanem, kasiling uman na pametang na dakula' ya alaga' na pigtagu' adti dalem na lupa' dun ni pawa'. Pigkita' na sambuk na utaw, aw to-o sakanan migleya. Yanagaw pigliku' nan pigtabunan, aw tigkas yan piggalin nan ya kadég na nyatagtun nan, aw pigbayadan nan ya pawa' yan. ");
INSERT INTO klg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aw ya Kasakupan na Pighari-an na Tyumanem kasiling uman na maynini: Awun utaw na magbalikwatay na nyaninaw sa to-o manenggeya na manga pérlas. ");
INSERT INTO klg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tantanan nan paninawun kyinita' nan ya sambuk na pérlas na to-o dakula' ya alaga'. Yanagaw maksay nan piggalin ya kadég na nyatagtun nan aw pigbayadan nan ya pérlas yan. ");
INSERT INTO klg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aw maynan uman, ya Kasakupan na Pighari-an na Tyumanem kasiling na maynini: Awun pukut na pig-ulug mangisda-ay adti tubig. Aw wala' kadugay, madég ya punganan na isda' na nyakamang. ");
INSERT INTO klg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pagkatmu' da na pukut, pigguyud nilan adti ligad. Aw nyingkud silan aw nyamalli' sa isda'. Ya manga mangkadyaw na isda' pigseled nilan adti manga babalanan, manang ya manga isda' na wala' ya guna pyan-agbel nilan. ");
INSERT INTO klg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Maynan uman ya ma-imo' sa manga utaw adti kamoliyan na manga allaw. Madi ya manga anghil asini tas na lupa', aw tapiden nilan ya manga utaw na mangkalatay lekat adti manga utaw na dyumalug sa pagkaliman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aw agbel nilan ya manga mangkalatay adti atulun na dili' pagkapatayan. Aw adtu silan pagpansisugaw aw magpansipanguliteb ya manga untu nilan.” ");
INSERT INTO klg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pagkatigkas ni Jisus maglong sa manga pundinganan yeiy, nyusip sakanan sa manga umagakan nan, “Unu, kyalabetan da mayu ya kadég na piglong ku kamayu?” Aw tyumubag silan kanan, “E-e.” ");
INSERT INTO klg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aw miglong pa si Jisus kanilan, “Alimbawa', kun awun magpalna-uway sa dadan na Uldin na manga Judiyu, aw dawata nan ya bagu na palna-u sa Kasakupan na Pighari-an na Tyumanem, kasiling sakanan na utaw na mayaman na migkamang sa bagu aw dadan na pametang lekat adti kaban nan. Kay kya-ede-an nan alag ya dadan aw ya bagu na palna-u.” ");
INSERT INTO klg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na, pagkatigkas ni Jisus migpalna-u sa manga utaw magi sa manga pundinganan, pig-indegan nan ya banwa yan. ");
INSERT INTO klg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aw nyuli' sakanan adti lunsud na Nazarit na yan ya pigtulinan nan, aw migpalekat sakanan migpalna-u sa manga utaw dun ni sinagoga nilan. Aw sa pagdengeg nilan sa pigpalna-u nan, to-o silan nyabelengbeleng. Aw miglong silan, “Ayin lekat ya katadeng nan yeiy? Aw pig-unu nan ya pagpaka-imo' sa manga milagru? ");
INSERT INTO klg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ise' saba olo' sakanan na panday. Enda', ya ina nan si Maria. Aw ya manga inulug nan, yan si Santiago, aw si José, aw si Simon, aw si Judas! ");
INSERT INTO klg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aw asini uman pag-eya' ya kadég na manga bubay nan. Ayin kamanga na utaw yeiy ya katulus aw ya katadeng nan?” ");
INSERT INTO klg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yanagaw wala' silan pangintu-u kanan. Aw miglong si Jisus kanilan, “Wala' ya propita na pagdawaten adti kanan banwa aw kanan kadégan, manang adti eped baling na banwa pagdawaten sakanan.” ");
INSERT INTO klg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aw asuntu na wala' silan pangintu-u kanan, tabay ya manga milagru na pig-imo' ni Jisus dun ni kanilan. ");
INSERT INTO klg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dun ni manga allaw yan, si Hérodés Antipas ya migdumala sa banwa na Galiliya. Aw pigdengeg nan ya manga pig-imo' ni Jisus, ");
INSERT INTO klg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yanagaw miglong sakanan adti manga pigsaligan nan, “Yeiy saba si Juan na Magba͡utismuway! Nyataw da kadi' lekat adti pagkamatay! Yan ya du-an na nyaka-imo' sakanan sa manga milagru.” ");
INSERT INTO klg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nyakapaglong si Hérodés sa maynan asuntu sa pig-imo' nan kan Juan idtu muna. Kay pigpadakep nan si Juan, aw pigpagapus aw pigpakalabusu nan, asuntu na gayed sakanan pigsagda ni Juan na miglong, “Pigpigil saba adti Uldin na manga Judiyu ya pagpanga͡ubayan sa ka͡ubayan na inulug mu.” Kay kyamang ni Hérodés si Hérodiyas na ka͡ubayan na inulug nan na si Pilipi. ");
INSERT INTO klg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aw pangkay kaliman galu ni Hérodés patayen si Juan, manang nyallek kun unu ya imo-un na manga utaw kanan. Kay kya-ede-an nilan na si Juan ya sambuk na propita na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, pagdateng da na allaw ni Hérodés, syumayaw ya dalaga ni Hérodiyas adti asdangan na kadég na pyamilit dun ni katipun, aw to-o migleya si Hérodés kanan. ");
INSERT INTO klg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aw pigpakangan nan ya dalaga magi sa sapa' na atag nan ya pangkay unu ya sekaten nan. ");
INSERT INTO klg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yanagaw pigpalna-uwan na ina nan, na yeiy ya paglongun na dalaga adti kan Hérodés, “Atagan kanak adun ya ulu ni Juan na Magba͡utismuway na dayaw betang adti dakula' na palatu!” ");
INSERT INTO klg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagdengeg ni Hérodés sa tubag na dalaga, migkalat to-o ya ginawa nan. Manang asuntu na nyakasapa' da sakanan dun ni asdangan na kadég na pyamilit nan, syumugu' na atag adti dalaga ya pigsekat nan. ");
INSERT INTO klg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yanagaw pigpa-utudan nan sa ulu si Juan adti kalabusuwanan. ");
INSERT INTO klg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aw pigbetang ya ulu adti dakula' na palatu, aw pig-atag adti dalaga, aw dyala uman na dalaga adti ina nan. ");
INSERT INTO klg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aw pig-angay na manga umagakan ni Juan ya lawas nan aw piglebeng nilan. Tigkas yan, kyadtuwan nilan si Jisus aw pig-ubat-ubatan nilan sa kadég na nya-imo'. ");
INSERT INTO klg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, pagdengeg ni Jisus sa nya-imo' kan Juan, pig-indegan nan ya banwa yan, aw syumakay sakanan sa balangay pasinan adti kaligbinan. Manang pagdengeg na madég to-o na utaw kun ayin ya un nan kadtuwan, pig-indegan nilan uman ya manga lunsud nilan aw nyanaw silan migpadulug sa danaw pasinan adti pigkadtuwan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sa pagpanog ni Jisus lekat adti balangay, kyinita' nan ya madég to-o na utaw na migkatipun dun. Aw to-o nan silan kyallatan, aw pigpangguli' nan ya kadég na awun magkedel. ");
INSERT INTO klg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagka͡ambung da, dyumulud kan Jisus ya kanan manga umagakan aw miglong silan, “Ambung da to-o aw wala' ya makan asini banwa ini. Ayin ya madyaw kun papanawun da ya manga utaw pada makabayad silan sa makan nilan dun ni manga baranggay.” ");
INSERT INTO klg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Manang tyumubag si Jisus kanilan, “Dili' ka-ilangan na manaw silan. Kamu baling ya matag kanilan sa un nilan makan.” ");
INSERT INTO klg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aw miglong silan kanan, “Olo' da limallapid ya pan aw duwambulus ya isda' ini.” ");
INSERT INTO klg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yanagaw miglong si Jisus kanilan, “Dala͡a mayu adi kanak.” ");
INSERT INTO klg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tigkas yan, piglongan nan ya manga utaw na dayaw silan mingkud dun ni sakati. Aw pigkamang nan ya limallapid ya pan aw ya duwambulus ya isda', aw lyumangad sakanan adti langit aw pigpasalamatan nan adti Tyumanem. Aw tigkas yan, pigtenga-tenga' nan ya pan aw pig-atag nan adti kanan manga umagakan aw pyan-atped-atped nilan adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aw kyuman ya kadég nilan, aw alag silan nyangkabiyag. Aw pigpan-imun na kanan manga umagakan ya nyangkasama', aw nyangkatmu' ya sampulu' tag duwa ya be-en. ");
INSERT INTO klg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na, ya kadég na kyuman dun, manga limammalalan ya eseg aw wala' pa ya labet na manga ka͡ubayan aw mangayse'. ");
INSERT INTO klg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sa abus da pakakan ya manga utaw, maksay pigsugu' ni Jisus ya kanan manga umagakan na lumiku' sumakay adti balangay, aw muna la silan adti dipag na danaw, kay un pa nan papanawun ya kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aw pagkatigkas da ni Jisus papanawun ya manga utaw, tyumukud sakanan adti buntud na olo' nan sayda na un manawagtawag adti Tyumanem. Aw kyagabiyanan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aw ya balangay na pigsakayan na manga umagakan nan, mawat da lekat adti ligad na danaw, aw pigsalumpak nilan ya samet aw ya baled. ");
INSERT INTO klg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na, sa pagpakallawunun da, nyanaw si Jisus adti tas na tubig aw migpasinan adti kanilan. ");
INSERT INTO klg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Manang pagkita' nilan na awun nyanaw adti tas na tubig, to-o silan nyallek. Aw mig-ulangag silan na miglong, “Iyan da ya ma-allekay!” ");
INSERT INTO klg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Manang maksay si Jisus migtawag kanilan, “Dili' kamu magkallek! Aku saba ya ini! Pakabagsega ya kamayu ginawa.” ");
INSERT INTO klg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aw pigtatawag ni Pédro si Jisus, “Kay Magpalna-uway, kun tengteng na ikaw ya iyan, na, pakadtuwa aku ni sayid mu dun ni tas na tubig.” ");
INSERT INTO klg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aw miglong si Jisus kanan, “Adi kaw!” Yanagaw nyanog si Pédro adti balangay aw nyanaw dun ni tas na tubig pasinan adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Manang pagbati' nan sa samet, to-o sakanan nyallek, aw un da galu malemes. Yanagaw mig-ulangag sakanan, “Kay Magpalna-uway! Tabangi aku beg!” ");
INSERT INTO klg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aw maksay ni Jisus pig-awidan ya bekten nan aw engata lekat adti tubig, aw piglongan nan, “Tay sa katagbi' na pagsalig mu kanak! Ananga' kaw magduwaduwa?” ");
INSERT INTO klg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sa pagsakay da nilan adti balangay, dayaw uman tyumangke' ya samet. ");
INSERT INTO klg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aw ya kadég nilan dun ni balangay, pigdeyen nilan si Jisus, aw miglong silan, “Matinaw saba na ikaw ya Ise' na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagpakatalipag da nilan, dyumunggu' silan adti banwa na Génésarét. ");
INSERT INTO klg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aw sa pagka-ede' na manga utaw na si Jisus ya dyumateng adti kanilan banwa, maksay nilan uman pigpa-ede' adti kadég na banwa na nyakapalibed dun. Yanagaw pyandala nilan adti kan Jisus ya manga pyangkedelan. ");
INSERT INTO klg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aw nyanginayu' ya manga utaw kan Jisus na pa-awiden nan ya manga pyangkedelan sa pangaway na pigsut nan. Aw ya kadég na nyaka-awid, alag silan kyaguli-an. ");
INSERT INTO klg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sambuk na allaw yan, awun dyumateng lekat adti Jérusalim na manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu. Aw dyumulud silan adti kan Jisus, ");
INSERT INTO klg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","aw nyusip silan, “Ananga' na manga umagakan mu lakadan ya manga katanem na mangkabaklegay tadun? Kay ya kanmu manga umagakan, kyuman silan na wala' una pag-unaw!” ");
INSERT INTO klg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Manang nyusip si Jisus kanilan, “Kamu uman, ananga' mayu lakadan ya sugu' na Tyumanem magi sa pagdalug mayu sa kamayu katanem? ");
INSERT INTO klg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kay yan saba ya sugu' na Tyumanem asini muna dun ni Uldin, ‘Pagbasa͡an mayu ya kamayu ama aw ina’ aw ‘Pangkay singalan ya maglong sa malatay adti kanan ama aw ina, patayen ya utaw yan.’ ");
INSERT INTO klg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Manang sangkamulu' ya pigpalna-u mayu. Kay pigpalna-uwan mayu ya manga utaw na maglong silan adti kanilan ama aw ina, ‘Pasinsiyayi beg aku, kay wala' da ya kabatug ku magtabang kamayu, kay pigtani la ku adti Tyumanem ya un ku galu atag adti kamayu.’ ");
INSERT INTO klg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yanagaw dun ni kamayu pigpalna-u aw pigpan-imo', kasiling na pigtumbay mayu baling adti utaw na pabaya-an nilan ya kanilan mangkatikadeng. Pigpalipaslipasan mayu ya sugu' na Tyumanem, asuntu olo' sa manga katanem mayu. ");
INSERT INTO klg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Migtallalingu kamu! Matinaw saba ya pigpasulat dadan kan Isayas sa bet mayu, law na Tyumanem: ");
INSERT INTO klg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ya manga utaw ini, pigbasa͡an aku nilan magi olo' dun ni paglong nilan, manang ya kanilan anenganeng mawat adi kanak. ");
INSERT INTO klg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wala' ya guna na pagsimba nilan kanak, kay pigsayuwan nilan baling ya kanak manga sugu' sa palna-u na pig-imo-imo' olo' na manga utaw.’ ” ");
INSERT INTO klg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tigkas yan, pigtawag ni Jisus ya madég na utaw, aw piglongan nan silan, “Pakanyegi aw anenganenga mayu ya un ku paglongun: ");
INSERT INTO klg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Beke' na pagkanen na utaw ya makapalipa' kanan, manang ya tingeg nan na malatay na lyumekat adti kanan anenganeng, yan saba ya makapalipa' kanan.” ");
INSERT INTO klg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tigkas yan, nyusip kan Jisus ya kanan manga umagakan, “Unu, kya-ede-an mu na nyadaman ya manga Parisiyo asuntu sa piglong mu?” ");
INSERT INTO klg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Manang tyumubag si Jisus kanilan, “Ya kanak Ama na awun ni tas na langit, un nan saba panggabutun ya kadég na tanem na wala' nan tanema. ");
INSERT INTO klg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabaya-i la ya manga utaw yan! Buta silan na gayed miggagad sa eped nilan na buta. Aw kun ya buta gagaden na sambuk na buta, na, alag silan molug adti gawang.” ");
INSERT INTO klg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pagkatigkas yan, miglong si Pédro kan Jisus, “Ubatan beg kanami ya kakawasan na pundinganan mu kakayna kun unu ya makapalipa' sa utaw.” ");
INSERT INTO klg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aw miglong si Jisus kanilan, “Pangkay kamu uman wala' pa pakalabet sa kakawasan na piglong ku? ");
INSERT INTO klg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wala' ka' mayu ka-ede-i na pangkay unu ya kanen na utaw, alag lumos adti buntit nan aw dili' madugay lumuwa' adti lawas nan? ");
INSERT INTO klg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Manang ya paglongun na utaw, yan ya lyumekat adti anenganeng nan. Aw yeiy saba ya makapalipa' sa utaw adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay ya anenganeng na utaw, yan ya lyekatan sa kadég na malatay kasiling na pagpatay sa eped na utaw, aw ya paglakadenen, aw ya pagkasala-enen, aw ya pagpanakaw, aw ya pagmatinaw sa galu' adti asdangan na mag-usayay, aw ya paglong sa makapagkalat sa dengeg na eped na utaw. ");
INSERT INTO klg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yeiy alag ya makapalipa' sa utaw. Manang kun kuman ya utaw na dili' mag-unaw, dili' yan makapalipa' kanan.” ");
INSERT INTO klg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pagkatigkas yan, pig-indegan ni Jisus ya banwa na Galiliya, aw nyadtu sakanan ni banwa na sakup na manga lunsud na Tiro aw Sidon. ");
INSERT INTO klg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aw awun nyeya' dun na ka͡ubayan na Héntil na lekat adti buwadbuwad ni Canaan. Aw sa pagdengeg nan na dyumateng si Jisus, nyadtu sakanan ni sayid nan aw gayed nyanginayu', law nan, “Kay Sir na buwadbuwad ni Dabid, kallati beg aku! Ya ise' ku na bubay, pigpati-is sakanan to-o na busaw na syumeled kanan.” ");
INSERT INTO klg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Manang wala' ni Jisus tubaga ya ka͡ubayan. Aw dyumulud uman dun ya kanan manga umagakan aw miglong silan kan Jisus, “Ayin ya madyaw aw papanawun da ya ka͡ubayan yeiy, kay gayed sakanan mig-agad-agad kanaten aw gyumelgel nyangilalat.” ");
INSERT INTO klg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pagkatigkas yan, miglong si Jisus adti ka͡ubayan, “Pigpadala aku adti buwadbuwad ni Isra-él kay kasiling silan na manga karniro na nyakasuway asuntu na wala' ya migdiyaga kanilan. Wala' pa saba dateng ya allaw na tabangan ta kamu na manga Héntil.” ");
INSERT INTO klg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Manang migpalapit kanan ya ka͡ubayan aw lyumuhud adti asdangan nan, aw to-o nyangilalat, law nan, “Kay Sir, tabangi aku beg!” ");
INSERT INTO klg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aw tyumubag si Jisus magi sa pundinganan, “Dili' madyaw kun kamangen ya pan na mangayse' aw agbel adti manga idu'.” ");
INSERT INTO klg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Manang miglong ya ka͡ubayan, “Kay Sir, matinaw ya piglong mu, manang pangkay ya manga idu' makakan saba sa manga mumu' na mangkataktak lekat adti lamisa na tagtun kanilan.” ");
INSERT INTO klg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sa pagdengeg ni Jisus sa tubag na ka͡ubayan, piglongan nan sakanan, “Kay Dé', tay sa kadakula' na pagpangintu-u mu kanak! Matuman saba ya pigsekat mu.” Aw dun ni udas yan, dayaw kyaguli-an ya ise' na ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pagkatigkas yan, pig-indegan ni Jisus ya banwa yan, aw nyadtu sakanan adti ligad na Danaw na Galiliya. Aw tyumukud sakanan adti buntud aw nyingkud dun. ");
INSERT INTO klg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aw dyumulud kanan ya madég to-o na utaw, aw pyandala nilan ya manga kapig aw ya manga kimay. Pigpa-agad nilan uman ya manga buta aw manga umu, aw eped pa na manga pyangkedelan. Aw dayaw nilan pigpaligena' dun ni asdangan ni Jisus. Aw pigguli' nan ya manga magkedel nilan. ");
INSERT INTO klg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aw sa pagkita' na manga utaw sa nyangka-imo', to-o silan nya-enneng-enneng. Kay ya manga umu, nyakapaglong da. Aw ya manga kimay, migpangkadyaw da. Aw ya manga kapig, nyampakapanaw da. Aw ya manga buta, kyumita' da. Aw pigdeyen nilan ya Tyumanem na Isra-él. ");
INSERT INTO klg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Paglabay da na tulungallaw, pigtawag ni Jisus ya kanan manga umagakan aw piglongan nan silan, “Nyallat aku sa manga utaw ini, kay seled da na tulungallaw gayed silan ini sayid tadun, aw wala' da ya un nilan makan asini. Dili' aku malim na muli' silan na wala' pa silan pakakan pagaw to-o magkalumay silan dun ni dalan.” ");
INSERT INTO klg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yanagaw nyusip ya manga umagakan nan, “Ayin kitadun kamang sa makan asini kaligbinan ini na maka-umba' sa kadég na manga utaw yeiy?” ");
INSERT INTO klg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aw nyusip si Jisus kanilan, “Pilallapid ya pan mayu awun?” Aw tyumubag silan, “Olo' da pitullapid ya pan, aw tabay ya isda' asini.” ");
INSERT INTO klg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aw piglongan ni Jisus ya manga utaw na mingkud silan dun ni sakati. ");
INSERT INTO klg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aw pigkamang nan ya pitullapid ya pan aw ya manga isda', aw pigpasalamatan nan adti Tyumanem. Pagkatigkas yan, pigtenga-tenga' nan adti kanan manga umagakan na un nilan uman atped-atped adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aw kyuman ya kadég nilan aw alag silan nyangkabiyag. Aw pigpan-imun na manga umagakan nan ya nyasama' aw pitungka be-en na mabakla' ya dayaw nyangkatmu'. ");
INSERT INTO klg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na, ya kadég na kyuman dun, manga upatemmalalan ya eseg aw wala' pa ya labet na manga ka͡ubayan aw mangayse' nilan. ");
INSERT INTO klg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatigkas yan, pigpapanaw ni Jisus ya manga utaw, aw syumakay sakanan sa balangay aw migpasinan adti sakup na lunsud na Magdala. ");
INSERT INTO klg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aw sa talana pa ni Jisus dun, awun dyumulud kanan na manga Parisiyo aw manga Sadusiyo kay kaliman nilan tanda-en si Jisus. Yanagaw migsekat silan kanan sa pangilala na magmatinaw kun yan ya Pigpadala na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Manang miglong si Jisus kanilan, “Sa agpet da sumallep ya sega, maglong kamu, ‘Madyaw ya lupa' kunallaw kay mapula ya langit adun.’ ");
INSERT INTO klg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aw pagkamaselem da uman, kun magkapula' ya langit aw maglugaytem ya manga labun, maglong kamu, ‘Mulan adun na allaw.’ Matadeng kamu mag-ubad sa timpo, manang dili' mayu mabatug ubaden ya kakawasan na manga nyangka-imo' adun na manga allaw yeiy! ");
INSERT INTO klg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tay sa kalatay na manga utaw adun na allaw yeiy! Pigtalikudan nilan ya Tyumanem, aw kasiling silan na ka͡ubayan na miglakadenen. Gayed silan migsekat sa pangilala, manang yan da olo' ya pangilala na atag ku kanilan ya kasiling na nya-imo' kan Jonas.” Aw pig-indegan silan ni Jisus aw nyanaw da sakanan. ");
INSERT INTO klg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aw sa pagpakatalipag da na manga umagakan ni Jisus sa danaw, kya-anenganengan nilan na kyalingawan nilan ya dyumala sa pan. ");
INSERT INTO klg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pagkatigkas yan, miglong si Jisus kanilan, “Magpakatadeng kamu sa patulinay na manga Parisiyo aw Sadusiyo!” ");
INSERT INTO klg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aw migpansibalawbalaw ya manga umagakan nan, miglong silan, “Yeiy gya ya du-an na piglong nan, kay wala' kitadun pakadala sa pan.” ");
INSERT INTO klg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Manang kya-ede-an ni Jisus ya pigbalawbalawan nilan. Yanagaw miglong sakanan adti kanilan, “Ananga' mayu balawbalawan na wala' kamu pakadala sa pan? Katagbi' na pagpangintu-u mayu! ");
INSERT INTO klg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Unu, wala' mayu kalabeti? Unu ka', kyalingawlingawan da mayu ya pagpakan ku sa limammalalan ya manga utaw sa limallapid olo' ya pan? Aw pila ya be-en na nyatmu' sa pigpan-imun mayu? ");
INSERT INTO klg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aw wala' da mayu uman ka-anenganengi ya pagpakan ku sa upatemmalalan ya utaw sa pitullapid ya pan? Aw pila ya mabakla' na be-en na nyasama' na nyatmu' sa pigpan-imun mayu? ");
INSERT INTO klg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aw ya pundinganan na piglong ku kakayna, ananga' wala' mayu kalabeti na beke' na tengteng pan ya pyalabet ku? Magpakatadeng kamu pagaw katapunan kamu na palangad patulinay na manga Parisiyo aw Sadusiyo!” ");
INSERT INTO klg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aw dun da na manga umagakan nan kalabeti ya piglong ni Jisus na magpakatadeng silan sa baluk na palna-u na manga Parisiyo aw manga Sadusiyo. Kay ya palna-u nilan gayed migkadakula' aw tyumapun adti madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na, dyumateng da si Jisus aw manga eped nan adti banwa na Césariya Pilipos. Aw sambuk na allaw pig-usip nan ya kanan manga umagakan, “Aku na Ise' na Utaw, dun ni pagbalawbalaw na manga utaw, singalan kunu aku adti kanilan?” ");
INSERT INTO klg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aw tyumubag silan, “Ya eped miglong na ikaw kunu si Juan na Magba͡utismuway, aw awun eped na miglong na ikaw kunu si Éliyas, aw awun pa eped na miglong na ikaw si Jérémiyas aw sambuk baling na propita.” ");
INSERT INTO klg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pagkatigkas yan, nyusip si Jisus kanilan, “Manang adti kamayu, singalan aku?” ");
INSERT INTO klg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aw tyumubag si Simon Pédro, “Ikaw saba ya Misiyas! Ikaw ya tengteng Ise' na Tyumanem na Gayed Awun!” ");
INSERT INTO klg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aw miglong si Jisus kanan, “Madyaw ya kanmu, kay Simon na ise' ni Jonas. Kay beke' na utaw ya migbukas kanmu seiy, manang ya kanak Ama na awun ni tas na langit yan ya migbukas adti kanmu. ");
INSERT INTO klg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aw asuntu sa piglong mu, lekat adun tawagen da kaw na Pédro na ya kakawasan: batu na sumalem. Aw dun ni batu yeiy, ya kadég na manga mangintu-uway imo-un ku na kanak kasakupan. Aw dili' yeiy degen na katulus na kamatayen. ");
INSERT INTO klg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Un ku atag kanmu ya manga kunsi-ay sa Kasakupan na Pighari-an na Tyumanem. Kun unu ya pigpigil mu asini tas na lupa', yan uman ya pigpigil dadan na Tyumanem adti tas na langit. Aw kun unu ya pigtumbay mu asini tas na lupa, yan uman ya pigtumbay dadan na Tyumanem adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagkatigkas yan, piglongan ni Jisus ya kanan manga umagakan, “Dili' mayu pagpa-ede' adti pangkay singalan utawa na aku ya Misiyas.” ");
INSERT INTO klg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lekat dun ni allaw yan, pigpalekat ni Jisus ya pagpa-ede' adti manga umagakan nan na ka-ilangan sakanan madtu ni Jérusalim kay yeiy ya pigpalpa dadan na Tyumanem. Aw dun ni Jérusalim, kele͡an sakanan aw ti-isen nan ya pamulayam na manga magdadumala͡ay sa manga Judiyu aw manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin. Aw un sakanan patayen, manang pagkatlu na allaw mataw sakanan. ");
INSERT INTO klg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Manang piggagad ni Pédro si Jisus adti dili' to-o mawat sa manga eped nilan, aw pigpalekat nan ya pagsagda kanan, “Kay Magpalna-uway, dili' yan tumbay na Tyumanem na apeten mu ya pagti-is! Dili’ yan mabatug!” ");
INSERT INTO klg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Manang nyatubang si Jisus kan Pédro aw pigsagda nan, “Ya piglong mu lekat saba adti kan Satanas na yan ya un magbalabag sa palpa na Tyumanem. Yanagaw pagpakawat kaw! Wala' mu betangan adti kanmu anenganeng ya kana Tyumanem pagkaliman. Yan olo' ya pig-anenganeng mu ya kana utaw.” ");
INSERT INTO klg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Pangkay singalan ya malim ma-imo' kanak umagakan, ka-ilangan ayawan nan ya kanan pagkaliman aw pisanen nan ya kanan krus aw dumalug kanak. ");
INSERT INTO klg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kay pangkay singalan ya gyuminawa sa kanan pagka-utawun asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay, matagtun nan ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unu ka' ya un ma-untung na utaw kun matagtun nan ya kadakula' na banwa manang kalagakan baling sa ginawa nan? Aw unu uman ya nyatagtun na utaw na umba' nan pagliwan sa ginawa na wala' ya katigkasan? ");
INSERT INTO klg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kay madi pa aku na Ise' na Utaw, aw sa pagliku' ku, ka-agadan aku na dakula' na kalalamdag na pagka Tyumanem na kanak Ama, aw eped ku ya manga anghil. Aw atagan ku ya tagsambuksambuk na utaw sa umba' sa kadég na pigpan-imo' nilan pangkay madyaw aw pangkay malatay. ");
INSERT INTO klg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aw matinaw ya un ku paglongun kamayu: Awun manga eped asini kamayu na dili' nilan apeten ya pagkamatay menda' na kita-en nilan ya paghari' na Ise' na Utaw.” ");
INSERT INTO klg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, pagkatigkas na enemengallaw, pigpa-agad ni Jisus si Pédro aw ya duwa ya maylug na si Santiago aw si Juan. Aw tyumukud silan adti matas na buntud na olo' silan. ");
INSERT INTO klg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aw sa talana nilan sakanan pigtandawan, kyinita' nilan na nya-uman ya kadakula' na lawas ni Jisus, aw ya kalalamdag na gya nan kasiling na sega, aw ya kadégkadég nan to-o migkaputi'. ");
INSERT INTO klg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Migpakita' uman dun si Moysis aw si Éliyas, aw migbalawbalaw silan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aw miglong si Pédro kan Jisus, “Kay Magpalna-uway, madyaw kay ini kami! Kun malim kaw, magtulluk aku sa tulu ya layag asini, sambuk ya kanmu, sambuk ya kan Moysis aw sambuk uman ya kan Éliyas.” ");
INSERT INTO klg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sa talana pa nan miglong, awun labun na to-o malalamdag na tyumakleb kanilan. Aw awun tingeg na lekat adti labun na miglong, “Yeiy ya kanak Ise' na to-o ku pigginawa͡an aw to-o aku kyatutukan kanan. Pakanyegi mayu sakanan!” ");
INSERT INTO klg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagdengeg na tulu ya umagakan nan sa tingeg yan, to-o silan nyallek aw nyanlebleb adti lupa'. ");
INSERT INTO klg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Manang dyumulud si Jisus kanilan aw pig-awidan nan silan, aw miglong sakanan, “Pagbangun kamu! Dili' kamu magkallek!” ");
INSERT INTO klg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aw sa pag-inunu nilan, dakman olo' si Jisus ya kyinita' nilan dun. ");
INSERT INTO klg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sa pagtubang da nilan lekat adti buntud, piglongan silan ni Jisus, “Dili' mayu pagpa-ede' ya kyinita' mayu adti pangkay singalan menda' sa allaw na matawun aku na Ise' na Utaw lekat adti nyangkamatay.” ");
INSERT INTO klg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aw nyusip silan kan Jisus, “Ananga' gayed miglong ya manga magpalna-uway sa Uldin na ka-ilangan maka-una si Éliyas dumateng aw makamoli ya Misiyas?” ");
INSERT INTO klg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tyumubag si Jisus kanilan, “Matinaw saba ya piglong nilan na maka-una si Éliyas na un magtagilan sa kadég. ");
INSERT INTO klg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Manang paglongun ta kamu na dyumateng da si Éliyas aw wala' sakanan kilala͡a na manga utaw. Pigpamulayaman nilan baling. Aw maynan uman, aku na Ise' na Utaw un nilan uman pamulayaman aw pati-isen.” ");
INSERT INTO klg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aw kyalabetan da na kanan manga umagakan na ya pyalabet ni Jisus na si Éliyas yan si Juan na Magba͡utismuway. ");
INSERT INTO klg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagliku' da ni Jisus aw manga eped nan adti baba' na pigkatipunan na madég na manga utaw, dyumulud kanan ya sambuk na eseg. Aw lyumuhud sakanan adti asdangan ni Jisus ");
INSERT INTO klg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aw miglong, “Kay Magpalna-uway, kallati beg ya ise' ku na eseg! Kay gayed sakanan pagtakigan aw to-o migti-is. Malikit sakanan magkalukad adti atulun aw malikit uman magkolug dun ni tubig. ");
INSERT INTO klg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yanagaw pigpa-agad ku sakanan adti manga umagakan mu manang wala' nilan kabatug guli-a.” ");
INSERT INTO klg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aw miglong si Jisus, “Tay sa manga utaw adun na manga allaw yeiy na baluk ya anenganeng aw wala' ya pagpangintu-u! Sangunu ka' ya kadugay na mati-is ku ya pag-iyagad kamayu?” Tigkas yan, miglong uman si Jisus, “Na, pa-agadan adi sayid ku ya ise'.” ");
INSERT INTO klg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aw pigsagda nan ya busaw, aw lumuwa' lekat adti ise', aw dayaw migkadyaw ya ise'. ");
INSERT INTO klg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sa pagpanaw da na manga utaw, dyumulud kan Jisus ya kanan manga umagakan aw nyusip silan, “Ananga' na wala' nami kabatug alilini ya busaw yan?” ");
INSERT INTO klg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aw tyumubag si Jisus kanilan, “Asuntu na wala' pa to-o pakadalid ya pagpangintu-u mayu. Manang matinaw ya un ku paglongun kamayu: Kun awun tengteng pagpangintu-u mayu pangkay tagbi' kasiling na bini' na mustardo, mabatug mayu paglongun ya buntud ini, ‘Kay Buntud, ka-alin kaw adtu!’ aw ma-alin saba. Wala' ya dili' mayu mabatug. ");
INSERT INTO klg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aw mabatug mayu saba alilinan ya maynan na punganan na busaw, magi sa pagpuwasa aw pagpanawagtawag adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sambuk na allaw, migkatipun si Jisus aw ya kanan manga umagakan adti Galiliya. Aw miglong si Jisus kanilan, “Aku na Ise' na Utaw agpet da lubidan aw tumbay adti manga utaw na ");
INSERT INTO klg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","un magpatay kanak. Manang pagdateng na katlu na allaw, matawun aku lekat adti pagkamatay.” Aw sa pagdengeg na manga umagakan nan, to-o migkalat ya ginawa nilan. ");
INSERT INTO klg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aw sa pagdateng nilan adti Kapirna-um, dyumulud adti kan Pédro ya manga mangungubla͡ay sa buwis na Témplo na awun ni Jérusalim. Aw nyusip silan kanan, “Unu, magbayad ya magpalna-uway mayu sa buwis na Témplo?” ");
INSERT INTO klg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tyumubag si Pédro, “E-e.” Pag-uli' da ni Pédro adti balay, nyuna si Jisus miglong kanan, “Kay Simon, adti kanmu anenganeng, singalan galu ya umba' pabayaden na manga hari' sa manga buwis? Ya kanilan ise' aw kun manga sakup nilan?” ");
INSERT INTO klg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aw tyumubag si Pédro kanan, “Manga sakup nilan.” Aw miglong pa si Jisus, “Yanagaw wala' ya labet na tengteng na ise' nilan magbayad. ");
INSERT INTO klg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Manang pada dili' kitadun kadamanan na manga mangungubla͡ay sa buwis na Témplo, paminta kaw kanate' adti dulug na danaw. Beklasa ya tagna' na isda' na tumubug sa binta mu. Beka-a ya baka nan, aw kita-en mu dun ya kuwalta na bulawan na maputi'. Kamanga ya kuwalta aw bayadi ya buwis ku aw ya kanmu.” ");
INSERT INTO klg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aw yan uman na allaw, dyumulud kan Jisus ya kanan manga umagakan aw pig-usip nilan sakanan, “Singalan ya to-o matas dun ni Kasakupan na Pighari-an na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aw migtawag si Jisus sa sambuk na tagbi' na ise' aw pigpa-indeg nan adti tenga' nilan. ");
INSERT INTO klg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aw piglongan nan ya kanan manga umagakan, “Matinaw saba ya un ku paglongun kamayu: Kun dili' ma-uman ya anenganeng mayu aw dili' kamu magpadalem kasiling na tagbi' na ise', dili' kamu makaseled adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Manang pangkay singalan ya magpadalem kasiling na ise' ini, yan ya utaw na to-o matas dun ni Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aw pangkay singalan kamayu ya dumawat sa utaw na madalem kasiling na ise' ini asuntu sa pagdalug mayu kanak, dun da aku nan uman dawata. ");
INSERT INTO klg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Manang kun awun utaw na migpadalem na nyangintu-u kanak, aw kun buyuwun sakanan adti pagpakasala', ya utaw na magbuyu madyaw pa baling kun tati-an ya liyeg nan na dakula' na gilingan na batu aw ulugun sakanan adti kalaleman na dagat. ");
INSERT INTO klg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Magpakatadeng ya kadég mayu! Kay awun saba madég na magpakabuyu sa utaw adti pagpakasala'. Manang ya utaw na maggagad sa eped nan adti pagpakasala', to-o malatay ya un nan datengan. ");
INSERT INTO klg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yanagaw kun ya pig-imo' na kanmu tullu' aw kanmu siki ya du-an na makasala' kaw, madyaw pa na magpakawat kaw adti pangkay unu na makapabuyu kanmu adti pag-imo' sa sala'. Pangkay pa utudun ya kanmu tullu', madyaw pa na awun malagak dun ni kanmu lawas aw matagtun mu ya ginawa na wala' ya katigkasan, kay sa awun duwa ya tullu' mu aw duwa ya siki mu manang agbel kaw baling adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aw maynan uman, kun ya pag-inunu mu ya du-an na makasala' kaw, madyaw pa na magpakawat kaw adti pangkay unu na makapabuyu kanmu sa pag-imo' sa sala'. Pangkay pa lugiten ya kanmu mata, madyaw pa na mabuta ya mata mu aw matagtun mu ya ginawa na wala' ya katigkasan kay sa awun duwa ya mata mu manang agbel kaw baling adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Magpakatadeng kamu na dili' mayu mana-na' ya manga migpadalem na nyangintu-u kanak. Kay paglongun ta kamu na adti asdangan na Ama ku, awun manga anghil na gayed nyakatanaw sa pagpakabetang nilan. ");
INSERT INTO klg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aw nyadi ya Ise' na Utaw pada paliku-un adti Tyumanem ya kadég na nyakasuway. ");
INSERT INTO klg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Unu ya anenganeng mayu sa ini? Alimbawa' kun awun utaw na nyakatagtun sa sanggatus ya karniro, aw awun sambuk na nyakasuway, unu ya un nan imo-un? Enda'! Ayawan nan saba dagawdagaw ya kasiyaman tag siyam dun ni panabtabanan aw paninawun nan ya sambuk na nyakasuway. ");
INSERT INTO klg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Matinaw ya un ku paglongun kamayu: Kun kita-en da nan ya karniro na nyakasuway, to-o pa sakanan magleya sa sambuk na kyinita' nan kay sa kasiyaman tag siyam na adti panabtabanan na wala' pakasuway. ");
INSERT INTO klg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yanagaw maynan uman ya Ama mayu na awun ni tas na langit, dili' nan kaliman na ka-eletan lekat adti kanan ya pangkay sambuk na migpadalem na nyangintu-u kanan.” ");
INSERT INTO klg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kun awun eped mu na mangintu-uway na nyakasala' adti kanmu, na, kadtuwi sakanan aw paglonga sa sala' nan na olo' kamu duwa. Kun magpakanyeg sakanan kanmu aw magselsel, na, magkasambuk da ya ginawa mayu. ");
INSERT INTO klg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Manang kun dili' sakanan tumande' kanmu na awun sala' nan, pagpa-agad kaw sa sambuk aw kun duwa ya eped mu na mangintu-uway. Kay dun ni pagbalawbalaw mayu, duwa kun tulu ya magmatinaw sa sala' nan. ");
INSERT INTO klg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Manang kun dili' sakanan magpakanyeg kamayu, ubat-ubatan mayu adti katipun na manga mangintu-uway. Aw kun dili' sakanan tumande', na, pabaya-i la ya utaw yan, aw dili' da kaw mag-ubaybay kanan. Silinga la sakanan na utaw na wala' ya pagpangintu-u sa tengteng Tyumanem aw mangungubla͡ay sa buwis na dili' kasaligan. ");
INSERT INTO klg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Matinaw ya un ku paglongun kamayu: Kun unu ya pigpigil mayu asini tas na lupa', yan uman ya pigpigil dadan na Tyumanem adti tas na langit. Kun unu ya pigtumbay mayu asini tas na lupa', yan uman ya pigtumbay dadan na Tyumanem adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aw matinaw uman ya un ku paglongun kamayu: Kun duwa kamayu asini tas na lupa' ya magkasambuk ya ginawa sa pangkay unu ya sekaten mayu dun ni panawagtawag, atag saba na Ama ku na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kay kun awun duwa aw tulu ya mangintu-uway na magkatipun dun ni kanak ngalan, awun saba aku ni tampid nilan.” ");
INSERT INTO klg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pagkatigkas yan, dyumulud si Pédro kan Jisus aw nyusip kanan, “Kay Magpalna-uway, kun gayed makasala' adi kanak ya eped ku na mangintu-uway, makapila ku sa kanan pasinsiyayi? Unu, makapitu olo'?” ");
INSERT INTO klg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aw tyumubag si Jisus kanan, “Paglongun ta kaw na beke' olo' na makapitu, manang kapituwan ka pitu ka pilu'. ");
INSERT INTO klg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kamangan ta sa alimbawa'. Ya Kasakupan na Pighari-an na Tyumanem, kasiling na maynini: Awun sambuk na hari' na migpatawag sa manga sugu-anen nan pada usayen ya manga pigtaligu nan adti kanilan. ");
INSERT INTO klg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sa pagpalekat da na hari' mig-usay, pigpa-agad adti kanan ya sambuk na sugu-anen nan na nyaka-utang sa minélyun na kuwalta. ");
INSERT INTO klg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aw asuntu na wala' nan kabatug bayadi, migsugu' ya hari' na galinen ya sugu-anen yan dala ya kanan ka͡ubayan aw kadég na mangayse' nan. Aw panggalinen uman ya kadakula' na nyatagtun nan pada makabayad. ");
INSERT INTO klg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yanagaw lyumuhud ya sugu-anen adti asdangan na hari' aw to-o nyangilalat kanan, aw miglong sakanan, ‘Kay Hari', kallati beg aku! Kun makatagad pa kaw beg, bayadan ta kaw sa kadakula'!’ ");
INSERT INTO klg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yanagaw pigkallatan sakanan na hari' aw wala' da nan pabayada, aw pigpapanaw da sakanan. ");
INSERT INTO klg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Manang sa pagluwa' da nan, pig-isungun nan ya eped nan na sugu-anen na nyakabeles kanan sa tagbi' na kuwalta. Aw pigtigel nan ya utaw yan aw piglongan nan, ‘Bayadi aku adun sa beles mu kanak!’ ");
INSERT INTO klg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Aw to-o nyangilalat ya eped nan, law nan, ‘Kay Lew, kallati aku beg! Kun makatagad pa kaw, bayadan ta kaw sa kadakula' na beles ku kanmu!’ ");
INSERT INTO klg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Manang wala' sakanan kalim na madugay bayadan. Pigpakalabusu nan baling ya eped nan menda' na makabayad sakanan. ");
INSERT INTO klg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagkita' na manga eped nilan na sugu-anen sa nya-imo', to-o migkalat ya ginawa nilan. Yanagaw nyadtu silan adti asdangan na hari' aw pig-ubat nilan kanan ya kadég na nya-imo'. ");
INSERT INTO klg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pagkatigkas yan, pigpatawag na hari' ya sugu-anen na wala' pakabayad kanan, aw miglong ya hari', ‘To-o malatay ya pig-imo' mu! Wala' da ta kaw pabayada sa utang mu kanak asuntu na to-o kaw nyangilalat kanak. ");
INSERT INTO klg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ananga' wala' mu kallati ya eped mu kasiling na pagkallat ku kanmu?’ ");
INSERT INTO klg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aw to-o nyadaman ya hari' kanan, aw ya syampetan yan, pigpakalabusu sakanan aw pigpamulayaman na manga magtatunggu-ay menda' na kabayadan nan ya kadakula' na beles nan. ");
INSERT INTO klg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Maynan uman ya imo-un na Ama ku na awun ni tas na langit adti tagsambuksambuk kamayu, kun dili' mayu tengteng pasinsiya͡an ya sala' na manga eped mayu na mangintu-uway.” ");
INSERT INTO klg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatigkas ni Jisus palna-uwan ya manga utaw dun, pig-indegan nan ya Galiliya aw tyumalipag sakanan sa tubig na Jordan aw migpasinan adti probinsiya na Judiya. ");
INSERT INTO klg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aw dyumalug kan Jisus ya to-o madég na manga utaw. Aw pigpangguli' nan ya manga kyedelan dun. ");
INSERT INTO klg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Awun manga Parisiyo na dyumulud kan Jisus na un magtanda' kanan magi sa usip, law nilan, “Unu, pigtumbay sa eseg ya pag-ayaw sa ka͡ubayan nan pangkay unu ya du-an?” ");
INSERT INTO klg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tyumubag si Jisus kanilan, “Wala' ka' mayu kabasa dun ni Uldin ya pigpasulat na Tyumanem? Asini muna sa pag-imo' nan sa manga utaw, duwa ya punganan nilan: Awun eseg aw awun bubay. ");
INSERT INTO klg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aw pigpasulat nan uman, ‘Yeiy ya du-an na indegan na eseg ya ama nan aw ina nan, aw pa-egketen silan ya ka͡ubayan nan, aw ya duwa silan ma-imo' da sambuk.’ ");
INSERT INTO klg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yanagaw beke' da silan na duwa manang ma-imo' da sambuk. Aw ya pig-isambuk da na Tyumanem, dili' galu silan pagsuwayen na utaw!” ");
INSERT INTO klg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aw nyusip pa silan kan Jisus, “Kun maynan, ananga' maglong si Moysis na mabatug na eseg ayawan ya ka͡ubayan nan magi sa pag-atag sa sulat na magmatinaw na mag-ayaw da silan, aw tigkas yan papanawun nan?” ");
INSERT INTO klg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aw tyumubag si Jisus kanilan, “Yan saba ya du-an na piglong ni Moysis na mabatug ya pag-ayaw, asuntu sa kategelan mayu. Manang beke' na maynan ya palpa na Tyumanem lekat pa asini muna. ");
INSERT INTO klg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ini ya kanak paglongun kamayu: Kun awun eseg na ayawan nan ya kanan ka͡ubayan na wala' pagkasala-enen adti sambuk na eseg, aw mangugnan sakanan sa eped na ka͡ubayan, piglakadan nan ya muna ka͡ubayan nan.” ");
INSERT INTO klg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pagkatigkas yan, miglong ya manga umagakan ni Jisus kanan, “Kun maynan ya ma-imo' sa mangugnanay, madyaw pa baling kun dili' da mangugnan ya utaw.” ");
INSERT INTO klg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Manang miglong si Jisus kanilan, “Ya piglong mayu yeiy dili' mabatug na eped na utaw, manang ya makadawat seiy yan olo' ya manga utaw na pigtabangan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kay awun du-an na ya manga eped na eseg dili' magpangugnan. Ya eped wala' ya kabatug nilan mag-imo' sa ise' kay awun se-ey na kanilan lawas. Awun uman eped na pigkapun da. Aw awun uman manga eped na wala' da pangugnan kay nyatibulluk silan adti imo-unun sa Kasakupan na Pighari-an na Tyumanem. Yanagaw, ya eseg na makadawat seiy, madyaw pa kanan ya dili' da mangugnan.” ");
INSERT INTO klg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pagkatigkas yan, awun mangkayantek na mangayse' na pigpandala adti kan Jisus na un nan silan pan-awidan aw panawagtawagan pada atagan silan na kadyawan. Manang pigsagda baling na kanan manga umagakan ya manga utaw na nyandala sa mangayse' nilan. ");
INSERT INTO klg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yanagaw miglong si Jisus, “Pakadiya kanak ya manga mangayse' aw ya-i mayu silan pagtageni! Kay ya manga utaw na dyumawat kanak kasiling na manga mangayse' ini, silan saba ya maka-akup adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aw pig-awidan nan ya manga mangayse' aw pig-atagan nan silan na kadyawan magi sa panawagtawag nan. Aw tigkas yan, nyanaw da uman si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na, awun sambuk na eseg na dyumulud kan Jisus kay kaliman nan musip, aw miglong sakanan, “Kay Magpalna-uway, unu ya madyaw na ka-ilangan ku imo-un pada matagtun ku ya ginawa na wala' ya katigkasan?” ");
INSERT INTO klg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aw tyumubag si Jisus kanan, “Ananga' kaw musip kanak kun unu ya madyaw? Sambuk da saba olo' ya madyaw, yan ya Tyumanem. Kun kaliman mu matagtun ya ginawa na wala' ya katigkasan, daluga ya kanan manga sugu'.” ");
INSERT INTO klg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aw nyusip pa uman sakanan, “Unu ya manga sugu' yan?” Aw tyumubag si Jisus kanan, “Dili' kaw magpatay sa utaw, aw dili' kaw maglakadenen, aw dili' kaw magpanakaw, aw dili' mu pagmatinawun ya galu' adti asdangan na mag-usayay, ");
INSERT INTO klg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aw basayi ya kanmu ama aw ina, aw ginawayi ya eped mu kasiling na pagginawa mu sa kanmu pagka-utawun.” ");
INSERT INTO klg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Miglong uman kanan ya eseg yan, “Pigdalug da ku alag ya kadég yeiy. Unu pa ya wala' ku ka-imo'?” ");
INSERT INTO klg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aw tyumubag si Jisus kanan, “Kun kaliman mu malingeb ya kadakula', uli' kaw aw galina ya manga nyatagtun mu. Kun magalin da mu, atagan ya kuwalta yan adti manga utaw na wala' ya pagkamangan. Kun imo-un mu yeiy, dun da kaw pagluduk sa ka-unan adti tas na langit. Aw pagkatigkas yan, liku' kaw adi aw dalug kaw kanak.” ");
INSERT INTO klg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Manang pagdengeg na eseg yan sa tubag ni Jisus, nyanaw sakanan aw to-o migkalat ya ginawa nan kay to-o madég ya ka-unan nan. ");
INSERT INTO klg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pagkatigkas yan, miglong si Jisus sa manga umagakan nan, “Matinaw ya un ku paglongun kamayu: Malug sa utaw na mayaman ya pagpaka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aw paglongun ta kamu na molas pa ya pag-agi na ayep na kamilyo adti gawang na dagem kay sa pagpaka-akup na utaw na mayaman dun ni Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagdengeg na manga umagakan nan seiy, to-o silan nyabelengbeleng aw nyusip silan, “Na, kun maynan, singalan ka' ya paluwa-en na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pig-inunu silan ni Jisus aw piglongan nan silan, “Dili' na utaw mabatug yeiy, manang adti Tyumanem mabatug saba ya kadég.” ");
INSERT INTO klg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tigkas yan, miglong si Pédro kanan, “Inunuwa ya kanami ini! Nyabus da nami pig-ayawan ya kadég na nyatagtun nami pada magad kanmu. Unu ya imanen nami?” ");
INSERT INTO klg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aw tyumubag si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Dun ni allaw na baguwun da na Tyumanem ya kadakula' na banwa, aku na Ise' na Utaw mingkud adti kanaken trunu na un maghari' sa kanak kasakupan. Aw kamu uman na gayed nyagad kanak, mingkud kamu uman adti sampulu' tag duwa ya trunu. Aw magdumala kamu sa kadég na manga buwadbuwad ni Isra-él na lyumekat alag adti sampulu' tag duwa ya ise' nan na eseg. ");
INSERT INTO klg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aw pangkay singalan ya mag-ayaw sa kadég asuntu kanak, pangkay ya kanan balay, aw manga kaylug nan aw kanan mangkatikadeng aw manga mangayse', aw ya lupa' nan asuntu kanak, un liku' kanan ya sanggatus ka pilu' na pig-ayawan nan aw matagtun nan uman ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Manang awun madég na utaw na nyaka-una adun aw makamoli silan kagaya. Aw madég uman ya utaw na nyakamoli adun manang maka-una kagaya.” ");
INSERT INTO klg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ya Kasakupan na Pighari-an na Tyumanem kasiling na maynini: Awun utaw na dakula' ya parasan nan. Pagkamaselem da, nyanaw sakanan na un maninaw sa manga utaw na magtalabahu adti kanan parasan. ");
INSERT INTO klg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pagkita' da nan sa manga utaw na malim magtalabahu, pigpakangan nan silan sa umba' na pagtandan sa sangallaw na pagtalabahu na yan ya tag sangka dinaryo. Aw pigpakadtu nan silan adti parasan nan. ");
INSERT INTO klg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Pagdateng da na alas nibi na maselem, nyadtu sakanan adti palingki aw awun pigkita' nan na manga utaw na gayed mig-indeg-indeg dun kay wala' ya talabahu nilan. ");
INSERT INTO klg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yanagaw miglong kanilan ya tagtun, ‘Awun talabahuwunun adti kanak parasan. Kun malim kamu magtalabahu, tandanan ta kamu sa umba' na tandan kamayu.’ ");
INSERT INTO klg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aw yanagaw nyadtu silan adti parasan nan. Pagka-alas dosi la, lyumiku' da uman ya tagtun adti palingki aw awun pa uman kyinita' nan na manga utaw dun aw pigpatalabahu la nan uman adti kanan parasan. Aw maynan uman ya pig-imo' nan dun ni alas trés. ");
INSERT INTO klg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pagka alas singku la na ambung, lyumiku' da uman salut ya tagtun adti palingki, aw awun pa kyinita' nan dun na manga utaw na mig-indeg-indeg kay wala' ya talabahu nilan. Aw pig-usip nan silan, ‘Ananga' gayed kamu asini mag-indeg-indeg? Syapadan ya allaw adun na wala' ya talabahu mayu.’ ");
INSERT INTO klg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aw tyumubag silan kanan, ‘Wala' du-an ya migpatalabahu kanami.’ Yanagaw miglong kanilan ya tagtun sa parasan, ‘Kadtu kamu baling ni parasan ku aw pagtalabahu kamu dun.’ ");
INSERT INTO klg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aw sa pagkamagsiklep da, miglong ya tagtun adti maggagaday sa manga magtalabahuway, ‘Tawaga ya kadég nilan aw atagan ya tandan adti tagsambuksambuk kanilan, manang una͡en mu atagan na tandan ya manga nyakamoli tyumangka', aw pamoliya ya nyaka-una.’ ");
INSERT INTO klg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aw ya manga magtalabahuway na tyumangka' na alas singku na ambung, dyumulud silan aw pigtandanan ya tagsambuksambuk kanilan na tag sangka dinariyo. ");
INSERT INTO klg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aw sa pagdulud da uman na manga nyaka-una tyumangka', pig-iman nilan na dakula' pa ya tandan kanilan. Manang ya tagsambuksambuk kanilan pig-atagan na tag sangka dinariyo kasiling na nyadawat na manga nyakamoli tyumangka'. ");
INSERT INTO klg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagpakadawat da nilan sa kanilan tandan, migdiklamu silan adti tagtun sa parasan, ");
INSERT INTO klg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","law nilan, ‘Olo' da sangka udas ya pagtalabahu na manga utaw yeiy! Ananga' pigpa-unawa mu baling ya tandan sa kadég nami? Sangallaw nami migtalabahu aw nyabelad pa kami na sega, manang silan wala' da dateng na sangallaw!’ ");
INSERT INTO klg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Manang miglong ya tagtun adti sambuk kanilan, ‘Kay Lew, wala' ta kamu limbungi. Dadan da saba kitadun migpakang sa tandan na tag sangka dinariyo ya allaw. ");
INSERT INTO klg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, dawata la ya kanmu tandan aw uli' da kaw. Kanak yeiy pagbaya' na pa-unawa͡en ya tandan adti kadég mayu pangkay nyaka-una kamu aw pangkay nyakamoli silan. ");
INSERT INTO klg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yeiy ya kanak pagbaya' kay aku ya tagtun. Unu, nyinga' kaw asuntu sa kanimbet ku kanilan?’ ");
INSERT INTO klg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aw miglong si Jisus, “Maynan uman ya adti kanak kasakupan. Awun madég na manga utaw na nyakamoli adun manang maka-una silan kagaya. Aw awun uman madég na manga utaw na nyaka-una adun manang makamoli silan kagaya.” ");
INSERT INTO klg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, sa pagpasinan da ni Jisus aw ya madég na manga utaw adti Jérusalim, pigtani ni Jisus ya sampulu' tag duwa ya kanan umagakan kay awun paglongun nan kanilan, law nan, ");
INSERT INTO klg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pada ka-ede-an mayu, migpasinan da kitadun adti Jérusalim, aw aku na Ise' na Utaw un da tumbay adti manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin, aw ukuman aku nilan na patayen. ");
INSERT INTO klg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pagkatigkas yan, tumbay aku uman nilan adti manga utaw na Héntil, aw odoy-odoyun aku nilan aw badasan uman na lalabet, aw pakalabu nilan adti krus. Manang pagdateng na katlu na allaw, matawun aku lekat adti pagkamatay.” ");
INSERT INTO klg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pagkatigkas yan, dyumulud kan Jisus ya ka͡ubayan ni Zibidiyo aw ya manga ise' nilan na si Santiago aw si Juan. Aw lyumuhud sakanan adti asdangan ni Jisus kay awun sekaten nan. ");
INSERT INTO klg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aw nyusip si Jisus kanan, “Unu ya kaliman mu na imo-un ku kanmu?” Aw tyumubag sakanan, “Pakangan beg kanak na dun ni kanmu Kasakupan na un mu hari-an kagaya, tumbay mu ya duwa ya ise' ku yeiy na mingkud adti sayid mu dun ni ingkudanan na to-o pagbasa͡an, ya sambuk apit adti kalintu aw ya sambuk apit adti kawala.” ");
INSERT INTO klg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Manang piglongan silan ni Jisus, “Wala' mayu ka-ede-i kun unu ya pigsekat mayu. Unu, mabatug mayu ti-isen ya pagti-is na un ku ka-agiyan?” Aw miglong ya duwa yeiy, “E-e, mabatug nami.” ");
INSERT INTO klg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aw miglong si Jisus kanilan, “Un mayu saba ka-agiyan ya kadég yeiy. Manang ya pag-ingkud apit adti kalintu aw kawala ku, beke' ku ya mamalli'. Ama ku saba ya magbaya' kun singalan ya mingkud dun.” ");
INSERT INTO klg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sa pagdengeg na sampulu' ya umagakan nan sa pigsekat na duwa ya maylug aw ina nilan, nyadaman silan. ");
INSERT INTO klg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yanagaw pigpatawag ni Jisus ya kadég nilan aw piglongan nan silan, “Kya-ede-an da mayu ya bet na manga pangulu na manga utaw na wala' ya pagpangintu-u sa Tyumanem. Silan ya gayed magbaya' sa manga sakup nilan. Aw maynan uman ya pig-imo' na mangkalangkaw nilan. Gayed silan magpanugu' sa kanilan manga utaw asuntu na dakula' ya katundanan nilan. ");
INSERT INTO klg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Manang dili' mayu silan pagsilingan. Kun awun sambuk kamayu na kaliman nan ma-imo' dakula' na utaw, ka-ilangan una sakanan ma-imo' sugu-anen dun ni kamayu. ");
INSERT INTO klg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aw kun awun sambuk kamayu na malim na yan ya gayed pag-una͡en, ka-ilangan silingan nan ya bet na sugu-anen na gayed magpadana'. ");
INSERT INTO klg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kasiling ku saba na Ise' na Utaw, wala' aku kadi asini tas na lupa' pada sanggila-en, manang yan baling ya pigkadi ku ya ma-imo' sugu-anen adti madég na utaw, aw ma-imo' kalyu kanilan adti pagkamatay pada maglekat kanilan adti manga sala' nilan.” ");
INSERT INTO klg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na, sa pag-indeg ni Jisus aw manga umagakan nan lekat adti syudad na Jériko, dyumalug kanan uman ya to-o madég na utaw. ");
INSERT INTO klg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aw awun uman duwa ya eseg na buta na nyingkud dun ni kilid na dalan. Aw sa pagdengeg nilan na un da lumabay si Jisus, migtatawag silan kanan, “We... Pangulu na buwadbuwad ni Dabid, kallati beg kami!” ");
INSERT INTO klg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Madég ya utaw na migsagda kanilan na maglong, “Katinep kamu!” Manang to-o pa baling nilan pigpakadakula' ya kanilan tingeg, law nilan, “We... Pangulu na buwadbuwad ni Dabid, kallati beg kami!” ");
INSERT INTO klg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yanagaw tyumeneng si Jisus aw pigtawag nan silan aw nyusip kanilan, “Unu ya kaliman mayu na imo-un ku kamayu?” ");
INSERT INTO klg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aw tyumubag silan kanan, “Kay Sir, kaliman beg nami kumita'!” ");
INSERT INTO klg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aw nyallat si Jisus kanilan, aw pig-awidan nan ya mata na tagsambuksambuk kanilan, aw dayaw silan kyumita'. Aw dyumalug da silan kanan. ");
INSERT INTO klg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na, sa malapit da silan adti Jérusalim, dyumateng silan adti baranggay na Bétpagi dun ni kilid na Buntud na Manga Olibo. Aw pigsugu' ni Jisus ya duwa ya umagakan nan, ");
INSERT INTO klg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aw piglongan nan silan, “Kadtu kamu dun ni baranggay adti dipag, aw sa pagseled mayu dun, kumita' kamu sa asnu na pig-eket eped ya kanan nati. Ubada mayu ya eket nilan aw guyuda mayu adi kanak. ");
INSERT INTO klg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kun musip kamayu, paglonga mayu sakanan: ‘Ya Magpalna-uway awun ka-ilangan nan sa asnu aw sa nati ini.’ Aw tumbay saba na tagtun aw maksay nan padala kamayu.” ");
INSERT INTO klg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na, ya kadég yeiy na nya-imo', nyatuman ya pigsulat na propita asini muna: ");
INSERT INTO klg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Paglonga ya manga utaw dun ni Jérusalim: ‘Tanawa! Dyumateng da ya hari' mayu! Migpadalem sakanan aw dyumateng na syumakay sa nati na asnu!” ");
INSERT INTO klg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aw nyanaw ya duwa ya umagakan nan aw pigtuman nilan ya kadég na pigsugu' ni Jisus kanilan. ");
INSERT INTO klg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pigguyud nilan ya asnu aw nati nan adti kan Jisus, aw pig-apidan nilan aw pigsakayan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sa talana nilan migpasinan adti Jérusalim, awun madég to-o na manga utaw na migma-una kanilan na migpansiladlad dun ni dalan sa kadégkadég na yan ya palangad pagpamasa nilan kan Jisus. Aw ya eped na manga utaw migladlad uman silan adti dalan sa manga mangkayantek na manga sanga na kawuy na bagu nilan pigpan-utud. ");
INSERT INTO klg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aw ya manga utaw na nyuna kan Jisus aw ya manga nyakamoli kanan, alag silan migpansideyen na maglong, “Hosana! Deyen tadun ya Buwadbuwad ni Dabid! Ini la ya Pigpadala na Tyumanem dun ni kanan ngalan, aw umba' sakanan deyen! Hosana! Aw deyen ya Tyumanem na awun ni tas na langit!” ");
INSERT INTO klg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagseled da ni Jisus adti Jérusalim, wala' katingen ya anenganeng na madég na manga utaw dun ni syudad, aw nyangusip silan, “Singalan ya utaw yeiy?” ");
INSERT INTO klg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aw tyumubag kanilan ya madég na manga utaw na nyagad kan Jisus, “Yeiy saba ya propita na si Jisus na taga Nasarit, sakup na Galiliya.” ");
INSERT INTO klg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aw syumeled si Jisus adti dakula' na pamanag na Témplo na Tyumanem. Aw sa pagkita' nan sa manga utaw na nyampamaligya' aw nyampamayad, pigpalekat nan ya pag-alilin kanilan. Pigpantuwad nan ya manga lamisa na manga maglaliwanay sa kuwalta aw ya manga ingkudanan na manga mamaligya-ay sa kalupati. ");
INSERT INTO klg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aw miglong si Jisus kanilan, “Yeiy ya pigpasulat na Tyumanem asini muna, ‘Ya kanak balay, pagtawagen na panawagtawaganan.’ Manang pig-imo' mayu baling tagu-anan sa manga mangkatakaw.” ");
INSERT INTO klg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aw dyumulud adti kan Jisus ya manga buta, aw ya manga kapig. Aw pigpangguli' nan silan dun ni pamanag na Témplo. ");
INSERT INTO klg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Manang sa pagkita' na manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin sa pigpan-imo' ni Jisus, aw sa pagdengeg nilan sa tatawag na manga mangayse' dun ni pamanag na Témplo, to-o silan nyangkadaman. Kay miglong ya manga mangayse', “Hosana! Deyen tadun ya buwadbuwad ni Dabid!” ");
INSERT INTO klg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yanagaw nyusip silan kan Jisus, “Unu, dyengeg mu ya piglong na manga mangayse' iyan?” Aw tyumubag si Jisus, “E-e, dyengeg ku. Ananga', wala' mayu kabasa ya pigpasulat na Tyumanem asini muna? Nyakasulat saba na pangkay ya mangayse' dala ya manga magsusu pa, pigpalna-uwan silan na Tyumanem na magdeyen kanan.” ");
INSERT INTO klg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagkatigkas yan, pig-indegan silan ni Jisus adti pamanag na Témplo aw lyumuwa' sakanan adti syudad aw migpasinan adti baranggay na Bétaniya. Aw dun da sakanan kulang na gabi yan. ");
INSERT INTO klg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkamaselem yan, talana ni Jisus lyumiku' adti syudad na Jerusalim, nyagetem sakanan. ");
INSERT INTO klg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aw sa pagkita' nan sa kawuy na igira adti kilid na dalan, migpalapit sakanan adti kawuy, manang wala' ya pigkita' nan na bunga. Tumalag baling dawun. Yanagaw piglongan ni Jisus ya kawuy, “Lekat adun na allaw yeiy, dili' da kaw makapamunga!” Aw tigkan nyalanes ya kawuy. ");
INSERT INTO klg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkita' na manga umagakan nan sa nya-imo' sa kawuy, to-o silan nya-enneng-enneng aw miglong silan, “Ananga' maksay nyalanes ya kawuy na igira iyan?” ");
INSERT INTO klg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aw tyumubag si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Kun mangintu-u kamu sa Tyumanem aw dili' magduwaduwa, mabatug mayu uman ya pig-imo' ku adti kawuy na igira. Manang beke' olo' na maynan, mabatug mayu uman paglongan ya buntud ini, ‘Kay Buntud, kawas kaw adti dagat!’ Aw ma-imo' saba ya piglong mayu. ");
INSERT INTO klg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kun to-o kamu sumalig sa Tyumanem, madawat saba mayu ya pigsekat mayu magi sa kamayu pagpanawagtawag.” ");
INSERT INTO klg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na, lyumiku' si Jisus adti pamanag na Témplo. Aw talana nan migpalna-u dun, dyumulud kanan ya manga mangkatas na magdadugsu-ay aw ya manga magdadumala͡ay sa manga Judiyu. Aw nyusip silan kanan, “Unu ya katundanan mu na du-an pig-alilinan mu ya manga utaw asini Témplo kagabi? Aw singalan ka' ya nyatag kanmu sa katundanan na imo-un mu ya maynan?” ");
INSERT INTO klg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tyumubag si Jisus kanilan, “Musip aku uman kamayu, aw kun matubag mayu ya usip ku, na, ubat ku uman kamayu kun ayin lekat ya katundanan ku sa pag-imo' sa kadég yeiy. ");
INSERT INTO klg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, ini ya kanak usip kamayu: Ayin lekat ya katundanan ni Juan sa pagba͡utismu nan sa manga utaw? Unu, lekat adti Tyumanem aw olo' lekat adti utaw?” Aw mig-usip-usipay silan, “Unu ya un tadun tubag kanan? Kun tubagen tadun na ‘lekat adti Tyumanem,’ maglong sakanan kanaten, ‘Ananga' wala' kamu pangintu-u kanan?’ ");
INSERT INTO klg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aw kun tubagen tadun uman na ‘lekat adti utaw’, pagaw madaman ya manga utaw ini. Kay pyangintu-uwan na kadég nilan na si Juan propita sakanan na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yanagaw tyumubag silan kan Jisus, “Enday, wala' nami ka-ede-i.” Aw miglong si Jisus kanilan, “Dili' ta kamu uman ubatan kun singalan ya nyatag kanak sa katundanan na ma-imo' ku ya maynan.” ");
INSERT INTO klg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na, pig-ubatan da uman silan ni Jisus sa pundinganan, law nan, “Unu ya anenganeng mayu sa ini? Awun sambuk na utaw na awun duwa ya ise' nan na eseg. Sambuk na allaw, pigsugu' nan ya ise' nan na magulang, ‘Kay To', kadtu kaw adun ni kanaten parasan aw pagtalabahu kaw dun.’ ");
INSERT INTO klg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aw tyumubag ya ise' nan, ‘Dili' aku malim madtu!’ Manang wala' kadugay nya-uman ya anenganeng nan aw nyadtu baling sakanan ni parasan. ");
INSERT INTO klg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Aw pigkadtuwan uman na ama nilan ya ise' nan na mangud aw maynan uman ya pigsugu' nan adti kanan. Aw miglong ya ise' nan, ‘E-e, kay Ma'. Madtu aku.’ Manang wala' baling sakanan kadtu.” ");
INSERT INTO klg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aw nyusip si Jisus, “Na, ayin sa duwa ya mig-imo' sa pagkaliman na ama nilan?” Aw tyumubag silan, “Ya magulang.” Aw miglong si Jisus kanilan, “Matinaw ya paglongun ku kamayu: Nyaka-una pa kamayu nyaka-akup adti Kasakupan na Pighari-an na Tyumanem ya manga mangungubla͡ay sa buwis aw manga ka͡ubayan na miggalin sa pagkaka͡ubayan nilan.” ");
INSERT INTO klg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay nyadi si Juan na Magba͡utismuway na un pakita' kamayu ya pa-agi sa pag-imo' sa pagkaliman na Tyumanem, manang wala' kamu pangintu-u sa piglong nan. Manang ya manga mangungubla͡ay sa buwis aw manga ka͡ubayan na miggalin sa pagkaka͡ubayan nilan, migpakanyeg silan kanan aw migselsel silan. Aw pangkay kya-ede-an da mayu yeiy manang kenne' baling na wala' kamu pagselsel aw wala' kamu uman pangintu-u kanan.” ");
INSERT INTO klg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pakanyegi pa mayu ya sambuk na pundinganan: Awun sambuk na tagtun sa lupa' na migpatanem sa madég na balagen na paras, aw dayaw nan pigpalibedan na alad. Aw migpa-imo' sakanan sa pigisanan sa manga bunga na paras. Aw migpatulluk uman sa matas na tunggu-anan. Pagkatigkas yan, pigpasa-up nan ya kanan parasan. Aw nyanaw sakanan adti sambuk na banwa. ");
INSERT INTO klg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pagdateng na allaw na migpa-ipu' da sa manga bunga na paras, migsugu' ya tagtun sa manga sugu-anen nan adti manga pigpasa-up nan pada kamangen ya kanan bagi'. ");
INSERT INTO klg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Manang pagdateng na manga sugu-anen nan dun, pigdulus baling silan na manga sa-up, aw ya sambuk byadasan nilan pyanumbag, aw ya sambuk pigpatay nilan, aw ya sambuk pyamintu nilan na batu. ");
INSERT INTO klg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aw migsugu' da uman ya tagtun sa madég pa na manga sugu-anen, manang byadasan nilan uman pyamulayaman kasiling na pig-imo' nilan adti manga sugu-anen na nyaka-una. ");
INSERT INTO klg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pagkatigkas yan, pigsugu' da nan adti kanilan ya ise' nan na eseg, aw miglong sakanan, ‘Kun ise' ku ya madtu, un nilan yeiy basa͡an.’ ");
INSERT INTO klg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Manang sa pagkita' na manga sa-up kanan, migbalawbalaw silan na maglong, ‘Ini ya ise' na tagtun! Na! Naten sakanan patayen aw matagtun tadun ya parasan na un ayawan kanan.’ ");
INSERT INTO klg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yanagaw pigdulus nilan aw pigdala adti luwa' na parasan aw pigpatay nilan. ");
INSERT INTO klg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pagkatigkas yan, nyusip si Jisus, “Na, sa pagliku' na tagtun, unu ya imo-un nan adti manga sa-up?” ");
INSERT INTO klg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aw tyumubag silan kanan, “Alag nan saba patayen ya manga malatay na sa-up yan! Aw tigkas yan, pasa-up nan ya parasan adti eped na manga utaw na maka-atag kanan sa bagi' na manga bunga dun ni allaw na pagpa-ipu'.” ");
INSERT INTO klg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aw miglong si Jisus kanilan, “Unu, wala' ka' mayu kabasa ya pigpasulat na Tyumanem asini muna? ‘Ya dakula' na batu na iman na manga panday aw wala' ya guna, yan baling ya batu na sumalem na nya-imo' tullukanan sa dakula' na balay. Ya pig-imo' yeiy na Tyumanem to-o madyaw aw nyakapa-enneng-enneng kanaten.’ ");
INSERT INTO klg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeiy ya du-an na paglongun ta kamu: Dili' da atag na Tyumanem adti kamayu ya manga kadyawan na awun ni Kasakupan na kanan Pighari-an, manang yan baling ya atagan nan ya manga utaw na gayed dyumalug sa kanan pagkaliman. ");
INSERT INTO klg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ya utaw na pagsungkul adti batu yan aw pakadakdak, madugdug sakanan. Aw kun singalan ya kolugan na batu yan, madupuk saba.” ");
INSERT INTO klg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagdengeg da na manga mangkatas na magdadugsu-ay aw manga Parisiyo sa pundinganan ni Jisus, kya-ede-an nilan na silan ya pigpalabet nan. ");
INSERT INTO klg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yanagaw kaliman da galu nilan dakepen si Jisus, manang nyallek silan sa manga utaw dun. Kay adti anenganeng na manga utaw na migkatipun dun, propita si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pagkatigkas yan, pig-ubatan pa silan ni Jisus sa manga pundinganan, law nan, ");
INSERT INTO klg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ya Kasakupan na Pighari-an na Tyumanem, kasiling na maynini: Awun hari' na migpatagilan sa pista na kasal sa ise' nan na eseg. ");
INSERT INTO klg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pigsugu' na hari' ya kanan manga sugu-anen na tawagen da ya manga utaw na dadan da pigpamilit na madtu ni pista na kasal. Manang ya manga pigpamilit wala' baling silan kalim kadtu. ");
INSERT INTO klg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yanagaw migsugu' pa ya hari' sa manga eped na sugu-anen nan, aw miglong sakanan, ‘Na, paglonga la mayu ya manga pigpamilit na nyatagilan da ku ya pista na kasal. Pigpatumba la ku ya kanak manga mangkataba' na baka aw nyalutu' da ya kadakula'. Yanagaw paglonga mayu na maksay da silan madi.’ ");
INSERT INTO klg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Manang pigpalipaslipasan na manga pigpamilit ya piglong na manga sugu-anen nan. Ya eped kanilan nyadtu baling ni pawa', aw ya eped nyadtu ni tindahan nan. ");
INSERT INTO klg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aw ya manga eped uman na pigpamilit, pigdulus nilan ya manga sugu-anen na hari' aw pigpamulayaman nilan, aw pigpamatay. ");
INSERT INTO klg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na, sa pagdengeg na hari' sa kyagamakan na manga sugu-anen nan, to-o sakanan nyadaman. Yanagaw migsugu' sakanan sa manga sundalu pada patayen nilan ya manga migpatay sa manga sugu-anen nan aw pansangaben ya syudad nilan. ");
INSERT INTO klg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatigkas yan, miglong ya hari' adti manga sugu-anen nan, ‘Nyatagilan da ya pista na kasal, manang ya manga utaw na tagna' ku pigpamilit, dili' silan umba' pakadiyen. ");
INSERT INTO klg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yanagaw kadtu kamu ni manga suwayan na manga dalan na syudad, aw pakadiya mayu asini pista ya kadég na manga utaw na kita-en mayu.’ ");
INSERT INTO klg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aw pigtuman na manga sugu-anen ya pigsugu' na hari'. Nyadtu silan adti manga dalan, aw pigpa-agad nilan ya kadég na utaw na pigkita' nilan pangkay madyaw aw malatay na utaw. Aw dayaw nyatmu' ya katipunanan. ");
INSERT INTO klg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Na, wala' kadugay, syumeled ya hari' adti katipunanan na kasal na un magtanaw sa manga pigpamilit, aw kyinita' nan ya sambuk na eseg dun na wala' sut sa kadégkadég na umba' pagsutun adti kasal. ");
INSERT INTO klg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aw nyusip ya hari' kanan, ‘Kay Lew, ananga' kaw makaseled adi na wala' kaw sut sa kadégkadég na pangkasal?’ Manang wala' pakapaglong ya utaw yan. ");
INSERT INTO klg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pagkatigkas yan, miglong ya hari' sa manga sugu-anen nan, ‘Banggeti ya taklayan aw siki na utaw yeiy, aw agbelan mayu sakanan adti banwa na kangitngitan na adti luwa'. Dun ni banwa yan, to-o magpansugaw ya manga utaw aw magpansipanguliteb ya manga untu nilan.’ ” ");
INSERT INTO klg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Aw miglong pa si Jisus, “Madég to-o ya pigpamilit manang tabay olo' ya dyumawat aw yan ya maka-akup adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pagkatigkas yan, pig-indegan na manga Parisiyo si Jisus, aw migkatipun silan na un mag-imo' sa palpa pada kalitagan nilan si Jisus dun ni piglong nan. ");
INSERT INTO klg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yanagaw awun manga utaw na pigsugu' nilan adti kan Jisus, na lekat adti kanilan manga umagakan aw lekat adti partido ni Hérodés, aw miglong silan kan Jisus, “Kay Magpalna-uway, kya-ede-an nami na ya kadég na piglong mu alag saba matinaw, aw gayed mu pigpalna-u ya tengteng pagkaliman na Tyumanem. Aw kya-ede-an uman nami na wala' ya pigkibang mu sa manga utaw pangkay singalan pa silan. ");
INSERT INTO klg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yanagaw, awun usip nami kanmu: Adti kanmu anenganeng, unu, pigtumbay adti Uldin tadun na manga Judiyu ya pagbayad sa buwis adti kan César aw dili'?” ");
INSERT INTO klg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Manang kya-ede-an ni Jisus ya kapandayan nilan. Yanagaw piglongan nan silan, “Alag kamu saba migtallalingu! Ananga' aku mayu tanda-en? ");
INSERT INTO klg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakita͡an kanak ya kuwalta na un mayu pagbayad sa buwis.” Aw pigdimilan nilan sakanan na kuwalta, ");
INSERT INTO klg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","aw nyusip si Jisus kanilan, “Kan yeiy gya ya ini? Aw kan yeiy uman ngalan ya nyakasulat asini?” ");
INSERT INTO klg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aw tyumubag silan, “Kan César.” Aw miglong si Jisus kanilan, “Na, atagan mayu adti kan César ya umba' kan César aw atagan adti Tyumanem ya umba' sa Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sa pagdengeg nilan sa tubag nan, to-o silan nya-enneng-enneng asuntu sa tubag nan. Yanagaw pig-indegan nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dun ni allaw yan, awun dyumulud kan Jisus na manga Sadusiyo. Na, ya manga utaw yeiy, wala' silan pangintu-u na awun pagkataw na manga utaw lekat adti pagkamatay. Yanagaw nyusip silan kanan, ");
INSERT INTO klg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kay Magpalna-uway, piglong kanaten ni Moysis ya sugu' yeiy adti Uldin tadun: ‘Kun awun eseg na nyatay, aw kun wala' silan ya ka͡ubayan nan paka-ise', ka-ilangan pangugnanen na inulug na eseg ya nyabalu pada ya mangayse' nilan ma-imo' da buwadbuwad na inulug nan na nyatay da.’ ");
INSERT INTO klg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, idtu muna adti kanami, awun pitu ya mangkaylug na eseg. Ya magulang na kadég nilan, nyangugnan sa ka͡ubayan. Manang wala' silan paka-ise'. Aw nyatay ya eseg yan, aw ya nyabalu pigpangugnan na mangud na eseg nan. ");
INSERT INTO klg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aw maynan uman ya nya-imo' adti mangud nan aw adti katlu menda' sa kapitu. ");
INSERT INTO klg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pagkatigkas yan, nyatay uman ya ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, ini ya usip nami kanmu: Pagdateng da na allaw na pagmataw sa manga utaw lekat adti nyangkamatay, singalan ya tengteng eseg na ka͡ubayan yan? Kay awun pitu ya eseg na nyangugnan kanan.” ");
INSERT INTO klg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aw tyumubag si Jisus kanilan, “Yan saba ya du-an na nyangkasayep kamu, kay wala' mayu kalabeti ya pigpasulat na Tyumanem asini muna aw wala' mayu uman ka-ede-i ya katulus nan. ");
INSERT INTO klg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kay dun ni pagmataw sa manga utaw lekat adti pagkamatay, dili' da silan mangugnan, kasiling saba na anghil na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aw ya pagmataw sa manga utaw lekat adti nyangkamatay, unu, wala' ka' mayu kabasa ya pigpasulat na Tyumanem asini na muna? Kay miglong sakanan: ");
INSERT INTO klg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aku ya Tyumanem ni Abraham, aw ya Tyumanem ni Isaak, aw ya Tyumanem ni Jakub.’ Yan ya kakawasan nan, pangkay nyatay da silan manang adti asdangan na Tyumanem kenne' na utaw pa silan aw gayed nilan pigsimba ya Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagdengeg na manga utaw sa piglong ni Jisus, to-o silan nya-enneng-enneng sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na, pagdengeg na manga Parisiyo na pigdeg ni Jisus ya kapandayan na manga Sadusiyo, migkatipun silan aw dyumulud adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aw nyusip ya sambuk kanilan na magpalna-uway sa Uldin, pada tanda-en nan si Jisus, law nan, ");
INSERT INTO klg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kay Magpalna-uway, unu ya to-o matas na sugu' na Tyumanem dun ni Uldin na pig-atag nan kan Moysis?” ");
INSERT INTO klg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aw tyumubag si Jisus kanan, “Ginawa͡an mu ya Tyumanem na kanmu Pangulu sa kadakula' na pagka-utawun mu, aw sa kadakula' na ginawa mu, aw sa kadakula' na anenganeng mu. ");
INSERT INTO klg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sa kadég na manga sugu', yeiy ya to-o matas. ");
INSERT INTO klg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aw ya kadwa na sugu' na to-o matas: Ginawayi ya eped mu na utaw kasiling na pagginawa mu sa kanmu pagka-utawun. ");
INSERT INTO klg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kun dalugun mu ya duwa yeiy, dun da mu uman kadalug ya kadég na manga sugu' na awun ni Uldin aw ya pigsulat na manga propita.” ");
INSERT INTO klg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na, sa talana pa na manga Parisiyo migkatipun dun ni pamanag na Témplo, nyusip si Jisus kanilan, ");
INSERT INTO klg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Unu ya anenganeng mayu sa Misiyas? Kan yan buwadbuwad sakanan?” Aw tyumubag silan, “Buwadbuwad sakanan ni Dabid.” ");
INSERT INTO klg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aw miglong si Jisus kanilan, “Na, kun maynan, ananga' miglong si Dabid magi sa Ispiritu Santo na ya Misiyas yan ya Pangulu nan? Miglong saba si Dabid, ");
INSERT INTO klg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Piglongan na Tyumanem ya Misiyas na kanaken Pangulu: “Ingkud kaw apit adi kalintu ku menda' na mabus ku degen ya manga po-on mu aw alag ku silan betang adti salad na manga siki mu.” ’ ");
INSERT INTO klg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yanagaw kun pigtawag ni Dabid ya Misiyas na ‘Pangulu’, pig-unu nan ya pagka-imo' buwadbuwad ni Dabid?” ");
INSERT INTO klg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aw wala' kanilan ya nyakatubag sa usip ni Jisus. Aw lekat dun ni allaw yan, wala' da ya nyaka-eles nyangusip kanan. ");
INSERT INTO klg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkatigkas yan, miglong si Jisus adti madég na manga utaw aw adti manga umagakan nan, law nan, ");
INSERT INTO klg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ya manga magpalna-uway sa Uldin tadun aw ya manga Parisiyo, silan ya awun katundanan mag-ubad sa kakawasan na Uldin na pig-atag na Tyumanem kan Moysis. ");
INSERT INTO klg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yanagaw pakanyegi mayu ya kadég na pigpalna-u nilan aw dayaw mayu daluga. Manang dili' mayu pagsilingan ya kanilan manga pig-imo'. Kay pangkay pigpalna-u nilan ya matinaw manang wala' nilan daluga ya kanilan pigpalna-u. ");
INSERT INTO klg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gayed nilan uman pigdugangan ya manga sugu' na Tyumanem, aw piggelgel nilan pigpadalug ya manga utaw. Aw ya syampetan yan, to-o kyabegatan ya manga utaw sa pagdalug. Manang pigpabaya-an baling nilan aw pangkay tagbi' wala' silan tabang pada matuman ya pigsugu' nilan. ");
INSERT INTO klg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ya kadég na pigpan-imo' nilan, olo' yan ya pagpakita-kita' adti eped na manga utaw pada saya' silan. Alimbawa', to-o nilan pigpakadakula' ya kanilan betanganan sa papiles na pigsulatan sa tingeg na Tyumanem, pada molas kita-en dun ni kanilan bayu' aw bekten. Aw to-o nilan pigpakalawig ya pangawaykaway na kadégkadég na kanilan pagsutun. ");
INSERT INTO klg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aw dun uman ni manga sinagoga aw manga dakula' na pista, kaliman nilan ya mingkud adti ingkudanan na manga dengganen. ");
INSERT INTO klg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pagleya͡an to-o nilan ya pagbasa͡an silan na manga utaw dun ni palingki. Aw pagkaliman nilan ya pagtawagen na ‘Magpalna-uway’. ");
INSERT INTO klg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Manang dili' kamu magkalim na tawagen na manga eped na ‘Magpalna-uway’ kay sambuk da olo' ya kamayu Magpalna-uway. Aw ya kadég mayu kasiling da kamu na mangkaylug dun ni pagpangintu-u mayu. ");
INSERT INTO klg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aw dili' mayu pagtawagen na ‘Ama’ ya kamayu manga magpalna-uway asini tas na lupa', kay sambuk da olo' ya Ama mayu na yan ya awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aw dili' kamu magkalim na tawagen kamu na manga utaw na ‘Amu’, kay sambuk da olo' ya kamayu Amu na yan ya Misiyas. ");
INSERT INTO klg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kun singalan kamayu ya nya-imo' dakula' na utaw, gayed sakanan magpadalem aw ma-imo' sugu-anen dun ni kamayu. ");
INSERT INTO klg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kay pangkay singalan ya magpatastas, un saba sakanan padalemen. Aw ya utaw na magpadalem, un sakanan patasen. ");
INSERT INTO klg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Aw kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan! Migtallalingu kamu! Gayed mayu pigbalabagan ya agiyanan pasinan adti Kasakupan na Pighari-an na Tyumanem. Pangkay kamu dili' kamu malim sumeled. Aw pigpigilan mayu uman ya manga eped na malim galu sumeled. ");
INSERT INTO klg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan! Migtallalingu kamu! Gayed mayu piglimbungan ya manga balu pada agawun ya kanilan lupa' aw balay aw ka-unan. Magpanawagtawag kamu na madugay pada katabunan ya kamayu manga sala'. Yanagaw asuntu seiy, to-o pa mabegat ya pa-emel-emel na Tyumanem kamayu. ");
INSERT INTO klg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan! Migtallalingu kamu! Kay pigbetang mayu sa ginawa ya paglegeb sa kadakula' na banwa, aw ya dagat pigtalipag mayu pada maninaw sa pangkay sambuk na utaw na gagaden mayu adti kamayu pagpangintu-u. Aw sa nyagagad da mayu sakanan, pig-imo' mayu baling sakanan na to-o pa malatay kamayu na umba' agbel adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Malatay ya un mayu datengan! Kasiling kamu saba na buta na miggagad sa manga eped. Pigpalna-u mayu na ‘wala' ya guna kun magsapa' ya utaw magi sa Témplo, manang kun singalan ya magsapa' magi sa bulawan na awun ni Témplo, na, tengteng nan saba imo-un ya sapa' nan aw tumanen ya kanan pigpakang.’ ");
INSERT INTO klg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Buta kamu! Aw wala' ya kya-ede-an mayu! Ayin ka' ya to-o matas: ya bulawan aw ya Témplo? Ya bulawan migkalinis saba olo' asuntu na awun ni seled na Témplo. ");
INSERT INTO klg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aw migpalna-u kamu uman, ‘Kun magsapa' ya utaw magi sa dugsu-anan na awun ni Témplo, wala' ya guna na pagsapa' nan, manang kun magsapa' sakanan magi dun ni dugsu' na pig-ayawan nan dun ni dugsu-anan, na, to-o ma-iganget ya pakang nan.’ ");
INSERT INTO klg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Buta kamu! Ayin ka' ya matas: ya pigdugsu' nan aw ya dugsu-anan? Ya dugsu' migkalinis saba olo' asuntu na awun ni dugsu-anan. ");
INSERT INTO klg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yanagaw pangkay singalan utawa ya magsapa' magi sa dugsu-anan dun ni Témplo, beke' olo' na dugsu-anan ya pigsapa-an nan manang dala uman ya kadég na pigdugsu' dun. ");
INSERT INTO klg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aw kun magsapa' ya utaw magi sa Témplo, na, beke' olo' na Témplo ya pigsapa-an nan, manang dala uman ya Tyumanem na nyeya' adti seled. ");
INSERT INTO klg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aw ya utaw na migsapa' magi sa adti tas na langit, beke' olo' na adti tas na langit ya pigsapa-an nan, manang dala uman ya trunu aw ya Tyumanem na nyingkud dun. ");
INSERT INTO klg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan! Migtallalingu kamu! Dayaw mayu pigdalug ya sugu' dun ni Uldin na atag adti Tyumanem ya kasampulu', pangkay ya mangkayantek na anagay na pigtanem mayu alag mayu pigkamangan. Manang pigpalipaslipasan mayu baling ya to-o matas na manga palna-u na awun ni Uldin, dala ya pag-usay na matulid aw ya pagtabang sa manga makalalat aw pagtuman sa manga pakang. Madyaw saba na nyatag kamu sa kasampulu' adti Tyumanem, manang dili' mayu pagkalingawan ya manga matas na imo-unun na madyaw. ");
INSERT INTO klg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Buta saba kamu na gayed miggagad sa eped! Pagsala͡en mayu ya mangkayantek na mannanap na awun ni inemenen mayu, manang piglamun mayu baling ya dakula' na ayep na kamilyo! ");
INSERT INTO klg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan. Migtallalingu kamu! Kasiling na pag-ugasan mayu ya lawas na tabu' aw ya salad na palatu manang kenne' pa baling na kalipa' na adti seled! Nyatmu' ya kamayu anenganeng na malatay. Aw pigtibagsegan mayu na matagtun pa ya pangkay unu na pagkaliman mayu. ");
INSERT INTO klg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Buta kamu na manga Parisiyo! Una͡a mayu linisi ya kamayu anenganeng pada magkadyaw uman ya manga imo-unun mayu. ");
INSERT INTO klg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kamu na magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan! Migtallalingu kamu! Kasiling kamu na manga ilib na paglebengan sa lawas na manga nyangkamatay. Pigpaputi' na manga utaw ya apit adti luwa' na ilib na paglebengan pada to-o manenggeya' tandawan, manang ya adti seled nyatmu' baling na manga pesa' aw kadég na mangkalipa'. ");
INSERT INTO klg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kasiling kamu saba uman na maynan. Adti mata na manga utaw, iman nilan aw pigdalug mayu ya Uldin na Tyumanem, manang ya tengteng matinaw, dun ni pigpan-imo' mayu, wala' mayu daluga ya kanan manga sugu' kay migtallalingu kamu. ");
INSERT INTO klg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kamu na manga magpalna-uway sa Uldin aw manga Parisiyo, malatay ya un mayu datengan. Migtallalingu kamu! Kay migpa-indeg kamu sa manenggeya na batu aw pigpakanenggeya͡an mayu ya manga lebeng na manga propita aw manga eped na utaw na dayaw uman dyumalug sa pagkaliman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aw miglong kamu, ‘Kun dun pa kami ni manga allaw na manga tyugbulan tadun, dili' galu kami magad sa pagpatay nilan sa manga propita.’ ");
INSERT INTO klg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yanagaw dun ni paglong mayu seiy, pigmatinaw da mayu na kamu ya manga buwadbuwad na manga migpatay sa manga propita! ");
INSERT INTO klg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, tigkasa la ya malatay na pigpalekat da na manga tyugbulan mayu! ");
INSERT INTO klg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ya bet mayu kasiling na ulud. Alag kamu saba kasiling na kamangayse-anan na kamugung! Unun mayu ya pagpakaluwa' sa pa-emel-emel na Tyumanem adti atulun na dili' pagkapatayan? ");
INSERT INTO klg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yeiy ya du-an na magpadala aku adti kamayu sa manga propita, aw manga utaw na matadeng mag-ubad sa tingeg na Tyumanem, aw manga magpalna-uway. Manang ya eped kanilan pamatayen mayu aw ya eped pakalabu mayu adti krus. Aw ya eped kanilan badasan mayu na lalabet adti seled na manga sinagoga mayu. Aw awun manga eped kanilan na pandalugun mayu lekat adti sambuk na lunsud pasinan adti sambuk uman na lunsud pada pamulayaman mayu silan. ");
INSERT INTO klg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yanagaw dumateng adti kamayu ya pagpa-emel-emel na Tyumanem asuntu sa pagpatay mayu sa manga utaw na dyumalug sa pagkaliman nan, lekat pa kan Abel asini muna, aw menda' adti pagpatay kan Zakariyas na ise' ni Barakiyas. Kay ya manga tyugbulan mayu, yan ya migpatay kan Zakariyas adti Témplo, dun ni tenga' na Balay na Tyumanem aw dugsu-anan. ");
INSERT INTO klg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Matinaw ya un ku paglongun kamayu: Un saba asag adti manga utaw adun ya kadakula' na pa-emel-emel na Tyumanem asuntu sa pagpatay aw pagpamulayam sa kanan manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aw miglong pa si Jisus, “We....manga utaw na Jérusalim, pigpamatay mayu ya manga propita na Tyumanem, aw pigpamintu mayu na batu ya manga pigpansugu' nan adti kamayu. Malikit da aku galu magtameng kamayu, kasiling na minsa' na migtatawag sa manga unsuy nan na un nan tipunun adti dalem na manga panid nan, manang wala' kamu kalim! ");
INSERT INTO klg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, un da kamu na Tyumanem pabaya-an. ");
INSERT INTO klg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aw paglongun ta kamu: Kun mindeg da aku, dili' da aku mayu kita-en menda' na dumateng ya allaw na maglong kamu, ‘Ini la ya Pigpadala na Tyumanem dun ni kanan ngalan, aw umba' sakanan deyen!’ ” ");
INSERT INTO klg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na, sa adtu la si Jisus ni luwa' na Témplo, dyumulud adti kanan ya manga umagakan nan aw pigtulli' nilan ya Témplo aw ya kadég na kyinita' nilan dun. ");
INSERT INTO klg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aw miglong si Jisus kanilan, “Kyinita' pa mayu adun ya kadég yeiy, manang matinaw ya un ku paglongun kamayu: Dumateng ya allaw na wala' da ya kita-en asini na manga mangkabakla' na batu na pig-ilantulantu. Ya kadég yeiy alag saba mangkagettan.” ");
INSERT INTO klg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aw pagkatigkas yan, tyumukud silan adti Buntud na Manga Olibo aw nyingkud si Jisus dun. Aw dyumulud uman kanan ya manga umagakan nan na olo' silan aw nyusip silan, “Ubati kami kun kinunu katuman ya kadég na piglong mu kakayna. Aw unu ya pangilala na agpet da ya pagliku' mu aw ya kamoliyan na allaw?” ");
INSERT INTO klg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tyumubag si Jisus kanilan, “Magpakatadeng kamu pagaw awun magpasuway kamayu. ");
INSERT INTO klg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kay awun madég na utaw na un dumateng na dumala sa kanak ngalan aw maglong silan, ‘Aku saba ya Misiyas’ aw madég ya gawayan nilan. ");
INSERT INTO klg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aw makadengeg kamu sa manga dakula' na tanam na malapit adti kamayu aw manga ubat-ubat sa dakula' na tanam adti eped na manga banwa. Manang dili' kamu magkallek. Ka-ilangan una ma-imo' ya kadég yeiy manang beke' pa nan ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ya sambuk na nasud manubbuk sa eped na nasud, aw ya sambuk na kasakupan tumanam sa eped na kasakupan. Dumateng ya dakula' na getem, aw manga linug adti madég na banwa. ");
INSERT INTO klg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Manang ya kadég yeiy, olo' pa yan pagpalekat sa pagti-is na un dumateng, kasiling na ka͡ubayan na bagu pyetesan. ");
INSERT INTO klg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Dumateng ya allaw na tumbay kamu adti pagpamulayam, aw pamatayen kamu. Dumutan kamu na madég na manga utaw asuntu na dyumalug kamu kanak. ");
INSERT INTO klg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aw dun ni manga allaw yan, madég ya tumalikud sa pagpangintu-u nilan kanaken. Aw maglalubiday silan aw magdadumutay. ");
INSERT INTO klg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aw madég uman ya dumateng na sallong kunu propita aw pasuwayen nilan ya madég na utaw. ");
INSERT INTO klg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aw asuntu na magkadég to-o ya imo-unun na malatay, magkaniki' ya paggaginawa͡ay na madég na utaw. ");
INSERT INTO klg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Manang kun singalan ya magpadeleg dun ni pagpangintu-u nan taman adti katigkasan, yan ya utaw na paluwa-en na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aw sa dili' pa dumateng ya katigkasan, pa-ede' adti kadakula' na banwa ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, dun ni manga allaw yan, kita-en mayu adti seled na Témplo na Tyumanem ya to-o malatay aw kallekanan. Yeiy ya pigsulat na propita na si Danyél asini muna. Aw ya magbasa seiy, kalabetan nan galu ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kun kita-en da mayu ya maynan adti Témplo, kamu na awun ni Judiya, maksay kamu palaguy adti manga buntud. ");
INSERT INTO klg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aw kun awun utaw adti luwa' na balay, dili' da sakanan magliku' adti seled na un kumamang sa pangkay unu. ");
INSERT INTO klg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kun awun utaw na magtalabahu adti pawa' nan, dili' da sakanan mag-uli' na un mangay sa kadégkadég nan. ");
INSERT INTO klg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dun ni manga allaw yan, makalalat ya manga ka͡ubayan na mabdes, aw ya manga kalmukan. ");
INSERT INTO klg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Manang panawagtawagi mayu adti Tyumanem na ya pagpalaguy mayu dili' galu ma-imo' dun ni bulan na to-o maniki' aw dun ni Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kay to-o malat ya un kagamakan na manga utaw, aw wala' pa na utaw lemena asini tas na lupa' ya maynan lekat pa adti pag-imo' na Tyumanem sa kadakula' na banwa taman adun. Manang pagkatigkas yan, dili' da yeiy masalut. ");
INSERT INTO klg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kun pigpakadugay pa na Tyumanem ya manga allaw yan na to-o malug, wala' ya utaw na masama' asini tas na lupa'. Manang wala' nan pakadugaya asuntu sa kallat nan sa manga utaw na pigpamalli' nan. ");
INSERT INTO klg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Aw dun ni manga allaw yan, kun awun utaw na maglong kamayu, ‘Tanawa! Ini la ya Misiyas!’ aw maglong ya sambuk, ‘Awun da kunu ya Misiyas!’ Manang dili' mayu silan pagpangintu-uwan. ");
INSERT INTO klg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kay awun dumateng na sallong kunu Misiyas. Aw awun uman dumateng na sallong kunu manga propita na Tyumanem. Magpakita' silan sa manga pangilala aw milagru pada pasuwayen ya manga utaw. Pangkay ya manga pigpamalli' da na Tyumanem pasuwayen nilan kun mabatug. ");
INSERT INTO klg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, pig-ubatan ta kamu dadan pada ka-ede-an mayu ya kadég yeiy. ");
INSERT INTO klg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Yanagaw pagaw awun maglong kamayu, ‘Tanawa, adtu ya Misiyas ni kaligbinan!’ Manang dili' kamu magkadtu. Aw kun maglong silan, ‘Tanawa, awun da sakanan ni seled na tambi' na balay!’ Manang dili' mayu silan pagpangintu-uwan. ");
INSERT INTO klg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kay aku na Ise' na Utaw, dun ni kanak pagliku', kita-en saba na kadég kasiling na kilat na magka-ilaw sa kadakula' na langit. ");
INSERT INTO klg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Awun pundinganan na maglong: ‘Kun ayin ya awun lawas na nyatay da, adtu yan uman pagkatipunuk ya manga uwak.’ Maynan uman, kun kita-en mayu ya manga pangilala na bagu ku piglong, ka-ede-an mayu na agpet da ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na, pagkatigkas da na dakula' na manga kalugan dun ni manga allaw yan, ya sega aw bulan dili' da matag sa kalalamdag. Aw mangkolug ya madég na manga bitun. Aw wala' da ya katundanan na kadég na awun ni dalem na langit. ");
INSERT INTO klg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pagkatigkas yan, kita-en dun ni langit ya pangilala sa pagliku' na Ise' na Utaw. Aw magpansisugaw ya kadég na kasakupan na manga utaw na wala' pangintu-u. Kay aku na Ise' na Utaw, kita-en nilan na magpasinan dun ni labun aw ka-agadan na katulus aw dakula' na kalalamdag na pagka Tyumanem ku. ");
INSERT INTO klg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aw magi sa uni na trumpita na to-o mableg, sugu-un ku ya kanak manga anghil. Aw madtu silan ni silatan aw adti sallepan aw adti balabagan na kadakula' na banwa, aw un nilan angayen aw pantipunun ya manga utaw na pigpamalli' da ku. ");
INSERT INTO klg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, anenganenga mayu ya pundinganan sa kawuy na igira: Kun ya sanga manalingsing aw dumawun da, ka-ede-an na agpet da ya manga bulan na to-o mapasu'. ");
INSERT INTO klg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aw maynan uman, kun kita-en mayu ya kadég na piglong ku kamayu, dun da mayu ka-ede-i na malapit da ya pagliku' ku. ");
INSERT INTO klg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Matinaw ya un ku paglongun kamayu: Ya manga utaw asini tas na lupa' adun na allaw yeiy, dili' pa silan mabus mangkamatay menda' na magpalekat ya kadég na piglong ku. ");
INSERT INTO klg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pangkay kun ma-uman ya langit aw ya kadakula' na banwa manang ya manga tingeg na piglong ku dili' saba ma-uman. ");
INSERT INTO klg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Na, ya allaw aw udas na pagliku' ku, wala' ya utaw na nyaka-ede'. Yan olo' ya nyaka-ede' ya Ama ku na awun ni tas na langit. Pangkay ya manga anghil, aw pangkay aku na Ise' nan wala' uman paka-ede'. ");
INSERT INTO klg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kay kasiling na nya-imo' dun ni manga allaw ni Nuwi, maynan uman ya un ma-imo' dun ni allaw na pagliku' na Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kay sa wala' pa dateng ya dakula' na lenep, migpadeleg ya manga utaw kyuman aw nyan-inem, aw nyampangugnan silan, menda' sa allaw na syumeled si Nuwi adti arka. ");
INSERT INTO klg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aw wala' nilan ka-ede-i kun unu ya kagamakan na un dumateng menda' na miglenep na dakula' aw nyabus silan nyangkalemes. Aw maynan uman, dili' na manga utaw imanmanen ya pagliku' na Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dun ni allaw yan, kun awun duwa ya eseg adti pawa', ya sambuk kamangen aw ya sambuk ka-ayawan. ");
INSERT INTO klg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aw maynan uman, kun awun duwa ya ka͡ubayan na miggiling, ya sambuk kamangen aw ya sambuk ka-ayawan. ");
INSERT INTO klg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yanagaw gayed kamu magpakatanaw, kay wala' mayu ka-ede-i kun kinunu ya pagliku' na kamayu Pangulu. ");
INSERT INTO klg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anenganenga mayu yeiy: Kun nyaka-ede' pa ya tagtun sa balay na awun matakaw na sumeled na gabi yan, magpulaw galu sakanan aw pakatanawan nan ya kanan balay pada dili' makaseled ya matakaw. ");
INSERT INTO klg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yanagaw ka-ilangan mayu magtagilan kamu, kay pangkay unu udasa lumiku' ya Ise' na Utaw na dili' mayu pag-imanmanen.” ");
INSERT INTO klg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Miglong pa si Jisus sa pundinganan, law nan, “Ya sugu-anen na kasaligan aw to-o matadeng, yan ya taliguwan na amu nan sa manga eped nan na sugu-anen dun ni balay. Aw yan ya matag kanilan sa kakan umba' sa allaw yan. ");
INSERT INTO klg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Madyaw ya kana sugu-anen yan kun sa pag-uli' na amu nan, kita-en sakanan na pigpakadyaw nan ya talabahu na pigtaligu kanan. ");
INSERT INTO klg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Matinaw ya un ku paglongun kamayu: Ya sugu-anen yeiy un saba taliguwan na amu nan sa kadakula' na nyatagtun nan. ");
INSERT INTO klg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Manang kun malatay ya bet na sugu-anen, pagaw mag-anenganeng sakanan, ‘Nyasalang pa ya amu kay madugay wala' liku'.’ ");
INSERT INTO klg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yanagaw palekaten nan ya pagpanlabet sa manga eped nan na sugu-anen, aw gayed sakanan kuman aw minem eped na manga pala-inem. ");
INSERT INTO klg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Manang wala' nan imanmana na dumateng ya amu kay wala' nan ka-ede-i ya udas sa pagliku' nan. ");
INSERT INTO klg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aw to-o sakanan pa-emel-emelen aw pasambuk adti banwa na pagludukan sa manga migpantallalingu. Aw dun ni banwa yan to-o silan magsugaw aw magsipanguliteb ya untu nilan.” ");
INSERT INTO klg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Na, dun ni manga allaw yan, ya Kasakupan na Pighari-an na Tyumanem kasiling na maynini: Awun sampulu' ya dalaga na un madtu ni kasal. Dyumala silan sa kanilan manga salengan kay un silan sumungun sa eseg na migpanamung. ");
INSERT INTO klg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Na, dun ni kanilan, awun lima na tagbi' ya katadeng, aw wala' silan dala sa gas na un pagdugang adti salengan nilan. Manang ya lima na to-o matadeng, migtagilan dadan silan sa sabuy na nyatmu' na gas. ");
INSERT INTO klg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Aw asuntu na madugay dyumateng ya migpanamung, yanagaw pigtudtud ya manga dalaga aw ya syampetan yan nyampakatulug silan. ");
INSERT INTO klg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na, pagkatenga-tenga' da na gabi, awun tatawag na miglong, ‘Tanawa! Ini la ya migpanamung! Panamal da kamu aw sunguna mayu sakanan!’ ");
INSERT INTO klg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aw migbangun ya sampulu' ya dalaga, aw pigtagilan nilan ya kanilan manga salengan. ");
INSERT INTO klg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aw ya lima na wala' dala sa gas, migsekat silan adti lima na awun pigdala na gas, miglong silan, ‘Atagi beg kami na gas mayu kay lyumaleng da ya manga salengan nami.’ ");
INSERT INTO klg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Manang tyumubag ya lima na awun pigdala na gas, ‘Pagaw dili' maka-umba' ya gas ini sa kadég tadun. Madyaw pa baling na mayad kamu adti tindahan.’ ");
INSERT INTO klg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yanagaw sa talana nilan nyadtu ni tindahan, dyumateng ya migpanamung. Aw ya lima ya dalaga na nyakatagilan dadan, nyagad silan adti seled aw tyumambung sa pista na kasal. Aw tigkas yan, dayaw pigbalagsangan ya tatakep. ");
INSERT INTO klg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wala' kadugay dyumateng uman ya lima ya dalaga na lekat adti tindahan, aw migtatawag silan, ‘We kay Sir, we.....kay Sir, uwangi beg kami!’ ");
INSERT INTO klg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Manang tyumubag kanilan ya migpanamung, ‘Tengteng na wala' ta kamu kilala͡a!’ ” ");
INSERT INTO klg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yanagaw miglong si Jisus adti manga umagakan nan, “Magpakatanaw kamu aw gayed kamu pagtagilan! Kay wala' mayu ka-ede-i kun kinunu ya allaw aw ya udas na pagliku' ku.” ");
INSERT INTO klg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aw miglong pa si Jisus, “Ya Kasakupan na Pighari-an na Tyumanem kasiling uman na maynini: Awun sambuk na utaw na un madtu ni mawat na banwa. Manang sa wala' pa sakanan indeg, pigtawag nan ya kanan manga sugu-anen, aw pigtaliguwan nan silan umba' sa katadeng nilan magdala sa manga nyatagtun nan ");
INSERT INTO klg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","dala ya kuwalta na un nilan balikwaten. Ya sambuk, pigtaliguwan nan na limammalalan ya kuwalta na bulawan, aw ya sambuk, duwammalalan, aw ya sambuk sammalalan. Aw tigkas yan, nyanaw da sakanan. ");
INSERT INTO klg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, ya sugu-anen na nyakadawat sa limammalalan ya kuwalta na bulawan, maksay nan pigbalikwat ya kanan aw nyakaginansiya uman sa limammalalan. ");
INSERT INTO klg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aw maynan uman, ya nyakadawat sa duwammalalan, pigbalikwat nan uman ya kanan aw nyakaginansiya sakanan sa duwammalalan. ");
INSERT INTO klg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Manang ya nyakadawat sa sammalalan, piglebeng nan baling ya kuwalta adti lupa'. ");
INSERT INTO klg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na, to-o madugay wala' uli' ya amu nilan. Manang sa pag-uli' da nan, pigpatawag nan ya kanan manga sugu-anen na pigtaliguwan nan sa kuwalta, aw pig-usip nan silan kun pig-unu nilan ya pagbalikwat. ");
INSERT INTO klg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dyumulud kanan ya sugu-anen na nyakadawat sa limammalalan, aw pig-atag nan ya kapital aw kyadugangan uman na limammalalan, aw aw miglong sakanan, ‘Kay Sir, idtu muna limammalalan ya pigtaligu mu kanak. Na, tanawa! Nyakaginansya aku uman sa limammalalan.’ ");
INSERT INTO klg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aw miglong ya amu nan, ‘Madyaw ya pig-imo' mu! Asuntu na kasaligan kaw sa tagbi', taliguwan pa ta kaw uman sa dakula'. Na, seled kaw aw agad kaw sa kanak pagleya!’ ");
INSERT INTO klg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Maynan uman, dyumulud kanan ya sugu-anen na nyakadawat sa duwammalalan, aw pig-atag nan ya kapital aw kyadugangan uman na duwammalalan, aw miglong sakanan, ‘Kay Sir, idtu muna duwammalalan ya pigtaligu mu kanak. Na, tanawa! Nyakaginansya aku uman sa duwammalalan.’ ");
INSERT INTO klg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aw miglong kanan ya amu nan, ‘Madyaw ya pig-imo' mu! Asuntu na kasaligan kaw sa tagbi', taliguwan pa ta kaw uman sa dakula'. Na, seled kaw aw agad kaw sa kanak pagleya!’ ");
INSERT INTO klg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pagkatigkas yan, dyumulud kanan uman ya sugu-anen na nyakadawat sa sammalalan ya kuwalta. Aw miglong sakanan, ‘Kay Sir, kya-ede-an ku na wala' ya pagkallat mu, aw pag-aniyen mu ya pigtanem na eped na utaw. ");
INSERT INTO klg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yanagaw nyallek aku, aw ya kuwalta na pigtaligu mu kanak piglebeng ku adti dalem na lupa'. Na, ini ya kuwalta mu.’ ");
INSERT INTO klg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Manang miglong ya amu nan, ‘Malatay ya bet mu aw to-o kaw mataka. Kya-ede-an mu kadi' ya bet ku na pag-aniyen ku ya pigtanem na eped. ");
INSERT INTO klg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, ananga' wala' mu baling betangan adti bangku ya kuwalta ku pada dun ni kanak pagliku' awun ginansya ku?” ");
INSERT INTO klg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pagkatigkas yan, piglongan na amu ya eped na manga sugu-anen, ‘Kamanga ya kuwalta adti kanan aw atagan adti sambuk na sugu-anen na awun sampulummalalan! ");
INSERT INTO klg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kay kun singalan ya migpakadyaw sa pigtaligu kanan, taliguwan pa sakanan sa madég. Manang kun singalan ya wala' pagpakadyaw sa pigtaligu kanan pangkay tagbi', kamangen baling yan lekat adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, agbelan da mayu ya sugu-anen iyan na wala' ya guna adti banwa na kangitngitan na awun ni luwa'. Aw dun ni banwa yan, magpampanguliteb ya untu nilan aw to-o silan magsugaw.’ ");
INSERT INTO klg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Na, aku na Ise' na Utaw, dun ni pagliku' ku ka-agadan aku na dakula' na kalalamdag na kanaken pagka Tyumanem, eped na kadég na manga anghil. Aw mingkud da aku dun ni kanak trunu na pagkahari'. ");
INSERT INTO klg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aw ya kadég na manga utaw asini tas na lupa' magkatipun dun ni asdangan ku. Aw un ku silan tapiden kasiling na magdadiyaga͡ay sa manga ayep na migtapid sa manga karniro lekat adti manga kambing. ");
INSERT INTO klg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya manga karniro tapiden ku silan apit adti kanak kalintu. Manang ya manga kambing tapiden ku uman silan apit adti kawala ku. ");
INSERT INTO klg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pagkatigkas yan, aku na hari' maglong adti manga utaw na apit adti kalintu ku, ‘Kadi kamu na manga pigpakadyaw na kanak Ama, tagtuna la mayu ya pigpakang nan na yan ya pagpaka-akup mayu dun ni Kasakupan na Pighari-an nan. Yeiy saba ya pigtagilan kamayu lekat pa na pagka-imo' na kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kay dun ni manga allaw na nyagetem aku, pigpakan aku mayu, aw dun na pigtalaynem aku, pya-inem aku mayu. Aw dun ni manga allaw na dumadayu aku, pigpapanik aku mayu, aw dayaw aku mayu pigbasa͡an. ");
INSERT INTO klg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kyalugnasan aku, aw pig-atagan aku mayu na kadégkadég. Aw sa kyedelan aku, dayaw aku mayu pigsanggila'. Sa dun na nyakalabusu aku, pigtanaw aku mayu.’ ");
INSERT INTO klg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pagkatigkas yan, musip ya manga utaw na dyumalug sa pagkaliman na Tyumanem, law nilan, ‘Kay Pangulu, kanu kaw nami kita-a na nyagetem aw pigpakan kaw nami? Aw kanu kaw nami kita-a na tyalaynem aw pigpa-inem kaw nami? ");
INSERT INTO klg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aw kanu kaw beg nami kita-a na dumadayu aw pigpapanik kaw nami aw pigbasa͡an? Aw kanu kaw nami kita-a na kyalugnasan aw pig-atagan kaw nami na kadégkadég? ");
INSERT INTO klg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aw kanu kaw nami kita-a na kyedelan aw nyakalabusu aw pigtanaw kaw nami?’ ");
INSERT INTO klg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aw aku na hari' un tumubag kanilan, ‘Matinaw saba ya un ku paglongun kamayu: Sa dun na pig-imo' mayu yeiy adti pangkay sambuk na kanaken eped na to-o tagbi' ya dengeg, kasiling na pig-imo' da mayu uman kanak.’ ");
INSERT INTO klg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagkatigkas yan, paglongun ku ya manga utaw apit adti kawala ku, ‘Pagpakawat kamu kanak, kadég mayu na un da pa-emel-emelen! Adtu kamu ni atulun na dili' pagkapatayan na yan ya pigtagilan dadan na Tyumanem kan Satanas aw sa manga busaw na sakup nan. ");
INSERT INTO klg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay dun ni manga allaw na nyagetem aku, wala' aku mayu pakana. Aw tyalaynem aku, manang wala' aku mayu pa-inema. ");
INSERT INTO klg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dumadayu aku, manang wala' aku mayu papanika adti kamayu balay. Kyalugnasan aku, manang wala' aku mayu atagi na kadégkadég. Kyedelan aku, manang wala' aku mayu sanggila-a. Aw nyakalabusu aku, manang wala' aku mayu tanawa.’ ");
INSERT INTO klg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pagkatigkas yan, maglong uman ya manga utaw yeiy, ‘Kay Pangulu, kanu kaw nami kita-a na nyagetem aw pigtalaynem? Aw kanu kaw nami uman kita-a na dumadayu aw kyalugnasan, aw kyedelan, aw nyakalabusu na wala' kaw nami tabangi?’ ");
INSERT INTO klg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aw tumubag aku kanilan, ‘Matinaw saba ya un ku paglongun kamayu: Kun wala' mayu imo-a yeiy adti pangkay sambuk na to-o tagbi' ya dengeg, kasiling uman na wala' mayu uman imo-a kanak.’ ");
INSERT INTO klg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aw un silan alilinan aw pa-emel-emelen na wala' ya tyamanan. Manang ya manga utaw na gayed dyumalug sa pagkaliman na Tyumanem, atagan saba na ginawa na wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na, pagkatigkas ni Jisus magpalna-u sa kadég yeiy adti manga umagakan nan, piglongan nan silan, ");
INSERT INTO klg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kya-ede-an mayu na dakman duwangallaw dumateng da ya Pista na Paglabay na Anghil na Tyumanem, aw aku na Ise' na Utaw un tumbay adti kanak manga po-on pada kalabuwan adti krus.” ");
INSERT INTO klg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dengan na manga allaw yan, migkatipun uman ya manga mangkatas na magdadugsu-ay aw ya manga magdadumala͡ay sa manga Judiyu adti seled na palasyo ni Kaypas. Na, si Kaypas ya pangulu na manga magdadugsu-ay dun ni umay yan. ");
INSERT INTO klg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aw pigbalawbalawan nilan kun unun nilan ya pagdakep kan Jisus na tagu-tagu' aw pagpapatay kanan. ");
INSERT INTO klg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Manang miglong silan, “Dili' tadun yeiy imo-un sa allaw na Pista ya pagdakep kanan pagaw magubut baling ya manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, talana ni Jisus adti baranggay na Bétaniya, syumeled sakanan dun ni balay ni Simon na awun ibung idtu muna. ");
INSERT INTO klg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aw sa kyuman pa silan dun ni lamisa, awun sambuk na ka͡ubayan na dyumulud kan Jisus aw awun pigdala nan na sabuy na pig-imo' lekat adti batu na alabastro. Aw ya sabuy pigseledan na manimbo' na dakula' to-o ya alaga'. Aw pig-asagan nan na manimbo' ya ulu ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Manang sa pagkita' na manga umagakan nan seiy, nyadaman silan aw law nilan, “Syapadan ya manimbo' iyan! ");
INSERT INTO klg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Madyaw pa baling kun piggalin nan aw ya kuwalta atag adti manga utaw na wala' ya pagkamangan!” ");
INSERT INTO klg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Manang kya-ede-an ni Jisus ya piglong nilan, yanagaw piglongan nan silan, “Ananga' mayu sala-en ya ka͡ubayan yeiy? Madyaw saba ya pig-imo' nan kanak. ");
INSERT INTO klg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ya manga utaw na wala' ya pagkamangan gayed mayu pig-iyeped. Manang aku, dili' da aku madugay asini sayid mayu. ");
INSERT INTO klg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aw dun ni pag-asag nan sa manimbo' asini lawas ku, kasiling na pigtagilan da nan dadan ya kanak lawas na un lebeng. ");
INSERT INTO klg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Matinaw saba ya un ku paglongun kamayu: Pangkay ayin pa-ede-an ya Madyaw na Ubat-ubat adti kadakula' na banwa, gayed uman ubat-ubat ya pig-imo' nan kanaken pada dili' sakanan kalingawan.” ");
INSERT INTO klg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na, dun ni sampulu' tag duwa ya umagakan ni Jisus, ya sambuk kanilan si Judas Iskariyoti. Aw nyadtu sakanan adti manga mangkatas na magdadugsu-ay, ");
INSERT INTO klg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aw piglongan nan silan, “Unu ya atag mayu kanak kun tumbay ku si Jisus adti kamayu?” Yanagaw pig-atagan nilan sakanan na katluwan ya kuwalta. ");
INSERT INTO klg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aw lekat dun ni allaw yan, tyumagad si Judas sa selat na un nan lubidan si Jisus adti kanilan. ");
INSERT INTO klg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na, dyumateng da ya Pista na Pan na Wala' Patulina. Yanagaw dyumulud adti kan Jisus ya manga umagakan nan, aw law nilan, “Ayin ya kaliman mu pakadtuwan kanami pada tagilanen kanmu ya pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aw tyumubag si Jisus kanilan, “Kadtu kamu ni Jérusalim, aw kita-en mayu dun ya sambuk na utaw. Paglonga mayu sakanan, ‘Nyamene' ya Magpalna-uway na malapit da ya allaw na pigpamalli' na Tyumanem, aw kaliman nan kuman adti balay mu sa pangiyambungay sa Pista eped na kanan manga umagakan.’ ” ");
INSERT INTO klg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yanagaw pigtuman na manga umagakan nan ya piglong ni Jisus, aw pigtagilan nilan ya pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na, sa pagkamagsiklep da, migkatipun adti lamisa si Jisus aw ya sampulu' tag duwa ya umagakan nan. ");
INSERT INTO klg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa talana nilan kyuman, miglong si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Awun sambuk kamayu na un maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pagdengeg na manga umagakan nan, migkalat to-o ya ginawa nilan, aw nyusip ya tagsambuksambuk kanilan, “Kay Magpalna-uway, beke' ku ya pyalabet mu?” ");
INSERT INTO klg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aw tyumubag si Jisus kanilan, “Awun sambuk kamayu na tyumugmuk sa pan eped ku asini lipung ini na yan ya un maglubid kanak. ");
INSERT INTO klg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aku na Ise' na Utaw un saba patayen kasiling na dadan da pigpasulat asini muna. Manang malatay ya un datengan na utaw na maglubid kanak. Madyaw pa baling kanan ya wala' ka͡utaw asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pagkatigkas yan, miglong si Judas na maglubiday kan Jisus, “Kay Magpalna-uway, enda' aku ya pyalabet mu?” Aw tyumubag si Jisus kanan, “Piglong da mu.” ");
INSERT INTO klg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na, talana nilan kyuman, migkamang si Jisus sa pan aw pigpasalamatan nan adti Tyumanem. Tigkas yan, pigtenga-tenga' nan aw pigpan-atag nan adti kanan manga umagakan, aw miglong sakanan, “Dawata aw kana mayu, kay yeiy ya kanak lawas.” ");
INSERT INTO klg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagkatigkas yan, pigkamang nan uman ya tabu' na pigseledan sa bino aw pigpasalamatan adti Tyumanem. Aw pigdimil nan kanilan ya tabu', aw piglongan nan silan, “Ya tagsambuksambuk kamayu minem asini tabu' ini, ");
INSERT INTO klg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kay yeiy ya kanak dugu' na un pa-iligen pada lanasen ya sala' na manga utaw. Magi sa dugu' ku, yan ya magpa-iganget sa bagu na pakang na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Paglongun ta kamu na dili' da ku salutun ya minem sa bino na paras menda' sa allaw na adtu la aku inem eped mayu dun ni pighari-an na kanak Ama.” ");
INSERT INTO klg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagkatigkas ni Jisus maglong, migdalangan silan sa pagdeyen adti Tyumanem. Aw nyanaw da silan aw tyumukud adti Buntud na Manga Olibo. ");
INSERT INTO klg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aw sa dun pa silan ni dalan, miglong si Jisus kanilan, “Adun na gabi, un kamu magsipalaguy aw maksay aku mayu ayawan. Kasiling na pigpasulat dadan na Tyumanem: ‘Patayen ku ya magdadiyaga͡ay aw magpanbeklag ya manga karniro nan.’ ");
INSERT INTO klg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Manang pagkatigkas na pagkataw ku lekat adti pagkamatay, muna aku kamayu adti Galiliya.” ");
INSERT INTO klg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aw miglong si Pédro kanan, “Pangkay kun ayawan kaw na kadég nilan, manang aku, dili' ta kaw ayawan!” ");
INSERT INTO klg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Manang miglong si Jisus kanan, “Matinaw saba ya un ku paglongun kanmu: Kagaya na gabi, sa dili' pa tumaga-uk ya manuk, balyaw aku mu na makatlu.” ");
INSERT INTO klg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Miglong uman si Pédro kanan, “Pangkay patayen pa aku nilan eped mu, manang ya magbalyaw kanmu, dili' ku yan ma-imo'!” Aw maynan uman ya piglong na kadég na manga eped nan. ");
INSERT INTO klg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na, dyumateng si Jisus aw ya manga umagakan nan adti banwa na pigngalanan na Gétsémani. Aw miglong si Jisus kanilan, “Ingkud da kamu asini talana ku adtu manawagtawag.” ");
INSERT INTO klg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aw pigpa-agad nan si Pédro, aw ya duwa ya ise' ni Zibidiyo na eseg. Aw wala' katingen ya anenganeng ni Jisus, aw to-o migkalat ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aw piglongan nan silan, “Kasiling na un da aku matay sangadi sa kakalatan na ginawa ku. Pagtagad pa kamu asini aw pagpulaw kamu eped ku.” ");
INSERT INTO klg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aw migpa-awat pa si Jisus kanilan tagbi' aw lyumebleb adti lupa' aw nyanawagtawag, “Kay Ma', kun mabatug, kamanga beg kanak ya pagti-is na un ku ka-agiyan. Manang beke' na kanak pagkaliman ya matuman. Yan baling ya matuman ya kanmu pagkaliman.” ");
INSERT INTO klg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagkatigkas yan, lyumiku' si Jisus adti tulu ya umagakan nan aw kyinita' nan na nyampakatulug silan. Aw piglongan nan si Pédro, “Ananga' kamu makatulug? Unu, dili' mayu mabatug ya magpulaw eped ku pangkay sangka-udas olo'? ");
INSERT INTO klg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pagpulaw kamu aw panawagtawag pada dili' kamu degen na pagtanda'. Kaliman galu na utaw na manawagtawag, manang pigdeg baling na kalumay na kanan lawas.” ");
INSERT INTO klg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aw migpa-awat da uman si Jisus kanilan aw nyanawagtawag, “Kay Ma', kun dili' mu beg tumbay na makamang adi kanak ya pagti-is, na, matuman da ya kanmu pagkaliman.” ");
INSERT INTO klg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aw lyumiku' pa salut si Jisus adti manga umagakan nan, aw kyinita' nan na nyampakatulug da uman silan, kay to-o silan pigtudtud. ");
INSERT INTO klg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yanagaw pig-indegan da nan uman silan aw nyadtu sakanan ni mawatawat aw katlu la nan nyanawagtawag adti kanan Ama. Aw ya pagpanawagtawag nan kasiling na piglong nan idtu na tagna' aw kadwa na pagpanawagtawag nan. ");
INSERT INTO klg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatigkas yan, lyumiku' da uman si Jisus adti manga umagakan nan aw piglongan nan silan, “Unu, kenne' pa mayu kyumulang aw nyakatulug? Tanawa! Dyumateng da ya udas na ya Ise' na Utaw un lubidan aw tumbay adti manga makasasala'. ");
INSERT INTO klg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pagbangun kamu! Kitadun da! Iyan da ya utaw na un maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sa talana pa ni Jisus miglong, dyumateng si Judas Iskariyoti. Sambuk sakanan dun ni sampulu' tag duwa ya umagakan ni Jisus. Eped nan ya madég na utaw na nyandala sa kampilan aw babunal. Pigsugu' silan na manga mangkatas na magdadugsu-ay aw magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, dadan da silan ni Judas pigpa-ede' sa pangilala, law nan, “Ya utaw na alekan ku, yan ya dakepen mayu.” ");
INSERT INTO klg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aw dyumulud si Judas adti kan Jisus aw miglong sakanan, “Kay Magpalna-uway, madyaw na gabi kanmu!” Aw pig-alekan nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tyumubag si Jisus kanan, “Kay Lew, imo-a la ya kaliman mu imo-un.” Aw pigdulus na manga eped ni Judas si Jisus aw pigdakep nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ya sambuk na umagakan ni Jisus, pigtagnus nan ya kanan kampilan, aw pigtibas nan ya sugu-anen na pangulu na manga magdadugsu-ay, aw dayaw nya-ilap ya talinga nan. ");
INSERT INTO klg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aw miglong si Jisus kanan, “Uli-an adti luma' ya kampilan mu! Kay ya kadég na magpatay sa eped nan magi sa kampilan, patayen uman silan magi sa kampilan. ");
INSERT INTO klg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Unu, wala' mu ka-ede-i na mabatug ku ya magsekat sa tabang adti kanak Ama, aw maksay saba aku padala͡an na pangkay pilammalalan ya anghil?” ");
INSERT INTO klg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Manang kun imo-un ku ya maynan, unun pa ya pagkatuman sa pigpasulat na Tyumanem asini muna na ka-ilangan ma-imo'?” ");
INSERT INTO klg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aw miglong si Jisus adti manga utaw dun, “Ananga' kamu dumala sa manga kampilan aw babunal? Kasiling kamu na migdakep sa ribildi! Kada allaw migpalna-u aku dun ni Témplo, aw wala' aku mayu dakepa. ");
INSERT INTO klg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Manang ya kadég yeiy ka-ilangan ma-imo', pada matuman ya pigpasulat na Tyumanem magi sa manga propita nan asini muna.” Aw tigkas yan, migsipalaguy ya manga umagakan ni Jisus aw pig-ayawan nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ya manga utaw na migdakep kan Jisus, pigpa-agad nilan sakanan adti asdangan ni Kaypas na yan ya pangulu na manga magdadugsu-ay. Aw migpangkatipun dun ni balay nan ya manga magpalna-uway sa Uldin aw ya manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aw dyumalug si Pédro kanilan manang migpa-awatawat kan Jisus aw taman da olo' sakanan dun ni pamanag na balay na pag-usayan. Aw pagseled nan adti pamanag, nyingkud sakanan dun ni sayid na manga magtatunggu-ay kay kaliman nan ka-ede-an kun unu ya un ma-imo' kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na, adti seled, dun ya manga mangkatas na magdadugsu-ay aw ya kadég na matas na mag-usayay. Aw gayed silan nyaninaw sa utaw na magmatinaw sa galu' adti kan Jisus pada awun puliba na patayen sakanan. ");
INSERT INTO klg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pangkay awun madég na utaw na migmatinaw sa galu' adti kanan, manang wala' ya kyinita' nilan na indeganan na papatay nilan sakanan. Tigkas yan, nyindeg ya duwa adti asdangan nilan ");
INSERT INTO klg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aw miglong silan, “Miglong ya utaw ini, ‘Mabatug ku kalaten ya Témplo na Tyumanem aw seled na tulungallaw mabatug ku uman imo-un.’ ” ");
INSERT INTO klg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aw nyindeg ya pangulu na manga magdadugsu-ay aw nyusip kan Jisus, “Unu ya tubag mu sa diklamu nilan kanmu?” ");
INSERT INTO klg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Manang wala' si Jisus tubag. Yanagaw, pig-usip da nan uman: “Dun ni ngalan na Tyumanem, ubati kami sa tengteng matinaw. Unu, ikaw ka' ya Misiyas, ya Ise' na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aw tyumubag si Jisus kanan, “Piglong da mu. Manang paglongun ta kamu adun: Kagaya na moli na allaw, kita-en mayu aku na Ise' na Utaw na mingkud apit adti kalintu na Tyumanem na To-o Matulus. Aw kita-en aku mayu uman na lumiku' na ka-agadan na manga labun.” ");
INSERT INTO klg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagdengeg na pangulu na manga magdadugsu-ay sa tubag ni Jisus, pigkésé' nan ya kanan sa-ul asuntu sa kadaman nan aw miglong, “Ya utaw yeiy miglong sa malatay adti Tyumanem! Ananga' pa kitadun maninaw sa eped na un magmatinaw? Dyengeg da mayu saba ya piglong nan. Migpa-unawa sakanan sa Tyumanem! ");
INSERT INTO klg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, unu ya kamayu pagbaya'?” Aw tyumubag silan, “Umba' sakanan patayen!” ");
INSERT INTO klg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aw tigkas yan, pig-eleb-eleban nilan ya gya ni Jisus, aw byadasan nilan sakanan pyanumbag, aw gayed nilan pigpanampal, ");
INSERT INTO klg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aw pig-odoy-odoy nilan sakanan na miglong, “Na, kun ikaw ya Misiyas, ubatan kanami kun singalan ya migsumbag kanmu!” ");
INSERT INTO klg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na, sa talana pa ni Pédro nyingkud adti luwa' dun ni pamanag, awun sambuk na sugu-anen adti balay na dyumulud kanan aw miglong, “Enda', ikaw uman ya eped ni Jisus na taga Galiliya!” ");
INSERT INTO klg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Manang pigbalyaw ni Pédro si Jisus adti asdangan na kadég na manga utaw dun ni pamanag, law nan, “Wala' ku ka-ede-i ya piglong mu!” ");
INSERT INTO klg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagkatigkas yan, mig-alin si Pédro adti suwangan na pamanag. Aw kyinita' uman sakanan na sugu-anen na bubay aw miglong sa manga utaw dun, “Ya eseg yeiy, eped saba ni Jisus na taga Nazarit!” ");
INSERT INTO klg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aw uman da ni Pédro pigbalyaw aw migsapa', law nan, “Matay pa aku, wala' ku kilala͡a ya utaw yan!” ");
INSERT INTO klg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na, awun manga utaw na mig-indeg-indeg dun. Aw wala' kadugay, dyumulud silan kan Pédro aw miglong silan, “Matinaw saba na ikaw ya sambuk kanilan. Pangkay ya linitukan mu taga Galiliya.” ");
INSERT INTO klg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aw migsapa' salut si Pédro, law nan, “Matay pa aku, wala' ku saba kilala͡a ya utaw yan na piglong mu!” Aw tigkan tyumaga-uk ya manuk. ");
INSERT INTO klg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aw dun da ni Pédro ka-anenganengi ya piglong kanan ni Jisus, “Sa dili' pa tumaga-uk ya manuk, balyaw aku mu na makatlu.” Aw migkalat ya ginawa ni Pédro, yanagaw lyumuwa' sakanan aw to-o migsugaw. ");
INSERT INTO klg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na, pagkamaselem da, migkasambuk ya ginawa na kadég na mangkatas na magdadugsu-ay aw manga magdadumala͡ay sa manga Judiyu kun unu ya un nilan imo-un kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yanagaw pigpagapus nilan, aw pigpa-agad nilan adti kan Pilato na yan ya gubirnador na taga Roma. ");
INSERT INTO klg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, si Judas na maglubiday, sa pagka-ede' nan na pig-ukuman da si Jisus na patayen, to-o nan pigselsel ya kanan pagka-utawun. Aw pig-uli' nan ya katluwan ya kuwalta na pig-atag kanan na manga mangkatas na magdadugsu-ay aw magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aw miglong sakanan kanilan, “Nyakasala' aku, kay piglubidan ku ya utaw na wala' ya sala'!” Manang tyumubag silan, “Unu ya kanami labet? Kanmu la yan tubagenen!” ");
INSERT INTO klg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yanagaw pigsabug ni Judas ya kuwalta dun ni Témplo, aw nyanaw sakanan. Aw tigkas yan, tyumuyu' sakanan na pig-eketan ya liyeg adti tas na kawuy. ");
INSERT INTO klg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na, pyamulut na manga mangkatas na magdadugsu-ay ya kuwalta aw miglong silan, “Kun uli' tadun ya kuwalta ini adti tipunanan sa kuwalta na Témplo, kalakadan tadun ya Uldin kay yeiy ya pigbayad pada papatay ya sambuk na utaw.” ");
INSERT INTO klg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yanagaw pigbalawbalawan nilan kun unu ya madyaw imo-un sa kuwalta yan, aw tyumande' silan na bayad sa lupa' na sambuk na utaw na mag-imo-ay sa manga kulun. Aw pig-imo' nilan lebenganan sa manga utaw na dumadayu. ");
INSERT INTO klg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yeiy ya du-an na taman adun pigngalanan na manga utaw ya lupa' yeiy na “Lupa' na Pigbayadan na Dugu'.” ");
INSERT INTO klg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aw dun ni pig-imo' nilan, nyatuman da ya pigsulat na propita na si Jérémiyas asini muna na miglong: “Pigkamang nilan ya katluwan ya kuwalta, kay yan ya alaga' na pigkapakangan da na manga buwadbuwad ni Isra-él na umba' pagbayad kanan. ");
INSERT INTO klg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aw ya kuwalta yan pigbayad sa lupa' na utaw na mag-imo-ay sa kulun, kay yeiy ya pigsugu' na Tyumanem kanak.” ");
INSERT INTO klg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, nyindeg si Jisus adti asdangan na gubirnador aw pig-usip nan, “Unu, ikaw ya hari' sa manga Judiyu?” Aw tyumubag si Jisus, “Piglong da mu.” ");
INSERT INTO klg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Manang wala' nan tubaga ya diklamu na manga mangkatas na magdadugsu-ay aw manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pagkatigkas yan, nyusip pa si Pilato kanan, “Unu, wala' mu dengega ya kadég na manga diklamu nilan kanmu?” ");
INSERT INTO klg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Manang pangkay sambuk na diklamu nilan, wala' ya pigtubag ni Jisus kanan. Aw nyabelengbeleng to-o kanan si Pilato. ");
INSERT INTO klg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kada umay dun ni Pista na Paglabay na Anghil na Tyumanem, awun katanem na gubirnador magpaluwa' sa sambuk na nyakalabusu na kaliman na manga utaw paluwa-en. ");
INSERT INTO klg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aw dun ni kalabusuwanan awun sambuk na utaw na pigngalanan na Barabas. Aw to-o malatay ya dengeg nan. ");
INSERT INTO klg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yanagaw sa pagkatipun da na manga utaw, pig-usip silan ni Pilato, “Singalan ya kaliman mayu na paluwa-en ku, si Barabas, aw kun si Jisus na pagtawagen na Misiyas?” ");
INSERT INTO klg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kay kya-ede-an ni Pilato na to-o nyinga' kan Jisus ya manga magdadumala͡ay sa manga Judiyu, aw yan ya du-an na pigtumbay nilan si Jisus adti kanan. ");
INSERT INTO klg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sa kenne' pa ni Pilato nyingkud adti ingkudanan na pag-ukum, migpadala ya ka͡ubayan nan sa tingeg na miglong, “Pabaya-i la ya utaw yan. Kay wala' ya sala' nan. Kumanggabi to-o nyalinggal ya anenganeng ku asuntu sa tagaynep ku kanan.” ");
INSERT INTO klg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Manang ya manga mangkatas na magdadugsu-ay aw manga magdadumala͡ay sa manga Judiyu, pigpalna-uwan nilan ya manga utaw na sekaten nilan na paluwa-en si Barabas aw papatay si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aw nyusip salut si Pilato kanilan, “Singalan kanilan duwa ya kaliman mayu na paluwa-en ku?” Tyumubag silan, “Si Barabas!” ");
INSERT INTO klg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aw nyusip pa si Pilato kanilan, “Kun paluwa-en ku si Barabas, unun ku ya utaw yeiy na pagtawagen na Misiyas?” Aw tyumubag ya kadég nilan, “Pakalabuwan sakanan adti krus!” ");
INSERT INTO klg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aw miglong pa si Pilato, “Ananga', unu ya nya-imo' nan na malatay?” Manang to-o la baling silan nyamansag, “Pakalabuwan sakanan adti krus!” ");
INSERT INTO klg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kyinita' da ni Pilato na wala' ya un nan mabatug kay migpalekat da miggubut ya manga utaw. Yanagaw migpakamang sakanan sa tubig aw mig-unaw dun ni asdangan na kadég na utaw, aw miglong sakanan, “Na! Kun patayen mayu ya utaw yeiy, beke' da yan na kanak sala'. Kamayu la yan tubagenen!” ");
INSERT INTO klg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aw alag silan nyamansag, “Kami aw ya kanami manga buwadbuwad ya manubag sa kamatayen nan!” ");
INSERT INTO klg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yanagaw pigpaluwa' ni Pilato si Barabas. Manang si Jisus pigpalabet nan aw pigtumbay nan adti kanilan pada kalabuwan adti krus. ");
INSERT INTO klg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aw pigdala si Jisus na manga sundalu na Romanen adti pamanag na palasyo na gubirnador. Aw pigtawag nilan ya kadég na sundalu aw kalimpungi nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aw pigluwasan nilan sakanan aw pigpasut nilan sa malawig na sa-ul na tapel ya batek kasiling na pagsutun na hari'. ");
INSERT INTO klg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pagkatigkas yan, mig-imo' silan sa korona na suksukun aw pigsangkub nilan adti ulu ni Jisus. Aw pigpa-awid nilan sakanan sa bangka' adti kalintu na tullu' nan. Aw lyumuhud silan adti asdangan nan, aw pig-odoy-odoy nilan na sallong kunu syumaludu silan kanan, aw miglong silan, “Kay Hari' na manga Judiyu, magkadugay pa galu ya pag-eya' mu asini tas na lupa'!” ");
INSERT INTO klg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pigpan-eleban nilan si Jisus aw pigkamang nilan adti kanan ya bangka' aw gayed nilan pigbunalan ya ulu nan. ");
INSERT INTO klg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatigkas nilan sakanan odoy-odoyun, pigluwasan nilan sa malawig na sa-ul aw pigliku' nilan pigpasut ya kanan kadégkadég. Aw tigkas yan, pigdala na manga sundalu si Jisus adti luwa' na syudad na un nilan kalabuwan adti krus. ");
INSERT INTO klg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sa pagdala na manga sundalu kan Jisus adti luwa' na syudad na Jérusalim, pig-isungun nilan ya sambuk na eseg na si Simon na taga syudad na Ciréné, aw pigleges pigpapisan kanan na manga sundalu ya krus ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aw dyumateng da silan adti banwa na pigngalanan na Golgota na ya kakawasan: Banwa na Pesa' na Ulu. ");
INSERT INTO klg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pigdimilan nilan si Jisus na bino na pigdali-an na to-o mapayit. Manang sa pagtémtém nan, wala' nan inema. ");
INSERT INTO klg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aw tigkas yan, pigkalabuwan nilan si Jisus adti krus. Aw migbunutbunut ya manga sundalu kun singalan kanilan ya makatagtun sa tagsambuksambuk na kadégkadég ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagkatigkas yan, nyingkud silan adti dalem na krus, aw pigtunggu-an nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aw apit adti tas na ulu nan awun pigtapli' na tabla na pigsulatan sa limanda kanan: “Yeiy si Jisus, ya Hari' na manga Judiyu.” ");
INSERT INTO klg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na, dun ni tampid ni Jisus awun uman duwa ya ribildi na pigkalabuwan adti manga krus nilan, ya sambuk apit adti kalintu aw ya sambuk uman apit adti kawala. ");
INSERT INTO klg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ya manga utaw na lyumabay dun, mig-odoy-odoy silan kan Jisus aw mig-eleng-eleng silan, ");
INSERT INTO klg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aw law nilan, “Miglong kaw na kalaten mu ya Témplo aw seled na tulungallaw pa-indegen mu uman salut ya bagu. Na! Tabangi ya kanmu pagka-utawun! Kun tengteng matinaw na ikaw ya tengteng Ise' na Tyumanem, panog kaw dun ni krus!” ");
INSERT INTO klg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Maynan uman, mig-odoy-odoy kanan ya manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin, aw ya manga magdadumala͡ay sa manga Judiyu, ");
INSERT INTO klg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","aw miglong silan, “Mabatug nan tabangan ya manga eped manang dili' nan mabatug tabangan ya kanan pagka-utawun. Hari' kunu sakanan sa manga utaw na Isra-él! Kun manog sakanan dun ni krus, mangintu-u kami kanan! ");
INSERT INTO klg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Piglong nan na syumalig sakanan sa Tyumanem. Na, pakatanawan tadun kun kaliman na Tyumanem paluwa-en sakanan. Kay gayed nan piglong kunu na ‘Aku ya Ise' na Tyumanem.’ ” ");
INSERT INTO klg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aw pangkay uman ya duwa ya ribildi na pigkalabu eped nan, mig-odoy-odoy uman kanan. ");
INSERT INTO klg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, pagka-alas dosi la, migkangitngit ya banwa seled na tulungka udas. ");
INSERT INTO klg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pagka-alas trés na ambung, mig-ulangag si Jisus, aw mableg to-o ya tingeg nan, miglong sakanan, “Éli, Éli, lama sabaktani?” Ya kakawasan na piglong nan: “We....Tyumanem ku! We....Tyumanem ku! Ananga' aku mu ayawan?” ");
INSERT INTO klg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sa pagdengeg na manga utaw na malapit dun, miglong ya eped kanilan, “Pigtawag nan ya propita na si Éliyas.” ");
INSERT INTO klg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aw sambuk kanilan maksay nyangay sa ispongha aw pig-elem nan adti bino na malagsing. Aw pigbetang nan adti tuktuk na layi' aw pigsungit nan kan Jisus na un pasepsep kanan. ");
INSERT INTO klg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Manang miglong ya manga eped nilan, “Tagadan pa tadun! Tanawun tadun kun madi si Éliyas aw magtabang kanan.” ");
INSERT INTO klg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aw mig-ulangag to-o si Jisus, aw tigkas yan nyabugtu' ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aw nyakisay ya to-o madakmel na téla na pigsaliben na awun ni Témplo, aw dayaw nyatenga' lekat adti tas taman adti dalem. Aw nyangka-eyeng ya lupa', aw nyangkabetak ya manga batu'. ");
INSERT INTO klg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aw pyangka-uwangan ya manga lebeng, aw madég ya nyangkataw na manga nyangintu-u sa Tyumanem, ");
INSERT INTO klg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","aw lyumuwa' silan adti kanilan manga lebeng. Pagkataw da ni Jisus lekat adti pagkamatay, syumeled silan adti Jérusalim, aw dun da silan kita-a na madég na utaw. ");
INSERT INTO klg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, migtunggu' dun kan Jisus ya sambuk na kapitan aw manga eped nan na sundalu. Aw sa pagbati' nilan sa linug aw sa pagkita' nilan sa kadég na nyangka-imo' dun, to-o silan nyangkallek aw nyakapaglong silan, “Matinaw kadi'! Ya utaw ini, tengteng saba Ise' na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Awun uman madég na ka͡ubayan na migtandaw adti mawatawat. Silan ya taga Galiliya na gayed migsanggila' aw tyumabang kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eped dun ni kanilan si Maria na taga lunsud na Magdala, aw si Maria na ina ni Santiago aw ni José, aw dun uman ya ka͡ubayan ni Zibidiyo. ");
INSERT INTO klg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa un da sumallep ya sega, dyumateng dun ya sambuk na utaw na mayaman na si José na taga Arimatiya. Aw nyangintu uman sakanan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aw nyadtu si José ni kan Pilato aw pigsekat nan ya lawas ni Jisus pada lebeng nan. Aw migsugu' si Pilato na atag ya lawas ni Jisus adti kan José. ");
INSERT INTO klg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yanagaw pigdala ni José ya lawas aw pigbedbedan nan na bagu na téla na linum. ");
INSERT INTO klg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na, awun pig-imo' da ni José na lebeng dun ni kilid na pangpang na yan ya pigtagilan nan galu sa paglebengan kanan. Aw dun nan betangan ya lawas ni Jisus. Aw tigkas yan, miglilid si José sa dakula' na batu adti baka' na ilib aw nyanaw sakanan. ");
INSERT INTO klg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aw nyingkud si Maria na taga Magdala aw ya sambuk pa uman na Maria malapit dun ni piglebengan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na, pagkasalut na allaw, yan ya Allaw na Pagladeng. Aw migkatipun adti asdangan ni Pilato ya manga mangkatas na magdadugsu-ay aw manga Parisiyo ");
INSERT INTO klg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","aw miglong silan, “Kay Gubirnador, kya-anenganengan nami ya piglong na maggawayay yan idtu na wala' pa sakanan kamatay. Miglong sakanan, ‘Paglabay na tulungallaw, matawun aku lekat adti pagkamatay.’ ");
INSERT INTO klg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yanagaw migsekat kami kanmu na magsugu' kaw sa manga sundalu na tunggu-an nilan ya piglebengan kanan taman adti katlu na allaw, pagaw takawun na manga umagakan nan ya lawas aw gayed silan mag-ubat-ubat adti manga utaw na nyataw da sakanan lekat adti pagkamatay. Aw ya sampetan yan, to-o pa ya paggalu' nilan kay sa idtu muna.” ");
INSERT INTO klg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yanagaw miglong si Pilato kanilan, “Pagtawag kamu sa manga sundalu aw pakadyawa mayu ya pagpatunggu' sa piglebengan kanan!” ");
INSERT INTO klg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aw nyadtu silan adti piglebengan kan Jisus. Aw pigpangilala͡an nilan ya dakula' na batu na pigtampeng adti baka' na ilib pada ka-ede-an nilan kun awun utaw na mag-anggin sa batu. Aw pigpatunggu-an nilan sa manga sundalu ya lebeng. ");
INSERT INTO klg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, nyatigkas da ya Allaw na Paglagdeng. Aw sa to-o pa maselem na allaw na Linggo, nyadtu si Maria na taga Magdala aw ya sambuk uman na Maria adti piglebengan kan Jisus kay kaliman nilan tanawun. ");
INSERT INTO klg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aw bigla' miglinug na to-o mabagseg, kay nyanog ya sambuk na anghil na Tyumanem lekat adti tas na langit. Aw nyadtu ya anghil ni piglebengan aw pig-anggin nan ya dakula' na batu na pigtampeng sa baka' na ilib. Aw nyingkud sakanan dun ni tas na batu. ");
INSERT INTO klg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","To-o nyinag ya gya nan kasiling na kilat, aw to-o maputi' ya kadégkadég nan. ");
INSERT INTO klg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aw sa pagkita' na manga magtatunggu-ay sa anghil, to-o silan migteneb aw pyantakigan aw pigkuyapan kasiling na nyangkamatay silan. ");
INSERT INTO klg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Manang piglongan na anghil ya manga ka͡ubayan, “Dili' kamu magkallek! Kya-ede-an ku na pyaninaw mayu si Jisus na pigkalabuwan adti krus. ");
INSERT INTO klg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wala' da sakanan asini, kay nyataw da kasiling na piglong nan idtu muna! Seled kamu aw inunuwa mayu ya pigpakulangan kanan. ");
INSERT INTO klg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aw kaksay kamu panaw aw ubati mayu ya manga umagakan nan na nyataw da sakanan lekat adti pagkamatay. Nyuna la sakanan adti Galiliya aw dun da mayu kita-a. Dili' mayu pagkalingawan ya piglong ku kamayu.” ");
INSERT INTO klg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yanagaw maksay silan nyalaguy lekat adti lebeng, aw pangkay nyallek silan manang to-o uman silan migleya. Aw dyumalagan silan pasinan adti manga umagakan nan kay un nilan ubat-ubatan. ");
INSERT INTO klg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aw bigla' migpakita' si Jisus kanilan dun ni dalan, aw miglong sakanan, “Ya kalinaw gayed magad kamayu!” Aw dyumulud silan aw pig-awidan nilan ya siki nan aw pigsimba nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pagkatigkas yan, miglong si Jisus kanilan, “Dili' kamu magkallek! Ubati mayu ya manga inulug ku na madtu silan ni Galiliya aw dun da aku nilan kita-a.” ");
INSERT INTO klg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sa pagpanaw da na manga ka͡ubayan, ya eped na manga sundalu na migtunggu' sa lebeng lyumiku' silan adti syudad aw pig-ubat-ubat nilan adti manga mangkatas na magdadugsu-ay ya kadég na nyangka-imo' dun. ");
INSERT INTO klg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yanagaw migkatipun da uman ya manga mangkatas na magdadugsu-ay aw ya manga magdadumala͡ay sa manga Judiyu, aw pigka-unawa͡an nilan na atagan nilan na dakula' na kuwalta ya manga sundalu pada dili' nilan ubat-ubat ya matinaw, ");
INSERT INTO klg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aw piglongan nilan, “Yeiy ya ubat-ubat mayu sa manga utaw: ‘Talana nami nyampakatulug na gabi yan, dyumateng ya manga umagakan nan aw pigtakaw nilan ya lawas ni Jisus.’ ");
INSERT INTO klg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kun dengegen na gubirnador ya ubat-ubat mayu, kami la ya magbalawbalaw kanan pada dili' kamu nan kadamanan.” ");
INSERT INTO klg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pigdawat nilan ya kuwalta aw pigdalug nilan ya kadég na piglong kanilan. Aw taman adun, yeiy ya kasampetanen na gayed pigsalut-salut na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na, ya sampulu' taggesya' ya umagakan ni Jisus, nyadtu silan ni buntud na awun ni Galiliya na yan ya piglong nan kanilan. ");
INSERT INTO klg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aw sa pagkita' nilan kanan, pagsimba nilan sakanan. Manang awun manga eped kanilan na migduwaduwa kun yan si Jisus aw ya beke'. ");
INSERT INTO klg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pagkatigkas yan, dyumulud si Jisus kanilan aw miglong sakanan, “Pig-atag da adi kanak ya katundanan na magdumala sa kadég na awun ni tas na langit aw sa kadég na asini tas na lupa'. ");
INSERT INTO klg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yanagaw kadtuwi mayu ya kadég na manga banwa aw imo-a mayu ya manga utaw na kanak manga umagakan, aw ba͡utismuwi mayu silan dun ni ngalan na Ama, aw Ise', aw Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aw palna-uwi mayu silan na imo-un nilan ya kadég na pigsugu' ku kamayu. Aw dili' mayu pagkalingawan na gayed ta kamu agad-agadan kada allaw menda' na malingeb da ya kadég adti kamoliyan na allaw.”");
INSERT INTO klg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Yéiy ya Madyaw na Ubat-ubat kan Jisu-Kristu na Ise' na Tyumanem. Ya pag-ubat-ubat seiy, migpalekat asini muna kasiling na pigpasulat na Tyumanem sa propita nan na si Isayas, kay dun ni pigsulat nan miglong ya Tyumanem adti Ise' nan: “Un ku pa-una͡en kanmu ya kanak mag-ubat-ubatay pada tagilanen nan ya un mu agiyan. ");
INSERT INTO klg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Magtatawag sakanan adti kaligbinan, aw yeiy ya un nan paglongun: ‘Tagilana mayu ya un agiyan na kanaten Tyumanem! Pakadyawa mayu ya dalan na un nan agiyan!’ ” ");
INSERT INTO klg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nyatuman yeiy dun ni pagkadtu ni Juan na Magba͡utismuway adti kaligbinan, aw pig-ubat-ubat nan na magpaba͡utismu ya manga utaw aw magselsel silan pada lanasen na Tyumanem ya kanilan manga sala'. ");
INSERT INTO klg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aw nyadtu ni kan Juan ya madég na manga utaw na lekat adti kadakula' na Judiya aw Jérusalim. Aw pig-ubat nilan ya kanilan manga sala' adti Tyumanem aw pigba͡utismuwan silan ni Juan dun ni tubig na Jordan. ");
INSERT INTO klg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, ya pigsut ni Juan pig-imo' lekat adti bulbul na kamilyo, aw ya elen nan uman lekat adti kindal na baka. Aw ya kanan pagkanen, yan ya dulun aw dega'. ");
INSERT INTO klg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aw yeiy ya pig-ubat-ubat ni Juan: “Awun pa sambuk na makamoli kanak na to-o pa matas, aw dili' aku makatumbuk kanan. Pangkay ya pag-ubad sa eket na sandal nan dili' aku umba'. ");
INSERT INTO klg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aku ya magba͡utismu kamayu magi sa tubig, manang ya un dumateng, yan ya magba͡utismu kamayu sa Ispiritu Santo.” ");
INSERT INTO klg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Talana ni Juan migba͡utismu sa manga utaw dun ni tubig na Jordan, dyumateng si Jisus lekat adti Nasarit sakup na Galilya, aw migpaba͡utismu sakanan kan Juan. ");
INSERT INTO klg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aw sa pagtaklang da ni Jisus lekat adti tubig, kyinita' nan na nyabeka' ya langit aw ya Ispiritu Santo na lyumugsad adti kanan kasiling na kalupati. ");
INSERT INTO klg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aw awun tingeg na lekat adti tas na langit na miglong, “Ikaw ya Ise' ku na to-o ku pigginawa͡an, aw to-o aku kyatutukan kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aw maksay si Jisus pigpa-agad na Ispiritu Santo adti kaligbinan na laganasen, ");
INSERT INTO klg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","aw adtu sakanan seled na kapatan ya allaw, aw gayed pigtanda' ni Satanas. Aw awun manga ayep na iyalas dun, aw pigsanggila' na manga anghil si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, pagkatigkas na pagkalabusu kan Juan, wala' kadugay nyuli' si Jisus adti Galilya. Aw pigpa-ede' nan ya Madyaw na Ubat-ubat na lekat adti Tyumanem, ");
INSERT INTO klg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","law nan, “Nyatuman da ya piglong na manga propita asini muna. Ya Paghari' na Tyumanem sa Kasakupan nan malapit da. Yanagaw pagselsel kamu aw pangintu-uwi mayu ya Madyaw na Ubat-ubat!” ");
INSERT INTO klg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na, sambuk na allaw, nyanaw si Jisus adti baklayan na Danaw na Galilya, aw kyinita' nan si Simon aw ya inulug nan na si Andrés na nyamiyala kay mangisda-ay saba silan. ");
INSERT INTO klg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aw miglong si Jisus kanilan, “Agad kamu kanak, kay imo-un ta kamu mangisda-ay sa manga utaw!” ");
INSERT INTO klg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aw maksay nilan pig-ayawan ya manga biyala nilan aw nyagad silan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Migpadeleg silan nyanaw adti baklayan, aw kyinita' uman ni Jisus si Santiago aw ya inulug nan na si Juan na alag ise' ni Zibidiyo. Dun silan ni kanilan balangay mig-uman sa manga biyala. ");
INSERT INTO klg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aw maksay nan pigtawag na magad silan kanan. Aw pig-ayawan nilan ya kanilan ama aw ya manga magtalabahuway dun ni balangay, aw nyagad silan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aw nyadtu silan ni lunsud na Kapirna-um. Pagdateng na Allaw na Paglagdeng, syumeled si Jisus adti sinagoga aw migpalekat migpalna-u sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aw ya kadég na dyumengeg sa palna-u nan, alag silan nya-enneng-enneng kay awun katulus na kanan pagpalna-u aw dili' kasiling na pagpalna-u na kanilan manga magpalna-uway sa Uldin. ");
INSERT INTO klg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na, dun ni sinagoga awun sambuk na eseg na pigseledan na busaw. Aw to-o sakanan mig-ulangag, ");
INSERT INTO klg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","law nan, “Kay Jisus na taga Nasarit, unu ya tud mu kanami? Unu, nyadi kaw na un apnasen ya kadég nami? Pigkilala ta kaw! Ikaw saba ya Pigpadala na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Manang pigsagda ni Jisus ya busaw, law nan, “Katinep kaw aw luwa' kaw dun ni kanan!” ");
INSERT INTO klg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aw pigpatakig to-o na busaw ya utaw, aw mig-ulangag aw lyumuwa' ya busaw. ");
INSERT INTO klg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aw ya kadég na manga utaw dun, alag silan nya-enneng-enneng. Aw migpan-usip-usipay silan, law nilan, “Unu yeiy? Bagu na palna-u? Awun katulus nan magsugu' sa manga busaw aw pagka͡agadan nilan sakanan!” ");
INSERT INTO klg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yanagaw maksay nyabekkal ya pig-imo' ni Jisus dun ni banwa na Galilya. ");
INSERT INTO klg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pagkatigkas yan, maksay si Jisus nyindeg aw ya manga eped nan adti sinagoga dala si Santiago aw si Juan, aw nyadtu silan adti balay ni Simon aw ni Andrés. ");
INSERT INTO klg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pagdateng nilan dun, maksay nilan pig-ubatan si Jisus na kyedelan ya ugangan ni Simon na ka͡ubayan, aw gayed sakanan kyumulang asuntu na to-o migkapasu'. ");
INSERT INTO klg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yanagaw, migpalapit si Jisus adti kanan aw pig-awidan nan ya bekten aw pigbangun nan. Aw dayaw pig-uwasan sa kapasu' nan, aw pagkatigkas yan, pigsanggila' nan silan. ");
INSERT INTO klg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagsallep da na sega, pigpandala adti kan Jisus ya kadég na kyedelan aw manga utaw na syeledan na busaw. ");
INSERT INTO klg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aw madég ya manga utaw na taga Kapirna-um na migkatipun adti gisakan na balay. ");
INSERT INTO klg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yanagaw pigpangguli' nan ya madég na punganan na manga magkedel, aw pig-alilinan nan uman ya madég na busaw na syumeled adti manga utaw. Aw wala' ni Jisus tumbayan na maglong ya manga busaw kay kya-ede-an da nilan kun singalan sakanan. ");
INSERT INTO klg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na, pagkamaselem da, to-o nyaselem si Jisus migbangun aw migpasinan sakanan adti kaligbinan aw nyanawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aw pigpaninaw ni Simon aw manga eped nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aw sa pagkita' nilan kanan, law nilan, “Ya kadég na manga utaw alag nyaninaw kanmu!” ");
INSERT INTO klg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Manang miglong si Jisus kanilan, “Madtu kitadun adti manga lunsud na malapit asini, pada pa-ede-en silan sa Madyaw na Ubat-ubat, kay yeiy ya du-an na pigpadala aku asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aw piglegeb ni Jisus ya banwa na Galilya, aw gayed migpalna-u adti manga sinagoga na manga Judiyu. Aw pig-alilinan nan ya manga busaw na syumeled adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na, awun eseg na ibungun na dyumulud kan Jisus. Lyumuhud sakanan aw to-o nyanginayu', law nan, “Kay Sir, kun malim kaw, guli-a beg ya ibung ku, pada kalinisan da ya lawas ku.” ");
INSERT INTO klg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aw to-o si Jisus nyallat kanan. Yanagaw, pig-awidan nan ya eseg yan aw miglong, “Kaliman ku saba. Kalinisan da kaw!” ");
INSERT INTO klg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aw dayaw nyalanas ya kanan ibung, aw kyalinisan da ya lawas nan. ");
INSERT INTO klg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tigkas yan, maksay sakanan pigpapanaw ni Jisus aw piglongan nan, ");
INSERT INTO klg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ya-i pag-ubatan adti pangkay singalan utawa ya nya-imo' kanmu adun! Manang kadtu kaw baling ni Témplo aw patanawan ya lawas mu adti magdadugsu-ay, aw yan ya magmatinaw na nyaguli' da ya ibung mu. Aw dala͡en mu kanan ya umba' na pagdugsu' na pigsugu' ni Moysis, pada ka-ede-an na manga utaw na kyalinisan da kaw.” ");
INSERT INTO klg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Manang sa pagpanaw da nan, pig-ubat nan adti madég na utaw ya nya-imo' kanan, yanagaw nyabekkal baling ya ubat-ubat kanan. Aw yan ya du-an na wala' si Jisus pakaseled adti manga lunsud aw adtu pa sakanan pag-eya' ni kaligbinan. Aw pangkay nyeya' sakanan dun, manang kenne' na manga utaw adti eped na manga banwa nyadtu ni sayid nan. ");
INSERT INTO klg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paglabay da na pilangallaw, lyumiku' si Jisus adti lunsud na Kapirna-um. Aw nyabekkal ya ubat-ubat na awun da sakanan ni balay na pagbantukan nan. ");
INSERT INTO klg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wala' kadugay, migkatipun ya madég na manga utaw adti balay menda' na wala' da silan kasa aw gayed da silan mig-insek pangkay adti gisakan. Aw pig-ubat-ubatan silan ni Jisus sa tingeg na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Talana nan mig-ubat-ubat, awun upat ya eseg na dyumateng na migtingga sa pulid pada dala͡en adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Manang asuntu sa kadég na utaw, wala' silan pakapalapit adti kan Jisus. Yanagaw piggawangan nilan ya atep dun ni tas ni Jisus, aw pigtonton nilan adti dalem ya pigpakulangan sa pulid. ");
INSERT INTO klg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kyinita' ni Jisus ya kadakula' na pagpangintu-u nilan, yanagaw piglongan nan ya pulid, “Kay Lew, ya manga sala' mu adti Tyumanem, piglanas da.” ");
INSERT INTO klg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, awun uman manga magpalna-uway sa Uldin na nyingkud dun. Pagdengeg nilan sa piglong ni Jisus, mig-anenganeng silan, ");
INSERT INTO klg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ananga' maglong sa maynan ya utaw yeiy? Migpa-unawa sakanan sa Tyumanem! Ya Tyumanem saba olo' ya makalanas sa manga sala'!” ");
INSERT INTO klg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Manang maksay ni Jisus kya-ede-an ya pig-anenganeng nilan, yanagaw piglongan nan silan, “Ananga' kamu mag-anenganeng sa maynan? ");
INSERT INTO klg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ayin ka' ya molas paglongun adti eseg na pulid, ‘Ya manga sala' mu nyalanas da,’ aw kun paglongun sakanan, ‘Pagbangun kaw. Dala͡a ya pigtingga͡an nilan kanmu aw panaw da kaw’? ");
INSERT INTO klg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Manang matinawun ku adti kamayu na ya Ise' na Utaw awun katundanan nan maglanas sa manga sala' na manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tigkas yan, miglong si Jisus adti eseg na pulid, “Pagbangun kaw. Dala͡a ya pigtingga͡an nilan kanmu aw uli' da kaw!” ");
INSERT INTO klg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aw dun ni asdangan na manga utaw, migbangun ya eseg aw maksay nan pigdala ya pigtingga͡an kanan aw nyanaw da sakanan. Aw to-o nya-enneng-enneng ya manga utaw, aw pigdeyen nilan ya Tyumanem, aw law nilan, “Wala' pa tadun kita-a ya kasiling na maynini!” ");
INSERT INTO klg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na, lyumiku' da uman si Jisus adti baklayan na danaw. Madég ya manga utaw na dyumulud kanan, aw pigpalna-uwan nan silan. ");
INSERT INTO klg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatigkas yan, nyanaw si Jisus lekat dun, aw kyinita' nan si Libi na ise' ni Alpiyo na nyingkud adti bayadanan sa buwis. Miglong si Jisus kanan, “Agad kaw kanak.” Aw nyindeg si Libi aw nyagad kanan. ");
INSERT INTO klg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wala' kadugay, migpa-imo' si Libi sa dakula' na kakan adti balay nan. Kyuman dun si Jisus aw ya kanan manga umagakan. Aw dun uman ya madég na manga mangungubla͡ay sa buwis aw ya eped pa na manga makasasala' kay madég da ya dyumalug kanan. ");
INSERT INTO klg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dun uman ya eped na manga Parisiyo na magpalna-uway sa Uldin. Aw sa pagkita' nilan na syumambuk si Jisus kyuman sa manga utaw yeiy, pig-usip nilan ya manga umagakan ni Jisus, “Ananga' sakanan sumambuk kuman sa manga mangungubla͡ay sa buwis aw sa manga utaw na makasasala'?” ");
INSERT INTO klg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aw sa pagdengeg ni Jisus sa piglong nilan, pigtubag nan silan magi sa pundinganan, law nan, “Ya manga utaw na mangkadyaw ya lawas, dili' nilan ka-ilangan ya doktor. Manang ya manga utaw na awun magkedel, silan ya awun ka-ilangan sa doktor. Ya pigkadi ku asini tas na lupa', yan ya pagtawag sa manga utaw na nyaka-ede' sa manga sala' nilan, pada magselsel silan aw dumalug kanak. Manang ya manga utaw na iman nilan aw wala' ya kanilan sala' adti Tyumanem, beke' nilan ya pigtawag ku.” ");
INSERT INTO klg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na, migpuwasa ya manga umagakan ni Juan na Magba͡utismuway aw migpuwasa uman ya manga Parisiyo. Yanagaw, awun manga utaw na dyumulud kan Jisus aw nyusip kanan, “Ananga' migpuwasa ya umagakan ni Juan aw ya umagakan na manga Parisiyo, manang ya kanmu umagakan, wala' silan pagpuwasa?” ");
INSERT INTO klg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aw tyumubag si Jisus kanilan magi sa pundinganan, law nan, “Kun awun kasal, dili' magpuwasa ya manga tyumambung kay migleya silan talana na kenne' pa dun ni sayid nilan ya eseg na magpanamung. ");
INSERT INTO klg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Manang dumateng ya allaw na kamangen sakanan lekat adti kanilan, aw dun ni allaw yan, magpuwasa la silan.” ");
INSERT INTO klg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aw migpadeleg pa si Jisus miglong magi sa pundinganan, law nan, “Kasiling uman na kadégkadég, ya bagu na téla dili' pagleneb adti dadan na téla na malungu la. Kay kun maleneb da aw gayed bugsakan, dili' madugay kumeteng ya bagu aw to-o la baling magkadakula' ya kakisayan. ");
INSERT INTO klg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aw maynan uman, wala' ya utaw na mag-asag sa bagu na bino adti dadan na betanganan na pig-imo' lekat adti kindal na ayep. Kay kun asag ya bino dun ni dadan na betanganan aw sumubuk, mutu ya betanganan, aw masapad ya bino, aw magkalat baling ya betanganan. Manang ya bagu na bino, pag-asag adti bagu na betanganan na kindal na ayep.” ");
INSERT INTO klg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sambuk na Allaw na Paglagdeng, nyanaw si Jisus aw ya kanan manga umagakan dun ni dalan na nyaka-agi adti tenga' na pawa' na awun trigu na agpet da aniyen. Talana nilan nyanaw, nyanaplus ya umagakan nan sa trigu aw pigtebteb nilan. ");
INSERT INTO klg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aw piglongan na manga Parisiyo si Jisus, “Inunuwa ya pig-imo' na manga umagakan mu! Kyalakadan nilan baling ya Uldin! Wala' saba tumbayan adti Allaw na Paglagdeng ya pag-ani!” ");
INSERT INTO klg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Manang tyumubag si Jisus kanilan, “Unu, wala' pa ka' mayu kabasa ya pigpasulat na Tyumanem asini muna sa pig-imo' ni Dabid? Sa pagkagetem nan aw manga eped nan kay wala' ya un nilan kanen, ");
INSERT INTO klg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","syumeled sakanan adti Balay na Tyumanem dengan na si Abi-atar ya pangulu na manga magdadugsu-ay. Aw pigkan ni Dabid ya pan na pig-atag da adti Tyumanem, aw pig-atped-atped nan uman ya manga eped nan, pangkay yan saba olo' ya makakan ya manga magdadugsu-ay. Aw dun da baling nilan kalakadi ya Uldin.” ");
INSERT INTO klg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aw piglongan pa silan ni Jisus, “Ya Allaw na Paglagdeng pig-imo' pada sa manga utaw. Wala' imo-a ya utaw pada sa Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yanagaw, pig-atag da adti Ise' na Utaw ya pagbaya' sa unu ya madyaw imo-un sa Allaw na Paglagdeng.” ");
INSERT INTO klg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na, lyumiku' si Jisus syumeled adti sinagoga, aw dun ya sambuk na eseg na kimay ya sangkilid na bekten nan. ");
INSERT INTO klg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aw awun manga Parisiyo na gayed nyakatanaw sa un imo-un ni Jisus, kun guli-en nan ya bekten na utaw dun ni Allaw na Paglagdeng, pada awun puliba nilan maglimanda kanan. ");
INSERT INTO klg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aw pigtawag ni Jisus ya eseg na kimay, law nan, “Adi kaw aw indeg kaw asini asdangan na kadég na utaw.” ");
INSERT INTO klg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tigkas yan, pig-usip nan ya manga Parisiyo, “Adti Uldin tadun na pig-atag na Tyumanem, unu ya pigtumbay na imo-un dun ni Allaw na Paglagdeng, ya pag-imo' sa madyaw aw ya pag-imo' sa malatay? Aw ya pagpaluwa' sa utaw lekat adti pagti-is, aw kun kalaten baling sakanan?” Manang wala' silan tubag kanan. ");
INSERT INTO klg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pig-inunu ni Jisus ya kadég nilan aw nyadaman sakanan. Aw migkalat uman ya ginawa nan asuntu sa kategelan nilan. Tigkas yan, piglongan nan ya eseg na kimay, “Ulada ya bekten mu.” Aw sa pag-ulad nan sa kanan bekten, dayaw migkadyaw. ");
INSERT INTO klg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pagkatigkas yan, lyumuwa' ya manga Parisiyo aw maksay silan migpalpa eped ya partido ni Hérodés, kun unun nilan ya pagpapatay kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jisus aw ya kanan manga umagakan, nyadtu silan adti baklayan na danaw. Aw dyumalug kanilan ya to-o madég na utaw na lekat dun ni Galilya aw adti Judiya. ");
INSERT INTO klg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aw awun uman lekat adti syudad na Jérusalim, aw banwa na Iduméya. Aw ya manga eped lekat adti dipag na tubig na Jordan, aw adti nyakapalibed sa manga syudad na Tiro aw Sidon. Kay dyengeg nilan ya kadég na pigpan-imo' ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Asuntu na madég to-o ya utaw, piglongan nan ya kanan manga umagakan na magtagilan sa balangay na un nan ka-ingkudan pagaw ma-insek sakanan na madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kay madég ya pigpangguli' ni Jisus na pyangkedelan, yanagaw ya eped na awun magkedel, gayed silan mig-insekay kay kaliman nilan na maka-awid kanan. ");
INSERT INTO klg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aw kun kita-en sakanan na utaw na pigseledan na busaw, lumebleb silan dun ni asdangan nan, aw mag-ulangag na maglong, “Ikaw ya Ise' na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Manang piglongan ni Jisus ya manga busaw, “Dili' kamu mag-ubat-ubat adti manga eped kun singalan aku!” ");
INSERT INTO klg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatigkas yan, tyumukud si Jisus adti buntud aw pigtawag nan ya kaliman nan pa-agad, aw migpalapit silan kanan. ");
INSERT INTO klg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aw pigpamalli' ni Jisus ya sampulu' tag duwa na un magad kanan aw pigtawag nan silan na apostolés, kay un silan padala pada mag-ubat-ubat, ");
INSERT INTO klg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aw pig-atagan nan silan na katulus mag-alilin sa manga busaw. ");
INSERT INTO klg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, ini ya sampulu' tag duwa na pigpamalli' ni Jisus: Si Simon na pigngalanan nan na Pédro, ");
INSERT INTO klg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aw si Santiago aw ya inulug nan na si Juan na alag ise' ni Zibidyo, aw pagtawagen silan duwa ni Jisus na Bo-anérgés, na ya kakawasan: mangayse' na dadaneg. ");
INSERT INTO klg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pigpamalli' nan uman si Andrés, si Pilipi, si Baltolomé, si Matiyo, si Tomas, si Santiago na ise' ni Alpiyo, si Tadiyo, si Simon na Kananiyo, ");
INSERT INTO klg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aw si Judas Iskariyoti. Si Judas yeiy, yan ya miglubid kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatigkas yan, lyumiku' si Jisus aw manga eped nan adti balay. Wala' kadugay, migkatipun da uman dun ya madég na utaw, yanagaw wala' pakaselat si Jisus aw manga eped nan pakakan. ");
INSERT INTO klg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aw sa pagdengeg na pamilya ni Jisus sa manga pigpan-imo' nan, nyadtu silan kay un nilan sakanan angayen, kay miglong ya manga utaw na migkameneng sakanan. ");
INSERT INTO klg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Awun uman manga magpalna-uway sa Uldin na dyumateng lekat adti Jérusalim. Miglong silan adti manga utaw, “Ya utaw yeiy pigseledan ni Bilsibul! Pig-alilinan nan saba ya manga busaw magi sa katulus na pangulu na manga busaw.” ");
INSERT INTO klg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yanagaw pigtawag silan ni Jisus aw piglongan nan magi sa pundinganan, “Dili' mabatug ni Satanas ya pag-alilin sa manga kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ya kasakupan na nyatenga-tenga', dili' yan makapadeleg na madugay. ");
INSERT INTO klg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Maynan uman ya ka-epedanan dun ni balay na awun pagkatenga-tenga'. ");
INSERT INTO klg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aw kun si Satanas tanamen nan ya kanan manga kasakupan, dili' saba magpadeleg ya pagdumala nan aw magkalat baling ya kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Si Satanas kasiling na utaw na to-o mabagseg na tagtun sa balay. Wala' ya pangkay sambuk na makaseled adti balay nan pada takawun ya kanan ka-unan kun dili' una gapusun ya tagtun. Manang kun magapus da ya tagtun, mabatug da kamangen ya manga ka-unan nan. ");
INSERT INTO klg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Matinaw ya un ku paglongun kamayu: Pangkay unu ya sala' mayu adti Tyumanem aw pangkay unu ya paglongun mayu na malatay adti kanan, mabatug lanasen ya manga sala' mayu. ");
INSERT INTO klg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Manang ya utaw na maglong sa malatay adti Ispiritu Santo, yan ya sala' na dili' mabatug lanasen. Aw ya sampetan na sala' yeiy, pa-emel-emelen na Tyumanem na wala' ya tyamanan.” ");
INSERT INTO klg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Piglong yeiy ni Jisus adti manga magpalna-uway sa Uldin kay miglong silan, “Pigseledan sakanan saba na busaw.” ");
INSERT INTO klg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na, dyumateng ya ina ni Jisus aw manga inulug nan, aw nyan-indeg silan adti luwa' aw pigpatawag nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Adti seled na balay, madég ya utaw na nyingkud na nyakapalibed kan Jisus, aw miglong silan kanan, “Awun ni luwa' ya ina mu aw manga inulug mu. Pyaninaw kaw nilan.” ");
INSERT INTO klg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aw tyumubag si Jisus kanilan, “Awun pa saba uman pigsiling ku na kanak ina aw kanak manga inulug.” ");
INSERT INTO klg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aw pig-inunu nan ya manga utaw na nyingkud na nyakapalibed kanan, aw law nan, “Inunuwa mayu! Ya manga utaw ini, silan uman ya kanak ina aw kanak manga inulug! ");
INSERT INTO klg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pangkay singalan ya mag-imo' sa pagkaliman na Tyumanem, silan ya kanak manga inulug aw manga bubay aw ina ku.” ");
INSERT INTO klg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na, migpalna-u la uman si Jisus adti baklayan na danaw. Aw kyalimpungan sakanan na madég to-o na utaw na un magpakanyeg kanan. Yanagaw mig-alin si Jisus adti balangay na malapit dun ni baklayan aw nyingkud sakanan dun. Aw nyan-indeg ya manga utaw dun ni baklayan. ");
INSERT INTO klg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aw madég ya pigpalna-u nan kanilan magi sa manga pundinganan, law nan, ");
INSERT INTO klg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pakanyegi mayu ya un ku paglongun! Awun sambuk na utaw na nyadtu ni pawa' nan na un magsabug sa manga bini'. ");
INSERT INTO klg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa pagsabug nan sa manga bini', awun eped na nyakasabug adti kilid na dalan. Aw nyangkawun ya manga langgam aw pyanubug nilan ya manga bini'. ");
INSERT INTO klg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aw awun manga eped na nyakasabug adti kabatuwan aw maksay gyumiti' kay wala' abay ya lupa'. ");
INSERT INTO klg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Manang pagsilat na sega, nyangkalanes baling ya manga tanem kay wala' to-o pakadalid. ");
INSERT INTO klg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ya eped na manga bini' nyakasabug adti magalet na suksukun. Gyumiti' ya manga bini', manang asuntu na tyumulin uman ya magalet, nyalemes baling ya manga tanem aw wala' pakabunga. ");
INSERT INTO klg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Manang ya manga bini' na nyakasabug adti mataba' na lupa', tyumulin aw to-o nyamunga. Awun nyunga na tag katluwan, aw awun nyunga na tag ka͡eneman, aw awun nyunga na tag sanggatus.” ");
INSERT INTO klg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aw miglong pa si Jisus kanilan, “Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sa pag-uli' da na madég na utaw, awun pa nyasama' kanilan eped na sampulu' tag duwa ya umagakan ni Jisus, aw nyusip silan kanan kun unu ya kakawasan na pundinganan nan. ");
INSERT INTO klg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aw miglong si Jisus kanilan, “Pigtumbay da kamayu na Tyumanem ya pagka-ede' sa pigtagu' idtu muna sa Kasakupan na Pighari-an nan. Manang adti manga eped, pig-ubat-ubat adti kanilan magi sa manga pundinganan ");
INSERT INTO klg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","pada matuman adti manga utaw yeiy ya dadan da na Tyumanem pigpasulat adti propita nan, law nan, ‘Pangkay gayed nilan inunuwun manang dili' nilan kita-en. Aw pangkay gayed nilan dengegen, manang dili' nilan kalabetan ya kakawasan. Kun kalabetan nilan, pagaw magselsel silan aw lanasen ya manga sala' nilan.’ ” ");
INSERT INTO klg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Miglong si Jisus kanilan, “Unu, wala' mayu kalabeti ya pundinganan yeiy? Na, kun maynan, unun mayu ya pagpakalabet sa eped na manga pundinganan ku? ");
INSERT INTO klg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ini ya kakawasan na pundinganan sa manga bini': Ya bini' na pigsabug na utaw, yan ya tingeg na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Ya kilid na dalan na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg da sa tingeg na Tyumanem manang maksay dyumateng si Satanas aw pigdampas nan ya pigdengeg nilan. ");
INSERT INTO klg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Aw ya kabatuwan na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg sa tingeg na Tyumanem aw maksay nilan pigdawat na awun pagleya ");
INSERT INTO klg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","manang dili' to-o makadalid ya pagpangintu-u nilan. Kun awun dumateng na manga kalugan aw manga pagpamulayam asuntu sa tingeg na Tyumanem na dyengeg nilan, maksay nilan ayawan ya kanilan pagpangintu-u. ");
INSERT INTO klg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Aw ya manga magalet na suksukun na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg da sa tingeg na Tyumanem ");
INSERT INTO klg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","manang ya kanilan anenganeng nyatmu' na kakaypengan sa pagpakabetang nilan, aw sa pag-anenganeng na ma-imo' mayaman, aw sa manga pagkaliman nilan asini tas na lupa'. Aw ya sampetan yan, dili' makabunga ya pagpangintu-u nilan. ");
INSERT INTO klg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Manang ya mataba' na lupa' na kyasabugan sa manga bini', yan ya manga utaw na migpakanyeg sa tingeg na Tyumanem aw pigdawat nilan. Aw mamunga silan sa madég. Ya sambuk mamunga na katluwan, aw ya eped ka͡eneman, aw ya eped sanggatus.” ");
INSERT INTO klg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Miglong pa si Jisus kanilan, “Unu ka', magsulu' ya utaw sa salengan pada sangkuban nan na be-en? Dili' saba! Aw dili' nan uman betang adti dalem na katri. Manang betang nan saba adti bantawanan. ");
INSERT INTO klg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ya kakawasan na pundinganan yeiy: Wala' saba ya nyatagu' na dili' kabukasan, aw ya kadég na wala' pa kalabeti idtu muna, dili' madugay kalabetan da. ");
INSERT INTO klg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Miglong pa uman si Jisus, “To-o pakanyegi ya un ku paglongun kamayu! Kay kun matibulluk kamu magpakanyeg, to-o pa dakula' ya kalabetan mayu, aw dugangan pa na Tyumanem ya kamayu kya-ede-an. ");
INSERT INTO klg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kay ya utaw na dyumalug sa pigpalna-u kanan sa kana Tyumanem, dugangan pa ya kyalabetan nan. Manang ya utaw na wala' dalug sa palna-u yan, kamangen baling adti kanan anenganeng ya pangkay tagbi' na kyalabetan da nan.” ");
INSERT INTO klg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Miglong pa si Jisus, “Ya Kasakupan na Pighari-an na Tyumanem, kasiling na maynini: Awun utaw na migsabug sa manga bini' adti kanan pawa'. ");
INSERT INTO klg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagkagabi makatulug sakanan aw pagka-allaw magbangun uman. Aw ya manga bini' na pigsabug nan, tyumulin aw wala' nan ka-ede-i kun pig-unu na manga bini' ya pagtulin. ");
INSERT INTO klg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ya lupa', yan ya magpatulin sa tanem. Una mandagem, aw tigkas yan lumawas, aw mameles, aw tigkas yan maniswak da. ");
INSERT INTO klg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aw pagka-inug da na bunga nan, galaben da na tagtun kay umba' da saba aniyen.” ");
INSERT INTO klg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Migpadeleg si Jisus miglong, “Unu pa ya un tadun kapa-unawa͡an sa Kasakupan na Pighari-an na Tyumanem? Unu ya pundinganan na gamiten tadun? ");
INSERT INTO klg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ya kasakupan nan kasiling na sambuk na bini' na mustardo. Yan ya to-o tagbi' na bini', ");
INSERT INTO klg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","manang kun matanem aw tumulin, matas pa yeiy sa eped na manga tanem. Mabakla' ya manga sanga nan aw umba' kapugadan na manga langgam.” ");
INSERT INTO klg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Madég pa ya manga pundinganan na piggamit ni Jisus dun ni kanan pagpalna-u kanilan na umba' nilan kalabetan. ");
INSERT INTO klg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wala' nan silan palna-uwi na beke' na magi sa pagpundinganan. Manang kun olo' silan ya kanan manga umagakan, pigbangal nan ya kadakula' na kakawasan na manga pundinganan. ");
INSERT INTO klg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na, pagsallep da na sega, miglong si Jisus adti manga umagakan nan, “Naten tumalipag sa danaw!” ");
INSERT INTO klg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pig-ayawan nilan ya madég na utaw adti baklayan, aw syumakay silan sa balangay na pigsakayan da ni Jisus. Aw awun manga eped na balangay na dyumengan kanilan. ");
INSERT INTO klg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Talana nilan dun ni tenga-tenga' na danaw, wala' nilan imanmana bigla' dyumateng ya to-o mabandes na samet, aw syalampawan na manga baled ya balangay nilan aw un da matmu' na tubig. ");
INSERT INTO klg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Manang nyakatulug si Jisus apit adti moli na balangay na dayaw migkama. Aw pigpukaw sakanan na manga umagakan nan, law nilan, “Kay Magpalna-uway! Wala' kaw kaypeng na un da kitadun malened aw mangkamatay?” ");
INSERT INTO klg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yanagaw migbangun si Jisus, aw piglongan nan ya samet aw manga baled, “Tangke' kamu!” Aw tyumeneng ya samet aw migkalinaw da ya danaw. ");
INSERT INTO klg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aw piglongan silan ni Jisus, “Ananga' kamu mangkallek? Tay, sa katagbi' na pagsalig mayu kanak!” ");
INSERT INTO klg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","To-o silan nyangkallek aw mig-usip-usipay silan, “Singalan ka' ya utaw yeiy? Pangkay ya samet aw ya manga baled magka͡agad sa sugu' nan!” ");
INSERT INTO klg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na, dyumateng si Jisus aw ya manga umagakan nan adti dipag na danaw, dun ni banwa na pig-eya-an na manga taga Girasa. ");
INSERT INTO klg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Talana ni Jisus nyanog lekat adti balangay, awun eseg na syumungun kanan. Ya eseg yeiy pigseledan na busaw ");
INSERT INTO klg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","aw nyeya' adti ilib na yan ya paglebengan sa manga nyangkamatay. Aw dili' da sakanan pagkatagenan pangkay kun eketan pa na sangkali'. ");
INSERT INTO klg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Malikit da pagsangkali-an ya manga bekten aw siki nan, manang pagpamugtu-un nan. Aw pangkay singalan wala' ya makatagen kanan. ");
INSERT INTO klg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allaw aw gabi, maglegeblegeb sakanan adti manga lebeng aw manga buntud. Gayed sakanan mag-ulangag aw pigpali-pali-an nan na batu ya lawas nan. ");
INSERT INTO klg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sa pagkita' na utaw yan kan Jisus adti mawat, nyalaguy sakanan pasinan adti sayid nan aw lyumuhud dun ni asdangan nan. ");
INSERT INTO klg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aw pigsugu' ni Jisus ya busaw na syumeled sa utaw yan, law nan, “Luwa' kaw asini eseg ini!” Aw tigkan mig-ulangag ya eseg, “Kay Jisus na Ise' na Tyumanem na To-o Matas, pabaya-i la aku! Nyanginayu' aku kanmu dun ni ngalan na Tyumanem na dili' aku mu beg pamulayaman!” ");
INSERT INTO klg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aw pig-usip ni Jisus ya busaw, “Singalan ya ngalan mu?” Tyumubag sakanan, “Si Légion, kay to-o kami madég.” ");
INSERT INTO klg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aw gayed sakanan nyanginayu' kan Jisus na dili' nan silan alilinan lekat adti banwa yan. ");
INSERT INTO klg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, awun madég to-o na taku' na nyangaliwad adti kakayaban na malapit dun. ");
INSERT INTO klg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aw nyanginayu' kan Jisus ya manga busaw, law nilan, “Tumbayan beg kanami na sumeled adti manga taku' iyan.” ");
INSERT INTO klg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yanagaw pigtumbay silan ni Jisus. Aw ya kadég nilan lyumuwa' lekat adti eseg yan aw adtu la silan seled ni manga taku'. Aw nyampamalaguy ya kadég na manga taku' lekat adti kakayaban aw kyumawas silan dun ni pangpang adti ligad na danaw. Aw manga duwammalalan ya kadég na taku' na nyabus nyangkalemes. ");
INSERT INTO klg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aw ya manga magdadiyaga͡ay sa manga taku', nyalaguy silan adti lunsud, aw pig-ubat-ubatan nilan ya manga utaw dun ni lunsud aw ya manga nyakapalibed dun. Yanagaw nyangkadtu ya madég na utaw na un magtanaw sa nya-imo'. ");
INSERT INTO klg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagdateng nilan adti kan Jisus, kyinita' nilan ya eseg na pigseledan na busaw idtu muna na migkadyaw da ya anenganeng nan, kay nyingkud sakanan aw migkadégkadég da. Aw to-o silan nyangkallek. ");
INSERT INTO klg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ya manga kyumita' sa kadég na nya-imo' sa eseg yan aw sa manga taku', pig-ubat-ubat nilan uman sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yanagaw nyanginayu' silan kan Jisus na indegan nan ya banwa nilan. ");
INSERT INTO klg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pagsakay da ni Jisus adti balangay, ya eseg na pig-alilinan nan sa manga busaw nyanginayu' kanan, law nan, “Magad aku galu kanmu!” ");
INSERT INTO klg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Manang wala' sakanan pa-agadan ni Jisus. Pigsugu' nan baling, law nan, “Uli' da kaw adti pamilya mu aw ubat-ubati silan sa kadakula' na pig-imo' kanmu na Tyumanem aw sa kallat nan kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yanagaw, nyanaw da ya eseg aw nyadtu ni banwa na pigtawag Dékapolis aw pig-ubat-ubatan nan ya manga utaw sa kadakula' na pig-imo' kanan ni Jisus. Aw nya-enneng-enneng ya kadég na utaw na migpakanyeg kanan. ");
INSERT INTO klg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na, si Jisus aw ya manga umagakan nan syumakay sa balangay aw tyumalipag da uman sa danaw. Pagpakatalipag da nilan, lyumagbet kanan ya madég to-o na manga utaw dun ni baklayan. ");
INSERT INTO klg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aw dyumulud kanan ya sambuk na pagsaligan adti sinagoga na pigngalanan na si Jairus. Aw lyumuhud adti asdangan ni Jisus ");
INSERT INTO klg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aw nyanginayu' sakanan, law nan, “Ya ise' ku na dalagita, to-o kyatigda-an aw kamatayenen da! Manang kya-ede-an ku na kun magad kaw kanak adti balay aw pandungan mu na kanmu palad, kaguli-an aw kamatawan sakanan!” ");
INSERT INTO klg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yanagaw nyagad si Jisus kanan. Aw nyagad uman kanilan ya madég to-o na manga utaw, aw gayed da silan mig-insek malapit dun ni sayid ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, dun ni tenga' na madég na manga utaw, awun sambuk na ka͡ubayan na gayed pigdugu-dugu' seled da na sampulu' tag duwa ya umay. ");
INSERT INTO klg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Madég to-o ya pagti-is na kya-agiyan nan lekat adti pagpabulung nan sa madég na doktor menda' na nyabus ya kuwalta nan, manang wala' sakanan kaguli-i, aw to-o la baling ya bati-enen nan. ");
INSERT INTO klg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dyengeg nan ya pag-ubat-ubat sa manga pigpan-imo' ni Jisus. Yanagaw dyumulud sakanan nyagi dun ni madég na utaw apit adti bagakwang ni Jisus. Aw pig-awidan nan ya kadégkadég ni Jisus, ");
INSERT INTO klg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kay mig-anenganeng sakanan, “Kun ka-awidan ku olo' ya pigsut nan, kaguli-an da aku.” ");
INSERT INTO klg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aw sa pagpaka-awid nan, dayaw tyumeneng ya dugu', aw pigbati' nan na kyaguli-an da sakanan. ");
INSERT INTO klg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aw kya-ede-an ni Jisus na awun katulus na lyumuwa' lekat adti kanan. Yanagaw bigla' nyatubang adti madég na utaw aw nyusip kanilan, “Singalan ya nyawid sa kadégkadég ku?” ");
INSERT INTO klg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aw tyumubag ya manga umagakan nan, “Kyinita' da mu ya kadég na utaw na mig-insek pasinan adti kanmu, yanagaw ananga' kaw musip kun singalan ya nyawid kanmu?’ ” ");
INSERT INTO klg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Manang gayed pyaninaw ni Jisus adti kadég na utaw kun singalan ya nyawid kanan. ");
INSERT INTO klg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Asuntu na kya-ede-an da na ka͡ubayan yan na kyaguli-an da sakanan, migpalapit sakanan adti kan Jisus na to-o tyakigan sa kakallekan nan. Lyumuhud adti asdangan nan aw nyangillupung, aw pig-ubat nan kanan ya tengteng na matinaw sa nya-imo' kanan. ");
INSERT INTO klg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aw miglong si Jisus kanan, “Kay De', asuntu sa pagpangintu-u mu kanak, yan ya nyakaguli' kanmu. Yanagaw uli' kaw na awun da pagkatingen na kanmu anenganeng kay kyaguli-an da kaw.” ");
INSERT INTO klg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sa kenne' pa ni Jisus miglong adti ka͡ubayan yan, awun manga utaw na dyumateng lekat adti balay ni Jairus, aw piglongan nilan sakanan, “Nyapalus da beg ya ginawa na ise' mu! Yanagaw dili' da mu pagpagudun ya Magpalna-uway.” ");
INSERT INTO klg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Manang pigpalipaslipasan ni Jisus ya piglong nilan, aw piglongan nan si Jairus, “Dili' kaw magkallek, pangintu-u la kaw olo'.” ");
INSERT INTO klg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na, wala' ni Jisus tumbayan na awun eped na magad kanan adti balay ni Jairus. Yan olo' ya pigpa-agad nan si Pédro aw si Santiago aw ya inulug ni Santiago na si Juan. ");
INSERT INTO klg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagdateng nilan adti balay, kyinita' ni Jisus ya madég na utaw na migpansimatay. ");
INSERT INTO klg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sa pagseled da nan, pig-usip nan silan, “Ananga' kamu magsasugaway aw magpanmatay? Wala' kamatay ya ise', olo' saba nyakatulug!” ");
INSERT INTO klg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nyaka-ikel baling silan sa piglong nan. Manang pigpaluwa' nan silan adti balay, aw pigpa-agad ni Jisus ya ama aw ina na ise' aw ya tulu ya umagakan nan adti pigpakulangan sa ise'. ");
INSERT INTO klg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tigkas yan, pig-awidan nan ya bekten na ise' aw law nan dun ni kanilan tingeg, “Talita kumi!” Ya kakawasan nan: “Kay Dé', pagbangun kaw!” ");
INSERT INTO klg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aw dayaw migbangun ya ise' aw pagpanawpanaw. Aw to-o silan nya-enneng-enneng. Na, ya ise' yeiy, sampulu' pa tag duwa ya umay nan. ");
INSERT INTO klg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aw piglongan silan ni Jisus, “Ya-i mayu pag-ubat-ubatan ya kyinita' mayu adti eped na utaw!” Aw piglongan nan uman silan na atagan ya ise' na kakan. ");
INSERT INTO klg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagkatigkas yan, pig-indegan ni Jisus ya banwa yan aw nyuli' adti lunsud na Nazarit na yan pigtulinan nan, aw nyagad kanan ya manga umagakan nan. ");
INSERT INTO klg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pagdateng na Allaw na Paglagdeng, migpalekat si Jisus migpalna-u sa manga utaw dun ni sinagoga. Aw madég ya nyakadengeg sa palna-u nan aw to-o silan nyabelengbeleng, aw migsibalawbalaw silan, law nilan, “Ayin lekat ya katadeng na utaw yeiy? Aw pig-unu nan ya pagpaka-imo' sa manga milagru? ");
INSERT INTO klg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Olo' saba sakanan panday asini kanaten, aw ise' sakanan ni Maria. Aw ya manga inulug nan, yan si Santiago, aw si José, aw si Judas, aw si Simon. Aw asini uman pag-eya' ya manga bubay nan!” Asuntu seiy, wala' silan kalim pangintu-u kanan. ");
INSERT INTO klg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aw miglong si Jisus kanilan, “Wala' ya propita na pagdawaten adti kanan banwa aw kanan kadégan, manang pagdawaten baling sakanan adti eped na manga banwa.” ");
INSERT INTO klg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeiy ya du-an na wala' abay ya milagru na nya-imo' nan dun ni kanilan. Tabay ya utaw na pigkaguli-an, taman olo' na pigpandungan nan sa kanan palad. ");
INSERT INTO klg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aw nya-enneng-enneng si Jisus asuntu na wala' silan pangintu-u kanan. Yanagaw piglegeb nan baling ya eped na manga baranggay aw migpalna-u sa manga utaw adtu. ");
INSERT INTO klg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pagkatigkas yan, pigpatawag ni Jisus ya sampulu' tag duwa ya manga umagakan nan aw un nan silan sugu-un na tag duwaduwa. Aw pig-atagan nan silan na katulus na un mag-alilin sa manga busaw na syumeled adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Piglongan nan silan, “Dili' kamu magdala sa pangkay unu. Dili' kamu magdala sa makan aw kabil aw kuwalta. Olo' bangka' ya dala͡a mayu. ");
INSERT INTO klg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pagsandal kamu manang dili' kamu magdala sa manga kadégkadég. ");
INSERT INTO klg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aw ya tagtun sa balay na magpabantuk kamayu, dun da kamu pag-eya' menda' na indegan mayu ya lunsud yan. ");
INSERT INTO klg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Manang kun dili' kamu dawaten na manga utaw adti sambuk na banwa, aw dili' silan malim magpakanyeg sa ubat-ubat mayu, na, sa pag-indeg mayu sa banwa yan, taptapa ya alikabuk na siki mayu, kay yan ya pangilala adti kanilan na ukuman silan na Tyumanem adti kamoliyan na allaw.” ");
INSERT INTO klg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pagkatigkas ni Jisus maglong kanilan, nyanaw ya sampulu' tag duwa aw gayed silan mig-ubat-ubat na ka-ilangan magselsel ya manga utaw sa manga sala' nilan. ");
INSERT INTO klg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mig-alilin silan sa madég na busaw. Aw madég ya manga utaw na kyedelan na pig-asagan nilan na lana na olibo, aw dayaw silan kyaguli-an. ");
INSERT INTO klg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dyengeg na hari' na si Hérodés Antipas ya kadég na pigpan-imo' ni Jisus, kay ya ngalan ni Jisus to-o la migkadengganen. Awun manga utaw na miglong, “Yan si Juan na Magba͡utismuway na nyataw lekat adti pagkamatay. Yan ya du-an na nyaka-imo' sakanan sa manga milagru.” ");
INSERT INTO klg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Awun uman manga eped na miglong, “Yan si Éliyas.” Aw miglong uman ya manga eped, “Propita sakanan na Tyumanem kasiling na manga propita asini muna.” ");
INSERT INTO klg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aw sa pagdengeg ni Hérodés sa madég na pigpan-imo' ni Jisus, miglong sakanan, “Nyataw si Juan na pigpa-utudan ku sa ulu!” ");
INSERT INTO klg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yan ya piglong ni Hérodés, kay idtu muna, pigpadakep nan si Juan aw pigpagapus aw pigpakalabusu. Ya du-an, kay pigpanga͡ubayan ni Herodes si Hérodiyas na ka͡ubayan na inulug nan na si Pilipi, ");
INSERT INTO klg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","aw gayed pigsagda ni Juan si Hérodés na miglong, “Pigpigil saba adti Uldin na manga Judiyu ya pagpanga͡ubayan sa ka͡ubayan na inulug mu.” ");
INSERT INTO klg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yanagaw to-o pigdumutan ni Hérodiyas si Juan, aw pigtibagsegan nan ya pagpapatay kanan, manang wala' nan ka-imo' asuntu na wala' tumbayan ni Hérodés ");
INSERT INTO klg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kay nyallek sakanan kan Juan. Kay kya-ede-an nan na si Juan wala' ya sala' aw nyatibulluk adti pagdalug sa pagkaliman na Tyumanem. Yanagaw pigtamengan ni Hérodés si Juan aw kaliman nan uman na gayed magpakanyeg sa palna-u nan pangkay nyabelengbeleng sa pigdengeg nan. ");
INSERT INTO klg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Manang pagdateng na allaw ni Hérodés, mig-imo' sakanan sa dakula' na katipun. Aw pyamilit nan ya manga pigsaligan nan, aw ya manga matas na sundalu, aw ya manga dakula' na utaw dun ni banwa na Galilya. Aw yeiy da ya allaw na pigtagadan ni Hérodiyas. ");
INSERT INTO klg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dun ni katipun yan, syumeled ya ise' ni Hérodiyas na dalaga aw syumayaw adti asdangan na kadég na utaw. Aw to-o migleya si Hérodés aw ya manga pyamilit nan, yanagaw piglongan nan ya dalaga, “Pagsekat kaw sa pangkay unu na kaliman mu aw atag ku kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tigkas yan, migsapa' si Hérodés kanan, law nan, “Atag ku kanmu ya kadakula' na sekaten mu kanak, pangkay katenga' pa na kasakupan ku.” ");
INSERT INTO klg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lyumuwa' ya dalaga aw nyusip sa ina nan, “Unu ya un ku sekaten?” Aw tyumubag ya ina nan, “Yan ya sekata ya ulu ni Juan na Magba͡utismuway.” ");
INSERT INTO klg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nyaksay lyumiku' ya dalaga adti kan Hérodés, aw law nan, “Yan ya kaliman ku sekaten ya ulu ni Juan na Magba͡utismuway. Atagan kanak adun ya ulu nan na dayaw betang adti dakula' na palatu!” ");
INSERT INTO klg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagdengeg ni Hérodés, migkalat ya ginawa nan. Manang asuntu na nyakasapa' da sakanan dun ni asdangan na kadég na pyamilit nan, makamulamula kanan kun dili' nan tumanen ya sapa' nan. ");
INSERT INTO klg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aw maksay ni Hérodés pigsugu' ya sambuk na sundalu na angayen ya ulu ni Juan. Aw nyadtu ya sundalu ni kalabusuwanan aw pig-utudan nan si Juan sa ulu. ");
INSERT INTO klg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aw pigbetang nan ya ulu ni Juan adti dakula' na palatu aw dyala nan adti dalaga, aw pig-atag na dalaga adti ina nan. ");
INSERT INTO klg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagdengeg na manga umagakan ni Juan sa nya-imo', pig-angay nilan ya lawas nan aw lebengan nilan. ");
INSERT INTO klg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na, lyumiku' ya manga apostolés adti tampid ni Jisus aw pigdandan nilan kanan ya kadég na pigpan-imo' nilan aw pigpalna-u nilan. ");
INSERT INTO klg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Manang to-o madég ya utaw na migliku-liku' adti sayid nilan aw wala' ya selat nilan kyuman, yanagaw miglong si Jisus sa manga umagakan nan, “Naten madtu ni kaligbinan pada maglagdeng dagawdagaw.” ");
INSERT INTO klg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yanagaw syumakay silan sa balangay aw migpasinan adti kaligbinan na olo' silan. ");
INSERT INTO klg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Manang sa pag-indeg da nilan, madég ya utaw na kyumita' aw kyumilala kanilan. Aw dyumalagan ya manga utaw na lekat adti eped na manga lunsud dun ni baklayan pasinan adti banwa na un kadtuwan ni Jisus aw nyaka-una pa silan dyumateng dun. ");
INSERT INTO klg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagpanog da ni Jisus lekat adti balangay, kyinita nan ya to-o madég na utaw na migkatipun dun. Aw to-o sakanan nyallat kanilan kay kasiling silan na manga karniro na wala' ya magdadiyaga͡ay. Yanagaw madég ya pigpalna-u ni Jisus kanilan. ");
INSERT INTO klg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagka͡ambung da, dyumulud kan Jisus ya kanan manga umagakan, aw miglong silan, “Ambung da to-o aw wala' ya makan asini banwa ini. ");
INSERT INTO klg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ayin ya madyaw kun papanawun da mu ya manga utaw pada makabayad silan sa kanilan makan dun ni manga baranggay?” ");
INSERT INTO klg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Manang tyumubag si Jisus kanilan, “Kamu baling ya matag sa un nilan makan.” Aw miglong silan kanan, “Unu, manaw kami pada mayad sa makan na kadég na utaw yeiy? Ya kakan na maka-umba’ kanilan, walumbulan na utaw talabahuwan!” ");
INSERT INTO klg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aw miglong si Jisus kanilan, “Pilallapid ya pan mayu awun? Tanawa mayu kunu.” Aw sa pagka-ede' da nilan, piglongan nilan si Jisus, “Olo' da limallapid ya pan aw duwambulus ya isda'.” ");
INSERT INTO klg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tigkas yan, pigpa-ingkud ni Jisus ya manga utaw na ubbung-ubbung dun ni sakati. ");
INSERT INTO klg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aw yanagaw nyingkud silan na tag sanggatus ya sangka-ubbung aw tag kaliman ya sangka-ubbung. ");
INSERT INTO klg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pigkamang ni Jisus ya limallapid ya pan aw duwambulus ya isda'. Aw lyumangad sakanan adti langit aw pigpasalamatan nan adti Tyumanem. Aw tigkas yan, pigtenga-tenga' nan ya pan aw pig-atag nan adti kanan manga umagakan na un nilan atped-atped adti manga utaw. Maynan uman, pigtenga-tenga' ni Jisus ya duwambulus ya isda' adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kyuman ya kadég nilan aw alag silan nyangkabiyag. ");
INSERT INTO klg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aw pigpan-imun na manga umagakan ni Jisus ya nyasama' na pan aw isda', aw nyangkatmu' ya sampulu' tag duwa ya be-en. ");
INSERT INTO klg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sa kadég na kyuman dun, manga limammalalan ya eseg. ");
INSERT INTO klg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sa abus da pakakan ya manga utaw, maksay pigsugu' ni Jisus ya kanan manga umagakan na lumiku' sumakay adti balangay aw muna la silan adti Bétsayda, kay un pa nan papanawun ya kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagkatigkas nan papanawun ya manga utaw, tyumukud si Jisus adti buntud na un manawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkalalem da na gabi, adtu la ni tenga-tenga' na danaw ya balangay na pigsakayan na manga umagakan nan, aw dakman si Jisus ya adti buntud. ");
INSERT INTO klg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pigtandawan nan silan aw kyinita' nan na migkalug silan nyamegsay kay gayed nilan pigsalumpak ya mabandes na samet. Aw sa pagpakallawunun da, nyanaw si Jisus adti tas na tubig aw migpasinan dun ni kanilan aw un da nan galu silan labayan. ");
INSERT INTO klg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Manang pagkita' nilan na awun nyanaw adti tas na tubig, iman nilan aw ma-allekay sakanan. Aw mig-ulangag silan ");
INSERT INTO klg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kay alag nilan pigkita' aw to-o silan nyallek. Manang maksay si Jisus migtawag kanilan, “Dili' kamu magkallek! Aku saba ya ini! Pakabagsega ya ginawa mayu.” ");
INSERT INTO klg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aw syumakay si Jisus adti balangay aw dayaw tyumangke' ya mabandes na samet. Aw ya manga umagakan nan to-o nya-enneng-enneng. ");
INSERT INTO klg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pangkay kyinita' da nilan ya katulus ni Jisus sa pig-imo' nan sa pan, manang wala' pa nilan kalabeti kun singalan sakanan, kay kenne' na kategelan na anenganeng nilan. ");
INSERT INTO klg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagpakatalipag da nilan sa danaw, adtu silan dunggu' ni lunsud na Génésarét, aw dun da nilan eketan ya balangay. ");
INSERT INTO klg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagpanog nilan adti balangay, maksay na manga utaw pigkilala si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aw migkagallat silan nyangay sa manga pyangkedelan lekat adti manga banwa na nyakapalibed dun, aw pigdala nilan adti banwa na dyengeg nilan na adtu si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aw kun ayin si Jisus kadtu, pangkay adti baranggay aw adti lunsud aw adti palingki, adtu nilan uman dala͡a ya manga utaw na pyangkedelan. Aw nyanginayu' silan kan Jisus na pa-awiden nan silan sa pangaway na pigsut nan. Aw ya kadég na nyaka-awid, alag silan kyaguli-an. ");
INSERT INTO klg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na, awun dyumateng lekat adti Jérusalim na manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu, aw dyumulud silan adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aw kyinita' nilan ya eped na manga umagakan ni Jisus na kyuman na kenne' na kalipa' na manga tullu' nilan kay wala' nilan daluga ya pa-agi na pag-unaw na pigsugu' na manga Parisiyo. ");
INSERT INTO klg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kay ya manga Judiyu, labi la ya manga Parisiyo, pigpigil kanilan ya kuman na dili' una mag-unaw kasiling na pa-agi na pigdalug na manga Judiyu kay yan ya katanem na pigpalna-u na manga mangkabaklegay nilan. ");
INSERT INTO klg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aw dili' silan uman kuman sa lekat adti palingki kun dili' silan una mag-unaw. Madég pa ya maynan na katanem na gayed nilan pigdalug kasiling na pag-ugas sa manga tabu' aw manga kulun aw manga lutu-unan. ");
INSERT INTO klg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yanagaw nyusip kan Jisus ya manga Parisiyo aw manga magpalna-uway sa Uldin, law nilan, “Ananga' na wala' na manga umagakan mu daluga ya manga katanem na mangkabaklegay tadun? Kyuman silan na kenne' na kalipa' na tullu' nilan.” ");
INSERT INTO klg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tyumubag si Jisus kanilan, “Matinaw saba ya pigpasulat dadan kan Isayas sa bet mayu na manga migtallalingu, law na Tyumanem: ‘Ya manga utaw ini, pigbasa͡an aku nilan magi olo' dun ni paglong nilan, manang ya kanilan anenganeng mawat adi kanak. ");
INSERT INTO klg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wala' ya guna na pagsimba nilan kanak, kay pigsayuwan nilan baling ya kanak manga sugu' sa palna-u na pig-imo-imo' olo' na manga utaw.’ ” ");
INSERT INTO klg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Migpadeleg si Jisus miglong adti manga Parisiyo, “Wala' mayu daluga ya sugu' na Tyumanem aw pigdalug mayu baling ya katanem na manga utaw aw ya palna-u nilan.” ");
INSERT INTO klg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aw piglongan pa uman silan ni Jisus, “To-o kamu matadeng magpalipaslipas sa pigsugu' na Tyumanem pada padelegen mayu ya kamayu manga katanem. ");
INSERT INTO klg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kasiling na piglong ni Moysis: ‘Pagbasa͡an mayu ya kamayu ama aw ina’ aw ‘Pangkay singalan ya maglong sa malatay adti kanan ama aw ina, patayen sakanan.’ ");
INSERT INTO klg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Manang sangkamulu' ya pigpalna-u mayu. Kay pigpalna-uwan mayu ya manga utaw na maglong silan adti kanilan ama aw ina, ‘Pasinsiyayi beg aku, kay wala' da ya kabatug ku magtabang kamayu, kay pigtani la ku adti Tyumanem ya un ku galu atag kamayu.’ ");
INSERT INTO klg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kasiling na pigtumbay mayu baling adti utaw na pabaya-an nilan ya kanilan mangkatikadeng. ");
INSERT INTO klg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yanagaw magi sa manga katanem na pigpalna-u mayu adti manga eped, pig-imo' mayu kasiling na wala' ya guna ya tengteng sugu' na Tyumanem. Aw madég pa uman ya baluk na pigpan-imo' mayu kasiling na maynan.” ");
INSERT INTO klg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aw pigtawag da uman ni Jisus ya madég na utaw, aw piglongan nan silan, “Kadég mayu, pakanyegi ya un ku kamayu paglongun aw anenganenga mayu yeiy: ");
INSERT INTO klg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Beke' na pagkanen na utaw ya makapalipa' kanan, manang ya kadég na malatay na lyumekat adti kanan anenganeng, yan saba ya makapalipa' kanan. ");
INSERT INTO klg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatigkas yan, pig-indegan ni Jisus ya madég na utaw, aw syumeled sakanan adti balay. Adti seled, nyusip kanan ya manga umagakan nan kun unu ya kakawasan na pundinganan nan. ");
INSERT INTO klg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aw tyumubag si Jisus kanilan, “Pangkay kamu uman wala' pa pakalabet sa kakawasan na piglong ku? Beke' na pagkanen na utaw ya makapalipa' kanan adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kay ya pagkanen na utaw dili' sumeled adti anenganeng nan, manang adtu baling ni buntit, aw dili' madugay lumuwa' adti lawas nan.” Yanagaw dun ni piglong ni Jisus, pigpa-ede' nan na ya kadég na makan, alag da malinis. ");
INSERT INTO klg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Miglong uman si Jisus, “Ya kadég na malatay na lyumekat adti anenganeng na utaw, yan ya makapalipa' kanan. ");
INSERT INTO klg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay ya anenganeng na utaw, yan ya lyekatan sa kadég na malatay kasiling na pagkasala-enen, pagpanakaw, pagpatay sa utaw, ");
INSERT INTO klg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aw ya paglakadenen, aw ya pagkatagaw, aw ya pagkaybeg sa pametang na eped na utaw, aw ya pagkaliman mag-imo' sa malatay adti eped, ya paggalu', aw ya pag-imo' sa makamulamula sa lawas, aw ya pag-inga', aw ya pagkalat sa dengeg na eped na utaw, aw ya pagpatastas, aw ya pagkategel. ");
INSERT INTO klg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ya kadég na malatay yeiy, lekat saba adti anenganeng na utaw, aw yan ya makapalipa' kanan.” ");
INSERT INTO klg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pagkatigkas yan, nyindeg si Jisus lekat adti Galilya aw nyadtu ni banwa na sakup na syudad na Tiro na pig-eya-an na manga utaw na Héntil. Syumeled sakanan adti sambuk na balay aw dili' galu sakanan malim na ka-ede-an na manga utaw na awun sakanan, manang maksay baling nyabekkal ya ubat-ubat sa pagdateng nan. ");
INSERT INTO klg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Na, dun ni banwa yan, awun sambuk na ka͡ubayan na Héntil na buwadbuwad na manga taga Ponisiya sakup na Sirya, aw awun ise' nan na bubay na pigseledan na busaw. Yanagaw, pagdengeg na ka͡ubayan yan na dyumateng si Jisus adti kanilan banwa, maksay sakanan nyadtu aw lyumuhud dun ni asdangan nan, aw nyangilalat kan Jisus na alilinan ya busaw lekat adti ise' nan. ");
INSERT INTO klg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Manang miglong si Jisus kanan, “Pabiyagen pa una ya mangayse', kay dili' madyaw kun kamangen ya pan nilan aw agbel adti manga idu'.” ");
INSERT INTO klg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tyumubag ya ka͡ubayan kan Jisus, “Matinaw yan kay Sir, manang pangkay ya manga idu' adti dalem na lamisa makakan pa sa manga mumu' na mangayse' na mangkataktak.” ");
INSERT INTO klg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aw piglongan ni Jisus ya ka͡ubayan, “Asuntu sa tubag mu, uli' da kaw, kay lyumuwa' da ya busaw lekat adti ise' mu.” ");
INSERT INTO klg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yanagaw nyuli' ya ka͡ubayan aw kyinita' nan ya ise' nan na kyumulang da adti kulanganan nan aw wala' da ya busaw dun ni kanan. ");
INSERT INTO klg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na, pig-indegan ni Jisus ya Tiro aw nyadtu ni syudad na Sidon. Aw pagkatigkas yan, syuminan da uman sakanan adti manga banwa na awun ni palibed na Danaw na Galilya aw adti manga lunsud na sakup na Dékapolis. ");
INSERT INTO klg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Talana nan dun, pigpa-agad na manga utaw adti kan Jisus ya sambuk na eseg na bengel aw umal, aw nyanginayu' silan na pandungan nan na kanan palad. ");
INSERT INTO klg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yanagaw pigtani ni Jisus ya eseg yan lekat adti manga utaw, aw pigseled nan ya duwa ya tulli-ay nan adti manga talinga na utaw yan, aw pigbetangan nan na laway ya dila' na umal. ");
INSERT INTO klg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aw lyumangad si Jisus adti langit aw gyuminawa na malalem, aw miglong sakanan, “Éppata!” Ya kakawasan nan: “Ka-uwangan kaw!” ");
INSERT INTO klg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aw dayaw dyumengeg aw nyakapaglong ya eseg yan, aw mabangal da ya paglong nan. ");
INSERT INTO klg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pagkatigkas yan, piglongan ni Jisus ya manga utaw, “Dili' mayu pag-ubat-ubat adti pangkay singalan ya nya-imo' adun.” Manang to-o pa baling nilan pigbekkal adti madég na utaw ya nya-imo'. ");
INSERT INTO klg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aw to-o nya-enneng-enneng ya manga utaw aw miglong silan, “Alag mangkadyaw ya pigpan-imo' nan. Pigpadengeg nan ya manga bengel aw pigpapaglong nan ya manga umal.” ");
INSERT INTO klg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dun ni manga allaw yan, migkatipun da uman ya madég to-o na manga utaw adti kan Jisus. Pagkabus da na makan nilan, pigtawag ni Jisus ya kanan manga umagakan, aw piglongan nan silan, ");
INSERT INTO klg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nyallat aku sa manga utaw ini, kay seled na tulungallaw gayed silan asini sayid tadun, aw wala' da ya un nilan makan. ");
INSERT INTO klg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kun pa-uli-en ku silan na wala' ya pigkan, pagaw to-o silan magkalumay dun ni dalan. Kay awun eped kanilan na mawat pa ya un nilan uli-an.” ");
INSERT INTO klg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aw tyumubag ya kanan manga umagakan, “Ayin kitadun kamang sa makan asini kaligbinan ini na maka-umba' sa kadég na manga utaw yeiy?” ");
INSERT INTO klg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aw nyusip si Jisus kanilan, “Pilallapid ya pan mayu awun?” Aw tyumubag silan, “Pitullapid da.” ");
INSERT INTO klg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aw piglongan ni Jisus ya manga utaw na mingkud silan dun ni sakati. Aw pigkamang nan ya pitullapid ya pan, aw pigpasalamatan nan adti Tyumanem. Aw pagkatigkas yan, pigtenga-tenga' nan adti kanan manga umagakan na un nilan uman atped-atped adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aw pagkatigkas yan, kyumamang uman si Jisus sa mangkayantek na isda' na awun ni kanilan, aw pigpasalamatan nan ya Tyumanem. Aw piglongan nan ya manga umagakan nan na pan-atped-atpeden uman ya manga utaw na isda'. ");
INSERT INTO klg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kyuman ya kadég nilan aw alag silan nyangkabiyag. Aw pigpan-imun na manga umagakan nan ya nyasama' aw pitungka be-en na mabakla' ya dayaw nyangkatmu'. ");
INSERT INTO klg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na, ya kadég na utaw na kyuman dun, manga upatemmalalan. Aw pagkatigkas nilan kuman, pigpapanaw silan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aw maksay si Jisus aw manga umagakan nan syumakay sa balangay nilan pasinan adti banwa na Dalmanuta. ");
INSERT INTO klg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na, dyumulud ya manga Parisiyo kan Jisus aw gayed migpa-ayil kanan, kay yan ya tud nilan ya pagtanda' kun si Jisus ya Pigpadala na Tyumanem. Yanagaw migsekat silan kanan sa pangilala. ");
INSERT INTO klg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Manang gyuminawa si Jisus na malalem aw nyusip kanilan, “Ananga' ya manga utaw adun na manga allaw yeiy gayed migsekat sa pangilala? Matinaw ya un ku kamayu paglongun: Dili' kamu saba atagan na pangilala!” ");
INSERT INTO klg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aw pig-indegan nan ya manga Parisiyo, aw syumakay si Jisus aw manga eped nan sa balangay, aw migpasinan adti dipag na danaw. ");
INSERT INTO klg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, kyalingawan na manga umagakan ni Jisus ya dyumala sa pan, aw dakman sallapid ya pan na awun ni balangay. ");
INSERT INTO klg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aw miglong si Jisus kanilan, “Magpakatadeng kamu sa patulinay na manga Parisiyo aw ni Hérodés.” ");
INSERT INTO klg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aw migpanbalawbalaw silan, law nilan, “Yan gya ya du-an na piglong nan kay wala' kitadun pakadala sa pan.” ");
INSERT INTO klg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Manang kya-ede-an ni Jisus ya pigbalawbalawan nilan, yanagaw nyusip sakanan kanilan, “Ananga' mayu balawbalawan ya wala' ya pan? Unu, wala' pa ka' mayu kalabeti? Kenne' ka' na kategelan na anenganeng mayu? ");
INSERT INTO klg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Awun saba mata mayu, ananga' wala' mayu kita-a? Awun saba talinga mayu, ananga' wala' mayu dengega? Unu, kyalingawlingawan da mayu ya kyinita' mayu ");
INSERT INTO klg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","sa pagtenga' ku sa limallapid ya pan aw sa pagpakan ku sa limammalalan? Na, pila ya be-en na nyatmu' sa nyasama' na pigpan-imun mayu?” Tyumubag silan, “Sampulu' tag duwa.” ");
INSERT INTO klg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nyusip pa si Jisus kanilan, “Sa pagtenga' ku sa pitullapid ya pan aw sa pagpakan ku sa upatemmalalan ya utaw, na, pila ya be-en na mabakla' na nyatmu' sa nyasama' na pigpan-imun mayu?” Aw tyumubag silan, “Pitungka be-en na mabakla'.” ");
INSERT INTO klg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aw nyusip si Jisus kanilan, “Unu, wala' pa mayu kalabeti na beke' na tengteng pan ya pyalabet ku?” ");
INSERT INTO klg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pagdateng ni Jisus aw manga umagakan nan adti Bétsayda, awun manga utaw na mig-agak sa eseg na buta pasinan adti kan Jisus, aw nyanginayu' silan kanan na awidan nan ya eseg yan. ");
INSERT INTO klg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pig-agak ni Jisus ya eseg na buta aw pigpa-agad nan adti luwa' na baranggay. Aw tigkas yan, pigdamus ni Jisus ya kanan laway adti mata na utaw yan aw betangi nan na kanan manga palad, aw nyusip si Jisus kanan, “Unu, awun da kyinita' mu?” ");
INSERT INTO klg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pagtandaw na eseg yan, miglong sakanan, “E-e, kyinita' da ku ya manga utaw manang kasiling silan na manga kawuy na migpanawpanaw.” ");
INSERT INTO klg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aw pigbetang pa uman ni Jisus ya manga palad nan adti manga mata na eseg. Aw sa pagtandaw nan salut, dayaw da kyumita' aw mabangal da ya pag-inunu nan. ");
INSERT INTO klg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aw pagkatigkas yan, pigpa-uli' sakanan ni Jisus aw piglongan nan, “Sa pag-uli' mu, dili' kaw mag-agi adti baranggay.” ");
INSERT INTO klg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pagkatigkas yan, nyindeg si Jisus aw manga umagakan nan aw nyanaw silan adti manga baranggay sakup na lunsud na Césariya Pilipo. Aw sa talana nilan nyanaw, pig-usip nan silan, “Dun ni pagbalawbalaw na manga utaw, singalan kunu aku?” ");
INSERT INTO klg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aw tyumubag silan, “Ya eped miglong na ikaw kunu si Juan na Magba͡utismuway, aw awun eped miglong na ikaw kunu si Éliyas, aw awun pa eped miglong na ikaw ya sambuk na propita.” ");
INSERT INTO klg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aw nyusip pa si Jisus kanilan, “Manang adti kamayu, singalan aku?” Aw tyumubag si Pédro, “Ikaw saba ya Kristu.” ");
INSERT INTO klg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aw piglongan silan ni Jisus na dili' nilan pagpa-ede' adti eped na utaw kun singalan sakanan. ");
INSERT INTO klg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aw pigpalekat ni Jisus ya miglong adti kanan manga umagakan, “Aku na Ise' na Utaw ka-ilangan magti-is aw kele͡an na manga magdadumala͡ay sa manga Judiyu aw manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin. Aw un aku nilan patayen, manang pagkatlu na allaw mataw aku.” ");
INSERT INTO klg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","To-o ni Jisus pigbangal kanilan ya un ma-imo' kanan. Aw pigpa-agad sakanan ni Pédro adti dili' to-o mawat sa manga eped nilan, aw pigpalekat ni Pédro ya pagsagda kanan. ");
INSERT INTO klg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Manang nyatubang si Jisus adti manga umagakan nan, aw pigsagda nan si Pédro, law nan, “Pagpakawat kaw kanak! Ya piglong mu lekat saba adti kan Satanas. Wala' mu betangan adti kanmu anenganeng ya kana Tyumanem pagkaliman. Yan olo' ya pig-anenganeng mu ya kana utaw.” ");
INSERT INTO klg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pagkatigkas yan, pigtawag ni Jisus ya madég na manga utaw aw ya kanan manga umagakan, aw piglongan nan silan, “Pangkay singalan ya malim ma-imo' kanak umagakan, ka-ilangan nan ayawan ya kanan pagkaliman aw pisanen nan ya kanan krus aw dumalug kanak. ");
INSERT INTO klg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kay pangkay singalan ya gyuminawa sa pagka-utawun nan asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay pada magpa-ede' sa Madyaw na Ubat-ubat, yan ya un makatagtun sa ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Unu ka' ya un ma-untung na utaw kun matagtun nan ya kadakula' na banwa manang kalagakan baling sa ginawa na wala' ya katigkasan? ");
INSERT INTO klg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aw unu uman ya nyatagtun na utaw na umba' nan pagliwan sa ginawa na wala' ya katigkasan? ");
INSERT INTO klg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ya manga utaw asini tas na lupa' adun na manga allaw yeiy, gayed silan migpakasala', aw kasiling silan na ka͡ubayan na miglakadenen. Aw kun singalan ya mamulamula asuntu kanak na Ise' na Utaw aw mamulamula asuntu sa palna-u ku, kamulamula ku uman ya utaw yan dun ni allaw na pagliku' ku asini tas na lupa'. Aw dun ni kanak pagliku' kita-en ya dakula' na kalalamdag na pagka Tyumanem na kanak Ama, aw eped ku ya manga anghil lekat adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aw miglong pa si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Awun eped kamayu asini na dili' nilan apeten ya pagkamatay menda' na kita-en nilan ya paghari' na Tyumanem na ka-agadan na kadakula' na katulus nan.” ");
INSERT INTO klg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkatigkas na enemengallaw, pigpa-agad ni Jisus si Pédro aw si Santiago aw si Juan aw tyumukud silan adti matas na buntud na olo' silan. Aw sa talana nilan sakanan pigtandawan, nya-uman ya kadakula' na lawas ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ya kaputi' na kadégkadég nan wala' ya un maka-unawa asini tas na lupa', aw to-o masilang. ");
INSERT INTO klg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aw migpakita' uman dun si Éliyas aw si Moysis aw migbalawbalaw silan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aw miglong si Pédro kan Jisus, “Kay Magpalna-uway, madyaw kay ini kami. Magtulluk kami sa tulu ya layag, sambuk ya kanmu, sambuk ya kan Moysis aw sambuk ya kan Éliyas.” ");
INSERT INTO klg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yan ya piglong ni Pédro kay wala' nan ka-ede-i kun unu ya madyaw nan paglongun, kay to-o silan nyallek. ");
INSERT INTO klg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aw tigkas yan, awun labun na tyumakleb kanilan. Aw awun tingeg na lekat adti labun na miglong, “Yéiy ya kanak Ise' na to-o ku pigginawa͡an. Pakanyegi mayu sakanan!” ");
INSERT INTO klg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aw sa pag-inunu nilan, wala' ya eped na kyinita' nilan dun, dakman olo' si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sa pagtubang nilan lekat adti buntud, piglongan silan ni Jisus na dili' nilan pagpa-ede' adti pangkay singalan ya kyinita' nilan taman na mataw ya Ise' na Utaw lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yanagaw pigtuman nilan ya piglong ni Jisus, manang gayed silan mig-usip-usipay kun unu ya kakawasan na piglong nan sa pagkataw na utaw lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aw pig-usip nilan si Jisus, “Ananga' gayed miglong ya manga magpalna-uway sa Uldin na ka-ilangan maka-una si Éliyas dumateng aw makamoli ya Misiyas?” ");
INSERT INTO klg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Aw tyumubag si Jisus kanilan, “Matinaw saba ya piglong nilan na si Éliyas ya maka-una aw magtagilan sa kadég. Manang paglongun ta kamu na dyumateng da si Éliyas, aw pigpamulayaman sakanan na manga utaw, kasiling na dadan da na Tyumanem pigpasulat. Aw maynan uman, pigpasulat nan na aku na Ise' na Utaw ka-ilangan pati-isen aw odoy-odoyun na manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagliku' ni Jisus aw ya tulu ya eped nan lekat adti buntud, kyinita' nilan na kyalimpungan na madég na utaw ya kanilan eped. Aw pig-ayil silan na manga magpalna-uway sa Uldin na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aw ya madég na manga utaw, wala' nilan imanmana na mawun si Jisus, yanagaw sa pagkita' nilan kanan, nya-enneng-enneng silan aw maksay silan lyumagbet kanan. ");
INSERT INTO klg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aw nyusip si Jisus kanilan, “Unu ya pig-ayilan mayu?” ");
INSERT INTO klg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aw miglong ya sambuk na eseg dun, “Kay Magpalna-uway, pigpa-agad ku adi kanmu ya ise' ku na eseg kay syeledan sakanan na busaw aw wala' da sakanan pakapaglong. ");
INSERT INTO klg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aw kun magseled ya busaw kanan, magkatuwad sakanan dun ni lupa', aw magsula' ya baka' nan aw magpanguliteb ya untu nan aw magkeseg ya kanan lawas. Yanagaw migsekat aku adti manga umagakan mu na alilinan nilan ya busaw yan, manang wala' nilan kabatug.” ");
INSERT INTO klg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aw miglong si Jisus, “Tay sa manga utaw adun na manga allaw yeiy na wala' ya pagpangintu-u! Sangunu ka' ya kadugay na mati-is ku ya pag-iyagad kamayu?” Tigkas yan, miglong si Jisus, “Na, pa-agadan adi sayid ku ya ise'.” ");
INSERT INTO klg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yanagaw pigpa-agad nilan ya ise' adti kan Jisus. Manang pagkita' na busaw kan Jisus, to-o nan pigpatakig ya ise' aw nyalukad adti lupa', aw gayed migtambulilid aw migsula' ya baka' nan. ");
INSERT INTO klg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aw pig-usip ni Jisus ya ama na ise', “Kanu pagpalekat ya bati-enen na ise' mu?” Aw tyumubag ya ama nan, “Lekat pa na pagkatagbi' nan. ");
INSERT INTO klg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Malikit da na busaw paglukaden ya ise' ku adti atulun aw adti tubig na un nan galu patayen. Manang kun mabatug mu, kallati aw tabangi beg kami!” ");
INSERT INTO klg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aw miglong si Jisus, “Ananga' kaw maglong, ‘Kun mabatug mu’? Mabatug saba adti utaw ya kadakula' kun awun pagpangintu-u nan kanak.” ");
INSERT INTO klg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aw maksay tyumubag ya ama na ise' yan, “Nyangintu-u aku kanmu, manang dili' pa umba'! Tabangi beg aku na kadugangan ya kanak pagpangintu-u kanmu!” ");
INSERT INTO klg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagkita' ni Jisus sa to-o madég na manga utaw na maksay migpasinan adti kanan, pigsugu' nan ya busaw na migpabengel aw migpa-umu sa ise', law ni Jisus, “Paglongun ta kaw kay busaw: Luwa' kaw asini ise' ini, aw dili' da mu pagliku-an!” ");
INSERT INTO klg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aw tigkan mig-ulangag ya busaw, aw to-o nan pigpatakig ya ise', aw tigkas yan, lyumuwa' ya busaw. Iman mu aw wala' da ya ginawa na ise', aw madég kanilan ya miglong, “Nyatay da ya ise' iyan.” ");
INSERT INTO klg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Manang pig-awidan ni Jisus ya tullu' na ise' aw banguna nan aw nyindeg ya ise' dun ni asdangan nilan. ");
INSERT INTO klg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagseled da ni Jisus aw kanan manga umagakan adti balay, pig-usip nilan sakanan, “Ananga' wala' nami kabatug alilini ya busaw yan?” ");
INSERT INTO klg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aw tyumubag si Jisus kanilan, “Ya maynan na punganan na busaw, ka-alilinan magi olo' sa pagpanawagtawag adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pag-indeg ni Jisus aw kanan manga umagakan dun, nyagi silan adti Galilya. Aw dili' si Jisus malim na ka-ede-an na eped na utaw kun ayin silan, ");
INSERT INTO klg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay kaliman nan palna-uwan silan. Miglong si Jisus kanilan, “Aku na Ise' na Utaw agpet da lubidan aw tumbay adti manga utaw na un magpatay kanak. Manang pagdateng na katlu na allaw, matawun aku lekat adti pagkamatay.” ");
INSERT INTO klg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Manang wala' nilan kalabeti ya kakawasan na piglong nan, aw migduwaduwa silan musip kanan. ");
INSERT INTO klg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pagdateng nilan adti Kapirna-um, nyantuk si Jisus aw ya manga umagakan nan adti balay, aw nyusip si Jisus kanilan, “Unu ya pig-ayilan mayu dun ni dalan kakayna?” ");
INSERT INTO klg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Manang nyatinep silan kay ya pig-ayilan nilan kun singalan kanilan ya to-o matas. ");
INSERT INTO klg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aw nyingkud si Jisus aw pigtawag nan ya sampulu' tag duwa aw piglongan nan silan, “Kun awun sambuk kamayu na kaliman nan ma-imo' to-o dakula' na utaw, ka-ilangan sakanan una magpadalem aw ma-imo' sugu-anen na kadég.” ");
INSERT INTO klg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aw pagkatigkas yan, kyumamang si Jisus sa tagbi' na ise' aw pigpa-indeg nan dun ni tenga' nilan. Tigkas yan, pigsipit nan ya ise', aw miglong si Jisus, ");
INSERT INTO klg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pangkay singalan kamayu ya dumawat sa utaw na madalem kasiling na ise' ini asuntu sa pagdalug mayu kanak, dun da aku nan uman dawata. Aw pangkay singalan ya dumawat kanak, dun da nan uman dawata ya Ama na migpadala kanak.” ");
INSERT INTO klg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aw miglong si Juan kan Jisus, “Kay Magpalna-uway, kyinita' nami ya sambuk na utaw na mig-alilin sa manga busaw dun ni ngalan mu, aw piglongan nami sakanan na botonan nan ya pigpan-imo' nan kay beke' saba sakanan na eped tadun.” ");
INSERT INTO klg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Manang miglong si Jisus kanilan, “Pabaya-i mayu sakanan! Kay ya utaw na maka-imo' sa milagru magi dun ni kanak ngalan, dili' uman sakanan maksay makapaglong sa malatay adi kanak. ");
INSERT INTO klg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kun singalan ya wala' kele sa kanaten palna-u, yan ya syumambuk uman kanaten. ");
INSERT INTO klg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Matinaw saba ya un ku paglongun kamayu: Pangkay singalan utawa na mallat kamayu aw matag sa pangkay sangkatabu' ya tubig asuntu na kya-ede-an nan na aku si Kristu ya pigdalug mayu, na, yan ya utaw na dumawat sa tandan kagaya. ");
INSERT INTO klg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Manang kun awun utaw na migpadalem na nyangintu-u kanak, aw kun buyuwun sakanan adti pagpakasala', ya utaw na magbuyu madyaw pa baling kun tati-an ya liyeg nan na dakula' na gilingan na batu aw ulugun sakanan adti dagat. ");
INSERT INTO klg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aw kun ya pig-imo' na kanmu tullu' ya du-an na makasala' kaw, madyaw pa baling na magpakawat kaw dun ni pangkay unu ya makapabuyu kanmu adti pag-imo' sa sala'. Pangkay pa kun utudun ya kanmu tullu', madyaw pa na awun malagak dun ni kanmu lawas aw matagtun mu ya ginawa na wala' ya katigkasan, kay sa awun duwa ya tullu' mu manang agbel kaw baling adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Dun ni banwa yan, ya mangkayantek na lala na magkan sa unud na utaw dili' magkamatay, aw ya atulun dili' uman pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aw kun ya pig-imo' na kanmu siki ya du-an na makasala' kaw, madyaw pa baling na magpakawat kaw dun ni pangkay unu ya makapabuyu kanmu adti pag-imo' sa sala'. Pangkay pa kun utudun ya kanmu siki, madyaw pa na awun malagak dun ni kanmu lawas aw matagtun mu ya ginawa na wala' ya katigkasan, kay sa awun duwa ya siki mu manang agbel kaw baling adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Dun ni banwa yan, ya mangkayantek na lala na magkan sa unud na utaw dili' magkamatay, aw ya atulun dili' uman pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aw kun ya pag-inunu mu ya du-an na maka-imo' kaw sa sala', madyaw pa baling na magpakawat kaw sa pangkay unu ya makapabuyu kanmu adti pag-imo' sa sala'. Pangkay pa kun lugiten ya kanmu mata, madyaw pa baling na mabuta ya sangkilid na mata mu aw sumeled kaw adti kasakupan na Tyumanem kay sa awun duwa ya mata mu manang agbel kaw baling adti atulun na dili' pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dun ni banwa yan, ya mangkayantek na lala na magkan sa unud na utaw dili' magkamatay, aw ya atulun dili' uman pagkapatayan. ");
INSERT INTO klg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ya kadég na utaw un nilan ka-agiyan ya manga kalugan pada ya pagpangintu-u nilan to-o magkasalig. Kasiling na gulay na pag-asinan pada magkadyaw ya nanam. ");
INSERT INTO klg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Madyaw ya asin, manang kun kalagakan sa nanam, dili' da makaliku' ya ka͡asin nan. Maynan uman, ka-ilangan na masiling kamu na asin adti kamayu eped, aw pagsambuka ya kamayu ginawa.” ");
INSERT INTO klg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pagkatigkas ni Jisus palna-uwan ya manga utaw dun, nyanaw sakanan aw ya kanan manga umagakan. Tyumalipag silan sa tubig na Jordan aw migpasinan adti banwa na Judiya. Aw dun ni pagpanaw nilan, gayed migkatipun adti kan Jisus ya madég na utaw, aw pigpalna-uwan nan silan kay yan ya kanan kyanalaman pag-imo-un. ");
INSERT INTO klg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aw awun manga Parisiyo na dyumulud adti kan Jisus na un magtanda' kanan, law nilan, “Unu, pigtumbay sa eseg ya pag-ayaw sa ka͡ubayan nan?” ");
INSERT INTO klg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tyumubag si Jisus kanilan, “Unu ya piglong ni Moysis sa pag-ayaw?” ");
INSERT INTO klg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aw miglong silan, “Yan saba ya piglong ni Moysis na mabatug ayawan na eseg ya ka͡ubayan nan kun una nan atagan na sulat na magmatinaw na mag-ayaw silan, aw tigkas yan, papanawun da nan.” ");
INSERT INTO klg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aw tyumubag si Jisus kanilan, “Yan saba ya du-an na pigsulat ni Moysis ya pag-ayaw asini muna, asuntu sa kategelan mayu. ");
INSERT INTO klg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Manang lekat na pag-imo' na Tyumanem sa kadakula' na banwa, yan ya palpa nan na ‘duwa ya punganan na utaw na pig-imo' nan: awun eseg aw awun bubay.’ ");
INSERT INTO klg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Yéiy ya du-an na indegan na eseg ya kanan ama aw ina, aw pa-egketen silan ya ka͡ubayan nan, ");
INSERT INTO klg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aw ya duwa silan ma-imo' da sambuk.’ Yanagaw beke' da silan na duwa manang sambuk da. ");
INSERT INTO klg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aw ya pigsambuk da na Tyumanem, dili' galu silan pagsuwayen na utaw!” ");
INSERT INTO klg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagliku' ni Jisus aw manga umagakan nan adti balay, nyusip silan uman kanan sa kakawasan na piglong nan. ");
INSERT INTO klg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aw miglong si Jisus kanilan, “Kun awun eseg na ayawan nan ya kanan ka͡ubayan, aw kun mangugnan sakanan sa eped na ka͡ubayan, piglakadan da nan ya muna ka͡ubayan nan. ");
INSERT INTO klg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aw ya ka͡ubayan uman, kun ayawan nan ya kanan eseg aw mangugnan sa eped na eseg, piglakadan nan ya muna eseg nan.” ");
INSERT INTO klg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sambuk na allaw, awun manga utaw na nyandala adti kan Jisus sa mangkayantek na mangayse' nilan na un nan awidan pada atagan silan na manga kadyawan. Manang pigsagda baling na umagakan nan ya manga utaw na nyandala sa mangayse' nilan. ");
INSERT INTO klg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkita' ni Jisus na pigsagda nilan, nyadaman sakanan aw piglongan nan silan, “Pakadiya kanak ya manga mangayse'. Ya-i mayu silan pagtageni! Kay ya manga utaw na dyumawat kanak kasiling na manga mangayse' ini, silan saba ya maka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Matinaw saba ya un ku paglongun kamayu: Pangkay singalan ya dili' malim dumawat kanak kasiling na pagdawat kanak na manga mangayse' ini, dili' saba silan makaseled adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pagkatigkas yan, pigsipit nan ya manga mangayse' aw pandungi nan na kanan palad aw pig-atagan nan silan na manga kadyawan magi dun ni kanan pagpanawagtawag. ");
INSERT INTO klg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sa un da galu si Jisus manaw, awun eseg na dyumalagan adti kanan aw lyumuhud dun ni asdangan nan, aw nyusip kan Jisus, “Kay Magpalna-uway na to-o madyaw, unu ya ka-ilangan ku imo-un pada matagtun ku ya ginawa na wala' ya katigkasan?” ");
INSERT INTO klg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aw tyumubag si Jisus kanan, “Ananga' aku mu tawagen na madyaw? Wala' saba ya utaw na madyaw. Sambuk da olo' ya tengteng na madyaw, yan ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na, kya-ede-an mu ya manga sugu' dun ni Uldin: Dili' kaw magpatay sa utaw, dili' kaw maglakadenen, dili' kaw magpanakaw, dili' mu pagmatinawun ya galu' adti asdangan na mag-usayay, dili' kaw maglimbung sa eped na utaw, aw basa͡an mu ya kanmu ama aw ina.” ");
INSERT INTO klg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aw tyumubag ya eseg, “Kay Magpalna-uway, pigdalug da ku alag ya kadég yeiy lekat pa na pagkatagbi' ku.” ");
INSERT INTO klg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aw pigtengtengan sakanan ni Jisus aw dakula' ya ginawa nan sa utaw yan, yanagaw piglongan nan, “Dakman sambuk ya wala' mu ka-imo': Uli' kaw aw galina ya kadég na nyatagtun mu. Tigkas yan, atagan ya kuwalta adti manga utaw na wala' ya pagkamangan. Kun imo-un mu yeiy, dun da kaw pagluduk sa ka-unan adti tas na langit. Aw pagkatigkas yan, liku' kaw adi aw dalug kaw kanak.” ");
INSERT INTO klg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagdengeg na utaw yan sa piglong ni Jisus, nyanaw sakanan aw to-o migkalat ya ginawa nan kay to-o madég ya ka-unan nan. ");
INSERT INTO klg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pag-indeg da na utaw yan, pig-inunu ni Jisus ya kanan manga umagakan, aw law nan, “Malug saba sa utaw na mayaman ya maka-akup adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aw nyabelengbeleng ya kanan manga umagakan sa piglong nan kay wala' nilan kalabeti. Yanagaw miglong pa si Jisus kanilan, “Kamu na pigsiling ku na kanak mangayse', paglongun ta kamu: Malug saba sa utaw ya pagpaka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aw paglongun ta kamu na molas pa ya pag-agi na ayep na kamilyo adti gawang na dagem kay sa pagpaka-akup na utaw na mayaman dun ni Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aw to-o pa silan nyabelengbeleng aw mig-usip-usipay silan, “Na, kun maynan, singalan ka' ya paluwa-en na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aw pig-inunu silan ni Jisus aw law nan, “Dili' na utaw mabatug yeiy manang mabatug saba na Tyumanem. Kay wala' ya dili' mabatug na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aw miglong si Pédro kanan, “Inunuwa ya kanami ini! Nyabus da nami pig-ayawan ya kadég na nyatagtun nami pada magad kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aw tyumubag si Jisus kanan, “Matinaw saba ya un ku paglongun kanmu: Pangkay singalan ya mag-ayaw sa kadég asuntu kanak aw asuntu sa Madyaw na Ubat-ubat, pangkay ayawan nan ya balay nan, aw ya kanan manga mangkaylug, aw mangkatikadeng nan aw ya manga mangayse' nan, aw ya lupa' nan, ");
INSERT INTO klg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na, ya utaw yan, un liku' adti kanan asini tas na lupa' ya sanggatus ka pilu' sa idtu na pig-ayawan nan. Dumawat pa sakanan sa manga balay, aw manga mangkaylug, aw manga ina, aw manga mangayse', aw lupa', aw maka-agad dun uman ya manga pamulayam. Aw dawaten nan uman ya ginawa na wala' ya katigkasan adti kamoliyan na allaw. ");
INSERT INTO klg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Manang awun madég na utaw na nyaka-una adun aw makamoli silan kagaya. Aw madég uman ya utaw na nyakamoli adun manang maka-una kagaya.” ");
INSERT INTO klg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, sa pagpadeleg nilan nyanaw adti Jérusalim, si Jisus ya nyuna sa manga umagakan nan. Aw nyasagunut ya anenganeng nilan, aw nyangkallek ya eped na manga utaw na dyumalug kanilan. Aw pigtani ni Jisus ya sampulu' tag duwa ya umagakan nan aw pig-ubat-ubat nan kanilan ya un dumateng kanan, ");
INSERT INTO klg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","law nan, “Pada ka-ede-an mayu, migpasinan da kitadun adti Jérusalim, aw aku na Ise' na Utaw un da tumbay adti manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin, aw ukuman aku nilan na patayen. Aw tigkas yan, tumbay aku uman nilan adti manga utaw na Héntil, ");
INSERT INTO klg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","aw odoy-odoyun aku nilan, aw eleb-eleban aw badasan nilan panlabeten, aw tigkas yan, patayen aku nilan. Manang pagdateng na katlu na allaw, mataw aku lekat adti pagkamatay.” ");
INSERT INTO klg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na, migpalapit adti kan Jisus si Santiago aw si Juan na alag ise' ni Zibidyo, aw miglong silan kanan, “Kay Magpalna-uway, awun galu sekaten nami kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aw tyumubag si Jisus kanilan, “Unu ya un mayu sekaten adi kanak?” ");
INSERT INTO klg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aw tyumubag silan, “Pag-ingkud da mu kagaya dun ni paghari' mu, tumbayan kanami ya mingkud adti sayid mu, ya sambuk apit adti kalintu aw ya sambuk apit adti kawala.” ");
INSERT INTO klg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Manang miglong si Jisus kanilan, “Wala' mayu ka-ede-i kun unu ya pigsekat mayu. Unu, mabatug mayu ya manga kalugan na un ku ka-agiyan? Aw unu, mati-is mayu uman ya manga un ku ti-isen?” ");
INSERT INTO klg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tyumubag silan, “E-e, mabatug nami.” Aw miglong si Jisus kanilan, “Un mayu saba agiyan ya un ku ka-agiyan, aw un mayu uman ti-isen ya un ku ti-isan. ");
INSERT INTO klg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Manang ya pag-ingkud adti kalintu ku aw adti kawala ku, beke' ku ya mamalli'. Ya mingkud dun, yan ya manga pigpamalli' da na Ama ku.” ");
INSERT INTO klg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, ya sampulu' uman na umagakan ni Jisus, dyengeg nilan ya pigsekat ni Santiago aw ni Juan, aw to-o silan nyadaman. ");
INSERT INTO klg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yanagaw pigpatawag ni Jisus ya kadég nilan aw piglongan nan silan, “Kya-ede-an da mayu ya bet na manga magdadumala͡ay sa manga utaw na wala' ya pagpangintu-u sa Tyumanem. Silan ya gayed magbaya' sa manga sakup nilan. Aw maynan uman ya manga mangkalangkaw, gayed silan magpanugu' sa manga utaw asuntu na dakula' ya katundanan nilan. ");
INSERT INTO klg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Manang dili' mayu silan pagsilingan. Kun awun sambuk kamayu na kaliman nan ma-imo' dakula' na utaw, ka-ilangan una sakanan ma-imo' sugu-anen dun ni kamayu. ");
INSERT INTO klg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aw kun awun sambuk kamayu na malim na yan ya gayed pag-una͡en, ka-ilangan silingan nan ya bet na sugu-anen na magpadana' adti kadég na utaw. ");
INSERT INTO klg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pangkay aku na Ise' na Utaw, wala' aku kadi asini tas na lupa' pada sanggila-en, manang yan baling ya pigkadi ku ya ma-imo' sugu-anen adti manga utaw, aw ma-imo' kalyu kanilan adti pagkamatay pada maglekat kanilan adti manga sala' nilan.” ");
INSERT INTO klg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, dyumateng si Jisus aw manga umagakan nan adti syudad na Jériko. Aw sa pag-indeg nilan lekat dun ni syudad yan, madég ya manga utaw na nyagad kanilan. Aw adti kilid na dalan awun eseg na buta na nyingkud aw nyangilalat sa manga utaw na lyumabay. Ya ngalan nan si Bartimyo na ise' ni Timyo. ");
INSERT INTO klg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagdengeg nan na si Jisus na taga Nasarit ya un lumabay, migtatawag sakanan, “We... kay Jisus na buwadbuwad ni Dabid! Kallati beg aku!” ");
INSERT INTO klg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Manang pigsagda sakanan na madég na utaw, law nilan, “Katinep kaw!” Manang to-o pa nan baling pigpakadakula' ya kanan tingeg, “We... Buwadbuwad ni Dabid, kallati beg aku!” ");
INSERT INTO klg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yanagaw tyumeneng si Jisus aw law nan, “Tawaga mayu sakanan aw pa-agadan mayu adi.” Aw pigtawag nilan ya buta aw law nilan, “Pakabagsega ya ginawa mu! Indeg kaw kay pigtawag kaw ni Jisus!” ");
INSERT INTO klg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aw maksay nan pigsalabel ya kayab nan aw nyindeg aw migpalapit kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aw nyusip si Jisus kanan, “Unu ya kaliman mu na imo-un ku kanmu?” Aw tyumubag ya eseg yan, “Kay Magpalna-uway, kaliman ku beg kumita' salut.” ");
INSERT INTO klg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aw piglongan sakanan ni Jisus, “Panaw da kaw. Asuntu sa pagpangintu-u mu kanak, kyaguli-an da kaw.” Aw dayaw sakanan kyumita' aw dyumalug da kan Jisus sa panaw nan. ");
INSERT INTO klg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, sa malapit da silan adti Jérusalim, dyumateng silan adti manga baranggay na Bétpagi aw Bétaniya dun ni kilid na Buntud na Manga Olibo. Aw pigsugu' ni Jisus ya duwa ya umagakan nan, ");
INSERT INTO klg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","law nan, “Kadtu kamu dun ni baranggay adti dipag. Pagseled da mayu, kita-en mayu ya sambuk na nati na asnu na wala' pa kasakayi na utaw. Ubada mayu ya eket aw guyuda mayu adi. ");
INSERT INTO klg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kun awun musip kamayu, ‘Ananga' mayu yan ubadan?’ paglonga sakanan, ‘Ya Magpalna-uway ka-ilangan nan ya nati ini. Aw maksay nan uman uli' asini.’ ” ");
INSERT INTO klg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aw nyanaw ya duwa ya umagakan nan aw kyinita' nilan ya nati na asnu na pig-eket adti suwangan na balay dun ni dalan. Aw talana nilan pig-ubad ya eket, ");
INSERT INTO klg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","awun manga utaw na mig-indeg-indeg dun aw nyusip kanilan, “Ananga' mayu ubadan ya nati yan?” ");
INSERT INTO klg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aw tyumubag silan kasiling na pigpamene' ni Jisus kanilan. Aw pigtumbay kanilan na manga utaw na dala͡en nilan ya nati na asnu. ");
INSERT INTO klg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pigguyud nilan adti kan Jisus aw pig-apidan nilan na manga kadégkadég, aw syumakay si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aw sa talana nilan nyanaw, awun madég na utaw adti ma-una na migpansiladlad dun ni dalan sa kadégkadég kay yan ya palangad pagpamasa nilan kan Jisus. Aw ya eped na manga utaw migpanladlad silan adti dalan sa manga sanga na madég ya dawun na pigpan-utud nilan adti magalet. ");
INSERT INTO klg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ya manga utaw na nyuna kan Jisus aw ya nyakamoli kanan, alag silan migpansideyen na maglong, “Hosana! Ini la ya Pigpadala na Tyumanem dun ni ngalan nan, aw umba' sakanan deyen! ");
INSERT INTO klg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yeiy ya maghari' adti trunu na tyugbulan tadun na si Dabid aw umba' sakanan deyen! Hosana! Aw deyen ya Tyumanem na awun ni tas na langit!” ");
INSERT INTO klg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagdateng da nilan adti Jérusalim, syumeled si Jisus adti pamanag na Témplo, aw pigtandawan nan ya kadég na awun dun. Tigkas yan, lyumuwa' sakanan kay ambung da aw lyumiku' silan ya sampulu' tag duwa ya umagakan nan adti Bétaniya. ");
INSERT INTO klg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkamaselem da, nyindeg silan adti Bétaniya aw syuminan adti Jérusalim. Aw sa pagpanaw nilan, nyagetem si Jisus, aw ");
INSERT INTO klg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","adti mawatawat awun kyinita' nan na kawuy na igira na to-o dyumawun. Migpalapit si Jisus na un nan tanawun pagaw awun bunga. Pagdateng nan adti kawuy, wala' ya kyinita' nan na bunga, olo' manga dawun, kay beke' pa na timpu na timpamunga. ");
INSERT INTO klg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yanagaw piglongan ni Jisus ya kawuy, “Lekat adun na allaw yeiy, dili' da kaw makapamunga!” Aw dyengeg na manga umagakan nan ya kanan piglong. ");
INSERT INTO klg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagdateng nilan adti Jérusalim, syumeled si Jisus adti dakula' na pamanag na Témplo aw pigpalekat nan ya pag-alilin sa manga utaw na nyampamaligya' aw nyampamayad. Pigpantuwad nan ya manga lamisa na manga maglaliwanay sa kuwalta aw ya manga ingkudanan na manga mamaligya-ay sa kalupati. ");
INSERT INTO klg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aw wala' nan tumbayan sa manga utaw na magdala sa pangkay unu dun ni pamanag na Témplo. ");
INSERT INTO klg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pagkatigkas yan, pigpalekat nan ya pagpalna-u kanilan, law nan, “Yéiy ya pigpasulat na Tyumanem asini muna: ‘Ya kanak balay pagtawagen na panawagtawaganan na manga utaw lekat adti kadég na banwa.’ ‘Manang pig-imo' mayu baling tagu-anan sa manga mangkatakaw.’ ” ");
INSERT INTO klg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aw ya piglong ni Jisus dyengeg na manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin. Aw dun da lekat na pigbantakan nilan si Jisus na un patayen kay nyangkallek silan kanan asuntu sa kadég na utaw na migleya migpakanyeg sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa pagkamagsiklep da, nyindeg si Jisus aw ya kanan manga umagakan dun ni syudad. ");
INSERT INTO klg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkamaselem da, lyumiku' silan adti Jérusalim aw kyinita' nilan ya kawuy na igira na nyalanes da lekat adti dalid taman adti dawun. ");
INSERT INTO klg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aw kya-anenganengan ni Pédro ya piglong ni Jisus, aw law nan, “Kay Magpalna-uway, tandawi pagaw! Ya kawuy na igira na kyatullunan sa tingeg mu kagabi, nyalanes da!” ");
INSERT INTO klg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aw miglong si Jisus kanilan, “Pangintu-u kamu sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Matinaw saba ya un ku paglongun kamayu: Pangkay singalan ya maglong sa buntud ini, ‘Kay Buntud, ka-alin kaw aw kawas kaw adti dagat,’ kun awun pagpangintu-u nan aw dili' magduwaduwa na ma-imo' yeiy, ma-imo' saba ya piglong nan. ");
INSERT INTO klg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yanagaw paglongun ta kamu: Pangkay unu ya sekaten mayu adti Tyumanem magi sa pagpanawagtawag, pangintu-uwi na madawat mayu, aw matagtun mayu saba. ");
INSERT INTO klg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Manang kun manawagtawag kamu adti Tyumanem aw awun utaw na pigkalatan mayu na ginawa, una mayu silan pasinsiyayi pada lanasen uman na Ama mayu adti tas na langit ya kamayu manga sala'.” ");
INSERT INTO klg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kun dili' mayu pasinsiya͡an ya kanilan pig-imo' kamayu na malatay, dili' uman lanasen na Ama mayu adti tas na langit ya kamayu manga sala'. ");
INSERT INTO klg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aw pagdateng nilan salut adti Jérusalim, talana ni Jisus nyanaw adti pamanag na Témplo, dyumulud kanan ya manga mangkatas na magdadugsu-ay, ya manga magpalna-uway sa Uldin, aw ya manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aw nyusip silan kanan, law nilan, “Unu ya katundanan mu na du-an pig-alilinan mu ya manga utaw asini Témplo? Aw singalan ka' ya nyatag kanmu sa katundanan na imo-un mu ya maynan?” ");
INSERT INTO klg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Manang miglong si Jisus kanilan, “Musip aku uman kamayu, aw kun matubag mayu ya usip ku, na, ubat ku uman kamayu kun ayin lekat ya katundanan ku sa pag-imo' sa kadég yeiy. ");
INSERT INTO klg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ini ya kanak usip kamayu: Ayin lekat ya katundanan ni Juan sa pagba͡utismu nan sa manga utaw? Unu, lekat adti Tyumanem aw olo' lekat adti utaw? Na, tubaga aku mayu.” ");
INSERT INTO klg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aw mig-usip-usipay silan, “Unu ya un tadun tubag kanan? Kun tubagen tadun na ‘lekat adti Tyumanem,’ maglong sakanan kanaten, ‘Ananga' wala' kamu pangintu-u kanan?’ ");
INSERT INTO klg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aw kun tubagen tadun ‘lekat adti utaw,’ na, unun tadun yan?” Nyallek silan sa manga utaw na migbantay kanilan dun ni Témplo, kay pyangintu-uwan na kadég na utaw na si Juan propita sakanan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yanagaw tyumubag silan kan Jisus, “Enday, wala' nami ka-ede-i.” Aw miglong si Jisus kanilan, “Dili' ta kamu uman ubatan kun singalan ya nyatag kanak sa katundanan na ma-imo' ku ya maynan.” ");
INSERT INTO klg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aw migpalekat si Jisus mig-ubat-ubat adti manga magdadumala͡ay sa manga Judiyu magi sa pundinganan, law nan, “Awun sambuk na tagtun sa lupa' na migpatanem sa madég na balagen na paras, aw dayaw nan yeiy pigpalibedan na alad. Aw migpa-imo' sakanan sa pigisanan sa manga bunga na paras. Aw migpatulluk uman sa matas na tunggu-anan. Pagkatigkas yan, pigpasa-upan nan ya parasan nan. Aw nyanaw sakanan adti sambuk na banwa. ");
INSERT INTO klg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pagdateng na allaw na migpa-ipu' da sa bunga na paras, migsugu' ya tagtun sa sambuk na sugu-anen nan adti manga pigpasa-up sa parasan kay kaliman nan kamangen ya kanan bagi'. ");
INSERT INTO klg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Manang pagdateng na sugu-anen nan dun, pigdulus nilan baling, aw byadasan pyanumbag, aw pigpa-uli' nilan na wala' ya dyala. ");
INSERT INTO klg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Aw migsugu' da uman na tagtun ya sambuk na sugu-anen nan. Manang wala' nilan basabasayi, aw pigbunalan baling nilan ya ulu nan. ");
INSERT INTO klg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tigkas yan, pigsugu' pa nan uman ya sambuk na sugu-anen aw pigpatay nilan. Aw madég pa uman ya pigsugu' nan. Ya eped piglabet nilan aw ya eped pigpatay. ");
INSERT INTO klg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Na, awun dakman sambuk na wala' pa nan sugu-a. Yan ya ise' nan na eseg na to-o nan pigginawa͡an. Miglong ya tagtun adti anenganeng nan, ‘Kun ise' ku ya madtu, un nilan yan basa͡an.’ Yanagaw pigsugu' nan ya kanan ise'. ");
INSERT INTO klg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Manang sa pagkita' na manga sa-up kanan, miglong silan, ‘Ini ya ise' na tagtun! Na! Naten sakanan patayen aw matagtun da tadun ya parasan na un ayawan kanan.’ ");
INSERT INTO klg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yanagaw pigdulus nilan sakanan aw pigpatay nilan. Tigkas yan, pig-agbel nilan ya lawas nan adti luwa' na parasan.” ");
INSERT INTO klg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aw miglong si Jisus, “Na, unu ya imo-un na tagtun sa parasan? Kadtuwan nan ya manga sa-up aw alag nan saba patayen! Aw pasa-up nan ya parasan adti eped na manga utaw. ");
INSERT INTO klg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ananga' wala' mayu kalabeti ya pigpasulat na Tyumanem asini muna? ‘Ya dakula' na batu na iman na manga panday aw wala' ya guna, yan baling ya batu na sumalem na nya-imo' tullukanan sa dakula' na balay. ");
INSERT INTO klg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ya pig-imo' yeiy na Tyumanem to-o madyaw aw nyakapa-enneng-enneng kanaten.’ ” ");
INSERT INTO klg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pagdengeg na manga magdadumala͡ay sa manga Judiyu sa pundinganan ni Jisus, kya-ede-an nilan na silan ya pigpalabet nan. Aw kaliman nilan galu dakepen si Jisus manang nyallek silan sa manga utaw dun. Yanagaw pig-indegan da nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wala' kadugay, pigsugu' na manga magdadumala͡ay sa manga Judiyu adti kan Jisus ya eped na manga Parisiyo aw manga utaw na lekat adti partido ni Hérodés. Kay kaliman nilan kalitagan si Jisus dun ni tubag nan. ");
INSERT INTO klg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aw sa pagdateng nilan dun, miglong silan kanan, “Kay Magpalna-uway, kya-ede-an nami na ya kadég na piglong mu alag matinaw, aw wala' ya pigkibang mu sa manga utaw pangkay singalan pa silan. Aw gayed mu pigpalna-u ya tengteng pagkaliman na Tyumanem. Yanagaw, awun usip nami kanmu. Adti kanmu anenganeng, unu, pigtumbay adti Uldin tadun na manga Judiyu ya pagbayad sa buwis adti kan César aw dili'?” ");
INSERT INTO klg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Manang kya-ede-an ni Jisus ya pagtallalingu nilan, yanagaw law nan kanilan, “Ananga' aku mayu tanda-en? Dalayi aku na kuwalta pada tanawun ku.” ");
INSERT INTO klg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aw pigdala͡an nilan si Jisus na kuwalta, aw pig-usip nan silan, “Kan yeiy gya ya ini? Aw kan yeiy uman ngalan ya nyakasulat asini kuwalta?” Tyumubag silan, “Kan César.” ");
INSERT INTO klg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aw miglong si Jisus kanilan, “Na, atagan mayu adti kan César ya umba' sa kan César aw atagan adti Tyumanem ya umba' sa Tyumanem.” Aw to-o silan nya-enneng-enneng sa tubag nan. ");
INSERT INTO klg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pagkatigkas yan, awun manga Sadusiyo na dyumulud kan Jisus. Na, wala' silan pangintu-u na awun pagkataw na manga utaw lekat adti pagkamatay. Yanagaw nyusip silan kanan, ");
INSERT INTO klg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kay Magpalna-uway, pigsulat kanaten ni Moysis asini muna ya sugu' yeiy adti Uldin tadun: ‘Kun awun eseg na nyatay, aw kun wala' silan ya ka͡ubayan nan paka-ise', pangugnanen na inulug na eseg ya nyabalu pada ya mangayse' nilan ma-imo' da buwadbuwad na inulug nan na nyatay da.’ ");
INSERT INTO klg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, awun pitu ya mangkaylug na eseg. Ya magulang sa kadég nilan, nyangugnan sa ka͡ubayan. Manang wala' silan paka-ise'. Aw nyatay ya eseg yan. ");
INSERT INTO klg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yanagaw ya balu pigpangugnan da na mangud na eseg nan, manang wala' uman silan paka-ise' aw uman da nyatay ya eseg yan. Aw maynan uman ya nya-imo' adti katlu na kaylug nan. ");
INSERT INTO klg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ya tagsambuksambuk na mangkaylug nyabus nyangugnan sa ka͡ubayan na magulang nilan, aw pangkay pitu silan manang alag silan nyatay na wala' paka-ise'. Pagkatigkas yan, nyatay da uman ya ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ya usip nami kanmu: Pagdateng da na allaw na pagmataw sa manga utaw lekat adti nyangkamatay, singalan ya tengteng eseg na ka͡ubayan yan? Kay awun pitu ya eseg na nyangugnan kanan.” ");
INSERT INTO klg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aw tyumubag si Jisus kanilan, “Yan saba ya du-an na nyangkasayep kamu, kay wala' mayu kalabeti ya pigpasulat na Tyumanem asini muna aw wala' mayu uman ka-ede-i ya katulus nan. ");
INSERT INTO klg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kay dun ni allaw na matawun ya manga utaw lekat adti pagkamatay, dili' da silan mangugnan, kasiling saba na anghil na awun ni tas na langit. ");
INSERT INTO klg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aw ya pagmataw sa manga utaw lekat adti pagkamatay, unu, wala' ka' mayu kabasa dun ni pigsulat ni Moysis ya piglong na Tyumanem lekat adti tagbi' na kawuy na lyumaga? Ini ya piglong nan: ‘Aku ya Tyumanem ni Abraham, aw ya Tyumanem ni Isaak, aw ya Tyumanem ni Jakub.’ ");
INSERT INTO klg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yan ya kakawasan nan, pangkay nyatay da silan manang adti asdangan na Tyumanem kenne' na utaw pa silan aw gayed nilan pigsimba ya Tyumanem. Alag kamu nyangkasayep!” ");
INSERT INTO klg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, awun sambuk na magpalna-uway sa Uldin na migpakanyeg sa balawbalaw nilan. Pagdengeg nan sa tubag ni Jisus na to-o madyaw, nyusip sakanan uman, law nan, “Unu ya to-o matas na sugu' na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tyumubag si Jisus kanan, “Yéiy ya sugu' na to-o matas: ‘Kamu na manga utaw na Isra-él, dayaw mayu pakanyegi! Ya Tyumanem na kanaten Pangulu sambuk da. ");
INSERT INTO klg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ginawa͡an mu ya Tyumanem na kanmu Pangulu sa kadakula' na pagka-utawun mu, aw sa kadakula' na ginawa mu, aw kadakula' na anenganeng mu, aw kadakula' na kabagseg mu.’ ");
INSERT INTO klg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aw yeiy ya kadwa na sugu' na to-o matas: ‘Ginawayi ya eped mu na utaw kasiling na pagginawa mu sa kanmu pagka-utawun’. Wala' da ya eped na sugu' na matas pa sa duwa yeiy.” ");
INSERT INTO klg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Miglong pa uman ya magpalna-uway sa Uldin adti kan Jisus, “Kay Magpalna-uway, matinaw saba ya tubag mu kay miglong kaw, ‘Ya Tyumanem sambuk da, aw wala' ya eped.’ ");
INSERT INTO klg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aw matinaw uman ya piglong mu na to-o matas ya sugu' na ginawa͡an ya Tyumanem sa kadakula' na pagka-utawun, aw sa kadakula' na anenganeng, aw sa kadakula' na kabagseg, aw ginawa͡an ya eped na utaw kasiling na pagginawa sa kanaten pagka-utawun. Ya pagtuman sa duwa ya sugu' yeiy, to-o pa saba matas kay sa kadég na dugsu' adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagdengeg ni Jisus na matinaw ya tubag nan, miglong sakanan, “Malapit da kaw maka-akup adti Kasakupan na Pighari-an na Tyumanem.” Aw lekat dun, wala' da ya utaw na nyaka-eles nyusip kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Talana ni Jisus migpalna-u dun ni pamanag na Témplo, miglong sakanan adti manga utaw na migpakanyeg, “Ya manga magpalna-uway sa Uldin, ananga' gayed silan maglong na ya Kristu, yan ya buwadbuwad ni Dabid? ");
INSERT INTO klg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kay si Dabid saba ya miglong magi sa Ispiritu Santo asini muna, law nan: ‘Miglong ya Tyumanem adti kanaken Pangulu: “Ingkud kaw apit adi kalintu ku menda' na mabus ku degen ya manga po-on mu aw alag ku silan betang adti salad na siki mu.” ’ ");
INSERT INTO klg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, dun da si Dabid paglong na ya Kristu yan ya kanan Pangulu. Yanagaw kun pigtawag ni Dabid ya Misiyas na ‘Pangulu,’ pig-unu na Misiyas ya pagka-imo' buwadbuwad ni Dabid?” Aw madég ya migpakanyeg kan Jisus, aw to-o silan migleya sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aw dun ni palna-u nan, miglong pa uman si Jisus, “Magpakatadeng kamu sa manga magpalna-uway sa Uldin. Magkalim silan magsut sa manga malawig na sa-ul. Aw yan ya pagleya͡an nilan ya pagbasa͡an na manga utaw adti manga palingki. ");
INSERT INTO klg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aw dun uman ni manga sinagoga aw manga dakula' na pista, pagkaliman nilan ya mingkud adti ingkudanan na manga dengganen. ");
INSERT INTO klg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Madugay silan magpanawagtawag pada kita-en na manga utaw, manang pig-agaw baling nilan ya ka-unan na manga balu. Ya manga utaw yeiy, silan ya dumawat sa mabegat to-o na pa-emel-emel na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Talana ni Jisus nyingkud malapit adti uluganan sa kuwalta dun ni Témplo, pigtandawan nan ya madég na utaw na nyan-ulug sa kuwalta. Aw awun manga mayaman na nyan-ulug sa madég na kuwalta. ");
INSERT INTO klg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aw dyumateng ya sambuk na ka͡ubayan na balu na wala' ya pagkamangan, aw mig-ulug uman sa duwa ya sinsilyo na tagbi' to-o ya alaga'. ");
INSERT INTO klg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pigtawag ni Jisus ya kanan manga umagakan, law nan, “Matinaw saba ya un ku paglongun kamayu: Ya balu iyan pangkay wala' ya pagkamangan nan, manang dakula' pa ya kanan pig-atag kay sa kadég na utaw na nyatag sa madég na kuwalta. ");
INSERT INTO klg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay ya kanilan pig-atag, sobla la olo' na kuwalta nilan, manang ya ka͡ubayan iyan, pig-ubus nan pig-atag ya kadakula' na nyatagtun nan.” ");
INSERT INTO klg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na, pagluwa' da ni Jisus adti Témplo, miglong kanan ya sambuk na umagakan nan, “Kay Magpalna-uway, tandawi ya manga mangkabakla' na batu na pig-imo' Témplo! To-o madyaw ya pagka-imo' na kadég!” ");
INSERT INTO klg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aw miglong si Jisus, “Ya Témplo na pigkita' mayu adun aw eped pa iyan ni pamanag, dumateng ya allaw na mabus silan magkalat. Ya manga mangkabakla' na batu na pig-ilantulantu iyan, ya kadég yeiy alag saba mangkagettan.” ");
INSERT INTO klg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pagkatigkas yan, tyumukud si Jisus adti Buntud na Manga Olibo dun ni dipag na Témplo aw nyingkud dun. Aw dyumulud kanan si Pédro, si Santiago, si Juan aw si Andrés, aw nyusip silan kan Jisus, ");
INSERT INTO klg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ubati kami kun kinunu katuman ya kadég na piglong mu kakayna. Aw unu ya pangilala na agpet da ya allaw yan?” ");
INSERT INTO klg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aw tyumubag si Jisus, “Magpakatadeng kamu pagaw awun magpasuway kamayu. ");
INSERT INTO klg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kay awun madég na utaw na un dumateng na dumala sa kanak ngalan aw maglong silan, ‘Aku saba ya Misiyas’ aw madég ya gawayan nilan. ");
INSERT INTO klg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aw makadengeg kamu sa manga dakula' na tanam na malapit adti kamayu aw manga ubat-ubat uman sa tanam adti eped na manga banwa, manang dili' kamu magkallek. Ka-ilangan una ma-imo' ya kadég yeiy manang beke' pa nan ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kay ya sambuk na nasud manubbuk sa eped na nasud, aw ya sambuk na kasakupan tumanam sa eped na kasakupan. Awun manga linug adti madég na banwa aw dumateng ya dakula' na getem. Aw olo' pa yan pagpalekat sa pagti-is na un dumateng, kasiling na ka͡ubayan na bagu pyetesan. ");
INSERT INTO klg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Magpakatanaw kamu! Kay awun manga utaw na malim maglimanda aw magdala kamayu adti usayanan. Aw badasan kamu nilan na lalabet dun ni seled na sinagoga nilan. Asuntu sa pagpangintu-u mayu kanak, un kamu nilan pa-indegen adti asdangan na manga gubirnador aw manga hari', aw dun da kamu pakaselat pagpa-ede' kanilan sa Madyaw na Ubat-ubat kanak. ");
INSERT INTO klg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aw sa dili' pa dumateng ya katigkasan, ka-ilangan una pa-ede' adti kadég na manga banwa ya Madyaw na Ubat-ubat. ");
INSERT INTO klg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yanagaw kun pandakepen kamu aw pan-usipen na mag-usayay, dili' magkakamang ya ginawa mayu sa un mayu tubag. Kay dun ni udas yan, ya Ispiritu Santo yan ya maggagad sa kamayu anenganeng sa un mayu tubag kanilan. ");
INSERT INTO klg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Dun ni manga allaw yan, awun manga mangkaylug na magtumbay sa inulug nan adti manga po-on pada patayen. Aw maynan uman awun manga ama na magtumbay sa kanilan ise' na patayen. Aw awun manga ise' na matu sa mangkatikadeng nilan aw magtumbay kanilan adti manga po-on pada patayen. ");
INSERT INTO klg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aw dumutan kamu na madég na manga utaw asuntu sa pagdalug mayu kanak. Manang pangkay singalan ya magpadeleg dun ni pagpangintu-u nan kanak taman adti katigkasan, yan saba ya utaw na paluwa-en na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na, dun ni manga allaw yan, awun kita-en mayu na to-o malatay aw kallekanan adti seled na Témplo na Tyumanem na dili' galu umba' kita-en dun. Aw kamu na magbasa, kalabetan galu mayu ya kakawasan. Kun kita-en da mayu ya maynan adti Témplo, kamu na awun ni Judiya, maksay kamu palaguy adti manga buntud. ");
INSERT INTO klg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kun awun utaw adti luwa' na balay, dili' da sakanan magliku' adti seled na un kumamang sa pangkay unu. ");
INSERT INTO klg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aw kun awun utaw na magtalabahu adti pawa' nan, dili' da sakanan mag-uli' na un mangay sa kadégkadég nan. ");
INSERT INTO klg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Makalalat ya manga ka͡ubayan na mabdes aw ya manga kalmukan dun ni manga allaw yan. ");
INSERT INTO klg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Panawagtawag kamu adti Tyumanem na dili' yeiy galu ma-imo' dun ni bulan na to-o maniki'. ");
INSERT INTO klg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kay dun ni manga allaw yan, ya un kagamakan na manga utaw to-o pa yeiy mabegat kun pa-unawa sa manga kyagamakan na manga utaw asini tas na lupa' lekat pa na pag-imo' na Tyumanem sa kadakula' na banwa aw pangkay sa manga dumadateng pa. ");
INSERT INTO klg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kun wala' pa na Tyumanem uwa-i ya manga allaw yan na to-o malug, wala' ya utaw na masama' asini tas na lupa'. Manang asuntu sa kallat nan sa manga utaw na pigpamalli' nan, wala' nan pakadugaya ya manga allaw yan. ");
INSERT INTO klg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Aw dun ni manga allaw yan, kun awun utaw na maglong kamayu, ‘Tanawa! Ini la ya Kristu!’ aw maglong ya sambuk, ‘Awun da kunu ya Kristu!’ Manang dili' mayu silan pagpangintu-uwan. ");
INSERT INTO klg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kay awun dumateng na sallong kunu Kristu. Aw awun uman dumateng na sallong kunu manga propita na Tyumanem. Magpakita' silan sa manga pangilala aw milagru pada pasuwayen ya manga pigpamalli' da na Tyumanem kun mabatug. ");
INSERT INTO klg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yanagaw magpakatanaw kamu! Pig-ubatan ta kamu dadan sa kadég yeiy pada ka-ede-an da mayu. ");
INSERT INTO klg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na, pagkatigkas da na dakula' na manga kalugan yan dun ni manga allaw yan, ya sega aw bulan dili' da matag sa kalalamdag. ");
INSERT INTO klg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Aw mangkolug ya madég na manga bitun. Mangkatangkeg ya kadég na awun ni balintenga-an magi sa katulus na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aw pagkatigkas yan, aku na Ise' na Utaw lumiku' na kita-en dun ni labun na ka-agadan na dakula' na kalalamdag aw katulus na pagka Tyumanem ku. ");
INSERT INTO klg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aw sugu-un ku ya manga anghil aw madtu silan ni silatan aw adti sallepan aw adti balabagan na kadakula' na banwa, aw un nilan angayen aw pantipunun ya manga utaw na pigpamalli' da ku. ");
INSERT INTO klg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na, anenganenga mayu ya pundinganan sa kawuy na igira: Kun ya sanga manalingsing aw dumawun da, ka-ede-an mayu na agpet da ya manga bulan na to-o mapasu'. ");
INSERT INTO klg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aw maynan uman, kun kita-en mayu ya kadég na piglong ku kamayu, dun da mayu ka-ede-i na malapit da ya pagliku' ku. ");
INSERT INTO klg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Matinaw ya un ku paglongun kamayu: Ya manga utaw asini tas na lupa' adun na allaw yeiy, dili' pa silan mabus mangkamatay menda' na matuman ya kadég na piglong ku. ");
INSERT INTO klg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pangkay kun ma-uman ya langit aw ya kadakula' na banwa manang ya manga tingeg na piglong ku dili' saba ma-uman. ");
INSERT INTO klg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na, ya allaw aw udas na pagliku' ku, wala' ya utaw na nyaka-ede'. Yan olo' ya nyaka-ede' ya Ama ku na awun ni tas na langit. Pangkay ya manga anghil, aw pangkay aku uman na Ise' nan wala' paka-ede'. ");
INSERT INTO klg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yanagaw magpakatanaw kamu! Aw gayed kamu pagtagilan! Kay wala' mayu ka-ede-i kun kinunu ya pagliku' ku. ");
INSERT INTO klg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kasiling na eseg na un manaw adti mawat na banwa, pigtaligu nan ya kanan balay adti manga sugu-anen nan. Piglongan nan ya tagsambuksambuk kanilan sa un nilan imo-un. Aw pigsugu' nan ya magtatunggu-ay sa tatakep na gayed sakanan magpakatanaw. ");
INSERT INTO klg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Maynan uman kamu, gayed kamu magpakatanaw kay wala' mayu ka-ede-i kun kinunu ya pag-uli' na tagtun sa balay, pangkay ambung, aw tenga-tenga' na gabi, aw pagtaga-uk da na manuk aw kun paka͡allawunun. ");
INSERT INTO klg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pagaw maksay dumateng ya tagtun aw kasaban kamu nan na nyampakatulug. ");
INSERT INTO klg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yanagaw yeiy ya piglong ku kamayu aw paglongun ku adti kadég na utaw: ‘Gayed kamu magpakatanaw.’ ” ");
INSERT INTO klg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na, dakman duwangallaw magpalekat da ya Pista na Paglabay na Anghil na Tyumanem aw ya Pista na Pan na Wala' Patulina. Ya manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin na manga Judiyu, gayed silan mig-anenganeng kun unun nilan ya pagdakep kan Jisus na tagu-tagu', kay kaliman nilan patayen sakanan. ");
INSERT INTO klg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Manang miglong silan, “Dili' tadun yeiy imo-un sa allaw na Pista pagaw magubut baling ya manga utaw.” ");
INSERT INTO klg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, si Jisus aw ya manga umagakan nan nyadtu silan ni baranggay na Bétaniya. Aw kyuman silan adti balay ni Simon na awun ibung idtu muna. Talana ni Jisus kyuman, dyumulud kanan ya sambuk na ka͡ubayan na dyumala sa sabuy na pig-imo' lekat adti batu na alabastro, aw adti seled awun to-o manimbo' na pigngalanan na nardo. Aw dakula' to-o ya alaga' kay wala' ya nyakadali'. Pigbukasan nan ya sabuy aw pig-asagan nan ya ulu ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Manang ya manga utaw dun, sa pagkita' nilan sa pig-imo' na ka͡ubayan yan, ya eped kanilan to-o nyadaman aw miggumudgumud, law nilan, “Syapadan ya manimbo' iyan! ");
INSERT INTO klg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kay ya alaga' nan sangaka͡umay na utaw talabahuwan, aw kun piggalin pa yeiy, ya kuwalta atag galu adti manga utaw na wala' ya pagkamangan.” Aw to-o nilan pigsala' ya ka͡ubayan yan. ");
INSERT INTO klg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Manang miglong si Jisus kanilan, “Pabaya-i mayu sakanan. Ananga' mayu sala-en? Madyaw saba ya pig-imo' nan kanak. ");
INSERT INTO klg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ya manga utaw na wala' ya pagkamangan gayed mayu pig-iyeped, aw pangkay kinunu mayu silan tabangan mabatug mayu saba. Manang aku, dili' da aku madugay asini sayid mayu. ");
INSERT INTO klg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ya ka͡ubayan ini, pig-imo' nan ya kanan mabatug pada mamasa kanak. Aw dun ni pag-asag nan sa manimbo' asini lawas ku, yan ya palangad pagtagilan nan dadan sa kanak lebeng. ");
INSERT INTO klg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Matinaw saba ya un ku paglongun kamayu: Pangkay ayin pa-ede-an ya Madyaw na Ubat-ubat adti kadakula' na banwa, gayed uman ubat-ubat ya pig-imo' nan kanaken pada dili' sakanan kalingawan.” ");
INSERT INTO klg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na, dun ni sampulu' tag duwa ya umagakan ni Jisus, ya sambuk kanilan si Judas Iskariyoti. Aw nyadtu sakanan adti manga mangkatas na magdadugsu-ay pada lubidan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagdengeg nilan sa tud nan, migleya to-o silan, aw pigpakangan nilan si Judas na atagan nilan sakanan na kuwalta. Yanagaw tyumagad si Judas sa selat pada lubidan nan si Jisus adti kanilan. ");
INSERT INTO klg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, dyumateng da ya tagna' na allaw na Pista na Pan na Wala' Patulina. Yeiy ya allaw na magsi-iyaw ya manga Judiyu sa nati na karniro na un nilan kanen dun ni pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem. Nyusip kan Jisus ya manga umagakan nan, law nilan, “Ayin ya kaliman mu pakadtuwan kanami pada tagilanen kanmu ya pangiyambungay sa Pista?” ");
INSERT INTO klg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yanagaw pigsugu' ni Jisus ya duwa ya umagakan nan, law nan, “Kadtu kamu ni Jérusalim. Pagdateng mayu dun, awun sumungun kamayu na sambuk na eseg na dumala sa sibulan na syeledan na tubig. Agad kamu kanan. ");
INSERT INTO klg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aw sa pagseled nan adti balay, paglonga mayu ya tagtun sa balay yan, ‘Nyamene' ya Magpalna-uway: Ayin kunu ya tambi' na un nan pagkanan sa pangiyambungay sa Pista eped nan ya kanan manga umagakan?’ ");
INSERT INTO klg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aw pakita' nan kamayu ya dakula' na gibalayan adti kadwa na kansad na balay na dadan da nilan pigtagilan. Aw dun da kamu pag-imo' sa pangiyambungay tadun.” ");
INSERT INTO klg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yanagaw nyanaw ya duwa ya umagakan ni Jisus adti syudad. Aw pagdateng nilan dun, kyinita' nilan ya kadég na piglong ni Jisus kanilan. Aw pigtagilan nilan ya pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aw sa pagkamagsiklep da, dyumateng si Jisus aw ya sampulu' tag duwa ya umagakan nan. ");
INSERT INTO klg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aw sa talana nilan kyuman, miglong si Jisus kanilan, “Matinaw saba ya un ku kamayu paglongun: Awun sambuk kamayu asini eped ku kyuman na un maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pagdengeg na manga umagakan nan, migkalat to-o ya ginawa nilan. Aw nyusip ya tagsambuksambuk kanilan, “Unu, beke' ku ya pyalabet mu?” ");
INSERT INTO klg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aw tyumubag si Jisus kanilan, “Dun ni kamayu na sampulu' tag duwa, awun sambuk na tyumugmuk sa pan eped ku asini lipung ini na yan ya un maglubid kanak. ");
INSERT INTO klg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aku na Ise' na Utaw un saba patayen kasiling na dadan da pigpasulat asini muna. Manang malatay ya un datengan na utaw na maglubid kanak. Madyaw pa baling kanan ya wala' ka͡utaw asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Talana nilan kyuman, migkamang si Jisus sa pan aw pigpasalamatan nan ya Tyumanem. Tigkas yan, pigtenga-tenga' nan ya pan aw pigpan-atag nan adti manga umagakan nan aw law nan, “Dawata mayu aw kana. Yéiy ya kanak lawas.” ");
INSERT INTO klg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagkatigkas yan, pigkamang nan uman ya tabu' na pigseledan sa bino aw pigpasalamatan nan ya Tyumanem. Aw pigdimil nan kanilan ya tabu', aw nyinem ya tagsambuksambuk kanilan. ");
INSERT INTO klg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aw piglongan nan silan, “Yeiy ya kanak dugu' na un pa-iligen pada sa kadég na manga utaw. Magi sa dugu' ku, yan ya magpa-iganget sa bagu na pakang na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Matinaw saba ya un ku paglongun kamayu: Dili' da ku salutun ya minem sa bino na paras menda' sa allaw na adtu la aku inem sa bagu na bino adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagkatigkas ni Jisus maglong, migdalangan silan sa pagdeyen adti Tyumanem. Aw pig-indegan nilan ya Jérusalim aw tyumukud silan adti Buntud na Manga Olibo. ");
INSERT INTO klg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aw sa dun pa silan ni dalan, miglong si Jisus kanilan, “Ayawan aku na kadég mayu. Kasiling na pigpasulat dadan na Tyumanem: ‘Patayen ku ya magdadiyaga͡ay aw magpanbeklag ya manga karniro nan.’ ");
INSERT INTO klg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Manang mataw aku lekat adti pagkamatay. Aw muna aku kamayu adti Galilya.” ");
INSERT INTO klg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aw miglong si Pédro kanan, “Pangkay ayawan kaw na kadég nilan, manang aku, dili' ta kaw ayawan!” ");
INSERT INTO klg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aw miglong si Jisus kanan, “Matinaw saba ya un ku paglongun kanmu: Kagaya na gabi, sa dili' pa tumaga-uk ya manuk na makadwa, balyaw aku mu na makatlu.” ");
INSERT INTO klg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Manang gayed uman miglong si Pédro, “Beke' yan! Pangkay patayen pa aku nilan eped mu, manang ya magbalyaw kanmu, dili' ku yan ma-imo'!” Aw maynan uman ya piglong na kadég na manga eped nan. ");
INSERT INTO klg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na, dyumateng si Jisus aw ya manga umagakan nan adti banwa na pigngalanan na Gétsémani. Aw miglong si Jisus kanilan, “Ingkud da kamu asini talana ku adtu manawagtawag.” ");
INSERT INTO klg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Manang pigpa-agad nan si Pédro, aw si Santiago, aw si Juan. Aw wala' katingen ya anenganeng ni Jisus, aw to-o migkalat ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aw piglongan nan silan, “Liwan na un da aku matay sangadi sa kakalatan na ginawa ku. Pagtagad pa kamu asini aw pagpulaw kamu.” ");
INSERT INTO klg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aw migpa-awat si Jisus kanilan tagbi'. Aw lyumuhud sakanan adti lupa' aw nyanawagtawag adti Tyumanem na kun mabatug, dili' galu dumateng adti kanan ya pagti-is, ");
INSERT INTO klg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","law ni Jisus, “Kay Ma', mabatug mu saba ya pangkay unu. Kun kaliman mu, kamanga beg kanak ya pagti-is na un ku ka-agiyan. Manang beke' na kanak pagkaliman ya matuman. Yan baling ya matuman ya kanmu pagkaliman.” ");
INSERT INTO klg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagliku' ni Jisus adti tulu ya umagakan nan, kyinita' nan na nyampakatulug da silan. Yanagaw piglongan nan si Pédro, “Kay Simon, ananga' kaw makatulug? Unu, dili' mu mabatug ya pagpulaw pangkay da olo' sangka udas? ");
INSERT INTO klg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pagpulaw kamu aw panawagtawag kamu pada dili' kamu degen na pagtanda'. Kaliman galu na utaw ya manawagtawag, manang pigdeg baling na kalumay na kanan lawas.” ");
INSERT INTO klg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aw migpa-awat da uman si Jisus kanilan aw nyanawagtawag adti Ama nan, aw pigsalut nan ya tagna' na panawagtawag nan. ");
INSERT INTO klg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aw lyumiku' pa salut si Jisus adti kanilan, aw kyinita' nan na uman da silan nyampakatulug, kay to-o silan pigtudtud. Aw wala' nilan ka-ede-i kun unu ya un nilan tubag kanan. ");
INSERT INTO klg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aw katlu ni Jisus lyumiku' adti kanilan, piglongan nan silan, “Unu, kenne' pa mayu kyumulang aw nyakatulug? Umba' da yan! Dyumateng da ya udas na ya Ise' na Utaw un lubidan aw tumbay adti manga makasasala'. ");
INSERT INTO klg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pagbangun kamu! Kitadun da! Iyan da ya utaw na un maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sa talana pa ni Jisus miglong, dyumateng si Judas Iskariyoti. Sambuk sakanan dun ni sampulu' tag duwa ya umagakan ni Jisus. Eped nan ya madég na utaw na nyandala sa kampilan aw babunal. Pigsugu' silan na manga mangkatas na magdadugsu-ay, aw manga magpalna-uway sa Uldin, aw manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, dadan da silan ni Judas pigpa-ede' sa pangilala, law nan, “Ya utaw na alekan ku, yan ya dakepen mayu. Pa-agadan mayu aw dayaw mayu tunggu-i.” ");
INSERT INTO klg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yanagaw pagdateng nilan dun, dyumulud si Judas adti kan Jisus aw miglong, “Kay Magpalna-uway!” Aw pig-alekan nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aw tigkan nilan pigdulus si Jisus aw pigdakep nilan. ");
INSERT INTO klg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aw ya sambuk na utaw na malapit dun, pigtagnus nan ya kanan kampilan, aw pigtibas nan ya sugu-anen na pangulu na manga magdadugsu-ay, aw nya-ilap ya talinga nan. ");
INSERT INTO klg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aw tigkas yan, miglong si Jisus adti manga utaw na migdakep kanan, “Ananga' kamu dumala sa manga kampilan aw babunal? Kasiling kamu na migdakep sa ribildi! ");
INSERT INTO klg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kada allaw awun aku ni Témplo migpalna-u, aw wala' aku mayu dakepa. Manang ka-ilangan na ma-imo' yeiy pada matuman ya pigpasulat dadan na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aw ya manga umagakan ni Jisus, nyabus silan nyampamalaguy aw pig-ayawan nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Awun sambuk na bata' na dyumalug adti moli ni Jisus, aw olo' migkulimot sa kayab. Pigdakep galu uman nilan, ");
INSERT INTO klg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","manang kya-ayawan ya kayab nan aw nyakapalaguy sakanan na wala' ya kadégkadég. ");
INSERT INTO klg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pagkatigkas yan, pigpa-agad nilan si Jisus adti balay na pangulu na manga magdadugsu-ay. Aw migpangkatipun dun ya kadég na mangkatas na magdadugsu-ay, aw manga magdadumala͡ay sa manga Judiyu, aw manga magpalna-uway sa Uldin. ");
INSERT INTO klg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aw dyumalug si Pédro kanilan manang migpa-awatawat kan Jisus aw taman da olo' sakanan dun ni pamanag na balay na pag-usayan. Aw talana nilan adti seled, nyingkud si Pédro dun ni sayid na manga magtatunggu-ay malapit dun ni atulun kay nyanalang sakanan. ");
INSERT INTO klg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, adti seled, dun ya manga mangkatas na magdadugsu-ay aw ya kadég na matas na mag-usayay. Aw gayed silan nyaninaw sa utaw na magtanemtanem sa mabegat na sala' adti kan Jisus, manang wala' ya kyinita' nilan na puliba na umba' sakanan patayen. ");
INSERT INTO klg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pangkay awun madég na utaw na migmatinaw sa galu' adti kanan, manang wala' pag-unawa ya ubat-ubat nilan. ");
INSERT INTO klg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aw awun uman manga eped na utaw na nyindeg adti asdangan na kadég nilan aw migmatinaw silan sa galu' adti kan Jisus, law nilan, ");
INSERT INTO klg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dyengeg nami ya utaw yeiy na miglong, ‘Kalaten ku ya Témplo ini na pig-imo' na utaw, aw seled na tulungallaw, pa-indegen ku ya bagu na wala' imo-a na utaw.’ ” ");
INSERT INTO klg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pangkay maynan ya pig-ubat nilan, manang kenne' na wala' pag-unawa ya piglong nilan. ");
INSERT INTO klg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pagkatigkas yan, nyindeg ya pangulu na manga magdadugsu-ay adti asdangan na kadég, aw nyusip kan Jisus, “Unu, wala' ya tubag mu sa diklamu nilan kanmu?” ");
INSERT INTO klg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Manang wala' si Jisus tubag kanan. Aw pig-usip da nan uman, “Unu, ikaw ka' ya Kristu, ya Ise' na Tyumanem na To-o Pagdeyen?” ");
INSERT INTO klg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aw tyumubag si Jisus, “E-e, aku saba. Aw kita-en mayu aku na Ise' na Utaw na mingkud apit adti kalintu na Tyumanem na To-o Matulus. Aw kita-en aku mayu uman na lumiku' na ka-agadan na manga labun.” ");
INSERT INTO klg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagdengeg na pangulu na manga magdadugsu-ay sa tubag ni Jisus, pigkésé' nan ya kanan sa-ul kay to-o sakanan nyadaman, aw miglong, “Ananga' pa kitadun maninaw sa eped na un magmatinaw? ");
INSERT INTO klg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dyengeg da mayu saba ya piglong nan na malatay adti Tyumanem. Migpa-unawa sakanan sa Tyumanem! Na, unu ya kamayu pagbaya'?” Yanagaw, pig-ukuman nilan si Jisus na umba' sakanan patayen. ");
INSERT INTO klg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aw ya eped kanilan migpalekat mig-eleb-eleb kan Jisus. Aw pigtampeng nilan ya mata nan aw pigbadasan nilan na sumbag, aw law nilan, “Na, ubatan kanami kun singalan ya migsumbag kanmu!” Tigkas yan, pigkamang na manga magtatunggu-ay si Jisus aw gayed nilan pigpanampal. ");
INSERT INTO klg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na, talana ni Pédro adti pamanag na balay, awun sambuk na ka͡ubayan na dyumateng na yeiy ya sugu-anen na pangulu na manga magdadugsu-ay. ");
INSERT INTO klg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aw sa pagkita' nan kan Pédro na nyanalang, pigtengtengan nan aw miglong, “Ikaw uman ya eped ni Jisus na taga Nasarit!” ");
INSERT INTO klg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Manang migbalyaw si Pédro, law nan, “Wala' ku ka-ede-i ya piglong mu!” Aw mig-alin si Pédro adti suwangan na pamanag. Aw tigkas yan tyumaga-uk ya manuk. ");
INSERT INTO klg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wala' kadugay, kyinita' da uman na sugu-anen si Pédro, aw miglong adti manga utaw dun, “Ya eseg iyan, eped nilan saba!” ");
INSERT INTO klg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Manang uman da ni Pédro pigbalyaw. Aw wala' kadugay, miglong kan Pédro ya manga utaw dun na mig-indeg-indeg, “Matinaw saba na ikaw ya sambuk kanilan, kay ya linitukan mu kasiling na taga Galilya.” ");
INSERT INTO klg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aw pigpalekat ni Pédro ya migsapa', law nan, “Matay pa aku! Wala' ku saba kilala͡a ya utaw yan na piglong mayu.” ");
INSERT INTO klg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aw dyengeg nan ya kadwa na pagtaga-uk na manuk, aw dun da ni Pédro ka-anenganengi ya piglong ni Jisus kanan, “Sa dili' pa tumaga-uk ya manuk na makadwa, balyaw aku mu na makatlu.” Aw migkalat ya ginawa ni Pédro aw to-o sakanan migsugaw. ");
INSERT INTO klg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na, pagkamaselem da, migkasambuk ya ginawa na manga mangkatas na magdadugsu-ay, aw manga magdadumala͡ay sa manga Judiyu, aw manga magpalna-uway sa Uldin, aw kadakula' na mag-usayay kun unu ya un nilan imo-un kan Jisus. Yanagaw pigpagapus nilan si Jisus, aw pigpa-agad nilan adti kan Pilato na yan ya gubirnador na taga Roma. ");
INSERT INTO klg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aw pig-usip ni Pilato si Jisus, “Unu, ikaw ya hari' sa manga Judiyu?” Aw tyumubag si Jisus, “Piglong da mu.” ");
INSERT INTO klg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pagkatigkas yan, pig-ubat na manga mangkatas na magdadugsu-ay kan Pilato ya madég na diklamu nilan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yanagaw nyusip pa si Pilato kanan, “Wala' ka' ya matubag mu sa manga piglong nilan? To-o madég ya manga diklamu nilan kanmu.” ");
INSERT INTO klg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Manang wala' da tubag si Jisus. Aw nyabelengbeleng kanan si Pilato. ");
INSERT INTO klg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, awun katanem na gubirnador na kada umay dun ni Pista na Paglabay na Anghil na Tyumanem, magpaluwa' sakanan sa sambuk na nyakalabusu na kaliman na manga utaw paluwa-en. ");
INSERT INTO klg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aw dun ni kalabusuwanan awun manga utaw na nyakalabusu asuntu na nyatu silan sa gubirno aw awun manga pigpatay nilan. Ya sambuk kanilan pigngalanan na si Barabas. ");
INSERT INTO klg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aw migpangkatipun ya madég na utaw adti kan Pilato, kay ya tud nilan sekaten adti kanan na imo-un nan uman adun na umay ya kanan katanem na magpaluwa' sa sambuk na utaw na pigkalabusu. ");
INSERT INTO klg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aw nyusip si Pilato kanilan, “Unu, kaliman mayu na paluwa-en ku kamayu ya hari' sa manga Judiyu?” ");
INSERT INTO klg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kay kya-ede-an ni Pilato na to-o nyinga' kan Jisus ya manga mangkatas na magdadugsu-ay aw yan ya du-an na pigtumbay nilan si Jisus adti kanan. ");
INSERT INTO klg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Manang pigdegdeg na manga mangkatas na magdadugsu-ay ya madég na manga utaw na yan ya sekaten nilan si Barabas. ");
INSERT INTO klg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aw nyusip pa si Pilato kanilan, “Kun paluwa-en ku si Barabas, unun ku ya utaw yeiy na pagtawagen mayu na Hari' na manga Judiyu?” ");
INSERT INTO klg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aw tyumubag ya kadég nilan, “Pakalabuwan sakanan adti krus!” ");
INSERT INTO klg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aw miglong pa si Pilato, “Ananga'? Unu ya nya-imo' nan na malat?” Manang to-o la baling silan nyamansag, “Pakalabuwan sakanan adti krus!” ");
INSERT INTO klg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, ya kaliman ni Pilato na magleya kanan ya manga utaw, yanagaw pigpaluwa' nan si Barabas. Manang si Jisus pigpalabet nan aw pigtumbay nan adti kanilan pada pakalabu adti krus. ");
INSERT INTO klg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aw pigdala si Jisus na manga sundalu adti pamanag na palasyo na gubirnador. Aw pigtawag nilan ya kadég na manga sundalu. ");
INSERT INTO klg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aw pigpasut nilan si Jisus sa malawig na sa-ul na tapel ya batek kasiling na pagsutun na hari'. Aw tigkas yan, mig-imo' silan sa korona na suksukun aw pigsangkub nilan adti ulu ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aw pig-odoy-odoy nilan na sallong kunu syumaludu silan kanan, law nilan, “Kay Hari' na manga Judiyu, magkadugay pa galu ya pag-eya' mu asini tas na lupa'!” ");
INSERT INTO klg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aw gayed nilan pigbunalan ya ulu nan na bangka', aw pigpan-eleban nilan si Jisus. Aw lyumuhud silan adti asdangan nan na sallong kunu silan migsimba kanan. ");
INSERT INTO klg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatigkas nilan sakanan odoy-odoyun, pigluwasan nilan sa malawig na sa-ul aw pigliku' nilan pigpasut ya kanan kadégkadég. Aw tigkas yan, pigdala na manga sundalu si Jisus adti luwa' na syudad na un nilan kalabuwan adti krus. ");
INSERT INTO klg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dun ni dalan, pig-isungun nilan ya sambuk na eseg na si Simon na taga syudad na Ciréné, aw pigleges pigpapisan kanan na manga sundalu ya krus ni Jisus. Na, si Simon yan ya ama ni Aléjandro aw ni Rupo. ");
INSERT INTO klg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aw dyala nilan si Jisus adti banwa na pigngalanan na Golgota, na kakawasan: Banwa na Pesa' na Ulu. ");
INSERT INTO klg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagdateng nilan dun, pigdimilan nilan si Jisus na bino na pigdali-an na mirra, manang wala' nan dawata. ");
INSERT INTO klg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aw tigkas yan, pigkalabuwan nilan si Jisus adti krus. Aw migbunutbunut ya manga sundalu kun singalan kanilan ya makatagtun sa tagsambuksambuk na kadégkadég ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na, manga alas nibi na maselem ya pagkalabu nilan kan Jisus adti krus. ");
INSERT INTO klg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aw awun pigsulat nilan dun ni tabla na limanda kanan aw pigtapli' nilan adti krus na maglong: “Yéiy ya Hari' na manga Judiyu.” ");
INSERT INTO klg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na, dun ni tampid ni Jisus awun duwa ya ribildi na pigkalabuwan uman adti manga krus nilan, ya sambuk apit adti kalintu aw ya sambuk uman apit adti kawala. ");
INSERT INTO klg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nyatuman agaw ya pigpasulat na Tyumanem asini muna, law nan: “Nyaka-iyeped sakanan sa manga makasasala'.” ");
INSERT INTO klg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aw ya manga utaw na lyumabay dun, mig-odoy-odoy silan kan Jisus aw mig-eleng-eleng silan, law nilan, “Miglong kaw na kalaten mu ya Témplo aw seled na tulungallaw pa-indegen mu uman salut ya bagu. ");
INSERT INTO klg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na! Tabangi ya kanmu pagka-utawun aw panog kaw dun ni krus!” ");
INSERT INTO klg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aw maynan uman, migpan-odoy-odoy kanan ya manga mangkatas na magdadugsu-ay aw ya manga magpalna-uway sa Uldin, law nilan, “Mabatug nan tabangan ya eped, manang dili' nan mabatug tabangan ya kanan pagka-utawun. ");
INSERT INTO klg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Misiyas kunu sakanan aw Hari' sa manga utaw na Isra-él! Kun kita-en nami na manog sakanan dun ni krus, mangintu-u kami kanan!” Aw pangkay ya duwa na eped nan na pigkalabu adti krus, mig-odoy-odoy uman kanan. ");
INSERT INTO klg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pagka-alas dosi la, migkangitngit ya banwa seled na tulungka udas. ");
INSERT INTO klg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pagka-alas trés da na ambung, mig-ulangag si Jisus, law nan, “Éloi, Éloi, lama sabaktani?” Ya kakawasan na piglong nan: “We....Tyumanem ku! We....Tyumanem ku! Ananga' aku mu ayawan?” ");
INSERT INTO klg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sa pagdengeg na manga utaw na malapit dun, miglong ya eped kanilan, “Pakanyegi mayu! Pigtawag nan ya propita na si Éliyas.” ");
INSERT INTO klg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aw sambuk kanilan maksay nyangay sa ispongha aw pig-elem nan adti bino na malagsing. Aw pigbetang nan adti tuktuk na layi' aw pigsungit nan kan Jisus na un pasepsep kanan. Aw miglong sakanan, “Na, tagadan pa tadun! Tanawun naten kun madi si Éliyas pada magpapanog kanan lekat adti krus.” ");
INSERT INTO klg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aw mig-ulangag to-o si Jisus aw nyabugtu' ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aw nyakisay ya to-o madakmel na téla na pigsaliben na awun ni Témplo, aw dayaw nyatenga' lekat adti tas taman adti dalem. ");
INSERT INTO klg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aw ya kapitan na manga sundalu na nyindeg dun ni asdangan na krus, kyinita' nan ya pagkamatay ni Jisus. Aw nyakapaglong sakanan, “Matinaw kadi'! Ya utaw ini, tengteng Ise' na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Awun uman manga ka͡ubayan na migtandaw adti mawatawat. Eped dun ni kanilan si Salomé aw si Maria na taga lunsud na Magdala, aw si Maria na ina ni Santiago aw ni José. ");
INSERT INTO klg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Silan ya eped na manga umagakan ni Jisus na gayed mig-agad-agad kanan. Aw silan ya migsanggila' kanan talana na adtu pa silan ni Galilya. Aw madég pa uman ya eped na manga ka͡ubayan na nyagad kanan adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na, yan ya allaw na magtagilan ya manga Judiyu sa Allaw na Paglagdeng. Aw sa pagkamagsiklep da, ");
INSERT INTO klg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","si José na taga Arimatiya wala' pagduwaduwa kadtu ni kan Pilato, aw pigsekat nan ya lawas ni Jisus. Si José pagbasa͡an na manga eped nan adti matas na usayanan aw migtagad pa uman sa Paghari' na Tyumanem sa Kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sa pagdengeg ni Pilato na nyatay da si Jisus, kyumega' sakanan. Yanagaw pigtawag nan ya kapitan na manga sundalu aw pig-usip nan kun tengteng na nyatay da si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagdengeg ni Pilato sa piglong na kapitan, pigtumbay nan kan José ya pagkamang sa lawas ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pagkatigkas yan, nyayad si José sa téla na linum, aw pigkamang nan ya lawas ni Jisus lekat adti krus aw pigbedbedan nan na téla. Aw pigbetang nan adti seled na ilib na dadan da pigkutkutan adti kilid na pangpang na un paglebengan sa utaw, aw miglilid sakanan sa dakula' na batu pada pagtampeng sa baka' na ilib. ");
INSERT INTO klg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aw pigtandawan ni Maria na taga Magdala aw si Maria na ina ni José, yanagaw pigka-ede-an nilan kun ayin lebengan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagkatigkas da na Allaw na Paglagdeng, si Maria na taga Magdala, aw si Maria na ina ni Santiago, aw si Salomé, nyayad silan sa manimbo' na un asag adti lawas ni Jisus. ");
INSERT INTO klg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aw to-o maselem na allaw na Linggo, nyadtu silan adti piglebengan kanan. ");
INSERT INTO klg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aw sa talana pa nilan dun ni dalan, mig-usip-usipay silan, “Singalan ya un mag-anggin kanaten sa batu lekat adti baka' na ilib?” Maynan ya piglong nilan kay to-o dakula' ya batu na pigtampeng sa baka' na ilib. ");
INSERT INTO klg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Manang sa pag-inunu nilan, kyinita' nilan na nyaka-anggin da adti kilid ya dakula' na batu. ");
INSERT INTO klg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pagseled nilan adti ilib, kyumita' silan sa eseg na bagu pa ya ginawa aw syumut sa to-o maputi' na kadégkadég na nyingkud apit adti kalintu. Aw ya manga ka͡ubayan to-o silan kyumega'. ");
INSERT INTO klg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Manang miglong ya utaw kanilan, “Dili' kamu magkallek! Kya-ede-an ku na pyaninaw mayu si Jisus na taga Nasarit na pigkalabuwan adti krus. Wala' da sakanan asini. Nyataw da! Inunuwa mayu ya pigpakulangan kanan iyan. ");
INSERT INTO klg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, panaw da kamu! Aw ubati mayu ya manga umagakan nan, labi la si Pédro, na nyuna la si Jisus adti Galilya aw dun da mayu kita-a kasiling na pig-ubat nan kamayu idtu muna.” ");
INSERT INTO klg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aw lyumuwa' silan lekat adti ilib aw to-o silan nyalaguy kay migteneb silan aw nya-enneng-enneng. Aw wala' nilan ubat-ubatan ya kyinita' nilan adti eped na utaw kay to-o silan nyallek. ");
INSERT INTO klg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, pagkataw da ni Jisus na to-o maselem na allaw na Linggo, una sakanan migpakita' kan Maria na taga Magdala na yan ya pig-alilinan nan sa pitu ya busaw idtu muna. ");
INSERT INTO klg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aw pigkadtuwan ni Maria ya manga umagakan ni Jisus na kenne' pa na kakalatan na ginawa nilan aw migsugaw. Aw piglongan nan silan na kyinita' nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Manang wala' silan pangintu-u sa piglong nan na nyataw da si Jisus aw migpakita' kanan. ");
INSERT INTO klg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatigkas yan, migpakita' si Jisus adti duwa ya umagakan nan talana nilan nyanaw adti luwa' na syudad, manang wala' nilan maksay kilala͡a kay nyabagu la ya kanan lawas. ");
INSERT INTO klg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sa pagka-ede' da nilan na yan si Jisus, lyumiku' silan adti Jérusalim, aw pig-ubatan nilan ya kanilan manga eped sa kyinita' nilan. Manang ya eped na manga umagakan wala' silan uman pangintu-u kanilan. ");
INSERT INTO klg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aw wala' kadugay, migpakita' si Jisus adti sampulu' taggesya' ya umagakan nan sa talana nilan kyuman. Pigsagda nan silan asuntu na wala' silan pangintu-u aw to-o mategel ya anenganeng nilan pangkay pig-ubatan da silan na manga utaw na nyataw da sakanan. ");
INSERT INTO klg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aw miglong si Jisus kanilan, “Kadtuwi mayu ya kadakula' na banwa, aw pa-ede-a mayu ya kadég na utaw sa Madyaw na Ubat-ubat kanak. ");
INSERT INTO klg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kun singalan ya mangintu-u kanak aw magpaba͡utismu, paluwa-en sakanan na Tyumanem, manang kun singalan ya dili' mangintu-u kanak, ukuman sakanan na pa-emel-emelen. ");
INSERT INTO klg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aw maka-agad ya manga pangilala yeiy sa manga utaw na mangintu-u kanak: Dun ni katulus na kanak ngalan, maka-alilin silan sa manga busaw, aw makapaglong silan sa manga punganan na tingeg na wala' pa nilan lemena paglongan. ");
INSERT INTO klg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aw pangkay kun maka-awid silan sa ulud aw pangkay maka-inem silan sa makababaleng, dili' silan ma-unu. Aw kun pandungan nilan na kanilan palad ya manga pyangkedelan, dayaw silan kaguli-an.” ");
INSERT INTO klg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatigkas ni Jisus na kanaten Pangulu maglong adti manga umagakan nan, nya-engat sakanan adti tas na langit, aw nyingkud apit adti kalintu na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aw nyanaw ya manga umagakan nan, aw piglegeb nilan ya kadég na banwa aw pigpa-ede' nilan ya Madyaw na Ubat-ubat kan Jisus. Aw pangkay ayin silan kadtu, pigtabangan silan na katulus ni Jisus. Aw ya manga milagru na pigpa-imo' nan kanilan, yan ya migmatinaw sa kanilan pig-ubat-ubat. Amén!");
INSERT INTO klg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kay Tyupilo na to-o pagbasa͡an: Madég ya utaw na migtibagseg migsulat sa manga kasampetanen sa manga nyatuman asini kanaten na manga pig-imo' ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pigsulat nilan ya pig-ubat-ubat kanilan na manga utaw na tengteng kyumita' sa kadég na nya-imo' lekat pa idtu muna. ");
INSERT INTO klg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kay Tyupilo, asuntu na to-o ku pigsadsadan ya kadég na nya-imo' lekat pa na idtu muna, nyakabetang adti anenganeng ku na madyaw aw dayaw ku uman tapiden ya pagkasulat adti kanmu. ");
INSERT INTO klg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya tud ku pada to-o mu ka-ede-an na tengteng matinaw ya pig-ubat-ubat da kanmu. ");
INSERT INTO klg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dun ni manga allaw na si Hérodés ya mighari' sa banwa na Judiya, awun sambuk na magdadugsu-ay adti Témplo na Tyumanem na pigngalanan na Zakariyas. Nyaka-akup sakanan adti ugbungan na manga magdadugsu-ay na pigdumala͡an ni Abiyas asini muna. Aw ya ka͡ubayan nan na si Élisabét, buwadbuwad uman ni Aaron. ");
INSERT INTO klg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na, si Zakariyas aw si Élisabét, nyatibulluk silan dyumalug sa pagkaliman na Tyumanem. Pigdalug nilan ya kadég na sugu' dun ni Uldin na pig-atag na Tyumanem asini muna. ");
INSERT INTO klg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Manang wala' ya ise' nilan kay dili' magpaka-ise' si Élisabét aw unud da alag ya ginawa nilan. ");
INSERT INTO klg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na, dyumateng ya simana na kanan Zakariyas da uman ugbungan ya mag-imo' sa manga imo-unun dun ni Témplo na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aw migbunutbunut silan kay yan ya katanem na manga magdadugsu-ay, aw si Zakariyas ya kyabunutan nilan na un magsunug sa insénso adti seled na Tambi' na Pigtani adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aw sa talana nan migsunug sa insénso, awun madég to-o na manga utaw adti luwa' na nyanawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aw migpakita' kan Zakariyas ya sambuk na anghil na Tyumanem na nyindeg apit adti kalintu na sunuganan sa insénso. ");
INSERT INTO klg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkita' nan sa anghil, migteneb sakanan aw to-o nyallek. ");
INSERT INTO klg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Manang miglong kanan ya anghil, “Dili' kaw magkallek, kay Zakariyas, kay dyengeg saba na Tyumanem ya panawagtawag mu. Aw ya ka͡ubayan mu na si Élisabét, un mag-ise' sa eseg, aw Juan ya pagngalan mayu kanan. ");
INSERT INTO klg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","To-o dakula' ya pagleya mu kanan, aw madég uman ya magleya sa pagka͡utaw nan. ");
INSERT INTO klg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kay to-o matas ya imo-unun na un taligu kanan na Tyumanem. Ka-ilangan dili' sakanan mag-inem sa bino aw sa eped pa na inemenen na to-o magpakalangulangu. Matmu' sakanan na Ispiritu Santo pangkay adtu pa sakanan ni seled na buntit na ina nan. ");
INSERT INTO klg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aw madég ya buwadbuwad ni Isra-él na un nan paliku-un adti Tyumanem na kanilan Pangulu. ");
INSERT INTO klg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ya ise' mu, yan ya muna sa Kristu, aw ya katulus na atag kanan na Ispiritu Santo, kasiling saba na kan Éliyas. Aw pa-iyuli-en nan ya manga ama aw kanilan manga mangayse', aw paliku-un nan ya manga utaw na wala' dalug sa pagkaliman na Tyumanem pada makaliku' silan dumalug kanan. Magi sa un nan imo-un, matagilan ya manga utaw sa pagdateng ni Kristu.” ");
INSERT INTO klg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aw piglongan ni Zakariyas ya anghil, “Unun ku ya pagka-ede' na matinaw ya piglong mu kanak? Bakleg da aku. Aw buyag da uman ya ka͡ubayan ku.” ");
INSERT INTO klg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tyumubag kanan ya anghil, “Aku si Gabriyél na gayed mag-indeg adti asdangan na Tyumanem. Pigsugu' aku adi sayid mu na un magpa-ede' sa madyaw na ubat-ubat yeiy. ");
INSERT INTO klg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Manang asuntu na wala' mu pangintu-uwi ya kadég na piglong ku, na, ma-umu kaw menda' na matuman ya kadég na piglong ku kanmu. Aw matuman saba yeiy dun ni allaw na dadan da pigpamalli' na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, ya manga utaw na tyumagad kan Zakariyas adti luwa', nyabelengbeleng silan kun ananga' madugay sakanan adti seled na Tambi' na Pigtani adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aw sa pagluwa' da nan, dili' da sakanan magpakapaglong manang gayed migpulingen kanilan pada pa-ede' na awun pigpakita' kanan adti seled. ");
INSERT INTO klg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aw sa pagkatigkas da na imo-unun nan dun ni Témplo, nyuli' sakanan adti kanan balay. ");
INSERT INTO klg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sa paglabay da na pilangallaw, nyabdes si Élisabét. Aw seled na limambulan wala' sakanan luwa' adti balay nilan, aw miglong adti anenganeng nan, ");
INSERT INTO klg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Pigkallatan aku na Tyumanem. Pigkamang nan adi kanak ya kamulamula ku adti manga utaw.” ");
INSERT INTO klg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na, sa enemembulan da na pagkabdes ni Élisabét, pigsugu' na Tyumanem ya anghil na si Gabriyél adti lunsud na Nazarit, sakup na Galilya, ");
INSERT INTO klg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","na madtu ni sambuk na ka͡ubayan na wala' pa ka-ilabeti na eseg. Ya ngalan nan si Maria. Ya tawas nan si José na buwadbuwad ni Dabid na hari' asini muna. ");
INSERT INTO klg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aw sa pagdateng na anghil adti kan Maria, miglong sakanan, “Pagleya kaw kay ya Tyumanem to-o migpakadyaw kanmu, aw gayed kaw nan pig-agadan.” ");
INSERT INTO klg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagdengeg ni Maria seiy, to-o sakanan nyabelengbeleng kun unu ya kakawasan na piglong na anghil. ");
INSERT INTO klg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aw miglong ya anghil kanan, “Dili' kaw magkallek, kay Maria, kay kyatutukan ya Tyumanem kanmu. ");
INSERT INTO klg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pakanyegi ya un ku paglongun kanmu: Dili' madugay, mabdes kaw aw mag-ise' sa eseg, aw ngalanan mu sakanan na Jisus. ");
INSERT INTO klg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma-imo' sakanan to-o dengganen, aw pagtawagen sakanan na Ise' na Tyumanem na To-o Matas, aw imo-un sakanan na Tyumanem hari' kasiling na tyugbulan nan na si Dabid. ");
INSERT INTO klg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aw maghari' sakanan sa manga buwadbuwad ni Jakub na wala' ya tyamanan. Aw ya kasakupan na un nan hari-an, wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aw nyusip si Maria sa anghil, “Unun ya pagka-imo' na kadég yeiy na wala' pa ya eseg ku?” ");
INSERT INTO klg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aw tyumubag ya anghil, “Ya Ispiritu Santo un lumugsad dun ni kanmu aw kalandungan kaw na katulus na Tyumanem na To-o Matas. Yanagaw ya ise' na un ma͡utaw dun ni kanmu, wala' ya sala' dun ni kanan, aw pagtawagen sakanan na Ise' na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na, ya kadégan mu uman na si Élisabét, pangkay madég ya miglong na dili' sakanan magpaka-ise', manang nyabdes da sakanan sa ise' nan na eseg, aw enemembulan da ya kabdesan nan. ");
INSERT INTO klg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kay adti Tyumanem, wala' saba ya dili' nan mabatug.” ");
INSERT INTO klg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aw miglong si Maria, “Sugu-anen aku saba na Tyumanem. Madyaw beg galu aw matuman ya piglong mu adi kanak.” Pagkatigkas yan, pig-indegan sakanan na anghil. ");
INSERT INTO klg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na, wala' kadugay, nyanigpes si Maria aw nyaksay nyadtu ni lunsud adti kabuntudan dun ni banwa na Judiya. ");
INSERT INTO klg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagdateng nan dun, syumeled sakanan adti balay ni Zakariyas aw nyangumusta kan Élisabét. ");
INSERT INTO klg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aw sa pagdengeg ni Élisabét sa pangumusta ni Maria, mig-inang ya ise' adti buntit nan. Aw nyatmu' si Élisabét na Ispiritu Santo ");
INSERT INTO klg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aw miglong sa mabagseg na tingeg, “Kay Maria, madyaw ya kanmu! Sa kadég na manga ka͡ubayan, ikaw ya to-o pigpakadyaw na Tyumanem, aw maynan uman ya ise' na un ma͡utaw dun ni kanmu. ");
INSERT INTO klg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ananga' aku tanawun na ina na kanak Pangulu? ");
INSERT INTO klg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kay pagdengeg ku sa pagpangumusta mu, mig-inang ya ise' adi buntit ku kay to-o sakanan migleya. ");
INSERT INTO klg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aw madyaw ya kanmu kay pyangintu-uwan mu na tumanen saba na Tyumanem ya kadég na piglong nan kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aw miglong si Maria, “Pigdeyen ku ya Tyumanem sa kadakula' na kanak ginawa aw kanak anenganeng, ");
INSERT INTO klg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aw dakula' uman ya kanak pagleya asuntu na Magpaluwa-ay sakanan. ");
INSERT INTO klg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kay pig-anenganeng aku nan pangkay madalem aku na kanan sugu-anen. Lekat adun na allaw, madég ya manga utaw na maglong, ‘To-o madyaw ya kan Maria,’ ");
INSERT INTO klg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kay madég ya mangkadyaw na pigpan-imo' kanak na Tyumanem na To-o Matulus. Aw wala' ya maka-unawa sa ngalan nan. ");
INSERT INTO klg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aw kyallatan nan ya kadég na awun pagkallek kanan pangkay sa manga utaw adun aw sa manga buwadbuwad na dumadateng pa. ");
INSERT INTO klg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pigpakita' na Tyumanem ya kanan katulus magi sa kadyaw na pig-imo' nan. Ya manga migpatastas, pig-alilinan nan silan. ");
INSERT INTO klg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pigpapanog nan ya manga hari' adti kanilan trunu. Aw pigsuguk nan ya manga utaw na madalem. ");
INSERT INTO klg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pigpabiyag nan ya manga utaw na nyangkagetem, aw pig-alilinan nan ya manga mayaman na wala' ya dyala. ");
INSERT INTO klg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pigtabangan nan ya kanan manga utaw na yan ya manga buwadbuwad ni Isra-él. Wala' nan kalingawi ya kanan pakang na kallatan nan ya manga utaw nan. ");
INSERT INTO klg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kay asini muna, pigpakangan nan ya kanaten tyugbulan na si Abraham aw ya manga buwadbuwad nan na kallatan nan ya kadég tadun na wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aw nyeya' pa si Maria dun ni tampid ni Élisabét seled na tulumbulan, aw pagkatigkas yan, nyuli' da sakanan adti balay nan. ");
INSERT INTO klg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na, dyumateng ya allaw na kya͡utawan da si Élisabét, aw mig-ise' sakanan sa ise' na eseg. ");
INSERT INTO klg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sa pagpakadengeg na manga sumbalay nan aw kanan kadégan na to-o sakanan kyallatan na Tyumanem, ya kadég nilan nyagad kanan migleya. ");
INSERT INTO klg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aw sa walungallaw da na ise', nyadtu ya kadégan nilan kay un patuli' ya ise'. Aw kaliman nilan galu ngalanan ya ise' na si Zakariyas kasiling na ngalan na ama nan. ");
INSERT INTO klg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Manang wala' kalim si Élisabét, aw miglong sakanan, “Si Juan ya pagngalan kanan!” ");
INSERT INTO klg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aw miglong silan, “Wala' ya kadégan mayu na maynan ya ngalan!” ");
INSERT INTO klg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aw pigpulingenan nilan ya ama na ise' kun unu ya kaliman nan pagngalan sa ise' nan. ");
INSERT INTO klg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aw migpulingen uman si Zakariyas na atagan sakanan na sulatanan aw yan ya pigsulat nan: “Juan ya pagngalan kanan.” Aw nyabelengbeleng ya kadég nilan. ");
INSERT INTO klg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aw wala' nilan imanmana na nyakapaglong da si Zakariyas aw pigdeyen nan ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aw yanagaw nyangkallek ya kadég na sumbalay nilan. Aw ya nyangka-imo' yeiy alag nyabekkal adti kadakula' na kabuntudan na Judiya. ");
INSERT INTO klg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aw ya kadég na manga utaw na nyakadengeg seiy, nyaka-usip silan adti kanilan anenganeng, law nilan, “Unu ya un datengan na ise' yeiy aw magkadakula' da sakanan?” Kay nyabangal da na awun ni kanan ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aw si Zakariyas na ama ni Juan nyatmu' na Ispiritu Santo, aw ini ya pigpa-ede' nan: ");
INSERT INTO klg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Deyen tadun ya Pangulu na yan ya Tyumanem na manga utaw na Isra-él! Kay nyadi la sakanan aw pigpalekat da nan ya pagpaluwa' sa kanan manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Migpadala sakanan sa Magpaluwa-ay na to-o matulus asini kanaten na lekat adti manga buwadbuwad ni Dabid na kanan sugu-anen, ");
INSERT INTO klg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kasiling na pigpa-ede' nan asini muna magi sa kanan manga propita. ");
INSERT INTO klg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aw pigpakang nan na un nan kitadun paluwa-en lekat adti kanaten manga po-on aw adti pagdumala na kadég na migkalat kanaten sa ginawa. ");
INSERT INTO klg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Piglong nan uman na pakita' nan ya kanan kallat adti kanaten manga tyugbulan, aw dili' nan kalingawan ya pakang nan kanaten ");
INSERT INTO klg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na pigsapa' nan adti kan Abraham na tyugbulan tadun, ");
INSERT INTO klg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na un nan kitadun paluwa-en lekat adti kanaten manga po-on pada mabatug da tadun ya pagsimba kanan na wala' ya kakallekan. ");
INSERT INTO klg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Aw taniyen kitadun adti kanan, aw dalugun tadun ya kanan pagkaliman adti asdangan nan sa kadég na allaw na pag-eya' tadun asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pagkatigkas yan, miglong si Zakariyas adti ise' nan, “Ikaw kay To', pagtawagen kaw na propita na Tyumanem na To-o Matas, kay ikaw ya un muna sa Pangulu pada tagilanen ya un nan agiyan. ");
INSERT INTO klg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pa-ede-en mu ya kanan manga utaw na mabatug da silan paluwa-en kun lanasen da ya manga sala' nilan ");
INSERT INTO klg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","magi sa kallat na kanaten Tyumanem. Aw ya Magpaluwa-ay na un nan padala, kasiling na sega na bagu syumilat adti silatan ");
INSERT INTO klg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na un mag-atag sa kalalamdag adti kadég na nyeya' dun ni kangitngitan aw sa manga kyalandungan na alung na kamatayen. Aw yan ya magpalna-u kanaten sa dalan na un tadun agiyan pasinan adti kalinaw.” ");
INSERT INTO klg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aw ya ise' na si Juan tyumulin, aw migkabagseg ya ginawa nan aw migkasalig ya kanan pagpangintu-u. Aw nyeya' sakanan adti kaligbinan menda' sa allaw na migpalekat sakanan migpalna-u sa manga utaw na Isra-él. ");
INSERT INTO klg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na, idtu na manga allaw yan, si César Agusto ya impirador na migdumala sa kadakula' na kasakupan na Roma. Mig-imo' sakanan sa bala-ud na ka-ilangan magpalista ya kadég na utaw magi sa sinsus. Ya sugu' yeiy pigbekkal adti kadakula' na kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yeiy ya tagna' na pagpasinsus. Aw nya-imo' yeiy dengan na si Kuréniyo ya migdumala sa banwa na Sirya. ");
INSERT INTO klg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yanagaw ya kadég na manga utaw migpansi-uli' silan adti kanilan manga lunsud pada magpalista sa ngalan nilan. ");
INSERT INTO klg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aw si José nyindeg uman lekat dun ni lunsud na Nazarit na sakup na Galilya aw nyadtu ni Bétlihém na sakup na Judiya. Na, ya lunsud na Bétlihém, yan ya pigka͡utawan ni Dabid na hari' asini muna. Yanagaw nyadtu si José kay buwadbuwad sakanan ni Dabid, ");
INSERT INTO klg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","eped nan si Maria na kanan tawas na ka͡utawanan da, pada magpalista uman silan. ");
INSERT INTO klg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sa talana nilan adti Bétlihém, dyumateng ya udas na pyetesan da si Maria. ");
INSERT INTO klg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aw kya͡utawan sa ise' nan na eseg na panggadan magulang, aw pigputus nan na téla ya ise' nan. Aw pigpakulang nan dun ni kakananan na ayep kay wala' da ya tambi' na un nilan kabantukan. ");
INSERT INTO klg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, yan na gabi, awun manga magdadiyaga͡ay na migtunggu' sa manga karniro nilan dun ni panabtabanan na dili' to-o mawat adti Bétlihém. ");
INSERT INTO klg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aw tigkan migpakita' kanilan ya sambuk na anghil na Tyumanem, aw kya-ilawan silan na dakula' na kalalamdag na Tyumanem. Aw to-o silan nyallek. ");
INSERT INTO klg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Manang miglong ya anghil kanilan, “Dili' kamu magkallek! Pakanyegi mayu ya un ku paglongun: Awun ubat-ubat ku kamayu na to-o madyaw na makapaleya sa kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kay adun na gabi yeiy, adti lunsud ni Dabid, nya͡utaw da ya Magpaluwa-ay na yan ya Kristu na Pangulu. ");
INSERT INTO klg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aw yeiy ya pangilala na matinaw ya pig-ubat-ubat ku kamayu: Kita-en mayu ya tagbi' na ise' na pigputus na téla aw pigpakulang dun ni kakananan na manga ayep.” ");
INSERT INTO klg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pagkatigkas na anghil maglong, bigla' uman dyumateng ya madég na manga anghil na lekat adti tas na langit. Aw ya kadég nilan migdeyen sa Tyumanem, law nilan, ");
INSERT INTO klg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Deyen ya Tyumanem na awun ni tas na langit! Aw ya manga utaw asini tas na lupa' na nyakatutuk sa Tyumanem awun da kalinaw nilan.” ");
INSERT INTO klg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sa pagliku' da na manga anghil adti tas na langit, migbalawbalaw ya manga magdadiyaga͡ay sa karniro, law nilan, “Na! Kitadun da madtu ni Bétlihém aw naten tanawun ya nya-imo' adtu na pigpa-ede' kanaten na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yanagaw nyaksay silan nyadtu aw kyinita' nilan si Maria aw si José, aw pigkita' nilan uman ya ise' na pigpakulang adti kakananan na ayep. ");
INSERT INTO klg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aw pagkatigkas nilan tanawun ya ise', pig-ubat-ubat nilan adti manga utaw ya piglong kanilan na anghil sa ise' yan. ");
INSERT INTO klg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aw nyabelengbeleng ya kadég na nyakadengeg sa pig-ubat-ubat na manga magdadiyagay sa karniro. ");
INSERT INTO klg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Manang si Maria, pigtagu' nan adti kanan ginawa ya kadég na nyangka-imo' aw gayed nan pig-anenganeng kun unu ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aw lyumiku' ya manga magdadiyaga͡ay na migdeyen silan sa Tyumanem asuntu sa kadég na pigdengeg aw pigkita' nilan, kay alag saba matinaw ya kadég na piglong na anghil kanilan. ");
INSERT INTO klg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na, sa walungallaw da na ise', pigpatuli' nilan sakanan. Aw Jisus ya pigngalan nilan kanan, kay yan ya ngalan na piglong na anghil kanilan idtu muna sa wala' pa kabdes ya ina nan. ");
INSERT INTO klg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na, dyumateng da ya allaw na un madtu si José aw si Maria adti Témplo dun ni Jérusalim pada tumanen ya sugu' dun ni Uldin na pig-atag kan Moysis sa paglinis sa ka͡ubayan na bagu kya͡utawan. Aw pigdala nilan uman ya ise' pada taniyen adti Tyumanem, ");
INSERT INTO klg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kay nyakasulat adti Uldin: “Ya kadég na ise' na eseg na panggadan magulang pagtaniyen adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na, pada kalinisan si Maria, pigdalug nilan uman ya nyakasulat dun ni Uldin: “Dugsu' ya duwa ya tukmu, aw kun wala' yan, duwa baling ya impis na kalupati.” ");
INSERT INTO klg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, awun sambuk na utaw dun ni Jérusalim na pigngalanan na Simyon. Nyatibulluk ya ginawa nan dyumalug sa Uldin aw awun pagkallek nan sa Tyumanem. Madugay da nan pigtagadan na paluwa-en ya manga buwadbuwad ni Isra-él, aw ya Ispiritu Santo awun ni kanan. ");
INSERT INTO klg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aw pigpa-ede' da kanan na Ispiritu Santo na dili' pa sakanan matay menda' na kita-en nan ya Kristu na pigpakang na Tyumanem asini muna. ");
INSERT INTO klg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aw dun ni allaw yan, piggagad na Ispiritu Santo si Simyon na madtu ni Témplo. Aw dun da nan kita-a ya ise' na si Jisus na pigdala na mangkatikadeng nan adti Témplo na un tumanen ya sugu' dun ni Uldin. ");
INSERT INTO klg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sa pagkita' ni Simyon sa ise', pigsipit nan aw pigdeyen nan ya Tyumanem, law nan, ");
INSERT INTO klg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“We... Tyumanem, tumbayan da na kamangen aku mu kay nyatingen da ya anenganeng ku, asuntu na nyatuman da ya pigpakang mu kanak. ");
INSERT INTO klg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kay pigkita' da na kanak mata ya magpaluwa-ay ");
INSERT INTO klg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na pigtagilan mu dadan pada magpaluwa' sa kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sakanan ya kalalamdag na mag-ilaw sa un agiyan na manga utaw na Héntil pada mangintu-u silan kanmu. Aw magi kanan ka-atagan na dengeg ya manga utaw na Isra-él na yan ya kanmu manga utaw.” ");
INSERT INTO klg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pagdengeg na ama aw ina na ise' sa piglong ni Simyon, nya-enneng-enneng silan sa pigpa-ede' nan sa un datengan na ise'. ");
INSERT INTO klg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aw tigkas yan, migsekat si Simyon adti Tyumanem na pakadyawun nan silan, aw piglongan pa nan uman si Maria, “Ya ise' ini, pigpadala na Tyumanem adti kadég na manga utaw na Isra-él aw ma-imo' sakanan pangilala adti kanilan. Manang madég kanilan ya kumele kanan, yanagaw ukuman nan silan. Manang madég uman kanilan ya dumawat kanan, aw paluwa-en nan silan. ");
INSERT INTO klg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aw magi kanan kabukasan ya pigtagu' na manga utaw dun ni kanilan anenganeng. Manang ikaw kay Dé', asuntu na madég ya kumele sa ise' mu, magkalat ya kanmu ginawa kasiling na pigdugsang na lipang ya pusu' mu.” ");
INSERT INTO klg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na, awun sambuk na ka͡ubayan na balu aw propita sakanan na Tyumanem. Aw ya ngalan nan si Ana na ise' ni Panu-él na buwadbuwad ni Asir. To-o la sakanan buyag, aw olo' da pitungka͡umay ya pagsambuk nilan ya eseg nan. ");
INSERT INTO klg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nyabalu la sakanan, aw adun kawaluwan tag upat ya umay nan. Allaw aw gabi awun sakanan ni Témplo na gayed migsimba sa Tyumanem magi sa pagpuwasa aw pagpanawagtawag. ");
INSERT INTO klg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aw sa talana pa ni José aw ni Maria adti Témplo, dyumulud si Ana kanilan. To-o sakanan migleya aw pigpasalamatan nan ya Tyumanem. Aw gayed nan pigkasampetan ya ise' adti kadég na manga utaw na migtagad sa pagpaluwa' na Tyumanem sa manga taga Isra-él. ");
INSERT INTO klg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sa abus da ni José aw si Maria katuman ya kadég na pigsugu' na umba' nilan imo-un na awun ni Uldin na Tyumanem, nyuli' silan adti Nazarit sakup na Galilya. ");
INSERT INTO klg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aw ya ise' tyumulin aw gayed sakanan nyatmu' na katadeng aw grasya na alag lekat adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, kada umay magkadtu ya mangkatikadeng ni Jisus adti Jérusalim pada tumambung sa Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aw sa pagdateng da ni Jisus adti sampulu' tag duwa ya umay, nyadtu uman silan ni Pista kasiling na katanem nilan. ");
INSERT INTO klg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatigkas na manga allaw na Pista, nyan-uli' da silan. Manang migpatagak baling si Jisus adti Jérusalim. Aw wala' yeiy ka-ede-i na mangkatikadeng nan. ");
INSERT INTO klg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iman nilan aw nyaka-agad si Jisus sa kanilan ka-epedanan. Pagkatigkas na sangallaw na pagpanaw nilan, pigpaninaw nilan si Jisus dun ni kanilan kadégan aw manga ubaybay ");
INSERT INTO klg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","manang wala' nilan kita-a. Yanagaw lyumiku' silan adti Jérusalim pada paninawun sakanan. ");
INSERT INTO klg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sa pagkatlu la na allaw, pigkita' nilan si Jisus adti Témplo na nyingkud dun ni tenga' na manga magpalna-uway sa Uldin. Migpakanyeg si Jisus aw nyusip kanilan. ");
INSERT INTO klg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aw ya kadég na dyumengeg kanan, nya-enneng-enneng silan asuntu sa kadakula' na kya-ede-an nan dun ni pagtubag nan sa kanilan manga usip. ");
INSERT INTO klg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aw sa pagkita' na mangkatikadeng nan kanan, to-o silan nyabelengbeleng, aw miglong ya ina nan, “Kay To', ananga' mu imo-un kanami yeiy? Tanawa! To-o kami nyaypeng kanmu! Gayed kaw nami ya ama mu pigpaninaw.” ");
INSERT INTO klg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tyumubag si Jisus kanilan, “Kay Ne', ananga' kamu maninaw kanaken? Unu, wala' ka' mayu ka-ede-i na ka-ilangan na asini aku pag-eya' ni balay na Ama ku?” ");
INSERT INTO klg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Manang wala' nilan kalabeti kun unu ya kakawasan na piglong nan. ");
INSERT INTO klg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aw nyagad si Jisus kanilan nyuli' adti Nazarit. Aw kya͡agadan nan ya kanan mangkatikadeng. Aw ya kadég na nya-imo', alag pigtagu' na ina nan adti kanan ginawa. ");
INSERT INTO klg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aw tyumulin si Jisus aw kyadugangan pa to-o ya katadeng nan. Aw ya Tyumanem aw manga utaw alag kyatutukan kanan. ");
INSERT INTO klg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na, pagdateng da na sampulu' tag lima ka umay na pagdumala na impirador na si Tibériyo César sa kadakula' na kasakupan na Roma, dun ni umay yan, si Ponsyo Pilato uman ya gubirnador sa probinsiya na Judiya. Aw si Hérodés Antipas ya migdumala sa banwa na Galilya, aw ya mangud nan na si Pilipi yan ya migdumala sa manga banwa na Ituréya aw Trakonitis. Si Lisaniyas ya migdumala sa banwa na Abiléné. ");
INSERT INTO klg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aw si Anas aw si Kaypas, silan duwa ya manga pangulu na manga magdadugsu-ay sa manga utaw na Judiyu. Aw dun ni umay yan, dyumateng ya allaw na miglong ya Tyumanem adti ise' ni Zakariyas na si Juan talana nan nyeya' adti kaligbinan. ");
INSERT INTO klg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yanagaw piglegeb nan ya manga banwa na malapit dun ni tubig na Jordan, aw pig-ubat-ubat nan na magpaba͡utismu ya manga utaw aw magselsel silan pada lanasen na Tyumanem ya kanilan manga sala'. ");
INSERT INTO klg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dun ni pigpan-imo' ni Juan, nyatuman ya pigsulat na propita na si Isayas asini muna: “Awun utaw na magtatawag adti kaligbinan, aw yeiy ya un nan paglongun: ‘Tagilana mayu ya un agiyan na kanaten Tyumanem! Pakadyawa mayu ya dalan na un nan agiyan! ");
INSERT INTO klg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ya kadég na kalikuban un tabunan, aw ya kadég na kabuludan alag pakalataganen, aw ya manga dalan na kaliku-an pantuliden, aw ya manga dalan na batubatuwun pan-angginan. ");
INSERT INTO klg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aw kita-en na kadég na manga utaw ya Magpaluwa-ay na padala na Tyumanem adti kanilan.” ");
INSERT INTO klg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yanagaw madég ya manga utaw na nyadtu ni kan Juan pada magpaba͡utismu kanan. Aw miglong si Juan kanilan, “Kasiling kamu na kamangayse-anan na kamugung! Singalan ka' ya miglong kamayu na makapalaguy kamu lekat adti pa-emel-emel na Tyumanem na malapit da dumateng? ");
INSERT INTO klg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kun kaliman mayu makaluwa' dun ni pa-emel-emel na Tyumanem, pakita͡an mayu ya bunga na kamayu pagselsel. Unu ka', mig-anenganeng kamu na dili' kamu nan pa-emel-emelen asuntu na buwadbuwad kamu ni Abraham? Paglongun ta kamu: Mabatug saba na Tyumanem ya pag-imo' sa manga batu ini na palangad mangayse' ni Abraham na un pagsayu kamayu! ");
INSERT INTO klg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aw pangkay adun pigtagilan da ya palakul na un pagsakap sa manga kawuy na wala' pamunga sa madyaw, aw agbel adti atulun.” ");
INSERT INTO klg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aw nyangusip ya madég na manga utaw kan Juan, “Kun maynan, unu ya madyaw nami imo-un?” ");
INSERT INTO klg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aw tyumubag si Juan kanilan, “Kun singalan kamayu ya awun duwa ya sa-ul, madyaw pa na atag nan ya sambuk adti utaw na wala' ya sa-ul. Aw kun singalan uman kamayu ya awun kakan, atagan nan ya wala' ya pagkanen.” ");
INSERT INTO klg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Awun uman manga mangangubla͡ay sa buwis na nyadtu ni kan Juan pada magpaba͡utismu. Aw nyusip silan kanan, “Kay Magpalna-uway, unu uman ya imo-un nami?” ");
INSERT INTO klg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aw tyumubag si Juan kanilan, “Dili' mayu pagpasobla͡an ya pagpangubla sa buwis.” ");
INSERT INTO klg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aw awun uman manga sundalu na nyangusip kanan, law nilan, “Aw kami uman, unu ya kanami imo-un?” Aw tyumubag si Juan kanilan, “Dili' mayu pag-alleken ya manga utaw aw pagtanemtaneman pada makakuwalta kamu. Dili' da kamu mag-alup sa dakula' na tandan.” ");
INSERT INTO klg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sa pagpakadengeg na manga utaw sa palna-u ni Juan, migpalekat silan mig-anenganeng pagaw si Juan ya Kristu na kanilan pigtagadan. ");
INSERT INTO klg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Manang miglong si Juan kanilan, “Aku ya migba͡utismu kamayu magi sa tubig. Manang awun sambuk na un pa dumateng na to-o pa matas kanak, aw dili' aku makatumbuk kanan. Pangkay ya eket na sandal nan dili' aku umba' mag-ubad. Aw yan ya magba͡utismu kamayu sa Ispiritu Santo aw atulun. ");
INSERT INTO klg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dun ni pag-ukum nan, taniyen nan ya kanan manga utaw, kasiling saba na utaw na migbulus sa trigu. Magi dun ni pagbulus nan, matani ya tipig aw matani uman ya awun seled. Panimunun nan ya awun seled aw dayaw betang adti pul. Manang ya tipig, ubusun nan panimunun aw asag adti atulun na dili' pagkapatayan.” ");
INSERT INTO klg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Madég pa uman ya piglong ni Juan na makapabagseg sa anenganeng na manga utaw magi dun ni pagpa-ede' nan sa Madyaw na Ubat-ubat adti kanilan. ");
INSERT INTO klg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Manang si Hérodés Antipas na migdumala sa banwa na Galilya, pigpakalabusu nan si Juan. Kay gayed sakanan pigsagda ni Juan asuntu na kyamang nan si Hérodiyas na ka͡ubayan na mangud nan, aw asuntu na madég pa uman ya malatay na pig-imo' nan. ");
INSERT INTO klg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aw dun ni pagpakalabusu nan kan Juan, kyadugangan pa baling ya manga sala' nan! ");
INSERT INTO klg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, wala' pa si Juan kalabusuwa, pigpamba͡utismuwan nan ya madég na manga utaw. Aw pigba͡utismuwan nan uman si Jisus. Aw sa talana ni Jisus nyanawagtawag, nyabeka' ya langit ");
INSERT INTO klg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aw ya Ispiritu Santo lyumugsad adti kanan kasiling na kalupati. Aw awun tingeg na lekat adti tas na langit na miglong, “Ikaw ya Ise' ku na to-o ku pigginawa͡an, aw to-o aku kyatutukan kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sa pagpalekat ni Jisus migpalna-u, manga katluwan da ya umay nan. Aw adti anenganeng na manga utaw, ise' sakanan ni José. Na, si José, yan ya ise' ni Éli. ");
INSERT INTO klg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aw si Éli ya ise' ni Matat, aw si Matat ya ise' ni Libi. Si Libi ya ise' ni Mélki. Si Mélki ya ise' ni Janay, aw si Janay ya ise' ni José. ");
INSERT INTO klg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si José ya ise' ni Matatiyas, aw si Matatiyas ya ise' ni Amos. Si Amos ya ise' ni Nahum, aw si Nahum ya ise' ni Ésli. Si Ésli ya ise' ni Nagay, ");
INSERT INTO klg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","aw si Nagay ya ise' ni Ma-at. Si Ma-at ya ise' ni Matatiyas. Si Matatiyas ya ise' ni Sémé-in. Si Sémé-in ya ise' ni Josék. Si Josék ya ise' ni Joda. ");
INSERT INTO klg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda ya ise' ni Jo-anan. Si Jo-anan ya ise' ni Résa. Si Résa ya ise' ni Zérubabél. Si Zérubabél ya ise' ni Salati-él, aw Salati-él ya ise' ni Néri. ");
INSERT INTO klg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Néri ya ise' ni Mélki, aw si Mélki ya ise' ni Adi. Si Adi ya ise' Kosam, aw si Kosam ya ise' ni Élmadam. Si Élmadam ya ise' ni Ér, aw ");
INSERT INTO klg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","si Ér ya ise' ni Joswé. Si Joswé ya ise' ni Éliyézér, aw Éliyézér ya ise' ni Jorim. Si Jorim ya ise' ni Matat, aw Matat ya ise' ni Libi. ");
INSERT INTO klg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Libi ya ise' ni Simyon, aw si Simyon ya ise' ni Juda. Si Juda ya ise' ni José. Si José ya ise' ni Jonam. Si Jonam ya ise' ni Éliyakim. ");
INSERT INTO klg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Éliyakim ya ise' ni Mélia, aw si Mélia ya ise' ni Ména. Si Ména ya ise' ni Matata, aw si Matata ya ise' ni Natan. Si Natan ya ise' ni Dabid, ");
INSERT INTO klg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","aw si Dabid ya ise' ni Jési. Si Jési ya ise' ni Obéd, aw si Obéd ya ise' ni Boaz. Si Boaz ya ise' ni Salmon, aw si Salmon ya ise' ni Na-asyon. ");
INSERT INTO klg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aw si Na-asyon ya ise' ni Aminadab, aw si Aminadab ya ise' ni Admin. Si Admin ya ise' ni Arni. Si Arni ya ise' ni Hézron, aw si Hézron ya ise' ni Paréz. Aw si Paréz ya ise' ni Juda, ");
INSERT INTO klg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","aw si Juda ya ise' ni Jakub. Si Jakub ya ise' ni Isaak, aw si Isaak ya ise' ni Abraham. Si Abraham ya ise' ni Téra. Si Téra ya ise' ni Nahor. ");
INSERT INTO klg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor ya ise' ni Sérug, aw si Sérug ya ise' ni Réyu. Si Réyu ya ise' ni Pélég, aw si Pélég ya ise' ni Hibir. Si Hibir ya ise' ni Syéla. ");
INSERT INTO klg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Syéla ya ise' ni Ka-inan, aw si Ka-inan ya ise' ni Alpaksad. Si Alpaksad ya ise' ni Syém, aw si Syém ya ise' ni Nuwi. Si Nuwi ya ise' ni Lamék, ");
INSERT INTO klg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","aw si Lamék ya ise' ni Metuséla. Aw si Metuséla ya ise' ni Énok, aw si Énok ya ise' ni Jaréd. Aw si Jaréd ya ise' ni Mahalalél, aw Mahalalél ya ise' ni Kénan. ");
INSERT INTO klg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Aw si Kénan ya ise' ni Énos, aw si Énos ya ise' ni Sét. Aw si Sét ya ise' ni Adan, aw si Adan yan ya ise' na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, nyatmu' si Jisus na Ispiritu Santo aw pig-indegan nan ya tubig na Jordan, aw pigpa-agad sakanan na Ispiritu adti kaligbinan. ");
INSERT INTO klg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Seled na kapatan ya allaw wala' sakanan kan aw gayed pigtanda' ni Satanas. Aw pagkatigkas na pagpuwasa ni Jisus, to-o sakanan nyagetem. ");
INSERT INTO klg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aw miglong kanan si Satanas, “Kun Ise' kaw na Tyumanem, na, paglonga ya manga batu ini na ma-imo' pan.” ");
INSERT INTO klg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Manang tyumubag si Jisus kanan, “Yeiy saba ya pigpasulat na Tyumanem: ‘Beke' olo' na kakan ya makamataw sa utaw.’ ” ");
INSERT INTO klg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatigkas yan, pigpa-agad ni Satanas si Jisus adti matas na buntud aw pigpatandaw kanan dagawdagaw ya kadég na kasakupan asini tas na lupa'. ");
INSERT INTO klg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aw piglongan nan si Jisus, “Ikaw ya un ku atagan sa katundanan magdumala sa kadég yeiy aw ya kanenggeya nilan. Kay pigtumbay da kanak ya kadég, aw mabatug ku atag adti pangkay singalan ya kaliman ku atagan. ");
INSERT INTO klg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yanagaw, kun magsimba kaw kanak, atag ku kanmu ya kadég yeiy.” ");
INSERT INTO klg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aw tyumubag si Jisus kanan, “Pigpasulat da saba: ‘Ya Tyumanem na kanmu Pangulu, yan olo' ya kanmu simba͡en aw yan ya kanmu ka͡agadan.’ ” ");
INSERT INTO klg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatigkas yan, pigpa-agad nan si Jisus adti syudad na Jérusalim aw pigpa-indeg nan adti katasan na Témplo aw law nan, “Kun ikaw ya Ise' na Tyumanem, kawas kaw adti dalem, ");
INSERT INTO klg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kay yeiy ya pigpasulat asini muna: ‘Sugu-un na Tyumanem adti kanmu ya kanan manga anghil na un magtameng kanmu,’ ");
INSERT INTO klg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","aw ‘Salu-un kaw nilan aw pangkay ya manga siki mu dili' kapali-an na manga batu.’ ” ");
INSERT INTO klg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aw tyumubag si Jisus, “Yeiy uman ya pigpasulat na Tyumanem: ‘Dili' mu pagtanda-en ya Tyumanem na kanmu Pangulu.’ ” ");
INSERT INTO klg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagkatigkas da na kadég na punganan na pagtanda' ni Satanas kan Jisus, pig-indegan pa nan dun aw migtagad na makaselat salut magtanda' kanan. ");
INSERT INTO klg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, nyuli' si Jisus adti banwa na Galilya. Aw awun ni kanan ya katulus na Ispiritu Santo, aw nyabekkal ya dengeg nan dun ni kadakula' na palibed na banwa yan. ");
INSERT INTO klg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aw migpalna-u sakanan adti manga sinagoga nilan aw pigdeyen sakanan na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aw pagkatigkas yan, nyuli' si Jisus adti lunsud na Nazarit na yan ya pigtulinan nan. Aw dun ni Allaw na Paglagdeng, nyadtu sakanan ni sinagoga, kay yan ya kanan kyanalaman. Aw nyindeg si Jisus na un magbasa sa pigpasulat na Tyumanem, ");
INSERT INTO klg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","aw pigdimil kanan ya pigsulat ni Propita Isayas. Pig-ulad ni Jisus aw kyinita' nan ya un nan basa͡en, aw pigpalekat nan ya pagbasa, law nan: ");
INSERT INTO klg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ini kanaken ya Ispiritu Santo, kay pigpamalli' aku nan na un magpa-ede' sa Madyaw na Ubat-ubat adti manga utaw na tagitu'. Pigpadala aku nan na un mag-ubat-ubat adti manga pig-allang na mabatug da silan paluwa-en. Aw ya manga utaw na buta, kumita' da silan. Aw ya manga utaw na pyamulayaman, paluwa-en silan. ");
INSERT INTO klg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aw piglongan aku nan na pa-ede-en ya manga na utaw na dyumateng da ya allaw na paluwa-en silan na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatigkas ni Jisus magbasa, piglulun nan ya pigsulatan aw pig-uli' nan adti pagsaligan dun ni sinagoga, aw nyingkud sakanan. Aw ya kadég na utaw dun nyinunu kanan. ");
INSERT INTO klg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aw dun da si Jisus paglong kanilan, “Ya pigpasulat ini na Tyumanem asini muna, nyatuman da adun na allaw, aw pigpakanyegan da mayu.” ");
INSERT INTO klg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ya kadég na utaw dun migsaya' kanan aw nyabelengbeleng silan sa mangkadyaw na piglong nan. Aw miglong silan, “Enda', olo' saba sakanan ise' ni José?” ");
INSERT INTO klg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yanagaw miglong si Jisus kanilan, “Nya-ede' aku na maynini ya pundinganan na un mayu paglongun kanak: ‘Kay Doktor, bulunga una ya kanmu pagka-utawun.’ Aw maglong kamu uman kanak, ‘Kay Magpalna-uway, dyengeg nami ya kadég na pigpan-imo' mu adti lunsud na Kapirna-um. Na, imo-a la uman asini kanaten banwa.’ ");
INSERT INTO klg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pagkatigkas yan, miglong pa uman si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Wala' ya propita na pagdawaten dun ni kanan banwa. ");
INSERT INTO klg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Anenganga mayu ya nya-imo' dun ni manga allaw ni propita Éliyas. Seled na tulungka͡umay aw tenga' na wala' ya ulan, aw awun dakula' na getem asini banwa ini. Aw awun madég na ka͡ubayan na nyabalu dun ni manga allaw yan. ");
INSERT INTO klg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Manang wala' padala͡an na Tyumanem si Éliyas adti pangkay sambuk kanilan. Adtu baling sakanan sugu-a adti sambuk na ka͡ubayan na nyabalu na nyeya' adti Zarépta, sakup na Sidon. ");
INSERT INTO klg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aw awun uman madég na ibungun asini Isra-él dengan na manga allaw ni Propita Élisiyo. Manang wala' ya sambuk kanilan na kyalinisan sa ibung nilan. Si Na-aman olo' na taga Sirya ya kyalinisan.” ");
INSERT INTO klg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagpakadengeg na kadég na awun ni seled na sinagoga sa piglong ni Jisus, to-o silan nyangkadaman. ");
INSERT INTO klg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aw nyan-indeg silan aw pigdulus nilan si Jisus aw piggakgak adti luwa' na lunsud, adti ligad na pangpang na kyabetangan na lunsud nilan, kay un galu nilan tulud. ");
INSERT INTO klg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Manang nyagi baling si Jisus dun ni tenga' na kadég na manga utaw aw nyanaw da sakanan. ");
INSERT INTO klg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aw tyumubang si Jisus adti lunsud na Kapirna-um, sakup na Galilya. Pagdateng na Allaw na Paglagdeng, syumeled sakanan adti sinagoga aw migpalna-u sa manga utaw dun. ");
INSERT INTO klg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aw ya manga utaw na nyakadengeg, nya-enneng-enneng silan kay awun katulus na kanan pagpalna-u. ");
INSERT INTO klg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, dun ni sinagoga awun sambuk na eseg na pigseledan na busaw. Aw to-o sakanan mig-ulangag, ");
INSERT INTO klg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","law nan, “Kay Jisus na taga Nazarit, unu ya tud mu kanami? Unu, nyadi kaw na un apnasen ya kadég nami? Pigkilala ta kaw! Ikaw saba ya Pigpadala na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Manang pigsagda ni Jisus ya busaw, law nan, “Katinep kaw aw luwa' kaw adti kanan!” Aw pigdakdak na busaw ya utaw dun ni asdangan na kadég nilan, aw lyumuwa' ya busaw adti kanan na wala' ka-unu ya utaw yan. ");
INSERT INTO klg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ya kadég na manga utaw dun, alag silan nya-enneng-enneng. Aw migpan-usip-usipay silan, law nilan, “Unu ya palabet seiy? Kay awun katulus nan magsugu' sa manga busaw aw lyumuwa' silan!” ");
INSERT INTO klg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aw nyabekkal ya dengeg ni Jisus dun ni kadakula' na palibed na banwa yan. ");
INSERT INTO klg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagkatigkas yan, nyindeg si Jisus lekat adti sinagoga, aw nyadtu sakanan ni balay ni Simon. Na, ya ugangan ni Simon na ka͡ubayan to-o migkapasu'. Yanagaw nyanginayu' silan kan Jisus na guli-en nan. ");
INSERT INTO klg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aw nyindeg si Jisus adti tampid nan, aw pigsagda nan ya kapasu', aw dayaw pig-uwasan ya ka͡ubayan sa kapasu-an nan, aw maksay migbangun aw migsanggila' kanilan. ");
INSERT INTO klg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagsallep da na sega, pigpandala na manga utaw adti kan Jisus ya kadég na eped nilan na kyedelan. Pangkay unu ya magkedel nilan, pigpandungan ni Jisus na kanan palad ya tagsambuksambuk kanilan aw pyangkaguli-an silan. ");
INSERT INTO klg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pig-alilinan nan ya manga busaw lekat adti madég na manga utaw, aw lyumuwa' silan na to-o mig-ulangag na miglong, “Ikaw ya Ise' na Tyumanem!” Manang pigsagda silan ni Jisus aw wala' nan tumbayan na maglong kay kya-ede-an nilan na si Jisus yan ya Kristu. ");
INSERT INTO klg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sa pagkamaselem da, pig-indegan ni Jisus ya lunsud yan aw nyadtu sakanan ni kaligbinan. Manang pigpaninaw sakanan na madég na manga utaw, aw sa pagkita' nilan kanan, nyanginayu' silan na dili' nan silan indegan. ");
INSERT INTO klg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Manang miglong si Jisus kanilan, “Ka-ilangan na pa-ede' ku uman adti eped na manga lunsud ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem, kay yan ya du-an na pigpadala aku asini.” ");
INSERT INTO klg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aw migpadeleg si Jisus mig-ubat-ubat adti manga sinagoga dun ni Judiya. ");
INSERT INTO klg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na, sambuk na allaw, nyindeg si Jisus adti baklayan na Danaw na Génésarét na migpalna-u sa manga utaw, aw mig-insekay silan migpalapit adti kanan kay kaliman nilan magpakanyeg sa tingeg na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aw kyinita' ni Jisus ya duwa ya balangay adti ligad na danaw, manang ya manga mangisda-ay, nyanug pa silan pada mag-ugas sa kanilan manga pukut. ");
INSERT INTO klg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yanagaw nyanik si Jisus adti sambuk na balangay ni Simon, aw piglongan nan na tulud tagbi' ya balangay adti ligad. Aw nyingkud si Jisus dun ni balangay aw pigpalna-uwan nan ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatigkas da nan magpalna-u, piglongan nan si Simon, “Pagpalawud kamu aw tontona mayu ya manga pukut pada makakamang kamu sa isda'.” ");
INSERT INTO klg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aw tyumubag si Simon, “Kay Magpalna-uway, sanggabi pa nami ya nyamukut aw wala' ya nyakamang nami! Manang asuntu na ikaw ya miglong kanami, tontonun pa ku uman salut ya manga pukut.” ");
INSERT INTO klg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sa pagtonton da nilan sa kanilan manga pukut, madég to-o ya manga isda' na nyakamang nilan, aw nyangkakésé' da galu ya kanilan manga pukut. ");
INSERT INTO klg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yanagaw pigkapay nilan ya manga eped nilan adti sambuk na balangay pada tumabang kanilan. Aw migpalapit ya manga eped nilan aw pig-atmu' nilan na isda' ya duwa ya balangay aw agpet da galu malened asuntu sa dakula' na nyakamang nilan. ");
INSERT INTO klg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkita' ni Simon sa nya-imo' yeiy, lyumuhud sakanan dun ni asdangan ni Jisus aw piglongan nan, “Kay Magpalna-uway, pagpa-awat kaw beg kanake' kay makasasala' aku!” ");
INSERT INTO klg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Piglong yeiy ni Simon kay nya-enneng-enneng sakanan aw ya kanan manga eped asuntu sa kadég na isda' na nyakamang nilan. ");
INSERT INTO klg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aw ya manga eped ni Simon na si Santiago aw si Juan na alag mangayse' ni Zibidiyo nya-enneng-enneng uman silan. Aw miglong si Jisus kan Simon, “Dili' kaw magkallek. Lekat adun imo-un da kaw mangisda-ay sa manga utaw.” ");
INSERT INTO klg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pagkatigkas yan, pigguyud nilan ya kanilan manga balangay adti ligad na danaw aw pig-ayawan nilan ya kadég aw nyagad silan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Talana ni Jisus adti sambuk na lunsud, awun dyumulud kanan na eseg na ibungun. Pagkita' nan kan Jisus, lyumuhud sakanan aw nyanginayu', law nan, “Kay Sir, kun malim kaw beg, guli-a ya ibung ku, pada kalinisan da ya lawas ku.” ");
INSERT INTO klg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aw pig-awidan ni Jisus ya eseg aw piglongan nan, “Kaliman ku saba. Na, kalinisan da kaw!” Aw dayaw nyalanas ya ibung nan. ");
INSERT INTO klg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aw piglongan ni Jisus ya utaw yan na dili' nan pag-ubat-ubat adti pangkay singalan utawa. Aw piglongan nan uman, “Kadtu kaw ni Témplo, aw patanawan ya lawas mu adti magdadugsu-ay, aw matinawun nan na kyaguli-an da kaw. Aw atag kaw kanan sa umba' mu pagdugsu' na pigsugu' ni Moysis na yan ya magmatinaw adti manga utaw na kyalinisan da kaw.” ");
INSERT INTO klg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Manang to-o pa baling nyabekkal ya ubat-ubat sa dengeg ni Jisus. Aw migkatipun adti kanan ya to-o madég na manga utaw pada magpakanyeg kanan aw pada pangguli-en ya manga magkedel nilan. ");
INSERT INTO klg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Manang malikit si Jisus magkadtu ni kaligbinan na sayda nan pada manawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na, sambuk na allaw, talana ni Jisus migpalna-u, awun manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu na nyingkud dun na lekat adti madég na lunsud dun ni banwa na Galilya aw Judiya aw syudad na Jérusalim. Aw awun ni kan Jisus ya katulus na Tyumanem sa pagguli' sa manga magkedel. ");
INSERT INTO klg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na, awun manga eseg na dyumateng dun na migtingga sa pulid. Pigtibagsegan nilan na makaseled adti balay pada dala͡en ya pulid adti asdangan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Manang wala' silan pakaseled asuntu sa kadég na utaw. Yanagaw nyanik silan adti atep na balay aw piggawangan nilan ya atep, pagkatigkas yan pigtonton nilan adti dalem ya pigpakulangan sa pulid dun ni asdangan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sa pagkita' ni Jisus sa kadakula' na pagpangintu-u nilan, miglong sakanan adti pulid, “Kay Lew, ya manga sala' mu adti Tyumanem, piglanas da.” ");
INSERT INTO klg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aw sa pagpakadengeg na manga Parisiyo aw manga magpalna-uway sa Uldin sa piglong ni Jisus, mig-anenganeng silan, “Ananga' maglong sa maynan ya utaw yeiy? Migpa-unawa sakanan sa Tyumanem! Ya Tyumanem saba olo' ya makalanas sa manga sala'!” ");
INSERT INTO klg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Manang kya-ede-an ni Jisus ya anenganeng nilan, yanagaw piglongan nan silan, “Ananga' kamu mag-anenganeng sa maynan? ");
INSERT INTO klg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ayin ka' ya molas paglongun adti eseg na pulid, ‘Ya manga sala' mu piglanas da,’ aw kun paglongun sakanan, ‘Pagbangun kaw aw panaw da kaw’? ");
INSERT INTO klg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Manang matinawun ku adti kamayu na ya Ise' na Utaw awun katundanan nan asini tas na lupa' maglanas sa sala' na manga utaw.” Tigkas yan, miglong si Jisus adti eseg na pulid, “Pagbangun kaw! Dala͡a ya pigtingga nilan kanmu aw uli' da kaw adti balay mu!” ");
INSERT INTO klg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aw maksay migbangun ya eseg na pulid dun ni asdangan na manga utaw aw dyala nan ya pigtingga kanan aw nyuli' adti balay nan na to-o migdeyen sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aw ya kadég na manga utaw na kyumita' sa nya-imo', nya-enneng-enneng silan aw nyallek aw migdeyen silan sa Tyumanem. Aw miglong silan, “Wala' pa tadun kita-a ya maynini!” ");
INSERT INTO klg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatigkas yan, nyanaw si Jisus aw kyinita' nan si Libi na mangangubla͡ay sa buwis na nyingkud adti bayadanan sa buwis. Aw miglong si Jisus kanan, “Agad kaw kanak.” ");
INSERT INTO klg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aw nyindeg si Libi aw pig-ayawan nan ya kadég aw nyagad kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wala' kadugay, migpa-imo' si Libi sa dakula' na kakan adti balay nan pada mamasa kan Jisus. Aw dun uman ya madég na manga mangangubla͡ay sa buwis aw eped na manga utaw na nyagad kanilan kyuman. ");
INSERT INTO klg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Manang miggumudgumud ya manga Parisiyo aw ya manga eped nilan na magpalna-uway sa Uldin, aw migdiklamu silan adti manga umagakan ni Jisus, law nilan, “Ananga' kamu sumambuk kuman aw minem sa manga mangangubla͡ay sa buwis aw manga makasasala'?” ");
INSERT INTO klg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aw tyumubag si Jisus kanilan magi sa pundinganan, “Ya manga utaw na mangkadyaw ya lawas, dili' nilan ka-ilangan ya doktor. Manang ya manga utaw na awun magkedel, silan ya awun ka-ilangan sa doktor. ");
INSERT INTO klg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ya pigkadi ku asini tas na lupa' yan ya pagtawag sa manga utaw na nyaka-ede' sa sala' nilan pada magselsel silan sa kanilan manga sala'. Manang ya manga utaw na iman nilan aw wala' ya kanilan sala', beke' nilan ya pigtawag ku.” ");
INSERT INTO klg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Awun manga utaw dun na miglong kan Jisus, “Ananga' malikit magpuwasa aw magpanawagtawag ya umagakan ni Juan na Magba͡utismuway aw ya umagakan na manga Parisiyo, manang ya kanmu umagakan, kyuman silan baling aw nyinem?” ");
INSERT INTO klg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aw tyumubag si Jisus kanilan magi sa pundinganan, “Enda', kun awun kasal, dili' magpuwasa ya manga utaw kun kenne' pa dun ni sayid nilan ya eseg na migpanamung. ");
INSERT INTO klg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Manang dumateng ya allaw na kamangen sakanan lekat adti kanilan, aw dun ni manga allaw yan, magpuwasa la silan.” ");
INSERT INTO klg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aw pig-ubatan pa uman silan ni Jisus sa pundinganan, law nan, “Kasiling uman na kadégkadég, wala' ya utaw na magtabas sa bagu aw pagleneb nan adti dadan. Kun imo-un nan yeiy, makisay baling ya bagu na kadégkadég aw dili' uman mag-unawa ya batek na pigleneb adti dadan na kadégkadég. ");
INSERT INTO klg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aw maynan uman, wala' ya mag-asag sa bagu na bino adti dadan na betanganan na pig-imo' lekat adti kindal na ayep. Kay kun imo-un nan yeiy, sumubuk ya bagu na bino aw mutu ya betanganan aw masapad baling ya bino aw magkalat uman ya betanganan. ");
INSERT INTO klg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Manang ya bagu na bino, ka-ilangan asag adti bagu na betanganan. ");
INSERT INTO klg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aw ya manga utaw na nyaka-inem da sa dadan na bino dili' malim minem sa bagu, kay maglong silan, ‘Madyaw pa ya dadan.’ ” ");
INSERT INTO klg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na, sambuk na Allaw na Paglagdeng, nyanaw si Jisus aw ya kanan manga umagakan dun ni dalan na nyaka-agi adti tenga' na pawa' na awun trigu na agpet da aniyen. Aw nyanaplus ya manga umagakan nan sa trigu aw pigtebteb nilan. ");
INSERT INTO klg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Manang awun manga Parisiyo na nyusip, “Ananga' mayu lakadan ya sugu' dun ni Uldin sa Allaw na Paglagdeng?” ");
INSERT INTO klg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tyumubag si Jisus kanilan, “Unu ka', wala' mayu kabasa ya pigpasulat na Tyumanem sa pig-imo' ni Dabid? Pagkagetem nan aw ya kanan manga eped, ");
INSERT INTO klg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","syumeled sakanan adti Balay na Tyumanem, aw pigkamang nan ya pan na pig-atag da adti Tyumanem aw kana nan, aw pig-atped-atped nan uman ya kanan manga eped, aw dun da nilan baling kalakadi ya Uldin kay yan saba olo' ya makakan ya manga magdadugsu-ay.” ");
INSERT INTO klg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aw miglong pa uman kanilan si Jisus, “Pig-atag da adti Ise' na Utaw ya pagbaya' sa unu ya madyaw imo-un sa Allaw na Paglagdeng.” ");
INSERT INTO klg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na, sambuk uman na Allaw na Paglagdeng, syumeled si Jisus adti sinagoga aw migpalna-u, aw dun ya sambuk na eseg na kimay ya kalintu na bekten nan. ");
INSERT INTO klg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aw dun uman ya manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu na migbantay sa un imo-un ni Jisus, kun guli-en nan ya bekten na utaw dun ni Allaw na Paglagdeng. Kay kaliman nilan na awun puliba maglimanda kanan. ");
INSERT INTO klg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Manang kya-ede-an ni Jisus ya adti anenganeng nilan. Yanagaw pigtawag nan ya eseg na kimay, law nan, “Adi kaw aw indeg kaw asini asdangan na kadég na utaw.” Aw nyindeg ya utaw yan dun ni asdangan nilan. ");
INSERT INTO klg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aw miglong si Jisus adti manga Parisiyo aw manga magpalna-uway, “Awun usip ku kamayu: Adti Uldin, unu ya pigtumbay na imo-un dun ni Allaw na Paglagdeng, ya pag-imo' sa madyaw aw ya pag-imo' sa malatay? Aw kun paluwa-en ya utaw lekat adti pagti-is aw kalaten baling sakanan?” ");
INSERT INTO klg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pig-inunu ni Jisus ya kadég nilan, aw tigkas yan piglongan nan ya eseg na kimay, “Ulada ya bekten mu.” Aw pig-ulad nan ya kanan bekten, aw dayaw migkadyaw. ");
INSERT INTO klg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Manang ya manga Parisiyo aw manga magpalna-uway sa Uldin, to-o silan nyadaman aw pigbalawbalawan nilan kun unu ya un nilan imo-un kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na, dun ni manga allaw yan, tyumukud si Jisus adti buntud na un manawagtawag. Aw sanggabi nan nyanawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aw sa pagkamaselem da, pigtawag ni Jisus adti kanan ya manga umagakan nan. Aw pigpamalli' nan ya sampulu' tag duwa ya eseg aw pigngalanan nan silan na manga apostolés. ");
INSERT INTO klg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ini ya manga pigpamalli' nan: Si Simon na pigngalanan ni Jisus na Pédro, aw ya inulug nan na si Andrés, aw si Santiago, si Juan, si Pilipi, si Bartolomi, ");
INSERT INTO klg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","aw si Matiyo, si Tomas, si Santiago na ise' ni Alpiyo, si Simon na Zéloti, ");
INSERT INTO klg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas na ise' ni Santiago, aw si Judas Iskariyoti na yan ya un maglubid kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pagkatigkas yan, tyumubang si Jisus aw ya kanan manga umagakan adti kalatagan, kay tyumagad dun ya madég na dyumalug kanan. Aw dun uman pagkatipun ya madég pa to-o na manga utaw na lekat adti kadakula' na Judiya aw Jérusalim, aw awun uman lekat adti lunsud na Sidon aw Tiro na apit adti ligad na dagat. ");
INSERT INTO klg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nyangkadtu silan ni kan Jisus na un magpakanyeg kanan aw pada guli-en ya manga magkedel nilan. Aw nyangkadtu uman ya manga utaw na syeledan na manga busaw, aw pyangkaguli-an silan. ");
INSERT INTO klg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aw migtibagseg ya kadég na utaw na maka-awid silan kan Jisus kay kya-ede-an nilan na awun katulus na magluwa' lekat adti kanan, aw alag silan kyaguli-an. ");
INSERT INTO klg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aw pig-inunu ni Jisus ya kanan manga umagakan, aw miglong sakanan: “Madyaw ya kamayu na nyaka-ede' na wala' ya mabatug mayu kun wala' ya Tyumanem. Kay nyaka-akup da kamu adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Madyaw ya kamayu na nyagetem adun, kay pakabiyagen kamu kagaya. Madyaw ya kamayu na migsugaw adun, kay pakaganen ya ginawa mayu kagaya. ");
INSERT INTO klg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Madyaw ya kamayu kun dumutan kamu na eped asuntu sa pagdalug mayu sa Ise' na Utaw, pangkay kele͡an kamu nilan aw odoy-odoyun aw kalaten ya kamayu dengeg. ");
INSERT INTO klg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pagleya kamu dun ni allaw yan kay dakula' saba ya madawat mayu na pigtagilan da adti tas na langit. Maynan saba ya pig-imo' na manga tyugbulan nilan adti manga propita na Tyumanem asini muna. ");
INSERT INTO klg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Manang kamu na mangkayaman, malatay ya un mayu datengan kay nyatagtun da mayu adun ya madyaw na pagpakabetang. ");
INSERT INTO klg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kamu na nyangkabiyag adun, malatay ya un mayu datengan kay dumateng ya allaw na magetem kamu. Kamu na na nyaka-ikel adun, malatay ya un mayu datengan kay magkalat saba ya ginawa mayu kagaya aw to-o kamu magsugaw. ");
INSERT INTO klg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kamu na pigsaya' adun na madég na utaw, malatay ya un mayu datengan. Maynan saba uman pigsaya' na manga tyugbulan nilan ya manga sallong kunu propita asini muna. ");
INSERT INTO klg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Manang ini ya kanak paglongun kamayu na manga migpakanyeg: Ginawayi mayu ya kamayu manga po-on. Aw imo-a mayu ya mangkadyaw adti manga utaw na migdumut kamayu. ");
INSERT INTO klg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pakadyawa ya manga migtullun kamayu aw panawagtawagi adti Tyumanem ya manga migpakalat kamayu. ");
INSERT INTO klg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kun awun magsampal sa gya mu, pasampalan uman kanan ya sangkilid. Aw kun awun magkamang sa sambuk na kadégkadég mu, na, atagan kanan. Kun kamangen pa nan uman ya kanmu kamisita, atagan uman kanan. ");
INSERT INTO klg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Atagi mayu ya pangkay singalan na migsekat kamayu sa tabang. Aw kun awun utaw na kumamang sa kamayu pametang, dili' da mayu pagbawi-en. ");
INSERT INTO klg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kun kaliman mayu pakadyawun na eped na utaw, na, una͡a mayu silan pakadyawa. ");
INSERT INTO klg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kun yan olo' ya pigginawa͡an mayu ya manga gyuminawa kamayu, ayin da ya kadyaw na pig-imo' mayu? Pangkay ya manga makasasala', pigginawa͡an saba nilan ya manga gyuminawa kanilan. ");
INSERT INTO klg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aw kun yan olo' ya pakadyawun mayu ya manga utaw na mig-imo' kamayu sa madyaw, ayin da ya kadyaw na pig-imo' mayu? Pangkay ya makasasala' mig-imo' uman sa maynan. ");
INSERT INTO klg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aw kun yan olo' ya pabelesen mayu ya eped na pig-iman mayu na makasayu kamayu, ayin da ya kadyaw na pig-imo' mayu? Pangkay ya manga makasasala' migpabeles saba adti manga eped nilan na makasasala', aw pig-iman nilan na makasayu ya nyeles adti kanilan. ");
INSERT INTO klg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Manang ginawayi mayu baling ya kamayu manga po-on. Aw imo-a mayu ya madyaw adti kanilan. Pabelesa mayu silan na wala' ya pag-iman na sayuwan kamu nilan. Kay kun imo-un mayu ya kadég yeiy, dakula' saba ya madawat mayu aw ma-imo' kamu mangayse' na Tyumanem na To-o Matas. Kay ya Tyumanem magkallat saba, pangkay sa manga utaw na dili' magpasalamat kanan aw pangkay sa manga utaw na malatay ya bet. ");
INSERT INTO klg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yanagaw pagkallatan mayu ya kadég, kasiling na pagkallat na Tyumanem na kamayu Ama. ");
INSERT INTO klg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dili' kamu mag-ukum sa eped na utaw, pada dili kamu uman ukuman na Tyumanem. Dili' mayu pagpasala-en ya eped, pada dili' kamu uman pasala-en na Tyumanem. Pasinsiyayi mayu ya eped na utaw, aw lanasen saba na Tyumanem ya manga sala' mayu. ");
INSERT INTO klg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Atagi mayu ya manga eped aw atagan kamu uman na Tyumanem. Kay pangkay sangunu ya kadakula' na pig-atag mayu, maynan uman ya atag kamayu na Tyumanem na dayaw pa nan daseken aw eyengen aw dugangan pa menda' na to-o lumapya.” ");
INSERT INTO klg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pagkatigkas yan, miglong pa uman si Jisus adti umagakan nan sa pundinganan, law nan “Dili' mabatug na buta ya pagguyud sa eped nan na buta, kay alag silan molug adti gawang. ");
INSERT INTO klg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ya pigpalna-uwan dili' matas sa migpalna-u kanan. Umba' da sa pigpalna-uwan ya magkatadeng kasiling na migpalna-u kanan. ");
INSERT INTO klg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ananga' kaw magtulli' sa puling na awun ni mata na kanmu eped manang pigpabaya-an mu baling ya dakula' na batang na nyakabalabag dun ni kanmu mata? ");
INSERT INTO klg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ananga' kaw maglong sa eped mu, ‘Nate' kamangen ya kanmu puling’’ manang wala' mu kita-a ya kanmu puling na kasiling na batang ya kadakula'? Migtallalingu kaw! Una͡a saba kamanga ya puling mu pada mabangal da ya pag-inunu mu aw mabatug da mu ya pagkamang sa puling na kanmu eped. ");
INSERT INTO klg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Aw migpadeleg si Jisus miglong, “Ya madyaw na kawuy dili' mamunga sa malat, aw ya malat na kawuy dili' mamunga sa madyaw. ");
INSERT INTO klg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kay ya tagsambuksambuk na kawuy ka-ede-an magi sa bunga nan. Dili' kaw maka-ipu' sa madyaw na bunga na igira adti kawuy na suksukun, aw dili' kaw uman maka-ipu' sa bunga na paras adti sampinit. ");
INSERT INTO klg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aw maynan uman ya utaw. Pangkay unu ya awun ni anenganeng nan, yan uman ya kanan paglongun. Kun gayed madyaw ya pig-anenganeng na utaw, madyaw uman ya imo-unun nan. Manang kun malatay ya pig-anenganeng nan, malatay uman ya paglongun nan. ");
INSERT INTO klg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ananga' aku mayu pagtawagen na ‘Pangulu’ manang wala' mayu daluga ya palna-u ku? ");
INSERT INTO klg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pangkay singalan ya dumulud kanak aw magpakanyeg sa palna-u ku aw dalugun nan, kasiling sakanan na utaw asini pundinganan ");
INSERT INTO klg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","na migtulluk sa balay nan. Una sakanan migkutkut menda' na dyumateng adti batu na sumalem aw dun sakanan pagtulluk sa balay. Aw pagbuntul na ba', pigtuluy ya balay yan manang wala' kalukad, kay to-o masalig ya kyatullukan. ");
INSERT INTO klg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Manang ya utaw na dyumengeg sa palna-u ku aw wala' nan daluga, kasiling uman sakanan na utaw na migtulluk sa balay dun ni tullukanan na dili' masalig. Aw pagbuntul na ba', pigtuluy ya balay yan aw dayaw nyalukad aw to-o migkalat.” ");
INSERT INTO klg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatigkas ni Jisus magpalna-u adti manga utaw, nyadtu sakanan adti lunsud na Kapirna-um. ");
INSERT INTO klg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na, dun ni Kapirna-um pag-eya' ya sambuk na kapitan sa manga sundalu aw awun kanan sugu-anen na to-o nan pigginawa͡an, manang kyedelan ya sugu-anen nan aw pakamatayenen da. ");
INSERT INTO klg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagdengeg na kapitan na awun si Jisus ni lunsud, pyakadtu nan ya manga magdadumala͡ay sa manga Judiyu dun ni lunsud, aw piglongan nan silan na manginayu' kan Jisus na madtu ni balay pada guli-en ya sugu-anen nan. ");
INSERT INTO klg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagdateng nilan adti kan Jisus, nyanginayu' silan to-o kanan, law nilan, “Ya utaw yeiy umba' mu sakanan tabangan, ");
INSERT INTO klg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kay pigginawa͡an nan ya kadég tadun na manga Judiyu aw migpatulluk sakanan kanaten sa sinagoga!” ");
INSERT INTO klg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yanagaw nyagad si Jisus kanilan. Sa malapit da silan adti balay, pigsugu' na kapitan ya manga ubaybay nan na sungunun nilan si Jisus aw paglongun sakanan, “Kay Sir, yeiy ya piglong kanmu na kapitan: ‘Dili' da kaw maglos, kay dili' aku saba makatumbuk magpapanik kanmu adti kanak balay. ");
INSERT INTO klg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yeiy ya du-an na beke' ku ya nyangay kanmu. Manang pangkay olo' da mu paglongun na kaguli-an sakanan, kaguli-an saba ya sugu-anen ku. ");
INSERT INTO klg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kay sambuk aku uman na magka͡agad sa matas pa kanak ya katundanan aw awun uman katundanan ku sa manga sundalu na madalem pa kanak. Kun sugu-un ku ya sambuk na “Kadtu kaw!” maksay sakanan madtu. Aw kun paglongun ku uman ya sambuk na “Kadi kaw!” madi sakanan. Aw pangkay unu ya sugu-an ku sa kanak sugu-anen, ka͡agadan nan saba.’ ” ");
INSERT INTO klg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sa pagdengeg ni Jisus sa piglong na kapitan, law nan, “Tay sa kadakula' na pangpangintu-u na utaw yeiy!” Aw miglong sakanan adti manga utaw na nyagad kanan, “Paglongun ta kamu: Ya eseg ini pangkay Héntil sakanan, manang wala' pa ku kita-a asini manga utaw na Isra-él ya maynini na pagpangintu-u.” ");
INSERT INTO klg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aw sa pagliku' da na manga pigsugu' na kapitan adti balay, kyinita' nilan na kyaguli-an da ya sugu-anen. ");
INSERT INTO klg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na, wala' kadugay, nyadtu si Jisus ni lunsud na pigngalanan na Na-in. Aw nyagad uman kanan ya manga umagakan nan aw ya madég to-o na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sa malapit da silan dumateng adti suwangan na lunsud, awun kyinita' nilan na manga utaw na lyumuwa' dun na migtingga sa lawas na nyatay kay un nilan lebeng. Aw ya nyatay, tamisa na ise' na eseg na sambuk na ka͡ubayan na balu. Aw madég to-o ya nyagad sa balu. ");
INSERT INTO klg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aw sa pagkita' ni Jisus sa balu, to-o sakanan nyallat. Aw piglongan nan, “Dili' kaw magsugaw.” ");
INSERT INTO klg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aw pigpalapitan nan ya lungun aw pig-awidan nan, aw tyumeneng ya manga migtingga. Aw piglongan ni Jisus ya nyatay, “Kay To', pagbangun kaw!” ");
INSERT INTO klg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aw migbangun ya nyatay aw miglong da, aw pigliku' ni Jisus adti ina nan. ");
INSERT INTO klg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aw to-o nyallek ya kadég na utaw sa pigkita' nilan. Aw pigdeyen nilan ya Tyumanem, law nilan, “Dyumateng da asini kanaten ya sambuk na propita na to-o matulus!” Aw miglong silan uman, “Pigtanaw da na Tyumanem ya manga utaw nan!” ");
INSERT INTO klg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aw ya ubat-ubat sa pig-imo' ni Jisus nyabekkal adti kadakula' na probinsiya na Judiya aw dun ni manga banwa na nyakapalibed. ");
INSERT INTO klg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na, ya kadég yeiy na pigpan-imo' ni Jisus, pig-ubat-ubat kan Juan na manga umagakan nan. ");
INSERT INTO klg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yanagaw pigtawag ni Juan ya duwa ya umagakan nan, aw pigpakadtu nan silan adti kan Jisus pada usipen kun sakanan ya pigpakang na Tyumanem asini muna aw kun awun pa tagadan nilan na eped. ");
INSERT INTO klg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aw sa pagdateng nilan adti kan Jisus, miglong silan, “Pigsugu' kami ni Juan na Magba͡utismuway pada musip kanmu kun ikaw ya pigpakang na Tyumanem asini muna na un madi aw kun awun pa eped na tagadan nami?” ");
INSERT INTO klg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, dun ni udas yan, pigpangguli' ni Jisus ya madég na pyangkedelan aw manga utaw na syeledan na busaw aw madég uman na buta. ");
INSERT INTO klg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yanagaw pigtubag ni Jisus ya manga pigsugu' ni Juan, law nan, “Liku' kamu adti kan Juan aw ubat-ubati mayu sakanan sa manga dyengeg mayu aw sa manga kyinita' mayu: Ya manga buta, kyumita' da. Ya manga pulid, nyakapanaw da. Ya manga ibungun, pyangkaguli-an aw malinis da. Ya manga bengel, dyumengeg da. Awun manga nyangkamatay na nyataw da. Ya manga tagitu' na utaw, kya-ubatan da sa Madyaw na Ubat-ubat. ");
INSERT INTO klg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aw madyaw ya kana manga utaw na wala' pagduwaduwa na aku ya Pigpadala na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sa pagpanaw da na manga pigsugu' ni Juan, pigpalekat ni Jisus ya pagkasampet kan Juan adti manga utaw na migkatipun, law nan, “Sa pagkadtu mayu adti kan Juan dun ni kaligbinan idtu muna, unu ka' ya kamayu pig-iman na du-an mayu sakanan pyaninaw? Pagaw nyadtu kamu na olo' magtandawtandaw sa utaw na kasiling na tigbaw na pig-eyeng-eyeng na samet. Beke' saba na maynan si Juan! ");
INSERT INTO klg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Manang ananga' kamu madtu ni kaligbinan? Pagaw iman mayu aw kumita' kamu sa utaw na syumut sa kadégkadég na mayaman. Ya utaw na maynan, adtu sakanan pagkita-en ni palasyo. Manang beke' saba uman na maynan si Juan! ");
INSERT INTO klg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yanagaw unu ka' ya pig-iman mayu na un mayu kita-en dun ni kaligbinan? Pig-iman gya mayu na kumita' sa propita. Paglongun ta kamu na si Juan beke' olo' na propita manang matas pa sakanan sa manga muna propita. ");
INSERT INTO klg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aw si Juan yeiy, yan ya pigkasampetan dadan dun ni pigpasulat na Tyumanem asini muna: ‘Pa-una͡en ku kanmu ya kanak mag-ubat-ubatay pada tagilanen nan ya un mu agiyan.’ ");
INSERT INTO klg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Paglongun ta kamu: Ya kadég na utaw na nya͡utaw asini tas na lupa', wala' ya pangkay sambuk na matas pa kan Juan na Magba͡utismuway. Manang ya to-o madalem na utaw na nyaka-akup adti Kasakupan na Pighari-an na Tyumanem, matas pa sakanan kan Juan.” ");
INSERT INTO klg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, pagdengeg da na kadég na manga utaw sa piglong ni Jisus, tyumande' silan na matinaw saba ya pigpa-ede' na Tyumanem magi kan Juan. Kay idtu muna sa pag-ubat-ubat pa ni Juan, migpaba͡utismu silan kanan, dala ya manga mangangubla͡ay sa buwis. ");
INSERT INTO klg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Manang awun madég na manga Parisiyo aw manga magpalna-uway sa Uldin na wala' nilan daluga ya tud na Tyumanem kanilan kay wala' silan pagpaba͡utismu kan Juan. ");
INSERT INTO klg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Migpadeleg si Jisus miglong, “Unu ya un ku kapa-unawa͡an sa manga utaw adun na gayed kyumele sa palna-u na dyengeg nilan? ");
INSERT INTO klg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kasiling silan na mangayse' na nyan-ingkud adti pamanag na palingki. Dili' silan malim magad magdanga pangkay pigtatawag silan na kanilan manga eped na maglong: ‘Naten magdanga! Migpasonata kami sa pangkasal, manang wala' kamu sayaw! Aw migpansi-engge' kami manang wala' kamu pagsugaw.’ ");
INSERT INTO klg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Maynan saba uman kamu. Kay dyumateng si Juan aw migpuwasa sakanan aw wala' inem sa bino. Aw miglong kamu, ‘Syeledan sakanan na busaw!’ ");
INSERT INTO klg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tigkas yan, dyumateng ya Ise' na Utaw. Kyinita' mayu sakanan kyuman aw nyinem eped nan ya madég na manga utaw. Manang miglong kamu baling, ‘Tanawa mayu ya utaw yeiy! To-o sakanan kyuman aw to-o nyinem sa bino, aw mig-ubaybay sakanan sa manga mangangubla͡ay sa buwis aw manga makasasala'!’ ");
INSERT INTO klg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pangkay maynan ya piglong mayu, manang ya palna-u ku aw palna-u ni Juan, alag saba pigmatinaw dun ni manga pigpan-imo' na kadég na utaw na dyumalug sa palna-u nami.” ");
INSERT INTO klg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na, awun sambuk na Parisiyo na pigngalanan na si Simon, aw piglongan nan si Jisus na kuman adti tampid nan. Yanagaw nyadtu si Jisus adti balay ni Simon aw kyuman dun ni lamisa. ");
INSERT INTO klg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, dun uman ni lunsud yan, awun sambuk na ka͡ubayan na makasasala'. Pagdengeg nan na kyuman si Jisus adti balay na Parisiyo, nyadtu sakanan aw dyumala sa tagbi' na sabuy na pig-imo' lekat adti batu na alabastro aw awun seled na manimbo'. ");
INSERT INTO klg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aw dyumulud apit adti bagakwang ni Jisus aw gayed migsugaw. Aw nyangkataktak ya manga luwa' nan dun ni manga siki ni Jisus, yanagaw piggalisan nan na kanan lugay aw pig-alekan nan ya manga siki aw dayaw nan asagi na manimbo'. ");
INSERT INTO klg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Manang ya Parisiyo na migpilit kan Jisus, kyinita' nan ya pig-imo' na ka͡ubayan yan, aw miglong sakanan adti anenganeng nan, “Kun tengteng propita ya utaw ini, ka-ede-an nan galu kun singalan ka͡ubayana ya nyawid kanan, kay ya ka͡ubayan iyan makasasala' saba.” ");
INSERT INTO klg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Manang kya-ede-an ni Jisus kun unu ya adti anenganeng nan aw yanagaw miglong sakanan, “Kay Simon, awun paglongun ku kanmu.” Aw tyumubag si Simon, “Unu yan, kay Magpalna-uway?” ");
INSERT INTO klg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aw miglong si Jisus sa pundinganan, law nan, “Awun sambuk na utaw na migpabeles sa kuwalta adti duwa ya utaw. Ya sambuk, nyeles sa limang gatus ka dinariyo aw ya sambuk uman nyeles olo' sa kalima͡an. ");
INSERT INTO klg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aw asuntu na dili' nilan mabatug bayadan ya kanilan beles, yanagaw wala' da silan pabayada na migpabeles kanilan. Na, singalan sa duwa ya to-o gyuminawa sa utaw na migpabeles kanilan?” ");
INSERT INTO klg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aw tyumubag si Simon, “Idtu na dakula' ya beles.” Aw miglong si Jisus kanan, “Matinaw saba ya tubag mu.” ");
INSERT INTO klg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aw piglingi' nan ya ka͡ubayan aw piglongan nan si Simon, “Kyinita' da mu ya pig-imo' na ka͡ubayan ini. Pagseled ku asini balay mu, wala' aku mu atagi na tubig pada pag-ugas sa manga siki ku. Manang ya ka͡ubayan ini, pig-ugasan nan baling ya manga siki ku na luwa' nan, aw piggalisan nan na kanan lugay. ");
INSERT INTO klg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aw wala' aku mu aleki kasiling na katanem tadun sa pagpangumusta. Manang ya ka͡ubayan ini, lekat pa na pagdateng nan asini gayed nan pig-alekan ya manga siki ku. ");
INSERT INTO klg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aw wala' mu asagi na lana na olibo ya kanak ulu, manang pig-asagan nan baling ya manga siki ku na manimbo'. ");
INSERT INTO klg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yangaw paglongun ta kaw: Madég saba ya manga sala' na ka͡ubayan yeiy, manang piglanas da kay dakula' ya ginawa nan kanak. Manang ya utaw na tabay ya manga sala' nan na un ku lanasen, tagbi' ya pagginawa nan kanak.” ");
INSERT INTO klg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aw miglong si Jisus adti ka͡ubayan, “Piglanas da ya manga sala' mu.” ");
INSERT INTO klg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aw ya manga utaw na kyuman eped ni Jisus, miglong silan adti kanilan anenganeng, “Singalan ka' utawa yeiy na makalanas sa manga sala'?” ");
INSERT INTO klg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Manang miglong si Jisus adti ka͡ubayan, “Ya pagpangintu-u mu, yan ya nyakapaluwa' kanmu. Yanagaw uli' da kaw na awun da kalinaw na kanmu anenganeng.” ");
INSERT INTO klg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lyumabay da ya pilangallaw aw nyanaw da uman si Jisus aw nyapit adti madég na manga lunsud aw manga baranggay. Aw pigpa-ede' nan ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem. Aw nyagad kanan ya sampulu' tag duwa ya umagakan nan. ");
INSERT INTO klg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aw awun uman nyagad kanilan na manga ka͡ubayan. Ya eped kanilan pigguli' da dadan ni Jisus ya magkedel nilan aw ya eped uman pig-alilinan da nan sa manga busaw. Ya sambuk kanilan yan si Maria na taga lunsud na Magdala na pig-alilinan ni Jisus idtu muna sa pitu ya busaw. ");
INSERT INTO klg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aw nyagad uman si Susana aw si Jo-ana aw eped pa na manga ka͡ubayan. Ya manga ka͡ubayan yeiy kyumamang silan lekat adti kanilan pagkamangan aw pigtabang nilan kan Jisus aw kanan manga umagakan. Na, ya eseg ni Jo-ana na si Kusa, yan ya sambuk na pagsaligan ni Hérodés Antipas. ");
INSERT INTO klg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aw sa migkatipun da adti tampid ni Jisus ya madég to-o na manga utaw na lyumekat adti madég na lunsud, piglongan nan silan magi sa pundinganan, ");
INSERT INTO klg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","law nan: “Awun sambuk na utaw na nyadtu ni pawa' nan na un magsabug sa manga bini'. Sa pagsabug nan sa manga bini', ya eped nyakasabug adti kilid na dalan aw kyataguna-an, aw pyanubug na manga langgam na tyumugpa' dun. ");
INSERT INTO klg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ya eped na manga bini' nyakasabug adti kabatuwan aw maksay gyumiti'. Manang nyalanes ya manga tanem kay magdang to-o ya lupa'. ");
INSERT INTO klg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ya eped na manga bini' nyakasabug adti magalet na suksukun. Gyumiti' ya manga bini', manang asuntu na tyumulin uman ya magalet, nyalemes baling ya manga tanem. ");
INSERT INTO klg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aw ya eped na manga bini' nyakasabug adti mataba' na lupa', tyumulin aw nyamunga na tag sanggatus.” Aw miglong pa si Jisus kanilan, “Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aw nyusip kan Jisus ya kanan manga umagakan kun unu ya kakawasan na pundinganan yeiy. ");
INSERT INTO klg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aw tyumubag sakanan kanilan, “Kamu ya pigtumbayan na Tyumanem na maka-ede' sa pigtagu' asini muna sa Kasakupan na Pighari-an nan. Manang awun manga eped na utaw na pangkay dyengeg da nilan ya manga pundinganan manang wala' tumbayan kanilan ya pagpakalabet sa kakawasan. Yanagaw pangkay gayed nilan inunuwun manang dili' nilan kita-en. Aw pangkay gayed nilan dengegen, manang dili' nilan kalabetan ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na, yeiy ya kakawasan na pundinganan: Ya tingeg na Tyumanem yan ya kasiling na manga bini' na pigsabug. ");
INSERT INTO klg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Ya kilid na dalan na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg da sa tingeg na Tyumanem manang dumateng si Satanas aw dampasen nan adti kanilan ya pigdengeg da nilan pada dili' silan mangintu-u aw dili' silan paluwa-en na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Aw ya kabatuwan na kyasabugan sa manga bini', yan ya manga utaw na dyumengeg sa tingeg na Tyumanem aw pigdawat nilan na awun pagleya manang dili' to-o makadalid ya pagpangintu-u nilan. Pagdateng na manga kalugan aw manga pagpamulayam asuntu sa pagpangintu-u nilan, ayawan nilan ya kanilan pagpangintu-u. ");
INSERT INTO klg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Aw ya magalet na sukusukun na kyasabugan uman sa manga bini', yan ya manga utaw na dyumengeg sa tingeg na Tyumanem aw nyangintu-u silan manang ya kanilan anenganeng nyatmu' na kakaypengan sa pagpakabetang nilan, aw sa pag-anenganeng na ma-imo' mayaman, aw sa manga pagkaliman nilan asini tas na lupa'. Aw ya sampetan yan, dili' makabunga ya kanilan pagpangintu-u. ");
INSERT INTO klg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Manang ya mataba' na lupa' na kyasabugan sa manga bini', yan ya manga utaw na migpakanyeg sa tingeg na Tyumanem aw gayed nilan pigbetang adti kanilan malinis na anenganeng, aw magi sa pagpadeleg nilan, nyamunga na to-o madég.” ");
INSERT INTO klg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Miglong pa si Jisus kanilan, “Wala' ya utaw na magsulu' sa salengan pada sangkuban nan, aw maynan uman, dili' betang adti dalem na katri. Manang betang nan baling adti bantawanan pada ka-ilawan ya kadég na awun ni seled na balay. ");
INSERT INTO klg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maynan uman, wala' ya nyatagu' adun na dili' kabukasan. Aw ya kadég na wala' pa kalabeti idtu muna, dili' madugay alag da saba kalabetan aw mabangal ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Yanagaw to-o mayu pakanyegi ya piglong ku kamayu. Kay ya utaw na dyumalug sa pigpalna-u kanan sa kana Tyumanem, dugangan pa ya kyalabetan nan. Manang ya utaw na wala' dalug sa palna-u yan, kamangen baling adti kanan ya pangkay tagbi' na kyalabetan da nan.” ");
INSERT INTO klg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na, dyumateng ya ina ni Jisus aw manga inulug nan, manang wala' silan pakapalapit asuntu sa kadég na manga utaw na nyakapalibed kanan. ");
INSERT INTO klg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aw awun miglong kan Jisus, “Awun ni luwa' ya ina mu aw manga inulug mu. Kaliman nilan magbalawbalaw kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tyumubag si Jisus kanilan, “Pangkay singalan ya dyumengeg sa tingeg na Tyumanem aw dyumalug sa dyengeg nilan, silan uman ya pigsiling ku na kanak manga inulug aw manga bubay aw ina ku.” ");
INSERT INTO klg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na, sambuk na allaw, miglong si Jisus adti kanan manga umagakan, “Naten tumalipag sa danaw.” Yanagaw syumakay silan adti balangay aw syuminan adti dipag. ");
INSERT INTO klg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Talana nilan syumakay, nyakatulug si Jisus. Aw bigla' dyumateng ya to-o mabandes na samet, aw syalampawan na manga baled ya balangay nilan aw un da matmu' na tubig. Aw agpet da galu silan malened. ");
INSERT INTO klg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yanagaw, maksay dyumulud kan Jisus ya manga umagakan nan aw pigpukaw nilan na miglong, “Kay Magpalna-uway! Un da kitadun mangkamatay!” Aw migbangun si Jisus aw pigsagda nan ya samet aw baled, law nan, ‘‘Tangke' kamu!’’ Aw tyumangke' ya samet aw migkalinaw da ya danaw. ");
INSERT INTO klg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Miglong si Jisus sa manga umagakan nan, “Ayin da saba ya pagsalig mayu kanak!” To-o silan nyallek aw nya-enneng-enneng aw mig-usip-usipay silan, “Singalan ka' ya utaw yeiy? Pangkay ya samet aw ya manga baled magka͡agad kanan!” ");
INSERT INTO klg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aw migpadeleg si Jisus aw manga umagakan nan syumakay sa balangay aw tyumalipag sa danaw, aw dyumateng silan adti banwa na pig-eya-an na manga taga Girasa dun ni dipag na Galilya. ");
INSERT INTO klg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sa pagpanog ni Jisus lekat adti balangay, awun eseg na syumungun kanan. Na, ya eseg yeiy nyeya' idtu muna adti lunsud, manang pigseledan sakanan na madég na busaw yanagaw madugay na wala' da sut sa kadégkadég aw wala' uman sakanan pag-eya' adti balay, manang adtu baling pag-eya' ni ilib na paglebengan sa nyangkamatay. ");
INSERT INTO klg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sa pagkita' nan kan Jisus, mig-ulangag sakanan aw nyangillupung adti asdangan nan. Aw miglong sa mabagseg na tingeg, “Kay Jisus na ise' na Tyumanem na To-o Matas, pabaya-i la aku! Nyanginayu' aku kanmu na dili' aku mu pagpati-isen!” ");
INSERT INTO klg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yan ya piglong nan kay tolobo pa ni Jisus pigsugu' ya busaw na lumuwa' dun ni utaw yan. Ya utaw yeiy madugay da sakanan pigseledan na manga busaw. Aw pangkay pigtunggu-an aw pigsangkali-an ya manga siki aw ya taklayan nan, manang dili' sakanan pagkatagenan. Pagpamugtu-un nan baling ya sangkali' aw pagbalukun nan ya putaw. Aw paggagaden sakanan na busaw adti kaligbinan. ");
INSERT INTO klg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tigkas yan, pig-usip sakanan ni Jisus, “Singalan ya ngalan mu?” Aw law nan, “Si Légion.” Kay madég saba ya manga busaw na syumeled kanan. ");
INSERT INTO klg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aw nyanginayu' pa silan kan Jisus na dili' nan silan pakawasen adti gawang na wala' ya katantanan. ");
INSERT INTO klg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, awun madég to-o na manga taku' na nyampangaliwad adti kakayaban na malapit dun. Yanagaw nyanginayu' kan Jisus ya manga busaw na tumbay galu kanilan na sumeled adti manga taku'. Aw pigtumbay silan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aw ya kadég nilan lyumuwa' lekat adti eseg aw syumeled silan adti manga taku'. Tigkas yan, nyampamalaguy ya kadég na manga taku' dun ni kakayaban aw pyangkawasan nilan ya pangpang adti ligad na danaw aw ya kadég nilan nyabus nyangkalemes. ");
INSERT INTO klg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na, ya manga magdadiyaga͡ay sa manga taku', sa pagkita' nilan sa nya-imo', nyalaguy silan adti lunsud aw pig-ubat-ubatan nilan ya manga utaw dun ni lunsud aw ya nyakapalibed dun. ");
INSERT INTO klg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yanagaw nyangkadtu ya manga utaw na un nilan tanawun ya nya-imo'. Aw sa pagdateng da nilan adti kan Jisus, kyinita' nilan ya eseg na abus da ka-alilini sa madég na manga busaw, aw nyingkud da sakanan adti asdangan ni Jisus na awun da kadégkadég aw migkadyaw da ya kanan anenganeng, aw asuntu seiy, nyangkallek silan. ");
INSERT INTO klg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aw ya manga utaw na kyumita' sa kadég na nyangka-imo', pig-ubat-ubatan nilan ya manga utaw kun pig-unu ya pagpaguli' sa utaw na pigseledan na manga busaw. ");
INSERT INTO klg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pagkatigkas yan, ya kadég na nyeya' adti palibed na lunsud na Girasa, nyanginayu' silan kan Jisus na indegan nan ya banwa nilan, kay alag silan to-o nyangkallek. Aw sa pagsakay da ni Jisus adti balangay na un da galu mindeg, ");
INSERT INTO klg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","nyanginayu' kanan ya eseg na kya-alilinan da sa manga busaw, law nan, “Magad aku galu kanmu!” Manang pigpapanaw sakanan ni Jisus, aw piglongan nan, ");
INSERT INTO klg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uli' da kaw adti kamayu aw ubati ya manga utaw sa kadakula' na pig-imo' kanmu na Tyumanem.” Aw nyindeg ya eseg aw pig-ubat-ubatan nan ya kadég na awun ni lunsud sa kadakula' na pig-imo' kanan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sa pagliku' ni Jisus adti dipag na danaw, migleya to-o ya manga utaw dyumawat kanan kay ya kadég nilan tyumagad kanan. ");
INSERT INTO klg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aw ya sambuk kanilan yan si Jairus na pagsaligan adti sinagoga. Dyumulud sakanan adti kan Jisus aw lyumuhud adti asdangan nan, aw nyanginayu' na madtu ni balay nan ");
INSERT INTO klg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kay kamatayenen da ya ise' nan na tamisa. Ya ise' nan yeiy dalagita la aw sampulu' pa tag duwa ya umay nan. Yanagaw nyagad si Jisus kanan. Sa pagpanaw da nilan, migpan-insek ya madég na manga utaw na nyakapalibed kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na, dun ni tenga' na kadég na manga utaw, awun sambuk na ka͡ubayan na gayed pigdugu-dugu' seled da na sampulu' tag duwa ya umay. Nyabus da ya kuwalta nan migpabulung aw wala' sakanan kaguli-i. ");
INSERT INTO klg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yanagaw dyumulud ya ka͡ubayan yan apit adti bagakwang ni Jisus aw pig-awidan nan ya pangaway na pigsut nan, aw dayaw tyumeneng ya kanan dugu'. ");
INSERT INTO klg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aw nyusip si Jisus kanilan, “Singalan ya nyawid kanak?” Aw ya kadég na manga utaw alag miglong na wala' silan awid kanan. Aw miglong si Pédro, “Enda', kay Magpalna-uway, kyinita' da mu saba ya kadég na manga utaw na mig-insek kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Manang miglong si Jisus, “Awun nyawid kanak kay pigbati' ku na awun katulus na lyumuwa' lekat adi kanak.” ");
INSERT INTO klg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pagka-ede' na ka͡ubayan na dili' da nan matagu', lyumiku' sakanan adti kan Jisus na pigtakigan. Aw nyangillupung adti asdangan ni Jisus aw pig-ubat nan adti kadég na manga utaw kun unu ya du-an na pig-awidan nan ya pigsut ni Jisus aw ya pagpakaguli' kanan. ");
INSERT INTO klg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aw miglong si Jisus kanan, “Kay Dé', asuntu sa pagpangintu-u mu kanak, yan ya nyakaguli' kanmu. Uli' kaw na awun da kalinaw na kanmu anenganeng.” ");
INSERT INTO klg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sa wala' pa si Jisus katigkas paglong adti ka͡ubayan yan, awun utaw na dyumateng lekat adti balay ni Jairus, aw law nan, “Nyapalus da beg ya ginawa na ise' mu, kay Sir! Dili' da mu pagpagudun ya Magpalna-uway.” ");
INSERT INTO klg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagdengeg ni Jisus sa piglong na utaw yan, miglong sakanan kan Jairus, “Dili' kaw magkallek. Pangintu-u kaw olo' aw kaguli-an ya ise' mu.” ");
INSERT INTO klg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sa pagdateng da ni Jisus adti balay ni Jairus, wala' sakanan kalim agadi na manga utaw adti seled. Yan olo' ya pigpa-agad nan si Pédro aw si Juan aw si Santiago, aw ya ama aw ina na ise'. ");
INSERT INTO klg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aw ya manga utaw adti luwa', alag silan migpansisugaw aw migpansimatay. Manang miglong si Jisus kanilan, “Dili' kamu magsugaw kay wala' saba kamatay ya ise'. Nyakatulug olo' sakanan!” ");
INSERT INTO klg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aw nyaka-ikel baling silan sa piglong nan kay kya-ede-an nilan na nyatay da ya ise'. ");
INSERT INTO klg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Manang pig-awidan ni Jisus ya bekten na ise' aw law nan, “Kay Dé', pagbangun kaw!” ");
INSERT INTO klg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aw lyumiku' ya ginawa nan aw dayaw sakanan migbangun aw nyindeg. Aw migsugu' si Jisus na atagan nilan na kakan ya ise'. ");
INSERT INTO klg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","To-o nya-enneng-enneng ya manga mangkatikadeng nan sa kyinita' nilan. Manang piglongan silan ni Jisus, “Ya-i mayu pag-ubat-ubatan adti eped na utaw ya nya-imo'.” ");
INSERT INTO klg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pagkatigkas yan, pigpatawag ni Jisus dun ni sayid nan ya sampulu' tag duwa ya kanan manga umagakan na dadan da nan pigpamalli', aw pig-atagan nan silan na katulus na un mag-alilin sa kadég na manga busaw aw magguli' sa manga utaw na awun magkedel. ");
INSERT INTO klg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aw pigsugu' silan ni Jisus pada mag-ubat-ubat sa Kasakupan na Pighari-an na Tyumanem, aw mangguli' sa manga utaw na kyedelan. ");
INSERT INTO klg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aw piglongan nan silan, “Dili' kamu magdala sa pangkay unu na manga pametang mayu. Dili' kamu magdala sa bangka', aw kabil, aw makan, aw kuwalta, aw manga ilisan. ");
INSERT INTO klg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aw kun ayin ya balay na datengan mayu, dun da kamu pag-eya' menda' na indegan mayu ya lunsud yan. ");
INSERT INTO klg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aw pangkay ayin na banwa ya kadtuwan mayu, kun dili' kamu dawaten na manga utaw dun, sa pag-indeg mayu dun ni lunsud yan, taptapa ya alikabuk na manga siki mayu. Kay yan ya pangilala na ukuman silan na Tyumanem adti kamoliyan na allaw.” ");
INSERT INTO klg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aw nyindeg silan, aw pigkadtuwan nilan ya manga baranggay, aw gayed nilan pigpa-ede' ya Madyaw na Ubat-ubat. Aw pangkay ayin silan kadtu, awun pigpangguli' nilan na manga utaw na kyedelan. ");
INSERT INTO klg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, si Hérodés Antipas ya migdumala sa banwa na Galilya. Dyengeg nan ya kadég na pigpan-imo' ni Jisus, aw nyabelengbeleng sakanan kay awun manga utaw na miglong na yan kunu si Juan na Magba͡utismuway na nyataw lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aw awun uman manga eped na miglong na lyumiku' da si Éliyas. Aw miglong pa uman ya eped na nyataw da lekat adti nyangkamatay ya sambuk na propita na Tyumanem asini muna. ");
INSERT INTO klg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Manang miglong si Hérodés, “Pigpa-utudan da ku saba si Juan sa ulu nan! Singalan utawa yeiy na gayed ku pigdengeg na migpan-imo' sa maynan?” Yanagaw pigtibagsegan ni Hérodés na kita-en nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, lyumiku' ya manga apostolés adti tampid ni Jisus aw pigdandan nilan kanan ya manga nyangka-imo' nilan. Aw pigpa-agad nan silan adti lunsud na Bétsayda na olo' silan. ");
INSERT INTO klg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Manang pagka-ede' da na madég na manga utaw na nyindeg da silan, dyumalug silan kan Jisus. Pagdateng nilan dun, alag nan silan pigdawat aw piglongan sa Kasakupan na Pighari-an na Tyumanem, aw pigpangguli' nan ya manga awun magkedel. ");
INSERT INTO klg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na, pagka͡ambung da, dyumulud kan Jisus ya sampulu' tag duwa ya umagakan nan aw miglong kanan, “Ayin ya madyaw kun papanawun da ya manga utaw adti manga baranggay na malapit asini, pada makabayad silan sa un nilan makan aw makapaninaw silan sa balay na kabantukan nilan. Kay kaligbinan ya banwa ini.” ");
INSERT INTO klg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Manang tyumubag si Jisus kanilan, “Kamu baling ya matag sa un nilan makan.” Aw miglong silan kanan, “Ya asini kanami olo' da limallapid ya pan aw duwambulus ya isda'. Kun malim kaw, manaw pa kami aw mayad sa makan na maka-umba' kanilan.” ");
INSERT INTO klg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na, ya kadég na manga eseg dun, manga limammalalan silan. Aw piglongan ni Jisus ya kanan manga umagakan, “Pa-ingkuda mayu ya manga utaw na tag kaliman.” ");
INSERT INTO klg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aw pigtuman nilan ya piglong ni Jisus aw pigpa-ingkud nilan ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pagkatigkas yan, pigkamang ni Jisus ya limallapid ya pan aw duwambulus ya isda', aw lyumangad sakanan adti langit aw pigpasalamatan nan adti Tyumanem. Aw tigkas yan, pigtenga-tenga' ni Jisus aw pig-atag nan adti kanan manga umagakan aw pig-atped-atped uman nilan adti kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kyuman ya kadég nilan aw alag silan nyangkabiyag. Aw pigpan-imun na manga umagakan nan ya nyangkasama', aw nyatmu' ya sampulu' tag duwa ya be-en. ");
INSERT INTO klg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sambuk na allaw, nyanawagtawag si Jisus na olo' nan sayda, aw malapit dun ni tampid nan ya kanan manga umagakan. Aw pig-usip nan silan, “Dun ni pagbalawbalaw na manga utaw, singalan kunu aku?” ");
INSERT INTO klg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aw tyumubag silan, “Ya eped miglong na ikaw kunu si Juan na Magba͡utismuway. Aw awun eped na miglong na ikaw kunu si Éliyas, aw awun pa uman eped na miglong na ikaw ya sambuk na propita asini muna na nyataw da.” ");
INSERT INTO klg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aw pig-usip pa silan ni Jisus, “Manang adti kamayu, singalan aku?” Aw tyumubag si Pédro, “Ikaw saba ya Kristu na Pigpadala na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aw piglongan silan ni Jisus na dili' nilan yeiy pagpa-ede' adti pangkay singalan utawa. ");
INSERT INTO klg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aw miglong pa si Jisus kanilan, “Aku na Ise' na Utaw ka-ilangan magti-is aw kele͡an na manga magdadumala͡ay sa manga Judiyu aw manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin. Aw papatay nilan, manang pagkatlu na allaw mataw aku.” ");
INSERT INTO klg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aw miglong si Jisus adti kadég nilan, “Pangkay singalan ya malim ma-imo' kanak umagakan, ka-ilangan ayawan nan ya kanan pagkaliman aw pisanen nan ya kanan krus kada allaw aw dumalug kanak. ");
INSERT INTO klg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pangkay singalan ya gyuminawa sa pagka-utawun nan asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay, yan ya un makatagtun sa ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Unu ka' ya un ma-untung na utaw kun matagtun nan ya kadakula' na banwa manang kalagakan baling sa ginawa nan? ");
INSERT INTO klg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pangkay singalan ya mamulamula asuntu kanak na Ise' na Utaw aw sa palna-u ku, kamulamula ku uman ya utaw yan dun ni allaw na pagliku' ku asini tas na lupa'. Aw dun ni pagliku' ku, kita-en ya kanak kalalamdag aw ya kalalamdag uman na kanak Ama aw manga anghil na lekat adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Matinaw saba ya un ku paglongun kamayu: Awun eped asini kamayu na dili' nilan apeten ya pagkamatay menda' na kita-en nilan ya paghari' na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, paglabay da na walungallaw lekat na paglong ni Jisus sa kadég yeiy, tyumukud sakanan adti sambuk na buntud na un manawagtawag adti Tyumanem. Aw pigpa-agad nan si Pédro aw si Juan aw si Santiago. ");
INSERT INTO klg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Talana ni Jisus nyanawagtawag, nya-uman ya gya nan, aw ya kadégkadég nan to-o maputi' aw masilang. ");
INSERT INTO klg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aw tigkan migpakita' ya duwa ya utaw na si Moysis aw si Éliyas, aw migbalawbalaw silan si Jisus. ");
INSERT INTO klg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aw kya-ilawan uman silan na kalalamdag. Aw yan ya pigbalawbalawan nilan ya pagkamatay ni Jisus na agpet da matuman adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, si Pédro aw manga eped nan to-o silan nyakatulug. Manang sa pagmata nilan, kyinita' nilan ya dakula' na kalalamdag na pagka Tyumanem ni Jisus, aw kyinita' nilan uman ya duwa ya eped nan na nyindeg dun ni sayid nan. ");
INSERT INTO klg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aw sa un da manaw ya duwa ya utaw yeiy, miglong si Pédro kan Jisus, “Kay Magpalna-uway, madyaw kay ini kami. Magtulluk kami sa tulu ya layag, sambuk ya kanmu, sambuk ya kan Moysis aw sambuk uman ya kan Éliyas.” Manang wala' ni Pédro ka-ede-i kun unu ya piglong nan. ");
INSERT INTO klg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sa talana pa nan miglong, awun labun na tyumakleb kanilan, aw to-o silan nyallek. ");
INSERT INTO klg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aw awun tingeg na lekat adti labun na miglong, “Yeiy ya kanak Ise' na pigpadala ku. Pakanyegi mayu sakanan!” ");
INSERT INTO klg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aw sa pagteneng da na tingeg, pigkita' nilan na dakman olo' si Jisus ya nyasama'. Aw ya kadég na pigkita' nilan dun ni allaw yan, wala' nilan ubatan adti pangkay singalan. ");
INSERT INTO klg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na, salut na allaw, sa pagtubang nilan lekat adti buntud, madég ya manga utaw na syumungun kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aw dun ni kadég nilan, awun sambuk na eseg na miglong sa mabagseg na tingeg, law nan, “Kay Magpalna-uway, tanawa beg ya ise' ku na eseg, kay yeiy ya ise' ku na tamisa. ");
INSERT INTO klg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Malikit sakanan pagseledan na busaw aw tigkan sakanan mag-ulangag aw pagtakigan menda' na magsula' ya baka' nan. Gayed sakanan pagpati-isen na busaw na syumeled kanan aw dili' da malim lumuwa' ya busaw lekat adti kanan. ");
INSERT INTO klg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nyanginayu' da aku sa manga umagakan mu na alilinan nilan ya busaw adti kanan, manang wala' nilan kabatug.” ");
INSERT INTO klg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aw miglong si Jisus, “Tay sa manga utaw adun na manga allaw yeiy na baluk ya anenganeng aw wala' ya pagpangintu-u! Sangunu ka' ya kadugay na mati-is ku ya pag-iyagad kamayu?” Aw piglongan ni Jisus ya ama na ise', “Pa-agadan adi sayid ku ya ise' mu.” ");
INSERT INTO klg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aw sa pagpa-agad da sa ise' adti kanan, piglagpes na busaw ya ise' dun ni lupa' aw to-o pigtakigan. Manang pigsagda ni Jisus ya busaw aw dayaw kyaguli-an ya ise', aw pigliku' ni Jisus adti ama nan. ");
INSERT INTO klg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aw ya kadég na kyumita' sa nya-imo', nya-enneng-enneng silan sa kadakula' na katulus na Tyumanem. Aw sa talana pa nya-enneng-enneng ya manga utaw sa kadég na nya-imo' ni Jisus, miglong sakanan adti manga umagakan nan, ");
INSERT INTO klg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pakanyegi mayu to-o ya un ku paglongun kamayu: Aku na Ise' na Utaw agpet da tumbay adti manga utaw na un magpatay kanak.” ");
INSERT INTO klg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Manang wala' nilan kalabeti ya kakawasan na piglong ni Jisus kay pigtagu' pa adti kanilan pada dili' nilan ka-ede-an. Aw nyallek silan nyusip sa piglong nan. ");
INSERT INTO klg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aw migpan-ayil ya manga umagakan ni Jisus kun singalan kanilan ya to-o matas. ");
INSERT INTO klg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Manang kya-ede-an ni Jisus ya kanilan anenganeng. Yanagaw kyumamang sakanan sa tagbi' na ise' aw pigpa-indeg nan dun ni tampid nan. ");
INSERT INTO klg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aw miglong si Jisus kanilan, “Pangkay singalan kamayu ya dumawat sa utaw na madalem kasiling na ise' ini asuntu sa pagdalug mayu kanak, dun da aku nan uman dawata. Aw pangkay singalan ya dumawat kanak, dun da nan uman dawata ya Ama na migpadala kanak. Kay kun singalan ya magpadalem, yan baling ya to-o matas.” ");
INSERT INTO klg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aw miglong si Juan kan Jisus, “Kay Magpalna-uway, kyinita' nami ya sambuk na utaw na mig-alilin sa manga busaw dun ni kanmu ngalan, aw miglong kami kanan na botonan nan ya pigpan-imo' nan kay beke' saba sakanan na eped tadun!” ");
INSERT INTO klg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Manang miglong si Jisus kanilan, “Ya-i mayu sakanan pagtageni! Kay kun singalan ya wala' pagbalabag kamayu, yan ya syumambuk kamayu.” ");
INSERT INTO klg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na, sa malapit da dumateng ya manga allaw na ma-engat si Jisus adti tas na langit, pigbetang nan adti kanan ginawa ya pagkadtu adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aw awun manga utaw na pigpa-una nan adtu ni sambuk na baranggay sakup na Samariya pada tagilanen nilan ya kanan kabantukan. ");
INSERT INTO klg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Manang ya manga utaw na nyeya' dun ni baranggay yan, dili' silan malim dumawat kan Jisus kay kya-ede-an nilan na un sakanan madtu ni Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aw sa pagkita' na manga umagakan nan na wala' sakanan dawata, miglong si Santiago aw si Juan kan Jisus, “Kay Magpalna-uway, unu, kaliman mu magsekat kami adti Tyumanem na pa-ulanan nan ya kadég nilan na atulun pada mabus silan masangab?” ");
INSERT INTO klg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Manang piglingi' silan ni Jisus aw pigsagda nan silan. ");
INSERT INTO klg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aw migpadeleg silan nyanaw pasinan adti eped na baranggay. ");
INSERT INTO klg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Talana nilan nyanaw, awun sambuk na utaw na miglong kan Jisus, “Kay Magpalna-uway, magad aku kanmu pangkay ayin kaw pasinan.” ");
INSERT INTO klg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aw miglong si Jisus kanan, “Ya manga mile' awun pugala' na kanilan pagka-eya-an, aw ya manga langgam awun kanilan pugad. Manang ya Ise' na Utaw, wala' ya balay na un nan kabantukan.” ");
INSERT INTO klg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aw miglong pa uman si Jisus adti eped na utaw, “Agad kaw kanak!” Manang tyumubag kanan ya utaw, “Kay Magpalna-uway, tumbayan pa una kanak na muli' aku adti kanami pada maglebeng sa ama ku.” ");
INSERT INTO klg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Manang tyumubag si Jisus kanan, “Pabaya-an da sa manga utaw na wala' pangintu-u ya paglebeng sa nyatay. Manang ikaw, panaw da kaw aw ubat-ubatan ya Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aw awun pa uman eped na utaw na miglong kan Jisus, “Kay Magpalna-uway, dumalug aku kanmu, manang tumbayan pa una kanak na muli' aku adti kanami kay un pa ku sabiyen ya kanak pamilya.” ");
INSERT INTO klg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Manang tyumubag si Jisus kanan, “Ya utaw na migdaru na gayed maglingi-lingi', makasuway ya agi na daru nan. Maynan uman ya utaw na wala' katibulluk ya kanan anenganeng adti pagdalug kanak. Dili' sakanan umba' maka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatigkas na kadég yeiy, nyamalli' pa uman si Jisus sa kapituwan tag duwa ya utaw. Aw pigsugu' nan silan na tag duwaduwa pada muna kanan adti manga lunsud aw kadég na manga banwa na un nan kadtuwan. ");
INSERT INTO klg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aw sa wala' pa silan indeg, miglong sakanan kanilan, “Dakula' to-o ya aniyenen, manang tabay ya mag-aniyay. Yanagaw panawagtawag kamu adti Tyumanem na yan ya tagtun sa palangad aniyenen na magpadala sakanan sa manga mag-aniyay.” ");
INSERT INTO klg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, panaw kamu. Manang pakanyegi ya un ku kamayu paglongun: Padala ta kamu adti manga utaw na mangkalatay ya bet. Kasiling kamu saba na manga nati na karniro na nyadtu ni manga malyaw na idu' na to-o mangkabulut. ");
INSERT INTO klg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dili' kamu magdala sa pu-ut, aw kabil, aw sandal. Dili' kamu magteneng dun ni dalan na un mangumusta sa utaw, pada dili' kamu masalang. ");
INSERT INTO klg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pangkay kanyan balay ya datengan mayu, maynini ya una mayu paglongun kanilan: ‘Atagan na Tyumanem na kalinaw ya kadég na asini balay ini.’ ");
INSERT INTO klg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aw kun kaliman nilan dumawat sa kalinaw na piglong mayu, atagan saba silan na Tyumanem na kalinaw. Manang kun dili' silan dumawat, dili' uman silan atagan. ");
INSERT INTO klg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aw kun mamasa silan kamayu, dun da kamu pag-eya' aw dili' kamu mag-alin-alin. Sumambuk kamu kanilan kuman aw minem. Aw pangkay unu ya pakan aw pa-inem nilan kamayu, dawata mayu kay ya utaw na migtalabahu umba' saba sakanan tandanan. ");
INSERT INTO klg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kun dumateng kamu adti sambuk na lunsud aw dawaten kamu nilan, pangkay unu ya pakan nilan kamayu, kana mayu. ");
INSERT INTO klg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pangguli-a mayu ya magkedel na manga utaw dun ni lunsud aw paglonga mayu silan, ‘Malapit da adti kamayu ya Paghari' na Tyumanem sa Kasakupan nan.’ ");
INSERT INTO klg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Manang pangkay kinunu kamu dateng adti sambuk na lunsud aw dili' kamu nilan dawaten, na, kadtu kamu baling ni manga dalan adti lunsud yan aw paglonga mayu silan, ");
INSERT INTO klg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pangkay ya alikabuk na lunsud mayu na dyumeket asini siki nami, un nami taptapen na yan ya pangilala na ukuman kamu na Tyumanem. Manang anenganenga mayu ya ini: Malapit da ya Paghari' na Tyumanem sa Kasakupan nan.’ ” ");
INSERT INTO klg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aw miglong pa uman si Jisus kanilan, “Paglongun ta kamu, dun ni allaw na pag-ukum na Tyumanem kagaya, to-o pa mabegat ya pa-emel-emel nan sa manga lunsud na dili' dumawat kamayu kay sa pagpa-emel-emel nan sa manga utaw adti Sodoma!” ");
INSERT INTO klg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aw miglong pa uman si Jisus, “Kadég mayu na taga lunsud na Korazin aw Bétsayda, malatay ya un mayu datengan! Kay kyinita' da mayu ya manga milagru na pig-imo' ku, manang tabay kamayu ya migselsel. Kun pig-imo' pa ku yeiy adti manga lunsud na Tiro aw Sidon, madugay da galu silan magselsel aw mangawak sa kalapeng aw magsabug sa abu adti ulu nilan na yan ya pangilala sa kanilan pagselsel. ");
INSERT INTO klg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dun ni allaw na pag-ukum, to-o pa mabegat ya pa-emel-emel na Tyumanem adti manga lunsud na Korazin aw Bétsayda kay sa Tiro aw Sidon. ");
INSERT INTO klg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Aw kamu na nyeya' dun ni Kapirna-um, unu, iman mayu aw ya pagkadengganen mayu dyumateng adti tas na langit? Manang dala͡en kamu baling adti banwa na Kaludukan.” ");
INSERT INTO klg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Ya magpakanyeg kamayu, kasiling na aku ya pigpakanyegan nilan. Aw ya kumele kamayu, kasiling na aku ya pigkele͡an nilan. Aw ya kyumele kanak, kyumele uman sa migpadala kanak.” ");
INSERT INTO klg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na, lyumiku' da ya kapituwan tag duwa ya pigsugu' ni Jisus, aw to-o silan migleya. Aw miglong silan, “Kay Magpalna-uway, pangkay ya manga busaw pigka͡agadan kami nilan dun ni pag-alilin nami magi sa kanmu ngalan!” ");
INSERT INTO klg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aw miglong si Jisus kanilan, “Kyinita' ku saba si Satanas na bigla' nyolug lekat adti langit kasiling na kilat. ");
INSERT INTO klg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Na, pakanyegi ya un ku kamayu paglongun: Pig-atagan ku kamu sa katundanan pada degen ya katulus ni Satanas, aw pangkay kun makagina' kamu sa manga ulud aw manga sangalan, dili' kamu ma-unu. ");
INSERT INTO klg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Manang dili' mayu pagleya͡an na pigka͡agadan kamu na manga busaw, yan baling ya pagleya͡an mayu na nyasulat da ya kamayu manga ngalan adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na, idtu na udas yan, to-o migleya si Jisus sa manga pigpan-imo' na Ispiritu Santo, aw nyanawagtawag sakanan, law nan, “Kay Ma', ikaw ya tagtun sa kadég na awun ni tas na langit aw asini kadakula' na banwa. Pigpasalamatan ta kaw kay pigtagu' mu ya kanmu palpa lekat adti manga utaw na matas kunu ya katadeng manang pigbukasan mu baling adti manga utaw na tagbi' ya katadeng kasiling na tagbi' na ise'. Yeiy saba kay Ma' ya kanmu pagkaliman.” ");
INSERT INTO klg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Pigtumbay da na Ama adi kanak ya kadég. Aw ya kanaken Ama, yan olo' ya nyaka-ede' kanak. Aw aku olo' ya nyaka-ede' kanan, aw pangkay singalan uman na tumbay ku na maka-ede' sa Ama.” ");
INSERT INTO klg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aw nyatubang si Jisus adti manga umagakan nan, aw miglong kanilan, “Madyaw ya kamayu kay kyinita' da mayu ya pigpan-imo' ku! ");
INSERT INTO klg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Paglongun ta kamu na awun madég na manga propita na Tyumanem aw manga hari' asini muna na kaliman nilan galu kita-en ya kyinita' da mayu, aw kaliman nilan galu dengegen ya dyengeg da mayu, manang wala' nilan kita-a aw wala' nilan dengega.” ");
INSERT INTO klg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na, ya sambuk na magpalna-uway sa Uldin, kaliman nan tanda-en si Jisus magi sa usip. Yanagaw nyindeg sakanan aw miglong, “Kay Magpalna-uway, unu ya ka-ilangan ku imo-un pada matagtun ku ya ginawa na wala' ya katigkasan?” ");
INSERT INTO klg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aw tyumubag si Jisus kanan, “Unu ya awun ni Uldin na pigpasulat na Tyumanem? Unu ya kyalabetan mu lekat adti pigbasa mu?” ");
INSERT INTO klg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aw tyumubag ya magpalna-uway, “Yan ya nyakasulat dun ni Uldin na ‘Ginawa͡an mu ya kanmu Tyumanem sa kadakula' na pagka-utawun mu, aw sa kadakula' na ginawa mu, aw sa kadakula' na kabagseg mu, aw sa kadakula' na anenganeng mu’, aw ‘Ginawayi ya eped mu na utaw kasiling na pagginawa mu sa kanmu pagka-utawun.’ ” ");
INSERT INTO klg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aw miglong si Jisus kanan, “Matinaw saba ya tubag mu. Kun imo-un mu yeiy, matagtun mu ya ginawa na wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Manang dili' malim ya magpalna-uway na mamulamula sakanan, yanagaw pig-usip pa nan uman si Jisus, “Singalan ya eped ku na un ku ginawa͡an?” ");
INSERT INTO klg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aw tyumubag si Jisus magi sa pundinganan, “Awun sambuk na utaw na Judiyu na tyumubang lekat adti Jérusalim na migpasinan adti Jériko. Talana nan nyanaw, byanganan sakanan na manga mangkatakaw. Pigpalluwasan nilan sa kadégkadég aw pyangamang nilan ya manga pametang nan. Aw tigkas yan, pigbadasan nilan pyamunalan aw pig-ayawan nilan na dakman tag sambuk ya ginawa. ");
INSERT INTO klg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yan uman na udas, nyaka-agi dun ya sambuk na magdadugsu-ay na lekat adti Témplo na Tyumanem. Sa pagkita' nan sa utaw na nyakakulang adti ligad na dalan, pig-aliwes nan baling aw nyagi adti sangkilid na dalan. ");
INSERT INTO klg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Maynan uman ya sambuk na buwadbuwad ni Libi na magtabang sa imo-unun adti Témplo. Sa pagkita' nan sa utaw na nyakakulang dun ni ligad na dalan, pig-aliwes nan uman. ");
INSERT INTO klg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Manang awun uman sambuk na utaw na Samariyanen na nyaka-agi dun ni dalan. Aw sa pagkita' nan sa utaw na nyakakulang, to-o sakanan nyallat. ");
INSERT INTO klg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yanagaw, pigdulud nan ya utaw aw pigbulung nan. Pig-asagan nan na bino aw lana ya manga pali' aw dayaw nan bedbedi. Tigkas yan, syagupu nan aw pigpasakay adti kanan asnu aw pigdala nan adti balay na bantukanan aw to-o nan pigdiyaga͡an. ");
INSERT INTO klg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkasalut da na allaw, pig-atagan nan ya tagtun sa balay na duwangka dinariyo ya kuwalta aw law nan, ‘Dayaw kanak diyagayi ya utaw ini. Aw kun dili' pa maka-umba' ya pigbayad ku kanmu, sa pagliku' ku asini dugangan da ku.’ ” ");
INSERT INTO klg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pagkatigkas ni Jisus maglong sa pundinganan, pig-usip nan ya magpalna-uway sa Uldin, “Na, dun ni kanmu anenganeng, sa tulu silan, ayin kanilan ya tengteng gyuminawa sa utaw na byanganan dun ni dalan?” ");
INSERT INTO klg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aw tyumubag ya magpalna-uway, “Ya idtu na nyallat kanan.” Aw miglong si Jisus, “Yanagaw, imo-a uman ya maynan.” ");
INSERT INTO klg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Migpadeleg si Jisus nyanaw aw ya kanan manga umagakan aw dyumateng silan adti sambuk na baranggay. Awun sambuk na ka͡ubayan na nyamasa kan Jisus adti balay nan, aw ya ngalan nan si Marta. ");
INSERT INTO klg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na, si Marta awun kaylug nan na si Maria. Aw si Maria, nyingkud sakanan malapit adti sayid ni Jisus aw to-o migpakanyeg sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Manang si Marta, nyasagunut to-o ya kanan anenganeng asuntu sa kadég na imo-unun nan sa pagsanggila' kanilan. Yanagaw dyumulud si Marta adti kan Jisus aw miglong, “Kay Magpalna-uway, unu, pabaya-an da mu gayed si Maria na dili' aku nan tabangan sa manga imo-unun ku?” ");
INSERT INTO klg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Manang tyumubag si Jisus kanan, “Kay Marta, tay sa kadég na pig-anenganeng mu! ");
INSERT INTO klg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sambuk da saba olo' ya awun tengteng ma-untung aw yan ya pigpamalli' ni Maria. Aw dili' saba makamang lekat adti kanan.” ");
INSERT INTO klg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na, sambuk na allaw yan, pagkatigkas da ni Jisus manawagtawag, miglong kanan ya sambuk na umagakan nan, “Kay Magpalna-uway, si Juan na Magba͡utismuway pigpalna-uwan nan ya manga umagakan nan sa pagpanawagtawag. Palna-uwi kami uman sa pagpanawagtawag adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yanagaw miglong si Jisus kanilan, “Sa kamayu pagpanawagtawag, maynini ya paglongun mayu: ‘Kay Ama, pagbasa͡an na kadég na utaw ya kanmu ngalan. Migsekat kami na dumateng adi kanami ya Kasakupan na Pighari-an mu. ");
INSERT INTO klg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sambata beg ya kanami pagkan adun na allaw yeiy. ");
INSERT INTO klg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aw lanasa ya manga sala' nami, kay pigpasinsiya͡an nami uman ya kadég na nyakasala' kanami, aw dili' mu kami pagpabaya-an adti pagtanda' na dili' nami mabatug degen.’ ” ");
INSERT INTO klg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aw miglong pa uman si Jisus adti kanilan, “Alimbawa' kun awun sambuk kamayu na madtu ni balay na ubaybay nan na magtenga' da ya gabi aw magtatawag na maglong, ‘We.... Lew, pabelesa aku beg na tulullapid ya mabakla' na pan, ");
INSERT INTO klg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kay awun ubaybay ku na bagu dyumateng lekat adti mawat aw wala' ya un ku pakan kanan!’ ");
INSERT INTO klg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aw tumubag sakanan lekat adti seled na balay, ‘Ya-i la aku paglinggala. Pigbalagsangan da ku ya tatakep aw kyumulang da ya kanak mangayse' asini tampid ku, yanagaw dili' da aku maka-atag kanmu sa pangkay unu.’ ");
INSERT INTO klg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Paglongun ta kamu: Pangkay dili' sakanan malim magbangun aw matag adti ubaybay nan, manang asuntu na wala' kamulamula gyumelgel migsekat ya utaw yan, magbangun da sakanan aw matag sa pigsekat nan. ");
INSERT INTO klg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Yanagaw paglongun ta kamu: Pagsekat kamu adti Tyumanem, aw atagan kamu nan. Tibagsegi mayu ya pagpaninaw, aw pakita' nan kamayu. Pagtatawag kamu adti kanan, aw uwangan kamu nan. ");
INSERT INTO klg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kay ya kadég na magsekat adti kanan, un nan saba atagan. Aw ya kadég na maninaw, awun saba kita-en nilan. Aw ya kadég na magtatawag adti kanan, un nan saba silan uwangan. ");
INSERT INTO klg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Alimbawa', kamu na manga ama, kun magsekat ya ise' mayu sa isda', unu, atagan mayu baling na ulud? Dili' saba! ");
INSERT INTO klg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aw kun magsekat silan sa ise' na manuk, atagan ka' mayu baling na sangalan? Dili' saba! ");
INSERT INTO klg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yanagaw, pangkay makasasala' kamu, manang kya-ede-an mayu kun unu ya madyaw atag adti kamayu mangayse'. Na, to-o pa dun ya Ama mayu na adti tas na langit. Atag nan saba ya kanan Ispiritu adti kadég na magsekat kanan.” ");
INSERT INTO klg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na, sambuk na allaw, mig-alilin si Jisus sa busaw na syumeled adti utaw na nyakapa-umu kanan. Sa abus da ni Jisus alilini ya busaw, nyakapaglong da ya utaw yan. Aw to-o nya-enneng-enneng ya kadég na utaw. ");
INSERT INTO klg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Manang awun eped kanilan na miglong, “Ya kanan pag-alilin sa manga busaw, magi saba sa katulus ni Bilsibul na pangulu na manga busaw.” ");
INSERT INTO klg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aw awun uman eped kanilan na kaliman nilan tanda-en si Jisus. Yanagaw migsekat silan kanan sa pangilala na magmatinaw kun yan ya Pigpadala na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Manang kya-ede-an ni Jisus ya adti anenganeng nilan aw yanagaw piglongan nan silan, “Ya kasakupan na nyatenga-tenga', dili' yan magpadeleg na madugay. Aw maynan uman ya ka-epedanan dun ni balay na awun pagkatenga-tenga'. ");
INSERT INTO klg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aw kun si Satanas ya mig-alilin sa manga sakup nan, na, kasiling na pigtanam nan ya kanan pagka-utawun, aw dun da baling sakanan dega. Miglong kamu na pig-alilinan ku ya manga busaw magi sa katulus ni Bilsibul na pangulu nilan. Manang kun maynan, kasiling na pigtanam nan ya kanan pagka-utawun. ");
INSERT INTO klg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aw kun kan Bilsibul katulus ya kanak pag-alilin sa manga busaw, na, usipen ta kamu: Ya kamayu uman manga sakup na mag-alilin sa manga busaw, ayin ka' lekat ya katulus na pig-atag kanilan? Silan saba ya magmatinaw na galu' ya piglong mayu! ");
INSERT INTO klg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Manang kun magi sa katulus na Tyumanem ya pag-alilin ku sa manga busaw, na, dun da mayu ka-ede-i na asini la ni kamayu ya Pigpadala na Tyumanem na un mag-imo' sa kasakupan nan.” ");
INSERT INTO klg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yanagaw miglong pa uman si Jisus sa pundinganan, “Kun ya utaw na mabagseg awun madég na kinis nan na migtunggu' sa palasyo nan, matingen ya kanan anenganeng kay dili' ma-agaw ya manga nyatagtun nan. ");
INSERT INTO klg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Manang kun sulungun ya kanan palasyo na utaw na to-o pa mabagseg kanan, degen saba ya tagtun, aw ma-agaw ya manga kinis na pigsaligan nan, aw tenga-tenga-en uman ya ka-unan na nya-agaw lekat adti kanan.” ");
INSERT INTO klg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aw migpadeleg si Jisus miglong, “Ya utaw na wala' pagpasakup kanak, yan baling ya gayed migbalabag sa kanak manga imo-unun. Aw kun awun dili' tumabang maggagad sa manga utaw adi kanak, yan baling ya mig-ampang kanilan adti kanak kasakupan. ");
INSERT INTO klg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Na, kun awun busaw na lumuwa' adti utaw, maglegeblegeb yan adti kaligbinan na wala' ya tubig aw maninaw sa un nan ka-eya-an manang wala' ya kita-en nan dun. Yanagaw maglong adti anenganeng nan, ‘Lumiku' aku baling adti muna pig-eya-an ku.’ ");
INSERT INTO klg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aw sa pagliku' nan, kita-en nan na malinis da ya kanan pig-indegan idtu muna, kasiling na balay na dayaw da kyapamunasan aw nyatigpes. ");
INSERT INTO klg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pagkatigkas yan mangay sakanan sa pitu ya eped nan na to-o pa baling malatay kanan. Aw sumeled silan adti utaw yan, aw dun da silan pag-eya'. Aw to-o pa malatay ya kabetangan na utaw yan kay sa idtu muna.” ");
INSERT INTO klg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sa kenne' pa ni Jisus miglong, awun ka͡ubayan dun ni katipun na miglong kanan sa mabagseg na tingeg, law nan, “Madyaw saba ya kana ka͡ubayan na migpaka͡utaw kanmu aw migpasusu kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Manang tyumubag si Jisus kanan, “To-o pa baling madyaw ya kana manga utaw na migpakanyeg sa tingeg na Tyumanem aw migtuman sa pigdengeg nilan.” ");
INSERT INTO klg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sa to-o pa migkadég ya manga utaw na migkatipun, migpadeleg si Jisus miglong, “Tay sa kalatay na manga utaw adun na manga allaw yeiy. Migsekat silan sa pangilala, manang ya pangilala na un ku atag kanilan, yan olo' ya kasiling na nya-imo' kan Jonas. ");
INSERT INTO klg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kay si Jonas asini muna nya-imo' sakanan pangilala adti manga utaw dun ni syudad na Ninibé, maynan uman ya Ise' na Utaw, ma-imo' uman sakanan pangilala adti manga utaw adun na manga allaw yeiy. ");
INSERT INTO klg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aw dun ni allaw na pag-ukum, ya réyna na migdumala asini muna sa banwa na Syiba, selselen nan uman ya kadég mayu. Kay nyanaw sakanan lekat adti mawat na banwa pada magpakanyeg sa katadeng na hari' na si Solomon. Manang paglongun ta kamu na asini la ni tampid mayu ya to-o pa matas kan Solomon, manang wala' mayu baling sakanan pakanyegi. ");
INSERT INTO klg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pagdateng na allaw na pag-ukum, ya manga utaw dun ni syudad na Ninibé selselen nilan ya kadég mayu. Kay sa pagpakanyeg nilan sa pag-ubat-ubat ni Jonas, migselsel silan sa kanilan manga sala'. Manang kamu, pangkay ini tampid mayu ya to-o pa matas kan Jonas, manang wala' mayu baling sakanan pangintu-uwi. ");
INSERT INTO klg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aw miglong pa uman si Jisus kanilan, “Wala' ya utaw na magsulu' sa salengan pada sangkuban nan. Manang betang nan baling adti bantawanan pada ya kadég na sumeled adti balay ka-ilawan silan na kalalamdag. ");
INSERT INTO klg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya kanmu mata, yan ya kalalamdag na lawas mu. Yanagaw, kun madyaw ya pag-inunu mu, awun kalalamdag na maka-ilaw sa kanmu anenganeng. Manang kun masakiten ya kanmu mata, na, to-o dakula' ya kangitngit na awun ni kanmu. ");
INSERT INTO klg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yanagaw magpakatadeng kaw pagaw iman mu aw kya-ilawan da ya anenganeng mu manang kenne' kadi' na kangitngit. ");
INSERT INTO klg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kun ya anenganeng mu nyatmu' na kalalamdag aw wala' ya kangitngit dun, ka-ilawan saba ya kadakula' na pagka-utawun mu, kasiling na kya-ilawan kaw na saleng.” ");
INSERT INTO klg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatigkas ni Jisus maglong, awun sambuk na Parisiyo na migpilit kanan na kuman adti balay nan. Yanagaw nyagad si Jisus kanan aw kyuman adti tampid nan. ");
INSERT INTO klg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sa pagkan da nilan, nyabelengbeleng ya Parisiyo sa pagkita' nan kan Jisus kyuman na wala' una pag-unaw. ");
INSERT INTO klg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yanagaw miglong si Jisus kanan, “Kamu na manga Parisiyo, pag-ugasan mayu ya luwa' na lawas na tabu' aw ya salad na palatu manang kenne' pa baling na kalipa' na adti seled! Migtallalingu kamu, kay yan ya gayed adti anenganeng mayu ya pagkamang sa pangkay unu na pagkaliman mayu aw nyatmu' ya anenganeng mayu na malatay. ");
INSERT INTO klg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ayin pakabetang ya anenganeng mayu? Enda', Tyumanem saba ya mig-imo' sa lawas mayu, aw yan uman ya mig-imo' sa adti seled na kamayu anenganeng? ");
INSERT INTO klg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yanagaw una͡a mayu linisi ya kamayu anenganeng pada kallatan mayu ya manga utaw na wala' ya pagkamangan. Aw kun yeiy ya imo-un mayu, na, dayaw kamu magkalinis. ");
INSERT INTO klg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kamu na manga Parisiyo, malatay ya un mayu datengan! Dayaw mayu pigdalug ya sugu' dun ni Uldin na atag adti Tyumanem ya kasampulu', pangkay ya mangkayantek na anagay na pigtanem mayu alag mayu pigkamangan. Manang pigpalipaslipasan mayu baling ya pag-usay na matulid aw ya pagginawa sa Tyumanem. Ka-ilangan saba mayu yeiy alag imo-un dala ya pag-atag sa kasampulu' adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kamu na manga Parisiyo, malatay ya un mayu datengan! Dun ni sinagoga kaliman mayu na mingkud adti ingkudanan na utaw na dengganen, aw pangkay adti manga palingki kaliman mayu uman basa͡an na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Malatay ya un mayu datengan, kay kasiling kamu na manga lebeng na wala' pangilalayi. Pigpanggina-an na manga utaw na wala' nilan ka-ede-i na awun kadi' lebeng. Aw maynan uman, iman na manga utaw aw matulid kamu manang wala' nilan ka-ede-i na malatay ya anenganeng mayu.” ");
INSERT INTO klg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na, awun sambuk na magpalna-uway sa Uldin na manga Judiyu na miglong kan Jisus, “Kay Magpalna-uway, dun ni manga piglong mu, pigsupla mu kami!” ");
INSERT INTO klg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aw tyumubag si Jisus, “Kamu uman na manga magpalna-uway sa Uldin, malatay ya un mayu datengan! Kay gayed mayu pigdugangan ya manga sugu' na Tyumanem, aw piggelgel mayu ya manga utaw na dalugun nilan. Aw ya syampetan yan, to-o silan kyabegatan. Manang pigpabaya-an baling mayu silan aw pangkay tagbi' wala' kamu tabang pada matuman nilan ya pigsugu' mayu. ");
INSERT INTO klg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Malatay ya un mayu datengan! Kay migpa-indeg kamu sa manenggeya na batu adti tas na manga lebeng na manga propita na pigpatay na tyugbulan mayu asini muna. ");
INSERT INTO klg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aw magi dun ni pigpan-imo' mayu, kasiling na tyumande' kamu sa pagpatay na kamayu tyugbulan sa manga propita, aw kamu ya pigpa-imo' sa manga lebeng nilan. ");
INSERT INTO klg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yanagaw yeiy ya du-an na dadan miglong ya Tyumanem magi sa katadeng nan, law nan, ‘Padala͡an ku silan na manga propita aw manga apostolés. Manang ya manga eped pamatayen nilan aw ya manga eped pamulayaman.’ ");
INSERT INTO klg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yanagaw kamu na manga utaw adun na allaw yeiy, pa-emel-melen uman na Tyumanem asuntu sa pagpatay na kamayu tyugbulan sa manga propita nan, lekat pa asini muna na pag-imo' nan sa kadakula' na banwa taman adun, ");
INSERT INTO klg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","lekat pa kan Abel aw menda' adti pagpatay kan Zakariyas na ise' ni Barakiyas. Kay ya manga tyugbulan mayu, silan ya migpatay kan Zakariyas adti Témplo, dun ni tenga' na Balay na Tyumanem aw dugsu-anan. Paglongun ta kamu: Kamu na manga utaw adun na allaw ini, kamu saba ya pasala-en sa kadég na pig-imo' nilan idtu muna. ");
INSERT INTO klg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Malatay ya un mayu datengan, kamu na manga magpalna-uway sa Uldin! Kay gayed mayu pigbalabagan ya agiyanan adti tengteng na pagka-ede' sa Tyumanem. Pangkay kamu dili' kamu malim sumeled. Aw pigbalabagan mayu uman ya manga eped na malim galu sumeled.” ");
INSERT INTO klg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sa pag-indeg da ni Jisus adti balay na Parisiyo, dun da pagpalekat ya malatay na ginawa kanan na manga magpalna-uway sa Uldin na manga Judiyu aw manga Parisiyo. Aw gayed silan gyumelgel kanan magi sa madég na mangkalug na usip, ");
INSERT INTO klg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kay yan ya tud nilan na kalitagan si Jisus magi dun ni paglong nan. ");
INSERT INTO klg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dun ni manga allaw yan, matag pilammalalan ya manga utaw na migpangkatipun na un magpakanyeg kan Jisus, aw gayed da silan mig-insek. Aw piglongan nan una ya kanan manga umagakan, law nan, “Magpakatadeng kamu sa patulinay na manga Parisiyo na yan ya kanilan pagtallalingu pagaw katapunan kamu nilan. ");
INSERT INTO klg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kay wala' ya nyatagu' adun na dili' kagaya kabukasan, aw wala' ya pigtagu na utaw adti anenganeng nan na dili' ka-ede-an. ");
INSERT INTO klg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yanagaw, pangkay unu ya piglong mayu dun ni mangitngit, dengegen da kagaya kun magkalalamdag da. Aw pangkay unu ya pigtumantuman mayu adti seled na tambi' na pigtakepan, ubat-ubat kagaya adti kadég na manga utaw.” ");
INSERT INTO klg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kamu na kanak manga ubaybay, paglongun ta kamu: Dili' kamu magkallek sa manga utaw na makamatay sa lawas mayu, kay olo' lawas ya mabatug nilan patayen, aw tigkas yan wala' da ya mabatug nilan na malatay dun ni kamayu. ");
INSERT INTO klg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Manang ubat ku kamayu kun singalan ya umba' mayu kallekan: Kalleki mayu ya Tyumanem kay mabatug nan saba patayen ya lawas na utaw aw awun uman katulus nan mag-agbel sa utaw adti atulun na dili' pagkapatayan. Yan saba ya paglongun ku kamayu na Tyumanem olo' ya umba' mayu kallekan. ");
INSERT INTO klg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Anenganenga mayu ya mangkayantek na langgam na maya. Kun bayadan na utaw ya lima ya maya, tagbi' to-o ya alaga' nilan, manang wala' ya pangkay sambuk kanilan na pigkalingawan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aw to-o pa kamu dun, pangkay ya manga lugay mayu kya-ede-an saba na Tyumanem kun pila ya kadég. Yanagaw dili' kamu magkallek kay to-o pa dakula' ya alaga' mayu kay sa madég na maya.” ");
INSERT INTO klg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aw paglongun ta kamu: Pangkay singalan ya maglong adti asdangan na manga utaw na umagakan ku sakanan, aku na Ise' na utaw maglong uman adti asdangan na manga anghil na Tyumanem na umagakan ku ya utaw yan. ");
INSERT INTO klg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Manang pangkay singalan ya magbalyaw kanak adti asdangan na manga utaw, balyaw ku uman sakanan adti asdangan na manga anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aw pangkay singalan ya maglong sa malatay adti Ise' na Utaw, mabatug lanasen na Tyumanem ya sala' nan. Manang ya utaw na maglong sa malatay adti Ispiritu Santo, dili' saba lanasen ya sala' na utaw yan. ");
INSERT INTO klg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Asuntu sa pagpangintu-u mayu kanak, awun manga utaw na maglimanda kamayu aw pa-agad kamu nilan adti mag-usayay dun ni sinagoga, aw adti asdangan na manga gubirnador aw manga migdumala. Manang dili' magkakamang ya ginawa mayu kun unu ya un mayu tubag kanilan, ");
INSERT INTO klg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kay dun ni udas yan, ya Ispiritu Santo, yan ya magpalna-u kamayu kun unu ya madyaw mayu paglongun.” ");
INSERT INTO klg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, dun ni madég na manga utaw awun sambuk na miglong kan Jisus, “Kay Magpalna-uway, paglonga kanak ya magulang ku na eseg na bagi-an aku nan sa ayawanan na ama nami.” ");
INSERT INTO klg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Manang tyumubag si Jisus kanan, “Kay Lew, singalan ka' ya nyatag kanake' sa katundanan sa pag-usay kamayu aw sa pagtenga' sa ayawanan yan?” ");
INSERT INTO klg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tigkas yan, miglong pa si Jisus adti madég na utaw, “Magpakatanaw kamu pagaw wala' ya katantanan mayu maninaw sa kuwalta aw ka-unan. Kay ya kadyaw na pag-eya' na utaw dili' saba lumekat adti kadég na nyatagtun nan.” ");
INSERT INTO klg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aw miglong si Jisus adti kanilan sa pundinganan: “Awun sambuk na makabatug na to-o dakula' ya aniyenen adti pawa' nan. ");
INSERT INTO klg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yanagaw miglong sakanan adti anenganeng nan, ‘Unu ya un ku imo-un adun? Wala' da ya pul na kabetangan sa aniyenen ku! ");
INSERT INTO klg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Madyaw pa baling na agba-en ku ya kanak manga dadan na pul aw mag-imo' aku sa to-o pa dakula'. Aw dun ku luduka ya kadakula' na kanak ani aw ya kadég na manga pametang ku. ");
INSERT INTO klg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aw tigkas yan, maglong aku, “To-o la madég ya pigtagilan ku sa dumadateng na manga umay. Maglagdeng aku, aw to-o kuman aw minem, aw imo-un ku ya pangkay unu na kaliman ku imo-un!” ’ ");
INSERT INTO klg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Manang miglong ya Tyumanem kanan, ‘Ayin pakabetang ya anenganeng mu? Adun na gabi kamangen ku ya ginawa mu. Yanagaw singalan pa ya makatagtun sa kuwalta aw ka-unan na pigluduk mu?’ ” ");
INSERT INTO klg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aw miglong pa si Jisus, “Maynan saba ya ma-imo' sa utaw na migluduk sa manga ka-unan aw kuwalta pada ka-untungan olo' ya kanan pagka-utawun manang pigpalipaslipasan nan baling ya pagkaliman na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Yanagaw paglongun ta kamu: Dili' magkakamang ya ginawa mayu sa kadég na kamayu kapelekan asini tas na lupa', kun unu ya un mayu makan aw unu ya un mayu sutun. ");
INSERT INTO klg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kay ya pag-eya' na utaw asini tas na lupa', beke' olo' na makan aw beke' olo' na kadégkadég. ");
INSERT INTO klg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Inunuwa mayu ya manga langgam. Wala' silan pagtanem, aw wala' silan uman pag-ani. Wala' ya pul na un nilan pagludukan sa kanilan makan, manang pigpakan silan saba na Tyumanem. Aw asuntu na to-o pa dakula' ya alaga' mayu kay kanilan, yanagaw atagan kamu nan sa kadég na kamayu kapelekan! ");
INSERT INTO klg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Singalan ka' kamayu ya makasugpat sa ginawa mayu asini tas na lupa' magi sa pagkaypeng mayu? Wala' saba. ");
INSERT INTO klg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na, kun dili' mayu mabatug ya maynan, ananga' magkakamang ya ginawa mayu sa manga kapelekan? ");
INSERT INTO klg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Inunuwa mayu ya pagtulin na manga sagbet na magpamulak adti magalet. Wala' silan pagtalabahu aw wala' uman silan pagté'. Manang paglongun ta kamu: Si Solomon, to-o dengganen ya pagkahari' nan asini muna aw syumut sakanan sa kadégkadég na to-o manenggeya, manang to-o pa dun manenggeya ya manga bulak yeiy. ");
INSERT INTO klg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ya manga sagbet adti magalet mamulak adun aw pagkakunallaw malanes aw tigkas yan sangaben. Aw pangkay tagbi' ya alaga' nilan, manang pigpakanenggeya to-o silan na Tyumanem. Aw to-o pa kamu dun kay atagan kamu nan saba sa un mayu sutun. Tay, sa katagbi' na pagpangintu-u mayu! ");
INSERT INTO klg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yanagaw dili' gayed magkakamang ya ginawa mayu kun unu ya un mayu kanen aw inemen. ");
INSERT INTO klg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ya kadég yeiy, gayed pigtibagsegan na matagtun na manga utaw na wala' pangintu-u sa Tyumanem. Manang kamu, wala' ya du-an na makamang ya ginawa mayu, kay kya-ede-an da saba na Ama mayu na awun ni tas na langit kun unu ya kamayu kapelekan. ");
INSERT INTO klg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tibulluka mayu baling ya kamayu anenganeng adti kadég na awun ni Kasakupan na Pighari-an na Tyumanem. Kun maynan ya imo-un mayu, sambaten nan ya kadég na kamayu kapelekan. ");
INSERT INTO klg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ya kadég mayu na kanaken manga umagakan, pangkay tabay kamu manang dili' kamu magkallek, kay yan ya pagkaliman na Ama mayu na awun ni tas na langit na atag kamayu ya kadég na awun ni kanan kasakupan. ");
INSERT INTO klg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yanagaw galina mayu ya kamayu nyatagtun, tigkas yan, atagi mayu ya manga utaw na wala' ya pagkamangan. Kun imo-un mayu yeiy, dun da kamu pagluduk sa palangad ka-unan adti tas na langit, kasiling na mig-imo' kamu sa pu-ut na dili' mabuslut. Ya pigluduk mayu adti tas na langit dili' saba magkalat aw wala' ya makatakaw, aw wala' ya mannanap na makakan. ");
INSERT INTO klg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kay kun ayin ya kanmu ka-unan, adtu uman ya kanmu anenganeng. ");
INSERT INTO klg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Magpakatadeng kamu aw gayed mayu pasiga͡en ya kamayu manga salengan pada dili' kamu kabigla-an. ");
INSERT INTO klg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pagsiling kamu sa manga sugu-anen na gayed migtagad sa pag-uli' na amu nilan lekat adti kasal, pada sa pagdateng nan aw sa pagtawag nan, maksay nilan ka-uwangan ya tatakep. ");
INSERT INTO klg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Madyaw ya kana manga sugu-anen na nyakatagad sa pagliku' na amu nilan kay wala' silan pakatulug aw gayed silan mig-inap. Paglongun ta kamu na pa-ingkudun saba na amu ya kanan manga sugu-anen aw dayaw nan silan sanggila-en. ");
INSERT INTO klg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","To-o madyaw ya kanilan kun datengan silan na kanilan amu na mig-inap pangkay kun magtenga' da ya gabi aw kun paka͡allawunun da. ");
INSERT INTO klg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Anenganenga mayu yeiy: Kun kya-ede-an pa na tagtun sa balay ya udas na pagseled na matakaw, pakatanawan nan saba ya kanan balay pada dili' makaseled ya matakaw. ");
INSERT INTO klg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yanagaw pagtagilan kamu kay pangkay unu udasa lumiku' ya Ise' na Utaw na dili' mayu pag-imanmanen.” ");
INSERT INTO klg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aw nyusip si Pédro, “Kay Magpalna-uway, singalan ya pig-ubat-ubatan mu sa pundinganan yeiy, kami olo' aw ya kadég na manga utaw?” ");
INSERT INTO klg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tyumubag si Jisus kanan, “Ya sugu-anen na kasaligan aw to-o matadeng, yan ya taliguwan na amu nan sa manga eped nan na sugu-anen dun ni balay. Aw yan ya matag kanilan sa kakan na umba' sa allaw yan. ");
INSERT INTO klg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Madyaw ya kana sugu-anen yan kun sa pag-uli' na amu nan, kita-en na pigpakadyaw nan ya talabahu na pigtaligu kanan. ");
INSERT INTO klg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Matinaw ya un ku paglongun kamayu: Ya sugu-anen yeiy un saba taliguwan na amu nan sa kadakula' na kanan nyatagtun. ");
INSERT INTO klg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Manang ya sugu-anen na dili' kasaligan, sa pagpanaw da na amu nan, mag-anenganeng sakanan, ‘Madugay pa muli' ya amu ku.’ Yanagaw palekaten nan ya pagpanlabet sa manga eped nan na sugu-anen na eseg aw manga bubay, aw gayed sakanan kuman aw minem menda' na malangulangu sakanan. ");
INSERT INTO klg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Manang dumateng ya kanan amu dun ni udas na wala' nan pag-imanmana, aw to-o saba sakanan pa-emel-emelen na amu nan. Aw pasambuk sakanan adti banwa na pagludukan sa manga utaw na dili' kasaligan. ");
INSERT INTO klg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na, ya sugu-anen yan, pangkay kya-ede-an nan ya pagkaliman na tagtun kanan manang wala' nan tumana aw wala' pagtagilan sa pagliku' nan, yanagaw to-o saba sakanan labeten. ");
INSERT INTO klg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Manang ya sugu-anen na wala' paka-ede' sa pagkaliman na amu nan aw wala' uman paka-ede' sa sala' na nya-imo' nan, pa-emel-emelen uman manang dili' to-o labeten. Na, ya utaw na pig-atagan sa madég, madég uman ya imanen adti kanan. Aw ya utaw na pigtaliguwan sa madég na imo-unun, madég uman ya imanen adti kanan.” ");
INSERT INTO klg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Aw miglong pa uman si Jisus kanilan, “Nyadi aku asini tas na lupa' na un dumala sa atulun, aw kaliman ku na maksay da yeiy lumaga. ");
INSERT INTO klg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Manang sa dili' pa yeiy ma-imo', madég pa ya manga pagti-is na un ku ka-agiyan. Aw dili' matingen ya kanak anenganeng menda' na matuman ya kadég yeiy. ");
INSERT INTO klg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dili' kamu mag-anenganeng na nyadi aku pada dumala sa kalinaw asini tas na lupa'. Ya pagkadi ku, yan baling ya du-an na matenga-tenga' ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lekat adun, kun awun lima ya mig-eya' adti sambuk na balay, dili' da magkasambuk ya anenganeng nilan. Ya tulu, mag-italis sa duwa, aw maynan uman ya duwa adti tulu. ");
INSERT INTO klg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ya ama mag-italis silan ya kanan ise' na eseg asuntu kanak. Aw ya ina mag-italis silan uman ya kanan ise' na ka͡ubayan. Aw ya ugangan nan na bubay mag-italis silan ya makeye' nan na ka͡ubayan.” ");
INSERT INTO klg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aw miglong pa uman si Jisus adti madég na manga utaw, “Sa pagkita' mayu sa lugaytem adti sallepan, maglong kamu, ‘Mulan adun,’ aw mulan saba. ");
INSERT INTO klg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aw kun tumambel ya samet lekat adti balabagan, maglong kamu uman, ‘Mapasu' adun,’ aw mapasu' saba. ");
INSERT INTO klg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Migtallalingu kamu! Matadeng kamu mag-ubad sa timpo manang ananga' wala' mayu kabatug ya pag-ubad sa kakawasan na manga nyangka-imo' adun na manga allaw yeiy? ");
INSERT INTO klg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aw ananga' malug adti kamayu ya pagbaya' kun unu ya madyaw imo-un? ");
INSERT INTO klg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kun awun maglimanda kanmu, tibagsegi na maksay kamu magkakadyaway talana mayu dun ni dalan pasinan adti usayanan, pagaw padakep kaw baling na mag-usayay aw dala͡en kaw nan adti mag-ukumay, aw ya mag-ukumay yan ya magbaya' na pakalabusu kaw nan. ");
INSERT INTO klg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Paglongun ta kamu: Dili' kaw paluwa-en lekat adti kalabusuwanan menda' na dili' mu kabayadan ya kadakula' na beles mu.” ");
INSERT INTO klg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, talana ni Jisus migpalna-u sa madég na utaw, awun manga dyumateng dun aw pig-ubatan nilan si Jisus sa nya-imo' sa manga taga Galilya na pigpapatay ni Pilato talana nilan migdugsu' sa manga ayep adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aw nyusip si Jisus kanilan, “Unu, mig-anenganeng kamu na yan ya du-an na malatay ya kyagamakan nilan kay to-o pa silan makasasala' kay sa manga eped na taga Galilya? ");
INSERT INTO klg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Beke' saba! Manang paglongun ta kamu: Kun dili' mayu selselan ya kamayu manga sala', mabus kamu uman mangkamatay. ");
INSERT INTO klg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na, unu ya anenganeng mayu sa sampulu' tag walu ya utaw na nyangkamatay asuntu na kyagettanan silan na torré na Siloam? Pagaw mig-anenganeng kamu uman na to-o pa dakula' ya kanilan manga sala' kay sa kadég na manga eped na nyeya' dun ni seled na Jérusalim? ");
INSERT INTO klg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dili' saba! Manang paglongun ta kamu: Maynan uman ya datengan mayu kun dili' kamu magselsel sa kamayu manga sala'.” ");
INSERT INTO klg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tigkas yan, miglong si Jisus kanilan sa pundinganan, “Awun sambuk na utaw na nyakatanem da sa kawuy na igira dun ni kanan parasan. Pagdateng da na bulan na mamunga la, pigkadtuwan nan ya kawuy na igira na un nan tanawun. Manang wala' ya kyinita' nan na bunga. ");
INSERT INTO klg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yanagaw piglongan nan ya utaw na pigtaliguwan nan migtalabahu dun ni kanan parasan, ‘Seled da na tulungka͡umay ya pagliku-liku' ku asini migtanaw kun nyamunga la igira ini, manang wala' ya kyinita' ku na bunga. Madyaw pa baling utudun da yeiy kay migsapadsapad olo' sa taba' na lupa'.’ ");
INSERT INTO klg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Manang tyumubag ya utaw na pigtaluguwan nan, ‘Kay Sir, pabaya-i pa adun na umay ini. Un pa ku palibedan na kutkut ya punu-an nan aw dayaw abunuwi. ");
INSERT INTO klg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aw kun munga salut na umay, madyaw yan, manang kun dili', na, pa-utudan da.’ ” ");
INSERT INTO klg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sambuk na Allaw na Paglagdeng, migpalna-u si Jisus adti sinagoga. ");
INSERT INTO klg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aw awun ka͡ubayan dun na nyasakung asuntu na pigpamulayaman na busaw seled da sampulu' tag walu ya umay aw dili' nan mabatug tuliden ya lawas nan. ");
INSERT INTO klg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sa pagkita' ni Jisus kanan, pigtawag nan ya ka͡ubayan aw piglongan nan, “Kaguli-an da kaw.” ");
INSERT INTO klg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aw pigpandungan ni Jisus na kanan palad ya ulu na ka͡ubayan, aw dayaw nyatulid ya lawas nan aw to-o nan pigdeyen ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Manang nyadaman ya pagsaligan sa sinagoga, asuntu na migguli' si Jisus sa utaw dun ni Allaw na Paglagdeng. Yanagaw miglong ya pagsaligan adti manga utaw, “Seled na sangka simana, awun enemengallaw na pagtalabahu tadun. Aw yan galu ya manga allaw na pagkadi mayu kun malim kamu kaguli-an, manang dili' galu Allaw na Paglagdeng!” ");
INSERT INTO klg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Manang tyumubag si Jisus kanan, “Migtallalingu kamu! Enda', ya kamayu baka aw asnu, pigtumbay mayu saba na alinen aw pigguyud adti pa-inemanan pangkay Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kun maynan ya pig-imo' mayu sa kamayu manga ayep, na, ananga' wala' mayu tumbayan na paluwa-en ya ka͡ubayan ini sa pagti-is nan pangkay Allaw na Paglagdeng? Buwadbuwad saba sakanan ni Abraham, manang kasiling na pig-eketan sakanan ni Satanas seled na sampulu' tag walu ya umay.” ");
INSERT INTO klg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sa paglong ni Jisus seiy, nyamulamula ya manga mig-ampang kanan kay kyatinawan silan. Aw migleya ya kadég na manga utaw sa manga pigpan-imo' nan na to-o madyaw. ");
INSERT INTO klg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yanagaw miglong si Jisus, “Unu ya un tadun kapa-unawa͡an sa Kasakupan na Pighari-an na Tyumanem? Aw unu ya madyaw na pundinganan seiy? ");
INSERT INTO klg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ya kasakupan na Tyumanem kasiling na sambuk na bini' na mustardo na pigtanem na utaw dun ni tanemanan nan. Tyumulin aw migkatas kasiling na kawuy, aw pigpugadan na manga langgam ya manga sanga nan.” ");
INSERT INTO klg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aw miglong pa si Jisus, “Unu pa uman ya un tadun kapa-unawa͡an sa Kasakupan na Pighari-an na Tyumanem? ");
INSERT INTO klg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ya kasakupan nan kasiling na tagbi' na patulinay na pigdali' na ka͡ubayan adti dakula' na harina, aw pigtagadan nan na tumulin ya kadakula' na harina na pigmasa nan.” ");
INSERT INTO klg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aw sa migpasinan si Jisus adti Jérusalim, migpalna-u sakanan adti manga lunsud aw manga baranggay na kya-agiyan nan. ");
INSERT INTO klg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aw nyusip kan Jisus ya sambuk na utaw, “Kay Magpalna-uway, unu, tabay ka' olo' ya manga utaw na paluwa-en na Tyumanem?” Aw miglong si Jisus kanilan, ");
INSERT INTO klg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tibagsegi mayu ya pagseled magi sa suwangan na mapeyet na yan ya pasinan adti ginawa na wala' ya katigkasan talana awun pa selat. Madég galu ya malim sumeled manang dili' da makaseled. ");
INSERT INTO klg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kay paglongun ta kamu: Kun takepen da na tagtun ya tatakep, madég kamayu ya mindeg adti luwa' aw magtatawag na maglong, ‘Kay Sir! Uwangi beg kami!’ Manang tumubag sakanan kamayu, ‘Wala' ta kamu kilala͡a.’ ");
INSERT INTO klg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pagkatigkas yan, magpalekat kamu maglong, ‘Kay Sir, kami saba ya kyuman aw nyinem dun ni tampid mu. Aw migpalna-u kaw adti banwa nami.’ ");
INSERT INTO klg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Manang tumubag sakanan, ‘Wala' ta kamu saba kilala͡a. Aw wala' ku uman ka-ede-i kun ayin kamu lekat. Pagpakawat kamu kanak, kadég mayu na gayed mig-imo' sa malatay!’ ");
INSERT INTO klg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aw kita-en mayu si Abraham aw si Isaak aw si Jakub, aw ya kadég na manga propita dun ni seled na Kasakupan na Pighari-an na Tyumanem. Aw to-o kamu magpansisugaw, aw magsipanguliteb ya untu mayu asuntu na wala' kamu paseleda. ");
INSERT INTO klg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aw awun madég na manga Héntil na lekat adti silatan aw adti sallepan aw adti balabagan, aw mingkud silan adti dakula' na katipun dun ni Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pakanyegi mayu: Awun manga utaw na nyakamoli adun manang maka-una silan kagaya. Aw awun uman manga nyaka-una adun manang makamoli silan kagaya.” ");
INSERT INTO klg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na, dun ni udas yan, awun manga Parisiyo na dyumulud kan Jisus aw miglong kanan, “Kaksay kaw palaguy kay kaliman ni Hérodés Antipas na patayen kaw.” ");
INSERT INTO klg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Manang tyumubag si Jisus kanilan, “Kadtuwi mayu ya utaw yan na gayed maggaway aw magpakalat sa manga utaw. Paglonga mayu sakanan na padelegen ku ya pag-alilin sa manga busaw aw ya pagpangguli' sa manga kyedelan adun na allaw yeiy taman kunallaw. Aw sa katlu na allaw, matigkas ku ya kanak imo-unun. ");
INSERT INTO klg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Manang ka-ilangan ku padelegen ya kanak panaw adun aw kunallaw, aw sangkallaw. Kay dili' umba' patayen ya propita na Tyumanem adti eped na banwa, manang dun olo' ni Jérusalim.” ");
INSERT INTO klg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aw migkalat ya ginawa ni Jisus asuntu sa manga nya-imo' dun ni Jérusalim. Yanagaw miglong sakanan, “Kamu na taga Jérusalim, pigpatay mayu ya manga propita na Tyumanem, aw pigpamintu mayu na batu ya manga pigsugu' nan adti kamayu. Malikit da aku galu magtameng kamayu kasiling na minsa' na migtatawag sa manga unsuy nan na un nan tipunun adti dalem na manga panid nan, manang wala' kamu kalim! ");
INSERT INTO klg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, un da kamu na Tyumanem pabaya-an. Aw paglongun ta kamu: Dili' da aku mayu kita-en menda' na dumateng ya allaw na maglong kamu, ‘Ini la ya Pigpadala na Tyumanem dun ni kanan ngalan, aw umba' sakanan deyen!’ ” ");
INSERT INTO klg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na, sambuk na Allaw na Paglagdeng, pigpilit si Jisus na kuman adti balay na sambuk na magdumala͡ay sa manga Parisiyo. Aw sa talana nilan kyuman, to-o nilan pyakatanawan si Jisus kun unu ya un nan imo-un. ");
INSERT INTO klg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aw dun ni kanilan ya sambuk na utaw na nyangkabaga' ya kadakula' na lawas nan. ");
INSERT INTO klg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aw nyusip si Jisus sa manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu, “Unu, pigtumbay na Uldin tadun ya pagguli' sa utaw dun ni Allaw na Paglagdeng?” ");
INSERT INTO klg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Manang wala' silan tubag. Yanagaw pig-awidan ni Jisus ya utaw aw dayaw nan guli-a, aw pigpapanaw nan. ");
INSERT INTO klg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aw miglong si Jisus kanilan, “Kun awun ise' mayu aw pangkay baka na nyolug adti malalem na gawang na pagludukan sa tubig, unu ya imo-un mayu? Maksay mayu saba kamangen pangkay Allaw na Paglagdeng.” ");
INSERT INTO klg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Manang wala' silan pakatubag sa usip nan. ");
INSERT INTO klg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na, kyinita' ni Jisus ya manga pyampamilit dun ni balay na Parisiyo na nyamalli' silan sa ingkudanan na dengganen na un nilan ingkudan. Yanagaw pigpalna-uwan nan silan, law nan, ");
INSERT INTO klg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kun piliten kaw dun ni pista na kasal, dili' kaw maksay mag-ingkud adti pagpa-ingkudan sa manga dengganen pagaw awun utaw na dumateng na pigpilit uman na matas pa ya dengeg nan kanmu. ");
INSERT INTO klg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aw ya utaw na nyamilit kamayu maglong baling kanmu, ‘Dili' pa kaw dun. Kay ya ingkudanan yeiy pigtagilan da sa utaw ini.’ Yanagaw mamulamula kaw baling aw adtu la kaw sa kanmu ingkud ni ligad. ");
INSERT INTO klg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Manang kun piliten kaw, pamalli-a ya pag-ingkudan na manga utaw na dili' dengganen. Yanagaw kun dumateng ya nyamilit aw maglong kanmu, ‘Na, kay Lew, adi kaw ingkud ni pagpa-ingkudan sa manga dengganen,’ magi dun saya' kaw adti asdangan na kadég na pigpamilit. ");
INSERT INTO klg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay pangkay singalan ya magpatastas, un saba sakanan padalemen. Aw ya utaw na magpadalem, un sakanan patasen. ");
INSERT INTO klg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pagkatigkas yan, miglong si Jisus adti utaw na nyamilit kanan, “Kun mag-imo' kaw sa dakula' na kakan, dili' mu pagpamiliten ya manga ubaybay mu aw manga kaylug mu aw manga kadégan mu aw manga sumbalay mu na mayaman. Kay kun piliten mu silan, kasoli-an kaw nilan uman kagaya. ");
INSERT INTO klg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Manang kun mag-imo' kaw sa dakula' na kakan, yan baling ya madyaw mu pamiliten ya manga utaw na wala' ya pagkamangan, aw ya manga kimay, aw ya manga kapig, aw manga buta. ");
INSERT INTO klg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aw madyaw ya kanmu, kay dili' silan makasoli' kanmu. Ya Tyumanem, yan saba ya magsoli' kanmu dun ni allaw na panmatawun nan ya manga utaw na dyumalug sa pagkaliman nan.” ");
INSERT INTO klg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aw ya sambuk na utaw na kyuman dun ni sayid ni Jisus nyakadengeg sa piglong nan, aw miglong adti kanan, “Madyaw ya kana utaw na kuman dun ni Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pagkatigkas yan, miglong si Jisus adti kanan sa pundinganan: “Awun utaw na mig-imo' sa dakula' na pista, aw madég to-o ya pyamilit nan. ");
INSERT INTO klg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aw pagdateng da na allaw na pista, pigsugu' nan ya kanan sugu-anen na tawagen da ya manga pigpamilit nan, ‘Kadi la kamu, kay nyatagilan da ya kadég!’ ");
INSERT INTO klg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Manang ya tagsambuksambuk kanilan miglong na dili' silan makakadtu. Ya sambuk miglong, ‘Bagu aku nyakabayad sa lupa' aw ka-ilangan na tanawun ku. Yanagaw pasinsiyayi aku.’ ");
INSERT INTO klg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aw miglong uman ya sambuk, ‘Bagu aku nyakabayad sa sampulu' ya baka aw tanawun ku silan kun madyaw silan magdaru. Yanagaw pasinsiyayi aku.’ ");
INSERT INTO klg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aw miglong pa uman ya sambuk, ‘Bagu pa aku nyangugnan aw yanagaw dili' aku makakadtu.’ ");
INSERT INTO klg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Yanagaw nyuli' ya sugu-anen adti kanan amu aw pigdandan nan ya kadég. Pagpakadengeg na amu nan, to-o sakanan nyadaman, aw miglong adti sugu-anen nan, ‘Kaksay kaw kadtu ni manga dalan aw manga agiyanan na syudad. Aw pa-agadan adi ya manga tagitu' na utaw aw ya manga kimay, aw ya manga buta, aw ya manga kapig.’ ");
INSERT INTO klg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Wala' kadugay, nyuli' ya sugu-anen aw miglong, ‘Kay Sir, nyatuman da ya kadég na pigsugu' mu kanak, manang wala' pa katmu' ya katipunanan.’ ");
INSERT INTO klg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yanagaw miglong pa uman ya amu adti kanan, ‘Kadtuwi ya manga balay na adti luwa' na syudad aw manga dalan na pasinan adti buntud, aw paglonga ya taman na kita-en mu na madi silan pada matmu' nilan ya kanak balay. ");
INSERT INTO klg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Paglongun ta kamu: Wala' ya pangkay sambuk na utaw na muna ku pigpamilit na makakan sa pigtagilan ku.’ ” ");
INSERT INTO klg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Talana ni Jisus migpadeleg nyanaw pasinan adti Jérusalim, madég to-o ya utaw na nyagad kanan. Aw nyatubang sakanan aw miglong kanilan, ");
INSERT INTO klg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kun awun sambuk kamayu na malim dumalug kanak, manang to-o pa nan pigginawa͡an ya kanan ama aw ina, aw ka͡ubayan aw manga mangayse' nan, aw kanan manga inulug aw bubay, aw pangkay ya kanan pagka-utawun, aw kun tagbi' ya pagginawa nan kanak, dili' sakanan umba' ma-imo' kanak umagakan. ");
INSERT INTO klg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pangkay singalan ya dili' magpisan sa kanan krus aw dumalug kanak, dili' sakanan umba' ma-imo' kanak umagakan. ");
INSERT INTO klg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kun awun adti kamayu na malim magtulluk sa dakula' na balay, sa dili' pa nan tulluk ya balay, una nan anenganengen kun sangunu ya magastu aw kun maka-umba' ya kuwalta nan sa pagpa-imo' menda' na matigkas. ");
INSERT INTO klg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kay kun dili' nan yeiy una anenganengen, pagaw mapatal olo' aw mabus ya kuwalta nan aw dili' matigkas. Yanagaw ikelan baling sakanan na manga utaw na kumita', ");
INSERT INTO klg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aw maglong silan, ‘Ya utaw yeiy kalama-lama' da migpa-imo' sa balay manang dili' nan mabatug tigkasen.’ ");
INSERT INTO klg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Aw kasiling uman sakanan na hari' na awun sampulu' ka malalan ya sundalu na un tumanam adti sambuk na hari'. Patawag nan una ya kanan manga hénéral aw magsekat sa palna-u kun mabatug degen na sampulu' ka malalan na kanan sundalu ya hari na awun kaluwa͡an ka malalan ya sundalu. ");
INSERT INTO klg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kun adti kanan anenganeng dili' nan mabatug degen ya manga po-on nan, madyaw pa baling na sumugu' sakanan sa manga pigsaligan nan adti kanan po-on pada magpakang silan na dili' da magtanam. ");
INSERT INTO klg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Maynan uman, kun singalan kamayu ya dumalug kanak, una͡en nan anenganengen kun mabatug nan ayawan ya kadakula' na pigginawa͡an nan asini tas na lupa'. Kay kun dili' nan mabatug, dili' sakanan umba' ma-imo' kanak umagakan.” ");
INSERT INTO klg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Aw miglong pa uman si Jisus sa pundinganan, law nan, “Madyaw ya asin, manang kun kalagakan sa nanam, dili' da makaliku' ya ka͡asin nan. ");
INSERT INTO klg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wala' da ya ma-untung, pangkay sagel pa adti malalipa' na ayep pada imo-un abunu. Yeiy ya du-an na salabel da. Magpakatadeng kamu na dili' mayu pagpalipaslipasan ya pigdengeg mayu.” ");
INSERT INTO klg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na, ya manga mangangubla͡ay sa buwis aw ya manga makasasala' alag silan migpalapit kan Jisus kay kaliman nilan pakanyegan ya palna-u nan. ");
INSERT INTO klg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aw migpanggumudgumud ya manga Parisiyo aw manga magpalna-uway sa Uldin na manga Judiyu, law nilan, “Ya utaw ini, dyumawat sa manga makasasala' aw syumalu kanilan kyuman.” ");
INSERT INTO klg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yanagaw pig-ubatan silan ni Jisus sa pundinganan: ");
INSERT INTO klg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kun awun utaw dun ni kamayu na tyumagtun sa sanggatus ya karniro, aw nyalagak ya sambuk kanilan, unu ya un nan imo-un? Enda', ayawan pa nan saba ya kasiyaman tag siyam dun ni panabtabanan aw paninawun nan ya sambuk na nyalagak menda' na kita-en nan. ");
INSERT INTO klg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aw sa pagkita' da nan, to-o sakanan magleya aw pisanen nan ya karniro. ");
INSERT INTO klg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aw sa pagdateng nan adti balay, tawagen nan ya kanan manga ubaybay aw manga sumbalay, aw maglong kanilan, ‘Magleya kitadun kay pigkita' da ku ya kanak karniro na nyalagak.’ ");
INSERT INTO klg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aw maynan uman, dakula' pa saba ya pagleya na adti tas na langit asuntu sa sambuk na makasasala' na magselsel, kay sa kasiyaman tag siyam ya utaw na iman nilan aw matulid ya kanilan anenganeng aw dili' nilan ka-ilangan magselsel.” ");
INSERT INTO klg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aw kun ya sambuk uman na ka͡ubayan awun sampulu' ya drakma na kuwalta nan, aw kyalagakan sa sambuk, na, unu ya imo-un nan? Sulu-an nan saba ya kanan salengan aw pamunasan nan ya kanan balay. Aw to-o nan paninawun menda' na kita-en nan. ");
INSERT INTO klg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aw sa pagkita' da nan, tawagen nan ya kanan manga ubaybay aw manga sumbalay, aw maglong sakanan kanilan, ‘Magleya kitadun kay kyinita' da ku ya kanak kuwalta na nyalagak.’ ");
INSERT INTO klg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Maynan uman, dakula' saba ya pagleya na manga anghil na Tyumanem na awun ni tas na langit asuntu sa sambuk na makasasala' na migselsel.” ");
INSERT INTO klg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aw awun pa uman pundinganan na pig-ubat kanilan ni Jisus, law nan, “Awun sambuk na utaw na duwa ya ise' nan na eseg. ");
INSERT INTO klg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sambuk na allaw yan miglong ya mangud adti ama nan, ‘Kay Ma', atagan da kanak ya bagi' ku.’ Yanagaw pigtenga' na ama nilan ya kanan ka-unan adti duwa ya ise' nan. ");
INSERT INTO klg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Na, paglabay da na pilangallaw, piggalin na mangud ya kadég na pigbagi' kanan, aw tigkas yan, nyanaw sakanan adti mawat na banwa. Aw to-o nan pigdagwas ya kanan kuwalta adti pangkay unu na pagkaliman nan. ");
INSERT INTO klg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pagka͡abus da na kanan kuwalta, dyumateng uman ya dakula' na getem adti banwa yan. Aw dun da pagpalekat na to-o migkapelek sakanan. ");
INSERT INTO klg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yanagaw nyaninaw sakanan sa talabahu, aw yan ya kyaseledan nan ya magpakan sa manga taku' adti pawa' na sambuk na utaw dun ni banwa yan. ");
INSERT INTO klg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aw to-o sakanan nyagetem, yanagaw kaliman da nan galu kuman sa kakan na manga taku', kay wala' ya pangkay sambuk na nyatag kanan sa makan. ");
INSERT INTO klg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Aw pigpalekat nan ya pag-anenganeng sa kyabetangan nan. Aw miglong adti kanan anenganeng, ‘Ya kadég na magtalabahuway ni Ma', dakula' ya kanilan makan. Manang ya kanak ini, un da aku matay na ballus!’ ");
INSERT INTO klg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yanagaw miglong sakanan, ‘Madyaw pa baling na muli' aku adti kan Ma' aw paglongun ku sakanan, “Kay Ma', nyakasala' aku adti Tyumanem aw adti kanmu. ");
INSERT INTO klg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aw adun, dili' da aku umba' pagtawagen na ise' mu. Imo-a la aku baling sambuk na kanmu magtalabahuway!” ’ ");
INSERT INTO klg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Yanagaw pig-indegan nan ya banwa yan aw nyuli' adti tampid na ama nan. Aw sa mawat pa sakanan, pigkita' da na kanan ama aw to-o nan pigkallatan. Aw dyumalagan pasinan adti ise' nan, aw pigkepkep nan aw aleki. ");
INSERT INTO klg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aw miglong kanan ya ise', ‘Kay Ma', nyakasala' aku adti Tyumanem aw adti kanmu. Dili' da aku umba' pagtawagen na ise' mu.’ ");
INSERT INTO klg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Manang miglong ya kanan ama adti manga sugu-anen nan, ‘Maksay mayu dala adi ya to-o manenggeya na kadégkadég aw pasutan kanan. Paningsingi mayu ya tullu' nan aw dayaw mayu sandali ya siki nan. ");
INSERT INTO klg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aw angaya mayu uman ya nati na baka na pigpataba', aw tumba͡a mayu. Naten magpista, ");
INSERT INTO klg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kay ya ise' ku ini kasiling na nyatay da, manang utaw pa sakanan! Nyalagak idtu muna manang nyuli' da adun.’ Aw migpalekat silan migpista. ");
INSERT INTO klg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, wala' kadugay nyuli' ya ise' nan na magulang lekat adti pawa'. Aw sa malapit da sakanan adti balay, dyengeg nan ya sunata aw pagsayaw. ");
INSERT INTO klg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yanagaw pigtawag nan ya sambuk na sugu-anen aw nyusip kanan, ‘Unu ya pigleya͡an nilan awun ni balay?’ ");
INSERT INTO klg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Aw miglong kanan ya sugu-anen, ‘Nyuli' da ya mangud mu! Pigtumba͡an na ama mayu na nati na baka na pigpataba' kay nyuli' kunu ya ise' nan na madyaw ya lawas aw wala' ya kyagamakan nan!’ ");
INSERT INTO klg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Manang pagdengeg nan seiy, nyadaman to-o sakanan, aw dili' malim sumeled adti balay. Yanagaw lyumuwa' ya ama nan aw nyanginayu' kanan na sumambuk kanilan. ");
INSERT INTO klg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Manang tyumubag ya magulang sa ama nan, ‘Kay Ma', anenganenga pagaw, gayed aku migtalabahu kanmu seled da na pilangka͡umay. Aw wala' aku pagsuwayenen sa sugu' mu. Manang wala' ya pig-atag mu kanak pangkay da ise' na kambing na un ku pagpista eped na kanak manga ubaybay. ");
INSERT INTO klg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Manang sa pag-uli' da na ise' mu na migdagwas sa kanmu ka-unan adti manga ka͡ubayan na miggalin sa pagka-utawun nilan, dayaw mu baling pigtumba͡an sa nati na baka na pigpataba'!’ ");
INSERT INTO klg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aw miglong kanan ya ama nan, ‘Kay To', ini kaw gayed ni sayid ku. Aw ya kadég na nyatagtun ku alag saba kanmu. ");
INSERT INTO klg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Umba' saba kitadun magleya kay ya mangud mu ini la! Kasiling sakanan na nyatay da, manang utaw pa sakanan! Nyalagak idtu muna manang adun kyinita' da.’ ” ");
INSERT INTO klg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aw mig-ubat pa uman si Jisus sa pundinganan adti manga umagakan nan, law nan, “Awun sambuk na utaw na mayaman, aw pigtaligu nan adti kanan pagsaligan ya kanan manga ka-unan aw kuwalta. Manang awun manga utaw na migdiklamu adti mayaman na pigdagwas kunu na pagsaligan ya kuwalta nan. ");
INSERT INTO klg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yanagaw pigpatawag nan ya kanan pagsaligan, aw piglongan nan, ‘Unu ya dyengeg ku yeiy na diklamu kanmu? Atagan da kanak adun ya listahan sa kadég na manga pigbayadan mu aw ya manga pigpabeles mu na kuwalta ku, kay lekat adun dili' da kaw magpadeleg sa talabahu mu.’ ");
INSERT INTO klg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yanagaw miglong ya pagsaligan adti anenganeng nan, ‘Unu la ya un ku imo-un na beke' da ku ya pagsaligan na amu ku? Dili' ku mabatug ya mabegat na talabahu kasiling na pagkutkut sa lupa', aw to-o aku magkamulamula magsekatenen adti manga eped.’ ");
INSERT INTO klg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aw pagkatigkas nan anenganengen ya puluglima nan, miglong adti anenganeng nan, ‘Ah... yeiy baling ya madyaw ku imo-un pada madég ya ubaybay ku na dumawat kanak adti balay nilan dun ni allaw na wala' da ya talabahu ku.’ ");
INSERT INTO klg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yanagaw pigpatawag na pagsaligan ya tagsambuksambuk na nyakabeles sa amu nan. Pig-usip nan ya sambuk, ‘Pila ya beles mu adti amu ku?’ ");
INSERT INTO klg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aw tyumubag ya utaw yan, ‘Sanggatus ka sibulan ya mantika' na olibo.’ “Aw miglong kanan ya pagsaligan, ‘Ini la ya listahan sa beles mu. Ingkud kaw aw sulata na kalima͡an da olo' ya kyabelesan mu.’ ");
INSERT INTO klg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aw tigkas yan, miglong da uman adti kadwa na nyakabeles, ‘Pila uman ya kanmu beles adti amu ku?’ Aw tyumubag ya utaw yan, ‘Sanggatus ka anes ya trigu.’ Aw miglong ya pagsaligan, ‘Ini la ya listahan sa beles mu. Na, sulata na olo' da kawaluwan ka anes.’ ");
INSERT INTO klg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aw pigsaya' baling na amu nan ya kanan pagsaligan asuntu sa katadeng nan. Kay ya manga utaw asini tas na lupa' to-o pa baling madég ya kapandayan nilan sa pagbalikwat kay sa manga utaw na syumalig sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Aw paglongun ta kamu: Dumateng ya allaw na wala' da ya pagkamangan mayu. Yanagaw pagkanimbet kamu adun pada ma-imo' ya pagkaliman na Tyumanem asini tas na lupa' magi sa kuwalta mayu. Aw ya manga utaw na pigtabangan mayu na nyakaseled adti Kasakupan na Pighari-an na Tyumanem, to-o silan magleya sa pagkita' nilan kamayu kagaya adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ya utaw na kasaligan sa tagbi', kasaligan uman sa dakula'. Aw ya utaw na dili' kasaligan sa tagbi', dili' uman kasaligan sa dakula'. ");
INSERT INTO klg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yanagaw kun dili' kamu kasaligan sa kuwalta aw ka-unan asini tas na lupa', singalan ka' ya un magtaligu kamayu sa tengteng ka-unan adti tas na langit? ");
INSERT INTO klg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aw kun dili' kamu kasaligan sa pigtaligu kamayu na eped na utaw, na, singalan pa ka' ya un matag kamayu sa ka-unan na nyakatagilan da pada kamayu? ");
INSERT INTO klg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wala' ya allang na makadalug sa duwa ya tagtun, kay pakalaten nan ya sambuk aw ginawa͡an nan ya sambuk. Maynan uman, dalugun nan ya sambuk aw palipaslipasan nan baling ya sambuk. Dili' saba mabatug na utaw pagdenganen ya pagginawa sa kuwalta aw ya pagdalug sa Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sa pagdengeg na manga Parisiyo sa palna-u ni Jisus, pig-odoy-odoy nilan sakanan kay to-o nilan pigginawa͡an ya kuwalta. ");
INSERT INTO klg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Manang miglong si Jisus adti kanilan, “Migpakita-kita' kamu adti asdangan na manga utaw na sallong kunu na wala' ya sala' mayu, manang nya-ede' saba ya Tyumanem sa anenganeng mayu. Ya pigginawa͡an to-o na manga utaw asini tas na lupa, adti Tyumanem wala' ya ma-untung. ");
INSERT INTO klg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ya Uldin na pig-atag na Tyumanem kan Moysis aw ya manga pigsulat na manga propita, pigpa-ede' da menda' sa manga allaw ni Juan na Magba͡utismuway. Lekat dun ni allaw na pagdateng ni Juan, pigpa-ede' da adti manga utaw ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem. Aw madég ya migtibagseg na maka-akup dun. ");
INSERT INTO klg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Manang kenne' pa na awun ma-untung sa Uldin na pig-atag na Tyumanem. Molas pa malanas ya langit aw lupa' kay sa ma-uman ya pangkay tagbi' na kulis na pigpasulat dun ni Uldin. ");
INSERT INTO klg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kasiling uman na piglong dun ni Uldin sa mangugnanay: Kun awun eseg na ayawan nan ya kanan ka͡ubayan, aw kun mangugnan sa eped na ka͡ubayan, piglakadan da nan ya muna ka͡ubayan nan. Aw ya eseg na mangugnan sa ka͡ubayan na pig-ayawan da na eseg nan, miglakadenen uman sakanan.” ");
INSERT INTO klg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aw miglong pa uman si Jisus sa sambuk na pundinganan, law nan, “Awun utaw na mayaman na migkadégkadég sa téla na linum aw téla na tapel ya batek na alag dakula' ya alaga'. Aw migpa-eyang sakanan kyuman sa mangkadyaw na kakan kada allaw. ");
INSERT INTO klg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","“Aw dun ni luwa' na suwangan na pamanag na balay nan pigpakulang dun ya sambuk na utaw na makalalat na pigngalanan na si Lazaro. Ya lawas nan nyatmu' na pegsa ");
INSERT INTO klg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","aw kaliman nan galu kuman sa mumu' na nyangkataktak lekat adti lamisa na mayaman. Aw gayed dyumulud adti kanan ya manga idu' aw pyan-ilasan nilan ya manga pegsa nan. ");
INSERT INTO klg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na, sambuk na allaw nyatay si Lazaro, aw pya-agad sakanan na manga anghil adti tampid ni Abraham. Ya utaw na mayaman nyatay uman aw piglebeng. ");
INSERT INTO klg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aw dun ni banwa na Kaludukan to-o sakanan migti-is, aw sa paglangad nan kyinita' nan ya kanan tyugbulan na si Abraham adti mawat aw dun ni tampid nan si Lazaro. ");
INSERT INTO klg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yanagaw migtatawag ya mayaman, ‘We....kay Ma' na Abraham! Mallat kaw kanak. Sugu-a beg si Lazaro na tullak nan ya kanan tullu' adti tubig pada patagdu-an nan ya dila' ku. Kay to-o aku migti-is idi asuntu sa kapasu' na atulun!’ ");
INSERT INTO klg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Manang tyumubag si Abraham kanan, ‘Kay To', anenganenga pagaw, sa adtu pa kaw ni tas na lupa', madyaw ya kanmu pagpakabetang, aw si Lazaro, malatay ya kanan pagpakabetang. Manang adun, migleya sakanan idi, aw migti-is kaw sa kanmu. ");
INSERT INTO klg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aw dili' mabatug ya pigsekat mu, kay awun iyan ni tenga' tadun na gawang na to-o malalem na nyaka-elet kanaten. Aw pangkay singalan ya malim na madtu na lekat adi kanami, dili' nan mabatug ya pagkadtu, aw wala' uman ya lekat dun ni kamayu na makakadi.’ ");
INSERT INTO klg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aw miglong pa uman ya mayaman, ‘Nyanginayu' aku kanmu, kay Ma' na Abraham. Pakadtuwa si Lazaro adti balay na ama ku, ");
INSERT INTO klg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kay awun pa lima ya inulug ku aw pa-ede-en nan silan pada dili' silan makadalug kanak adi banwa idi na alag pagti-is.’ ");
INSERT INTO klg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Manang tyumubag si Abraham, ‘Adtu la ni kanilan ya pigpansulat ni Moysis aw manga propita na Tyumanem. Ka-ilangan pakanyegan nilan aw dalugun nilan.’ ");
INSERT INTO klg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aw miglong pa ya mayaman, ‘Manang kay Ma' na Abraham, dili' silan mangintu-u, kantaw kun awun madtu na lekat adti nyangkamatay, yan ya magselsel silan.’ ");
INSERT INTO klg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Manang miglong si Abraham kanan, ‘Kun dili' silan mangintu-u sa pigpalna-u ni Moysis aw manga propita na Tyumanem, dili' silan uman mangintu-u pangkay kun awun pa sambuk na mataw lekat adti nyangkamatay na magpalna-u kanilan.’ ” ");
INSERT INTO klg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aw miglong si Jisus adti kanan manga umagakan, “Awun saba manga makapasungkul adti pag-imo' sa sala'. Manang to-o malatay ya datengan na utaw na maggagad sa eped nan adti pag-imo' sa sala'. ");
INSERT INTO klg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kun awun utaw na migpadalem na nyangintu-u kanak aw kun buyuwun sakanan adti pagpakasala', ya utaw na magbuyu madyaw pa baling kun tati-an ya liyeg nan na dakula' na gilingan na batu aw ulugun sakanan adti dagat. ");
INSERT INTO klg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yanagaw magpakatadeng kamu! Kun awun inulug mu dun ni pagpangintu-u na makasala' kanmu, pagsagda͡an sakanan. Aw kun magselsel, pasinsiyayi sakanan. ");
INSERT INTO klg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aw kun makasala' adti kanmu pangkay sangallaw makapitu, aw makapitu uman liku' adti kanmu aw maglong sakanan, ‘Migselsel da aku,’ na, ka-ilangan pasinsiya͡an mu sakanan.” ");
INSERT INTO klg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pagkatigkas yan, miglong kanan ya manga apostolés, “Kay Pangulu, dugangi beg ya kanami pagpangintu-u!” ");
INSERT INTO klg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aw tyumubag si Jisus kanilan, “Kun awun tengteng na pagpangintu-u mayu pangkay tagbi' kasiling na bini' na mustardo, mabatug mayu paglongun ya dakula' na kawuy yeiy, ‘Na! Ka-akat kaw, aw ka-alin kaw adti dagat.’ Aw ka͡agadan saba na kawuy ya sugu' mu.” ");
INSERT INTO klg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aw miglong pa uman si Jisus adti kanilan, “Kun sambuk kamayu awun sugu-anen na migdaru aw kun beke' yan migtunggu' sa manga karniro, aw sa pag-uli' nan adti balay, enda', dili' kaw saba makapaglong kanan, ‘Ingkud kaw aw kan kaw asini tampid ku?’ ");
INSERT INTO klg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dili' saba. Yan baling ya paglongun mu kanan, ‘Maksay kaw kanak pag-imo' sa kakan. Pagkatigkas mu magsanggila' kanak, na, kan da kaw uman sa kanmu.’ ” ");
INSERT INTO klg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aw dili' uman pasalamatan na amu ya sugu-anen nan kay ya sugu-anen olo' nan pigtuman ya pigsugu' kanan. ");
INSERT INTO klg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aw maynan uman kamu. Pagkatigkas da mayu tumanen ya kadég na pigsugu' kamayu, maglong kamu, ‘Olo' kami sugu-anen aw dili' umba' pasalamatan kay pig-imo' nami olo' ya kanami imo-unun.’ ” ");
INSERT INTO klg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Talana ni Jisus migpasinan adti Jérusalim, nyagi sakanan dun ni eletanan na banwa na Samariya aw Galilya. ");
INSERT INTO klg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aw sa pagseled da nan adti sambuk na baranggay, syumungun kanan ya sampulu' ya ibungun, aw tyumeneng silan adti mawatawat ");
INSERT INTO klg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aw migtatawag silan, “Kay Jisus na Magpalna-uway! Kallati beg kami.” ");
INSERT INTO klg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sa pagkita' ni Jisus kanilan, piglongan nan silan, “Kadtu kamu ni Témplo aw patanawan ya kamayu lawas adti manga magdadugsu-ay.” Aw sa talana pa nilan migpasinan adti Jérusalim, pyangkalinisan da ya kanilan lawas. ");
INSERT INTO klg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aw ya sambuk kanilan, sa pagkita' nan na kyaguli-an da sa ibung nan, lyumiku' sakanan adti kan Jisus na migdeyen sa Tyumanem sa mabagseg na tingeg. ");
INSERT INTO klg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aw lyumuhud sakanan aw dyumukduk adti siki ni Jisus, aw to-o migpasalamat kanan. Na, ya utaw yeiy, Samariyanen sakanan. ");
INSERT INTO klg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pagkatigkas yan, miglong si Jisus, “Enda', sampulu' kamu ya kyalinisan? Ayin da saba ya siyam? ");
INSERT INTO klg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ananga' wala' liku' ya manga eped na un magdeyen sa Tyumanem, olo' baling utaw ini na beke' na tengteng Judiyu?” ");
INSERT INTO klg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aw miglong si Jisus kanan, “Indeg kaw aw panaw da kaw. Ya kanmu pagpangintu-u, yan ya du-an na kyaguli-an kaw.” ");
INSERT INTO klg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na, sambuk na allaw awun manga Parisiyo na nyusip kan Jisus, “Kinunu pagpalekat ya Paghari' na Tyumanem sa Kasakupan nan asini tas na lupa'?” Aw tyumubag si Jisus kanilan, “Sa pagpalekat na paghari' na Tyumanem wala' ya kita-en mayu na pangilala. ");
INSERT INTO klg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yanagaw wala' ya makapaglong, ‘Tanawa! Ini la!’ Aw dili' uman makapaglong, ‘Awun da!’ Kay ya paghari' na Tyumanem awun da saba ni kamayu.” ");
INSERT INTO klg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pagkatigkas yan, miglong si Jisus adti kanan manga umagakan, “Un saba dumateng ya manga allaw na kaliman mayu galu kumita' kanak na Ise' na Utaw pangkay kun olo' sangallaw, manang dili' da aku mayu kita-en. ");
INSERT INTO klg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aw dengegen mayu ya ubat-ubat na manga utaw na maglong, ‘Tanawa! Ini la!’ Aw maglong ya sambuk, ‘Awun da sakanan!’ Manang dili' kamu magka-agad-agad kanilan aw dili' da aku mayu pagpaninawun. ");
INSERT INTO klg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay aku na Ise' na Utaw, dun ni kanak pagliku' kita-en saba na kadég, kasiling na kilat na magpaka-ilaw sa kadakula' na langit. ");
INSERT INTO klg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Manang ka-ilangan ku una ka-agiyan ya madég na manga pagti-is aw kele͡an aku na manga utaw adun na manga allaw yeiy. ");
INSERT INTO klg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Aw kasiling na nya-imo' dun ni manga allaw ni Nuwi, maynan uman ya un ma-imo' dun ni allaw na pagliku' na Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sa wala' pa dateng ya dakula' na lenep, migpadeleg ya manga utaw kyuman aw nyan-inem, aw nyampangugnan, menda' sa allaw na syumeled si Nuwi adti arka. Aw dyumateng ya dakula' na lenep aw nyabus silan nyangkalemes. ");
INSERT INTO klg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Maynan uman ya nya-imo' dun ni manga allaw ni Lot. Ya manga utaw, gayed silan kyuman aw nyan-inem aw nyampamalit aw nyampamaligya', aw gayed silan nyampananem aw migpantulluk sa manga balay. ");
INSERT INTO klg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Manang dun ni allaw na pagpakaluwa' ni Lot adti syudad na Sodoma, aw pigpa-ulanan na Tyumanem ya syudad na atulun aw asupri. Aw nyabus silan nyangkamatay. ");
INSERT INTO klg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aw maynan uman ya ma-imo' sa lumiku' ya Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Dun ni allaw yan, ya utaw na adti luwa' na balay, dili' da sakanan magliku' adti seled na un pa kumamang sa pangkay unu. Aw kun awun utaw na magtalabahu adti pawa' nan, dili' da sakanan mag-uli'. ");
INSERT INTO klg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Anenganenga mayu ya kyagamakan na ka͡ubayan ni Lot. ");
INSERT INTO klg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pangkay singalan ya gyuminawa sa pagka-utawun nan asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay, yan ya un makatagtun sa ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Paglongun ta kamu: Sa pagliku' ku, kun awun duwa ya utaw na nyakatulug adti tambi', ya sambuk kamangen aw ya sambuk ka-ayawan. ");
INSERT INTO klg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aw maynan uman kun awun duwa ya ka͡ubayan na miggiling, ya sambuk kamangen aw ya sambuk ka-ayawan. ");
INSERT INTO klg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aw kun awun duwa ya eseg na migtalabahu adti pawa', ya sambuk kamangen aw ya sambuk ka-ayawan.” ");
INSERT INTO klg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aw nyusip kanan ya manga umagakan nan, law nilan, “Kay Magpalna-uway, ayin yeiy apit ka-imo'?” Aw tyumubag si Jisus kanilan magi sa pundinganan, “Kya-ede-an mayu na kun ayin ya lawas na nyatay da, adtu uman pagkatipunuk ya manga uwak.” ");
INSERT INTO klg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pagkatigkas yan, piglongan ni Jisus ya kanan manga umagakan sa pundinganan pada palna-uwan silan na gayed manawagtawag adti Tyumanem aw dili' magkalumay ya ginawa nilan. ");
INSERT INTO klg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yanagaw miglong si Jisus kanilan, “Adti sambuk na syudad awun mag-ukumay na wala' ya pagkallek sa Tyumanem aw wala' uman ya pagpamasa nan sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dun uman ni syudad yan awun sambuk na ka͡ubayan na balu na gayed migliku-liku' adti asdangan na mag-ukumay aw nyanginayu' kanan, law nan, ‘Tabangi aku beg adti sambuk na migdiklamu kanak aw pakadyawa ya pag-usay kanami.’ ");
INSERT INTO klg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Na, madugay pigpalipaslipasan na mag-ukumay ya pigsekat nan, manang sa kadugayan nyilab sakanan sa pagpanginayu' na balu, aw miglong adti anenganeng nan, ‘Pangkay wala' ya pagkallek ku sa Tyumanem aw wala' ya pagpamasa ku sa manga utaw, ");
INSERT INTO klg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","manang asuntu na gayed gyumelgel kanak ya balu ini, yanagaw pakadyawun da ku ya pag-usay kanilan, kay kun dili' ku imo-un yeiy, gayed pa aku nan liku-liku-an aw mabus baling ya kanak pasinsiya.’ ” ");
INSERT INTO klg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aw miglong pa uman si Jisus adti kanilan, “Anenganenga mayu ya piglong na mag-ukumay yeiy. Pangkay wala' sakanan dalug sa pagkaliman na Tyumanem manang matulid ya kanan pag-ukum. ");
INSERT INTO klg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aw dakula' pa saba dun ya tabang na Tyumanem adti manga utaw na pigtani la nan na nyanginayu' kanan allaw aw gabi. Aw dili' nan palipaslipasan ya manga pigsekat nilan. ");
INSERT INTO klg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Paglongun ta kamu, maksay nan saba silan tabangan. Manang aku na Ise' na Utaw sa pagliku' ku kagaya asini tas na lupa', unu, awun pa ka' kita-en ku na manga utaw na awun pagpangintu-u?” ");
INSERT INTO klg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, awun manga utaw na migpatastas kay adti kanilan anenganeng, wala' ya sala' nilan, manang pigna-na' nilan ya kanilan manga eped. Yanagaw pig-ubat-ubatan silan ni Jisus sa pundinganan, ");
INSERT INTO klg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","law nan, “Awun duwa ya utaw na nyadtu ni Témplo na un manawagtawag adti Tyumanem. Ya sambuk Parisiyo aw ya sambuk mangungubla͡ay sa buwis. ");
INSERT INTO klg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nyindeg ya Parisiyo na sayda nan, aw maynini ya kanan pagpanawagtawag: ‘Kay Tyumanem, to-o aku migpasalamat kanmu na dili' aku kasiling na manga utaw na matilimbungay aw malatay ya bet aw maglakadenen, aw dili' aku kasiling na utaw iyan na mangangubla͡ay sa buwis. ");
INSERT INTO klg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kada simana makadwa aku magpuwasa. Aw nyatag aku kanmu sa kasampulu' na kadakula' na pagkamangan ku.’ ");
INSERT INTO klg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Manang ya mangangubla͡ay sa buwis, nyindeg adti mawatawat, aw wala' sakanan langad adti langit. Pigbug nan baling ya aba nan kay to-o sakanan migselsel aw nyanawagtawag, law nan, ‘We.... Tyumanem, kallati beg aku kay makasasala' aku.’ ");
INSERT INTO klg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Paglongun ta kamu: Sa pag-uli' da na mangangubla͡ay sa buwis, pigdawat sakanan na Tyumanem kasiling na wala' da ya sala', aw wala' nan dawata ya Parisiyo. Kay pangkay singalan ya magpatastas, padalemen saba, aw ya utaw na magpadalem, pakatasen sakanan.” ");
INSERT INTO klg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, sambuk na allaw, awun manga utaw na nyandala adti kan Jisus sa mangkayantek na mangayse' nilan na un nan silan pan-awidan pada atagan silan na manga kadyawan. Manang sa pagkita' na manga umagakan nan, pigsagda nilan baling ya manga utaw na nyandala sa manga mangayse' nilan. ");
INSERT INTO klg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Manang pigtawag ni Jisus ya manga mangayse', aw piglongan nan ya kanan manga umagakan, “Pakadiya kanak ya manga mangayse' aw ya-i mayu silan pagtageni! Kay ya manga utaw na dyumawat kanak kasiling na manga mangayse' ini, silan saba ya maka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Matinaw saba ya un ku paglongun kamayu: Pangkay singalan ya dili' malim dumawat kanak kasiling na pagdawat kanak na manga mangayse' ini, dili' saba silan makaseled adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na, nyusip kan Jisus ya sambuk na malangkaw na manga Judiyu, “Kay Magpalna-uway na to-o madyaw, unu ya ka-ilangan ku imo-un pada matagtun ku ya ginawa na wala' ya katigkasan?” ");
INSERT INTO klg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aw tyumubag si Jisus kanan, “Ananga' aku mu ngalanan na madyaw? Wala' saba ya utaw na madyaw. Sambuk da olo' ya tengteng madyaw, aw yan ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na, kya-ede-an mu ya manga sugu' dun ni Uldin: Dili' kaw maglakadenen, aw dili' kaw magpatay sa eped na utaw, aw dili' kaw magpanakaw, aw dili' mu pagmatinawun ya galu' adti asdangan na mag-usayay, aw pagbasa͡an mu ya kanmu ama aw ina.” ");
INSERT INTO klg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aw tyumubag ya eseg, law nan, “Alag da ku yeiy pigdalug lekat pa na pagkatagbi' ku.” ");
INSERT INTO klg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aw sa pagdengeg ni Jisus sa tubag nan, miglong sakanan, “Dakman sambuk ya imo-un mu: Galina ya kadég na nyatagtun mu. Tigkas yan, atagan ya kuwalta adti manga utaw na wala' ya pagkamangan. Kun imo-un mu yeiy, dun da kaw pagluduk sa ka-unan adti tas na langit. Aw pagkatigkas yan, liku' kaw adi aw dalug kaw kanak.” ");
INSERT INTO klg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Manang sa pagdengeg nan sa piglong ni Jisus, migkalat ya ginawa nan kay to-o sakanan mayaman. ");
INSERT INTO klg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Aw sa pagkita' ni Jisus na migkalat ya ginawa nan, miglong sakanan, “Malug saba sa utaw na mayaman ya pagpaka-akup adti Kasakupan na Pighari-an na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Molas pa ya pag-agi na ayep na kamilyo adti gawang na dagem kay sa pagpaka-akup na utaw na mayaman dun ni Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aw ya manga utaw na nyakadengeg sa piglong ni Jisus, nyusip silan kanan, “Na, kun maynan, singalan ka' ya paluwa-en na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aw tyumubag si Jisus, “Ya dili' mabatug na utaw mabatug saba na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aw miglong si Pédro kanan, “Inunuwa ya kanami ini! Nyabus da nami pig-ayawan ya kadég na nyatagtun nami pada magad kanmu.” ");
INSERT INTO klg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aw tyumubag si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Pangkay singalan ya mag-ayaw sa balay nan, aw sa ka͡ubayan nan, aw kaylug nan aw mangkatikadeng nan aw mangayse' nan, asuntu sa Kasakupan na Pighari-an na Tyumanem, ");
INSERT INTO klg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na, makadawat ya utaw yan asini tas na lupa' sa to-o pa madég kay sa idtu na pig-ayawan nan. Aw adti kamoliyan kagaya na allaw matagtun nan uman ya ginawa na wala' ya katigksan.” ");
INSERT INTO klg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pagkatigkas yan, pigtani ni Jisus ya sampulu' tag duwa ya umagakan nan, aw law nan kanilan, “Pada ka-ede-an mayu, migpasinan da kitadun adti Jérusalim aw adtu la katuman ya kadakula' na pigsulat na manga propita sa ma-imo' kanak na Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kay tumbay aku adti manga Héntil, aw odoy-odoyun aku nilan aw eleb-eleban, ");
INSERT INTO klg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","aw badasan labeten, aw tigkas yan, patayen aku nilan. Manang pagdateng da na katlu na allaw, mataw aku lekat adti pagkamatay.” ");
INSERT INTO klg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Manang wala' na manga umagakan nan kalabeti ya kakawasan na piglong nan. Kay pigtagu' pa adti kanilan ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na, sa malapit da si Jisus adti syudad na Jériko, awun eseg na buta na nyingkud dun ni kilid na dalan aw gayed migsekat sa kuwalta. ");
INSERT INTO klg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aw sa pagdengeg nan sa madég na manga utaw na lyumabay dun, nyusip sakanan, “Unu yangadi?” ");
INSERT INTO klg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aw miglong ya manga utaw kanan, “Lyumabay si Jisus na taga Nazarit!” ");
INSERT INTO klg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yanagaw to-o sakanan migtatawag, “We... Jisus na buwadbuwad ni Dabid, kallati beg aku!” ");
INSERT INTO klg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aw pigsagda sakanan na manga utaw na nyaka-una kan Jisus, law nilan, “Katinep kaw!” Manang to-o pa nan baling pigpakadakula' ya kanan tingeg, “We... Buwadbuwad ni Dabid, kallati beg aku!” ");
INSERT INTO klg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yanagaw tyumeneng si Jisus, aw syumugu' na pa-agad ya eseg na buta adti kanan. Aw sa malapit da sakanan, nyusip kanan si Jisus, ");
INSERT INTO klg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Unu ya kaliman mu na imo-un ku kanmu?” Aw tyumubag ya eseg yan, “Kay Sir, kaliman ku beg na kumita salut.” ");
INSERT INTO klg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aw miglong pa si Jisus kanan, “Kumita' da kaw. Asuntu sa pagpangintu-u mu kanak, kyaguli-an da kaw.” ");
INSERT INTO klg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aw dayaw sakanan kyumita' aw dyumalug kan Jisus na to-o migdeyen sa Tyumanem. Aw sa pagkita' na manga utaw sa nya-imo' yeiy, pigdeyen nilan uman ya Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na, syumeled da si Jisus adti syudad na Jériko. ");
INSERT INTO klg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dun ni banwa yan awun sambuk na eseg na pigngalanan na si Zakiyo. Sambuk sakanan na mangkatas na manga mangungubla͡ay sa buwis, aw mayaman sakanan. ");
INSERT INTO klg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aw kaliman ni Zakiyo na kumita' kan Jisus. Manang dili' nan mabatug kay magkagpa' sakanan aw madég ya manga utaw na nyaka-una kanan. ");
INSERT INTO klg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yanagaw dyumalagan si Sakiyo adti ma-una aw nyanik adti kawuy na sikamoro pada kita-en nan si Jisus kay dun sakanan agi. ");
INSERT INTO klg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aw sa pag-agi la ni Jisus dun, lyumangad sakanan aw miglong, “Kay Zakiyo, kaksay kaw panog! Kay adun na allaw yeiy ka-ilangan na madtu aku ni balay mu.” ");
INSERT INTO klg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yanagaw maksay nyanog si Zakiyo aw migleya sakanan dyumawat kan Jisus adti balay nan. ");
INSERT INTO klg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aw ya kadég na kyumita' kanan migpanggumudgumud silan na miglong, “Ananga' si Jisus lumaba' adti balay na utaw na makasasala'?” ");
INSERT INTO klg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Manang nyindeg si Zakiyo aw miglong, “Kay Magpalna-uway, atag ku adun adti manga utaw na makalalat ya katenga' na nyatagtun ku. Aw kun awun kyalimbungan ku na pangkay singalan, uli' ku kanan na upat ka pilu'.” ");
INSERT INTO klg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sa pagdengeg ni Jisus seiy, miglong sakanan, “Adun na allaw yeiy, ikaw aw ya ka-epedanan mu asini balay pigpaluwa' da kamu lekat adti pa-emel-emel na Tyumanem. Kay nyangintu-u la kaw, kasiling ni Abraham na kanaten tyugbulan. ");
INSERT INTO klg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aw yan saba ya pigkadi na Ise' na Utaw asini tas na lupa' pada paliku-un ya manga nyakasuway.” ");
INSERT INTO klg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aw sa kenne' pa na manga utaw migpakanyeg sa piglong ni Jisus, mig-ubat-ubat sakanan sa sambuk na pundinganan, kay malapit da sakanan adti Jérusalim aw iman na manga utaw aw agpet da magpalekat ya Paghari' na Tyumanem sa Kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yanagaw miglong si Jisus adti kanilan, “Na, awun dengganen na utaw adti sambuk na banwa. Aw nyanaw sakanan adti mawat na banwa pada dumawat sa katundanan sa pagkahari' dun ni kanan kasakupan, aw tigkas yan, muli' uman sakanan. ");
INSERT INTO klg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manang sa wala' pa sakanan indeg, pigpatawag nan ya sampulu' ya sugu-anen nan, aw pigtaliguwan nan ya tagsambuksambuk kanilan sa kuwalta. Aw piglongan nan silan, ‘Balikwata mayu ya kuwalta ku ini taman na pag-uli' ku.’ ");
INSERT INTO klg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Manang pigkalatan sakanan baling na ginawa na manga utaw dun ni kanilan banwa. Yanagaw, sa pagpanaw da nan, awun manga utaw na pigsugu' nilan adti un nan kadtuwan na maglong, ‘Dili' kami malim na maghari ya utaw yeiy kanami.’ ");
INSERT INTO klg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pangkay maynan ya piglong nilan manang kenne' sakanan ya pig-imo' hari'. Aw sa pag-uli' nan da nan, pigpatawag nan ya tagsambuksambuk na sugu-anen na pigtaliguwan nan sa kuwalta pada ka-ede-an nan kun pila ya nyabalikwat nilan. ");
INSERT INTO klg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ya nyaka-una dyumateng, miglong sakanan, ‘Kay Sir, ya kuwalta na pigtaligu mu kanak, nyakaginansya aku sa sampulu'.’ ");
INSERT INTO klg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aw miglong kanan ya hari', ‘Madyaw to-o ya pig-imo' mu! Madyaw kaw saba na sugu-anen. Na, asuntu na kasaligan kaw sa tagbi', atagan ta kaw sa pagdumala sa sampulu' ya syudad.’ ");
INSERT INTO klg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pagkatigkas yan, dyumateng uman ya kadwa na sugu-anen aw miglong, ‘Kay Sir, ya kuwalta na pigtaligu mu kanak, nyakaginansya aku uman sa lima.’ ");
INSERT INTO klg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aw miglong kanan ya hari', ‘Madyaw yan! Atag ku kanmu ya pagdumala sa lima ya syudad.’ ");
INSERT INTO klg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pagkatigkas yan, dyumateng uman ya sambuk na sugu-anen aw miglong, ‘Kay Sir, ini la ya kuwalta mu. Dayaw ku pigputus na panyu' aw pigtagu' ku pada dili' malagak, ");
INSERT INTO klg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kay nyallek aku kanmu asuntu na maksay kaw magkadaman. Magpangamang kaw sa wala' mu talabahuwi aw pag-aniyen mu ya kana eped na beke' mu ya migtanem.’ ");
INSERT INTO klg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aw tyumubag ya hari', ‘Wala' ya katukanan na pagkasugu-anen mu! Ya kanmu tingeg, yan uman ya gamiten ku sa pag-ukum kanmu. Kya-ede-an mu na maksay aku magkadaman aw magpangamang sa wala' ku talabahuwi aw pag-aniyen ku ya kana eped na beke' ku ya migtanem. ");
INSERT INTO klg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ananga' wala mu baling betangan adti bangku ya kanak kuwalta pada awun ginansya?” ");
INSERT INTO klg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pagkatigkas yan, miglong ya hari' adti manga eped na sugu-anen nan, ‘Kamanga mayu ya kuwalta adti kanan aw atagan adti sugu-anen na nyakaginansya sa sampulu'.’ ");
INSERT INTO klg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Manang miglong silan, ‘Kay Sir, awun da saba ginansiya nan na sampulu'.’ ");
INSERT INTO klg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tyumubag kanilan ya hari', ‘Paglongun ta kamu: Ya utaw na migpakadyaw sa pigtaligu kanan, taliguwan pa uman sakanan sa madég. Manang ya utaw na wala' nan pakadyawa ya pigtaligu kanan, pangkay ya tagbi' na pigtaligu kanan, kamangen pa lekat adti kanan. ");
INSERT INTO klg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aw adti manga po-on ku asini kanak kasakupan na dili' malim na maghari' aku kanilan, pa-agadan mayu silan adi aw pamataya asini asdangan ku.’ ” ");
INSERT INTO klg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagkatigkas ni Jisus maglong sa pundinganan yeiy, nyindeg sakanan aw migpadeleg sa panaw nan pasinan adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na, sa malapit da silan adti manga baranggay na Bétpagi aw Bétaniya dun ni kilid na Buntud na Manga Olibo, pigsugu' nan ya duwa ya umagakan na muna silan, ");
INSERT INTO klg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","law nan, “Kadtu kamu dun ni baranggay adti dipag. Aw sa pagseled mayu dun, kita-en mayu ya sambuk na nati na asnu na wala' pa kasakayi na utaw. Ubada mayu ya eket nan aw guyuda mayu adi. ");
INSERT INTO klg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pagaw awun musip kamayu, ‘Ananga' mayu ubadan ya nati yeiy?’ Paglonga mayu sakanan, ‘Ya Magpalna-uway ka-ilangan nan ya nati ini.’ ” ");
INSERT INTO klg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yanagaw nyanaw ya duwa aw kyinita' nilan ya nati na asnu kasiling na piglong ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sa talana nilan pig-ubad ya eket, nyusip kanilan ya manga tagtun sa asnu, “Ananga' mayu yan ubadan?” ");
INSERT INTO klg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aw tyumubag silan, “Awun katukanan na Magpalna-uway nami.” ");
INSERT INTO klg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aw pigguyud nilan ya nati adti kan Jisus aw pig-apidan nilan aw pigpasakay nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sa pagpasinan da nan adti Jérusalim, migpansiladlad ya manga utaw dun ni dalan sa kadégkadég na yan ya palangad pagpamasa nilan kan Jisus ");
INSERT INTO klg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aw sa pagtubang ni Jisus dun ni Buntud na Manga Olibo na malapit da adti Jérusalim, to-o madég ya manga utaw na dyumalug kanan, aw migpansideyen silan sa Tyumanem sa dakula' na tingeg asuntu sa manga milagru na pigpan-imo' nan na kyinita' nilan. ");
INSERT INTO klg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Miglong silan, “Ini la ya Hari' na Pigpadala na Tyumanem dun ni kanan ngalan aw umba' sakanan deyen! Awun kalinaw adti tas na langit, aw deyen ya Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na, dun ni kadég na manga utaw, awun manga Parisiyo na miglong kan Jisus, “Kay Magpalna-uway, patinepa ya kanmu manga umagakan.” ");
INSERT INTO klg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Manang tyumubag si Jisus kanilan, “Paglongun ta kamu: Kun matinep ya manga utaw, batu baling ya magdeyen kanak.” ");
INSERT INTO klg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sa malapit da si Jisus adti Jérusalim aw sa pagkita' da nan sa syudad, migsugaw sakanan asuntu sa manga utaw na nyeya' dun, ");
INSERT INTO klg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aw law nan, “Kaliman ku galu na ka-ede-an mayu adun na allaw yeiy ya un maka-atag kamayu sa kalinaw. Manang adun, nyatagu' yeiy baling adti kamayu. ");
INSERT INTO klg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Un saba dumateng ya manga allaw na palibedan na manga po-on mayu ya syudad aw mag-imo' silan sa inalad pada dili' kamu maka-agi aw dili' kamu uman makapalaguy. ");
INSERT INTO klg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Agba-en nilan ya kadakula' na syudad menda' na wala' da ya manga batu na pig-ilantulantu pangkay sambuk. Ka-ampugan kamu aw pangkatabunan dala ya mangayse' mayu. Alag yeiy ma-imo' asuntu na pigpalipaslipasan mayu ya pagkadi na Tyumanem na un magpaluwa' kamayu.” ");
INSERT INTO klg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagdateng da ni Jisus adti Jérusalim, syumeled sakanan adti pamanag na Témplo aw pigpalekat nan ya pag-alilin sa manga utaw na nyampamaligya' dun. ");
INSERT INTO klg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aw piglongan nan silan, “Yeiy ya pigpasulat na Tyumanem asini muna, ‘Ya kanak balay pagtawagen na panawagtawaganan.’ Manang pig-imo' mayu baling tagu-anan na manga mangkatakaw.” ");
INSERT INTO klg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aw kada allaw migpalna-u si Jisus adti Témplo. Manang ya manga mangkatas na magdadugsu-ay, aw manga magpalna-uway sa Uldin, aw ya manga mangkalangkaw na manga Judiyu, byantakan nilan si Jisus na patayen. ");
INSERT INTO klg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Manang wala' silan pakaselat pagpatay kanan kay madég to-o ya manga utaw na migpakanyeg sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na, sambuk na allaw, migpalna-u si Jisus adti manga utaw dun ni pamanag na Témplo aw migpa-ede' sa Madyaw na Ubat-ubat. Aw dyumulud kanan ya manga mangkatas na magdadugsu-ay, aw ya manga magpalna-uway sa Uldin, aw manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aw nyusip silan kanan, “Ubatan kanami: Unu ya katundanan mu na du-an pig-alilinan mu ya manga utaw asini Témplo? Aw singalan ka' ya nyatag kanmu sa katundanan na imo-un mu ya maynan?” ");
INSERT INTO klg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aw miglong si Jisus kanilan, “Usipen ta kamu uman. Ubatan mayu kanak kun ");
INSERT INTO klg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ayin lekat ya katundanan ni Juan sa pagba͡utismu nan sa manga utaw? Unu, lekat adti Tyumanem aw olo' lekat adti utaw?” ");
INSERT INTO klg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aw mig-usip-usipay silan, “Unu ya un tadun tubag kanan? Kun tubagen tadun na ‘lekat adti Tyumanem,’ maglong sakanan kanaten, ‘Ananga' wala' kamu pangintu-u kanan?’ ");
INSERT INTO klg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Manang kun tubagen tadun uman ‘lekat adti utaw,’ na, pamintuwun kitadun baling na manga utaw na batu, kay pyangintu-uwan nilan na si Juan propita sakanan na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yanagaw tyumubag silan kan Jisus, “Enday, Wala' nami ka-ede-i.” ");
INSERT INTO klg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aw miglong si Jisus kanilan, “Dili' ta kamu uman ubatan kun singalan ya nyatag kanak sa katundanan na ma-imo' ku ya maynan.” ");
INSERT INTO klg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aw migpalekat si Jisus mig-ubat-ubat sa pundinganan adti manga utaw, “Awun sambuk na eseg na migpatanem sa madég na balagen na paras adti lupa' nan, aw pigpasa-up nan ya parasan aw nyadtu sakanan adti sambuk na banwa aw nyeya' pa dun na madugay. ");
INSERT INTO klg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pagdateng na allaw na migpa-ipu' da sa bunga na paras, pigsugu' na tagtun ya sambuk na kanan sugu-anen adti manga pigpasa-up nan sa parasan kay kaliman nan kamangen ya kanan bagi'. Manang pagdateng na sugu-anen nan dun, byadasan nilan pyanumbag, aw pigpa-uli' nilan na wala' ya dyala. ");
INSERT INTO klg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aw migsugu' da uman ya tagtun sa sambuk na sugu-anen nan. Manang byadasan nilan pyanumbag aw pigmulamula. Aw pigpa-uli' nilan na wala' ya dyala. ");
INSERT INTO klg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tigkas yan, pigsugu' nan uman ya katlu na sugu-anen nan, manang pigpali-an nilan baling aw pig-alilinan. ");
INSERT INTO klg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pagkatigkas yan, miglong ya tagtun sa parasan, ‘Unu la ya un ku imo-un? Na, sugu-un ku baling ya kanak ise' na eseg na to-o ku pigginawa͡an pagaw yeiy ya basa͡an nilan.’ ");
INSERT INTO klg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Manang sa pagkita' na manga sa-up kanan, migbalawbalaw silan na maglong, ‘Ini la ya ise' na tagtun! Na! Naten sakanan patayen pada matagtun da tadun ya parasan na un ayawan kanan.’ ");
INSERT INTO klg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aw pigdala nilan sakanan adti luwa' na parasan aw pigpatay nilan. Aw nyusip si Jisus sa manga utaw, “Na, unu ya imo-un na tagtun sa parasan sa manga utaw na pigpasa-up nan? ");
INSERT INTO klg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kadtuwan nan saba silan aw alag nan pamatayen! Aw pasa-up nan ya parasan adti eped na manga utaw.” Pagkatigkas ni Jisus maglong sa pundinganan yeiy, miglong ya manga utaw na migpakanyeg, “Dili' yan tumbay na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Manang nyinunu si Jisus kanilan aw nyusip, “Kun maynan, unu saba ya kakawasan na pigpasulat na Tyumanem: ‘Ya dakula' na batu na iman na manga panday aw wala' ya guna, yan baling ya batu na sumalem na nya-imo' tullukanan sa balay.’ ");
INSERT INTO klg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ya utaw na pagsungkul adti batu yan aw pakadakdak, madugdug sakanan. Aw ya pangkay singalan na kolugan na batu yan, madupuk saba.” ");
INSERT INTO klg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pagdengeg na manga magpalna-uway sa Uldin aw manga mangkatas na magdadugsu-ay sa pundinganan ni Jisus, kaliman nilan galu dakepen si Jisus, kay kya-ede-an nilan na silan ya pigpalabet dun ni pundinganan nan. Manang nyallek silan sa manga utaw dun. ");
INSERT INTO klg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yanagaw gayed nilan pigbantayan si Jisus aw migsugu' silan sa manga utaw na un manilib na sallong kunu madyaw ya tud nilan. Manang yan ya tengteng tud nilan na kalitagan si Jisus dun ni tubag nan, pada awun kalimanda nilan kanan aw tumbay adti gubirnador. ");
INSERT INTO klg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aw nyusip ya manga nyanilib kan Jisus, “Kay Magpalna-uway, kya-ede-an nami na ya kadég na piglong aw pigpalna-u mu alag matinaw aw wala' ya pigkibang mu. Aw gayed mu pigpalna-u ya tengteng pagkaliman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yanagaw ubatan kanami kun pigtumbay adti Uldin tadun na manga Judiyu ya pagbayad sa buwis adti kan César aw ya dili'?” ");
INSERT INTO klg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Manang kya-ede-an ni Jisus ya kapandayan nilan, aw piglongan nan silan, ");
INSERT INTO klg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakita͡an kanak ya kuwalta. Kan yeiy gya ya ini? Aw kan yeiy uman ngalan ya nyakasulat asini?” Tyumubag silan, “Kan César.” ");
INSERT INTO klg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aw miglong si Jisus kanilan, “Na, atagan mayu adti kan César ya umba' kan César aw atagan adti Tyumanem ya umba' sa Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yanagaw wala' nilan kabatug kalitagi si Jisus dun ni tubag nan. Manang nya-enneng-enneng silan baling sa tubag nan aw nyatinep da silan. ");
INSERT INTO klg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na, awun dyumulud kan Jisus na manga Sadusiyo. Ya manga utaw yeiy wala' silan pangintu-u na awun pagkataw na manga utaw lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yanagaw nyusip silan kanan, “Kay Magpalna-uway, pigsulat kanaten ni Moysis ya sugu' yeiy adti Uldin tadun: ‘Kun awun eseg na nyatay, aw kun wala' silan ya ka͡ubayan nan paka-ise', ka-ilangan pangugnanen na inulug na eseg ya nyabalu pada ya mangayse' nilan ma-imo' da buwadbuwad na inulug nan na nyatay da.’ ");
INSERT INTO klg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, awun pitu ya mangkaylug na eseg. Ya magulang sa kadég nilan nyangugnan sa ka͡ubayan, manang nyatay ya eseg yan na wala' silan paka-ise'. ");
INSERT INTO klg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yanagaw ya balu pigpangugnan na mangud nilan, aw nyatay da uman ya eseg yan na wala' silan paka-ise'. ");
INSERT INTO klg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aw maynan uman ya nya-imo' adti katlu taman adti kapitu, alag silan nyatay na wala' paka-ise'. ");
INSERT INTO klg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pagkatigkas yan, nyatay da uman ya ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, kun dumateng ya allaw na panmatawun ya manga utaw lekat adti nyangkamatay, singalan ya tengteng eseg na ka͡ubayan yan? Kay awun pitu ya eseg na nyangugnan kanan.” ");
INSERT INTO klg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aw tyumubag si Jisus kanilan, “Adun na manga allaw yeiy, nyampangugnan ya manga utaw asini tas na lupa'. ");
INSERT INTO klg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Manang kagaya moli na allaw, dun ni kasakupan na Tyumanem, ya manga utaw na panmatawun lekat adti nyangkamatay, dili' da silan mangugnan. ");
INSERT INTO klg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aw dili' da silan matay, kasiling na manga anghil. Silan saba ya mangayse' na Tyumanem na pigmataw da. ");
INSERT INTO klg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pangkay ya pigsulat ni Moysis sa pagtawag kanan na Tyumanem lekat adti tagbi' na kawuy na lyumaga, dun nan bangala na mataw uman salut ya manga utaw. Miglong ya Tyumanem kan Moysis, ‘Aku ya Tyumanem ni Abraham aw ya Tyumanem ni Isa-ak aw ya Tyumanem ni Jakub.’ ");
INSERT INTO klg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yan ya kakawasan nan, pangkay nyatay da silan manang adti asdangan na Tyumanem kenne' na utaw pa silan aw gayed nilan pigsimba ya Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aw awun manga magpalna-uway sa Uldin na miglong, “Kay Magpalna-uway, madyaw saba ya tubag mu.” ");
INSERT INTO klg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aw wala' da silan paka-eles pag-usip kanan. ");
INSERT INTO klg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pagkatigkas yan, miglong si Jisus kanilan, “Ananga' silan gayed maglong na ya Kristu, yan ya buwadbuwad ni Dabid? ");
INSERT INTO klg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Si Dabid saba ya migsulat asini muna dun ni libru na Manga Salmo, law nan: ‘Miglong ya Tyumanem adti kanaken Pangulu: “Ingkud kaw apit adi kalintu ku ");
INSERT INTO klg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","menda' na mabus ku degen ya manga po-on mu aw alag ku silan betang adti salad na manga siki mu.” ’ ");
INSERT INTO klg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, dun da si Dabid paglong na ya Kristu yan ya kanan Pangulu. Yanagaw kun pigtawag ni Dabid ya Misiyas na ‘Pangulu’, pig-unu na Misiyas ya pagka-imo' buwadbuwad ni Dabid?” ");
INSERT INTO klg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aw sa talana pa migpakanyeg kanan ya madég na utaw, miglong si Jisus adti kanan manga umagakan, ");
INSERT INTO klg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Magpakatadeng kamu sa manga magpalna-uway sa Uldin. Magkalim silan magsut sa malawig na sa-ul. Aw magleya silan kun pagbasa͡an silan adti palingki. Aw dun uman ni manga sinagoga aw manga dakula' na pista, pagkaliman nilan ya mag-ingkud adti pag-ingkudan na manga utaw na dengganen. ");
INSERT INTO klg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Madugay silan magpanawagtawag pada kita-en na manga utaw, manang pig-agaw baling nilan ya ka-unan na manga balu. Ya manga utaw yeiy, to-o mabegat ya pa-emel-emel na Tyumanem kanilan.” ");
INSERT INTO klg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na, dun ni Témplo, talana ni Jisus migtandaw, kyinita' nan ya manga mayaman na mig-ulug sa kuwalta nilan adti uluganan. ");
INSERT INTO klg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aw kyinita' nan uman ya sambuk na ka͡ubayan na balu na wala' ya pagkamangan na mig-ulug sa duwa ya sinsilyo. ");
INSERT INTO klg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aw miglong si Jisus, “Matinaw saba ya un ku paglongun kamayu: Ya balu iyan pangkay wala' ya pagkamngan nan, manang dakula' pa ya kanan pig-atag kay sa kadég na utaw na nyatag sa kuwalta nilan. ");
INSERT INTO klg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay ya pig-atag nilan, sobla la olo' na kuwalta nilan, manang ya ka͡ubayan yeiy, pig-ubus nan pig-atag ya kadakula' na nyatagtun nan.” ");
INSERT INTO klg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na, awun manga utaw na migbalawbalaw sa kanenggeya na Témplo kay pigpakanenggeya͡an na manga batu aw eped pa na pig-atag na manga utaw adti Témplo. Yanagaw miglong si Jisus, ");
INSERT INTO klg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya kadég yeiy na kyinita' mayu adun, dumateng ya allaw na mabus magkalat. Pangkay ya manga mangkabakla' na batu na pig-ilantulantu, ya kadég yeiy alag saba mangkagettan.” ");
INSERT INTO klg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aw pig-usip nilan si Jisus, “Kay Magpalna-uway, kinunu katuman ya kadég na piglong mu kakayna? Unu ya pangilala na agpet da ma-imo' ya kadég yan?” ");
INSERT INTO klg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aw miglong si Jisus, “Magpakatadeng kamu pagaw pasuwayen kamu, kay awun madég na un dumateng na dumala sa kanak ngalan aw maglong silan, ‘Aku saba ya Kristu,’ aw maglong silan uman, ‘Dyumateng da ya allaw!’ Manang dili' kamu magka-agad-agad kanilan. ");
INSERT INTO klg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aw kun makadengeg kamu na awun manga dakula' na tanam aw pag-atu na manga utaw sa gubirnu, dili' kamu magkallek. Kay ya kadég yeiy ka-ilangan una ma-imo', manang beke' pa nan ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aw tigkas yan, miglong pa si Jisus kanilan, “Ya sambuk na nasud manubbuk sa eped na nasud, aw ya sambuk na kasakupan tumanam sa eped na kasakupan. ");
INSERT INTO klg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Awun dakula' to-o na manga linug aw getem adti madég na banwa, aw awun uman manga magkedel na magkalintapun na makamatay. Aw lekat adti langit, awun kita-en na manga kallekanan aw manga eped pa uman na pangilala. ");
INSERT INTO klg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Manang sa dili' pa dumateng ya kadakula' yeiy, dakepen kamu aw pamulayaman, aw pa-agad adti sinagoga pada limanda kamu nilan aw kalabusuwun. Aw pa-agad kamu nilan uman adti asdangan na manga hari' aw manga gubirnador. Ya kadég yeiy imo-un nilan kamayu asuntu sa pagpangintu-u mayu kanak. ");
INSERT INTO klg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aw dun da kamu pakaselat pagpa-ede' kanilan sa Madyaw na Ubat-ubat kanak. ");
INSERT INTO klg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sa dili' pa yeiy ma-imo', dili' magkakamang ya kamayu ginawa sa un mayu tubag kanilan, ");
INSERT INTO klg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kay aku saba ya mag-atag kamayu sa katadeng sa un mayu paglongun. Pangkay ya manga po-on mayu dili' nilan mabatug tubagen. ");
INSERT INTO klg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aw dun uman ni allaw yan, pangkay ya manga mangkatikadeng mayu, aw manga kaylug aw kadégan mayu aw ubaybay mayu, lubidan kamu nilan adti kamayu manga po-on. Aw patayen nilan ya eped kamayu. ");
INSERT INTO klg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Asuntu sa pagdalug mayu kanak, dumutan kamu na madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Manang dili' kamu magkallek kay tamengan kamu na Tyumanem aw pangkay ya sambuk na lugay mayu dili' malagak. ");
INSERT INTO klg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kun magpadeleg kamu sa pagpangintu-u kanak, matagtun mayu ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Manang kun kita-en mayu ya syudad na Jérusalim na pyalibedan da na to-o madég na manga sundalu, na, ka-ede-an mayu na malapit da kalaten ya syudad. ");
INSERT INTO klg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yanagaw, kamu na awun ni Judiya, maksay kamu palaguy adti manga buntud, aw kamu na asini ni syudad, maksay kamu luwa', aw ya kadég mayu adti manga pawa', dili' da kamu magseled adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kay yeiy ya manga allaw na pa-emel-emelen na Tyumanem ya Jérusalim pada matuman ya pigpasulat nan asini muna. ");
INSERT INTO klg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Makalalat ya manga ka͡ubayan na mabdes aw ya manga kalmukan dun ni manga allaw yan. Kay dumateng ya madég na kalugan asini tas na lupa', aw to-o malatay ya kagamakan na manga utaw yeiy asuntu sa kadaman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aw madég ya pamatayen magi sa kampilan, aw ya manga eped allangen adti madég na manga nasud. Aw ya syudad na Jérusalim, agawun na manga Héntil aw eya-an nilan taman na malingeb da ya piglong na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aw awun manga pangilala na kita-en dun ni sega aw bulan aw manga bitun. Aw ya manga utaw asini tas na lupa' to-o magkakamang ya ginawa nilan, aw mallek silan sa mangkabakla' na manga baled adti dagat. ");
INSERT INTO klg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Magpanteneb ya manga utaw sa kakallekan nilan sa un dumateng adti kadakula' na banwa. Kay ya manga bitun aw kadég na pagkita-en na adti langit alag magkatangkeg aw dili' da silan magi dun ni dadan na agiyanan nilan. ");
INSERT INTO klg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aw dun da nilan kita-a ni labun ya Ise' na Utaw na lumiku' na ka-agadan na dakula' na kalalamdag aw katulus na pagka Tyumanem nan. ");
INSERT INTO klg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, kun magpalekat da ya kadég yeiy, pakabagsega ya kamayu ginawa aw langad kamu adti langit kay malapit da ya pagpaluwa' kamayu.” ");
INSERT INTO klg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aw miglong si Jisus kanilan sa pundinganan: “Tanawa mayu ya kawuy na igira aw ya kadég uman na manga kawuy. ");
INSERT INTO klg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kun kita-en mayu na manalingsing aw dumawun da, ka-ede-an mayu na agpet da ya manga bulan na to-o mapasu'. ");
INSERT INTO klg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aw maynan uman, kun kita-en mayu ya kadég na piglong ku kamayu, ka-ede-an mayu na malapit da ya Paghari' na Tyumanem sa Kasakupan nan. ");
INSERT INTO klg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Matinaw ya un ku paglongun kamayu: Ya manga utaw asini tas na lupa' adun na allaw yeiy, dili' pa silan mabus mangkamatay menda' na magpalekat da ya kadég na piglong ku. ");
INSERT INTO klg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pangkay kun ma-uman ya langit aw ya kadakula' na banwa manang ya manga tingeg na piglong ku dili' saba ma-uman. ");
INSERT INTO klg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Migpadeleg si Jisus miglong, “Magpakatadeng kamu na dili' mayu ka͡agadan ya pagka-utawun mayu adti pagpa-eyang dun ni pagpamista aw pag-inem menda' na mangkalangulangu kamu aw sa pagkaypeng sa kamayu pag-eya'. Kay pagaw kabigla-an kamu ");
INSERT INTO klg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kasiling na iyalas na kyalitagan. Kay ya kadég na utaw na mig-eya' asini tas na lupa' kabigla-an saba silan dun ni manga allaw yan. ");
INSERT INTO klg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yanagaw gayed kamu pagtagilan sa kamayu pagka-utawun aw gayed kamu uman panawagtawag adti Tyumanem pada dili' kamu kaliputan na manga kalugan yeiy na un dumateng, aw mabatug mayu ya mindeg adti asdangan na Ise' na Utaw na wala' ya kamulamula.” ");
INSERT INTO klg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kada allaw migpalna-u si Jisus adti pamanag na Témplo, manang pagkagabi, magluwa' sakanan aw adtu maglagdeng ni Buntud na Manga Olibo. ");
INSERT INTO klg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aw sa to-o pa maselem, madég ya utaw na migkatipun adti Témplo na un magpakanyeg sa palna-u nan. ");
INSERT INTO klg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, agpet da ya allaw na Pista na Pan na Wala' Patulina na pigtawag uman na Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aw ya manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin na manga Judiyu, gayed silan nyaninaw sa pa-agi kun unun nilan ya pagpapatay kan Jisus, kay nyallek silan sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sa talana pa nilan migpalpa seiy, syumeled si Satanas adti kan Judas Iskariyoti na yan ya sambuk dun ni sampulu' tag duwa ya umagakan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aw nyadtu si Judas adti manga mangkatas na magdadugsu-ay aw manga kapitan na manga magtatunggu-ay dun ni Témplo. Aw pigbalawbalawan nilan kun unun nan ya pagtumbay kan Jisus adti kanilan. ");
INSERT INTO klg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aw to-o silan migleya, aw pigka-unawa͡an nilan na atagan si Judas na kuwalta. ");
INSERT INTO klg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yanagaw tyumande' si Judas aw tyumagad sa selat pada lubidan nan si Jisus adti kanilan na dili' ka-ede-an na madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, dyumateng da ya tagna' na allaw na Pista na Pan na Wala' Patulina. Yeiy ya allaw na magsi-iyaw ya manga Judiyu sa nati na karniro, kay yan ya un nilan kanen dun ni pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yanagaw pigsugu' ni Jisus si Pédro aw si Juan, law nan, “Kadtu kamu aw tagilana mayu kanaten ya pangiyambungay sa Pista na paglabay na Anghil na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aw pig-usip nilan si Jisus, “Ayin apit ya kaliman mu na magtagilan kami?” ");
INSERT INTO klg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aw tyumubag si Jisus, “Sa pagseled da mayu adti Jérusalim, sungunun kamu na sambuk na eseg na dyumala sa sibulan na nyatmu' na tubig. Agad kamu kanan adti balay na un nan kadtuwan. ");
INSERT INTO klg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aw paglonga mayu ya tagtun sa balay, ‘Nyamene' ya Magpalna-uway: Ayin kunu ya tambi' na un nan pagkanan sa pangiyambungay sa Pista eped nan ya kanan manga umagakan?’ ");
INSERT INTO klg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aw yanagaw pakita' nan kamayu ya dakula' na gibalayan adti kadwa na kansad na balay na dadan da pigtagilan. Aw dun da mayu tagilana ya pangiyambungay tadun.” ");
INSERT INTO klg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yanagaw nyanaw ya duwa na pigsugu' nan. Aw sa pagdateng nilan dun, kyinita' da nilan ya kadég na piglong ni Jisus, aw pigtagilan nilan ya pangiyambungay sa Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na, sa pagdateng da na udas na kuman da silan, nyingkud si Jisus eped na kanan umagakan dun ni lamisa pada kuman. ");
INSERT INTO klg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aw piglongan nan silan, “To-o ku kaliman sumambuk kamayu kuman sa pangiyambung ini sa Pista sa dili' pa aku magti-is. ");
INSERT INTO klg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aw paglongun ta kamu na dili' da aku kuman salut seiy menda' na malingeb ya kakawasan nan adti Kasakupan na Pighari-an na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aw migkamang si Jisus sa tabu' na pigseledan sa bino na paras aw pigpasalamatan nan adti Tyumanem, aw tigkas yan miglong sakanan, “Dawata mayu ya tabu' aw pagsayusayu kamu inem. ");
INSERT INTO klg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Paglongun ta kamu: Dili' da aku salut minem sa bino na paras menda' na dumateng ya Paghari' na Tyumanem sa Kasakupan nan.” ");
INSERT INTO klg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aw migkamang si Jisus sa pan aw pigpasalamatan nan adti Tyumanem. Pagkatigkas yan pigtenga-tenga' nan ya pan aw pigpan-atag nan adti kanan manga umagakan, aw law nan, “Yeiy ya kanak lawas na pig-atag kamayu. Kana la mayu, pada gayed aku mayu ka-anenganengan.” ");
INSERT INTO klg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aw maynan uman, pagkatigkas nilan mangiyambung, pigkamang nan ya tabu' na syeledan sa bino, aw law nan, “Yeiy ya kanak dugu' na pa-iligen pada kamayu. Magi sa dugu' ku, yan ya magpa-iganget sa bagu na pakang na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Manang pakanyegi mayu ya un ku paglongun: Awun eped tadun na kyuman asini lamisa na un maglubid kanak. ");
INSERT INTO klg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aku na Ise' na Utaw un saba patayen kay yan ya dadan pigpalpa na Tyumanem. Manang malatay ya un datengan na utaw na maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aw migpan-usip-usipay silan kun singalan kanilan ya maglubid kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, nya-imo' ya ayil na manga umagakan ni Jisus. Mig-ayil silan kun singalan ya to-o matas kanilan. ");
INSERT INTO klg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yanagaw miglong si Jisus adti kanilan, “Kya-ede-an da mayu ya bet na manga hari' na wala' pagpangintu-u sa Tyumanem. Silan da ya gayed migbaya' sa manga sakup nilan. Aw ya kaliman na manga mangkalangkaw nilan na magkadengganen silan kay silan gayed ya magtabang sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Manang dili' mayu silan pagsilingan. Ya to-o dakula' adti kamayu ka-ilangan masiling baling na to-o mangud. Aw ya magdumala, ka-ilangan masiling sakanan na sugu-anen. ");
INSERT INTO klg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Singalan ka' ya matas, ya pigbasa͡an sa kakan aw kun ya nyamasa kanan? Enda', yan saba ya matas ya pigbasa͡an? Manang ini aku saba na nyamasa kamayu.” ");
INSERT INTO klg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aw miglong pa uman si Jisus kanilan, “Kamu ya gayed mig-agad-agad kanak dun ni manga kalugan na kya-agiyan ku. ");
INSERT INTO klg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yanagaw, asuntu na pigtaliguwan aku na kanak Ama sa pagdumala sa kasakupan nan, taliguwan ta kamu uman kagaya sa kasakupan nan, ");
INSERT INTO klg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","pada magdengan kitadun kuman aw minem adti kanak lamisa dun ni kanak kasakupan. Aw mingkud kamu adti manga trunu aw magdumala kamu aw mag-ukum sa manga buwadbuwad na sampulu' tag duwa ya ise' ni Isra-él na eseg.” ");
INSERT INTO klg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tigkas yan, miglong si Jisus kan Pédro, “Kay Simon, pakanyegi ya un ku kanmu paglongun: Pigsekat ni Satanas na tanda-en ya kamayu pagpangintu-u. Ya pagtanda' nan kamayu kasiling na pagbulus sa umay pada matani ya tipig aw ya awun seled. ");
INSERT INTO klg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Manang nyanawagtawag aku na dili' mu ayawan ya pagpangintu-u mu. Aw sa pagpakaliku' da mu adi kanak, mabatug mu pakabagsegen ya pagpangintu-u na manga eped mu.” ");
INSERT INTO klg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aw miglong si Pédro kanan, “Kay Magpalna-uway, magad aku kanmu pangkay adti kalabusuwanan aw adti pagkamatay!” ");
INSERT INTO klg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Manang tyumubag si Jisus kanan, “Paglongun ta kaw, kay Pédro: Sa dili' pa tumaga-uk ya manuk kagaya na gabi, balyaw aku mu na makatlu.” ");
INSERT INTO klg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagkatigkas yan, miglong si Jisus kanilan, “Idtu na muna, sa pagsugu' ku kamayu, piglongan ta kamu na dili' kamu magdala sa pu-ut aw kabil aw manga sandal. Na, unu ka', migkapelek kamu?” Aw tyumubag silan, “Wala' saba.” ");
INSERT INTO klg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aw miglong pa si Jisus, “Manang adun, pangkay singalan kamayu ya awun pu-ut aw kabil, dala͡a la mayu. Aw pangkay singalan ya wala' ya kampilan, galinen nan ya kanan inabelan aw pagbayad nan sa kampilan. ");
INSERT INTO klg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kay ka-ilangan magi kanak matuman ya pigpasulat na Tyumanem asini muna: ‘Adti anenganeng na manga utaw, ribildi sakanan.’ Aw un da saba yeiy matuman.” ");
INSERT INTO klg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aw miglong ya manga umagakan nan, “Kay Magpalna-uway, tanawa! Awun duwa ya kampilan ini.” Aw tyumubag si Jisus, “Umba' da yan.” ");
INSERT INTO klg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aw lyumuwa' si Jisus adti balay aw nyanaw pasinan adti Buntud na Manga Olibo kay yeiy ya kanan kyanalaman. Aw nyagad uman ya manga umagakan nan. ");
INSERT INTO klg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aw sa pagdateng da nilan, miglong si Jisus, “Panawagtawag kamu pada dili' kamu degen na pagtanda'.” ");
INSERT INTO klg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aw migpa-awat si Jisus kanilan, aw lyumuhud sakanan aw nyanawagtawag, law nan, ");
INSERT INTO klg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Kay Ma', kun kaliman mu, kamanga beg kanak ya pagti-is na un ku ka-agiyan. Manang beke' na kanak pagkaliman ya matuman, kanmu saba pagkaliman ya matuman.” ");
INSERT INTO klg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na, migpakita' kan Jisus ya sambuk na anghil lekat adti tas na langit aw migpakabagseg kanan. ");
INSERT INTO klg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aw asuntu na to-o migkalat ya ginawa nan, nyatibulluk pa sakanan nyanawagtawag. Aw nyantagdu' adti lupa' ya init nan kasiling na dugu'. ");
INSERT INTO klg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatigkas nan manawagtawag, nyindeg sakanan aw lyumiku' adti manga umagakan nan aw kyinita' nan na nyampakatulug silan kay to-o migkalat ya ginawa nilan. ");
INSERT INTO klg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aw miglong si Jisus kanilan, “Ananga' kamu makatulug? Pagbangun kamu aw panawagtawag pada dili' kamu degen na pagtanda'.” ");
INSERT INTO klg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sa talana pa ni Jisus miglong, dyumateng ya madég na manga utaw. Aw ya nyuna kanilan si Judas Iskaryoti na sambuk dun ni sampulu' tag duwa ya umagakan ni Jisus. Dyumulud si Judas adti kan Jisus aw aleki nan, ");
INSERT INTO klg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","manang miglong si Jisus kanan, “Kay Judas, ananga' mu lubidan ya Ise' na Utaw magi sa alek?” ");
INSERT INTO klg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aw sa pagkita' na manga umagakan ni Jisus sa un ma-imo' kanan, miglong silan, “Kay Magpalna-uway, unu, pantibasen nami silan na kampilan?” ");
INSERT INTO klg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aw pigtibas na sambuk kanilan ya sugu-anen na pangulu na manga magdadugsu-ay, aw dayaw nya-ilap ya kalintu na talinga nan. ");
INSERT INTO klg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Manang pigsagda sakanan ni Jisus, “Umba' da yan!” Aw pig-uli' nan ya talinga na sugu-anen aw dayaw nyaka-uli'. ");
INSERT INTO klg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na, ya manga nyagad kan Judas na un magdakep kan Jisus, yan ya manga mangkatas na magdadugsu-ay, aw manga magtatunggu-ay sa Témplo, aw manga magdadumala͡ay sa manga Judiyu. Aw miglong si Jisus kanilan, “Ananga' kamu dumala sa manga kampilan aw manga babunal? Kasiling kamu na migdakep sa ribildi! ");
INSERT INTO klg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kada allaw awun aku ni Témplo, aw wala' aku mayu dakepa. Manang yeiy da saba ya kamayu selat, aw yeiy da uman ya pagdumala na kangitngit.” ");
INSERT INTO klg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pagkatigkas yan, pigdulus nilan si Jisus aw pigpa-agad adti balay na pangulu na manga magdadugsu-ay. Aw dyumalug uman si Pédro kanilan, manang migpa-awatawat sakanan. ");
INSERT INTO klg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Adti pamanag na balay, migduluk ya manga utaw aw nyan-ingkud silan dun pada manalang. Aw migpalapit uman si Pédro aw nyingkud adti tampid nilan. ");
INSERT INTO klg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aw awun sambuk na sugu-anen na bubay na kyumita' kanan na nyingkud dun, aw pigtengtengan nan si Pédro aw miglong, “Ya utaw ini sambuk uman na eped nan!” ");
INSERT INTO klg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Manang migbalyaw si Pédro, law nan, “Kay Dé', wala' ku kilala͡a ya utaw yan!” ");
INSERT INTO klg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wala' kadugay, awun da uman eseg na kyumita' kanan, aw law nan, “Ikaw uman ya sambuk na eped nilan.” Manang tyumubag si Pédro, “Beke' ku, kay Lew!” ");
INSERT INTO klg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lyumabay da ya sangka-udas aw miglong pa uman ya sambuk na utaw, “Ya eseg ini, eped nilan saba kay taga Galilya sakanan!” ");
INSERT INTO klg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Manang miglong si Pédro, “Kay Lew, wala' ku ka-ede-i ya piglong mu!” Sa talana pa nan miglong, tigkan tyumaga-uk ya manuk. ");
INSERT INTO klg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lyumingi' si Jisus aw pigtengtengan nan si Pédro. Aw dun da ni Pédro ka-anenganengi ya piglong kanan ni Jisus, “Sa dili' pa tumaga-uk ya manuk kagaya gabi, balyaw aku mu na makatlu.” ");
INSERT INTO klg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","To-o migkalat ya ginawa ni Pédro, yanagaw lyumuwa' sakanan aw to-o migsugaw. ");
INSERT INTO klg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na, ya manga migtunggu' kan Jisus, pig-odoy-odoy nilan sakanan aw pigpanumbag nilan. ");
INSERT INTO klg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aw pigtampeng nilan ya mata nan aw piglongan nilan, “Ubatan kanami kun singalan ya migsumbag kanmu!” ");
INSERT INTO klg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aw madég pa uman ya tingeg na piglong nilan na pagmulamula kanan. ");
INSERT INTO klg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na, pagkamaselem da, migkatipun ya manga magdadumala͡ay sa manga Judiyu, dala ya manga magdadugsu-ay, aw ya manga magpalna-uway sa Uldin. Aw tigkas yan, pigpa-agad nilan si Jisus adti pag-usayan nilan. ");
INSERT INTO klg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aw miglong silan kan Jisus, “Ubati kami kun ikaw ya Misiyas.” Manang tyumubag si Jisus kanilan, “Pangkay kun ubatan pa ta kamu, dili' aku mayu pangintu-uwan, ");
INSERT INTO klg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","aw kun usipen ta kamu, dili' kamu uman tumubag. ");
INSERT INTO klg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Manang agpet da ya allaw na mingkud ya Ise' na Utaw apit adti kalintu na Tyumanem na To-o Matulus.” ");
INSERT INTO klg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aw miglong ya kadég nilan, “Unu ka', ikaw kadi' ya Ise' na Tyumanem?” Aw tyumubag si Jisus kanilan, “Piglong da mayu saba.” ");
INSERT INTO klg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aw miglong silan, “Ananga' pa kitadun maninaw sa eped na un magmatinaw? Dyengeg da tadun saba ya kanan piglong.” ");
INSERT INTO klg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pagkatigkas yan, nyindeg ya kadég nilan aw pigpa-agad nilan si Jisus adti kan Pilato. ");
INSERT INTO klg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aw pigpalekat nilan ya paglimanda kanan, law nilan, “Ya utaw yeiy, kyinita' nami sakanan na migpasuway sa manga eped nami na Judiyu. Aw pigpalna-uwan nan silan na dili' matag sa buwis adti kan César. Aw miglong uman sakanan na yan kunu ya Kristu aw hari'.” ");
INSERT INTO klg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yangaw nyusip si Pilato kan Jisus, “Unu, ikaw ya hari' sa manga Judiyu?” Aw tyumubag si Jisus, “Piglong da mu.” ");
INSERT INTO klg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aw miglong si Pilato adti manga mangkatas na magdadugsu-ay aw kadég na manga utaw na miglimanda, “Wala' ya kyinita' ku na indeganan na limanda mayu ya utaw yeiy.” ");
INSERT INTO klg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Manang to-o silan gyumelgel, law nilan, “Gayed nyagubut ya manga utaw asini kadakula' na Judiya asuntu sa palna-u nan. Migpalekat sakanan adti Galilya, aw dyumateng da uman asini Jérusalim.” ");
INSERT INTO klg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagdengeg ni Pilato sa piglong nilan, nyusip sakanan kun taga Galilya si Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aw sa pagpaka-ede' nan na si Jisus taga Galilya sakup na pigdumala͡an ni Hérodés Antipas, pigpa-ated nan si Jisus adti kan Hérodés kay dun ni manga allaw yan awun sakanan ni Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sa pagkita' ni Hérodés kan Jisus, migleya sakanan kay madég ya pigdengeg ni Hérodés kanan aw kaliman nan kumita' sa milagru na imo-un ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yanagaw madég ya manga usip nan kan Jisus manang wala' nan tubaga. ");
INSERT INTO klg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ya manga mangkatas na magdadugsu-ay aw manga magpalna-uway sa Uldin na manga Judiyu dun uman silan, aw pangkay unu la ya manga piglimanda nilan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aw migpalekat si Hérodés aw manga sundalu nan mig-odoy-odoy kan Jisus, aw pigpasut nan na malawig na sa-ul na to-o manenggeya kasiling na kana hari'. Aw pigpaliku' nan adti kan Pilato. ");
INSERT INTO klg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, dun ni manga allaw yan migka-ubaybay da si Hérodés aw si Pilato, pangkay matalapo-on silan idtu muna. ");
INSERT INTO klg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na, pigpatawag ni Pilato ya manga mangkatas na magdadugsu-ay, aw manga magdadumala͡ay, aw ya eped pa na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aw miglong si Pilato kanilan, “Pigdala la mayu kanak ya utaw yeiy na pigdiklamu na migpasuway kunu sakanan sa manga utaw. Aw sa pagsadsad ku kanan dun ni asdangan mayu, wala' saba ya kyinita' ku na sala' nan na pigdiklamu mayu sakanan. ");
INSERT INTO klg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pangkay si Hérodés wala' uman ya kyinita' nan na sala' na utaw yeiy, yan ya du-an na pigpaliku' nan adi kanak. Yanagaw wala' ya nya-imo' nan na malatay na umba' sakanan patayen! ");
INSERT INTO klg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yanagaw palabet da ku olo' sakanan, tigkas yan paluwa-en.” ");
INSERT INTO klg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na, awun katanem na gubirnador na kada umay dun ni Pista na Paglabay na Anghil na Tyumanem, ka-ilangan magpaluwa' sakanan sa sambuk na nyakalabusu. ");
INSERT INTO klg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Manang nyamansag ya kadég na manga utaw, law nilan, “Pataya ya utaw yeiy! Aw paluwa-a kanami si Barabas!” ");
INSERT INTO klg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na, si Barabas pigkalabusu asuntu sa paggagad nan sa manga Judiyu na nyatu sa gubirnu na taga Roma dun ni Jérusalim, aw awun uman utaw na pigpatay nan. ");
INSERT INTO klg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kaliman ni Pilato paluwa-en si Jisus, yanagaw pig-usip pa nan uman ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Manang gayed silan nyamansag na miglong, “Pakalabuwan sakanan! Pakalabuwan sakanan adti krus!” ");
INSERT INTO klg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aw sa katlu la silan ni Pilato piglongan, law nan, “Ananga' ka'? Unu ya nya-imo' nan na malatay? Wala' saba ya kyinita' ku na pig-imo' nan na umba' patayen! Yanagaw palabet ku, aw tigkas yan paluwa-en ku sakanan.” ");
INSERT INTO klg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Manang to-o la baling silan nyamansag na pakalabu si Jisus adti krus. Aw pig-atag kanilan ya pigsekat nilan. ");
INSERT INTO klg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tyumande' da si Pilato kanilan na pakalabu si Jisus adti krus. ");
INSERT INTO klg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pigpaluwa' nan ya utaw na pigkalabusu asuntu sa pag-atu nan sa gubirnu aw pagpatay nan sa utaw. Manang si Jisus pigtumbay nan adti kanilan pada ma-imo' ya kaliman nilan imo-un adti kanan. ");
INSERT INTO klg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sa pagdala na manga sundalu kan Jisus adti luwa' na syudad na Jérusalim, pig-isungun nilan ya sambuk na eseg na si Simon na taga syudad na Ciréné, aw pigleges nilan pigpapisan kanan ya krus aw gyumuyud sakanan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na, awun madég to-o na manga utaw na dyumalug, aw awun uman manga ka͡ubayan dun na migpansisugaw kay migkalat ya ginawa nilan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Manang piglingi' silan ni Jisus aw piglongan nan silan, “Kamu na manga ka͡ubayan na asini Jérusalim, dili' aku mayu pagsugawan, manang yan baling ya sugawi ya kamayu pagka-utawun aw ya manga mangayse' mayu. ");
INSERT INTO klg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kay dumateng ya manga allaw na maglong ya manga utaw, ‘Madyaw ya kana manga ka͡ubayan na wala' paka-ise' aw wala' ka͡utawi aw wala' ya pigpasusu nilan na ise'.’ ");
INSERT INTO klg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dun ni manga allaw yan, paglongun na manga utaw ya manga buntud, ‘Gettani kami!’ Aw maglong silan uman adti manga kabuludan, ‘Tabuni kami!’ ");
INSERT INTO klg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kay kun pig-imo' nilan yeiy kanak na wala' ya sala', to-o pa dun ya imo-un nilan adti manga utaw na awun sala'.” ");
INSERT INTO klg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Awun uman duwa ya utaw na ribildi na pigpa-agad nilan na un patayen eped ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aw sa pagdateng nilan adti Banwa na Pesa' na Ulu, dun da nilan si Jisus kalabuwi adti krus aw duwa ya ribildi adti manga krus nilan, ya sambuk apit adti kalintu nan aw ya sambuk uman apit adti kawala. ");
INSERT INTO klg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aw miglong si Jisus, “Kay Ma', pasinsiyayi silan kay wala' nilan ka-ede-i kun unu ya pig-imo' nilan.” Aw migbunutbunut ya manga sundalu kun singalan kanilan ya makatagtun sa tagsambuksambuk na kadégkadég ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aw mig-indeg-indeg ya manga utaw migbantay sa kadég na nyangka-imo'. Manang ya manga magdadumala͡ay sa manga Judiyu, pig-odoy-odoy nilan sakanan, law nilan, “Mabatug nan tabangan ya manga eped. Na, tabangan nan galu uman ya kanan pagka-utawun kun yeiy ya Misiyas na pigpadala na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aw pig-odoy-odoy uman na manga sundalu talana nilan dyumulud kan Jisus na un pa-inemen na bino na malagsing, ");
INSERT INTO klg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aw miglong silan, “Kun ikaw ya Hari' na manga Judiyu, na, tabangi ya kanmu pagka-utawun!” ");
INSERT INTO klg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na, apit adti tas na ulu nan awun tabla na pigsulatan sa ini: “Yeiy ya Hari' na manga Judiyu.” ");
INSERT INTO klg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aw mig-odoy-odoy uman kan Jisus ya sambuk na ribildi na pigkalabuwan dun, law nan, “Enda', ikaw saba ya Kristu? Na! Tabangi ya kanmu pagka-utawun aw tabangi kami uman!” ");
INSERT INTO klg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Manang pigsagda sakanan na eped nan na ribildi na maglong, “Unu, wala' kaw kallek sa Tyumanem? Alag saba kitadun pig-ukuman na patayen. ");
INSERT INTO klg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kita duwa ya umba' ukuman kay yeiy ya tandan sa imo-unun nate' na malatay. Manang ya utaw ini wala' ya pig-imo' nan na malatay.” ");
INSERT INTO klg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aw miglong pa sakanan, “Kay Jisus, anenganenga aku dun ni allaw na maghari' da kaw.” ");
INSERT INTO klg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aw miglong si Jisus kanan, “Matinaw saba ya un ku paglongun kanmu, adun na allaw magad kaw kanak adti Para-iso.” ");
INSERT INTO klg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pagka-alas dosi la, migkangitngit ya banwa seled na tulungka udas, ");
INSERT INTO klg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","aw wala' silat ya sega. Aw nyakisay ya to-o madakmel na téla na pigsaliben na awun ni seled na Témplo, aw dayaw nyatenga' na duwa. ");
INSERT INTO klg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aw mig-ulangag si Jisus, “Kay Ma', tumbay ku kanmu ya kanak ispiritu!” Aw tigkas yan nyabugtu' ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na, pagkita' na kapitan na manga sundalu na migtunggu' kanan, pigdeyen nan ya Tyumanem, law nan, “Matinaw saba na wala' ya sala' na utaw yeiy!” ");
INSERT INTO klg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aw ya madég to-o na utaw na migkatipun migbantay, sa pagkita' nilan sa nyangka-imo', nyan-uli' silan na migpansibug sa kanilan aba kay migkalat ya ginawa nilan. ");
INSERT INTO klg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aw ya kadég na manga kyumilala kan Jisus dala ya manga ka͡ubayan na nyagad kanan lekat adti Galilya, kyinita' nilan uman adti mawatawat ya kadég na nya-imo'. ");
INSERT INTO klg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na, awun sambuk na utaw na si José na taga lunsud na Arimatiya sakup na Judiya. Sambuk sakanan na nyaka-akup adti matas na pag-usayan. Wala' ya pagsala' sa bet nan aw pagbasa͡an sakanan na manga utaw. ");
INSERT INTO klg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","To-o nan pigtagadan ya Paghari' na Tyumanem sa Kasakupan nan, aw wala' sakanan tande' sa pagbaya' na manga eped nan aw sa manga pigpan-imo' nilan kan Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ya utaw yeiy nyadtu ni kan Pilato aw pigsekat nan ya lawas ni Jisus. ");
INSERT INTO klg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagkatigkas yan, pigkamang nan ya lawas lekat adti krus aw pigbedbedan nan na téla na linum. Aw pigbetang nan dun ni ilib na pigkutkutan dadan adti kilid na pangpang na wala' pa kabetangi na lawas na utaw. ");
INSERT INTO klg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na, yan na allaw, yan da ya paggtagilan na manga utaw sa Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aw ya manga ka͡ubayan na nyagad kan Jisus lekat adti Galilya, dyumalug silan kan José aw pigtandawan nilan ya pagbetang sa lawas ni Jisus adti ilib na piglebengan. ");
INSERT INTO klg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagkatigkas yan, nyuli' silan aw migtagilan sa manga manimbo' aw lana na un pagdamus sa lawas ni Jisus. Manang sa pagdateng na Allaw na Paglagdeng, miglagdeng silan kay yan ya sugu' dun ni Uldin na pig-atag na Tyumanem kan Moysis. ");
INSERT INTO klg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pagkamaselem da na Linggo, pigkadtuwan na manga ka͡ubayan ya ilib na piglebengan kan Jisus. Aw pyandala nilan ya manga manimbo' na dadan da nilan pigtagilan. ");
INSERT INTO klg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aw sa pagdateng nilan dun, kyinita' nilan na nyaka-anggin da adti kilid ya dakula' na batu na pigtampeng sa baka' na ilib, ");
INSERT INTO klg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","manang sa pagseled da nilan, wala' ya kyinita' nilan dun na lawas. ");
INSERT INTO klg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aw sa talana pa nilan nyabelengbeleng sa nya-imo', bigla' nyaka-indeg adti sayid nilan ya duwa ya eseg, aw to-o masilang ya kadégkadég nilan. ");
INSERT INTO klg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aw to-o nyallek ya manga ka͡ubayan, yanagaw dyumukduk silan. Manang miglong ya duwa ya eseg, “Ananga' mayu paninawun ya nyataw asini piglebengan sa nyangkamatay? ");
INSERT INTO klg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wala' da sakanan asini! Nyataw da saba! Unu, kyalingawan da mayu kadi' ya piglong nan kamayu idtu muna sa kenne' pa nan adti Galilya? ");
INSERT INTO klg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Miglong sakanan na ka-ilangan na tumbay ya Ise' na Utaw adti manga utaw na makasasala', aw papatay nilan adti krus, manang pagkatlu na allaw matawun sakanan lekat adti nyangkamatay.” ");
INSERT INTO klg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aw kya-anenganengan na manga ka͡ubayan ya piglong ni Jisus idtu muna. ");
INSERT INTO klg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aw sa pagliku' da nilan lekat adti lebeng, pigdandan nilan ya kadég na kyinita' nilan adti sampulu' taggesya' ya umagakan nan aw adti manga eped pa. ");
INSERT INTO klg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na, ya manga ka͡ubayan na migdandan seiy adti manga apostolés, yan si Maria na taga Magdala, aw si Jo-ana, aw si Maria na ina ni Santiago, aw eped pa na manga ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sa pagdengeg na manga apostolés sa pigdandan nilan, wala' nilan pangintu-uwi. Iman nilan aw kasampetanen na pig-imo-imo' olo' na manga ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Manang si Pédro nyindeg aw dyumalagan pasinan adti ilib, aw gyumukung syumilib aw yan olo' ya kyinita' nan ya manga téla na linum na pigbedbed sa lawas ni Jisus. Yanagaw nyuli' sakanan na nyabelengbeleng sa nya-imo'. ");
INSERT INTO klg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dun ni allaw yan, awun duwa ya umagakan ni Jisus na nyanaw pasinan adti sambuk na baranggay na pigngalanan na Émaus, aw ya kawat nan lekat adti Jérusalim, sampulu' taggesya' ka kilomitro. ");
INSERT INTO klg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aw pigbalawbalawan nilan ya kadég na nyangka-imo'. ");
INSERT INTO klg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aw sa talana nilan migbalawbalaw, migpalapit si Jisus aw nyagad kanilan. ");
INSERT INTO klg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Manang wala' nilan sakanan kilala͡a kay wala' pa kanilan tumbayan ya pagkilala kanan. ");
INSERT INTO klg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aw miglong si Jisus kanilan, “Unu ya kamayu pigbalawbalawan talana mayu nyanaw?” Aw tyumeneng pa silan dagawdagaw aw to-o migkabegat ya gya nilan. ");
INSERT INTO klg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aw miglong ya sambuk kanilan na si Kliyopas, “Ikaw gya olo' ya lyumaba' adti Jérusalim na wala' paka-ede' sa nyangka-imo' adun na manga allaw yeiy!” ");
INSERT INTO klg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aw pig-usip silan ni Jisus, “Unu ka' ya nyangka-imo'?” Aw tyumubag silan kanan, “Ya nya-imo' saba adti kan Jisus na taga Nazarit! Propita sakanan na migpakita' sa katulus na Tyumanem adti manga utaw magi sa manga pigpan-imo' nan aw sa manga pigpalna-u nan. ");
INSERT INTO klg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Manang ya manga mangkatas na magdadugsu-ay dun ni Témplo, aw manga magdadumala͡ay, piglimanda nilan baling sakanan aw pigtumbay adti taga Roma pada ukuman aw pakalabu adti krus! ");
INSERT INTO klg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pig-iman nami na si Jisus ya magpaluwa' sa nasud na Isra-él. Manang katlu la baling na allaw adun lekat na pagkamatay nan. ");
INSERT INTO klg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aw awun pa uman nyakapabelengbeleng kanami. Kakayna na to-o pa maselem, ya manga ka͡ubayan na gayed nyagad kanami, pigkadtuwan nilan ya ilib na piglebengan sa lawas ni Jisus, ");
INSERT INTO klg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","manang wala' nilan kita-a ya lawas nan dun! Aw maksay silan lyumiku' adti kanami, aw mig-ubat-ubat na awun kunu migpakita' kanilan na manga anghil na miglong na nyataw da si Jisus! ");
INSERT INTO klg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pagkatigkas yan, awun pa uman manga eped nami na nyadtu ni ilib. Aw kyinita' nilan na matinaw ya piglong na manga ka͡ubayan. Wala' saba nilan kita-a ya lawas ni Jisus.” ");
INSERT INTO klg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pagkatigkas nilan magdandan yan, miglong si Jisus kanilan, “Tay sa kadugay na wala' pa mayu kalabeti. Ananga' malug adti kamayu ya pagpangintu-u sa pigsulat na manga propita? ");
INSERT INTO klg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Unu ka', wala' pa mayu ka-ede-i na ka-ilangan una pati-isen ya Kristu sa dili' pa liku' ya dengeg nan?” ");
INSERT INTO klg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aw pigpalabet ni Jisus kanilan ya kadég na pigpasulat sa pagka-utawun nan, lekat adti pigsulat ni Moysis aw ya manga propita. ");
INSERT INTO klg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na, sa malapit da silan adti baranggay na un nilan kadtuwan, iman nilan aw magpadeleg pa si Jisus adti panaw nan. ");
INSERT INTO klg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Manang to-o silan nyanginayu' kanan, law nilan, “Asini la kaw ni tampid nami kay ambung da to-o aw agpet da magabi.” Aw nyagad si Jisus syumeled adti balay. ");
INSERT INTO klg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aw sa un da silan kuman, kyumamang si Jisus sa pan aw pigpasalamatan nan adti Tyumanem. Aw tigkas yan, pigtenga-tenga' nan ya pan aw pig-atag nan kanilan. ");
INSERT INTO klg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aw kyabukasan ya anenganeng nilan aw pigkilala la nilan si Jisus, manang bigla' sakanan nyalanas dun ni pag-inunu nilan. ");
INSERT INTO klg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aw miglong silan, “Tamanta migkaga͡an ya ginawa tadun kakayna adti dalan dun ni pagpa-ede' nan kanaten sa pigpasulat na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aw dun ni udas yan, maksay silan lyumiku' adti Jérusalim. Aw dun da nilan kita-a ya sampulu' taggesya' ya umagakan ni Jisus aw ya manga eped nilan na migkatipun. ");
INSERT INTO klg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aw miglong ya kadég nilan adti duwa, “Nyataw da saba ya kanaten Magpalna-uway! Migpakita' sakanan adti kan Simon!” ");
INSERT INTO klg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aw tigkas yan, pig-ubat-ubat uman na duwa adti manga eped nilan ya nya-imo' dun ni dalan pasinan adti Émaus, aw ya pagpakilala kanilan ni Jisus dun ni pagtenga' nan sa pan. ");
INSERT INTO klg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aw sa talana pa nilan migbalawbalaw sa kadég na nya-imo', bigla' migpakita' si Jisus dun ni tenga' nilan aw miglong, “Ya kalinaw gayed magad kamayu!” ");
INSERT INTO klg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Manang migteneb silan aw to-o nyallek kay iman nilan aw kalaluwa ya kyinita' nilan. ");
INSERT INTO klg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aw miglong si Jisus kanilan, “Ananga' kamu mallek? Ananga' magduwaduwa ya kamayu anenganeng? ");
INSERT INTO klg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inunuwa mayu ya manga palad ku aw kanak manga siki! Awidi aku mayu aw ka-ede-an mayu na beke' aku saba na kalaluwa, kay ya kalaluwa wala' ya pesa' aw wala' ya unud.” ");
INSERT INTO klg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aw pigpakita' nan kanilan ya manga palad nan aw siki nan. ");
INSERT INTO klg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pangkay to-o silan migleya aw nya-enneng-enneng, manang kenne' na malug kanilan ya pagpangintu-u sa kyinita' nilan. Yanagaw pig-usip silan ni Jisus, “Unu, awun pa kakan mayu asini?” ");
INSERT INTO klg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aw pig-atagan nilan sakanan na isda' na abus da pasagi, ");
INSERT INTO klg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aw pigdawat nan aw pigkan nan dun ni asdangan nilan. ");
INSERT INTO klg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pagkatigkas yan, miglong si Jisus kanilan, “Idtu na migka-iyeped pa kitadun, yeiy ya piglong ku kamayu: Ka-ilangan matuman ya kadég na pigsulat sa pagkadi ku, dala ya pigsulat dun ni Uldin na pig-atag na Tyumanem kan Moysis, aw ya pigsulat na manga propita aw dun ni Manga Salmo.” ");
INSERT INTO klg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aw pigbukasan ni Jisus ya kanilan anenganeng pada kalabetan nilan ya pigpasulat na Tyumanem, ");
INSERT INTO klg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","aw miglong sakanan kanilan, “Ini saba ya pigpasulat asini muna: ‘Ka-ilangan magti-is ya Kristu aw dun ni katlu na allaw mataw sakanan lekat adti pagkamatay.’ ");
INSERT INTO klg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aw dun ni kanak ngalan ka-ilangan ubat-ubat adti kadég na manga nasud na kun magselsel ya manga utaw sa kanilan manga sala', lanasen saba na Tyumanem ya kadég na sala' nilan. Aw ya pag-ubat-ubat yeiy, magpalekat asini Jérusalim. ");
INSERT INTO klg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aw kamu ya magmatinaw adti kadég na manga utaw sa manga nyangka-imo'. ");
INSERT INTO klg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pakanyegi mayu ya un ku paglongun: Un ku padala kamayu ya pigpakang na kanak Ama, manang katingen pa kamu asini Jérusalim menda' na madawat mayu ya katulus na lekat adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagkatigkas yan, pigpa-agad silan ni Jisus adti Bétaniya. Pagdateng nilan dun, pigpatas nan ya kanan manga tullu' aw migsekat adti Tyumanem na atagan silan na manga kadyawan. ");
INSERT INTO klg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Talana pa nan nyanawagtawag, maya-maya' sakanan nya-engat lekat dun ni tampid nilan pasinan adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aw pigsimba nilan sakanan aw lyumiku' silan adti Jérusalim na to-o migleya. ");
INSERT INTO klg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aw kada allaw adti Témplo, gayed nilan pigdeyen ya Tyumanem.");
INSERT INTO klg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asini muna sa wala' pa na Tyumanem imo-a ya kadakula' na banwa, awun da gayed ya Tingeg. Aw ya Tingeg, dun da sakanan gayed ni Tyumanem. Aw ya Tingeg, Tyumanem saba sakanan. ");
INSERT INTO klg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Awun saba sakanan gayed ni Tyumanem lekat pa asini muna. ");
INSERT INTO klg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Magi kanan pig-imo' na Tyumanem ya kadakula'. Kun wala' ya Tingeg, wala' ya nya-imo' pangkay sambuk. ");
INSERT INTO klg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yan ya lyekatan sa ginawa. Aw ya ginawa yeiy, kasiling na dakula' na saleng na mag-atag sa kalalamdag adti kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ya kalalamdag yeiy, yan ya nyaka-ilaw sa kadég na awun ni mangitngit, aw dili' mabatug na kangitngit degen ya kalalamdag. ");
INSERT INTO klg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, awun sambuk na utaw na pigsugu' na Tyumanem. Ya ngalan nan si Juan. ");
INSERT INTO klg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aw yan ya pigpa-una na Tyumanem na un magmatinaw kun singalan ya kalalamdag yeiy, pada magi sa pagmatinaw nan, mangintu-u ya kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Beke' ni Juan ya kalalamdag manang yan ya magmatinaw kun singalan ya kalalamdag. ");
INSERT INTO klg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si Jisus, yan ya tengteng kalalamdag na nyadi asini tas na lupa' na un mag-ilaw sa anenganeng na kadég na utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aw pangkay nyeya' sakanan asini lupa' aw magi kanan nya-imo' ya kadakula' na banwa, manang wala' sakanan kilala͡a na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aw pangkay pigkadiyan nan ya kanan manga kadégan na manga Judiyu, manang madég kanilan ya wala' dawat kanan. ");
INSERT INTO klg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Manang ya kadég na dumawat aw mangintu-u kanan, imo-un nan silan manga mangayse' na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aw ya pagka-imo' nilan mangayse' nan, dili' kasiling na utaw mag-ise', aw dili' uman asuntu sa pagkaliman na mangkatikadeng. Manang yan baling ya pagbaya' na Tyumanem na ma-imo' silan mangayse' nan. ");
INSERT INTO klg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aw ya Tingeg yeiy, nya-imo' sakanan utaw aw nyeya' asini eped tadun. Nyatmu' sakanan na kallat, aw alag matinaw ya piglong nan. Aw kyinita' nami ya kadyaw na Tyumanem dun ni kanan Ise' na tamisa. ");
INSERT INTO klg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aw si Juan na Magba͡utismuway ya migmatinaw kanan adti manga utaw magi sa mabagseg na tingeg, law nan: “Yeiy ya utaw na pig-ubat-ubat ku kamayu na un dumateng na matas pa kanak. Kay dun da sakanan dadan sa wala' pa aku ka͡utaw!” ");
INSERT INTO klg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Asuntu sa kadakula' na kallat ni Jisus, gayed kitadun kya-untungan sa manga kadyawan aw migpadeleg na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kay asini muna, pig-atag na Tyumanem ya kanan Uldin adti manga Judiyu magi kan Moysis. Manang adun, magi kan Jisu-Kristu pigpakita' nan ya kanan grasya aw katinawan. ");
INSERT INTO klg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wala' ya utaw na kyumita' sa Tyumanem. Yan olo' ya kyumita' kanan ya kanan Ise' na tamisa. Aw yan ya migpa-ede' adti kadég tadun sa Ama nan kay gayed silan mig-iyeped. ");
INSERT INTO klg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, ya manga magdadumala͡ay sa manga Judiyu adti Jérusalim, migsugu' silan sa manga magdadugsu-ay aw manga buwadbuwad ni Libi adti kan Juan, pada usipen nilan kun singalan sakanan. ");
INSERT INTO klg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aw wala' nan kanilan tagu-a ya matinaw, law nan, “Beke' ku saba ya Misiyas na kamayu pigtagadan!” ");
INSERT INTO klg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nyusip pa silan kanan, “Na, kun beke' mu ya Misiyas, singalan kaw saba? Unu, ikaw si Éliyas?” Aw miglong si Juan, “Beke' aku ni Éliyas!” Tigkas yan, nyusip pa uman silan kanan, “Ikaw kadi' ya Propita na pigtagadan nami?” Manang tyumubag si Juan kanilan, “Beke' ku uman ya Propita!” ");
INSERT INTO klg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aw miglong silan, “Ubatan kanami ya tengteng na matinaw kun singalan kaw pada awun ma-ubat-ubat nami adti manga migsugu' kanami! Na, unu ya mapaglong mu sa kanmu pagka-utawun?” ");
INSERT INTO klg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aw tyumubag si Juan kanilan, “Aku saba ya magtatawag dun ni kaligbinan na pyalabet ni Propita Isayas asini muna. Aw yeiy ya paglongun ku: ‘Pakadyawa mayu ya dalan na un agiyan na kanaten Tyumanem!’ ” ");
INSERT INTO klg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, ya manga migsugu' sa manga utaw na nyusip kan Juan, yan ya manga Parisiyo. ");
INSERT INTO klg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aw nyusip pa silan kanan, “Kun beke' mu ya Misiyas, aw beke' mu uman si Éliyas, aw beke' mu uman ya Propita na kanami pigtagadan, na, ananga' kaw magba͡utismu sa manga utaw?” ");
INSERT INTO klg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aw tyumubag si Juan kanilan, “Migba͡utismu aku sa manga utaw magi sa tubig, manang awun sambuk na nyindeg adun asini sayid tadun na wala' pa mayu kilala͡a. ");
INSERT INTO klg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nyakamoli sakanan kanak aw matas pa sakanan kanaken, aw dili' aku makatumbuk kanan. Pangkay ya pag-ubad sa eket na sandal nan dili' aku umba'.” ");
INSERT INTO klg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na, nya-imo' ya kadég yeiy adti baranggay na Bétaniya apit adti silatan na tubig na Jordan na pigba͡utismuwan ni Juan sa manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na, pagkasalut na allaw, pigkita' ni Juan si Jisus na migpasinan adti kanan, aw piglongan ni Juan ya manga utaw, “Tandawi mayu! Iyan da ya Nati na Karniro na Tyumanem na un pagdugsu' pada lanasen ya sala' na manga utaw! ");
INSERT INTO klg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yan saba ya utaw na piglong ku kamayu na un dumateng. Matas pa sakanan kanak, kay dun da sakanan dadan sa wala' pa aku ka͡utaw. ");
INSERT INTO klg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Idtu muna, pangkay wala' ku kilala͡a kun singalan sakanan, manang nyadi aku ni tubig na un magba͡utismu sa manga utaw pada kilala͡en sakanan na manga taga Isra-él. ");
INSERT INTO klg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Makamatinaw aku kay kyinita' ku ya Ispiritu Santo lekat adti tas na langit kasiling na kalupati na lyumugsad aw nyatingen adti kanan. ");
INSERT INTO klg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Idtu muna pangkay wala' ku sakanan kilala͡a, manang dun ni pagsugu' kanak na Tyumanem magba͡utismu, miglong sakanan dadan kanaken, ‘Kun kita-en mu ya kanak Ispiritu na lumugsad adti sambuk na utaw aw matingen adti kanan, yan ya utaw na un magba͡utismu magi sa Ispiritu Santo.’ ");
INSERT INTO klg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kyinita' ku saba alag ya kadég yeiy, yanagaw pigmatinaw ku sakanan na yan ya Ise' na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagkasalut na allaw, lyumiku' da uman si Juan adti tubig na Jordan eped nan ya duwa ya kanan umagakan. ");
INSERT INTO klg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aw sa pagkita' nan na lyumabay si Jisus kanilan, miglong si Juan, “Inunuwa! Iyan da saba ya Nati na Karniro na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aw sa pagdengeg na duwa ya umagakan ni Juan sa piglong nan, maksay silan dyumalug kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paglingi' ni Jisus, kyinita' nan silan na dyumalug kanan. Yanagaw pig-usip nan silan, “Unu ya pyaninaw mayu?” Aw miglong silan kanan, “Kay Rabbi, ayin ya balay na pigbantukan mu?” Na, ya kakawasan na tingeg ‘Rabbi’: Magpalna-uway. ");
INSERT INTO klg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aw piglongan silan ni Jisus, “Agad kamu aw tanawa ya kanak pigbantukan.” Yanagaw nyagad silan kanan. Na, manga alas kuwatru la na ambung ya pagdateng nilan adti pigbantukan nan, yanagaw nyatingen pa silan dun menda' na maselem. ");
INSERT INTO klg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na, ya sambuk na dyumengeg sa piglong ni Juan aw nyagad kan Jisus adti byantukan nan, yan si Andrés na inulug ni Simon Pédro. ");
INSERT INTO klg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pagkamaselem da, pyaninaw ni Andrés si Simon aw piglongan nan, “Kay Lew! Pigkita' da nami ya Misiyas!” Na, ya kakawasan na Misiyas, yan ya Kristu. ");
INSERT INTO klg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aw pigpa-agad nan si Simon adti kan Jisus. Pagdateng nilan dun, pigtengtengan ni Jisus si Simon aw law nan, “Ikaw si Simon na ise' ni Juan! Aw lekat adun, ngalanan da kaw na Kipas.” Na, ya Kipas aw ya Pédro, sambuk da ya kakawasan: batu. ");
INSERT INTO klg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagkasalut na allaw, yan ya pagbaya' ni Jisus na madtu ni probinsya na Galilya. Kyinita' nan si Pilipi aw piglongan nan sakanan, “Agad kaw kanak.” ");
INSERT INTO klg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na, taga lunsud na Bétsayda si Pilipi aw yan uman ya lunsud na pig-eya-an ni Andrés aw ni Pédro. ");
INSERT INTO klg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aw pyaninaw ni Pilipi si Natanyél aw piglongan nan, “Kay Lew, kyinita' da nami ya utaw na pigsulat ni Moysis adti Uldin, aw pigsulat uman na manga propita asini muna! Yan saba si Jisus na taga Nazarit na ise' ni José!” ");
INSERT INTO klg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aw miglong si Natanyél, “Unu, awun ka' madyaw na lyumekat adti Nazarit?” Manang tyumubag si Pilipi kanan, “Agad kaw kanak aw tanawa!” ");
INSERT INTO klg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sa pagkita' ni Jisus kan Natanyél na migpasinan adti kanan, miglong si Jisus, “Inunuwa! Yan ya tengteng utaw na Isra-él aw dili' sakanan magpan-akal.” ");
INSERT INTO klg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aw nyusip si Natanyél kanan, “Pig-unu mu ya pagpaka-ede' sa bet ku?” Aw tyumubag si Jisus kanan, “Sa wala' pa kaw tawaga ni Pilipi, kyinita' da ta kaw dun ni dalem na kawuy na igira.” ");
INSERT INTO klg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aw miglong si Natanyél, “Kay Magpalna-uway, ikaw saba ya Ise' na Tyumanem! Ikaw ya Hari' sa manga utaw na Isra-él!” ");
INSERT INTO klg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aw miglong si Jisus kanan, “Unu, nyangintu-u la kaw kanak asuntu na miglong aku kanmu na kyinita' da ta kaw dadan adti dalem na kawuy na igira? To-o pa yan dun ya kita-en mu kagaya.” ");
INSERT INTO klg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aw miglong si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Dumateng ya allaw na mabeka' ya langit aw kita-en mayu ya manga anghil na Tyumanem na uman manog pasinan adti tampid na Ise' na Utaw aw uman manik adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na, paglabay da na duwangallaw, awun kasal adti baranggay na Cana sakup na probinsya na Galilya. Aw nyadtu ya ina ni Jisus, ");
INSERT INTO klg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","aw si Jisus sambuk uman na pyamilit aw ya kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sa pagka͡abus da na bino, miglong kan Jisus ya ina nan, “Nyabus da ya bino nilan.” ");
INSERT INTO klg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aw miglong si Jisus kanan, “Kay Ne', ananga' kaw maglong adi kanak na nyabus da ya bino nilan? Wala' pa saba dateng ya allaw na pakita' ku ya kanak katulus adti manga utaw.” ");
INSERT INTO klg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Manang miglong ya ina nan adti manga sugu-anen dun ni kasal, “Imo-a mayu ya pangkay unu ya paglongun nan kamayu.” ");
INSERT INTO klg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, dun ni balay yan, awun enem ya mangkabakla' na betanganan sa tubig na pag-unaw na manga Judiyu sa dili' pa silan kuman kay yan ya kanilan katanem. Ya manga betanganan yeiy alag batu, aw kun magpangkatmu' da, ya seled na tagsambuk kanilan tag kaluwan kun beke' yan katluwan ka galun. ");
INSERT INTO klg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aw miglong si Jisus adti manga sugu-anen, “Pan-atmu-a mayu na tubig ya manga betanganan ini.” Aw dayaw nilan pigpan-atmu' ya kadég na manga betanganan. ");
INSERT INTO klg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkatigkas yan, miglong si Jisus kanilan, “Na! Sagad da kamu aw dala͡a adti pigsaligan sa pista.” Aw syumagad silan aw pigdala nilan adti pigsaligan. ");
INSERT INTO klg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aw pigtémtéman nan ya tubig na nya-imo' da bino, manang wala' nan ka-ede-i kun ayin lekat ya bino yeiy. Yan olo' ya nyaka-ede' ya manga sugu-anen na syumagad. Yanagaw pigpatawag na pigsaligan ya eseg na bagu nyangugnan ");
INSERT INTO klg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aw piglongan nan, “Ya katanem tadun pagpa-inem una ya madyaw na bino, aw kun dakula' da ya ma-inem nilan, bagu la uman pa-inem ya dili' to-o madyaw. Manang ikaw, bagu mu baling adun paluwa-en ya to-o madyaw na bino.” ");
INSERT INTO klg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeiy ya nya-imo' adti Cana, probinsya na Galilya aw yan ya tagna' na milagru na pig-imo' ni Jisus adti asdangan na manga utaw. Aw magi sa milagru yeiy, dun kita-a ni kanan ya katulus na pagka Tyumanem nan. Aw nyangintu-u kanan ya manga umagakan nan. ");
INSERT INTO klg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatigkas yan, tyumubang si Jisus pasinan adti lunsud na Kapirna-um eped nan ya kanan ina aw manga mangkangud nan, aw manga umagakan nan. Aw nyatingen pa silan dun seled na pilangallaw. ");
INSERT INTO klg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na, ya Pista na Paglabay na Anghil na Tyumanem un da magpalekat. Aw madég ya manga Judiyu na nyadtu ni Jérusalim aw nyadtu uman si Jisus na un tumambung sa pista. ");
INSERT INTO klg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdateng nan dun, syumeled sakanan adti dakula' na pamanag na Témplo. Aw pigkita' nan na awun manga utaw na migbaligya' sa manga baka aw karniro aw kalupati. Aw kyinita' nan uman ya manga maglaliwanay sa kuwalta dun ni manga lamisa nilan. ");
INSERT INTO klg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yanagaw mig-imo' si Jisus sa lalabet na lubid, aw pigpalekat nan ya pag-alilin kanilan. Pig-alaw nan uman ya manga karniro aw manga baka pasinan adti luwa' na pamanag na Témplo. Pigpambélét nan ya kuwalta aw pigpantuwad nan ya manga lamisa. ");
INSERT INTO klg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aw piglongan nan ya manga mamaligya-ay sa kalupati, “Kamanga mayu ya kadég yeiy! Ya-i mayu pag-imo-a baligya-anan ya balay na kanaken Ama!” ");
INSERT INTO klg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aw kya-anenganengan na manga umagakan nan ya pigpasulat na Tyumanem asini muna: “Asuntu na dakula' ya ginawa ku sa Balay na Tyumanem, yeiy saba ya un dumala kanak adti pagkamatay.” ");
INSERT INTO klg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na, sa pagkita' na manga magdadumala͡ay sa manga Judiyu sa pig-imo' nan, pig-usip nilan si Jisus, “Unu ya un mu kanami pakita' na pangilala na magmatinaw na awun katundanan mu mag-imo' seiy?” ");
INSERT INTO klg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aw tyumubag si Jisus kanilan, “Agba-a mayu ya Témplo ini aw seled na tulungallaw pa-indegen ku salut.” ");
INSERT INTO klg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aw tyumubag silan, “Ya Témplo ini, pig-imo' na manga panday seled na kapatan tag enem ya umay, aw seled olo' na tulungallaw pa-indegen mu salut?” ");
INSERT INTO klg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Manang ya pigpalabet ni Jisus na Témplo, yan ya kanan lawas. ");
INSERT INTO klg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yanagaw adti moli na allaw na nyataw sakanan lekat adti pagkamatay, kya-anenganengan na manga umagakan nan ya piglong nan idtu muna, aw pyangintu-uwan nilan ya pigpasulat dadan na Tyumanem asini muna aw ya manga piglong ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, sa adtu pa si Jisus ni Jérusalim dun ni manga allaw na Pista na Paglabay na Anghil na Tyumanem, madég ya nyangintu-u kanan kay kyinita' nilan ya manga milagru na pigpan-imo' nan. ");
INSERT INTO klg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Manang wala' si Jisus salig sa pagpangintu-u nilan kanan, kay kya-ede-an nan ya kadég na awun ni anenganeng nilan. ");
INSERT INTO klg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aw wala' uman ya du-an na pa-ede' kanan ya bet na manga utaw kay kya-ede-an da nan dadan silan. ");
INSERT INTO klg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na, awun utaw na Parisiyo na pigngalanan na si Nikodimo, aw sambuk uman sakanan na magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sambuk na gabi, nyadtu sakanan ni sayid ni Jisus aw piglongan nan, “Kay Magpalna-uway, kya-ede-an nami na sambuk kaw na magpalna-uway na pigpadala na Tyumanem. Kay awun manga milagru na pigpan-imo' mu na dili' mabatug na utaw kun wala' ya Tyumanem dun ni kanan.” ");
INSERT INTO klg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tyumubag si Jisus kanan, “Matinaw ya un ku paglongun kanmu: Dili' mabatug na utaw kita-en ya Kasakupan na Pighari-an na Tyumanem kun dili' una sakanan mabagu.” ");
INSERT INTO klg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aw nyusip si Nikodimo kanan, “Unu ya imo-un na utaw pada mabagu ya kanan pagka-utawun? Kun unud da ya ginawa nan, unun nan ya pagliku' aw pagseled adti buntit na ina nan pada ma͡utaw salut?” ");
INSERT INTO klg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aw tyumubag si Jisus kanan, “Matinaw saba ya un ku kanmu paglongun: Wala' ya utaw na makaseled adti Kasakupan na Pighari-an na Tyumanem kun dili' sakanan una mabagu magi sa tubig aw Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kay ya pig-ise' na utaw, utaw saba na awun sala', aw ya utaw na pigbagu na Ispiritu, pig-atagan saba sakanan na bagu na pagka-utawun. ");
INSERT INTO klg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dili' kaw magkabelengbeleng sa piglong ku kanmu na ka-ilangan ya kadég mayu mabagu. ");
INSERT INTO klg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ya samet tumambel pangkay ayin pasinan, aw dengegen tadun ya pagtambel nan manang dili' tadun ka-ede-an kun ayin lekat aw ayin uman pasinan. Kasiling uman na maynan, dili' ka-ede-an kun pig-unu na Ispiritu Santo ya pagbagu sa utaw.” ");
INSERT INTO klg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aw nyusip pa uman si Nikodimo, “Unu ya pagkabatug na kadég yeiy?” ");
INSERT INTO klg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tyumubag si Jisus kanan, “Sambuk kaw saba na pigkilala na magpalna-uway sa Uldin asini banwa na Isra-él. Ananga' wala' mu ka-ede-i ya kadég yeiy? ");
INSERT INTO klg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Matinaw saba ya un ku kanmu paglongun: Pig-ubat nami ya kanami kya-ede-an aw pigmatinaw nami ya kanami kyinita', manang wala' mayu dawata. ");
INSERT INTO klg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kun wala' kamu pangintu-u sa piglong ku sa asini tas na lupa', unun mayu ya pagpangintu-u kun ubat ku kamayu ya adti tas na langit? ");
INSERT INTO klg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wala' ya utaw na nyaka-ede' kun unu ya adti tas na langit kay wala' ya utaw na nyakakadtu. Yan olo' ya nyaka-ede' ya Ise' na Utaw kay lyumekat sakanan adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ya un ma-imo' kanaken, kasiling na nya-imo' sa inutaw na kamugung na galang na pigbetang ni Moysis adti aligi na pigpa-indeg nan adti kaligbinan, pada kita-en na manga utaw aw mataw silan. Ka-ilangan maynan uman ya ma-imo' sa Ise' na Utaw, un sakanan pakalabu adti krus, ");
INSERT INTO klg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pada pangkay singalan ya mangintu-u kanan, makatagtun sa ginawa na wala' ya katigkasan.” Yeiy ya piglong ni Jisus adti kan Nikodimo. ");
INSERT INTO klg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pigginawa͡an to-o na Tyumanem ya kadég na manga utaw, aw yan ya du-an na pig-atag nan ya kanan Ise' na tamisa pada pangkay singalan ya gayed mangintu-u kanan dili' ka-eletan lekat adti Tyumanem aw dili' sakanan pa-emel-emelen, manang makatagtun baling sa ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay ya pagpadala na Tyumanem sa Ise' nan asini tas na lupa', beke' na kaliman nan na ukuman ya manga utaw asuntu sa manga sala' nilan, manang yan ya tud nan na paluwa-en silan magi sa Ise' nan. ");
INSERT INTO klg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yanagaw, pangkay singalan ya mangintu-u kanan, dili' saba pa-emel-emelen. Manang pangkay singalan ya dili' mangintu-u kanan, pig-ukuman da sakanan kay wala' nan pangintu-uwi na yan ya Ise' na Tyumanem na tamisa. ");
INSERT INTO klg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ini ya du-an na un silan ukuman: Dyumateng ya kalalamdag asini tas na lupa' na un mag-ilaw sa anenganeng na manga utaw. Manang yan baling ya pigginawa͡an nilan ya kangitngitan aw beke' na kalalamdag kay malatay ya manga imo-unun nilan. ");
INSERT INTO klg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kay ya kadég na manga utaw na gayed mig-imo' sa malatay, pigkele͡an nilan ya kalalamdag pagaw kabukasan ya imo-unun nilan na malatay. ");
INSERT INTO klg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Manang ya manga utaw na gayed dyumalug sa tengteng matinaw, kaliman nilan magpalapit adti kalalamdag, pada kita-en ya manga imo-unun nilan na madyaw kay nyabatug nilan yeiy magi sa tabang na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatigkas yan, nyadtu si Jisus aw manga umagakan nan ni probinsiya na Judiya. Aw sa talana pa nilan dun, pigba͡utismuwan nilan ya manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aw si Juan uman migba͡utismu adti Énun malapit adti lunsud na Salim kay madég ya tugbul na tubig aw manga linaw dun ni banwa yan. Aw madég ya nyangkadtu adti kanan na un magpaba͡utismu, ");
INSERT INTO klg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","kay dun ni manga allaw yan, wala' pa kalabusuwa si Juan. ");
INSERT INTO klg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na, migbalawbalaw ya sambuk na Judiyu aw manga umagakan ni Juan, aw pigbilingbilingan nilan ya katanem na paglinis na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yanagaw nyadtu silan ni kan Juan aw pig-usip nilan sakanan, “Kay Rabbi, kya-anenganengan mu ya utaw na pigpakilala mu kanami adti dipag na Jordan? Migba͡utismu la uman sakanan! Tanawa! Nyadtu la baling ni kanan ya kadég na manga utaw!” ");
INSERT INTO klg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Manang tyumubag si Juan kanilan, “Wala' ya un mabatug na utaw pangkay sambuk kun dili' tumbay na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamu saba ya makamatinaw sa pigpa-ede' ku idtu muna na beke' ku ya Kristu manang pigsugu' aku olo' na Tyumanem na muna kanan pada ubat-ubat ku ya kanan pagdateng. ");
INSERT INTO klg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kasiling na awun pigkasal, yan olo' ya tagtun sa pangubayanen ya eseg nan. Manang ya ubaybay na pigpamalli' na pangesegenen na migtagad kanan, to-o magleya sa pagdengeg nan na dyumateng da ya pangesegenen. Yanagaw aku uman, to-o aku migleya asuntu na nyangkadtu la ya manga utaw adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ka-ilangan na magkatas to-o ya kanan dengeg aw ka-ilangan na dili' da aku sa kanak magkadengganen.” Yeiy ya piglong ni Juan na Magba͡utismuway. ");
INSERT INTO klg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ya utaw asini tas na lupa', yan olo' ya pigkasampetan nan ya asini tas na lupa'. Manang ya lyumekat adti tas na langit, matas pa kay sa kadég. ");
INSERT INTO klg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aw ya manga kyinita' nan aw ya manga dyengeg nan adti tas na langit, pig-ubat nan, manang tabay ya nyangintu-u sa piglong nan. ");
INSERT INTO klg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Manang pangkay singalan ya mangintu-u sa paglongun nan, yan ya magmatinaw sa kadég na pigpa-ede' kanan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay si Jisus ya Pigpadala na Tyumanem na un maglong sa manga tingeg nan, aw pig-atag kanan na Tyumanem ya Ispiritu Santo na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pigginawa͡an na Ama ya kanan Ise' aw pig-atag adti kanan ya kadég. ");
INSERT INTO klg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pangkay singalan ya mangintu-u sa Ise' na Tyumanem, matagtun nan ya ginawa na wala' ya katigkasan. Manang kun singalan ya dili' dumalug sa Ise' nan, dili' nan matagtun ya ginawa na wala' ya katigkasan, aw awun baling gayed ni kanan ya kadaman na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na, dyengeg na manga Parisiyo na madég da ya utaw na migpaba͡utismu aw dyumalug kan Jisus kay sa kan Juan, ");
INSERT INTO klg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","manang ya tengteng matinaw, beke' ni Jisus ya migba͡utismu manang kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagka-ede' da ni Jisus na dyengeg da na manga Parisiyo, pig-indegan nan ya probinsiya na Judiya aw lyumiku' adti Galilya. ");
INSERT INTO klg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sa pagpasinan ni Jisus adti Galilya, ka-ilangan sakanan magi adti Samariya. ");
INSERT INTO klg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aw sa pagdateng nilan adti Samariya, nyaka-agi silan adti lunsud na Sikar malapit adti lupa' na pig-atag ni Jakub sa ise' nan na si José. ");
INSERT INTO klg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na, dun ni banwa yan awun to-o malalem na tegbengan na pigkutkutan ni Jakub asini muna. Aw nyingkud si Jisus dun ni kilid na salukanan kay to-o sakanan migkalug lekat adti panaw nan aw alas dosi la. ");
INSERT INTO klg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sayda la nan olo' ya dun kay ya manga umagakan nan nyadtu silan ni lunsud na un mayad sa makan. Wala' kadugay, dyumateng ya sambuk na ka͡ubayan na Samariyanen na un sumaluk. Aw miglong si Jisus kanan, “Pa-inema aku na tubig.” ");
INSERT INTO klg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aw miglong ya ka͡ubayan, “Ananga' kaw magsekat adi kanak sa tubig? Judiyu kaw saba aw aku ka͡ubayan na Samariyanen.” Yan ya piglong na ka͡ubayan kay dili' silan pagkasambukan na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aw miglong si Jisus kanan, “Kun pigka-ede-an pa mu galu kun unu ya ma-atag na Tyumanem aw kun singalan aku na migsekat kanmu sa tubig, ikaw baling ya magsekat kanak aw atagan ta kaw sa to-o pa madyaw na tubig kasiling na selep na dili' magkati, aw yan ya maka-atag sa tengteng ginawa.” ");
INSERT INTO klg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aw miglong ya ka͡ubayan kanan, “Kay Sir, wala' ya sasaluk mu aw to-o malalem ya tegbengan ini. Ayin kaw kamang sa tubig na maka-atag sa ginawa? ");
INSERT INTO klg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unu, matas pa kaw ka' kay sa bakleg nami asini muna na si Jakub? Nyinem sakanan sa tubig ini aw nyinem uman ya mangayse' nan, aw pigpa-inem nilan asini ya kanilan manga ayep. Aw yeiy ya ayawanan nan kanami na manga buwadbuwad nan.” ");
INSERT INTO klg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aw tyumubag si Jisus kanan, “Ya utaw na minem sa tubig ini, talaynemen pa salut, ");
INSERT INTO klg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","manang pangkay singalan ya minem sa tubig na atag ku, dili' da sakanan salut talaynemen. Kay ya palangad tubig na un ku atag, masiling saba na selep na gayed nyiswak dun ni kanan anenganeng, aw matag kanan sa ginawa na wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yanagaw miglong ya ka͡ubayan, “Kay Sir, atagi aku na tubig yan pada dili' da aku talaynemen salut, aw dili' da aku magliku-liku' sumaluk!” ");
INSERT INTO klg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Miglong si Jisus kanan, “Angaya ya eseg mu aw liku' kaw adi.” ");
INSERT INTO klg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aw tyumubag ya ka͡ubayan, “Wala' ya eseg ku.” Aw miglong si Jisus, “Matinaw ya tubag mu na wala' ya kanmu eseg, ");
INSERT INTO klg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kay idtu muna awun lima ya eseg mu aw ya sambuk na pig-iyeped mu adun beke' na kanmu tengteng eseg. Matinaw saba ya piglong mu.” ");
INSERT INTO klg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Miglong ya ka͡ubayan, “Kay Sir, nya-ede' aku na propita kaw! ");
INSERT INTO klg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Asini buntud ini, yeiy ya banwa na pagsimba͡an na kanami manga mangkabaklegay. Manang miglong kamu na manga Judiyu na adtu olo' ni Jérusalim ya umba' pagsimba͡an sa Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aw tyumubag si Jisus kanan, “Pakanyegi ya un ku kanmu paglongun: Dumateng ya allaw na simba͡en mayu ya Ama pangkay asini buntud ini aw adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamu na manga Samariyanen, wala' mayu ka-ede-i kun singalan ya pigsimba mayu. Manang kami na manga Judiyu, kya-ede-an nami kun singalan ya kanami pigsimba, kay ya Magpaluwa-ay sa manga utaw lyumekat saba adti manga utaw na Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Manang dumateng ya udas aw migpalekat da saba na ya manga tengteng mananimba͡ay magkasambuk ya kanilan anenganeng na un simba͡en ya Ama aw matibulluk ya kanilan anenganeng adti katinawan. Maynan ya umba' na mananimba͡ay na pigpaninaw na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ya Tyumanem, Ispiritu saba. Yanagaw pangkay singalan ya magsimba kanan, ka-ilangan simba͡en nilan dun ni kanilan ispiritu, aw matibulluk adti katinawan.” ");
INSERT INTO klg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Miglong ya ka͡ubayan kan Jisus, “Kya-ede-an ku na dumateng ya Misiyas na pigtawag uman na Kristu. Aw sa pagdateng nan, bangalen nan kanaten ya kadég.” ");
INSERT INTO klg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aw miglong si Jisus kanan, “Aku saba ya piglong mu na un dumateng.” ");
INSERT INTO klg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa kenne' pa ni Jisus miglong, dyumateng ya manga umagakan nan. Aw nyabelengbeleng silan kay migbalawbalaw sakanan sa ka͡ubayan. Manang wala' ya sambuk kanilan na nyusip sa ka͡ubayan kun unu ya tud nan aw wala' silan uman usip kan Jisus aw ananga' sakanan magbalawbalaw sa ka͡ubayan yeiy. ");
INSERT INTO klg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aw pig-ayawan na ka͡ubayan ya betanganan nan sa tubig aw maksay lyumiku' adti lunsud. Aw pig-ubatan nan ya manga utaw na nyeya' dun, ");
INSERT INTO klg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","law nan, “Panamal kamu! Tanawa mayu ya utaw na mig-ubat kanak sa kadég na nya-imo' ku! Pagaw yeiy da gya ya Kristu?” ");
INSERT INTO klg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yanagaw ya manga utaw lyumekat adtu lunsud yan aw nyadtu silan adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa wala' pa dateng ya manga utaw, miglong kan Jisus ya manga umagakan nan, “Kay Magpalna-uway, kan da kaw!” ");
INSERT INTO klg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Manang miglong si Jisus kanilan, “Awun pagkanen ku na wala' mayu ka-ede-i.” ");
INSERT INTO klg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yanagaw mig-usip-usipay silan, law nilan, “Pagaw awun dyumala kanan sa kakan?” ");
INSERT INTO klg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Manang miglong si Jisus kanilan, “Yan ya kanak pagkanen, ya pagtuman sa pagkaliman na migpadala kanak aw ya paglingeb sa imo-unun na pya-imo' nan kanaken. ");
INSERT INTO klg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Enda', miglong kamu na awun pa upatembulan bagu ya pag-ani? Manang paglongun ta kamu, adun ya umba' na pag-ani. Inunuwa mayu ya madég na utaw na nyandateng! Kun sa aniyenen pa yeiy, dayaw da nya-inug aw umba' da aniyen. ");
INSERT INTO klg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya mag-aniyay, un saba dumawat sa tandan, aw ya manga bunga na pig-ani la, yan ya manga utaw na makatagtun sa ginawa na wala' ya katigkasan. Yanagaw, ya manga utaw na migtanem aw ya manga utaw na mig-ani, alag silan magleya. ");
INSERT INTO klg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Matinaw ya paglongun: ‘Awun migtanem, aw eped ya mig-ani.’ ");
INSERT INTO klg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pigsugu' ta kamu na un mag-ani sa wala' mayu kapagudi. Ya eped na manga utaw migtalabahu aw to-o dakula' ya pagud nilan. Aw kamu ya kya-untungan sa kanilan kyapagudan.” ");
INSERT INTO klg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aw madég ya manga Samariyanen dun ni lunsud yan na nyangintu-u la kan Jisus asuntu sa pig-ubat kanilan na ka͡ubayan. Law nan, “Piglong nan saba kanak ya kadég na pig-imo' ku!” ");
INSERT INTO klg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yanagaw sa pagdateng da na manga Samariyanen adti kan Jisus, nyanginayu' silan kanan na matingen pa adti tampid nilan. Aw nyeya' pa sakanan dun seled na duwangallaw. ");
INSERT INTO klg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aw asuntu sa pagpalna-u ni Jisus kanilan, to-o pa madég ya nyangintu-u kanan. ");
INSERT INTO klg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aw miglong silan adti ka͡ubayan, “Nyangintu-u la kami adun kanan beke' olo' na asuntu sa piglong mu kanami manang asuntu na kami la ya tengteng dyumengeg sa piglong nan. Aw kya-ede-an da nami na yan saba ya Magpaluwa-ay sa kadég na manga utaw!” ");
INSERT INTO klg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagkatigkas da na duwangallaw, migpadeleg si Jisus sa panaw nan pasinan adti Galilya. ");
INSERT INTO klg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na, idtu muna miglong si Jisus na dili' pagdawaten ya propita dun ni kanan banwa. ");
INSERT INTO klg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Manang sa pagdateng da ni Jisus adti banwa na Galilya, madég na Galilyanen ya dyumawat kanan. Kay kyinita' da na manga utaw yeiy ya pigpan-imo' ni Jisus dun ni pista adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aw lyumiku' uman si Jisus adti Cana sakup na Galilya na yan ya banwa na pig-imo-an nan sa milagru na ya tubig migbaluy bino. Na, adti Kapirna-um awun sambuk na pagsaligan na gubirnu na nyeya' dun, aw to-o kyatigda-an ya ise' nan na eseg. ");
INSERT INTO klg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagdengeg nan na dyumateng si Jisus adti Galilya lekat adti Judiya, nyadtu sakanan adti Cana aw nyanginayu' na magad kanan si Jisus adti Kapirna-um aw guli-en nan ya ise' na pakamatayenen da. ");
INSERT INTO klg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Miglong si Jisus kanan, “Kun wala' pa kamu kita' sa manga pangilala aw milagru na pig-imo' ku, dili' kamu mangintu-u kanak.” ");
INSERT INTO klg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Manang miglong ya pagsaligan, “Kay Sir, mallat kaw beg kanak. Agad kaw kanake' talana wala' pa kamatay ya ise' ku!” ");
INSERT INTO klg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Miglong si Jisus kanan, “Uli' da kaw, kay kyaguli-an da ya ise' mu!” Aw pigpangintu-uwan na pagsaligan ya piglong ni Jisus, aw nyaksay sakanan nyuli' adti Kapirna-um. ");
INSERT INTO klg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aw sa talana pa nan dun ni dalan, pigsungun da sakanan na manga sugu-anen nan aw piglongan nilan na kyaguli-an da ya ise' nan. ");
INSERT INTO klg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yanagaw pig-usip nan silan kun unu udasa ya pagpakaguli' kanan. Aw tyumubag silan, “Kagabi ambung na manga ala una ya pag-uwas sa kapasu-an nan.” ");
INSERT INTO klg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aw kya-anenganengan na ama na ise' na yan ya udas na miglong si Jisus kanan na “Kyaguli-an da ya ise' mu!” Yanagaw ya pagsaligan aw ya kadég na ka-epedanan nan dun ni balay alag silan nyangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, yeiy ya kadwa na milagru na pig-imo' ni Jisus adti Galilya pagkatigkas nan adti Judiya. ");
INSERT INTO klg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkatigkas yan, tyumukud si Jisus adti Jérusalim na un tumambung sa Pista na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, adti syudad na Jérusalim, awun linaw na pigngalanan adti tingeg na Hibriyu, Bétésda. Ya linaw yeiy malapit adti suwangan na pag-agiyan na manga karniro, aw kyapalibedan na lima ya silunganan. ");
INSERT INTO klg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aw dun ni manga silunganan yeiy, kyumulang ya madég na manga utaw na awun magkedel, kasiling na manga buta, aw manga pulid aw manga kimay. ");
INSERT INTO klg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Migtagad silan na mag-inang ya tubig. Kay awun kunu udas na magpanog ya anghil na Tyumanem na un magpa-inang sa tubig. Aw kun singalan ya maka-una magtingelem adti tubig na pigpa-inang na anghil, kaguli-an pangkay unu ya magkedel nan. ");
INSERT INTO klg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, awun sambuk na eseg dun na awun magkedel nan na seled da na katluwan tag walu ya umay. ");
INSERT INTO klg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aw pigkita' ni Jisus na kyumulang sakanan dun, aw kya-ede-an nan uman na to-o la madugay ya magkedel nan. Yanagaw nyusip si Jisus kanan, “Unu, kaliman mu kaguli-an?” ");
INSERT INTO klg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tyumubag ya eseg, “Kay Sir, wala' beg ya utaw na malim dumala kanak adti linaw kun mag-inang da ya tubig. Talana pa ku migpasinan adtu, awun da nyaka-una kanak na eped na utaw.” ");
INSERT INTO klg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aw miglong si Jisus kanan, “Pagbangun kaw! Dala͡a ya kamen mu aw panaw da kaw!” ");
INSERT INTO klg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aw dayaw kyaguli-an ya eseg yan. Aw dyala nan ya kanan kamen aw panaw da. Na, nya-imo' yeiy dun ni Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yanagaw miglong ya manga magdadumala͡ay sa manga Judiyu adti eseg na bagu kyaguli-an, law nilan, “Adun ya Allaw na Paglagdeng! Wala' saba tumbayan ya pagdala sa kamen!” ");
INSERT INTO klg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Manang pigtubag nan silan, “Ya utaw na migguli' kanaken, yan ya migsugu' kanak, law nan, ‘Dala͡a ya kamen mu aw panaw da kaw.’ ” ");
INSERT INTO klg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aw nyusip silan kanan, “Singalan ya utaw yan na miglong kanmu?” ");
INSERT INTO klg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Manang wala' na eseg yan kilala͡a kun singalan ya migguli' kanan. Kay nyanaw da si Jisus asuntu na madég to-o ya manga utaw dun. ");
INSERT INTO klg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagkatigkas yan, pigkita' ni Jisus ya eseg yan adti pamanag na Témplo aw piglongan nan, “Tanawa! Migkadyaw da kaw. Yanagaw dili' da kaw magpakasala' pagaw to-o pa malatay ya dumateng kanmu.” ");
INSERT INTO klg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aw nyadtu ya eseg yan adti manga magdadumala͡ay sa manga Judiyu aw piglongan nan silan na si Jisus ya migguli' kanan. ");
INSERT INTO klg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yanagaw, asuntu sa pagguli' ni Jisus dun ni Allaw na Paglagdeng, dun da pagpalekat ya palpa nilan na pamulayaman si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Manang tyumubag si Jisus kanilan, “Migpadeleg ya kanak Ama sa kanan imo-unun. Yanagaw magdeleg aku uman.” ");
INSERT INTO klg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aw asuntu sa piglong ni Jisus, to-o pa nilan kaliman na patayen sakanan. Aw beke' olo' na kyalakadan nan ya sugu' sa Allaw na Paglagdeng, manang yan ya to-o nilan kyadaman ya piglong ni Jisus na Ama nan ya Tyumanem, na ya kakawasan: migpa-unawa sakanan sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yanagaw miglong si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Wala' ya un mabatug na Ise' kun wala' ya katundanan nan na lekat adti Ama. Yan olo' ya pig-imo' na Ise' ya kyinita' nan na pig-imo' na Ama. Kay kun unu ya pig-imo' na Ama, yan uman ya pig-imo' na Ise'. ");
INSERT INTO klg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kay pigginawa͡an na Ama ya kanan Ise', aw pigpakita' nan adti Ise' nan ya kadég na kanan pigpan-imo'. Aw pangkay awun da kyinita' mayu na pig-imo' nan, manang to-o pa dun dakula' ya un nan pakita' magi sa Ise' nan, pada to-o pa kamu ma-enneng-enneng. ");
INSERT INTO klg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ya Ama, magpakamataw sa manga nyangkamatay, maynan uman ya Ise' maka-atag sa ginawa adti pangkay singalan ya kaliman nan atagan. ");
INSERT INTO klg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aw beke' na Ama ya mag-ukum sa manga utaw, kay pig-atag da nan adti kanan Ise' ya kadakula' na katundanan sa pag-ukum, ");
INSERT INTO klg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pada basa͡an na kadég na utaw ya Ise' kasiling na pagpamasa nilan sa Ama. Yanagaw pangkay singalan ya wala' pamasa sa Ise', wala' nilan uman basayi ya Ama na migpadala kanan. ");
INSERT INTO klg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Matinaw ya un ku paglongun kamayu: Pangkay singalan ya migpakanyeg sa ubat-ubat ku aw nyangintu-u sa migpadala kanak, yan ya utaw na nyakatagtun da sa ginawa na wala' ya katigkasan. Aw dili' sakanan ukuman na pa-emel-emelen kay wala' da sakanan ka-eleti adti Tyumanem aw awun da ni kanan ya tengteng ginawa. ");
INSERT INTO klg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Matinaw saba uman ya un ku paglongun kamayu: Ya manga utaw na kya-eletan pa lekat adti Tyumanem, dyumateng da ya allaw na dumengeg silan sa tingeg na Ise' na Tyumanem. Aw ya kadég na magpakanyeg aw mangintu-u sa ubat-ubat na Ise' nan, silan ya atagan sa bagu na ginawa. ");
INSERT INTO klg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kay ya Ama, yan ya lyekatan sa ginawa, aw kanan pagbaya' na ya Ise' nan lekatan uman sa ginawa. ");
INSERT INTO klg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aw pig-atagan nan uman sakanan na katundanan sa pag-ukum asuntu na yan ya Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dili' kamu magkabelengbeleng sa tingeg ku, kay dumateng saba ya udas na dengegen na kadég na nyangkamatay ya tingeg na Ise' na Utaw ");
INSERT INTO klg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aw lumuwa' silan lekat adti kanilan manga lebeng. Ya manga utaw na mig-imo' sa madyaw, un silan matawun aw atagan sa ginawa na wala' ya katigkasan. Aw ya manga utaw na mig-imo' sa malatay, matawun silan uman manang ukuman na pa-emel-emelen. ");
INSERT INTO klg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Wala' ya un ku mabatug kun aku olo'. Ya kanaken pag-ukum magi saba sa piglong na Tyumanem, aw matinaw ya pag-ukum ku. Dili' aku makabaya' mag-ukum manang ya migpadala kanak yan olo' ya magbaya'. ");
INSERT INTO klg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na, kun aku olo' ya magmatinaw adti manga utaw sa kanaken pagka-utawun, dili' kamu mangintu-u kanak. ");
INSERT INTO klg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Manang awun pa sambuk na migmatinaw kun singalan aku, aw nya-ede' aku na alag saba matinaw ya piglong nan. ");
INSERT INTO klg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Idtu muna, migsugu' kamu sa manga utaw adti kan Juan na Magba͡utismuway pada usipen sakanan, aw pigmatinaw aku nan adti kanilan. ");
INSERT INTO klg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wala' aku pagsalig sa utaw na mig-ubat-ubat kun singalan aku, manang pigkasampetan ku yeiy olo' pada paluwa-en kamu na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan kasiling na saleng na syumiga, aw migleya kamu dagawdagaw sa ubat-ubat nan. ");
INSERT INTO klg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Manang awun pa to-o matas na migmatinaw kanak kay kan Juan. Ya manga imo-unun na pigpa-imo' kanak na Ama na un ku lingeben, yeiy saba ya migmatinaw na pigpadala aku nan. ");
INSERT INTO klg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aw ya Ama na migpadala kanak, yan ya tengteng na migmatinaw kun singalan aku. Manang kamu, wala' mayu pakanyegi ya piglong nan, aw wala' mayu sakanan kita-a. ");
INSERT INTO klg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aw wala' mayu betangan adti kamayu anenganeng ya manga tingeg nan. Kay wala' mayu pangintu-uwi ya kanan pigpadala. ");
INSERT INTO klg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pigsadsadan mayu ya pigpasulat na Tyumanem, kay mig-anenganeng kamu na magi dun ni pagsadsad mayu matagtun mayu ya ginawa na wala' ya katigkasan. Manang adti pigpasulat nan, aku saba ya pigmatinaw dun! ");
INSERT INTO klg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Manang dili' kamu baling malim magpalapit adi kanak pada matagtun mayu galu ya ginawa na wala' ya katigkasan! ");
INSERT INTO klg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Wala' aku pagtagad na deyen na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Manang kya-ede-an ku ya awun ni kamayu anenganeng na wala' ya pagginawa mayu sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nyadi aku dun ni ngalan na kanak Ama, manang wala' aku mayu dawata aw wala' aku mayu pakanyegi. Kun awun eped na dumateng magi olo' dun ni kanan pagka-utawun, maksay mayu baling pigdawat. ");
INSERT INTO klg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Unun mayu ya pagpangintu-u kanak, kun yan olo' ya pagkaliman mayu ya pagsaya' na eped na utaw, aw wala' mayu kalimi ya pagsaya' na lyumekat olo' adti Tyumanem? ");
INSERT INTO klg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Manang dili' kamu mag-anenganeng na aku ya maglimanda kamayu adti asdangan na Ama. Si Moysis na gayed mayu pig-iman, yan ya maglimanda kamayu. ");
INSERT INTO klg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kay kun tengteng kamu nyangintu-u kan Moysis, mangintu-u kamu galu uman kanak, kay aku saba ya pigpalabet nan dun ni kanan pigsulat. ");
INSERT INTO klg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Manang kun wala' mayu pangintu-uwi ya pigsulat nan, na, unun mayu ya pagpangintu-u sa piglong ku kamayu?” ");
INSERT INTO klg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sa paglabay da na pilangallaw, syumakay si Jisus sa balangay aw tyumalipag sa Danaw na Galilya na pigngalanan uman na Danaw na Tibériyas. ");
INSERT INTO klg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aw to-o madég ya manga utaw na dyumalug kan Jisus, kay kyinita' nilan ya manga milagru dun ni pagpangguli' nan sa manga pyangkedelan. ");
INSERT INTO klg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aw tyumukud si Jisus aw ya kanan manga umagakan adti kabuludan, aw nyingkud silan dun. ");
INSERT INTO klg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na, agpet da ya pista na manga Judiyu na yan ya Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aw sa pagkita' ni Jisus sa madég to-o na manga utaw na migpasinan adti kanan, piglongan nan si Pilipi, “Ayin kitadun bayad sa makan pada makakan ya kadég na manga utaw ini?” ");
INSERT INTO klg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na, maynan ya usip nan kay kaliman nan tanda-en ya pagpangintu-u ni Pilipi. Manang kya-ede-an ni Jisus kun unu ya un nan imo-un. ");
INSERT INTO klg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aw tyumubag si Pilipi kanan, “Pangkay ya walumbulan na utaw talabahuwan, dili' pa maka-umba' pagbayad sa makan na kadég na manga utaw ini, pangkay tagbi' olo' ya atag adti tagsambuksambuk kanilan.” ");
INSERT INTO klg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Manang miglong ya inulug ni Simon Pédro na si Andrés na sambuk uman na umagakan ni Jisus, ");
INSERT INTO klg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Awun ise' asini na eseg na awun limallapid ya pan aw duwambulus ya isda'. Manang unun nan ya pagpaka-umba' sa kadég na manga utaw ini?” ");
INSERT INTO klg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Miglong si Jisus adti manga umagakan nan, “Pa-ingkuda mayu ya manga utaw.” Na, dun ni banwa yan to-o madég ya sakati aw nyingkud silan dun. Na, ya kadég na manga eseg dun, manga limammalalan silan. ");
INSERT INTO klg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pagkatigkas yan, pigkamang ni Jisus ya pan, aw pigpasalamatan nan adti Tyumanem, aw pyan-atped-atped adti kadég na nyan-ingkud dun. Aw maynan uman ya pig-imo' nan sa manga isda'. Aw kyuman ya kadég nilan aw alag silan nyangkabiyag. ");
INSERT INTO klg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkatigkas nilan kuman, miglong si Jisus adti manga umagakan nan, “Pan-imuna mayu ya nyangkasama' pada dili' masapad.” ");
INSERT INTO klg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yanagaw pigpan-imun nilan ya kadég na nyasama', aw sampulu' tag duwa ya be-en na dayaw nyangkatmu'. ");
INSERT INTO klg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sa pagkita' na manga utaw sa milagru na pig-imo' ni Jisus, miglong silan, “Yeiy saba ya Propita na pigpadala na Tyumanem asini tas na lupa'!” ");
INSERT INTO klg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aw kya-ede-an ni Jisus na kaliman nilan kamangen sakanan aw legesen imo-un hari'. Yanagaw migpa-awat si Jisus kanilan aw tyumukud da uman adti kabuludan na olo' nan sayda. ");
INSERT INTO klg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na, sa pagkamagsiklep da, tyumubang ya manga umagakan ni Jisus pasinan adti ligad na danaw. ");
INSERT INTO klg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Manang pagkagabi la, wala' pa dateng si Jisus, yanagaw syumakay silan sa balangay aw tyumalipag pasinan adti Kapirna-um. ");
INSERT INTO klg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sa talana pa nilan adti danaw, dyumateng ya to-o mabandes na samet aw migbaled ya tubig. ");
INSERT INTO klg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na, ya kawat na pigbegsayan da nilan sobla limangka kilomitro, aw kyinita' nilan si Jisus na nyanaw dun ni tas na tubig na migpasinan adti balangay. Aw to-o silan nyallek, ");
INSERT INTO klg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","manang migtawag si Jisus kanilan, “Dili' kamu magkallek! Aku saba ya ini!” ");
INSERT INTO klg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aw migleya silan migpasakay kan Jisus dun ni tampid nilan aw maksay dyumateng ya balangay adti banwa na pigkadtuwan nilan. ");
INSERT INTO klg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagkasalut da na allaw, ya manga utaw na migpatagak adti dipag na danaw, kya-ede-an nilan na sambuk da olo' ya balangay adti ligad na danaw. Aw kya-ede-an nilan uman na olo' umagakan ni Jisus ya syumakay aw wala' sakanan paka-agad kanilan. ");
INSERT INTO klg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wala' kadugay, awun manga balangay lekat adti Tibériyas na nyakadanggay malapit adti pigpakanan na kanaten Pangulu sa madég na utaw sa pan na pigpasalamatan da nan adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yanagaw sa pagka-ede' da na manga utaw na wala' da dun si Jisus aw ya manga umagakan nan, ya eped kanilan syumakay sa manga balangay aw syuminan adti Kapirna-um na un paninawun si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sa pagdateng nilan adti dipag, kyinita' nilan si Jisus, aw law nilan, “Kay Magpalna-uway, kanu kaw dateng asini?” ");
INSERT INTO klg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aw tyumubag si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Pyaninaw aku mayu beke' na asuntu sa manga milagru na kyinita' mayu, manang asuntu saba sa pagpakan ku kamayu kagabi aw dayaw kamu nyangkabiyag. ");
INSERT INTO klg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dili' mayu olo' pagtibagsegan ya pagkanen na maksay magkalat. Manang yan baling ya tibagsegi mayu ya palangad pagkanen na maka-atag sa ginawa na wala' ya katigkasan. Aw yeiy ya un atag na Ise' na Utaw adti kamayu. Kay pig-atag kanan na Tyumanem na Ama ya katulus mag-imo' sa manga milagru yeiy na un magmatinaw kun singalan sakanan.” ");
INSERT INTO klg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yanagaw nyusip silan kanan, “Unu ya madyaw nami imo-un pada mabatug ya manga imo-unun na Tyumanem?” ");
INSERT INTO klg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aw tyumubag si Jisus kanilan, “Ini ya umba' mayu imo-un pada mabatug ya manga imo-unun na Tyumanem: Pangintu-uwan mayu ya Pigpadala nan.” ");
INSERT INTO klg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aw law nilan, “Unu ya milagru na un mu kanami pakita' pada pangintu-uwan kaw nami? ");
INSERT INTO klg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Asini muna, talana na manga tyugbulan tadun miglegeblegeb adti kaligbinan, yan ya pigkan nilan ya pigngalanan na ‘mana’. Yanagaw ini ya pigpasulat na Tyumanem: ‘Pig-atagan nan silan na pagkanen na lekat adti langit.’ ” ");
INSERT INTO klg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aw tyumubag si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Beke' ni Moysis ya nyatag kanilan sa pagkanen na lekat adti tas na langit, manang yan saba ya nyatag kanilan ya Ama ku. Aw yan uman ya nyatag kamayu sa tengteng pagkanen na lekat adti tas na langit. ");
INSERT INTO klg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kay ya pagkanen na lekat adti Tyumanem, yan ya nyanog lekat adti tas na langit aw gayed nyatag sa tengteng ginawa adti manga utaw.” ");
INSERT INTO klg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aw law nilan, “Kay Pangulu, atagi kami gayed na pagkanen yeiy!” ");
INSERT INTO klg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aw miglong si Jisus kanilan, “Aku saba ya pagkanen na nyatag sa tengteng ginawa. Pangkay singalan ya madi kanak, dili' da sakanan magetem. Aw pangkay singalan ya mangintu-u kanak, dili' da sakanan uman talaynemen. ");
INSERT INTO klg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Manang kasiling na piglong da ku kamayu idtu muna: Pangkay kyinita' da mayu ya manga milagru na pig-imo' ku, manang wala' kamu pakalabet kun singalan aku, aw wala' aku mayu pangintu-uwi. ");
INSERT INTO klg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya kadég na manga utaw na pig-atag kanak na Ama, un silan madi kanak, aw pangkay singalan ya madi kanak dili' ku pabaya-an. ");
INSERT INTO klg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay nyanog aku lekat adti tas na langit na un imo-un ya pagkaliman na migpadala kanak, aw beke' na kanak pagkaliman. ");
INSERT INTO klg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aw yan ya kanan pagkaliman na wala' ya pangkay sambuk na malagak na manga pig-atag nan kanak. Manang adti kamoliyan na allaw matawun ku silan lekat adti nyangkamatay. ");
INSERT INTO klg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kay ini saba ya pagkaliman na Ama ku: Ya kadég na nyaka-ede' kun singalan ya Ise' nan aw mangintu-u kanan, yan ya manga utaw na makatagtun sa ginawa na wala' ya katigkasan aw matawun ku silan adti kamoliyan na allaw.” ");
INSERT INTO klg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na, migdiklamu ya manga eped na Judiyu sa piglong nan na “Aku ya pagkanen na nyanog lekat adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aw miglong silan, “Enda', si Jisus saba olo' yeiy na ise' ni José! Kya-ede-an tadun ya ama nan aw ya ina nan. Ananga' sakanan makapaglong na nyanog kunu sakanan lekat adti tas na langit?” ");
INSERT INTO klg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Manang miglong si Jisus kanilan, “Dili' kamu magdiklamu sa piglong ku. ");
INSERT INTO klg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ya kanak Ama na awun ni tas na langit yan ya migpadala kanak asini. Yanagaw wala' ya utaw na makakadi kanak kun dili' sakanan paduludun na kanak Ama. Aw ya dyumalug kanak, matawun ku sakanan lekat adti nyangkamatay dun ni kamoliyan na allaw. ");
INSERT INTO klg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Awun pigsulat na propita asini muna: ‘Palna-uwan na Tyumanem ya kadég nilan.’ Yanagaw ya kadég na migpakanyeg sa pigpasulat na Ama ku aw dyumalug sa piglong nan, silan ya dumulud kanak. ");
INSERT INTO klg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Beke' na kakawasan nan na awun kyumita' sa Ama. Wala' saba ya utaw na kyumita' kanan. Yan olo' ya kyumita' ya Pigpadala na Tyumanem na lyumekat adti tampid nan. ");
INSERT INTO klg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Matinaw ya un ku paglongun kamayu: Pangkay singalan ya nyangintu-u kanak, nyakatagtun da sa ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku ya pagkanen na nyatag sa tengteng ginawa. ");
INSERT INTO klg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ya tyugbulan mayu asini muna, kyuman silan sa mana adti kaligbinan manang alag da silan nyangkamatay. ");
INSERT INTO klg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Manang pangkay singalan ya kuman sa pagkanen na lyumekat adti tas na langit, dili' da sakanan ka-eletan adti Tyumanem na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku saba ya pagkanen na lyumekat adti tas na langit na matag sa tengteng ginawa. Pangkay singalan ya kuman seiy, makatagtun sakanan sa ginawa na wala' ya katigkasan. Aw ya pagkanen na atag ku adti kadég na manga utaw, yan ya kanaken lawas.” ");
INSERT INTO klg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sa pagdengeg na manga Judiyu sa piglong ni Jisus, migbilingbiling silan kun unu ya kakawasan na piglong nan, aw law nilan, “Unun na utaw yeiy ya pag-atag sa unud na lawas nan kanaten pada kanen tadun?” ");
INSERT INTO klg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yanagaw miglong si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Kun dili' kamu kuman sa unud na lawas na Ise' na Utaw aw minem sa dugu' nan, wala' adti kamayu ya tengteng ginawa. ");
INSERT INTO klg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pangkay singalan ya kuman sa unud na lawas ku aw minem sa dugu' ku, yan ya utaw na makatagtun sa ginawa na wala' ya katigkasan, aw matawun ku sakanan adti kamoliyan na allaw. ");
INSERT INTO klg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kay ya kanaken unud, yan saba ya tengteng pagkanen, aw ya kanaken dugu', yan saba ya tengteng inemenen. ");
INSERT INTO klg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aw pangkay singalan ya kuman sa kanaken unud aw minem sa kanaken dugu', nyakasambuk da sakanan kanaken, aw aku awun uman ni kanan. ");
INSERT INTO klg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ya Ama na migpadala kanak, yan ya lyekatan sa tengteng ginawa. Aw asuntu kanan, awun ginawa ku. Yanagaw pangkay singalan ya kuman sa unud na lawas ku, matagtun nan uman ya tengteng ginawa magi kanak. ");
INSERT INTO klg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya tyugbulan mayu asini muna kyuman silan sa mana manang alag da silan nyangkamatay. Manang aku saba ya pagkanen na lyumekat adti tas na langit, aw pangkay singalan ya kuman sa pagkanen yeiy makatagtun sa ginawa na wala' ya katigkasan.” ");
INSERT INTO klg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na, pigpalna-u ni Jisus ya kadég yeiy talana nan adti seled na sinagoga dun ni lunsud na Kapirna-um. ");
INSERT INTO klg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Madég ya manga utaw na gayed dyumalug kan Jisus. Sa pagdengeg nilan sa piglong nan, migpan-usip-usipay ya eped kanilan, law nilan, “To-o malug ya kanan pigpalna-u! Singalan ya utaw na makalabet seiy?” ");
INSERT INTO klg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Manang kya-ede-an ni Jisus ya piggumudgumud nilan, yanagaw pig-usip nan silan, “Unu, nyakapalumay ya ginawa mayu sa piglong ku? ");
INSERT INTO klg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, kun maynan, unu ya anenganeng mayu kun kita-en da mayu ya Ise' na Utaw na ma-engat adti tas na langit na piglekatan nan? ");
INSERT INTO klg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ya Ispiritu Santo, yan ya nyatag sa ginawa na wala' ya katigkasan, aw dili' yeiy mabatug na utaw. Aw ya ubat-ubat ku na dyengeg mayu, yan ya magbagu kamayu magi sa Ispiritu Santo aw matag sa tengteng ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Manang awun manga eped kamayu na wala' pangintu-u sa piglong ku.” Maynan ya piglong ni Jisus kay kya-ede-an da nan dadan kun singalan ya wala' pangintu-u kanan, aw kya-ede-an nan uman kun singalan ya un maglubid kanan. ");
INSERT INTO klg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aw miglong pa uman si Jisus kanilan, “Yeiy ya du-an na miglong aku kamayu na wala' ya utaw na makakadi kanak kun dili' tumbay na kanak Ama.” ");
INSERT INTO klg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yanagaw lekat dun ni allaw yan, asuntu sa pigpalna-u ni Jisus, madég ya manga utaw na wala' da dalug kanan. ");
INSERT INTO klg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aw nyusip si Jisus adti sampulu' tag duwa ya umagakan nan, “Unu, kaliman mayu uman mayaw kanak?” ");
INSERT INTO klg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aw tyumubag si Simon Pédro kanan, “Kay Pangulu, kun ayawan kaw nami, ayin da kami pasinan? Ikaw olo' ya mig-ubat-ubat sa tengteng ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nyangintu-u la kami kanmu, aw kya-ede-an da nami na ikaw ya wala' ya sala' na Pigpadala na Tyumanem na lekat adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pagkatigkas yan, miglong si Jisus kanilan, “Enda', kamu na sampulu' tag duwa, aku ya nyamalli' kamayu? Manang awun sambuk kamayu na piggagad ni Satanas!” ");
INSERT INTO klg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na, yan ya pigpalabet nan si Judas Iskaryoti na ise' ni Simon na taga Kariyot probinsiya na Judiya. Pangkay sambuk sakanan dun ni sampulu' tag duwa ya umagakan nan, manang sakanan ya un maglubid kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatigkas yan, piglegeb ni Jisus ya banwa na Galilya. Wala' sakanan kalim kadtu ni probinsiya na Judiya kay kya-ede-an nan na ya manga magdadumala͡ay sa manga Judiyu nyaninaw kanan pada patayen sakanan. ");
INSERT INTO klg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na, malapit da magpalekat ya Pista na Manga Layaglayag. ");
INSERT INTO klg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aw piglongan si Jisus na mangkangud nan, “Panaw kaw asini aw kadtu kaw ni Judiya, pada kita-en na manga dyumalug kanmu ya manga milagru na pigpan-imo' mu. ");
INSERT INTO klg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay kun kaliman mu magkadengeg, dili' mu pagtagu-un ya kanmu manga imo-unun manang pakita͡an baling adti kadég na utaw!” ");
INSERT INTO klg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maynan ya piglong na manga mangkangud nan kay pangkay silan wala' pangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yanagaw miglong si Jisus kanilan, “Wala' pa dateng ya allaw na umba' aku madtu. Manang panaw da kamu sa kamayu kay wala' ya kamayu salang. ");
INSERT INTO klg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ya manga utaw na wala' pangintu-u kanak, pigdumutan aku nilan kay pigmatinaw ku na malatay ya imo-unun nilan. Manang kamu wala' nilan dumuti. ");
INSERT INTO klg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamu la ya kadtu ni pista! Manang dili' aku sa kanak tumambung, kay wala' pa kalingeb ya manga allaw ku asini.” ");
INSERT INTO klg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yanagaw, pagkatigkas nan maglong seiy, nyatingen pa sakanan dun ni Galilya. ");
INSERT INTO klg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Manang sa pagpanaw da na mangkangud ni Jisus na un tumambung sa Pista, nyindeg uman si Jisus aw dyumalug kanilan. Manang wala' sakanan pagpa-ede' sa manga utaw kay dili' malim sakanan kilala͡en. ");
INSERT INTO klg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na, dun ni Pista, pigpaninaw sakanan na manga magdadumala͡ay sa manga Judiyu, aw pigpan-usip nilan ya manga utaw, “Ayin yeiy sakanan?” ");
INSERT INTO klg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aw migtumantumanay ya manga utaw. Ya eped miglong, “Madyaw sakanan na utaw.” Manang miglong ya manga eped, “Beke' yan na matinaw! Pigpasuway nan baling ya manga utaw magi sa palna-u nan!” ");
INSERT INTO klg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Manang olo' silan migtumantumanay aw wala' silan paglong adti madég na utaw kay nyallek silan kadamanan na manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, sa pagkatenga-tenga' da na Pista, nyadtu si Jisus adti pamanag na Témplo aw pigpalekat nan ya pagpalna-u. ");
INSERT INTO klg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aw sa pagdengeg na manga magdadumala͡ay sa manga Judiyu sa palna-u nan, to-o silan nya-enneng-enneng, aw law nilan, “Ayin lekat ya katadeng nan yeiy? Wala' saba sakanan paka-iskwila adti pag-iskwila͡an na manga Judiyu.” ");
INSERT INTO klg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aw miglong si Jisus kanilan, “Ya palna-u ku kamayu, wala' lekat adi kanaken. Manang lyumekat saba adti migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pangkay singalan ya malim mag-imo' sa pagkaliman na Tyumanem, maka-ede' kun ayin lekat ya palna-u ku, kun lyumekat adti Tyumanem aw kun lekat olo' adi kanake'. ");
INSERT INTO klg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ya utaw na migpalna-u na lekat adti kanan anenganeng, pigpakadengeg nan olo' ya kanan pagka-utawun. Manang ya migpakadengeg sa migpadala kanan, yan ya tengteng pangintu-uwan kay wala' ya galu' dun ni kanan. ");
INSERT INTO klg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Enda', pig-atagan saba kamu ni Moysis na Uldin? Nyakasulat saba dun na ‘Dili' kamu magpatay.’ Manang wala' ya pangkay sambuk kamayu na nyakatuman sa kadég na manga sugu' dun. Kay kun pigtuman pa mayu, na, ananga' kaliman aku mayu patayen?” ");
INSERT INTO klg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Manang miglong ya manga utaw, “Pigseledan kaw gya na busaw! Singalan ka' ya un malim magpatay kanmu?” ");
INSERT INTO klg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aw tyumubag si Jisus kanilan, “Migpaguli' aku sa utaw dun ni Allaw na Paglagdeng aw nyabelengbeleng kamu aw wala' kamu katutuki. ");
INSERT INTO klg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Manang kamu uman, pangkay Allaw na Paglagdeng migtalabahu kamu. Kay pigtuli' mayu ya kamayu mangayse' na eseg kasiling na pigpalna-u ni Moysis na pigsugu' na Tyumanem adti kanaten tyugbulan. ");
INSERT INTO klg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kun pigpatuli' mayu ya kamayu manga mangayse' dun ni Allaw na Paglagdeng pada dili' mayu kalakadan ya sugu' na Uldin, na, ananga' kamu madaman kanak asuntu sa pagpaguli' ku sa sambuk na utaw dun ni Allaw na Paglagdeng? ");
INSERT INTO klg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dili' kamu mag-ukum asuntu olo' sa pigkita' mayu! Anenganenga mayu una kun unu ya tengteng matinaw pada madyaw ya kamayu pag-ukum.” ");
INSERT INTO klg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ya eped na manga utaw na nyeya' dun ni Jérusalim miglong silan, “Enda', yeiy ya utaw na un galu patayen na manga magdadumala͡ay sa manga Judiyu? ");
INSERT INTO klg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Manang ini baling sakanan! Aw mig-ubat-ubat adti asdangan na kadég na utaw, aw wala' ya kanilan nyakapaglong kanan! Unu, pig-anenganeng nilan na yeiy ya Misiyas? ");
INSERT INTO klg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nya-ede' kitadun kun ayin lekat ya utaw yeiy. Aw kun Misiyas ya dumateng, wala' ya maka-ede' kun ayin sakanan lekat.” ");
INSERT INTO klg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yanagaw miglong si Jisus sa mabagseg na tingeg adti manga utaw na pigpalna-uwan nan dun ni pamanag na Témplo, “Mig-anenganeng kamu na kya-ede-an da mayu kun singalan aku aw kun ayin aku lekat. Manang ya tengteng matinaw wala' mayu ka-ede-i kun ayin aku lekat. Aw beke' na kanak pagbaya' na nyadi aku. Ya migpadala kanak yan ya lyekatan sa kadég na matinaw, aw wala' mayu sakanan ka-ede-i. ");
INSERT INTO klg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Manang kya-ede-an ku sakanan kay nyindeg aku lekat adti kanan, aw yan ya migpadala kanak asini!” ");
INSERT INTO klg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Asuntu sa piglong ni Jisus, kaliman da galu na manga magdadumala͡ay sa manga Judiyu dakepen sakanan, manang wala' ya utaw na migdakep kanan kay wala' pa dateng ya kanan udas. ");
INSERT INTO klg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pangkay maynan ya pig-anenganeng nilan, manang madég pa ya utaw dun na migpakanyeg sa palna-u ni Jisus aw nyangintu-u kanan, aw miglong silan, “Yeiy da saba ya Misiyas, kay wala' ya pangkay singalan na maka-unawa sa kadég na milagru na pigpan-imo' nan.” ");
INSERT INTO klg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kyadenggan na manga Parisiyo ya balawbalaw na manga utaw sa manga piglong ni Jisus. Yanagaw migkasambuk ya anenganeng nilan aw ya manga mangkatas na manga magdadugsu-ay, aw pigsugu' nilan ya manga magtatunggu-ay sa Témplo na dakepen nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeiy ya du-an na miglong si Jisus sa manga utaw na migkatipun dun, “Tagbi' dakman ya manga allaw ku asini tampid mayu, aw tigkas yan, lumiku' aku adti migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Paninawun aku mayu manang dili' da aku mayu kita-en aw dili' kamu makakadtu adti kanaken kadtuwan.” ");
INSERT INTO klg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yanagaw, mig-usip-usipay ya manga magdadumala͡ay sa manga Judiyu, law nilan, “Ayin kadi' sakanan kadtu na dili' da naten sakanan kita-en? Unu ka', madtu sakanan ni banwa na manga Grigo na pig-eya-an na manga eped tadun na Judiyu, aw adtu sakanan pagpalna-u sa manga utaw na Grigo? ");
INSERT INTO klg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Unu ya kakawasan na piglong nan na ‘Paninawun aku mayu manang dili' da aku mayu kita-en, aw dili' kamu makakadtu adti kanaken kadtuwan’?” ");
INSERT INTO klg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na, dyumateng ya allaw na yan ya katigkasan na Pista na allaw na to-o matas. Aw nyindeg si Jisus aw miglong sa mabagseg na tingeg adti asdangan na madég to-o na manga utaw, “Pangkay singalan kamayu ya pigtalaynem, madi kanak aw minem. ");
INSERT INTO klg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kasiling na pigpasulat na Tyumanem asini muna: ‘Pangkay singalan ya nyangintu-u kanak, miswak adti seled nan ya tubig na matag sa tengteng ginawa.’ ” ");
INSERT INTO klg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na, ya pigpalabet ni Jisus, yan ya Ispiritu Santo na un pa dawaten na manga mangintu-uway. Wala' pa atagan ya Ispiritu kay wala' pa si Jisus ka-engat adti tas na langit na un dumawat sa dengeg na lekat adti Ama nan. ");
INSERT INTO klg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pagdengeg na manga utaw sa piglong ni Jisus, awun manga eped na miglong, “Ya utaw ini, yeiy saba ya Propita na pigtagadan tadun!” ");
INSERT INTO klg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aw miglong uman ya manga eped, “Yeiy saba ya Misiyas!” Manang awun manga eped na miglong, “Beke' yan! Kay ya Misiyas dili' lumekat adti Galilya. ");
INSERT INTO klg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kay pigpasulat na Tyumanem na ya Kristu lumekat adti buwadbuwad ni Dabid aw ma͡utaw adti Bétlihém na pig-eya-an uman ni Dabid asini muna.” ");
INSERT INTO klg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yanagaw nyatenga-tenga' ya anenganeng na manga utaw kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Awun manga eped kanilan na kaliman nilan dakepen sakanan manang wala' nilan ka-imo' ya pagdakep kanan. ");
INSERT INTO klg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sa pagliku' na manga magtatunggu-ay sa Témplo adti manga Parisiyo aw manga mangkatas na magdadugsu-ay, pig-usip silan na manga migsugu' kanilan: “Ananga' na wala' mayu sakanan dakepa aw dala͡a asini?” ");
INSERT INTO klg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tyumubag kanilan ya manga magtatunggu-ay, “Wala' pa ya utaw na dyengeg nami na kasiling na maynan!” ");
INSERT INTO klg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aw nyusip ya manga Parisiyo kanilan, “Unu ka', pangkay kamu, kyagawayan nan uman? ");
INSERT INTO klg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sa kadég na migdumala aw kadég nami na manga Parisiyo, singalan ka' ya nyangintu-u sa piglong nan? ");
INSERT INTO klg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ya manga utaw asini katipun na migpakanyeg kanan, wala' silan paka-ede' sa Uldin tadun. Katullunan silan!” ");
INSERT INTO klg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na, ya sambuk na Parisiyo na si Nikodimo, yan ya nyadtu ni kan Jisus idtu muna na migtenga' da ya gabi. Aw miglong si Nikodimo adti manga eped nan, ");
INSERT INTO klg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wala' tumbayan na Uldin tadun ya pag-ukum sa utaw na wala' pa ka-usayi.” ");
INSERT INTO klg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aw tyumubag silan kanan, “Unu ka', taga Galilya kaw uman? Tanawa aw sadsadi ya pigpasulat na Tyumanem aw ka-ede-an mu na wala' ya propita nan na lumekat adti Galilya!” ");
INSERT INTO klg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatigkas yan, migsi-uli' ya kadég nilan. ");
INSERT INTO klg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aw lyumiku' si Jisus adti Buntud na Manga Olibo. ");
INSERT INTO klg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Manang sa pagkamaselem da, lyumiku' uman sakanan adti pamanag na Témplo. Madég to-o ya manga utaw na migpalapit kanan. Yanagaw nyingkud sakanan aw pigpalna-uwan nan silan. ");
INSERT INTO klg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Talana nan migpalna-u, dyumulud kanan ya manga magpalna-uway sa Uldin aw manga Parisiyo na migpa-agad sa sambuk na ka͡ubayan na kyadula͡an na miglakadenen. Aw pigpa-indeg nilan adti tenga-tenga' na kadég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aw miglong silan kan Jisus, “Kay Magpalna-uway, ya ka͡ubayan ini kyadula͡an na miglakadenen. ");
INSERT INTO klg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Adti Uldin na pig-atag na Tyumanem kan Moysis, kun awun ka͡ubayan na kyadula͡an miglakadenen, umba' sakanan pamintuwun na batu menda' na matay. Na, unu ya kanmu mapaglong sa ka͡ubayan yeiy?” ");
INSERT INTO klg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Maynan ya usip nilan kay kaliman nilan tanda-en si Jisus pada kalitagan dun ni tubag nan aw awun kalimanda nilan kanan. Manang ya pig-imo' ni Jisus, miglingkotot baling sakanan aw migsulatsulat sa tullu' nan dun ni lupa'. ");
INSERT INTO klg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Manang asuntu na gayed silan gyumelgel nyusip kanan, nyinindeg si Jisus aw miglong adti kanilan, “Kun singalan kamayu ya wala' ya sala', yan ya muna mintu kanan sa batu.” ");
INSERT INTO klg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aw miglingkotot da uman sakanan aw migsulatsulat pa sa tullu' nan dun ni lupa'. ");
INSERT INTO klg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aw sa pagdengeg nilan sa piglong nan, migbeklag ya tagsambuksambuk kanilan. Nyuna nyanaw ya manga bakleg menda' na nyabus silan nyanaw. Yan olo' ya nyasama' si Jisus aw ya ka͡ubayan na kenne' pa nan nyindeg dun. ");
INSERT INTO klg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aw nyinindeg si Jisus aw piglongan nan ya ka͡ubayan, “Kay Dé', ayin da silan? Wala' kaw kadi' nilan ukumi na pa-emel-emelen?” ");
INSERT INTO klg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tyumubag ya ka͡ubayan, “Wala' kay Sir.” Aw miglong si Jisus kanan, “Aku uman dili' maka-ukum kanmu na pa-emel-emelen. Uli' da kaw aw dili' da kaw salut magpakasala'.” ");
INSERT INTO klg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pagkatigkas yan, miglong pa si Jisus adti manga utaw, “Aku ya kalalamdag na maka-ilaw sa anenganeng na manga utaw. Pangkay singalan ya dumalug kanak, wala' da sakanan dun ni kangitngitan kay ka-ilawan da sakanan na kalalamdag na maka-atag sa tengteng ginawa.” ");
INSERT INTO klg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sa pagdengeg na manga Parisiyo sa piglong ni Jisus, miglong silan, “Ikaw olo' ya migmatinaw sa kanmu pagka-utawun, yanagaw beke' na matinaw ya piglong mu!” ");
INSERT INTO klg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aw law ni Jisus kanilan, “Pangkay kun yan ya piglong ku ya kanak pagka-utawun, alag saba matinaw ya kanak piglong. Kay kya-ede-an ku kun ayin aku lekat aw ayin aku pasinan. Manang kamu, wala' kamu paka-ede' kun ayin aku lekat aw ayin aku pasinan. ");
INSERT INTO klg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ya indeganan na pag-ukum mayu sa utaw lekat olo' adti pigkita' mayu. Manang beke' na maynan ya kanak pag-ukum adti pangkay singalan. ");
INSERT INTO klg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kun mag-ukum aku, alag saba matinaw ya pagbaya' ku. Kay beke' ku olo' ya mag-ukum manang ya eped ku ya Ama na migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enda', nyakasulat dun ni Uldin mayu na ‘kun mig-unawa ya piglong na duwa ya utaw dun ni asdangan na mag-usayay, ya piglong nilan alag saba matinaw.’ ");
INSERT INTO klg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yanagaw pigmatinaw ku ya kanak pagka-utawun. Aw ya sambuk uman na migmatinaw kanak, yan ya Ama ku na migpadala kanak.” ");
INSERT INTO klg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aw nyusip ya manga Parisiyo kanan, “Ayin ka' ya Ama mu?” Aw tyumubag si Jisus kanilan, “Yeiy ya tengteng matinaw: Wala' kamu paka-ede' kanak aw wala' mayu uman ka-ede-i ya Ama ku. Kun kya-ede-an pa aku mayu, ka-ede-an mayu uman ya kanak Ama.” ");
INSERT INTO klg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ya kadég yeiy, piglong ni Jisus dun ni pagpalna-u nan adti pamanag na Témplo malapit adti manga uluganan sa kuwalta. Manang wala' ya migdakep kanan kay wala' pa dateng ya allaw na dakepen sakanan. ");
INSERT INTO klg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aw miglong pa si Jisus kanilan, “Manaw aku, aw dili' da aku asini sayid mayu. Paninawun aku mayu, aw kamatayan pa mayu ya pagpadeleg mag-imo' sa sala'. Dili' kamu makakadtu adti kanaken kadtuwan.” ");
INSERT INTO klg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yanagaw mig-usip-usipay ya manga magdadumala͡ay sa manga Judiyu, law nilan, “Unu ya kakawasan na piglong nan na dili' kunu kitadun makakadtu adti kanan kadtuwan? Unu, tumuyu' sakanan?” ");
INSERT INTO klg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aw miglong si Jisus kanilan, “Asini tas na lupa' ya kamayu pig-eya-an, manang aku lyumekat adti tas na langit. Aw ya anenganeng mayu asini olo' ni tas na lupa'. Manang aku dili' taga asini. ");
INSERT INTO klg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yeiy ya du-an na piglong ku na kamatayan mayu ya pagpadeleg mag-imo' sa sala'. Kay kun dili' kamu mangintu-u na matinaw ya piglong ku na aku ya Pigpadala na Tyumanem, kamatayan mayu saba ya pagpadeleg mag-imo' sala'.” ");
INSERT INTO klg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Miglong silan, “Singalan kaw ka'?” Aw tyumubag si Jisus, “Piglongan da ta kamu saba lekat pa asini muna kun singalan aku. ");
INSERT INTO klg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madég pa galu ya un ku diklamu kamayu. Manang yan olo' ya pigpa-ede' ku adti manga utaw ya dyengeg ku adti migpadala kanak. Aw alag matinaw ya piglong nan.” ");
INSERT INTO klg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Manang wala' nilan kalabeti na yan ya pigpalabet nan ya kanan Ama. ");
INSERT INTO klg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yanagaw miglong pa uman si Jisus kanilan, “Pagdateng na allaw na pa-indegen mayu ya Ise' na Utaw adti krus, dun da mayu ka-ede-i kun singalan aku. Aw ka-ede-an da mayu na wala' ya pig-imo' ku na wala' lekat adti Ama, manang yan olo' ya piglong ku ya pigpalna-u nan kanak. ");
INSERT INTO klg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aw ya migpadala kanak, gayed sakanan nyagad kanaken. Wala' aku nan pabaya-i. Kay kun unu ya makatutuk kanan, yan ya gayed ku pig-imo'.” ");
INSERT INTO klg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aw sa pagpakadengeg na manga utaw sa piglong ni Jisus, madég kanilan ya nyangintu-u kanan. ");
INSERT INTO klg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yanagaw piglongan ni Jisus ya manga Judiyu na nyangintu-u la kunu kanan, “Kun padelegen mayu ya pagdalug sa palna-u ku, kamu saba ya tengteng na umagakan ku, ");
INSERT INTO klg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","aw ka-ede-an mayu ya tengteng matinaw, aw magi sa pagka-ede' mayu sa katinawan, paluwa-en kamu lekat adti pagka-allang mayu.” ");
INSERT INTO klg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aw law nilan, “Buwadbuwad kami ni Abraham! Wala' kami allanga na pangkay singalan. Ananga' kaw maglong na paluwa-en kami?” ");
INSERT INTO klg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aw tyumubag si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Pangkay singalan ya migpakasala', allang saba na sala'. ");
INSERT INTO klg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ya utaw na allang wala' ya un nan matagtun, manang ya ise' na tagtun sa balay, yan ya tumagtun sa bagi' na ama nan na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yanagaw, kun ya Ise' na Tyumanem ya magpaluwa' kamayu dun ni pagka-allang mayu, makaluwa' kamu saba. ");
INSERT INTO klg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kya-ede-an da ku na manga buwadbuwad kamu ni Abraham. Manang ya eped kamayu gayed migpalpa na patayen aku. Kay kyele͡an mayu ya kanak palna-u. ");
INSERT INTO klg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yan ya kanak pigpalna-u adti kamayu, ya pigkita' ku adti tampid na Ama ku. Aw ya kamayu pig-imo', yan ya pigdengeg mayu lekat adti kamayu ama.” ");
INSERT INTO klg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Manang miglong silan, “Si Abraham ya kanami ama!” Aw tyumubag si Jisus kanilan, “Kun matinaw na manga buwadbuwad kamu ni Abraham, pig-imo' mayu galu ya manga pigpan-imo' nan. ");
INSERT INTO klg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Manang adun, pigbetang da mayu adti kamayu ginawa ya pagpatay kanak asuntu na pig-ubat-ubat ku ya matinaw. Beke' na maynan ya bet ni Abraham! Ya pig-ubat-ubat ku, alag lyumekat adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Manang ya kamayu pig-imo' kasiling uman na pig-imo' na kamayu ama.” Aw law nilan, “Beke' kami na kasiling na manga ise' adti luwa'! Sambuk da ya Ama nami, aw yan ya Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aw miglong si Jisus kanilan, “Kun matinaw pa na tengteng Ama mayu ya Tyumanem, ginawa͡an aku mayu galu kay lekat aku adti sayid nan. Wala' aku kadi asuntu sa kanak pagbaya', manang kanan pagbaya'. ");
INSERT INTO klg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ananga' dili' mayu pagkalabetan ya kakawasan na piglong ku? Ya tengteng matinaw, dili' mayu mati-is ya pagpakanyeg sa palna-u ku. ");
INSERT INTO klg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas ya kamayu ama, aw pangkay unu ya kanan pagkaliman, yan ya kamayu pig-imo'. Migpatay sakanan lekat pa asini muna. Pagkele͡an nan ya matinaw kay wala' dun ni kanan ya katinawan. Galu-un sakanan asuntu na yan ya kanan bet aw yan ya lyekatan sa kadég na kagalu-an. ");
INSERT INTO klg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yanagaw asuntu na alag matinaw ya piglong ku, yan baling ya du-an na wala' kamu pangintu-u kanak. ");
INSERT INTO klg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na, singalan ka' kamayu ya makamatinaw na nyakasala' aku? Wala' saba! Ananga' dili' kamu mangintu-u na alag matinaw ya piglong ku? ");
INSERT INTO klg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pangkay singalan ya kana Tyumanem utaw, magpakanyeg aw mangintu-u sa ubat-ubat na lekat adti kanan. Manang kamu, wala' mayu kalabeti asuntu na beke' kamu na utaw na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tyumubag ya manga eped na Judiyu kan Jisus, “Matinaw saba ya piglong nami na utaw kaw na Samariyanen aw syeledan kaw na busaw!” ");
INSERT INTO klg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aw piglongan silan ni Jisus, “Wala' aku seledi na busaw. Pigbasa͡an ku ya kanak Ama manang pigmulamula aku mayu baling. ");
INSERT INTO klg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Beke' na tud ku na magpakadengeg sa kanak pagka-utawun. Manang ya Ama ku, yan ya magpakadengeg kanak, aw yan ya mag-ukumay. ");
INSERT INTO klg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Matinaw ya un ku paglongun kamayu: Ya utaw na dyumalug sa palna-u ku, dili' da saba matay.” ");
INSERT INTO klg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pagkatigkas yan, miglong kanan ya manga Judiyu, “Adun tengteng na kya-ede-an da nami na syeledan kaw na busaw! Pangkay si Abraham nyatay da, aw maynan uman ya manga propita, manang miglong kaw baling na kun singalan ya gayed dyumalug sa palna-u mu dili' da matay. ");
INSERT INTO klg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Unu ka', mig-anenganeng kaw na matas pa kaw kay sa tyugbulan tadun na si Abraham na nyatay da aw sa manga propita na nyangkamatay da uman? Singalan kaw ka'?” ");
INSERT INTO klg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aw tyumubag si Jisus kanilan, “Kun aku olo' ya migpakadengeg sa kanaken pagka-utawun, wala' ya guna na dengeg ku. Manang ya kanak Ama, yan ya migpakadengeg kanak. Aw piglong mayu na yan ya Tyumanem na kamayu pigpangintu-uwan. ");
INSERT INTO klg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wala' mayu ka-ede-i kun singalan sakanan. Manang aku, kya-ede-an ku sakanan. Kun maglong aku na wala' ku ka-ede-i kun singalan sakanan, na, ma-imo' aku baling galu-un kasiling mayu. Manang kya-ede-an ku ya Tyumanem aw dayaw ku pigtuman ya piglong nan. ");
INSERT INTO klg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ya kamayu tyugbulan na si Abraham, to-o sakanan migleya kay pig-iman nan na kita-en pa nan ya pagkadi ku. Aw kyinita' da nan saba, aw to-o sakanan migleya.” ");
INSERT INTO klg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aw miglong ya manga Judiyu, “Wala' pa kaw saba dateng adti kalima͡an ya umay! Pig-unu mu ka' ya pagkita' kan Abraham?” ");
INSERT INTO klg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aw miglong si Jisus kanilan, “Matinaw saba ya un ku paglongun kamayu: Sa wala' pa si Abraham ka͡utaw, awun da aku saba dadan.” ");
INSERT INTO klg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aw asuntu sa piglong ni Jisus, nyamulut silan sa manga batu kay un nilan sakanan pamintuwun. Manang nyanaw si Jisus aw migpalagaklagak dun ni kadégan na utaw aw lyumuwa' adti pamanag na Témplo. ");
INSERT INTO klg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sa pagpanaw ni Jisus, pigkita' nan ya sambuk na utaw na buta lekat pa na pagka͡utaw nan. ");
INSERT INTO klg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yanagaw nyusip ya manga umagakan nan, “Kay Magpalna-uway, ananga' yan mabuta? Kanyan sala' ya pagkabuta nan, kanan aw kana mangkatikadeng nan?” ");
INSERT INTO klg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aw tyumubag si Jisus kanilan, “Ya kanan pagkabuta beke' na asuntu na nyakasala' sakanan aw mangkatikadeng nan. Manang magi dun ni pagkabuta nan, kita-en ya katulus na Tyumanem adti kanan. ");
INSERT INTO klg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Talana na allaw pa, ka-ilangan imo-un tadun ya imo-unun na Tyumanem na migpadala kanak. Kay dili' madugay, dumateng ya kangitngitan kasiling na gabi aw dili' da makatalabahu ya pangkay singalan. ");
INSERT INTO klg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Talana ini pa aku ni tas na lupa', aku saba ya kalalamdag na maka-ilaw sa anenganeng na manga utaw.” ");
INSERT INTO klg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tigkas ni Jisus maglong, pig-eleban nan ya kutu na lupa' aw pig-imo' nan pasak. Aw pigdamus nan adti manga mata na buta, ");
INSERT INTO klg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aw piglongan nan, “Kadtu kaw adti linaw na Silo-am aw pagkulamus kaw dun.” Na, ya kakawasan na Silo-am: pigpadala. Yanagaw nyadtu ya utaw yan aw lyumiku' sakanan na dayaw da kyumita'. ");
INSERT INTO klg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na, sa pagkita' da na manga sumbalay nan aw manga dadan da kyumilala kanan, miglong silan, “Enda', yan agaw ya utaw na gayed nyingkud aw magpangilalat magsekat sa kuwalta?” ");
INSERT INTO klg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aw tyumubag ya manga eped, “E-e, yan saba sakanan!” Manang law na manga eped na utaw, “Beke' nan! Unawa olo' ya gya nilan.” Tigkas yan, miglong uman ya utaw na bagu kyumita', “Aku saba ya utaw yan!” ");
INSERT INTO klg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yanagaw pig-usip nilan sakanan, “Unu ya du-an na kyumita' da kaw?” ");
INSERT INTO klg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aw miglong sakanan, “Ya utaw na pigngalanan na si Jisus mig-imo' sa pasak aw pigdamus nan adi manga mata ku, aw pigsugu' aku nan adti linaw na Silo-am pada magkulamus. Yanagaw nyadtu aku aw sa pagkulamus ku, dayaw aku kyumita'!” ");
INSERT INTO klg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aw nyusip silan kanan, “Ayin da sakanan adun?” Tyumubag ya utaw yan, “Enday. Wala' da ku ka-ede-i.” ");
INSERT INTO klg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pagkatigkas yan, pigpa-agad nilan adti asdangan na manga Parisiyo ya utaw na buta idtu muna. ");
INSERT INTO klg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, ya pag-imo' ni Jisus sa pasak na pigdamus nan adti manga mata na buta, yan ya Allaw na Paglagdeng. ");
INSERT INTO klg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yanagaw, pig-usip na manga Parisiyo ya utaw yan, “Ananga' magkita' da kaw?” Aw piglongan nan silan, “Pigdamusan na utaw na pasak ya manga mata ku. Tigkas yan, migkulamus aku, aw dayaw da aku kyumita'.” ");
INSERT INTO klg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yanagaw miglong ya manga eped na Parisiyo, “Wala' lekat adti Tyumanem ya utaw na mig-imo' seiy. Kay wala' nan daluga ya sugu' na Tyumanem na dili' magtalabahu dun ni Allaw na Paglagdeng!” Manang miglong ya manga eped kanilan, “Kun makasasala' pa ya utaw yan, dili' nan mabatug ya manga milagru na kasiling na maynan!” Aw nyatenga' ya anenganeng nilan. ");
INSERT INTO klg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yanagaw pigpadeleg nilan ya pag-usip sa utaw na buta idtu muna, “Na, asuntu na pigpaguli' nan ya manga mata mu, unu ya kanmu anenganeng sa utaw yan?” Aw tyumubag ya utaw na baya' kyumita', “Propita sakanan!” ");
INSERT INTO klg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na, wala' pangintu-uwi na manga magdadumala͡ay sa manga Judiyu ya piglong nan na buta sakanan idtu muna aw adun magkita' da sakanan. Yanagaw pigpatawag nilan ya kanan ama aw ina ");
INSERT INTO klg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aw pig-usip nilan, “Enda', ise' mayu ya utaw ini? Unu, matinaw na buta sakanan lekat pa na pagka͡utaw nan? Kun matinaw yeiy, ananga' magkita' da sakanan adun?” ");
INSERT INTO klg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aw tyumubag kanilan ya kanan mangkatikadeng, “Tengteng saba na ise' nami sakanan aw kya-ede-an nami na buta sakanan lekat pa na pagka͡utaw nan, ");
INSERT INTO klg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","manang wala' nami ka-ede-i ya du-an na kyumita' da sakanan. Aw wala' nami uman ka-ede-i kun singalan ya migpaguli' sa manga mata nan. Usipa mayu baling sakanan! Kay unud da saba ya kanan ginawa aw mabatug da nan ya pagtubag kamayu.” ");
INSERT INTO klg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maynan ya piglong na mangkatikadeng nan kay nyallek silan sa manga magdadumala͡ay sa manga Judiyu. Kay dadan da migsambuk ya anenganeng nilan aw pigpa-ede' da nilan adti manga utaw na dili' da paseleden adti kanilan sinagoga kun singalan ya mag-ubat-ubat na si Jisus ya Misiyas. ");
INSERT INTO klg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yan ya du-an na miglong silan, “Unud da saba ya ginawa nan, usipa mayu sakanan!” ");
INSERT INTO klg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yanagaw pigpatawag pa nilan salut ya utaw na kyumita' da, aw law nilan, “Pagsapa' kaw adti asdangan na Tyumanem na ubat mu ya matinaw. Kya-ede-an da nami na makasasala' ya utaw na migpaguli' kanmu.” ");
INSERT INTO klg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aw tyumubag ya utaw yan, “Wala' ku ka-ede-i kun makasasala' sakanan aw dili'. Yan olo' ya kya-ede-an ku, idtu muna buta aku manang adun kyumita' da aku!” ");
INSERT INTO klg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aw pig-usip pa nilan, “Unu ya pig-imo' nan kanmu? Pig-unu nan ya pagpaguli' sa kanmu manga mata?” ");
INSERT INTO klg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aw tyumubag ya utaw yan, “Pig-ubatan da ta kamu! Manang wala' mayu kadi' pangintu-uwi ya pig-ubat ku. Ananga' kamu gayed gumelgel musip kanak? Unu, kaliman mayu uman na ma-imo' umagakan nan?” ");
INSERT INTO klg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","To-o silan nyadaman kanan aw pigsupla nilan sakanan, law nilan, “Umagakan kaw nan saba! Manang kami, yan ya kanami pigdalug ya palna-u ni Moysis. ");
INSERT INTO klg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kay kya-ede-an nami na si Moysis piglongan na Tyumanem asini muna. Manang ya utaw yeiy na migguli' kanmu, wala' nami ka-ede-i kun ayin sakanan lekat!” ");
INSERT INTO klg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aw tyumubag ya utaw yan kanilan, “Nyabelengbeleng aku! Pigpaguli' nan ya manga mata ku manang wala' mayu ka-ede-i kun ayin sakanan lekat! ");
INSERT INTO klg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nya-ede' kitadun na dili' pakanyegan na Tyumanem ya manga makasasala'. Manang pangkay singalan ya migsimba kanan aw mig-imo' sa pagkaliman nan, pakanyegan nan saba sakanan. ");
INSERT INTO klg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lekat pa na pagka-imo' na kadakula' na banwa, wala' pa ya dyengeg tadun na kasiling ku na kyumita' da. ");
INSERT INTO klg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kun ya utaw yan wala' lekat adti Tyumanem, na, dili' nan galu mabatug ma-imo' ya kasiling na maynan!” ");
INSERT INTO klg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Manang tyumubag silan, “Unu ka', nyaka-eles kaw migpalna-u kanami? Makasasala' kaw saba lekat pa na pagka͡utaw mu!” Aw tigkas yan, miglong pa silan kanan, “Dili' da kaw makaseled adti manga sinagoga nami!” ");
INSERT INTO klg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sa pagdengeg ni Jisus na dili' da paseleden ya utaw yan na manga magdadumala͡ay sa manga Judiyu adti sinagoga nilan, yanagaw pyaninaw sakanan ni Jisus. Aw sa pagkita' da nan, pig-usip nan, “Unu, pyangintu-uwan da mu ya Ise' na Utaw?” ");
INSERT INTO klg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aw tyumubag sakanan, “Ubati aku kay Sir kun singalan sakanan, pada mangintu-u aku kanan.” ");
INSERT INTO klg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aw miglong si Jisus, “Kyinita' da mu saba sakanan aw yan ya migbalawbalaw kanmu adun.” ");
INSERT INTO klg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aw miglong ya utaw yan, “Kay Pangulu, nyangintu-u la aku kanmu!” Aw lyumuhud sakanan aw pigsimba nan si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aw miglong si Jisus kanan, “Nyadi aku asini tas na lupa' na un mag-ukum sa manga utaw. Kay ya manga utaw na wala' paka-ede' sa Tyumanem, kasiling silan na buta, aw ilawan ku ya anenganeng nilan. Manang ya manga utaw na iman nilan aw nyaka-ede' silan sa Tyumanem, masiling silan baling na buta.” ");
INSERT INTO klg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na, awun manga Parisiyo na malapit dun na nyakadengeg sa piglong ni Jisus, aw pig-usip nilan sakanan, “Unu ya kakawasan na piglong mu? Unu, kasiling kami uman na buta?” ");
INSERT INTO klg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aw tyumubag si Jisus kanilan, “Kun buta pa kamu, wala' galu ya un pagsala' kamayu. Manang miglong kamu na ‘Dayaw nami kyalabetan ya kadég.’ Yanagaw, kenne' pa na sala' mayu.” ");
INSERT INTO klg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Migpadeleg si Jisus miglong adti manga Parisiyo, law nan, “Matinaw ya un ku paglongun kamayu: Kun awun utaw na sumeled adti pigtorilan sa manga karniro manang ya pagseled nan wala' sakanan agi adti gisakan manang nyanik baling adti alad, ya utaw yeiy matakaw aw tulisan sakanan. ");
INSERT INTO klg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Manang ya magi dun ni gisakan, yan ya magdadiyaga͡ay sa manga karniro. ");
INSERT INTO klg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Asuntu na yan ya magdadiyaga͡ay, uwangan kanan na magtatunggu-ay ya tatakep. Aw sa pagtawag nan sa ngalan na tagsambuksambuk na karniro nan, kilala͡en nilan ya kanan tingeg, aw dayaw nan silan alladan adti luwa' na toril. ");
INSERT INTO klg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aw sa pagluwa' da na kadég na karniro nan, magma-una sakanan kanilan. Aw dumalug silan kanan kay kyilala nilan ya tingeg nan. ");
INSERT INTO klg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Manang dili' silan dumalug sa eped na utaw kay wala' nilan kilala͡a ya tingeg. Mampamalaguy baling silan.” ");
INSERT INTO klg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeiy ya pundinganan na piglong ni Jisus kanilan, manang wala' na manga Parisiyo kalabeti ya kakawasan. ");
INSERT INTO klg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yanagaw miglong pa si Jisus kanilan, “Matinaw ya un ku paglongun kamayu: Aku ya palangad gisakan dun ni pigtorilan sa manga karniro. ");
INSERT INTO klg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Madég ya manga magpalna-uway sa galu' na nyuna kanak aw kasiling silan na manga mangkatakaw aw tulisan. Manang ya kanaken manga karniro wala' pagpakanyeg kanilan. ");
INSERT INTO klg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku ya gisakan. Ya taman na sumeled magi kanak, paluwa-en na Tyumanem. Lumuwa' aw sumeled na wala' ya kakallekan nilan kay malinaw ya banwa aw makakan silan dun ni madyaw na panabtabanan. ");
INSERT INTO klg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ya matakaw, yan olo' ya tud nan ya tumakaw aw kaliman nan magpatay aw magkalat. Manang yan baling ya kanak pigkadi asini tas na lupa' na atagan ya manga utaw sa ginawa na wala' ya katigkasan aw sa manga kadyawan na wala' ya maka-unawa. ");
INSERT INTO klg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku ya madyaw na magdadiyaga͡ay sa manga karniro. Kay ya madyaw na magdadiyaga͡ay, gayed nan pagpan ya kanan pagka-utawun pada katamengan ya manga karniro nan. ");
INSERT INTO klg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ya magtatunggu-ay na pigtandanan, dili' sakanan kasiling na magdadiyaga͡ay na tagtun sa manga karniro. Kay kun kita-en nan ya malyaw na idu' na to-o mabulut na magpasinan adti kanan, maksay sakanan malaguy aw ayawan nan ya manga karniro. Aw belbelen na malyaw na idu' ya manga karniro, aw ya eped magpanbeklag silan aw magpangkabuluy. ");
INSERT INTO klg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Malaguy ya pigtandanan kay beke' nan ya tagtun aw wala' ya kakaypengan nan sa manga karniro na pigtunggu-an nan. ");
INSERT INTO klg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Manang aku ya madyaw na magdadiyaga͡ay sa manga karniro. Kya-ede-an ku ya kanak manga karniro aw kya-ede-an aku nilan uman, ");
INSERT INTO klg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kasiling saba na nya-ede' ya Ama kanak aw aku uman nya-ede' kanan. Aw gayed ku pigpan ya kanaken pagka-utawun pada katamengan ku ya kanak manga karniro. ");
INSERT INTO klg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na, awun pa uman manga eped na karniro ku na wala' pa asini toril ini. Ka-ilangan ku gagaden silan uman adti seled. Magpakanyeg silan kanak, aw ya kadég na magpakanyeg kanak, ma-imo' silan sambuk na ugbungan na sambuk olo' ya magdadiyaga͡ay kanilan. ");
INSERT INTO klg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Aw yan ya du-an na pigginawa͡an aku na Ama, kay pig-atag ku ya kanak pagka-utawun kanilan pada mataw aku lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wala' ya utaw na makabaya' sa pagkamatay ku. Manang awun katundanan ku lekat adti Ama na atag ku ya kanak pagka-utawun na un dugsu', aw awun uman kanak katundanan sa pagkataw ku lekat adti pagkamatay. Yeiy ya sugu' na kanak Ama na un ku tumanen.” ");
INSERT INTO klg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yanagaw asuntu sa piglong ni Jisus, nyatenga' da uman ya anenganeng na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Madég kanilan ya miglong, “Ya utaw yan, pigseledan saba na busaw! Migkameneng sakanan. Ananga' gayed pa kamu magpakanyeg kanan?” ");
INSERT INTO klg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Manang awun manga eped na miglong, “Ya palna-u yeiy beke' na kana utaw na pigseledan na busaw. Unun na busaw ya pagpaguli' sa utaw na buta?” ");
INSERT INTO klg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, dyumateng da ya Pista na Paglinis sa Témplo adti Jérusalim, aw yan ya timpu na maniki'. ");
INSERT INTO klg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Aw migpanawpanaw si Jisus adti Portiko ni Solomon dun ni pamanag na Témplo. ");
INSERT INTO klg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Talana nan dun, nyaluduk adti kanan ya manga magdadumala͡ay sa manga Judiyu, aw miglong silan, “Kinunu pa kaw paglong kanami kun singalan kaw? Kun ikaw ya Misiyas, bangala la adun adti kanami!” ");
INSERT INTO klg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aw tyumubag si Jisus kanilan, “Pig-ubat da ku kamayu manang wala' kamu pangintu-u. Ya manga milagru na pig-imo' ku magi sa ngalan na kanak Ama, yan ya migmatinaw kun singalan aku. ");
INSERT INTO klg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Manang wala' kamu pangintu-u kanak kay beke' kamu na kanak manga karniro. ");
INSERT INTO klg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kay ya kanak manga karniro magpakanyeg silan sa kanak tingeg, aw nya-ede' aku kanilan aw dyumalug silan sa piglong ku. ");
INSERT INTO klg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aw pig-atagan ku silan na ginawa na wala' ya katigkasan. Aw dili' silan ka-eletan lekat adti kanak kay wala' ya sambuk na makakamang kanilan lekat adi kanak. ");
INSERT INTO klg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pig-atag da silan kanak na Ama ku, aw dakula' pa ya katulus nan kay sa kadég. Wala' ya pangkay singalan na makakamang kanilan lekat adti Ama. ");
INSERT INTO klg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kay ya Ama aw aku sambuk da saba.” ");
INSERT INTO klg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagpakadengeg na manga magdadumala͡ay sa manga Judiyu sa piglong ni Jisus, to-o silan nyadaman aw nyampamulut silan sa manga batu na un galu nilan pamintuwun menda' na matay sakanan. ");
INSERT INTO klg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Manang miglong si Jisus kanilan, “Kyinita' da mayu saba ya madég na pig-imo' ku na to-o madyaw na lyumekat adti Ama. Ayin ya pig-imo' ku na du-an na un aku mayu bintuwun?” ");
INSERT INTO klg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aw miglong ya manga magdadumala͡ay sa manga Judiyu, “Dili' kaw nami bintuwun sa pig-imo' mu na madyaw, manang asuntu na migpa-unawa kaw sa Tyumanem. Utaw kaw saba olo'!” ");
INSERT INTO klg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aw miglong si Jisus kanilan, “Enda', nyasulat dun ni Uldin mayu na miglong ya Tyumanem na ‘manga tyumanem kamu.’ ");
INSERT INTO klg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kya-ede-an tadun saba na ya pigpasulat na Tyumanem alag matinaw. Kun miglong ya Tyumanem seiy adti manga tyugbulan mayu, aw kun silan ya muna nyakadawat sa ubat-ubat nan, na, ");
INSERT INTO klg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","unu ya indeganan na diklamu mayu kanak na migpa-unawa aku sa Tyumanem? Kun piglong na Tyumanem adti manga tyugbulan ya maynan, na, ananga' migdiklamu kamu kanak asuntu na miglong aku na ‘Ise' aku na Tyumanem na pigtani nan aw pigpadala nan asini tas na lupa'’? ");
INSERT INTO klg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kun wala' ku imo-a ya manga imo-unun na kanake' Ama, dili' aku mayu umba' pangintu-uwan. ");
INSERT INTO klg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Manang pig-imo' ku saba ya imo-unun na Ama ku. Yanagaw, pangkay wala' kamu pangintu-u sa piglong ku, anenganengen mayu galu ya manga puliba na manga pigpan-imo' nan pada ka-ede-an aw kalabetan mayu na aku aw ya Ama sambuk da.” ");
INSERT INTO klg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sa pagdengeg nilan seiy, kaliman nilan uman dakepen sakanan manang wala' nilan sakanan kasalinapi. ");
INSERT INTO klg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aw lyumiku' salut si Jisus adti dipag na tubig na Jordan adti banwa na pigba͡utismuwan ni Juan idtu muna. Aw dun pa sakanan katingen. ");
INSERT INTO klg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aw nyangkadtu ni kanan ya madég na manga utaw. Aw migbalawbalaw silan na maglong, “Wala' pag-imo' si Juan sa manga milagru manang alag matinaw ya kadég na pig-ubat nan kanaten sa utaw yeiy na si Jisus.” ");
INSERT INTO klg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aw dun ni banwa yan, awun madég na manga utaw na nyangintu-u la kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na, awun utaw na pigngalanan si Lazaro. Nyeya' sakanan adti baranggay na Bétaniya, aw matigda' sakanan. Aw dun uman pag-eya' ya manga bubay nan na si Maria aw si Marta. ");
INSERT INTO klg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na, ya Maria yeiy, yan ya un mag-asag kagaya sa manimbo' adti manga siki ni Jisus aw galisan nan na kanan lugay. Aw ya kanan inulug na si Lazaro, yan ya to-o kyatigda-an. ");
INSERT INTO klg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yanagaw pigpatugun na manga bubay nan si Jisus na maglong, “Kay Magpalna-uway, ya ubaybay mu na kanmu pigginawa͡an to-o kyatigda-an.” ");
INSERT INTO klg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aw sa pagdengeg ni Jisus sa ubat-ubat yeiy, miglong sakanan, “Ya tengteng na sampetan na kanan magkedel beke' na matay sakanan manang dun baling kita-a ya katulus na Ama aw magi dun madeyen ya Ise'.” ");
INSERT INTO klg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, alag pigginawa͡an ni Jisus si Marta aw si Maria aw si Lazaro. ");
INSERT INTO klg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yanagaw, pangkay dyengeg da ni Jisus na kyatigda-an si Lazaro, manang nyatingen pa sakanan adti pig-eya-an nan seled na duwangallaw. ");
INSERT INTO klg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagkatigkas yan, miglong si Jisus adti manga umagakan nan, “Lumiku' kitadun adti Judiya.” ");
INSERT INTO klg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Manang law nilan, “Kay Magpalna-uway, bagu pa kaw saba pigbantakan na manga magdadumala͡ay sa manga Judiyu na bintuwun na batu. Aw kenne' pa nilan nyaninaw kanmu. Ananga' kaliman mu lumiku' adti Judiya?” ");
INSERT INTO klg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aw miglong si Jisus kanilan, “Enda', sampulu tag duwa ya udas kada allaw? Yanagaw kun ya utaw manaw na allaw, dili' sakanan pagsungkul asuntu na malalamdag pa ya banwa. ");
INSERT INTO klg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Manang ya utaw na nyanaw na gabi, pagsungkul sakanan kay wala' ya kalalamdag na nyaka-ilaw kanan.” ");
INSERT INTO klg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagkatigkas yan, piglongan pa nan silan, “Nyakatulug da ya ubaybay tadun na si Lazaro. Manang adtu aku kay un ku sakanan pukawun.” ");
INSERT INTO klg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aw miglong ya manga umagakan nan, “Kay Magpalna-uway, kun nyakatulug sakanan, kaguli-an da.” ");
INSERT INTO klg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na, iman nilan aw nyakatulug olo' si Lazaro manang ya pyalabet ni Jisus na nyatay da sakanan. ");
INSERT INTO klg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yanagaw pigbangal ni Jisus kanilan, law nan, “Nyatay da si Lazaro. ");
INSERT INTO klg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Manang migleya aku asuntu kamayu na wala' aku dun ni pagkamatay nan. Kay kaliman ku na pakasaligen pa ya pagpangintu-u mayu. Na, kadtuwan tadun sakanan!” ");
INSERT INTO klg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pagkatigkas yan, miglong si Tomas adti manga eped nan na umagakan, “Magad kitadun kanan pangkay patayen kitadun eped nan.” Na, si Tomas pigtawag uman na Pingin. ");
INSERT INTO klg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na, pagdateng da ni Jisus adti Bétaniya, dyengeg nan na upatengallaw pa lekat na paglebeng kan Lazaro. ");
INSERT INTO klg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ya kawat na baranggay na Bétaniya lekat adti Jérusalim manga tulungka kilomitro, ");
INSERT INTO klg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","aw madég ya nyawun na manga utaw na Judiyu pada maglala kan Marta aw si Maria asuntu sa pagkamatay na inulug nilan. ");
INSERT INTO klg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aw sa pagdengeg ni Marta na migpasinan da dun si Jisus, pigsungun nan sakanan. Manang si Maria kenne' nan nyingkud dun ni balay nilan. ");
INSERT INTO klg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Aw sa pagkita' ni Marta kan Jisus, piglongan nan sakanan, “Kay Magpalna-uway, kun nyadi pa kaw beg galu, dili' matay ya inulug ku. ");
INSERT INTO klg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Manang nya-ede' aku na pangkay adun atag saba na Tyumanem kun unu ya sekaten mu adti kanan.” ");
INSERT INTO klg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aw miglong si Jisus kanan, “Mataw pa saba ya inulug mu.” ");
INSERT INTO klg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tyumubag si Marta, “Kya-ede-an ku na mataw sakanan adti kamoliyan na allaw sa pagmataw na Tyumanem sa kadég na nyangkamatay.” ");
INSERT INTO klg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pagkatigkas yan, miglong si Jisus kanan, “Aku ya magpakamataw sa utaw na nyatay, aw aku uman ya mag-atag sa ginawa na wala' ya katigkasan. Kun singalan ya mangintu-u kanak, pangkay matay pa sakanan manang mataw pa uman salut. ");
INSERT INTO klg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aw pangkay singalan ya nyangintu-u aw syumalig kanak, matagtun nan saba ya ginawa na wala' ya katigkasan. Unu, nyangintu-u kaw sa piglong ku yeiy?” ");
INSERT INTO klg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aw tyumubag si Marta kanan, “E-e, kay Magpalna-uway! Nyangintu-u aku na ikaw ya Misiyas na Ise' na Tyumanem na pigpakang na un dumateng asini tas na lupa'!” ");
INSERT INTO klg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkatigkas ni Marta maglong seiy, lyumiku' sakanan adti balay aw pigtumantumanan nan ya mangud nan na si Maria, law nan, “Ya Magpalna-uway malapit da dumateng asini. Kaliman nan magbalawbalaw kanmu.” ");
INSERT INTO klg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagdengeg ni Maria, maksay sakanan nyindeg aw nyadtu ni kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na, wala' pa si Jisus dateng adti baranggay manang kenne' pa nan adti banwa na pigsungunan kanan ni Marta. ");
INSERT INTO klg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Manang ya manga Judiyu na miglala kan Maria, sa pagkita' nilan na nyindeg da sakanan aw maksay lyumuwa', pigdalug nilan kay iman nilan aw madtu sakanan ni piglebengan kan Lazaro na un magsugaw. ");
INSERT INTO klg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagdateng ni Maria adti kan Jisus, lyumuhud sakanan adti asdangan nan, aw law nan, “Kay Magpalna-uway, kun asini pa kaw beg galu, dili' matay ya inulug ku.” ");
INSERT INTO klg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aw sa pagkita' ni Jisus na to-o migsugaw si Maria aw migsugaw uman ya manga Judiyu na dyumalug kanan, nyatangkeg ya anenganeng nan aw migkalat to-o ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aw nyusip si Jisus kanilan, “Ayin mayu sakanan lebengan?” Aw tyumubag silan kanan, “Kay Magpalna-uway, agad kaw kanami adti piglebengan kanan aw tanawa.” ");
INSERT INTO klg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aw migsugaw si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yanagaw miglong ya manga Judiyu na nyagad dun, “Inunuwa mayu sa kadakula' na pagginawa nan kan Lazaro.” ");
INSERT INTO klg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Manang miglong ya manga eped kanilan, “Pigguli' nan ya manga mata na utaw na buta, na, ananga' wala' nan katageni ya pagkamatay ni Lazaro?” ");
INSERT INTO klg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pagdateng ni Jisus adti ilib na piglebengan sa lawas ni Lazaro, to-o pa migkalat ya ginawa nan. Na, awun dakula' na batu na pigtampeng sa gawang na ilib. ");
INSERT INTO klg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yanagaw miglong si Jisus adti manga Judiyu dun, “Angginan mayu ya batu!” Manang miglong si Marta, “Kay Magpalna-uway, upatenggabi pa ya lawas nan dun ni seled na ilib! Kun uwangan nilan, malu' da.” ");
INSERT INTO klg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aw miglong si Jisus, “Unu, kyalingawan da mu ya piglong ku kanmu kakayna? Kun sumalig kaw kanak, kita-en mu ya katulus na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yanagaw pig-anggin nilan ya batu na pigtampeng sa gawang. Aw tigkas yan, lyumangad si Jisus adti langit aw nyanawagtawag adti Tyumanem, law nan, “Kay Ma', migpasalamat aku kanmu kay pigpakanyegan aku mu. ");
INSERT INTO klg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nya-ede' aku na gayed kaw migpakanyeg kanak. Manang piglong ku yeiy asuntu sa manga utaw na nyakapalibed kanake' pada mangintu-u silan na ikaw ya migpadala kanak asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkatigkas yan, pigtawag ni Jisus si Lazaro sa mabagseg na tingeg, “We....Lazaro! Luwa' kaw adi!” ");
INSERT INTO klg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aw lyumuwa' ya nyatay lekat adti piglebengan kanan. Aw kenne' pa na bedbed na téla dun ni manga bekten aw siki nan aw ulu nan. Aw miglong si Jisus kanilan, “Kamanga mayu ya pigbedbed kanan aw papanawa mayu!” ");
INSERT INTO klg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yanagaw, ya manga utaw na Judiyu na dyumalug kan Maria adti lebeng, kyinita' nilan ya pig-imo' ni Jisus. Aw madég kanilan ya nyangintu-u kanan. ");
INSERT INTO klg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Manang awun eped kanilan na nyadtu adti manga Parisiyo aw pigdandan nilan ya pig-imo' ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yanagaw ya mangkatas na manga magdadugsu-ay dun ni Témplo aw manga Parisiyo, pigpatawag nilan ya eped nilan pada magkatipun dun ni usayanan. Aw pigbalawbalawan nilan kun unu ya madyaw imo-un, law nilan, “Unu ya imo-un tadun? Madég to-o ya manga milagru na pig-imo' na utaw yan! ");
INSERT INTO klg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kun pabaya-an tadun sakanan, pagaw pangintu-uwan baling sakanan na manga utaw! Aw kun ma-imo' yeiy, sulungun kitadun na to-o madég na sundalu na Romanen aw kalaten nilan ya kanaten Témplo aw ya banwa tadun!” ");
INSERT INTO klg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Manang miglong ya sambuk kanilan na si Kaypas, “Wala' ya kyataga͡an mayu!” Na, dun ni umay yan, si Kaypas ya pangulu na manga magdadugsu-ay. ");
INSERT INTO klg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aw migpadeleg sakanan miglong, “Unu, wala' mayu anenganenga? Madyaw pa na sambuk olo' kanaten ya matay asuntu sa manga Judiyu kay sa apnasen ya kadég na manga utaw asini nasud tadun!” ");
INSERT INTO klg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, ya piglong yeiy ni Kaypas beke' na kanan pagbaya', manang nyakapaglong sakanan sa maynan kay pangulu sakanan na manga magdadugsu-ay dun ni umay yan. Aw yanagaw magi kanan pigpa-ede' na Tyumanem na un matay si Jisus pada paluwa-en ya kanan manga kadégan na Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aw beke' nilan olo' manang asuntu uman sa manga eped na un pa mangintu-u, pada sambukun ya kadég na ma-imo' utaw na Tyumanem na nyeya' adti madég na manga eped na nasud. ");
INSERT INTO klg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yanagaw lekat dun ni allaw yan, pigbantakan si Jisus na manga magdadumala͡ay sa manga Judiyu na patayen. ");
INSERT INTO klg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aw ya syampetan nan, wala' da si Jisus pagpakita' dun ni madég na manga utaw na Judiyu. Pig-indegan nan ya Jérusalim aw nyadtu sakanan ni banwa na malapit adti kaligbinan, dun ni lunsud na Éprayim. Aw nyatingen pa dun eped nan ya kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na, agpet da ya Pista na Paglabay na Anghil na Tyumanem. Yanagaw madég ya manga Judiyu na lekat adti kanilan manga banwa na tyumukud pasinan adti Jérusalim, pada linisan ya kanilan lawas kay yan ya kanilan katanem sa dili' pa dumateng ya gabi sa pagpalekat na Pista. ");
INSERT INTO klg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pagdateng nilan, gayed nilan pyaninaw si Jisus dun ni pamanag na Témplo. Aw gayed silan mig-usip-usipay, law nilan, “Unu ya kamayu anenganeng? Enda', dili' gya sakanan madi ni Pista?” ");
INSERT INTO klg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na, ya manga mangkatas na magdadugsu-ay dun ni Témplo aw manga Parisiyo, kaliman nilan dakepen si Jisus, yanagaw dadan da silan mig-imo' sa bala-ud na kun singalan ya maka-ede' kun ayin apit si Jisus, ubat nan kanilan. ");
INSERT INTO klg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, dakman enemengallaw magpalekat da ya Pista na Paglabay na Anghil na Tyumanem. Nyadtu si Jisus adti Bétaniya na pig-eya-an ni Lazaro na pigmataw nan lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aw pigtagilanan nilan si Jisus na pangiyambungay. Si Lazaro ya sambuk na kyuman dun ni sayid ni Jisus aw si Marta ya migsanggila' kanilan. ");
INSERT INTO klg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aw kyumamang si Maria sa tenga' ya litro na manimbo' na wala' ya nyakadali' na pigngalanan na nardo, aw dakula' to-o ya alaga'. Aw pig-asagan nan ya siki ni Jisus aw piggalisan nan na kanan lugay. Aw nyalegeb na kanimbo' ya seled na balay. ");
INSERT INTO klg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aw dun uman ya sambuk na umagakan ni Jisus na si Judas Iskariyoti, na yan ya un maglubid kanan. Sa pagkita' nan sa pig-imo' ni Maria, miglong sakanan, ");
INSERT INTO klg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ananga' wala' baling galina ya manimbo' iyan aw ya kuwalta atag galu adti manga utaw na wala' ya pagkamangan? Ya alaga' nan maka-umba' saba sa sangka͡umay na utaw talabahuwan!” ");
INSERT INTO klg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Piglong yeiy ni Judas beke' na asuntu na nyallat sakanan sa manga wala' ya pagkamangan, manang asuntu na matatilu' sakanan. Kay yan ya pigtaliguwan sa kuwalta na manga umagakan ni Jisus manang gayed nan pag-uwa-an. ");
INSERT INTO klg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aw tyumubag si Jisus kan Judas, “Pabaya-i la sakanan. Padayawan da kanan ya nyasama' na manimbo' pada pagtagilan dun ni allaw na paglebeng kanak. ");
INSERT INTO klg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ya manga utaw na wala' ya pagkamangan gayed mayu pig-iyeped. Manang aku dili' madugay asini sayid mayu.” ");
INSERT INTO klg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pagdengeg na madég to-o na manga utaw na Judiyu na nyawun si Jisus adti Bétaniya, nyadtu uman silan. Aw ya kanilan pagkadtu beke' olo' ni Jisus, manang peles nilan uman tanawun si Lazaro na pigmataw ni Jisus lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yanagaw migkatipun ya manga mangkatas na magdadugsu-ay adti Jérusalim aw pigbalawbalawan nilan na patayen uman si Lazaro, ");
INSERT INTO klg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kay madég ya manga Judiyu na wala' da dalug kanilan kay nyangintu-u la silan kan Jisus asuntu na pigmataw nan si Lazaro. ");
INSERT INTO klg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na, madég to-o ya manga utaw na dyumateng adti Jérusalim na un tumambung sa Pista na Paglabay na Anghil na Tyumanem. Pagkasalut na allaw, dyengeg nilan na migpasinan da si Jisus adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yanagaw nyan-utud silan sa palwa na manga palma aw pigsungun nilan si Jisus. Migpansileya silan aw migpan-iyak-iyak na miglong, “Hosanna! Ini la ya Pigpadala na Tyumanem dun ni kanan ngalan. Yeiy ya Hari' na Isra-él aw umba' sakanan deyen!” ");
INSERT INTO klg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na, dadan da kyinita' ni Jisus ya sambuk na nati na asnu, aw yan ya pigsakayan nan pasinan adti Jérusalim. Aw nyatuman da ya pigpasulat na Tyumanem asini muna: ");
INSERT INTO klg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kamu na manga utaw na taga Jérusalim, dili' kamu magkallek. Tanawa! Dyumateng da ya hari' mayu na syumakay sa nati na asnu!” ");
INSERT INTO klg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Idtu muna, wala' pa na manga umagakan nan kalabeti ya kakawasan na kadég yeiy na nyangka-imo'. Manang dun ni pagliku' ni Jisus adti tas na langit, dun da nilan ka-anenganengi na ya kadég yeiy pigpasulat dadan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Madég ya manga utaw na nyagad kan Jisus lekat adti Bétaniya aw silan ya kyumita' sa pagtawag nan kan Lazaro lekat adti lebeng aw ya pagmataw kanan. Aw silan uman ya gayed mig-ubat-ubat sa manga nya-imo' ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aw yeiy ya du-an na syumungun kan Jisus ya madég pa na utaw kay kyadenggan nilan ya ubat-ubat sa pig-imo' nan na milagru. ");
INSERT INTO klg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yanagaw migbalawbalaw ya manga Parisiyo, law nilan, “Inunuwa mayu! Dili' da naten mabanggang ya kadég na manga utaw na dyumalug da kanan!” ");
INSERT INTO klg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na, awun uman manga utaw na Grigo na dyumateng dun ni Jérusalim na un tumambung sa pista pada magsimba sa Tyumanem adti Témplo. ");
INSERT INTO klg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aw dyumulud silan kan Pilipi na taga Bétsayda, sakup na Galilya. Aw miglong silan kanan, “Kay Sir, kaliman nami galu kilala͡en si Jisus.” ");
INSERT INTO klg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piglongan ni Pilipi si Andrés sa tud nilan, aw migdengan silan nyadtu ni kan Jisus aw piglongan nilan sakanan. ");
INSERT INTO klg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aw yanagaw miglong si Jisus, “Dyumateng da ya udas na patasen ya dengeg na Ise' na Utaw. ");
INSERT INTO klg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Matinaw saba ya piglong ku kamayu: Wala' ya un ma-untung adti sambuk na bini' na trigu kun dili' matanem. Manang kun matanem una dun ni lupa' aw malandak, dili' madugay gumiti' aw tumulin menda' na to-o mamunga. ");
INSERT INTO klg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kun singalan ya gyuminawa sa kanan pagka-utawun asini tas na lupa', kalagakan baling sa ginawa nan. Manang kun singalan ya magtibulluk dumalug kanak pangkay pa adti pagkamatay, matagtun nan ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aw pangkay singalan ya malim ma-imo' kanak sugu-anen, una sakanan dumalug kanak, kun ayin aku, adtu uman sakanan. Aw kun singalan ya magtuman sa manga sugu' ku, pakadyawun uman na kanak Ama. ");
INSERT INTO klg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Na, madég ya kakaypengan ku. Manang unu, paglongun ku ya kanak Ama na paluwa-en aku nan galu lekat adti kanak pagti-is na un ku ka-agiyan? Dili' saba! Kay yeiy ya du-an na dyumateng aku asini udas ini, na un matuman ya pagkaliman nan.” ");
INSERT INTO klg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aw miglong pa si Jisus adti Ama nan, “Kay Ma', pakita͡an beg ya kanmu pagka Tyumanem adti manga utaw.” Aw awun tingeg na lyumekat adti tas na langit na miglong, “Abus da ku pakita͡an ya pagka Tyumanem ku, aw pakita' pa ku uman salut.” ");
INSERT INTO klg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na, madég ya manga utaw na mig-indeg-indeg na malapit dun, aw dyengeg nilan ya tingeg yan, aw law nilan, “Migdadaneng!” Manang miglong ya manga eped, “Pagaw piglongan sakanan na anghil!” ");
INSERT INTO klg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Manang miglong si Jisus kanilan, “Beke' ku ya pigpadengeg na Tyumanem sa tingeg nan, kamu saba ya pigpadenggan nan. ");
INSERT INTO klg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Migpalekat da ya pag-ukum sa manga utaw asini tas na lupa', aw degen da uman ya pagdumala ni Satanas sa kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aw sa pagkalabu la kanak adti krus, paduludun ku ya kadég na manga utaw adi kanak aw mangintu-u silan.” ");
INSERT INTO klg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aw dun ni paglong ni Jisus, pigpa-ede' nan kun unu ya un nan ka-agiyan na pagti-is sa pagkamatay nan. ");
INSERT INTO klg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yanagaw miglong ya madég na manga utaw, “Pigsulat dun ni Uldin tadun na wala' ya tyamanan na pagdumala na Misiyas. Ananga' kaw maglong na ka-ilangan matay ya Ise' na Utaw adti krus? Singalan ka' utawa ya pigpalabet mu na Ise' na Utaw?” ");
INSERT INTO klg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aw miglong si Jisus kanilan, “Ini pa ni kamayu ya kalalamdag manang dili' da magkadugay. Talana na asini pa, pangintu-uwi mayu pagaw kasaban kamu na kangitngitan. Kay ya utaw na nyanaw dun ni mangitngit, wala' nan ka-ede-i kun ayin sakanan pasinan. ");
INSERT INTO klg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yanagaw talana ini pa aku ni sayid mayu, pangintu-uwi mayu na aku ya kalalamdag pada ma-imo' kamu manga utaw na kalalamdag.” Pagkatigkas ni Jisus maglong seiy, malakwat da sakanan pagkita-en adti madég na manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pangkay madég da ya milagru na pigpakita' nan kanilan, manang wala' silan pangintu-u kanan. ");
INSERT INTO klg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yanagaw nyatuman da ya pigpasulat na Tyumanem magi sa propita nan na si Isayas, law nan, “Kay Tyumanem, singalan ka' ya nyangintu-u sa pag-ubat-ubat nami? Aw singalan manga utawa ya pigpakita-an da mu sa kanmu katulus?” ");
INSERT INTO klg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yan ya du-an na wala' nilan kabatug ya pagpangintu-u, kasiling na pigpasulat uman kan Isayas, law nan, ");
INSERT INTO klg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pigtampeng na Tyumanem ya kanilan mata pada dili' nilan kita-en ya katinawan. Aw pigpakategel nan ya kanilan anenganeng pada dili' nilan kalabetan ya ubat-ubat ku, kay kun kalabetan nilan pagaw magselsel silan, aw lanasen ku ya manga sala' nilan.” ");
INSERT INTO klg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Piglong yeiy ni Isayas asini muna kay dadan da pigpakita' kanan ya katulus na pagka Tyumanem ni Jisus na yan ya pigkasampetan nan. ");
INSERT INTO klg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pangkay maynan ya piglong ni Isayas, manang awun pa uman madég na manga Judiyu na nyangintu-u kan Jisus. Pangkay adti manga migdumala, awun eped na nyangintu-u la kanan, manang asuntu na nyallek silan sa manga eped na Parisiyo, wala' nilan pa-ede-an pagaw alilinan silan lekat adti manga sinagoga. ");
INSERT INTO klg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kay to-o nilan pigkaliman na saya' silan na manga utaw kay sa katutukan ya Tyumanem kanilan. ");
INSERT INTO klg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na, miglong si Jisus magi sa mabagseg na tingeg adti madég na manga utaw na migkatipun dun, law nan, “Pangkay singalan ya mangintu-u kanak, pangintu-uwan nan uman ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aw kun singalan ya kyumita' kanak, kyinita' nan uman ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nyadi aku asini tas na lupa' na un mag-ilaw sa anenganeng na manga utaw. Aw ya utaw na mangintu-u kanak, wala' da sakanan adti kangitngitan. ");
INSERT INTO klg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kun awun nyakadengeg sa ubat-ubat ku aw pigpalipaslipasan nan, dili' aku ya mag-ukum kanan. Yan saba ya kanak pigkadi ya pagpaliku' sa manga utaw adti Tyumanem. Aw beke' na kanak tud ya pag-ukum. ");
INSERT INTO klg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Manang ya utaw na gayed kyumele kanak aw dili' dumawat sa palna-u ku, ya manga tingeg na pig-ubat-ubat ku, yan ya mag-ukum kanilan kagaya adti kamoliyan na manga allaw. ");
INSERT INTO klg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kay ya pigpalna-u ku, wala' lekat adi kanake', manang lyumekat adti Ama na migpadala kanak. Aw yeiy ya migsugu' kanak kun unu ya un ku palna-u. ");
INSERT INTO klg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aw kya-ede-an ku na ya palna-u na pigsugu' nan kanak, yan ya maggagad sa utaw adti ginawa na wala' ya katigkasan. Yanagaw ya kadég na piglong ku kamayu, alag yeiy lekat adti Ama.” ");
INSERT INTO klg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sa wala' pa dateng ya Pista na Paglabay na Anghil na Tyumanem, nya-ede' si Jisus na malapit da ya allaw na pag-indeg nan asini tas na lupa' aw ya pagliku' nan adti tampid na Ama. To-o nan pigginawa͡an ya kanan manga umagakan aw pigpakita' nan kanilan ya kanan pagginawa na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pagkagabi yan, nyangiyambung si Jisus aw ya kanan manga umagakan. Na, pigbetang dadan ni Satanas adti anenganeng ni Judas Iskariyoti na ise' ni Simon na lubidan nan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nya-ede' si Jisus na pig-atag da na Ama kanan ya katundanan sa kadég. Nya-ede' uman na lekat sakanan adti Tyumanem aw un lumiku' adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yanagaw, talana nilan nyangiyambung, nyindeg si Jisus aw pigluwas nan ya sa-ul nan na malawig aw kyumamang sa dakula' na tuwalya aw pangawakan nan. ");
INSERT INTO klg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagkatigkas yan, kyumamang si Jisus sa palanggana aw pigseledan nan na tubig. Aw pigpalekat nan ya pag-ugas sa manga siki na tagsambuksambuk na umagakan nan aw piggalisan nan uman na tuwalya na pigpangawak nan. ");
INSERT INTO klg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aw sa pagdateng nan adti kan Simon Pédro, miglong si Pédro, “Kay Magpalna-uway, unu, ugasan mu uman ya kanak manga siki?” ");
INSERT INTO klg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aw tyumubag si Jisus kanan, “Adun, dili' pa mu yeiy kalabetan ya pig-imo' ku. Manang dili' madugay, kalabetan da mu.” ");
INSERT INTO klg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aw miglong ni Pédro, “Kay Magpalna-uway, dili' aku malim na ikaw ya mag-ugas sa siki ku!” Manang miglong si Jisus kanan, “Kun dili' kaw magpa-ugas kanake' sa manga siki mu, beke' kaw na umagakan ku.” ");
INSERT INTO klg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aw miglong si Simon Pédro, “Kun maynan, kay Magpalna-uway, beke' olo' na manga siki ku ya ugasan mu manang dala uman ya kanak manga tullu' aw ulu ku!” ");
INSERT INTO klg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Manang miglong si Jisus kanan, “Ya utaw na migsugbu la, dili' da ka-ilangan mag-ugas, kay malinis da ya kadakula' na lawas nan. Yan olo' ya ugasan ya manga siki nan. Aw dayaw da kamu migkalinis asuntu sa pagpangintu-u mayu kanak, manang beke' na kadég mayu.” ");
INSERT INTO klg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Maynan ya piglong ni Jisus asuntu na kya-ede-an da nan kun singalan ya un maglubid kanan. ");
INSERT INTO klg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagkatigkas da ni Jisus ugasan ya manga siki nilan, pigsut da nan uman ya kanan sa-ul aw lyumiku' sakanan adti lamisa. Aw pig-usip nan silan, “Unu, kyalabetan mayu ya kakawasan na pig-imo' ku kamayu? ");
INSERT INTO klg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pigbasa͡an aku mayu dun ni pagtawag mayu kanak na ‘Magpalna-uway’ aw ‘Pangulu’. Aw umba' ya pagtawag mayu kanak. ");
INSERT INTO klg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kun aku ya kamayu Pangulu aw Magpalna-uway na mig-ugas sa manga siki mayu, umba' kamu uman mag-ugas-ugasay sa kamayu manga siki. ");
INSERT INTO klg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Pig-imo' ku yeiy pada imo-un mayu pundinganan. Yanagaw magpadalem kamu kasiling na sugu-anen, kasiling na pig-imo' ku kamayu. ");
INSERT INTO klg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Matinaw ya un ku paglongun kamayu: Wala' ya sugu-anen na matas pa sa amu nan. Aw wala' ya pigsugu' na matas pa sa migsugu' kanan. ");
INSERT INTO klg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na, asuntu na kya-ede-an da mayu yeiy, kun imo-un mayu, madyaw ya kamayu. ");
INSERT INTO klg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manang beke' na kadég mayu ya pigpalabet ku. Kya-ede-an ku ya anenganeng na tagsambuksambuk na kanak manga pigpamalli'. Aw matuman ya pigpasulat na Tyumanem asini muna na maglong, ‘Ya ubaybay ku na syumambuk kanak kyuman, yan pa baling ya miglubid kanak.’ ");
INSERT INTO klg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pig-ubat ku yeiy dadan kamayu talana wala' pa ka-imo', pada kun ma-imo' da yeiy, ka-ede-an mayu na aku ya Misiyas. ");
INSERT INTO klg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Matinaw ya un ku paglongun kamayu: Pangkay singalan ya dumawat sa utaw na pigsugu' ku, dun da aku nan uman dawata. Aw kun singalan ya dumawat kanak, dun da nan uman dawata ya Ama na migpadala kanak.” ");
INSERT INTO klg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkatigkas ni Jisus maglong seiy, to-o migkalat ya ginawa nan, aw miglong sakanan, “Matinaw ya un ku paglongun kamayu: Awun sambuk kamayu na un maglubid kanak.” ");
INSERT INTO klg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aw migpan-inunuway ya manga umagakan nan kay to-o nyasagunut ya anenganeng nilan kun singalan kanilan ya pigpalabet nan. ");
INSERT INTO klg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, awun sambuk kanilan na pigginawa͡an ni Jisus na tyumangkil kanan. ");
INSERT INTO klg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aw pigpulingenan sakanan ni Simon Pédro na usipen nan si Jisus kun singalan ya pigpalabet nan. ");
INSERT INTO klg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yanagaw ya umagakan na tyumangkil kanan, nyangunsalig dun aba ni Jisus aw pig-usip nan sakanan, “Kay Magpalna-uway, singalan ya utaw yan?” ");
INSERT INTO klg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tyumubag si Jisus, “Ya utaw na atagan ku sa pan na un ku tugmuk, yan ya maglubid kanak.” Yanagaw kyumamang si Jisus sa pan aw pigtugmuk nan aw pig-atag nan kan Judas Iskariyoti na ise' ni Simon. ");
INSERT INTO klg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sa pagpakadawat da nan sa pan, syeledan sakanan ni Satanas. Aw miglong si Jisus kan Judas, “Maksay da imo-a ya awun ni anenganeng mu.” ");
INSERT INTO klg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na, wala' ya pangkay sambuk dun ni lamisa na nya-ede' kun unu ya du-an na piglong yeiy ni Jisus kan Judas. ");
INSERT INTO klg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iman na eped aw pigsugu' nan si Judas na un mayad sa makan pada sa Pista, aw kun beke' yan, matag adti manga utaw na wala' ya pagkamangan. Kay si Judas yan ya pigtaliguwan sa kuwalta. ");
INSERT INTO klg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aw sa pagkatigkas da ni Judas kuman sa pan, nyaksay sakanan nyindeg aw lyumuwa', aw gabi la. ");
INSERT INTO klg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sa adtu la si Judas ni luwa', miglong si Jisus, “Dyumateng da ya udas na pakita' da ya pagka Tyumanem na Ise' na Utaw, aw magi sa un ma-imo' kanak ka-ede-an na manga utaw ya kadyaw na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aw asuntu na ka-ede-an da nilan ya kadyaw na Tyumanem magi kanak, pakita' uman na Tyumanem ya kadyaw na Ise' nan. Aw un da nan imo-un. ");
INSERT INTO klg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kamu na kanak palangad mangayse', dakman tagbi' ya manga udas na pag-iyagad tadun. Paninawun aku mayu. Manang paglongun ku adun salut ya piglong da ku adti magdadumala͡ay sa manga Judiyu: ‘Dili' kamu makakadtu ni kanaken kadtuwan’. ");
INSERT INTO klg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Awun bagu na sugu' na un ku atag kamayu: Paggaginawa͡ay kamu. Kasiling saba na pagginawa ku kamayu, maynan uman maggaginawa͡ay ya kadég mayu. ");
INSERT INTO klg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kay kun maggaginawa͡ay kamu, ka-ede-an na kadég na manga utaw na kamu ya kanaken manga umagakan.” ");
INSERT INTO klg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pagkatigkas yan, nyusip si Simon Pédro kan Jisus, “Kay Magpalna-uway, ayin kaw kadtu?” Aw tyumubag si Jisus kanan, “Dili' pa kaw maka-agad kanak adti un ku kadtuwan, manang kagaya adti kamoliyan makadalug da kaw adtu.” ");
INSERT INTO klg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aw miglong si Pédro kanan, “Kay Magpalna-uway, ananga' dili' aku maka-agad kanmu adun? Atag ku ya kanak pagka-utawun pangkay adti pagkamatay asuntu kanmu!” ");
INSERT INTO klg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aw tyumubag si Jisus kanan, “Unu, tengteng na atag mu ya kanmu pagka-utawun asuntu kanak? Matinaw ya un ku paglongun kanmu: Sa dili' pa tumaga-uk ya manuk, balyaw aku mu na makatlu.” ");
INSERT INTO klg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Migpadeleg si Jisus miglong kanilan, “Dili' magkakamang ya ginawa mayu. Salig kamu sa Tyumanem, aw salig kamu uman kanak. ");
INSERT INTO klg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adti balay na Ama ku, madég ya manga tambi'. Dili' aku maglong kamayu kun beke' pa yeiy na matinaw. Yanagaw muna aku madtu na un magtagilan sa eya-anan mayu. ");
INSERT INTO klg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aw pagkatigkas ku tagilanen ya eya-anan mayu, lumiku' aku aw angayen ta kamu, aw dun da kamu gayed pag-eya' ni tampid ku. ");
INSERT INTO klg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aw kya-ede-an mayu ya agiyanan pasinan adti banwa na un ku kadtuwan.” ");
INSERT INTO klg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Miglong si Tomas kan Jisus, “Kay Magpalna-uway, wala' kami paka-ede' kun ayin kaw kadtu, yanagaw unun nami ya pagka-ede' sa agiyanan yan?” ");
INSERT INTO klg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aw tyumubag si Jisus kanan, “Aku ya agiyanan, aku ya katinawan, aw aku ya lyekatan sa ginawa na wala' ya katigkasan. Wala' ya pangkay sambuk na makakadtu ni Ama kun dili' magi kanak. ");
INSERT INTO klg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kun tengteng na kya-ede-an aku mayu, ka-ede-an da mayu uman ya kanak Ama. Yanagaw lekat adun, kya-ede-an da mayu sakanan aw kyinita' da mayu uman.” ");
INSERT INTO klg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pagkatigkas yan, miglong si Pilipi kan Jisus, “Kay Magpalna-uway, pakita͡an kanami ya Ama aw umba' da yan kanami.” ");
INSERT INTO klg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aw tyumubag si Jisus kanan, “Kadugay da naten mig-iyagad, wala' pa mu ka' ka-ede-i kun singalan aku? Ya kyumita' kanake', kyumita' uman sa Ama. Ananga' kaw makapaglong na ‘Pakita͡an kanami ya Ama’? ");
INSERT INTO klg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Unu, wala' pa kaw pangintu-u na aku awun ni Ama aw ya Ama asini kanak? Ya manga pig-ubat-ubat ku kamayu, wala' lekat adti kanak manang lyumekat adti Ama ku na asini kanak, aw magi kanak pig-imo' nan ya kanan manga imo-unun. ");
INSERT INTO klg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yanagaw, pangintu-uwi mayu na aku awun ni Ama, aw ya Ama asini kanak. Manang kun dili' mayu yan pangintu-uwan, pangintu-uwi aku mayu baling asuntu sa manga puliba na pigpan-imo' ku. ");
INSERT INTO klg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Matinaw ya un ku paglongun kamayu: Asuntu na lumiku' aku adti Ama, ya utaw na nyangintu-u kanak, mabatug nan imo-un ya manga pig-imo' ku aw to-o pa dun dakula' ya mabatug nan imo-un. ");
INSERT INTO klg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aw pangkay unu ya sekaten mayu magi sa kanak ngalan, imo-un ku pada madeyen ya Ama magi dun ni kanan Ise'. ");
INSERT INTO klg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Salutun ku ya paglong: Kun magsekat kamu sa pangkay unu magi sa kanak ngalan, imo-un ku saba. ");
INSERT INTO klg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kun pigginawa͡an aku mayu, daluga ya kanak manga sugu'. ");
INSERT INTO klg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aw sekaten ku adti Ama na padala͡an kamu nan na sambuk na mag-apitay na magpalna-u kamayu kalyu kanak, aw agad-agadan kamu nan na wala' ya tyamanan. ");
INSERT INTO klg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ya mag-apitay yeiy, yan ya Ispiritu Santo, aw alag matinaw ya paglongun nan. Ya manga utaw na wala' pangintu-u sa Tyumanem dili' nilan mabatug dawaten ya Ispiritu Santo, kay wala' nilan ka-ede-i sakanan. Manang kamu nya-ede' da kanan kay gayed sakanan awun ni kamayu, aw meya' pa dun ni anenganeng mayu. ");
INSERT INTO klg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Dili' ta kamu pabaya-an kasiling na manga manélu. Kay lumiku' aku saba asini kamayu. ");
INSERT INTO klg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dakman tagbi' ya udas aw dili' da aku na manga utaw kita-en. Manang kamu, kumita' pa kanak. Aw asuntu na awun ginawa ku na wala' ya katigkasan, kamu uman awun ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yanagaw dun ni allaw na kita-en aku mayu salut, ka-ede-an da mayu na aku awun ni Ama. Aw ka-ede-an mayu uman na nyaka-akup kamu kanak, aw aku awun gayed ni kamayu. ");
INSERT INTO klg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aw ya utaw na dayaw dyumalug sa manga sugu' ku, yan ya utaw na tengteng gyuminawa kanak. Aw ya utaw na gyuminawa kanak, ginawa͡an uman na kanaken Ama. Aw maynan uman, ginawa͡an ku sakanan aw pa-ede' ku kanan kun singalan aku.” ");
INSERT INTO klg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pagkatigkas yan, nyusip kan Jisus ya sambuk na umagakan nan na pigngalanan na si Judas, beke' na Judas Iskariyoti. Miglong si Judas, “Kay Magpalna-uway, ananga' olo' kami ya pigpa-ede' mu aw beke' na kadég na manga utaw?” ");
INSERT INTO klg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aw tyumubag si Jisus kanan, “Pangkay singalan ya gyuminawa kanak, dalugun nan ya palna-u ku. Aw ginawa͡an sakanan na kanak Ama, aw meya' kami ya Ama ku adti kanan. ");
INSERT INTO klg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Manang ya utaw na wala' ya pagginawa kanak, wala' nan uman daluga ya manga palna-u ku. Aw ya pigpalna-u ku na pigdengeg mayu, wala' lekat adti kanak manang lekat adti Ama na migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Piglong ku yeiy kamayu talana ini pa aku ni tampid mayu. ");
INSERT INTO klg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Manang ya mag-apitay na un padala na Ama dun ni kanak ngalan, yan ya Ispiritu Santo na un magpalna-u aw magpa-anenganeng kamayu sa kadég na piglong ku pada dili' mayu kalingawan. ");
INSERT INTO klg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Dili' magkakamang ya kamayu ginawa aw dili' kamu magkallek, kay ayawan ku kamayu ya kanak kalinaw. Aw ya kalinaw na un ku atag kamayu beke' na kasiling na kalinaw na asini tas na lupa'. ");
INSERT INTO klg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pigdengeg da mayu ya piglong ku kamayu na ‘indegan ta kamu manang lumiku' aku asini tampid mayu.’ Kun tengteng na pigginawa͡an aku mayu, magleya kamu galu asuntu na madtu aku ni tampid na Ama na matas pa kanak. ");
INSERT INTO klg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pig-ubat da ku yeiy dadan kamayu pada dun ni allaw na ma-imo' da, pangintu-uwan mayu ya piglong ku. ");
INSERT INTO klg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Dakman tagbi' ya udas na pagbalawbalaw tadun kay awun da ya migdumala asini tas na lupa' na si Satanas. Dili' aku degen na katulus nan, ");
INSERT INTO klg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","manang imo-un ku ya kaliman na kanak Ama pada ka-ede-an na manga utaw na pigginawa͡an ku ya Ama aw pigtuman ku ya kadég na pigsugu' nan kanake'. Na, kitadun da!” ");
INSERT INTO klg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Talana ni Jisus aw manga umagakan nan nyanaw, migpadeleg sakanan miglong adti kanilan, “Aku ya tengteng na punu-an na balagen na paras, aw ya Ama ku, yan ya magsanggila-ay. ");
INSERT INTO klg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ya kadég na sanga ku na wala' pakabunga, utudun nan. Aw ya manga sanga na nyamunga, panalingsingan nan pada to-o pa mamunga. ");
INSERT INTO klg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aw kamu, kyalinisan da magi sa palna-u ku na pigdawat da mayu. ");
INSERT INTO klg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Katingen kamu asini kanak kasiling uman na awun aku ni kamayu. Dili' makabunga ya sanga kun wala' dun ni punu-an. Maynan uman dili' kamu makabunga kun dili' kamu matingen asini kanak. ");
INSERT INTO klg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aku ya punu-an na balagen na paras, aw kamu ya manga sanga. Ya utaw na gayed nyatingen asini kanak aw aku uman awun ni kanan, yan ya utaw na to-o pa mamunga. Kay kun wala' aku, wala' ya mabatug mayu. ");
INSERT INTO klg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Manang kun awun utaw na wala' katingen adi kanak, kasiling sakanan na sanga na pig-utud aw pig-agbel adti ligad aw magdang da. Aw tigkas yan, panimunun aw agbel adti atulun. ");
INSERT INTO klg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Manang kun matingen kamu adi kanak, aw kun kenne' pa adti kamayu anenganeng ya pigpalna-u ku, na, pagsekat kamu sa pangkay unu ya kaliman mayu aw imo-un saba kamayu. ");
INSERT INTO klg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aw magi sa pagpamunga mayu na to-o madég, madeyen ya Ama. Aw yeiy ya magmatinaw na kamu ya kanak manga umagakan. ");
INSERT INTO klg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kasiling na pagginawa kanak na Ama, maynan uman ya pagginawa ku kamayu. Yanagaw katingen kamu dun ni kanak pagginawa. ");
INSERT INTO klg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kun dalugun mayu ya kanak manga sugu', tengteng na awun kamu ni kanak pagginawa, kasiling na dayaw ku pigtuman ya manga sugu' na Ama ku, aw gayed aku awun ni kanan pagginawa. ");
INSERT INTO klg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Piglong ku yeiy adti kamayu pada ya kanak pagleya awun ni kamayu aw ya pagleya mayu dayaw malingeb. ");
INSERT INTO klg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ini ya kanak sugu': Paggaginawa͡ay kamu kasiling na pagginawa ku kamayu. ");
INSERT INTO klg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kun awun utaw na magtumbay na patayen sakanan asuntu sa manga ubaybay nan, yan ya pagginawa na wala' ya maka-unawa. ");
INSERT INTO klg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kun imo-un mayu ya pigsugu' ku, kamu ya tengteng na ubaybay ku. ");
INSERT INTO klg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dili' ta kamu tawagen na sugu-anen, kay ya sugu-anen dili' maka-ede' sa imo-unun na amu nan. Manang pigtawag da ta kamu na kanak tengteng manga ubaybay, kay pigpa-ede' ku kamayu ya kadég na piglong na kanak Ama. ");
INSERT INTO klg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Beke' mayu ya nyamalli' kanak. Aku saba ya nyamalli' kamayu. Aw pigtani ta kamu na un magpa-ede' sa palna-u ku adti manga utaw pada mangintu-u silan, aw yeiy ya palangad bunga mayu na dili' magkalat. Aw yanagaw pangkay unu ya sekaten mayu adti Ama magi sa kanak ngalan, atag nan kamayu. ");
INSERT INTO klg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ini ya kanak sugu' kamayu: Gayed kamu paggaginawa͡ay.” ");
INSERT INTO klg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Miglong pa uman si Jisus, “Kun dumutan kamu na madég na manga utaw asuntu kanak, anenganenga mayu na aku ya muna nilan pigdumutan. ");
INSERT INTO klg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kun kenne' pa mayu nyaka-akup sa manga utaw asini tas na lupa', ginawa͡an kamu galu nilan. Manang asuntu na pigpamalli' da ta kamu, wala' da kamu paka-akup dun ni kanilan. Yanagaw yan ya du-an na pigdumutan kamu nilan. ");
INSERT INTO klg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Anenganenga mayu ya piglong da ku kamayu: Wala' ya sugu-anen na matas pa sa amu nan. Kun pigpamulayaman aku nilan, kamu uman pamulayaman nilan. Kun pigdalug nilan ya palna-u ku, dalugun uman nilan ya palna-u mayu. ");
INSERT INTO klg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Manang ya du-an na pamulayaman kamu nilan, kay nyangintu-u kamu kanak, aw wala' nilan ka-ede-i ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kun wala' aku kadi asini tas na lupa' aw pagpalna-u kanilan, wala' galu ya tubagenen nilan. Manang adun, dili' da silan makapaglong na wala' ya sala' nilan. ");
INSERT INTO klg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pangkay singalan ya migdumut kanak, pigdumutan nan uman ya Ama ku. ");
INSERT INTO klg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kun wala' ya pigpan-imo' ku dun ni kanilan na milagru na dili' mabatug na eped, dili' galu silan pasala-en. Manang kyinita' da nilan ya manga pig-imo' ku, aw pigdumutan aku baling nilan aw ya kanak Ama. ");
INSERT INTO klg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aw adti pig-imo' nilan, nyatuman da ya nyakasulat adti kanilan Uldin: ‘Pigdumutan aku nilan na wala' ya indeganan.’ ");
INSERT INTO klg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Manang padala ku kamayu ya mag-apitay na yan ya Ispiritu Santo na lekat adti Ama. Aw yan ya magpalna-u kamayu sa tengteng matinaw. Lekat sakanan adti Ama, aw yan ya magmatinaw kun singalan aku. ");
INSERT INTO klg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aw kamu uman ya magmatinaw kun singalan aku, kay nyaka-iyeped kamu saba kanak lekat pa adti pagpalekat ku migpalna-u. ");
INSERT INTO klg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Piglong da ku dadan ya kadég yeiy kamayu pada dili' kamu makasuway sa pagpangintu-u mayu kanak. ");
INSERT INTO klg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Alilinan kamu na manga magdadumala͡ay sa manga Judiyu dun ni manga sinagoga. Aw dumateng pa ya manga allaw na kun singalan ya magpatay kamayu iman nilan aw kyatutukan ya Tyumanem sa pig-imo' nilan. ");
INSERT INTO klg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Maynini ya imo-un nilan kamayu kay wala' nilan ka-ede-i kun singalan ya Ama aw kun singalan uman aku. ");
INSERT INTO klg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Manang piglong ku yeiy dadan pada kun ma-imo' ya maynan, ka-anenganengan mayu ya pigpa-ede' ku kamayu. “Idtu muna, wala' ku kamayu ubat-ubatan kay ini pa aku ni tampid mayu. ");
INSERT INTO klg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Manang adun, agpet da aku lumiku' adti Ama na migpadala kanak, aw wala' ya pangkay sambuk kamayu na nyusip kun ayin aku kadtu. ");
INSERT INTO klg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aw sa pag-ubat ku yeiy adti kamayu, migkalat da baling ya ginawa mayu. ");
INSERT INTO klg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Manang matinaw ya paglongun ku kamayu: To-o madyaw kamayu na indegan ta kamu. Kay kun dili' aku mindeg asini, dili' dumateng ya mag-apitay na yan ya Ispiritu Santo na magpalna-u kamayu. Manang kun mindeg aku, un ku padala sakanan adti kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aw sa pagdateng da nan asini, pa-ede' nan sa manga utaw kun unu ya manga sala' nilan, aw pa-ede' nan uman kanilan na wala' ya sala' asini kanak, aw ya Tyumanem yan ya mag-ukum kanilan. ");
INSERT INTO klg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bangalen nan adti kanilan na nyakasala' silan kay wala' aku nilan pangintu-uwi. ");
INSERT INTO klg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aw bangalen nan uman adti kanilan na wala' ya sala' dun ni kanak, yanagaw lumiku' aku adti tampid na Ama aw dili' da kamu kumita' kanak. ");
INSERT INTO klg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aw bangalen nan uman kanilan na ya Tyumanem yan ya mag-ukum sa manga utaw kay pig-ukuman da nan ya migdumala asini tas na lupa' na si Satanas. ");
INSERT INTO klg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Madég pa galu ya un ku paglongun kamayu manang malug pa mayu adun kalabetan. ");
INSERT INTO klg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Manang pagdateng da na Ispiritu Santo, gagaden nan ya anenganeng mayu adti pagka-ede' sa kadég na matinaw. Aw ya palna-u nan kamayu dili' lekat adti kanan manang yan olo' ya pa-ede' nan ya kanan pigdengeg. Pa-ede' nan uman kamayu kun unu ya un dumateng. ");
INSERT INTO klg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aw ya Ispiritu, patasen nan ya kanak dengeg. Kay ubat nan ya pangkay unu na dengegen nan lekat adti kanak, aw pa-ede' nan adti kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya kadég na adti anenganeng na Ama, yan uman ya kanak. Yanagaw pangkay unu ya dengegen na Ispiritu lekat adti kanak, yan uman ya pa-ede' nan adti kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Na, dakman tagbi' ya pagsambuk tadun aw dili' da aku mayu kita-en, manang dili' madugay uman da aku mayu kita-en.” ");
INSERT INTO klg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Asuntu sa piglong ni Jisus kanilan, mig-usip-usipay ya manga umagakan nan, “Unu ya kakawasan na piglong nan na ‘Dakman tagbi' ya pagsambuk tadun aw dili' da aku mayu kita-en, manang dili' madugay uman da aku mayu kita-en’? Aw miglong pa uman sakanan, ‘Lumiku' aku adti tampid na Ama.’ ” ");
INSERT INTO klg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aw gayed silan mig-usip-usipay na maglong, “Unu ya pyalabet nan na ‘dili' madugay’? Wala' tadun ka-ede-i kun unu ya pyalabet nan.” ");
INSERT INTO klg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, kya-ede-an ni Jisus na kaliman nilan galu musip kanan, yanagaw piglongan nan silan, “Enda', mig-usip-usipay kamu kun unu ya kakawasan na piglong ku kakayna na ‘Dakman tagbi' ya pagsambuk tadun aw dili' da aku mayu kita-en, manang dili' madugay uman da aku mayu kita-en’? ");
INSERT INTO klg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Matinaw ya un ku paglongun kamayu: Magsugaw kamu asuntu sa kakalatan na ginawa mayu, manang ya manga utaw na wala' pangintu-u kanak, magleya silan. Aw pangkay magkalat ya ginawa mayu, manang ya kakalatan yan kasayuwan saba na pagleya. ");
INSERT INTO klg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kasiling na ka͡ubayan na migti-is pyetesan. Manang sa pagka͡utaw da na ise' nan, kalingawan da nan ya pagti-is asuntu na magleya sakanan kay nya͡utaw da ya kanan ise'. ");
INSERT INTO klg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Maynan uman kamu. Migkalat ya ginawa mayu adun asuntu sa piglong ku kamayu, manang dili' madugay magkakita͡ay kitadun salut aw to-o kamu magleya. Aw wala' ya pangkay singalan na makakamang sa pagleya na awun ni kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Dun ni allaw yan, beke' da ku ya sekatan mayu. Matinaw ya un ku paglongun kamayu: Pangkay unu ya sekaten mayu adti Ama magi sa kanak ngalan, un nan saba imo-un kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taman adun, wala' kamu pagsekat sa pangkay unu adti kanan magi sa kanak ngalan. Manang adun, pagsekat da kamu, aw atag nan saba pada malingeb ya kamayu pagleya. ");
INSERT INTO klg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Miglong aku kamayu adun magi sa manga pundinganan, manang dumateng ya allaw na dili' da aku maglong kamayu magi sa manga pundinganan manang bangalen da ku adti kamayu ya kana Ama ku. ");
INSERT INTO klg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dun ni allaw yan, kamu la ya magsekat adti kanan dun ni pagpanawagtawag mayu magi sa kanak ngalan. Dili' da ka-ilangan na aku ya magsekat adti Ama pada kamayu. ");
INSERT INTO klg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pigginawa͡an kamu na Ama asuntu na gyuminawa kamu kanak aw nyangintu-u kamu na aku lekat adti Ama. ");
INSERT INTO klg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lyumekat aku adti Ama, aw nyadi aku asini tas na lupa'. Manang adun, indegan da ku ya banwa ini aw lumiku' da aku adti Ama.” ");
INSERT INTO klg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aw miglong ya manga umagakan nan, “Kyalabetan da nami adun ya piglong mu kay beke' da pundinganan ya piggamit mu! ");
INSERT INTO klg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nya-ede' da kami na kya-ede-an mu ya kadég. Pangkay wala' pa kami usip kanmu, dadan da mu kya-ede-an ya kanami pig-anenganeng. Yanagaw nyangintu-u la kami na lekat kaw adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aw nyusip si Jisus kanilan, “Unu, tengteng kamu nyangintu-u kanak? ");
INSERT INTO klg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Manang dumateng ya udas aw adun dyumateng da saba na magpansibeklag kamu mampamalaguy pasinan adti kamayu manga balay. Aw pabaya-an aku mayu na olo' ku sayda. Manang beke' na sayda ku olo' kay gayed aku pig-agad-agadan na kanak Ama. ");
INSERT INTO klg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ya kadég yeiy, piglong da ku kamayu pada awun kalinaw mayu asuntu na nyangintu-u kamu kanak. Asini tas na lupa', magti-is kamu sa madég na kalugan. Manang dili' magkalumay ya ginawa mayu, kay pigdeg da ku si Satanas na migdumala sa kadakula' na banwa.” ");
INSERT INTO klg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkatigkas ni Jisus maglong adti manga umagakan nan, lyumangad sakanan adti langit aw nyanawagtawag adti Tyumanem, law nan, “Kay Ma', 1 dyumateng da ya udas na pakita' mu ya katulus na pagka Tyumanem na kanmu Ise'. ");
INSERT INTO klg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kay pig-atag da mu kanak ya katundanan magdumala sa kadég na manga utaw, pada atag ku ya ginawa na wala' ya katigkasan adti manga utaw na pigtaligu mu kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aw maynini ya pa-agi na matagtun nilan ya ginawa na wala' ya katigkasan: Maka-ede' silan na ikaw olo' ya tengteng Tyumanem aw ka-ede-an nilan uman na aku si Jisu-Kristu na pigpadala mu. ");
INSERT INTO klg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pigpatas ku ya kanmu dengeg asini tas na lupa' magi sa pagtuman ku sa kadég na imo-unun na pigtaligu mu kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yanagaw adun, kay Ma', uli-an ya dengeg ku kasiling na idtu muna sa dun pa aku ni tampid mu lekat pa asini muna sa wala' pa ka-imo' ya kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pigpa-ede' ta kaw adti manga utaw na pigtaligu mu kanak na asini tas na lupa'. Idtu muna, kanmu silan, aw adun pig-atag mu silan kanak. Aw pigdalug nilan ya kanmu piglong. ");
INSERT INTO klg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aw pigka-ede-an da nilan na ya kadég na pig-atag mu kanak alag lyumekat adti kanmu. ");
INSERT INTO klg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kay ya piglong mu kanak, yan ya pigpalna-u ku kanilan, aw dayaw nilan pigdawat. Kya-ede-an da nilan na aku lekat saba adti kanmu, aw nyangintu-u silan na ikaw ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nyanawagtawag aku kanmu pada kanilan, manang beke' na manga utaw na wala' pangintu-u kanak. Yan saba ya pigpanawagtawagan ku adti kanmu ya manga utaw na pigtaligu mu kanak, kay kanmu saba silan manga utaw. ");
INSERT INTO klg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Aw ya kadég na kanak, kanmu saba. Aw ya kadég na awun ni kanmu, kanak uman. Aw pigpatas ya dengeg ku magi kanilan. ");
INSERT INTO klg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dili' madugay lumiku' aku adti kanmu kay Ma', aw dili' da aku meya' asini sayid na manga utaw. Manang silan, kenne' pa nilan asini. Kay Ma' na wala' ya sala', gayed silan tamengi magi sa katulus na kanmu ngalan na pig-atag mu kanak. Pakatanawi silan pada magkasambuk ya ginawa aw anenganeng nilan kasiling na kita sambuk da. ");
INSERT INTO klg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Talana ini pa aku ni sayid nilan, pigpakatanawan ku silan aw pigtamengan ku magi sa katulus na kanmu ngalan na pig-atag mu kanak. Aw wala' ya nyalagak kanilan, sambuk da olo' aw yan ya pigpalpa mu dadan na malagak, manang magi dun ni pig-imo' nan, matuman ya pigpasulat mu asini muna. ");
INSERT INTO klg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aw adun, lumiku' da aku adti kanmu. Aw dadan ku piglong ya kadég yeiy kanilan talana ini pa aku ni tampid nilan, pada malingeb da adti kanilan ya pagleya ku. ");
INSERT INTO klg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pigpalna-u la ku kanilan ya kanmu piglong. Aw pigdumutan silan na manga utaw na wala' ya pagpangintu-u kanmu, kasiling ku uman pigdumutan nilan kay wala' aku agad sa pa-agi nilan. ");
INSERT INTO klg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dili' aku magsekat adti kanmu na kamangen mu silan lekat asini tas na lupa', manang yan olo' ya sekaten ku adti kanmu na tamengan mu silan aw degen nilan ya manga kapandayan ni Satanas. ");
INSERT INTO klg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Beke' na asini tas na lupa' ya kanilan tengteng eya-anan, kasiling ku uman na dili' taga asini tas na lupa'. ");
INSERT INTO klg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taniya silan magi sa palna-u mu na alag matinaw. ");
INSERT INTO klg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aw kasiling na pigpadala aku mu asini tas na lupa', maynan uman pigsugu' ku silan adti kadég na manga utaw adti kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Asuntu kanilan, tumbay ku ya kanak pagka-utawun na ma-imo' dugsu' adti kanmu pada mabatug da silan taniyen aw ma-imo' kanmu manga utaw magi dun ni pagdalug nilan sa kanmu matinaw na palna-u. ");
INSERT INTO klg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na, beke' olo' nilan ya pyanawagtawagan ku adti kanmu, manang kadég uman na manga utaw na un pa mangintu-u kanak adti kamoliyan magi sa pag-ubat-ubat na manga utaw na nyangintu-u kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kay Ma', nyanawagtawag aku kanmu na magkasambuk galu ya kadég nilan kasiling na ikaw asini kanak aw aku awun ni kanmu. Nyanawagtawag aku uman na maka-akup silan kanate' pada mangintu-u ya manga utaw na asini tas na ikaw ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ya dengeg na pig-atag mu kanak asini muna, pig-atag da ku uman adti kanilan, pada magkasambuk ya kanilan ginawa kasiling na kita sambuk da. ");
INSERT INTO klg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ikaw asini kanak, aw aku awun ni kanilan, pada dayaw malingeb ya pagkasambuk na ginawa nilan. Kun maynan, ka-ede-an na manga utaw na ikaw ya migpadala kanak. Aw ka-ede-an nilan uman na pigginawa͡an mu silan kasiling na pagginawa mu kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Kay Ma', ya manga utaw na pig-atag mu kanak, kaliman ku mag-iyeped kami adti tampid mu. Aw kita-en nilan ya pig-atag mu kanak na katulus aw kalalamdag na pagka Tyumanem asuntu na pigginawa͡an aku mu lekat pa na pagka-imo' na kadakula' na banwa. ");
INSERT INTO klg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kay Ma' na wala' ya sala', ya manga utaw, wala' silan paka-ede' kun singalan kaw. Manang aku nyaka-ede' kanmu. Aw ya manga eped ku ini, kya-ede-an nilan na ikaw ya migpadala kanak. ");
INSERT INTO klg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pigpa-ede' da ta kaw adti kanilan, aw padelegen pa ku ya pagpa-ede', pada ya pagginawa mu kanak awun ni kanilan, aw aku uman awun ni kanilan.” ");
INSERT INTO klg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagkatigkas ni Jisus manawagtawag, nyanaw sakanan eped nan ya kanan manga umagakan. Tyumalipag silan sa ganga' na Kidron aw tyumukud silan aw syumeled dun ni kakawuyan na manga olibo. ");
INSERT INTO klg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, si Judas Iskariyoti na miglubid kan Jisus, kya-ede-an nan uman ya banwa yeiy kay malikit si Jisus magkadtu aw ya kanan manga umagakan. ");
INSERT INTO klg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aw dyumateng si Judas aw manga sundalu na Romanen aw manga magtatunggu-ay sa Témplo, kay pigsugu' silan na manga mangkatas na magdadugsu-ay aw manga Parisiyo. Aw nyandala silan sa manga saleng aw manga kinis. ");
INSERT INTO klg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na, kya-ede-an da ni Jisus dadan ya kadég na un ma-imo' kanan. Yanagaw pigsungun nan silan aw nyusip sakanan, “Singalan ya pigpaninaw mayu?” ");
INSERT INTO klg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aw tyumubag silan, “Si Jisus na taga Nazarit.” Miglong si Jisus kanilan, “Aku saba ya pyaninaw mayu.” Na, dun ni sayid nilan si Judas na yan ya miglubid kanan. ");
INSERT INTO klg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sa paglong ni Jisus kun singalan sakanan, nyaka-udul silan aw nyangkalukad dun ni lupa'. ");
INSERT INTO klg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pigsalut nan pig-usip silan, “Singalan ya pyaninaw mayu?” Aw law nilan, “Si Jisus saba na taga Nazarit.” ");
INSERT INTO klg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aw miglong si Jisus kanilan, “Piglongan da ta kamu na aku saba si Jisus. Yanagaw kun aku olo' ya pigpaninaw mayu, pabaya-i la ya manga eped ku ini na manaw silan.” ");
INSERT INTO klg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Na, dun ni tubag nan, nyatuman ya piglong nan idtu muna na wala' ya malagak pangkay sambuk na pigtaligu kanan na Ama. ");
INSERT INTO klg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aw pigtagnus ni Simon Pédro ya kampilan nan aw pigtibas nan ya sugu-anen na pangulu na manga magdadugsu-ay. Aw dayaw nya-ilap ya kalintu na talinga nan. Ya ngalan na sugu-anen yeiy, si Malku. ");
INSERT INTO klg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aw piglong si Jisus kan Pédro, “Uli-an adti luma' ya kampilan mu! Pagaw mig-anenganeng kaw na dili' ku mabatug ti-isen ya un pa-agiyan kanak na Ama.” ");
INSERT INTO klg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aw pagkatigkas yan, pigdakep si Jisus na manga sundalu na Romanen aw kapitan nilan, aw manga Judiyu na migtunggu' sa Témplo. Aw piggapus nilan si Jisus. ");
INSERT INTO klg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pigpa-agad nilan una sakanan adti asdangan ni Anas na ugangan ni Kaypas. Na, si Kaypas ya pangulu na manga magdadugsu-ay adti Témplo dun ni umay yan. ");
INSERT INTO klg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kaypas uman ya miglong idtu muna adti manga eped nan na magdadumala͡ay sa manga Judiyu, law nan, “Madyaw pa na sambuk olo' kanaten ya matay asuntu sa manga Judiyu kay sa apnasen ya kadég na manga utaw asini nasud tadun.” ");
INSERT INTO klg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, dyumalug si Simon Pédro kanilan adti mawatawat. Aw dyumalug uman ya sambuk na umagakan ni Jisus na pigkilala la na pangulu na manga magdadugsu-ay, aw pyaseled nan adti kanan balay eped ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Manang si Pédro kenne' nan mig-indeg-indeg adti luwa', malapit dun ni suwangan na pamanag. Yanagaw lyumuwa' ya sambuk na umagakan na pigkilala na pangulu na manga magdadugsu-ay, aw migbalawbalaw silan ya sugu-anen na bubay na migtunggu' sa suwangan, aw pigpaseled nan si Pédro. ");
INSERT INTO klg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aw miglong ya sugu-anen kan Pédro, “Enda', ikaw agaw ya sambuk na umagakan na utaw yan?” Aw tyumubag si Pédro, “Beke' ku.” ");
INSERT INTO klg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na, to-o maniki' ya gabi yan. Yanagaw migsipanalang ya manga sugu-anen aw ya manga magtatunggu-ay dun ni duluk nilan. Aw si Pédro, nyanalang uman adti sayid nilan. ");
INSERT INTO klg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Adti seled, pig-usip ni Anas si Jisus. Kaliman nan ka-ede-an kun singalan ya manga umagakan nan aw unu ya kanan pigpalna-u. ");
INSERT INTO klg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aw tyumubag si Jisus kanan, “Wala' ku tagu-a ya kanak pagpalna-u adti manga utaw. Kay dun aku pagpalna-u adti manga sinagoga aw adti manga pamanag na Témplo na alag pagkatipunan na kadég na manga Judiyu. Aw wala' ya pigpalna-u ku kanilan na tagu-tagu'. ");
INSERT INTO klg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ananga' aku mayu usipen? Usipa mayu baling ya manga utaw ini na nyakadengeg kanak kay nyaka-ede' silan kun unu ya pigpalna-u ku kanilan.” ");
INSERT INTO klg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sa paglong nan seiy, pigsampal sakanan na sambuk na magtatunggu-ay na nyinindeg malapit dun ni kanan, law nan, “Maynan ka' ya pagtubag sa pangulu na manga magdadugsu-ay?” ");
INSERT INTO klg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aw tyumubag si Jisus kanan, “Kun dili' matinaw ya piglong ku, matinawa la na dili' umba' ya piglong ku. Manang kun matinaw ya piglong ku, ananga' aku mu sampalen?” ");
INSERT INTO klg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pagkatigkas yan, pigpa-ated ni Anas si Jisus na kenne' piggapus adti kan Kaypas na yan ya pangulu na manga magdadugsu-ay. ");
INSERT INTO klg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, sa kenne' pa ni Pédro nyanalang, pig-usip sakanan na manga utaw dun, law nilan, “Enda', ikaw ya sambuk na umagakan na utaw yan?” Aw pigbalyaw da uman ni Pédro, law nan, “Beke' ku!” ");
INSERT INTO klg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Awun uman sambuk na sugu-anen na pangulu na magdadugsu-ay dun. Ya sugu-anen yeiy kadégan na utaw na nya-ilap ni Pédro ya talinga nan. Aw piglongan nan si Pédro “Enda', ikaw ya utaw na pigkita' ku eped nan dun ni kakawuyan na manga olibo?” ");
INSERT INTO klg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Manang uman da si Pédro migbalyaw. Aw tigkan tyumaga-uk ya manuk. ");
INSERT INTO klg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na, to-o pa maselem, lekat adti balay ni Kaypas pigpa-agad si Jisus pasinan adti palasyo na gubirnador na si Pilato na taga Roma. Aw pigpaseled nilan si Jisus, manang wala' seled ya manga Judiyu na migpa-agad kanan, kay kun sumeled silan kalakadan nilan ya kanilan katanem na dili' sumambuk sa manga Héntil, yanagaw dili' da kanilan tumbay na sumambuk kuman dun ni Pista na Paglabay na Anghil na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yanagaw lyumuwa' si Pilato aw nyusip kanilan, “Unu ya limanda mayu sa utaw ini?” ");
INSERT INTO klg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aw tyumubag silan kanan, “Kun wala' pa ya pig-imo' nan na malatay, dili' galu nami dala͡en asini kanmu!” ");
INSERT INTO klg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aw miglong si Pilato kanilan, “Dala͡a mayu adti kamayu usayanan aw kamu ya mag-ukum kanan magi sa kamayu Uldin.” Tyumubag ya manga Judiyu, “Dun ni kamayu bala-ud na Roma, wala' saba ya katundanan nami magpapatay sa utaw.” ");
INSERT INTO klg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aw dun ni piglong nilan kan Pilato, nyatuman ya piglong ni Jisus idtu muna kun unu ya kamatayen na un nan ka-agiyan. ");
INSERT INTO klg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yanagaw lyumiku' si Pilato adti seled, aw pigpatawag nan si Jisus aw pig-usip nan, “Unu, ikaw ya hari' sa manga Judiyu?” ");
INSERT INTO klg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aw tyumubag si Jisus kanan, “Unu, tengteng yeiy kanmu usip aw kun olo' kaw piglongan na manga utaw kun singalan aku?” ");
INSERT INTO klg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aw miglong si Pilato kanan, “Unu ka' ya pagtandaw mu kanak, Judiyu? Ya manga eped mu na Judiyu aw ya kamayu manga mangkatas na magdadugsu-ay, silan ya dyumala kanmu asini kanake'. Na, unu ya tengteng na nya-imo' mu?” ");
INSERT INTO klg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aw tyumubag si Jisus kanan, “Ya kanak pagkahari' wala' lekat asini tas na lupa'. Kun asini pa ni tas na lupa' ya pagkahari' ku, tyumanam da galu ya manga sakup ku na un magtameng kanak pada dili' aku tumbay adti manga magdadumala͡ay sa manga Judiyu. Manang ya kanak pagkahari' wala' lekat asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aw miglong si Pilato kanan, “Kun maynan, hari' kaw kadi'!” Aw miglong si Jisus kanan, “Matinaw saba ya piglong mu na hari' aku. Aw ya du-an na nya͡utaw aku asini tas na lupa' pada ubat-ubat ku ya tengteng matinaw. Aw ya kadég na malim maka-ede' sa matinaw, silan ya gayed magpakanyeg kanak.” ");
INSERT INTO klg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aw nyusip si Pilato kanan, “Unu ka' ya tengteng na matinaw?” Pagkatigkas ni Pilato maglong seiy, uman da sakanan lyumuwa' aw piglongan nan salut ya manga Judiyu, “Wala' ya kyinita' ku na un pagsala' kanan. ");
INSERT INTO klg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Manang awun katanem mayu na kada umay dun ni Pista na Paglabay na Anghil na Tyumanem, magsekat kamu sa sambuk na utaw na nyakalabusu na paluwa-en ku adti kamayu. Yanagaw unu ya kaliman mayu? Paluwa-en ku kamayu ya hari' na manga Judiyu?” ");
INSERT INTO klg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Manang nyamansag ya manga utaw dun, miglong silan, “Beke' nan! Si Barabas da!” Na, si Barabas sambuk na ribildi. ");
INSERT INTO klg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pagkatigkas yan, pigpa-angay ni Pilato si Jisus aw palabetan nan. ");
INSERT INTO klg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aw mig-imo' silan sa korona na suksukun aw pigsangkub nilan adti ulu ni Jisus. Aw pigpasut nilan sakanan sa malawig na sa-ul na tapel ya batek kasiling na pagsutun na hari'. ");
INSERT INTO klg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aw migsayusayu silan dyumulud kanan na maglong, “Kay Hari' na manga Judiyu, magkadugay pa galu ya pag-eya' mu asini tas na lupa'!” Aw syumampal uman silan kanan. ");
INSERT INTO klg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lyumuwa' da uman si Pilato aw piglongan nan ya manga Judiyu, “Tandawi mayu, pakita' ku sakanan kamayu salut pada pa-ede' na wala' ya pigkita' ku na un pagsala' kanan.” ");
INSERT INTO klg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yanagaw lyumuwa' si Jisus na awun da korona na suksukun adti ulu nan aw malawig na sa-ul na tapel ya batek. Aw miglong si Pilato kanilan, “Inunuwa mayu, ini la sakanan!” ");
INSERT INTO klg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sa pagkita' da na manga mangkatas na magdadugsu-ay aw manga magtatunggu-ay sa Témplo kan Jisus, nyamansag da uman silan na maglong, “Pakalabuwan sakanan! Pakalabuwan sakanan adti krus!” Aw miglong si Pilato kanilan, “Kamu la ya magbaya' kanan! Kamanga mayu aw kamu la ya pagpakalabu kanan adti krus. Kay wala' saba ya kyinita' ku na du-an na umba' sakanan patayen!” ");
INSERT INTO klg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Manang miglong kanan ya manga magdadumala͡ay sa manga Judiyu, “Awun kanami Uldin, aw pigsulat dun na umba' sakanan patayen asuntu sa piglong nan na Ise' kunu sakanan na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sa pagpakadengeg ni Pilato sa piglong nilan, to-o pa sakanan nyallek. ");
INSERT INTO klg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yanagaw syumeled pa sakanan adti palasyo aw pigpa-agad nan si Jisus. Aw pig-usip sakanan ni Pilato, “Taga ayin kaw?” Manang wala' si Jisus tubag kanan. ");
INSERT INTO klg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yanagaw miglong pa si Pilato kanan, “Ananga' dili' aku mu pagtubagen? Unu, wala' mu ka' ka-ede-i na awun katundanan ku magpaluwa' kanmu? Aw awun uman katundanan ku magpakalabu kanmu adti krus.” ");
INSERT INTO klg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tyumubag si Jisus kanan, “Wala' ya katundanan mu kanak kun wala' kanmu atagan ya katundanan lekat adti tas na langit. Yanagaw ya utaw na miglimanda kanak, dakula' pa ya kanan sala' kay sa kanmu.” ");
INSERT INTO klg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sa pagpakadengeg ni Pilato sa piglong ni Jisus, mig-anenganeng sakanan kun unun nan ya pagpaluwa' kan Jisus. Manang miglong pa uman ya manga magdadumala͡ay sa manga Judiyu, “Kun paluwa-en mu sakanan, beke' kaw na ubaybay ni César! Pangkay singalan ya magpakahari', liwan na nyatu sakanan adti kanaten impirador na si César.” ");
INSERT INTO klg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sa pagpakadengeg ni Pilato sa piglong nilan, pigpa-agad nan si Jisus adti luwa'. Aw nyingkud si Pilato adti ingkudanan na pag-ukum dun ni pag-usayan na pigtawag na Gabbata. Na, ya kakawasan na Gabata adti tingeg na Hibriyu: Balkun na Batu. ");
INSERT INTO klg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, ya allaw yeiy yan ya pagtagilan na manga utaw sa Pista na Paglabay na Anghil na Tyumanem, aw manga alas dosi la. Aw miglong si Pilato adti manga magdadumala͡ay sa manga Judiyu, “Ini la ya kamayu hari'!” ");
INSERT INTO klg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aw to-o baling silan nyamansag na maglong, “Pakalabuwan sakanan! Pakalabuwan adti krus!” Yanagaw pig-usip silan ni Pilato, “Unu, pakalabu ku ya hari' mayu?” Aw tyumubag ya manga mangkatas na magdadugsu-ay, “Wala' ya eped na hari' nami, si Impirador César olo'!” ");
INSERT INTO klg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yanagaw pigtumbay ni Pilato si Jisus adti kanilan na un pakalabu adti krus. Tigkas yan, pigdala si Jisus ");
INSERT INTO klg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","na manga sundalu na Romanen aw pigpapisan nilan sakanan sa krus. Aw lyumuwa' silan lekat dun ni syudad aw syuminan adti banwa na pigngalanan adti tingeg na Hibriyu na Golgota, na, ya kakawasan: Banwa na Pesa' na Ulu. ");
INSERT INTO klg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pagdateng nilan dun, pigkalabuwan nilan si Jisus adti krus. Aw dun ni tampid nan awun duwa ya utaw na pigkalabuwan uman adti manga krus nilan, ya sambuk apit adti kalintu aw ya sambuk apit adti kawala. ");
INSERT INTO klg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aw migpasulat si Pilato adti tabla aw pigtapli' nilan adti krus ni Jisus. Aw ini ya pigpasulat nan: “Si Jisus na taga Nazarit, ya Hari' na manga Judiyu.” ");
INSERT INTO klg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aw madég ya nyakabasa seiy asuntu na malapit adti Jérusalim ya banwa na pigpakalabuwan kan Jisus, aw pigsulat yeiy adti tingeg na Hibriyu, aw adti tingeg na Latin, aw adti tingeg na Grigo. ");
INSERT INTO klg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Miglong ya manga mangkatas na magdadugsu-ay adti kan Pilato, “Beke' galu na ‘Hari' sa manga Judiyu’ ya pigpasulat mu! Yan galu ya pigpasulat mu ‘Ya utaw yeiy miglong na Hari' kunu sakanan na manga Judiyu.’ ” ");
INSERT INTO klg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Manang miglong si Pilato kanilan, “Ya pigpasulat ku dili' da pag-umanen!” ");
INSERT INTO klg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pagkatigkas na manga sundalu kalabuwan si Jisus adti krus, pigkamang nilan ya manga kadégkadég nan aw pigtenga' nilan aw alag silan pyangkatpedan. Manang ya piglapid nan adti seled, pigtani nilan kay tumalag inabelan lekat adti tas taman adti dalem aw wala' ya pigté-an, aw dakula' ya alaga'. ");
INSERT INTO klg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yanagaw migbalawbalaw silan kun unu ya madyaw imo-un sa piglapid nan, aw pigtande-an nilan, aw miglong silan, “Dili' tadun késé-en. Madyaw pa na magbunutbunut kitadun kun singalan ya makatagtun sa ini.” Na, maynini ya nya-imo' pada matuman ya pigpasulat na Tyumanem asini muna, “Pigtenga' nilan ya kanaken manga kadégkadég, aw pigbunutbunutan nilan ya kanaken piglapid.” Yanagaw yeiy ya pig-imo' na manga sundalu. ");
INSERT INTO klg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, nyinindeg malapit adti krus ni Jisus ya ina nan, aw ya kaylug na ina nan, aw si Maria na ka͡ubayan ni Kliyopas, aw dun uman si Maria na taga lunsud na Magdala. ");
INSERT INTO klg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aw sa pagkita' ni Jisus sa ina nan aw sa umagakan nan na pigginawa͡an na nyinindeg uman dun, piglongan ni Jisus ya ina nan, “Silinga la sakanan na ise' mu.” ");
INSERT INTO klg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pagkatigkas yan, piglongan ni Jisus ya umagakan yan, “Silinga la sakanan na ina mu!” Aw lekat dun ni udas yan, pigpa-agad da na umagakan yeiy ya ina ni Jisus aw adtu la nan pa-eya-a ni kanan balay. ");
INSERT INTO klg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nya-ede' si Jisus na nyalingeb da ya kadég. Aw miglong sakanan, “Pigtalaynem aku.” Aw dun ni paglong nan, nyatuman ya pigpasulat na Tyumanem asini muna. ");
INSERT INTO klg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na, malapit adti krus awun seledanan na nyatmu' na bino na to-o malagsing. Yanagaw mig-elem ya manga sundalu sa ispongha dun aw pigbetang nilan adti tuktuk na layi' aw pigsungit nilan kan Jisus na un pasepsep kanan. ");
INSERT INTO klg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aw sa abus da nan kasepsep, miglong si Jisus, “Nyalingeb da ya kadég.” Aw nyatungayngay ya ulu nan kay nyabugtu' da ya kanan ginawa. ");
INSERT INTO klg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, agpet da sumallep ya sega dun ni allaw na migsitagilan ya manga Judiyu sa Allaw na Paglagdeng kay ya allaw yan nyakadengan sa Pista. Aw dili' malim ya manga magdadumala͡ay nilan na kenne' pa na manga lawas dun ni krus. Yanagaw migsekat silan kan Pilato na panlepeden ya manga siki na tulu ya utaw na kenne' pa dun ni manga krus, pada maksay silan matay aw kamangen ya manga lawas nilan na un lebeng sa dili' pa sumallep ya sega. ");
INSERT INTO klg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aw nyadtu ya manga sundalu aw pigleped nilan ya manga bitis na manga utaw na pigkalabuwan eped ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Manang pagdateng nilan adti kan Jisus, pigkita' nilan na nyatay da sakanan. Yanagaw wala' da nilan lepeda ya manga bitis nan. ");
INSERT INTO klg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Manang ya pig-imo' na sambuk na sundalu, pigdugsang nan na dilek ya kilid ni Jisus. Aw maksay nyilig ya dugu' aw tubig adti pali' nan. ");
INSERT INTO klg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na, ya kadég yeiy na nya-imo', kyinita' saba na utaw na migsulat seiy. Aw alag matinaw ya pigsulat asini pada dayaw kamu mangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aw nya-imo' ya kadég yeiy pada matuman ya pigpasulat na Tyumanem asini muna, “Dili' sakanan kalepedan sa pesa' pangkay sambuk.” ");
INSERT INTO klg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aw awun pa uman pigpasulat asini muna, “Inunuwun nilan ya utaw na pigdugsang da nilan.” ");
INSERT INTO klg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagkatigkas yan, si José na taga lunsud na Arimatiya, nyadtu ni kan Pilato na un manabi pada tumbay kanan ya pagkamang sa lawas ni Jisus aw tyumande' si Pilato. Yanagaw pigkamang ni José ya lawas ni Jisus. Na, si José, nyangintu-u sakanan kan Jisus na tagu-tagu' kay nyallek sakanan sa manga eped nan na manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Aw nyagad uman kanan si Nikodimo na yan ya migbalawbalaw kan Jisus sambuk na gabi idtu na muna. Aw awun pigdala nan na manimbo' na pigdali-an na mirra aw alobira na ya kabegat na kadég yeiy katluwan tag lima ka kilo. ");
INSERT INTO klg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Aw pigkamang nilan ya lawas ni Jisus aw pig-asagan na manimbo' aw pigbedbedan nilan na manga téla na linum kay yeiy ya katanem na manga Judiyu kun maglebeng silan sa nyatay. ");
INSERT INTO klg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, awun tanemanan na malapit dun ni banwa na pigkalabuwan kan Jisus, aw dun ni tanemanan awun sambuk na ilib na bagu pigkutkutan dun ni kilid na pangpang. Aw wala' pa ya piglebeng dun. ");
INSERT INTO klg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Asuntu na dispiras da na manga Pista na manga Judiyu, aw asuntu na malapit dun ya ilib, yanagaw dun da nilan lebengan ya lawas ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na, sa to-o pa maselem na Linggo na kenne' pa na gabi, nyadtu si Maria na taga Magdala adti piglebengan kan Jisus. Aw pagdateng nan dun, kyinita' nan na nyaka-anggin da ya dakula' na batu lekat adti baka' na ilib. ");
INSERT INTO klg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yanagaw maksay sakanan dyumalagan aw kyadtuwan nan si Simon Pédro aw ya sambuk uman na umagakan na pigginawa͡an ni Jisus. Aw miglong si Maria kanilan, “Pigkamang da nilan ya lawas na Pangulu tadun lekat adti ilib aw wala' nami ka-ede-i kun ayin da nilan betangan!” ");
INSERT INTO klg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sa pagdengeg nilan sa ubat-ubat ni Maria, maksay si Pédro aw ya sambuk na umagakan nyadtu ni ilib. ");
INSERT INTO klg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Alag silan nyalaguy, manang ya sambuk na to-o masaling kay kan Pédro, nyaka-una sakanan dyumateng adti lebeng. ");
INSERT INTO klg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pagdateng nan dun, gyumukung sakanan olo' aw syumilib adti seled, aw pigkita' nan ya manga téla na linum manang wala' da sakanan seled. ");
INSERT INTO klg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pagkatigkas yan, dyumateng da uman si Simon Pédro aw syumeled adti ilib. Aw pigkita' nan ya manga téla na linum ");
INSERT INTO klg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aw ya panyu' na pigbedbed sa ulu ni Jisus. Manang ya panyu' dayaw da nyapiku' aw nyatani lekat adti eped na téla. ");
INSERT INTO klg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pagkatigkas yan, ya umagakan na nyaka-una dyumateng adti ilib, syumeled da uman. Aw sa pagkita' nan na wala' da ya lawas dun, nyangintu-u sakanan na nyataw da si Jisus, ");
INSERT INTO klg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","pangkay wala' pa nilan kalabeti ya kakawasan na pigpasulat na Tyumanem asini muna na ka-ilangan mataw si Jisus lekat adti nyangkamatay. ");
INSERT INTO klg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pagkatigkas yan, lyumiku' silan duwa adti pigbantukan nilan. ");
INSERT INTO klg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Manang si Maria, kenne' nan nyinindeg adti luwa' na ilib na gayed migsugaw. Talana nan migsugaw, gyumukung sakanan aw syumilib adti piglebengan. ");
INSERT INTO klg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aw kyinita' nan na awun duwa ya anghil na syumut sa maputi'. Aw dun silan ingkud ni kyabetangan sa lawas ni Jisus, sambuk apit adti ulunan aw ya sambuk apit adti tuwadan. ");
INSERT INTO klg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aw nyusip silan kan Maria, law nilan, “Ananga' kaw magsugaw?” Aw tyumubag si Maria, “Pigkamang du-an nilan ya lawas na kanaken Pangulu, aw wala' ku ka-ede-i kun ayin nilan betangan.” ");
INSERT INTO klg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagkatigkas ni Maria maglong, lyumingi' sakanan aw pigkita' nan si Jisus na nyinindeg adti luwa' manang wala' nan kilala͡a na si Jisus kadi' ya pigkita' nan. ");
INSERT INTO klg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aw nyusip si Jisus kanan, “Ananga' kaw magsugaw? Singalan ya pigpaninaw mu?” Na, iman ni Maria aw yeiy ya utaw na mig-atiman sa tanemanan, yanagaw miglong sakanan, “Kay Sir, kun ikaw ya migkamang sa lawas nan, ubatan beg kanak kun ayin mu betangan kay kamangen ku ya lawas nan.” ");
INSERT INTO klg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aw miglong si Jisus kanan, “Kay Maria.” Aw nyatubang si Maria kan Jisus aw law nan, “Rabboni!” Na, ya kakawasan na Rabboni adti tingeg na Hibriyu: Magpalna-uway. ");
INSERT INTO klg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aw miglong si Jisus kanan, “Dili' aku mu pag-awidan, kay wala' pa aku ka-engat adti tampid na Ama. Manang kadtuwi baling ya manga inulug ku aw ubat-ubati silan na ma-engat aku adti kanaken Ama na kamayu uman Ama. Yan ya kanaken Tyumanem aw ya kamayu uman Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yanagaw nyadtu si Maria na taga Magdala adti manga umagakan ni Jisus, aw piglongan nan silan, “Pigkita' ku ya Pangulu tadun!” Aw pig-ubat nan uman kanilan ya piglong ni Jisus kanan. ");
INSERT INTO klg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na, sa pagkamagsiklep da na allaw na Linggo, kenne' na manga umagakan ni Jisus adti seled na pigbantukan nilan. Kay nyallek silan sa manga magdadumala͡ay sa manga Judiyu, aw pyambalagsangan nilan ya manga tatakep. Aw wala' nilan pag-imanmana nyaka-indeg si Jisus dun ni tenga' nilan, aw miglong sakanan, “Ya kalinaw gayed magad kamayu!” ");
INSERT INTO klg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkatigkas da nan maglong, pigpakita' nan kanilan ya manga pali' dun ni kanan manga palad aw dun ni kilid nan. Aw to-o migleya ya manga umagakan nan asuntu na kyinita' nilan ya kanilan Pangulu. ");
INSERT INTO klg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aw miglong pa uman si Jisus adti kanilan, “Ya kalinaw gayed magad kamayu! Aw kasiling na pigpadala aku na Ama adti manga utaw asini lupa', kamu uman un ku padala adti manga utaw.” ");
INSERT INTO klg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aw pagkatigkas ni Jisus maglong seiy, pig-eyepan nan na kanan ginawa ya kadég nilan, aw miglong sakanan, “Dawata mayu ya Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aw adun, kun maglong kamu adti pangkay singalan na nyalanas da ya manga sala' nilan, piglanas da saba na Tyumanem. Manang kun dili' kamu maglong na malanas da ya manga sala' nilan, na kenne' pa na manga sala' nilan.” ");
INSERT INTO klg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, si Tomas sambuk na umagakan ni Jisus na nyaka-akup dun ni sampulu' tag duwa. Aw pagtawagen sakanan na Pingin. Manang sa pagpakita' ni Jisus kanilan, wala' dun si Tomas. ");
INSERT INTO klg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yanagaw pig-ubatan nilan sakanan, law nilan, “Pigkita' nami ya kanaten Pangulu!” Manang miglong si Tomas kanilan, “Kun dili' ku una kita-en aw madamdam ya manga pali' na kya-agiyan na kalabu, aw kun dili' ku malungug ya tullu' ku adti kilid nan na pigdugsang na sundalu, dili' aku mangintu-u sa piglong mayu.” ");
INSERT INTO klg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aw sa paglabay da na walungallaw, migkatipun da uman ya manga umagakan ni Jisus dala uman si Tomas adti pigbantukan nilan. Pangkay pigbalagsangan nilan ya manga tatakep, manang bigla' da uman migpakita' si Jisus dun ni tenga' nilan aw miglong sakanan, “Ya kalinaw gayed magad kamayu!” ");
INSERT INTO klg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pagkatigkas yan, piglongan ni Jisus si Tomas, “Kay Tomas, adi kaw. Damdama ya palad ku na kya-agiyan na kalabu, aw lungugan ya tullu' mu adi kilid ku na pigdugsang na sundalu. Dili' da kaw magduwa-duwa, manang pangintu-uwi baling ya pigkita' mu.” ");
INSERT INTO klg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aw miglong si Tomas, “Kay Magpalna-uway! Ikaw saba ya kanak Pangulu aw ya kanak Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aw nyusip si Jisus kanan, “Unu, nyangintu-u la kaw na nyataw da aku lekat adti nyangkamatay asuntu na pigkita' aku mu? Madyaw ya kana manga utaw na nyangintu-u kanak pangkay wala' aku nilan kita-a.” ");
INSERT INTO klg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, madég pa uman ya manga milagru na pig-imo' ni Jisus dun ni tampid na manga umagakan nan na wala' ka͡abus pakasulat asini libru ini. ");
INSERT INTO klg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Manang ya nyakasulat asini, pigsulat pada mangintu-u kamu na si Jisus yan ya Kristu, ya Ise' na Tyumanem. Aw magi sa pagpangintu-u mayu kanan, matagtun mayu ya ginawa na wala' ya katigkasan. ");
INSERT INTO klg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Paglabay da na pilangallaw, migpakita' da uman si Jisus adti kanan manga umagakan dun ni ligad na Danaw na Tibériyas. Maynini ya nya-imo': ");
INSERT INTO klg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Migkatipun si Simon Pédro, aw si Tomas na pagtawagen uman na Pingin, aw si Natanyél na taga Cana sakup na Galilya, aw ya duwa ya ise' ni Zibidiyo na eseg, aw ya duwa pa uman na umagakan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aw miglong si Simon Pédro adti manga eped nan, “Un pa aku mamiyala.” Aw law nilan, “Magad kami kanmu!” Aw syumakay silan sa balangay aw syuminan adti ltenga-tenga' na danaw. Aw sanggabi nilan ya nyamiyala manang wala' ya nyakamang nilan. ");
INSERT INTO klg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na, sa to-o pa maselem, kyinita' nilan si Jisus nyinindeg adti baklayan dun ni ligad na danaw, manang wala' nilan kilala͡a kun singalan sakanan. ");
INSERT INTO klg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aw migtatawag si Jisus kanilan, “We...Lew! Awun nyakamang mayu?” Aw tyumubag silan kanan, “Wala' kay Lew, pangkay sambuk.” ");
INSERT INTO klg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aw migtatawag pa uman si Jisus kanilan, “Agbelan ya biyala mayu apit adti kalintu aw awun makamang mayu.” Yanagaw pig-agbel nilan ya kanilan biyala apit adti kalintu, aw to-o madég ya isda' na nyakamang nilan menda' na wala' da galu nilan kabatug engata. ");
INSERT INTO klg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aw miglong kan Pédro ya sambuk kanilan na pigginawa͡an ni Jisus, “Wettay, ya migtatawag kadi' kanaten, yan ya Pangulu tadun!” Aw sa pagdengeg ni Simon Pédro na si Jisus ya adti baklayan, maksay nan pigsut ya sa-ul nan, aw tyumellek sakanan aw kyumapay pasinan adti kan Jisus. ");
INSERT INTO klg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Manang ya manga eped na umagakan, kenne' pa nilan adti balangay aw pigguyud nilan ya biyala na nyatmu' na isda'. Kay ya kawat lekat adti ligad na danaw, manga kalima͡an ka depa. ");
INSERT INTO klg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sa pagpakataklang da nilan adti baklayan, awun kyinita' nilan na manga baga na uling aw isda' na pigpasagan, aw awun uman pan. ");
INSERT INTO klg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aw miglong si Jisus kanilan, “Dala kamu kanate' adi sa isda' na nyakamang mayu!” ");
INSERT INTO klg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yanagaw nyanik si Simon Pédro sa balangay aw pigbeklas nan ya biyala na kenne' pa nyatmu' na manga mangkabakla' na isda'. Sanggatus aw kalima͡an tag tulu ya kadég na isda' adti seled manang wala' kakésé' ya biyala. ");
INSERT INTO klg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pagkatigkas yan, miglong si Jisus kanilan, “Kan da kamu adi!” Aw wala' ya pangkay sambuk na manga umagakan nan na nyangusip kun singalan sakanan kay kya-ede-an da nilan na yan ya Pangulu. ");
INSERT INTO klg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aw pigkamang ni Jisus ya pan aw isda' na abus da nan pasagi aw pigtenga-tenga' nan adti kanilan. ");
INSERT INTO klg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, yeiy ya katlu na pagpakita' ni Jisus adti kanan manga umagakan pagkatigkas na pagkataw nan lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkatigkas nilan kuman, miglong si Jisus kan Simon Pédro, “Kay Simon na ise' ni Juan, unu, dakula' ya pagginawa mu kanak kay sa pagginawa na manga eped mu ini kanak?” Aw tyumubag si Pédro, “E-e, kay Pangulu. Kya-ede-an mu na to-o ta kaw pigginawa͡an.” Aw miglong si Jisus kanan, “Pakana ya kanak manga karniro.” ");
INSERT INTO klg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Miglong pa uman si Jisus, “Kay Simon na ise' ni Juan, unu, tengteng aku mu pigginawa͡an?” Aw law ni Pédro, “E-e, kay Pangulu, kya-ede-an da mu saba na to-o ta kaw pigginawa͡an.” Aw miglong pa uman si Jisus, “Diyagayi ya kanak manga karniro.” ");
INSERT INTO klg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dun ni katlu na usip ni Jisus, miglong sakanan, “Kay Simon na ise' ni Juan, unu, tengteng aku mu pigginawa͡an?” Migkalat ya ginawa ni Pédro asuntu na pig-usip sakanan ni Jisus na makatlu, “Unu, pigginawa͡an aku mu?” Yanagaw miglong si Pédro, “Kay Pangulu, nya-ede' kaw sa kadég. Kya-ede-an da mu saba na to-o ta kaw pigginawa͡an!” Aw miglong si Jisus, “Diyagayi ya kanak manga karniro.” ");
INSERT INTO klg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pagkatigkas yan, miglong pa uman si Jisus adti kan Pédro, “Matinaw ya un ku paglongun kanmu: Idtu na bagu pa ya ginawa mu, ikaw ya magbaya' sa kanmu pagka-utawun, kun unu ya un mu sutun aw kun ayin kaw pasinan. Manang pagkabakleg da mu, eped da na utaw ya mag-ulad sa kanmu manga bekten, aw eped na utaw ya magpasut kanmu, aw silan ya magbaya' kanmu. Aw pa-agad kaw nilan adti banwa na dili' mu kaliman kadtuwan.” ");
INSERT INTO klg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na, maynan ya piglong ni Jisus pada pa-ede' kanan kun unu ya ka-agiyan na pagkamatay ni Pédro, aw magi dun, un nan basa͡an ya Tyumanem. Pagkatigkas yan, miglong si Jisus kan Pédro, “Dalug kaw kanak!” ");
INSERT INTO klg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aw sa paglingi' ni Pédro, kyinita' nan na gyumuyud kanilan ya sambuk na umagakan na pigginawa͡an ni Jisus. Yeiy ya umagakan na nyangunsalig dun ni aba ni Jisus adti pagpangiyambung idtu muna aw nyusip kan Jisus kun singalan ya un maglubid kanan. ");
INSERT INTO klg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sa pagkita' ni Pédro kanan, nyusip sakanan kan Jisus, “Kay Pangulu, unu ya datengan na utaw yeiy?” ");
INSERT INTO klg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aw tyumubag si Jisus kanan, “Kun kaliman ku na meya' pa sakanan asini tas na lupa' menda' sa pagliku' ku, unu ya kanmu labet? Gayed kaw sa kanmu dalug kanak!” ");
INSERT INTO klg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Asuntu sa piglong nan yeiy, nyabekkal baling adti manga mangintu-uway ya kasampetanen na dili' kunu matay ya sambuk na umagakan na pigginawa͡an ni Jisus. Manang wala' si Jisus paglong na dili' sakanan matay. Yan olo' ya piglong nan, “Kun kaliman ku na meya' pa sakanan asini tas na lupa' menda' sa pagliku' ku, unu ya kanmu labet?” ");
INSERT INTO klg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aw yeiy ya umagakan ni Jisus na migmatinaw sa kadég na pigsulat nan asini, kay alag nan kyinita'. Aw kya-ede-an tadun na alag matinaw ya piglong nan asini. ");
INSERT INTO klg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Madég pa ya manga pig-imo' ni Jisus, aw kun mabus sulaten adti libru, ya kadég na manga libru dili' masa asini kadakula' na banwa.");
INSERT INTO klg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kay Tyupilo: Dun ni tagna' na libru na pigsulat ku idtu muna, pigpa-ede' ku ya kadég na pigpan-imo' ni Jisus aw ya kadég na pigpalna-u nan, lekat adti pagpalekat na imo-unun nan ");
INSERT INTO klg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","taman na allaw na nya-engat sakanan adti tas na langit. Na, pagkatigkas na pagkamatay nan, nyataw sakanan aw migpakita' adti manga apostolés na dadan da nan pigpamalli'. Seled na kapatan ya allaw, pigmatinaw nan na nyataw sakanan lekat adti pagkamatay, aw gayed nan pigpa-ede' kanilan ya Kasakupan na Pighari-an na Tyumanem, aw piglongan nan silan magi sa katulus na Ispiritu Santo kun unu ya un nilan imo-un. ");
INSERT INTO klg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sa kenne' pa ni Jisus adti tampid nilan, piglongan nan silan, “Dili' pa kamu magpanaw asini Jérusalim manang tagadi mayu una asini ya pigpakang na Ama na dyengeg mayu adi kanak. ");
INSERT INTO klg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Idtu muna sa utaw pa si Juan, pigba͡utismuwan kamu nan magi sa tubig, manang dili' madugay un kamu ba͡utismuwan magi sa Ispiritu Santo.” ");
INSERT INTO klg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pagkatipun da uman nilan, nyusip silan kan Jisus, law nilan, “Kay Magpalna-uway, unu ka', paluwa-en da mu adun ya nasud na Isra-él lekat adti pagsakup na Roma aw ikaw da ya maghari'?” ");
INSERT INTO klg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aw tyumubag si Jisus, “Wala' tumbayan kamayu ya pagka-ede' kun kinunu yan ka-imo', kay ya Ama, yan ya magbaya' sa kadég. ");
INSERT INTO klg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Manang dun ni allaw na pagdateng na Ispiritu Santo adti kamayu, madawat mayu ya katulus na Tyumanem. Yanagaw kamu ya magmatinaw kanak asini Jérusalim, aw adti kadakula' na probinsya na Judiya aw banwa na Samarya, aw pangkay adti kadakula' na banwa.” ");
INSERT INTO klg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkatigkas ni Jisus maglong kanilan, nya-engat sakanan adti langit aw gayed nilan pigtandawan menda' na kyasalibenan na labun aw wala' da nilan sakanan kita-a. ");
INSERT INTO klg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sa kenne' pa nilan lyumangad adti langit, bigla' nyaka-indeg dun ni sayid nilan ya duwa ya eseg na syumut sa kadégkadég na alag maputi'. ");
INSERT INTO klg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aw law nilan, “Kay manga taga Galilya, ananga' kenne' pa mayu mig-indeg-indeg asini aw lyumangad adti langit? Ya Jisus na nya-engat lekat adti kamayu pasinan adti tas na langit, dumateng ya allaw na lumiku' sakanan, aw maynini uman ya ma-imo' dun ni pagliku' nan.” ");
INSERT INTO klg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na, ya kadég yeiy nya-imo' adti buntud na pigngalanan na Olibo adti dipag na syudad na Jérusalim. Aw tigkas yan, lyumiku' ya manga apostolés adti Jérusalim, aw ya kawat na pigpanawan nilan sangka kilomitro. ");
INSERT INTO klg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aw syumeled silan adti bantukanan aw nyanik adti gibalayan na awun ni kadwa na kansad. Aw migkatipun silan si Pédro, aw si Juan, aw si Santiago, aw si Andrés, aw si Pilipé, aw si Tomas, aw si Baltolomi, aw si Matiyo, aw si Santiago na ise' ni Alpiyo, aw si Simon na nyakasakup idtu muna adti partido na manga Zéloti, aw si Judas na ise' ni Santiago. ");
INSERT INTO klg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aw gayed migsambuk ya ginawa nilan aw nyatibulluk adti pagpanawagtawag sa Tyumanem. Aw dun uman ya manga ka͡ubayan na nya-imo' umagakan ni Jisus, aw si Maria na ina nan, aw ya manga mangud ni Jisus na eseg. ");
INSERT INTO klg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sambuk na allaw yan, migkatipun ya manga sanggatus aw kaluwa͡an ya manga mangintu-uway kan Jisus. Aw nyindeg si Pédro aw piglongan nan ya kadég nilan, ");
INSERT INTO klg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kay manga inulug ku, nyatuman da ya pigpa-ede' dadan ni Dabid magi sa katulus na Ispiritu Santo, aw yeiy saba ya pag-allad ni Judas sa manga utaw na migdakep kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas, yan ya sambuk na eped nami na pigpamalli' ni Jisus na tyumabang sa manga imo-unun nan.” ");
INSERT INTO klg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, yeiy ya nya-imo' kan Judas: Ya pigtandan kanan sa pig-imo' nan na malatay, pigbayad nan sa lupa'. Aw adti lupa' na pigbayadan nan, dun sakanan kolug lekat adti kawuy na nyaka-una ya ulu nan aw nyakadakdak adti lupa' aw nyutu' ya buntit nan aw lyumuwa' ya tinay nan. ");
INSERT INTO klg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pagdengeg da na manga utaw na nyeya' dun ni Jérusalim sa kyagamakan ni Judas, pigngalanan nilan ya lupa' yan na Akéldama. Ya kakawasan: lupa' na pigbayadan na dugu'. ");
INSERT INTO klg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Migpadeleg pa si Pédro miglong, “Yeiy ya pigsulat asini muna dun ni Salmo: ‘Pabaya-an da galu na kadég na manga utaw ya kanan eya-anan aw wala' da ya un pa-eya-en dun ni lupa' yan.’ Aw pigsulat uman, ‘Madyaw awun sumayu sa katundanan nan.’ ” ");
INSERT INTO klg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Miglong pa uman si Pédro, “Ka-ilangan awun sambuk uman na eseg na un ma-imo' apostol eped nami aw magmatinaw sa pagkataw ni Jisus na kanaten Pangulu lekat adti pagkamatay. Aw ya umba' pamalli-en, yan ya sambuk na utaw na nyaka-iyeped kanami lekat adti allaw na pagba͡utismu ni Juan kan Jisus taman na allaw na nya-engat si Jisus adti tas na langit.” ");
INSERT INTO klg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yanagaw awun duwa ya eseg na un nilan pamalli-an. Ya sambuk, yan si José na pigngalanan uman na si Barsabas na pagtawagen nilan na Justo. Aw ya sambuk, yan si Matiyas. ");
INSERT INTO klg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pagkatigkas yan, nyanawagtawag silan, law nilan, “Kay Tyumanem na awun ni tas na langit: Kya-ede-an mu ya anenganeng na kadég na utaw. Pa-ede-an beg kanami kun singalan kanilan ya pigpamalli' da mu ");
INSERT INTO klg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na ma-imo' apostol na un sumayu kan Judas. Kay pig-ayawan ni Judas ya katundanan nan aw adtu la sakanan ni banwa na umba' kanan.” ");
INSERT INTO klg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatigkas yan, migbunutbunut silan, aw kan Matiyas ngalan ya kyabunutan, aw nya-imo' sakanan apostol eped na sampulu' taggesya'. ");
INSERT INTO klg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na, dyumateng da ya Pista na Péntékostés, aw ya kadég na manga mangintu-uway kan Kristu dun ni Jérusalim, migsambuk silan adti dakula' na balay. ");
INSERT INTO klg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aw tigkan awun dalagunut na lekat adti tas na langit kasiling na mabandes na samet aw nyatmu' na dalagunut ya balay na pigkatipunan nilan. ");
INSERT INTO klg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Awun uman migpakita' kanilan na manga laga na iman mu aw manga dila' na mig-atped-atped adti tagsambuksambuk kanilan. ");
INSERT INTO klg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aw nyatmu' ya kadég nilan na Ispiritu Santo, aw migpalekat silan miglong sa madég na punganan na tingeg na wala' pa nilan lemena paglongan. Nyakapaglong silan sa manga tingeg yeiy magi sa katulus na Ispiritu na pig-atag kanilan na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, asuntu sa manga pista, awun madég na utaw na Judiyu na dadan da dyumateng adti Jérusalim lekat adti madég na nasud kay to-o nyatibulluk ya kanilan ginawa sa pagdalug sa Uldin na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagdengeg nilan sa kawayit lekat adti seled na balay yan, nyaksay silan migkatipun. Aw to-o silan nyabelengbeleng kay dyengeg na tagsambuksambuk ya kanilan tengteng tingeg, ");
INSERT INTO klg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","aw to-o silan nya-enneng-enneng. Aw mig-usip-usipay silan, “Wettay, wan yangadi? Ya manga utaw yeiy alag saba silan taga Galiliya! ");
INSERT INTO klg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ananga' silan makapaglong sa kanaten manga tingeg na lekat adti manga banwa na pigka͡utawan tadun? ");
INSERT INTO klg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ya eped kanaten taga Partiya, aw taga Médiya aw taga Élam. Awun eped na lekat adti Mésopotamiya, aw Judiya, aw Capadocia aw Ponto aw Asia, ");
INSERT INTO klg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","aw Pridya, aw Pampiliya. Awun uman lekat adti Ihiptu, aw lekat adti manga sakup na Libya na malapit adti syudad na Ciréné, aw pangkay manga taga Roma dala ya Judiyu aw manga Héntil na dyumalug da sa Uldin aw katanem na manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aw ya eped taga Krita aw taga Arabiya. Alag tadun pigdengeg ya piglong nilan adti tagsambuksambuk na kanaten tingeg. Aw yan ya pigkasampetan nilan ya to-o mangkadyaw na pigpan-imo' na Tyumanem magi sa katulus nan!” ");
INSERT INTO klg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aw to-o silan nya-enneng-enneng aw nyabelengbeleng sa nya-imo' dun. Aw mig-usip-usipay silan, “Unu ya kakawasan na kadég yeiy?” ");
INSERT INTO klg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Manang awun eped kanilan na mig-odoy-odoy sa manga mangintu-uway, law nilan, “Ya manga utaw yan, nyalangulangu silan na inemenen!” ");
INSERT INTO klg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Manang nyindeg si Pédro aw ya eped nan na sampulu' taggesya' adti asdangan na kadég na manga utaw, aw miglong si Pédro adti kanilan magi sa mabagseg na tingeg. Law nan, “Kay manga kadégan ku na manga Judiyu aw kadég mayu na nyeya' asini Jérusalim, pakanyegi mayu ya un ku paglongun. ");
INSERT INTO klg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ya manga utaw na dyengeg mayu kakayna, iman mayu aw nyalangulangu silan na inemenen, manang beke' na maynan, kay bagu pa saba alas nibi na maselem! ");
INSERT INTO klg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ya nya-imo' adun na allaw ini, katumanan yeiy sa pigsulat na propita na si Joél asini muna: ");
INSERT INTO klg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ini ya piglong na Tyumanem. Dun ni manga kamoliyan na allaw, un ku atag ya kanak Ispiritu adti kadég na manga utaw. Ya manga buwadbuwad mayu na eseg aw bubay, un nilan ubat-ubat ya pa-ede' ku kanilan. Aw ya manga eseg na bagu pa ya ginawa, awun pakita' ku kanilan. Aw ya manga bakleg mayu, un ku silan patagaynepen. ");
INSERT INTO klg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aw pangkay ya kanak manga sugu-anen na eseg aw bubay, atag ku kanilan ya kanak Ispiritu, aw un nilan ubat-ubat ya pa-ede' ku kanilan. ");
INSERT INTO klg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magpakita' aku sa madég na pangilala adti langit aw manga milagru asini tas na lupa': Kita-en ya dugu' aw atulun aw madakmel na ebel. ");
INSERT INTO klg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ya sega magkangitngit, aw ya bulan iman mu aw dugu'. Maynan alag ya un mangka-imo' sa dili' pa dumateng ya allaw na pagdateng na Tyumanem, aw yeiy ya allaw na to-o madyaw aw wala' ya maka-unawa. ");
INSERT INTO klg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aw pangkay singalan ya magtawag adti Tyumanem, paluwa-en saba sakanan.’ ” ");
INSERT INTO klg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Migpadeleg si Pédro mig-ubat-ubat kanilan, law nan, “Kay manga kadégan ku na utaw na Isra-él, pakanyegi mayu ya tingeg ku! Ya Tyumanem ya migpa-ede' na si Jisus na taga Nasarit ya Pigpadala nan asini kanaten, aw kya-ede-an mayu kay pigmatinaw nan adti kamayu magi sa madég na manga pangilala aw milagru na pig-imo' ni Jisus. ");
INSERT INTO klg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aw si Jisus yeiy, dadan da na Tyumanem pigpalpa na un nan atag adti kamayu, aw kya-ede-an da nan dadan na un mayu tumanen ya pigpalpa nan, kay pigtumbay mayu si Jisus adti manga utaw na mag-imo' sa malatay, yanagaw kamu ya migpakalabu kanan adti krus. ");
INSERT INTO klg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Manang pigmataw sakanan na Tyumanem aw pigpaluwa' lekat adti katulus na kamatayen, kay dili' saba sakanan mabatug tagenan na kamatayen. ");
INSERT INTO klg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kay awun piglong ni Dabid asini muna na nyatuman dun ni kan Jisus: ‘Gayed ku pigkita' ya Tyumanem, kay dun da sakanan adti kalintu ku pada dili' aku ma-inang-inang. ");
INSERT INTO klg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yanagaw to-o aku migleya, aw dili' ku katagenan ya kanak pagdeyen kanan. Kya-ede-an ku na pangkay matay pa ya lawas ku manang awun pa imanen. ");
INSERT INTO klg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kay dili' mu pabaya-an ya kalaluwa ku adti banwa na Kaludukan. Aw aku na gayed migtuman sa pagkaliman mu, dili' mu tumbay na malandak ya kanak lawas adti lebeng. ");
INSERT INTO klg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pigpa-ede' da mu kanak ya un ku agiyan pasinan adti ginawa na wala' ya katigkasan, aw to-o aku magleya kay awun kaw gayed ni sayid ku.’ ” ");
INSERT INTO klg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Miglong pa si Pédro kanilan, “Kay manga kadégan ku, matinaw saba ya piglong ku kamayu sa tyugbulan tadun asini muna na si Dabid. Nyatay da sakanan aw piglebeng, aw kenne' pa na piglebengan kanan asini kanaten. ");
INSERT INTO klg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yanagaw asuntu na si Dabid sambuk na propita, kya-ede-an da nan na pigsapa-an sakanan na Tyumanem na ya sambuk na buwadbuwad nan un na Tyumanem pa-ingkudun adti trunu nan. ");
INSERT INTO klg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aw asuntu na kya-ede-an ni Dabid ya un dumateng, pigsulat nan ya pagkataw na Kristu lekat adti pagkamatay. Aw matinaw saba ya pigsulat nan na wala' na Tyumanem pabaya-i ya kalaluwa ni Jisus adti banwa na Kaludukan, aw wala' kalandak ya lawas nan adti lebeng. ");
INSERT INTO klg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Jisus yeiy, pigmataw da saba na Tyumanem. Aw pagkatigkas na pagkataw nan, kyinita' na kadég nami. ");
INSERT INTO klg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aw pigpatas da sakanan dun ni ingkudanan na to-o dengganen apit adti kalintu na Tyumanem adti tas na langit. Aw kasiling na pigpakang na Ama, pig-atag nan kan Jisus ya kanan Ispiritu, aw pig-atag da uman ni Jisus adti manga utaw. Aw ya kadég na kyinita' aw dyengeg mayu kakayna, alag yeiy nya-imo' magi sa katulus na Ispiritu nan. ");
INSERT INTO klg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kay beke' ni Dabid ya nya-engat adti tas na langit, manang yeiy ya pigsulat nan asini muna, law nan, ‘Miglong ya Tyumanem adti kanaken Pangulu, “Ingkud kaw apit adi kalintu ku ");
INSERT INTO klg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","menda' na mabus ku degen ya kanmu manga po-on aw alag ku silan betang adti salad na siki mu.” ’ ");
INSERT INTO klg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yanagaw kamu na buwadbuwad ni Isra-él, ka-ilangan mayu kalabetan na si Jisus na pigpakalabu mayu adti krus, yan saba ya pig-imo' na Tyumanem Kristu na Magpaluwa-ay kanaten aw Pangulu tadun.” ");
INSERT INTO klg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagdengeg da na manga utaw sa ubat-ubat ni Pédro, kyelegan ya ginawa nilan, yanagaw nyusip silan kan Pédro aw sa eped pa na manga apostolés, law nilan, “Kay manga inulug, unu ya madyaw nami imo-un?” ");
INSERT INTO klg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aw tyumubag si Pédro kanilan, “Ya tagsambuksambuk kamayu, selseli ya manga sala' mayu aw pagpaba͡utismu kamu dun ni ngalan ni Jisu-Kristu, aw lanasen na Tyumanem ya manga sala' mayu, aw madawat mayu ya kanan Ispiritu. ");
INSERT INTO klg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kay yan ya pigpakang na Tyumanem kanaten aw sa manga buwadbuwad tadun aw pangkay adti manga utaw na Héntil, taman na kadég na tawagen na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Madég pa ya pigpalna-u ni Pédro kanilan dun ni allaw na Péntékostés, aw nyanginayu' sakanan sa manga utaw na magselsel silan, law nan, “Ka-ilangan na makaluwa' kamu pada dili' kamu pa-emel-emelen na Tyumanem eped na manga utaw na malatay adun na manga allaw yeiy.” ");
INSERT INTO klg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aw dun ni allaw yan, awun manga tulummalalan ya nyangintu-u la sa pig-ubat-ubat ni Pédro, aw pigba͡utismuwan silan aw nyakadugang da adti manga eped na manga mangintu-uway dun. ");
INSERT INTO klg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aw ya manga bagu mangintu-uway, gayed nyatibulluk migpakanyeg sa palna-u na manga apostolés, aw migsambuk silan migkatipun, aw migsambuk uman silan kyuman, aw migsambuk sa pagpanawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aw pigpan-imo' na manga apostolés ya madég na pangilala aw milagru magi sa katulus na Tyumanem. Aw pigbasa͡an na manga utaw ya Tyumanem na awun pagkallek. ");
INSERT INTO klg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aw gayed migpangkatipun ya kadég na manga mangintu-uway, aw pigsambuk nilan ya manga pametang nilan. ");
INSERT INTO klg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aw migpalekat ya eped miggalin sa lupa' aw manga ka-unan nilan pada awun kuwalta na un atag adti manga eped nilan na migkapelek. ");
INSERT INTO klg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aw kada allaw migkatipun ya mangintu-uway adti pamanag na Témplo na Tyumanem, aw gayed silan migsambuk kyuman adti manga balay nilan aw to-o silan migleya, ");
INSERT INTO klg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","aw gayed nilan pigdeyen ya Tyumanem. Aw pigsaya' silan na kadég na utaw. Aw kada allaw pigdugangan na Tyumanem ya manga utaw na pigpaluwa' da nan. ");
INSERT INTO klg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sambuk na allaw, migpasinan si Pédro aw si Juan adti Témplo na manga alas trés na ambung kay yan ya udas na pagpanawagtawag na manga utaw na Judiyu sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sa malapit da silan adti Témplo, awun eseg dun na kapig na lekat pa na pagka͡utaw nan. Aw dun pagbetang na manga utaw na magtingga kanan kada allaw na un magsekat sa limos adti manga utaw na sumeled adti suwangan na pigngalanan na “Manenggeya.” ");
INSERT INTO klg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aw sa pagkita' nan kan Pédro aw kan Juan, migsekat sakanan sa kuwalta. ");
INSERT INTO klg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Manang pigtengtengan nilan ya utaw yan, aw law ni Pédro, “Inunuwa kami!” ");
INSERT INTO klg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aw pigtengtengan nan uman ya duwa kay yan ya pig-iman nan na atagan nilan sakanan na kuwalta. ");
INSERT INTO klg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Manang miglong si Pédro, “Wala' ya kuwalta ku, manang ya ini kanak na nyatagtun ku, yan ya un ku atag kanmu. Na! Dun ni ngalan ni Jisu-Kristu na taga Nasarit, indeg kaw aw panaw kaw!” ");
INSERT INTO klg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aw pig-awidan ni Pédro ya kalintu na bekten nan aw dayaw nan pa-indega. Aw tigkan migkabagseg ya siki nan ");
INSERT INTO klg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","aw nyaka-indeg da aw nyanaw, aw nyagad kanilan adti seled na Témplo na gayed mig-ugpasen na migdeyen sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aw kyinita' na kadég na manga utaw na nyakapanaw da sakanan aw migdeyen sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kyilala nilan sakanan na yan ya eseg na nyingkud dun ni Suwangan na Manenggeya na gayed nyangilalat. Aw to-o silan nyabelengbeleng sa nya-imo' kanan. ");
INSERT INTO klg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ya eseg na bagu makapanaw, wala' pakaluwat kan Pédro aw kan Juan dun ni agiyanan na pigngalanan na Portiko ni Solomon na awun ni pamanag na Témplo. Aw migkagallat ya madég na manga utaw migpalapit kanilan kay to-o silan nya-enneng-enneng sa kyinita' nilan. ");
INSERT INTO klg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aw sa pagkita' ni Pédro sa manga utaw, miglong sakanan kanilan, “Kay manga kadégan ku na manga utaw na Isra-él, ananga' kamu ma-enneng-enneng sa kyinita' mayu? Ananga' gayed kamu nyinunu kanami? Pagaw iman mayu aw awun katulus nami magpapanaw sa utaw yeiy. Aw iman mayu uman aw nyakapanaw da sakanan kay dyalug nami ya Uldin na Tyumanem? ");
INSERT INTO klg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Manang beke' saba na maynan! Ya kyinita' mayu kakayna lyumekat saba adti kana Tyumanem na manga tyugbulan tadun na si Abraham aw si Isa-ak aw si Jakub. Aw pigpakita' da nan ya pagka Tyumanem na sugu-anen nan na si Jisus. Manang si Jisus yeiy, pigtumbay mayu baling na patayen, aw pigkele͡an mayu adti asdangan na gubirnador na si Pilato, pangkay kaliman ni Pilato na paluwa-en sakanan. ");
INSERT INTO klg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pigkele͡an mayu ya Pigpadala na Tyumanem na wala' ya sala'! Aw pigsekat mayu baling na paluwa-en ya sambuk na utaw na migpatay sa eped na utaw. ");
INSERT INTO klg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Aw pigpapatay mayu ya piglekatan sa ginawa, manang pigmataw na Tyumanem lekat adti pagkamatay nan, aw migmatinaw kami na nyataw da sakanan. ");
INSERT INTO klg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aw ya utaw ini na pigkilala mayu, ya pagpangintu-u nan sa ngalan ni Jisus, yan ya migpakabagseg sa siki nan. Si Jisus saba ya pyangintu-uwan nan aw yan ya nyatag sa pagkadyaw na lawas nan asini asdangan na kadég mayu. ");
INSERT INTO klg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na, kamu na manga kadégan ku, kya-ede-an da ku adun na idtu na pagpapatay mayu kan Jisus, wala' mayu kilala͡a na yan ya Pigpadala na Tyumanem. Aw wala' uman sakanan kilala͡a na manga migdumala kamayu. ");
INSERT INTO klg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Manang dun ni pig-imo' mayu kan Jisus, pigtuman na Tyumanem ya pigpa-ede' nan dadan magi sa manga propita nan asini muna na un magti-is ya Kristu aw matay. ");
INSERT INTO klg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yanagaw pagselsel kamu sa manga sala' mayu aw ka͡agadi mayu ya Tyumanem pada lanasen nan ya manga sala' mayu. Kun imo-un mayu yeiy, dumateng ya manga allaw na pakaganen na Tyumanem ya ginawa mayu, ");
INSERT INTO klg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","aw padala pa nan salut asini tas na lupa' ya Misiyas na un magdumala kamayu, na yan saba si Jisus. ");
INSERT INTO klg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Manang ka-ilangan pa sakanan matingen adti tas na langit taman na allaw na baguwun ya kadég, kay pigpa-ede' na Tyumanem dadan adti kanan manga propita na yan ya un nan imo-un. ");
INSERT INTO klg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Miglong si Moysis asini muna adti manga utaw na Isra-él, law nan, ‘Un magpadala ya Tyumanem kamayu adti moli na allaw sa propita kasiling kanaken. Aw ya propita yan, un lumekat adti buwadbuwad ni Isra-él. Pakanyegi mayu ya kadég na un nan paglongun. ");
INSERT INTO klg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aw pangkay singalan ya dili' dumalug sa piglong na propita yeiy, taniyen sakanan aw patayen.’ ");
INSERT INTO klg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Aw si Samwél uman aw ya eped na manga propita na syumayu kanan, mig-ubat-ubat ya kadég nilan asini muna kun unu ya ma-imo' adun na manga allaw yeiy. ");
INSERT INTO klg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aw kitadun saba na Judiyu ya dyumawat adun sa pigpakang na Tyumanem adti tyugbulan tadun magi sa manga muna propita. Kay miglong ya Tyumanem kan Abraham asini muna, ‘Magi dun ni manga buwadbuwad mu, pakadyawun ku ya kadég na utaw na asini tas na lupa'.’ ");
INSERT INTO klg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yanagaw pigpadala na Tyumanem asini tas na lupa' ya kanan sugu-anen, aw kitadun na manga utaw na Isra-él ya muna nan pigpadala͡an, pada pakadyawun kitadun magi dun ni pagtabang nan sa tagsambuksambuk kanaten na un tadun talikudan ya pag-imo' sa malatay.” ");
INSERT INTO klg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sa wala' pa katigkas ni Pédro aw ni Juan ya pag-ubat-ubat adti manga utaw dun ni pamanag na Témplo, dyumulud adti kanilan ya manga magdadugsu-ay, aw ya kapitan na manga magtatunggu-ay sa Témplo, aw ya manga Sadusiyo. ");
INSERT INTO klg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aw nyadaman silan to-o kay pigpalna-uwan ni Pédro aw ni Juan ya manga utaw aw pig-ubat-ubat nilan ya pagkataw ni Jisus aw ya pagkataw uman na manga utaw lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yanagaw pigdakep nilan si Pédro aw si Juan. Aw asuntu na gabi la, pigpakalabusu nilan taman na maselem. ");
INSERT INTO klg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Manang ya manga utaw na migpakanyeg sa pig-ubat-ubat ni Pédro, madég kanilan ya nyangintu-u. Aw limammalalan ya kadég na manga eseg na nyangintu-u la kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na, pagkamaselem da, migkatipun dun ni Jérusalim ya magdadumala͡ay sa manga Judiyu, aw manga magpalna-uway sa Uldin nilan, aw ya kanilan manga mangkalangkaw. ");
INSERT INTO klg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aw dun uman si Anas na pangulu sa manga magdadugsu-ay, aw manga eped pa na kadégan nan dala si Kaypas aw si Juan aw si Aléjandro. ");
INSERT INTO klg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pigpa-angay nilan si Pédro aw si Juan aw pigpa-indeg nilan adti asdangan na manga mag-usayay. Aw pig-usip nilan, “Kanyan ngalan ya dyala mayu na migpaguli' sa utaw na kapig? Ayin lekat ya katulus mayu yan?” ");
INSERT INTO klg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aw si Pédro na nyatmu' na Ispiritu Santo tyumubag kanilan, “Kamu na manga magdadumala͡ay kanami na manga Judiyu, aw manga mangkalangkaw, ");
INSERT INTO klg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kun usipen mayu kami sa du-an na pigkallatan nami ya utaw na kapig aw kun pig-unu ya pagpaguli' kanan, ");
INSERT INTO klg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, yeiy ya tubag nami kamayu aw adti kadég na utaw na Isra-él: Ya eseg ini na nyindeg asini asdangan mayu adun na migkadyaw da ya lawas, pigkaguli-an sakanan magi sa katulus na ngalan ni Jisu-Kristu na taga Nasarit, na yan ya pigkalabu mayu adti krus manang pigmataw sakanan na Tyumanem lekat adti pagkamatay. ");
INSERT INTO klg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jisus saba ya pigkasampetan dun ni pigpasulat na Tyumanem na yan ya batu na sumalem na pigkele͡an na manga panday. Aw kamu saba ya manga panday na kyumele kanan. Manang yan baling ya batu na nya-imo' masalig na tullukanan sa balay. ");
INSERT INTO klg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aw yan olo' ya makapaluwa' kanaten lekat adti pa-emel-emel na Tyumanem, kay wala' ya eped na ngalan na pig-atag adti utaw na makapaluwa' kanaten. Kan Jisus olo' ngalan.” ");
INSERT INTO klg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, kyinita' na manga magdadumala͡ay na wala' ya kakallekan ni Pédro aw ni Juan miglong kanilan, aw to-o silan nya-enneng-enneng, kay kya-ede-an nilan na tagbi' ya pig-iskwila͡an ni Pédro aw ni Juan. Aw dun da nilan ka-ede-i na silan duwa ya gayed mig-iyeped kan Jisus idtu muna. ");
INSERT INTO klg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aw sa pagkita' nilan uman sa eseg na bagu pa pigkaguli-an na dun uman ni tampid nilan, wala' silan pakapaglong sa malat adti pagpaguli' kanan. ");
INSERT INTO klg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yanagaw pigpaluwa' nilan si Pédro aw si Juan, aw migbalawbalaw ya manga mag-usayay dun ni seled, ");
INSERT INTO klg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","law nilan, “Unu ya imo-un naten kanilan? Kya-ede-an da saba asini Jérusalim ya pig-imo' nilan na milagru, yanagaw dili' kitadun makabalyaw. ");
INSERT INTO klg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Manang pagaw mabekkal adti kadég na utaw ya pig-imo' nilan, naten silan paglongan na dili' da silan mag-ubat-ubat dun ni ngalan yan adti pangkay singalan utawa.” ");
INSERT INTO klg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yanagaw pigpatawag nilan si Pédro aw si Juan aw pigpigilan nilan na dili' da magpalna-u sa pangkay sambuk na palna-u ni Jisus adti manga utaw. ");
INSERT INTO klg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Manang tyumubag si Pédro aw si Juan kanilan, law nilan, “Ayin ya madyaw adti anenganeng na Tyumanem, imo-un nami ya kamayu piglong aw kun tumanen nami ya kanan sugu'? ");
INSERT INTO klg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dili' nami mabatug tagenan ya pag-ubat-ubat adti manga utaw sa pigpan-imo' ni Jisus na pigkita' nami idtu muna aw ya kadég na dyengeg nami adti kanan.” ");
INSERT INTO klg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Manang kenne' nilan pigpigilan ya duwa na dili' da silan mag-ubat-ubat. Aw tigkas yan, pigpaluwa' da silan lekat adti kalabusuwanan. Pangkay kaliman nilan pa-emel-emelen ya duwa yeiy manang dili' nilan mabatug asuntu na nyallek silan pagaw mangkadaman ya manga utaw. Kay ya manga utaw, alag silan migdeyen sa Tyumanem asuntu sa nya-imo' dun. ");
INSERT INTO klg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ya eseg na kyaguli-an da, sobla kapatan ya umay nan. ");
INSERT INTO klg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pagkatigkas ni Pédro aw ni Juan paluwa-en, nyadtu silan ni manga eped nilan na mangintu-uway aw pig-ubat nilan ya kadég na piglong na manga mangkatas na magdadugsu-ay aw manga magdadumala͡ay sa manga Judiyu. ");
INSERT INTO klg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aw sa pagdengeg da na manga mangintu-uway sa pig-ubat nilan, migsambuk silan nyanawagtawag, law nilan, “We Tyumanem na migdumala sa kadég: Ikaw ya mig-imo' sa langit aw lupa' aw dagat aw ya kadég na awun ni kanilan. ");
INSERT INTO klg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ikaw ya miglong asini muna adti matikadeng nami na si Dabid na kanmu sugu-anen. Aw magi sa Ispiritu mu, yeiy ya pigsulat nan: ‘Unu ya du-an na to-o nyadaman ya manga utaw na Héntil? Aw ananga' ya manga buwadbuwad ni Isra-él mag-anenganeng sa manga palpa na wala' ya guna? ");
INSERT INTO klg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ya manga hari' asini tas na lupa', migtagilan silan sa tanam, aw ya manga eped na utaw na migdumala, migkatipun silan na un atuwan ya Tyumanem aw ya paghari' na Misiyas na pigpadala nan.’ ");
INSERT INTO klg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aw yan saba ya nya-imo' idtu muna asini syudad. Si Hérodés aw si Ponsyo Pilato aw ya manga Héntil aw ya manga utaw na Isra-él, migsambuk ya kanilan anenganeng na un nilan bantakan ya kanmu Pigpadala na migtuman sa sugu' mu. ");
INSERT INTO klg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Asuntu sa katulus mu, ya pigpalpa mu asini muna yan ya pigpan-imo' nilan. ");
INSERT INTO klg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aw adun da, kay Tyumanem, dyengeg mu ya kanilan pagpigil kanami aw ya palpa nilan na malat adti kadég nami na maglong sa ngalan ni Jisus. Atagi beg na kabagseg na ginawa ya kanmu manga sugu-anen na maglong sa tingeg mu na wala' ya kakallekan. ");
INSERT INTO klg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Aw padelega beg ya pagpaguli' sa manga utaw na awun magkedel, aw pag-imo' pa kaw sa manga pangilala aw manga milagru magi sa ngalan ni Jisus na kanmu sugu-anen.” ");
INSERT INTO klg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatigkas nilan manawagtawag, nya-eyeng ya pigkatipunan nilan, aw nyatmu' ya kadég nilan na Ispiritu Santo aw mig-ubat-ubat silan sa kanan tingeg na wala' ya kakallekan. ");
INSERT INTO klg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na, ya kadég na mangintu-uway dun, migkasambuk ya ginawa nilan aw ya kanilan anenganeng. Aw gayed silan migtatabangay, aw wala' ya utaw na dyumemet sa kanan manga pametang aw ka-unan pangkay sambuk. ");
INSERT INTO klg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aw ya manga apostolés uman, magi sa katulus na Tyumanem, pigmatinaw nilan na nyataw da lekat adti pagkamatay ya kanaten Pangulu na si Jisus. Aw to-o pig-atagan na Tyumanem na grasya ya kadég nilan. ");
INSERT INTO klg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ya syampetan nan, wala' ya sambuk na utaw adti kanilan na migkapelek, kay pigtagisun na manga eped nilan ya paggalin sa kanilan lupa' aw balay, aw dyala nilan ya kuwalta ");
INSERT INTO klg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aw pigbetang nilan adti asdangan na manga apostolés, aw pig-atped-atped adti manga mangintu-uway na migkapelek. ");
INSERT INTO klg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aw maynan ya pig-imo' ni José na taga pulu' na Cipré. Si José yan ya sambuk na lekat adti buwadbuwad ni Libi, aw pigngalanan sakanan na manga apostolés na Bérnabi, kay yan ya kakawasan na Bérnabi: utaw na magpakagān sa ginawa na eped na utaw. ");
INSERT INTO klg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aw awun piggalin nan na lupa', aw pigdala nan ya kuwalta aw pigbetang adti asdangan na manga apostolés. ");
INSERT INTO klg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Manang awun sambuk uman na eseg na si Ananiyas, aw ya ka͡ubayan nan na si Sapira. Awun piggalin nilan na lupa', ");
INSERT INTO klg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","aw migkasambuk ya ginawa nilan na balyaw ya tengteng na alaga' sa piggalin nilan na lupa' aw dili' ubusun atag adti manga apostolés, yanagaw pigtagu' nilan ya eped, aw ya sobla pigbetang ni Ananiyas adti asdangan na manga apostolés. ");
INSERT INTO klg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Manang miglong si Pédro kanan, “Kay Ananiyas, ananga' pig-atmu' ni Satanas ya kanmu anenganeng na piggalu-an mu ya Ispiritu Santo? Kay yan ya piglong mu na yeiy da ya kadakula' na kuwalta adti paggalin mu sa lupa', manang awun baling pigtagu' mu. ");
INSERT INTO klg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Idtu muna ikaw ya tyumagtun sa lupa' mu, aw kun galinen da mu, ikaw ya magbaya' kun unun mu ya kuwalta. Manang mig-ubat kaw sa galu'. Paglongun ta kaw: Beke' saba na utaw ya piggalu-an mu, manang yan ya tengteng piggalu-an mu ya Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pagdengeg ni Ananiyas sa piglong ni Pédro, dayaw sakanan nyatuwad dun ni lupa' aw nyabugtu' ya ginawa nan. Aw dyumateng ya manga eseg, aw pigputus nilan ya lawas nan aw dyala adti un lebengan kanan. Aw ya kadég na dyumengeg sa kyagamakan nan, to-o silan nyallek. ");
INSERT INTO klg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na, manga tulungka-udas pa ya lyumabay, nyaka-ibwang uman ya ka͡ubayan nan. Aw wala' nan ka-ede-i kun unu ya kyagamakan na eseg nan. ");
INSERT INTO klg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aw miglong si Pédro kanan, “Kay Sapira, ubatan kanami. Unu, yeiy da ya kuwalta sa paggalin mayu sa kamayu lupa'?” Aw tyumubag si Sapira, “E-e, yan da.” ");
INSERT INTO klg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pagkatigkas yan, miglong si Pédro, “Ananga' migsambuk ya anenganeng mayu na un tanda-en ya Ispiritu na Tyumanem? Inunuwa! Iyan da ya manga eseg na bagu pa miglebeng sa eseg mu. Aw maynan uman ya kagamakan mu.” ");
INSERT INTO klg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aw tigkan nyatuwad si Sapira dun ni asdangan ni Pédro aw nyabugtu' ya ginawa nan. Aw pagdateng na manga eseg, kyinita' nilan na nyatay da. Aw uman da nilan pigdala adti un lebengan kanan, aw pigbetang nilan dun ni tangkil na eseg nan. ");
INSERT INTO klg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aw to-o pa kyadugangan ya kakallekan na kadég na manga mangintu-uway aw kadég na dyumengeg sa kyagamakan nilan. ");
INSERT INTO klg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, madég ya pangilala aw milagru na pigpan-imo' na manga apostolés magi sa katulus na Tyumanem. Aw gayed migsambuk ya kadég na manga mangintu-uway adti agiyanan na pigngalanan na Portico ni Solomon dun ni pamanag na Témplo. ");
INSERT INTO klg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ya manga utaw na wala' pangintu-u wala' silan paka-eles tambung manang pigbasa͡an nilan ya manga mangintu-uway. ");
INSERT INTO klg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aw madég pa uman ya manga eseg aw ka͡ubayan na bagu nyangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yanagaw pigpandala nilan ya manga pyangkedelan adti ligad na dalan aw pigpakulang dun ni kanilan kamen. Kay yan ya pig-iman nilan na kun lumabay dun si Pédro kalandungan silan na alung nan aw dayaw silan kaguli-an. ");
INSERT INTO klg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Aw dyumulud uman adti manga apostolés ya madég to-o na manga utaw lekat adti manga lunsud na nyakapalibed sa syudad na Jérusalim. Aw dyala nilan uman ya manga pyangkedelan aw ya manga utaw na pyamulayaman na manga busaw. Aw nyabus silan pyangkaguli-an. ");
INSERT INTO klg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na, ya pangulu na manga magdadugsu-ay adti Témplo na Tyumanem aw manga eped nan na nyaka-akup adti sékta na manga Sadusiyo, pagkita' da nilan sa pigpan-imo' na manga apostolés, to-o silan nyinga'. ");
INSERT INTO klg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yanagaw pigpadakep nilan ya manga apostolés aw pigseled adti kalabusuwanan na syudad. ");
INSERT INTO klg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Manang dun ni gabi yan, dyumateng ya sambuk na anghil na Tyumanem aw pig-uwangan nan ya manga tatakep na kalabusuwanan, aw pigpa-agad nan ya manga apostolés adti luwa', aw law nan, ");
INSERT INTO klg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Na, kadtu kamu ni pamanag na Témplo aw dayaw mayu palna-uwi ya manga utaw sa pig-atag na Tyumanem na yan ya bagu na ginawa.” ");
INSERT INTO klg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pagdengeg nilan sa piglong na anghil, lyumiku' silan adti pamanag na Témplo na maselem da, aw migpalekat silan migpalna-u sa manga utaw dun. Na, sa pagkatipun da na pangulu na manga magdadugsu-ay aw manga eped nan, pigpatawag nilan ya kadég na manga mag-usayay na manga Judiyu. Aw pigsugu' nilan ya manga magtatunggu-ay na angayen ya manga apostolés adti kalabusuwanan. ");
INSERT INTO klg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Manang sa pagdateng nilan adti kalabusuwanan, wala' da dun ya manga apostolés. Yanagaw lyumiku' silan aw pig-ubatan nilan ya kadég, law nilan, ");
INSERT INTO klg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kyinita' nami na dayaw pigbalagsangan ya manga tatakep na kalabusuwanan aw kenne' pa na manga magtatunggu-ay dun ni luwa', manang pag-uwang nami, wala' ya utaw dun ni seled!” ");
INSERT INTO klg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na, sa pagdengeg na kapitan na manga magtatunggu-ay sa Témplo aw manga mangkatas na magdadugsu-ay sa pig-ubat nilan, nyabelengbeleng silan kay wala' nilan kalabeti kun unu ya un sampetan na kadég yeiy. ");
INSERT INTO klg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pagkatigkas yan, awun utaw na dyumateng aw miglong kanilan, “Tanawa! Ya manga eseg na pigpakalabusu mayu, awun saba silan ni pamanag na Témplo! Migpalna-u la uman silan!” ");
INSERT INTO klg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yanagaw nyagad ya kapitan sa manga magtatunggu-ay aw pig-angay nilan ya manga apostolés, manang wala' nilan gelgela pa-agadan kay nyallek silan pagaw pamintuwun silan na manga utaw. ");
INSERT INTO klg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pagdateng da nilan adti asdangan na manga mag-usayay, piglongan na pangulu na manga magdadugsu-ay ya manga apostolés, ");
INSERT INTO klg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","law nan, “Pigpigil da nami kamayu na dili' kamu magpalna-u dun ni ngalan yan, manang inunuwa ya pig-imo' mayu! To-o la baling dyengeg adti kadakula' na Jérusalim ya pigpalna-u mayu! Aw kami pa ya pigdapel mayu na migpatay sa utaw yan!” ");
INSERT INTO klg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Manang tyumubag kanilan si Pédro aw ya eped na manga apostolés, law nilan, “Ya Tyumanem, yan ya ka-ilangan nami ka͡agadan, aw beke' na utaw. ");
INSERT INTO klg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kay ya Tyumanem na pyangintu-uwan na tyugbulan tadun, yan ya migmataw kan Jisus na pigpapatay mayu magi sa pagkalabu adti krus. ");
INSERT INTO klg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aw pigpatas nan si Jisus aw pigpa-ingkud apit adti kanan kalintu na un magdumala sa kadég. Aw magi sa maynan na pa-agi, pig-imo' nan sakanan Magpaluwa-ay sa kadég na utaw na Isra-él pada magselsel galu silan aw ayawan nilan ya kanilan manga imo-unun na malatay aw lanasen ya manga sala' nilan. ");
INSERT INTO klg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aw pigmatinaw nami ya kadég yeiy na nyangka-imo', aw pigmatinaw uman na Ispiritu na pig-atag da na Tyumanem adti kadég na utaw na dyumalug sa manga sugu' nan.” ");
INSERT INTO klg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagdengeg nilan sa tubag na manga apostolés, to-o silan nyadaman aw pigbetang nilan adti kanilan ginawa na patayen ya manga apostolés. ");
INSERT INTO klg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Manang nyindeg dun ya sambuk kanilan na si Gamalyél. Na, Parisiyo sakanan aw magpalna-uway sa Uldin na manga Judiyu, aw pigsaya' na kadég na manga utaw. Aw pigpaluwa' nan ya manga apostolés dagawdagaw lekat adti usayanan. ");
INSERT INTO klg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aw miglong si Gamalyél adti manga eped nan na mag-usayay, “Kay manga inulug na buwadbuwad ni Isra-él, dili' tadun gallaten ya un tadun imo-un sa manga utaw yeiy. ");
INSERT INTO klg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kya-anenganengan mayu na idtu muna awun sambuk na eseg na si Tyudas na migpatastas aw mig-imo' sa kasakupan nan na manga upatenggatus ya manga eseg. Manang pigpatay sakanan, aw ya kadég na eped nan nyabus migbeklag aw wala' da ya nyabatug nilan. ");
INSERT INTO klg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatigkas yan, dun ni manga allaw na pagsinsus, si Judas na taga Galiliya, mig-imo' uman sa kasakupan nan. Manang pigpatay sakanan uman, aw migbeklag ya manga eped nan. ");
INSERT INTO klg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yanagaw, paglongun ta kamu: Pabaya-i la mayu ya manga utaw yeiy! Paluwa-a la mayu silan. Kay kun ya pagpalna-u nilan lyumekat adti utaw olo', aw kun ya palpa nilan lyumekat adti kanilan anenganeng, dili' saba yan magpadeleg. ");
INSERT INTO klg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Manang kun lyumekat adti Tyumanem, na, dili' mayu silan katagenan, pagaw ka-atuwan mayu baling ya pagkaliman na Tyumanem!” Yanagaw tyumande' ya kadég na mag-usayay kan Gamalyél. ");
INSERT INTO klg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Aw pigpatawag nilan ya manga apostolés adti seled na usayanan, aw byadasan nilan pigpalabet. Tigkas yan, pigpigilan nilan na dili' da salutun ya pagpalna-u dun ni ngalan ni Jisus, aw pigpaluwa' da nilan. ");
INSERT INTO klg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pag-indeg da na manga apostolés, to-o silan migleya kay adti anenganeng na Tyumanem, umba' silan pati-isen sa pagmulamula kanilan asuntu kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aw kada allaw migpalna-u silan adti pamanag na Témplo aw adti manga balay na mangintu-uway. Aw wala' silan teneng sa pagpa-ede' sa Madyaw na Ubat-ubat na si Jisus yan ya Misiyas. ");
INSERT INTO klg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dun ni manga allaw yan, gayed kyadugangan ya manga utaw na nyangintu-u kan Jisus. Na, ya manga mangintu-uway na Judiyu na miglong sa tingeg na Grigo, migdiklamu silan adti eped nilan na Judiyu na miglong sa tingeg na Hibriyu. Migdiklamu silan kay kyalabayan baling ya kanilan manga balu dun ni pagpan-atag sa tabang kada allaw adti manga ka͡ubayan na nyabalu. ");
INSERT INTO klg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yanagaw pagdengeg na sampulu' tag duwa ya apostolés sa diklamu nilan, pigtipun nilan ya kadég na mangintu-uway. Aw miglong ya manga apostolés, law nilan, “Dili' madyaw kun kami ya man-atag sa tabang pagaw masalang ya pag-ubat-ubat nami sa tingeg na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yanagaw, kay manga inulug, pamalli' kamu adti eped mayu sa pitu ya eseg na un tadun taliguwan sa manga imo-unun yeiy. Yan ya pamalli-en mayu ya madyaw ya dengeg adti eped na utaw aw nyatmu' na Ispiritu Santo aw nyatmu' uman na katadeng sa unu ya madyaw imo-un. ");
INSERT INTO klg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Manang ya kanami, un nami tibullukun ya kanami anenganeng adti pagpanawagtawag sa Tyumanem aw pag-ubat-ubat sa kanan tingeg.” ");
INSERT INTO klg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pagdengeg na manga mangintu-uway sa palpa na manga apostolés, kyatutukan ya kadég nilan. Yanagaw pigpamalli' nilan si Éstéban na to-o masalig ya pagpangintu-u aw nyatmu' na Ispiritu Santo, aw si Pilipi, aw si Prokoro, aw si Nicanor, aw si Timon, aw si Parménas, aw si Nikolas. Na, si Nikolas taga syudad na Antiyokya aw beke' sakanan na Judiyu manang nyagagad asini muna adti katanem na manga Judiyu aw Uldin nilan. ");
INSERT INTO klg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ya pitu na pigpamalli' da, pigpa-indeg silan adti asdangan na manga apostolés. Aw pigpandungan na manga apostolés na kanilan palad ya pitu yeiy aw pyanawagtawagan nilan adti Tyumanem na tabangan nan silan sa kanilan manga imo-unun. ");
INSERT INTO klg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aw gayed nyabekkal ya tingeg na Tyumanem. Aw to-o kyadugangan ya manga nyangintu-u kan Jisus dun ni Jérusalim. Aw madég uman ya manga magdadugsu-ay adti Témplo na nyagagad aw nyangintu-u la. ");
INSERT INTO klg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aw si Éstéban, pigpakadyaw na Tyumanem aw pig-atagan nan na katulus aw yanagaw mig-imo' sakanan sa madég na pangilala aw milagru dun ni manga utaw. ");
INSERT INTO klg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Manang awun manga utaw na gayed nyanubbuk kanan sa ayil. Judiyu silan aw sakup na “Sinagoga na manga Libértino,” aw ya eped nilan manga utaw na taga Ciréné aw Aléksandriya, aw manga taga probinsya na Ciliciya aw Asia. Aw migpalekat silan mig-ayil kan Éstéban. ");
INSERT INTO klg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Manang tyumabang kanan ya Ispiritu Santo kun unu ya madyaw nan tubag kanilan, aw wala' silan paka-atu kanan. ");
INSERT INTO klg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yanagaw tyumandan silan sa manga eseg na tagu-tagu' na un magmatinaw sa galu' adti kan Éstéban. Aw pyamene-an nilan sa un nilan paglongun dun ni matas na usayanan: “Dyengeg nami ya paglong nan sa malatay adti kan Moysis aw adti Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yanagaw pigsutsutan nilan ya manga utaw aw ya magdadumala͡ay sa manga Judiyu aw ya manga magpalna-uway sa Uldin, aw alag silan nyadtu ni kan Éstéban aw pigdakep nilan aw pigdala adti asdangan na manga mag-usayay. ");
INSERT INTO klg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aw ya manga utaw na dyumawat sa kuwalta na tagu-tagu', silan ya migmatinaw sa galu', law nilan, “Ya utaw ini, gayed nan pigkasampetan na malatay ya Témplo na Tyumanem aw ya Uldin tadun. ");
INSERT INTO klg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kay dyengeg nami ya piglong nan na si Jisus na taga Nasarit, un nan kunu kalaten ya kadakula' na Témplo ini aw un nan sayuwan ya manga katanem na pig-atag ni Moysis adti manga tyugbulan tadun asini muna.” ");
INSERT INTO klg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aw ya kadég na manga mag-usayay, sa pag-inunu nilan, nya-uman ya gya ni Éstéban, iman mu aw gya na anghil. ");
INSERT INTO klg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pagkatigkas yan, nyusip kan Éstéban ya pangulu na manga magdadugsu-ay, “Unu, matinaw ya piglong nilan kanmu?” ");
INSERT INTO klg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aw tyumubag si Éstéban, “Kay manga kadégan ku na Judiyu aw manga kapatas nami, pakanyegi mayu ya un ku paglongun: Ya Tyumanem na umba' deyen, migpakita' adti kanaten tyugbulan na si Abraham talana pa sakanan nyeya' adti banwa na Mésopotamiya sa wala' pa pag-alin adti lunsud na Haran. ");
INSERT INTO klg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Miglong ya Tyumanem kanan, ‘Indeg da kaw lekat asini banwa na kya͡utawan mu, aw ayawi ya kanmu manga kadégan, aw pag-alin kaw adti sambuk na banwa na un ku pakita' kanmu.’ ");
INSERT INTO klg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yanagaw pig-indegan nan ya banwa na manga utaw na Kaldiyanen aw mig-alin sakanan adti Haran. Aw pagkatigkas na pagkamatay na ama nan, pigpakadi na Tyumanem si Abraham asini banwa na pig-eya-an tadun. ");
INSERT INTO klg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Idtu na pagdateng nan, wala' pa na Tyumanem atagi na lupa' pangkay min na palad. Manang pigpakangan nan si Abraham na atag nan ya lupa' ini adti kanan aw manga buwadbuwad nan, pangkay wala' pa ya ise' nan. ");
INSERT INTO klg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aw migpa-ede' ya Tyumanem na ya kanan manga buwadbuwad un ma-imo' dumadayu adti sambuk na banwa, aw un silan allangen aw pamulayaman seled na upatenggatus ya umay. ");
INSERT INTO klg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Manang miglong pa uman ya Tyumanem kan Abraham, ‘Un ku ukuman ya nasud na mag-allang kanilan. Aw pagkatigkas yan, paluwa-en ku ya buwadbuwad mu lekat adti nasud yan pada liku-an nilan ya lupa' ini aw asini la aku nilan simba͡a.’ ");
INSERT INTO klg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Aw pigsugu' na Tyumanem si Abraham na pantuli-en ya manga eseg kay yan ya pangilala sa pakang nan kanilan na dayaw mig-iganget. Aw nya͡utaw ya ise' nan na eseg na si Isa-ak, aw paglabay da na walungallaw, pigtuli' ni Abraham ya ise' nan. Aw si Isa-ak, nya-imo' ama ni Jakub, aw si Jakub nya-imo' ama na sampulu' tag duwa ya ise' nan na eseg na silan ya nya-imo' tyugbulan tadun. ");
INSERT INTO klg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aw ya manga tyugbulan tadun, nyinga' silan sa mangud nilan na si José. Yanagaw piggalin nilan aw pigdala na manga utaw adti nasud na Ihiptu aw nya-imo' sakanan allang. Manang gayed sakanan pig-agad-agadan na Tyumanem ");
INSERT INTO klg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aw pigpaluwa' nan lekat adti kadakula' na pamulayam. Aw pig-atagan nan na katadeng kun unu ya madyaw imo-un dun ni allaw na pigpatawag sakanan adti asdangan na para-un na yan ya hari' sa Ihiptu. Aw to-o migleya ya para-un kanan, yanagaw pig-imo' nan si José magdumala sa kadakula' na nasud na Ihiptu dala ya ka-epedanan na para-un. ");
INSERT INTO klg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na, dyumateng ya dakula' na getem adti banwa na Ihiptu aw adti banwa na Canaan. Aw migkapelek ya manga utaw dala uman ya tyugbulan tadun dun ni Canaan. To-o silan migti-is kay wala' ya kyinita' nilan na kakamangan sa pagkan nilan. ");
INSERT INTO klg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Manang pagdengeg ni Jakub na awun trigu adti Ihiptu, pigpakadtu nan dun ya manga ise' nan na eseg na nya-imo' tyugbulan tadun. Yan ya tagna' na pagkadtu nilan. ");
INSERT INTO klg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Adti kadwa na pagkadtu nilan, migpakilala si José adti manga mangkagulang nan, aw pigpa-ede' nan adti para-un ya pamilya nan. ");
INSERT INTO klg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Aw pagkatigkas yan, pigpatawag ni José ya ama nan na si Jakub aw ya kanan kadégan na pa-alinen adti Ihiptu. Aw ya kadég nilan kapituwan tag lima. ");
INSERT INTO klg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yanagaw nyanaw san Jakub adti Ihiptu aw dun da silan pag-eya'. Aw yan ya banwa na kyamatayan ni Jakub aw ya kadég na manga ise' nan na nya-imo' tyugbulan tadun. ");
INSERT INTO klg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Paglabay da na madég na umay, ya manga pesa' nilan pigdala adti banwa na Canaan aw piglebeng adti Shékim, dun ni ilib na pigbayadan ni Abraham na bulawan na maputi' asini muna lekat adti buwadbuwad ni Hamor dun ni Shékim. ");
INSERT INTO klg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na, sa malapit da ya allaw na tumanen na Tyumanem ya pigpakang nan kan Abraham asini muna, migkadég pa to-o ya manga buwadbuwad nan adti banwa na Ihiptu ");
INSERT INTO klg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","menda' na nyingkud da ya sambuk na hari' na wala' nan ka-ede-i ya tabang ni José dun ni Ihiptu asini muna. ");
INSERT INTO klg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yanagaw gayed sakanan mig-imo' sa manga malat na kapandayan na un magpakalug sa manga tyugbulan tadun. Aw pigleges nan silan na ayawan ya mangayse' nilan na bagu nya͡utaw adti luwa' pada dili' da mataw. ");
INSERT INTO klg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dun ni manga umay yan, nya͡utaw si Moysis aw to-o sakanan matinaw na pagka-ise'. Seled na tulumbulan pigkalmukan sakanan na ina nan na tagu-tagu' dun ni kanilan balay. ");
INSERT INTO klg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pagdateng na allaw na dili' da nilan mabatug tagu-un ya ise', pig-ayawan sakanan adti luwa', aw wala' kadugay pigkamang sakanan na biya' na yan ya ise' na para-un, aw pig-ipat nan kasiling na kanan tengteng ise'. ");
INSERT INTO klg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yanagaw si Moysis pigpalna-uwan na manga Ihiptuwanen sa kadakula' na kanilan katanem aw katadeng. Aw madyaw ya dengeg nan asuntu sa katadeng nan maglong aw sa pigpan-imo' nan. ");
INSERT INTO klg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pagdateng ni Moysis adti kapatan ya umay nan, nyakabetang adti anenganeng nan na lumaba' adti manga kadégan nan na buwadbuwad ni Isra-él dun ni Ihiptu. ");
INSERT INTO klg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aw kyinita' nan dun ya sambuk na kadégan nan na pyamulayaman na utaw na Ihiptuwanen. Aw pigtabangan ni Moysis ya kadégan nan aw pigpatay nan ya Ihiptuwanen. ");
INSERT INTO klg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Na, iman ni Moysis aw kalabetan na manga kadégan nan na Isra-él ya tud nan adti kanilan, na pigpamalli' sakanan na Tyumanem na un magpaluwa' kanilan lekat adti pagpamulayam na manga Ihiptuwanen. Manang wala' nilan kalabeti. ");
INSERT INTO klg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagkasalut da na allaw, lyumiku' si Moysis adti kadégan nan na Isra-él aw kyinita' nan ya duwa na migtanam. Aw kaliman nan galu usayen ya pagtanam nilan, law nan, ‘Kay Lew, ananga' kamu magtanam? Alag kamu saba mangkaylug!’ ");
INSERT INTO klg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Manang ya eseg na nyanubbuk sa tanam, pigtulud nan si Moysis aw piglongan nan, ‘Singalan ya mig-imo' kanmu kapatas nami na un magbaya-baya' kanami? ");
INSERT INTO klg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Unu ka', silingen aku mu na Ihiptuwanen na pigpatay mu kagabi?’ ");
INSERT INTO klg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagdengeg ni Moysis sa piglong nan, nyaksay sakanan nyanaw lekat adti Ihiptu aw nyalaguy pasinan adti banwa na Midyan. Aw dun da sakanan pangugnan, aw dun da uman ka͡utaw ya duwa ya ise' nan na eseg. ");
INSERT INTO klg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Paglabay da na kapatan ya umay, awun anghil na migpakita' kanan adti kaligbinan dun ni buntud na Sinay. Migpakita' kanan dun ni tagbi' na kawuy na lyumaga. ");
INSERT INTO klg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Aw pagkita' ni Moysis, to-o sakanan nyabelengbeleng. Aw sa pagpalapit nan adti kawuy, awun dyengeg nan na tingeg na lekat adti Tyumanem, ");
INSERT INTO klg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aku saba ya Tyumanem na manga tyugbulan mayu na si Abraham aw si Isa-ak aw si Jakub.’ Pagdengeg ni Moysis sa tingeg nan, to-o sakanan migteneb aw tyakigan aw wala' nan ka-inunu. ");
INSERT INTO klg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Aw miglong ya Tyumanem kanan, ‘Luwasa ya sandal mu, kay āsini aku ni banwa ini na pig-indegan mu. ");
INSERT INTO klg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kyinita' ku saba ya pagpakalat sa manga utaw ku adti nasud na Ihiptu, aw dyengeg ku uman ya pag-agele nilan. Aw nyanog aku lekat adti tas na langit kay un ku silan bawi-en lekat adti pagpamulayam na manga Ihiptuwanen. Yanagaw un ta kaw padala adti Ihiptu.’ ");
INSERT INTO klg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Si Moysis yeiy, pigkele͡an na manga tyugbulan tadun asini muna aw miglong silan, ‘Singalan ya mig-imo' kanmu kapatas nami na un magbaya-baya' kanami?’ Manang yeiy baling ya utaw na pigsugu' na Tyumanem aw pig-imo' nan kanilan kapatas, aw yeiy ya migpaluwa' kanilan lekat adti manga Ihiptuwanen magi sa anghil na Tyumanem na migpakita' kanan dun ni tagbi' na kawuy na lyumaga. ");
INSERT INTO klg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aw si Moysis ya miggagad sa manga tyugbulan tadun lekat adti banwa na Ihiptu, manang sa wala' pa silan indeg, madég ya pangilala aw milagru na pigpakita' nan dun ni banwa yan aw adti Dagat na Mapula, aw adtu uman ni kaligbinan na alag laganasen seled na kapatan ya umay. ");
INSERT INTO klg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aw si Moysis saba ya miglong adti manga buwadbuwad ni Isra-él, law nan, ‘Un pa magpadala ya Tyumanem adti kamayu sa sambuk na propita kasiling kanak na lumekat adti buwadbuwad ni Isra-él.’ ");
INSERT INTO klg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aw si Moysis uman ya dyumala sa tingeg na anghil na miglong kanan dun ni tas na buntud na Sinay na awun ni kaligbinan, aw pigpa-ede' nan uman adti manga tyugbulan tadun. Aw pigdawat nan ya pigsulat na Tyumanem na yan ya Uldin na pig-ayawan sa kadég tadun aw yan ya nyatag kanaten sa ginawa. ");
INSERT INTO klg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Manang ya tyugbulan tadun, wala' silan kalim dalug kan Moysis, aw yan ya gayed nilan pig-anenganeng ya pag-eya' nilan adti Ihiptu. ");
INSERT INTO klg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yanagaw miglong silan kan Aaron, ‘Imo-i kami sa manga inutaw na yan da ya tyumanem na un maggagad kanami, kay wala' da nami ka-ede-i kun ayin da adun ya utaw yan na si Moysis na miggagad kanami lekat adti Ihiptu.’ ");
INSERT INTO klg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aw mig-imo' silan sa inutaw kasiling na nati na baka, aw pigdugsu-an nilan ya inutaw yan aw pig-imo-an nilan sa pista kay kyatutukan silan sa pig-imo' na kanilan manga tullu'. ");
INSERT INTO klg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yanagaw pigpabaya-an da silan na Tyumanem na magsimba sa sega aw bulan aw manga bitun. Aw ya kanilan bet pigsulat adti libru na manga propita: ‘Kamu na buwadbuwad ni Isra-él, seled na kapatan ya umay miglegeblegeb kamu adti kaligbinan, aw migpatay kamu sa madég na manga ayep aw pigdugsu' mayu ya manga lawas nilan, manang beke' ku baling ya pigdugsu-an mayu. ");
INSERT INTO klg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aw yan saba ya gayed mayu pigsidala ya layaglayag na inabelan na yan ya pag-eya-an na sambuk na inutaw mayu na si Molok. Aw pigdala mayu uman ya inutaw na bitun na pigngalanan mayu na Répan. Aw yeiy ya pig-imo' mayu manga tyumanem na un mayu simba͡en. Yanagaw un ta kamu alilinan apit adti tadtu na banwa na Babiloniya.’ ");
INSERT INTO klg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na, ya tyugbulan tadun asini muna, mig-imo' silan uman sa palangad pag-eya-an na tengteng Tyumanem dun ni kaligbinan. Aw dun ni pag-imo' nilan, dayaw nilan dyalug ya pigpakita' na Tyumanem kan Moysis kun unu ya gya na pag-eya-an nan. ");
INSERT INTO klg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aw pig-ayawan nilan adti kanilan manga buwadbuwad aw pigsidala uman nilan menda' sa paggagad ni Joswé kanilan asini banwa ini. Aw dun ni manga allaw yan, pig-alilinan na Tyumanem ya manga muna utaw aw nyatagtun na manga tyugbulan tadun ya lupa' yeiy, aw asini la ni banwa tadun ya palangad pag-eya-an na Tyumanem taman na manga allaw na paghari' ni Dabid. ");
INSERT INTO klg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Aw kyatutukan ya Tyumanem kan Dabid, aw migsekat si Dabid na tumbay kanan ya pagtulluk sa dakula' na eya-anan na Tyumanem asini tas na lupa' na un pagsimba͡an na manga buwadbuwad ni Jakub sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Manang si Solomon baling ya pigtumbay na Tyumanem na un magtulluk sa balay nan. ");
INSERT INTO klg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Manang ya Tyumanem na To-o Matas, dili' mabatug na meya' sakanan adti balay na pig-imo' na utaw, kasiling na pigsulat na propita asini muna, law na Tyumanem, ");
INSERT INTO klg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ya adti tas na langit, yan ya trunu sa paghari' ku, aw ya lupa', yan ya gina-anan ku. Unu pa balaya ya un mayu imo-un kanak? Aw ayin aku na banwa paglagdeng? ");
INSERT INTO klg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Unu ka', beke' ku ya mig-imo' sa kadég yeiy?’ ” ");
INSERT INTO klg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Aw miglong pa si Éstéban dun ni matas na usayanan, “Mangkategel kamu! Kasiling kamu na manga Héntil na wala' ya kalim magpakanyeg sa tingeg na Tyumanem! Gayed kamu nyatu sa Ispiritu nan kasiling uman na tyugbulan mayu asini muna. ");
INSERT INTO klg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyabus pyamulayaman na kamayu tyugbulan ya manga propita! Aw pigpatay nilan ya manga mig-ubat-ubat dadan sa pagkadi na sambuk na wala' ya sala' na yan si Jisus! Aw sa pagdateng nan, pigtumbay mayu baling adti kanan manga po-on aw kamu saba ya migpapatay kanan! ");
INSERT INTO klg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aw pangkay kamu ya nyakatagtun sa Uldin na pig-atag na Tyumanem magi sa manga anghil asini muna, manang wala' mayu pagbetangan sa ginawa ya pagdalug sa Uldin.” ");
INSERT INTO klg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagdengeg na manga mag-usayay sa kadakula' na piglong ni Éstéban, to-o silan nyadaman aw nyampanguliteb ya kanilan untu sa kabulut nilan. ");
INSERT INTO klg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Manang si Éstéban nyatmu' na Ispiritu Santo, aw lyumangad sakanan adti langit aw kyinita' nan ya kalalamdag na Tyumanem na to-o syumiga aw si Jisus na nyindeg apit adti kalintu nan. ");
INSERT INTO klg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aw miglong sakanan, “Inunuwa! Nyabeka' da ya langit. Kyinita' da ku ya Ise' na Utaw na nyindeg apit adti kalintu na Tyumanem!” ");
INSERT INTO klg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Manang pigsengseng na manga mag-usayay ya manga talinga nilan aw migpangkawayit silan, kay dili' silan malim magpakanyeg sa piglong nan. Tigkas yan, pigdulus nilan si Éstéban, ");
INSERT INTO klg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aw pigdala nilan adti luwa' na syudad aw pigbadasan nilan na babintu. Aw ya manga utaw na migmatinaw sa galu' adti kan Éstéban, talana nilan pyamintu sakanan, pigtaligu nilan ya kanilan manga sa-ul adti sambuk na eseg na bagu pa ya ginawa na pigngalanan na si Saulo. ");
INSERT INTO klg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Talana pa nilan si Éstéban pyamintu, nyanawagtawag sakanan adti Tyumanem, law nan, “We.... Jisus na kanak Pangulu, dawata beg ya ispiritu ku!” ");
INSERT INTO klg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pagkatigkas yan, lyumuhud si Éstéban adti lupa' aw mig-ulangag, law nan, “Kay Pangulu, dili' mu silan pagpa-emel-emelen asuntu sa pig-imo' nilan.” Aw pagkatigkas nan maglong, nyabugtu' ya ginawa nan. ");
INSERT INTO klg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Aw kyabantayan ni Saulo ya kadég na nya-imo' aw tyumande' sa manga utaw na migpatay kan Éstéban. Manang awun manga eseg dun na masalig to-o ya pagpangintu-u aw dayaw nilan piglebeng ya lawas ni Éstéban. Aw to-o silan migmatay aw migsugaw. Aw lekat dun ni allaw yan, migpalekat ya dakula' na pagpamulayam sa manga mangintu-uway kan Jisus dun ni Jérusalim. Aw ya syampetan nan, madég ya mangintu-uway na migbeklag nyamalaguy adti kadakula' na probinsya na Judiya aw adti banwa na Samariya. Yan dakman olo' ya nyasama' dun ni Jérusalim ya manga apostolés. ");
INSERT INTO klg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aw si Saulo migpadeleg nyamulayam sa manga mangintu-uway aw kaliman nan apnasen ya kadég nilan. Pigpanseled nan ya manga balay nilan aw pyandakep nan ya manga eseg aw ka͡ubayan aw pigpakalabusu nan silan. ");
INSERT INTO klg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, ya manga mangintu-uway na nyamalaguy lekat adti Jérusalim, piglegeb nilan ya manga banwa na dyatengan nilan, aw gayed nilan pigpa-ede' adti manga utaw ya Madyaw na Ubat-ubat kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ya sambuk kanilan na si Pilipi, nyadtu sakanan adti sambuk na lunsud na sakup na Samariya, aw pig-ubat-ubatan nan silan na si Jisus yan ya Kristu na pigpadala na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pagdengeg da na madég na utaw sa pig-ubat-ubat nan, aw pagkita' nilan sa manga milagru na pig-imo' nan magi sa katulus na Tyumanem, dayaw nilan pigpakanyegan ya piglong nan. ");
INSERT INTO klg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kay madég ya manga busaw na lyumuwa' da adti manga utaw na to-o mig-ulangag. Aw madég ya manga pulid aw kapig kyaguli-an da silan. ");
INSERT INTO klg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yanagaw to-o migleya ya manga utaw adti lunsud yan. ");
INSERT INTO klg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na, dun ni lunsud yan, awun anituwan na pigngalanan na Simon. Aw madugay da nya-enneng-enneng ya manga utaw dun ni kadakula' na Samariya sa nyangka-imo' na katulus nan, yanagaw migpalibantug sakanan. ");
INSERT INTO klg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aw idtu muna, alag migpakanyeg kanan ya manga utaw, dala ya tagitu' aw ya manga dakula' na utaw. Aw gayed silan miglong, “Ya utaw yeiy, awun ni kanan ya katulus na Tyumanem na pigtawag na ‘To-o Matulus.’ ” ");
INSERT INTO klg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Aw asuntu na madugay da silan nya-enneng-enneng sa manga nya-imo' nan, gayed nilan sakanan pigpakanyegan. ");
INSERT INTO klg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Manang pagdateng ni Pilipi adti Samariya, pigpa-ede' nan ya Madyaw na Ubat-ubat sa Kasakupan na Pighari-an na Tyumanem aw ya ngalan ni Jisu-Kristu. Aw madég kanilan ya nyangintu-u sa pig-ubat-ubat nan. Aw pigba͡utismuwan ya madég na manga eseg aw manga ka͡ubayan. ");
INSERT INTO klg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pangkay si Simon nyangintu-u uman. Aw pagkatigkas sakanan ba͡utismuwan, nyagad da sakanan kan Pilipi aw kyinita' nan ya manga pangilala aw milagru, aw to-o si Simon nya-enneng-enneng. ");
INSERT INTO klg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na, ya manga apostolés na awun ni Jérusalim, dyengeg nilan na dyawat na madég na utaw adti banwa na Samariya ya tingeg na Tyumanem. Yanagaw pigpakadtu nilan si Pédro aw si Juan. ");
INSERT INTO klg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagdateng da nilan dun, pyanawagtawagan nilan adti Tyumanem ya manga utaw na bagu nyangintu-u na madawat nilan ya Ispiritu nan, ");
INSERT INTO klg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kay wala' pa dateng adti kanilan ya Ispiritu pangkay pigba͡utismuwan silan dun ni ngalan ni Jisus na Pangulu. ");
INSERT INTO klg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pagkatigkas yan, pigpandungan ni Pédro aw ni Juan na kanilan manga palad ya manga bagu pa nyangintu-u, aw nyadawat nilan ya Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aw kyinita' ni Simon na dun ni pagpandong na manga apostolés sa palad nilan adti manga utaw, nyadawat nilan ya Ispiritu Santo. Yanagaw pig-atagan nan galu na kuwalta ya manga apostolés, ");
INSERT INTO klg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","aw law nan, “Atagi aku na katulus yeiy pada ya pangkay singalan na pandungan ku na kanak palad makadawat uman sa Ispiritu Santo.” ");
INSERT INTO klg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Manang miglong si Pédro kanan, “Maka-eped kanmu ya kuwalta mu masangab adti atulun na dili' pagkapatayan! Asuntu na mig-aneng-aneng kaw na mabatug mu bayadan ya katulus na Ispiritu Santo. ");
INSERT INTO klg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wala' ya labet mu sa imo-unun na pigtaligu na Tyumanem kanami, kay kya-ede-an nan na kenne' pa na kalatay na anenganeng mu. ");
INSERT INTO klg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Yanagaw pagselsel kaw sa malat na pigpalpa mu. Aw panawagtawag kaw adti Tyumanem pagaw kallatan kaw nan aw dili' da kaw pa-emel-emelen asuntu sa anenganeng mu na malatay. ");
INSERT INTO klg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kay kyinita' ku na to-o kaw nyinga' kanami aw kyaliputan kaw dun ni imo-unun na malatay.” ");
INSERT INTO klg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Aw tyumubag si Simon kanilan, “Panginayu' kamu beg kanake' adti Tyumanem na dili' dumateng adi kanak ya pangkay sambuk na piglong mayu.” ");
INSERT INTO klg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aw migpadeleg si Pédro aw si Juan migpa-ede' sa Madyaw na Ubat-ubat kan Kristu. Pagkatigkas yan, syuminan silan adti Jérusalim. Aw dun ni panaw nilan, nyapit silan adti madég na baranggay aw pigpa-ede' nilan adti manga taga Samariya ya Madyaw na Ubat-ubat kan Kristu na lekat adti tingeg na Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Manang si Pilipi, pigsugu' sakanan na anghil na Tyumanem na miglong, “Kadtu kaw adti dalan na lekat adti Jérusalim pasinan adti Gasa.” Na, dun ni kaligbinan paka-agi ya dalan yeiy. ");
INSERT INTO klg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yanagaw nyindeg si Pilipi aw nyanaw dun ni dalan yan, aw kyinita' nan adti mawatawat ya sambuk na eseg na taga Étiyopya. Na, ya utaw yeiy, pigsaligan ni Candasi na rayna sa nasud na Étiyopya, aw pigtaliguwan sakanan sa kadakula' na ka-unan aw kuwalta na rayna. Lyumekat sakanan adti Jérusalim kay migsimba sa Tyumanem ");
INSERT INTO klg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aw nyuli' da. Nyingkud dun ni kalisa nan aw migbasa sa libru na pigsulat na propita na si Isayas. ");
INSERT INTO klg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Aw miglong ya Ispiritu Santo adti kan Pilipi, “Daluga aw dengan kaw sa kalisa nan!” ");
INSERT INTO klg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yanagaw dyumalagan si Pilipi pasinan adti kalisa, aw dyengeg nan ya pagbasa na utaw yan na lekat adti pigsulat ni Isayas. Aw nyusip si Pilipi kanan, “Unu, kay Lew, kyalabetan mu ya kakawasan na pigbasa mu?” ");
INSERT INTO klg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Aw tyumubag sakanan, “Wala' ku kalabeti. Unun ku ya pagpakalabet kun wala' ya utaw na magpalabet kanak?” Aw piglongan nan si Pilipi na tumangkil kanan sumakay adti kalisa. ");
INSERT INTO klg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na, ini ya pigbasa nan: “Kasiling sakanan na karniro na pigdala adti iyawanan, aw kasiling uman na ise' na karniro na un da gupitan, wala' ya tingeg na piglong nan. ");
INSERT INTO klg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pigmulamula sakanan na manga utaw, aw dili' matinaw ya pag-ukum nilan kanan. Singalan ka' ya un magtultul sa manga buwadbuwad nan adti moli na allaw? Kay ya ginawa nan pigkamang da asini tas na lupa'.” ");
INSERT INTO klg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aw miglong ya pigsaligan kan Pilipi, “Ubatan kanak. Singalan utawa ya pigsulat na propita na si Isayas? Ya kanan pagka-utawun aw kun eped na utaw?” ");
INSERT INTO klg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aw pigpalekat ni Pilipi ya pag-ubat-ubat kanan, lekat adti pigsulat ni Isayas menda' adti Madyaw na Ubat-ubat kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aw sa talana silan syumakay adti kalisa, dyumateng silan adti tubig, aw miglong ya pigsaligan, “Tengtengi! Awun tubig iyan! Ananga' dili' aku mu ba͡utismuwan adun?” ");
INSERT INTO klg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aw tyumubag si Pilipi kanan, “E-e. Mabatug kaw saba ba͡utismuwan kun mangintu-u kaw kan Jisus sa kadakula' na ginawa mu.” Aw law na pigsaligan, “Nyangintu-u la aku na si Jisu-Kristu, yan ya Ise' na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aw pigsugu' nan ya dyumala sa kalisa na tumeneng. Aw nyanog silan adti kalisa aw tyumala' sa tubig. Aw dun da ni Pilipi ba͡utismuwi ya pigsaligan na taga Étiyopiya. ");
INSERT INTO klg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagtaklang nilan lekat adti tubig, bigla' pigkamang na Ispiritu Santo si Pilipi aw dyala nan adti eped na banwa, aw wala' da na pigsaligan kita-a. Aw migpadeleg ya pigsaligan adti panaw nan na to-o migleya. ");
INSERT INTO klg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Aw si Pilipi dun da pakabetang adti lunsud na Asoto. Aw pigpa-ede' nan ya Madyaw na Ubat-ubat kan Jisus adti manga utaw na nyeya' adti kadég na manga lunsud na pig-agiyan nan pasinan adti syudad na Césariya. ");
INSERT INTO klg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Manang dun ni manga allaw yan, kenne' pa ni Saulo pigpamulayaman ya manga mangintu-uway kan Jisus aw gayed nan silan byantakan na apnasen. Yanagaw nyadtu sakanan adti pangulu na manga magdadugsu-ay dun ni Témplo na awun ni Jérusalim ");
INSERT INTO klg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aw migsekat sa manga sulat na un pakita' adti magdadumala͡ay sa manga sinagoga na manga Judiyu adti syudad na Damasko. Ya manga sulat yan, palangad katundanan nan magdakep sa manga utaw na nyangintu-u kan Jisus. Kadég na kita-en nan na dun na nyangintu-u la, pangkay eseg aw ka͡ubayan, alag nan dakepen aw pa-agad adti Jérusalim. ");
INSERT INTO klg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na, sa malapit da si Saulo adti Damasko, bigla' awun kalalamdag na to-o masilang na lekat adti tas na langit na nyakapalibed kanan, ");
INSERT INTO klg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","aw dayaw sakanan nyatuwad dun ni lupa', aw awun tingeg na dyengeg nan, “We Saulo! We Saulo! Ananga' aku mu gayed pamulayaman?” ");
INSERT INTO klg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Aw tyumubag si Saulo, “Singalan kaw kay Sir?” Aw tyumubag ya tingeg, “Aku saba si Jisus na gayed mu pigpamulayaman. ");
INSERT INTO klg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Manang pagbangun kaw aw kadtuwi ya syudad. Pagdateng da mu dun, awun maglong kanmu sa unu ya un mu imo-un.” ");
INSERT INTO klg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na, ya manga eped ni Saulo, wala' silan pakapaglong kay to-o silan kyabigla-an. Kay dyengeg nilan ya tingeg manang wala' ya kyinita' nilan na miglong. ");
INSERT INTO klg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yanagaw migbangun si Saulo lekat adti lupa', manang pagbeka' nan sa kanan manga mata, dili' da sakanan magkita'. Yanagaw pig-agak sakanan na manga eped nan aw pig-ated nilan adti Damasko. ");
INSERT INTO klg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aw seled na tulungallaw wala' sakanan kita', aw wala' uman sakanan kan aw wala' inem. ");
INSERT INTO klg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na, dun ni syudad na Damasko pag-eya' ya sambuk na mangintu-uway kan Jisus na pigngalanan na Ananiyas. Aw migpakita' si Jisus kanan kasiling na migtagaynep, aw piglongan nan, “We Ananiyas.” Aw miglong si Ananiyas, “Ini aku, kay Pangulu.” ");
INSERT INTO klg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Aw miglong si Jisus kanan, “Kadtu kaw ni dalan na pigngalanan na ‘Matulid,’ aw paninawa adti balay ni Judas ya sambuk na eseg na pigngalanan na si Saulo na taga syudad na Tarso. Kay tolobo sakanan nyanawagtawag adti Tyumanem ");
INSERT INTO klg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","aw pigpakita' da ta kaw kanan magi sa tagaynep na nyadtu kaw kunu adti pig-eya-an nan aw pigpandungan mu sakanan na kanmu palad pada kumita' sakanan salut.” ");
INSERT INTO klg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Manang tyumubag si Ananiyas, “Kay Pangulu, pigdengeg ku adti madég na manga utaw na malatay ya bet na utaw yeiy. To-o nan pigpamulayaman ya madég na mangintu-uway kanmu dun ni Jérusalim, ");
INSERT INTO klg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","aw adun, awun da katundanan nan lekat adti mangkatas na manga magdadugsu-ay dun ni Jérusalim na magdakep sa kadég na nyangintu-u kanmu.” ");
INSERT INTO klg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Manang miglong si Jisus kanan, “Kadtu kaw ni sayid nan, kay pigpamalli' ku dadan si Saulo na un aku nan pa-ede' adti manga utaw na Héntil, aw adti asdangan na manga hari', aw adti manga utaw na buwadbuwad ni Isra-él. ");
INSERT INTO klg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aw pa-ede' ku kanan ya kadég na ka-ilangan nan ti-isan asuntu sa pagpangintu-u nan kanak.” ");
INSERT INTO klg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yanagaw nyadtu si Ananiyas aw syumeled adti balay ni Judas. Aw pigpandungan nan na kanan palad si Saulo, aw law nan, “Kay inulug Saulo, pigsugu' aku ni Jisus na kanaten Pangulu, yan saba ya migpakita' kanmu dun ni dalan talana mu migpasinan adi. Aw pigpakadi aku nan pada salut kaw kumita' aw matmu' na Ispiritu Santo.” ");
INSERT INTO klg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aw tigkan awun nyangkataktak lekat adti mata ni Saulo na kasiling na manga imbis na isda', aw dayaw sakanan kyumita' salut. Pagkatigkas yan, nyindeg sakanan aw migpaba͡utismu la. ");
INSERT INTO klg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kyuman sakanan aw lyumiku' ya kabagseg na lawas nan. Na, seled na pilangallaw nyeya' si Saulo adti sayid na manga mangintu-uway dun ni Damasko. ");
INSERT INTO klg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Aw nyadtu sakanan ni manga sinagoga aw pig-ubat-ubatan nan ya manga Judiyu, law nan, “Si Jisus, yan saba ya Ise' na Tyumanem.” ");
INSERT INTO klg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aw ya kadég na utaw na dyumengeg kanan, to-o silan nyabelengbeleng. Aw mig-usip-usipay silan, “Ananga' ya utaw iyan? Idtu muna, pigpamulayaman nan ya manga mangintu-uway kan Jisus adti Jérusalim. Aw ya tud na pagkadi nan asini banwa yeiy, yan ya pagdakep sa manga mangintu-uway pada pa-agad adti asdangan na mangkatas na manga magdadugsu-ay dun ni Jérusalim.” ");
INSERT INTO klg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Manang dun ni manga allaw yan, si Saulo to-o pa kyadugangan ya katulus na pagpalna-u nan, aw dun ni palna-u nan pigmatinaw nan na si Jisus, yan ya Kristu. Aw ya manga utaw na Judiyu dun ni Damasko, dili' nilan mabatug tubagen ya pagmatinaw nan. ");
INSERT INTO klg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Paglabay da na madég na allaw, awun eped na manga Judiyu dun ni Damasko na migkasambuk migpalpa na patayen si Saulo. ");
INSERT INTO klg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kada allaw aw gabi, pigbanganan nilan si Saulo dun ni manga suwangan na inalad na syudad. Manang awun migpa-ede' kanan sa pigpalpa nilan. ");
INSERT INTO klg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aw pigtamengan sakanan na manga utaw na dyumalug sa palna-u nan. Pigpa-ingkud nilan si Saulo adti seled na dakula' to-o na be-en aw yan na gabi pigtonton nilan adti luwa' na inalad na syudad. ");
INSERT INTO klg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aw lyumiku' si Saulo adti Jérusalim aw kaliman nan galu sumambuk adti manga mangintu-uway kan Jisus, manang nyallek silan kanan kay iman nilan aw wala' pa sakanan pangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Manang pig-alladan sakanan ni Bérnabi adti asdangan na manga apostolés. Aw pig-ubat ni Bérnabi kanilan ya pagpakita' ni Jisus kan Saulo adti dalan pasinan dun ni Damasko aw ya piglong ni Jisus kanan, aw ya pag-ubat-ubat ni Saulo dun ni ngalan ni Jisus adti manga utaw na awun ni Damasko na wala' ya kakallekan. ");
INSERT INTO klg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yanagaw migka-iyeped da si Saulo aw ya manga mangintu-uway dun. Aw pangkay ayin silan kadtu dun ni Jérusalim, wala' si Saulo kallek mag-ubat-ubat dun ni ngalan ni Jisus. ");
INSERT INTO klg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na, awun manga Judiyu na yan ya kanilan tingeg ya Grigo. Aw ya palna-u nilan gayed pigbilingbiling ni Saulo. Yanagaw byantakan nilan na patayen sakanan. ");
INSERT INTO klg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aw sa pagka-ede' na manga mangintu-uway na byantakan si Saulo, pig-ated nilan sakanan adti syudad na Césariya aw pigpasakay nilan pasinan adti banwa nan na Tarso. ");
INSERT INTO klg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Aw dun ni manga allaw yan, tyumeneng da ya pagpamulayam sa manga mangintu-uway dun ni manga banwa na Judiya aw Galiliya aw Samariya. Magi sa tabang na Ispiritu Santo, migkadég silan aw gayed uman migkasalig ya kanilan pagpangintu-u aw gayed silan nyallek sa Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, si Pédro gayed nan pigkadtuwan ya manga banwa na pig-eya-an na manga mangintu-uway. Sambuk na allaw nyadtu sakanan ni manga mangintu-uway na awun ni lunsud na Lida. ");
INSERT INTO klg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dun ni lunsud yan, kyinita' nan ya sambuk na eseg na pigngalanan na si Éniyas. Seled na walungka͡umay, dili' sakanan magpakabangun kay pulid sakanan. ");
INSERT INTO klg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Aw miglong si Pédro kanan, “Kay Éniyas, pagbangun kaw aw luluna ya kamen mu, kay pigguli' da ni Jisu-Kristu ya kanmu magkedel.” Aw nyaksay si Éniyas migbangun. ");
INSERT INTO klg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pagkita' na kadég na utaw dun ni Lida aw adti kalatagan na Syaron na kyaguli-an da si Éniyas, nyangintu-u silan uman kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, adti lunsud na Jopa awun sambuk na ka͡ubayan na nyangintu-u na pigngalanan na Tabita. Ya ngalan nan adti tingeg na Grigo, Dorkas. Madég ya pigpan-imo' nan na madyaw aw gayed sakanan tyumabang sa manga utaw na wala' ya pagkamangan. ");
INSERT INTO klg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sa kenne' pa ni Pédro adti Lida, kyedelan si Tabita aw to-o kyatigda-an, aw nyatay sakanan. Pig-ugasan na manga ubaybay nan ya kanan lawas aw pigpakulang nilan dun ni tambi' adti kadwa na kansad na balay nan. ");
INSERT INTO klg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na, mig-ilapit ya lunsud na Jopa aw ya lunsud na Lida. Aw sa pagdengeg na manga mangintu-uway dun ni Jopa na adtu pa si Pédro ni Lida, pigsugu' nilan ya duwa ya eseg pada angayen sakanan. Aw nyanginayu' silan kanan, law nilan, “Kaksay kaw beg agad kanami!” ");
INSERT INTO klg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aw nyaksay si Pédro nyindeg aw nyagad kanilan. Pagdateng nilan dun ni balay, pig-alladan nilan si Pédro adti tambi' na kyakulangan na lawas ni Tabita. Pagseled nan adti tambi', piglibedan sakanan na manga balu na alag migsugaw, aw pigpakita' nilan kanan ya manga kadégkadég na pigté' ni Dorkas sa utaw pa sakanan. ");
INSERT INTO klg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Aw pigpaluwa' ni Pédro ya kadég nilan adti tambi'. Aw lyumuhud sakanan aw nyanawagtawag adti Tyumanem. Aw tigkas yan, pig-asdangan nan ya lawas ni Tabita aw law nan, “Kay Tabita, pagbangun kaw!” Aw pigbeka' nan ya kanan manga mata. Pagkita' nan kan Pédro, dayaw sakanan nyingkud. ");
INSERT INTO klg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pig-awidan ni Pédro ya taklayan nan aw pigpa-indeg nan. Tigkas yan, pigpaseled ni Pédro ya manga balu aw eped na mangintu-uway, aw pigpakita' nan kanilan na nyataw da si Tabita. ");
INSERT INTO klg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aw nyabekkal ya ubat-ubat kan Tabita adti kadakula' na lunsud na Jopa, aw ya syampetan yan madég ya utaw na nyangintu-u kan Jisus. ");
INSERT INTO klg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aw si Pédro, nyeya' pa dun ni Jopa seled na madég na allaw, adti balay na sambuk na eseg na mag-imo-ay sa pametang lekat adti kindal na ayep. Aw ya utaw yan pigngalanan uman na si Simon. ");
INSERT INTO klg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, adti syudad na Césariya dun ni probinsya na Judiya, awun utaw dun na pigngalanan na Cornélyo. Sambuk sakanan na kapitan na migdumala sa sangka batalyun ya sundalu na taga Italiya. ");
INSERT INTO klg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aw pangkay Héntil sakanan, manang nyatibulluk ya ginawa nan dyumalug sa Tyumanem aw awun pagkallek nan kanan, dala uman ya manga ka-epedanan nan dun ni balay. Aw dakula' to-o ya tabang nan adti manga Judiyu na wala' ya pagkamangan. Aw malikit sakanan magpanawagtawag adti Tyumanem. ");
INSERT INTO klg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sambuk na allaw, manga alas trés na ambung, awun anghil n