﻿USE sofia;
DROP TABLE IF EXISTS sofia.kkl_vpl;
CREATE TABLE kkl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kkl_vpl WRITE;
INSERT INTO kkl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nia mangkina wamna komag, yum-yum samenag Allahri sunulamogti, imap so'oap samenag sumbaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Imap so'oap sumbaog li mog so'o eraruk wamogpa, senerakna babe sunsunum kom wamog. Sik tapto inibin sogmondo aloamogpa, magti mog so'o nikniamog. Magti mog so'o nikniamogpa, ot Allah Yameog mag alip toman lebe alamog. ");
INSERT INTO kkl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mag alip toman Allah Yame lebe alamogpa, Allahri ik selek sum eneko yubu lelamogti, “Ae mog so'o tibin tae,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Tibin tae seogpa, tibin taogpa, kembaogti, walia uan sembaog. Walia uan sembaogti, “Tibin mo inibin mo wamdik,” aro tibin aneko “Ae yo'obi,” engero pibogti, inibin aneko “Ae inipna” engero pibog. ");
INSERT INTO kkl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Imbaogti, inipna selekne taogpa, kwelekaogpa, ik phendep sum eneko Allah yubu lelamogti, “Mag mombolag sip longop tangkamlangeap, paliag sip longop tangkamlangeap, a'ero-a'ero longop tangkamdik,” aro irikna phela wengero pibog. ");
INSERT INTO kkl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Wengero pibogti, irikna phela wengero pibogne neneko “Im” si engkaogpa, imbaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Imbaogti, inipna phendepne taogpa, kwelekaogpa, ik wilindip sum eneko Allahri yubu lelamogti, “Mag im mombolag sip wamlange mo longop taleba, mog so'o mektopne lag tale,” seogpa, mag mo longop taogti, so'o mektopne lag taog. ");
INSERT INTO kkl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mag longop taogne neneko Allahri “mag sin longoropne mag nubunge laut” engkaogti, mog so'o mag sindi niknibaog komne so'o nimi wamnebag pibogti, “so'o mektopne” engkaogti, walia uan sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Walia uan sembaogti, Allahri yubu lelamogti, “So'o mektopne sumbanne neneri pongoroba kal wana maubalulneap nia mangkina wana pongop talulneap a'ero wamlulba pongop tale,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Pongop tale seogpa, mog so'o anekori nia mangkina pongoro yabiog. Pongoro yabiogpa, Allahri kembaogti, walia uan sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Walia uan sembaogpa, imbaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Imbaogti, inipna wilindi taogpa, ik tom sum eneko Allahri yubu lelamogti, “Mog so'o tibin nenenne imag warebale. Yo'obi sembe nhon inipnag sembe nhon, ae ik a'ilinne sembe nhon, heng kom tangom yag tangom anpa a'ilinne sembe babe nhon, Na Allah omeklamnikti awi uro wamikti a'ilinne sembe babe warebale,” seogne nene sik taog. ");
INSERT INTO kkl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tibin nenenne nubunge phende sunulamogti, yo'obi sembe heng sumbaogti, inipnag sembe wal sumbaogti, imberea babe sumbaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","“Tibin mo inibin mo wamdik,” aro yo'obiap inipnaap sembe mog so'o tibin nenena abeneko Allahri imag mebirog. Mebirogti, kembaogti, walia uan sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Walia uan sembaogti, kembaogpa, ae inipna tom sum taog. ");
INSERT INTO kkl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Inipna ik tom sum taogpa, ik lam sum eneko Allahri yubu lelamogti, “Maghag lebe aropneap winang im toman yabilulneap yag tale,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Seogti, Allahri maghag lebe aropneap, nubungeap, ologneap, winang im toman yabiropneap sumbaog. Sumbaogti, kembaogti, walia uan sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","23","Walia uan sembaogti, Allahri yubu lelamogti, “Maghag wamukangneap winang im toman yabukangneap mangap taikti, so'oag maghag imag manga pilili sululom,” aro mikip nembahiog. ");
INSERT INTO kkl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ik lam sum taogpa, ik no'op sum eneko Allahri yubu lelamogti, “Nia mangkina lebe aroba, nimiri pia mo'oropneap, pia urop komneap, yan toman piropneap, mon magti yabiropneap a'ero wamukangpa, mog so'o aneri yag nenep tale,” seogne nene sik taog. ");
INSERT INTO kkl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nia mangkina lebe aroba sumbaogti, kembaogti, walia uan sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Walia uan sembaogti, nen Allahri yubu lelamogti, “Wene Na nong yameap seneragnaap sunsunum uro nimi sumbanun. Sindi nia mangkina lebe aroba nubunge ologne nimiri pia mo'osiropneap, pia mo'osirop komneap, maghag uropneap babe, mon magti yabiropne babe, winang babe sindi yae piamsukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Allahri nimi sunulamsiogti, Allah Eldamne nong yameap seneragnaap sunsunum uro nimi sumbahiogne abeneko nhon nengabo nhon kelabo sumbahiog. ");
INSERT INTO kkl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Sumbahiogti, sin mikip nembahiogti, sinag aruklamsiogti, “A'unap a'unag agha nimi mangaro likto pilengeap mog so'o ane to'op taikti, saelbamukang. Sindi lebe aroba mog so'oag maghag im toman yabiropneap nia taneko pia yae wamsukang,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“A'undi telamneba, pongoroba wana mauropneap, kal wana mauropneap, nia mangkina yina togtopneap a'ero wamlange nari tarelamsin. ");
INSERT INTO kkl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pham, winang, mana, nimiri pia mo'osiropneap, pia mo'osirop komneap, pongoroba ma'al agha telamukang,” wene seogne nene sik taog. ");
INSERT INTO kkl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allahri nia taneko sumbaogti, kembaogti, walia uitna aro yeng sembaog. Yeng sembaogpa, imbaogti, kwelekaogpa, ae inipna no'opne taog. ");
INSERT INTO kkl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Allahri undo imap so'oap nia mangkina sumbaogti, nia mangkina sumban aro sae saek sum eneko sae koupto tektek ebog. ");
INSERT INTO kkl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tektek ebiagha, Allahri, “Ik saek sum eneko wali sirik sum nemban,” aro mo wepto pibog. Allahri im so'o sumbaogne neneag palilamap. ");
INSERT INTO kkl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Allah Nuni ponekori imap so'oap sumbaog li eneko sembe sarikto pibogne. Mag anam Allahri pelengelan komag pongoroba sa'a-sa'a nia mangkina orog wamogpa, nimi nhondi babe, Eden aneko yae uro awe wenne babe orog wamog. ");
INSERT INTO kkl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aghana mog so'o punag wamogneri iba yangkalamogti, mog so'o sukuplamog. ");
INSERT INTO kkl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Sukuplamogpa, Allah Nuni ponekori so'o olog tobogti, nimi sumbaog. Nimi sumbaogti, ulom ina hain epna phoaro tobong kibogpa, nimi aneko lebe seog. ");
INSERT INTO kkl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Lebe alamogpa, Allah Nuni ponekori heng walelingkirobag sip Eden nimi aingniro wamnebag awe so'o nembaogti, nimi sumbaogne neneko ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Allah Nuni ponekori, “Mog so'o aingniro wamnep so'o enekoag wana wali sao kal nhon sao nhon sao pongkale,” sembaogpa, pongkaog. Eden so'o anekoag nusamag kal phende pongkarek. Kal nhon neneko kal wana nimiri teropba nimi ya'ag kamag urop kal, nhon neneko kal wana nimiri teropba, “Malinge nene walinge nene,” aro el tangsirop kal wamog. ");
INSERT INTO kkl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eden aingniro wamnep so'oag aneko mog so'o sumbaogne sukupnange sembe, mag lu nhon neneko agha mag ele tombare abeneko phae saog uro mabek. ");
INSERT INTO kkl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Mag nhon sina Pison nenekori Hawila so'oag kanero yabirop. Hawila so'oag aneko kamna kapna alikinag uro toroba, tingibom warebom aroba kirik kamongkai saonge emas, apna song wali kal, apna leng-leng arop kirik kamna kapna maiknoro torop kirik yogne pibog. ");
INSERT INTO kkl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mag si phendepne sina Gihon nenekori Kus so'o kanero yabirop. ");
INSERT INTO kkl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mag si wilindipne Tigris nenekori Asyur so'oag heng walelingkirobag sip yabirop. Mag si tomnena Efrat urop. ");
INSERT INTO kkl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Allah Nuni ponekori nimi sumbaogne neneko, “Eden mog so'o yae wamleri, awe topleri, wamlul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","17","Nimi sumbaogne nenekoag Allahri yubu lelamogti, “Kal mog so'o eneag wamlange tane telamlulam, aghana kal wana nimiri teropba, 'Walinge nene, malinge nene,' aro el tangsirop kal eneogna tululam kom. Temen sum tepna anag agha lag taleba, tebalulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Wene seogti, Allah Nuni ponekori wanaag agha seneraghogti, “Nengaboog wamnaba sunsunum kom. El yeplamlulne nhon elap sunsunum uro sumbanun,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wene sembaogti, so'o agha nia mangkina lebe aroba mog so'oag uropneap, im toman yabiropneap sumbaogne taneko ni poa nimi sumbaog nimi enekoag, “Si engkahilea kembanun,” aro pabiog. Pabiogpa, a'ero-a'ero si engkahiogpa, si engkahiogne taneko sunsunum uro amik babe engelamsiek. ");
INSERT INTO kkl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Lebe aroba mog so'oag uropneap, im toman yabiropneap taneko ni si engkahiogpa, nimi aneko yepnange elap sunsunumne orog wamog. ");
INSERT INTO kkl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Orog wamogpa, Allah Nuni ponekori, “Nimi aneko mangkhauk maple,” sembaogpa, malamog abeneko Nuni Allah ponekori nimi aneko ka'asik nhon lagto tobogti, lagto toboghag aneko sop agha nimbirog. ");
INSERT INTO kkl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ka'asik lagto tobogne nenekoag kelabo sumbaogti, nengabo anekoag pabiog. ");
INSERT INTO kkl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Pabiogpa, nengabo anekori yubu lelamogti, “El neneog nanap sunsunum, el wamlangena yo'o nari yo'o, sop nari sop agha yag nembal. Ane sembe kelabo si engkanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Wene undo uro yabiogne ane sembe nengabori sikini sikinin laplobiagha, ela'angeri elkel tolamlaag agha sin nong nhon sop nhon nenep tangtop. ");
INSERT INTO kkl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ela'angeap elkelap abeneko kabeog wamdek, aghana sin ali sembamdek kom. ");
INSERT INTO kkl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Allah Nuni ponekori nia mangkina sumbaogne taneko nusamag wana olog hektopne phae nhon wamog. Phae anekori kelabo anekoag hailamogti, “Allahri, 'Kal wana ni tane teheng kom,' aro ambatsil, te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Wene seogpa, kelenekori, “Kom! 'Kal so'o eneag wamlange wana ni telamturom,' seo. ");
INSERT INTO kkl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","'Ot nusamag wamlange neneog salena babe saelbaheng kom, tena babe teheng kom. Tirumun sum a'unag agha tepna lag talul,' seo,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Wene seogpa, phae anekori, “A'unag agha tepna lag talul kom,” seog. Seogti, “Allahri leplange nene, 'Kal wana ane tirikti, Na Allah saog uro wamdikti, “Malinge nene, walinge nene,” aro wana hekahileag,' aro yubu orolena lepla,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wene seogpa, kelenekori kal “Tururom kom,” seog kal eneko kemelamogpa, kal aneko wana wali wamogpa, kal wana wali wamla aro kembaogti, “Kal wana ane teneba wana hekto yabinilul,” sembaog. Wene sembaogti, kal wana aneko tagto teog. Teogti, ela'ange elkelap nhon wamdeka ela'ange tarogpa, teog. ");
INSERT INTO kkl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Terekti, abeneko kemel talamdekpa, kabeog wamdek. “Kabeog wamnam,” aro wana hekahiogpa, kal ara ma'al wiptekti enekarek. ");
INSERT INTO kkl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ae sinag ae pho alamogpa, Allah Nuni poneko awe anekoag palamogha lilim ka'ebarekti, sin phende abeneko Nuniri ipsileag aro kal liliag toknol talamdek. ");
INSERT INTO kkl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Toknop tarekti, wamdekpa, Allah Nuni ponekori nengabo anekoag, “Tala wamlam?” aro yobog. ");
INSERT INTO kkl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yobogpa, nengabo anekori, “An aweag yalamlama lilim ka'ebandi, kabeog wamna aro aliri toknol talan,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Wene seogpa, Allahri, “An kabeog wamlam aro etneri ambatkel?” seogti, “Kal wana teheng kom senne neneko telam, te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Haibaogpa, nimi nengabo anekori lelamogti, “Kelabo anap wamturom aro tatneomne nenekori kal wana aneko tatnelba, tendi wamna.” ");
INSERT INTO kkl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Seogpa, Allah Nuni ponekori kelabo aneko hailamogti, “Sa'a sembe kal wana ane telam?” seog. Wene seogpa, kelenekori, “Phae aneri yubu neplamneldi, 'Tululam,' selba ten,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Wene seogpa, Allah Nuni ponekori phae anekoag yubu lelamogti, “Andi yubu orolenange leplamba, tam nubunge anag palilamna. Nia mangkina lebe aroba taneko, ot an aghabog so'o ina mon moagti lelepto palapmendi, so'o leng-lenga aghabog tero wapmendi, tebalulam aro yo'olangken,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Yo'olangken seogti, “Nari salag lelamnari, anap keleneap aisa neneptangto wamturom aro salag palilamna. An anmaboap, kelene elmaboap isa orobog wamtumundi, andi, 'Keleneri elmabo nhon yan pubuag si sapsinun,' aro ulapmenba, eldi andi usog solapto olangkilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Wene seogti, Nuni nenekori kelabo anekoag yubu lelamogti, “An me monag poroapmenba, an me mon maikno telangkilul. Me mangaro anep peram me mon ogti indolamlulam. Andi ana'ange sembe wana maikno seneraglamlulam, aghana eldi arukna nembangkilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Wene seogti, Nuni nenekori nengabo anekoag, “Andi ankel yubu ka'ebalamdi, kal wana teheng kom senonge telamba, andi awe welapmenne mali talamlul aro yo'olangken. Andi awe kilim weyang alapmendi, welapmenne melapmenneog tero wamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yo yoaba, kirikna, werengkel, lea pongkaleba, paiag mo pongoroba aghabog mo tero wamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Awe welapmendi, whin yangkalangkel ebog tero wapmendi, tebalulam. An nong so'o agha sumbahiana tebamendi, samoro so'o talulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Wene seogpa, kelabo aneko nimi ni sikinin talul aro ela'ange Adamdi Hawa engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Engkaogpa, Allah Nuni nenekori sin phende sembe lebe aroba kon agha ag wetnero enekitsiog. ");
INSERT INTO kkl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Allah Nuni ponekori wanag agha seneragogti, “Wene sin phende nimi so'oag nimi agha Na saog uro wamdikti, “Malinge nene, walinge nene,” aro wana hekto yabihil. Sindi teban koma ya'ag kamag wamdikag aro, nimiri teropba nimi ya'ag kamag urop kal wana eneko turukang kom,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Sembaogti, Eden awe so'oag aneko yaglamsiogti, “Nari a'un sumbahisi so'o enekoag welamlulam,” aro Adam neneko ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","“Nimiri teropba nimi ane ya'ag kamag urop kal peramag babe pirikag, tena babe tirikag,” aro Allah arukna malaikat Eden so'oag anekoa heng walelingkirobag sip sekitsiog. Sekitsiogne, yae ua unneap, mal tomeag auk pog taktak aropne lemeng-lamang aropne sekitsiog. ");
INSERT INTO kkl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Wamdekti, Adam neneko elkel Hawaap mapdekpa, Hawa me monag taogpa me nengabo me mangaro aog. Me nengabo me mangaro aogti, Nani Allahri yeplamneldi me nengabo me tatnel aro me si Kain engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kain mangaro aogti ilipsae Habel babe mangaro aog. Mangkahiogpa, me abeneko nubu tarekti, Habel neneko pham mo'oropne wamogpa, Kain neneko awe wenne wamog. ");
INSERT INTO kkl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Wamdekti, Kain nenekori Nani Allah sembe mhong towaleng kimnun aro aweag mebogne nenne tobogti aukag tabog. ");
INSERT INTO kkl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tabogpa, Habel nenekori babe elenge pham domba taneko anabiagne samenagne mesah yagne nhon tobogti Ili Allah sembe tabog. Tabogpa, Ili Allahri, “Habeldi taplange wali,” aro Habel sembe awi sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kaindi tabogne mali aro Kain sembe karong sembaogne sembe Kain yo sembaogti whing mali taog. ");
INSERT INTO kkl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Whing mali taogpa, Allah El sam el taogti, Kainag, “Sa'a sembe yo talamdi whing mali talamlam? ");
INSERT INTO kkl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Andi walia uahomdi whing sepsebek uro wamsom. Andi, 'Yonge uanun,' sembalamba, malinge an wanaag yanal. Malinge nenekori an wanaag aluklangkel ana malinge seneraglamlamne nene lipsiri hekto wame,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wene seogpa, Kain nenekori ilipsae Habelag, “Aweag pununam,” seogpa, pirekti, aweag anekoa Kaindi ilipsae Habel ya'ag obog. ");
INSERT INTO kkl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Obogpa, Allahri Kainag yubu lelamogti, “Anipsae Habel tala wamla?” seogpa, Kaindi, “Na ekon. Na sop-sop naipsae yae wamsene, te?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Wene seogpa, Allah yubu lelamogti, “Sa'a sembe tamna nene ualam? Anipsae eneng so'oag yingkilne nenekori nimi yubu saog uro Nanag lelamlange neneno. Anipsae eneng yingkilne andi babe toknobanep kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Wene seogti, “Anipsae ya'ag oblamne eneng mog so'oag yingkilana an so'o eneag wamlulam kom, wena babe weltolamlulam kom alamna. Andi awe weltolapmenne, sa'a-sa'a melapmenne, pongona babe pongkalul kom. Ane sembe aingniro wamna koma ina pu alapmendi, as nhonag pang yang ulamlulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Wene seogpa, Kain nenekori Ili Allahag ambarelamogti, “Nani, yaghe! Tam nanag piplamne nene ikin maiknori, nari pomnep kom saog wamla. ");
INSERT INTO kkl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Andi, 'Na wahingag wamleag,' aro so'o walinge nene agha yag lambanelamba, aingniro koma wamneri as nhonag pang yang ulamneri wamneba, nimiri imnikti opnukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Wene seogpa, Allahri, “Wene selamba, Nari yubu lelamnari, 'Nimiri an opkikpa toro tipto Nari sindi nimi saekpare opsinun,' alamna,” seog. Wene seogti, “Nimiri talaba ibikti obikag,” aro Allahri Kainag kekneba pibog. ");
INSERT INTO kkl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kekneba pibogpa, Kain neneko Ili whingag agha lambaogti, Eden so'o mombolag sip laplobiagha heng walelingkirobag sip piogti, mog so'o Nod aro engerop so'oag pina wamog. ");
INSERT INTO kkl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain neneko elkelap maptekpa, elkel neneko me monag taogpa, me nengabo me mangaro aogti si Henokh engkaog. Wamekti, Kain nenekori as nubunge nhon ya'aro kirik sengket piro warekto sobaogti, elme si sunsunum uro as Henokh si engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henokh elme Irad, Irad elme Mehuyael, Mehuyael elme Metusael, Metusael elme Lamekh mangaro yabiog. ");
INSERT INTO kkl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekh nenekori kelabo phende topsiogne Adaap Silaap topsiog. ");
INSERT INTO kkl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nenekori Yabal mangaro aog. Yabaldi mangaroba mangarobari tanekori pham maikno pia ulamekti as nhonag tea ko'oa ulamek. ");
INSERT INTO kkl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal ilipsae taptoba si Yubal nenekori mangarobari mangaroba pingkong ona elnang wamekti, pingkong lilim nhon saogne lenne sununnang el wamek. ");
INSERT INTO kkl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamekhti kel Sila neneko elme Tubal-Kain mangaro aogpa, eldi mangarobari mangaroba awena nhon sao nhon sao solamekti, yaeap, pisog karog sununneap el wamek. Besi agha nhon saogha nhon saogha sununna elnang wamek. Tubal-Kain elipsa'el si Naama wamog. ");
INSERT INTO kkl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","24","Lamekh neneko kelabo phende topsiogne abenekoag kibiang toalengep tangtop yubu lelamogti, “Adaap Silaap sepna lemnunne ka'eamturom,” seog. Seogti, “Kain aghabog yonge wamla kom, na babe yonge wamna,” aro sepna seplamogti, “Nimi nengabo nhon olog uro opneogha sembe nari ya'ag opsi. Meneng sisua ologha sembe me nengabo nhon ya'ag olopsi. Allahri, 'Kaindi nimi nhon obogne sembe, Kain opmun tanena Nari el sembe lunuro nimi saekpare opsinun,' seog. Ane sembe na opnik tanena lunuro opnik nimi eneko teng wilindi opsilul,” aro seplamog. ");
INSERT INTO kkl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamap elkel Hawaap nikag maptekpa, kel enekori me nhon mangaro aogpa me aneko si Set engkaog. Me si Set engkaogne, “Kaindi Habel obogpa me mangaro hane komne agha Allahri Habel lunumna tatnel,” aro me si Set engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nenekori me nengabo me nhon mangaro aogti si Enos engkaog. Enos wamog li ko'o eneag agha “Nuni Allah mema singkikne,” aro si lena imbaek. ");
INSERT INTO kkl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam yina nimi sisana ane. Allahri nimi samenag sunulamsiogti Eldamne yameap sunsunum uro nimi sumbahiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kabuni kelabo sin sumbahiog. Sin mikip nembahiogti sin si “Nimi” engkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam el wamogne heng kun-kunne teng tombare eptopne no'op tarabare (130) wamogti, eldamnang yameap nongap sunsunum uro me nengabo me mangaro aogti, si Set engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adamdi me nenneap kelmabo nenneap liksiogne nen heng kun teng-tengne (800) pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam wamogti tebaogne heng kun-kunne teng-teng (930) wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set wamogti heng kun-kunne teng wilindi eptopne tom tarabare (105) wamogti, me nengabo me sina Enos mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Setdi me nenneap kelmabo nenneap liksiogne nen heng kun 807 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set wamogne heng kun-kunne 912 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos wamogne heng kun-kunne teng wilindi eptopne supnabare (90) wamogti me si Kenan mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosti Kenan mangkaogti me nenneap kelmabo nenneap liksiogne nen heng kun 815 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos wamogne heng kun-kunne 905 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan wamogne heng kun-kunne teng phende eptopne ao tarabare (70) wamogti me si Mahalaleel mangkaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenandi Mahalaleel mangkaogti, me nenneap kelmabo nenneap liksiogne nen heng kun 840 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan wamogne heng kun-kunne 910 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel heng kun-kunne teng phende eptopne ko'olombare (65) wamogti me si Yared mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleeldi me nenneap kelmabo nenneap liksiogne nen heng kun 830 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleel wamogne heng kun-kunne 895 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared wamogne heng kun-kunne teng no'opbare (162) wamogti me nengabo me si Henokh mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaredti me nenneap kelmabo nenneap liksiogne nen heng kun 800 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yared wamogne heng kun-kunne 962 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henokh heng kun-kunne teng phende eptopne ko'olombare (65) wamogti me nengabo me Metusalah mangkaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henokhti Metusalah mangkaogti Allahap sae tiptangto wamdekne heng kun teng ko'olombare eptopne wilindi (300) ulamdekti nen meap kelmaboap mangalamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henokh wamogne heng kun-kunne teng naualbare eptopne mekpare (365) wamog. ");
INSERT INTO kkl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henokh Allahap sae tiptangto ulamdekti Allahri kiliro tobog. ");
INSERT INTO kkl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalah heng kun-kunne teng no'opbare eptopne phendeba tarabare (187) wamogti me nengabo me si Lamekh mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusalah Lamekh mangaro aogti me nenneap kelmabo nenneap liksiogne nen heng kun 782 pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusalah wamogne heng kun-kunne 969 wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamekh heng kun-kunne teng no'opbare eptopne lin tarabare (182) wamogti me nengabo me mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mangaro aogti si Nuh aro engkaogne, “Allahri so'o ene wabaogpa eraruk aghana nuri whin uro awe tolamebeag me eneri wana aingnilamsilul,” aro Lamekhti me si Nuh aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamekh nen wamogti me nenneap kelmabo nenneap liksiogne nen heng kun teng no'op tarabare eptopne selek (595) pin komag agha, liksiog. ");
INSERT INTO kkl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wamogha eldinge heng kun-kunne 777 taogpa Lamekh tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuh heng kun-kunne wamogha teng sa'o tarabare eptopne mekpare (500) taogpa eldinge me wilindi mangkahiog, sina: Sem, Yafet, apna Hamap. ");
INSERT INTO kkl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mog so'o sirikag-sirikag nimi maikno likto palamogpa, kelabo maikno mangalamsiek. ");
INSERT INTO kkl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Allah Elmabo tanekori kemelamsiekpa, kelmabo saren walingeog wamek. Wamekpa, sindi wanari, “Toro aukap,” senelamekneog tolamsiek. ");
INSERT INTO kkl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Undo unulamekpa, Nuni Allah ponekori yubu lelamogti, “Nimi ya'ag kamag wamikag, hain Nari tarelamsinne sinna nimi sop, ane sembe heng kun taibuka taubuka ulamlea teng lambareog wamukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Abene li nengabo si “Nefalim” engehiropne mog so'o eneag wamek. Wamekpa Allah Elmaboap kelabo tanekoapti nimi mangkahiekpa sindi mangaroba mangkahiropne yin sae yo nang wamek. Samenag sin taneko wamekti, log kom uro palisong uro nimi si lehinneog wamek. ");
INSERT INTO kkl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Allahri nimi kemelamsiogpa, nimi so'oag nimiri wanaag agha malingeog seneraglamekti, malingeog ulameka kembahiog. ");
INSERT INTO kkl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","7","Kembahiogti, “Sa'a sembe sin sumbahisiri, 'So'o eneag wamlulom,' aro ambatsisi?” sembaogti, wana mali taog. “Na mane agha uahi,” aro wana-ag seneraghogti, “Nimi Nari sumbahisinge taneap lebe aroba so'oag wamangneap, imtoman yabiropneap, ni taneko ni Nari kom nembahinun. ");
INSERT INTO kkl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ot Nuh sembe aghabog Nari awi senelamnange limnun,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","11","Nuh ponekori ulamogne ane: Nuh elmabo me nengabo me wilindi abeneko sina Sem, Yafet, Ham mangkahiog. Nimi so'oag nimi Nuh likog ko'oag wamekne tanekori malia aghabog ulamekpa, ot Nuh aghabog Allahap sae tipto wamogti, malia uan koma wamogti, nimi wamek nimiap se'el neneptangto koma wamek. Aghana nimi yogne ni tala-tala wamekne tanekori Allah whingag yoaba aghabog ulamekti, nimi olamsiek. ");
INSERT INTO kkl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allahri kemelamsiogpa, sindi uanep kom saogneog ulamekti, sik malinge aghabog ulamek. ");
INSERT INTO kkl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ulamekpa, Allahri Nuh ponekoag yubu lelamogti, “Nimi ni kom taukang aro karepto palilamna. Sindi malia ulamangne mog so'o to'op talamlaba, nimi niap nia mangkinaap orog nembanun. ");
INSERT INTO kkl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ane sembe kabong mag alip toman piroba nhon polbanep kom kal, kat kal agha sol tolamlulam. Kabong anekoag leka wilniro sobamendi, mag wa'ileag aro paiag simbik babe, aeag simbik babe wiri lelepto sobalulam. ");
INSERT INTO kkl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kabong aneko sunuro we uro sobalulamagna yan ingiro a'ilina saog tanena, selek teng, phendep teng eneko, teng tombareap epto wilindiba tarabareap sobalulam. Sabo uro sunuro sobalulamagna timbom agha no'op tarabare sobalulam. We uro tai solingkululamagna moromna nualbare saog uro solingkululam. Kabong aneko solapmendi, kabong lomag tika wilindi sobalulam. ");
INSERT INTO kkl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Imagap peyaganoap solapmendi, anabiag keken nhon phobalulam. Kabong aneko paro tara sip ina siram nhon pa'abalulam. ");
INSERT INTO kkl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","'Hain eptoba ni orog taik,' aro Nari mag sin nubunge arukaneba, longoro walelamleri, niknibahileba, ni tebaukang. ");
INSERT INTO kkl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","'Ot an aghabog toro pipkinun,' aro anag salag lelamna. Andi kelap, anmabori kelaboap, kabongag wa'alulom. ");
INSERT INTO kkl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Lebe aroba so'oag uropneap, im toman yabiropneap sin babe ni tebaikag, ane sembe si a'aero wamangne nene uro kelne nhon, yemne nhon anag yaikpa, kabong anekoag toro tobongkahilulam. ");
INSERT INTO kkl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","22","A'unap lebe aroba tanekoapti telamluloma maiknoro tobongkalulam,” aro ambarogha sunsunum uro uaog. ");
INSERT INTO kkl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Olog wameka Nuni Allah ponekori Nuh ponekoag yubu lelamogti, “Nari an kemelangkenba, nimi wamangne anabiag ot an nhonog sikneog ulamlamba anag Nari wana piamna. Ane sembe wene anenge kelabo meap kabong sobaomne nenekoag wa'alulom. ");
INSERT INTO kkl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","A'un kabongag wa'alapmundi lebe aroba Allah sembe pimnep saogne so'oag yabiropneap, im toman yabiropneap, si a'ero wamlange kel nenge saekpare topsimendi tolongolamsimendi, Allah sembe pimnep kom saogne nhon sao nhon sao wamlange ot yemne nhon, kelne nhon topsimendi tobongkahilulam. Magdi niknibahileba ya'ag orog taikag amik sin babe maikno taukangba, ambatkenne nene sunsunum uro ualulam. ");
INSERT INTO kkl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","5","Ik saekpare wapmunba, 'Hain eptoba Nari sumbahisinge orog talul,' aro Nari mag nubunge pelengelaneba telamlea inipna teng nhon epto naualbare talul,” aro Nuni Allahri ambarogne sunsunum uro Nuh ponekori ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","16","Allahri lebogne sunsunum uro lebe aroba so'oag yabiropneap, im toman yabiropneap, teropneap, terop komneap, Allah sembe pimnep saogneap, si sisa a'ero kabong anekoag yalamekpa, Nuh ponekori tobongkipsiog. Tobongki agha nen ik saekpare wamekpa, mag longolamog sumeneko Nuh, elkelabo, elmabo Sem, Yafet, Ham, sin kelaboap kabong anekoag “Magdi opsileag,” aro Nuh poneko kelabo meap, elmabori kelaboap kabongag wa'alamekti, lebe aroba nimiri pia mo'osiropneap, mo'osirop komneap, mon magti so'oag lelepto yabiropneap, im toman yabiropne ol yagneap, hain eptoba so'oag uroba kel nenge kabongag aneko yalamekpa, Allahri lebogne sunsunum uro Nuh ponekori tobongkipsiogpa, Allahri ina serekahiog. Ina serekahiogpa mag longoro walelamogti, mog so'o niknilamog sum Nuh poneko mangaro yabiogne heng kun taibuka taubuka ulamogha heng kun-kunne 600, wal phendepne, ae ik ko'olom tarabare sumeneko mag punguro walelamogpa, imag siba im kupto mag nubunge kuluklamog paghabog ae inipna teng nhon epto naualbare taog. Mag longoro walelamogti, mog so'o niknibaogne neneko li sumene Nuh mangkaekne heng kun-kunne 600 wamogpa uro yabiog. ");
INSERT INTO kkl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Mag aneko longoro payangkalamog paghabog ae inipna teng nhon epto naualbare taogpa, kabong aneko pawalelamogti, mag alibag yingkiogpa, pol keaglamog. ");
INSERT INTO kkl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Mag aneko maiknoro longolamogti, yim nubunge ta'aro niknilamogti, im ngang tamag walbaogpa, mog so'o wamloa abeneko ta'aro niknibaog. ");
INSERT INTO kkl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Undo unulamogti, Nuni Allahri nia mangkina hain eptopne so'oag yabiropneap, im toman yabiropneap, nimiri mo'osiropneap, peret aro yabiropneap, kelero yabiropneap, nimiap ya'ag orog nenelamsiogti, ot Nuhap kabongag aneko wa'iekneog Allahri toro pipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mag longoro walbaogne neneko lo'oe tan koma wamog paghabog ik teng lambare eptopne naual tarabare (150) taogpa, kabong aneko saignil ingkiog. ");
INSERT INTO kkl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kabong aneko saingnil ingkiogne sembe palilamap. Allahri Nuhap lebe aroba kabongag wa'iekne tanekoap sembe ekon tan koma seneraglamogti, phoana poghogpa, mag longoro walbaogne neneko lo'oe tangtang kuluklamog. ");
INSERT INTO kkl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","3","Mag so'oag agha punguro walelamogne taneko kom nenelamogti, imag agha kulukul alamogne taneko kom nenero lepto unulamog abeneko mag longkaogne taneko lo'oe tangtang kuluklamog. Mag aneko lo'oe taogne wal lambare agha lo'oe taog. ");
INSERT INTO kkl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Wal saekne, ik ko'olom tarabare taog sum eneko kabong aneko Ararat sip yim tamag saingnil ingkiog. ");
INSERT INTO kkl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Saingnil ingkiogpa, wal wilindi wamekpa, mag aneko lo'oe tangtang kuluklamogha wal sa'ongeag, ik selek sum eneko yim lag tangtang palamog. ");
INSERT INTO kkl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Inipna teng nhon epto naualbare wamogti Nuh ponekori keken lepto soroba aneko kubogti winang hamale sae laplobog. Sae laplobogpa, piogha aneko yan kom paghabog mag aneko lo'oe tangtang kuluklamog. ");
INSERT INTO kkl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","Lo'oe talamogpa Nuh ponekori, “Mag aneko ya'ag lo'oe tal, to?” aro winang mem winang nhon sae laplobog, aghana mag aneko mog so'o ni nikniamogpa winang aneko puna-ag orogti nen samoro kabong anekoag pul aogpa, Nuh poneko sae la'aro winang aneko saelbaogti, nen kabong ae lomag toro pibog. ");
INSERT INTO kkl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Toro pibogti, ik saekbare wamogha nen mem winang aneko sae laplobog. ");
INSERT INTO kkl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Sae laplobog sum eneko ae sinag winang anekori kal zaitun ma'al erenne nhon singkamogti, payaogpa, Nuh ponekori, “Mag lo'oe tal,” aro el taog. ");
INSERT INTO kkl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nen ik saekpare wamogha Nuh ponekori winang aneko nen sae laplobogpa piogha aneko nen samoro yaog kom. ");
INSERT INTO kkl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuh poneko mangkaeka heng kun taibuka taubuka ulamogha teng no'op tarabare eptopne saekpare (601), wal selekne, ik selek sum eneko mag aneko ya'ag lo'oe taogpa, Nuh poneko ae imag sobaogne neneko lelekto tilamogpa, mag lo'oe tangto mog so'o mektobag tibaog. ");
INSERT INTO kkl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ik teng phende eptopne wilindip sum taogpa, mog so'o ya'ag mekog. ");
INSERT INTO kkl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mekogpa Allahri yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“An anenge kelabo meap, anmabori kelaboap lambahut! ");
INSERT INTO kkl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Lebe aroba so'oag yabiropneap, im toman yabiropneap, nubunge ologne mangap taikti, mog so'o tala-tala wamukangba ni poa lambalulam!” seog. ");
INSERT INTO kkl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wene seogpa, Nuh ponekori elkelap, elmaboap, elmabori kelaboap kabongag agha lanalamekti, ");
INSERT INTO kkl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","lebe aroba taneko sisa a'ero poa lambahiek. ");
INSERT INTO kkl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Lambaekti abeneko Nuh ponekori, “Nuni Allah sembe mhong towalengkanun,” aro kirik yangkaogti, lebe aroba so'oag yabiropneap, im toman yabiropneap, Allah sembe pimnep saogne sisa a'ero uropne nhon-nhon obogti, aukag tabog. ");
INSERT INTO kkl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","“Nuhri taplange Na sembe wali sembaldi tapla,” aro Nuni Allah awi sembaogti, wanaag agha seneraghogti, “Amik, nimiri malia ulamikne sembe Nari so'o ane yo'obanun kom. Nimi ologhag nolamang liag agha wana malinge seneraglamangne sembe Na wana sesog, aghana hain eptoba ni amik nen kom nembahinun kom. ");
INSERT INTO kkl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mog so'o ane orog tan koma wamleba, wero mero tero, sonap boboap, ebare mag, inipna kwelekna wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Wene seogti, Allahri Nuh elmaboap mikip nenero aruklamsiogti, “A'unag agha nimi maikno mangaro pileba, mog so'o ane to'op talul. ");
INSERT INTO kkl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Samenag magti nimi opsin komag nimiap lebe arobaap sin nikag wamek aghana magti opsiogpa, lebe aroba so'oag uropneap, im toman yabiropneap, maghag uropneap a'un sembe log uro wamukang. 'A'un mikip uro wapmundi, lebe aroba saelbamsululom' aro sin ni a'un saeag palilamna. ");
INSERT INTO kkl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","'So'oag agha pongoroba telamlulom,' aro Nari tatsisi saog uro wene, 'Lebe aroba taneko babe telamlulom,' aro wene ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ot enengag agha kamag wamnep, ane sembe lebe aroba enengap teheng kom. ");
INSERT INTO kkl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Nari nimi Nandamne yameap sunsunum uro sumbahisi ana a'undi eneng, a'undi hain sembe Nari lumbanun. Lebe arobari opsilea babe Nari lumbanun, nimiri opsika babe Nari a'undi hain lumbanun. Nimi etneri nimi olamsile tanena el neneko nimi yogneri obukang. ");
INSERT INTO kkl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A'unag agha nimi maikno mangkahimunneri mog so'o to'op talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Wene seogti Allahri Nuh elmaboap sin ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“Wene anap anmaboapti mangkahimunneap, lebe aroba so'oag wamangneap, im toman yabiropneap, a'un ni kabong anekoag agha lambalomne, sikindi mangkahyikne sembe babe niag salag palilamnange ane: ");
INSERT INTO kkl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","'Nia mangkina hain eptopne ni wamlange nen mag agha opsunun kom,' aro salag ane palilamna. Nen mag nubunge longoro walelamleri, mog so'o ane mali nembalul kom. ");
INSERT INTO kkl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Nari a'unap lebe aroba tanekoap a'unag salag palilamnange nene wamle paghabog wamlul. Salag palilamnange nene sembe kekneba Nari yin ene phae mano yame saog uro kokto imag wiriklamna. ");
INSERT INTO kkl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sop-sop toa pololong aropne payalamneba mano yame lag talamle tanena, ");
INSERT INTO kkl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Nari, 'Nia mangkina hain eptoba nen opsunun kom,' aro salag palilamnange neneag seneraglamnun. ");
INSERT INTO kkl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nari yin mano yame saog uro lag talamleba Nari kemelamneri, a'unap lebe arobaap sembe salag lelamnange nene kom tanep komdi palilamnange nene sembe el uro wamnun. ");
INSERT INTO kkl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nari nia mangkina hain ua uropne niag salag lelamnange nene sik senelamlulomba, kekneba Nari yin phae mano yame ane wiriklamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuh elmabo kabong anekoag agha lambaekne taneko si Sem, Yafet, Ham lambaek. Ham elmena sina Kanaan. ");
INSERT INTO kkl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuh elmabo wilindi abeneko nimi so'oag nimi ni sikinisang taog. ");
INSERT INTO kkl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh poneko awe weropne wamogti, haing anggur awe wenne alnibaog. ");
INSERT INTO kkl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Haing anggur awe welamogti, ik nhon sum Nuh poneko haing anggur lolteroba mag yonge maikno teogti, nenek salehirop nang saog uro ulamog. Nenek salehirop nang saog uro ulamogti, ag enekto amogne komopto tobogahiogti, elenge ae kalun aeag aneko malamog. ");
INSERT INTO kkl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nuh poneko karebenang malamogpa Ham nenekori kembaogti, “Naro yabo ambatsineba og sobukap,” aro ambarel pihiog. ");
INSERT INTO kkl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ambarel pihiogpa, Semap Yafetapti ag nhon toptekti, sa'o tara-tara ag sirikag saelbamdekti, wail toman ko'ol palamdekti, “Nani kerebenang wamla imnunam kom,” aro wail tahip agha ag aneko niknibarek. ");
INSERT INTO kkl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Niknibarekti wamdekpa, mag yonge teogne neneko wana peket taogpa, pukogti, “Hamdi nanag uanep kom saogne ual,” aro ");
INSERT INTO kkl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Hamag yubu lelamogti, “Anme Kanaan seklebale! Elkabo arukna taleri seklenne wamle! ");
INSERT INTO kkl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","Name Sem Ili Allah omeknange wamlaba, nimiri babe Sem Ili Allah omeklamukang. Allahri Yafet elenge mog so'o yabto ambatleba, eldi mangaro mangkahilenge tanekori Sem elmaboap nikag wamukang. Aghana Kanaan neneko elkabo arukna talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Mag nubunge neneko longoro walelamogti nimi obsiogha Nuh heng kun-kunne teng no'op tarabare eptopne no'opbare (600) wamogpa, uro yabiog. Uro yabiog aneko nen Nuh heng kun-kunne teng aobare eptopne phendeba tarabare (350) wamog. Heng kun-kunne teng aobare eptopne phendeba tarabare (350) wamogti, Nuh mangkaeka heng kun-kunne 950 wamogpa tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mag nubunge nenekori nimi opsiogpa Nuh elmabo tanekori nimi liksiekne ane. ");
INSERT INTO kkl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafetdi liksiognena Gomer, Magog, Madai, Yawan, Tubal, Mesekh apna Tirasap. ");
INSERT INTO kkl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Yafet elme me yandonge Gomer. Gomerti liksiogne Askenas, Rifat, apna Togarmaap. ");
INSERT INTO kkl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yafet elme Yawandi liksiogne Elisa, Tarsis apna Kitim nimiap Dodanim nimiap. ");
INSERT INTO kkl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yawandi mangkahiogne likto yabiogne sisa nimi ene mag longorop mag abomag urop nimi tala-tala likto mangaro yabiogti, sindi yubu babe yubu a'ero-aero lerop nimi wamek. ");
INSERT INTO kkl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham elmabona Kush, Misraim, Put apna Kanaanap. ");
INSERT INTO kkl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Hamdi me yandonge Kush. Kush elmabona Seba, Hawila, Sabta, Raema, apna Sabtekhaap. Kush elme Raema. Raema elmabona Syeba apna Dedanap. ");
INSERT INTO kkl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushti me nen nhon mangaro aogne Nimrod. Nimrod samenag nimi nubunge so'oag wamogne Nimrod wamog. ");
INSERT INTO kkl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Allahri Nimrod pone yeplamogpa, Allah whingag mana winang yin sae yonge wamog. Wamogpa nimi etne yin sae yo tanena nimiri, “El yonge Nimrod Allah whingag wamog saog uro wamla,” aropti nimiri si lerop. ");
INSERT INTO kkl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Samenag saelbamsiog asna Babel, Erekh, Akad apna mog so'o ni Sinearap. ");
INSERT INTO kkl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nen aneko mog so'o eldi saelbamsinepne nubu nenero Asyur piogti Niniwe apna Rehobot-Ir apna Kalah apna ");
INSERT INTO kkl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen sobaog. As tompare abene sobaog aghana as nubu sirikne Kalah sobaog. ");
INSERT INTO kkl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hamdi me nabinge Misraim. Misraimdi Ludim nimi mangaro, Anamim nimi mangaro, Lehabim nimi mangaro, Naftuhim nimi mangaro, ");
INSERT INTO kkl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim nimi mangaro, Kaftorim nimi mangaro, Kasluhim nimi mangkahiogne nimi ene sisana Filistin nimi. ");
INSERT INTO kkl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Hamdi elme Kanaan. Kanaandi me yandonge mangaro aogne Sidon, nabinge Het, apna Yebusi nimiap, Amori nimiap, Girgasi nimiap, Hewi nimiap, Arki nimiap, Sini nimiap, Arwadi nimiap, Semari nimiap, Hamati nimiap. Kanaandi mangaroba sisa as tala-tala likto piogti ");
INSERT INTO kkl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","as soro wamekne tane: Sidon, Gerar, Gaza, Sodom, Gomora, Adma, Zeboim apna Lasaap. ");
INSERT INTO kkl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Anena Hamdi nimi sisa likto piogne sindi as babe mo, yubu babe mo likto piog. ");
INSERT INTO kkl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","24","Yafet eldo Sem. Sem elmabo mangaro piognena: Elam, Asyur, Arpakhsad, Lud apna Aramap. Aramdi mangkahiognena: Us, Hul, Geter apna Masap. Sem elme elabo me Arpakhsad. Arpakhsadti mangkaognena: Selah, Selahri mangkaognena Eber. Ane sembena Eber nimiri, “Nu Sem ilisang wamap,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberti me phende mangkahiognena samenagne Peleg. Nimi si Peleg anena, “Mog so'o tala-tala a'eptaek,” aro. Peleg ilipsaena Yoktam. ");
INSERT INTO kkl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","30","Yoktamdi mangkahiognena Almodad, Selef, Hazar-Mawet, Yerah, Hadoram, Uzal, Dikla, Obal, Abimael, Syeba, Ofir, Hawila, apna Yobabap. Sin nimi likna nenena Yoktamdi liksiogne. Sin wamekagna Mesa apna Sefar yim heng walelingkirobag sip. ");
INSERT INTO kkl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sem sisa-ag agha nimi mangaro likto piogne sin yubu babe a'ero, as babe a'ero, sindi mog so'o babe a'ero tangtang piog. ");
INSERT INTO kkl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aghana nimi si wamlange nenena Nuh sisaringe, mag nubunge longol langkalamogdi, opsiogpa, Nuhri me wilindi liksiog aghana sin wilindiri mangkahiekne mog so'o as tala-tala nimi aghabog taog. ");
INSERT INTO kkl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Samen nimi so'oag wamekne taneko niri yubu ot nhonog yubuog lelamek. ");
INSERT INTO kkl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sin taneko yale heng walelingkirobag sip piekti mog so'o pulu nhon Sinear ibekti so'o eneag wamek. ");
INSERT INTO kkl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wamekti sin-sin yubu lelamekti, “Ae nhon sobaukap,” aro yubu lelamekti, “So'o winiro aukag tabebeba kirik saog taleba kirik pai so'obai ubu walelameberi sobukap,” seekti so'o winiro tabekti ");
INSERT INTO kkl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","lelamekti, “Nun sembe wamukapag as nhon ya'aro solameberi nusamag ae nhon mororo sopso im tamag solingkukap. Sobaberi nun tala-tala taukap kom. Sobabe ae ene nun dam nimi omektangto seneragtangto ka'aseptangto kom-kom wamukap.” ");
INSERT INTO kkl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Wene aro seneraghekti solamekpa Nuni Allahri kemelingkihinun aro kulukulaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kulukul aogti Nuni Allah ponekori, “Wene nimi mog so'o eneag wamangne yubu ot nhon, nimi mog so'o as eneag wamangne babe ot nhon, wene alnirobag alnibang, amik wamikti phelektopne ulamukang. ");
INSERT INTO kkl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ane sembe Na kulukaneri yubu yog-yog nembahineba nhondi nhon yubu ka'ebanep kom wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wene seogti Nuni Allahri, “Sin unulamangne tanena mog so'oag tala-tala taik,” aro talup lambahiogpa, ae eneko soban koma laploa tala-tala taek. ");
INSERT INTO kkl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nuni Allahri nimi yubu mo-mo nenelamsiogti, talup lambahiogpa, tala-tala taekag aneko si “Babel” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem elmabo ane. Sem heng kun-kunne teng wilindi epto ko'olom tarabare (98) wamogpa magti opsiog. Aneko nen heng kun phende wamogti Sem mangaro aogne teng wilindi epto supna tarabare (100) wamogpa el yandome si Arpakhsad mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mangaro aogti me nenneap kelmabo nenneap mangkahiogti, Sem wamogne heng kun-kunne teng no'op tarabare epto no'opbare (600) wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sem elme Arpakhsad heng kun teng nhon epto linbare (35) wamogti me si Selah mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selah mangaro aogti me nenneap kelmabo nenneap mangkahiogti Arpakhsad wamogne heng kun-kunne teng ao tarabare epto no'opbare (438) wamogti, tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Arpakhsad elme Selah heng kun teng nhon epto wilindi (30) wamogti me si Eber mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber mangaro aogti me nenneap kelmabo nenneap mangkahiogti Selah wamogne heng kun-kunne teng ao tarabare epto selek (433) wamogti, tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Selah elme Eber heng kun teng nhon epto saekpare (34) wamogti me si Peleg mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg mangaro aogti me nenneap kelmabo nenneap mangkahiogti Eber wamogne heng kun-kunne teng ko'olom tarabare epto lambare (464) wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Eber elme Peleg wamogne heng kun teng nhon epto wilindi (30) wamogti me si Rehu mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rehu mangaro aogti me nenneap kelmabo nenneap mangkahiogti Peleg wamogne heng kun-kunne teng linbare epto lam tarabare (239) wamogti, tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Peleg elme Rehu heng kun teng nhon epto lambare (32) wamogti Serug mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug mangaro aogti me nenneap kelmabo nenneap mangkahiogti Rehu wamogne heng kun-kunne teng linbare epto lam tarabare (239) wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Rehu elme Serug heng kun teng nhon epto wilindi (30) wamogti me si Nahor mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor mangaro aogti me nenneap kelmabo nenneap mangkahiogti Serug wamogne heng kun-kunne teng linbare epto mekpare (230) wamogti, tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Serug elme Nahor heng kun teng nhon epto phende (29) wamogti me si Terah mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah mangaro aogti me nenneap kelmabo nenneap mangkahiogti Nahor wamogne heng kun-kunne teng lambare epto naualbare (148) wamogti tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Nahor elme Terah heng kun-kunne teng phende epto ao tarabare (70) wamogti me si Abramap, Nahorap, Haranap mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terah elmabo si tane wamla. Terahri me wilindi mangkahiogne Abram, Nahor, apna Haranap. Harandi Lot mangaro aogti nen elme si nhon Yiska mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran neneko ili kamag wamogpa elenge as Ur-Kasdima tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram nenekori elkel Sarai toro aogpa Nahor nenekori Haran elmangkel Milka toro aog. ");
INSERT INTO kkl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai neneko ibili talamogti me nhon mangaro an koma wamog. ");
INSERT INTO kkl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah nenekori elme Haran mangaro aogne Lotap, Abram elkel Saraiap, enero, “Ur-Kasdim so'o eneko laplobiagha as Kanaan pukap,” sembaek aghana as Kharan piekti wamek. ");
INSERT INTO kkl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Pina wamekti Terah mangkaekne heng kun teng saekbare eptopne ao tarabare (205) wamogti Terah mog so'o Kharan agha tebaog. ");
INSERT INTO kkl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wamekpa Nuni Allahri Abramag yubu lelamogti, “Anenge asap, ankaboap, anenge so'oap laplobiagha Nari mog so'o ambatkenenge nhonag pululam,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Andi mangarobari mangkahyikne tanekori mangkahyikne maikno talamikti, 'Nimi sisa nubunge wamle,' aro mikip nembahineba an si paliag wamleba an pere agha nimi maikno Nari walingena tatsinun. ");
INSERT INTO kkl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nimiri an yeplangkiikne Nari sin yepsinun. Nimiri an walangkiikne nari sin wabahinun. An pere agha nimi mog so'oag tala-tala wamikne ni walingena tatsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram mangkaekne heng kun taibuka taubuka ulamogha teng phende epto saek tarabare (75) wamogpa Nuni Allahri ambarogne sunsunum uro, “Kanaan so'oag pukap,” aro as Kharan laplobiagha palamekti elkel Saraiap, ilipsari me Lotap, eldi aruknap, sikininge sae agha wamoghap toro aekti palamek. ");
INSERT INTO kkl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Palameka Kanaan so'oag piekti Sikhem peramag kal nubu kal bari tamag More so'oag piek. Piekag aneko Kanaan nimi wamekag piek. ");
INSERT INTO kkl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Wamekpa Nuni Allah poneko Abram whingag lag taogti, “Mog so'o nene andi mangarobari mangaroba tatsinun,” aro ambarog. Ambarogpa Abram nenekori, “Nani Allah na whingag lag talne sembe mhong towalengkimnun,” aro kirik yangaro pibog. ");
INSERT INTO kkl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kirik yangaro pibogti, “Mag kwasag sip punun,” aro piogti heng walelingkirobag as Ai anabi as Betel heng purukul pirobag anabiag ae kalun ae soro wamog. Aneko wamogti, “Nuni Allahag mili molona lemnun,” aro mhong towalengenag nhon yangaro sobaog. ");
INSERT INTO kkl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Wameka nen lamba palamekti Negeb so'o mektopneag kulukul palamek. ");
INSERT INTO kkl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Negeb so'oag aneko pina wamekpa, kwaneng yo nubunge wamogpa, “Kwaneng erarukti Mesir pukap,” aro palamek. ");
INSERT INTO kkl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As Mesir peramag piekti elkel Sarai ambarelamogti, “An saren haing elel wamlamba ");
INSERT INTO kkl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mesir nimiri kembaghiikti, “Kelene Abram elkel wamla,” aro seneraghikti an lililangkiikti na opnukang. ");
INSERT INTO kkl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ane sembe andi, 'Na Abram ilipsa'ael wamna,' semenba sindi an sembe na opnukang kom. Sindi an sembe, 'Ilipsa'ael wamla,' aro nanag walia ulamukang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","“Walia ulamukang,” aro Sarai ambarogpa, Mesir piekpa Mesir nimiri kemelamekpa Sarai saren kemerop wamog. ");
INSERT INTO kkl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mesir nimi sembe yubu sia leropne Firaun wamog. Firaundi yubu eptopnang tanekori babe ibekti, “Saren walinge yal,” aro sikini ambarel piek. Ambarel piekti Sarai poa Firaundi aeag pelepto payaek. ");
INSERT INTO kkl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Payaekpa Abram sembe, “Sarai eldo wamla,” aro Firaundi walia Abramag ulamogti Firaun eldamnang arukna-ap, pham domba, kambing, sapiap, popsirop pham keledai, untaap pogto tatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Firaundi Abramdi kel tobogne sembe Nuni Allahri Firaundi ae lomap, ilipsaboap sembe nikna nubunge Allahri elag pibog. ");
INSERT INTO kkl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nikna nubunge pibogpa Firaundi Abram yobogti, “Andi sa'a sembe, 'Sarai nari kel,' sen koma orolenange ambatneom? ");
INSERT INTO kkl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Sa'a sembe, 'Naipsa'ael,' aro orolena lebomba nari tomno? An kel ane wamlaba toro agha pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Seogti, “Abram elkelap elenge aba ni toro agha as eneag agha lambaukangpa enero pabhululom,” aro Firaundi eldi arukna tanekoag arukahiog. ");
INSERT INTO kkl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram babe Lot babe sikinenge aba sikin kelabo toro agha Mesir so'oag agha Negeb sip palamek. ");
INSERT INTO kkl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Sin pina wamekti, pham Abramdinge maikno taogpa, wali-walia leng-leng aroba kirik emas perak wamogpa, tupne wamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Inaghag maba palamogti, Negeb so'oag agha Betel piog. Piogti Betelap Aiap anabiag samenag, “Allahag mhong towalengkanun,” aro kirik yangaro piboghag aneko wamogti, Nuni Allah omeklamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abramap Lotap palamdekne abeneko Lotdinge aruknaap, pham domba, kambing, sapiap, ae kalun aeap maikno wamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Wamogpa, abene li Kanaan nimiap Feris nimiap mog so'o aneag babe wamek. Undo wamekti, sindinge pham maikno wamogpa sindinge pham pia unag sunsunum kom wamog. Sin nikag wamnep kom saog wamog. Abramdi pham yae ua urop nimiap Lotdi pham yae ua urop nimiap ol dalamekpa ");
INSERT INTO kkl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram nenekori Lotag yubu lelamogti, “Anap nanap andi phamap, nari phamap, pia yae ua urop nangap tana sunsunum komdi nunna elkae-elkae. ");
INSERT INTO kkl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ane sembe mog so'o ane sabo wamlaba an babe mo tamenba na babe mo tanun. An waneng sip tanamen tanena na sirik sip tanun. An sirik sip tanamen tanena na waneng sip tanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Wene seogpa Lot whing kanebom agha tilamogpa Yordan sip Zoar ina agha mag lu wali wamogti samen Allahri Eden so'o walinge sumbaogne neneko saog wamogha tibog aog. Nene unu arekne nene anam Nuni Allahri Sodom nimiap Gomora nimiap opsin komag uarek. Mog so'o unu arekne nene samen Mesir mog so'oag sukuptopne walinge sa'a nia mangkina wamogne saog mog so'o wamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Undo wamogpa Lotti tibaogti, “Mag Yordan sip so'o pulu waliag na ngai tanun,” aro Abram laplobiagha heng walelingkirobag sip piogti wamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Kanaan so'oag wamogpa Lot mag Yordan pulu waliag wamogti ae soro Sodom peramag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","As Sodom wamek nimi tanekori Nuni Allah wail ibarelamekti yonge aghabog maikno ulamek. ");
INSERT INTO kkl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot neneko, “A'ero wamnunam,” aro piogpa Allah Nuni ponekori Abramag yubu lelamogti, “Sekamlamag anea mog so'o tibalulam, heng walelingkirobag sip, purukul pirobag sip, mag luag sip, kwasag sip wali uro tibogalulam. ");
INSERT INTO kkl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mog so'o tibalama ane, anap anmabo amik mangaro pululneap sembe ya'ag an saeag pimnun. ");
INSERT INTO kkl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nari andi mangaroba maikno nembahineba so'o lenglenga saog uro mog so'o to'opto pulul. Andi mangaroba taneko so'o lenglenga saog taleba nimi etneri babe so'o lenglenga a'elbanep kom saog wamleba andi mangaroba taneko babe a'elbhukang kom. ");
INSERT INTO kkl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nari mog so'o nene anag pimnundi wene sekmendi mog so'o kemeroa yabululam. Sabo wamla do, kom do?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Wene seogpa, Abram nenekori ae aneko kwerekaogti as Hebron peramag Mamre kal bari nubu kal wamoghag ae kalun ae sol piogti, Nuni Allah sembe mhong towalengenag sobaog. ");
INSERT INTO kkl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wamekti Babilonia nimi sikindo yubu sia leropne Amrafelap, Elasar nimi sikindo Ariokhap, Elam nimi sikindo Kedorlaomerap, Goyim nimi sikindo Tideal, sin tombare ma'aptaekpa ");
INSERT INTO kkl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodom nimi sikindo Beraap, Gomora nimi sikindo Birsyaap, Adma nimi sikindo Syinabap, Zeboim nimi sikindo Semeberap, mog so'o Bela si nhon Zoar nimi sikindoap, sin lambareap taekpa sin mal talamek. ");
INSERT INTO kkl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Mal tabaekne tam ane sembe sarikto lelamap. Nimi nubunge Kedorlaomer nenekori sin lambare abeneko saelbamsiog paghabog heng kun taibuka taubuka ulamogha aobare taog. Aobare taogpa heng kun nhonag sin lambare nangeneri, “El mombolag wamukap komdi sae lipsilul,” aro ma'aptaekti sikindo yabo yin saleropnangdi as Sidim puluag poloro wimbahiek. Poloro wimbahiekag aneko wene “Mag Teptop Mag” aro engerop. ");
INSERT INTO kkl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Heng kun phendepneag nimi nubunge Kedorlaomer neneko elkabo mal taropnang elag sip taeknangdi, “Mal tabaukap,” aro yaekti as Asyterot-Karnaim anekoag as Refaim nimi oro luknulamsiekti as Ham anekoa Zuzim nimi olamsiekti as Syawe-Kiryataim anekoa Imim nimi opsiekti ");
INSERT INTO kkl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hori nimi yim Edom tamag wamekne sarenelepto olamsiekti pai aldesag as El-Paran peramag pilbhiek. ");
INSERT INTO kkl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Pilbhiekti samoro yalamekti as En-Mispat yaek. Yaekti Amalek nimiringe so'o ni pin wa'iogti ni mali nembaogti Amori nimi as Hazezon-Tamar taneko wamekne babe olamsiekti oro luknu-luknu phiek. ");
INSERT INTO kkl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sin taneko oro luknu pahiekpa Sodom, Gomora, Adma, Zeboim, Bela nimi sikindoyabo lambare a'ero wamekne tanekori sikinipsabo yin saleropnang longkitsiekti ");
INSERT INTO kkl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam, Goyim, Babilonia, Elasar nimi sikindoyabo a'ero uropne tombare abenekoap mal talamek. ");
INSERT INTO kkl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","So'o Sidim puluag aneko pensal waronne saogne longoroba maikno longo-longo piamekpa Sodom Gomora nimi sikini yabo phendeap sikinipsabo yin saleropnangap logti mal talamekag laplobiagha merero palamekti sin yin saleropnang nimi maikno pensal waronne saogne longorobag aneko selengag eba timbaek. Timbaekpa nenne yimag sip piek. ");
INSERT INTO kkl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Piekpa nimi nubunang tombare abenekori Sodom Gomora nimiri sikiningeaba tenaba tanekoap haogha toro agha piek. ");
INSERT INTO kkl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram Ilipsae elme Lot neneko babe Sodom wamogpa nimi isa nimi tanekori sae kaupto pabalamsiekti elenge aba babe toro aek. ");
INSERT INTO kkl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Undo unu aekpa nimi nhon laniptaogne nenekori mal tabekne sembe Ibraninge Abramag ambarel piog. Abram neneko kal bari nubu kal Amoringe Mamre ponekori kal tamag wamog. Mamre poneko elkabo Eskolap Anerap Abrahamap ma'aptangto wamek. ");
INSERT INTO kkl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ilipsae elme Lot neneko sae kaupto poroa piang ana Abramdi ka'ebaogti eldi mabo mal yo uro taropnang teng ko'olombare eptopne saek tarabare (318) poloro wimbahiogti nimi tombare abeneko sarekerepto as Dan pilphiek. ");
INSERT INTO kkl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","As Dan aneko poloro wimbahiogti inipnag nimi isa nang eneko sarenelebom-nelebom agha olamsiekti as Damsyik phibom agha mag luag sip as Hoba peramag pilphiek. ");
INSERT INTO kkl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Undo unulamekti nia mangkina haogha tobeka tanekoap Lotap kelaboap nimi orange sae kaupto paphiekne tanekoap Abramdi taulpahiog. ");
INSERT INTO kkl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram nenekori Elam nimi sikindo Kedorlaomerap yubu sia leropnang elag sip taekneap taneko oro pabalamsiekti oro luknubahiekti samoro yalamekpa Sodom nimi sikindo poneko as Syawe puluag Abram whingag piog. Sodom nimi sikindo Abramap haiptarekagna nen si nhon “Yubu Sia Lerobag” engerop. ");
INSERT INTO kkl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salem nimi sikini nubunge Melkisedek Allah Mikip Phelektopne arukna wamogti, memne Allahap nimiap sembe anabiag uropne wamog. Wamogne ponekori babe kwaneng rotiap mag anggur magap Abram sembe poa piogti ");
INSERT INTO kkl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","wali aro kiplamogti, “Allah Mikip Phelektopne imap so'oap sumbaogne nenekori o'ona sembangkeldi yeplangkelul. ");
INSERT INTO kkl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Allah Mikip Phelektopne nenekori nimi isa nimi wamangne an saeag piboba El omeklamukap,” seog. Wene seogpa Abramdi nimiri saeagha talupto tobogne taneko palu sa'obare wimbaogti “Allah yeplamnelba, oro luknubahin,” aro Melkisedek palu nhon tarog. ");
INSERT INTO kkl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tarogpa Sodom nimi sikindo ponekori Abramag yubu lelamogti, “Naringe Kederlaomerdi toboa nen andi el sae agha talupto tobomne an talapmendi ot nimi naipsabo saelbahiomne nen samoro nandamne tatnululam,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Wene aro ambarogpa Abramdi yubu lelamogti, “Nuni Allah Mikip Phelektopne imap so'oap sumbaogne whingag ot sik uro lemnunne ane: ");
INSERT INTO kkl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Andi amik lelapmendi, 'Nia mangkina tatsiba Abram tupne taog,' semenag ane sembe andinge wet sop olog babe na olog babe toro anun kom. ");
INSERT INTO kkl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ot Naipsabori teongne aghabog tatkenep kom saog wamla. Nangkabo Aner, Eskol, Mamre nanag sip taongne sin saeag taongeog toro aukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Wamogpa Abram nenekori haing uamna kwelekamna senenag agha uro yabinepne kemelamogpa Nuni Allahri Abramag yubu lelamogti, “Abram, log sembaheng kom! 'Malinge anag taleag,' aro Nari an piangkeneri kamna nubunge tatkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Wene seogpa Abramdi yubu lelamogti, “Nani Allah sa'a aba agha Andi na tatnululam, Nani na me nhon tatneom komba na me koma tebaneba naringe sae agha nari arukna Eliezer Damsyikne ponekoag talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Wene seogpa Allahri yubu lelamogti, “Nimi etneag babe andinge sae agha elag talul kom. Ot andi me taptopneag andinge sae agha elag talul,” seogti ");
INSERT INTO kkl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Abram enero asag poa lambaogti ambarelamogti, “Imag tiwalengkipmendi imberea tiwalengkiplulam! Imberea a'ilbanep kom wamla saog uro andi mangarobari mangkahyikne taneko maikno taukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Allahri lebogne nene sembe Abramdi, “Ot sik uro lepla,” aro seneraglamogpa, Nuni Allahri Abramag wana piamog. ");
INSERT INTO kkl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kwelekaogpa, nen Abramag Allahri yubu lelamogti, “Na Nani Allah wamna. 'So'o ane an ngai talulam,' aro Nari Ur-Kasdim so'oag agha enero payaghai,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Wene seogpa Abramdi Allahag hailamogti, “Nani Allah nubunge, Andi, 'Mog so'o ane tatkinun,' selam aghana, kekneba uamenba 'Sik uro lepla,' sembanun,” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Haibaogpa Nuni Allahri, “Pham sapi kelne nhon, kambing kelne nhon, domba yemne nhon heng kun wilindi ubu piamangneap winang mem winang ologne nhon, nubunge nhon tarel anululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","“Tarel anululam,” seogpa payaogti pham taneko usoghag agha amuag serelingkiogti lelero palilamogti winang abeneko ningki oro pibog. ");
INSERT INTO kkl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pibogti wamogpa winang pham kalerop winang yingkina tukap aro ulamekpa Abramdi yaglamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Heng purukanep peram ulamogpa Abram kwhaingti mangkhauk mabog abeneko inipna tuka'ag aropne logne niknilaog. ");
INSERT INTO kkl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tuka'ag seog abeneko Allah yubu lelamogti, “El uro wamlulam, andi mangarobari mangkahyikne taneko heng kun teng naual tarabare ane ni wamikpa nimiri asag agha sekelanan nimi aro arukna maikno aruklamsiikti olamsukang. ");
INSERT INTO kkl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","An anisag yabo arukna nembamsiikti olamsiik nimi taneko sindi ulamikne sembe Nari lumbahineba anisag yabo lanalamikti nia mangkina poro agha lambaukang. ");
INSERT INTO kkl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","An aghabogna anenge nimi sisa likna pimenba, hong kul wangkeleba, wana aingniro tebamenba, so'oag sikkukang. ");
INSERT INTO kkl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Aghana nimi sisa andinge nimi likna tomne neneko samoro ane yaukang. Amori nimi mog so'o ngai nimi yonge aghabog ulamangne Na wana sesog wamnel kom. Wana sesog uanele sum lumbanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Heng purukaogti imbaogpa Abramdi kemelamogpa auk una-ap whea-ap pham kalero phendeag piroba anabiag auk una mhong yarut alamogpa whea auk pog tagtag alamogpa yabalamog. ");
INSERT INTO kkl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","21","Undo unulamog abeneko Allahri sumene Abramag salag lelamogti, “Andi mabo mangaroba-ag mog so'o nene anag Mesira yalamlari mag nubunge Efrat neneag. Keni nimiri so'oap, Kenas nimiri so'oap, Kadmon nimiri so'oap, Het nimiri so'oap, Feris nimiri so'oap, Rafaim nimiri so'oap, Amori nimiri so'oap, Kanaan nimiri so'oap, Girgasi nimiri so'oap, Yebus nimiri so'oap andi mangaroba-ag tatsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram elkel Sarai neneko me mangaroan koma wamog. Wamekti Mesir kel nhon si Hagar el arukna wamog. ");
INSERT INTO kkl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Wamekti Sarai nenekori Abramag ambarelamogti, “Nuni Allahri nanag, 'Me mangaro alul kom,' senelamlaba an nari arukna aneap maptumunba eldi me nhon mangkatnelul senelamna,” aro ambarogpa Abramdi, “Wali leplam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wene seogpa Sarai nenekori, “Na arukna toro alulam,” aro Abram tarog. Tarog li eneko Abram Kanaan wamog paghabog heng kun taibuka taubuka ulamogha heng kun sa'obare taog. ");
INSERT INTO kkl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram neneko Hagarap maptekpa me monag wamogpa, “Me monag wamnel,” aro Hagar el taogti Hagar neneko omektangto, nongkotno aro Sarai mombolag nenelamog. ");
INSERT INTO kkl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mombolag nenelamogpa Sarai nenekori Abramag yubu lelamogti, “Nari arukna Hagar neneko nari tatkenoba me monag taonge neneko el taori na mombolag nenelamnel. Andi uaomne neneri na mali nenelamnel. Ane sembe tam nun phendeag wamlange nene Nuni Allahri og tam karebalul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Wene seogpa Abramdi, “El neneko an arukna wamlaba an saeag wamla. Andi sembamlamne wali elag ualulam,” aro ambarogpa Sarai nenekori Hagar nenekoag yonge maikno ulamogpa logti lambaog. ");
INSERT INTO kkl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Lambaogti palamogti mog so'o Syur pirobag aldesag mag lu pirobag piogti wamogpa Nuni Allahri Ilipsae arukna malaikat nhon poghogpa Hagarag yaogti ");
INSERT INTO kkl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","yubu lelamogti, “Sarai arukna Hagar, an talaba yalamdi, 'Tala punun,' aro ulamlam?” aro haibaogpa, Hagar nenekori, “Na logti Sarai neneko laploa yalamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Wene seogpa Allah arukna anekori, “Samoro elag pimendi wamlulam, wali an eldi mombolag nenelangkilul,” aro wene seogti nen yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","“Nari an mikip nembahineba andi mangarobari mangkahyikne taneko maikno taikpa nimiri a'ilbahinep kom wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Olog wapmena me nengabo me mangaro alulam. Mangaro amendi, 'Na mali uro wamnaba Nani Allahri ka'ebaneori me nengabo me tatnel,' aro me si Ismael engkalulam. ");
INSERT INTO kkl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","An anme neneko pham pai pham saog uro haing whi wamleri elkaboap ni aisa neneptangto wamikpa eldi, 'Nimi opsinun,' aro ulamleba sindi babe, 'El obukap,' aro ulamukang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ambarogpa Hagar neneko wana-ag agha hailtalamogti, “Allah kemelamnelne neneko sumene imna, welaro amik el si engkanun?” aro “El-roi” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ane sembe mag so'o waliropne Kades anabi Bered anabiag mag so'o waliropne neneko sina, “Beer-lahai-roi,” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nen Saraiag sambaogti, olog wamogha Hagar nenekori me nengabo me mangaroaogpa Ili Abram ponekori me si Ismael engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Me si Ismael engkaog li eneko Abram heng kun mangaro yabiogne teng wilindi eptopne lambare (86) wamog. ");
INSERT INTO kkl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram mangaptaogne heng kun taibuka taubuka ulamogha teng wilindi eptopne sa'o tarabare (99) wamogpa, Nuni Allah Abram el whingag lag taogti yubu lelamogti, “Na Na'uni Allah Imap So'oap Saelbamnange. Andi Nari yubuog ka'elapmendi, 'Uaho,' senelamnangeog ulamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nari anag salag palilamnari, 'Anmabo anisag yabo maikno taukang,' aro salag palilamna,” seogpa, ");
INSERT INTO kkl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram neneko whing tahip yabu sanukto pulingkiogpa Allahri yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Nari anag salag lelamnange nene: Nimi sisa nubunge mog so'o a'ero-a'ero wamik nimi sikinisang an talulam. Ane sembe an si samenne Abram alangkeapne nene kom wamleba wene wendog si, 'Abraham wamlulam,' aro engelangkeken. ");
INSERT INTO kkl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nari anag nimi likna pimneba, andi mangarobari mangkahyikne taneko maikno taikti, as nubu tangto a'ero-a'ero wamikti yubu a'ero-a'ero lelamukang. Sin taneko anabiag agha yubu sia leropnang raja babe seklamukang. ");
INSERT INTO kkl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nari anap anmabo amikneap, 'Na Na'uni Allah Na wamnun,' aro salag palilamnange nene ya'ag wamlebog ekon tan koma wamlulom. ");
INSERT INTO kkl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","So'o Kanaan ane an nimi sekelanan nang saog uro wamlam aghana, an anisag yabo sembe so'o ane 'Ngai taukang,' aro tatsineri, sin sembe Sikini Allah Na wamnun,” aro lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","“Nari salag palilamnange nene anap, anmaboap, anmabo amikneap sae mikip uro saelbamlulom.” ");
INSERT INTO kkl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Allahri lelamogti, “Nari salag palilamnange nene ekon tan koma el uro wamlulom aro anap, anmaboap nengabo niap nengabo kon karebel talamlulom. ");
INSERT INTO kkl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Me nengabo me mangalamsimunne ik lin sum talamle tanena kon kareplamsululom. Andamne, arukna anenge asag agha mangap taikneap, as yoghag agha kamna kapto tolamsimunneap, me nengabo me ni kon kareplamsululom. Nari anag salag palilamnange nene ya'ag wamlulne sembe el uro wamlulomba, kon karepnange nene kekneba a'unag wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kon kareptop kom nimi taneko, 'Allahri lebogne irikna phibaek,' aro a'un, Na, Namabo anabiag agha iksibitsululom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ambarogti nen yubu lelamogti, “An ankel Sarai alamangne neneko si samenne lipsimendi si wendogne Sara engkalulam. ");
INSERT INTO kkl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Elag walinge pimneri Nari el mikip nembaneba me nengabo me mangkatkilul. As nubu tangto a'ero-a'ero wamikne sikinin el wamlul. Eldi mangaroba mangarobari mangkahyikne anabiag nimi nubunang raja yubu lennang babe seklamukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Wene seogpa Abraham neneko whing tahip yabu sanukto pulingkina seneraglamogti, “Nimi ya'ag sabal tangto heng kun teng wilindi eptopne supna tarabare undo pinneri me mangaro anep te? Sara neneko babe ya'ag sabal taori heng kun teng wilindi eptopne supnabare tao. Huro me mangkalulne sembe?” aro wana-ag ogsolamog. ");
INSERT INTO kkl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Wene senero Allahag yubu lelamogti, “Andi leplamne nene, 'Ot Ismael aghabog Abraham lunumna wamla,' aro ulamlulam,” seogpa ");
INSERT INTO kkl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Allahrina, “Wene sembaheng kom! Ankel Sara nenekori me nengabo me mangkatkeleba si Ishak engkalulam. Nari anag salag lelamnange nene sunsunum uro anme Ishakti mangkahilenge babe Nariog saelbamsineba wamukang. ");
INSERT INTO kkl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismael sembe babe andi molbalamne nene sunsunum uro ulamnun. Nari el mikip nembaneba eldi mangaroba mangarobari mangkahyikne maikno taukang. Ismael elmabo nengabo aobare mangkahileba yubu lennang wamukang. Elag agha nimi likto pilenge Nari as nubu nene-nene pihinun. ");
INSERT INTO kkl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aghana, heng kun amikne nonoag andi kel Sara me nengabo me mangatkilul. 'Sara me mangatkilulne Ishak sembe salag anag pipsinge neneko el saeag talul,' aro nen salag palilamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wene aro ni ambarogti Abraham laplobiagha piog. ");
INSERT INTO kkl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Laplobiagha piogpa sumeneko sum Abraham nenekori Allahri ambarogne sunsunum uro elme Ismaelap eldi aeag agha kaubuni mangkahiekneap kaubuni agha kamna kapto topsiogneap sumeneko sum ni kon karebahiog. ");
INSERT INTO kkl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Abraham ya'ag sabal taogti heng kun teng wilindi eptopne sa'o tarabare (99) wamogpa Ismael heng kun naualbare wamog heng kunag agha sin phende babe kareplamsiekti ae enekoag kaubuni wamekneap ni kon karebahiek. ");
INSERT INTO kkl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Wameka Abraham neneko kal bari Mamre ponekori nubu kal tamag peramag wamogpa, Nuni Allah el whingag lag taog. Ae sumeneko sum ae siro heng pobori ae tomae ina siramag pukamogti ");
INSERT INTO kkl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","whing ebom agha kemelamsiogpa nimi wilindi el whingag sekamek. Sekamekpa tibahiogti Abraham neneko sekom agha sinag merero piogti yabu sanukto sin whingag pulingkina, ");
INSERT INTO kkl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Nani yabo, a'undi na sembe o'ona sembamnelomdi yalomba a'epihibom agha peneheng kom. Na a'un arukna wamnari ");
INSERT INTO kkl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","mag tebarel ahineba yan a'elbamundi kal tamag anea tektek eplulom. ");
INSERT INTO kkl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","A'un tektek eplapmunba na kwaneng roti toarel ahinenge timundi mikip tahileba pululom. Nani yabo, nanag yalom ana tektek epna koma pululom kom,” seogpa sindina, “Wah naba nangkae, andi leplamne nene ualulam,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Wene seekpa Abraham neneko elamag-elemag aeag wa'iogti Sara ambarelamogti, “Kwaneng wilindinang maiknoro tukanga sembe sae etparero topmendi winiro taplulam,” aro ambarogti ");
INSERT INTO kkl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","merero pham mo'orobag piogti pham sapi me walinge mesa yagne nhon tobogti, “Elemag oro yobalulam,” aro eldi arukna-ag tarel aogpa elem-elem yobaog. ");
INSERT INTO kkl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Elem-elem yobaogpa pham sop yobaogne taneko nimi yaek nimi tanekoag pham sop yorobap kwaneng rotiap pham mum mag lolteropneap pham mum agha likto teropneap tarebihiogpa telamekpa el kal eneko tamag sekamog. ");
INSERT INTO kkl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sekamogpa sindi yubu lelamekti, “An kel Sara tala wamla?” aro haibaekpa, “Aeag wamla,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ambatsiogpa sin taneko nhondi yubu lelamogti, “Heng kun nonoag an kel Sara nenekori me mangaro aleri wamleag na samoro anag yanun,” seog. Wene alamdek abeneko Sara neneko ina siram mombolag sip sin wailag wamogti ka'eamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abene wamdek li Abrahamap Saraap ya'ag sabal wamdekti Sara babe eneng wal yalamog kom. ");
INSERT INTO kkl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Undo wamdekti Sara nenekori, “Na na'angeap ya'ag sabal tanomo, na kon babe halo seneo aghana huro na'angeap mapnunamne sembe?” aro wanag ogsolamog. ");
INSERT INTO kkl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ogsolamogpa Nuni Allahri Abrahamag hailamogti, “Sa'a sembe Sara wana-ag agha seneraglamlari, 'Na sabal tanori huro me mangkanun?' aro ogsobal? ");
INSERT INTO kkl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","A'uni Allahri uanep komne nhon wamla, te? Nari lemna saog uro heng kun nonoag an kel Sara nenekori me nengabo me mangaro aleba wamtumunag samoro yanun,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Wene aro ambarogpa Sara nenekori logti, “Ogsoban kom,” aro keneno seog. Keneno seogpa Nuni Allahri, “Andi sik uro ogsobalam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Wene aro nimi wilindi abeneko nimi nhondi ambarogpa sin wilindi abeneko lambaekti palamekpa Abrahamdi, “Ina-ag pil pihinun,” aro nhon palamek. Palamekti as Sodom tirobag piekti ");
INSERT INTO kkl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nani Allahri eldi wana-ag agha seneraglamogti, “Nari, 'Uanun,' senenne Abraham whingag yubu kom tanun kom. ");
INSERT INTO kkl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Eldi mangkahirobari mangkahyikne maikno taikti, as nubu tangto wamukang. El pere agha Nari nimi sisa ni tala-tala wamikne walingena tatsinun. ");
INSERT INTO kkl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","'Eldi maboap sindi mangkahyikneap ambahileba Na yubuog ka'elamikti, sikneog ul palamukang. Sikneog ul palamukang aghana tam waelbaelba, sik uro kareplamukang,' aro Abrahamog Nari wepsi. Sindi walia aghabog ul palamik tanena Nari salag el neneag pimnonge saog uro ul palamukang,” sembaogti ");
INSERT INTO kkl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Abrahamag yubu lelamogti, “Sodom Gomora nimiri Na wail ibarelamneangdi yonge aghabog ulamangpa nimi orangeri yubu yanga alamangne Nari ka'elamsin. ");
INSERT INTO kkl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ane sembe, 'Ot sik uro yonge aghabog ulamang to?' aropne agha kemelingkhinun,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ambarogpa nimi yaek nimi abeneko phende Sodom sip pirekpa Nuni Allah aghabog Abrahamap wamdek. ");
INSERT INTO kkl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Wamdekti Abraham neneko Nuni Allah peramag piogti ambarelamogti, “Nani, Andi, 'Nimi wali aghabog ulamangneap malia ulamangneap ma'aro opsunun,' senelamlam? ");
INSERT INTO kkl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nimi teng phende malia urop komne wamik tanena as nene Andi mali nembanep saog, te? 'Sin tane yo uro wamik,' aro Sodom nimiri malia ulamangne wailag nenelapmendi mali nembahilulam kom, te? ");
INSERT INTO kkl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nimi walia ulamangneap malia ulamangneap ma'aro opsululam kom te? Malia uropnangdi ulamangne agha nimi niag taleag. Nani, Andi 'uanun' sembalamne ualulam kom. Andi nimi so'oag wamangne ni sinag tam ua ulamlaba o'olamlamne anekona, sin nimi taneag babe ot sik uro karebalulam, te!” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Wene seogpa Nuni Allahri, “As Sodom ane nimi walia ulamangne teng phende wamikpa ipsine tanena, 'Sinne abene el uro wamik,' aro Sodom nimiri malia ulamangne wailag nenelamneri mali nembahinun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Seogpa Abraham nenekori nen yubu lelamogti, “Nani, na nimi so'oagne so'o lenglenga saog uro wamnari Anag na yubu lemnep kom saog wamla aghana na yubu paliag uro lemnari wene lemnunne sembe babe yareag sembane. ");
INSERT INTO kkl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nimi walia uropne teng phende abeneko lambare orog wamikpa teng nhon eptopne no'op tarabare wamik tanena lambare abeneko sembe as ni ane opsululam te?” seogpa Nuni Allah ponekori, “Nimi walia urop nimi teng nhon eptopne no'op tarabare wamikpa ipsine tanena lambare abeneko sembe opsunun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Wene seogpa Abraham nenekori nen yubu lelamogti, “Nimi walia uropne teng nhon eptopne naualbare wamik tanena huro senelamlam?” aro haibaogpa Nuni Allahri, “Nimi teng nhon eptopne naualbare wali wamik aro, 'Uanun,' sembanenge lipsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Wene seogpa nen Abrahamdi, “Nani, nen nhon lemnunne sembe wabaneheng kom! Nimi walia uropne nimi teng nhon eptopne wilindi wamik tanena wela ualulam?” seogpa Nuni Allahri, “Sin teng nhon eptopne wilindiog wamikpa ipsine tanena nari, 'Uanun,' sembanena uanun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Wene seogpa Abrahamdi nen ambarelamogti, “Nani, Anag yubu lemnep kom saog wamla aghana yubu pam keyagman menanga lemnari nen lemnunne sembe yo sembaneheng kom. Nimi walia uropne lin tarabareog wamik tanena huro ualulam?” seogpa Nuni Allahri, “Nimi ot lin tarabareog wamikpa ipsine tanena as ane orog nembanun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Wene seogpa nen Abrahamdi ambarelamogti, “Nani, wana mali sembaheng kom! Ot nhon babe lemnun. Ot nimi sa'obareog wamik tanena as ane mali nembalulam te?” aro ambarogpa Nuni Allahri, “Ot nimi sa'obareog wamikpa ipsine tanena as ane orog nembanun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yubu komopto leptekti Allah babe piogpa Abraham elenge aeag piog. ");
INSERT INTO kkl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Allah Ilipsabo malaikat phende samenag pirekne abeneko inipnag as Sodom pirek. Palamdekpa Lot neneko leka as Sodom kanero toropne ina siramag pukamogti, tilamsiogpa, nimi phende abeneko yalamdeka tibogahiogti, sekom agha sin whingag piogti, yabu sanukto so'oag pulingkiogti, ");
INSERT INTO kkl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Sin kiplamsiogti, “Nani yabo, naringe aeag piberi, yan mag aelbarumunba, nari aeag nhon mabukap. Mabeberi ambhum 'Pununam,' sembaromag pururom,” aro ambatsiog. Wene aro ambatsiogpa sindi, “Nangkae, wali leplam aghana nu asag tane mamnunam,” serek. ");
INSERT INTO kkl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Wene serekpa Lot nenekori yubu mikip uro pukap aro ambatsiogpa, nhon eldi aeag piek. Aeag piekti Lot nenekori kwaneng yobarelamsiogti, roti walerop komne babe tabatsiogpa telamdek. ");
INSERT INTO kkl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Terekti abeneko anam mamna komag kabuni nongnangap kabuniap meap ni longoro yaekti ae neneko kanelamek. ");
INSERT INTO kkl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ae eneko kanero wamekti Lotag yubu lelamekti, “Inipnag kaubuni anag yarangne abeneko tala wamdang? Poa la'imbarelahi. Nuri labaghaukapti,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Wene alamekpa Lot neneko lambaogti ina serekna paiag siba sobaogti ");
INSERT INTO kkl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Sodom nimiag yubu lelamogti, “Nangkabo, a'undi yonge ualulom kom!” aro ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","“Namangkelabo phende nimiap yabirop komne wamdang. Ane sembe tatsineba a'undi, 'Uaukap,' sembalomne ualulom aghana, nimi phende abenekoog nari aeag yarangba, sae lopsinep komdi, a'undi yoaba sinag ualulom kom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Wene aro ambatsiogpa, Sodom nimi tanekori Lot ponekoag lelamekti, “An nimi sekelananne wamlam ane sembe welaro 'O'obatsinun,' senelamlam? An pi! Pimen kom tanena nimi abeneko olog uro olamsiberi an agha maiknoro opkukap,” aro ambarelamekti, Lot wepto palamekti, “Ina serekna kupto wa'ukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Undo unulamekpa nimi phende abenekori sae lanaro Lot neneko kiliro tobongkarekti, ina serekna aeag agha serekarek. ");
INSERT INTO kkl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Serekarekti Sodom nimi asag wamek nimi taneko ni haing ulopsirekpa, “Ina siram aneko ala wamla?” aro elamekti, ibek kom. ");
INSERT INTO kkl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Undo unulamekpa nimi phende abenekori Lot ambarelamdekti, “Sodom nimi tane malia aghabog ulamangpa, nimi orangeri mog so'o ene sembe lelamangne Nuni Allah ka'ebaori, 'Sodom nimi mali nembahilulom,' aro nu pogsio. Ane sembe an anmabo kelmeap an yamal yaboap ankabo yogne as eneag wamang tanena, poa lambahilulam,” aro ambatek. ");
INSERT INTO kkl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Wene aro ambatekpa, Lot neneko elmangkelabo phende abeneko topsurukang senen nang abenekoag ambarelamsiogti, “Na yamal yabo, Nuni Allahri as nene mali nembalulba elemag-elemag lambaukapti yahut!” aro ambatsiogpa, kabuni abenekori, “Leldepna yubu lelamla,” aro ka'ebarek kom. ");
INSERT INTO kkl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ka'ebarek komba mabekti, lukunap malaikat phende abenekori yubu mikip uro Lot ambarelamdekti, “As ane mali talamleri opsileba, tebamunag an kelap anmangkel yaboap elemag-elemag as eneag agha lambalulom,” aro ambatek. ");
INSERT INTO kkl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Wene aro ambatekpa, Lot nenekori wanag agha, “Pinun to, kom to?” aro seneragto nemen ulamogpa, Nuni Allahri el sembe o'ona aro “Yepnun,” sembaogpa, malaikat phende abenekori Lot elkelap elmangkelabo phende abenekoap sae kiliro as enekoag agha poa lambahiek. ");
INSERT INTO kkl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","As Sodom anekoag agha poa lambahirekti, palamekti, malaikat abeneko nhondi, “A'un tebamunagti elemag-elemag palapmundi, puluag tektek epto koma, wailag sip tisamoro koma yimag pululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Wene aro ambatsiogpa, Lot nenekori, “Nani, Andi na o'ona sembamnelamdi, tebaleag aro taulbanelamba, yim neneko we maiknori na anam pin komag as eneag ualulne nenekori na omneleba tebaneag. ");
INSERT INTO kkl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","As ologne peramag wamlange nene tibogae, nu kamag wamukapti, 'As eneag pululom,' aro wene aro ambatsi,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wene aro molbaogpa malaikat anekori, “Hae, nangkae, andi wali leplamba, as ologne nene nari mali nembanun komdi ");
INSERT INTO kkl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","elemag-elemag pululom! A'un as enekoag pin komag nari sa'a-sa'a uanun kom,” seog. Lot nenekori, “As ologne nene tibogae,” seogne sembe as eneko si Zoar engerop taog. ");
INSERT INTO kkl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Heng tingilamogpa, Lot as Zoar wa'iog. ");
INSERT INTO kkl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Wa'iogpa Nuni Allahri as Sodomap Gomora-ap abeneko pere auk poghap song malia-ap pelengel aogpa, ");
INSERT INTO kkl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","as pulu phende abeneko kabuni kelabo as ologne nubunge olamsiogti, pongoroba mog so'o mali nembaog. ");
INSERT INTO kkl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Olamsiog abeneko Lot elkel neneko wailag sip samoro tilamogpa kikipto ua kirik sektopne saog taog. ");
INSERT INTO kkl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Lukunapne Abrahamdi, “Nani Allahag ambhum yubu lemnoag punun,” aro piogti, ");
INSERT INTO kkl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","as Sodom Gomora puluag Yordan sip tilamogpa, nimi awe auk tolongoropba mhong polesog aropne nene saog ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Allahri as Mag Yordan peramag as Lot wamoghag aneko mali nenelamogti, Abraham sembe ekon taog kom. Ekon taog komdi, Lot sembe Abraham ilipsae Haran elme wamlaba, tebaleag aro seneraghogti sae kiliro tobog. ");
INSERT INTO kkl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Undo unuaogpa, wamekti, Lot nenekori, “As Zoar wamneba tebaneag,” aro log sembe lambaogti, elmangkelabo phende abenekoap yim kirik arameag pina wamek. ");
INSERT INTO kkl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wamekti ik nhon sum elmangkel yandonge nenekori ilipsa'elag ambarelamogti, “Nuni sabal tao anekona nai eneng lununne orogti, nu babe nengabo toltonne orogti, ");
INSERT INTO kkl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","nuni mag yonge tebatnemeba, wana loba tanaleba, elap mabebeba, eldi likna lag taukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Wene seogti, inipna sumeneko sikini mag yonge tebatekpa, teogti malamogpa elmangkel yandonge neneko iliap maptek. Maptekpa ili nenekori, “Welaro uan,” aro ekon uro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wamekti lukunapne neneko elmangkel yandonge nenekori ilipsa'elag ambarelamogti, “Inipnag Naniap na mamna anekona sumene nen mag yonge tebatnemeba, malamle abeneko naiap maplulam. Mapmenba nuni sembe nundi mangkanemeba, nuni sembe nimi likna wamlul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ambarog aneko imbaogpa, sikini Lot neneko mag yonge tebatekpa, teogti malamogpa, elmangkel amikne neneko iliap maptek. Lot neneko ya'ag ekondi ekon uro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Elmangkelabo phende abeneko iliap maptekpa, sin phende me monag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Wamekti elmangkel yandonge nenekori me nengabo me mangaro aogti, si Moab engkaog. El neneko Moab nimi wene wamangne sikinisa taog. ");
INSERT INTO kkl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Elmangkel amikne nenekori babe me nengabo me mangaro aogti, si Ben-Ami engkaog. El neneko Amon nimi sisa sikini taog. ");
INSERT INTO kkl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham neneko as Mamrea lanaro palamogti, Negeb so'oag as Kadesh anabi mog so'o Syur anabiag palamog abeneko pere as Gerar nimi sekelingkiropne saog uro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","As Gerar wamogti Abrahamdi elkel sembe, “Ane nari naipsa'el,” seogpa nimi nubunge Gerar wamogne Abimelekti, “Sara tol pimundi, nanag payalulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Wene seog sumeneko inipnag lenda roman Allahri Abimelekhag yubu lelamogti, “Nari lelamna an tebanualam, kelabo andi toplamne neneko ela'ange wamla,” alamog. ");
INSERT INTO kkl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Wene alamogpa, Abimelekh Saraap mamdek komdi lelamogti, “Nani, Andi nimi as malia uan komne opsinep te?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Wene seogti nen lelamogti, “Eldamne Abrahamdi agha lelamori, 'El naipsa'el,' seo. Apna eldangkel Sarari lelamori, 'Abrahamna, Naro,' seo. Ane sembe nene uanonge nene sindam nimiri leptongneag agha wana wali uro uano, nari sae loba uro uano kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Undo wene seogti, lenda mamogpa, Allahri yubu lelamogti, “Nene uaomne nene sindam nimiri leptongag agha wana wali uro uaom. Ane sembe nari anag ulamnonge andi Nanag sembenga pipmenag aro 'Kel eleneag saelbaleag,' senelamnoa wene ambarelangken”, seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Seogti, “Ane sembe wene kelene ela'ange saeag nembalulam. Ela'ange Na pam silimu tiptopne wamla ane sembe, elkel samoro tatmenba, eldi an sembe Nanag molbatkelenge pere agha an wali nembaghelul. Ela'ange saeag nembamen kom tanena, anap andi asag nimi wamangneap tebalulom,” aro Allahri yubu lelamogha lenda mabog. ");
INSERT INTO kkl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Lenda undo mabogti, lukunap abeneko nimi nubunge Abimelekh nenekori nimi el umag wamekti, awe welamekne taneko ambatsiogpa, ka'ebaekti log sene-sene palamek. ");
INSERT INTO kkl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Undo unuaogti Abraham yobogti hailamogti, “Sa'a sembe tamna nunag uaom? Nari anag tam malia uanoba, andi nanag tamna nene uaomba, nanap nari mog so'o nimi wamangneap loba nembahisom te? Andi nanag tam uanep komne uaom,” aro wene seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Wene seogti, nen lelamogti, “Tamna sa'a seneraghomdi uaom?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Wene aro haibaogpa, Abrahamdi samoro Abimelekhag lelamogti, “Nari seneragnonge, 'Tane Allahag wana seneragtop kom nimi wamang. Nari kelene toro habe senen nimiri omnikag,' aro uano,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Wene seogti nen lelamogti, “Elna sik naipsa'el aghana nuri nai ot nhon bana, elna ka'in nhondinge agha toptanomo,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Seogti, “Allahri, 'Lambalulam' seoba, naniri aeag agha lanalamnomori nari kelag lemnongena, 'Nanag seneraglamnemen tanena as tala yabalamneme nimiag, “Elna naro,” alamlulam,' seno,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Wene seogpa Abimelekhti Sara eldamne Abrahamag nembaogti, pham dombaap sapiap tarog. Tarogti nen eldi arukna nengaboap kelaboap tarog. ");
INSERT INTO kkl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Tarogti Abimelekhti Abrahamag yubu sia lelamogti, “Mog so'o ane naringe, andi, 'Wamnun,' sembamenag wamlulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelekhti Saraag yubu lelamogti, “Andoag kamna kal ma'al maiknoro tarelamnange nene na sae loba pinori kamna nimi whingag agha tarelamna. 'An mali uaom kom,' aro tatna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelekhti Abrahamdi kel Sara tobogpa, Allahri Abimelekhti kelaboap eldi aruknaap ibili nene-nene phiog. Allahri ibili nene-nene phiog aneko, sumeneko sum Abrahamdi Allahag moloro yubu lebogpa, Allahri Abimelekh whero eldi kelabo babe whebhaiogpa me mangal tolamek. ");
INSERT INTO kkl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Wamekti Nuni Allahri samenag lebogne sembe o'ona aro Sara sembe seneraglamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Seneraglamogpa Abraham neneko sabal taog aghana, Allahri seneropneag agha elkel Sara me monag taogpa Allahri, “Sumene sum mangaro alul,” seogne sunsunum taog sumeneko me nengabo me mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mangaro aogpa, Abraham nenekori me si Ishak engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Engkaogti Ishak neneko mangaro aogne ik lin sum taogpa, Allahri lebogne sunsunum uro Abrahamdi kon karebaog. ");
INSERT INTO kkl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham neneko mangkaekne heng kun taibuka taubuka ulamogha teng wilindi eptopne supna tarabare (100) taogpa, Ishak mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Mangaro aogti Sara nenekori yubu lelamogti, “Allahri nanag ualne sembe ogsolamna. Nimi yog nimiri ka'ebahikti nari ogsolamna saog uro sindi babe ogsobaukang,” alamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Nen yubu nhon lelamogti, “Nari anam me mangaro an komag nimi etneri nari na'ange ambarelamsengdi, 'An andi keldi anmabo maum timbahilul,' aro ambatnep kom. Na'ange ya'ag sabal tao aghana nari me mangkatna,” alamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Wamekti Sara elme Ishak nubu talamogti, ilin maum lipsiog sum eneko Abrahamdi sani nubunge yobaog. ");
INSERT INTO kkl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Yobaogpa Hagar nenekori Abraham mangkarogne Ismael neneko yubu nepto ogsolamog. Yubu nepto ogsolamogha kembaogti, ");
INSERT INTO kkl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara nenekori Abrahamag ambarelamogti, “An tebamenba, andinge na name Ishakap, an arukna elmeap sin ngai tarikag, an arukna ilin elme yag lambahilulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","“Yag lambahilulam,” seogpa Abraham nenekori, “Ismael babe nari me aghana sa'ambe lepla?” aro wana mali taog. ");
INSERT INTO kkl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Wana mali taogpa Allahri Abrahamag yubu lelamogti, “An arukna Hagar elmeap sembe wana ikin sembaheng kom. Nari, 'An anisag yabo maikno taukang,' aro salag pimnonge neneko Ishak siba uro pilul ana Sarari leplange nene saog uro ualulam. ");
INSERT INTO kkl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hagar elme babe an mangkatkeonge wamla aro el babe mikip nembaneba, eldi mangaroba mangarobari mangkahyikne maikno taikpa, as nubu nene-nene phinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wene seogpa mabeka lukun Abraham nenekori kwanengap mag ma'i terobap Hagarag pobirogti, “Anmeap palamturom,” aro ambatsiog. Ambatsiogpa Hagar neneko pirekti, Bersyeba aldesag “Tala pinun,” aro wana eka'uk alamogpa, yang pang ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yang pang ulamogpa, mag pabiogne abeneko orog taogpa Hagar nenekori elme yoaba nusamag pilobogti, ");
INSERT INTO kkl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","“Name si taraplamlea imnun kom,” aro olog weag pina pukamogti engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Me Ismael nenekori mag yori hain taknep ulamogti, “Na mag,” alamogha Allahri ka'ebaogpa, Allah ilipsae arukna malaikat nenekori imag agha yubu lelamogti, “Hagar, sa'a sembe wana ikin uro wamlam? Allahri anme yubu ka'ebalba, log sembaheng kom! ");
INSERT INTO kkl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","An me peramag pimendi pukitmendi, sae lomoro saelbalulam. Ilisag yabo maikno nembahineba, maikno taikti, as nubunge sopso pukang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ambarogti, “Mag sembe so'o walirobag kembalul,” aro Hagar haing tibin nembaogpa, ibogti mag ma'iag tero tel piogti, elme tarel aogpa teog. ");
INSERT INTO kkl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Teogti wamogpa, Allahri Ismael neneko piamog paghabog nubu taogti, aldesag Paran wamog. Paran wamogpa, ilindi Mesir kel nhon tarogpa, toro aogti yin sae yonge wamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ik nhon sum Abimelekhap, Pikhol yin saleropne sikindoap Abrahamag yubu lelamdekti, “Nuri lag ia ulangkeap. Nia mangkina Allahri yeplangkelne,” serek. ");
INSERT INTO kkl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Serekti, “Ane sembe nanag nen orolenange leplulam komba, sik uro Allah siag leplulamne, nari mabo sembe babe, nari mangarobari mangkahyikne sembe babe, mog so'o ene sembe babe, nari anag ulamna saog uro, anna sekelananne anekona,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Wene seogpa Abrahamdi, “Yo nangkae, nen orolenange lemnun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Wene seogti Abraham elmaboringe mag waliroba longoropne Abimelekh ilipsabori taulbaekne sembe Abrahamdi, “Yaghe, welaro,” seogpa ");
INSERT INTO kkl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelekhti, “Na ekon: Etneri uaonge sembe apna samenag ambatneom kom aghana sumeneog ka'eban,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Wene seogpa Abraham nenekori eldi pham domba eldi pham sapi tobogti, Abimelekh tarogpa, yubu salag nikne leptek. ");
INSERT INTO kkl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","29","Leptekti Abraham nenekori pham domba me kelne aghabog saekbare poloro nikag pibogha sembe Abimelekhti, “Sa'a sembe neabenena nikag poloro piplam?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Wene seogpa Abrahamdi, “Pham me saekbare abene nari saeri tatkinun. 'Pham abene kekneba mag ane naba nari saeri wailbano,' aro an el ua unne sembe tatkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Wene aro salag leptekti, yubu nikne leptek ane sembe mag aneko Bersyeba engkaek. ");
INSERT INTO kkl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Yubu Bersyeba aneko nikne leptekti, Abimelekhap yin saleropne sikindo Pikhol ponekoap nen samoro Filistin so'oag pirek. ");
INSERT INTO kkl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Pirekpa Abraham nenekori kal yangkal saog kal Bersyeba peramag aneko mebogti, “Allah ya'ag kamagne poneko” si lero yoplamog. ");
INSERT INTO kkl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham neneko ik maiknoro Filistin so'oag aneko wamogti, nimi sekelananne wamog. ");
INSERT INTO kkl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Olog wameka Allahri, “'Abraham neneko Na yubu ka'ebalul to?' aro mipnun,” sembaogti, “Abraham,” yobog. Yobogpa, “Nani, na wamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allahri ambarelamogti, “An me ot nhonogne an wanaagne Ishak nenekoap Moria mog so'oag pururom. Pirumundi Nari yim nhon ambatkenengeag an me 'Na sembe mhong towalengkalulam,' aro oro aukag taplulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ambarogpa mabogha lukunap Abraham nenekori, “Allah sembe mhong towalengkanundi kal poa pukap,” aro kal werero sin popsinep pham keledai alibag towalengkibekti Ishakap eldi arukna phendeap Allahri ambaroghag aneko piek. ");
INSERT INTO kkl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Palamek paghabog inipna phende taogpa ik wilindip sumeneko palamekti, Abrahamdi tilamogpa, Allahri leboghag aneko olog we uro wamogpa tiboghaogti, ");
INSERT INTO kkl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham nenekori eldi arukna phende abenekoag ambarelamsiogti, “A'un keledai aneap ane wamturom. Na nameapti Allah omekanunamdi tani yingkinemeri yanunam,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ambatsiogti, “Allah sembe mhong towalengkanun” aro kal werebaekne taneko elme Ishakti sa'oag saobirogti, eldamneri auk unaap, pisoghap saelbaogpa palamdek. ");
INSERT INTO kkl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Palamdekti Ishak nenekori, “Naiong,” seogpa, Abraham nenekori, “Name, sa'a?” seog. Seogpa Ishak nenekori, “Aukap kalap tomnam aghana, pham domba aukag tamnunamne tala wamla?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Haibaogpa, Abraham nenekori, “Name, Allahri tatsilenge tamnunam,” seogpa palamdek. ");
INSERT INTO kkl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Palamdeka Allahri ambaroghag aneko pirekti, Abraham nenekori, “Allah sembe mhong towalengkimnun,” aro kirik yangkaogti, kal alibag pibog. Pibogti Ishak haing sae yan kaubiagha kal paliag mambirogti, ");
INSERT INTO kkl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","pisog kiliro “Omnun,” aro ulamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","NUNI Allah Ilipsae malaikat nenekori imag agha, “Abraham, Abraham,” aro yobogpa, Abraham nenekori, “Wa,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Wa,” seogpa, Allah arukna malaikat anekori, “Anme wali uro wamlulba, opseng kom. Andi Na sembe log uro wamlamdi yubu ka'elamnelamne wene Na eltanel. 'Anme me ot nhonogne tatnululam,' senaba o'ona aro toro piro alam kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Seogpa Abraham neneko tangaom agha tilamogpa, pham domba yemne pinu yagne yoabaag kekhaektangtoba wamogpa, ibogti pham aneko tolbina elme lunumna oro aukag tabog. ");
INSERT INTO kkl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Taboghag aneko Abrahamdi si, “NUNI Allahri teko senenna tatsirobag,” engkaog. Engkaogha sunsunum uro wene babe nimiri lelamangdi, “NUNI Allahri yim eneag agha teko senenna tatsilul,” alamang. ");
INSERT INTO kkl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaikat anekori nen imag agha yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Na Nandamne Allah Siag yubu sik uro lemnunne ane: Nari, 'Anme ot nhonog agha tatnululam,' senoba, 'Name o'ona,' aro toro piro aom komba, ");
INSERT INTO kkl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Nari an mikip nembagheneba, andi mangarobari mangkahyikne taneko maikno taukang. Maikno taikti, imberea nimiri a'ilbahinep kom saog uro, kirik a'angkea mag abolag lalaptoba a'ilbanep kom saog taikpa, nimiri a'ilbahinep kom wamukang. Nimiri a'ilbahinep kom wamikpa, andi mangarobari mangkahyikne maikno taikti, nimi mog so'o wamikne oro luknulamsiikti, sindi isa nimi, sindi so'o sin ngai taikti saelbamukang. ");
INSERT INTO kkl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Andi Na yubu ka'ebalamba, andi mangarobari mangkahyikne pere agha Nari nimi sisa ni tala-tala wamikne walingena tatsinun,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ambarogpa Abraham neneko eldi arukna phende pipsioghag aneko samoro yarekba, sin ma'aptaekti, as Bersyeba pina ya'ag wamek. ");
INSERT INTO kkl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Abraham neneko ilipsae Nahorti kel Milka sembe ka'elamogpa, me linbare wamsil ana ka'ebaog. Nahorti mabo sina ane: Us me yandonge, Bus me nabinge, tanena Nahor elme wilindipne Kemuel mangaro aog. Kemuel poneko Aramnang sikini taog. Nahor elme tomne Kesed, lamne Hazo, no'opne Pildasi, saekne Yidlap, elabome ane Betuel. Betuel ponekori Ribka mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor elmabo tognoro pia urop kel Reumaag agha me tombare. Sina: Tebah, Gaham, Tahas apna Maakhaap likitsiog. ");
INSERT INTO kkl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara neneko mangkaekne heng kun taibuka taubuka ulamogha teng tombare eptopne supna tarabare (127) taog. ");
INSERT INTO kkl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kanaan so'oag as Kiryat-Arba anekoa tebaog. Tebaogpa ela'ange Abraham yingkina engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yingkina engelamogti, Abrahamdi elkel teptoba aneko aeag piogha Het nimi as Hebron so'o ngai nangag piogti, ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Na a'un anabiag na sekelanne wamnari, 'Nari kel siknunag sembe so'o olog ambatnemunba, kamna tatsinun,' aro mololamsin,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wene aro ambatsiogpa sindi lelamekti, ");
INSERT INTO kkl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nani, an nimi nubunge nu anabiag Allahri mikip nenelangkelba wamlamne kiplangkeap. Nu nununge so'o nimi teptopne siklamsiabag tapto walingeag siklulam. Nimi siklamsiabag nu nimi a'erodinge taneko anabiagne nhonag ankel siklulamne sembe nu niri wali sembamap,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Wene aro ambarekpa sin whingag yabu sanukto pulingkiogti, ");
INSERT INTO kkl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","yubu lelamogti, “A'un nari kel, 'Wali tanea siklul,' sembalomba, 'As Magbela kirik arame Zohar elme Efrondi sirikag wamlange neneko kamna kapto tomnundi ambatlulom,' aro mololamsin. Eldi kamna kapna molbanelenge sunsunum uro a'un whingag agha tatnundi, so'o kamna kapto tomnunag aneko nari kel sikneba, so'o naringe talul,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Sumeneko Efron neneko Het nimi nusamag leka as kanero torop ina siramag pukamogti, Abrahamdi lebogne neneko ka'ebaogti, nimi wamekne taneko whingag lelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nani, na nangkabo ni ka'eamangpa, yubu lemnuandi ka'eamnululam. Nani, so'o siklulamag ane babe kirik arame ane babe tarelangken. Andi kamna kapnululam kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Wene seogpa, Abraham neneko Het nimi whingag yabu sanukto pulingkiogti, ");
INSERT INTO kkl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","sin whingag agha Efronag yubu lelamogti, “Nari lemnunne nene ka'eamne. So'o aneko nari kel siknundi, kamna tatkinunne sembe, 'Saelbalulam,' aro mololangken,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Wene aro ambarogpa, Efron nenekori, ");
INSERT INTO kkl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Nani, ankel so'oag siklulamba, kamna maikno toplulam kom aro kal ma'al kirik wana solomne teng naual tarabare mololangkenne sembe wana ikin sembaheng kom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Wene aro ambarogpa Abrahamdi, “Wali lepla,” sembaogti, Efrondi nimi Het nimi taneko whingag molbaogne abeneko sunsunum uro, “Sunurop to?” aro sumbongkia torobag kirik wana solomne ikin sununna kembaogti, Efron ponekoag tarog. ");
INSERT INTO kkl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tarogpa, so'o Mamre heng walelingirobag sip Makhpela wamog so'o Efrondi aneko Abraham ngai taog. So'o nenekoag awe wenag babe, kirik arame babe, kal wamogne ni taneko babe, ");
INSERT INTO kkl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","“Abraham saeag tal,” aro Het nimi ina siram peramag wamek nimi taneko ni el taek. ");
INSERT INTO kkl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nimi ni el taekpa, Abraham nenekori Kanaan so'oag as Hebron wamoghag Makhpela arameag elkel Sara tebaogne neneko sikog. ");
INSERT INTO kkl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Undo ulamogti samenag Het nimiri so'o saelbamekne kirik arameap abeneko Abrahamdi, “Nari kel siknun,” aro ngai taog. ");
INSERT INTO kkl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamdi so'o as Hebron toboghag aneko ngai taogti, wamogpa, NUNI Allahri elag walia ulamog pahabog, nong sabal taog. ");
INSERT INTO kkl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sabal taogti ik nhon sum eldi arukna elenge aba ni pia ulamsiogne ponekoag yubu ambarelamogti, “Name, Andi sik uro ambatnululamne el tanundi, na yan kwagha mombolag sae tobong kiplulam. ");
INSERT INTO kkl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Tobong kipmendi NUNI Allah Imagne im so'o saelbamlange nenekori ka'eamleba, name Ishak sembe andi, 'Kanaan so'o eneag wamang kelabo ebanun kom,' aro yubu sik uro leplulam. ");
INSERT INTO kkl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Na mangkaneekag Ur-Kasdim pimendi, na nangkabo naipsabo sikin mangkelabo nhon el pululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Wene aro ambarogpa, eldi arukna anekori Abrahamag yubu lelamogti, “Kelabo Ishakti toplul sembanenge nenekori, 'Anap Kanaan pununam kom,' sele tanena anme Ishak eneko enel aneba, andi laploa yalumag pununam te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Haibaogpa Abrahamdi, “Kom, na name tane wamlul. Enero pabululam kom! ");
INSERT INTO kkl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","NUNI Allah imag wamlange nenekori na naniri asag agha poa lambaneog. Poa lambaneogpa, nangkabo laplobiagha lambahiba, Allahri, 'So'o Kanaan ane otsik an anisag yabo tatsinun,' aro salag pibog. El nenekori, 'An yepkulul,' aro El Ilipsae malaikat poghol aleba, andi na name Ishak sembe kelabo aneko enero poa yalulam. ");
INSERT INTO kkl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kelabo anekori, 'Anap Kanaan so'oag pununam kom,' sele tanena wene salag palilamnange sembe seneragna koma wana keyagman uro an mo yalulam. Ane sembe name enero poa pululam kom!” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Wene aro ambarogpa, eldi arukna anekori ili Abrahamdi kwagha mombolag sae tobongkibogti, Abrahamdi lebogne sunsunum uro salag pibog. ");
INSERT INTO kkl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Salag pibogti, eldi arukna anekori wali-walia iliringe tobogti, popsirop pham unta sa'obareag towalengkaogti, Abraham ilipsae Nahor samen wamoghag Aram mog so'o mag luag sip piog. ");
INSERT INTO kkl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Piogti ae sinag kelabo mag tel alamekag, “Pham unta taneko tektek eplamik,” aro mag sembe so'o wailbaekag aneko tektek eplamog. ");
INSERT INTO kkl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Tektek epto wamekpa, Abrahamdi arukna aneko Allahag yubu lero mololamogti, “Na nani Abraham Ili Allah wamlamne, Nani Abraham sembe o'ona sembame. Nani Abrahamdi sembao saog uro uanundi yepnululam! ");
INSERT INTO kkl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na wene mag waliroba peramag sekamna. Olog wamneba as eneag kelmabo mag telaukang. ");
INSERT INTO kkl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Sin yaikne taneko nhon elag mololamneri, 'Mag ma'iag teropne na mag olog tunundi,' seneba, eldi, 'Nani an temenba, anenge pham unta babe tebatsunun,' selenge neneko sembe, 'NUNI Allahri Ishak sembe kelabo nene weplange ane,' sembanun. Nari pham unta babe mag tebatsile tanena, 'Nani Abraham Allahri o'ona sembamlari, eldi seneragtopne sunsunum uro ual,' aro el tan unulul,” aro Allahag molona molorop yubu lebog. ");
INSERT INTO kkl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Allahag yubu molona lelamog abeneko kel saren nubu walinge nhon si Ribka mag ma'i teroba mag tebogti, walel alamog. Ribka neneko Betuel elmangkel. Betuel poneko Abraham ilipsae Nahor elme Milkari mangaro aogne. Ribka nengabo tomna koma wamogti yaog. Mag sembe wailbaekag aneko kulukaogti, mag ma'iag tebogti walel alamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham arukna aneko elemag-elemag keleneko peramag piogti, “Namangkel, mag olog tebatne,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Molbaogpa kelenekori, “Nani, tululam,” aro mag ma'i aneko elemag-elemag sa'oag agha toro pibogti mag tero tarogpa teog. ");
INSERT INTO kkl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Teogpa kelenekori, “Andi pham unta babe mag tebarel phineba mag tukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Seogti mag teroba aneko elemag-elemag pabiogti, pham unta mag teroba anekoag ikatsiogti, nen samoro telbina ikatsiogpa, pham taneko mag ni teek. ");
INSERT INTO kkl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Undo unulamogpa Abraham arukna anekori, “NANI Allahri nari semban saog uro yepneldo,” aro yubu koma keleneko kembamogti wamog. ");
INSERT INTO kkl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pham taneko mag mon og uro teekpa, Abraham arukna anekori wali-walia leng-leng aroba kirik emas agha sunuroba kamna alikinag uro kamna kapto toroba tobogti, kelenekori uramag u pong saog uro tobongkibogti, sae no'obag babe sae supnagha saog uroba phende no'obag tobongkibog. ");
INSERT INTO kkl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Tobongkibogti hailamogti, “Anina sina etne? Aniri aeag nari maboap mabukapti, olog kolo wamlare?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Haibaogpa, Ribka nenekori, “Na nani Nahorap Milkaapti mangkaekne Betuel wamla,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“Nu nununge ae an sembe kolo wamla. Anenge pham mamnebag babe wamlaba, anenge phamdi tena babe wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Wene seogpa Abraham arukna aneko so'oag yabu sanukto pulingkiogti, Allahag yubu omekto towalengelamogti, ");
INSERT INTO kkl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Na nani Abraham ILI Allah omeklangken. Andi Nani Abraham ekon tan koma o'ona senelamlamdi, ambarom saog uro ualam. Na nani ilipsaeringe mangaroba wamangag peket enero poa yanelam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Wene seogpa Ribka neneko ilindi aeag piogti, Abraham arukna anekori lebogne sembe eldi ae lomag nimi ambarelamsiogpa, Ribka eldo Laban nenekori babe ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ka'ebaogti kemelamogpa, ilipsa'el uramag babe, saeag babe kirik emas agha sunuroba leng-leng aroba tobongkiamogpa, Laban kembiagha elem-elem lambaogti, tilamogpa Abraham arukna elenge phamap mag waliroba peramag sekamogpa, Labandi tibog aogti, piog. ");
INSERT INTO kkl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Piogti, Abraham aruknaag, “Nani, an NUNI Allahri o'ona sembe yeplangkelne wamlamba, ipken. Paiag tane wamlulam kom. Anap anenge phamap mamnebag o'obandi, aeag pukapti yae,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","enero poa aeag piog. Piogti Laban nenekori arukahiogpa pham unta alibag payaogne taneko toro pelengkaekti, pham mamnebag o'ol aba karebaekne usa yangaro uaekti, tena pham sembe babe tatsiek. Tatsiekti Abraham arukna yan mag a'elbaukang aro mag tebatsiek. ");
INSERT INTO kkl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kwaneng yoro sin whingag pil aekpa, Abraham arukna anekori lelamogti, “Kwaneng anam ten komag na yanne sembe ambatsineri, na kwaneng tunun,” seogpa, Laban nenekori, “Nani, ambatsi!” seog. ");
INSERT INTO kkl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Seogpa, “Na Abraham arukna yan,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“Na nani neneko NUNI Allahri mikip nenelamogti, pham domba, sapi, unta, keledaiap, wali-walia leng-leng aroba kirik emas, perakap, elenge me kelmabo aruknaap maiknoro tarogpa, el neneko tupne taog. ");
INSERT INTO kkl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na nani elkel Sara neneko ya'ag sabal taog aghana me nengabo me mangkarogpa, naniri, 'Na tebane tanena naringe tane name meneri ngai taho,' senelamlari wamla. ");
INSERT INTO kkl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Eldi ambarelamneori, 'Na name sembe Kanaan kelabo ebaheng kom aro sik uro leplulam. ");
INSERT INTO kkl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Na nani samenag wamoghag pimendi, na nari naipsae anabiagne kelabo nhon ipmendi, enero poa yalulam,' aro ambatneo. ");
INSERT INTO kkl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ambatneoba narina, 'Kelabo anekori, “Anap Kanaan so'oag pununam kom,” sele tanena welaro uanun?' aro haibanoba ");
INSERT INTO kkl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","eldina, 'Undo kom. Nani Allah yubu ka'elamnaba Nani Allah ponekori, “An yepkilul,” aro Ilipsae malaikat poghol aleba, na name sembe naipsae anabiagne kelabo nhon iplulam. ");
INSERT INTO kkl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nangkabo tanekori kelabo nhon tatkik komba, ipmen taneogna, wene salag palilamnange sembe seneragna koma wana aingniniro nongog yalulam,' aro ambatneo. ");
INSERT INTO kkl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ambatneoba sumene mag sembe so'o walirobag yingkina wanaag agha molona Allahag yubu lelamnari, 'NANI, Abraham ILI Allah wamlamne, Abrahamdi sembao saog uro uanundi, yepnululam. ");
INSERT INTO kkl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Wene wamneba, kelme nhon mag na wamnaag ane tel tol alengeag, “Mag tebatne,” aro molbaneba, ");
INSERT INTO kkl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kelabo nhon yalengeri, “Nani mag tebatkenun,” sele tanena el neneko Allahri weplange kom sembanun. Kelabo nhon yalengeri, “Nani, mag tebatkeneri, anenge pham unta babe tebarel phinun,” selenge neneko sembe Nuni Allahri Abraham elme Ishak sembe kel weplange ane sembanun,' aro Allahag molona molban. ");
INSERT INTO kkl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Allahag yubu lelamna abeneko Ribka neneko mag ma'i sa'oag sa'oro poplari, mag telengkilba, nari, 'Mag tebatne,' aro mag molban. ");
INSERT INTO kkl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Mag molbanba, mag ma'i elem-elem toro piplari, 'Nani, mag temenba, anenge pham babe tarel phineba tukang,' selba ten. Tenba nanenge pham babe mag tarel phil. ");
INSERT INTO kkl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tarel phildi yalba nari, 'An ani etne?' aro haibanba, 'Nani Nahorap Milkaapti mangaro arekne Betuel neneko wamla,' selba, emas agha u pong sunuropne ulomag tobongkipnari, supnagha leng-leng arobari emas agha wiropne saeag tobongkipna. ");
INSERT INTO kkl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tobongkipnari, nani Abraham ILI Allah omeklamnari, yabu sanukto pulingkina, 'Andi na nani ilipsaeri mangarobari mangaroba wamlaag payanelamba, nani elme sembe kelene imna,' Allah omekan. ");
INSERT INTO kkl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ane sembe a'undi na nani 'Nu sisa nhonog aneko,' sembamundi, o'ona sembamun tanena tibin nenero ambatnululom, kom sembamunne babe ambatnumunba, yog kelabo ebanun,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ambatsiogpa Labaanap Betuelapti ambarelamtekti, ''NUNI Allahri seneropne sunsunum uro, uro yabilba, nuri sa'a senep kom. ");
INSERT INTO kkl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribka nene anap pirumunba, NUNI Allahri sembao saog uro ani elmeri toplul,” serek. ");
INSERT INTO kkl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Wene serekne ka'ebaogti, Abraham arukna aneko so'oag yabu sanukto pulingkiogti, NUNI Allah omekaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Omekaogti, ag eneknangeap, leng-leng aroba kirik perak emas agha wiroba saeag tobongkipnepneap, saramag langkanepneap Ribka tarogti, ilin babe eldo babe wali-walia tatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tatsiogti, Abraham arukna anekoap ilipsaboap kwanengap magap teekti mabek. Mabeka kwelekaogpa, Abraham arukna anekori, “Na naniag punundi ambarelamsin,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ambatsiogpa, Ribka eldoap ilinapti ambarelamdekti, “Ribka nunap ik sa'obare to undo wamebea pulul,” serek. ");
INSERT INTO kkl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Wene aro ambatekpa Abraham arukna anekori, “NUNI Allahri yeplamneoba, naniri seneragtopne sunsunum uro uano anekona a'undi, 'Wamukap,' seheng kom. Naniag punun anekona, 'Elemag,' ambatnururom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wene aro ambatsiogpa, sindina, “Ribka neneko yobeberi haibaukap,” serekti, ");
INSERT INTO kkl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ribka yoptekti hailamdekti, “Nimi poneap pururom te?” aro haibarekpa, “Nhon pununam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wene seogpa, Ribka ologhag pia ulamog kelenekoap Ribkaap, “Nhon pururom,” aro ambarelamsirekti, “Abraham arukna ilipsaboap nhon pululom,” aro ambatsirekti, ");
INSERT INTO kkl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Allah siag Ribka kiplamekti, “An nunipsa'el wamlamne nimi teng-tengne a'ilbanep kom saog uro wamukangne sikinin talulam. Andi mangarobari mangkahyikne tanekori nimi isanangdi as soro pin wa'alamikti, oro yaglamsukang,” aro kibek. ");
INSERT INTO kkl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kibekpa, Ribkaap eldi arukna tanekoap ag togto aekti, pham unta alibag waelbaekti, Abraham arukna anekoap nhon piek. ");
INSERT INTO kkl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Abraham arukna palamog ko'o eneko Ishak neneko mag sembe wailbaekag, “Beer-lahai-Roi” engeropne neneko peramag piogti, wamog. Beer-lahai-Roi wamogha Kanaan so'o mag kwasag sip piogti, wamogha samoro yalamog. ");
INSERT INTO kkl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ik nhon sum sinag aweag, “Ina kemeroa yabunun,” aro elenge aeag agha lambaogti, tilamogpa pham untari nimi poamsiekpa, yalameka tibogahiog. ");
INSERT INTO kkl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ishakti tilamsiogpa, Ribka nenekori babe Ishak tibogaogti, pham unta alibag agha kuluka yingkiogti, ");
INSERT INTO kkl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ribkari Abraham aruknaag hailamogti, “Nimi nhon aweag siba nunag sip yalamlange nene etne?” seogpa, Abraham arukna anekori, “Na nani yalamla ane,” seog. Wene seogpa Ribka neneko ag agha whing liliptaog. ");
INSERT INTO kkl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Wene Ishak yaghag yaekti, Abraham arukna anekori undo unuaogne sembe Ishakag ni ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ambarogpa Ishak nenekori, “Ribka na kel,” aro toro aogti, ilin Sara samen wamog aeag poa wa'iog. Poa wa'iogti, wamekti, Ishak nenekori, “Nanin tebaoba, wana mali uro wamnaag agha na kel Ribka yanel,” aro Ribka sembe o'ona senelamog. ");
INSERT INTO kkl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamdi yog kelabo Ketura nhon tobog. ");
INSERT INTO kkl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura tobogne nenekoag agha me mangkahiognena: Simiranap, Yogsanap, Medanap, Midyanap, Isibaghap apna Suaap mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Abraham elme Yogsandi mangkahiognena Siabaapna Dedanap. Dedan sisana Asyur nimiapna Letus nimiap Leum nimiap. ");
INSERT INTO kkl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Abraham elme Midiandi mabona Epha, Epher, Henokh, Abida, apna Elda'aap mangkahiog. Mabo enekona ni Ketura elauyabo wamek. ");
INSERT INTO kkl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Abrahamdi yog kelabo topsiogti, me pipsiogne sae agha olog-olog tatsiog. Me pilopsiogne tanekoag, “Heng walelingkirobag sip pimundi wamlulom,” aro yag lambahiogti, el sae agha nia mangkina Ishak saeag aghabog pibog. ");
INSERT INTO kkl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham mangkaeka heng kun taibuka taubuka ulamogha teng no'opbare eptopne naualbareag (175) wamogpa, sabal taogti, wana aingniro wamogti, hain kom taogpa, ilisag yaboag yame samen piog. ");
INSERT INTO kkl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tebaogpa, elmabo Ishakap Ismaelapti Makhpela kirik arameag so'o siktekag aneko Mamre peramag so'o samen Hetne Sohar elme ngai wamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham nenekori kamna kapto tobogti, elkel Sara kirik arame so'o sikoghag aneko Abraham babe so'o siktek. ");
INSERT INTO kkl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","So'o siktekti, wamdekpa, Allahri Abraham elme Ishak neneko o'ona senelamogti, yeplamog. Li ko'o eneag Ishak neneko mag sembe so'o wailbaekag, “Beer-lahai-roi” so'o peramag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Abraham elme Ismaeldi elmabo liksiogne ane. Abraham elkel Sara arukna Hagar Mesir kel wamogti, Abrahamap maptekti, Ismael mangkaog. ");
INSERT INTO kkl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Ismael elmabo likto piogha sunsunum uro sin sina ane: Ismael elme yandome Nebayor, nabime Kedar, tanena Adbeel, Mibsam, Misima, Duma, Masa, Hadad, Tema, Yetur, Nafis, apna elabome Kedmaap. ");
INSERT INTO kkl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismaeldi mabo sin aobare nangene sindi sisa aobare taogpa, sin nimi nubunang as a'ero sin si nubu taog. Ismael elmabo as babe kalun ae longoro sorobag babe a'ero-a'ero solamekpa, ua ulamekag a'ero-a'ero elmabo si sunsunum uro alamek. ");
INSERT INTO kkl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael el mangkaekne heng kun-kunne teng lambare eptopne phende (137) wamogti, hain kom taogti, ilisagyaboag yame samen piog. ");
INSERT INTO kkl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tebaogpa, Ismaeldi mangaroba sin mog so'o wamekne Hawila inagha Syur inagha heng walelingkirobag sip Mesira Asyur simbik wamek. Sin wamekne sikin kaboap aisa neneptangto wamek. ");
INSERT INTO kkl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham elme Ishak nenekori ulamogne ane: ");
INSERT INTO kkl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishak mangkaekne heng kun taibuka taubuka ulamogha teng nhon eptopne naualbare (40) taogpa, elkel Ribka toro aog. Ribka eldo Labanap sikini Betuel Aramneap Aram mog so'o nimi wamdek. ");
INSERT INTO kkl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka neneko me mangaro an koma wamogpa, Ishak nenekori Allahag molona yubu lelamogpa, NUNI Allahri ka'ebaogpa, Ribka me monag taog. ");
INSERT INTO kkl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Me monag phende wamdekti, webeltalamdekpa, Ribka nenekori, “Sa'ambe tamna nene nanag ulamla?” aro wanag agha seneraghogti, “NANI Allahri tibin nenero ambatnilul,” aro hailbiog. ");
INSERT INTO kkl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Hailpiogpa, NUNI Allahri yubu lelamogti, “Nimi sisa phende an monag wamdang. Sin-sin aisa neneptangkamtukang. Sin phende abeneko nhon agha mikipne wamleba, yandonge mombolag taleba, nabinge paliag talul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ambarogpa, wamogti, Ribka nenekori me phende mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Samenag mangaptaogne neneko kon uwong hong mana hong saog uro pongoropne mangaptaog. Undo pongkamogha sembe me si Esau aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Me amikne neneko mangaro kuluklamogti, eldori yan pubu saelbamogti, eldi, “Na sam,” aro yan saelbamogne sembe si Yakub engkaek. Ishak heng kun teng phende eptopne no'opbareag (60) wamogpa sin phende mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Me abeneko nubu tarekti, Esau neneko pham winang mana sae yonge wamogti, paiag pham winang mana onne yeng awi uro wamog. Yakub neneko wana aingniropne wamogti, aeag aghabog ua ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishakti winang mana sop tenne sembe awi yeng uro wamogti, elme Esau sembe agha wanaag uro ua ulamogpa, Ribka nenekori elme Yakub sembe wanaag uro ua ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ik nhon sum Yakub nenekori kacang uwongne yolamogpa, Esau neneko paiag agha kwaneng yo uro yaog. ");
INSERT INTO kkl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yaogti Yakubag, “Nangkae, na kwaneng yori uwonga ane olog tatne!” aro molbaog. (”Uwonga ane,” seogne sembe si nhon Edom aro engkaek.) ");
INSERT INTO kkl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Esau nenekori molbaogpa, Yakub nenekori ambarelamogti, “Wali molbanelam, ane sembe anna yandonge wamlama anekona, nimi yandoa na tatnemendi, anna nabinge tamenba, na yandonge tanun taneogna, molbanelama tatkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Molbaogpa, Esauri, “Kwaneng yori tebanep saog ulamnari, sa'a sembe 'Na nimi yandoa wamna,' sunun?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Seogpa, Yakub nenekori, “'An nimi yandonge an wamlulam,' aro Allah siag sik uro leplulam,” aro ambarogpa, “Otsik uro lemna,” seogpa, Yakub neneko nimi yandoa aneko taog. ");
INSERT INTO kkl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Undo unuaogpa, Yakub nenekori kwaneng rotiap kacang uwonga anekoap tarogpa, teogti, piog. Undo ulamdekti, “Na yandonge ua una karong,” aro lipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ishak kelabo meap Beer-lahai-roi wamekpa, Abraham wamog li kwaneng yo nubunge wamog saog uro, sumene li ene babe kwaneng yo nubunge waelbaogpa, Filistin nimi nubunge Abimelekh ponekoag Ishak piogti, “Mesir palamapti, olog wamukap,” aro molbaogti, as Gerar pina wamog. ");
INSERT INTO kkl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","3","Pina wamogpa, Allah el wamoghag lag taogti, yubu lelamogti, “Mesir anna pheng kom, Nari ambatkeno saog uro tane wamlulam,” seogti, “Nari an piangkeneri yeplangkinun. Nari aniag salag samenag lepsinge neneko, mog so'o ene anapna anmaboabag pimnun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Seogti, “Nari anag andi mangaroba imag imberea saog uro maikno nembahinun. Nari mog so'o ene andi mangarobag mog so'o ene tatsineri, andi mangarobari mangkahyikne pere agha Nari nimi sisa ni tala-tala wamikne walingena tatsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Seogti, “Abraham Nari yubu ni lelamsinge ka'eamogti, nanag wana piamog ane sembe Nari an yepkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ane sembe Ishak Gerar wamog. ");
INSERT INTO kkl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Taneko wamek nimiri eldi kel Ribka sembe haibaekpa, Ishakti, “Ribka saren kemerop wamogpa, Ribka toro habe senen nimiri omnikag,” sembaogti, “Ribkana nari kel kom, elna naipsae'el,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Gerar aneko Ishak pina ua ulamogha ik nhon sum Filistin nimi nubunge Abimelekh ae lomag wamogti, keken lom toman agha Ishakap Ribkaap tilamsioghag agha sin nebeldalamdek. ");
INSERT INTO kkl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nebeldalamdekpa, tiboghahiogti, Abimelekhti Ishak yobogti, “Ribkana ankel aghana sa'a sembe 'Naipsa'el,' seom?” seogpa Ishakti, “'Nari kel seneba, na omnikag,' aro lemno,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Wene, “Aro lemno,” seogpa, Abimelkhti, “Sa'a sembe nunag wene seom?,” aro wene seogti, nen lelamogti, “Andamneri wene seomba, nari mabo andi kelap mapseng, tanena tam andi kelap mapseng nenena andamneag agha tam ikinne nunag pipso,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Wene seogti, as eneko wamek nimiag yubu ambarelamsiogti, “Nimi etneri nimi eneag tam pipseng kom elkelag babe saelbaheng kom, tam sinag kaolbahik nimi eneko obukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Heng kun enekoag Allahri Ishak yeplamogpa, awe webaogti, meroba aweag aneko mebogha taneko nong pibogpa, maiknoro taghogti, el meroba tupne wamog. ");
INSERT INTO kkl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Sae agha maikno tang-tang palamogpa, el tupne nubunge wamog. ");
INSERT INTO kkl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ishaktinge pham dombaap sapiap maikno wamogpa, eldi arukna babe maikno wamekne sembe Filistin nimi yo senelamek. ");
INSERT INTO kkl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Yo senelamekti, samenag Abraham aruknari mag tena sembe so'o wailbaekne taneko ni so'o tolongoro leple piek. ");
INSERT INTO kkl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Undo leple piekti, Abimelekhti yubu lelamogti, “Nununge so'oag agha lambalulam, an anea anenge sae agha nubu talamlambana,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Wene aro ambarogpa, Ishak as enekoag agha Gerar puluag piogti, ae soro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Pina wamogti, iliri mag waliroba agha Filistin nimiri so'o tolongoro lebeka taneko nen waliro lambaogti, iliri mag waliroba si enge-enge yabiogha sunsunum uro nen enge-enge piog. ");
INSERT INTO kkl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Gerar puluag aneko Ishak aruknari mag walirop mag wailbaekti mag siriro la'anilamogha ibek. ");
INSERT INTO kkl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Aghana pham pia yae ua uropnang Gerar nimiap Ishakti arukna pham yae ua urop nimiap, “Nununge mag,” aro lelamekti, “Mag ane nununge,” tam aro wene seekne sembe mag aneko si “Esek” aro Ishakti engkaog. Mag si Esek aro engkaogne nene nun yubuag, “Waptangtop Mag” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ishak arukna tanekori nen orange babe wailbaek. Aghana nen wailbaek mag taneko sembe babe waltalameka sembe Ishakti sin yubuag mag si, “Sitna” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nen anekoa nhonag nhon wailbaog aghana mag nene wailbaogne nene sembe sin waptan kom, ane sembe Ishakti, “Rehobot” aro engkaog. Rehobot aro engkaogne nene sembe, “Wene Allahri nun mog so'o ene tatsilba, me likto mangaro tero wamukap,” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Anekoa Ishak Bersyeba piog. ");
INSERT INTO kkl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Bersyeba aneko pina wamogpa, sumeneko inipnag Allah el whingag lag taogti, yubu lelamogti, “Na Allah, ani Abraham Ili. An log sembaheng kom, Nari yepto piangkenun. Nari salag Nari arukna Abrahamag lepsinge sunsunum uro mikip nembagheneba, andi mangaroba nimi maikno taukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Allah el whingag lag taogti, yubu leboghag aneko “Mhong towalengkanun” aro kirik yangaro sobaogti, “An Ya'ag Wamlamne” aro Allah si yoplamog. Ae kalun ae babe sobaogpa, eldi arukna tanekori babe mag so'oag walirop mag babe wailbaek. ");
INSERT INTO kkl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aneko ae sobaogti, wamogpa, ik nhon sum nimi nubunge Gerar wamogne yubu sia leropne Abimelekhap, el yubu amoropne Ahusatap, yin saleropne sikindo Pikholap “Ishak haiptaukap,” aro yaek. ");
INSERT INTO kkl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aghana Ishakti yubu lelamogti, “Sa'a sembe nanagna wenena yalom? Samen a'undi na sembe karong senelamnilumdi, a'ununge so'oag agha yagnilum kom te?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Wene seogpa, sindina, “Wene nuri kemelangkeapne, wene Allahri piangkel, ane sembe nuri lebapne: elap nunap yubu nikne ya'ag lebukap. Wene leplulamne andi nunag yoaba ualulam kom, nuri babe anag yoaba uaukap kom. Nuri anag walia uabori, lipkeboba, wali uro piom. Nunag tibin wamlange an Allahri yepto piangkilul,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Wene seekpa, Ishakti tenaba yobaogha ma'aptangto teek. ");
INSERT INTO kkl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tea mabeka kwelekaogne sindi “Salag lebukap” aro seneragto wamekne salag lero yubu sia lebek. Lebekti Ishakti, “Nangkabo, palamlulom,” aro kipsiogpa piek. ");
INSERT INTO kkl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Sumeneko sum babe Ishak arukna tanekori, “Mag walilamapne neneko sumene mag ibab,” aro ambarel aek. ");
INSERT INTO kkl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ambarel aekpa, sumeneko mag sin wailbaekne aneko “Mag Siba” engkaogpa, as taneko sobaekne wene “Beerseba” engerop taog. ");
INSERT INTO kkl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mag ibekag Beerseba Ishak wamogti, elkelabo meap babe wamek. Wamekpa, Esau mangkaekne heng kun-kunne selek ta'om agha epto naual bare (40) piog. Piogpa, Ishak elme Esauri Het kelabo phende tolamsiogti, Beeri elmangkel Yudit nhonapna Elon elmangkel Basmatap topsiog. ");
INSERT INTO kkl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Awi senerop kom kelabo phende topsiogne nene sembe Esau iliap ilinapti karong senelamdekti, wana mali talamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ishak neneko ya'ag sabal taogti, haing mali taogpa, elme yandonge Esau nenekoag “Name, yae,” aro yobogpa, Esauri, “Yo, nani,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Seogpa Ishak nenekori ambarelamogti, “Na ya'ag sabal tanori, tepnange peram uro wamna. ");
INSERT INTO kkl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ane sembe yin pusap topmendi, paiag pham winang mana ol pina payalulam. ");
INSERT INTO kkl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Payingkina sao wali uro yobamenba, teneri, na anam teban komag Allah siag an kipkenun,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ishakti Esau ambarelamogha Ribkari ka'ebaogti, Esau paiag sip ol piogpa, ");
INSERT INTO kkl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka nenekori Yakub ambarelamogti, “Name, Aniri Esau ambarelamlaba, ka'ebanne ane ka'eapmen, ");
INSERT INTO kkl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Paiag ol pimendi, wali uro yobongkia tarelanemenba, teneri na anam teban komag NUNI Allah siag kipkenun,' selne ka'eban. ");
INSERT INTO kkl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ane sembe, name, nari ambatkinunne sunsunum uro ualulam. ");
INSERT INTO kkl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pham mo'olamabag pimendi, pham kambing me phende topmendi, na tarelanemenba, nari yobaneba, andi poa pimenba, ani awi yeng uro telul. ");
INSERT INTO kkl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Poa pimenba, teleri, el anam teban komag Allah siag kipkelul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ambarogpa Yakub nenekori ambarelamogti, “Nanin, Esau neneko nong hong maikno, na nong hong orog aneno. ");
INSERT INTO kkl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Na naniri na konag salelamneleri, 'Orolena lepla,' aro na Allah siag kipnen koma yo'obaneleag,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Wene aro ambarogpa, ilindi, “Name, yo'obahilulne nene nanag talulba, wanag keyagman uro nari lepnange sunsunum uro pham kambing abeneko tol pululam,” seogpa, ");
INSERT INTO kkl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakub nenekori pham kambing abeneko tol piogti, ilin tarel aogpa, “Ishakti wali yeng uro tilul” aro ilindi wali uro yobaog. ");
INSERT INTO kkl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Yobaogti Ribka nenekori aeag wa'iogti, ag Esauri eneka uropne walinge aeag piamsiogne tobogti, Yakub enekirog. ");
INSERT INTO kkl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Enekirogti pham kambing kon logto pibogne tobogti, ni phende saeag enekto kaubirogti, ko'olomag enekto kaupto, “Iliri, 'Esauri hong,' sembalul,” aro enekto kaubirog. ");
INSERT INTO kkl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Enekto kaubirogti, sao wali uro yobaogha tanekoap kwaneng roti werebaogha tanekoap Yakub tarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tarogpa pabiogti, “Nani,” aro kibogpa, Ishak nenekori, “Name, anna Esauro Yakubto?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Wene seogpa Yakub nenekori, “Na anme yandonge Esau neneko yan. Andi ambatnelamne sunsunum uro pai pham oro yoro payandi, pukmendi telame! Temendi Allah siag kipnululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ambarogpa Ishak nenekori, “Name, elemag oplamdi, yoro payalam,” seogpa Yakubti, “NUNI Allah nenekori whingag nembatnelba payan,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Wene seogpa Ishak nenekori Yakubag, “An nong kon salbitkeneri, 'Otsik uro Esau yal,' aro el tanululba, abene yae!” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Wene seogpa Yakub neneko ili peramag piogpa, sae nong konag salelamogti, “Yubu Yakubti yubu saog ka'elamna agha sae Esauri sae saog salelamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yakub sae pham kambing hong kauptopti, “Esauri sae hong pongoropne saog uro wamla,” aro Ishakti, “Esau yal,” sembaogti, “Allah siag kipnun,” sembaog aghana nen hailamogti, ");
INSERT INTO kkl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“An otsik uro Esau yalam?” aro haibaogpa, Yakub nenekori, “Nani, otsik uro na Esau neneko yan,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Wene seogpa Ishakti, “Yoro payalama taneko tatnemenba, teneri, NUNI Allah siag kipkinun,” aro ambarogpa, sop yoroba anekoap mag anggurap tarel piogpa, teog. ");
INSERT INTO kkl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Teogti, “Name, na peramag abene yamendi somoro saelbamnululam,” aro ambarogpa, ");
INSERT INTO kkl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakub ili Ishak peramag piogti, nongag somoro saelbamogti, kiplamog. Kiplamogpa, Ishakti Esauri ag song uaogne sembe, “Esau name yandonge,” aro elme Allah siag kiplamogti, “Name, anag agha song yalamlange awe Nani Allahri sai nenelamla saog uro song anag agha yalamla. ");
INSERT INTO kkl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Imag agha Allahri mag tum-tuma pelengel alamleba, so'o andinge sai talamleba, nia mangkina melapmenna so'o eneag maiknoro pongolamlul. ");
INSERT INTO kkl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","As mog so'o nubunge wamikne an yan mombolag amupto pulamikti, an arukna wamukang. Ankabo taneko sikini saog uro an wapmenba, an whingag yabu sanukto pulamukang. An yo'olangkiikne taneko sin loba nenel dalamukang. Nimi etneri kiplangkiikne taneko Allahri o'ona sembe yeplamsilul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ishak nenekori elme Yakub Allah siag kibogpa, lambaom agha palamog abeneko Esau neneko paiag agha yaog. ");
INSERT INTO kkl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eldi babe mana wali sao uro yobaogti, iliag payaogti, yubu lelamogti, “Nani, pukongkia an sembe payana tane telamlulam! Temendi Allah siag kipnululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ambarogpa, Ishak nenekori, “An etneri lelamlam?” seogpa, Esau nenekori, “Na Esau anme samenne nenekori lelamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Seogpa Ishak neneko lo'om aro lagmag seogti, elek-elek alamogti, “An anam yan komag etne yaldi, pham yobarel anel? El nenekori payalne tendi, name yandonge 'Otsik uro yan,' selba, 'Otsik uro yal,' aro NUNI Allah siag kipto lemna anekona nen lemnep kom saog,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ambarogpa Esauri ka'ebaogti, wanaag mali taogpa, yubu haum aro engelamogti, “Nani, na babe! Ani NUNI siag kipnululam,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Molbaogpa Ishak nenekori, “An anipsae neneko yaldi, yubu orolena leplaba, kipna anag ambatkehenenge neneko elag ambatna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Wene seogpa, Esau nenekori yubu lelamogti, “Samenag eldi, 'An yandonge wamlulam kom,' aro yubu nepneori, sumene babe ik phendepne kipna na ambatnepne neneko toro agha pil. Eldamne si Yakub si ahaem engeroba sunsunum uro yubu orolenange lepla. Allahri yepkelul aro kipna nhon ambatnemenne wamla, te?” aro haibaogpa, ");
INSERT INTO kkl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishak nenekori, “Nari anipsae nenekoag, anipsae ani wamlul sekitna. 'Ankabo an arukna wamikpa, an sembe nia mangkina melapmenne maikno talul,' sen. Ane ni ambatna anekona anag wene nari sa'a senep kom saog,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ambarogpa Esau neneko nen yubu mikip uro hailamogti, “Andi Allah siag kipsinne ik nhon leplamdi, nen ik phende lenne orog te? Nani, na babe Allah siag kipnululam!” aro wene seogti, yubu haum aro engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Engelamogpa Ishak nenekori ambarelamogti, “An wamlulamag mag tum-tuma pelengel ananna orogti, so'o mesah uro sai wamlul kom. ");
INSERT INTO kkl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Anenge yindi an piangkeleba, an mal taropne wapmendi, an anipsae arukna wamlulam. An anipsae arukna wamlulam aghana, Andi 'El tamag wamnun kom,' aro sae mikip peleptamendi, eldi arukna wamlulam kom” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau nenekori, “Naniri Allah siag naipsae Yakubog kipla,” aro Yakub sembe karong sembaogti, “Olog wamebea nai tebaleba, Yakub omnun,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esauri, “Naipsae omnun,” alamla ana ka'ebaogti, Ribka nenekori, “Name Yakub yobol phut,” seogpa, Yakub neneko yaogpa, yubu ambarelamogti, “Name, ando Esau neneko 'Wana mali nembaneonge sembe opkinun,' senero wamla. ");
INSERT INTO kkl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ane sembe na anindi lemnunne nene ka'eame: Tognop tangtang pimendi, naro Labanag as Kharan pululam. ");
INSERT INTO kkl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pimendi, elap wamtumunba, andori yo uro seneraglamlange kom talul. ");
INSERT INTO kkl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Andi wana mali nembalumne ekon tale tanena, an enel aghukang aro nimi pogsinun. Ae ik nhon sum agha na namabo ni phende ka'asebel tananne mali senelamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Olog wameka Ribka nenekori Ishakag yubu lelamogti, “Na tungna sap-sabi Het so'o eneag wamang kelabo tane kembi ulamsin. Esauri Het kelabo topsioa saog uro name Yakubti babe Het kelabo topsileba, 'Imnun kom,' aro wali tebanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ishak nenekori Yakub yobogti, Allah siag kibogti, ambarelamogti, “Name, andi Kanaan kelabo topsiseng kom! ");
INSERT INTO kkl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Anin ili Betuelag Aram mog so'oag pimendi, anawang Laban elmangkelabo anabiagne nhon topsululam. ");
INSERT INTO kkl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Allah Imap So'oap Saelbamlange nenekori an mikip nembagheleba, andi mangarobari mangaroba maikno taikti, nimi sisa nubu taukang. ");
INSERT INTO kkl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","NUNI Allahri Abraham o'ona senelamogti, yeplamog saog uro an anmaboap yeplamsileba, so'o an nimi yangkanne saog uro wamlamag ane Allahri Abrahamag, 'Anisag yabo tatsinun,' seogne sunsunum uro a'un ngai talulom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","“A'unin Ribka eldo Labanag Aram mog so'oag pululam,” aro ambarogne sunsunum uro Yakub neneko Aramne Betuel elme Laban wamoghag piog. ");
INSERT INTO kkl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Ishak nenekori elme Yakub Allah siag kibogti, “Kanaan kelabo topsin koma Aram mog so'oag pimendi, Aram kelabo el phululam,” aro ambarog. Yakub neneko ili ilindi leptekne ka'ebaogti, Aram mog so'oag piogne sembe Esau nenekori ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ka'ebaogti, sikini Ishak nenekori, “'Kanaan kelabo tohinne sembe karong', senen,” aro Esau el taogti, ");
INSERT INTO kkl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Abraham elme Ismaelag piogti, elkelabo phende abeneko babe wamdekpa, nen wilindipne Ismael elmangkel Nebayot ilipsa'el Mhalat tobog. ");
INSERT INTO kkl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakub neneko as Bersyeba laplobi agha, “As Kharan punun,” aro piog. ");
INSERT INTO kkl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Palamog pahabog heng puruk aogpa, pioghag anekoa kirik nhon tobogti, kirik aneko agha usog epto malamog. ");
INSERT INTO kkl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Malamogti lenda malamogpa, moromna nhon so'oag agha sekamogpa, imap tibamogpa, Allah ilipsabo malaikat moromna aneko toman kululung walelem alameka ipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kemelamsiogpa, NUNI Allah moromna aneko toman sekamogti, “Anisag Abrahamap, ani Isakap, Sikini Allah Na ane wamna,” seogti, “Nari, 'So'o an malamlamag ane an, anmaboapti ngai taukang,' aro tatsinun. ");
INSERT INTO kkl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Andi mangarobari mangkahyikne taneko so'o lenglenga alirop kom wamla saog uro taikpa, sikininge so'o heng walelingkirobag sip, heng purukul pirobag sip, ople sip, tabo sip maikno talul. Anap anmaboap pere agha Nari nimi sisa ni tala-tala wamikne walingena tatsinun. ");
INSERT INTO kkl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","As tala-tala pimenag Na anap wamnemeri yepto piangkenun. Nari an sae lipken koma wamne pahabog anag Nari lemnange ni ulamneri, mog so'o eneag samoro payakenun,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Wene alamog abeneko Yakub neneko pukogti, yubu lelamogti, “NUNI Allah tane wamlange weneog el tanel!” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","nen yubu lelamogti, “Na wamnaag ane nimiri loghag. As tane Allahri ae wamlaba, imag yangkanne ina siramag wamna,” aro log sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nen mabogti, lukun Yakub seklamogti, “Allah wamlaag ane,” aro, “Kekneba pimnun,” sembaogti, kirik usog epto mabog kirik eneko so'oag mebirogti, kirik anekoag kal saitun wangka lolteroba mag ikog. ");
INSERT INTO kkl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ikogti, samen mog so'o ene Lus engeroba aneko Betel engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Engkaogti Yakub nenekori Allah whingag salag palilamogti, “NUNI Allah nanap nhon palamnemeri, terobap nanenge ag eneknangeap tarelamneleri, yeplamnele pahabog ");
INSERT INTO kkl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","wali uro naniri aeag samoro yane tanena, kekneba na sembe talul. Ni undo saog uro pinep tanena, 'El Allah aghabog nari ukuma wamlul,' aro omeklamnun. ");
INSERT INTO kkl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nia mangkina Eldi tarelamnelea taneko pogto sa'obare palu tobiagha, palu nhon nen samoro El tarelamnun. Kirik mebitnaag ane Allah wamlaag, Eldi ae saog uro talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Undo wene seogti, Yakub neneko Kanaan so'o laplobiagha heng walelingkirobag sip piog. ");
INSERT INTO kkl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","3","Palamogti, tilamogpa, mag sembe wailbaeka nhon peramag pham domba palu wilindi longoro wamekpa, tibogahiog. Ora sum babe pham pia uhirop nang taneko niri sikininge pham mag aneko peram ni yalamekpa, kembiag agha nubu kirik mag ina siram leptop kirik kupto pil pindogha pham taneko mag tebarelamsiekpa, ni telamek tanena sereklamek. ");
INSERT INTO kkl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakub mag aneko peramag piogti, pham taneko pia uhirop nang tanekoag hailamsiogti, “Nangkabo, a'un tala nimi?” seogpa, sindina, “Nu Kharan nimi,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Seekpa Yakub nenekori, “Nahor ilisag Laban neneko olog ililamlom, te?” seogpa, sindi, “Ililamap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Wene seekpa, Yakubti, “El welaro wamla?” seogpa, sindi, “Wali wamla,” seekti, “Elmangkel si Rahel pham domba kambing iliringe poa yalamsil ane tiboghamen,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Seekpa, Yakub nenekori, “Nangkabo, ae imbal komba ae siro wamap, aghana sa'a sembe a'ununge pham poloro pil ahilom? Mag aghabog tebatsimundi, 'Mo salik malik maneng telamukang,' aro poa phululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ambatsiogpa, sindina, “Pham domba pia urop nimi taneko nenneri pham domba ni payahiikpa, mag ina siram kirik kubeberi, 'Mag tebatsukap,' aro tibogto wamap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakub neneko sinap yubu lero wamekpa, Rahel neneko pham iliringe poa yalamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","“Na nanin eldori kelmeri pham domba iliringe poa yalamla,” aro tibog aogti, Yakub neneko mag waliroba peramag piogti, kirik mag inasiram leptopne neneko toro ko'ol piogti, Labandi pham taneko mag tebatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Tebatsiogti, Rahel somoro kibogti, “Nari nawang elmangkelap haiptanam,” aro engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Engelamogti, “Na an ani ilipsa'el Ribka elme yan,” aro ambarog. Ambarogpa, Rahel neneko iliag merero piogti, “Anipsa'el Ribka elme yal,” aro ambarel piog. ");
INSERT INTO kkl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ambarogpa ka'ebaogti, Laban neneko elemag-elemag Yakubag piogti, somoro kibogti, eldi aeag enero poa yaog. Aeag yaekti, Yakub nenekori elag uro yabiogne sembe Laban ambarogpa, ");
INSERT INTO kkl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban nenekori, “Otsik, nari enengdinge agha yalam,” seog. Yakub neneko wal nhon ningki wamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban nenekori Yakubag yubu lelamogti, “An na enengdinge wamlam ana, sa'a sembe nari awe mo webarelamnululam? Kamna etbare tatkenun sembamlam?” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban elmangkelabo samenne Lea wamogpa, amikne Rahel wamog. ");
INSERT INTO kkl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea haing pabo tolaktop saogpa, Rahel saren kemeroba wamogti, haing elela aneko wamog. ");
INSERT INTO kkl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Undo wamdekpa, Yakubti Rahel sembe wana telamogti, “Nawang, an anmangkel amikne neneko toro anundi, nari andi awe welamne pahabog heng kun taibuka taubuka ulamleba heng kun saekbare talul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Wene aro ambarogpa, Laban nenekori, “Name ane nimi orangeri toro aikagti an tatkinundi, an nanap tane wamnunam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wene seogpa, Yakub nenekori, “Rahel toro anun” aro awe welamogha heng kun saekbare taog. Yakubti “Rahel tomnun,” aro wana telamogpa, heng kun saekpare wamog aneko aghana, “Ik a'ilbanep saog uro wamna,” senelamog. ");
INSERT INTO kkl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Wene senelamogha Yakub nenekori Laban ambarelamogti, “Nuri lemnomo saog uro heng kun saekbare awe webanori, anmangkel toro anundi, tatnululam,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Molbaogpa, Laban nenekori, “Namangkel Yakubti toplulne sembe sani yobanun,” aro nimi ni as eneko wamekne yopsiogpa, sani yobaogne teek. ");
INSERT INTO kkl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Teekti, imbaogpa, Laban nenekori elmangkel toro anepne Rahel payan koma, Lea enero Yakub tarel piogpa, nikag maptek. ");
INSERT INTO kkl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Undo unuaog sumeneko Laban nenekori eldi arukna Zilpaag, “Lea arukna wamlulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Lukun Yakub pukogti, kemelamogpa, “Leaap mamnam,” aro el taog. El taogti, Labanag piogti, ambarelamogti, “Sa'a sembe nanag nene saogne ualam? Andi, 'Rahel tatkenun,' seomba, anenge awe welamno aghana, sa'a sembe yubu neplamnelam?” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ambarogpa, Laban nenekori ambarelamogti, “As eneag wamlange agha uan. Eldo'el wamnaba, ilipsa'el samenag nengabori tomnep kom,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“Ane sembe Lea tobomne sembe awi yeng uro seplamebe pahabog, ik saekbare taleba, namangkel Rahel babe tatkenun. Tatkeneba, el sembe kamna nen heng kun saekbare awe naringe welamlulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ambarogne neneko sembe Yakubti, “Hae,” sembaogti, inipna kwelekna saekbare seplamek pahabog, wamekpa, Labandi elmangkel Rahel tarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Undo unuaog sumeneko Laban nenekori el arukna si Bilha nenekoag, “Rahel arukna wamlulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakub neneko Rahelap babe nikag maptek. Yakubti Rahel sembe agha wanaag uro wamogti, Lea sembe olog wana abolag wamog. Sin wamekti, Yakubti Labandi awe nen hengkun saekpare welamog. ");
INSERT INTO kkl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yakub neneko Lea wanaag olog abolag saogti, NUNI Allah kembaogti, “Lea nenekori me mangaro ale,” sembaogti, “Rahel me mangaro an koma wamle,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Wene sembaogpa, Lea me monag taogpa, me nengabo me nhon mangaro aog. Mangaro aogti yubu lelamogti, “Na wana mali uro wamnaba, NANI Allahri imnelba, na na'angeri na babe wanaag sembanele,” aro me aneko si Ruben engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Wameka nen Lea neneko me monag taogpa, me nengabo me nhon mangaro aog. Mangaro aogti, yubu lelamogti, “Na na'angeri o'ona sembamnel komne sembe NANI Allahri ka'ebaneori, me ane babe tatnel,” aro me aneko si Simeon engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wamekti Lea nenekori me nengabo me nhon mangaro aogti, yubu lelamogti, “Me nengabo me wilindi mangkatnonge sembe na'angeri na sembe wanaag uro wamlul,” aro wene seogti, me si Lewi engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Wameka Lea neneko me monag taogpa, me nengabo me mangaro aogti, yubu lelamogti, “Wenenge nene agha Allahag 'NANI' aro kipto omeklamna,” aro me aneko si Yehuda engkaog. Yehuda mangaro yabiogne agha Lea me mangaro an koma wamog. ");
INSERT INTO kkl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lea me mangal dolamogpa, Rahel nenekori, “Naro'el me mangal dolamlaba, na me mangaro an koma wamna,” aro elto'elag wana mali uro seneraglamogti, Yakubag yubu lelamogti, “Me nhon tatnululam kom, tanena na tebanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Wene seogpa, Yakub neneko wanaag yo sembaogti, “Na Allah saog uro wamna kom. El nenekori seneraghogne sunsunum uro an ibili talamlam,” aro Rahel wabaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","4","Wabaogpa, Rahel nenekori yubu lelamogti, “Na arukna Bilhaap maptumunba, eldi me mangaro na ilag pipleba, nari me talul,” aro eldi arukna Bilha aneko ela'ange Yakubag ambarogpa, Yakub elkel wilindipne taog. Yakub neneko Bilha anekoap maptekpa, ");
INSERT INTO kkl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","me monag taogpa, me nengabo me mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Mangaro aogpa, Rahel nenekori yubu lelamogti, “Nari Allahag mololamnoba, ka'ebaneori, nanag sip tangto me nengabo me tatnel,” aro me si Dan engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Wamekti, Bilha nenekori nen sap me nhon monag taogpa, Yakub elme nengabo me mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Mangaro aogpa, Raheldi yubu lelamogti, “Naro'elap talamnomori, na paliag neneptano,” aro me aneko si Naptali engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Wamekti, Lea nenekori, “Me mangaro anep kom saog wamna,” sembaogti, elenge arukna Silpa neneko “Yakub elkel tale,” sembaogti tarog. ");
INSERT INTO kkl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tarogpa, Silpa nenekori me nengabo me nhon Yakub sembe mangkarog. ");
INSERT INTO kkl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Mangkarogpa, Lea nenekori yubu lelamogti, “Na wali neneptan,” aro me si Gad engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Wamekti, Silpa nenekori nen sap me nengabo me nhon mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Mangaro aogpa, Lea nenekori yubu lelamogti, “Na wali kel neneptan. Ora kelabori, 'El wali,' senelamnukang,” aro me aneko si Aser engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wamekti, wal tomneag Ruben neneko paiag piogti, kal wana terobpa me yag tananne sembe terop kal wana tobogti, ilin Lea tarel aog. Ilin Lea tarel aogne Rahel el taogti, yubu lelamogti, “Kal wana anmeri payalne olog tatne,” aro Leaag molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Molbaogpa, Leari yubu lelamogti, “Andi na'ange tobomne sunsunum komdi, wene babe 'Kal wana ane babe tomnun,' aro ulamlam?” aro wabaog. Wabaogpa, Raheldi, “Hae, kal wana anmeri tol pildi, tarel aghelba, tatnemendi andi kamna saog uro inipna Yakubap mapturom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Sinag Yakub aweag agha yalamogpa, Lea whingag piogti ambarelamogti, “Kal wana me yag tananne sembe terop kal wana nameri tol pildi, tarel anelba, nari Rahel tatnange sembe kamna saog uro 'Yakubap mapturom,' selba, sumene nanap mamnunam,” aro ambarog. Ambarogpa, sumeneko inipna Leaap nhon maptek. ");
INSERT INTO kkl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Maptekpa, Leari Allahag mololamogne sunsunum uro me monag taogpa, Leah elme lamne Yakub sembe mangkarog. ");
INSERT INTO kkl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Mangkarogti, yubu lelamogti, “Nanenge arukna aneko na'angeag ambatnonge sembe kamna Allahri tatnel,” aro me si Isakhar engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Wamekti, Lea neneko me monag nhon taogpa, Lea elme no'opne Yakub sembe mangkarog. ");
INSERT INTO kkl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mangkarogti, yubu lelamogti, “Allahri ya'ag tapto walia tatneoba, wene na'ange sembe me no'opne mangkatna anekona eldi na sembe wali sembamneleba, ya'ag ma'aro wamnunam,” aro me si Sebulon engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Wamekti Lea nenekori kel nhon mangaro aogti, kelme si Dina engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Olog wamekti, Allahri Rahel sembe ekon tan koma seneraghogpa, Raheldi mololamogne sunsunum uro me nhon monag taogpa, me nengabo me mangaro aog. Mangaro aogti, Rahel nenekori yubu lelamogti, “Na ali uro wamnonge neneko NANI Allahri kom nembaldi, ");
INSERT INTO kkl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","amik me nengabo me nhon tatnilul,” aro me aneko si Yusup engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raheldi Yusup mangkaogpa, Yakubti Labanag yubu lelamogti, “Weneogna sae limnemenba, nanenge mog so'oag punun. ");
INSERT INTO kkl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nanenge kelabo phendeap, nanenge maboap, sin topsinonge, awang, an el wamlam. Na awe maikno welamnori, topsi. Ane sembe nhon pukap,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Molbaogpa Labandi yubu lelamogti, “Na lia peneheng kom, kekneba wene ulamlange iamnange nia mangkina nanag wamlange Allahri an pere agha yepneo. ");
INSERT INTO kkl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ane sembe, 'Kamna tatnoho,' sembamlamne etbare leplulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Wene seogpa Yakubti lelamogti, “Nawang, awe maikno tolamnange an el wamlam. Pham babe wene andinge maikno talamlange ");
INSERT INTO kkl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","nari pia ulamsinba. Na anam yan komag awangdinge sa'a-sa'a etbare wamo kom, aghana awang wene an nubu taom. NUNI Allahri yepkeonge babe nanag agha. Wene naringe kelabo me sembe awe wero tomnun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Wene seogpa Labandi, “Wene selamba, sa'a agha tatkinun?” seogpa, Yakubti, “Awangdi, sa'a undoba tatneheng kom. Pham andinge nari piamsinun. Ot nari lepnunne nene sembe awangdi, 'Wali,' sululam: ");
INSERT INTO kkl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Na sumene pham kambing domba anabi toman yabalamneri, pham domba me mirinneap, pham kambing domba ma'i ukum siptopneap ni kamna saogne topsunun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Seogti, “Amik ik nhon nari pham kemelapmenba, pham domba kambing hong solomne undo nari pham anabiag wamikpa, ipmen tanena, 'Haogha tobo,' sembalulam. Aghana nari pham anabiag pham hong solomne orogtina, 'Yakub sik urop nimi wamla,' sembalulam” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Wene seogpa Labandi, “Ot andi leplamne neneog uanunam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","“Uanunam,” seog, aghana Yakub anam toro pil phiog kom agha sumeneko babe Labandi, “Yakub mane ulamna,” aro eldi pham kambing yemne kelneap, parektopneap, hong yogto-yogto siriktopneap, ma'i ukum siptopneap, domba me mirinne babe, ni taneko toro Labandi elmaboag, “Weag pham yag lambahukap,” seog. Wene seogpa, Labanap elmaboapti tognoro yag lambahiekti, Yakub laploa palamekti, inaag inipna ik wilindi maro piek. Maro piekpa Yakubti pham Labandinge nen laplopsiekne yae uro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yae uro wamogti, Yakubti ere saog kal tunguna sae erenne sae nhon tobogti, kon septo tobog. Kon septo tobogti, kal pun solomne kemelamog. ");
INSERT INTO kkl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kemelamogti, tunguna kon septo tobogne ane pabiog. Pabiognena, pham kwaneng mag terobag pham yaekti, lop phamap kel phamap nebel talamikti, yina tobukang senenag aneko tunguna ikog. ");
INSERT INTO kkl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tunguna ikoghag lop pham kel pham nebel talamekti, pham ma'i ukum siktopneap, parektopneap, yogto-yogto siriktopneap, mangal talamek. ");
INSERT INTO kkl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubti kemelamogpa, pham maikno taikpa, mangal talamekne Yakubti pham me pogto, Labandinge nenag palilamog, el damnangdinge nenag sip palilamog. Palilamsiogti, pham Labandinge ma'i ukum siptopneap, parektopneap, yogto-yogto siriktopneap wamekne ane yogto pabihiogti, “Nandam pham maikno taukang,” aro eldi pham whingag wimbahiog. Labandi pham nhonag Yakubti pham nhonag mo'olamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","42","Mo'olamsiogti, pham me mangap taukang arobag kame aneko iklamog. Sikin kwaneng mag telamekti, “Anea mangal talamukang,” aro eldi kame tunguna palilamog. Mikipne whingag sip tunguna palilamog, aghana mikip komne sembe palilamog kom. Ane sembe mikipne mangal talamekne Yakub saeag talamogpa, mikip komne mangal talamekne Laban saeag talamog. ");
INSERT INTO kkl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Unulamogti, Yakub pham tupne taog. Eldi aruknaap, kelaboap, nengaboap, maikno wamek. Eldi popsirop pham untaap, keledaiap babe maikno wamog. ");
INSERT INTO kkl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakub tupne taogti, olog wamogpa, Laban elmabori yubu lelamekti, “Yakubti nuni yongdinge sae agha nia mangkina tolamlari, nia mangkina tup talamla,” alameka Yakubti ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ka'ebaogti, Laban whingag babe kemelamogpa, samenag wali ulamdek saog uro kom. ");
INSERT INTO kkl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Unulamogpa NUNI Allahri Yakubag yubu lelamogti, “An sambamendi, aniri asag samoro ankabo wamangag pululam. Nari an yepto piangkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Wene seogpa, Yakubti nimiag yubu palilamogti, “Rahelap Leaap na wamnaag aldes pham pia ulamsinag yarukang,” aro yopsiog. ");
INSERT INTO kkl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yopsiogpa, yarekpa, yubu ambarelamsiogti, “Nari wene a'uni whingag kemelamnaba, samenag wamnomo saog uro wali wamla kom. Aghana nari nai ili Allahri yepto piamnel,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","7","Ambatsiogti, “A'un babe el wamdom. Samenag na awe tolamnori, a'uni sembe mikip uro welamno. Welamnoba, a'uniri, 'Kamna wali uro tatkinun,' seog, aghana kamna kapnen koma yubuog ik sa'obare lelobog. Ane sembe Allahri, 'Labandi Yakub opleag aro Nari piamnun,' sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A'uniri lelamori, 'Pham kambing ma'i ukum siptopne awe welamlamne sembe kamna an talulam,' alamo tanena ni phamdi ma'i ukum siptopne mangalamong. 'Pham hong yogto-yogto siriktopne an talulam,' alamo tanena ni phamdi hong yogto-yogto siriktopne mangalamong. ");
INSERT INTO kkl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Undo wene aro ambarelamneoghag anekoa Allahri a'uniringe tolamori, nanag tatneo,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nen ambatsiogti, “Ik nhon sum lenda maro kemelamsiba, pham taneko yina tomneba liag, yem pham taneko ma'i ukum siptopne phamap, hong yogto siriktop phamapti kel phamag walelamsiekpa, kembahisi. ");
INSERT INTO kkl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Allahri babe eldi arukna malaikat pere agha lenda toman ambarelamneogti, 'Yakub,' seogpa nari, 'Ya Nani Allah,' sehiba, ");
INSERT INTO kkl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eldi yubu lelamogti, 'Nari Labandi anag ulamlange nene Nari kembamnaba, whing epmendi tibog amen. Pham yemne wamangneri kel pham kambing dombaag walelamangne hong yogto-yogto, ma'i ukum siptopne ubu piamang. ");
INSERT INTO kkl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Na Allah Betel wamlumag lag tahinge poneko. Lag tahiba, kirik wepto mebitlumdi, kal saitun wangka lolteroba kirik alibag iklumdi, salag leplum. Ane sembe wene sekmendi, anenge aba wamlange togto amendi, mog so'o eneag agha lambamendi, ankabori so'oag pululam,' seog,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Wene aro Yakubti eldi kelabo Rahelap, Leaap ambatsiogpa, sindina, “Nun sembe nuniri saeagha poghatsinep kom, te? ");
INSERT INTO kkl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nuna nimi yanan nimi sembamsil. Nu, eldi kamna kapto toro aori ni abeneko ni teo. ");
INSERT INTO kkl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nia Allahri nuri nairi saeag agha tobonge nenena nu babe ngai apna numaboap sembe. Allahri ambatkeonge nene sunsunum uro 'Uanun,' sembalamne nenena ualulam. Nene sembe tamna orog,” aro ambatek. ");
INSERT INTO kkl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Wene aro ambatekpa, Yakub kelabo meap pham unta alibag towalengkipsiogti, eldi pham longoro pabil ahiogti, nia mangkina Aram puluag agha el saeag taogne tobogti, Ili Ishak Kanaan wamoghag “Pukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Rahel sikini Laban pham domba hong karepto tol pilamogpa, elmangkel Raheldi haogha mema ae lomag phap tangtoba iliringe tol piog. ");
INSERT INTO kkl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iliringe tol piogpa, Yakubti elyamal Labanag ambatto koma mane ulamogti, Yakub kelabo meap sin tognop tangto piek. ");
INSERT INTO kkl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tognop tangto sikinengaba wamsiogha poro agha mag Efrat kauro yim Gilead sip piek. ");
INSERT INTO kkl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Laban poneko ik wilindi wamogha Yakub pio ana ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ka'ebaogti eldi nimi poloro wimbahiogpa, Yakub sarekerepto palamekti, inaag ik saekbare maro palamekti, yim Gilead lambaek. ");
INSERT INTO kkl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lambaekti, pina mamekpa, lenda toman Allahri Labanag yubu lelamogti, “Andi Yakubag yubu kiki nhon babe, hakto aro yubu elag babe, lepseng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakub samenag piogti, ae kalun ae yimag Gilead aneko sobaog. Laban ilipsaboap babe Yakub sarekerepto piogti, eldi babe yim enekoag agha nhonag ae kalun ae sobaek. ");
INSERT INTO kkl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Piogti Labandi Yakubag yubu lelamogti, “Sa'a sembe andi haing kumbaneomdi, kelmabo naringe malag agha pelopto topsilo saog uaom? ");
INSERT INTO kkl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Sa'a sembe yubu koma yaomdi, mane nembaneom? Sa'a sembe nanag ambatneom kom? Nanag ambatnhomba, sepna septo wana waliag pogkhene. ");
INSERT INTO kkl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nanag babe olog ambatnhomba, namangkelabo olog somoro kibitsiseneba, peheng. Andi uaomne nene olog mali uro uaom. ");
INSERT INTO kkl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na wanaag yo uaneoba, 'Nari opkenep' sembano, aghana ani Ili Allahri inipnag yubu lelamlari, 'Andi Yakubag yubu kiki nhon babe, hakto aro yubu babe, elag lepseng kom,' sel. ");
INSERT INTO kkl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ane sembe wene an aniri aeag panne sembe wana telangkelba, 'Punun,' sembalam, aghana sa'a sembe nanenge mema haogha tomneom?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Wene seogpa, Yakubti elyamal Labanag yubu lelamogti, “Na an yubu ambatken koma yanongena, anmangkelabo tane andi, 'Peheng kom,' aro, 'Salero pipsimenag,' aro yubu koma yano,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ambarogti nen mema aneko sembe yubu ambarelamogti, “Na yamal, mema tane nu yalamobo nimiri haogha tobobori, payaboba, ipmen tanena el neneko oplulam. Kembalulam, andinge aba tane payaboa 'Nhon wamlaro,' ipmenba, wamle tanena toplulam. Nuri nimi tane kembamsikba, sindi haingag,” seog. Yubu wene aro lebogne nene Raheldi iliri mema tobogne neneko Yakub ekondi, lebog. ");
INSERT INTO kkl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Wene seogpa, Laban neneko “Mema aneko ebanun,” aro Yakubti aeag samenag wa'iogti, sen-sena ebaogba, orog. Anea Leari aeag wa'iogti, sen-sena ebaogpa, orog. Yakubti kelabori arukna phende abenekori aeag wa'iogti, sen-sen agha ebaog aghana olog imna kom. ");
INSERT INTO kkl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Imna komdi, “Raheldi aeag ebanun,” agha wa'iog aghana Raheldi ili Labanag, “Nani, wabaneheng kom. Na wal palamnari, puro seknange babe eraruk,” seog. Wene seog, aghana anam ili Raheldi aeag wa'in komag Raheldi mema aneko tobom agha pham unta alibag yangaro puroba aneko tosaelbom agha lilbiagha so'oag yangaro pukog. Yangaro pukogpa, Laban neneko sen-sen agha ebaogpa, olog ibog kom. ");
INSERT INTO kkl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Olog ibog koma sembe Yakub wanaag yo taogpa, elyamalag walamogti, “Na yamal, sa'a yoaba uanoa sembe sarenelepto elamnelam? ");
INSERT INTO kkl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sa'a agha iplam? Nari tomnonge andala? Sa'a sembe sarenelepto yaomdi, ae naringe kwerekto sen-sen agha ebanelam? Na nimi yonge wamna kom. Wene andinge nari payanonge pilapmenba, andi nimiap nari nimiapti kembaikti, tam karebaukangpa,” aro walamog. ");
INSERT INTO kkl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Walamogti, “Na anap nhon wamnomonge heng kun lintara bare wamnoa andinge pham domba kambing me mangal anahina babe orog, nari pham andinge tena babe orog. ");
INSERT INTO kkl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","'Si yoabari oro tenba, ane unual,' aro anag ambarel anaghenne babe orog. Undo si yoabari ten tanena, naba nari mo lumbanep. Nimiri haogha yo'obi tomnange babe, inipnag tomnange babe, yamal, 'Andi lumbalulam,' aro ambatnerop. ");
INSERT INTO kkl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Pham yae ulamel no, yo'obi heng eneriba telamnelo, inipnag son eneba son sek lelamel no, kwahing ae mana ane babe puka malamel no. ");
INSERT INTO kkl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Na yamal, anag pham yae seklero pia ulamsisia heng kun lin tarabare ane. Heng kun mekbare an mangkelabo kelabo topsinepne sembe topsi. Heng kun no'opbare pham andinge na tanepne sembe topsi. Andi, 'Kamna alikinag uro kamna kapkenun,' silum, aghana ik sa'obare ane yubu anda leloplum. ");
INSERT INTO kkl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nani Ishakap, ili Abrahamapti log sembamdekti, Si lelamdekne ponekori kembamnele komdi, lilomnhomba, sae agha koma waildam phene. Aghana seklelamnori, ulamnonge kembaneori, Allahri inipnag karepto pelengelal,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Wene seogpa, Labandi Yakubag yubu lelamogti, “Kelmabo abene namangkelabo, sindi mabo na namabo, pham tane babe naringe. Ane sembe wene ane sa'a agha nari kelmaboap nanisag mangaro arongneap sembe sa'a agha uanun?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Seogti, “Ane sembe, anap nanap yubu nikne ya'ag lero pimnemeri, 'Ekon tanemeag,' aro kekneba nhon karebanemeri, ya'ag el wamnunam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Wene seogpa Yakubti kirik nhon tobom agha el ua una sembe mebirog. ");
INSERT INTO kkl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Mebirogti, elmaboag yubu lelamogti, “Kirik wimbalulom,” seog. Wene seogpa, wimbaekpa, kirik wimbaekag aneko pukamekti, kwaneng teek. ");
INSERT INTO kkl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Kwaneng teekti, Laban ponekori, “Sumene kirik wimbanama ane anap nanap el uro wamnunama,” seogti, kirik mero wimbarekag aneko “Yegar-Sahaduta” aro engkaogpa, Yakubti eldi yubuag “Galed” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nen Labandi, “An moag na moag wamnemeba, Nuni Allahri, 'Yubu nikne lemnamne sunsunum uro uanunam,' aro yae ua uamsilul,” aro sina “Mispa” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labandi nen nhon babe lelamogti, “Andi namangkelaboag malia ulapmendi, kelabo nenne tolamsimenba, nimiri iangkukang kom aghana seneragamlulam: Allahri haingdi kembamsilul,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","“Ane kirik poloroba nari pimna. Kirik ane sekiagha an anabi na anabiag irikna wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Seogti, “Kirik winiro pimnama aneap kirik memnama aneapti nu ambareamsilne nari kirik winiro pimnama ane phibom agha anag nari yoaba uanun kom, andi babe phibom agha nanag yoaba ulalulam kom. ");
INSERT INTO kkl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Anisag Abraham Ili mem siap, nanisag Nahor mem siap, Sindi ukuma mem siap, mem si abenekori nunag tam karebaukangne nun anabiag wamlul,” aro seog. Ane sembe si “Mispa” engkaog. Seogpa, Yakubti ili Ishakti ukuma mem siag lero Labanag salag yubu lebog. ");
INSERT INTO kkl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Salag yubu lebogti, pham nhon oro Allah sembe yimag aneko tabogti, elkabo eldi nimi poloro wimbahiogti, sin aneko tenaba tero yimag aneko mabek. ");
INSERT INTO kkl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mabeka kwelekaogpa, lukunapne neneko Labandi elmangkelabori kelmabo maboap somoro togtog aro kipsiogti, elmangkelabo babe kipsiogti, “Wali wamlulom,” aro pat pipsiogti, elengeag samoro piog. ");
INSERT INTO kkl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakub neneko, “Nanengeag punun,” aro inaag palamogpa, Allah Ilipsabo malaikat elag yalamek. ");
INSERT INTO kkl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yalameka tibogahiogti, Yakub nenekori, “Allah Ilipsabo yin saleropnang longorobagna ane,” aro as aneko Mahanaim engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakub nenekori nimi etpare eldi aruknaag, “Naro Esau Seir mog so'o Edom wamlaag pululom,” aro pogsiog. ");
INSERT INTO kkl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Poglamsiogti, “Pimundi ambatlulomne ane: 'Na Yakub, anme. Na wene wamnange nuri awang Labanap sekel anan nimi saog uro wamnori, wene og yalamna. ");
INSERT INTO kkl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Wene wamnange arukna kabuniap kelaboap, pham sapi, keledai, domba, kambingap nari saeag wamlaba, wene yanunne sembe, “Nai, andi awi yeng sembalulam,” aro yubu ane palilamna. Nari nimi tane pogsinne na yanunne sembe an ambatkiikpa, wana sepsebek uro wamlulam,' aro ambatlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Esauag pina samoro Yakubag yaekti, ambarelamekti, “Nani, ando Esau pina kemelamoboba, ando neneko 'Naipsaeap haiptanunam,' aro nimi teng naual tarabare (400) wimbahioba, elap yalamongba, kembitsibori yalamap,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","8","Ambarekpa Yakub neneko log maikno sembaogti, wanaag senaraglamogti, “Namaboap nanenge pham ni tanekoap anabiag pogto palu phende a'ero pimne, tanena Esauri nhon palu olamsile, tanena palu nhon ka'eseptaukang,” sembaogti, palu phende poloro wimbahiog. ");
INSERT INTO kkl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Undo unuaogti, Yakub nenekori molona lelamogti, “Nanisag Abrahamdi elme Ishakap Sikini Allah wamlamne, Nani, Andi ambarelamneomdi, 'Andinge as taptopne ankabo wamangag pululam. Nari an piangkeneba, wali uro wamlulam,' aro nanag salag lebom. ");
INSERT INTO kkl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na malinge wamna, aghana Andi na o'ona sembamlumdi, samen yepnelum saog uro yeplamnelum. Na nanenge as laplobiagha lambahi sum sa'a-sa'a toro an koma kame tunguna aghabog toro salero agha mag Yordan kauro pihi, aghana wene samoro yalamnari, namaboap nanenge phamap kong phende yalamap. ");
INSERT INTO kkl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Naro Esau neneko yaleri, 'Naringe kelabo meap opsileag,' aro log uro wamap. 'An saeag agha taulbahilulam,' aro mololangken. ");
INSERT INTO kkl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Andi na ambarelamnelumdi, 'Nari an piangkene pahabog anisag yabo mag kirik a'angkea mag abolag to'op tangkamla saog uro wamleba, ailbanep kom saog wamlul,' aro ambatnelumne neneko sembe seneraglulam!” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Ambarogti wanag agha seneraglamogti, “Esau wana wali nenenne sembe, 'Naringe pham nenne pabululom,' aro naipsabo arukahineri, na tane wamnun,” sembaogti, pham kambing kelne teng linbareap, yemne lintarabareap, pham domba kelne teng linbareap, yemne lintarabareap, pham sapi kelne teng nhon epto naualbareap, yemne sa'obareap, nimi poahirop pham unta teng nhon epto wilindiri maum tinilamsiekne nongap meap, popsirop pham keledai kelne lintarabareap, yemne sa'obareap, ni ane tobogti, ");
INSERT INTO kkl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","aero-aero kerekto wimbahiog. Kerekto wimbahiogti, ilipsabo ambarelamsiogti, “Na tane mamnundi, nikag taikag aro a'undi aero-aero popsimundi, samenag pululom. Inaag aero-aero palapmundi, nenne samenag pumunba, nenne amik pukang,” aro ambatsiogti, ");
INSERT INTO kkl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","“Samenag pulul,” sembaogne neneko ambarelamogti, “Tonge Esauap haiptarumundi, eldi hailogkeleri, 'Anna anina etne? A'un tala palamlom? Etneri pham agha payalamlom?' aro haibaghaleba, ");
INSERT INTO kkl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","andi ambarelapmendi, 'Andi arukna Yakubtinge payalamna. “Nani Esau sembe pabululom,” selba, tarel alangkeap. Andi arukna Yakub neneko amik yalamla,' sululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Ilipsabo “Pham pabukang,” sembaog nang eneko ni wene aro ambatoba yabihiog. Yakub nenekori, “'Esau wana wali nembanun,' aro pham taneko poa naipsabo samenag arukahineri, na amik pineba, Esauri, 'Wali,' sembalul,” aro seneraghogha sunsunum uro ");
INSERT INTO kkl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","pham wepto tobeka taneko samenag poa palamekpa, el mo aghabog ae kalun aeag aneko mabog. ");
INSERT INTO kkl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Yakub neneko inipnag pukogti, elkelabo phendeap, eldi arukna phende kelaboap, elmabo ko'olombareap samenne mag Yabog kauro tara sip pil phiogti, el neneko samoro yaogti, elenge phamap eldinge ni tanekoap, “Mag Yabog kauro tara sip pabululom,” aro pogsiogpa, pil phiekpa, ");
INSERT INTO kkl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","el mo wamog. El mo wamogpa, nimi nhon elag yaogti, Yakub saelbaogpa, sin phende ko'olomoghol talamdek pahabog ae kwelekaog. ");
INSERT INTO kkl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ae kwelekaogpa nimi neneko, “Yakub mikipti nari el oro luknubanep kom,” aro el taogti, Yakubti yan il su kopkop tiptobag wenelobog. ");
INSERT INTO kkl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Wenelobogti, nimi nenekori yubu lelamogti, “Heng yanualba, na sae limne,” seogpa, Yakubti, “Allah siag kipnemen tanena sae lipkenun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Wene seogpa, nimi enekori, “An sina etne?” aro haibaogpa, “Na Yakub,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Na Yakub,” seogpa, nimi enekori ambarelamogti, “An si Yakub alamukang kom. Andi Allahap nimiap babe talamlamdi, mikip talamba, an si Israel alamukang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Wene aro ambarogpa, Yakub nenekori, “An si lag phoro ambatne!” seogpa, nimi enekori, “Sa'a sembe na si lag phoro ambatkenun?” aro ambarogti, Yakub “Wali wamlulam,” aro kibog. ");
INSERT INTO kkl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Undo unuaogpa, Yakub nenekori yubu lelamogti, “Nari Allah whing imna, aghana na teban kom,” aro undo unuarekag aneko Peniel engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Engkaogti heng yalamogpa, Peniel aneko laplobiagha palamogti, yan il komobaogne nenekori yan keamtiro palamog. ");
INSERT INTO kkl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nimi nenekori Yakub yan il komopto obog ane sembe, Israel nimi sumene babe pham yan tombarea il pangkal sop melmel telamang kom. ");
INSERT INTO kkl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Palamekti, Yakubti tilamogpa, Esau eldi arukna nimi teng naual tarabareap (400) yalamek. Yalamekpa, tibogahiogti, Yakubti mabo ni tane wamekne pogto, nenne Leaag nembahiogti, nenne Rahelag nembahiogti, nenne eldi arukna phende kelabo abenekoag nembahiog. ");
INSERT INTO kkl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Eldi arukna phende kelabo abeneko sikin maboap usoghag nembahiogti, Lea elmaboap nusamag nembahiogti, Rahel elme Yusupap amik nembahiogpa, palamek. ");
INSERT INTO kkl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakub samenag menangkaogti, yabu sanukto pulingkiro palamogti, ik saek bare yabu sanukto pulingkiogti, eldo peramag piog. ");
INSERT INTO kkl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eldo peramag piogpa, eldori, “Naipsae,” aro merea somoro salel piogpa, kiptangto engeltalamdek. ");
INSERT INTO kkl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esauri Yakubti kelabo me kembahiogti, “Tane et nimi?” aro haibaogpa, Yakubti, “Tanena nari kelabo mabo. Allah wana waliri tatneonge,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Wene seogpa, eldi arukna eldi kelabo nembahiogne abeneko sikin maboap Esau whingag yabu sanukto pulingkiek. ");
INSERT INTO kkl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ane Lea elmaboap Esau whingag yabu sanukto pulingkiek. Ane Yusup ilin Rahelap Esau whingag yabu sanukto pulingkirek. ");
INSERT INTO kkl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Pulingkiekpa Esauri yubu lelamogti, “Wela sembalamdi, nimiap phamap pogsilamne haiptaapne nene?” seogpa Yakubti, “Naro, andi o'ona sembahilulam,” aro seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Wene seogpa, eldo Esauri Yakubag, “Naipsae, nanag sae agha maikno wamla. Andi na nen tatneheng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Wene seogpa Yakubti, “Undo kom. Andi o'ona sembanelamba, nari saeag agha tatkenne toro alulam. Haiptanamdi, andi whing kembaghendi, Allahri whing iplo saog uro an naro nari ipken. Ane sembe na wana wali,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Seogti, “Nari payandi, tatkenne nene nu kiptangto sembe tatkendi, toro alulam. Allah wana waliri nanag kwema senelamnonge maikno tatneo, ane sembe lipseng kom,” aro mikip lelamogha sembe tobog. ");
INSERT INTO kkl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Wene alamogpa, tarogha taneko tobogti, yubu lelamogti, “Wene nhon togheberi, nhon palamukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","14","Wene seog, aghana Yakubti lelamogti, “Naro, el wamlam, me tanena elemag pinep kom saog, apna pham me maum telamangneap. Ik nhon sum elemag pana babe pham tane tebanepti, an samenag palapmenba, na amik nemen-nemen meap phamap yan nginikom agha palamika sunsunum uro Seir mog so'o pina wapmenag yanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Wene seogpa Esauri, “Wene selam, tanena nari arukna me etbare undo piloa phinun,” seogpa, Yakubti, “Mo palamebea na sembe ikin sembaheng kom. Naro, na sembe awi senelamnelamba, ot an sembe na yeng,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Wene seogti, Esau sumeneko sum elsam Edom piog. ");
INSERT INTO kkl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Esau Edom palamogpa, Yakub Sukot piogti, ae eldamne sembe soro eldi pham tanekoap sembe babe kalun ae sobaog. Ane sembe mog so'o si ane Sukot engerop. ");
INSERT INTO kkl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakub Aram so'oag agha Kanaan so'oag as Sikhem piogha, wali uro piogti, as Sikhem peramag ae soro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ae soro wamoghag aneko mog so'o aneko Hamor sisa nimiringe. Sikhem poneko babe Hamor elme wamog. Yakubti, “Mog so'o wene wamnaag aneko naringe ya'ag wamlul,” aro kamna kapto kirik wana solomne teng tombare (100) agha kamna kapto tobog. ");
INSERT INTO kkl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Toboghag aneko Allah sembe si lero mhong towalengenag sobaogti, si “El Elohe Israel” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","As Sikhem peramag wamekti, Yakubap Leaap sikin mangkel Dinari, “As Sikhem kelabo kemel pihinun,” aro piog. ");
INSERT INTO kkl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Palamogpa, mog so'o ene saelbamogne Hemor elme Sikhem, sin sisa Hewi nimi. Elme Sikhemdi Dina poa piogti, saelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Saelbaogti, Sikhemdi, “Yakub elmangkel topsene,” agha wana telamog, apna “Dinari wana nanag wamso,” senelamog. ");
INSERT INTO kkl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ane sembe elme Sikhemdi ili Hemorag yubu lelamogti, “Kel saren ene na-anme toatnululam, 'Na el topsene,' senalamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakub ka'elamogpa, “Sikhemdi elmangkel Dina saelbal,” seeka ka'ebaogti, “Namabo phamag yae wamanga yingkiamna komdi,” sembaogti, yubu koma wamog. ");
INSERT INTO kkl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Yubu koma wamogpa, Sikhem ili Hemor “Yubu lemnunam,” aro Yakub wamoghag piog. ");
INSERT INTO kkl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","“Yubu lemnunam,” aro ulamdek abeneko, Yakub elmabo babe pham yae wameka yaekti, Sikhemdi sikinipsa'el saelbaogne sembe sin wanaag yo uahiog. Sikhemdi Yakub elmangkel saelbaogne nene uanep komne uaogne neneri Israel nimi ali nembahiogpa, sin wana sesog tahiog. ");
INSERT INTO kkl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","9","“Yubu lemnunam,” aro Hemorti Yakub elmaboapag yubu lelamogti, “Na name andi kelmeag wana telamlaba, andi lepmenne agha nari me andi kelme toplul,” seog. Seogti, “Nuri yubu saekag lero pimnunamne kelabo andi kelmabo nuri kelmabo tol talamukap. ");
INSERT INTO kkl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Undo unuaberi, Nai, an nunap wali so'o eneag wameberi, anba andi, “Wamnun” senenag wamlulam. A'unba a'undi, “Wamukap” senenag soro wa'imundi, awe wero saeagha maikno neneptangto wamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Sikhemdi Dina iliap eldo yaboag ambarelamsiogti, “Na kel ane tatnululom. Tatnemunba, a'undi 'Kwema' simuna babe tatsineri, 'Kelabo sabogha abene,' aro molbanumuna babe tatsinun,” aro molbahiog. ");
INSERT INTO kkl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","14","Wene seogpa, Yakub elmabori sikinipsa'el saelbaogha sembe orolena yubu ili elme Hemorap Sikhemap samoro ambarelamsiekti, “Nunipsa'el kon teptop kom nengaboag nuri tatsina nu ali. ");
INSERT INTO kkl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nunipsa'el tomnep tanena nuri lebebenge sarenelebamun taneogna hae. A'un kabuni ni wamlomne kon teptamundi, nu saog tamun taneogna, ");
INSERT INTO kkl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","nuri kelmabo babe a'undi tolamsimunba, nuri babe a'undi kelmabo topsiberi, a'unap wameberi, nun as nhon taukap. ");
INSERT INTO kkl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wene seapne ka'ebamundi, kon teptamun kom, tanena nuri kelme toro aberi pukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Wene seekpa, ili elme Hemorap Sikhemapti, “Wali lebang,” sembarek. ");
INSERT INTO kkl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sembarekti, Sikhemdi “Dina toro hanne,” senenne wana lololamogpa, nimi sisa Sikhemdi nimi sisa el agha yubu lenne wamogti, “Elem-elem uaukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ili elme Hemorap Sikhemap nimi yubu lero haiptangtobag ina siramag pirekti, as eneko nimi ambarelamsirekti, ");
INSERT INTO kkl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Nuri mog so'o ene sabo wamla, ane sembe nungkabo, Yakub poneko elmaboap agha yingkina wamangne nunap wamukap. Sin nunag walia ulamsiangba, mog so'o eneag wamikti, sinba sindi 'Uaukap,' senena uro wamukang. Nuri sindi kelmabo hae tolamsukap, sindi babe nuri kelmabo hae tolamsukang. ");
INSERT INTO kkl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Israel nimiap nun nhon wameberi, nun as nhon taukapnena, sindi uropne nuri babe uaukapnena, 'Kabuni ni wamapne kon teptaukap.' ");
INSERT INTO kkl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Undo unuabeba, sindi pham, sindi sae agha nun saeag talul. Sindi lebangneag sarekerebabeba, sin nunap wamukap,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wene aro ambatsirekpa, nimi ni yubu lero haiptangtobag as ina siramag yaek nimi taneko ka'ebaekti, nimi kaubuni as eneko kon kareptangtang piek. ");
INSERT INTO kkl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kon kareptaekneri, ogti wamekpa, ik wilindip sum Yakub elmabo phende Dina eldo Simeonap Lewiap karog nhondi nhon nhondi nhon toptekti, as enekoag wa'irekti, kabuni ni opsirek. ");
INSERT INTO kkl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ili elme Hemorap Sikhemap babe opsirekti, sikinipsa'el aeag anekoa poa lambarek. ");
INSERT INTO kkl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Sikinipsa'el saleroba sembe tiro opsirekpa, Yakub elmabo nenne wa'ina hohola nia mangkina talupto topsiek. ");
INSERT INTO kkl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yakub elmabo wa'ina lebekti, pham kambing, domba, sapi, keledai toro palamogpa, nia mangkina paiagneap aeagneap topsiek. ");
INSERT INTO kkl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kelabo me babe toro wimbahiek. Nia mangkina kamna alikinag uro toroba sa'a-sa'a ni aeag wamogha ane ni topsiek. ");
INSERT INTO kkl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Topsiekpa, Yakubti Simeonap Lewiap sin phendeag lelamogti, “Namabo, a'undi na loba nembanerom. Wene Feris nimiap Kanaan nimiap as ene nimiapti nanag wana mali pipneang. Nunna nimi etbare kom. Sin ma'aptaikti, nu oro luknubahukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wene seogpa, sindina, “Sa'a sembe nunipsa'el ina yabirop kel nembangpa?” serek. ");
INSERT INTO kkl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Wamogpa Allahri Yakubag yubu lelamogti, “Ando Esau sembe logti palumba, Na Nani Allah an whingag lag tahinge nenekori lelamna. Lag tahiag aneko as Betel pimendi, wapmendi, Na sembe mhong towalengenag sobanululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Ambarogpa Yakub nenekori elkelabo elmabo nimi elap wamekne taneko ambarelamsiogti, “Na wana ikin uro wamsiba, Allahri yepneogti, tala palamsiag babe yeplamneogne sembe mhong towalengenag sobanundi, as ene lilobiagha Betel pukap. Ane sembe mema as yogneag piamlomne lipsimundi, sabol keptangto aleptalulom. Aleptamundi, ag wendogne poro alulom!” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ambatsiogpa mema tanekoap, aoag tolongoroba tanekoap Yakubag tarekpa, Yakubti as Sikhem peramag kal nubunge wamogne neneko tamag sikog. ");
INSERT INTO kkl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sikogti Yakub elmaboap lanalamekpa, Allahri nimi as kanero wamekne nimi taneko log nembhaiogpa, “Yakub elmaboap opsukap,” aro sarenelebahinep kom uaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Pinep kom wamogpa, Yakub elmaboap as Betel samenag as si Lus engerobag Kanaan so'oag ane piek. ");
INSERT INTO kkl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Piekti Yakub nenekori Allahag mhong towalengenag sobaogti, wanag agha seneraglamogti, “Na naro sembe logti palamsiba, Allah lag taogti, El wamlaag ane,” aro si El Betel engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Engkaogti tane wamekag anekoa Ribka nong ologhag agha piamog pahabog wamog kel Debora neneko tebaogpa, as Betel aneko mombolag sip kal nubunge wamogha mombolag sip sikog. Kal nubunge wamogpa, sikogag wamog kal eneko si “Engena kal” engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakub neneko samenag Aram mog so'o laplobiagha yalamogha as Betel yaogpa, nen Allah el whingag lag taogti, kiplamogti, ");
INSERT INTO kkl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“An si wene Yakub wamlamne Yakub alangkukang kom, wene Israel alangkukang,” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Engkaogti, nen lelamogti, “Na Allah Imap So'oap Saelbamnange yubu lelamna. Andi mangarobari mangkahyikne maikno taikti, as nubunge yubu a'ero-a'ero leropne wamukang. Sin wamikne taneko anabiag agha nimi nubunge raja seklamukang. ");
INSERT INTO kkl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","'So'o anisag Abrahamap ani Ishakap tatsinun,' sehinge neneko an anmabori ngai taukangba, tatsinun,” aro ambarogti, ");
INSERT INTO kkl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Yakub liloa piog. ");
INSERT INTO kkl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Piogpa Yakub ponekori, “Allahri nanag yubu leplaag ane,” aro kekneba kirik nhon so'oag mebirogti, kirik anekoag anggur magap kal saitun wangka lolterobaap ikog. ");
INSERT INTO kkl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ikogti si Betel ya'ag engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wameka Yakub elmaboap as Betel laplobiagha Efrata peramag palamekpa, Rahel neneko me mangal dona peram taogti, monag ta'ap alamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","in tolamog abeneko el yeplamog kel enekori ambarelamogti, “Nen nengabo me nhon mangaro alulam. Ikin uro wamseng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Seogpa Rahel neneko tebanep hain kom tanogpa, me aneko si Ben-Oni engkaog, aghana iliri Benyamin engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel neneko tebaogpa, Efrata ina pirobag inaag sikog. Samenag as Efrata engeropne neneko wene Betlehem alamang. ");
INSERT INTO kkl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Sikoghag aneko Yakob ponekori kekneba kirik nhon mebirogne neneko wene babe wamla. ");
INSERT INTO kkl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Undo unuaogti, Yakub neneko ae wenge solingkirobag si Eder neneko phibom agha piogti, ae kalun ae soro wamog. ");
INSERT INTO kkl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wamogti Ruben nenekori iliri elkel nenero aogne Bilha nenekoap mabogne sembe Yakubti ka'ebaogti, wamog. Yakub nenekori elmabo nengabo mabo aobare mangkahaiog. ");
INSERT INTO kkl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Elkel Lea nenekori elme samenagne Ruben mangaro aogti, Simeonap, Lewiap, Yehudaap, Isakharap, Zebulonap, mangkahaiog. ");
INSERT INTO kkl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Elkel Rahel nenekori Yusubap Benyaminap mangkahaiog. ");
INSERT INTO kkl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel arukna Bilha nenekori Danap Naptaliap mangkahaiog. ");
INSERT INTO kkl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea arukna Zilpa nenekori Gadap Asyerap mangkahaiog. Me taneko nina Aram so'oag agha mangkahiek. ");
INSERT INTO kkl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Wamekti Yakub neneko ili Ishakag Hebron peramag as Mamre piog. Samenag as eneko Abrahamap Ishakap nimi sekelanan nang saog uro wamdek. ");
INSERT INTO kkl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Ishak mangkaekne heng kun taibuka taubuka ulamogha teng no'opbare eptopne sa'o tarabare (180) taogpa, sabal taogti, wana aingniro wamogti, hain kom taogpa, ilisag yaboag yame samen piog. Tebaogpa, elmabo Esauap Yakubapti so'o siktek. ");
INSERT INTO kkl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau si nhon Edom. ");
INSERT INTO kkl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esauri Kanaan kelabo phende topsiog. Selekne Hetne Elon elmangkel Ada tobog, phendepne Hewinge Ana elmangkel Oholibama tobog. Ana ili Sibeon. Nen nhon ma'aro wilindipne tobogne Ismael elmangkel Nebayot ilipsa'el Basmat tobog. ");
INSERT INTO kkl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adari Elifas Esau sembe mangkarogpa, Basmatti Rehuel mangkarog. ");
INSERT INTO kkl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamari Esau sembe mangkarognena: Yeus, Yaelam apna Korahap. Esau Kanaan wamogha el kelabori mabo lambare ane mangkahiek. ");
INSERT INTO kkl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esauri ilipsae Yakub laplobiagha mog so'o nhon weag palamogti, Kanaan wamogti, saeag taoghaap, eldi kelaboap, eldi maboap, eldi kelmaboap, eldi aeag wamek nimiap, eldi phamap piek. ");
INSERT INTO kkl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esauri ilipsae laploa piognena, sindinge saeagha pham maikno wamogpa, sin ilipsaeap nhon nikag wamnep kom. Ane sembe eldori ilipsae laploa piog. ");
INSERT INTO kkl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ane sembe Esau, si nhon Edom, Seir yimag ko'oro piog. ");
INSERT INTO kkl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Piogti, Esauri nimi likto Edom nimi yina liksiogne ane. ");
INSERT INTO kkl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau, si nhon Edom, elmabona: Esauri kel Adari Elifas mangkaog. Esauri kel Basmatti Rehuel mangkaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ada ela'ange Esau. Esauri me Elifas. Elifasti mabona: Teman, Omar, Sepho, Gaetam, apna Kenasap. ");
INSERT INTO kkl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifasti kel Timna tognoro torop keldi mena Amalek. Si lepsiap nang ini sikinisag sikinauna Esauap Adaap. ");
INSERT INTO kkl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Basmat ela'ange Esau. Esauri me Rehuel. Rehuelti mabona: Nahat, Serah, Siama apna Misaap. Anena Esau elkel Basmat elau yabo. ");
INSERT INTO kkl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esauri kel Oholibama ilisag Sibeon. Sibeon elme Ana. Oholibamana Ana elmangkel agha Esauri tobog. Oholibamari Esau sembe mangkahiogne: Yeus, Yaelam apna Korahap. ");
INSERT INTO kkl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esauri mangahirobari sikini yabo tangto piek sisana ane. Elifas Esauri me yandonge. Elifas pone sikini taog. Nimi sisa taeknena: Teman, Omar, Sefo, Kenas, Korah, Gaetam, apna Amalek nimi sisa sikini taek. Esauri kel Adari Elifas mangkaogpa, Elifasti liksiogne undo wamek. ");
INSERT INTO kkl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rehuel ponekona, Esau elkel Basmatti mangkarogne. Nimi sisa sikini yabo taek nimina: Nahat, Serah, Siama, apna Misaap nimi sisa sikini taek. Esauri kel Basmatti Rehuel mangkaogpa, Rehueldi liksiogne undo wamek. ");
INSERT INTO kkl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esauri kel Oholibama. Oholibama ilisag Sibeon. Oholibama ili Ana. Esauap Oholibamaapti liksirekne sindi mabo Yeus, Yaelam, apna Korah nimi sisa sikini taek. ");
INSERT INTO kkl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Si lepsiap nang ini Esauri mabo sindam nimi si ahaem uro sikini yabo tangtang piek. ");
INSERT INTO kkl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Esau ko'oro Seir pioghag aneko Hori nimi wamekag piog. Horingena Seir poneko elmabo ane: Lotan, Siobal, Sibeon, Ana, ");
INSERT INTO kkl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dision, Eser, apna Disianap. Edom so'oag Seir elmabo sikini yabo taek. ");
INSERT INTO kkl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan elmabona: Hori, apna Hemanap. Lotan ilipsa'elna Timna. ");
INSERT INTO kkl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Siobal elmabona: Alwan, Manhat, Ebal, Siepho apna Onamap. ");
INSERT INTO kkl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon elmabona: Aya apna Anaap. Ana poneri iliringe pham yae ua ulamsiogti, aldesag mag lu pobonge ibog. ");
INSERT INTO kkl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana elmabona Dision apna elmangkel Oholibamaap. ");
INSERT INTO kkl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dision elmabona: Hemdan, Esiban, Yitran apna Keranap. ");
INSERT INTO kkl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser elmabona: Bilhan, Saawan apna Akanap. ");
INSERT INTO kkl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disian elmabona: Us apna Aranap. ");
INSERT INTO kkl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ane wamlange nenena Hori nimi sikini yabo sisa taek nimi. Sikini yabo sisa taek nimi endana: Lotan nimi sikini, Siobal nimi sikini, Sibeon nimi sikini, Ana nimi sikini, ");
INSERT INTO kkl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dision nimi sikini, Eser nimi sikini, apna Disian nimi sikiniap. Hori nimi sikini yabo sisa ene Hori as mog so'o taneag likto piog. ");
INSERT INTO kkl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","32","Anam Israel yubu sia lerop nang raja wamna komag, Edom samenag yubu sia lerop nang wamek nangna: Beor elme Bela yubu sia leropne Edom mog so'oag wamek nimi sembe wamog. Eldi as Dinhaba. ");
INSERT INTO kkl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela tebaogpa, Serah elme Yobab as Bosrange agha Bela lunumna waelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab tebaogpa, lunumna Husiam waelbaogne Teman nimi sisa agha waelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husiam tebaogpa, Bedad elme Hadad lunumna as Awitne agha waelbaog. Hadad poneri Midian nimiap Moab asag agha mal talamekti, oro luknubahiogne. ");
INSERT INTO kkl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad tebaogpa, Hadad lunumna as Masrekange Samla waelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla tebaogpa, Samla lunumna Rehobot mag abolagne Syaul waelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Syaul tebaogpa, Syaul lunumna Akhbor elme Baal-Hanan waelbaog. ");
INSERT INTO kkl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan tebaogpa, Baal-Hanan lunumna Hadar waelbaog. Hadarti asna Pahu. Eldi kel sina Mhetabe'el ili Matred. Mhetabe'el ilisag Mesa'ab. ");
INSERT INTO kkl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Edom nimi sikinisang taognena Esau. Nimi sisana: Timna, Alwi, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, apna Iram nimi sisaap. Sin si lepsiap nimi sisa ene ahaem uro, as mog so'o wameka ane babe, nimi si wamla ane saog uro engero piog. ");
INSERT INTO kkl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Esau ilipsae Yakub neneko ili nimi sekelanan nang saog uro wamoghag Kanaan so'oag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","El elmabori ulamekne ane: Yakub elme Yusup mangkaekne heng kun taibuka taubuka ulamogha timbom agha ko'olom tarabare taogpa, iliri elkelabo nembahiogne taneko Bilhaap Silpaap sikin mabo mangkahirekne tanekoapti pham kambing domba piamsiek. Yusubap nikag piamsiekti, eldo yabori yoaba ulamekne sembe Yusup nenekori ili ambarelamog. ");
INSERT INTO kkl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakub nenekori elme Yusup sembe, “Sabalag agha mangaro ano me,” aro wanaag uro seneraglamogti, eldoyabo sembe wana abolag uro seneraglamsiog. Ik nhon sum Yakubti ag nhon ketkero yogto-yogto wibogti, “Enekel dolamlul,” aro tarog. ");
INSERT INTO kkl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yakub elmabo yogneri seneraglamekti, “Nuniri nunipsae Yusup sembe wanaag wamlari, nun wailag nenelamsil,” aro el taekti, sikinipsae Yusubag yubu wali uro lelamek kom. ");
INSERT INTO kkl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Ik nhon sum Yusupti lenda mabogti, eldo yabo nebatsiog. Yusupti eldo yabo nebatsiogne ane, “Naro yabo, lemnunne nene ka'eamsut! Nari lenda malamnaba, nun ni aweag wamapti, roti wana mauroba yo'o kareptopne kaupto palilamapti, kemelamnaag agha nari kaupto pililamnange sek-sek yabiamangba, a'undinge yomoro naringeag kiniplamang,” aro ambatsiogpa, sindi el sembe, “Karong,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wene aro ambatsiogpa, elag yubu lelamekti, “'Na yubu lenne taneri, nu mombolag nembahinun,' senelamlam?” aro wabaek. Lenda mabiagha nebarelamsiogne sembe eldo yabo taneko yo senelamek. ");
INSERT INTO kkl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Undo unulamekpa, nen lenda nhon mabogti, eldo yabo nebarelamsiogti, “Nari lenda mamnaba, hengap, walap, imbrea ko'olombareap tanekori na saramag yabu sanukto kulukul alamangba, imna,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Lenda mabogne neneko ili babe ambarogpa, iliri walamogti, “Lenda nene wela saogne maplam? Na aniap, aninap, ando yaboap, 'Nanag yaikti, yabu sanukto pul aukang,' senelamlam?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Undo unulamogne sembe Yusup eldo yabo tanekori el sembe wana mali lelem karong uro seneraglamekpa, iliri lenda aneko el uro ua ulamogti, usoghag pia ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wamekti, Yusup eldo yabori pham kambing domba sikiniringe taneko poa phiekti, as Sikhem peramag piamsiek. ");
INSERT INTO kkl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Undo unuaekpa, Yakub nenekori Yusup ambarelamogti, “Ando yabori pham nuringe as Sikhem piamangdi, wamangag kemel philulam,” aro ambarogpa, Yusupti, “Nani, wali leplam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Wene seogpa, Yakubti, “'Ando yaboap, pham naringeap, wali wamangdo,' aro kemel phimendi, ambarel anululam,” aro ambarogpa, Yusup neneko Hebron whaboghag agha “Sikhem punun,” aro palamog. “Sikhem punun,” aro palamoghag agha ");
INSERT INTO kkl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","“Tala wamang,” aro ekondi, paiag tangom ina ag tangom aba palamogpa, nimi nhon haiptarekti, “Sa'a elamlam?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Wene aro haibaogpa, Yusupti, “Nani, 'Naro yabori pham tala piamsiangdi, tala wamang,' aro elamsindi, an el wamlam tanena ambatnululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Wene seogpa, nimi enekori, “Ando yabo tane lambaongdi, palamongdi, 'As Dotan pukap,' aro wene alamonga ka'ebahino,” aro ambarogpa, Yusup neneko eldo yabo as Dotan wamekag piogti, tibog ahiog. ");
INSERT INTO kkl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yusup neneko weag yalamogha tibog aekti, “El nunag yalamle tanena obukap,” sembaekti, ");
INSERT INTO kkl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","sin mo-mo yubu lelamekti, “Lenda polan uro maropne poneko yalamlaba, ");
INSERT INTO kkl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ya'ag oro mag longkanep kirik arameag pelengkaukap. Undo unuaberi, 'Si yoabari obo,' alamukap. Undo obebeba, eldi lenda malamonge welaro pulul kembaukap,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Undo wene alameka Ruben nenekori ka'ebahiogti, “Welaro sin saeag agha taulbanun?” sembaogti, yubu lelamogti, “Naipsabo, ya'ag obukap kom. ");
INSERT INTO kkl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","El eneng yingkileag, nuri elag sa'a-sa'a uan koma mag longkanep kirik arameag ani pelengkaukap,” seog. Wene seogne nene, “Yusup neneko obikag pelebaneri, 'Aniag pululam,' sunun,” aro seneraghogti, lebog. ");
INSERT INTO kkl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusup neneko eldo yaboag yaogpa, sindi saelbaekti, elenge ag walinge poro amogne neneko kuripto tobogahiekti, ");
INSERT INTO kkl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","sae kiliro pabiekti, mag longkanep kirik arameag aneko peleng lobol piek. Peleng lobol piekag aneko mag longorop komag peleng lobol piek. ");
INSERT INTO kkl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Unuaekti kwaneng telamekti, tilamekpa, yog nimi Ismael sisa nimi mog so'o Gilead anekoa “Mesir pukap,” aro yalamek. Yalameka anekona, kal wea nimi whesinaap, teptop nimi song kom nenenna-ap, kwanengap ma'aro yonaap, “Nimi Mesir wamang nimiri kamna kapto tobukang,” aro pham unta alibag towalengkibekti, payalamek. Sindi payalameka tibogahiek. ");
INSERT INTO kkl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tibogahiekti, Yusup eldo Yehuda nenekori elkaboag yubu lelamogti, “Nangkabo, sa'a sembe nunipsae obeberi, eneng tognobaukap? ");
INSERT INTO kkl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Yusup nunipsae ana, obukap kom semban. Ane sembe Ismael nang eneag kamna kapto tobukap,” aro ambatsiogpa, “Wali leplam,” seekti, ");
INSERT INTO kkl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","wamekag Ismael nimi yalamekpa, ipsiekti, “Midian nimi yalamangne ane,” sembaek. Midian nimi wali-walia kamna kapto tororo yabirop nimi yabaekpa, Yusup neneko eldo yabori mag longkanep kirik arame anekoa kiliro towalengkaekti, Ismael nimi taneko tatsiekpa, sindi kamna kapto kirik wana solomne lin tarabareag tobek. Tobekpa, Yusup neneko Mesir poa piek. ");
INSERT INTO kkl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Poa piekpa, Yusup eldo Ruben mag longkanep kirik arame anekoag yaogti, tiplengelamogpa, Yusup neneko kom wamogpa, lo'om seogti, ag wangaro amogne kweldero epsiog. ");
INSERT INTO kkl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Undo unuaogti, elkaboag piogti, ambarelamsiogti, “Me aneko orogti, wene wela uanun?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Seogpa, Yusup eldo yabo tanekori pham kambing nhon obekti, Yusupti ag eneko pham kambing enengag werebaekti, ");
INSERT INTO kkl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","nimi nhon ambarelamekti, “Ag ane nuri naiag pabimendi, ambarelapmendi, '”Ag ane nuri ibobori, anmeri ag to?” aro pebel alangken,' sululam,” aro ambarekpa, Yakub ya'aghag piog. ");
INSERT INTO kkl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Piogti, ag aneko pebogpa, Yakub nenekori kembaogti, yubu lelamogti, “Ot sik uro nari nameri ag. Name Yusup neneko si yoabari oro kaelbaori, pelekto teo,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","wana maliri ag wangaro amogne kweldero epsiogti, kuripto tobogahiogti, “Amang ulamna,” aro ag kilikin ag malinge poro aogti, so'o liktangto elme sembe sana amang wamog. ");
INSERT INTO kkl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Amang wamogti, wamogpa, elmabo elmangkelabo yingkina “Wana aingnibaukap,” aro yaek aghana, sikini wana aingnilamog kom. Elme sembe seneraglamogti, “Name sembe amang ulamneri tebanun,” seogti, engero aghabog ua ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Undo wamogti, ua ulamogpa, Midian nimiri Yusup neneko Mesir pabiekti, Potifar ponekoag tarel piekpa, eldi kamna tatsiog. Potifar neneko Mesirnang sikini yae wameknang sikindo wamog. ");
INSERT INTO kkl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yusup Mesir wamogpa, Yehuda elkaboap wamna koma laploa piogti, as Adulam wamogne sina Hira poneag piogti, wamog. ");
INSERT INTO kkl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Aneko pina wamogti, kelabo nhon Kanaan nimi Suari kelme haiptarekti, salag lebogti, toptarekti, Yehuda elkelap nikag maptek. ");
INSERT INTO kkl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Keleneko me monag taogti, me mangaro aogpa, ili Yehudari si Er aro engkarek. ");
INSERT INTO kkl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Keleneko nen me monag taogti, me nengabo me mangaro aogti, me si Onan ilindi engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nen keleneko me monag taogti, me nhon babe mangaro aogti, me si Siela engkaog. Ela'ange Yehuda Kesib pina wamogpa, me ane mangaro aog. ");
INSERT INTO kkl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yehudari elme yandonge Er sembe kelabo nhon Tamar tobog. ");
INSERT INTO kkl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tobog aghana, Er yonge aghabog ulamogha sembe NUNI Allahri ibogti, ya'ag obog. ");
INSERT INTO kkl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Allahri obogpa, Yehudari elme Onan Er ilipsaeag yubu lelamogti, “Andori yauog laploa loba tao aneko maupmendi, nhon maptumunba, ando lunuro eldi sisa babe yag talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aghana Onan el wamognena, “Na narori kelap mapneme tanena na sisa talul kom. Naro sisa talul anekona, malamnemea naringe eneng agha naro sisa talul kom,” aro nikag maptek aghana eldi eneng kel anekoag talamog kom. ");
INSERT INTO kkl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","“Naringe eneng keleneag nari pimnun kom,” seogne sembe NUNI Allahri ibogti, “Onan yonge ulamla,” aro Allahri ya'ag obog. ");
INSERT INTO kkl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Allahri Onan obogpa, Yehudari elmabori yauog anekoag yubu lelamogti, “Namangkel, pimendi aniri aeag yauog uro wamlulam. Pimendi, wapmenba, name Siela nubu tale tagha,” seog. Yehudari seneraghognena, “Namabo tebarong saog uro Siela babe tebaleag,” aro lebog. Wene seogpa, Tamar lambaogti, iliri aeag pina yauog wamog. ");
INSERT INTO kkl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Piogpa, wamekti, Sua elmangkel Yehudari kel tebaog. Tebaogpa, elkel tebaogha sembe amang wamogha elkae Hira as Adulam wamogne poneko enero agha as Timna piog. Piognena pham domba hong kareplamangpa, Yehudari, “Pham domba hong karebel ahinun,” aro sembaogti, piog. ");
INSERT INTO kkl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Elmabori yauog Tamar anekori ka'elamogpa, elyamal Yehuda, “As Timna pham domba hong karebel ahinun,” aro yalamla ana ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ka'ebaogti, Tamar neneko 'yauog tandi enektop ag' kwiripto lilobi agha, ag yogne enekongkia whingag liliro pelengtoba lilbongkia Timna ina pirobag pukamog. Pukamoghagna as Enaim wa'ineba peramag. Tamar sik uro elel wamognena, “Yehuda elme Siela nabinge wene nubu tao aghana, wene toamnel kom,” senelamog. ");
INSERT INTO kkl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Yehudari Tamar whingag liliroba lilbamogha sembe elyamal kel iamog koma “Ina yabirop kel pukamla,” sembaog. Wene sembaogti, Yehuda Tamar ina peramag aneko sekel piogti, lelamogti, “Yae, na an saelbaghenun,” seogpa, kelenekori, “Na saelbanemen tanena sa'aba agha tatnululam?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Seogpa, Yehudari, “Nari pham domba yemne nhon wendog nolamlange tatkinun,” seog. Wene seogpa, Tamarti, “Wali, aghana tatnululama ane sembe nang-nang aro wamnuna sa'agha tatnululam?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Wene seogpa, Yehudari, “Sa'a agha wene tatkinun?” seogpa, kelenekori, “Sae ma'alag tolongka uroba-ap, saramag langka uroba-ap, anenge kame tunguna saeag wamlange nang-nang uro wamnuna tatnululam,” seog. Wene aro molbaogha tarogti, saelbaog. Saelbaogpa, keleneko memon taog. ");
INSERT INTO kkl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar aeag piogti, ag wangka piogne kwiripto pibogti, yauog kelabori enektopne enekaog. ");
INSERT INTO kkl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Enekaogti, wamogpa, Yehudari elkae Hira Adulamne poghogti, “Pham kambing ane pina tarel pimendi, naringe aba kelenekori toboa taneko payalulam,” seogpa, palamoghag agha kel eneko orog wamog. ");
INSERT INTO kkl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hirari Enaim nimiag hailamsiogti, “Ina yabirop kel inaag ua ulamla kel eneko ala wamla?” aro haibahiog. Wene aro haibahiogpa, sindina, “Tanena ina yabirop kelabo nhon wamang kom,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Wene seekpa, Hira samoro Yehudaag piogti, ambarelamogti, “Nari keleneko olog inma kom. Nimi wamang nimiri lebangnena, 'Tanena ina yabirop kelabo nhon wamang kom,' seang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Wene aro ambarogpa, Yehudarina, “Naringe aba elsaeag tao anena wali elenge talul. Nimiri nu yubu lehinba, nu ali unne sembena, 'Pham ane tarel pululam,' sen aghana el kom wamlaba, payalam tanena andane,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Wal wilindiro undo wameka, Yehudari ka'elamogpa, “Anmabori yauog anyamalkel Tamarna ina yabirop kelabo saog uro yabalamori, memon tao,” ana ka'ebaog. Wene alameka ka'ebaogti, Yehudari yubu lelamogti, “Tol pimundi, payalulom. Kamag kekman auk tabukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","“Tol pimundi, payalalulom,” seogpa, piekti, aeag agha Tamar poa lanalamekpa, Tamarti elyamal Yehudaag yubu piro lebognena, “Taneaba ngainge poneri memon nembaneo. Ane sembe na saeag wamla tane poa samenag pimunba, nimi sae saelbahilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Wene seogpa, poa piekpa, Yehudari kembaogti, el taogti, lebogti, “Kel enena malia uan koma wamla. Nari elag uanepne uano komnena, na name Sielaap ma'abahino kom,” seog. Yehuda nen kel enekoap man ana orog. ");
INSERT INTO kkl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar me mangal tona peram wamogpa, mangal tolamoghag agha me phende mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Me mangal tona peram wamogpa, me mangal tolamoghag agha me samenag yingkiogne neneko sae lanal aogpa, yepsiropneri sae no'obag saelbaogti, wet purum uwongne agha saeag kerekaog. Sae kerekaogti yubu lelamogti, “Mene samenag mangaro yingkil,” ");
INSERT INTO kkl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","alamoghag agha sae kiliro aog. Sae kiliro aogpa, me nhon amikne samenag yingkiog. Yingkiog meag yepsirop kel enekori yubu lelamogti, “An mikip talamdi, an samenag yingkilam,” seog. Ane sembe me samenag mangaro yingkiogne neneko me si Peres aro engkaek. ");
INSERT INTO kkl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Peres samenag mangaro yingkiogpa, ilipsae amik sae no'obag wet purum uwongne kerektoba amik yingkiog. Ane sembe si Serah engkaekti, nene me yandonge sembaek. ");
INSERT INTO kkl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismael nimiri Yusup neneko Mesir pabiekti, Potifar tarel piekpa, eldi kamna tatsiog. Potifar neneko Mesir nimi sikini yae wamek nang yin saleropne sikindo wamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yusup neneko ili Mesirne ponekoap wamogpa, NUNI Allahri yeplamogpa, awe wali uro welamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Wamogne Potifar nenekori kemelamogpa, Ili Allahri me aneko yeplamogpa, “Awe ambarelamnange ni awe wali uro welamla,” aro kemelamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Undo ulamogha kembaogti, Potifar nenekori Yusup sembe o'ona senelamogti, “An agha na peramag wapmendi, yeplamnululam,” aro ambarelamog. Nen nhon ambarelamogti, “Na naringe aeag wamlange naringe saeag agha ni andi o'olamlulam,” aro sekirog. ");
INSERT INTO kkl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Toro sekirogti, wamogpa, NUNI Allahri Yusubag seneraglamogti, Potifarti ae eneko wali nenelamogpa, Potifar ponekoringe aeag wamogne paiag wamogne ni wali uro tolamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nia mangkina eldinge taneko Yusupti saeag pibogti, eldamneri olog uan koma, ot tena aghabog seneraglamog. Yusup neneko kabuni kemerop wamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wamekti, Potifarti keldi Yusup kembiagha wana telamogpa, lebogti, “An nanap mamnunamdi yae,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Wene seogpa, Yusupti, “Karong,” aro yubu lelamogti, “Nanin, nani Potifar nenekori nia mangkina eldinge aeag wamlange, 'Andi piamlulam,' aro ambatneori, nia mangkina o'ol tolamla kom. ");
INSERT INTO kkl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Naniri nia mangkina sembe ambarelamsilba, ka'elamang saog uro nari babe ambarelamsinba ka'ebanep. Nia mangkina ni ae eneag nari saeag pibog aghana, nanin, na nani elkel wamlam ana an sembe naniri ambatneo kom. An sembe ambatneo komba, welaro nari malia ulamneri, Allah wana loba nembanun?” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wene aro ambarogti, wamogpa, kelenekori sopsop yubu yangaro, “Nhon mamnunam,” alamog aghana Yusup ka'elamog kom. ");
INSERT INTO kkl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ik nhon sum ili arukna nenne oroghag Yusup aeag wa'iogti, aeag wamogha “O'obanun,” aro aeag wa'iog. ");
INSERT INTO kkl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Aeag wa'iogti, aeag wamogha “O'obanun,” aro ulamoghag agha ili Potifar elkel wa'alulum agha Yusupti ag enekto amogneag saelbaogti, “Wene nhon mamnunam,” aro wene alamoghag agha Yusup, “Karong,” aro ag enekto amogne neneko kwiripto keleneko saeag tan aogha laplobiagha lahimbom seog. ");
INSERT INTO kkl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yusupti ag eneko el saeag taogha kembiagha ");
INSERT INTO kkl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kelenekori eldi arukna yopsiogti, ambarelamsiogti, “Namabo, na na'angeri Ibraninge ae eneag tolongol aoba, yubu neplamsil. El neneko na marobag wa'ildi, 'Nanap mamnunam,' aro ulamlaba, na ngolol alamna. ");
INSERT INTO kkl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ngolol alamna sembe logti, lanalamlari elenge ag laplobiagha pilne kembahut!” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wene aro ambatsiogti, kelenekori ag aneko piamogti, wamogpa, ela'ange yaogpa, ");
INSERT INTO kkl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","18","ambarelamogti, “Ibraninge andi arukna payaomne ponekori aeag wa'ildi, na 'Saelbanun,' aro ulamnelag agha nari yubu ngolol aro, haum alamnange sembe log lelem palamlari, ag kwiripto liloa pilne ane,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wene aro ambarogpa, ela'ange Potifar nenekori ka'ebaogti, wanaag yo sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yo sembaogti, Yusup neneko salero Potifarti kop aeag tolongol piog. Kop ae tolongol pioghag aneko nimiri Mesir yubu sia leropneag malia uanba, tolongol pirob aeag tolongol piek. ");
INSERT INTO kkl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tolongol piekpa, NUNI Allahri Yusup yeplamogpa, kop ae yae ua uropne ponekori Yusup sembe o'ona senelamog. ");
INSERT INTO kkl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","O'ona senelamogti, “Nimi orange haing sae kaupto tolongolamsiekne andi kemelamsimendi, sa'a-sa'a kop aeag uropne andi o'olamlulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ambarogti, kemelamogpa, Yusup neneko Ili Allahri yeplamogpa, awe eldi welamogne sikneog uro yabalamogpa, kembaogti, Yusup saeag awe pibogne taneko tolamoghag kemel palamog kom. ");
INSERT INTO kkl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Wameka nimi phende yubu sia leropne Mesir wamogne Firaun yeplamdek nang abeneko, nhonna mag Firaun tebatnange sembe, nhonna kwaneng roti yoro tengenne wamdek nang abenekori Firaunag malia uarek. ");
INSERT INTO kkl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ane sembe Firaundi sin phende el yeplamdek nang abenekoag yo pipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Yo pipsiogti, sin neabeneko salero kop aeag yin saleropne sikini Firaun sembe yae ua uropneri aeag Yusup wamog ae kop aeag tobongkipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sin phende abeneko kop aeag aneko ik maiknoro wamdek. Firaun yae ua uropne ponekori Yusupag, “Andi sin yeplamsululam,” aro elag tareamog. ");
INSERT INTO kkl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ik nhon sum nimi nubunge yeplamdek nang abenekori lenda maptek. Lenda maptek aneko lilimna a'ero maptek. ");
INSERT INTO kkl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Maptekti wamdekpa, Yusup lukunap yaogti, kemelamsiogpa, sin wana ikin uro wamdek. ");
INSERT INTO kkl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Undo wamdekpa, kembahiogti Yusupti, “Sa'a sembe wana ikin saog uro wamdom?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wene seogpa sindina, “Inipnag lenda mamnam aghana nimi nhondi babe lenda mamnamne neneko 'Lelero ane sembe maptom,' aro ambatsinep kom,” serek. Wene serekpa Yusupti sinag lelamogti, “Allahri lenda maptoma lelbatsinep kom te? Na ka'eamnundi, welaro maptom?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wene seogpa, mag nimi nubunge Firaun sembe yeptopne ponekori, “Lenda aneko malamnari, kemelamna-ag agha haing anggur na whingag wamla. ");
INSERT INTO kkl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Haing anggur aneko wag wilindi uro pongolamla. Mog anam pongolamla aghana es momagamla. Aghana wana mauroba aneko yina lom-lom alamangpa imna. ");
INSERT INTO kkl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Unu amangba, kembandi, kemelamnaag agha nimi nubunge Firaundi mag teroba na saeag wamla. Wamlaba, haing anggur wana aneko tagnari, nimi nubunge Firaundi mag ma'iag loltero pelengkandi, tarelamna,” aro nebog. ");
INSERT INTO kkl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","13","Wene aro Yusupag nebarogpa, Yusuptina, “Lenda maplamnena undo sembe maplam: Wag wilindi wamlange nenekona ik wilindi wamlulamne sembe. Ik wilindi wapmenba, Firaundi kop aeag anea lambitkeleri, 'Malia uaomne orog tal,' aro, 'Awe samen tolamomne saelbamlulam,' seleba, samen mag tebarelamom saog uro tebarelamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lambamen tanena na sembe ekon taneheng kom. Tam na wamnange babe nimi nubungeag ambatmenba, na babe kop aeag anea lambitnelul. ");
INSERT INTO kkl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nana Ibrani so'oag wamsiag agha naro yabori Ismael nimiag nembaneekpa sindi poa Mesir nimiag kamna tol aneek aghana, Mesir tane babe nari tam malinge una babe ekon agha, kop aeag ane tobongkipneek,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nimi nubunge sembe mag tebato yeplamogne ponekori lenda lelbarogha wali ka'ebaogti, kwaneng roti nimi nubunge sembe yoro ingkatopne ponekori babe Yusupag, “Lelbatnulul,” aro nebarelamogti, “Nari babe lenda mamnangena, kwaneng roti winiroba kau wiroba wilindi usoghag poamna. ");
INSERT INTO kkl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kau wilindi aneko wilindipne neneko kemelamnaag agha kwaneng roti wereroba yogne-yogne Firaun sembe wamla, aghana winang yingkina kau sirikagne alibag neneko telamang,” aro Yusupag nebog. ");
INSERT INTO kkl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Nebogpa, Yusupti lenda aneko lelero ambarelamogti, “Lenda aneko undo sembe maplam. Kau wilindi maplamne neneko ik wilindi sembe maplam. ");
INSERT INTO kkl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ik wilindi wapmenba, Firaundi lambitkeleri, nimiag “Oplulom,” seleba, andi usog karepto kalag epto silbaghikpa, winang yingkina sop nong andinge tukukang,” aro lelero ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Lenda mapteka lelero ambatsiogpa, wameka ik wilindip sumneko nimi nubunge Firaun mangkaek sum wamog sumeneko, tenaba maiknoro yoro el mombolag wameknang awe tolamekne ni “Yalulom,” aro ambatsiog. Ambatsiogpa, yaekpa, ambarelamsiogti, “Nimi kop aeag wamdang nimi abeneko tolbina nimi wamangag na whingag payahilulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nimi nubunge mag tebarelamog nimi enekoag seognena, “Samen pukamomag pukamlulam,” seogpa, pukamogti, mag nimi nubunge poneko mag tero tebarelamog. ");
INSERT INTO kkl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nimi nhonne kwaneng roti yoro yubu sia leropne sembe ingilamogne ponekona, usog karepto lenda Yusupti lelbarogne neneko sunsunum uro kalag silbaek. ");
INSERT INTO kkl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yusupti, “Na sembe ekon taneheng kom,” seog aghana, nimi enekori Yusup sembe seneragna koma el ekon taog. ");
INSERT INTO kkl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Heng kun phende phibaogpa, Firaundi lenda malamogti, Mag Nil abolag sekamog. ");
INSERT INTO kkl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Sekamogti, Mag Nil koag kemelamogpa, pham sapi saekpare hong alam-alam arop pham wali uro norop pham maghag agha walel aekti, mag abolag pongoroba telamek. ");
INSERT INTO kkl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nen babe kemelamogpa, Mag Nil lomag agha pham sapi yarirop-yarirop pham saekpare lamba walel aekti, wali uro norop pham peramag sekamek. ");
INSERT INTO kkl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kemelamsioghag agha, pham sapi yarirop-yarirop pham tanekori wali norop pham telamsiek. Undo telamsiekpa, Firaundi lenda maro haing kwelekaog. ");
INSERT INTO kkl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nen mabogti, lenda malamogti, kemelamogpa, roti mauroba yo'o nhonag agha wana mauroba korokto saekpare mauamogpa, whi ubu pilamekpa, mabog. ");
INSERT INTO kkl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nen tipto malamogti, kemelamogpa, roti mauroba yo'o nhonag agha nen wana mauroba korokto saekpare nika-nika uro mauamog. Nen saekpare mauamog aghana aldesag khaori kolalem-kolalem uro maurop saog uro whi ubu pilamek kom. ");
INSERT INTO kkl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kolalem-kolalem uro maubu piamekti, whi wamek kom aghana wali uro mauropne kolalem uro mauropneri telamsiekti, orog nembahiekpa, Firaundi lenda maro haing kwelekaogti, “Nia imna tane lenda mamna,” sembaogti, el taog. ");
INSERT INTO kkl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Maboghag lukun kwelekaogne log sembaogti, “Etneri lenda mamnange nene lelbatnilul,” aro el umag yubu amorop nangap, haing ka'en nangap yopsiog. Yopsiogti, lenda mabogne nebatsiogpa, sin niri lenda mabogha aneko lelbarek kom. ");
INSERT INTO kkl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Lelbarek komba, mag Firaun sembe tebatopne ponekori iliag, “Na sumene nari mali uanonge sumene lag phoro ambatkinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wene seogti, “Samen taneko andi nanap nangkae kwaneng roti werero tengkatkeropneap yo sembahilumdi, wabahilumba, an sembe yae ua uahiropneri ae kop aeag tobongkipsiek. ");
INSERT INTO kkl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","12","Tobongkipsiekpa, wamnumuri, ik nhon sum lenda a'ero mamnumu. Lenda mamnumua aneko lelero eltananne ekon wamnumu aghana, kabuni Ibraninge samen Firaundi yae wamek nang yin saleropne sikindori aeag yepto wamog. Yepto wamog aghana salero kop aeag tobongkibekpa, ik nhon sum haiptaburi, elag lenda mamnumunge nebatnumuba, lenda mamnumua a'ero lelbatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Lenda mamnumua lelbatsiog aneko sik uro yabiog. Wene babe samen mag tebarelangkhi saog uro wene babe wamnaba, nangkae kwaneng roti werero tengkarelangkeogne poneko lenda mabogpa, lelbarogha sunsunum uro kalag epto silbaek,” aro nebarog. ");
INSERT INTO kkl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Wene aro nebarogpa, ka'ebaogti, Firaundi, “Yusup kop aeag wamla tol pululom,” seogpa, Yusup kop aeag agha lambaogti, waba hong lero ag walinge enekaogti, Firaun whingag piog. ");
INSERT INTO kkl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Yusup Firaun whingag piogpa, yubu sia leropne Firaundi, “Nari lenda mamna aghana, nimi nhondi babe lenda mamnange lelbatnenne orog. Aghana an sembe ka'ebannena, 'Lenda lilim ka'ebongkia abeneko pere lelbatsinep,' seangba, ka'eban,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Wene seogpa, Yusupti, “Nani, na kom. Allahri sikne lelbatkilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Wene aro ambarogpa, Firaundi, “Lenda malamnari kemelamnag agha Mag Nil abolag sekamna. ");
INSERT INTO kkl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Sekamnari kemelamnaag agha Mag Nil lomag agha pham sapi saekpare wali uro norop pham hong alam-alam aro siriktop pham walelangti, mag abolag pongoroba telamang. ");
INSERT INTO kkl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Telamangpa, kemelamsinag agha nen sap pham sapi saekpare yarirop-yarirop pham, nari babe Mesir so'o eneag undop pham ilihirop kom aghana sumene undo ipsin. ");
INSERT INTO kkl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Undo kemelamsinag agha yarirop-yarirop pham tanekori pham samenag walelangne wali uro norop pham taneko tehiang. ");
INSERT INTO kkl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tehiang aghana yarirop-yarirop pham taneko mon olog yogholbana babe orog, ot nika yariroba taneko wamangba mamnari pukna. ");
INSERT INTO kkl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Pukna aghana nen sap malamnari, kemelamnaag agha kwaneng roti sununa sembe meroba yo'o nhonag agha wana mauroba korokto saekbare mauamangba, yina ubu piamang. ");
INSERT INTO kkl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nen tipto malamnari, kemelamnaag agha kwaneng roti sununa sembe meroba yo'o nhon anekoag agha nen wana saekbare maubu piamang aghana aldesag khaori kolalem-kolalem ubu piamang. ");
INSERT INTO kkl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kolalem-kolalem ubu pilamangba, kemelamsinag agha kolalem-kolalem ubu pilamangne tanekori wana wali uro mauropne telamsiang. Undo mamnari, nimi lenda aneko peket lelbatnen nimiap, haing ka'en nimiap ambatsin aghana sindi tibin nenero lelbatneang kom,” aro Yusup nebarog. ");
INSERT INTO kkl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Wene aro Yusup nebarogpa, Yusupti nimi nubunge yubu sia leropne Firaunnag, “Lenda phende maplamne abene ot nhonog tam sembe maplam. Allah Eldi, 'Uanun,' sembamlange ambatkel. ");
INSERT INTO kkl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Wali uro norop pham saekpare iplamneap, roti wana wali uro mauroba korokto saekpare whi ubu pilamangpa, iplamneap ni abeneko tamna heng kun saekbare sembe maplam. ");
INSERT INTO kkl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nen mamlamdi, pham sapi yarirop pham saekpare ipsilamneap, roti wana mauroba aldesag khaori kolalem-kolalem ubu pilamangpa, ipsilamne abenena, kwaneng yo waelbaleri, heng kun saekpare wamlulne sembe maplam aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nari nai, an lenda maplama ambatkenne sunsunum uro Allah Eldi, 'Uanun,' sembamlange sembe ambatkelba, lenda undo maplam. ");
INSERT INTO kkl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Heng kun saekpare Mesir so'o eneag meroba polon tarag alamleba, kwaneng ten wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Aghana heng kun taibuka taubuka uroba saekpare talamleba, kwaneng yo nubunge waelbalul. Kwaneng yo waelbaleba, nimiri, 'Nari meroba maikno talba, naringe maikno wamla,' samen senenne ekon taukang. Kwaneng yo nubunge Mesir so'o eneag waelbaleba, mog so'o ene iklerebalul. ");
INSERT INTO kkl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Allahri, 'Uanun,' sembamlange lenda ik phende, nai, andi maplamne abenena, Allahri, 'Uanun,' sembamlange nen phelekalul kom, Allahri, 'Uanun,' sembamlange abene uro yabinual,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Wene aro ambarogti, “Nari lenda maplama ambatkenne sembe sik uro seneragmendi, nari ambatkenenge sunsunum uro ualulam. Ane sembe nimi nhon ero wepmendi, 'Nimi eneri seneragna wali, saelbamsori wali uaho,' senenne nhon weplulam. ");
INSERT INTO kkl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Ane sembe nimi nhon ero wepmendi, sekitmen tanena, nimi yogne el umag wamikti, kiliro ul palamukangne babe sekitsululam. Sekitsimenba ulamukangnena, heng kun saekpare Mesir nimiri meroba ten wamleba, Mesir nimiri tolamikti, palu lambare winilamukang. Aghana sin palu tombare telamikti, palu nhonna a'unag payalamukang. Ni asag kwaneng wipag pirop ae a'ero-a'ero sol tolamikpa, Mesir nimiri payalamikne taneko wip a'ero-a'ero palilamikpa, yae uro wamukang. ");
INSERT INTO kkl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tenaba wip-wipne palilamukangne nenena, kwaneng yo walel aleba, heng kun saekpare aneko tero une sembe wero palilamukang. Undo unuamik andarina kwaneng yo walel alenge neneko kwaneng yori Mesir nimi nhon tebaukang kom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yusupti lebogne sembe nimi nubunge yubu sia leropne Firaunap el umag wamek nangapti, “Wali lepla,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Wene seekpa, yubu sia leropne Firaundi el umag urop nangag hailamsiogti, “Nimi nhon Yusup saogne lunumna nhon wamla kom. Elna Allah yame elag to'opto wamla” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Wene seogti, Firaundi Yusubag yubu lelamogti, “Anna Allahri ni ane ambarelangkelba, ni el wamlam ane sembe nimi orangeap sunsunum kom. ");
INSERT INTO kkl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ane sembe wene nari an sekel ilangkennena, Mesir andi saelbapmendi, yubu lelapmenba, ka'elamikti, neleplamukang. Ot nana agha andi babe paliag nembamnululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Wene seogti, Firaundi Yusubag lelamogti, “Nari towalengelangken nenena, andi mog so'o Mesir andi saelbamlulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Wene seogti, Firaundi sae ma'alag tolongka uroba Firaundi saeag agha olobaogti, Yusupti sae ma'alag tolongkaogti, ag wet sop walinge agha wirop ag agha enekirogti, ngangag leng-leng aro kirik emas agha sunuroba ngangag warekirog. ");
INSERT INTO kkl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Warekirogti, “Na paliag wamna aghana Yusup phendepneag waelbalul” aro ambarelamogti, “Nari poa phiroba kereta phendepne waelbapmenba, nimi an whingag palamikti, 'Firaundi weplange Firaun sae sirik sip pukamlulne yalamla. Nuni!' alamukangba, waelbalulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Wene seogti, Yusubag ambarelamogti, “Na Firaun yubu sia leropne na ya'ag wamna. Aghana, an ekonagna nimiri awero nia uanepne Mesir so'oag ane sangsang uro ulamukang kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Wene seogti, Firaundi Yusup si Mesir yubuag agha engelamogti, “Saphnat-Pa'anea” aro si engkaog. Engkaogti, memne Potifera, On wamogne poneko elmangkel Asnat Firaundi tobogti, Yusup tarog. Undo unuaogpa, Yusupti Mesir nimi saelbamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusup mangkaekne eldinge heng kun selek ta'om agha epto wilindi wamogpa, el webek. Webekpa, Firaun umag awe tolamogti, Mesir as kanelamog. ");
INSERT INTO kkl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Heng kun saekbare kwaneng ten wamogpa, Mesir nimi meroba pongoroba polon tarag alamogpa wamek. ");
INSERT INTO kkl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kwaneng ten wamogpa, Yusupti roti sumbaneba meroba pongoroba taneko poloro as kanero yabalamogti, as taneko meroba ni palilamog. ");
INSERT INTO kkl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kwaneng as pololamogne taneko wip maikno, mag yengkea lolaptoba mag abolag saog uro nimiri babe a'ilbanep kom saog ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kwaneng yo yan komag Potifera as On memne poneko elmangkel Yusupti kel Asnatti me phende mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Me yandonge neneko Manasye aro engkaog. Yusupti Manasye aro engkaognena, “Allahri samen ua ulamsiri, seklelamsinge ekon nembaneogpa, naiap naro yaboap ekon tahisi,” aro engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Me phendepne Efraim aro engkaog. Efraim aro Yusupti engkaognena, “Seklelamna so'oag agha me Allahri tatnel,” aro Efraim engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Heng kun saekpare kwaneng ten wamogpa, meroba wamog heng kun saekpare eneko orog taogpa, ");
INSERT INTO kkl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","55","Yusupti samen Firaunag ambarogne sunsunum uro kwaneng yo waelbaog. Ni mog so'o Mesir kanero wamekne kwaneng yo wamek. Mesir nimiri babe “Kwaneng yo wamap,” aro Firaunag lelamekpa, Firaundi, “Yusubag pimundi, eldi yubu sunsunum uro ulamlulom,” aro ambarelamsiog. Mesir nimi babe kwaneng yo wamek aghana, samenag Yusupti kwaneng wero piboghag agha Mesir nimi ni kwaneng telamek. ");
INSERT INTO kkl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Kwaneng yo ikinne wamogne anena, Mesir ni mog so'o babe mog so'o peramag ni babe kwaneng yo wamek. Mesir nimiap, ni as kanero wamek nimiap, weag nimiap babe kwaneng yo wamek. Aghana, Yusubag yalamekpa, Yusupti kwaneng poloro pia urop aeag agha tolamogti, kamna kaplamekpa, tarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Sikini Yakubti ka'elamogpa, “Kwaneng roti Mesir wamla,” seeka ka'ebaog. “Wamla,” seeka ka'ebaogti, elmaboag yubu lelamogti, “Sa'a sembe namabo aingniro ulamlom?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nen yubu lelamogti, “Na yubu ka'ebanne 'Mesir kwaneng roti wamla,' seanga ka'eban. Kwaneng yo seklero tebabeag, ane sembe pimundi, kwaneng roti kamna toro payalulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wene seogpa, Yusup eldo yabo sa'obare “Kwaneng roti tobukap,” aro Mesir piek. ");
INSERT INTO kkl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakubti elme Benyamin Yusup ilipsae nhon “Pheng kom,” aro salero pibognena, “Inaag palamikpa, opleag” aro salero pibog. ");
INSERT INTO kkl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaan kwaneng yo waelbaogpa, nimi orange babe Mesir kwaneng kamna toro tol alamekpa, Yakub elmabo babe “Tobukap,” aro yaek. ");
INSERT INTO kkl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kwaneng roti mog so'o ni ane kamna tol alamekpa, tarelamsiognena Yusup. Mog so'o Mesir saelbamogpa, eldo yabo yaekti, sikinipsae Yusup whingag yabu sanukto pulingkina kibek. ");
INSERT INTO kkl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusupti eldo yabo ipsiog aghana, maneri ipsin koma saog uaog. Yusupti, “A'unna tala nimi?” aro yubu yo uro haibahiog. Haibahiogpa, sindi, “Nu Kanaan mog so'oag wamap nimi agha, 'Kwaneng tobukap,' aro yaap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusupti eldo yabo whingna iamsiog aghana, eldo yabori elna iamek kom. ");
INSERT INTO kkl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Iamek komba, Yusup eldi lenda sin sembe malamogne seneraghogti, “A'un nimi tane yalom nena, haing toro nimi wea urop komag mog so'o eneag wamlange kemenelehin nimi yalom,” aro wene seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wene seogpa, sindina, “Nuni, undo kom. Nun yaapnena, 'Kwaneng tobukap,' aro yaap,” seekti, ");
INSERT INTO kkl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","“Nani, nu yaap nang enena, nun kongap nang. Nai ot nhon. Nu wana porog nimi. Nu kemenelero haing tohirop nimi kom,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Wene seek, aghana eldi lelamogti, “Orolena. A'un yalomne mog so'o ene 'Yae ua unne sogna wamlaag kembaukap,' aro yalom,” seogpa, ");
INSERT INTO kkl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sindina, “Nu kongap nang aobare nang. Nu Kanaan so'oag wamap, nuri nai ot nhon. Nhonna loba taog pana, wenena elabome nen tagha iliap wamdang,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Wene seekpa, Yusupti, “Yo! Usaap taneko lemna, a'unna haing toro kemenelehin nang,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","“Wene selom aghana, a'un nari mipsinun. Nari sik uro nimi nubunge yubu sia leropne siag lelamnange, anam a'unipsae anam yan komag a'un nhon babe pululom kom. ");
INSERT INTO kkl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A'un agha nhon wepmunba, pileri, a'unipsae tol pulul. Tol piamleba, nennena sae kaupto piamsinun. A'undi leplomne sik talul to? A'undi leplomne neneko orolena tanena, sik uro nimi nubunge Firaundi lepso saog uro nari lelamnangena a'unna kemenelehin nang,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Wene seogti, ni kop aeag tobongkipsiogpa, ik wilindi wamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ik wilindip sum Yusupti sinag yubu lelamogti, “Na Allah sembe log uro wamnange. Nari a'un sae lipsinunne, ot ina nhon. ");
INSERT INTO kkl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","A'undi leplomne sik sembanepne sembe, a'un agha nhon kop aeag salero pibukap. Orangena kwaneng tobomne popmundi, a'undi kelabo me kwaneng yo seklelamangne sembe pabululom. ");
INSERT INTO kkl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pumun aghana, a'undi leplomne sik senena sembe a'unipsae elabome neneko payalulom. Kom tanena tam ikinne nari a'unag pimnun,” seog. Wene seogpa, “Yo,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sin mamun yubu lelamekti, “Wene nunag tam talamlangena, samenag nuri nunipsaeag uabunge sembe, 'Naro yabo omneheng kom,' aro wene alamog aghana, nuri el sembe o'ona sembabu komdi, obubu. Aneko sembe wene tangoro nunag talamla tam nene seklelamap ane,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Wene alamekpa, Rubendi ilipsabo tanekoag yubu lelamogti, “'Obukap,' alamlumba, nari 'Opseng kom moaba apmunagti,' aro ambatsisi kom te. Wene alamsi aghana, ka'ebanulum kom. Wene el tebaogne neneko eneng aneko sembe nun eneng lunup talul,” aro wene alamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wene alameka Yusuptina ka'eamsiog aghana, eldoyabori seneragamek kom. Sindi lelamekne nhon meri Yusubag yubu tiplamog. ");
INSERT INTO kkl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wene alamekpa, Yusup sin laploa piogti, engel piogti, yaogti, “Simeon haing kauplulom,” aro ambatsiogpa, elkabo whingag agha salero haing kaupto pibek. ");
INSERT INTO kkl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Simeon sae salero pibekpa, Yusupti eldi aruknaag ambarelamsiogti, “Sindi ag poa yaongneag kwaneng lilapmundi, kamna tobong kirik solomne samoro sindi aghag libahilulom, apna kwaneng inaag tenepneap,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Libaekpa, Yusup eldo yabo taneko kwaneng taneko popsirop pham keledai alibag towalengkibekti, palamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mamnebag aneko piekti, sin taneko nhondi, “Pham keledai kwaneng tatnun,” aro ag ina siram kwhabia agha kemelamogpa, kirik solomne kwaneng kamna tobog kirik eneko ag ina siramag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wamogpa, ibogti, elkabo nenneag ambarelamsiogti, “Nangkabo, nari aghag kembamun! Kirik solomne naringe samoro pibang,” seogpa, kembaekti, sin mamun kemeptaom agha log lelem pet-pet alamekti, “Nuni Allahri nunag sa'agha ulamla?” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanaan sikini wamoghag piekti, sinag uro yabiogne sikiniag ambarekti, ");
INSERT INTO kkl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mesir so'o saelbamlange ponekori hagto walamsildi, 'A'unna mog so'o eneag wamlange haing toro kemenelen nimi,' alamsio. ");
INSERT INTO kkl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Aghana nuri elag lelamobori, 'Nuna wana porog nimi, nuna haing toro mog so'o kemenelen nimi kom. ");
INSERT INTO kkl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuna kongap nang aobare nang naina ot nhon. Nhonna ka'aseptaog bana, wenena nunipsae elabomeog iliap Kanaan wamdang,' sebo. ");
INSERT INTO kkl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Wene seboba, mog so'o Mesir saelbamlange ponekori nunagna, 'Na a'undi leplomne sembe mipsinun. “A'un sik wana nhonog nimiro,” aro a'un sa'obare wamlom nang ene agha nhon nanag wamleba, kwaneng kelabo me si tarapnange sembe kwaneng pabululom. ");
INSERT INTO kkl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Pabumundi, a'unipsae elabome neneko nanag payamun taneogna, nari a'un sembe, “Haing toro mipna nang kom, wana nhonog nang,” sembahineri, a'unkae lambatsine taneogna, mog so'o eneag hae pang yang ulamlulom,' aro wene seo,” aro sikiniag nebarek. ");
INSERT INTO kkl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nebarekti, pabieka taneko toro la'anilamekti, kemelamekpa, kirik solomne kwaneng sembe kamna kapto tobeka taneko ni nangdinge aghag ubu piamogha sikiniap kembaekti, log senelamek. ");
INSERT INTO kkl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kembaekti sikiniri lelamogti, “A'undi unulamlomdi, namabo ka'asebel talamang. Yusup orog taog, Simeon orog tao, wene Benyamin pabunualom. Nanagha sol olamnelomba, ulamnun,” aro wene alamog. ");
INSERT INTO kkl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Sikiniri wene seogpa, Rubendi iliag yubu lelamogti, “Nani, wene selam aghana, Benyamin na saeag tatnululam. Samoro payane kom tanena, nari mabo me phende ya'ag opsululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Wene seogpa, iliri, “Name, elna anap nhon pulul kom. Eldona tebaogba, ilipsae ot nhonog wamla. Palamtumunba, inaag agha ople tanena, penelamnelomne sembe seneragto ulamneri, kul hong yabukom agha teplomnun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Kanaan kwaneng yo nubunge waelbaogne aingnibaog komba wamek. Kwaneng Mesira tol aekne taneko orog taogpa, Yakubti elmaboag yubu lelamogti, “Kwaneng nuringe orog talbana, a'un Mesir pimundi, kwaneng tol pululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Sikiniri, “Tol pululom,” seogpa, Yehudari ili Yakubag, “Nimi enekorina yubu ambarelamsiori, 'A'unipsaeap nhon yamun kom tanena, na whingna imnululom kom,' seo,” seogti, ");
INSERT INTO kkl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","“Nai, andi agha, 'A'unipsaeap pululom,' semen tanena hae piberi, kwaneng toa yaukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nen lebogti, “Nairi, 'A'unipsae Benyaminap pululom kom,' semen tanena, pukap kom. Nimi enekorina, 'A'unipsaeap yamun kom tanena, nanap haiptaukap kom,' seo,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Wene seogpa, Yakubti, “Namabo, a'undi na loba nenelamnelom. Sa'ambe nimi eneag, 'Nunipsae nhon wamla,' aro wene seom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wene seogpa, elmaborina, “Nimi enekorina haim-haim alamsio. 'A'uni kamag wamla te, a'unipsae nhon wamla te?' aro hailamsioag aneko ambarobo. Nunag ambatsiongena, 'A'unipsae payalulom,' seo ana nu babe ekon wamobori, ambarobo. Ambaroboag agha nuri eldi wene sulul sembamobo komne 'A'undi a'unipsae payalulom,' seo,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Wene seekti, Yehudari iliag lelamogti, “Nai, 'Mene anap pululom,' semenba, pukap. Tam uro yabineba, mene sembe nari o'obanun. Nun kwaneng yori, nhon si tarababeag. ");
INSERT INTO kkl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nari el o'obanun. Nai, nari saeag piplulam. Nari agha el samoro payane kom tanena, tam neneko nanag sembeng ana ya'ag nanag wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nun ta'abamna koma phebeagti, ik phende pang yang uahabe,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Wene seogpa, sikini Israel ponekori, “Undo wene selom tanena, mog so'o eneag wamlea wali saogha a'undi ag nhonag libamundi, eldi wali senena nimi eneko tarel pululom. Pabalapmundi, nikna whesinna pelagtangtobap, pondog magap, kwaneng ma'al yonaap, teptop nimi song kom nenenneap, yalukap tarel pululom. ");
INSERT INTO kkl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kirik solomne kwaneng tonneap babe poa pululom. Samenag ag ina siramag wamoba, tobomne babe pabimundi, samoro tatlulom. Kirik solomne anena wanaag ogto uaong sembanorina. ");
INSERT INTO kkl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","A'unipsae babe poa pimundi, elemag Mesir yubu sia lenneag pululom. ");
INSERT INTO kkl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Allah Imap So'oap Saelbamlangeri wana wali nembaleba, a'un o'ona sembahileri, 'Simeonap Benyaminap samoro nhon pabhululom,' aro a'un saeag tatsilul. Tagha nana wela uanun kom, namabo ya'ag ka'asebel talamang ane,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wene seogpa, Yusup eldo yabo tanekori wali-waliaap, kirik solomne kwaneng kamna tomnepneap, sindi ag ina siramag wamogpa, tobekne “Samoro tarukap,” aropneap, Benyaminap elemag nhon Mesir piek. Mesir piekti, Yusup whingag wa'iek. ");
INSERT INTO kkl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kemelamogpa, Benyamin eldo yaboap nhon pieka kembiagha, eldi arukna aeag tolamogne yoplamogti, “Nimi tane nari aeag paphilulam. Sumene ae sironge nene kwaneng nanap nhon tukap. Ane sembe pham nhon opmendi, yoro tengelamlulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Eldi arukna anekori ka'ebaogti, enero poa Yusupti aeag poa phiog. ");
INSERT INTO kkl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yusupti aeag poa phiogpa, sin log sene-sene yabaeknena, “Nun ane, 'Paiag nang yaang,' aro nen samen sum yabonge neneko kirik solomne ag ina siramag wamoba, tobobonge neneko sembe payahiang. Neneko sembe nun saelbahiangdi, pham keledai nuringe toro agha sindi arukna nemban uahiang,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ane sembe Yusupti aeag wamekti, ina serekna peramag ae yae ua uropne ponekoag, ");
INSERT INTO kkl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Naiyong, nu yubu olog wamla. Nu ane kwaneng tobukap agha ane samenag yingkiamobo. ");
INSERT INTO kkl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Ane yingkina palamobori, nu ae inaag mamnebag aneko pina, ag si kwaro kemelamoboag agha kirik solomne nuri kwaneng tobobonge ni aneko nuri kwaneng ag ina siramag wamo. Ane sembe nu babe ekon, etneri nuri aghag libao ane ekondi, wene nen sap samoro kwaneng tobukapne babe, kirik solomne kamna nuri aghag wamonge babe, 'Samoro tatkukap,' aro payaap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wene seekpa, nimi yeplamsiogne ponekori, “Nene sembe log sembaheng kom. A'uni mema si, aniri Ili Allahri a'undi aghag libao. Wene a'undi tatneomne kwaneng sembe anekona na tomno,” seog. Seogti, sikinkae Simeon lambirogti, elkaboag tatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wene seogti, aeag poa wa'isiogti, yan a'elerona mag tebatsiogti, pham keledai sindinge taneko babe tenaba tatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Undo unu ahiogpa, sindi babe Yusup “Wana wali nenero tarukap,” sembaekti, pobeka taneko babe “Sironge nene yaleba, tarukap,” aro togto piamek. ");
INSERT INTO kkl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Togto piamekti, wamekpa, Yusup yaogpa, yabu saknukto Yusup whingag pulingkina tarek. ");
INSERT INTO kkl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tarekpa, Yusupti, “A'un welaro wamlom?” aro hailamsiogti, “A'undi a'uni sembe nanag ambarelamneomdi, 'Nuni sabal uroba wamla,' seom aneko wali wamla te? Welaro wamla?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wene seogpa, sindina, “Nu nuni wali wamlari, andi arukna wamla,” seek. Wene seekti, yabu sanukto pulingkina kibek. ");
INSERT INTO kkl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wene aro kibekpa, kemelamsiogti, ilipsae taptopne Benyamin sin anabiag wamogha kembaogti, “'Nunipsae elabome wamla,' seomdi, ambatneomne neneko te?” seogti, lebogti, “Name, Allahri yepto piangkilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wene seogti, ilipsaeag kembiagha, “Na naipsae o'ona nuba maum nhonog,” aro kembiagha, “hailmag lagto pelengena mali,” ane sembe elem-elem eldi ae lomag piogti, engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Engkaogti, hailmag luptangom agha lamba yaogti, “Kwaneng yoro piplomne pil alulom,” seog. Wanaagna engelamogtiog. ");
INSERT INTO kkl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusup elba mo kwaneng terobag pukamogti, teog. Eldo yaboap ilipsaeapna nhonag pukamekti, teek. Mesir nimi taneko wamek nimi elba sin nhonag teek. Mesir nimi Ibrani nimiap kwaneng nikag tena sin karong senen. Ane sembe Mesir nimi yog nimi tane wameknang eneko babe mo kwaneng telamekag pukamek. ");
INSERT INTO kkl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusup babe elba mo nhonag pukogti, teog aghana, Yusup eldo yabo taneko sin pukeknena, Yusupti arukna anekori, “Yandonge pukleba, ane iklibagne undo puk-puk yabukang,” aro pukitsiog. Sin undo pukekti, kemep taekti, el taekti, lo'om seek. ");
INSERT INTO kkl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusup eldo yabo tanekona kwaneng Yusupti kwariag agha tatsiek. Kwaneng telamekti, eldo yabo taneko etbarero undo tatsiekti, Benyamin agha ik lambare tarekpa, teog. Sumeneko agha kwanengap magap Yusubap nhon og soro teek. ");
INSERT INTO kkl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusuptinge ae yae ua uropne ponekoag ambarelamogti, “Kwaneng sindi poa pineba, uro lilamsimendi, sindi kirik solomne kamna tobika aneko nen samoro sindi ag ina siramag libahilulam. ");
INSERT INTO kkl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Naringe mag tena solomne agha sunuroba anena sikinipsae elabongeri ag ina siramag libalulam, apna kirik solomne kwaneng toplange kamna anekoap nen samoro eldi ag ina siramag libalulam,” seog. Wene seogha sunsunum uro Yusupti arukna aneko uaog. ");
INSERT INTO kkl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kwelekaogpa, lukunap ae tibin talamog abeneko Yusup arukna tanekori “Pululom,” aro sae lipsiekpa, poahirop pham keledai taneko alibag towalengkibekti, palamek. ");
INSERT INTO kkl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mesira lambaekti, anam we uro pin komag Mesir so'oag palamekpa, Yusupti eldi ae yae ua uropne ponekoag yubu lelamogti, “Elemag sarekarepto sin palamikag pululam. Sarekarepto sinag pimen tanena, sinag leplulamnena, 'Sa'a sembe nairi walia ulamlaba, a'undi naiag yoaba ulamlom? ");
INSERT INTO kkl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Sa'a sembe nairinge mag tena solomne agha sunuroba haogha tobom? Mag tena anena, nai mag tero el amik unag sembe pom-pomoro el tan ana. A'undi yoaba nubunge uaom,' sululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wene seogpa, Yusupti ae yae ua uropne poneko Yusup eldo yabo inaag palamekag piogti, Yusupti ambarogne sunsunum uro lebog. ");
INSERT INTO kkl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wene aro ambatsiogpa, Yusup eldo yabo tanekori, “Sa'a sembe nuniri undo lepla? Sa'a sembe elag nuri yoaba uahabe? ");
INSERT INTO kkl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Samen sum eneko babe kirik solomne nuri ag ina siramag wamonge babe samoro payabonge an el wamlam. Welaro nuri nairinge aeag ua uroba kamna maiknoro toroba welaro topsebe?” seekti, ");
INSERT INTO kkl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","“Nuringe aghag etneri aghag agha mag tena ane ipmen tanena, wamleba, ipmen meneko tebalul apna nai arukna taukap,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Wene aro ambarekpa, Yusup arukna anekori, “Wali leplom aghana, etneri aghag wamle tanena, el neneko agha nai arukna talul. Wene nennena hae pululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wene seogpa, sindinge ag pham keledai alibag agha pelengero so'oag pibekti, ag si kwha-kwha yabiek. ");
INSERT INTO kkl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ag si kwhabaekpa, Yusupti arukna ae yae ua ulamogne ponekori sen-sen agha yandongeri aghag samenag alnibaogti, eroba elabongeri aghag. Elabonge Benyamindi aghag elamogpa, mag tena Yusupdinge neneko Benyamindi aghag wamog. ");
INSERT INTO kkl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Eldo yabo taneko sikinipsae sembe o'ona ua ahiogpa, sindinge ag enekto amekne saeri taepto unuaekti, pobeka taneko pham keledai alibag towalengkibekti, samoro Mesir piek. ");
INSERT INTO kkl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yehuda ilipsaboap Yusupti aeag palamekpa, Yusup aeag wamogpa, pina elemag yabu sanukto pulingkina kibek. ");
INSERT INTO kkl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kibekpa, Yusupti lelamogti, “Sa'a agha a'undi ualom? A'unna ekon te? Na saogne pone a'undi ulamlomne ag pom-pomoro yoaba ulamlomne ipsenep,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Wene seogpa Yehudari, “Nai, nuri anag yubu lemnep kom. Sa'a agha lebukap. Welaro agha nuri, 'Malia uan kom,' senep kom. Allahri nu anmabori ulamapne ane sel. Wene nu ni ane an arukna taukap. Mag tena eldi aghag wamlange neneko aghabog kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Wene seogpa, Yusupti, “Kom! A'un nenne a'uniag samoro wali uro pumunba, elba naringe eldi aghag wamlange nenekoog, nari arukna talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Wene seogpa, Yehuda sekom agha Yusup peramag piogti, “Nani, na nen olog yubu lemnun. Na wabaneheng kom, an nimi nubunge yubu sia leropne saog uro Mesir wamlam. ");
INSERT INTO kkl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Samen yabonge neneko nai andi hailamsiomdi, 'A'undi nai babe a'unipsabo babe wamang te?' seom. ");
INSERT INTO kkl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wene seomba, nurina, 'Nuri nai sabal tao, elme olog me nhon wamsilnena, sabal taoag agha toro aonge. Sin phendena sikinin ot nhon. Eldona tebaog aghana, eldi maum tattopne agha wamsil, ane sembe iliri mene sembe wanaag uro ua ulamla,' sebo. ");
INSERT INTO kkl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nai, andi 'Payamunba, kembanun,' seoma sembe payabo. ");
INSERT INTO kkl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Aghana nuri nai anag ambarelangkebori, 'Menena iliri sae limnep kom. Mene agha ili sae limna tanena, waba kaong senep saog,' seboba, ");
INSERT INTO kkl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","andi lelamomdi, 'A'unipsae elabonge neneko agha payamun kom tanena, na whingag yalulom kom,' seom. ");
INSERT INTO kkl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Wene seomba, Kanaan mog soo ag pibori, nuri nai Yakub an yeplangkelne ponekoag ambarelamobori, andi lebomne abeneko ambarobo. ");
INSERT INTO kkl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ambaroboba, nairi 'Nen kwaneng tol pululom,' aro arukahio. ");
INSERT INTO kkl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aghana nuri naiag lelamobori, 'Nun mona pukap kom. Nunipsae nhon taneogna pukap. Nunipsaeap pibe kom tanena, nimi enekori whing ibukap kom,' sebo. ");
INSERT INTO kkl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Wene aro nai ambaroboba, nairina nunagna, 'Namabo, a'un el wamlom. Nari kel Raheldi me phendeog yag nembitsio. ");
INSERT INTO kkl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Me samenagne ka'aseptaog, yoabari teog to. Ka'aseptaog aneko olog haiptangtop kom. ");
INSERT INTO kkl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Wene babe name elabonge nene na saeag agha topmunba, uro yabinep komne uro yabile tanena, na sabalag anda nanagha tipto loba nembanumunba, tebanun,' seo,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Nen tipto ambarelamogti, “Nani, ane sembe nanagha naipsae koma naiag pine tanena, andi arukna nuri nai loba talul. Eldi hainna meneag tiptangkamla, apna el ya'ag sabal taobana, nuri sap wana mali nembabe tanena, sap tipto loba nembaukap. ");
INSERT INTO kkl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Apna nari naiag salag lelamnori, 'Na saeag piplamba, nari me ane o'obanun,' seno. Nari agha, 'Me ane samoro payane kom tanena, tam ualea nanagha sa'obanun,' seno. ");
INSERT INTO kkl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ane sembe nanagha mene lunumna an arukna taneri, tane wamnun. Me anena sae lipmenba, eldo yaboap nhon pukang. ");
INSERT INTO kkl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mene koma nanagha naiag panne sunsunum kom. Na mene koma na naiag panba, naiag uro yabinep komne uro yabanne nenena, na haingdi ilina mali,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","2","Yusupti elkaboag kembiagha wanag seneraglamogne tognoamnep kom ulamogpa, nimi el umag wamekne tanekoag, “Lambalulom,” seog. “Lambalulom,” seogpa, lambaekpa, Yusup elkaboap mo wamek. Mo wamek aghana, Yusup neneko maiknoro engelamogpa, Mesir nimiri babe Firaundi aeag wamek nimi babe engena sembe ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusupti elkaboag ambarelamsiogti, “Nana Yusup! Naina anam wamla te?” seog. Wene seogpa, sin kaebaekti, sin log sembe yubu samoro ambarek kom. ");
INSERT INTO kkl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yubu samoro ambarek komba, Yusupti elkaboag yubu lelamogti, “Na peramag abene yahut!,” seogpa, peramag yaekpa, ambarelamsiogti, “Na a'unipsae Yusup, a'undi Mesir nimiag kamna topnelumne poneko,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nen lelamogti, “Aghana wenena, mane agha 'Yoaba uaburi, nuri nunipsae kamna toro tatsibu' aro waptangto wanaag seneragseng kom. Nana Allahri enero poa yaneognena, nimi tebaikag aro nimi wali nembahinepne sembe na samenag yahi. ");
INSERT INTO kkl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kwaneng yo waelbaoa heng kun phende uabori, heng kun wamukapne lambare nen wamukapneagna nimiri wero tenne orog wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Allahri na samenag enero payaneogpa, a'un amik yaomnena, a'un wali wapmundi, a'undinge nimi likna tipto pilul aro payaneogpa, yeplamsinun. ");
INSERT INTO kkl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ane sembe a'undi ulamnelumba, ane yahi kom, Allahri sembaogneag agha. Eldi na epneori, 'Firaun yubu amoropne wamleri, Firaundi awe yan sae awe toro saleropnang sikini, Mesir mog so'o ene sikini wamlul,' sembaogti, Allahri na paliag sekitneog. ");
INSERT INTO kkl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ane sembe elemag samoro nani Yakubag pumundi, 'Anme Yusupti undo lepla,' aro ambatlulomnena, 'Allahri anme Yusup sembe nimi nubunge mog so'o saelba unne nembaongena, mog so'o Mesir ni semberina, “Elemag yalulom,” seo,' aro ambatlulom. ");
INSERT INTO kkl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Na peramag Gosyen yingkina wamlul. '”Naiap ilisag yaboap pham domba, kambing, sapi apna saeagha wamlea niap,” seo,' aro ambatlulom. ");
INSERT INTO kkl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nai Gosyen yingkina wamle tanena nari piamnun. Kwaneng yo nen heng kun lambare wamukap, ane sembe naiap kelabo meap pham eldingeap tenaba yo uro wamukang kom. ");
INSERT INTO kkl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Wene a'undi kembanelom ane. An Benyamin andi babe. Na sik tapto na Yusup. ");
INSERT INTO kkl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Naiag ambatlulom, na Mesir sembe saelbamna. Elag babe ambatlulom, a'un kembalomdi iplomne ni ambatmundi, elemag-elemag payalulom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wene seogti, Benyamin somoro salero amogti engelamog. Benyamindi babe eldo salero amogti engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusup engelamogtiog eldo yabo nenne babe somoro kiplamsiogti, tog-tog aro kipsiog. Kipsiogpa yubu lero eldo yabo taneko aro wamek. ");
INSERT INTO kkl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yubu sia leropneri aeag agha ka'elamekpa, Yusup eldo yabo yang ana ka'ebaekti, yubu sia leropne babe el umag wamekne babe awi yeng sembaek. ");
INSERT INTO kkl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Yubu sia leropne Firaundi Yusubag yubu lelamogti, “Ando yaboag ambatsululam: 'A'undi pham keledai alibag kwaneng towalengkamundi, poa Kanaan pululom,' sululam. ");
INSERT INTO kkl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Andi naiap andi nairi kelabo meap kerero ane yananne sembena, nari so'o walinge mog so'o eneag wamlange tatsinun. Tatsineba so'o eneag agha wero tero wamukang. ");
INSERT INTO kkl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Palamikti poa pukanga ambatsululamnena: Sikiniap sindi kelabo me ologneap yanana sembe phamdi kiliro poroba kereta etbarero poa pukang. ");
INSERT INTO kkl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Sikininge aba sembe wana sesog uro seneragukang kom, 'Mesir so'oag ane babe walia ni so'o eneag wamla,' aro ambatsululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yubu sia leropneri Yusup ambarogpa, Yusupti pham keledairi kiliro poa phiroba kereta kerektopne etbare yubu sia leropneri lebogha sunsunum uro tatsiogti, kwaneng inaag tenne babe Yakub elmabo taneko tatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ag pol tona tarelamsiogti, eldo yabo taneko nongagneap yanagneap nhon-nhon tarelamsiogti, Benyamin agha kal ma'al kirik wana solomne teng ko'olombare tarogti, ag enekel tonne nongagne lambare yanagne lambare tarog. ");
INSERT INTO kkl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yusupti ili Yakub sembe palilamogti, pham keledai saobareag wali-walia Mesir so'oag wamogha towalengkaog. Pham keledai sa'obare alibagna, kwaneng roti wana mauroba erenneap, kwaneng roti aukag taropneap, apna kwaneng “Mesir yalamleri nani tulul,” aropneap pibog. ");
INSERT INTO kkl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Eldo yabo tatsiogpa, palamekpa, Yusupti, “Inaag waptaheng kom,” aro wene seog. ");
INSERT INTO kkl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Palamekti Mesir laplobiagha Kanaan so'oag sikini wamoghag piek. ");
INSERT INTO kkl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Piekti sikini ambarelamekti, “Nai, Yusup Mesir so'oag kamag wamlari, eldi mog so'o Mesir saelbamla” seeka ka'ebaogti, “Orolena lelamang,” aro sik sembaog kom. ");
INSERT INTO kkl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aghana Yusupti ni lebogne ambarekpa, Yusupti, “Kereta poa pukang,” aro pibogne ibogti, Yakubti sik sembaogti, yeng sembaog. ");
INSERT INTO kkl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ibogti sikini ponekori lelamogti, “Yusup name kamag wamnel. Nene sembe wamna. Pineri imneriog tebanun,” alamog. ");
INSERT INTO kkl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wameka Yakub nenekori eldinge nia togto tobogti, “Mesir mog so'o punun,” aro as Bersyeba piogti, ili Ishakti Allah omeklamogne sembe pham obogti, mhong towalengkaog. ");
INSERT INTO kkl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mhong towalengkaogpa, imbaogpa, Yakubti haing uamna kwelekamna senenag agha Allahri yubu lelamogti, “Yakub, Yakub,” seogpa, Yakubti, “Nani na ane wamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Wene seogpa, Allahri, “Na Allah, ani Ishakti Omeklamneogne Na wamna. Mesir panne sembe log sembaheng kom! Mesir mog so'o anea anisag yabo maikno nembahineba, as nubu tangto wamukang. ");
INSERT INTO kkl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na anap Mesir nhon pinemeri, amik anisag yabo samoro payaghenun. An loba tamenba, anme Yusupti o'obaghelul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ambarogpa, Yakub elmabo tanekori sikiniap, sindi kelabo meap, pham kudari kiliro poa phiroba alibag Mesir nimi sikini yubu sia leropneri arukahiogpa, sin tol ahinep yaekne tanekoag waelbaek. ");
INSERT INTO kkl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Sikininge phamap, sikininge aba Kanaan wamekpa, saeag taogneap, taneko poro agha mog so'o Mesir palamek. Palamekti Yakub sikinisag yabo nengabo me kelabo me toro agha Mesir ni palamek. ");
INSERT INTO kkl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Eldamne Yakubap, elmaboap, sikinmaboap, kelaboap piekne sina tane: Ruben, Yakubti me yandonge. ");
INSERT INTO kkl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben elmabona: Henokh, Palu, Hezron, apna Karmiap. ");
INSERT INTO kkl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, Yakubti me nabime. Simeondi mabona: Yemuel, Yamin, Ohad, Yakhin, Zohar, apna Kanaan keldi me Syaulap. ");
INSERT INTO kkl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, Yakubti me Simeon iklibagne. Lewiri mabona: Gerson, Kehat apna Merariap. ");
INSERT INTO kkl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yehuda, Yakubti me Lewi iklibagne. Yehudari mabona: Syela,Peres, apna Zerahap. Yehudari mabo Kanaan so'oag agha tebaeknena: Er apna Onanap. Yehuda elme Peresti mabo nen phende mabona: Hesron apna Hamulap. ");
INSERT INTO kkl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakhar, Yakubti me Yehuda iklibagne. Isakhar elmabona: Tola, Pua, Yasyub,apna Simronap. ");
INSERT INTO kkl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulon, Yakubti me Isakhar iklibagne. Zebulon elmabona: Sered, Elon, apna Yahleelap. ");
INSERT INTO kkl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ni ane Lea elmaboap elau yaboap. Aram mog so'oag wamekti, Yakub sembe mangkahiog. Ni nimi si palilamapne anena Yakub elmaboap ilisagyaboap nina teng nhon eptopne no'op bare (33). Yakubti kelmabona Dina wene babe palilamap. ");
INSERT INTO kkl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad, Yakubap Silpaapti me amikne mangkahirekne. Gad elmabona: Sipyon, Hagi, Syuni, Esbon, Eri, Arodi, apna Areliap. ");
INSERT INTO kkl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, Yakubti me Gad iklibagne. Aser elmabona: Yimna, Yiswa, Yiswi, Beria, apna Serah sikinipsa'elap. Beriari mangkhaiognena: Heber, apna Malkielap. ");
INSERT INTO kkl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nimi ao tarabare anena Yakubap Silpaapti mangkahirekne. Silpa kelenena, Lea ili Labandi, “Lea arukna wamlul,” aro tarog keldi mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Raheldi mabona me phende Yusubapna Benyaminap. ");
INSERT INTO kkl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Mesira Yusubap elkel Asnatapti me phende mangkahireknena: Manasyeapna Efraimap. Asnat ilina, Potifera memne poneko as On wamog. ");
INSERT INTO kkl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin, Yakub elme elabonge. Benyamin elmabona: Bela, Bekher, Asbel, Gera, Na'aman, Ehi, Ros, Mupim, Hupin apna Aredap. ");
INSERT INTO kkl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Anena Raheldi Yakub sembe mangkahiognena. Sin nina mekpare. ");
INSERT INTO kkl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yakubti kel taogne Bilha anekori elme amikne Dan mangkaog. Dan elmena Husim. ");
INSERT INTO kkl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali, Yakub elme Dan iklibagne. Naftali elmabona: Yahseel, Guni, Yeser, apna Syilemap. ");
INSERT INTO kkl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Anena Bilhari Yakub sembe mangkahiogne. Bilha kel enena Labandi, “Rahel arukna wamlul,” aro tarog keldi mangkahiog. Sin ni anena saekbare. ");
INSERT INTO kkl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakub elyamal yabo sikindi me wamla aghana Yakub elyamal sembe tane mome torop kom. Sin ni Yakub elmaboap Mesir so'oag pieknena teng phende eptopne aobare (66) piek. ");
INSERT INTO kkl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusup elmabo Mesira mangkahiogne me phende abenekoap tanena sin teng phendeap eptopne ao tarabare (70) taog. ");
INSERT INTO kkl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Mesir palamekti, Yakub nenekori elme Yehuda ambarelamogti, “An samenag pimendi, 'As Gosyen haiptukap,' aro Yusup ambatlulam,” seog. Wene aro poghogti, Yakub neneko as Gosyen pina wamogpa, ");
INSERT INTO kkl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusup neneko “Nani whingag punun,” aro pham kudari kiliro pabiroba alibag waelbaogti, ili whingag yaogti, somoro saelbamogti, kiplamogti, engkaog. ");
INSERT INTO kkl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Engelamogpa, Yakubti elme Yusubag yubu lelamogti, “Nari an ipkekendi, 'Name kamag wamla,' aro wana aingnibanelba, wali loba tanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Wene seogpa, Yusupti elkabonge tanekoag yubu lelamogti, “Na nari nai yubu sia leropneag pineri, 'Nari naiap nangkaboap Kanaan so'oag agha yaong,' sunun. ");
INSERT INTO kkl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","'Na nangkabo taneko pham dombaap, sapiap, yae uro mo'olamsiang-nang sikininge phamap, sikiningeaba ni poro agha yaong,' sunun. ");
INSERT INTO kkl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Na nani nimi nubunge yubu sia leropne ponekori yopsileri, a'undi awe saelba weropne sembe haibahilul. ");
INSERT INTO kkl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","A'undi ambarelapmundi, 'Nuniyabori babe pham mo'olamek saog uro nuri babe nun ologhag agha pham mo'on nang wamap,' aro ambatlulom,” seogti, “Wene aro ambatmunba, 'A'un Gosyen so'oag wamlulom,' sulul,” seog. Wene aro ambatsiognena, Mesir nimiri pham pia urop nimiap, sin nikag ua unna sin karong senerop, ane sembe Yusup eldi elkaboag wene aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Wene seogti, eldo yabo lambare enero poa Mesir nimi sikini Firaun saramag poa phiogti, ambarelamsiogti, “Nari naiap, naro yabongeap, sindi pham kambing, domba, sapiap sikininge saeag agha wamlaap, Kanaana yaangdi, wenena Gosyen so'oag wamang,” aro ambatsiog. Wene aro ambatsiogti, elkabo lambare nhon piekne abeneko sindi si babe ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","4","Wene aro ambatsiogpa, nimi nubunge Firaun ponekori, “A'undinge awe huropne?” seog. Wene seogpa sindina, “Nuna pham mo'oro yae ua urop nimi, samenag isang wamog saog uro,” seekti, “Nu yaapnena, Kanaan kwaneng yo waelbaoba, tena nuri pham sembe orog taoba, 'Mog so'o eneag wamukap,' aro yaap. Ane sembe, Nai, 'Mog so'o Gosyen wamukap,' aro mololangkeap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Wene seekpa, nimi nubunge Firaundi Yusubag yubu lelamogti, “Wene aniap ankaboap ane wamang. ");
INSERT INTO kkl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mog so'o Mesir ane anenge mog so'o as sao tal. Sin mog so'o waliag Gosyen wamukang. Sin nusamag pham pia una etpare sol wali nimi wamikti, naringe pham babe wene sindi yae wamsukang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusupti ili babe enero nimi nubunge Firaun whingag pabiog. Pabiogpa, Yakubti nimi nubunge poneko kibogpa, ");
INSERT INTO kkl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","nimi nubunge ponekori Yusup ili Yakub hailamogti, “An mangkageeka heng kun etbare wamlam?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Wene aro haibaogpa, Yakubti, “Nani, na nimi ina tongonne tahiri, sekel ananne saog uro ikin uro wamsiri, heng kun tom ta'om agha epto no'op tarabare (130) wamna. Samen Nanisang yabo ina tongoro tero heng kun tenghan-tenghanne palamog saog uro kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Wene seogti, Yakubti nimi nubunge yubu sia leropne poneko kibogti, lambaog. ");
INSERT INTO kkl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Lambaogpa, Firaundina, “Yusup iliap elkaboap ane wamlulom,” aro Mesir so'oag so'o sukuptobag “Ngai talulom,” aro nimi nubunge yubu sia leropneri ambatsioghag as Ramses peramag wamek. ");
INSERT INTO kkl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ramses peramag wamekpa, Yusupti iliap, elkaboap, sikin maboap sembe kwaneng yeplamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kwaneng yo Mesirap Kanaanap wamogne neneko sop-sop kwaneng yo aghabog palamogpa, kwaneng orog taogpa, nimi mog so'o anekoag wamek nimi ni pesa talamek. ");
INSERT INTO kkl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Pesa talamekpa, Yusupti pongoroba kwaneng roti sumbaneba kamna kapto tolamek kal ma'al taneko nimi yubu sia leropneri aeag sop-sop poa pail palamogpa, nimi saeag kal ma'al orog taog. ");
INSERT INTO kkl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mesir wamek nimiri babe, Kanaan wamek nimiri babe, sindinge kal ma'al kwaneng kamna kapto tobiagha toro tena orog tahiogpa, Yusubag yingkina lelamekti, “Nununge kal ma'al orog tahio, nu kwaneng tatsululam. Nu tebabeagti lipsiseng kom,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Wene alamekpa, Yusupti lelamogti, “A'ununge kal ma'al orog tahio tanena, pham tarel anumunba, nari kwaneng tatsinun,” alamog. ");
INSERT INTO kkl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wene alamogpa, sindi pham tarel alamekpa, kwaneng lunuro tarelamsiog. Sindi, “Kwaneng tatsilul,” aro kapto payalamek phamna kuda, domba, kambing, sapi, apna keledaiap. Heng kun enena phamag agha kwaneng kamna kapto tarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nen nhon heng kunag yingkina lelameknena, “Nu lag phoro lelamap, kal ma'al nuringe orog tahio, pham nuringe andi toro aom. Nu wene an tatkenepne sa'a-sa'a saeag wamla kom. Wenena nu nongap, nununge awe so'oap aghabog. ");
INSERT INTO kkl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nu tebabeagti, lipsiseng kom! Nu nimi nong babe, nununge awe so'o babe kwaneng agha kamna tatsululam. Nu nimi nongap, nununge awe so'oap, nimi nubunge yubu sia leropneringe talul. Ot nununge awe so'o si mag komdi, iklerebaleag, yina aweag memneba tatsimenba, melamukap,” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Wene alamekpa, Mesir nimiringe awe so'o wamogne Yusupti yubu sia leropne Firaun sembe tobog. Kwaneng yo aneko maiknonge waelbaogpa, Mesir wamek nimiringe sindinge awe so'o yubu sia leropneri kwanengag kamna ni tobog. ");
INSERT INTO kkl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mesir mog so'o ni wamek nimi Yusupti arukna nembahiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mesir mem nangdinge ogna Yusupti kamna tomna kom. Sin nang enena yubu sia leropneri nangena kamna tatto eldi saelbamsiog. ");
INSERT INTO kkl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","24","Yusupti Mesir nimiri so'o Firaun sembe kamna tobogti, yubu lelamogti, “Sumene nari a'un nongap, a'undi awe so'oap kamna topsinba, Firaun yubu sia leropneringe talom. Anena yina aweag memneba mepmunba, whi tale tanena, topmundi, palu lambare pogto nembatmundi, a'un kelabo meap tena sembe, yina sembe babe palu tombare tol tolapmundi, Firaun sembe pogtopne nhon tarelamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wene seogpa, Mesir nimi tanekori lelamekti, “Andi nu tebahabe nimi aghana, toro pipsilamba, nurina 'Nani,' alamap. Nu wana waliag agha yubu sia leropne arukna wamukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Wene seekpa, Yusupti “Mem nangdi so'o Firaun saeag talul kom, aghana yog nimiri wero mero telamnepne, pogtopne lambare agha nhon yubu sia leropne sembe tarel alamlulom,” seogti, karepto pibogne neneko sunsunum uro yubu sia karepto pibogne, wene babe anam wamlaba, Mesir nimiri unulamang. ");
INSERT INTO kkl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel nimi taneko Mesir so'oag wamekti, Gosyen aneko ngai taekti, wamekti, tup talamekpa, nimi likna maikno mangaro palamog. ");
INSERT INTO kkl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub Mesir aneko yingkina wamekpa, heng kun ko'olom tarabare piog. Yakub heng kun samenag wamogneap, ma'aro tanena, heng kun teng lambare eptopne aobare (147) wamog. ");
INSERT INTO kkl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yakub el, “Wene loba tanep peram wamna,” sembaogti, elme Yusup yobogti, ambarelamogti, “Name, andi na o'ona sembamnelam tanena, na yan kwagha mombolag sae tobongkiapmendi, sik uro salag leplulamnena, andi, 'Mesir so'oag ane sikkenun kom,' aro yubu salag leplulam. ");
INSERT INTO kkl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nanisag yaboag yame naringe pineleba, na wanaag 'So'o siknoho,' sembamnangena, nanisang yabo so'o siksiroba peramag 'So'o siknoho,' sembamna,” seog. Wene seogpa, Yusupti lelamogti, “Nani, wene selam tanena, anba andi, 'Leplamneag,' uanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Wene seogpa, Yakubti lelamogti, “Name, 'Sik uro uanun,' aro nanag leplulam,” seogpa, Yusupti “Sik uro uanun,” aro ili ambarogpa, Yakub ae usah usoghag sip yan sanukto pulpina Allah omekaog. ");
INSERT INTO kkl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Olog wameka nimiri Yusubag, “Ani nikna niklamla,” aro ambarekpa, elmabo phende Manaseap Efraimap Yakub niklamoghag piek. ");
INSERT INTO kkl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“Yusup yal,” seeka Yakub, el si nhon Israel ka'ebaogti, mamogha puknep kom agha mikip pukom agha pukogti, ");
INSERT INTO kkl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yusubag ambarelamogti, “Allah Imap So'oap Saelbamlange neneko na Kanaan so'oag as Lus wamsiba, whingag lag taogti, 'Mikip nembahinun,' aro ambarelamneogti, ");
INSERT INTO kkl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","'Nari an yepkeneri, anisag yabo maikno nembahineba, as nubu tangto wamukang. Nari mog so'o ene andi mangarobag tatsineba, sin ya'ag ngai wamukang,' seogne ka'ebahi,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Seogti, nen nhon babe lelamogti, “Name, anmabo Efraimap Manaseap na anam yan komag mog so'o Mesir anea mangap tarong. 'Mabo abene nari mabo tarong,' sembamna. 'Rubenap Simeonap nari mabo wamdang saog uro nanisag Manaseap Efraimap babe wamtukang,' senelamna. ");
INSERT INTO kkl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nen amik wapmendi, me amikne mangaro amenne tanena anenge, aghana me amikne taneag, 'Nari mabo,' sembanun kom. Amik lag taik mabo andinge tanena, Efraimap Manaseap sembe 'Nuni yabo,' alamikti, sin phende agha sisa wamikti, sindi saeag agha mog so'o tobukang. ");
INSERT INTO kkl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nari uanne nene, anin Rahel sembe. Inaag samoro Aram mog so'oa yalamsiag agha aninka Kanaan so'oag Efrata peramag agha loba taog. Loba taogpa, ina Efrata tara sip so'o siklopsi,” aro ambarog. Wenena Efrata ambarogha ane sembe, Betlehem alamangne nene agha el ua ulamsil. ");
INSERT INTO kkl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Wene aro ambarogti, Yusup iliri elmabo abeneko kemelamsiogti, “Me abene etne-etne?” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“Etne-etne,” seogpa, Yusupti, “Abene nari mabo. Me abene Mesir anea Allahri tatneonge,” seog. Wene seogpa, Israeldi, “Meabene na peramag yarukang. Nari sinag 'Nuni Allahri wali-walia tarelamsilul,' aro yubu kipto pipsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","“Sinag yubu kipto pipsinun,” seogpa, Israel sabal taogti, haing toa saogne lililamogpa, Yusupti elmabo sae salero ili Israel peramag nembahiogpa, somoro kipsiogti, togtog aro kipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Undo unu ahiogti, Israeldi Yusubag yubu lelamogti, “Name, na anap 'Haiptangto whing uram yo'o olog ipkinun kom,' senelamna agha, wene Allahri sembalne agha andi mabo babe ipsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Wene seogpa, Yusupti eldi mabo sikini ili Israeldi ilag agha topsiogti, Yusup ili whingag yabu sanukto pulingkina kibog. ");
INSERT INTO kkl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","14","Kibogti, me abeneko tobom agha, Yusupti sirik sae sip elnabime Efraim salelamogti, waneng sae sip elyandome Manase salelamogti, ili whingag nembahiog. Yusupti me nabinge Efraim ilisagti waneng sae sip nembaogti, eldo Manase ilisagti sirik sae sip nembaog. Aghana sikin isag Israeldi sae wanwan obi agha Efraim nabinge aghana sirik sae Efraimdi usoghag pibogti, waneng sae Manase yandongeri usoghag pibog. ");
INSERT INTO kkl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Sin usoghag sae pipsiogti, Yusup pat palilamogti, “Nani Allah nanisangdi Abrahamap Ishakap omeklamdekne, me abene yepsilulam. Nani Allah samen wamsiag agha wene wamnaag pia yeplamnelamne me abene yepsululam. ");
INSERT INTO kkl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Allah arukna malaikat na eraruk uro uropbaag yemneropne ponekori, me abene yepsilulam. Na siap nanisang si, Abrahamap Ishakap me abene pere wamlebog likna palamlul. Sindi me mangaroba likna me sindinge pileba, mog so'oag maikno talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusupti kemelamogpa, ili Israeldi sae Efraimdi usoghag piamogpa, kembaogti, “Undo mali,” aro iliri sae Efraimdi usoghag tobogti, “Manaseri usoghag pimnun,” aro ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusupti iliag yubu lelamogti, “Undo kom, nai. Me yandongena ane. Andi sirik saena me yandongeri usoghag piplulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aghana iliri, “Kom,” aro wene seogti, yubu lelamogti, “Na el wamna, na name, na el wamna. Manase el mikip wamlul. Eldi mangaroba babe as mog so'o nubu tangto wamlul, el nimi nubunge babe wamlul. Aghana ilipsae agha mikip sirik wamleba, eldi mangaroba mog so'o as babe nubungeog wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Israeldi elmabori maboag sumeneko sum kipna walinge pipsiogti, lelamogti, “Na Israel wamna. Nanisag yabori nimiag kipna walinge palilamsiikti, a'undi si lelamsukang. Sindi a'undi si lelamikti, lelamukangnena, 'A'un Allahri wali nembahilulnena, Efraimap Manaseap saog uro,'” aro kipna walinge palilamsiogti, Efraim samenag nembaogti, eldo Manase amik nembaog. ");
INSERT INTO kkl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Undo unu aogti, Israeldi elme Yusubag yubu lelamogti, “Wene iplam, na si tarapnange peram tal, aghana Allahri a'un yeplamsileba, samoro a'ununge mog so'oag samoro pululom. ");
INSERT INTO kkl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Anap ankaboap a'unag tatsinunneag agha, nen nhon tatkenun. Samenag Amori nimi mal talamsiri, sikin mog so'o yim mog so'o nari saeag taonge aneko, an saeag tarelangken,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Wamekti Yakub, si nhon Israel nenekori elmabo ni yopsiogti, yubu ambarelamsiogti, “Namabo, amik a'unag talamlulne sembe ambatsinundi, winilahut! ");
INSERT INTO kkl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Na Yakub na a'uni Israel yubu ka'eamlulom! ");
INSERT INTO kkl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben name, an me yandonge, na ani kabuni wamsiri, pipkehinge eneng samenagne an wamlam. An nong mikip wamlamdi, nimi maiknori maiplangkeong. ");
INSERT INTO kkl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mag nubunge mikipti ni pabinep saog uro wamlaba, andi babe naringe mali nembaom. An nari kel nembanongeap mabomdi, nari ae usah son nembaom. An samen paliag pat pipkehene, aghana wene, 'Ankaboap nika-nika uro wamlulom,' alamna. ");
INSERT INTO kkl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","A'un eldo ilipsae Simeonap Lewiap, a'undinge yin yonge abaltolneog piro amtom. ");
INSERT INTO kkl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Na sin yubu saekag palilamikag palamnun kom, sin winil talamikag palamnun kom. Sin yo ulamsila sembe nimi olamsirangdi, pham sapi yan poltheng karep lolamsirang. ");
INSERT INTO kkl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Sindi yoa ulamdangne nene sembe karong senelamna. Yoa ulamdangne sikin yo sirik wamdang. Yoaba ulamdangne nene kaupsile, yareag senelamsirang komba, nari na namaboag agha sin a'ebahineri, sindi wamtukangne nimi sekelanan nang saog uro Israel nimi anabiag wamtukang. ");
INSERT INTO kkl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, an ankabori kibiang towalenglangkiikti, yabu sanukto pulangkukang. Anna isa nang urongag lopnagha salelamsululam. ");
INSERT INTO kkl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda kam singa me saog uro wamlulam. Tenaba opleri, teleri, mon taleba, nen kwanerobag yingkina ibog sengkelaglamleri, kwanelamlul. Unulamleba, palisong nimi nhondi babe logti, kaombalul kom. ");
INSERT INTO kkl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yehuda andi nimi nubu nangdi salerop kame tunguna saelbapmenba, andi mangaroba amik yalamlengeriba, ya'ag saelbamukang. Andi mangaroba pere agha nimi nubunge nhon yaleba, nimi mog so'o ni wamik nimi ni el umag wamikti, eldi yubu ka'elamukang. ");
INSERT INTO kkl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Eldi anggur alonga uro mepleba, mauro yina tinilamleba Pham keledai me eldinge anggur yo'o walingeag kerekamlul. Ag enektopne anggur maghag a'alelamlul. Anggur lolteroba maghag agha eldi ag enektopne uwong talul ana eneng saog uro. ");
INSERT INTO kkl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Haing eneng seret alamlulne sembena, anggur lolteroba mag telamle saog uro. Elag kembiag agha eldi sina kororop wamlul ana, maum kororop saog uro wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulonna, mag longorop mag peramag wamleba, kabong ae soropne mag alip toman pol keaglamik nimiri, “Zebulondi mog so'oag pat pipsilul,” aro maikno yalamukang. Eldi mog so'o wilnirobagna Sidon simbik wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakhar sunumna, pham keledai yo'o mikipne saog wamleba, ikinaba porobari lingniamukang. ");
INSERT INTO kkl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Eldi kemelamleba, 'So'o aneko wali wamlul. Mog so'o aneko sai wamleba, so'o aneko na tanun' aro, nimiri aruklamikpa, ikinaba maghan og uro polamlul. ");
INSERT INTO kkl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, andi mabo Israelnang anabiag wamikti, sisa nhon mo wamikpa andi tam ikinne sinag wamleba, wali uro kareplamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Name Dan phae inaag ma uropba palisong urop saog uro wamle. Phaeri pham kuda yanag saplamnaba, nimi kuda alibag walelem agha palamnange eba tinirop saog uro. Phae ane olog aghana yo wamla saog uro wamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Nani Allah, 'Andi taulbanululam' aro nang-nangaro wamna. ");
INSERT INTO kkl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, nimiri 'Anenge aba topkukap,' aro ulamikag agha, andi babe 'Tangoro sarekerepto yan pubuag saelbahinun,' aro ulamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, andinge tenaba maikno wamleba, andi nimi nubunang sembe meneklamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, an pai pham rusa kel pham agha kobea loptangka pirop saog uro wapmendi, me walingeog mangalamsululam. ");
INSERT INTO kkl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusup an wamlamne pai pham keledai me mikipne mag luag wamlange saog uro wamlamdi, yimag merero walerop pham keledai saog wamlam. ");
INSERT INTO kkl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nimiri isa nembangkeangdi, 'Yin maldi opkukap,' aro yinap malapti sarekereplangkeang. ");
INSERT INTO kkl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aghana an Yusup wamlamne, Allah pham yae ua uropne saog uro wamla. Ani Israeldi Kirik Sildiri lilbangkelul. Allah Mikipne Yakubti omeklamlangeri yeplangkeleba Yin mal andinge weapmendi, andinge sae lin kong mikip wamlulam. ");
INSERT INTO kkl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ani Israeldi Nai Allahri yeplangkelul. Allah Im So'o Saelbamlangeri mikip nenelangkelul. Mag imag agha kulukul alamleri, mag so'o lomag agha walel alamleri, mikip nembahileba me mangaro maum tinilamsukang. ");
INSERT INTO kkl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Main samenag sekogne ane we wamla. yimag agha wali-walia maikno tomnepne wamla aghana, aniringe saeag agha nia mangkia Yusup saeag wali uro phelekto palilamnaba, elkabo nusamag agha sikini saog uro wamlul. ");
INSERT INTO kkl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin an kam yonge serigala saog uro wapmendi, yo'obi inipna tenaba ol palapmendi, an telapmendi, ankabo poglamsululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ni ambatsiogne ni ane sin aobare nangdi mangaroba likto pileba, sinag uro yabinepne ambarelamsiogti, kipsiog. ");
INSERT INTO kkl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Yakubti ni yubu kopkop tagto elmaboag ambarelamsiogti, “Usa nuni yabo piek saog uro na babe punun. Sin piekpa, pil phiekag kirik arame Makhpela heng walelingkirobag sip Mamre Kanaan so'oag sikil punululom. So'o anena Abrahamdi kirik arameap so'o kanero wamla aneap Hetne Efron saeag agha tobog. ");
INSERT INTO kkl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Anea Abraham eldamne babe, elkel Sara babe, elme Ishak babe, Ishakti kel Ribka babe, so'o siksiek. Anea babe a'unin Lea so'o siksi. ");
INSERT INTO kkl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","So'o wamla aneap, kirik arame wamla aneap, Het elmabori saeag agha kamna toro tobog. Kamna toboghag ane pil punululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wene aro yubu kopkop tagto ambatsiogti, ae koloag yan togto winiptangom agha hain orog taogpa, ilisag yaboag yame samen piogpa, loba taog. ");
INSERT INTO kkl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tebaogpa, Yusup neneko ili whingag somoro saelbamogti, tog-tog aro kipto engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Engkaogti, “Nani olog piamnea,” aro nimi teptopne mektop nimiag “Meklulom,” aro el nimiag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nimi mekna meklameka anena ik teng nhonap epto naulbare sum agha mekek. Mesir nimi Yusup ili tebaogha sembe engel wa'alamek ana wal phende eptopne sa'obare sum agha engero libek. ");
INSERT INTO kkl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nimi amang piro uaekti, Yusupti yubu sia leropne eldi yan sae wamekne ambarelamsiogti, “Nangkabo, a'undi na sembe wali senelamnemundi, nari yubu lemununne nene nuni yubu sia leropneag ambatlulom. ");
INSERT INTO kkl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Nari nai loba tanep peramag yubu lelamori, 'Nanag yubu sikne agha salag leplulam,' seo. 'Na siknebagna, so'o Kanaan walilopsiag siknululam,' seo. Wene seoba, 'Anba andi, 'Leplamneag,' Kanaan sikil pikenun,' seno. Ane sembe, ambatmunba, na kho olog tatnelul. Sikne tanena nen samol anun,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Wene seogpa, yubu sia leropne Firaundi lelamogti, “Wene selam tanena, anba andi salag lebom saog uro so'o sikil pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusup ili “So'o sikil punun,” aro palamogpa, yubu sia leropneri aeag awe torop nangap, yubu sia leropneri yan sae yubu eptop nangap, Mesir so'oag nimi nubunang wamek nangap, Yusubap nhon piek. ");
INSERT INTO kkl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Pieknena Yusupti ae lom nimiap, ili Yakubti ae lom nimiap, elkaboap piek. Piekpa, Gosyen so'oag wameknena me ologneapna phamap agha wamek. ");
INSERT INTO kkl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pham kudari alibagneap, kiliro poa ahiroba alibagneapti sin nimi tiriklameka mog so'o sanuklamog. ");
INSERT INTO kkl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Palameka Haatad nimiri roti wana weptobag Mag Yordan kauro tara sip piekti, engelamek. Aneko maiknoro engero wamekpa, Yusup ili mali taogne sembe ik saekpare amang ulamog. ");
INSERT INTO kkl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanaan so'oag aneko wamek nimiri Haatad nimiri roti wana weptobag Yakub amang piro ulamekne ipsiekti, lelamekti, “Nimi engenari agha mane agha engelamang,” aro wene alameka sembe Haatad aneko Abel-Misraim engkaek. ");
INSERT INTO kkl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Sikini Yakubti ambatsiogha sunsunum uro uaekti, Yakub Kanaan poa piekti, Makhpela kirik arameag samenag Abrahamdi Efron Hetneri so'oag toboghag heng walelingkirobag sip Mamre peramag sikek. ");
INSERT INTO kkl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sikini so'o sikekti, Yusubap, elkaboap, nimi yogne “So'o sikukap,” aro piek nimiap, samoro Mesir yaek. ");
INSERT INTO kkl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yakub tebaogpa, Yusup eldo yabo tanekori yubu lelamekti, “Nuri Yusubag malia uabunge sembe tangoro obsilul te?” alamek. ");
INSERT INTO kkl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Wene seekti, nimi nhon ambarelamekti, “Yusubag pimendi, ambatlulamne ane, 'Nuni loba taneba peramag ambarelamsiori, “A'unipsae Yusubag ambatlulomne, 'Ando yabori tam malia uakeekne wailag nembalulam,' aro molbanun,” aro ambatsiog. Ane sembe Allah nuniri omeklamogne arukna wamapti, nuri elag yoaba uabunge sembe wailag nembahilulba, mololamap,' aro wene seangdi, 'Ambarel pululam,' seang,” aro ambarek. Ambarekpa, Yusubag ambarel piogpa, ka'ebaogti abeneko Yusup engelamog. ");
INSERT INTO kkl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Wameka Yusup eldo yabo tanekori “Nunipsae wamlaag pukap,” aro piekti, Yusup whingag yabu sanukto pulpina, “Nu an arukna wamap,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Wene aro ambarekpa, Yusupti ambarelamsiogti, “Na Allah lunumna wamna komdi, na sembe log uro wamseng kom! ");
INSERT INTO kkl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","A'undi na 'Obukap,' sembalum aghana, Allahri, 'Sindi uaikne neneag agha eldi nimi maikno yepsilul,' sembaogti, sembaogha sunsunum uro wene babe uro yabio,” aro ambatsiog. Wene aro eldo yabo taneko wana aingnibahiogti, nen ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","“Ane sembe log uro wamseng kom. A'un a'unmaboap nari piamsinun,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusup elkaboap Mesir wamek paghabog Yusup mangkaeka heng kun taibuka taubuka ulamogha teng tombare eptopne phende (110) taog. ");
INSERT INTO kkl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusup neneko sabal wamogti, elme Efraim ilisag yabo mangkaeka wamogti, ipsiog. Yusup elme Manaseri me nhon mangkaogti, me aneko si Makhir engkaog. Makhir elmabo anena Yusup elmabo eldamneringe saog taek. ");
INSERT INTO kkl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusup el wene “Tebanep peram wamna,” sembaogti, elkabo ambarelamsiogti, “Na tebaneba, a'un Allahri piamsile pahabog as eneag agha poa lambahileri, 'Abraham, Ishak, Yakubag tatsinun,' aro salag pibog so'o enekoag poa pil philul,” seog. ");
INSERT INTO kkl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Seogti, “Enero poa pil phile sum na yo'o toa punululomba, yubu otsik uro leplulom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ambatsiogti, Yusup mangkaeka heng kun taibuka taubuka ulamogha teng tombare eptopne phende (110) wamogpa, tebaog. Yusup tebaogpa, “So'o sikukap kom,” aro nimi teptopba liktopba nimi teptoba polorop koma likekti, kabong soro lomag tobongol obek. Abenda. ");
INSERT INTO kkl_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Betlehem asag samenag nimi nubunang tam lelekto kareptopnangdi Israelnang saelbamsiekti, wamek li enekoag Kanaan so'oag kwaneng yo waelbaog. Kwaneng yo waelbaogpa kwaneng yo sembe nimi nhon elkabo eldi so'o laplobiagha eldi kelap eldi mabo phende abenekoap sindi as Betlehem laplobiagha Yehuda so'oag agha lambaek. Lambaekti, Moab so'oag piekti, nimi sekelengkirop nimi wamek. Nimi piek nimi sina Elimelek, eldi kel Naomi, eldi mabo phende abeneko sina Mahlonap Kilionap, sin nimi abene piek. Nimi abeneko nimi sisa Efrata nimi Betlehem ngai nimi wamek aghana kwaneng yo sembe mog so'o Moab piekti, wamek. ");
INSERT INTO kkl_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","5","Wamekpa, Elimelek poneko tebaog. Elkel Naomi kel enekoap elmabo phende abenekoap wamek. Wamekti elmabo phende abenekori Moab kelabo topsirek. Rutap Orpaap topsirekti, wamekpa hengkun sa'obare taog. Hengkun sa'obare taogpa, sikini samenag tebaog saog uro elmabo phende abeneko Mahlonap Kilionap babe tebarekpa, sikinin Naomi yauog kel eneko mo wamog. ");
INSERT INTO kkl_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Mog so'o Moab wamekti Naomi kelenekori ka'elamogpa, “NUNI Allahri nu Israel nimi o'ona senelamsildi kwaneng tatsio,” alameka Naomi kelenekori ka'ebaog. Ka'ebaogti, Naomi keleneko elyamal kelaboap togto aekti, mog so'o Moab wameka laplobiagha mog so'o Yehuda Israel so'oag wamogne samoro palamek. ");
INSERT INTO kkl_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Naomi ela'angeri so'oag Yehuda sip pukap aro inaag palamek. ");
INSERT INTO kkl_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Inaag palamekti Naomiri elyamal kelabo phende abenekoag, “Na yamal kelabo a'un embahirong mabo abeneko wamserengba, wali nhon Israel so'oag samoro phebe aghana nanap a'unap nhon Israel so'oag wamebenge olog eraruk ane sembe, a'un samoro a'unindi aeag a'ero-a'ero pururom. A'un embahirongba a'undi sinap nanap o'ona sembamsirum saog uro NUNI Allahri a'un sembe babe o'ona sembahilul aro a'un sembe molbarelamsin. Sindi a'un embahairong aghana sin phende abeneko teng serongba nanap nhon palameberi, wamebenge olog sunsunum kom. ");
INSERT INTO kkl_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","NUNI Allahri a'un o'ona sembamsileba, nengabo toro arumundi, a'ununge aeag yeng uro wamturom,” aro sin phende abenekoag yubu lelamogti, somoro kiplamsiog. Somoro kiplamsiogpa, sin phende abeneko yubu maiknoro wana ngik-ngok aro engelamdek. ");
INSERT INTO kkl_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Sin phende abenekori sin yamal kelag yubu lelamdekti, “Nun samoro pununam kom. Anap nhon angkabo wamangag pukap,” aro ambattekpa, ");
INSERT INTO kkl_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomi kel enekori, “Namangkelabo, nanap nhon pukap kom. Sa'a sembe nanap nhon pukap? Nari a'un topsinepne me nhon mangkanep saog kom wamna ane sembe, a'unungeag samoro pururom,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","“Na nong sabal wamnarina, a'undi mog so'oag samoro pururom. Na sabal wamnarina, nari me nhon nen mangkanep kom wamna. Na nong saren wamsene tanena sumene babe nengabo nhon topsenenge ponekori me nengabo me mangkahenenge abeneko huro elelem agha nubu taherengdi, a'un topsisereng? A'undi sin nubu taherengne sembe nang-nang arurom, te? Elem me abeneko noban koma ulamserengne, wali kom, ane sembe nanap nayamal kelabo a'un phendeap pukap kom. NUNI Allahri nu niag tam ikinne paibo aghana nanag tam ikin sirikne paibo. Ane sembe nanap piberi nen mali uro wamebeagti a'unungeag pururom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Wene aro ambatsiogpa Rutap Orpaap maiknoro engelamdekti, Orpa kel enekori, “Nanengeag saombanun,” aro el yamalkel somoro kibogti elengeag samoro piog. Elengeag samoro piogpa, Rut kel enekori “Nayamal kelap nhon pununam,” aro Naomi tamag ta'ap seogti, elag noropto saelbamog. ");
INSERT INTO kkl_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Rut Naomi tamag ta'ap seogpa Naomi kel enekori Rutag yubu lelamogti, “Namangkel, ankae kel kembamen! Ankae kel elenge asag elenge mema pharobag palamla pagha an ta'ap selamba, namangkel an babe el amik pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Wene seog aghana Rut kel enekori, “Andina na laplobiagha pululam selam aghana nen andi nanag pululam seheng kom. Nari asag punun kom. An tala palapmenag na babe palamnun. An malapmenag na babe malamnun. Andi angkabo nari nangkabo taukang. Andi omeklamlam Allah nari Allah taleba, nari babe omeklamnun. ");
INSERT INTO kkl_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Nu phende nikag wamnemeri, teplamneme sum agha a'eptanunam. An tebalulamag na babe tebanun. An sekkukang so'oag na babe siknukang. Orolena lelamna tanena NUNI Allahri tam ikinne nanag piplul,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Rut yubu mikip uro “Nhonag pununam,” alamogpa, Naomiri “El saombalul kom,” aro el taogti, sa'a sunun komdi aro yubu kom taog. ");
INSERT INTO kkl_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Sin phende palamdekti, Betlehem palamdekpa, Betlehem wamek nimiri Naomi keleneko yalamla aro kololamek. Kololamekpa kelabo wamekneri, “Sik Naomi kelenekore?” alamek. ");
INSERT INTO kkl_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","21","Wene alamekpa Naomi kelenekori, “Na Naomi seneheng kom. Si Naomi aro engehirop si enena wali kelabo aro engehirop. Na si Sek kel sunululom. Na si Sek kel sunululom nena Allah Mikip phelektopne ponekori na sae limneogpa mali uro ulamneldo agha yalamna. Tanea na palamsiri, saeag olog wamogpa wamneba sunsunum wamsiri pihi. NUNI Allahri nanag tam ikinne paibogpa, seklenneog seklero ulamneldoa, sa'a-sa'a koma yalamna. Allah Mikip phelektopne ponekori nanag malingeog palilamneloba, seklena seknelamneldo ane sembe a'undi na Naomi seneheng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Undo uro yabiogne neneko sembe Naomi Moab piog aneko samoro elyamalkel Rut Moab kelenekoap samoro Betlehem yarek. Yarekne kwaneng roti karepto wendog wenam yongoro pololameka liag yarek. ");
INSERT INTO kkl_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi ela'ange samenag tebaogne Elimelek elai sisa nik nimi nubunge nhon sina Boas tupne wamogpa, ");
INSERT INTO kkl_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Moab kel Rut kelenekori elyamalkel Naomiag ambarelamogti, “Na pineba, nimi nhondi o'ona sembanele tanena, nimi enekori yengag agha el aruknari kwaneng roti wana pololamika tinilamlenge polbanundi, punun,” seogba, Naomirina, “Namangkel, wali pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Wene seogpa, Rut kel eneko elyamal Elimelek sisa nik nimi Boastingeag aro tapto el wamog kom aghana, Boasdi aweag piogti, Boas ilipsabori roti wana kareplameka tagto tinilamogne pololamog. ");
INSERT INTO kkl_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Pololamogpa Boas poneko as Betlehem simbika aweag yaogti, Boasti arukna kwaneng roti wana kareplamekag yaogti, wana kareplameknang tanekoag, “NUNI Allahri a'un paiamsilul,” aro kiplamsiogpa, sindi tangoro, “Nuni, an babe NUNI Allahri yeplangkilul,” aro kibek. ");
INSERT INTO kkl_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kibekpa, Boasti arukna sikindo samenagneag, “Kelene etneri kel?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Haibaogpa, arukna sikindo anekorina, “Kel enena mog so'o Moab kel, el yamal Naomi kelenekoap tane yarong kel. ");
INSERT INTO kkl_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Rut kel enekori ambatsilne, 'Anmabo amik palamneri, kwaneng roti wana tagto tinilamlenge na poloro anun,' seldi, molbahilba ae lukun alnibaldi, tektek epna koma pololamla paghabog wene wamla. Olog tektek papnun aro kalun aeag ane pukamla,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Ambarogpa Boas ponekorina Rut kel enekoag yubu lelamogti, “Namangkel, nari anag lemnunne ane ka'eamlulam. Nari awe tane laplobi agha kwaneng roti yoghag polol peheng kom. Tane pololapmendi, na arukna kelabo kwaneng roti wana togtog palamikag ipsimendi, sin amik pululam. Sin nong laplobi agha pin koma sin peramag aghabog wamlulam. Mag yo ulangkele tanena mag ma'ina arukna nengabo me niri mag tero paliroba tel pululam. Nari naipsaboag, 'Kel enena saelbaheng kom,' aro wembahindina, log kom uro pululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Wene aro ambarogba, Rut kel enekori amupto so'oag malingkina Boas kiplamogti, “Na nimi aeag kel agha huroba sembe o'ona sembanelamdi, na yeplamnelam?” seog. ");
INSERT INTO kkl_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Wene seogpa, Boasti tangaro ambarelamogti, “Nimiri an sembe ambarelamsiangdi, 'Kel ane ela'ange tebaoba, elyamalkelag walia aghabog ulamo. Elyamalkelag walia ulamori, ilin ili laplobi agha el mangkaekag babe laplobiagha nimiri asag samen babe ipsiog kom nimi wamekag yao,' aro ambarelamneongba, ka'ebano. ");
INSERT INTO kkl_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Andi lebomne, 'Israel nangdi omeklamang Allah enekoag pineba, pelebaneleba, wana aingniro wamnun,' seomdi, an tane yaom. Ane sembe nari NUNI Allahag molbaralangkenne, nu Israel nimiri NUNI Allah omeklamapne ponekori kamna walinge tatkekeleba, walinge aghabog saelbapmendi, wamlulam aro an sembe molbarelangken,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ambarogpa Rut kel enekorina, “Nani, na kelabo an arukna wamangne tane saog uro wamna kom aghana, andi na o'ona sembanelamdi, na wana ikin uro wamnaba, walia nanag lelamlamdi, wana keagman nembamnelam. Nani,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kwaneng telamek pere, Boas ponekori Rutag, “Kwaneng tukapti, yae kwaneng roti wana anggur wana lolderoba agha pelengkiogha tululam,” aro ambarogpa, Rut keleneko Boasti arukna awe tolamekag aneko wamek nimiag peramag pulaog. Yaogpa kwaneng roti telamek abeneko Boas ponekori kwaneng roti sunuroba wana wali uro aukag tabekne babe tarogpa, teogti, mon ogti, nen phelektopne pogto Rut kelenekori aghag liro pibog. ");
INSERT INTO kkl_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Pibogti Rut keleneko kwaneng roti wana tinilamlenge togto anun aro piogpa, Boas ponekori eldi aruknag ambarelamsiogti, “Keleneri kwaneng roti wana olog-ologne tinilamlenge togto anun aro pil. Olog-ologne togto anun aro pil aghana a'undi kaongoro kaupto palilamlomne anabiagne keleneri walinge nubu uro toltolamle tanena waro ali nembaheng kom. Waro ali nemban koma liloapmundi, Rut kelenkori wali maiknoro togtoalul aro kiliro lebelaglopmundi pelengelolapmunne togtoalul,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Kwaneng roti sumbaneba kolopto tinilamogne pololamog paghabog ae sin taog. Imbaogba Rut keleneko kwaneng roti wana pololamogne keloplamogpa kolopto yangkalamogne taneko poloro agha libaogne ikinne sepuluh kilogram taog. ");
INSERT INTO kkl_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ag nhon taogpa, Rut kel enekori aghag liro pobogti, asag pabiogti, elyamalkelag undo polbandi payana tane kembamen aro ambarog. Kembamen aro ambarogti, Rut kel enekori nen yogharogne taneko, el samen Boas nenekoap kwaneng telamdekne phelektoba aghag lilamogti, pogto payaogne yogharogti, elyamal kel Naomi tarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tarogpa elyamal kel Naomi kel enekori ibogti lelamogti, “Sumene tala pilamdi, polbalamdi, kwaneng tane payalamlam? Etneri aweag agha an sumene awe toplamdi payalam?” seogti Naomi kelenekori tipto lelamogti, “Anag walia ual nimi sembe, 'Allahri walia elag ulamlul,' aro molbarelamna,” seog. Naomiri wene seogpa Rut kel enekorina, “Awe sumene kwaneng roti wana tognag ane ngaingena Boas,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Wene aro ambarogpa Naomi kel enekorina Rut kelenekoag, “Namangkel, nimi enena nuri nimi sisa nikne peramag nimi o'ona paibatsinepne wamla. Eldi nun paiamsulul. NUNI Allah nimi teptopneap, kamagneap laplopsin koma walia ulamsilne ponekori Boas babe yepto walia ulamlul aro molbarelamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Wene seogpa, Boasti samenag Rut ambarog yubu Rut kel enekori nen tipto Naomi ambarelamogti, “Boasti nanag, 'Ana nari arukna kwaneng roti wana kareplamik nimi peramag wapmendi, ik etpare kwaneng roti wana kareplamikag tane tinilamlenge pololapmen paghabog nari aweag komopto polbalulom,' seldi, ambatnel,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Wene aro ambarogpa, Naomi kelenekori elyamalkel Rut kelenekoag, “Wali nayamalkel, an wali Boasti aweag el arukna kelabo taneko peramag wapmendi, polol palamlulam. Andi eldi awe laplobi agha lepmendi, ora nimiri aweag pimen tanena nimiri kirik pupling oro saelbaghanep,” aro wembaog. ");
INSERT INTO kkl_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wene aro wembaogti ambarogpa Rut kelenekori elyamalkel yubu ka'ebaog. Ka'ebaogpa, Boas ilipsabori samenag alnibaekti kareplamekne babe komoptobag kareplamekne babe Rut kelenekori neleplamsiog. Neleplamsiogti, Boas arukna kelabo peramag wamogti, kwaneng roti wana so'oag tinilamogne elap elyamal kelenekoap sembe ik wal phende saog pololtolamog paghabog komopto tobek. Undo pololamog ko'o ene Rut keleneko elyamalkel Naomiap nhon wamdek. ");
INSERT INTO kkl_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Wamdekti, ik nhon sum Naomi kel enekori el yamalkel Rutag yubu lelamogti, “Namangkel, an huro wamlulam? An amik wali uro wamnepne sembe nengabo an toltonne nhon ebatkinun sembamna. ");
INSERT INTO kkl_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kelabo anap nikag a'un aweag pololamlomne Boasti aweag pololamlom. Boas ponena samenag toamneogne eldi sisa nik nimi nu o'ona sembahainepne wamla. Ane sembe ka'eamnululam! Sumene ae inipnag Boas poneko kwaneng roti wana poloro yo'oag agha kolopto yangkalul aro keloplamangag aweag pileri, roti wana nong wepto tolamlul. ");
INSERT INTO kkl_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ane sembe, an kon maghag a'eleptamendi, song walia an nongag pelagtamendi, ag walinge enekamendi, kwaneng roti wana yo'oag agha koloptalul aro kelopto tolamikag pululam. Pina wapmendi Boas sembe nang-nangkapmenba kwanengap maghap tulul, aghana an pina wapmenne lag neneptaheng kom. ");
INSERT INTO kkl_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","An ipken kombog Boas mal pulul. Mal pileag wali uro kembamendi, Boas malamleag peramag pimendi, son sembe kaluptangka malamlea yanag sip tengkongkia, yanag sip mal pululam. Mal pimenba, ipkeleri, nu o'ona sembahileri, maupkelul aro ulapmenne sembe Boas el uro wamlul. El uro wamleri, nu Ibrani nimiri uropne sunsunum uro andi amik uamenne sembe babe Boasti an ambatkelul,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Wene aro ambarogpa, Rut kel enekori, “Na yamalkel, wali ambatnelam. Ambatnelamne sunsunum uro nari uanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Wene seogti, Rut kel eneko kwaneng roti wana yo'oag agha wana koloplamekag aneko piogti, el yamal keldi lebogne sunsunum uro uaog. ");
INSERT INTO kkl_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas poneko kwanengap maghap teogti, wanaag yeng uro mamnun aro kwaneng roti wana erabalingkirobag peramag mal piogpa, Rut kel eneko nemen-nemen keleleng agha yaogti, Boas poneko son sembe kaluptangka maroba aneko ebiagha Boas yan peramag mal piog. ");
INSERT INTO kkl_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Mal piogpa, Boas poneko malamogha ae tomnusam taogpa lo'om seogti, pulingkiogti, peramag sale whilamogpa, yanag sip kel nhon malamogha el taog. ");
INSERT INTO kkl_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","El taogti, hailamogti, “Anna etne?” seogpa, kel enekorina, “Nani, nana Rut, an arukna na malamna,” seog. Seogti, “Boasti na topnelul, to, kom, to?” aro, Ibrani nimiri ul palamekne sunsunum uro Rut kelenekori nen tipto ambarelamogti, “Anna nayamal tebaogne el sisa nik nimi nu o'ona paibatsinepne wamlam. Ane sembe andi na pelepto kaluptangka agha niknibatnululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Wene aro ambarogpa Boas ponekori, “Namangkel, NUNI Allahri anag walia aghabog ualul aro molbarelangken! An yamalkel Naomiag walia ulamomnena olog tamag wamlaba, sumene an yamal sisa nik nimi wamnange sembe o'ona sembanelamdi, nanag ualamnena ya'ag paliagne. Na olog sabal wamna ane sembe andi kaubuni toro anun aro ebahinep. An nimi anabiag kaubuni wamangne anabiag, saeag tupnang babe, saeag agha orog nang babe nimi anabiag kaubuni toro anun aro ebahinep aghana, yog kaubuni anabiag agha el palamlam kom. ");
INSERT INTO kkl_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ane sembe namangkel, log sembaheng kom! Nimi as eneag wamangnena an sembe “Wali sirik kel wamlari walinge aghabog seneraglamlari ulamla,” alamang. Andi ni molona molbanelamne sunsunum uro nari babe anag uanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Wene seogti, “Sikne agha leplam. Nana an yamalkel nimi sisa nikne peramag wamna ane sembe, nari an wamnepne sembe nari tagha uanun. Aghana, nimi nhon an yamalkel nimi sisa nikne peram sirikne wamla. El wamlange nenekori paiamsulul, to, tibogamukap. ");
INSERT INTO kkl_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","An sumene inipnag tane mapmenba, ambhum lukuna nimi anekoag pineba, 'Kel eneko na topnun,' sulul, to? Topnun sele tanena wali topkelul. Karong sele tanena nari topkenun. NUNI Allah kamag wamlange poneko whaingag agha sik uro lelamna,” seog. Wene seogti, “Namangkel, lukun pululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ambarogpa, Rut kel eneko Boas yan simbik malamogpa, kwelekanep peramag Boas ponekori, “Kelabo kwaneng roti wana yo'oag agha kolopto palirobag malal aro nimi yog nimi el taikag,” aro pulul sembaogne sunsunum uro lukun ae kwelekan komag nimiri imna komag sekom agha Rut keleneko piog. ");
INSERT INTO kkl_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Punun aro ulamogpa, Boas ponekorina Rutag, “Ag ngang kwhena kwheamlama ane lopmendi ane sangaro yangkalulam!” Boasti wene seogpa, Rut kelenekori lopto sangaro yangkaogpa, kwaneng roti sumbaneba olog wali saogne to'opto 20 kilogram libarogti, Rutti usoghag pobirogti, Boas poneko as Betlehem asag piog. ");
INSERT INTO kkl_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Boas pal toghog abeneko Rut kel eneko babe elyamalkel Naomiag yaogpa, Naomi kel enekori, “Namangkel, welaro uro yabil?” aro haibaogpa, Rut kel enekori Boasti Rutag lebogneap uaogneap ni ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nen babe ambarelamogti, “Boasti 'Anyamalkelag an nongog pululam kom,' seldi kwaneng roti sumbaneba ag teknero 20 kilogram libatnelba, payan,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wene aro ambarogpa, Naomi kel enekori Rutag, “Namangkel, el Boas ponekori tam ane wali uro wepto paibukap aro elamlaba, ae sumene agha karepto paibukap aro tektek papna koma elamlaba, ae sumene agha karepto paibaukang. Ane sembe an tane pukapmendi, wapmenba, lebukangne el talulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boas poneko leka as kota Betlehem kanero sobaeka ina siramag piogti pukamog. Pukamogti tilamogpa kabuni nhon yalamogha tibogaogti Boasti senenne “Elimelekh nimi sisa nik nimi peramag sirikne aneko yalamlare?” sembaogti tibogamogpa peramag yalamog. Peramag yalamogpa yobogti, “Naba nangkae, yamendi peramag abene pulae,” seogpa yaogti nimi eneko Boas peramag pulaog. ");
INSERT INTO kkl_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Pulaogpa, Boastina Betlehem nimi sikindo yabo saelba uahiropnang sa'obare yopsiogpa, sikin babe yubu lebukap aro el yaghag pulaek. ");
INSERT INTO kkl_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Nikag pukekti, Boasti yubu elkae samen yaogne ponekoag yubu lelamogti, “Naomi kel eneko as Moab piog aneko samoro yaori, so'o ela'ange Elimelekhti nun nunkaeri laplobog so'o eneko Naomiri, 'Nimi yog nimiri saeag nembaneba, sindi na kamna tatnukang,' senelamla. ");
INSERT INTO kkl_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ane sembe nari seneraglamnange tam nene sembe an eltahom sembamna. 'So'o aneko nari tomnun,' sembamen tanena kembamsiang nimi whingag nimi nubunang pukamangag tanea lag phoro leplulam. Karong sembamenne babe lag phoro leplulam. So'o aneko ngai tanepnang ot nun phendeog wamnam agha, nari an phibom agha so'o aneko na tanep kom. Andi lepmenne na ka'ebanun,” seogpa, nimi enekori, “So'o eneko na tanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Wene seogpa, Boasti tangoro ambarelamogti, “Wali leplam, aghana so'o aneko Naomi saeag agha toplulam tanena sumeneko Naomi el mamne tebaonge Mahlon el kel Moab kel Rut kel eneko babe mauplulam. Maupmen tanena Rut ela'ange tebaog aneko lunumna elmabo mangkatsilenge tanekori so'o aneko saelbamukang. Andi so'oap kel enekoap toplulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ambarogpa, nimi anekorina, “Undop agha tanena nari so'o eneko nari tomnenge olog ikin. So'o eneko tomneri, amik sum tebane tanena so'o eneko kelenekoap elmabo mangkahilengeap sikindinge taleba, na mabo taptopne wene wamangneri saeag talul kom. Ane sembe na Naomi ela'ange nimi sisa nikne peramag sirikne wamnari, so'o aneko tomnep aghana so'o aneko sae lililamna. So'o enekoap kel enekoap na kom. Andina 'Eldi toro alul to?' sembalam aghana an toro alulam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Samenag Israel nimiri sindinge kamna toro tolamekti, “Yubu sam karepto paibapti, salagna ane palilamna,” aro ngainang tanekori yan wangana sandal enekamogne tara sip kwiripto, “Na ngai tanun,” senerop nimi enekoag tarelamek. ");
INSERT INTO kkl_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Samen unulamekne sunsunum uro nimi enekori Boasag lelamogti, “Andi toplulam,” aro Boas saeag nenelamogti yan wangana sandal enekamogne tara sip kwiripto Boas tarog. ");
INSERT INTO kkl_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Tarogpa, Boastina nimi nubunang pukamek nangap kemelamsiek nimi niap ambarelamsiogti, “Sumene a'un kemelamsilom nimi a'un whingag agha Elimelekap elmabo Mahlonap, Kilionapti ni laploa tebaek so'o ni aneko Naomi saeag agha sumene na tolamna. ");
INSERT INTO kkl_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Moab kel Rut keleneko Mahlondi yauog kel aneko maupto nari tomneri Mahlon tebaonge lunumna mangkanun. Mangkaneba, sindi so'o eneko ngai uro saelbamukang. Saelbamikpa, as eneag urop nimiap el sisa nhon nimiapti Mahlon si ekon taikag aro sumene a'un whingag agha eldinge tolamnari, el lunumna mangkanun aro ambarelamsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Boasti wene seogpa, nimi ina siram peramag winiro wamek nimi tanekoap, nimi nubunang tanekoapti yubu lelamekti, “Leplamnena nun ka'ebaap. Kel andi aeag wa'ile kel eneko sembe 'NUNI Allahri yeplamlul,' aro molbarelamsiap. NUNI Allahri yeplamsileba, nunisag Yakub elkelabo phende Leaap Rahelapti elmabo maiknoro Yakub sembe mangkattek saog uro, Rut kelenekori babe nimi maikno mangkatkelul. Mangkatkeleba, anna sisa sina Efrata nimi anabiag tupne wamle paghabog an si as Betlehem tane nubu talul. ");
INSERT INTO kkl_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","NUNI Allahri an yeplangkeleba, kel saren kel enekori me maiknoro mangkatkeleba, mangkatkelenge neneko nunisag Yehuda elme Peresti me maikno likto yabahiogne saog uro wamukang. Nunisag Yehuda elkel Tamar kel enekori mangkarog mena Peresti maiknoro mangkahiog. Nunisag Peresti maiknoro mangkahiogne saog uro, Rut kelenekoriba me maiknoro mangkatkeleba, sisa nubu talul aro Nuni Allahag a'un sembe molbarelamsiap,” aro kibek. ");
INSERT INTO kkl_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kibekpa Boasti Rut kel eneko maubogti, nikag maptekpa, NUNI Allahri mikip nembaogpa, Rut kel eneko me mon taogti, me nengabo me mangkaog. ");
INSERT INTO kkl_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Me mangaro aogne sembe as Betlehem kelabo enekori Naomikag yubu lelamekti, “NUNI Allahri sumene anau an piangkenepne me nengabo me tatsilba, anyamalkel enekori meneko mangkatsilba, NUNI Allah omekto kiplamap! Me aneko Israel nimiri si nubu nenelamukang. ");
INSERT INTO kkl_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Andi mabo kaubuni saekpare mangkahisomne abenekori, an yeplangkehengne olog tamag wamsoba, anyamalkeldi an o'ona sembagheori, me mangkaro alne ya'ag uro paliag wamla. Me anekori an wana yeng nenelangkeleri, an sabal tamenba, o'obaghelul,” aro kibek. ");
INSERT INTO kkl_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kibekpa, Naomi kel enekori me aneko tobogti, saramag piamogti, me aneko mo'olamog. ");
INSERT INTO kkl_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Mo'olamogti, wamogpa, Naomi kelenekori ae peramag wamek kelabo tanekori, “Wene Naomi sembe me nengabo me nhon mangkal,” seekti, elau nengabo me aneko sina Obed engkaek. Obed el mamne Isai. Isai el mamne Daud amik mangap taog. Daud ilisag yabo sina tane palilamap: ");
INSERT INTO kkl_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peres, el mamne Hesron. ");
INSERT INTO kkl_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron el mamne Ram. Ram elmamne Aminadab. ");
INSERT INTO kkl_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab elmamne Nahason. Nahason elmamne Salmon. ");
INSERT INTO kkl_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon elmamne Boas. Boas elmamne Obed. ");
INSERT INTO kkl_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed elmamne Isai. Isai elmamne Daud mangaro likto piog. Abenda ");
INSERT INTO kkl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yubu walinge Allah Elme Yesus Kristus sembe na Markusti mome palilamnange tamna ane. ");
INSERT INTO kkl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Samenag Yesus anam yan komag, el mog so'oag yalulne sembe Allahri yubu ambarelamogti, Allah yubu silimu tiptopne Yesaya ponekori tipto mome toro pibog. Allahri samenag Elmeag lebogne Yesaya poneko el taogti, nen tipto mome tobogne ane: “Nari yubu ambatsirop nimi nhon pogneba, 'Eldi ina an pinepne sembe yarelamlul,' aro pognun. ");
INSERT INTO kkl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pognenge poneko pai aldesog urobag pileri, yubu haum aro nimi yoplamsileri, 'Ina nu saelbamsilulne yanepne sembe yarelamlulom. El yanep ina porog nenelamsut,' aro ambatsilul,” aro Allahri lebogne sunsunum uro Yesayari mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yesaya ponekori mome tobogne sunsunum uro Allahri yubu ambatsiropne poghogpa, Yohanes nimi maghag pelengahiropne poneko pai aldesog urobag yaog. Yaogti, Allah yubu ambarelamsiogti, “A'undi mali-malia wanaag seneragto ulamlomne lipsumunba, maghag pelengkipsinun. Pelengkipsineba, a'undi mali-malia ulamlomne Allahri wailag nembaleri, kom nembalul,” aro ambarelamsiogti, maghag pelengelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wene aro ambarelamsiogti, maghag pelengelamsiogpa, nimi maikno mog so'o Yudea wamek nimiap, as Yerusalem wamek nimiap, Yohanesag ka'el alamek. Ka'elamekti, “Nuri malia-malia undo-undo ulamubu” aro lag phoro ambarelamekpa, Yohanesti mag Yordan inaag pelengelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanesti pham unta hong agha wirop ag wangkamogne, Allah yubu silimu tiplameknangdi samenag wangkamekne sunsunum uro wangkamogti, uwoghag lebe aroba kon agha sunurop haing kauptangkamog. Kauptangkamogti, eldi tena whengap pondog maghap tero wamog. ");
INSERT INTO kkl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Undo tero wamogti, nimiag yubu ambarelamsiogti, “Na sam yano aghana, amik nimi nubunge nhon, nanap sunum komne phelektopne mikipne nubunge nhon yalul. Na nimi ologne wamnaba, el mikip phelektopne wamlul ane sembe, eldi arukna tanunne na sunurop kom. El mikip sirikne yaleba, na kinipto pulingkina nari eldi yan wangana haing lopna babe nanap sunurop kom. ");
INSERT INTO kkl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nari mag mo aneag agha a'un maghag pelengelamsin aghana, El nubunge yalulne ponekori Allah Eldamne Yame Walinge a'unag pelengkatsilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yohanesti nimi maghag pelengelamsiog abeneko Yesus as Nazaret, mog so'o Galilea wamogha laplobiagha, Yohanes wamoghag yaog. Yaogpa, Yohanesti Yesus mag Yordan inaag maghag pelengkaog. ");
INSERT INTO kkl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pelengkaogpa, Yesus maghag agha lambaog abeneko imag tiwalengelamogpa, im sangal naghogpa, Allah Yame Walinge mem winang saog uro elag kulukul alamogha ibog. ");
INSERT INTO kkl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Elag kulukul alamogpa, imag agha yubu nhon lelamogti, “Anna name nari o'ona senero angkenne, na wana awi nenelamnelam,” al toghogha ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Allah yubu lelamogha ka'ebaog abeneko pere, Allah Yame walinge anekori enero pabiogpa, Yesus pai aldesog urobag piog. ");
INSERT INTO kkl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Piogti, wamogti, inipna ik teng nhon epto nualbareap (40) taog. Wamogpa, phia sikini nubungeri, “Allahri iriktop yubu phibalul to, kom to,” aro wana aluktop yubu agha yubu neplamog. Yubu neplamog paghabog Yesus winangap, manaap, pagheap ua urobag wamogpa, Allah arukna malaikat imagnang yinkina el yepto piamek. ");
INSERT INTO kkl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mog so'o saelba uropne nimi nubunge Herodesti, Yohanes haing sae kaupto salero kop aeag tobongkaogpa, Yesus mog so'o Galilea so'oag piog. Piogti, Allah yubu walinge ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Allahri samenag, 'Mog so'oag nimi wali uro paiamsineri saelbamsinun,' aro salag pibogne sunsunum uro wene undo uro yabinual. A'undi mali-malia ulamlomne lipsimundi, Allah yubu walinge aneko sik sembamundi, salero ul palamsut,” aro ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus mag Galilea longorop mag peramag mag abol toman palamogti, tilamogpa, ikan oropnang phende wamdekne Simonap, ilipsae Andreasap tibogahiog. Tilamsiogpa, ikan oropnangdi ulamekne sunsunum uro ikan liptangop ag maghag talamteka tibogahiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tibogahiogti, Yesusti sinag yubu lelamogti, “Nanag yarumunba, nanap nelepto nhon pukap. Wene a'un ikan aghag lilamsirom saog uro amik sum babe yepsineba, a'undi nimi ero yubu sikne ambarelamsirumundi, nanag payahirurom. Nanag yahut,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yesusti wene seogpa, ta'ap sen koma sindinge ikan liptangtop ag laplobi agha Yesusag nelepto elap nhon palamek. ");
INSERT INTO kkl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nelebarekpa, olog we koma piekti, tilamogpa, Yesusti Zebedeus elmabo phende Yakobusap, elkae Yohanesap tibogahiog. Sikin kabong lomag wamtekti, sindi ikan liptangtop ag o'oro wetnel tolameka tibogahiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tibogahiogti, ta'ap sen koma Yesusti, “A'un nanag nelepto nhon pukap,” aro sin yopsiog. Yopsiogpa, sindi sikini Zebedeusap eldi aruknaap kabong lomag wameka aneko lilobi agha Yesusag nelebarek. ");
INSERT INTO kkl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesusap, Eldi yopsiognang abenekoap as Kapernaum piekti, wamek. Wamekpa, Yahudi nimiri poloro winiptangto Allah yubu lerop sum taogpa, Allah yubu lerop aeag wa'iekti, Yesusti Allah yubu ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wali uro ambarelamsiogpa, nimi taneko ka'ebaekti, “Yaghe, el mo el uropne wamlari, mikipneag agha ambarelamsil. Musari samenag mome tobog yubu ambatsiropnangdi undo mikipneag agha ambarelamsiang kom,” senelamekti, lo'om seek. ");
INSERT INTO kkl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yahudi nimiri Allah yubu lerop ae as Kapernaum wa'iek nimi taneko anabiag agha phia yonge kulomag wa'iog nimi nhon wamog. Wamogpa, Yesusti ambarelamsiogha ka'elamekti, lo'om alamek abeneko, phia yonge kulomag wa'iog nimi enekori haum aro yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus, Nazaretneo! An nunag hualulam? Nu sembe 'Kom nembahinun,' aro yalam te? Anna etne na el wamna. Anna Allahri 'Pognun,' aro salag pibogne sunsunum uro Eldamneri wepto pogkeogne wamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wene seogpa, Yesusti phia yonge anekoag, “Yubu kom tae! Nimi eneag agha lambae!” aro arukaog. ");
INSERT INTO kkl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","“Lambae!” aro arukaogpa, phia yonge nenekori nimi eneko yo uro lologlamogti, yubu ngolol aro nimi kulomag agha lambaog. ");
INSERT INTO kkl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lambaogpa, nimi ni taneko kembaekti, “Yaghe, mane agha ual!” al talamek. “Huropne mikipne agha undo uro yabil? Nimi enekori yubu wendogne mikipneag agha ambarelamsil. Eldi phia yongeag, 'Lambae,' aro aruklamsilba, ka'elamangdi, lanalamang,” seekti, lo'om seek. ");
INSERT INTO kkl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lo'om seekti, sindi, “Yesusti unuro unual,” aro ambarelamsiekpa, ka'ebaek nimiri tipto ambarelamsiekpa, Galilea mog so'oag yubu eneko men phea sabo taog. ");
INSERT INTO kkl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sin nimi poloro winirop aeag aneko laplobi agha, Simonap, ilipsae Andreasap sindi aeag piekti, Yesusap, Yakobusap, Yohanesap sin lambare nhon piek. ");
INSERT INTO kkl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aeag yaekpa, Simon elyamal kel naikna bobo along wamogpa, ae lomag malamog. El yamalkel eneko naiklamogha sembe Yesusag peket ambarek. ");
INSERT INTO kkl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ambarekpa, Yesus kel enekoag piogti, sae kiliro yepto pukirog. Pukirog abeneko pere bobona orog taogpa, kel enekori sin tena yepto yobarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Heng puruklamog abeneko ae imbaogpa, nimi naiktopneap, nimi phia arukna yonge kulumag uropneap maikno Yesusag payahiek. ");
INSERT INTO kkl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","As aneko nimi ni yalonga saog uro ae aneko ina siramag longol aek. ");
INSERT INTO kkl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Longol aekpa, Yesusti naikna yogne-yogne seklelamekne wali nenelamsiogti, phia arukna yonge babe nimiag agha yaglambahiog. Phia arukna taneko Yesus sembe “El etne wamla,” aro el uro wamek, ane sembe Yesusti sikinag, “A'un yubu lepseng kom,” aro irikahiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kweleknag aneko ae anam wareban komag Yesus pukogti, ae aneko laplobi agha as peramag nimi oroghag piog. Piogti, anekoa Allahag moloro yubu lelamog. ");
INSERT INTO kkl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lelamog aghana Simonap elkaboap Yesus el piek. ");
INSERT INTO kkl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Elamekti, ibekti, elag yubu lelamekti, “Nimi maiknori an elangkeangpa, nu nen samoro aeag pukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aghana Yesusti samoro ambarelamsiogti, “Kom. Nana, 'Nimi niag Allah yubu sikne ambatsinun,' aro so'oag yahi ane sembe, nu yog as peramag wamang nimiag pukapti yahut!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Anea Yesus mog so'o Galilea as wamekne kanero wamek nimiag ambattoa tongolamsiog. Allah yubu lero poloro winirop aeag babe Allah yubu ambarelamsiogti, phia arukna yonge babe yag lanalamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yesus mog so'o Galilea kanero wamek nimiag ambattoa tongolamsiog abeneko, nimi nhon konag naikna poloro telamogne, wali tanep komne, telamog nimi nhon yaog. Yaogti, Yesus whingag yabu sanukto pulingkiogti, wanaag agha mololamogti, “An wali nembahinepne wamlamdi, yeng sembamen tanena, andi na wali nembanululam, te?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Seogpa, nimi eneko o'ona sembamog. O'ona senelamogti, sae saelbamogti, yubu lelamogti, “Na yeng. Wali tae!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lelamog abeneko pere naikna aneko orog taogpa, nimi eneko wali taog. ");
INSERT INTO kkl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wali taogpa, Yesusti elag iriklamogti, “Wali pululam! ");
INSERT INTO kkl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nari an wali nembaghenne sembe ora nimiag ambatsiseng kom! Aghana memne nimi sae agha Allah sembe pairopne nhonag peket pimendi, waliaba Allah sembe pimnepne elag pabululam. Waliaba pabululamnena, Musari samenag, 'Kon naikna urop nimi wali tale tanena, Allah sembe pimnepne payalul,' aro mome toro paibog yubu sunsunum uro pabululam. Pabimendi, memne Allah sembe pairopneag aghabog ambarel pimendi, 'Wali nembamnel,' aro ambatlulam. Ambarel pimenba, kembaghelenge pere agha an wali nembaghenne sembe el taleri, waliaba tarel pabimenne Allah sembe aukag taplul. Ni undo uro yabalamle pere agha, kekneba sinag uro yabileba, nimi el wamnep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wene aro irikaog aghana, nimi eneko anekoa laplobi agha Yesusti el wali nembaogne sembe nimiag salik-malik uro neplamog. Undop agha, Yesus as nhon tibin uro wa'inep komdi, El sop-sop nimi oroghag ua ulamogpog, sopsop tala-tala nimi elag yalamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ae ik etbare Yesus undo wamogha nen samoro as Kapernaum yaogpa, “Yesus wene samoro aeag yal,” aro yubu sabo taogpa, nimi maikno ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka'ebaekti, yalamekti, aeag babe nimi aghabog teknebaek. Teknebaekti, ina siramag babe asag sip nimi to'opto longolaekpa, kolo orog taog. Undo wamekpa, Yesusti sinag Allah yubu ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ambarelamsiogpa, wamekag aneko nengabo tombareri lebe arop kom nimi nhon morea kalag keyapto, “Yesusag payaukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Payalamekti, kemelamekpa, nimi maikno longolaekne sembe Yesus peramag wa'inep kom. Wa'inep kom, ane sembe sikin imag alibag waelbaekti, Yesus wamogha alibag imag kwerekaekti, sikindi poneko morea kalap haingdi kerekto ae lomag pelengkaek. ");
INSERT INTO kkl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pelengkaekpa, Yesusti kembahiogti, el wamognena, “'Sik uro nungkae wali nembatsilul' aro seneraghangdi, payaang,” sembaog. “Sik uro wali nembatsilul,” sembaekne ipsiogti, lebe arop kom nimi enekoag yubu lelamogti, “Mele, andi mali-malia uaomne Nari kom nembanba, tam orog tal,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Wene seogpa, nubunang Musari samenag mome tobogne ambatsiropnang etpare pukamekne tanekori Yesus yubu ka'ebaekti, sindi wanaag mali senelamek. Senelamekti, “Sa'a sembe nimi ane, 'Andi mali-malia uaomne kom nemban,' alamla? Nimiri mali-malia uropne nimi nhondi babe kom nembanep kom. Eldi, 'Mali-malia uaomne kom nemban,' aro lemnepnena, Ot Allah Eldamneriog lemnep. Nimi eneri Allah san lepla,” aro wanaag seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wene aro sindi wanaag seneraglamekne Yesus peket el taogti, ambarelamsiogti, “A'undi wanaag 'Lepso kom,' senelamlomne nene sa'ambe seneraglamlom? ");
INSERT INTO kkl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nari, 'Andi mali-malia uropne orog nemban,' sen tanena, 'Sik uro yabil to, kom to?' aro nimiri imnep kom. Aghana nari elag ambatneri, 'Seke! Andi morea kalap salero pululam,' sene tanena, nimiri 'Sik uro yabil to, kom to?' aro ibikti, el tanep. Ane sembe nelagha nimiri keyagman uro lemnep? ");
INSERT INTO kkl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aghana, a'undi Na sembe el tahom senelamnari, lag nembanun. Na imag agha, 'Mog so'oag nimi tanun,' aro yahinge wamna. Allahri nari saeag mikipne pibog andarina nimiri mali-malia uropne sembe nari wailag nenero kom nembanep. Kembamundi, el talulom,” seog. Seogti, lebe arop kom nimi enekoag yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Seke! Andi morea kal saelba palame!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wene seogpa, nimi ni taneko tiboglamekpa, lebe arop kom nimi enekori sekom agha morea kal aneko tobogti, lambaog. Lambaogpa, nimi niri ponekoag tibogaekti, “Yaghe, ane mane agha ual! Tam undopne nu olog irop komne uro yabil,” aro lo'om seekti, Allah omeklamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","As Kapernaum laplobi agha Yesus samoro mag Galilea sin peramag piog. Piogpa, nimi maikno elag yalamekpa, Allah yubu ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ambattoa yabalamsiogti, nimi nhon sina Lewi, Alfeus elme tilamog. Lewi poneko Kapernaum mog so'o saelba uhiropnang yubu eptopne wamog. Kapernaum nimiri awe tolamekti, kal ma'al kamna tolamekpa, Lewi ponekori sinag aruklamsiognena, “Kal ma'al tolamlomne agha saelba uhiropnang sembe pogto nanag palilamlulom,” aro aruklamsiog. Aruklamsiogpa, payalamekpa, kal ma'al tipto iliyabo saeag tarelamsiog. Lewi poneko awe torop aeag pukamogpa, Yesus yabalamogti, Lewi pukamogha ibog. Yesusti Lewiag, “Anna nanag neleplamnululam,” seogpa, Lewi sekom agha Yesus neleplamog. ");
INSERT INTO kkl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nelebaogpa, Yesusap Lewiri aeag piekti, kwaneng telamek. Lewiri aeag kwaneng telamek nimina, Lewi elkabo saelba uhiropnangdi yubu eptopnang “Kal ma'al paya,” aro aruksiropnang maikno babe wamek. Ora nimi sin sembe nimiri, “Sikin malia ulamang,” senehirop nimi babe, Lewiri aeag yaekti, Yesus yubu ka'ero neleptopnangap kwaneng nhon telamek. Lewi elkabo anabiag agha maiknori Yesus neleplamek ane sembe, sin babe Yesus nelepto kwaneng telamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kwaneng telamekpa, Farisi nimi Musari samenag mome tobog yubu ambatsirop nimi taneko wamek. Wamekti, Yesusap nimi tanekoapti kwaneng nikag telameka tibogahiek. Yesus tibogaekti, Farisi nimi tanekori Yesusti yubu ka'ero neleptopnangag hailamsiekti, “Sa'a sembe Yesusap, sin Roma nimi kal ma'al poloro toropnangap, mali-malia urop nimi yogneap kwaneng nikag telamang?” aro haibahiek. ");
INSERT INTO kkl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Haibahiekpa, Yesus ka'ebaogti, samoro ambarelamsiogti, “Nong wali nimiri wehesirop nimi sembe yepneho senelamang kom. Ot niktop nimiri aghabog wehesirop nimi sembe yepneho senelamang. Ane saog uro, na so'oag 'Yepsinun' aro yahinge nenena, nimiri, 'Na malia urop nimi,' aro el tahoba, nimi neneko 'Yopto yepsinun,' aro yahi. Ora nimiri 'Na walia aghabog ulamna,' sembaho tanena, nimi neneko sembe yopto yepsinun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohanesti yubu ka'ero neleptopnangap Farisinangap sin tanekori, “Allahag moloro omeklamukap,” aro kwaneng ten koma omekto ulamek. Undo ulamekpa, nimi etpare Yesusag yaekti, hailamekti, “Sa'a sembe Yohanesti yubu ka'ero neleptopnangap Farisinangap sin nimi tanekori, 'Allah omeklamukap,' aro kwaneng ten koma ulamang aghana, andi yubu ka'ero neleptopnang tanekori kwaneng telamang?” aro hailamek. ");
INSERT INTO kkl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesusti samoro ambarelamsiogti, “Na so'oag wamnaag abenena, nanag neleptopnang kwaneng tero kom-kom wamseng kom. Sunumna ambatsinun. Nimi nhondi kel torop tanena, elkaboap ma'ap tahengdi, kwaneng telamseng to, kom to? Kel torop nimi tanekoap, elkaboap kel torop sum eneko elenge nimi paliap wamangne sembe kwaneng tero kom-kom wamang kom. Ane saog uro nanap, na neleptopnangap nimi pali wamapti, nu nikag wamapne abeneko nu kwaneng ten koma wamnep kom. ");
INSERT INTO kkl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aghana ik nhon sum kel toropne poneko nimiri salero pabik tanena, elkabo kwaneng ten koma wamukang. Ane saog uro na wamna kom tanena, nari yubu ka'ero neleptopnang kwaneng ten koma wamukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Seogti, sunumna nhon babe ambarelamsiogti, “Ag samenag wirop ag wamsoba, ag eneko tilipto yabiho tanena, ag wiroba wendogne taebom agha nimiri ag samenne wetnelamang kom. Ag wendogne taebom agha leknero wetnebaheng tanena, wiroba wendogne nene samenne agha pulukto koloptanep. Undop agha ag samenne eneko taepto tinilamnari lom nubu tanep. ");
INSERT INTO kkl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nen sunumna nhon ambatsinun. Nimi nhondi anggur wana lolterop mag topsori, mag tero lina pham kambing kon agha wetnerop ag mag nene tero lirop. Anggur wana weneog lolterop mag tero lirop tanena, pham kambing kon agha wetnerop ag samenne ag tero lirop kom. Anggur lolterop mag neneko kon agha wetnerop ag tero lirop tanena, anggur mag nene agha ibya lanalamlori, kon agha wetnerop ag eneko nubu nenelamlo. Nubu nembaleba, kon agha wetnerop ag samenne pulugamsoba, kon serero langtukto phobaho tanena, kon agha wetnerop ag babe, anggur loloterop mag babe loba tanep. Ane sembe, nimiri anggur wana lolterop mag wendogne aghag tero lirop tanena, sop-sop kon eren kon agha wetnerop aghag tero lirop,” seog. Yesusti, “Wendogneap samenneap nikag pimnep kom,” seognena, likiptop yubuag agha lelamogti, “Nari wene ambarelamsinne neneap, a'undi samenag agha sop-sop kwaneng ten koma ul palamlomne neneap sunsunum urop kom,” aro likiptop yubu agha ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Olog wameka, Yahudi nimiri Allah yubu lerop sum taogpa, Yesusap eldi yubu ka'ero neleptopnangap palamekti, kwaneng roti wana sina gandum awe wero meroba nubungeag ina palamek. Palamek abeneko pere, Yesus eldi yubu ka'ero neleptopnangdi gandum wana tagto tobek. ");
INSERT INTO kkl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tagto tobekpa, Farisinangdi sin tibogahiekti, “Awe tomnep kom sum wamap aghana, gandum wana tagto tobang,” sembaek. Undo sembaekti, Yesusag hailamekti, “Kembamen! Musari samenag mome tobognena, Allah yubu lerop sumeneko awe tomnep kom aro mome tobog. Sa'a sembe an neleptopnangdi yubu nene ka'eban koma roti wana nene tagto tobang?” aro Yesusag haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Haibaekpa, Yesusti samoro ambarelamsiogti, “Nunisag nubunge Daud poneko samen wamogti, uaogne sembe a'un ekon, te? Abyatar memne poneko nimi sae agha Allah sembe pairopnang sikini nubunge wamog ko'oag Daud ponekori uaogne sembe mome toropneag agha kemerop kom, te? Memne Allah sembe pairopne nubunge Abyatar samen wamog ko'oag, Daudap elkaboap sindi kwaneng orog taog. Kwaneng orog taogpa, Daud poneko Allahri Mem Ae enekoag wa'iogpa, kwaneng roti Allah sembe pibekne taneko tatsiogpa, teek. Kwaneng roti teekne tanekona, Musari samenag mome tobogne sunsunum uro, 'Ot memnang Allah sembe pairopnangdi aghabog tenep,' seog. Aghana, Daudap elkaboapti kwaneng roti neneko teekne sembe Allahri, 'Malia uang,' seog kom. ");
INSERT INTO kkl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Allahri nimi sam sumbahiog. Amiknena, Allah yubu lero tektek papto urop sumeneko nimi wali uro wamnepne sembe nembirogti tatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Allah yubu lero tektek papto urop sum babe nimi sembe tatsiog, ane sembe nimiri uanepne sembe na imag agha mog so'oag nimi tahingeri salelamnari, o'obanep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Olog wamekpa, Allah yubu lerop sum taogpa, Yesus nen Yahudi nimi poloro winirop ae Allah yubu lerop aeag wa'iog. Wa'iogpa, nimi nhon sae tara malinge ae lomag wamog. ");
INSERT INTO kkl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wamogpa, Farisi nimi etpare babe ae lom neneag wamek. Sin Farisi nimi agha nenneri, “Yesusag tam pipsebe,” aro Yesusti uropne keme nenelamek. Sin Farisi nimi seneraglamekti, “Sumene Allah yubu lero tek-tek papto urop sum wamap. Musari samenag mome tobog yubu sunsunum uro nimiri awe tomnep kom aghana, Yesusti sumene nimi nene wali nembalul to, kom to?” aro Yesus kemelamek. ");
INSERT INTO kkl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kemelamekpa, Yesusti sae tara malinge ponekoag yubu lelamogti, “Yae, nimi ni whingag ane sekel ae,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Seogti, nimi ni wamekag ambarelamsiogti, “Wela sembalom? Allah yubu lero tek-tek papto urop sum wamapnena, Musari samenag aruktop yubu mome tobogha sunsunum uro nimiri huanep? Musari mome tobogne sunsunum uro nimiri walia uanep to, malia uanep to? Tek-tek papto urop sum wamapnena, nimi wali nembahinep to, nimi ya'ag opsinep to?” aro ambatsiog. Wene aro ambatsiog aghana, sin yubu koma wamek. ");
INSERT INTO kkl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yubu koma wamekpa, Yesusti el wamogti, “Farisinangdi sae malinge poneko sembe o'ona senelamang kom,” sembaogti, wanaag yonge waelbaog. Wanaag yonge waelbaogpa, wana mali sembaogti, ni wamekag kanero kembahiog. Kembahiogti, sae tara malinge ponekoag yubu lelamogti, “Sae nginikae,” seog. Seogpa, poneko sae nginikaogpa, sae wali taog. ");
INSERT INTO kkl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wali taogpa, tibogaekti Farisinang taneko nimi poloro winirop aeag agha lambaek. Lambaekti, “Welaro Yesus obukap?” aro Galilea mog so'o saelba uropne Herodesti nimiap ma'ap taekti, “Yesus obukap,” aro yubu nikne lebek. Lelamekpa, Yesusap eldi yubu ka'ero neleptopnangap ko'oro piek. ");
INSERT INTO kkl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesusap eldi yubu ka'ero neleptopnangap wamekag laplobi agha mag Galilea sin abolag piek. Piekpa, Galilea nimi maikno nimi teng-tengne Yesusag nelepto piek. ");
INSERT INTO kkl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yesus amik nelepto piek nimina, as Yerusalem nimi babe, Yerusalem kanero mog so'o Yudea nimi babe yaek. Mag kwasag sip mog so'o Idumea nimi babe, mag Yordan kauro yale sip nimi babe, heng purukul pirobag sip as Tirusap as Sidonap kanero wamek nimi babe, nimi maikno teng-tengne yaek. Sin taneko yaekne, Yesusti ulamogne sembe ka'ebaekti, kemelaek. ");
INSERT INTO kkl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Nimi maikno Yesusag kemelaekpa, Yesusti nimi maikno wali nenelamsiog. Wali nenelamsiogpa, naiktop nimi maikno tanekori, “Nu babe Yesus nongag saelbahabeba, wali nembahiso,” aro sendebel alamek. Ane sembe Yesusti eldi yubu ka'ero neleptopnangag ambarelamsiogti, “Nimi taneri na lingnilomniikagti, na mag alip toman pinunne sembe kabong nhon weamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sendebel alamekpa, sin taneko wamek nimi anabiag agha phia yonge kulomag uahirop nimiri Yesus tibogaek tanena, Yesus whingag u amupto malangkalamek. Malingkina yubu haum aro lelamekti, “Anna Allah elme,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Undo lelamek aghana, phia yonge tanekori, “Yesus Allah Elme wamla,” aro lag phoro lelamekne sembe karongdi, Yesusti sikinag aruklamsiogti, “A'un yubu kom tahut! Na Yesus etne wamnange sembe leplulom kom!” aro arukahiog. ");
INSERT INTO kkl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","19","Yesus yim nhonag waelbaogti, eldi wanaag agha, “Nimi neneap neneap wali yopsinun,” sembaogne sunsunum uro yopsiogpa, nimi taneko el yaghag yaek. Yaekpa, nimi aobare wepsiogti, sekitsiog. Wepto sekitsiog nimina: Simon, el si nhon Petrus aro Yesusti si engkaogne poneko webog. Zebedeus elmabo phende Yakobusap ilipsae Yohanesap wepsiogti, yubu maikno mikip uro lelamdekne sembe, “Boanerges,” aro si engkahiog. Yahudi nimiri yubuagna, “Limang elmabo,” aro engkahiog. Andreasap Filipusap Bartolomeusap Matiusap Tomasap Alfeus elme Yakobusap Tadeusap wepsiog. Simon, eldi “Yahudi nimi mo seksebe,” aro ulamogne ponekoap Yudas Iskariotne Yesus aisanangag pankhebaogne ponekoap babe wepsiog. Wepsiogti ambarelamsiogti, “Nari a'un wepsin. A'un nanap ma'aro wapmundi, nikag wamukap. 'A'undi phia yonge nimi kulomag agha yag lanalamsululom,' aro a'undi saeag mikipne pimnun. Nari a'un sembe, 'Phia yonge nimi kulomag agha yag lanalamsimundi, Allah yubu ambatto tongolamsululom,' aro pogsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yim aneko laplobi agha Yesus aeag samoro piog. Aeag piogti wamoghag, nimi maikno, “Yesus kemel pukap,” aro yaek nimi along nen ae anekoag longolaek. Undo longolaekpa, Yesusap eldi yubu ka'ero neleptopnangapti yeplamsiek paghabog kwaneng ologha babe tenep kom wamog. ");
INSERT INTO kkl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesusti ulamogne sembe nimiri lel palamekpa, Yesus ilipsabo taptopneap ilinap ka'ebaekti, “El nenek saelbal,” sembaek. Ane sembe ka'ebaekti, enero tol pukap aro Yesus yaghag yalamek. ");
INSERT INTO kkl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anam enel an komag, Musari samenag mome tobog yubu ambatsiropnang Yerusalema Yesus wamoghag kulukulaekti, lelamekti, “Phia sikini nubunge si Beelzebul nenekori el mo Yesus kulomag wa'io. Wa'ionge nenekori Yesusag mikipne pibo andari, eldi phia yag lanalamsil,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Seekpa, Yesusti sin Musari mome tobogne ambatsiropnang taneko yopsiogti, sunumna etpare pere agha ambarelamsiog. Ambarelamsiogti, “'Phia sikini nubunge mikipne pere agha phia yag lanalamsil,' alamlom. Undop agha, 'Phia sikini nubunge Satanas nenekori nimi kulomag agha eldamne yag lanaptanep,' alamlom, te? ");
INSERT INTO kkl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","As nhon pogto mal talamnari, as aneko khaepto wali uro wamnep to, kom to? ");
INSERT INTO kkl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ae lom nhon nimi mamun aisa nenehiro mal tangkamna tanena, khaepto wali uro wamnep kom. ");
INSERT INTO kkl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ane saog uro phia sikini nubunge Satanas nenekori eldamne aisa neneptangto elkabo yag lanalamsisoba, sin leya pehengpa, el mikip uro wamso komdi, timbaho. Aghana phia sikini nubunge Satanas nenekori eldamne aisa neneptangtop komdi, el mikip wamla. ");
INSERT INTO kkl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mikip wamla aghana, nari phia yag lanalamsinne sembe sunumna ambatsinun. Nimi mikipneri ae wamsoba, nimi etneri babe ae aneko wa'iro nimi mikipne anekoringe haogha tomnep kom. Ot yog nimi, mikip phelektop nimiri ae ngainge mikipne neneko salero haing sae kaupso taneogna, ae anekoag wa'ina ae ngainge mikipneringe taluro tomnep. Sunumna nenena, nari mikip phelektopneag agha phia yag lanalamsinne sembe a'un ambatsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Wene aro lebogpa, Musari samenag mome tobogne ambatsiropnangdi, “Yesusti phia sikini nubungeri mikipneag agha ulamla,” seekne sembe, Yesusti nen tipto ambarelamsiogti, “Sikne agha nari ambatsineba, wali uro ka'ebalulom. Nia mangkina nimiri mali-malia uropneap nimiri san leropneap ni Allahri wailag nenero tam kom nembanep. Aghana nimi etneri Allah Eldamne Yame Walinge san lepseng tanena, Allahri tam nene orog nembanep kom. Nimi etneri Allah Yame Walinge sembe mali aro san lerop tanena, malia uropne neneko Allahri tam orog nemban koma tam ya'ag uropne wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Wene aro lebogpa, Yesus ilinap ilipsaboap yaek. Yaekag aneko nimi maikno Yesus peramag kanero pulaekti, longolamek ane sembe, ilinap ilipsaboap asag nangnangkamek. Nangnangkamekti nimi nhonag, “Yesus yobol wa'ilulam!” aro poghekpa, Yesus kanero pukamek nimi anekori tipto yubu lelamekti, “An aninap anipsaboap asag wamangdi, elangkeang,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wene seekpa, Yesusti samoro ambarelamsiogti, “'An aninap anipsaboap,' selom aghana, naninap naipsaboap ane etne?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Seogti, el peramag kanero pukamek nimi kemelamsiogti, yubu lelamogti, “Kembahilulom. Na nanin naipsabo wamloa saogne tane wamang. ");
INSERT INTO kkl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nimi etneri Allahri seneropne sunsunum uro ul palamle tanena, nimi eneko sembe 'Naipsae, naipsa'el, nanin,' senelamsindi, o'ona senelamsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesusti nen Galilea mag sin abolag piogti, alniro yubu ambarelamsiog. Ambarelamsiogpa, nimi maikno sirik longowarekaekpa, el mag alip toman pirop kabong nhonag pulingkiog. Kabong lomag pulingkiogti, “Nimiri na tiboganeikpa, yubu ambatsinun,” aro mag alibag olog ko'oro piogpa, nimi maikno taneko mag abolag sekamek. ");
INSERT INTO kkl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sekamekpa, Yesusti likiptop yubu agha tam maikno sembe sunumna ambarelamsiog. Ambarelamsiogne undo eldi sikin ambarelamsiog: ");
INSERT INTO kkl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ka'eamlulom! Nari ambatsinenge wali uro seneraglamlulom! Awe weropne nhondi so'oag wana togtoba maikno yamoro toghol palamog. ");
INSERT INTO kkl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yamoro toglamogba, wana nenne inaag timbaog. Inaag timbaogpa, winang yingkina wana togna toghogha taneko ni toro teek. ");
INSERT INTO kkl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wana nenne babe so'o ologhag kirik phalag timbaog. Anekoag timbaogti, so'o ologhari wana togna toghogha aneko elemag pongo saelbaog. ");
INSERT INTO kkl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pongo saelbaog aghana kirik phalag so'o ologhari, yareng weag wa'in kom. Ane sembe heng waelbaogti, bobori pongoraba taneko elemag halo aro ul taog. ");
INSERT INTO kkl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nenne babe pongoroba alog aba nusamag timbaogti, pongkaog aghana, alog aba tanekori niknibaogpa, aweag toghogne neneko wana mauamog kom. ");
INSERT INTO kkl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aghana nenne babe so'o mesaag sukuptobag timbaog. So'o mesaag ingkiogne wali uro pongkaogti, wana mauamog. Pongkaogti, yo'o nenneri wana teng nhon, nenneri wana teng phende, nenneri wana teng tombare maubaog,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Seogti, Yesusti ambarelamsiogti, “Nimi ni ao wamla ane sembe, sunumna wene ka'ebalom tanena, wali uro seneraglamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Seogti, el mo wamogpa, eldi yubu ka'ero neleptopnang aobare abenekoap, yog nimi elap wamek nimiap Elag hailaek. Sindi Yesusag hailamekti, “Likiptop yubuag agha sunumna etpare sunuro ambatsilamne neneko, tam huropne sembe ambatsilam,” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Haibaekpa, eldi ambarelamsiogti, “Amik Allahri so'oag nimi maikno saelbamsilul. Allahri nimi maikno saelbamsilula welaro wamlulne sembe samenag tognoro wamog. Tognoro wamog aghana, na wene a'un sembe lag phoro ambarelamsin. Aghana sin nanag sikne aro seneragtop kom nimi sembe likiptop yubuag agha ni ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Samenag Allah yubu silimu tiptop nimi nhondi sik uro yabilulne sembe mome toro pibog. Eldi Allah yubu tipto mome toro pibognena, 'Wanaag agha ka'ebahengdi, seneragsengdi, Allahag samoro yaheng tanena, Allahri sindi malia uropne tam orog nenero wailag nembalul. Aghana, sindi sop-sop 'Ipsene' aro haingdi ililamukang aghana, wanaag agha seneraghukang kom. 'Ka'ebahane' aro aori ka'elamukang aghana, wanaag agha ka'ebaukang kom,' aro mome toro pibog. Ane sembe nari sin undop saog nimiag likiptop yubuag agha sunumna sunuro ambarlamsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wene seogti, Yesusti nen eldi yubu ka'ero neleptopnang ambarelamsiogti, “A'un sunumna wana yamoro togtoba sembe seneragnep kom tanena, sunumna orange ambatsinenge babe welaro seneraglulom? ");
INSERT INTO kkl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sunumna aneko tibin nembahinun: Wana aweag yamoro togtopne poneko Allah yubu walinge ambatto poa tongohirop nimi sembe lemna. ");
INSERT INTO kkl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wana toglamnaba, inaag yingkirop sennena, Allah yubu ka'erop nimi sembe lemna. Allah yubu ambatto poa tongohirop nimiri ambatsirop yubu ene nimi eneko ka'erop. Ka'erop aghana, ka'eamna abeneko pere phia sikini nubunge nenekori yingkina nimi wanaag tognange abeneko toltol yingkirop. ");
INSERT INTO kkl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wana toglamnaba, kirik phalag yingkirop sennena, Allah yubu ambarelamsinba, peket elemag yeng uro ka'erop nimi sembe lemna. ");
INSERT INTO kkl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Elemag yeng uro ka'erop aghana, Allah yubu ambatsirop yubu eneko nimi enekori wanaag yareng pelengka urop komne saog wamla ane sembe, nimi eneko khaepto wamnep kom. Nimi undopnena, Allah yubu sunsunum uro ul piropne sembe eraruk tale tanena, Allah yubu saelban koma elem uro lilohirop. Allah yubu sunsunum uro ul piropne sembe ora nimiri malia ulamsiik tanena, elem uro Allah yubu sae limnep. Pongoroba yareng pelengka urop komne saog uro, nimi undopne khaepto wamnep kom. ");
INSERT INTO kkl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wana toglamnaba, pongoroba alog aba nusamag yingkirop sennena, nimi nenne Allah yubu ka'erop nimi sembe lemna. ");
INSERT INTO kkl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Undop nimi anekona Allah yubu ka'erop aghana, sindi wanaag sop-sop, 'Wela wamnun,' aro wana ikin uro seneraglamang. Undo seneraglamangdi, 'Tup tahaneri, nia ni walinge nari saeag taho,' senenne sindi wanaag to'op tangtopneri, Allah yubu niknil orop. Niknilamlaba, sindi wanaag kolo orogti, Allah yubu pongoro wana maubanep kom saog wamla. ");
INSERT INTO kkl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wana toglamnaba, so'o mesa sukuptobag yingkirop sennena, sin Allah yubu ka'ero wali uro seneragto salerop nimi sembe lemna. Sindi wali uro Allah yubu saelbanne agha sindi wanaag Allah yubu pongoro wana maiknoro mauamla. Nenneri wana teng nhon maurop, nenneri wana teng phende maurop, nenneri teng tombare maurop saog uro sindi wanaag wamla,” aro Yesusti tibin nenero ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Seogti, Yesusti likiptop yubuag sunumna nhon babe ambarelamsiogti, “Nimiri whea timbom agha auk pok kau mombolag niknirop te? Kombagha tanena, auk pog mamneba mombolag tognorop te? Kom! Nimiri whea timbom agha 'Eptobag wareamlul,' aro laghag ikto pairop. ");
INSERT INTO kkl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Allahri samenag salag lebogne whea saog uro wamla. Allahri yubu lebogne 'Ya'ag tognoro wamlul,' aro lebog kom. Nia tognoro wamlange, 'Lag taleba, el taukang,' aro lebog. ");
INSERT INTO kkl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nimi ni ao wamla ane sembe, nari yubu lelamnange wali uro ka'ebalulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Seogti, Yesusti nen tipto lelamogti, “Nari ambarelamsinne wene ka'elamlomdi, wali uro seneraglamlulom! A'undi ka'elamlom yubu nene sunuro seneraglamlomne sunsunum uro Allahri babe a'un sumbahileri, tam kemero karebi agha tatsilul. Abeneog kom aghana, nen phelekto tatsilul. ");
INSERT INTO kkl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nimi etneri, 'Na olog ka'eamnari, seneragna aghana, wali uro el tahane,' senelamle tanena, elag ma'aro tatlul. Aghana nimi etneri, 'Olog seneragnep komdi, limnun,' senelamle tanena, seneragna ologha elag wamlange babe kom talul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusti nen yubu lelamogti, “Amik Allahri mog so'oag nimi maikno saelbamsilul. Mog so'oag nimi saelbamsilulne nenena, nimi nhondi wana togna togtoba aweag meropne saog uro wamla. ");
INSERT INTO kkl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wana aweag toghi agha, inipnag mamnep. Kweleknag puknep. Mabom pukom alamnaba, wana togtoba taneko pongoro nubu tanep. Mabom pukom alamnari kemelamnaba, nubu tangtop aghana, pongoroba ane welaro pongorop anena, nimi togna merop nimi enekona ekon. ");
INSERT INTO kkl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wana so'oag wamlange mo pongorop. Mo pongoro towalengkandi, yo'o waelban tanena, es uandi, wana maurop. ");
INSERT INTO kkl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wana maubandi, whi tan tanena, ngainge poneko imnari, 'Yongorop li yan tanena tagnun,' sembanep,” aro sunumna Allahri mog so'oag nimi saelbamsilulne sembe Yesusti likiptop yubu ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Seogti, Yesusti nen lelamogti, “Allahri mog so'oag nimi saelba uhirop nimi wene ologha aghana, amik sum Allahri mog so'oag nimi maikno saelbamsilul. Maikno saelbamsilulne ane huropneag agha sunuro ambatsinep? Tam huropneag agha a'unag tibin nenero sumbatsinun? ");
INSERT INTO kkl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Allahri amik ma'arop nimi maikno saelbahilulne nenekona, kwarang si so'oag togtopne saog uro wamla. Kwarang si nene sik uro olog sirik. ");
INSERT INTO kkl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nimiri kwarang si olog sirikne nene toro eldi aweag memna tanena, pongoro meroba nenne memnange anabiag agha, el agha alikin sirik uro pongoro waelbanep. Pongoro waelbandi, sae la'imbanba, winangdi kal sae tanekoag ae solanep,” aro sunuro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Sunumna undo saogne maikno likiptop yubuag agha ambarelamsiog. Likiptop kom yubuag agha nimi maikno whingag ambarelamsiog kom. Ambarelamsiog yubu enena, nimiri wanaag seneragnepne sunsunum uro ambarelamsiog. Ambarelamsiog aghana, nimi maikno lambaekpa, Yesusap eldi yubu ka'ero neleptopnangap mo wamekti, likiptop yubu ambatsiog yubu eneko ni tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sumeneko ae sin taogpa, Yesusti el neleptopnangag yubu lelamogti, “Yahut! Nun mag sin tara sip kauro pukapti,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Seogti, eldi yubu ka'ero neleptopnangap kabong nhonag wa'iek. Wa'iekpa, yog nimi babe, “Nhon pukap,” aro sindi kabong etpare lomag wa'iekpa, nimi mag abolag wamekne taneko laplobi agha, “Mag kauro tara sip pukap,” aro mag alip toman piek. ");
INSERT INTO kkl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Palamekag abeneko, khao nubunge alniro ulamogti, mag kola'epto yalamogti, kabongag sibil alamog. Sibil alamogpa, mag saplukto kabongag wa'alamogpa, kabong anekoag mag teknebanep saog ulamog. ");
INSERT INTO kkl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Undo unulamogpa, Yesus kabong pomaghag sip wamogha usog eptoba alibag malamog. Malamogpa, eldi yubu ka'ero neleptopnangdi kamolamekti, “Nai! Yubu ambatsiropne! Magti nu olamsilba, tebabeagti, an log semban koma mo malamlam, te?” seek. ");
INSERT INTO kkl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Seekpa, Yesus pukogti, khao anekoag walamogti, mag kola'epto yalamogne anekoag, “Angnibae! Paplobe!” aro irikaog. Wene seogpa, khao aneko angnibaogpa, mag aneko babe paplobog. ");
INSERT INTO kkl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Paplobogpa, Yesusti eldi yubu ka'ero neleptopnangag yubu lelamogti, “Sa'a sembe a'un log senelamlom? Sa'a sembe a'undi nanag 'Sikne,' aro seneraglamnelom kom?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Undo unuaogpa, sin log lelem, “Yaghe, mane agha ual,” sembaek. Sembaekti, sin mamun hail talamekti, “Nimi enena etne? Khaoap mag kola'epto yabiropneap eldi aruksirop yubu leplange ka'ebarangdi, angnibarang,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kabongag agha mag alip toman palamekti, Yesusap el neleptopnangap Galilea mag sin kauro mog so'o Gerasa piek. ");
INSERT INTO kkl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Piekti, Yesus kabong lomag agha kuluka yangkalamogpa, kaubuni nhon phia kulomag wa'iog nimi nhondi Yesus yalamogha tiboghaog. Nimi enekona, Yesus anam yan komag phia el kulomag wa'iogpa, nimi teptop nimi kirik selenga lomag pail pirobag ua ulamog. Inipnag kweleknag nimi teptoba kirik lomag pail pirobag yim kongtenag taneko ua ulamogti, haum aro kirik agha nongag karebel dalamog. Yog nimiri “El yae wamukap,” aro ik sulu salero sae mamunap, yan mamunap haing kauplamek aghana, sop-sop pulpulukto eplamsiog. Yan sae haing kauplameknena, nimiri haing pulukanep kom haing besiag agha sunurop haing babe kogto puluklolamsiog. El kulomag phia ua ulamogneri mikipti, nimi nhondi babe saelbanep kom ulamog. Phia kulomag wamog nimi enekori Yesus yalamogha weag agha tiboghaogti, nimi teptopne kirik selenga lomag pail pirobag aneko laplobi agha merero Yesus wamoghag yingkiog. Yingkiogti, Yesus whingag yabu sanukto u amupto pulingkiog. ");
INSERT INTO kkl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yan sanukto u amupto pulingkiogpa, Yesusti phia kulomag wamog nimi anekoag lelamogti, “Phia yonge, nimi ane kulomag wamlamne, lambae!” seog. Seogpa, phia yonge yubu mikip uro haum alamogti, “Yesuso, Allah paliag uropne Elme wamlamne! Sa'a sembe na neplamnelam? Na 'Seklebale' aro na omneheng kom. Allah siag agha 'Opkenun kom,' aro nanag salag lero ambatnehom!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Seogpa, Yesusti phia yonge anekoag hailamogti, “An si etne?” seog. Seogpa, samoro lelamogti, “Nu phia maikno teknero nimi ane kulomag wamap. Ane sembe, na si Legion,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ambarogti, Yesusag sarikto ko'oro mololamogti, “Andi mog so'o aneag agha nu yag lambahiseng kom,” aro mololamog. ");
INSERT INTO kkl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sin wameka peramag pham maikno main alunag so'o ero toro telamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Phia yonge tanekori Yesusag mololamekti, “Nu pham kulomag wa'al phukap. Andi nunag, 'Pham taneag wa'isut,' aro nu arukahisom,” aro mololamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Seekpa, Yesusti, “Hae, pululom,” seog. Seogpa, phia yonge taneko ponekoag agha lambaekti, pham taneko kulomag wa'iek. Wa'iekpa, pham taneko merelamekti, kwerenag eba timbom agha mag sinag tagpurukom seekti, tebaek. Purukom seek pham taneko teng-tengne (2.000) tagpurukom seekti, tebaek. ");
INSERT INTO kkl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mag sinag tagpurukom seekti tebaekpa, pham yae paia ulamsieknang taneko logti laplobi agha merebaek. As peramag wamek nimiag merebaekti, uro yabiogne sembe ambarel phiek. Ambarel phiekpa, nimi taneko sindi asag lambaekti, “Sa'a uro yabil,” aro kemelaek. ");
INSERT INTO kkl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusag yaekti, kemelamekpa, el samen phia maikno kulomag wamog nimi wali taogne poneko ane pukamog. Wali taogti, ag nongag wangkamogti, wana peket uro pukamog. Pukamogpa, ibekti, “Welaro uro yabil?” aro log tahiog. ");
INSERT INTO kkl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Log tahiogpa, ni uro yabiogne ibek nimi tanekori sin kemelaek nimiag el nenelamsiek. El nenero ambarelamsiekti, “El phia kulomag wamo nimi agha Yesusti phia yag lambahilba, phia phamag wa'iangpa, mag sinag tagpurukom seangdi, tebang,” aro el nenero ambatsiek. ");
INSERT INTO kkl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wene aro ambatsiekpa, ka'ebaekti, mog so'o eneko nimiri Yesusag, “Nuri mog so'o eneag wamlulam kom. Pululam,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","“Pululam,” seekpa, Yesus “Pinun” aro kabong lomag wa'alamog abeneko pere, phia kulomag wa'iogha wali taogne ponekori Yesusag mololamogti, “Nanap wali nhon pukap te?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wene seog aghana, Yesusti, “Nanap nhon pukap kom aghana, andi aeag pululam. Im So'o Ngainge Ponekori anag yareag sembangkeldi, maiknoro yepkelba, wali talam. O'ona maikno senero yepkelne sembe angkaboag ambarel phululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Seogpa, piogti, nimi ponekori, “Yesusti na maiknoro yepneori, wali nembaneo,” aro ambarel phiog. Eldinge as aghabog ambarel phiog kom aghana, mog so'o si As Sa'obare nimiag babe ambarel phiog. Ambarelamsiogha ka'ebaekti, As Sa'obare mog so'o taneko nimi niri, “Yaghe, mane agha uao,” sembaek. ");
INSERT INTO kkl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus mog so'o Gerasa wamogha, nen kabong lomag wa'iogti, mag sin Galilea kauro tara sip piog. Piogti, kabong lomag agha kuluka yangkaogpa, nimi maikno mag sin abolag wamek nimi Yesus peramag warekto longolamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yesus mag sin abolag wamogpa, nengabo nhon si Yairus yaog. Yaogne poneko elna, as taneko nimi sembe Allah yubu lero nimi poloro winirop ae saleropne poneko Yesus wamoghag yaog. Yesus ibogti, Yesus yan tamag yabu sanukto uamupto malangkina kibog. ");
INSERT INTO kkl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Malingkina kibogti, Yesusag wanaag agha mololamogti, “Nani! Nari kelme tebanep saog wamla. El tebaleagti, an yamendi, 'Nanenge kelme tebaleag' aro sae pipmenba, wali talul,” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wene aro molbaogpa, Yesus babe Yairusap nhon pirek. Palamdekpa nimi maikno neleplamekti, nimi lingniptangto palamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sin Yesus nelepto lingniptangto palamek nimi anabiag agha, kelabo nhon hengkun aobare eneng sopsop palamog kel sin nusamag wamog. ");
INSERT INTO kkl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eneng palamog kelenekona, samenag agha whesiropnang maiknori “Yebukap,” aro ulamekpa, kal ma'al tarelamsiog. Kal ma'al ni eldi saeag agha tarelamsiogpa, whesiropnangdi ulamekne pere agha maiknoro seklelamogpog, naikna aneko orog taog kom. Wenena, ot kal ma'al orog taog aghana, naikna luluro nubu taogpa, wamog. ");
INSERT INTO kkl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Seklero naiklamog aghana, Yesusti nimi maikno wali nenelamsiogne sembe kel enekori ka'ebaogti, senelamogti, “Ot eldi ag nongag wangkamlange agha po'obahaneri, wali tanun,” sembaog. Ane sembe, Yesus nelepto palamek nimi anabiag agha kel eneko Yesus amik peram tang-tang yalamogti, eldi nongag enektop ag kel enekori po'obaog. ");
INSERT INTO kkl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aghag po'olamog abeneko pere eneng palamogne aneko pabog. Kel enekori, “Wene seklenne orog talba, sik uro wali tan,” sembaogti, el taog. ");
INSERT INTO kkl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kel eneko wali taog abeneko pere, Yesus el taogti, “Mikipne nanag wamlange agha nimi nhon weneog wali tal,” sembaog. Sembaogti, wailag sip taongkom agha hailamsiogti, “Etneri nari aghag po'obal?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yesusti haibahiogpa, eldi yubu ka'ero neleptopnang nhondi samoro ambarelamogti, “Nimi maikno lingnil talamanga iamsilam aghana andi, 'Etneri nari aghag po'obal?' aro haibahilam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wene seog aghana, Yesusti nen “Nari aghag po'obal nimi eneko imnun,” aro keme warekahiog. ");
INSERT INTO kkl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Keme wareklamsiogpa, kel enekori senelamogti, “Yesusti mikipneag agha wali tan,” aro el uro wamog. Kel eneko logti pet-pet aro Yesus whingag yingkina uamupto malingkiogti, ni uro yabiogne sembe lag phoro Yesusag ambarog. ");
INSERT INTO kkl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lag phoro ambarogpa Yesusti, “Namangkel, Nanag, 'Wali nembanelul,' aro nanag sikne aro seneraglamnelamne agha wali talam. Anag naikna seklelamomne kom talba, ya'ag wali talam. Wana aingniro wapmendi, pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusti kelenekoag yubu lelamog abeneko, Allah yubu lerop ae saelbamogne poneko Yairusti arukna etpare yaek. Yaekti ambarelamekti, “Nai, kelme aneko tebal. Ya'ag loba talbana, yubu ambatsiropne poneri hualul kombana, enero poa peheng kom,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Seek aghana, sindi yubu lebekne sembe Yesusti ka'eban koma saog uaog. Ka'eban koma saog uaogti, Yesusti Allah yubu lerop ae saelbamogne poneko Yairusag yubu lelamogti, “Log sembaheng kom. Ot nanag 'sikne' aro seneraglamnululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wene seogti, Yesus nen tipto palamog aghana, el nelepto palamek nimi ni tanekoag, “Ane wamlulom,” aro irikahiog. Ot Petrusap, Yakobusap, Yakobus ilipsae Yohanesap, sin nimi wilindi abenekoag, “Nhon pukap,” seogti Yesusap nhon Yairusti aeag piek. ");
INSERT INTO kkl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yairusti aeag peram palamekpa, Yesusti kemelamsiogpa, nimi engenari pinim kolomna alamekpa, yubu maiknoro lelamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Engenari pinim kolomna alamekpa, Yairusti aeag aneko Yesus wa'iogti, “Sa'a sembe engelamlomdi, yubu maikno lelamlom? Kelme anena mali tal kom. Elna mana agha malamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesusti wene seogne sembe nimi tanekori Yesusag ogsolamek. Ogsolamekpa nimi tanekoag, “A'un asag lambahut,” aro asag yag lambahiog. Yag lambahiogti, ot kelmeneko iliap ilinap, el neleptopnang wilindi yaekne abenekoap aghabog, kelme mali tangtobag aneko wa'iek. ");
INSERT INTO kkl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wa'iekti Yesusti kelme aneko sae saelbamogti, Yahudi nimiri samenag yubu lerop yubuag lelamogti, “Talita kum,” seog. Nun yubuag, “Namangkel, anag yubu lelamna. Puke!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","“Puke!” seog abeneko pere, kelmeneko puka sekelingkiogti yabalamog. Kelmeneko mangkaekag agha heng kun aobare wamogpog tebaogpa, Yesusti kamag nembaog. Sindi kelmeneko kamag uro wamogha haingdi ibekti, “Yaghe manegha ual,” aro lo'om paibon alamek. ");
INSERT INTO kkl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lo'om paibon alamekpa, Yesusti iriktop yubu ambarelamsiogti, “Kelme ane nen kamag talne sembe nimi nhondi babe nimiag ambatsiseng kom,” aro mikip uro ambatsiog. Wene seogti, nen tipto lelamogti, “Kelme ane kwaneng tatmunba tulul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","As Kapernaum aneko laplobi agha Yesusap eldi yubu ka'ero neleptopnangap eldi asag Nasaret piek. ");
INSERT INTO kkl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Piekti, Allah yubu lerop sum taogpa, Yahudi nimiri poloro winirop aeag wa'iekpa, Yesusti Allah yubu ambarelamsiog. Ambarelamsiogpa, eldi asag nimi maikno wamekne taneko Yesusti ambarelamsiogne ka'ebaekti, “Yaghe,” seek. Seek aghana, sindi wanaag karong senelamekti, sin mamun hailtalamekti, “El neneko etneri wana hekaoba, undo ambarelamsil? Mikip huropneag agha eldi sae pere agha nimiri uanep komne, Allah Eldamneri uanep saogne ulamla? Nimi enena, Mariam elme ae soropne neneko ane. Ilipsabo Yakobusap, Yosesap, Yudasap, Simonap wamangne nu el. Ilipsa'elabo babe tane wamang. Nimi eneko kom to?” aro karong senelamekti, eldi yubu wa'epto ka'elamek kom. ");
INSERT INTO kkl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Karong senelamekti, ka'elamek komne sembe, Yesusti ambarelamsiogti, “Allahri yubu silimu tiptop nimi elenge asag agha lambahori, yog nimiri asag Allah yubu ambatsisoba, yog asag nimiri el kipto ka'erop. Ot Allahri yubu silimu tiptop nimiri elenge asag Allah yubu ambatsiso tanena, eldi ae lom nimi babe, elenge asag nimi babe el kipto ka'erop kom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","As aneko wamek nimiri elag “Sikne” aro seneraglamek komne sembe Yesusti eldi wanaag, “Yaghe, huro sik senelamang komba” sembaog. El sin Nasaret nimi nusamag wamogpa, elag sikne aro seneraglamek kombana, “Allahri Yesus pere agha ual,” senenne kekneba uanep kom saog wamog. Ot nimi etpare naiklamek nimi as anekoag wamekpa, Yesusti sinag sae pipsiogti, wali nembahiog. Nasaret nimiri sik senelamek komne sembe Yesusti, “Yaghe,” senelamogti, as kanero wamek nimi taneko “Ka'ebaukang,” aro nhon asag, nhon asag pina, Allah yubu ambatto poa yabalamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Allah yubu ambatto poa tongolamsiekti, eldi yubu ka'ero neleptopnang aobare abeneko “Yahut,” aro yopsiog. Yopsiogti, ambarelamsiogti, “A'un nimi aobare wamlomne tane phende-phende palamlulom. Nari a'un poglamsinnena, 'Palapmundi, phia nimi kulomag ulamsiangne yag lanalamsululom,' aro nari mikipne a'unag palilamsin,” aro pogsiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Poglamsiog abeneko pere aruklamsiogti, “Ot kame tunguna saelbapmundi pululom. Orange pabaheng kom. Kwaneng teroba babe, ag nubunge babe, kal ma'al babe pabaheng kom. ");
INSERT INTO kkl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Palapmunne, yan sangag wangaropne enekalulom. Ag nongag wangkapmunne babe, hai pabalulom aghana, ag nongag wangkanepne lununne pabaheng kom. ");
INSERT INTO kkl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","As nhonag wa'al pimunba, ae ngainge nhondi, 'Nari aeag malamturom,' seleba, wapmundi, ae enekoag aghabog malamlulom. As anekoag ambarelamsimundi, nhon aeag mal pang, nhon aeag mal pang uaheng kom. Nimi nhondi aeag og malapmundi, as anekoag wamik nimi sembe komopto ambatsimun taneogna, ae aneko laplobi agha as anekoa lambamundi, wali pululom. ");
INSERT INTO kkl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aghana a'un as nhonag pimunba, nimi tanekori a'undi yubu ka'ebaik kom tanena, as aneko laplobi agha pululom. Laplobi agha palapmundi, so'o ubun yanag wamlenge po'oro pelengkalulom. Po'oro pelengkipmunne ane as aneko nimiri kembaikti, 'Malia lebobonge ane Allahri ipsildi, nu opsileagti,' sembaukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Seogpa, aobarenang aneko piekti, “A'undi mali-malia uropne lepsisut,” aro ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ambarelamsiekti, Yesusti sinag mikipne pipsiogneag agha phia nimi kulomag ulamogne maikno yag lanalamsiek. Nimi niktop nimi maikno babe kemelamsiekti, kal saitun wana lolterop mag usoghag pelaglamsiekti, Yesus poneko mikipne pere agha wali nenelamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Undo unulamekpa, nimiri Yesusti ulamogne sembe a'ero-a'ero seneraglamek. Nenneri, “Allah yubu silimu tiplamek nimiri samenag ulamek saog uro, el babe Allah yubu silimu tiptopne wamlari ulamla,” senelamek. Nenneri, “Allah yubu silimu tiptopne Elia nen samoro yaori, el agha ane to?” senelamek. Nimi nhon-nhondi Yesus sembe senelamekti, “El Yohanes, nimi maghag pelengehiropne poneko wamla. Yohanes poneko samenag tebao aghana nen kamag tangka yao. El kamag tao ane sembe, nimiri uanep komne Allahri mikipne el pere agha ulamla,” aro lelamek. Nimiri Yesusti ulamogne sembe maiknoro lelamekpa, mog so'o Galilea nimi sembe yubu sia leropne Herodesti babe ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesti ka'ebaogti, el lobaro seneragto lelamogti, “Ane sik Yohanes. Samen nari arukahinoba, nimiri Yohanes ngang karebaongpa, tebao. Aghana, wene el nen samoro kamag tao,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yubu sia leropne Herodesti Yohanes obogne undo uro yabiog. Samen Herodes ilipsae Pilipus wamog. Pilipus elkel Herodias wamogpa, yubu sia leropne Herodes ponekori ilipsaeri kel eneko pelepto aog. Pelebaogne sembe Yohanesti Herodesag yubu lelamogti, “An anipsaeri kel pelebaomne nene, Allahri yubu lebogne irikna phiro uaom,” aro wembaog. Wembaog ane sembe, Herodesti pelepto aog keleneko Herodiasti ela'angeag lelamogti, “Yohanes nene saelbamendi, haing sae kaupto kop aeag tobongkalulam,” seog. Seogpa, Herodesti nimi arukahiogpa, Yohanes salero haing sae kaupto tobongkibek. ");
INSERT INTO kkl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Wembaogne sembe Herodes elkel Herodiasti, “Yohanes ya'ag omnun,” aro yo senelamog. Yo senelamog aghana, ela'ange Herodesti, “Yohanes poneko nimi sikne Allah Eldamneri poghogne wamlari, walia ulamla,” aro el wamog. Ane sembe Herodesti Yohanes yae urop nimiag, “Yohanes poneko wali uro piamlulom,” aro arukamsiogpa, elkel Herodias nenekori “Yohanes omnun,” sembaog aghana, omnep kom wamog. Wamogpa, yubu sia leropne Herodesti babe Yohanesti ambarelamog yubu ka'elamog abeneko pere, yeng uro ka'elamog aghana, elkel Herodias pelebaogne sembe “Huahane?” aro enhaun seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Olog wamekpa, ik nhon sum yubu sia leropne Herodesti, “Na mangkaneek sum kwelekto yabilbana sani yobatsinun,” aro nimi nubunang yopsiog. Eldi yubu eptopnangap, eldi yin saleropnang sikindoyaboap, mog so'o Galilea nimi nubunangap, “Na mangkaneek sum talbana, sani nikag tukap,” aro yopsiog. Yopsiog sumeneko elkel Herodiasti, “Sumene 'Yohanes omnun,' senelamnange pa'asea sumene agha,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sembaogpa, sani nikag telamekne pere agha Herodias elmangkel wa'iogti, saren kelenekori nimi nubunang taneko whing toman kolapto seplamog. Kolapto seplamogpa, Herodesap elap nikag telamek nimiapti, “Saren kelene wali uro kolapto seplamla,” aro awi sembaek. Awi sembaekpa, yubu sia leropne Herodes ponekori saren kel enekoag, “Nanag molbane. Andi 'Sa'a-sa'a tatneho,' senelamlama tatkenun. ");
INSERT INTO kkl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nari saelbamna mog so'o molbanemena babe, naringe nhon andinge nhon pokto tatkenun. Sik lemna. Andi molbanemena tatkene kom tanena, Allah imnelne ponekori hae omnelul,” aro salag lebog. ");
INSERT INTO kkl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wene seogpa, saren kel enekori ilin Herodiasag hail palamogti, “Kain, na sa'a moloro anun?” aro haibaog. Haibaogpa, ilindi samoro ambarelamogti, “'Yohanes maghag pelengehiropne ngang karepto olopmenba, usog imnun,' aro Herodesag molbalulam” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wene seogpa, ta'ap sen koma saren kel eneko Herodes yaghag samoro piog. Piogti, mololamogti, “Nai, nari anag mololangkennena, Yohanes maghag pelengehiropne tebalul. Eldi usog ngangag agha karepto olobikti, usog yangkarobag paia tarelaikpa, imnun,' aro mololangken,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Molbaog yubu aneko ka'ebaogti, Herodes wana ikin taog. Wana ikin taog aghana, eldi wanaag seneraglamogti, “Tane wamang nimi whingag, 'Tatkene kom tanena hae Allahri omnelul,' aro salag pimna,” aro seneraglamogti aliri, “Kom senep komdi, hae tatnun,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wene sembaogti, ta'ap sen koma yin salero nimi ohirop nimi nhonag, “Kelenekori, 'Yohanes maghag pelengehiropneri usog imnun,' selba karebel pimendi, payalulam,” aro arukaog. ");
INSERT INTO kkl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ane sembe nimi nenekori Yohanes piamekag aneko piogti, Yohanes usog ngangag agha karebel pina yangkarobag pibogti, Herodias elmangkel tarel aog. Tarel aogpa, saren kel enekori tipto ilinag 'Iplul' aro tarel piog. ");
INSERT INTO kkl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wene aro obekpa, Yohanesti yubu ka'ero neleptopnangdi ka'ebaekti, Yohanes nong teptoba tol aek. Tol aekti, Yohanes nong teptoba aneko pabiekti, kirik selenga lomag pail piek. ");
INSERT INTO kkl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesusti wepto pogsiognang taneko nen samoro Yesus yaghag yaek. Yaekti sikindi nimi yepto ulamekneap, nimi Allah yubu ambarelamsiekneap sembe Yesusag ambarek. ");
INSERT INTO kkl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ambarekpa, nimi maikno “Yesus kemel pukap,” aro pang yang ulamekneri Yesusap el neleptopnangap kwaneng tenep kom wamog. Ane sembe el neleptopnang ambarelamsiogti, “Yahut! Nu nimi oroghag piberi, olog nu wali tektek papto wamukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wene seogpa, sin kabong lomag wa'iekti, nimi oroghag sip mag alip toman piek. ");
INSERT INTO kkl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piek aghana, nimi maikno sikin palameka ipsiekti, “Tanetna Yesusap el neleptopnangap agha palamang,” aro el tahiog. El tahiogpa, mog so'o anekoag wamek nimi maiknori, “'Yesusap eldi yubu ka'ero neleptopnangap mag abolag anoko saingil pukap,' aro ulamangpana, so'o toman merero sin sam whing karepto pukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus kabong lomag agha lambom agha tilamsiogpa, nimi teng-tengne longkamek. Longkamekpa kembahiogti, “Nimi taneko wana ophag aro wamangnena, pham domba paia uhirop nimi orogti, pham domba 'Tala pukap,' aro ophag alo saog uro wamang,” aro o'ona sembahiog. O'ona sembahiogti, yubu maikno ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ambarelamsiogpa, ae sin taogpa, eldi yubu ka'ero neleptopnangdi Yesusag yubu lelamekti, “Ae imbalba, mog so'o ane ae sorop komag paiag wamap. ");
INSERT INTO kkl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kwaneng orogti, andi nimi taneag 'A'un koloptahut,' aro ambatsimenba, as kanero wamangneag kwaneng kamna kapto tol pukang,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wene seekpa, Yesusti samoro ambarelamsiogti, “A'undi agha kwaneng tatsimunba, tukang,” seog. Wene seogpa, sindi, “Nunag kal ma'al ologha wamlangena, tane wamang nimi teng-tengne wamangneap sunurop kom. Nuri kal ma'al agha ni tane wamang nimi sembe sunuro kwaneng tenep uro kamna kapto topsebe tanena, nimi nhondi wal linbare awe topsoba, kamna tatnep saog urop kal ma'al maikno agha kwaneng kamna kapto topsebe. Andi nunag, 'Hae tol pululom,' selam, te?” aro Yesusag haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wene seekpa, Yesusti hailamsiogti, “A'unag kwaneng roti etpare poamlom? Kemel pululom,” seog. Kemel piekti, “Kwaneng roti taroba lambareap, ikan phendeap wamla,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wene aro ambarekpa, Yesusti el neleptopnangag ambarelamsiogti, “Nimi palu a'ero-a'ero nembia, 'O'olaba saiag puksut,' aro ambattoa yabihilulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Seogpa, ambattoa yabihiekpa, nimi taneko teng-tengne wamek aghana, palu nhonag nimi teng phende saog uro, nhonag nimi teng tombare saog uro longoro pul piek. ");
INSERT INTO kkl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pukekpa, Yesusti kwaneng roti lambareap, ikan phende abenekoap tobogti, imag tiwalengkia Nuni Allahag, “Wali tatsilam,” seog. Wene seogti, kwaneng roti taneko tobogti, eldi yubu ka'ero neleptopnangag, “Nimi taneko kwaneng tatsululom,” aro khepto-khepto tatsiog. Tatsiogti, ikan phende abeneko babe sop kelekto-kelekto tatsiog. Tarelamsiogpa, el neleptopnangdi nimi ni tanekoag pogto tarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Poglamsiekpa, sin ni teekpa, mon og tahiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Teekpa mon og tahiogpa, phelektopne babe wamog. Eldi yubu ka'ero neleptopnangdi kwaneng rotiap ikan sopap phelektopne poloro pibekti, haing agha kau saog uro wiroba nubunge aobare liro pibek. ");
INSERT INTO kkl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nimi kwaneng teekne taneko kaubuniog teng-tengne (5.000) wamek. Aghana kelabo me babe wamekti teekpa, mon og tahiogne a'ilbahin kom. ");
INSERT INTO kkl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wene kwaneng teekpa, ta'ap sen koma Yesusti eldi yubu ka'ero neleptopnangag, “A'un kabong lomag wa'imundi, na laplobi agha mag sin kauro as Betsaida sam pululom. A'un sam palapmunba, nari nimi maikno tanekoag 'A'ununge asag phut,' aro ambatsinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mag sin kauro palamekpa, Yesusti nimi maikno tanekoag, “Pululom,” seog. Seogti, “Mo wamneri, Allahap yubu lemnunam,” aro main nhonag waelbaog. ");
INSERT INTO kkl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Main nhonag yingkiogpa, imbaogpa, eldi yubu ka'ero neleptopnang kabongag agha mag sin nusamag palamekpa, Yesus el mo mag sin abolag wamog. ");
INSERT INTO kkl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mag abolag wamogti, tilamsiogpa, mikip uro mag kau karepto palamek aghana, khao sin whingag siba yalamogneri eka'uktina, nemen uro palamek. Mag sin nusamag eka'uk uro palamekpa, tibogahiogti, inipna tom nusam anabi, kwelekna anabiag, sikin wamekag mag alip toman yan ingiro piog. Palamogti, “Phibom agha pinun,” aro saog ulamog. ");
INSERT INTO kkl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","“Phibom agha pinun,” aro saog ulamogpa, tilamekpa, el mag alip toman yan ingiro palamogha tibogaek. Tibogaekti, inibin sembe sin kabong lomag wamekne taneko niri, “Phia yalamla,” aro log maikno seklebaekti, ngolol alamek. Logti ngolol alamek abeneko pere Yesusti sinag yubu lelamogti, “Nangkabo! Log sembaheng kom. Na Yesus a'unag yalamnari, wana aingniro wamsut!” seog. ");
INSERT INTO kkl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wene seogti, kabong lomag wamekneag wa'iogpa, khao aneko angnibaog. Eldi yubu ka'ero neleptopnang kabong lomag wamekne tanekori, “Yaghe, mane agha ual,” aro lo'om paibon seek. ");
INSERT INTO kkl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Lo'om paibon seeknena, tam nene sembe. Yesusti kwaneng roti ologha tobogti, nimi teng-tengne kwaneng tatsiogpa, mon og uro teeka ibek aghana, anam wanaag seneraghek komdi, wana hekamsin koma wamek. Ane sembe, Yesus mag alip toman yan ingkiro mag sin nusamag yalamogpa, khao aingnibaogha ibekti, weneog, “Yaghe, Yesus poneko mikip sirikne wamla,” aro lo'om paibon seek. ");
INSERT INTO kkl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kabongag agha mag sin kauro tara sip piekti, mog so'o Genesaret saingnil ingkiekti, kabong mag abolag kerekaek. ");
INSERT INTO kkl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Saingnil ingkiekti, kabong lomag agha lanalamek abeneko nimi maiknori sin tibogahiekti, “Yesus yal,” aro el tahiog. ");
INSERT INTO kkl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","El tahiogpa, nimi tanekori merero as nhonag pang, nhonag pang ulamekti, “Yesus yal,” aro el nenelamsiek. “Yesus tane yal,” ana ka'ebaekti, nimiri niklamek nimi taneko morea kalag keyapto poa, “Yesus wamla,” seekag payalamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesus as nubungeag to, ologneag to, tala-tala palamogpa, “Yesus yal,” ana ka'ebaekti, nimi niktopne poa “Yesus whingag nembaneba, wali nembalul,” aro nimi longorobag payalamsiek. Payalamsiekpa, nimi niktopne tanekori wanaag agha Yesusag mololamekti, “Ot andi ag nongag wangkamlamne ag po'obahane tanena, wali tanun,” aro sarikto-sarikto mololamek. Nimi etneri eldi aghag babe po'olongolamek tanena, wali talamek. ");
INSERT INTO kkl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ik nhon sum Farisinangap, Musari samenag mome tobog yubu ambatsiropnang etpareap Yerusalema Yesusag yaek. ");
INSERT INTO kkl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yaekti, kembamsiekpa, Yesus el neleptopnang etpare kwaneng telamek. Kwaneng telamekag aneko, Yahudi nimi sikinisag yabori “Allah whingag wali wamukap,” aro sae a'elero ul palamekne sunsunum uro uaek komdi, sae a'elban koma kwaneng telamek. ");
INSERT INTO kkl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tamna undo. Yahudi nimi sikinisag yabori samenag ambarelamsiekti, “Allah whingag sembenga pibebeagti, sae linag agha sae ma'alag wali uro a'alelamebe taneogna, kwaneng telamukap,” aro ambarelamsiekti, ul palamek. Ane sembe Farisi nimiap, ni Yahudi nimiap sop-sop sikinisag yabori ambarelamsiekne sunsunum uro ul palamekti, sae a'elban koma kwaneng telamek kom. ");
INSERT INTO kkl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sa'a-sa'a kamna kapto tol pina, nimi longorobag palamekti, samoro yalamek tanena, sae a'elban koma kwaneng telamek kom. Sae aghabog kom aghana, sikinisag yabori ul palamekne, mag ma'i ologne, nubunge babe, kwaneng ingiro tena babe, wali uro a'elban koma kwaneng telamek kom. Sikinisag yabori ul palamekne sunsunum uro Yahudi nimiri sop-sop ul palamek. ");
INSERT INTO kkl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ane sembe Yesusti yubu ka'ero neleptopnangdi sae a'elban koma kwaneng telamekpa, Farisinangap, Musari samenag mome tobog yubu ambatsiropnangap abenekori ipsiekti, Yesusag hailamekti, “Sa'a sembe andi yubu ka'ero neleptopnangdi sae linag agha sae ma'alag a'elban koma kwaneng telamang? Nunisagyabori, 'Allah whingag wali wamukap,' aro ul palamekti, 'Undo-undo unulamlulom,' aro ambatsiek yubu phibang,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Seekpa, Yesusti samoro ambarelamsiogti, “A'undi sop-sop senelamlomne, 'Nimiri na wali kembanukang,' aro walia uloa saog ulamlom. Aghana samenag Allahri yubu silimu tiptopne Yesaya ponekori a'un sembe mome toro pibog. Allahri yubu lebogpa, Yesayari tipto mome toro pibognena, 'Nimi tanekori pamag agha na omeklamneang aghana, sindi wanaag sik uro omeklamneang kom. ");
INSERT INTO kkl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sindi nimiag yubu ambarelamsiangnena, Nimiri senenneag agha 'Undo-undo unuaukang,' aro ambarelamsiang. Aghana Na Allahri aruksirop yubu sik uro ambarelamsiang kom. Ane sembe sindi Na omeklamneang yubu ka'elamna kom.' aro Allahri ambarogpa, Yesayari tipto mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nimiri, 'Undo-undo unualulom,' aro ambatsiropne mikip uro saelba ulamlom aghana, Allahri aruksirop yubu lilobi agha saelba ulamlom kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesusti Farisinangap, Musari yubu ambatsiropnangap tanekoag tipto ambarelamsiogti, “Yaghe, a'undina, 'Wali sirika ulamap,' senelamlom te? A'undi ul palamlomnena, 'Nunisagyabori “Undo-undo ul palamukap,” senenne saelba Allahri aruksirop yubu ingisaplamlom. Sik, wali ulamlom te? ");
INSERT INTO kkl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Unulamlom aghana, tam nenena wela sembamlom? Samenag Allahri Musa ambarelamogpa, Musari tipto ambatsiognena, 'A'uni a'unin abeneko kipto o'ona senelamsululom,' seog. Seogne apna, 'Nimi etneri ili ilin yo'olamsile tanena, nimi eneko ya'ag oplulom,' seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Musari wene seog aghana, a'undi ul palamlomneap, Musari yubu ambatsiogneap olog sunsunum kom saog wamla. Sunumnana undo. Nimi nhondi eldi nong nimiag yubu lelamsori, 'Nai kaen, nari saeag wamlange agha yepsisene aghana, nari samenag “Allah sembe pimnun,” aro salag pimno. Salag pimno ane sembe, a'un yepsinep kom,' aro lemnep. Nimiri eldi nong nimiag undo ambatsiso tanena, Allahri aruksirop yubu, 'A'uni a'unin abeneko kipto o'ona senelamsululom,' aro lebogne sunsunum urop kom. Sunsunum kom aghana, a'un Farisinangap, Musari mome tobog yubu ambatsiropnangapti, 'Nong nimi yepsinep kom,' selenge ponekoag, 'Hae, andi saeag agha “Allah sembe pimnun,” aro salag pibom. Ane sembe andi nong nimi yepsululam kom,' aro nimiag ambarelamsilom. ");
INSERT INTO kkl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tam neneog kom. Tam nene saogne maikno ulamlom. A'undi amona nimiag ambarelamsilomdi, 'Nunisagyabori ul palamekne sunsunum uro ulamsebe,' aro ambarelamsilom abeneko pere, a'undam nimiri Allahri aruksirop yubu lilobi agha wail ibarelamlom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Seogti, nimi maikno taneko yopsiogti, yubu ambarelamsiogti, “A'un ni wali uro ka'ebamundi, seneraglamlulom! ");
INSERT INTO kkl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nimiri sa'a-sa'a tenba, kulomag wa'in tanena, nimi eneko sembe Allahri, 'Loba,' senelamla kom. Nimiri wanaag agha seneraghongkia mali-malia lero ulamla tanena, wanaag agha malia lero uropne sembe Allahri, 'Loba,' sembanep. ");
INSERT INTO kkl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nimi ni ao wamla ane sembe, ka'eamlomne nene wali uro seneraglamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wene seogti, Yesus nimi maikno taneko laplobi agha piogti, eldi yubu ka'ero neleptopnangap aeag wa'iek. Wa'iekti, eldi yubu ka'ero neleptopnangdi elag hailamekti, “Sunumna nimiri tenaba sembe ambatsilamne sa'a sembe leplam?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Haibaekpa, Yesusti sinag hailamsiogti, “A'un olog anam seneraglom kom te?” aro haibahiog. Yesusti wanaag seneraglamogti, “Nia mangkina nimiri tenaba tehonge sembe Allahri nimi eneko sembe, 'Loba,' sembalul komdi, nimiri tenaba ni tenep,” aro, “Tibin nenero ambatsinun,” sembaogti, tipto ambarelamsiog. Eldi yubu ka'ero neleptopnangag ambarelamsiogti, “Nimiri sa'a-sa'a tenba, kulomag wa'in tanena, nimi eneko sembe Allahri, 'Loba,' senelamla kom. Tam nenena, a'un wana hekto seneraglom kom te? Nimiri sa'a-sa'a tenaba terop tanena, nimi kulomag wa'irop aghana, wanaag ya'ag wa'irop kom. Nia mangkina nimiri tenaba tenba, monag tisirikag wa'irop aghana nen lambanep,” seog. Eldi yubu lebogne neneag agha, “Nia mangkina tenaba waliri, nimiri terop, tanena Allahri, 'Loba,' sembalul kom,” aro tam karepto pibog. ");
INSERT INTO kkl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wene seogti, nen ambarelamsiogti, “Nimiri wanaag agha lero uropne sembe Allahri, 'Loba,' sembanep. ");
INSERT INTO kkl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Nimiri wanaag agha lero uropne nenena, 'Undo unuahane,' aro seneragtopne agha mali-malia lelamlari ulamla. Nimiri wanaag agha seneraghongkia mali-malia ulamangnena: kelabo nengabo toptangkamna komne salik-malik tektangtop, ora nimiri kelabo nengabo sembe, 'Naringe wamsoba saelbahane,' aro pelepsirop, nimiringe haogha torop, nimi ya'ag ohirop, aboapti, topsene senerop, yoaba uahane senerop, orolena lerop, nimiri wana bobongeag agha ali neneptangtopne urop, yog nimiringe sembe naringeog wamso senerop, nimi san lerop, metmereng arop, wanaag seneragna koma ua urop, ");
INSERT INTO kkl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ni lemnange tanena, nimiri wanaag agha seneraghongkia unulamlange sembe undo unurop nimi eneko sembe Allahri, 'Loba,' sembahinep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wene seogti, Yesusti mog so'o Galilea laplobi agha mog so'o Tirus peramag piog. Piogti, “Tektek papto wamnun,” sembaogti, “Nimiri imneikag,” aro ae nhonag wa'iogti, wamog. Wamog aghana, nimiri el yal aro el taek. ");
INSERT INTO kkl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kelabo nhon elmangkel phia yonge kulomag wamog kel enekori ka'elamogpa, “Yesus yal,” ana ka'ebaog. “Yal,” ana ka'ebaog abeneko pere keleneko yingkina “Yesus kipnun,” aro el whingag yabu sanukto uamupto malingkiog. ");
INSERT INTO kkl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yesus sekamogpa, yanag malingkiogti, Yesusag mololamogti, “Namangkelag phia yonge wamlaba, yamendi, yaglambalulam,” aro wanaag agha sarikto-sarikto molbaog. Molbaog aghana, keleneko nimi sisa Yahudi kel kom. Mog so'o Siria as nhon Penisia peram wamogneag agha mangkaek kel wamogpog, Yesus whingag mololaog. ");
INSERT INTO kkl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Molbaogpa, Yesusti kel enekoag lelamogti, “Nimiri sikinmabo sam kwaneng tarelamsiangdi, amik kam kwaneng tarelamang. Kwaneng me ologneri saeag agha pelepto kamag tobogsin tanena mali. Ane saog uro na yog asag nimi sam yebel phinep kom. Namabo Yahdudinang nari yubu ka'ero neleptopnang sam komopto yepsisene taneogna, nimi sisa Yahudi kom nimi amik yebel phinep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Seogpa, kelenekori, “Mikip phelektopne wamlari, ologha sirikagne tatneho,” aro wanaag seneraglamogti, lelamogti, “Nai, otsik leplam. Aghana kwaneng meri telamnaba, ubun pelengloropne kam umag ua tokto toro tenep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Seogpa, Yesusti elag lelamogti, “Andi samoro ambatnelamne wali leplam. Andi molbanelamne wene uro yabil ane sembe, hae pululam. Phia yonge andi kelme kulomag agha lambal,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","“Lambal,” seogpa, keleneko eldi aeag piog. Piogti kemelamogpa, elmangkelag phia yonge kulomag wamogne neneko lambaogpa, keleneko tektek papto marobag malamog. ");
INSERT INTO kkl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wamogha Yesus Tirus mog so'o aneko laplobi agha, Sidon ina agha palamog. Palamogti, mag sin Galilea peramag phibom agha heng walelingkirobag sip mog so'o si As Sa'obare as anabi toman piog. ");
INSERT INTO kkl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Piogti wamogpa, nimiri Yesusag nimi yubu lerop komne ao leptopne nhon payaek. Payaekti, “Sae elag pipmenba, wali talul,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wene aro molbaekpa, Yesusti “Mo wamnunam,” aro yubu lerop komne ao leptopne poneko poa nimi oroghag pabiog. Pabiogpa mo wamdekti, Yesusti sae ma'al agha ao lom abenekoag tobongkibog. Tobongkibogti Yesusti sae ma'alag sulumag supto yubu lerop komne ponekori silimuag pelaghirog. ");
INSERT INTO kkl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Silimuag pelaghirogti, imag tiwalengkia Yesusti hain nubu uro ebaogti, pho aro lelamogti, “Efata,” seog. Yahudi nimiri lerop yubuag “Efata,” seognena, nuri yubuag “Kube,” aro lebog. ");
INSERT INTO kkl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wene seog abeneko pere, ao kubogti, pam silimu lebe aro yubu lemnep wamogpa, peket uro yubu lelamog. ");
INSERT INTO kkl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Nimi eneko wali taogti, peket uro yubu lelamogpa, Yesusti sin wamek nimi tanekoag, “Tam nene sembe nimiag ambatsiseng kom,” aro irikahiog. Irikahiog aghana, nimi tanekori Yesusti wali nembaogne sembe “Map, mane agha ual,” aro lo'om seekti, wana awiri ambatto poa yabalamsiek. Yesusti nen “Ambatsiseng kom,” aro sarikto-sarikto irikahiogpog, sindi yubu nubu nenero ambatto poa yabalamsiek. Ambatto tongolamsiekpa, ka'elamekti, “Nia mangkina wali ulamlari, nimi pam ao leptopne babe kuplamsilba, yubu lelamang,” aro yubu sabo nenero ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sin taneko ik etpare wamekpa, nimi maikno Yesus wamoghag longol aek. Longoro ulamekpa, kwaneng orogti kwaneng yo ulamsiogpa, Yesusti ipsiog. Ipsiogti, Yesusti eldi yubu ka'ero neleptopnang yopsiogti, yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nimi maiknori nanag nelepto kemel aneongpa, wamap paghabog inipna ik wilindip sum tal. Ik wililindip sum talba, kwaneng orogti kwaneng yo sembamangdi, wamangba, yareag senelamsin. ");
INSERT INTO kkl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nari sinag 'A'ununge asag pululom,' aro ambatsisene aghana, sin tane wamang nimi weag nimi agha yingkina wamang. Ane sembe, 'Pululom,' sene tanena, 'Kwaneng yoapti mandu aro phukul piikag,' senelamnari, 'Pululom,' senun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Seogpa, eldi yubu ka'ero neleptopnangdi samoro lelamekti, “Sik, nimi along tanekori kwaneng teheng aghana, kwaneng orogbana, pai aldesog urobag wamaptina, tala siba kwaneng roti sunuro tol pinep?” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wene seekpa, Yesusti, “Kwaneng roti etpare poamlom,” aro haibahiog. Haibahiogpa sindi, “Kwaneng roti saekpare wamla,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wene seekpa, Yesusti nimi maikno wamek nimi tanekoag, “Puksut,” seogti, kwaneng roti saekpare abeneko tobogti, Allahag, “Nani, wali tatsilam,” seog. Seogti, kwaneng roti saekpare abeneko saeri khepto-khepto eldi yubu ka'ero neleptopnangag, “Tarel phululom,” aro tatsiog. Tatsiogpa, nimi maikno taneko pogsiek. ");
INSERT INTO kkl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sin wamekne anabiag nimiri ikan ologne etpare babe poamek. Ikan ologne abeneko babe Yesusti tobogti, Allahag, “Nani, wali tatsilam,” seog. Seogti, ikan abeneko babe el neleptopnangag, “Pogsululom,” aro tatsiogpa, pogto tarel phiek. ");
INSERT INTO kkl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Pogto tarel phiekpa, nimi ni teekpa, mon og tahiog. Sumeneko teek nimi teng-tengne (4.000) mon og uro teek. Kwaneng rotiap ikan sopap phelektopne babe wamog. Eldi yubu ka'ero neleptopnangdi kwanengap ikan sopap phelektopne poloro pibekti, haing agha kau wiroba nubunge saekpare libaek. Wene teekpa, mon og tahiog taneogna, Yesusti nimi tanekoag, “A'undi asag pululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Seogti, ta'ap sen koma elap eldi yubu ka'ero neleptopnangap kabong lomag wa'iekti, mag sin Galilea kauro heng puruknag sip mog so'o Dalmanuta piek. ");
INSERT INTO kkl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Piekpa, Farisi nimi etpare “Mibukap,” aro Yesusag yaekti, yubu leldalamek. Yubu lelamekti, “Allah Imagne ponekori sik uro an pere agha ulamla tanena, kekneba nhon ualulam,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sindi elag sik semban koma wene aro ambarekpa, Yesusti hain nubu ebaogti, wana ikin senelamog. Wana ikin senelamogti, samoro ambarelamsiogti, “A'un wene wamlom nimiri na sembe ka'elamlomdi ililamnelom. Sa'a sembe nanag, 'Nen kekneba nhon ualulam,' alamlom? Sik uro lemnuan. Nari kekneba a'un sembe nen tatsinun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Seogti, Farisi nimi taneko lilobiagha Yesus kabongag waelbaogpa, eldi yubu ka'ero neleptopnangap mag kauro tara sip piek. ");
INSERT INTO kkl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kabong lomag agha mag alip toman mag kauro palamek. Palamek abeneko pere, sin el taekti, “Kwaneng roti sembe ekon taapti, nhonog payaap,” aro el taek. ");
INSERT INTO kkl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sin kabong lomag agha mag alip toman palamek nimiag, Yesusti wenero ambarelamsiogti, “Farisi nimiap, nimi nubunge Herodesap sin abeneko wanaag 'Waelbalul,' aro yamoroba saog uro wamlange sembe, 'Nunag taleag,' aro haing whi uro togtangto yae wamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wene seogpa, eldi yubu ka'ero neleptopnang taneko seneraghekti, sin mamun lelamekti, “Nu kwaneng roti payaap kom ane sembe, 'Roti waebalul,' aro yamoroba sembe undo lepla,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wene alamekne Yesusti ka'ebahiogti, hailamsiogti, “Sa'a sembe kwaneng roti orogne sembe tam nembalomdi yubu lelamlom? A'undi wanaag seneraglamlom komdi, a'undi seneragna sao kauplolamsil, te? Wana hekamsin komdi ekon wamlom, te? ");
INSERT INTO kkl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A'undinge haing wamla aghana sa'a sembe ililamlom kom? A'undinge ao wamla aghana sa'a sembe ka'elamlom kom? Nari uanonge sembe ekon talamsil te? ");
INSERT INTO kkl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kwaneng roti lambare abeneko agha nimi teng-tengne (5.000) khebatsinoba, teongne sembe seneraglamlulom. Kwaneng teongba, mon og tahioba, kwaneng roti phelektopne poloro pibomne, kau wiroba nubunge etpare libaom?” seog. Seogpa, “Kau wiroba aobare libabo,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wene seekpa, Yesusti nen hailamsiogti, “Nen amik sum kwaneng roti saekpare agha nimi teng-tengne (4.000) khebatsinoba, teongne sembe babe seneraglamlulom. Kwaneng teongba, mon og tahioba, kwaneng roti phelektopne poloro pibomne, kau wiroba nubunge etpare libaom?” seog. Seogpa sikindina, “Kau wiroba saekpare libabo,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wene seekpa, Yesusti sinag samoro ambarelamsiogti, “Undop pogna, a'undi sumene babe anam seneraglamlom kom te?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kabong lomag agha mag alip toman palameka as Betsaida piek. Piekpa nimiri as enekoag agha nimi haing uropne nhon Yesusag payaekti, “Elag sae pipmendi, wali nembalulam,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Molbaekpa, Yesusti nimi eneko sae kiliro as enekoag agha poa lambaog. Poa lambaogti, nimi aneko haingag sulumag likto sae ni phende pibog. Sae pibogti hailamogti, “Andi sa'a iplam?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wene seogpa, nimi eneko whingag sip tibogaogti, yubu lelamogti, “Nimi yabalamangba, tibogamna aghana, tibin uro iamna kom. Yabalamangba ililamsinne kaldi lebe aro yabaloa saog ililamsin,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wene seogpa, Yesusti nen ik phendep sum sae phende ponekori haingag pibog abeneko pere, nimi aneko haing kwelekaog. Kwelekaogpa, el nia mangkina tibin uro ililamog. ");
INSERT INTO kkl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tibin uro ililamogpa, Yesusti ponekoag aruklamogti, “Nimi asag ambatsin koma aeag pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tanena Yesusap eldi yubu ka'ero neleptopnangap as nubunge Kaisarea-Pilipi kanero wamek asag piek. Inaag palamekti, Yesusti sinag hailamsiogti, “Nimirina na sembe etne alamang?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Seogpa, samoro ambarelamekti, “Nimi nenneri an sembe, 'Yohanes maghag pelengehiropne poneko tebaog aghana, nen kamag taonge poneko ane,' senelamangdi, yubu lelamang. Nenneri, 'Elna, samenag Allah yubu silimu tiptopne Elia poneko samoro yaori wamla,' senelamangdi, yubu lelamang. Nenneri, 'Elia kom aghana samenag Allah yubu silimu tiptopne yogne kamag taonge wamla,' senelamangdi, lelamang,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wene seekpa, Yesusti nen hailamsiogti, “Aghana a'un morina na sembe etne senelamnelom,” aro Yesusti haibahiog. Wene aro haibahiogpa, Petrusti samoro lelamogti, “Anna, Nuni Allahri samenag 'Pognun,' aro salag lero pibogne sunsunum uro, an 'Taulbahimendi, saelbamsululam,' aro wepto pogkeogne wamlam. Nuni Allahri an undo pogkeogne sembe, 'Kristus wamlam,' alamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wene seogpa, Yesusti iriklamsiogti, “Na sembe, 'Kristus, Allahri wepto poghol aogne wamla,' aro nimi nhonag babe lag phoro ambatsiseng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wene seogti, lelamekne neneag agha Yesusti alnibaogti, eldi yubu ka'ero neleptopnangag el amik seklebalulne sembe ambarelamsiog. Ambarelamsiogti, “Na imag agha 'Mog so'oag nimi tanun' aro yahinge wamnabog, Yahudi nimi maiknori wa'ebanukang. Na wa'eplamniik nimina, sikiniyabo Yahudi nimi sembe wenehirop nimiap, memnang Allah sembe pairopnang sikinipsaboap, Musari samenag mome tobog yubu ambatsiropnangapti wa'ebanukang. Wa'ebaniikti, ya'ag omnukang. Ya'ag omnukang aghana, ik wilindip sum nen samoro kamag tanun,” aro alniro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Eldi yubu ka'ero neleptopnang ambarelamsiogti, el seklero tebanepne sembe tognoban koma lag phoro ambatsiog. “Seklero tebanun,” aro ambatsiogpana, Petrusti Yesus sae kiliro kaeag sip pabiogti, “Undo lepseng kom,” aro wembaog. ");
INSERT INTO kkl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wene aro wembaogpa, Yesusti taongkom agha eldi yubu ka'ero neleptopnang yogne kembamsiog. Kembamsiogti, Yesusti Petrusag samoro wenelamogti, “Phia yubu leplam. An Na wailag sip pi! Andi leplamnena, Allahri seneropne kom. Nimiri seneropne agha leplam,” aro wembaog. ");
INSERT INTO kkl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wene aro wembaogti, Yesusti nimi maikno wamekne tanekoap eldi yubu ka'ero neleptopnangap “Yahut,” aro yopsiog. Yopsiogti, sinag yubu ambarelamsiogti, “Nimi etneri, 'Na Yesusag nelepto nhon palamnunam,' senelamle tanena, mo neleplamnelul kom. Eldi wanaag agha seneragtopne lipseleri, Allahri senenne sunsunum uro seneraglamle tanena, hae nanag neleplamnelul. Nimi enekori, 'Yesusag nelebel pinun,' senelamle tanena, eldi wanaag agha, 'Nimiri na yubu nepto kalag sipto ya'ag omneika babe, khaepto Yesusag neleplamnun,' senelamle taneogna, neleplamnelul. ");
INSERT INTO kkl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nimi etneri, 'Na wali wamnange eka'uk taneleagti, Yesusag nelebel pinun kom,' senelamle tanena, Allahri nimi eneko ya'ag kamag nembalul kom. Aghana nimi etneri na Yesus sembe seneraglamneleri, 'Allahri yubu walinge salag pibogne sunsunum uro Yesus sik uro wepto poghog. Ane sembe na wali wamnepne sae limneri, Yesusag nelebel pinun,' aro seneraglamle tanena, Allahri nimi eneko sembe ya'ag kamag nembalul. ");
INSERT INTO kkl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Kamag uro unne nene nia mangkina agha kamna kapto lumbanep te? Nia mangkina mog so'oag wamlange nimiag tahoba, tebale sumeneko Allah ya'ag kamag uro unne elag tale kom tanena, el tupne wamla sembanep kom. ");
INSERT INTO kkl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wene wamang nimi tanekori Allah lai agha mali-malia maikno ulamang. Nimi etneri mog so'oag nimi whingag logti aliri, 'Yesusap ma'aptaukap kom,' sele tanena, Nari babe nimi eneko sembe, 'Elna nari nimi kom,' senun. Na imag agha mog so'oag nimi tahinge, amik samoro yalamne sumeneko, Allah Eldamneri arukna imagnang malaikatap yanun. Nani Allahringe imang warero libango aropne nanag wamleba yanun. Yalamne sumeneko nimi etne aliri nanap ma'aptangtop kom tanena, na amik yane sumeneko babe, nimi eneko Nani Allah whingag wamleba, 'Nari nimi kom,' senun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Seogti, nen tipto yubu lelamogti, “A'un tane wamlom nimi sikne agha ambarelamsin. A'un tane sekamlom nimi anabiag agha nimi nhon-nhon anam teban komag, Allahri mog so'oag nimi maikno saelbamsilulne lag taleba, iplulom. Allahri mog so'oag nimi saelbamsilulne nenena, Eldamneri mikipneag agha lag nembaleba, anam teban komag a'un anabiag agha nimi nhon-nhondi iplulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Wene seogpa, ik no'opbare wameka, Yesusti Petrusap Yakobusap Yohanesap enero poa yim wenge nhonag waelbaekti, sin tombare mo wamek. Mo wamekpa, sikin whingag agha Yesus nong a'eropne taogpa, eldi ag wangkamogne haing omomne kororo yame warebaog. Eldi ag kororo warebaogne nenena, nimi mog so'oag nimiri ag a'elbanepne sunsunum wamog komdi, haing omomne kororo warebaog. ");
INSERT INTO kkl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kororo warebaogpa, ilipsabori tilamekpa, Yesusap nimi phendeap yubu lelameka ipsiek. Yesusap yubu lelamdek nimi abeneko ipsieknena, sikinisagyabo Allah yubu silimu tiptopnang Eliaap Musaap Allahri nen samoro payahiogpa, Yesusap yubu lelamekpa ipsiek. ");
INSERT INTO kkl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Yubu lelameka ipsiekti, Petrusap, Yakobusap, Yohanesap sin wanaag lo'om seekti, logti Petrusti, “Sa'a senep,” sembaog. “Sa'a senep,” aro Yesusag yubu lelamogti, “Nai, amohiropne wamlamne! Nu tane wamapnena wali. Ane sembe ae wilindi soro kaluna kaulbaukap. An sembe nhon, Musa sembe nhon, Elia sembe nhon sobatsukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wene seogpa, toa yaogti lililamsiog pere agha, Allahri imag agha yubu lelamogti, “Anena Na Name, wanaag wamnelne. Eldi yubu ka'eamlulom,” alamogha ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wene seog abeneko pere, kanero kemelamekag agha Eliaap Musaap nen tognop tarekpa, ot Yesus agha sinap nhon wameka ibek. ");
INSERT INTO kkl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Undo unuaogpa, Yesusap el neleptopnang wilindi abenekoap yimag agha kuluklamekti, Yesusti irikto yubu ambarelamsiogti, “A'undi yimag agha wene iplomne sembe nimi nhonag babe ambatsiseng kom. Na imag agha mog so'oag nimi tahiri, wamna aghana, amik tebaneri, nimi teptopne anabiag agha nen samoro kamag tanun. Kamag tanun sumeneko tale taneogna, a'undi wene iplomne sembe nimi ambatsululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wene seogpa, Yesusti yubu ka'ebaekne sunsunum uro nimi ambatsiek kom. Nimi ambatsiek kom aghana sin mamun hail talamekti, “Sa'a sembe Yesusti, 'Imag agha mog so'oag nimi tahinge amik nimi teptopne anabiag agha kamag tanun,' sel?” aro yubu hail talamek. ");
INSERT INTO kkl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sikin mamun yubu hail talamekti, Yesusag babe hailamekti, “Musari samenag mome tobogne ambatsiropnangdi ambarelamsiangnena, 'Allahri weptopne “Mog so'oag nimi saelbamsululam,” aro poglenge yalul. Aghana el anam yan komag, Elia sam yaleba, Allahri wepto poglenge amik yalul,' aro ambarelamsiang. Sa'a sembe sindi undo ambarelamsiang?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Wene aro haibaekpa, Yesusti samoro ambarelamsiogti, “Allahri wepto pogtopne anam yan komag, Elia ponekori sam yingkina, 'Allahri wepto poglenge poneko yanepne sembe ina yarebanun,' aro nia mangkina welingkirop. Ane sik uro ambarelamsiang. Aghana nari a'unag ambarelamsinne, Elia poneko nousap yaoba, nimiri el sembe karongdi, 'Malia uaukap,' senenne sunsunum uro ni uaong. Sikindi elag malia uaongne sembe anam uro yabin komag Allahri sam el wamogti, Eldi yubu mome toro pairopnangag ambatsiogha sunsunum uro mome toro pibeka wamla. Aghana tamna undo. Sindi Allah yubu tipto samenag mome toro pibek nangdi, 'Imag agha mog so'oag nimi talenge ponekona, nimiri wa'eplamikpa, seklebalul,' aro mome toro pibek. Wali uro seneraglapmundi, 'Sa'a sembe mome ane toro pibek?' aro seneraglamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wene seogpa, Yesusap elkabo wilindi abenekoap nen samoro yimag agha kulukul alamekti, eldi yubu ka'ero neleptopnang yogne wamekag yaek. Yalamekti, kemelamsiekpa, nimi maikno longolaeka nusamag Musari mome toro pibog yubu ambatsiropnang etpareri Yesusti yubu ka'ero neleptopnang yogne aneko toraptangto lel talamekpa, ipsiek. ");
INSERT INTO kkl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ipsiekti yalamekpa, nimi longkamek nimi tanekori Yesus tibogaekti, “El yalamla,” aro awi maikno senelamekneag agha merero utol piek. ");
INSERT INTO kkl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Utol piekpa, Yesusti sinag hailamsiogti, “Sa'a sembe tam nenero yubu lel talamlom?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wene aro haibahiogpa, nimi longolaekne anabiag agha nimi nhondi samoro ambarelamogti, “Nai, amohiropne wamlam. Nari me anag poa yanne, 'Wali nembalulam,' aro payan. Phia yonge el kulomag wa'iogti, yubu kom nembaog. ");
INSERT INTO kkl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Phia yonge nenekori elag ulamlange, yamoro eplamlari, so'oag oro manalamla. Manalamlaba, me eneko si kelengtepto si ka'en toman kamola makel alamlari, nong ni kikiplamla. Ane sembe, payandi andi yubu ka'ero neleptopnangag 'Wali nembatnululom,' aro molbahin aghana, sumbangba eraruk tina, wali nembanep kom saog wamla,” aro Yesusag ambarog. ");
INSERT INTO kkl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wene aro ambarogpa, Yesusti sinag yubu lelamogti, “Eh, a'un nanag sikne aro seneraglamlom kom nimi. Na ko'o ik etbare a'un anabiag wamneri, 'Nanag sikne aro seneraglamseng,' aro wana palingkina wamnep? Me ane payahut,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Seogpa, me aneko Yesusag payaek. Payaekpa, phia yonge aneko Yesus ililamog abeneko pere, me anekoag uloghognena, konkonoro so'oag mambirogpa, so'oag pemaglamogti, si ka'en toman kamola makel alamog. ");
INSERT INTO kkl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Si ka'en toman makel alamogpa, Yesusti iliag hailamogti, “Etsuma phia yonge el kulomag wa'iori ulamla,” aro haibaog. Haibaogpa, ili ponekori samoro ambarelamogti, “El olog wamoghag agha wa'iogti, phia yonge nenekori 'Omnun,' aro ik nhon-nhon aukag wepto talamlori, ik nhon-nhon babe maghag wepto talamlo. Nu sembe yareag sembahisomdi, yepsisom. Andi el wali nembanep to, kom to?” aro Yesusag molbaog. ");
INSERT INTO kkl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wene aro molbaogpa, Yesusti samoro ambarelamogti, “Sa'a sembe andi nanag, 'Yepsinep to, kom to,' aro haibanelam? Andi nanag seneragto, 'Allah mikipneri el pere agha sik uro ulamla,' aro nanag seneraglamnemen tanena, andi sa'a-sa'a nanag molbanemenne sunsunum uro uro yabinep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesusti wene seog abeneko pere, me eneko ili ponekori yubu haum aro lelamogti, “Nari anag sik semban aghana, wana phende taneleagti, yepnemen andarina nari nubu uro anag 'Sikne' aro seneraglamnun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Seogpa, Yesusti kemelamsiogpa, nimi maikno merero longol aek. Merero longolameka kembamsiogti, Yesusti phia yonge nenekoag aruklamogti, “An phiari me aneag pam lepto ao leplamlamne, nari anag 'Lambae!' aro yaglangken. Me eneag agha lambamendi, nen samoro wa'al alulam kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wene “Lambae” seogpa, phia yonge me eneko kulomag wamogha haum aro lanalamogti, me eneko nong lolog murulamog pere agha lambaog. Lambaogpa, me eneko tebalo nimi saog uaogpa, nimi maikno tanekori, “Ya'ag loba tal,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","“Loba tal,” alamek aghana, Yesusti me eneko sae salero toro sekirogpa, me aneko sekog. ");
INSERT INTO kkl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Me eneko wali taogti, sekogpa, Yesus eldi yubu ka'ero neleptopnangap ae lomag wa'ina, mo wamek. Sin Yesusap nhon mo wamekti, Yesusag hailamekti, “Nai, sa'a sembe nuri phia nimi kulomag ua ulamsilne neneko nuri yaglambahinep kom?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wene aro haibaekpa, Yesusti samoro ambarelamsiogti, “Phia yonge nene saogne yag lambahinepnena, mo yubuag agha, 'Lambae,' arop tanena, yaglambanep kom. Ot Nuni Allahag molona mololapmunba, Allahri ka'ebom agha wali sele taneogna, El mikipne pere agha yag lambahinep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Seogti, Yesusap eldi yubu ka'ero neleptopnangap mog so'o aneko laplobi agha mog so'o Galilea phiro piek. Palamekti Yesusti senelamogti, “Nari yubu ka'ero neleptopnangap mo wameberi, ot sin aghabog el nenero ambarelamsinun. Ane sembe nu tane wamapne sembe nimiri el taikag,” aro lag palamek kom. Yesusti eldi yubu ka'ero neleptopnang ambarelamsiogti, “Na imag agha mog so'oag nimi tahinge aghana, nimi nhondi na aisanang saeag nenero pankhebanelul. Pankhebaneleba, ya'ag omneik aghana, wilindip sum nen samoro kamag tanun,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesusti wene aro ambatsiogpa, yubu neneko sindi wali uro seneraghek kom aghana logti, elag haibaek kom. ");
INSERT INTO kkl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sin mog so'o Galilea palamekti, as Kapernaum yaek. Yaekti, aeag wa'iekti, Yesusti eldi yubu ka'ero neleptopnangag hailamsiogti, “Usa inaag yalamap abeneko tam huropne sembe yubu leple yalamlom?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wene aro haibahiogpa, samoro yubu lebek kom. Elag samoro ambarek komnena, inaag yalamekti, sin mamun “Nun anabiag agha etne agha nubunge?” aro yubu lep tang-tang yalamek. Ane sembe aliri, yubu lebek kom. ");
INSERT INTO kkl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ambarek komba, Yesus pukogti, eldi yubu ka'ero neleptopnang aobare aneko yopsiog. Yopsiogti, yubu ambarelamsiogti, “Nimi etneri, 'Na Allah whingag nubunge tanun,' senelamle tanena, nimi enekori, 'Whingagne tanun,' seneropne laipsileba, wana mamleba, nimi ni yeplamsile taneogna, Allah whingag nubu tanep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wene seogti me ologne nhon tobogti, sin anabiag piamogti, somoro saelbamog. Somoro saelbamogti, yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nimi etneri nanag sikne aro seneragtopne sembe me ologne nene saog nimi toro kipto piple tanena, nimi enekori na babe toro kipto pimneloa saog ulamlul. Na toro kipnelul nimi eneko na mo kiplul kom aghana, na kipnelenge pere agha na pogneogne poneko, Nani Allah babe kiplul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wene seogpa, Yohanesti Yesusag yubu lelamogti, “Nai, amohiropne wamlam! Nuri kemelamoboba, nunap nhon yabalamap kom nimiri an si lero phia yonge yaglamsioba ibobo. Ibobo aghana, nimi aneko nuri anag neleplangkeap saog uro anag sop nelepto yabalamla kom. Ane sembe, 'Yesus si lero phia yaglambahiseng kom,' aro irikabo,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Wene seog aghana Yesusti, “Nimi nhondi na si lero nanag sikne aro seneraglamlangeag agha kekneba ulamleri, 'Allahri mikipne el pere agha ulamla,' senenne kekneba wene uale tanena, nimi enekori na san tilibanep kom. Ane sembe nanag seneragto na si lero kekneba ulamle nimi irikahiseng kom. Nimi etneri nu aisa nembahile kom tanena, nimi eneko nungkae wamlari, na san tilibanelul kom. ");
INSERT INTO kkl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tam nene sembe sikne agha lemnuan. Nimi etneri a'un sembe, 'Allahri wepto poghogne Kristus poneko ma'aptangtop nimi wamlombana, a'un yepsisene,' sembaleri, a'un yepto mag babe tebarelamsile tanena, Allahri nimi eneko sembe ekon tan koma kamna tatlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wene seogti, Yesusti sunumna yubu etpare nen lelamogti, “A'undi usa 'Etne nubunge,' aro leptalom aghana, sin olog nimi agha nanag sikne aro seneraglamneangne nenena wali. Wali aghana, olog nimiri nanag seneraglamneangpog, nimiri sindi wana toro na wail ibukang agha ekel ina toman pabihiik tanena, Allahri sin pabihirop nimi enekoag tam ikinne pipsilul. Olog nimi pabihirop nimi eneko ngangag kirik ikinne kerekto mag longorop mag nubunge lautag talobol pinepne ane olog keyagman saog. Allahri elag ikinne piplulne aghabog ikin sirik. ");
INSERT INTO kkl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","A'undi wanaag agha seneraglapmundi, 'Sae tarari malia uahane,' sembamun tanena, 'Mali-malia uaneag aro sae aneko karepto tobogahane,' aro wanaag seneraglamlulom. 'Nelagha wali?' aro seneragsut! Sae ni phende wamsoba, mali-malia ulapmenne sembe Allahri tam ikinne anag pelengero, ebek sop-sop mahan ektobag auk nubunge sarangtop komag an tobogagheho tanena, wali sembahom to, kom to? Sae tara karepto toboghahom andarina, mali-malia uan koma Allah ua urobag kamag wamsom, taneogna wali. ");
INSERT INTO kkl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","A'undi wanaag agha seneraglapmundi, 'Yan tarari malia uahane,' sembamun tanena, 'Mali-malia uaneag aro yan aneko karepto tobogahane,' aro wanaag seneraglamlulom. 'Nelagha wali?' aro seneragsut! Ni yan mamun wamsoba, mali-malia ulapmenne sembe Allahri tam ikinne anag pelengero, ebek sop-sop mahan ektobag auk nubunge sarangtop komag an tobogagheho tanena, wali sembahom to, kom to? Yan tara karepto toboghahom andarina, mali-malia uan koma Allah ua urobag kamag wamsom, taneogna wali. ");
INSERT INTO kkl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","A'undi wanaag agha seneraglapmundi, 'Haing tarari kembi agha malia uahane,' sembamun tanena, 'Mali-malia uaneag aro haing aneko kwhero tobogahane,' aro wanaag seneraglamlulom. 'Nelagha wali?' aro seneragsut! Mali-malia uan koma haing tara kwhero toboghahomne agha, Allahri wali saelba uhiropne poneko umag ya'ag kamag wapmun, taneogna wali. Kombagha, haing ni phende wamsoba, mali-malia ulapmunne sembe Allahri tam ikinne a'unag pelengero a'un tobogahileba, ebek teban komag sop-sop mahan ektobag auk nubunge sarangtop komag ya'ag wapmunagti. ");
INSERT INTO kkl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nimiri garam yamolamloa saogne nimi niag auk kulukulalul. ");
INSERT INTO kkl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Garam nenena sao wali aghana, emem arop kom tale tanena nimiri nen samoro garam sao wali nembanep komdi, teba'an sembanep. Ane saog uro, a'un mamun ma'aptangto wapmunneag agha garam sao walinge yamolamloa saog ulapmundi, waptan koma wali wamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wene seogti, Yesus as Kapernaum laplobi agha mag Yordan kauro mog so'o heng walelingkirobag sip phibom agha mog so'o Yudea piog. Piogpa, nimi maikno mog anekoag wamek nimi Yesus peram longowarekaek. Longowarekaekpa, yog sum ambarelamsiog saog uro nimi tanekoag babe Allah yubu ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ambarelamsiogpa Farisi nimi “Yesus mibukap,” aro yaekti hailamekti, “Meo! Nunisag Musari samen mome toro pibog yubu sunsunum uro, nengabori elkel toamna agha keleneko lipso tanena, hae te?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Haibaekpa, Yesusti “Ambatsinun,” aro samoro hailamsiogti, “Musari samenag, 'Undo-undo unulamlulom,' aro mome tobog yubuag tam nene sembe sa'a seog?” aro Yesusti tangoro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wene aro Yesusti haibahaiogpa sindina, “Musari mome toro pibogne sunsunum uro nimi nhondi, 'Nari kel limnun,' sembaho tanena hae limnep. Ot anam limna komag mome nhon, 'Sumene nari kel ene limna,' arop mome kekneba topsori, kekneba aneko kelenekoag tatso abeneogna, eldi kel eneko limnep,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Seekpa, Yesusti nen lelamogti, “Sik, Musari undo mome tobog aghana, a'unag Nuni Allahri seneropne sembe wana hekamsin koma wamlom. Ane sembe Musari a'unisagyaboag, 'Mome kekneba topsori, elkelag tatsori limnep,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Undo mome toro pibog aghana, anamag Allahri nia mangkina sumbaog sumeneko kaubuniap kelaboap sumbahiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ane sembe nengabori iliap ilinap lilobi agha, ela'angeap elkelap toptarikti, ma'aptangkamtukang. ");
INSERT INTO kkl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sin abeneko nong nhonog saog neneptangtop. Sin abeneko nong phende kom, aghana nong nhonog neneptangtop. ");
INSERT INTO kkl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Allahri ela'angeap elkelap abeneko agha nong nhonog nenero ma'abahiog, ane sembe nimi nhondi babe ela'angeap elkelap a'eptaheng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wene seogti, sikin aeag wa'iekti, Yesus yubu ka'ero neleptopnangdi elag hailamekti, “Yubu nenekona sa'a sembe ambatsilam?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Haibaekpa, Yesusti sinag ambarelamsiogti, “Nimiri kelabo samenne laplobi agha wendogne toltolamle tanena, kelabo samenne wana mali nenero kelabo pelepto tohiropne saog uro ulamla. ");
INSERT INTO kkl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kelabori babe ela'ange samenne laplobi agha nimi kabuni nhonag wa'alamle tanena, kelabori nengabo pelepto tohiropne saog uro wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wamekpa, ik nhon sum nimiri me ologne Yesusag payalamsiek. Payalamsiekti Yesusag mololamekti, “Andi nuri mabo usog alibag sae pipmendi, Allahag molbatsimenba, nuri mabo wali wamukang,” aro moloro payalamsiek. Aghana Yesus yubu ka'ero neleptopnangdi nimi tanekoag, “Payahiseng kom,” aro nimi taneko wabahiek. ");
INSERT INTO kkl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","“Payahiseng kom,” aro el neleptopnangdi nimi walamsiekne Yesusti ipsiogti, el neleptopnang walamsiogti, “Me tane Nanag wali yaukang. A'undi irikahiseng kom. Nuni Allahri sin babe piamsildi, saelbamsil. ");
INSERT INTO kkl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nari a'unag sik uro lelamnange, olog mabori nong nimiag wana palilamang saog uro nimi etneri Allahag 'Sik uro piamsildi, saelbamsil,' aro seneraglamle tanena, Allah elme talul. Aghana nimi etneri me taneko saog uro Allahag 'Sikne' aro seneraglamle kom tanena, Allah elme tanep kom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wene seogti me ologne taneko somoro saelbahiogti, me ologne taneko usoghag sae piamsiogti, “Wali wamukang,” aro molona Allahag molbatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sae pipsiogti Yesus inaag palamogpa, nimi nhon merero Yesusag yaog. Nimi eneko yaogti Yesus whingag yabu sanukto pulingkina, “Nani, an yubu ambatsiropne walinge wamlam! Yubu ambatnululam! Nari hulamnengeag agha ya'ag kamag uro unne nanag talul?” aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wene aro molbaogpa Yesusti, “Nanag 'walinge' selamnena, nimi mog so'oagne nhon babe walinge wamla kom. Ot Allah mo aghabog walinge wamla. Andi sa'a sembe nanag walinge selam?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wene seogti Yesusti nen tipto yubu ambarelamogti, “Allahri Musa pere agha aruksirop yubu ambatsiogne an el wamlam. Nimi ya'ag opsiseng kom. Nengabo kelabo toptangkamna komag nikag mapseng kom. Nimiringe haoghaba topseng kom. 'Nimiri unulamoba imno,' aro yubu orolena lepseng kom. 'Nimiringe sembe naringe taho,' aro haing kunulamsiseng kom. A'uni a'unindi yubu ka'ero kiplamsululom. Ni ane Allahri samenag ambarogpa, Musari tipto ambatsiogpa, ka'elamapne an babe el wamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yesusti wene seogpa nimi enekori, “Nai, yubu ambatsiropne, ni leplamne abenena na olog wamsiag agha saelbamsia kekman wene babe saelbamnari ulamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nimi enekori wene seogpa, Yesusti o'ona senero kembaogti, “Ot nhonog andi ulamlam komne nhon wamla. Pimendi andi saeag agha ni wamlange nimiag kamna kapto topmendi, kamna tatkeikne nimi saeag agha orogne tatsululam. Tatsimen tanena, samoro nanag yamendi, nanag yubu ka'ero neleplamnululam. Undo tatsimen tanena, Allah imagne ponekori kamna ya'ag kamag uro unne anag tatkelul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesusti wene seogpa, nimi enekori ka'ebaogti, “Nanenge saeag agha maikno wamlaba, huro uanun,” aro wana ikin taogpa piog. ");
INSERT INTO kkl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Piogpa Yesusti el yubu ka'ero neleptopnang keme warekahiogti, “Allahri na wepto poghol aneog aghana, nimi saeag agha tup uro urop nimiri elsaeag uropne lipsisori, nanag nelepto 'Saelbamnululam,' aro ulamlenge eka'uk sirik,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wene seogpa, el yubu ka'ero neleptopnang ka'ebaekti, yaghe sembaek. Yaghe sembaek aghana, Yesusti nen tipto ambarelamsiogti, “Mabo, Allahri na wepto poghol aneog aghana, nimiri eldamne wanaag agha nanag nelepto 'Saelbamnululam' aro mo uanep kom saog wamla. Mog so'oag nimi sembe tam nene ikin sirik. ");
INSERT INTO kkl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pham unta nhon imisti phoroba lom toman wa'ana eka'ukti, wa'inep kom saog. Wa'inep kom saog aghana, olog hae sembanep. Ot tup nimina, Allahri 'Saelbamsululam,' aro wepto pogtopne poneko sembe tup nimiri, 'El umag wamnun,' sembanep kom saog wamla. Pham unta imisti phoroba lom toman wa'ana hae, eka'uk kom sembanep. Ot tupne Allahri saelba uhirobag wa'inne eka'uk sirik wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesusti wene seogne sembe eldi yubu ka'ero neleptopnang lo'om paibon seekti, sin mamun hail talamekti, “Undop tanena, Allahri nimi etne agha 'Ya'ag kamag uro wamukang,' aro taluro saelbahinep?” seek. ");
INSERT INTO kkl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wene seekpa, Yesusti sin kembahiogti lelamogti, “Nimiri wanaag agha uro yabinep kom aghana, ot Allahri yepsinneag agha uro yabinep. Nia mangkina Allahri 'Uanun,' senenne sunsunum uro ualeba, uro yabinep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wene seogpa Petrusti, “Nu kembahimen! Nuringe nia mangkina ni lipsibori, anag neleplangkeap,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Wene seogpa Yesusti, “Nari a'unag sikne agha lelamnange, nimi etneri na Yesusag nelepto 'Allah yubu walinge ambarelamsunun,' aro eldinge ae, eldi eldo ilipsae, eldi eldo'el ilipsa'el, eldi ili ilin, eldi elmabo elenge awe, nimi enekori laplopsilenge sembe wene wamap ko'oeneag Allahri lunuro nen ma'aro maiknoro phekletopneap tatlul. Nia mangkina laploplenge sembe tatleba, elag talulnena, nimiri aeap, eldi eldoyabo ilipsaboap, eldi eldo'elabo ilipsa'elaboap, eldi iliyabo ilinaboap, eldi elmaboap, elenge awe babe wene wamap ko'oeneag elag talul. Nen nhonna, ora nimiri el sembe, 'Yesus neleptop nimi seklebaukang,' aro olamsiikpa, seklenne babe elag talul. Aghana amik yalamle ko'oag Allahri ya'ag kamag uro unne neneko tatsilul. ");
INSERT INTO kkl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Abene agha amik yalamle sumeneko nimi nubunge wene wamang nimi agha, nimi maikno ologne taukang. Nimi ologne wene wamang nimi agha, nimi maikno amik nubunge taukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wamekpa Yesus el yubu ka'ero neleptopnangap, “Yerusalem waelbukap,” aro palamekti, Yesus samenag menangal piogpa palamek. Yesus samenag menangal piogpa, as Yerusalem palamekti, Yesus el yubu ka'ero neleptopnang tanekori senelamekti, “Yerusalem nimiri el obukang to kom to,” aro yaghe sembaek. Ora nimi Yesusag neleplamek nimi babe log tahiog. Samen uaog saog uro, nen babe Yesusti el yubu ka'ero neleptopnang aobare nang eneko yopsiogti, Yesusti elag uro yabinepne sembe nen alniro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ambarelamsiogti, “Ka'eamlulom! Nu wene Yerusalem sip palamap. Yerusalem wamebea na mog so'oag nimi tahinge sembe nimiri pangkhebanelul. Pangkhebanelenge, sin Allah sembe pairopnang sikindoyaboap Musari samenag mome toro pibog yubu ambatsiropnangap sikin saeag nenero pangkhebanelul. Sin Allah sembe pairopnangap Musa yubu ambatsiropnangap abenekori na sembe 'Ya'ag tebalul,' aro tam karepto pibikti, nimi sisa Yahudi kom nimi saeag nembanukang. ");
INSERT INTO kkl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sindi saeag nembaneikpa, nimi sisa Yahudi kom nimiri nanag yubu neplamneikti, sulu mag suplamneikti, taeplam-taeplam lopneikti, ya'ag omnukang. Ya'ag omneikpa, olog wamneri, ik wilindip sumeneko nen kamag tanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wene seogpa, Zebedeus elmabo Yakobusap Yohanesapti Yesusag yarekti, “Nai, nu yubu ambatsiropne wamlam. Nuri 'Andi nu sembe uahom,' senelamnamne olog ambatkenemeba, nu sembe ualulam, te?” aro haibarek. ");
INSERT INTO kkl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wene serekpa Yesusti, “A'undi sa'a agha, 'Nu sembe undo-undo uatsulul,' senelamdom?” aro Yesusti sin haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yesusti wene aro sinag haibahiogpa sindi, “Andi 'Nimi so'oag nimi ni saelbahinun,' aro pukapmenba, an sembe kibiang towalengerop sumeneko, andi nun phende abenekoag, 'Nhon sae sirik sip pulae, nhon sae waneng sip pulae,' semenba nu anap nhondi saelbamsukap senelamnam,” serek. ");
INSERT INTO kkl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wene serekpa Yesusti, “A'undi molbaneromne ekonne agha molbanerom. Na seklebanun saog uro a'un babe na nelepto seklebanep to, kom to? Na tebanun saog uro a'un babe na nelepto tebanep to, kom to?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Haibahiogpa, sindina, “Nuri babe unuanunam,” serek. Wene serekpa, Yesusti, “A'unna, nari seklero tebanunne saog uro seklebarurom. ");
INSERT INTO kkl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aghana a'un sembe, 'Nhon na sae sirik sip, nhon na sae waneng sip pularurom,' aro ambatsinun kom. Ot Nuni Allah Eldi wanaag agha na sae sirik sipap, sae waneng sipap puka urobag o'obaori, tatsilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wene aro molbarekpa, Yesus el yubu ka'ero neleptopnang yogne sa'obare nang tanekori ka'ebaekti, Yakobusap Yohanesap alniro wabahiek. ");
INSERT INTO kkl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Walamsiekpa Yesusti “A'un ni abene yahut,” aro yopsiogti ambarelamsiogti, “Nimi sisa Yahudi kom nimi Allah yubu ekon nimi tala-tala wamang nimi sembe saelba uhiropnangdi nimi luknuhiro salelamsiang. Sin anabiag agha sikiniyabori yo uro mikipne agha ulamsiang. Tam nene a'un el wamlom. ");
INSERT INTO kkl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Unulamang aghana a'undi unuaheng kom! Nimi etneri a'un nusamag wamlomne, 'Na nubunge tanun,' sembale tanena, amik nimi yepsinne agha talul. ");
INSERT INTO kkl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nimi etneri na samenagne tanun sembale tanena, nimi ni sembe arukna talul. ");
INSERT INTO kkl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na mog so'oag nimi tahi aghana, nandamne yepnukang aro so'oag yahi kom. Nimi yepsinun aro yahi. Yahingena, mog so'oag nimi niri mali-malia ulamangpa, Nuni Allahri opsinep. Aghana 'Mog so'oag nimi anabiag agha nimi maiknori malia uroba sembe lunuro tebaneba, sikin ya'ag kamag uro wamukang,' aro yahi,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yerusalem inaag palamekti, as Yerikho yaek. Yaekti, Yesusap el yubu ka'ero neleptopnangap as Yerikho phibom agha lanalamekpa, as aneko nimi maikno babe el nelepto nhon palamek. Palamekpa, nimi haing uropne nhon ina abolag puka kal ma'al mololamsiog. Mololamsiogne poneko sina Bartimeus ponekori mololamsiog. ");
INSERT INTO kkl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Moloro pukamogti ka'elamogpa, “Yesus Nazaretne poneko palogla,” alameka ka'ebaog. Ka'ebaogti, Bartimeus ponekori yubu nubu uro yoplamogti, “Yesus Daud elme, na o'ona sembane,” aro yoplamog. ");
INSERT INTO kkl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yoplamoghag agha nimi maikno tanekori, “Yubu kom tae,” aro walamekpog, el nen ma'aro mikip uro haum aro, “Daud elme, na o'ona sembane,” aro yubu lelamog. ");
INSERT INTO kkl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wene alamogpa, Yesusti ka'ebaogti sekelabiogti, “El Yoplulom,” seog. “Yoplulom,” seogpa nimi tanekori haing urop nimi eneko yopto ambarelamekti, “Yesusti yoplangkelba, awi uro wamlulam! Sekelabi,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wene aro ambarekpa, haing urop nimi Bartimeus nimi enekori ag alibagne kwiripto tobogahiogti elemag-elemag sekom agha Yesusag piog. ");
INSERT INTO kkl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Piogpa Yesusti Bartimeusag yubu lelamogti, “Andi yopnelamnena, 'Yesusti nanag sa'a agha uanoho,' sembamlamdi yopnelam?” aro haibaog. Wene aro haibaogpa Bartimeus haing uropne ponekori, “Nai, yubu ambarelamsilamne, nari 'Haing ene kwelekanoho,' sembamnari yopken,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wene seogpa Yesusti, “Andi Nanag wana saingniro seneragto wana sepsebek aro 'Wali kwelek anelul,' sembalamne nene sembe, wali nembaghenuan. Hae, wali pululam,” seog. Yesusti wene seog abeneko pere haing aneko kwelekaogpa, nimi eneko Yesus ina palamoghag neleplamog. ");
INSERT INTO kkl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus el yubu ka'ero neleptopnangap as Yerusalem peramag palamekti, yim Zaitun tamag as Betfageap Betaniaap piek. Piekti, Yesusti el yubu ka'ero neleptopnang phende pogto ");
INSERT INTO kkl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aruklamsiogti, “A'un whingag as aneag pururom. Purumundi, pham keledai yemne haing kobea kerektop pham nhon ipturom. Pham keledai aneko nimi anam pulingkirop kom pham kerektoba iptumundi, pham ane kobea lopto payarurom. ");
INSERT INTO kkl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nimiri a'unag, 'Sa'a sembe a'undi kobea loplamtom?' aro hailogsikpana, a'undi ambatsururomnena, 'Nuni nu saelba uhiropne poneko teko sel tagha kobea lopnamdi, pabalamnam. Usa nuniri, 'Samoro paburorom' sele tanena, nen pham ene elem uro yalul,' sururom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wene seogpa, el yubu ka'ero neleptopnang phende abeneko pirekti, pham keledai yemne aneko ae ina siram peramag kerekameka iptek. Iptekti, pham keledai yemne aneko kobea loplamdekpa, ");
INSERT INTO kkl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nimi taneko sekamek nimiri sinag hailamsiekti, “Sa'a sembe a'undi pham keledai ane loplamdom?” aro haibahiek. ");
INSERT INTO kkl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wene aro haibahiekpa, sikini Yesusti yubu ambatsiogha sunsunum uro ambatsirekpa, nimi tanekori, “Hae pabururom,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","“Pabururom,” seekpa, pham keledai yemne neneko Yesusag pabirekti, sikinenge ag nongag enektop ag kwiripto pham keledai alibag yangkaekpa, Yesus pham keledai alibag pulingkiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pulingkiogti, yalamog inaag aneko nimi tanekori, “Nimi nubunge yalamlaba, kibukap,” aro Yesus pinep ina yangalamek. Nimi nenneri sindi nongag enektop ag kwiripto inaag yangalamekpa, nenneri aweag agha kal ma'al kokto payingkina inaag yangalamek. ");
INSERT INTO kkl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ina yangaro palamekti, Yesus whingag sip palamek nimiap wailag sip agha neleplamsiek nimiap tanekori yubu mikip uro haum alamekti, “Nu Taluro Saelba Uhiropne kiplamsut! Nuni Allahri poglaba, yalamlange poneko paliag nenelamsut! ");
INSERT INTO kkl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nunisag Daud ponekori Israel nimi saelbamsiog saog uro amik yalamlange ponekori wali saelbamsilul. Im Paliagneri nu taluro saelbamsilne poneko omeklamsut!” seek. ");
INSERT INTO kkl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wene alamekpa, Yesus as soro kalurop as Yerusalem piogti, Allahri Mem Ae aramag wa'iogti, ni taneko wamogne keme warekaog. Keme warekaog aghana, inipna peram taogpa, el yubu ka'ero neleptopnang aobare nangap as Betania piek. ");
INSERT INTO kkl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","As Betania mabeka ae lukunap, “Yerusalem samoro pukap” aro as Betania lanaro palamekpa, Yesus kwaneng yo sembaog. ");
INSERT INTO kkl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kwaneng yo sembaogti, weag agha tilamogpa, kal ara kwarang saog kal eneko ma'al saroba tibogaog. Tibogaogti “Wana mauamla to kembanun,” aro piog. Piog aghana, kal ara wana maurop li kom ane sembe, kal wana orog wamogti, ot ma'al aghabog saroba wamog. ");
INSERT INTO kkl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma'al aghabog saroba wamogpa, Yesusti ibogti, kal ara kwarang saog kal enekoag Yesusti walamogti, “Sumene agha alniro andi wana mauroba nimi nhondi babe tukukang kom,” aro walamogha elag neleptopnangdi yubu tam ane ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus el yubu ka'ero neleplamek nimiap Yerusalem piekti, Yesus Allahri Mem Ae aramag wa'iog. Wa'iogti kemelamsiogpa, nimi maikno wa'ina pail alameknena, “Nimiri Allah sembe tatnepne yingkirop nimiri kamna kapto tobukang,” aro pail alamekpa, kamna kapto tolamek. Sindi kamna kapto tolamekne sembe Allahri Mem Ae salerop nimi tanekori seneraglamekti, “Nimi niri kal ma'al tane sunsunum komdi, nun Yahudi nimiri kal ma'al agha kamna kapto tolamukang,” senelamek. Ane sembe, sin sunsunum urop kal ma'al salerop nimi kwaria soroba peramag pukamekpa, nimiri kal ma'al tatto tol alamekti, kamna kapto tolamekpa, Yesusti ipsiog. Ipsiogti, kal ma'al tarel talamek nimi pukamekag Yesusti kwaria yamoro epsiog. Nimi mem winang payalamek nimi puka urobag babe Yesusti yamoro epsiogti, sin kamna kapto payalamek nimiap tolamek nimiap yag lambahiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yag lambahiogti, “Nimi nhondi babe Allahri Mem Ae aram toman kamna kapto toroba pailaheng kom,” aro irikahiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wene aro irikahiogti, Yesusti nimi tanekoag yubu ambarelamsiogti, “Samenag Allahri yubu lebogne nimiri mome toro pibogne undo: 'Nari ae anena, nimi ni tala-tala wamangneri, “Imagne Ponekoag molona molba urop ae,” aro engkukang,' seog. Aghana a'undi ulamlomneag agha 'Haoghaba toro nimi ohirop nimi tognop tangtobag' saog nembaom,” aro Yesusti wabahiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesusti wene seogpa, memnang Yahudi nimiri sae agha Allah sembe pairopnang sikiniyaboap, Musari samenag mome toro pibog yubu ambatsiropnangap tanekori ka'ebaek. Ka'ebaekti log senelamekti, “Yesus nenekori yubu ambarelamsilne ka'elamang nimi niri el sembe 'Mane agha ambarelamsil' aro yeng senelamang,” aro Yahudi nimi sembe nubu nangdi log senelamek. Log senelamek ane sembe sin wana yo tahiogpa, “Yesus welaro obukap?” aro ina elamek. ");
INSERT INTO kkl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Imbaogpa, Yesusap el yubu ka'ero neleptopnangap Yerusalem laploa piek. ");
INSERT INTO kkl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ae kwelekaogpa, lukunap Yerusalem samoro palamekti, Yesusti sam wabaog kal ara kwarang saog kal eneko tam toman kembi-kembi palamekti kemelamekpa, kal eneko yarengap ni ul taog. ");
INSERT INTO kkl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kal ul tangtoba Petrusti kembaogti, Yesusti kal ara wabaogha sembe seneraghogti, yubu lelamogti, “Nai, nu yubu amohinne wamlamne, kal ara ambuhum wabaom kal aneko ya'ag ul tal,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wene seogpa Yesusti, “Allahag wana saingniapmundi, 'Sikne' aro seneraglamlulom! ");
INSERT INTO kkl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","24","Nari a'un ambarelamsinne wali ka'ebalulom. A'undi Allahag mololapmundi, wana nhonog uro mololamlulom. A'undi Allahag mololapmunneag agha 'Sik uro yabilul,' aro mololapmun tanena, sik uro yabilul. Sunumna nhon ambatsinun. Nimi etneri wana phende seneragna koma eldi wanaag, 'Nuni Allahri sik ualul,' senenneag agha yim eneag aruklamleri, 'Ko'oro mag longorop mag laut nubungeag tobogholtal pi,' aro arukale tanena, sik uro yabilul. ");
INSERT INTO kkl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A'undi Nuni Allahag molona mololapmun aghana, a'undi wanaag ora nimi sembe wana mali sembamsimun tanena, nimi neneko sembe 'Malia uaneo,' sembamunne samenag orog nembamun taneogna, Allahag molona molbalulom. Tam orog nembamunne, 'Nani Allahri nari malia ulamnonge wailag nembalul,' aro ora nimiri a'unag malia ulamsiikne orog nenelapmun taneogna, Allahag molona mololamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aghana ora nimiri a'unag malia uropne sembe a'undi tam wailag nemban koma Allahag molona molbamun tanena, Nuni Allahri babe a'undi malia uropne wailag nembalul kom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wene aro ambatsiogti, tipto palamekti, Yerusalem samoro piek. Yerusalem samoro piekti, Yesus Allahri Mem Ae aram toman kemeroa yabalamogpa, memnang Allah sembe pairop nang sikini yaboap, Musari “Undo-undo unulamlulom,” aro mome toro pibog yubu ambatsirop nangap, Yahudi nimi sikiniyabo wenehirop nangap Yesusag hailaek. ");
INSERT INTO kkl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sikin yaekti Yesusag hailamekti, “Andi ulamlamne, etneri mikipne anag pibori, 'Unualulam,' aro pogkeoba, ulamlam?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wene aro haibaekpa Yesusti, “Nari babe a'unnag haibahinun. Haibahinenge sembe a'undiba lag phoro ambatnumun taneogna, nari babe, 'Etneri pogneoba, ulamna,' aro ambatsunun. ");
INSERT INTO kkl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A'undi wela senelamlom? Yohanes maghag pelengehiropne ponekori ulamongena, elna etneri poghoba, nimi maghag pelengelamsio senelamlom? Nimiri to, Allah Imagne Poneri to?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Haibahiogpa, sin mamun tognoro hailtalamekti, “Nuri elag samoro, 'Allahri Yohanes poghoba, yubu ambatto maghag pelengelamsio,' sebe tanena, Yesusti nunag haibahileri, 'Sa'a sembe Yohanesti yubu ambatsionge sembe sik sembaom kom?' seleag,” aro sin mamun yubu lelamek. ");
INSERT INTO kkl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sin nubunang tanekori Yohanesag sik sembaek kom aghana, yog nimi ni tanekori Yohanes sembe, “Nuni Allahri yubu silimu tiptopne wamo,” senelamek. Nimi maiknori undo senelamek ane sembe, sin nubunangdi Yesusag hailamek nimi tanekori, “'Nimiri Yohanes pogho,' sebeag,” aro nimi sembe log senelamek. ");
INSERT INTO kkl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nimi sembe log senelamekti, “Yohanes maghag pelengehiropne poghonge, etneri pogho nu ekon,” seek. Wene seekpa Yesusti, “Undop pagha tanena, nari babe a'unag, 'Eldi pogneoba ulamna,' aro phoro ambatsinun kom” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sin memnang Allah sembe pairopnang sikiniyaboap, Musari mome toro pibog yubu ambatsiropnangap, Yahudi nimi sembe sikiniyaboap tanekori, “Etneri Yohanes pogho nu ekon,” seekpa Yesusti samoro, “Undop pagha tanena, na pogneonge sembe babe ambatsinun kom,” seog. “Ambatsinun kom,” seog aghana, sunumna nhon alniro ambarelamsiogne ane. “Nimi nhondi awe wero haing anggur aweag mebog. Mebogti leka kanero tobogti, haing anggur wana mag loltero pelengenag wip nhon hoghaog. Wip nhon hoghaogti, yae ua unnang sembe ae mororo ae alikinag solingkiogti, awe yae ua unnangag 'Yae wamlulom,' seogti, laplobi agha weag sip piog. ");
INSERT INTO kkl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Piogti wamogha haing anggur wana tagtop li yaogpa, awe ngainge ponekori eldi aruknaag, 'Awe wero yae ua urop nangag na sembenge tol pululam,' aro poghog. ");
INSERT INTO kkl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Poghog aghana, awe wero yae ua urop nang tanekori eldi arukna aneko saelbaek. Salero olamekti, tatna koma 'Pululam,' seekpa, nongog mo yaog. ");
INSERT INTO kkl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nongog yaogpa, awe ngainge ponekori eldi arukna nen nhon poghog. Poghog aghana awe yae ua urop nang tanekori usoghag olamekti, yubu neplamekti, oro yaghekpa yaog. ");
INSERT INTO kkl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Usoghag obekpa yaogpa, awe ngainge ponekori eldi arukna wilindipne babe poghog aghana, nimi eneko ya'ag obek. Ya'ag obekpa, awe ngainge ponekori eldi arukna maikno poglamsiog aghana, nenne mulog olamsiekti, nenne ya'ag olamsiek. ");
INSERT INTO kkl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Undo olamsiekpa, wene etne agha awe ngainge ponekori pognep? Wene elme o'onange neneko ot nhonog wamla. Undop aghana, elme neneko babe awe yae ua urop nang tanekoag poghog. Awe ngainge ponekori, 'Awe ngainge elme yal sembaikti kiplamikti, elagna pogto tarukang,' aro elme poghog. ");
INSERT INTO kkl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","8","Poghog aghana, awe yae ua urop nimi tanekori, 'Awe ngainge elme, el amik awe ngai tanepne wene ane yalamla. Obeberi nun agha awe ngainang taukap,' seekti saelbaekti ya'ag obek. Obekti nimi teptoba aneko awe sirikag toboglopsiek,” aro Yesusti sunumna ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sunumna ane wene aro ambatsiogti hailamsiogti, “Awe ngainge poneko yaleri awe yae ua urop nimi tanekoag huahilul? Yaleri awe yae urop nimi taneko luknuro ya'ag opsileri, awe aneko yog nimiag 'Welamlulom,' aro nimi saeag piplul. ");
INSERT INTO kkl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Allah yubu samenag mome toro pibogneag kemelamlom aghana, ekon taom te? 'Ae sorop nangdi kirik nene mali aro toboghaek aghana kirik neneko yangan kirik o'omne yangap tao. ");
INSERT INTO kkl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yangan kirik o'omne nembaonge Allah mori uaoba, nuri awi sirik uro kemelamap,' aro mome toro pibog,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sunumna nene wene aro ambatsiogpa, Yahudi nimi sikiniyaboap, Musari mome toro pibog yubu ambatsirop nangap, memnang Allah sembe pairopnangap tanekori ka'ebaek. Ka'ebaekti sindi karong senelamekti, “Nunag 'Undo-undo malia ulamlom,' aro yubu likipto lepla,” sembaekneag agha, “Welaro el salero haing sae kaubaukap?” aro ulamek. “Saelbaukap,” aro ulamek aghana, sindi “Nimi maikno tanekori nu wabhiikag,” aro logti, saelban koma Yesus liloa piek. ");
INSERT INTO kkl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wamekpa, Yahudinang sikiniyabori Farisi nimi etpareap, nimi nubunge Herodesag neleptop nimi etpareap, “Yesusag pimundi, monag aluktop yubu haibamunba, Yesusti yubu malinge leplea ka'ebalulom,” aro pogsiek. ");
INSERT INTO kkl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pogsiekpa, Yesusag yaekti hailamekti, “Nai, andi nimiag 'Ologne to, nubunge to,' aro kembahin koma wali yubu ambarelamsilam. Ane sembe nu el wamapne, 'Nimiri na sembe wali sembanukang,' semban koma Allahri seneropne sunsunum uro sik yubu ambarelamsilam. Ane sembe andi yubu ka'ebaukap. Roma nimiri nu luknuhiro saelba uhiropne nubunge Kaisar ponekori nunag, 'Kal ma'al a'undi saeag agha na sembe pogto tarelamnululom,' aro arukahiog. 'Tarelamnululom,' aro arukahiogpa, nuri wali el tarelamukap to, kom to?” aro monag aluktop yubu haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wene aro haibaekpa, Yesusti seneraglamogti, “Sindi yubu lilim walingeag agha lebang aghana, 'Yesusti leplengeag agha haing sae kaupto saelbaukap,' sembangdi haibaneang,” aro Yesus el taog. El taogti, yubu lelamogti, “Sa'a sembe a'undi 'Selbel werobag sae kiliro pailbukap,' aro undo haibanelom? Kal ma'al kirik wanange nhon payamunba, nari kembanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wene seogpa, sin kal ma'al kirik wana nhon tarekpa, Yesusti salero kemelamogti, “Kal ma'al kirik wana aneag etneri si wamla? Etneri yame sunumna wamla?” aro maneri haibahiog. Wene seogpa sindi, “Roma nimi nubunge Kaisarti yame sunumnaap eldi siap kal ma'al aneag wamla,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wene seekpa Yesusti, “Kal ma'al aneag Kaisarti yame sunumnaap eldi siap pairop tanena, Kaisarti a'unag 'Pogto tatne,' sele tanena, 'Eldinge,' aro tarelamlulom. Aghana sa'a-sa'a Allahringe wamla tanena, Nuni Allahag tarelamlulom,” seog. Wene seogne ka'ebaekti, “Yaghe, eldi wana hektopne agha ambatsil,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ik nhon sum Yahudi nimi Sadukinang etpare Yesusag yaek. Saduki nimiri seneraglameknena, “Nimi teptopne nimi nen amik kamag taukang kom,” aro seneraglamekti, “Yesusag hairo mibukap,” aro yaek. ");
INSERT INTO kkl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yesusag yaekti hailamekti, “Nangkae, wali yubu ambarelamsilam. Tam nhon ambatkebeba, andi lepmenne ka'ebukap. Samenag Musari mome toro pibog yubuag kemelamapnena, 'Kabuni nhon me koma tebale tanena, yauog kel eneko ilipsaeri maupto topleri, eldo sembe lumbanep me nhon piplul,' aro Musari mome tobog. ");
INSERT INTO kkl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tam nene sembe sunumna nhon ambatkukap. Sin saekbare nang wamnari, yandonge poneko kelabo toamna agha me koma tebanep. ");
INSERT INTO kkl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tebaho tanena, ilipsae phendepne ponekori, 'Naro lunumna me nhon wamso,' aro yauog kel eneko maupnep. Maupnep aghana el babe me koma tebanep. Tebanepba ilipsae wilindipne ponekori babe undo unuanep. ");
INSERT INTO kkl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ilipsae tomne, lamne, no'opne undobog nimi saekbare abenekori kel eneko maupnep aghana, me koma ni tebanep. Komopnag keleneko babe tebanep. ");
INSERT INTO kkl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nimi saekparenang enekori keleneko toamna ane sembe, amik nimi teptopne kamag tanep sumeneko keleneko etneri kel tanep?” aro monag alukto Yesusag haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wene aro haibaekpa, Yesusti tangaro ambarelamsiogti, “A'un Sadukinang Allah yubu mome toropne seneraglamlom kom. Allahri mikibag agha nimi nen samoro kamag nenehiropne sembe babe sik senelamlom kom. Ane sembe a'un loba uro seneraglamlom. ");
INSERT INTO kkl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aghana nimi teptopne nen samoro kamag taukang sumeneko, nengabo kelabo toptangkamukang kom. Allah arukna imagnang malaikat saog uro wamikti, nengabo kelabo toptangto koma wamukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wene seogti, Yesusti nen tipto ambarelamsiogti, “Nimi nen samoro kamag taukangne sembe olog ambatsinun. A'undi Allah yubu Musari mome toro pibog yubu olog kemelamlom kom te? Musari Allah yubu mome toro pibog yubuna, Musa alog kal peramag sekogpa, Allahri elag ambarog yubu sembe ekon te? Musa alog kal peremag sekoghag kal aneko auk pog libagloa saog uro wamog aghana, kal aneko telamog kom. Anekoa Allahri Musaag ambarelamogti, 'Nana Abrahamap, Ishakap, Yakubapti omeklamneekpa taulbahiropne wamna,' aro Allahri ambarog. ");
INSERT INTO kkl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wene seog aghana, Abrahamap, Ishakap, Yakubap sam tebaek. Tebaek aghana 'Sin nen kamag taukang,' aro Allahri seneraghogti, 'Nana Abrahamap, Ishakap, Yakubapti omeklamneekpa taulbahiropne wamna,' seog. Nuni Allah ponekona, 'Nimi ya'ag teptoba wamukang,' aro taulbahirop kom. Elna 'Nimi kamag wamukang,' aro taulbahiropne wamla. A'un Saduki nimiri loba uro seneraglamlom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesusap Saduki nimiap yubu lelameka anekoag nimi nhon Musari samenag mome tobog yubu ambatsiropne nhon yaogti ka'ebaog. Musari samenag mome tobog yubu ambatsiropne ponekori ka'elamogpa, Yesusti Saduki nimi anekoag samoro ambatsiogpa, ka'ebaogti, “Yesusti wali lepla,” sembaog. “Wali lepla,” sembaogti, Musari yubu ambatsiropne ponekori Yesusag hailamogti, “Allahri ni 'Undo-undo ulamlulom,' aro aruksirop yubu nelagha nubu sirikne, o'omne wamla?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wene aro haibaogpa, Yesusti samoro ambarelamogti, “Allahri 'Undo-undo ulamlulom,' aro aruksirop yubu ni agha, o'omnena ane. Musari samenag mome toro palilamogti, 'A'un Israel nimi ka'eamsut! Nuni Allah, nia mangkina Saelba Uhiropne poneko ot nhonog wamla. ");
INSERT INTO kkl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nuni Allah nu Saelba Uhiropne poneko sembe a'undi wana ningkiap nong ningkiapti o'ona senelapmundi, Elag to'opto seneraglapmundi, nong mikipneag agha El sembe sol wali uro awe tolamlulom,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Allahri aruksirop yubu o'omne phendepnena, 'Andamnang nong ningki o'ona seneptangkamlam saog uro nimi orange babe o'ona sembamsululam,' aro mome toro pibog. Allahri aruksirop yubu orange babe wamla aghana, yubu o'omne paliag sirikne phende abene aghabog,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yesusti wene seogpa, Musari mome toro pibog yubu ambatsiropne ponekori, “Andi sik yubu walinge ambatsilam. Nuni Allah ot nhonog wamlaba, mikip sirikne phendepne El saog uro wamla kom. ");
INSERT INTO kkl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nimiri 'Nuni Allah kibukap,' aro waliaba tatnepneap, lebe aroba oro Allah sembe aukag tamnepneap, ni ane wali. Ot phelektopnena, andi leplamne sunsunum uro nimiri unulamik abeneogna, phelektopne wali sirik wamla. Nimiri wana ningkiag agha Nuni Allah o'ona senero Elag to'opto seneraglamikti, nong mikipneag agha El sembe sol wali uro awe tolamik taneogna, wali sirikne phelektopne wamla. Neapna nimiri nong ningki o'ona seneptangkamap saog uro nimi orange babe o'ona sembamsibe tanena, ane babe wali sirik. Nuni Allah sembe waliaba tatnep aghana, paliag siriknena Allahap nimiap o'ona sembamsukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wene seogpa, Yesusti ka'ebaogti, “Musa yubu ambatsiropne ponekori wana hektopneag agha wali uro lepla,” sembaog. “Wali lepla,” sembaogti, Musa yubu ambatsiropne ponekoag, “Andi leplamne ka'ebiagha, na el tan. Allahri wepto poghogne poneko lag taleri, nimi saelbamsile tanena, andi wana mapleba, elag nelebanep,” seog. Wene seogpa, yog nimiri, “Yesus sumbaukap,” aro logti, nimi nhondi babe elag hairo mibek kom. ");
INSERT INTO kkl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus Allahri Mem Ae aramag wamogti, tipto yubu ambarelamsiogti, “Sin Musari mome toro pibog yubu elnangdi ambarelamsiangne, 'Allahri “Saelbamsululam,” aro wepto poglenge Kristus poneko sembe “Daud elme” aro engeropne,' alamang. Sa'a sembe 'Daud elme' alamang?” aro yubu ambatto haibahiog. ");
INSERT INTO kkl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Haibahiogti, Yesusti nen tipto ambarelamsiogti, “Kristus yalenge poneko sembe 'Daud elme' aro engelamang aghana, Daud eldamneri Kristus poneko sembe 'Na saelba uneropne' aro engero lebog. Allah Eldamne Yame Walingeri nunisag Daud ponekoag ambarogpa, sunsunum uro Daud eldamneri Kristus poneko sembe mome toro pibognena, 'Nuni Imagneri na saelba uneropne ponekoag yubu lelamogti, “Na sae sirik sip pulamen paghabog, andi aisanang andi yan mombolag pipsineba, nun niri saelbanunam,” seog,' aro Daudti mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Undop agha, nunisag Daud eldamneri Kristus poneko sembe 'Na saelba uneropne' aro engelamog tanena, welaro nimiri Daud paliag nenero Kristus poneko sembe 'Daud elme' aro engero lemnep?” aro ambatsiog. Yubu ambarelamsiogpa, sin Allahri Mem Ae aramag wamek nimiri wana yeng uro ka'elamek. ");
INSERT INTO kkl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ka'elamekpa, Yesusti yubu tipto ambarelamsiogti, “Sin Musari yubu ambatsiropnang tanekori ulamangne saog uro a'undi babe unuaheng kom. Sin Musa yubu ambatsiropnang taneko sindamneri paliag neneptangka nubu nimiri enektop ag walinge agha nongag wangalamangdi, nimiri pail wa'ina torobag wa'alamangdi, 'Wali sembanehengdi, kipneheng,' aro nimi whing toman pang yang ulamang. ");
INSERT INTO kkl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nimi poloro Allah yubu lerop aeag babe, nimi haiptangto kwaneng yoro nikag terobag babe, 'Nimi nubunang purobag aghabog pukamsene,' aro pulamang. ");
INSERT INTO kkl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sin nimiri, 'Na kipneheng,' aro unulamang aghana, sae agha orog nimi sembe yareag sembahin koma, aboapti kaldam kelabori ae babe, sae agha uropne babe sin Musari yubu ambatsiropnang tanekori taluro tolamang. O'ona sembahin koma taluro tolamang aghana, sindi malia uropne sembe 'Niknip tanun,' aro Allahag molona we uro kiliro lelamang. Unulamangne nene sembe ni tam kemero karebalulne ponekori kemelamsildi, tam ikin sirikne sinag pipsilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wene seogti, Yesus Allahri Mem Ae aramag palamoghag agha aneko nimiri sae agha kal ma'al Allah sembe pairobag wamogpa, peramag pul piog. Pukamogti kemelamsiogpa, nimi maikno tanekori kal ma'al Allah sembe palilameka kembamsiog. Palilamek nimina, tup nimi maikno tanekori kal ma'al maikno palilamek. ");
INSERT INTO kkl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Palilamekpa kembamsiogag agha kaldam kel sae agha orog kel nhon yaogti, kamna kapto torop kirik wana ologne phende pibog. Kamna kapto torop kirik wana pibognena, si toro tona babe ologha tatsinepne pibog. ");
INSERT INTO kkl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Pibogpa kembaogti, Yesusti el yubu ka'ero neleptopnang “Yahut,” aro yopsiog. Yopsiogpa, elag yaekpa, ambarelamsiogti, “Nari a'unag sik uro lelamnange, tup nimi maikno tanekori sikin saeag maikno wamlange agha pogto waliaba maikno palilamang. Maikno palilamang aghana, kaldam keleneri olog piplange, el saeag orog agha ni kwaneng toro tenne elag wamlange Allah sembe ni pipla. Tup nimi taneri pogto pibangne kembi agha, 'Olog pogto pibang,' sembanep. Aghana kaldam keleneri el saeag orog agha ni tatla ane sembe, nimi ni tane wamangne kembi agha 'Kaldam keleneri maikno phelektopne pipla,' sembanep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesusap eldi yubu ka'ero neleptopnangap Allahri Mem Ae nubunge laplobi agha palamekti, eldi yubu ka'ero neleptopne nhondi, “Nai, yubu amohiropne, Allahri Mem Ae aram ane kembamen! Nubu kirik walingeag agha Allahri Mem Ae tipto sorop ae maikno ane babe, imag soroba babe kemerop sirik,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wene seogpa Yesusti, “Nubu ae walinge maiknoa soroba ane tiboghamen. Amik sum ni ae aneap, imag soroba aneap nimiri ni kwerekto yamolobikpa, kirik nhon babe nen sorobag sekamlul kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wene seogti, Yesusap eldi yubu ka'ero neneptopnangap Zaitun yimag yingkiekti, Yesus Allahri Mem Ae nubunge whingag sip tibogto pukamog. Pukamogpa, eldi yubu ka'ero neleptopnang tombare Petrusap, Yakobusap, Yohanesap, Andreasapti, “Yesusap mo yubu lepsebe,” aro Yesusag yaek. ");
INSERT INTO kkl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yaekti mololamekti, “Nai, andi usa leplamne neneko sembe olog tibin nebatsululam. Usa andi, 'Nimiri ni kwerekto yamolobukang,' aro leplamne nene etsum agha uro yabilul? Kekneba huropne agha lag taleba, 'Wene uro yabinep,' sembaukap?” aro eldi yubu ka'ero neleptopnang tombare abenekori Yesusag haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Wene aro haibaekpa, Yesusti sinag samoro ambarelamsiogti, “Nimiri a'unag, 'Orolenange ambatsikag,' aro haing whi uro wamlulom! Allahri samenag salag lero palilamogti, 'Nimi nhon “Nimi taluro saelbamsilul,” aro wepto pognun,' seogne sunsunum uro, na Yesus wepto pogneo. Na Yesus wepto pogneonge sembe lebog aghana, amik sum nimi maiknori orolenange leroa yalamikti, a'ero-a'ero lelamikti, 'Allahri nanagha “Saelbamsululam,” aro wepto pogneoba yan,' sukang. Sindi orolenange lelamikne sembe nimi maiknori sik sembaukang aghana, a'undi sik sembaheng kom. ");
INSERT INTO kkl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","A'undi ka'elapmunba, nimiri mog so'o aneag babe, weag urop mog so'oag babe mal talamikne sembe lelamikpa, ka'elapmun tanena, wanaag samsamoro log sembaheng kom. Mal talamikne ane sik uro yabilul aghana, Allahri tam karepto ikinne komopto pimnep sum anam elem uro yabinep kom. ");
INSERT INTO kkl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yubu sia leropne as nhonap nhonap aisa neneptangto mal talamikpa, nubu mog so'o nhonap mog so'o nhonap nimi teng-tengne mal talamukang. Mal talamikpa, mog so'o tala-tala sa'uma pot-porolamleba, kwaneng yo maikno walelamlul. Uro yabilul aghana, 'Allahri tam karepto ikinne pairop sum komobanual,' sembaheng kom. Allahri tam kareptop sum lag tanepne sembe sunumnana undo. Me anam mangaptan komag ilindi me mangaro anebag og alnilamsildi, og nubu tangtang og maikno uro seklero mangal tolamla tanena, 'Me manganuan,' sembanep. Ane saog uro, nari ambatsinne sunsunum uro nimi seklenne nubu tangtang uro yabilenge abeneko pere a'undi 'Wene Allahri tam karebalul to,' aro alniro seneragnep. ");
INSERT INTO kkl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Aghana sumeneko anam lag tan komag a'un haing whi uro wamlulom! Nimiri a'un salero, 'Yesusag neleptopnang,' aro Yahudi nimi sembe tam kareptopnangag pabalamsiikti, Yahudi nimi poloro winiro yubu lerop aeag olamsukang. A'un salelamsiikti, 'A'un Yesusag neleptopnang,' aro nimi mog so'o saelba uhiropnangap yubu sia leropnangap sikin whingag pabalamsiikpa, a'undi na Yesus sembe 'Undo-undo wamori, ulamoba, ibobo,' aro lag phoro ambarelamsululom. ");
INSERT INTO kkl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Allahri tam komopto karebalul sumeneko anam uro yabin komag, a'undi yubu walinge Allahri nimi wali saelba uhiropne sembe ambarelamsululom. Ambarelamsimunba, yubu tipto nimi mog so'oag tala-tala wamang nimiag ambatsiik taneogna, tam wali uro komopto karebanep sumeneko uro yabinep. ");
INSERT INTO kkl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yubu walinge ambarelamsimunba, nimiri a'un haing sae kaupto tam kemero kareptobag pabuhukang. Tam kemero kareptop nimi whingag pabihik tanena, 'Sa'a senun,' aro log sembaheng kom. Sin whingag wapmunag abeneko pere Allah Eldamne Yame Walingeri a'unag 'Undo-undo leplulom,' aro el nembahilul. Allah Yame Walingeri a'unag amolamsilenge a'un mori senenneag kom aghana, Allahri senenne sunsunum uro amolamsilul. Ane sembe log semban koma Allah Yame Walingeri a'unag amolamsilenge sunsunum uro lelamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Na sembe ambarelamsimunba, tipto ambarelamsiikne abeneko pere, nimiri karongdi, ilipsaeap eldoapti 'Nangkae' semban koma 'Yesusag neleplamlaba, ya'ag oplulom,' aro pan khebahileba, nimiri opsukang. Iliri babe elme sembe 'Name,' semban koma nimiri saeag nenero, 'Yesusag neleplamlaba, salero oplulom,' aro pan khebalul. Nimiri sikini sikinin 'Ya'ag opsukang,' aro pan khebahukang. A'un nanap ma'aptangto neleplamnelomne sembe nimi niri a'un sembe karong sembahukang. Karong sembahukang aghana, nimi etneri wana khaepto wamleri, nanag 'sikne' aro seneraglamle tanena, Nuni Allahri nimi eneko taluro wali nembalul,” aro Yesusti eldi yubu ka'ero neleptopnang tombare abenekoag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wene seogti, Yesusti nen ambarelamsiogti, “Ik nhon sum malia nhon Allahri 'Song mali,' senenne Allahri Mem Ae lomag wa'ina sekamleri, Allahri Mem Ae aneko mali nembalul. Mali nembaleba, Allahri Eldi Mem Ae sembe 'Karong' sembaleri, laplobi agha pileba, nimiri babe karongdi laplobi agha pukang,” aro Yesusti ambatsiog. (A'undi mome nene kemelamlom nimiri wali uro seneraglapmun tanena, Yesusti “Malia” seogne nene “Tam huropne sembe lebog,” aro wana hekahilul). Yesusti eldi yubu ka'ero neleptopnangag tipto ambarelamsiogti, “Malia aneko Allahri Mem Aeag wa'ina sekamle sumeneko nimi mog so'o Yudea wamik nimiri, 'Nu ya'ag opsikag,' aro merero yimag pinep. ");
INSERT INTO kkl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sumeneko nimi eldi ae imaghag tai waelbamle nimi elem uro kulukaleri, ae lomag wamlea 'Tomnun,' aro ae lomag wa'in koma elem-elem merero yimag pilul. ");
INSERT INTO kkl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nimi aweag wamle nimi eldi ag nongag enektoba kwiripto piplea samoro tol pin koma merero yimag pulul. ");
INSERT INTO kkl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Undo uro yabalamle abene sin kelabo me mum tiniltolamik kelaboap, memon wamik kelaboap, sin sembe ikin sirikti, 'Yaghe' aro seklebaukang. ");
INSERT INTO kkl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Ko'o neneag wamik nimi maiknoro seklebaukang. Undo uro yabalamleba, seklebaukangnena, Allahri samenag so'o sumbaog sumag agha nimi seklelameka kekman, wene babe seklelamang aghana, undo uro yabileba, ikin uro seklebaukangne sunsunum uro kom. Undo uro yabileba, seklelamikpa, amik wamukang nimi babe seklebanep aghana, undo saog uro seklebaukang kom. Ot ko'o neneag wamik nimi agha undo seklebaukang. Ni undo uro yabalamlulne nene mag telamle liag uro yabile tanena, yimag panne ekauk sirik, ane sembe Allahag mololapmundi, 'Nun seklebabeagti, mag telamle liag uro yabalamlul kom,' aro molona mololamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ikin seklebaukang ko'o aneko Allahri peram nembaho komba, nimi ni tebaheng. Aghana anam uro yabin komag, Allahri o'ona senehiro, 'Na mabo taukang,' aro wepsiog nimi sembe yareag sembahiogti, 'Ko'o ane peram nembanun,' aro karebaogti, peram nembalul. ");
INSERT INTO kkl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ko'o anekoag nimiri a'unag yubu ambarelamsisengdi, 'Kembahut! Allahri wepto “Taluro saelbamsululam” aro poghogne Kristus yaldi, ane wamla,” sehengba, nimi orangeri, 'Ano wamla,' seheng tanena, a'undi sik sembaheng kom. Sinag nelebahin koma yimag merero pululom. ");
INSERT INTO kkl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nimi maiknori lero yalamikti, nenneri, 'Na Allahri “Saelbamsululam” aro wepto pogneoba, na Kristus yan,' aro orolena ambarelamsukang. Nenneri, 'Na Allah yubu silimu tipto lelamna,' aro orolena ambarelamsukang. Orolena ambarelamsiikti, nimiri uanep komne ulamikti, 'Yaghe! Imagneri mikipne pere agha mane agha ual,' senen kekneba ulamikpa, orolena lelamikne nimi maikno sirikti sik sembaukang. Nimi maikno sirikti sik sembaukang aghana, Allahri 'Namabo taukang,' aro wepsirop nimi sembe, 'Orolena sik sembaukang kom,' aro wana hekahileba, orolena lelamikne sembe sik sembaukang kom. ");
INSERT INTO kkl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nari wene a'unag ambatsinne nene anam uro yabin komag ni uro yabinepne sembe ambatsin. Ane sembe haing whi uro wamlulom,” aro Yesusti eldi yubu ka'ero neleptopnang tombare abenekoag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wene aro ambatsiogti, Yesusti nen tipto ambarelamsiogti, “Ikin seklelamik ko'o eneko uro yabileba, amik nen uro yabilulnena, Allah yubu samenag mome toro pibogne sunsunum uro uro yabilul. Samenag Allah yubu silimu tiptopne nhondi amik uro yabilulne sembe mome toro palilamogti, 'Heng babe tingkale komba, wal babe tingkalul kom. ");
INSERT INTO kkl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Imberea babe lulupna agha imag agha tinilamikpa, imang wareroba imag wamlange babe ni lolog alul,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Undo uro yabile tanena, na imag agha nimi mog so'oag nimi tahinge toa nusam toman yanun. Yalamneba, Allah Imagne ponekori mikipne pere agha imang warero lag taneba, nimi niri tiboganukang. ");
INSERT INTO kkl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Imang warero mikipneag agha yaneri, nari Allah arukna imagnang malaikat poglamsineri, “Allahri 'Na mabo taukang,' aro wepsirop nimi mog so'o im tiptobag so'o tiptobag wamang nimi ni poloro wimbahilulom,” aro pogsunun. ");
INSERT INTO kkl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","29","Nari a'unag 'Undo-undo uro yabilul,' aro ambatsinne sunsunum uro uro yabalamleba, kemelapmundi el tahilul. Ni ane kembamundi seneraglapmundi, 'Yesusti nunag, “Nen amik uro yabilul,” aro ambatsiogne peram tanual,' aro el tahilul. Kekneba kemelamlulomne nene sembe, sunumna nhon kal sembe ambatsinun. Nu nimi taneri kal ara kemelamapba, kon eren ua ulamlari, mog towalengelamla tanena, 'Ebare li tanual,' senelamap. Ane saog uro, nari a'unag 'Undo-undo uro yabilul,' aro ambatsinne sunsunum uro uro yabalamle tanena, 'Nen amik uro yabinepne peram tanual,' senelamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sik uro ambarelamsin. Nimi wene wamang nimi anam teban komag ni ambatsinne nene uro yabilul. ");
INSERT INTO kkl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Imap so'oap orog talul aghana, nari yubu leropne orog talul kom. Ya'ag wamlul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wene seogti, nen tipto ambarelamsiogti, “Ni 'Undo-undo uro yabilul,' aro ambatsinne nenena, nimi nhondi babe, 'Etsum uro yabilul,' aro el wamla kom. Allah arukna imagnang malaikat babe, Allah Elme babe ekon. Ot Nuni Allah Eldamneog el wamla. ");
INSERT INTO kkl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A'un babe 'Etsum uro yabilul,' aro ekon uro wamlom. Ane sembe tibogto weapmundi, haing whi uro wamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'Tibogto weamlulom,' sennena, sunumna nhon ambatsineba ka'eamlulom. Ae ngainge nhon 'Weag punun,' aro ulamla tanena, eldi ae lomag wamlange eldi aruknari saeag piplari, 'Yae wamlulom,' aro arukahil. Aruklamsildi, elme arukna nhonag, 'Awe nene tolamlulam,' seldi, nen nhonag, 'Awe nene saelbamlulam,' aro ambatsil. 'A'ero-a'ero saelbamlulom,' aro ambatsildi, ina siramag, 'Yae wamlulam,' sel nimi enekoag, 'Wali uro yae wamlulam. Na pineri, samoro yanunne sembe haing whi uro tibogamlulam,' sel. Wene aro arukahildi pil. Ane saog uro na anam pin komag a'unag, 'Weapmundi, haing whi uro tibogamlulom,' aro nari ambatsin. ");
INSERT INTO kkl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ae ngainge poneko pila 'Etsum samoro aeag yalul,' aro eldi arukna taneko ekon. Ae ngainge poneko sinag yalul to, tomnusam yalul to, kweleknag yalul to, heng lopwalengeleag yalul to, sin ekon. Ae ngaingeri arukna ae yae ua uropnang taneko ekon urop saog uro, na nimi so'oag nimi tahinge etsum samoro yanunne sembe a'un babe ekon uro wapmunba, yanun. Ane sembe haing whi uro tibogamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ae ngainge poneko lo'om aro yalamleba, el arukna taneko malamikpa, ipsile tanena karong sembahilul. Ane saog uro na lo'om aro samoro yalamneba, a'un malapmunagti, haing whi uro tibogamlulom. ");
INSERT INTO kkl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nari a'unag lelamnange nene nimi niag wenero ambarelamsin. Haing whi uro tibogamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Yahudi nimi sembe nubu sum peramag wamekpa, nimi maiknori, “Nubu sum 'Paskah' amni taleba, as Yerusalem sani yoro telameberi, kwaneng walerop komne ik saekpare telamukap,” aro Yerusalem yalamek. Yalamekti wamekpa, memnang Yahudi nimi sae agha Allah sembe pairopnang sikindoyaboap, Allahri Musa pere agha “Undo-undo unulamlulom” aro mome toropne ambatsiropnangap tanekori, “Welaro Yesus haing kumbaberi, sae kaupto saelbaberi, ya'ag obukap,” senelamek. “Obukap,” senelamek aghana seneraglamekti, “Nubu sum Paskah taleba, ik saekpare sani yoro terop sum abeneko pere el sae kaupto saelbabe tanena, nimi maikno tane wamang nimiri nu walamsiikti, yanghang alamikag,” aro log senelamek. ");
INSERT INTO kkl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wene “Salero obukap,” senelamekpa Yesus Yerusalem peramag as Betania Simondi aeag wamog. Simon poneko samenag kon tena pololamogpa, wali taogne ponekori aeag Yesus wamogti, kwaneng telamog. Kwaneng telamogpa, kelabo nhondi aeag wa'iogti, nongag pelagtop mag song walinge payaog. Nongag pelagtop mag song walinge nene kirik agha sunurop ma'i nhonag ikto tobongkibekpa, kamna alikinag kapto tobogti payaog. Payaogti, “Ologha babe pimna koma ni ikto kipnun,” aro ma'i ina siram kobongkia Yesusti usoghag ikog. ");
INSERT INTO kkl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kamna alikinag kapto torop mag song walinge ikogpa, nimi etpare wamekne tanekori ibekti, wana yo senelamek. Yo senelamekti, sin mamun yubu lelamekti, “Sa'a sembe mag song walinge nene loba nenero iklopla? ");
INSERT INTO kkl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Song wali mag enena, nimiri hengkun nhon awe welamnaba, kamna tatsiropneag saog uro kamna kapto torop mag ane. Keleneri saeag agha nimiri kamna kapto topsoba, kal ma'al ane nimi sae agha orog nimiag pogto tatsiso aghana iklopla,” aro keleneko wabaek. ");
INSERT INTO kkl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wene aro walamekpa, Yesustina, “Lipsisut! Sa'a sembe keleneag walamlom? Eldi nanag 'Nimi o'omne' sembaneldi, walia ual. ");
INSERT INTO kkl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sin nimi sae agha orogne sopsop a'un nusamag wamikpa, a'undi 'Wene yepsisebe,' sembamun tanena, sopsop yepsinep. Ot nana agha sopsop a'unap nhon wamukap kom. ");
INSERT INTO kkl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Keleneri eldi saeag wamlangeag agha na sembe 'Nimi o'omne,' aro kipnel. Na amik tebahaneba, nari nongag nimiri song wali mag pelaganehengdi, so'oag sikitneheng saog uro ual. Na anam teban komag keleneri nanag song wali mag pelaghaneldi, na tebane sum sembe wero o'ona sembamnel. ");
INSERT INTO kkl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sikne agha ambarelamsin! Mog so'o tala-tala yubu walinge Allahri nimi saelbamsilne sembe nimiri ambarel palamsiikti, keleneri nanag walia ualne sembe ekon tan koma ambarelamsukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","11","Wene “Kelenekori wali kipnel,” seogpa, Yesus eldi yubu ka'ero neleptopnang aobarenang agha nimi nhonna, Yudas Iskariotne nenekori, “Yesus pankhebanun,” aro piog. Yudas nenekori memnang Allah sembe pairopnangag piogti, “Yesus pankhebanun,” aro ambatsiogpa, wana awi sembamek. Awi senelamekti, “Yesus nunag pankhebamenba, kal ma'al kamna tatkukap,” aro salag lero pibek. Saekag lebekneag agha Yudasti “Etsum pa'asea wamlul,” aro weamogti, keme nelero seneraglamog. ");
INSERT INTO kkl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yahudi nimiri ik saekpare kwaneng roti walerop komne telamek ko'o alnirop sum, nubu sum Paskah sumeneko taog. Paskah sumeneko Yahudi nimiri sop-sop ul palamekne sunsunum uro “Pham domba me oro yobaukap,” aro ulamek. Yobaukap aro ulamekti, Yesusti yubu ka'ero neleptopnangdi Yesusag hailamekti, “Nai, nu sam piberi, kwaneng yobabeba, yamenba nhon tukap. Tala siba pham domba me oro yoro tukap?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wene aro haibaekpa, Yesusti eldi yubu ka'ero neleptopnang phende arukto poglamsiogti, “As nubunge Yerusalem palamtumunba, nimi kabuni nhon mag tero poa yalamlenge pone haiptamundi, elag nelebarurom. ");
INSERT INTO kkl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Elag nelepto palaptumundi, el wa'alogle ae eneag wa'arurom. Wa'arumundi ae ngainge ponekoag, 'Nuni, elag yubu ka'ero neleplamapne ponekori nun anag pogsilba, yanam. Anag hailangkeldi, “Nanap nari yubu ka'ero neleptopnangap Paskah sumeneko mo wameberi, andi ae lom nhonag telaukap. Ae lom nelag agha nanap nari yubu ka'ero neleptopnangap mo wameberi, pham domba me nhon tukap?” aro hailangkeldi, nu pogsilba, yanam,' sururom. ");
INSERT INTO kkl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wene surumunba, ae ngainge ponekori a'unag ae tika paliagneag ae lom nubunge ambatsilul. Ae lom nubunge anekoag ae usa puna babe, kwaneng palinag babe ni sunuro nu sembe wero wamla. Ae lom eneag agha nu ni sembe wero palilamturom,” aro Yesusti sin phende pogsiog. ");
INSERT INTO kkl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wene aro pogsiogpa, eldi yubu ka'ero neleptopnang phende abeneko as Yerusalem anekoag pirekpa, Yesusti sinag, “As anekoag ipturom,” seogne sunsunum uro iptek. Iptekti, ae lom anekoag wa'irekti, Paskah sum sembe tenaba yoro wero palilamdek. ");
INSERT INTO kkl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ae imbaogpa, Yesusap eldi yubu ka'ero neleptopnang aobareap wa'iek. ");
INSERT INTO kkl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wa'iekti kwaneng tero pukamekpa, Yesusti lelamogti, “Sik uro ambarelamsin. Wene nu ane kwaneng nhon tero pukamapnang anabiag agha nimi nhondi na pankhebanuanel,” aro eldi yubu ka'ero neleptopnangag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wene aro ambatsiogpa, ka'ebaekti wana mali tahiogpa, eldi yubu ka'ero neleptopnang ni tanekori a'ero-a'ero Yesusag lelamekti, “Nari komdiog,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wene alamekpa, Yesusti nen yubu lelamogti, “A'un aobarenang anabiag agha nhondi pankhelebanuanel. Nimi endana nanap nikag telamnamdi, kal wana lolterop maghap pelengenag, el babe nikag kwaneng roti pelengkia telamnam aghana, pankhebanelul. ");
INSERT INTO kkl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na mog so'oag nimi tahinge nanag uro yabilulnena, samenag Allah yubuag na sembe mome toro pibekne sunsunum uro tebanun. Ot el pankhebanele nimi sembe yaghe senero seklebalul. Na nimi mog so'oag nimi tahinge pankhebanele nimi nenekoag Allahri tam ikin sirikne piplul. Ilindi el mangkaho komba, elag ikinne wamso komba, seklebaho kom. Aghana, na pankhebanelul nimi sembe ikin sirikne elag pipleba, seklebalul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wene seogti, kwaneng telamekag agha Yesusti kwaneng roti tobogti, “Nani, wali tatsilam,” aro Allah kibog. “Wali tatsilam,” aro yubu lebogti, kwaneng roti aneko saeri khepto-khepto eldi yubu ka'ero neleptopnangag tarelamsiogti, “Na nong ane topsuri, tehut,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wene seogti, mag anggur lolterop mag ma'i tobogti, “Nani, wali tatsilam,” aro Allah kibogti, sin tebatsiogpa, sin ni wamekne tanekori anggur lolterop mag ane teek. ");
INSERT INTO kkl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Anggur lolterop mag ane telamekpa, Yesusti ambarelamsiogti, “Allahri samenag, 'Nimi maikno taulbahinun,' aro salag lero pibogne sunsunum uro nari eneng ene lambanual. ");
INSERT INTO kkl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sik uro ambarelamsinne ka'ebalulom. Allahri nimi mog so'oag nimi saelba uhin ko'o anam uro yabin komag, anggur lolterop mag nen tenun kom. Ot Allahri nimi mog so'oag nimi saelba uhin ko'o lag tale sumeneko og, weneogna anggur lolterop mag wendogne tenun,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wene seogpa, Allah omektop sepna nhon sebekti, Zaitun yimag piek. ");
INSERT INTO kkl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zaitun yimag piekti, Yesusti eldi yubu ka'ero neleptopnang ambarelamsiogti, “Samen Allah yubu silimu toptopne nhondi mome toro pibogne ane: 'Nari pham domba yae ua uropne poneko omneba, pham domba taneko talupto tala-tala pukang,' aro mome toro pibog. Mome toro pibogne nene a'un sembe mome toro pibogpa, a'un ni tanekori na liloa taluptangka pululom. ");
INSERT INTO kkl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aghana omneikpa, nen samoro kamag taneri, na sam mog so'o Galilea pineba, a'un amik yalulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wene “Na liloa taluptangka pululom,” aro Yesusti ambatsiogpa Petrusti, “Sin ni tanekori an liloa pikiikba, nanogna an liloa pikenun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Petrusti wene seogpa Yesusti, “Yubu sikne ambarelamsinenge ka'ebamendi el uro wamlulam! Ae anam kwelekan komag winang ayam anam ik phende yubu lemna komag, andi ik wilindi na sembe, 'Nimi ene na ekonne,' sululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wene seogpa, Petrusti nen mikip uro ambarelamogti, “Kom. Nana tapto anap ma'aro tebahenemea babe, nari an sembe, 'Ekonne,' senun kom,” seog. Seogpa Yesusti yubu ka'ero neleptopnang nenneri babe nika uro lebek. ");
INSERT INTO kkl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wene seekpa, Yesusap eldi yubu ka'ero neleptopnangap mog so'o sina Getsemani piek. Piekti Yesusti ambarelamsiogti, “Na Allahag molona molol pinundi, a'un ane pukamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wene seog aghana, Yesusti Petrusap Yakobusap Yohanesap enero pabihiogti, olog ko'oro palamekag abenekoa Yesus wana samsamoro wana ikin taog. ");
INSERT INTO kkl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wana ikin uro ambarelamsiogti, “Na wana ikin sirik uanelba, tebanep saog uro wamna. Ane wapmundi, haing whi uro yae wamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Wene seogti, Yesus olog nen ko'oro piogti, wana ikindi so'oag malingkina Allahag molona mololamogti, “Naba naniong! Ot Andiog nia mangkina uanep. Nanag 'Seklero tebalulam,' aro pogneomne ikindi, kom nembahom. Ot nari 'Undo yaboho,' seneropne agha ualulam kom. Andi wanaag seneropne agha uro yabile,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wene seogti eldi yubu ka'ero neleptopnang wilindi wamekag samoro yaogti, malameka ipsiog. Ipsiogti, Simon Petrusag, “Simon, meo! An malamlam, te? Heng ko'o nhonog wero yae wamnep kom, te? ");
INSERT INTO kkl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nimiri wanaag agha, 'Walia uahene,' sembanep aghana, nong mikip komdi walia uan koma uro yabileagti. Ane sembe haing whi uro yae wamsuri, Allahag mololamsut. 'Sa'a-sa'a uro yabileba, khaepto wamukap,' aro mololamlulom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wene aro ambatsiogti, nen samoro piogti, Allahag molona samen lel piogne saog uro nen lel piog. ");
INSERT INTO kkl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lel piogti, nen samoro yaogti kemelamsiogpa, sin nen malamek. Sin kwahingdi malamekne sembe aliri, “Sa'a sukap,” aro yubu koma wamek. ");
INSERT INTO kkl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Yubu kom taekpa, Yesus nen samoro ik wilindip sum Allahag molona molol piog. Piogti, Allahag molona molbaogti, nen samoro yaog. Yaogti malameka kemelamsiogti, “A'un anam tektek papto malamlom, te? Abenda maplom! Puksuri, kembamsut! Na mog so'oag nimi tahinge pankhebanuanelba, mali-malia uropnangdi na sae kaupto saelbanukang. Wene palumukap! Na pankhebanelne neneko yalamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusti anam yubu ambarelamsioghag agha kemelamekpa, eldi yubu ka'ero neleptopnang aobarenang abeneko agha Yudas neneko yalamogha ibek. Yudasap nhon yalamek nimina, nimi maikno “Yesus saelbaukap,” aro yaek. Sin Yudasap nhon yaeknang anekona, memnang Allah sembe pairopnang sikindoyaboap, Musari yubu ambatsiropnangap, Yahudi nimi sembe wenehiropnangap tanekori pogsiekpa, karogap kameap saelba, “Yesus haing sae kaupto saelbaukap,” aro Yudasag nelebel alamek. ");
INSERT INTO kkl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sin anam Yesusap haiptan komag Yudasti sinag kekneba nhon el nenelamsiogti, “Nari somoro togtogha kiplamne nimi endane, el agha saelbamundi, lambaleag aro wali yae uro pabululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wene aro ambatsiogpa, Yudasag nelepto yaekti, Yudas yingkin togha abeneko pere Yesusag pintogha, “Nai, wali yubu ambatsiropne wamlam!” aro togtogha kibog. ");
INSERT INTO kkl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Togtogha kiplamog abeneko nimi yaek nimi tanekori Yesus saelbom agha haing sae kaubek. ");
INSERT INTO kkl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Haing sae kauplamek nimi anabiag agha memne Allah sembe pairop nang sikini nubunge arukna nhon babe wamog. Haing sae kauplamekpa, nimi nhon Yesus peramag sekamogne ponekori karog kilbom agha memne Allah sembe pairop nang sikini arukna wamogne ponekori ao pubom agha pelengelobog. ");
INSERT INTO kkl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Pelengelobogpa, salelamek abeneko pere Yesusti nimi tanekoag lelamogti, “Sopsop Allahri Mem Ae aramag wa'alamnori, a'un whingag Allah yubu ambarelamsinobog, a'undina salelamneom kom. Na 'Mo sekukap,' aro mal tarop nimi sikini wamsene tanena, a'undi nanag yalamlomne, 'Nimi yonge ane oro saelbaukap,' aro karogap kameap payalamlomne sunsunum sembanep. Aghana, na mo sekukap aro mal taropne kom. Ane sembe a'undi nimi whingag yo kom uro na saelbanep aghana, samenag Allah yubu silimu tiptop nimiri mome toro pibogne sunsunum uro uro yabilul ane sembe, wene yalomdi undo salelamnelom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wene alamog abeneko, eldi yubu ka'ero neleptopnang ni el laploa tognoptang-tang merebaek. ");
INSERT INTO kkl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Sin Yesusag neleptop nimi tognoptang-tang merebaek nimi agha kaubuni nhon ag sabonge agha nongag wangkamogti, Yesusag neleplamog. Sin Yesus haing sae kauplamek nimi tanekori, “Yesusag neleptopne eneko saelbaukap,” aro ulamekti saelbaekpa, ag aneko kologlobi agha kabeog merebaog. ");
INSERT INTO kkl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesus saelbaekti, memne Allah sembe pairop nang sikiniri aeag poa palamekpa, memnang Allah sembe pairopnang sikindo yabo niap, Yahudi nimi sikini yaboap, Musari yubu mome ambatsirop nangap ni poloro winiptaekpa, sindi whingag Yesus poa piek. ");
INSERT INTO kkl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesus salero pabalamekpa, Petrusna weag agha poro tiro palamogti, memne Allah sembe pairop nang sikiniri aramag wa'al piog. Wa'al piogti, memne Allah sembe pairop nang sikini yae ua urop nang anabiag auk lekto pukamog. ");
INSERT INTO kkl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Auk lekto pukamogpa, memnang Allah sembe pairop nang sikini yaboap, ora nimi nubungeri Yahudi nimi sembe tam lelekto kemeropnangapti, “Yesus ya'ag obukap,” aro Yesusag tam palinne sembe kemelamek. Elag tam palinne kemelamekti, orolena lerop nimi yopsiekpa, nimi tanekori Yesus sembe, “Undo-undo malia uaori leboba, ibobori ka'ebabo,” aro lolorop yubu orolena ambatsiek. Lolorop yubu orolena yubu lelamek aghana, lelamekne nene olog tiptangtop komdi, nimiri sik sembanep kom ane sembe, ka'elamekneag agha Yesusag tam palinne olog ibek kom. ");
INSERT INTO kkl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Yesusag tam palinne kemelamekti ibek komba, nen nimi etbare sekekti, yubu minirop yubu mangkaek. Yubu minirop yubu mangalamekti, “Nimi eneri yubu lelamoba ka'ebabongena, 'Allahri Mem Ae, nimi saeri sorop ae enena kwerekaneri, ik wilindiag agha mem ae wendogne nimi saeri sorop komne sobanun,' alamoa ka'ebabo,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wene aro mangarop yubu lebekne nene babe olog tiptangtop komdi, nimiri sik sembanep kom. ");
INSERT INTO kkl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wene aro sik sembanep komne lebekpa, memne Allah sembe pairop nang sikini poneko sin ni wameka anabiag sekogti, Yesusag hailamogti, “Sindi wene an sembe 'Malia lelamo,' seangne sembe andi pelebeltanan yubu leplulam kom te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wene aro haibaog aghana, Yesus yubu lemna koma wamog. Yubu lemna koma wamogpa, memne Allah sembe pairopnang sikini ponekori nen hailamogti, “An Allah Paliagne Elme walinge wamlam to, kom to? Nuni Allahri an sembe 'Mog so'oag nimi taluro saelbamsilul,' aro wepto pogkeonge poneko Kristus wamlam to, kom to?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wene aro haibaogpa Yesusti, “Wene leplamne pone wamna. Na imag agha mog so'oag nimi tahinge Allah mikipne poneko sae sirik sip pukamneri, toa nusam toman nen samoro mog so'o aneag yanea imnululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Yesusti wene seogpa, memne Allah sembe pairop nang sikini ponekori ka'ebaogti, yo lelem elenge ag wangkamogne taepto ebog. Elenge ag wangkamogne taepto ebogti, tam kareptopnangag lelamogti, “Eldamneri leplange wene ka'ebap. Yog nimiri 'Undo-undo lelamoa ka'ebano,' aro lenne nen ka'ebaukap kom. Allah san tilipto, 'Paliagne wamna,' aro leplange ka'ebalom. Wenena yubu ka'ebalomneag agha 'Huaukap,' aro seneraglamlom?” aro haibahiog. Wene aro haibahiogpa, nimi wamek nimi tanekori, “Allah san tiliptop yubu lepla ane sembe, ya'ag tebalulne sunsunum,” aro tam karebaek. ");
INSERT INTO kkl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","“Tebalul,” aro tam karebaekti, nimi etpareri sulu mag supto haing ubi agha olamekti, “Etneri olangkel nimi si lepmen,” aro yubu nepto olamek. Olamekpa, memne Allah sembe pairop nang sikini nubunge yae ua urop nang tanekori babe Yesus salero olamek. ");
INSERT INTO kkl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yesus olamekpa, memne Allah sembe pairop nang sikini ponekori ae aramag Petrus tau sip wamogpa, Allah sembe pairop nang sikini arukna kelabo nhon Petrus wamoghag yaog. ");
INSERT INTO kkl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yaogti Petrus auk leklamogha ibogti, wali uro whingag kembirogti, “An babe Yesus Nasaretne nenekoag neleplamomba ipkeno,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wene seog aghana Petrusti, “Na ekon. Andi sa'a yubu agha lelamlam? Na seneragna kom,” seog. Wene seogti, sekom agha memne Allah sembe pairop nang sikini ponekori ae aram ina siramag piogpa, winang ayam yubu lebog. ");
INSERT INTO kkl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wene seogti, ae aram ina siramag aneko piogti sekamogpa, keleneko nen yaogti Petrus ibog. Ibogti nen sarikto nimi wamek nimi tanekoag alniro ambarelamsiogti, “Nimi ene babe Yesusag neleplamla,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wene aro ambatsiogpa, ka'ebaogti Petrusti nen yubu lelamogti, “Yesusna na ekonne” seog. Wene seogpa, ko'o olog wameka nimi taneko nen yingkina Petrusag lelamekti, “An sembena, 'El Galileange,' aro el wamap. Undop agha nuri an sembe, 'Sik tapto Yesus nenekoag neleptopne wamla,' aro seneraglamap,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wene seekpa, Petrusti samoro yubu ambarelamsiogti, “A'undi si lelamlom nimi ene na otsik tapto ekonne agha lelamlom. Orolena ambarelamsin tanena, imagne ponekori hae omnelul,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wene alamog abeneko pere winang ayam yubu ik phendepne yubu lebog. Winang ayam ik phendepne yubu lebogpa, Yesusti samenag yubu lebogne sembe Petrus el taog. Yesusti samen Petrusag ambarelamogti, “Winang ayam yubu ik phende lemna komag andi ik wilindi na sembe 'Ekonne' aro yubu leplulam,” seogne sembe Petrusti seneraghogti, “Sik uro lepla,” aro engelamog. ");
INSERT INTO kkl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwelekaogpa lukunap memnang Allah sembe pairop nang sikindoyaboap, Yahudi nimi sikiniri wenehirop nangap, Musa yubu mome ambatsirop nangap, ora nimi nubungeri Yahudi nimi sembe tam lelekto kemeropnangap sin ni tanekori “Huaukap,” aro yubu lelamek. Yubu lelamekti, “Yesus haing sae kaupto mog so'o aneag saelba uhiropne Pilatus saeag poa pukap,” aro yubu saekag lebekti, Yesus haing sae kaupto Pilatus saeag tarel piek. ");
INSERT INTO kkl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pabiekpa, Pilatus ponekori Yesusag hailamogti, “An sik Yahudi nimi sembe yubu sia leropne nubunge, te?” seog. Wene seogpa, Yesusti, “Yo, otsik leplam,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wene seogpa, memnang Allah sembe pairop nang sikini yabo tanekori Yesus sembe “Malinge undo-undo ulamo,” aro lolorop yubu Pilatusag ambarelamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ambarekpa, Pilatusti Yesusag nen hailamogti, “Andi yubu samoro ambatsululam kom, te? Kembamen! Andi malia uaomne nanag ambatneangne maiknori,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wene aro haibaog aghana, Yesusti nen samoro yubu olog lebog kom. Yubu olog lebog komba Pilatusti, “Sa'a sembe peleptangtop yubu olog lepla kombae?” aro yaghe sembaog. ");
INSERT INTO kkl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wamek sumeneko Yahudi nimi sembe nubu sum Paskah yanuaog. Pilatus ponekori sop-sop ulamognena, Paskah sum talamogpa, Yahudi nimi haing sae kaupto kop aeag tobongolamsiog nimi agha Pilatus ponekori “Yahudi nimiri molona molbaneikne sunsunum uro nimi nhonog lambitnun,” aro ulamog. ");
INSERT INTO kkl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Haing sae kaupto tobongkipsiek nimi taneko wameknena, Yahudi nimi nenneri seneraglamekti, “Roma nimiri nu saelbamsiangne karongdi, mo seksebe,” aro ulamek. “Mo seksebe,” aro ulamek nimi nenneri nimi ya'ag opsiekpa, Roma nimiri haing sae kaupto saelbamsiekti, kop aeag tobongkipsiek. Sin kop aeag tobongkipsiek nimi agha nimi ohiropne nhon si Barabas wamog. ");
INSERT INTO kkl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wamogpa, Yahudi nimi maikno tanekori Pilatusag yaekti, “Hengkun samenag ulamom saog uro sumene babe nimi nhon sae lobitlulam,” aro molona mololaek. ");
INSERT INTO kkl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Wene aro molbaekpa, Pilatus ponekori el wamogti, “Memnang Allah sembe pairopnang sikindoyabori, 'Yesus si nubunge taleag,' aro wana mali senelamangdi, salero nanag poa yaang,' aro Pilatus ponekori el wamog. Ane sembe Pilatusti nimi maikno tanekoag hailamsiogti, “A'undi nanag mololamnelomne, a'un Yahudi nimiri, 'Saelbamsululam' aro lebomne Yesus pone agha sae lobitnunne, yeng te?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wene “Yesus sae lobitnun,” aro haibahiog aghana, memnang Allah sembe pairop nang sikindo yabo tanekori wanaag nonogtop yubu lebek. Wanaag nonogtop yubu lelamekti, nimi maikno wana tolamsiekneag agha nimi maikno tanekori, “Barabas agha sae lobitlulam,” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wene alamekpa Pilatusti, “Wene alamlom tanena, a'un Yahudi nimiri elag, 'Saelbamsululam,' aro lebomne pone Yesusag huanun?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wene seogpa, nimi taneko yubu mikip uro lelamekti, “Yesus kalag siplobe!” alamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wene alamekpa, Pilatus ponekori nen hailamsiogti, “Wene alamlom aghana sa'a sembe? Nimi eneri malinge huropne uaoba, kalag sipto omnun?” aro haibahiog. Wene aro haibahiog aghana, sindi yubu nen nubu nenero haum aro lelamekti, “Kalag siplobe!” seek. ");
INSERT INTO kkl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","“Kalag siplobe!” aro haum alamekpa, Pilatus ponekori nimi maikno taneko “Wana yeng nembahinun,” aro sindi molbaekne sunsunum uro Barabas agha sae loplobog. Barabas agha sae loplobogti, “Yesus taeplam-taeplamlopmundi, kalag sipto oplulom!” aro Pilatusti yin saleropnangdi saeag nembaog. ");
INSERT INTO kkl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yin saleropnangdi saeag nembaogpa, taeplam-taeplamlobekdi, mog so'o saelba uhiropne ae nubunge aramag Yesus pabiek. Pabiekti, sikinkabo yin saleropnang yogne yopsiekpa, ni longol aek. ");
INSERT INTO kkl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Longoptaekti, “Yubu nebukap,” aro ag uwongne nimi nubunangdi enektop ag Yesus nongag wangkirek. Elag wangkirekti, alog aba agha mog so'o saelba uhiropnang usoghag kwiria elektoba saogne wibekti, yubu nepto usoghag nobek. ");
INSERT INTO kkl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Uwong ag elag wangkirekti, alog aba nobekti, yubu nepto lelamekti, “Nuni! Yahudi nimi saelbamsilamne,” aro yubu neplamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yubu neplamekti, Yesus usoghag kameri olamekti, silu mag suplamek. Silu mag suplamekti, nimi nubunge kiploa saog uro yabu sanukto pulingkina yubu neplamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yubu neplamekti, “Abenda. Pukap,” sembaekti uwong ag nongag enektoba wangkirekne neneko el nongag agha kuribaekti, el samenag wangaro amogne wangkirek. Wangkirekti, “Yesus kalag sipto olobukap,” aro poa lambaek. ");
INSERT INTO kkl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","“Yesus kalag sipto obukap,” aro inaag poa palamekti, yin saleropnang tanekori nimi nhonag, “Yesus sipnep kal ane poplulam,” aro pobirek. Sindi elag pobirek nimi eneko sina Simon, Aleksanderap Rufusap sikini ponekoag kal pobirek. Simon pone as Kirene agha yalamogpa yobekti, “Kal ane poplulam,” aro yubu mikip uro arukaek. ");
INSERT INTO kkl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pobirekpa palamekti, Yesus mog so'o nhon sina Golgota mainag pabiek. Golgota aneko Yahudi nimiri lelamek yubuag, “Nimi usog ya'ol,” aro main ane si Golgota aro engero yabiog. ");
INSERT INTO kkl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Golgota mainag poa piekti, Yesusag mag anggur lolterop maghap, uwong mag mur arop maghap ma'abaekti, elag tebarek. Mag tareknena, “Mag ane teleba, og seklelamlange olog keyagman talul,” aro tebarek aghana, Yesusti mag ten koma lipsiog. ");
INSERT INTO kkl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mag lipsiogpa, ag nongag wangkamogne kwiriplobekti, kal tam alikinag siptoba, pakuri Yesus sae yan kalag siplobek. Siplobek nimi tanekori, “Yesusti nongag wangarop ag etne-etne pogtaukang?” sembaek. “Etne-etne pogtaukang?” senelamekti, “Kekneba toboghabeba, po'obahile nimi enekori toro aukang,” aro kekneba toboglamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesus kalag pakuri siplobeknena, ae lukun heng ko'o supnangeag agha kalag siplobek. ");
INSERT INTO kkl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kalag sibekti, Roma nimiri, “Nimi ane kalag sipto obapnena tamna nene sembe,” aro mome toro pibek. Mome toro pibeknena: “Nimi ane Yahudi nimi sembe yubu sia lero saelbamsilne” aro mome toro pibekti, Yesus kalag sibek kal anekoag pibek. ");
INSERT INTO kkl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesus kalag siplobekag nimi phende babe yoaba ulamdek nimi pabihiekti, Yesus sae sirik sip nhon, waneng sip nhon kalag siplopsiek. ");
INSERT INTO kkl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Samenag anam kalag siplopsin komag Allahri yubu silimu tiptop nimiri uro yabinepne sembe mome tolamogti, “Yoaba urop nimiag ulamsiangne saog uro elag babe uaukang,” aro mome toro pibog. Elap yoaba urop nimiap ma'aro siplopsinepne sembe samenag mome toro pibogne sunsunum uro uro yabiog. ");
INSERT INTO kkl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Kal sibeka peram toman palamek nimi taneko ngang kwa'arom-kwa'aroma Yesus san tiliplamekti, “Eh, andi samen yubu lelamomdi, 'Allahri Mem Ae nubunge kwereklopseneri, nen ik wilindiog agha wendogne sobahane,' seom. An sik uro mikip tanena, kalag agha kulukamendi, wali nenep talulam!” aro yubu nepto san tilibaek. ");
INSERT INTO kkl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yubu nepto san tiliplamekpa, memnang Allah sembe pairopnang sikindoyaboap, Musari samenag mome toro pibogne ambatsiropnangap tanekori babe Yesus yubu nepto sin mamun lelamek. Yubu nepto lelamekti, “Nimi orange wali nenelamsio aghana, eldamne wali neneptanep kom. ");
INSERT INTO kkl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","El neneko sik uro Allahri webogti, 'Israel nimi taluro saelbamsilul,' aro poghogne Kristus wamso tanena, hae kal aniag agha kulukaho. Kulukaho andarina ipseberi, wali elag sik sembahabe,” aro yubu neplamek. Yubu nepto san tiplamekpa, elap nikag kalag sipto opsiek nimi phende abenekori babe Yesus san tilipto yubu neplamdek. ");
INSERT INTO kkl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yesus kalag sibekpa, wamogpa, heng ik mol-mol seogti, siro turu alamog abeneko heng sanubom seogti, ae iniplobog. Ae iniplobogpa, wamek mog so'o eneko ni iniplobogha heng ko'o wilindi piog. Heng ko'o wilindi palamogha, kekman heng taolbaogti, ae sin taog. ");
INSERT INTO kkl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ae sin taogpa, Yesusti Yahudi nimiri yubuag yubu haum aro lelamogti, “Eloi! Eloi, lama sabakhtani?” seog. Seogne anena nuri yubuag, “Nani Allah! Nani Allah, sa'a sembe andi na laploamnelam?” aro lebog. ");
INSERT INTO kkl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wene seogpa, nimi etpare taneko wamek nimiri ka'ebom agha seneraghek komdi, “Ka'ebahut! Eldi Allah yubu silimu tiptopne Elia pone yoplamla,” seek. ");
INSERT INTO kkl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wene seekti, nimi nhondi elem-elem noghom-nesom saogne tol piogti, anggur lolterop maghag werebi agha kalag kolnoro, “Yesus mag yori mag telul,” aro towalengero Yesus pamag pibog. Towalengero pibogti, yubu lelamogti, “Olog mo wamleba, ta'abameberi kembamukap. Allah yubu silimu tiptopne Elia samenag wamogne poneko yaleri, kalag ania toro pelengkalul to, kom to?” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wene seogpa, Yesus yubu haum aro lelamogti hain kom taog. ");
INSERT INTO kkl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yesus tebaog sumeneko Allahri Mem Ae lomag “Mem usa ae lom aneag nimi wa'aukang kom,” aro ag wilnirop ag nubunge ina siramag siliplengkibekne wamog. Yesus teplamogti hain kom taongom alamog abeneko pere, ae lom wilnirop ag siliplengeroba pukama aneko serero payangkaogti, phende taog. ");
INSERT INTO kkl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesus hain kom taog sumeneko, yin saleropnang sikindo nhon Yesus whingag sekamogti ni kembamog. Yesusti yubu mikip uro haum aro lelamogti, hain kom taongom alamogne ibogti, yin saleropnang sikindo ponekori, “Otsik, nimi ene Allah Elme,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yesus hain kom taongom alamogpa, kelabo etbare weag agha sekamekti tibogamek. Kelabo tibogamek kelabo taneko anabiag agha wameknena: Maria Magdala kelenekoap Salome kelenekoap Yakobus amik mangkaekne ponekoap ilipsae Yosesap sikinin Maria kelenekoap Kelabo tanekori Yesus tebaogne weag agha tibogamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kelabo tanekona, samen Yesus mog so'o Galilea wamogpa, kelabo tanekori “Yesusag teko ualeag,” aro yepto neleplamek. Yesus as Yerusalem palamogpa, kelabo tanekoap yog kelabo maiknoap abenekori Galilea mog so'o laplobi agha elag nelepto as Yerusalem yingkiekti, weag agha hain kom taongom alamogha tibogamek. ");
INSERT INTO kkl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Tebaog sumeneko Yahudi nimi niri, “Ambhum tek-tek papto wameberi, Allah yubu lebukap,” aro menekna togtop sum wamek. Nimi nhon sina Yusup, as Arimateange ponekori Yesus tebaogne sembe el taog. Yusup Arimateange pone el babe Yahudi nimi sembe tam lelekto kemerop nimi Mahkamah Agama nimi agha nubunge wamog. Yusup ponekori Allah sembe yeng senelamogti, “Allahri nimi mog so'oag nimi saelbamsilulne imnun,” aro nang-nang alamog. Undo unulamogha Yesus tebaogne sembe el taogti, inipna peram taogpa, Yusup ponekori, “Yesus tebaogha o'obanun,” aro Pilatusag piogti, log kom uro “Yesus tebaogha aneko pabinun,” aro molol piog. ");
INSERT INTO kkl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wene aro molbaogpa, “Yesus tebal,” seogha ka'ebaogti, Pilatus ponekori, “Weneog kalag sibang aghana, el elem phea abene tebal, te?” aro lo'om seog. Lo'om seogti, “Yin saleropnang sikindo enel pululom,” aro nimi pogsiogpa, enel piekti payaek. Payekpa Pilatus ponekori yin saleropnang sikindo ponekoag, “Yesus usaap ya'ag tebal, te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wene aro haibaogpa, yin saleropnang sikindo ponekori, “Sik uro ya'ag tebal,” seog. Seogpa, Pilatusti Yusupag, “Wali teptoba aneko tol pululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wene aro ambarogpa, Yusupti ag sabonge walinge nimi teptopne kelepsirop ag kamna alikinag uro tobogti, Yesus kalag sipto obeka aneko toro pelengkia ag sabonge tobogha anekoag kelebaog. Kelebongkia kirik lom hogtobag pail piog. Kirik lom hogtobag pail piogti, ina siramag kirik nubunge agha pemagto ina siramag maruklobongkia piog. ");
INSERT INTO kkl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yesus kirik lom hogtobag pibogpa, Maria Magdala kelenekoap, Yoses ilin Mariaap abenekori Yesus kirik lomag palilamogha tibogamsirek. ");
INSERT INTO kkl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yesus tebaog sumeneko Yusupti Yesus teptoba kirik lom hogtobag pibogpa, ae imbaog. Iniplamog abeneko pere Yahudi nimi sembe tek-tek papto Allah yubu lerop sum taogpa, ik nhon wamekpa, nen imbaog. Imbaogpa, sumeneko inipnag aneko Maria Magdala kelenekoap, Yakobus ilin Maria kelenekoap, Salome kelenekoap sin kelabo wilindi abenekori, “Yesus nong teptoba song taleagti, nong alip toman song wali mag ikil pukap,” sembamek. “Heng walelingkileba, ikil pukap,” aro inipnag aneko song wali mag kamna kapto tol piek. ");
INSERT INTO kkl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tol piekti, kweleknag aneko lukunap sin Yesus kirik lom hogtobag piboghag aneko piek. ");
INSERT INTO kkl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Inaag palamekti, sin mamun hail talamekti, “Kirik nubunge ina siramag maruktoba aneko etneri yepto pemagto kolbatsilul,” aba palamek. ");
INSERT INTO kkl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","“Kirik aneko nubu sirikti,” aba palamekti, pina kemelamekag agha kirik aneko pemagto koloropba ina siram kuptoba ibek. ");
INSERT INTO kkl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ina siram kuptop wamogpa, wa'ina sae sirik sip kemelamekpa, kabuni me nhon ag siliro pelengka urop ag kororopne wangkamogti, pukamog. Pukamogpa ibekti, sin lo'om seek. ");
INSERT INTO kkl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lo'om seekpa, kaubuni me anekori sinag yubu lelamogti, “Log sembaheng kom! Na elwamnange Yesus Nasaretne amni kalag siplobongne poneko elamlom. El tane wamla kom. El nen kamag tal! A'undi babe kembalulom! El pibongagna ane. ");
INSERT INTO kkl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wene pimundi, yubu nene Eldi yubu ka'ero neleptopnangag ambatsumundi, Petrusag babe ambatlulom. Ambarelamsumundi, 'Yesus sam mog so'o Galilea palamlaba, a'un babe Galilea pululom. Eldi samenag ambarelamsio saog uro, Galilea pimundi haiptalulom,' aro ambarel phululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wene aro ambatsiogpa, kirik lom hogtobag Yesus piboghag anekoa lambaekti, merero palamek. Sin logti nimi nhon babe ambatsin koma merero piek.  ");
INSERT INTO kkl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Selek sum aneko lukunap Yesus tebaogha nen kamag taogti, samenagne Maria Magdala keleneko whingag lag taog. Maria Magdala kelenena, samenag Yesus anam teban komag phia saekpare el kulomag wamekpa, Yesusti keleneko wali nenero phia yag lambahiogpa, wali taog kel. ");
INSERT INTO kkl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Magdala keleneko whingag Yesus lag taogpa, kelenekori sin samenag Yesusag nelepto elap nhon ul palamek nimi ambarel phiogpa, haiptaek. Haiptaekti, sikin engero amang ulamekag kelenekori, “Yesus nen kamag taldi, nanag lag talba imna,” aro ambatsiog aghana, sik sembaek kom. ");
INSERT INTO kkl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ambatsiogne sik sembaek kom aghana, sumeneko babe Yesus elkabo phende as nhonag palamdek. Palamdekpa Yesus sin whingag lag taog aghana, Yesus nong a'erop saogne agha lag taog. ");
INSERT INTO kkl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lag taogpa, sin phende sikinkabo wamekag saombarekti, ambarelamsirek aghana, sin phende abenekori yubu lelamdekne babe sinkabori sik sembaek kom. ");
INSERT INTO kkl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ambarelamsirekpa seneragto lelamekti, Yesusti wepto pogsiognang ko'olombarenang taneko kwaneng telamek. Kwaneng telamekpa, Yesus sin whingag lag taog. Lag taogti, sinag yubu lelamogti, “Nimi etpare anekori na sembe, 'Nen kamag talba, imna,' aro a'unag ambarelamsiang. Sa'ambe a'un usog mikipti sik senelamlom kom,” aro wembahiog. ");
INSERT INTO kkl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wene aro wembahiogti, tipto ambarelamsiogti, “Nimi tala-tala wamangneag pimundi, yubu walinge 'Allahri Yesus pere agha mog so'oag nimi taluro saelbamsil,' aro nimi niag ambarel phululom. ");
INSERT INTO kkl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nimi etneri, 'Yesusag sikne aro seneraglamna ane sembe maghag pelengkipnululam,' aro ulamle tanena, nimi eneko Allahri taluro saelbalul. Ot nimi etneri na Yesusag sikne aro seneraglamla kom tanena, Allahri nimi enekoag tam ikinne pipleri, oplul. ");
INSERT INTO kkl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Sin na Yesusag sikne aro seneraglamik nimiri kekneba ulamukang. Kekneba ulamiknena, Na Yesus mikipne sin pere agha ulamneba, phia yonge yag lanalamsukang. Sin ekon yubu ka'eptanep kom yubuag lelamukang. Sindi ya'ag ohirop phae saelbaika babe, nimi ya'ag ohirop mag telamika babe, sin tebaukang kom. Sindi nimi naiktopne nong alibag sae palilamsiikpa, Allahri nimi taneko wali nenelamsilul. Nanag sikne aro seneraglamik nimiri undo unulamik tanena, 'Yesusti mikipne sin pere agha ulamla,' aro el tanep,” seog. ");
INSERT INTO kkl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wene aro ambatsiogpa, Nuni Allahri imag agha nu Saelba Uhiropne Yesus kiliro tobog. Kiliro tobogpa, “Nikag nun niri saelbamsununam,” aro Allah sae sirik sip pulingkiogti wamla. ");
INSERT INTO kkl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nuni Allahri imag agha kiliro tobogpa, Yesusti yubu ka'ero neleptopnang tanekori as tala-tala nimiag yubu walinge Yesus sembe ambarel phiek. Ambarel palamsiekpa, nu Saelba Uhiropne Yesusti mikip nenelamsiogpa, kekneba maikno ulamek. Kekneba ulameknena, nimiri kembi agha, “'Imagne ponekori sin pere agha ulamla tanena, Imagneri yubu sikne ambarelamsiang,' sembaukang” aro kekneba maikno ulamekti ambarelamsiek. Abenda. ");
INSERT INTO kkl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teofilus nani, samenag mome pipsinge ane. Yesusti alnibaogti, ulamogti ambarelamsiogti, imag yingkiogpa, ni ulamogne sembe mome toro pipsi. El neneko anam imag yingkin komag Allah Eldamne Yame Walinge Elag wamogpa, Yesusti nimi a'obare wepsiogti, pogsiog. Yesusti wepto pogsiognang tanekoag “A'undi nia mangkina undo-undo ulamlulom,” aro ambatsiogpa, Allah imagneri kiliro tobogha sembe mome topsi. ");
INSERT INTO kkl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","El obekpa, seklero tebaogti, kamag taogne, “Na kamag tanonge imniikti, 'Sik, kamag tao,' sembaukang,” aro kekneba maikno sin haingag ulamog. Ulamogti, “Allahri Eldamne yubu ka'erop nimi wali uro saelbahilulne,” sembe ambarelamsiogti, “Naipsabori imnukang,” aro lag tangom tognop tangom alamogha inipna teng nhon epto naualbare taog. ");
INSERT INTO kkl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Ik nhon sum Yesusti wepsiogti, pogsiogneap kwaneng nhon telamekti ambarelamsiogti, iriklamsiogti, “Yohanesti samenag nimi maghag pelengelamsiogne mag moag pelengkipsiog aghana, olog wapmunba, Allahri Eldamne Yame Walinge a'unag pelengkipsilul. Ane sembe, as Yerusalem anea lamba pheng kom. Na Naniri, 'Nandamne Yame tatsinun,' aro salag lebogne Nari ambatsinonge neneko nang-nang aro wamlulom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesusti wepto pogsiog nimi taneko ik nhon sum Yesusap winiro wamekti hailamekti, “Nai, samenag Roma nimiri nu Israel nimi saelbamsiek komag wamubu saog uro nu 'Israel nimi mog so'o nuringe ngai taukap aro paliag nembahinun,' aro leplam, te?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wene aro haibaekpa Yesusti, “Allahri Israel nen samoro paliag nembahilulne etsum anena a'unna eltanep kom. Nani Allah el mo el wamlari saelbamlari, karebalul aghana, ");
INSERT INTO kkl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Allah Eldamne Yame Walinge a'unag kulukul aleri, mikip nembahileba, Na wamnori ulamnoba imneomneap, Nanag uro yabilneap, amik uro yabilulneap sembe as Yerusalem, mog so'o Yudea, mog so'o Samaria, as tala-tala im tiptobag so'o tiptobag wamangneag pimundi, ambarelamsululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wene aro ambarelamsiog abeneko imag agha Allahri Yesus kiliro tolamogpa, toari niknilamogpa, Eldi wepto pogsiognangdi tiwalengkamek. ");
INSERT INTO kkl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","El imag yangkalamogpa, Ilipsabori tiwalengkamekti, hain ebom alamekag agha nimi phende ag solomne enektopne sin peramag sekamdekne abenekori sin yubu ambarelamsirekti, “A'un mog so'o Galilea nimi. A'un sa'a sembe imag tiwalengkamlom? Yesus neneko a'un laplobiagha Allahri imag agha kiliro tolamlaba, tiwalengkamlomne nene saog uro amik kulukul alulne babe yangkalamlaba tiwalengkalomne saog uro kulukul alul,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","13","Ambatsirekpa Yesusti Wepto Pogsiog nimi taneko yim Zaitun anekoa samoro as Yerusalem yaek. Zaitun yimag aneko Yerusalem ana we koma samoro Yerusalem yingkina nimiri ae agha sesog wamekag aneko ae tika alikinagneag waelbaekti, wamek. Sin wameknena: Petrus, Yohanes, Yakobus, Andreas, Filipus, Tomas, Bartolomeus, Matius, Alfeus elme Yakobus, Simon ponena “Roma nimi luknubahibeberi, mo sekukap,” aro yin saelbamogneap, Yakobus elme Yudasap sin wamek. ");
INSERT INTO kkl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sin ma'aptangto wamekti, sol wali,wali uro Allahag yubu moloro longoptangto wamek. Longoptangto wamekne taneko kelabo etbareap, Yesus Ilin Mariaap, Yesus ilipsabo taptopneapna, yogne agha Yesus sareneleplamek nimiap wamek. ");
INSERT INTO kkl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ik nhon sum Yesusag “Sikne” aro seneragtop nimi teng tombare eptopneap saog uro (120) longoro wamek sumeneko Petrus neneko, “Yubu lemnun,” aro sekog. ");
INSERT INTO kkl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Sekogti yubu lelamogti, “Nangkabo, Allah Eldamne Yame Walinge nenekori samenag nunisang Daud pere agha lebog. Lebogne, Daudti Allah yubuag mome toroba buku nhonag mome toro pibog. 'Mome toro pibognena Yesus saleropnang poa yahionge sembe mome toro pibog,' aro el taap. Allahri samenag seneraghogti, 'Undo uro yabilul,' sembaogne toro pibogne kom tanep kom. Toro pibogne sunsunum uro Yudasti nimi topsiori, poa yahioba, Yesus saelbaong. ");
INSERT INTO kkl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Samenag Yudas poneko babe nu nimi a'ilin wamobori, Yesus sembe nimi ambatto yeplamsibo,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas neneko malia uaogne sembe kamna tarekpa, kamna anekoag agha so'o tobogti, so'o enekoag tinilamogti, mon serero tisirik langtukto tebaog. ");
INSERT INTO kkl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Undo obogne neneko Yerusalem nimi niri el taekti, obog so'o eneko “Nimi eneng so'o,” alamekti, sindi yubuag si “Hakal Dama,” aro engkaek. ");
INSERT INTO kkl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrusti lelamogti, “Allahri 'Undo uro yabilul,' sembaogne ane sembe nunisang Daud pere agha Allah yubu sepna wamlangena: 'El ua urobag langkop tale nimi nhon babe aneko wamukang kom.' Nen siplamogti: 'Wenehiropne nenekori awe toro saelbamonge nimi yog nimiag tale,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ane sembe Yudas lunumna nhon ebeberi, webukap. Webebeba, nimi nhon aneri, 'Yesus kamag taoba, ibo,' nunap nimi ambatsukap. Ambatsiropne webukapnena, samenag Yohanesti nu Salehiropne Yesus maghag pelengkiboghag agha, wamogti sop-sop nunap wamoba, Yesus nu nusamag ua ulamogha iboba, Allahri imag agha Yesus kiliro toboa babe ibori, nimi ane webukap. Webeberi, nunap ambarelamsukapti, 'Yesus kamag taoba, haingdi ibobo,' aro nimi ambatsukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wene seogpa, nimi wamekne tanekori, “Nimi phende wepsukap,” aro Yusubap Matiasap towalengkaek. Yusup poneko si wilindi wamog. Si nhon Barsabas alamek, si nhon Yustus alamek. ");
INSERT INTO kkl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","“Sin phende abeneko wepsukap,” aro Allahag mololamekti, “Nai, Andi ni nimi wanaag kembamsilam. Samenag Yudas, 'Nari yubu ambarelamsululam,' aro webomdi, poghomne neneko eldamne sae pere agha apto aori, laplobi agha malia uaonge sunsunum urobag wamla. Naro, Andi, 'Nimi phende abene, Andi yubu pibomne wamsori, ambarelamsiso saog uro lunuro pukamlulne nene,' aro webatsi,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wene aro Allahag molbaekti, “Kekneba ibukap,” aro kirik toboglamekpa, Matiasag po'obaogpa, Yesusti wepto pogsiogne ko'olombareog wamek aghana Matias aonge taog. ");
INSERT INTO kkl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yahudi nimiri ik nubu sum si Pentakosta taogpa, “Yesus otsik uro lebo” aro seneragtop nimi taneko ot nhonoghag poloro winiptangto wamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Poloro winiptangto wamekpa, imag agha khao yubu mu ana saog uro lelamogpa, lo'om alamekag agha, ae sin wamek ae anekoag mu aro tobonglamog. ");
INSERT INTO kkl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tobonglamogpa, nimi taneko toman a'ero-a'ero auk pog libang-libang arop saogne sinag pulamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sinag pulamsiogti, Allah Eldamne Yame Walingeri sin nongag to'opto wa'isiogti, mikipne pipsiog. Mikipne pipsiogpa, sin ekon yubu ka'eptanep kom yubuag alnibaekti, a'erop-a'erop yubuag Allah Yame Walingeri tatsiogha sunsunum uro lelamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wene aro lelamekti, as Yerusalem wamekpa, nimi sisa Yahudi nimi engeropnang Allahag yubu moloropne wamekpa, nimi sisa a'ero-a'ero nimi Allahag yubu moloropnang babe wamek. Allahag yubu moloropnang taneko wameknena, “Pentakosta sum uaukap,” aro anamag, mog so'o sirikag-sirikag agha yalamekti, yubu mo-mo lerop nimi Pentakosta sumeneko as Yerusalem wamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yingkina wamekpa, Allah Eldamne Yame Walingeri tatsiogha sunsunum uro a'erop-a'erop yubuag lelameka yingkirop nimiri ka'ebaekti, Yahudi nimi maikno wamek nimi taneko longol alamek. Longol alamekti ka'elamsiekpa, “Yesusti otsik uro lebo” aro seneragtop nimiri yubu a'erop-a'erop yubuag lelamekpa, ka'elamsiek nimi tanekori, “Welaro lelamang? Nundam nimiri yubu ka'elamapti,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ka'elamsiek nimi tanekori, “Welaro lelamang,” sembaekti, yubu lelamekti, “Sin nimi taneag mane agha uro yabil. Sin Yahudinang mog so'o Galilea nimi taneko kom te? ");
INSERT INTO kkl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ka'elamsiaba nununge yubuag lelamangba, welaro lelamang. Nununge as babe yubu babe a'ero lero urop nimi aghari. ");
INSERT INTO kkl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Nunna mog so'o Partia agha, Media agha, Elam agha, Mesopotamia agha, Yudea agha, Kapadokia agha, Pontus agha, Asia agha, Frigia agha, Pamfilia agha, Mesir agha, Kirene peramag Libia agha, Kreta agha, Arab agha, Roma agha Yerusalem yingkiropnang Yahudi nimi wamap. Roma agha Yerusalem yingkirop nimi, nhon wamapne yangkan nimi aghana Roma nimi nhon-nhon Yahudi nimi saog uro taburi, sindi omeklamangneag omeklamap nimi aghari. Tam nubunge Allahri ualne sembe lelamangba, nu mog so'o sirikag-sirikag yingkiropnangdi ka'elamsiap,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sin wene alamek nimi tanekori, “Logti, mane agha sindi nun yubuag lelamang. Amik uro yabilulne welaro uro yabilul?” aro wene alamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aghana sin nenneri lelamekti, “Mag yonge teangdi nenek saelbahilba lelamang,” aro og solamsiekti, pam kwereklamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wene alamsiekti, pam kwereklamsiekpa, Petrus neneko elkabo ko'olombare nang eneko babe sekekpa, Petrusti yubu nubu uro ambarelamsiogti, “A'un Yahudi nimi nangkabo, Yerusalem wamlom nimi nangkabo, nari ambatsinunne nene a'un niri ka'eamsuri seneragsu. ");
INSERT INTO kkl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wene heng ot weneog tingil alba wamap ane sembe, mag yonge teang koma agha lelamang. A'undi lelamlomne nene saog uro nimi tane mag teangba, nenek saelbahilba, lelamang kom. ");
INSERT INTO kkl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sindi lelamangne nenena samenag Allahri ambarelamogpa, Allahri yubu silimu tiplamogne Yoel nenekori mome toro pibogha sunsunum uro lelamang,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Wene seogti, Petrusti nen tipto lelamogti, “Allahri lebogne Yoeldi mome toro pibogne ane: 'Ik komopnag li wamikag Nari Nandamne Yame Walinge nimi mog so'oag maiknoro pelengel anun. A'undi mabo kelmaboag Nari ambatsininge sindi a'un ambatsukang. A'undi mabo Nari, “Uro yabinepne ibukang,” sembaneri, uanea sunsunum uro ibukang. Nong nimi Nari, “Lenda mabukang,” sembaneri, el nembahinenge lenda mabukang. ");
INSERT INTO kkl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sumeneko li enekoag Na arukna kabuni babe, kelabo babe, Nandamne Yame Walinge sinag maiknoro pelengkahinun. Pelengkahineba Nari ambatsininge sunsunum uro ambarelamsukang. ");
INSERT INTO kkl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Imag 'Undo uro yabilul,' senena kekneba uaneri, so'oag agha babe, 'Im So'o Ngainge yan ual,' aro el nenehinna kekneba pimnun. Amik enengap, auk apna, auk mhong luma kuktopneap wamlul. ");
INSERT INTO kkl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Im So'o Ngainge yale sum eneko elel molel arop sum talul. Aghana, ik nubu sum eneko uro yabin komag, heng inibin sog mondo seleba, wal imag wamlange eneng saog taleba, ");
INSERT INTO kkl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","nimi etneri Im So'o Ngainge ponekoag molbale tanena Allahri nimi ane taulbalul,' aro Yoel pere agha ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel nimi nangkabo, a'unag yubu lemnunne nene ka'eamsu: Yesus Nasaretne poneko sembe, 'Yaghe, Allahri el pere agha ual' senenne kekneba nimiri uanep komne, Allah Eldamneri uanepne Yesus pere agha ulamo. Unulamoa a'undi babe ibom. Eldi ulamonge kekneba mikipne a'un haingag agha ulamo. Allahri El pere agha ulamori, Yesus Nasaretne sembe a'unag tibin nembahio. ");
INSERT INTO kkl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Allah Eldamneri sembaogne sunsunum uro, 'Tebalea pere agha nimi mog so'oagne taulbahilul,' aro a'undi saeag Yesus tatsiogpa, Allah yubu ingisapsirop nimi saeag nembaom. Nimi saeag nembaomdi, kalag siplobomdi, obom. ");
INSERT INTO kkl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Obom aghana 'El teptobag aneko ya'ag ua una sunsunum kom,' sembaogti, Allahri seklerobag nimi teptobag agha kamag nembaog. ");
INSERT INTO kkl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daud ponekori Yesusag uro yabinepne sembe lelamogti, mome toro pibogne ane, 'Im So'o Ngainge sinag kweleknag na whingag ua ulamla. Nari sae sirik sip ua ulamlaba, kemelamnari, na lagmag senep kom. ");
INSERT INTO kkl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Im So'o Ngaingeri piamnelba, wana awi uro wamnari, pamag agha El omeklamna. Anenge Arukna Sol Wali Walinge neneko so'oag agha polbalul kom. Nanenge yame nimi teptobag limnululam komne, na el. Ane sembe nong aneag 'Salag lebomne kembanun,' aro tibogto wamnun. ");
INSERT INTO kkl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Andi ina walinge ibatnulumba, kamag wamnundi, na An saramag wamneba, na awi yeng maikno teknebarelamnululam,' aro Daudti siplamog.” ");
INSERT INTO kkl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nen tipto Petrusti ambarelamsiogti, “Nangkabo, nunisag nubunge Daud neneko sembe nari lag phoro ambatsunun. Nunisag tebaogpa, el arameag sikekag aneko wene nuri babe ililamap. ");
INSERT INTO kkl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud neneko Allahri yubu silimu tiptopne wamogti, ambarelamsiogne wamogpa, Allahri elag sik uro salag lelamogti, 'An anmabo mangarobari mangaroba mangkahyikne nhon an lunumna nimi salehiropne sunsunum urobag pukamlul,' aro ambarogne el wamog. ");
INSERT INTO kkl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wene aro ambarogpa, Daudti amik uro yabinepne sembe el wamogti, lebogne ane, 'Na nong so'oag agha polbaneag, “Nimi teptobag babe wamle,” aro limneheng kom,' seogne nene lunumna Allahri wepleri, alikinag nembalulne neneko Allahri kamag nembanepne sembe eldi lebog. ");
INSERT INTO kkl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesus neneko Allahri kamag nembaonge nuri haingdi babe ibobo. ");
INSERT INTO kkl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kamag nembaori, Allahri kiliro tobori, Eldi sae sirik sip alikinag nembaori, Allah Eldamne Yame Walinge salag lebogne neneko Elag pibo. Elag piboba, Eldi maiknoro pelengel alba, aoag agha ka'ebalomdi, wene haingdi babe iplom ane. ");
INSERT INTO kkl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ane sembe, Daud poneko imag yingkiog kom aghana, Daudti lebogne ane: “Na Nani Allahri na ua urop mog so'oag nimi salehiropneag yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","'An Nari sae sirik sip pulingkiapmendi, wapmenba, An aisa nemba uagherop nimi ingkisapsinun',” seog. ");
INSERT INTO kkl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nangkabo, ni ambatsinne ka'ebamundi, a'un ekon uro wamseng kom. Yesus a'undi kalag sipto olopsiomne poneko 'Mog so'oag nimi taulbahilul,' aro Allahri webogti, 'Saelbamsululam,' aro paliag pukirogne sembe a'un Israel nimi ni el uro wapmundi, seneraglamlulom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wene aro Petrusti ambatsiogpa, Yahudi nimi tanekori ka'ebaekti, wana ikin tahiogpa, Petrusap elkabo sin Yesusti wepto pogsiognang tanekoabag hailamsiekti, “Nangkabo, nuri hulamukap,” aro haibahiek. ");
INSERT INTO kkl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wene aro haibahiekpa, Petrustina, “'Allahri malia ulamlomne tam orog nembalul,' aro malia ulamlomne lipsululom. Lipsimundi, 'Mog so'oag nimi taulbahilul,' aro Allahri Webogne si Yesus engeropneag seneraglapmunne maghag pelengkipsibeba, Allahri Eldamne Yame Walinge tatsilul. ");
INSERT INTO kkl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Allahri, 'Nandamne Yame Walinge tatsinun,' aro samenag salag pibogne nenena a'unap, a'un maboap, nimi weag wamangne babe Nuni Allahri yopsileba, yaukangneap sembe babe salag nene pibog,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yubu yogne maikno haingdi ipsiogne sembe ambarelamsiogti, yubu yangaro yopto wana tolamsiogti, “Wene malia ulamang nimi taneko anabiag wamlomba, wail ibongkia yamunba, Allahri sin nusamag agha taulbahilulba, yahut,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petrusti yubu ambarelamsiogpa, ka'ebaekne taneko “Maghag pelengkipsululom,” aro yaekne nimi teng-tengne (3000) yaekpa, maghag pelengelamsiek. Pelengkipsiekpa, Yesusag “sikne” aro seneragtop nimiap ma'al talamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma'al talamekti, Yesusti wepto pogsiognangdi yubu ambarelamsiekpa, sinag kweleknag sol wali uro yubu ka'elamsiekti, seneraglamekti, wana nhonog uro wamekti, Allahag molona lero kwaneng kheptangto tero wamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesusti wepto pogsiognang tanekori, 'Allahri sin pere agha ual' senenne kekneba maikno ulamekti, nimiri uanep komne, Allah Eldamneri uanepne ulamekpa, kemelamsiekti, “Nimiri uanep komne ulamang” aro nimi ni “Yaghe, logtie” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nimi ni Yesusag “sikne” aro seneraglamek nimi taneko wana nhonog uro wamekti, “Andinge, naringe,” sen koma ot “Nuringeog,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Sae agha sikininge uropne tanekori kamna kapto tolamekti, tolameka taneko teko wamsiogha sunsunum uro tarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sinag kweleknag ma'aptangto sol wali, wali uro Allah yubu sembe Allahri Ae aramag poloro winildal wa'alamekti, sikininge “Ae a'ero kwaneng khepto tukap,” aro nhon aeag tea, nhon aeag tea wana wali uro yeng uro wamekti, ");
INSERT INTO kkl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Allah omeklamek. “Sin wana wali ulamang,” aro nimi niri yeng awi uro tilamsiek. Nuni Allahri, “Malia ulamangne sembe opsineag aro taulbahinun,” aro seneraghogti, nimi maikno tanekoag wana heklamsiogpa, “Yesus otsik uro lebo,” aro seneraglamek. Sik seneraglamekpa, sinag kweleknag Yesusag “sikne” aro seneragtop nimiap ma'al tan anag, ma'al talamekpa, maikno talamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ik nhon sum heng sin tanep peram Yahudi nimiri sop-sop Allahag mololamek heng enekoag Allahri Ae aramag “Molona yubu lemnunam,” aro Petrusap Yohanesap palamdek. ");
INSERT INTO kkl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Palamdekpa nimi nhon yan malia mangkaekpa, elkabori sop-sop keyapto pil pang yang pang ulamek saog uro sumene babe pil piek. Nimi yan malinge neneko, “'Allahri Ae aramag yubu lebukap,' aro wa'alamik nimiri saeag wamlea molbahilul,” aro leka Allahri Ae aramag kanero toropne ina siramag ina siram si “Ina siram Walinge” aro engeropne nenekoag elkabori pil palamek. ");
INSERT INTO kkl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","4","Petrusap Yohanesap, “Allahri Ae aramag wa'inunam,” aro yalamdeka yan malinge ponekori ipsiogti, “Kal ma'al nhon tatnururom,” aro molbahiog. Molbahiogpa, kembarekti, Petrusti, “Nangkae, nunag kembahi,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Nunag kembahi,” seogpa nimi yan malinge ponekori, “Nanag olog tatnurukanga wamla,” aro kembamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kembamsiogpa Petrustina, “Kal ma'al an tatkenne orog wamla. Ot an tatkununne wamlangena, Allahri 'Nia Mangkina Saelbamsululam,' aro webogne si Yesus Nasaretne engeropne ponekori wali nembaghelul. Wene anag ambarelangkennena, 'Sekmendi palame',” seog. ");
INSERT INTO kkl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wene seogti, Petrusti el neneko sae sirikneag agha toro sekirog. Toro sekirog abeneko pere el neneko yan nginikom agha pinep saog wamogpa, yan no'op mikip taog. ");
INSERT INTO kkl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mikip taogpa, lopnagha sekelingkiogti, yang pang ulamogti, sin phendeap Allahri Ae aramag wa'alamekti, awi yengdi sunukto Allah omeklamog. ");
INSERT INTO kkl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","El yan wali taogti, palamogti Allah omek-omek palamogpa, nimi ni tanekori el ibek. ");
INSERT INTO kkl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ibekti, “El yan maliri Allahri Ae aramag 'Ina Siram Walinge' peramag ua ulamlari, nimiag kal ma'al mololamsilba, ia ulamap nimi eneko,” aro kemelamekti, “Welaro yan wali tal,” aro, “Yaghe” senena wanaag lolbahiog. ");
INSERT INTO kkl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nimi yan malinge agha wali taogne ponekori Petrusap Yohanesap salelamsiogti, nhon palameka ipsiekti, nimi maikno tanekori, “Yaghe logtie” alamekti, Allahri Ae aramag “Salomo” engerobag sip imag agha solorobag aneko Petrusap Yohanesap wa'iekag aneko el babe wa'iogpa, “Yaghe logti mane agha ual,” aro teknel wa'alamek. ");
INSERT INTO kkl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Teknel wa'alamekpa, Petrusti nimi maikno tanekoag yubu lelamogti, “Nangkabo a'un Israel nimi, sa'a sembe 'Mane agha uro yabil' aro log senelamlom? Sa'a sembe nunag kemelamsilom? A'undi senelamlomnena, 'Sin Allah yubu sunsunum uro sol wali uro walia aghabog urop nimiri, nimi ane wali nembarang,' senelamlom aghana, Allah Eldamneri seneragnari agha nimi ane wali nembal. A'undi sembamlomne, nimi yabalamlange sembe, 'Sindinge mikip monge, wamlaba,' sembamlom te? ");
INSERT INTO kkl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nunisag yabo Abraham, Ishak, Yakub Sikini Allah sindi omeklamekne ponekori Elme Yesus neneko Eldi paliag nembaog. Aghana El neneko Pilatus tarel piomba, eldi 'Sae lobitnun,' seo aghana Pilatus whaingag a'undi, 'Sae lobitlulam kom. Nu karong,' seom. ");
INSERT INTO kkl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Allahri wepto aogne walinge sik uro lero uropne poneko sembe Pilatusti, 'Sae lopnun,' aro ulamo aghana 'Karong,' alamomdi, nimi ohiropne poneko sembe 'Sae lobatsululam,' seom. ");
INSERT INTO kkl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ya'ag kamag uro unne tam saleropne poneko a'undi olobomba, Allahri nimi teptopne nusamag agha El neneko kamag nembao. Undo unuaonge nuri ibobonge ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nimi a'undi ililamlomne nene 'Mikipne si Yesus engeropneri wali nembahinep,' aro seneraglaba, nimi ane yan wali nembal. 'El sik uro mikipne' aro seneraglange neneri nimi ane a'un whingag agha wali tal,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Petrusti wene aro ambarelamsiogti, “Nangkabo, a'un saelbamsiang nangap, a'undi ulamlomneap, Allahri samenag, 'Undo uro yabilul,' aro seneraghogne sembe a'un ekondi, Yesus olobomne nene na el. ");
INSERT INTO kkl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","A'un ekon aghana ulamomne pere agha Allahri samenag el wamogti, 'Undo yabilul,' aro ambatsiogne sunsunum nembaog. Allahri 'Wepneri, Poghol anun,' seogne neneko 'Seklebalul,' aro Allahri samen Eldi yubu silimu tiplamek nang ni pere agha ambatsiogpa, 'Mome toro pibekne sunsunum tale' aro Allahri wanaag agha wene sembaogti, uaog. ");
INSERT INTO kkl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ane sembe 'Allahri malia ulamlomne kom nembalul,' aro malia ulamlomne lipsimundi, Allah yubu ka'ero wanaag piapmunba, a'undi malia uroba lupsilulba, wali uro seneraglamsu. ");
INSERT INTO kkl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wali uro seneragmunba, Nuni Allahri amik wana keakman nembahileri, Yesus samenag 'Taulbahimendi, saelbamsululam,' aro wero pibogne neneko a'unag nen poglul. ");
INSERT INTO kkl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","El neneko imag wamle pog Allahri nen poglul. Samenag Allahri Eldamneri yubu silimu tiptopnang sol walingeag ambatsiogpa, mome toro pibekne sunsunum uro, 'Nia mangkina Allahri wendog nembalul,' aro mome toro pibek. Allahri, 'Wene nia mangkina wendog nembanun,' sembale tanena Yesus samenag wero pibogne neneko nen poglul. ");
INSERT INTO kkl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Samenag Musari ambarelamsiogti, 'Nuni Allahri a'un Israel nimi nusamag agha Allahri yubu silimu tiplamlulne na saog uro nhon sekitlul. Eldi ni yubu lelamlea a'undi wali uro ka'eamlulom. ");
INSERT INTO kkl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Uro yabilulnena, nimi etneri Allahri yubu silimu tiptopne ponekori yubu lelamlea ka'eamle kom tanena, kom nembahinep,' aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samenag Allahri yubu silimu tiplamek nang Samuelag agha, eldi lero amik wamek nangag agha, ni nangdi uro yabinepne sembe lebek. Yabinepne sembe lebekne anena, wene og Yesusag uro yabionge sembe lebek. ");
INSERT INTO kkl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Samenag Allahri Eldamneri yubu silimu tiplamek nangag yubu salag nikne lero ambarelamsiogne a'un sembe. Samen a'unisangag agha salag pibogne Allahri Abrahamag pibognena: 'Andi mangarobari mangkahyikne pere agha Nari nimi sisa ni tala-tala wamikne walingena tatsinun,' seog. Salag nene a'un sembe lebog. ");
INSERT INTO kkl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ane sembe Elme nhon sekirogti, nu Yahudinangag poghogpa, nunag samenag yaognena 'Walia ulamsinun,' aro yaog. Eldi wali uahinepnena, samenag yoaba ulamlomne lipsululom aro mikip nembahinep,” aro Petrusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrusap Yohanesapti nimi maikno yubu ambarelamsirekpa, Yahudi nimiri sae agha memnang saeag neneropba, Allah sembe pairopnangap, Allahri Ae yae ua uropnang yin saleropnang sikindoap, Saduki nimiap sin phendeag yaek. ");
INSERT INTO kkl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yaekti ka'elamsiekpa, Petrusap Yohanesapti, “Nimi etneri, Yesusag 'sikne,' senelamleri, tebale tanena Yesus kamag tao saog uro kamag tanep,” aro nimi maikno ambarelamsirek. Ambarelamsirekpa, ka'ebaekti memnang Allah sembe pairopnangap, Allahri Ae yae ua uropnang yin saleropnang sikindoap, Saduki nimi tanekoap yo sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yo sembaekti, “Sin phende abeneko tam kareptopnang whingag pabhukap,” sembaek aghana, imbaogpa, “Ambhum samoro yaberi, tam kareptopnang whingag pabhukap,” aro sae kaupto kop aeag tobongkipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tobongkipsiek aghana, Yesus sembe ambarelamsirekne nimi maikno tanekori ka'elamek. Ka'elamekti seneraglamekti, “Sin phenderi ambarelamsirangne sembe sik uro ambarelamsirang,” aro seneraglamek. “Sik uro ambarelamsirang,” aro seneragtop nimi taneko wamekne, kabuni aghabog a'iliro agha teng-tengne (5.000) wamek. ");
INSERT INTO kkl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Mabeka kwelekaogne memnang Yahudi nimi saelba uahiropnangap, Yahudi nong nimi nubunangap, Musari samenag mome tobogne ambatsiropnangap, memne Allah sembe pairopnang sikini nubunge Hanasap, eldi nimi sisa nhonne, Kayafas, Yohanes, Aleksander, ora nimiap, “Petrusap Yohanesap sembe tam karebaukap,” aro as Yerusalem winiptaek. ");
INSERT INTO kkl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Winiptaekti Petrusap Yohanesap abeneko enero poa yahiekpa, nimi poloro winiptangkamek nang tanekori sinag hailamsiekti, “Nimi etne mikibag agha? Nimi etne siag agha ulamdomdi, nimi wali nenelamsirom?” aro haibahiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wene aro haibahiekpa, Allah Eldamne Yame Walingeri Petrus wana salero el nongag wa'alamogti, mikipne piamogpa, haibahiekne sembe Petrus sekogti ambarelamsiogti, “Nani yabo nimi nubunangap, nani yabo nimi saelbamsilom nangap, wene na yubu lemnunne ka'eamlulom! ");
INSERT INTO kkl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Sumene nimi yan malinge nhon yepnamne nene wali uanam aghana, 'Ambatsisereng,' aro hailamsilomdi, 'Nimi etne mikibag nimi nene yan wali nembarom?' aro nunag hailamsilom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wene seogti, “A'un Israel nimiap, a'un nimi ni wamlom nimi tane el tahile. Allahri 'Mog so'oag nimi taulbahilulam,' aro webogne Nasaretne poneko si Yesus engeropneag moloro ul tongolamnam. Yesus neneko a'undi kalag sipto olobom aghana, Allahri nimi teptobag agha nen kamag nembao. Kamag nembaonge ponekoag molbanamba, nimi nene wali nembalba, yan wali talne a'un whingag sekamlari wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","12","Nen ambarelamsiogti, “Samenag Yesus anam mangkaek komag Allahri yubuag Yesus sembe mome tobogne ane: 'A'un ae sorop nimiri, “Yangan kirik nubunge nene mali,” aro toboghailum, aghana yangan kirik katne nhonog sunuropne tao,' aro mome tobog. Israel nimi nubunang, ae sorop nimiri yangan kirik katne samenag toboghaiek saog uro Yesus wa'epto toboghaom aghana Yesus neneko Allahri, 'El mori nimi mog so'oag nimi taulbahinep,' aro Yesus yangan kirik katne saog uro wepto sekirog. Nimi mog so'oag nimi malia uroba sembe 'Allahri opsileag,' aro Yesusti taulbahinep. Im tamag mog so'o sirikag-sirikag nimi taulbahinepne ot nhonog si Yesus engeropne wamla. Elag mololamnaba, Eldi nu taulbahinep. Elap sunsunumne nhon wamla kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wene seogpa, nimi yubu tam kareptopnang poloro winiptaek nimi tanekori Petrusap Yohanesap sembe, “Sin mome lerop kom nimi apna, kembiag agha el urop kom nimi sao wamdang. Nubunang ambarelamsirang aghana sin log kom uro lero ulamdang,” sembaekti, “Yaghe, mane agha ulamdang,” alamek. “Yesusap nhon yabalamdongne sin phende,” aro el wamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nimi yan wali taogne neneko sin Petrusap Yohanesap peramag sekamogpa, ibekti, “Nuri sinag sa'a sukap kom,” aro yubu koma wamek. ");
INSERT INTO kkl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wameka, “A'un asag lambalulom,” aro wene seekpa, lambaekpa Yahudi nimi sembe yubu tam kareptopnang Mahkamah Agama nimi mo yubu lelamekti, ");
INSERT INTO kkl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nimi phende abeneri Allah Eldamneri uanepne nimiri uanep komne uarongba, Yerusalem nimi ni el taongba, nuri, 'Sindi lelamdangne orolenange lelamdang,' aro orolenange nuri lemnep kom saog wamla. Ane sembe, nimi abeneag nuri sa'ange agha ambatsukap? ");
INSERT INTO kkl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sindi alnibarongne nene nimi maiknori ka'ebaikpa, nubu taleag, nimi abeneag walamsiberi, '”Allahri nia mangkina si Yesus poneko saeag nembao,” aro ambatsiseng kom,' aro yubu mikip uro wembahukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wene seekti, sin abenekoag “Wa'al alulom,” aro yopsiekti, “Yesus sembe ambarelamsiromne sik komne ambarelamsirom. Nimiag yubu lelamtumundi, 'Allahri nia mangkina si Yesus poneko saeag nembao,' aro ambatsiseng kom,” aro wembahiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wembahiek aghana Petrusap Yohanesapti, “A'undam nimiri wanaag agha senaragsu. Nelagha Allah whingag wali: A'un yubu mombolag wamukap to, Allah yubu mombolag wamukap to? Allah whingag uaukap sembalomne nelagha wali sembamlom? ");
INSERT INTO kkl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Allahri uaonge sembe nimiag ambatsibe tanena Allah whingag wali. Ane sembe aoag agha ka'ebabori, haingdi babe ibobonge nene sembe nimi ambatsin koma wamnep kom,” serek. ");
INSERT INTO kkl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Wene serekpa, tam kareptopnang taneko yubu lenne orog. Yubu mikip uro sin phende abeneko wembahiekti, “Pururom,” aro yag lambahiek. Nimi wali nembarekne neneko ibekti, nimi maiknori Allah omeklamek. Tam kareptopnangdi Allah omeklameka ipsiekti, sindi, “Sin phendeag huaukap,” alamek. Allah omeklameka ipsiekti, tam kareptopnangdi “Logti tam lolohinne orogti,” lipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lipsieknena, nimi yan malinge wali nembarek nimi eneko mangkaekne heng kun yag tangom kom tangom alamogha teng nhon eptopne naualbare (40) taogpa, Allah Eldamneri uanepne saog uro wali nembarekpa, tam kareptopnangdi “Uaukap” sembaekne, “Tam lolohinne orogti,” lipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petrusap Yohanesap “Pururom,” aro sae lipsiekpa, sikinkaboag pirekti, memnang Allah sembe pairopnang sikindo yaboap, Yahudi nimi sikini yaboapti lebekne “Nunag undo-undo wene seangdi, wembahiang,” aro sikinkaboag ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ambatsirekpa sikinkabori ka'ebaekti, sin ma'aptangto Allah omekto mololamekti, “Nuni Allah nia mangkina saelbamlamne, Andi imap, so'oap, magap nia mangkina ni Andi sumbalum. ");
INSERT INTO kkl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Andi Andamne Yame Walinge neneko Andi arukna nuni Daud pere agha elag piplumne ambatsiogne ane, 'Yahudi sisa kom nimi Allah omektop kom nimi tala-tala wamangneri sa'ambe yanghang alamsiang? Sa'a sembe as tala-tala wamangneri, “Undo-undo uaukap,” senelamangdi lelamang aghana, uro yabilul kom? ");
INSERT INTO kkl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nuni Allahri “Taulbahimendi, saelbamsululam,” aro wepto aogne ot nhon. Allahri wepto aog aghana mog so'oag yubu sia leropnang tanekoap, sikin tamag salehiropnangapti, “Karong,” aro poloro winilamang. Poloro winilamangdi, Nuni Allahap, Eldamneri wepto aogneap “Mal tabaukap,” aro yin singilamsiangdi, wamang,' aro Daudti samenag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Samenag ambatsiogne sunsunum uro sik uro yabiog. Anme sol walinge Andi “Taulbahilulam” aro wepto alumne Yesus neneko 'Obukap,' aro Herodesap, Pontius Pilatusap, Yahudi sisa kom nimiri Allah omektop komnangap, Israel nimiap, as eneag poloro winiptaong. ");
INSERT INTO kkl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sin winiptaong nimi tanekori 'Uaukap,' sembaongdi, ulamongne, An Sae Mikipne nenekori samenag agha 'Wali undo uaukang,' sembalumne saog uro ulamong. ");
INSERT INTO kkl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wene Nuni Allah, Yahudi nimi tam kareptopnang taneri nu Yesusag 'Sikne' aro seneragtop nimi sembe 'A'un opsukap' alamang. 'Opsukap,' alamangdi, walamsiangba nu Andi kembahi. Nuri 'Anenge yubu log kom uro ambarelamsukap,' aro An arukna wamapne tane mikip nembahi. ");
INSERT INTO kkl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Anme sol walinge si Yesus nenekoag mololamebeba, 'Yesus Allah Elmeag mololamangba, Allahri sin pere agha ual,' senenne kekneba nunag piplulam. An sae pelengkamendi yepsimenba, nimi niktopne wali nenelamseberi, nimiri uanep komne, Allah Eldamneri uanepne yogne ulamukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wene aro Allahag omekto mololamekpa, sin poloro wamekag aneko sa'uma saog uro Allah Eldamne Yame Walingeri sindi wana salero nongag wa'isiogti, mikipne pipsiog. Mikipne pipsiogpa, Allah yubu log kom uro ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesusag “sikne” aro seneraglamek nimi taneko wana ot nhonog uro sin ma'aptangto wamek. Ma'aptangto wamekti, nimi nhondinge saeag agha ua ulamogha, “Andinge naringe” sen koma, “Nuringe aghabog” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Allahri, “Nimiag lag pho'oro ambatsululom,” aro mikip nenelamsiogpa, Yesusti wepto pogsiognangdi, “Nu salehiropne, Nuro Yesus Allahri kamag nembaonge ibobo,” aro sol wali uro ambarelamsiek. Sin ni tanekori, “Allahri to'opto o'ona sembamsil,” senelamekti, o'ona senel talamek. ");
INSERT INTO kkl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Senel talamekti, sin ni taneko nhon babe sae agha elenge orog uro wamek kom. Yesusag “Sikne” aro seneragtop nimi taneko anabiag awe ae ngai nimi wamek. Sikinenge awe ae ngai nimi tanekori nimi yogneag awe ae tarelamsiekti, kal ma'al tolamek. Kal ma'al tolamekne Yesusti wepto pogsiognangdi saeag aghabog nenelamsiek. Yesusti wepto pogsiognangdi saeag aghabog nenelamsiekpa, sindi nimi tipto kwema ua ulamsiogha uro tarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nimi nhon si Yusup, Yesusti wepto pogsiognangdi Barnabas engkaekne, “Wana aingnihinne,” aro engkaek. Elna sisa Lewinge mog so'o Siprusne wamog. ");
INSERT INTO kkl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","El nenekori so'o eldamneringe nimiag kamna tobogti, so'o kamna kal ma'al tareka aneko Yesusti wepto pogsiognangdi saeag nenel aog. ");
INSERT INTO kkl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nimi kabuni nhon si Ananias, elkel Safiraap wamdek. Wamdekti so'o sindinge nhon nimiag tatsirek. So'o tatsirekne sembe kamna tatsiekpa, kal ma'al toptek. ");
INSERT INTO kkl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Toptekti kal ma'al so'o kamna tatsiekne taneko sembe Ananias elkel Safiraag ambarelamogti, “Kal ma'al ane luluro piro anun,” aro ambarog. “Luluro piro anun,” aro ambarogpa, elkel sae saekag agha Ananiasti nenne luluro pil tolamogti, nenne pogto, “Yesusti wepto pogsiognangdi saeag nenel anun,” aro pil piog. ");
INSERT INTO kkl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pil piogpa, Petrus nenekori Ananiasag, “Ananias, phiari wana sao kauplangkelba, Allah Eldamne Yame Walinge whingag orolena sa'ambe ualam? Orolena lelamlamdi, so'o sembe tatkeangne pogto sa'a sembe tognoro pairo alam? ");
INSERT INTO kkl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","So'o anena anenge, anam kamna kapto tomna komagna. Kal ma'al babe anenge kamna kaplamdi, toplamag babe. Tam ane anba andi saeag wamla. Aghana sa'ambe an wanaag orolenange seneraglam? Nimiag orolenange ua alam kom, anena Allahag ua alam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wene alamogpa, Ananias ka'elamogti abeneko pere, so'oag malingkina Ananias tebaog. Tebaogne sembe nimi ni ka'ebaekti, log maikno senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tebaogpa kabuni mabo etbarero yingkina nimi teptoba aneko kaupto poa lambaekti, so'oag sikil piek. ");
INSERT INTO kkl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sikil pina yalamek abeneko Ananias elkel ela'ange tebaogne ekon uro yaogti, wa'al aog. ");
INSERT INTO kkl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wa'al aogpa, Petrusti elag hailamogti, “So'o aneko sembe kamna kapto toptoma ana'angeri kal ma'al payalnena abene te? Andi babe ambatne,” seog. Seogpa kelenekori, “Otsik uro ni so'o kamna kal ma'al tatsiongne payal abene,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wene seogpa, Petrusti, “A'un phende sa'a sembe 'Nuni Allah Yame Walingeag orolenange ambatnemeri, mipnunam,' aro yubu nikne leptom? Nimi ana'ange sikil piang nang taneko ina siramag yaangdi, an keyapto 'Poa lambaukap,' aro wamangba kembahi,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wene alamog abeneko Petrus whingag malingkina tebaog. Nimi kabuni taneko aeag wa'iekti, keleneko teptoba kembaekti, keyapto poa lambaekti, ela'ange sikeka peramag aneko elkel babe sikek. ");
INSERT INTO kkl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Undo unu aogne sembe nimi Yesus yubu ka'ero winiptangtop nimi ni log maikno senelamek. Tebarekne sembe ka'ebaek nimi yogne babe ni log maikno senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesusti wepto pogsiognang tanekori Allah Eldamneri uanepne nimiri uanep komne ulamekti, “Yaghe, Allahri sin pere agha ual” senenne kekneba maikno nimi maikno whingag ulamek. Undo unulamekpa, nimi Yesusag “Sikne” aro seneraglamekne taneko sin ma'aptangto wamekti, Allahri Ae aramag “Salomo” engerobag sip imag agha solorobag aneko haibil talamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Haibil talamekpa, nimi orange maiknori Yesusag “sikne” aro seneraglamek nimi sembe, “Wali,” aro maiplamsiek. “Wali,” aro maiplamsiek aghana, log uro seneraglamekne sembe, maiplamsiek nimi taneko agha, nhon babe Allahri Ae aramag ma'al tan anag yalamek kom. ");
INSERT INTO kkl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Log uro seneraglamekti, yalamek kom aghana, kaubuniap kelaboap Yesus sembe el talamekti, Yesusag “Sikne” aro seneraglamekti, Elag “Saelbamsululam,” alamek. “Saelbamsululam,” alamekti, samen Yesusag “sikne” aro seneraglamek nimiap ma'al talamekpa, maikno talamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yesusti wepto pogsiognangdi nimi maikno wali nenelamsiekne taneko sembe nimi tanekori nimi niklamekne Petrus ina palamoghag nimi niktopne ae usa yangal pina pia ulamsiek. “Petrus yabalogleri eldi yameri olog po'obahileba, wali taukang,” aro manal pina ulamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Manal pina ulamsiekpa, as Yerusalem kanero wamek nimiri niklamekneap, phiari loba nenelamsiog nimiap enero payalamsiekpa, sin ni Yesusti wepto pogsiognangdi whelamsiekpa, wali talamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kemelamsiekpa Yesusti wepto pogsiognangdi “Yaghe” senenne maikno ulameka sembe memne Allah sembe pairopnang sikini nubungeap, el neleptop nang Saduki nangap, “Nubunang talamang,” aro sin wana yo senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sin yo senelamekti, Yesusti wepto pogsiog nimi taneko salero kop aeag tobongkahiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Aghana inipnag Nuni Allahri Eldamneri arukna malaikat poghogpa, kulukul aogti, kop ae ina siram taneko kupto lanalamsiogti, “Pimundi, Allahri Ae aramag sekapmundi, Allah yubu nimi maiknoag ambarelamsimundi, 'Yesusag “sikne,” aro seneragtop nimi tebale tanena kamag tanep,' aro ambarelamsululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sin wene aro ambatsiog yubu eneko ka'ebaekti, lukunap Allahri Ae aramag wa'iekti, Yesus sembe yubu ambarelamsiek. Ambarelamsiekti wamekpa, memne Allah sembe pairopnang sikini nubungeap, el neleptop nangapti Yahudi nimi sembe yubu tam kareptopnang Mahkamah Agama nong nimi nubunang poloro wimbahiek. Poloro wimbahieknang tanekona ni Israel nang sikini yabo poloro wimbahiek. Wimbahiekti, “Yesusti wepto pogsiognang abeneko kop aeag tol phululom,” aro arukahiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wene aro arukahiekpa, Allahri Ae yae ua urop nang “Nimi tol phukap,” aro piek aghana, nimi tanekori kop aeag aneko kemelamsiekag agha sin orog wamek. Orog wamekpa, kembahiekti nen samoro Yahudi nimi sembe yubu tam kareptop nangag ambarel phiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ambarelamsiekti, “Nu piapti, kop aeag pina kemelamabag agha ina serekna wali maupto serektop, nimi babe kop ae yae ua unnang ina siramag yae wamang. Wamangba ina serekna kubiagha wa'alamabag agha nimi nhon babe ae lomag una wamang kom,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wene aro ambatsieka ka'ebaekti, Allahri Ae yae ua urop nang yin saleropnang sikindoap, memnang Allah sembe pairopnang sikindo yaboap wana sao kaupsiogpa, amik tanepne sembe log senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Amik tanepne sembe senelamekti wamekpa, nimi yubu poa yaogti ambarelamsiogti, “Nani yabo, Nimi a'undi kop aeag tobongkipsiom nimi abeneko wene Allahri Ae aramag nimi yubu ambarelamsiang,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wene aro yubu poa piogne neneko ka'ebaekti, Allahri Ae yae ua uropnang sikindoap, el sembe yae ua urop nang yin saleropnangap piekti, Yesusti wepto pogsiognang abeneko Allahri Aeag aneko oro kom-kom wali uro tol phiek. Oro kom-kom wali uro tol phieknena, “Yesusti wepto pogsiognang olamsibe tanena, nimi wamang nimi taneri kirikti nu opsiikag,” aro log sembaekti, wali uro tol phiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tol phiekti, Yahudi nimi sembe yubu tam kareptop nang Mahkamah Agama wimbahiekag poa wa'isiek. Wa'isiekpa memne Allah sembe pairopnang sikini nubunge ponekori tam sinag palilamsiogti, wenelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“'Yesus siag nimi yubu ambatsiseng kom,' aro mikip uro a'unag ambatsibo. Aghana wenena sa'a agha ulamlom? Wene, 'A'undi ambatsiseng kom,' sebo aghana Yesus poneko sembe ambarelamsilomdi, yubu eneko nubu nenero Yerusalem sabo tao. Wene a'un Yesusti wepto pogsiog nangdi nu Yahudi nimi nubunang sembe lelamlomne, 'A'undi ulamomba, Yesus eneko tebao,' alamlom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wene seogpa, Petrusap elkabo Yesusti wepto pogsiognangapti, “Allahri leropne agha sik sembanepti sarenelebel pinep. A'un Yahudi nimi nubunangdi leplomne nuri sarenelebanep kom. ");
INSERT INTO kkl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesus a'undi kalag siplobomdi, ya'ag olobomba, tebaonge neneko Allah nunisangdi omeklamekne ponekori nimi teptopne urobag agha kamag nembao. ");
INSERT INTO kkl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","El neneko Allahri “Israel nimiri malia ulamangne lipsiikpa, tam orog nembanun,” aro Yesus paliag nembao. “Nandamne sae sirik sip nimi nubunge sunsunum urobag wamlulam,” aro paliag nembao. Allahri Yesus paliag nembaoba, Allah sae sirik sip wamla. Allahri, “Israel nimi salehiropne talulam,” aro Yesus toro sekiro. Toro sekiroba, 'Israel nimiri malia uroba sembe Allahri opsileag,' aro Yesus taulbahiropne tao. ");
INSERT INTO kkl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Allahri uaonge sembe el tabori, nuri nimi ambarelamsiap. Allah Eldamne Yame Walinge neneko El yubu ka'ero ua urop nimiag tarelamsilne nenekori babe nimi ambarelamsil,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wene aro Petrus elkaboapti ambarelamsieka ka'ebaekti, sin wanaag aluklamsiogpa, “Yesusti wepsiog nimi taneko opsukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wanaag agha “Opsukap,” senelamekpa, Farisinge nhon si Gamaliel wamog. Gamaliel poneko Musari samenag mome tobogne sembe ambarelamsiog. Musari samenag mome tobognena, Allahri “Undo-undo tam kareplamlulom,” aro Musa ambatsiogpa, Gamaliel el wamogti, ambarelamsiog. Wamogti ambarelamsiogpa, nimi ni tanekori maiplamek. El neneko Yahudi nimi sembe yubu tam kareptopnang Mahkamah Agama anabiag wamogha sekogti, “Yesusti wepto pogsiognang poa lambahilulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wene seogti, Gamalieldi, “Sae lobitsukap,” aro Yahudi nimi sembe yubu tam kareptop nimi wameka tanekoag ambarelamsiogti, “Israel nimi nangkabo, 'Nimi tane obsukap,' sembaloma wali uro tam o'obiagha ualulom. ");
INSERT INTO kkl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nimi phende samenag wamdekne sembe seneragsumundi, el talulom. Nimi nhon Teudas neneko, 'Na nubunge paliag wamna,' aro sekogne seneragsu. 'Na paliagne wamna,' alamogpa, nimi elag sare neleptopne teng-tengne (400) tanekori el yubu ka'elamek. El neneko nimiri obekpa, Teudas yubu ka'elamek nimi taneko tala-tala taekti, unulamekne neneko lipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teudas neneko obekpa, tebaogpa, wamek. Wamekpa, nimi si tolamsiek liag Yudas Galileange poneko babe walel ingkiog. Yudas wamog liag babe nimi maikno elag sare neleptop nimi wamekne elag sip taekti, “Roma nimi mombolag wamukap komdi, sae lipsukang,” aro yin salelamek. Yin salelamek aghana, nimiri Yudas ya'ag ologhekpa, elag neleptop nimi taneko oro nelepto tala-tala nembahiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Ane sembe nari a'unag lelamnange, nimi taneag sa'a-sa'a ualulom kom. Teudasap Yudasap tebarekne sembe ambatsin. Sin abeneko saog uro, Yesus yubu ka'ero sareneleptop nimi mo seneragtopneag agha, 'Uaukap' sembamangdi, ulamang tanena, sa'a-sa'a ulamangne kom tanep. Aghana, sindi ulamangne nene agha Allahri seneropneag agha ulamang tanena a'undi nimi, tanena kom nembahilulom kom. Ane sembe sae lobitsululom. A'undi ulamlomne nene agha 'Allah luknubaukap,' aro ulapmunag wali uro kembiagha seneragmundi,” aro ambatsiog. “Gamalieldi wene seogne sik,” aro el yubu ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wene aro ambatsiogpa, “Yesusti wepto pogsiog nimi taneko wa'al aukang,” seekpa, wa'al aekpa, sae kaupto taeplam-taeplam lopsiekti, “A'undi, 'Allahri nia mangkina si Yesus poneko saeag nembao,' aro nimi ambatsiseng kom,” aro ambatsiekti, sae lipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wene aro sae lipsiekpa, Yesusti wepto pogsiog nimi taneko yubu tam kareptobag anekoa lambaek. Lambaekti, Yesusti wepto pogsiognangdi seneraglamekti, “Yesusti nunag arukahiori, 'Pimundi, Nanag uro yabiogne sembe ambarelamsululom,' aro arukahiog. Nunag arukahionge sunsunum uro “Yesus si nubu talul,” aro sol wali, wali uro ambarelamsiapne sembe nimiri nu sae kaupto taeplam-taeplam lopsiangba, ali nembahiang. Ali nembahiangba, seklelamap aghana, Yesusti nunag arukahionge sunsunum uro sol wali, wali uro sik uro ambarelamsiapne sembe Allah nu sembe yeng senelamla. Ane sembe ali nembahiang aghana, Allahri nu kembamsilne sembe, nu babe yeng senelamap,” aro seneraglamek. Undo seneraglamekti, sin awi yeng uro lambaek. ");
INSERT INTO kkl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lambaekti sop-sop Allahri Ae aramag yubu ambatto, nimiri aeag ambatto, Allahri, “Mog so'oag nimi taulbahimendi, saelbamsululam,” aro Wepto Poghol aogne Yesus sembe Yubu Walinge ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wamekti Yesus yubu ka'elamekne sunsunum uro ulamek nimi, nimi maikno talamek. Maikno talamekti, Yahudi nimi wamek aghana sin nusamag agha Yunani yubu lerop nimi babe wamek, Ibrani yubu lerop nimi babe wamek. Yahudi nimi Yunani yubu lerop nimi wamekneri Yahudi nimi Ibrani yubu lerop nimiag wana mali palilamsiek. Yunani yubu lerop nimi tanekori lelamekti, “Ibrani yubu lerop kelabo yauog taekne babe, Yunani yubu lerop kelabo yauog taekne babe kwaneng tatsinep. Aghana, kal ma'al yepna sop-sop yeplamsiloma kelabo kaldam kelabo nu Yunani yubu lerop nimiringe olog tarelamsilom kom,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wene aro Yunani yubu lerop nimiri lelamekne sembe, Yesusti wepto pogsiog nimi aobare nang enekori Yesus yubu ka'ero ulamek nimi poloro wimbahiek. Poloro wimbahiekti, yubu ambarelamsiekti, “Nu kwaneng tenaba sembe nimi o'olamsiberi, Allah yubu nimi ambatsin koma libeberi, tenaba sembe ulamebenge nenena mali. ");
INSERT INTO kkl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ane sembe nangkabo, nimi saekpare wepsululom. Wepsululomnena, Allah Eldamne Yameri seneragna sunsunum uro wanaag seneraglamangdi, wana maro hekto seneraglamangdi, walia ulamangba ililamsilomne, sin nusamag agha nimi saekpare wepsululom. Wepsimunba, 'Sol wali, wali uro kwanengap, kal ma'alap kelabo yauog taekne nika-nika uro tarelamsululom,' aro nimi saekpare abenekoag ambatsiberi wepsukap. Wepsibeba, sindi saelbamikti, nimi yeplamsukang. ");
INSERT INTO kkl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nimi saekpare wepsimunne tanekori nimi tenaba saelbamikpa, nu Yesusti wepto pogsiognangdi sop-sop Allahag molona lelameberi, Allah yubu tibin nenero ambarelamsukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wene seekpa, nimi wamek nimi tanekori “Wali” seekti, nimi weplamsiek. Weplamsiekpa, nimi nhon sina Stefanus webek. Stefanus ponekona, Allah Eldamne Yame Walingeri Stefanus nongag mikipne to'opto piamogpa, Stefanusti wanaag seneraglamogti, “Yesus sik uro Allahri 'Taulbahilulam,' aro wepto poghogne,” aro mikip uro seneraglamog. Yesusag “sikne,” aro seneraglamogne Stefanus webekti, nen weplamsiekti, Filipusap, Prokhorusap, Nikanorap, Timonap, Parmenasapna, Nikolausap wepsiek. Nikolaus poneko samenag Allah omeklamog kom aghana Yahudi nimi saog uro taogti, Allah omeklamekne saog uro el babe Allah omeklamogne taog. Elna as Antiokhia agha, “Na babe Yahudi nimiri omeklamangne Allah omeklamnun,” aro yingkina wamog. ");
INSERT INTO kkl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nimi Yesusag “Sikne” aro seneragtop nimi taneko ni wamekneri nimi saekpare abeneko wepsiek. Wepsiekti, Yesusti wepto pogsiognang enekoag pil phiekpa, Yesusti wepto pogsiognang enekori “Allahri mikip nembahileba, kwaneng pogto kelabo yauog taekne yeplamsumuna sol wali, wali uro saelbamlulom,” aro Allahag molona lero usoghag sae pipsiek. ");
INSERT INTO kkl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wene aro tenaba sembe awe tona sin saekpare nangag pibekti, Yesusti wepto pogsiognangdi Allah yubuag agha Yesus sembe tibin nenero ambarelamsiek. Tibin nenero ambarelamsiekpa, yubu eneko tala-tala nubu talamogpa, Yesus yubu ka'ero ulamek nimi as Yerusalem maikno talamek. Memnang Allah sembe pairopnang babe maiknori Yesus sembe el talamek. El talamekti, “Yesus ponekona, Allahri 'Malia ulamangne sembe “Opsineag,” aro taubahilulam,' aro wepto poghogne,” aro seneraglamekti, ma'al talamekti. ");
INSERT INTO kkl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus neneko Allahri mikipne elag to'opto palilamogpa, nimiag walia ulamsiogti, “Yaghe, Allahri el pere agha ual” senenne kekneba nimiri uanep komne, Allah Eldamneri uanepne nimi maikno whingag Stefanusti ulamog. ");
INSERT INTO kkl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Stefanusti undo unulamogpa, Yahudi nimi nusamag agha Libertini aldalamek nimi babe wamek. Libertini aldalamek nimiri Allah yubu lerop ae nhonag ma'al dalamekti, sina Libertini Allah yubu lero omektop ae engel dalamek. (Libertini aldalamek nimi anena, “'Nu samenag nimi arukna wamubu aghana sae lobitsiekpa, wamap,' aro urop nimi,” aro engel dalamek. Sin tanekona, mog so'o Kirene nimiap, as Aleksandria nimiap, mog so'o Kilikia nimiap, mog so'o Asia nimiap babe wamek.) Libertini nimi tanekori, “Stefanusti Yesus sembe nimiag ambarelamsilul kom,” aro Stefanusap yubu yo uro lel talamek. ");
INSERT INTO kkl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stefanusap yubu yo uro lel talamek aghana, Stefanusag Allah Yameri mikipne piamogpa, wana hekto yubu lelamogti, tibin uro ambarelamsiogpa, sindi samoro elag yubu lemnep kom wamog. ");
INSERT INTO kkl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sindi samoro elag yubu lemnep kom wamogpa, Libertini nimi tanekori haing kunuro nimi orangeag wana tolamsiekti, “Stefanusti ambarelamsilne nu karong. Ane sembe, nimi ambarelamsululomne, 'Stefanusti Musa san tiliptop yubu lebori, Allah babe san tiliptop yubu lebo,' aro orolena yubu ambarelamsululom,” aro wana toro ambatsiek. Libertini nimiri wene aro wana toro ambatsiekpa, nimi orange tanekori, “Wali, ambarelamsukap,” seekti, “Nu aori ka'ebabongena, Stefanusti Musa san tiliptop yubu lebori, Allah babe san tiliptop yubu lebo,” aro orolena yubu lero ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wene aro orolena yubu lerop nimi tanekori ambatsiekpa, nimi maiknori ambatsiekne ka'ebaekti, “Stefanusti mali ulamlaba, saelbaukap,” aro wanaag meso yalikahiog. Wanaag meso yalikahiogti, as Yerusalem wameknangap, Yahudi nimi nong nimi nubunangap, Musari samenag mome tobogne ambatsiropnang tanekoap piekti, Stefanus salel pina Yahudi nimi sembe yubu tam kareptop nimi Mahkamah Agama haiptangtobag payaek. ");
INSERT INTO kkl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yubu tam kareptop nangag payaekti, Libertini aldalamek nimi enekori yubu loloro lerop nimi babe pabiek. Libertini nimiri yubu loloro lerop nimiag ambarelamsiekti, “Ambatsululomne, 'Stefanus eneri nu haingag wene alamo,' sululom,” seek. Wene seekpa, yubu loloro lerop nimi tanekori orolena ambarelamsiekti, “Stefanus eneri sop-sop sinag kweleknag lelamori, 'Allah Eldamne Mem Ae loba tao,' seo. Apna, Stefanusti lelamori, 'Musari samenag Allahri “Undo ualulom,” aro ambarogne sembe mome tobogne babe loba tao,' seoba, aori ka'ebabo. ");
INSERT INTO kkl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Stefanusti yubu lebonge nu ka'ebabongena, 'Yesus Nasaretne ponekori Allahri Ae ene kwerek alul. Tanena, Musari samenag ambatsiogpa, saelba ulamapne orog nembaleri, wendogne nhon lag nembalul' seo,” aro wene seek. ");
INSERT INTO kkl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wene aro orolena yubu lebekne sembe Yahudi nimi sembe yubu tam kareptop nimi Mahkamah Agama haiptangtobag wamek nimi tanekori Stefanusti whingag tilamek. Whingag tilamekpa, kembiag agha Stefanusti whing Allah arukna malaikatti whing saog taog. ");
INSERT INTO kkl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Memne Allah sembe pairopnang sikini nubunge ponekori hailamogti, “Sindi lebangne sik te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Haibaogpa Stefanusti, “Nangkabo, nani yabo ka'eamsu! Anam nunisang Abraham Kharan pin komag Mesopotamia wamogpa, Allah warero libango aropne Abraham wamoghag lag taog. ");
INSERT INTO kkl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Lag taogti, Allahri yubu lelamogti, 'Anenge mog so'o asag agha lambamendi, ankabo laploa Nari mog so'o nhon ambatkenenge nhonag pululam,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Allahri Abrahamag wene seogpa, Kasdim nimi mog so'o laplobi agha as Kharan piogti wamog. As Kharan aneko wamogpa, Abraham ili tebaogpa, Allahri lebogha sunsunum uro nu Yahudinang wamap so'o eneag Allahri Abraham payaogpa, Abraham wamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","'Pululam,' seogpa, yaoghag ane, 'So'o ologha babe an ngai talulam,' ana babe kom. 'Ot anap andi mangarobari mangaroba mangkahyikneap amik ngai talulom,' aro Allahri Abrahamag salag lero ambarog. Abene li elmabo babe nhon wamna komag, oroghag agha ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ambarogti nen Allahri Abrahamag yubu lelamogti, 'Andi mangorabari mangaroba mangkahyikne nimiri so'oag nimi sekelanan nang saog uro nimiri so'oag wamukang. Wamikpa so'o eneko nimiri sinag heng tai buka tau buka ulamlea teng-tengne (400) wamikpa, so'o eneko nimiri olamsiikti, aruklamsiikpa, ikinaba maghan og uro polamukang. ");
INSERT INTO kkl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nimiri so'oag aneko arukna nembamsiikpa, “Olamsiik nimi taneko sindi ulamikne mali,” kembaneri, Nari tam karebiagha lunuro obahinun. Obahineba, anisag yabo lambaikti, mog so'o Yerusalem ane Na omekanukang,' aro Abrahamag Allahri ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ambarogti, Allahri Abrahamap yubu nikne lero salag palilamogti, 'Nari salag palilamnange nene ekon tan koma el uro wamlulom aro anap, anmaboap nengabo niap nengabo kon karebel dalamlulom,' aro yubu nikne lero salag pibog. Abrahamdi elme Ishak mangaro aogti, 'Allahap nari mangarobari mangaroba mangkahyikneap ma'aptanumunge ekon taikag,' aro ae ik lin sum Allah ambarogne sunsunum uro elme Ishak nengabo kon karebaog. Abrahamdi Ishak mangkaogpa, Ishakti Yakub mangkaogpa, Yakubti kongap nang a'obare mangkahiogpa, sindi nimi sisa a'obare likto piekti, nunisa yabo nubunang taek,” Stefanusti ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Stefanusti nen tipto ambarelamsiogti, “Nunisa yabo a'obare nubunang enekori sikinipsae Yusup sembe, 'Nuni Yakubti nu sembe olog uro o'ona senelamsildi, elme Yusup sembe agha maikno o'ona senelamla,' aro wana mali senelamek. Wana mali senelamekti, 'Mesir nimi arukna talul,' aro eldoyabori kamna kapto tobek aghana, Allahri sikinipsae Yusup yepto piamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yepto piamogti, tam malinge elag uaekne orog nembaogpa, Mesir nimi sembe yubu sia leropne Firaunag yaog. Elag yaogpa, Allahri Yusup yeplamogpa, wana seneragna heklamogpa, Firaundi Yusup sembe 'Wali uro awe tolamla,' aro awi senelamog. Yusup sembe awi senelamogti, Firaundi 'Mesir so'o saelbamlulam,' aro towalengkaogpa, Yusupti Mesir so'o saelbamog. Mesir so'o saelbamogpa, Firaundi aeag uropne babe, Firaun el tamag awe toro ulamekne babe, 'Pia ulamlulam,' aro Yusup saeag nembaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Towalengkaogpa wamekpa, Mesir so'oag babe, Kanaan so'oag babe, kwaneng yo nubunge waelbaogpa, kwaneng yo seklelamek. Kwaneng yo seklelamekpa, nunisa yabo Kanaan wamekne babe kwaneng telamek kom. ");
INSERT INTO kkl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Unu amogpa, 'Mog so'o Mesir kwaneng telamang,' ana Yakubti ka'ebaogti, nunisa yabo nubunangag 'Mesir kwaneng tol pululom,' aro pogsiog. Pogsiogpa, sin sumene alnirop sum 'Kwaneng tobukap,' aro piekti, kwaneng samoro payaekti, olog wamek. ");
INSERT INTO kkl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nen ik phendep sum babe piekpa, Yusupti, 'Na a'unipsae wamna,' aro eldo yabo ambatsiogpa, Firaun babe Yusup ili eldo yabo wamekne sembe el taog. ");
INSERT INTO kkl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","El taogpa Yusupti iliap, eldo yabori maboap kelaboap, 'Na ya'aghag yalulom,' aro yopsiogpa, ili Yakubap nhon yaek nimi taneko teng phende eptopne saektara bare (75) yaek. ");
INSERT INTO kkl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mog so'o Mesir piekti wamekpa, Yakub tebaogpa, nunisa yabo nubunang babe wamekti tebaek. ");
INSERT INTO kkl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nunisa yabo nubunang teplameka Sikhem poa pina sikil palamsiek. Sikil palamsiekag samen Abrahamdi kamna kapto Hemor elmabo saeag agha kal ma'al kirik wana solomneap ag agha toboghag aneko Sikhem mog so'oag kirik arameag sikil palamsiek,” aro Stefanusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stefanusti nen tipto ambarelamsiogti, “Allahri Abrahamag salag lebogne neneko, Israel nimi Mesir wamekne maikno tangto palamogpa, Allahri salag lebogne sunsunum uro pinepne peram talamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Peram talamogpa, Mesir nimi yubu sia leropne Yusupti uaogne ekonne nhon mog so'o Mesir saelbamsinepne waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Waelbaogne ponekori nunisa yaboag orolenange lero unulamsiogti, 'Maikno taikag,' aro sin aruklamsiogti, 'A'undi mabo maghag tobogsiro sin ohiro ulamlulom,' aro aruklamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Undo unulamog li eneag Musa mangaptaogpa, Allahri Musa sembe 'Wali,' senelamog. Ili ilindi aeag wal wilindi tognoro mo'oro piamdek. ");
INSERT INTO kkl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wal wilindi taogpa, mag abolag pabiogti, pibog. Pibogpa, Firaun elmangkeldi me aneko ibogti, tobogti, eltangkeldi me saog uro mo'ol tolamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa neneko Mesir nimiri nia mangkina uropne ambarelamekpa, sindi uropne leropne el talamogti, wana heklamsiog. Musa nenekori yubu lenne babe, nia ua unne babe mikip uro ulamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","El mangkaekne heng tai buka tau buka ulamogha teng nhon epto naual bare wamogpa, 'Nangkabo Israel nimi kemel phinun,' aro wanaag seneraghog. ");
INSERT INTO kkl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kemel phinun,' aro palamoghag agha Mesirne nhondi elkae Israelne nhon tam oroghag agha olamogha ibog. Ibogti, Musari elkae pelepto elkae Israelne ponekoag sip taogti, Mesirne poneko ya'ag obog. ");
INSERT INTO kkl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa eldamne wanaag agha seneragamognena, 'Nangkabo Israel nimiri na sembe wali sembaukang. “Mesir nimiri Israel nimi olamsiangba, Allahri, 'Taulbahilulam,' aro poglange Musa ane,” sembaukang,' sembaog aghana, el sembe undo seneraglamek kom. ");
INSERT INTO kkl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mabogha kwelekaogpa, lukunap Israelnang phende talamdeka kembahiogti, 'Nari ma'abahinun,' aro piog. Sinag piogti, 'Nangkabo, a'unna sa'ambe ol talamdom? A'unna eldo ilipsae saog uro wamdom kom te?' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Seogpa, talamdekti, elkae obogne ponekori Musa wepto pil piogti, yubu lelamogti, 'Etneri, “Nu saelbamsulul,” aro etneri towalengkakeo? Etneri, “tam kareplamlulam,” seori, etneri towalengkakeo? ");
INSERT INTO kkl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ambhum Mesirne obomne neneko saog uro wene na babe omnululam te?' aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wene seogpa, Musa ka'ebaogti, log lelem laplobi agha mog so'o Midian piogti, nimi sekelingkiropne saog uro wamog. Aneko pina wamogti, me nengabo me phende mangkahiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mog so'o Midian wamogpa, hengkun tai buka tau buka ulamogha teng nhon epto naual bare taogpa, ik nhon sum Musa poneko Yim Sinai tamag yabalamogti, pai aldes saog urobag wamog. Yim Sinai tamag yabalamogti, kemelamogpa, Allahri El arukna malaikat poghogne yingkina kal werengkel alog saog kal anekoag auk pog tag-tag alamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musari ibogti, 'Map, maneagha ulamla. Kembanun,' sembaogti, peramag piog. Peramag piogti, 'Kembanun,' aro ulamoghag agha Nuni Allah yubu lilim ka'ebaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Allahri Musaag yubu lelamogti, 'Na Allah, anisang yabori Allah omeklamekne Wamna. Abrahamap, Ishakap, Yakubapti omeklamekne Allah sikini Na wamna,' seogpa, Musa log lelem pet-pet alamogti, whing ebom agha kal werengkel alog kalag auk pog tag-tag alamogha anekoag tibog anep kom wamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Unuaogpa Nuni Allahri nen yubu lelamogti, 'Na whingag ane memag sekamlam. Memag sekamlam ane sembe yan wangana tobongkamlama ane olobalulam,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","'Na Namabo Israel nimi mog so'o Mesir wamangne tiplengelamsinba, whin maikno seklelamangti, “Yaghe” alamangne Na ka'eamna. Na kulukulanne “Sin haing sae lopsinun,” aro kulukulan. Wene Nari an pogkeneba, samoro Mesir pululam,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Samenag Israel nimiri Musa sembe 'Nu karong,' aro wa'epto tobogaekne neneko, 'Etneri, “Nu saelbamsulul,” aro etneri towalengkakeo? Etneri, “Tam kareplamlulam,” seori, etneri towalengkakeo?' seek. Wene seek aghana Allahri El arukna malaikat poglamogti, 'Musaag pimendi, Nari yubu elag tiplulam,' aro poghogpa, Allah arukna malaikat neneko werengkel auk pog tag-tag alamoghag aneko lag taogti, 'Israel nimi saelbamsimendi, haing sae lopsululam' aro Musa poghog. ");
INSERT INTO kkl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musari ulamognena 'Yaghe, Allahri el pere agha ual,' senenne kekneba nimiri uanep komne Allah Eldamneri uanepne ulamog. Mesira, mag longorop mag Uwong Mag Sin agha, pai aldes saog urobag aneko babe ulamogpa, heng kun tai buka tau buka ulamogha teng nhon epto naual bare taog. ");
INSERT INTO kkl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa nenekori Israel nimiag yubu lelamogti, 'Nimi nhon na saog uro Allahri yubu silimu tiplamlulne a'un Israel nimi anabiag agha Allahri sekitlul,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wene seogti, Musa nenekoap nu Israel nimi nunisag yaboap pai aldes saog urobag nhon wamekpa, nunisag yabo poloro winilamekne yim tamag laplobi agha Musa Sinai Yimag waelbaog. Sinai Yimag waelbaogpa, Musa pere agha Allahri El arukna malaikat poghogne nenekori, “Yubu ambatsinne sunsunum uro unulapmundi, Allahap ma'aptangto kamag wamnep,” aro yubu ambarogpa, Musa nenekori nunisag yabo nen tipto ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ambarogne ambatsiog aghana, nunisa yabo eldi lebogne sare nelebaek komdi, wanaag agha 'Karong' aro 'Mesir samoro pukap,' sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wene senelamekti, Harunag yubu lelamekti, '”Musari nu saelbamsioba, Mesira lambabo aghana wela uaori, tala pio,” senelamap. Ane sembe an Harundi saeri sumbatsululama, Nuri phalamsibenge samenag menangal palamikti, nu yeplamsukanga saeri sumbatsululam,' alamek. ");
INSERT INTO kkl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wene alamekti, pham sapi me saog uro sunumna Harunapti sumbaekti, 'Nuni nundam nimiri sumbaba aneri nu piamsilul,' aro awi uro seplamekti, sani yoro telamek. Sani yoro telamekti, sumbaek mema anekoag pham oro aukag taro phalamek. ");
INSERT INTO kkl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Undo mema phalamekpa, Allahri sinag wail ibatsiogti, lipsiogti, 'Sinba, tibin nenenne imag wareropneag phalamik,' aro lipsiog. Imag wareropneag phalamekne sembe babe, Allahri sin wail ibatsiogne sembe babe, Allahri yubu silimu tiptop nimiri mome tobognena: 'A'un Israel nimi hengkun teng nhon epto naual bare pai aldes saog urobag wamlumdi, “Allahag pham oro aukag taro Allah sembe tarelamap,” senelamlum. ");
INSERT INTO kkl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","“Allah sembe tarelamap,” senelamlum, aghana “Mema si Molokh omeklamukap,” aro mema pia urop ae kalun ae kwerekto poa pang-yang ulamlum. Apna “Mema Refan omeklamukap,” aro el kekneba imbrea saogne nimi saeri sunuropne babe poa pang-yang ulamlum. Ane sembe nari popsineri, toboghol pihinebag Babel kauro nimi saeag nenel phinun,' aro mome tobog,” aro Stefanusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","45","Stefanusti nen tipto ambarelamsiogti, “Nunisag yabori anam mema Refanap Molokhap poa pang-yang ulamek komag agha, Mesira lambaekti, pai aldes saog urobag wamek. Wamekpa, Allahri Musaag ambarelamogti, '”A'un nusamag wamneri, piamsineba, omeklamnululom,” aro Allah omektop ae kalun ae nhon sobalulom. Sunumna ambatkenba, kembalam saog uro sunsunum uro sobalulom,' aro Allahri ambarogne sunsunum uro nunisa yabori pai aldesag saog urobag sobaekti, kwerekto poa kwaneng ero pang-yang ulamek. Israel nimiri Allah omektop ae kalun ae eneko kembiag agha, “Allahri Israel nimiap ma'al tanan yubu Musaag ambarogne saekag pibubu mome tobogne kalun ae eneag piameberi, Allahag 'Sikne' aro seneraglameberi, ulamebeba, piamsilul,” aro el taek. Allah omektop ae kalun ae eneko sobaekti, kwerekto poa kwaneng ero pang-yang ulamek. Israel nimi salehiropne Musa tebanep liag, Yosua Musa lunuro waelbaog. Yosuari saelbamsiog li eneko mog so'o wene wamabag payaekpa, mog so'o eneko nimi Allahri talup lambahiogpa, nunisa yabo lelnero wa'iek. Lelnero wa'iekti, sisa nhondi nhon, nhondi nhon pogto mog so'o tobekti, wamek paghabog Daud waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nunisa Daud poneko sembe Allahri sembaogne ane, “El wana lag phoropne,” aro awi sembaog. Daudti Allahag mololamogti, 'Ae nhon Yakubti omeklangkeogne poneko ua unag sembe sobaghenun,' aro molbaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Molbaogpa Allahrina, 'Molbanelam aghana andi sobalulam kom. Anme Salomori Nari ae sobalul,' seogpa, sobaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sobaog aghana, nimiri saeag agha 'Allah tane wamlul,' aro sorop ae enekoag aghabog Mikip Phelektopne Imag wamlange wamnep kom. Samenag babe Allah Eldamneri yubu silimu tiptopneag ambarogpa, ambarogne sunsunum uro mome tobogne ane: ");
INSERT INTO kkl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nuni Allahri lelamognena, 'Na pukamneri, nimi ni saelbahinuna sunsunumag aneko im tiwalengka ulamlomne saog wamla. Imag pukamnari, Na yan pelengka unag aneko sao mog so'o ni wamla. Na ua ulamnaba, imap so'oap to'op tal ane sembe, a'undi, “'Allah wamlulaag,' aro ae soro pibukap,” sembamunne, welaro ae sobalulom? “Allah tane wamnebag,” sunsunum urobag tala wamlul sembamlom? ");
INSERT INTO kkl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na nadamne saeri nia sumbahi,' aro Allahri Eldi yubu silimu tiptopne pere agha ambatsiog,” Stefanusti wene aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Wene seogti, Stefanusti eldamne yubu agha nen tipto tam kareptopnangag ambarelamsiogti, “A'un usog mikip nimi. A'undi nengabo kon kareptop nimi aghana Allahri, “Ma'ap taukap,” aro lebogne ingkisaplamlom. Allahri samenag, “'Na Allahri Israel nimiap ma'ap tabunge ekon taikag,' aro nengabo kon kareplamlulom,” aro lebogne a'ori ka'ebalum aghana wanaag seneraglamlom komdi ekon talamlom. A'undi Allah Eldamne Yame Walinge sop wailag nenero wa'eplamlom. Nu Israel nimi nunisa yabori ulamek saog uro wene a'undi babe ulamlom. ");
INSERT INTO kkl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nunisa yabori Allahri yubu silimu tiptop nimi ni mali-malia nenero 'Seklebaik,' aro ulamsiek. Unulamsiekti, nimi sikne yanepne sembe ambarelamsiekne ya'ag olamsiek. Samen abonogho wene a'undi babe nimi sikne yaonge eldamne Yesusag wabe kolaglo saog uaomdi, obom. ");
INSERT INTO kkl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Allahri el arukna malaikat pogsiogpa, nunisa Musaag yubu ambarekpa, el pere agha Allahri lebogne, 'Undo ulamlulom,' aro arukahiogne ka'ebaom aghana yubu arukto ambatsiogne ingisaplamlom. ");
INSERT INTO kkl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stefanusti wene aro ambatsiogpa, nimi nubunang wamek nang tanekori ka'ebaekti, wanaag yo maikno walelamsiogpa, si keleng tebongkia yo uro seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wanaag yo uro seneraglamekpa, Allah Eldamne Yame Walingeri seneragna sunsunum uro Stefanusti wanaag seneraglamogti, imag tiwalengelamogpa, Allah ua urobag Allah warero libango aropne sae sirik sip, nimi nubunge sunsunum urobag sip Yesus sekamogha tiwalengkaog. ");
INSERT INTO kkl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tiwalengkaogti, “Nangkabo, im phoamlaba, El nimi so'oagne taogne neneko Allah sae sirikneag sekamlaba tiwalengkan,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wene alamog abeneko sin ao leptangom agha sin yo lelem yanghang alamekti, Stefanusag merero niri saelbaek. ");
INSERT INTO kkl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Niri saelbaekti, kiliro asag agha pabiekti, paiag simbik toboghol piekti, kirikti olamek. Kirikti olameka ipsiek nimiri, “Nu babe ag pibeberi, Stefanus kirikti ol pukap,” aro nongag enektop ag kwiriplamek. Ag kwiriplamekti, kabuni me nhon sina Saulusti yan umag, “Piamsululam,” aro pibek. ");
INSERT INTO kkl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Stefanus kirikti olamek abeneko Stefanusti Yesusag yoplamogti, “Yesus Nia Mangkina Saelbamsilamne, nari yame anag yale tanena, 'Nanap wamnunam,' sululam!” aro mololamog. ");
INSERT INTO kkl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mololamogti, yabu sanukto pulingkiogti, nen yubu mikip uro mololamogti, “Yesus Nia Mangkina Salehiropne, 'Sindi undo malia ulamangba,' aro wailag nembamendi, lumbaheng kom!” seogti, tebaog. ");
INSERT INTO kkl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Stefanus obekpa, tebaogne sembe Saulus awi sembaog. Awi sembaog aghana yog nimi Allah yubu ka'elamekti, ulamek nimi taneko wamekti, Stefanus obeka aneko keyapto so'oag sikekti, o'ona lelem engero wamek. Stefanus obek sum eneko Stefanus obek nimiri “Seklebaik” aro alnibaekti, Yesusag “Sikne” aro seneragtop nimi taneko maiknoro malia ulamsiek. Malia ulamsiekpa, Yesusag seneragtop nimi as Yerusalem laplobiagha mog so'o Yudeaap Samariaap tala-tala nimi wamekag piekti, a'ero-a'ero wamek. Yesusti wepto pogsiognang a'o bare abenekoog Yerusalem wamek. ");
INSERT INTO kkl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yerusalem wamekpa, Saulusti “Yesusag 'Sikne' aro seneragtop nimi opsunun,” aro ae taneko sen-senna elamsiog. Ae taneko sen-senna elamsiogti, kabuni kelabo aeag agha kiliro-kiliro kop aeag tobonglamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesusag “Sikne” aro seneragtop nimi kop aeag tobonglamsiekpa, “Nu Yesusag seneragtop nimi opsiikag,” aro as Yerusalema lambaekti, piekag anekoa nimi tala-tala nimiag yubu walinge Yesus sembe ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ambarelamsiekti, Yerusalema lambaekne nhon Filipus neneko babe mog so'o Samaria as nubunge nhon wamogne nenekoag piog. Nubu as nenekoag piogti, Allahri “Taulbahimendi, saelbamsululam,” aro wepto poghol aogne Yesus sembe mog so'o Samaria nimiag ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Yubu ambarelamsiogti, Filipusti nimi whingag ulamognena, “Allah Eldamne mikipneri el pere agha ulamla” senenne kekneba ulamog. Phia nimi kulomag ulamsiogne yag lanalamsiogpa, haum alamekti lanalamek. Nimi yan malinge babe, nimi lebe arop kom nimi babe Filipusti wali nenelamsiog. Undo unulamogne kembiagha Samaria nimiri sol wali,wali uro ma'aptangto ambarelamsiogne ka'elamek. ");
INSERT INTO kkl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Filipusti nimi maikno wali nenelamsiogti, yubu walinge Yesus sembe ambarelamsiogpa, nimi as eneko wamek nimiri awi maikno senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","As eneko nimi nhon sina Simon mema mili lero phalamogne wamog. Samenag agha as enekoag mema phalamogne wamogpa, as enekoag wamek nimi niri, “Yaghe, mane agha ual,” senelamek. Undo senelamekpa, Simon ponekori, “Na maneagne pone nubunge wamna,” aro ambarelamsiogti, mema mili lero phalamog. Phalamogha sembe Samaria nimi ologne nubunge ni tanekori seneraglameknena, “Allah Eldamne mikipne Simon pone kulomag piamlaba, Simon pone 'Mikip Sirikne',” aro si lelamek. Simondi samenag agha heng kun taibuka taubuka ulamogha mema ulamogne kembiag agha Samaria nimi niri, “Yaghe, mane agha ulamla,” senelamek. “Mane agha ulamla” senena ulamogne sembe eldi yubu ka'elamekti, sindi babe ulamek. ");
INSERT INTO kkl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Simondi yubu ka'elamek aghana Filipus mog so'o Samaria yaogti, yubu walinge Yesus sembe ambarelamsiogti, “Allahri 'Mog so'oag nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne si Yesus wamla. Mog so'oag nimiri Yesusag 'Sikne' aro seneraghikpa, Elag seneragtop nimi Allahri saelbamsilul,” aro Filipusti ambarelamsiog. Ambarelamsiogpa, Simondi yubu samen ka'elamek nimi mog so'o Samaria wamek nimi taneko Filipusti ambarelamsiogne ka'elamekti, “Sik uro ambarelamsil” aro seneraglamek. Nengabo kelabo Samaria wamek nimi “Sik” aro seneraglamekti, “Filipusti ambarelamsilne saelbamukap,” aro elag yalamekpa, maghag pelengelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon poneko babe, “Yesus sembe ambarelamsilne sik,” aro seneraglamogpa, Filipusti maghag pelengkaog. Simon babe Filipus nelepto elap pang-yang ulamdek. Pang-yang ulamdekpa, Filipusti nimiri uanep komne, Allah Eldamneri uanepne, “Allah Eldamne mikipneri el pere agha ulamla” senenne kekneba mikip uro ulamogpa, Simondi, “Yaghe, mane agha ulamla,” alamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesusti wepto pogsiognang as Yerusalema ka'elamekpa, “Mog so'o Samaria wamang nimiri Allah yubu ka'elamangdi, Yesusag 'Sikne' aro seneraglamang,” ana ka'ebaekti, Petrusap, Yohanesap wepto pogsiek. ");
INSERT INTO kkl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Petrusap Yohanesap anam yan komag agha, Filipusti ambarelamsiogti, “Si Yesus engeropneag 'Sikne' aro seneragmunba, Yesusti saelbamsilul,” aro Samaria nimi maghag pelengkipsiog. Maghag pelengkipsiog aghana Allah Eldamne Yame Walinge Samaria nimi nhonag babe pelengel aog kom. Ane sembe Petrusap, Yohanesap pogsiekpa, Samaria pirekti, Samaria nimi usoghag sae saelbamsirekti, Allahag mololamdekti, “Andamne Yame Walinge sin Samaria nimi taneag tatsululam,” aro molona molbarek. Wene aro molbarekpa, Allahri Eldamne Yame Walinge sin nongag palilamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Yesusti wepto pogsiognangdi nimi usoghag sae pipsiekpa, Allahri Eldamne Yame Walinge sin nongag palilamsiogpa, Simon ponekori kembahiog. Kembahiogti Yesusti wepto pogsiognangag kal ma'al payaogti, Simon ponekori yubu lelamogti, “A'undi nimi usoghag sae palilamsiromba, Allahri Eldamne Yame Walinge nimi tane nongag palilamsil. A'undi ulamdomne saog uro nari babe uanun. Kal ma'al ane tatsineba, mikipne ane tatnurumunba, nimi usoghag nari sae palilamsineba, Allahri Eldamne Yame Walinge nimi nongag palilamsilul,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wene seogpa Petrusti, “Allahri, 'Mo tatsinun,' senelamlange nene andina 'Kamna kal ma'alag kapto tomnep,' senelamlam, te? Senelamlamne ane sembe anap anenge kal ma'al eneap tebalulam! ");
INSERT INTO kkl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Andi wanaag Allahri seneragna sunsunum uro seneraglamlam kom. Ane sembe nuri sae nimi usoghag palilamsiapne, olog babe tam andinge tanep kom. ");
INSERT INTO kkl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Allahri anap, andinge kal ma'alap kom nembaghenep ane sembe, malia ualamne nene wali uro seneragmendi lipsululam. Lipsimendi, 'Malia uanne tam orog nembalulam,' aro Nuni Allahag mololapmenba, 'Malia wanaag seneraglamlamne nene Allahri tam orog nembalul to, kom to?' aro mololame. ");
INSERT INTO kkl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Andi wanaag seneraglamlamne sembe na el tan. Andi wanaag yonge meso pungkulamlaba, andi mali-malia ulamlamneri wana sao kauplangkelba, ulamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Wene seogpa Simondi sin phendeag yubu lelamogti, “A'undi leptomne nanag taleagti, a'undi na sembe yepto A'uni Allahag molbarurom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Seogpa, wameka, Petrusap Yohanesapti, “Allahri nimi el uro ua unne kekneba Yesus sembe maikno ulamogpa, ibubu,” aro Nuni Allah yubu ambarelamsirekti, as Yerusalem samoro yalamdek. Yalamdekti mog so'o Samaria as maikno wa'iro yubu walinge Yesus sembe ambare-ambare Yerusalem yarek. ");
INSERT INTO kkl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Petrusap Yohanesap as Yerusalem yarekti, wamdekpa, sikinkae Filipus Samaria mog so'oag wamog. Wamogpa, Nuni Allahri Eldamneri arukna malaikat nhon poghol aogne Filipus Samaria mog so'oag wamoghag piog. Piogti, Filipusag yubu lelamogti, “Sekmendi, Yerusalem simbik pimendi, ina as Yerusalema as Gaza kuluptop ina waghag pululam. As Yerusalem anabi as Gaza anabiag ina pai aldes saoghag wamlange nene toman pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Wene seogpa Filipus sekom agha piog. Piogti tilamogpa, Etiopiange nhon nimi nubunge yalamog. Mog so'o Etiopia nimi yubu sia lerop kel si Kandake arukna wamogti, Kandake kel eneringe sae agha piamogne yalamog. El neneko as Yerusalem Allah omekel piogti, samoro yalamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Samoro yalamogti, kereta alibag pukamogpa, pham kudari kiliro payalamog. Kereta alibag pukamogti, mome Yesaya Allahri yubu silimu tiptopneri mome tobogne Etiopiangeri eldi saeag saelbamogti, keme-keme yalamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Keme-keme yalamogpa, Allah Yame Walinge nenekori Filipusag, “Elem-elem pimendi, pham kudari kereta kiliro payalamla peramag ane pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wene seogpa, Filipus elem-elem kereta yalamogha peramag piogti, ka'elamogpa Allahri yubu silimu tiptopne Yesayari mome toro pibogne Etopiangeri kemero lelamogha Filipusti ka'ebaog. Ka'ebaogti, “Nani, yubu leple yalamlam yubu ene wanaag olog el talam te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Haibaogpa nimi nubunge ponekori, “Nimi amoro el nenehin nang orog wamnaba, welaro el tanep?” seog. Wene seogti Filipusag, “Walel amenba, nhon pununam,” aro molbaogpa, Filipus neneko kereta alibag waelbaogti, Etopiange peramag pulingkiog. ");
INSERT INTO kkl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yesayari mome toro pibogne leple yalamogne lilimna ane: “'Pham domba obukap,' aro pabirop saog uro El babe pabiek. Nimiri pham domba hong kareplamangba, pham domba yubu lemna kom ua urop saog uro, El babe yubu koma wamogpa obek. ");
INSERT INTO kkl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","El nimiri ali nenero yubu lero loloroba lelamekpa, tam Elag taog. Elag tam pibekne wali uro kemban koma El ya'ag obekpa, tebaog. Tebaogne sembe, Nimi nhondi babe 'Eldi mabo tane wamang,' aro lemnep kom,” aro mome toroba leple yalamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopiange ponekori Filipusag hailamogti, “Nari anag hailangkenne, Allahri yubu silimu tiplamogne poneri etne sembe mome toro pibogti lebog? Eldamne sembero, nimi orange sembero?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wene aro haibaogpa, Filipusti leple yalamogne neneko Yesayari mome toro pibog yubu aneko sirik kiliro yubu walinge Yesus sembe tibin nenero ambare-ambare palamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wene aro ambare-ambare palamogpa, inaag mag sinag wamoghag pirekti, nimi nubunge Etiopiange ponekori Filipusag, “Ane mag wamla ane. Tibogae. Tam olog wamla, te? Na andi maghag pelengkanei,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wene seogpa Filipusti, “Andi Yesusag 'Sikne' aro wanaag seneraglamlam tanena, maghag pelengkaghenun,” seog. Wene seogpa Etiopiange ponekori, “Seneraglamnange, 'Allahri, “Mog so'oag nimi taulbahimendi, saelbamsululam,” aro Elme Yesus wepto poghog' aro sik uro seneraglamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Etiopiange poneko eldi arukna kereta pham kudari kiliro payalamogne ponekoag “Babitlulam,” seogpa, babogpa, “An ane wamlulam,” seog. Seogti sin mag sinag nhon yingkirekti, Filipusti Etiopiange poneko mag sinag pelengkibog. ");
INSERT INTO kkl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Maghag pelengkibogpa, walel alamoghag agha Nuni Allah Yame Walingeri Filipus poa piogpa, Etiopiange ponekori Filipus ibog kom. Ibog komdi Etiopiange poneko awi yeng sene-sene elengeag sip palamog. ");
INSERT INTO kkl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Allahri Filipus pabiogpa, as Asdod yaog. As enekoag agha, “Yesus sembe ambarelamsinun,” aro as Kaisarea anabi Asdod anabiag as ni wamekne yubu walinge ambare-ambare palamsiogti, Kaisarea piog. ");
INSERT INTO kkl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Filipusti Yesus yubu walinge ambare-ambare palamsiog abeneko, Nia Mangkina Salehiropne Yesus yubu ka'ero ulamek nimi sembe Saulus nenekori karongdi, yo senelamog. “Ya'ag olamsinun,” aro yo senelamogti, Saulus nenekori memne Allah sembe pairopnang sikini nubungeag piogti, ");
INSERT INTO kkl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Na mome toatnemenba, na as Damsyik Yahudi nimiri Allah yubu lerop ae sale-sale pilamang nimiag tatsinun. Tatsineri, as Damsyik nimi anabiag agha Yesusti Ina pa'abaog Ina nelepto palamang nimi ipsine tanena haing kaupto saelbahineri, as Yerusalem payahinun,” aro Saulusti molbaog. ");
INSERT INTO kkl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mome molbaogpa, memne Allah sembe pairopnang sikini nubungeri el saeag mome tarogpa, Saulus as Damsyik inaag palamog. As Damsyik peramag palamogpa, imag agha libango aropne haing omomne elag warelobog. ");
INSERT INTO kkl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Imag agha libango aropne haing omomne warelobogpa, so'oag malingkiogti ka'elamogpa, “Saulus! Saulus! Sa'a sembe 'Seklebale' aro ulamnelam?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wene seogpa Saulusti, “Nani, anna etne?” seog. “Etne,” seogpa, nen lebog yubu enekori, “Na Yesus, andi 'Seklebale,' aro ulamnelamne ponekori lelamna. ");
INSERT INTO kkl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Andi Na malia ulamnelam aghana, wenena sekmendi, as Damsyik pululam. Pimendi wapmenba, andi ulamlulamne nimiri ambatkukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wene aro ambarelamogpa, Saulusap nhon palamek nimi taneko el peramag sekamekti, sindi babe yubu ka'ebaek. Yubu ka'ebaek aghana, nimi nong ibek komdi lo'om paibon seekti, yubu kom taek. ");
INSERT INTO kkl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yubu kom taekti wamekpa, Saulus neneko pulingkina sekogti, “Haing kwelekanun,” aro ulamoghag agha, haing kwelekna eraruk taogti, ya'ag taog. Haing aneko ya'ag ubaogpa, nimiri sae salero as Damsyik pabiek. ");
INSERT INTO kkl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","As Damsyik pabiekpa, ik wilindi haing uroba wamogti, kwaneng mag tero koma wamog. ");
INSERT INTO kkl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","As Damsyik Yesus yubu ka'ero ulamogne nhon si Ananias wamog. Wamogti haing uamna kwelekamna senenag agha kemelamogpa, Nia Mangkina Salehiropne Yesusti, “Ananias,” aro yoplamogha ka'ebaogti, “Nia Mangkina Salehiropne, na ane wamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Ananiasti, “Na wamna,” seogpa, Nia Mangkina Salehiropne Yesusti, “Tarsusne nhon si Saulusti haing uamna kwelekamna senenag agha amik uro yabinepne kembal. Kembalnena, nimi nhon si Ananias Saulus wamlaag wa'ildi, sae usoghag palilamlaba, haing ubaonge kwelekal. Haing uamna kwelekamna senenag agha kembaldi, wene Nanag mololamnel. Ane sembe, sekmendi ina piroba si Ina Peket pululam. Pimendi, Yudasti ae anekoag agha, 'Tarsusne si Saulus engeropne tala wamla,' aro nimi wamangneag haibahilulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yesusti wene seogpa, Ananiasti, “Nia Mangkina Salehiropne, nimi ene sembe nimi maiknori yubu lelamangba ka'elamna. 'An Yesusag “Sikne” aro seneragtop nimi wepsilumne as Yerusalem wamangne Saulusti, “Seklebaik” aro olamsil,' alamangba ka'elamna. ");
INSERT INTO kkl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wene ane yingkina wamlangena, 'Nimi Yesusag “Sikne” aro seneragtop nimi sae kaupto saelbamsilul,' aro Yahudi nimi sembe memnang Allah sembe pairopnang sikindo yabori Saulusag yubu pibong. 'El nuri sae wamlari, undo unualul,' aro yubu pibongba, wene tane yaori wamla,” aro Ananiasti wene seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananiasti wene seogpa, Nia Mangkina Salehiropne Yesusti, “Pimenag anekoa, el Saulusna, 'Nari yubu nimi tala-tala wamangne ambatsulul,' aro webamnange wamla. Webamnangena, 'Nimi sisa Yahudi nimi komneap, mog so'o saelba urop nimi nubunangap, nimi sisa Yahudi nimi Israel nimi babe pileri, Na Yesus sembe yubu walinge sinag ambatsulul,' aro webamna,” aro Yesusti wene seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Seogti, nen tipto ambarelamogti, “Nari el ambatnunnena, Na yubu nimiag ambarelamsilenge sembe seklena seklelamlul. 'Na Yesus si nubu talul,' aro Saulus maiknoro seklelamlulne sembe elag ambatnun,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wene seogpa, Ananias piogti, ae enekoag wa'al piog. Wa'al piogti Saulus usoghag sae palilamogti, “Saulus nangkae, Nia Mangkina Saelbamsilne Yesus, an inaag yalamomba, lag taonge ponekori nanag yubu ambatnel. Ambarelamneldi, 'Saulusag pimenba, an sae pere agha Saulusti haing kwelekaleba, Allah Eldamne Yame Walinge el kulomag teknero wa'ileri, mikip nembalul,' aro anag pognelba, yan,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wene seog abeneko pere haing sikna lilbamlo agha eldi haingag agha seknagha timbaogpa, haing kwelekaog. Haing kwelekaogti, tibanep saog wamogpa, Ananiasti maghag pelengkaog. ");
INSERT INTO kkl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Maghag pelengkaogpa, kwaneng teogti, nong mikip taogpa, wamog. Saulus poneko mikip taogti, Yesus yubu ka'ero ulamek nimiap ik etbare Damsyik wamog. ");
INSERT INTO kkl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wamogti, ta'ap sen koma Saulus nenekori Yahudi nimiri Allah yubu lerop aeag winil talamekag wa'ilamogti, “Yesus neneko Allah Elme,” aro lag phoro nimi ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulusti ambarelamsiogne sembe “Map, yaghe! Nimi eneko kom, te?” alamekti, “Saulus kom te! Eldi samenag, 'Yesusag “Sikne” aro seneragtop nimi Yerusalem wamangne orog nembahinun,' aro maiknoro olamsiori, wene babe tane yao. Tane yaongena, 'Yesusag sikne aro seneragtop nimi Damsyik wamangne babe oro saelbahineri, haing sae kaupto memnang Allah sembe pairopnang sikindo yaboag pabihinun,' aro yingkilamla aghari,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wene alamek aghana, Allahri Saulus mikip nenelamogpa, Yahudi nimi agha Damsyik wamek nimiag Yesus sembe tibin nenero ambarelamsiog. Ambarelamsiogti, “Yesus neneko Allahri, 'Nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne wamla,” aro kekneba maikno Yesus sembe tibin nenero ambarelamsiog. “Yesus Allahri wepto poghol aogne” aro ambarelamsiogne sembe nimi nhondi babe, “Orolena ambarelamsil,” senep kom wamog. ");
INSERT INTO kkl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wene aro ambarelamsiogti, ik maikno wamogpa, Yahudi nimiri, “Saulus obukap,” aro yubu nikne saekag lelamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","“Obukap,” aro yubu nikne saekag lelamekne Saulus babe ka'ebaog. Yahudi nimiri, “Saulus obukap,” aro sinag kweleknag as leka kanero solingkirobag ina siram wa'albang yang pang uanebag taneko welamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","“Obukap,” aro welameka sembe ik nhon sum ae inipnag Saulus kau saog uro haingdi piri wiroba lomag wa'iog. Lomag wa'iogpa, eldi yubu ka'erop nimiri kau saog uro wiropne nenekoag agha as kanero leka solingkiropne nenekoag Saulus paiag sip pelengkaek. ");
INSERT INTO kkl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus Yerusalem piogti, “Yesus yubu ka'ero ulamang nimiap ma'aptaukap,” sembaog aghana, Yesus yubu ka'erop nimi tanekori, “Paulus sik uro Yesusag wana seneraglamla kom. Yesus yubu ka'erop komne wamlari, maneri lelamla,” aro el sembe log senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","28","Wene aro log senelamek aghana nimi nhon si Barnabasti, “Saulus yepnun” aro Saulus poa Yesusti wepto pogsiog nimi tanekoag payaog. Payaogti ambarelamsiogti, “Nimi ene 'Damsyik punun,' aro inaag palamoag agha Yesus el whingag lag taori, yubu lebo. Elag yubu leboba, Saulus as Damsyik wamoa Yesus sembe log kom uro Damsyik nimiag ambarelamsio,” seog. Saulus babe Yesusti wepto pogsiog nimi tanekoap nhon wamek. Wamekti, Saulus as Yerusalem nimi wamekne nusamag agha sop-sop pang yang ulamogti, log kom uro “Nia Mangkina Saelbamsilne si Yesusti pognel,” aro ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","As Yerusalem Yahudi nimi wameknena, Yahudi nimiri ul palamekne sunsunum uro saelba ulamekpa, Yahudi nimi agha Yunani nimiri ul palamekne sunsunum uro saelba ulamek nimi babe wamek. Yahudi nimi agha Yunani yubu lelamek nimi tanekoap Saulusap Yesus sembe yubu lel talamek. Yubu lel talameka sembe Yunani yubu lelamek nimi tanekori, “Saulus obukap,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","“Obukap,” senelameka elkabo Yesusag “Sikne” aro seneragtop nimi el taekti, sindi el poa Kaisarea pabiekti, “Tarsus pululam,” aro poghek. ");
INSERT INTO kkl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Poghekti wamekpa, Yesusag “Sikne” aro seneragtop nimi mog so'o Yudeaap, Samariaap, Galileaap wamek nimi ni wana aingniro wamek. Nia Mangkina Salehiropne ponekori yubu sunsunum uro ul palamekpa, Allah Eldamne Yame Walingeri sin yeplamsiogpa, sin mikip talamekti, Yesusag “sikne” aro seneragtop nimi maikno talamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wamekpa Petrus neneko as kanero wamekne kemero poa palamsiogti, Allahri wepsiog nimi Yesusag “Sikne” aro seneragtop nimi as Lida wamekag piog. ");
INSERT INTO kkl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","As Lida aneko palamogpa, nimi nhon si Eneas nong kikiplobogpa, heng kun tai buka tau buka ulamogha heng kun lin bare aeag taogti malamog. ");
INSERT INTO kkl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Aeag taogti malamogpa, Petrusti Eneasag yubu lelamogti, “Eneas, nangkae. Allahri, 'Taulbahimendi, saelbamsululam,' aro wepto poghogne Yesus ponekori wali nemban uaghel. Pukmendi ae kolo togtoae,” seog. Wene seog abeneko pere wali taogti, pukogti, sekamog. ");
INSERT INTO kkl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wali taogpa, nimi as Lida wamekneap, as Saron wamekneap kembaekti, mali-malia ulamekne libekti, Nia Mangkina Saelbamsilne Yesus agha “Sikne” aro nimi niri seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mog so'o eneag as nhon sina Yope babe wamog. As Yope kelabo nhon sina Tabita Yesus yubu ka'ero ulamog kel nhon wamog. Kel ene Yahudi yubuag sina Tabita, aghana Yunani yubuag sina Dorkas alamek. Eldi wali-walia nimiag ulamogti, nimi sae agha orogne yeplamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yeplamsiog aghana, nikna niklamogti tebaog. Tebaogpa nimi teptoba aneko mag a'elero ae tika alikinagneag palingkiek. ");
INSERT INTO kkl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ae tika alikinagneag palingkiekti ka'elamekpa, “As Lida Yope peramag Petrus neneko yaldi wamla,” ana ka'ebaek. Ka'ebaekti Yesus yubu ka'ero ulamek nimi tanekori nimi phende pogsiekpa, Petrus wamoghag yarekti, “Elem-elem as Yope yalulam,” aro molbarek. ");
INSERT INTO kkl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus yubu ambattekne ka'ebaogti, elemag sekom agha nelebahiog. Nelebahiogpa, piekti Petrus enero ae tika alikinagneag poa waelbaek. Waelbaekpa yingkina kemelamoghag agha kelabo kaldam kelabo nimi teptoba kanero sekamek. Sekamekti, nongag enektop ag Dorkas kamag wamogti wibatsiog ag toro Petrusag pebarekti engelamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Engelamekpa Petrusti, “A'un ni lambalulom,” seogti, yabu sanukto pulingkina Allahag molona molbaog. Molbaogti nimi teptoba anekoag kembiagha, “Tabita, puke!” seogpa, haing kwelekaogti, Petrus kembaogti, pukog. ");
INSERT INTO kkl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pukogpa, Petrusti kel eneko sae saelbamogti, yepto toro sekirog. Sekirogti Allahri wepsiog nimi Yesusag “Sikne” aro seneragtop nimiap, kaldam kelabo tanekoap yopsiogti, Dorkas kamag taog kel eneko sin saeag tatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sin saeag tatsiogpa, Dorkas kamag taog yubu eneko as Yope sabo taogpa, nimi maikno tanekori, “Yesus sik uro Nia Mangkina Saelbamsilne,” aro seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus neneko as Yope wamogti, nimi nhon si Simon pham sapi kon logto mektopneap ik etbare undo wamdek. ");
INSERT INTO kkl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","As Kaisarea nimi nhon sina Kornelius wamog. Kornelius ponena, Roma nimi yin saleropnang kong-kongne wamek aghana, teng tombare yin saleropnang sembe sikindo wamog. Elap, elkaboap, el umag wamek nimiap sembe “Italia Nimi Yin Saleropnang” aro engelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Elap eldi aeag wamek nimiap Allah yubu sunsunum uro ulamekti, Allah omeklamek. Eldi nimi sae agha orogne yeplamsiogti, sop-sop Allahag molona mololamog. ");
INSERT INTO kkl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ik nhon sum heng taolbaogti, sin tanep peram haing uamna kwelekamna senenag agha tibin uro kemelamogpa, Allahri Eldamneri arukna malaikat nhon poghol aogne yaogti, yubu lelamogti, “Kornelius, nangkae!” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","“Kornelius, nangkae!” seogpa, Allah arukna malaikat Korneliusti ibogti, logti, “Nani, anna tane sa'a sembe yalamdi,” seog. Wene seogpa, Allah arukna malaikat anekori, “Andi Allahag molona mololamlamne Allahri ka'elamlaba, andi nimi sae agha orogne yeplamsilamne babe Allahri iyangkeldi tiplengkangkel. Ni ulamlamne sembe Allahri kembangkeldi, 'Walia aghabog na sembe ulamla,' senelamla. ");
INSERT INTO kkl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wene nimi etbare undo pogsimenba, as Yope piikti, nimi si Simon, si nhon Petrus, pone enel pukang. ");
INSERT INTO kkl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon Petrus poneko elkae Simon pham sapi kon logto mektopne poneri aeag mag longorop mag nubunge laut libunag sorop ae eneag wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ambarogti, Allah arukna malaikat aneko piogpa, Kornelius poneko arukna phendeap, yin saleropne el yae ua uropne Allah yubu sunsunum uro ulamogneap yopsiog. ");
INSERT INTO kkl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Yopsiogti, “Allah arukna malaikat yaldi, yubu wene ane ambatnelne sunsunum uro, as Yope Simon si nhon Petrus wamlange enel pululom,” aro pogsiog. ");
INSERT INTO kkl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Korneliusti pogsiogpa, sin wilindi abeneko as Yope peramag inaag palamek abeneko Petrus ae siro heng ik mol-mol aloghogpa, “Ae imaghag molona molbanun,” aro waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Waelbaogti Allahag molona mololamoghag agha kwaneng yo uaogpa, “Kwaneng tehene,” sembaog. “Kwaneng tehene,” sembaogpa, kwaneng el sembe togto yoroba ingilamekpa, “Haing uamnaro, kwelekamnaro,” senenag agha kemelamoghag agha kekneba uaog. ");
INSERT INTO kkl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kekneba uaogpa, imag sip tiwalengelamoghag agha im phoro ag sangaroba ag ingkisag-ingkisag haing tombare kerekto saog urop ag pelengel alamog. ");
INSERT INTO kkl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pelengel alamogpa, lomag tao wamekpa, ipsiog ana lebe aroba yan tombareri yabiropneap, mon magti yabiropneap, winang im toman yabiropneap ipsiog. ");
INSERT INTO kkl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pelengel alamog pere ka'elamoghag agha yubu lelamogti, “Petrus pukmendi, lebe aroba tane oro yobamendi telamlulam,” alamog. ");
INSERT INTO kkl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wene alamogpa, ka'ebaogti, Petrusti, “Nani, samenag Allahri nunisa Musaag yubu ambarelamogti, 'Lebe aroba undop-undoba saogha a'un Yahudi nimiri oro tululom kom,' aro ambarog. Ane sembe, na ik nhon babe sop undoba saogha telamna komdi, wene babe mali sembandi, tunun kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wene seogpa, yubu kaebaog yubu enekori nen lelamogti, “Allahri yubu, 'Wali nembandina, wene tululam,' sel ane sembe, 'Lebe aroba sop tane mali, nimiri tenep kom,' aro andi sap wene seheng kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ag sangaro kekneba ulamogha ot sumeneko agha ik wilindi elag el nembaogti, imag nen waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Undo unuaogpa, kembaogne ane sembe Petrusti, “Sa'a sembe ual?” aro seneragto pulamog abeneko, nimi Korneliusti, “As Yope pululom,” aro pogsiog nimi abeneko ae Simondi ae ibekti, ae leka kanero solingkirobag ina siramag sekamek. ");
INSERT INTO kkl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ina siramag sekel pina nimi nhon yobekti hailamekti, “Nimi asag nimi nhon sina Simon Petrus ae eneag yingkina ua unne no?” aro haibaek. ");
INSERT INTO kkl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Wene aro hailamek abeneko pere Petrusag kekneba uaogpa, kembaogne ane sembe “Sa'a sembe ual?” aro seneraglamog. Seneraglamog pere Allah Yame Walingeri Petrusag yubu lelamogti, “Petrus nangkae, an nimi wilindiri an elangkeang. ");
INSERT INTO kkl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sekom agha kulukamendi, ta'ap sen koma sinap nhon pululam. Nari arukahinba, sinna yang,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wene seogpa Petrus kulukaogti, nimi tanekoag yubu lelamogti, “Na a'undi elamnelomne nana ane. Sa'a sembe yalomdi elamnelom?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wene seogpa sindina, “Nu nuni yin saleropnang teng tombare saelbamsilne sina Korneliusti nu pogsio. Elna Allah omektopne, Allah yubu sunsunum uro walia aghabog uropne wamla. Yahudi nimi niri el sembe 'walinge' sembamang. Allahri Eldamneri arukna malaikat nhon poghol aogne ponekori ambaroa sunsunum uro pogsioba, yabongena an enelaghukap aro yaap. Andi nunap nhon piberi, nuni Koreneliusti aeag wa'iberi, lepmenne nu nuni ka'ebalul,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wene aro ambarekpa, Petrusti yubu lelamogti, “Wali, na wamna aeag mabukap,” aro ambatsiogpa, aeag wa'iek. Mabeka lukunap Petrusap el enel pieknangap nhon palamekpa, as Yope nimi Yesusag “Sikne” aro seneragtop nimi babe Petrusap nhon piek. ");
INSERT INTO kkl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sin inaag mabekti, palamekpa Kornelius ponekori eldi kelmabo meap, elkaboap, eldo yabo, ilipsabo yopsiogti, Petrus tibogto wamekag as Kaisarea Petrus piog. ");
INSERT INTO kkl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tibogto wamekag Petrus piogpa, Kornelius ponekori Petrus yanag amupto malingkina kibog. ");
INSERT INTO kkl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kornelius ponekori Petrus yanag amupto malingkina kiplamog aghana, Petrusti sae kiliro toro sekirogti ambarelamogti, “Nangkae sekelingki! Na babe an saog uro nimi agha yan,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wene seogpa, Petrusap yubu leple aeag wa'alamdekpa, nimi maikno tekne amek. ");
INSERT INTO kkl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tekne amekpa, kembahiogti, Petrusti yubu ambarelamsiogti, “Nangkabo a'un el wamlom, na Yahudinge wamna aghana Yahudi nimi nubunangdi, 'Yahudi sisa kom nimiap hale nenep tangto, nimi pali nenep tangkamseng kom,' aro ambarelamsiek. Aghana Allahri seneropne na whingag lag taongena, Allahri seneropne, 'Nanag yaukang,' senelamlange nimi etneri karebanep kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","“Ane sembe Nai andi moloro 'Yalulam,' seomba, na kom sen koma yan. Nai andi 'Yalulam,' seomne sa'a sembe?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Petrusti wene seogpa Korneliusti, “Ne sum eneko heng taolbaori, sin tanep peram, wene saog, na aeag agha Allahag molona mololamno. Mololamnori kemelamnoag agha kabuni nhon ag heng-henga tingiropne enekamori, na whingag sekamo. ");
INSERT INTO kkl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Sekamori nanag yubu lelamori, 'Kornelius, andi nimi saeag agha orogne yeplamsilamdi, molona mololamlamne Allahri ka'elamlari, wamla. ");
INSERT INTO kkl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ane sembe nimi arukahimenba, Yope piikti, nimi si Simon Petrus enel pukang. El wamla aena pham sapi kon logtoba mektopne poneko sina Simondi aeag mag longorop mag libunag wamla,' aro Allah arukna malaikatti ambatneo. ");
INSERT INTO kkl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ane sembe nari elemag nimi pogsinoba, nai an tol pikeongba, an wana waliapti, an nanag yalam. Wene wali yalamba, nu babe Allah whingag longoro wamapti, Nuni Allahri 'Yubu ambatsululam,' aro pogkeonge nu babe ka'ebaukapti, nu babe lelero ambatsi,” aro Korneliusti Petrusag molbaog. ");
INSERT INTO kkl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Wene seogpa Petrus nenekori, “Allahrina 'Nimi ane Yahudi sisa nimi to, kom to,' semban koma nimi ni sembe o'ona sembamsildi wamlange, sumeneog el tandi, sik semban. ");
INSERT INTO kkl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nimi ni sikininge as mog so'o a'ero-a'ero urop nimi Yahudi nimi sisa kom nimi aghana, Allah yubu sunsunum uro walia ulamnari wamnaba, Allahri o'ona sembamsildi wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","38","Petrusti nen tipto ambarelamsiogti, “Nangkabo, Yesus Nia Mangkina Saelbamsilne nu Israel nimiap nhon palamububa, Allahri el pere agha yubu ambarelamsiogpa, elag uro yabiogne sembe a'un ni el wamlom. Yubu walinge ambatsiognena, Allahri 'Nanap nimiap ma'ap taukap,' aro Yesus wepto poghog. Wepto poghogpa, Yohanesti 'Allahri, “Saelbamsululam,” aro wepto poghogne yan ual, ane sembe mali-malia ulamlomne lipsimundi, Allahag samoro yalulom,' aro nimi maghag pelengelamsiog. Yohanes ponekori, 'Allahri wepto poghogne yan ual,' aro maghag pelengelamsiogti, Yesus babe maghag pelengkaog abeneko pere Allahri 'Taulbahimendi, saelbamsululam,' aro Yesus Nasaretne poneko Allah Eldamne Yame Walingeap Eldamne mikipneap elag pibog. Elag pibogpa, Galilea so'oag agha Yudea so'oag tala-tala palamogti, wali-walia aghabog ulamog. Unulamogpa, Allahri el yeplamogpa, phiari saelba ulamsiogne wali nenelamsiog. Yesusti unulamogne nene sembe nu ni el wamsil. ");
INSERT INTO kkl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mog so'o Yudeap as Yerusalemap Eldi ulamogneap, ulamongeap Nu nang eneri haingdi ibobori, ambarelamsiap. Walinge aghabog ulamo aghana, nimiri kalag siplobongdi, ya'ag olobong. ");
INSERT INTO kkl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Olobong aghana, ik wilindip sum teptobag agha Allahri kamag nembao. Kamag nembaoba, Allahri, 'Nimiag lag nenep talul,' sembaogne sunsunum uro lag nenel talamo. ");
INSERT INTO kkl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","El Allahri kamag nembaonge lag nenel talamoa nimi niag kom. Ot nu Allahri samenag wepsiog nimi abenekoriog haingdi babe ibobo, kwanengap magap babe nhon tebori, ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","El nunap nhon wamoboa, nunag yubu lelamori, 'Nimiag ambarelamsumundi, “Yesus poneko Allahri wepto sekirog. Wepto sekirogpa, amik ualulne, nimi teptopneap, kamagneap, Yesusti nimi poloro wepsileri, tam karebalul,” aro ambarelamsululom,' aro Yesusti nu pogsio. ");
INSERT INTO kkl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pogsioba, wene yubu ambarelamsiapnena, samenag Allahri yubu silimu tiplamek nang ni wamekneri Yesus sembe ambarelamsiek. Yesus sembe ambarelamsieknena, 'Nimi etneri Elag “Sikne” aro seneraghikpa, Allahri kembahileri, “Nari wepto poghol ahinge ponekoag wali senelamang,” aro malia uroba tam orog nembalul,' aro yubu tiplamek,” aro Petrusti ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wene aro Petrusti ambarelamsiogpa, Petrusti yubu ka'elamek nimi tanekoag Allah Eldamne Yame Walinge sin nongag kulukul aog. ");
INSERT INTO kkl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Allah Yame sinag kulukul alamogpa, a'erop-aerop yubu Allah Eldamne Yame Walingeri tarelamsiog yubuag lero Allah omeklamek. Omeklamekpa, Yahudi nimi agha Yesusag “Sikne” aro seneragtop nimi Petrusap nhon yaeknang tanekori babe Allahri Eldamne Yame Walinge tarelamsiogha ibek. Ibek nang taneko Yahudi nimi nengabo kon karebel dalamek nang Yesusag “Sikne” aro seneragtop nang wamek. Wamekti ibekti, as Yope agha Petrusap nhon yaek nang tanekori, “Yahudi nimi kom aghana, sinag babe Allahri Eldamne Yame Walinge tarelamsil,” aro logti, “Yaghe,” alamek. Yahudi nimiri kemelamsiekpa, Yahudi sisa kom nimiri a'erop-a'erop yubu Allah Eldamne Yame Walinge tarelamsiog yubuag lelamekpa, Petrusti, ");
INSERT INTO kkl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kembahimun. Nun saog uro nimi tane babe Allah Eldamne Yame Walinge sinag tahil. Ane sembe nimi tane Yesusag 'Sikne' aro seneraghik tanena, maghag pelengehinne etneri kom senep?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","“Etneri kom senep?” seogti, Petrusti nen lelamogti, “Nimi tanekori Yesusag 'Sikne,' aro seneraglamekne sembe maghag pelengkipsululom,” seogpa, maghag pelengkahiek. Pelengkipsiekpa nimi tanekori Petrusag “Ik etbare nhon wamukap,” aro molbaekpa, Petrus wamog. ");
INSERT INTO kkl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Petrus as Kaisarea wamogpa, Yesusti wepto pogsiog nimi Petrus elkabo yogne babe mog so'o Yudea wamek. Wamekpa, “Yahudi sisa kom nimi babe wene Allah yubu ka'elamangdi, Yesusag 'Sikne' aro seneraglamang,” alameka Yesusti wepto pogsiog nimi yogneap Yesusag “Sikne” aro seneragtop nimi mog so'o Yudea wamek nimi tanekoapti ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ka'ebaek aghana Yahudi nimiri senelamekne, “Allahri samenag ambatsiogha sunsunum uro nimi nengabo kon karebel talamik tanena, Allahap ma'ap tangtop nimi,” senelamek. Ane sembe, Petrus mog so'o Kaisarea laplobi agha as Yerusalem yingkiogpa, Yahudi nimi as Yerusalem wamekne Petrusag piekti, yubu lelamekti, ");
INSERT INTO kkl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“An Yahudinge, Allahri samen arukahiogne sunsunum uro kon andinge karebaghaek aghana, Yahudi nimiri uaheng kom seneropne uaom. Sin Yahudi sisa kom nimi tanena nengabo aneko 'Nunap Allahap ma'ap taukap,' aro kon karep tangtop kom. Kon karep tangtop kom aghana, sindi aeag piomdi, kwaneng nikag teom. Sa'a sembe Yahudi nimiri uaheng kom seneropne nene uaom?” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wene alamekpa, Petrusti, anam alniro yabioghag agha uro yabiogne ni ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na as Yope Allahag molona lelamnori, 'Haing uamna kwelekamna' senenag agha kemelamnoag agha kekneba nanag uao. Nari kemelamnoag agha ag sangaroba ag ingkisag-ingkisag haing tombare kerekto saog urop ag imag agha na saramag pelengel alamoa imno. ");
INSERT INTO kkl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pelengel alamoba, lomag kemelamnoag agha lebe aroba yan tombareri yabiropneap, lebe aroba nimiri pia urop komneap, lebe aroba mon magti yabiropneap, winang sin im toman yabiropneap imno. ");
INSERT INTO kkl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kemelamnoag agha imag agha nanag yubu lelamori, 'Petrus sekmendi, wamlange tane oro yobamendi, telame,' alamoa ka'ebano. ");
INSERT INTO kkl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wene alamoa ka'ebanori, narina, 'A, Nani, lebe aroba taneko sembe samen Allahri, “Tululom kom,” seogpa, samenag babe nari pamdi tihi komdi, sumene babe 'Mali,' sembandi, tunun kom,' seno. ");
INSERT INTO kkl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wene senoba, nen ik phendepne imag agha yubu ka'ebano yubu enekori lelamori, 'Allahri yubu, “Wali nembandi, wene tululam,” alamla ane sembe, “Lebe aroba sop tane mali, nimiri tenep kom,” aro andi sap wene seheng kom,' seo. ");
INSERT INTO kkl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Undo unuaonge nene ik wilindi unuaori, nen ag sangaroba ni lomag wamonge imag agha kiliro tobo,” aro Petrusti Yahudi nimiag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Petrusti nen tipto yubu ambarelamsiogti, “Kiliro toboba, wamnoag agha nimi wilindi as Kaisarea agha na wamnoag pogsioba, yaongdi, na wamno aeag ina siramag sekamong. ");
INSERT INTO kkl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sin sekamongba, Allah Yame Walinge nenekori na ambarelamneori, '”Yahudi nimi to kom to,” semban koma, sinap nhon pululom,' seoba, nangkabo no'opbare tane wamang nangap nhon pibo. Nu nhon as Kaisarea pibori, nimi wilindi pogsionge ponekori aeag wa'ibo. ");
INSERT INTO kkl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wa'iboba, Kaisarea nimi enekori nunag ambarelamsiori, 'Allah arukna malaikat nari aeag wa'al aori, nanag yubu lelamori, “As Yope nimi nhon Petrus, nen si nhon Simon wamla. 'Simon Petrus poneko enel pukang,' aro nimi pogsululam. ");
INSERT INTO kkl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pogsimenba, enero poa yaikpa, Simon Petrusti a'unag yubu ambatsilul. Yubu ambatsilenge wali uro ka'eapmundi, 'Sik' aro seneragmunba, 'Mali-malia ulamlomne sembe opsileag,' aro Allahri wepto poghol aogne ponekori taulbahilul,” aro Allah arukna malaikatti nanag ambatneo,' aro Kaisarea nimi enekori nebatneo,” aro Petrusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nen tipto Petrusti Yahudi nimi mog so'o Yudea wamek nimi ambarelamsiogti, “Kaisarea nimi enekori nebatneoba, nari yubu ambarelamsinoag agha Allah Eldamne Yame Walinge neneko samenag nunag kulukulaog saog uro, sinag babe kulukulao. ");
INSERT INTO kkl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kulukulaoba, Yesus Nia Mangkina Salehiropneri samenag lebogne ane, 'Yohanesti samenag nimi maghag pelengelamsiogne mag moag pelengkipsiog aghana, Allahri Eldamne Yame Walinge a'unag pelengkatsilul,' seogne nene el wamnori, wamno. ");
INSERT INTO kkl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nangkabo, nuri sik uro seneraglamapne, '”Mog so'oag nimi taulbahimendi, saelbamsululam,” aro Allahri wepto poghol aogne Yesus,' aro seneragoboba, Allahri Eldamne Yame Walinge nunag tatsiog. Nunag tatsiogne saog uro sin nimi taneko babe tatsio aghana nari welaro Allahag, 'Tatsiseng kom,' sehene?” aro Petrusti elkabo Yahudi sisa nimiag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ambatsiogpa, ka'ebaekpa, wana wali tahiogpa, Allah omeklamekti, “Yaghe! Allahri Yahudi sisa kom nimi babe yeplamsildi, 'Allahri opsileag,' aro sin Yahudi sisa kom nimiri malia ulamangne lililamsiang. Allahri yeplamsilba, malia ulamangne lililamsiangdi, Elag omeklamangba, Allahri opsulul kom. Ya'ag kamag wamukang,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","20","Petrusti “Yesus sembe ambarel phinun,” aro as Kaisarea anam pin komag, samenag Stefanusti Yesusag sikne aro seneraglamogne sembe Yahudi nimiri Stefanus ya'ag obek. Stefanus obekti, Yesusag “Sikne” aro senaragtop nimi yogne babe Yahudi nimiri sare nelepto olamsiek. Olamsiekpa, Yesusag “Sikne” aro seneragtop nimi taneko nimi anabi tang-tang piek. Nimi anabi tang-tang piekagna, nhon-nhon a'el talamekti, mog so'o Fenisia palamekpa, as Antiokhia inagha tang-tang piek. Nimi orange mag alip toman heng pulingkirobag sip palamekti, mag longo kanektop mog so'o Siprus piek. Piek abeneko pere yubu walinge Yesus sembe ambarelamsiek. Yesus yubu ambarelamsiek, aghana ot Yahudi nimiag aghabog yubu walinge ambarelamsiekti, Yahudi sisa kom nimiag ambarelamsiek kom. Undo unuaekpa, yog nimina, mog so'o Siprus nimiap, mog so'o Kirene nimiapti yubu walinge Yesus sembe ka'ebaekti, as Antiokhia piekti, Yahudi nimi agha Yunani nimiri saelba uropne ul palamek nimiag yubu walinge ane tipto ambarelamsiek. Yubu walinge ambarelamsiekne, “Allahri, 'Mog so'oag nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne Yesus nunag yaog,” aro ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nia Mangkina Salehiropne ponekori sin yeplamsiogpa, nimi maikno Yesus sembe yubu ambarelamsiek. Ambarelamsiekpa, ka'elamek nimi tanekori mali-malia ulamekne lililamsiekti, Nia Mangkina Salehiropne Yesusag “Sikne,” aro wanaag seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","As Yerusalem Yesusag “Sikne” aro seneraglemek nimiri ka'elamekti, “As Antiokhia Yahudi nimi agha Yunani nimiri saelba ulamangne sunsunum uro ul palamang nimi maiknori Yesusag wana seneraglamang,” alameka ka'ebaek. Ka'ebaekti, Yahudi nimi Yesusag “Sikne” aro seneragtop nimi Yerusalem wamekne tanekori, “As Antiokhia nimiag uro yabalamlange kemel phululam,” aro nimi si Barnabas poghek. ");
INSERT INTO kkl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas neneko kulomag Allah Eldamne Yame Walingeri wa'iogti, teknero ua ulamogpa, Barnabasti wanaag Yesusag “Sikne” aro to'opto seneraglamogti, walia aghabog ulamog. As Yerusalem nimiri Barnabas poghekpa, as Antiokhia piogti, kemelamsiogpa, “Allahri sin sembe wali sembamsildi, Eldamne seneragna sunsunum uro walia tarelamsil,” aro Barnabas awi sembaog. Awi sembaogti, wenelamsiogti, “Wene Yesusag wana seneraglamlomne nene wali. Wana phende seneragseng kom. 'Yesusti ya'ag saelbamsilul,' aro a'ero-a'ero wanaag seneraglamlulom,” aro wembahiog. Barnabasti Antiokhia nimi wana wali uro wenelamsiogpa, nimi maiknori malia ulamekne lipsiekti, Nia Mangkina Salehiropne Yesusag “Sikne” aro seneraglamek nimi maikno tangto palamog. ");
INSERT INTO kkl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wameka Barnabas neneko, “Saulus ebanun,” aro as Tarsus piogti, ");
INSERT INTO kkl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saulus ibogti, samoro as Antiokhia enero payaog. Enero payaogti, as Antiokhia Yesusag “Sikne” aro seneragtop nimiap wamekpa, Saulusap Barnabasapti Allah yubu samenag ambatsiogne pere agha Yesus sembe tibin nenero nimi maikno ambarelamsirekpa, heng kun nhon taog. Yesus yubu ka'ero ulamek nimi sembe samenag yum-yum as Antiokhia asag anea sisa Kristen aro engelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wamekpa, Yerusalema Allahri yubu silimu tiptop nimi as Antiokhia yaek. ");
INSERT INTO kkl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yaek nimi taneko nhon sina Agabus Allah Yame Walingeri el pere agha yubu lelamogti, “Mog so'o Roma nimi saelbamsiek mog so'o niag kwaneng yo nubunge waelbalul,” aro ambatsiog. Ambatsiogne nene yubu sia leropne nubunge Kaisar sina Klaudius nimi saelbamsiog li kwaneng yo neneko waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kwaneng yo neneko waelbaogpa, Yesus yubu ka'ero ulamek nimiri, “Nungkabo Yesusag 'Sikne' aro seneragtop nimi Yudea wamangne kwaneng yo maiknori, nuri yepsukap,” aro yubu saekag lebek. Yubu saekag lebekti, Yesus yubu ka'ero ulamek nimi ni as Antiokhia wamekneri saeag phelekto wamogha sunsunum uro, “Yudea nimi tatsinun,” aro kal ma'al poloro palilamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Poloro palilamsiekpa, “Sikindoyabo wenehiropnang Yudea wamangneag tarel phululom,” aro Barnabasap Saulusap pogsiekpa, pabalamdek. ");
INSERT INTO kkl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kwaneng yo nubunge waelbaog li enekoag Roma nimi saelbamsiogne Kaisar Klaudius umag Yahudi nimi sembe yubu sia leropne nhon babe sina Herodes wamog. Yubu sia leropne Herodes nenekori “Yesusag 'Sikne' aro seneragtop nimi seklebaukang,” aro ilipsabo yin saleropnang pogsiro “Haing sae kaupto poa yalamsululom,” aro ambarelamsiogpa, elag poa yalamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nimi elag poa yalamsiekne anabiag agha nimi nhon sina Yakobus, Yohanes eldo wamog. Herodesti el umag nimiag, “Yakobus neneko karoghag agha karepto oplulom,” aro arukahiogpa, ya'ag obek. ");
INSERT INTO kkl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Obeka sembe Yahudi nimiri “Wali,” aro awi senelamekpa, Herodesti ipsiogti, “Petrus babe saelbalulom,” aro arukahiog. Herodes ilipsabori Petrus saelbaek sumenena, Yahudi nimiri kwaneng roti walerop komne tero ik etpare Allah omekto wameka, ik nhon sum eneko Petrus sae kaupto saelbaek. Petrus saelbaekti, kop aeag tolongolamekpa, Herodesti el umag yin saleropnang ao tara bare nangag ambarelamsiogti, “A'un ina siram sunuro nimi tombare-tombare yae wamlulom,” aro ambatsiog. Wene aro ambatsiogti, “Allah omekto kwaneng roti walerop komne terop li liogha Petrus tam ane nimi maikno whingag karebanun,” aro Petrus kop aeag tobongkibog. ");
INSERT INTO kkl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petrus neneko kop aeag aneko wamogpa, Yesusag “Sikne” aro seneragtop nimi tanekori sol wali, wali uro, “Petrus yeplulam,” aro Allahag molona mololamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodesti, “Ambuhum nimi maikno wamika haingag agha tam karebaukap,” aro wamogpa, Petrus neneko sae tara-tara yin salerop nangdi saeap a'amsuro kaubirekpa, Petrus malamog. Sindi sae a'amsuro kaubirek haing aneko besi agha sorop haingag agha kaubirek. Petrus malamog ae lom ina siramag yin salerop nang nenne babe yae wamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yae wamekti, wamekpa, Nuni Allahri Eldamneri arukna malaikat poghogne neneko Petrus malamoghag wa'iogpa, Petrus wamog ae lom eneko warelobog. Allah arukna malaikat anekori Petrus malamogha kaombaogti, “Nangkae, elemag puke,” alamog abeneko besi agha sorop haing sae kaubamek haing eneko loptangka timbaog. ");
INSERT INTO kkl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Loptangka timbaogpa, Allah arukna malaikat anekori Petrusag yubu lelamogti, “Anenge uoghag nopna noptoba nopto amendi, yan wangana wangaro alulam,” seogpa wangkaog. Wangkaogpa nen lelamogti, “Ag nongagne enekto amendi, nanag sarenelebanululam.” seog. ");
INSERT INTO kkl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Wene seogpa, Petrus kop aeag anekoa lanaro Allah arukna malaikat nelepto lanalamogti, Petrustina, “Ot sik uro Allah arukna malaikati lobolanel,” semban koma, “Lenda malamna to,” senero Allah arukna malaikat nelepto lambaog. ");
INSERT INTO kkl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Allah arukna malaikat nelepto palamogti, yin salerop nang ina siram tenap lomag tao weamekne phibom agha, nen tenap phendepne yae wamekne phioro asag lambanebag besiri soro lingnil oropneag palamdekpa, ina siram aneko mo kuptaog. Mo kuptaogpa, lanaro palamdekti, ina ingkisag anekoa palamdekti, Allah arukna malaikat anekori Petrus laploa piog. ");
INSERT INTO kkl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ina ingkisag aneko pirekti, Allah arukna malaikat anekori Petrus laploa piogpa, wana hegkaogti, “Yahudi nimiri na 'Obukap,' sembamangdi wamang, aghana Allahri eldi arukna malaikat arukalba, Herodes saeag agha Nani Allahri taulbanelba, wene sik uro el tanel,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Undo wene seogti, seneraglamogti, Yohanes si nhon Markus ilin Mariari aeag piog. Ae neneko nimi maikno poloro tekne amekti, Petrus sembe Allahag molona mololamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ae enekoag piogti, leka toroba ina siramag kaungkaogpa, “Etneri kaungulamla,” aro Maria arukna kelabo sina Rode nenekori kemel aog. ");
INSERT INTO kkl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kemel aogti Petrus yubu lelamogha ka'ebaogti, awi lelem ina kupna koma, “Nimi ambatsunun,” aro ae lomag piogti, “Petrus asag wamla,” aro nimi longoro tekne amekne ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ambatsiogpa sindina, “Anna serem saelbamlamdi, lelamlam,” aro wene alamekpa, eldina, “Ot sik,” seogpa sindina, “Allah arukna malaikatti Petrus piamlange yalba lelamla,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yubu undo lelamekpa, Petrusti ina kaungu-kaungu palamogha sembe ina kupto kemelamekpa, Petrus ina siramag wamogha ibekti, “Logti, mane agha yal,” sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Logti, mane agha yal,” sembaekpa, Petrusti, “Yubu kom talulom,” aro sae maubitsiogti, “Nuni Allahri eldi arukna malaikat poglaba, kop aeag agha enero poa lambitnelba yan,” aro ambatsiog. “Ambatsinne nene Yakobusap, nungkabo Yesusag 'Sikne' aro seneraglamang nimi yogneap ambatsululom,” seogti, lamba as oraag piog. ");
INSERT INTO kkl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lukunap yin salerop nang Petrus yae ulamekne tanekori, “Petrusag sa'a agha ualba, welaro lambal?” aro logti, sin mamun maikno haum aro lelamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yin saleropnang taneko logti, sin mamun maikno haum aro lelamekti, wamekpa, Herodes nenekori, “Petrus ebalulom,” seogpa, sen-senna ebaek. Ebaekpa, orogti, Herodesti, “Yin salerop nang Petrus yae wamek nang payahilulom,” seogpa, payahiekpa, Herodesti hailamsiog. Hailamsiogti, “'Sindi saeag agha lambal,' aro opsululom,” seogpa, yin saleropnang orangeri, “Opsukap,” aro pabahiek. Undo Herodesti saeag agha Petrus Allahri lambirogpa, Herodes neneko mog so'o Yudea laplobi agha as Kaisarea piogti, wamog. ");
INSERT INTO kkl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodesap mog so'o Tirus nimiap mog so'o Sidon nimiap sin iriktangto saog uro wamekti, Herodesti sin sembe yo senelamog. Yo senelamog aghana Herodesti mog so'oag agha sindi tisirik wamogpa, Tirus nimiap Sidon nimiap ma'aptaekti, “'Nimi nubunge Herodesap nunap tam wamlul kom,' aro elag yubu lel pukap,” aro piek. Elag piekti, nimi nhon si Blastus, yubu sia leropne Herodesti yubu eptopne ae lomag o'olamsiogne ponekoag, “Herodesap nunap ma'aptaukap,” aro samenag yubu yangaro lebekpa, Blastus sinag sip taog. Blastus sinag sip taogti, Herodesag yubu tipto ambarogpa, ");
INSERT INTO kkl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodesti, “Sinag yubu lemnun,” aro yubu pibog. “Yubu lebukap,” seog sumeneko yaogpa, nimi nubu nimiri enektop ag enekaogti, elel molel aroba towalengkaogti, nimi nubunang salehiropnang purobag pulingkiogti, sinag yubu lebog. ");
INSERT INTO kkl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yubu lelamogpa, ka'eamek nimi tanekori “Nunag wali sembahilul,” aro kibiang towalengelamekti, “Nimiri yubu lelamla kom, phia phalamapne imag wamlange nimi saog taldi, lelamla,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wene alamekpa, Nuni Allahri “Mog so'oag nimiri Na mo omekaneheng aghana, Herodes omeklamang. Omeklamangba, Herodesti, 'Na omekaneheng kom. Allahag agha omekalulom,' senep aghana, 'Wali omeklamneang,' sembaldi wamla,” aro Allahri Eldamneri arukna malaikat, “Herodes oplulam,” aro poghog. Poghogpa, Herodes obogpa, kolagti tero tebaog. ");
INSERT INTO kkl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Herodes tebaogpa, yubu kom taog aghana, Allah yubu nubu taogpa, nimi maiknori, “Allah yubu wali,” aro ka'elamek. ");
INSERT INTO kkl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasap Saulusapti as Antiokhia nimiri sae agha pabireka taneko tatsirekti, Yerusalem laplobi agha samoro yalamdekti, Yohanes si nhon Markus neneko enero poa yarek. ");
INSERT INTO kkl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Saulasap Barnabasap samoro yarek li as Antiokhia Yesusag “Sikne” aro seneragtop nimi haibil talamek nimi anabiag Allahri yubu silimu tiptop nimi Allah yubu tibin nenero ambatsirop nimi wamek. Allahri yubu tipto tibin nenero ambatsirop nimi taneko sina: Barnabasap, Simeon si nhon Nigerap, mog so'o Kirene nimi nhon si Lukiusap, Saulusap, Menahenap wamek. Menahen ponekona yubu sia leropne Herodesap nhon mo'obhaiekpa, Herodes elkae Menahen wamog. Sin Allahri yubu silimu tiptop nimi wamekti, as Antiokhia nimi Yesusag “Sikne” aro seneragtop nimiap nhon haibil talamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ik nhon sum kwaneng ten koma Nuni Allahag omekto molona mololamekti, wamekpa, Allah Eldamne Yame Walinge nenekori sinag yubu lelamogti, “Nari samenag, 'Uanun,' sembanori, Barnabasap Saulusap, 'Nari sae tarikti, nari awe tolamtukang,' aro karepto wepto pipsinori, yoplamsin. Yoplamsinnena, a'un Antiokhia nimiri sinag ambatsumundi, 'Ot Allahri, “Undo-undo tolamturom,” selenge aghabog tolamturom,' aro sin phende wepsimundi pogsululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wene aro Allahri ambatsiogpa, nen kwaneng tero koma Allahag molona yubu moloro wameka Saulusap Baranabasap usoghag sae pipsiekti, “Allahri 'Awe undo-undo tolamturom,' selenge tol pururom,” aro pogsiek. ");
INSERT INTO kkl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Allah Eldamne Yame Walinge nenekori Barnabasap Saulusap pogsiogpa, pirekti, as Seleukia pin togha kabongag agha mag alip toman pirekti, mag laut longo kanektop mog so'o Siprus pirek. ");
INSERT INTO kkl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pirekti as Salamis anekoa Yahudi nimiri Allah yubu lerop aeag agha Allah yubu ambarelamsirek. Allah yubu ambarelamsirekti, wamdekpa, nimi nhon sina Yohanes Markus nenekori sin phende yeplamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","As Salamisa heng walelingkirobag sip mag abolag wamdeka lambaekti, Siprus so'o inagha heng pulingkirobag simbik palamekti, as nhon mag abolag heng pulingkirobag sip si Pafos piek. As Pafos piekag aneko nimi nhon sina Baryesus Yahudinge haiptaek. Baryesus Yahudinge ponekori, “Allahri yubu ambatneonge tipto ambarelamsin,” aro orolena yubu lero mema mili lero phalamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Baryesus poneko elkae Siprus so'o saelbamogne nimi nubunge sina Sergius poneko wamog. Nimi nubunge mog so'o eneko saelbamogne sina Sergius, si nhon Paulus, neneko wana hekto wamogti, “Barnabasap Saulusapti Allah yubu tibin nenero ambarelamsirangne ka'ebanun. Enero payahilulom” aro nimi pogsiogba, Sergius Paulus wamoghag Barnabasap Saulusap payahiek. ");
INSERT INTO kkl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Payahiekpa, Allah yubu ambarelamsirek aghana mema mili lero pharopne Baryesus, si nhon Elimas ponekori, “Sin phenderi ambarelamsirangne sembe karong,” senelamog. “Karong,” senelamogti, “Nimi nubunge mog so'o saelbamogne ponekori wana Yesusag seneraglul kom,” aro mema ulamogne ponekori Sergiusti seneragna sao kauplolamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sao kauplolamogpa, Allahri Eldamne Yame Mikipne Saulus nongag to'opto piamogpa, mema ulamogne Elimas poneko yop-yoba kembaog. Yop-yoba kembaogti, Saulus, el babe si nhon Paulus nenekori, yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Phia yonge saog uro wamlam. Wanaag malingeog seneraglamlamdi, yubu orolenangeog lelamlam. Nimi nhondi sik uro yubu leropne babe, porog uro toropne babe, 'Karong,' alamlamdi, 'Nari aisa,' aro iriklamlam. Nia Mangkina Salehiropne poneko sembe porog uro ambarelamsin aghana, sengkwanekto nenelamlam. Undo ulamlamne libe! ");
INSERT INTO kkl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nia Mangkina Salehiropne poneko saeri wene 'An opkunun,' aro yalamlange wene tiboghae, haing uroba wapmendi, heng olog imna koma wapmen paghabog ik etbare talul,” aro wabaog. Wene aro Paulusti walamog abeneko pere nimi eneko haing uro toa saogne marukul aogpa, “Nimiri sae saelbanukang,” aro sale wihi-wihi palamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Undo unuaogne sembe Siprus so'o wamekag saelbamogne nimi nubunge poneko kembaogti, “Barnabasap Paulusapti, 'Yesusti nia mangkina saelbamsil,' aro mane agha sik uro ambarelamsirang,” aro Yesusag “Sikne” aro seneraglamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Wameka Paulus elkaboap as Pafos laplobiagha mag alip toman agha piek. Mag alip toman agha piekne, ag kabongag kerekaekpa, “Phoanari ko'oro pabalamlul,” aro kerektop ag towalengkaekti, mag alip toman agha piekti, as si nhon Perga Pamfilia so'oag piek. Piekti, Yohanes Markus neneko sin Perga laplobiagha as Yerusalem samoro yaog. ");
INSERT INTO kkl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Samoro yaogpa, sin taneko Perga phibom agha piekti, as Antiokhia Pisidia so'oag yingkiek. Yingiekti, wamekpa, Yahudi nimiri Allah yubu lerop sum taogpa, Allah yubu lerop aeag wa'iekti, pukamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wa'iekti, pukamekpa, Allahri samenag Musa ambarog yubu mome toro pibekneap, Allahri yubu silimu tiptopnangdi yubu mome toro pibekneap sangkaekti, ambarelamsiek. Mome sangkaekti, ambatsiekti, wa'amogto pibekti, Allah yubu lerop ae saleropnang tanekori nimi nhon poghekpa, Paulusap Barnabasap hailamsiogti, “Nangkabo, a'undi nimi tane sembe 'Wana aingnibahununam,' senenne wamla tanena sektumundi yubu ambatsururom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Wene seogpa, Paulus sekogti, sae la'abatsiogti, yubu lelamogti, “Israel nimi nangkabo, yog nimiri Allah yubu sunsunum uro ul palamlom nimi babe nangkabo, nari lemnunne nene ka'eamlulom. ");
INSERT INTO kkl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allahri samenag agha nu Israel nimi pia ulamsiogne ponekori nu Israel nimi nunisa yabo samenag wepsiogpa, mog so'o Mesira nimi yangkan nang saog uro wamek aghana, 'Maikno taukang,' aro nubu nembahiog. Maikno nembahiogti, El sae mikipne nenekori saelbamsiogti, mog so'o Mesira enero poa lambahaiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Poa lambahaiogpa, pai aldesag saog urobag wamogti, sindi malinge aghabog ulamek. Malinge ulamekpa, 'Opsinun,' sembaog aghana wana palingkiogti, wamog pahabog heng tai buka tau buka ulamogha heng kun selek ta'om agha epto naual bare (40) taog. ");
INSERT INTO kkl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Selek ta'om agha epto naual bare taogpa, Allahri, 'Kanaan so'o Israel nimi sisa nimiag tatsinun,' aro Kanaan so'oag wamekne nimi sisa saekbare ene Allahri oro luknubahiog. Oro luknubahiogpa, Israel nimi lelnero ngai talamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Israel nimi sikinisag Israel poneko el maboap samenag Mesir yaekti, wamekti, Israeldi mangaroba mangarobari mangkahiekne Mesir so'o laplobiagha Kanaan so'o ngai taekne ni ane hengkun teng ao tarabare eptopneap (450) palamogpa, wamekti, Israel nimi Kanaan so'o lelnero ngai taek. Ngai taekti, nimi nubu nang tam lelekto kemero kareptop nimi Allahri sekililamsiogti poglamsiog. Israel nimi sembe tam lelekto kemero kareptop nimi komoptobagnena Samuel sekirog. Samuel ponekona Allahri yubu silimu tiptopne wamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel wamog li enekoag Israel nimiri, 'Yubu sia leropne nubunge saelbamsilulne nhon sekitsimenba, towalengkibukapti,' alamek. Israel nimiri wene alameka ka'ebaogti, Israel elme Benyamin mangarobari mangaroba mangkahiek nimi agha nimi nhon Allahri webogti, Kis elme Saul poneko sekirogpa, towalengkibek. Towalengkibekpa, Israel nimi saelbamsiogti, hengkun tai buka tau buka ulamogha teng nhon epto naual bare taogpa, Saul tebaog. ");
INSERT INTO kkl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saul tebaogpa, el lunumna Daud Allahri sekirogpa, Israel nimiri, 'Nu saelbamsileri, yubu sia lelamlul,' aro towalengkibek. Daud sembe Allahri samenag lebogne ane, 'Na Allahri wanaag seneragna sunsunum uro Isai elme Daudti babe seneraglamla. Nari yeng senenne ni sunsunum uro ulamlulne, Na el,' aro Allahri wene seog. ");
INSERT INTO kkl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Daud poneko sembe Allahri, 'Daudti mangaroba pere agha Israel nimi taulbahinepne nhon mangaptalul,' aro Allahri salag pibog. Salag pibogne neneko Yesus sembe lebog. ");
INSERT INTO kkl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","El anam yanep peramag Yohanesti Israel nimi, nimi ni ambarelamsiogti, 'A'un malia ulamlomne wali uro seneragmundi, lililamsimun tanena maghag pelengkipsinun,' alamog. ");
INSERT INTO kkl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohanes nenekori Israel nimi komopto ambarelamsiogne peram taogpa, eldi yubu ambarelamsiogti, 'A'undi, “El yalul” senelamlomne poneko na kom. Na sam yano aghana El nenekona, olog amik yalul. El nubunge ponekori yan wangana nari haing lopna babe sunsunum kom,' aro Yohanesti samenag ambatsiog,” aro Paulusti ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Wene aro Paulusti ambarelamsiogti, “Nangkabo, Abrahamdi mangaroba wamapneap, Allah yubu sunsunum uro ul palamlom nimi yogne tane wamlomneap, samenag 'Nimi taulbahinepne yalul,' aro wene seogne poneko yaogpa, Allahri nunag salag pibogne sunsunum uro, uro yabiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Allahri salag lebogne nunag taogne uro yabiogne ambatsinun. Allahri 'Nimi taulbahinepne yalul' seogne poneko, 'Na Yesus. Na Allahri wepto pogholaneo,' seog aghana Yerusalem nimiap, sikini yabo saelbamsiek nang tanekori babe Yesus el nong babe yubu babe wa'eplamek. El neneko tam karebaekti, 'Tebalul,' seekne neneko samen Allahri, 'Sik uro yabilul,' aro el uro wamog. El uro wamogpa, Allahri yubu silimu tiplamek nangdi samenag Elag amik uro yabilulne sembe samenag mome toro palilamek. Mome toro palilamekpa, samenag agha wene babe Allah yubu lerop sum talamlaba, nu Yahudi nimi niri mome palilamekne sop-sop lelamapti, ka'elamap. Allahri yubu silimu tiptopnangdi mome toro palilamekne Yerusalem wameknangdi babe ka'elamek aghana, yubu tolamek komdi, Allah yubuag 'Uaukang,' aro ambatsiekne neneko sunsunum uro 'Tebalul,' aro karebaek. ");
INSERT INTO kkl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","'Tebalul,' aro karebaekpa, nimiri El sembe 'Sik eldi ane malia uao,' senep kom aghana, Roma nimi nubunge Yahudi nimi wamekag mog so'o salehiropne Pilatusag, 'Ya'ag oplulom,' aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Samenag El sembe Allahri yubu ambatsiogne mome toro pibeka sunsunum uro Elag uaekpa, kalag agha pelengkaekti, kirik arameag wirikil wa'iek. ");
INSERT INTO kkl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wirikil wa'iekti, piekpa, nimi teptobag wamog aghana, Allahri nimi teptopne nusamag agha El neneko kamag nembaog. ");
INSERT INTO kkl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kamag nembaogpa, Elap nhon Galilea agha Yerusalem palamek nimi taneko sae a'iliro wamekpa, sin haingag lag tangom tognop tangom alamogne sembe, 'Nuri haingdi ibubu,' aro nimi tane wene ane ambarelamsiang. ");
INSERT INTO kkl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Wene ane nen tipto ambarelamsiapnena, 'Samenag nunisa yaboag Allahri salag pibogne neneko wene uro palamla,' aro yubu walinge neneko wene ane a'unag ambarelamsiap. Sindi mangarobari mangaroba mangkahiekne wene wamapne nuri haingag agha Allahri Yesus kamag nembaog. Undo kamag nembaogti, Allahri samenag, 'Uanun,' aro salag pibogne sunsunum uro wene nuri haingag agha uaog. Nunisagyabori samenag Allah omekto sepna siplamekti, sepna phendepneag Allahri yubu lebogne agha mome toro pibognena ane, 'Anna Na Name, Na sumene andi nai tan,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allahri Yesus nimi teptopne wameka anabiag agha kamag nembaogpa, 'So'oag agha ya'ag nong polbalul kom,' aro Allah yubu lemnunne nene mome toro pibogne ane: '”Nandamne wanaag agha Daud sembe walia uanun,” aro salag pipsinge sik uro uanun. Daud sembe salag lero pipsinge a'unag tipto tatsinun.' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sepna nhon babe siplamogti, mome toro pibognena, 'Anenge Arukna Sol Wali Walinge neneko so'oag agha polbalul kom,' aro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","'Polbalul kom,' aro mome toro pibog aghana, Daud poneko el uro wamogti, Allahri seneropne wali uro ulamogti, sabal taogti, tebaog. Tebaogpa, iliyabo teptoba pibekag aneko tobongol piekpa, polbaog. ");
INSERT INTO kkl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Undo unuaog aghana Yesus neneko Allahri kamag nembaog. Daud polbaog saog uro polbaog kom,” aro ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Paulusti wene aro ambarelamsiogti, “Nangkabo, 'El Yesus neneko wamogti, ulamogha pere agha Allahri a'undi malia ulamlomne tam orog nembalul,' aro ambarelamsinne a'un ekon uro wamnep kom. Samenag Allahri 'Undo-undo ulamlulom,' aro Musaag yubu ambarelamogpa, mome toro pibog. Musa yubu mome toro pibogne salelamap aghana malia ulamap tanena Allahri nu sembe 'Porog urop nimi,' sembalul kom. Nu sembe 'Porog urop nimi,' sembalul kom aghana, nimi etneri Yesusag 'Sikne' aro seneraglamleba, sembenga uropne tam orog nembi agha, Allahri nimi ane sembe 'Porog urop nimi' sembalul alamna. ");
INSERT INTO kkl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ane sembe, samenag Allahri yubu silimu tiptopneri mome toro pibekne neneko saog uro a'unag uro yabileagti, wanaag el uro wamsuri, wamsut: ");
INSERT INTO kkl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Allahri yubu silimu tiptopne nhondi mome tobogne ane, 'Wene wamlom ko'o ene, “Nari uanun,” sembanea uanun. A'unag tibin nenero ambatsiika babe a'undi sik sembalulom komne webanun. Allahri yubu seneragtop kom nimi, wali uro tibogamsut! “Yaghe! Mane agha ual,” sembamundi, Nari yubu ka'eapmun kom tanena tebalulom!' aro mome tobog,” aro Paulusti komopto ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulusti yubu ni ambatsiogti, Barnabasap lanalamdekpa, nimi tanekori, “Sumene yubu ambatsilamne nen tipto Allah yubu amik lebukap sumono babe yingkina ambarel ahirurom,” aro molbahiek. ");
INSERT INTO kkl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Allah yubu lerop aeag haibil talamek nimi lambaekti, Yahudi sisa nimi maiknoap, Yahudi sisa kom nimi Allah omektop nimi taek nimiapti Paulusap Barnabasap nelepto palamek. Sin amik palamekpa, sin phenderi nimi taneko wenelamsirekti, “Allahri nimi so'oag nimi Yesusti uaogne pere agha talulamsilne ponekoag sinag kweleknag seneraglamlulom,” aro ambarelamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wene aro ambarelamsirekti, wamdekpa, Allah yubu lerop sumeneko peram taogpa, as eneko nimi ni wa'al aloa saog uro, nimi maikno, “Nia Mangkina Salehiropne Yesus sembe Allah yubu pere agha ambatsurukangne ka'ebaukap,” aro yalamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nimi maikno yalameka Yahudi nimiri ipsiekti, “Nimi maikno ambarelamsireka ka'el wa'alamang,” aro wana sek tahiogpa, u kwa'en pa'alamsiekti, “A'undi lelamdomne orolenange lelamdom,” aro Paulus san tiliplamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wene aro san tiliplamekpa, Paulusap Barnabasapti log kom uro ambarelamsirekti, “Nangkabo, a'un Yahudi sisa nimiag samen Yesus sembe Allah yubu pere agha ambatsinomonge, ora sisa nimiag samen ambatsinep kom wamo. A'un samen yubu walinge ene ambatsinomo aghana a'undam nimiri, 'Karong,' aro lililamsilom. A'undi, 'Kamag nenehirop yubu ambarelamsilne nu seneraglamukap komdi, ya'ag kamag wamukap kom,' aro kareplamlom. A'un Yahudi nimi tane wamlomne yubu ene tolamlom kom ane sembe, nuri Yahudi sisa kom nimiag yubu walinge nene ambarel phukap. ");
INSERT INTO kkl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","'Undo ulamlulom,' aro Nuni Allahri nunag samenag yubu pibogne ane, '”Allah yubu ekon nang Yahudi sisa kom nimi sembe an whea walinge saog uro wamlulam,” aro sekitkehiba, andi nimi so'oag sirikag-sirikag wamangneag pimenba, el taikpa, sin taulbahinep,' aro mome toro pibog. Mome ane undo toro pibogne ane sembe, Yahudi sisa kom nimiag yubu walinge nene ambarel phukap,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wene aro ambatsiogpa, Yahudi sisa kom nimi tanekori ka'ebaekti, “Nia Mangkina Salehiropne Yesus sembe yubu ambarelamsirekne walinge” senelamekti, awi yeng senelamek. Allahri samenag “Ya'ag kamag wamlulom,” aro wepsiog nimi tanekori “Sik uro ambarelamsirang” aro Yesusag “Sikne” aro seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nimi ni as kanero wamekne taneko Nia Mangkina Salehiropne Yesus sembe ambatsirop yubu nubu taogpa, ka'elamek. ");
INSERT INTO kkl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nimi taneko Yesus yubu ka'elamekpa, Yahudi nimiri “Paulusap, Barnabasap nu karongdi, nuri asag agha yag lambitsukap,” aro ulamek. As tanekoag kelabo sikininyabo saog uro wamek kelabo taneko Allah omeklamek kelabo Yahudi nimi tanekori yubu yangaro wana tolamsiekti, nimi nubu nang as tanekoag babe wana tolamsiek. Wana tolamsiekti, nimi maikno sikin sip tangto, “Paulusap, Barnabasap opsukap,” aro malia ulamsiekti, as enekoag agha yag lambahiek. ");
INSERT INTO kkl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","52","Yag lambahiekpa, Paulusap Barnabasap lanalamdekti, sindi yanag so'o ubun wamogne “As aneko Allahri opsinepne sembe el uro wamukang,” aro so'o ubun kepto pelengkia pirek. As Antiokhia laplobi agha pirek aghana, ambarelamsirekne ka'elamekti, sunsunum uro ulamek nimi, samenag Yesusag “Sikne” aro seneraglamek nimi taneko sin wana awi yeng uro wamek. Wamekpa Allahri Eldamne Yame Walinge sin nongag to'opto palilamsiogpa, wamek. Wamekpa, Barnabasap Paulusap as Ikonium pirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulusap Barnabasap as Ikonium pirekti, Yahudi nimiri Allah yubu lerop aeag wa'irekti, Yesus sembe Allah yubu pere agha tibin nenero wali uro ambarelamsirek. Ambarelamsirekpa, Yahudi nimiap Yunani nimiap nimi maiknori, “Sik uro ambarelamsirang,” aro wanaag seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yahudi nimi nenneri, “Paulusap Barnabasapti yubu orolena ambarelamsirang,” senelamek nimi tanekori, “Yesusag 'Sikne' aro seneraglamang nimi ene mali,” aro wana aluktop yubu yangaro Yahudi sisa kom nimi taneko wana tolamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wana tolamsiek aghana Paulusap Barnabasap ik maiknoro as Ikonium wamdekti, “Nuni Allahri Yesusti uaogne pere agha mog so'oag nimi talulamsil,” aro log kom uro ambarelamsirek. “Sindi yubu ambarelamsirangne nimiri sik sembaukang,” aro nia mangkina Saelbamsilne ponekori sinag mikip nenelamsiogpa, Allah Eldamneri uanepne nimiri uanep komne ulamdekti, “Yaghe, Allahri sin pere agha ual” senenne kekneba ulamdek. ");
INSERT INTO kkl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kekneba ulamdekpa, as eneko wamek nimi taneko as pogto nenne Yahudi nimiag sip talamekpa, nenne “Yesus sembe sik uro ambarelamsirang,” aro Barnabasap Saulusap sinag sip talamek. ");
INSERT INTO kkl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Sin pogtaekti, Yahudi sisa komnangap, Yahudi nangap sin sikindo yaboap winiptaekti, “Paulusap Barnabasap oro saelbahiberi, kirikti ya'ag opsukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","“Sin opsukap,” alamekne eltarekti, Paulusap Barnabasap as enekoag agha lambarekti, Likaonia so'oag pirekti, Likaonia so'o enekoag as Listraap Derbeap pirek. Pirekti, as eneko kanero wamek nimi wamekne yubu walinge Yesus sembe ambarelamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","As Listra aneko nimi kabuni nhon mangaptangto yangkaoghag agha yan malia mangap taogha seka pana babe erarukne nhon wamog. ");
INSERT INTO kkl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pukamogha Paulusti Yesus sembe tibin nenero yubu ambarelamsiogne yan mali nimi enekori ka'ebaogpa, Paulusti whing ebom agha til talamdekti, Paulusti, “Nimi eneri 'Yesusti Nia Mangkina Saelbamsil' aro ambarelamsinne sik sembal. Ane sembe na sae pere agha Yesusti el yan wali nembalul,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulusti wene sembaogti, nimi enekoag yubu mikip uro lelamogti, “Yan mikip uro sekelabi,” seogpa, nimi eneko lopnagha sekelabiogti, pang yang ulamog. ");
INSERT INTO kkl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sekogti, pang yang ulamogha nimi maikno tanekori Paulus sae pere agha nimi taneko wali taogha ibekti, “Nimiri uanep komne uarang,” alamek. Alamekti ibek nimi tanekori Likaonia yubuag haum aro nimi ambarelamsiekti, “Phia phalamsiapne imag wamanga nimi saog tarangdi, so'oag yingkina ulamdang,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","“So'oag yingkina ulamdang,” alamekti, Barnabas sembe “Nuri phalamap phia,” aro si Zeus engkaekti, Paulus babe, “Yubu maiknoro ambarelamsildi, yubu tiplamla phia,” aro si Hermes engkaek. ");
INSERT INTO kkl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wene aro engkahiekpa, as Lystra leka kanero solingkirobag paiag sip ina peramag, Zeus pharobag mem ae soroba soropne wamog. Zeus pharobag mem ae wamoghag memne Zeus sembe pairopne ponekori as Likaonia nimiri wene alameka ka'ebaog. Ka'ebaogti, pham sapi yemneog tobogti, uwong-uwonga kal es agha lomoro pham sapi tanekoag kwiria elekahiogti, “Zeusap Hermesap pham sapi oro phalamsukap,” aro nimi maiknoapti as leka solingkirobag ina siram peramag yagto payalamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Undo unulameka Allah Eldamne Yame Walingeri wepto pogsiognang Barnabasap Paulusapti ka'ebarekti, eltarek. Eltarekti, “Sindi mema phalamangne nene uanep komne ulamang,” aro Barnabasap Paulusapti ag enekto amdekne taepto epsirekti, nimi maikno nusamag lopnagha wa'irek. Nimi nusamag wa'irekti, yubu lelamdekti, ");
INSERT INTO kkl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nangkabo, nene sa'a agha ulamlom? Nu nimi a'un saog uro so'oag nimi wamnam. A'unag yanomonge, '”A'undi teba'en uroba lebe arop komne phalamlomne lipsumundi, wailag nembamundi, Allah ya'ag kamag wamlange im, so'o, mag nia mangkina wamlange sumbaogne ponekoag wanaag seneraglamlulom,” aro yubu walinge ambarel ahanunam,' aro yanomo. ");
INSERT INTO kkl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Samen a'unisagyabo wamek ko'oag Nuni Allahri, 'Nimi niri mem pharoba a'ero ubu pilamlange mem phalamsik,' aro lipsiog. ");
INSERT INTO kkl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lipsiog aghana, mog so'o sukupnange imag agha mag pelengkarelamsildi, so'oag wamlange mauroba li tarelamsildi, a'un kwaneng tenaba tarelamsildi, wana yeng wali nenelamsildi, El wamlange tognop tan koma walia aghabog ulamla,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wene aro ambatsirek aghana yubu ambatsirekne ingisaplobekti, “Sin phendeag mem phaphaukap,” aro ulamekpa, nen sap sarikto-sarikto “Karong,” alamdek. ");
INSERT INTO kkl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wamekpa, as Antiokhia nimiap as Ikonium nimiap Yahudi nimi wamekne as Listra yaekti, as eneko wamek nimi yubu yangaro wana tolamsiekti, limilamsiek. Limilamsiekpa, as enekoag wamek nimi sinag sip talamekti, Paulus kirikti obek. Obekti, “Ya'ag tebal,” aro kiliro asag poa lambaekti, paiag sip toltoghol piek. ");
INSERT INTO kkl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Toltoghol piek aghana elkabo Yesus yubu ka'ero ulamek nimi taneko longoro kanekto sekamekpa, Paulus pukogti, sekogti, nen as enekoag samoro wa'iog. Wa'iogti, mabogha kwelekaogne elkae Barnabasap nhon Derbe pirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","23","As Derbe pirekti, Paulusap Barnabasapti nimiag yubu walinge Yesus sembe ambarelamsirekpa, nimi maiknori sik uro seneraglamekti, Yesus yubu ka'ero ulamek nimi as Derbe wamekne maikno talamek. Maikno talamekpa, nen samoro as Listra inagha, as Ikonium phibom agha, Pisidia so'oag as Antiokhia palamdekag agha, Yesusag “Sikne” aro seneragtop nimi winil talamekag wa'alamdek. As a'ero-a'ero winil talamekag wa'alamdekag agha Paulusap Barnabasapti winil talamek nimi anabiag agha sikindoyabo wenehiropnang weplamsirekti, “Nimi taneko o'olamsululom,” aro sekililamsirek. Sekililamsirekti, kwaneng tero koma molona Yesusag mololamdekti, “Nuro Yesus, nu nimi ni saelbamsilam. Nimi wenehiropnang tanekori anag 'Sikne' aro seneraglamangba, andi arukna wamukangne, 'Wali sembamlulam,' aro ambatto mololangkeap” aro molbarek. Wenehiropnang weplamsirekne tanekoap Yesus yubu ka'ero ulamek nimiap wenelamsirekti, “Wene Yesusag 'Sikne' aro wanaag seneraglamlomne nene wali. Wana phende seneragseng kom,” aro nimi Yesus yubu ka'ero ulamek nimi wenelamsirek. Wenelamsirekti, “Maiknoro seklelameberi, wana nhonog uro wamebe tanena Allah Eldamneri wali uro paia saelbamsilul,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Undo unuarekti, palamdeka Pisidia so'o inagha mog so'o Pamfilia yarek. ");
INSERT INTO kkl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pamfilia yarekti, so'o eneko as Perga wamek nimiag Yesus yubu ambatsirekti, as Atalia mag laut longoropne abolag yarekti, ");
INSERT INTO kkl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","kabong nhonag wa'albarek. Wa'albarekpa, kabong pabiropnang tanekori ag kabongag kerekaekpa, “Phoanari ko'oro pabalamlul,” aro kerektop ag towalengkaekti, mag alip toman agha as Antiokhia Siria so'oag yarek. As Antiokhia nimiri, “Allah Wana Waliri piamsileba, Yesus yubu ambarelamsururom,” aro aneko samenag pogsiekpa, alnibarekti, ambatoba tongkahirek. Ambatoba tongkahirekti, Paulusap Barnabasapti, “Nunag 'Ambarel phururom,' aro pogsiongne neneko komopto uitnam,” aro nen sap alnibarekag aneko samoro yarek. ");
INSERT INTO kkl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Yarekti Yesusag “Sikne” aro seneragtop nimi poloro winiptaekpa, ambarelamsirekti, “Allahri yeplamsiori, uabongena Yahudi sisa komnang sembe babe Allahri ina kupsioba, sin babe Yesusag sik uro seneraglamang,” aro ambarelamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ambarelamsirekti wamdekpa, Yesus yubu ka'ero ulamek nimiap ma'aro wamekti, ik ko'o maiknoro wamek. ");
INSERT INTO kkl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","As Antiokhia Siria so'oag wamekpa, mog so'o Yudea nimi as Antiokhia piek. Piekti, sin Antiokhia nimi Yesusag “Sikne” aro seneragtop nimi taneko ambarelamsiekti, “Allahri samenag, 'Nengabo ni, “Allahap ma'ap taukap,” aro kon kareplamukang,' aro Allahri Musaag ambarogpa, yubu tipto mome toro pibog. Musari mome toro pibogpa, nu Yahudi nimiri salero ul palamapne sunsunum uro nengabo kon kareplamukang. Kon karebaik kom tanena Yesusti kon kareptop kom nimi taulbahilul kom,” aro ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wene aro ambatsiekpa, Paulusap Barnabasapti, “A'undi lelamlomne nene orolena lelamlom,” aro Yudea so'o agha yaek nimiap yubu maiknoro leldalamek. “Nelagha sikne,” aro yubu maiknoro leldalamekpa, Yesusag seneragtop nimi as Antiokhia winil dalamek nimiri Paulusap Barnabasap Yesusag “Sikne” aro seneragtop nimi etpareap wepsiek. Wepsiekti, “A'un as Yerusalem pululom. Pimundi ualulomne ane, a'unap, Yesusti samen wepto pogsiognangap, Yesusag seneragtop nimi as Yerusalem winil talamang nimi sikindoyabo wenehiropnangap haiptamundi, 'Nengabo kon kareptanep tam ene karebaukap,' aro as Yerusalem pululom,” aro pogsiek. ");
INSERT INTO kkl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wene aro pogsiekpa, Paulusap, Barnabasap, sikin kabo nhon palamek nang tanekoapti as Antiokhia agha lambaekti, Fenisia so'o inagha Samaria so'o inagha palamek. Sin palamek abeneko pere nimi so'o eneag wamekne wana heklamsirekti, “Yahudi sisa kom nimi Allah yubu ekon aghana Yesus sembe ka'elamangdi, Elag 'Sikne' aro seneraglamang,” aro uro yabiogne sembe ambare-ambare palamsiek. Ambare-ambare palamsiekpa, Yesusag “Sikne” aro seneragtop nimi ina palamekag wamekne ka'ebaekti, “Sin Yahudi sisa kom nimi Allah yubu ekon nang wali Yesusag seneraglamang,” aro awi yeng maikno senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","As Yerusalem piekpa, Yesusti samenag wepto pogsiognangap, Yesusag “Sikne” aro seneragtop nimi winil talamek nimiap, sikindoyabo wenehiropnangap, wamekne tanekori sin piekne enero poa wa'isiekti, kipsiek. Kipsiekpa, sindi ambarelamsirekti, “Allahri nu pere awe welamoboba, Yahudi sisa kom nimi Allah yubu ekon nimiri Yesusag 'Sikne' aro seneraglamang,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wene aro ambatsirekpa, Yesusag sikne aro seneragtop nimi taneko ka'ebaek. Ambatsireka ka'ebaek nimi anabiag wameknena, seneragna nhon uro seneragtop nimi kong nhon ma'aptangtop nimi Yahudi Farisi nimi alameknang wamek. Farisi nimi taneko agha nimi etpare sekekti, yubu lelamekti, “Yahudi sisa kom nimi Allah yubu wali ka'ebaek aghana, Yesusag seneraglamang tanena, sindi babe nengabo kon karebel talamukang. Kon karebel talamikpa, aruklamsibenge, 'Samenag Allahri “Ualulom,” aro ambarogne Musari yubu tipto mome tobogne ni sunsunum uro ul palamsut,' aro ambatsukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wene seekne sembe Yesusti samenag wepto pogsiognangap, wenehiropnang tanekoap winiptaekti, “Yahudi sisa kom nimiri nengabo kon karebel talamukang to, kom to? Musari Allah yubu tipto mome tobogne ni sunsunum uro ul palamukang to, kom to?” aro tam nene sembe yubu lelamek. ");
INSERT INTO kkl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yubu tam neneko sembe ko'o olog maiknoro sin mamun lero libekti, Petrus sekogti, ambarelamsiogti, “Nangkabo, Yesusag 'Sikne' aro seneragtop nimi wamap. Samenag wamububa, Allahri seneraghogti, 'Yahudi sisa kom nimiri yubu walinge Yesus sembe ka'ebaikti, Yesusag “Sikne” aro seneraglamukang,' aro Allahri a'un anabiag agha na wepneog. Wepneogpa, yubu walinge ane Yahudi sisa kom nimi tipto ambarelahisi. Samenag uro yabiogne ane sembe ni el wamlom. ");
INSERT INTO kkl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Allahri nimi wana kemelamsilne ponekori Eldamne Yame Walinge nu tatsiog. Nu Yahudi nimi agha Yesusag seneragtop nimi tatsiog saog uro sin Yahudi sisa kom nimi babe tarelamsiogti, 'Namabo taukang,' sembaogne kembatsiogpa, nu eltabu. ");
INSERT INTO kkl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Allahri 'Nimi tane Yahudi sisa nimi to, kom to?' semban koma, Yahudi sisa kom nimiri wanaag agha Yesusag “Sikne” aro seneraglameka Allahri kemelamsiog. Kemelamsiogti, sembenga sindi wanaag wamogne Allahri lupsiogpa, wanaag sik urop nimi taek. ");
INSERT INTO kkl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Allah Eldamneri undo unuaogne sembe a'un ni el wamlom aghana, sa'a sembe a'undi, 'Allahri uaogne wali to, kom to?' aro miplamlom? Tam ikinne sin Yahudi sisa kom nimi Yesus yubu ka'ero ulamang nimi taneag palilamsilom. Nunisa yabori babe nuri babe wali uro ulbinep kom bog, sa'a sembe sin sa'oag ikinne palilamsilom? ");
INSERT INTO kkl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Undo unuaheng kom. Nuri wanaag seneraglamapnena, 'Yesusti Nia Mangkina Saelbamsilne ponekori nu Yahudi sisa nimi wana waliri piamsildi, nu taulbahiog saog uro, sin Yahudi sisa kom nimi babe wana waliri piamsildi, talulamsil,' aro wanaag seneraglamap,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wene aro ambatsiogpa, winil talamek nimi taneko yubu koma wamek. Wamekti, ka'eamekpa, Barnabasap Paulusapti, “Samenag Yahudi sisa kom nimi yog asag nimiap nhon wamoboba, Allahri nu yeplamsioba, 'Allahri sin pere agha ual,' senenne kekneba nimiri uanep komne Allah Eldamneri uanepne, undo-undo uanomo,” aro ambatsirek. ");
INSERT INTO kkl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Abeneko komopto ambatsirekpa, Yakobusti sin winil talamek nimi anabiag sekogti, yubu lelamogti, “Nangkabo yubu lemnunne ka'eamlulom. ");
INSERT INTO kkl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Yahudi sisa kom nimi Allah yubu ekon nimi o'ona sembamsiogti, 'Namabo taukang,' aro samenag Allahri wepsiogne sembe wene abeneko Simondi ambatsil. ");
INSERT INTO kkl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Leplange nene samenag Allahri yubu silimu tiptopnang tanekori mome toro pibekne sunsunum uro ambatsil. Samenag Allahri yubu silimu tiptop nimiri mome toro pibekne pere agha, 'Allahrina, ");
INSERT INTO kkl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Na samoro yaneri, Daudti ae kalun ae kwerek taog ae eneko meneng ae ene agha ae soro ae walinge wendogne saog urop ae soro sekitnun. ");
INSERT INTO kkl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Sekitneba, 'Yahudi nimi pogto wamikneap, Yahudi sisa kom nimiapti Na Im So'o Ngainge wamnange elamniikti, Nari si lero seneraglamnikpa, Naringe taukang,' aro Daudti ae kalun ae kwerek taogne nen ae soro sekitnun,” aro Allahri ambatsiog,' aro mome toro pibog. Undo mome toro pibogpa, samenag agha 'Undo uro yabilul,' aro nimiri ka'ebaekti, el taek. ");
INSERT INTO kkl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Undo Allahri, 'Daudti ae kalun ae wendogne saog urop ae soro sekitnun,' aro ambatsiogne ane sembe, nari mo kareplamnange lemnuan. Yahudi sisa kom nimiri Allah yubu ka'elamekti, samenag Allahag seneraglamek kom aghana, wene Yesusag seneraglamang. Wene Yesusag seneraglamang nimi taneag tam ikinne pibukap kom sembamna. ");
INSERT INTO kkl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Tam ikinne Yahudi sisa kom nimiag pibukap kom aghana, samenag agha nimi as ni wamek nimiri Musari mome toro pibogne sembe ambarelamsiekpa, ka'elamek. Wene babe Allah yubu lerop sum talamlaba, Yahudi nimiri sop-sop Allah yubu lerop aeag wa'alamangdi, Musari mome toro pibogne lelamang. Ane sembe, Yahudi sisa kom nimi Yesusag 'Sikne' aro seneragtop nimiag ambatsukapnena ane: '”Lebe aroba eneng la'imbaleag,” aro homamanga lepto oroba sopap, enengap telamlulom kom. Eneng lambaleba, sop agha telamlulom. Ora nimiri, “Phia sembe phabaukap,” aro lebe aroba sop palilamikti, mektop sop babe yoro tarelamsiikpa, telamlulom kom. Apna, nengaboap kelaboapti, “Yog nimiri kelabo nengabo sembe naringe og wamso,” aro wanaag seneragmundi, saelbahiseng kom,' aro mome toro pibeberi, yubu ambatsukap,” aro Yakobusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yakobusti wene aro ambatsiogpa, Yesusti wepto pogsiognangap, Yesusag 'Sikne' aro seneragtop nimi as Yerusalem winil talamek nimiap, sikindoyabo wenehiropnangapti, “Yakobusti leplange wali,” sembaek. Wali sembaekti, “Paulusap Barnabasap nhon as Antiokhia piik nimi ebahukap,” aro yubu lebekti, Yudas si nhon Barsabasap, Silasap wepsiekti, pogsiek. Sin phende wepsiekne abeneko sembe Yesusag seneragtop nimi tanekori, “Nimi nubunge wamdang,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Sin phende abeneko poglamsiekti, mome toro sin saeag pibeknena ane: “Nun Yesusti wepto pogsiognangap, a'un kabo Yesusag seneragtop nimi Yerusalem wamapneap, sikindoyabo wenehiropnangapti, a'un kiplamsiap. Yahudi sisa kom nimi aghana Yesusag 'Sikne' aro seneraglamlomne as Antiokhia wamlomneap, mog so'o Siria wamlomneap, mog so'o Kilikia wamlomne sembe nuri a'un kiplamsiap. ");
INSERT INTO kkl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nun yubu ka'ebabongena, nu nungkabo anabiag agha samenag, nuri babe sin pogsin koma samenag a'unag yaongneri ambarelamsiongdi, a'un wana samsamolopsiongdi, tam ikinne pibong. ");
INSERT INTO kkl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ikinne pibongne ane sembe nuri ka'ebabori, nu ma'aro wamobori, yubu nikne lebobori, 'Nungkabo walinge Barnabasap Paulusap nhon pululom,' aro nimi phende ero wepsibori, poghol alamsiap. ");
INSERT INTO kkl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paulusap Barnabasap abeneri 'Allahri, “Saelbamsululam,” aro wepto poghol aogne poneko Yesus si nubu talul,' aro Yesus sembe ambarelamsirang. Ambarelamsirangne sembe ora nimiri, 'Ya'ag opsukap,' aro ulamsiong aghana, ta'ap sen koma Yesus sembe ambarelamsirang. ");
INSERT INTO kkl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Samenag nimiri a'un wana samsamolopsiongne ane sembe, nuri nimi phende 'Barnabasap Paulusap nhon palamukang,' aro wepto poglamsiap nimina, Yudasap Silasap a'unag yarikpa, mome ane palilamapne kembamunne sunsunum uro sindi pamag agha babe yubu nikne ambatsurukang. ");
INSERT INTO kkl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Ambatsurukangnena Allahri, 'Tam ikinne Yahudi sisa kom nimiag piplulom kom. Ot nimiri unuaukang kom senenne sembe ambatsululom,' aro Allahri Eldamne Yame Walingeri senelamlange nunag taoba, el tabori, yubu lelbang-bang mome ane palilamap. “Lebe aroba eneng la'imbaleag,” aro homamanga lepto oroba sopap, enengap telamlulom kom. Eneng lambaleba, sop ane telamlulom. Ora nimiri, 'Phia sembe phabaukap,' aro lebe aroba sop palilamikti, mektop sop babe yoro tarelamsiikpa, telamlulom kom. Apna, nengaboap kelaboapti, 'Yog nimiri kelabo nengabo sembe naringe og wamso,' aro wanaag seneragmundi, saelbahiseng kom. 'Teheng kom uaheng kom,' aro palilamapne nene saelba wapmunba, a'un wali wamlulom. Nangkabo ot abenda ambatsiap,” aro mome tobek. ");
INSERT INTO kkl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wene aro mome tobekti, “Wali pululom,” aro kipsiekpa, sin pogsiekne abeneko as Antiokhia piekti, Yesusag “Sikne” aro seneragtop nimi poloro wimbahiekti, mome aneko tatsiek. ");
INSERT INTO kkl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mome aneko tatsiekpa, kembaekti, “Wana aingnirop yubu nu sembe pipsiong,” aro as Antiokhia nimi taneko sin awi yeng sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasap Silasap abeneko Allahri yubu silimu tiptop nang wamdekti, Yesusag “Sikne” aro seneragtop nimi taneko yubu ambatto wana aingniro poa tongolamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sin phende abeneko Allah yubu ambarelamsiekti, as Antiokhia sae a'iliro wamekpa, as Antiokhia Yesusag “Sikne” aro seneragtop nimi tanekori wana wali uro lelamekti, “A'unkabo poghol ahiong nangag nen samoro pimundi, nuri sin sembe 'Nungkabo,' aro kiplamsiapne ambatsululom,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","“Pululom,” seek aghana, Silas nenekori, “Na a'unap wamukap,” seogti, ta'ap seog. ");
INSERT INTO kkl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ta'ap seogpa, Paulusap Barnabasap abeneko babe as Antiokhia olog maiknoro wamdeka sinap nimi maikno orangeapti, yubu walinge Nia Mangkina Salehiropne Yesus sembe tibin nenero ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ambatto wameka Paulusti, Barnabasag yubu lelamogti, “Nuri samenag Nia Mangkina Salehiropne Yesus yubu ambarelamsinumu asag nungkabo Yesusag 'Sikne' aro seneragtop nimi 'Wali wamang to, kom to?' aro kemeroa yabuhununam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Wene seogpa, Barnabasti, “Nun kae Yohanes, si nhon Markus babe nhon pukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","“Nhon pukap,” seogpa, Paulusti, “Yohanes Markus nimi enena samenag nunap nhon pibo aghana, as Pamfilia wamoboba, elna awe lilobi agha nu laplobi agha samoro yao. Ane sembe, nen elap nhon pukap kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wene seogpa, Paulusap Barnabasap su'ahel yo uro leptekti, a'eptarekti, Barnabas nenekori Markus enero agha kabong mag alip toman inagha mog so'o Siprus pirek. ");
INSERT INTO kkl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus nenekori babe Silas enero agha “Pununam,” seogpa, elkabo Yesusag “Sikne” aro seneragtop nimi tanekori Nia Mangkina Saelbamsilne ponekoag mololamekti, “Wana wali uro piamsululam,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wene aro molbaekpa, Paulusap Silasap lambarekti, mog so'o Siria inagha mog so'o Kilikia palamdekti, Yesusag “Sikne” aro seneragtop nimi winil talamek nimi mikip nenero poa palamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus palamogha as Derbea nen as Listra piog. Ae Listra anekoa palamogpa, nimi nhon Yesus yubu ka'ero ulamog nimi nhon si Timotius wamog. Timotius ilinna Yahudi kel, Yesusag seneraglamog kel wamogpa, Timotius ili ponekona Yunaninge wamog. ");
INSERT INTO kkl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yesusag “Sikne” aro seneragtop nimi as Listra wamek nimiap as Ikonium wamek nimiapti, “Timotius wana wali” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Wene alameka Paulusti ka'ebaogti, “Timotius enero poa nhon pukap,” sembaog aghana, Yahudi nimi as enekoag wamek nimi tanekori, “Timotius neneko ili Yahudi sisa nimi komdi, Yunaninge wamla,” aro ni el wamek. Timotius ili Yunaninge wamogne sembe, Paulusti, “Timotius kon karebaikpa, nhon pukap,” seogpa, Timotius kon karebaek. ");
INSERT INTO kkl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paulus elkaboap as taneko ni kanero palamekti, Yerusalema Yesusti wepto pogsiognangap Yerusalem wamek nimi Yesusag seneragtop nimi wenehiropnangapti yubu tam karepto pibekne as taneko ambatto poa tongolamsiekti, “Undo ul palamlulom,” aro ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ambatto poa tongolamsiekpa, Yesusag seneragtop nimi winil talamek nimi ka'elamekti, mikip uro Yesusag “Sikne” aro seneraglamekti, nimi maikno talamek. ");
INSERT INTO kkl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulusap elkaboap palamekpa, Allah Eldamne Yame Walinge nenekori, “Asia so'oag wamang nimiag Yesus yubu ambatsiseng kom,” aro pat pibogpa, ina palamekne mog so'o Frigia Galatia so'oag piek. ");
INSERT INTO kkl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","8","Mog so'o Misia simbik palameka, “Mog so'o Bitinia pukap,” aro ulamek aghana, Yesus Eldamne Yame Walinge nenekori, “Bitinia peheng kom,” aro irikahiogpa, Misia so'o phiro as Troas piek. ");
INSERT INTO kkl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Troas piekti, Paulus ae inipnag malamogti, haing uamna kwelekamna senenag agha lenda malamog abeneko pere nimi mog so'o Makedonia nimi nhon sekamogha tibog aog. Tibog aogpa, Makedoniange ponekori, “Mag alip toman kauro yamendi, nu Makedonia nimi yepsululam,” aro mololamogpa, lenda mabog. ");
INSERT INTO kkl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulusti lenda undo mabogne sembe nu ambatsiogpa, tam kareplamuburi, “'Makedonia nimiag pimundi, yubu walinge Yesus sembe ambarel phululom,' aro Allahri ambatto nu yoplamsil,” sembabu. “Allahri nun yoplamsil,” aro seneraglamuburi, “Elem-elem mog so'o Makedonia pukap,” aro togna toglamubu. ");
INSERT INTO kkl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","12","Togna togto aburi, Troas laplobi agha kabong lomag agha palamubunge peket aro as sina Samotrake pina mabubu. Mabubua kwelekaogpa, Neapolis inagha as Filipi pibu. As Filipi as nubunge neneko Makedonia so'oag agha Roma nimiri samenag nimi taneko luknubahiekti, Roma nimiri ul palamekne sunsunum uro saelbamsiek. As Filipi anekoa sae a'iliro wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","14","As Filipi wamuburi, Yahudi nimiri Allahag yubu lerop sum taogpa, “Yahudi nimiri mag abolag winil dalamangdi, Allahag molona mololamang, to,” aro el pukap sembabu. El pukap sembaburi, as Filipi leka kanero solingkirobag ina siram lambaburi, mag abolag palamububa, kelabo longoro wamekag piburi, pukubu. Pukamububa, kel nhon si Lidia as Tiatira kel wamog. Wamog kel enekori ag walinge nimi nubunge tupne sembe wirop ag uwong-uwonga likto ulamogti, kel eneko Yahudi kel kom aghana Allah omektop kel wamog. Elap kelabo tanekoap yubu saro wamubu. Yubu saro wamububa, Lidia kelenekori babe yubu ambatsibunge ka'eamsiog. Paulusti Yesus sembe yubu ambarelamsiog abeneko Nuni Allahri keleneko wana heklamogpa, Yesusag “Sikne,” aro seneraghogti, yubu ene saelbamog. ");
INSERT INTO kkl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","“Yubu ene sik,” sembaogti, saelbamogpa, kelenekoap eldi aeag wamek nimiap ni maghag pelengkahibu. Maghag pelengkahibuba, Lydia kelenekori nunag ambarelamsiogti, “Nia Mangkina Salehiropne Yesusag 'Sikne' aro seneraglamna. A'undi na sembe, 'Kel eneri sik uro Yesusag seneraglamla,' sembamun, tanena nanap nhon wamukap,” aro yubu mikip uro enero eldi aeag tobongkipsiog. ");
INSERT INTO kkl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","17","As Filipi wamubuag agha kel nhon el kulomag phia wamog kel wamog. Kel enekona, amik uro yabinepne ililamog kel, ili yabo arukna saog uro wamog. Wamogpa, nimiri kel enekoag yalamekpa, kel enekori, “Anag undo uro yabilul,” aro ambarelamsiogpa, el talamekti, kamna ili yabo tarelamsiekpa, ili yabo tup talamek. Ik nhon sum, “Yahudi nimiri mag abolag Allahag molona molorobag pukap,” aro palamububa, keleneko haiptaburi, nu Paulusap amik sare nelepto yalamogti, haum aro lelamogti, “Nimi tane Allah Mikip Phelektopne arukna wamang ane sembe, sindi yubu ambarelamsiangne ka'elapmunba, Allahri a'un taulbahilul,” aro yubu leple yalamog. ");
INSERT INTO kkl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Undo yubu wene alamogha ane, nu pang-yang ulamububa, yubu wene alamog aneko sae a'ilin talamog. Ik nhon sum, yubu wene alamogha aneko sembe Paulusti wanaag yo uaogpa, samoro keleneko kembaogti, phia keleneko kulomag wamogha anekoag yubu lelamogti, “Allahri 'Saelbamsululam,' aro wepto poghol aogne Yesusti el mikipne nunag pipsiogpa, lemnuan. Phia kelene kulomag wamlama ane lambae!” seog. Wene seogpa, phia keleneko kulomag wamogha aneko lambaog. ");
INSERT INTO kkl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Phia aneko kelenekoag wamogne neneko lambaogpa, ili yabo tanekori, “Phia aneko el kulomag ulamlari, 'Undo-undo uro yabilul,' alamlaba, kal ma'al maikno tarelamsiang aneko wene nen saelbaukap kom,” aro Paulusap Silasap sae salero, tam lelekto kemero kareptobag saelba uahirop nangag poa phiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Keleneko ili yabori tam lelekto kemero kareptobag poa phiekti, saelba uahirop nangag lolorop yubu ambarelamsiekti, “Sin Yahudi nimi taneri ambarelamsirangne nene, 'Ulamlulom,' alamdang aghana, nu mog so'o Roma nimi wamapti, ambarelamsirangne sunsunum uro uanep kom wamap. Nu as Filipi nimi Roma nimi umag wamapne wana mali nenelamsirangba, nimi taneri yanghang alamsiang,” aro lolorop yubu ambatsiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wene aro ambatsiekpa, nimi maikno tanekori Paulusap Silasap sembe “Karong” alamsiekpa, nimi nubunang tanekori sikinipsabo saeag nembahiekti, “Sikininge ag enekto amtangne taepto epsimundi, nimi abene kameri opsululom,” aro ambatsiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wene aro ambatsiekpa, kameri maiknoro taeplam-taeplam lopsiekti, kop aeag tolongkahiekti, kop ae yae uropne ponekoag, “Lambarikagtina, wali uro yae wamsululam,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wene aro ambarekpa, kop ae yae ua uropne ponekori sin phende abeneko ae kolo lom nusamagneag nembahiogti, sindi yan kalag a'aruro kauplopsiog. ");
INSERT INTO kkl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yan kalag a'aruro kauplopsiogpa, wamekpa, ae inipna tomnusam taogpa, Paulusap Silasap abenekori Allahag molona mololamdek. Allahag molona mololamdekti, Allah omektop sepna seplamdekne nimi yogne kop aeag aneko wamekneri babe ka'eamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Allah omektop sepna seplamdekpa, ka'ebaekti, wamekpa, ae sa'uma nubunge nhon ulamog. Ae sa'uma ulamogti, ae eneko solamekti, yangkaek kirik maptopne pot-porolamog. Yangan kirik maptopne pot-porolamogpa, ina siram kuptangto palamogpa, kop aeag tobongkamsiek nimi yan sae haing kaubamsiekne loptangto palamog. ");
INSERT INTO kkl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ae sa'uma aneko ulamog abeneko kop ae yae ua uropne poneko malamogha pukog. Pukogti, kemelamogpa, ina serekna serekahiogne taneko ni kupto wamogha kembaogti, “Nimi ni tobongkahiongne lambang,” aro log sembaog. Log sembaogti, karog kilbaogti, “Ya'ag optanun,” aro ulamog. ");
INSERT INTO kkl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","“Optanun,” aro ulamogpa, Paulusti, yubu nubu uro lelamogti, “Optaheng kom. Nuna ni ae lomag ane wamap,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Undo wene seogpa, kop ae yae ua uropne ponekori, “Whea tarelanuhu,” aro ilipsabo arukahiogti, ae lom enekoag wa'iogti, pet-pet aro Paulusap Silasap sin whingag yabu sanukto pulingkiog. ");
INSERT INTO kkl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yabu sanukto sin whingag pulingkiogti, sekom agha Paulusap Silasap enero poa asag lambahiogti, hailamsiogti, “Nani yabo, malia ulamnange sembe, 'Allahri lunuro opneleag,' aro na huaneba taulbanelul?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Na huaneba, taulbanelul,” aro haibahiogpa, sindi samoro elag lelamdekti, “Nia mangkina Salehiropne Yesus ponekoag 'Sikne' aro seneraglapmunba, anap ankabo andi aeag wamangneap taulbahilul,” aro ambatek. ");
INSERT INTO kkl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wene aro ambatekti, elap ilipsabo eldi aeag wamekneap Nia Mangkina Salehiropne Yesus sembe yubu ambarelamsirek. ");
INSERT INTO kkl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ambarelamsirekpa, kop ae yae wamogne ponekori inipnag abeneko sin phende opsiek ina taneko mag a'elbahiog. Mag a'elbahiogpa, eldi kelabo me wamekneap eldi aeag wamekneapti Yesusag seneraglamekne sembe maghag pelengkipsirek. ");
INSERT INTO kkl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Maghag pelengkipsirekpa, Paulusap Silasap abeneko enero poa kop ae yae wamogne ponekori aeag poa phiogti, kwaneng yobatsiog. Yobatsiogpa, teekti, wamekti, elap ilipsabo aeag wamekneapti, “Allah yubu ambatsirangba, sik senelamapti, salelamap,” aro awi yeng senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kweleknag aneko as Filipi aneko nimi saelba uahiropnangdi sikinipsabo poglamsiekti, “Kop aeag nimi yae ua uropne ponekoag pimundi, ambarelapmundi, 'Nimi phende nang abeneko sae lopsululam,' aro ambatlulom,” aro pogsiek. ");
INSERT INTO kkl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pogsiekpa piekti, ambarekpa, kop ae yae wamogne ponekori nen sap tipto Paulus ambarelamogti, “Nangkabo, nimi saelba uahirop nimi tanekori nanag, 'Sae lopsimenba, yubu lepseng koma lambarukang,' seangba, wali lambarurom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wene aro ambatsiogpa, Paulus nenekori saelba uahirop nang sikinipsabo yaek nimi tanekoag, “Nu babe Roma nimi wamnam aghana, tam oroghag agha sa'a sembe tam lelekto kemero kareptop nimiri nunag haibahin koma nimi maikno haingag agha opsiongdi, kop aeag tolongkipsiong? Opsiongdi, tolongkipsiong aghana, wene sa'a sembe tognoro saog uro 'Pururom,' seang? Nu tognoro saog uro lambanunam kom. Sindam nimi yaikti, nu enero poa lambitsukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paulusti, wene aro ambatsiogne sindi yubu poro agha sikini yaboag piekti, yubu tipto ambatsiek. Ambatsiekpa, ka'ebaekti, as taneko nimi saelba uahiropnangdi, “Paulusap Silasap, sin babe Roma nimi wamdang, aghana tam lelekto kemban koma sin opsibo,” aro el taekti, log sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Log sembaekti, as Filipi saelba uahirop nimi nubu nang taneko Paulusap Silasap sin wamdekag piekti, “Wana aingniro lambarukang,” aro yubu wali uro lelamekti, ae kop aeag anekoa enero poa lambahiekti, “Nangkabo, as eneag laplobi agha lambarurom,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Wene aro ambatsiekpa, sin phende kop aeag agha lambarekti, kel Lidia kelenekori aeag pirek. Pirekti, sikin kabo Yesusag “Sikne” aro seneragtop nimi wana aingnibahirekti, Paulus elkabo abenekoap as Filipi aneko laplobi agha palamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","As Filipi laplobi agha Paulusap elkaboap as Amfipolis inagha as Apolonia inagha palamekti, as Tesalonika piek. As enekoag Yahudi nimiri Allahag yubu lerop ae nhon wamog. ");
INSERT INTO kkl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Allah yubu lerop sum taogpa, Paulus nenekori ora asag ulamog saog uro as Tesalonika anekoa babe Yahudi nimiri Allah yubu lerop ae enekoag wa'alamog. Wa'alamogti, Allah yubu lerop sum ik wilindi tibin nenero ambarelamsiogti, “Allah yubu samenag toro pirop mome kembi agha Allahri, 'Mog so'oag nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne poneko sembe nu el taap. Samenag mome toro pibek nimiri saeag agha undo uro yabilulne sembe Allahri ambarelamsiogne, 'Na Allahri wepto poghol anunne poneko mog so'oag yaleba, nimiri ya'ag obikpa, seklero tebaleri, nimi ya'ag teptopne nusamag agha kamag talul,' aro Allahri ambatsiog. Allahri, 'Mog so'oag nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne Yesus ponekoag uro yabiogne sembe ambarelamsin,” aro Paulusti ambatto wana heklamsiogpa, sindi “El tahabe,” aro hailamekne eldi tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Paulusti wene aro ambarelamsiogpa, Yahudi nimi etbareri “Paulusti ambarelamsilne sik,” senelamekti, Paulusap Silasap sae tiptangto ma'altalamek. Ma'altalamek nimi ane Yunani nimi Allah omektop nimi maikno babe, kelabo as Tesalonika kelabo sikinin yabo saog uro wamek kelabo maikno babe sindi, “Sik” senelamekti, Paulus elkaboap ma'altalamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Sin ma'altalameka kembi agha, Yahudi nimiri, “Nimi maiknori sin phende maiplamsiang,” aro wana yo senelamsiek. Wana yo senelamsiekti, Yahudi nimi tanekori ulamekti, malia ulamek nimi awe weroan koma ambengka uro urop nimi etbare sae kiliro topsiekti, “Put-put ana ulamukang,” aro Yahudi nimiri “Unulamlulom,” aro arukahiek. Wene aro arukahiekpa, put-put alameknang anekori as aneko nimi wana bobo nenelamsiek. Wana bobo nenelamsiekpa, as taneko nimiri “Yanghang alamsiberi, yag lambahukap” aro poloro winiptaek. Poloro winiptaekpa, Yahudi nimiap put-put arop nimiap tanekori, “Paulusap Silasap ero saelbahiberi, poloro winiptaang nimi saeag nembahukap,” aro sikinkae Yasondi ae kwerekto wa'iek. ");
INSERT INTO kkl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kwerekto wa'iekti kemelamsiekpa, Paulusap Silasap orog wamdekpa, sikinkae Yasonap Yesusag “Sikne” aro seneragtop nimi etbareap saelbahiekti, kiliro so'oag lelepto poa palamsiekti, nimi nubu nang as eneko saelbamsiek nang saeag tarel phiek. Yubu haum aro poa palamsiekti, “Mog so'o as tala-tala tam palilamdangba, yubu talamla nimi taneko wene nuri asag yingkilamdang,” alamekti kiliro pabalamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","“Yasondi Silasap Paulusap kiliro nuri asag palilamsil. Roma nimi sembe yubu sia leropne nubunge Kaisardi yubu tam karepto pibog aghana, yarek nimi anekoap, sikinkabo tanekoapti philamang. Roma nimiri mog so'o wamap ane sembe, yubu sia leropne nhonog Kaisar wamla aghana, sindi ambarelamsirangne, 'Yubu sia leropne nubunge nhon Yesus wamla,' aro ambarelamsirang,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wene alamekpa, nimi maikno tanekoap nimi nubu nang tanekoapti ka'ebaekti, wana samsamolopsiogpa wamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Wana samsamolopsiogpa, wamekti, nimi nubu nang tanekori Yasonap Yesusag seneraglamek nimi tanekoabag lelamekti, “Kal ma'al nunag tatsumundi, aghabogna pululom. A'unkabori Yesus poneko yubu ambarelamsirangne ane sembe, 'Nunkabori nen yubu ane ambatsin koma nuri asag agha lambarukang,' aro salag pipmundi, kal ma'al tatsululom,” aro nimi nubu nang tanekori wene seekpa, kal ma'al tatsiek. Tatsiekpa, tobekti, “A'unungeag pululom,” seekpa, lambaek. ");
INSERT INTO kkl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lambaek sumeneko inipnag Yesusag “Sikne” aro seneragtopnang tanekori “Nangkabo, pururom,” seekpa Paulusap Silasap as Berea pirek. Aneko pirekti Yahudi nimiri Allah yubu lerop aeag aneko wa'irek. ");
INSERT INTO kkl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yahudi nimi agha as Tesalonika wamek nimi taneko wana yo nimi wamek aghana, Yahudi nimi agha as Berea wamek nimi wana aingnirop nimi wamekti, wanaag sol wali, wali uro Allah yubu ka'elamek. Ka'elamekti, “Paulusti Allah yubu ambarelamsilne nene sik to, kom to,” aro seneraglamekti, Allah yubu samenag toro pirop mome sop-sop lelekto kemelamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Berea nimiri, “Sik to, kom to?” aro Allah yubu lelekto kemelamekti, Yahudi nimi agha as Berea wamek nimi maiknori Yesusag “Sikne” aro seneraglamekpa, Yunani nimi sikinin yabo saog uro wamek nimi taneko babe, Yunani nimi kelaboap nengaboap sin maiknori Yesusag “Sikne” aro seneraglamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","As Berea nimi maiknori Yesusag seneraglamek aghana, “Paulusti as Berea nimi Allah yubu ambarelamsil,” ana Yahudi nimi agha Tesalonika wamek nimi tanekori ka'ebaekti, “Paulusti yubu ka'ebaukang kom,” aro as Berea aneko piek. Piekti, put-put aro wana aluktop yubu ambarelamsiekpa, ka'elamekti nimi maikno sikin sip tangto “Paulusti ambarelamsilne karong,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wene alamekne sembe ta'ap sen koma Paulus elkabo Yesusag “Sikne” aro seneragtop nimi tanekori mag longorop mag laut abolag sip poghol piekpa, Silasap Timotiusap agha as Berea aneko wamdek. ");
INSERT INTO kkl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paulus neneko elkabori enero poa as Atena pil piekti, yalamekpa Paulus nenekori, “Silasap Timotiusap menag-menag na amik yarukang,” aro yubu pibog. ");
INSERT INTO kkl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","As Atena aneko piogti, Silasap Timotiusap sembe nang-nangaro tibogto wamsiogti, as enekoag nimi saeri sunurop mema phalamekne maikno wamogha kembaogti, Paulus wana ikin sembaog. ");
INSERT INTO kkl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Wana ikin taogne sembe, Yesus sembe ambarelamsiogti, eldi yubu ka'elamek nimiap sop-sop haibildalamekti, “El tahabe,” aro hailamekne tibin nenero ambarelamsiog. Yahudi nimiri Allah yubu lerop aeag wa'alamekti, Yahudi nimiap Yahudi sisa kom nimi Allah omektop nimi tanekoap Yesus sembe ambarelamsiog. As Atena nimiri nia mangkina pail wa'ina tolamekag babe Paulusti sop-sop palamogti, nimi pangyang ulamek nimi taneko wamekne babe ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nimi etbare mome ambatsirop nang Epikurosti seneragtopne saelbamek nangap, Stoari seneragtopne saelbameknangap, Paulusap alniro yubu saro haibil talamek. Haibil talamekti, Paulusti yubu walinge Yesus sembe ambarelamsiogti, “Nimi teptopne kamag tanep,” aro wene seogne sembe, nimi taneko etbareri, “Nimi ene el wamlare? Eldi seneragna olog aghana yubu pam andari lelamla,” alamekpa, nen nimiri, “Nimi eneri mema ora mog so'oag nimiri phalamangne nu ekonne ambarelamsil, te?” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wene alamekti, Paulus neneko tam kareptobag Areopagus yimag poa piekti, “Andi yubu tam wendogne lelamlamne nene nu babe ka'ebaukapti, nen ma'aro ambatsi,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“Andi lelamlamne nuri aoag olog ka'elamabag agha lelamlamne nene sembe, 'Sa'a agha lelamla,' senelamap. Ane sembe, lag phoro ambatsisom?” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(As Atena wamek nimiap nimi ora asag agha sekelingkirop nimi tanekoap oraba uan koma yubu tam wendogne sembe ngagto ka'elamekti, wamek.) ");
INSERT INTO kkl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wamekti, “Ambatsisom,” alamekpa, Paulus neneko Areopagus yimag aneko poloro winil talamek nimi whingag sekogti, yubu lelamogti, “Atena nimi nangkabo, a'undi mema phalamlomne sol wali uro ulamlomne kemelamsin. ");
INSERT INTO kkl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A'undi mema phalamloma tane sembe ina yabalamnori, mema pharobag nhon kemelamno. Kemelamnoba, mome toro piplumne lilimna ane: “Mema nimiri ekon uropne sembe,” aro mome toplumdi, mema pharobag ane piplum. A'undi mema ekon urop mema phalamlomne poneko sembe wene nari a'unag ambatsinun. ");
INSERT INTO kkl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Allahri nia mangkina so'oag wamlange sumbaogti, im so'o saelbamsil. Im So'o Saelbamsilne poneko nimi saeri mem ae soropneag ua urop kom. ");
INSERT INTO kkl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Imap so'oap sumbaogne ponekori nimi ni kamag nenelamsildi, hain tarelamsildi, ni nuri saeag wamlangena tarelamsilba, nu nimi mog so'oag nimiri, 'Imap so'oap sumbaogne poneko el teko wamla,' sembanep kom. Nuri saeag agha el yepnep kom. ");
INSERT INTO kkl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yum-yum samenag nimi nhon sumbaogneag agha nimi maikno likto palamogpa, nimi mog so'oag nimi likto piek. Nimi likto piekne taneko 'Nimi tala-tala wamikti, mog so'o to'op taukang,' aro Allahri nimi sumbahiog. Sumbahiogti, kareplamogti, 'Nimi mog so'o a'ero-a'ero wamukangne, tane nhon, tane nhon wamukang,' aro karebaogti, pipsiog. Apna, 'Nimi ane ko'o eneag wamlul, nen nimi li ko'o nhon likto pilul,' aro karepto pibog. ");
INSERT INTO kkl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","28","Allahri karepto pibognena, 'Nimi Na whing ebaneikti, mololamniikti, “Yepsi,” aro Nanag ebanukang to kom to,' aro Allahri undo unuaog. A'uni yabo nimi nubu nangdi sepna siplamekti, 'Nu mog so'oag nimi Eldi mangaro likto pipsiogne wamap. Ot Eldi saeag agha hain eplamapti, senelamapti, lebe alamap,' aro siplamek. Nu mog so'oag wamapne el wamlange weag wamla kom ane sembe, sae nginikto ulamebeba, el nunag lag talul. ");
INSERT INTO kkl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nu mog so'oag nimi Allahri mangaro likto pipsiogne wamap ane sembe, nimiri 'El imag uropne hain tarelamsilne poneko sunumna sumbaukap,' sembaheng kom. Leng-leng arobaap, kororopneap, wali kirikap tobiagha nimi saeri walia sunuroba taneko El imag uropne hain tarelamsilne poneko sunumna sumbanep kom. ");
INSERT INTO kkl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nu mog so'oag nimi limituk uro wamuburi, 'Hain tarelamsiogne poneko sunumna sumbaukap,' aro lebe arop komne agha sunulamubu. Sunulamubunge neneko sembe samenag Allahri, 'Sin ekondi, ulamangba, unulamik,' sembaogti, lipsiog aghana, wene Eldi nimi ni tala-tala wamang nimiag lelamlangena, 'Samenag malia ulamlumne lipsimundi, Nanag yalulom,' aro aruklamsil. ");
INSERT INTO kkl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Allahri yubu pibogne, '”Sumeneko uanun,” sembamsinge sunsunum uro, nimi nhon wepto sekitsinge sae pere agha nimi ni mog so'oag uropne tam ua uropne porog uro tam karebanun,' aro yubu pibog. Wene aro yubu pibogne sembe 'Samenag malia ulamlomne lipsimundi, Nanag yalulom,' aro aruklamsil. 'Nimi nhon wepto sekitsinge,' seognena, 'Nimi ni, “Allahri Yesus ane wepto sekirog,” aro el taukang' senenag agha Allahri nimi teptopne nusamag agha Yesus poneko kamag nembaog,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","“Nimi teptopne nen kamag tanep,” aro Paulusti ambatsiogpa, ka'ebaek nimi taneko pogtaek. Nimi nenne tanekori Paulusag og sobaek aghana, nen nimiri, “Nangkae, wene selamne nene sembe nen lepmenba, nu ka'ebaukap,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wene seekpa, Paulus yubu tam kareptop nimi winiltalamekag aneko laploa lambaog. ");
INSERT INTO kkl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wene alamekag agha ka'ebaek nimi etpare Paulusag sip talamekti, wene aro ambatsiogne sembe Yesusag “Sikne” aro seneraglamek. Sin Yesusag “Sikne” aro seneraglamek nimina, Areopagus yimag tam kareptopne nhon sina Dionisiusap, kelabo nhon Damarisap, nimi etbareap sin sik senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulusap Atena olog wamekpa, Paulus neneko as Atena laplobiagha as Korintus piog. ");
INSERT INTO kkl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Korintus piogti, Yahudinge nhon si Akwila haiptarek. Akwila poneko mog so'o Pontusne wamogti, as Roma sekilingkiog. Aghana Roma nimi salehiropne sina Klaudius yubu sia leropne nubunge ponekori, “Yahudi nimi as Roma tane wamseng kom,” aro as Roma agha yag lambahiog. As Roma agha yag lambahiogpa, Akwila elkel Priskilaap as Roma negara mog so'o Italia laplobi agha as Korintus yarekti, Paulusap haiptaek. ");
INSERT INTO kkl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulus neneko sin wamdekag piogpa, sin elkel ela'ange abeneko babe, “Nu awe nikne, pham kon mektopne agha kalun ae sona ag wetnero sorop nimi wamap,” aro sin phenderi aeag nhon wamekti, awe nhon tolamek. ");
INSERT INTO kkl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Wamekti, awe nhon tolamekti, Yahudi nimiri Allah yubu lerop sum yalamog tanena Paulus nenekori sop-sop Allah yubu lerop aeag wa'alamogti ambarelamsiog. Ambarelamsiogti, Yahudi nimiap Yunani nimiap “Yesusag seneraglamlulom,” aro ambatto wana heklamsiogpa, sindi “El tahabe,” aro hailamekne eldi tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Allah yubu lerop sum yalamog sumeneko Paulusti Yesus sembe ambarelamsiogti, wamogpa, Silasap Timotiusap mog so'o Makedonia agha yarek. Makedonia agha Silasap Timotiusap Paulus wamoghag yarekpa, Paulus ponekori ag wetnero tolamogne libogti, “Allah yubu nimi ambatsinunne aghabog uanun,” aro sol wali, wali uro ambarelamsiog. Sop-sop Yahudi nimi ambarelamsiogti, “Allahri 'Mog so'oag nimi taulbahimendi, saelbamsululam,' aro wepto poghol aogne Yesus nunag lag taog,” aro ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Paulusti ambarelamsiog aghana Yahudi nimi tanekori, “Yesus sembe ambarelamsilne nimiri ka'ebaheng kom,” aro ulamekti, Paulusap Yesusap san tiliplamsiek. San tiliplamsiekpa, Paulusti ag enektopne leng-lenga wamogne po'oro pelengkaogti, sinag yubu lelamogti, “Allahri opsileba, a'ununge eneng a'ununge usoghag timbale! Allahri awe nari saeag nembaneogne tolamnari, Yesus sembe a'unag samen yubu ambarelamsin ane sembe nanag tam pimnep kom. Wene anea lambaneri, Yahudi sisa kom nimi mog so'o yog nimiag ambarel phinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wene seogti, Yahudi nimiri Allah yubu lerop ae anekoa lambaogti, ae anekoap tipto sorobag ae wamogne palamog. Ae ngainge si Titius Yustus wamogne poneko nimi sisa Yahudinge kom aghana Allah omeklamogne wamog. Paulusti Allah yubu lerop aeap tipto sorobag ae aneko alniro wa'alamogti, Yesus sembe nimi ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ambarelamsiogne ka'elamekag agha Allah yubu lerop ae saleropne poneko si Krispus wamogneap, eldi ae lom nimiap Yesusag “Nia Mangkina Saelbamsil,” aro seneraglamek. Paulusti ambarelamsiogne sik senelamekti, wamekpa, Korintus nimi Yahudi sisa kom nimi maikno Paulusti Yesus sembe ambarelamsiogne ka'elamekti, sik senelamek. Yesusag “Sikne” aro seneraglamek nimi maghag pelengkahiek. ");
INSERT INTO kkl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ik nhon sum inipnag malamogpa, Paulus lenda saog uro haing uamna kwelekamna senenag agha Nia Mangkina Salehiropne ponekori elag yubu lelamogti, “Log kom uro ambarelamsululam! Yubu kom taheng kom! ");
INSERT INTO kkl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nari an piangken. Nimi naringe as eneag nimi maikno wamang ane sembe, tane wapmenne nimi nhondi babe yo uro saelbaghukang kom. Ona babe opkukang kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Wene seogpa, Paulus neneko as Korintus wamogti, Allah yubu ambarelamsiogpa, heng kun nhon wal no'op bare taog. ");
INSERT INTO kkl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Heng kun nhon wal no'op bare taog aghana, nimi nubunge si Galio, “Mog so'o Akhaya saelbamlul,” aro towalengkaek li sin Yahudi nimi taneko ma'aptaekti, “Paulusag tam ikinne pibukap,” aro yubu tam lelekto kemero kareptop nangag poa piek. ");
INSERT INTO kkl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Poa piekti, lelamekti, “Nimi eneri ekel ina Allah yubu ambarelamsildi, 'Undo-undo Allah omeklamlulom,' aro ambarelamsil aghana, nu Yahudi nimi nunisag Musari toro pibog momeap sunsunum kom uro ambarelamsil,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Wene alamekpa, Paulus yubu lemnun agha ulamoghag agha, Galio ponekori Yahudi nimiag yubu lelamogti, “A'un Yahudi nimi nangkabo. Tam payalomnena, nun saelbamsiang nangdi samenag yubu sia pibekne phibao aro lemnepne wamsoba, ologne to, nubunge to payahom tanena, 'Wali payaangba,' aro karebahane. ");
INSERT INTO kkl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","16","Aghana tam payalomne nene yubu kiki sembe, nimi si sembe, samenag a'unisag yabori mome tobekne saelba ulamlomne sembe yubu leplomdi, payalomba tam nene nari karebanep komdi, a'un mo karebalulom,” aro Yahudi nimi taneko yubu tam kareptop aeag agha yag lambahiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yag lambahiogpa, nimi tanekori Yahudi nimi nhon sina Sostenes saelbaekti, yubu tam kareptop ae ina siramag agha olamek. Sostenes poneko Yahudi nimiri Allah yubu lerop ae saelba uropne wamog aghana Sostenes olameka ipsiogti, Galio ponekori yubu olog lebog kom. ");
INSERT INTO kkl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus ik maiknoro Korintus wamogha Yesusag “Sikne” aro seneragtop nimi tanekoag, “Mog so'o Siria simbik pinun,” seogti, mag alip toman agha palamog. “Mag alip toman punun,” aro as Kengkrea piogti, Yahudi nimiri ulamekne sunsunum uro “'Allah arukna sol wali walinge wamnun' aro keknep uro yabalamne abeneko hong kareptop koma wamnea, wal nenekoag hong karebanukang,” aro salag pibogne sunsunum uro hong karebaek. Hong karebaekpa, palamoghag agha Priskilaap Akwilaap nhon palamekti, ");
INSERT INTO kkl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","as Efesus piek. Piekti Priskilaap ela'ange Akwilaap abenekori, “Nu tane wamnunam,” serekpa, Paulus nenekori, “Nen tipto palamnun,” seog. “Palamnun,” seog aghana, as Efesus olog wamogpa, Yahudi nimiri Allah yubu lerop aeag aneko piogti, Yahudi nimiap aneko Yesus yubu ambarelamsiogti, sindi “El tahabe,” aro hailamekne eldi tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tibin nenero ambarelamsiogpa, Yahudi nimi tanekori Paulusag mololamekti, “An nunap olog tane wamebea,” aro molbaeka Paulusti “Kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Kom,” seog aghana, “Pinun,” aro kiplamsiogne, “Amik Allahri nanag, 'Wali saombalulam,' aro ambatnele tanena amik a'unag samoro yanun,” aro kipsiog. Kipsiogti, as Efesus aneko laplobi agha mag alip toman agha as Kaisarea sip piog. ");
INSERT INTO kkl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","As Kaisarea sip piogti, mag abolag sekel piogti, “Yesusag 'Sikne' aro seneragtop nimi Yerusalem wamangne kipsinun,” aro waelbaogti, kipsiogti, as Antiokhia Siria so'oag kulukul aog. ");
INSERT INTO kkl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","As Antiokhia aneko pina wamogha, lanaro kemeroa yabalamsiogti, mog so'o Galatia inagha mog so'o Frigia inagha ni kemelamsiogti, Yesus yubu ka'ero ulamek nimi wana sindinge mikip nenlamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Paulus as Antiokhia lambaogti, mog so'o Galatia inagha mog so'o Frigia inagha Yesus yubu ka'ero ulamek nimi kemelamsiogpa, Yahudinge nhon si Apolos as Aleksandria mangkaekne poneko as Efesus yaog. El yubu lenna babe Allah yubu mome toro piroba babe yabo telekto wali uro elne yaog. ");
INSERT INTO kkl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Samenag Nuni Allahag samoro pirop Ina Yesusti pa'abaogne sembe nimiri Apolos tipto ambarekpa, wana sol wali, wali uro Yesus sembe yeng uro sik uro ambarelamsiog. Sik uro ambarelamsiog aghana, ot samen Yohanesti maghag pelengelamsioghag agha ambarelamsiogne sembe aghabog Apolos el uro wamog. Amik Yesusag “Sikne,” aro seneraglamog nimi maghag pelengelamsiekne sembe ekon wamog. ");
INSERT INTO kkl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yahudi nimiri Allah yubu lerop aeag aneko Apolosti log kom uro alniro nimi ambarelamsiogha Priskilaap Akwilaapti ka'ebarekti, sindi poa sindi aeag pirek. Pirekti, yubu kiki telekto ambarelamdekti, “Allahri Yesus poghol aogneri mog so'oag nimi enero poa Allahag samoro payalamsil Ina pa'abaogne undo,” aro ma'aro ambatek. ");
INSERT INTO kkl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos, “Mog so'o Akhaya punun,” aro ulamogpa, elkabo as Efesus wameknang Yesusag “Sikne” aro seneraglamek nangdi, “Wali leplam,” aro mome toro sikinkabo Yesus yubu ka'ero ulamek nimi mog so'o Akhaya wamek nangag, “Nungkae Apolos a'unag yaleba, wali kiplulom,” aro mome toro pibek. Akhaya so'oag pioghag Allah Wana Walingeri wana heklamsioghag agha samenag agha Yesusag “Sikne” aro seneraglamek. Yesusag seneraglamek nimi Akhaya wamekag Apolos yaogti, maiknoro yeplamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos neneko Akhaya so'oag yaogti, Yesus yubu ambarelamsiog. Ambarelamsiog aghana Yahudi nimiri, “Yesus Allahri poghol aogne kom,” alamekpa, Yahudi nimi tanekoap Apolos ponekoap wana yo uro nimi whingag leldalamek. Sinap leldalamekag agha, Apolosti yubu ambarelamsiogne nimiri wali ka'elamek. Apolos ponekori Allah yubu mome toro pibogne lelekto lag nenero ambarelamsiogti, “Yesus poneko Allahri 'Taulbahimendi, saelbamsululam,' aro wepto poghol aogne yaog,” aro ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos poneko as Korintus wamogpa, Paulus poneko yim kelero palamogha as Efesus yaog. Efesus aneko nimi etbare “Yesus yubu ka'ero ulamap” senerop nimiap haiptaek. ");
INSERT INTO kkl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Sinap haiptaekti, Paulusti sin wamek nimi abenekoag hailamsiogti, “A'undi Yesusag 'Sikne' aro seneraghaomba, Allahri Eldamne Yame Walinge a'unag tatsio, te?” aro haibahiogpa, sindina, “Kom. 'Allah Eldamne Yame Walinge,' selamne nenena ik nhon babe ka'elamap kom yubu agha leplam,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wene seekpa Paulusti, “A'un maghag pelengkipsieknena, etneri yubu ambatsiogne sik sembalumneag agha maghag pelengkipsiek,” aro haibahiogpa, sindina, “Yohanesti yubu ambarelamsiogne ka'ebaburi, sik sembabuba, ambarelamsiogne sunsunum uro maghag pelengkahiek,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Wene seekpa, Paulusti yubu ambarelamsiogti, “Yohanesti mag sinag pelengelamsiognena, '”Malinge ulamlomne lipsimunba, Allahri, 'El amik yalul,' seogne ponekoag 'Sikne' aro seneraglamlulom,” aro nari maghag pelengelamsin,' aro Yohanesti maghag pelengelamsiog. Yohanesti, 'Amik yalul,' seogne poneko Yesus yanepne sembe lebog,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Paulusti wene aro ambarelamsiogti, “Allahri 'Amik yalul,' seogne poneko si Yesus engeropne sembe lebog,” aro ambarelamsiogpa, Yesusti Nia Mangkina Saelbamsilne ponekoag “Sikne” aro seneraglamekne sembe Paulusti maghag pelengkipsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","7","Maghag pelengkipsiog nimi taneko nimi kaubuni aobare saog uro wamek. Paulusti aobare wamek nang taneko usoghag sae pipsiogpa, Allah Eldamne Yame Walinge sin nongag tahiog. Allah Eldamne Yame Walinge sin nongag tahiogne ponekori pam keagman nenelamsiogpa, Allahri tarelamsiogti, el nenelamsiog yubuag ambarelamsiek. Ambarelamsiek, aghana yubu ambarelamsieknena, Allah Eldamne Yame Walingeri yeplamsiogpa, yog nimiri yubu el tangom agha sin ekon urop yubuag agha lelamekti, ambarelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Wene aro ambatsiekti, wamekpa, Paulus neneko Yahudi nimiri Allah yubu lerop aeag aneko log kom uro wal wilindi wa'alamogti, “Allahri mog so'oag nimi saelbamsilnena, undo-undo saelbamsil,” aro ambarelamsiog. “Ka'ebahut. Sik uro lelamna,” aro ambarelamsiogti, sindi “El tahabe,” aro hailamekne eldi tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aghana nimi etbare usog mikip talamekti, “Sik” senelamek komdi, nimi maikno whingag “Paulusti ambarelamsilne, 'Yesusti Allahag samoro pirop Ina pa'abaog,' aro ambarelamsil aghana, yubu nenena Yesusti orolena ambarelamsiog yubu agha Paulusti lelamla,” alamek. Wene alamekpa, Paulusti sin Yahudi nimi wene alamek nimi laplobi agha Yesus yubu ka'elamekne sunsunum uro ulamek nimi enero poa pabihiogti, Tiranusti yubu tam lelamog ae lomag sop-sop winil talamek. Winil talamekti, yog nimiag Yesus yubu ambarelamsiogpa, sindi “El tahabe,” aro hailamekne eldi tibin nenero ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Undo unulamekne nene heng kun phende yubu ambatto leldalamekpa, Yesusti Nia Mangkina Saelbamsilne poneko sembe ambarelamsiog yubu ane nubu talamogpa, Yahudi nimiap Yunani nimiap mog so'o Asia wamek nimi ni ka'ebaek. ");
INSERT INTO kkl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Allahri mikipne Paulus nongag nembamogpa, nimiri, “Allahri el pere agha mane agha ulamla,” senenne kekneba Paulusti ulamog. ");
INSERT INTO kkl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Allah mikipneri el pere agha ulamogpa, Paulusti nongag enektop ag babe, whin keptop ag babe tolamekti, nimi niktop nimiap, phia nimi kulomag urop nimiabag “Wali nembahilul,” aro pil palamsiek. Sinag pil palamsiekpa, malia nimi kulomag ua ulamsiogne lanalamekpa, wali talamek. ");
INSERT INTO kkl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wali talamekpa, Yahudi nimi mema mili lero nimi whesirop nang wamekne as mog eneko kanelamek. Kanelamekti, “Nimi phia kulomag uropne lambaukang,” aro Nia Mangkina Salehiropne Yesus si lelamekti, “Paulusti Yesus si ambarelamsilne neneko si lelamna. Lambahut!” aro whelamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sin undo wheroba tongolamsiekne taneko anabiag agha wameknena, nimi saekpareri ambatto whero poa tongolamsiek. Nimi saekpare enena, memne Allah sembe pairopnang sikindo nhon, Yahudinge si Skewa neneko elmabo saekpareri ambatto whero poa tongolamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wene aro whelamsiek aghana, phia nimi kulomag ua ulamsiogne taneko nhondi lelamogti, “Nana, Yesus na el, Paulus sembe babe ka'ebano, aghana a'unna etne?” alamog. ");
INSERT INTO kkl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wene alamogti, phia kulomag lekneamogne poneko wea sekogti, whesiropnang saekbare nang abeneko olamsiogpa, ae lom wamekag aneko lanalamekpa, sindi ag enekto amekne taepto unuahiogpa, kerebenang eneng laptiktoba piek. ");
INSERT INTO kkl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Undo uro yabiogne neneko sembe ka'ebaekti, nimi as Efesus wamekne Yahudi nimiap Yunani nimiap sin log senelamekpa, Nia Mangkina Salehiropne Yesus si nubu talamog. ");
INSERT INTO kkl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yesusag “Sikne” aro seneraglamek nimi taneko maikno yaekti, “Samenag nuri malia undo-undo ulamobo,” aro nimi haingag lag phoro lebek. ");
INSERT INTO kkl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mema mili lero pharop nimi taneko maikno yaekti, mema uroba si mome toro piameka togto payaekti, nimi maikno haingag agha aukag talamek. Mema si pharop yubu mome toroba ni aukag talamekne tane samenag kal ma'al kamna kapto tolamekne kal ma'al teng-tengne agha kamna kapto tobek aghana, Yesusag “Sikne” aro seneraglamek nimiri sindinge phia si mome toroba aukag tabek. ");
INSERT INTO kkl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Undo uro yabiogneag agha “Yesusti mikip uro Nia Mangkina Saelbamsil,” aro yubu ane nubu tangto sabo talamogpa, Yesusag seneraglamek nimi maikno talamek. ");
INSERT INTO kkl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ni unuaekpa, Paulusti el wanaag agha, “Makedonia so'o inagha mog so'o Akhaya pineri, as Yerusalem punun,” aro seneraghog. Seneraghogti, “As Yerusalem pineri, as Roma nimi babe kemel phinun,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","“Na mog so'o Asia ane olog wamnea amik punun,” aro ilipsabo Timotiusap Erastusap “Samenag Makedonia pururom,” aro pogsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pogsiog abeneko Yesus yubu ka'erop nimi Efesus wamekneri, “Yesusti Allahag samoro yinkirop Ina pa'abaog,” aro ambarelamsieka sembe tam nubunge nembaek. ");
INSERT INTO kkl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nimi nhon si Demetrius wali-walia kirik leng-leng arop kirik perak aroba agha sunuro sorop nimi nhon wamog. Demetrius nenekori sunuro solamognena, Efesus nimiri sikinin phalamek kel Artemis mema pharoba sunuro solamog. Demetriusti sunuroba taneko Efesus wamek nimiri maiknoro tol tolamekag agha sunuro sorop nimi yogne as Efesus wamekne babe tup talamek. ");
INSERT INTO kkl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius ponekori elkabo sunulamek nang poloro wimbahaiogti, yubu ambarelamsiogti, “Nangkabo, nuri sunulamapba, taneag kamna maikno tarelamsiangba, nu tup talamapne nangkabo a'un el wamlom. ");
INSERT INTO kkl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tup talamap aghana, a'undi haingdi iamlomdi, aori babe ka'eamlomne, wene ane Paulus pone yaori, ambarelamsildi, 'Nimiri saeri sunuropne nene, “Mikip imag wamangne saog uro wamang,” aro sunumna sunulamangne sikne kom,' alamlari, nimi tane ni ambatsioba ka'ebaong. Ambarelamsilne ka'ebaong nimina as Efesus nimi aghabog kom, aghana as ni Asia so'oag wamang nimi babe ka'ebaongdi, sik senelamang. ");
INSERT INTO kkl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nuri Artemis nunin phalamap kel wamlaba, Asia nimi taneap nimi mog so'oag nimi niapti elag mili lelamap aghana, Paulus ponekori undo ambarelamsilne nene, nuri nunin Artemis mema sunuro phalamap kel nimiri karong alamikti, teba'en nembaukang. Teba'en nembaukangne abeneog komdina, nuri Artemis nunin phalamap kelap eldi mem ae tane soropne nenekoap babe mali sembaukang,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wene seogne neneko ka'ebaekti, yo lelem yubu haum aro lelamekti, “Nu Efesus nimi sembe nunin phalamap kel Artemis ya'ag paliag wamlul,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","As ene nimi wamek nimi tukom taghom agha longkaekti, Makedonia so'o agha Paulusap nhon palamdek nang Gayusap Aristarkhusap sae salero kiliro pabalamsiekti, as Efesus nimiri longorobag aneko poa phiek. ");
INSERT INTO kkl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Poa phiekpa, Paulus ponekori, “Poa phiekag aneko punun,” sembaog aghana, Yesus yubu ka'ero ulamek nimi tanekori, “Pululam kom,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mog so'o Asia saelbamek nang etpare babe sinap Paulusap nimi pali wamekti, elkabo wamekti, nimiag yubu palilamekti, “As Efesus nimiri longorobag aneko pulul kom,” aro yubu pairo molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nimi maikno as Efesus nimiri longorobag longolamek aghana, nimi nhon-nhon aghabog tam nene sembe el uro wamek. As Efesus nimiri longorobag aneko nimi longol wa'alamek nimi tanekori haum aro lelamekti, “Longol wa'iapnena yubu tamna nene sembe lelamap,” alamekpa, ora nimiri, “Tam ene sembe kom, tamna nene sembe longol wa'iap,” alamek. Wene alamek aghana sinna tamna ekon wamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","“Yubu tam nene sembe lelamap anena,” ekon wamsiogpa, Yahudi nimiri nimi nhon si Aleksander webekti, “Andi yubu tibin nenero ambatsululam,” aro sae kiliro sekirekpa, el nenekori, “Yubu ambatsinundi, yubu kom tahut,” aro sae kwarobatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Sae kwarobatsiogti, “Yubu ambatsinun,” aro ulamog aghana, nimi tanekori “Elna Yahudinge,” aro nimi maikno taneko sin el tahiogpa, yubu maikno haum aro lelamekti, “Nu Efesus nimi sembe nunin phalamap kel Artemis ya'ag paliag wamlul,” aro haum alamekpa, heng phende piog. ");
INSERT INTO kkl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Heng phende piogpa, nimi nubunge Efesus nimi sembe yubu tam kareptop yubu mome toro pibogne poneko wamogti, sin whingag sekogti, “Yubu lemnun,” seog. “Lemnun,” seogpa nimi maikno taneko yubu koma wamekpa, ambarelamsiogti, “A'un Efesus nimi nangkabo. Samenag nu Efesus nimiag kirik imag agha timbalne nunin Artemis yame sunumna saog urop kirik nuri saeag taogpa, nubu kelene mem aeag wali paia ulamap. Nubu kel Artemis phalamap kel eneri kirikap el mem aeap nu Efesus nimiri wali uro paia ulamaba sembe nimi ni mog so'oag wamangne el uro wamang, te? ");
INSERT INTO kkl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ekon wamang komdi, nimi nhondi babe orolena senep kom ane sembe, wana aingnil talapmundi, wali uro seneraghongkia ualulom. ");
INSERT INTO kkl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nimi payahilomne abeneri nuri mem aeag ua uroba haogha tolamdang komdi, nuri phalamap kel nubu kel wamlange san tiliplamdang kom aghana payahilom. ");
INSERT INTO kkl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tam orog agha tane payahilomne sunsunum kom agha payahilom. Tam lelekto kemero kareptobag wamla. Ane sembe, Demetriusap elkabo awe nhon tolamang nimiapti 'Yubu tam nhon nimiag pibukap,' sembaik tanena tam neneko poa tam lelekto kemero kareptop nimiag payalamsinep. Yubu tam lelekto kemero kareptop aeag poa piikpa, nun saelba ulamsiang nimiri sop-sop tam kareplamangne sunsunum uro kareplamukang. ");
INSERT INTO kkl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","'Tam yogne yubu lebukap,' senelamlomne babe wamle tanena, nu saelba uahiropnangdi ambatsiekne sunsunum uro nimi ni poloro wimbahimunba, wali uro karebaukap. ");
INSERT INTO kkl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ot sumene tam orog aghana yubu haum aro leplomne nene agha nun saelbamsiang nangdi samenag yubu sia pibekne phibalom. Nun saelbamsiang nangdi nunag tam pibik tanena, nurina sinag samoro sa'a senep? 'Tamna nene sembe,' aro lepseberi, uahabe taneogna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wene aro ambatsiogti, nimi tanekoag “Pululom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","As Efesus nimiri yanghang alamsieka aneko ta'ap seekpa, olog wameka Paulus elkabo Yesus yubu ka'ero ulamek nimi taneko yopsiogti, wana aingnibahiogti, “Na Makedonia so'oag punun,” aro ambatsiogti piog. ");
INSERT INTO kkl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Makedonia inagha palamogti nimi tanekoag yubu maiknoro ambare-ambare wana aingni-aingni palamsiogti, Yunani so'oag piog. ");
INSERT INTO kkl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Yunani so'oag piogti, wamogpa wal wilindi taogpa, “Mog so'o Siria mag alip toman punun,” sembaog. “Mag alip toman punun,” sembaog aghana, Yahudi nimiri, “Paulus obukap,” aro saekag lebekne sembe el taogti, “Mog so'o Makedonia inagha samoro punun,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","“Punun,” sembaogti palamogpa, elap nhon palamek nangna: Pirus elme Sopater Bereangeap; Tesalonika nimi, nimi phende Aristarkhusap Sekundusap; Derbenge Gayusap; Listrange Timotiusap; Asia nimi, nimi phende Tikikusap Trofimusap; sin nangene Paulusap nhon palamek. ");
INSERT INTO kkl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Paulusap elap nhon palameknang taneko a'ep taekti, sin samenag as Troas piekti, nun sembe tibogamsiekti, as Troas wamek. ");
INSERT INTO kkl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Allah omekto kwaneng roti walerop komne terop li tero liogha, mag alip toman as Filipi laplobi agha palamububa, ae inipna tombare taog. Ae inipna tombare taogpa, as Troas piburi, sin sam piekti, wameknangap haibtaburi, wamubu pahabog ik saek bare taog. ");
INSERT INTO kkl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sae kaupto ua urop sum taogpa, “Kwaneng roti khepto tukap,” aro winiptaburi, Paulusti nunkabo nunap nhon wamekne sinag, “Nu ambuhum pukap,” aro yubu maiknoro ambarelamsiog paghabog ae inipna tomnusam taog. ");
INSERT INTO kkl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ae tika alikinagne nu wamubuag aneko whea maikno tiniro ikik piek. ");
INSERT INTO kkl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Paulus yubu kiliro-kiliro lelamog abeneko kabuni me nhon si Eutikus neneko keken phoro soro kuptopne ina siramag pukamogti, kabuni me eneko haing whi uro wamna koma kwhingdi tungum kanem alamogti, eba timbaog. Ae tika wilindipne nenekoag agha eba timbaogpa, nimiri salero kemelamekag agha ya'ag tebaog. ");
INSERT INTO kkl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ya'ag oroba wamogpa, Paulus poneko kulukaogti, kabuni tebaogha aneko somoro saelbamogti, nimi tanekoag, “Yubu maikno lero engkaheng kom. Me ane kamag wamla,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Wene seogti, Paulus nen samoro aeag tai waelbaogti, kwaneng khepto teekti, nen yubu lelamog paghabog ae kwelekaog. Kwelekaogpa Paulus neneko lambaogti palamog. ");
INSERT INTO kkl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","El palamogpa, nimi tanekori me kabuni aneko kamag wamogne elenge aeag pabiekti, sin ni wana aingniro awi yeng uro wamek. ");
INSERT INTO kkl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","“Pukap,” sembabuba, Paulustina, “A'un sam kabongag agha as Asos pimundi, wapmunag na yan toman agha ina toman yanun,” seogha sunsunum uro nu samenag kabongag mag alip toman agha as Asos piburi wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wamububa, el nunap as Asos haiptaburi, kabongag Paulusap nhon waelbaburi, mag alip toman agha as Metilene pibu. ");
INSERT INTO kkl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","As Metilene mabubua lukunapne as enekoag agha mag alip tomanog palamuburi, mag longoro kanektop so'o Khios peramag piburi, inipnag nhon mamubu. Aneko mabubua kwelekaogne lukunap mag longoro kanektop mog so'o as Samos piburi, mabubua kwelekaogne as Miletus pibu. ");
INSERT INTO kkl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulusti, “Nu anam Yerusalem pin komag agha Yahudi nimiri ik nubu sum Pentakosta uaikag,” sembaogne sembe “Mog so'o Asia ik maikno wamukap kom. As Efesus babe yan ingkan koma pukap,” aro karebaog. ");
INSERT INTO kkl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","As Miletus pina wamuburi, Paulustina, “As Efesus Yesusag 'Sikne' aro seneragtop nimi sikidoyabo wenelamsiang nang na as Miletus wamnaag yaukangba, enel phululom,” aro Miletus nimi pogsiog. ");
INSERT INTO kkl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Enel phiekti yaekpa, Paulusti as Efesus nimi piamsiekti, wenehirop nangag yubu lelamogti, “Nangkabo, samenag Asia so'o eneag yahiri, yana alnina alnilamsiri, ulamsiri, ulamnange a'un elwamlom. ");
INSERT INTO kkl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yahudi nimiri nanag yo palilamneekti, “Obukap,” aro saekag lero ulamneekpa, wana pailangkalamsiri engelamsiri, Nia Mangkina Salehiropne Yesus ponekori awe tolamsinge seklero tolamsi. ");
INSERT INTO kkl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Undop aghana ta'ap sen koma, “El uro wamikpa, yepsilul,” sembahi tanena, yubu eneko a'unag ni ambarelamsisiri, ologha babe tognobahi kom. Tognoban koma yubu ni amolamsisinge nimi ni whingag agha ambatsisiri, a'ununge aeag poloro winil talamlumag babe ambatsisi. ");
INSERT INTO kkl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yahudi nimiap Yunani nimiap ambarelamsisiri, 'Malia ulamlomne lipsimundi, Allahag wana seneraglapmundi, Nia Mangkina Saelbamsilne Yesusag “Sikne” aro seneraglamlulom,' aro ambatsisi. ");
INSERT INTO kkl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yerusalem pineba, nanag uaukangne ekon wamnari wamna. Allah Eldamne Yame Walinge nenekori sae kiliro pabalamneleba punun. ");
INSERT INTO kkl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nanag uaukangne ekon wamna aghana, na as nhonag pang nhonag pang ulamnaba, Allah Eldamne Yame Walinge nenekori, 'Nimiri haing sae kaupkikpa, seklebalulam,' aro lag phoro ambarelamnel. ");
INSERT INTO kkl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","'Seklebalulam,' aro ambarelamnel aghana, nari wana nong ene sembe seneraghal talamna kom. Nari seneraglamnangena, Nia Mangkina Saelbamsilne Yesusti awe na saeag pibogne sol wali, wali uro komopto tolamnun. Awe na saeag pibognena, '”Allahri nimi lunuro opsin koma wana waliri nimi talulamsil,” aro yubu walinge Yesus sembe ambarelamsululam,' aro na saeag pibog. ");
INSERT INTO kkl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Wene aro na saeag pibogpa, as nhonag pang nhonag pang ulamnori, a'unag babe Allahri mog so'oag nimi saelbamsilne sembe ambarelamsino aghana, a'undi nari whing ene nen olog imnululom komne, na el wamna. ");
INSERT INTO kkl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Ane sembe sumene ane yubu mikip uro a'unag lelamnangena, Allahri 'Yubu ane ambatsululam,' aro ambarelamneonge ta'ap sen koma a'unag tipto ni ambarelamsino. Ane sembe nimi nhondi nari yubu Yesus sembe ambatsinonge ka'ebaom kom tanena Allahri opsilea tam nanag nembaheng kom. ");
INSERT INTO kkl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","29","Na a'un laplobi agha pineba, pai kam yonge saog urop nimi yingkina saluro kilphaikagti, wali uro a'unkaboap a'un wenehirop nang a'undam nimi wanaapti haing whi uro yae wamsululom. Allah Eldamne Yame Walinge nenekori, 'A'unkabo pham domba saog uro wamang nimi taneko yubu amohiro paiamsululom,' aro sekitsio. Sekitsioba, pai kam yonge saog urop nimiri pham domba Allah Eldamne enengag agha toro topsio nimi taneko o'ona sembahin koma wea oro kilphaikagti, Yesusag 'Sikne' aro seneragtop nimi haing whi uro yae piamsululom. ");
INSERT INTO kkl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","A'un anabiag agha babe nimi sekelingkukang. Sekelingkikti, Allah yubu lero orolenange agha sikne nembukang. Orolenange agha sikne nembamikti, Yesus yubu ka'ero ulamang nimi wana tolamsikpa, sinag 'Sikne,' aro sare nelebahukang. ");
INSERT INTO kkl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Orolenange agha sikne nembamikti, wana tolamsik nimi yaukangne sembe seneragto yae uptangkamlulom! Heng kun wilindi sinag kweleknag na olog ta'apsen koma nari wanaag agha engelamnoriog a'un ni ambarelamsinonge ekon taheng kom. ");
INSERT INTO kkl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Wene, 'Allahri a'un piamsilul,' aro nari a'un Allah saeag nenelamsin. 'Allahri opsin koma wana waliri talulamsil,' aro Yesus yubu sembe ambarelamsinne salelapmunba, Allahri a'un mikip nenelamsileri, 'Yesusag “Sikne” aro seneraglamik nimi taneko Na namabo,' aro weplamsil nimi niag tatsilul. 'Na mabo,' senelamsildi, eldinge saeag agha tatsileba, ya'ag kamag wamukang. ");
INSERT INTO kkl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nari, 'A'undi saeagha leng-leng aroba emasto, perakto, enektop agto a'undi na tatneheng,' aro wanaag seneraglamno kom. ");
INSERT INTO kkl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nanap nangkabo nhon wamubungeap teko nunag wamogne sembe nadamne saeag agha kamna kapto tolamsinge a'un elwamlom. ");
INSERT INTO kkl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nari ulamnonge 'Sindi babe imniikti, ulamukang,' aro sunumna ulamno. Nia mangkina ulamnongena, 'Sol wali, wali uro welapmundi, nimi mikip komne yeplamsululom,' aro ulamnoba, imneom. Nia ni ulamnonge aneko, Yesusti yubu ambarelamsiogne seneragi agha ulamno. Nia Mangkina Salehiropne Yesusti ambarelamsiogti, 'Nimiri a'unag tatsiikne olog wali sembamlom aghana, nimiag tatsululomne sembe “Wali sirik,” alamna,' aro ambatsiog. Yesusti ambarelamsiogne seneragi agha nia mangkina a'un anabi agha ulamno,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ni ane Paulus nenekori ambatsiogti, yabu sanukto pulingkina sin Allahag molona molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Allahag molona lero molbaekti, sindi Paulus somoro togtog aro kiplamekti, “Wali pululam,” aro maiknoro engkarek. ");
INSERT INTO kkl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Paulusti, “Nen amik whing imnululom kom,” seogne sembe, “Nen haiptaukap kom,” aro wana sapsiogpa, “Mag alip toman pulul,” aro kabong wamoghag mag abolag pil piek. ");
INSERT INTO kkl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nungkabo as Efesus Yesusag “Sikne” aro seneragtop nimi wenehirop nimiap wamuburi, wana ikin uro sae liptaburi, mag alip toman palamubua mag longoro kanektop so'oag as Kos peket pibu. Kos pina mabubua kwelekaogne, mag longoro kanektop so'oag as Rodos pibu. As Rodos pina mabubua kwelekaogne nen mag alip toman palamubua kabong pabalingkirobag aneko haing kerekaek as Patara pabalingkibu. ");
INSERT INTO kkl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patara piburi, kabong Fenisia so'oag piropne nhon ibuburi, phoanari ko'oro pabalamlul arop kabong anekoag waelbaburi pibu. ");
INSERT INTO kkl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Palamuburi mag longoro kanektop mog so'o Siprus ibubu aghana, Siprus waneng sip nenelobiagha mog so'o Siria simbik palamubu. Palamuburi as nubunge Tirus pibuag anekoa kabongag nia mangkina pabalamogha taneko as enekoag yognepti, as enekoag saingnil pibu. ");
INSERT INTO kkl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Saingnil piburi, as Tirus anekoa Yesus yubu ka'ero ulamek nimi wamekne kemeroa yabihiburi, ik saekbare wamubu. Tirus ane wamububa, Allah Yame Walingeri Yesus yubu ka'erop nimi tanekoag ambatsiogpa, yubu ane nen tipto Paulusag, “Yerusalem pheng kom,” aro ambarek. ");
INSERT INTO kkl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aneko wamubua nun ina panne peram taogpa, anekoa sin laplobi agha lambaburi palamubu. Anekoa lambaburi, “Yerusalem pukap,” aro palamububa, as enekoag nimi Yesus yubu ka'erop nimiap, sindi kelabo meapti nu poa kabong saingnilingkirobag pil phiekpa, mag abolag aneko yan yabu sanukto pukuburi, Allahag molona molbabu. ");
INSERT INTO kkl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Aneko sae saleptaburi pogtabu. Nu kabongag walelamububa, sin sikininge asag samoro piek. ");
INSERT INTO kkl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tirus nimi sikininge asag piekpa, nu mag alip toman agha as Ptolemais piburi, nungkabo Yesusag “Sikne” aro seneragtop nimi as eneko nimi wamekne kipsiburi, ik nhon sum wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mabubua kwelekaogpa, palamubua as Kaisarea pibu. As Kaisarea nimi nhon wamogne, samenag as Yerusalema nimi saekbare “Kwaneng pogto yauog kelabo o'oro tarelamsululom,” aro wepsiekne nhon sina Filipus wamog. Filipus samenag yauog kelabo sembe kwaneng pogto tarelamsiogti, el babe yubu walinge Yesus sembe ambarelamsiogne wamogpa eldi aeag wa'iburi, wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipus ponekori ae wamubuag wameknena, elmangkelabo saren tombare abeneko wamekpa, Allahri sin wanaag yeplamsiogpa, Allahri yubu silimu tipto ambarelamsiek kelabo wamek. ");
INSERT INTO kkl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yingkina aneko Filipus ponekori aeag ik etbare wamububa, Allahri yubu silimu tiptopne nhon sina Agabus mog so'o Yudea agha as Kaisarea wamubuag kulukul aog. ");
INSERT INTO kkl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","El nun peramag yaogti, Paulustinge enektop ag sembe uwoghag noptop haing lobogti, Agabus eldamneri sae yan kabuldalamogti, nunag yubu lelamogti, “Paulusti uwoghag noptop haing ane el uwoghag agha lopnari, kabuldalamna. Unuanne nene sembe Allah Eldamne Yame Walingeri nanag ambarelamneori, 'Nari unuanne saog uro Yahudi nimi as Yerusalem wamangneri haing ngainge poneko uanne nene saog uro kaubukang. Kaubikti, Allah omektop kom nimi Yahudi sisa kom nimi saeag nembaukang,' aro ambatneo,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wene seogha ka'ebaburi, Yesus yubu ka'erop nimi taneko wamek nimiapti Paulusag “Yerusalem pheng kom,” aro yubu mikip uro molbabu. ");
INSERT INTO kkl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paulusag “Yerusalem pheng kom,” aro molbabu aghana, Paulustina, “Sa'a sembe engelamnelomdi, wana ikin nenelamnelom? Na haing sae kaupniikne tamna ikin kom senelamna. Yerusalem nimi Yesus sembe ambarelamsinenge sembe ya'ag omniikpa, tebanunne babe tamna ikin kom senelamna. Na sembamnangena, 'Yahudi nimiri Nia Mangkina Salehiropne Yesus yubu saelbamikpa, Yesus si nubu talul,' aro as Yerusalem palamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nuri lebubunge ka'eban koma eldi wene seogpa, nurina, “Elba. Nuni Allah seneropne agha elag ualul,” seburi, yubu kom tabu. ");
INSERT INTO kkl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Kaisarea aneko ik sulu wamubua nuringe togna toguburi, Kaisarea nimi Yesus yubu ka'ero ulamek nimi etbareap as Yerusalem palamubu. Yerusalem palamububa, sindi nu poa nimi nhon si Manasondi aeag poa phiek. Elna mog so'o Siprusne samenag agha Yesus yubu ka'elamogti, Elag seneraglamogne Manasondi aeag wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","As Yerusalem pibuba, nungkabo Yesusag “Sikne” aro seneragtop nimiri sin wana awi yeng uro nu kiplamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pina mabubua kwelekaogpa, nu ni Paulusap wamubunge Yakobus kemel pibuba, Yesusag seneragtop nimi Yerusalem wamek nimi wenehiropnang ni babe wamek. ");
INSERT INTO kkl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Wamekpa Paulusti kipsiogti, yubu ambarelamsiogti, “Allahri na pere agha mikipne na tarelamneoba, Yahudi sisa kom nimi Yesusag 'Sikne' aro seneraglamang,” aro sin wamekne taneko yubu kiki lelekto ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wene aro Paulusti ambatsiogne ka'ebaekne sembe sin ni Allah omeklamekti, Paulusag yubu lelamekti, “Paulus, nangkae! Kembahi, Yahudi nimi teng-tengne wene Yesusag 'Sikne' aro seneraglamangne as Yerusalem tane wamang. Yesusag 'Sikne' aro seneraglamang nimi taneko Yahudi nimi wamang ane sembe sol wali, wali uro Allahri samenag, 'Israel nimi noropto saelbamukang,' aro Musa ambarog yubu mome toro pibogne sunsunum uro ul palamang. ");
INSERT INTO kkl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Sol wali, wali uro ul palamang aghana, nimiri an sembe sinag minirop yubu ambarel palamsiong. Minirop yubu ambarelamsiongnena, 'Paulusti Yahudi sisa nimi as tala-tala wamang nimi ambarelamsildi, “Musari samenag yubu pibogne sunsunum uro a'un Yahudi nimiri ul palamlomne lipsululom. Samenag agha a'un mabo kon kareplamsilomne babe lipsululom,” aro wene Paulusti ambarelamsil. Paulusti ambarelamsilne as tala-tala Yahudi sisa kom nimi urobag ambarel palamsil,' aro ambarelamsiong. Minirop yubu an sembe ambarelamsiongne tane nubu taoba, Yahudi nimi maikno tanekori ka'ebaong. ");
INSERT INTO kkl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ka'ebongdi, el uro wamangag an tane yalamne ka'ebaikti, anag uaukangne sembe huaukap? ");
INSERT INTO kkl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nuri lebebenge nene ka'ebamendi, ualulam. Nu anabiag tane nimi tombare samenag salag lebongdi, '”Allah arukna sol wali walinge wamukap,” aro keknep uro yabalameberi, hong karepto koma wamebea, wal nenekoag hong karebahukang,' aro salag pibong. ");
INSERT INTO kkl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Sin tombare 'Hong karepto koma wamukap,' seong nang abenekoap palapmundi, samenag Musari 'Allah whingag sembenga pabeheng kom,' aro mome toro pibogne sunsunum uro alel talamlulom. Alel talapmundi, Allahri Ae aramag wa'imunba, sin hong karebahikne sembe kamna tatsimendi, Allah sembe pibukangne sembe babe tatsululam. Undo unulapmendi, anap sinap Musari mome toro pibogne sunsunum uro ul palapmunba, nimi taneri ipkikti, an sembe minirop yubu ka'ebaongne neneko, 'Sikne kom,' aro el taukang. Sindi el talamukangne, 'Paulusti babe samen Musari mome toro pibogne neneko sunsunum uro ul palamla,' aro el taikti, Yahudi nimi tanekori tam anag pibongne 'Kom talul,' senelamap. ");
INSERT INTO kkl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yahudi sisa nimi tanekori anag tam pibongne lero libapti, wene Yahudi nimi sisa kom nimi agha Yesusag 'Sikne' aro seneraglamang nimi taneko sembe mome toro sinag pibobonge ambatkenun. Sindi ul palamukangne sembe samenag yubu lebobori, karebabonge sunsunum uro mome toro pibobo. Sin sembe karebabongena, 'Lebe aroba eneng la'imbaleag,' aro homamanga lepto oroba sopap, enengap telamukang kom. Eneng lambaleba, sop ane telamukang. Ora nimiri, “Phia sembe phabaukap,” aro lebe aroba sop palilamikti, mektop sop babe yoro tarelamsiikpa, telamukang kom. Apna, nengaboap kelaboapti yog nimiri kelabo nengabo sembe, “Naringe og wamso,” aro wanaag seneragikti, saelbahukang kom,' aro karebabo. Karebobori, mome toro pibobo,” aro sindi Paulusag ambarek. ");
INSERT INTO kkl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Wene aro ambarekpa, lukunap Paulusti nimi tombare “Hong karepto koma Allah arukna sol walinge wamukap,” seek nimi taneko enero pabihiogti, samenag Musari “Allah whingag sembenga pabeheng kom,” aro mome toro pibogne sunsunum uro wali uro sin nong mag a'aleptaek. Wali uro sin nong mag a'aleptaekti, Allahri Aeag palamekti, “Allahag salag pibobonge neneko taknep sum peram wamlaba, Musari yubu sunsunum uro ik etpare aleltalameberi wamebea, salag pibobonge taknep sumeneko Allah sembe a'ero-a'ero webabonge payaukap. Payabeba, Allah sembe nuri saeag agha lebe aroba oro paibatsululom,” aro Yahudi nimiri saeag agha Allah sembe pairopnang Paulusap nhon ambarel phiek. ");
INSERT INTO kkl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","“Hong karepto koma wamukap,” seek nimi tanekoap Paulusapti, “Allahag oro tarukapne 'Wali,' sembalul,” aro ik saekpare sum Musari mome toro pibogne sunsunum uro sin nong aleltalamek. Aleltalamekti, wamekpa, salag pibekne taktop sumeneko peram taogpa, Allahri Aeag piekti, wamek. Wamekpa, Yahudi nimi agha Asia so'oag urop nimi agha yaekti, kemelamekpa, Paulus Allahri Ae aramag wamogpa, ibek. Ibekti nimi orangeag wanaag aluktop yubu lebek. Wanaag aluktop yubu lebekpa, nimi maikno tanekoag sikin sip taekti, Paulus saelbaek. ");
INSERT INTO kkl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Saelbanebag haum alamekti, “Israel nang yebelahisu! Nimi eneri tala-tala pina, nun Yahudi nimi san tilipto ambarelamsil. Samenag Allahri, 'Undo-undo ulamlulom,' aro Musaag ambarogpa, mome toro pibog. Musari mome toro pibogneap, Allahri Ae eneap babe mombolag nenero ambarelamsil. Wene ane iplulom! Eldi Yunani nimi poa Allah Eldamne Mem Ae aramag payalamsildi, sembenga nenelal,” alamekti, Paulus saelbaek. ");
INSERT INTO kkl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sindi wene alamekti saelbaeknena, Trofimus Efesusne poneko samenag inaag Paulusap nhon asag palamdeka ibekne sembe, “Allahri Aeag ane poa wa'alal,” senelamekti, yubu haum aro lelamek. ");
INSERT INTO kkl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Haum alamekpa, nimi ni wamloa saog uro as enekoag wamekne tagto longolaekti, Paulus salero Allahri Ae aramag agha kiliro poa lanalamekpa, Allahri Ae aram leka ina siramag serekaek. ");
INSERT INTO kkl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ina serekaekpa, sindi “Paulus ya'ag obukap,” aro ulamek abeneko, “Yerusalem nimi niri haum alamang,” aro ka'ebaekti, yubu poa Roma nimi sembe yin saleropnang sikindoag yubu pabiek. ");
INSERT INTO kkl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wene aro ambarel piekpa, yin saleropnang sikindo ponekori el umag yubu eptopnang etbareap, ilipsabo yin saleropnang etbareap poloro winiptaek. Poloro winiptaekpa, topsiogti elemag Paulus olamekag aneko piek. Piekpa, Paulus olamekti, yin saleropnang palameka ililamsiekti, Paulus olameka libek. ");
INSERT INTO kkl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Olameka libekpa, yin saleropnang sikindo poneko Paulus peramag sekel piogti, saelbaogti, “Besi agha sorop haing phende topmundi, el sae kauplulom,” aro ilipsabo arukahiog. Wene aro arukahiogti, Yahudi nimiri Paulus olamek nimi tanekoag hailamsiogti, “Nimi enena etne? Eldi hualba olamlom?” aro haibahiog. ");
INSERT INTO kkl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wene aro haibahiogpa, nimi tanekori yubu maikno lelamekti, nenneri “Undo sembe,” nenneri “Unuaoa sembe,” aro wene alamekne, tam ane sembe senen komdi, yin saleropne sikindo ponekori eldi aruknaag, “Nuri aeag pabululom,” aro arukahiog. ");
INSERT INTO kkl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","“Pabululom,” seogpa, pil palamek abeneko “Paulus obukap” senerop nimi maikno tanekori wanaag yo lelem “Toghitlulom,” alamek. Wanaag yo lelem “Toghitlulom,” alamekpa, yin saleropnangdi sindi ae alongag piekag aneko, “Paulus obukap,” aro maiknoro longolamekti, lingniltalamekpa, yin saleropnang tanekori Paulus keyapto ae alongag tai sip poa waelbaek. ");
INSERT INTO kkl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulus neneko yin saleropnangdi asag poa, wa'inebag “Aeag poa wa'aukap,” aro ulamek abeneko Paulusti, “Na yubu olog ambatkinun!” seogpa, yin saleropnang sikindo ponekori, “Anna Yunani yubu el te?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Wene selamba, anna Mesirne poneko kom te? Weneog aneko suknumna suknubaomdi, 'Roma nimi mombolag wamukap kom,' aro mal taropnang teng-tengne (4000) poro agha aldesag piomne poneko kom te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Wene aro haibaogpa, Paulustina, “Nana Yahudinge, nari asna Tarsus, as nubunge Kilikia so'oag wamlange nenekoag wamna. Nimi maikno taneag yubu ambatsinundi, mololangken,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wene seogpa, yin saleropne sikindo ponekori, “Wali andi ambatsululam,” aloghog abeneko Paulus ae alongag sekelingkiogti, sae la'abatsiogpa, yubu kom tanaek abeneko Paulusti Ibrani yubuag yubu ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Yahudi nimi nangkabo, naniyabo, a'undi lolomnange nanag lolbitneomba, nari tibin nenero peleptangtop yubu ambatsinunne ka'eamlulom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","3","Undo wene seogpa, nimi maikno tanekori nimi poneri Ibrani yubuag ambarelamsil aro ka'ebaekti, yubu koma wamek. Yubu koma wamekpa, Paulusti, “Nangkabo, a'un Yahudi nimi wamlomne saog uro na babe Yahudinge wamna. Na mangkaneekag as Tarsus Kilikia so'oag wamlange nenekoag agha mangkaneekpa, as Yerusalem ane yahiri, nubu tahi. Nunisa Musa yubu elne Gamalielti, Musa yubu kop-koptagto ao mili kuruk aneogpa, wali uro el tahi. El tahiri, a'un wamlomne Allah sembe wana wali uro ulamlom saog uro, nari babe Allah sembe ta'ap sen koma sol wali uro ulamsi. ");
INSERT INTO kkl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“Allah sembe sol wali uro ulamsi aghana Yesusag seneragna komag wamsi. Yesusag 'Sikne' aro seneraglamsi komdi, nari babe Yesusti Allahag samoro yingkirop Ina pa'abaog yubu ka'ero ulamek nimi sare nelepto ya'ag olamsisi. Ya'ag olamsisiri, nenne salero kabuniap kelaboap kop aeag tolongolamsisi. ");
INSERT INTO kkl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","6","Undo ulamsinge nene memne Allah sembe pairopnang sikini nubungeap, Yahudi nimi wenehirop nang nubunang babe, sindi nari uahinge el wamangdi, 'Sik lepla' aro lemnep. Sindi nanag, 'Yesus yubu ka'erop nimi ebahimendi, haing sae kaupto saelbahimendi, as Yerusalem samoro payahimenba, opsukap,' aro mome nanag pibatneek. Mome ane nanag pibatneekti, pogneekpa, palamsiri, 'Sikinkabo Yahudi nimi as Damsyik wamang nimiag mome ane tarel phineri, Yesus yubu ka'erop nimi saelbahinun,' aro palamsi. 'Saelbahinun,' aro palamsiri, as Damsyik peramag ae siro palamsiag agha heng yame saogne haing omomne imag agha nanag tingil omneog. ");
INSERT INTO kkl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tingil omneogpa, na so'oag malingkihiri ka'elamsiba, yubu nhon lelamogti, 'Saulus, Saulus! Sa'a sembe Na “Seklebale,” aro ulamnelam?' seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Wene seogpa, nari hailamsiri, 'Nani, Anna Etneri lelamlam,' sihiba, Eldina, 'Na Yesus Nasaretne andi “Seklebale,” aro ulamnelamne ponekori lemna,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Heng yame saogne nanag tingkaneogne nimi nanap palamubungeri babe ibekti, aoag agha yubu lilim ka'ebaek, aghana yubu nanag lelamogne sindi ka'ebaek kom. ");
INSERT INTO kkl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Eldi yubu ka'ebaek kom aghana, nari lelamsiri, 'Nani, sa'a agha nari uanun?' sihiba, Eldina, 'Sekmendi Damsyik pululam. Damsyik pimenba andi ulamlulamne Allahri seneropne ambatkenep,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","'Damsyik pimenba, ambatkenep,' seog aghana, na haing omomne warero libango aropne nenekori haing ubaneogpa, pinep komdi nangkabo nhon palamubu nangdi sae salero Damsyik poa pineek. ");
INSERT INTO kkl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Poa piniekpa, as Damsyik aneko nimi nhon sina Ananias. Ananias ponekona, Musa yubu sunsunum uro sol wali uro ulamogpa, Yahudi nimiri as Damsyik anekoa el wamogne sembe walinge senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","El neneko na peramag yaogti, yubu lelamogti, 'Saulus, nangkae. Haing kwelekae,' seog abeneko pere na haing kwelekahiri, nari elag kembahi,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Elag kembahiba, nanag eldi yubu lelamogti, 'Allah nunisag yabori omeklamekne ponekori weplangkeldi, “Allah Eldamne seneropne walinge el taleri, Nimi Sikne yaogne poneko ipleri, Eldi yubu pamag agha lanaropne ka'ebanulul,” aro wepkel,' aro Ananiasti ambatneog. ");
INSERT INTO kkl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wene aro ambatneogti, nen lelamogti, 'An haing kwelekalamdi iplamne, ka'ebalamne Eldi ualne andi nimi ni ambarelamsululam. ");
INSERT INTO kkl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sa'a sembe wene nang-nangalamlam? Sekmendi Yesusag, “Malia uanonge tam orog nembanululam,” aro Yesusag yubu mololapmenba, maghag pelengkakukang,' aro Ananiasti ambatneog,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Paulusti nen tipto ambarelamsiogti, “Na samoro Yerusalem yahiri, Allahri Aeag wamsiri, Allahag yubu mololamsi. Allahag yubu mololamsiri, haing uamna kwelekamna senenag agha Nia Mangkina Salehiropne Yesus poneko ipsi. Ipsiri tilamsiag agha Eldi nanag yubu lelamogti, 'Na sembe yubu ambarelamsilamne ka'ebaukang komba, Yerusalem anea elem-elem lambalulam,' seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","'Lambalulam,' seogpa, nari lelamsiri, 'Nia Mangkina Saelbamsilamne, sin elwamangne, nari Allah yubu lerop aeag agha nhonag wa'ang, nhonag wa'ang ulamsiri, An Yesusag “Sikne” aro seneraglamek nimi salero kop aeag tolongolamsisiri, olamsisinge sin el wamang. ");
INSERT INTO kkl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Stefanus poneko, An Yesusti ulamluma ipkeogti, nimi ambarelamsiog. Yesus sembe ambarelamsiogne sembe ya'ag olamekpa, olamek sumeneko, 'Wali ya'ag olamang,' aro na wamsiri, sae saekag sembahi. Wene sembahiri, Stefanus olamek nimi tanekori sindi enektop ag pibekpa, nari yae piamsisi,' aro Yesusag ambatsi. ");
INSERT INTO kkl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Wene aro ambatsiba, Nia Mangkina Saelbamsilne ponekori nanag lelamogti, 'Yerusalema lambamendi, pululam. Amik Nari an mog so'o weag wamang nimi Yahudi sisa kom nimiag poglangkenun,' aro ambatneog,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nimi Paulusti yubu ambarelamsiogne wali ka'elamek aghana, wene aro “Nia Mangkina Saelbamsilne ponekori, 'Mog so'o weag wamang nimi Yahudi sisa kom nimiag poglangkenun,' aro ambatneog,” aro Paulusti ambarelamsiog abeneko, Yahudi nimiri ka'ebaekti, wana yo senelamekti, “Nimi undopne ya'ag oplulom! Undop nimi wamnep kom,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wene alamekti, Yahudi nimiri sindinge ag siriro pelengerobag kwiripto tobog ahiekti, hao lopto alikinag towalengelamek. ");
INSERT INTO kkl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Undo unulamekpa, yin saleropne sikindo ponekori, “Nimi maikno taneko yubu sa'a sembe lelamang, eltanundi,” aro, “Paulus aeag pabumundi, taeplam-taeplam lobalulom. Taeplam-taeplam lopmundi, wana aluktop yubu ambatsilne el talulom,” aro ilipsabo ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yin salerop nang tanekori Paulus pabiekti, “Taeplam-taeplam lobukap,” aro yan sae kiliro haing kauplamek abeneko Paulusti, yin saleropnang sikindo nhon Paulus peramag sekamogne ponekoag hailamogti, “A'undi tam wali uro kembitna koma nimi Roma nimi opsinep te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wene aro haibaogpa, yin saleropne poneko Paulusti lebogne neneko ka'ebaogti, eldo yin saleropne ponekoag piogti, “Paulusti wene sel,” aro ambarelamogti, “Paulus pone babe Roma nimi wamlaba, sa'agha elag ualulam?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Wene aro haibaogpa, yin saleropne sikindo poneko Paulusag piogti, “An sik Roma nimi wamlam?” seogpa Paulusti, “Yo, ot andi leplam ane,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Wene seogpa, yin saleropne sikindo ponekori, “Na babe 'Romange tanun,' aro kal ma'al kamna alikinag Roma nimi sikini yabo tatsisi,” seogpa Paulusti, “Na kal ma'al tatsisi kom. Nani Romangeri mangkaneogpa, Romange wamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wene seogpa, yin salerop nangdi “Taeplam-taeplam lobebeba, nu eltanepne ambatsilul,” aro haing kaubek nang tanekori babe ka'ebaekti, “Obukap kom,” aro log lelem elemag-elemag piek. Sin log lelem elemag piekpa, yin saleropne sikindo ponekori babe, “Romange agha mane agha, 'Besi agha sorop haing agha kauplulom,' sen,” aro log sembaog. ");
INSERT INTO kkl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yin saleropne sikindo ponekori, “'Yahudi nimiri Paulusag tam pairo ulamangne nene sa'a sembe ulamang?' aro sik wali uro eltahane,” senelamog. Wene senelamogti, mabogha kwelekaogne memnang Allah sembe pairopnang sikindo yaboap, Yahudi nimi sembe tam lelekto kemero kareptopnang Mahkamah Agama nangap yopsiog. Yopsiogti, poloro wimbahaiogpa, wamekag Paulus haing sae lopto enero poa sin wamekag payaek. ");
INSERT INTO kkl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulusti, Yahudi nimi sembe ua tam lelekto kemero kareptop nimi Mahkamah Agama nimiag yop-yoba kembahiogti, lelamogti, “Nangkabo, samenag babe, wene babe, 'Allahri ililamnel,' aro ul palamnange nene nari wanari babe, tam malia uan kom sembamnari wamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Paulusti wene alamoghag agha memne Allah sembe pairopnang sikini nubunge Ananias ponekori ka'ebaogti, wana yo sembaogti, “Paulus pamag taeplam loplulom,” aro peramag wamek nimiag wene aro arukahiogpa, pamag taeplam lobek. ");
INSERT INTO kkl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pamag taeplam lobekpa, Paulusti memne Allah sembe pairopnang sikini nubunge ponekoag, “Andi, 'Na walinge malia urop komne,' senelamlamdi ulamlam aghana, Allahri an babe opkulul. Andi senelamlamne, 'Musari mome toropneag kembiagha sunsunum uro Paulusti tam ene karebanun,' sembalam aghana, 'Pam taepto oplulom,' selamne agha andi Musari yubu mome torop mome eneko philamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wene seogpa, Paulus peramag wamekti, ka'ebaek nimi tanekori, “Andi nimi nubunge memne Allah sembe pairopnang sikini nubunge san tiliplamlam,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Wene seekpa Paulusti, “Nangkabo, samenag Musari mome toro pibognena, 'A'uni yabo saelbamsiang nangag san tilipto yubu malinge lepseng kom,' aro mome toro pibognena na el wamna aghana, el poneko nimi nubunge memne Allah sembe pairopnang sikini nubunge wamlange na ekondi ogto lemna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Wene seogti, “Nimi wamek nimi taneko Saduki nimiap Farisi nimiap winiltalamekag nhon wamang,” aro eltaog. Saduki nimiri senelamekti, “Nimi teptopne yame orogti, nimi teptopne kamag tanep kom. Allah arukna malaikat babe orog,” senelamek. Undo senelamekpa, Farisi nimiri, “Nimi yame wamangpa, nimi teptopne kamag tanep. Apna Allah arukna malaikat babe wamang,” senelamek. Sindi senelamekne sembe el uro wamogti, Paulusti tam kareptopnang Mahkamah Agama nimi tanekoag yubu ambarelamsiogti, “Nangkabo, na babe Farisinge wamna, nani babe Farisingeri mangkaneog. 'Nimi teptopne Allahri kamag nembahilul,' senelamnari, nang-nang aro ulamnange ane sembe na enero poa yaneangba, wene tane tam kareptobag wamna ane,” seog. Eldi wene seogne sembe nimi taneko yubu ka'ebaekti, Farisi nimiap Saduki nimiap sin waltalamekti, winil talamek nimi taneko nenne Farisi nimiag sip talamekpa, nennne Saduki nimiag sip taekti, sin sae saekag lero wamek kom. ");
INSERT INTO kkl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Undo wene alamekti, sin maiknoro yo piptangka leldalamek. Nimi etbare Farisi nimi Musari samenag mome tobogne ambatsiropnang sekelabiekti yubu lelamekti, “Nuri kembabag nimi eneag tam nenenne olog ibap kom. Nimi eneri yubu lelamlangena Allah arukna malaikattiro, nimi yameriro ambarogne agha lelamloa saog sembaap,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Sin yubu haum hag aro lelamekpa, yin saleropne sikindo ponekori “Paulus kiliro pobikag, logti,” aro yin saleropne sikindo ponekori ilipsaboag, “Kulukamundi tolingkina nu yin saleropnangdi aeag pabululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pabiekpa, kwelekaogne, inipnag Paulus malamogpa, Nia Mangkina Salehiropne Yesus el peramag yaogti, yubu lelamogti, “Wana keagman uro wamlulam. Na sembe andi Yerusalema lebom saog uro, Roma pimendi babe wene aro ambatsululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wene seogpa, mabogha ae kwelekaogpa, nimi Yahudi nimi taneko tognorobag longoptaekti, “Paulus obukap,” aro yubu lelamekti, “El ya'ag obebe taneogna kwanengap magap tukap. Kom tanena Allahri nu opsinep,” aro salag yubu karebaek. ");
INSERT INTO kkl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","“El obeberi, kwaneng tukap,” seek nang taneko teng nhonap epto naual bare nangdi lelamekpa, nen ma'aropne wamekti. ");
INSERT INTO kkl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","“El obeberi, kwaneng tukap,” seek nang tanekori memnang Allah sembe pairopnang sikindo yaboap, Yahudi nimi sikindoyabo wenehiropnangap ambarel phiekti, “Nuna 'Paulus obebe taneogna kwanengap magap tukap. Kom tanena Allahri nu opsilul,' aro salag yubu karebap. ");
INSERT INTO kkl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Wene aro karebap ana, a'unap Yahudi nimi sembe tam lelekto kemero kareptopnang Mahkamah Agama nangap poloro wapmundi, mome toro yin saleropne sikindoag mome pipmunba, 'Nen sap samoro tam wali uro kembaukap ane sembe Paulus payalulam,' aro maneri mome toro piplulom. Pipmunba, yin saleropnang sikindori mololapmunne ka'ebaleri, nuri 'Obaukap,' senelamapne ekondi, 'Paulus sin wamangag payalulom,' aro arukahilul. Arukahileba, payalamikpa, inaag anam a'unag Paulus payan komag nuri inaag webaberi obukap,” aro ambatsiek. ");
INSERT INTO kkl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Wene alameka aghana Paulus ilipsa'eldi mangaroba me nhon wamog menekori sindi yubu lelamekne ka'ebahiog. Ka'ebaogti, meneko yin salerop nangdi aeag piogti, “Paulusap haiptanunam,” aro yin salerop nang yae wamek nang tanekoag ambatsiogpa, “Hae haiptarurom,” seekpa wa'iogti, sindi lelamekne ka'ebahiogne Paulusag ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wene aro ambarogpa, Paulusti yin saleropne nhon yobogti, “Me ane poa lepmendi, a'undo yin salerop neag poa pululam. El a'undoag yubu olog leplul,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Wene seogpa yin saleropne ponekori me aneko poa lebogti, sikindo yin saleropneag poa piogti ambarelamogti, “Paulus ae kop aeag wamlange ponekori yopneldi, 'Me ane anag poa pululam,' sel. 'Meneri yubu olog elag ambatlul,' selba payan,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Wene aro ambarogpa, yin saleropne sikindo ponekori meneko sae kiliro saelba ae paroag sip piog. Ae paroag sip piogti, hailamogti, “Sa'a agha nanag 'Ambatnun,' aro leplam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Wene seogpa menekori, “Yahudi nimiri saekag lelamangne ka'ebahinnena, nari nawang Paulus sembe 'Nen sap samoro ambuhum tam wali uro kembaukap. Nuri tam lelekto kemero kareptobag Mahkamah Agama winil talamikag payalulam,' aro anag molbaghukang. ");
INSERT INTO kkl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wene aro molbaghukang aghana, andi sindi yubu ka'ebahiseng kom. Nimi teng nhon epto naual bare phelekto abenekori, 'Paulus obukap,' aro inaag webaikti wamnuang. Sindi lebangnena, 'Nu Paulus ya'ag obebe taneogna kwanengap magap tukap. Kom tanena Allahri nu opsinep,' aro salag pibangdi, yubu karebangdi wamang. Sindi 'Nen payalulam,' aro maneri mome toro toatsinne sembe molbagha nuagheang, wenena andi yubu lenne sembe agha nang-nangaro wamang,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Wene aro ambarogpa, yin saleropne sikindo ponekori menekoag, “'Elag yubu undo ambatna,' aro nimiag ambatsiseng kom,” seogti, “Anenge aeag pululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Meneko elenge aeag piogpa, yin saleropne sikindo ponekori ilipsabo yin salerop nang phende yopsiogti ambarelamsiogti, “Yin salerop nang teng linbare saog nimiap (200), yin salerop nang pham kuda alibag pan nang teng wilindi saog nimiap (70), yin salerop nang kame lausiki saleropnang teng linbare saog nimiap (200) poloro webitsululam. Webitsimenba, heng purukaleba, olog inibin tanaleba, Paulus as ane agha poa lepmundi, as Kaisarea poa pululom. ");
INSERT INTO kkl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Keledai Paulus alibag walenne babe webitmendi, poa mog so'o ane saleropne Feliks ya'aghag wali uro Kaisarea poa pululom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yin saleropne sikindo ponekori, mog so'o saleropne Feliks sembe mome tobogne lilimna ane: ");
INSERT INTO kkl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Na Klaudius Lisiasti nani nubunge walinge Feliks aro kiplangken. ");
INSERT INTO kkl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nimi ene Yahudi nimiri saelbaongdi, sindi 'Obukap,' aro ulamang. Aghana nimiri, 'Nimi ene Romange,' seongba, ka'ebanori na naipsaboapti Yahudi nimiri saeag agha taluro tomno. ");
INSERT INTO kkl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Taluro tobobori, 'Sa'a sembe lelamang tam kembaukap,' aro Yahudi nimi sembe tam lelekto kemero kareptop nimi Mahkamah Agama nimiag poa pibo. ");
INSERT INTO kkl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Poa piboba, eldi tam malia unneap sunsunum uro, tam elag 'Tebalul,' aro tininneap, kop aeag tolongonneap sunsunum uptao kom. Sindi elag tam yo'o saog nembaongnena, 'Musa yubu samenag mome toro piropne philamla,' aro undo agha lebong. ");
INSERT INTO kkl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Apna na yubu ka'ebanonge, 'Yahudi nimiri, “El obukap,” aro yubu lelamang,' seongba ka'ebano. Ane sembe nari 'Elemag nai anag poa pululom,' sen. Sendina tam elag yubu lelamang nangagna, 'Tam a'undi lelamlomne poa elag poa pululom,' sen anekona an babe el uro,” aro mome pibog. ");
INSERT INTO kkl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mome undo pibogpa, sikindo yin saleropneri ambatsiogha sunsunum uro inipnag Paulus poa as Antipatris poa piek. ");
INSERT INTO kkl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kwelekaogpa lukunapne yin salerop nangap, kame lausiki salerop nangap aeag samoro Yerusalem yaekpa, yin salerop nang agha pham kuda alibag pan nang tanekori Paulus poa sin Kaisarea sip palamek. ");
INSERT INTO kkl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","As Kaisarea aneko piekti, sikindori mome pibogap, Paulusap mog so'o Kaisarea saelba uropne Feliks ponekoag tarek. ");
INSERT INTO kkl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mome tareka aneko kembaogti, Feliksti Paulusag, “Anna talange,” aro haibaog. Wene aro haibaogpa, Paulustina, “Na Kilikiange,” seogpa eltaogti, ");
INSERT INTO kkl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Feliks ponekori, “Tam anag pibong nimi taneko yaik tanena tam anag pipkeongne kembaukap,” seogti, “Nimi nubunge yubu sia leropne Herodesti samenag sobaog aeag piapmundi, yae wamlulom,” aro ilipsaboag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ik lambare wameka memne Allah sembe pairopnang sikini nubunge sina Ananiasap, Yahudi nimi sikindoyabo wenehiropnangapti sindi, “Yubu tam Paulusag pibebenge sembe lelekto mog so'o wamabag saelba uropne ambatsilul,” aro nimi nhon sina Tertulus webekti, sin nhon piek. Piekti, “Paulusag tam wamla,” aro “Mog so'o saelba uropne Feliks ambarukap,” aro as Kaisarea piek. ");
INSERT INTO kkl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Sin poloro wamekag Feliks ponekori el umag wameknangag, “Paulus payalulom,” seogpa payaek. Payaekpa, Tertulus neneko sekelabiogti, Yahudi nimiri Paulusag tam palilamekne sembe ambarelamsiogti, “Nani nubunge Feliks, an wamlamagna nununge mog so'o ene aingniamla. An wana hektopne wamlamdi, yubu lelamlamdi, mog so'o nununge tane wali uro o'obarelamsilamba, wali uro palamla. ");
INSERT INTO kkl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nani andi uaomne nu niri sop-sop ililamapti, salelamapti 'Wah, Feliks, Nani,' aro kiplangkeap. ");
INSERT INTO kkl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","An nimi nubunge tam maikno kemelamlamdi, ulamlamne na el wamna, ane sembe nani, 'Andi wana pailangkalapmendi, nari yubu olog lemnunne nene sembe ka'eame,' aro mololangken. ");
INSERT INTO kkl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nimi ene meneng singina salehiropne saog wamlaba, as mog so'o ni abeneko posaplamlaba, ililamap. Yahudi nimi as tala-tala wamangne eldi aghabog put-put ana tolongolamla. Nimi ene ekel ina ambatto Nasaretne yubu ka'elamang nimi sembe usog talamla. ");
INSERT INTO kkl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Abeneog kom, aghana Allahri Mem Ae walinge eldi, 'Yahudi sisa kom nimi pabhineri, Yahudinang aghabog wamnebag tobongkipsineri, Allahri Ae Mem Ae loba nembanun,' aro ulamo. Undo ulamoba, kembabori, nuri 'Musa yubu saelba ulamapne sunsunum uro tam karebaukap,' aro Paulus saelbabo. ");
INSERT INTO kkl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Wene sembabori, Paulus saelbabo aghana yin saleropnang sikindo Lisias neneko yaori, nu saeag agha yo uro nimi ene tolao. ");
INSERT INTO kkl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nimi ene pelepto tobori, nunag ambarelamsiori, 'Mog so'o salehiropne Feliksti tam kembalulba, elag pululom,' aro ambatsioba yaap. Nai andi haibamendi, nuri lebapne sembe 'Sik uro lebang,' aro el talulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wene aro ambarogpa, Yahudi nimi taneko wamek nimiri babe “Sik lepla,” aro wene alamek. ");
INSERT INTO kkl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wene alamekpa, mog so'o Kaisarea saleropne Feliks ponekori Paulusag, “Andi babe yubu leplulam,” aro haing tibu nginikom seog. Haing tibu nginikom seogpa Paulusti, “Nani, na el wamnange, andi Yahudi nimi mog so'o eneag wamapne heng kun-kunne saelbamsilamdi, nuri ul palamapne sembe el ua ulamlamdi, tam kemero kareplamlamne na el wamna. Ane sembe na wana yeng wamnelne nanag tam palilamangne nene, nani, andi 'Kembaho,' sembamna. ");
INSERT INTO kkl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nani, andi nimiag haibahimenba, sindi lebikne agha el talulam. Na as Yerusalem, 'Allah omekel pinun,' aro pinori wamnoba, ik ao bare sum taoba, wene wamap. ");
INSERT INTO kkl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na Yerusalem wamnonge aneko Allahri Aeag babe, Allah yubu lerop aeag babe, inaag nimi ua urobag babe yabalamnari, nimi nhonap babe yubu wabahin koma nimiag 'Yubu talul,' aro suknunne babe orog. ");
INSERT INTO kkl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Sindi babe, 'Tamna nene sembe lelamap,' alamang aghana, 'Malia uao,' senenne kekneba uanonge nhon anag lag nembanep kom saog wamla. ");
INSERT INTO kkl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nani, na an whingag agha lag phoro lemnun. Nari omeklamnange nunisari Allah omeklamekne poneko omeklamnari, Yesusti Allahag samoro yingkirop Ina pa'abaogne poneko omeklamna. Ina pa'abaogne poneko omeklamnange, 'Ekel ina ambarelamsilne,' alamang aghana, Musari samenag mome toro pibog yubuap, Allahri yubu silimu tiplamek nimiri mome toro pibek yubuap 'Sik' senelamna. ");
INSERT INTO kkl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","'Nimi malia uropne walia uropne Allahri kamag nembahilul,' aro nari babe seneraglamnari, wana piamnange nang-nangaro wamna. Nang-nang aro wamna saog uro 'Allahri nimi kamag nembahilul,' aro sindi babe nang-nangaro wana piamang. ");
INSERT INTO kkl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nimi malia uropne walia uropne Allahri kamag nembahilul ane sembe Allah whingag babe, nimi whingag babe wanaag agha nia mangkina ulamnange 'Walinge aghabog uahane,' senelamna. Undo unulamnange sembe 'Malinge ulamna,' seneldalamna kom. ");
INSERT INTO kkl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nangkabo urobag heng kun-kunne uldongolamneldoba, sindi wanari, 'Nungkabo Yahudi nimi sae agha orog nimiag yepsukap,' aro tatneongba, as Yerusalem payano. As Yerusalem yan komag agha, 'Allah sembe mhong towalengerobag wali-walia pimnun,' sembanori, 'Yahudi nimi as Yerusalem wamangne yepsinepne tarel phinun,' aro as Yerusalem samoro yanori payano. ");
INSERT INTO kkl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Yanori, 'Allah whingag wali neneptanun,' aro Musari samenag mome toro pibogne sunsunum uro aleltalamnori, wamnoa Allahri aeag wa'ino. Wa'inori, unulamnoagna nimi suknubahin koma wamnori, nimi maikno nanap nhon wamobo kom. Nari yubu suknuna nimiag suknunne babe orog aghana, Yahudi nimi mog so'o Asia agha yaong nimi tanekori imneong. Sin Asia nangdi nari samen uldongolamnoag agha yaongdi, imneongdi, tam nembaong. Yahudi nimi Asia so'o agha nimiri tam nembaong nimi eneko yahengdi, nani an whingag lepseng tanena wali. ");
INSERT INTO kkl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yahudi nimi Asia so'o agha nimi taneko yaong komba, yaang nimi taneri samenag nu Yahudi nimi sembe tam lelekto kemero kareptobag Mahkamah Agama enero poa pineong. Mahkamah Agama enero poa pineongba, wene tamna nene sembe payaneang sembano kom aghana nen sap wene ane payaneang. Malinge uanonge sembe sindi wene ambatkukang sembamna. ");
INSERT INTO kkl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Na Yahudi nimi sembe tam lelekto kemero kareptop nimi whingag Mahkamah Agama pabineongpa, yubu kiki leploa saogne lemnongena: '”Nimi teptopne kamag taukang,” senonge sembe tane pukitnelom,' senonge sembe na yubu tam nembaneong, to?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Wene aro Paulusti ambarogpa, Feliks poneko Yesusti yubu ina neleptop nimi sembe el uro wamog aghana, “Amik karebanun,” sembamog. Undo sembamogti, “Yin saleropnang sikindo Lisias yaleri, yubu ambatnelenge ka'ebaneri, tam nene karebanun,” aro wene seogti pibog. ");
INSERT INTO kkl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wene seogti, yin salerop nang sikindo ponekoag, “Paulus wali uro piapmendi, elkabori yebel alamikne sembe yag lambahiseng kom,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ik etbare wameka Feliksap elkel Drusila Yahudi kelenekoap yaekpa, Feliksti, “Paulus tol pululom,” seogpa, payaekpa, Paulusti Yesus Allahri wepto poghol aogne ponekoag “Sikne” aro seneragnepne sembe Feliks lelekto ambarelamogpa, Feliksti aoag agha ka'eloamog. ");
INSERT INTO kkl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ka'elobongkia wamogpa, Paulusti Allah yubu tibin nenero porog uro ulpanneap, eldamneri wana pailangkanneap, Allahri amik tam karebelalulneap sembe Feliks ambarogpa, Feliks poneko log sembaogti, “Ot abene ambatnelamba pululam. Nen 'Ambatnelul,' sembane tanena yopkunun,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks poneko wanaag seneraglamognena, “Kal ma'al tatneleba, sae loplambanun,” sembamogti, ik sulu Paulus yoplamogpa, yubu lelamdek. ");
INSERT INTO kkl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paulus aneko piamogne heng kun phende piogpa, Feliks lunumna sina Perkius Festus waelbaog. Aghana Feliksti “Yahudi nimi wana topsunun,” aro “Paulus kop aeag aneko wamlul,” sembamog. ");
INSERT INTO kkl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus poneko “Yudea so'o saelbamlulam,” aro nimi nubunge towalengkaogpa, as Kaisarea ae inipna ik wilindi wamogha as enekoag agha Yerusalem waelbaog. ");
INSERT INTO kkl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Yerusalem waelbaogti, wamog. Wamogpa, memnang Allah sembe pairopnang sikindo yaboap, Yahudi nimi sikini yaboapti tognoro saekag lelamekti, “Festus whingag piberi, 'Paulus Yerusalem poa pululom,' aro molbaukap. Molbabeba, Paulus inaag payalamikpa, Paulus obukap,” aro saekag lebek. Undo tognoro saekag lebekti, Festus poneko whingag piekti, “Paulusti undo-undo ulamo. Ane sembe nai Festus, andi nu sembe wali sembahimen tanena, 'Paulus as Yerusalem poa pululom,' sululam,” aro molbaek. ");
INSERT INTO kkl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","“Obukap,” aro tognoro saekag lebekti, Festus ponekoag, “Paulus as Yerusalem pabululam,” aro molbaek aghana Festus nenekori, “Paulus as Kaisarea kop aeag wamlaag wamlul. Wamleba, na babe olog wamnea as Kaisarea samoro punun sembamna. ");
INSERT INTO kkl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","A'un a'uni yabo 'Eldi uaonge sembe elag tam pibukap,' sembamun tanena nanap nhon as Kaisarea piberi, elag tam piplulom. Elag tam pimnepne wamle tanena, lelekto kembaberi, 'Malia uao to, kom to?' aro karebanun,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Undo wene seogti, Festus neneko ik linbarero ik saobarero undo as Yerusalem wamogha samoro Kaisarea kulukulaog. Wamogha lukunapne, “Yubu tam lelekto kembaberi, tam karebanundi, Paulus enel pululom,” aro ilipsabo ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulus sin poloro wamekag enero payaekpa, Yahudi nimi Yerusalema yaek nimi taneko el kanero sekek. Paulus kanero sekekti, yubu maikno lelamekti, “Malia undo-undo ulamo,” aro lolorop yubu lelamek aghana, “Malia uaonge undo-undo ulamo,” alamekne tiplamog komdi, nimiri sik sembanep kom saog wamog. ");
INSERT INTO kkl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wene alamekne tiplamog komdi, sik sembanep saog kom wamogpa, Paulusti, “Nandamne sembe peleptangtop yubu lemnun,” aro sekelingkiog. Sekelingkiogti, yubu lelamogti, “Nari ulamnangena, Musari samenag mome toro pibog yubu Yahudi nimiri salero ul palamang yubu phibano kom. Allahri Ae sembe babe, yubu sia leropne nubunge Kaisarag babe, nari tam malia unne babe san lenne babe orog senelamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Wene seogpa, Festus ponekori, “Yahudi nimi wana topsunun,” aro Paulusag hailamogti, “'Tam ane as Yerusalema karebaukapti, pukap,' senne sembe saekag senelamlam, te?” aro haibaog. ");
INSERT INTO kkl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Wene aro haibaogpa, Paulusti, “Samenag yubu sia leropne nubunge Kaisardi anag, 'Yudea so'oag pimendi, saelbamsululam,' aro sekitkeo. Sekitkeoba, an whingag tane wamnari, tanea babe andi tam karebanep. Nari ologha babe Yahudi nimiag tam malinge uan komne nai an el wamlam. ");
INSERT INTO kkl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nari sik uro malia uahi tanena, malia uahinge sunsunum uro opnumunba, wali tebanun. Aghana tam nanag palilamangne orolenange lelamangdi, lolorop yubu lelamang tanena, nimi nhondi babe sin Yahudi nimi saeag nembanukang kom. Na Kaisar whingag waelbaneba, Kaisarti tam karebalul,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Wene seogpa, Festus poneko el yubu eptopnangap yubu nikne lebekti, Paulusag ambarelamogti, “'Kaisarag waelbanun,' selamba, elag pimenba, Kaisarti tam kemero karebalul,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ae ik etpare wamekpa, nimi nubunge yubu sia leropne Agripaap, ilipsa'el Bernikeap abeneko “As Kaisarea Festus poneko kipnunam,” aro yarek. ");
INSERT INTO kkl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aneko sin ik etbare undo wamekti, Festus nenekori Paulusag tam pibekne sembe yubu sia leropne Agripa ambarelamogti, “Nimi sae kauptopne nhon Feliks saelbamsiog liag agha Yahudi nimiri tam 'Eldi malia ual,' aro salero Feliks whingag pabiekpa, sae kaupto kop aeag tobongkibog. Kop aeag tobongkibogti, tam kareban komdi, wene babe kop aeag wamla. ");
INSERT INTO kkl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kop aeag wamlange ponekona, na Yerusalem pinoba, memnang Allah sembe pairopnang sikindo yaboap, Yahudi nimi sikindoyabo wenehiropnangapti, tam malia uamonge ambatneongdi, 'Malia ualne sembe “Opsut,” sululam,' aro molbaneong. ");
INSERT INTO kkl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Wene aro molbaneongba, nari ambarelamsinori, 'Yubu sia leropne nubunge Kaisardi ambarelamsiogne sunsunum uro salero ul palamapnena, nimi nhondi nimi nhonag tam palilamle tanena, tam elbina malia uropne poneko haiban koma nimiri tam karebanep saog wamla kom. Tam tangtopneap tam paliropneap nikag wamnaba, tam anabiag wamnari kemeropneri malia uropne poneko haibanep. Haibanba, tam tangtopneri eldamne sembe pelebeltanan yubu tibin talbin tanena, tam lelekto kemero kareptop nimiri, “Ualne sembe undo uaukap,” aro karebaleba, eldi yubu sunsunum uro tam tangtopneag uro yabilul,' aro wene seo. ");
INSERT INTO kkl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Wene aro ambatsinoba, sinap nu nhon as Kaisarea tane yabori, maboboa kwelekaonge 'Ta'ap sen koma yubu tam lelekto kembaberi karebaukap,' aro 'El neneko enel pululom,' seno. ");
INSERT INTO kkl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Elag tam palirop nimi taneko kanero sekamongdi, 'Eldi malia uaonge “Undo-undo uao,” aro lag phoro lebukang,' sembano. '”Undo-undo uao,” aro lebukang,' sembano aghana, nimi nhondi babe, 'Eldi malia uaonge ane,' aro lebongne, nari samenag sembanonge sunsunum uro lebong kom. ");
INSERT INTO kkl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","'”Tam ikinne ane,” aro lebukang,' sembanonge sunsunum uro lebong kom aghana, ot sindi omeklamongne sembe aghabog tam nembaongdi, yubu lelamong. Apna, nimi nhon samenag tebaogne si Yesus sembe Paulusti, 'El sik uro kamag taogti, wamla,' aro ambatsionge sembe yubu tam saog tao. ");
INSERT INTO kkl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sin undo yubu lelamongba, nari 'Yubu tam ane sembe lelamang,' aro karebelbana, enhaun seo. Ane sembe nari Paulusag hailamnori, 'An Yerusalem pimenba, Yahudi nimi ua urobag tam ane karebanundi, wali sembalam te?' aro haibano. ");
INSERT INTO kkl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wene aro haibanoba, Paulustina, '”Kaisarti tamna karebalul,” aro Kaisar nang-nang aro kop aeag ane wamnun,' seo. Ane wene seoba, nari 'Kaisarag pognun,' aro kop aeag piamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Wene seogpa, Agripa nenekori Festusag, “Nari babe, 'Nimi neneko eldamneri yubu lelamsoa ka'ebahane,' sembamna,” seogpa, Festus nenekori, “Ambhum el yubu leplenge ka'ebalulam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wene seogpa, mabeka lukunapne Agripaap ilipsa'el Bernikeap nimi nubu nimiri towalengeroba towalengkibtekpa, yin salerop nang sikini yaboap, as eneko wamek nimi sikini yaboap wa'alamek. Wa'iekpa, Festus ponekori, “Paulus tol pululom,” aro nimi arukahiog. ");
INSERT INTO kkl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Paulus tolpina payaekpa, Festus nenekori yubu lelamogti, “Yubu sia leropne Agripa nuniap, nimi ni tane yalomne nangkabo! Yahudi nimi ni taneko Yerusalem wamangneap, Yahudi nimi kota Kaisarea tane wamangneapti, nimi pone sembe 'Malia ulamo,' aro yubu maikno lelamong. Yahudi nimiri nanag yingkina koloro, 'Nimi ene ik waro wamlul kom, tebalul,' aro haum alamong. ");
INSERT INTO kkl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Undo wene alamong aghana, nari kembanori tam uaonge sunsunum uro tam elag palina babe orog uao. Ya'ag onna babe orog uaoba, eldamneri 'Kaisarti tam karebalul,' seoba, nari, 'Kaisar ya'aghag kota Roma pabiikpa, Kaisar whingag pulul,' aro yubu lemno. ");
INSERT INTO kkl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","27","Yubu lemno aneko agha 'Eldi tam malia uaonge Kaisarti kemero karebalul,' aro mome toro palina tam orog kembano. Na el wamnange, nimi nhondi malia uropne tam kembanba, 'Eldi uaonge tam nene sembe uao,' aro mome toro palinne oroghag agha, 'Kaisarti kembalul,' aro elag pognep kom sembamna. Ane sembe a'un ni wamlomne whingag el pailan. Nuni yubu sia leropne Agripa, an babe Yahudi nimiri omekto ul palamangne elne wamlam. Tam eldi uaonge kembabeba, tam wamleba, ibebe tanena, eldi uaonge sembe nari mome tomneri, Kaisarag pognun,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Wene aro ambatsiogpa, Agripa ponekori Paulusag, “Wene andi ulamlamne sembe pelebel tanan yubu leplulam,” seogpa, Paulusti, sae la'abatsiogti, yubu lelamogti, ");
INSERT INTO kkl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Yubu sia leropne Agripa nani, Yahudi nimiri lolorop yubu nanag lolbaneongne sembe sumene an whingag agha pelebel tanan yubu lag phoro lemnunne sembe awi yeng uro wamna. ");
INSERT INTO kkl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Yahudi nimiri sikinisari ulamekne saelba ulamangneap, tam sin anabiag lag taongeap ni ane sembe an el wamlam. An el wamlamba, nari ambatkinunne andi wana palingkina wali ka'eamnululamba, mololangken. ");
INSERT INTO kkl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Na nari asag agha mangkaneekpa, na kaubuniag agha Yahudi nimiri saelba ulamekti, ulamekne ambaneek. Ambaneekpa, as Yerusalem ane babe yahiba, nen anea ma'aro ambaneek. Ambaneekpa, na yabalamsiri, ulamsia Yahudi nimi as Yerusalem wamekneri imneekne sin el wamang. ");
INSERT INTO kkl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Sin samenag agha na sembe sin ni el wamang. Sindi agha, na Farisinge wamsiri, Musari yubu toro pibogne sembe mikip uro saelbamsiri, yubu ane sunsunum uro ul palamsinge 'Hae lebukap,' sembaik, tanena ambarelamsinne sembe 'Sik lepla,' aro lebukang. ");
INSERT INTO kkl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na wene ane sekamnangena, 'Allahri nunisa yaboag “Undo uanun,” aro salag pibogne sunsunum uro sik talul,' senelamnari, nang-nang aro ulamna. 'Allahri, “Uanun,” seogne sik talul,' aro nang-nang aro ulamnange sembe nimiri saelbaneongdi, wene ane tam kareptop nang whingag payaneongba, sekamna. ");
INSERT INTO kkl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nu Yahudinang sisa aobare wamapne nene, 'Allahri samenag salag pibogne sunsunum uro sik talul,' aro nu niri sinag kweleknag sol wali, wali uro Allah omeklamekne saog uro nu babe nang-nang aro omeklamap. Nani Agripa, undo seneraglamekti, ulamekne sunsunum uro ulamnonge sembe Yahudi nimiri nanag, 'Tam malinge ulamlam,' alamangpa, na wene pelebeltanan yubu ambarelangken. ");
INSERT INTO kkl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nangkabo, sa'a sembe a'undina, 'Allahri nimi teptopne kamag nembanep kom,' aro seneraglamlom? ");
INSERT INTO kkl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Samenag nari babe '”Yesus Nasaretne si nubu taleag,” aro yo uro ulamsinun,' senelamsi. ");
INSERT INTO kkl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Lemnange nene Yerusalema unulamsisi. Memnang Allah sembe pairopnang sikindo yabo tanekori, 'Nuri sae wamla,' aro yubu nanag pibekpa, nimi Yesusag 'Sikne' aro seneragtop nimi maikno haing sae kaupto kop aeag tobonglamsisi. Kop aeag tobongolamsisiri, 'Ya'ag tepnange babe wali tebaik,' aro yubu lepsiri, Yahudi nimi nubunangap saekag lebubuag agha, Yesusag seneraglemek nimi ya'ag opsiek. ");
INSERT INTO kkl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yahudi nimiri Allah yubu lerop ae nhonag pang nhonag pang ulamsisiri, 'Yesusag seneraglamangne sembe opsukap,' aro sen-senna elamsisi. Elamsisiri, ililamsisiri, 'Yesus san tiliplopsisut,' aro ambarelamsisi. Yo maikno senelamsisiri, kota maikno weag wamekag babe el palamsisiri, 'Seklebaukang,' aro ul palamsisi,” aro Paulusti nimi nubunge Agripa whingag ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Paulusti nen tipto ambarelamsiogti, “Undo unulamsiba, memnang Allah sembe pairopnang sikindo yabo tanekori, 'Nuri sae wapmendi, as Damsyik pimendi, undo-undo ualulam,' aro ambatneekpa, 'As Damsyik punun,' aro palamsi. ");
INSERT INTO kkl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nani Agripa, yubu sia lelamlamne, inaag palamsiba ae siro heng ik molmol alamog abene heng tingirop saog komne tibin warerop sirikne imag agha nanap nangkabo palamubu nangag warelopsiog. ");
INSERT INTO kkl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Warelamsiog abeneko nangkaboap nu so'oag malingkiburi, ka'elamsiba yubu nhon Ibrani yubuag lelamogti, 'Saulus, Saulus sa'a sembe “Seklebale,” aro Na ulamnelam? Eldi yagto pabalangkelne pheleptangka pululam kom. Pheleptangka palapmen tanena og seklebalulam,' alamogpa ka'ebahi. ");
INSERT INTO kkl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Wene alamogpa ka'ebahairi narina, 'Nai, an etneri lelamlam?' sihiba, Eldina, 'Na Yesus andi “Seklebale,” aro ulamnelamne ponekori lelamna,' alamogha ka'ebahi. ");
INSERT INTO kkl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Eldina, 'Wene pukmendi, sekelabi. An “Na arukna wapmendi, wene imnelamneap amik Nari 'Ualulam,' sununneap nimi ambarelamsululam,” aro Nari sekitkunundi, an haingag lag tan. ");
INSERT INTO kkl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nari an poglangkenne, “Yahudi nimiap, Yahudi sisa kom nimi as tala-tala wamang nimiap babe sin wamangag pululam,” aro poglangken. Poglangkenne saelbaghiikpa, Yahudi nimiri saeag agha babe, Yahudi sisa kom nimi mog so'o as tala-tala nimiri saeag agha babe, Nari sae lopkenun. ");
INSERT INTO kkl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Poglangkenba, sin wamangag pimendi, sin nimi taneko haing uropne haing kwelekel palamsululam. Haing kweleklamsimenba, inibinag lilobiagha samoro tibinag yalamukang. “Haing kwelekamikti, phia sikini nubunge Iblis ponekori saeag agha sae loptangom agha Allahag samoro yalamikpa, Allahri saelbamsukang,” aro poglangken. “Sindam nimiri Na Yesusag 'Sikne' aro seneraglamik tanena, Allahri 'Naringe aghabog wamukang,' aro wepsirop nimi sembe sindi malia ulamangne tam orog nembaleba, Allah Eldamne mabo taukang,” aro poglangken,' aro Yesusti ambatneo. ");
INSERT INTO kkl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ane sembe, nani Agripa, yubu sia lelamlamne, Yesus imagne ponekori kekneba nanag uaori, yubu ambatneonge sunsunum uro ul palamno. ");
INSERT INTO kkl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","As Damsyika nimi Yahudi nimi wamekneag agha alnina alnibahiri, kota Yerusalem nimiap, Yudea so'oag urop nimiap, Yahudi nimiap babe, Yahudi sisa kom nimi babe Allah yubu ambarelamsisi. Sinag ambarelamsisiri, 'Malinge ulamlomne lilobiagha Allahag samoro yamundi, Allah Elag wanaag seneraglapmundi, Allahri “Walinge,” seneropne aghabog ulamlulom. Allahri “Walinge” seneropne aghabog undo unulapmunba, nimiri “Malinge ulamangne lilobiagha Allah Elmabo taang,” aro el tanep,' aro ambarelamsisi. ");
INSERT INTO kkl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Undo wene aro ambarelamsisinge sembe Yahudi nimiri Allahri Ae aramag agha saelbaneekti, “Ya'ag obukap,” aro uaneek. ");
INSERT INTO kkl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Undo “Obukap,” aro uaneek aghana, Allahri samenag agha yeplamneoa wene babe piamnelba, wamna. Wamnari wene ane sekamnari, nari haingdi ipsinge nimi ologne nubunge ambarelamsin. Nari ambarelamsinnena, samen Allahri yubu silimu tiplamek nangdi lebekne mome toro pibekneapna Musa yubuap agha ambarelamsin. Yogne agha ambarelamsin kom. ");
INSERT INTO kkl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Samenag Musaap Allah yubu silimu tiplamek nangapti ambarelamsiekne nenena, 'Allahri “Mog so'oag nimi taulbahilulam,” aro wepto poghol aogne poneko seklero tebaleba, Allahri nimi teptopne ua urobag agha El samenag kamag nembalul. Kamag nembaleba, elkabo Yahudi nimi elap nikag wamangne babe, Yahudi sisa kom nimi babe, “Allahri Na pere agha taulbahilul,” aro wepto poghol aogne ponekori tibin nenero ambarelamsilul,' aro ambarelamsiekpa, nen tipto ambarelamsin,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulusti, “Undo-undo ulamsi,” aro pelebeltanan yubu ambarelamsiog abeneko, Festus ponekori yubu mikip uro lelamogti, “Paulus, an serem ulangkelba, lelamlam. 'Nia mangkina el tahane,' aro el talamlam aghana senaragna maiknori serem ulamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Wene seogpa, Paulusti samoro, “Na serem saelbanelba, lelamna kom. Festus nani walinge, na seneragna walinge sikne agha lelamna. ");
INSERT INTO kkl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nani Agripa, yubu sia lelamlamne, lelamnange tane an babe el wamlam. El wamlam ane sembe na log kom uro, nani, an whingag lag phoro lelamna. Na el wamnange ni lemnange tane, nani, an ekonne nhon lemna kom. Lemnange uro yabionge agha lemna. Nen tognorobag agha uro yabiogne agha lemna kom. ");
INSERT INTO kkl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nani Agripa, yubu sia lelamlamne, samen Allahri yubu silimu tiplamek nangdi lebekne sembe sik senelamlam, te? Na elwamnange, nani, andi babe sik senelamlam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Wene seogpa Agripari, “Andi senelamlamne, 'Wene abene, nari olog yubu lemnange ka'ebiagha Kristen nimi talul,' senelamlam, te?” seog. ");
INSERT INTO kkl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Wene seogpa Paulusti, “Na Allahag molona molbanun, wene babe to, olog wamebeba babe to, an aghabog kom. Anap ane nimi wamang nimiap sembe, 'Nari yubu ka'ebaneang nimi tane na saog taukang. Na saog taikpa, nimi tanena haing sae kaupto pipsiseng kom,' aro Allahag mololamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Wene aro Paulusti ambatsiogpa, nimi nubunge yubu sia leropne Agripaap, ilipsa'el Bernikeap, wamekag mog so'o saleropne Festusap, nimi ni sinap pukamekne tanekoap sekekti, ");
INSERT INTO kkl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","lanalamekti sin mo-mo yubu leple palamekti, “Nimi ene uaoa sunsunum uro kop aeag tolongoro babe, ya'ag onne babe, tamna orog wamla,” aba palamek. ");
INSERT INTO kkl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Wene aba palamekpa, Agripa ponekori Festusag ambarelamogti, “Nimi eneri 'Kaisarag pinun,' sele kom tanena kop aeag agha sae lopto lambitsebe. Aghana, eldamneri 'Kaisarag punun,' seo ane sembe Kaisarag pabukap,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","“Kaisar ya'aghag mog so'o Italia sip pululom,” aro wene Festusti seogti, Paulusap nimi yogne haing sae kaupto wamekne tanekoap Kaisar arukna yin saleropne nhon sina Yulius neneko saeag nembaog. El saeag nembahiogti, “Andi poa phululam,” aro ambarog. ");
INSERT INTO kkl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ambarekpa kabong nhon as Adramitium agha yaogne neneko “As Asia so'oag mag longorop mag laut abolag soropne tanekoag nhonag wa'albang, nhonag wa'albang uanun,” aro ulamogne nenekoag wa'iburi pibu. Aristarkhus so'o Makedoniange ponekori aeag as Tesalonika agha yaogne ponekoap nhon pibu. ");
INSERT INTO kkl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mabubua kwelekaogpa, as Sidon saingnilingkibu. Saingnilingkiburi, yin saleropne Yulius ponekori Paulus o'ona sembaogti, “Ankaboag andi kwema sembamlama tatkukang bana kemeroa yabhululam,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","As Sidon aneko laplobiagha mag alip toman agha palamububa, khao nu kabong palamubua whingag siba yalamogha sembe mag longorop mag laut kanero longorobag mog so'o Siprus khao maruktobag sip pibu. ");
INSERT INTO kkl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Siprus so'oag anekoa mag alip toman aghabog palamubua, mog so'o Kilikia sirik sip mag longorop mag laut abol toman agha palamubu. Nen tipto palamuburi, mog so'o Pamfilia sirik sip mag longorop mag laut abol toman agha laploplo as Mira Likia so'oag saingnilingkibu. ");
INSERT INTO kkl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","As enekoag agha yin saleropne poamsiogne ponekori kabong nhon as Aleksandria agha yaog kabong eneko “Mog so'o Italia punun,” aro ulamogha ibog. Ibogti yalamubu kabong enekoag agha laplobiagha “Mog so'o Italia punun,” aro ulamog kabong enekoag enero poa tobongkipsiog. ");
INSERT INTO kkl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tobongkipsiogpa mag alip toman palamububa, khao kabong whingag siba yalamogti, yalamubuag sip ko'oro poa phinep ulamogne nenekori kabong alibag ik etbarero undo mabuburi, eraruk uro as Knidus peramag pibu. Khaori kabongag wamubunge “Pukap” senenag ko'oro pabhinep kom ane sembe Kreta khao maruktobag sip inagha yim Salmone amusogti lilirobag khao aingnirobag sip pibu. ");
INSERT INTO kkl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Opsinep saog ulamogpa nemen-nemen eraruk uro yim Salmone amusoghag anekoa mag alip toman palamuburi, kabong nenne babe saingnil pirobag as Lasea peramag “Saingnil Piroba Walinge” si engeropne nenekoag saingnil pibu. ");
INSERT INTO kkl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Undo palamububa, “Italia sumene saingnilbukap,” sembabu sum eneko phibaogpa, Israel nimiri nubu sum kwaneng terop kom sum eneko uro libek. Undo libekpa, khao li taogne sembe “Magti yamoro tapsileag,” aro Paulusti yubu ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Nangkabo, nari kembanba, nu ina panne eraruk ulamlaba, iamnarina pukap kom. Kabongag poamaba babe, kabong babe, nu nimi ane babe opsinep iamna,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Wene seog aghana, yin saleropne ponekori Paulusti lebogne sembe sik sembaog komdi, kabong ngaingeap, kabong u o'oropneapti leptekne agha sik sembaog. ");
INSERT INTO kkl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kabong saingnilingkirobag ane, “Khao li wamnual,” aro kabong saingnia unne eraruk wamog. Mag kanero longorop so'o Kreta so'oag as nhon sina Feniks wamogpa, kabong saingnirobag heng pulingkirobag sip tibogto, waneng sip babe, sirik sip babe tibogtobag wamogpa, “Khaori opsinep komag aingnirobag wamla,” sembaek. Ane sembe kabong porop nang tanekori, “Anea lambaberi, khao li wamlange nene as Feniks pina wamukap,” aro wene seek aghana nen nimi nhon-nhon nimiri saekag lebek kom. ");
INSERT INTO kkl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","“Lambaukap,” aro wamek abeneko phoana nemenag yangaro-yangaro mag longorop mag laut siba mog so'oag sip yalamog. Mag longorop mag laut sip agha phoana yangaro-yangaro yalamogpa, “Hae phoana aneri Feniks asag pabil philul,” sembaekti, “Kabong saelbamlul,” aro kirik simbuk saogha maghag pelengeroba aneko toro kabongag towalengkaekti, ag kabongag kerekaekpa, “Phoanari kabong ko'oro pabalamlul,” aro kerektop ag towalengkaekti, mog so'o Kreta mag abol peram toman kabongag palamap. ");
INSERT INTO kkl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Olog palamekpa, khao nubunge Krete so'oag ople siba mag longorop mag laut simbik pabirop khao yalamog. ");
INSERT INTO kkl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yalamogti nu palamubu kabong enekoag sibil alamog. Khao yalamogne neneko mikipti, “Mog so'o Krete mag abol toman palamukap,” aro ulamubu aghana, kabong aneko panne eraruk wamogpa, kabong aneko babe khao palamoghag sip mikip taog. “Elba eldi ualea,” aro pulobububa, mag longorop mag laut sip pabalamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pabalamsiogti mag longo kanektobag as Kauda aneko maruktobag sip aneko pilphiogpa, eraruk uro kabong nubunge pomaghag sip kerektop kabong ologne haing kerekto kiliro toro pibubu. ");
INSERT INTO kkl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kabong ologne neneko kiliro towalengkaburi, nu pabalamsiog kabong aneko magti sibilalamleba, “Taongkaleag,” aro haing mikipne agha nu pabalamsiog kabong aneko wan-wanoro kaubek. Kaubekti, “Khaori mag longorop mag laut ingkisag Sirtis kirik a'angkeag meldal paphileag,” aro log senelamek. Log senelamekti, ag kabongag kerekaekne, “Phoanari ko'oro pabalamlul,” aro kerektop ag wamogne togto pibekpa, kabong aneko khao palamog ina nemen palamog. ");
INSERT INTO kkl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mabubua kwelekaogne neneko khao aneko olog paplamog komdi, opsinep ulamogpa, kabongag ikinne poameka taneko maghag talamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mabubua ik wilindip sumeneko kabongag soroba taneko sinba kabong porop nimi tanekori maghag talamek. ");
INSERT INTO kkl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Khao anekori unulamogpa, kabongag palamubunge nene heng babe imbrea babe olog ililamubu kom. Undo palamubua ik etpare imbrea babe heng babe ililamubu komdi, khao anekori sibil alamogpa, “Ot tebaukap aneog,” seneragamubu. ");
INSERT INTO kkl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nimi taneko ik maikno kwaneng tero koma wamekpa, Paulus sin anabiag sekogti, yubu ambarelamsiogti, “Nangkabo, Kreta wamoboa nandamneri lemnonge a'undi ka'ebanohomba, nuri poamaba tologlamsibongeap, kabong kwerekto maghag talamobongeap unuahabe kom. ");
INSERT INTO kkl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","A'un nari wembahino yubu ka'ebaom kom aghana, wene nari wenelamsinne, wana aingniro wamlulom. Nu kabong eneag agha nu ni tebaukap kom, ot kabong aneogna loba talul. ");
INSERT INTO kkl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nari lelamnange nenena undo. Na inipnag lenda mamnaba, Allah naringe omeklamnange poneko Eldamneri arukna malaikat nanag poghol aoba, yaldi na peramag sekamla. ");
INSERT INTO kkl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Yaldi, na peramag sekamlari, leplangena, 'Paulus, log sembaheng kom. An Kaisar whingag pululam. Allahri an o'ona sembangkelba, nimi anap kabongag wamlomne tane nhon babe tebalulom kom,' aro wene malaikat nenekori ambatnel. ");
INSERT INTO kkl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","'Tebalulom kom,' aro ambatnelba, nangkabo, wana aingniro wamsu. Nanag ni ambatnelne nene ni uro yabilulba, na Allahag seneraglamna. Ane sembe nangkabo, wana aingniro wamsu. ");
INSERT INTO kkl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tebaukap kom aghana kabong aneri nu mag longo kanektobag pabalamsileri, meloptaleba, kabong ane kolabalul,” aro Paulusti ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ik meke sumeneko khao anekori kabong ane pabalamog paghabog mag Adria laut longoropneag pabalamsiog. Pabalamsiogpa, inipna tomnusam talamogpa, inipnag kabong porop nimi tanekori, “Abolag payalamsil, te?” sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","“Abolag payalamsil, te?” sembaekti, kirik haing kerekongkia peleng-peleng yalamekpa, mag longoroba we aneko haing kongkarekna yan kwagha tariro ingina teng nhon epto naul bare wamog. Nen olog pabalamsiogpa, pelengelamekpa haing kongkarekna yan kwagha tariro ingina teng nhon epto wilindi wamog. ");
INSERT INTO kkl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","“Kabong aneko kirik sildiag tipleag,” aro sin log lelem kirik simbuk tombare kabong pomaghag sip pelengkaekti, “Elemag kwelekale,” senero wamek. ");
INSERT INTO kkl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","“Elemag kwelekale,” senero wamekti, kabong porop nimi tanekori, “Magti kabong aneko kolabaleagti, kabong nubunge laplobiagha kabong ologne maghag pelengkaberi, mag alip toman tognoro pukap,” aro saekag lebek. Undo tognoro saekag lebekti, maneri ulamekti, seneraglamekti, “Ora nimi ekon wamukang. Kabong porop kom nimiri sembaukangnena, 'Kabong paiag sip saelba unna kirik simbuk whingag sip wamlange pelengelamang,' senelamikpa, mag alip toman kabong ologneag agha tognoro pukap,” aro kabong ologne kabong nubungeag wamogne neneko maghag pelengkaek. ");
INSERT INTO kkl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Undo unulamekpa, Paulusti ipsiogti, el taogti, yin saleropne sikindoap ilipsaboap tibin nenero ambarelamsiogti, “Kabong porop nimi tanekori, 'Tognoro pukap,' aro ulamang aghana, kabongag wamna koma liloa piik tanena, nhon kamag wamlulom kom,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Wene seogpa, kabong nubunge porop nimiri “Tognoro pukap,” aro ulamekne sembe, yin saleropnang tanekori el taekti, kabong ologne kabong nubungeag haing kerekameka taneko haing karepto maghag talopsiek. Kabong ologne maghag talopsiekpa, kabong nubunge porop nimi tognoro piek kom. ");
INSERT INTO kkl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kwelekanep peram Paulusti “Kwaneng tululom,” aro wenelamsiogti, “'Khao kom taho,' senero wamomdi, ik mek bare kwaneng ten koma wamom. ");
INSERT INTO kkl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","A'un wali kamag wamlulomba, kwaneng a'un samenag tululom. A'un ni ane wamlomne a'undi usoghag hong pongoropne hong kiki nhon seknagha timbalul kom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wene aro ambatsiogti, Paulusti kwaneng roti tobogti, sin ni wamekne whingag agha Allahag “Nani, wah, walia tatsilam,” aro lelamogti, khepto-khepto tatsiogti, Paulus samenag teog. ");
INSERT INTO kkl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Sin wana ikin wamsiogne wana aingnibahiogpa, sin babe awi yeng uro kwaneng telamek. ");
INSERT INTO kkl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nu kabong enekoag nimi yalamubungena, nimi teng sa'obare eptopneap (276) ane yalamubu. ");
INSERT INTO kkl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kwaneng tiburi, mon tahiogpa, kabongag kwaneng roti sumbaneba gandum wana poamekne taneko “Kabong keyagman talul,” aro maghag talolamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kweleklamogpa kabong porop nimi tanekori tilamekpa, mog so'o kirik a'angkea ingkis sameptopne nhon tibog aek. Kabong porop nimi taneko mog so'o ene sin babe ekon aghana, kabongag agha tibogaekag aneko “Tibil pukap,” sembaek. ");
INSERT INTO kkl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Anekoa “Kabong saelbamlul,” aro kirik simbuk pelengeroba taneko haing kaongoro maghag talopsiek. Haing kaongoro maghag talopsiek abeneko kabong u o'oroba “Nhonag sip pabileag,” aro kerektopne toro pibekti, “Pulul,” senenagne u o'obaek. Phoana mag laut longorop mag siba yalamogpa, “Mog so'o ingkisag tibil pukap,” aro ulamekti, ag kabongag kerekaekpa, “Phoanari ko'oro pabalamlul,” aro kerektop ag kabong whingag sip towalingkibekti, palamek. ");
INSERT INTO kkl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mag ingkisag palamek aghana, kabong eneko kirik a'angkeag malukaogpa, kabong whingag sip kirik a'angkeag wereloptaogpa, lebe senep kom uaog. Lebe senep kom uaogpa, pomaghag sipna mag kola'epto yalamogti, olamogne nenekori kolabaog. ");
INSERT INTO kkl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kolabaogpa, yin salerop nang kabongag wamek nang tanekori nimi sae kaupto pabalamsiek nimi taneko “'Maghag agha ya'aro abolag piikti, merebaikag,' aro opsukap,” aro ulamek. ");
INSERT INTO kkl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Undo unulamekpa, yin saleropnang sikindo Paulus pabalamogne ponekori “Paulus obikag,” aro “Pelebanun,” aro irikahiog. Irikahiogti ambarelamsiogti, “Mag alip toman ya'aro pirop nimi samenag maghag taptaikti, ya'aro abolag pukang,” seog. ");
INSERT INTO kkl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Mag ya'aro panne ekonnena kal la'asi agharo, kabong kwerektoba agharo salero mag alip toman agha mag abolag undo piburi, nimi nhon babe tebaek kom. ");
INSERT INTO kkl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Magti opsiog komba, mag alip toman agha mag longo kanektop so'oag abolag piburi, wamububa Malta nimi tanekori, “Malta so'oag yalom,” aro ambatsiekpa, eltabu. ");
INSERT INTO kkl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Malta nimi wamek nimi tanekori nu sembe o'ona maikno sembahiekti yeplamsiek. Mag telamogti, sondi habuklamububa, nimi tanekori auk lolbaek. ");
INSERT INTO kkl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Auk lolbaekpa, Paulusti kal toro polbaogti, aukag tabogpa, auk ogti phae nhon lambaogti, Paulus saeag si sabog. ");
INSERT INTO kkl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Saeag si singkamogpa, Malta nimiri kembaekti, “Nimi ene mag alip toman yalamlaba, magti opla kom aghana, phaeri si saplaba, tebalul. Nimi nhon samen opsiog tiog ane sembe nimi ene wamnep kom. Wene malia uaonge sembe memari lunuro yingkina elba opla,” alamek. ");
INSERT INTO kkl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Wene alamekpa, Paulusti phae aneko saeag agha pelebom agha aukag tabog. Phaeri si sabog aneko nona babe olog nobaog kom. ");
INSERT INTO kkl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Phaeri si sabog aneko sembe nimi wamek nimi tanekori, “Paulusti sae usa olog sae babe nobalul to, tepna babe tebalul to?” aro kemero wamek. Sindi wene sembamekti, kemero wamek aghana, sindi seneragamekti “Ualul,” sembamekne olog uro yabiog komba, sindi el sembe, “Elna nimi kom. Anena mema,” senelamek. ");
INSERT INTO kkl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Malta so'oag wamubua peramag so'o enekoag mog so'o ngainge nubunge mag longo kanektop so'o saelbamogne sina Publius wamog. Publius ponekori nu eldi wana wali uro aeag topsiogpa, ik wilindi wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wamububa Publius ili nong boboap, niknaap, ti haoapti niklamogti, aeag malamog. Malamogpa Paulus aeag wa'iogti, sae usoghag pairo Allahag molona lebogpa, Publius ili wali taog. ");
INSERT INTO kkl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Neneko wali nembaogpa, nimi orange nikna niklamekne mag longo kanektop so'o enekoag wamekne yalamekpa, wali nenelamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wali nenelamsiogpa, awi maiknoro kiplamsiekti, sindi nu sembe wali sembamsiekti, “Mag alip toman kabongag agha palamikti, tukang,” senena sindi nu sembe wero palilamsiek. ");
INSERT INTO kkl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mag longoro kanektop so'o Malta wamubu so'o tanekoag kabong as Aleksandria agha yaog kabong nhon wamogpa, khao li taogpa, Malta so'o kabong pabalingkirobag aneko haing kerekaekti, ta'ap wamog. Wamogpa, so'o anekoag yabuburi, wal wilindi wamubua khao aingniamogpa, as Aleksandria agha yaog kabong enekoag waelbabu. Kabong waelbabu kabong enekoag mema phende Kastorapna Poluksap usog yame sunuro kabong whingag sip sobaekpa, kabong enekoag yalamubu. ");
INSERT INTO kkl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Yalamuburi, as Sirakusa aneko yingkina ik wilindi wamubu. ");
INSERT INTO kkl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Aneko ik wilindi wamubua mag alip toman palamuburi, as Regium yabu. Mabubua kwelekaogne neneko phoana wali uro yalamubuag siba yangaro yalamogpa, ik nhon ningki palamubua, as Putioli yabu. ");
INSERT INTO kkl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Putioli aneko pibuba, nungkabo Yesusag “Sikne” aro seneraglamek nimiri, “Nunap nhon wamukap,” aro nunag molbahiekpa, ik saek bare sinap nhon wamubu. Aneko wamubua nen as Roma palamubu. ");
INSERT INTO kkl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nungkabo Roma nimi Yesusag “Sikne” aro seneraglamek nimiri nu yalamubunge sembe yubu ka'ebaekti, nu wamubuag yaek. Roma agha nu wamubuag yalamek nimina, as si Pasar Apius wamubuag yaekpa, nen tipto palamuburi, as si Tres Taberne wamubuag babe nunag yalamek. Sin nunag yalamekne sembe Paulusti kembahiogti, wana aingnibaogpa, “Allah wah, Nani,” alamog. ");
INSERT INTO kkl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nu as Roma aneko piburi, Paulus kop aeag tolongoro koma el mo aeag wamogpa, yin saleropne nhondi yae wamog. ");
INSERT INTO kkl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Wamubua ik wilindi wamuburi, Paulusti Yahudi nimi sikini yabo yopsiogpa, poloro winiptaek. Poloro winiptaekpa, Paulusti lelamogti, “Nangkabo, nu Yahudi nimi sembe suknuna suknubano kom. Nu Yahudi nimiri ul palamapne saelba uropne irikna sembe babe phibano kom, aghana na Yerusalem wamnoba saelbaneongdi, Roma nimi saeag nembaneong. ");
INSERT INTO kkl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Saeag nembaneongdi, nanag tam pibongne sembe Roma nimiri kembaongba, tam nari unne sunsunum uro tam ikinne na tepnange palinne orogti, 'Sae libukap,' seong. ");
INSERT INTO kkl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Undo wene seong aghana, Yahudi nimiri, 'Sae haing sae lopto lambaheng kom,' seongba, nari ambarelamsinori, 'Kaisarag pibeba, Yahudi nimiri tam sumbaneongne sembe Kaisarti karebalul,' seno. Wene senonge nene, 'Yahudi nimiri ulamangne sembe tam Kaisar whingag ambarel pinun,' aro lepno kom. ");
INSERT INTO kkl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ane sembe, 'A'unap haiptaberi, a'unag yubu lemnun,' aro yopsin. Nu Israel nimiri nang-nang alamapne neneko sembe na sae kaupto wamnange nene ililamnelom,” aro ambatsiog. ");
INSERT INTO kkl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wene aro ambatsiogpa, sindi elag yubu lelamekti, “Nun nungkabo Yudea wamangneri mome an sembe pibongne nunag yao kom. Nungkabo Yahudi nimi yogne babe nunag yaongneri andi malia ualumne sembe tam nhon babe ambatsiong kom. ");
INSERT INTO kkl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Yahudi nimi tane yaong nimiri an sembe nunag ambatsiong kom aghana, nu ka'elamapne andi ambarelamsilam yubu ene sembe nimi tala-talari, 'Ekel uro seneragtop yubu ina ambatoba,' alamangba, ka'elamap. Ane sembe, andi seneraglamlamdi, ulamlamne nene nuri ka'ebaukapti, ik nhon sum ambatsululam,” seek. ");
INSERT INTO kkl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Wene seekti, “Ik nhon longop taberi, yubu tam kembaukap,” aro Paulusap sinap yubu saekag lebek. Sumeneko sum Paulus ua ulamoghag aneko nimi maikno elag yaekpa, lukunap Allah yubu alnibaogti, ambarelamsiog paghabog ae sin taog. Ambarelamsiognena, samen Musari, “Undo-undo ualulom,” aro mome toro pirop yubuap, Allahri yubu silimu tiptop nangdi mome toro pibek yubuap agha kiliro ambarelamsiogti, “Allahri, 'Nimi ni mog so'oag nimi saelbahinun,' seogne Yesus sembe lelamogpa, mome toro pibek,” aro wana heklamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wene aro wana heklamsiogpa, nimi nenneri Paulusti ambatsiogne sembe “Sik lepla,” aro seneraglamekpa, nimi nenneri “Orolena lepla,” aro eldi yubu seneraghek kom. ");
INSERT INTO kkl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Wene aro seneraghek komne sembe Yahudi nimi taneko yubu leldalamekti, anam lamban komag sindi seneragna wana taongkwahiogne kembahiogti, Paulusti yubu kiki nene ambarelamsiogti, “Samen Allahri yubu silimu tiptopne Yesayaag Allah Eldamne Yame Walingeri sikne aghabog lebog. Sik andagha lebognena, yubu tipto a'unisag yabo Yesayari ambarelamsiogti, ");
INSERT INTO kkl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","27","'Israel nimi taneko usog mikip nimi talamek. Sin ao leptangkamekti, haing babe uptangkamek. Sindi ao leptan koma babe haing uptan koma babe haingdi ipnep, aori ka'ebanep, wanaag babe seneragnep tanena Nadamne Allahag samoro yaukang. Nadamne Allahag samoro yahengpa, wali nembahisene. Aghana usog mikip talamekne sembe Israel nimi eneag pimendi, lelapmendi, “A'undi sop-sop 'Ka'ebahane' aro a'ori ka'elamlulom aghana, wanaag agha ka'ebalulom kom. 'Ipsene' aro haingdi ililamlulom aghana, wanaag agha seneraglulom kom,” aro ambatsululam,' aro Allahri ambarogne Yesayari sik uro mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Allahri a'un Yahudi nimi sembe 'Ka'ebaukang kom,' aro ambarogne sembe 'El wamlulom,' aro tibin nenero ambarelamsin. Allahri samenag 'Mog so'oag nimi taulbahinun,' aro salag pibognena, 'Yahudi sisa kom nimi ambarel palamsululom,' aro yubu ene poglamsiog. Poglamsiogpa, wene ambarelamsiapba, sin wali ka'elamukang,” seog. ( ");
INSERT INTO kkl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wene aro ambatsiogpa, Yahudi nimi yaek nimi taneko palamekti, sin mo-mo yubu leldalamekti, yubu leple palamek.) ");
INSERT INTO kkl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Piekpa Paulus neneko nimiri ae agha kamna toro ua ulamoghag anekoag heng kun phende wamogti, nimi elag yalamekne sembe wana yeng sembamogpa, nimi elag maiknoro yalamekpa, wali uro kiplamsiog. ");
INSERT INTO kkl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wali uro kiplamsiogti, hengkun phende as Roma wamogha log kom uro “Allahri, 'Nimi ni mog so'oag nimi saelbahinun,' seogne anena Eldamneri 'Saelbahimendi, taulbahilulam,' aro wepto poghol aogne Yesus sembe lelamog,” aro ambarelamsiog. Ambarelamsiogne nimiri iriknange orog wamogpa, to'onna kom uro yubu walinge Yesus sembe ambarelamsiog. ");
INSERT INTO kkl_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Nungkabo! Na Paulusap nangkae Timotiusap Yesustinge arukna wamnamdi, mome neneag agha kiplamsinam. Yesus poneko sembe Kristus alamapnena, Allahri el wepto “Mog so'oag nimi talulamsimendi, saelbamsululam,” aro poghogpa, Yesus yaogne sembe Kristus aro engelamap. Yesus Kristus ponekori arukna wamnamdi, a'un kiplamsinam. Allahri a'un sembe “Namabo taukang,” aro wepsiogpa, a'undi Yesusag “Sikne” aro seneragto Elap ma'aptaomdi, Allah Elmabo taom nimi as kota Filipi wamlom nimi ni “Nungkabo” aro kiplamsinam. Apna nungkabo as kota Filipi nimi sembe Allah Elmabo paia uhirop nangap, Allah Elmabo yepto tongohirop nangap sembe a'un kiplamsinam. ");
INSERT INTO kkl_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Nuri a'un sembe Allahag molbarelamsinam nenena, “Nuni Allah nuringeap Yesus Kristus nu Saelba Uhiropne ponekoapti wana walingeag agha a'un walia ulamsirikti, a'un aingnilamsurukang,” senelamnamdi, molona molbarelamsinam. ");
INSERT INTO kkl_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Nari sop-sop a'un sembe seneraglamsindi, nari wanaag agha, “Naba Nani walinge,” aro Allah kiplamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Nari a'un ni sembe sop-sop Allahag molbarelamsindi, nia a'un sembe molbarelamsinne, na wana yengag agha molona molbarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Nari wana yengag agha a'un ni sembe Allahag kipto molona molbarelamsinnena, tam nene sembe. Na samenag Filipi so'oag yahiri, yubu walinge Yesus sembe a'un ambatsisiba, a'undi alniro Yesusag “Sikne” aro seneraglamlum sumag agha yeplamnelum. Alnirop sumag agha yeplamnelumba, a'unap sae kerektangto tolamuburi, wene babe awe nikne toro yubu walinge Yesus sembe nimiag ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","A'unag uro yabiogne neneko, Allah Eldamneri a'un yepto alnibaogpa, Yesusag “Sikne” aro seneraglamlum. Nari wana to'opto sik sembamnarina, Eldi a'unag walinge alnibaogne ponekori a'un sae lipsin koma tipto walinge tolamle paghabog Yesus Kristus El nen samoro yalamle sumeneko agha a'unag tolamsilne komobalul. ");
INSERT INTO kkl_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","A'un nari nimi wanaagne wamlom ane sembe, nari a'un ni sembe “Khaepto wamukang tiog,” senelamsindi, yeng sirik uro seneraglamsinne nene sunsunum. A'undi nanap sae kerektangto awe nikne tolamap ane sembe, a'un sembe undo yeng senelamsin. Allahri wana walingeag agha na yepto awe nene tatneori, a'un babe yepto tatsio andarina, Yesus yubu walinge nikne ambarelamsilom. Na wamnangena, Yesus yubu walinge sik senerop kom nimi whingag Yesus yubu walinge pelepto sikne lag nenelamsinneag babe, nimiri na haing sae kaupto salero piamneangneag babe, a'undi na sae limnen koma Allahri yeplamsilneag agha awe nikne tolamap. Ane sembe “A'un nari nimi wanaagne wamlom,” senelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Nari a'un sembe “Sik uro a'unap haiptahabe,” senenne nanag loloro wamlange sembe Allah Eldamneri el wamla. Yesus Kristus ponekori o'ona senelamsilneag agha a'un sembe o'ona senero, “Haiptahabe,” senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Nari a'un sembe molona Allahag molbarelamsinnena ane. Allahri a'undinge wana heksinne maikno nembamsileba, a'unag el wamsilulne babe maiktangto yabalamlul. Allahri undo a'un yeplamsilul andarina a'un mamun o'ona maikno ma'aro seneldalamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","11","Allahri a'undinge wana heklamsileba, a'undi nia mangkina mipsinne agha, “Malinge nene, walinge nene,” aro el tamundi, walinge sirikne aghabog saelbalulom. Mipsinne agha walingeog saelbapmun tanena, Yesus Kristus nen samoro yale sumeneko tam lelekto kemero kareplamleri, a'undinge wanaag malinge nhon babe iplul kombana, nimi nhondi babe a'unag tam pimnep kom. “A'un undo wamsom,” sembamnangena, Allahri wepto poghogne Yesus Kristus ponekori a'unag ulamsileba, a'undi walia sikne ulbanne a'unag to'opto wamleba, wanaag malinge orogha a'unag tam pimnep kom uro wamlulom. Undo wapmun tanena, nimiri a'undi ulapmunne sembe Nuni Allah omektoba El sembe kibiang towalengkukang. Ni ane a'unag undo uro yabilultiog sembamnari, Allahag “Yepsululam,” aro molbarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Nangkabo, a'un babe eltahiso sembamnangena, nanag uro yabalamlangeag agha yubu walinge Yesus sembe nimi maikno ka'elamangpa, Yesus yubu walinge nene sabo talamla. ");
INSERT INTO kkl_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Undo yabalamlaba, as kota eneag wamang nimi niri na sembe el uro wamangnena, sindi, “Paulus nenekori 'Yesus Kristus si nubu talul,' aro ambarelamsilne sembe nimiri el sae kaupto kop aeag tobongkibong,” aro na sembe ka'elamangdi, el uro wamang. As kota eneag wamang nimiri babe, Roma nimi sembe yubu sia leropne ponekori ae yae ua uro yin salerop nang babe ka'ebaongdi, el wamang. ");
INSERT INTO kkl_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Nungkabo Yesus Saelba Uhiropne ponekoag wana saingnia urop nimi as kota neneag wamang nimiri na sae kaupto kop aeag wamnange kembamneong. Kembamneongpog, na sae kaupto wamnange neneri sin Yesusag seneragtop nimiri wana mikip nenelamsil andarina, sin nimi agha maiknori Allah yubu Yesus sembe nen ma'aro log kom uro lag phoro nimiag ambarelamsiang. ");
INSERT INTO kkl_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","17","Nimiri Yesus yubu sikne ambarelamsiangnena, nimi nhon-nhondi sindi, “Nimi nubunge tanun,” aro ambarelamsiangba, nhon-nhondi “Ora nimi luknubahineri, paliag tanun,” aro ambarelamsiang. Sin undop saog nimiri wana tapto seneragna koma, na sembe seneraglamneangdi, “Paulus haing sae kaupto kop aeag wamla. Undo wamlaba, Yesus sembe ambarelamsibenge agha nimiri nu omeklamsikpa, nubunang tabenge sembe Paulusti wana saplul,” aro Yesus yubu sembe ambarelamsiang. “Nimiri mipnukang,” aro ambarelamsiang aghana nenneri otsik uro o'ona senehinneag agha “Yepsinun,” aro Yesus sembe yubu sikne ambarelamsiang. Sin undop saog nimi el wamsilba, na haing sae kaupto kop aeag wamnange nenena, Allahri kop ae aneag sekitneo andarina, pelebeltanan yubu ambatsirop sumeneko sembe nang-nangkalamna abeneko pere Yesus yubu walinge babe sik uro ambarelamsindi, ambarelamsinun. Sin undop saog nimi el wamsilba, na wamnange sembe o'ona senelamneangdi, yubu walinge Yesus sembe tipto ambarelamsiang. ");
INSERT INTO kkl_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Nimi eneri wana walingeag agha Yesus yubu walinge ambarelamsiangpa, nenneri “Nubunge tanun,” aro Yesus yubu sikne ambarelamsiang. Tam nene nanag ikin kom. Na sembe o'omnena, sa'a-sa'a uro yabileba, nimiri Yesus sembe, “Allahri wepto poghogne Kristus wamla,” aro sik uro ambarelamsiik tanena, na yeng ulamnel. Na yeng ulamnelba, amikne babe yeng uro wamnun. ");
INSERT INTO kkl_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Na haing sae kaupto kop aeag wamnari, “Na yeng sirik uro wamnun,” senennena, tam nene sembe. Yesus Kristus ponekori nunag Yame Walinge tatsiogpa, a'undi na sembe Allahag molona molbarelamnelomne sembe, “Eldi Yameri na yepto paiamneleri, wali nembanelul,” aro na elwamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","“Allah Yame Walingeri sik uro na yepto paimnelul,” senelamnari, yeng uro tiboglamnangena angaro yabinep komdi, ali sembamnun kom. Nari nongag sa'a-sa'a uro yabioba, nari nong ningkiri “Yesus Kristus poneko si nubu talul,” aro sop-sop ulamna. Wene babe, Allah Yame Walingeri yepneleba, kamag wamneag babe, ya'ag omneikag babe, “Yesus Kristus si nubu talul,” aro “Log kom uro ambarelamsisene,” senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Nari senelamnange, na kamag wamnangena, Allahri wepto poghogne Kristus ponekoringe wamna. Na tebanne babe, tebaneba, kamna walinge nanag talul. ");
INSERT INTO kkl_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Aghana na mog so'oag wene wamnange nenena, “Awe walinge wero nimi wali yepsinun,” senelamna. Ane sembe, “Yaghe, nela agha wepto whingag nembanun?” senelamnari, ");
INSERT INTO kkl_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","na tara sip agha kilim, tara sip agha kilim aloa saog ulamnel. Nari wanaag agha senelamnangena, “Yesus Kristus saramag piheneri, nhon wamseneme,” senelamnange, nene agha wali sirik senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Aghana nari a'un wenehiro yepsisene senelamnange nenena, tebahane tanena a'un sembe eka'uktina, “Mog so'o neneag agha wamsene,” senelamna. Kamag wamneba, a'un sembe wali wamlul. ");
INSERT INTO kkl_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Tam nene sembe na sik uro el wamna. Ane sembe, “A'unap nhon na kamag wamnun,” aro wepto whingag nenelamna. Mog so'o neneag a'unap nhon wamnea andarina a'un yeplamsinun. Nari a'un yeplamsinnena, “Yesusag wana maiktangto saingnia wapmundi, awi senenne a'un wanaag nubu tangto yabalamlul,” aro yeplamsinun. ");
INSERT INTO kkl_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","“Kamag wamnun,” aro wepto whingag nenelamna andarina, na a'un wamlomag samoro yane tanena, a'un Yesus Kristus ponekoag nhon ma'altalamlom nimi awi sembamlulom. Na a'unag samoro yanenge sembe a'undi, “Yesus Kristus ponekori Paulus tebanebag agha taulbaoba, yal,” senelamlulom tiog. Undo senelapmunneag agha, awi senenne siriro la'analamloa saog uro a'unag wamlul tiog sembamnari, “Nen haiptahabe,” senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","“Nen haiptahabe,” senelamna aghana, a'un wamlomag yaneri, nari haingdi a'un ipsinun to, ya'ag a'eptabeba, nimiri a'un sembe yubu lena aghabog ka'ebanun, to, amik el taukap. Ot sa'a-sa'a uro yabileba, a'un wali wamlulom aro el tahane sembamnari, nari wanaag wamlange a'un ambatsinuan. A'undi sop-sop ulapmunnena, Yesus Kristusap ma'aptangtop nimiri unuaheng senenne sunsunum uro ulamlulom. Allah Eldamne Yame Walingeri a'un yeplamsileba, Yesus yubu sunsunum uro a'un seneragna nhonog khaepto wamlulom. Khaepto wapmundi, a'un mamun seneragna nhonog agha sae kerektangto kilim weang alapmundi, Yesus yubu sikne pelepto ambarelamsululom. ");
INSERT INTO kkl_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","A'undi nia ulapmunneag a'un aisa nenelamsiik nimi sembe log semban koma khaepto sekamlulom. A'un log kom uro khaepto sekapmunne nene sindi kembongkia, “Allahri Yesusag wana saingnia pairop nimi taulbahileri, Yesus yubu ingisaptop nimi oro luknubahilul,” aro keknep uro yabilul. ");
INSERT INTO kkl_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Allahri a'unag walia tarelamsilne nenena, Yesusag “Sikne” aro seneragnange nene tarelamsildi, taulbahilul. Ot nunag tatsiogne nenena Yesusag seneragnange aghabog tatsiog kom aghana, Allahri wepto poghogne Yesus Kristus poneko sembe seklero ulbanne babe nunag tatsiog. ");
INSERT INTO kkl_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Nunag tatsiogpa, nari kilim weang aro ulamsinge neneko a'undi haingdi ililamnelum. Wene babe ikinne nanag uro yabalamlange sembe ka'elamlomdi, a'undi babe kilim weang aroba nikne seklelamlom. ");
INSERT INTO kkl_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Allahri wepto poghogne Yesus Kristus ponekoap ma'altalamlomne neneri a'undinge wana mikip nenelamsil. Yesus Kristus ponekori a'un o'ona senelamsilne neneri a'undinge wana aingnilamsil. Allah Yame Walingeri a'un yeplamsilneag agha a'un kabo Yesusag seneragtop nimiap sae kerektangto wali wamlomdi, a'undi wanaag agha yareag seneltalamlom. ");
INSERT INTO kkl_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Ane sembe a'undi na wana awi to'opto nembamnululom nena nenda nene: A'un seneragna nhonog uro wana nhonog agha a'un mamun o'ona seneldalamlulom. A'un mamun “Nari wanaagne” seneltalapmundi, seneragna nhonog agha ulpalamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Sa'a-sa'a ulpalapmunne nenena, “Na nimi nubunge tanun,” aro uaheng kom. Apna, na maiptangtop senenneag agha “Na ililamnukang,” aro uaheng kom. Ulamlulomnena ane. A'undi wanaag andamne mombolag neneptangto ora nimi sembe “Whingagne nembahinun,” aro ulamsululom. ");
INSERT INTO kkl_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","A'undi “Teko uaneleag,” aro ulapmunneag, ot andamne sembe aghabog semban koma ora nimi sembe babe, “Teko uahileag” aro kembamsululom. ");
INSERT INTO kkl_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","A'undi seneraglamlulomnena, Yesus Kristus ponekori wana seneragtopne sunsunum uro seneraglamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Allahri wepto poghogne Kristus ponekoap Allahap nika-nika uro nhon urop, aghana Kristus ponekori Eldamne sembe “Nanap Allahap nika-nika uroptina, nia mangkina salelamna aghana, sesog sembe sae limnun,” senelamog. ");
INSERT INTO kkl_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Wene Eldamne sembe seneragtan koma Allahringe mikipne sae libogti, mog so'oag nimi mangaptangtopne sunsunum uro mangaptaogti, nimi arukna neneptaog. ");
INSERT INTO kkl_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","El mog so'oag nimi nongag mangaptaogti wamogha, Eldamne mombolag neneptangto Allahri Elag, “Mog so'oag nimi sembe lunuro tebel pululam,” aro aruktop yubu ka'elamogti, wail ibatna koma sunsunum uro ulamog paghabog tebaog. Tebaognena, haogha torop nimi wamloa saog obekti, aluktoba paku agha el kalag sibekpa, seklero tebaog. ");
INSERT INTO kkl_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Eldamne mombolag neneptangto Allah yubu sunsunum uro ulamog ane sembe, Allahri Yesus poneko kiliro paliag sirikne urobag nembaogti, Elag Allahri pibognena, nia mangkina saelba uhiropne si engero pibogti, mikipne ni aneko Yesus saeag pibog. ");
INSERT INTO kkl_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Ane sembe Nia Mangkina Saelba Uhiropne poneko si Yesus sembe, nia ni imag ua uropneap, mog so'oag ua uropneap, so'o punag ua uropneap, nia mangkina wamlangeri El whingag yabu sanukto amupto pulingkiberi, El kiplamukap. ");
INSERT INTO kkl_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Allahri wepto poghogne Kristus sembe nia mangkina wamlangeri, “Yesus nia mangkina Saelba Uhiropne wamla,” aro lag phoro lelamukap. Yesus paliag nenero lag phoro lelamebengeri Nuni Allah paliag nenero omeklamukap. ");
INSERT INTO kkl_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","13","Nangkabo, nari a'un o'ona sembamsin nimi! Yesus eldamneri Allah yubu sunsunum uro ulamog ane sembe, a'undi babe Allah yubu ambarelamsinne ka'eapmundi, sunsunum uro ulamlulom. Samenag a'un anabiag wamnori nari yubu lelamnonge ka'elamomdi sop-sop sunsunum uro ulamom. Samenag ulamom saog uro, wenena a'unap nanap weag neneptangkamabag, nari yubu lero palilamnange sae limna koma saelbapmundi, sol wali uro ulamlulom. Allah El mori a'un taulbahiognena, a'undi wanaag awe tolamla andarina, Allahri wana yeng neneropne sunsunum uro yeng senelapmundi, sunsunum uro a'undi uanep. A'undinge wanaag tolamla ane sembe, Eldi walia ulamsionge sembe log lelem pet-pet aro a'unag tolamlange sunsunum uro lag nenero ulamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","16","Sa'a-sa'a a'undi ulapmunne, seneraglapmundi, “Allah Elme wamnaba, nimiri nanag tam pimneikagti, malia uan koma walinge aghabog uanun,” aro a'un mamun wana mali paiptan koma, yubu neneptan koma ulamlulom. Undo unulapmun tanena, mog so'oag nimi anabiag wapmundi, mali-malia urop nimi, ekel ina inibinag pirop nimi anabiag wapmundi, yubu walinge Yesus sembe ambarelamsululom. Yubu walinge Yesus sembe nenekori nimi kamag nenerop yubu wamla. Malia uan koma wapmundi, Yesus yubu walinge ambarelamsimun tanena ekel ina inibinag pirop nimi anabiag wapmunne, a'un wap warerop saog urop nimi wamlulom. “Undo-undo unulamlulom,” aro ambarelamsinnena, amik Allahri wepto poghogne Kristus nen samoro yale sumeneko, El sembe nari kilim weanga awe wel tongahinne neneko “Teba'an sembaleag,” aro undo ambarelamsin. El nen samoro yale sumeneko a'un Filipi nimiri wali-walia ulapmunne neneko ipleba, nari babe, “Ali semban koma Elag ambatneri, 'Nari awe wel tongolamnange pere agha wali-walia unulamang,' aro ambatnun,” senelamnari, “Undo-undo unulamlulom,” aro ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Nari awe wel tongolamnange pere agha a'undi Yesusag “Sikne” aro wana saingnia seneraglamlom. Ane sembe nari Allah sembe nhon tarelahane senelamnangena, Allah sembe awe wel tongolamnoba, a'undi sik senelamlomne neneko Allah whingag kipto palilamna. Na nimi sisa Yahudi nimiri “Allah sembe pham domba aukag tabukap,” aro palilamangdi, pham domba oropne nong alibag anggur lolderop mag ikto Allah kiplamang. Undo saog uro nari Yesus yubu walinge ambarelamsinne sembe nimiri ya'ag omneik tanena, “Nari eneng babe Allah sembe iknun,” aro wana awi uro tarelamna. A'unap nanap nhon Allah kipto palilamapne sembe nikag awi senelamukap. ");
INSERT INTO kkl_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Nuri Allah sembe paimnepne sembe a'undi babe nari awi senelamnange saog uro nanap nhon awi sembamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Nari sik uro seneraglamnange Yesus nu Saelba Uhiropneri yeplamneleba, nari Timotius elemag a'unag pogholanun. Pogholaneba eldi a'un sembe yubu ebel yalenge ka'ebane taneogna, wana aingnibanile andarina, wana mikip tanun. ");
INSERT INTO kkl_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Ot Timotius agha nari wana seneragnaap el agha sunsunumdi, ot eldi a'un wali wamnepne sembe sik uro seneragto o'obahinep. ");
INSERT INTO kkl_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Nimi orange ni kemelamsinba, Yesus Kristus si nubu talulne sembe seneragto ulbalamang komdi, ora nimi sembe seneragna koma sindam nimiringe sembe agha seneraglamangdi ulamang. ");
INSERT INTO kkl_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Elap nanap ili elme saog wamnomori, Yesus Yubu Walinge nubu nenero nimi ambatto tongolamsinomoa eldi sol wali uro yeplamneo. Yeplamneori, miplamongba, a'undi babe haingdi ibomdi, “Nimi sikne wamla,” aro el wamlom. ");
INSERT INTO kkl_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Ane sembe, tam nanag uro yabalamlange sembe “Lambanun to, kom to,” aro olog tibin talamle tanena, “Nari Timotius a'unag men phea pogholanun,” aro seneragamna. ");
INSERT INTO kkl_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Na mori babe sik uro seneragamnangena, nu Saelba Uhiropneri yeplamneleba, ko'o olog we uro pin komag men phea a'un kemelahinun sembamna. ");
INSERT INTO kkl_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","26","Nungkae Yesusag seneragtopne Epafroditus a'undi “Na yeplamnilul,” aro pogholaomne poneko, nari sembamnange, nen sap a'unag wali pogholanun sembamna. El pogholaomne poneko nanap nhon awe nikne weltongolamnomoba, aisanangdi nu 'Luknubahukap,' aro ulamsiongba, Yesus yubu walinge pelepto sikne lag nenelamsinomo. El samen niklamoba, a'un eltahio. A'undi el sembe el uro wamlomba, “Log sembahengag,” aro el wana ikin uro a'un sembe “Wela wamangne sembe kemel phihene,” aro wana seneraglamla. Wenena, wali nen a'unag pogholanun. ");
INSERT INTO kkl_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","El sik naikna mali uro naiklamori, tebanep wamo aghana, Allahri el sembe yareag sembaori, yeboba, wali tao. Allahri yareag sembaongena, el aghabog yareag sembao kom. Na sembe babe Allahri “Wana ikin along sembaleag,” aro yareag sembaneori, Epafroditus wali nembao. ");
INSERT INTO kkl_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Ane sembe maiknoro seneraglamnari, “El nen a'unag samoro 'Pululam,' sunun,” aro seneraglamna. Nen samoro a'unag pogholane andarina, a'un babe wana awi uahileba, na babe wana aingnibanilul. ");
INSERT INTO kkl_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","30","Eldi yeplamneonge a'undi pogholaomne wamla. A'undi na yeplamnehom aghana, a'un weag a'eptabongeag agha eldi a'un lumbaori, nong sembe seneragtan koma na yeplamneo. Yeplamneori, elba, “Yesus Kristus si nubu talul,” aro Epafroditus ponekori awe tolamori, el tebanep wamo. Ane sembe “Nu Yesusag seneragtop nimi nikne wamap,” sembamunba, el samoro yaleba, a'undi wana yengag agha kipto paliag nembamlulom. Nimi etneri sindam nimi nong sembe seneragtan koma Yesus sembe awe tolamik tanena, undop saog nimi kipto paliag nembamsululom. ");
INSERT INTO kkl_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Wene nangkabo Yesusag wana saingnia seneragtop nimi, nari a'un sembe mome komoptopne palilamnarina, nu Saelba Uhiropne ponekoap ma'altalamapne sembe awi uro wamlulom. Tam nene mome toro pimna aghana, nari nen sarikto a'unag ambatsinenge na sembe ikin komdi, “A'un pelebahinun,” aro nen sap sarikto ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","A'un togtangto wapmundi, haing whi uro yae wamlulom. Sin Yahudi nimi agha nimiri ambarelamsiangdi, “Ot kon karepto kon teptangtop nimi aghabog Allahap ma'aptangtop nimi tanep,” aro ambarelamsiang nimi taneko sembe haing whi uro yae wamlulom. Sindi undo ambarelamsiangdi, nengabo kon karebiagha sisua nenehirop nimi tanekori malia sirikne ulamangdi, kam yonge saog urop nimi wamang. Sin sembe haing whi uro yae wapmundi, sindi ambarelamsiangne sik semban koma a'un togtangto wamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Sindi ambarelamsiangdi, “Kon karepto kon teptamun taneogna, Allahap ma'aptangtop nimi talulom,” alamang aghana, nunna Allah Yame Walingeri yeplamsilba, Allahri wepto poghogne Kristusag wana saingnia seneraglamapti, Allahap ma'aptangtop nimi wamap. Kristus Yesus ponekoag wana saingnia seneraglamapti, paliag nenelamapti, Allah Eldamne Yame Walingeri yeplamsilneag agha sik uro Allah omeklamap. Allahri wepto poghogne Kristusag wana saingnia seneraglamap aghana, nimiri nongag ul piropneag wana saingnia seneraglamap kom. Sin Yahudi nimi agha kon teptangtop nimiri ambarelamsiangdi, “Kon karepto kon teptamun taneogna, Allahap ma'aptangtop nimi talulom,” alamang. Aghana nuri, “Allahri wepto poghogne Kristus ponekori Allahap nunap ma'abahinep,” aro Elag wana saingnia seneraglamebe tanena, kon teptangtop nimi sikne wamap senep. ");
INSERT INTO kkl_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Nimi nhondi el wanaag sik senelamsori, “Nari nongag ul piropne sembe na Allah whingag wali wamna,” sembanep. Undo sembanep aghana, nari undo seneraglamna kom. Nimi nhondi, “Nimi nongag ul piropneri Allah whingag nimi wali nembahinep,” sembahoba, sik uro wamso tanena, nandamne sembe olog ambatsinun. Ora nimiri nongag ul piropne ologha wamlaba, na Paulusti nongag ul piropne maikno sirik wamla. Nari nongag ulpiropne maikno sirik wamlange sembe, “Nimi ni anabiag agha na nimi wali sirikne wamna,” sembahane. Ka'ebalulom! ");
INSERT INTO kkl_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Na Israel ponekori nimi sisa liktoba taptopne wamna! Israel poneko elmabo aobare agha, elme wanaagne Benyamin nimi sisa liktoba agha mangkaneek! Mangkaneekpa Allahri samenag Abrahamag babe, Musaag babe aruksirop yubu sunsunum uro na mangaptahia, ik lin sumeneko taogpa, nanag kere kon tepto karebaneek. Nu Yahudi nimi nunisag Abraham poneko Ibraninge alamek tanena, na Ibraninge taptopne wamna. Allahri aruktop yubu Musaag ambarogpa, Musari tipto mome toro pibog yubu sembe, sol wali uro el talamsiri, sunsunum uro ulamsi. Nari sik tapto Musari aruktop yubu mome toro pibogne sunsunum uro ul palamsinge sembe “Farisi nimi,” aro kiplamneek. ");
INSERT INTO kkl_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Na undo Musa yubu elwamsiri, sunsunum uro ulamsiba, nimi nhondi babe nari ulamsinge sembe Allah yubu takto tam nanag pimnep kom. Na Allah sembe wana maikno sembahingena, “Imagne sae tanun” aro yeng sirikne nanag loloro wamneog andarina, Yesus yubu neneko orolena yubu sembahiri, “Yesusag seneragtop nimi seklebaik,” aro olamsisi. ");
INSERT INTO kkl_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Undo wamsiri, ulamsiri, samenag nari, “Allah whingag wali neneptanepne maikno nanag poloptal,” sembanep aghana, wenena undo senelamna kom. Wenena, Allahri wepto poghogne Kristus poneko Yesus, “Si nubu talul,” aro ulamna, aghana nari samenag “Wali neneptanepne poloptal,” senelamsiri ulamsinge ni neneko teba'an senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Neabene aghabog kom. Wene na el wamnangena, Allahri samenag Kristus poneko sembe salag lebogti, “Nari wepto pognenge nhon yaleri, mog so'oag nimi anabiag agha taulbahileri, mog so'oag nimi saelbamsilul,” aro salag pibogne neneko “Yesus sembe lebog,” aro el taneo. Samenag Musari aruktop yubu sunsunum uro ulamsinge, Allahri “El yalul,” seog nimi Kristus poneko sembe nang-nang aro ulamsi. Nang-nang aro undo unulamsi aghana, “Yesus neneko el Kristus wamla,” aro el taneog kom. Ane sembe ni samenag ulamsinge neneri yepneog komdi, pham ti yaroba wamloa saog senelamna. Wali sirik phelektopne nhonogne anena, “Yesus sik uro Kristus wamla,” aro el taneoba, Yesus Kristus ponekori na Saelbamnel. Nia mangkina sae limno andarina, Yesus Kristus na Saelbamnelne ponekoap sae tiptangto wamnemeri, ");
INSERT INTO kkl_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","sik tapto Elap nhon ma'aptangto wamnunam. Musa yubu mome toro pibog yubu saelbiagha nimi nhondi Allah whingag, “Malia uan komdi, sik urop nimi wamna,” senep kom. Nari babe samenag Musa yubu saelbamsiri, ulamsingeag agha “Nimi sikne wamna,” senun kom. Aghana nari Yesus sembe sik senelamnari, “Allahri wepto poghogne Kristus wamla,” aro seneraglamna andarina, nanap Yesus Kristus ponekoap ma'aptangto wamnam. Nari Yesusag “Sikne” aro seneragtopne nene sembe Allah Eldamneri nanag ililamneldi, nanap Kristusap ma'aptangto wamnamne ililamsildi, na sembe “Porog urop nimi,” senelamnel. ");
INSERT INTO kkl_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Ot nhonog nanag taho senelamnangena, Allahri wepto poghogne Kristus poneko el tahaneri, sae tiptangto wamseneme senelamna. Allah Eldamne Yame Walingeri Yesus Kristus teptobag agha kamag nembaonge mikipne neneko nanag babe taho. El samenag seklero tebaog saog uro na babe El sembe seklero tebahane andarina, ");
INSERT INTO kkl_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","El samenag teptobag agha kamag taogne saog uro na babe kamag tahane senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Nari lemnange nenena, “Ni ane nanag uro yaboho senenne nanag taoba, Allahri nanag komopto tobitnel,” alamna kom. Aghana nari tipto ulamneba, “Yesus Kristus ponekori na sembe wero tatnilulne tomnun,” aro anam ultongolamna. Nene sembe na taluro tomneori Eldinge nembaneo. ");
INSERT INTO kkl_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Nangkabo a'un Yesusag seneraglamlomne, nari sik uro seneragamnangena, “Na sembe weroba wamlange tatnelulne neneko na saeag tal,” senelamna kom. Aghana ot nhonog nari uanunne wamla. Uanunne wamlangena, na wailag wamlange sembe limneri, saramag wamlange sembe mikip uro ulamnun senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Ane sembe, “Komobitneba na sembe weroba wamlange na saeag talul,” aro kilim weanga ambatto tongolamna. Na saeag tatnelulnena, “Allah imag ua urobag kamag uro nhon wamnunam,” aro Allahri Yesus Kristus pere agha na taluro yopneog. ");
INSERT INTO kkl_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Nangkabo, nu ni Yesusag wana saingniro wali uro seneragnep nimi wamap tanena, weneog lemnange sunsunum uro seneraglamukap. Aghana nangkabo, nari lemnange sembe saelbanep komdi, saekag kom tanena, hae, Allahri tam nene sembe a'un tibin nembatsilul. ");
INSERT INTO kkl_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Ot wenena, nunag tibin nembahioba, nunag wamlange sunsunum uro saekag wameberi, ulamukap. ");
INSERT INTO kkl_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Nangkabo, a'un Yesusag seneragtop nimi. A'undi babe nari ulamnaba kembamnelomne sunsunum uro ulamlulom. Nuri sikne agha ul palamoboa sunsunum uro ultongolamang nimi babe ipsimun tanena, sin sembe babe wailag nembahin koma kembamsimundi, sunsunum uro ulamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","“Nuri ulamapne kembamsimundi, sunsunum uro unulamlulom,” aro ambatsinnena tam nene sembe. Samenag nimiri Yesus kalag sibekpa, nu sembe tebaog aghana, nimi maiknori ul palamangne pere agha nu sembe tebaogne poneko aisa nenelamang. Undo ul palamangneag agha nari wana saplamnelba, samenag ik sulu ambarelamsino saog uro wene babe hail mag tiniro ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Sin undo urop nimi eneri mog so'oag nimi nongagne sembe wana to'opto seneraglamangdi, “Na mon sek,” senenne omekto tena aboap ulamang. Sindi ali nenero ul piropne sembe maibiltalamang. Undo ul palamangneag agha sirikagne seklero loba taukang. ");
INSERT INTO kkl_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Aghana nu Allah Elmabo wamapti, nuringe as singkiknena, El imag wamlange ponekoap nhon wamukabag wamla. Anikoa nu Taluro Saelba Uhiropne poneko Yesus Kristus amik yalul aro seneraglamapti, wana yeng uro tibogto El yalulne sembe nang-nang alamap. ");
INSERT INTO kkl_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","El yalulne poneko saeag mikipne wamla andarina nia mangkina El umag nembahilul. Mikipne nenekoag agha nuri nong kon polbanepne nene El imang warero polbanep kom nong saog uro nembahileri, wendog nembahilul. ");
INSERT INTO kkl_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Nangkabo, a'undi Yesusag wana saingnia seneragtop nimi! A'un sik nari o'ona sembamsin nimi wamlomne, nari wanaag “A'unap sik uro haibiltahabe,” yeng uro senelamsin. A'unna na sembe, nari kilim weang ambarel tongolamnonge sembe kamna nubunge nanag tatneloa saog wamlom. Nangkabo nimi wanaagne wamlomne, nari wana a'unag yeng nubu sirikne nubu wamla. Ni Yesus nu Saelba Uhiropne sembe ambatsinne neneko seneraglapmundi, “Yesus nen samoro yaleba, Elap nhon El umag ya'ag wamukap,” aro nang-nangaro khaepto wamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Nuninyabo Euodiaap Sintikheap kelabo abeneko sembe a'undi yubu leptangtopne sembe mali semban. A'un abeneko Yesus nu Saelba Uhiropne ponekoap ma'aptangtop kelabo wamtom ane sembe, nari wenero mololamsinnena, “A'undi saekag lero wana aingnibarurom,” aro wenero mololamsin. ");
INSERT INTO kkl_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Nangkae Susugos, an wana wali uro sol wali uro nanap nhon tolamnam. Anag moloro ambarelangkennena, “Andi sin kelabo phende tipto a'eptaikagti, yeplamsululam,” aro mololangken. Sin kelabo abeneko nanap nhon Yesus Yubu Walinge sembe kilim weanga ambarel tolamobongena, nungkae Klemenap, nimi orangeapti nhon tolamobo saog uro sin kelabo abenekoapti babe tolamobo. Sin nanap nhon awe tolamobo nimi neneko, sindi si Allahri el wamsildi, “Na Allahap nikag wali urobag ya'ag uro kamag wamukap,” aro nimi si mome toro pibogneag sindi si wamla. ");
INSERT INTO kkl_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","“A'un wana ikin uro wamna koma, sop-sop wana yeng uro wamlulom,” alamna! Nen sap sarikto lemnun. A'un Yesus nu Saelba Uhiropne ponekoap sae tiptangto wamlom ane sembe, “Wana yeng uro wamlulom,” alamna! ");
INSERT INTO kkl_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Yesus nu Saelba Uhiropne poneko yanepne peram wamla ane sembe, nimi niag ulamsimunne, a'undi wanaag agha win-win aro ulamsululom. ");
INSERT INTO kkl_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Nia mangkina sembe wana tai pailangkang tau pailangkang uan koma, kwema ulamsilea sembe Allahag molona mololamlulom. Nia mangkina a'undi wana seneragnaag wamlange sembe a'undi wanaag agha “Nuni Allahri nunag walia ulamsil,” aro lelapmundi, Allahag molona mololamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Undo Allahag mololapmun tanena, a'un Yesus Kristusap ma'altalamlomdi, sae tiptangto wamlomne sembe, Allahri a'un wana aingnilamsilul. Allahri wana aingnilamsilengeag agha a'undinge wanaap seneragnaap yae paiamsilul. Allahri nimi wana aingnibahinepne neneko sembe mog so'oag nimiri seneragnep kom aghana, Allahri a'un wana aingnibahileri, yae wamsilul. ");
INSERT INTO kkl_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Nangkabo, Yesusag wana saingnia seneragtop nimi. Komoptopne ma'aro pimnuan. A'undi seneraglapmunnena, tam nene sembe seneragamlulom. Nia sikne wamlange Nia sunsunum uro wamlange Nia porog uro wamlange Nia walinge aghabog malinge ma'aban koma wamlange Nia holno aropne wamlange Nia nimiri maipnepne wamlange Tam nene wali sirikne, nimiri wali aro paliag neneropne wamla tanena tam nene sembe wana to'opto seneraglamlulom. ");
INSERT INTO kkl_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Nari yubu a'unag ambarelamsinoba, ka'eamomdi, tolamomne sunsunum uro ul palamlulom. Nari ulamnoba, ililamneomdi, el taomne sunsunum uro ul palapmunba, Allahri wana aingnilamsileri, a'un yepto paiamsilul. ");
INSERT INTO kkl_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Nanap nu Saelba Uhiropne ponekoap ma'aptangto wamnari, na yeng sirik wamnelnena, ko'o maikno uro yabio aghana, wene a'undi na wamnange sembe seneraglamnelomdi, yeng sirik nembamnel. Nari lelamnange nene, “A'undi na sembe ekon taneom,” aro lelamna kom. A'undi na sembe elwamnelom aghana, a'un nanag whing pailanepne ekaukti, ko'o maikno uro yabioba, weneog pibom. ");
INSERT INTO kkl_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Nari lelamnange nene na kwema wamnelne agha lelamna kom. Nanag sa'a-sa'a kwema samenag ulamneogne agha “Nu Saelba Uhiropne ponekori yepto piamnel” aro eltalamsi. Ane sembe, naba nanag wamnenne abeneko agha “Mampul uro ua uanun,” aro lelamna. ");
INSERT INTO kkl_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","13","Nari samenag na ua unne abene ni yambahi. Kwema uro unne to, na saeag kwema koma sa'a-sa'a wamnaba unne to, abenena tam nhon nanag lag tao. Samenag nimi maiknori ekonne tognoropne nhon nanag lag taoba, lag phoro ambatsinuan. Sa'a-sa'a nanag uro yabilenge, kwaneng yo babe, mon og teneba babe, tam ikinne babe, ikin komne babe nanag uro yabileba, nu Saelba Uhiropne ponekori mikip nenelamnelne agha nari sangsang ul palamneri, mampul uro wamnun. Tam nene nanag lag taoba, lag phoro ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Tognoroba nene el tahiri, lag ambatsin aghana, a'undi na kwema wamnoag a'undi na yepneom. A'undi na yepto uaomne wali sirikne agha uaom. ");
INSERT INTO kkl_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Filipi nimi nangkabo! Samenag a'unag Yesus Yubu Walinge ambatsisiba, ka'ebalum sumeneko sembe a'undam nimi el wamlom. Samenag nari, “Yesus Yubu Walinge ambarel phunun,” aro a'un wamlomag Makedonia so'o agha lanaro palamsiba, Yesusag seneragtop nimi poloptangtop nimi yogneri yepto tatneek komne, a'un babe elwamlom. Ni Yesusag seneragtop nimi poloptangtop nimi agha, ot a'un nhonogti na yepneom. ");
INSERT INTO kkl_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Na as kota Tesalonika wamsiag babe, a'undi “Kwema elag ualeag,” aro na yepnenne ik etpare palilamnelum. ");
INSERT INTO kkl_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Nari sembamnangena, “A'undi na sembe pimnehengba, na toltoneog,” sembamna kom. Nari sembamnangena, “Kal wana maubaloa saog uro a'undi walia unne maupto palilamlomne wana yeng uro imnun,” senelamna. ");
INSERT INTO kkl_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Na kwema wamneonge sembe a'undi ni pimneomne tomno. Apna phelektopne babe pimneom. Na sembe ni pimneomne Epafroditusti payaonge tomno. Wenena nanag ni kwema wamneonge ni saeag taoba wamna. A'undi na sembe ni palilamnelomne nenena Allah sembe song walia taroba saogne wamla. A'undi na kwema wamneonge sembe pimneomne nenena, “Allah sembe tarukap,” aro wali pibomdi, Allahri wana yeng neneropne pibom. ");
INSERT INTO kkl_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","A'undi “Allah sembe pibukap,” aro yepneomne sembe Allahri na yae piamnelne ponekori a'unag kwema ulamsilenge babe teknero yeplamsilul. Allahri saeag nia mangkina wamlaba, Yesus Kristus saeag maiknoro phelekto pibog. A'un Yesus Kristusap ma'altalamlomne sembe a'unag kwema uahinepne ni teknero yeplamsilul. ");
INSERT INTO kkl_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Nuba Nuniong Allahri nu yae piamsilne poneko ya'ag uro omeklamebe paghabog kiplamukap! Sikne agha saekag lebap. ");
INSERT INTO kkl_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Nangkabo! Allahri “Nari mabo taukang” aro werop nimi, sin Yesus Kristusap ma'aptangtop nimi ni sembe, nari kiplamsinne nene ambatsululom. Nangkabo Yesusag wana saingnia seneragtop nimi nanap nhon wamapne babe a'un kiplamsiang. ");
INSERT INTO kkl_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Yesusag seneragto Allah Elmabo taong nimi as kota eneag wamangne niri a'un kiplamsiang. Sin yubu sia leropne Kaisar ponekori ae yae ua urop nimi sin mori babe kiplamsiang. ");
INSERT INTO kkl_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Nangkabo, “Yesus Kristus nu Saelba Uhiropne ponekori a'un niag wana waliri ulamsileri nong ningki piamsilul,” aro a'un sembe molbarelamsin. Abenda. ");
INSERT INTO kkl_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Nare yabo nangkabo! Nuni Allah Elmabo taom nimi a'un as kota Tesalonika wamlom nimi Allahri, 'Taulbahimendi, saelbamsululam,' aro wepto poghogne Yesus ponekori taulbahaio. Allahri samenag Yesus webogti, “Mog so'oag nimi agha taulbahaimendi, saelbamsilulam,” aro poghogne Yesus yaogne sembe si Kristus aro engero yabiog. Yesus Kristus poneko mog so'oag yaogti, a'unap nunap taulbahiogpa, nu Paulusap Silasap Timotiusapti Allahag mololamapti, “Allah wana waliri a'un wana aingnilamsilba, wali uro wamlom,” aro Allahag molona mololamap. ");
INSERT INTO kkl_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","Nuri a'un sembe ekon talamap komdi, sop-sop Nuni Allah nuringeag nuri “Wah Naniong” aro Allahag a'un ni sembe molona molbarelamsiap. A'un sembe ekon talamap komdi seneragha ulamsiapnena: A'undi unna ulamlomne sembe kemelamsibongena, a'undi Yesus ponekoag sikne aro seneraglamlom. A'undi Yesusag seneraglamlomneag agha, wali-walia ulamlomdi, a'undi nimi yogne sembe o'ona senelamsilomdi whin seklero yeplamsilomba, kemelamsibo. Apna a'un eraruk uro wamlom aghana seneragha ulamlomne, “Allahri wepto poghogne Yesus Kristus nu saelbamsilne ponekori nu yepsilul,” aro sik senelamlom ane sembe, mikip uro wana paia ulamlom. A'undi Yesusag sik senelamlomdi, wali-walia ulamsilomdi, mikip uro wana paia ulamlomne sembe ekon talamap komdi, a'un sembe molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Nangkabo, a'un sembe nu elwamapne, Allahri a'un sembe o'ona senelamsiori wepsio andarina eldamneringe aghabog taom. ");
INSERT INTO kkl_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Allahri “Taulbahinun,” aro a'un sik uro wepsiogne sembe nu el wamap. Allahri sik uro a'un wepsiogne sembe nu el wamapne tamna ane sembe. Nuri a'unag Allah Yubu Walinge Yesus sembe ambarelamsiapnena pamag yubu aghabog kom. Yesus sembe ambarelamsiapnena, sik uro seneraglamapti, Allah Eldamne Yame Walingeri mikipneag agha haingdi imnepne ulamapti ambarelamsiap. Allah Eldamne Yame Walinge mikipneri nu pere agha haingdi imnepne a'un whingag ulamog ane sembe, Allahri a'un sik uro wepsiog aro el wamap. Nu a'un anabiag wamobori, a'un sembe ulamobonge a'un ni elwamlom. ");
INSERT INTO kkl_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","A'undi babe nuri ulamobonge ipsiomdi, nelepto ulamlom. Nuri ulamobongeap, Yesus nu saelba uhiropne ponekori ulamogneap saog uro a'undi nelepto ulamlom. Yesus Yubu walinge ambarelamsiapba, ka'elamlomba, seklenne a'unag lag talamlaba seklelamlom. Seklelamlom aghana Allah Eldamne Yame Walingeri a'un yeplamsioba, Yesus yubu walinge ambarelamsiapne nene wana yeng uro a'undi salelamlom. Wana yeng sirikne nene Allah Eldamne Yame Walingeri a'unag tarelamsil. ");
INSERT INTO kkl_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Wana yeng sirikne neneko Allah Eldamne Yame Walinge nenekori tarelamsilba, Yesus sembe ambarelamsiapne seklero salelamlom. Undo ulamlomba, Yesusag seneragtop nimi propinsi Makedonia wamang nimiap, propinsi Akhaya wamang nimiapti a'un ul palamlomne sembe ka'elamsiang. Ka'elamsiangdi sindam nimiri, “As Tesalonika Yesusag seneragtop nimiri ulamangne saog uro nuri babe nelepto ulamukap,” senelamangdi ulamang. ");
INSERT INTO kkl_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Akhaya nimiap Makedonia nimiapti a'un sembe ka'elamangdi, “Nuri babe nelepto ulamukap,” aro ulamangba, a'undi unulamlomne yubu eneko Makedoniaap Akhayaap sabo tangto palamoa wene babe palamla. Sabo tangto palamla yubu eneko abene aghabog kom. A'undi wana paia seklero ulamlomneag agha yubu lilim lonceng oleanne saog uro yubu nu saelba uhiropne poneko Yesus sembe yubu sabo tangto piog. Sabo tangto piogpa, nimiri ka'elamangdi, “Tesalonika nimiri Allahag sik uro seneraglamang,” alamangba, yubu eneko nen tipto tala-tala sabo tangto piog. Sabo tangto piogpa, nuri tala-tala Yesus sembe ambarelamsiboag nimi wamang nimiri ka'ebong. Nuri nimiag “Tesalonika nimiri ulamangne sembe ambatsukap,” aro ambarelamsibo aghana, “Ka'ebabo,” alamong. ");
INSERT INTO kkl_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","El wamang ane sembe nuri a'undi ulamlomne sembe nen yubu tipto ambatsisebe koma babe hae sembamap. Nimiri a'un sembe el wamangdi lelamsiangne, nu a'unag yabuba, nu a'undi topsilumne sembe, “Wali kipsiek” aro a'un sembe nimiri lelamang. Nimiri a'un sembe yubu lelamangnena, “Tesalonika nimiri mem phalamekne laplobi agha samoro Allah ot nhonog kamagne ponekoag samoro yaekti, nimi yepsiro Allah omeklamang,” alamang. ");
INSERT INTO kkl_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Sindi babe yubu lelamangnena, a'un Tesalonika nimiri seneraglamlomdi, “Allahri Elme Yesus nimi teptobag agha kamag nembaogti, imag agha kiliro tobogpa, imag agha Yesus amik samoro yalul,” aro a'undi nang-nangaro ulamlomne sembe babe nimiri yubu lelamang. Yesus Allahri kamag nembaogne poneko, nu mog so'oag nimiri mali-malia ulamapne sembe Allahri, “Opsinun,” sembaog aghana, nu mog so'oag nimi pelebahainun aro Yesus nu lunuro tebaogti, kamag taogti, nu peleplamsil. ");
INSERT INTO kkl_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Nangkabo, nuri Yesus sembe a'unag ambarel ahibunge, teba'en uro amberal ahibu kom. A'undam nimi elwamlom. ");
INSERT INTO kkl_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Nu anam Tesalonika a'unag yan komag as Filipi wamububa, nun san tiliplamsiekpa seklero wamubunge sembe a'un elwamlom. Nimi maiknori san tiliplamsiekti iriklamsiek aghana, Nuni Allahri nu wanaag log kom nembahiog. Log kom nembahiogpa, Allah Eldamne Yubu Walinge Yesusti nimi talulamsilne sembe a'unag ambarelahibu. ");
INSERT INTO kkl_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Nuri a'un ambarelamsibungena, ogtopne agha kom. Apna liptop yubu mane yubu agha ambatto, “Nimiri saeag agha walinge topsukap,” aro orolena yubu ambarelamsibu kom. ");
INSERT INTO kkl_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Nuri ambarelamsibunge nimiri, “Nun dam nimi sembe wana wali sembaukang,” aro ambarelamsibu kom. Nuri ambarelamsibungena, “Allah nu wanaag miplamsilne wana wali yeng sembalul,” aro ambarelamsibu. Nunag Allahri sembamsiognena, “Wali. Hae Yesus yubu walinge sembe ambatto sol wali uro sik uro sabo nembaukang,” sembamogpa ambarelamsibu. ");
INSERT INTO kkl_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","A'un babe elwamlom. Nuri pamag agha “Nimiri wana topsukap,” aro emem arop yubu lerop kom. Apna nuri aboaba sembe tognoro nhon lenne babe orog. Allah nun ipsiogne wamla. ");
INSERT INTO kkl_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Nuri ulamubungena, a'undi babe, nimi orangeri babe, “Nu kibiang towalengkipsiseng,” aro ero ulamubu kom. Allahri samenag Yesus wepto “Nimi so'oag nimi taulbahimendi saelbamsululam,” aro poghogpa, El yaogne ponekori nu wepto pogsiogti, nunag mikipne tatsiog. Mikipne nunag tatsiog ane sembe nunag kwema ulamsoba, “Tatsiseng,” aro nuri a'unag molbahinep. Aghana a'unag molbahibu komne a'un elwamlom. ");
INSERT INTO kkl_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Mikipne nunag tatsiogneag agha a'unag molbahainep aghana, nu a'un anabiag wamubunge ilindi elme win-winna pia uropne saog uro piamsibu. ");
INSERT INTO kkl_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Nu a'unap nhon wamuburi, ulamubunge Allahringe Yubu Walinge pamag aghabog ambarelamsibu kom. Pamag agha ambarelamsibu kom aghana, a'un sembe o'ona senehinne loloro wamogpa, nia nuri nong mikipneag agha “Yepsukap” aro a'un sembe ulamuburi, ambarelamsibu. ");
INSERT INTO kkl_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Nu whin seklero ulamubunge nene sembe a'un ni elwamlom. Allahringe Yubu walinge a'un ambarelamsibunge, “A'un nimi nhonag babe nu sembe saeagha seneragsukang kom,” aro sinag kweleknag whin seklero ulamubunge a'un elwamlom. ");
INSERT INTO kkl_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","A'un Yesusag seneraglamlom nimi anabiag wamububa, a'undi haingdi babe iamsilumba, Allahri babe nu iamsiogpa ulamubu. A'un anabiag wamuburi, “Allahri uaukang senenne sunsunum uro uaukap,” senelamuburi sikne aghabog a'unag ulamsibu. Ane sembe nimi nhondi babe nuri a'un anabiag wamuburi, ulamubunge sembe “Malia-malia undo-undo ulamek,” senep kom. ");
INSERT INTO kkl_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Me ologne agha iliri yubu wenerop saog uro nuri a'un nimi nhon-nhon a'ero wenelamsiburi, a'un wana aingnilamsibu. Ane sembe nari “Sikne aghabog a'unag ulamsibu,” aro sik uro lelamnange sembe a'undi babe el wamlom. Eraruk uro wamlumba, yubu ambatto yeplamsibu. A'un wana ikin uro senelamlumba, wana aingnilamsibu. Sik komne salelamlumba, wenelamsiburi, “Nuri 'Unulamlulom,' aro ambarelamsibunge sunsunum uro ulapmundi, Allah wana yeng nembamlulom,” aro yubu mikip uro ambarelamsibu. Allahri a'un yoplamsildi, “Na Allahri yubu ka'ebamundi, Nandamne Yesus wepto pogsinge ponekoag sikne aro seneraglapmun tanena, Nari a'un wali uro saelbamsunun. Saelbamsineri, Nandamne imang wareropne ua urobag ya'ag nhon wamukap,” aro Allahri a'un yoplamsil. Ane sembe a'undi, “Allah wana yeng nenelamukap,” aro ulamlulom. ");
INSERT INTO kkl_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Tam nhon wamlange uro yabionge nenda sembe Allahag “Nuniong, wah” aro sop-sop molona lero kiplamap. Tam neneko uro yabiongena, nuri Allah Yubu a'unag ambarelamsiboba, yubu ambarelamsibonge neneko sembe “Nimiri yubu mo,” semban koma lipsiom kom. Nuri yubu ambarelamsibunge neneko sembe a'undi “Sik uro Allahri yubu ambarelamsiang,” aro ka'ebaomdi saelbaom. A'undi Yesusag “Nimi so'oag nimi taluro saelbahainepne,” aro seneraglamlomba, Allahri yubu enekori a'un nongag awe tolamla. ");
INSERT INTO kkl_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Nangkabo, Yahudi nimi mog so'o Yudea wameknang agha Yesus Kristus ponekoag seneraglamekpa, Yesus Eldamneringe taek. Eldamneringe taek nimi tanekoag samenag Yahudi nimi agha Yesusag seneragtop kom nimiri sinag malia ulamsiek. Yudea mog so'oag agha babe Yesus Eldamneringe taek nimi tanekoag Yahudi nimiri malia ulamsiek saog uro a'un Tesalonika nimiag babe Tesalonika nimiri malia ulamsiong. A'un seklena seklelamomnena, a'un sisa nimiri ulamsiongba, seklelamom saog uro sin Yudea Allah Elmabo taek nimi babe sin sisa nimi Yahudi nimiri “Seklebaik” aro ulamsiek. ");
INSERT INTO kkl_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Undo unulamsiek nimi tanekori nu Saelba uahiropne Yesus babe obekti Allah silimu tiptop nang babe olamsiekti nu babe seklelamukang aro olamsiek. Sindi nimi ni sembe aisa nembamsiekpa sin sembe Allahri babe karong sembahaiog. ");
INSERT INTO kkl_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Unulamsiekti nimi tala-tala uropne Yahudi sisa kom nimiag Yesus yubu ambatto taluro sae kilihin yubu ambatsinepne neneko iriklamsiek. Sindi undo ununa aghabog ulamsiekti Yesus yubu ambatsinne iriklamsiek ane sembe sin Yahudi nimiri malia ulamsiekne neneko leng-lenga langaro walelaori teknebaoba, wene Allahri sinag tam ikinne pelengenne aghabog wamla. ");
INSERT INTO kkl_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Nangkabo, a'un sembe “Nundam mabo,” senelamsiap pog, nimiri nunag malia ulamsiekne sembe nu sesog saog uro a'un laplobiagha yahiburi, haingdi ipsinep kom saog wamla. Haingdi ipsinep kom aghana, a'un sembe ekon tan koma wana to'opto o'ona senelamsiap. “Nu a'un wamlomag yaberi kemelahukap,” senelamobonge nu wanaag nubu uro lololtalamori, ngenohom alamsioba, otsik sol wali uro sunulamobo. ");
INSERT INTO kkl_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Nuri a'un kemelahukap sembabori, ik phende wilindi na yanun sembanori sumbano aghana, phia sikini nubunge ponekori nu ina irikahio. ");
INSERT INTO kkl_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","A'un sik uro a'un nuri nimi wanaagne wamlomdi, nuri wana yeng sirikne nubu nembahaiomba, nuri wana a'unag wamla. Yesus nu saelba uahiropne poneko yalamle sumeneko a'un Yesus yubu mikip uro salelapmunne sembe wana yeng uro wamukap. El whingag nhon wameberi, a'un kembiagha, “Sol wali, wali uro ambatto tolamobonge wali uro tobirobo,” sembaukap. Ane sembe otsik uro a'un kemelahukap senelamobori sol wali uro sunulamobo. ");
INSERT INTO kkl_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","A'undi nu wana yeng sirikne nubu nembahaiomba nuri wana a'unag wamlaba, a'un sembe seneraghi agha wali tolamobo senelamap. ");
INSERT INTO kkl_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Nuri wene sembabonge neneko ta'apsenep kom uao. Ane sembe nuri seneraghabori na Paulusap Silasap, “As Atena mo wamnemeri, ");
INSERT INTO kkl_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","nunkae Timotius mo pognunam,” sembanomo. Nunkae Timotius nunap Allahringe awe tolamubunge poglamnomori, “Yesus Allahri wepto poghogne poneko sembe yubu walinge Timotiusti ambarel philul,” sembanomori pognomo. “A'un Tesalonika nimiag ambarelamsileri, a'undi wanaag Yesus sembe seneragnange wembahileri, mikip nembahailul,” sembanomori pogholanomo. ");
INSERT INTO kkl_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Nuri poghol anomongena a'un Tesalonika nimiri Yesusag wana seneraglamlomne sembe seklenna a'unag lag taoba, “Yesus sembe ambarelamsiapne libukang kom,” aro Timotius a'unag pogholanomo. Yesusag sikne aro seneragtop nimiag seklenne lag talamlenge sembe a'undam nimi el wamlom. ");
INSERT INTO kkl_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Nu a'unap nhon wamuburi, samen anamag, “Nuri Yesusag sikne aro seneraglamapne sembe ora nimiri malia ulamsiikpa, seklelamukap,” aro ambatsibunge neneko sik uro wene a'unag uro yabalamlaba a'undi haingdi babe ililamlom. ");
INSERT INTO kkl_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Ane sembe nari a'un sembe “Welaro wamang” senelamnori, ta'ap senep komdi, Timotius poghol anongena, “A'undi Yesusag wana seneragna kembahainun,” aro pogholano. Na log ulamneongena Yesus yubu saelbamlomne sembe nimiri a'un “Seklebaik,” aro ulamsiangba, phia sikini nubunge ponekori a'un sae kililamsileba, a'unag ambatsibunge “Libikag,” senelamnonge sembe Timotius pogholano. ");
INSERT INTO kkl_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Timotius pogholano aghana wene Timotius samoro yaori yubu walinge yeng sirikne a'undi Yesusag seneraglamlomdi nimi o'ona senero yepsinne ulamlomne sembe ambatsioba yeng senelamap. Wene senelamlomdi nu sembe wanaag uro seneraglamsilomba, “Nuri sinag pheberi, sinap nhon haiptahabe,” senelamap saog uro a'undi babe, “Sin nunag yahengba, haiptahabe,” senelamlom. ");
INSERT INTO kkl_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Ane sembe nangkabo, nimiri nunag malia ulamsiangba, nu ua unag erarukag seklena seklelamabag yubu a'undinge Yesusag seneraglamlomne neneri wana aingnilamsil. ");
INSERT INTO kkl_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","A'undi Yesus nu Saelbamsilne ponekoag seneragna wamlaba, “Nuri ambatsibu yubu eneko ka'ero ulamangdi, Yesusap sae tiptangto seklamang,” aro nu babe wana aingniro kamag wamap senelamap. Ane sembe a'un otsik uro Yesusap sae tiptangto sekamlulom. ");
INSERT INTO kkl_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","A'un Yesusap sae tiptangto wamlomne sembe nuri wana yeng along wamapti, nuri nongag mikipne ni wamlangeag agha a'un sembe Allah omeklamap aghana sunurop kom sembamap. ");
INSERT INTO kkl_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Sinag kweleknag a'un sembe nu nong ningkiri Allahag molona mololamap nena, “Yesusag wana to'opto seneraglamangne sembe ekon uro wamikagti, nen haiptangto ma'aro wamseberi, Yesusag wana seneragna sembe nen ma'aro ambatsisebe,” senelamap. ");
INSERT INTO kkl_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Nuni Allah Eldamneap Elme Yesus nu Saelbamsilne ponekoapti nu ina pa'abatsurukang aro mololamsiapti, wali sembarikpa, a'un kemelahukap. ");
INSERT INTO kkl_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Nari yeng senelamnangena, Yesus nu Saelba uahiropne ponekori a'unag nimi o'ona senehinne ma'aro sirilamleri tarelamsileba, nuri a'un sembe o'ona senelamsiap saog uro a'undi babe a'un-a'un wana piptangka o'ona seneldalapmundi, nimi orange babe wanaag o'ona sembamsululom. ");
INSERT INTO kkl_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","A'un sembe molbarelamsiapnena, “Yesus nu taluro saelba uahiropneri a'undi seneragna wana mikip nenelamsileri, Yesusti 'Tam karebanun,' aro yalamle sumeneko Yesus Elag seneragtop nimiap nhon yaikpa, Nuni Allah whingag malia uan koma wali uro wamlulom. Nuni Allah whingag wapmunba, a'un sembe 'Namabo' sembahilulba, nimi nhondi babe a'un sembe malinge uaong aro tam pimnep kom,” aro a'un sembe molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Nangkabo, nuri ambarelamsibunge, “Allahri uaheng senenne sunsunum uro otsik uro ulamlulom” aro ambarelamsibu. Nuri ambarelamsibunge sunsunum uro ul palamik kom nimi Allah wana wali nembanep kom. A'un wene nuri ambatto ulamobonge sunsunum uro ul palamlomne wali. Nuri a'unag Yesus nu saelbamsilne mikibag agha a'unag mololamsiapnena nen ma'aro wali uro ulbalamlulom. ");
INSERT INTO kkl_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Yesus nu saelbamsilne mikibag agha a'un haingag agha “Ualulom-ualulom,” aro ambarelamsibonge ka'ebaomdi, el wamlom ane sembe nen sol wali uro ul palamlulom. ");
INSERT INTO kkl_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Allahri seneropne ane: “Na Namabori Na wana yeng neneropne aghabog ulamukang,” senenne a'undi ulamlulom. Unulapmundi, a'undi salik-malik kelaboap nengaboap mapseng kom. Nengabo eldamneri kelap aghabog nhon ma'al talamtukangba, kel eneko ela'angeap aghabog nhon ma'al talamtukang. ");
INSERT INTO kkl_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Kabuniri kelabo toamle tanena ela'angeriba elkeldiba kelabo nengabo orange sembe “Topsisene, saelbahaisene,” aro wana sesog uro seneragna koma Allah wana wali nenenneap sik uropne nimi wana wali nenehinneap agha seneraglamlulom. Undo seneraglapmundi, ela'angeap elkelap nikag wamturom aro ma'amsika uro wali uro wamlulom. ");
INSERT INTO kkl_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Allah sembe ekon uro urop nimiri kelabo nengabo sembe Allah senenne semban koma “Saelbahisene” aro sindi wana yorolamsilba salik-malik kelabo nengabo tolamsiang aghana a'un Allah elmabo wamlom. Ane sembe Allah ekon uro urop nimiri ulamangne saog uro ulamseng kom. ");
INSERT INTO kkl_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","A'un Yesusag wana seneragtop nimi wamlom ane sembe a'un kabo nimi haing pesah iogha lepsimundi a'un kabo ingisapsilo saog uro a'un kabori kelaboro sa'a-sa'a topsiseng kom. A'un kaboag otsikne agha ualulom. Tam nene sembe otsikne agha uamun kom tanena, a'un kaboag malinge uamunne sembe amik Yesus tam karepto nu saelba uahiropne ponekori a'unag tam ikinne piplul aro wenero ambatsibunge a'un elwamlom. ");
INSERT INTO kkl_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Allahri nun nimi yopsiogne, “Mali-malia ulamukang,” aro nun yopsiog kom. Nun yopsiognena Allahri “Nadamneri seneropne sunsunum uro ulamikti, yeng nembanukang,” aro yopsiog. Ane sembe, Allahri seneropne sunsunum uro ulapmun komdi, a'unkabo ingisapsilo saog uro ulapmunba, Allahri a'unag tam ikinne piplul. ");
INSERT INTO kkl_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Nengaboap kelaboap salik-malik ma'aptaheng kom aro ambatsinne nene sik uro lemna. Nimi etneri yubu ene sembe karong sembaleri liple tanena nimi agha karong sembaikti wa'epto libukang kom, aghana Eldamne Yame Walinge a'un tarelamsilne neneko Allah waepto ebukang. Ane sembe wali uro ka'eapmundi, yubu ene saelbamlulom. Nengaboap kelaboap ma'aptanepne sembe komopto ambatsin. ");
INSERT INTO kkl_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Wene, a'undi o'ona seneltalamlomne sembe olog ambatsinun. A'undi a'un kabo Yesusag seneragtop nimi sembe wanaag agha o'ona seneptangka un yubu ene sembe Allahri a'un samenag elnembahaioba, wali uro ka'ebaomdi, yubu ene sunsunum uro ulamlom. Ane sembe o'ona seneptangka un yubu ene sembe a'unag nen sap mome toro pibukap kom. ");
INSERT INTO kkl_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Nimi wanaag agha o'ona senehinne yubu ene sembe a'un kabo Yesusag seneragtop nimi tala-tala mog so'o propinsi Makadonia wamang nimi sembe o'ona senelamsilomdi, uaom. Aghana nangkabo, nuri a'unag nen mololamsiapnena, “Nen tipto nimi o'ona senelamsumundi, walinge unne aghabog a'unag loloro wamleba ulamsululom,” aro mololamsiap. ");
INSERT INTO kkl_vpl VALUES ("H14_11","082_4_11","1TH","4","11","12","A'undi “Uahabe,” ulomlulomnena, undo-undo ulamlulom. A'un aingniro wapmundi tam yogne ora nimiag uro yabalamlenge sembe salel wa'in koma, tam a'undinge ul palamlulom. Samenag nuri a'un ambatsibu saog uro, nimiri tisirikag agha a'un wamlulom kom aro ambatsibu. Ane sembe teko a'unag uahileagti, a'un dam nimi saeri ul piro wero mero tero wamlulom. Undo-undo unulapmunba, Yesus yubu ekon nimiri kembahikti a'un sembe sindi wali sembahaukang. ");
INSERT INTO kkl_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Nangkabo, nuri seneraglamapne nimi samenag tebaekne sembe a'un babe eltahom sembamap. Yesusag sikne aro seneragtop kom nimiri, “Teptop nimi nen kamag taukang kom,” aro amang ul palamang. “Kamag taukang kom,” aro amang ul palamang aghana a'un Yesus kamag taogne ponekoag seneragtop nimi wamlom. Ane sembe mog so'oag nimiri wene amang ul palamang saog uro ulamlulom kom. Sin samenag tebaekne sembe eltahom aro sik uro ambarelamsukap. ");
INSERT INTO kkl_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Nuri sik uro seneraglamapne Yesus tebaog aghana kamag taog aro seneraglamap. Ane sembe nuri seneraglamapnena Yesusag sikne aro seneragtop nimi tebaiik aghana nen amik Allahri kamag nembahaileba, Yesus nen samoro yalamle sumeneko Allahri embahaileba, Yesusap nhon yaukang. ");
INSERT INTO kkl_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Nimi nen amik kamag nembahailulne nene sembe Yesusti ambatsiogne nuri a'un ambarelamsiap. Nene sembe Yesus nu saelba uahiropne poneko amik nen yalamle sumeneko nu nimi kamag wamebengeri nimi teptopne amik nenelobiagha nun samenag Yesus whingag taukap kom. ");
INSERT INTO kkl_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Yesusti samenag yubu ambatsiogpa nen tipto ambarelamsinnena, Allah arukna malaikat sikindori Yesus yanepne sembe wene yalul anne el taukang aro yubu nubu uro yopsilul. Yopsileri, wa'en yubu lilim nubu uro ma'i saog uropne terompet phoalamlul. Terompet phoalamleba, mog so'o leksuluplamleba, Yesus nu taluro saelba uahiropne poneko Elmo imag agha kuluka yalul. Kuluka yalamleri, Yesusag seneragtop nimi samenag tebaek nimi samenag kamag nembahailul. ");
INSERT INTO kkl_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Tebaek nimi samenag kamag nembahileri, sinap nu li ko'o enekoag nu kamag wamebengeap toa nusam toman agha Allahri nu kiliro topsilul. Kiliro topsileba nu Saelba Uahiropne ponekoap imag haiptaberi, ya'ag elap wamukap. ");
INSERT INTO kkl_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Ane sembe a'un a'unkabo Yesusag seneragtop nimiap yubu nene elneneptangto nang-nang aro wapmundi, wana nubu neneptangkamlulom. ");
INSERT INTO kkl_vpl VALUES ("H15_1","082_5_1","1TH","5","1","2","Nangkabo, a'un Yesusag senaragtop nimi wamlomne, Yesus nu Saelba Uahiropne poneko nen amik yalulne neneko sembe a'un tibin uro el wamlom. El samoro yan aloglulne neneko sembe hurop sum li ko'oag agha uro yabilul aro nimiri pimnep kom wamla. El yalul sumeneko nimiri, “Haoghaba tobukap,” aro inipnag nimiri aeag tognoro wa'irop saog uro wamlaba nimiri haing whi uro tibogto wamnep kom saog wamla. Haogha nimiri inipnag yingkirop saog uro Yesus samoro yaloglul ane sembe nuri a'unag nen tipto Yesus samoro yaloglulne neneko sembe, “Sumene li ko'oag agha uro yabilul,” aro mome toro pibaukap kom. ");
INSERT INTO kkl_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Nen amik yalul li ko'o eneko, nimiri lelamikti, “Wenena sa'a-sa'a yubu tananne orog wamlaba aingniro wamap,” alamik abene malia urop nimi kom nembahinep sum waleloglul. El yan aloglulne nenekona, kelabo me monag wamnaba, “Sumene sum mangaroanun,” sembamna komag agha lo'om alognari me mangaltoropne saog uro waleloglul sum Yesus nen yale sum eneko wamla. Yesus nen yale sum malia urop nimi kom nembahinep sum eneko walelogleba, Yesus yubu walinge ka'erop kom nimi el whingag agha la'aniptaukang kom. ");
INSERT INTO kkl_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Aghana nangkabo, a'unna inibinag urop nimi saog uro wamlom kom. Ane sembe a'un haing whi uro wapmundi, were tibog amlulom. Ae ngainge haogha nimi yalenge neneko sembe ekon uro wamleba, haogha nimi ae kwerekto wa'iro yaleri, ae ngainge yame yagsileba, lo'om sulul. Aghana a'un inibinag urop nimi saog komdi, Yesus yanepne sembe wali uro nang-nang aro tibogapmunba, Yesus nen yanalogleba, lo'om sululom kom. ");
INSERT INTO kkl_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","A'un ni nimi tibinneog wamlomdi, walinge aghabog uro wareropneog ulamlomba, nunna nimi inibinne inipnagtinge kom. ");
INSERT INTO kkl_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Ane sembe nunna nimi inibinne inipnagne wamap komdi, nimi orange malamang saog uro malamukap kom. Nun mamna koma haing whi uro wamebeberi wero tibogto wamukap. ");
INSERT INTO kkl_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Nimi yoaba urop nimi taneko Yesus yanepne sembe wero wamna koma inipnag malamang. Ora nimiri inipnag mag yonge tero ulamangne sembe nenek saelbahirop. ");
INSERT INTO kkl_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Nunna nimi tibin nimi warerop nimi wamap ane sembe nuri seneragna babe tibin uro seneragtop nimi wamukap. Mal tarop nimiri, “Mal tabukap,” aro wero ulamikti, seng enekamikti, “Mal homamangag teklemna wapsikag,” aro ngang kwhena kwhelamang. Mal tarop nimiri wero ulamangne saog uro nuri babe wero tibogto wamebengena, Yesusag sikne aro seneraglameberi, Allahap nimiap o'ona senelamsibenge agha seng enektop nimi saog uro wali uro wero wamukap. Mal tarop nimiri ngang kwhena kwhelamang saog uro nun dam nimiri Yesusag seneraglamebengeag agha pelebel talamukap. Peleptanepne seneraglamukapnena, “Yesus yaleri, nu pelepto taulbahileba, Allahri nu opsilul kom,” aro tiboglamapneag agha nuri usoghag babe mal kaunguro timbaneba kalulamap. Undo seneragto o'ona senelamsiberi, Yesusag seneraglameberi, tibin uro seneragto Yesus yaleri, pelebahilulne sembe tibogto wamukap. ");
INSERT INTO kkl_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Allah nu wepsiogne ponekori nunag, “Tam ikinne pimnun,” aro nu wepsiog sembaheng kom. Allahri nu wepsiognena, Allahri Yesus wepto poghogpa, nunag yaogti, nu talulamsildi, saelbamsil. Nu saelba uahiropne Yesus pere agha Allahri nu “Yesusag seneragtop nimi taulbahinun,” aro wepsiog. Taulbahinun aro wepsiog nimi wamap, ane sembe Yesus yaleri, pelebahileba, Allahri nunag tam ikinne piplul kom aro tibogto wamukap. ");
INSERT INTO kkl_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Yesus El tebaogne nu sembe tebaog. El yalamle sum eneko nu kamag wamapneap nu teptopneap Elap nhon wamukap aro samenag tebaog. ");
INSERT INTO kkl_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Ane sembe wene ulamlom saog uro nen tipto a'un-a'un weneldalapmundi, mikip neneltalamlulom. ");
INSERT INTO kkl_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Nangkabo Yesusag seneragtop nimi wamlomne, nuri a'unag molorop yubu a'unag palilamapne ane. Nu saelba uahiropne Yesus ponekori a'un anabiag nimi etpare wamangne sinag mikipne palilamsilba, sin a'uniyabo saog uro wamang. Sinag mikipne palilamsil nimi tanekori a'unag Allah yubu wenehirop yubu ambarelamsiangdi, a'un sembe awe tolamang ane sembe, “Wali uro ka'eamsimundi, kiplamsilulom,” aro mololamsiap. ");
INSERT INTO kkl_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Sindi Allah yubu a'unag ambatto awe tolamang ane sembe, a'undi sin o'ona senero paliag nenero nimi wanaagne nembamsululom. A'un anabiag wamang nimiap wana aingniro nimi wanaagneog seneldalamlulom. ");
INSERT INTO kkl_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Nangkabo, nuri a'unag wenehin yubu olog wembahaukapnena ane. A'un anabiag sol mali aro awe torop kom nimi wamikne wenelamsululom. Wana ikin uro urop nimi wamikne wana keagman nenelamsululom. Mikip kom uro urop nimi wamikne yeplamsululom. Nimi niri ulamikne sembe wana palingkina wali uro ulamlulom. ");
INSERT INTO kkl_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Nimiri a'unag malia ulamsikpa, “Nuri babe taongoro malia uakap,” aro ulamseng kom. A'un-a'un walia aghabog ulapmundi ni nimiag babe walia aghabog ulamlulom. ");
INSERT INTO kkl_vpl VALUES ("H15_16","082_5_16","1TH","5","16","18","Eraruk uro wapmunag, wali uro wapmunag Allahri a'unag ulamlange sembe, “Walinge aghabog ulamla,” aro awi sembamlulom. Awi sembapmundi, Allahag molona sop-sop sinag kweleknag ta'ap sen koma mololamlulom. A'un undo wapmundi ulapmun tanena Allahri a'un sembe wana awi sembamsilul. Sembamsilengena, “Nari weptopne Yesus mog so'oag pogsingeap sae tiptangtop nimi wamangdi, walia ulamang,” aro a'un sembe wana awi sembamsilul. ");
INSERT INTO kkl_vpl VALUES ("H15_19","082_5_19","1TH","5","19","20","Allah Yame Walingeri nimi wanaag yubu elnenelamsilba, nen tipto yubu ambarelamsik tanena salero ka'eban koma yubu ene sembe teba'en sembaheng kom. Allah Yame Walingeri tarelamsil yubu eneko auk pok saog uro wamlaba, oro niknibaheng kom. ");
INSERT INTO kkl_vpl VALUES ("H15_21","082_5_21","1TH","5","21","22","Allah Yame Walinge oro niknibaheng kom aghana, ka'eapmundi, nia ni wali uro seneragto, malinge sik urop komne, “Nunag taleag,” aro weag nembamlulom. Sa'a-sa'a ka'eapmundi, nelagha wali aro kemelbina walinge sik uropne aro seneraglapmun tanena walinge aghabog a'unag wamlul. ");
INSERT INTO kkl_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Nuri a'un sembe Allahag molbarelamsiapnena, Allah Eldamne nu wana aingnilamsilne ponekori a'un sik uro urop nimi nembahileba, Allah Eldamneri mabo wapmundi Eldi uaheng senenne sunsunum uro ulapmundi, wamlulom. Undo wapmunba Allahri a'un yae piamsileba, a'undi seneragnaap, a'undi wanaap, a'undi nong ningkiap yae piptangkamlulom. Allahri a'un yae piamsileba, yae piptangkapmunba, Allahri wepto poghogne Yesus nu saelbamsilne poneko yalamle sumeneko nimi nhondi babe a'un sembe “Malia uaong,” senep kom. Abene nuri a'un sembe Allahag molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Allahri “Naringe taukang” aro a'un yopsiogpa, Eldi salag pibogne neneko angaro yabinep komdi otsik uro ualul. ");
INSERT INTO kkl_vpl VALUES ("H15_25","082_5_25","1TH","5","25","26","“Nu Yesusag seneragtop nimi wamap,” aro a'un-a'un eldo ilipsae saog neneptangka wapmundi, eldo ilipsae somoro kiptangtop saog uro kibiltalamlulom. Nangkabo, nu sembe Allahag molona lelamsululom. ");
INSERT INTO kkl_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Nari a'unag mololamsinnena Yesusti nanag “Ambatsululam,” aro mikipne nanag pimneongeag agha mololamsin. Mome nari palilamnange nene “Yesusag seneragtop nimi niri ka'ebaukang,” aro sin ni whingag agha mome lilim lelapmunba sindi babe ka'elamukang. ");
INSERT INTO kkl_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","A'un sembe molbarelamsiapnena, Allahri wepto poghogne Yesus nu talulamsildi, saelbamsilne poneko wana waliri a'un yepto piamsilul aro molbarelamsiap. Abenda. ");
INSERT INTO kkl_vpl VALUES ("H21_1","083_1_1","2TH","1","1","2","Nangkabo Nuni Allahri, “Mog so'oag nimi taulbahimendi, saelbamsululam,” aro wepto poghogne Yesus ponekoag a'un Tesalonika nimiri seneraglamlomdi, Allah Elmabo taomba, Yesusti nu talulamsildi saelbamsil. Ane sembe na Paulusti mome ane palilamnange neneag agha nu wilindi nang na Pauluasap, Silasap Timotiusapti kiplamsiap. Nuri a'un sembe molbarelamsiapnena, Nuni Allahap, El mori wepto poghogne Yesus nu saelbamsilne ponekoapti a'un sembe wana wali sembamsirangdi, wana aingniro yepto piamsurukang aro molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Nangkabo, a'undi Yesusag sikne aro seneraglamlomdi, samenag agha yubu ene saelba ulamlum aghana wene babe nen ma'aro mikip uro saelbamlom. Samenag a'un o'ona seneldalamlum aghana wene babe a'un maiknoro o'ona seneldalamlom. A'undi undo ul palamlomne sembe nunag yeng to'opto wamlaba Allahag “Wah, Nuniong,” aro kiplamebe kom tanena mali sembamap. Ane sembe nuri senelamapnena, “Allahag Nuni wah aro papna koma omeklamukap,” senelamap. ");
INSERT INTO kkl_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Ane sembe nuri Allah elmabo as yogneag ambatto poa tongolamsiapti a'undi ulamlomne sembe kekaghelbina ambarelamsiap. A'un Tesalonika nimi sembe “Wali sirik ulamang,” aro ambarelamsiapnena, a'undi Yesusag seneraglamlomne sembe nimiri a'unag seklebaik aro ulamsiangba ikin uro seklelamlom. Seklelamlom aghana Yesus nu taulbahainepne poneko limna koma Yesusag wana nhonog uro sikne aro seneraglamlom. A'undi wana nhonog uro Yesusag seneraglamlomne sembe nuri as yogneag ambatto poa tongolamsiapti, a'undi ulamlomne towalengkhiro ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","A'undi undo unulamlomne neneri amik Allahri tam peket uro karebanepne lag wamla. Allahri tam peket uro karebahilulnena, a'undi Yesusag seneraglamlomdi seklenne sembe a'unag talamlaba, wana maulamlaba ulamlomne nene sembe Allahri, “Wali, Namabo taongba, saelbamsinne sunsunum uro urop nimi” sembamsilba, El Allahap a'un nhon wamnepne kekneltalamla. ");
INSERT INTO kkl_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","A'un “Seklebalulom,” aro ulamsik nimiag amik Eldi tam porog uro kareplamleri, lumbahileba sin babe seklebaukangne wamla. ");
INSERT INTO kkl_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Wene a'un seklelamlomneap nu seklelamapneap sembe Allahri nu aingnibitsilul. Aingnibitsilenge anena, Nu Saelba Uahiropne poneko Yesus nen imag agha kulukul alamleri, Yesusap Allah arukna malaikat palisong nangap auk pog libang-libang arop saogneap lag talamukang. Lag talamik sumeneko Allahri nu aingnibitsulul. ");
INSERT INTO kkl_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","El kulukul alulnena, Yesusti “Na mog so'oag nimi saelbamsin aghana mog so'oag nimi taulbahinep yubu Wali Yubu eneko Allah yubu karong arop nimiri ingisaplamang,” sembalul. “Ingisaplamang,” sembaleri, Yesusti “Allah sembe ekon uro urop nimi tanekoag tam ikinne pimnun,” aro kulukul alul. ");
INSERT INTO kkl_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Yesus yubu walinge ingisaptop nimi ni tanekoag “Tam ikinne pimnun,” aro kulukul alulne ya'ag seklero wamnebag Yesusti weag toro toboghailul. Toboghahileba nu Saelba Uahiropne Yesus Mikip Phelektopne Eldamne imang babe Yesus ua urobag babe olog ibukang kom. ");
INSERT INTO kkl_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Ni undo ualulne nenena, El yalamle sumeneko agha ulamleba, elag sik senerop nimi niri paliag nenelamikti, “Yaghe! Mane agha ulamlari, wamla,” aro El omeklamukang. Sumeneko a'un babe nuri ambarelamsibu yubu sik senelamlom ane sembe, Yesusag sikne aro seneragtop nimi anabiag a'un babe wapmundi, El omeklamlulom. ");
INSERT INTO kkl_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Ane sembe nuri a'un sembe sop-sop molona Allahag molbarelamsiapnena, Allahri a'undi wanaag kembiagha, “Namabo taukang aro yoplamsin nimi taneko sunsunum uro urop nimi,” sembalul aro Nuni Allahag molbarelamsiap. Nen tipto molbarelamsiapti, a'undi Yesusag seneragto “El si nubu nembaukap aro undo-undo ulamukap,” senelapmunne sembe, Allah Eldamne mikipne agha yepsileba, “Wali-walia ulamukap,” senelapmunne sunsunum uro sik uro yabilul aro a'un sembe Allahag molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Nuri a'un sembe Allahag molbarelamsiapnena tam nene sembe. A'undi Yesusag seneraglapmundi, “El si nubu nembaukap,” aro wali-walia ulamlulom. Undo unulapmunba, nimiri a'un kemelamsikti, a'undi Yesus omeklamlom saog uro sindi babe, “Nu saelbamsilne poneko omeklamukap,” sembaukang. A'un kemelamsik nimiri “Yesus omeklamukap,” sembaikpa, Allahap Eldamneri wepto poghogne Yesus nu saelbamsilne ponekoapti a'un sembe wana wali sembahirukang. Ane sembe Yesus omeklamikne saog uro Yesus Eldamneri a'un babe towalenghiro paliag nembahilul. ");
INSERT INTO kkl_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Allahri Yesus nu saelbamsilne wepto poghogpa, yaogne poneko sembe si Kristus aro engero yabiog. Yesus Kristus nu saelbamsilne poneko nen amik yaleri nu poloro wimbahaileba elap nhon wamukap. Nangkabo, Yesusag seneraglamlomne, El nen amik yalamleri, nu poloro wimbahilul. Tam abeneko sembe nari a'unag otsik uro mololamsinne ane: ");
INSERT INTO kkl_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Nimiri a'unag mome to yubu to payaikti, tam Yesus nen yanepne sembe orolena ambatsinep. Ane sembe, sindi yubu sik to kom to aro wali uro ka'ebitsululom. Orolena ambarelamsiikti, “Paulusap elkaboapti amberelamsiong yubu eneko nu samen eltabori nuri wene nen tipto a'unag ambarelamsiap,” aro orolena ambatsinep. Sindi orolena ambarelamsiikti, “Allah Eldamne Yameri Paulusap elkaboabag yubu piboba nen tipto nunag ambarelamsiong. Wene nuri a'unag ambarelahiap,” alamik tane, sindi yubu sik to kom to aro wali uro ka'ebitsululom. Sindi lelamikti, “Yesus nu saelbamsilne poneko ik phendep sum nen samoro yaori, elag seneragtop nimi wimbahioba, tane wamap,” alamik tanena elemag-elemag men phea abeneko otsik sembaheng kom. Elemag-elemag otsik semban koma, wana ophag aro wana tung mai neneloptaheng kom. ");
INSERT INTO kkl_vpl VALUES ("H22_3","083_2_3","2TH","2","3","4","Nimi yaikti, Yesus Eldamneri nimi winihiro yalamle sum eneko sembe orolena ambatsiikpa, sik to kom to aro ka'emlulom. Yesus nen amik yalenge sembe ambatsiikne eneko nari ambatsinne yubu sunsunum uro kom tanena, sik sembahiseng kom. Yesus el nen anam yan komag uro yabilulnena nene agha uro yabile tagha amik Yesus yalul. Nimi maikno Allahag wana seneragtop nimi taneko Allah sembe karong alamikti, Yesus yubu nimi taulbahainep yubu eneko lililamsukang. Lililamsiikpa, Allah yubu ingkisaptop nimi nubunge nhon lag tangto waelbaleri, ualulnena ane. Allah yubu ingkisaptop nimi enekori ora nimiri phalamikneap, ora nimiri Allah aro engero palilamikneap “Mombolag nembamsukap,” aro, Allah yubu ingkisaptop nimi eneko agha “Paliag wamna,” aro omekeltalamlul. Omekeltalamleri, Allahri Mem Ae nubunge kota Yerusalem wamlangeag babe wa'ileri, pukamleri, welmot lambitlulnena, “Nana agha Allah wamna,” aro welmot lambitlul. Undo unualul aghana Allahri nimi ene sembe samenag el wamogti, “Luknuro kom nembanun,” aro tam karepto pibog. Nen sap sarikto ambarelamsindi, Yesus nen amik yan komag nimiri Allah sembe karong alamikti, Yesus yubu lililamsikpa, Allah yubu ingisaptop nimi nubunge poneko lag taleba, amik Yesus nen samoro imag agha yalul. Ane sembe, nimiri a'unag yaikti, Yesus nen amik yanepne sembe orolena ambarelamsiik tanena elemag-elemag men phea otsik sembahiseng kom. ");
INSERT INTO kkl_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Na samenag a'unap nhon wamsiri tam nene sembe a'un ni ambatsisinge a'un ekon taom kom sembamna. ");
INSERT INTO kkl_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Allah yubu ingisaptop nimi nubunge neneko wene lag tanep aghana nhondi saelbamlari, iriklamlange neneko a'un elwamlom. Wene saelbamlari, iriklamla agha Allahri, “Nimi yonge yubu ingisaptopne lag talul,” sembaog sumeneko og lag tangto yabilul. ");
INSERT INTO kkl_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Lag tangto yabilul aghana wene babe nimi maiknori, “Na mori uanun senenne sunsunum uro uanun,” senelamangdi, ulamangdi, Allah yubu ingisaplamang. Sindi ulamangne sembe nu Yesusag seneragtop nimiri mali aro undo unulamap kom, aghana sindi seneragna wanaag ulamsilne ekondi undo unulamang. Wene undo Allah yubu ingisaplamang aghana, Allah yubu ingisaptop nimi nubunge neneko lag tanepne sembe, nhondi saelbamlari, iriklamlange neneko Allahri toro kolbitlul. ");
INSERT INTO kkl_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Toro kolbitle taneogna Allah yubu ingkisaptop nimi nubunge neneko lag talul. Lag taleba Yesus nu saelba uahiropne ponekori “Tam karebaneri malinge neneko kom nembanun,” aro Yesus nen yalamle sumeneko Eldamne imang warero kom nembaleri, malinge neneko Yesusti haindi phoaro oplul. ");
INSERT INTO kkl_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Allah yubu ingisaptop nimi nubunge yalenge neneko sembe phia sikini nubungeri nimi eneko nongag leknebaleba nimi eneko yalul. Phia sikini nubungeri mikibag agha yaleri, kekneba nimiri uanep komne maikno ulamlul. Phiari mikibag agha nimiri uanep komne maikno ulamleri, orolenange agha nimiri wana tohileba nimiri, “Yaghe, Allah Imagne mikipneri el pere agha ual” sembaukang. ");
INSERT INTO kkl_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Allah yubu ingkisaptop nimiri undo unulamleri, mali-malia maikno ulamleri, orolenange lelamlul. Nimi samenag Allahri “Loba taukang,” sembaog nimiri orolenange maikno lelamlenge neneko sik sembaukang. Sin Allahri “Loba taukang,” sembaog nimi anekori Allah Yubu sikne nimi taulbahinep yubu eneko karong senelamikti, sikne neneko wa'eplamukang. Sindi Allah yubu wa'eplamikti, Allah yubu ingisaptop nimiri orolenange lelamlenge sik sembaukangne sembe Allah samenag el taog. Samenag el taogti, “Taulbahinun komdi, loba taukang,” sembaog. ");
INSERT INTO kkl_vpl VALUES ("H22_11","083_2_11","2TH","2","11","12","Sin Allahri “Loba taukang,” sembaog nimi tanekori Allah yubu sikne neneko sembe karong senelamikti malinge sembe wali senelamukang. Ane sembe nimi enekoag Allahri, “Tam ikinne karepto sinag pimnun,” sembalul. “Tam ikinne sinag pimnun,” sembaleri, Allah yubu sikne nimi wali nembahinep yubu eneko sik senelamik komne sembe Allahri nimiri seneragna loba nembahilul. Seneragna loba nembahileba, nimiri orolenange ka'esebeltanan yubu lelamikne sembe sik sembaikpa, Allahri tam ikinne karepto sinag piplul. ");
INSERT INTO kkl_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Nangkabo Yesus nu saelba uahiropne ponekori o'ona sembamsil nimi! Nuni Allahri a'un wepsiori, Eldinge nembamsil. A'unag uro yabalamlange sembe nuri senelamapnena, “Nuni Allahag sop-sop Naniong wah aro kibiang towalengelamukap,” senelamap. Eldi a'un sembe anam im so'o sumban komag a'un samenag “Toro pipsineba, Na mabo taukang,” aro wepsiog. Wepsiogti, Allah Eldamne Yame Walingeri malinge a'undi wana seneragnaag uropne yag lanalamsil. Eldamne Yame Walingeri malinge yag lanalamsilne pere agha a'undi Allah yubu walinge Yesus sembe sikne aro seneraglamlom. Allahri sik yubu eneko sikne aro seneraglamlomne pere agha talulamsilba, Allah Elmabo taomdi, wamlom. ");
INSERT INTO kkl_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Allahri a'un “Na Namabo taukang,” aro wepto talulamsilnena, Yubu Walinge Yesus sembe nuri a'un ambatsibunge pere agha a'un Allahri yopsiogti, talulamsil. Talulamsilba, Allahri Elme wepto poghogne Yesus paliag nembaog saog uro Yesusti nu saelba uahiropne ponekori nu kiliro paliag nembahilul. ");
INSERT INTO kkl_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Ane sembe, nangkabo a'un porog uro sekapmundi, nuri ambatsibunge pamag agha babe momeag agha babe ambatsibunge wali mikip uro saelbamlulom. ");
INSERT INTO kkl_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Nuni Allahap Elme Yesus Kristus nu saelbamsilne ponekoapti nu o'ona senelamsirang. O'ona senelamsirangdi, nunag wana waliri ulamsirangneag agha wana aignilamsirang. Wana aingniro mikip nenelamsirangba, ya'ag wana aingniro mikip wameberi, “Allahri nunag walinge aghabog uahilul,” aro tibogto wamapti, wamukap. Allahap Yesusapti wana waliri nunag ulamsirangne nene sembe, nuri Allahap Elme Yesusabag a'un Tesalonika nimi sembe Allahap Yesusabag molbarelamsiap. Allahap Yesusabag a'un sembe molbarelamsiapnena, “Nen ma'aro wana aingnilamsurumundi, mikip nenelamsururom,” aro molbarelamsiap. A'un Tesalonika nimi mikip nenelamsirikpa, “A'un Tesalonika nimiri yubu wali nenerop yubu ambarelamsimundi, walia aghabog ulamlulom,” aro molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Wene nangkabo, nuri a'un sembe mome komoptopne palilamaptina nu sembe Allahag molona lelamsululom. Allahag molona lelamsumunnena, Yesus yubu walinge elemag sabo tangto pileba samenag a'un Tesalonika nimiag uro yabiog saog uro wali uro ka'elamikti, saelbaukang aro Allahag molona molbarelamsululom. ");
INSERT INTO kkl_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Yesus sembe ambarelamsiap yubu nimi niri sik senelamang kom ane sembe karong senerop nimi yo nimiri nu yubu nepto opsikag tina nu sembe Allahag molona lelamsululom. ");
INSERT INTO kkl_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Undop aghana Yesus nun saelbamsilne ponekori nu ya'ag yae piamsileri, sae lipsilul kom. Eldi a'un mikip nembamsileri yongeri sae kiliro yubu nepsinebag agha Eldi yae wamsileri a'un taluro pelebahilul. ");
INSERT INTO kkl_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Nuri a'un sembe wana nong ningkiri Yesus nu saelbamsilne saeag palilamsiap. Nuri a'unag “Ualulom-ualulom” aro ambatsibunge sunsunum uro wene wali uro ulamlom. Wali ulamlomdi, nen amik babe ulamlulom aro el uro wamapti, a'un sembe Yesus nu saelbamsilne ponekori saeag palilamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Nuri nun saelbamsilne ponekoag a'un sembe molona molbarelamsiapnena, nu taluro saelbamsilne ponekori a'un yeplamsileba, Allahri nu o'ona sembamsilne saog uro a'undi babe wanaag agha o'ona seneptangkamlulom. Nu taluro saelbamsilne ponekori a'un yeplamsileba, Yesus Allah Elme wepto poghogne ponekori wana nhonog uro Allahag seneragto seklebaog saog uro, a'undi babe wana nhonog uro Allahag seneraglamlulom aro a'un sembe Allahag molbarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Nangkabo, Yesus nu saelbamsilne ponekori mikipne nunag pipsiogneag agha nuri a'unag aruklamsiapne ane. A'un Yesusag sikne aro seneragtop nimi wamlomne anabiag agha, nimi etne nuri ambatsibu yubu salero ulamang komdi, solmali uro urop nimi ipsimun tanena, sin undo urop nimiap ma'aptangto wamseng kom aro ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Nu a'un anabiag wamuburi nuri awe tolamubunge solmali semban koma solwali wali uro tolamubunge a'undi babe ipsilum. Nuri senelamuburi, “Nuri sol wali, wali uro tolamubunge sindi babe ipsikti nuri sol wali uro awe tolamap saog uro sindi babe sol wali uro tolamukang,” aro ulamubu ane sembe a'undi babe otsik uro sol wali uro tolamlulom. ");
INSERT INTO kkl_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Nu a'unap wamubungena kwaneng tena mo telolamsubu kom. Sinag kweleknag whin seklero awe tolamubungena, “Nimi nuri tenaba sembe a'un yubu nepsukap kom,” aro nuri saeri ero tolamubu. ");
INSERT INTO kkl_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Yesus nu saelba uahiropne ponekori nu wepto pogsiogti, nunag mikipne tatsiog. Mikipne nunag tatsiog ane sembe nunag kwema ulamogpa, a'unag molbahinep. Nuri a'unag kwaneng to, pakaian to, uang to molbahinep aghana nuri sembamubungena, “Sindi nu kemelamsiikpa, nuri ulamebenge sindi ipsikti, sindi babe nelepto ulamukang” sembamubu. Ane sembe a'unag molbahin koma nuri saeri ero tolamubu. ");
INSERT INTO kkl_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Nu a'un anabiag wamubuag yubu nene agha “Ulamukap,” aro karepto pibubungena, “Nimi etneri sop-sop, 'Awe tomna koma mo wamnun,' aro ulamle tanena, nimi eneko kwaneng telamlul kom,” aro karepto pibubu. Ane sembe, nen sap sarikto “Sol mali uro urop nimi awe toro uan kom tanena nimi enekoap ma'aptangto wamseng kom,” aro ambarelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Nuri samenag, “Awe weroan kom nimiri kwaneng telamlul kom,” aro karebabu aghana wene ka'elamapba, a'un anabiag agha nimi etpare wamangdi, awe weroan koma toro kokto wamang. Toro kokto ulamangdi, sa'a-sa'a uan koma ulamang aghana, ora nimiri tam ua ulamla tanena urukag wa'ina salel wa'alamang” alamangpa, ka'elamap. ");
INSERT INTO kkl_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Nuri karepto pibubungena nen sap sarikto aruklamsiap. Yesus Kristus nu saelbamsilne ponekori mikipne nunag pipsiogpa, Eldamne mikipneag agha sin ora nimiri tam wa'iro sale-sale tongorop nimiag wenelamsiapti, yubu mikip uro aruklamsiap. “Sin undop nimi nimiringe tag sae tobongol wa'anne libikti, aingniro taikti, awe saeri weroaik taneogna tenaba telamukang,” aro wenelamsiap. ");
INSERT INTO kkl_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Aghana a'undi nimiag walia ulamlomne nenena sololamnari, ta'ap senun semban agha walia ulamlomne lipseng kom. ");
INSERT INTO kkl_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Nuri mome toro palilamapne neneag wamlange nene saelbamlulom. Nimi nhon a'un anabiag agha nuri mome eneko sembe sik sembale komdi, nelebale kom tanena, nimi enekoap sae tiptangto wamlulom kom. “Ali sembaleri, yubu eneko ka'ebalul,” aro a'un togtangto wapmundi, elap sae tiptangto wamseng kom. ");
INSERT INTO kkl_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Aghana nimi eneko a'undi aisa nemban koma yubu wali uro “Nungkae Yesusag seneragtopne,” aro yubu agha wenelamlulom. ");
INSERT INTO kkl_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Nu saelbamsildi, wana aingnilamsilne poneko Eldamneri sop-sop a'undi wana babe aingnilamsilul. Wali uro wapmunag, eraruk uro wapmunag, a'undi wana aingnilamsilul aro Elag molbarelamsiap. A'un saelbamsilne ponekori a'un yae piamsileba, Elap nhon wamlulom. ");
INSERT INTO kkl_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Na nadamne Paulusti mome abene tolamnari, nangkabo aro a'un kiplamsin. Nari sop-sop mome tolamnange saog uro mome nenneag babe nari sae kekneba na kekneltananne sembe undo palilamna. Ane sembe nimi etneri mome ene kembaikti, Paulusti tapto mome eneko tobog aro el taukang. ");
INSERT INTO kkl_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Nuri Allahag molona molbarelamsiapnena, '”Mog so'oag nimi taulbahimendi, saelbamsululam,' aro Allahri wepto poghol aogne Yesus ponekori wana waliri o'ona sembamsildi a'un ni yepto piamsilul,” aro molbarelamsiap. Abenda. ");
INSERT INTO kkl_vpl VALUES ("T11_1","084_1_1","1TI","1","1","2","Timotius naba name. Nari samen Yesusag sikne aro seneraglamna saog uro andi babe Allahri, “Nimi mog so'oag nimi taulbahaileri, saelbamsilul,” aro wepto poghogne ponekoag seneraglamlam. Ane sembe, naba name taptopne saog wamlamba kiplangken. Samen Allahri Yesus wepto “Taulbahileri, saelbamsilul,” aro poghogne Yesus yaogne sembe Kristus aro engero yabiog. Yesus Kristus ponekori Allahri aruktop yubu sunsunum uro na Paulus wepto pogneogpa, Yesus sembe ambarelamsindi, mome ane an sembe toro palilamna. Allahri nu talulamsilne ponekori nu mog so'oag nimi sembe Yesus poghatsiogpa, “Nunap Allahap nhon wali wamukap,” aro Yesusag sikne aro seneragto nang-nangalamap. Nari an sembe molbarelangkenne, Nuni Allahap Eldi wepto poghogne Yesus Kristus nu saelbamsilne nenekoapti an sembe wana wali sembangkarukang. Wana wali sembangkirikti, yareagti yeplangkirikpa, wana aingniro wamlulam. ");
INSERT INTO kkl_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Name Timotius, na Makedonia so'oag palamnori, ambatkenonge sunsunum uro an as kota Efesus ya'ag wamlulam sembamna. An Efesus ya'ag wamlulam sembamnangena, “Nimi etbareri Allah yubu kilbiagha sik komne ambatsiong nimi tanekoag 'Undop yubu ambatsululom kom,' aro pat palirop yubuag wembahilulam,” aro ambatkenori, nen sap sarikto ambarelangkeken. ");
INSERT INTO kkl_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Sindi kom nepna neptop yubuap, nimi yan ana lelektop yubuap ambarelamsiong yubu ene sembe nimiri saekag lemnep komdi, sop-sop yubu ene sembe leldalamangne nene “Pabukang” aro wenelamsululam. Allahri awe Eldamneringe nuri sa'oag pipsiogti, “Nanag sikne aro seneraglamnemundi, Nari awe tolamlulom,” seog. “Awe tolamlulom,” seog aghana sindi ambarelamsiong yubu eneri nimi wana wag nenelamsiangba, Allahri “Awe tolamlulom,” seogne sunsunum uro ulamang kom. ");
INSERT INTO kkl_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Nari “Undo ambatsiseng kom,” aro iriklamsinnena tam nene sembe. Nari yeng senelamnarina, “Nimi wanaag sembenga orog nimi wamikti, malia uan koma wana aingniro senelamikti, Yesusag sikne aro seneraglamukang. Undo unulamik tanena, Allah o'ona senelamikti, sin mamun o'ona seneldalamukang,” senelamnari, yepsinep kom yubu ambatsiropnang nene wenero iriklamsin. ");
INSERT INTO kkl_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","“Nia undo-undo wali uro ulamlulom,” aro wenelamsin aghana, nimi etbareri nari wenehirop yubu ene wail ibarelamongdi, Allahap nimiap o'ona seneptangtopne lipsiong. Sin mamun uro yabinep komne sik komne agha lelamang. ");
INSERT INTO kkl_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Sin nimi taneko, “Musari yubu mome toro piropne sembe ambatsin nimi tahabe,” aro ambarelamsiang. Sindi yubu kiki telekto el uro ambatsiropnang wamloa saog aghana, yubu tam sirikagne ekondi, yubu kiki pamag agha lanalamangne babe lomag wamlange sinna ekon. ");
INSERT INTO kkl_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","El uro wamapnena, Allahri samenag Musa ambarog yubu mome toro pibogne nenena wali. Wali aghana, ot nimiri Musari yubu sik uro saelbamnari, Musari mome toro pibog yubu enekoog ulamna tanena, sik uro wali sembanep. ");
INSERT INTO kkl_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Nen nhon el wamapnena, Musari iriktop yubu mome toro pibog yubu enena nimi wali uro urop nimi sembe mome toro pibog kom. Musari iriktop yubu mome toro pibog yubu enena irikna phirop nimi sembe, Allah wail ibatop nimi sembe, Allah omektop kom nimi sembe, malia urop nimi sembe, Allahri senenne sunsunum uro seneragtop kom nimi sembe, nimiri tam so'oagne sembe wanaag somoro agha urop nimi sembe Musari iriktop yubu mome toro pibog. Sin undo urop nimiri nimi olamsiangdi, sikini sikinin ohirop nimi sembe iriktop yubu mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Kelabo nengabo toptan komag agha waleptangto malia urop nimi wamang. Ora nimiri malia uropnena, sin mamun salik-malik uro “Uahaneme” senenneag agha kabuniap-kabuniap, kelaboap-kelaboap babe elkel ela'ange neneptangka wamloa saog uro marop nimi wamang. Nimi sae kaupto kamna tatsin koma yo uro aruksirop nimi wamangdi, nimi sindi saeag wamang nimi pham to, kam to nenelamsiloa saog uro kamna kapto tolamangdi, ora nimiri saeag tarelamsiang. Orolena lerop nimi wamang. Ipsin koma orolena lero, “Eldi undo unuaoba, imno,” arop nimi wamang. Nimi maiknori Allah yubu sikne ambatsirop yubu sunsunum uro uan koma malia ulamang. Ni undop nimi abini sembe Allahri iriktop yubu ambarogne sunsunum uro Musari mome toro pibog. ");
INSERT INTO kkl_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Allah omeklamapne ponekori Eldamneri yubu sikne neneko nanag ambatneogti, “Yubu walinge Allah nubu sirikne ponekori Yesus tatsiogne sembe ambarelamsululam,” aro nari saeag pibog. Nari saeag pibog, ane sembe Allah yubu sikne sunsunum uro yubu walinge sik uro tipto ambarelamsin. ");
INSERT INTO kkl_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Yesus Kristus nu saelbamsilne ponekori na sembe “Nari arukna sol walinge,” sembamneori, sekitneo. Eldi “Nari awe webatnilul,” aro sekitneori, nari nong mikip nenelamneoba, Eldi awe nari tolamna. Eldi na sembe wali senelamneoa sembe Yesus nu saelbamsilne ponekoag “Naba nani,” aro kiplamna. ");
INSERT INTO kkl_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Samenag nari Yesus san tilipto “Elag seneragtop nimi seklebaik,” aro ulamsiri, olamsisi. Undo ulamsiri, olamsisi aghana samenag na anam Yesusag “Sikne” aro seneragamsi komdi, nari ulamsinge na babe ekonne agha ulamsi, ane sembe Allahri yareag sembaneog. ");
INSERT INTO kkl_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Ulamsi aghana nana nu Talulamsildi Salelamsilne ponekori nanag to'opto o'ona sembamneog. O'ona sembaneogti, yepneogpa, Yesusag “Sikne” aro seneraglamna. Elag “Sikne” aro seneraglamnaba, Yesus Kristus ponekori na o'ona senelamnelne agha nari babe nimi o'ona senelamsin. ");
INSERT INTO kkl_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Yubu kiki otsikne agha lag phoro lemnuan. Nimi nenneri babe malia urop aghana, nanagha yonge mali sirikne ulamsinge poneko na wamna. Malia sirikne ulamsi aghana, Yesus Kristus yaognena, “Nimi malia urop nimi sae kiliro taulbahinun,” aro yaog. Nari otsikne agha ambatsin ane sembe, sik uro to'opto seneraglapmundi, saelbamlulom. ");
INSERT INTO kkl_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Ora nimiri malia ulamang aghana nari agha mali sirikne maikno ulamsi. Na Paulusti malia ulamsinge sembe Yesus Kristus ponekori samenag seneraglamneogti, “Malia maikno sirikne ulamlange sembe el Paulusag tam pimnep aghana, elag yareag sembanun. Elag yareag sembaneri, wana paiamneba, yog nimiri ibaukang. Ibik nimiri na Yesusti wana paiamnange sembe el taikti, sindi malia ulamangne sembe babe na Yesusag mololamnukang. Na Yesusag mololamnikti, 'Samenag Paulusti malia ulamogne sembe wana paiplum saog uro, nari malia ulamnange babe wailag nembalulam,' aro mololamnukang,” sembaog. Undo seneraglamogti, Yesus ponekori nari malia ulamsinge sembe tam pimnep aghana, el nong ningkiag agha na malia uropne pone sembe wana paiamogti, o'ona sembaneog. Nanag uro yabiogne nene nimi niri ibikti, sindi babe Yesusag “Sikne” aro seneraglamik tanena, sik uro ya'ag kamag uro wamukang. ");
INSERT INTO kkl_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","El ya'ag wamlange ponekori samenag wamek nimiap nu wamap nimiap wamukang nimiap salero paiamsil. Nu mog so'oag nimiri ililamap kom aghana, El nu sembe yubu sia leropne Nuni Allah ot nhonogne wamla. El aghabog papna koma omeklameberi, “Nuni,” aro kiplamukap. Sikne agha saekag lebap. Abenda. ");
INSERT INTO kkl_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Naba name Timotius! Allah yubu silimu tiptopnangdi samenag andi whingag amik anag uro yabinepne sembe ambatkeong yubu sunsunum uro “Ulamlulam,” aro awe nene an saeag palilamna. Anag uro yabinepne sembe samenag ambatkeong yubu enekori mikip nembangkeleba, ekon talulam kom. Yubu ambatkeong yubu eneko sunsunum uro, “Orolena yubu lerop nimi yubu kom taukang,” aro ambarelamsululam. Ambarelamsimenne, yin saleropnangdi sikinkabo pelepto aisanangap maldaropne wamloa saog uro wana nhonog uro sikne aghabog ambarelamsululam. ");
INSERT INTO kkl_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Ambarelamsimendi, Yesusag “Sikne” aro seneraglapmendi, andi wanaag “Sikne aghabog uanun” seneropne sunsunum uro ulamlulam. Samenag nimi etbare Yesusag seneraghong aghana sindam nimiri wanaag agha seneragtopneri wa'epto poa phio. Wa'epto poa phioba sindi, “Sik uro uropne walinge aghabog uahane” aro seneraglamong komdi, sindi wanaag agha Yesusag seneragnange teba'en nembaong. ");
INSERT INTO kkl_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Sindi Yesusag seneragna teba'en neneptarong nimi abenekona Aleksanderap Himeneusap. Sin phende abeneko sembe nari tam pelengero “El taukang,” aro phia sikini nubunge saeag pipsino. Phia sikini nubunge saeag pipsinongena, “Sindi Allah san tilibanep kom,” aro el taukang sembanori, phia saeag pipsino. ");
INSERT INTO kkl_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Anamag ambarelamsinne o'omnena ane: Allahag molon yubu mololapmundi, teko wamsilea sembe molbarelamsululom. Mololapmundi, nimi ni sembe babe Allahag molona molbarelamsimundi, Allahri tarelamsilne sembe, “Naba Nani, wali tarelamsilam” aro omeklamlulom. ");
INSERT INTO kkl_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Yubu sia lerop nangap nimi nubu nang a'un sale-sale piamsiang nangap sembe babe molona Allahag molbarelamsululom. Molbarelamsimunne, “Tam yogne-yogne orog wamleba, aingniro wana wali uro wameberi, Allahri seneragna sunsunum uro malia uan koma wamukap,” aro molbarelamsululom. ");
INSERT INTO kkl_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Undo ulapmunne agha Allah nu taulbahiropne poneko wana wali nenelamukap. ");
INSERT INTO kkl_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Eldi yeng seneropnena, “Nimi ni sikne Yesus sembe el taheng. El taikti, Yesusag 'Sikne' aro seneraglamik andarina, sindi malia ulamangne agha taulbahinun,” aro yeng senelamla. ");
INSERT INTO kkl_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Tam nene sembe sik yubu lemnuan. Allah nhonog wamlaba, nunap Allahap sembe anabiag talamlari, nu Allahap ma'abahinepne ot nhonog wamla. El nhonog wamlange poneko Allahri “Nimi so'oag nimi taulbahileri, saelbahilul,” aro poghogne Yesus Kristus wamla. ");
INSERT INTO kkl_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","El neneko “Nimi so'oag nimiri mali-malia uropne sembe kom nembahane,” aro kamna toptaogti, Eldi nimi taluro wali nembahinep. Yesusti undo unuaogne nenena, Allahri “Wene Nari wana kembaukang” senen ko'oag agha Yesusti uaogpa, Allahri “Yesusti uropne pere agha nimi ni Nanag saombanep,” aro yeng sembaogne lag taog. ");
INSERT INTO kkl_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Undo unuaogne nene sembe Yesusti na pogneog. Poglamneogti, “Yahudi sisa kom nimiag yubu walinge Yesus sembe lag phoro sik uro ambarelamsileba, sik seneraglamukang,” aro Yesusti na pogneog. Nari lemnange nene orolenange agha lemna kom, otsikne agha lemna. ");
INSERT INTO kkl_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Nari yeng senelamnangena, nimi kabuni tala-tala wamang nimi sindi wanaag, “Allahri senenne sunsunum uro ulamukap,” aro sae towalengero Allahag omekto molona mololamukang. Nari yeng senelamnange, “Allahri senenne sunsunum uro ulamikti, omekto mololamik andarina, nimiap-nimiap waptangkamna koma, nimiap se'el neneptangkamna koma wamukang,” senelamna. ");
INSERT INTO kkl_vpl VALUES ("T12_9","084_2_9","1TI","2","9","10","Kelabo sembe babe nari yeng senelamnangena ane: Allah omektop nimiri ulamukangne sunsunum uro sindi nongag enektangkamukang. Ora nimiri a'un anabiag kelabori nongag enektoamikne kembahiikti, “Ot sunsunum uro enektoamla,” senelamukang. A'un anabiag kelabo kembahiik nimiri, “Yesusag seneragto wana marop kelabo wamangdi, sunsunum uro enektoamang” senelamikti, kiplamsiikne sembe na yeng. Allah omektop kelabori sindi hongag leng-leng aroba emas kamna maikno toropne agha kauplamikti, ag babe kamna maiknoro torop ag agha enektangkamikpa, nimiri haing phende wilindi tiboghahiikne nene mali. Allah omektop kelabori sindi wali-walia towalengeptanep saogne uanepnena, sa'a-sa'a walia ulapmunba, nimiri kembahiikti, “Walia maikno ulamangdi, wali kelabo wamang,” sembaukang. ");
INSERT INTO kkl_vpl VALUES ("T12_11","084_2_11","1TI","2","11","12","A'un Yesusag seneragtop nimiap winiltalapmundi, kelabori Allah yubu sembe nengabo ambarelamsiseng kom. Kelabo yubu koma wamikti, ka'eamikpa, kaubuniri yubu ambarelamsiikne kelabori wana mamleba, ka'elamik tanena, el talamukang. Allah yubu lero winirobag nengabori Allah yubu ambarelamsiikpa, kelabori “Poneri yubu lelamlange ka'emnun kom,” aro ulamikne nene sunsunum kom. ");
INSERT INTO kkl_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","“Kelabori nengabo amoro ambarelamsiseng kom,” aro ambatsinne nenena tam nene sembe. Allahri nimi sunulamsiogti, Adam samenag sumbaogti, Hawa amik sumbaog. ");
INSERT INTO kkl_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Allahri nimi sumbahiogpa, Adam poneko phaeri yubu orolena yubu sik sembaog kom. Sik sembaog kom aghana, Hawa keleneko phaeri yubu orolena yubu sik sembaogti, Allah yubu lebogne irikna phibaog. Adam poneko babe irikna phibaog aghana, phaeri yubu orolena yubu sik sembaog koma phibaog. Ane sembe Allahri kelabo sembe tam pipsiogne sunsunum uro nengabo umag wamukang. ");
INSERT INTO kkl_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Kelabo sembe “Nengabo umag wamukang,” alamna aghana, kelabori me mangalamsiangneri kelabo sembe wali nenelamsil. Me mangalamsiikti, Yesusag sikne aro seneraglamikti, nimi o'ona senelamsiikti, Allahri senenne sunsunum uro ulamikti, wana mamleba wamik tanena kelabo wali wamukang. ");
INSERT INTO kkl_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Yubu kiki nene sikne andagha ambarelangken. Nimi etneri, “Yesusag seneragtop nimi pia uhirop nimi tanun,” senerop nimi enekori “Awe saelbahane,” aro seneragtopnena, awe toro welbana wali sirikne “Saelbahane,” senerop. ");
INSERT INTO kkl_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Ane sembe nimiri yubu sikne agha “Malia ulamla” aro elag tam pimnep tanena, Yesusag seneragtop nimi pia uhirop nimi wamnep kom. Yesusag seneragtop nimi piamsinep nimi eneko kelabo ot nhonog toamnep. Yesusag seneragtop nimi pia uhiropne tanep nimina, undop nimi agha tanep. Eldi wana mamleba, “Malia uanun” senelamlenge lirop Eldi wana hekto seneragha urop Nimi orangeri el sembe “Wali nimi” aro kiptop Eldi aeag nimi wa'al ananne sembe ina kuptop Eldi wali uro el nenero ambatsinep ");
INSERT INTO kkl_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Mag yongeri wana torop kom Nimiap kame tarop koma “Nimiap-nimiap aigniro wamukap,” senerop Nimiap waptangtop yubu agha leptangtop kom Kal ma'aldi wana torop kom Undop saog nimi wamle tanena, “Yesusag seneragtopne pia uahirop nimi taho,” sembanep. ");
INSERT INTO kkl_vpl VALUES ("T13_4","084_3_4","1TI","3","4","5","Yesusag seneragtopne pia uhiropne tanep nimiri eldi kel, eldi mabo kelmabo wali uro o'oamsilul. Wali uro o'oamsileba, eldi mabo kelmabori sikini yubu ka'eamikti, sikini sembe “Nuniong,” senero sunsunum uro ulamukang. Nimi nhondi eldi kel, eldi mabo kelmabo wali uro o'obahinep kom agha elag “Yesusag seneragtopne pia ulamsululam,” aro eldi saeag piamna tanena, welaro Allah Elmabo o'obahinep? Ane sembe eldi kelabo meap wali uro o'oamsile kom tanena, Allah Elmabo pia uahiropne wamlul kom. ");
INSERT INTO kkl_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Allah Elmabo pia uhinne tanep nimina, weneog Yesusag “Sikne” aro alniro seneraglamna nimi agha pia uhirop nimi tanep kom. Weneog Yesusag seneraglamna nimi agha Allah Elmabo pia uhiropne tan pagha tanena, el nenekori, “Na Allah Elmabo pia uhinne wamna,” aro metmereng senep. Samenag babe phia sikini nubungeri “Na nubunge wamna,” aro metmereng seogpa, Allahri phia sikini nubunge nenekoag tam ikinne pibog. Allahri samenag phia sikini nubungeag tam ikinne pibog saog uro, Allah Elmabo pia uhirop nimiri “Nubunge wamna,” aro metmereng seleba, Allahri elag babe tam ikinne pimnep. ");
INSERT INTO kkl_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Allah Elmabo pia uhinne tanepnena, Yesusag seneragtop kom nimiri babe eldi ul palamlange sembe “Nimi walinge,” senelamik tanena, el wali Allah Elmabo pia uhinne wamnep. Aghana Yesusag seneragtop kom nimiri Allah Elmabo pia uhin nimi sembe san tilipnange na karong. Ane sembe Yesusag seneragtop kom nimiri eldi ulamlange sembe mali alamik tanena, nimi eneko Allah Elmabo pia uhinne wamnep kom. Nimi undo urop saog nimi eneko “Phia sikiniri selbel werobag wa'ileag,” aro Allah Elmabo pia uhinne wamlul kom. ");
INSERT INTO kkl_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Allah Elmabo pia uhiropne tanep nimi sembe ambatsindi, nen tipto ambarelamsinnena, Yesusag seneragtop nimi longoro winiroba anabiag agha “Teko ulamsileag,” aro yepto tongohiropne tanep nimi sembe ambatsinuan. A'un Allah Elmabo anabiag agha nimi yepto tongohiropne tanep nimina, undop nimi agha tanep. Sindi lero ul palamangne agha ora nimiri maipsinep Sindi sikne andagha lero urop nimi Mag yongeri wana tohirop kom nimi Kal ma'aldi babe haing suruhirop kom nimi Undop nimi wamseng tanena, a'undi sin sembe, “Yesusag seneragtop winirop nimiri sae tahengdi, yepto tongohirop nimi taheng,” sembanep. ");
INSERT INTO kkl_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Sin yepto tongohirop nimi tanep nimina, “Walinge agha ulamnari, uanun,” aro yubu sikne Yesus sembe seneraglamangdi, salelamang nimi agha wepsiro sekitsinep. Yubu sikne Yesus sembe samenag tognoro saog wamog aghana wene el tabu. El taburi, Allah Elmabo yepto tongohinep nimiri yubu sikne wali uro seneraglamikti, kas mi agha saelbamik pagha tanena, “Nuri sae tahengdi, yepto tongohiropne taheng,” aro seneragnep. ");
INSERT INTO kkl_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Sin Allah Elmabo yepsin nimi anam wepsin komag sin mipsinba, nimiri sin sembe se'el nembahinep kom tanena, sin hae Allah Elmabo yepto tongohirop nimi wamnep. ");
INSERT INTO kkl_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Kelabo sikindinge babe sindi wana mamleba, “Malia uaukap,” senelamikne libikti, ora nimi sembe san tilipto lemna koma ulamukang. Undo ulamikpa, ora nimiri ililamsiikti, yepto tongohirop nimi sikin kelabo aneko sembe “Sikneog lero urop kelabo wamang,” aro maiplamsukang. ");
INSERT INTO kkl_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Allah Elmabo yepto tongohiropne eldi kel ot nhonog toamnari, eldi kelap kelmabo meap wali uro o'obahinepne agha wamlul. ");
INSERT INTO kkl_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Nimi etneri Yesusag seneragtop nimi sol wali, wali uro yeplamsiikpa, ora nimiri sin wali uro yeptop nimi sembe “Nimi walinge, nani,” aro maiplamsukang. Nimi wali uro yeplamsiikti, sindam nimiri wanaag Yesusag seneragnange nen ma'aro maikno talamlul. Yesusag seneragnange maikno talamleri, wana nong ningkiri Yesusag “Allahri wepto poghogne Kristus sik uro wamla,” aro seneraglamukang. ");
INSERT INTO kkl_vpl VALUES ("T13_14","084_3_14","1TI","3","14","15","Nari an kemelaghenunne nen olog tane wamneri, an kota Efesus wamlamag men yanun. “Men yanun,” sembamna aghana men yane kom tanena, “A'un ekon wamnep kom,” sembamnari mome ane “El talulom,” aro palilamna. A'un Allah Elmabo saog uropne wamlom, ane sembe Allahri Eldamneri mabo sembe, “'Undo-undo ua ulamukang,' senenne el wamlulom,” sembamnari, mome ane toro palilamna. Allah ya'ag kamag uropne ponekori “Eldi yubu sikne mikip uro saelbamlulom,” aro a'un Yesusag seneragtop nimi poloro winilamsilba, wamlom. “Eldi yubu sikne salelapmundi, ambarelamsimunba, ora nimiri Yesus sembe 'Allahri wepto poghogne sikne wamla,' sembaukang,” aro Allahri a'un poloro winilamsildi, sekelilamsil. ");
INSERT INTO kkl_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Sikne Yesus sembe samenag tognoro wamog aghana wene lag taogpa, nu Yesusag seneragtop nimi niri El sembe saekag lelamapne wali nubu sirik wamla. Nuri Yesus sembe sikne aro seneraglamapne undo. El neneko nimi saog uro lag taogpa, Allah Yame Walingeri “El sikne,” aro lag nenelamogpa, Allah arukna malaikatti babe ibek. Nimiri yubu El sembe ambarel phiekpa, nimi sisa Yahudi kom nimi babe ka'elamek. Nimi mog so'oag nimi tala-tala wamangne agha El neneko sembe “Sikne” aro seneraglamang. Samenag nimi saog uro mog so'oag wamog aghana, Allahri El neneko sembe “Nimiri omeklamukang” aro imag agha kiliro tobogpa, wamla. ");
INSERT INTO kkl_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Allah Yame Walingeri tibin uro yubu lelamlangena, Yesus samoro yanep sum peram wamebeag, nimi Yesusag “Sikne” aro seneragtop nimi agha Yesus yubu lilobukang. Yesus yubu lilobikti, phia yubu orolena yubu agha “sikne” aro ka'elamikti, ina ka'eseptanep ina nelebaukang. ");
INSERT INTO kkl_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Phia yubu aneko orolena lerop nimi pere agha ambarelamsiang. Orolena yubu ambatsirop nimina sindi wana seneragnaag sikne ka'eban koma phia yubu ambarelamsiang. ");
INSERT INTO kkl_vpl VALUES ("T14_3","084_4_3","1TI","4","3","5","Orolena yubu ambatsiropnang tanekori “Nengabo kelabo topsin koma mo-mo wamlulom,” aro ambarelamsiang. Tenaba sembe babe “Salik-malik ten koma, kwaneng neneap, neneap tululom,” alamang. “Nengabo kelabo toptaheng kom. Kwaneng teheng kom,” alamang aghana Nuni Allahri nia mangkina sumbaogne wali sumbaog. Nengabo kelabo sumbahiogti, kwaneng babe sumbaog. Nia mangkina Allahri sumbongkia seneraghogti, “Wali-walia sumbandi, tarelamsinne ibikti, el taukang. El taikti, seneraglamneikti, 'Naniong, walia tarelamsilam,' aro tolamukang,” sembaogti, nia mangkina sumbaog. Allahri nia mangkina sumbaogti, nimi sumbahiogti, “Mog so'oag nimiag tarelamsin,” aro ambatsiog. Ane sembe, Allahri sik uro walia tarelamsilne sembe el uro wameberi, nu Yesusag seneragtop nimiri tolameberi, “Nuba, Naniong,” aro kiplamebe tanena Allahri wali sembalul. ");
INSERT INTO kkl_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ni ambatkenne nini, nunkabo Yesusag seneragtop nimiag ambarelamsimen tanena, anna Yesus Kristus ponekori awe wali uro toro ulpiro yeptopne wamlulam. Yesusap Allahap sembe yubu sikne samenag ambatkebonge sunsunum uro wene ulpalamlamdi, nen tipto yubu sikne wali uro toro ambarelamsululam. Yubu sikne ambatkebonge sunsunum uro ambarelamsimen tanena, yubu eneko andamne wanaag meptaleri, mikip nenelangkelul. ");
INSERT INTO kkl_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Yubu sik komne nuri seneragna inibin nembahinep yubu sembe babe, sabal kelabo nenek salehirop kelabori neplamloa saog yubu kamolange sembe babe ka'eamlulam kom. Yubu sik komne ka'ebahin koma koloptangkapmendi, “Andi wana seneragna Allahri seneragna sunsunum uro talul,” aro eltangkapmendi, seneraglapmendi, ulamlulam. ");
INSERT INTO kkl_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Nimiri seneraglamangne, “'Mikip nembamsilul,' aro topseng kom, teheng kom,” alamanga sunsunum uro ulamangneri nimi nong olog yepsinep. Nimi nong olog yepsinep aghana, Allahri senenne sunsunum uro ulpiropnena, wene ko'oag wamapne sembe babe, amik ko'oag sembe babe, nia mangkina ulpalamapne sembe babe, Allahri senenne sunsunum uro ulpalamebe tanena, wali wamukap. Allahri nunag salag lero ambatsiogti, “Nari seneragna sunsunum uro seneragto ulapmun tanena wali wamlulom,” aro salag lero pipsiog. Ane sembe amik Elap nhon ya'ag kamag uro wamebeag, nuri Eldi salag lero pibogne salero sunsunum uro ulamapne sembe teba'en sembaukap kom. ");
INSERT INTO kkl_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Yubu kiki otsikne agha lag phoro lemnuan, ane sembe wali uro ka'eapmundi, mikip uro saelbamlulom. ");
INSERT INTO kkl_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Nuri Allah ya'ag kamag uropne ponekoag seneraglamapnena, “Nimi ni mog so'oag nimiri malia ulamapne sembe Allahri opsinep. Allahri nu opsinep aghana Yesusag seneragto Elag wana saingnia piamebengeag agha Allahri nu taulbahilul,” aro nang-nangaro seneraglamap. Nimi etneri Allahri wepto poghogne ponekoag “Sikne” aro seneraglamleba, Allahri nimi eneko taulbalul. Ane sembe, nuri mikip uro whin seklero awe tolamap. ");
INSERT INTO kkl_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Nia ane ambarelamsimenne nene, “Ni Paulusti ambatsiropne saelbapmundi, sunsunum uro ulamlulom,” aro ambarelamsululam. ");
INSERT INTO kkl_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Ambarelamsimenba, nimi nhondi babe an sembe, “Me ane kabuni weneog me, el ekon bog lelamla,” aro an sembe teba'en sembaheng kom. Anna, “Sindi nari lelamnange sembe teba'en sapsabi na kembaneikag,” aro anna agha, “Sindi kembaniikti, sindi babe na ulamnange nelepto ulamukang,” senelapmendi, Yesusag seneragtop nimi whingag andi ulpalamlulam. Andi ulamlulamnena, yubu hekto lelapmendi, andi wanaag seneragto ulpalamlulam. Andi nimi ni sembe o'ona senelamsimendi, Yesusag “Nu Saelbamsilne sikne,” aro seneraglamlulam. Nia mangkina undo andi wanaag seneragtopne lag phoro ulpalapmendi, “Imnikti, nari ulamnange sindi babe nelepto ulpalamukang,” aro ulpalamlulam. ");
INSERT INTO kkl_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Undo ulpalapmendi, andi sol wali uro Allah yubu mome toro pairopneag agha kemero nimi whingag ambarelamsululam. Lero ambarelamsimendi, “Sindi babe saelbahengdi uaheng,” aro nimi elnenero wenelamsilulam. Undo Allah yubu ambarelamsimen paghabog na amik anag yanun. ");
INSERT INTO kkl_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","“El nenehinne ambatto wenelamsululam,” aro ambatkennena, samenag Yesusag seneragtop nimi wenehinnangdi andi usoghag sae pipkeongdi, Allah yubu silimu tiptop yubu ambatkeong. Sindi Allah yubu silimu tipto ambatkeong pere agha Allah Yame Walingeri mikipne an nongag pipkeo. Mikipne an nongag pipkeonge salik-malik uro pipkeo kom ane sembe, anag tatkeonge sembe teba'en sembaheng kom. ");
INSERT INTO kkl_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Nia ane wana nhonog uro saelbapmendi, solwali wali uro sik uro tolapmenba, nimiri kembaghiikti, an sembe “Wana hekto el talamlari, wali uro ambarelamsil,” sembaukang. ");
INSERT INTO kkl_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Andamneri ulpalamlamne babe yae weptangkapmendi, andi pamag agha amolamsilamne nene babe “Sengkwanektop yubu ambatsineag” aro yae weapmendi amolamsilulam. Papna koma sik uro ulpalapmendi, solwali wali uro yubu sikne ambarelamsululam. Undo ambarelamsimen tanena andi yubu ka'erop nimi wali nenelamsimendi, andamneri wali neneptangkamlulam. ");
INSERT INTO kkl_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Andi nimi sabal saog nimi yubu mikip uro wembahin koma, yubu yangaro “Nani yabo,” aro wenehirop yubu lelamlulam. Kabuni maboag babe “Nangkabo” sembapmendi wembamsululam. ");
INSERT INTO kkl_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Kelabo sabal kelaboag “Nanin yabo,” sembapmendi, wembamsululam. Kelmaboap saren kelaboap “Naipsa'el yabo,” sembapmendi, “Saelbahane,” semban koma walinge aghabog ulamsimendi, wembamsululam. ");
INSERT INTO kkl_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Kelabo kaldam kelabo sin mo urop kelabo “Nanin yabo,” aro paliag nembamsilulam. ");
INSERT INTO kkl_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Aghana kaldam kelabo sikin maboro, sikinau yaboro wamik tanena sikin maboag samenag wembamsululam. Sikinin kaldam kel taonge sembe wenelamsimendi, “A'undi ae lomag nimi 'Teko wamikag,' aro o'ona senero kembamsimunne agha Allah wana yeng nembamlulom. A'uni a'unindi samenag sindi wana wali uro mo'olamsiong ane sembe, a'uni a'uninap tangoro walia ulamsimundi, yeplamsululom” aro wenelamsululam. Undo unulamikne nene agha Allah yeng sirik neneropne wamla. ");
INSERT INTO kkl_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Kelabo kaldam kelabo otsik uro kaldam kel elmo urop kelenekori, eldi seneragna wana Allahag paia uropti, teko elag ualne sembe sinag kweleknag “Allah yepnelul,” aro molona moloro ua urop. ");
INSERT INTO kkl_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Aghana kelabo kaldam kelabo agha wana sesog uro seneragto nia mangkina sembe “Naringe wamsori, yeng nembaneho,” senerop kelabo babe wamang. Kelabo undop saog kelabo hain epto kon kamag ua urop aghana, wana seneragna loba uro seneragtop. ");
INSERT INTO kkl_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Kaldam kelabo sembe “Undo-undo ualulom,” aro yubu tam ambarelangkennena, “Ora nimiri Allah Elmaboag tam paipsiikag,” aro ambatkinuanne nene, nen tipto Yesusag seneragtop nimi ambarelamsululam. ");
INSERT INTO kkl_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Yesusag seneragtop nimiri sindi ae lom nimi yepsin kom tanena, mali sirik urop nimi sembanep. Sunumna nhon ambatkenuan. Nu Yesusag seneragtop nimiri senelamapne, sin Yesusag seneragtop kom nimi sembe “Sindi malia ulamsiang,” senelamap. Aghana, sindi kelabo kelme mabo taptopneap, sikini sikinin yaboap yae paiamsiangdi, o'ona seneltalamangne walinge ulamang. Wali uro paia ulamangne nene Yesusag seneragtop nimiri unuaheng, aghana Yesusag seneragtop nimi nhondi ili ilinap, eldi kel kelmabo maboap wali uro yae piamsile kom tanena, nimi eneko agha sik mali sirik nimi sembanep. Undop saog nimiri pamag agha “Yesusag seneraglamna” lerop aghana, sindi ul piropne neneag agha Yesus wa'eploa saog urop. ");
INSERT INTO kkl_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","“Kaldam kelabo yepsukap,” aro mome si tolapsimun tanena salik-malik uro si topsiseng kom. Kaldam kelabo agha mome siag tobongkipsinep kelabona, ela'ange ot nhonog torop kelabo agha, heng kun-kunne teng phende eptopneap saog (60) phiro wamik kelabo agha mome siag tobongolamsululom. ");
INSERT INTO kkl_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","“Yepsukap,” aro mome siag tobongkiamsimunne, kaldam kelabori walinge maikno ulamikpa, nimiri iamsikti, “Walia ulamla,” aro ambatkiik tanena kaldam kel eneko mome siag tobongolamsululom. Kaldam kelabo agha mome siag tobongkipsinep kelabori wali-walia ulamangnena: elmabo wali uro mo'oamsil kel nimi yalamangne yeplamsildi, “Ae lomag aingniro wamlulom,” aro toro palilamsil kel Yesusag seneragtop nimi sembe wana mamleba yeplamsil kel nimi kwema wamsilne yeplamsil kel sol wali, wali uro nia mangkina walia ulamla kel Undo urop kaldam kelabo agha mome siag tobongkipsimundi, yepsululom. ");
INSERT INTO kkl_vpl VALUES ("T15_11","084_5_11","1TI","5","11","12","Kaldam kelabo saren saog wamik kelabo sindi si momeag tobongkipsiseng kom. Saren saog wamik kelabo agha tobongkipsimun tanena, sindi “Nengabo nen nhon tomna koma, Yesustinge wamnun,” seheng. “Nengabo nen nhon toamna koma Yesustinge wamun,” seheng aghana amik sindi kon kemeptaikpa, sin kon eren wamsileri, ulogsilenge sembe “Nu nengabo toro aukap,” sukang. “Nengabo nhon tomnun kom,” selenge phibaleri, Yesus Kristus poneko laplobi agha nengabo tomnep. Salag leropne phibaleri, nengabo topleba, “Allahri elag tam ikinne pipleag,” aro, anamag sin kon eren wamsile kelabori si momeag topsiseng kom. ");
INSERT INTO kkl_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Apna saren saog wamik kelabo agha tobongkipsimundi, yepsimun tanena sindi saeri sa'a-sa'a uan koma, nimi yepsinep kom yubu agha tipto ambatto tongolamikti, sunsunum urop kom yubu agha lero ae nhonag wa'ang nhonag wa'ang ulamukang. Sindi ae eneag wa'ang, ae eneag wa'ang ulamikpa, ora nimiri tam ua ulamle tanena urukag wa'ina salel wa'alamukang. ");
INSERT INTO kkl_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Ane sembe nari sembamnangena, “Kaldam kelabo saren saog wamik kelabo agha 'Yepsukap,' aro mome siag tobongkipsiseng kom,” sembamna. Kaldam kelabo sin saren saog wamik kelabo wenelamsimenne, nengabo toro aikti, me mangaro sindi aeag wamikne “O'olamsululom,” aro wembamsilulam. Undo ambareamsimenba wamikti, walinge ulamik andarina nunag aisa nenelamsiang nimiri nu san tilibahinep kom. ");
INSERT INTO kkl_vpl VALUES ("T15_15","084_5_15","1TI","5","15","16","Kaldam kelabo etpare phia sikini nubunge yubuag nelebaong ane sembe, kaldam kelaboag, “Undo-undo ulamlulom,” aro ambatsilulamne ambatken. Yesusag seneragtop nimiri ae lom nimi agha kaldam kelabo taik tanena, ae lom eneko wamik nimiri kaldam kel eneko yeplamukang. Yesusag seneragtop nimi poloro winiptangtop nimiri awe yogne uanepne wamla ane sembe, kaldam tale kel eneko ae lom eneko Yesusag seneragtop nimi wamik tanena sindi keleneko yeplamukang. Sindi el undo yeplamik tanena Yesusag seneragtop nimi poloro winiptangtop nangna sae laia agha kaldam kelabo sik uro mo urop kelabo yelamsukang. ");
INSERT INTO kkl_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Allah Elmabo wenehiropnangdi wali uro saelbamsindi, wali uro o'olamna tanena, “Nu wali uro saelbamsildi wali o'olamsil,” aro kamna kipto tatsimunne nene sunsunum wamla. A'un Allah yubu ambatto wenehiropnangdi a'un wenelamsiangdi, amolamsiang ane sembe, a'undi sin wenehiropnang sembe amik nembahin koma sin nimi whingagne nembamsimundi, tatsululom. Undopne agha sunsunum. ");
INSERT INTO kkl_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Kamna tatsiikne neneko sembe Allahri Yubu Momeag Musari sae pere agha mome toro pairopne wamla. Mome toro paibognena, “Nimiri awe torop nimiri pham sapi kerekamnari, 'Kwaneng roti sununa gandum wana kolopto yingkileba, poloro anun,' aro pham sapi yagto pabalamna. Pham sapi yagto pabalamnange abeneko pere, 'Yo'oag ingirop pham sapiri roti wana teleag,' aro pham ua'al aroro kauptop saog uro kaupseng kom,” aro mome tobog. Pham sapi sembe mome tobog aghana, “Nimi awe torop nimi el awe tomnange sembe kamna tatsiikne abenekoog sunsunum,” aro mome toro paibog. ");
INSERT INTO kkl_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Allah yubu amoro wenehirop nang kiplamsimunba, nimi nhondi a'un wenehiropnangag tam palilamsiikti, “Eldi malia undo unual,” aro ot nimi nhondi leplenge sembe sik sembaheng kom. Nimi phende wilindiri, “Eldi malia undo unuaoba, ibobo,” aro lebik taneogna “Sik to, kom to,” aro tam lelekto kembamlulom. ");
INSERT INTO kkl_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Nimi malia uropne sembe Allah yubu ka'erop nimi ni whingag agha wembahimenba, nimi orange babe “Malia ulamebeag,” aro log senelamikti, walinge aghabog ulamukang. ");
INSERT INTO kkl_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Ni tam lepnange sembe ambarelangkenne sunsunum uro sik uro ulpalamlulam. “Na nimi nhonag sip tanun,” semban koma anna agha nimi anabiag sikne agha ulamlulam. Nia “Undo-undo ulamlulam,” aro ambatkenne Allahap Kristus Yesusap Allah arukna malaikat walinge wepsiropneap whingag agha andi sa'oag palilamnaba, nimiag ulpalapmenne kemelangkukang. ");
INSERT INTO kkl_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","“Allah Elmabo saelba uahiropne wamlul,” aro elemag abeneko nimi usoghag sae pipsiseng kom. Ekonne agha elemag nimi usoghag sae pipmendi, sekitmen tanena, nimi enekori malia ulamleba, anap elap sae tiptangto wamtumunne sembe andi babe malia ulamlam. Ane sembe “Eldi malinge ulamlenge na sa'oag taleag,” aro andi, “Allah Elmabo saelba uahiropne talul,” aro nimi elemag sekitsilulam kom. ");
INSERT INTO kkl_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","An sop-sop mon og aghabog telangkelba, niklamlamdi pesa ulangkel ane sembe, mag salingeog tero wamseng kom. Anggur mag olog maghag ikto pelengkia telapmenba, an mon telangkelne nene yepkelul. ");
INSERT INTO kkl_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Nimi etbareri malinge uroba sembenga saogne paliropne anam tam lelekto kareptobag agha kemban kombog lag wamla. Aghana nimi etbareri malia uropne anam tognorop saog wamlaba, amik lag talul. ");
INSERT INTO kkl_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Undo saog uro babe nimiri walinge ulpiropne lag wamla. Nimiri walinge tognoro ulpiropne wene wamlaba, iamap kom aghana, walinge ulpiropne neneko tognorobag wamnep komdi, lag ua ulamlul. ");
INSERT INTO kkl_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Yesusag seneragtop nimi, nimi arukna sae kauploa saog uro awe ikinne torop nimi wamik tanena, sikini sikinin yabori aruktop yubu ka'elamsiikti, “Kipsunun,” aro sunsunum uro tolamukang. Tolamik abeneko pere sindi seneraglamikne, “Nimiri na kembaneikti, Yesus sembe ambarelamsiap yubu mali sembaikagti, Allah omeklamap poneko san tiliplamikag,” aro sol wali uro awe tolamukang. ");
INSERT INTO kkl_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Yesusag seneragtop nimi agha nimiringe awe toropne arukna wamleba, ili poneko babe Yesusag seneragtopne wamle tanena, arukna wamlenge ponekori, “Nu Yesusag seneragtop nimi wamnam,” aro ili poneko luknunne ualul kom. Undo luknuro ualul kombog arukna wamlenge ponekori ili poneko sembe “Naba nani Yesusag seneraglamlaba, Yesusti o'ona seneropne wamlaba, nari babe o'ona senero yepnun,” senelamlul. Undo senelamleri, “Wali uro yepnun,” aro ili poneko sembe awe tolamlul. Ni ambatkenne abene ambareamsimendi wembamsululam. ");
INSERT INTO kkl_vpl VALUES ("T16_3","084_6_3","1TI","6","3","4","Nuri ambarelamsiap yubu neneko Allah wana wali neneropne sunsunum urop yubu ambarelamsiap. Nuri ambarelamsiap yubu nenekona, Allahri “Taulbahimendi, saelbamsululam,” aro weptopne Yesus Kristus ponekori yubu sikne sunsunum urop yubu ambarelamsiap. Nuri ambarelamsiapne sunsunum urop kom yubu agha nimi nhondi ambarelamsile tanena, nimi eneko metmereng arop nimi sa'a-sa'a ekon nimi wamla. Nimi undop nimi enena, naikna salehirop nimi saog wamlari, nimiap-nimiap loba neneptaheng arop yubu kikiag agha leleng-lelenga lelamla. Leleng-lelenga pan khelamsilba, nimiri ka'elbina sin yubu neneptangka sin waptangto leldalamnari, “Nu luknubahaikag,” aro waptangto loba neneptanep. Sindi yubu pan khero suknulamang yubu sembe waptangto leldalamangdi, “Nu luknubahaikag,” aro wana mali seneldalamang. Sinag yubu pan khelamsiangne yubu suknulamangne sindi ka'ebiagha “A'undi undo-undop,” aro waldalamangdi, wana mali neneldalamang. ");
INSERT INTO kkl_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","Undo unuropne agha nimiri seneragna loba neneldalamangdi, Allah yubu sikne Yesus sembe seneragna koma yubu sik komne sembe nimiap-nimiap sop-sop waptangto yubu leldalamang. Undo unurop nimiri Allah yubu paliag nenero ambarelamsiseng aghana, Allah yubu sikne seneragtopne sinag ekon wamla. Sin elwamsilnena, “Allah yubu ambarelamsineba, ka'erop nimiri kal ma'al maikno tarelamnukang,” aro seneragtopne agha sinag waml