﻿USE sofia;
DROP TABLE IF EXISTS sofia.kkj_vpl;
CREATE TABLE kkj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kkj_vpl WRITE;
INSERT INTO kkj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mɛkana maka kɛ lɛpɔ kasi Yesus Krist nɛ̀ mɛɗinɔ mɛ ɓesaŋmbambɔ ɓenɛ. Nyɛ nday Davit, nday Abaraham. ");
INSERT INTO kkj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraham jama Isak, ɛ Isak ja Yakɔp, ɛ Yakɔp ja Yuda ɓenɛ ɓemaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda jama Farɛs nɛ̀ Jara kɛ mɔy nyaŋgwɛ te wan Tamar. Farɛs jama Ɛsrom, ɛ Ɛsrom ja Aram. ");
INSERT INTO kkj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram jama Aminadap, Aminadap jama Nasɔn, ɛ Nasɔn ja Salmɔn. ");
INSERT INTO kkj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔn jama Bowas kɛ mɔy nyaŋgwɛ te wenɛ Rahab, ɛ Bowas ja Yobɛd kɛ mɔy nyaŋgwɛ te wenɛ Rut. Yobɛd jama Isay, ");
INSERT INTO kkj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isay jama Davit, ɛ kumande Davit ɓu̧ nya Uri ja nɛ Salomɔŋ. ");
INSERT INTO kkj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔŋ jama Robowam, Robowam jama Abiya, ɛ Abiya ja Asa. ");
INSERT INTO kkj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa jama Yosafat, ɛ Yosafat ja Yoram, ɛ Yoram ja Osiyas. ");
INSERT INTO kkj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas jama Yoyatam, Yoyatam jama Akas, ɛ Akas ja Esekiyas. ");
INSERT INTO kkj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas jama Manase, Manase jama Amɔn, ɛ Amɔn ja Yosiyas. ");
INSERT INTO kkj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyas jama Yekoniyas ɓenɛ ɓemaŋ kɛ ŋgimɔ te yi ɓo ɓiyma nɛ Ɓɔnɔ ɓe Isarayɛl kɛ̀ nɔ kɛ ɗiyɔ bala kɛ Babilɔn kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kɛ yɔkwa̧ ɗiyɔ bala kɛ Babilɔn, ɛ Yekoniyas ja Salatiyɛl, ɛ Salatiyɛl ja Sorobabɛl. ");
INSERT INTO kkj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabɛl nja̧ ja Abiyud, Abiyud jama Eliyakim, ɛ Eliyakim ja Asɔr. ");
INSERT INTO kkj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔr jama Sadɔk, Sadɔk jama Akim, ɛ Akim ja Eliyud. ");
INSERT INTO kkj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud jama Eliyasar, Eliyasar jama Matan, ɛ Matan ja Yakɔp. ");
INSERT INTO kkj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔp nja̧ ja Yosɛp te njoŋɔ nɛ Mariya. Yo Mariya te ja Yesus te yi ɓo jeɓa nde *Krist kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ɗete, kandɛ Abaraham kumɔ Davit ɓomɔ jaɗya nɛ ndɛndi te kumɔ kamɔ jɔ yini. Kandɛ Davit kumɔ kɛ ŋgimɔ te yi ɓo ɓiyma nɛ Ɓɔnɔ ɓe Isarayɛl kɛ̀ nɔ kɛ ɗiyɔ bala kɛ Babilɔn kɛ́, ɓomɔ jaɗya nɛ ndɛndi te kumɔ kamɔ jɔ yini. Kandɛ kɛ ŋgimɔ kɛna ɗiyɔ bala kumɔ kɛ ŋgimɔ jariki Krist ɓomɔ jaɗya nɛ ndɛndi te kumɔ kamɔ jɔ yini sendi. ");
INSERT INTO kkj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jariki Yesus Krist kwaŋnama ɗekɛ: Yo ɓa̧ kponate nde, nyaŋgwɛ wenɛ Mariya ta kelɔ gwaki ɓenɛ Yosɛp. Ma piŋɔ te yi ɓenɛ nyɛ tì pa ɓokwɛ to, ɛ Mariya semɛ nde, a mɛ nɛ mɔy nɛ ɗeti te yi Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Njoŋɔ wenɛ Yosɛp ɓa̧ nɛ ŋgbeŋ. A tì kwaɗyɛ wuŋgwɛ nyɛ kɛ mbɔmbu ɓomɔ na. Ɛ nyɛ pɛsɛ nde, a ta tikɔ nyɛ kinɛ nde, ɓomɔ dûkwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Piŋɔ te yi nyɛ ɓa̧ ndi kɛ takina ɗete kɛ́, ɛ wɛtɛ jaki Baba Mbokɔ ɗya̧ kɛ yenɛ nɛ nje te yi nyɛnɔ lɛpɔ nyɛ nyɛ nde: «Yosɛp te mɔnɔ Davit, wɛ tî gwaki wɔ̧ te yi ɓu̧ nyari wɔ Mariya nɛ mɛgwaki na, kɛto mɔy te yi nyɛ nɔ kɛ́, a ɓóŋ nɛ ɗeti te yi Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A ta ja mɔnɔ mbam, wɛ ta lo nyɛ nde Yesus, kɛto yo nyɛ ta joŋgwɛ ɓotu ɓe kandɔ ɗyenɛ kɛ mɛɓeyɔ man.» ");
INSERT INTO kkj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mɛyasi mɛte hɛnɛ kwaŋnama ɗete, nɛ́ lɛpi te yi Baba Mbokɔ kwaŋɗya kɛ numbu mɔ punja mɛlɛpi mɛnɛ kɛ́ si tôndu. ");
INSERT INTO kkj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A lɛpima nde: ‹Nɛ ɓɛ̂ŋa, ɓindi ŋgɔndu ta tɔkɛ mɔy ja mɔnɔ mbam. Ɓo ta lo nyɛ nde Emanuwɛl.› Yite nde: Njambiyɛ mɛ sinɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kɛ Yosɛp ma jemiyɛ kɛ́, ɛ nyɛ kelɛ nda yi jaki Baba Mbokɔ lɛpima nyɛ nyɛ kɛ́. Ɛ nyɛ ɓu̧ nyari wenɛ Mariya. ");
INSERT INTO kkj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko a tì kpokɛ nyɛ na kumɔ kɛ ŋgimɔ te yi Mariya jama nɛ bosa mɔnɔ wenɛ, mɔnɔ mbam. Ɛ Yosɛp lo nyɛ nde Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus jaɗya kɛ Betɛlɛhɛm kɛ mɛnɛti mɛ Yuda kɛ ŋgimɔ te yi Herod ɓa̧ kumande kɛ́. Yo ɓa̧ nɛ ɓotu ɓe duwa̧ mɛyasi kɛ kasi ɓesisɔ̧. Ɛ ɓo tɛmɛ wulɛ pulɔ komɛ yesɔ pundɛ kɛ́ ɗya̧ kɛ Yerusalɛm ");
INSERT INTO kkj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","diyɛ nde: «Kumande Ɓeyudɛn te ɛ jaɗya kɔkɔ te tì pa kikɔ kɔ ɓa we? Kɛto wusɛ semma sisɔ̧ wenɛ kɛ pulɔ komɛ yesɔ pundɛ kɛ́, ɛ wusɛ nje yí nje kanɔ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kɛ kumande Herod ma wokɔ ɗete kɛ́, ɛ lɛpi ɓanɛ nyɛ ɓenɛ ɓotu ɓe Yerusalɛm hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ɛ nyɛ wesiɗye ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ hɛnɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ɓe kandɔ Isarayɛl yí diyɛ ɓo mbɛy te yi *Krist yâkaŋgwɛ jaɗyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Kɛ Betɛlɛhɛm kɛ mɛnɛti mɛ Yuda, kɛto mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima nde: ");
INSERT INTO kkj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ma wɛ Betɛlɛhɛm kɛ mɛnɛti mɛ Yuda, ko wɛ yeti mɔnɔ ɗya kɛ njoka kpasa mɛɗya mɛ mɛnɛti mɛ Yuda na, kɛto kum te ɛ ta kɛndɔ nɛ kandɔ mbɛ Isarayɛl kɔ ta wulɛ ndi kɛ yɔ.› » ");
INSERT INTO kkj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ɗete, ɛ Herod jeɓa ɓotu ɓe duwa̧ mɛyasi nɛ sɔ, ɛ nyɛ kombile diyɛ ɓo ŋgbak ŋgbak ŋgimɔ te yi sisɔ̧ te punduma nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kɛ kɔŋte, ɛ nyɛ tomɛ ɓo kɛnjɛ kɛ Betɛlɛhɛm lɛpɔ nde: «Nɛ kɛ̂n, nɛ̀ wunɛ dîya yasi kimɔte kɛ kasi mɔnɔ te. Kɛ wunɛ si dolɔ nyɛ, nɛ̀ wunɛ njâki nje lɛpɔ nyɛ mi, nɛ́ mi nɛ ŋguru wombɛ kɛ̀ sendi kɛ̀ kanɔ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kɛ ɓo ma si lɛŋgwɛ mɛtɔ kɛ yasi te yi kumande lɛpima kɛ́, ɛ ɓo kwa̧. Ɓo sém semɔ, sisɔ̧ te yi ɓo ɓɛŋma kɛ pulɔ komɛ yesɔ pundɛ kɔ kɛ kɛndɔ kɛ mbɔmbu yan. Kɛ nyɛ ma kumɔ ndi kɛ mbɛy te yi mbɔŋgɔ mɔnɔsikɛ ɓa̧ kɛte kɛ́, ɛ nyɛ tɛmɛ. ");
INSERT INTO kkj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɛ ɓotu ɓe duwa̧ mɛyasi ma nje semɔ sisɔ̧ nɛ kɔkɔ kɛ́, ɛ ɓo sosa ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓo nyiŋma tu̧ dolɔ mbɔŋgɔ mɔnɔsikɛ ɓenɛ nyaŋgwɛ wenɛ Mariya, ɛ ɓo kusɛ mɛɓɔŋ kɛ mɛnɛti kanɔ mbɔŋgɔ mɔnɔsikɛ. Ɓo walma kpasa kimɔ mɛyasi mɛte yi ɓo nja̧ nɔ kɛ́ nyɛ nyɛ. Yo ɓa̧ lɔr nɛ̀ yiŋa kpasa njɔnju jeti ɓu̧ yiŋa lɔbinda te yi ɓo kelɛ nɛ wɛtɛ mbunjɔ nde *mir kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kɛ kɔŋte, ɛ Njambiyɛ lɛpɛ nyɛ ɓo nɛ nje te yi nyɛnɔ nde, ɓo tî yɔkwɛ nɛ kɔkɔ kɛ̀ punjɛ misi nyɛ Herod na. Kɛ nyɛ ma lɛpɔ nyɛ ɓo ɗete kɛ́, ɛ ɓo tɔkɛ mbaŋa nje dɛlɛ yí ɗuwɛ nɔ kɛ̀ nɔ ɗya ɗyan. ");
INSERT INTO kkj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɛ ɓotu ɓe duwa̧ mɛyasi ma si kwa̧ kɛ́, ɛ wɛtɛ jaki Baba Mbokɔ nje punjɛ yotu nyɛ Yosɛp nɛ nje te yi nyɛnɔ lɛpɔ nyɛ nyɛ nde: «Tɛma, ɓoŋgɔ mbɔŋgɔ mɔnɔsikɛ ɓenɛ nyaŋgwɛ ɓɔmbɔ nɔ kɛ̀ nɔ kɛ Ejipt. Wunɛ ɗîy mate kumɔ kɛ ŋgimɔ te yi mi ta lɛpɔ nyɛ wɛ, kɛto Herod ta sa̧ nje te yi wo mɔnɔsikɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɗete, ɛ Yosɛp tɛmɛ nɛ tu ɓu̧ mbɔŋgɔ mɔnɔsikɛ ɓenɛ nyaŋgwɛ kwa̧ nɔ kɛ̀ nɔ kɛ Ejipt. ");
INSERT INTO kkj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A ɗiyma mate kumɔ kɛ ŋgimɔ te yi Herod gwa̧ nɔ kɛ́. Yo kwaŋnama ɗete, nɛ́ lɛpi te yi Baba Mbokɔ lɛpima kɛ numbu mɔ punja mɛlɛpi mɛnɛ kɛ́ si tondu. A lɛpima nde: ‹Mi jeɓama mɔnmbɛ soŋɛ kɛ Ejipt.› ");
INSERT INTO kkj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kɛ Herod ma ɓɛŋɛ nde, ɓotu ɓe duwa̧ mɛyasi seɓila nyɛ kɛ́, ɛ njoŋ nɛ tusiyɛ, ɛ nyɛ tomɛ ɓomɔ, nɛ́ ɓo kɛ̀ wo mbɔŋgɔ ɓɔnɔ ɓembam hɛnɛ kumɔ kɛ ɓaka ɓe nɛ sew yiɓa kɛ Betɛlɛhɛm nɛ̀ kɛ pɔku te yite. A pɛsima mɛsew mɛ ɓɔnɔ ɓembam ɓete yi ɓo yâkaŋgwɛ wo ɓaka ɓeŋgwɛ ŋgimɔ te yi ɓotu ɓe duwa̧ mɛyasi semma nɛ sisɔ̧ nda yi ɓo lɛpima nyɛ nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɗete, lɛpi te yi Jeremi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima nɛ mbɔmbu kɛ́ kelnama gbate. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‹Ɓo wokuma mɛkembi kɛ Rama, mɛɗukwe nɛ̀ ɓeya nyaŋgwɛ mɛjaɓa. Rasɛl kɛ lelɔ ɓɔnɔ ɓenɛ, a ti kway nde, mumɔ wɛ̂ɗya temɔ nɛ na, kɛto ɓɔnɔ ɓenɛ yeti se na.› ");
INSERT INTO kkj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kɛ Herod ma gwe kɛ́, ɛ wɛtɛ jaki Baba Mbokɔ punjɛ yotu nyɛ Yosɛp nɛ nje te yi nyɛnɔ kɛ Ejipt lɛpɔ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Tɛma, ɓoŋgɔ mbɔŋgɔ mɔnɔsikɛ ɓenɛ nyaŋgwɛ ɗuwɛ nɔ nɛ kɔkɔ kɛ̀ nɔ kɛ Isarayɛl, kɛto ɓotu ɓete ɓe kwaɗya wo nyɛ ɓaka ma gwe.» ");
INSERT INTO kkj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɛ Yosɛp tɛmɛ ɓu̧ mɔnɔsikɛ ɓenɛ nyaŋgwɛ yɔkwɛ nɔ kɛ̀ nɔ kɛ Isarayɛl. ");
INSERT INTO kkj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma kɛ Yosɛp ma wokɔ nde, yo Arkelas ɓu̧ ɗiyɔ kumande kɛ Yuda kɛ numbu saŋgwɛ wenɛ Herod kɛ́, ɛ nyɛ gwe wɔ̧ te yi yɔkwɛ kɛ̀ mate. Yasi wɛtɛ, a nja kwa̧ kɛ̀ kɛ Galile nda yi Baba Mbokɔ nja̧ lɛpɔ nyɛ nyɛ kɛ nyɛnɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A ka̧ ɗiyɔ kɛ wɛtɛ ɗya nde Nasarɛt. Yo kelnama ɗete, nɛ́ mɛlɛpi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ si tondu. Ɓo lɛpima nde: ‹Ɓo ta jeɓa nyɛ nde Mɔ Nasarɛt.› ");
INSERT INTO kkj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kɛ ŋgimɔ te yite Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku punduma kandɛ pelna Kimɔ Tom kɛ koŋgor kɛ mɛnɛti mɛ Yuda. ");
INSERT INTO kkj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A ɗikima lɛpɔ nde: «Wunɛ yêŋsaŋgwɛ temɔ, kɛto *Kandɔ te yi kwey ma wuta.» ");
INSERT INTO kkj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaŋ, nyɛ mɔ te yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kasi nɛ nde: ‹Wɛtɛ mumɔ kɛ kembiɗya kɛ mɔy koŋgor nde: Wunɛ kômbila nje Baba Mbokɔ. Wunɛ tɛ̂mbiɗya mɛnje mɛnɛ nɛ ŋgbeŋ.› ");
INSERT INTO kkj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jaŋ ɗikima lɛŋɛ nɛ wɛtɛ lambɔ te yi ɓo kelma nɛ mɛmburu mɛ *samo kɛ́. Mɛɗye mɛnɛ ɓa̧ ɓeɗɔlɔ nɛ̀ mutɔ mɛ jo te yi nyɛ ɗikima dolɔ kɛ likɔ kɛ́. Kanda te yi nyɛ ɗikima lɛŋɛ kɛ jon kɛ́, ɓo kél yo nɛ kotu nyamɔ. ");
INSERT INTO kkj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓotu ɓe Yerusalɛm nɛ̀ ɓotu ɓe Yuda nɛ̀ ɓotu ɓete ɓe ɗikima ɗiyɔ kɛ pɔku goŋ Yurdɛ̧ ɓaka ɗikima nje hɛnɛ pɛlɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɛ ɓo ɗiki jayɛ ɓeya mɛkele man kɛ mbɔmbu ɓomɔ, ɛ Jaŋ ɗiki tɔpɛ ɓo kɛ mɔrɔku kɛ Yurdɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kɛ Jaŋ ma ɓɛŋɛ nde, *Ɓefarisɛ̧ nɛ̀ *Ɓesadusɛ̧ ɓuɗyate kɛ nje kɛ yenɛ, na tɔpi ɓo kɛ mɔrɔku kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ mbo yeri, nda lɛpɛ nyɛ wunɛ nde, wunɛ yakama diyɔ lalɛ kɛ ŋgambi Njambiyɛ yi nje kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wunɛ kêl mɛkele mɛte yi teɗye nde, wunɛ ma yeŋsa temɔ. ");
INSERT INTO kkj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wunɛ tî ɓoɓa lɛpɔ kɛ mɔy temɔ yun nde, wunɛ ɓenday ɓe Abaraham. Kɛto mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Njambiyɛ yakama yeŋsa mɛtari mɛte yikɛ nde, yo ɓɛ̂ki ɓɔnɔsikɛ nyɛ Abaraham. ");
INSERT INTO kkj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Njeŋ mɛ nɛ lɛndɛ kɛ njuku jeti, ɗete jeti hɛnɛ ɛ ɗiyɛ kinɛ wumɔ kimɔ mɛmbumɔ, ɓo ta pɛsɔ nyɛ ɓetɛ kɛ ɗitɛ. ");
INSERT INTO kkj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi tɔ́pa mbɛ wunɛ nɛ mɔrɔku yí teɗye nde, wunɛ ma yeŋsa temɔ. Yasi wɛtɛ, mɔ te ɛ nje kɛ kɔŋ mbɛ kɔ ta tɔpɛ nɛ wunɛ kɛ Kimɔ Sisiŋ nɛ̀ kɛ ɗitɛ, kɛto a nɛ ɗeti kwa̧ mi. Ko mi ti yaka sɔrɛ mɛnakala kɛ kol nɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A nɛ jeti kɛ ɓɔ yí kutɔ nɛ nyambi, yí ɓakɛ njɔsɔ te nɛ̀ kopu te. A ta soŋɛ njɔsɔ nyambi kɛ̀ ɓakiɗye kɛ ndam. Ma a ta loɗyɛ mɛkopu mɛte kɛ ɗitɛ te yi ti ɗím kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kɛ ŋgimɔ te yite ɛ Yesus tɛmɛ kɛ Galile kɛ̀ kɛ yi Jaŋ kɛ goŋ Yurdɛ̧, nɛ́ Jaŋ tɔpi nyɛ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yasi wɛtɛ, ɛ Jaŋ sɛŋɛ kutuɗya lɛpɔ nde: «’Yeti gba wɛ yâkaŋgwɛ tɔpɛ mi kɛ mɔrɔku na? Nan yi wɛ kpalɔ nje nde, mi tɔ̂pa wɛ kɛ mɔrɔku kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Tikɔ, nɛ́ yo pa kelna ɗete ndana, kɛto yo kimɔte nde, wusɛ tônjukwɛ mɛyasi hɛnɛ te yi nɛ ŋgbeŋ nda yi Njambiyɛ kwaɗyɛ.» Ɛ Jaŋ jayɛ kinɛ pitiɗye se yaŋa nyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ndi nɛ tɔpuna nɛ kɛ mɔrɔku, ɛ Yesus ɓendɛ ŋgindi nɛdɔ. Semɔ semɔ, ɗyoɓɔ nɛmbiya, ɛ nyɛ ɓɛŋɛ Sisiŋ Njambiyɛ kɛ piyɛ nda pepɔ nje kɛ yotu nɛ ");
INSERT INTO kkj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","yaka nɛ wɛtɛ mɛn kɛ wulɛ ɗyoɓɔ lɛpɔ nde: «Yɔkɔ mɔnmbɛ, sɔŋ temɔ mbɛ, temɔ mbɛ hɛnɛ kɛ yotu nɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kɛ kɔŋte, ɛ Kimɔ Sisiŋ kelɛ nde, Yesus kɛ̂n kɛ koŋgor, nɛ́ *Kum ɓeya mɛkele kɛ̀ ɓoɓi nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus kiyma mɛɗye yaka mɛyesɔ kamɔni nɛ̀ mɛtu kamɔni. Kɛ kɔŋte, ɛ nyɛ wokɛ nja. ");
INSERT INTO kkj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ɛ *Mɔ ɓoɓuna ɓomɔ kɔ nje kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, wɛ Mɔnɔ Njambiyɛ, lɛpɔ nyɛ mɛtari maka nde, yo yêŋsaŋgwɛ ɓɛ mampa.» ");
INSERT INTO kkj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yasi wɛtɛ, ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Mumɔ ti yaka joŋna ndi nɛ mampa nyɛpɔ na, mumɔ yakama joŋna nɛ mɛlɛpi hɛnɛ te yi pundɛ kɛ numbu Njambiyɛ.› » ");
INSERT INTO kkj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kɛ kɔŋte, ɛ Kum ɓeya mɛkele kɔ ɓu̧ nyɛ kɛ̀ nɔ kɛ Yerusalɛm, ɗya te yi Njambiyɛ tɔkuma, kwa̧ tɛmbiɗye nyɛ kɛ tosiyɔ̧ mbanjɔ Njambiyɛ ");
INSERT INTO kkj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","lɛpɔ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, wɛ Mɔnɔ Njambiyɛ, ɗokɔ piyɛ kɛ mɛnɛti, kɛto yo kɛtinate nde: ‹Njambiyɛ ta nyɛ numbu nyɛ ɓejaki ɓenɛ kɛto yɔ, ɗete ɓo ta jɛkiɗye ɓɔ ɓiye nɛ wɛ, kambɔ wɛ mɛ nje ɗumɔ kol yɔ kɛ tari.› » ");
INSERT INTO kkj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Yo kɛtinate nde: ‹Wɛ tî ɓoɓa Baba Mbokɔ te Njambiyɛ wɔ na.› » ");
INSERT INTO kkj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɛ Kum ɓeya mɛkele kɔ ɓu̧ nyɛ sendi, kɛ̀ nɔ kɛ wɛtɛ nyaŋgwɛ ɗɔŋna keki, teɗye nyɛ mɛkandɔ hɛnɛ kɛ to mɛnɛti nɛ̀ mɛnyɔŋɔ mɛte yi ɗiyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Mɛyasi mɛnɔri hɛnɛ, mi ta nyɛ wɛ yo, ŋgɛ wɛ kusɛ mɛɓɔŋ kɛ mɛnɛti kanɔ mi.» ");
INSERT INTO kkj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «*Satan, lɔndɔ kɛ kɛki mbɛ. Yo kɛtinate nde: ‹Kanɔ Baba Mbokɔ te Njambiyɛ wɔ, kelɔ mɛsay nyɛ ndi nyɛ nyɛpɔ.› » ");
INSERT INTO kkj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndana, ɛ Kum ɓeya mɛkele kɔ tikɛ nyɛ, ɛ ɓejaki ɓe Njambiyɛ nje nje kelɔ mɛsay nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kɛ Yesus ma wokɔ nde, ɓo ɓiyma Jaŋ nyɛ kɛ jɔɓɔ kɛ́, ɛ nyɛ tɛmɛ kwa̧ kɛ̀ kɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A ɗuwa̧ kɛ Nasarɛt kɛ̀ ɗiyɔ kɛ Kapɛrnawum kɛ goŋ matɔ kɛ mɛnɛti mɛ Sabulɔŋ nɛ̀ Nɛftali. ");
INSERT INTO kkj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mɛyasi kwaŋnama ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","A lɛpima nde: ‹Ɓotu ɓe mɛnɛti mɛ Sabulɔŋ nɛ̀ Nɛftali pɛlɛ pɔku nyaŋgwɛ matɔ kɛ ŋginjɛ Yurdɛ̧, mɛnɛti mɛ Galile te yi ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka, ");
INSERT INTO kkj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ɓotu ɓaka ɓe ɗiyma kɛ mɔy yitil ɓaka ɓɛŋma nyaŋgwɛ mɛjasi. Ɓotu ɓete ɓe ɗiyma kɛ ndiliŋ mbɛy te yi sɔŋ ɓaka, mɛjasi kumma pɛlɛ yan.› ");
INSERT INTO kkj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kandɛ kɛ ŋgimɔ te yite, ɛ Yesus kandɛ pelna Kimɔ Tom lɛpɔ nde: «Wunɛ yêŋsaŋgwɛ temɔ, kɛto *Kandɔ te yi kwey ma wuta.» ");
INSERT INTO kkj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ kɛndɔ kɛ goŋ nyaŋgwɛ matɔ Galile, ɛ nyɛ ɓɛŋɛ ɓembam yiɓa, ɓo púndu mɔy wɛtɛ, Simɔn te yi ɓo jeɓa nde Piyɛr kɔ ɓenɛ maŋ wenɛ Andere. Ɓo ɓa̧ kɛ ɓetɛ bulajama kɛ matɔ, kɛto ɓo ɓa̧ ɓotu ɓe wona ɓenjanjɔ. ");
INSERT INTO kkj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ ɓêŋgwɛ mi, mi ta kelɔ nde, wunɛ ɓɛ̂ki ɓotu ɓe ɗalna ɓomɔ teɗye nje Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɛ ɓo tɛmɛ nɛ ŋgɛt ŋgbɛsɛ mɛbulajama man ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus nja̧ toŋgiɗya kɛ̀ mbɔmbu, ɛ nyɛ ɓɛŋɛ sendi ɓaŋa ɓembam yiɓa, ɓo púndu sendi mɔy wɛtɛ, Jak te mɔnɔ Seɓede ɓenɛ maŋ wenɛ Jaŋ. Ɓo ɓa̧ kɛ mɔy landi ɓenɛ ɓe saŋgwɛ wan Seɓede kɛ kombile mɛbulajama man, ɛ Yesus jeɓa ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɛ ɓo tɛmɛ nɛ ŋgɛt ŋgbɛsɛ landi nɛ̀ saŋgwɛ wan kwa̧ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus kɛndima linje mɛnɛti mɛ Galile hɛnɛ, teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, pelɛ Kimɔ Tom kɛ kasi *Kandɔ Njambiyɛ, siɗyɛ kwalɔ mɛkɔn nɛ̀ kwalɔ mɛkɔsu hɛnɛ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɗinɔ ɗyenɛ wumma kumɔ kɛ ndiŋgɛlɛ mɛnɛti mɛ Siri. Ɓo ɗikima ɓu̧ ɓotu ɓe kɔn hɛnɛ nje nɔ kɛ yenɛ. Yo ɓa̧ ɓotu ɓete ɓe ɓa̧ kɛ wokɔ yotu kwanate nɛ̀ ɓaka ɓe ɓa̧ kɛ saŋgwa nɛ mɛbɔnɛ nɛ̀ kwalɔ mɛkɔn wɛtɛ wɛtɛ nɛ̀ ɓotu ɓete ɓe ɓeya mɛsisiŋ ɗikima njaŋgwɛ ɓo ɓaka. Yo ɓa̧ nɛ ɓotu ɓete ɓe ɓa̧ kɛ kɔnɔ nɛ jaja nɛ̀ ɓotu ɓe kɔsu. Ɓo ɗikima ɓu̧ ɓo hɛnɛ nje nɔ kɛ yenɛ, ɛ nyɛ ɗiki siɗyɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nyaŋgwɛ ŋgil ɓomɔ ɗikima ɓeŋgwɛ nyɛ. Ɓo ɗikima wulɛ Galile nɛ̀ kɛ nyaŋgwɛ mɛɗya kamɔ nɛ̀ kɛ Yerusalɛm nɛ̀ Yuda hɛnɛ nɛ̀ ŋginjɛ Yurdɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kɛ Yesus ma ɓɛŋɛ ɓuɗya ŋgil ɓomɔ kɛ́, ɛ nyɛ kwa̧ ɓendɔ keki kwa̧ ɗiyɔ mɛtiɗyɛ. Ɛ ɓejekɛ ɓenɛ nje kɛ kɛki nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ɛ nyɛ ɓutɛ numbu kandɛ teɗya mɛlɛpi mɛ Njambiyɛ nyɛ ɓo lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ɓotu ɓete ɓe duwɛ kɛ temɔ yan nde, ɓo kinɛ ɗeti ɓaka nɛ mɛsosa, kɛto *Kandɔ te yi kwey, yo yan. ");
INSERT INTO kkj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɓotu ɓete ɓe nɛ ŋgambi kɛ temɔ kɛto mɛbɔnɛ ɓaka nɛ mɛsosa, kɛto Njambiyɛ ta wɛɗye temɔ yan. ");
INSERT INTO kkj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɓotu ɓete ɓe nɛ wɛyna temɔ ɓaka nɛ mɛsosa, kɛto ɓo ta namɔ mɛnɛti maka. ");
INSERT INTO kkj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɓotu ɓete ɓe gwe nja̧ nɛ̀ yɛsiɗyɛ kelna ŋgbeŋ mɛkele ɓaka nɛ mɛsosa, kɛto Njambiyɛ ta nyɛ ɓo ɗeti te yi kelɔ ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɓotu ɓete ɓe gwe ŋgwɛtɛ ɓɛsɔ ɓaka nɛ mɛsosa, kɛto a ta gwe ŋgwɛtɛ yan. ");
INSERT INTO kkj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɓotu ɓete ɓe nɛ temɔ nɛ salɛlɛ ɓaka nɛ mɛsosa, kɛto ɓo ta ɓɛŋɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓotu ɓete ɓe kelɛ nde, ɓomɔ ɗîy nɛ tɛ ɓaka nɛ mɛsosa, kɛto Njambiyɛ ta jeɓa ɓo nde Ɓɔnɔ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɓotu ɓete yi ɓo teɗye ɓo mɛbɔnɛ kɛto ŋgbeŋ mɛkele ɓaka nɛ mɛsosa, kɛto Kandɔ te yi kwey, yo yan. ");
INSERT INTO kkj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kɛ ɓomɔ toyɛ wunɛ teɗye wunɛ mɛbɔnɛ pɛsɔ ja̧ nyɛ kɛ numbu yun lɛpɔ kwalɔ ɓeya mɛlɛpi hɛnɛ nɛ wunɛ kɛto mbɛ, yite wunɛ nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wunɛ sôsaŋgwɛ ɗiyɔ nɛ mbeskere, kɛto nyaŋgwɛ sol kɛ laɗye wunɛ kɛ ɗyoɓɔ. Ɓo teɗya ndi sendi nyaŋgwɛ mɛbɔnɛ ɗete nyɛ bosa ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓe kandima nje nɛ wunɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Wunɛ kwa te yi mɛnɛti maka. Ma kɛ kwa si lenjɔ, ɓo ta kelɔ nan yí yɔkiɗye nɛ som te? Siya yasi te yi ɓo yakama kelɔ, yo nde, ɓo léŋ yo kɛ sɛ̧, ɓomɔ má si natɛ sɔpite. ");
INSERT INTO kkj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wunɛ mɛjasi te yi mɛnɛti maka. Ɗya te yi ɓo sumɛ kɛ to keki kɛ́ yeti nɛ ɗeti te yi sɔma na. ");
INSERT INTO kkj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɓo ti kwénja lambo tikɔ kɛ mɔy mbe na, ɓo ɓóŋ kasɛ kɛ to teɓel, yo má panɔ yí nyɛ mɛyasi nyɛ ɓomɔ hɛnɛ ɓe ɗiyɛ kɛ mɔy tu̧ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɗete sendi, wunɛ pânkwɛ mɛjasi kɛ misi mɛ ɓomɔ, nɛ́ ɓo ɓɛŋ kimɔ mɛkele mun yí lukse nɛ Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Wunɛ tî taka nde, mi njáki nje yaŋgile mɛmboŋga mɛte yi Mɔyisi kɛtima ho yaŋgile teɗya yasi te yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ teɗya kɛ́ na. Mi ti ma njáki yí nje yaŋgile na, mi njáki nje kelɔ yasi te yi mɛmboŋga lɛpɛ kɛ́ kumɔ njena. ");
INSERT INTO kkj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgimɔ hɛnɛ te yi ɗyoɓɔ tì pa yambile, ko gbɛla mɔnɔ mbulma mɛkɛti sikɛ̧ ho gbɛla mɔnɔ yaŋa nɛ mbɛt te yi ɗiyɛ kɛ mɛmboŋga kɛ́ tí yambile kɛte na kumɔ nde, mɛyasi hɛnɛ sîki kelna. ");
INSERT INTO kkj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɗete, mumɔ hɛnɛ ɛ ta yaŋgile ko wɛtɛ mɔnɔ mboŋga te ɛ nɛ mbɛt kɛ njoka mɛmboŋga yí teɗye ɓomɔ nde, ɓo kêl ɗete, ɓo ta jeɓa nyɛ nde njena mumɔ kɛ *Kandɔ te yi kwey. Ma yɔkɔ ɛ ta ɓeŋgwɛ mɛmboŋga mɛte teɗye sendi ɓomɔ nde, ɓo kêl ɗete kɔ ta ɓɛ nyaŋgwɛte kɛ Kandɔ te yi kwey. ");
INSERT INTO kkj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mi kɛ lɛpɔ nyɛ wunɛ nde: Ŋgɛ wunɛ ti kelɛ ŋgbeŋ mɛkele laŋsa ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧ na, nɛ tí nyiŋɛ kɛ Kandɔ te yi kwey na. ");
INSERT INTO kkj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Wunɛ duwa̧ nde, ɓo lɛpima nyɛ ɓebaba ɓusu nde: ‹Kpɛ, wɛ tî woku mumɔ. Mɔ te ɛ wo mumɔ, ɓo kɛ̂n nɛ nyɛ kɛ mbɔmbu ɓotu ɓe pɛsina jɔsi.› ");
INSERT INTO kkj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma kɛ yembɛ, mi kɛ lɛpɔ nyɛ wunɛ nde: Ŋgɛ mumɔ wokɛ ŋgambi suŋgwɛ nɛ maŋ, na sâŋgwaŋgwɛ nɛ mɛbɔnɛ kɛ mɛɓɔ mɛ ɓotu ɓe pɛsina jɔsi. Ŋgɛ mumɔ yisɛ maŋ lɛpɔ nde: ‹Kwaŋgɔ wari,› mɔ te sâŋgwaŋgwɛ nɛ mɛbɔnɛ kɛ mɛɓɔ mɛ ɓotu ɓe njena nyaŋgwɛ jɔsi Ɓeyudɛn. Ŋgɛ mumɔ jeɓa maŋ nde lem, ɓo ɓôŋ nyɛ ɓetɛ kɛ ɗitɛ te yi ti ɗím kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ŋgɛ ɓɛ nde, wɛ kɛ kɛ̀ nyɛ Njambiyɛ sadaka kɛ mbɛy nyɛna sadaka, ŋgɛ nje kɛ ɗyanɔ ɗyɔ nde, wúnɛ mbaŋa mɔŋ nɛ lɛpi, ");
INSERT INTO kkj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nɔ̀ pâŋ pa niŋgwɛ sadaka yɔ womɛte kɛ mbɛy nyɛna sadaka nyɛ Njambiyɛ, yɔkwɛ nɛ kɔkɔ, pa kɛ̀ kombile lɛpi wúnɛ mɔŋ. Kɛ kɔŋte, nɔ̀ njâki nje nyɛ sadaka yɔ nyɛ Njambiyɛ yɛy. ");
INSERT INTO kkj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ŋgɛ wúnɛ mumɔ ɓɛ nɛ lɛpi, saŋgɔ nje te yi kombile lɛpi te nɛdɔ wúnɛ nyɛ piŋɔ te yi wúnɛ nyɛ ndi kɛ nje kɛ́. Kelɔ ɗete, a mɛ nje ɓu̧ wɛ kɛ̀ nɔ kɛ mbɔmbu mɔ pɛsina jɔsi, ma mɔ pɛsina jɔsi mɛ nje ɓu̧ wɛ kaŋɛ nyɛ mɔ te ɛ ɗiyɛ nɛ tu̧ jɔɓɔ kɔ, ma mɔ te ɛ ɗiyɛ nɛ tu̧ jɔɓɔ kɔ nje ɓu̧ wɛ nyɛ kɛ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Wɛ disɔ pundɔ womɛri, yite ɔ sima gbo lɛpi hɛnɛ nɛ satak kinɛ ɓukwɛ ko mɔnɔ mbulma sisi wɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Wunɛ duwa̧ nde, ɓo lɛpima nde: ‹Kpɛ, wɛ tî kel wanja na.› ");
INSERT INTO kkj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma mi kɛ lɛpɔ mbɛ nyɛ wunɛ nde: Mumɔ hɛnɛ ɛ ɓɛŋɛ wɛtɛ nyari ɓosa nyɛ, mɔ te sima kelɔ wanja ɓenɛ nyɛ kɛ mɔy temɔ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ŋgɛ ɓɛ nde, misi wɔ ɛ mbam ɓɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ ɗôka yo li̧ nɛ naŋ. Kɛto yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, ndi doku yotu yɔ wɛtɛ sâŋnaŋgwɛ, laŋsa nde, kɛn nɛ ndiŋgɛlɛ yotu yɔ hɛnɛ nɛ jɛm kɛ ɗitɛ te yi ti ɗím kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ŋgɛ ɓɛ nde, mbam ɓɔ wɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ kîla yo li̧ nɛ naŋ. Kɛto yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, ndi doku yotu yɔ wɛtɛ sâŋnaŋgwɛ, laŋsa nde, kɛn nɛ ndiŋgɛlɛ yotu yɔ hɛnɛ nɛ jɛm kɛ ɗitɛ te yi ti ɗím kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ɓo lɛpima sendi nde: ‹Ŋgɛ mumɔ soŋɛ ɓɔ nɛ nyari wenɛ, na nyɛ̂ki nyɛ mɛkana mɛ diɗya gwaki.› ");
INSERT INTO kkj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma mi kɛ lɛpɔ mbɛ nyɛ wunɛ nde: Ŋgɛ mumɔ soŋɛ ɓɔ nɛ nyari kinɛ nde, a jatiɗye kol kɛ sɛ̧ na, yite mɔ te kɛ sesiɗye nya te kɛ nje kelna mɛwanja. Sendi, mɔ te ɛ ɓu̧ nya te yi njom soŋma ɓɔ nɛ nyɛ, mɔ te mɔ kelna wanja. ");
INSERT INTO kkj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Wunɛ duwa̧ sendi, ɓo lɛpima nyɛ ɓebaba ɓusu nde: ‹Kpɛ, wɛ tî yaŋgila yasi te yi wɛ si kinja kɛ́ na. Yo nde, tonjukwɛ mɛyasi hɛnɛ te yi wɛ si kinja kɛ mbɔmbu Baba Mbokɔ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma mi kɛ lɛpɔ mbɛ nyɛ wunɛ nde: Kpɛ, wunɛ tî kinjaŋgwɛ yaŋa na ko kaŋɛ ɓɔ kɛnjɛ kwey na. Kɛto ɗyoɓɔ, yo siya ɓekum te yi Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ko wunɛ tî tɛnda mɛnɛti yí kinja nɛ yaŋa na. Kɛto mɛnɛti, yo yasi te yi nyɛ kasɛ kol kɛte. Wunɛ tî kinjaŋgwɛ yaŋa nɛ ɗinɔ Yerusalɛm na. Kɛto yo ɗya te yi Nyaŋgwɛ Kumande. ");
INSERT INTO kkj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wɛ tî kinjaŋgwɛ yotu yɔ na. Kɛto wɛ ti yaka yeŋsa nyiŋɔ to yɔ wɛtɛ nɛ wɛtɛ nde, yo ɓɛ̂ki wumnate ho yindinate na. ");
INSERT INTO kkj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ŋgɛ wunɛ lɛpɛ nde: ‹I̧,› yo ɓɔ̂na ndi nde: ‹I̧.› Ma ŋgɛ wunɛ lɛpɛ nde: ‹Ɓɛ,› yo ɓɔ̂na ndi nde: ‹Ɓɛ.› Yikɛ yi wunɛ nje dokiɗye kɛ to te kɛ́ wúla kɛ yi *Mɔ ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Wunɛ duwa̧, ɓo lɛpima nde: ‹Ŋgɛ mumɔ tɔsɛ misi mɛ jakɔsɔ, nɛ̀ ɓo tɔ̂su sendi yenɛ. Ŋgɛ mumɔ lekɛ su̧ jakɔsɔ, nɛ̀ ɓo lêka sendi yenɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma mi kɛ lɛpɔ mbɛ nyɛ wunɛ nde: Wunɛ tî pitiɗya yaŋa nyɛ mɔ te ɛ kelɛ ɓeya yasi nɛ wunɛ na. Ŋgɛ mumɔ kpakɛ wɛ kɛ pokɔ te ɛ mbam ɓɔ, nɔ̀ yêŋsaŋgwɛ sendi yɔru nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ŋgɛ mumɔ ɓeŋgwɛ wɛ nɛ lɛpi, na suku lambɔ te yi wɛ lɛŋɛ kɛ́, nɔ tîki sendi nde, a ɓôŋ nyaŋgwɛ lambɔ ɗuku yɔ. ");
INSERT INTO kkj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ŋgɛ mumɔ jeliyɛ wɛ nde, kɛn tikiɗye nyɛ kɛ nje yaka kilomɛta wɛtɛ, nɔ̀ kɛ̂n wúnɛ nyɛ kumɔ kilomɛta yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ŋgɛ mumɔ jɔmbɛ yaŋa kɛ ɓɔ yɔ, nɔ̀ nyɛ̂ki nyɛ. Wɛ tî tum kɔŋ nɛ mɔ te ɛ kɛ kwaɗyɛ jɔmbɔ yaŋa kɛ mɛɓɔ mɔ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Wunɛ duwa̧, ɓo lɛpima nde: ‹Kwaɗyikwɛ mɔ njɔŋ wɔ, ɓenɔ pendɔ wɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma kɛ yembɛ, mi kɛ lɛpɔ mbɛ nyɛ wunɛ nde: Wunɛ kwâɗyikwɛ ɓependɔ ɓun, diyɛ Njambiyɛ nde, a nyɛ̂ki mɛkombila nyɛ ɓotu ɓete ɓe kita nɛ wunɛ ɓaka, kelɔ ŋgay nɛ ɓotu ɓete ɓe ɓenɛ wunɛ ɓaka, ŋgwɛta nɛ Njambiyɛ kɛto ɓotu ɓete ɓe pɔnse wunɛ teɗye wunɛ mɛbɔnɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ŋgɛ wunɛ kelɛ ɗete, wunɛ ta ɓɛ ɓɔnɔ ɓe Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ, kɛto a pánkwɛ yesɔ nyɛ ɓeya ɓomɔ, nyɛ sendi kimɔ ɓomɔ. A nɔ́ɗyukwɛ mbiyɔ nyɛ ɓotu ɓete ɓe nɛ ŋgbeŋ, nyɛ sendi ɓotu ɓete ɓe kelɛ yasi kɔtute ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma ŋgɛ wunɛ kwaɗyɛ ndi ɓotu ɓete ɓe kwaɗyɛ wunɛ ɓaka, kwalɔ sol te yɛn yi wunɛ ta ɓɛ nɔ kɛ́? ’Ko ɓotu ɓe ɓoŋna mɔni garama ti kél ndi sendi ɗete na? ");
INSERT INTO kkj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ŋgɛ wunɛ nyɛnɛ ndi ɓemaŋ ɓun, nyaŋgwɛ kimɔ yasi te nda yi wunɛ kelma komɛte laŋsa ɓɛsɔ kɛ́? ’Ko ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka ti kél ndi sendi ɗete na? ");
INSERT INTO kkj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ɗete, wunɛ ɓɛ̂ki nɛ njololo nda yi Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ ɗiyɛ nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Wunɛ ɗîy nɛ sɔsɔ, wunɛ tî kel kimɔ mɛkele kɛ misi mɛ ɓomɔ, nɛ́ ɓo ɓɛŋ ɗete yí tɔndɔ nɛ wunɛ na. Ŋgɛ wunɛ kelɛ ɗete, ko wunɛ tí ɓɛ nɛ sol kɛ mɛɓɔ mɛ Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kɛ ŋgimɔ te yi wɛ kɛ kelɔ ŋgay nɛ buka ɓomɔ, wɛ tî paŋ pa jembɔ jembɔ kɛ numbu kɛ mbɔmbu ɓomɔ nda yi ɓotu ɓe likisi ɗiki kelɔ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nɛ̀ kɛ ɓoku mɛnje kɛ̀ nɔ kɛ́ na. Ɓo kél ɗete, nɛ́ ɓomɔ lukse nɛ ɓo. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Sol te yi ɓa̧ nde, ɓo ɓɛ̂ki nɔ kɛ́, ɓo ma dolɔ yo kɛ yite. ");
INSERT INTO kkj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yo nde, ŋgɛ wɛ kɛ̀ nyɛ buka mumɔ yasi, ɓɔ wɔ ɛ gare tî dukwɛ yasi te yi mbam ɓɔ kelɛ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yo kêlnaŋgwɛ ɗete, nɛ́ nyɛna yasi te yi wɛ nyɛ kɛ́ kwaŋna kɛ sɔ. Ɗete, sɔŋgwɛ ɛ ɓɛŋɛ yasi te yi kwaŋna sɔɗyate kɔ ta duwɛ yɔkiɗye yo nyɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ŋgɛ wunɛ ŋgwɛta nɛ Njambiyɛ, nɛ tî kel nda yi ɓotu ɓe likisi ɗiki kelɔ kɛ́ na. Ɓo kwáɗyikwɛ tɛmɛ tɛma kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nɛ̀ kɛ ɓoku mɛnje ŋgwɛta nɛ Njambiyɛ, nɛ́ ɓomɔ ɓɛŋ ɓo. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Sol te yi ɓa̧ nde, ɓo ɓɛ̂ki nɔ kɛ́, ɓo ma dolɔ yo kɛ yite. ");
INSERT INTO kkj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yo nde, ŋgɛ wɛ kɛ̀ ŋgwɛta nɛ Njambiyɛ, nyiŋa toŋgari yɔ ndaɗyɛ numɛy ŋgwɛta nɛ Sɔŋgwɛ womɛte kɛ sɔ. Ɗete, Sɔŋgwɛ ɛ ɓɛŋɛ yasi te yi kwaŋna sɔɗyate kɔ ta duwɛ yɔkiɗye yo nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ŋgɛ wɛ ŋgwɛta nɛ Njambiyɛ, wɛ tî ɓuɗyukwɛ lɛpi nɛ ndambu ndambu nda yi ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ kelɛ kɛ́ na. Kɛto ɓo táka nde, ŋgɛ ɓo lɛpina ɓuɗyate, yite Njambiyɛ ta yeŋsa kɛ mɛŋgwɛta man. ");
INSERT INTO kkj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wunɛ tî ɓekiɗyaŋgwɛ nɛ ɓo na, kɛto Saŋgwɛ wun sima duwɛ yasi te yi wunɛ kwaɗyɛ piŋɔ te yi wunɛ tì pa diyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Ɗete, ŋgɛ wunɛ ŋgwɛta nɛ Njambiyɛ, wunɛ lɛ̂pi ɗekɛ: ‹Saŋsu, wɛ ɛ ɗiyɛ kɛ ɗyoɓɔ, kelɔ nde, ɓomɔ ɓôŋ ɗinɔ ɗyɔ kiyɔ. ");
INSERT INTO kkj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Inja namɔ mbokɔ. Yasi te yi wɛ kwaɗyɛ kêlnaŋgwɛ kɛ mɛnɛti maka nda yi kelna sendi kɛ ɗyoɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyɛkɔ wusɛ mɛɗye mɛte yi ta yaka nɛ wusɛ kɛ yesɔ te ɛ muka. ");
INSERT INTO kkj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tikɔ wusɛ nɛ ŋgwɛtɛ kɛ ɓeya mɛyasi mɛte yi wusɛ kelɛ kɛ́ nda yi wusɛ ma tikɔ sendi nɛ ɓotu ɓete ɓe kelma ɓeya mɛyasi nɛ wusɛ. ");
INSERT INTO kkj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wɛ tî jaya nde, wusɛ sâŋgwaŋgwɛ nɛ mɛɓoɓilan na. Soŋa wusɛ kɛ mɛɓɔ mɛ *Mɔ ɓeya mɛkele. Kɛto yo wɛ namɛ, yo wɛ ɓɛ nɛ ŋguŋguɗyɛ nɛ̀ luksa yaka nɛ mɛŋgimɔ hɛnɛ, *amɛn.› ");
INSERT INTO kkj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ɗete, ŋgɛ wunɛ tikɛ ɓomɔ nɛ ŋgwɛtɛ kɛ ɓeya mɛyasi mɛte yi ɓo kelɛ nɛ wunɛ kɛ́, yite Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ má tikɔ sendi wunɛ nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma ŋgɛ wunɛ ti tikɛ ɓomɔ nɛ ŋgwɛtɛ kɛ ɓeya mɛyasi mɛte yi ɓo kelɛ kɛ́ na, Saŋgwɛ wun tí tikɔ sendi wunɛ nɛ ŋgwɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ŋgɛ wunɛ kiyɛ mɛɗye yí kanɔ nɛ Njambiyɛ, wunɛ tî kel mɛmbɔlɛ nde, wunɛ nɛ ŋgambi nda yi ɓotu ɓe likisi ɗiki kelɔ, tiŋɔ mɛŋgembi nɛ siɓiɓi ɗiyɔ nɔ, nɛ́ ɓomɔ taki nde, ɓo kɛ kiyɔ mɛɗye yí kanɔ nɛ Njambiyɛ kɛ́ na. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Sol te yi ɓa̧ nde, ɓo ɓɛ̂ki nɔ kɛ́, ɓo ma dolɔ yo kɛ yite. ");
INSERT INTO kkj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma ŋgɛ wɛ kiyɛ yɔ mɛɗye yí kanɔ nɛ Njambiyɛ, weya misi lɔmbɛ lɔbinda kɛ to, ");
INSERT INTO kkj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kambɔ ɓomɔ mɛ nje duwɛ nde, wɛ kɛ kiyɔ mɛɗye. Ma ndi sɔŋgwɛ ɛ ɗiyɛ womɛte kɛ sɔ kɔ kɛ duwɛ. Ɗete nyɛ, mɔ te ɛ ɓɛŋɛ yasi te yi kwaŋna sɔɗyate kɔ ta duwɛ yɔkiɗye yo nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Wunɛ tî ndɛm kusuku komɔ kɛ mɛnɛti maka kɛ mbɛy te yi ɓenya nɛ̀ ŋgalma ɓekiɗye kɛ́ na, kɛ mbɛy te yi ɓotu ɓeguɓɔ lekɛ tu̧ ɓu̧ yo kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yasi wɛtɛ, wunɛ ndɛ̂m kusuku komɔ kɛ ɗyoɓɔ kɛ mbɛy te yi ɓenya nɛ̀ ŋgalma tí ɓekiɗye kɛ́, kɛ mbɛy te yi ɓotu ɓeguɓɔ tí lekɛ tu̧ ɓu̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kɛto kɛ mbɛy te yi kusuku yɔ ɗiyɛ kɛte, temɔ yɔ sendi womɛte. ");
INSERT INTO kkj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Misi yo nda lambo kɛ yi mumɔ. Ŋgɛ misi mɔ ɓɛŋna kimɔte, yotu yɔ hɛnɛ kɛ mɔy mɛjasi. ");
INSERT INTO kkj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma ŋgɛ misi mɔ ti ɓɛ́ŋna kimɔte na, yotu yɔ hɛnɛ ta ɓɛ kɛ mɔy yitil. ’Ŋgɛ ɓɛ nde, mɛjasi mɛte yi ɗiyɛ kɛ yotu kɛ́ mɛ yitil, komɛte, yitil te yite má nje yindɔ ɓa nan? ");
INSERT INTO kkj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Kiya mumɔ wɛtɛ ti yaka ɓɛ nɛ ɓemasa yiɓa na. Ho a ta ɓenɔ wɛtɛ, kwaɗyɛ mbaŋa, ho a ta wokuna nɛ wɛtɛ, yɛliyɛ mbaŋa. Wunɛ ti yaka kelɔ Njambiyɛ mɛsay, ɓeŋgwɛ sendi kasi kusuku na. ");
INSERT INTO kkj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Nɛ tî gwaki kaŋ kɛ joŋgwɛ ɗyun kɛ kasi mɛɗye ho kɛ kasi yasi te yi wunɛ ta hɔɓiye ho gwe kaŋ yotu yun kɛ kasi mɛlɛŋgwe na. ’Joŋgwɛ ti kwa̧ ka mɛɗye? ’Yotu ti kwa̧ ka lambɔ? ");
INSERT INTO kkj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wunɛ pâŋ pa ɓɛŋɛ ɓenɔn ɓete ɓe jɛ nɛ kwey ɓaka. Ɓo ti ɓɛ́ki mbɛki ho soŋɛ nyambi kɛ ŋgwaŋ ndɛmɔ nyɛ kɛ mɛndam na. Ma ko ɗete, sɔŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ kɛ nyɛ ɓo mɛɗye. ’Yeti wunɛ kwa̧ ka yun ɓo mɛtu gɔmay na? ");
INSERT INTO kkj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mɔ te nda kɛ njoka yun yakama sɛwɗye mɛtu mɛ joŋgwɛ ɗyenɛ ko nɛ mbɛt kɛto gwena kaŋ te yi nyɛ nɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ŋgɛ ɓɛ ɗete, kɛto ŋge yi wunɛ nje gwe kaŋ kɛ kasi mɛlambɔ kɛ́? Wunɛ ɓɛ̂ŋa nda yi mɛmbunjɔ ju̧ nɔ kɛ́. Mɛmbunjɔ yeti kɛ kelɔ yiŋa mɛsay ho sa mɛlambɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Ko kumande Salomɔŋ nɛ nyaŋgwɛ ɗiyɔ mɛluksa mɛnɛ tì lɛŋɛ yiŋa kpasa kimɔ lambɔ nda njam mɛmbunjɔ maka wɛtɛ nɛ wɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wuy, tikina temɔ te yi wunɛ tikɛ kɛ yi Njambiyɛ kɛ́ gba ɗekɛ nɛ mbɛt. Ma ŋgɛ Njambiyɛ nyɛ kimɔ njam nyɛ mɛmbunjɔ mɛte yi likɔ yi ɗiyɛ ndi muka, nɛmɛnɔ ɓo ɓoŋma ɓetɛ kɛ ɗitɛ kɛ́, ’suŋgwa nɛ wunɛ? ’A ta ɗiyɔ ka kinɛ lɛnje wunɛ lambɔ na? ");
INSERT INTO kkj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ma ɗete, nɛ tî gwaki kaŋ yaŋa lɛpɔ nde: ‹Hɛ ta ɗye ɓa ŋge? Hɛ ta hɔɓiye ɓa ŋge? Hɛ ta lɛŋɛ ɓa ŋge?› na. ");
INSERT INTO kkj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yo nde, yo ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka sa̧ mɛyasi mɛte yinɔri hɛnɛ. Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ duwa̧ nde, wunɛ yâkaŋgwɛ ɓɛ nɛ mɛyasi mɛte kɛ joŋgwɛ ɗyun. ");
INSERT INTO kkj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wunɛ kânda gɔsɔ *Kandɔ te yi Njambiyɛ nɛ̀ ŋgbeŋ mɛkele mɛnɛ, ɗete a má nje dokiɗye mɛyasi mɛte yiri hɛnɛ kɛ to te nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ɗete, wunɛ tî gwaki kaŋ yasi te yi ta kwaŋna nɛmɛnɔ kɛ́ na. Yesɔ te ɛ nɛmɛnɔ ta gwe kaŋ yotu te yenɛ, kɛto yesɔ hɛnɛ kɛ soɓɛ mapi mɛbɔnɛ mɛte yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Wunɛ tî jɔsa mumɔ na. Ɗete, Njambiyɛ tí jɔse sendi wunɛ na, ");
INSERT INTO kkj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kɛto Njambiyɛ ta jɔse wunɛ ndi nda yi wunɛ jɔse nɛ ɓɛsɔ kɛ́. A ta nyɛ wunɛ yasi ɓeŋgwɛ ndi kiya ɗɔkɔ mapi te yi wunɛ yekɛ nɛ yasi nyɛ ɓɛsɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ŋge kelɛ yi wɛ ɓɛŋɛ ndi mbulma ɗyan te yi kɛ misi mɛ mɔŋ kinɛ pa wokɔ kɛlɛŋ kɛlɛŋ kɔkɔ jeti te yi kɛ misi mɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wɛ ta kelɔ nan yí lɛpɔ nɔ nyɛ mɔŋ nde: ‹Maŋmbɛ inja, nɛ́ mi wumbiɗye ɗyan soŋɛ kɛ misi mɔ› piŋɔ te yi kɔkɔ jeti ndi kɛ misi mɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɛ mɔ likisi! Kanda soŋɛ kɔkɔ jeti te yi kɛ misi mɔ kɛ́, nɛ́ wɛ nje ɓɛŋ yasi nɛ ŋgɛlɛlɛ, nɛ́ wɛ nje soŋ nɛ mbulma ɗyan te yi kɛ misi mɛ mɔŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Wunɛ tî nyɛki ɓembiye kpasa mɛyasi na, ma ɓo nje kpalɔ ɓu̧ ɗyambi suŋgwɛ nɛ wunɛ nyalɔ wunɛ nɛ sɛl sɛl. Sendi, wunɛ tî ɓeta mɛmbɔtu mun nyɛ ɓɔnɔ ɓeaɓem na, ma ɓo nje natɛ sɔpite yo. ");
INSERT INTO kkj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Wunɛ jɔ̂mbu yasi, ɗete ɓo ta nyɛ wunɛ. Wunɛ sâŋ, ɗete nɛ ta dolɔ. Wunɛ ɗûŋgwɛ numɛy, ɗete ɓo ta ɓutɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kɛto ɓo nyɛ́ki yasi nyɛ mumɔ hɛnɛ ɛ jɔmbɛ kɔ. Mɔ te ɛ sa̧, a kɛ dolɔ. Yɔkɔ ɛ ɗuŋgwɛ numɛy, ɓo kɛ ɓutɛ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mɔ te nda kɛ njoka yun yakama nyɛ mɔnɔ wenɛ kil kusu, ŋgɛ nyɛ diyɛ mampa kɛ ɓɔ nɛ? ");
INSERT INTO kkj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ho nde, ŋgɛ nyɛ diyɛ nyɛ njanjɔ, ’a má yaka nyɛ nyɛ nyɔŋɛ? ");
INSERT INTO kkj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ŋgɛ ɓɛ nde, ko ɓotu ɓe nyalɔ nda wunɛ kɛ duwɛ nyɛna ɓɔnɔ ɓun kimɔ mɛyasi, ’suŋgwa nɛ Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ? ’A ta ɗiyɔ ka kinɛ nyɛ kimɔ mɛyasi nyɛ ɓotu ɓete ɓe diyɛ nyɛ yo ɓaka? ");
INSERT INTO kkj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Yasi hɛnɛ te yi wunɛ kwaɗyɛ nde, ɓomɔ kêl nyɛ wunɛ, wunɛ kêl sendi nyɛ ɓo ɗete. Nyaŋgwɛ yasi hɛnɛ te yi Mɔyisi kwaɗya lɛpɔ kɛ mɔy mɛmboŋga nɛ̀ nyaŋgwɛ yasi hɛnɛ te yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ kwaɗya lɛpɔ kɛ́, yori. ");
INSERT INTO kkj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Wunɛ nyîŋa nɛ ɓolkoko numɛy, kɛto gbaɓu gbaɓu numɛy nɛ̀ nyaŋgwɛ nje ɓóŋ mumɔ kɛ̀ nɔ kɛ nje te yi nyɛ ta yambile kɛte kɛ́. Ma ɓomɔ ɓuɗyate kɛ tɔkɛ nje te ɛte. ");
INSERT INTO kkj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yasi wɛtɛ, ɓolkoko numɛy nɛ̀ mɔnɔ nje ɓóŋ mumɔ kɛ̀ nɔ kɛ nje te yi joŋgwɛ, ma ɓotu ɓete ɓe kwa̧ nɛ nje te yite ɓaka ti ɓuyɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Wunɛ ɗîy nɛ sɔsɔ nɛ ɓotu ɓe punja mɛlɛpi mɛ ja̧ ɓe nje kɛ yun nɛ kimɔ tɛri nda ɓesam ɓaka. Yasi wɛtɛ, mɛtemɔ man nda ɓeŋgwɛy. ");
INSERT INTO kkj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wunɛ ta duwɛ ɓo kɛ mɛkele man. ’Ɓo nɔ́ku ka fiya kɛ lɛlɔ? ’Ɓo nɔ́ku ka fumbi kɛ mɛŋgombiya? ");
INSERT INTO kkj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kimɔ jeti wúm kimɔ mɛmbumɔ, ma jeti te ɛ mɛ kɛ ɓeyɔ kɔ wúm ɓeya mɛmbumɔ. ");
INSERT INTO kkj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kimɔ jeti ti yaka wumɔ ɓeya mɛmbumɔ na. Sendi, jeti te ɛ mɛ kɛ ɓeyɔ kɔ ti yaka wumɔ kimɔ mɛmbumɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jeti hɛnɛ ɛ ɗiyɛ kinɛ wumɔ kimɔ mɛmbumɔ, ɓo kɛ pɛsɔ yo nyɛ kɛ ɗitɛ. ");
INSERT INTO kkj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ɗete, wunɛ ta duwɛ ɓotu ɓete kɛ mɛkele man. ");
INSERT INTO kkj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Yeti ɓomɔ hɛnɛ ɓe jeɓa mi nde: ‹Nyaŋgwɛ Kumande, Nyaŋgwɛ Kumande› ɓaka ta nyiŋɛ kɛ *Kandɔ te yi kwey na, yasi wɛtɛ, yo ndi ɓaka ɓe kelɛ yasi te yi Saŋmbɛ te ɛ ɗiyɛ kɛ kwey kwaɗyɛ kɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Komɛ yesɔ te ta ɗya̧ kɛ́, ɓomɔ ɓuɗyate ta lɛpɔ nyɛ mi nde: ‹Nyaŋgwɛ Kumande, Nyaŋgwɛ Kumande, ’wusɛ tì punjɛ ka mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ nɛ ɗinɔ ɗyɔ na? ’Wusɛ tì soŋɛ ka ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗinɔ ɗyɔ na? ’Wusɛ tì kelɛ sendi ɓuɗya mɛyekambiyɛ nɛ ɗinɔ ɗyɔ na?› ");
INSERT INTO kkj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Komɛte, mi ta yeŋsa nyɛ ɓo nɛ ŋgwa̧y nde: ‹Wunɛ ɓotu ɓe kelɛ ɓeya mɛyasi mɛte yi mɛmboŋga ɓenɛ kɛ́, wunɛ lɔ̂ndu kɛ kɛki mbɛ, ko mi tì duwɛ wunɛ nɛ mbɛt wɛtɛ yesɔ na!› ");
INSERT INTO kkj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yo nde, mumɔ hɛnɛ ɛ wokɛ yasi te yi mi lɛpima ndana, kelɔ nda yi yo teɗye nyɛ, nyɛ nda mɔ te ɛ nɛ sɔsɔ, kɛto a summa tu̧ ɗyenɛ kɛ to mbatɔ. ");
INSERT INTO kkj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mbiyɔ nɔma, ɛ mbeŋ ɗya̧, ɛ pupɔ kwa̧ mɛnda kɛ tu̧, tu̧ kinɛ gbuŋgula na, kɛto yo ɓa̧ sumnate kɛ to mbatɔ. ");
INSERT INTO kkj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yasi wɛtɛ, mumɔ hɛnɛ ɛ wokɛ yasi te yi mi lɛpɛ kinɛ kelɔ nda yi yo teɗye nyɛ, nyɛ nda lem mumɔ, kɛto a summa tu̧ ɗyenɛ kɛ to mɛsɛy. ");
INSERT INTO kkj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbiyɔ nɔma, ɛ mbeŋ ɗya̧, ɛ pupɔ kwa̧ mɛnda kɛ tu̧, ɛ tu̧ gbuŋgula ɓalɔ nɛ hugbak.» ");
INSERT INTO kkj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kɛ Yesus ma si lɛpina ɗete kɛ́, ɛ nyaŋgwɛ ŋgil ɓomɔ ŋgbakima kwalɔ teɗya yasi te yenɛ, ");
INSERT INTO kkj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kɛto a ɗikima teɗye ɓo mɛyasi nda mɔ te ɛ namɛ, a tì ɓɛ kɛ teɗye nda yi ɓotu ɓe kɛtina mɛyasi ɓan na. ");
INSERT INTO kkj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kɛ Yesus ma si piyɛ wulɛ keki kɛ́, ɛ nyaŋgwɛ ɓuɗya ŋgil ɓomɔ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ndana, ɛ wɛtɛ mɔ ndoko nje kɛ kɛki nɛ kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ lɛpɔ nde: «Nyaŋgwɛ Kumande, ŋgɛ wɛ kwaɗyɛ, wɛ yakama kelɔ nde, yotu mbɛ ɓɛ̂ki nɛ kpɛlɛŋ.» ");
INSERT INTO kkj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɛ Yesus sambile ɓɔ kpokɛ nɛ nyɛ lɛpɔ nde: «Mi kwaɗya, yotu yɔ ɓɛ̂ki nɛ kpɛlɛŋ.» Ɛ kɔn ndoko siyɛ, ɛ yotu nɛ yɔkwɛ ɓɛ nɛ kpɛlɛŋ ndi kɛ kiya mbɛy. ");
INSERT INTO kkj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Ɗiyɔ nɛ sɔsɔ. Kpɛ, wɛ tî yekiɗya mɛyasi mɛte yi kwaŋnama kɛ́ nyɛ mumɔ na. Yasi wɛtɛ, kɛn kɛ̀ teɗye yotu yɔ nyɛ mɔ nyɛna sadaka nyɛ Njambiyɛ, nɛ̀ wɛ kɛ̂n kelɔ sadaka nda yi Mɔyisi pɛsima kɛ́, nɛ́ ɓomɔ duwɛ nde, kɔn yɔ siyma.» ");
INSERT INTO kkj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ nyiŋɛ kɛ Kapɛrnawum kɛ́, ɛ wɛtɛ nyaŋgwɛ kum ɓesɔja, mɔ Rom te ɛ ɗikima ɗiyɔ nɛ ɓesɔja gɔmay kɔ nje kɛ yenɛ ŋgwɛta nɛ nyɛ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Nyaŋgwɛ Kumande, mɔ mɛsay wombɛ kɛ tu̧ kɛ mɛtinɛŋgwɛ kɛ kɔnɔ nɛ mɛkati, yotu nɛ kɛ kwa ɓuɗyate.» ");
INSERT INTO kkj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Mi ta kɛ̀ joŋgwɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɛ nyaŋgwɛ kum ɓesɔja kɔ yeŋsa nde: «Nyaŋgwɛ Kumande, mi yeti mɔ te yi wɛ yakama nyiŋɛ kɛ tu̧ ɗyenɛ na. Ɓeta ndi gbɛla numbu kɛnjɛ, nɛ́ kɔn mɔ mɛsay wombɛ siy. ");
INSERT INTO kkj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kɛto ko mi, ɓaŋa ɓomɔ kɛ ɗiyɔ nɛ mi, ma mi kɛ ɗiyɔ sendi nɛ ɓesɔja. Mi yakama lɛpɔ nyɛ wɛtɛ sɔja nde: ‹Kɛn kaka,› ɔ ɓɛ́ŋa, a ka̧, lɛpɔ nyɛ mbaŋa nde: ‹Inja woŋga,› a má nje. Mi yakama lɛpɔ nyɛ mɔ mɛsay wombɛ nde: ‹Kelɔ yiri,› ɔ ɓɛ́ŋa, a má kelɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kɛ Yesus ma wokɔ lɛpi te yi kum ɓesɔja lɛpima kɛ́, ɛ nyɛ ŋgbakima lɛpɔ nyɛ ɓotu ɓete ɓe ɓa̧ kɛ ɓeŋgwɛ nyɛ ɓaka nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ko kɛ kandɔ Isarayɛl mi tì pa ɓɛŋɛ kwalɔ nyaŋgwɛ tikina temɔ te yikɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ɗete, mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Ɓomɔ ɓuɗyate ta wulɛ pulɔ komɛ yesɔ pundɛ nɛ̀ pulɔ komɛ yesɔ ɓalɛ nje ɗiyɔ ɗyena ɓenɛ ɓe Abaraham nɛ̀ Isak nɛ̀ Yakɔp kɛ *Kandɔ te yi kwey. ");
INSERT INTO kkj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yasi wɛtɛ, ɓo ta ɓetɛ ŋgbak ŋgbak ɓɔnɔ ɓe kandɔ kɛ sɛ̧ kɛ yitil, yo womɛte komɛ ɓo ta lelɔ nyambɔ mɛsu̧.» ");
INSERT INTO kkj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ nyaŋgwɛ kum ɓesɔja kɔ nde: «Ɗukwɛ, mɛyasi kêlnaŋgwɛ kɛ yɔ ɓeŋgwɛ tikina temɔ te yi wɛ nɔ kɛ yembɛ kɛ́.» Ndi kɛ kiya ŋgimɔ te, ɛ kɔn mɔ mɛsay wenɛ siyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kɛ kɔŋte, ɛ Yesus nje kwa̧ kɛ̀ kɛ tu̧ Piyɛr dolɔ ki nɛ Piyɛr ɛ nyari mɛtinɛŋgwɛ kɛ kɔnɔ nɛ ɗuku. ");
INSERT INTO kkj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɛ Yesus kɛnjɛ ɓɔ kpokɛ nɛ ɓɔ mɔ kɔn, ɛ kɔn ɗuku siyɛ kɛ yotu nɛ. Ɛ nyari tɛmɛ kɛ̀ kelɔ mɛsay nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kɛ ɓekoko ma ɗya̧, ɛ ɓomɔ kɛ̀ nɛ ɓaŋa ɓuɗya ɓotu ɓete ɓe ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu ɓaka kɛ̀ yi Yesus. A ɗikima soŋɛ ɓeya mɛsisiŋ kɛ yotu yan nɛ lɛpi te yi pundɛ kɛ numbu nɛ kɛ́, ɛ nyɛ siɗyɛ mɛkɔn mɛ ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mɛyasi kelnama ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. A lɛpima nde: ‹A ɓoŋma mɛkɔsu musu soɓɛ mɛkɔn musu.› ");
INSERT INTO kkj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kɛ Yesus ma ɓɛŋɛ nyaŋgwɛ ŋgil te yi linja nyɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde, ɓo sâɓikwɛ nyaŋgwɛ mbatɔ kɛ̀ ŋginjɛ te yɔru. ");
INSERT INTO kkj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wɛtɛ mɔ teɗya mɛmboŋga nja̧ kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «Yekele, mbɛy hɛnɛ te yi wɛ ta kɛ̀ kɛte, mi ta ɓeŋgwɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ɓetoŋgɔ nɛ mɛnjɛmbi man, ɓenɔn sendi nɛ mɛtu̧ man. Yasi wɛtɛ, *Mɔnɔ mumɔ kinɛ mbɛy te yi nyɛ yakama ɓokwɛ to kɛte na.» ");
INSERT INTO kkj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɛ wɛtɛ mumɔ te ɛ ɓa̧ sendi jekɛ wenɛ kɔ lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, tikɔ mi, nɛ́ mi pa kɛ̀ pumbu saŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yasi wɛtɛ, ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ɓeŋgwɛ mi, tikɔ, nɛ́ ɓemuŋ pumbu ɓemuŋ ɓan.» ");
INSERT INTO kkj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kɛ kɔŋ mɛyasi mɛnɔri, ɛ Yesus kwa̧ ɓendɔ landi, ɛ ɓejekɛ ɓenɛ ɓeŋgwɛ sendi nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Semɔ semɔ, ɛ nyaŋgwɛ mbuku kwa̧ kɛ to nyaŋgwɛ matɔ, ɛ mɛkumbɔ mɛmiyɛ landi, yinɔri Yesus nɛ kɛ jakɔ. ");
INSERT INTO kkj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɛ ɓejekɛ kɛ̀ kɛ kɛki nɛ, jemɛ nyɛ lɛpɔ nde: «Nyaŋgwɛ Kumande, joŋgwɛ wusɛ, hɛ ta girɔ ndana.» ");
INSERT INTO kkj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Wunɛ ɓotu ɓete ɓe tikɛ temɔ nɛ mbɛt kɛ yi Njambiyɛ ɓaka, wunɛ gwáki wɔ̧ ŋge?» Ndana, ɛ nyɛ nje tɛmɛ ɓama nɛ mbuku ɓenɛ nyaŋgwɛ matɔ, ɛ yasi hɛnɛ yɔkwɛ ɓɛ wɛynate nɛ sɛmyɛk. ");
INSERT INTO kkj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɛ sosu yan siyɛ nɛ hirek, ɛ ɓo lɛpɛ tandɛ yan nde: «Yɔkɔ ɓa kwalɔ mɔ te nda yi gba mbuku nɛ̀ nyaŋgwɛ matɔ wokuna nɛ nyɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kɛ Yesus ma saɓiyɛ nyaŋgwɛ matɔ kumɔ kɛ ŋginjɛ te yɔru kɛ mɛnɛti mɛ ɓotu ɓe Gadara kɛ́, ɛ ɓaŋa ɓembam yiɓa ɓe ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu ɓaka nje kɛ yenɛ. Ɓo púndu kɛ mɛŋguku kɛ mbɛy komɛ ɓomɔ ɗikima pumbɔ ɓemuŋ kɛ́. Ɓo ɓa̧ nda goŋgo njomɔ, ɗete ko mumɔ tì ɓɛ kɛ pɛsa pulɔ mate na. ");
INSERT INTO kkj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ndana, ɛ ɓo kembiɗya lɛpɔ nde: «Mɔnɔ Njambiyɛ, sinɛ wunɛ nɛ lɛpi te nda? Wɛ sáŋ ŋge kɛ yotu su? ’Wɛ njáki, nɛ́ wɛ nje teɗye wusɛ mɛbɔnɛ piŋɔ te yi ŋgimɔ tì pa yaka kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yinɔri nyaŋgwɛ kuru ɓeaɓem ɓa̧ kɛ ɗyena, ɓo tì ɓɛ lɔndunate nɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ɛ ɓeya mɛsisiŋ ŋgwɛta nɛ Yesus lɛpɔ nde: «Ŋgɛ wɛ ɗuɗye wusɛ, kɛnjikwɛ wusɛ kɛ̀ kɛ kuru ɓeaɓem ɓari, nɛ́ wusɛ kɛ̀ nyiŋ kɛ yotu yan.» ");
INSERT INTO kkj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ kɛ̂n.» Ɛ ɓo ɗuwɛ kɛ yotu ɓembam ɓenɔri kɛ̀ nyiŋɛ kɛ yotu ɓeaɓem. Ɛ ndiŋgɛlɛ kuru ɓeaɓem siliyɛ kombɔ nɛ ɓeya sokɔ nɛ bibibi bimbina kɛ nyaŋgwɛ matɔ si gwe. ");
INSERT INTO kkj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɓotu ɓete ɓe ɓa̧ kɛ ɓakiɗye ɓeaɓem ɓaka sɛɗya kambɔ kumɔ ɗya, yekiɗye mɛyasi hɛnɛ te yi kwaŋnama kɛ́. Ɓo jekima lɛpɔ yasi te yi ɗyaŋma kɛ yi ɓotu ɓete ɓe ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ndana, ɛ ndiŋgɛlɛ ɗya sutiyɛ kɛ̀ pɛ yi Yesus. Kɛ ɓomɔ ma kaŋɛ misi ɓɛŋɛ nɛ nyɛ kɛ́, ɛ ɓo ŋgwɛta nɛ nyɛ nde, a kwâŋ lɔndɔ kɛ mɛnɛti man. ");
INSERT INTO kkj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kɛ kɔŋ te kɛ́, ɛ Yesus ɓendɛ landi saɓiyɛ nyaŋgwɛ matɔ nɛ kɔkɔ kɛ̀ kɛ ŋgbak ŋgbak ɗya ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɛ ɓaŋa ɓomɔ soɓɛ wɛtɛ mɔ jɛmti mɛtinɛŋgwɛ kɛ taŋ nje nɔ kɛ yenɛ. Kɛ Yesus ma ɓɛŋɛ gbate nde, ɓo tikima temɔ nɛ nyɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ mɔ jɛmti nde: «Mɔnmbɛ, wɛ tî kambi yaŋa na, mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ndana, ɛ ɓaŋa ɓotu ɓe kɛtina mɛyasi lɛpɛ kɛ mɔy temɔ yan nde: «Mbam kɔ kɛ gbutɔ gba nɛ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus duwa̧ mɛtakɛ man, ɛ nyɛ lɛpɛ nde: «Kɛto ŋge yi wunɛ ɓɛ nɛ ɓeya mɛtakɛ kɛ mɔy mɛtemɔ mun ɗete kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma nɛ̀ lɛpinate nde: ‹Mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ› nɛ̀ lɛpinate nde: ‹Tɛma kɛndɔ,› kelna ŋge kwa̧ jɛwɔ kɛ njokate? ");
INSERT INTO kkj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ɗete, mi ta teɗye wunɛ ndana nde, *Mɔnɔ mumɔ nɛ ɗeti te yi tikɔ mɛɓeyɔ mɛ ɓomɔ nɛ ŋgwɛtɛ kɛ to mɛnɛti.» Ɛ nyɛ nje lɛpɔ nyɛ mɔ jɛmti nde: «Tɛma, ɓoŋgɔ taŋ yɔ ɗukwɛ kɛ tu̧ ɗyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɛ mɔ jɛmti tɛmɛ ɗuwɛ kɛ̀ tu̧ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kɛ ŋgil ma ɓɛŋɛ ɗete kɛ́, ɛ ɓomɔ gwe wɔ̧ ɓuɗyate lukse Njambiyɛ, kɛto a nya ɓomɔ ɗeti te yi kelɔ kwalɔ mɛyasi nda yite. ");
INSERT INTO kkj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus nja̧ toŋgiɗya kɛ̀ mbɔmbu, ɛ nyɛ ɓɛŋɛ mbaŋa mbam nde Matiyo kɛ ɗiyɔ kɛ mbɛy komɛ ɓomɔ ɗiki gbo mɔni garama kɛ́. Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Ɓeŋgwɛ mi.» Ɛ nyɛ tɛmɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ɗyena kɛ tu̧ Matiyo ɓenɛ ɓejekɛ ɓenɛ kɛ́, ɛ ɓaŋa ɓuɗya ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓaŋa ɓotu ɓe mɛɓeyɔ nje ɗyena ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kɛ *Ɓefarisɛ̧ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Kɛto ŋge yi masa wun ɗyena ɓenɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe mɛɓeyɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus wokuma yasi te yi ɓo lɛpima kɛ́, ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yeti ɓotu ɓete ɓe nɛ mɛmbundɔ wɛynate ɓaka sa̧ nɛ nje mɔ nyɛti na, yasi wɛtɛ, yo ndi ɓotu ɓe kɔnɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma ɗete, wunɛ kwâŋ, nɛ̀ wunɛ jêka ɓiye to lɛpi kɛ yi Njambiyɛ lɛpɛ nde: ‹Yo gwena ŋgwɛtɛ ɓɛsɔ yi mi jayɛ, yeti wona ɓenyamɔ kelɔ nɛ sadaka na.› Yo nde, mi ti njáki nje jeɓa ŋgbeŋ ɓomɔ na, mi njáki nje jeɓa ɓotu ɓe mɛɓeyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wɛtɛ yesɔ ɓejekɛ ɓe Jaŋ nja̧ kɛ yi Yesus lɛpɔ nyɛ nyɛ nde: «Sinɛ *Ɓefarisɛ̧ kɛ ɗiki kiyɔ mɛɗye yí kanɔ nɛ Njambiyɛ. Ma kɛto ŋge yi ɓejekɛ te ɓɔ ti kél sendi ɗete kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɛ Yesus yeŋsa nyɛ ɓo nde: «’Ɓesɔ ɓe mbam te ɛ kelɛ gwaki kɔ yakama jaɓa ka kɛ ŋgimɔ te yi nyɛ ndi kɛte ɓenɛ ɓo kɛ́? Ko na. Ma ŋgimɔ ta ɗya̧ yi ɓomɔ ta soŋɛ nɛ nyɛ kɛ mɛɓɔ man. Yo kɛ ŋgimɔ te yite yi ɓo ta kiyɔ mɛɗye yɛy. ");
INSERT INTO kkj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Mumɔ ti ɓóŋ pɛl jɔnja lambɔ nje datɔ nɛ lambɔ te yi ma ɓutɔ kɛ́ na. Kɛto ŋgɛ yo kelna ɗete, pɛl jɔnja lambɔ má nyukute njombute, ɔ ɓɛ́ŋa, nyal te má nje ɗɔkɔ kwa̧ to te. ");
INSERT INTO kkj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sendi, mumɔ ti sɔ́pita jɔnja mɛnjam nyɛ kɛ ɓɔru mɛmbe na. Kɛto ŋgɛ yo kelna ɗete, mɛmbe má posiyɛ nyiŋɛ siri, mɛnjam má si dɛndila nɛ mɛnɛti. Yasi wɛtɛ, ɓo sɔ́pita jɔnja mɛnjam nyɛ kɛ jɔnja mɛmbe. Komɛte, mɛnjam nɛ̀ mɛmbe tí yambile na.» ");
INSERT INTO kkj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus ɓa̧ ndi kɛ lɛpina ɗete nyɛ ɓo kɛ́, yaka nɛ wɛtɛ kum kɛ ɗya̧ nje kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ lɛpɔ nyɛ nyɛ nde: «Ŋgɔndu wombɛ gwa̧ ndana ndana, ko ɗete, inja kasɛ ɓɔ kɛ yotu nɛ, na ju̧.» ");
INSERT INTO kkj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ɛ Yesus tɛmɛ ɓenɛ ɓejekɛ ɓenɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ndana, ɛ wɛtɛ nyari yi mɛkiyɔ ɓa̧ kɛ lekwɛ nyɛ kɛ mɛsew kamɔ jɔ yiɓa kɔ pɛsa nɛ kɔŋ Yesus kpokɛ numbu lambɔ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nya kɔ kelma ɗete, kɛto a ɗikima lɛpɔ kɛ mɔy temɔ nɛ nde: ‹Ŋgɛ mi kpokɛ ndi gbɛla numbu lambɔ nɛ, kɔn mbɛ ta siyɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ɛ Yesus yeŋsa ɓɛŋɛ nyari lɛpɔ nde: «Mɔnmbɛ, wɛ tî kambi yaŋa na, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ.» Ɛ kɔn nyari siyɛ ndi kɛ kiya mbɛy. ");
INSERT INTO kkj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesus ɗyaŋma kɛ tu̧ kum kɔ ɓɛŋɛ ɓomɔ kɛ tɔ̧ mbule, dolɔ sendi ŋgil nɛ ho. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Wunɛ sîki pundɔ, mɔnɔ ŋgɔndu kɔ tì gwe na, a kɛ jakɔ.» Yasi wɛtɛ, ɛ ɓo nyɛtɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kɛ ɓo ma si punjɛ ɓomɔ kɛ́, ɛ Yesus nyiŋɛ tu̧ kɛnjɛ ɓɔ ɓiye nɛ mɔnɔ ŋgɔndu kɛ ɓɔ, ɛ nyɛ tɛmɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ɛ kasi te nyanja kɛ ndiŋgɛlɛ poku mɛnɛti mɛte hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kɛ Yesus ma tɛmɛ komɛte yí kwa̧ kɛ́, ɛ ɓaŋa ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka yiɓa kandɛ ɓeŋgwa nɛ kɔŋ nɛ kɔŋ kembiɗya lɛpɔ nde: «Mɔnɔ Davit, gwakɔ ŋgwɛtɛ wusu.» ");
INSERT INTO kkj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kɛ Yesus ma nyiŋɛ tu̧ kɛ́, ɛ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓenɔri nje kɛ kɛki nɛ, ɛ nyɛ diyɛ ɓo nde: «’Wunɛ kɛ tikɔ temɔ nde, mi yakama kelɔ yasi te yi wunɛ diyɛ kɛ́?» Ɛ ɓo yeŋsa nde: «I̧, Nyaŋgwɛ Kumande.» ");
INSERT INTO kkj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ndana, ɛ Yesus kpokɛ misi man lɛpɔ nde: «Mɛyasi kêlnaŋgwɛ kɛ yotu yun ɓeŋgwɛ ndi tikina temɔ te yi wunɛ nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɛ misi man ɓutuna. Ɛ Yesus kombile lɛpɔ nyɛ ɓo nde: «Kpɛ, mumɔ tî dukwɛ yasi te yi kwaŋnama kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko ɗete, kɛ ɓo ma pundɔ ndi yan ɗekɛ kɛ́, ɛ ɓo lapiɗye kasi Yesus kɛ ndiŋgɛlɛ mɛnɛti mɛte hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ kwa̧ kɛ́, ɛ ɓaŋa ɓomɔ nje nɛ wɛtɛ mbam ɛ ɓa̧ nɛ ɓeya sisiŋ kɛ yotu kɔ kɛ yi Yesus. A ti ɗíki tapita na. ");
INSERT INTO kkj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kɛ Yesus ma si soŋɛ ɓeya sisiŋ kɛ yotu nɛ kɛ́, ɛ nyɛ kandɛ ndapi. Ɛ ɓomɔ ŋgbakima lɛpɔ nde: «Ko njɛl yasi nda yikɛ tì pa ɓɛŋna nɛ toru kɛ kandɔ Isarayɛl na.» ");
INSERT INTO kkj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yasi wɛtɛ, ɛ *Ɓefarisɛ̧ lɛpɛ nde: «Yo *Kum ɓeya mɛsisiŋ nyɛ nyɛ ɗeti te yi soŋɛ nɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus kɛndima linje nyaŋgwɛ mɛɗya nɛ̀ mɔnɔ mɛɗya hɛnɛ. A ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, pelɛ Kimɔ Tom kɛ kasi *Kandɔ Njambiyɛ, siɗyɛ kwalɔ mɛkɔn nɛ̀ kwalɔ mɛkɔsu hɛnɛ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ ɓuɗya ŋgil ɓomɔ kɛ́, ɛ nyɛ gwe ŋgwɛtɛ yan ɓuɗyate, kɛto ɓo ɓa̧ kɛ jaɓa, yotu nɛ putɛ nda ɓesam ɓete ɓe kinɛ mɔ ɓakiɗya yan ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ɗete, ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Ɓuɗya nyambi ma ɗetɔ kɛ ŋgwaŋ, ma ɓotu ɓe mɛsay ti ɓuyɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ɗete, wunɛ ŋgwɛ̂taŋgwɛ nɛ sa ŋgwaŋ nde, a kɛ̂njikwɛ ɓotu ɓe mɛsay, nɛ́ ɓo kɛ̀ wesiɗye nyambi nɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kɛ kɔŋte, ɛ Yesus jeɓa ɓejekɛ ɓenɛ kamɔ jɔ yiɓa, nyɛ ɓo ɗeti te yi soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ, siɗyɛ kwalɔ mɛkɔn nɛ̀ kwalɔ mɛkɔsu hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mɛɗinɔ mɛ ɓotu ɓe tomun ɓe Yesus kamɔ jɔ yiɓa kɛ: Bosate Simɔn te yi ɓo jeɓa sendi nde Piyɛr kɔ ɓenɛ ndɛmbi wenɛ Andere ɓu̧ Jak te mɔnɔ Seɓede ɓenɛ maŋ wenɛ Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Yo nɛ Filip nɛ̀ Bartelemi nɛ̀ Tomasi nɛ̀ Matiyo te mɔ ɓoŋna mɔni garama nɛ̀ Jak te mɔnɔ Alfe ɓu̧ Tade. ");
INSERT INTO kkj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yo sendi nɛ Simɔn te mɔ mɛnɛti mɛ Kanan nɛ̀ Yudas te mɔ ɗyari Iskariyot. Yo nyɛ ɗyaŋgwɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus tomma ɓotu ɓaka kamɔ jɔ yiɓa kitɛ ɓo lɛpɔ nde: «Kpɛ, wunɛ tî kɛn kɛ yiŋa mɛkandɔ na. Wunɛ tî nyiŋa sendi kɛ mɛɗya mɛ ɓotu ɓe Samari na. ");
INSERT INTO kkj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wunɛ kpâl kɛ̀ kɛ kandɔ Isarayɛl kɛ yi ɓesam ɓete ɓe ma ɗimbiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wunɛ pêla kɛ̀ nɔ nyɛ ɓomɔ nde: ‹*Kandɔ te yi kwey ma wuta.› ");
INSERT INTO kkj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wunɛ sîɗyikwɛ mɛkɔn mɛ ɓomɔ. Wunɛ kêl nde, ɓemuŋ wômkwɛ, kelɔ sendi nde, yotu ɓotu ɓe ndoko ɓɛ̂ki nɛ kpɛlɛŋ. Wunɛ sôŋa ɓeya mɛsisiŋ kɛ yotu ɓomɔ. Ɓo nya wunɛ mɛyasi gbɛlate, ɗete wunɛ nyɛ̂ki sendi nɛ gbɛlate. ");
INSERT INTO kkj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wunɛ tî ɓoŋ ko lɔr ko sumba ko mɔnɔ litɔ mɔni ɓakiɗye kɛ jon ɗyun na. ");
INSERT INTO kkj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wunɛ tî ɓiya ko koɓiyɛ kwa̧ nɔ ko lambɔ yiɓa ko nakala ko yiŋa kum jeti kɛ ɓɔ na, kɛto mɔ mɛsay yâkaŋgwɛ ɗye nduku mɛsay mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɗya hɛnɛ te yi wunɛ ta ɗya̧ kɛte, wunɛ pâŋ pa diyɛ, simande wɛtɛ mɔ te ɛ jayɛ mɛsay mun ɛ yakama ɓu̧ wunɛ kimɔte kɔ kɛte, nɛ̀ wunɛ yâki ndi kɛ mbɛy nɛ kumɔ kɛ ŋgimɔ te yi wunɛ ta kwa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Komɛ wunɛ ta nyiŋɛ tu̧ te kɛ́, nɛ̀ wunɛ nyɛ̂n ɓotu ɓe tu̧ lɛpɔ nde, tɛte njâki kɛ yan. ");
INSERT INTO kkj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ŋgɛ ɓo yaka nɛ tɛte yi wunɛ lɛpima nɔ kɛ́, nɛ̀ yo njâki gbate kɛ yan. Ma ŋgɛ ɓo ti yaka nɔ na, nɛ̀ yo yɔ̂kwɛ kɛ̀ pɛ yun. ");
INSERT INTO kkj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ŋgɛ ɓɛ nde, kɛ yiŋa tu̧ ho kɛ yiŋa ɗya ɓomɔ tí ɓu̧ wunɛ kimɔte ho wokɔ mɛlɛpi mun na, nɛ̀ wunɛ pûndu kɛ tu̧ te ho ɗuwɛ kɛ ɗya te. Nɛ̀ wunɛ kûtu ŋgbutu tu̧ te ho yi ɗya te soŋɛ kɛ mɛkol mun yí teɗye nde, ɓo kelma ɓeyate. ");
INSERT INTO kkj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Kɛ yesɔ pɛsina jɔsi, pɛsina jɔsi ɓotu ɓe ɗya te ta ɗetɔ kwa̧ yi ɓotu ɓe *Sɔdɔm nɛ̀ *Gɔmɔr. ");
INSERT INTO kkj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Nɛ ɓɛ̂ŋa, mi kɛ tomɔ wunɛ kɛnjɛ nda ɓesam kɛ njoka ɓeŋgwɛy. Wunɛ ɗîy nɛ sɔsɔ nda ɓekwɛ̧, ɓɛ wɛyna ɓomɔ nda ɓepepɔ. ");
INSERT INTO kkj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wunɛ ɗîy nɛ sɔsɔ nɛ ɓomɔ, kɛto ɓo ta ɓu̧ wunɛ kaŋɛ nyɛ ɓotu ɓe pɛsina jɔsi. Ɓo ta njurɔ wunɛ nɛ njambala kɛ mɛmbanjɔ mɛwesiɗya man. ");
INSERT INTO kkj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɓo ta ɓu̧ wunɛ kɛ̀ nɔ kɛ mbɔmbu ɓekum nɛ̀ kɛ mbɔmbu ɓekumande kɛto mbɛ, nɛ́ wunɛ lɛpi yasi te yi wunɛ ɓɛŋma nɛ̀ yi wunɛ duwa̧ kɛ kasi mbɛ kɛ́ nyɛ ɓo, lɛpɔ sendi nyɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma komɛ ɓo ta ɓu̧ wunɛ kɛ̀ nɔ kɛ mbɔmbu yan ɗete kɛ́, wunɛ tî gwaki kaŋ wo yotu nda yi wunɛ ta lɛpina nɔ, ho gwe kaŋ kɛ yasi te yi wunɛ ta lɛpɔ kɛ́ na. Kɛto yasi te yi wunɛ ta lɛpɔ kɛ́, yo Kimɔ Sisiŋ ta nyɛ wunɛ yo kɛ numbu kɛ kiya mbɛy. ");
INSERT INTO kkj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kɛto ko yeti wunɛ ta tapita na, yo Sisiŋ te yi Saŋgwɛ wun ta tapita nɛ nje yun. ");
INSERT INTO kkj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Maŋ ta ɗyaŋgwɛ maŋ wenɛ nyɛ ɓomɔ, nɛ́ ɓo wo nyɛ. Saŋgwɛ nɛ mɔnɔ ta kelɔ sendi ɗete nɛ mɔnɔ wenɛ. Ɓɔmbɛsikɛ ta lu̧ ɗyambi suŋgwɛ nɛ ɓesaŋgwɛ ɓan nɛ̀ ɓenyaŋgwɛ ɓan ɗyaŋgwɛ ɓo nyɛ ɓomɔ, ɓo má wo ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɓomɔ hɛnɛ ta ɓenɔ wunɛ kɛto ɗinɔ ɗyembɛ, ma mɔ te ɛ ta ɗisima kelɔ tiŋ kumɔ kɛ siynate kɔ ta ju̧. ");
INSERT INTO kkj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ŋgɛ ɓo teɗye wunɛ mɛbɔnɛ kɛ wɛtɛ ɗya, nɛ̀ wunɛ kâmbi ɓɔmbɔ kɛ̀ kɛ mbaŋa. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wunɛ tí siɗyɛ linje mɛɗya hɛnɛ kɛ ndiŋgɛlɛ mɛnɛti mɛ Isarayɛl kinɛ nde, *Mɔnɔ mumɔ ɗyâŋ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Mɔ te ɛ jekɛ yasi kɔ tì kwa̧ yekele wenɛ na. Sendi, mɔ mɛsay tì kwa̧ masa wenɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ŋgɛ ɓo kelɛ nɛ mɔ te ɛ jekɛ yasi kɔ nda yi ɓo kelɛ nɛ yekele wenɛ, yite kimɔte kɛ yi jekɛ te. Sendi, ŋgɛ ɓo kelɛ nɛ mɔ mɛsay nda yi ɓo kelɛ nɛ masa wenɛ, yite kimɔte kɛ yi mɔ mɛsay te mbɛte. Ma ŋge ɓo jeɓa sa̧ tu̧ nde *Belsebul, ’ɓo ta nje lɛpɔ nde ŋge suŋgwɛ nɛ ɓotu ɓe tu̧ ɗyenɛ? ");
INSERT INTO kkj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ɗete, wunɛ tî kambi ɓotu ɓete ɓe kelɛ ɓeya yasi suŋgwɛ nɛ wunɛ kɛ́ na, kɛto kinɛ yaŋa te yi ɗiyɛ kɛ sɔ ta ɗiyɔ kinɛ pundɔ puyɛ na. Sendi, kinɛ yaŋa te yi ɗiyɛ sɔɗyate ta ɗiyɔ nde, ɓomɔ tí duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yasi te yi mi lɛpɛ nyɛ wunɛ kɛ mɔy yitil nɛ tu, wunɛ lɛ̂pi yo kɛ puyɛ nɛ yesɔ. Yasi te yi ɓo lakiɗya lakiɗyaŋgwɛ nyɛ wunɛ kɛ mɛtɔ, wunɛ ɓêndi mɛtosiyɔ̧ pelɛ yo nɛ gbololo. ");
INSERT INTO kkj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wunɛ tî kambi ɓotu ɓete ɓe yakama wo mɛmbundɔ kinɛ ɓɛ nɛ ɗeti te yi wo sendi sisiŋ na. Yasi wɛtɛ, wunɛ kpâl kambɔ yɔkɔ ɛ yakama girise sisiŋ nɛ̀ mɛmbundɔ kɛ ɗitɛ te yi ti ɗím kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ɓo ti ɗyáŋgwɛ ka ɓeŋgiri yiɓa sisi wɛtɛ na? Ko ɗete, kinɛ wɛtɛ nɛ wɛtɛ kɛ njoka yan kɛ ɓalɔ kɛ mɛnɛti yambile kinɛ nde, Saŋgwɛ wun dûkwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko nyiŋɔ to yun, Njambiyɛ kɛ duwɛ ɓuyɔte. ");
INSERT INTO kkj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɗete, wunɛ tî kambi yaŋa na. Wunɛ sulnate kɛ misi mɛ Njambiyɛ kwa̧ ɓuɗya ɓeŋgiri. ");
INSERT INTO kkj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yo nde, mumɔ hɛnɛ ɛ jayɛ mi kɛ mbɔmbu ɓomɔ, mi ta jayɛ sendi nyɛ kɛ mbɔmbu Saŋmbɛ te ɛ ɗiyɛ kɛ kwey kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma mɔ te ɛ sɛŋɛ mi kɛ mbɔmbu ɓomɔ, mi ta sɛŋɛ sendi nyɛ kɛ misi mɛ Saŋmbɛ te ɛ ɗiyɛ kɛ kwey kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Wunɛ tî taka nde, mi njáki nje nyɛ tɛte kɛ mɛnɛti maka na. Mi ti njáki nje nyɛ tɛte na, yasi wɛtɛ, mi njáki nɛ kafa. ");
INSERT INTO kkj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kɛto mi njáki ɓakɛ njoka mɔnɔ ɓenɛ saŋgwɛ, ɓakɛ njoka mɔnɔ nyari ɓenɛ nyaŋgwɛ, ɓakɛ sendi njoka njari ɓenɛ mbambɔ ɛ nyari. ");
INSERT INTO kkj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sendi, ɗyambi ta wulɛ ndi kɛ tu̧ mumɔ suŋgwɛ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mɔ kwaɗyɛ saŋgwɛ ho nyaŋgwɛ kwa̧ mi, mɔ te ti yaka ɓɛ mumɔ wombɛ na. Sendi, mɔ kwaɗyɛ mɔnɔ wenɛ ɛ mbam ho ɛ nyari kwa̧ mi, mɔ te ti yaka ɓɛ mumɔ wombɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ŋgɛ mumɔ ti soɓɛ kroa nɛ ɓeŋgwɛ nɛ mi, mɔ te ti yaka ɓɛ mumɔ wombɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mɔ te ɛ ta ɓakiɗye joŋgwɛ ɗyenɛ nɛ ŋgom ŋgom kɔ ta ɗimbiɗye yo, ma yɔkɔ ɛ ta ɗimbiɗye joŋgwɛ ɗyenɛ kɛto mbɛ kɔ ta kpalɔ ɓɛ nɛ yo. ");
INSERT INTO kkj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Mɔ ɓu̧ wunɛ kimɔte, mɔ te ɓóŋ mi. Ma mɔ ɓu̧ mi kimɔte, a ɓóŋ Mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mɔ ɓu̧ mɔ punja mɛlɛpi mɛ Njambiyɛ kimɔte, kɛto a duwa̧ nde, nyɛ mɔ punja mɛlɛpi mɛ Njambiyɛ, mɔ te ta ɓɛ sendi nɛ sol te yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ta ɓɛ nɔ kɛ́. Sendi, mɔ te ɛ ɓu̧ ŋgbeŋ mumɔ kimɔte, kɛto a duwa̧ nde, nyɛ nɛ ŋgbeŋ, mɔ te ta ɓɛ sendi nɛ sol te yi ŋgbeŋ ɓomɔ ta ɓɛ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔ te ɛ ta ɓu̧ ko ndi gbɛla pelɔ tɛ mɔrɔku nyɛ mbaŋa mɔnɔsikɛ, kɛto mɔnɔ te jekɛ wombɛ, mɔ te tí kɔpɔ sol nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kɛ Yesus ma si lɛpɔ mɛyasi mɛnɔri nyɛ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kɛ́, ɛ nyɛ tɛmɛ womɛte kwa̧, na kɛ̀ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ, pelɛ sendi Kimɔ Tom nɛ kɛ nyaŋgwɛ mɛɗya mɛte yi mɛnɛti mɛte. ");
INSERT INTO kkj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jaŋ ɗiyma kɛ tu̧ jɔɓɔ wokɔ nda yi ɓomɔ ɗikima yekiɗye mɛyasi mɛte yi *Krist ɗikima kelɔ kɛ́. Ɛ nyɛ tomɛ ɓaŋa ɓejekɛ ɓenɛ kɛ̀ diyɛ nɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Wɛ ka mɔ te ɛ ɓa̧ nde, a njâki kɔ, ho wusɛ lâɗya mbaŋa dɛlɛ?» ");
INSERT INTO kkj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Wunɛ yɔ̂kwɛ nɛ̀ wunɛ yêkiɗya yasi te yi wunɛ wokuma nɛ̀ yi wunɛ ɓɛŋma kɛ́ nyɛ Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka mɛ kɛ ɓɛŋɛ yasi. Ɓotu ɓe ndɛmbil mɛ kɛ kɛndɔ lalɛ nɛ ŋgbeŋ. Ɓaka ɓe nɛ ndoko ɓaka mɛ nɛ yotu nɛ kpɛlɛŋ. Ɓotu ɓete ɓe nɛ ɗiɓina mɛtɔ ɓaka mɛ kɛ wokɔ pɛ̧. Ɓemuŋ kɛ womiyɛ. Ɓo kɛ lɛpɔ sendi Kimɔ Tom nyɛ buka ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mɔ te ɛ ta ɗiyɔ kinɛ jɔsiɗye kelɔ yiŋa ɓeya yasi kɛto mbɛ kɔ nɛ mɛsosa.» ");
INSERT INTO kkj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kɛ ŋgimɔ te yi ɓejekɛ ɓe Jaŋ ɓa̧ kɛ kwa̧ kɛ́, ɛ Yesus kandɛ lɛpina mɛyasi kɛ kasi Jaŋ nyɛ ŋgil ɓomɔ nde: «Kɛ yi wunɛ ka̧ nɔ kɛ koŋgor kɛ́, wunɛ kɛ́n kɛ̀ ɓɛŋɛ yasi te nda? ’Wunɛ kɛ́n ka kɛ̀ ɓɛŋɛ njoy te yi pupɔ wumbiɗye kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma wunɛ ma kɛ́n kɛ̀ ɓɛŋɛ yasi te nda gbate? ’Wunɛ ka̧ kɛ̀ ɓɛŋɛ mbaŋa mumɔ nɛ kpasa mɛlambɔ kɛ yotu? Yo nde, ɓotu ɓete ɓe lɛŋɛ kpasa mɛlambɔ ɗete ɓaka jóŋnaŋgwɛ ndi kɛ ndoko ɓekumande. ");
INSERT INTO kkj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma wunɛ ma kɛ́n gbate kɛ̀ ɓɛŋɛ nda? ’Wunɛ kɛ́n kɛ̀ ɓɛŋɛ mɔ punja mɛlɛpi mɛ Njambiyɛ? I̧, mi kɛ lɛpɔ nyɛ wunɛ nde: Nyɛ mɔ punja mɛlɛpi mɛ Njambiyɛ gbate gbate, ma yasi wɛtɛ, a kwaŋma yite. ");
INSERT INTO kkj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yo nyɛ yi ɓo kɛtima kasi nɛ kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓɛŋa, mi kɛ kandɛ tomɔ mɔ tomun wombɛ nɛ wɛ, na kɛ̀ kandi kombile nje tikɛ wɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ɛ jaɗya wulɛ kɛ mɔy nyari kwaŋma Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku na. Ko ɗete, njena mumɔ kɛ *Kandɔ te yi kwey kwa̧ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kandɛ kɛ ŋgimɔ te yi Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku kandima nɛ pelna Kimɔ Tom Njambiyɛ kumɔ ndana Kandɔ te yi kwey kɛ saŋgwa nɛ ɗetina mɛsuŋgwa. Ma yo ɓotu ɓete ɓe lu̧ to gɔsɔ yo nɛ tiŋ hɛnɛ ɓaka ɓu̧ yo. ");
INSERT INTO kkj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ma ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ nɛ̀ mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́ lɛpima kasi Kandɔ te, yite Jaŋ tì pa kandɛ lɛpinate yenɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ŋgɛ wunɛ kwaɗyɛ wokɔ to yasi te yi mi lɛpɛ kɛ́, yo nde, Jaŋ nyɛ Eli te yi ɓo ɗikima lɛpɔ nde, a ta nje kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mɔ te ɛ nɛ mɛtɔ te yí wokɔ nɛ pɛ̧, na woku. ");
INSERT INTO kkj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Ma, mi ta yekɔ ɓa ɓotu ɓe ŋgimɔ te yɔkɔ nɛ ɓe nda? Ɓo nda ɓɔnɔsikɛ te ɓe ɗiyɛ kɛ babal, ɓaka má lɛpɔ kɛnjɛ ɓɛsɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Wusɛ tɔŋma mbule nyɛ wunɛ, wunɛ kinɛ ɓɔlɔ na. Wusɛ jembima mɛjembi mɛ sɔŋ nyɛ wunɛ, wunɛ kinɛ lelɔ na.› ");
INSERT INTO kkj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɗete sendi, Jaŋ nja̧. Mɛɗye, a ti ɗyáki. Mɛnjam, a ti hɔ́ɓiya. Kɛ kɔŋte, ɓomɔ nde: ‹A nɛ ɓeya sisiŋ kɛ yotu.› ");
INSERT INTO kkj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ndana *Mɔnɔ mumɔ nja̧. Mɛɗye, a kɛ ɗye. Mɛnjam, a kɛ hɔɓiye. Kɛ kɔŋte, ɓomɔ nde: ‹Nɛ ɓɛ̂ŋa ndi nyaŋgwɛ mɔ mɛɗye nɛ̀ nyaŋgwɛ mɔ hɔɓiya mɛnjam te yɔkɔ, sɔ nɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe mɛɓeyɔ.› Yasi wɛtɛ, ɗyanɔ Njambiyɛ gbate nɛ ŋgbeŋ. Yo kɛ ɓɛŋna ɗete kɛ mɛkele mɛte yi ɗyanɔ te kelɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ndana, ɛ Yesus kandɛ ndeyna ɓotu ɓe mɛɗya mɛte yi nyɛ kelma sulɔ nyaŋgwɛ mɛkele kɛ yan ɓaka, kɛto ɓo tì yeŋsa temɔ na. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Wunɛ ɓotu ɓe Korasin, mɛbɔnɛ ta ɓalɔ kɛ to yun! Wunɛ ɓotu ɓe Betsayda, mɛbɔnɛ ta ɓalɔ sendi kɛ to yun! Kɛto má ɓɛki nde, nyaŋgwɛ mɛkele mɛte yi kelnama kɛ mɛɗya mun kɛ́ ma kélnaŋgwɛ kɛ Tir nɛ̀ Sidɔn, ma ɓotu ɓete yeŋsama temɔ njombu yaŋa lɛŋɛ mɛsanduku kutuɗye mɛsu mɛ ɗitɛ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yori yi mi lɛpɛ nyɛ wunɛ nde: Kɛ yesɔ pɛsina jɔsi, pɛsina jɔsi te yun ta laŋ ɗetɔ kwa̧ yi Tir nɛ̀ Sidɔn. ");
INSERT INTO kkj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma wunɛ ɓotu ɓe Kapɛrnawum, ’wunɛ táka ka nde, ɓo ta ɓendiɗye wunɛ kumɔ kwey? Ko na, ɓo ta kpalɔ piɗyɛ wunɛ kumɔ kɛ ɗya ɓemuŋ. Kɛto má ɓɛki nde, nyaŋgwɛ mɛkele mɛte yi kelnama kɛ yun kɛ́ ma kélnaŋgwɛ kɛ *Sɔdɔm, ma Sɔdɔm ndi kɛte kumɔ muka. ");
INSERT INTO kkj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yori yi mi lɛpɛ nyɛ wunɛ nde: Kɛ yesɔ pɛsina jɔsi, pɛsina jɔsi te yun ta laŋ ɗetɔ kwa̧ yi Sɔdɔm.» ");
INSERT INTO kkj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ndi kɛ kiya ŋgimɔ te yite ɛ Yesus lɛpɛ nde: «Mi kɛ lukse wɛ Da, Kumande ɗyoɓɔ nɛ̀ mɛnɛti, kɛto wɛ sɔɗya mɛyasi mɛte nɛ ɓotu ɓe ɗyanɔ, sɔɗyɛ sendi nɛ ɓotu ɓe duwa̧ yasi kpalɔ nje punjɛ yo nyɛ gbɛla ɓɔnɔsikɛ. ");
INSERT INTO kkj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","I̧ Da, mi kɛ lukse wɛ, kɛto wɛ kwaɗya nde, mɛyasi kwâŋnaŋgwɛ ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Saŋmbɛ nya mi mɛyasi hɛnɛ. Mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ Mɔnɔ na, soŋɛ ndi Da. Sendi, mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ Da na, soŋɛ ndi *Mɔnɔ nɛ̀ mɔ te yi Mɔnɔ kwaɗyɛ punjɛ yo nyɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Wunɛ njâki kɛ yembɛ, wunɛ ɓomɔ hɛnɛ ɓe ma si katɔ nɛ soɓuna ɗitina mɛmapi, mi ta nyɛ mbɛ wunɛ mɛwɛɗya. ");
INSERT INTO kkj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wunɛ jâya *mapi te yi mi soɓiɗye wunɛ kɛ́, ɓeŋgwɛ mi kelɔ yasi te yi mi lɛpɛ nyɛ wunɛ kɛ́, jayɛ sendi mɛyasi mɛte yi mi teɗye wunɛ kɛ́, kɛto mi wɛyna mumɔ, mi sendi nɛ kimɔ temɔ. Ɗete, mɛtemɔ mun ta ɗiyɔ gbate nɛ tɛ, ");
INSERT INTO kkj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kɛto mapi te yi mi soɓiɗye wunɛ kɛ́ kimɔte kɛ yun. Sendi, yasi te yi mi soɓiɗye wunɛ kɛ́ ɗekɛ nɛ hɛsɛm.» ");
INSERT INTO kkj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɗiyɔ kɛ́, ɛ Yesus ɓenɛ ɓejekɛ ɓenɛ kwa̧ kɛ̀ kɛ mɔy mɛŋgwaŋ mɛte yi ɓo ɓɛma nyambi te yi ɓo kelɛ nɛ mampa kɛ́. Yo ɓa̧ kɛ yesɔ *Saba. Ɓejekɛ ɓa̧ kɛ gwe nja, ɛ ɓo nyɛ ɓɔ kɛ lekina mɛto mɛte ɗye. ");
INSERT INTO kkj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kɛ *Ɓefarisɛ̧ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo lɛpɛ nyɛ Yesus nde: «Ɓɛŋa ndi, ɓejekɛ ɓɔ kɛ kelɔ yasi te yi mɛmboŋga musu kiɗyɛ nde, mumɔ tî kel kɛ yesɔ Saba kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yasi wɛtɛ, ɛ Yesus yeŋsa nyɛ ɓo nde: «’Yite nde, wunɛ tì pa tɔlɔ yasi te yi kumande Davit kelma komɛ nyɛ gwa̧ nja ɓenɛ ɓotu ɓenɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A nyiŋma kɛ mbanjɔ Njambiyɛ, ɓu̧ mɛmampa mɛte yi ɗiyɛ kɛ mbanjɔ Njambiyɛ kɛ́ ɗye ɓenɛ ɓotu ɓenɛ. Yo tì ɓɛ nde, gbɛla mumɔ ɗyâki na, ko nyɛ Davit ko ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ nɛ ɓaka. Yo ɓa̧ nde, ndi ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓepɔ yâkaŋgwɛ ɗye yo. ");
INSERT INTO kkj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","’Yite nde, wunɛ tì tɔlɛ kɛ mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́ nde, ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ yeti kɛ jesɔ mboŋga te ɛ lɛpɛ kasi Saba kɛ́ na? Ɓo kɛ kelɔ mɛsay lalɛ kɛ mɔy mbanjɔ Njambiyɛ kɛ yesɔ Saba. Ma ko ɗete, Njambiyɛ yeti kɛ ndeyɛ ɓo kɛ yite na. ");
INSERT INTO kkj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Yo nɛ wɛtɛ mumɔ waka ɛ kwaŋma mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wunɛ ma dúkwɛ ɓiye to lɛpi kɛ yi mɛkana mɛ Njambiyɛ lɛpɛ nde: ‹Mi kwáɗyikwɛ gwena ŋgwɛtɛ ɓɛsɔ, yeti nyɛna sadaka te yi mumɔ nyɛ mi kɛ́ na.› Wunɛ má dukwɛ lɛpi te, ma wunɛ yeti kɛ lɛpina ɓeyate suŋgwɛ nɛ ɓotu ɓete ɓe tì kelɛ yiŋa ɓeya yasi na. ");
INSERT INTO kkj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kɛto yo mi *Mɔnɔ mumɔ ɗiyɛ nɛ yesɔ Saba.» ");
INSERT INTO kkj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kɛ kɔŋte, ɛ Yesus tɛmɛ kwa̧ kɛ̀ kɛ mbanjɔ mɛwesiɗya man. ");
INSERT INTO kkj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wɛtɛ mbam ɓa̧ womɛte, ɓɔ nɛ ma jɛmɛ ɓɛ nɛ fɛŋgɛlɛŋ. Ɛ ɓaŋa ɓomɔ diyɛ Yesus nde: «’Mɛmboŋga kɛ jayɛ ka nde, mumɔ sîɗyikwɛ kɔn mumɔ kɛ yesɔ *Saba?» Ɓo díya ɗete yí tulɔ nɛ numbu nɛ yí lɛpɔ nde, a kelma yiŋa ɓeya yasi. ");
INSERT INTO kkj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Ŋgɛ mbaŋa mumɔ kɛ njoka yun ɓɛ nɛ ndaŋga nya sam wenɛ, ŋgɛ sam te ɓalɛ kɛ mɔy ɓelɔ kɛ yesɔ Saba, mɔ te nda má ɗiyɔ kinɛ ɓiye nyɛ saɓɛ kɔ? ");
INSERT INTO kkj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","’Yite nde, mumɔ tì kwa̧ ka nya sam mɛŋga gɔmay na? Ɗete, mɛmboŋga kɛ jayɛ nde, mumɔ kâma jakɔsɔ kɛ yesɔ Saba.» ");
INSERT INTO kkj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ndana, ɛ nyɛ nje lɛpɔ nyɛ mbam kɔ nde: «Sambila ɓɔ.» Ɛ nyɛ sambile ɓɔ te, ɛ yo yɔkwɛ ɓɛ lalɛ nda ɓɔ te yɔru. ");
INSERT INTO kkj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɛ *Ɓefarisɛ̧ pundɛ kɛ̀ kelɔ kutu yí sa̧ nje nda yi ɓo yakama wo nɛ Yesus kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kɛ nyɛ ma duwɛ ɗete kɛ́, ɛ nyɛ kwa̧ lɔndɔ womɛte. Nyaŋgwɛ ŋgil ɓomɔ ɓeŋgwa nyɛ, ɛ nyɛ joŋgwɛ ɓotu ɓe kɔn hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yasi wɛtɛ, a lɛpima nyɛ ɓo nde, kpɛ, ɓo tî ɗyaŋgwɛ ɗinɔ ɗyenɛ nyɛ ɓomɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yo nde, mɛyasi kélnaŋgwɛ ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. Njambiyɛ lɛpima kwaŋɗye kɛ numbu Esayi nde: ");
INSERT INTO kkj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‹Nɛ ɓɛ̂ŋa, yɔkɔ mɔ mɛsay wombɛ yi mi tɔkuma kɔ, mi kɛ kwaɗyɛ nyɛ ɓuɗyate, temɔ mbɛ ɓiyma nyɛ. Mi ta nyɛ Sisiŋ mbɛ kɛ yotu nɛ. A ta lɛpɔ ŋgbeŋ mɛkele mɛmbɛ nyɛ mɛkandɔ mɛte ɓe yeti kɛ duwɛ mi ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A tí lombiɗya ɓenɛ mumɔ ho ɓama na. Mumɔ tí wokɔ mɛn nɛ nɛ ɓoku mɛnje yí kɛ̀ nɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A tí lekɛ soŋ te ɛ ma nimbɔ kɔ na, ho ɗimɔ lambo te ɛ ndi kɛ ɓiye kɔ na. A ta kelɔ ɗete kumɔ nde, kelna yasi nɛ ŋgbeŋ nâm mɛnɛti maka. ");
INSERT INTO kkj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ɗete, mɛkandɔ mɛ ɓotu ɓete ɓe yeti kɛ duwɛ mi ɓaka ta ɓɛ nɛ ɓiɓina temɔ kɛ yenɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɓo nja̧ ɓu̧ wɛtɛ mbam te ɛ ɓa̧ nɛ wɛtɛ ɓeya sisiŋ kɛ yotu kɔ nje nɔ kɛ yi Yesus. A tì ɓɛ kɛ ɓɛŋɛ yasi ho tapita na. Ɛ Yesus joŋgwɛ nyɛ, ɛ nyɛ kandɛ ndapi, ɓɛŋɛ sendi yasi. ");
INSERT INTO kkj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ŋgil ɓomɔ hɛnɛ ŋgbakimama, ɛ ɓo ɗiki lɛpɔ nde: «’Yɔkɔ yeti gba Mɔnɔ Davit na?» ");
INSERT INTO kkj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɛ *Ɓefarisɛ̧ ma wokɔ kasi te kɛ́, ɛ ɓo lɛpɛ nde: «Mbam kɔ sóŋa ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ gba ɗeti te yi *Belsebul te *Kum ɓeya mɛsisiŋ.» ");
INSERT INTO kkj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus duwa̧ mɛtakɛ man, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ŋgɛ kiya kandɔ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, ɓo ta yaŋgile kandɔ te. Sendi, kɛ kiya ɓotu ɓe nyaŋgwɛ ɗya ho ɓotu ɓe kiya tu̧ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, ɗya te ta tika welɛ, ho mɔy tu̧ te tí kɛ̀ mbɔmbu na. ");
INSERT INTO kkj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kɛ *Satan yeŋsa yotu kpalɔ ɗuɗye Satan, ’yite a tì si ɓakɛ yotu nɛ na? ’Ma yite kandɔ ɗyenɛ ma nje kɛ̀ mbɔmbu nan? ");
INSERT INTO kkj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ŋgɛ ɓɛ nde, mi sóŋa mbɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗeti te yi Belsebul, ma ɓotu ɓun sóŋa yan ɓo nɛ ɗeti te yi nda? Ɗete, yo ɓo nɛ ŋguru wan ta jɔse wunɛ nɛmɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma ŋgɛ ɓɛ gbate nde, mi sóŋa mbɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗeti te yi Sisiŋ Njambiyɛ, yite téɗya nde, *Kandɔ Njambiyɛ mɛ kɛ njoka yun. ");
INSERT INTO kkj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Mumɔ yakama nyiŋɛ ka kɛ tu̧ wɛtɛ ŋgaɓolo mbam, wɛnjile mɛyasi mɛnɛ kinɛ pa kandɛ ɓiye nyɛ wotɔ na? Yo nde, ŋgɛ nyɛ si kandɛ wotɔ nyɛ, a má nje wɛnjile mɛyasi mɛ tu̧ ɗyenɛ yɛy. ");
INSERT INTO kkj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ŋgɛ mumɔ ti ɓɛ kɛ kɔŋ mbɛ na, mɔ te kɛ lu̧ ɗyambi nɛ mi. Sendi, ŋgɛ mumɔ ti kwaɗyɛ wesiɗye yasi sinɛ nyɛ na, mɔ te kɛ wanjɔ. ");
INSERT INTO kkj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Njambiyɛ yakama tikɔ ɓomɔ nɛ ŋgwɛtɛ kɛ ɓeya yasi hɛnɛ te yi ɓo kelɛ nɛ̀ kɛ lɛpi gbutu hɛnɛ te yi ɓo lɛpɛ suŋgwɛ nɛ nyɛ kɛ́. Ma ndi nde, ŋgɛ mumɔ lɛpɛ lɛpi gbutu suŋgwɛ nɛ Kimɔ Sisiŋ, ko Njambiyɛ tí tikɔ mɔ te nɛ ŋgwɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ŋgɛ mumɔ lɛpina ɓeyate suŋgwɛ nɛ *Mɔnɔ mumɔ, Njambiyɛ yakama tikɔ nyɛ nɛ ŋgwɛtɛ. Ma ŋgɛ mumɔ lɛpina ɓeyate suŋgwɛ nɛ Kimɔ Sisiŋ, Njambiyɛ tí tikɔ mɔ te nɛ ŋgwɛtɛ, ko kɛ ŋgimɔ te yɔkɔ ko kɛ ŋgimɔ te yi ta nje kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ɓo lɛ́pi nde: Yɔkɔ kimɔ jeti, komɛ nyɛ wumɛ kimɔ mbumɔ. Ɓo lɛ́pi sendi nde: Yɔkɔ ɓeya jeti, komɛ nyɛ wumɛ ɓeya mbumɔ, kɛto ɓo dúkwɛ jeti wulɛ kɛ mbumɔ te yi nyɛ wumɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wunɛ mbo yeri, ɓeya ɓomɔ nda wunɛ, nɛ ta kelɔ nan yí lɛpɔ nɛ kimɔ mɛlɛpi? Yo nde, numbu púnjukwɛ mɛyasi mɛte yi tondɛ nɛ ŋgbɛŋ kɛ mɔy temɔ mumɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kimɔ mumɔ kél kimɔ mɛkele wulɛ kɛ kimɔ mɛyasi mɛte yi ɗiyɛ kɛ temɔ nɛ kɛ́. Ma ɓeya mumɔ kél ɓeya mɛkele wulɛ kɛ ɓeya mɛyasi mɛte yi ɗiyɛ kɛ mɔy temɔ nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Kɛ yesɔ pɛsina jɔsi ɓomɔ hɛnɛ ta yeŋsa kɛ mɛlɛpi mɛ tum hɛnɛ te yi ɓo lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yo nde, wɛ ta kaɓɔ ho ɓalɔ lɛpi wulɛ kɛ yasi te yi wɛ lɛpima kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ndana, ɛ ɓaŋa ɓotu ɓe teɗya mɛmboŋga nɛ̀ *Ɓefarisɛ̧ ɓu̧ lɛpi lɛpɔ nde: «Yekele, hɛ kɛ kwaɗyɛ nde, kelɔ wɛtɛ mɛyekambiyɛ, nɛ́ wusɛ ɓɛŋ.» ");
INSERT INTO kkj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Ɓeya ɓotu ɓe ŋgimɔ te yɔkɔ ɓe yeti kɛ wokuna nɛ Njambiyɛ ɓaka kɛ diyɛ wɛtɛ mɛyekambiyɛ. Ma ko ɓo tí teɗye ɓo wɛtɛ mɛyekambiyɛ na, ndi yikɛ yi ma ɗyáŋ Yonas te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yo nde, ndi nda yi Yonas kwaŋɗya mɛyesɔ yitati nɛ̀ mɛtu yitati kɛ mɔy nyaŋgwɛ njanjɔ, ɗete sendi, *Mɔnɔ mumɔ ta kwaŋɗye mɛyesɔ yitati nɛ̀ mɛtu yitati kɛ mɔy mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɗyoɓɔ Njambiyɛ ta pɛsɔ jɔsi kɛ́, ɓotu ɓe Ninive ta tɛmɛ kɛ mbɔmbu ɓotu ɓe ŋgimɔ te yɔkɔ pɛsɔ jɔsi yan teɗye ɓo nde, ɓo ɓalma lɛpi, kɛto ɓo, ɓotu ɓe Ninive yeŋsama yan temɔ komɛ Yonas pelma yasi te yi Njambiyɛ lɛpima kɛ́ nyɛ ɓo. Ma ndana waka, mɔ te ɛ kwaŋma Yonas kɔ kɛte. ");
INSERT INTO kkj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kɛ yesɔ pɛsina jɔsi te nya te ɛ ɓa̧ kumande kɛ Seba kɔ ta tɛmɛ kɛ mbɔmbu ɓotu ɓe ŋgimɔ te yɔkɔ pɛsɔ jɔsi yan teɗye ɓo nde, ɓo ɓalma lɛpi, kɛto a tɛmma nɛ lɔndunate nɛ mbi̧ kɛ njena mɛnɛti yí nje wokɔ lɛpi te yi ɓa̧ tondunate nɛ ɗyanɔ kɛ numbu Salomɔŋ kɛ́. Ma ndana waka, mɔ te ɛ kwaŋma Salomɔŋ kɔ kɛte. ");
INSERT INTO kkj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ŋgɛ ɓeya sisiŋ pundɛ ɗuwɛ kɛ yotu mumɔ, a kwáŋ wowɔ nɛ mɛkoŋgor yí sa̧ mbɛy mɛwɛɗya. Ma ŋgɛ nyɛ ti dolɛ kɛ́, ");
INSERT INTO kkj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","a má lɛpɔ nde: ‹Mi ta yɔkwɛ nɛ kɔkɔ kɛ̀ kɛ tu̧ ɗyembɛ komɛ mi wulma kɛ́.› A yɔ́kwɛ nje dolɔ nde, tu̧ mɛ gboŋgote, ɓo ma wɔmbile yo nɛ ŋgɛsɛsɛ si kombile yo. ");
INSERT INTO kkj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ŋgɛ nyɛ semɛ ɗete kɛ́, a kwa̧ kɛ̀ ɓu̧ sendi ɓaŋa hakambe ɓeya mɛsisiŋ yitan jɔ yiɓa ɓe nɛ ɗeti kwa̧ nyɛ ɓaka. Ɔ ɓɛ́ŋa, ɓenɛ hɛnɛ ɓo má ɗya̧ nyiŋɛ tu̧ ɓiye ɗya womɛte. Ɗete, tɛri mɔ te má nje ɓɛ ndana ɓeyate kwa̧ yi mbɔmbu. Yo ta ɓɛ sendi ɗete kɛ yi ɓeya ɓotu ɓe ŋgimɔ te yɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Piŋɔ te yi Yesus ɓa̧ ndi kɛ lɛpina nyɛ ŋgil ɓomɔ kɛ́, ɛ nyaŋgwɛ ɓenɛ ɓemaŋ ɗya̧ ɗiyɔ kɛ sɛ̧. Ɓo kwaɗya lɛpɔ yiŋa yasi nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɛ mbaŋa mumɔ nje lɛpɔ nyɛ nyɛ nde: «Ɓɛŋa, nyɔŋgwɛ kɛ sɛ̧ ɓenɛ ɓemɔŋ, ɓo kɛ kwaɗyɛ lɛpɔ yaŋa nyɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Nda nyaŋmbɛ? Ɓe nda ɓemaŋ ɓembɛ?» ");
INSERT INTO kkj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kɛ kɔŋte, ɛ nyɛ sambile ɓɔ tewɔ nɛ ɓejekɛ ɓenɛ lɛpɔ nde: «Ha, nyaŋmbɛ nɛ̀ ɓemaŋ ɓembɛ ɓaka! ");
INSERT INTO kkj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yo nde, mumɔ hɛnɛ ɛ kelɛ yasi te yi Saŋmbɛ te ɛ ɗiyɛ kɛ kwey kɔ kwaɗyɛ, mɔ te maŋmbɛ ho ɗyɔmbu ɗyembɛ ho nyaŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kɛ kiya yesɔ te ɛ Yesus pundɛ kɛ tu̧ kɛ̀ ɗiyɔ kɛ goŋ nyaŋgwɛ matɔ. ");
INSERT INTO kkj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nyaŋgwɛ ŋgil ɓomɔ nja̧ wesiɗya kɛ kɛki nɛ, ɛ nyɛ ɓendɛ wɛtɛ landi ɗiyɔ kɛte. Ŋgil ɓomɔ hɛnɛ ɓa̧ kɛ ŋgindi. ");
INSERT INTO kkj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A lɛpima ɓuɗya mɛyasi nyɛ ɓo nɛ nje mɛkanɔ lɛpɔ nde: «Wɛtɛ mɔ ɓɛna mbɛki kwaŋma kɛ ŋgwaŋ yí kɛ̀ nyanje kwalɔ. ");
INSERT INTO kkj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ nyanje kwalɔ kɛ́, ɛ yiŋa ɓalɛ kɛ nje, ɛ ɓenɔn si nje ɗye yo. ");
INSERT INTO kkj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yiŋa ɓalma kɛ mbɛy te yi ɓa̧ tandɛ mɛtari kinɛ ɓuɗya gbɛla mɛnɛti kɛte kɛ́, ɛ yo lo nɛdɔ, kɛto mɛnɛti tì ɓɛ ɗimnate na. ");
INSERT INTO kkj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yasi wɛtɛ, kɛ yesɔ ma panɔ, ɛ yo si nyɔlɔ sɔsɔ, kɛto mɛkaŋgil mɛte tì kumɛ womaŋa na. ");
INSERT INTO kkj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yiŋa ɓalma kɛ mbɛy te yi ɓa̧ nɛ mɛŋgombiya kɛte kɛ́, ɛ mɛŋgombiya ju̧ si ŋgaŋgile yo. ");
INSERT INTO kkj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yiŋa kwalɔ nja̧ ɓalɔ kɛ kimɔ mɛnɛti, ɛ yo wumɛ mɛmbumɔ. Kwalɔ te wɛtɛ nya mɛmbumɔ gɔmay, ɛ wɛtɛ nyɛ kamɔtan jɔ kamɔ wɛtɛ, ɛ wɛtɛ nyɛ nɛ kamɔtati. ");
INSERT INTO kkj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mɔ te ɛ nɛ mɛtɔ te yí wokɔ pɛ̧, a wôku.» ");
INSERT INTO kkj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ndana, ɛ ɓejekɛ ɓenɛ nje kɛ kɛki nɛ diyɛ nyɛ nde: «Kɛto ŋge yi wɛ lɛpina nyɛ ɓo nɛ nje mɛkanɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yo ndi wunɛ yi Njambiyɛ nya ɗeti te yi duwɛ mɛyasi mɛte yi ma ɓɛ́ki sɔɗyate nɛ mbɔmbu kɛ kasi *Kandɔ te yi kwey kɛ́. Yasi wɛtɛ, kɛ ɓɛ ɓo, a tì nyɛ yan ɓo ɗeti te yi duwɛ mɛyasi mɛte na. ");
INSERT INTO kkj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yo nde, pɛ mɔ te ɛ mɛ nɛ yasi kɔ, ɓo ta dokiɗye sendi yiŋa yasi nyɛ nyɛ, a má ɓɛ kɛ nyɛŋgwɛ. Ma pɛ yi yɔkɔ ɛ kinɛ yaŋa kɔ, ɓo ta soŋɛ ko mɔnɔ yasi te yi nyɛ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yi mi lɛpina nyɛ ɓo nɛ nje mɛkanɔ kɛ́, yo kɛto ɓo kɛ ɓɛŋɛ yasi kinɛ duwɛ yasi te yi ɓo ɓɛŋɛ kɛ́ na. Ɓo kɛ lɛŋgwɛ mɛtɔ kɛ yasi kinɛ wokɔ ho ɓiye to te na. ");
INSERT INTO kkj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɗete, mɛkele man kɛ tonjɛ lɛpi te yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ ma lɛ́pi kɛ́. A lɛpima nde: ‹Wunɛ ta wokɔ wokɔ nɛ mɛtɔ mun, ma ko wunɛ tí ɓiye to te na. Nɛ ta ɓɛŋɛ ɓɛŋa nɛ misi mun, ma ko nɛ tí duwɛ yasi te yi wunɛ ɓɛŋɛ kɛ́ na, ");
INSERT INTO kkj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kɛto mɛtemɔ mɛ ɓotu ɓaka mɛ nɛ ɓiŋɓili. Ɓo nɛ ŋguru wan ma ɗiɓɔ mɛtɔ man nɛ̀ misi man. Ɓo kél ɗete, ma misi man nje ɓɛŋɛ yasi, ma mɛtɔ man nje wokɔ pɛ̧, ma temɔ yan nje nɛmbɛ mɛyasi, ma ɓo nje yeŋsa temɔ, ma mi nje siɗyɛ kɔn yan.› ");
INSERT INTO kkj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma kɛ yun, wunɛ nɛ mɛsosa, kɛto misi mun kɛ ɓɛŋɛ yasi, mɛtɔ mun kɛ wokɔ pɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓuɗyate nɛ̀ ɓuɗya ɓotu ɓe Njambiyɛ kwaɗya ɓɛŋɛ mɛyasi mɛte yi wunɛ ɓɛŋɛ muka kɛ́, ko ɗete, ɓo tì ɓɛŋɛ na. Ɓo kwaɗya wokɔ mɛyasi mɛte yi wunɛ wokɛ muka kɛ́, ko ɗete, ɓo tì wokɛ yo na. ");
INSERT INTO kkj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ma ndana, wunɛ wôku to kanɔ mɔ ɓɛna mbɛki. ");
INSERT INTO kkj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ŋgɛ mumɔ wokɛ mɛlɛpi mɛte yi lɛpɛ kasi *Kandɔ te yi kwey kinɛ ɓiye to te na, ɔ ɓɛ́ŋa, *Mɔ ɓeya mɛkele má nje si soŋɛ mɛlɛpi mɛte yi nyiŋma kɛ temɔ nɛ kɛ́. Nje te yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya njɛl mɔ te mbɛte. ");
INSERT INTO kkj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbɛy te yi ɓa̧ tandɛ mɛtari yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya mɔ te ɛ wokɛ mɛlɛpi mɛ Njambiyɛ jayɛ yo nɛdɔ nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yasi wɛtɛ, a tì pa lo mɛgata na. Ɗeti sumna kol kikwɛ yeti na. Ma ŋgɛ nyɛ saŋgwa nɛ yiŋa mɛpɔku ho teɗye nyɛ yiŋa mɛbɔnɛ kɛto mɛlɛpi mɛ Njambiyɛ kɛ́, ɔ ɓɛ́ŋa, a jatiɗya kol kɛ ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbɛy te yi ɓa̧ nɛ mɛŋgombiya yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya mɔ te ɛ wokɛ mɛlɛpi mɛ Njambiyɛ. Yasi wɛtɛ, kɛsa temɔ kɛ mɛyasi mɛte yi ŋgimɔ te yɔkɔ nɛ̀ kasi kusuku te yi ɗiki seɓile temɔ ɓomɔ kɛ́ ma si ŋgaŋgile mɛlɛpi mɛte, ɔ ɓɛ́ŋa, mɛlɛpi mɛ Njambiyɛ te yi nyɛ wokuma kɛ́ tí kelɔ se yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma kimɔ mɛnɛti te yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya mɔ te ɛ wokɛ mɛlɛpi mɛ Njambiyɛ ɓiye to te kwa̧ wumɔ mɛmbumɔ. Kwalɔ mbumɔ wɛtɛ kɛ nyɛ mɛmbumɔ gɔmay, wɛtɛ kɛ nyɛ nɛ kamɔtan jɔ kamɔ wɛtɛ, wɛtɛ sendi kɛ kɛ̀ nyɛ kamɔtati.» ");
INSERT INTO kkj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kɛ kɔŋte, ɛ Yesus yekiɗye sendi wɛtɛ kanɔ nyɛ ɓo lɛpɔ nde: «*Kandɔ te yi kwey kɛ ɓoŋna nɛ wɛtɛ mɔ te ɛ nyanja kimɔ kwalɔ kɛ ŋgwaŋ nɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma piŋɔ te yi ɓomɔ hɛnɛ ɓa̧ kɛ jakɔ kɛ́, ɛ mɔ pendɔ wenɛ kwa̧ kɛ̀ nyanje sendi kwalɔ ɓeya mbunjɔ kɛ njoka kimɔ kwalɔ te yiri tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma kɛ nyambi ma lo ju̧ nyɛ mɛmbumɔ kɛ́, ɛ ɓeya mbunjɔ ŋgbaɓiyɛ sendi nɛ kamama. ");
INSERT INTO kkj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kɛ ɓotu ɓe mɛsay ɓenɛ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo nje diyɛ masa wan nde: ‹Nyaŋgwɛ mbam, ’wɛ ti ma ɓɛ́ki kwalɔ kimɔ nyambi kɛ ŋgwaŋ yɔ na nde? Ma ɓeya mbunjɔ te yɔkɔ wúla ɓa we?› ");
INSERT INTO kkj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ɛ nyɛ yeŋsa nyɛ ɓo nde: ‹Yo mbaŋa mɔ pendɔ wombɛ kelɛ yasi yinɔri.› Ɛ ɓo diyɛ nyɛ nde: ‹’Wɛ kwáɗyikwɛ nde, wusɛ kɛ̂n kɛ̀ sutɛ ɓeya mbunjɔ te soŋɛ?› ");
INSERT INTO kkj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɛ nyɛ yeŋsa nde: ‹Ɓɛ. Nɛ tîki, kambɔ wunɛ mɛ nje sutɛ ɓeya mbunjɔ gbamɔ nɛ kimɔ nyambi. ");
INSERT INTO kkj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nɛ tîki, nɛ́ yo hɛnɛ ju̧ kumɔ kɛ ŋgimɔ soŋna nyambi kɛ ŋgwaŋ. Komɛ ŋgimɔ te ta yaka kɛ́, mi ta lɛpɔ nyɛ ɓotu ɓe soŋna nyambi nde: Wunɛ kânda sutɛ ɓeya mbunjɔ dokɔ yo wotɔ kɛ̀ loɗyɛ. Ma kɛ ɓɛ kimɔ nyambi, wunɛ ndɛ̂m yo kɛ̀ nyɛ kɛ ndam mbɛ.› » ");
INSERT INTO kkj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kɛ kɔŋte, ɛ Yesus yekiɗye sendi wɛtɛ kanɔ nyɛ ɓo lɛpɔ nde: «*Kandɔ te yi kwey nda wɛtɛ kwalɔ mɔnɔ mbumɔ nde mutar yi wɛtɛ mumɔ ɓoŋma kɛ̀ ɓɛ kɛ ŋgwaŋ nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbumɔ te kwa̧ yɛlɔ kɛ njoka mɛkwalɔ hɛnɛ te yi ɗiyɛ kɛ to mɛnɛti. Ma kɛ yo si lo, yo kpál nje ju̧ ɗɔkɔ kwa̧ kwalɔ mɛnyiŋɔ hɛnɛ nje ɓɛ nyaŋgwɛ jeti, ɔ ɓɛ́ŋa, ɓenɔn kɛ nje sumɔ mɛtu̧ man kɛ mɛɓɔ mɛte joŋna kɛte.» ");
INSERT INTO kkj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kɛ kɔŋte, ɛ nyɛ yekiɗye sendi wɛtɛ kanɔ nyɛ ɓo nde: «*Kandɔ te yi kwey nda mɔnɔ ŋga̧ kelna mampa yi nyari ɓu̧ saŋgwɛ nɛ su farin yaka loŋga yitati. Mɔnɔ ŋga̧ yinɔri ta kelɔ nde, mbɔrɔ farin yinɔri hɛnɛ sîki wuɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ɗikima lɛpɔ mɛyasi mɛnɔri hɛnɛ nyɛ ŋgil ɓomɔ nɛ nje mɛkanɔ. Ko a tì ɓɛ kɛ lɛpina nyɛ ɓo kinɛ nyɛ kanɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yo kwaŋnama ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. A lɛpima nde: ‹Mi ta ɓutɛ numbu lɛpina nɛ nje mɛkanɔ. Mi ta punjɛ mɛyasi mɛte yi ɓa̧ sɔɗyate nɛ mbɔmbu kandɛ kɛ ŋgimɔ te yi mbokɔ tì pa kusuna na.› ");
INSERT INTO kkj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ndana, ɛ Yesus tikɛ ŋgil kwa̧ nyiŋɛ tu̧. Ɛ ɓejekɛ ɓenɛ nje kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «Lɛpɔ to kanɔ ɓeya mbunjɔ te yi mɛmiya ŋgwaŋ kɛ́ nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mɔ te ɛ nyanje kimɔ kwalɔ kɔ, yo *Mɔnɔ Mumɔ. ");
INSERT INTO kkj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ŋgwaŋ te yi ɓo lɛpɛ nɔ kɛ́, yo téɗya ndiŋgɛlɛ mɛnɛti maka. Kimɔ kwalɔ, yo ɓotu ɓe *Kandɔ Njambiyɛ. Ɓeya mbunjɔ, yo ɓotu ɓe *Mɔ ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mɔ pendɔ te ɛ nyanja kwalɔ ɓeya mbunjɔ te kɔ, yo *Kum ɓeya mɛkele. Ŋgimɔ soŋna nyambi kɛ ŋgwaŋ téɗya siyna mbokɔ te yɔkɔ. Ɓotu ɓe soŋna nyambi kɛ ŋgwaŋ, yo ɓejaki ɓe Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ma mɛyasi ta kwaŋna kɛ siyna mbokɔ te yɔkɔ ndi nda yi ɓo sutɛ nɛ ɓeya mbunjɔ ɓetɛ kɛ ɗitɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","*Mɔnɔ mumɔ ta tomɔ ɓejaki ɓenɛ, ɓo má si kɛ̀ kawule ɓomɔ hɛnɛ te ɓe jatiɗye ɓɛsɔ kɛ ɓeya nje nɛ̀ ɓotu ɓete ɓe kelɛ mɛyasi mɛte yi mɛmboŋga ɓenɛ kɛ́ soŋɛ kɛ Kandɔ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɓo má nje ɓiye ɓo ɓetɛ kɛ nyɛŋ nyɛŋ ɗitɛ, womɛte ɓo ta lelɔ nyambɔ mɛsu̧. ");
INSERT INTO kkj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɛ ŋgimɔ te yite mbɔmbu ɓotu ɓete ɓe nɛ ŋgbeŋ ɓaka ta panɔ nɛ pay pay nda misi mɛ yesɔ kɛ Kandɔ Saŋgwɛ wan. Ma mɔ te ɛ nɛ mɛtɔ te yi wokɔ nɛ pɛ̧ kɔ, a wôku. ");
INSERT INTO kkj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«*Kandɔ te yi kwey nda yiŋa kpasa yasi te yi ɓo sɔɗya kɛ mɔy mɛnɛti kɛ wɛtɛ ŋgwaŋ. Ɛ wɛtɛ mumɔ nje sɔmbɔ yo. Ɛ nyɛ yɔkiɗye sɔɗyɛ yo nɛ kɔkɔ. Mɛsosa kwaŋma nyɛ kɛ temɔ, ɛru ɛ kwa̧ kɛ̀ ɗyaŋgwɛ mɛyasi mɛnɛ hɛnɛ nje ɓu̧ mɔni te ɓɔmɔ nɛ ŋgwaŋ yinɔri. ");
INSERT INTO kkj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«*Kandɔ te yi kwey sendi nda mɔ ɗyaŋgwa mɛyasi te ɛ gɔsɛ kpasa mɛdiyamaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kɛ nyɛ ma kweɗya wɛtɛ yi ɗye ɓuɗya mɔni kɛ́, ɛ nyɛ kwa̧ kɛ̀ ɗyaŋgwɛ mɛyasi mɛnɛ hɛnɛ nje ɓɔmɔ nɛ yo. ");
INSERT INTO kkj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«*Kandɔ te yi kwey sendi nda bulajama te yi ɓo ɓetima kɛ maŋ, ɛ yo kawule kwalɔ ɓenjanjɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kɛ yo si tondɔ kɛ́, ɓo kɛ ɗalɛ yo kɛ̀ nɔ ŋgindi, ɓo má nje kwa̧ ɗiyɔ mɛtiɗyɛ, sawɛ kimɔ ɓenjanjɔ nyɛ kɛ mɛmapi, ɓetɛ ɓe ɓeya ɓete. ");
INSERT INTO kkj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yo ta kwaŋna sendi ɗete kɛ siyna mbokɔ te yɔkɔ. Ɓejaki ɓe Njambiyɛ ta nje ɓakɛ ɓeya ɓomɔ nɛ̀ ŋgbeŋ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ɓo ta ɓiye ɓeya ɓomɔ ɓetɛ kɛ nyɛŋ nyɛŋ matɔ ɗitɛ. Yo womɛte komɛ ɓo ta lelɔ nyambɔ mɛsu̧.» ");
INSERT INTO kkj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ɛ Yesus nje diyɛ ɓejekɛ ɓenɛ nde: «’Nɛ wokuma ka to mɛlɛpi hɛnɛ te yi mi lɛpima nyɛ wunɛ kɛ́?» Ɛ ɓo yeŋsa nde: «I̧, hɛ wokuma.» ");
INSERT INTO kkj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Mɔ teɗya mɛmboŋga hɛnɛ ɛ jekima mɛyasi mɛte yi ɓɛŋɛ *Kandɔ te yi kwey kɔ nda sa tu̧ te ɛ ɓɛŋɛ kusuku nɛ ɓu̧ jɔnja mɛyasi nɛ̀ mɛnjombu mɛte kɛ njokate.» ");
INSERT INTO kkj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kɛ Yesus ma si siɗyɛ lɛpina mɛkanɔ mɛnɔri ɗete kɛ́, ɛ nyɛ tɛmɛ womɛte kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A kwaŋma kɛ̀ kɛ ŋgbak ŋgbak ɗya ɗyenɛ. Ɛ nyɛ ɗiki teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn yi ɓa̧ womɛte kɛ́. Ɓotu ɓete ɓe ɗikima wokɔ yasi te yi nyɛ teɗya kɛ́ ɗikima ŋgbakima lɛpɔ nde: «Njɛl ɗyanɔ te yi mbam kɔ ɓɛ nɔ nɛ̀ njɛl ɗeti kelna nyaŋgwɛ mɛkele mɛte yi nyɛ nɔ kɛ́ wúla ɓa nyɛ we? ");
INSERT INTO kkj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","’Ta ɛ kɔ na mɔnɔ kapinda? ’Nyaŋgwɛ wenɛ yeti Mariya na? ’Ɓemaŋ yeti ɓe Jak nɛ̀ Yosɛp nɛ̀ Simɔn nɛ̀ Yude na? ");
INSERT INTO kkj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","’Ɓeɗyɔmbu ɓenɛ hɛnɛ yeti waka sinɛ ɓo na? Ɗyanɔ nɛ̀ ɗeti te yikɛ hɛnɛ wúla nyɛ we?» ");
INSERT INTO kkj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kɛ yan, a ɓa̧ yasi te yi njaŋgwa ɓo kɛ temɔ jatiɗye ɓo kɛ ɓeya nje. Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ɓo lúksa mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ yiŋa mɛmbɛy, ma ɓo yɛ́lkwɛ nyɛ ndi kɛ ɗya ɗyenɛ nɛ̀ kɛ mɔy kandɔ ɗyenɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A tì kelɛ yiŋa ɓuɗya nyaŋgwɛ mɛkele womɛte na, kɛto ɓo tì tikɛ temɔ kɛ yenɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kɛ ŋgimɔ te yite kumande Herod te ɛ ɓa̧ kumande kɛ Galile kɔ wokuma je Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ɛ nyɛ lɛpɛ nyɛ ɓotu ɓe mɛsay ɓenɛ nde: «Yo Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku, yo gba nyɛ womiyɛ kɛ njoka ɓemuŋ, yori yi nyɛ ɓɛ nɛ ɗeti te yi kelɔ nyaŋgwɛ mɛkele kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yo nde, nɛ mbɔmbu Herod tomma ɓomɔ kɛ̀ ɓiye nɛ Jaŋ wotɔ nyɛ nyɛ kɛ jɔɓɔ kɛto Herodiyas nya Filip te maŋ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Herod kelma ɗete, kɛto Jaŋ ɗikima lɛpɔ nyɛ nyɛ nde: «Yo ti yaka nde, ɓoŋgɔ Herodiyas nɛ mɛgwaki na.» ");
INSERT INTO kkj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɗete, Herod kwaɗya wo nyɛ, yasi wɛtɛ, a gwa̧ wɔ̧ ŋgil, kɛto ɓomɔ hɛnɛ duwa̧ nde, Jaŋ mɔ punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wɛtɛ yesɔ ɓo ɓa̧ kɛ kelɔ jesɔ yesɔ jariki kumande Herod. Ɛ ŋgɔndu Herodiyas nje ɓɔlɔ jesɔ kɛ mbɔmbu ɓotu ɓete ɓe nja̧ ɓaka, ɛ yo ɓiye temɔ Herod. ");
INSERT INTO kkj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ɛ nyɛ lɛpɛ kinja nyɛ nyɛ nde, yasi hɛnɛ te yi nyɛ ta diyɛ kɛ mɛɓɔ mɛnɛ ko ŋge, a ta nyɛ nyɛ yo. ");
INSERT INTO kkj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mɔnɔ nyari ɓeŋgwa yasi te yi nyaŋgwɛ lɛpima nyɛ nyɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ kumande Herod nde: «Nyɛkɔ mi to Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku gba waka kɛ mɔy pan.» ");
INSERT INTO kkj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yo nya kumande ŋgambi kɛ temɔ. Ma kɛto a sima kinja nɛ̀ kɛto mbɛri misi mɛ ɓotu ɓete ɓe nyɛ jeɓama ɓaka, ɛ nyɛ pɛsɛ nde, a ta nyɛ nyɛ to Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ɛ nyɛ tomɛ ɓomɔ kɛnjɛ kɛ tu̧ jɔɓɔ kɛ̀ kilɛ nɛ to Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ɛ ɓo ɗya̧ nɔ kɛ pan kaŋɛ nyɛ ŋgɔndu nyari. Ɛ nyɛ nje kaŋɛ nyɛ nyaŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ɛ ɓejekɛ ɓe Jaŋ kɛ̀ ɓu̧ muŋ nɛ kɛ̀ pumbɔ. Ɛ ɓo nje kwa̧ kɛ̀ lɛpɔ nyɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kɛ Yesus ma wokɔ kasi sɔŋ Jaŋ kɛ́, ɛ nyɛ ɗuwɛ womɛte kwa̧ nɛ landi yí kɛ̀ sa̧ yiŋa mbɛy te yi ɓa̧ nɛ sɛnjɛnjɛ kinɛ ɓomɔ kɛte kɛ́. Ma kɛ ɓomɔ ma duwɛ ɗete kɛ́, ɛ ɓo sutiyɛ kɛ mɛɗya ɓeŋgwɛ nyɛ kol nɛ kol nɛ ŋgindi. ");
INSERT INTO kkj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kɛ Yesus ma piyɛ kɛ landi kɛ́, a ɓɛ́ŋa nyaŋgwɛ ŋgil ɓomɔ kɛ́. Ɛ nyɛ gwe ŋgwɛtɛ yan ɓuɗyate siɗyɛ mɛkɔn mɛ ɓotu ɓete ɓe ɓa̧ kɛ kɔnɔ kɛ njoka yan ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kɛ ɓekoko ma ɗya̧ kɛ́, ɛ ɓejekɛ ɓenɛ kɛ̀ kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «Waka koŋgor, ma ŋgimɔ ma kwa̧ sendi ɓuɗyate, tikɔ, nɛ́ ɓomɔ kwa̧ kɛ̀ kɛ mɛɗya kɛ̀ sa̧ mɛɗye ɓɔmɔ, nɛ́ ɓo ɗye.» ");
INSERT INTO kkj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «’Ɓo njáki nje kwa̧ kɛ̀ we? Ndi gba wunɛ nɛ ŋguru wun nyɛ̂ki ɓo mɛɗye.» ");
INSERT INTO kkj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yasi wɛtɛ, ɛ ɓo nje yeŋsa nyɛ nyɛ nde: «Wusɛ waka ndi nɛ mampa yitan nɛ̀ ɓenjanjɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ɛ Yesus lɛpɛ nde: «Nɛ njâki nɛ yo woŋga kɛ yembɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ ŋgil ɓomɔ nde, ɓo ɗîy ɗiyɔ kɛ to mɛmbunjɔ. Ɛ nyɛ nje ɓu̧ mampa yinɔri yitan nɛ̀ ɓenjanjɔ ɓenɔri yiɓa kaŋɛ misi kɛnjɛ kwey nyɛ Njambiyɛ wosoko. Kɛ kɔŋte, ɛ nyɛ nje lekɛ yo kaŋɛ nyɛ ɓejekɛ ɓenɛ. Ɛ ɓo ɓu̧ yo kɛ̀ kaɓɔ nyɛ ŋgil ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɛ ɓomɔ hɛnɛ ɗyena ditɔ. Ɛ ɓo nje wesiɗye mɛɓukwɛ mɛte yi tonjɛ mɛmakɔ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kɛ njoka ɓotu ɓete ɓe ɗyenama ɓaka ɓembam nɛ ɓembam kumma nda ɓomɔ tomay yitan kinɛ tɔlɔ ɓomari nɛ̀ ɓɔnɔsikɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ndana ndana kɛ kɔŋte kɛ́, ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde, ɓo ɓêndi landi kandɛ saɓiyɛ kɛ̀ ŋginjɛ te yɔru, na pa tika lɛpɔ nyɛ ŋgil ɓomɔ nde, ɓo sîki ɗuwɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kɛ nyɛ ma si kwaŋɗye ŋgil ɗete kɛ́, ɛ nyɛ kwa̧ kɛ̀ nɛ naŋ ɓendɔ keki, na kɛ̀ ŋgwɛta nɛ Njambiyɛ. Tu yinjama dolɔ nyɛ mate nyɛpɔ. ");
INSERT INTO kkj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yinɔri ɓejekɛ mɛ kɛ̀ nɛ landi lɔndunate kɛ ɓembe sombu. Ɓo ɓa̧ kɛ saŋgwa nɛ mɛbɔnɛ ɓuɗyate nɛ mɛkumbɔ, kɛto ɓo kɛ kɛ̀, pupɔ kɛ nje njakɔ kɛ mbɔmbu yan mata ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kɛ pɔku njenamɛnɔ ɛ Yesus nyɛ kol kɛ kɛndi kɛ to ɗuku yí kɛ̀ nɔ kɛ yan. ");
INSERT INTO kkj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɛ ɓejekɛ ma ɓɛŋɛ nyɛ kɛ kɛndɔ kɛ to ɗuku ɗete kɛ́, ɛ ɓo gwe wɔ̧ lɛpɔ nde: «Yo ablasa!» Ɛ ɓo gwe wɔ̧ ɓuɗyate kembiɗya. ");
INSERT INTO kkj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kɛ Yesus ma ɓɛŋɛ ndi ɗete kɛ́, a tì ndekiɗye na. Ɛ nyɛ ɓetɛ mɛn kɛnjɛ ɓo lɛpɔ nde: «Nɛ tî kambi yaŋa na, yo mi! Nɛ tî gwaki wɔ̧ na!» ");
INSERT INTO kkj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kɛ Piyɛr ma wokɔ ɗete kɛ́, ɛ nyɛ lɛpɛ kɛnjɛ nyɛ nde: «Nyaŋgwɛ Kumande, ŋgɛ ɓɛ nde, yo gba wɛ, jaya nde, mi kɛ̂ndi kɛ to ɗuku kɛ̀ pɛ yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Inja.» Ɛ Piyɛr piyɛ kɛ landi kandɛ kɛndi kɛ to ɗuku yí kɛ̀ nɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma kɛ Piyɛr ma ɓɛŋɛ dimbi pupɔ kɛ́, ɛ nyɛ gwe wɔ̧. A ɓɛŋma nde, a mɛ kɛ nyiŋɛ kɛ mɔrɔku, ɛ nyɛ kembiɗya lɛpɔ nde: «Nyaŋgwɛ Kumande, joŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɛ Yesus sambile ɓɔ nɛdɔ ɓiye nɛ nyɛ kinɛ ndekiɗye na lɛpɔ nyɛ nyɛ nde: «Wɛ mɔ te ɛ kɛ tikɔ temɔ nɛ mbɛt kɛ yembɛ kɔ, kɛto ŋge yi wɛ nya mɛso kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɛ ɓo hɛnɛ yiɓa ɓendɛ landi, ɛ pupɔ siyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɛ ɓejekɛ ɓete ɓe ɓa̧ kɛ mɔy landi ɓaka nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus lɛpɔ nde: «Wɛ Mɔnɔ Njambiyɛ gbate!» ");
INSERT INTO kkj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɓo saɓiya ɗuku kumɔ kɛ mɛnɛti mɛ Genesarɛt. ");
INSERT INTO kkj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓotu ɓe mate duwa̧ nde, yo Yesus, ɛ ɓo kɛnjɛ mɛn kɛ mɛpɔku mɛte yite hɛnɛ. Ɛ ɓo ɓu̧ ɓotu ɓe kɔn hɛnɛ nje nɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓo ŋgwɛtama nɛ nyɛ nde, a jâya nde, ɓotu ɓekɔn kpôka ndi gbɛla numbu lambɔ nɛ lalɛ. Ɗete, ɓomɔ hɛnɛ ɓe kpokuma numbu lambɔ nɛ mɛkɔn man siyma nɛ kpaya. ");
INSERT INTO kkj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ndana, ɛ *Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi ɓe wulma Yerusalɛm ɓaka nje kɛ yi Yesus diyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Kɛto ŋge yi ɓejekɛ ɓɔ yaŋgile mɛkele mɛte yi wulma nɛ ɓesaŋmbambɔ ɓusu kɛ́? Kɛto ɓo ti wéya ɓɔ komɛ ɓo kwaɗyɛ ɗyena kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ma wunɛ, kɛto ŋge yi wunɛ nje yaŋgile mboŋga te yi Njambiyɛ kpalɔ nje ɓeŋgwɛ mɛkele mɛte yun nɛ ŋguru wun kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ma Njambiyɛ lɛpima nde: ‹Jɛsɔ sɔŋgwɛ ɓenɛ nyɔŋgwɛ.› A lɛpima sendi nde: ‹Mɔ te ɛ ta lɛpina ɓeyate nɛ saŋgwɛ ho nɛ nyaŋgwɛ, ɓo wôku nyɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma kɛ yun, wunɛ lɛ́pi yun nde, ŋgɛ mumɔ lɛpɛ nyɛ saŋgwɛ ho nyɛ nyaŋgwɛ nde: ‹Yasi te yi mi diyma kamɛ nɛ wɛ kɛ́, mi sima si nyɛ Njambiyɛ yo nɛ sadaka.› ");
INSERT INTO kkj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Womɛte kɛ yun, mɔ te yakama ɗiyɔ kinɛ kamɛ se saŋgwɛ ho nyaŋgwɛ na. Ɗete, wunɛ kɛ kpalɔ li̧ lɛpi te yi Njambiyɛ wulɛ kɛ mɛkele mɛte yi wunɛ tɛmbiɗya kandɛ nɛ ɓetomba kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wunɛ ɓotu ɓe likisi, lɛpi te yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ kasi yun kɛ́ ɓa̧ gbakasi. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Ɓotu ɓaka kán mi ndi kɛ kondɔ numbu, yasi wɛtɛ, temɔ yan lɔndunate nɛ mbi̧ nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kannate yi ɓo kanɛ nɛ mi kɛ́ gba gbɛlate, kɛto ɓo téɗya ndi mɛyasi mɛte yi wulɛ kɛ pɛsina te yi ɓomɔ.› » ");
INSERT INTO kkj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kɛ kɔŋte, ɛ Yesus jeɓa ŋgil lɛpɔ nyɛ ɓomɔ nde: «Wunɛ lɛ̂ŋgwɛ mɛtɔ yí wokɔ lɛpi kɛ. ");
INSERT INTO kkj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yeti yasi te yi nyiŋɛ kɛ numbu mumɔ kɛ́ kelɛ nde, a ɓɛ̂ki nɛ sɛmbɔ na, yasi wɛtɛ, yo yasi te yi pundɛ kɛ numbu nɛ kɛ́, yo yite kelɛ nde, a ɓɛ̂ki nɛ sɛmbɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ndana, ɛ ɓejekɛ ɓenɛ kɛ̀ kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «’Wɛ kɛ duwɛ ka nde, lɛpi te yi wɛ lɛpima kɛ́ njaŋgwa temɔ *Ɓefarisɛ̧ ɓuɗyate?» ");
INSERT INTO kkj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Kwalɔ mbunjɔ hɛnɛ te yi Saŋmbɛ te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ tì ɓɛ, yo ta sutuna. ");
INSERT INTO kkj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nɛ tîki ɓo, ɓo ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka. Ɓo kɛ teɗye ɓɛsɔ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka nje. Ma ŋgɛ mɔ ɗiɓina misi teɗye jakɔsɔ mɔ ɗiɓina misi nje, ɓo hɛnɛ yiɓa ta ɓalɔ kɛ mɔy ɓelɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ɛ Piyɛr ɓu̧ lɛpi lɛpɔ nyɛ nyɛ nde: «Nɛmba to kanɔ te nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «’Ko wunɛ sendi, wunɛ tì pa ɓɛ ndi nɛ ɗyanɔ na? ");
INSERT INTO kkj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wunɛ yeti kɛ wokɔ ka nde, yasi hɛnɛ te yi nyiŋɛ kɛ numbu kɛ́ píkwɛ kɛ̀ kɛ mɔy mumɔ, kɛ kɔŋte, a má kɛ̀ nyakɔ yo kɛ mboŋ na? ");
INSERT INTO kkj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma yasi wɛtɛ, mɛyasi mɛte yi pundɛ kɛ numbu mumɔ kɛ́ wúla kɛ mɔy temɔ. Yo yite kelɛ nde, a ɓɛ̂ki nɛ sɛmbɔ, ");
INSERT INTO kkj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","kɛto ɓeya mɛtakɛ hɛnɛ wúla ndi kɛ mɔy temɔ mumɔ. Yo kasi wona ɓomɔ. Yo kwalɔ kelna mɛwanja hɛnɛ te yi mumɔ yakama kelɔ. Yo kasi mɛguɓɔ nɛ̀ kasi pɛsina lɛpi nyɛ mumɔ kɛ numbu nɛ̀ kasi tɔyna ɓɛsɔ. ");
INSERT INTO kkj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yo mɛyasi mɛnɔri kelɛ nde, mumɔ ɓɛ̂ki nɛ sɛmbɔ. Ma ŋgɛ mumɔ ɗyena kinɛ pa weyɛ ɓɔ, yite ti kél nde, mumɔ ɓɛ̂ki nɛ sɛmbɔ na.» ");
INSERT INTO kkj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus tɛmma womɛte kwa̧ kɛ̀ kɛ mɛnɛti mɛ Tir nɛ̀ Sidɔn. ");
INSERT INTO kkj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yaka nɔ, wɛtɛ nyari ŋgɔndu Kanan ɛ ɗikima ɗiyɔ kɛ mɛnɛti mɛte kɔ nja̧ kɛ yenɛ kembiɗya lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, mɔnɔ Davit, gwakɔ ŋgwɛtɛ wombɛ. Ɓeya sisiŋ kɛ njaŋgwɛ ŋgɔndu wombɛ ɓeyate.» ");
INSERT INTO kkj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko Yesus tì yeŋsa yaŋa nyɛ nyɛ na. Ɓejekɛ nja̧ kɛ kɛki Yesus jeliyɛ nyɛ lɛpɔ nyɛ nyɛ nde: «Lɛpɔ nyɛ nya kɔ nde, a kwâŋ, kɛto a kɛ ɗiki kembiɗya ɓeŋgwɛ nɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ɛ Yesus yeŋsa nde: «Njambiyɛ tomma mi njesɛ, nɛ́ mi nje joŋgwɛ ndi ɓɔnɔ ɓesam ɓe kandɔ Isarayɛl ɓe ma ɗimbiyɛ ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ko ɗete, nya kɔ nja̧ kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, kama mi.» ");
INSERT INTO kkj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ɛ Yesus yeŋsa nde: «Yo yeti kimɔte nde, ɓo ɓôŋ mɛɗye mɛ ɓɔnɔsikɛ nje ɓetɛ nyɛ ɓɔnɔ ɓembiye na.» ");
INSERT INTO kkj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɛ nyari lɛpɛ nde: «Yo gbate ɗete, Nyaŋgwɛ Kumande. Ma ko ɗete, ɓɔnɔ ɓembiye ɗíy ndi lalɛ kɛ nji̧ teɓel yí ɗye mɛmbulma mɛɗye mɛte yi ɓalɛ wulɛ kɛ teɓel ɓemasa ɓan kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ndana, ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ nyari, tikina temɔ te yi wɛ nɔ kɛ yembɛ kɛ́ gba nyaŋgwɛte ɓuɗyate. Mɛyasi kêlnaŋgwɛ pɛ yɔ nda yi wɛ kwaɗyɛ kɛ́.» Ɛ mɔnɔ wenɛ ɓɛ nɛ tɛ ndi kɛ kiya ŋgimɔ te. ");
INSERT INTO kkj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus nja̧ kwa̧ komɛte kɛndɔ kumɔ kɛ kɛki nyaŋgwɛ matɔ Galile. Ɛ nyɛ kwa̧ ɓendɔ keki kwa̧ ɗiyɔ mɛtiɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nyaŋgwɛ ŋgil ɓomɔ nja̧ kɛ yenɛ. Ɓo nja̧ nɛ ɓotu ɓe ndɛmbil nɛ̀ ɓotu ɓe ɗiɓina misi nɛ̀ ɓaka ɓe ti tápitaŋgwɛ nɛ̀ ɓotu ɓe kɔsu nje ɓu̧ sendi ɓaŋa ɓuɗya ɓotu ɓe kɔn. Ɓo nja̧ nɛ ɓo hɛnɛ kɛ nji̧ mɛkol mɛnɛ, ɛ nyɛ siɗyɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɛ ŋgil ŋgbakima ɓuɗyate tɔndɔ yí ɓɛŋɛ nde, ɓotu ɓete ɓe tì ɓɛ kɛ tapita ɓaka mɛ kɛ tapita, ɓotu ɓe kɔsu mɛ nɛ tɛ, ɓotu ɓe ndɛmbil kɛ kɛndɔ lalɛ kimɔte, ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka kɛ ɓɛŋna. Ɛ ɓomɔ lukse Njambiyɛ te ɛ kandɔ Isarayɛl. ");
INSERT INTO kkj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɗiyɔ kɛ́, ɛ Yesus jeɓa ɓejekɛ ɓenɛ lɛpɔ nyɛ ɓo nde: «Mi kɛ gwe ŋgwɛtɛ ŋgil ɓotu ɓaka ɓuɗyate, kɛto yo mɛ kɛ̀ muka mɛtu yitati yi ɓo waka kɛ kɛki mbɛ kɛ́. Ma yasi te yi ɓo ta ɗye yeti. Mi yeti kɛ kwaɗyɛ nde, ɓo ɗûkwɛ nɛ nja na, kambɔ wum mɛ nje ɓaɗyɛ ɓo kɛ nje.» ");
INSERT INTO kkj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɛ ɓejekɛ ɓenɛ lɛpɛ nyɛ nyɛ nde: «Waka koŋgor, hɛ ta kelɔ ɓa nan yí dolɔ nɛ ɓuɗya mɛɗye mɛte yi wusɛ ta nyɛ nɛ njɛl ŋgil nda yikɛ, ɓo má ɗye ditɔ?» ");
INSERT INTO kkj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɛ Yesus diyɛ ɓo nde: «Wunɛ nɛ mampa niŋgɔ?» Ɛ ɓo yeŋsa nde: «Yitan jɔ yiɓa nje ɓu̧ ɓɔnɔ ɓenjanjɔ nɛ mbɛt.» ");
INSERT INTO kkj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɛ nyɛ lɛpɛ nyɛ ɓomɔ nde, ɓo ɗîy ɗiyɔ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɛ nyɛ ɓu̧ mampa yinɔri yitan jɔ yiɓa nɛ̀ ɓenjanjɔ nyɛ Njambiyɛ wosoko nje lekɛ yo nyɛ ɓejekɛ ɓenɛ. Ɛ ɓo nje ɓu̧ yo kɛ̀ kaɓɔ nyɛ ŋgil ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓomɔ hɛnɛ ɗyenama ditɔ, ɛ ɓo nje wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ yitan jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓotu ɓete ɓe ɗyenama ɓaka ɓa̧ ɓembam nɛ ɓembam tomay yini kinɛ tɔlɔ ɓomari nɛ̀ ɓɔnɔsikɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ ɓomɔ nde, ɓo sîki ɗuwɛ. Ɛ nyɛ nje ɓendɔ landi kɛ̀ pɛ wɛtɛ mbɛy nde Magadaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Ɓefarisɛ̧ nɛ̀ *Ɓesadusɛ̧ nja̧ kɛ yi Yesus. Yí ɓoɓɛ nɛ nyɛ, ɓo diyma nyɛ nde, a têɗya ɓo wɛtɛ mɛyekambiyɛ te yi wulɛ kɛ ɗyoɓɔ kɛ́, nɛ́ ɓo ɓɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ɓekoko wunɛ nde: ‹Yesɔ ta panɔ nɛmɛnɔ, kɛto mɛta mɛ ɗyoɓɔ tenate nɛ ŋgawo.› ");
INSERT INTO kkj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma ɓemɛŋmɛnɛ wunɛ nde: ‹Mbiyɔ ta nɔ muka ɓeyate, kɛto ɗyoɓɔ ɗekɛ nɛ gaŋgayoko, yasi nɛ ndiliŋ.› Wunɛ kɛ duwɛ nɛmbɛ tɛri ɗyoɓɔ, ’ma wunɛ yeti nɛ ɗeti te yi nɛmbɛ mɛyasi mɛte yi kwaŋna kɛ mɛŋgimɔ te yikɛ na? ");
INSERT INTO kkj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɓeya ɓotu ɓete ɓe ŋgimɔ te yɔkɔ ɓe yeti kɛ wokuna nɛ Njambiyɛ ɓaka kɛ diyɛ wɛtɛ mɛyekambiyɛ. Ma ko ɓo tí teɗye ɓo wɛtɛ mɛyekambiyɛ na, ndi yikɛ yi ma ɗyáŋ Yonas kɛ́.» Kɛ kɔŋte, ɛ nyɛ tikɛ ɓo tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ɓo saɓiya ɗuku kɛ̀ ŋginjɛ te yɔru. Ɓejekɛ leŋsama kinɛ kɛ̀ nɛ mampa na. ");
INSERT INTO kkj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ɗiyɔ kɛ́, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ ɗîy gba nɛ sɔsɔ nɛ ŋga̧ te yi Ɓefarisɛ̧ nɛ̀ yi Ɓesadusɛ̧.» ");
INSERT INTO kkj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɛ ɓejekɛ ɗiki takina sa̧ to te kɛ mɔy mɛtemɔ man lɛpɔ nde: «A lɛ́pi ɗete, kɛto wusɛ tì nje nɛ mampa na.» ");
INSERT INTO kkj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus duwa̧ yasi te yi ɓa̧ kɛ kwaŋna kɛ́, ɛ nyɛ lɛpɛ nde: «Kɛto ŋge yi wunɛ takina ɗete kɛ mɔy mɛtemɔ mun lɛpɔ nde, yo kɛto wunɛ tì nje nɛ mampa kɛ́? Tikina temɔ te yi wunɛ nɔ kɛ́ ɗekɛ nɛ mbɛt. ");
INSERT INTO kkj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","’Yite nde, wunɛ tì pa ɓiye ndi to mɛyasi kumɔ ndana na? ’Wunɛ yeti kɛ takɛ se mampa yitan te yi mi nya ɓomɔ tomay yitan ɗye kɛ́ na? ’Wunɛ yeti kɛ takɛ se ɓuyɔ mɛmakɔ mɛte yi wunɛ nja̧ tonjɛ nɛ ɓukwɛ mɛɗye mɛte kɛ́ na? ");
INSERT INTO kkj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kɛ kɔŋte yinɔri, ’mi tì ɓu̧ mampa yitan jɔ yiɓa nyɛ ɓomɔ tomay yini ɗye na? ’Wunɛ yeti kɛ takɛ se ɓuyɔ mɛmakɔ mɛte yi wunɛ nja̧ tonjɛ nɛ ɓukwɛ mɛɗye mɛte yite kɛ́ na? ");
INSERT INTO kkj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ŋge kelɛ yi wunɛ ti wóku nde, mi ti lɛ́pi nɛ kasi mɛɗye kɛ́? Ma wunɛ ɗîy nɛ sɔsɔ nɛ ŋga̧ Ɓefarisɛ̧ nɛ̀ yi Ɓesadusɛ̧.» ");
INSERT INTO kkj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ndana yɛy, ɛ ɓo nje ɓiye to te nde, a ti lɛ́pi nde, ɓo ɗîy nɛ sɔsɔ nɛ faŋ ŋga̧ te yi ɓo ɓu̧ kelɔ nɛ mampa kɛ́ na. A lɛ́pi nɛ teɗya yasi te yi Ɓefarisɛ̧ nɛ̀ Ɓesadusɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus nja̧ kwa̧ kumɔ kɛ mɛnɛti mɛ Sesare Filipi. Ɛ nyɛ diyɛ ɓejekɛ ɓenɛ nde: «Ɓomɔ lɛ́pi nde, mi *Mɔnɔ mumɔ, mi nda?» ");
INSERT INTO kkj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɛ ɓo yeŋsa nde: «Ɓaŋa lɛ́pi nde, wɛ Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. Ɓaŋa nde, wɛ Eli. Ɓaŋa nde, wɛ Jeremi. Ɓaŋa sendi nde, wɛ wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ nda ɓari.» ");
INSERT INTO kkj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ndana, ɛ nyɛ nje diyɛ ɓo nde: «Ma kɛ yun, wunɛ lɛ́pi ɓa nde, mi nda?» ");
INSERT INTO kkj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ɛ Simɔn Piyɛr yeŋsa nde: «Wɛ *Krist te Mɔnɔ Njambiyɛ te ɛ nɛ joŋ kɔ!» ");
INSERT INTO kkj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɛ Yesus ɓu̧ lɛpi lɛpɔ nyɛ nyɛ nde: «Simɔn te mɔnɔ Yonas, wɛ nɛ mɛsosa, kɛto yasi te yi wɛ lɛpima kɛ́. Yeti wɛtɛ mɔ mɛnɛti maka punjɛ yo nyɛ wɛ na, yasi wɛtɛ, yo Saŋmbɛ te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ punjɛ yo nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma kɛ yembɛ, mi kɛ lɛpɔ nyɛ wɛ nde: Wɛ Piyɛr! Yite nde mbatɔ. Mi ta kusɔ njɔŋ ɓotu ɓete ɓe tikɛ temɔ kɛ yembɛ ɓaka kɛ to mbatɔ te. Ko sɔŋ nɛ̀ ɗeti te yi nyɛ nɔ kɛ́ ti yaka kelɔ yaŋa nɛ yo na. ");
INSERT INTO kkj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi ta nyɛ wɛ mɛnjaŋgɔ mɛ numɛy te yi *Kandɔ te yi kwey. Yasi hɛnɛ te yi wɛ ta kpo kɛ mɛnɛti maka, yo ta ɓɛ sendi kponate ɗete kɛ kwey. Sendi, yasi hɛnɛ te yi wɛ ta wunjɛ kɛ mɛnɛti maka, yo ta ɓɛ sendi wunjinate ɗete kɛ kwey.» ");
INSERT INTO kkj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ ɓo nde, kpɛ, ko ɓo tî lɛpi nyɛ wɛtɛ mumɔ nde, nyɛ Krist na. ");
INSERT INTO kkj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kandɛ kɛ ŋgimɔ te yite, ɛ Yesus kandɛ lɛpinate nyɛ ɓejekɛ ɓenɛ nde, mɛyasi ta kelna ɗekɛ: A yâkaŋgwɛ kɛ̀ pɛlɛ Yerusalɛm. Sendi, ɓetomba ɓe ɗya nɛ̀ ɓekum ɓe ɓotu nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ta teɗye nyɛ mɛbɔnɛ ɓuɗyate kwa̧ wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati. ");
INSERT INTO kkj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɛ Piyɛr ɓu̧ nyɛ kɛ̀ nɔ nɛ naŋ kandɛ gayna nɛ lɛpɔ nyɛ nyɛ nde: «Njambiyɛ tí jayɛ na, Nyaŋgwɛ Kumande! Yaŋa ɗete tí ɗya̧ wɛ na!» ");
INSERT INTO kkj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yasi wɛtɛ, ɛ Yesus yeŋsa ɓɛŋɛ Piyɛr lɛpɔ nyɛ nyɛ nde: «Satan, lɔndɔ kɛ kɛki mbɛ. Wɛ yasi te yi yakama jatiɗye mi kɛ ɓeya nje, kɛto mɛtakɛ mɔ yeti wɛtɛ nɛ yi Njambiyɛ na, yo mɛtakɛ mɛte yi ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ndana, ɛ Yesus nje lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: «Ŋgɛ mumɔ kwaɗyɛ ɓeŋgwɛ mi, a tî ɓoŋ yotu nɛ nde, yo yaŋa na. A sôɓa kroa nɛ ɓeŋgwɛ mi, ");
INSERT INTO kkj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","kɛto mumɔ hɛnɛ ɛ kwaɗyɛ kambiɗya nɛ joŋgwɛ ɗyenɛ nɛ ŋgom ŋgom kɔ ta ɗimbiɗye yo. Ma yɔkɔ ɛ ta ɗimbiɗye joŋgwɛ ɗyenɛ kɛto mbɛ kɔ ta ɓɛ nɛ nɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma ŋgɛ mumɔ si namɔ mɛnɛti maka hɛnɛ nje ɗimbiɗye joŋgwɛ ɗyenɛ, yo má nje kamɛ nyɛ kɛ ŋge? Ho nde, yo kwalɔ yasi te nda yi mumɔ yakama nyɛ kɛ numbu joŋgwɛ ɗyenɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yo nde, *Mɔnɔ mumɔ ta nje kɛ mɛluksa mɛ Saŋgwɛ wenɛ ɓenɛ ɓejaki ɓenɛ. Komɛte, a ta nyɛ mumɔ hɛnɛ sol ɓeŋgwɛ mɛkele mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ɓaŋa ɓomɔ kɛ njoka yun ɓe ɗiyɛ ndana waka ɓaka tí gwe kinɛ pa ɓɛŋɛ *Mɔnɔ mumɔ kɛ nje ɓu̧ ɗiyɔ kumande nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ya mɛtu yitan jɔ wɛtɛ kɛ kɔŋte, ɛ Yesus ɓu̧ Piyɛr nɛ̀ Jak nɛ̀ Jaŋ te maŋ nɛ Jak kwa̧ ɓenɛ ɓo ɓepɔ kɛ̀ nɛ naŋ kɛ wɛtɛ nyaŋgwɛ keki. ");
INSERT INTO kkj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kumɔ mate, ɛ yotu nɛ sɛnjɛ kɛ misi man. Mbɔmbu nɛ ɓa̧ kɛ panɔ nɛ pay pay nda yol misi mɛ yesɔ. Mɛlambɔ mɛnɛ ɓa̧ wumnate nɛ mboŋ mboŋ nda yol mɛjasi. ");
INSERT INTO kkj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɓo sém semɔ, Mɔyisi ɓenɛ Eli ɓaka kɛ nyɛ mɛsimɔ ɓenɛ ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ndana, ɛ Piyɛr ɓu̧ lɛpi lɛpɔ nyɛ Yesus nde: «Nyaŋgwɛ Kumande, yo kimɔte nde, wusɛ ɗîy waka. Ŋgɛ wɛ kwaɗyɛ, mi ta sumɔ mɛbala yitati waka, wɔ wɛtɛ, ɛ Mɔyisi wɛtɛ, ɛ Eli wɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piŋɔ te yi nyɛ ɓa̧ kɛ lɛpɔ ndi ɗete kɛ́, ɛ wɛtɛ wumna kulutu nɛ poŋpoŋ ɗiɓiɗye ɓo. Ɛ wɛtɛ mɛn wulɛ kɛ mɔy kulutu lɛpɔ nde: «Yɔkɔ mɔnmbɛ, sɔŋ temɔ mbɛ, wunɛ wôkunaŋgwɛ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kɛ ɓejekɛ ma wokɔ mɛn yinɔri kɛ́, ɛ ɓo gwe wɔ̧ ɓuɗyate ɓalɔ ɓusɛ mbɔmbu kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ɛ Yesus nje kpokɛ ɓo wasɛ lɛpɔ nde: «Nɛ tɛ̂ma. Nɛ tî kambi yaŋa na.» ");
INSERT INTO kkj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kɛ ɓo ma kaŋɛ misi, ɓo tì ɓɛŋɛ se wɛtɛ mumɔ na, ndi Yesus nyɛpɔ. ");
INSERT INTO kkj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma ndana, komɛ ɓo ɓa̧ kɛ piyɛ wulɛ kɛ to keki kɛ́, ɛ Yesus kiɗyɛ lɛpɔ nyɛ ɓo nde: «Kpɛ, nɛ tî yekiɗya yasi te yi wunɛ ɓɛŋma kɛ́ nyɛ mumɔ na. Nɛ disɔ yekiɗye, yite *Mɔnɔ mumɔ womiya kɛ njoka ɓemuŋ.» ");
INSERT INTO kkj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kɛ kɔŋte, ɛ ɓejekɛ diyɛ nyɛ nde: «Kɛto ŋge yi ɓotu ɓe teɗya mɛmboŋga lɛpɛ nde, Eli ta pa kandɛ nje ɗiŋ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɛ Yesus yeŋsa nde: «Yo gbate nde, Eli njâki yí nje kombile mɛyasi hɛnɛ tikɔ kɛ mbɛy te. ");
INSERT INTO kkj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma mi kɛ lɛpɔ nyɛ wunɛ nde: Eli ma nje, ɓomɔ kinɛ duwɛ nyɛ na. Ɓo kelma yasi te yi ɓo kwaɗya kelɔ kɛ́ nɛ nyɛ. Yo ɗete sendi nde, Mɔnɔ mumɔ ta saŋgwa nɛ mɛbɔnɛ kɛ mɛɓɔ man.» ");
INSERT INTO kkj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɛ ɓejekɛ nje wokɔ yɛy ndana nde, a lɛ́pi kasi Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kɛ ɓo ma yɔkwɛ kumɔ komɛ ŋgil ɓomɔ ɓa̧ kɛ́, ɛ wɛtɛ mbam nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus ");
INSERT INTO kkj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","lɛpɔ nde: «Nyaŋgwɛ Kumande, gwakɔ ŋgwɛtɛ mɔnɔ wombɛ. A kɛ kɔnɔ nɛ jaja saŋgwa nɛ mɛbɔnɛ ɓuɗyate. Yo kɛ ɗiki ɓetɛ nyɛ kɛ ɗitɛ, yiŋa kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi ɓoŋma nyɛ kɛ̀ nɔ kɛ yi ɓejekɛ ɓɔ, ɛ ɓo suɗyɛ kinɛ siɗyɛ kɔn nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ɛ Yesus yeŋsa nde: «Wunɛ ɓotu ɓe ti jáya yasi ɓaka, mi ta ɗiyɔ sinɛ wunɛ kumɔ ndenɛn? Mi ta gbisɔ wunɛ kumɔ ndenɛn? Wunɛ ɓôŋ nyɛ nje nɔ woŋga kɛ yembɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ndana, ɛ Yesus ɓama nɛ ɓeya sisiŋ. Ɛ ɓeya sisiŋ pundɛ ɗuwɛ kɛ yotu mɔnɔsikɛ ndi kɛ kiya ŋgimɔ te, ɛ kɔn mɔnɔsikɛ siyɛ ndi kɛ kiya mbɛy. ");
INSERT INTO kkj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ndana, ɛ ɓejekɛ nje kɛ̀ kɛki Yesus diyɛ nyɛ tandɛ yan nde: «Kɛto ŋge yi wusɛ suɗya su soŋna ɓeya sisiŋ te kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Yo kɛto tikina temɔ te yi wunɛ nɔ kɛ́ ɗekɛ nɛ mbɛt. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Má ɓɛki nde, tikina temɔ te yi wunɛ tikɛ kɛ yembɛ kɛ́ nyaŋgwɛte nda ɗokɔ mbumɔ ŋgwal lalɛ, ma wunɛ yakama lɛpɔ nyɛ keki te yɔkɔ nde: ‹Jisa waka kɛ̀ suma kaka.› Ma yaŋa te yi ta ganɔ wunɛ yeti na. ");
INSERT INTO kkj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ndi nde, njɛl ɓeya sisiŋ nda ɛnɔru yakama ɗuwɛ kɛ yotu mumɔ ndi nɛ nje mɛŋgwɛta nɛ Njambiyɛ nɛ̀ nje kiyna mɛɗye.» ");
INSERT INTO kkj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wɛtɛ yesɔ piŋɔ te yi Yesus ɓa̧ kɛ kwa̧ kɛ mɛnɛti mɛ Galile ɓenɛ ɓejekɛ ɓenɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yo nde, ɓo ta ɓu̧ *Mɔnɔ mumɔ kaŋɛ nyɛ kɛ mɛɓɔ ɓomɔ, ");
INSERT INTO kkj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɓo má wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» Ɛ lɛpi yinɔri kwaɗye temɔ ɓejekɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kɛ Yesus ɓenɛ ɓejekɛ ɓenɛ ma ɗya̧ kɛ Kapɛrnawum kɛ́, ɛ ɓotu ɓete ɓe ɗiki ɓu̧ mɔni garama te yi kombila mbanjɔ Njambiyɛ ɓaka lɛpɛ nyɛ Piyɛr nde: «’Yite nde, yekele wun ti gbóku garama te yi ɓɛŋɛ kombila mbanjɔ Njambiyɛ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ɛ nyɛ yeŋsa nde: «A gbóku gbokɔ.» Kɛ Piyɛr ma ɗya̧ nyiŋɛ tu̧ kɛ́, ɛ Yesus kandɛ ɓu̧ lɛpi lɛpɔ nde: «Simɔn, ɔ ɓɛ́ŋa nan? Ɓekum ɓe mɛnɛti maka díya mɛtikɛt nɛ̀ mɔni garama kɛ ɓɔ ɓe nda? ’Ɓo díya kɛ ɓɔ ɓɔnɔ ɓe ɗya ho kɛ ɓɔ ɓejɛŋgwɛ?» ");
INSERT INTO kkj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ɛ Piyɛr yeŋsa nyɛ nyɛ nde: «Ɓo díya kɛ ɓɔ ɓejɛŋgwɛ.» Ɛ Yesus nje diyɛ nyɛ nde: «’Yite téɗya nde, ɓɔnɔ ɓe ɗya ti gbóku na, nduku? ");
INSERT INTO kkj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma kambɔ yo mɛ nje njaŋgwɛ ɓo jatiɗye kɛ ɓeya nje, kɛn kɛ nyaŋgwɛ matɔ, nɔ̀ ɓêta gɛy. Bosa njanjɔ te ɛ ta ɓiye gɛy kɔ, nɔ̀ sûta nyɛ ɓakɛ numbu nɛ, ɔ ta dolɔ sule wɛtɛ. Nɔ̀ ɓôŋ gbo nɛ garama te yembɛ nɛ yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ndana, kɛ kiya ŋgimɔ te ɓejekɛ ɓe Yesus nja̧ kɛ kɛki nɛ diyɛ nyɛ nde: «Yo nda ɓa kwa̧ ɓɛsɔ kɛ *Kandɔ te yi kwey?» ");
INSERT INTO kkj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɛ Yesus jeɓa wɛtɛ gbɛla mɔnɔsikɛ ɓu̧ nyɛ tɛmbiɗye kɛ ɓembe yan ");
INSERT INTO kkj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","lɛpɔ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ wunɛ ti yeŋsa temɔ kpalɔ ɓɛ nda ɓɔnɔsikɛ, ko wunɛ tí nyiŋɛ kɛ Kandɔ te yi kwey na! ");
INSERT INTO kkj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɗete, mumɔ hɛnɛ ɛ ta piɗyɛ yotu nda mɔnɔsikɛ nda yɔkɔ, mbɛte ta ɓɛ nyaŋgwɛte kwa̧ ɓɛsɔ kɛ Kandɔ te yi kwey. ");
INSERT INTO kkj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sendi, mɔ te ɛ ɓu̧ mɔnɔsikɛ nda yɔkɔ kimɔte kɛto mbɛ, yo mi yi mɔ te ɓu̧ gba mi kimɔte. ");
INSERT INTO kkj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma ŋgɛ wɛtɛ mumɔ kelɛ yiŋa yasi te yi yakama jatiɗye wɛtɛ mɔnɔsikɛ kɛ njoka ɓɔnɔ ɓaka ɓe tikɛ temɔ kɛ yembɛ ɓaka kɛ ɓeya nje, ŋgɛ ɓo lɛpɛ ndi nde, ɓo ɓôŋ tari kɔkuna yasi kɛsɛ kɛ ŋgiŋ mɔ te kwa̧ ɓetɛ nyɛ kɛ maŋ, yite ɓo jekima kelɔ kimɔ yasi nɛ nyɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«O nyaŋgwɛ mɛbɔnɛ mɛte yi ta ɓalɔ kɛ to ɓotu ɓe mɛnɛti maka kɛ́ wa! Kɛto yo nde, mɛyasi mɛte yi yakama jatiɗye mumɔ kɛ ɓeya nje kɛ́ yâkaŋgwɛ ɗya̧. Yasi wɛtɛ, mɛbɔnɛ ta ɓalɔ kɛ to mɔ te ɛ kelɛ nde, yo ɗyâŋ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ŋgɛ ɓɛ nde, wɛtɛ ɓɔ yɔ ho wɛtɛ kol wɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ kîla yo li̧ nɛ naŋ. Yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, nyiŋa ndi nɛ ɓɔ wɛtɛ ho ndi nɛ kol wɛtɛ kɛ ɗyoɓɔ, ɓɛ nɛ joŋgwɛ, laŋsa nde, ɓo ɓêta wɛ kɛ ɗitɛ te yi ju̧ kpo nɛ kpo kɛ́ nɛ mɛɓɔ ho nɛ mɛkol mɔ hɛnɛ yiɓa nɛ jɛm. ");
INSERT INTO kkj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ŋgɛ ɓɛ nde, wɛtɛ misi yɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ ɗôka misi te mbɛte li̧ nɛ naŋ. Yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, nyiŋa ndi nɛ misi wɛtɛ kɛ ɗyoɓɔ, ɓɛ nɛ joŋgwɛ, laŋsa nde, ɓo ɓêta wɛ kɛ ɗitɛ te yi ti ɗím kɛ́ nɛ misi mɔ hɛnɛ yiɓa nɛ jɛm. ");
INSERT INTO kkj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Wunɛ ɗîy nɛ sɔsɔ yí yɛliyɛ wɛtɛ mɔnɔsikɛ kɛ njoka ɓɔnɔ ɓaka. Mi kɛ kombile lɛpɔ nyɛ wunɛ ɗete, kɛto ɓejaki ɓete ɓe ɓakiɗye ɓo ɓaka kɛ ɗiki nje kɛ mbɔmbu Saŋmbɛ te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ mɛŋgimɔ hɛnɛ.  ");
INSERT INTO kkj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yo nde, *Mɔnɔ mumɔ ma njáki nje sa̧ ɓotu ɓete ɓe ma ɗimbiyɛ ɓaka joŋgwɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Nɛ ɓɛ́ŋa nan? Ŋgɛ wɛtɛ mumɔ ɓɛ nɛ ɓesam gɔmay, ŋgɛ wɛtɛ ɗimbiyɛ, a kél nan? ’A ti páŋ pa tikɔ ɓesam kamɔtan jɔ kamɔni jɔ yitan jɔ yini te ɓari kɛ mbɛy mɛɗye, pa kɛ̀ sa̧ yɔkɔ ɛ ɗimbiya kɔ na? ");
INSERT INTO kkj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ nyɛ kweɗya nyɛ, a ɓɛ́ki nɛ mɛsosa, laŋsa yikɛ yi nyɛ ɓɛ nɔ kɛto ɓe kamɔtan jɔ kamɔni jɔ yitan jɔ yini te ɓari ɓe tì ɗimbiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɗete sendi, Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ yeti kɛ jayɛ nde, wɛtɛ mumɔ kɛ njoka ɓɔnɔ ɓaka yâmbila na. ");
INSERT INTO kkj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ŋgɛ mɔŋ kelɛ yiŋa ɓeya yasi suŋgwɛ nɛ wɛ, nɔ̀ kɛ̂n dolɔ nyɛ ndi wunɛ yiɓa ndeyɛ nyɛ kɛ ɓeya yasi te yi nyɛ kelma kɛ́. Ŋgɛ nyɛ jayɛ yo, yite ɔ joŋgwa nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ŋgɛ nyɛ sɛŋɛ kinɛ jayɛ na, nɔ̀ ɓôŋ ɓomɔ yiɓa ho yitati kɛ̀ dolɔ nɛ nyɛ, nɛ́ wunɛ nɛmbi lɛpi te kɛ mbɔmbu ɓotu ɓaka yiɓa ho yitati ɓe ta ɗiyɔ kɛ mbɛy te ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ŋgɛ nyɛ sɛŋɛ kinɛ jayɛ sendi yan na, nɔ̀ ɓôŋ lɛpi te kɛ̀ teɗye njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yembɛ ɓaka. Ma ŋgɛ nyɛ sɛŋɛ kinɛ jayɛ yan na, nɔ̀ ɓɛ̂ŋa nyɛ nda mɔ te ɛ tì pa duwɛ Njambiyɛ na, ɓɛŋɛ nyɛ nda ɓotu ɓe ɓoŋna mɔni garama. ");
INSERT INTO kkj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Yasi hɛnɛ te yi wunɛ ta kpo kɛ mɛnɛti maka, yo ta ɓɛ sendi kponate ɗete kɛ kwey. Sendi, yasi hɛnɛ te yi wunɛ ta wunjɛ kɛ mɛnɛti maka ta ɓɛ sendi wunjinate ɗete kɛ kwey. ");
INSERT INTO kkj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gbakasi sendi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ ɓomɔ yiɓa kɛ njoka yun saŋgwɛ mɛtemɔ kɛ mɛnɛti maka yí diyɛ ko kwalɔ yasi te nda, Saŋmbɛ te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ ta nyɛ ɓo ya te, ");
INSERT INTO kkj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","kɛto kɛ mbɛy komɛ ɓomɔ yiɓa ho yitati ŋgbɔ saŋgwa nɛ ɗinɔ ɗyembɛ, mi womɛte kɛ njoka wan.» ");
INSERT INTO kkj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ndana, ɛ Piyɛr tɛmɛ kɛ̀ kɛ kɛki Yesus diyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ŋgɛ maŋmbɛ ɗiki kelɔ yiŋa ɓeya yasi suŋgwɛ nɛ mi, mi yakama tikɔ nyɛ nɛ ŋgwɛtɛ kumɔ mɛŋga niŋgɔ? ’Mi yakama tikɔ nyɛ nɛ ŋgwɛtɛ kumɔ mɛŋga yitan jɔ yiɓa?» ");
INSERT INTO kkj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ja̧, mi yeti kɛ lɛpɔ nde: Tikɔ ndi nyɛ nɛ ŋgwɛtɛ mɛŋga yitan jɔ yiɓa na. Mi lɛ́pi nde: Tikɔ nyɛ nɛ ŋgwɛtɛ mɛŋga kamɔtan jɔ kaɓa mɛŋga yitan jɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Yo ɗete, *Kandɔ te yi kwey nda wɛtɛ kumande te ɛ kwaɗya duwɛ ɓuyɔ mɛyasi mɛnɛ yi ɓa̧ kɛ mɛɓɔ mɛ ɓotu ɓe mɛsay ɓenɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ndana, piŋɔ te yi nyɛ ɓa̧ kɛ tɔlɔ nɛmbɛ yo ɗete kɛ́, ɛ ɓo ɗya̧ nɛ wɛtɛ mɔ mɛsay wenɛ ɛ ɓa̧ nɛ mɔni nɛ kumɔ ɓuɗya ɓemiliyɔŋ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mɔ mɛsay kɔ tì ɓɛ nɛ mɔni te yi gbo nɛ pilo te na. Ɛ masa wenɛ pɛsɛ nde, a ta ɗyaŋgwɛ nyɛ nɛ̀ nyari nɛ̀ ɓɔnɔ ɓenɛ nɛ̀ mɛyasi mɛnɛ hɛnɛ yí yɔkiɗye nɔ. ");
INSERT INTO kkj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ndana, ɛ mɔ mɛsay kɔ nje ɓalɔ kɛ nji̧ mɛkol mɛnɛ kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ lɛpɔ nde: ‹Tiso masa, gbisɔ mi kumɔ nde, mi yɔ̂kiɗya yo hɛnɛ nyɛ wɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Masa wenɛ gwa̧ ŋgwɛtɛ wenɛ ɓuɗyate, ɛ nyɛ tikɛ pilo yinɔri hɛnɛ lɛpɔ nde, a kwâŋ. ");
INSERT INTO kkj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Kɛ mɔ mɛsay kɔ ma kwa̧ ɗete kɛ́, ɛ nyɛ kɛ̀ saŋgwa nɛ wɛtɛ mɔ njɔŋ wenɛ yi ɓenɛ nyɛ ɗikima kelɔ mɛsay kɔ. Ɛ mɔ njɔŋ wenɛ te ɓa̧ nɛ pilo nɛ mil yitan jɔ yitati. Ɛ nyɛ kɛnjɛ ɓɔ ɓiye nɛ nyɛ sɔtɔ nyɛ nɛ ɗɔt kɛ ŋgiŋ lɛpɔ nde: ‹Gbokɔ mɔni mbɛ nyɛ mi.› ");
INSERT INTO kkj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ndana, ɛ mɔ njɔŋ wenɛ te ɓalɛ kɛ nji̧ mɛkol mɛnɛ ŋgwɛta nɛ nyɛ lɛpɔ nde: ‹Tiso, gbisɔ mi kumɔ nde, mi gbôku yo hɛnɛ nyɛ wɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yasi wɛtɛ, ko a tì jayɛ na. A kwaŋma ɓu̧ nyɛ nyɛ kɛ jɔɓɔ kumɔ kɛ ŋgimɔ te yi nyɛ gboma nɛ pilo yinɔri hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kɛ ɓotu ɓete ɓe ɓenɛ ɓo ɗikima kelɔ mɛsay ɓaka ma ɓɛŋɛ yasi te yi kwaŋnama kɛ́, ɛ yo kwaɗye ɓo temɔ ɓuɗyate. Ɛ ɓo kwa̧ kɛ̀ yekiɗye mɛyasi mɛte yi kwaŋnama hɛnɛ kɛ́ nyɛ masa wan. ");
INSERT INTO kkj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ndana, ɛ masa mɔ mɛsay kɔ jeɓa nyɛ lɛpɔ nyɛ nyɛ nde: ‹Wɛ ɓeya mɔ mɛsay! Kwey mi tikima pilo yɔ hɛnɛ, kɛto wɛ ŋgwɛtama nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ŋge ɓa kelɛ yi wɛ tì gwe ŋgwɛtɛ mɔ njɔŋ wɔ nda yi mi gwa̧ nɛ ŋgwɛtɛ wɔ sendi kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Masa wenɛ wokuma ŋgambi kaŋɛ nyɛ nyɛ ɓesɔja, ɛ ɓo teɗye nyɛ nyaŋgwɛ mɛbɔnɛ kumɔ nde, a yɔ̂kiɗya pilo nɛ hɛnɛ nyɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɛ Yesus lɛpɛ nde: «Yo ɗete sendi nda yi Saŋmbɛ te ɛ ɗiyɛ kɛ ɗyoɓɔ ta kelɔ nɛ wunɛ, ŋgɛ wunɛ ɗiyɛ kinɛ tikɔ ɓemaŋ ɓun nɛ ŋgwɛtɛ nɛ temɔ yun hɛnɛ kɛ ɓeya yasi te yi ɓo kelɛ nɛ wunɛ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kɛ Yesus ma si lɛpina ɗete kɛ́, ɛ nyɛ tɛmɛ kɛ Galile kwa̧ tɔkula kɛ̀ kɛ mɛnɛti mɛ Yuda kɛ ŋginjɛ Yurdɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nyaŋgwɛ ŋgil ɓomɔ ɓeŋgwa nyɛ, ɛ nyɛ joŋgwɛ ɓotu ɓekɔn womɛte siɗyɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Ɓefarisɛ̧ nja̧ kɛ yenɛ yí nje ɓoɓɛ nyɛ. Ɛ ɓo diyɛ nyɛ nde: «’Mɛmboŋga kɛ nyɛ ka mumɔ ɗeti nde, a sôŋa ɓɔ nɛ nyari wenɛ kɛ lɛpi hɛnɛ te yi yakama kpɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ɛ nyɛ yeŋsa nde: «’Yite nde, wunɛ tì pa tɔlɔ mɛlɛpi maka yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Kɛ yi Njambiyɛ kusuma nɛ mɛyasi kɛ kandinate kɛ́, a kusuma mbam kusɔ nyari?› ");
INSERT INTO kkj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ɛ Njambiyɛ lɛpɛ sendi nde: ‹Ɗete, mbam ta tikɔ saŋgwɛ ɓenɛ nyaŋgwɛ joŋna ɓenɛ nyari nda kɔl ɓenɛ jon. Ɓo hɛnɛ yiɓa ta kpalɔ nje ɓɛ ndi mbundɔ wɛtɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Komɛte, ɓo yeti se ɓomɔ yiɓa na, ɓo mɛ ndi mbundɔ wɛtɛ. Ma ɗete, mumɔ tî ɓaka yasi te yi Njambiyɛ sima jaŋgwɛ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɛ *Ɓefarisɛ̧ nje diyɛ nyɛ nde: «Ma kɛto ŋge yi Mɔyisi nya nje nde, mbam yakama kɛtɔ mɛkana mɛ diɗya gwaki nyɛ nyari yí soŋɛ ɓɔ nɛ nyɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Mɔyisi nya wunɛ nje nde, wunɛ sôŋa ɓɔ nɛ ɓoma ɓun, kɛto mɛtemɔ mun nɛ keskere. Yasi wɛtɛ, yo tì ɓɛ ɗete kɛ yi Njambiyɛ kusuma nɛ mɛyasi kɛ kandinate kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma mi kɛ lɛpɔ nyɛ wunɛ nde: Mbam hɛnɛ ɛ ta soŋɛ ɓɔ nɛ nyari wenɛ kinɛ nde, a jatiɗya kol kɛ sɛ̧ na, ŋgɛ mbam te kwa̧ kɛ̀ ɓu̧ mbaŋa nyari nɛ mɛgwaki, yite nyɛ mɔ kelna wanja.» ");
INSERT INTO kkj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɛ ɓejekɛ ɓenɛ lɛpɛ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, tɛri mbam ɗete kɛ mbɔmbu nyari, yite yo yeti kɛ kamɛ yaŋa nde, mumɔ ɓôŋ nyari lalɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Yeti ɓomɔ hɛnɛ yakama ɓiye to lɛpi kɛ na, yo ndi ɓotu ɓete ɓe Njambiyɛ nyɛ ɓo ɗeti te yi ɓiye to te ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yo nde, ɓaŋa ɓomɔ jáɗyikwɛ nyakɔte ɗete, ɓo ti yaka duwɛ ɓomari na. Kɛ yi ɓaŋa, yo ɓomɔ nje kelɔ nde, ɓo ɓɛ̂ki nyakɔte. Kɛ yi ɓaŋa sendi, yo ɓo nɛ ŋguru wan kwaɗyɛ ɗiyɔ ɗete kinɛ ɓu̧ ɓoma na, kɛto ɓo kɛ kwaɗyɛ kelɔ mɛsay mɛte yi ɓɛŋɛ *Kandɔ te yi kwey. Mɔ te ɛ yakama wokɔ lɛpi kɛ jayɛ yo, na jâya.» ");
INSERT INTO kkj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɗiyɔ kɛ́, ɛ ɓomɔ ɓu̧ sɛkɛ sɛkɛ ɓɔnɔsikɛ kɛ̀ nɔ kɛ yi Yesus, na kasɛ ɓɔ kɛ yotu yan ŋgwɛta nɛ Njambiyɛ kɛ to yan. Yasi wɛtɛ, ɛ ɓejekɛ ɓamɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Nɛ tîki sɛkɛ sɛkɛ ɓɔnɔsikɛ, nɛ́ ɓo nje kɛ yembɛ. Nɛ tî peti ɓo na, kɛto *Kandɔ te yi kwey, yo yi njɛl ɓotu ɓete ɓe nda ɓo ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kɛ nyɛ ma si kasɛ mɛɓɔ kɛ yotu yan kɛ́, ɛ nyɛ nje tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ndana, ɛ wɛtɛ mbam nje kɛ yi Yesus lɛpɔ nyɛ nyɛ nde: «Yekele, mi kêl kwalɔ kimɔ yasi te nda, nɛ́ mi ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo?» ");
INSERT INTO kkj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Kɛto ŋge yi wɛ diyɛ mi diyan kɛ kasi yasi te yi kimɔte kɛ́? Kimɔ mumɔ ndi gba wɛtɛ. Ŋgɛ wɛ kwaɗyɛ ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo, ɓakiɗya mɛmboŋga mɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɛ mbam kɔ diyɛ nyɛ nde: «Mɛmboŋga te yin?» Ɛ Yesus yeŋsa nde: «Kpɛ, wɛ tî woku mumɔ. Wɛ tî kel wanja. Wɛ tî guɓu na. Wɛ tî pɛsi lɛpi nyɛ kɛ numbu mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jɛsɔ sɔŋgwɛ ɓenɛ nyɔŋgwɛ. Sendi, kwaɗyikwɛ jakɔsɔ mumɔ nda yi wɛ kwaɗyɛ nɛ yotu yɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɛ gwanjɔ kɔ yeŋsa nyɛ nyɛ nde: «Mi kɛ ɓakiɗye mɛyasi mɛnɔri hɛnɛ, ɓukwa̧ sendi ŋge yi mi tì pa kelɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ŋgɛ wɛ kwaɗyɛ ɓɛ nɛ njololo, kwaŋgɔ, kɛn ɗyaŋgwɛ mɛyasi mɔ hɛnɛ ɓu̧ mɔni te kaɓɔ nyɛ buka ɓomɔ. Ɗete, wɛ ta ɓɛ nɛ kusuku kɛ ɗyoɓɔ, kɛ kɔŋte, nɔ̀ ɓêŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yasi wɛtɛ, kɛ gwanjɔ kɔ ma wokɔ ɗete kɛ́, ɛ nyɛ kwa̧ nɛ ŋgambi kɛ temɔ, kɛto a ɓa̧ nɛ ɓuɗya kusuku. ");
INSERT INTO kkj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɛ Yesus nje lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Yo gba sulnate nde, mɔ kusuku nyîŋa kɛ *Kandɔ te yi kwey. ");
INSERT INTO kkj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi kɛ lɛpɔ sendi nyɛ wunɛ nde: Yo jɛwnate nde, nyaŋgwɛ nyamɔ nde *samo yakama kwa̧ lalɛ nɛdɔ kɛ njɛmbi alula nɛ̀ nde, mɔ kusuku nyîŋa kɛ *Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kɛ ɓejekɛ ma wokɔ lɛpi yinɔri kɛ́, ɛ ɓo ŋgbakima ɓuɗyate lɛpɔ nde: «Ma ŋgɛ ɓɛ ɗete, nda yakama ju̧ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ɛ Yesus ŋgɛkila ɓɛŋɛ ɓo lɛpɔ nyɛ ɓo nde: «Kɛ yi ɓomɔ mumɔ yeti nɛ ɗeti te yi kelɔ ɗete na. Ma kɛ yi Njambiyɛ, a nɛ ɗeti te yi kelɔ mɛyasi hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ndana, ɛ Piyɛr ɓu̧ lɛpi lɛpɔ nyɛ nyɛ nde: «Wusɛ ma tikɔ su mɛyasi hɛnɛ ɓeŋgwɛ wɛ. Yo ta nje ɓɛ nan kɛ yusu?» ");
INSERT INTO kkj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Komɛ *Mɔnɔ mumɔ ta nje ɗiyɔ kɛ siya ɓekumande nɛ kɛ mɔy mɛluksa yí nje kombile sendi mɛyasi hɛnɛ nɛ kɔkɔ kɛ́, wunɛ ɓotu ɓete ɓe ɓeŋgwa mi ɓaka, wunɛ ta ɗiyɔ sendi kɛ mɛsiya ɓekumande kamɔ jɔ yiɓa pɛsɔ jɔsi mɛkandɔ mɛ ɓotu Isarayɛl kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mumɔ hɛnɛ ɛ ta tikɔ mɛtu̧ mɛnɛ, tikɔ ɓemaŋ ho ɓeɗyɔmbu ho saŋgwɛ ho nyaŋgwɛ, tikɔ nyari ho ɓɔnɔ ho ŋgwaŋ nɛ kɛto mbɛ, mɔ te ta kpalɔ ɓɛ nɛ mɛyasi kwa̧ yite. A ta ɓɛ sendi nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bosa ɓomɔ ɓuɗyate ta nje ɓɛ ɓotu ɓe njimɛ. Sendi, ɓotu ɓe njimɛ ta ɓɛ bosa ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Yo nde, *Kandɔ te yi kwey nda wɛtɛ masa mɛsay ɛ punduma ɓemɛŋmɛnɛ nɛ kpuŋ yí kɛ̀ gɔsɔ ɓomɔ, nɛ́ ɓo kɛ̀ kel mɛsay kɛ ŋgwaŋ *vinyɛ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A kombila ɓenɛ ɓo nde, a ta gbo ɓo nda yi ɓo ɗiki gbo nɛ mɔ mɛsay kɛ yesɔ wɛtɛ kɛ́. Kɛ kɔŋte, ɛ nyɛ kwaŋɗye ɓo kɛnjɛ kɛ mɛsay kɛ ŋgwaŋ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kɛ yesɔ ma ɓendɔ kumɔ kɛ pɔku hawa yitan jɔ yini kɛ́, ɛ nyɛ pundɛ sendi. A dól ɓaŋa ɓomɔ kɛ ɗiyɔ kɛ babal kinɛ yaŋa te yi ɓo kelɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: ‹Wunɛ sendi, wunɛ kɛ̂n kelɔ mɛsay kɛ ŋgwaŋ mbɛ, mi ta nyɛ wunɛ yasi te yi ta yaka wunɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɛ ɓo kwa̧ kɛ̀ ŋgwaŋ. Ɗiyɔ kɛ́, ɛ masa mɛsay kɔ pundɛ sendi kɛ ɓembe yesɔ, nje pundɔ sendi kɛ pɔku hawa yitati te yi ɓekoko. A kelma ndi nda yi nyɛ kelma nɛ ɓari kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɗiyɔ kɛ pɔku hawa yitan te yi ɓekoko kɛ́, ɛ nyɛ nje pundɔ sendi dolɔ ɓaŋa ɓomɔ ndi kɛ ɗiyɔ womɛte. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: ‹Ŋge ɓa yi wunɛ kwaŋɗye ndiŋgɛlɛ yesɔ waka kinɛ yaŋa te yi wunɛ kelɛ kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɛ ɓo yeŋsa nyɛ nyɛ nde: ‹Yo nde, ko mumɔ tì jeɓa wusɛ nɛ mɛsay na.› Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: ‹Wunɛ sendi, wunɛ kɛ̂n kelɔ mɛsay kɛ ŋgwaŋ mbɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Kɛ tu ma yinja kɛ́, ɛ nyɛ lɛpɛ nyɛ mɔ te ɛ ɗikima ɗiyɔ nɛ ɓotu ɓe mɛsay hɛnɛ kɔ nde: ‹Jeɓaŋgwɛ ɓotu ɓe mɛsay gbo mɔni yan nyɛ ɓo. Kanda gbona yan nɛ ɓotu ɓete ɓe mi nja̧ jeɓa njimɛ ɓaka kɛ̀ nɔ kɛ ɓe bosa ɓete.› ");
INSERT INTO kkj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɓotu ɓete ɓe nyɛ jeɓama njimɛ kɛ hawa yitan te yi ɓekoko ɓaka nja̧. Ɓo gboma mumɔ hɛnɛ nda yi ɓo ɗiki gbo nɛ mɔ mɛsay kɛ yesɔ wɛtɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kɛ kɔŋte, ɛ ɓotu ɓete ɓe nyɛ kandima jeɓa ɓaka nje. Ɓo takima nde, ɓo ta ɓiye mɔni kwa̧ ɓari. Yasi wɛtɛ, ɓo gboma sendi ɓo ndi nda yi ɓo gbo nɛ mɔ mɛsay kɛ yesɔ wɛtɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kɛ ɓo ma ɓiye mɔni ɗete kɛ́, ɛ ɓo lɛpina ɓeyate suŋgwɛ nɛ masa mɛsay lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Ɓotu ɓete ɓe wɛ jeɓama njimɛ ɓaka kelma mɛsay ndi hawa wɛtɛ. Hɛ wɔnduma su ɓiriki kelɔ mɛsay kɛ ɓaŋɓaŋ yesɔ kandɛ ɓemɛŋmɛnɛ kumɔ ɓekoko. Ma ŋge kelɛ yi wɛ nje gbo sendi ɓo nda wusɛ kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ɛ masa mɛsay yeŋsa nyɛ mbaŋa nde: ‹Sɔ mbɛ, ɓeya yasi te nda yi mi kelma nɛ wɛ kɛ́? Nduku, ’hɛ kombila nde, mi ta gbo wɛ nda yi ɓo ɗiki gbo nɛ mɔ mɛsay kɛ yesɔ wɛtɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma ɓoŋgɔ mɔni yɔ, nɔ̀ lɔ̂ndu kɛ kɛki mbɛ. Mi kwaɗyɛ nyɛ yasi nyɛ mɔ te yi mi jeɓama njimɛ kɔ ndi nda yɔ sendi. ");
INSERT INTO kkj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","’Yite nde, mi yeti ka nɛ ɗeti te yi kelɔ yasi te yi mi kwaɗyɛ nɛ kusuku mbɛ na? ’Ma temɔ yɔ kwáki suŋgwɛ nɛ mi, kɛto mi kimɔ mumɔ?› » ");
INSERT INTO kkj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɛ Yesus nje lɛpɔ nde: «Yo sendi ɗete, ɓotu ɓe njimɛ ta nje ɓɛ bosa ɓomɔ. Sendi, bosa ɓomɔ ta nje ɓɛ ɓotu ɓe njimɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ɓendɔ yí kɛ̀ pɛ Yerusalɛm kɛ́, ɛ nyɛ jeɓa ɓejekɛ ɓenɛ kamɔ jɔ yiɓa lɛpɔ nyɛ ɓo tandɛ yan kɛ nje nde: ");
INSERT INTO kkj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Nɛ ɓɛ̂ŋa, wusɛ ɓe ɓendɛ kɛ̀ pɛ Yerusalɛm ɓaka: Ɓo ta ɓu̧ *Mɔnɔ Mumɔ kaŋɛ nyɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi. Ɓo ta pɛsɔ nde, ɓo wôku nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kɛ kɔŋte, ɓo má nje ɓu̧ nyɛ kaŋɛ nyɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka, nɛ́ ɓo nyɛti nyɛ njurɔ nyɛ nɛ njambala nje ŋgba nyɛ kɛ kroa, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ndana kɛ́, ɛ nyaŋgwɛ nɛ ɓɔnɔ ɓe Seɓede ɓu̧ ɓo kɛ̀ nɔ kɛ yi Yesus, kusɛ mɛɓɔŋ kɛ mɛnɛti yí diyɛ nyɛ yiŋa yasi. ");
INSERT INTO kkj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ɛ Yesus diyɛ nyɛ nde: «Wɛ kwáɗyikwɛ ŋge?» Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Pɛsɔ nde, ɓɔnɔ ɓembɛ yiɓa ɓaka ɗîy mɛtiɗyɛ kɛ kɛki yɔ komɛ wɛ ta ɓu̧ ɗiyɔ kumande yɔ kɛ́, wɛtɛ pulɔ mbam ɓɔ, wɛtɛ pulɔ gare yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ɛ Yesus yeŋsa nde: «Wunɛ yeti kɛ duwɛ yasi te yi wunɛ diyɛ kɛ́ na. ’Wunɛ yakama hɔɓiye ka pelɔ mɛbɔnɛ mɛte yi mi ta hɔɓiye kɛ́?» Ɛ ɓo yeŋsa nde: «Hɛ yakama hɔɓiye.» ");
INSERT INTO kkj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yo gbate nde, wunɛ ta hɔɓiye pelɔ mɛbɔnɛ mɛte yi mi ta hɔɓiye kɛ́. Ma yasi wɛtɛ, kɛ kasi ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ ho kɛ gare mbɛ, yeti mi kaɓɛ yo nyɛ ɓomɔ na. Mɛmbɛy mɛte wókunaŋgwɛ nɛ ɓotu ɓete ɓe Saŋmbɛ sima si kombile yo tikɛ ɓo ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kɛ ɓejekɛ te ɓari kamɔ ma wokɔ yasi te yi Jak ɓenɛ Jaŋ lɛpima kɛ́, ɛ temɔ yan kwa suŋgwɛ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ɛ Yesus jeɓa ɓejekɛ hɛnɛ lɛpɔ nde: «Wunɛ duwa̧ nde, ɓekum ɓete ɓe namɛ ɓomɔ kɛto mɛnɛti ɓaka kɛ ɓendɔ to yan ɓendɔ. Ma ɓe nyaŋgwɛ ɓomɔ ɓete ɓe kɛ njoka yan ɓaka kɛ kpalɔ natɛ ɓo nata. ");
INSERT INTO kkj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yasi wɛtɛ kɛ yun, yo tî kelnaŋgwɛ ɗete na. Mɔ te ɛ kwaɗyɛ ɓɛ nyaŋgwɛte kɛ njoka yun kɔ yâkaŋgwɛ kelɔ mɛsay nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma yɔkɔ ɛ kwaɗyɛ ɓɛ bosa mumɔ kɛ njoka yun kɔ yâkaŋgwɛ ɓɛ bala ɓɛsɔ. ");
INSERT INTO kkj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yo ɗete, *Mɔnɔ mumɔ sendi nɛ ŋguru wenɛ ti ma njáki, nɛ́ ɓomɔ kel mɛsay nyɛ nyɛ na. Yasi wɛtɛ, a nja̧ nda mɔ mɛsay yí nyɛ joŋgwɛ ɗyenɛ yí kolɔ nɛ ɓuɗya ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ pundɔ ɗuwɛ kɛ Yeriko ɓenɛ ɓejekɛ ɓenɛ kɛ́, nyaŋgwɛ ŋgil ɓomɔ ɓa̧ kɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yinɔri ɓaŋa ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka yiɓa ɓa̧ mɛtiɗyɛ kɛ kɛki nje. Kɛ ɓo ma wokɔ nde, Yesus kɛ kwa̧ kɛ́, ɛ ɓo kembɛ nde: «Nyaŋgwɛ Kumande, Mɔnɔ Davit, gwakɔ ŋgwɛtɛ wusu!» ");
INSERT INTO kkj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɓo ɗikima ɓamɛ ɓo, nɛ́ ɓo ɗiɓi numbu. Ko ɗete, ɓo nja̧ kembɔ kwa̧ to te nde: «Nyaŋgwɛ Kumande, Mɔnɔ Davit, gwakɔ ŋgwɛtɛ wusu!» ");
INSERT INTO kkj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ndana, ɛ Yesus tɛmɛ jeɓa ɓo diyɛ ɓo nde: «Nɛ kwáɗyikwɛ nde, mi kêl ŋge nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, kelɔ nde, misi musu ɓɛ̂ŋnaŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus gwa̧ ŋgwɛtɛ yan kpokɛ misi man. Ndana ndana, ɛ ɓo kandɛ ɓɛŋna yasi kwa̧ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɓo kɛndima wuta nɛ Yerusalɛm, kumɔ kɛ Betfage kɛ pulɔ *Keki mɛoliviye. Ɛ Yesus tomɛ ɓaŋa ɓejekɛ yiɓa kɛnjɛ mbɔmbu lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Wunɛ kɛ̂n kɛ ɗya te ɛ kɛ mbɔmbu wun kɔ. Nɛ nyiŋna ɗya ɗekɛ wunɛ ta dolɔ wɛtɛ nya tofu tiŋnate nɛ̀ mɔnɔ wenɛ. Nɛ̀ wunɛ wûnja ɓo nje nyɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ŋgɛ mumɔ lɛpɛ yiŋa yaŋa nyɛ wunɛ, nɛ̀ wunɛ yêŋsaŋgwɛ nde: ‹Nyaŋgwɛ Kumande kɛ kwaɗyɛ ɓo.› Ɔ ɓɛ́ŋa, ndana ndana a má soŋɛ ɓɔ nɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yo nde, mɛyasi kwaŋnama ɗete, nɛ́ lɛpi te yi mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ si tôndu. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‹Nɛ lɛ̂pi nyɛ Ŋgɔndu Siyɔŋ*f1* nde: Ɓɛŋa, kumande wɔ yima pɛ yɔ. Temɔ nɛ ɗekɛ nɛ tɛ. A ɓendima nya tofu. A ɓendima mɔnɔ tofu te yi nyaŋgwɛ ɗiki soɓɛ mɛmapi kɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɓejekɛ ka̧, ɛ ɓo kelɛ nda yi Yesus lɛpima nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓo ɓoŋma nya tofu nɛ̀ mɔnɔ te ɗya̧ nɔ, ɓu̧ mɛlambɔ man jonɔ kɛ to yan, ɛ Yesus kwa̧ ɓendɔ ɓo ɗiyɔ kɛ to yan. ");
INSERT INTO kkj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sulɔ ɓotu ɓete ɓe ɓa̧ kɛ mɔy ŋgil ɓaka ɓoŋma mɛlambɔ man jonɔ kɛ nje, ɛ ɓaŋa lekɛ yan mɔnɔ ɓɔ mɛjeti ɓetɛ kɛ nje. ");
INSERT INTO kkj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ŋgil ɓotu ɓete ɓe ɓa̧ mbɔmbu nɛ̀ ɓe ɓa̧ kɛ kɔŋ nɛ ɓaka ɗikima kembɔ nde: «*Hosana Mɔnɔ Davit! Mɛkombila nɛ yɔkɔ ɛ nje nɛ ɗinɔ Baba Mbokɔ kɔ! Njambiyɛ ɓɛ̂ki nɛ mɛluksa kɛ kwey!» ");
INSERT INTO kkj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kɛ Yesus ma nyiŋɛ kɛ Yerusalɛm kɛ́, ɛ ndiŋgɛlɛ ɗya ɓɛ nɛ kamtana. Ɓomɔ ɗikima diyɛ nde: «Yɔkɔ ɓa nda?» ");
INSERT INTO kkj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɛ ɓomɔ yeŋsa nde: «Yo Yesus te mɔ punja mɛlɛpi mɛ Njambiyɛ, nyɛ mɔ Nasarɛt kɛ Galile.» ");
INSERT INTO kkj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus ɗyaŋma nyiŋɛ mbanjɔ Njambiyɛ, ɛ nyɛ ɗuɗye ɓomɔ hɛnɛ ɓe ɓa̧ kɛ ɗyaŋgwɛ nɛ̀ ɓe ɓa̧ kɛ ɓɔmɔ mɛyasi womɛte ɓaka. A tindima mɛteɓel mɛ ɓotu ɓe sɛnjina mɔni nɛ̀ mɛsolo mɛ ɓotu ɓe ɗyaŋgwa ɓepepɔ ɓetɛ kɛ mɛnɛti ");
INSERT INTO kkj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","lɛpɔ nyɛ ɓo nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓo ta jeɓa tu̧ ɗyembɛ nde tu̧ mɛŋgwɛta.› Ma yasi wɛtɛ, wunɛ kɛ kpalɔ yeŋsa yun yo nɛ gbaŋ ɓotu ɓe guɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɓaŋa ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka nɛ̀ ɓotu ɓe ndɛmbil nja̧ kɛ yi Yesus kɛ mbanjɔ Njambiyɛ, ɛ nyɛ siɗyɛ mɛkɔsu man. ");
INSERT INTO kkj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko ɗete, kɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ma ɓɛŋɛ mbɛri mɛyasi mɛte yi nyɛ kelma, wokɔ sendi nda yi ɓɔnɔsikɛ ɗikima kembiɗya kɛ mɔy mbanjɔ Njambiyɛ nde: ‹*Hosana Mɔnɔ Davit!› kɛ́, ɛ temɔ yan kwa. ");
INSERT INTO kkj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɛ ɓo lɛpɛ nyɛ Yesus nde: «’Wɛ kɛ wokɔ yasi te yi ɓo lɛpɛ kɛ́?» Ɛ nyɛ yeŋsa nde: «I̧, mi kɛ wokɔ. ’Ma yite nde, wunɛ tì pa tɔlɔ mɛlɛpi maka yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ na? Yo kɛtinate nde: ‹Wɛ kelma nde, ko sɛkɛ sɛkɛ ɓɔnɔsikɛ nɛ̀ ɓaka ɓe ndi kɛ ɗye ɓɛri ɓaka lûksa wɛ.› » ");
INSERT INTO kkj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ ŋgbɛsɛ ɓo pundɔ ɗuwɛ womɛte kɛ Yerusalɛm kwa̧ kɛ̀ ya kɛ Betani. ");
INSERT INTO kkj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Misi pupɛ ɓemɛŋmɛnɛ kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ yɔkwɛ nɛ kɔkɔ kɛ̀ Yerusalɛm kɛ́, nja ɓa̧ kɛ kelɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kɛ nyɛ ma kaŋɛ misi, a ɓɛ́ŋa wɛtɛ njuku *figiye kɛ kɛki nje. Ɛ nyɛ kwa̧ kɛ̀, a sém ndi mɛmbɔru nɛ mɛmbɔru nɛ gbi. Ɛ nyɛ lɛpɛ nyɛ njuku figiye te nde: «Yɔ siyma ɓɔnɛ, ko wɛ tí wumɔ se ko mbumɔ wɛtɛ nɛ wɛtɛ mbaŋa yesɔ na.» Ndana ndana, ɛ njuku figiye ɛnɔru gwe sɔsɔ nɛ kawoyo. ");
INSERT INTO kkj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kɛ ɓejekɛ ma ɓɛŋɛ yasi yinɔri kɛ́, ɛ ɓo ŋgbakima lɛpɔ nde: «Kelma nan yi njuku figiye kɔ gwa̧ sɔsɔ ndi ndana ndana ɗekɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ wunɛ tikɛ gba temɔ kɛ yi Njambiyɛ kinɛ mɛso na, wunɛ ta kelɔ yasi kwa̧ yikɛ yi mi kelma ndana nɛ njuku figiye kɔ kɛ́. Ko wunɛ lɛ́pi nyɛ keki te yɔkɔ nde: ‹Ɗukwɛ waka kɛ̀ ɓalɔ kɛ maŋ,› yo má kelna ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yasi hɛnɛ te yi wunɛ ta diyɛ Njambiyɛ kɛ mɛŋgwɛta mun, tikɔ gba temɔ kɛ yenɛ, a ta nyɛ wunɛ yo.» ");
INSERT INTO kkj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus nja̧ kwa̧ kɛ̀ kɛ mbanjɔ Njambiyɛ. Kɛ ŋgimɔ te nyɛ ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ́, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya nje kɛ yenɛ diyɛ nyɛ nde: «Ɗeti te yi wɛ kelɛ nɛ mɛyasi mɛte yikɛ kɛ́ wúla we? Sendi, nda nyɛ wɛ ɗeti nde, kelɔ mɛyasi mɛte?» ");
INSERT INTO kkj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mi sendi, mi ndi nɛ lɛpi wɛtɛ yi mi ta diyɛ wunɛ. Ŋgɛ wunɛ yeŋsa nyɛ mi, mi má nje lɛpɔ nyɛ wunɛ mbɛy komɛ ɗeti te yi mi kelɛ nɛ mɛyasi mɛte wulɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nda tomɛ Jaŋ nde, a njâki tɔpɛ ɓomɔ kɛ mɔrɔku? ’Yo Njambiyɛ ho yo ɓomɔ?» Ndana, ɛ ɓo kandɛ mɛdiyna tandɛ yan lɛpɔ nde: «Ŋgɛ wusɛ lɛpɛ nde: Yo Njambiyɛ, yite a ta diyɛ wusɛ nde: Ma kɛto ŋge yi wunɛ tì tikɛ temɔ kɛ yasi te yi nyɛ lɛpima kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma ŋgɛ wusɛ nje yeŋsa nde: Yo ɓomɔ, yite wusɛ yâkaŋgwɛ kambɔ ŋgil ɓomɔ, kɛto ɓomɔ hɛnɛ kɛ ɓɛŋɛ nde, Jaŋ mɔ punja mɛlɛpi mɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɗete, ɛ ɓo yeŋsa nyɛ Yesus nde: «Wusɛ yeti kɛ duwɛ na.» Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Mi sendi, mi yeti kɛ lɛpɔ yaŋa nyɛ wunɛ kɛ kasi ɗeti te yi mi kelɛ nɛ mɛyasi mɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Nɛ ta lɛpɔ nde ŋge kɛ kanɔ te yi wunɛ ta wokɔ ndana kɛ́? Mbaŋa mbam ɓa̧ nɛ ɓɔnɔ ɓembam yiɓa. Ɛ nyɛ lɛpɛ nyɛ tomba te nde: ‹Mɔnmbɛ, kɛn kelɔ say kɛ ŋgwaŋ mbɛ muka.› ");
INSERT INTO kkj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɛ nyɛ yeŋsa nde: ‹Kway na.› Ɗiyɔ kɛ́, ɛ nyɛ ɗiyɛ nɛ ŋgbum takɛ yasi tɛmɛ kwa̧ kɛ̀ ŋgwaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ndana, ɛ nyɛ dolɛ ndɛmbi te lɛpɔ ndi kiya yasi te yi nyɛ lɛpima nyɛ yɔru kɛ́ nyɛ nyɛ. Ɛ nyɛ yeŋsa nde: ‹I̧ Da, mi ta kɛ̀.› Ma yasi wɛtɛ, a tì nje kɛ̀ na. ");
INSERT INTO kkj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kɛ njoka ɓɔnɔ ɓaka yiɓa, nda wokuma mɛn saŋgwɛ kɔ?» Ɛ ɓo yeŋsa nde: «Yo tomba te.» Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓoma ɓete ɓe joŋna kɛ sap sap joŋgwɛ ɓaka ta kandɛ nyiŋɛ kɛ *Kandɔ Njambiyɛ tikɔ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yo ta ɓɛŋna ɗete, kɛto Jaŋ nja̧ kɛ yun teɗye wunɛ nje te yi nɛ ŋgbeŋ, ma wunɛ tì tikɛ temɔ kɛ yasi te yi nyɛ lɛpima kɛ́ na. Yasi wɛtɛ, ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓoma ɓete ɓe joŋna kɛ sap sap joŋgwɛ ɓaka tikima yan temɔ kɛ yasi te yi nyɛ lɛpima kɛ́. Wunɛ kómbila ɓɛŋɛ yun mɛyasi mɛnɔri hɛnɛ. Ma nɛ nde, wunɛ njâki yeŋsa temɔ kɛ kɔŋte yí tikɔ temɔ kɛ yasi te yi nyɛ lɛpima kɛ́, wusɛ tì kelɛ ɗete na. ");
INSERT INTO kkj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Wunɛ wôku sendi wɛtɛ kanɔ. Wɛtɛ masa mɛsay sama ŋgwaŋ *vinyɛ. Ɛ nyɛ kelɛ kakwɛ litɔ nɛ yo, timɔ mbɛy sɔpita mɛmbumɔ, sumɔ sendi doŋgbe doŋgbe tu̧ yí pɛmna ŋgwaŋ. Ɛ nyɛ nje kaŋɛ yo hɛnɛ nyɛ ɓaŋa ɓotu ɓe mɛsay nde, ɓo ɓâkiɗya, ɓɛ sendi nɛ ŋgaɓiyɛ te yan kɛte. Kɛ kɔŋte, ɛ nyɛ kwa̧ kɛ̀ lɔndunate kɛ yiŋa mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɛ ŋgimɔ te yi mɛmbumɔ ma si ɗetɔ kɛ ŋgwaŋ kɛ́ ma ɗya̧, ɛ nyɛ tomɛ ɓaŋa ɓotu ɓe mɛsay kɛnjɛ kɛ yi ɓari, nɛ́ ɓo njesɛ nyɛ yiŋa kwalɔ mɛmbumɔ mɛ ŋgwaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yasi wɛtɛ, ɛ ɓotu ɓe ɓa̧ nɛ mɛsay te ɓari ɓiye ɓo mɛndɛ wɛtɛ, wo mbaŋa, lu̧ mɔ yitatite nɛ mɛtari wo. ");
INSERT INTO kkj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kɛ kɔŋte, ɛ nyɛ tomɛ sendi ɓaŋa ɓotu ɓe mɛsay ɓuɗyate kwa̧ ɓe mbɔmbu. Ɛ ɓo kelɛ nɛ ɓo ndi nda yi ɓo kelma nɛ bosa ɓomɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yí siɗyɛ nɔ, ɛ nyɛ nje tomɔ mɔnɔ wenɛ kɛnjɛ lɛpɔ nde: ‹Ɓo ta kambɔ, kɛto yo mɔnmbɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yasi wɛtɛ, kɛ ɓotu ɓaka ma kaŋɛ misi ɓɛŋɛ nɛ nyɛ kɛ́, ɛ ɓo lɛpɛ tandɛ yan nde: ‹Mɔ te ɛ ta tika nɛ mɛlikɔ, ɛkɔ. Nɛ njâki, hɛ wôku nyɛ, nɛ́ wusɛ tika nɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɛ ɓo ɓiye nyɛ kɛ̀ ɓetɛ kɛ kɔŋ ŋgwaŋ wo. ");
INSERT INTO kkj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ma ndana, komɛ sa ŋgwaŋ ta kɛ̀ nje kɛ́, a ta kelɔ nan nɛ ɓotu ɓaka?» ");
INSERT INTO kkj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɛ ɓo yeŋsa nyɛ Yesus nde: «A ta girise ɓeya ɓotu ɓenɔri nɛ nyalɔ, nje kaŋɛ ŋgwaŋ nyɛ ɓaŋa ɓotu ɓe mɛsay ɓe ta nyɛ nyɛ mɛmbumɔ kɛ ŋgimɔ ɗya̧.» ");
INSERT INTO kkj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «’Yite nde, wunɛ tì pa tɔlɔ lɛpi kɛ yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ na? Yo kɛtinate nde: ‹Tari*f1* te yi ɓotu ɓe sumna tu̧ sɛŋma kɔ kpalma nje ɓɛ saŋgwɛ kondu. Ma yasi kɛ, yo mɛkele mɛ Baba Mbokɔ, yo yasi te yi wusɛ ɓɛŋɛ ŋgbakima.› ");
INSERT INTO kkj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Njambiyɛ ta soŋɛ *Kandɔ ɗyenɛ kɛ mɛɓɔ mun, a má nje kaŋɛ yo nyɛ kandɔ te ɛ ta kelɔ mɛyasi nɛ ŋgbeŋ nda yi nyɛ Njambiyɛ kwaɗyɛ kɛ́.  ");
INSERT INTO kkj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ŋgɛ mumɔ ɓalɛ kɛ Tari te, a ta lekwɛ nɛ mutu mutu. Sendi, ŋgɛ Tari te ɓalɛ kɛ to mumɔ, yo ta kɔkɔ nyɛ nɛ mbɔl.» ");
INSERT INTO kkj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ *Ɓefarisɛ̧ wokuma mɛkanɔ mɛnɔri, ɛ ɓo duwɛ nde, Yesus lɛ́pinaŋgwɛ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓo saŋma nje te yi ɓiye nyɛ, yasi wɛtɛ, ɓo ɓa̧ kɛ kambɔ ŋgil ɓomɔ, kɛto ɓomɔ ɓɛŋma nde, Yesus mɔ punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus nja̧ kɛ̀ sendi mbɔmbu lɛpina nyɛ ɓomɔ nɛ nje mɛkanɔ. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«*Kandɔ te yi kwey kɛ ɓoŋna nɛ wɛtɛ kumande te ɛ kelma jesɔ gwaki mɔnɔ wenɛ ɛ mbam kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A tomma ɓotu ɓe mɛsay ɓenɛ kɛ̀ jeɓa nɛ ɓotu ɓete ɓe nyɛ jeɓama kɛ jesɔ ɓaka. Yasi wɛtɛ, ɓotu ɓete tì kwaɗyɛ nje na. ");
INSERT INTO kkj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A nja̧ ɓasiɗye tomɔ ɓaŋa ɓotu ɓe mɛsay lɛpɔ nde: ‹Nɛ kɛ̂n lɛpɔ nyɛ ɓotu ɓete ɓe mi jeɓama ɓaka nde: Mi sima kombile mɛɗye hɛnɛ. Mi woma ɓenday nɛ̀ ɓenyamɔ ɓete ɓe nɛ mutɔ ɓaka. Mɛyasi mɛ kombilate, ɓo njâki kɛ jesɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yasi wɛtɛ, ɓotu ɓete yɛliya jeɓan te tɔkɛ kɛndi yan kwa̧. Yɔkɔ ɛ tɛmɛ kɛ̀ ŋgwaŋ nɛ, yɔru ɛ kwa̧ kɛ̀ ɗyaŋgwɛ mɛjɛŋ mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓukwɛ te ɓaka tɛmma ɓiye ɓotu ɓe mɛsay ɓe kumande teɗye ɓo mɛbɔnɛ wo ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Temɔ kumande kwama ɓuɗyate, ɛ nyɛ tomɛ ɓesɔja ɓenɛ si kɛ̀ girise nɛ ɓeya ɓotu ɓe wona ɓomɔ ɓaka, loɗyɛ ɗya ɗyan. ");
INSERT INTO kkj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kumande nja̧ lɛpɔ nyɛ ɓotu ɓe mɛsay ɓenɛ nde: ‹Mi ma komsa jesɔ, ma ɓotu ɓete ɓe mi jeɓama ɓaka ti yaka nɛ jesɔ te na. ");
INSERT INTO kkj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ndana, nɛ kɛ̂n nɛ mɛmanɔ yi kɛ̀ nɔ. Ɓomɔ hɛnɛ te yi wunɛ ta dolɔ, wunɛ lɛ̂pi nyɛ ɓo nde, ɓo njâki kɛ jesɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɓotu ɓe mɛsay ka̧ nɛ ɓoku mɛnje ŋgbɔ ɓomɔ hɛnɛ te yi ɓo dolma, ko ɓeya ɓomɔ ko kimɔ ɓomɔ. Ɛ tu̧ jesɔ tondɛ nɛ ɓomɔ nɛ ŋgbɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kumande nja̧ nyiŋɛ tu̧ yí nje ɓɛŋɛ ɓomɔ, a sém mbaŋa mumɔ kɛ njokate kinɛ lambɔ jesɔ gwaki kɛ yotu na. ");
INSERT INTO kkj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ɛ nyɛ diyɛ nyɛ nde: ‹Sɔ mbɛ, yo kwaŋnama nan yi wɛ nyiŋma waka kinɛ lambɔ jesɔ gwaki kɛ yotu kɛ́?› Mbam ɗiyma nɛ kpiŋgbili kinɛ ɓutɛ numbu na. ");
INSERT INTO kkj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɛ kumande lɛpɛ nyɛ ɓotu ɓe mɛsay nde: ‹Wunɛ ɓîya nyɛ wotɔ mɛkol nɛ̀ mɛɓɔ mɛnɛ tɔkɛ nyɛ ɓetɛ kɛ sɛ̧ kɛ yitil. Yo womɛte komɛ nyɛ ta lelɔ nyambɔ mɛsu̧.› ");
INSERT INTO kkj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yo nde, Njambiyɛ jéɓaŋgwɛ ɓomɔ ɓuɗyate, ma ɓaka ɓe nyɛ tɔkɛ kɛ njokate ɓaka ti ɓuyɔ na.» ");
INSERT INTO kkj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ndana, ɛ *Ɓefarisɛ̧ kwa̧ kɛ̀ kelɔ kutu yí ɓɛŋɛ nɛ nje te yi ɓo yakama dɔŋgiɗye nɛ Yesus wulɛ kɛ yasi te yi nyɛ nɛ ŋguru wenɛ ta lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓo tomma ɓejekɛ ɓan nɛ̀ ɓaŋa ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ kumande Herod ɓaka kɛnjɛ kɛ yi Yesus lɛpɔ nde: «Yekele, hɛ duwa̧ nde, wɛ mɔ gbakasi. Wɛ téɗya nje Njambiyɛ gbate gbate ko kɛ misi mɛ nda, kɛto wɛ ti ɓáŋ yɔ mbɛri misi mɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ma, lɛpɔ yasi te yi wɛ takɛ kɛ lɛpi kɛ kɛ́: ’Mɛmboŋga lɛ́pi ka nde, mumɔ gbôku garama nyɛ *Sesar ho a tî gboku?» ");
INSERT INTO kkj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yasi wɛtɛ, Yesus duwa̧ ɓeya mɛtakɛ man. Ɛ nyɛ yeŋsa nde: «Wunɛ ɓotu ɓe likisi, wunɛ ɓóɓa mi kɛto ŋge? ");
INSERT INTO kkj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wunɛ pâŋ pa teɗye mi mɔni te yi ɓo ɗiki gbo nɛ garama kɛ́.» Ɛ ɓo nje nɛ sule wɛtɛ ɓu̧ kaŋɛ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ɛ nyɛ diyɛ ɓo nde: «Yikɛ yekambiyɛ to nda? Mɛkɛti mɛte yikɛ téɗya nda?» ");
INSERT INTO kkj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Yo yi Sesar.» Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Ɗete, wunɛ nyɛ̂ki Sesar mɛyasi mɛte yenɛ, nyɛ Njambiyɛ mɛyasi mɛte yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ɓo wokuma nda yi Yesus yeŋsama kɛ́, ɛ ɓo ŋgbakima ŋgbɛsɛ nyɛ tɔkɛ kɛndi si kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kɛ kiya yesɔ te *Ɓesadusɛ̧ ɓe lɛpɛ nde, ɓemuŋ tí womiyɛ ɓaka nja̧ kɛ yi Yesus lɛpɔ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Yekele, Mɔyisi lɛpima nde: ‹Ŋgɛ mbam gwe kinɛ tikɔ mɔnɔsikɛ na, nɛ̀ maŋ nɛ mbam te ɓôŋ kusɔ, na ja ɓenɛ nyɛ yí kwaŋɗye nɛ ɗinɔ maŋ ɛ gwa̧ kɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma yo ɓa̧ nɛ ɓaŋa ɓɔnɔ ɓembam yitan jɔ yiɓa ɓe jaɗya kɛ mɔy yan, ɓo joŋnama kɛ njoka wusu. Tomba te ɓoŋma nyari nje gwe. Nda a tì ja kɛ́, ɛ ndɛmbi te ɓu̧ kusɔ maŋ. ");
INSERT INTO kkj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yo nja̧ kwaŋna ndi sendi ɗete nɛ̀ ndɛmbi te nɛ̀ mɔ yitatite kumɔ kɛ mɔ yitan jɔ yiɓate. ");
INSERT INTO kkj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɗiyɔ kɛ́, ɛ nyari nje gwe sendi kɛ kɔŋ yan hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ma kɛ yesɔ te yi ɓemuŋ ta womiyɛ nɔ kɛ́, kɛ njoka ɓembam ɓaka yitan jɔ yiɓa, nya kɔ ta nje ɓɛ nya nda, kɛto ɓo hɛnɛ ɓoŋma nyɛ nɛ mɛgwaki?» ");
INSERT INTO kkj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Wunɛ kɛ mɔy mɛjɔsɔ, kɛto wunɛ kɛ ndekima yasi te yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́, ndekima sendi ŋguŋguɗyɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yo nde, komɛ ɓemuŋ ta womiyɛ kɛ́, mɛgwaki tí ɓɛŋna se na. Yasi wɛtɛ, ɓomɔ hɛnɛ ta joŋna nda yi ɓejaki ɓe Njambiyɛ joŋna nɔ kɛ ɗyoɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma kɛ kasi womiya ɓemuŋ, ’yite nde, wunɛ tì pa tɔlɔ ka yasi te yi Njambiyɛ lɛpima nyɛ wunɛ kɛ́ na? Njambiyɛ lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Mi mbɛ Njambiyɛ te ɛ Abaraham, Njambiyɛ te ɛ Isak, Njambiyɛ te ɛ Yakɔp.› Yo nde, Njambiyɛ yeti Njambiyɛ ɓemuŋ na, nyɛ Njambiyɛ te ɛ ɓotu ɓete ɓe nɛ joŋ ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ŋgil ɓotu ɓete ɓe lɛŋgwa mɛtɔ kɛ yasi te yi Yesus ɗikima lɛpɔ kɛ́ ŋgbakimama kwalɔ teɗya yasi te yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kɛ *Ɓefarisɛ̧ ma wokɔ nde, a ɗiɓima numbu *Ɓesadusɛ̧ kɛ yeŋsa lɛpi te yi nyɛ yeŋsama kɛ́, ɛ ɓo kwa̧ wesiɗya. ");
INSERT INTO kkj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wɛtɛ kɛ njoka yan ɓa̧ nyaŋgwɛ mɔ teɗya mɛmboŋga. Ɛ nyɛ diyɛ Yesus diyan yí lɛɓiye nɛ nyɛ. A diyma nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Yekele, kɛ njoka mɛmboŋga, yɛn kwa̧ ɓɛsɔ?» ");
INSERT INTO kkj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ɛ Yesus yeŋsa nyɛ nyɛ nde: « ‹Kwaɗyikwɛ Baba Mbokɔ te Njambiyɛ wɔ nɛ temɔ yɔ hɛnɛ, nɛ sisiŋ yɔ hɛnɛ, nɛ ɗyanɔ ɗyɔ hɛnɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Bosa mboŋga nɛ̀ nyaŋgwɛ mboŋga te ɛ kwaŋma ɓɛsɔ hɛnɛ kɔ, ɛru. ");
INSERT INTO kkj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mboŋga yiɓate ɛ kɛ ɓoŋna nɛ mbɛte, yo yɔkɔ ɛ lɛpɛ nde: ‹Kwaɗyikwɛ mɔŋ nda yi wɛ kwaɗyɛ nɛ yotu yɔ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mɛmboŋga maka yiɓa ɓɛ njuku mɛmboŋga nɛ̀ njuku mɛlɛpi hɛnɛ te yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nda yi *Ɓefarisɛ̧ wesiɗyama kɛ́, ɛ Yesus diyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Nɛ táka nde, *Krist nda? Nyɛ mɔnɔ nda?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Nyɛ Mɔnɔ Davit.» ");
INSERT INTO kkj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Ma ŋge nje kelɔ nde, Kimɔ Sisiŋ nyɛ̂ki Davit ɗeti te yi jeɓa nyɛ nde Kumande wenɛ kɛ́? Kɛto Davit lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Baba Mbokɔ lɛpima nyɛ Kumande wombɛ nde: Ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ mbɛ kumɔ nde, mi sîki kawule ɓependɔ ɓɔ tikɔ kɛ nji̧ mɛkol mɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ma ŋgɛ Davit jeɓa nyɛ nde Kumande, yite Kumande wenɛ ta kpalɔ nje ɓɛ mɔnɔ wenɛ nan?» ");
INSERT INTO kkj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛ nɛ ɗeti te yi yeŋsa yaŋa nyɛ nyɛ na. Kandɛ yesɔ te ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓoɓɛ diyɛ se nyɛ yiŋa diyan na. ");
INSERT INTO kkj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ndana, ɛ Yesus lɛpɛ nyɛ ŋgil ɓomɔ nɛ̀ ɓejekɛ ɓenɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧ ndana kɛ mbɛy Mɔyisi yí teɗye mɛmboŋga mɛ Njambiyɛ yi Mɔyisi kɛtima kɛ́ nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɗete, wunɛ kêl ɓakiɗye mɛyasi hɛnɛ te yi ɓo ta lɛpɔ nyɛ wunɛ kɛ́, ma yasi wɛtɛ, nɛ tî joŋnaŋgwɛ nda ɓo na, kɛto ɓo lɛ́pi ndi yasi lɛpɔ kɛ numbu kinɛ nje kelɔ nda yi ɓo lɛpima kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓo kánja ɗitina mɛmapi soɓiɗye ɓomɔ kɛ ɓɛkɔ. Ma yasi wɛtɛ, ɓo nɛ ŋguru wan yeti kɛ sambile nyɛy ɓɔ wɛtɛ kpokɛ nɛ yo na. ");
INSERT INTO kkj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ɓo kél mɛkele man hɛnɛ nde, nɛ́ ɓomɔ ɓɛŋ ɓo. Ɗete, ɓo kɛ ɗɔkwɛ mɔnɔ mɛyasi mɛte yi ɓo ɗiki lɛŋɛ yi nɛ mɛmboŋga mɛ Mɔyisi kɛ mɔyte kɛ́ kwa̧ yi ɓɛsɔ, sɛwɗye sendi mɛyasi mɛte yi ɓo nyɛ kɛ numbu mɛlambɔ man kɛ́ nɛ ndulɛŋ ndulɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɓo sáŋ kpasa mɛmbɛy kɛ mɛtu̧ mɛdina, kwaɗyɛ ɗiyɔ kɛ bosa mɛmbɛy kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Ɓo kwáɗyikwɛ nde, ɓomɔ kɛ̂ nyɛnɔ ɓo kɛ mɛmbɛy komɛ ɓomɔ ɗiki wesiɗya kɛ́, ");
INSERT INTO kkj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kwaɗyɛ sendi nde, ɓomɔ kɛ̂ jeɓaŋgwɛ ɓo nde yekele. ");
INSERT INTO kkj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma ŋgɛ ɓɛ wunɛ, wunɛ tî saŋ nde, mumɔ jêɓaŋgwɛ wunɛ nde yekele na, kɛto wunɛ ndi nɛ Yekele wɛtɛ nɛ wɛtɛ. Ma wunɛ hɛnɛ ɓemaŋ nɛ ɓemaŋ. ");
INSERT INTO kkj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wunɛ tî jeɓaŋgwɛ wɛtɛ mumɔ kɛ to mɛnɛti nde da na, kɛto wunɛ ndi nɛ Da wɛtɛ nɛ wɛtɛ, yo yɔkɔ ɛ ɗiyɛ kɛ kwey kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɛ tî saŋ nde, mumɔ jêɓaŋgwɛ wunɛ nde masa na, kɛto wunɛ ndi nɛ Masa wɛtɛ nɛ wɛtɛ, yo *Krist. ");
INSERT INTO kkj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mɔ te ɛ ɓɛ nyaŋgwɛte kɛ njoka yun kwa̧ ɓɛsɔ kɔ yâkaŋgwɛ kelɔ mɛsay nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mɔ te ɛ ɓendiɗye yotu kɛnjɛ kwey, Njambiyɛ ta piɗyɛ nyɛ kɛnjɛ nji̧. Ma yɔkɔ ɛ piɗyɛ yotu kɛnjɛ nji̧, Njambiyɛ ta kpalɔ ɓendiɗye nyɛ kɛnjɛ kwey.» ");
INSERT INTO kkj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe teɗya mɛmboŋga nɛ̀ *Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi, kɛto wunɛ kɛ ɗiɓɔ numɛy te yi *Kandɔ te yi kwey kɛ mbɔmbu ɓomɔ. Wunɛ nɛ ŋguru wun yeti kɛ nyiŋɛ kɛte na, ma wunɛ yeti kɛ tikɔ nde, ɓotu ɓete ɓe kwaɗyɛ nyiŋɛ kɛte ɓaka nyîŋa na.  ");
INSERT INTO kkj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe teɗya mɛmboŋga nɛ̀ Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto wunɛ kɛ wɛnjile mɛyasi hɛnɛ nɛ mbul kɛ mɛɓɔ mɛ ɓekusɔ ɓomari ɗiki nje kelɔ sɛwna mɛŋgwɛta, nɛ́ ɓomɔ ɓɛŋ nde, wunɛ kimɔ ɓomɔ. Ɗete, Njambiyɛ ta jɔse wunɛ ɗetinate teɗye wunɛ nyaŋgwɛ mɛbɔnɛ kwa̧ to te. ");
INSERT INTO kkj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe teɗya mɛmboŋga nɛ̀ Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto wunɛ kɛ ɓendɔ mɛlandi kɛ̀ nɔ kɛ to mɛɗuku, kɛ̀ mɛkɛndi kɛ to mɛnɛti yí sa̧ mɔ te ɛ ta yeŋsa temɔ nyiŋɛ kɛ misɔn yun. Ma ŋgɛ nyɛ si nyiŋɛ ɗete kɛ́, wunɛ kpalma nje kelɔ nde, a ɓɛ̂ki yɔkɔ ɛ ta kɛ̀ kɛ ɗitɛ te yi ti ɗím kɛ́, kɛto wunɛ ta kelɔ nde, a kêl ɓeya yasi kwa̧ wunɛ mɛŋga yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe ɗibina misi ɓe kɛndɛ nɛ ɓomɔ ɓaka! Wunɛ lɛ́pi nde: ‹Ŋgɛ mumɔ kinja mbanjɔ Njambiyɛ, a yakama ɗiyɔ kinɛ tonjɛ yasi te yi nyɛ kpoma kɛ́ na. Yasi wɛtɛ, ŋgɛ nyɛ kinja lɔr te yi ɗiyɛ kɛ mbanjɔ Njambiyɛ kɛ́, na tônjukwɛ yasi te yi nyɛ kpoma kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ma wunɛ ɓelem, wunɛ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka, ŋge kwa̧ jakɔsɔ, yo lɔr ho yo mbanjɔ Njambiyɛ te yi kelɛ nde, lɔr te wôkunaŋgwɛ ndi nɛ Njambiyɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wunɛ lɛ́pi sendi nde: ‹Ŋgɛ mumɔ kinja nɛ ɗinɔ mbɛy nyɛna sadaka nyɛ Njambiyɛ kɛ́, a yakama ɗiyɔ kinɛ tonjɛ yasi te yi nyɛ kpoma kɛ́ na. Yasi wɛtɛ, ŋgɛ nyɛ kinja sadaka te yi ɓo nja̧ kasɛ kɛ mbɛy nyɛna sadaka kɛ́, na tônjukwɛ yasi te yi nyɛ kpoma kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ma wunɛ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka, ŋge kwa̧ jakɔsɔ, yo sadaka te yi ɓo nje nɔ kɛ́, ho yo mbɛy nyɛna sadaka te yi kelɛ nde, sadaka te wôkunaŋgwɛ ndi nɛ Njambiyɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mɔ te ɛ kinja mbɛy nyɛna sadaka nyɛ Njambiyɛ, a kínjaŋgwɛ mbɛy nyɛna sadaka gbesɔ nɛ mɛyasi hɛnɛ te yi ɗiyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɔ te ɛ kinja mbanjɔ Njambiyɛ, a kínjaŋgwɛ mbanjɔ gbesɔ nɛ mɔ te ɛ ɗiyɛ kɛte kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sendi, mɔ te ɛ kinja ɗyoɓɔ, a kínjaŋgwɛ siya ɓekumande te yi Njambiyɛ gbesɔ nɛ mɔ te ɛ kɛ ɗiyɔ kɛte kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto kɛ gbɛla mɛmbunjɔ nde *maŋt nɛ̀ *anis nɛ̀ *kimɛ̧ wunɛ kɛ ɓu̧ yasi hɛnɛ kɛ njokate ɓakɛ kɛ mɛŋgaɓiyɛ kamɔ kamɔ, ɓu̧ kwalɔ ŋgaɓiyɛ te wɛtɛ wɛtɛ nyɛ Njambiyɛ. Wunɛ kɛ kpalɔ tikɔ kelna kpasa mɛyasi mɛte yi ɗiyɛ kɛ mɔy mɛmboŋga nda pɛsina lɛpi nɛ ŋgbeŋ nɛ̀ gwena ɓɛsɔ ŋgwɛtɛ nɛ̀ tikina temɔ kɛ yi Njambiyɛ. Ma yo yite yi wunɛ yâkaŋgwɛ kelɔ kinɛ tikɔ kelna ɓukwɛ mɛyasi mɛte yiri na. ");
INSERT INTO kkj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wunɛ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓe kɛndɛ nɛ ɓomɔ ɓaka, wunɛ kɛ sɛ mɛnjam soŋɛ gbɛla mɔnɔ ɗyɛŋgil kɛte kpalɔ nje tikɔ nyaŋgwɛ nyamɔ nde *samo kɛte mɛnɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto wunɛ wéya ndi kɔŋ pelɔ nɛ̀ kɔŋ pan, yasi wɛtɛ, mɔy te tondunate nɛ mɛyasi mɛ guɓɔ nɛ̀ ɓeya mɛyasi mɛte yi wunɛ nyɛ temɔ yun kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wɛ *Farisɛ̧ te mɔ ɗiɓina misi pâŋ pa weyɛ mɔy pelɔ nɛ̀ mɔy pan, nɛ́ kɔŋ te nje ɓɛ pupunate. ");
INSERT INTO kkj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto wunɛ nda mɛɓoŋsɔŋ mɛte yi ɓo si lɔmbɛ konɔ kɛte kɛ́. Kɛ puyɛ, kimɔ yaŋa ɗekɛ nɛ ŋgɛrɛ ŋgɛrɛ, ma mɔy te tondunate nɛ mɛyesɔ mɛ ɓemuŋ nɛ̀ kwalɔ yasi nyɛ̧ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wunɛ ndi sendi ɗete kɛ mbɔmbu ɓomɔ. Ɗekɛ ɔ ɓa nde, wunɛ nɛ ŋgbeŋ, ma kɛ mɔy mɛtemɔ mun likisi nɛ̀ yiŋa ɓeya mɛyasi mɛte yi mɛmboŋga ɓenɛ kɛ́ kɛte nɛ ŋgbɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Mɛbɔnɛ ta ɓalɔ kɛ to yun, wunɛ ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧, wunɛ ɓotu ɓe likisi! Kɛto wunɛ kɛ wɔmɔ mɛɓoŋsɔŋ mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, kɛrke mɛɓoŋsɔŋ mɛ ŋgbeŋ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma wunɛ kɛ kpalɔ nje lɛpɔ nde: ‹Hɛ má ɗiy kɛ ŋgimɔ te yi ɓesaŋgwɛ ɓusu ɓa̧ nɔ kɛte kɛ́, ma wusɛ tì gbesɛ ɓɔ sinɛ ɓo yí wo nɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ na.› ");
INSERT INTO kkj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɗete, wunɛ ɓesa ɓete kɛ pɛsɔ lɛpi yun nɛ ŋguru wun jayɛ nde, wunɛ ɓɔnɔ ɓe ɓotu ɓete ɓe woma ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ma ndana, nɛ kɛ̂n mbɔmbu yí tonjɛ ndi yasi te yi ɓesaŋgwɛ ɓun kandima kwey kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wunɛ ɓenyɔŋɛ, wunɛ mbo yeri! Wunɛ ta kelɔ nan yí kambɔ nɛ mɛbɔnɛ mɛte yi ɗitɛ te ɛ ti ɗím teɗye kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɗete, mi kɛ tomɔ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ nɛ̀ ɓotu ɓe ɗyanɔ nɛ̀ ɓotu ɓe kɛtina mɛyasi kɛnjɛ wunɛ. Wunɛ ta wo ɓaŋa, ŋgba ɓaŋa kɛ kroa, njurɔ ɓaŋa nɛ njambala kɛ mɛmbanjɔ mɛwesiɗya mun. Nɛ ta teɗye ɓo nyaŋgwɛ mɛbɔnɛ nɛ mɛɗya yí kɛ̀ nɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mɛyasi ta kwaŋna ɗete, nɛ́ mɛkiyɔ hɛnɛ te yi ɓotu ɓete ɓe tì kelɛ yiŋa ɓeya yasi yi nyanjama kɛ to mɛnɛti maka kɛ́ ɓal kɛ to yun, kandɛ kɛ mɛkiyɔ mɛ Abɛl te ŋgbeŋ mumɔ kumɔ kɛ mɛkiyɔ mɛ Sakari te mɔnɔ Baraki yi wunɛ woma kɛ njoka mbanjɔ Njambiyɛ nɛ mbɛy nyɛna sadaka nyɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɛyasi mɛte hɛnɛ ta ɓalɔ kɛ to ɓotu ɓe ŋgimɔ te yɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusalɛm, Yerusalɛm, wɛ ɛ ɗiki wo ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, lu̧ ɓotu ɓete ɓe Njambiyɛ tomɛ njesɛ kɛ yɔ ɓaka nɛ mɛtari wo, mi kwaɗya wesiɗye ɓɔnɔ ɓɔ nda yi gway kuɓɛ gukule nɛ ɓɔnɔ ɓenɛ kɛ nji̧ mɛpapɔ mɛnɛ kɛ́! Ko ɗete, nɛ tì kwaɗyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma ndana nɛ ta tika nɛ tu̧ ɗyun gboŋgote. ");
INSERT INTO kkj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yasi wɛtɛ, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ tí ɓɛŋɛ se mi na kumɔ komɛ wunɛ ta duwɛ lɛpɔ nde: ‹Mɛkombila nɛ yɔkɔ ɛ nje nɛ ɗinɔ Baba Mbokɔ kɔ!› » ");
INSERT INTO kkj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ pundɔ kɛ mbanjɔ Njambiyɛ kɛ́, ɛ ɓejekɛ ɓenɛ kɛ̀ kɛ kɛki nɛ lɛpɔ nde, a sêŋgila ndi mɛtu̧ mɛ mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yasi wɛtɛ, ɛ nyɛ yeŋsa nyɛ ɓo nde: «’Nduku wunɛ kɛ ɓɛŋɛ mɛyasi mɛnɔri hɛnɛ? Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Kinɛ tari wɛtɛ nɛ wɛtɛ ta ɗiyɔ waka kɛ to jakɔsɔ kinɛ nde, ɓo gbûŋgula ɓetɛ kɛ mɛnɛti na.» ");
INSERT INTO kkj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kɛ kɔŋte, ɛ nyɛ kwa̧ kɛ̀ ɗiyɔ mɛtiɗyɛ kɛ *Keki mɛoliviye. Ɛ ɓejekɛ ɓenɛ nje dolɔ nyɛ tandɛ yan diyɛ nyɛ nde: «Lɛpɔ nyɛ wusɛ, mɛyasi mɛte ta kwaŋna ndenɛn? Yo ŋge yi ta teɗye nde, njena yɔ nɛ̀ siyna mbokɔ te yɔkɔ ma wuta kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Wunɛ ɗîy nɛ sɔsɔ, ma mumɔ mɛ nje seɓile wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kɛto ɓuɗya ɓomɔ ta nje nɛ ɗinɔ ɗyembɛ lɛpɔ nde: ‹Mi *Krist, mi kɔ!› Ɓo ta seɓile ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɛ ta wokɔ ɓomɔ kɛ lɛpɔ kasi mɛɗyambi, wokɔ ŋgum ŋgum te. Wunɛ tî gwaki kaŋ yaŋa na, kɛto mɛyasi mɛte yâkaŋgwɛ kelna. Ndi nde, yite tì pa ɓɛ siyna mɛyasi na. ");
INSERT INTO kkj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kandɔ wɛtɛ ta tɛmɛ lu̧ ɗyambi nɛ wɛtɛ kandɔ. Kumande wɛtɛ má tɛmɛ lu̧ ɗyambi nɛ jakɔsɔ. Kolɔ ta kelna kɛ yiŋa mɛmbɛy, sendi mɛnɛti ta ŋgwaŋgwa kɛ yiŋa mɛmbɛy. ");
INSERT INTO kkj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mɛyasi mɛnɔri hɛnɛ ta ɓɛ ndi gbɛla toŋ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ɓo ta kaŋɛ wunɛ nyɛ ɓomɔ, ɓo má teɗye wunɛ ɓeya nyaŋgwɛ mɛbɔnɛ wo wunɛ. Mɛkandɔ hɛnɛ ta ɓenɔ wunɛ kɛto ɗinɔ ɗyembɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɗete, yo ta nje jatiɗye ɓuɗya ɓomɔ kɛnjɛ kɛ ɓeya nje. Ɓomɔ ta ɗyaŋgwina ɓenna tandɛ yan. ");
INSERT INTO kkj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɓuɗya ɓomɔ ta nje lɛpɔ ja̧ nde, ɓo ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ. Ɓo ta jatiɗye ɓuɗya ɓomɔ kɛ ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kelna ɓeya mɛyasi mɛte yi mɛmboŋga ɓenɛ kɛ́ ta ɗɔkɔ ɗɔkɔ kɛ̀ nɔ mbɔmbu. Ɗete, sulɔ ɓomɔ tí kwaɗya se ɓuɗyate kɛ̀ nɔ mbɔmbu nda yi ɓo kandima nɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma yɔkɔ ɛ ta gbisɔ kelɔ tiŋ kumɔ kɛ siynate kɔ ta ju̧. ");
INSERT INTO kkj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ɓo ta pelɛ Kimɔ Tom te yi lɛpɛ kasi *Kandɔ te yi kwey kɛ́ kɛ to mbokɔ hɛnɛ, nɛ́ mɛkandɔ hɛnɛ si woku. Kɛ kɔŋte, siyna mɛyasi má nje ɗya̧ yɛy. ");
INSERT INTO kkj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Yo nde, wunɛ ta ɓɛŋɛ mɔ te yi ɓo jeɓa nde *Nyaŋgwɛ mɔ ɓekiɗya mɛyasi ɛ kelɛ gbutu ɓiye nɛ mbanjɔ Njambiyɛ kɔ. Daniyɛl te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kasi nɛ. A ta nje ɗiyɔ kɛ mbɛy te yi nɛ kiyɔ kɛ́. Ma mɔ te ɛ tɔlɛ mɛlɛpi maka kɔ wôku to te ɗiyɔ nɛ sɔsɔ. ");
INSERT INTO kkj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yite nɛ̀ ɓotu ɓete ɓe ɗiyɛ kɛ mɛnɛti mɛ Yuda ɓaka sɛ̂ɗyikwɛ kambɔ kɛ̀ kɛ to mɛkeki. ");
INSERT INTO kkj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mɔ te ɛ ta ɓɛ kɛ tosiyɔ̧ kɔ pîkwɛ kinɛ pa nyiŋɛ tu̧ nde, na kɛ̀ ɓu̧ yaŋa pundɔ nɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sendi, mɔ te ɛ ta ɓɛ kɛ ŋgwaŋ kɔ tî yɔkwɛ nɛ kɔkɔ nde, na pa kɛ̀ ɓu̧ lambɔ nɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kɛ ŋgimɔ te yite, ɓoma ɓete ɓe ta ɓɛ nɛ mɔy nɛ̀ ɓaka ɓe ta ɓɛ ndi kɛ nyɛ ɓɔnɔsikɛ ɓɛri ɓaka ta saŋgwa nɛ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ nde, ŋgimɔ sokɔ te tî ɗyaŋ kɛ ŋgimɔ abekata ho kɛ wɛtɛ yesɔ *Saba na. ");
INSERT INTO kkj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kɛto kɛ ŋgimɔ te yite nyaŋgwɛ mɛbɔnɛ ta ɓɛŋna. Kandɛ yi Njambiyɛ ma kúsu nɛ mbokɔ kumɔ ndana yiŋa nyaŋgwɛ mɛbɔnɛ tì pa ɓɛŋna ɗete na. Sendi, yiŋa nyaŋgwɛ mɛbɔnɛ tí ɓɛŋna se ɗete wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti ɓɛki nde, Baba Mbokɔ kâya ɓuyɔ mɛtu mɛte tikɔ nɛ ŋgbet na, ma mumɔ wɛtɛ nɛ wɛtɛ tí ju̧ na. Yasi wɛtɛ, a ta kayɛ yo, kɛto ɓotu ɓete ɓe nyɛ sima si tɔkɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ma ŋgɛ mumɔ lɛpɛ nyɛ wunɛ nde: ‹Ha *Krist waka ho a wari!› wunɛ tî jaya na. ");
INSERT INTO kkj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kɛto ɓotu ɓete ɓe lɛpɛ ja̧ nde, ɓo Krist nɛ̀ ɓaka ɓe lɛpɛ sendi nde, ɓo ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓaka ta nje. Ɓo ta kelɔ nyaŋgwɛ mɛyekambiyɛ, kelɔ sendi nyaŋgwɛ mɛyasi, simande ɓo yakama jatiɗye ko ɓotu ɓete ɓe Njambiyɛ sima si tɔkɛ ɓaka kɛ yiŋa ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma mi ma lɛpɔ mɛyasi hɛnɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ma ŋgɛ ɓo lɛpɛ nyɛ wunɛ nde: ‹Ha *Krist kaka kɛ koŋgor!› wunɛ tî kɛn na. Ho nde: ‹A kɛ mɛsɔma kɛ toŋgari womaŋa!› wunɛ tî jaya na. ");
INSERT INTO kkj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yo nde, njena *Mɔnɔ mumɔ ta ɓɛ nda yi yɛsi mbiyɔ yɛsɛ nɔ nɛ vɛrum, panɔ kandɛ komɛ yesɔ pundɛ kumɔ komɛ yesɔ ɓalɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma kɛ mbɛy hɛnɛ te yi muŋ yasi ɗiyɛ kɛte, ɓedaɓo wésiɗyaŋgwɛ womɛte. ");
INSERT INTO kkj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ŋgɛ mɛtu mɛ nyaŋgwɛ mɛbɔnɛ mɛnɔri siyɛ ndi ɗekɛ kɛ́, yesɔ ta ɗimɔ, ŋgwɛndɛ tí panɔ se na, ɓesisɔ̧ ta kɛtiyɛ kɛ kwey ɓalɔ kɛ mɛnɛti. Mɛyasi mɛte yi nɛ ŋguŋguɗyɛ yi ɗiyɛ kɛ kwey kɛ́ ta ŋgbɔkisa ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kɛ kɔŋte, yasi te yi teɗye nde, *Mɔnɔ mumɔ yima kɛ́ ta pundɔ kɛ ɗyoɓɔ, mɛkandɔ mɛ ɓomɔ hɛnɛ kɛ to mɛnɛti ta jaɓa. Ɓo ta ɓɛŋɛ Mɔnɔ mumɔ kɛ nje kɛ to mɛkulutu kɛ kwey nɛ nyaŋgwɛ ŋguŋguɗyɛ nɛ̀ nyaŋgwɛ mɛluksa. ");
INSERT INTO kkj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A ta tomɔ ɓejaki ɓenɛ nɛ nyaŋgwɛ mɛdɔmbiya kɛnjɛ kɛ mɛmbɛy hɛnɛ kɛ̀ wesiɗye ɓotu ɓete ɓe nyɛ sima tɔkɛ ɓaka kɛ mɛɓoku mɛ mɛnɛti maka yini kɛ mbokɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Wunɛ ɓôŋ ɗyanɔ kɛ yasi te yi *figiye teɗye kɛ́. Kɛ ŋgimɔ te yi mɛɓɔ mɛte mɛ kɛ ɓɔyɛ nɛ̀ kɛ ŋgimɔ te yi mɛmbɔru mɛte mɛ kɛ lo, wunɛ kɛ duwɛ nde, ŋgimɔ mbiyɔ ma wuta. ");
INSERT INTO kkj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɗete sendi, komɛ wunɛ ta ɓɛŋɛ nde, mɛyasi mɛnɔri hɛnɛ mɛ kɛ ɗya̧, wunɛ dûkwɛ nde, *Mɔnɔ mumɔ mɛ nɛdɔ te yi nje, yasi mɛ kɛ ŋgiŋ nyinɔ. ");
INSERT INTO kkj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ko ɓotu ɓete ɓe nɛ joŋ kɛ ŋgimɔ te yɔkɔ ɓaka tí gwe hɛnɛ kinɛ nde, mɛyasi mɛnɔri ɗyâŋ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ɗyoɓɔ nɛ̀ mɛnɛti ta si kwa̧ yambile, ma ndi mɛlɛpi mɛmbɛ tí yambile ko wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ma kɛ kasi yesɔ nɛ̀ hawa te yi mɛyasi mɛte ta ɗya̧ kɛte kɛ́, ko mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ na, ko ɓejaki ɓete ɓe ɗiyɛ kɛ ɗyoɓɔ ko *Mɔnɔ, ndi Da nyɛpɔ duwɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yasi te yi kwaŋnama kɛ ŋgimɔ Nɔy kɛ́ ta kwaŋna sendi ɗete kɛ ŋgimɔ te yi Mɔnɔ mumɔ ta nje kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kɛ mɛtu mɛte yi mbeŋ tì pa ɗya̧ na, ɓomɔ ɗikima ɗyena, ɗye mɛnjam, kelɔ mɛgwaki, kɛnjɛ ɓeŋgɔndu ɓan kɛ mɛgwaki kumɔ kɛ yesɔ te yi Nɔy nyiŋma nɔ kɛ mɔy nyaŋgwɛ kuka kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓomɔ tì ɓɛ kɛ takɛ yaŋa na kumɔ nde, nyaŋgwɛ mbeŋ ɗyaŋma si mɛmiyɛ ɓo hɛnɛ. Yo ta kwaŋna sendi ɗete kɛ ŋgimɔ te yi Mɔnɔ mumɔ ta nje kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma kɛ njoka ɓembam yiɓa ɓe ta ɓɛ kɛ kelɔ mɛsay kɛ ŋgwaŋ, a ta ɓu̧ wɛtɛ, tikɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kɛ njoka ɓoma yiɓa ɓe ta ŋgbɔ kɔkɔ yasi kɛ tari, a ta ɓu̧ wɛtɛ, tikɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ɗete, wunɛ pɛ̂m yasi, kɛto wunɛ yeti kɛ duwɛ ŋgimɔ te yi Nyaŋgwɛ Kumande wun ta nje kɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wunɛ dûkwɛ gba nde: Sa tu̧ má dukwɛ ŋgimɔ te yi mɔ guɓɔ nje nɔ nɛ tu kɛ́, ma nyɛ kɛ pɛmɔ yasi, kambɔ mɔ guɓɔ mɛ nje lekɛ tu̧ nyiŋɛ guɓɔ mɛyasi. ");
INSERT INTO kkj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɗete wunɛ sendi, wunɛ kômsaŋgwɛ, kɛto Mɔnɔ mumɔ ta nje kɛ ŋgimɔ te yi wunɛ tì ɓɛ kɛ takɛ nde, a ta nje kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Yo mɔ mɛsay te yɛn yi ɓo yakama ɓɛ nɛ ɓiɓina temɔ nɛ nyɛ? Yo yɔkɔ ɛ nɛ sɔsɔ yi masa wenɛ tɛmbiɗya nyɛ nde, a ɗîy nɛ ɓotu ɓe mɛsay ɓenɛ yí nyɛ ɓo mɛɗye yaka nɛ ŋgimɔ te yi nyɛ pɛsima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mɔ mɛsay kɔ nɛ mɛsosa, ŋgɛ masa wenɛ yɔkwɛ dolɔ nyɛ kɛ kelɔ ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: A ta nje tɛmbiɗye nyɛ, na ɗiy nɛ mɛyasi mɛnɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yasi wɛtɛ, ŋgɛ mɔ mɛsay kɔ ɓɛ ɓeya mɔ mɛsay, a ta lɛpɔ kɛ mɔy temɔ nɛ nde: ‹Masa wombɛ tí yɔkwɛ ndana nɛdɔ na.› ");
INSERT INTO kkj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ɔ ɓɛ́ŋa, ŋgɛ nyɛ nyɛ ɓɔ kɛ mɛndina ɓɛsɔ ɓotu ɓe mɛsay, ɗiyɔ ndi mɛɗye nɛ̀ hɔɓiya mɛnjam ɓenɛ ɓotu ɓe gwena mɛnjam, ");
INSERT INTO kkj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","yite wɛtɛ yesɔ masa wenɛ ta duwɛ ɗya̧ kɛ yesɔ te yi nyɛ tì ɓɛ kɛ takɛ nde, a ta ɗya̧ kɛte na, kɛ hawa te yi nyɛ tí duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A ta teɗye nyɛ nyaŋgwɛ mɛbɔnɛ tikɔ kɛ nje sɔŋ kelɔ nɛ nyɛ nda yi ɓo kelɛ nɛ ɓotu ɓe likisi kɛ́. Yo womɛte komɛ nyɛ ta lelɔ nyambɔ mɛsu̧.» ");
INSERT INTO kkj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ma komɛ *Kandɔ te yi kwey ta nje kɛ́, mɛyasi ta kwaŋna nda yi yo kwaŋnama nɔ kɛ kanɔ ɓaŋa ɓeŋgɔndu kamɔ ɓe ɓoŋma mɛlambo man yí kɛ̀ saŋgwa nɛ mbam gwaki. ");
INSERT INTO kkj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kɛ njoka yan, yitan tì ɓɛ nɛ ɗyanɔ na, ma ɓari ɓetan ɓa̧ nɛ ɗyanɔ. ");
INSERT INTO kkj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓaka ɓe tì ɓɛ nɛ ɗyanɔ ɓaka ɓoŋma mɛlambo man kinɛ ɓiye yiŋa karasin kwa̧ nɔ na. ");
INSERT INTO kkj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma ɓaka ɓe ɓa̧ nɛ ɗyanɔ ɓaka ɓoŋma mɛlambo man tɛlɔ sendi yiŋa karasin kɛ mɛndaki ɓiye kwa̧ nɔ. ");
INSERT INTO kkj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mbam gwaki linjama kinɛ nje nɛdɔ na, ɗete ɛ ɓo hɛnɛ si dɔŋgbɔ kwa̧ nɛ jakɔ. ");
INSERT INTO kkj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nɛ ɓembe tu ɓo wóku kembi: ‹Wunɛ tɛ̂ma dɔ, mbam gwaki ɗyaŋma. Nɛ pûndu kɛ̀ saŋgwa nɛ nyɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ndana, ɛ ɓo hɛnɛ jemiyɛ tɛmɛ kombile mɛlambo man. ");
INSERT INTO kkj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ɓaka ɓe tì ɓɛ nɛ ɗyanɔ ɓaka nja̧ lɛpɔ nyɛ ɓari nde: ‹Nɛ nyɛ̂ki wusɛ yiŋa mɔnɔ karasin yun, kɛto mɛlambo musu kɛ si ɗimɔ.› ");
INSERT INTO kkj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ɛ ɓari ɓe ɓa̧ nɛ ɗyanɔ ɓaka yeŋsa nde: ‹Ko na, yite tí yaka wusɛ sinɛ wunɛ hɛnɛ na. Wunɛ kpâl kɛ̀ kɛ mbɛy ɗyaŋgwate kɛ̀ ɓɔmɔ yun mate.› ");
INSERT INTO kkj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Piŋɔ te yi ɓo ɓa̧ kɛ kɛ̀ kɛ ɓɔmnate kɛ́, ɛ mbam gwaki ɗya̧. Ɓari ɓe komsama ɓaka nyiŋma ɓenɛ ɓe mbam gwaki kɛ tu̧ jesɔ gwaki, ɛ ɓo ɗiɓɛ numɛy nɛ kpikip. ");
INSERT INTO kkj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɗiyɔ te kɛ kɔŋte kɛ́, ɛ ɓeŋgɔndu te ɓari nje ɗya̧ yɛy kembiɗya lɛpɔ nde: ‹Nyaŋgwɛ mbam, nyaŋgwɛ mbam, ɓuta numɛy nyɛ wusɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ɛ mbam nje ɗiyɔ yeŋsa nyɛ ɓo nde: ‹Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mi yeti kɛ duwɛ wunɛ na.› ");
INSERT INTO kkj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ɗete, wunɛ pɛ̂m yasi, kɛto wunɛ yeti kɛ duwɛ yesɔ ko hawa te yi *Mɔnɔ mumɔ ta ɗya̧ kɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Komɛ *Kandɔ te yi kwey ta nje kɛ́, mɛyasi ta kwaŋna nda yi yo kwaŋnama kɛ kasi wɛtɛ mbam te ɛ kwaɗya kɛ̀ lɔndunate kɛ wɛtɛ mɛnɛti kɔ. Kɛ ŋgimɔ kwaŋge ɛ nyɛ jeɓa ɓotu ɓe mɛsay ɓenɛ kaŋɛ kusuku nɛ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A kaŋma miliyɔŋ yitan nyɛ bosa mumɔ, kaŋɛ miliyɔŋ yiɓa nyɛ mɔ yiɓa, nje kaŋɛ miliyɔŋ wɛtɛ nyɛ mɔ yitati. A nya mumɔ hɛnɛ ɓeŋgwɛ ɗeti nɛ. Kɛ kɔŋte, ɛ nyɛ tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ndana ndana, mɔ te ɛ ɓoŋma miliyɔŋ yitan kɔ kwaŋma si kɛ̀ ɗɔkwɛ yo, kweɗya sendi miliyɔŋ yitan dokiɗye kɛ to te yiri. ");
INSERT INTO kkj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mɔ yiɓa ɛ ɓoŋma miliyɔŋ yiɓa kɔ kelma ndi sendi ɗete. A dolma miliyɔŋ yiɓa dokiɗye kɛ to te yiri. ");
INSERT INTO kkj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma mɔ te ɛ ɓoŋma ndi miliyɔŋ wɛtɛ kɔ kwaŋma kɛ̀ ɗokile mɛnɛti sɔɗyɛ mɔni masa wenɛ kɛte. ");
INSERT INTO kkj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yo kwaŋma ɓuɗya mɛtu ɛ masa wan nje yɔkwɛ. A jeɓama ɓo, nɛ́ ɓo lɛpi yasi te yi ɓo kelma nɛ mɔni te kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mɔ te yi masa wenɛ nya nyɛ miliyɔŋ yitan kɔ nja̧ nɛ miliyɔŋ yitan te yi nyɛ kweɗyama dokiɗye kɛ to te yiri kɛ́. Ɛ nyɛ lɛpɛ nde: ‹Nyaŋgwɛ mbam, wɛ nya mi miliyɔŋ yitan, ɓɛŋa, miliyɔŋ yitan yi mi kweɗyama dokiɗye kɛ to te kɛ́!› ");
INSERT INTO kkj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ɛ masa wenɛ lɛpɛ nyɛ nyɛ nde: ‹Kimɔ yaŋa! Wɛ mɔ mɛsay te yi ɓo yakama ɓɛ nɛ ɓiɓina temɔ nɛ nyɛ, wɛ nɛ duwɛ ɓakiɗya yasi. Wɛ duwa̧ ɓakiɗye yasi te yi nɛ mbɛt, ɗete mi ta nyɛ wɛ ɓuɗya mɛyasi nde, ɗiyɔ nɔ. Mi masa wɔ, inja kɛ ɗiyɔ kɛ mɔy mɛsosa sinɛ wɛ!› ");
INSERT INTO kkj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mɔ te yi masa wenɛ nya nyɛ miliyɔŋ yiɓa kɔ nja̧ sendi lɛpɔ nde: ‹Nyaŋgwɛ mbam, wɛ nya mi miliyɔŋ yiɓa, ɓɛŋa, miliyɔŋ yiɓa yi mi kweɗyama dokiɗye kɛ to te kɛ́!› ");
INSERT INTO kkj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ɛ masa wenɛ lɛpɛ nyɛ nyɛ nde: ‹Kimɔ yaŋa! Wɛ mɔ mɛsay te yi ɓo yakama ɓɛ nɛ ɓiɓina temɔ nɛ nyɛ. Wɛ duwa̧ ɓakiɗye yasi te yi nɛ mbɛt, ɗete mi ta nyɛ wɛ ɓuɗya mɛyasi nde, ɗiyɔ nɔ. Mi masa wɔ, inja ɗiyɔ kɛ mɔy mɛsosa sinɛ wɛ!› ");
INSERT INTO kkj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ndana yɛy, ɛ mɔ te yi masa wenɛ nya ndi nyɛ miliyɔŋ wɛtɛ kɔ ɗya̧ nje sendi. Ɛ nyɛ lɛpɛ nde: ‹Nyaŋgwɛ mbam, mi duwa̧ nde, wɛ nɛ nyanɔ ɓuɗyate. Wɛ ndɛ́m mɛɗye kinɛ mbɛki te yi wɛ paŋma ɓɛ na. Wɛ wésiɗya mɛɗye kinɛ kwalɔ te yi wɛ nyanja kɛ mɛnɛti na. ");
INSERT INTO kkj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mi gwa̧ wɔ̧, ɛ mi ɓu̧ miliyɔŋ wɔ kɛ̀ sɔɗyɛ kɛ mɔy mɛnɛti. Ma ɓɛŋa mɔni yɔ kɛ, ɓoŋgɔ yo!› ");
INSERT INTO kkj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ɛ masa wenɛ yeŋsa nyɛ nyɛ nde: ‹Wɛ ɓeya mɔ mɛsay, wɛ mɔ ɗyɛm! Wɛ duwa̧ nde, mi ndɛ́m mɛɗye kinɛ mbɛki te yi mi paŋma ɓɛ na. Mi wésiɗya mɛɗye kinɛ kwalɔ te yi mi nyanja na. ");
INSERT INTO kkj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ɗete, ma wɛ ɓoŋma mɔni mbɛ kɛ̀ tikɔ kɛ yi ɓotu ɓe ɓakiɗya mɔni, ma mi ta kɛ̀ ɓu̧ mɔni mbɛ kɛ yɔkwe nɛ liɓa kɛ to te. ");
INSERT INTO kkj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ma wunɛ sûku miliyɔŋ te ɛ kɛ ɓɔ nɛ kɔ kaŋɛ nyɛ mɔ te ɛ nɛ miliyɔŋ kamɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yo nde, ɓo ta dokiɗye yasi nyɛ mɔ te ɛ mɛ nɔ kɔ, a má nje ɓɛ kɛ nyɛŋgwɛ. Yasi wɛtɛ, pɛ yɔkɔ ɛ kinɛ yaŋa kɔ, ɓo ta sukɔ ko mɔnɔ yasi te yi nyɛ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma pɛ yi ɓeya mɔ mɛsay kɔ ɛ ɗimbiɗye ŋgimɔ nɛ gbɛlate kɔ, wunɛ ɓîya nyɛ ɓetɛ kɛ sɛ̧ kɛ yitil. Yo womɛte komɛ nyɛ ta lelɔ nyambɔ mɛsu̧.› » ");
INSERT INTO kkj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Komɛ *Mɔnɔ mumɔ ta nje kɛ mɔy mɛluksa mɛnɛ ɓenɛ ɓejaki ɓenɛ hɛnɛ kɛ́, a ta kwa̧ ɗiyɔ mɛtiɗyɛ kɛ siya ɓekumande nɛ̀ kɛ ɗiyɔ mɛluksa mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mɛkandɔ mɛ ɓotu ɓe mɛnɛti maka hɛnɛ ta nje wesiɗya kɛ mbɔmbu wenɛ. A ta ɓakɛ ɓo nda yi mɔ ɓakiɗya ɓetitɛr ɓakɛ njoka ɓesam nɛ̀ ɓegbataɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A ta ɓu̧ ɓesam kɛnjɛ pulɔ mbam ɓɔ nɛ, ɓu̧ ɓegbataɓɔ kɛnjɛ pulɔ gare. ");
INSERT INTO kkj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ndana, nyɛ Kumande má nje lɛpɔ nyɛ ɓotu ɓete ɓe ta ɓɛ kɛ mbam ɓɔ nɛ ɓaka nde: ‹Nɛ njâki, wunɛ ɓotu ɓete ɓe Saŋmbɛ nya wunɛ mɛkombila ɓaka. Wunɛ njâki nje namɔ *Kandɔ te yi nyɛ sima kombile tikɛ wunɛ piŋɔ te yi mbokɔ tì pa kusuna na. ");
INSERT INTO kkj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kɛto mi gwa̧ nja, ɛ wunɛ nyɛ mi mɛɗye. Mi gwa̧ yɛsiɗyɛ, ɛ wunɛ nyɛ mi mɔrɔku nde, mi hɔ̂ɓiya. Mi ɓa̧ jɛŋgwɛ, ɛ wunɛ ɓu̧ mi kimɔte. ");
INSERT INTO kkj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi ɓa̧ sɔkɛrɛ, ɛ wunɛ lɛnje mi lambɔ. Mi ɓa̧ kɛ kɔnɔ, ɛ wunɛ nje ɓɛŋɛ mi. Mi ɓa̧ kɛ jɔɓɔ, ɛ wunɛ nje lɛpiɗye mi.› ");
INSERT INTO kkj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ma ndana, ɓotu ɓete ɓe Njambiyɛ pɛsima nde, ɓo mɛ nɛ ŋgbeŋ kɛ mbɔmbu wenɛ ɓaka má nje diyɛ nyɛ nde: ‹Nyaŋgwɛ Kumande, wusɛ ɓɛ́ŋa ɓa wɛ we kɛ gwe nja, ɛ wusɛ nyɛ wɛ mɛɗye? Hɛ ɓɛ́ŋa wɛ we kɛ gwe yɛsiɗyɛ, ɛ wusɛ nyɛ wɛ mɔrɔku nde, hɔɓiya? ");
INSERT INTO kkj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wusɛ ɓɛ́ŋa wɛ we nda jɛŋgwɛ, ɛ wusɛ ɓu̧ wɛ kimɔte? Ho nde sɔkɛrɛ, ɛ wusɛ lɛnje wɛ lambɔ? ");
INSERT INTO kkj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wusɛ ɓɛ́ŋa wɛ we kɛ kɔnɔ ho nde kɛ jɔɓɔ, ɛ wusɛ kɛ̀ lɛpiɗye wɛ?› ");
INSERT INTO kkj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kumande má nje yeŋsa nyɛ ɓo nde: ‹Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɛŋgimɔ hɛnɛ te yi wunɛ kelma yiŋa kimɔ yasi ɗete nɛ wɛtɛ mumɔ kɛ njoka ɓemaŋ ɓembɛ ɓaka, ko nde, ɓo ɓɛ̂ki ɓeŋgbanda, wunɛ kél yo nɛ mi.› ");
INSERT INTO kkj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kɛ kɔŋte, a má nje lɛpɔ nyɛ ɓotu ɓete ɓe kɛ pulɔ gare nɛ ɓaka nde: ‹Wunɛ jîsa lɔndɔ kɛ kɛki mbɛ, wunɛ ɓotu ɓete ɓe Njambiyɛ sima kita nɛ wunɛ ɓaka. Wunɛ kɛ̂n kɛ ɗitɛ te yi ju̧ kpo nɛ kpo. Njambiyɛ kombila yo yi *Kum ɓeya mɛkele ɓenɛ ɓejaki ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yo kɛto mi gwa̧ nja, wunɛ kinɛ nyɛ mi mɛɗye na. Mi gwa̧ yɛsiɗyɛ, wunɛ tì nyɛ mi mɔrɔku nde, mi hɔ̂ɓiya na. ");
INSERT INTO kkj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi ɓa̧ jɛŋgwɛ, wunɛ kinɛ ɓu̧ mi kimɔte na. Mi ɓa̧ sɔkɛrɛ, wunɛ tì lɛnje mi lambɔ na. Mi ɓa̧ kɛ kɔnɔ, ɓɛ kɛ jɔɓɔ, wunɛ tì nje ɓɛŋɛ mi na.› ");
INSERT INTO kkj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ma ɓo sendi, ɓo ta diyɛ nde: ‹Nyaŋgwɛ Kumande, wusɛ ɓɛ́ŋa ɓa wɛ we kɛ gwe nja, kɛ gwe yɛsiɗyɛ ho jɛŋgwɛ ho sɔkɛrɛ ho kɛ kɔnɔ ho kɛ jɔɓɔ, ɛ wusɛ ɗiyɛ kinɛ kamɛ wɛ?› ");
INSERT INTO kkj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ndana, a má nje yeŋsa nyɛ ɓo nde: ‹Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɛŋgimɔ hɛnɛ te yi wunɛ ɗiyma kinɛ kelɔ kimɔ yasi ɗete nɛ wɛtɛ mumɔ kɛ njoka ɓemaŋ ɓembɛ ɓaka, ko nde, ɓo ɓɛ̂ki ɓeŋgbanda, yo mi yi wunɛ ɗiyma kinɛ kelɔ yo.› ");
INSERT INTO kkj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɗete, ɓeya ɓotu ɓaka ta kɛ̀ saŋgwa nɛ mɛbɔnɛ kpo nɛ kpo. Ma ɓotu ɓete ɓe nɛ ŋgbeŋ ɓaka ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo.» ");
INSERT INTO kkj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kɛ kɔŋte, kɛ Yesus ma si lɛpɔ teɗye mɛyasi mɛnɔri hɛnɛ ɗete kɛ́, ɛ nyɛ nje lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Wunɛ duwa̧ nde, ɓukwa̧ ndi mɛtu yiɓa, nɛ́ jesɔ *Paska Ɓeyudɛn kelna. Ɓo ta ɓiye *Mɔnɔ mumɔ kaŋɛ nyɛ ɓomɔ, nɛ́ ɓo ŋgba nyɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ndana, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya wesiɗya kɛ mbanjɔ Kayif te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓo pɛsima nda yi ɓo yâkaŋgwɛ ɓiye nɛ Yesus nɛ nje likisi yí wo nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yasi wɛtɛ, ɓo lɛpima nde: «Yo tî kelnaŋgwɛ kɛ ɓembe jesɔ na, kambɔ ɓomɔ mɛ nje kelɔ mɛyasi nɛ hoya hoya.» ");
INSERT INTO kkj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus ɓa̧ kɛ Betani kɛ tu̧ wɛtɛ mbam nde Simɔn, a ɓa̧ kɛ kɔnɔ nɛ ndoko. ");
INSERT INTO kkj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ɗiyɔ kɛ́, ɛ wɛtɛ nyari nje kɛ kɛki Yesus nɛ wɛtɛ ndaki tondunate nɛ yiŋa lɔbinda te yi ɗye ɓuɗya mɔni. Ɓo sama ndaki te nɛ yiŋa tari nde albatɛrɛ. Piŋɔ te yi Yesus ɓa̧ kɛ ɗyena kɛ́, ɛ nya kɔ nje kumbɛ yo kɛ to nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kɛ ɓejekɛ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo wokɛ ŋgambi lɛpɔ nde: «To ɓekiɗya lɔbinda te yikɛ ɓa nɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma ɓo ɗyaŋgwa lɔbinda kɛ yi yaka ɓuɗya mɔni ɓu̧ yo kamɛ nɛ ɓotu ɓe ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus wokuma yasi te yi ɓo ɓa̧ kɛ nyiŋgila kɛ́. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ njáŋgwɛ nya kɔ kɛto ŋge? A kelma kimɔ yasi nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nɛ ɓɛ̂ŋa, mɛtu hɛnɛ wúnɛ ɓotu ɓe ŋgwɛtɛ kɛ ɗiyɔ kɛ kiya mbɛy, ma kɛ ɓɛ mi, mi tí ɗiyɔ mbɛ sinɛ wunɛ kɛ kiya mbɛy mɛtu hɛnɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A kumbuma mutɔ kɛ yotu mbɛ ndana. A kelma ɗete yí laɗye nɛ pumbuna mbɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mbɛy hɛnɛ te yi ɓo ta pɛlɛ Kimɔ Tom kɛ to mɛnɛti hɛnɛ, ɓo ta yekiɗye sendi yasi te yi nya kɔ kelma kɛ́, nɛ́ ɓomɔ taki nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndana kɛ́, ɛ Yudas te Iskariyot, nyɛ ɛ ɓa̧ kɛ njoka ɓejekɛ kamɔ jɔ yiɓa kɔ kwa̧ kɛ̀ kɛ yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ");
INSERT INTO kkj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","lɛpɔ nyɛ ɓo nde: «Nɛ ta nyɛ mi ŋge, nɛ́ mi ɗyaŋgwɛ Yesus nyɛ wunɛ?» Ɛ ɓo kaŋɛ sule kamɔtati nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndana, ɛ nyɛ kandɛ saŋna kimɔ ŋgimɔ te yi nyɛ yakama ɗyaŋgwɛ nɛ Yesus nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bosa yesɔ jesɔ ɗyena mɛmampa mɛte yi kinɛ ŋga̧ kɛte kɛ́ ɗyaŋma. Ɛ ɓejekɛ ɓe Yesus nje diyɛ nyɛ nde: «Wɛ kwáɗyikwɛ nde, wusɛ kɛ̂n kombile mbɛy ɗyena jesɔ *Paska te yɔ we?» ");
INSERT INTO kkj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɛ nyɛ yeŋsa nde: «Wunɛ kɛ̂n kɛ mɔy ɗya kɛ yi mumɔ nde kaɗyɛ, nɛ́ wunɛ lɛpi nyɛ nyɛ nde: ‹Yekele nde: Ŋgimɔ mbɛ ma ɗya̧. Mi ta kwaŋɗye *Paska sinɛ ɓejekɛ ɓembɛ kɛ yasi yɔ.› » ");
INSERT INTO kkj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ɓejekɛ kelma nda yi Yesus lɛpima nyɛ ɓo kɛ́. Ɛ ɓo kombile mɛɗye mɛ *Paska. ");
INSERT INTO kkj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kɛ ɓekoko ma ɗya̧ kɛ́, ɛ Yesus kwa̧ ɗiyɔ ɓenɛ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa yí ɗyena. ");
INSERT INTO kkj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Piŋɔ te yi ɓo ɓa̧ kɛ ɗyena kɛ́, ɛ nyɛ lɛpɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mbaŋa mumɔ kɛ njoka yun ta ɗyaŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yo nya ɓo ŋgambi ɓuɗyate kɛ temɔ. Ɛ mumɔ hɛnɛ diyɛ nyɛ wɛtɛ wɛtɛ nde: «Nyaŋgwɛ Kumande, yo ka mi?» ");
INSERT INTO kkj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ɛ Yesus yeŋsa nde: «Mɔ te yi sinɛ nyɛ ɓetima ɓɔ kɛ kiya katɔ mɛɗye wɛtɛ kɔ, yo nyɛ ta ɗyaŋgwɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","*Mɔnɔ mumɔ ta kwa̧ gbate nda yi yo kɛtinate kɛ kasi nɛ kɛ mɛkana mɛ Njambiyɛ kɛ́. Ndi nde, mɛbɔnɛ ta ɓalɔ kɛ to mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ. Ɓo má ɗiy kinɛ ja mɔ te, ma yo gba kimɔte ɓuɗyate kɛ yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas mɔ te ɛ kaŋma nyɛ nyɛ ɓomɔ kɔ nja̧ ɓu̧ sendi lɛpi diyɛ nyɛ nde: «Yekele, yo ka mi?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo gba wɛ!» ");
INSERT INTO kkj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Piŋɔ te yi ɓo ɓa̧ kɛ ɗyena kɛ́, ɛ Yesus ɓu̧ mampa. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ lekɛ yo kaŋɛ nyɛ ɓejekɛ ɓenɛ lɛpɔ nde: «Wunɛ ɓôŋ, nɛ ɗyâki, yikɛ mɛmbundɔ mɛmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kɛ kɔŋte, ɛ nyɛ ɓu̧ pelɔ nɛ tena mɛnjam kɛ mɔyte. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ kaŋɛ yo nyɛ ɓo lɛpɔ nde: «Wunɛ hɛnɛ hɔ̂ɓiya yo. ");
INSERT INTO kkj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kɛto yikɛ mɛkiyɔ mɛmbɛ, yo mɛkiyɔ mɛte yi kelɛ mbon. Mɛkiyɔ mɛte yi nyanjama kɛto ɓuɗya ɓomɔ. Yo ta kelɔ nde, Njambiyɛ tîki ɓomɔ nɛ ŋgwɛtɛ kɛ mɛɓeyɔ man. ");
INSERT INTO kkj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Ko mi tí hɔɓiye se tena mɛnjam maka na kumɔ kɛ ŋgimɔ te yi mi ta hɔɓiye nɛ wɛtɛ jɔnjate sinɛ wunɛ kɛ *Kandɔ Saŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kɛ ɓo ma si jembina yí lukse nɛ Njambiyɛ kɛ́, ɛ ɓo kwa̧ kɛ̀ kɛ *Keki mɛoliviye. ");
INSERT INTO kkj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ndana, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Yasi te yi mi ta saŋgwa nɔ kɛ tu te yɔkɔ muka kɛ́ ta njaŋgwɛ wunɛ hɛnɛ kɛ tikina temɔ te yi wunɛ tikɛ kɛ yembɛ kɛ́ jatiɗye wunɛ kɛ ɓeya nje. Kɛto yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Mi ta mukɔ mɔ ɓakiɗya ɓesam, ɓesam má si wanja.› ");
INSERT INTO kkj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndi nde, komɛ mi ta womiyɛ kɛ́, mi ta kandɛ kumɔ Galile nɛ wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ɛ Piyɛr ɓu̧ lɛpi lɛpɔ nde: «Ŋgɛ ɓɛ nde, kɛ yi ɓomɔ hɛnɛ, yasi te yi wɛ ta saŋgwa nɔ kɛ́ ta njaŋgwɛ ɓo ɗete kɛ tikina temɔ te yi ɓo tikɛ kɛ yɔ kɛ́ jatiɗye ɓo kɛ ɓeya nje, ma pɛlɛ yembɛ, ko yo tí ɓɛŋna ɗete wɛtɛ yesɔ na.» ");
INSERT INTO kkj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Kɛ gba tu te yɔkɔ muka piŋɔ te yi mbam kuɓɛ tì pa kɔkɔ, wɛ ta tonɔ kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na.» ");
INSERT INTO kkj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ɛ Piyɛr yeŋsa nyɛ nyɛ nde: «Ko nde, sɔŋ te ɓîya mi sinɛ wɛ, ko mi tí tonɔ nɛ mbɛt nde, mi yeti kɛ duwɛ wɛ na.» Ɓejekɛ hɛnɛ lɛpima ndi sendi ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kɛ kɔŋte, ɛ Yesus kwa̧ ɓenɛ ɓejekɛ ɓenɛ kɛ̀ kɛ wɛtɛ mbɛy nde Gɛtsemane. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ ɗîy mɛtiɗyɛ waka kumɔ kɛ ŋgimɔ te yi mi ta pa kɛ̀ kaka si kɛ̀ ŋgwɛta nɛ Njambiyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɛ nyɛ ɓu̧ Piyɛr nɛ̀ ɓɔnɔ ɓe Seɓede yiɓa kwa̧ nɔ. Ɛ ŋgambi kandɛ nyiŋna nɛ kɛ temɔ, temɔ nɛ ɓa̧ nɛ haɓuɓu. ");
INSERT INTO kkj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Temɔ mbɛ nɛ ŋgambi nda mi ta gwe. Wunɛ ɗîy waka, wunɛ ɗîy mɛjemsiɗyɛ sinɛ wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɛ nyɛ nje kwa̧ kɛ̀ mbɔmbu nɛ mbɛt, ɛ nyɛ ɓalɛ kɛ mɛnɛti kɔtɔ mbɔmbu ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: «Saŋmbɛ, ŋgɛ yo yaka, kelɔ nde, nyaŋgwɛ mapi mɛbɔnɛ mɛte yikɛ ɗûkwɛ kɛ to mbɛ. Ma yo tî kelnaŋgwɛ nda yi mi kwaɗyɛ kɛ́ na, yo kêlnaŋgwɛ nda yi wɛ kwaɗyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ɛ nyɛ kɛ̀ yɔkwɛ nje komɛ ɓejekɛ ɓa̧ kɛ́ dolɔ ɓo kɛ jakɔ. Ɛ nyɛ lɛpɛ nyɛ Piyɛr nde: «Ko gbɛla hawa wɛtɛ, wunɛ tì wɛliyɛ ɗiyɔ mɛjemsiɗyɛ sinɛ wunɛ na. ");
INSERT INTO kkj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wunɛ ɗîy mɛjemsiɗyɛ, nɛ̀ wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ, ma mɛɓoɓilan nje laŋsa wunɛ. Temɔ nɛ yɛsiɗyɛ kelna kimɔ yasi, ko ɗete, mɛmbundɔ nɛ tɛkɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kɛ mɛŋga yiɓate, ɛ nyɛ jisɛ kwa̧ kɛ̀ nɛ naŋ ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: «Saŋmbɛ, ŋgɛ ti yaka nde, nyaŋgwɛ mapi mɛbɔnɛ mɛte ɗûkwɛ kɛ to mbɛ kinɛ mi nɛ saŋgwa nɔ na, nɔ̀ kêl nda yi wɛ kwaɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A ka̧ gbiŋgbɔ mate nje dolɔ sendi ɓo kɛ jakɔ, kɛto jakɔ kwaŋma ɓo kɛ misi. ");
INSERT INTO kkj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɛ nyɛ tikɛ ɓo kwa̧ kɛ̀ nɛ naŋ nɛ kɔkɔ. Kɛ mɛŋga yitatite ɛ nyɛ ŋgwɛta nɛ Njambiyɛ lɛpɔ ndi kiya yasi te yi nyɛ kandima lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A ka̧ yɔkwɛ mate nje dolɔ ɓejekɛ ɓenɛ lɛpɔ nyɛ ɓo nde: «Wunɛ kɛ kombile ya yun ndana, wɛɗya yun lalɛ. Nɛ ɓɛ̂ŋa, ŋgimɔ ɗyaŋma yi ɓo ta ɓu̧ nɛ *Mɔnɔ mumɔ kaŋɛ nyɛ kɛ mɛɓɔ mɛ ɓotu ɓe mɛɓeyɔ. ");
INSERT INTO kkj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nɛ tɛ̂ma, hɛ kwâŋ. Nɛ ɓɛ̂ŋa, mɔ te ɛ ɗyaŋgwɛ mi kɔ yima!» ");
INSERT INTO kkj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Piŋɔ te yi nyɛ ɓa̧ ndi kɛ lɛpɔ ɗete kɛ́, ɛ Yudas te ɛ ɓa̧ kɛ njoka ɓejekɛ kamɔ jɔ yiɓa kɔ ɗya̧. A nja̧ nɛ nyaŋgwɛ ŋgil ɓomɔ, ɓo ɓa̧ nɛ mɛkafa nɛ̀ mɛtegbe. Yo ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya tomɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mɔ te ɛ ta ɗyaŋgwɛ nyɛ nyɛ ɓomɔ kɔ nya ɓo kasiya nde: ‹Mɔ te yi mi ta nyɛnɔ nyɛ dulɔ numbu nɛ kɔ, ɛru, nɛ̀ wunɛ ɓîya nyɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ndana ndana kɛ́, ɛ Yudas ɗya̧ kwa̧ kɛ̀ kɛ kɛki Yesus lɛpɔ nde: «Yekele, hɛ lɛ̂pi!» Ɛ nyɛ kwa̧ dulɔ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Sɔ mbɛ, yasi te yi wɛ nja̧ kelɔ kɛ́, kelɔ yo nɛdɔ!» Ndana, ɛ ɓotu ɓaka ŋgbɔ kɛnjɛ ɓɔ ɓiye nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɛ mbaŋa mɔ te ɛ ɓa̧ ɓenɛ ɓe Yesus kɔ sutɛ kafa kɔtɔ nɛ mɔ mɛsay mɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ, pɛsɔ tɔ nɛ ɓetɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Yɔkiɗya kafa yɔ sɔmɔ kɛ ɓambi te. Kɛto ɓomɔ hɛnɛ ɓe sutɛ kafa, ɓo ta sɔmbɔ sɔŋ ndi nɛ nje kafa. ");
INSERT INTO kkj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","’Wɛ yeti kɛ duwɛ nde, ŋgɛ mi kwaɗyɛ, mi yakama diyɛ Saŋmbɛ ko ndana, a má njesɛ mi nyaŋgwɛ ŋgil njɔŋ ɓejaki laŋsa kamɔ jɔ yiɓa na? ");
INSERT INTO kkj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma ŋgɛ mɛyasi nje kwaŋna ɗete, yite yasi te yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ má nje tondɔ ɓa nan? Kɛto yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde, mɛyasi yâkaŋgwɛ kelna ɗete.» ");
INSERT INTO kkj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ndana, ɛ Yesus diyɛ ŋgil ɓotu ɓete ɓe nja̧ ɓiye nyɛ ɓaka nde: «’Mi ka mɔ guɓɔ, nɛ́ wunɛ ɓu̧ mɛkafa nɛ̀ mɛtegbe yí nje ɓiye nɛ mi? Mi ɗikima ɗiyɔ mɛtiɗyɛ mɛtu hɛnɛ kɛ mbanjɔ Njambiyɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ, ma wunɛ tì ɓiye mi na. ");
INSERT INTO kkj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yo nde, mɛyasi mɛnɔri hɛnɛ kwaŋnama ɗete, nɛ́ mɛlɛpi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima yi ɗiyɛ kɛtinate kɛ mɛkana mɛnɛ kɛ́ si tôndu.» Ndana, ɛ ɓejekɛ hɛnɛ si posiyɛ li̧ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓotu ɓete ɓe ɓiyma Yesus ɓaka ɓoŋma nyɛ kɛ̀ nɔ kɛ yi Kayif te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. Yite ɓotu ɓe teɗya mɛmboŋga nɛ̀ ɓetomba ɓe ɗya mɛ kɛ mɛwesiɗya mate. ");
INSERT INTO kkj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyɛr ɓa̧ kɛ ɓeŋgwɛ Yesus nɛ naŋ kumɔ kɛ ndoko nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ, ɛ nyɛ nyiŋɛ kɛ̀ ɗiyɔ mɛtiɗyɛ ɓenɛ ɓotu ɓe mɛsay, na ɓɛŋ nda yi mɛyasi ta siyɔ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ njɔŋ njena nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka saŋma to lɛpi te yi ɓo ta lɛpɔ suŋgwɛ nɛ Yesus yí wo nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma yasi wɛtɛ, ɓo saŋma deŋgɔ. Ko ɓɛkɔ nde, ɓaŋa ɓomɔ ɓuɗyate ɗikima tɛmɛ nje pɛsɔ lɛpi nyɛ nyɛ kɛ numbu. Ɗiyɔ kɛ́, ɛ ɓaŋa yiɓa pundɛ ɗya̧ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Mbam kɔ lɛpima nde: ‹Mi yakama si lekɛ mbanjɔ Njambiyɛ te yɔkɔ, nje sumɔ sendi yo ndi kɛ mɛtu yitati.› » ");
INSERT INTO kkj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ tɛmɛ diyɛ Yesus nde: «Wɛ yeti kɛ yeŋsa ka yaŋa kɛ yasi te yi ɓo lɛpɛ suŋgwɛ nɛ wɛ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɛ Yesus ɗiyɛ nɛ sɛm. Ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ lɛpɛ nyɛ nyɛ nde: «Mi kɛ diyɛ wɛ kɛ mbɔmbu Njambiyɛ te ɛ nɛ joŋ kɔ, ŋgɛ ɓɛ nde, wɛ gbate *Krist te Mɔnɔ Njambiyɛ, lɛpɔ nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «I̧, wɛ tɔsuma lɛpi. Mi kɛ kombile lɛpɔ sendi nyɛ wunɛ nde: Kandɛ ndana wunɛ ta ɓɛŋɛ *Mɔnɔ mumɔ mɛtiɗyɛ kɛ mbam ɓɔ Njambiyɛ te ɛ nɛ ŋguŋguɗyɛ hɛnɛ kɔ. Wunɛ ta ɓɛŋɛ sendi nyɛ kɛ nje kɛ to mɛkulutu kɛ ɗyoɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndana, ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nyalɛ mɛlambɔ kɛ yotu nɛ lɛpɔ nde: «Ŋge yi ɓo ta lɛpɔ sendi nyɛ wusɛ kɛ́? Wunɛ wokuma lɛpi gbutu te yi nyɛ lɛpima ndana ndana suŋgwɛ nɛ Njambiyɛ kɛ́! ");
INSERT INTO kkj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kɛ yun, nɛ ɓɛ́ŋa nan?» Ɛ ɓo yeŋsa nde: «Yakama nde, ɓo wôku nyɛ!» ");
INSERT INTO kkj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndana, ɛ ɓo kandɛ sana mɛsɛri kɛ misi mɛnɛ sɔmɔ nyɛ. Ɛ ɓaŋa kpakɛ nyɛ kɛ pokɔ ");
INSERT INTO kkj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","lɛpɔ nde: «Krist, tuɓɔ mɔ te ɛ kpakima wɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yinɔri Piyɛr ɓa̧ mɛtiɗyɛ kɛ mɔy ndoko kɛ sɛ̧. Ɛ wɛtɛ nya te ɛ ɗikima kelɔ mɛsay womɛte kɔ nje kɛ kɛki nɛ lɛpɔ nyɛ nyɛ nde: «Wɛ sendi, wɛ ɓa̧ wúnɛ Yesus te mɔ Nasarɛt.» ");
INSERT INTO kkj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yasi wɛtɛ, ɛ Piyɛr tonɛ kɛ mbɔmbu ɓomɔ hɛnɛ lɛpɔ nde: «Mi yeti kɛ duwɛ yasi te yi wɛ kwaɗyɛ lɛpɔ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɛ nyɛ tɛmɛ, na kɛ̀ pulɔ numɛy ndoko. Ɛ wɛtɛ nya te ɛ ɗikima kelɔ sendi mɛsay womɛte kɔ ɓɛŋɛ nyɛ lɛpɔ nyɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka nde: «Mbam kɔ ɓa̧ ɓenɛ ɓe Yesus te mɔ Nasarɛt.» ");
INSERT INTO kkj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɛ Piyɛr tonɛ wolo kinja lɛpɔ nde: «Mi yeti kɛ duwɛ mbam te na.» ");
INSERT INTO kkj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɗiyɔ nɛ mbɛt kɛ kɔŋte kɛ́, ɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka nje kɛ kɛki Piyɛr lɛpɔ nyɛ nyɛ nde: «Gbate, wɛ sendi kɛ njoka ɓotu ɓete, kɛto ndapi yɔ kɛ teɗye ɗete.» ");
INSERT INTO kkj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndana, ɛ nyɛ kandɛ mɛkinja mɛ yotu ɓiye kwey ɓiye nji̧ lɛpɔ nde: «Ko mi yeti kɛ duwɛ mbam te na!» Yaka nɛ mbam kuɓɛ kɛ kɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ɗete, ɛ Piyɛr takɛ lɛpi te yi Yesus ma lɛ́pi nde: ‹Wɛ ta tonɔ kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na piŋɔ te yi kuɓɛ tì pa kɔkɔ kɛ́.› Ɛ Piyɛr pundɛ kwa̧ kɛ̀ lelɔ ɓeyate. ");
INSERT INTO kkj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɓemɛŋmɛnɛ sut ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya kelɛ kutu nɛ ɗinɔ Yesus, nɛ́ ɓo wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kɛ ɓo ma si wotɔ nyɛ kɛ́, ɛ ɓo ɓu̧ nyɛ kwa̧ nɔ kaŋɛ nyɛ nyɛ Pilat te nyaŋgwɛ kum ɗya. ");
INSERT INTO kkj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ndana, kɛ Yudas mɔ te ɛ ɓoŋma Yesus kaŋɛ nyɛ ɓomɔ kɔ ma ɓɛŋɛ nde, ɓo pɛsima nde, ɓo ta wo Yesus kɛ́, ɛ mɛtakɛ kwa̧ nyɛ kɛ temɔ kɛ yasi te yi nyɛ kelma kɛ́. Ɛ nyɛ ɓu̧ sule kamɔtati te yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya nya nyɛ kɛ́, na kɛ̀ tikiɗye nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Mi kelma ɓeya yasi yi kaŋɛ mɔ te ɛ tì kelɛ yiŋa ɓeya yasi kɔ nyɛ wunɛ.» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Yeti kasi su na, yite ɓɛ́ŋa wɛ!» ");
INSERT INTO kkj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɛ Yudas ɓetɛ mɔni kɛ mɛnɛti kɛ mbanjɔ Njambiyɛ pundɔ kwa̧ kɛ̀ kɛsɛ ŋgiŋ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ tɔkuma mɔni te lɛpɔ nde: «Mɛmboŋga musu yeti kɛ nyɛ wusɛ ɗeti te yi ɓu̧ mɔni nje gbesɔ nɛ yikɛ yi wokuna nɛ Njambiyɛ kɛ́ na, kɛto mɔni te yikɛ wúla kɛ nje mɛkiyɔ mɛ mumɔ.» ");
INSERT INTO kkj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kɛ ɓo ma si jaŋɔ yí ɓɛŋɛ yasi te yi ɓo yakama kelɔ nɔ kɛ́, ɛ ɓo ɓu̧ yo ɓɔmɔ nɛ wɛtɛ ŋgwaŋ kɛ ɓɔ mɔ wɔmna mɛmbe. Ɓo ɓɔ́m yo yí pumbuna ɓejɛŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yori, kumɔ muka ɓo jéɓaŋgwɛ ŋgwaŋ te nde Ŋgwaŋ mɛkiyɔ. ");
INSERT INTO kkj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ɗete, lɛpi te yi Jeremi te mɔ punja mɛlɛpi mɛ Njambiyɛ ma lɛ́pi kɛ́ sima tondɔ. A lɛpima nde: ‹Ɓo ɓoŋma sule kamɔtati ɓomɔ nɛ ŋgwaŋ mɔ wɔmna mɛmbe nda yi Baba Mbokɔ kombila lɛpɔ nyɛ mi kɛ́. Kandɔ Isarayɛl pɛsima nde, ɓuyɔ mɔni te yakama nɛ ɓɔmna nɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɓo ka̧ nɛ Yesus kɛ jɔsi kɛ mbɔmbu Pilat te nyaŋgwɛ kum ɗya. Ɛ nyɛ diyɛ nyɛ mɛdiyan lɛpɔ nde: «Wɛ kumande Ɓeyudɛn?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo nda yi wɛ lɛpɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yasi wɛtɛ, a tì yeŋsa yaŋa kɛ mɛlɛpi mɛte yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya ɗikima lɛpɔ suŋgwɛ nɛ nyɛ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɛ Pilat diyɛ nyɛ nde: «Wɛ yeti kɛ wokɔ mɛyasi hɛnɛ te yi ɓo lɛpɛ suŋgwɛ nɛ wɛ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko Yesus tì yeŋsa yaŋa nyɛ nyɛ na, ko nɛ mbɛt kɛ yiŋa yasi na. Ɛ Pilat ŋgbakima ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kɛ ŋgimɔ jesɔ *Paska hɛnɛ nyaŋgwɛ kum ɗikima soŋɛ ɓɔ nɛ mɔ jɔɓɔ wɛtɛ, yɔkɔ yi ŋgil ɗikima lɛpɔ nde, a sôŋa ɓɔ nɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ɓo ɓa̧ nɛ wɛtɛ ɓeya mɔ jɔɓɔ kɛ ŋgimɔ te yite nde Barabas. Ɓomɔ hɛnɛ ɗikima lɛpɔ kasi nɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ɛ Pilat diyɛ ŋgil ɓotu ɓete ɓe wesiɗyama ɓaka nde: «Nɛ̀ Barabas nɛ̀ Yesus te yi ɓo jeɓa nde *Krist kɔ, wunɛ kwáɗyikwɛ nde, mi sôŋa ɓɔ nɛ nda yɔkiɗye nyɛ nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat diyma ɗete, kɛto a duwa̧ nde, yo kɛto ɓeya temɔ yi ɓo kaŋma nɛ Yesus nyɛ kɛ mɛɓɔ mɛnɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kɛ ŋgimɔ te yi Pilat ɓa̧ mɛtiɗyɛ kɛ mbanjɔ jɔsi kɛ pɛsina jɔsi kɛ́, ɛ nyari wenɛ kɛnjɛ tomun lɛpɔ nyɛ nyɛ nde: ‹Wɛ tî nyɛki numbu kɛ lɛpi mbam ɛnɔru na, nyɛ ŋgbeŋ mumɔ. Mi yama ɓeya tu muka ɓuɗyate kɛ kasi nɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya kitɛ ɓomɔ nde, ɓo dîya nde, Pilat sôŋa ɓɔ nɛ Barabas kpalɔ wo Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ɛ nyaŋgwɛ kum Pilat ɓasiɗye diyɛ ɓo nde: «Kɛ njoka ɓotu ɓaka yiɓa, wunɛ kwáɗyikwɛ nde, mi sôŋa ɓɔ nɛ nda yɔkiɗye nyɛ wunɛ?» Ɛ ɓo yeŋsa nde: «Soŋa ɓɔ nɛ Barabas.» ");
INSERT INTO kkj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ɛ Pilat nje diyɛ ɓo nde: «Ma mi kêl ɓa nan nɛ Yesus te yi ɓo jeɓa nde Krist kɔ?» Ɛ ɓo hɛnɛ yeŋsa nde: «Ɓo ŋgbâki nyɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ɛ nyaŋgwɛ kum Pilat diyɛ ɓo nde: «Ma yo kwalɔ ɓeya yasi te nda yi nyɛ kelma kɛ́?» Ɛ ɓo kembiɗya ndana kwa̧ to te lɛpɔ nde: «Ɓo ŋgbâki nyɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat ɓɛŋma nde, sosu nɛ siyma, lɛpi yeti kɛ wɛyɛ na, mɛyasi kɛ kpalɔ ɓɛ nɛ hoya hoya kwa̧ to te. Ɛ nyɛ ɓu̧ mɔrɔku weyɛ nɛ mɛɓɔ kɛ mbɔmbu ŋgil ɓomɔ hɛnɛ lɛpɔ nde: «Mi yeti mbɛ nɛ lɛpi kɛ sɔŋ ŋgbeŋ mɔ te yɔkɔ na, yo ɓɛ́ŋa wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɛ ŋgil ɓomɔ hɛnɛ yeŋsa nde: «Simbo sɔŋ nɛ ɓâl kɛ to su nɛ̀ kɛ to ɓɔnɔ ɓusu.» ");
INSERT INTO kkj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɗete, ɛ Pilat soŋɛ ɓɔ nɛ Barabas yɔkiɗye nyɛ ɓo. Kɛ nyɛ ma si nyɛ ɗeti nde, ɓo njûru Yesus nɛ njambala kɛ́, ɛ nyɛ kaŋɛ nyɛ nyɛ ɓo, nɛ́ ɓo kɛ̀ ŋgba nyɛ kɛ kroa. ");
INSERT INTO kkj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ɓesɔja ɓe nyaŋgwɛ kum Pilat ŋgbɔsuma Yesus kɛ̀ nɔ kɛ mbanjɔ Pilat kɛ numɛy tu̧ ɗyenɛ mate. Ɛ ɓo wesiɗye ndiŋgɛlɛ njɔŋ ɓesɔja hɛnɛ litɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓo sɔruma mɛlambɔ kɛ yotu nɛ nje lɛnje nyɛ wɛtɛ kpasa tena gambo. ");
INSERT INTO kkj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɛ ɓo ɓu̧ yiŋa mɛkɔl nɛ mɛsɔru kɛte jakɔ nɛ ɗuŋgwɛ te lɛnje nyɛ kɛ to. Ɛ ɓo ɓu̧ yiŋa kum soŋ nyɛ kɛ mbam ɓɔ nɛ. Ɛ ɓo nje kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ sɛrke nyɛ lɛpɔ nde: «Kumande Ɓeyudɛn, hɛ lɛ̂pi!» ");
INSERT INTO kkj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɛ ɓo ɓu̧ kum soŋ yinɔri kwɛlɛ nɛ nyɛ kɛ to, sa mɛsɛri kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kɛ ɓo ma siɗyɛ sɛrka nɛ ɗete kɛ́, ɛ ɓo sɔrɛ kpasa tena gambo yinɔri kɛ yotu nɛ nje lɛnje nyɛ mɛlambɔ mɛnɛ ŋgbɔsɔ nyɛ kwa̧ nɔ, nɛ́ ɓo kɛ̀ ŋgba nyɛ kɛ kroa. ");
INSERT INTO kkj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ pundɔ ɗuwɛ kɛ mɔy ɗya kɛ́, ɛ ɓo saŋgwa nɛ wɛtɛ mbam nde Simɔn, mɔ Sirɛn. Ɛ ɓesɔja jeliyɛ nyɛ nde, a sôɓa kroa Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓo kɛndima kumɔ kɛ mbɛy te yi ɓo jeɓa nde Golgota, yite nde Mbɛy gboŋgo to. ");
INSERT INTO kkj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kumɔ mate, ɛ ɓo ɓu̧ yiŋa mɛnjam mɛte yi ɓo pulma nɛ yiŋa pekeke yasi kɛte nyɛ Yesus nde, a hɔ̂ɓiya. Kɛ nyɛ ma ɓoɓɛ ndi ɗekɛ kɛ́, ɛ nyɛ sɛŋɛ kinɛ hɔɓiye na. ");
INSERT INTO kkj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kɛ ɓo ma si ŋgba nyɛ kɛ kroa ɗete kɛ́, ɛ ɓo ɓu̧ mɛlambɔ mɛnɛ lu̧ kɛ mbari yi kaɓiɗya nɛ yo. Mɛyasi kwaŋnama ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi mɔ punja mɛlɛpi mɛ Njambiyɛ ma lɛ́pi kɛ́. A lɛpima nde: ‹Ɓo kaɓiɗyama mɛlambɔ mɛmbɛ. Ɓo loŋma lambɔ te yi mi ɗikima lɛŋɛ kɛ nji̧ te yiri kɛ́ kɛ mbari.› ");
INSERT INTO kkj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kɛ kɔŋte, ɛ ɓo kwa̧ ɗiyɔ mɛtiɗyɛ pɛmɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yí teɗye nɛ to sɔŋ nɛ, ɓo kɛtima yiŋa yasi ŋgba kɛ to kroa nɛ nde: ‹Yɔkɔ Yesus, kumande Ɓeyudɛn.› ");
INSERT INTO kkj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɓo ŋgbama sendi nyaŋgwɛ ɓotu ɓe guɓɔ yiɓa kɛ kroa nda Yesus, wɛtɛ kɛ kroa te wenɛ pulɔ mbam ɓɔ nyɛ, wɛtɛ kɛ wenɛ pulɔ gare. ");
INSERT INTO kkj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓotu ɓete ɓe ɗikima kwa̧ kwaŋgɔ nɛ nje ɓaka ɗikima toyɛ nyɛ kɛnjɛ ndiŋgile to soŋɛ pokɔ ");
INSERT INTO kkj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lɛpɔ nde: «Wɛ mɔ te ɛ lekɛ mbanjɔ Njambiyɛ nje sumɔ ndi kɛ mɛtu yitati kɔ, joŋgwɛ yotu yɔ nɛ ŋguru wɔ. Ŋgɛ ɓɛ nde, wɛ Mɔnɔ Njambiyɛ, pikwɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ ɓetomba ɓe ɗya ɗikima nyɛtɔ nyɛ sendi lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«A ɗikima joŋgwɛ ɓaŋa ɓomɔ, ma a yeti nɛ ɗeti te yi joŋgwɛ yotu nɛ nɛ ŋguru wenɛ na. ’A yeti kumande Isarayɛl na? Ma a pîkwɛ ŋgɛnjɛ ndana kɛ kroa, ɗete wusɛ ta tikɔ temɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A ɓa̧ nɛ ɓiɓina temɔ hɛnɛ kɛ yi Njambiyɛ, a ɗikima lɛpɔ nde: ‹Mi Mɔnɔ Njambiyɛ.› Ma ŋgɛ ɓɛ nde, Njambiyɛ kɛ kwaɗyɛ nyɛ gbate, a jôŋgwɛ nyɛ ndana.» ");
INSERT INTO kkj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nyaŋgwɛ ɓotu ɓe guɓɔ ɓete yi ɓo ŋgbama kɛ kroa ɓenɛ ɓe Yesus ɓaka ɓa̧ kɛ toyɛ sendi nyɛ ɗete. ");
INSERT INTO kkj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yitil kelma kɛ ndiŋgɛlɛ mɛnɛti kandɛ kɛ ɓembe yesɔ kumɔ kɛ hawa yitati te yi ɓekoko. ");
INSERT INTO kkj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kɛ pɔku hawa yitati, ɛ Yesus kembɛ ɗetinate lɛpɔ nde: «Eli, Eli, lama sabatani?» Yite nde: ‹Njambiyɛ wombɛ, Njambiyɛ wombɛ, wɛ léŋ mi kɛto ŋge?› ");
INSERT INTO kkj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kɛ ɓaŋa ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ma wokɔ ɗete kɛ́, ɛ ɓo lɛpɛ nde: «A kɛ jeɓa Eli.» ");
INSERT INTO kkj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɛ wɛtɛ mumɔ kɛ njoka yan sɛɗyɛ nɛdɔ kɛ̀ ɓu̧ yiŋa yasi nda kusa tɔpɛ kɛ yiŋa ɗyanjina mɛnjam sɔmɔ kɛ jeti sambile nyɛ nyɛ nde, a hɔ̂ɓiya. ");
INSERT INTO kkj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɛ ɓaŋa lɛpɛ nde: «Tikɔ, hɛ pa ɓɛŋ, simande Eli ta nje joŋgwɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ɗiyɔ kɛ́, ɛ Yesus kembɛ ɗetinate kwa̧ kaŋɛ sisiŋ nɛ nyɛ kɛ mɛɓɔ mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɛ nyaŋgwɛ lambɔ te yi ɓa̧ kɛsate kɛ mbɛy te yi nɛ kiyɔ kɛ mbanjɔ Njambiyɛ kɛ́ nyaliyɛ kɛ ɓembe kandɛ kwey kumɔ nji̧. Ɛ mɛnɛti ŋgwaŋgwa, ɛ mɛtari posiyɛ, ");
INSERT INTO kkj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mɛɓoŋsɔŋ ɓutunama, ɛ ɓotu ɓe Njambiyɛ ɓuɗyate ɓe ma gwe ɓaka womiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓo punduma kɛ ɓoŋsɔŋ. Kɛ Yesus ma si womiyɛ kɛ́, ɛ ɓo nyiŋɛ kɛ Yerusalɛm, ɗya te yi Njambiyɛ tɔkuma. Ɓomɔ ɓuɗyate ɓɛŋma ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kum ɓesɔja nɛ̀ ɓesɔja ɓete ɓe ɓenɛ ɓo ɓa̧ kɛ pɛmɔ Yesus ɓaka ɓɛŋma nda yi mɛnɛti ŋgwaŋgwama nɔ, ɓɛŋɛ sendi yasi te yi kwaŋnama kɛ́. Ɛ ɓo gwe wɔ̧ ɓeyate lɛpɔ nde: «Mbam kɔ ɓa̧ gbate Mɔnɔ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɓaŋa ɓoma ɓuɗyate ɓa̧ womɛte. Ɓo ɗikima ɗiyɔ nɛ naŋ ɓɛŋɛ yasi kɛnjɛ. Ɓo ɗikima ɓeŋgwɛ Yesus kelɔ mɛsay nyɛ nyɛ kandɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mariya te ŋgɔndu Magdala nɛ̀ Mariya te nyaŋgwɛ nɛ Jak ɓenɛ Yosɛp nɛ̀ nyaŋgwɛ nɛ ɓɔnɔ ɓe Seɓede ɓa̧ kɛ njoka ɓoma ɓenɔri. ");
INSERT INTO kkj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kɛ ɓekoko ma kelɔ, ɛ wɛtɛ mɔ Arimate nde Yosɛp ɗya̧. A ɓa̧ mɔ kusuku, ɓɛ sendi wɛtɛ jekɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A ka̧ kɛ yi Pilat kɛ̀ diyɛ muŋ Yesus. Ɛ Pilat jayɛ nde, ɓo ɓôŋ muŋ Yesus nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɛ Yosɛp ɓu̧ muŋ Yesus ɓɔyɛ kɛ wɛtɛ wumna ndɔmbɔ nɛ mboŋ mboŋ ");
INSERT INTO kkj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kwa̧ kɛ̀ niŋgwɛ kɛ jɔnja ɓoŋsɔŋ te yi nyɛ Yosɛp nɛ ŋguru wenɛ ma lɛ́pi nde, ɓo tîm nyɛ nyɛ kɛ wɛtɛ nyaŋgwɛ tari kɛ́. Ɓo tì pa pumbɔ wɛtɛ mumɔ kɛte nɛ mbɔmbu na. Ɛ nyɛ nje ɓiŋgile wɛtɛ nyaŋgwɛ tari ɗiɓɔ nɛ numbu te tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya te ŋgɔndu Magdala ɓenɛ Mariya te yɔru ɓa̧ womɛte mɛtiɗyɛ kɛ kɛki ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Misi pupɛ, yite nde, kɛ kɔŋ mɛkomsa mɛ yesɔ *Saba, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ *Ɓefarisɛ̧ kɛ̀ dolɔ Pilat lɛpɔ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Sa Mbokɔ, wusɛ ndi kɛ takɛ yasi te yi mɔ ja̧ kɔ ɗikima lɛpɔ piŋɔ te yi nyɛ ɓa̧ ndi nɛ joŋ kɛ́. A ɗikima lɛpɔ nde: ‹Ya mɛtu yitati kɛ kɔŋte mi ta womiyɛ.› ");
INSERT INTO kkj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ɗete, pɛsɔ nde, ɓo pɛ̂m ɓoŋsɔŋ kumɔ kɛ mɛtu yitati, kambɔ ɓejekɛ ɓenɛ mɛ nje guɓɔ muŋ nɛ kwa̧ nɔ nje kpalɔ lɛpɔ nyɛ ɓomɔ nde: ‹A womiya!› Lɛpina ja̧ te yite ta nje ɓɛ yɛy ŋgboro kwa̧ bosate.» ");
INSERT INTO kkj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ɛ Pilat lɛpɛ nyɛ ɓo nde: «Ta ɓesɔja ɓe pɛmna yasi ɓaka, nɛ kwâŋ, ɓo kɛ̂n kɛ̀ pɛmɔ ɓoŋsɔŋ nda yi wunɛ kwaɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɛ ɓo nje kwa̧ ɓu̧ yiŋa yasi nda ɗaŋgi ɗakse kɛ numbu ɓoŋsɔŋ yi teɗye nde, yo nyaŋgwɛ kum nyɛ ɗeti te yi kelɔ ɗete. Ɓo ɓoŋma sendi ɓesɔja tikɔ womɛte yí pɛmna ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kɛ kɔŋ yesɔ *Saba ɛ Mariya te ŋgɔndu Magdala ɓenɛ Mariya te yɔru tɛmɛ ɓemɛŋmɛnɛ nɛ sut kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi yí kɛ̀ ɓɛŋɛ ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Semɔ semɔ, ɛ mɛnɛti ŋgwaŋgwa ɓuɗyate, kɛto wɛtɛ jaki Baba Mbokɔ piya wulɛ ɗyoɓɔ njeŋɛ tari soŋɛ kɛ numbu ɓoŋsɔŋ nje kwa̧ ɗiyɔ mɛtiɗyɛ kɛ to te. ");
INSERT INTO kkj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A ɓa̧ kɛ panɔ kɛ misi nda yɛsi mbiyɔ, mɛlambɔ mɛnɛ ɓa̧ wumnate nɛ mboŋ mboŋ. ");
INSERT INTO kkj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɓesɔja ɓete ɓe ɓa̧ kɛ pɛmɔ yasi ɓaka gwa̧ wɔ̧ ŋgwaŋgwa tika nda muŋ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yasi wɛtɛ, ɛ jaki lɛpɛ nyɛ ɓomari nde: «Kɛ ɓɛ wunɛ, nɛ tî gwaki wɔ̧ na. Mi duwa̧ nde, wunɛ sáŋ Yesus te yi ɓo ŋgbama kɛ kroa kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A yeti se waka na, a ma womiyɛ nda yi nyɛ ma lɛ́pi kɛ́. Nɛ njâki, nɛ ɓɛ̂ŋa mbɛy te yi ɓo niŋgwa nyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wunɛ kɛ̂n nɛdɔ kɛ̀ lɛpɔ nyɛ ɓejekɛ nde: ‹A ma womiyɛ kɛ njoka ɓemuŋ. A ma kandɛ kwa̧ nɛ wunɛ kɛ̀ pɛ Galile. Wunɛ ta ɓɛŋɛ nyɛ mate.› Ma yokɛ yi mi ma lɛpɔ nyɛ wunɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɓoma gwa̧ wɔ̧, ma ɓo ɓa̧ nɛ nyaŋgwɛ mɛsosa kɛ temɔ. Ɓo kwaŋma jesɛ nɛdɔ kɛ̀ kɛki ɓoŋsɔŋ sɛɗyɛ kɛ̀ lɛpɔ tom te nyɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Semɔ semɔ, Yesus ɛ nje kɛ mbɔmbu yan ru saŋgwa nɛ ɓo lɛpɔ nde: «Hɛ lɛ̂pi wunɛ!» Ɛ ɓomari kɛ̀ wuse nyɛ kɛ mɛkol kusɛ mɛɓɔŋ kanɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Nɛ tî gwaki wɔ̧ na. Nɛ kɛ̂n lɛpɔ nyɛ ɓemaŋ ɓembɛ nde, ɓo kɛ̂n pɛlɛ Galile, ɓo ta ɓɛŋɛ mi mate.» ");
INSERT INTO kkj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Piŋɔ te yi ɓomari ɓa̧ ndi kɛ kɛ̀ kɛ́, ɛ ɓaŋa ɓesɔja ɓete ɓe ɓa̧ kɛ ɓakiɗye ɓoŋsɔŋ ɓaka pɛsa kumɔ kɛ mɔy ɗya, dolɔ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ yekiɗye mɛyasi hɛnɛ te yi kwaŋnama kɛ́ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kɛ kɔŋte, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya wesiɗya kpo ŋgiŋ kaŋɛ ɓuɗya mɔni nyɛ ɓesɔja ɓaka ");
INSERT INTO kkj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","lɛpɔ nyɛ ɓo nde: «Wunɛ lɛ̂pi nde, ɓejekɛ ɓenɛ nja̧ nɛ tu nje guɓɔ nyɛ piŋɔ te yi wunɛ ɓa̧ kɛ jakɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma ŋgɛ nyaŋgwɛ kum ɗya wokɛ kasi te, wusɛ ta wɛɗye temɔ nɛ kelɔ nde, wunɛ tî saŋgwaŋgwɛ nɛ mɛnjaŋgwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ɓesɔja ɓoŋma mɔni te, ɛ ɓo kelɛ nda yi ɓo lɛpima nyɛ ɓo kɛ́. Ɛ lɛpi ja̧ te yi ɓo lɛpima nyɛ ɓo nde, ɓo lɛ̂pi ɗete kɛ́ lapiɗya kɛ njoka Ɓeyudɛn kumɔ ndi muka. ");
INSERT INTO kkj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɓejekɛ kamɔ jɔ wɛtɛ tɛmma kɛ̀ pɛlɛ Galile kɛ keki te yi Yesus lɛpima nyɛ ɓo kɔ. ");
INSERT INTO kkj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kɛ ɓo ma ɓɛŋɛ nyɛ kɛ́, ɛ ɓo kusɛ mɛɓɔŋ kanɔ nyɛ. Ma ɓaŋa ɓa̧ nɛ mɛso kɛ temɔ. ");
INSERT INTO kkj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ɛ Yesus kɛ̀ kɛ kɛki yan lɛpɔ nde: «Njambiyɛ ma nyɛ mi ɗeti te yi namɔ mɛyasi hɛnɛ kandɛ kɛ kwey kumɔ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɗete, wunɛ kwâŋ, wunɛ kêl nde, mɛkandɔ hɛnɛ ɓɛ̂ki ɓejekɛ ɓembɛ. Wunɛ kêl ɗete nɛ nje tɔpuna yan kɛ mɔrɔku nɛ ɗinɔ Da, nɛ ɗinɔ *Mɔnɔ, nɛ yi Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wunɛ kêl nde, ɓo ɓɛ̂ki ɓejekɛ ɓembɛ ɗete nɛ nje teɗya yan sendi nde, ɓo ɓâkiɗya mɛyasi hɛnɛ te yi mi lɛpima nyɛ wunɛ kɛ́. Ma wunɛ ɗûkwɛ nde: Mi ndi sinɛ wunɛ mɛtu hɛnɛ kumɔ kɛ siyna mbokɔ te yɔkɔ.»");
INSERT INTO kkj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kimɔ Tom te yi lɛpɛ kasi Yesus Krist te Mɔnɔ Njambiyɛ kɛ́ kandima ɗekɛ: ");
INSERT INTO kkj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yo kandima nda yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ́. A kɛtima nde: ‹Ɓɛŋa, mi kɛ kandɛ tomɔ mɔ tomun nɛ wɛ, na kɛ̀ kandi kombile nje tikɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wɛtɛ mumɔ kɛ kembiɗya kɛ mɔy koŋgor nde: Wunɛ kômbila nje Baba Mbokɔ. Wunɛ tɛ̂mbiɗya mɛnje mɛnɛ nɛ ŋgbeŋ.› ");
INSERT INTO kkj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɗiyɔ kɛ kɔŋte, ɛ Jaŋ ɗya̧ nyɛ ɓɔ kɛ tɔpuna ɓomɔ kɛ mɔrɔku kɛ koŋgor, pelɛ kɛ kasi tɔpuna ɓomɔ kɛ mɔrɔku nde, ɓo yêŋsaŋgwɛ temɔ jayɛ nde, ɓo tɔ̂pa ɓo kɛ mɔrɔku, nɛ́ Njambiyɛ tiki mɛɓeyɔ man nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓotu ɓe Yerusalɛm nɛ̀ ɓotu ɓe mɛnɛti mɛ Yuda hɛnɛ ɗikima kɛ̀ kɛ yenɛ. Ɓo ɗikima jayɛ ɓeya mɛkele man kɛ mbɔmbu ɓomɔ, ɛ nyɛ ɗiki tɔpɛ ɓo kɛ Yurdɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaŋ ɗikima lɛŋɛ wɛtɛ lambɔ te yi ɓo kelma nɛ mɛmburu mɛ *samo. Kanda te yi nyɛ ɗikima lɛŋɛ kɛ jon kɛ́, ɓo kél yo nɛ kotu nyamɔ. A ɗikima ɗye ɓeɗɔlɔ nɛ̀ mutɔ mɛ jo te yi nyɛ ɗikima dolɔ kɛ likɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A ɗikima pelɛ lɛpɔ nyɛ ɓomɔ nde: «Wɛtɛ mumɔ kɛ nje kɛ kɔŋ mbɛ. A nɛ ɗeti kwa̧ mi. Mi ti yaka ɗitima yí wunjɛ kɔl mɛnakala kɛ kol nɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi tɔpuma mbɛ wunɛ kɛ mɔrɔku. Yasi wɛtɛ, kɛ ɓɛ nyɛ, a ta tɔpɛ wunɛ kɛ Kimɔ Sisiŋ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kɛ ŋgimɔ te yite, Yesus ɗyaŋma wulɛ Nasarɛt kɛ mɛnɛti mɛ Galile. Ɛ Jaŋ tɔpɛ nyɛ kɛ mɔrɔku kɛ Yurdɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ɓendɔ ndi ŋgindi ɗekɛ kɛ́, a ɓɛ́ŋa ɗyoɓɔ kɛ nɛmbiyɛ, ɛ Kimɔ Sisiŋ piyɛ nje kɛ yotu nɛ nda pepɔ. ");
INSERT INTO kkj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɛ wɛtɛ mɛn wulɛ ɗyoɓɔ lɛpɔ nde: «Wɛ Mɔnɔ mbɛ, sɔŋ temɔ mbɛ, temɔ mbɛ hɛnɛ kɛ yotu yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ndana ndana, ɛ Kimɔ Sisiŋ kaŋɛ Yesus kɛnjɛ kɛ koŋgor. ");
INSERT INTO kkj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A kwaŋɗya mɛtu kamɔni mate. Kɛ mɛtu te yinɔri *Satan ɓa̧ ndi kɛ ɓoɓɛ nyɛ. Yesus joŋnama mate kɛ njoka ɓenyamɔ ɓe likɔ, ɛ ɓejaki ɓe Njambiyɛ ɗiki kelɔ mɛsay nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kɛ ɓo ma si ɓiye Jaŋ nyɛ kɛ jɔɓɔ kɛ́, ɛ Yesus kwa̧ kɛ̀ kɛ mɛnɛti mɛ Galile pelɛ Kimɔ Tom Njambiyɛ nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A ɗikima lɛpɔ nde: «Ŋgimɔ te yi Njambiyɛ pɛsima kɛ́ ma ɗya̧, *Kandɔ Njambiyɛ ma wuta. Wunɛ yêŋsaŋgwɛ temɔ jayɛ sendi Kimɔ Tom.» ");
INSERT INTO kkj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus ɓa̧ kɛ kwa̧ kɛ goŋ nyaŋgwɛ matɔ Galile. A ɓɛŋma Simɔn ɓenɛ Andere, maŋ nɛ Simɔn kɛ ɓetɛ bulajama kɛ nyaŋgwɛ matɔ, kɛto ɓo ɓa̧ ɓotu ɓe wona ɓenjanjɔ. ");
INSERT INTO kkj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ ɓêŋgwɛ mi, mi ta kelɔ nde, wunɛ kpâl ɓɛ ɓotu ɓe ɗalna ɓomɔ, teɗye nje Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ndana ndana, ɛ ɓo ŋgbɛsɛ mɛbulajama man ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus toŋgiɗyama kumɔ mbɔmbu nɛ mbɛt, ɛ nyɛ ɓɛŋɛ Jak te mɔnɔ Seɓede ɓenɛ maŋ wenɛ Jaŋ. Ɓo ɓa̧ kɛ mɔy landi kɛ kombile mɛbulajama. ");
INSERT INTO kkj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ndana ndana, ɛ Yesus jeɓa ɓo, ɛ ɓo tikɛ saŋgwɛ wan Seɓede kɛ mɔy landi ɓenɛ ɓotu ɓe mɛsay kwa̧ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kɛ kɔŋte, ɛ Yesus kwa̧ ɓenɛ ɓejekɛ ɓenɛ ɓenɔri kɛ̀ kɛ Kapɛrnawum. Kɛ yesɔ *Saba ma ɗya̧, ɛ nyɛ nyiŋɛ kɛ mɔy mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɓomɔ ŋgbakimama kwalɔ teɗya yasi te yenɛ ɓuɗyate, kɛto a ɗikima teɗye ɓo mɛyasi nɛ ɗeti Njambiyɛ. A tì ɓɛ kɛ teɗye nda yi ɓotu ɓe kɛtina mɛyasi na. ");
INSERT INTO kkj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kɛ ŋgimɔ te yite wɛtɛ mbam te ɛ ɓa̧ nɛ wɛtɛ ɓeya sisiŋ kɛ yotu kɔ ɓa̧ kɛ mɔy mbanjɔ mɛwesiɗya man. ");
INSERT INTO kkj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ɛ nyɛ kembiɗya lɛpɔ nde: «Yo ŋge, Yesus te mɔ Nasarɛt, sinɛ wunɛ nɛ lɛpi te nda? ’Wɛ njáki nje girise wusɛ? Mi duwa̧ wɛ kimɔte, wɛ pupuna mɔ te yi Njambiyɛ tɔkuma njesɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ɛ Yesus ɓama nɛ ɓeya sisiŋ lɛpɔ nde: «Ɗiɓɔ numbu yɔ, pundɔ kɛ yotu mbam kɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ɛ ɓeya sisiŋ jalɛ mbam kɔ ɓeyate kwa̧ pundɔ kɛ yotu nɛ nɛ nyaŋgwɛ kembi. ");
INSERT INTO kkj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɛ sosu ɓomɔ hɛnɛ siyɛ nɛ hirek, ɛ ɓo ɗiki diyna tandɛ yan nde: «Yikɛ ɓa ŋge? Yikɛ ɓa kwalɔ jɔnja teɗya yasi te nda? A téɗya gba yasi nɛ ŋguŋguɗyɛ. A kɛ ɓama ko nɛ ɓeya mɛsisiŋ, ɓeya mɛsisiŋ kɛ wokuna nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ndana ndana, ɛ ɗinɔ Yesus wumɛ nyanja yaka nɛ mɛnɛti mɛ Galile hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kɛ ɓo ma pundɔ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ́, ɛ Yesus kwa̧ ɓenɛ ɓe Jak nɛ̀ Jaŋ kɛ̀ kɛ tu̧ Simɔn ɓenɛ Andere. ");
INSERT INTO kkj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yinɔri ki nɛ Simɔn ɛ nyari ɓa̧ mɛtinɛŋgwɛ nɛ ɗuku. Ɛ ɓo lɛpɛ kasi nɛ nɛdɔ nyɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɛ nyɛ kɛ̀ kɛ kɛki nyari kɛnjɛ ɓɔ tɛmbiɗye nɛ nyɛ. Ɛ kɔn ɗuku siyɛ kɛ yotu nɛ, ɛ nyɛ tɛmɛ kɛ̀ kelɔ mɛsay nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kɛ ɓekoko ma ɗya̧, tu mɛ kɛ yinja, ɛ ɓomɔ ɓu̧ ɓotu ɓe kɔn hɛnɛ nɛ̀ ɓotu ɓete ɓe ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu ɓaka nje nɔ kɛ̀ yi Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɛ ɓotu ɓe ɗya hɛnɛ ŋgbɔ wesiɗya kɛ numɛy tu̧. ");
INSERT INTO kkj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A siɗya mboya mɛkɔn mɛ ɓuɗya ɓomɔ, soŋɛ sendi ɓuɗya ɓeya mɛsisiŋ kɛ yotu ɓomɔ. A tì ɓɛ kɛ jayɛ nde, ɓeya mɛsisiŋ lɛ̂pinaŋgwɛ na, kɛto ɓeya mɛsisiŋ duwa̧ nyɛ kimɔte. ");
INSERT INTO kkj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yi kɛ̀ nɔ njenamɛnɔ piŋɔ te yi yasi ndi gba nɛ mbi mbi mbilip kɛ́, ɛ Yesus tɛmɛ pundɔ kwa̧ kɛ̀ kɛ wɛtɛ mbɛy te yi ɓa̧ kinɛ ɓomɔ kɛte kɛ́ kɛ̀ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ɛ Simɔn ɓenɛ ɓotu ɓete ɓe ɓenɛ ɓo ɓa̧ ɓaka ɓeŋgwɛ nyɛ nɛdɔ. ");
INSERT INTO kkj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kɛ ɓo ma dolɔ nyɛ kɛ́, ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Ɓomɔ hɛnɛ kɛ gɔsɔ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Hɛ kwâŋ kɛ̀ kɛ yiŋa mɛmbɛy kɛ mɛɗya mɛte yi kɛ mbɔmbu wusu kɛ́, nɛ́ mi kɛ̀ pel sendi mɛlɛpi mɛ Njambiyɛ mate, kɛto mi ma njáki kɛto te yite.» ");
INSERT INTO kkj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɛ nyɛ tɛmɛ kwa̧ kɛndɔ nɛ mɛnɛti mɛ Galile hɛnɛ pelɛ Kimɔ Tom kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, soŋɛ sendi ɓeya mɛsisiŋ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wɛtɛ mɔ ndoko nja̧ kɛ yi Yesus kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ ŋgwɛta nɛ nyɛ lɛpɔ nde: «Ŋgɛ wɛ kwaɗyɛ, ɔ yakama kelɔ nde, yotu mbɛ ɓɛ̂ki nɛ kpɛlɛ kpɛlɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ɛ Yesus gwe ŋgwɛtɛ wenɛ sambile ɓɔ kpokɛ nɛ nyɛ lɛpɔ nde: «Mi kwaɗya, yotu yɔ ɓɛ̂ki nɛ kpɛlɛ kpɛlɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɛ ndoko siyɛ kɛ kiya mbɛy kɛ yotu nɛ. Ɛ yotu nɛ ɓɛ nɛ kpɛlɛ kpɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ɛ Yesus yɔkiɗye nyɛ kɛ kiya mbɛy kiɗyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Kpɛ, wɛ tî yekiɗya mɛyasi mɛte yi kwaŋnama kɛ́ nyɛ mumɔ na. Yasi wɛtɛ, kɛn teɗye yotu yɔ nyɛ mɔ nyɛna sadaka nyɛ Njambiyɛ, nɛ̀ wɛ kɛn kelɔ sadaka nda yi Mɔyisi pɛsima kɛ́, kɛto yotu yɔ mɛ nɛ kpɛlɛ kpɛlɛ, nɛ́ ɓomɔ duwɛ nde, kɔn yɔ siyma.» ");
INSERT INTO kkj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko ɓɛkɔ ɗete, mbam kɔ kwaŋma kandɛ pelɛ mɛyasi mɛte yi kwaŋnama kɛ́ kɛ mɛmbɛy hɛnɛ nyɛ ɓomɔ. Ɗete, Yesus tì ɓɛ se nɛ ɗeti te yi nyiŋɛ kɛ wɛtɛ ɗya kɛ misi mɛ ɓomɔ na. A ɗikima ɗiyɔ nɛ naŋ kɛ mɛmbɛy mɛte yi ɓomɔ yeti kɛte kɛ́. Ɓomɔ ɗikima wulɛ mɛmbɛy hɛnɛ nje kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mɔnɔ mɛtu kwaŋma kɛ kɔŋte, ɛ Yesus yɔkwɛ wolo nɛ kɔkɔ kɛ̀ kɛ Kapɛrnawum. Ɓomɔ wokuma nde, a kɛ mɔy tu̧. ");
INSERT INTO kkj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɛ ɓuɗya ɓomɔ ŋgbɔ wesiɗya komɛte, ko mɔnɔ mbɛy tì ɓɛ se na ko kɛ kɛki numɛy. Yesus ɓa̧ kɛ pelɛ mɛlɛpi mɛ Njambiyɛ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndana, ɛ ɓaŋa ɓomɔ yini soɓɛ wɛtɛ mɔ jɛmti nje nɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ɓo tì ɓɛ nɛ ɗeti te yi kumɔ nɛ nyɛ kɛ mbɔmbu Yesus na, kɛto nyaŋgwɛ ŋgil ɓomɔ. Ɗete, ɛ ɓo ɓendɛ tosiyɔ̧, tosɔ yaka nɛ mbɛy komɛ nyɛ ɓa̧ kɛ́, piɗyɛ taŋ nɛ̀ mɔ jɛmti mɛtinɛŋgwɛ kɛte. ");
INSERT INTO kkj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kɛ Yesus ma ɓɛŋɛ gbate nde, ɓomɔ ɓaka tikima temɔ nɛ nyɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ mɔ jɛmti nde: «Mɔnmbɛ, mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɓaŋa ɓotu ɓe kɛtina mɛyasi ɓa̧ mɛtiɗyɛ womɛte. Ɛ ɓo ɗiki takina lɛpɔ kɛ mɔy mɛtemɔ man nde: ");
INSERT INTO kkj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‹Nan yi mbam kɔ lɛpina ɗekɛ kɛ́? A kɛ gbutɔ gba nɛ Njambiyɛ. Nda yakama tikɔ mɛɓeyɔ mɛ mumɔ nɛ ŋgwɛtɛ kɔ? Kinɛ mumɔ na, ndi Njambiyɛ nyɛpɔ!› ");
INSERT INTO kkj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus duwa̧ mɛtakɛ man kɛ mɔy temɔ nɛ kɛ kiya mbɛy. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kɛto ŋge yi wunɛ ɓɛ nɛ njɛl mɛtakɛ ɗete kɛ mɔy mɛtemɔ mun kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nɛ̀ lɛpinate nyɛ mɔ jɛmti nde: ‹Mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ,› nɛ̀ lɛpinate nde: ‹Tɛma, ɓoŋgɔ taŋ yɔ kɛndɔ,› kelna ŋge kwa̧ jɛwɔ kɛ njokate? ");
INSERT INTO kkj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yasi wɛtɛ, mi kɛ kwaɗyɛ nde, wunɛ dûkwɛ nde, *Mɔnɔ mumɔ nɛ ɗeti te yi tikɔ mɛɓeyɔ mɛ ɓomɔ nɛ ŋgwɛtɛ kɛ to mɛnɛti.» Ɗete, ɛ nyɛ lɛpɛ nyɛ mɔ jɛmti nde: ");
INSERT INTO kkj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mi kɛ lɛpɔ nyɛ wɛ nde: Tɛma, ɓoŋgɔ taŋ yɔ, ɗukwɛ kɛ̀ tu̧ yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɛ nyɛ tɛmɛ nɛ ŋgɛt ɓu̧ taŋ nɛ pundɔ nɔ kɛ misi mɛ ɓomɔ hɛnɛ. Ɛ ɓo hɛnɛ ŋgbakima ɓuɗyate lukse Njambiyɛ lɛpɔ nde: «Wusɛ tì pa ɓɛŋɛ yikɛ nɛ toru na!» ");
INSERT INTO kkj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kɛ kɔŋte, ɛ Yesus yɔkwɛ nɛ kɔkɔ kɛ̀ pulɔ goŋ nyaŋgwɛ matɔ. Ɓomɔ hɛnɛ ɗiyma nje kɛ yenɛ. Ɛ nyɛ ɗiki teɗye ɓo mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndana kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ kwa̧ kɛ́, ɛ nyɛ ɓɛŋɛ Levi te mɔnɔ Alfe mɛtiɗyɛ kɛ mbɛy komɛ ɓomɔ ɗiki gbo garama kɛ́. Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɓeŋgwɛ mi.» Ɛ Levi tɛmɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ɗyena kɛ tu̧ Levi ɓenɛ ɓejekɛ ɓenɛ kɛ́, ɛ ɓaŋa ɓuɗya ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓaŋa ɓotu ɓe mɛɓeyɔ nje ɗyena sendi ɓenɛ ɓo. Yo nde, ɓuɗya ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓuɗya ɓotu ɓe mɛɓeyɔ ɗikima ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kɛ ɓotu ɓe kɛtina mɛyasi ɓete ɓe ɓa̧ kɛ njɔŋ *Ɓefarisɛ̧ ɓaka ma ɓɛŋɛ nde, Yesus kɛ ɗyena ɓenɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe mɛɓeyɔ kɛ́, ɛ ɓo lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Kɛto ŋge yi nyɛ ɗyena kɛ kiya mbɛy ɓenɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe mɛɓeyɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kɛ Yesus ma wokɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yeti ɓotu ɓete ɓe nɛ mɛmbundɔ wɛynate ɓaka sa̧ nje mɔ nyɛti na, yasi wɛtɛ, yo ndi ɓotu ɓe kɔnɛ ɓaka. Mi ti njáki nje jeɓa ŋgbeŋ ɓomɔ na, mi njáki nje jeɓa ɓotu ɓe mɛɓeyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wɛtɛ yesɔ ɓejekɛ ɓe Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku nɛ̀ *Ɓefarisɛ̧ ɓa̧ kɛ kiyɔ mɛɗye. Ɛ ɓomɔ nje diyɛ Yesus nde: «Ɓejekɛ ɓe Jaŋ nɛ̀ ɓe Ɓefarisɛ̧ kɛ ɗiki kiyɔ mɛɗye. Ma kɛto ŋge yi ɓejekɛ te ɓɔ ti kél sendi ɗete kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ŋgɛ mumɔ kelɛ gwaki jeɓa ɓesɔ ɓenɛ kɛ mɛkeɓi mɛte, ’ɓesɔ ma kiyɔ mɛɗye piŋɔ te yi nyɛ ndi kɛte ɓenɛ ɓo kɛ́? Ko na, ŋgimɔ hɛnɛ te yi nyɛ ndi kɛte ɓenɛ ɓo, ɓo yeti nɛ ɗeti te yi kiyɔ mɛɗye na. ");
INSERT INTO kkj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yasi wɛtɛ, ŋgimɔ ta ɗya̧, ŋgimɔ te yi ɓo ta soŋɛ nɛ nyɛ kɛ mɛɓɔ man. Yo kɛ ŋgimɔ te yite yi ɓo ta kiyɔ mɛɗye yɛy. ");
INSERT INTO kkj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Mumɔ ti ɓóŋ pel jɔnja lambɔ nje datɔ kɛ lambɔ te yi ma ɓutɔ kɛ́ na. Kɛto ŋgɛ yo kelna ɗete, pɛl jɔnja te má nyukute njombu te. Ɔ ɓɛ́ŋa, nyal te má nje ɗɔkɔ kwa̧ to te. ");
INSERT INTO kkj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sendi, mumɔ ti sɔ́pita jɔnja mɛnjam nyɛ kɛ ɓɔru mɛmbe na. Kɛto ŋgɛ yo kelna ɗete, mɛnjam ta wuɗyɛ kelɔ nde, mɛmbe pôsukwɛ. Ɔ ɓɛ́ŋa, mɛnjam nɛ̀ mɛmbe ma si yambile gwe nyiŋɛ siri. Yo nde, mumɔ sɔ́pita mɛnjam nyɛ kɛ jɔnja mɛmbe.» ");
INSERT INTO kkj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wɛtɛ yesɔ Yesus ɓa̧ kɛ kwa̧ kɛ mɔy mɛŋgwaŋ mɛte yi ɓo ɓɛma nyambi te yi ɓo kelɛ nɛ mampa kɛ́. Yo ɓa̧ kɛ yesɔ *Saba. Ɛ ɓejekɛ ɓenɛ nyɛ ɓɔ kɛ lekina mɛto mɛte kwey nɛ kwey kwa̧ nɔ. ");
INSERT INTO kkj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɛ *Ɓefarisɛ̧ lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa ndi, kɛto ŋge yi ɓo kelɛ yasi te yi mɛmboŋga musu kiɗyɛ nde, mumɔ tî kel kɛ yesɔ Saba kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɛ Yesus yeŋsa nyɛ ɓo nde: «’Yite nde, wunɛ tì pa tɔlɔ yasi te yi kumande Davit kelma kɛ ŋgimɔ te yi yasi kwaŋma nyɛ yi nyɛ gwa̧ nja ɓenɛ ɓotu ɓenɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yo nde, a nyiŋma kɛ mbanjɔ Njambiyɛ kɛ ŋgimɔ te yi Abiyatar ɓa̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kɛ́, ɓu̧ mɛmampa mɛte yi ɗiyɛ kɛ mbanjɔ Njambiyɛ kɛ́ ɗye, ɓu̧ sendi yiŋa nyɛ ɓotu ɓenɛ. A kelma ɗete ko ɓɛkɔ nde, yo ndi ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓepɔ yâkaŋgwɛ ɗye yo.» ");
INSERT INTO kkj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Njambiyɛ tɛmbiɗya yesɔ Saba yi kamɛ nɛ mumɔ. A ti kúsu mumɔ kɛto yesɔ Saba na. ");
INSERT INTO kkj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɗete, yo mi *Mɔnɔ mumɔ ɗiyɛ ko nɛ yesɔ Saba sendi.» ");
INSERT INTO kkj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kɛ kɔŋte, ɛ Yesus kwa̧ nyiŋɛ wolo kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Wɛtɛ mbam ɓa̧ womɛte, ɓɔ nɛ ma jɛmɛ ɓɛ nɛ fɛŋgɛlɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓaŋa ɓomɔ ɓa̧ kɛ pɛmɔ Yesus yi ɓɛŋɛ, simande a ta siɗyɛ kɔn mumɔ kɛ yesɔ *Saba, nɛ́ ɓo kweɗya nje te yi lɛpɔ nde, a kelma yiŋa ɓeya yasi. ");
INSERT INTO kkj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ɛ Yesus lɛpɛ nyɛ mbam te yi ɓɔ nɛ ma jɛmɛ ɓɛ nɛ fɛŋgɛlɛŋ kɔ nde: «Tɛma womɛri kɛ ɓembe ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɛ Yesus nje diyɛ ɓo nde: «Mɛmboŋga mun lɛ́pi nɛ ŋge? ’Ɓo kâma mumɔ kɛ yesɔ Saba, ho ɓo kêl nyalɔ nɛ nyɛ? Nɛ̀ joŋgwa mumɔ nɛ̀ wona nɛ, yasi te nda yi mumɔ yâkaŋgwɛ kelɔ kɛ yesɔ Saba kɛ́?» Ɛ ɓo ɗiyɛ nɛ kpiŋgbili kinɛ ɓutɛ numbu na. ");
INSERT INTO kkj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɛ Yesus wokɛ ŋgambi kaŋɛ misi ɓɛŋɛ nɛ ɓo hɛnɛ kɔla, kɛto mɛtemɔ man ɓa̧ nɛ keskere. Ɛ nyɛ lɛpɛ nyɛ mbam kɔ nde: «Sambila ɓɔ.» Ɛ nyɛ sambile ɓɔ. Ɛ ɓɔ te yi ma jɛmɛ kɛ́ yɔkwɛ nje kɛ mbɛy te. ");
INSERT INTO kkj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ɛ *Ɓefarisɛ̧ pundɛ ɓekɛ ɓekɛ ɓenɛ ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ Kumande Herod ɓaka kɛ̀ kelɔ kutu yí sa̧ nje te yi ɓo yakama wo nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus jisima kwa̧ ɓenɛ ɓejekɛ ɓenɛ kɛ̀ pulɔ nyaŋgwɛ matɔ. Nyaŋgwɛ ŋgil ɓomɔ ɓeŋgwa nyɛ. Ɓo wúla Galile, ");
INSERT INTO kkj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","wulɛ Yerusalɛm nɛ̀ Yuda hɛnɛ, wulɛ Idume nɛ̀ pɔku te yi Tir nɛ̀ Sidɔn. Nyaŋgwɛ ŋgil ɓomɔ te nja̧ kɛ yi Yesus, kɛto ɓo wokuma mɛyasi hɛnɛ te yi nyɛ ɗikima kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde, ɓo ɓôŋ wɛtɛ mɔnɔ landi ɓakiɗye womɛte laɗye nɛ nyɛ, kambɔ nyiɓi nyiɓi ŋgil ɓomɔ te yikɛ mɛ nje matima nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yo nde, nda yi nyɛ ɗikima siɗyɛ kɔn ɓuɗya ɓomɔ ɗete kɛ́, ɛ ɓomɔ hɛnɛ ɓe ɓa̧ nɛ mboya mɛkɔn ɓaka ɗiki matima nyɛ yí sa̧ nje te yi kpokɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kɛ ɓɛ ɓeya mɛsisiŋ, ŋgimɔ hɛnɛ te yi ɓo ɗikima kaŋɛ misi ɓɛŋɛ nyɛ, ɓo ɗikima kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ kembiɗya nde: «Wɛ Mɔnɔ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yasi wɛtɛ, a ɗikima kiɗyɛ ɓo nde, kpɛ, ɓo tî kel nde, mumɔ dûkwɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus nja̧ kwa̧ ɓendɔ keki jeɓa ɓotu ɓete ɓe nyɛ kwaɗya nde, ɓo njâki ɓaka. Ɛ ɓo kɛ̀ kɛ kɛki nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ɛ nyɛ tɔkɛ ɓomɔ kamɔ jɔ yiɓa ɓe ta ɗiyɔ kɛ kɛki nɛ ɓaka, na tom ɓo sendi kɛnjɛ kɛ pelɛ Kimɔ Tom, ");
INSERT INTO kkj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nyɛ sendi ɓo ɗeti te yi soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mɛɗinɔ mɛ ɓomɔ kamɔ jɔ yiɓa te ɓe nyɛ tɔkuma ɓaka, yokɛ: Yo nɛ Simɔn te yi nyɛ loma nyɛ nde Piyɛr kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yo nɛ Jak te mɔnɔ Seɓede ɓenɛ maŋ wenɛ Jaŋ. Yesus loma ɓo nde Bowanɛrgɛs, yite nde Ɓɔnɔ ɓe lum mbiyɔ. ");
INSERT INTO kkj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yo nɛ Andere nɛ̀ Filip nɛ̀ Bartelemi nɛ̀ Matiyo nɛ̀ Tomasi nɛ̀ Jak te mɔnɔ Alfe nɛ̀ Tade ɓu̧ Simɔn te yi ɓo jeɓa nde Mɔnɔ kandɔ kɔ, ");
INSERT INTO kkj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nje ɓu̧ Yudas Iskariyot, mɔ te ɛ ɗyaŋgwa Yesus kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɗiyɔ kɛ́, ɛ Yesus nje yɔkwɛ kɛ̀ pɛ tu̧ ɓenɛ ɓejekɛ ɓenɛ. Ɓo tì ɓɛ nɛ mɔnɔ ŋgimɔ te yi ɗye mɔnɔ yaŋa na, kɛto nyaŋgwɛ ŋgil ɓomɔ nja̧ wesiɗya wolo komɛte. ");
INSERT INTO kkj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kɛ ɓemaŋ nɛ Yesus ma wokɔ ɗete kɛ́, ɛ ɓo kɛ̀, nɛ́ ɓo kɛ̀ ɓu̧ nyɛ kwa̧ nɔ, kɛto ɓo ɗikima lɛpɔ tandɛ yan nde: ‹A kɛ kɔnɔ nɛ to.› ");
INSERT INTO kkj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɛ ɓotu ɓe kɛtina mɛyasi ɓete ɓe wulma Yerusalɛm ɓaka lɛpɛ nde: «A nɛ *Kum ɓeya mɛsisiŋ te yi ɓo jeɓa nde *Belsebul kɔ kɛ yotu. A sóŋa ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗeti te yi Kum ɓeya mɛsisiŋ.» ");
INSERT INTO kkj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ndana, ɛ Yesus jeɓa ɓo lɛpɔ nyɛ ɓo nɛ nje kanɔ nde: «’*Satan nɛ ŋguru wenɛ yakama ɗuɗye yotu nɛ nɛ nje te yin? ");
INSERT INTO kkj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kɛ kiya ɓotu ɓe kandɔ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, kandɔ te tí kɛ̀ mbɔmbu na. ");
INSERT INTO kkj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sendi, kɛ kiya ɓotu ɓe mɔy tu̧ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, mɔy tu̧ te tí kɛ̀ mbɔmbu na. ");
INSERT INTO kkj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɗete, ŋgɛ Satan lu̧ ɗyambi suŋgwɛ nɛ yotu nɛ nɛ ŋguru wenɛ ɓakɛ yotu nɛ kɛ ɓembe, a tí kɛ̀ mbɔmbu joŋna na, yasi wɛtɛ, a ta yambile. ");
INSERT INTO kkj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mumɔ ti yaka nyiŋɛ kɛ tu̧ wɛtɛ ŋgaɓolo mbam yí wɛnjile mɛyasi mɛnɛ kinɛ pa kandɛ ɓiye nyɛ wotɔ nyɛ, na nje wɛnjile mɛyasi mɛnɛ na. Yo nde, ŋgɛ nyɛ si kandɛ wotɔ nyɛ, a má nje wɛnjile mɛyasi mɛ tu̧ ɗyenɛ yɛy. ");
INSERT INTO kkj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ: Njambiyɛ yakama tikɔ ɓomɔ nɛ ŋgwɛtɛ kɛ ɓeya yasi hɛnɛ te yi ɓo kelɛ nɛ̀ kɛ kwalɔ lɛpi gbutu hɛnɛ te yi ɓo yakama lɛpɔ suŋgwɛ nɛ nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yasi wɛtɛ, mumɔ hɛnɛ ɛ ta lɛpɔ lɛpi gbutu suŋgwɛ nɛ Kimɔ Sisiŋ, ko Njambiyɛ tí tikɔ mɔ te nɛ ŋgwɛtɛ wɛtɛ yesɔ na. Yo nde, mɛɓeyɔ mɛte ta ɗiyɔ kɛ to nɛ kpo nɛ kpo.» ");
INSERT INTO kkj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus lɛ́pi ɗete, kɛto ɓo ɗikima lɛpɔ nde, a nɛ ɓeya sisiŋ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Semɔ semɔ, ɛ nyaŋgwɛ nɛ Yesus ɓenɛ ɓemaŋ ɗya̧ ɗiyɔ kɛ sɛ̧ tomɔ mumɔ, na kɛ̀ jeɓa nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nyaŋgwɛ ŋgil ɓomɔ ɓa̧ mɛtiɗyɛ linje nyɛ. Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa, nyɔŋgwɛ kɛ sɛ̧ ɓenɛ ɓemɔŋ, ɓo kɛ ɗita wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ɛ nyɛ yeŋsa nde: «Nda nyaŋmbɛ? Ɓe nda ɓemaŋ ɓembɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɛ nyɛ kaŋɛ misi ɓɛŋɛ nɛ ɓotu ɓete ɓe ɓa̧ mɛtiɗyɛ linje nyɛ ɓaka lɛpɔ nde: «Nɛ ɓɛ̂ŋa, nyaŋmbɛ nɛ̀ ɓemaŋ ɓembɛ, ɓo ɓaka! ");
INSERT INTO kkj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yo nde, mumɔ hɛnɛ ɛ kelɛ yasi te yi Njambiyɛ kwaɗyɛ, mɔ te maŋmbɛ ho ɗyɔmbu ɗyembɛ ho nyaŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kɛ kɔŋte, ɛ Yesus ɓasiɗye nyɛ numbu kɛ teɗya ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ goŋ nyaŋgwɛ matɔ. Nyaŋgwɛ ŋgil ɓomɔ nja̧ wesiɗya kɛ kɛki nɛ. Ɛ nyɛ ɓendɛ wɛtɛ landi ɗiyɔ mɛtiɗyɛ kɛte kɛ to ɗuku. Ŋgil ɓomɔ hɛnɛ ɓa̧ kɛ ŋgindi kɛ goŋ. ");
INSERT INTO kkj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A ɓa̧ kɛ teɗye ɓo ɓuɗya mɛyasi nɛ nje mɛkanɔ. Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ teɗye ɓo mɛyasi kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Nɛ lɛ̂ŋgwɛ mɛtɔ kɛ yasi te yi mi ta lɛpɔ kɛ́. Wɛtɛ mɔ ɓɛna mbɛki kwaŋma kɛ̀ ŋgwaŋ yí kɛ̀ nyanje kwalɔ. ");
INSERT INTO kkj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ nyanje kwalɔ kɛ́, ɛ yiŋa ɓalɛ kɛ nje. Ɛ ɓenɔn si nje ɗye yo. ");
INSERT INTO kkj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yiŋa ɓalma kɛ mbɛy te yi ɓa̧ tandɛ mɛtari kinɛ ɓuɗya gbɛla mɛnɛti kɛte na. Ɛ yo lo nɛdɔ, kɛto mɛnɛti tì ɓɛ ɗimnate na. ");
INSERT INTO kkj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yasi wɛtɛ, kɛ yesɔ ma panɔ, ɛ yo si nyɔlɔ sɔsɔ, kɛto mɛkaŋgil mɛte tì kumɛ womaŋa na. ");
INSERT INTO kkj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yiŋa ɓalma kɛ mbɛy te yi ɓa̧ nɛ mɛŋgombiya kɛte kɛ́. Ɛ mɛŋgombiya ju̧ si ŋgaŋgile yo, kwalɔ te kinɛ nyɛ mɛmbumɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yiŋa kwalɔ nja̧ ɓalɔ kɛ kimɔ mɛnɛti. Ɛ yo ju̧ ɗɔkɔ wumɔ mɛmbumɔ. Kwalɔ te wɛtɛ nya mɛmbumɔ kamɔtati, ɛ wɛtɛ nyɛ kamɔtan jɔ kamɔ wɛtɛ, ɛ wɛtɛ nyɛ nɛ gɔmay.» ");
INSERT INTO kkj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kɛ kɔŋte, ɛ Yesus lɛpɛ nde: «Mɔ te ɛ nɛ mɛtɔ te yí wokɔ pɛ̧, a wôku!» ");
INSERT INTO kkj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kɛ nyɛ ma nje tika nyɛpɔ kɛ́, ɛ ɓotu ɓete ɓe ɓa̧ kɛ kɛki nɛ ɓaka, nɛ̀ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa diyɛ nyɛ to kanɔ te. ");
INSERT INTO kkj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yo ndi wunɛ yi Njambiyɛ nya ɗeti te yi duwɛ mɛyasi mɛte yi ma ɓɛ́ki sɔɗyate nɛ mbɔmbu kɛ kasi *Kandɔ Njambiyɛ kɛ́. Yasi wɛtɛ, kɛ yi gbɛla ɓomɔ, mɛyasi hɛnɛ kwáŋ nɛ nje mɛkanɔ. ");
INSERT INTO kkj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yo kwáŋnaŋgwɛ ɗete kɛ yan, nɛ́ ɓo ɓɛŋ yasi seŋgile kinɛ duwɛ yasi te yi ɓo ɓɛŋɛ kɛ́ na, nɛ́ ɓo lɛŋgwɛ mɛtɔ wokɔ kinɛ ɓiye to yasi te yi ɓo wokɛ kɛ́ na. Yo kélnaŋgwɛ ɗete, ma ɓo nje yeŋsa temɔ, ma Njambiyɛ nje tikɔ ɓo nɛ ŋgwɛtɛ kɛ ɓeya mɛkele man.» ");
INSERT INTO kkj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesus nja̧ kɛ̀ mbɔmbu lɛpɔ nyɛ ɓo nde: «’Yite nde, wunɛ yeti kɛ wokɔ to kanɔ te na? Ŋgɛ ɓɛ nde, wunɛ tì wokɛ na, nɛ ta kelɔ nan yí wokɔ nɛ to mɛkanɔ hɛnɛ? ");
INSERT INTO kkj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kwalɔ te yi mɔ ɓɛna mbɛki nyanja kɛ́, yo teɗya mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nje te yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ. Kɛ kɔŋte, *Satan nja̧ nɛdɔ nje soŋɛ mɛlɛpi mɛte yi nyiŋma kɛ temɔ yan kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mbɛy te yi ɓa̧ tandɛ mɛtari yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ, jayɛ yo nɛdɔ nɛ mɛsosa, ");
INSERT INTO kkj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ma ɓo tì pa lo mɛgata na. Ɗeti sumna kol kikwɛ yeti na. Ŋgɛ ɓo saŋgwa nɛ yiŋa mɛpɔku ho teɗye ɓo yiŋa mɛbɔnɛ kɛto mɛlɛpi mɛ Njambiyɛ kɛ́, ɔ ɓɛ́ŋa, ɓo jatiɗya kol kɛ ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mbɛy te yi ɓa̧ nɛ mɛŋgombiya yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ, ");
INSERT INTO kkj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yasi wɛtɛ, kɛsa temɔ kɛ mɛyasi mɛte yi ŋgimɔ te yɔkɔ nɛ̀ kasi kusuku te yi ɗiki seɓile temɔ ɓomɔ kɛ́ nɛ̀ yiŋa mɛwoɓɔ ma si nyiŋɛ temɔ yan ŋgaŋgile mɛlɛpi mɛ Njambiyɛ. Ɔ ɓɛ́ŋa, mɛlɛpi mɛ Njambiyɛ te yi ɓo wokuma kɛ́ tí kelɔ se yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma kimɔ mɛnɛti te yi yiŋa kwalɔ ɓalma kɛte kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ jayɛ yo kwa̧ wumɔ mɛmbumɔ. Wɛtɛ kɛ nyɛ kamɔtati, mbaŋa kɛ nyɛ kamɔtan jɔ kamɔ wɛtɛ, ma wɛtɛ kɛ kɛ̀ nyɛ nɛ gɔmay.» ");
INSERT INTO kkj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus ka̧ sendi mbɔmbu lɛpɔ nyɛ ɓo nde: «’Mumɔ kwénja ka lambo nje ɓu̧ mbe ɓusɛ nɔ ho ɓu̧ tikɔ kɛ nji̧ taŋ? ’A ti ɓóŋ kasɛ kɛ to teɓel na? ");
INSERT INTO kkj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kɛto kinɛ yaŋa te yi ɓɛ sɔɗyate yakama ɗiyɔ kinɛ pundɔ puyɛ na. Sendi, kinɛ yaŋa te yi ɓɛ sɔɗyate yakama ɗiyɔ nde, ɓomɔ tí duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mɔ te ɛ nɛ mɛtɔ te yí wokɔ nɛ pɛ̧, na woku!» ");
INSERT INTO kkj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ɛ Yesus nje lɛpɔ sendi nyɛ ɓo nde: «Wunɛ ɗîy nɛ sɔsɔ kɛ yasi te yi wunɛ wokɛ kɛ́. Njambiyɛ ta nyɛ wunɛ yasi ɓeŋgwɛ ndi kiya ɗɔkɔ mapi te yi wunɛ yekɛ nɛ yasi kɛte nyɛ ɓɛsɔ kɛ́. Ma a ta dokiɗye yiŋa yasi kɛ to te nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yo nde, ɓo ta dokiɗye yiŋa yasi nyɛ mɔ te ɛ mɛ nɔ kɔ. Ma pɛ yi yɔkɔ ɛ kinɛ yaŋa kɔ, ɓo ta soŋɛ ko mɔnɔ yasi te yi nyɛ nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus nja̧ kɛ̀ sendi mbɔmbu lɛpɔ nde: «*Kandɔ Njambiyɛ kwáŋnaŋgwɛ nda yi mumɔ kɛ̀ nyanje nɛ kwalɔ kɛ ŋgwaŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kɛ kɔŋte, ko a yâki ko a pɛ̂m tu nɛ yesɔ, kwalɔ kɛ lo nɛ ɗɔkɔ kinɛ nde, nyɛ nɛ ŋguru wenɛ dûkwɛ nda yi yo kwaŋna nɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mɛnɛti nɛ ŋguru wenɛ kɛ kelɔ nde, nyambi wûm kandɛ kɛ lonate kumɔ kɛ wumnate nje kumɔ kɛ ŋgimɔ te yi yo ta si tandɛ ɗetɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kɛ yo si ɗetɔ ɗete kɛ́, ɔ ɓɛ́ŋa, ndana ndana a nya ɓɔ kɛ mɛsay, kɛto ŋgimɔ soŋna nyambi kɛ ŋgwaŋ sima ɗya̧.» ");
INSERT INTO kkj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kɛ kɔŋte, ɛ Yesus nje lɛpɔ sendi nde: «Hɛ yakama lɛpɔ nde, *Kandɔ Njambiyɛ nda ŋge? Hɛ ta yekiɗye ɓa kwalɔ kanɔ te yɛn yí yekɔ nɔ? ");
INSERT INTO kkj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yo nda wɛtɛ kwalɔ mɔnɔ mbumɔ nde mutar yi ɓo ɓu̧ yikile kɛ mɛnɛti kɛ́. Mbumɔ te kwa̧ yɛlɔ kɛ njoka mɛkwalɔ hɛnɛ te yi ɗiyɛ kɛ to mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma yasi wɛtɛ, kɛ ɓo si yikile yo kɛ mɛnɛti kɛ́, yo kpál nje ju̧ ɗɔkɔ kwa̧ kwalɔ mɛnyiŋɔ hɛnɛ, nyɛ nyaŋgwɛ mɛɓɔ mɛte. Ɔ ɓɛ́ŋa, ɓenɔn má nje sumɔ mɛtu man kɛ mɛɓɔ mɛte joŋna kɛ wukumɛ te.» ");
INSERT INTO kkj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus ɗikima kwa̧ nɛ nje ɓuɗya mɛkanɔ nda yikɛ ɗekɛ yí lɛpɔ nɛ mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ. A ɗikima nyɛ mɛkanɔ saman te yi ɓo yakama ɓiye to te. ");
INSERT INTO kkj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yo nde, ko a tì lɛpina nyɛ ɓo kinɛ nyɛ kanɔ kɛte na. Yasi wɛtɛ, a ɗikima nɛmbɛ to mɛyasi hɛnɛ nyɛ ɓejekɛ ɓenɛ kɛ ŋgimɔ te yi ɓenɛ ɓo ɓɛ ɓepɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kɛ kiya yesɔ te ɓekoko ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wusɛ sâɓikwɛ nyaŋgwɛ matɔ kɛ̀ ŋginjɛ te yɔru.» ");
INSERT INTO kkj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɛ ɓo tikɛ ŋgil ɓomɔ ɓu̧ Yesus kwa̧ nɔ nɛdɔ nɛ landi te yi nyɛ ɓa̧ kɛ mɔyte kɔ. Yiŋa mɛlandi ɓa̧ sendi kɛ njɔŋ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ndana ndana, ɛ wɛtɛ nyaŋgwɛ mbuku ɗya̧. Ɛ mɛkumbɔ mɛnda kɛ landi. Ɛ landi kandɛ ɗyena mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yinɔri Yesus ɓa̧ nɛ kɛ jakɔ kɛ to filo, kɛ mɛta mɛ landi. Ɛ ɓo jemɛ nyɛ lɛpɔ nde: «Yekele, hɛ ta girɔ ndana, ’yo yeti kɛ kelɔ nɛ wɛ yaŋa na?» ");
INSERT INTO kkj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus jemiya ɓama nɛ mbuku lɛpɔ nyɛ nyaŋgwɛ matɔ nde: «Yo sîy ɗete. Wɛ tî wati na.» Ɛ mbuku siyɛ, ɛ yasi hɛnɛ yɔkwɛ ɓɛ nɛ tɛ nɛ sɛmyɛk. ");
INSERT INTO kkj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Kɛto ŋge yi wunɛ gwe wɔ̧ ɗete kɛ́? ’Yite nde, wunɛ yeti kɛ tikɔ temɔ nɛ mi na?» ");
INSERT INTO kkj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓo gwa̧ wɔ̧ ɓuɗyate, sosu nɛ hirek. Ɛ ɓo ɗiki lɛpɔ tandɛ yan nde: «Yɔkɔ ɓa kwalɔ mɔ te nda yi gba mbuku nɛ̀ nyaŋgwɛ matɔ wokuna nɛ nyɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɓo nja̧ saɓiyɛ kumɔ kɛ ŋginjɛ nyaŋgwɛ matɔ kɛ mɛnɛti mɛ ɓotu ɓe Gerasa. ");
INSERT INTO kkj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus piya kɛ landi yaka nɛ wɛtɛ mbam kɛ wulɛ kɛ mɛŋguku komɛ ɓo ɗikima pumbɔ ɓemuŋ kɛ́. A nja̧ saŋgwa nɛ Yesus. Mbam te ɓa̧ nɛ wɛtɛ ɓeya sisiŋ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A ɗikima ɗiyɔ kɛ mɛŋguku mɛte. Ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛ nɛ ɗeti te yi wotɔ nyɛ na, ko nɛ̀ mɛkɔl mɛ sumba. ");
INSERT INTO kkj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yo nde, ɓo ɗikima nyɛ mɛpoka kɛ mɛkol mɛnɛ wotɔ nyɛ nɛ mɛkɔl mɛ sumba. Ko ɗete, a ɗikima pamɔ mɛkɔl mɛ sumba lekɛ mɛpoka nɛ ɛsɛ ɛsɛ. Mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛ se nɛ ɗeti te yi kusɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A ɗikima ɗiyɔ tu nɛ yesɔ kɛ mɛŋguku mɛnɔri nɛ̀ kɛ to mɛkeki. A ɗikima ɗiyɔ ndi kembi, ndi tɛndina yotu nɛ mɛtari. ");
INSERT INTO kkj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ Yesus kɛ nje nɛ naŋ kɛ́, ɛ nyɛ sɛɗyɛ kɛ̀ kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ ");
INSERT INTO kkj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kembiɗya lɛpɔ nɛ mɛn kɛ kwey nde: «Yesus te Mɔnɔ Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ, sinɛ wɛ nɛ lɛpi te nda? Mi kɛ lɛpɔ nyɛ wɛ kɛ mbɔmbu Njambiyɛ nde, wɛ tî teɗya mi mɛbɔnɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A lɛ́pi ɗete, kɛto Yesus lɛpima nyɛ nyɛ nde: ‹Ɓeya sisiŋ, pundɔ ɗuwɛ kɛ yotu mbam kɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ɛ Yesus diyɛ nyɛ nde: «Ɗinɔ ɗyɔ nde nda?» Ɛ nyɛ yeŋsa nde: «Ɗinɔ ɗyembɛ nde Nyaŋgwɛ ŋgil, kɛto wusɛ nɛ ɓuyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɛ nyɛ ŋgwɛta ɓuɗyate nɛ Yesus nde, a tî lɔnjukwɛ ɓo nɛ pɔku mɛnɛti te yite na. ");
INSERT INTO kkj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nyaŋgwɛ kuru ɓeaɓem ɓa̧ kɛ ɗyena womɛte pulɔ to keki. ");
INSERT INTO kkj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɛ ɓeya mɛsisiŋ ŋgwɛta nɛ nyɛ lɛpɔ nde: «Kɛnjikwɛ wusɛ kɛ kuru ɓeaɓem ɓari, nɛ́ wusɛ kɛ̀ nyiŋ kɛ yotu yan.» ");
INSERT INTO kkj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɛ Yesus jayɛ. Ɛ ɓeya mɛsisiŋ pundɛ ɗuwɛ kɛ yotu mbam kɛ̀ nyiŋɛ ɓeaɓem. Ndana, ɛ kuru ɓeaɓem siliyɛ kombɔ nɛ ɓeya sokɔ nɛ bibibi kɛ̀ gwaɗya kɛ nyaŋgwɛ matɔ ɓeɓiye mɔrɔku si gwe. Ɓuyɔ yan kumma nda tomay yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ɛ ɓotu ɓete ɓe ɓa̧ kɛ ɓakiɗye ɓeaɓem ɓaka sɛɗyɛ kambɔ kwa̧ kɛ̀ yekiɗye kasi te kɛ nyaŋgwɛ ɗya nɛ̀ kɛ mɔnɔ mɛɗya. Ɛ ɓomɔ sutiyɛ kɛ̀ ɓɛŋɛ yasi te yi kwaŋnama kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓo ka̧ kumɔ komɛ Yesus ɓa̧ kɛ́. Ɛ ɓo ɓɛŋɛ mbam te ɛ ɓa̧ nɛ ɓeya mɛsisiŋ nɛ mbɔmbu kɛ yotu kɔ kɛ ɗiyɔ wɛynate nɛ mɛlambɔ kɛ yotu, gba nyɛ mɔ te ɛ ɓa̧ nɛ ŋgil ɓeya mɛsisiŋ kɛ yotu kɔ. Ɛ ɓomɔ gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓotu ɓete ɓe ɗiyma kɛ mbɛy te ɓaka yekiɗya mɛyasi mɛte yi ɓo ɓɛŋma kɛ́ nyɛ ɓo. Kandɛ kɛ yi mɔ te ɛ ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu kɔ kumɔ kɛ yi ɓeaɓem. ");
INSERT INTO kkj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɗete, ɛ ɓotu ɓaka nyɛ numbu kɛ mɛŋgwɛta nɛ Yesus nde, a kwâŋ lɔndɔ kɛ mɛnɛti man. ");
INSERT INTO kkj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ɓendɔ landi kɛ́, ɛ mbam te ɛ ɓa̧ nɛ ɓeya mɛsisiŋ nɛ mbɔmbu kɛ yotu kɔ diyɛ nyɛ nde, a kɛ kwaɗyɛ kwa̧ ɓenɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yasi wɛtɛ, Yesus tì jayɛ na, a lɛpima nyɛ nyɛ nde: «Ɗukwɛ kɛ̀ tu̧ ɗyɔ suŋgwɛ ɓotu ɓɔ, nɔ̀ yêkiɗya mɛyasi hɛnɛ te yi Baba Mbokɔ kelma nɛ wɛ kɛ́ nyɛ ɓo, yekiɗye sendi nda yi nyɛ gwa̧ nɛ ŋgwɛtɛ wɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ndana, ɛ mbam kwa̧. Ɛ nyɛ kandɛ pelna yasi hɛnɛ te yi Yesus kelma kɛ yotu nɛ kɛ́ kɛ nyaŋgwɛ mɛɗya kamɔ te yi ɓa̧ kɛ mɛnɛti mɛte kɛ́. Ɛ ɓomɔ hɛnɛ ŋgbakima. ");
INSERT INTO kkj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus kwaŋma nɛ landi yɔkwɛ nɛ kɔkɔ kumɔ kɛ ŋginjɛ te yɔru. Ɛ nyaŋgwɛ ŋgil ɓomɔ nje wesiɗya kɛ kɛki nɛ. A ɓa̧ kɛ ŋgindi kɛ goŋ nyaŋgwɛ matɔ. ");
INSERT INTO kkj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɛ wɛtɛ kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn ɗya̧. Ɗinɔ ɗyenɛ nde Yayrus. Kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ Yesus kɛ́, ɛ nyɛ nje ɓalɔ kɛ nji̧ mɛkol mɛnɛ ");
INSERT INTO kkj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ŋgwɛta ɓuɗyate nɛ nyɛ lɛpɔ nde: «Tiso mɔnmbɛ, mɔnɔ nyari ta gwe ndana! Inja kasɛ mɛɓɔ kɛ yotu nɛ, nɛ́ kɔn nɛ siy, na ju̧.» ");
INSERT INTO kkj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɛ Yesus kwa̧ ɓenɛ nyɛ. Nyaŋgwɛ ŋgil ɓomɔ ɓa̧ kɛ ɓeŋgwɛ nyɛ nɛ suk suk matima nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yinɔri wɛtɛ nyari ɓa̧ kɛ njoka ŋgil, mɛkiyɔ ɓa̧ kɛ lekwɛ nyɛ, yo mɛ kɛ mɛsew kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A ɓɛŋma mɛbɔnɛ ɓuɗyate kɛ ɓeŋgwa ɓuɗya ɓotu ɓe nyɛti kɛ̀ nɔ. A kwaŋɗya mɛyasi hɛnɛ te yi ɓa̧ nde, a jôŋnaŋgwɛ nɔ kɛ́, ko wokɔ mɔnɔ mɛkamna nɛ mbɛt na. Kɔn kpalma ɗɔkɔ ɗɔkɔ kɛ̀ nɔ mbɔmbu. ");
INSERT INTO kkj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A wokuma ɓomɔ kɛ lɛpɔ kasi Yesus. Ɛ nyɛ kwa̧ nɛ pulɔ kɔŋ ɓomɔ nyiŋɛ mɔy ŋgil kpokɛ lambɔ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kɛto nya kɔ ɗikima lɛpɔ kɛ mɔy temɔ nɛ nde: ‹Ŋgɛ mi kpokɛ ndi gbɛla lambɔ nɛ, kɔn mbɛ ta siyɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndana ndana, ɛ mɛkiyɔ mɛte yi ɓa̧ kɛ lekwɛ nyɛ kɛ́ pɛsiyɛ kɛ kiya mbɛy. Ɛ nyɛ wokɛ kɛ mɔy yotu nɛ duwɛ nde, kɔn nɛ siyma. ");
INSERT INTO kkj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ndi kɛ kiya mbɛy sendi Yesus duwa̧ nde, yiŋa ɗeti nɛ ɗuwa̧ kɛ yotu nɛ. Ɛ nyɛ yeŋsa kɛ njoka ŋgil diyɛ nde: «Nda kpokuma lambɔ mbɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɛ ɓejekɛ ɓenɛ yeŋsa nyɛ nyɛ nde: «Wɛ kɛ ɓɛŋɛ nde, ɓomɔ ɗekɛ nɛ suk suk kɛ matima wɛ, kɛ kɔŋte, wɛ kɛ kpalɔ diyɛ nde: ‹Nda kpokɛ mi?› » ");
INSERT INTO kkj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesus ka̧ mbɔmbu ŋgɛkila, na ɓɛŋ mɔ te ɛ kelma yasi yinɔri kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nyari gwa̧ wɔ̧ ŋgwaŋgwa, kɛto a duwa̧ yasi te yi ɗyaŋma nyɛ kɛ́. Ɛ nyɛ nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus lɛpɔ yasi hɛnɛ te yi kwaŋnama kɛ́ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Mɔnmbɛ, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ. Kwaŋgɔ nɛ tɛ, kɔn yɔ siyma nɛ kpaya.» ");
INSERT INTO kkj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus ɓa̧ ndi kɛ lɛpina ɗete kɛ́, yaka nɛ ɓomɔ kɛ wulɛ kɛ tu̧ Yayrus te kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nje lɛpɔ nyɛ nyɛ nde: «Wɛ njáŋgwɛ sendi yekele nɛ ŋge, ŋgɔndu wɔ tì si gwe.» ");
INSERT INTO kkj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yasi wɛtɛ, Yesus wokuma lɛpi te pupɛ mɛtɔ, ɛ nyɛ lɛpɛ nyɛ Yayrus te kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nde: «Wɛ tî gwaki wɔ̧ yaŋa na, siya te ndi nde, tikɔ temɔ kɛ yembɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus tì jayɛ nde, wɛtɛ mumɔ ɓeŋgwɛ nyɛ na, soŋɛ ndi Piyɛr nɛ̀ Jak ɓenɛ maŋ wenɛ Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɛ ɓo kwa̧ kumɔ kɛ tu̧ kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɔ. Ɛ Yesus dolɛ ɓomɔ nɛ ho, ɓaŋa ɓa̧ kɛ lelɔ kembiɗya nɛ kpɛ̧. ");
INSERT INTO kkj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɛ Yesus nyiŋɛ tu̧, lɛpɔ nyɛ ɓomɔ nde: «Ho te yikɛ yi wunɛ kelɛ kɛ́, yo kɛto ŋge? Kɛto ŋge yi wunɛ lelɛ kɛ? Mɔnɔsikɛ tì gwe na, a kɛ jakɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɛ ɓo nyɛtɛ nyɛ. Ɗete, ɛ nyɛ punjɛ ɓo hɛnɛ kɛnjɛ sɛ̧. Ɛ nyɛ ɓu̧ ndi saŋgwɛ nɛ mɔnɔ nɛ̀ nyaŋgwɛ nɛ mɔnɔ nɛ̀ ɓotu ɓete ɓe nyɛ nja̧ ɓenɛ ɓo ɓaka nyiŋɛ nɔ kɛ mbɛy komɛ muŋ mɔnɔsikɛ ɓa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɛ nyɛ ɓiye mɔnɔsikɛ kɛ ɓɔ lɛpɔ nde: «Talita kumi!» Yite nde: ‹Mɔnɔ ŋgɔndu, mi kɛ lɛpɔ nyɛ wɛ nde: Tɛma.› ");
INSERT INTO kkj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɛ mɔnɔ ŋgɔndu tɛmɛ ndi nɛ ŋgɛt kɛ kiya mbɛy nyɛ kol kɛ kɛndi. A ɓa̧ nɛ mɛsew kamɔ jɔ yiɓa. Ɛ ɓo ŋgbakima ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ɛ Yesus lɛpɛ nyɛ ɓo nde, kpɛ, mumɔ tî dukwɛ yasi te yi kwaŋnama kɛ́ na. Ɛ nyɛ nje lɛpɔ nde, ɓo nyɛ̂ki mɔnɔsikɛ mɛɗye. ");
INSERT INTO kkj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus punduma womɛte kwa̧ kɛ̀ kɛ ɗya ɗyenɛ. Ɛ ɓejekɛ ɓenɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kɛ yesɔ *Saba ma ɗya̧ kɛ́, ɛ nyɛ kandɛ teɗya ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Ɓuɗya ɓotu ɓete ɓe ɗikima lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ ɓa̧ kɛ lɛpɔ kɛ́ ŋgbakimama. Ɛ ɓo ɗiki lɛpɔ nde: «Mbam te yɔkɔ kwéɗyaŋgwɛ yikɛ we? Njɛl ɗyanɔ te yikɛ wúla nyɛ we? Ma ɗeti kelna kwalɔ nyaŋgwɛ mɛkele mɛte yikɛ wúla ɓa nyɛ we? ");
INSERT INTO kkj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","’A yeti kapinda, mɔnɔ Mariya na? ’Yeti maŋ nɛ Jak nɛ̀ Yosɛs nɛ̀ Yude nɛ̀ Simɔn na? ’Sinɛ ɓeɗyɔmbu yeti waka na?» Ma pɛ yan, ɓo ɓɛŋma nde, a ɓa̧ yasi te yi jatiɗya ɓo kɛnjɛ kɛ ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yasi wɛtɛ, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Ɓo ti lúksa mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ ɗya ɗyenɛ, kɛ njoka ɓejaɗyɛ ɓenɛ ho kɛ mɔy kandɔ ɗyenɛ na. Ɓo lúksa ndi nyɛ kɛ yiŋa mɛmbɛy.» ");
INSERT INTO kkj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɗete, yo kelma nde, a tî kel yiŋa nyaŋgwɛ mɛkele womɛte na. A kasa ndi mɛɓɔ kɛ yotu ɓaŋa ɓotu ɓekɔn nɛ mbɛt siɗyɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus ŋgbakimama kɛto ɓo tì tikɛ temɔ kɛ yenɛ na. Kɛ kɔŋte, ɛ nyɛ kwa̧ kɛndɔ saŋgwɛ mɛɗya mɛte yi ɓa̧ kɛ poku te yite kɛ́, teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ndana, ɛ Yesus jeɓa ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kandɛ tomna yan yiɓa yiɓa. A nya ɓo ɗeti te yi soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɛ nyɛ lɛpɛ nyɛ ɓo nde, kpɛ, ɓo tî ɓiya yaŋa kwa̧ nɔ na, soŋɛ ndi toŋgolo. Ɓo tî ɓiya ko mɛɗye ko koɓiyɛ ko mɔnɔ litɔ mɔni ɓakiɗye kɛ jon na. ");
INSERT INTO kkj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ndi nde, ɓo yakama lɛŋɛ mɛnakala, ma mumɔ tî dokiɗya lambɔ yiɓa kɛ yotu kwa̧ nɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Tu̧ hɛnɛ te yi wunɛ ta nyiŋɛ ya te, wunɛ ɗîy ndi womɛte kumɔ kɛ ŋgimɔ te yi wunɛ ta kwa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma ŋgɛ wunɛ kumɛ kɛ yiŋa mbɛy nde, ɓomɔ tì ɓu̧ wunɛ kimɔte ho wokɔ mɛlɛpi mun na, nɛ wunɛ kwâŋ womɛte. Komɛ wunɛ ta tɛmɛ yí kwa̧ kɛ́, nɛ̀ wunɛ kûtu ŋgbutu te yi ndama kɛ mɛkol mun kɛ́ yí teɗye ɓo nde, ɓo kelma ɓeyate.» ");
INSERT INTO kkj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɓo tɛmma kwa̧ yí kɛ̀ pelɛ mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ nde, ɓo yêŋsaŋgwɛ temɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓo soŋma ɓeya mɛsisiŋ ɓuɗyate kɛ yotu ɓomɔ, lɔmbɛ mutɔ kɛ yotu ɓuɗya ɓotu ɓekɔn yí siɗyɛ nɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kumande Herod wokuma kasi Yesus, kɛto ɗinɔ ɗyenɛ ɓa̧ kɛ wumɔ ɓuɗyate kɛ mɛmbɛy hɛnɛ. Ɓo ɗikima lɛpɔ nde: «Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku womiya kɛ njoka ɓemuŋ, yori yi nyɛ ɓɛ nɛ ɗeti te yi kelɔ nyaŋgwɛ mɛyekambiyɛ te yikɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɓaŋa ɓomɔ ɗikima lɛpɔ nde: «Yo Eli.» Ɓaŋa nde: «Yo ndi wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ nda ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yasi wɛtɛ, kɛ Herod ma wokɔ mɛyasi mɛte yi Yesus ɗikima kelɔ kɛ́, ɛ nyɛ lɛpɛ nde: «Gba Jaŋ te yi mi lɛpima nde, ɓo pɛ̂si to nɛ kɔ, yo nyɛ womiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yo nde, Herod nɛ ŋguru wenɛ tomma ɓomɔ kɛ̀ ɓiye nɛ Jaŋ nyɛ kɛ jɔɓɔ kwa̧ wotɔ nyɛ. Herod kelma ɗete, kɛto nyɛ Herod sukuma Herodiyas te nya maŋ wenɛ Filip kɛ mɛɓɔ mɛnɛ ɓu̧ nyɛ nɛ mɛgwaki. ");
INSERT INTO kkj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ɛ Jaŋ ɗiki lɛpɔ nyɛ nyɛ nde: ‹Yo ti yaka nde, ɓoŋgɔ nya mɔŋ nɛ mɛgwaki na.› ");
INSERT INTO kkj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ɗete, ɛ Herodiyas ɓakiɗye ŋgɔl te kɛ temɔ suŋgwɛ nɛ Jaŋ, sa̧ nje te yi wo nyɛ. Ma yasi wɛtɛ, a gɔsuma nje te deŋgɔ, ");
INSERT INTO kkj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kɛto Herod ɓa̧ kɛ kambɔ Jaŋ. A duwa̧ nde, Jaŋ ɓa̧ nɛ ŋgbeŋ kinɛ mɛjɔsɔ kɛ yiŋa yasi na. Herod ɓa̧ kɛ kambiɗya nɛ nyɛ ɓuɗyate. Mɛŋgimɔ hɛnɛ te yi nyɛ wokɛ yasi te yi pundɛ kɛ numbu Jaŋ, a ɗikima ɗiyɔ sosu nɛ ham, ndi nde, a ɓa̧ nɛ mɛsosa yí wokɔ mɛyasi mɛte yi Jaŋ ɗikima lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wɛtɛ yesɔ ɛ yiŋa kimɔ ŋgimɔ ɗya̧ kɛ yi Herodiyas. Yo ɓa̧ kɛ ŋgimɔ te yi Herod ɓa̧ kɛ kelɔ jesɔ yesɔ jariki nɛ kɛ́. A kelma nyaŋgwɛ dina jeɓa nɛ nyaŋgwɛ ɓekum ɓenɛ nɛ̀ ɓekum ɓesɔja nɛ̀ kpasa ɓomɔ ɓe mɛnɛti mɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɗiyɔ kɛ́, ɛ ŋgɔndu Herodiyas nyiŋɛ tu̧ ɓɔlɔ jesɔ. Ɛ yo ɓiye temɔ Herod nɛ̀ ɓotu ɓete ɓe ɓa̧ kɛ mbɛy mɛɗye ɓenɛ ɓo ɓaka. Ɛ kumande Herod lɛpɛ nyɛ ŋgɔndu nyari nde: «Diya mi yasi hɛnɛ te yi wɛ kwaɗyɛ, mi ta nyɛ wɛ yo.» ");
INSERT INTO kkj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herod kinjama yotu lɛpɔ nyɛ nyɛ nde: «Yasi hɛnɛ te yi wɛ ta diyɛ, ko ŋge, mi ta nyɛ wɛ yo. Ko ɓɛkɔ nde, mi pɛ̂si mɛnɛti mɛte yi mi namɛ kɛ́ kɛ ɓembe ɓu̧ pɛl te wɛtɛ nyɛ wɛ, mi ta kelɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mɔnɔ nyari punduma kɛ̀ dolɔ nyaŋgwɛ lɛpɔ nyɛ nyɛ nde: «Mi dîya ɓa ŋge?» Ɛ nyɛ yeŋsa nde: «Diya to Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku.» ");
INSERT INTO kkj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɛ nyɛ yɔkwɛ ɓekɛ ɓekɛ nyiŋɛ tu̧ kɛ̀ nɛdɔ kɛ yi kumande Herod lɛpɔ nde: «Mi kwáɗyikwɛ nde: Nyɛkɔ mi to Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku ndana ndana waka kɛ mɔy pan.» ");
INSERT INTO kkj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yo nya kumande Herod ŋgambi ɓuɗyate, ma kɛto a sima kinja nɛ̀ kɛto mbɛri misi mɛ ɓotu ɓete ɓe nyɛ jeɓama ɓaka, a tì kwaɗyɛ pitiɗye numbu se na. ");
INSERT INTO kkj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɗete, ɛ nyɛ tomɛ wɛtɛ sɔja te ɛ ɓakiɗye nyɛ kɔ nɛdɔ lɛpɔ nde, a kwâŋ ɓekɛ ɓekɛ yɔkwɛ nɛ to Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɛ sɔja kwa̧ kumɔ kɛ tu̧ jɔɓɔ pɛsɔ to Jaŋ nyɛ kɛ mɔy pan ɗya̧ nɔ kaŋɛ nyɛ ŋgɔndu nyari. Ɛ nyɛ nje kaŋɛ nyɛ nyaŋgwɛ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kɛ ɓejekɛ ɓe Jaŋ ma wokɔ kasi te kɛ́, ɛ ɓo kɛ̀ ɓu̧ muŋ nɛ kɛ̀ pumbɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɓotu ɓe tomun ɓe Yesus nja̧ yɔkwɛ, ɛ ɓo nje wesiɗya kɛ kɛki nɛ. Ɓo yekiɗya mɛyasi hɛnɛ te yi ɓo kelma nɛ̀ yi ɓo teɗya kɛ́ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ njâki woŋga tandɛ yun, nɛ́ wusɛ kwa̧ kɛ̀ kɛ mbɛy te yi kinɛ ɓomɔ kɛte kɛ́, nɛ́ wunɛ pa wɛɗya nɛ mbɛt.» A lɛ́pi ɗete, kɛto ɓomɔ ɓa̧ kɛ nje ɗuwɛ nɛ gbiti gbiti, ŋgimɔ te yi ɓo ta ɗye nɛ mɔnɔ yaŋa tì ɓɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɗete, ɛ ɓo kwa̧ nɛ landi yí kɛ̀ kɛ yiŋa mbɛy te yi ɓa̧ nɛ sɛnjɛnjɛ kinɛ ɓomɔ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko ɗete, ɓuɗya ɓomɔ semma ɓo kɛ kwa̧, ɛ ɓo duwɛ ɓo. Ɛ ɓomɔ sutiyɛ kɛ mɛɗya hɛnɛ pɛsa kol nɛ kol ɓekɛ ɓekɛ kandɛ kumɔ nɛ ɓo kɛ mbɛy te yi ɓo kɛ̀ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kɛ Yesus ma piyɛ kɛ landi kɛ́, a ɓɛ́ŋa nyaŋgwɛ ŋgil ɓomɔ kɛ. Ɛ nyɛ gwe ŋgwɛtɛ yan ɓuɗyate, kɛto ɓo ɓa̧ nda ɓesam ɓete ɓe kinɛ mɔ ɓakiɗya yan ɓaka. Ɛ nyɛ kandɛ teɗya yan ɓuɗya mɛyasi. ");
INSERT INTO kkj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɓekoko sima ɗya̧, ŋgimɔ ma kwa̧ ɓuɗyate, ɛ ɓejekɛ ɓe Yesus kɛ̀ kɛ kɛki nɛ lɛpɔ nde: «Waka koŋgor, ŋgimɔ sima kwa̧ sendi ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tikɔ, nɛ́ ɓo kwa̧ kɛ̀ kɛ mɛlunde nɛ̀ kɛ mɛɗya mɛte yi kɛ pɔku te yi waka kɛ́, nɛ́ ɓo kɛ̀ ɓɔm yasi te yi ɓo yakama ɗye.» ");
INSERT INTO kkj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ndi gba wunɛ nɛ ŋguru wun nyɛ̂ki ɓo mɛɗye.» Ɛ ɓo nje yeŋsa nyɛ nyɛ nde: «’Wusɛ ɓôŋ ka ndi mɔni te yi yakama gbo mɔ mɛsay kɛ mɛyesɔ mɛsay gɔmay yiɓa kɛ́ kɛ̀ ɓɔmɔ nɛ mɛɗye nje nyɛ ɓo?» ");
INSERT INTO kkj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ɛ Yesus diyɛ ɓo nde: «Wunɛ nɛ mampa niŋgɔ? Wunɛ pâŋ kɛ̀ ɓɛŋɛ.» Ɛ ɓo kwa̧ kɛ̀ ɗita yɔkwɛ nje lɛpɔ nde: «Yo nɛ mampa yitan nɛ̀ ɓenjanjɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ɛ nyɛ lɛpɛ nyɛ ɓo nde, ɓo lɛ̂pi nyɛ ɓomɔ hɛnɛ nde, ɓo ɗîy ɗiyɔ nɛ mɛnjɔŋ mɛte kɛ to mɛmbunjɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɛ ɓomɔ kwa̧ ɗiyɔ nɛ mɛnjɔŋ mɛte, ɓaŋa kamɔtan kamɔtan, ɓaŋa gɔmay gɔmay. ");
INSERT INTO kkj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ɛ nyɛ nje ɓu̧ mampa yinɔri yitan nɛ̀ ɓenjanjɔ ɓenɔri yiɓa kaŋɛ misi kɛnjɛ kwey nyɛ Njambiyɛ wosoko. Kɛ kɔŋte, ɛ nyɛ nje lekɛ yo kaŋɛ nyɛ ɓejekɛ ɓenɛ, nɛ́ ɓo kaɓi nyɛ ŋgil ɓomɔ. Ɛ nyɛ kaɓɛ sendi ɓenjanjɔ ɓenɔri yiɓa yaka nɛ ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓomɔ hɛnɛ ɗyenama ditɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ɛ ɓo nje wesiɗye ɓukwɛ mampa nɛ̀ ɓukwɛ njanjɔ tonjɛ mɛmakɔ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kɛ njoka ɓotu ɓete ɓe ɗyenama ɓaka ɓembam nɛ ɓembam kumma ɓomɔ tomay yitan. ");
INSERT INTO kkj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ndana ndana kɛ kɔŋte kɛ́, ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde, ɓo ɓêndi landi kandɛ saɓiyɛ kɛ̀ ŋginjɛ te yɔru kɛ pulɔ Betsayda, na pa tika lɛpɔ nyɛ ŋgil ɓomɔ nde, ɓo sîki ɗuwɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kɛ ŋgil ma si kwa̧ kɛ́, ɛ nyɛ kwa̧ ɓendɔ keki yí kɛ̀ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tu yinjama dolɔ ɓejekɛ nɛ̀ landi kɛ ɓembe sombu, ndi Yesus tikama nyɛpɔ kɛ ŋgindi. ");
INSERT INTO kkj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesus ɓɛŋma nde, ɓejekɛ kɛ saŋgwa nɛ mɛbɔnɛ ɓuɗyate yí ɗukɔ nɛ landi, kɛto ɓo kɛ kɛ̀, pupɔ kɛ nje njakɔ kɛ mbɔmbu yan mata ɓo. Kɛ pɔku njenamɛnɔ, ɛ Yesus kandɛ kɛndi kɛ to ɗuku kɛ̀ nɔ pulɔ yan. A diyma kwa̧ ɓo kwaŋgɔ. ");
INSERT INTO kkj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kɛ ɓo ma ɓɛŋɛ nyɛ kɛ kɛndɔ kɛ to ɗuku kɛ́, ɛ ɓo takɛ nde, yo ablasa. Ɛ ɓo kandɛ kembi. ");
INSERT INTO kkj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɓo hɛnɛ ɓɛŋma nyɛ, ɛ ɓo gwe wɔ̧ ɓuɗyate. Ndana, kɛ Yesus ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ ɓetɛ mɛn kɛnjɛ ɓo lɛpɔ nde: «Nɛ tî kambi na, yo mi, nɛ tî gwaki wɔ̧ na.» ");
INSERT INTO kkj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A ka̧ kɛ̀ dolɔ ɓo ɓendɔ landi. Ɛ pupɔ siyɛ. Ɛ ɓo ŋgbakima ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ɓo ŋgbakimama, kɛto ɓo tì ɓiye to yasi te yi kwaŋnama kɛ mɛyekambiyɛ mɛte yi nyɛ kelma yí nyɛ nɛ ɓomɔ mampa kɛ́ na. Ɓo tì ɓiye to te na, yo nde, mɛtemɔ man ɓa̧ nɛ keskere. ");
INSERT INTO kkj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓo saɓiya nyaŋgwɛ matɔ kumɔ ŋginjɛ te yɔru kɛ mɛnɛti mɛ Genesarɛt kwa̧ ɓendɔ ŋgindi. ");
INSERT INTO kkj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ndi nɛ piya te yi ɓo piya kɛ landi kɛ́, ɛ ɓomɔ duwɛ nde, yo Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɛ ɓo kɛ̀ kɛ pɔku te yinɔri hɛnɛ, kandɛ soɓuna ɓotu ɓekɔn kɛ mɛtaŋ kɛ̀ nɔ kɛ mbɛy hɛnɛ te yi ɓo wokuma nde, a kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kɛ mbɛy hɛnɛ te yi nyɛ nya kol kɛte, ko kɛ mɔnɔ mɛɗya ko kɛ nyaŋgwɛ mɛɗya ko kɛ mɛlunde, ɓo ɗikima ɓu̧ ɓotu ɓe kɔn nje tikɔ kɛ mɛmbɛy mɛte yi ɓomɔ ɗiki wesiɗya kɛte kɛ́. Ɛ ɓo ɗiki ŋgwɛta nɛ nyɛ nde, a jâya nde, ɓotu ɓekɔn kpôka ndi gbɛla numbu lambɔ nɛ lalɛ. Ɗete, ɓaka hɛnɛ ɓe kpokuma numbu lambɔ nɛ, mɛkɔn man siyma. ");
INSERT INTO kkj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Ɓefarisɛ̧ nɛ̀ ɓaŋa ɓotu ɓe kɛtina mɛyasi ɓe wulma Yerusalɛm ɓaka nja̧ wesiɗya kɛ kɛki Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓo ɓɛŋma ɓaŋa ɓejekɛ ɓenɛ kɛ ɗyena nɛ mɛɓɔ mɛte yi kpokuma yiŋa yaŋa te yi nyɛ sɛmbɔ kɛ́. Yite nde, ɓo tì weyɛ mɛɓɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yo nde, Ɓefarisɛ̧ ko Ɓeyudɛn hɛnɛ ti ɗyénaŋgwɛ kinɛ pa weyɛ mɛɓɔ kimɔte, ɓeŋgwɛ mɛkele mɛte yi wulma nɛ ɓesaŋmbambɔ ɓan kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sendi, kɛ ɓo yɔkwɛ kɛ mɔy sɛ̧, ɓo yeti nɛ ɗeti te yi ɗyena kinɛ pa weya na. Ɓo sendi nɛ ɓuɗya yiŋa mɛkele mɛte yi ɓo ɓakiɗye yi wulma nɛ ɓetomba nda weyna mɛpelɔ nɛ̀ mɛmbe nɛ̀ mɛjɔlɛ mɛte yi sumba nɛ̀ mɛtaŋ. ");
INSERT INTO kkj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ɛ Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi diyɛ Yesus nde: «Kɛto ŋge yi ɓejekɛ ɓɔ ti ɓéŋgwɛ mɛkele mɛte yi wulma nɛ ɓesaŋmbambɔ ɓusu kɛ́? Kɛto ŋge yi ɓo ɗyena nɛ mɛɓɔ mɛte yi kpokuma yiŋa yasi te yi nyɛ sɛmbɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Wunɛ ɓotu ɓe likisi! Lɛpi te yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ kasi yun kɛ́ ɓa̧ gbakasi. Yo nda yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓotu ɓaka kán mi kɛ kondɔ numbu, yasi wɛtɛ, temɔ yan lɔndunate nɛ mbi̧ nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kannate yi ɓo kanɛ nɛ mi kɛ́ gba gbɛlate. Ɓo téɗya ndi mɛyasi mɛte yi wulɛ kɛ pɛsina te yi ɓomɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wunɛ kɛ tikɔ mɛmboŋga mɛ Njambiyɛ kpalɔ ɓakiɗye mɛkele mɛte yi wulma nɛ ɓetomba kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A ka̧ mbɔmbu lɛpɔ nyɛ ɓomɔ nde: «Wunɛ kɛ kombile payɛ mɛmboŋga mɛ Njambiyɛ, nɛ́ wunɛ nje ɓakiɗye mɛkele mun yi wunɛ ma wúla nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ma Mɔyisi lɛpima nde: ‹Jɛsɔ sɔŋgwɛ ɓenɛ nyɔŋgwɛ.› Sendi: ‹Yɔkɔ ɛ ta lɛpina ɓeyate nɛ saŋgwɛ ho nɛ nyaŋgwɛ, ɓo wôku nyɛ.› ");
INSERT INTO kkj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ma kɛ yun, wunɛ lɛ́pi yun nde: ‹Ŋgɛ mumɔ lɛpɛ nyɛ saŋgwɛ ho nyɛ nyaŋgwɛ nde: Kɔrbaŋ, yite nde: ‹Yasi te yi mi diyma kamɛ nɛ wɛ kɛ́, mi sima si nyɛ Njambiyɛ yo nɛ sadaka.› Kɛ yite, wunɛ lɛ́pi yun nde, a tî kama se saŋgwɛ ho nyaŋgwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɗete, wunɛ kɛ li̧ lɛpi te yi Njambiyɛ wulɛ kɛ mɛkele mɛte yi wunɛ tɛmbiɗya kandɛ nɛ ɓetomba kɛ́. Ma wunɛ kɛ kɛ̀ mbɔmbu yí kelɔ yiŋa ɓuɗya kwalɔ mɛkele nda yite.» ");
INSERT INTO kkj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kɛ kɔŋte, ɛ Yesus jeɓa ŋgil wolo lɛpɔ nyɛ ɓomɔ nde: «Wunɛ hɛnɛ lɛ̂ŋgwɛ mɛtɔ yí wokɔ lɛpi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kinɛ yaŋa wɛtɛ nɛ wɛtɛ yakama wulɛ sɛ̧ kɛ̀ kɛ mɔy mumɔ kelɔ nde, a ɓɛ̂ki nɛ sɛmbɔ na. Yasi wɛtɛ, yo yasi te yi wulɛ kɛ mɔy mumɔ kɛ́ yakama kelɔ nde, a ɓɛ̂ki nɛ sɛmbɔ. ");
INSERT INTO kkj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋgɛ mumɔ ɓɛ nɛ mɛtɔ te yí wokɔ pɛ̧, na woku.» ");
INSERT INTO kkj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kɛ nyɛ ma kwa̧ nyiŋɛ tu̧ bɛ ndi nyɛ ɓenɛ ɓejekɛ ɓenɛ nɛ naŋ nɛ ŋgil ɓomɔ kɛ́, ɛ ɓejekɛ diyɛ nyɛ mɛdiyan kɛ kasi kanɔ te. ");
INSERT INTO kkj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «’Yite nde, wunɛ sendi, wunɛ yeti nɛ ɗyanɔ na? ’Nɛ tì wokɛ nde, kinɛ yaŋa wɛtɛ nɛ wɛtɛ yakama wulɛ sɛ̧ kɛ̀ kɛ mɔy mumɔ kelɔ nde, a ɓɛ̂ki nɛ sɛmbɔ na? ");
INSERT INTO kkj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kɛto yo ti kɛ́n kɛ temɔ nɛ na, yo kɛ́n kɛ mɔy, kɛ kɔŋte, a má nje kɛ̀ nyakɔ yo kɛ mboŋ.» Yesus kɛ kwaɗyɛ teɗye komɛte nde, mɛɗye hɛnɛ kimɔte. ");
INSERT INTO kkj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A nja̧ kɛ̀ mbɔmbu lɛpɔ nde: «Yasi te yi pundɛ kɛ mɔy mumɔ, yo yite kelɛ nde, a ɓɛ̂ki nɛ sɛmbɔ, ");
INSERT INTO kkj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","kɛto ɓeya mɛtakɛ hɛnɛ wúla kɛ mɔy yotu, kɛ mɔy temɔ mumɔ, yo kwalɔ kelna mɛwanja hɛnɛ te yi mumɔ yakama kelɔ. Yo kasi mɛguɓɔ nɛ̀ kasi wona ɓomɔ. Yo kasi nyɛna temɔ kɛ mɛyasi nɛ̀ kelna ɓeya mɛyasi. Yo kasi ɓoŋna yasi nɛ nje mɛseɓila nɛ̀ kasi kelna mɛkele mɛ mɛmi nɛ̀ kasi ɓeya temɔ nɛ̀ tɔyna ɓɛsɔ nɛ̀ ɓendiɗya yotu nɛ̀ kelna yasi nɛ yaw yaw. ");
INSERT INTO kkj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɓeya mɛyasi mɛnɔri hɛnɛ wúla kɛ mɔy yotu kelɔ nde, a ɓɛ̂ki nɛ sɛmbɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus tɛmma kɛ mɛnɛti mɛ Genesarɛt womɛte kwa̧ kɛ̀ kɛ mɛnɛti mɛ Tir. Ɛ nyɛ kwa̧ nyiŋɛ kɛ mbaŋa tu̧, yasi wɛtɛ, a tì kwaɗyɛ nde, ɓomɔ dûkwɛ na. Ko ɗete, a tì ɓɛ nɛ ɗeti te yi sɔma kinɛ nde, ɓomɔ dûkwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wɛtɛ nyari ɓa̧ nɛ ŋgɔndu wenɛ nɛ ɓeya sisiŋ kɛ yotu. Kɛ nya kɔ ma wokɔ kasi Yesus kɛ́, ɛ nyɛ nje ɓalɔ kɛ nji̧ mɛkol mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nya kɔ tì ɓɛ ŋgɔndu Yudɛn na, a ɓa̧ ŋgɔndu Fenisi kɛ mɛnɛti mɛ Siri. A ŋgwɛtama nɛ Yesus nde, a ɗûɗya ɓeya sisiŋ soŋɛ kɛ yotu mɔnɔ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Pa tikɔ, nɛ́ ɓɔnɔsikɛ pa ɗyena ditɔ, kɛto yo yeti kimɔte nde, ɓo ɓôŋ mɛɗye mɛ ɓɔnɔsikɛ nje ɓetɛ nyɛ ɓɔnɔ ɓembiye na.» ");
INSERT INTO kkj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɛ nyari yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, yo gbate ɗete. Ma yasi wɛtɛ, ɓɔnɔ ɓembiye ɗíy ndi lalɛ kɛ nji̧ teɓel yí ɗye mɛmbulma mɛɗye mɛte yi ɓalɛ wulɛ kɛ mɛɓɔ mɛ ɓɔnɔsikɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Kɛto wɛ yeŋsama kimɔte, ɗete ɗukwɛ, ɓeya sisiŋ ma ɗuwɛ kɛ yotu mɔnɔ wɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kɛ nyɛ ma ɗuwɛ kumɔ tu̧ kɛ́, a dól mɔnɔsikɛ mɛtinɛŋgwɛ kɛ taŋ, ɓeya sisiŋ ma pundɔ ɗuwɛ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus nja̧ tɛmɛ wolo kɛ mɛnɛti mɛ Tir kwa̧ nɛ Sidɔn laŋsa mɛnɛti mɛte yi nyaŋgwɛ mɛɗya kamɔ ɗiyɛ kɛte kɛ́. Ɛ nyɛ kwa̧ kumɔ kɛ nyaŋgwɛ matɔ Galile. ");
INSERT INTO kkj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɓo ɓoŋma wɛtɛ mbam nɛ ɗiɓina mɛtɔ nje nɔ kɛ yenɛ. Mbam te tì ɓɛ kɛ lɛpina kimɔte na. Ɛ ɓo ŋgwɛta nɛ Yesus nde, a kâsikwɛ mɛɓɔ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ɛ Yesus jisɛ nɛ nyɛ kɛ ŋgil ɓomɔ kɛ̀ nɛ naŋ nyinje mɛnyɛy mɛnɛ kɛ mɛtɔ mɛnɛ sa mɛsɛri kɛ ɓɔ nɛ kpokɛ nɛ ɗyem mbam. ");
INSERT INTO kkj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ɛ Yesus kaŋɛ misi kɛnjɛ kwey piɗyɛ sosu lɛpɔ nyɛ nyɛ nde: «Efata!» Yite nde: ‹Ɓutunaŋgwɛ!› ");
INSERT INTO kkj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ndana ndana, ɛ mɛtɔ mɛ mbam ɓutuna, ɛ ɗyem nɛ wunjiyɛ, ɛ nyɛ kandɛ ndapi nɛ kpɛlɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ɛ Yesus lɛpɛ nyɛ ɓo nde, kpɛ, ɓo tî yekiɗya nyɛ mumɔ na. Ko ɓɛkɔ ɗete, yo kɛ ŋgimɔ te yi nyɛ gayɛ ɓo, yo kɛ ŋgimɔ te yite yi ɓo pelɛ kasi te kɛ̀ nɔ mbɔmbu. ");
INSERT INTO kkj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓo ŋgbakimama ɓuɗyate lɛpɔ nde: «Yasi hɛnɛ te yi nyɛ kelɛ kɛ́ gba kimɔte. A kɛ kelɔ nde, gba ɓotu ɓete ɓe nɛ ɗiɓina mɛtɔ ɓaka wôku pɛ̧, kelɔ sendi nde, ɓotu ɓete ɓe ti ɓɛ kɛ tapita ɓaka tâpitaŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kɛ ŋgimɔ te yite nyaŋgwɛ ŋgil ɓomɔ nja̧ wesiɗya wolo kɛ kɛki Yesus. Yasi wɛtɛ, ɓo tì ɓɛ nɛ yaŋa te yi ɓo ta ɗye na. Ɛ Yesus jeɓa ɓejekɛ ɓenɛ lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mi kɛ gwe ŋgwɛtɛ ŋgil ɓotu ɓaka ɓuɗyate, kɛto yo mɛ kɛ muka mɛtu yitati yi ɓo waka kɛ kɛki mbɛ kɛ́. Ma yasi te yi ɓo ta ɗye yeti. ");
INSERT INTO kkj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋgɛ mi lɛpɛ ndana nde, ɓo ɗûkwɛ nɛ nja, wum ta ɓaɗyɛ ɓo kɛ nje, kɛto ɓaŋa kɛ njoka yan wulma nɛ naŋ nje nɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɛ ɓejekɛ ɓenɛ pitiɗye lɛpɔ nyɛ nyɛ nde: «Wusɛ waka kɛ koŋgor, hɛ ta kelɔ nan yí nyɛ nɛ ɓomɔ mɛɗye nde, ɓo ɗyâki ditɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ɛ Yesus diyɛ ɓo nde: «Wunɛ nɛ mampa niŋgɔ?» Ɛ ɓo yeŋsa nde: «Yitan jɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɛ nyɛ lɛpɛ nyɛ ɓomɔ nde, ɓo ɗîy ɗiyɔ kɛ mɛnɛti. Ɛ nyɛ ɓu̧ mampa yitan jɔ yiɓa kɛ, nyɛ Njambiyɛ wosoko lekɛ yo nyɛ ɓejekɛ ɓenɛ, nɛ́ ɓo kɛ̀ kaɓi nyɛ ɓomɔ. Ɛ ɓo ɓu̧ kɛ̀ kaɓɔ nyɛ ŋgil ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓo ɓa̧ sendi nɛ ɓɔnɔ ɓenjanjɔ nɛ mbɛt. Ɛ nyɛ nyɛ Njambiyɛ wosoko nje lɛpɔ nyɛ ɓejekɛ ɓenɛ nde, ɓo kɛ̂n kaɓɔ yo sendi nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓomɔ ɗyenama ditɔ. Ɛ ɓo nje wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ yitan jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓo ɓa̧ nda ɓomɔ tomay yini. Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ ɓomɔ nde, ɓo sîki ɗuwɛ. ");
INSERT INTO kkj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kinɛ kikɔ kɛ́, ɛ nyɛ ɓendɛ landi ɓenɛ ɓejekɛ ɓenɛ kwa̧ kɛ̀ kɛ mɛnɛti mɛ Dalmanuta. ");
INSERT INTO kkj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɗiyɔ kɛ́, ɛ *Ɓefarisɛ̧ ɗya̧ kandɛ mɛtandɔ ɓenɛ ɓe Yesus. Yí ɓoɓɛ nɛ nyɛ, ɓo diyma nyɛ nde, a têɗya ɓo wɛtɛ mɛyekambiyɛ yi wulɛ kɛ ɗyoɓɔ, nɛ́ ɓo ɓɛŋ. ");
INSERT INTO kkj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ɛ Yesus njimɛ kɛ temɔ lɛpɔ nde: «Kɛto ŋge yi ɓotu ɓe ŋgimɔ te yɔkɔ diyɛ wɛtɛ mɛyekambiyɛ kɛ́? Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ: Ko ɓo tí ɓɛŋɛ mɛyekambiyɛ wɛtɛ nɛ wɛtɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kɛ kɔŋte, ɛ nyɛ ŋgbɛsɛ ɓo ɓendɔ landi saɓiyɛ kɛ̀ ŋginjɛ te yɔru. ");
INSERT INTO kkj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɓejekɛ leŋsama kinɛ ɓu̧ mampa ɓuɗyate na. Ma ɓo ɓa̧ ndi nɔ wɛtɛ kɛ mɔy landi. ");
INSERT INTO kkj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ɛ Yesus kombile lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy gba nɛ sɔsɔ nɛ ŋga̧ te yi *Ɓefarisɛ̧ nɛ̀ ŋga̧ te yi Herod.» ");
INSERT INTO kkj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ɛ ɓejekɛ ɗiki sa̧ to lɛpi te tandɛ yan takɛ nde, yo kɛto ɓo tì ɓu̧ mampa ɓuɗyate na. ");
INSERT INTO kkj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus duwa̧ yasi te yi ɓa̧ kɛ kwaŋna kɛ́. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kɛto ŋge yi wunɛ takɛ nde, mi lɛ́pi ɗete, kɛto wunɛ tì ɓu̧ mampa ɓuɗyate kɛ́? ’Yite nde, kumɔ ndana wunɛ tì pa ɓɛ nɛ ɗyanɔ na? ’Wunɛ tì pa ɓiye to mɛyasi kumɔ ndana na? ’Mɛtemɔ mun ndi ka nɛ keskere? ");
INSERT INTO kkj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","’Misi te yi wunɛ nɔ kɛ́, wunɛ yeti kɛ ɓɛŋna na? ’Mɛtɔ mɛte yi wunɛ nɔ kɛ́, wunɛ yeti kɛ wokɔ ka pɛ̧ na? ’Ma yite nde, wunɛ kinɛ ɗyɔŋgɔ yí takɛ nɛ mɛyasi na? ");
INSERT INTO kkj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Komɛ mi lekima mampa yitan nyɛ ɓomɔ tomay yitan kɛ́, wunɛ nja̧ wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ niŋgɔ?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Kamɔ jɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ma komɛ mi lekima mampa yitan jɔ yiɓa nyɛ ɓomɔ tomay yini kɛ́, wunɛ nja̧ wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ niŋgɔ?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Yitan jɔ yiɓa.» ");
INSERT INTO kkj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «’Wunɛ tì pa ɓiye ndi to te na?» ");
INSERT INTO kkj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɓo nja̧ kwa̧ kumɔ kɛ Betsayda. Ɛ ɓomɔ ɓu̧ wɛtɛ mɔ ɗiɓina misi nje nɔ kɛ yi Yesus ŋgwɛta nɛ nyɛ nde, a kpôka nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ɛ nyɛ ɓiye mɔ ɗiɓina misi kɛ ɓɔ jisɛ nɛ nyɛ kɛ mɔy ɗya. Kɛ kɔŋte, ɛ nyɛ sa mɛsɛri lɔmbɛ kɛ misi mɛ mɔ ɗiɓina misi kasɛ ɓɔ kɛ yotu nɛ diyɛ nyɛ nde: «Wɛ kɛ ɓɛŋɛ yiŋa yasi?» ");
INSERT INTO kkj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ɛ mɔ ɗiɓina misi ŋgɛkila lɛpɔ nde: «Mi kɛ ɓɛŋɛ ɓomɔ. Mi ɓɛ́ŋa ɓo nda mɛjeti, yasi wɛtɛ, ɓo kɛ kɛndɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kɛ kɔŋte, ɛ nyɛ ɓasiɗye kasɛ ɓɔ kɛ misi mɛ mɔ ɗiɓina misi. Kɛ nyɛ ma ɓɛŋɛ yasi nɛ ŋgoŋ kɛ́, ɛ misi mɛnɛ ɓutuna, ɛ nyɛ kandɛ ɓɛŋna yasi hɛnɛ nɛ ŋgɛlɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ tî yɔkwɛ se nyiŋɛ mɔy ɗya na, ɗukwɛ kɛ̀ tu̧ ɗyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus nja̧ kwa̧ ɓenɛ ɓejekɛ ɓenɛ kɛ̀ kɛ pɔku mɛɗya mɛte yi Sesare te yi Filip. Piŋɔ te yi ɓo ɓa̧ kɛ kɛndi kɛ́, ɛ nyɛ diyɛ ɓo nde: «Ɓomɔ lɛ́pi nde, mi nda?» ");
INSERT INTO kkj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɛ ɓo yeŋsa nde: «Ɓaŋa lɛ́pi nde, wɛ Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. Ɓaŋa nde, Eli. Ɓaŋa sendi nde, wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ nda ɓari.» ");
INSERT INTO kkj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɛ nyɛ nje diyɛ ɓo nde: «Ma kɛ yun, wunɛ lɛ́pi ɓa nde, mi nda?» Ɛ Piyɛr yeŋsa lɛpɔ nyɛ nyɛ nde: «Wɛ *Krist!» ");
INSERT INTO kkj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɛ Yesus lɛpɛ nyɛ ɓo nde, kpɛ, ko ɓo tî lɛpi ɗete nyɛ wɛtɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ndana, ɛ Yesus kandɛ teɗya yan mɛyasi lɛpɔ nde: «Yo kponate nde, *Mɔnɔ mumɔ sâŋgwaŋgwɛ nɛ mɛbɔnɛ ɓuɗyate. Ɓetomba ɓe ɗya nɛ̀ ɓekum ɓe ɓotu ɓe kɛtina mɛyasi nyɛ Njambiyɛ nɛ̀ ɓotu ɓe teɗya mɛmboŋga ta sɛŋɛ nyɛ. Yo kponate sendi nde, ɓo ta wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus ɓa̧ kɛ lɛpɔ mɛlɛpi mɛnɔri nɛ gbas gbas. Ɛ Piyɛr ɓu̧ nyɛ kɛ̀ nɔ nɛ naŋ kandɛ gayna nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yasi wɛtɛ, ɛ nyɛ yeŋsa ɓɛŋɛ ɓejekɛ ɓenɛ ɓenɔ nɛ Piyɛr lɛpɔ nyɛ nyɛ nde: «*Satan, lɔndɔ kɛ kɛki mbɛ, kɛto mɛtakɛ mɔ yeti wɛtɛ nɛ yi Njambiyɛ na, yo mɛtakɛ mɛte yi ɓomɔ!» ");
INSERT INTO kkj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kɛ kɔŋte, ɛ nyɛ jeɓa ŋgil ɓomɔ nɛ̀ ɓejekɛ ɓenɛ lɛpɔ nyɛ ɓo nde: «Ŋgɛ mumɔ kwaɗyɛ ɓeŋgwɛ mi, a tî ɓoŋ yotu nɛ nde, yo yaŋa na. A sôɓa kroa nɛ ɓeŋgwɛ mi, ");
INSERT INTO kkj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","kɛto mumɔ hɛnɛ ɛ kwaɗyɛ kambiɗya nɛ joŋgwɛ ɗyenɛ nɛ ŋgom ŋgom kɔ ta ɗimbiɗye yo. Ma yɔkɔ ɛ ta ɗimbiɗye joŋgwɛ ɗyenɛ kɛto mbɛ nɛ̀ kɛto Kimɔ Tom kɔ ta ɓɛ nɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma ŋgɛ mumɔ si namɔ mɛnɛti maka hɛnɛ, nje ɗimbiɗye joŋgwɛ ɗyenɛ, yo má nje kamɛ nyɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yo kwalɔ yasi te nda yi mumɔ yakama nyɛ kɛ numbu joŋgwɛ ɗyenɛ kɔ? ");
INSERT INTO kkj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo nde, mumɔ hɛnɛ ɛ ta gwe njɔn jayna mbɛ nɛ̀ jayna mɛlɛpi mɛmbɛ kɛ mbɔmbu ɓotu ɓe muka ɓe tumɛ kɔŋ nɛ Njambiyɛ joŋna kɛ mɛɓeyɔ ɓaka, *Mɔnɔ mumɔ ta gwe sendi njɔn wenɛ komɛ nyɛ ta nje kɛ mɔy mɛluksa mɛ Saŋgwɛ ɓenɛ pupuna ɓejaki ɓe Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesus ka̧ mbɔmbu lɛpɔ sendi nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Kɛ njoka ɓotu ɓete ɓe ɗiyɛ ndana waka ɓaka, ɓaŋa tí gwe kinɛ pa ɓɛŋɛ nda yi *Kandɔ Njambiyɛ ta nje nɔ nɛ nyaŋgwɛ ŋguŋguɗyɛ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ya mɛtu yitan jɔ wɛtɛ kɛ kɔŋte, ɛ Yesus ɓu̧ Piyɛr nɛ̀ Jak nɛ̀ Jaŋ kwa̧ ɓenɛ ɓo ɓepɔ kɛ̀ nɛ naŋ kɛ wɛtɛ nyaŋgwɛ keki. Kumɔ mate, ɛ yotu nɛ sɛnjɛ kɛ misi man. ");
INSERT INTO kkj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mɛlambɔ mɛnɛ kpalma panɔ nɛ ŋgɛ̧y ŋgɛ̧y ŋgɛ̧y wumɔ nɛ mboŋ mboŋ. Kinɛ mumɔ wɛtɛ nɛ wɛtɛ kɛ to mɛnɛti yakama weyɛ lambɔ, yo má wumɔ nda yite na. ");
INSERT INTO kkj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɓo sém semɔ, Eli ɓenɛ Mɔyisi ɓaka kɛ nyɛ mɛsimɔ ɓenɛ ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Yekele, yo kimɔte nde, wusɛ ɗîy waka. Hɛ sûm mɛbala yitati, wɔ wɛtɛ, ɛ Mɔyisi wɛtɛ, ɛ Eli wɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyɛr lɛ́pi ɗete, kɛto a tì ɓɛ kɛ duwɛ yasi te yi nyɛ yâkaŋgwɛ lɛpɔ kɛ́ na, kɛto wɔ̧ kwaŋma ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wɛtɛ kulutu nja̧ ɗiɓiɗye ɓo. Ɛ wɛtɛ mɛn wulɛ kɛ mɔy kulutu lɛpɔ nde: «Yɔkɔ mɔnmbɛ, sɔŋ temɔ mbɛ, wunɛ wôkunaŋgwɛ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kɛ ɓejekɛ ma kaŋɛ misi ŋgɛkila kɛ kɛki yan kɛ́, ɓo tì ɓɛŋɛ se wɛtɛ mumɔ na, ndi Yesus nyɛpɔ ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndana, kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ piyɛ wulɛ kɛ to keki kɛ́, ɛ Yesus kiɗyɛ ɓo nde, kpɛ, ɓo tî yekiɗya yasi te yi ɓo ɓɛŋma kɛ́ nyɛ mumɔ na, ɓo ta disɔ yekiɗye, yite *Mɔnɔ mumɔ womiya kɛ njoka ɓemuŋ. ");
INSERT INTO kkj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓo ɓakiɗya lɛpi yinɔri nɛ gbɔl kɛ temɔ, ɛ ɓo ɗiki diyna tandɛ yan nde: «Kasi womiyate kɛ njoka ɓemuŋ, yite lɛ́pi ɓa nɛ ŋge?» ");
INSERT INTO kkj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɛ ɓo diyɛ nyɛ nde: «Kɛto ŋge yi ɓotu ɓe kɛtina mɛyasi lɛpɛ nde, Eli ta pa kandɛ nje ɗiŋ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yo gbate nde, Eli ta kandɛ nje yí nje kombile mɛyasi hɛnɛ tikɔ kɛ mbɛy te.» Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nde: «Ma nan yi yo kɛtinate kɛ kasi *Mɔnɔ mumɔ nde, a ta saŋgwa nɛ mɛbɔnɛ ɓuɗyate, ɓomɔ má yɛliyɛ nyɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma mi kɛ lɛpɔ nyɛ wunɛ nde: Eli ma nje, ɛ ɓomɔ kelɛ yasi te yi ɓo kwaɗya kelɔ kɛ́ nɛ nyɛ. Ɓo kelma nda yi yo ɓa̧ kɛtinate kɛ kasi nɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kɛ ɓo ma wuta nɛ ɓejekɛ te ɓari kɛ́, ɓo dól nde, nyaŋgwɛ ŋgil ɓomɔ nɛ̀ ɓotu ɓe kɛtina mɛyasi sima litɔ ɓo tikɔ kɛ ɓembe. Ɓenɛ ɓo ɓa̧ kɛ nyɛ mɛso. ");
INSERT INTO kkj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kɛ ŋgil ɓomɔ ma kaŋɛ ndi misi ɗekɛ ɓɛŋɛ nɛ Yesus kɛ́, ɛ ɓo ŋgbakima sutiyɛ kɛ̀ nyɛnɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ɛ Yesus diyɛ ɓo nde: «Wúnɛ ɓo nyɛ́ki mɛso kɛto yasi te nda?» ");
INSERT INTO kkj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɛ wɛtɛ mbam te ɛ ɓa̧ kɛ mɔy ŋgil kɔ yeŋsa nyɛ nyɛ nde: «Yekele, mi ɓoŋma mɔnmbɛ nje nɔ kɛ yɔ, a nɛ wɛtɛ ɓeya sisiŋ kɛ yotu yi kelɛ nde, a tî tapitaŋgwɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mbɛy hɛnɛ te yi nyɛ kwaɗyɛ dindɔ nyɛ kɛte, a kɛ ɓetɛ nyɛ kɛ mɛnɛti nɛ weŋ. Ɔ ɓɛ́ŋa, mɛwuru kɛ pundɔ nyɛ kɛ numbu nɛ pukam pukam, a mɛ kɛ nyambɔ mɛsu̧, yotu ma si ɗetɔ nɛ kaŋgata. Mi ŋgwɛtama nɛ ɓejekɛ ɓɔ nde, ɓo ɗûɗya ɓeya sisiŋ te soŋɛ kɛ yotu nɛ. Yasi wɛtɛ, ɛ ɓo suɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ɛ Yesus yeŋsa lɛpɔ nyɛ ɓo nde: «Wunɛ ɓotu ɓete ɓe ti jáya yasi ɓaka, ’mi ta ɗiyɔ sinɛ wunɛ kumɔ ndenɛn? ’Mi ta gbisɔ wunɛ kumɔ ndenɛn? Wunɛ njâki nɛ nyɛ woŋga kɛ yembɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɛ ɓo ɓu̧ nyɛ kɛ̀ nɔ. Kɛ ɓeya sisiŋ ma kaŋɛ ndi misi ɗekɛ ɓɛŋɛ nɛ Yesus kɛ́, ɛ nyɛ jalɛ mɔnɔsikɛ ɓeyate. Ɛ nyɛ ɓalɛ kɛ mɛnɛti kandɛ mɛɓiŋgila, mɛwuru kɛ pundɔ kɛ numbu. ");
INSERT INTO kkj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ɛ Yesus diyɛ saŋgwɛ nɛ mɔnɔ nde: «Yo kánda ndenɛn?» Ɛ nyɛ yeŋsa nde: «Yo ma kíki kandɛ, a ndi nɛ mɔnɔsikɛ. ");
INSERT INTO kkj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kɛ yiŋa mɛŋgimɔ yo kɛ ɗiki ɓetɛ nyɛ kɛ ɗitɛ, yiŋa kɛ mɔrɔku sa̧ ndi nje te yi wo nyɛ wokɔ. Ndi nde, ŋgɛ ɓɛ nde, wɛ yakama kelɔ yaŋa, kama wusɛ, gwakɔ ŋgwɛtɛ wusu.» ");
INSERT INTO kkj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ kpál lɛpɔ nde: ‹Ŋgɛ ɓɛ nde, wɛ yakama kelɔ yaŋa nde,› ma pɛ mɔ te ɛ tikɛ temɔ kɛ yi Njambiyɛ, mɛyasi hɛnɛ yakama kelna.» ");
INSERT INTO kkj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ndana, ɛ saŋgwɛ nɛ mɔnɔ kembiɗya nɛdɔ nde: «Mi kɛ tikɔ temɔ, ma kama mi, kɛto yo sulnate nde, mi ɓɛ̂ki nɛ tikina temɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kɛ Yesus ma ɓɛŋɛ nde, ŋgil ɓomɔ kɛ sutiyɛ yí nje kɛ́, ɛ nyɛ ɓama nɛ ɓeya sisiŋ lɛpɔ nyɛ nyɛ nde: «Wɛ sisiŋ te ɛ kelɛ nde, mumɔ tî tapitaŋgwɛ, ɗiɓɔ sendi mɛtɔ mɛ mumɔ kɔ, gba mi kɛ kombile lɛpɔ nyɛ wɛ nde: Pundɔ ɗuwɛ kɛ yotu mɔnɔ kɛ. Kpɛ, wɛ tî yɔkwɛ nyiŋɛ ɗiyɔ se kɛ yotu nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɛ ɓeya sisiŋ kembiɗya jalɛ mɔnɔsikɛ ɓeyate pundɔ ɗuwɛ kɛ yotu nɛ. Ɛ mɔnɔsikɛ tika nɛ lɔŋkpɔŋ nda muŋte. Ɛ sulɔ ɓomɔ lɛpɛ nde, a gwa̧. ");
INSERT INTO kkj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yasi wɛtɛ, ɛ Yesus ɓiye nyɛ kɛ ɓɔ tɛmbiɗye. Ɛ mɔnɔsikɛ tɛmɛ ɗiyɔ kɛ tɛri kwey. ");
INSERT INTO kkj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɛ Yesus ma nje kwa̧ nyiŋɛ tu̧ kɛ́, ɛ ɓejekɛ ɓenɛ diyɛ nyɛ tandɛ yan nde: «Kɛto ŋge yi wusɛ suɗya su soŋna ɓeya sisiŋ te kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Njɛl sisiŋ nda ɛnɔru yakama ɗuwɛ kɛ yotu mumɔ ndi nɛ nje mɛŋgwɛta nɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kɛ kɔŋte, ɛ ɓo tɛmɛ womɛte kwa̧ nɛ Galile. Yasi wɛtɛ, Yesus tì kwaɗyɛ nde, ɓomɔ dûkwɛ mbɛy nɛ na, ");
INSERT INTO kkj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kɛto a ɓa̧ kɛ teɗye ɓejekɛ ɓenɛ mɛyasi lɛpɔ nyɛ ɓo nde: «Ɓo ta ɓu̧ *Mɔnɔ mumɔ kaŋɛ nyɛ kɛ mɛɓɔ mɛ ɓomɔ, ɓo má wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ndi nde, ɓejekɛ tì wokɛ to lɛpi te na, yasi wɛtɛ, ɓo gwa̧ wɔ̧ diynate. ");
INSERT INTO kkj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɓo kwaŋma kumɔ kɛ Kapɛrnawum. Kɛ Yesus ma kwa̧ nyiŋɛ tu̧ kɛ́, ɛ nyɛ diyɛ ɓo nde: «Wunɛ ɓa̧ kɛ nyɛ mɛso kɛ nje kɛto yasi te nda?» ");
INSERT INTO kkj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɛ ɓo ɗiyɛ nɛ kpiŋgbili kinɛ ɓutɛ numbu na, kɛto ɓo ɓa̧ kɛ pitiɗya numbu kɛ nje yí duwɛ mɔ te ɛ kwaŋma ɓɛsɔ kɛ njoka yan kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ndana, ɛ Yesus kwa̧ ɗiyɔ mɛtiɗyɛ jeɓa ɓejekɛ kamɔ jɔ yiɓa lɛpɔ nyɛ ɓo nde: «Ŋgɛ mumɔ kwaɗyɛ ɓɛ bosa mumɔ kɛ njoka ɓɛsɔ, a ɓɛ̂ki nda njena mumɔ kɛ njoka yan hɛnɛ, kelɔ sendi mɛsay nyɛ ɓo hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɛ nyɛ ɓu̧ wɛtɛ gbɛla mɔnɔsikɛ tɛmbiɗye kɛ ɓembe yan kaŋɛ nyɛ ɓiye kɛ ɓɔ lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Mumɔ hɛnɛ ɛ ɓu̧ wɛtɛ mɔnɔsikɛ nda yɔkɔ kimɔte kɛto mbɛ, yo mi yi nyɛ ɓu̧ kimɔte. Ma mɔ te ɛ ɓu̧ mi kimɔte, yeti ndi mi nɛ ŋguru wombɛ yi nyɛ ɓu̧ na, yo nde, a ɓóŋ Mɔ te ɛ tomma mi kɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jaŋ lɛpima nyɛ Yesus nde: «Yekele, wusɛ ɓɛŋma wɛtɛ mbam kɛ soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗinɔ ɗyɔ. Ɛ wusɛ gayɛ nyɛ, kɛto a yeti kɛ njɔŋ su na.» ");
INSERT INTO kkj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ɛ Yesus lɛpɛ nde: «Wunɛ tî gay nyɛ na, kɛto mumɔ ti yaka kelɔ mɛyekambiyɛ nɛ ɗinɔ ɗyembɛ nje yeŋsa ndi numbu ndana ndana lɛpina ɓeyate nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yo nde, ŋgɛ mumɔ ti lu̧ ɗyambi suŋgwɛ nɛ wusɛ, a kɛ kɔŋ su. ");
INSERT INTO kkj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mumɔ hɛnɛ ɛ ta nyɛ wunɛ pelɔ mɔrɔku wɛtɛ nde, wunɛ hɔ̂ɓiya, kɛto wunɛ ɓotu ɓe *Krist, mɔ te tí kɔpɔ sol nɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ma ŋgɛ wɛtɛ mumɔ kelɛ yasi te yi yakama jatiɗye wɛtɛ mɔnɔsikɛ kɛ njoka ɓɔnɔ ɓaka ɓe tikɛ temɔ kɛ yembɛ ɓaka kɛ ɓeya nje, ŋgɛ ɓo lɛpɛ ndi nde, ɓo ɓôŋ tari kɔkuna yasi tiŋɔ kɛ ŋgiŋ mɔ te kwa̧ ɓetɛ nyɛ kɛ maŋ, yite ɓo jekima kelɔ kimɔ yasi nɛ nyɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ŋgɛ ɓɛ nde, wɛtɛ ɓɔ yɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ kîla ɓɔ te mbɛte soŋɛ. Yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, nyiŋa ndi nɛ ɓɔ wɛtɛ kɛ ɗyoɓɔ ɓɛ nɛ joŋgwɛ, laŋsa nde, ɓɛkɔ nɛ mɛɓɔ hɛnɛ yiɓa nje kwa̧ kɛ̀ kɛ ɗitɛ te yi ɗiyɛ kpo nɛ kpo kinɛ ɗimɔ kɛ́.  ");
INSERT INTO kkj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mate ɓeɗuŋ ɓete ɓe ɗye ɓo nɛ fit fit ɓaka yeti kɛ gwe na, ma ɗitɛ yeti kɛ ɗimɔ sendi na. ");
INSERT INTO kkj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ŋgɛ ɓɛ nde, wɛtɛ kol yɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ kîla kol te mbɛte soŋɛ. Yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, nyiŋa ndi nɛ kol wɛtɛ kɛ ɗyoɓɔ ɓɛ nɛ joŋgwɛ, laŋsa nde, ɓo ɓêta wɛ kɛ ɗitɛ te yi ti ɗím kɛ́ nɛ mɛkol mɔ hɛnɛ yiɓa nɛ jɛm.  ");
INSERT INTO kkj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mate ɓeɗuŋ ɓete ɓe ɗye ɓo nɛ fit fit ɓaka yeti kɛ gwe na, ma ɗitɛ yeti kɛ ɗimɔ sendi na. ");
INSERT INTO kkj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ŋgɛ ɓɛ nde, wɛtɛ misi yɔ kɛ kwaɗyɛ jatiɗye wɛ kɛ ɓeya nje, nɔ̀ ɗôka misi te mbɛte soŋɛ. Yo ta jekɔ ɓɛ kimɔte kɛ yɔ nde, nyiŋa kɛ *Kandɔ Njambiyɛ nɛ misi wɛtɛ, laŋsa nde, ɓo ɓêta wɛ kɛ ɗitɛ te yi ti ɗím kɛ́ nɛ misi mɔ hɛnɛ yiɓa nɛ jɛm. ");
INSERT INTO kkj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mate ɓeɗuŋ ɓete ɓe ɗye ɓo nɛ fit fit ɓaka yeti kɛ gwe na, ma ɗitɛ yeti kɛ ɗimɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ɗitɛ ta pupuɗye mumɔ hɛnɛ ndi nda yi kwa kombile nɛ mɛɗye kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kwa kimɔ yasi, ma kɛ som kwa si sambiyɛ, wunɛ ta kelɔ nan yí yɔkiɗye nɔ? Wunɛ ɓɛ̂ki nda mɛɗye mɛte yi ɓɛ nɛ kwa kɛte joŋna nɛ tɛ tandɛ yun.» ");
INSERT INTO kkj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus nja̧ tɛmɛ womɛte kwa̧ kɛ̀ kɛ mɛnɛti mɛ Yuda kɛ ŋginjɛ Yurdɛ̧. Ɛ nyaŋgwɛ ŋgil ɓomɔ nje wesiɗya wolo kɛ kɛki nɛ. Ɛ nyɛ kandɛ teɗya yan mɛyasi nda njɛl wenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɛ *Ɓefarisɛ̧ nje kɛ yenɛ yí nje ɓoɓɛ nyɛ. Ɛ ɓo diyɛ nyɛ nde: «Mɛmboŋga kɛ nyɛ ka mumɔ ɗeti nde, a sôŋa ɓɔ nɛ nyari wenɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «’Mɔyisi pɛsima nɛ ŋge nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɛ ɓo lɛpɛ nde: «Mɔyisi nya nje nde, mbam yakama kɛtɔ mɛkana mɛ diɗya gwaki nyɛ nyari yí soŋɛ ɓɔ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Yo kɛto mɛtemɔ mun nɛ keskere, yori yi Mɔyisi kɛtima nɛ mboŋga te ɗete nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma kɛ yi Njambiyɛ kusuma nɛ mɛyasi kɛ kandinate kɛ́, a kusuma mbam, kusɔ nyari. ");
INSERT INTO kkj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɗete, mbam ta tikɔ saŋgwɛ ɓenɛ nyaŋgwɛ joŋna ɓenɛ nyari nda kɔl ɓenɛ jon. ");
INSERT INTO kkj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ɓo hɛnɛ yiɓa ta nje ɓɛ ndi mbundɔ wɛtɛ. Komɛte, ɓo yeti se ɓomɔ yiɓa na, ɓo mɛ ndi mbundɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ma ɗete, mumɔ tî ɓaka yasi te yi Njambiyɛ sima jaŋgwɛ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kɛ ɓo ma kumɔ kɛ tu̧ kɛ́, ɛ ɓejekɛ diyɛ nyɛ mɛdiyan wolo kɛ yasi te yi nyɛ lɛpima ndana kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Mbam hɛnɛ ɛ ta soŋɛ ɓɔ nɛ nyari wenɛ kwa̧ ɓu̧ mbaŋa, yite nyɛ mbam mɛwanja kɛ mbɔmbu bosa nyari. ");
INSERT INTO kkj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ŋgɛ nyari ɗuwɛ kɛ ɓɔ njom kɛ̀ kelɔ gwaki ɓenɛ wɛtɛ mbam, yite nyɛ nya mɛwanja.» ");
INSERT INTO kkj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɗiyɔ kɛ́, ɛ ɓomɔ ɓu̧ sɛkɛ sɛkɛ ɓɔnɔsikɛ kɛ̀ nɔ kɛ yi Yesus, na kpoki ɓo yí nyɛ ɓo mɛkombila. Yasi wɛtɛ, ɛ ɓejekɛ ɓamɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kɛ nyɛ ma ɓɛŋɛ ɗete kɛ́, ɛ yo kwaɗye temɔ nɛ ɓuɗyate. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Nɛ tîki sɛkɛ sɛkɛ ɓɔnɔsikɛ, nɛ́ ɓo nje kɛ yembɛ. Nɛ tî peti ɓo na, kɛto *Kandɔ Njambiyɛ, yo yi njɛl ɓotu ɓete ɓe nda ɓo ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mumɔ ti jayɛ *Kandɔ Njambiyɛ nda yi mɔnɔsikɛ jayɛ nɛ yasi kɛ́ na, ko a tí nyiŋɛ kɛte na.» ");
INSERT INTO kkj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kɛ kɔŋte, ɛ nyɛ kaŋɛ ɓɔnɔsikɛ soɓɛ kɛ ɓɔ kasɛ mɛɓɔ kɛ yotu yan nyɛ ɓo mɛkombila. ");
INSERT INTO kkj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ndana, kɛ Yesus ma tɛmɛ nyiŋɛ nje kɛ́, ɛ wɛtɛ mbam sɛɗyɛ nje kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ diyɛ nyɛ nde: «Kimɔ yekele, mi kél nan, nɛ́ mi ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo?» ");
INSERT INTO kkj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ɛ Yesus diyɛ nyɛ nde: «Wɛ jéɓaŋgwɛ mi nde kimɔ mumɔ kɛto ŋge? Kɛto kinɛ kimɔ mumɔ wɛtɛ nɛ wɛtɛ na, ndi Njambiyɛ nyɛpɔ. ");
INSERT INTO kkj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wɛ ma duwɛ mɛmboŋga mɛ Njambiyɛ, yo nde: ‹Kpɛ, wɛ tî woku mumɔ na. Wɛ tî kel wanja na. Wɛ tî guɓu na. Wɛ tî pɛsi lɛpi nyɛ kɛ numbu mumɔ na. Wɛ tî seɓila mumɔ ɓu̧ nɛ yiŋa yasi kɛ mɛɓɔ mɛnɛ na. Jɛsɔ sɔŋgwɛ ɓenɛ nyɔŋgwɛ.› » ");
INSERT INTO kkj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɛ mbam yeŋsa nyɛ nyɛ nde: «Yekele, mi kɛ ɓakiɗye mɛyasi mɛnɔri hɛnɛ kandɛ nɛ mɔnɔsikɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus ɓɛŋma nyɛ kwaɗyɛ nyɛ lɛpɔ nyɛ nyɛ nde: «Ɓukwa̧ yasi wɛtɛ yi wɛ tì pa kelɔ kɛ́, yo nde, kɛn ɗyaŋgwɛ mɛyasi mɔ hɛnɛ, nɔ̀ ɓôŋ mɔni te kaɓɔ nyɛ buka ɓomɔ. Ɗete, wɛ ta ɓɛ nɛ kusuku kɛ ɗyoɓɔ. Kɛ kɔŋte, nɔ̀ ɓêŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yasi wɛtɛ, ŋgɛ mbam kɔ ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ nyɛ tiŋɛ mɛŋgembi nɛ siɓiɓi kwa̧ nɛ ŋgambi, kɛto a ɓa̧ nɛ ɓuɗya kusuku. ");
INSERT INTO kkj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ndana, ɛ Yesus kaŋɛ misi ŋgɛkila lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: «Yo gba sulnate nde, ɓotu ɓe kusuku nyîŋa kɛ *Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɓejekɛ ŋgbakimama lɛpi yinɔri ɓuɗyate. Ɛ Yesus ɓasiɗye lɛpɔ nyɛ ɓo nde: «Wunɛ ɓɔnɔ, yo gba sulnate nde, ɓotu ɓete ɓe nyɛ temɔ yan hɛnɛ kɛ kusuku ɓaka nyîŋ kɛ *Kandɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yo sulnate nde, nyaŋgwɛ nyamɔ nde *samo yakama kwa̧ lalɛ nɛdɔ kɛ njɛmbi alula nɛ̀ nde, mɔ kusuku nyîŋa kɛ *Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɛ ɓejekɛ ŋgbakima kwa̧ to te lɛpɔ tandɛ yan nde: «Ma ŋgɛ ɓɛ ɗete, nda yakama ju̧ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus ɓɛŋma ɓo lɛpɔ nde: «Kɛ yi ɓomɔ, mumɔ yeti nɛ ɗeti te yi kelɔ ɗete na. Ma kɛ yi Njambiyɛ, a nɛ ɗeti te yi kelɔ mɛyasi hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ɛ Piyɛr ɗiyɛ lɛpɔ nyɛ nyɛ nde: «Ɓɛŋa, wusɛ ma tikɔ su mɛyasi hɛnɛ kpalɔ ɓeŋgwɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ɛ Yesus yeŋsa nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mumɔ hɛnɛ te ɛ ta tikɔ tu̧ ɗyenɛ, tikɔ ɓemaŋ ho ɓeɗyɔmbu ho nyaŋgwɛ ho saŋgwɛ ho ɓɔnɔ ho mɛŋgwaŋ mɛnɛ kɛto mbɛ nɛ̀ kɛto Kimɔ Tom, mɔ te ta kpalɔ ɓɛ nɛ mɛyasi gɔmay kɛ numbu yasi wɛtɛ te yi nyɛ tikima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kandɛ ndana mɔ te ta ɓɛ nɛ mɛtu̧ gɔmay. A ta ɓɛ nɛ ɓemaŋ gɔmay ɓu̧ ɓeɗyɔmbu gɔmay. A ta ɓɛ sendi nɛ ɓenyaŋgwɛ gɔmay nɛ̀ ɓɔnɔ gɔmay ɓu̧ mɛŋgwaŋ gɔmay. A ta ɓɛ nɛ mɛyasi mɛnɔri hɛnɛ kɛ mɔy nyaŋgwɛ mɛbɔnɛ. Ma a ta ɓɛ sendi nɛ joŋgwɛ te yi kpo nɛ kpo kɛ mɛtu mɛte yi ta nje kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yo nde, bosa ɓomɔ ɓuɗyate ta nje ɓɛ ɓotu ɓe njimɛ. Sendi, ɓotu ɓe njimɛ ɓuɗyate ta nje ɓɛ bosa ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ɓo ɓa̧ kɛ kɛndi yí ɓendɔ kɛ̀ pɛ Yerusalɛm. Yesus ɓa̧ mbɔmbu, ɓejekɛ kɛ kɔŋ nɛ. Temɔ yan tì ɓɛ nɛ tɛ na. Ɓotu ɓete ɓe ɓa̧ kɛ ɓeŋgwɛ nyɛ ɓaka ɓa̧ kɛ gwe wɔ̧ ɓuɗyate. Ɛ Yesus kala jeɓa ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kandɛ lɛpina yasi te yi nyɛ ta saŋgwa nɔ kɛ́ nyɛ ɓo: ");
INSERT INTO kkj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Nɛ ɓɛ̂ŋa, wusɛ ɓe ɓendɛ kɛ̀ pɛ Yerusalɛm ɓaka. Ɓo ta ɓu̧ *Mɔnɔ Mumɔ nyɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi. Ɓo ta pɛsɔ nde, ɓo wôku nyɛ. Kɛ kɔŋte, ɓo má nje ɓu̧ nyɛ kaŋɛ nyɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓotu ɓete ta nyɛtɔ nyɛ sa mɛsɛri kɛ yotu nɛ. Ɓo ta njurɔ nyɛ nɛ njambala nje wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jak ɓenɛ Jaŋ te ɓɔnɔ ɓe Seɓede nja̧ kɛ kɛki Yesus lɛpɔ nyɛ nyɛ nde: «Yekele, yasi te yi wusɛ ta diyɛ wɛ kɛ́, hɛ gɔ́ru nde, kelɔ yo nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ɛ Yesus diyɛ ɓo nde: «Nɛ kwáɗyikwɛ nde, mi kêl ɓa ŋge nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Komɛ wɛ ta ɓu̧ ɗiyɔ mɛluksa mɔ kɛ́, jaya nde, wusɛ ɗîy mɛtiɗyɛ kɛ kɛki yɔ, wɛtɛ pulɔ mbam ɓɔ, wɛtɛ pulɔ gare yɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yasi wɛtɛ, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ yeti kɛ duwɛ yasi te yi wunɛ diyɛ kɛ́ na. ’Wunɛ yakama hɔɓiye ka pelɔ mɛbɔnɛ mɛte yi mi ta hɔɓiye kɛ́? Njɛl mɛtɔpuna mɛte yi mi ta saŋgwa nɔ kɛ́, ’wunɛ yakama wɛliyɛ yo nde?» ");
INSERT INTO kkj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Wusɛ yakama wɛliyɛ.» Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Gbate, wunɛ ta hɔɓiye pelɔ mɛbɔnɛ mɛte yi mi ta hɔɓiye kɛ́. Sendi, njɛl mɛtɔpuna mɛte yi mi ta saŋgwa nɔ kɛ́, wunɛ ta saŋgwa nɔ sendi. ");
INSERT INTO kkj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma yasi wɛtɛ, kɛ kasi ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ ho kɛ gare mbɛ, yeti mi kaɓɛ yo nyɛ ɓomɔ na. Mɛmbɛy mɛte wókunaŋgwɛ nɛ ɓotu ɓete ɓe Njambiyɛ sima si kombile yo tikɛ ɓo ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kɛ ɓejekɛ te ɓari kamɔ ma wokɔ mɛlɛpi mɛte yi Jak ɓenɛ Jaŋ lɛpima kɛ́, ɛ temɔ yan kwa suŋgwɛ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ɛ Yesus jeɓa ɓejekɛ hɛnɛ lɛpɔ nyɛ ɓo nde: «Wunɛ duwa̧ nde, ɓotu ɓete yi ɓomɔ jeɓa nde ɓekum kɛ to mɛnɛti ɓaka kɛ kpalɔ ɓendɔ to yan ɓendɔ. Ma ɓe nyaŋgwɛ ɓotu ɓete ɓe kɛ njoka yan ɓaka kɛ kpalɔ natɛ ɓo nata. ");
INSERT INTO kkj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yasi wɛtɛ kɛ yun, yo yeti kɛ kwaŋna ɗete na. Mɔ te ɛ kwaɗyɛ ɓɛ nyaŋgwɛte kɛ njoka yun kɔ yâkaŋgwɛ kelɔ mɛsay nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma yɔkɔ ɛ kwaɗyɛ ɓɛ bosa mumɔ kɛ njoka yun kɔ ɓɛ̂ki bala ɓɛsɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kɛto *Mɔnɔ mumɔ sendi nɛ ŋguru wenɛ ti ma njáki, nɛ́ ɓomɔ kel mɛsay nyɛ nyɛ na, yasi wɛtɛ, a nja̧ nda mɔ mɛsay yí nyɛ joŋgwɛ ɗyenɛ yí kolɔ nɛ ɓuɗya ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɓo kɛndima kumɔ kɛ Yeriko. Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ pundɔ ɗuwɛ kɛ mɔy ɗya ɓenɛ ɓejekɛ ɓenɛ nɛ̀ nyaŋgwɛ ŋgil ɓomɔ kɛ́, wɛtɛ mɔ ɗiɓina misi nde Bartime, mɔnɔ Time ɓa̧ kɛ ɗiyɔ kɛ kɛki nje. A ɗikima jɔmbɔ mɛyasi kɛ mɛɓɔ mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ŋgɛ nyɛ ma wokɔ nde, yo Yesus te mɔ Nasarɛt kwa̧ kɛ́, ɛ nyɛ nyɛ numbu kɛ kembi lɛpɔ nde: «Mɔnɔ Davit Yesus, gwakɔ ŋgwɛtɛ wombɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓaŋa ɓomɔ ɓuɗyate ɓamma nyɛ yí sa̧ nje nde, a ɗîɓi numbu. Ma ko ɓɛkɔ ɗete, yo kɛ ŋgimɔ te yite yi nyɛ nja̧ kembɔ kwa̧ to te nde: «Mɔnɔ Davit, gwakɔ ŋgwɛtɛ wombɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ndana, ɛ Yesus tɛmɛ lɛpɔ nde: «Wunɛ jêɓaŋgwɛ nyɛ.» Ɛ ɓo jeɓa mɔ ɗiɓina misi lɛpɔ nyɛ nyɛ nde: «Wɛ tî kambi yaŋa na. Tɛma, a kɛ jeɓa wɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kɛ nyɛ ma wokɔ ɗete kɛ́, ɛ nyɛ ɓetɛ gambo nɛ nɛ vɛŋ lombiyɛ kɛ̀ pɛ yi Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ɛ Yesus diyɛ nyɛ nde: «Wɛ kwáɗyikwɛ nde, mi kêl ŋge nyɛ wɛ?» Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Yekele, kelɔ nde, mi ɓɛ̂ŋnaŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Kwaŋgɔ, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ.» Ndana ndana, ɛ nyɛ kandɛ ɓɛŋna yasi ɓeŋgwɛ Yesus kɛ̀ nɔ. ");
INSERT INTO kkj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ɓo kɛndima wuta nɛ Yerusalɛm kumɔ kɛ kɛki Betfage nɛ̀ Betani, kɛ pulɔ *Keki mɛoliviye. Ɛ Yesus tomɛ ɓaŋa ɓejekɛ ɓenɛ yiɓa kɛnjɛ mbɔmbu lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Wunɛ kɛ̂n kɛ ɗya te ɛ kɛ mbɔmbu wun kɔ. Nɛ nyiŋna ɗya ɗekɛ wunɛ ta dolɔ wɛtɛ mɔnɔ tofu tiŋnate. Mumɔ wɛtɛ nɛ wɛtɛ tì pa ɗiɗyɛ mɛta mɛnɛ wɛtɛ yesɔ kɛ to nɛ na. Nɛ̀ wunɛ wûnja nyɛ nje nɔ. ");
INSERT INTO kkj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ŋgɛ mumɔ diyɛ wunɛ nde: ‹Wunɛ wúnja nyɛ kɛto ŋge?› Nɛ̀ wunɛ yêŋsaŋgwɛ nde: ‹Nyaŋgwɛ Kumande kɛ kwaɗyɛ nyɛ, a ta yɔkiɗye nyɛ nɛdɔ.› » ");
INSERT INTO kkj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓo ka̧, ɛ ɓo dolɛ wɛtɛ mɔnɔ tofu tiŋnate kɛ numɛy kɛ sɛ̧ yaka nɛ nje, ɛ ɓo wunjɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɛ ɓaŋa ɓotu ɓete ɓe ɓa̧ womɛte ɓaka diyɛ ɓo nde: «Yiri ŋge yi wunɛ kelɛ kɛ́? Kɛto ŋge yi wunɛ wunjɛ mɔnɔ tofu ɛnɔru kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɛ ɓo yeŋsa nda yi Yesus lɛpima nyɛ ɓo kɛ́. Ɛ ɓo tikɛ ɓo nde, ɓo kwâŋ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓo ɓoŋma mɔnɔ tofu kumɔ nɔ kɛ yi Yesus, ɓu̧ mɛlambɔ man jonɔ kɛ to nɛ. Ɛ nyɛ kwa̧ ɓendɔ mɔnɔ tofu ɗiyɔ kɛ to nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓomɔ ɓuɗyate ɓoŋma mɛlambɔ man jonɔ kɛ nje, ɛ ɓaŋa lekɛ yan mɔnɔ mɛɓɔ mɛjeti kɛ lɔ̧ ɓetɛ kɛ nje. ");
INSERT INTO kkj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓotu ɓete ɓe ɓa̧ mbɔmbu nɛ̀ ɓaka ɓe ɓa̧ kɛ kɔŋ Yesus ɓaka ɗikima kembɔ nde: «*Hosana, mɛkombila nɛ yɔkɔ ɛ nje nɛ ɗinɔ Baba Mbokɔ! ");
INSERT INTO kkj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mɛkombila ɓɛ̂ŋnaŋgwɛ kɛ kandɔ saŋmbambɔ wusu Davit yi nje kɛ́! Njambiyɛ ɓɛ̂ki nɛ̀ mɛluksa kɛ kwey!» ");
INSERT INTO kkj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus ɗyaŋma kɛ Yerusalɛm kwa̧ nyiŋɛ mbanjɔ Njambiyɛ. Kɛ nyɛ ma si ɓɛŋɛ mɛyasi hɛnɛ te yi ɓa̧ kɛ kɛki nɛ kɛ́, ɛ nyɛ kwa̧ ɓenɛ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kɛ̀ pɛ Betani, kɛto ŋgimɔ sima kwa̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Misi pupɛ, kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ pundɔ ɗuwɛ kɛ Betani kɛ́, Yesus ɓa̧ kɛ wokɔ nja. ");
INSERT INTO kkj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ nɛ wɛtɛ njuku *figiye nɛ naŋ nɛ mɛmbɔru nɛ gbi kɛ́, ɛ nyɛ kɛ̀, na kɛ̀ ɓɛŋ, simande yo wumma. Yasi wɛtɛ, kɛ nyɛ ma wuta nɛ njuku te kɛ́, a sém ndi mɛmbɔru nɛ mɛmbɔru nɛ gbi, kɛto yo tì ɓɛ ŋgimɔ wumnate na. ");
INSERT INTO kkj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ndana, ɛ nyɛ lɛpɛ nyɛ njuku figiye ɛnɔru nde: «Siyma ɓɔnɛ nɛ ŋgbɔt nde, ko mumɔ wɛtɛ nɛ wɛtɛ tí ɗye se kwalɔ mbumɔ yɔ wɛtɛ yesɔ na!» Ɓejekɛ ɓenɛ wokuma lɛpi yinɔri yi nyɛ lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɓo yɔkwa̧ nɛ kɔkɔ ɗya̧ kɛ Yerusalɛm. Ɛ Yesus nyiŋɛ mbanjɔ Njambiyɛ kandɛ ɗuɗya ɓotu ɓete ɓe ɓa̧ kɛ ɗyaŋgwɛ nɛ̀ ɓaka ɓe ɓa̧ kɛ ɓɔmɔ mɛyasi womɛte ɓaka. A tindima mɛteɓel mɛ ɓotu ɓe sɛnjina mɔni nɛ̀ mɛsolo mɛ ɓotu ɓe ɗyaŋgwa ɓepepɔ ɓetɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A tì tikɛ nde, mumɔ wɛtɛ nɛ wɛtɛ sôɓa yiŋa yaŋa pɛsa nɔ nɛ mɔy mbanjɔ Njambiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A teɗya ɓo mɛlɛpi mɛ Njambiyɛ lɛpɔ sendi nde: «’Yo yeti gba kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓo ta jeɓa tu̧ ɗyembɛ nde tu̧ te yi mɛkandɔ hɛnɛ ta ŋgbɔ ŋgwɛta nɛ Njambiyɛ kɛ mɔyte› na? Ma yasi wɛtɛ, wunɛ kpalma yeŋsa yun yo nɛ gbaŋ ɓotu ɓe guɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ma wokɔ ɗete kɛ́, ɛ ɓo sa̧ nje te yi ɓo yakama wo nɛ nyɛ. Ndi nde, ɓo ɓa̧ kɛ kambɔ nyɛ, kɛto yasi te yi nyɛ ɗikima teɗye kɛ́ ɗikima kpokɛ temɔ ɓomɔ hɛnɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɛ ɓekoko ma ɗya̧ kɛ́, ɛ Yesus pundɛ ɗuwɛ kɛ mɔy ɗya ɓenɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɛ ɓo ma nje tɔkɛ sendi nje ɓemɛŋmɛnɛ kɛ́, ɓejekɛ sém nde, njuku *figiye kɔ ma gwe sɔsɔ nɛ kawoyo kandɛ kɛ toŋ te kumɔ nji̧. ");
INSERT INTO kkj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ɛ Piyɛr takɛ yasi te yi kwaŋnama kɛ́. Ɛ nyɛ lɛpɛ nyɛ Yesus nde: «Yekele, ɓɛŋa njuku figiye te yi wɛ ma kítaŋgwɛ nɛ nyɛ kɔ ma sɔsɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ɛ Yesus nje ɗiyɔ lɛpɔ nyɛ ɓo nde: «Wunɛ tîki temɔ kɛ yi Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mumɔ lɛpɛ nyɛ keki te yɔkɔ nde: ‹Ɗûkwɛ waka kɛ̀ ɓalɔ kɛ maŋ,› yo ta kelna ɗete, ŋgɛ nyɛ tikɛ temɔ nde, yasi hɛnɛ te yi nyɛ lɛpima kɛ́ ta kelna gbate kinɛ ɓɛ nɛ mɛso kɛ temɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yori yi mi lɛpɛ nyɛ wunɛ nde: Yasi hɛnɛ te yi wunɛ ta diyɛ Njambiyɛ kɛ mɛŋgwɛta mun, ŋgɛ wunɛ tikɛ temɔ nde, wunɛ mɛ nɛ ya te, Njambiyɛ ta nyɛ wunɛ yo. ");
INSERT INTO kkj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Ma kɛ ŋgimɔ hɛnɛ te yi wunɛ tɛmɛ yí ŋgwɛta nɛ Njambiyɛ, ŋgɛ ɓɛ nde, wunɛ nɛ yiŋa lɛpi suŋgwɛ nɛ wɛtɛ mumɔ, wunɛ tîki nyɛ nɛ ŋgwɛtɛ, nɛ́ Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ tiki sendi wunɛ nɛ ŋgwɛtɛ kɛ ɓeya mɛyasi mɛte yi wunɛ kelɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma ŋgɛ wunɛ ti tikɛ ɓɛsɔ nɛ ŋgwɛtɛ na, saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ tí tikɔ sendi wunɛ nɛ ŋgwɛtɛ kɛ ɓeya mɛkele mun na.» ");
INSERT INTO kkj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɓo yɔkwa̧ wolo kɛ̀ kɛ Yerusalɛm. Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ jombila kɛ mɔy mbanjɔ Njambiyɛ kɛ́, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ ɓetomba ɓe ɗya nje kɛ yenɛ ");
INSERT INTO kkj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","diyɛ nyɛ nde: «Ɗeti te yi wɛ kelɛ nɛ mɛyasi mɛte yikɛ kɛ́ wúla we? Nda nyɛ wɛ ɗeti nde, kelɔ mɛyasi mɛte?» ");
INSERT INTO kkj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Mi sendi, mi ndi nɛ lɛpi wɛtɛ yi mi ta diyɛ wunɛ, nɛ̀ wunɛ yêŋsaŋgwɛ nyɛ mi, nɛ́ mi nje lɛpi mbɛy te yi ɗeti te yi mi kelɛ nɛ mɛyasi mɛte wulɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nda tomɛ Jaŋ nde, a njâki tɔpɛ ɓomɔ kɛ mɔrɔku? ’Yo Njambiyɛ ho yo ɓomɔ? Ma nɛ yêŋsaŋgwɛ nyɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ndana, ɛ ɓo kandɛ mɛdiyna tandɛ yan lɛpɔ nde: «Ŋgɛ wusɛ lɛpɛ nde: Yo Njambiyɛ tomɛ nyɛ, yite a ta diyɛ nde: Ma kɛto ŋge yi wunɛ tì tikɛ temɔ kɛ yasi te yi nyɛ lɛpima kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma ŋgɛ wusɛ nje yeŋsa nde: Yo ɓomɔ tomɛ nyɛ, yite...» Ɓo lɛ́pi ɗete, kɛto ɓo ɓa̧ kɛ kambɔ ŋgil ɓomɔ, kɛto ɓomɔ hɛnɛ ɓɛŋma nde, Jaŋ gbate mɔ punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɗete, ɛ ɓo yeŋsa nyɛ Yesus nde: «Wusɛ yeti kɛ duwɛ na.» Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Mi sendi, mi yeti kɛ lɛpɔ yaŋa nyɛ wunɛ kɛ kasi ɗeti te yi mi kelɛ nɛ mɛyasi mɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kɛ kɔŋte, ɛ Yesus kandɛ lɛpina mɛyasi nyɛ ɓo nɛ nje mɛkanɔ. Ɛ nyɛ lɛpɛ nde: «Wɛtɛ mumɔ sama ŋgwaŋ *vinyɛ. Ɛ nyɛ kelɛ kakwɛ litɔ nɛ yo, timɔ mbɛy sɔpita mɛmbumɔ, sumɔ sendi doŋgbe doŋgbe tu̧ yí pɛmna ŋgwaŋ. Ɛ nyɛ nje kaŋɛ yo hɛnɛ nyɛ ɓaŋa ɓotu ɓe mɛsay nde, ɓo ɓâkiɗya, ɓɛ sendi nɛ ŋgaɓiyɛ te yan kɛte. Kɛ kɔŋte, ɛ nyɛ kwa̧ lɔndunate kɛ̀ yiŋa mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kɛ ŋgimɔ te yi mɛmbumɔ sima ɗetɔ kɛ ŋgwaŋ ma ɗya̧, ɛ nyɛ tomɛ wɛtɛ mɔ mɛsay kɛnjɛ kɛ yi ɓari, nɛ́ ɓo njesɛ nyɛ ŋgaɓiyɛ mɛmbumɔ mɛte yenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yasi wɛtɛ, ɓotu ɓe mɛsay te ɓari tɛmma ɓiye nyɛ mɛndɛ yɔkiɗye nyɛ nɛ gboŋgo ɓɔ. ");
INSERT INTO kkj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kɛ kɔŋte, ɛ nyɛ tomɛ sendi wɛtɛ mɔ mɛsay kɛnjɛ ɓo. Ɛ ɓo mɛndɛ mbɛte kɔmbɛ kɛ to toyɛ nyɛ wuŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A nja̧ tomɔ sendi mbaŋa kɛ kɔŋ te yɔru. Ɛ ɓo wo mbɛte. Ɛ nyɛ nje tomɔ sendi ɓaŋa ɓuɗyate kɛnjɛ. Ɓo natima ɓaŋa tumbɔ wo ɓaŋa. ");
INSERT INTO kkj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ndana, ɛ nyɛ tika ndi nɛ ndaŋga mɔnɔ wenɛ, sɔŋ temɔ nɛ. Yí siɗyɛ nɔ, ɛ nyɛ nje tomɔ nyɛ kɛnjɛ lɛpɔ nde: ‹Ɓo ta kambɔ, kɛto yo mɔnmbɛ.› ");
INSERT INTO kkj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yasi wɛtɛ, ɓotu ɓe mɛsay ɓaka nja̧ lɛpɔ tandɛ yan nde: ‹Nɛ ɓɛ̂ŋa, mɔ te ɛ ta tika nɛ mɛlikɔ, ɛkɔ! Nɛ njâki, hɛ wôku nyɛ, nɛ́ wusɛ tika su nɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɛ ɓo ɓiye nyɛ wo, ɓu̧ muŋ nɛ kɛ̀ li̧ kɛ kɔŋ ŋgwaŋ. ");
INSERT INTO kkj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Ma sa ŋgwaŋ ta nje kelɔ nan? A ta nje girise ɓotu ɓe mɛsay ɓenɔri nje kaŋɛ ŋgwaŋ nyɛ ɓaŋa. ");
INSERT INTO kkj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Yite nde, wunɛ tì pa tɔlɔ lɛpi kɛ yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ na? Yo kɛtinate nde: ‹Tari*f1* te yi ɓotu ɓe sumna tu̧ sɛŋma kɔ kpalma nje ɓɛ saŋgwɛ kondu. ");
INSERT INTO kkj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ma yasi kɛ, yo mɛkele mɛ Baba Mbokɔ, yo yasi te yi wusɛ ɓɛŋɛ ŋgbakima.› » ");
INSERT INTO kkj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kɛ ɓekum Ɓeyudɛn ma si wokɔ mɛlɛpi mɛnɔri hɛnɛ kɛ́, ɛ ɓo sa̧ nje te yi ɓiye Yesus, kɛto ɓo duwa̧ nde, a nyɛ́ki kanɔ te suŋgwɛ nɛ ɓo. Yasi wɛtɛ, ɓo ɓa̧ kɛ kambɔ ŋgil ɓomɔ, ɗete ɛ ɓo jisɛ kwa̧ tikɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɓo nja̧ tomɔ ɓaŋa *Ɓefarisɛ̧ nɛ̀ ɓaŋa ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ kumande Herod ɓaka kɛnjɛ kɛ yi Yesus, nɛ́ ɓo dɔŋgiɗye nyɛ wulɛ kɛ lɛpi te yi ta pundɔ kɛ numbu nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɛ ɓo ɗya̧ lɛpɔ nyɛ nyɛ nde: «Yekele, wusɛ duwa̧ nde, wɛ mɔ gbakasi ko kɛ misi mɛ nda, kɛto wɛ ti ɓáŋ yɔ mbɛri misi mɛ mumɔ na. Wɛ téɗya yɔ nje Njambiyɛ gbate gbate. ’Mɛmboŋga lɛ́pi nde, mumɔ gbôku garama nyɛ *Sesar? ’Hɛ gbôku ho hɛ tî gboku?» ");
INSERT INTO kkj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesus duwa̧ likisi yan, ɛ nyɛ diyɛ ɓo nde: «Wunɛ ɓóɓa mi kɛto ŋge? Wunɛ ɓôŋ nɛ sule wɛtɛ nje nɔ, nɛ́ mi ɓɛŋ.» ");
INSERT INTO kkj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɛ ɓo nje nɔ ɓu̧ kaŋɛ nyɛ nyɛ. Ɛ nyɛ diyɛ ɓo nde: «Yikɛ yekambiyɛ to nda? Kɛtina mɛkɛti mɛte yikɛ téɗya nda?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Yo yi Sesar.» ");
INSERT INTO kkj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Wunɛ nyɛ̂ki Sesar mɛyasi mɛte yenɛ, nyɛ Njambiyɛ mɛyasi mɛte yenɛ.» Ɓo ŋgbakimama ɓuɗyate kɛ yasi te yi nyɛ yeŋsama kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Ɓesadusɛ̧ lɛ́pi yan nde, ɓemuŋ tí womiyɛ na. Ɓo nja̧ sendi kɛ yi Yesus diyɛ nyɛ mɛdiyan lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Yekele, kɛ njoka mɛmboŋga musu yi Mɔyisi kɛtima kɛ́, yo kɛtinate kɛ mɔyte nde: ‹Ŋgɛ mumɔ ɓɛ nɛ maŋ, ŋgɛ maŋ wenɛ te gwe tikɔ nyari kinɛ ja ɓenɛ nyɛ na, na ɓôŋ kusɔ te, na ja kwaŋɗye nɛ ɗinɔ maŋ ɛ gwa̧ kɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yo ɓa̧ nɛ ɓaŋa ɓɔnɔ ɓembam yitan jɔ yiɓa ɓe jaɗya kɛ mɔy yan. Tomba te ɓoŋma nyari gwe kinɛ tikɔ ko mɔnɔsikɛ ɓenɛ nya te na. ");
INSERT INTO kkj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɛ ɛ kɔŋ te ɓu̧ kɔ gwe kinɛ tikɔ ko mɔnɔsikɛ ɓenɛ nya te na. Yo ɓa̧ ndi sendi ɗete nɛ mɔ yitatite. ");
INSERT INTO kkj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yo kwaŋnama ndi ɗete siɗyɛ nɛ ɓo hɛnɛ yitan jɔ yiɓa nɛ gbukup. Ko mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yan tì ja ɓenɛ nya te yí kusɔ nɛ kandɔ na. Ɗiyɔ kɛ́, ɛ nyari nje gwe sendi kɛ kɔŋ yan hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ma kɛ yesɔ te yi ɓemuŋ ta womiyɛ nɔ kɛ́, kɛ njoka ɓembam ɓaka, nya kɔ ta nje ɓɛ nya nda, kɛto ɓo hɛnɛ yitan jɔ yiɓa ɓoŋma nyɛ nɛ mɛgwaki?» ");
INSERT INTO kkj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «’Nɛ ti ɓɛ́ŋa nde, mɛjɔsɔ mun wúla, kɛto wunɛ kɛ ndekima yasi te yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ, ndekima sendi ŋguŋguɗyɛ Njambiyɛ na? ");
INSERT INTO kkj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yo nde, komɛ ɓemuŋ ta womiyɛ kɛ́, mɛgwaki tí ɓɛŋna se na. Yasi wɛtɛ, ɓomɔ hɛnɛ ta joŋna nda yi ɓejaki ɓe Njambiyɛ joŋna nɔ kɛ ɗyoɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma kɛ kasi womiya ɓemuŋ, yite nde, wunɛ tì pa tɔlɔ ka mɛkana mɛte yi Mɔyisi kɛtima kɛ́ na? Wunɛ tì pa tɔlɔ kɛ mbɛy te yi lɛpɛ kasi mɔnɔ jeti te ɛ ɓa̧ kɛ ɓiye ɗitɛ kɛ́ na? Womɛte Njambiyɛ lɛpima nyɛ Mɔyisi nde: ‹Mi mbɛ Njambiyɛ te ɛ Abaraham, Njambiyɛ te ɛ Isak, Njambiyɛ te ɛ Yakɔp.› Wunɛ tì pa tɔlɔ mbɛy te na? ");
INSERT INTO kkj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yo nde, Njambiyɛ yeti Njambiyɛ ɓemuŋ na, nyɛ Njambiyɛ te ɛ ɓotu ɓete ɓe nɛ joŋ ɓaka. Gbate, wunɛ kɛ mɔy mɛjɔsɔ nɛ pitik.» ");
INSERT INTO kkj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wɛtɛ mɔ kɛtina mɛyasi ɓa̧ kɛ lɛŋgwɛ mɛtɔ kɛ mɛso mɛte yi ɓo ɓa̧ kɛ nyɛ kɛ́. A ɓɛŋma nde, Yesus yeŋsama kimɔte nyɛ *Ɓesadusɛ̧. Ɛ nyɛ nje kɛ kɛki nɛ diyɛ nyɛ nde: «Kɛ mɛmboŋga hɛnɛ, yɛn kwa̧ ɓɛsɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Mboŋga te ɛ kwaŋma ɓɛsɔ kɔ, yo yɔkɔ ɛ lɛpɛ nde: ‹Kandɔ Isarayɛl, wokɔ. Siya Baba Mbokɔ, yo ndi Baba Mbokɔ te Njambiyɛ wusu. ");
INSERT INTO kkj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kwaɗyikwɛ Baba Mbokɔ te Njambiyɛ wɔ nɛ temɔ yɔ hɛnɛ, nɛ sisiŋ yɔ hɛnɛ, nɛ ɗyanɔ ɗyɔ hɛnɛ, nɛ ɗeti yɔ hɛnɛ.› ");
INSERT INTO kkj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mboŋga yiɓate, yo nde: ‹Kwaɗyikwɛ mɔŋ nda yi wɛ kwaɗyɛ nɛ yotu yɔ kɛ́.› Kinɛ mbaŋa mboŋga ɛ kwaŋma mɛmboŋga maka yiɓa na.» ");
INSERT INTO kkj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɛ mɔ kɛtina mɛyasi nje lɛpɔ nyɛ nyɛ nde: «Kimɔ yaŋa, yekele, wɛ lɛpima gba gbakasi yí lɛpɔ nde, siya Njambiyɛ yo ndi nyɛ nyɛpɔ, kinɛ mbaŋa se na. ");
INSERT INTO kkj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sendi, ŋgɛ mumɔ kwaɗyɛ Njambiyɛ nɛ temɔ nɛ hɛnɛ, nɛ ɗyanɔ ɗyenɛ hɛnɛ, nɛ ɗeti nɛ hɛnɛ, kwaɗyɛ jakɔsɔ mumɔ nda yi nyɛ kwaɗyɛ nɛ yotu nɛ kɛ́, yo yite laŋsa mɛsadaka hɛnɛ te yi mumɔ yakama nyɛ Njambiyɛ kɛ́. Yo yite laŋsa mɛsadaka mɛ ɓenyamɔ te yi ɓo loɗyɛ loɗyukwɛ, ko mɛsadaka mɛte yiri hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus ɓɛŋma nde, a yeŋsama kimɔte nɛ ɗyanɔ, ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Wɛ mɛ nɛdɔ te yi nyiŋɛ kɛ *Kandɔ Njambiyɛ.» Kɛ kɔŋte, ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓoɓɛ diyɛ nyɛ mɛdiyan se na. ");
INSERT INTO kkj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus ɓa̧ kɛ teɗye mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ kɛ mbanjɔ Njambiyɛ. Ɛ nyɛ diyɛ nde: «Kɛto ŋge yi ɓotu ɓe kɛtina mɛyasi lɛpɛ nde, *Krist mɔnɔ Davit kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davit nɛ ŋguru wenɛ lɛpima nɛ̀ ɗeti te yi Kimɔ Sisiŋ nde: ‹Baba Mbokɔ lɛpima nyɛ Kumande wombɛ nde: Ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ mbɛ nde, mi sîki kawule ɓependɔ ɓɔ tikɔ kɛ nji̧ mɛkol mɔ.› ");
INSERT INTO kkj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davit nɛ ŋguru wenɛ kɛ jeɓa nyɛ nde Kumande. Ma Kumande wenɛ ta kpalɔ nje ɓɛ mɔnɔ wenɛ nan?» Nyaŋgwɛ ŋgil ɓomɔ ɓa̧ kɛ lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ ɓa̧ kɛ lɛpɔ kɛ́ nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Piŋɔ te yi Yesus ɓa̧ kɛ teɗye yasi kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓomɔ nde: «Wunɛ ɗîy nɛ sɔsɔ nɛ ɓotu ɓe kɛtina mɛyasi. Ɓo kwáɗyikwɛ jaŋa nɛ nyaŋgwɛ ndulɛŋ ndulɛŋ mɛgambo kɛ mbɔmbu ɓomɔ, kwaɗyɛ sendi nde, ɓomɔ kɛ̂ nyɛnɔ ɓo kɛ mɛmbɛy komɛ ɓomɔ ɗiki wesiɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɓo kwáɗyikwɛ ɗiyɔ kɛ bosa mɛmbɛy kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, sa̧ sendi kpasa mɛmbɛy kɛ mɛtu̧ mɛdina. ");
INSERT INTO kkj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓo wɛ́njila mɛyasi hɛnɛ nɛ mbul kɛ mɛɓɔ mɛ ɓekusɔ ɓoma, ɗiki nje kelɔ sɛwna mɛŋgwɛta, nɛ́ ɓomɔ ɓɛŋ nde, ɓo kimɔ ɓomɔ. Njambiyɛ ta jɔse ɓo teɗye ɓo nyaŋgwɛ mɛbɔnɛ kwa̧ to te.» ");
INSERT INTO kkj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus ɗiyma mɛtiɗyɛ yaka nɛ kpoŋgi nyɛna sadaka nyɛ Njambiyɛ. A ɓa̧ kɛ ɓɛŋɛ nda yi ŋgil ɓomɔ ɓa̧ kɛ nyɛ mɔni kɛte kɛ́. Ɓotu ɓe kusuku ɓuɗyate ɓa̧ kɛ nyɛ ɓuɗya mɔni kɛte. ");
INSERT INTO kkj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wɛtɛ buka kusɔ nyari nja̧ ɓetɛ limbi sisi yiɓa yi yaka pata wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus jeɓama ɓejekɛ ɓenɛ lɛpɔ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Buka kusɔ nya kɔ nya kwa̧ ɓaka hɛnɛ, ");
INSERT INTO kkj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kɛto ɓari hɛnɛ nya ɓuyɔ mɛyasi mɛte yi ɓo ɓɛ nɔ kwa̧ to te kɛ́. Yasi wɛtɛ, buka kusɔ nya kɔ nya yasi hɛnɛ te yi ɓa̧ nde, a jôŋnaŋgwɛ nɔ kɛ ɗiyɔ mɛbukɔ mɛnɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ pundɔ kɛ mbanjɔ Njambiyɛ kɛ́, ɛ wɛtɛ jekɛ wenɛ lɛpɛ nyɛ nyɛ nde: «Yekele, ɓɛŋa ndi mbɛri mɛtari mɛte yikɛ wa! Ɓɛŋa ndi mɛtu̧ mɛte yikɛ wa!» ");
INSERT INTO kkj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «’Nduku, wɛ kɛ ɓɛŋɛ nyaŋgwɛ mɛtu̧ mɛte yinɔri? Kinɛ tari wɛtɛ nɛ wɛtɛ ta ɗiyɔ waka kɛ to jakɔsɔ kinɛ nde, ɓo gbûŋgula ɓetɛ kɛ mɛnɛti na!» ");
INSERT INTO kkj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kɛ kɔŋte, ɛ nyɛ kwa̧ kɛ̀ ɗiyɔ mɛtiɗyɛ yaka nɛ mbanjɔ Njambiyɛ kɛ *Keki mɛoliviye. Nɛ̀ Piyɛr nɛ̀ Jak nɛ̀ Jaŋ ɓu̧ Andere ɓa̧ ndi ɓenɛ ɓe Yesus ɓepɔ. Ɓo diyma nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Lɛpɔ nyɛ wusɛ, mɛyasi mɛte ta kwaŋna ndenɛn? Yo ŋge yi ta teɗye nde, mɛyasi mɛte hɛnɛ ta ɓɛ kɛ kelna kumɔ kɛ njenate?» ");
INSERT INTO kkj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ndana, ɛ Yesus kandɛ lɛpi lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy nɛ sɔsɔ, ma mumɔ mɛ nje seɓile wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kɛto ɓomɔ ɓuɗyate ta nje nɛ ɗinɔ ɗyembɛ lɛpɔ nde: ‹Mi *Krist, mi kɔ!› Ɗete, ɓo ta seɓile ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Komɛ wunɛ ta wokɔ ɓomɔ kɛ lɛpɔ kasi mɛɗyambi, wokɔ ŋgum ŋgum te kɛ́, wunɛ tî gwaki kaŋ yaŋa na, kɛto mɛyasi mɛte yâkaŋgwɛ kelna. Ndi nde, yite tì pa ɓɛ siyna mɛyasi na. ");
INSERT INTO kkj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kandɔ wɛtɛ ta tɛmɛ lu̧ ɗyambi nɛ wɛtɛ kandɔ. Kumande wɛtɛ má tɛmɛ lu̧ ɗyambi nɛ jakɔsɔ. Mɛnɛti ta ŋgwaŋgwa kɛ yiŋa mɛmbɛy. Kolɔ ta kelna kɛ to mɛnɛti. Mɛyasi mɛnɔri ta ɓɛ ndi gbɛla toŋ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ma wunɛ ɗîy yun nɛ sɔsɔ, kɛto ɓo ta ɓu̧ wunɛ kaŋɛ nyɛ ɓotu ɓe pɛsina jɔsi. Ɓo ta njurɔ wunɛ nɛ njambala kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Wunɛ ta tɛmɛ kɛ mbɔmbu ɓekum nɛ̀ kɛ mbɔmbu ɓekumande jɔse lɛpi kɛ kasi mbɛ. Yo ta kelna ɗete, nɛ́ wunɛ lɛpi mɛyasi mɛte yi wunɛ ɓɛŋma nɛ̀ yi wunɛ duwa̧ kɛ kasi mbɛ kɛ́ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bosa yasi, yo nde, ɓo kânda pa pelɛ Kimɔ Tom nyɛ mɛkandɔ mɛ ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Komɛ ɓo ta ɓu̧ wunɛ kɛ̀ nɔ kɛ mbɔmbu ɓotu ɓe pɛsina jɔsi kɛ́, wunɛ tî kanda gwe kaŋ wo yotu kɛ yasi te yi wunɛ ta lɛpɔ kɛ́ na. Yasi wɛtɛ, wunɛ lɛ̂pi ndi lɛpi te yi Njambiyɛ ta nyɛ wunɛ kɛ numbu kɛ kiya mbɛy kɛ́, kɛto yeti wunɛ ta lɛpina na, yo Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Maŋ ta ɗyaŋgwɛ maŋ wenɛ nyɛ ɓomɔ, nɛ́ ɓo wo nyɛ. Saŋgwɛ nɛ mɔnɔ ta kelɔ sendi ɗete nɛ mɔnɔ wenɛ. Ɓɔmbɛsikɛ ta lu̧ ɗyambi suŋgwɛ nɛ ɓesaŋgwɛ ɓan nɛ̀ ɓenyaŋgwɛ ɓan ɗyaŋgwɛ ɓo nyɛ ɓomɔ, ɓo má wo ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓomɔ hɛnɛ ta ɓenɔ wunɛ kɛto ɗinɔ ɗyembɛ. Ma yɔkɔ ɛ ta gbisɔ kelɔ tiŋ kumɔ kɛ siynate kɔ ta ju̧. ");
INSERT INTO kkj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Wunɛ ta ɓɛŋɛ mɔ te yi ɓo jeɓa nde *Nyaŋgwɛ mɔ ɓekiɗya mɛyasi ɛ kelɛ gbutu ɓiye nɛ mbanjɔ Njambiyɛ kɔ kɛ nje ɗiyɔ kɛ mbɛy te yi nyɛ ti yaka ɗiyɔ kɛte kɛ́. Ma mɔ te ɛ tɔlɛ mɛlɛpi maka kɔ wôku to te ɗiyɔ nɛ sɔsɔ.» Ɛ nyɛ nje lɛpɔ nde: «Komɛ wunɛ ta ɓɛŋɛ mɛyasi mɛte kɛ kwaŋna ɗete, nɛ̀ ɓotu ɓete ɓe ɗiyɛ kɛ mɛnɛti mɛ Yuda ɓaka sɛ̂ɗyikwɛ kambɔ kɛ̀ kɛ to mɛkeki. ");
INSERT INTO kkj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mɔ te ɛ ta ɓɛ kɛ tosiyɔ̧ kɔ pîkwɛ kinɛ pa nyiŋɛ tu̧ nde, na kɛ̀ ɓu̧ yaŋa pundɔ nɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sendi, mɔ te ɛ ta ɓɛ kɛ ŋgwaŋ kɔ tî yɔkwɛ nɛ kɔkɔ nde, na pa kɛ̀ ɓu̧ lambɔ nɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ɓoma ɓete ɓe ta ɓɛ nɛ mɔy nɛ̀ ɓaka ɓe ta ɓɛ ndi kɛ nyɛ ɓɔnɔsikɛ ɓɛri kɛ ŋgimɔ te yite ɓaka ta saŋgwa nɛ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ nde, mɛyasi mɛte tî ɗyaŋ kɛ ŋgimɔ abekata na, ");
INSERT INTO kkj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kɛto kɛ ŋgimɔ te yite, nyaŋgwɛ mɛbɔnɛ ta ɓɛŋna. Kandɛ yi Njambiyɛ ma kúsu nɛ mbokɔ kumɔ ndana yiŋa nyaŋgwɛ mɛbɔnɛ tì pa ɓɛŋna ɗete na. Sendi, yiŋa nyaŋgwɛ mɛbɔnɛ tí ɓɛŋna se ɗete wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti ɓɛ́ki nde, Baba Mbokɔ kâya ɓuyɔ mɛtu mɛte tikɔ nɛ ŋgbet na, ma mumɔ wɛtɛ nɛ wɛtɛ tí ju̧ na. Yasi wɛtɛ, a kayma yo, kɛto ɓotu ɓete ɓe nyɛ sima si tɔkɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ma ŋgɛ mumɔ lɛpɛ nyɛ wunɛ nde: ‹Ha *Krist waka ho a wari!› wunɛ tî jaya na. ");
INSERT INTO kkj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kɛto ɓotu ɓete ɓe lɛpɛ ja̧ nde, ɓo Krist nɛ̀ ɓaka ɓe lɛpɛ sendi nde, ɓo ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓaka ta nje. Ɓo ta kelɔ mɛyekambiyɛ, kelɔ sendi nyaŋgwɛ mɛyasi, ɓo yakama jatiɗye ko ɓotu ɓete ɓe Njambiyɛ sima si tɔkɛ ɓaka kɛ yiŋa nje. ");
INSERT INTO kkj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma wunɛ ɗîy nɛ sɔsɔ, mi ma lɛpɔ mɛyasi hɛnɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ma kɛ kɔŋ mɛtu mɛ nyaŋgwɛ mɛbɔnɛ mɛnɔri yesɔ ta ɗimɔ, ŋgwɛndɛ tí panɔ se na. ");
INSERT INTO kkj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ɓesisɔ̧ ta kɛtiyɛ kɛ kwey ɓalɔ kɛ mɛnɛti. Mɛyasi mɛte yi ɓɛ nɛ ŋguŋguɗyɛ yi ɗiyɛ kɛ kwey kɛ́ ta ŋgbɔkisa ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kɛ kɔŋte, ɓo ta ɓɛŋɛ *Mɔnɔ mumɔ kɛ nje nɛ mɛkulutu nɛ nyaŋgwɛ ŋguŋguɗyɛ nɛ̀ nyaŋgwɛ mɛluksa. ");
INSERT INTO kkj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A ta tomɔ ɓejaki ɓenɛ kɛnjɛ kɛ mɛmbɛy hɛnɛ, kɛ mɛɓoku mɛ mɛnɛti maka hɛnɛ yini kɛ to mbokɔ. A ta wesiɗye ɓotu ɓete ɓe nyɛ sima si tɔkɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Wunɛ ɓôŋ ɗyanɔ kɛ yasi te yi *figiye teɗye kɛ́. Kɛ ŋgimɔ te yi mɛɓɔ mɛte mɛ kɛ ɓɔyɛ nɛ̀ kɛ ŋgimɔ te yi mɛmbɔru mɛte mɛ kɛ lo, wunɛ kɛ duwɛ nde, ŋgimɔ mbiyɔ ma wuta. ");
INSERT INTO kkj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɗete sendi, komɛ wunɛ ta ɓɛŋɛ nde, mɛyasi mɛte mɛ kɛ ɗya̧, wunɛ dûkwɛ nde, *Mɔnɔ mumɔ mɛ nɛdɔ te yi nje, yasi mɛ kɛ ŋgiŋ nyinɔ. ");
INSERT INTO kkj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ko ɓotu ɓete ɓe nɛ joŋ kɛ ŋgimɔ te yɔkɔ ɓaka tí gwe hɛnɛ kinɛ nde, mɛyasi mɛnɔri hɛnɛ ɗyâŋ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ɗyoɓɔ nɛ̀ mɛnɛti ta si kwa̧ yambile, ma ndi mɛlɛpi mɛmbɛ tí yambile ko wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ma kɛ kasi yesɔ nɛ̀ hawa te yi mɛyasi mɛte ta ɗya̧ kɛte kɛ́, ko mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ na, ko ɓejaki ɓete ɓe ɗiyɛ kɛ ɗyoɓɔ ɓaka, ko *Mɔnɔ, ndi Da nyɛpɔ duwɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wunɛ ɗîy nɛ sɔsɔ, wunɛ pɛ̂m yasi, kɛto wunɛ yeti kɛ duwɛ ŋgimɔ te yi mɛyasi mɛte ta ɗya kɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yo ta ɓɛ nda yi wɛtɛ mbam ɛ tɛmma kwa̧ kɛ̀ lɔndunate kɛ wɛtɛ mɛnɛti, tikɔ tu̧ ɗyenɛ kaŋɛ mɛyasi hɛnɛ nyɛ ɓotu ɓe mɛsay ɓenɛ. A teɗya mumɔ hɛnɛ yasi te yi nyɛ yâkaŋgwɛ kelɔ, lɛpɔ nyɛ mɔ te ɛ ɗikima ɓakiɗye numɛy kɔ nde, a pɛ̂m yasi. ");
INSERT INTO kkj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ɗete, wunɛ pɛ̂m yasi, kɛto wunɛ yeti kɛ duwɛ ŋgimɔ te yi sa tu̧ ta yɔkwɛ kɛte kɛ́ na. A yakama yɔkwɛ ho ɓekoko ho nɛ ɓembe tu ho kɛ ŋgimɔ kɔku kuɓɛ ho ɓemɛŋmɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wunɛ pɛ̂m yasi, kambɔ a mɛ nje ɗya̧ nɛ ɓɛlɛm dɔŋgiɗye wunɛ kɛ jakɔ. ");
INSERT INTO kkj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yasi te yi mi lɛpɛ nyɛ wunɛ kɛ́, mi lɛ́pi nyɛ ɓomɔ hɛnɛ: Wunɛ pɛ̂m yasi.» ");
INSERT INTO kkj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesɔ *Paska Ɓeyudɛn nɛ̀ ŋgimɔ jesɔ ɗyena mɛmampa te yi kinɛ ŋga̧ kɛte kɛ́ ɓukwa̧ ndi mɛtu yiɓa, nɛ́ yo kelna. Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi saŋma nje te yi ɓo yakama ɓiye Yesus nɛ nje likisi yí wo nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɓo saŋma nje te ɗete, kɛto ɓo ɗikima lɛpɔ nde: «Yo tî kelnaŋgwɛ kɛ ɓembe jesɔ na, kambɔ ɓomɔ mɛ nje kelɔ mɛyasi nɛ hoya hoya.» ");
INSERT INTO kkj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus ɓa̧ kɛ Betani kɛ tu̧ wɛtɛ mbam nde Simɔn, a ɓa̧ kɛ kɔnɔ nɛ ndoko. Piŋɔ te yi ɓo ɓa̧ kɛ ɗyena kɛ́, ɛ wɛtɛ nyari nyiŋɛ tu̧ nɛ wɛtɛ ndaki tondunate nɛ yiŋa lɔbinda nde *nar yi ɗye ɓuɗya mɔni. Ɓo sama ndaki te nɛ wɛtɛ tari nde albatɛrɛ. Lɔbinda te ɓa̧ nɛ sɛŋgɛlɛŋ, ɓo tì pulɛ yo nɛ yiŋa yasi na. Ɛ nya kɔ lekɛ numbu ndaki kumbɛ mutɔ yinɔri kɛ to Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɓaŋa ɓotu ɓete ɓe ɓa̧ womɛte ɓaka wokuma ŋgambi lɛpɔ tandɛ yan nde: «To ɓekiɗya lɔbinda te yikɛ ɓa nɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma ɓo ɗyaŋgwa yo ɓuɗya mɔni laŋsa ɓuyɔ mɔni te yi ɓo gbo nɛ mɔ mɛsay kɛ mɛtu mɛsay gɔmay yitati yí kamɛ nɛ ɓotu ɓe ŋgwɛtɛ.» Ɛ ɓo lɛpina ɓeyate suŋgwɛ nɛ nya kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yasi wɛtɛ, ɛ Yesus lɛpɛ nde: «Wunɛ tîki nyɛ nɛ sɛm. Kɛto ŋge yi wunɛ njaŋgwɛ nyɛ kɛ́? A kelma kimɔ yasi nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nɛ ɓɛ̂ŋa, wúnɛ ɓotu ɓe ŋgwɛtɛ kɛ ɗiyɔ kɛ kiya mbɛy mɛtu hɛnɛ. Ɗete, mɛŋgimɔ hɛnɛ te yi wunɛ kwaɗyɛ, wunɛ yakama kelɔ kimɔ yasi nɛ ɓo. Ma kɛ ɓɛ mi, mi tí ɗiyɔ mbɛ sinɛ wunɛ kɛ kiya mbɛy mɛtu hɛnɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yasi te yi nyɛ ɓa̧ nɛ ɗeti te yi kelɔ, a kelma. A kandima si lɔmbɛ mi lɔbinda kɛ yotu mbɛ yí laɗye nɛ pumbuna mbɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mbɛy hɛnɛ te yi ɓo ta pelɛ Kimɔ Tom kɛ to mɛnɛti hɛnɛ, ɓo ta yekiɗye sendi yasi te yi nya kɔ kelma kɛ́, nɛ́ ɓomɔ taki nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas te Iskariyot, yɔkɔ ɛ ɓa̧ kɛ njoka ɓejekɛ kamɔ jɔ yiɓa kɔ kwaŋma kɛ̀ kɛ yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ, na kɛ̀ ɗyaŋgwɛ Yesus nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kɛ ɓo ma si wokɔ yasi te yi nyɛ lɛpima nyɛ ɓo kɛ́, ɛ ɓo ɓɛ nɛ mɛsosa ɓuɗyate. Ɛ ɓo kpo nde, ɓo ta nyɛ nyɛ mɔni. Ndana, ɛ Yudas kandɛ saŋna kimɔ ŋgimɔ te yi nyɛ yakama ɗyaŋgwɛ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bosa yesɔ jesɔ ɗyena mɛmampa mɛte yi kinɛ ŋga̧ kɛte kɛ́ ɗyaŋma. Yo yesɔ wona ɓɔnɔ ɓesam nɛ sadaka yi mɛɗye mɛ jesɔ *Paska Ɓeyudɛn. Ɛ ɓejekɛ ɓe Yesus diyɛ nyɛ nde: «Wɛ kwáɗyikwɛ nde, wusɛ kɛ̂n kombile mbɛy ɗyena jesɔ Paska te yɔ we?» ");
INSERT INTO kkj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɛ nyɛ tomɛ ɓaŋa ɓejekɛ ɓenɛ yiɓa lɛpɔ nyɛ ɓo nde: «Wunɛ kɛ̂n kɛ nyaŋgwɛ ɗya, wunɛ ta saŋgwa nɛ wɛtɛ mbam nɛ mapi mɔrɔku, nɛ̀ wunɛ ɓêŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mbɛy te yi nyɛ ta nyiŋɛ kɛte, wunɛ lɛ̂pi nyɛ sa tu̧ nde: ‹Yekele nde: Mbɛy te yi sinɛ ɓejekɛ ɓembɛ ta ɗye Paska kɛte kɛ́ ɓa we?› ");
INSERT INTO kkj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A ta teɗye wɛtɛ nyaŋgwɛ toŋgari nyɛ wunɛ kɛ tu̧ kwey kɛ pay to te nɛ mɛyasi hɛnɛ gweya̧ kombilate kɛ mɔyte. Yo womɛte yi wunɛ ta kombile mɛɗye mɛ Paska te yusu.» ");
INSERT INTO kkj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɓejekɛ ka̧ ɗya̧ kɛ mɔy ɗya dolɔ mɛyasi hɛnɛ nda yi Yesus lɛpima nyɛ ɓo kɛ́. Ɛ ɓo kombile mɛɗye mɛ Paska. ");
INSERT INTO kkj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kɛ ɓekoko ma ɗya̧ kɛ́, ɛ Yesus ɗya̧ ɓenɛ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Piŋɔ te yi ɓo ɓa̧ kɛ mbɛy mɛɗye kɛ ɗyena kɛ́, ɛ nyɛ lɛpɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wɛtɛ mumɔ kɛ njoka yun ta ɗyaŋgwɛ mi, a waka kɛ ɗyena sinɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yo nya ɓo ŋgambi ɓuɗyate kɛ temɔ. Ɛ mumɔ hɛnɛ diyɛ nyɛ wɛtɛ wɛtɛ nde: «’Yo ka mi?» ");
INSERT INTO kkj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yo wɛtɛ mumɔ kɛ njoka yun ɓejekɛ kamɔ jɔ yiɓa, sinɛ nyɛ kɛ ɓetɛ ɓɔ kɛ kiya katɔ mɛɗye wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Mɔnɔ mumɔ ta kwa̧ gbate nda yi yo kɛtinate kɛ kasi nɛ kɛ mɛkana mɛ Njambiyɛ kɛ́. Ndi nde, mɛbɔnɛ ta ɓalɔ kɛ to mɔ te ɛ ɗyaŋgwɛ nyɛ kɔ. Ɓo má ɗiy kinɛ ja mɔ te, ma yo gba kimɔte ɓuɗyate kɛ yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Piŋɔ te yi ɓo ɓa̧ kɛ ɗyena kɛ́, ɛ Yesus ɓu̧ mampa. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ lekɛ yo kaŋɛ nyɛ ɓo lɛpɔ nde: «Wunɛ ɓôŋ, yikɛ mɛmbundɔ mɛmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kɛ kɔŋte, ɛ nyɛ ɓu̧ pelɔ nɛ tena mɛnjam kɛ mɔyte. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ kaŋɛ yo nyɛ ɓo, ɛ ɓo hɛnɛ hɔɓiye. ");
INSERT INTO kkj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Yikɛ mɛkiyɔ mɛmbɛ, yo mɛkiyɔ mɛte yi kelɛ mbon, mɛkiyɔ mɛte yi kɛ nyanja kɛto ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ko mi tí hɔɓiye se tena mɛnjam maka na kumɔ kɛ ŋgimɔ te yi mi ta nje hɔɓiye nɛ wɛtɛ jɔnjate kɛ *Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kɛ ɓo ma si jembina yí lukse nɛ Njambiyɛ kɛ́, ɛ ɓo kwa̧ kɛ̀ kɛ *Keki mɛoliviye. ");
INSERT INTO kkj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Yasi te yi mi ta saŋgwa nɔ kɛ́ ta njaŋgwɛ wunɛ hɛnɛ kɛ tikina temɔ te yi wunɛ tikɛ kɛ yembɛ kɛ́, jatiɗye wunɛ kɛ ɓeya nje. Kɛto yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Mi ta mukɔ mɔ ɓakiɗya ɓesam, ɓesam má si wanja.› ");
INSERT INTO kkj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yasi wɛtɛ, komɛ mi ta womiyɛ kɛ́, mi ta kandɛ kumɔ Galile nɛ wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, kɛ yi ɓomɔ hɛnɛ yasi te yi wɛ saŋgwa nɔ kɛ́ ta njaŋgwɛ ɓo ɗete kɛ tikina temɔ te yi ɓo tikɛ kɛ yɔ kɛ́, jatiɗye ɓo kɛ ɓeya nje, ma pɛlɛ yembɛ, ko yo tí ɓɛŋna ɗete na.» ");
INSERT INTO kkj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Kɛ gba tu te yɔkɔ muka wɛ ta tonɔ kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na piŋɔ te yi kuɓɛ tì pa kɔkɔ kumɔ mɛŋga yiɓa na.» ");
INSERT INTO kkj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yasi wɛtɛ, ɛ Piyɛr pitiɗye kɛ numbu nɛ lɛpɔ nde: «Ko ɓɛkɔ nde, sɔŋ te ɓîya mi sinɛ wɛ, ko mi tí tonɔ nɛ mbɛt nde, mi yeti kɛ duwɛ wɛ na.» Ɓo hɛnɛ lɛpima ndi ɗete sendi. ");
INSERT INTO kkj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kɛ kɔŋte, ɛ ɓo kwa̧ kɛ̀ kɛ wɛtɛ mbɛy nde Gɛtsemane. Ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wunɛ ɗîy mɛtiɗyɛ waka kumɔ kɛ ŋgimɔ te yi mi ta siɗyɛ mɛŋgwɛta nɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɛ nyɛ ɓu̧ Piyɛr nɛ̀ Jak nɛ̀ Jaŋ kwa̧ nɔ. Ɛ wɔ̧ kandɛ ɓiyna nɛ ɓuɗyate, temɔ nɛ ɓa̧ nɛ haɓuɓu. ");
INSERT INTO kkj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Temɔ mbɛ nɛ ŋgambi nda mi ta gwe. Wunɛ ɗîy waka, nɛ ɗîy mɛjemsiɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɛ nyɛ kwa̧ nɛ mbɛt kɛ̀ mbɔmbu ɓalɔ kɛ mɛnɛti ŋgwɛta nɛ Njambiyɛ, ho ŋgimɔ mɛbɔnɛ mɛte yite yakama lɔndɔ kɛ kɛki nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A ɗikima lɛpɔ nde: «*Aba Da, wɛ nɛ ɗeti te yi kelɔ mɛyasi hɛnɛ. Kelɔ nde, nyaŋgwɛ mapi mɛbɔnɛ mɛte yikɛ ɗûkwɛ kɛ to mbɛ. Ma yo tî kelnaŋgwɛ nda yi mi kwaɗyɛ kɛ́ na, yo kêlnaŋgwɛ nda yi wɛ kwaɗyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɛ nyɛ kɛ̀ yɔkwɛ nje komɛ ɓejekɛ ɓa̧ kɛ́ dolɔ ɓo kɛ jakɔ. Ɛ nyɛ lɛpɛ nyɛ Piyɛr nde: «Simɔn, wɛ kɛ gba jakɔ. Ko gbɛla hawa wɛtɛ, wɛ tì wɛliyɛ ɗiyɔ mɛjemsiɗyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wunɛ ɗîy mɛjemsiɗyɛ, nɛ̀ wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ, ma mɛɓoɓilan mɛ nje laŋsa wunɛ. Temɔ nɛ yɛsiɗyɛ kelna kimɔ yasi, ko ɗete, mɛmbundɔ nɛ tɛkɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɛ nyɛ jisɛ wolo kwa̧ kɛ̀ nɛ naŋ kɛ̀ ŋgwɛta nɛ Njambiyɛ lɛpɔ ndi kiya mɛlɛpi mɛte yi nyɛ kandima lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A ka̧ gbiŋgbɔ mate nje dolɔ sendi ɓo kɛ jakɔ, kɛto jakɔ kwaŋma ɓo kɛ misi. Ɓo tì ɓɛ nɛ yaŋa te yi ɓo yakama yeŋsa nyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kɛ kɔŋte, ɛ nyɛ nje kɛ mɛŋga yitatite, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ kômbila ya ndana, wɛɗya yun lalɛ. Yakama yɛy, ŋgimɔ ɗyaŋma. Nɛ ɓɛ̂ŋa, ɓo ta ɓu̧ *Mɔnɔ mumɔ ndana kaŋɛ nyɛ kɛ mɛɓɔ mɛ ɓotu ɓe mɛɓeyɔ. ");
INSERT INTO kkj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nɛ tɛ̂ma, hɛ kwâŋ. Nɛ ɓɛ̂ŋa, mɔ ɗyaŋgwɛ mi kɔ yima!» ");
INSERT INTO kkj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus ɓa̧ ndi kɛ lɛpɔ ɗete kɛ́, yaka nɛ Yudas te ɛ ɓa̧ kɛ njoka ɓejekɛ kamɔ jɔ yiɓa kɔ kɛ ɗya̧. A nja̧ nɛ nyaŋgwɛ ŋgil ɓomɔ. Ɓo ɓa̧ nɛ mɛkafa nɛ̀ mɛtegbe. Yo ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ ɓetomba ɓe ɗya tomɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ nya ɓo kasiya nde: ‹Mɔ te yi mi ta nyɛnɔ nyɛ dulɔ numbu nɛ kɔ, ɛru, nɛ̀ wunɛ ɓîya nyɛ kwa̧ nɔ pɛmɔ nyɛ kimɔte.› ");
INSERT INTO kkj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas ɗyaŋma kɔpɔ kɔpɔ kɛ̀ kɛ kɛki Yesus lɛpɔ nde: «Yekele!» kwa̧ dulɔ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɗete, ɛ ɓotu ɓaka ŋgbɔ ɓiye Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɛ wɛtɛ mɔ te ɛ ɓa̧ womɛte kɔ sutɛ kafa kɔtɔ nɛ mɔ mɛsay mɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ pɛsɔ tɔ nɛ ɓetɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ɛ Yesus diyɛ ɓotu ɓenɔri nde: «’Mi ka mɔ guɓɔ, nɛ́ wunɛ ɓu̧ mɛkafa nɛ̀ mɛtegbe yí nje ɓiye nɛ mi? ");
INSERT INTO kkj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mi ɗikima ɗiyɔ mɛtu hɛnɛ kɛ njoka yun teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbanjɔ Njambiyɛ, ma wunɛ tì ɓiye mi na. Yo nde, mɛyasi kwáŋnaŋgwɛ ɗekɛ, nɛ́ mɛlɛpi mɛte yi ɗiyɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tondu.» ");
INSERT INTO kkj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndana, ɛ ɓejekɛ hɛnɛ si posiyɛ li̧ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wɛtɛ gwanjɔ ɓa̧ kɛ ɓeŋgwɛ Yesus ndi nɛ gbɛla gwey kɛ yotu kinɛ yiŋa lambɔ kɛ mɔyte na. Ɛ ɓo kwaɓɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yasi wɛtɛ, ɛ nyɛ wɛkiɗye gwey tikɔ nɛ ɓo sɛɗyɛ kwa̧ sɔkɛrɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓo ɓoŋma Yesus kɛ̀ nɔ kɛ yi nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ hɛnɛ nɛ̀ ɓetomba ɓe ɗya nɛ̀ ɓotu ɓe kɛtina mɛyasi wesiɗyama womɛte. ");
INSERT INTO kkj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyɛr ɓa̧ kɛ ɓeŋgwɛ Yesus nɛ naŋ kumɔ kɛ mɔy ndoko nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. Ɛ nyɛ kwa̧ ɗiyɔ mɛtiɗyɛ ɓenɛ ɓotu ɓe mɛsay kwa̧ wɛtina ɗitɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ njɔŋ nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka saŋma to lɛpi te yi ɓo ta lɛpɔ suŋgwɛ nɛ Yesus yí wo nɛ nyɛ. Ma yasi wɛtɛ, ɓo saŋma deŋgɔ. ");
INSERT INTO kkj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yo nde, ɓomɔ ɓuɗyate ɗikima nje pɛsɔ lɛpi nyɛ nyɛ kɛ numbu. Ma ŋgiŋ yan ɓa̧ dɛlɛ dɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɓaŋa ɓomɔ tɛmma pɛsɔ lɛpi nyɛ nyɛ kɛ numbu lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Hɛ wokuma, a kɛ lɛpɔ nde: ‹Mi ta si lekɛ mbanjɔ Njambiyɛ te yɔkɔ yi ɓomɔ summa nɛ mɛɓɔ kɔ nje sumɔ wɛtɛ ndi kɛ mɛtu yitati. Mbɛte yeti mɛɓɔ mɛ ɓomɔ ta sumɔ na.› » ");
INSERT INTO kkj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko ɗete, ŋgiŋ yan ɓa̧ sendi dɛlɛ dɛlɛ kɛ lɛpi te yi ɓo lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ tɛmɛ kɛ mbɔmbu ɓomɔ hɛnɛ diyɛ Yesus nde: «’Wɛ yeti kɛ yeŋsa ka yaŋa kɛ yasi te yi ɓotu lɛpɛ suŋgwɛ nɛ wɛ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ɛ Yesus ɗiyɛ ndi nɛ sɛm kinɛ yeŋsa yaŋa na. Ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓasiɗye diyɛ nyɛ lɛpɔ nde: «’Wɛ ka *Krist, mɔnɔ Njambiyɛ te ɛ nɛ mɛluksa kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ɛ Yesus yeŋsa nde: «I̧, yo mi. Wunɛ ta ɓɛŋɛ *Mɔnɔ mumɔ mɛtiɗyɛ kɛ mbam ɓɔ Njambiyɛ te ɛ nɛ ŋguŋguɗyɛ hɛnɛ kɔ. Wunɛ ta ɓɛŋɛ sendi nyɛ kɛ nje kɛ mɔy kulutu kɛ ɗyoɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ndana, ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nyalɛ mɛlambɔ kɛ yotu nɛ lɛpɔ nde: «Ŋge yi ɓo ta lɛpɔ sendi nyɛ wusɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wunɛ wokuma lɛpi gbutu te yi nyɛ lɛpima suŋgwɛ nɛ Njambiyɛ kɛ́. Kɛ yun, nɛ ɓɛ́ŋa nan?» Ɛ ɓo hɛnɛ pɛsɛ nde, yakama nde, ɓo wôku nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɛ ɓaŋa kandɛ sana mɛsɛri kɛ yotu nɛ, wotɔ misi mɛnɛ, sɔmɔ nyɛ lɛpɔ nyɛ nyɛ nde: «Tuɓɔ mɔ te ɛ sɔmma wɛ kɔ.» Ɛ ɓotu ɓe mɛsay ɓiye nyɛ kandɛ kpakina nɛ kɛ pokɔ. ");
INSERT INTO kkj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kɛ ŋgimɔ te yi Piyɛr ɓa̧ ndi kɛ mɔy ndoko kɛ sɛ̧ kɛ́, ɛ wɛtɛ nya te ɛ ɓa̧ kɛ njoka ɓomari ɓete ɓe ɗikima kelɔ mɛsay kɛ tu̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓaka nje. ");
INSERT INTO kkj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kɛ nyɛ ma ɓɛŋɛ Piyɛr kɛ mɛwɛtina mɛ ɗitɛ kɛ́, ɛ nyɛ seŋgile nyɛ lɛpɔ nyɛ nyɛ nde: «Wɛ sendi, wɛ ɓa̧ wúnɛ Yesus te mɔ Nasarɛt.» ");
INSERT INTO kkj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ɛ Piyɛr tonɛ lɛpɔ nde: «Mi yeti kɛ duwɛ yaŋa na. Mi yeti kɛ wokɔ mbɛ to yasi te yi wɛ kwaɗyɛ lɛpɔ kɛ́ na.» Ɛ Piyɛr jisɛ kɛ mɔy ndoko kɛ̀ pɛlɛ numɛy te. Ɛ mbam kuɓɛ kɔkɛ. ");
INSERT INTO kkj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kɛ nya kɔ ma ɓɛŋɛ Piyɛr wolo kɛ́, ɛ nyɛ kandɛ lɛpinate sendi nyɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka nde: «Mbam kɔ kɛ njoka ɓotu ɓete.» ");
INSERT INTO kkj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɛ Piyɛr ɓasiɗye tonɔ. Ɗiyɔ nɛ mbɛt kɛ kɔŋ te kɛ́, ɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka lɛpɛ nyɛ nyɛ nde: «Gbate, wɛ kɛ njoka ɓotu ɓete, kɛto wɛ mɔ Galile.» ");
INSERT INTO kkj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɛ Piyɛr kandɛ mɛkinja mɛ yotu ɓiye kwey ɓiye nji̧ lɛpɔ nde: «Mi yeti kɛ duwɛ mbam te yi wunɛ lɛpɛ nɔ kɔ na.» ");
INSERT INTO kkj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yaka nɛ mbam kuɓɛ kɛ kɔkɔ kɛ mɛŋga yiɓate. Ɛ Piyɛr nje takɛ lɛpi te yi Yesus ma lɛ́pi nyɛ nyɛ nde: ‹Wɛ ta tonɔ kumɔ muka mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na piŋɔ te yi kuɓɛ tì pa kɔkɔ kumɔ mɛŋga yiɓa.› Kɛ Piyɛr ma takɛ lɛpi yinɔri kɛ́, ɛ nyɛ kandɛ ɗukwe. ");
INSERT INTO kkj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɓemɛŋmɛnɛ sut ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kelma kutu ɓenɛ ɓetomba ɓe ɗya nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ ɓomɔ hɛnɛ te ɓe ɗiyɛ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka. Kɛ ɓo ma si wotɔ Yesus kɛ́, ɛ ɓo ɓu̧ nyɛ kwa̧ nɔ kaŋɛ nyɛ nyɛ Pilat. ");
INSERT INTO kkj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat diyma nyɛ mɛdiyan lɛpɔ nde: «’Wɛ kumande Ɓeyudɛn nde?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo nda yi wɛ lɛpɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ lɛpima ɓuɗya mɛyasi suŋgwɛ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat ka̧ mbɔmbu diyɛ nyɛ nde: «Wɛ yeti nɛ yaŋa te yi lɛpɔ na? Wɛ yeti kɛ wokɔ mɛyasi hɛnɛ te yi ɓo lɛpɛ suŋgwɛ nɛ wɛ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ɛ Yesus ɗiyɛ nɛ sɛm kinɛ yeŋsa se yaŋa na. Ɛ Pilat ŋgbakima ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kɛ ŋgimɔ jesɔ *Paska hɛnɛ Pilat ɗikima soŋɛ ɓɔ nɛ mɔ jɔɓɔ wɛtɛ, yɔkɔ yi ɓomɔ ɗikima lɛpɔ nde, a sôŋa ɓɔ nɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wɛtɛ mbam nde Barabas ɓa̧ kɛ jɔɓɔ ɓenɛ ɓekumbɔ ɓenɛ, kɛto ɓo woma mumɔ kɛ ŋgimɔ te yi ɓo ɗesa nɛ to ɓomɔ suŋgwɛ nɛ ɓekum ɓe ɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ŋgil ɓomɔ sutiya kɛ̀ pɛ yi Pilat kandɛ diyna nɛ nde, a nyɛ̂ki ɓo yasi te yi nyɛ ɗiki nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ɛ Pilat nje diyɛ ɓo nde: «Wunɛ kwáɗyikwɛ nde, mi sôŋa ɓɔ nɛ kumande Ɓeyudɛn yɔkiɗye nyɛ nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilat díya ɗete, kɛto a duwa̧ nde, ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓa̧ nɛ ɓeya temɔ suŋgwɛ nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko ɗete, ɓo sesiɗya ɓomɔ nde, ɓo lɛ̂pi nyɛ Pilat nde, a sôŋa ɓɔ nɛ Barabas yɔkiɗye nyɛ ɓo, tikɔ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɛ Pilat ɓasiɗye diyɛ ɓo nde: «Wunɛ kwáɗyikwɛ nde, mi kêl nan nɛ yɔkɔ yi wunɛ jeɓa nde kumande Ɓeyudɛn kɔ?» ");
INSERT INTO kkj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɛ ɓo kembɛ wolo lɛpɔ nde: «Ŋgbakɔ nyɛ kɛ kroa!» ");
INSERT INTO kkj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ɛ Pilat diyɛ ɓo nde: «Ma yo kwalɔ ɓeya yasi te nda yi nyɛ kelma kɛ́?» Ɛ ɓo kembiɗya ndana kwa̧ to te lɛpɔ nde: «Ŋgbakɔ nyɛ kɛ kroa!» ");
INSERT INTO kkj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat kwaɗya wɛɗye temɔ yan kelɔ nda yi ɓo diyma kɛ́. Ɗete, ɛ nyɛ soŋɛ ɓɔ nɛ Barabas yɔkiɗye nyɛ nyɛ ɓo. Kɛ nyɛ ma si nyɛ ɗeti nde, ɓo njûru Yesus nɛ njambala kɛ́, ɛ nyɛ kaŋɛ nyɛ nyɛ ɓo, nɛ́ ɓo kɛ̀ ŋgba nyɛ kɛ kroa. ");
INSERT INTO kkj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɓesɔja nja̧ ŋgbɔsɔ Yesus kɛ̀ nɔ kɛ mɔy sɛ̧ ndoko kɛ mbanjɔ Pilat kɛ numɛy tu̧ ɗyenɛ. Ɛ ɓo wesiɗye ndiŋgɛlɛ njɔŋ ɓesɔja hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓo lɛnja nyɛ wɛtɛ kpasa tena gambo, ɓu̧ yiŋa mɛkɔl nɛ mɛsɔru kɛte kɛ́ jakɔ nɛ ɗuŋgwɛ te lɛnje nyɛ kɛ to. ");
INSERT INTO kkj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɛ ɓo kandɛ sombila nɛ lɛpɔ nde: «Kumande Ɓeyudɛn, hɛ lɛ̂pi!» ");
INSERT INTO kkj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɛ ɓo ɓu̧ kum soŋ kwɛlɛ nɛ nyɛ kɛ to, sa mɛsɛri kɛ yotu nɛ, kusɛ mɛɓɔŋ kɔtɔ mbɔmbu kɛ mbɔmbu wenɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kɛ ɓo ma si siɗyɛ sɛrka nɛ ɗete kɛ́, ɛ ɓo sɔrɛ kpasa tena gambo yinɔri kɛ yotu nɛ, nje lɛnje nyɛ mɛlambɔ mɛnɛ, ŋgbɔsɔ nyɛ kwa̧ nɔ, nɛ́ ɓo kɛ̀ ŋgba nyɛ kɛ kroa. ");
INSERT INTO kkj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mbaŋa mbam nde Simɔn, mɔ Sirɛn, saŋgwɛ nɛ Alɛksaŋdɛrɛ nɛ̀ Rufus ɓa̧ kɛ kwa̧ nɛ nje nɛ nje wulɛ ŋgwaŋ. Ɛ ɓesɔja jeliyɛ nyɛ nde, a sôɓa kroa Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓo ɓoŋma Yesus kumɔ nɔ kɛ mbɛy te yi ɓo jeɓa nde Golgota, yite nde Mbɛy gboŋgo to. ");
INSERT INTO kkj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kumɔ mate, ɛ ɓo ɓu̧ yiŋa mɛnjam mɛte yi ɓo pulma nɛ̀ yiŋa yasi nde *mir kɛ́ nyɛ nde, a hɔ̂ɓiya. Yasi wɛtɛ, a tì hɔɓiye na. ");
INSERT INTO kkj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kɛ ɓo ma si ŋgba nyɛ kɛ kroa ɗete kɛ́, ɛ ɓo ɓu̧ mɛlambɔ mɛnɛ lu̧ kɛ mbari yí kaɓiɗya nɛ yo, yí duwɛ nɛ ŋgaɓiyɛ te yi mumɔ hɛnɛ kɛ njoka yan yakama ɓu̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ɓo ŋgbáki nyɛ kɛ hawa yitan jɔ yini te yi ɓemɛŋmɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yí teɗye nɛ to sɔŋ nɛ, ɓo kɛtima yiŋa yasi ŋgba kɛ to kroa nɛ nde: ‹Yɔkɔ kumande Ɓeyudɛn.› ");
INSERT INTO kkj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓo ŋgbama sendi nyaŋgwɛ ɓotu ɓe guɓɔ yiɓa kɛ kroa nda Yesus, wɛtɛ kɛ kroa te wenɛ pulɔ mbam ɓɔ nɛ, wɛtɛ kɛ wenɛ pulɔ gare. ");
INSERT INTO kkj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ɗete, lɛpi te yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓo tɔlma nyɛ kɛ njoka ɓotu ɓe ɓeya mɛkele› kɛ́, sima tondɔ. ");
INSERT INTO kkj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓotu ɓete ɓe ɗikima kwa̧ kwaŋgɔ nɛ nje ɓaka ɗikima toyɛ nyɛ kɛnjɛ ndiŋgile to soŋɛ pokɔ lɛpɔ nde: «Hey wɛ! Wɛ mɔ te ɛ lekɛ mbanjɔ Njambiyɛ nje sumɔ ndi kɛ mɛtu yitati kɔ, ");
INSERT INTO kkj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","joŋgwɛ yotu yɔ nɛ ŋguru wɔ piyɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe teɗya mɛmboŋga ɗikima nyɛtɔ sendi nyɛ tandɛ yan lɛpɔ nde: «A ɗikima joŋgwɛ ɓaŋa ɓomɔ, ma a yeti nɛ ɗeti te yi joŋgwɛ yotu nɛ nɛ ŋguru wenɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ma *Krist te kumande Isarayɛl pîkwɛ ŋgɛnjɛ ndana kɛ kroa, nɛ́ wusɛ ɓɛŋ, nɛ́ wusɛ tiki temɔ kɛ yenɛ.» Ɓotu ɓete yi ɓo ŋgbama ɓo ɓenɛ ɓe Yesus ɓaka ɗikima toyɛ sendi nyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kɛ ɓembe yesɔ ma ɗya̧ kɛ́, ɛ yitil kelɛ kɛ ndiŋgɛlɛ mɛnɛti kumɔ kɛ hawa yitati te yi ɓekoko. ");
INSERT INTO kkj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kɛ hawa yitati ma ɗya̧ kɛ́, ɛ Yesus kembɛ nɛ mɛn kɛ kwey lɛpɔ nde: «Elɔy, Elɔy, lama sabatani?» Yite nde: ‹Njambiyɛ wombɛ, Njambiyɛ wombɛ, wɛ léŋ mi kɛto ŋge?› ");
INSERT INTO kkj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kɛ ɓaŋa ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ma wokɔ ɗete kɛ́, ɛ ɓo lɛpɛ nde: «Nɛ wôku ndi, a kɛ jeɓa Eli.» ");
INSERT INTO kkj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɛ wɛtɛ mbam kɛ njoka yan sɛɗyɛ kɛ̀ ɓu̧ yiŋa yasi nda kusa tɔpɛ kɛ yiŋa ɗyanjina mɛnjam sɔmɔ kɛ jeti sambile nyɛ nyɛ nde, a hɔ̂ɓiya. Ɛ mbam te lɛpɛ nde: «Nɛ tîki, hɛ pa ɓɛŋ, simande Eli ta nje piɗyɛ nyɛ soŋɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ɛ Yesus kembɛ ɗetinate jɛyɛ gwe. ");
INSERT INTO kkj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɛ nyaŋgwɛ lambɔ te yi ɓa̧ kɛsate kɛ mbɛy te yi nɛ kiyɔ kɛ mbanjɔ Njambiyɛ kɛ́ nyaliyɛ kɛ ɓembe kandɛ kwey kumɔ nji̧. ");
INSERT INTO kkj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kɛ kum ɓesɔja gɔmay te ɛ ɓa̧ womɛte kɛ tɛri kɛ mbɔmbu Yesus kɔ ma ɓɛŋɛ nda yi Yesus jɛyma nɔ kɛ́, ɛ nyɛ lɛpɛ nde: «Mbam kɔ ɓa̧ gbate Mɔnɔ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ɓaŋa ɓoma ɓa̧ sendi womɛte. Ɓo ɗikima ɗiyɔ nɛ naŋ ɓɛŋɛ yasi kɛnjɛ. Mariya te ŋgɔndu Magdala nɛ̀ Mariya te nyaŋgwɛ nɛ Yosɛs ɓenɛ Jak te ɛ ɓa̧ mɔnɔsikɛ kɛ njoka ɓɛsɔ kɔ, nje ɓu̧ sendi mbaŋa nyari nde Salome ɓa̧ kɛ njoka ɓoma ɓenɔri. ");
INSERT INTO kkj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓo ɗikima ɓeŋgwɛ Yesus kelɔ mɛsay nyɛ nyɛ kɛ ŋgimɔ te yi nyɛ ɓa̧ nɔ kɛ Galile kɛ́. Yo ɓa̧ sendi nɛ ɓaŋa ɓuɗya ɓoma ɓe tɛmma nje Yerusalɛm ɓenɛ ɓe Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɓekoko sima ɗya̧, yo ɓa̧ ŋgimɔ te yi ɓo ɗiki komsa kɛte yí teɗye nde, ŋgimɔ mɛwɛɗya mɛte yi yesɔ *Saba ta ɓɛ kɛ kandɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ɛ Yosɛp te mɔ Arimate ɗya̧. A ɓa̧ kɛ njɔŋ nyaŋgwɛ jɔsi Ɓeyudɛn. Ɓomɔ ɓa̧ kɛ jɛsɔ nyɛ. Sendi, nyɛ nɛ ŋguru wenɛ ɓa̧ kɛ laɗye *Kandɔ Njambiyɛ. Ɛ nyɛ tiŋɛ temɔ kɛ̀ kɛ yi Pilat kɛ̀ diyɛ muŋ Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ɛ Pilat ŋgbakima yí wokɔ nde, Yesus gwa̧ ɗete nɛ kpeteŋ. Ɛ nyɛ jeɓa kum ɓesɔja kɔ diyɛ nyɛ, simande Yesus ma kíki gwe. ");
INSERT INTO kkj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kɛ kum ɓesɔja ma lɛpɔ nyɛ nyɛ nde, Yesus gwa̧ gbate kɛ́, ɛ nyɛ jayɛ nde, Yosɛp ɓôŋ muŋ nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ɛ Yosɛp ɓɔmɛ ndɔmbɔ kwa̧ piɗyɛ muŋ Yesus kɛ kroa ɓɔyɛ nɛ ndɔmbɔ kɛ̀ niŋgwɛ kɛ ɓoŋsɔŋ te yi ɓo timma kɛ wɛtɛ nyaŋgwɛ tari kɛ́. Ɛ nyɛ nje ɓiŋgile wɛtɛ tari ɗiɓɔ nɛ numbu te. ");
INSERT INTO kkj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya te ŋgɔndu Magdala nɛ̀ Mariya te nyaŋgwɛ nɛ Yosɛs ɓɛŋma mbɛy te yi ɓo pumbuma nyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kɛ yesɔ *Saba ma si kwa̧ kɛ́, ɛ Mariya te ŋgɔndu Magdala nɛ̀ Mariya te nyaŋgwɛ nɛ Jak nɛ̀ Salome ɓɔmɛ yiŋa mɛmutɔ mɛte yi ɓa̧ nɛ kimɔ mɛtul, nɛ́ ɓo kɛ̀ nyɛ kɛ yotu Yesus. ");
INSERT INTO kkj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ɓemɛŋmɛnɛ sut kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi, ɛ ɓo tɛmɛ yí kɛ̀ kɛ ɓoŋsɔŋ kɛ ŋgimɔ te yi njanjakwɛ nje nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓo ɗikima diyna nde: «Nda ta njeŋɛ tari soŋɛ kɛ numbu ɓoŋsɔŋ nyɛ wusɛ?» ");
INSERT INTO kkj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kɛ ɓo ma kaŋɛ misi, ɓo ɓɛ́ŋa nde, ɓo ma njeŋɛ tari yinɔri soŋɛ. Yo nde, yo ɓa̧ nyaŋgwɛte ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kɛ ɓo ma nyiŋɛ kɛ mɔy ɓoŋsɔŋ, ɓo ɓɛ́ŋa mbaŋa gwanjɔ mɛtiɗyɛ pulɔ mbam ɓɔ nɛ wumna gambo kɛ yotu. Ɛ ɓo gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Nɛ tî gwaki wɔ̧ na. Wunɛ sáŋ Yesus te ɛ Nasarɛt yi ɓo ŋgbama kɛ kroa kɔ. A ma womiyɛ, a yeti se waka na. Nɛ ɓɛ̂ŋa mbɛy te yi ɓo niŋgwa nyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma wunɛ kɛ̂n kɛ̀ lɛpɔ nyɛ Piyɛr nɛ̀ ɓejekɛ ɓete ɓari nde, a ma kandɛ kwa̧ nɛ wunɛ kɛ̀ pɛ Galile. Wunɛ ta ɓɛŋɛ nyɛ mate nda yi nyɛ ma lɛ́pi nyɛ wunɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɛ ɓo pundɛ kɛ ɓoŋsɔŋ sɛɗyɛ kwa̧ nɛ mɛŋgwaŋgwa, yo kwaŋma to yan. Ɗete, ɓo tì lɛpɛ yaŋa nyɛ mumɔ na, kɛto wɔ̧ kwaŋma ɓo ɓuɗyate.  ");
INSERT INTO kkj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus womiya ɓemɛŋmɛnɛ kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi. Ɛ nyɛ kandɛ punjɛ yotu nyɛ Mariya te ŋgɔndu Magdala yi nyɛ soŋma ɓeya mɛsisiŋ yitan jɔ yiɓa kɛ yotu nɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɛ nyɛ kwa̧ kɛ̀ yekiɗye yo nyɛ ɓotu ɓete ɓe joŋnama ɓenɛ ɓe Yesus ɓaka. Ɓo ɓa̧ kɛ wo yotu lelɔ. ");
INSERT INTO kkj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A lɛpima nyɛ ɓo nde, Yesus nɛ joŋ, a ɓɛŋma nyɛ. Kɛ ɓo ma wokɔ ɗete kɛ́, ɓo tì jayɛ na. ");
INSERT INTO kkj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kɛ kɔŋte, ɛ Yesus punjɛ yotu nyɛ ɓaŋa yiɓa kɛ njoka yan nɛ yiŋa yotu dɛlɛ kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ kɛ̀ kɛ yiŋa mɛlunde kɛ́. ");
INSERT INTO kkj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɛ ɓo yɔkwɛ nje yekiɗye sendi nyɛ ɓenjɔŋ ɓan. Yasi wɛtɛ, ɓo tì jayɛ sendi yasi te yi ɓo lɛpima nyɛ ɓo kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kɛ kɔŋte yinɔri, ɛ Yesus nje punjɛ sendi yotu nyɛ ɓejekɛ ɓenɛ kamɔ jɔ wɛtɛ kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ ɗyena kɛ́. A ndeyma ɓo, kɛto ɓo ɓa̧ nɛ mɛso kɛ temɔ. Sendi, ɓo tì tikɛ temɔ kɛ yasi te yi ɓotu ɓete ɓe ɓɛŋma nde, a womiya lɛpima kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ kɛ̂n kɛ to mɛnɛti hɛnɛ kɛ̀ pelɛ Kimɔ Tom nyɛ ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mɔ te ɛ ta tikɔ temɔ kɛ Kimɔ Tom te, jayɛ nde, ɓo tɔ̂pa nyɛ kɛ mɔrɔku, mɔ te ta ju̧. Ma yɔkɔ ɛ ta ɗiyɔ kinɛ tikɔ temɔ kɛ Kimɔ Tom te na, jɔsi ta ɓalɔ kɛ to nɛ. ");
INSERT INTO kkj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɓotu ɓete ɓe ta tikɔ temɔ kɛ Kimɔ Tom te ɓaka ta kelɔ kwalɔ mɛyekambiyɛ te yikɛ, yo nde, ɓo ta soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗinɔ ɗyembɛ. Ɓo ta lɛpina nɛ yiŋa mɛnumbu. ");
INSERT INTO kkj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ɓo ta ɓiye sendi ɓenyɔŋɛ lalɛ nɛ ɓɔ. Kɛ ɓo hɔɓiye yiŋa yasi te yi nɛ lɔku kɛte, yo tí kelɔ ɓo yaŋa na. Ɓo ta kasɛ mɛɓɔ kɛ yotu ɓotu ɓekɔn, mɛkɔn man má siyɔ.» ");
INSERT INTO kkj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kɛ Kumande Yesus ma si lɛpina nyɛ ɓo kɛ́, ɛ Njambiyɛ yɔkiɗye nyɛ kɛnjɛ ɗyoɓɔ. Ɛ nyɛ kwa̧ kɛ̀ ɗiyɔ kɛ mbam ɓɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɛ ɓejekɛ nje kwa̧ kɛ̀ pelɛ Kimɔ Tom kɛ mɛmbɛy hɛnɛ. Kumande Yesus ɓa̧ kɛ kɔŋ yan, nyɛ ɓo ɗeti te yi kelɔ mɛyekambiyɛ, nɛ́ ɓomɔ duwɛ nde, lɛpi te yi ɓo lɛpɛ kɛ́, gbakasi.");
INSERT INTO kkj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nyaŋgwɛ mbam Teyofil, ɓuɗya ɓomɔ nya ɓɔ kɛ kɛtina mɛyasi mɛte yi kwaŋnama kɛ njoka wusu kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɓo kɛtima yo ɓeŋgwɛ yasi te yi ɓotu ɓete ɓe ɓɛŋma nɛ misi man wulɛ kɛ kandinate yekiɗya nyɛ wusɛ kɛ́. Ɓotu ɓete sendi nja̧ nje ɓɛ ɓotu ɓe lɛpina mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kɛ mi ma si gɔsɔ to te ɓiye kimɔte wulɛ nda yi yo kandima nɔ kɛ́, ɛ mi sendi ɓɛŋɛ kimɔte nde, mi kɛ̂ti yo kɛtɔ nɛ nje te nyɛ wɛ, ");
INSERT INTO kkj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nɛ́ wɛ duwɛ nde, mɛyasi mɛte yi ɓo teɗya wɛ kɛ́ kɛ nje gbate. ");
INSERT INTO kkj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kɛ ŋgimɔ te yi Herod ɓa̧ kumande kɛ mɛnɛti mɛ Yuda kɛ́, yo ɓa̧ nɛ wɛtɛ mɔ nyɛna sadaka nyɛ Njambiyɛ, ɗinɔ ɗyenɛ nde Sakari. A ɓa̧ kɛ njɔŋ Abiya. Nyari wenɛ ɓa̧ kɛ kandɔ *Arɔn. Ɗinɔ ɗyenɛ ɓa̧ nde Elisabɛt. ");
INSERT INTO kkj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓo hɛnɛ yiɓa ɓa̧ nɛ ŋgbeŋ kɛ misi mɛ Njambiyɛ. Ɓo joŋnama ɓakiɗye mɛmboŋga nɛ̀ mɛlɛpi mɛ Baba Mbokɔ hɛnɛ kinɛ mɔnɔ mɛjɔsɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɓo tì ɓɛ nɛ mɔnɔsikɛ na, kɛto Elisabɛt ɓa̧ kundu, sendi, ɓo hɛnɛ sima jombɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wɛtɛ yesɔ Sakari ɓa̧ kɛ tonjɛ mɛsay mɛnɛ kɛ mbɔmbu Njambiyɛ, kɛto yo ɓa̧ ŋgimɔ mɛsay mɛte yi njɔŋ te yenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A kelma ɗete nda yi ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɗikima kelɔ nɛ mɛsay man kɛ́. Kɛ ŋgimɔ te yite, ɛ ɓo kelɛ tay kɛ mbɔmbu Njambiyɛ. Ɛ tay teɗye nde, Sakari nyîŋa mbanjɔ Baba Mbokɔ kɛ̀ loɗyɛ mɛyasi mɛte yi nɛ kimɔ mɛtul kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nyaŋgwɛ ŋgil ɓomɔ ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ sɛ̧ kɛ ŋgimɔ loɗya mɛyasi mɛte yi ɓa̧ nɛ kimɔ mɛtul kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ndana kɛ́, ɛ wɛtɛ jaki Baba Mbokɔ pundɛ kɛ mbɔmbu Sakari. A ɓa̧ kɛ tɛri kɛ pay mbam ɓɔ kɛ mbɛy te yi ɓo ɗiki loɗyɛ mɛyasi mɛte yi nɛ kimɔ mɛtul kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kɛ Sakari ma ɓɛŋɛ jaki Njambiyɛ kɛ́, ɛ ɗyanɔ ɗyenɛ ɗimbiyɛ, ɛ nyɛ gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɛ jaki Njambiyɛ lɛpɛ nyɛ nyɛ nde: «Sakari, wɛ tî gwaki wɔ̧ na, kɛto Njambiyɛ jayma mɛŋgwɛta mɔ. Nyari wɔ Elisabɛt ta ja mɔnɔ mbam. Wɛ ta lo nyɛ nde Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wɛ ta ɓɛ nɛ nyaŋgwɛ mɛsosa kɛto nɛ. Sendi, ɓuɗya ɓomɔ ta sosa komɛ nyɛ ta jaɗyɛ kɛ́, ");
INSERT INTO kkj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kɛto a ta ɓɛ nyaŋgwɛte kɛ misi mɛ Baba Mbokɔ. A tí ɗye mɛnjam ho nyanna mɛnjam na. A ta ɓɛ tondunate nɛ Kimɔ Sisiŋ kandɛ kɛ mɔy nyaŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A ta yɔkiɗye ɓotu ɓe kandɔ Isarayɛl ɓuɗyate njesɛ kɛ yasi Baba Mbokɔ te Njambiyɛ wan. ");
INSERT INTO kkj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A ta kwa̧ mbɔmbu nɛ Nyaŋgwɛ Kumande nda mɔ tomun Njambiyɛ nɛ sisiŋ nɛ̀ ɗeti nda Eli. A ta yeŋsa mɛtemɔ mɛ ɓesaŋgwɛ nɛ ɓɔnɔ nde, ɓo kwâɗyikwɛ ɓɔnɔ ɓan. A ta kelɔ nde, ɓotu ɓe mbandɔ ɓɛ̂ki nɛ ɗyanɔ nda ŋgbeŋ ɓomɔ yí kombile nɛ kimɔ kandɔ tikɛ Baba Mbokɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ɛ Sakari lɛpɛ nyɛ jaki Njambiyɛ nde: «Mi ta kelɔ nan yí duwɛ nɔ nde, mɛyasi ta kwaŋna ɗete? Kɛto mi sima jombɛ. Sendi, mɛsew mɛ nyari mbɛ sima ɓuyɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛ jaki Njambiyɛ yeŋsa nyɛ nyɛ nde: «Yo mi, Gabriyɛl. Mi ɗíy kɛ mbɔmbu Njambiyɛ. Njambiyɛ tomɛ mi nde, mi njâki lɛpina nyɛ wɛ, lɛpɔ kimɔ tom te yikɛ nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ɓɛŋa, numbu yɔ ta ɓɛ ɗiɓinate. Wɛ tí tapita se na kumɔ kɛ ŋgimɔ te yi mɛyasi maka ta si kelna, kɛto wɛ tì jayɛ mɛlɛpi mɛmbɛ na, mɛlɛpi mɛte yi ta kelna tondɔ kɛ ŋgimɔ te yi yo yâkaŋgwɛ kelna kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ɓomɔ ɓa̧ ndi kɛ laɗye Sakari. Ɓo ɓa̧ kɛ ŋgbakima to te yi nyɛ kikɛ nɔ ɗete kɛ mɔy mbanjɔ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kɛ nyɛ ma nje pundɔ kɛ́, a tì ɓɛ nɛ ɗeti te yi lɛpina nyɛ ɓo na. Ɛ ɓo duwɛ nde, a ɓɛŋma yiŋa mɛyekambiyɛ kɛ mɔy mbanjɔ Njambiyɛ. A ɗikima pɛpiɗye mɛɓɔ numbu kɔɓɔ yí lɛpina nɔ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kɛ mɛtu mɛsay mɛte yenɛ ma siyɔ kɛ́, ɛ nyɛ tɛmɛ ɗuwɛ kɛ̀ ɗya ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mɔnɔ mɛtu kwaŋma kɛ kɔŋte, ɛ nyari wenɛ Elisabɛt ɓu̧ mɔy. Ɛ nyɛ sɔma nɔ ŋgwɛndɛ yitan. A ɗikima lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‹Baba Mbokɔ kelma nyaŋgwɛ ŋgikwa nɛ mi. A kaŋma misi ɓɛŋɛ nɛ mi yí soŋɛ nɛ wuŋgwa kɛ yotu mbɛ kɛ misi mɛ ɓomɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kɛ mɔy Elisabɛt ma kumɔ ŋgwɛndɛ yitan jɔ wɛtɛ kɛ́, ɛ Njambiyɛ tomɛ jaki wenɛ Gabriyɛl kɛnjɛ kɛ Galile kɛ wɛtɛ ɗya nde Nasarɛt, ");
INSERT INTO kkj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kɛ yi wɛtɛ ɓindi ŋgɔndu nde Mariya. Yo ɓa̧ kponate nde, a ta kelɔ gwaki ɓenɛ wɛtɛ mbam nde Yosɛp kɛ kandɔ Davit. ");
INSERT INTO kkj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jaki Njambiyɛ nyiŋma tu̧ Mariya dolɔ nyɛ lɛpɔ nyɛ nyɛ nde: «Mi kɛ nyɛnɔ wɛ, Baba Mbokɔ kɛ yɔ! A teɗya wɛ nyaŋgwɛ ŋgikwa nɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kɛ Mariya ma wokɔ ɗete kɛ́, ɛ ɗyanɔ ɗyenɛ ɗimbiyɛ, ɛ nyɛ gwe wɔ̧ ɓuɗyate. Ɛ nyɛ diyɛ kɛ mɔy temɔ nɛ nde: ‹To mɛnyɛn mɛte yikɛ lɛ́pi nɛ ŋge?› ");
INSERT INTO kkj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛ jaki Njambiyɛ lɛpɛ nyɛ nyɛ nde: «Mariya, wɛ tî gwaki wɔ̧ na, kɛto Njambiyɛ teɗya nyaŋgwɛ ŋgikwa nɛ kɛ yɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dukwɛ nde, wɛ ta ɓu̧ mɔy. Wɛ ta ja mɔnɔ mbam, wɛ ta lo nyɛ nde Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A ta ɓɛ nyaŋgwɛte kɛ misi mɛ Njambiyɛ. Ɓo ta jeɓa nyɛ nde Mɔnɔ Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ. Njambiyɛ te Baba Mbokɔ ta nyɛ nyɛ ɗiyɔ kumande saŋmbambɔ wenɛ Davit. ");
INSERT INTO kkj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A ta namɔ kandɔ tu̧ Yakɔp kpo nɛ kpo. Namnate yenɛ tí ɓɛ nɛ njena na.» ");
INSERT INTO kkj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ɛ Mariya lɛpɛ nyɛ jaki Njambiyɛ nde: «Yo yakama kelna nan, kɛto mi tì pa duwɛ mbɛ mbam na?» ");
INSERT INTO kkj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɛ jaki Njambiyɛ yeŋsa nyɛ nyɛ nde: «Kimɔ Sisiŋ ta nje pɛ yɔ. Ŋguŋguɗyɛ Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ ta ɓusɛ wɛ nda wukumɛ. Ɗete, mɔnɔ te yi wɛ ta ja kɔ ta ɓɛ kiyɔ. Ɓo ta jeɓa nyɛ nde Mɔnɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dukwɛ nde, toru wɔ Elisabɛt mɛ nɛ mɔy. A ɓoŋma mɔy nɛ jombiɗyɛ. Yɔkɔ yi ɓo ɗikima jeɓa nde kundu kɔ mɛ nɛ mɔy ŋgwɛndɛ yitan jɔ wɛtɛ muka. A ta ja mɔnɔ mbam. ");
INSERT INTO kkj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kɛto kinɛ yiŋa sulna yasi kɛ misi mɛ Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛ Mariya lɛpɛ nde: «Mi kɔ, mɔ mɛsay mɛ Baba Mbokɔ, yo kêlnaŋgwɛ kɛ yotu mbɛ nda yi wɛ lɛpima kɛ́!» Ɛ jaki Njambiyɛ pundɛ kwa̧ lɔndɔ kɛ kɛki nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ndi kɛ mɛtu te yite ɛ Mariya tɛmɛ ɓekɛ ɓekɛ kɛ̀ kɛ wɛtɛ ɗya kɛ mɛnɛti mɛ Yuda, kɛ mɛnɛti mɛte yi nɛ mɛkeki kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ɛ nyɛ nyiŋɛ tu̧ Sakari nyɛnɔ Elisabɛt. ");
INSERT INTO kkj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kɛ Elisabɛt ma wokɔ mɛnyɛn mɛ Mariya kɛ́, ɛ mɔnɔ watɛ ɓuɗyate kɛ mɔy nɛ, ɛ Kimɔ Sisiŋ tondɛ kɛ yotu Elisabɛt. ");
INSERT INTO kkj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ɛ nyɛ kembiɗya lɛpɔ nde: «Wɛ nɛ mɛkombila kɛ njoka ɓɛsɔ ɓoma. Sendi, mɔnɔ te ɛ kɛ mɔy yɔ kɔ nɛ mɛkombila. ");
INSERT INTO kkj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wuy, ŋge ɓa̧ kelɛ yi nyaŋgwɛ nɛ Nyaŋgwɛ Kumande wombɛ nja̧ ndana kɛ yasi mbɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kɛto, kɛ mi ma wokɔ mɛnyɛn mɔ kɛ́, ɛ mɔnɔsikɛ watɛ ɓuɗyate nɛ mɛsosa kɛ mɔy mbɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wɛ nɛ mɛsosa, kɛto wɛ jayma nde, mɛyasi mɛte yi Baba Mbokɔ lɛpima nyɛ wɛ kɛ́ ta kelna.» ");
INSERT INTO kkj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɛ Mariya lɛpɛ nde: «Mi kɛ kanɔ Baba Mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sendi, temɔ mbɛ nɛ mɛsosa kɛto Njambiyɛ, Mɔ te ɛ joŋgwɛ mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A teɗya mi ŋgikwa nɛ, mi mɔ mɛsay wenɛ. Kandɛ ndana kumɔ kpo nɛ kpo mɛkandɔ hɛnɛ te yi ta jaɗyɛ kɛ to mɛnɛti maka kɛ́ ta lɛpɔ nde, mi nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kɛto Njambiyɛ te ɛ nɛ ŋguŋguɗyɛ kɔ kelma nyaŋgwɛ mɛyasi kɛ pay te yembɛ. Ɗinɔ ɗyenɛ kiyɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sendi, ɓotu ɓete ɓe kambɛ nyɛ ɓaka, a gwáki ŋgwɛtɛ yan mɛŋgimɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A teɗya ɓomɔ nde, a nɛ nyaŋgwɛ ɗeti. A wanjima ɓotu ɓete ɓe ɓa̧ nɛ mɛtakɛ mɛ ɓendiɗya yotu kɛ temɔ yan ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A soŋma ɓekumande kɛ mɛɗiyɔ man nje ɓendiɗye gbɛla ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A tonja kimɔ mɛyasi nyɛ ɓotu ɓete ɓe gwe nja ɓaka, nje tikɔ ɓotu ɓete ɓe nɛ mɛyasi ɓaka nɛ gboŋgo ɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A kamma kandɔ Isarayɛl, ɓotu ɓe mɛsay ɓenɛ yí takɛ gwena ŋgwɛtɛ nɛ ");
INSERT INTO kkj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","suŋgwɛ nɛ Abaraham ɓenɛ ɓenday ɓenɛ kpo nɛ kpo. A kelma ɗete nda yi nyɛ lɛpima nyɛ ɓesaŋmbambɔ ɓusu kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya yama ɓenɛ Elisabɛt nda ŋgwɛndɛ yitati. Ɛ nyɛ nje ɗuwɛ kɛ̀ ɗya ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kɛ ŋgimɔ te yi Elisabɛt ta ja kɛte kɛ́ ma ɗya̧, ɛ nyɛ ja mɔnɔ mbam. ");
INSERT INTO kkj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kɛ ɓenjɔŋ ɓenɛ nɛ̀ ɓemaŋ ma wokɔ nde, Baba Mbokɔ teɗya nyɛ nyaŋgwɛ ŋgikwa nɛ ɗete kɛ́, ɛ ɓo ɓɛ nɛ mɛsosa nda Elisabɛt. ");
INSERT INTO kkj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kɛ mɔnɔsikɛ ma kumɔ mɛtu yitan jɔ yitati kɛ́, ɛ ɓomɔ nje kɛ pɛsina nɛ. Ɛ ɓo diy lo nyɛ nde Sakari nɛ ɗinɔ saŋgwɛ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yasi wɛtɛ, ɛ nyaŋgwɛ nɛ mɔnɔ lɛpɛ nde: «Ɓɛ, ɗinɔ ɗyenɛ ta ɓɛ nde Jaŋ!» ");
INSERT INTO kkj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Kinɛ mumɔ wɛtɛ nɛ wɛtɛ kɛ kandɔ ɗyɔ nɛ ɗinɔ te yite na.» ");
INSERT INTO kkj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ndana, ɛ ɓo pɛpiɗye ɓɔ diyɛ nɛ saŋgwɛ nɛ mɔnɔ nde: «Wɛ kwáɗyikwɛ lo mɔnɔsikɛ nde ŋge?» ");
INSERT INTO kkj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ɛ Sakari jɔmbɛ yiŋa yasi, na kɛtina kɛte. Ɛ nyɛ kɛtɛ kɛte nde: ‹Ɗinɔ mɔnɔsikɛ nde Jaŋ.› Ɛ ɓo hɛnɛ ŋgbakima ɗinɔ te yite. ");
INSERT INTO kkj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ndana ndana, ɛ numbu nɛ ɓutuna. Ɛ nyɛ kandɛ ndapi nɛ kɔkɔ lukse Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɛ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ pɔku mɛnɛti mɛte yite ɓaka gwe wɔ̧. Ɓotu ɓete ɓe ɗikima ɗiyɔ kɛ Yuda, kɛ mɛnɛti mɛte yi nɛ mɛkeki kɛte kɛ́ ɗikima yekiɗye ndi mɛyasi mɛte. ");
INSERT INTO kkj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓomɔ hɛnɛ ɓe wokuma kasi te ɓaka ɗikima takɛ yo kɛ mɔy temɔ. Ɛ ɓo ɗiki diyɛ nde: «Mɔnɔ te yɔkɔ ta duwɛ ɓɛ nan? Ɗeti Baba Mbokɔ ɓa̧ gbate kɛ yotu nɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Saŋgwɛ wenɛ Sakari ɓa̧ tondunate nɛ Kimɔ Sisiŋ. Ɛ nyɛ punjɛ mɛlɛpi mɛ Njambiyɛ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mɛluksa nɛ Baba Mbokɔ, Njambiyɛ te ɛ kandɔ Isarayɛl, kɛto a takima ɓotu ɓenɛ kolɔ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A nya wusɛ ɗetina mɔ te ɛ ta joŋgwɛ wusɛ kɔ wulɛ kɛ tu̧ mɔ mɛsay wenɛ Davit. ");
INSERT INTO kkj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A kelma nda yi nyɛ lɛpima kɛ numbu pupuna ɓotu ɓe punja mɛlɛpi mɛnɛ ɓe mɛtu mɛ njimɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mɔ te ɛ ta joŋgwɛ wusɛ komɛ ɓependɔ ɓusu ɗiyɛ kɛ́, soŋɛ wusɛ kɛ mɛɓɔ mɛ ɓotu ɓete ɓe ɓenɛ wusɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɗete, Njambiyɛ gwa̧ ŋgwɛtɛ ɓesaŋmbambɔ ɓusu yí takɛ sendi nɛ nyaŋgwɛ mbon te yi nyɛ kelma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","A kél ɗete ɓeŋgwɛ mɛkinja mɛte yi nyɛ kinjama nyɛ saŋmbambɔ wusu Abaraham kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A kinjama nde, ŋgɛ nyɛ si soŋɛ wusɛ kɛ mɛɓɔ mɛ ɓependɔ ɓusu, wusɛ ta kelɔ mɛsay nyɛ nyɛ kinɛ wɔ̧ na. ");
INSERT INTO kkj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wusɛ ta ɓɛ nɛ ŋgbeŋ, ɓakiɗye sendi mɛyotu musu pupunate kɛ mbɔmbu wenɛ kɛ mɛtu mɛ joŋgwɛ musu hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mɔnɔsikɛ, ŋgɛ ɓɛ wɛ, ɓo ta jeɓa wɛ nde Mɔ punja mɛlɛpi mɛ Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ, kɛto wɛ ta kandɛ kwa̧ mbɔmbu nɛ Baba Mbokɔ yí kombile mɛnje mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wɛ ta teɗye ɓomɔ ɓenɛ, nɛ́ ɓo duwɛ nje joŋgwɛ nɛ nje te nde, Njambiyɛ ta tikɔ mɛɓeyɔ man nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Njambiyɛ wusu nɛ ŋgikwa ɓuɗyate. Yo ɗete yi mɛjasi ta wulɛ ɗyoɓɔ nje pɛ yusu ");
INSERT INTO kkj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nje paniyɛ puyɛ nyɛ ɓotu ɓete ɓe ɗiyɛ kɛ mɔy yitil nɛ̀ kɛ ndiliŋ mbɛy te yi sɔŋ ɓaka, nɛ́ yo kɛndi nɛ wusɛ kɛ nje te ɛ nɛ tɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mɔnɔsikɛ ɓa̧ kɛ ɗɔkɔ. Sendi, ɗyanɔ ɓa̧ kɛ nje nyɛ ɓuɗyate. A joŋnama kɛ mɔy mɛkoŋgor kumɔ kɛ ŋgimɔ te yi nyɛ nja̧ nje punjɛ nɛ yotu nyɛ kandɔ Isarayɛl kɛ̀. ");
INSERT INTO kkj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kɛ mɛtu te yite ɛ *Sesar Ogust nyɛ mboŋga nde, ɓo tɔ̂l ɓomɔ kɛ to mɛnɛti mɛnɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yo ɓa̧ bosa tɔlna ɓomɔ. Yo kélnaŋgwɛ kɛ ŋgimɔ te yi Kirinus ɓa̧ nyaŋgwɛ kum kɛ mɛnɛti mɛ Siri kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mumɔ hɛnɛ ka̧ kɛ̀ kɛtɔ ɗinɔ ɗyenɛ kɛ ŋgbak ŋgbak ɗya ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ɛ Yosɛp tɛmɛ sendi kɛ Nasarɛt kɛ Galile kwa̧ kɛ̀ kɛ wɛtɛ ɗya nde Betɛlɛhɛm kɛ mɛnɛti mɛ Yuda. Betɛlɛhɛm ɓa̧ ɗya kumande Davit. Yosɛp ka̧ mate, kɛto ɓenɛ kumande Davit jaɗyɛ kɛ kiya kandɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A ka̧ kɛ̀ kɛtɔ ɗinɔ ɗyenɛ ɓenɛ Mariya, kɛto yo ɓa̧ kponate nde, ɓenɛ nyɛ ta kelɔ gwaki. Kɛ ŋgimɔ te yite Mariya ɓa̧ nɛ mɔy. ");
INSERT INTO kkj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Piŋɔ te yi ɓo ɓa̧ ndi mate kɛ́, ɛ ŋgimɔ te yi Mariya ta ja kɛte kɛ́ ɗya̧. ");
INSERT INTO kkj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ɛ nyɛ ja bosa mɔnɔ wenɛ, mɔnɔ mbam. Ɛ nyɛ ɓɔyɛ nyɛ nɛ mɛlambɔ niŋgwɛ nyɛ kɛ mɔy ɓokɔ, kɛto ɓo tì ɓɛ nɛ mbɛy kɛ tu̧ ɓejɛŋgwɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɓotu ɓe ɓakiɗya ɓesam ɓa̧ kɛ pɔku mɛnɛti mɛte yite kɛ ɓakiɗye ɓesam ɓan nɛ tu kɛ mɔy lɔ̧. ");
INSERT INTO kkj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɛ wɛtɛ jaki Baba Mbokɔ ɗya̧ kɛ yan. Ɛ nyaŋgwɛ mɛjasi mɛ Baba Mbokɔ panɛ kɛ mbɛy komɛ ɓo ɗiyma kɛ́. Ɛ ɓo gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ɛ jaki Njambiyɛ lɛpɛ nyɛ ɓo nde: «Nɛ tî gwaki wɔ̧ na, kɛto mi kɛ nje lɛpɔ kimɔ tom te yi kandɔ Isarayɛl hɛnɛ ta wokɔ mɛsosa kɛte kɛ́ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɔ te ɛ ta joŋgwɛ wunɛ kɔ jaɗya muka kɛ ɗya Davit, nyɛ *Krist, nyɛ Nyaŋgwɛ Kumande. ");
INSERT INTO kkj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yasi te yi wunɛ ta duwɛ nɔ kɛ́, yo nde: Wunɛ ta ɓɛŋɛ jɔnja mbɔŋgɔ mɔnɔsikɛ ɓɔynate nɛ mɛlambɔ. Ɓo niŋgwa nyɛ kɛ mɔy ɓokɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɓo sém semɔ, nyaŋgwɛ ŋgil ɓejaki ɓe Njambiyɛ ɗyaŋma dolɔ jaki te yɔru. Ɛ ɓo kanɛ Njambiyɛ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‹Mɛluksa nɛ Njambiyɛ pɛ kwey! Tɛte ɗîy nɛ ɓotu ɓete ɓe Njambiyɛ kwaɗyɛ kɛ mɛnɛti maka ɓaka!› ");
INSERT INTO kkj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ndana, kɛ ɓejaki ɓe Njambiyɛ ma tikɔ ɓo ɗuwɛ kɛ̀ ɗyoɓɔ kɛ́, ɛ ɓotu ɓe ɓakiɗya ɓesam lɛpɛ tandɛ yan nde: «Wusɛ kɛ̂n pɛlɛ Betɛlɛhɛm kɛ̀ ɓɛŋɛ yasi te yi kwaŋnama mate kɛ́, yasi te yi Baba Mbokɔ lɛpima nyɛ wusɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɛ ɓo tɛmɛ nɛdɔ kwa̧. Ɓo dolma Mariya ɓenɛ Yosɛp, dolɔ sendi jɔnja mbɔŋgɔ mɔnɔsikɛ niŋgwate kɛ mɔy ɓokɔ. ");
INSERT INTO kkj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kɛ ɓo ma si ɓɛŋɛ nyɛ kɛ́, ɛ ɓo yekiɗye mɛyasi mɛte yi ɓo wokuma kɛ kasi mɔnɔ te kɛ́ nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɓomɔ hɛnɛ ɓe wokuma mɛyasi mɛte yi ɓotu ɓe ɓakiɗya ɓesam yekiɗya kɛ́ ŋgbakimama. ");
INSERT INTO kkj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya ɓakiɗya nɛ mɛyasi mɛte kɛ mɔy temɔ nɛ takɛ gɔsɔ to te. ");
INSERT INTO kkj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kɛ kɔŋte, ɛ ɓotu ɓe ɓakiɗya ɓesam yɔkwɛ. Ɓo luksa Njambiyɛ ɓesɛ sendi nyɛ, kɛto mɛyasi mɛte yi ɓo wokuma nɛ̀ yi ɓo ɓɛŋma kɛ́ ɓa̧ ndi nda yi jaki Njambiyɛ lɛpima nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɓo yama mɛtu yitan jɔ yitati kɛ kɔŋ jariki. Ɛ ɓo pɛsɛ mɔnɔsikɛ, ɛ ɓo lo nyɛ nde Yesus, ɗinɔ te yi jaki Njambiyɛ nya, yite nyaŋgwɛ nɛ mɔnɔsikɛ tì pa ɓu̧ mɔy nɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ndana, kɛ mɛtu mɛ nyɛna sadaka yi pupuɗya yan kɛ misi mɛ Njambiyɛ ma yaka ɓeŋgwɛ mɛmboŋga mɛ Mɔyisi kɛ́, ɛ Yosɛp ɓenɛ Mariya ɓu̧ mɔnɔsikɛ kɛ̀ nɔ Yerusalɛm kɛ̀ nyɛ Baba Mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yo ɓa̧ kɛtinate ɗete kɛ mɛmboŋga mɛ Baba Mbokɔ nde: ‹Bosa mɔnɔ mbam te ɛ kandɛ jaɗyɛ kɛ mɔy nyaŋgwɛ kɔ ta ɓɛ ɛ Baba Mbokɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓo ka̧ sendi kɛ̀ nyɛ sadaka nda yo kɛtinate kɛ mɛmboŋga mɛ Baba Mbokɔ kɛ́: ‹Ɓebondo yiɓa ho sɔnjɔ ɓepepɔ yiɓa.› ");
INSERT INTO kkj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wɛtɛ mbam ɓa̧ kɛ Yerusalɛm, ɗinɔ ɗyenɛ nde Simeyɔŋ. A ɓa̧ ŋgbeŋ mumɔ. A ɓa̧ kɛ ɓakiɗye mɛmboŋga mɛ Njambiyɛ, tikɔ temɔ nɛ kɛ ŋgimɔ te yi Njambiyɛ ta joŋgwɛ nɛ kandɔ Isarayɛl kɛ́. Kimɔ Sisiŋ ɓa̧ sendi kɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kimɔ Sisiŋ téɗya nyɛ nde, a tí gwe kinɛ pa ɓɛŋɛ *Krist te ɛ Baba Mbokɔ ta njesɛ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɗiyɔ kɛ́, ɛ Kimɔ Sisiŋ pusɛ nyɛ kɛnjɛ kɛ mbanjɔ Njambiyɛ. Kɛ kiya ŋgimɔ te saŋgwɛ nɛ Yesus ɓenɛ nyaŋgwɛ ɓoŋma nyɛ yí tonjɛ mɛyasi mɛte yi mɛmboŋga ɗikima diyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ɛ Simeyɔŋ ɓu̧ mɔnɔsikɛ ɓiye kɛ mɛɓɔ nyɛ Njambiyɛ wosoko lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Sa Mbokɔ, ndana tikɔ mɔ mɛsay wɔ, na kwa̧ nɛ tɛ nda yi wɛ kpoma kɛ́, ");
INSERT INTO kkj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kɛto misi mɛmbɛ ma ɓɛŋɛ nda yi wɛ ta joŋgwɛ nɛ ɓomɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wɛ kombila yo ɗete, nɛ́ mɛkandɔ hɛnɛ ɓɛŋ. ");
INSERT INTO kkj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wɛ paniya mɛjasi, nɛ́ mɛkandɔ duwɛ wɛ yí nyɛ sendi kandɔ ɗyɔ Isarayɛl mɛluksa.» ");
INSERT INTO kkj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Saŋgwɛ nɛ Yesus ɓenɛ nyaŋgwɛ wenɛ ŋgbakimama mɛyasi mɛte yi Simeyɔŋ lɛpima kɛ kasi nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔŋ nya ɓo mɛkombila. Ɛ nyɛ nje lɛpɔ nyɛ Mariya, nyaŋgwɛ nɛ Yesus nde: «Dukwɛ nde, Njambiyɛ njesa mɔnɔ kɛ́, nɛ́ ɓomɔ ɓuɗyate yambile kɛ njoka kandɔ Isarayɛl, sendi nɛ́ ɓomɔ ɓuɗyate ju̧ kɛ njoka yan. A ta nje ɓɛ yasi te yi ta teɗye nde, ɓomɔ ta ɓiye mɛso nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ma nyari, kɛ yɔ, wɛ ta saŋgwa nɛ mɛbɔnɛ nda yi ɓo ɓu̧ kafa lu̧ nɛ mumɔ kɛ temɔ kɛ́. Yo ta kelna ɗete, nɛ́ mɛtakɛ mɛte yi ɗiyɛ kɛ mɔy temɔ ɓuɗya ɓomɔ kɛ́ pundu puyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yo ɓa̧ sendi nɛ wɛtɛ nyari mɔ punja mɛlɛpi mɛ Njambiyɛ, ɗinɔ ɗyenɛ ɓa̧ nde Ana, mɔnɔ Fanuwɛl kɛ kandɔ Asɛr. A ma jombɛ ɓuɗyate. Mbam te ɛ dolma nyɛ kelɔ gwaki ɓenɛ nyɛ kɔ kelma ndi mɛsew yitan jɔ yiɓa ɓenɛ nyɛ, ");
INSERT INTO kkj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ɛ mbam te gwe, ɛ nyɛ tika kusɔ. Ndana a mɛ nɛ mɛsew kamɔtan jɔ kamɔtati jɔ yini. A tì ɓɛ kɛ ɓaka nɛ mbanjɔ Njambiyɛ na. A ɗikima kelɔ mɛsay nyɛ Njambiyɛ tu nɛ yesɔ, kiyɔ mɛɗye ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kɛ kiya ŋgimɔ te yite ɛ Ana ɗya̧. Ɛ nyɛ lukse Baba Mbokɔ, yekiɗye sendi kasi mɔnɔ kɛ nyɛ ɓotu ɓete ɓe ɓa̧ kɛ laɗye ŋgimɔ te yi Njambiyɛ ta kolɔ nɛ Yerusalɛm kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kɛ ɓo ma si kelɔ mɛyasi hɛnɛ te yi mɛmboŋga mɛ Baba Mbokɔ lɛpɛ kɛ́, ɛ ɓo nje ɗuwɛ kɛ̀ ɗya ɗyan kɛ Nasarɛt kɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mɔnɔsikɛ ɓa̧ kɛ ɗɔkɔ. A ɓa̧ kɛ ɓu̧ ɗeti, ɓɛ sendi nɛ ɗyanɔ ɓuɗyate. Njambiyɛ nya temɔ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mɛsew hɛnɛ saŋgwɛ nɛ Yesus ɓenɛ nyaŋgwɛ ɗikima kɛ̀ Yerusalɛm kɛ jesɔ *Paska Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kɛ Yesus ma kumɔ mɛsew kamɔ jɔ yiɓa kɛ́, ɛ ɓenɛ ɓo kɛ̀ Yerusalɛm kɛ jesɔ Paska ɓeŋgwɛ mɛmboŋga mɛ jesɔ. ");
INSERT INTO kkj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kɛ jesɔ ma siyɔ kɛ́, ɛ saŋgwɛ ɓenɛ nyaŋgwɛ tɔkɛ nje yí ɗuwɛ. Yasi wɛtɛ, ɛ mɔnɔsikɛ tika kɛ Yerusalɛm, ɓesaŋgwɛ kinɛ duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓo takima yan nde, a ɓa̧ kɛ njɔŋ kɛndi. Ɛ ɓo kɛndɛ ndiŋgɛlɛ yesɔ wɛtɛ siɗyɛ. Ndana, ɛ ɓo kandɛ saŋna nɛ kɛ njoka ɓejaɗyɛ ɓan nɛ̀ ɓesɔ ɓan. ");
INSERT INTO kkj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kɛ ɓo ma sa̧ nyɛ kinɛ dolɔ kɛ́, ɛ ɓo yɔkwɛ nɛ kɔkɔ kɛ̀ kɛ Yerusalɛm kɛ̀ sa̧ nyɛ mate. ");
INSERT INTO kkj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ya mɛtu yitati kɛ kɔŋte, ɛ ɓo kɛ̀ dolɔ nyɛ kɛ mbanjɔ Njambiyɛ. A ɓa̧ kɛ ɗiyɔ kɛ njoka nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga lɛŋgwɛ mɛtɔ kɛ mɛyasi mɛte yi ɓo ɓa̧ kɛ lɛpɔ kɛ́, diyɛ sendi ɓo mɛdiyan. ");
INSERT INTO kkj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓomɔ hɛnɛ ɓe ɓa̧ kɛ wokɔ mɛyasi mɛte yi nyɛ ɓa̧ kɛ lɛpɔ nɛ̀ yeŋsa mɛdiyan te yi nyɛ ɗikima yeŋsa kɛ́ kambima ɗyanɔ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kɛ saŋgwɛ ɓenɛ nyaŋgwɛ ma ɓɛŋɛ nyɛ kɛ́, ɛ ɓo ŋgbakima ɓuɗyate. Ɛ nyaŋgwɛ lɛpɛ nyɛ nyɛ nde: «Mɔnmbɛ, ŋge yi wɛ kelma nɛ wusɛ ɗekɛ kɛ́? Sinɛ sɔŋgwɛ gwa̧ kaŋ ɓuɗyate kɛ saŋna yɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɛ nyɛ nje yeŋsa nyɛ ɓo nde: «Wunɛ ɓa̧ kɛ sa̧ mi kɛto ŋge? ’Wunɛ tì duwɛ nde, mi yâkaŋgwɛ ɗiyɔ kɛ tu̧ Saŋmbɛ na?» ");
INSERT INTO kkj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yasi wɛtɛ, ɓo tì wokɛ to yasi te yi nyɛ lɛpima nyɛ ɓo kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kɛ kɔŋte, ɛ nyɛ siliyɛ ɓenɛ ɓo yɔkwɛ kɛ̀ Nasarɛt. A ɓa̧ kɛ jɛsɔ ɓesaŋgwɛ. Nyaŋgwɛ ɓa̧ kɛ takɛ mɛyasi mɛte hɛnɛ kɛ mɔy temɔ nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus ɓa̧ kɛ ɗɔkɔ, ɗyanɔ ɓa̧ kɛ nje nyɛ sendi. Njambiyɛ nɛ̀ ɓomɔ nya temɔ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Kɛ ŋgimɔ te yi Jaŋ te mɔnɔ Sakari ɓa̧ kɛ mɔy koŋgor kɛ́, ɛ Njambiyɛ lɛpina nyɛ nyɛ. Yo ɓa̧ kɛ ŋgimɔ te yi Tibɛr *Sesar kumma mɛsew kamɔ jɔ yitan kɛ ɗiyɔ nyaŋgwɛ kumande kɛ́. Yite Pɔnsi Pilat ɓa̧ nyaŋgwɛ kum kɛ mɛnɛti mɛ Yuda, Herod ɓa̧ kum kɛ mɛnɛti mɛ Galile. Maŋ wenɛ Filip ɓa̧ kum kɛ mɛnɛti mɛ Iture nɛ̀ Trakɔnit. Lisaniyas ɓa̧ kum kɛ mɛnɛti mɛ Abilɛn. Kɛ ŋgimɔ te yite Hana ɓenɛ Kayif ɓa̧ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ndana, ɛ Jaŋ goŋgila nɛ mɛnɛti mɛ goŋ Yurdɛ̧ hɛnɛ, pelɛ nyɛ ɓomɔ nde, ɓo yêŋsaŋgwɛ temɔ jayɛ nde, ɓo tɔ̂pa ɓo kɛ mɔrɔku, nɛ́ Njambiyɛ tiki ɓo nɛ ŋgwɛtɛ kɛ mɛɓeyɔ man. ");
INSERT INTO kkj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yo kelnama ɗete ɓeŋgwɛ yasi te yi ɓa̧ kɛtinate kɛ mɛkana mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ́. A kɛtima nde: ‹Wɛtɛ mumɔ kɛ kembiɗya kɛ mɔy koŋgor nde: Wunɛ kômbila nje Baba Mbokɔ. Wunɛ tɛ̂mbiɗya mɛnje mɛnɛ nɛ ŋgbeŋ. ");
INSERT INTO kkj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gboŋgo hɛnɛ ɓɛ̂ki mbasinate. Keki nɛ̀ koru hɛnɛ ɓɛ̂ki nɛ tɛfɛn. Mɛnje mɛte yi nɛ kɔndu kɛ́ ɓɛ̂ki tɛmbiɗyate. Yikɛ yi nɛ mɛɓe kɛ́, ɓo sîki tonjɛ yo. ");
INSERT INTO kkj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sendi, ɓomɔ hɛnɛ ta ɓɛŋɛ nda yi Njambiyɛ ta joŋgwɛ nɛ ɓomɔ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɗete, ɓomɔ ɓuɗyate kwaɗya nde, Jaŋ tɔ̂pa ɓo kɛ mɔrɔku. Ɛ ɓo nje nɛ ŋgil kɛ yasi nɛ. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ mbo yeri, nda kelɛ nde, wunɛ tâka nde, wunɛ yakama diyɔ lalɛ kɛ ŋgambi Njambiyɛ yi nje kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yo kimɔte nde, wunɛ kêl kimɔ mɛkele nda yi kimɔ jeti wumɛ nɛ kimɔ mɛmbumɔ kɛ́ yí teɗye ɓomɔ nde, wunɛ ma yeŋsa temɔ. Sendi, wunɛ tî lɛpi nde, wunɛ ɓenday ɓe Abaraham na. Mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Njambiyɛ yakama yeŋsa mɛtari mɛte yikɛ, yo má ɓɛ ɓɔnɔ ɓe Abaraham. ");
INSERT INTO kkj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Njeŋ mɛ nɛ lɛndɛ kɛ njuku jeti, ɗete jeti hɛnɛ ɛ ɗiyɛ kinɛ wumɔ kimɔ mɛmbumɔ, ɓo ta pɛsɔ yo ɓetɛ kɛ ɗitɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɛ ɓotu ɓete ɓe wesiɗyama womɛte ɓaka diyɛ nyɛ nde: «Wusɛ kêl ɓa nan?» ");
INSERT INTO kkj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mɔ te ɛ nɛ mɛlambɔ yiɓa kɔ kâɓi wɛtɛ nyɛ mɔ te ɛ kinɛ yaŋa kɔ. Mɔ te ɛ nɛ mɛɗye kɔ kêl sendi ɗete.» ");
INSERT INTO kkj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɓotu ɓe ɓoŋna mɔni garama nja̧ sendi kɛ yi Jaŋ nde, a tɔ̂pa ɓo kɛ mɔrɔku. Ɛ ɓo diyɛ nyɛ nde: «Yekele, wusɛ kêl nan?» ");
INSERT INTO kkj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Wunɛ tî ɓoŋ mɔni kɛ ɓɔ mumɔ kwa̧ yikɛ yi ɓo pɛsima nde, wunɛ ɓôŋ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɓesɔja diyma sendi nyɛ nde: «A wusɛ su, wusɛ kêl nan?» Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Wunɛ tî ɓoŋ mɔni kɛ ɓɔ mumɔ nɛ ŋgaŋ ho nɛ nje te yi guɓɔ na, yasi wɛtɛ, wunɛ ɗyâki ndi mɔni ŋgwɛndɛ yun.» ");
INSERT INTO kkj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓomɔ ɓa̧ kɛ laɗye yasi te yi ta ɗya̧ kɛ́. Ɛ mumɔ hɛnɛ takɛ kɛ temɔ nɛ nde, Jaŋ yâkaŋgwɛ ɓɛ *Krist mɔ te ɛ joŋgwɛ ɓomɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ɛ nyɛ lɛpɛ nyɛ ɓo hɛnɛ nde: «Mi, mi tɔ́pa mbɛ wunɛ kɛ mɔrɔku. Yasi wɛtɛ, wɛtɛ mumɔ kɛ nje. A nɛ ɗeti kwa̧ mi. Mi ti yaka wunjɛ kɔl mɛnakala mɛnɛ na. A ta tɔpɛ wunɛ kɛ Kimɔ Sisiŋ nɛ̀ kɛ ɗitɛ. ");
INSERT INTO kkj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A nɛ jeti kɛ ɓɔ yí kutɔ nɛ nyambi, yí ɓakɛ njɔsɔ te nɛ̀ kopu te. A ta soŋɛ njɔsɔ te kɛ̀ ɓakiɗye kɛ mɔy ndam nɛ. Yasi wɛtɛ, a ta loɗyɛ mɛkopu mɛte kɛ ɗitɛ te yi ti ɗím kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jaŋ ɗikima nyɛ sendi yiŋa ɓuɗya mɛŋgitɛ nyɛ ɓomɔ. Ɗete, ɛ nyɛ lɛpɛ nɛ Kimɔ Tom Njambiyɛ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A ndeyma Herod, kɛto a ɓoŋma Herodiyas te nya maŋ wenɛ nɛ mɛgwaki. Ɛ nyɛ ndeyɛ nyɛ sendi, kɛto ɓeya mɛkele hɛnɛ te yi nyɛ ɗikima kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod ka̧ mbɔmbu kelɔ wɛtɛ ɓeya mɛkele dokiɗye kɛ to te yiri. A ɓoŋma Jaŋ ɗiɓɔ kɛ tu̧ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kɛ Jaŋ ma si tɔpɛ ɓomɔ hɛnɛ kɛ mɔrɔku kɛ́, ɛ nyɛ nje tɔpɛ sendi Yesus. Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ́, ɛ ɗyoɓɔ nɛmbiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɛ Kimɔ Sisiŋ piyɛ nɛ yotu nda pepɔ nje kɛ yotu nɛ. Ɛ wɛtɛ mɛn wulɛ ɗyoɓɔ lɛpɔ nde: «Wɛ mɔnmbɛ, sɔŋ temɔ mbɛ, temɔ mbɛ hɛnɛ kɛ yotu yɔ!» ");
INSERT INTO kkj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus kandima mɛsay mɛnɛ, yite a mɛ kɛ mɛsew kamɔtati. Ɓomɔ ɓa̧ kɛ takɛ nde, nyɛ mɔnɔ Yosɛp. Yosɛp ɓa̧ mɔnɔ Eli. ");
INSERT INTO kkj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɓa̧ mɔnɔ Matat. Matat ɓa̧ mɔnɔ Levi. Levi ɓa̧ mɔnɔ Mɛlki. Mɛlki ɓa̧ mɔnɔ Yanay. Yanay ɓa̧ mɔnɔ Yosɛp. ");
INSERT INTO kkj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛp ɓa̧ mɔnɔ Matatiyas. Matatiyas ɓa̧ mɔnɔ Amɔs. Amɔs ɓa̧ mɔnɔ Nahum. Nahum ɓa̧ mɔnɔ Ɛsli. Ɛsli ɓa̧ mɔnɔ Nagay. ");
INSERT INTO kkj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay ɓa̧ mɔnɔ Mahat. Mahat ɓa̧ mɔnɔ Matatiyas. Matatiyas ɓa̧ mɔnɔ Semɛy. Semɛy ɓa̧ mɔnɔ Yosɛk. Yosɛk ɓa̧ mɔnɔ Yuda. ");
INSERT INTO kkj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda ɓa̧ mɔnɔ Yohanan. Yohanan ɓa̧ mɔnɔ Resa. Resa ɓa̧ mɔnɔ Sorobabɛl. Sorobabɛl ɓa̧ mɔnɔ Salatiyɛl. Salatiyɛl ɓa̧ mɔnɔ Neri. ");
INSERT INTO kkj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ɓa̧ mɔnɔ Mɛlki. Mɛlki ɓa̧ mɔnɔ Adi. Adi ɓa̧ mɔnɔ Kosam. Kosam ɓa̧ mɔnɔ Ɛlmadan. Ɛlmadan ɓa̧ mɔnɔ Hɛr. ");
INSERT INTO kkj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Hɛr ɓa̧ mɔnɔ Yesus. Yesus ɓa̧ mɔnɔ Eliyesɛr. Eliyesɛr ɓa̧ mɔnɔ Yorim. Yorim ɓa̧ mɔnɔ Matat. Matat ɓa̧ mɔnɔ Levi. ");
INSERT INTO kkj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ɓa̧ mɔnɔ Simeyɔŋ. Simeyɔŋ ɓa̧ mɔnɔ Yuda. Yuda ɓa̧ mɔnɔ Yosɛp. Yosɛp ɓa̧ mɔnɔ Yonam. Yonam ɓa̧ mɔnɔ Eliyakim. ");
INSERT INTO kkj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ɓa̧ mɔnɔ Meleya. Meleya ɓa̧ mɔnɔ Mena. Mena ɓa̧ mɔnɔ Matata. Matata ɓa̧ mɔnɔ Natan. Natan ɓa̧ mɔnɔ Davit. ");
INSERT INTO kkj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davit ɓa̧ mɔnɔ Isay. Isay ɓa̧ mɔnɔ Yobɛd. Yobɛd ɓa̧ mɔnɔ Bowas. Bowas ɓa̧ mɔnɔ Sala. Sala ɓa̧ mɔnɔ Nasɔn. ");
INSERT INTO kkj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔn ɓa̧ mɔnɔ Aminadap. Aminadap ɓa̧ mɔnɔ Admin. Admin ɓa̧ mɔnɔ Arni. Arni ɓa̧ mɔnɔ Ɛsrom. Ɛsrom ɓa̧ mɔnɔ Farɛs. Farɛs ɓa̧ mɔnɔ Yuda. ");
INSERT INTO kkj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ɓa̧ mɔnɔ Yakɔp. Yakɔp ɓa̧ mɔnɔ Isak. Isak ɓa̧ mɔnɔ Abaraham. Abaraham ɓa̧ mɔnɔ Tara. Tara ɓa̧ mɔnɔ Nahɔr. ");
INSERT INTO kkj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahɔr ɓa̧ mɔnɔ Seruk. Seruk ɓa̧ mɔnɔ Rago. Rago ɓa̧ mɔnɔ Falɛk. Falɛk ɓa̧ mɔnɔ Ebɛr. Ebɛr ɓa̧ mɔnɔ Sala. ");
INSERT INTO kkj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ɓa̧ mɔnɔ Kaynam. Kaynam ɓa̧ mɔnɔ Arpakisad. Arpakisad ɓa̧ mɔnɔ Sɛm. Sɛm ɓa̧ mɔnɔ Nɔy. Nɔy ɓa̧ mɔnɔ Lamɛk. ");
INSERT INTO kkj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛk ɓa̧ mɔnɔ Matusala. Matusala ɓa̧ mɔnɔ Enɔk. Enɔk ɓa̧ mɔnɔ Yarɛd. Yarɛd ɓa̧ mɔnɔ Malelɛl. Malelɛl ɓa̧ mɔnɔ Kaynam. ");
INSERT INTO kkj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam ɓa̧ mɔnɔ Enɔs. Enɔs ɓa̧ mɔnɔ Sɛt. Sɛt ɓa̧ mɔnɔ Adam. Adam ɓa̧ mɔnɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kimɔ Sisiŋ tonduma kɛ yotu Yesus kɛ ŋgimɔ te yi nyɛ yɔkwa̧ nɔ kɛ goŋ Yurdɛ̧ kɛ́. Ɛ Kimɔ Sisiŋ kɛndɛ nɛ nyɛ kɛ koŋgor. ");
INSERT INTO kkj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus ɗiyma mɛtu kamɔni kɛ koŋgor mate. Ɛ *Kum ɓeya mɛkele ɓoɓɛ nyɛ. Kɛ mɛtu te yinɔri hɛnɛ Yesus tì ɗyena na. Kɛ mɛtu mɛte ma si kwa̧ kɛ́, ɛ nyɛ wokɛ nja. ");
INSERT INTO kkj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɛ Kum ɓeya mɛkele lɛpɛ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, wɛ Mɔnɔ Njambiyɛ, lɛpɔ nyɛ tari te yɔkɔ nde: Yeŋsaŋgwɛ ɓɛ mampa.» ");
INSERT INTO kkj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Mumɔ ti yaka joŋna ndi nɛ mampa nyɛpɔ na.› » ");
INSERT INTO kkj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kɛ kɔŋte, ɛ Kum ɓeya mɛkele ɓu̧ nyɛ kɛ̀ nɔ kɛ wɛtɛ gere gere mbɛy teɗye nyɛ mɛkandɔ hɛnɛ kɛ to mɛnɛti ndi tu wɛtɛ nda yi mumɔ kiɓiɗya nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ɛ Kum ɓeya mɛkele nje lɛpɔ nyɛ nyɛ nde: «Mi ta nyɛ wɛ ɗeti te yi namɔ mɛkandɔ mɛte yikɛ hɛnɛ, ɓɛ nɛ mɛluksa mɛte, kɛto ɓo nya mi ɗeti te yi namɔ yo. Ndana mi yakama ɓu̧ yo nyɛ mɔ te yi mi kwaɗyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ɗete, ŋgɛ wɛ kusɛ mɛɓɔŋ kɛ mɛnɛti kanɔ mi, mi má nyɛ wɛ yo hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Kanɔ Baba Mbokɔ te Njambiyɛ wɔ, kelɔ mɛsay nyɛ ndi nyɛ nyɛpɔ.› » ");
INSERT INTO kkj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kɛ kɔŋte, ɛ Kum ɓeya mɛkele kɔ ɓu̧ nyɛ sendi kɛ̀ nɔ kɛ Yerusalɛm, tɛmbiɗye nyɛ kɛ tosiyɔ̧ mbanjɔ Njambiyɛ lɛpɔ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, wɛ Mɔnɔ Njambiyɛ, ɗokɔ piyɛ kɛ mɛnɛti, ");
INSERT INTO kkj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kɛto yo kɛtinate sendi kɛ mɛkana mɛ Njambiyɛ nde: ‹Njambiyɛ ta lɛpɔ nyɛ ɓejaki ɓenɛ nde, ɓo ɓâkiɗya wɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɗete, ɓo ta jɛkiɗye ɓɔ ɓiye nɛ wɛ, kambɔ wɛ nje ɗumɔ kol yɔ kɛ tari.› » ");
INSERT INTO kkj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Wɛ tî ɓoɓa Baba Mbokɔ te Njambiyɛ wɔ na.› » ");
INSERT INTO kkj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɛ nyɛ ma si ɓoɓɛ Yesus nɛ mɛnje mɛte yinɔri hɛnɛ ɗete kɛ́, ɛ nyɛ kwa̧ lɔndɔ kɛ kɛki nɛ yí laɗye yiŋa mɛŋgimɔ. ");
INSERT INTO kkj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ndana, ɛ Yesus yɔkwɛ kɛ̀ kɛ Galile nɛ ɗeti Kimɔ Sisiŋ kɛ yotu. Ɓo ɓa̧ kɛ lɛpɔ kasi nɛ kɛ pɔku mɛnɛti mɛte yinɔri hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mɔy mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Ɛ ɓomɔ hɛnɛ ɗiki lukse nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kɛ kɔŋte, ɛ nyɛ kwa̧ kɛ̀ kɛ Nasarɛt kɛ mbɛy komɛ nyɛ ɗɔkuma kɛ́. Kɛ yesɔ *Saba ɛ nyɛ kwa̧ kɛ̀ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nda njɛl wenɛ. Ɛ nyɛ tɛmɛ, na tɔl mɛkana mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɛ ɓo ɓu̧ mɛkana mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ́ nyɛ nyɛ. Ɛ nyɛ ɓutɛ mɛkana tɔlɔ kɛ mbɛy te yi ɓa̧ kɛtinate nde: ");
INSERT INTO kkj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‹Sisiŋ Baba Mbokɔ kɛ yotu mbɛ. A tɔkuma mi, nɛ́ mi lɛpi Kimɔ Tom nyɛ buka ɓomɔ, tomɔ mi, nɛ́ mi lɛpi nyɛ ɓebala nde, ɗiyɔ bala yan siyma. Sendi, a tomma mi, nɛ́ mi lɛpi nyɛ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka nde, ɓo ɓɛ̂ŋnaŋgwɛ, tomɔ mi, nɛ́ mi joŋgwɛ ɓotu ɓete yi ɓo teɗye ɓo mɛbɔnɛ ɓaka, ");
INSERT INTO kkj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pelɛ nyɛ ɓomɔ sew te yi Baba Mbokɔ ta joŋgwɛ ɓo kɛte kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kɛ nyɛ ma si tɔlɔ kɛ́, ɛ nyɛ ɗiɓɛ mɛkana yɔkiɗye nyɛ mɔ te ɛ ɓa̧ kɛ kelɔ mɛsay kɛ mɔy mbanjɔ mɛwesiɗya kɔ. Kɛ kɔŋte, ɛ nyɛ kwa̧ ɗiyɔ. Ɓomɔ hɛnɛ ɓe ɓa̧ kɛ mɔy mbanjɔ ɓaka ɗikima ɓɛŋɛ nyɛ nɛ ŋgoŋ. ");
INSERT INTO kkj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ndana, ɛ Yesus lɛpɛ nyɛ ɓo nde: ‹Kɛ yesɔ te yɔkɔ muka, mɛyasi mɛte yi wunɛ wokuma, mi kɛ tɔlɔ kɛ mɛkana mɛ Njambiyɛ kɛ́ ma kelna gbate.› ");
INSERT INTO kkj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɛ ɓomɔ hɛnɛ jayɛ nyɛ. Ɛ ɓo ŋgbakima kimɔ mɛlɛpi mɛte yi ɗikima pundɔ kɛ numbu nɛ kɛ́. Ɛ ɓomɔ diyɛ nde: «’Yɔkɔ yeti mɔnɔ Yosɛp na?» ");
INSERT INTO kkj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Yo gbate, wunɛ ta nyɛ mi kanɔ nde: ‹Dɔkita, siɗyikwɛ kɔn yɔ nɛ ŋguru wɔ.› Wunɛ ta lɛpɔ sendi nyɛ mi nde: ‹Wusɛ wokuma mɛyasi mɛte yi wɛ kelma kɛ Kapɛrnawum kɛ́ hɛnɛ. Pa kelɔ sendi kiya mɛyasi mɛte waka kɛ ɗya ɗyɔ.› » ");
INSERT INTO kkj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nyɛ ɓomɔ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ɓo tí jaya mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ ɗya ɗyenɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mi kɛ lɛpɔ gbate nyɛ wunɛ nde: Ɓekusɔ ɓoma ɓa̧ kɛ mɛnɛti mɛ Isarayɛl ɓuɗyate kɛ ŋgimɔ te yi Eli ɓa̧ nɛ joŋ kɛ́. Sew yitati nɛ̀ ŋgwɛndɛ yitan jɔ wɛtɛ kwaŋma kinɛ mbiyɔ nɛ nɔ na, ɛ nyaŋgwɛ kolɔ ɗya̧ kɛ ndiŋgɛlɛ mɛnɛti mɛ Isarayɛl hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko ɗete, Njambiyɛ tì tomɛ Eli kɛnjɛ kɛ yasi wɛtɛ kusɔ kɛ njoka ɓekusɔ ɓoma ɓe kandɔ Isarayɛl na. A kpalma tomɔ Eli kɛnjɛ kɛ yasi wɛtɛ kusɔ nyari kɛ Sarɛpta kɛ mɛnɛti mɛ Sidɔn. ");
INSERT INTO kkj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sendi, kɛ ŋgimɔ te yi Elise te mɔ punja mɛlɛpi mɛ Njambiyɛ ɓa̧ nɛ jɔŋ kɛ́, ɓomɔ ɓe ndoko ɓa̧ ɓuɗyate kɛ Isarayɛl. Ko ɗete, mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yan tì nje nde, ɓo sâki kɔn nɛ na, ndi wɛtɛ jɛŋgwɛ nde Naman te mɔ mɛnɛti mɛ Siri nja̧.» ");
INSERT INTO kkj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kɛ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ mbanjɔ ɓaka ma wokɔ ɗete kɛ́, ɛ ɓo wokɛ ŋgambi ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɛ ɓo tɛmɛ ɗuɗye Yesus kɛ ɗya ɗyan ŋgbɔsɔ nyɛ kɛ̀ nɔ kɛ to keki, nɛ́ ɓo kɛ̀ pusu nyɛ ɓetɛ kɛnjɛ gboŋgo. Ɗya ɗyan te ɓa̧ kɛ to keki. Ɓo ka̧ nɛ nyɛ mate, nɛ́ ɓo kɛ̀ pusu nyɛ ɓetɛ kɛnjɛ gboŋgo. ");
INSERT INTO kkj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yasi wɛtɛ, ɛ nyɛ kwa̧ nɛ ŋgbeŋ ŋgbeŋ kɛ njoka yan kinɛ mumɔ nɛ ɓiye nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ndana, ɛ Yesus siliyɛ kɛ̀ kɛ wɛtɛ ɗya nde Kapɛrnawum kɛ Galile. Kumɔ mate, ɛ nyɛ ɗiki teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ yesɔ *Saba. ");
INSERT INTO kkj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓomɔ ŋgbakimama kwalɔ teɗya yasi te yenɛ ɓuɗyate, kɛto a ɗikima lɛpina nɛ ɗeti Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wɛtɛ mbam ɓa̧ kɛ mɔy mbanjɔ nɛ ɓeya sisiŋ *Satan kɛ yotu. Ɛ nyɛ kembiɗya nɛ mɛn kɛ kwey nde: ");
INSERT INTO kkj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ŋge ɓa Yesus te mɔ Nasarɛt, sinɛ wunɛ nɛ lɛpi te nda? ’Wɛ njáki nje girise wusɛ? Mi duwa̧ wɛ kimɔte, wɛ pupuna mɔ te yi Njambiyɛ tɔkuma njesɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ɛ Yesus ɓama nɛ ɓeya sisiŋ lɛpɔ nde: «Ɗiɓɔ numbu yɔ pundɔ kɛ yotu mbam kɔ.» Ɛ ɓeya sisiŋ jalɛ mbam kɔ ɓetɛ kɛ mɛnɛti kɛ misi mɛ ɓomɔ hɛnɛ ɓe ɓa̧ womɛte ɓaka pundɔ kwa̧ kinɛ kelɔ yiŋa ɓeya yaŋa nɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɛ ɓomɔ hɛnɛ ŋgbakima ɓuɗyate numbu hɛ haŋ, ɛ ɓo ɗiki diyna nde: «Kwalɔ lɛpi te yikɛ nan? Mbam te yɔkɔ kɛ ɓama nɛ ɗeti nyɛ ɓeya mɛsisiŋ, ɓeya mɛsisiŋ kɛ pundɔ kwa̧.» ");
INSERT INTO kkj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɛ ɗinɔ Yesus wumɛ njanja yaka nɛ pɔku mɛnɛti mɛte yinɔri hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kɛ kɔŋte, ɛ nyɛ pundɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ̀ kɛ tu̧ wɛtɛ mbam nde Simɔn. Ki nɛ Simɔn ɛ nyari ɓa̧ kɛ kɔnɔ ɓuɗyate nɛ ɗuku. Ɛ ɓo ŋgwɛta nɛ Yesus nde, a jôŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ɛ Yesus ɗitima kɛ to nyari ɓama nɛ kɔn, ɛ kɔn siyɛ. Ndana ndana, ɛ nyari kɛ̀ kelɔ mɛsay nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kɛ ŋgimɔ te yi tu ɓa̧ kɛ yinja kɛ́, ɛ ɓomɔ hɛnɛ ɓe ɓa̧ nɛ ɓenjɔŋ ɓan ɓe ɗikima kɔnɔ nɛ mboya mɛkɔn hɛnɛ ɓaka ɓu̧ ɓo nje nɔ kɛ yi Yesus. Ɛ nyɛ kasɛ mɛɓɔ kɛ yotu mumɔ hɛnɛ siɗyɛ mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɓeya mɛsisiŋ punduma sendi kɛ yotu ɓuɗya ɓomɔ. Ɓeya mɛsisiŋ mɛte ɗikima kembiɗya nde: «Wɛ Mɔnɔ Njambiyɛ!» Ɛ Yesus ɗiki ɓamɛ ɓo ɗiɓɔ mɛnumbu man, kɛto ɓeya mɛsisiŋ duwa̧ nde, Yesus nyɛ *Krist, yɔkɔ yi Njambiyɛ tomma kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kɛ misi ma pupɔ kɛ́, ɛ Yesus ɗuwɛ kɛ̀ ɗya kɛ̀ wɛtɛ mbɛy te yi ɓa̧ kinɛ ɓomɔ kɛte kɛ́. Ɛ ŋgil ɓomɔ kandɛ saŋna nɛ. Kɛ ɓo ma dolɔ nyɛ kɛ́, ɛ ɓo sa̧ nde, a tî kwaŋ se kɛ̀ kɛ wɛtɛ mbɛy tikɔ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Mi yâkaŋgwɛ kɛ̀ sendi kɛ yiŋa mɛɗya kɛ̀ lɛpɔ Kimɔ Tom kɛ kasi *Kandɔ Njambiyɛ, kɛto a ma tóm mi njesɛ kɛto te yite.» ");
INSERT INTO kkj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɛ nyɛ kɛ̀ mbɔmbu pelɛ Kimɔ Tom kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wɛtɛ yesɔ Yesus ɓa̧ kɛ goŋ wɛtɛ nyaŋgwɛ matɔ nde Genesarɛt. Ɛ ŋgil ɓomɔ ɓɛ kɛ suŋna mbɛy kɛ kɛki nɛ, nɛ́ ɓo woku mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɛ nyɛ ɓɛŋɛ mɛlandi yiɓa kɛ goŋ. Ɓotu ɓe wona ɓenjanjɔ ɓe piya kɛ mɛlandi mɛte ɓaka ɓa̧ kɛ weyɛ mɛbulajama man. ");
INSERT INTO kkj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ɛ nyɛ kwa̧ ɓendɔ wɛtɛ landi te. Yo ɓa̧ landi Simɔn. Ɛ nyɛ lɛpɛ nyɛ Simɔn nde, a pûsu landi kɛnjɛ nɛ mbɛt pulɔ sombu. Ɛ nyɛ kwa̧ ɗiyɔ mɛtiɗyɛ kɛ mɔy landi kɛ̀ mbɔmbu teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kɛ nyɛ ma si lɛpina nyɛ ɓomɔ kɛ́, ɛ nyɛ lɛpɛ nyɛ Simɔn nde: «Ɓoŋgɔ landi kɛ̀ nɔ pulɔ ɗimɔ, nɛ́ wunɛ ɓeta bulajama kɛ ɗuku.» ");
INSERT INTO kkj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ɛ Simɔn lɛpɛ nyɛ nyɛ nde: «Yekele, wusɛ ɓɛŋma bɔnɛ kɛ ndiŋgɛlɛ tu kɔ muka kumɔ ɓemɛŋmɛnɛ kinɛ wo yaŋa na. Ko ɓɛkɔ ɗete, mi ta ɓetɛ bulajama ndana kɛ ɗuku, kɛto yo wɛ lɛpɛ nde, mi ɓêta.» ");
INSERT INTO kkj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kɛ ɓo ma ɓetɛ mɛbulajama kɛ ɗuku kɛ́, ɛ ɓo wo ɓenjanjɔ ɓuɗyate. Ɛ mɛbulajama kandɛ nyaliyate. ");
INSERT INTO kkj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɛ ɓo pɛpiɗye ɓɔ kɛnjɛ ɓenjɔŋ ɓan ɓe ɓa̧ kɛ mɔy landi te yɔru ɓaka nde, ɓo njâki kamɛ ɓo. Ɛ ɓo nje, ɛ ɓo tonjɛ ɓenjanjɔ kɛ mɛlandi mɛnɔri yiɓa, ɛ yo kandɛ ɗyena mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kɛ Simɔn Piyɛr ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus lɛpɔ nde: «Nyaŋgwɛ Kumande, jisa kɛ kɛki mbɛ, kɛto mi mɔ mɛɓeyɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simɔn Piyɛr lɛpinama ɗete, kɛto a gwa̧ wɔ̧. Ɓenjɔŋ ɓenɛ hɛnɛ gwa̧ wɔ̧ sendi ɗete, kɛto ɓuɗya ɓenjanjɔ ɓete yi ɓo woma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jak ɓenɛ Jaŋ te ɓɔnɔ ɓe Seɓede, ɓekumbɔ ɓe ɓetina bulajama ɓe Simɔn gwa̧ sendi wɔ̧ ɗete. Ɛ Yesus lɛpɛ nyɛ Simɔn nde: «Wɛ tî gwaki wɔ̧ na, kandɛ ndana wɛ tí ɓɛ se mɔ wona ɓenjanjɔ na. Wɛ ta nje ɓɛ mɔ ɓoŋna ɓomɔ teɗye ɓo nje Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndana, ɛ ɓo nje ŋgbɔsɔ mɛlandi man, tikɔ mɛyasi hɛnɛ ɓeŋgwɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesus ɓa̧ kɛ wɛtɛ ɗya kɛ pɔku mɛnɛti mɛte. Wɛtɛ mbam ɓa̧ mate nɛ yotu hɛnɛ tandɛ ndoko. Kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ Yesus kɛ́, ɛ mbam nje kusɛ mɛɓɔŋ kɛ mbɔmbu wenɛ ŋgwɛta nɛ nyɛ lɛpɔ nde: «Nyaŋgwɛ Kumande, ŋgɛ wɛ kwaɗyɛ, kelɔ nde, yotu mbɛ ɓɛ̂ki nɛ kpɛlɛŋ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɛ Yesus sambile ɓɔ kpokɛ nɛ nyɛ lɛpɔ nde: «Mi kwaɗya, yotu yɔ ɓɛ̂ki nɛ kpɛlɛŋ.» Ndana ndana, ɛ ndoko siyɛ kɛ yotu mbam. ");
INSERT INTO kkj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Kpɛ, wɛ tî yekiɗya mɛyasi mɛte yi kwaŋnama kɛ́ nyɛ mumɔ na. Yasi wɛtɛ, kɛn kɛ̀ teɗye yotu yɔ nyɛ mɔ nyɛna sadaka nyɛ Njambiyɛ, nɔ̀ kɛ̂n kelɔ sadaka, nɛ́ wɛ ɓɛ pupunate kɛ misi mɛ Njambiyɛ nda yi Mɔyisi pɛsima kɛ́, nɛ́ ɓomɔ duwɛ nde, kɔn yɔ siyma.» ");
INSERT INTO kkj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ko ɓɛkɔ nde, Yesus lɛpima nyɛ mbam nde, a tî yekiɗya na, je nɛ kpalma kɛ̀ kɛndɔ mbɔmbu. Ɓuɗya ɓomɔ ɗikima nje wesiɗya kɛ kɛki nɛ, nɛ́ ɓo woku mɛlɛpi mɛnɛ, na siɗyɛ sendi mɛkɔn man. ");
INSERT INTO kkj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yasi wɛtɛ, Yesus ɗikima kwa̧ nɛ kɛ̀ kɛ mɛmbɛy mɛte yi ɓomɔ yeti kɛte kɛ́ kɛ̀ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wɛtɛ yesɔ Yesus ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. *Ɓefarisɛ̧ nɛ̀ nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga ɓa̧ mɛtiɗyɛ kɛ kɛki nɛ. Ɓo wulma kɛ Yerusalɛm, wulɛ sendi kɛ mɛɗya hɛnɛ kɛ Galile nɛ̀ Yuda. Baba Mbokɔ nya Yesus ɗeti te yi siɗyɛ mɛkɔn mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ndana, ɛ ɓaŋa ɓomɔ soɓɛ wɛtɛ mbam nɛ taŋ ɗya̧ nɔ. Mbam te ɓa̧ mɔ jɛmti, a ti kɛ́ndi na. Ɓo saŋma nje te yi nyiŋɛ nɛ nyɛ kɛ mɔy tu̧ nje tikɔ kɛ mbɔmbu Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yasi wɛtɛ, ɓo tì ɓɛ nɛ nje kwaŋge na kɛto ŋgil. Ɛ ɓo ɓendɛ nɛ nyɛ kɛ tosiyɔ̧ kelɔ njɛmbi kɛte piɗyɛ nyɛ nɛ taŋ nɛ hɛnɛ kɛ njoka ɓomɔ kɛ mbɔmbu Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɛ Yesus ma ɓɛŋɛ kwalɔ tikina temɔ te yi ɓotu ɓaka ɓa̧ nɔ kɛ́, ɛ nyɛ lɛpɛ nyɛ mɔ jɛmti nde: «Mbam, mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɛ Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi lɛpɛ kɛ mɔy mɛtemɔ man nde: «Yɔkɔ ɓa̧ nda ɛ gbutɛ gba nɛ Njambiyɛ kɔ? Nda yakama tikɔ mɛɓeyɔ mɛ mumɔ nɛ ŋgwɛtɛ kɔ? Kinɛ wɛtɛ mumɔ na, ndi Njambiyɛ nyɛpɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus duwa̧ mɛtakɛ man, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yikɛ ɓa kwalɔ mɛtakɛ te nda yi wunɛ ɓɛ nɔ ɗekɛ kɛ temɔ yun kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nɛ̀ lɛpinate nde: ‹Mɛɓeyɔ mɔ, mi kɛ tikɔ yo nɛ ŋgwɛtɛ› nɛ̀ lɛpina te nde: ‹Tɛma, kɛndɔ,› ’kelna ŋge kwa̧ jɛwɔ kɛ njokate? ");
INSERT INTO kkj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ɗete, mi ta teɗye wunɛ nde, *Mɔnɔ mumɔ nɛ ɗeti te yi tikɔ mɛɓeyɔ mɛ ɓomɔ nɛ ŋgwɛtɛ kɛ to mɛnɛti.» Ɛ nyɛ nje lɛpɔ nyɛ mɔ jɛmti nde: «Tɛma, ɓoŋgɔ taŋ yɔ, ɗukwɛ kɛ̀ tu̧ ɗyɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ndana ndana, ɛ mbam tɛmɛ nɛ ŋgɛt kɛ misi mɛ ɓomɔ hɛnɛ, ɓu̧ taŋ te yi nyɛ ɓa̧ mɛtinɛŋgwɛ kɛte kɛ́, ɗuwɛ nɔ kɛ̀ nɔ tu̧ nɛ luksa Njambiyɛ kɛ numbu. ");
INSERT INTO kkj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɛ ɓomɔ hɛnɛ ŋgbakima lukse Njambiyɛ. Ɓo gwa̧ wɔ̧ ɓuɗyate. Ɛ ɓo ɗiki lɛpɔ nde: «Kwalɔ mɛyekambiyɛ mɛte yikɛ nan yi wusɛ ɓɛŋma muka kɛ́!» ");
INSERT INTO kkj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kɛ kɔŋte, ɛ Yesus pundɛ kwa̧. Ɛ nyɛ kɛ̀ dolɔ wɛtɛ mɔ ɓoŋna mɔni garama nde Levi kɛ ɗiyɔ kɛ mbɛy mɛsay mɛnɛ. Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɓeŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɛ nyɛ tɛmɛ tikɔ numbu mɛsay mɛnɛ hɛnɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɛ Levi kelɛ ɓuɗya mɛɗye jeɓa nɛ ɓomɔ kɛ tu̧ ɗyenɛ kɛto Yesus. Ɓo ɓa̧ kɛ ɗyena ɓenɛ ɓaŋa ɓuɗya ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓaŋa ɓomɔ sendi. ");
INSERT INTO kkj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi ɓe ɓa̧ kɛ kiya njɔŋ wɛtɛ ɓaka wokuma ŋgambi lɛpɔ nyɛ ɓejekɛ ɓe Yesus nde: «Kɛto ŋge yi wunɛ ɗyena nɛ̀ yi wunɛ hɔɓiye mɛnjam kɛ mbɛy wɛtɛ wúnɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe mɛɓeyɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Yeti ɓotu ɓete ɓe nɛ mɛmbundɔ nɛ tɛ ɓaka sa̧ nje mɔ nyɛti na, yasi wɛtɛ, yo ndi ɓotu ɓete ɓe kɔnɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi ti njáki nje jeɓa ŋgbeŋ ɓomɔ nde, ɓo yêŋsaŋgwɛ temɔ na. Mi njáki nje jeɓa ɓotu ɓe mɛɓeyɔ nde, ɓo yêŋsaŋgwɛ temɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɛ *Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi lɛpɛ nyɛ Yesus nde: «Ɓejekɛ ɓete ɓe Jaŋ nɛ̀ ɓejekɛ ɓete ɓe *Ɓefarisɛ̧ kɛ ɗiki kiyɔ mɛɗye yaka nɛ mɛŋgimɔ. Ɓo kɛ ɗiki ŋgwɛta sendi nɛ Njambiyɛ. Yasi wɛtɛ, ɓejekɛ ɓete ɓɔ kɛ ɗyena yan lalɛ, hɔɓiye sendi lalɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ŋgɛ mumɔ jeɓa ɓesɔ ɓenɛ kɛ mɛkeɓi mɛ gwaki, wunɛ má kiɗyɛ ɓo mɛɗye piŋɔ te yi nyɛ ndi kɛte ɓenɛ ɓo kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yasi wɛtɛ, ŋgimɔ ta ɗya̧ yi ɓomɔ ta soŋɛ nɛ nyɛ kɛ mɛɓɔ man. Yo kɛ ŋgimɔ te yite yi ɓo ta kiyɔ mɛɗye yɛy.» ");
INSERT INTO kkj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɛ nyɛ nyɛ sendi ɓo wɛtɛ kanɔ nde: «Mumɔ ti ɓóŋ jɔnja pɛl lambɔ nje datɔ nɛ njombute na. Kɛto ŋgɛ yo kelna ɗete, jɔnja lambɔ ta nje ɓɛ nɛ tɔsu. Sendi, pɛl jɔnja lambɔ tí ɓɛŋna kimɔte kɛ njombute na. ");
INSERT INTO kkj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mumɔ ti sɔ́pita mɛnjam nyɛ kɛ ɓɔru mɛmbe na. Kɛto jɔnja mɛnjam ta wuɗyɛ kelɔ nde, mɛmbe pôsukwɛ, mɛnjam ma dɛndila kɛ mɛnɛti, mɛmbe má si yambile gwe nyiŋɛ siri. ");
INSERT INTO kkj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yasi wɛtɛ, mumɔ sɔ́pita mɛnjam kɛ jɔnja mɛmbe. ");
INSERT INTO kkj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sendi, mumɔ ti jáya njombu mɛnjam, ŋgɛ nyɛ si hɔɓiye jɔnjate na. Ɓo lɛ́pi kpo nɛ kpo nde: ‹Jɔnja mɛnjam kwa̧ nyɔŋɔ nɛ njombute.› » ");
INSERT INTO kkj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wɛtɛ yesɔ Yesus ɓa̧ kɛ kwa̧ kɛ mɔy mɛŋgwaŋ mɛte yi ɓo ɓɛma nyambi te yi ɓo kelɛ nɛ mampa kɛ́. Yo ɓa̧ kɛ yesɔ *Saba. Ɛ ɓejekɛ ɓenɛ lekɛ mɛto mɛte patɛ mɛmbumɔ mɛte ɗye. ");
INSERT INTO kkj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ɛ ɓaŋa *Ɓefarisɛ̧ lɛpɛ nyɛ ɓo nde: «Kɛto ŋge yi wunɛ kelɛ mɛyasi mɛte yi mɛmboŋga musu kiɗyɛ nde, mumɔ tî kel kɛ yesɔ Saba kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ɛ Yesus yeŋsa nyɛ ɓo nde: «’Wunɛ tì pa tɔlɔ yasi te yi kumande Davit kelma komɛ nyɛ gwa̧ nja ɓenɛ ɓomɔ ɓenɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A nyiŋma kɛ mbanjɔ Njambiyɛ, ɓu̧ mɛmampa mɛte yi ɗiyɛ kɛte kɛ́ ɗye, ɓu̧ sendi yiŋa nyɛ ɓotu ɓenɛ, ko ɓɛkɔ nde, yo ɓa̧ ndi ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓepɔ yâkaŋgwɛ ɗye yo.» ");
INSERT INTO kkj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Yo mi, *Mɔnɔ mumɔ ɗiyɛ sendi nɛ yesɔ Saba.» ");
INSERT INTO kkj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wɛtɛ yesɔ *Saba sendi Yesus nyiŋma kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. Wɛtɛ mbam ɓa̧ womɛte, mbam ɓɔ nɛ ma jɛmɛ ɓɛ nɛ fɛŋgɛlɛŋ. ");
INSERT INTO kkj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ɓotu ɓe kɛtina mɛyasi nɛ̀ *Ɓefarisɛ̧ ɓa̧ kɛ pɛmɔ Yesus yí ɓɛŋɛ, simande a ta siɗyɛ kɔn mumɔ kɛ yesɔ Saba, nɛ́ ɓo kweɗya nje te yi lɛpɔ nde, a kelma yiŋa ɓeya yasi. ");
INSERT INTO kkj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yasi wɛtɛ, Yesus duwa̧ mɛyasi mɛte yi ɓo ɓa̧ kɛ takɛ kɛ mɔy mɛtemɔ man kɛ́. Ɛ nyɛ lɛpɛ nyɛ mɔ te yi ɓɔ nɛ ma jɛmɛ kɔ nde: «Tɛma, ɗiyɔ womɛri kɛ ɓembe ɓomɔ.» Ɛ nyɛ tɛmɛ ɗiyɔ kɛ tɛri kwey. ");
INSERT INTO kkj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Mi kɛ diyɛ wunɛ nde: Mɛmboŋga mun lɛ́pi nɛ ŋge? Ɓo kâma mumɔ kɛ yesɔ Saba, ho ɓo kêl nyalɔ nɛ nyɛ? Nɛ̀ joŋgwa mumɔ nɛ̀ wona mumɔ, yo yasi te nda yi mumɔ yâkaŋgwɛ kelɔ kɛ yesɔ Saba kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ɛ nyɛ kaŋɛ misi ŋgɛkila ɓɛŋɛ nɛ ɓo hɛnɛ kɛ kɛki nɛ. Ɛ nyɛ nje lɛpɔ nyɛ mbam te yi ɓɔ nɛ ma jɛmɛ kɔ nde: «Sambila ɓɔ.» Ɛ nyɛ sambile ɓɔ. Ɛ ɓɔ nɛ yi ma jɛmɛ kɛ́ yɔkwɛ nje kɛ mbɛy te. ");
INSERT INTO kkj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ko ɓɛkɔ ɗete, ɓomɔ ɓaka wokuma ɓeya ŋgambi. Ɛ ɓo diyna yí sa̧ yasi te yi ɓo yakama kelɔ nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kɛ mɛtu te yite ɛ Yesus tɛmɛ kɛ̀ kɛ wɛtɛ keki kɛ̀ ŋgwɛta nɛ Njambiyɛ. A kwaŋɗya ndiŋgɛlɛ tu mate yí ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kɛ misi ma pupɔ kɛ́, ɛ nyɛ jeɓa ɓejekɛ ɓenɛ, sawɛ ɓomɔ kamɔ jɔ yiɓa kɛ njoka yan, nyɛ ɓo ɗinɔ nde Ɓotu ɓe tomun. ");
INSERT INTO kkj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yo ɓa̧ nɛ Simɔn te yi nyɛ loma nde Piyɛr kɔ ɓenɛ ndɛmbi wenɛ Andere ɓu̧ Jak nɛ̀ Jaŋ ɓu̧ Filip ɓenɛ Bartelemi. ");
INSERT INTO kkj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Yo ɓa̧ sendi nɛ Matiyo ɓenɛ Tomasi ɓu̧ Jak te mɔnɔ Alfe ɓu̧ Simɔn te yi ɓo ɗikima jeɓa nde Mɔnɔ kandɔ kɔ, ");
INSERT INTO kkj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ɓu̧ sendi Yude, mɔnɔ Jak nje ɓu̧ Yudas Iskariyot, yɔkɔ ɛ nja̧ ɗyaŋgwɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɛ Yesus piyɛ ɓenɛ ɓo wulɛ keki kɛ̀ kɛ tɛfɛn mɛnɛti komɛ ŋgil ɓejekɛ ɓenɛ ɓa̧ kɛ́. Ɓuɗya ɓotu ɓete ɓe wulma kɛ mɛnɛti mɛ Ɓeyudɛn hɛnɛ ɓaka nɛ̀ ɓe wulma kɛ Yerusalɛm, wulɛ sendi kɛ Tir nɛ̀ Sidɔn kɛ goŋ maŋ ɓaka ɓa̧ womɛte. ");
INSERT INTO kkj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓo nja̧ nje wokɔ mɛyasi mɛte yi nyɛ ta lɛpɔ kɛ́, nje sendi nɛ mɛkɔn man, na siɗyɛ yo. Ko ɓotu ɓete ɓe ɓeya mɛsisiŋ ɗikima njaŋgwɛ ɓo ɓaka, a kelma nde, ɓeya mɛsisiŋ pûndu kɛ yotu yan. ");
INSERT INTO kkj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mumɔ hɛnɛ saŋma nje te yi kpokɛ nyɛ, kɛto yiŋa nyaŋgwɛ ɗeti ɗikima wulɛ kɛ yotu nɛ siɗyɛ mɛkɔn man hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kɛ kɔŋte, ɛ nyɛ kaŋɛ misi ɓɛŋɛ ɓejekɛ ɓenɛ lɛpɔ nde: «Wunɛ ɓe buka ɓomɔ ndana, ko ɓɛkɔ ɗete, wunɛ nɛ mɛsosa, kɛto *Kandɔ Njambiyɛ, yo yun. ");
INSERT INTO kkj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ndana wunɛ kɛ gwe nja, ko ɓɛkɔ ɗete, wunɛ nɛ mɛsosa, kɛto wunɛ ta ɓɛ nɛ ditɔ. Wunɛ kɛ lelɔ ndana, ko ɓɛkɔ ɗete, wunɛ nɛ mɛsosa, kɛto wunɛ ta nyukuma. ");
INSERT INTO kkj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wunɛ nɛ mɛsosa komɛ ɓomɔ ta ɓenɔ wunɛ ɗuɗye wunɛ kɛ kɛki yan toyɛ wunɛ lɛpina ɓeyate nɛ wunɛ kɛto mbɛ *Mɔnɔ mumɔ. ");
INSERT INTO kkj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wunɛ sôsaŋgwɛ ɗo kɛ yesɔ te yite, kɛto nyaŋgwɛ sol kɛ laɗye wunɛ kɛ ɗyoɓɔ. Wunɛ dûkwɛ nde, ɓesaŋgwɛ ɓan kelma ndi sendi ɗete nɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma wunɛ ɓotu ɓe kusuku, wunɛ ta saŋgwa nɛ mɛbɔnɛ, kɛto wunɛ ma si dolɔ bɔtɛ te yun. ");
INSERT INTO kkj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wunɛ ɓotu ɓe nɛ ditɔ ndana ɓaka, wunɛ ta saŋgwa nɛ mɛbɔnɛ, kɛto wunɛ ta gwe nja. Wunɛ ɓotu ɓete ɓe nyukuma ndana ɓaka, wunɛ ta saŋgwa nɛ mɛbɔnɛ, kɛto wunɛ ta jaɓa lelɔ. ");
INSERT INTO kkj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wunɛ ta saŋgwa nɛ mɛbɔnɛ, ŋgɛ ɓomɔ hɛnɛ jayɛ wunɛ, kɛto ɓesaŋgwɛ ɓan ɗikima jayɛ sendi ɓeya ɓotu ɓe punja mɛlɛpi mɛ ja̧. ");
INSERT INTO kkj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ma wunɛ ɓotu ɓete ɓe wokɛ mɛlɛpi mɛte yi mi lɛpɛ kɛ́, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ kwâɗyikwɛ ɓependɔ ɓun. Wunɛ kêl kimɔ yasi nɛ ɓotu ɓete ɓe ɓenɛ wunɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wunɛ dîya Njambiyɛ nde, a nyɛ̂ki mɛkombila nyɛ ɓotu ɓete ɓe kita nɛ wunɛ ɓaka, ŋgwɛta sendi nɛ nyɛ, kɛto ɓotu ɓete ɓe ɗyaŋgwɛ ɗinɔ ɗyun ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ŋgɛ mumɔ nyɛ wɛ ɓanji kɛ pokɔ te ɛ wɛtɛ, nɔ̀ yêŋsaŋgwɛ sendi yɔru nyɛ nyɛ. Ŋgɛ mumɔ sukɛ nyaŋgwɛ lambɔ ɗuku yɔ, nɔ̀ tîki sendi nde, a ɓôŋ lambɔ te yi kɛ yotu yɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋgɛ mumɔ jɔmbɛ yiŋa yasi kɛ ɓɔ yɔ, nɔ̀ nyɛ̂ki nyɛ. Ŋgɛ mumɔ nda nɛ yasi yɔ, wɛ tî diya se yo kɛ ɓɔ nɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yasi te yi wunɛ kwaɗyɛ nde, ɓomɔ kêl nɛ wunɛ, wunɛ kêl sendi ɗete nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ŋgɛ wunɛ kwaɗyɛ ndi ɓotu ɓete ɓe kwaɗyɛ wunɛ ɓaka, ɓo ta jayɛ wunɛ nɛ nje te yin? Kɛto ko ɓotu ɓe mɛɓeyɔ kwáɗyikwɛ ndi sendi ɓotu ɓete ɓe kwaɗyɛ ɓo ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ŋgɛ wunɛ kelɛ ndi kimɔ yasi nɛ ɓotu ɓete ɓe kelɛ kimɔ yasi nɛ wunɛ, ɓo ta jayɛ wunɛ nɛ nje te yin? Kɛto ɓotu ɓe mɛɓeyɔ kél ndi sendi ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ŋgɛ wunɛ nyɛ ndi pilo nyɛ ɓotu ɓete ɓe wunɛ takɛ nde, ɓo yakama yɔkiɗye yo nyɛ wunɛ ɓaka, ɓo ta jayɛ wunɛ nɛ nje te yin? Kɛto ɓotu ɓe mɛɓeyɔ nyɛ́ki ndi pilo nyɛ ɓotu ɓe mɛɓeyɔ, nɛ́ ɓo yɔkiɗye nyɛ ɓo yaka nɛ yan. ");
INSERT INTO kkj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kɛ ɓɛ wunɛ, wunɛ kwâɗyikwɛ ɓependɔ ɓun. Wunɛ kêl kimɔ yasi nɛ ɓomɔ, nyɛ ɓo pilo soŋɛ temɔ kɛ kɔŋte. Ŋgɛ wunɛ kelɛ ɗete, ɓo ta jayɛ wunɛ ɓuɗyate. Wunɛ ta ɓɛ ɓɔnɔ ɓe Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ, kɛto a kél kimɔ yasi nɛ ɓotu ɓe nyalɔ, kelɔ sendi nɛ ɓotu ɓete ɓe ti dúkwɛ ŋgikwa ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wunɛ gwâki ŋgwɛtɛ ɓɛsɔ nda yi Njambiyɛ saŋgwɛ wun gwe nɛ ŋgwɛtɛ wun kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Wunɛ tî jɔsa mumɔ na, ɗete ɓo tí jɔse sendi wunɛ na. Wunɛ tî pɛsi lɛpi mumɔ na, ɗete ɓo tí pɛsɔ sendi lɛpi yun na. Wunɛ tîki ɓomɔ nɛ ŋgwɛtɛ kɛ ɓeya yasi te yi ɓo kelɛ nɛ wunɛ kɛ́, ɗete Njambiyɛ ta tikɔ sendi wunɛ nɛ ŋgwɛtɛ kɛ ɓeya yasi te yi wunɛ kelɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wunɛ kâɓi nɛ ɓomɔ, ɗete Njambiyɛ ta kaɓɔ nɛ wunɛ. A ta yekɔ yasi nyɛ kɛ mapi yun nɛ kimɔ nyaŋgwɛ kɔpu. A ta yekɔ ŋgbɔkise ɗinɔ, kɔpu má tondɔ nɛ lɛtɛtɛ wesiɗye. Ɗete, Njambiyɛ ta nyɛ wunɛ mɛkombila ɓeŋgwɛ ndi kiya ɗɔkɔ mapi te yi wunɛ yekɛ nɛ yasi nyɛ ɓɛsɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus ka̧ mbɔmbu nyɛ ɓo wɛtɛ kanɔ lɛpɔ nde: «’Mɔ ɗiɓina misi yakama teɗye ka wɛtɛ mɔ ɗiɓina misi nje? Ŋgɛ ɓɛ ɗete, ’ɓo hɛnɛ yiɓa kina ɓal kɛ mɔy ɓelɔ na? ");
INSERT INTO kkj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mɔ te ɛ jekɛ mɛsay kɔ tì kwa̧ masa wenɛ na. Yasi wɛtɛ, ŋgɛ nyɛ siɗyɛ jekinate hɛnɛ kimɔte, a má nje ɓɛ nda masa wenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Ŋge kelɛ yi wɛ ɓɛŋɛ ndi mbulma ɗyan te yi kɛ misi mɛ mɔŋ kinɛ pa wokɔ kɛlɛŋ kɛlɛŋ kɔkɔ jeti te yi kɛ misi mɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wɛ ta kelɔ nan yí lɛpɔ nɔ nyɛ mɔŋ nde: ‹Maŋmbɛ inja, nɛ́ mi wumbiɗye ɗyan soŋɛ kɛ misi mɔ› piŋɔ te yi kɔkɔ jeti ndi kɛ misi mɔ kɛ́? Wɛ, mɔ likisi, kanda soŋɛ kɔkɔ jeti te yi kɛ misi mɔ kɛ́, nɛ́ wɛ nje ɓɛŋ yasi nɛ ŋgɛlɛlɛ, nɛ́ wɛ nje soŋ mbulma ɗyan te yi kɛ misi mɛ mɔŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kɛto kimɔ jeti ti wúm ɓeya mɛmbumɔ na. Ɗete sendi, jeti te ɛ mɛ kɛ ɓeyɔ kɔ ti wúm kimɔ mɛmbumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wunɛ duwa̧ nde, ɓo dúkwɛ jeti hɛnɛ wulɛ kɛ mɛmbumɔ mɛnɛ. Ɓo ti nɔ́ku fumbi kɛ lɛlɔ na. Sendi, ɓo ti nɔ́ku fiya kɛ ndi̧ na. ");
INSERT INTO kkj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kimɔ mumɔ kél kimɔ mɛkele wulɛ kɛ kimɔ mɛyasi mɛte yi ɗiyɛ kɛ mɔy temɔ nɛ kɛ́. Ma ɓeya mumɔ kél ɓeya mɛkele wulɛ kɛ ɓeya mɛyasi mɛte yi ɗiyɛ kɛ mɔy temɔ nɛ kɛ́. Yo nde, mɛlɛpi hɛnɛ te yi mumɔ lɛpɛ kɛ́ wúla kɛ mɔy temɔ nɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ŋge kelɛ yi wunɛ jeɓa mi nde: ‹Nyaŋgwɛ Kumande, Nyaŋgwɛ Kumande,› kinɛ kelɔ yasi te yi mi lɛpɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi ta pa lɛpɔ nyɛ wunɛ kwalɔ mɔ te ɛ ɓeŋgwɛ mi, ɛ wokɛ mɛlɛpi mɛmbɛ kelɔ nda yi mi kwaɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mɔ te ɛ ɓeŋgwɛ mi, ɛ wokɛ mɛlɛpi mɛmbɛ kelɔ nda yi mi kwaɗyɛ kɔ kɛ ɓoŋna nɛ mɔ te ɛ summa tu̧ kɛ to mbatɔ, timɔ mɛkondu ɗimiyɛ. Kɛ mbeŋ ma ɗya̧, ɛ ɗuku ɗe mɛmiyɛ tu̧. Ɛ ŋguŋgul mɛnda nɛ dimbi kɛ tu̧, tu̧ kinɛ ndeŋsa na, kɛto a summa yo jeliyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yasi wɛtɛ, mɔ te ɛ wokɛ mɛlɛpi mɛmbɛ kinɛ kelɔ nda yi yo teɗye nyɛ kɛ́ kɛ ɓoŋna nɛ mɔ te ɛ summa tu̧ kɛ gbɛla mɛnɛti kinɛ timɔ mɛkondu ɗimiyɛ na. Kɛ mbeŋ ma ɗya̧, kɛ ɗuku ma ɗe, kɛ ŋguŋgul ma mɛnda nɛ dimbi kɛ tu̧, ɛ tu̧ te gbuŋgula ɓalɔ nɛ hugbak.» ");
INSERT INTO kkj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kɛ Yesus ma si lɛpɔ yasi te yi nyɛ kwaɗya lɛpɔ hɛnɛ kɛ́ nyɛ ɓomɔ, ɛ nyɛ yɔkwɛ kɛ̀ kɛ Kapɛrnawum. ");
INSERT INTO kkj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wɛtɛ nyaŋgwɛ kum ɓesɔja, mɔ Rom ɓa̧ nɛ wɛtɛ mɔ mɛsay wenɛ yi nyɛ ɗikima kwaɗyɛ ɓuɗyate kɔ. Mɔ mɛsay te ɓa̧ kɛ kɔnɔ. A ɓa̧ nɛdɔ nɛ sɔŋ. ");
INSERT INTO kkj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kɛ nyaŋgwɛ kum ɓesɔja kɔ ma wokɔ kasi Yesus kɛ́, ɛ nyɛ tomɛ ɓaŋa ɓetomba Ɓeyudɛn kɛnjɛ kɛ yenɛ nde, a njâki joŋgwɛ mɔ mɛsay wenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓo ka̧ kumɔ dolɔ Yesus, ɛ ɓo ŋgwɛta nɛ nyɛ ɓuɗyate lɛpɔ nde: «Yakama nde, kama mbam te, ");
INSERT INTO kkj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kɛto a kɛ kwaɗyɛ kandɔ ɗyusu. Sendi, yo nyɛ sumɛ mbanjɔ mɛwesiɗya musu.» ");
INSERT INTO kkj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɛ Yesus kwa̧ ɓenɛ ɓo. Kɛ nyɛ ma wuta nɛ tu̧ kɛ́, ɛ kum ɓesɔja tomɛ ɓesɔ ɓenɛ kɛ̀ saŋgwa nɛ nyɛ lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wɛ tî njaŋgwɛ yotu yɔ na, kɛto mi yeti mɔ te yi wɛ yakama nyiŋɛ kɛ tu̧ ɗyembɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yo ɗete yi mi ɓɛŋma nde, mi ti yaka wuta kɛ kɛki yɔ na. Ko ɓɛkɔ ɗete, ɓeta ndi gbɛla numbu kɛnjɛ, nɛ́ kɔn mɔ mɛsay wombɛ siy. ");
INSERT INTO kkj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kɛto ko mi, ɓaŋa ɓomɔ kɛ ɗiyɔ nɛ mi, ma mi kɛ ɗiyɔ sendi nɛ ɓesɔja. Mi yakama lɛpɔ nyɛ wɛtɛ sɔja nde: ‹Kɛn kaka,› ɔ ɓɛ́ŋa, a ka̧, lɛpɔ nyɛ mbaŋa nde: ‹Inja woŋga,› a má nje. Mi yakama lɛpɔ nyɛ mɔ mɛsay wombɛ nde: ‹Kelɔ yiri,› ɔ ɓɛ́ŋa, a kelma.» ");
INSERT INTO kkj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kɛ Yesus ma wokɔ mɛlɛpi mɛte yi nyaŋgwɛ kum ɓesɔja kɔ lɛpima kɛ́, ɛ nyɛ jayɛ nyɛ. Ɛ Yesus yeŋsa lɛpɔ nyɛ ŋgil ɓotu ɓete ɓe ɓa̧ kɛ ɓeŋgwɛ nyɛ ɓaka nde: «Mi kɛ lɛpɔ nyɛ wunɛ nde: Ko ɓɛkɔ kɛ kandɔ Isarayɛl, mi tì pa ɓɛŋɛ kwalɔ nyaŋgwɛ tikina temɔ te yikɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Komɛ ɓotu ɓe tomun yɔkwa̧ kɛ tu̧ kɛ́, ɓo dól nde, yotu mɔ mɛsay mɛ nɛ tɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kɛ kɔŋte, ɛ Yesus nje kwa̧ kɛ̀ kɛ wɛtɛ ɗya nde Nayin ɓenɛ ɓejekɛ ɓenɛ nɛ̀ nyaŋgwɛ ŋgil ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ wuta nɛ numɛy ndoko te yi linja ɗya kɛ́, ɛ nyɛ saŋgwa nɛ ɓomɔ kɛ soɓɛ muŋ kɛ̀ pumbɔ. Yo ɓa̧ kikɔ mɔnɔ mbam wɛtɛ kusɔ nyari. Ɓotu ɓe ɗya ɓuɗyate ka̧ njɔŋ wɛtɛ ɓenɛ ɓe kusɔ nya kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kɛ Kumande Yesus ma ɓɛŋɛ kusɔ nya kɔ kɛ́, ɛ nyɛ gwe ŋgwɛtɛ wenɛ lɛpɔ nyɛ nyɛ nde: «Wɛ tî lel na.» ");
INSERT INTO kkj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ɛ nyɛ jisɛ kɛ̀ mate kpokɛ taŋ te yi ɓo soɓɛ muŋ kɛte kɛ́. Ɛ ɓotu ɓe soɓuna muŋ tɛmɛ. Ɛ nyɛ lɛpɛ nde: «Gwanjɔ, mi kɛ lɛpɔ nyɛ wɛ nde: Tɛma.» ");
INSERT INTO kkj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ndana, ɛ muŋ tɛmɛ ɗiyɔ mɛtiɗyɛ kandɛ ndapi. Ɛ Yesus ɓu̧ nyɛ yɔkiɗye nyɛ nyaŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɛ ɓomɔ hɛnɛ gwe wɔ̧ lukse Njambiyɛ lɛpɔ nde: «Nyaŋgwɛ mɔ punja mɛlɛpi mɛ Njambiyɛ ɗyaŋma kɛ njoka su.» Sendi: «Njambiyɛ takima ɓomɔ ɓenɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɛ je yasi te yi Yesus kelma kɛ́ saŋgwa mɛnɛti mɛ Yuda nɛ pɔku mɛnɛti mɛte yite hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɓejekɛ ɓe Jaŋ yekiɗya sendi mɛyasi mɛte yinɔri hɛnɛ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ɛ nyɛ jeɓa yiɓa kɛ njoka yan tomɔ ɓo kɛnjɛ kɛ yi Kumande Yesus nde, ɓo dîya nyɛ nde: «Yo ka wɛ mɔ te ɛ ɓa̧ nde, a njâki kɔ, ho wusɛ lâɗya mbaŋa dɛlɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kɛ ɓotu ɓe tomun ma kɛ̀ dolɔ Yesus kɛ́, ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku tomɛ wusɛ njesɛ kɛ yɔ nde: ‹’Yo ka wɛ mɔ te ɛ yâkaŋgwɛ nje kɔ, ho wusɛ lâɗya mbaŋa dɛlɛ?› » ");
INSERT INTO kkj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kɛ kiya ŋgimɔ te Yesus ɓa̧ kɛ siɗyɛ mɛkɔn mɛ ɓuɗya ɓomɔ, ɓaka ɓe ɓa̧ nɛ mɛkɔsu nɛ̀ ɓe ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu. Ɓotu ɓete ɓe ɓa̧ nɛ ɗiɓina misi ɓaka, a kelma nde, ɓo ɓɛ̂ŋnaŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɛ nyɛ yeŋsa nyɛ ɓotu ɓete ɓe Jaŋ tomma ɓaka nde: «Wunɛ kɛ̂n kɛ̀ yekiɗye mɛyasi mɛte yi wunɛ ɓɛŋma nɛ̀ yi wunɛ wokuma kɛ́ nyɛ nyɛ. Wunɛ lɛ̂pi nyɛ nyɛ nde: Ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka mɛ kɛ ɓɛŋɛ yasi. Ɓotu ɓe ndɛmbil mɛ kɛ kɛndɔ nɛ ŋgbeŋ. Ɓaka ɓe nɛ ndoko ɓaka mɛ nɛ yotu nɛ kpɛlɛŋ. Wunɛ lɛ̂pi sendi nyɛ nyɛ nde: Ɓotu ɓete ɓe ɓa̧ nɛ ɗiɓina mɛtɔ ɓaka mɛ kɛ wokɔ yasi. Ɓemuŋ kɛ womiyɛ. Ɓo kɛ lɛpɔ Kimɔ Tom nyɛ buka ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɛ Yesus nje lɛpɔ nde: «Mɔ te ɛ ta ɗiyɔ kinɛ jɔsiɗye kelɔ yiŋa ɓeya yasi kɛto mbɛ kɔ nɛ mɛsosa.» ");
INSERT INTO kkj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kɛ ɓotu ɓete ɓe Jaŋ tomma ɓaka ma si kwa̧ kɛ́, ɛ Yesus kandɛ lɛpi kɛ kasi Jaŋ nyɛ ŋgil ɓomɔ. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kɛ yi wunɛ ka̧ kɛ koŋgor kɛ́, wunɛ kwaɗya kɛ̀ ɓɛŋɛ yasi te nda? ’Wunɛ kwaɗya kɛ̀ ɓɛŋɛ njoy te yi pupɔ wumbiɗye kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","’Wunɛ ka̧ gbate kɛ̀ ɓɛŋɛ ŋge? ’Wunɛ ka̧ kɛ̀ ɓɛŋɛ mbaŋa mumɔ nɛ kpasa mɛlambɔ kɛ yotu? Ɓotu ɓete ɓe lɛŋɛ kpasa mɛlambɔ nɛ̀ ɓe joŋna kɛ nyɛm nyɛm joŋgwɛ ɓaka ɗíy kɛ tu̧ ɓekumande. ");
INSERT INTO kkj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","’Wunɛ ka̧ kɛ̀ ɓɛŋɛ ŋge? ’Wunɛ ka̧ kɛ̀ ɓɛŋɛ mɔ punja mɛlɛpi mɛ Njambiyɛ? I̧, mi kɛ lɛpɔ nyɛ wunɛ nde: Nyɛ mɔ punja mɛlɛpi mɛ Njambiyɛ gbate gbate, ma yasi wɛtɛ, a kwaŋma yite. ");
INSERT INTO kkj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yo nyɛ yi kasi nɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Ɓɛŋa, mi kɛ kandɛ tomɔ mɔ tomun wombɛ nɛ wɛ, na kɛ̀ kandi kombile nje tikɛ wɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mi kɛ lɛpɔ nyɛ wunɛ nde: Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ɛ jaɗya wulɛ kɛ mɔy nyari kwaŋma Jaŋ na. Ko ɗete, njena mumɔ kɛ *Kandɔ Njambiyɛ kwa̧ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓete ɓe ɗikima wokɔ yasi te yi Jaŋ ɗikima lɛpɔ kɛ́ téɗya nde, Njambiyɛ nɛ ŋgbeŋ. Ɛ ɓo jayɛ nde, a tɔ̂pa ɓo kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yasi wɛtɛ, *Ɓefarisɛ̧ nɛ̀ nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga sɛŋma nde, Jaŋ tî tɔpa ɓo kɛ mɔrɔku na. Ɗete, ɓo téɗya yan nde, yasi te yi Njambiyɛ kombila kɛ yan kɛ́ ɓa̧ gbɛlate. ");
INSERT INTO kkj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Mi ta yekɔ ɓa ɓotu ɓe ŋgimɔ te yɔkɔ nɛ ɓe nda? Ɓo nda ɓe nda? ");
INSERT INTO kkj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓo nda ɓɔnɔsikɛ te ɓe ɗiyɛ kɛ babal, ɓaka má lɛpɔ kɛnjɛ ɓɛsɔ nde: ‹Wusɛ tɔŋma mbule nyɛ wunɛ, wunɛ kinɛ ɓɔlɔ na. Wusɛ jembima mɛjembi mɛ sɔŋ nyɛ wunɛ, wunɛ kinɛ lelɔ na.› ");
INSERT INTO kkj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ɗete sendi, Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku nja̧. Mɛɗye, a ti ɗyáki. Mɛnjam, a ti hɔ́ɓiya. Kɛ kɔŋte, wunɛ nde: ‹A nɛ ɓeya sisiŋ kɛ yotu.› ");
INSERT INTO kkj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ndana *Mɔnɔ mumɔ nja̧. Mɛɗye, a kɛ ɗye. Mɛnjam, a kɛ hɔɓiye. Kɛ kɔŋte, wunɛ nde: ‹Nɛ ɓɛ̂ŋa ndi nyaŋgwɛ mɔ mɛɗye nɛ̀ nyaŋgwɛ mɔ ɗyena mɛnjam te yɔkɔ, sɔ nɛ ɓotu ɓe ɓoŋna mɔni garama nɛ̀ ɓotu ɓe ɓeya joŋgwɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ɓomɔ hɛnɛ ɓe ɓeŋgwɛ yasi te yi Njambiyɛ kwaɗyɛ ɓaka kɛ jayɛ nde: Ɗyanɔ ɗyenɛ nɛ ŋgbeŋ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wɛtɛ mɔ *Farisɛ̧ jeɓama Yesus nde, a kɛ̂n ɗyena kɛ tu̧ ɗyenɛ. Ɛ nyɛ kɛ̀ kɛ tu̧ mɔ Farisɛ̧ te kɛ̀ ɗiyɔ, na ɗyena. ");
INSERT INTO kkj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wɛtɛ nya mɛɓeyɔ ɓa̧ kɛ ɗya te. Ŋgɛ nyɛ ma wokɔ nde, Yesus ka̧ ɗyena kɛ tu̧ mɔ Farisɛ̧ kɛ́, ɛ nyɛ ɓu̧ wɛtɛ kpasa ndaki nɛ lɔbinda kɛ mɔyte ");
INSERT INTO kkj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","kɛ̀ ɗiyɔ kɛ kɔŋ Yesus yaka nɛ mɛkol mɛnɛ. Nya kɔ ɓa̧ kɛ lelɔ. Ɛ misiɗyɛ ɗiki ɓalɔ kɛ mɛkol mɛ Yesus, ɛ nya kɔ ɗiki titɔ yo nɛ nyiŋɔ to nɛ. A ɗikima dulɔ sendi mɛkol mɛ Yesus lɔmbɛ lɔbinda yinɔri kɛte. ");
INSERT INTO kkj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kɛ mɔ Farisɛ̧ te ɛ jeɓama Yesus kɔ ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ lɛpɛ kɛ mɔy temɔ nɛ nde: ‹Mbam kɔ má ɓɛki gbate mɔ punja mɛlɛpi mɛ Njambiyɛ, ma nyɛ kɛ duwɛ nya te ɛ kɛ kpokɛ nyɛ kɔ, ma nyɛ kɛ duwɛ joŋgwɛ nya te, duwɛ nde, nyɛ mɔ mɛɓeyɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ndana, ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Simɔn, mi kɛ kwaɗyɛ lɛpɔ yiŋa yasi nyɛ wɛ.» Ɛ nyɛ yeŋsa nde: «Yekele, lɛpɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ɛ Yesus lɛpɛ nde: «Wɛtɛ mumɔ nya ɓomɔ yiɓa pilo. Wɛtɛ ɓoŋma mil gɔmay yitan. Ɛ wɛtɛ ɓu̧ nɛ mil kamɔtan. ");
INSERT INTO kkj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nda ɓo hɛnɛ yiɓa tì ɓɛ nɛ ɗeti te yi gbo mɔni te nyɛ sa te na, ɛ nyɛ tikɛ ɓo hɛnɛ yiɓa nɛ ŋgwɛtɛ nde, ɓo tî gboku se na. Kɛ njoka ɓotu ɓaka yiɓa, yo yɛn ɛ yâkaŋgwɛ kwaɗyɛ mbam kɔ kwa̧ to te kɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ɛ Simɔn yeŋsa nde: «Mi táka nde, yo yɔkɔ ɛ ɓa̧ nɛ nyaŋgwɛ pilo kɔ.» Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ pɛsima kimɔte.» ");
INSERT INTO kkj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɛ Yesus nje yeŋsa ɓɛŋɛ pulɔ nyari lɛpɔ nyɛ Simɔn nde: «’Wɛ kɛ ɓɛŋɛ nya kɔ? Mi nyiŋma tu̧ ɗyɔ, wɛ tì nyɛ mi mɔrɔku nde, mi wêya nɛ mɛkol mɛmbɛ na. Yasi wɛtɛ, ndi nyɛ ma ɓɔsɛ mɛkol mɛmbɛ nɛ misiɗyɛ mɛnɛ titɔ yo nɛ nyiŋɔ to nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wɛ tì dulɛ numbu mbɛ na, ndi nyɛ, kandɛ yi mi ma nyíŋa nɛ tu̧ ɗyɔ muka, a yeti kɛ wɛɗya dulna mɛkol mɛmbɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wɛ tì lɔmbɛ lɔbinda kɛ to mbɛ na, ndi nyɛ lɔmbuma kimɔ lɔbinda kɛ mɛkol mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɗete, mi kɛ lɛpɔ nyɛ wɛ nde: Ɓuɗya mɛɓeyɔ mɛte yi nyɛ kelma kɛ́ ma ɗuwɛ kɛ to nɛ nɛ ŋgwɛtɛ, kɛto a kwaɗya mi ɓuɗyate. Mɔ te yi ɓo tikɛ nyɛ nɛ ŋgwɛtɛ nɛ mbɛt, a téɗya sendi mɛkwaɗya nɛ mbɛt.» ");
INSERT INTO kkj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɛ Yesus nje lɛpɔ nyɛ nya kɔ nde: «Mɛɓeyɔ mɔ ma ɗuwɛ kɛ to yɔ nɛ ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɛ ɓotu ɓete ɓe ɓa̧ kɛ ɗyena ɓenɛ ɓe Yesus ɓaka lɛpɛ kɛ mɔy mɛtemɔ man nde: ‹Yɔkɔ nda ɛ soŋɛ mɛɓeyɔ kɛ to mumɔ nɛ ŋgwɛtɛ kɔ?› ");
INSERT INTO kkj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ɛ Yesus lɛpɛ nyɛ nyari nde: «Tikina temɔ te yi wɛ tikɛ kɛ yembɛ kɛ́ joŋgwa wɛ, kwaŋgɔ nɛ tɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kɛ kɔŋte, ɛ Yesus kɛ̀ mɛɗya mɛɗya, kɛ̀ nyaŋgwɛ mɛɗya nɛ̀ kɛ mɔnɔ mɛɗya yí pelɛ Kimɔ Tom teɗye ɓomɔ mɛyasi kɛ kasi *Kandɔ Njambiyɛ. A ɓa̧ ɓenɛ ɓejekɛ ɓenɛ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ɓaŋa ɓoma ɓe nyɛ soŋma ɓeya mɛsisiŋ kɛ yotu yan siɗyɛ mɛkɔn man ɓaka ɓa̧ sendi ɓenɛ ɓo. Yo ɓa̧ Mariya te yi ɓo ɗikima jeɓa sendi nde Madalɛna kɔ. Yo nyɛ yi Yesus soŋma ɓeya mɛsisiŋ yitan jɔ yiɓa kɛ yotu nɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yo ɓa̧ sendi nɛ Yuwana te nya Kusa, mɔ te ɛ ɗikima ɓakiɗye tu̧ kumande Herod kɔ, ɓu̧ Sosana nje ɓu̧ sendi ɓaŋa ɓoma ɓuɗyate. Ɓo hɛnɛ ɗikima ɓu̧ mɛyasi mɛte yi ɓo ɓa̧ nɔ kɛ́ nje kamɛ nɛ Yesus ɓenɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓomɔ wulma kɛ mɛɗya hɛnɛ nje kɛ yi Yesus. Kɛ ɓo ma si wesiɗya ɗete kɛ kɛki nɛ kɛ́, ɛ nyɛ yekiɗye wɛtɛ kanɔ nyɛ ɓo lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Wɛtɛ mɔ ɓɛna mbɛki kwaŋma kɛ̀ ŋgwaŋ yí kɛ̀ nyanje kwalɔ. Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ nyanje kwalɔ kɛ́, ɛ yiŋa ɓalɛ kɛ nje. Ɛ ɓomɔ kwa̧ natɛ yo. Ɛ ɓenɔn si ɗye yo. ");
INSERT INTO kkj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yiŋa kwalɔ ɓalma kɛ to mbatɔ. Kɛ yo ma diy lo kɛ́, ɛ yo si sɔsɔ, kɛto mɔrɔku tì ɓɛ kɛ nji̧ na. ");
INSERT INTO kkj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yiŋa ɓalma kɛ mbɛy te yi ɓa̧ nɛ mɛŋgombiya kɛte kɛ́. Ɛ kwalɔ te ju̧ saŋgwɛ nɛ mɛŋgombiya. Ɛ mɛŋgombiya si ŋgaŋgile yo. ");
INSERT INTO kkj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yiŋa kwalɔ ɓalma kɛ kimɔ mɛnɛti. Ɛ yite ju̧ ɗɔkɔ wumɔ mɛmbumɔ, kwalɔ te wɛtɛ nya mɛmbumɔ gɔmay.» Kɛ Yesus ma si lɛpɔ ɗete kɛ́, ɛ nyɛ nje lɛpɔ nɛ mɛn kɛ kwey nde: «Mɔ te ɛ nɛ mɛtɔ yí wokɔ pɛ̧, a wôku.» ");
INSERT INTO kkj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɛ ɓejekɛ ɓenɛ diyɛ nyɛ to kanɔ te. ");
INSERT INTO kkj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ɛ nyɛ yeŋsa nde: «Njambiyɛ nya wunɛ ɗeti te yi duwɛ mɛyasi mɛte yi ɓa̧ sɔɗyate yi ɓɛŋɛ *Kandɔ ɗyenɛ kɛ́. Kɛ yi ɓaŋa, ɓo lɛ́pi yo nyɛ ɓo nɛ mɛkanɔ, nɛ́ ɓo ɓɛŋ yasi seŋgile kinɛ duwɛ yasi te yi ɓo ɓɛŋɛ kɛ́ na, nɛ́ ɓo lɛŋgwɛ mɛtɔ kɛ yasi kinɛ ɓiye to te na. ");
INSERT INTO kkj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ma to kanɔ te ɗekɛ: Kwalɔ te yi ɓo lɛpɛ nɔ kɛ́, yo mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kwalɔ te yi ɓalma kɛ nje kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ. Kɛ kɔŋte, *Kum ɓeya mɛkele má nje soŋɛ mɛlɛpi mɛte kɛ mɔy mɛtemɔ man, ma ɓo mɛ nje tikɔ temɔ kɛ yi Njambiyɛ, ɓɛ nɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kwalɔ te yi ɓalma kɛ mbatɔ kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ jayɛ yo nɛ mɛsosa. Yasi wɛtɛ, ɓo tì pa lo mɛgata na, ɗeti sumna kol kikwɛ yeti na. Ŋgɛ mɛɓoɓilan ɗya̧ ɓo kɛ́, ɓo tumma kɔŋ yɔkwɛ nɛ kɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kwalɔ te yi ɓalma kɛ mbɛy te yi nɛ mɛŋgombiya kɛ́ téɗya ɓotu ɓete ɓe wokɛ mɛlɛpi mɛ Njambiyɛ jayɛ yo. Yí kɛ̀ mbɔmbu, kɛsa temɔ kɛ mɛyasi nɛ̀ kasi kusuku nɛ̀ kasi nyɛm nyɛm joŋgwɛ má si ŋgaŋgile ɓo. Ɔ ɓɛ́ŋa, mɛkele mɛte yi ɓo kelɛ kɛ́ ti tóndu na. ");
INSERT INTO kkj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kwalɔ te yi ɓalma kɛ kimɔ mɛnɛti kɛ́ téɗya ɓotu ɓete ɓe nɛ pupuna temɔ nɛ̀ kimɔ temɔ ɓe wokɛ mɛlɛpi mɛ Njambiyɛ ɓakiɗye yo, ɓɛ nɛ tiŋ yí kelɔ kimɔ mɛkele. ");
INSERT INTO kkj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Mumɔ ti kwénja lambo nje ɓu̧ mbe ɓusɛ nɔ, ho ɓu̧ tikɔ kɛ nji̧ taŋ na. A ɓóŋ tikɔ kɛ to teɓel, nɛ́ ɓotu ɓete ɓe nyiŋɛ tu̧ ɓaka ɓɛŋ mɛjasi mɛte. ");
INSERT INTO kkj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ɗete, kinɛ yaŋa yi ɗiyɛ sɔɗyate ta ɗiyɔ kinɛ pundɔ puyɛ na. Sendi, kinɛ yaŋa yi ɗiyɛ sɔɗyate ta ɗiyɔ kinɛ pundɔ puyɛ, ɓomɔ má duwɛ yo na. ");
INSERT INTO kkj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɗete, wunɛ ɗîy nɛ sɔsɔ ɓuɗyate kɛ wokuna yasi te yi wunɛ wokɛ kɛ́, kɛto ɓo ta dokiɗye yiŋa yasi nyɛ mɔ te ɛ nɔ kɔ. Yɔkɔ ɛ kinɛ yaŋa kɔ, ɓo ta soŋɛ mɔnɔ yasi te yi nyɛ takɛ nde, a nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyaŋgwɛ nɛ Yesus nɛ̀ ɓemaŋ nja̧, nɛ́ ɓo ɓɛŋ nyɛ. Yasi wɛtɛ, ɓo tì ɓɛ nɛ nje te yi kumɔ kɛ kɛki nɛ na kɛto ŋgil ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɛ ɓomɔ kɛ̀ lɛpɔ nyɛ nyɛ nde: «Nyɔŋgwɛ ɓenɛ ɓemɔŋ kɛ sɛ̧, ɓo kɛ kwaɗyɛ ɓɛŋɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yasi wɛtɛ, ɛ Yesus yeŋsa nde: «Nyaŋmbɛ nɛ̀ ɓemaŋ ɓembɛ, yo ɓaka ɓe wokɛ mɛlɛpi mɛ Njambiyɛ kelɔ nda yi yo teɗye ɓo kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wɛtɛ yesɔ ɛ Yesus ɓendɛ landi ɓenɛ ɓejekɛ ɓenɛ. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wusɛ sâɓikwɛ nyaŋgwɛ matɔ kɛ̀ ŋginjɛ te yɔru.» Ɛ ɓo tɛmɛ kwa̧. ");
INSERT INTO kkj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ saɓiyɛ nyaŋgwɛ matɔ kɛ́, ɛ Yesus kwa̧ nɛ jakɔ. Ndana, ɛ wɛtɛ mbuku yifila kɛ to nyaŋgwɛ matɔ, ɛ landi kandɛ ɗyena mɔrɔku. Ɓo mɛ kɛ ɓeya ɗiyɔ. ");
INSERT INTO kkj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɛ ɓejekɛ kɛ̀ kɛ kɛki nɛ jemɛ nyɛ lɛpɔ nde: «Yekele, yekele, wusɛ ta girɔ ndana!» Ɛ nyɛ jemiyɛ ɓama nɛ mbuku nɛ̀ mɛkumbɔ. Ɛ yo hɛnɛ si wɛyɛ, ɛ yasi nje ɓɛ nɛ tɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɛ Yesus nje diyɛ ɓo nde: «Tikina temɔ te yi wunɛ nɔ kɛ́ ɓa we?» Ɛ ɓo gwe wɔ̧ ŋgbakima diyna tandɛ yan nde: «Yɔkɔ ɓa̧ kwalɔ mɔ te nda yi gba pupɔ nɛ̀ mɔrɔku wokuna nɛ nyɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ndana, ɛ ɓo ŋgbɔsɛ landi kɛ mɛnɛti mɛ ɓotu ɓe Gerasa yaka nɛ mɛnɛti mɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kɛ Yesus ma ɓendɔ ŋgindi kɛ́, ɛ wɛtɛ mbam wulɛ ɗya nje saŋgwa nɛ nyɛ. Mbam te ɓa̧ nɛ ɓeya mɛsisiŋ kɛ yotu. A ɗikima ɗiyɔ sɔkɛrɛ njombu yaŋa. Sendi, a tì ɓɛ kɛ ya kɛ tu̧ na. A ɗikima joŋna kɛ mɛŋguku komɛ ɓo ɗikima pumbɔ ɓemuŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kɛ nyɛ ma ɓɛŋɛ Yesus kɛ́, ɛ nyɛ kembiɗya ɗetinate ɓalɔ kɛ nji̧ mɛkol mɛnɛ lɛpɔ nɛ mɛn kɛ kwey nde: «Yesus, Mɔnɔ Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey, sinɛ wɛ nɛ lɛpi te nda? Mi kɛ ŋgwɛta nɛ wɛ nde, wɛ tî pɔnsa mi na.» ");
INSERT INTO kkj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A lɛ́pi ɗete, kɛto Yesus lɛpima nyɛ ɓeya sisiŋ nde, a pûndu ɗuwɛ kɛ yotu nɛ. Ɓeya sisiŋ te ɓa̧ kɛ njaŋgwɛ nyɛ njombu yaŋa. Ɓo ɗikima ɓakiɗye nyɛ wotunate nɛ mɛkɔl mɛ sumba, nyɛ mɛpoka kɛ mɛkol mɛnɛ. Ko ɗete, a ɗikima pamɔ mɛyasi mɛnɔri hɛnɛ, ɓeya sisiŋ má yembile nyɛ kɛnjɛ kɛ mɛkoŋgor. ");
INSERT INTO kkj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ndana, ɛ Yesus diyɛ nyɛ nde: «Ɗinɔ ɗyɔ nde nda?» Ɛ nyɛ yeŋsa nde: «Ɗinɔ ɗyembɛ nde Nyaŋgwɛ ŋgil.» A lɛ́pi ɗete, kɛto ɓeya mɛsisiŋ ɓuɗyate nyiŋma kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɛ ɓeya mɛsisiŋ ŋgwɛta nɛ Yesus nde, a tî kɛnjikwɛ ɓo kɛ gboŋgo mɛndoŋ na. ");
INSERT INTO kkj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɓeaɓem ɓa̧ womɛte nɛ nyaŋgwɛ kuru te kɛ ɗyena kɛ keki. Ɛ ɓeya mɛsisiŋ ŋgwɛta nɛ nyɛ nde, a tîki, nɛ́ ɓo kɛ̀ nyiŋ kɛ yotu ɓeaɓem. Ɛ Yesus jayɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɛ ɓeya mɛsisiŋ pundɛ kɛ yotu mbam kɔ kɛ̀ nyiŋɛ kɛ yotu ɓeaɓem. Ɛ kuru ɓeaɓem siliyɛ kombɔ nɛ ɓeya sokɔ nɛ bibibi kɛ̀ gwaɗya kɛ nyaŋgwɛ matɔ ɓeɓiye mɔrɔku si gwe. ");
INSERT INTO kkj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kɛ ɓotu ɓete ɓe ɗikima ɓakiɗye ɓeaɓem ɓaka ma ɓɛŋɛ yasi te yi kwaŋnama kɛ́, ɛ ɓo sɛɗyɛ kambɔ kwa̧ kɛ̀ yekiɗye kasi te kɛ ɗya nɛ̀ kɛ mɛlunde. ");
INSERT INTO kkj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɛ ɓomɔ kɛ̀ kɛ ɓɛŋɛ yasi te yi kwaŋnama kɛ́. Ɓo ka̧ kumɔ kɛ kɛki Yesus dolɔ mbam te yi ɓeya mɛsisiŋ punduma kɛ yotu nɛ kɔ kɛ ɗiyɔ nɛ tɛ nɛ mɛlambɔ kɛ yotu kɛ kɛki Yesus. Ɛ ɓo gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɛ ɓotu ɓete ɓe ɗiyma kɛ mbɛy te ɓaka yekiɗye nyɛ ɓari nda yi nyɛ soŋma nɛ ɓeya mɛsisiŋ kɛ yotu mbam te kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kɛ ɓo ma si yekiɗye ɗete kɛ́, ɛ ɓotu ɓe mɛnɛti mɛ Gerasa nɛ̀ ɓotu ɓe pɔku mɛnɛti mɛte yite hɛnɛ lɛpɛ nyɛ Yesus nde, a kwâŋ lɔndɔ kɛ mɛnɛti man, kɛto ɓo gwa̧ wɔ̧ ɓuɗyate. Ɛ Yesus nje ɓendɔ landi, na ɗuwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɛ mbam te yi ɓeya mɛsisiŋ ɗuwa̧ kɛ yotu nɛ kɔ ŋgwɛta nɛ Yesus nde, a tîki, nɛ́ ɓenɛ nyɛ kwa̧. Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ɗukwɛ kɛ tu̧ ɗyɔ kɛ̀ yekiɗye mɛyasi hɛnɛ te yi Njambiyɛ kelma nɛ wɛ kɛ́.» Ɛ nyɛ kwa̧ kɛ̀ pelɛ mɛyasi hɛnɛ te yi Yesus kelma nɛ nyɛ kɛ́ nyɛ ɓomɔ hɛnɛ kɛ mɔy ɗya. ");
INSERT INTO kkj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kɛ Yesus ma yɔkwɛ kɛ́, ɛ ŋgil ɓomɔ nje sosa nyɛ, kɛto ɓomɔ hɛnɛ ɓa̧ kɛ laɗye nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɛ wɛtɛ mbam nde Yayrus ɗya̧. A ɓa̧ kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Ɛ nyɛ nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus ŋgwɛta nɛ nyɛ nde, a kɛ̂n kɛ tu̧ ɗyenɛ, ");
INSERT INTO kkj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kɛto mɔnɔ wenɛ ɛ nyari ɓa̧ kɛ sɛkɛ. Mɔnɔ te ɓa̧ kikɔ, a mɛ kɛ mɛsew kamɔ jɔ yiɓa. Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ kɛ̀ kɛ́, ɓomɔ ɓa̧ nɛ suk suk linje nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ase nde, kɛ njoka ɓotu ɓenɔri, wɛtɛ nyari ɓa̧ kɛ kɔnɔ. Mɛkiyɔ ɓa̧ kɛ lekwɛ nyɛ mɛ kɛ mɛsew kamɔ jɔ yiɓa. Mɛyasi hɛnɛ te yi ɓa̧ nde, a jôŋnaŋgwɛ nɔ kɛ́ siyma kɛ mɛɓɔ mɛ ɓotu ɓe nyɛti. Ko mɔ nyɛti wɛtɛ wɛtɛ tì siɗyɛ kɔn nɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɛ nyari nje kwa̧ pulɔ kɔŋ Yesus kpokɛ numbu lambɔ nɛ. Ɛ kɔn mɛkiyɔ pɛsiyɛ ndi kɛ kiya mbɛy. ");
INSERT INTO kkj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɛ Yesus diyɛ nde: «Yo nda kpokɛ mi?» Nda ɓomɔ hɛnɛ ɓa̧ kɛ sɛŋɛ kɛ́, ɛ Piyɛr ɓenɛ ɓenjɔŋ ɓenɛ lɛpɛ nde: «Yekele, ɓomɔ nɛ suk suk linje wɛ, kɛ kɔŋte, wɛ kɛ nje lɛpɔ nde: ‹Yo nda kpokɛ mi?› » ");
INSERT INTO kkj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɛ Yesus yeŋsa nde: «Wɛtɛ mumɔ kpokuma mi, kɛto mi wokuma nda yi yiŋa ɗeti mbɛ ɗuwa̧ nɔ kɛ yotu mbɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kɛ nyari ma ɓɛŋɛ nde, a ti yaka sɔma se kɛ́, ɛ nyɛ nje nɛ mɛŋgwaŋgwa nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus lɛpɔ to te yi nyɛ kpokuma nɛ nyɛ kɛ́ kɛ misi mɛ ɓomɔ hɛnɛ. A yekiɗya nda yi kɔn siyma nɔ kɛ yotu nɛ ndi kɛ kiya mbɛy kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Mɔnmbɛ, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ, kwaŋgɔ nɛ tɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A ɓa̧ ndi kɛ lɛpɔ ɗete, yaka nɛ mumɔ kɛ wulɛ kɛ tu̧ Yayrus te kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn nje lɛpɔ nyɛ nyɛ nde: «Wɛ tî njaŋgwɛ se yekele na, mɔnɔ wɔ ma gwe.» ");
INSERT INTO kkj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kɛ Yesus ma wokɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ Yayrus nde: «Wɛ tî gwaki kaŋ yaŋa na, tikɔ ndi yɔ temɔ nɛ mi, ɗete mɔnɔ wɔ ta ju̧.» ");
INSERT INTO kkj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kɛ Yesus ma ɗya̧ kɛ tu̧ kɛ́, a tì jayɛ nde, ɓenɛ wɛtɛ mumɔ nyîŋa na, ndi Piyɛr nɛ̀ Jaŋ nɛ̀ Jak ɓu̧ saŋgwɛ nɛ mɔnɔ ɓenɛ nyaŋgwɛ nɛ mɔnɔ. ");
INSERT INTO kkj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓomɔ hɛnɛ ɓa̧ kɛ lelɔ jaɓa kɛto mɔnɔsikɛ. Ɛ Yesus lɛpɛ nde: «Wunɛ tî lel na, kɛto a tì gwe na, a kɛ jakɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɛ ɓo nyɛtɛ nyɛ, kɛto ɓo duwa̧ gbate nde, mɔnɔsikɛ ma gwe. ");
INSERT INTO kkj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yasi wɛtɛ, ɛ Yesus ɓiye mɔnɔsikɛ kɛ ɓɔ lɛpɔ nɛ mɛn kɛ kwey nde: «Mɔnɔ ŋgɔndu, tɛma.» ");
INSERT INTO kkj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɛ sisiŋ nɛ yɔkwɛ, ɛ nyɛ tɛmɛ nɛ ŋgɛt. Ɛ Yesus lɛpɛ nde: «Wunɛ nyɛ̂ki nyɛ mɛɗye.» ");
INSERT INTO kkj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Saŋgwɛ nɛ mɔnɔ ɓenɛ nyaŋgwɛ ŋgbakimama ɓuɗyate. Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ tî yekiɗya mɛyasi mɛte yi kwaŋnama kɛ́ nyɛ wɛtɛ mumɔ na.» ");
INSERT INTO kkj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wɛtɛ yesɔ ɛ Yesus wesiɗye ɓejekɛ ɓenɛ kamɔ jɔ yiɓa, nyɛ ɓo ɗeti te yi soŋɛ ɓeya mɛsisiŋ hɛnɛ kɛ yotu ɓomɔ nɛ̀ ɗeti te yi siɗyɛ mɛkɔn. ");
INSERT INTO kkj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kɛ kɔŋte, ɛ nyɛ tomɛ ɓo kɛ̀ pelɛ kasi *Kandɔ Njambiyɛ, siɗyɛ sendi mɛkɔn mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ tî ɓiya yaŋa kɛ ɓɔ kɛndɔ nɔ na, ko toŋgolo ko koɓiyɛ ko mampa ko mɔni. Sendi, mumɔ tî ɓoŋ lambɔ yiɓa na. ");
INSERT INTO kkj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tu̧ te yi wunɛ ta nyiŋɛ ya te, wunɛ ɗîy ndi womɛte kumɔ kɛ ŋgimɔ te yi wunɛ ta kwa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŋgɛ ɓomɔ ti ɓu̧ wunɛ kimɔte na, nɛ̀ wunɛ pûndu ɗuwɛ kɛ ɗya te, nɛ̀ wunɛ kûtu ŋgbutu kɛ mɛkol mun yí teɗye ɓo nde, ɓo kelma ɓeyate.» ");
INSERT INTO kkj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɛ ɓo tɛmɛ kwa̧ kɛ̀ mɛɗya mɛɗya lɛpɔ Kimɔ Tom, siɗyɛ mɛkɔn mɛ ɓomɔ kɛ mɛmbɛy hɛnɛ komɛ ɓo ka̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kumande Herod wokuma mɛyasi hɛnɛ te yi ɓa̧ kɛ kelna kɛ́. Temɔ nɛ ɓa̧ kɛ ɗukuma, kɛto ɓaŋa ɓomɔ ɗikima lɛpɔ nde: «Jaŋ te ɛ ɗikima tɔpɛ ɓomɔ kɛ mɔrɔku kɔ womiya.» ");
INSERT INTO kkj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɓaŋa nde: «Yo Eli yɔkwɛ sendi nje kɛ mɛnɛti.» Ɓaŋa nde: «Yo wɛtɛ njombu mɔ punja mɛlɛpi mɛ Njambiyɛ womiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ɛ kumande Herod lɛpɛ nde: «Mi ma pɛsɔ ŋgiŋ Jaŋ, yɔkɔ ɓa nda yi mi wokɛ kasi nɛ ɗekɛ kɔ?» Ɛ nyɛ sa̧ nje te yi ɓɛŋɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kɛ ɓotu ɓe tomun ma yɔkwɛ kɛ́, ɛ ɓo yekiɗye mɛyasi hɛnɛ te yi ɓo kelma kɛ́ nyɛ Yesus. Ɛ nyɛ ɓu̧ ɓo ɓepɔ jisɛ nɔ kɛ̀ kɛ pulɔ wɛtɛ ɗya nde Betsayda. ");
INSERT INTO kkj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko ɗete, ɓomɔ ɓuɗyate duwa̧ yasi te yi kwaŋnama kɛ́, ɛ ɓo ɓeŋgwɛ nyɛ. Ɛ nyɛ ɓu̧ ɓo nɛ mɛsosa. Ɛ nyɛ lɛpɛ kasi *Kandɔ Njambiyɛ nyɛ ɓo. A siɗya sendi mɛkɔn mɛ ɓotu ɓete ɓe nja̧ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nda yesɔ ɓa̧ kɛ ɗuwɛ kɛ́, ɛ ɓejekɛ kamɔ jɔ yiɓa kɛ̀ kɛ kɛki nyɛ lɛpɔ nyɛ nyɛ nde: «Tikɔ ɓomɔ, nɛ́ ɓo kwa̧ kɛ̀ kɛ mɛɗya nɛ̀ kɛ mɛlunde mɛte yi kɛ pɔku te yi waka nɛdɔ kɛ́ kɛ̀ sa̧ mbɛy jakɔ nɛ̀ mɛɗye, kɛto wusɛ waka kɛ koŋgor.» ");
INSERT INTO kkj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun, wunɛ nyɛ̂ki ɓo mɛɗye.» Ɛ ɓo yeŋsa nde: «Wusɛ ndi nɛ mampa yitan nɛ̀ ɓenjanjɔ yiɓa. Wusɛ yakama nyɛ ɓo mɛɗye, ŋgɛ ɓɛ nde, wusɛ nɛ ŋguru te yi ɓɔmɔ mɛɗye yi yaka ŋgil te yikɛ hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɓembam nɛ ɓembam kumma nda tomay yitan. Ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wunɛ lɛ̂pi nyɛ ɓo nde, ɓo ɗîy nɛ mɛnjɔŋ, njɔŋ wɛtɛ ɓomɔ kamɔtan.» ");
INSERT INTO kkj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɛ ɓejekɛ kelɛ ɗete si ɗiɗyɛ ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ndana, ɛ Yesus ɓu̧ mampa yinɔri yitan nɛ̀ ɓenjanjɔ yiɓa kaŋɛ misi kɛnjɛ kwey nyɛ Njambiyɛ wosoko. Kɛ kɔŋte, ɛ nyɛ nje lekɛ yo nyɛ ɓejekɛ, nɛ́ ɓo kɛ̀ kaɓi nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓomɔ hɛnɛ ɗyenama ditɔ. Ɛ ɓo nje wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wɛtɛ yesɔ Yesus ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ wɛtɛ mbɛy. Ɓejekɛ ɓenɛ ɓa̧ womɛte. Ɛ nyɛ diyɛ ɓo nde: «Ɓomɔ lɛ́pi nde, mi nda?» ");
INSERT INTO kkj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɛ ɓo yeŋsa nde: «Ɓaŋa lɛ́pi nde, wɛ Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. Ɓaŋa nde, wɛ Eli. Ɓaŋa sendi nde, wɛ wɛtɛ njombu mɔ punja mɛlɛpi mɛ Njambiyɛ ɛ gwa̧ nje womiyɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ɛ Yesus diyɛ ɓo nde: «Kɛ yun nɛ ŋguru wun, wunɛ lɛ́pi nde, mi nda?» Ɛ Piyɛr yeŋsa nde: «Wɛ *Krist, mɔ te ɛ joŋgwɛ ɓomɔ ɛ Njambiyɛ njesa kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ɛ Yesus lɛpɛ nyɛ ɓo nde, kpɛ, ɓo tî lɛpi ɗete nyɛ wɛtɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nde: «Yo gba nde, *Mɔnɔ mumɔ yâkaŋgwɛ saŋgwa nɛ mɛbɔnɛ ɓuɗyate. Ɓetomba ɓe ɗya nɛ̀ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ta sɛŋɛ nyɛ kutuɗya. Ɓo ta wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ ɓo hɛnɛ nde: «Ŋgɛ mumɔ kwaɗyɛ ɓeŋgwɛ mi, a tî ɓoŋ yotu nɛ nde, yo yaŋa na. A sôɓa kroa nɛ mɛtu hɛnɛ ɓeŋgwɛ mi. ");
INSERT INTO kkj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kɛto mumɔ hɛnɛ ɛ ta kwaɗyɛ kambiɗya nɛ joŋgwɛ ɗyenɛ kɔ ta ɗimbiɗye yo. Yasi wɛtɛ, yɔkɔ ɛ ɗimbiɗye joŋgwɛ ɗyenɛ kɛto mbɛ kɔ ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma ŋgɛ mumɔ si namɔ mɛnɛti maka hɛnɛ, nje ɗimbiɗye joŋgwɛ ɗyenɛ ho ɓekiɗye yo, yo má nje kamɛ nyɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kɛto ŋgɛ mumɔ gwe njɔn jayna mbɛ nɛ̀ jayna mɛlɛpi mɛmbɛ, *Mɔnɔ Mumɔ ta gwe sendi njɔn wenɛ komɛ nyɛ ta nje nɛ nyaŋgwɛ mɛluksa mɛnɛ nɛ̀ yi Saŋgwɛ nɛ̀ yi pupuna ɓejaki ɓe Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mi kɛ lɛpɔ gbate nyɛ wunɛ nde: Ɓaŋa kɛ njoka ɓotu ɓete ɓe ɗiyɛ ndana waka ɓaka tí gwe kinɛ pa ɓɛŋɛ njena *Kandɔ Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kɛ Yesus ma si lɛpɔ ɗete, ya nda mɛtu yitan jɔ yitati kɛ́, ɛ nyɛ ɓu̧ Piyɛr nɛ̀ Jaŋ nɛ̀ Jak ɓendɔ ɓenɛ ɓo kɛ̀ kɛ to keki, na kɛ̀ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ́, ɛ mbɔmbu nɛ sɛnjɛ. Ɛ lambɔ nɛ yeŋsa ɓɛ wumnate nɛ mboŋ mboŋ. ");
INSERT INTO kkj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɓo sém semɔ, Yesus mɛ kɛ nyɛ mɛsimɔ ɓenɛ ɓembam yiɓa, yo ɓa̧ Mɔyisi ɓenɛ Eli. ");
INSERT INTO kkj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓo punduma kɛ nyaŋgwɛ mɛjasi. Mɔyisi ɓenɛ Eli ɓa̧ kɛ lɛpɔ nda yi Yesus ta kɛ̀ nɔ Yerusalɛm kɛ̀ saŋgwa nɛ sɔŋ mate kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyɛr ɓenɛ ɓenjɔŋ ɓenɛ ɓa̧ kɛ nyaŋgwɛ jakɔ. Kɛ jakɔ ma pɛsiyɛ kɛ misi man kɛ́, ɛ ɓo ɓɛŋɛ nyaŋgwɛ mɛjasi, ɓɛŋɛ Yesus nɛ̀ ɓembam yiɓa ɓe ɓa̧ kɛ kɛki nɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kɛ ŋgimɔ te yi ɓembam ɓaka kandima kwaŋge jisɛ kɛ kɛki Yesus kɛ́, ɛ Piyɛr lɛpɛ nyɛ Yesus nde: «Yekele, yo kimɔte nde, wusɛ ɗîy waka. Wusɛ sûm mɛbala yitati, wɔ wɛtɛ, ɛ Mɔyisi wɛtɛ, ɛ Eli wɛtɛ.» Piyɛr tì ɓɛ kɛ duwɛ yasi te yi nyɛ ɓa̧ kɛ lɛpɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piŋɔ te yi nyɛ ɓa̧ ndi kɛ lɛpɔ ɗete kɛ́, ɛ wɛtɛ kulutu nje ɗiɓiɗye ɓo. Ɓejekɛ gwa̧ wɔ̧ ɓuɗyate kɛ ŋgimɔ te yi ɓo ɓɛŋma nde, kulutu kɛ mɛmiyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ɛ wɛtɛ mɛn wulɛ kɛ mɔy kulutu lɛpɔ nde: «Yɔkɔ mɔnmbɛ yi mi tɔkuma. Wunɛ wôkunaŋgwɛ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kɛ ŋgimɔ te yi ɓo wokuma nɛ mɛn kɛ́, yite Yesus tikama ndi nyɛpɔ. Ɓejekɛ ɗiyma numbu kɔɓɔ kɛ pɔku mɛtu mɛte yite kinɛ yekiɗye yasi te yi ɓo ɓɛŋma kɛ́ nyɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Misi pupɛ ɛ ɓo piyɛ wulɛ kɛ to keki, ɛ nyaŋgwɛ ŋgil nje saŋgwa nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ɗiyɔ kɛ́, ɛ wɛtɛ mbam lɛpɛ nɛ mɛn kɛ kwey kɛ mɔy ŋgil nde: «Yekele, mi kɛ ŋgwɛta nɛ wɛ: Kaŋa misi ɓɛŋɛ nɛ gwanjɔ wombɛ, nyɛ kikɔ. ");
INSERT INTO kkj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yiŋa sisiŋ kɛ ɗiki yembile nyɛ. Ndana ndana kɛ́, a mɛ kɛ kembiɗya, sisiŋ te má nambɛ nyɛ, ɔ ɓɛ́ŋa, mɛwuru mɛ kɛ pundɔ kɛ numbu nɛ pum pum. Yo ti síy nɛdɔ na. Kɛ kɔŋte, yotu nɛ mɛ hɛnɛ katinate. ");
INSERT INTO kkj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ŋgwɛtama nɛ ɓejekɛ ɓɔ nde, ɓo ɗûɗya ɓeya sisiŋ te soŋɛ kɛ yotu nɛ, yasi wɛtɛ, ɛ ɓo suɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ɛ Yesus yeŋsa lɛpɔ nde: «Wunɛ ɓotu ɓete ɓe ti jáya yasi ɓaka, wunɛ sendi ɓeya ɓomɔ, mi ta ɗiyɔ sinɛ wunɛ kumɔ ndenɛn? Mi ta gbisɔ wunɛ kumɔ ndenɛn? Ɓoŋgɔ mɔnɔ wɔ nje nɔ waka.» ");
INSERT INTO kkj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kɛ ŋgimɔ te yi mɔnɔsikɛ ɓa̧ kɛ wuta nɛ Yesus kɛ́, ɛ ɓeya sisiŋ jalɛ nyɛ ɓetɛ kɛ mɛnɛti nambɛ nyɛ ɓeyate. Ɛ Yesus ɓama nɛ ɓeya sisiŋ siɗyɛ kɔn mɔnɔ ɛnɔru kaŋɛ nyɛ nyɛ saŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɛ ɓomɔ hɛnɛ ŋgbakima nyaŋgwɛ ɗeti Njambiyɛ. Kɛ ŋgimɔ te yi ɓomɔ hɛnɛ ɓa̧ ndi kɛ kɛ̀ mbɔmbu yí ŋgbakima mɛyasi mɛte yi Yesus ɗikima kelɔ hɛnɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: ");
INSERT INTO kkj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Wunɛ lɛ̂ŋgwɛ mɛtɔ kimɔte kɛ mɛlɛpi mɛte yi mi ta lɛpɔ nyɛ wunɛ ndana kɛ́. Ɓo ta ɓu̧ *Mɔnɔ mumɔ nyɛ ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ko ɓɛkɔ ɗete, ɓejekɛ tì wokɛ to lɛpi te na. Yo ɓa̧ sɔɗyate nɛ ɓo, ma ɓo nje ɓiye to te. Ɓo gwa̧ wɔ̧ diyna nɛ lɛpi te. ");
INSERT INTO kkj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yinɔri yiŋa mɛtandɔ ɗyaŋma kɛ njoka yan yí duwɛ mɔ te ɛ kwaŋma ɓɛsɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus duwa̧ yasi te yi ɓo ɓa̧ kɛ takɛ kɛ mɔy mɛtemɔ man kɛ́, ɛ nyɛ ɓu̧ wɛtɛ gbɛla mɔnɔsikɛ tɛmbiɗye kɛ kɛki nɛ ");
INSERT INTO kkj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","lɛpɔ nyɛ ɓo nde: «Mumɔ hɛnɛ ɛ ɓu̧ mɔnɔsikɛ nda yɔkɔ kimɔte kɛto mbɛ, a ɓóŋ mi kimɔte. Mɔ te ɛ ɓu̧ mi kimɔte, a ɓóŋ Mɔ te ɛ tomma mi kɔ. Ɗete, kɛ njoka yun hɛnɛ, yɔkɔ ɛ ɓu̧ yotu nɛ nda njena mumɔ, yo nyɛ kwa̧ ɓɛsɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ɛ Jaŋ lɛpɛ nde: «Yekele, wusɛ ɓɛŋma wɛtɛ mbam kɛ soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ nɛ ɗinɔ ɗyɔ, ɛ wusɛ gayɛ nyɛ, kɛto a yeti kɛ njɔŋ su na.» ");
INSERT INTO kkj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wunɛ tî gay nyɛ na, kɛto ŋgɛ mumɔ ti lu̧ ɗyambi suŋgwɛ nɛ wunɛ, a kɛ kɔŋ yun.» ");
INSERT INTO kkj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kɛ mɛtu mɛte yi Yesus ta yɔkwɛ kɛ̀ nɔ ɗyoɓɔ kɛ́ ma si wuta, ɛ nyɛ pɛsɛ kɛ temɔ nɛ nde, a kɛ kɛ̀ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɛ nyɛ tomɛ ɓomɔ kɛnjɛ mbɔmbu. Ɛ ɓo kwa̧ kumɔ kɛ wɛtɛ ɗya ɓotu ɓe Samari diy kombile mbɛy tikɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yasi wɛtɛ, ɓomɔ ɓe ɗya te tì ɓu̧ nyɛ nɛ mɛsosa na, kɛto ɓo ɓɛŋma nde, a kɛ́n kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kɛ ɓejekɛ ɓenɛ Jak ɓenɛ Jaŋ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo lɛpɛ nde: «Nyaŋgwɛ Kumande, wɛ kwáɗyikwɛ nde, wusɛ lɛ̂pi nde, ɗitɛ pîkwɛ kɛ kwey nje girise ɓo?» ");
INSERT INTO kkj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ɛ nyɛ yeŋsa ɓɛŋɛ ɓo ɓamɛ ɓo lɛpɔ nde: «Wunɛ yeti kɛ duwɛ kwalɔ sisiŋ te yi ɗya̧ kɛ yotu yun kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kɛto *Mɔnɔ mumɔ ti ma njáki nde, nɛ́ ɓomɔ yambile na. Yasi wɛtɛ, a njáki nje joŋgwɛ ɓomɔ.» Kɛ kɔŋte, ɛ ɓo kwa̧ kɛ̀ kɛ wɛtɛ ɗya. ");
INSERT INTO kkj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ nje kɛ́, ɛ wɛtɛ mumɔ lɛpɛ nde: «Mi kɛ kwaɗyɛ ɓeŋgwɛ wɛ kɛ mbɛy hɛnɛ komɛ wɛ ta kɛ̀ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ɓetoŋgɔ nɛ mɛnjɛmbi man, ɓenɔn sendi nɛ mɛtu̧ man. Yasi wɛtɛ, *Mɔnɔ mumɔ kinɛ mbɛy te yi nyɛ yakama ɓokwɛ to nɛ kɛte na.» ");
INSERT INTO kkj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɛ nyɛ nje lɛpɔ nyɛ wɛtɛ mumɔ nde: «Ɓeŋgwɛ mi.» Ɛ nyɛ yeŋsa nde: «Nyaŋgwɛ Kumande, tikɔ, nɛ́ mi pa kɛ̀ pumbu saŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ɛ Yesus yeŋsa nde: «Tikɔ, nɛ́ ɓemuŋ pumbu ɓemuŋ ɓan. Kwaŋgɔ yɔ kɛ̀ pelɛ kasi *Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɛ wɛtɛ nje lɛpɔ nɛ nde: «Nyaŋgwɛ Kumande, mi kɛ kwaɗyɛ ɓeŋgwɛ wɛ, yasi wɛtɛ, tikɔ, nɛ́ mi pa kɛ̀ jana nɛ ɓotu ɓembɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Ŋgɛ mumɔ nyɛ ɓɔ kɛ putika ŋgwaŋ nje ɓɛŋɛ njimɛ, mɔ te ti yaka kelɔ yaŋa kɛ Kandɔ Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kɛ kɔŋte, ɛ Kumande Yesus tɔkɛ ɓaŋa ɓejekɛ kamɔtan jɔ kaɓa tomɔ ɓo mbɔmbu yiɓa yiɓa kɛnjɛ kɛ mɛɗya hɛnɛ nɛ̀ mɛmbɛy hɛnɛ komɛ nyɛ nɛ ŋguru wenɛ kwaɗya kɛ̀ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ɓuɗya nyambi ma ɗetɔ kɛ ŋgwaŋ, yasi wɛtɛ, ɓotu ɓe mɛsay ti ɓuyɔ na. Ɗete, wunɛ ŋgwɛ̂taŋgwɛ nɛ sa ŋgwaŋ nde, a kɛ̂njikwɛ ɓotu ɓe mɛsay, nɛ́ ɓo kɛ̀ wesiɗye nyambi nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wunɛ kwâŋ, wunɛ dûkwɛ nde, mi kɛ tomɔ wunɛ kɛnjɛ nda ɓɔnɔ ɓesam kɛ njoka ɓeŋgwɛy. ");
INSERT INTO kkj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wunɛ tî ɓoŋ ko koɓiyɛ mɔni na ko gbɛla koɓiyɛ na ko mɛnakala na. Wunɛ tî tɛma kɛ nje yí pa nyɛnɔ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tu̧ hɛnɛ te yi wunɛ ta nyiŋɛ kɛte, wunɛ kânda lɛpɔ nde: ‹Tɛte ɓɛ̂ki nɛ ɓotu ɓe tu̧.› ");
INSERT INTO kkj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ŋgɛ wɛtɛ tɛ mumɔ ɓɛ kɛ tu̧ te, tɛte yi wunɛ lɛpima nɔ kɛ́ ta ɗiyɔ pɛlɛ nyɛ. Ŋgɛ yo ti ɓɛ ɗete na, yo má yɔkwɛ nje ndi kɛ yun. ");
INSERT INTO kkj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wunɛ ɗîy ndi kɛ tu̧ te. Wunɛ ɗyâki, nɛ̀ wunɛ hɔ̂ɓiya yasi te yi ɓo ta nyɛ wunɛ kɛ́, kɛto mɔ mɛsay yâkaŋgwɛ ɗye nduku mɛsay mɛnɛ. Wunɛ tî kɛn mɛtu̧ nɛ mɛtu̧ na. ");
INSERT INTO kkj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ŋgɛ wunɛ ɗya̧ kɛ yiŋa ɗya, ŋgɛ ɓomɔ ɓu̧ wunɛ kimɔte, nɛ̀ wunɛ ɗyâki yasi te yi ɓo ta nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wunɛ sîɗyikwɛ mɛkɔn mɛ ɓotu ɓe ɗya te, nɛ̀ wunɛ lɛ̂pi nyɛ ɓo nde: ‹*Kandɔ Njambiyɛ ma wuta.› ");
INSERT INTO kkj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ɗya hɛnɛ te yi wunɛ ta kumɔ kɛte, ŋgɛ ɓomɔ ti ɓu̧ wunɛ kimɔte na, nɛ̀ wunɛ kɛ̂ndi kɛ mɛmbɛy hɛnɛ kɛ mɔy ɗya lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Wusɛ kɛ kutɔ ŋgbutu ɗya ɗyun yi ka̧ kɛ mɛkol musu kɛ́ kɛnjɛ kɛ to yun yí teɗye wunɛ nde, wunɛ kelma ɓeyate. Yasi wɛtɛ, wunɛ dûkwɛ nde, Kandɔ Njambiyɛ ma wuta.› ");
INSERT INTO kkj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi kɛ lɛpɔ nyɛ wunɛ nde: Komɛ yesɔ pɛsina jɔsi ta ɗya̧ kɛ́, pɛsina jɔsi ɗya te ta laŋ ɗetɔ kwa̧ yi *Sɔdɔm. ");
INSERT INTO kkj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Wunɛ ɓotu ɓe Korasin, mɛbɔnɛ ta ɓalɔ kɛ to yun! Wunɛ ɓotu ɓe Betsayda, mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto má ɓɛki nde, nyaŋgwɛ mɛkele mɛte yi kelnama kɛ mɛɗya mun kɛ́ ma kélnaŋgwɛ kɛ Tir nɛ̀ Sidɔn, ma ɓotu ɓete yeŋsama temɔ njombu yaŋa, lɛŋɛ mɛsanduku kutuɗye mɛsu mɛ ɗitɛ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ɗete, kɛ yesɔ pɛsina jɔsi, pɛsina jɔsi te yun ta laŋ ɗetɔ kwa̧ yi Tir nɛ̀ Sidɔn. ");
INSERT INTO kkj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma wunɛ ɓotu ɓe Kapɛrnawum, ’wunɛ táka ka nde, ɓo ta ɓendiɗye wunɛ kumɔ kɛ kwey? Ɓo ta kpalɔ piɗyɛ wunɛ kumɔ kɛ ɗya ɓemuŋ!» ");
INSERT INTO kkj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ɛ Yesus nje lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: «Mɔ wokɛ mɛn yun, a wóku mɛn mbɛ. Sendi, yɔkɔ ɛ sɛŋɛ wunɛ, a sɛ́ŋa mi. Mɔ te ɛ sɛŋɛ mi, a sɛ́ŋa Mɔ te ɛ tomma mi kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɓejekɛ ɓaka kamɔtan jɔ kaɓa yɔkwa̧ nɛ mɛsosa nje lɛpɔ nde: «Nyaŋgwɛ Kumande, ko ɓeya mɛsisiŋ kɛ wokuna nɛ wusɛ kɛ ŋgimɔ te yi wusɛ kɛ lɛpina nyɛ ɓo nɛ ɗinɔ ɗyɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Mi ɓɛŋma *Satan kɛ wulɛ ɗyoɓɔ ɓalɔ kɛ mɛnɛti nda yɛsi mbiyɔ. ");
INSERT INTO kkj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wunɛ dûkwɛ nde, mi ma nyɛ wunɛ ɗeti te yi natɛ ɓenyɔŋɛ nɛ̀ ɓelel ɓu̧ ɗeti te yi laŋsa ɗeti *Mɔ pendɔ wun. Sendi, kinɛ yaŋa yakama kelɔ wunɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko ɓɛkɔ ɗete, wunɛ tî sosaŋgwɛ kɛto ɓeya mɛsisiŋ kɛ wokuna nɛ wunɛ na. Yasi wɛtɛ, wunɛ sôsaŋgwɛ, kɛto mɛɗinɔ mun mɛ kɛtinate kɛ ɗyoɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kɛ kiya ŋgimɔ te ɛ Kimɔ Sisiŋ kelɛ nde, Yesus sôsaŋgwɛ ɓuɗyate. Ɛ nyɛ lɛpɛ nde: «Mi kɛ lukse wɛ Da, Kumande ɗyoɓɔ nɛ̀ mɛnɛti, kɛto wɛ sɔɗya mɛyasi mɛte nɛ ɓotu ɓe ɗyanɔ, sɔɗyɛ sendi nɛ ɓotu ɓe duwa̧ yasi, kpalɔ nje punjɛ yo nyɛ gbɛla ɓɔnɔsikɛ. I̧ Da, mi kɛ lukse wɛ, kɛto wɛ kwaɗya nde, mɛyasi kwâŋnaŋgwɛ ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Saŋmbɛ nya mi mɛyasi hɛnɛ. Mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ *Mɔnɔ na, soŋɛ ndi Da. Sendi, mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ Da na, soŋɛ ndi Mɔnɔ nɛ̀ mɔ te yi Mɔnɔ kwaɗyɛ punjɛ yo nyɛ nyɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɛ Yesus yeŋsa ɓɛŋɛ ɓejekɛ lɛpɔ nyɛ ɓo ɓepɔ nde: «Wunɛ nɛ mɛsosa, kɛto ndana misi mun kɛ ɓɛŋɛ nyaŋgwɛ mɛyasi mɛte yi wunɛ ɓɛŋɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mi kɛ lɛpɔ gbate nyɛ wunɛ nde, ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ nɛ̀ ɓekumande kwaɗya ɓɛŋɛ nyaŋgwɛ mɛyasi mɛte yi wunɛ ɓɛŋɛ kɛ́, ma ɓo tì ɓɛŋɛ yo na. Ɓo kwaɗya wokɔ nyaŋgwɛ mɛyasi mɛte yi wunɛ wokɛ kɛ́, ma ɓo tì wokɛ yo na.» ");
INSERT INTO kkj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ndana, ɛ wɛtɛ nyaŋgwɛ mɔ duwa̧ mɛmboŋga tɛmɛ diyɛ Yesus diyan yí ɓoɓɛ nɛ nyɛ. A diyma nyɛ nde: «Yekele, mi kêl nan, nɛ́ mi ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo?» ");
INSERT INTO kkj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo kɛtinate nɛ ŋge kɛ mɛkana mɛ mɛmboŋga te yi Mɔyisi kɛtima kɛ́? Wɛ tɔ́l nɛ ŋge kɛ mɔyte?» ");
INSERT INTO kkj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɛ nyɛ yeŋsa nde: « ‹Kwaɗyikwɛ Baba Mbokɔ te Njambiyɛ wɔ nɛ temɔ yɔ hɛnɛ nɛ̀ sisiŋ yɔ hɛnɛ nɛ̀ ɗeti yɔ hɛnɛ nɛ̀ ɗyanɔ ɗyɔ hɛnɛ, kwaɗyɛ sendi mɔŋ nda yi wɛ kwaɗyɛ nɛ yotu yɔ kɛ́.› » ");
INSERT INTO kkj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ yeŋsama kimɔte, kelɔ ɗete, nɛ́ wɛ ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo.» ");
INSERT INTO kkj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yí teɗye nde, diyan nɛ nɛ ŋgbeŋ, ɛ nyɛ nje diyɛ Yesus nde: «Maŋmbɛ ɓa nda?» ");
INSERT INTO kkj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nde: «Wɛtɛ mumɔ wulma Yerusalɛm yí kɛ̀ kɛ Yeriko. Kumɔ kɛ nje, ɛ nyɛ saŋgwa nɛ ɓotu ɓe guɓɔ. Ɛ ɓo si sukɔ mɛyasi mɛnɛ mɛndɛ nyɛ ɓeyate tikɔ nyɛ kɛ nje sɔŋ si kwa̧. ");
INSERT INTO kkj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kɛ kiya ŋgimɔ te yite wɛtɛ mɔ nyɛna sadaka nyɛ Njambiyɛ ɓa̧ kɛ nje sendi kɛ kiya nje te. Kɛ nyɛ ma semɔ mbam ɛnɔru kɛ́, ɛ nyɛ konjɛ nyɛ kwa̧ nɛ naŋ. ");
INSERT INTO kkj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wɛtɛ mɔ kandɔ *Levi kelma sendi ɗete. Kɛ nyɛ ma kɛndɔ kumɔ womɛte semɔ mbam ɛnɔru kɛ́, ɛ nyɛ konjɛ nyɛ kwa̧ nɛ naŋ. ");
INSERT INTO kkj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wɛtɛ jɛŋgwɛ, mɔ Samari ɓa̧ kɛ kɛ̀ kɛndi nɛ. A kɛndima ɗya̧ kɛ kɛki mbam ɛnɔru. Kɛ nyɛ ma semɔ nyɛ kɛ́, ɛ ŋgwɛtɛ nɛ ɓiye nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɛ nyɛ jisɛ kɛ̀ kɛ kɛki nɛ ɓiye nyɛ kumbɛ mutɔ nɛ̀ mɛnjam kɛ mɛpeŋ mɛnɛ si wotɔ yo. Kɛ kɔŋte, ɛ nyɛ ɓu̧ nyɛ ɓendiɗye kɛ to tofu wenɛ kwa̧ nɛ nyɛ kɛ̀ nɔ kɛ tu̧ ɓejɛŋgwɛ ɓakiɗye nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Misi pupɛ ɛ nyɛ ɓu̧ sule yiɓa nyɛ mɔ te ɛ ɗiyɛ nɛ tu̧ ɓejɛŋgwɛ kɔ lɛpɔ nyɛ nyɛ nde: ‹Ɓakiɗya mbam kɔ kimɔte. Mɔni hɛnɛ te yi wɛ ta kwaŋɗye kɛ to te yikɛ, mi ta yɔkiɗye yo nyɛ wɛ komɛ mi ta yɔkwɛ kɛ́.› » ");
INSERT INTO kkj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɛ Yesus nje diyɛ nyaŋgwɛ mɔ duwa̧ mɛmboŋga kɔ nde: «Kɛ njoka ɓotu ɓaka ɓetati, yo nda kelma nda nyɛ maŋ nɛ mbam te yi ɓotu ɓe guɓɔ mɛndima kɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɛ nyɛ yeŋsa nde: «Yo yɔkɔ ɛ kelma ŋgikwa nɛ nyɛ kɔ.» Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Kwaŋgɔ, nɛ̀ wɛ kêl sendi ɗete.» ");
INSERT INTO kkj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kɛ ŋgimɔ te yi Yesus ɓenɛ ɓejekɛ ɓenɛ ɓa̧ kɛ kɛndi kɛ́, ɛ nyɛ kumɛ kɛ wɛtɛ ɗya. Ɛ wɛtɛ nyari nde Marta ɓu̧ nyɛ nɛ mɛsosa kɛ tu̧ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ɓa̧ nɛ wɛtɛ maŋ wenɛ nde Mariya. Mariya nja̧ ɗiyɔ mɛtiɗyɛ kɛ kɛki mɛkol mɛ Kumande Yesus yí wokɔ mɛlɛpi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yasi wɛtɛ, Marta ɓa̧ nɛ temɔ kɛ kelna ɓuɗya mɛsay. Ɛ nyɛ nje kɛ kɛki Yesus lɛpɔ nde: «Nyaŋgwɛ Kumande, ’wɛ ɓɛ́ŋa kimɔte nde, maŋmbɛ tîki mi nyɛpɔ kɛ kelna mɛsay? Lɛpɔ nyɛ nyɛ nde, a kâma mi.» ");
INSERT INTO kkj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ɛ Kumande Yesus yeŋsa nyɛ nyɛ nde: «Marta, Marta, wɛ kɛ gwe kaŋ njaŋgwɛ yotu kɛto ɓuɗya mɛkele! ");
INSERT INTO kkj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yo ndi nɛ yasi wɛtɛ yi ɓomɔ yâkaŋgwɛ kelɔ! Mariya tɔkuma kimɔ ŋgaɓiyɛ te yi mumɔ ti yaka soŋɛ kɛ ɓɔ nɛ na!» ");
INSERT INTO kkj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wɛtɛ yesɔ Yesus ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ wɛtɛ mbɛy. Kɛ nyɛ ma si ŋgwɛta kɛ́, ɛ wɛtɛ jekɛ wenɛ lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, teɗya wusɛ nda yi wusɛ yakama ŋgwɛta nɛ Njambiyɛ, nda Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku teɗya sendi ɓejekɛ ɓenɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Ŋgɛ wunɛ ŋgwɛta nɛ Njambiyɛ, wunɛ lɛ̂pi ɗekɛ: ‹Saŋsu, kelɔ nde, ɓomɔ ɓôŋ ɗinɔ ɗyɔ kiyɔ. Inja namɔ mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nyɛkɔ wusɛ mɛɗye mɛte yi ta yaka nɛ wusɛ kɛ yesɔ te ɛ muka. ");
INSERT INTO kkj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tikɔ wusɛ nɛ ŋgwɛtɛ kɛ ɓeya yasi te yi wusɛ kelɛ kɛ́, kɛto wusɛ sendi kɛ tikɔ ɓomɔ hɛnɛ ɓe kelɛ ɓeya yasi nɛ wusɛ. Wɛ tî jaya nde, wusɛ sâŋgwaŋgwɛ nɛ mɛɓoɓilan na.› » ");
INSERT INTO kkj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesus ka̧ mbɔmbu lɛpɔ nyɛ ɓo nde: «Hɛ pâŋ ɓoɓɛ lɛpɔ nde: Wɛtɛ mumɔ kɛ njoka yun kɛ̂n nɛ ɓembe tu kɛ yi sɔ wenɛ lɛpɔ nyɛ nyɛ nde: ‹Maŋmbɛ, nyɛkɔ mi pilo mampa yitati, ");
INSERT INTO kkj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kɛto wɛtɛ sɔ mbɛ ɗyaŋma kɛ yembɛ wulɛ kɛndi. Yasi te yi mi ta nyɛ nyɛ ɗye yeti.› ");
INSERT INTO kkj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sɔ má nje ɗiyɔ kɛ mɔy tu̧ yeŋsa nde: ‹Wɛ tî njaŋgwɛ mi na, mi ma ndaɗyɛ numɛy, sinɛ ɓɔnɔ ɓembɛ mɛ kɛ mɛtinɛŋgwɛ, mi ti yaka tɛmɛ kɛ̀ nyɛ wɛ mampa na.› » ");
INSERT INTO kkj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ɛ Yesus nje lɛpɔ nde: «Mi kɛ lɛpɔ gbate nyɛ wunɛ nde: Ko a tì tɛmɛ ɓu̧ yo nyɛ nyɛ, kɛto nyɛ sɔ wenɛ na, a ta tɛmɛ kɛ̀ nyɛ nyɛ yasi hɛnɛ te yi nyɛ kwaɗyɛ kɛ́, kɛto a jɔmbuma nɛ tiŋ. ");
INSERT INTO kkj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ jɔ̂mbu yasi, ɗete ɓo ta nyɛ wunɛ. Wunɛ sâŋ, ɗete wunɛ ta dolɔ. Wunɛ ɗûŋgwɛ numɛy, ɗete ɓo ta ɓutɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kɛto ɓo nyɛ́ki yasi nyɛ mumɔ hɛnɛ ɛ jɔmbɛ kɔ. Yɔkɔ ɛ sa̧, a kɛ dolɔ. Yɔkɔ ɛ ɗuŋgwɛ numɛy, ɓo kɛ ɓutɛ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wɛ saŋgwɛ nɛ mɔnɔ, ŋgɛ mɔnɔ wɔ jɔmbɛ mampa, ’wɛ má nje nyɛ nyɛ kil kusu? Ŋgɛ nyɛ jɔmbɛ njanjɔ, ’wɛ má nje nyɛ nyɛ nyɔŋɛ? ");
INSERT INTO kkj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ho nde, ŋgɛ nyɛ jɔmbɛ ki̧ kuɓɛ, ’wɛ má nje nyɛ nyɛ lel? ");
INSERT INTO kkj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ŋgɛ ɓɛ nde, ko ɓotu ɓe nyalɔ nda wunɛ kɛ duwɛ nyɛna ɓɔnɔ ɓun kimɔ mɛyasi, ’suŋgwa nɛ Saŋgwɛ wun te ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ? ’A ta ɗiyɔ ka kinɛ nyɛ Kimɔ Sisiŋ nyɛ ɓotu ɓete ɓe diyɛ nyɛ ɓaka?» ");
INSERT INTO kkj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wɛtɛ yesɔ Yesus ɓa̧ kɛ soŋɛ wɛtɛ ɓeya sisiŋ kɛ yotu wɛtɛ mumɔ. Ɓeya sisiŋ te ɗikima kelɔ nde, mumɔ tî tapitaŋgwɛ na. Kɛ ɓeya sisiŋ ma si pundɔ ɗuwɛ kɛ yotu nɛ kɛ́, ɛ mbam kɔ kandɛ ndapi. Ɛ ŋgil ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ŋgbakima. ");
INSERT INTO kkj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko ɓɛkɔ ɗete, ɓaŋa ɓomɔ kɛ njoka te nja̧ lɛpɔ nde: «A sóŋa ɓeya mɛsisiŋ nɛ ɗeti te yi *Kum ɓeya mɛsisiŋ te yi ɓo jeɓa nde *Belsebul kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yí ɓoɓɛ nɛ Yesus, ɛ ɓaŋa ɓomɔ kɛ njokate diyɛ nyɛ nde, a têɗya ɓo wɛtɛ mɛyekambiyɛ te yi wulɛ kɛ ɗyoɓɔ kɛ́, nɛ́ ɓo ɓɛŋ. ");
INSERT INTO kkj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yasi wɛtɛ, Yesus duwa̧ mɛtakɛ man. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ŋgɛ kiya kandɔ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, ɓo ta yaŋgile kandɔ te, yo má girɔ. Sendi, ŋgɛ ɓomɔ ɓe kiya tu̧ wɛtɛ ɓaka kɛ ɓembe lu̧ ɗyambi tandɛ yan, ɓo má wanja. ");
INSERT INTO kkj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ŋgɛ ɓɛ nde, *Satan kɛ lu̧ ɗyambi suŋgwɛ nɛ yotu nɛ nɛ ŋguru wenɛ, ’kandɔ ɗyenɛ má nje kɛ̀ mbɔmbu nan? Kɛto wunɛ kɛ lɛpɔ nde, mi sóŋa ɓeya mɛsisiŋ nɛ ɗeti Belsebul. ");
INSERT INTO kkj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ŋgɛ ɓɛ nde, mi sóŋa mbɛ ɓeya mɛsisiŋ nɛ ɗeti Belsebul, ɓomɔ ɓun sóŋa yan ɓo nɛ ɗeti te yi nda? Ɗete, yo ɓo nɛ ŋguru wan ta jɔse wunɛ nɛmɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma ŋgɛ ɓɛ nde, mi sóŋa ɓeya mɛsisiŋ nɛ ɗeti Njambiyɛ, yite téɗya nde, *Kandɔ Njambiyɛ mɛ kɛ njoka yun. ");
INSERT INTO kkj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ŋgɛ wɛtɛ ŋgaɓolo mbam ɓɛ nɛ mɛkɔ̧ mɛ ɗyambi kɛ ɓɔ ɓakiɗye nɛ tu̧ ɗyenɛ, kusuku nɛ kinɛ kaŋ na. ");
INSERT INTO kkj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yasi wɛtɛ, ŋgɛ wɛtɛ mɔ te ɛ nɛ ɗeti kwa̧ nyɛ kɔ ɗya̧ namɔ nyɛ, mɔ te má si soŋɛ mɛjɔlɛ mɛ ɗyambi mɛte yi sa tu̧ ɓa̧ tikɔ temɔ kɛte kɛ́ hɛnɛ kɛ mɛɓɔ mɛnɛ. Mɔ te má nje kaɓɔ kusuku sa tu̧ yi nyɛ ma namɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ŋgɛ mumɔ ti ɓɛ kɛ kɔŋ mbɛ na, mɔ te kɛ lu̧ ɗyambi nɛ mi. Sendi, ŋgɛ mumɔ ti kwaɗyɛ wesiɗye yasi sinɛ nyɛ na, mɔ te kɛ wanjɔ. ");
INSERT INTO kkj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Ŋgɛ ɓeya sisiŋ pundɛ ɗuwɛ kɛ yotu mumɔ, a kwáŋ wowɔ nɛ mɛkoŋgor yí sa̧ mbɛy mɛwɛɗya. Ŋgɛ nyɛ ti dolɛ kɛ́, a má lɛpɔ nde: ‹Mi ta yɔkwɛ nɛ kɔkɔ kɛ̀ kɛ tu̧ ɗyembɛ komɛ mi wulma kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A yɔ́kwɛ nje dolɔ nde, ɓo ma wɔmbile tu̧ nɛ ŋgɛsɛsɛ si kombile yo. ");
INSERT INTO kkj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ŋgɛ nyɛ semɛ ɗete kɛ́, a kwa̧ kɛ̀ ɓu̧ sendi ɓaŋa hakambe ɓeya mɛsisiŋ yitan jɔ yiɓa ɓe nɛ ɗeti kwa̧ nyɛ ɓaka. Ɔ ɓɛ́ŋa, ɓenɛ ɓo hɛnɛ ma ɗya̧ nyiŋɛ tu̧ ɓiye ɗya womɛte. Ɗete, tɛri mɔ te má nje ɓɛ ndana ɓeyate kwa̧ yi mbɔmbu.» ");
INSERT INTO kkj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus ɓa̧ ndi kɛ lɛpina ɗete kɛ́, ɛ wɛtɛ nyari ɗiyɛ kɛ mɔy ŋgil lɛpɔ nyɛ nyɛ nɛ mɛn kɛ kwey nde: «Nya te ɛ soɓuma wɛ kɛ mɔy nɛ, nyɛ sendi wɛ ɓɛri kɔ nɛ mɛsosa.» ");
INSERT INTO kkj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ɛ Yesus yeŋsa nde: «Ɓomɔ ɓe wokɛ mɛlɛpi mɛ Njambiyɛ, ɓakiɗye sendi yo ɓaka nɛ mɛsosa ɓuɗyate.» ");
INSERT INTO kkj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ɓomɔ ɓa̧ kɛ wesiɗya nɛ ŋgil kɛ kɛki Yesus. Ɛ nyɛ ɓutɛ numbu lɛpɔ nde: «Ɓeya ɓotu ɓe ŋgimɔ te yɔkɔ kɛ diyɛ yiŋa mɛyekambiyɛ. Yasi wɛtɛ, ɓo tí teɗye ɓo yiŋa mɛyekambiyɛ na, ndi yikɛ yi ma ɗyáŋ Yonas kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nda yasi te yi kelma Yonas ɓa̧ mɛyekambiyɛ kɛ yi ɓotu ɓe Ninive, ɗete sendi, yasi te yi ta kelɔ *Mɔnɔ mumɔ kɛ́ ta ɓɛ mɛyekambiyɛ kɛ yi ɓotu ɓe ŋgimɔ te yɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɗyoɓɔ Njambiyɛ ta pɛsɔ jɔsi kɛ́, nya te ɛ ɓa̧ kumande kɛ mɛnɛti mɛ njɛmbɔ kɔ ta tɛmɛ kɛ mbɔmbu ɓotu ɓe ŋgimɔ te yɔkɔ pɛsɔ lɛpi yan, teɗye ɓo nde, ɓo ɓalma lɛpi, kɛto a tɛmma lɔndunate kɛ njena mɛnɛti nje wokɔ mɛlɛpi mɛ Salomɔŋ te yi ɓa̧ tondunate nɛ ɗyanɔ kɛ́. Ndana waka, mɔ te ɛ kwaŋma Salomɔŋ kɔ kɛte. ");
INSERT INTO kkj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɗyoɓɔ Njambiyɛ ta pɛsɔ jɔsi kɛ́, ɓotu ɓe Ninive ta tɛmɛ kɛ mbɔmbu ɓotu ɓe ŋgimɔ te yɔkɔ pɛsɔ lɛpi yan teɗye ɓo nde, ɓo ɓalma lɛpi, kɛto ɓo, ɓotu ɓe Ninive yeŋsama yan temɔ komɛ Yonas pelma yasi te yi Njambiyɛ lɛpima nyɛ ɓo kɛ́. Ndana waka, mɔ te ɛ kwaŋma Yonas kɔ kɛte.» ");
INSERT INTO kkj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nde: «Mumɔ ti kwénja lambo kɛ̀ sɔɗyɛ ho kɛ̀ tikɔ kɛ mɔy mbe na. Yasi wɛtɛ, ɓo ɓóŋ kasɛ kɛ to teɓel, nɛ́ ɓomɔ hɛnɛ ɓe nyiŋɛ tu̧ ɓaka ɓɛŋ mɛjasi mɛte. ");
INSERT INTO kkj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Misi mɔ, yo nda lambo kɛ yotu yɔ. Piŋɔ te yi misi mɔ ɓɛŋna kimɔte, yotu yɔ hɛnɛ kɛ mɔy mɛjasi. Yasi wɛtɛ, kɛ ŋgimɔ te yi misi mɔ ti ɓɛ́ŋna kimɔte, yotu yɔ kɛ mɔy yitil. ");
INSERT INTO kkj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɛmba kimɔte, simande mɛyasi mɛte yi wɛ kelɛ kɛ́, yo yitil. ");
INSERT INTO kkj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ɗete, ŋgɛ yotu yɔ hɛnɛ ɓɛ kɛ mɔy mɛjasi kinɛ yiŋa mbɛy kɛ yitil na, yite mɛjasi saŋgwa yotu yɔ hɛnɛ nda yi lambo panɛ nɔ tikɔ nɛ wɛ kɛ mɛjasi kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kɛ ŋgimɔ te yi Yesus ɓa̧ ndi kɛ lɛpina kɛ́, ɛ wɛtɛ mɔ *Farisɛ̧ jeɓa nyɛ nde, a kɛ̂n kɛ̀ ɗyena kɛ tu̧ ɗyenɛ. Ɛ Yesus nyiŋɛ tu̧ kɛ̀ ɗiyɔ, na ɗyena. ");
INSERT INTO kkj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mɔ Farisɛ̧ ŋgbakimama yí ɓɛŋɛ nde, Yesus kɛ kwaɗyɛ ɗyena kinɛ pa weyɛ ɓɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɛ Kumande Yesus lɛpɛ nyɛ nyɛ nde: «Wunɛ Ɓefarisɛ̧, wunɛ wéya ndi kɔŋ pelɔ nɛ̀ kɔŋ pan, yasi wɛtɛ, temɔ yun tondunate nɛ yɛsiɗyɛ guɓɔ nɛ̀ ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wunɛ ɓelem, kiya mɔ te ɛ wɔmma kɔŋ te kɔ, ’yeti ndi nyɛ wɔmɛ mɔy te na? ");
INSERT INTO kkj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yasi wɛtɛ, wunɛ yâkaŋgwɛ kaɓɔ mɛyasi mɛte yi ɗiyɛ kɛ mɔyte kɛ́ nyɛ buka ɓomɔ. Komɛte, mɛyasi mun hɛnɛ ta ɓɛ pupunate kɛ mbɔmbu Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Wunɛ *Ɓefarisɛ̧, mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto kɛ gbɛla mɛmbunjɔ mɛ likɔ nde *maŋt nɛ̀ *ru nɛ̀ kwalɔ yiŋa mɛnyiŋɔ hɛnɛ, wunɛ kɛ ɓu̧ yasi hɛnɛ kɛ njokate ɓakɛ kɛ mɛŋgaɓiyɛ kamɔ kamɔ, ɓu̧ kwalɔ ŋgaɓiyɛ te wɛtɛ wɛtɛ nyɛ Njambiyɛ. Yasi wɛtɛ, kɛ pɛsina jɔsi nɛ ŋgbeŋ nɛ̀ kɛ kwaɗya Njambiyɛ, wunɛ kɛ tikɔ yite. Ma yo yite yi wunɛ yâkaŋgwɛ kelɔ kinɛ tikɔ kelna ɓukwɛ mɛyasi mɛte yiri na. ");
INSERT INTO kkj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Wunɛ *Ɓefarisɛ̧, mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto wunɛ kwáɗyikwɛ ɗiyɔ ndi kɛ bosa mɛtaŋ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Wunɛ kwáɗyikwɛ sendi nde, ɓomɔ kɛ̂ nyɛnɔ wunɛ kɛ mɛmbɛy komɛ ɓomɔ ɗiki wesiɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto wunɛ nda mɛɓoŋsɔŋ mɛte yi ɓɛ sɔɗyate, ɓomɔ kɛ kwa̧ kɛ to te kinɛ duwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ɛ wɛtɛ nyaŋgwɛ mɔ duwa̧ mɛmboŋga ɛ ɓa̧ kɛ njoka ɓɛsɔ kɔ lɛpɛ nyɛ Yesus nde: «Yekele, yi wɛ lɛpɛ ɗete kɛ́, wɛ kɛ toyɛ sendi wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ɛ Yesus yeŋsa nde: «Wunɛ nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga, mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto wunɛ kɛ soɓiɗye ɓomɔ nyaŋgwɛ ɗitina mɛmapi, yasi wɛtɛ, wunɛ nɛ ŋguru wun yeti kɛ sambile nyɛy ɓɔ yun wɛtɛ kpokɛ nɛ yo na. ");
INSERT INTO kkj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mɛbɔnɛ ta ɓalɔ kɛto yun! Kɛto wunɛ kɛ kombile wɔmɔ mɛɓoŋsɔŋ mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, yo ɓesaŋgwɛ ɓun wo ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɗete, wunɛ kɛ teɗye nde, ɓesaŋgwɛ ɓun nɛ kalɛ. Sendi, wunɛ kɛ jayɛ mɛkele man. Kɛto ɓo, ɓo woma ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, ma yo wunɛ kɛ nje kombile wɔmɔ mɛɓoŋsɔŋ man. ");
INSERT INTO kkj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɗete, Njambiyɛ te yɔkɔ ɛ duwɛ mɛyasi kɔ lɛpima nde: ‹Mi ta tomɔ ɓotu ɓe punja mɛlɛpi mɛmbɛ nɛ̀ ɓotu ɓe tomun. Ɓo ta wo ɓaŋa kɛ njokate, teɗye ɓaŋa mɛbɔnɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɗete, mi ta diyɛ mɛkiyɔ mɛ ɓotu ɓe punja mɛlɛpi mɛmbɛ hɛnɛ yi nyanjama kɛ́ kɛ mɛɓɔ mɛ ɓotu ɓe ŋgimɔ te yɔkɔ. Mi ta diyɛ mɛkiyɔ mɛte kandɛ kɛ yesɔ te yi mbokɔ kusunama nɔ, ");
INSERT INTO kkj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kandɛ kɛ mɛkiyɔ mɛ Abɛl kumɔ kɛ mɛkiyɔ mɛ Sakari te yi ɓo woma kɛ njoka mbɛy nyɛna sadaka nyɛ Njambiyɛ nɛ̀ mbanjɔ Njambiyɛ kɔ. Gbate, mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Njambiyɛ ta diyɛ mɛkiyɔ man kɛ mɛɓɔ mɛ ɓotu ɓe ŋgimɔ te yɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Wunɛ nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga, mɛbɔnɛ ta ɓalɔ kɛ to yun! Kɛto wunɛ petima nje nde, ɓomɔ tî dukwɛ mɛyasi na. Wunɛ nɛ ŋguru wun tì kɛndɛ kɛ nje te na, wunɛ kpalma petɔ ɓotu ɓete ɓe kwaɗya kɛndɔ kɛ nje te ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kɛ Yesus ma pundɔ kɛ tu̧ mɔ *Farisɛ̧ te kɛ́, ɛ Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi kandɛ jeliya nɛ ɓeyate diyɛ nyɛ ɓuɗya mɛdiyan ");
INSERT INTO kkj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","yí lɛɓiye nɛ nyɛ, simande yiŋa ɓeya lɛpi ta pundɔ kɛ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kɛ ŋgimɔ te yite ɓomɔ wesiɗyama ɓetomay ɓetomay nda ɓo ta natina. Ɛ Yesus pa kandɛ lɛpina nyɛ ɓejekɛ ɓenɛ, a lɛpima nde: «Wunɛ ɗîy nɛ sɔsɔ nɛ ŋga̧ *Ɓefarisɛ̧. Ŋga̧ te, yo likisi te yi ɓo nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yasi hɛnɛ te yi ɗiyɛ kɛ sɔ kɛ́ ta pundɔ puyɛ. Sendi, yasi hɛnɛ te yi ɗiyɛ sɔɗyate, ɓomɔ ta duwɛ yo. ");
INSERT INTO kkj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yasi hɛnɛ te yi wunɛ ta lɛpɔ kɛ mɔy yitil nɛ tu, ɓo ta wokɔ yo kɛ puyɛ nɛ yesɔ. Sendi, yasi te yi wunɛ ta lakiɗya lakiɗyaŋgwɛ kɛ mɛtɔ kɛ mɛtoŋgari, yo ta pelna kɛ mɛtosiyɔ̧ nɛ gbololo. ");
INSERT INTO kkj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wunɛ ɓesɔ ɓembɛ, mi lɛ́pi nyɛ wunɛ nde: Wunɛ tî kambi ɓotu ɓete ɓe yakama wo mɛmbundɔ kinɛ ɓɛ nɛ ɗeti te yi nje kelɔ yiŋa yaŋa kɛ kɔŋte na. ");
INSERT INTO kkj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi ta lɛpɔ mɔ te yi wunɛ yâkaŋgwɛ kambɔ kɔ. Wunɛ kâmbi mɔ te ɛ nɛ ɗeti te yi kɛnjɛ mɔ te yi nyɛ si wo kɔ kɛ ɗitɛ te yi ti ɗím kɛ́. Mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Wunɛ kâmbi mɔ te mbɛte. ");
INSERT INTO kkj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ɓenɔn nda ɓeŋgiri, ’ɓo ti ɗyáŋgwɛ ka ɓo yitan sisi yiɓa na? Ko ɗete, Njambiyɛ kɛ duwɛ ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yasi wɛtɛ, kɛ ɓɛ wunɛ, ko nyiŋɔ to yun, Njambiyɛ kɛ duwɛ ɓuyɔte. Wunɛ tî kambi yaŋa na, wunɛ sulnate kɛ misi mɛ Njambiyɛ kwa̧ ɓuɗya ɓeŋgiri. ");
INSERT INTO kkj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mi kɛ lɛpɔ nyɛ wunɛ nde: Mumɔ hɛnɛ tɛ ɛ jayɛ mi kɛ mbɔmbu ɓomɔ, mi *Mɔnɔ mumɔ ta jayɛ sendi nyɛ kɛ mbɔmbu ɓejaki ɓe Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yasi wɛtɛ, mumɔ hɛnɛ ɛ sɛŋɛ mi kɛ mbɔmbu ɓomɔ, mi Mɔnɔ mumɔ ta sɛŋɛ sendi nyɛ kɛ mbɔmbu ɓejaki ɓe Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Mumɔ hɛnɛ ɛ lɛpɛ yiŋa ɓeya yasi suŋgwɛ nɛ Mɔnɔ mumɔ, Njambiyɛ ta tikɔ nyɛ nɛ ŋgwɛtɛ. Yasi wɛtɛ, mumɔ hɛnɛ ɛ lɛpɛ lɛpi gbutu suŋgwɛ nɛ Kimɔ Sisiŋ, ko Njambiyɛ tí tikɔ nyɛ nɛ ŋgwɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Komɛ ɓo ta ɓu̧ wunɛ kɛ̀ nɔ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, kɛ̀ nɔ kɛ mbɔmbu ɓotu ɓe pɛsina jɔsi, ho kɛ̀ nɔ kɛ̀ mbɔmbu ɓekum, wunɛ tî gwaki kaŋ kɛ yasi te yi wunɛ ta yeŋsa, ho gwe kaŋ kɛ yasi te yi wunɛ ta lɛpɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kɛto Kimɔ Sisiŋ ta teɗye wunɛ yasi te yi wunɛ ta lɛpɔ kɛ́ kɛ kiya mbɛy.» ");
INSERT INTO kkj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kɛ kɔŋte, ɛ wɛtɛ mumɔ ɗiyɛ kɛ mɔy ŋgil lɛpɔ nyɛ Yesus nde: «Yekele, lɛpɔ nyɛ maŋmbɛ nde, sinɛ nyɛ kâɓiɗyaŋgwɛ kusuku te yi saŋsu tikima nɛ wusɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Mbam, nda tikɛ mi mɔ pɛsina jɔsi yun ho mɔ kaɓina kusuku yun nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy nɛ sɔsɔ. Wunɛ tî ɓɛki nɛ njaŋ sumba na, kɛto ɓuɗya kusuku te yi mumɔ yakama ɓɛ nɔ kɛ́ ti yaka nyɛ nyɛ joŋgwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɛ nyɛ nje yekiɗye wɛtɛ kanɔ nyɛ ɓo lɛpɔ nde: «Wɛtɛ mɔ kusuku woma ɓuɗya nyambi kɛ mɛŋgwaŋ mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛ nyɛ takina kɛ mɔy temɔ nɛ lɛpɔ nde: ‹Mi ta kelɔ nan, kɛto mi yeti se nɛ mbɛy te yi ɓakiɗye nyambi mbɛ kɛte na.› ");
INSERT INTO kkj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɛ nyɛ lɛpɛ nde: ‹Ndana mi duwa̧ nda yi mi ta kelɔ kɛ́. Mi ta si yaŋgile mɛndam mɛmbɛ nje sumɔ mɛnyaŋgwɛ mɛte kwa̧ yi mbɔmbu. Mi ta wesiɗye nyambi mbɛ nɛ̀ kusuku mbɛ hɛnɛ nyɛ kɛ mɔyte, ");
INSERT INTO kkj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","má nje lɛpɔ kɛ kɔŋte nyɛ temɔ mbɛ nde: Temɔ mbɛ, wɛ nɛ ɓuɗya kusuku kɛ kom yi yaka ɓuɗya mɛsew! Wɛɗyaŋgwɛ, ɗyenaŋgwɛ, ɗyakɔ mɛnjam, nɛ̀ wɛ kêɓi joŋgwɛ ɗyɔ!› ");
INSERT INTO kkj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yasi wɛtɛ, ɛ Njambiyɛ lɛpɛ nyɛ nyɛ nde: ‹Wɛ lem, kɛ tu kɔ muka mi ta ɓu̧ sisiŋ yɔ! Ma mɛyasi hɛnɛ te yi wɛ wesiɗya kɛ́ ta wokuna nɛ nda?› ");
INSERT INTO kkj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yo ɗete sendi kɛ yi mumɔ hɛnɛ ɛ wesiɗye kusuku ndi yenɛ nyɛpɔ, yasi wɛtɛ, nyɛ gbɛlate kɛ misi mɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɛ Yesus nje lɛpɔ kɛ kɔŋte nyɛ ɓejekɛ ɓenɛ nde: «Ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ tî gwaki kaŋ kɛ joŋgwɛ ɗyun kɛ kasi mɛɗye, ho gwe kaŋ yotu yun kɛ kasi mɛlɛŋgwe na, ");
INSERT INTO kkj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","kɛto joŋgwɛ kwa̧ mɛɗye, yotu kwa̧ mɛlambɔ. ");
INSERT INTO kkj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wunɛ ɓɛ̂ŋa ɓenɔn. Ɓo ti ɓɛ́ki mbɛki na, ɓo yeti kɛ soŋɛ yiŋa nyambi kɛ ŋgwaŋ na, ɓo kinɛ talɔ ho ndam na. Ko ɓɛkɔ ɗete, Njambiyɛ kɛ nyɛ ɓo mɛɗye. Wúnɛ ɓenɔn yeti wɛtɛ na, wunɛ kwa̧ ɓo mɛtu gɔmay kɛ misi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mɔ te nda kɛ njoka yun yakama sɛwɗye mɛtu mɛ joŋgwɛ ɗyenɛ nɛ mbɛt kɛto gwena kaŋ te yi nyɛ nɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋgɛ ɓɛ nde, wunɛ yeti nɛ ɗeti te yi kelɔ mɔnɔ yaŋa ɗete na, ’ma nɛ njáki gwe kaŋ kɛ mɛyasi mɛte yiri kɛto ŋge? ");
INSERT INTO kkj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Wunɛ ɓɛ̂ŋa nda yi mɛmbunjɔ ju̧ nɔ kɛ́. Mɛmbunjɔ yeti kɛ kelɔ yiŋa mɛsay ho sa mɛlambɔ na. Ko ɓɛkɔ ɗete, mi kɛ lɛpɔ nyɛ wunɛ nde: Ko kumande Salomɔŋ nɛ nyaŋgwɛ ɗiyɔ mɛluksa mɛnɛ tì lɛŋɛ yiŋa kpasa kimɔ lambɔ nda njam mɛmbunjɔ maka wɛtɛ nɛ wɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma wunɛ ɓotu ɓete ɓe tikɛ temɔ nɛ mbɛt kɛ yi Njambiyɛ ɓaka, ŋgɛ Njambiyɛ nyɛ kimɔ njam nyɛ mɛmbunjɔ mɛte yi likɔ yi ɗiyɛ ndi muka, nɛmɛnɔ ɓo ɓoŋma ɓetɛ kɛ ɗitɛ kɛ́, ’suŋgwa nɛ wunɛ? ’A ta ɗiyɔ ka kinɛ lɛnje wunɛ lambɔ na? ");
INSERT INTO kkj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wunɛ tî tiki ndi temɔ kɛ saŋna yasi te yi wunɛ ta ɗye ho yasi te yi wunɛ ta hɔɓiye na. ");
INSERT INTO kkj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kɛto yo mɛkandɔ mɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka sa̧ mɛyasi mɛte yinɔri hɛnɛ. Yasi wɛtɛ, Saŋgwɛ wun duwa̧ nde, wunɛ yâkaŋgwɛ ɓɛ nɛ mɛyasi mɛte kɛ joŋgwɛ ɗyun. ");
INSERT INTO kkj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wunɛ kânda gɔsɔ *Kandɔ te yi Njambiyɛ, ɗete a má nje dokiɗye mɛyasi mɛte yiri kɛ to te nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wunɛ mɔnɔ kuru ɓesam, wunɛ tî gwaki wɔ̧ na, kɛto Saŋgwɛ wun ɓɛŋma kimɔte yí kaŋɛ Kandɔ ɗyenɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wunɛ ɗyâŋgwɛ mɛkusuku mun ɓu̧ mɔni te nyɛ buka ɓomɔ. Wunɛ fûl mɛkoɓiyɛ mɛ ɓakiɗya mɔni yi ti ɓutɔ kɛ́, nɛ̀ wunɛ kôm mɛkusuku mun kɛ kwey komɛ Njambiyɛ ɗiyɛ kɛ́. Kusuku te tí yambile na. Mate mɔ guɓɔ tí wuta kɛ kɛkite na. Ɓenya tí ɗye yo na, ");
INSERT INTO kkj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","kɛto kɛ mbɛy te yi kusuku yun ɗiyɛ kɛte, temɔ yun ta ɓɛ sendi womɛte.» ");
INSERT INTO kkj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nde: «Wunɛ kômsaŋgwɛ susule mɔy jeliyɛ. Mɛlambo mun ɗîy kwenjate. ");
INSERT INTO kkj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wunɛ ɓɛ̂ki nda ɓotu ɓe mɛsay ɓete ɓe laɗye masa wan komɛ nyɛ ta yɔkwɛ kɛ jesɔ gwaki kɛ́. Ɗete, ɓo ta ɓutɛ numɛy nɛdɔ nyɛ nyɛ komɛ nyɛ ta ɗya̧ ɗuŋgwɛ numɛy kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɓotu ɓe mɛsay te ɓɛte nɛ mɛsosa komɛ masa wan ta yɔkwɛ dolɔ ɓo kɛ mɛjemsiɗyɛ kɛ́. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: A ta komsa susule mɔy jeliyɛ, a má jeɓa ɓo, nɛ́ ɓo nje ɗiy mɛtiɗyɛ ɗyena. Nyɛ nɛ ŋguru wenɛ ta ɓu̧ mɛɗye nɛ̀ mɛyasi hɛnɛ nje tikɔ kɛ nji̧ mɛkol man. ");
INSERT INTO kkj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kɛ nyɛ ɗya̧ kɛ ɓembe tu ho kɛ numbu ŋgimɔ dolɔ ɓo kɛ mɛjemsiɗyɛ, ɓotu ɓe mɛsay te ɓɛte nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wunɛ dûkwɛ gba nde: Sa tu̧ má dukwɛ ŋgimɔ te yi mɔ guɓɔ nje nɔ kɛ́, ma nyɛ kɛ pɛmɔ yasi, kambɔ mɔ guɓɔ mɛ nje lekɛ tu̧ nyiŋɛ guɓɔ mɛyasi. ");
INSERT INTO kkj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɗete, wunɛ sendi, wunɛ kômsaŋgwɛ, kɛto *Mɔnɔ mumɔ ta nje kɛ ŋgimɔ te yi wunɛ tì ɓɛ kɛ takɛ nde, a ta nje kɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ’wɛ nyɛ́ki kanɔ te yikɛ nyɛ wusɛ, ho wɛ nyɛ́ki kɛto ɓomɔ hɛnɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ɛ Nyaŋgwɛ Kumande yeŋsa nde: «Yo nda kimɔ mɔ ɓakiɗya mɛyasi? Yo yɔkɔ ɛ nɛ sɔsɔ yi masa wenɛ ta tɛmbiɗye nyɛ nde, a ɗîy nɛ ɓotu ɓe mɛsay ɓenɛ yí nyɛ ɓo mɛɗye yaka nɛ ŋgimɔ te yi nyɛ pɛsima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mɔ mɛsay kɔ nɛ mɛsosa komɛ masa wenɛ ta ɗya̧ dolɔ nyɛ kɛ kelɔ ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: A ta nje tɛmbiɗye nyɛ, na ɗiy nɛ mɛyasi mɛnɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yasi wɛtɛ, ŋgɛ mɔ mɛsay kɔ lɛpɛ kɛ mɔy temɔ nɛ nde: ‹Masa wombɛ tí yɔkwɛ ndana nɛdɔ na,› ŋgɛ nyɛ nje nyɛ ɓɔ kɛ mɛndina ɓotu ɓe mɛsay, ɓembam nɛ̀ ɓomari, ɗiyɔ ndi mɛɗye, ndi hɔɓiya mɛnjam nɛ̀ gwena mɛnjam, ");
INSERT INTO kkj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yite wɛtɛ yesɔ masa wenɛ ta duwɛ ɗya̧ kɛ yesɔ te yi nyɛ tì ɓɛ kɛ takɛ nde, a ta ɗya̧ kɛte na, kɛ hawa te yi nyɛ tí duwɛ na. A ta teɗye nyɛ nyaŋgwɛ mɛbɔnɛ tikɔ kɛ nje sɔŋ, kelɔ nɛ nyɛ nda yi ɓo kelɛ nɛ ɓotu ɓete ɓe ti tíki temɔ kɛ yi Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Mɔ mɛsay te yɔkɔ ɛ ma duwɛ yasi te yi masa wenɛ kwaɗyɛ nje ɗiyɔ kinɛ kombile mɛyasi, kinɛ kelɔ sendi nda yi masa wenɛ kwaɗyɛ, ɓo ta njurɔ nyɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yasi wɛtɛ, yɔkɔ ɛ kelma yasi kinɛ duwɛ kwaɗya te yi masa wenɛ, ŋgɛ ɓɛ nde, a kelma yasi te yi ɓo yâkaŋgwɛ njurɔ nyɛ kɛte, ɓo ta njurɔ nyɛ nɛ mbɛt. Ɓo ta diyɛ ɓuɗya mɛyasi kɛ mɛɓɔ mɛ mɔ te yi ɓo nya nyɛ ɓuɗya mɛyasi kɔ. Ɓo ta diyɛ kwa̧ to te kɛ mɛɓɔ mɛ mɔ te yi ɓo nya nyɛ ɓuɗya mɛyasi nde, a ɓâkiɗya kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Mi nja̧ ɓetɛ ɗitɛ kɛ mɛnɛti. Mi kɛ gɔrɔ nɛ temɔ mbɛ hɛnɛ nde, ɗitɛ ɓîya. ");
INSERT INTO kkj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yo nɛ wɛtɛ mɛtɔpuna te yi mi yâkaŋgwɛ saŋgwa nɔ, temɔ mbɛ ndi kɛ gwe kaŋ, disɔ wɛɗya, yo má kelna. ");
INSERT INTO kkj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","’Wunɛ táka ka nde, mi njáki nje nyɛ tɛte kɛ mɛnɛti maka? Mi kɛ lɛpɔ nyɛ wunɛ nde: Ko na. Mi njáki ɓakɛ njoka ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kandɛ ndana, kɛ njoka ɓomɔ yitan ɓe joŋna kɛ kiya tu̧ wɛtɛ, ɓo ta ɓaka, ɓomɔ yitati ta lu̧ ɗyambi suŋgwɛ nɛ ɓari yiɓa. Ɓaka yiɓa má lu̧ sendi ɗyambi suŋgwɛ nɛ ɓari ɓetati. ");
INSERT INTO kkj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Saŋgwɛ nɛ mɔnɔ ta lu̧ ɗyambi nɛ mɔnɔ ɛ mbam. Mɔnɔ ɛ mbam má lu̧ ɗyambi nɛ saŋgwɛ. Nyaŋgwɛ nɛ mɔnɔ ta lu̧ ɗyambi nɛ mɔnɔ wenɛ ɛ nyari. Mɔnɔ nyari má lu̧ sendi ɗyambi nɛ nyaŋgwɛ. Mbambɔ ɛ nyari ta lu̧ ɗyambi nɛ njari nɛ. Njari má lu̧ sendi ɗyambi nɛ mbambɔ ɛ nyari.» ");
INSERT INTO kkj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus ka̧ mbɔmbu lɛpɔ nyɛ ŋgil ɓomɔ nde: «Kɛ ŋgimɔ te yi wunɛ ɓɛŋɛ yindi mbiyɔ kɛ mɛta mɛ ɗyoɓɔ, ndana ndana wunɛ kɛ lɛpɔ nde: ‹Mbiyɔ ta nɔ,› ɔ ɓɛ́ŋa kɛ́, yo kelnama ndi ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kɛ ŋgimɔ te yi wunɛ tɛmɛ ɓemɛŋmɛnɛ ɓɛŋɛ ɗyoɓɔ nɛ waŋgo, wunɛ lɛ́pi nde: ‹Joŋ ta kelɔ muka ɓuɗyate,› ɔ ɓɛ́ŋa kɛ́, yo kelnama ndi ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wunɛ ɓotu ɓe likisi, wunɛ kɛ duwɛ nɛmbɛ tɛri ɗyoɓɔ nɛ̀ mɛnɛti. Ma nan yi wunɛ ti nɛ́mba mɛyasi mɛte yi kwaŋna kɛ mɛŋgimɔ te yikɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Kɛto ŋge yi wunɛ nɛ ŋguru wun ti nɛ́mba sendi mɛyasi yi duwɛ nɛ ŋgbeŋ mɛkele kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ŋgɛ wúnɛ mumɔ ɓɛ nɛ lɛpi, ŋgɛ ɓɛ nde, wunɛ kɛ kɛ̀ kɛ jɔsi, saŋgɔ nje te yí si kombile lɛpi te wúnɛ nyɛ kɛ ŋgimɔ te yi wúnɛ nyɛ ndi kɛ nje kɛ́. Kelɔ ɗete, kambɔ a mɛ nje ɓu̧ wɛ kɛ̀ nɔ kɛ mbɔmbu mɔ pɛsina jɔsi. Ma mɔ pɛsina jɔsi mɛ nje ɓu̧ wɛ kaŋɛ nyɛ mɔ te ɛ ɗiyɛ nɛ tu̧ jɔɓɔ kɔ, kambɔ mɔ te ɛ ɗiyɛ nɛ tu̧ jɔɓɔ kɔ mɛ nje ɓu̧ wɛ nyɛ kɛ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi kɛ lɛpɔ nyɛ wɛ nde: Wɛ disɔ pundɔ womɛri, yite wɛ sima gbo lɛpi hɛnɛ nɛ satak kinɛ ɓukwɛ ko mɔnɔ mbulma sisi wɛtɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ndi kɛ kiya ŋgimɔ te ɓaŋa ɓotu ɓete ɓe ɓa̧ womɛte ɓaka nja̧ yekiɗye kasi ɓotu ɓe Galile nyɛ Yesus. Ɓo lɛpima nda yi Pilat woma ɓotu ɓete, ɛ mɛkiyɔ man saŋgwa nɛ mɛkiyɔ mɛ ɓenyamɔ ɓete yi ɓo woma kelɔ nɛ sadaka nyɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «’Wunɛ táka ka nde, ɓo sáŋgwaŋgwɛ nɛ nyaŋgwɛ mɛbɔnɛ mɛnɔri, kɛto ɓo ɓa̧ nyaŋgwɛ ɓotu ɓe mɛɓeyɔ kwa̧ ɓomɔ hɛnɛ kɛ mɛnɛti mɛ Galile? ");
INSERT INTO kkj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mi kɛ lɛpɔ nyɛ wunɛ nde: Yeti ɗete na. Yasi wɛtɛ, ŋgɛ wunɛ ti yeŋsa temɔ na, wunɛ hɛnɛ ta yambile sendi ɗete. ");
INSERT INTO kkj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sendi, ɓomɔ kamɔ jɔ yitan jɔ yitati yi doŋgbe doŋgbe tu̧ Silɔy ɓalma si wo kɛ́, ’wunɛ táka ka nde, ɓo ɓa̧ nyaŋgwɛ ɓotu ɓe mɛɓeyɔ kwa̧ ɓomɔ hɛnɛ kɛ Yerusalɛm? ");
INSERT INTO kkj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mi kɛ lɛpɔ nyɛ wunɛ nde: Yeti ɗete na. Yasi wɛtɛ, ŋgɛ wunɛ ti yeŋsa temɔ na, wunɛ hɛnɛ ta yambile sendi ɗete.» ");
INSERT INTO kkj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kɛ kɔŋte, ɛ Yesus nyɛ wɛtɛ kanɔ nde: «Wɛtɛ mbam ɓɛma wɛtɛ jeti nde *figiye kɛ ŋgwaŋ nɛ. Ɛ nyɛ kɛ̀ ɓɛŋɛ, simande yo wumma, na nɔku. A ka̧ kinɛ dolɔ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndana, ɛ nyɛ lɛpɛ nyɛ mɔ ɓakiɗya ŋgwaŋ nde: ‹Ɓɛŋa, kandɛ mɛsew yitati muka, ŋgɛ mi nje ɓɛŋɛ, simande figiye kɔ wumma, nɛ́ mi nɔku tena mɛmbumɔ mɛte, mi ti dól yaŋa na. Ɗete, pɛsɔ nyɛ, a kɛ ɗye mbɛy gbɛlate.› ");
INSERT INTO kkj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ɛ mɔ ɓakiɗya ŋgwaŋ yeŋsa nyɛ nyɛ nde: ‹Masa, pa tikɔ sendi nyɛ kɛ sew kɔ. Kandɛ ndana mi ta timɔ mɛnɛti linje njuku te ɓu̧ kimɔ mɛnɛti gwaɗye kɛte, ");
INSERT INTO kkj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","simande kɛ sew te ɛ nje kɔ, a yakama wumɔ. Ŋgɛ ti ɓɛ ɗete na, wɛ ta pɛsɔ nyɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wɛtɛ yesɔ Yesus ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ wɛtɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ yesɔ *Saba. ");
INSERT INTO kkj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wɛtɛ nyari ɓa̧ womɛte nɛ kɔsu yi wɛtɛ ɓeya sisiŋ nya nyɛ kɛ́. Kɔsu te mɛ kɛ mɛsew kamɔ jɔ yitan jɔ yitati. Nya te ɓa̧ nɛ ŋgundɛŋ. A tì ɓɛ nɛ ɗeti te yi tɛmbiɗye yotu na. ");
INSERT INTO kkj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kɛ Yesus ma ɓɛŋɛ nyɛ kɛ́, ɛ nyɛ jeɓa nyɛ lɛpɔ nyɛ nyɛ nde: «Nyari, kɔn yɔ siyma.» ");
INSERT INTO kkj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ɛ Yesus kasɛ mɛɓɔ kɛ yotu nɛ, ɛ nyari tɛmbiɗye yotu ndana ndana kɛ kiya mbɛy kandɛ luksa Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kɛ mɔ te ɛ ɗiyɛ nɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɔ ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ wokɛ ŋgambi ɓuɗyate, kɛto Yesus siɗya kɔn kɛ yotu mumɔ kɛ yesɔ Saba. Ɛ nyɛ lɛpɛ nyɛ ŋgil ɓomɔ nde: ‹Ɓomɔ yâkaŋgwɛ kelɔ mɛsay kɛ mɛtu yitan jɔ wɛtɛ. Kɛ mɛtu te yite, wunɛ yâkaŋgwɛ nje, nɛ́ ɓo siɗyɛ mɛkɔn mun, yeti kɛ yesɔ Saba na.› ");
INSERT INTO kkj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɛ Nyaŋgwɛ Kumande yeŋsa nyɛ nyɛ nde: «Wunɛ ɓotu ɓe likisi, kɛ njoka yun hɛnɛ, ’nda ti wúnja nday ho tofu wenɛ, punjɛ kɛ̀ nyɛ nyɛ mɔrɔku kɛ yesɔ Saba kɔ? ");
INSERT INTO kkj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma nya kɔ, nyɛ nday Abaraham. *Satan ma nyɛ nyɛ kɔn kɛ yotu mɛ muka mɛsew kamɔ jɔ yitan jɔ yitati. ’Ti yaka nde, mi sîɗyikwɛ kɔn nɛ kɛ yesɔ Saba na?» ");
INSERT INTO kkj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ lɛpɔ ɗete kɛ́, ɛ njɔn ɓiye ɓotu ɓete ɓe ɓa̧ kɛ nyɛ mɛso nɛ nyɛ ɓaka. Yasi wɛtɛ, ŋgil ɓomɔ hɛnɛ ɓa̧ nɛ mɛsosa kɛ nyaŋgwɛ mɛkele hɛnɛ te yi Yesus ɓa̧ kɛ kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus ka̧ mbɔmbu lɛpɔ nde: «*Kandɔ Njambiyɛ nda ŋge? Mi ta yekɔ yo nɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yo nda kwalɔ wɛtɛ mɔnɔ mbumɔ nde mutar yi wɛtɛ mumɔ ɓoŋma kɛ̀ ɓɛ kɛ ŋgwaŋ nɛ kɛ́. Yo loma ɗɔkɔ ɓɛ nyaŋgwɛ jeti. Ɛ ɓenɔn nje sumɔ mɛtu̧ man kɛ mɛɓɔ mɛte joŋna kɛte.» ");
INSERT INTO kkj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nde: «Mi ta yekɔ sendi *Kandɔ Njambiyɛ nɛ ŋge? ");
INSERT INTO kkj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yo nda mɔnɔ ŋga̧ kelna mampa yi nyari ɓu̧ saŋgwɛ nɛ su farin yaka loŋga yitati. Mɔnɔ ŋga̧ te ta kelɔ nde, mbɔrɔ farin yinɔri hɛnɛ sîki wuɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus ka̧ mɛɗya mɛɗya, kɛ nyaŋgwɛ mɛɗya nɛ̀ kɛ mɔnɔ mɛɗya. A ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kwa̧ nɔ kɛ̀ nɔ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɛ wɛtɛ mumɔ diyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ’yite nde, ɓotu ɓete ɓe ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo ɓaka ti ɓuyɔ na?» Ɛ nyɛ yeŋsa nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Wunɛ nyɛ̂ki sosu yun hɛnɛ yí sa̧ nje te yi nyiŋɛ nɛ ɓolkoko numɛy. Mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Ɓomɔ ɓuɗyate ta sa̧ nje te yi nyiŋɛ. Ko ɓɛkɔ ɗete, ɓo tí nyiŋɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Komɛ sa tu̧ ta tɛmɛ ɗiɓɔ numɛy kɛ́, wunɛ ta tika kɛ sɛ̧. Wunɛ má kandɛ ɗuŋgwa numɛy lɛpɔ nde: ‹Nyaŋgwɛ Kumande, ɓuta numɛy nyɛ wusɛ.› Yasi wɛtɛ, a ta yeŋsa nyɛ wunɛ nde: ‹Mi yeti kɛ duwɛ mbɛy komɛ wunɛ wulɛ nje nɔ kɛ́ na.› ");
INSERT INTO kkj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Komɛte, wunɛ má nje kandɛ lɛpinate nyɛ nyɛ nde: ‹Wɛ ɗyenama hɔɓiye mɛnjam sinɛ wunɛ. Ɛ wɛ teɗye sendi ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mɛsɛ̧ musu.› ");
INSERT INTO kkj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A má nje yeŋsa nyɛ wunɛ nde: ‹Mi lɛ́pi nyɛ wunɛ nde: Mi yeti kɛ duwɛ mbɛy komɛ wunɛ wulɛ nje nɔ kɛ́ na. Wunɛ ɓomɔ hɛnɛ ɓe kelɛ yasi kɔtute ɓaka, wunɛ lɔ̂ndu kɛ kɛki mbɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Komɛ ɓo ta ɓu̧ wunɛ ɓetɛ kɛ sɛ̧ kɛ́, wunɛ ta ɗiyɔ mate ɓɛŋɛ Abaraham nɛ̀ Isak nɛ̀ Yakɔp nɛ̀ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ kɛ *Kandɔ Njambiyɛ. Komɛte, wunɛ ta lelɔ pukile mɛsu̧. ");
INSERT INTO kkj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yasi wɛtɛ, ɓomɔ ta wulɛ pulɔ komɛ yesɔ pundɛ nɛ̀ pulɔ komɛ yesɔ ɓalɛ. Ɓo ta wulɛ ŋgari, wulɛ njɛmbɔ nje ɗiyɔ ɗyena kɛ *Kandɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ɗete, ɓaŋa ɓotu ɓe njimɛ ta nje ɓɛ bosa ɓomɔ. Sendi, ɓaŋa bosa ɓomɔ má nje ɓɛ ɓotu ɓe njimɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kɛ kiya ŋgimɔ te ɛ ɓaŋa *Ɓefarisɛ̧ nje kɛ kɛki Yesus lɛpɔ nyɛ nyɛ nde: «Jisa waka, kwaŋgɔ lɔndɔ, kɛto kumande Herod kɛ kwaɗyɛ wo wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Wunɛ kɛ̂n lɛpɔ nyɛ kwɛ̧ ɛnɔru nde: ‹Mi kɛ soŋɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ, siɗyɛ mɛkɔn kandɛ muka kumɔ nɛmɛnɔ. Kɛ mɛtu yitati má nje siɗyɛ mɛsay mɛmbɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko ɓɛkɔ ɗete, mi yâkaŋgwɛ kɛ̀ nɛ kɛndi mbɛ mbɔmbu kandɛ muka kumɔ nɛmɛnɔ nje ɓu̧ kɛ kɔŋ nɛmɛnɔ, kɛto ɓo ti yaka wo mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ wɛtɛ mbɛy na, ndi kɛ Yerusalɛm.» ");
INSERT INTO kkj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nde: «Yerusalɛm, Yerusalɛm, wɛ ɛ ɗiki wo ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, lu̧ ɓotu ɓete ɓe Njambiyɛ tomɛ njesɛ kɛ yɔ ɓaka nɛ mɛtari wo! Mi kwaɗya wesiɗye ɓɔnɔ ɓɔ nda yi gway kuɓɛ gukule nɛ ɓɔnɔ ɓenɛ kɛ nji̧ mɛpapɔ mɛnɛ kɛ́. Ko ɓɛkɔ ɗete, wunɛ tì kwaɗyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ndana wunɛ ta tika nɛ tu̧ ɗyun gboŋgote. Yasi wɛtɛ, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ tí ɓɛŋɛ se mi na kumɔ komɛ wunɛ ta duwɛ lɛpɔ nde: ‹Mɛkombila nɛ yɔkɔ ɛ nje nɛ ɗinɔ Baba Mbokɔ kɔ!› » ");
INSERT INTO kkj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wɛtɛ yesɔ *Saba ɛ Yesus nyiŋɛ kɛ tu̧ wɛtɛ kum *Ɓefarisɛ̧ yí kɛ̀ ɗyena. Ɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ɗiki pɛmɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yaka nɔ, wɛtɛ mbam te ɛ ɓa̧ kɛ kɔnɔ nɛ ŋgbelele kɔ ɓa̧ womɛte kɛ mbɔmbu Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ɛ Yesus diyɛ nyaŋgwɛ ɓotu ɓe duwa̧ mɛmboŋga nɛ̀ Ɓefarisɛ̧ nde: «’Yo ka kimɔte nde, mumɔ sîɗyikwɛ kɔn mumɔ kɛ yesɔ Saba?» ");
INSERT INTO kkj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɛ ɓo ɗiyɛ nɛ sɛm kinɛ yeŋsa yaŋa na. Ndana, ɛ Yesus sambile ɓɔ kpokɛ nɛ mbam kɔ siɗyɛ kɔn nɛ lɛpɔ nyɛ nyɛ nde, a kwâŋ. ");
INSERT INTO kkj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Kɛ njoka yun ɓe ɗiyɛ waka ɓaka, nda yakama ɓɛŋɛ nɛ misi nde, mɔnɔ wenɛ ho taɓɔ wenɛ ɓalma kɛ mɔy guka kɛ yesɔ Saba, a má ɗiyɔ kinɛ ɓiye nyɛ saɓɛ ɓekɛ ɓekɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɓo tì yeŋsa sendi yaŋa nyɛ nyɛ kɛ diyan te yite na. ");
INSERT INTO kkj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kɛ kɔŋte, ɛ Yesus ɓɛŋɛ nde, ɓotu ɓete yi ɓo jeɓama nde, ɓo njâki ɗyena ɓaka kɛ sawɛ bosa mɛmbɛy. Ɛ nyɛ nyɛ ɓo kanɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ŋgɛ mumɔ kelɛ jesɔ gwaki jeɓa wɛ nde: Inja ɗiyɔ kɛte, wɛ tî ɗiy kɛ bosa mbɛy na, simande ɓo jeɓama wɛtɛ mɔ te ɛ kwaŋma wɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wɛ tî ɗiy kɛ bosa mbɛy na, kambɔ ma mɔ te ɛ jeɓama wunɛ hɛnɛ yiɓa kɔ mɛ nje lɛpɔ nyɛ wɛ nde: ‹Tɛma, nyɛ mbam te yɔkɔ mbɛy,› yite njɔn ta ɓiye wɛ komɛ wɛ ta tɛmɛ kɛ̀ ɗiyɔ kɛ mbɛy te yi njimɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yo nde, ŋgɛ mumɔ jeɓa wɛ kɛ jesɔ, kwaŋgɔ yɔ kɛ̀ ɗiyɔ kɛ mbɛy te yi njimɛ, simande komɛ mɔ te ɛ jeɓama wɛ kɔ ta nje kɛ́, a ta lɛpɔ nyɛ wɛ nde: ‹Sɔ mbɛ, kɛn ɗiyɔ mbɔmbu,› yite ta nyɛ wɛ mɛluksa kɛ misi mɛ ɓomɔ hɛnɛ ɓe wúnɛ ɓo ta ɗyena ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yo nde: Mumɔ hɛnɛ ɛ ɓendiɗye yotu kɛnjɛ kwey, ɓo ta piɗyɛ nyɛ kɛnjɛ nji̧. Yasi wɛtɛ, yɔkɔ ɛ piɗyɛ yotu nɛ kɛnjɛ nji̧, ɓo ta ɓendiɗye nyɛ kɛnjɛ kwey.» ");
INSERT INTO kkj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ mɔ te ɛ jeɓama nyɛ kɔ nde: «Ŋgɛ wɛ kelɛ mɛɗye yí jeɓa nɛ ɓomɔ kɛ ɓembe yesɔ ho ɓekoko, wɛ tî jeɓaŋgwɛ ɓesɔ ɓɔ ho ɓemɔŋ ho ɓejaɗyɛ ɓɔ ho ɓotu ɓe kusuku ɓe ɗiyɛ kɛ kɛki yɔ ɓaka na, kambɔ ɓo mɛ nje jeɓa sendi wɛ wɛtɛ yesɔ yí yɔkiɗye kiya yasi te yi wɛ kelma nyɛ ɓo kɛ́ nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yasi wɛtɛ, ŋgɛ wɛ kelɛ jesɔ yí jeɓa nɛ ɓomɔ nɛ mɛɗye, jeɓaŋgwɛ buka ɓomɔ, jeɓa ɓotu ɓe kɔsu nɛ̀ ɓotu ɓe ndɛmbil nɛ̀ ɓotu ɓe ɗiɓina misi. ");
INSERT INTO kkj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ŋgɛ wɛ kelɛ ɗete, wɛ ta ɓɛ nɛ mɛsosa, kɛto ɓo tí ɓɛ nɛ yasi te yi ɓo ta yɔkiɗye nɔ nyɛ wɛ na. Yo ndi nde, Njambiyɛ ta yɔkiɗye yo nyɛ wɛ kɛ yesɔ te yi ŋgbeŋ ɓomɔ ta womiyɛ nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kɛ wɛtɛ mɔ te yi ɓenɛ ɓe Yesus ɓa̧ kɛ ɗyena kɔ ma wokɔ mɛlɛpi mɛte yi Yesus lɛpima kɛ́, ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Mɔ te ɛ ta ɗyena kɛ *Kandɔ Njambiyɛ kɔ nɛ mɛsosa.» ");
INSERT INTO kkj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Wɛtɛ mbam komsama ɓuɗya mɛɗye yí jeɓa nɛ ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɛ ŋgimɔ mɛɗye ma ɗya̧ kɛ́, ɛ nyɛ tomɛ mɔ mɛsay wenɛ kɛ̀ jeɓa nɛ ɓotu ɓete ɓe nyɛ jeɓama ɓaka yí lɛpɔ nyɛ ɓo nde: ‹Wunɛ njâki, kɛto mɛyasi hɛnɛ mɛgweya̧ kombilate.› ");
INSERT INTO kkj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yasi wɛtɛ, mumɔ hɛnɛ kɛ njoka yan lɛpima ndi nda jakɔsɔ nde, ɓo ɓɛ̂ŋa nyɛ nɛ ŋgwɛtɛ, kɛto a ti yaka kɛ̀ na. Bosa mumɔ lɛpima nyɛ mɔ mɛsay nde: ‹Mi ɓɔmma yiŋa pɛl mɛnɛti, yo kɛ diyɛ nde, mi kɛ̂n kɛ̀ ɓɛŋɛ yo, ɗete ɓɛŋa mi nɛ ŋgwɛtɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɛ wɛtɛ lɛpɛ nɛ nde: ‹Mi ɓɔmma ɓenday kamɔ yi mɛsay, mi kɛ kɛ̀ ɓoɓɛ ɗeti yan, ɗete ɓɛŋa mi nɛ ŋgwɛtɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mbaŋa nja̧ lɛpɔ nɛ nde: ‹Mi ɓóŋ nyari ndi kwey kwey, ɗete mi ti yaka kɛ̀ na.› ");
INSERT INTO kkj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ɛ mɔ mɛsay kɔ yɔkwɛ kɛ̀ yekiɗye mɛyasi mɛte yi kwaŋnama kɛ́ nyɛ masa wenɛ. Ndana, ɛ masa wokɛ ŋgambi ɓuɗyate. Ɛ nyɛ nje lɛpɔ nyɛ mɔ mɛsay wenɛ nde: ‹Kɛn nɛdɔ kɛ nyaŋgwɛ sɛ̧ nɛ̀ kɛ ɓoku mɛnje kɛ mɔy ɗya, nɛ̀ wɛ ɓôŋ buka ɓomɔ nɛ̀ ɓotu ɓe kɔsu nɛ̀ ɓotu ɓete ɓe nɛ ɗiɓina misi ɓaka nɛ̀ ɓotu ɓe ndɛmbil nje nɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mɔ mɛsay ka̧ yɔkwɛ nje lɛpɔ nyɛ masa wenɛ nde: ‹Mi ma kelɔ nda yi wɛ lɛpima nyɛ mi kɛ́, yasi wɛtɛ, mɛmbɛy ndi kɛte.› ");
INSERT INTO kkj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ndana, ɛ masa lɛpɛ nyɛ mɔ mɛsay te nde: ‹Kɛn kɛ ɓoku mɛnje, nɔ̀ gôŋgilaŋgwɛ nɛ mɛndoko, nɔ̀ kêl nde, ɓomɔ njâki, nɛ́ tu̧ ɗyembɛ tondu.› ");
INSERT INTO kkj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yasi wɛtɛ, mi kɛ lɛpɔ nyɛ wunɛ nde: Kɛ ɓɛ bosa ɓotu ɓete ɓe mi jeɓama ɓaka, wɛtɛ nɛ wɛtɛ tí kpokɛ mɛɗye mɛmbɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyaŋgwɛ ŋgil ɓomɔ ɓa̧ kɛ kɛndɔ ɓenɛ ɓe Yesus. Ɛ nyɛ yeŋsa ɓɛŋɛ ɓo lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ŋgɛ mumɔ nje kɛ yembɛ, na ɓɛ jekɛ wombɛ, a sôŋa temɔ kɛ yotu saŋgwɛ ɓenɛ nyaŋgwɛ, soŋɛ temɔ kɛ yotu nyari ɓenɛ ɓɔnɔ nɛ̀ kɛ yotu ɓemaŋ ɓe ɓembam nɛ̀ ɓeɗyɔmbu, soŋɛ sendi temɔ kɛ joŋgwɛ ɗyenɛ nɛ ŋguru wenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sendi, ŋgɛ mumɔ ti soɓɛ kroa nɛ ɓeŋgwɛ mi na, mɔ te ti yaka ɓɛ jekɛ wombɛ na, kɛto ");
INSERT INTO kkj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","nda kɛ njoka yun, ŋgɛ nyɛ kwaɗyɛ sumɔ doŋgbe doŋgbe tu̧, a má ɗiyɔ kinɛ pa nɛmbɛ yí duwɛ yasi te yi nyɛ yakama kwaŋɗye, yí ɓɛŋɛ, simande a nɛ ɓuyɔ sumba yí siɗyɛ nɛ mɛsay mɛte kɔ? ");
INSERT INTO kkj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A ta pa kelɔ ɗete, ma nje ɓɛ nde, a kânda mɛsay kinɛ nje ɓɛ se nɛ ɗeti te yi siɗyɛ na. Ŋgɛ nyɛ kelɛ ɗete, ɓomɔ hɛnɛ ɓe ta ɓɛŋɛ ɓaka ta nyɛtɔ nyɛ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Mbam te yɔkɔ kandima njumɔ nje suɗyɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ɗete sendi, yo kumande te nda, ŋgɛ nyɛ kɛ̀ kɛ lu̧ ɗyambi nɛ wɛtɛ kumande, a má ɗiyɔ kinɛ pa nɛmbɛ yí ɓɛŋɛ, simande a yakama ɓu̧ ɓesɔja tomay kamɔ kɛ̀ lu̧ ɗyambi nɛ yɔkɔ ɛ nɛ ɓesɔja tomay kaɓa kɔ? ");
INSERT INTO kkj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ŋgɛ nyɛ ɓɛŋɛ nde, yo ti yaka na, a má tomɔ ɓomɔ kɛ ŋgimɔ te yi yɔru ndi lɔndunate kɛ́ kɛ̀ lɛpɔ nyɛ nyɛ nde, ɓo kêl mbon, nɛ́ ɓo ɗiy nɛ tɛ. ");
INSERT INTO kkj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɗete sendi, ŋgɛ mumɔ hɛnɛ kɛ njoka yun ti soŋɛ temɔ kɛ mɛyasi hɛnɛ te yi nyɛ nɔ kɛ́, mɔ te ti yaka ɓɛ jekɛ wombɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Yo gbate nde, kwa kimɔ yasi. Ko ɓɛkɔ ɗete, ŋgɛ kwa si lenjɔ, ɓo ta kelɔ nan nje yɔkiɗye nɛ somte? ");
INSERT INTO kkj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yo tí kelɔ se nde, mɛnɛti ho kundu jôŋgwɛ mbɛki na. Ɓo ɓóŋ yo li̧ kɛ sɛ̧. Mɔ te ɛ nɛ mɛtɔ te yí wokɔ nɛ pɛ̧, a wôku!» ");
INSERT INTO kkj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɓotu ɓe ɓoŋna mɔni garama hɛnɛ nɛ̀ ɓotu ɓe mɛɓeyɔ ɗikima nje kɛ kɛki Yesus yí nje wokɔ mɛlɛpi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Ɓefarisɛ̧ nɛ̀ ɓotu ɓe kɛtina mɛyasi nyiŋgilama lɛpɔ nde: «Mbam kɔ kɛ ɓu̧ ɓotu ɓe mɛɓeyɔ nɛ mɛsosa, kwa̧ ɗyena sendi ɓenɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yasi wɛtɛ, ɛ Yesus nyɛ ɓo kanɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Kɛ njoka yun, ŋgɛ wɛtɛ mumɔ ɓɛ nɛ ɓesam gɔmay, ŋgɛ wɛtɛ ɗimbiyɛ, a kél nan? ’A ti páŋ tikɔ ɓesam kamɔtan jɔ kamɔni jɔ yitan jɔ yini te ɓari kɛ mbɛy mɛɗye kwa̧ kɛ̀ sa̧ yɔkɔ ɛ ɗimbiya kɔ kumɔ kɛ ŋgimɔ te yi nyɛ dolɛ nyɛ kɛ́ na? ");
INSERT INTO kkj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Komɛ nyɛ si dolɔ nyɛ kɛ́, ’a ti sóɓa nyɛ nyɛ kɛ ɓɛkɔ nɛ nɛ mɛsosa na? ");
INSERT INTO kkj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kɛ nyɛ yɔkwɛ kumɔ tu̧, a má jeɓa ɓesɔ ɓenɛ nɛ̀ ɓembam ɓete ɓe ɗiyɛ kɛ kɛki nɛ ɓaka lɛpɔ nyɛ ɓo nde: ‹Wusɛ sôsaŋgwɛ, kɛto mi dolma sam wombɛ ɛ ɗimbiya kɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi kɛ lɛpɔ nyɛ wunɛ nde: Ɗete sendi, mɛsosa ɓɛ́ki ɓuɗyate kɛ ɗyoɓɔ, kɛto mɔ mɛɓeyɔ wɛtɛ ɛ yeŋsa temɔ kɔ. Mɛsosa mɛte kwa̧ yikɛ yi ɓɛŋna kɛto ɓomɔ kamɔtan jɔ kamɔni jɔ yitan jɔ yini ɓe nɛ ŋgbeŋ ɓe yeti kɛ diyɛ nde, ɓo yêŋsaŋgwɛ temɔ ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Ho nde, ŋgɛ wɛtɛ nyari ɓɛ nɛ sule kamɔ, ŋgɛ wɛtɛ ɗimbiyɛ, a kél nan? A kwénja lambo wɔmbile tu̧ sa̧ kimɔte kumɔ kɛ ŋgimɔ te yi nyɛ dolɛ yo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Komɛ nyɛ si dolɔ kɛ́, a má jeɓa ɓesɔ ɓenɛ nɛ̀ ɓoma ɓete ɓe ɗiyɛ kɛ kɛki nɛ ɓaka lɛpɔ nyɛ ɓo nde: ‹Wusɛ sôsaŋgwɛ, kɛto mi dolma sule wombɛ ɛ ɗimbiya kɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ɗete sendi, mi kɛ lɛpɔ nyɛ wunɛ nde: Ɓejaki ɓe Njambiyɛ wóku mɛsosa ɓuɗyate, ndi kɛto mɔ mɛɓeyɔ wɛtɛ ɛ yeŋsa temɔ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ɛ Yesus lɛpɛ sendi nde: «Wɛtɛ mbam ɓa̧ nɛ ɓɔnɔ ɓembam yiɓa. ");
INSERT INTO kkj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɛ ndɛmbi te lɛpɛ nyɛ saŋgwɛ nde: ‹Saŋmbɛ, nyɛkɔ mi ŋgaɓiyɛ mɛyasi mɛte yembɛ.› Ɛ saŋgwɛ wan kaɓɛ mɛyasi mɛte yi nyɛ ɓa̧ nɔ kɛ́ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mɔnɔ mɛtu kwaŋma kɛ kɔŋte nɛ mbɛt, ɛ ndɛmbi te dokɛ mɛyasi mɛnɛ hɛnɛ kwa̧ kɛ̀ lɔndunate kɛ wɛtɛ mɛnɛti. Kumɔ mate, ɛ nyɛ si kwaŋɗye kusuku nɛ kɛ nyɛm nyɛm joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kɛ nyɛ ma si kwaŋɗye yo ɗete kɛ́, yaka nɔ, nyaŋgwɛ kolɔ kɛ ɗya̧ kɛ mɛnɛti mɛte, ɛ yasi hɛnɛ kandɛ ɓanna nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛ nyɛ kwa̧ kɛ̀ diyɛ mɛsay kɛ ɓɔ wɛtɛ mbam mate. Ɛ mbam te kɛnjɛ nyɛ kɛ ɓakiɗya ɓeaɓem ɓenɛ kɛ mɔy lɔ̧. ");
INSERT INTO kkj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mɔnɔ mbam kɔ gɔruma ɗye mɛmbumɔ mɛte yi ɓeaɓem ɗikima ɗye kɛ́. Ko ɗete, mumɔ wɛtɛ nɛ wɛtɛ tì nyɛ nyɛ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ndana, ɛ nyɛ kandɛ takina yasi lɛpɔ kɛ mɔy temɔ nɛ nde: ‹Ɓotu ɓe mɛsay ɓe saŋmbɛ hɛnɛ nɛ ɓuɗya mɛɗye kwa̧ to te, mi mbɛ waka kɛ gwe nja. ");
INSERT INTO kkj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi ta tɛmɛ yɔkwɛ kɛ̀ pɛ yi saŋmbɛ. Mi ta lɛpɔ nyɛ nyɛ nde: Saŋmbɛ, mi ma kelɔ ɓeyate ɓuɗyate kɛ mbɔmbu Njambiyɛ nɛ̀ kɛ mbɔmbu wɔ. ");
INSERT INTO kkj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wɛ ti yaka jeɓa se mi nde mɔnɔ wɔ na. Kelɔ nɛ mi nda yi wɛ kelɛ nɛ wɛtɛ mɔ mɛsay wɔ kɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kɛ kɔŋte, ɛ nyɛ tɛmɛ yí yɔkwɛ kɛ̀ pɛ yi saŋgwɛ. «A ɓa̧ ndi lɔndunate, ɛ saŋgwɛ ɓɛŋɛ nyɛ gwe ŋgwɛtɛ wenɛ sɛɗyɛ kɛ̀ wuse nyɛ kwa̧ dulɔ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɛ mɔnɔ lɛpɛ nyɛ nyɛ nde: ‹Saŋmbɛ, mi ma kelɔ ɓeyate ɓuɗyate kɛ mbɔmbu Njambiyɛ nɛ̀ kɛ mbɔmbu wɔ. Wɛ ti yaka jeɓa se mi nde mɔnɔ wɔ na.› ");
INSERT INTO kkj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ko ɓɛkɔ ɗete, saŋgwɛ lɛpima nyɛ ɓotu ɓe mɛsay ɓenɛ nde: ‹Wunɛ njâki nɛdɔ nɛ lambɔ te ɛ laŋma nyɔŋɔ kwa̧ ɓɛsɔ kɔ nje lɛnje nyɛ. Wunɛ nyɛ̂ki bolo kɛ ɓɔ nɛ, lɛnje sendi nyɛ mɛnakala kɛ mɛkol. ");
INSERT INTO kkj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wunɛ kɛ̂n ɓu̧ mɔnɔ nday te ɛ nɛ mutɔ kɔ nje wo. Wusɛ ɗyênaŋgwɛ, nɛ̀ wusɛ sôsaŋgwɛ, ");
INSERT INTO kkj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kɛto mɔnmbɛ kɔ gwa̧, ndana a womiya. A ɗimbiya, ndana hɛ dolma nyɛ.› Ɛ ɓo kandɛ jesɔ. ");
INSERT INTO kkj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Kɛ ŋgimɔ te yite tomba te ɓa̧ kɛ ŋgwaŋ. Kɛ nyɛ ma yɔkwɛ wuta nɛ tu̧ kɛ́ a wóku ɓomɔ kɛ mɛndɛ mɛndumɔ ɓɔlɔ jesɔ. ");
INSERT INTO kkj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɛ nyɛ jeɓa wɛtɛ mɔ mɛsay diyɛ nyɛ nde: ‹Ŋge yi kwaŋna woŋga kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: ‹Mɔŋ yɔkwa̧, ɗete sɔŋgwɛ woma mɔnɔ nday te ɛ nɛ mutɔ kɔ, kɛto mɔnɔ ɗyaŋma nɛ tɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tomba mɔy wokuma ŋgambi kinɛ kwaɗyɛ nyiŋɛ tu̧ na. Ɛ saŋgwɛ pundɛ kɛ̀ ŋgwɛta nɛ nyɛ nde, a nyîŋa tu̧. ");
INSERT INTO kkj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ɛ nyɛ nje lɛpɔ nyɛ saŋgwɛ nde: ‹Pa ɓɛŋɛ, mi kɛ kelɔ mɛsay nyɛ wɛ waka ɓuɗya mɛsew. Mi tì yɛliyɛ yiŋa lɛpi kɛ numbu yɔ wɛtɛ yesɔ na. Ko gbɛla mɔnɔ taɓɔ wɛtɛ nɛ wɛtɛ, wɛ tì nyɛ mi nde, mi wôku ɗye sosa nɔ sinɛ ɓesɔ ɓembɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ɓɛŋa nde, mɔnɔ wɔ ɛ ma sambɔ mɛyasi mɔ ɓenɛ ɓoma ɗyaŋma kɛ́, wɛ kɛ nje wo mɔnɔ nday te ɛ nɛ mutɔ kɔ nyɛ nyɛ ɗye.› ");
INSERT INTO kkj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɛ saŋgwɛ lɛpɛ nyɛ nyɛ nde: ‹Mɔnmbɛ, sinɛ wɛ waka mɛtu hɛnɛ. Mɛyasi hɛnɛ te yi mi nɔ, yo yɔ. ");
INSERT INTO kkj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yasi wɛtɛ, yakama nde, wusɛ sôsaŋgwɛ kelɔ jesɔ, kɛto mɔŋ kɔ gwa̧, ndana a womiya. A ɗimbiya, ndana hɛ dolma nyɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus ka̧ mbɔmbu lɛpɔ nyɛ ɓejekɛ ɓenɛ nde: «Wɛtɛ mumɔ ɓa̧ nɛ kusuku ɓuɗyate. A ɓa̧ nɛ mɔ ɓakiɗya kusuku nɛ. Ɛ ɓomɔ nje lɛpɔ nyɛ nyɛ nde, mɔ ɓakiɗya kusuku nɛ kɛ sambɔ yo. ");
INSERT INTO kkj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɛ nyɛ jeɓa nyɛ lɛpɔ nde: ‹Yo kwalɔ yasi te nda yi mi wokɛ ɓomɔ lɛpɛ nɛ ɗinɔ ɗyɔ kɛ́? Lɛpɔ kasi mɛsay mɛ ɓakiɗya kusuku mbɛ yi wɛ kelma kɛ́, kɛto wɛ tí kɛ̀ se mbɔmbu yí kelɔ mɛsay mɛte na.› ");
INSERT INTO kkj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ɛ mɔ ɓakiɗya kusuku kɔ lɛpɛ kɛ mɔy temɔ nɛ nde: ‹Mi ta kelɔ nan, kɛto masa wombɛ kɛ soŋɛ mi kɛ mɛsay mɛ ɓakiɗya kusuku nɛ. Mi yeti nɛ ɗeti te yi putike mɛnɛti na. Njɔn jɔmbuna yasi kɛ ɓɔ ɓomɔ kɛ kelɔ mi.› ");
INSERT INTO kkj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɛ nyɛ lɛpɛ nde: ‹Mi duwa̧ nda yi mi ta kelɔ, nɛ́ ɓomɔ ɓu̧ nɛ mi kimɔte kɛ mɛtu̧ man komɛ ɓo ta soŋɛ mi kɛ mɛsay kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ndana, ɛ nyɛ jeɓa mumɔ hɛnɛ ɛ ɓa̧ nɛ yaŋa ɓenɛ masa wenɛ kɔ. Ɛ nyɛ diyɛ bosa mumɔ nde: ‹Wúnɛ masa wombɛ nɛ niŋgɔ?› ");
INSERT INTO kkj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɛ mbɛte yeŋsa nyɛ nyɛ nde: ‹Nyaŋgwɛ mɛmbe mɛmutɔ gɔmay.› Ɛ mɔ ɓakiɗya kusuku lɛpɛ nyɛ nyɛ nde: ‹Ɓoŋgɔ mɛkana mɔ ɗiyɔ mɛtiɗyɛ nɛdɔ kɛtɔ nde, yo kamɔtan.› ");
INSERT INTO kkj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kɛ kɔŋte, ɛ nyɛ diyɛ wɛtɛ sendi nde: ‹Yɔ ɓa niŋgɔ?› Ɛ nyɛ yeŋsa nde: ‹Makɔ yombo gɔmay.› Ɛ mɔ ɓakiɗya kusuku lɛpɛ nyɛ nyɛ nde: ‹Ɓoŋgɔ mɛkana mɔ kɛtɔ nde, yo kamɔtan jɔ kamɔtati.› ");
INSERT INTO kkj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɛ masa ɓeya mɔ ɓakiɗya kusuku kɔ jayɛ nyɛ kɛto jɛŋ te yi nyɛ kelma kɛ́.» Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nde: «Ɓotu ɓe mɛnɛti ɓaka nɛ jɛŋ kelna mɛkele suŋgwɛ nɛ ɓenjɔŋ ɓan kwa̧ ɓotu ɓete ɓe ɓeŋgwɛ mɛyasi mɛ Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ ɓôŋ gbɛla mɛyasi mɛ mɛnɛti maka ɓiye nɛ sɔ wúnɛ ɓomɔ, yaka nɔ, komɛ mɛyasi mɛte ta ɓanɔ wunɛ kɛ́, Njambiyɛ ta ɓu̧ wunɛ tikɔ kɛ mbɛy te yi wunɛ ta ɗiyɔ kɛte kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kɛto mɔ te ɛ duwɛ ɓakiɗye mɔnɔ yasi, a yakama duwɛ ɓakiɗye sendi nyaŋgwɛ yasi. Yɔkɔ ɛ seɓile mumɔ kɛ mɔnɔ yasi, a ta seɓile sendi mumɔ kɛ nyaŋgwɛ yasi. ");
INSERT INTO kkj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ɗete, ŋgɛ ɓɛ nde, wunɛ tì duwɛ ɓakiɗya gbɛla mɛyasi mɛ mɛnɛti maka na, nda má nje kaŋɛ sulna mɛyasi nyɛ wunɛ nde, wunɛ ɓâkiɗya? ");
INSERT INTO kkj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ŋgɛ ɓɛ nde, wunɛ tì duwɛ ɓakiɗya yasi mumɔ na, nda má nje nyɛ wunɛ yasi te yun kɔ? ");
INSERT INTO kkj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kiya mɔ mɛsay wɛtɛ ti yaka ɓɛ nɛ ɓemasa yiɓa na. Ho a ta ɓenɔ wɛtɛ, kwaɗyɛ mbaŋa, ho a ta wokuna nɛ wɛtɛ, yɛliyɛ mbaŋa. Wunɛ ti yaka kelɔ mɛsay mɛ Njambiyɛ, ɓeŋgwɛ sendi kasi kusuku na.» ");
INSERT INTO kkj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Ɓefarisɛ̧ ɓa̧ kɛ wokɔ mɛlɛpi mɛnɔri hɛnɛ. Ɛ ɓo yisɛ Yesus, kɛto ɓo ɓa̧ nɛ kwaɗya mɔni ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun kɛ ɓu̧ yotu yun kɛ misi mɛ ɓomɔ nde, wunɛ nɛ ŋgbeŋ. Yasi wɛtɛ, Njambiyɛ duwa̧ yasi te yi kɛ mɔy mɛtemɔ mun kɛ́. Wunɛ dûkwɛ nde, yasi te yi ɓomɔ lukse kɛ́, Njambiyɛ ɓɛ́ŋa yo nda ɓi̧ kɛ misi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́ nɛ̀ mɛlɛpi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ ɗiyma kumɔ kɛ ŋgimɔ te yi Jaŋ te mɔ tɔpuna ɓomɔ kɛ mɔrɔku. Kɛ kɔŋte, kandɛ kɛ ŋgimɔ te yite, ɓo kɛ lɛpɔ Kimɔ Tom kɛ kasi *Kandɔ Njambiyɛ. Ndana mumɔ hɛnɛ kɛ suŋna, na nyiŋ kɛte nɛ ɗeti hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wunɛ dûkwɛ nde, ɗyoɓɔ nɛ̀ mɛnɛti yakama yambile nɛdɔ. Yasi wɛtɛ, kinɛ mɔnɔ yaŋa nɛ mbɛt yakama ɗuwɛ kɛ mɛmboŋga mɛ Njambiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Mumɔ hɛnɛ ɛ soŋɛ ɓɔ nɛ nyari ɓu̧ mbaŋa, yite nyɛ mɔ kelna wanja. Sendi, mumɔ hɛnɛ ɛ ɓu̧ nya te yi njom soŋma ɓɔ nɛ nyɛ, mɔ te mɔ kelna wanja.» ");
INSERT INTO kkj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kɛ kɔŋte, ɛ Yesus yekiɗye wɛtɛ kanɔ nde: «Wɛtɛ mbam ɓa̧ nɛ ɓuɗya kusuku. A ɗikima lɛŋɛ kpasa mɛlambɔ mɛte yi ɗye ɓuɗya mɔni. A ɗikima joŋna mɛtu hɛnɛ kɛ nyɛŋgwɛ, komsa ɓuɗya mɛɗye jeɓa nɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yo ɓa̧ sendi nɛ wɛtɛ buka mumɔ nde Lasar. A ɓa̧ mɛtinɛŋgwɛ kɛ numɛy mɔ kusuku kɔ. Yotu Lasar ɓa̧ tandɛ mɛpeŋ nɛ fata fata. ");
INSERT INTO kkj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A kwaɗya ɗye mɛmbulma mɛɗye mɛte yi ɗikima ɓalɔ wulɛ kɛ teɓel mɔ kusuku kɔ kɛ́. Ko ɓembiye ɗikima nje ɗatɔ mɛpeŋ mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ɗiyɔ kɛ́, buka mɔ kɔ nja̧ gwe, ɛ ɓejaki ɓe Njambiyɛ soɓɛ nyɛ kɛ̀ tikɔ kɛ kɛki Abaraham. Mɔ kusuku kɔ nja̧ gwe sendi, ɛ ɓo pumbɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A ɓa̧ kɛ saŋgwa nɛ nyaŋgwɛ mɛbɔnɛ mate kɛ ɗya ɓemuŋ. Kɛ nyɛ ma kaŋɛ misi kɛ́, a ɓɛ́ŋa kɛnjɛ lɔndunate Lasar kɛ kɛki Abaraham. ");
INSERT INTO kkj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɛ nyɛ kembiɗya lɛpɔ nde: ‹Saŋsu Abaraham, gwakɔ ŋgwɛtɛ wombɛ. Tomɔ Lasar, a tɔ̂pa toŋ nyɛy nɛ kɛ mɔrɔku nje wɛɗye nɛ ɗyem ɗyembɛ, kɛto mi kɛ saŋgwa nɛ nyaŋgwɛ mɛbɔnɛ kɛ lam ɗitɛ te yikɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ɛ Abaraham yeŋsa nde: ‹Mɔnmbɛ, taka kimɔte. Wɛ ɓa̧ nɛ kusuku ɓuɗyate kɛ joŋgwɛ ɗyɔ, ɛ Lasar saŋgwa nɛ mɛbɔnɛ kɛ ŋgimɔ te yite. Ndana Lasar mɛ kɛ kimɔ ɗiyɔ woŋga, ma wɛ mɛ yɔ kɛ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yiŋa yasi sendi nde: Nyaŋgwɛ gboŋgo ndoŋ kɛ njoka su sinɛ wunɛ. Ɗete, ŋgɛ ɓomɔ kwaɗyɛ tɛmɛ woŋga yí kɛ̀ wɛri, ɓo ti yaka kwa̧ na. Sendi, ŋgɛ ɓomɔ kwaɗyɛ tɛmɛ wɛri nje woŋga, ɓo ti yaka saɓiyɛ na.› ");
INSERT INTO kkj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ɛ mɔ kusuku kɔ lɛpɛ nde: ‹Saŋsu, nda yo ɗete kɛ́, mi kɛ ŋgwɛta nɛ wɛ nde: Tomɔ Lasar kɛnjɛ kɛ yi saŋmbɛ, ");
INSERT INTO kkj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kɛto mi nɛ ɓemaŋ ɓembɛ yitan, na kɛ̀ lɛpi yasi te yi nyɛ ɓɛŋma nɛ misi mɛnɛ kɛ́ kimɔte nyɛ ɓo, ma ɓo nje nje sendi kɛ mbɛy nyaŋgwɛ mɛbɔnɛ mɛte yikɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ɛ Abaraham yeŋsa nde: ‹Mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́ nɛ̀ mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ mate, ɓo ɓêŋgwɛ yo.› ");
INSERT INTO kkj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ɛ mɔ kusuku lɛpɛ nde: ‹Ko na, Abaraham, saŋsu! Yo nde, ŋgɛ wɛtɛ mumɔ tɛmɛ kɛ njoka ɓotu ɓete ɓe ma gwe ɓaka kɛ̀ pɛ yan, ɓo ta yeŋsa temɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ɛ Abaraham nje lɛpɔ nyɛ nyɛ nde: ‹Ŋgɛ ɓo ti wokɛ mɛn Mɔyisi nɛ̀ mɛn ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ na, ɓo ti yaka jayɛ yiŋa yaŋa na, ko ɓɛkɔ nde, mumɔ wômkwɛ kɛ̀ lɛpɔ nyɛ ɓo.› ");
INSERT INTO kkj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kɛ kɔŋte, ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Yo gba nɛ mɛyasi mɛte yi kelɛ nde, mumɔ jâti kɛ ɓeya nje. Yasi wɛtɛ, mɛbɔnɛ ta ɓalɔ kɛ to mɔ te ɛ kelɛ nde, mɛyasi mɛte ɗyâŋ kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yo kimɔte kɛ yi mɔ te nde, ɓo ɓôŋ tari kɔkuna yasi tiŋɔ kɛ ŋgiŋ nɛ kwa̧ ɓetɛ nyɛ kɛ maŋ, laŋsa nde, a kêl yiŋa yasi te yi yakama jatiɗye ko mumɔ wɛtɛ kɛ njoka ɓɔnɔ ɓaka kɛ ɓeya nje. ");
INSERT INTO kkj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wunɛ pɛ̂m mɛkele mun nɛ ŋguru wun. Ŋgɛ mɔŋ kelɛ yiŋa ɓeya yasi suŋgwɛ nɛ wɛ, nɔ̀ ndêya nyɛ. Ŋgɛ nyɛ yeŋsa temɔ kɛ ɓeya yasi te yi nyɛ kelma kɛ́, nɔ̀ tîki nyɛ nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kɛ ndiŋgɛlɛ yesɔ wɛtɛ, ŋgɛ nyɛ kelɛ ɓeya yasi suŋgwɛ nɛ wɛ mɛŋga yitan jɔ yiɓa, ŋgɛ nyɛ nje sendi mɛŋga yitan jɔ yiɓa lɛpɔ nyɛ wɛ nde: ‹Mi yeŋsama temɔ kɛ ɓeya yasi te yi mi kelma kɛ́,› nɔ̀ tîki nyɛ nɛ ŋgwɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɛ ɓotu ɓe tomun ɓe Nyaŋgwɛ Kumande lɛpɛ nyɛ nyɛ nde: «Kelɔ nde, wusɛ tîki temɔ nɛ wɛ kwa̧ yikɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Má ɓɛki nde, tikina temɔ te yi wunɛ tikɛ kɛ yembɛ kɛ́ nyaŋgwɛte nda ɗɔkɔ mbumɔ ŋgwal lalɛ, ma wunɛ yakama lɛpɔ nyɛ jeti te yɔkɔ nde: ‹Sûtukwɛ kɛ̀ suma kɛ maŋ,› a má wokɔ mɛn yun. ");
INSERT INTO kkj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Wusɛ pâŋ pa lɛpɔ nde: Wɛtɛ mumɔ kɛ njoka yun nɛ mɔ mɛsay wenɛ ɛ putike ŋgwaŋ nɛ ho ɛ ɓakiɗye ɓetitɛr. Ŋgɛ nyɛ ɓɛŋɛ mɔ mɛsay wenɛ kɛ yɔkwɛ ŋgwaŋ, ’a má lɛpɔ nyɛ nyɛ nde: ‹Inja ɗiyɔ nɛdɔ ɗyena›? ");
INSERT INTO kkj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A ta lɛpɔ nyɛ nyɛ nde: ‹Jambinaŋgwɛ nyɛ mi, sɛnjɔ lambɔ, ɓoŋgɔ mɛɗye nje nɔ, nɛ́ mi pa ɗyena hɔɓiye mɛnjam, kɛ kɔŋte, wɛ má nje ɗyena nje hɔɓiye yɔ yɛy.› ");
INSERT INTO kkj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","’Wunɛ táka ka nde, a ta nyɛ mɔ mɛsay kɔ wosoko, kɛto a kelma yasi te yi nyɛ lɛpima nyɛ nyɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wunɛ sendi, ŋgɛ wunɛ si kelɔ yasi te yi ɓo lɛpima nde, wunɛ kêl kɛ́, nɛ̀ wunɛ njâki lɛpɔ kɛ kɔŋte nde: ‹Wusɛ gbɛla ɓotu ɓe mɛsay, hɛ kelma yasi te yi ɓa̧ nde, wusɛ kêl kɛ́.› » ");
INSERT INTO kkj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus ɓa̧ kɛ kɛ̀ kɛ Yerusalɛm. Ɛ nyɛ kwa̧ kɛ njoka mɛnɛti mɛ Samari nɛ̀ Galile. ");
INSERT INTO kkj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ nyiŋɛ kɛ wɛtɛ ɗya kɛ́, ɛ ɓaŋa ɓotu ɓe ndoko kamɔ nje saŋgwa nɛ nyɛ. Yasi wɛtɛ, ɓo tɛmma nɛ naŋ kembiɗya ");
INSERT INTO kkj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","lɛpɔ nde: «Yesus yekele, gwakɔ ŋgwɛtɛ wusu.» ");
INSERT INTO kkj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ɛ nyɛ ɓɛŋɛ ɓo lɛpɔ nde: «Wunɛ kɛ̂n kɛ̀ teɗye yotu yun nyɛ ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ.» Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ kɛ̀ kɛ́, ɛ kɔn yan siyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kɛ wɛtɛ kɛ njoka yan ma ɓɛŋɛ nde, kɔn nɛ siyma kɛ́, ɛ nyɛ yɔkwɛ nɛ kɔkɔ nɛ luksa Njambiyɛ kɛ numbu nɛ mɛn kɛ kwey. ");
INSERT INTO kkj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɛ nyɛ nje kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus nyɛ nyɛ wosoko. Mɔ te ɓa̧ mɔ Samari. ");
INSERT INTO kkj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ɛ Yesus nje lɛpɔ nde: «’Ɓo tì ɓɛ ɓomɔ kamɔ yi kɔn yan siyma kɛ́ na? Ɓomɔ yitan jɔ yini te ɓari ɓa we? ");
INSERT INTO kkj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ŋge kelɛ nde, jɛŋgwɛ te yɔkɔ nyɛpɔ yɔ̂kwɛ nɛ kɔkɔ nje lukse Njambiyɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɛ nyɛ nje lɛpɔ nyɛ mɔ Samari kɔ nde: «Tɛma, kwaŋgɔ, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɛ *Ɓefarisɛ̧ diyɛ Yesus nde: «*Kandɔ Njambiyɛ ta ɗya̧ ndenɛn?» Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Kandɔ Njambiyɛ tí ɗya̧ nɛ nje te nde, ɓomɔ ɓɛ̂ŋa na. ");
INSERT INTO kkj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɓo tí lɛpɔ nde: ‹Kandɔ Njambiyɛ waka ho wari› na. Wunɛ dûkwɛ nde, Kandɔ Njambiyɛ mɛ kɛ njoka yun.» ");
INSERT INTO kkj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɛ nyɛ lɛpɛ nyɛ ɓejekɛ nde: «Yo ta ɓɛ nɛ ŋgimɔ te yi wunɛ ta kwaɗyɛ ɗiyɔ ko nɛ mbɛt kɛ yesɔ te yi *Mɔnɔ mumɔ ta nje kɛ́. Ko ɓɛkɔ ɗete, wunɛ tí ɓɛŋɛ yesɔ te na. ");
INSERT INTO kkj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ɓomɔ ta lɛpɔ nyɛ wunɛ nde: ‹Nɛ ɓɛ̂ŋa, nyɛ waka, nyɛ wari!› Wunɛ tî kɛn na. Wunɛ tî sɛɗyikwɛ ɓeŋgwɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yo nde, njena Mɔnɔ mumɔ ta ɓɛ nda yi yɛsi mbiyɔ yesɛ nɔ nɛ vɛrum, panɔ kandɛ komɛ yesɔ pundɛ kumɔ komɛ yesɔ ɓalɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yasi wɛtɛ, a yâkaŋgwɛ saŋgwa nɛ mɛbɔnɛ ɓuɗyate. Ɓotu ɓe ŋgimɔ te yɔkɔ ta sɛŋɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yasi te yi kwaŋnama kɛ ŋgimɔ Nɔy kɛ́ ta kwaŋna sendi ɗete kɛ ŋgimɔ te yi Mɔnɔ mumɔ ta nje kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kɛ ŋgimɔ te yite ɓomɔ ɗikima ɗyena, ɗye mɛnjam, kelɔ mɛgwaki, kɛnjɛ ɓeŋgɔndu ɓan kɛ mɛgwaki kumɔ kɛ yesɔ te yi Nɔy nyiŋma nɔ kɛ mɔy nyaŋgwɛ kuka, ɛ nyaŋgwɛ mbeŋ ɗya̧ girise ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yo ta kwaŋna sendi nda yi yo kwaŋnama nɔ kɛ ŋgimɔ Lɔt kɛ́. Ɓomɔ ɗikima ɗyena, ɗye mɛnjam, ɓɔmɔ mɛyasi, ɗyaŋgwɛ mɛyasi. Ɓo ɗikima ɓɛ mɛnyambi, sumɔ mɛtu̧. ");
INSERT INTO kkj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yasi wɛtɛ, kɛ yesɔ te yi Lɔt ɗuwa̧ nɔ kɛ̀ *Sɔdɔm kɛ́, ɛ ɗitɛ nɛ̀ yiŋa lolna mɛtari wulɛ ɗyoɓɔ girise ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yo ta kwaŋna sendi ɗete kɛ yesɔ te yi Mɔnɔ mumɔ ta punjɛ yotu nyɛ ɓomɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yesɔ te mɔ te ɛ ta ɓɛ kɛ tosiyɔ̧ kɔ tî pikwɛ nde, a mɛ kɛ̀ ɓu̧ mɛyasi mɛnɛ kɛ mɔy tu̧ na. Sendi, mɔ te ɛ ta ɓɛ kɛ ŋgwaŋ kɔ tî yɔkwɛ nɛ kɔkɔ kɛ̀ ɗya na. ");
INSERT INTO kkj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wunɛ tâka yasi te yi kelnama nɛ nya Lɔt kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mumɔ hɛnɛ ɛ ta sa̧ nje te yi kambiɗya nɛ joŋgwɛ ɗyenɛ kɔ ta ɗimbiɗye yo. Yasi wɛtɛ, yɔkɔ ɛ ta ɗimbiɗye joŋgwɛ ɗyenɛ kɔ ta kpalɔ ju̧. ");
INSERT INTO kkj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi kɛ lɛpɔ nyɛ wunɛ nde: Kɛ ŋgimɔ te, kɛ njoka ɓomɔ yiɓa ɓe ta ya nɛ tu kɛ kiya taŋ wɛtɛ, a ta ɓu̧ wɛtɛ, tikɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kɛ njoka ɓoma yiɓa ɓe ta ŋgbɔ kɔkɔ yasi kɛ tari, a ta ɓu̧ wɛtɛ, tikɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kɛ njoka ɓembam yiɓa ɓe ta ɓɛ kɛ kelɔ mɛsay kɛ ŋgwaŋ, a ta ɓu̧ wɛtɛ, tikɔ wɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɛ ɓejekɛ diyɛ nyɛ nde: «Yo ta kwaŋna we, Nyaŋgwɛ Kumande?» Ɛ Yesus yeŋsa nde: «Kɛ mbɛy komɛ muŋ yasi ɗiyɛ kɛ́, ɓedaɓo wésiɗyaŋgwɛ womɛte.» ");
INSERT INTO kkj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus yekiɗya wɛtɛ kanɔ nyɛ ɓejekɛ ɓenɛ yí teɗye ɓo nde, ɓo yâkaŋgwɛ ŋgwɛta nɛ Njambiyɛ mɛtu hɛnɛ kinɛ katɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A yekiɗya nde: «Wɛtɛ mɔ pɛsina jɔsi ɓa̧ kɛ wɛtɛ ɗya. A tì ɓɛ kɛ kambɔ Njambiyɛ na. Sendi, yeti kasi nɛ nɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wɛtɛ kusɔ nyari ɓa̧ kɛ ɗya te. A ɗikima nje mɛŋgimɔ hɛnɛ kɛ yi mɔ pɛsina jɔsi kɔ lɛpɔ nyɛ nyɛ nde: ‹Pɛsɔ jɔsi kɛ njoka mbɛ sinɛ mɔ mɛlɛpi wombɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mɛŋgimɔ kwaŋma ɓuɗyate, mɔ pɛsina jɔsi tì kwaɗyɛ na. Kɛ kɔŋte, ɛ nyɛ nje lɛpɔ kɛ mɔy temɔ nɛ nde: ‹Mi kɛ duwɛ gbate nde, mi yeti kɛ kambɔ Njambiyɛ na. Sendi, mi yeti nɛ kasi nɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ko ɓɛkɔ ɗete, mi ta pɛsɔ lɛpi kusɔ nya kɔ, kɛto a kɛ njaŋgwɛ mi. Mi ta pɛsɔ lɛpi nɛ, kɛto a ta potɔ to mbɛ nɛ njenate mɛtu hɛnɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɛ Nyaŋgwɛ Kumande kɛ̀ mbɔmbu lɛpɔ nde: «Wunɛ wôku ndi yasi te yi ɓeya mɔ pɛsina jɔsi kɔ lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","’Wunɛ táka gbate nde, Njambiyɛ ta ɗiyɔ ka kinɛ pɛsɔ lɛpi kɛto ɓotu ɓete ɓe nyɛ ma tɔkɛ ɓaka yí kamɛ nɛ ɓo? ’A ta ɗiyɔ ka kinɛ pɛsɔ lɛpi kɛto ɓotu ɓete ɓe ŋgwɛta nɛ nyɛ tu nɛ yesɔ ɓaka? ’A ta linja kinɛ pɛsɔ ka lɛpi nɛdɔ kɛto yan yí kamɛ nɛ ɓo? ");
INSERT INTO kkj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi kɛ lɛpɔ nyɛ wunɛ nde: A ta pɛsɔ lɛpi nɛdɔ kɛto yan yí kamɛ nɛ ɓo.» Yesus siɗya lɛpɔ nde: Komɛ *Mɔnɔ mumɔ ta nje kɛ́, ’a ta kweɗya ka ɓomɔ kɛ tikɔ temɔ nɛ Njambiyɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A ka̧ mbɔmbu yekiɗye sendi wɛtɛ kanɔ, kɛto ɓotu ɓete ɓe lɛpɛ gba nde, ɓo nɛ ŋgbeŋ nje kpalɔ yɛliyɛ ɓɛsɔ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A yekiɗya nde: «Ɓembam yiɓa tɛmma kɛ̀ kɛ mbanjɔ Njambiyɛ yí kɛ̀ ŋgwɛta nɛ Njambiyɛ. Wɛtɛ ɓa̧ mɔ *Farisɛ̧, wɛtɛ ɓa̧ mɔ ɓoŋna mɔni garama. ");
INSERT INTO kkj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mɔ Farisɛ̧ tɛmma tɛma lɛpɔ nyɛ Njambiyɛ kɛ mɔy temɔ nɛ nde: ‹Njambiyɛ wombɛ, mi kɛ nyɛ wɛ wosoko, kɛto mi yeti nda ɓaŋa ɓomɔ na. Ɓaŋa ɓotu ɓe ŋgaŋ, ɓaŋa kɔtu ɓomɔ, ɓaŋa ɓotu ɓe kelna wanja. Wosoko, kɛto mi yeti nda mɔ ɓoŋna mɔni garama te yɔkɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kɛ mɔy sɔndi wɛtɛ mi kíy mɛɗye mɛŋga yiɓa. Kɛ mɛyasi hɛnɛ te yi mi sɔmbɛ, mi ɓáka yo kɛ mɛŋgaɓiyɛ kamɔ kamɔ, ɓu̧ ŋgaɓiyɛ kwalɔ mɛyasi mɛte wɛtɛ wɛtɛ nyɛ wɛ Njambiyɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yasi wɛtɛ, mɔ ɓoŋna mɔni garama kwaŋma nɛ kɛ̀ ɗiyɔ nɛ naŋ. A tì ɓoɓɛ kaŋɛ misi nɛ mbɛt kɛnjɛ kwey na. Yasi wɛtɛ, a kpoma ɓɔ kɛ ɓeti lɛpɔ nde: ‹Njambiyɛ wombɛ, soŋa ŋgambi yɔ kɛ to mbɛ, mi mɔ mɛɓeyɔ.› » ");
INSERT INTO kkj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɛ Yesus nje lɛpɔ nde: «Mi kɛ lɛpɔ nyɛ wunɛ nde: Mbam kɔ ɗuwa̧ kɛ̀ tu̧ ɗyenɛ nɛ temɔ nɛ tɛ, kɛto Njambiyɛ pɛsima nde, a mɛ nɛ ŋgbeŋ kɛ mbɔmbu wenɛ, soŋɛ mɔ Farisɛ̧. Kɛto mɔ te ɛ ɓendiɗye yotu kɛnjɛ kwey, Njambiyɛ ta piɗyɛ nyɛ kɛnjɛ nji̧. Ma yɔkɔ ɛ piɗyɛ yotu kɛnjɛ nji̧, Njambiyɛ ta ɓendiɗye nyɛ kɛnjɛ kwey.» ");
INSERT INTO kkj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓomɔ ɓoŋma sɛkɛ sɛkɛ ɓɔnɔsikɛ kɛ̀ nɔ kɛ yi Yesus, na kpoki ɓo, yí nyɛ ɓo mɛkombila. Yasi wɛtɛ, kɛ ɓejekɛ ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo ɓama nɛ ɓotu ɓete. ");
INSERT INTO kkj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɛ Yesus lɛpɛ nde, ɓo ɓôŋ ɓɔnɔsikɛ kɛ̀ nɔ. Ɛ nyɛ nje lɛpɔ nde: «Nɛ tîki, nɛ́ ɓɔnɔsikɛ nje kɛ yembɛ. Nɛ tî peti ɓo na, kɛto *Kandɔ Njambiyɛ wókunaŋgwɛ nɛ ɓotu ɓete ɓe nda ɓɔnɔsikɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mumɔ ti jayɛ Kandɔ Njambiyɛ nda mɔnɔsikɛ na, a tí nyiŋɛ kɛte na.» ");
INSERT INTO kkj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wɛtɛ yesɔ wɛtɛ kum Ɓeyudɛn diyma Yesus nde: «Kimɔ yekele, mi kêl nan, nɛ́ mi ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo?» ");
INSERT INTO kkj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Kɛto ŋge yi wɛ jeɓa mi nde kimɔ mumɔ kɛ́? Kɛto kinɛ kimɔ mumɔ wɛtɛ nɛ wɛtɛ na, ndi Njambiyɛ nyɛpɔ. ");
INSERT INTO kkj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wɛ ma duwɛ mɛmboŋga mɛ Njambiyɛ, yo nde: ‹Kpɛ, wɛ tî kel wanja na. Wɛ tî woku mumɔ na. Wɛ tî guɓu na. Wɛ tî pɛsi lɛpi nyɛ kɛ numbu mumɔ na. Jɛsɔ sɔŋgwɛ ɓenɛ nyɔŋgwɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɛ mbam yeŋsa nde: «Mi kɛ ɓakiɗye mɛyasi mɛnɔri hɛnɛ kandɛ nɛ mɔnɔsikɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kɛ Yesus ma wokɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Ɓukwa̧ yasi wɛtɛ yi wɛ tì pa kelɔ kɛ́, yo nde: Kɛn ɗyaŋgwɛ mɛyasi mɔ hɛnɛ, nɔ̀ ɓôŋ mɔni te kaɓɔ nyɛ buka ɓomɔ. Ɗete, wɛ ta ɓɛ nɛ kusuku kɛ ɗyoɓɔ. Kɛ kɔŋte, nɔ̀ ɓêŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kɛ mbam kɔ ma wokɔ ɗete kɛ́, ɛ nyɛ wokɛ ŋgambi ɓuɗyate, kɛto a ɓa̧ nɛ ɓuɗya kusuku. ");
INSERT INTO kkj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kɛ Yesus ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ lɛpɛ nde: «Yo gba sulnate kɛ yi ɓotu ɓe kusuku nde, ɓo nyîŋa kɛ *Kandɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yo jɛwnate nde, nyaŋgwɛ nyamɔ nda *samo yakama kwa̧ lalɛ nɛdɔ kɛ njɛmbi alula nɛ̀ nde, mɔ kusuku nyîŋa kɛ Kandɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓotu ɓete ɓe ɓa̧ kɛ wokɔ yasi te yi Yesus ɓa̧ kɛ lɛpɔ kɛ́ nja̧ diyɛ nde: «Ma ŋgɛ ɓɛ ɗete, nda yakama ju̧ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ɛ Yesus yeŋsa nde: «Yasi te yi ɓomɔ yeti nɛ ɗeti te yi kelɔ, Njambiyɛ nɛ ɗeti te yi kelɔ yo.» ");
INSERT INTO kkj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa, wusɛ ma tikɔ su mɛyasi musu hɛnɛ ɓeŋgwɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mumɔ tikɛ tu̧ ɗyenɛ, tikɔ nyari ho ɓemaŋ ho saŋgwɛ ɓenɛ nyaŋgwɛ, tikɔ ɓɔnɔ kɛto *Kandɔ Njambiyɛ, ");
INSERT INTO kkj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mɔ te ta ɓɛ nɛ mɛyasi mɛte yinɔri kɛ ŋgimɔ te yɔkɔ kwa̧ yi mbɔmbu. A ta ɓɛ sendi nɛ joŋgwɛ te yi kpo nɛ kpo kɛ mɛtu mɛte yi ta nje kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kɛ kɔŋte, ɛ nyɛ jeɓa ɓejekɛ ɓenɛ kamɔ jɔ yiɓa lɛpɔ nyɛ ɓo nde: «Nɛ ɓɛ̂ŋa, wusɛ ɓe ɓendɛ kɛ̀ pɛ Yerusalɛm ɓaka: Mɛyasi hɛnɛ te yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ kasi *Mɔnɔ mumɔ kɛ́ ta kelna gbate. ");
INSERT INTO kkj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ɓo ta ɓu̧ nyɛ kaŋɛ nyɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka. Ɓo ta nyɛtɔ nyɛ, tɔyɛ nyɛ, sa mɛsɛri kɛ yotu nɛ, ");
INSERT INTO kkj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","njurɔ nyɛ nɛ njambala. Kɛ kɔŋte, ɓo má wo nyɛ, a má nje womiyɛ kɛ mɛtu yitati.» ");
INSERT INTO kkj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yasi wɛtɛ, ɓejekɛ tì wokɛ yaŋa kɛ yasi te yi Yesus lɛpima kɛ́ na. To te ɓa̧ sɔɗyate nɛ ɓo, ɓo tì ɓiye to lɛpi te na. ");
INSERT INTO kkj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus ɓa̧ kɛ wuta nɛ Yeriko. Kɛ ŋgimɔ te yite wɛtɛ mɔ ɗiɓina misi ɓa̧ kɛ ɗiyɔ kɛ kɛki nje. A ɗikima jɔmbɔ mɛyasi kɛ mɛɓɔ mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kɛ nyɛ ma wokɔ ŋgil ɓomɔ kɛ kwa̧ kɛ́, ɛ nyɛ diyɛ to te. ");
INSERT INTO kkj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Yo Yesus te, mɔ ɗya Nasarɛt kwa̧.» ");
INSERT INTO kkj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kɛ nyɛ ma wokɔ ɗete kɛ́, ɛ nyɛ kembɛ nde: «Yesus, mɔnɔ Davit, gwakɔ ŋgwɛtɛ wombɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɛ ɓotu ɓete ɓe ɓa̧ mbɔmbu ɓaka ɓamɛ nyɛ lɛpɔ nyɛ nyɛ nde, a ɗîɓi numbu. Ko ɓɛkɔ ɗete, a nja̧ kembɔ kwa̧ to te nde: «Mɔnɔ Davit, gwakɔ ŋgwɛtɛ wombɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ɛ Yesus tɛmɛ lɛpɔ nde, ɓo ɓôŋ nyɛ kɛ̀ nɔ. Kɛ mɔ ɗiɓina misi ma wuta nɛ nyɛ kɛ́, ɛ nyɛ diyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wɛ kwáɗyikwɛ nde, mi kêl ŋge nyɛ wɛ?» Ɛ nyɛ yeŋsa nde: «Nyaŋgwɛ Kumande, kelɔ nde, mi ɓɛ̂ŋnaŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɓɛŋnaŋgwɛ, tikina temɔ te yi wɛ nɔ kɛ́ joŋgwa wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ndana ndana, ɛ nyɛ kandɛ ɓɛŋna yasi ɓeŋgwɛ Yesus nɛ luksa Njambiyɛ kɛ numbu. Kɛ ɓomɔ hɛnɛ ɓe ɓa̧ womɛte ɓaka ma ɓɛŋɛ yasi te yi kwaŋnama kɛ́, ɛ ɓo lukse Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus kɛndima ɗya̧ kɛ Yeriko. A ɓa̧ kɛ kwa̧ nje nɛ nje. ");
INSERT INTO kkj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wɛtɛ mbam nde Sase ɓa̧ kɛ ɗya te. A ɓa̧ kum ɓotu ɓe ɓoŋna mɔni garama. A ɓa̧ sendi mɔ kusuku. ");
INSERT INTO kkj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A saŋma nje te yi ɓɛŋɛ mɔ te yi ɓo jeɓa nde Yesus kɔ. Yasi wɛtɛ, a tì ɓɛ nɛ ɗeti te yi ɓɛŋɛ nyɛ na kɛto ŋgil ɓomɔ, kɛto Sase ɓa̧ mɔ ɓotu. ");
INSERT INTO kkj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛ nyɛ nje sɛɗyɛ kwa̧ kɛ̀ mbɔmbu kɛ̀ ɓendɔ wɛtɛ jeti nde sikɔmɔr, na ɓɛŋ Yesus, kɛto Yesus yâkaŋgwɛ kwa̧ womɛte. ");
INSERT INTO kkj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kɛ Yesus ma kumɔ womɛte kɛ́, ɛ nyɛ kaŋɛ misi ɓɛŋɛ Sase lɛpɔ nyɛ nyɛ nde: «Pikwɛ nɛdɔ, kɛto muka mi yâkaŋgwɛ ya kɛ tu̧ ɗyɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ɛ Sase piyɛ ɓekɛ ɓekɛ ɓu̧ Yesus nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɓomɔ hɛnɛ ɓe ɓɛŋma mɛyasi mɛte ɓaka nyiŋgilama lɛpɔ nde: «A ka̧ ya kɛ yasi mɔ mɛɓeyɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yasi wɛtɛ, ɛ Sase tɛmɛ kɛ mbɔmbu Kumande Yesus lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wokɔ. Mi ta ɓakɛ kusuku mbɛ kɛ ɓembe, ɓu̧ ŋgaɓiyɛ te wɛtɛ nyɛ buka ɓomɔ. Sendi, ŋgɛ ɓɛ nde, mi seɓila mumɔ, ɓu̧ nɛ yaŋa kɛ ɓɔ nɛ, mi ta yɔkiɗye yo mɛŋga yini nyɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ɛ Yesus nje yeŋsa nyɛ nyɛ nde: «Ɓotu ɓe tu̧ ɗyɔ mɛ nɛ joŋgwɛ muka, kɛto wɛ sendi nday Abaraham, ");
INSERT INTO kkj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","kɛto *Mɔnɔ mumɔ njáki nje sa̧ ɓotu ɓete ɓe ma ɗimbiyɛ ɓaka joŋgwɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kɛ ŋgimɔ te yi ɓomɔ ɓa̧ kɛ wokɔ yasi te yi Yesus ɓa̧ kɛ lɛpɔ kɛ́, ɛ nyɛ kɛ̀ mbɔmbu yekiɗye wɛtɛ kanɔ nyɛ ɓo. Yesus ɓa̧ kɛ wuta nɛ Yerusalɛm. Ɛ ɓomɔ takɛ nde, *Kandɔ Njambiyɛ ta ɗya̧ ndana ndana. ");
INSERT INTO kkj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A yekiɗya kanɔ te nde: «Wɛtɛ mbam jaɗya kɛ yiŋa kandɔ ɓekumande. Ɛ nyɛ kwa̧ kɛ̀ lɔndunate kɛ wɛtɛ mɛnɛti kɛ ɓoŋna ɗiyɔ kumande. Kɛ nyɛ si ɓu̧ ɗiyɔ kumande, a má nje yɔkwɛ. ");
INSERT INTO kkj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kɛ ŋgimɔ kwaŋge ɛ nyɛ jeɓa ɓaŋa ɓotu ɓe mɛsay ɓenɛ kamɔ, nyɛ ɓo sule lɔr kamɔ lɛpɔ nyɛ ɓo nde: ‹Wunɛ ɗɔ̂kwɛ yo kumɔ kɛ ŋgimɔ te yi mi ta yɔkwɛ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ɓotu ɓe ɗya ɗyenɛ ɗikima ɓenɔ nyɛ. Ɛ ɓo tomɛ ɓomɔ kɛnjɛ kɛ kɔŋ nɛ kɛ̀ lɛpɔ nyɛ nyaŋgwɛ kumande ɗya te nde: ‹Wusɛ yeti kɛ kwaɗyɛ nde, mbam kɔ ɗîy nɛ wusɛ na.› ");
INSERT INTO kkj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ndana, kɛ nyɛ ma yɔkwɛ kɛ ɓoŋna ɗiyɔ Kumande kɛ́, ɛ nyɛ lɛpɛ nde, ɓo jêɓaŋgwɛ ɓotu ɓe mɛsay ɓete ɓe nyɛ nya ɓo mɔni ɓaka. A kwaɗya duwɛ nda yi mumɔ hɛnɛ ɗɔkwa nɛ yenɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ɛ bosa mumɔ ɗya̧ lɛpɔ nde: ‹Kumande, sule lɔr wɔ punja sule lɔr kamɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: ‹Kimɔ yaŋa, wɛ mɔ mɛsay te yi ɓo yakama ɓɛ nɛ ɓiɓina temɔ nɛ nyɛ. Nda yi wɛ duwa̧ ɓakiɗye yasi te yi nɛ mbɛt, mi kɛ nyɛ wɛ mɛɗya kamɔ nde, ɗiyɔ nɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɛ mumɔ yiɓate nje lɛpɔ nde: ‹Kumande, sule lɔr wɔ punja sule lɔr yitan.› ");
INSERT INTO kkj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ɛ Kumande lɛpɛ nyɛ nyɛ nde: ‹Wɛ sendi, ɗiyɔ nɛ mɛɗya yitan.› ");
INSERT INTO kkj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ɛ mumɔ yitatite nje lɛpɔ nde: ‹Kumande, sule lɔr wɔ kɔ. Mi ɓɔyma yo nɛ kum lambɔ sɔɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mi gwa̧ wɔ̧ yɔ, kɛto wɛ nɛ nyanɔ ɓuɗyate. Wɛ ɓóŋ yasi kinɛ yaŋa te yi wɛ paŋma komɔ na. Wɛ ndɛ́m mɛɗye kinɛ mbɛki te yi wɛ paŋma ɓɛ na.› ");
INSERT INTO kkj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ɛ Kumande lɛpɛ nyɛ nyɛ nde: ‹Wɛ ɓeya mɔ mɛsay. Mi ta pɛsɔ lɛpi yɔ ɓeŋgwɛ mɛlɛpi mɛte yi punduma kɛ numbu yɔ kɛ́. Wɛ duwa̧ nde, mi nɛ nyanɔ ɓuɗyate. Mi ɓóŋ yasi kinɛ yaŋa te yi mi paŋma komɔ na. Mi ndɛ́m mɛɗye kinɛ mbɛki te yi mi paŋma ɓɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ŋge kelɛ yi wɛ tì ɓu̧ mɔni mbɛ kɛ̀ tikɔ kɛ mbɛy ɗɔkwa te kɛ́? Ŋge yi wɛ ti kelɛ ɗete, simande kɛ yɔkwe mbɛ, mi ta sɔmbɔ liɓa kɛ to te kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɛ Kumande lɛpɛ nyɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka nde: ‹Wunɛ sûku sule lɔr te yi kɛ ɓɔ nɛ kɛ́ kaŋɛ nyɛ mɔ te ɛ nɛ sule lɔr kamɔ kɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: ‹Kumande, mbɛte nɛ sule lɔr kamɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ɛ nyɛ lɛpɛ nde: ‹Mi kɛ lɛpɔ nyɛ wunɛ nde: Ɓo ta dokiɗye yasi nyɛ mɔ te ɛ mɛ nɔ kɔ. Yasi wɛtɛ, pɛ yɔkɔ ɛ kinɛ yaŋa kɔ, ɓo ta sukɔ ko mɔnɔ yasi te yi nyɛ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kɛ ɓɛ ɓotu ɓete ɓe ɓenɛ mi ɓaka, wunɛ ɓôŋ ɓo nje nɔ, kɛto ɓo tì kwaɗyɛ nde, mi ɗîy nɛ ɓo na. Wunɛ njâki nɛ ɓo waka nje pɛsɔ mɛŋgiŋ man kɛ mbɔmbu wombɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kɛ Yesus ma si lɛpina ɗete kɛ́, ɛ nyɛ ɓu̧ to njɔŋ kɛndi yí kɛ̀ nɔ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kɛ nyɛ ma wuta nɛ Betfage nɛ̀ Betani kɛ kɛki *Keki mɛoliviye kɛ́, ɛ nyɛ tomɛ ɓaŋa ɓejekɛ ɓenɛ yiɓa ");
INSERT INTO kkj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","lɛpɔ nyɛ ɓo nde: «Wunɛ kɛ̂n kɛ ɗya te ɛ kɛ mbɔmbu wun kɔ. Komɛ wunɛ ta nyiŋɛ kɛ mɔy ɗya kɛ́, wunɛ ta dolɔ mɔnɔ tofu tiŋnate. Mumɔ wɛtɛ nɛ wɛtɛ tì pa ɗiɗyɛ mɛta mɛnɛ wɛtɛ yesɔ kɛ to nɛ na. Nɛ̀ wunɛ wûnja nyɛ nje nɔ. ");
INSERT INTO kkj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ŋgɛ mumɔ diyɛ wunɛ nde: ‹Wunɛ wúnja nyɛ kɛto ŋge?› nɛ̀ wunɛ yêŋsaŋgwɛ nde: ‹Nyaŋgwɛ Kumande kɛ kwaɗyɛ kelɔ yiŋa yasi nɛ nyɛ.› » ");
INSERT INTO kkj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɓejekɛ ɓete ɓe nyɛ tomma ɓaka ka̧ kweɗya mɛyasi nda yi nyɛ lɛpima nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ wunjɛ mɔnɔ tofu kɛ́, ɛ ɓesa ɓete diyɛ ɓo nde: «Wunɛ wúnja nyɛ kɛto ŋge?» ");
INSERT INTO kkj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɛ ɓo yeŋsa nde: «Nyaŋgwɛ Kumande kɛ kwaɗyɛ kelɔ yiŋa yasi nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɛ ɓo ɓu̧ mɔnɔ tofu kɛ̀ nɔ kɛ yi Yesus, ɓu̧ mɛlambɔ man jonɔ kɛ to nɛ, nje ɓendiɗye nyɛ kɛ to te. ");
INSERT INTO kkj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ kwa̧ kɛ́, ɛ ɓomɔ ɓɛ kɛ jonɔ mɛlambɔ man kɛ nje, na kɛndi kɛ to te. ");
INSERT INTO kkj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kɛ nyɛ ma wuta nɛ Yerusalɛm kɛ piya *Keki mɛoliviye kɛ́, ɛ mɛsosa kwa̧ ŋgil ɓejekɛ hɛnɛ. Ɛ ɓo lukse Njambiyɛ nɛ mɛn kɛ kwey kɛto nyaŋgwɛ mɛkele hɛnɛ te yi ɓo ɗikima ɓɛŋɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɛ ɓo lɛpɛ nde: ‹Mɛkombila nɛ Kumande te ɛ nje nɛ ɗinɔ Baba Mbokɔ kɔ! Tɛte ɓɛ̂ŋnaŋgwɛ kɛ ɗyoɓɔ nɛ̀ mɛluksa ɓɛ̂ŋnaŋgwɛ kɛ kwey!› ");
INSERT INTO kkj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ɛ ɓaŋa *Ɓefarisɛ̧ ɓe ɓa̧ kɛ mɔy ŋgil yinɔri ɓaka lɛpɛ nyɛ Yesus nde: «Yekele, gayɔ ɓejekɛ ɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ɛ nyɛ yeŋsa nde: «Mi kɛ lɛpɔ nyɛ wunɛ nde: Ŋgɛ ɓo ɗiɓɛ numbu, mɛtari ta kpalɔ lɛpina nɛ mɛn kɛ kwey.» ");
INSERT INTO kkj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kɛ Yesus ma kumɔ kɛ kɛki Yerusalɛm kaŋɛ misi ɓɛŋɛ nɛ ɗya kɛ́, ɛ nyɛ kandɛ ɗukwe ");
INSERT INTO kkj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","lɛpɔ nde: «Yerusalɛm, wɛ má dukwɛ yɔ mɛyasi mɛte yi nyɛ wɛ tɛte kɛ yesɔ te yɔkɔ muka, ma yo gba kimɔte. Yasi wɛtɛ, yo sɔɗyate ndana kɛ misi mɔ. ");
INSERT INTO kkj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kɛto ŋgimɔ ta ɗya̧, ɓependɔ ɓɔ ta sumɔ ndoko litɔ wɛ. Ɓo ta sɛŋgɔ wɛ mɛmbɛy hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓo ta yaŋgile wɛ wúnɛ ɓɔnɔ ɓɔ ɓetɛ kɛ mɛnɛti. Ɓo tí tikɔ tari wɛtɛ dokiɗyate kɛ to jakɔsɔ na. Yo ta kelna ɗete, kɛto wɛ tì duwɛ ŋgimɔ te yi Njambiyɛ nja̧ ɓɛŋɛ wɛ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ɛ nyɛ kwa̧ nyiŋɛ mbanjɔ Njambiyɛ kandɛ ɗuɗya ɓotu ɓete ɓe ɓa̧ kɛ ɗyaŋgwɛ mɛyasi womɛte ɓaka ");
INSERT INTO kkj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","lɛpɔ nyɛ ɓo nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Tu̧ ɗyembɛ ta ɓɛ tu̧ mɛŋgwɛta.› Yasi wɛtɛ, wunɛ ma yeŋsa yo nɛ gbaŋ ɓotu ɓe guɓɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ mɛtu hɛnɛ kɛ mbanjɔ Njambiyɛ. Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ nyaŋgwɛ ɓotu ɓe kandɔ Isarayɛl saŋma nje te yi wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yasi wɛtɛ, ɓo tì duwɛ nda yi ɓo yakama kelɔ kɛ́ na, kɛto ɓomɔ hɛnɛ nya temɔ yan kɛ wokuna mɛlɛpi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wɛtɛ yesɔ Yesus ɓa̧ kɛ teɗye mɛlɛpi mɛ Njambiyɛ lɛpɔ Kimɔ Tom nyɛ ɓomɔ kɛ mbanjɔ Njambiyɛ. Semɔ semɔ, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi nɛ̀ ɓetomba ɓe ɗya ɗya̧ ");
INSERT INTO kkj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","diyɛ nyɛ nde: «Ɗeti te yi wɛ kelɛ nɛ mɛyasi mɛte yikɛ kɛ́ wúla we? Lɛpɔ nyɛ wusɛ. Nda nyɛ wɛ ɗeti nde, kelɔ mɛyasi mɛte?» ");
INSERT INTO kkj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mi sendi, mi ndi nɛ lɛpi wɛtɛ yi mi ta diyɛ wunɛ: ");
INSERT INTO kkj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nda tomɛ Jaŋ nde, a njâki tɔpɛ ɓomɔ kɛ mɔrɔku? Yo Njambiyɛ ho yo ɓomɔ? Wunɛ yêŋsaŋgwɛ nyɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɛ ɓo kandɛ mɛdiyna tandɛ yan lɛpɔ nde: «Ŋgɛ wusɛ lɛpɛ nde: Yo Njambiyɛ tomɛ nyɛ, a ta diyɛ wusɛ nde: ‹Ma kɛto ŋge yi wunɛ tì tikɛ temɔ kɛ yasi te yi nyɛ lɛpima kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma ŋgɛ wusɛ nje yeŋsa nde: Yo ɓomɔ tomɛ nyɛ, yite ɓomɔ hɛnɛ ta lu̧ wusɛ nɛ mɛtari wo, kɛto ɓo kɛ kombile duwɛ nde, Jaŋ ɓa̧ mɔ punja mɛlɛpi mɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛ ɓo yeŋsa nde: «Wusɛ yeti kɛ duwɛ Mɔ te ɛ tomma nyɛ nde, a njâki tɔpa ɓomɔ kɛ mɔrɔku kɔ na.» ");
INSERT INTO kkj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mi sendi, mi yeti kɛ lɛpɔ yaŋa nyɛ wunɛ kɛ kasi ɗeti te yi mi kelɛ nɛ mɛyasi mɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kɛ kɔŋte, ɛ nyɛ nyɛ wɛtɛ kanɔ nyɛ ɓomɔ nde: «Wɛtɛ mbam sama ŋgwaŋ *vinyɛ. Ɛ nyɛ kaŋɛ yo nyɛ ɓaŋa ɓotu ɓe mɛsay nde, ɓo ɓâkiɗya. Kɛ kɔŋte, ɛ nyɛ nje kwa̧ kɛ̀ lɔndunate kɛ yiŋa mɛnɛti kɛ̀ ya ɓuɗya mɛtu. ");
INSERT INTO kkj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kɛ mɛmbumɔ ma si ɗetɔ kɛ ŋgwaŋ, ɛ nyɛ tomɛ wɛtɛ mɔ mɛsay kɛnjɛ kɛ yi ɓari, nɛ́ ɓo njesɛ nyɛ ŋgaɓiyɛ mɛmbumɔ mɛte yenɛ. Yasi wɛtɛ, ɛ ɓotu ɓete mɛndɛ mɔ tomun yɔkiɗye nyɛ nɛ gboŋgo ɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɛ nyɛ ɓasiɗye tomɔ wɛtɛ mɔ mɛsay. Ɛ ɓotu ɓe ɓakiɗya ŋgwaŋ mɛndɛ nyɛ toyɛ nyɛ wuŋgwɛ, yɔkiɗye nyɛ nɛ gboŋgo ɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kɛ mɛŋga yitatite, ɛ nyɛ tomɛ sendi wɛtɛ mɔ mɛsay. Ɛ ɓo ɗuɗye nyɛ yɔkiɗye nɛ mɛpeŋ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ndana, ɛ sa ŋgwaŋ lɛpɛ nde: ‹Mi ta kelɔ nan? Mi ta tomɔ mɔnmbɛ, sɔŋ temɔ mbɛ, ta ɓɛ, ɓo ta kambɔ nyɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko ɓɛkɔ ɗete, kɛ ɓotu ɓe ɓakiɗya ŋgwaŋ ma ɓɛŋɛ nyɛ kɛ́, ɛ ɓo saŋgwɛ ŋgiŋ lɛpɔ nde: ‹Yo nyɛ ta tika nɛ mɛlikɔ mɛ saŋgwɛ. Wusɛ wôku nyɛ, nɛ́ wusɛ tika nɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɛ ɓo ɓu̧ nyɛ kɛ̀ ɓetɛ kɛ kɔŋ ŋgwaŋ wo.» Ndana, ɛ Yesus diyɛ nde: «Sa ŋgwaŋ ta kelɔ nan nɛ ɓo? ");
INSERT INTO kkj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A ta nje girise ɓo hɛnɛ kaŋɛ ŋgwaŋ nyɛ ɓaŋa.» Kɛ ɓomɔ ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ ɓo lɛpɛ nde: «Yaŋa tî kelnaŋgwɛ ɗete na.» ");
INSERT INTO kkj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yasi wɛtɛ, ɛ Yesus kaŋɛ misi ɓɛŋɛ nɛ ɓo lɛpɔ nde: «Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Tari*f1* te yi ɓotu ɓe sumna njumɔ sɛŋma kɔ kpalma nje ɓɛ saŋgwɛ kondu,› ma to lɛpi te nde ŋge? ");
INSERT INTO kkj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ŋgɛ mumɔ nje ɗumɔ mbɔmbu nɛ kɛte, a ta ɓalɔ nyaŋsaŋgwɛ lekwɛ nɛ mutu mutu. Sendi, ŋgɛ kondu te ɓalɛ kɛ to mumɔ, yo ta pɔsɔ nyɛ nɛ mbɔl.» ");
INSERT INTO kkj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi saŋma nje te yi ɓiye nyɛ ndi kɛ kiya ŋgimɔ te yite. Yasi wɛtɛ, ɓo kambima ɓomɔ. Ɓo duwa̧ nde, Yesus nyɛ́ki kanɔ te suŋgwɛ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ndana, ɛ ɓo kandɛ saŋna mɛnje tomɔ ɓomɔ yi pɛmna nɛ. Ɓotu ɓete ɗikima kelɔ mɛmbɔlɛ nda kimɔ ɓomɔ, simande ɓo ta wokɔ yiŋa kɔtu lɛpi kɛ numbu nɛ, nɛ́ ɓo ɓiy nyɛ, nyɛ ɓotu ɓe pɛsina jɔsi, nɛ́ ɓo nje kwaŋɗye nyɛ kɛnjɛ nyaŋgwɛ kum te ɛ ɗiyɛ nɛ mɛnɛti man kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɛ ɓotu ɓete lɛpɛ nyɛ Yesus nde: «Yekele, wusɛ duwa̧ nde, wɛ kɛ lɛpina teɗye sendi yasi nɛ ŋgbeŋ kinɛ nɛmbɛ njoka ɓomɔ na. Yasi wɛtɛ, wɛ téɗya yɔ nje Njambiyɛ gbate gbate. ");
INSERT INTO kkj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","’Hɛ gbôku ka garama nyɛ *Sesar, ho hɛ tî gboku na?» ");
INSERT INTO kkj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus duwa̧ likisi yan. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Wunɛ têɗya mi sule wɛtɛ. Yekambiyɛ nɛ̀ mɛkɛti mɛte yi kɛte kɛ́ téɗya nda?» Ɛ ɓo yeŋsa nde: «Yo yi Sesar.» ");
INSERT INTO kkj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ɗete, wunɛ nyɛ̂ki Sesar mɛyasi mɛte yenɛ, nyɛ Njambiyɛ mɛyasi mɛte yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma ɓo ti yaka ɓiye nyɛ nde, a lɛpima yiŋa kɔtu lɛpi kɛ mbɔmbu ɓomɔ na. Yasi wɛtɛ, ɓo ŋgbakimama nda yi Yesus yeŋsama nɔ nyɛ ɓo kɛ́, ɛ ɓo ɗiɓɛ numbu. ");
INSERT INTO kkj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɓaŋa ɓomɔ kɛ njoka *Ɓesadusɛ̧ ka̧ kɛ̀ yi Yesus. Ɓesadusɛ̧ lɛ́pi nde, mumɔ tí womiyɛ na. Ɛ ɓo lɛpɛ nyɛ Yesus nde: ");
INSERT INTO kkj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Yekele, Mɔyisi kɛtima kɛ mɛmboŋga nde: ‹Ŋgɛ mumɔ ɓɛ nɛ maŋ, ŋgɛ maŋ wenɛ te gwe tikɔ nyari kinɛ ja ɓenɛ na, na ɓôŋ kusɔ te, na ja kwaŋɗye nɛ ɗinɔ maŋ ɛ gwa̧ kɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ma yo ɓa̧ nɛ ɓɔnɔ ɓembam yitan jɔ yiɓa kɛ mɔy yan. Tomba mɔy ɓoŋma nyari. Ɛ nyɛ gwe tikɔ nya te kinɛ ja ɓenɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɛ ɛ kɔŋte nje ɓu̧ kusɔ. Ɛ nyɛ gwe sendi tikɔ nyɛ kinɛ ja ɓenɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɛ mɔ yitatite nje ɓu̧ sendi nya te. Yo kelnama ɗete nɛ ɓo yitan jɔ yiɓa hɛnɛ. Ɓo gwa̧ kinɛ tikɔ mɔnɔsikɛ wɛtɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɗiyɔ kɛ́, ɛ nyari nje gwe sendi. ");
INSERT INTO kkj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma komɛ ɓemuŋ ta womiyɛ kɛ́, nya kɔ ta nje ɓɛ nya nda kɛ njoka yan, kɛto ɓo hɛnɛ yitan jɔ yiɓa ɓoŋma nyɛ nɛ mɛgwaki?» ");
INSERT INTO kkj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ɓembam nɛ̀ ɓoma ɓete ɓe ndi ndana kɛ mɛnɛti ɓaka kɛ kelɔ mɛgwaki. ");
INSERT INTO kkj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yasi wɛtɛ, ɓotu ɓete ɓe Njambiyɛ ɓɛŋma kimɔte nde, ɓo ta womiyɛ kɛ njoka ɓemuŋ ɓɛ nɛ joŋgwɛ kɛ mbokɔ te yi ta nje kɛ́ tí kelɔ mɛgwaki se na. ");
INSERT INTO kkj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓo tí gwe se na, kɛto ɓo ta ɓɛ nda ɓejaki ɓe Njambiyɛ. Ɓo ta ɓɛ ɓɔnɔ ɓe Njambiyɛ, kɛto ɓo ma womiyɛ kɛ njoka ɓemuŋ. ");
INSERT INTO kkj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mɔyisi téɗya nde, ɓomɔ ta womiyɛ kɛ mbɛy te yi nyɛ lɛpima kasi mɔnɔ jeti te ɛ ɓa̧ kɛ ɓiye ɗitɛ kɔ komɛ nyɛ jeɓa Baba Mbokɔ nde: ‹Njambiyɛ te ɛ Abaraham, Njambiyɛ te ɛ Isak, Njambiyɛ te ɛ Yakɔp.› ");
INSERT INTO kkj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Njambiyɛ yeti Njambiyɛ ɓemuŋ na, nyɛ Njambiyɛ te ɛ ɓotu ɓete ɓe nɛ joŋ ɓaka. Kɛ yenɛ, ɓotu ɓete ɓe ma gwe ɓaka hɛnɛ nɛ joŋ.» ");
INSERT INTO kkj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɛ ɓaŋa kɛ njoka ɓotu ɓe kɛtina mɛyasi jayɛ lɛpɔ nde: «Yekele, wɛ lɛpima kimɔte.» ");
INSERT INTO kkj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kɛ kɔŋte, ɓo kinɛ ɓoɓɛ diyɛ se nyɛ yiŋa diyan na. ");
INSERT INTO kkj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Ɓomɔ lɛ́pi nde, *Krist mɔnɔ Davit nan? ");
INSERT INTO kkj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kɛto Davit nɛ ŋguru wenɛ kɛ lɛpɔ kɛ mɔy mɛkana mɛ Ɓesom nde: ‹Baba Mbokɔ lɛpima nyɛ Nyaŋgwɛ Kumande wombɛ nde: Ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ mbɛ ");
INSERT INTO kkj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kumɔ nde, mi sîki kawule ɓependɔ ɓɔ tikɔ kɛ nji̧ mɛkol mɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davit jeɓama Krist nde Nyaŋgwɛ Kumande, ma Krist ta kpalɔ nje ɓɛ mɔnɔ wenɛ nan?» ");
INSERT INTO kkj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kɛ ŋgimɔ te yi ɓomɔ hɛnɛ ɓa̧ kɛ wokɔ mɛlɛpi mɛte yi Yesus ɓa̧ kɛ lɛpɔ kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: ");
INSERT INTO kkj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Wunɛ ɗîy nɛ sɔsɔ nɛ ɓotu ɓe kɛtina mɛyasi. Ɓo kwáɗyikwɛ jaŋa nɛ nyaŋgwɛ ndulɛŋ ndulɛŋ mɛgambo kɛ mbɔmbu ɓomɔ, kwaɗyɛ sendi nde, ɓomɔ kɛ̂ nyɛnɔ ɓo kɛ mɛmbɛy komɛ ɓomɔ ɗiki wesiɗya kɛ́. Ɓo kwáɗyikwɛ ɗiyɔ kɛ bosa mɛmbɛy kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, sa̧ sendi kpasa mɛmbɛy kɛ mɛtu̧ mɛdina. ");
INSERT INTO kkj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓo wɛ́njila mɛyasi hɛnɛ nɛ mbul kɛ mɛɓɔ mɛ ɓekusɔ ɓoma, ɗiki nje kelɔ sɛwna mɛŋgwɛta, nɛ́ ɓomɔ ɓɛŋ nde, ɓo kimɔ ɓomɔ. Njambiyɛ ta jɔse ɓo teɗye ɓo nyaŋgwɛ mɛbɔnɛ kwa̧ to te.» ");
INSERT INTO kkj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus kaŋma misi ɓɛŋɛ nda yi ɓotu ɓe kusuku ɓa̧ kɛ nyɛ mɛyasi nɛ sadaka nyɛ Njambiyɛ kɛ mɔy kpoŋgi nyɛna sadaka kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɛ nyɛ ɓɛŋɛ wɛtɛ buka kusɔ nyari kɛ̀ ɓetɛ limbi sisi yiɓa kɛte. ");
INSERT INTO kkj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ɛ nyɛ lɛpɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Buka kusɔ nya kɔ nya kwa̧ ɓari hɛnɛ, ");
INSERT INTO kkj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kɛto ɓari hɛnɛ nya ɓuyɔ mɛyasi mɛte yi ɓo ɓɛ nɔ kwa̧ to te kɛ́. Yasi wɛtɛ, buka kusɔ nya kɔ nya yasi hɛnɛ te yi ɓa̧ nde, a jôŋnaŋgwɛ nɔ kɛ ɗiyɔ mɛbukɔ mɛnɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ɗiyɔ kɛ́, ɛ ɓaŋa ɓomɔ lɛpɛ kasi mbanjɔ Njambiyɛ. Ɓo ɓa̧ kɛ lɛpɔ nda yo ɓa̧ kimɔte nɛ kimɔ mɛtari nɛ̀ mɛyasi mɛte yi ɓomɔ nya Njambiyɛ nɛ sadaka kɛ́. Ɛ Yesus lɛpɛ nde: ");
INSERT INTO kkj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Kɛ mɛtu mɛte yi nje kɛ́ mɛyasi mɛnɔri hɛnɛ yi wunɛ ɓɛŋɛ kɛ́ kinɛ tari wɛtɛ nɛ wɛtɛ ta ɗiyɔ waka kɛ to jakɔsɔ kinɛ nde, ɓo gbûŋgula ɓetɛ kɛ mɛnɛti na.» ");
INSERT INTO kkj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɛ ɓo diyɛ nyɛ nde: «Yekele, mɛyasi mɛte ta kelna ndenɛn? Yo ŋge ta teɗye nde, mɛyasi mɛte ta ɓɛ kɛ kelna kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɛ nyɛ yeŋsa nde: «Wunɛ ɗîy nɛ sɔsɔ, ma ɓo nje seɓile wunɛ, kɛto ɓomɔ ɓuɗyate ta nje nɛ ɗinɔ ɗyembɛ lɛpɔ nde: ‹Mi *Krist, mi kɔ! Ŋgimɔ yakama.› Wunɛ tî ɓeŋgwɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Komɛ wunɛ ta wokɔ kasi mɛɗyambi, wokɔ sendi nde, ɓomɔ kɛ ɗesɛ to suŋgwɛ nɛ ɓekum ɓe ɗya, wunɛ tî gwaki kaŋ yaŋa na, kɛto mɛyasi mɛte kânda si kelna. Yasi wɛtɛ, yite tì teɗya nde, siyna mbokɔ ta ɗya̧ ndana ndana na.» ");
INSERT INTO kkj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kandɔ wɛtɛ ta tɛmɛ lu̧ ɗyambi nɛ wɛtɛ kandɔ. Kumande wɛtɛ má tɛmɛ lu̧ ɗyambi nɛ jakɔsɔ. ");
INSERT INTO kkj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mɛnɛti ta ŋgwaŋgwa ɓuɗyate. Ɓeya mɛkɔn nɛ̀ mɛkolɔ ta ɗya̧ sendi kɛ ɓuɗya mɛmbɛy. Nyaŋgwɛ mɛkele mɛte yi nyɛ wɔ̧ nɛ̀ nyaŋgwɛ mɛyekambiyɛ ta kelna wulɛ kwey. ");
INSERT INTO kkj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yasi wɛtɛ, kɛ ŋgimɔ te yi mɛyasi mɛnɔri tì pa kelna kɛ́, ɓo ta ɓiye wunɛ teɗye wunɛ nyaŋgwɛ mɛbɔnɛ. Ɓo ta kaŋɛ wunɛ tɛmbiɗye kɛ jɔsi kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, nyɛ wunɛ kɛ jɔɓɔ. Ɓo ta kɛ̀ nɛ wunɛ kɛ mbɔmbu ɓekumande nɛ̀ kɛ mbɔmbu ɓekum kɛto ɗinɔ ɗyembɛ. ");
INSERT INTO kkj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mɛyasi mɛte yi wunɛ ta saŋgwa nɔ kɛ́ ta kelɔ nde, wunɛ lɛ̂pi mɛyasi mɛte yi wunɛ ɓɛŋma nɛ̀ yi wunɛ duwa̧ kɛ kasi mbɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ɗete, wunɛ ɓâkiɗya kimɔte kɛ ɗyanɔ ɗyun nde, wunɛ tî kanda kuɗyɛ temɔ kɛ yasi te yi wunɛ ta yeŋsa kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kɛto mi ta teɗye wunɛ mɛlɛpi mɛte yi wunɛ ta lɛpɔ kɛ́, nyɛ sendi wunɛ ɗyanɔ te yi ta kelɔ nde, ɓependɔ ɓun tí sumɔ kol, ho yeŋsa yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ko ɓesaŋgwɛ ɓun nɛ̀ ɓenyaŋgwɛ ɓun, ko ɓemaŋ ɓun ko ɓejaɗyɛ ɓun nɛ̀ ɓesɔ ɓun ta ɗyaŋgwɛ wunɛ. Ɓo ta wo ɓaŋa ɓuɗyate kɛ njoka yun. ");
INSERT INTO kkj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓo hɛnɛ ta ɓenɔ wunɛ kɛto ɗinɔ ɗyembɛ. ");
INSERT INTO kkj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko ɓɛkɔ ɗete, nyiŋɔ to yun wɛtɛ nɛ wɛtɛ tí ɗimbiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wunɛ ta joŋgwɛ mɛsisiŋ mun, ŋgɛ wunɛ disima. ");
INSERT INTO kkj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Kɛ ŋgimɔ te yi wunɛ ta ɓɛŋɛ nde, mɛnjɔŋ ɓesɔja ma litɔ Yerusalɛm saŋgwɛ kɛ́, wunɛ dûkwɛ nde, Yerusalɛm ta ɓɛ kɛ yaŋgila. ");
INSERT INTO kkj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kɛ ŋgimɔ te yite ɓotu ɓete ɓe ta ɓɛ kɛ mɛnɛti mɛ Yuda ɓaka sɛ̂ɗyikwɛ kambɔ kɛ̀ kɛ to mɛkeki. Ɓaka ɓe ta ɓɛ kɛ Yerusalɛm ɓaka pûndu si kwa̧. Ɓotu ɓete ɓe ta ɓɛ kɛ mɛlunde ɓaka tî nyiŋa mɔy ɗya na. ");
INSERT INTO kkj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kɛto yo ta ɓɛ ŋgimɔ te yi Njambiyɛ ta ndeyɛ ɓomɔ ɓenɛ teɗye ɓo mɛbɔnɛ. A ta kelɔ ɗete, nɛ́ mɛyasi hɛnɛ te yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tôndu. ");
INSERT INTO kkj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɓoma ɓete ɓe ta ɓɛ nɛ mɔy nɛ̀ ɓaka ɓe ta nyɛ ɓɔnɔsikɛ ɓɛri kɛ ŋgimɔ te yite ɓaka ta saŋgwa nɛ mɛbɔnɛ, kɛto nyaŋgwɛ mɛbɔnɛ ta ɗya̧ kɛ ɗya. Njambiyɛ ta punjɛ ŋgambi nɛ suŋgwɛ nɛ ndiŋgɛlɛ kandɔ kɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓo ta wo ɓo nɛ kafa, ɓiye ɓo nɛ bala kɛ̀ nɔ kɛ mɛkandɔ hɛnɛ. Ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka ta sɔpite Yerusalɛm nɛ mɛkol kumɔ komɛ ŋgimɔ te yan ta siyɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Yiŋa mɛyasi mɛte yi teɗye nde, yaŋa ta ɗya̧ kɛ́ ta ɓɛŋna kɛ yesɔ, ɓɛŋna kɛ ŋgwɛndɛ nɛ̀ ɓesisɔ̧. Mɛkandɔ hɛnɛ kɛ to mɛnɛti ta gwe wɔ̧ ɓuɗyate. Ɓo ta ɗiyɔ temɔ kɛ ŋgiŋ kɛ nyaŋgwɛ mɛɗuŋ mɛ maŋ nɛ̀ mɛɗuŋ mɛ nyaŋgwɛ mɛkumbɔ. ");
INSERT INTO kkj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓomɔ ta gwe wɔ̧ ŋgwaŋgwa ɓalɔ kɛ takina yasi te yi ta ɗya̧ kɛ mɛnɛti kɛ́. Kɛto mɛyasi mɛte yi nɛ ŋguŋguɗyɛ yi ɗiyɛ kɛ kwey kɛ́ ta ŋgbɔkisa ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kɛ kɔŋte, ɓo ta ɓɛŋɛ *Mɔnɔ mumɔ kɛ nje nɛ kulutu nɛ nyaŋgwɛ ŋguŋguɗyɛ nɛ̀ nyaŋgwɛ mɛluksa. ");
INSERT INTO kkj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Komɛ mɛyasi mɛnɔri ta kandɛ ɗyaŋnate kɛ́, nɛ̀ wunɛ tɛ̂mbiɗya yotu kaŋɛ to, kɛto Njambiyɛ ta ɓɛ kɛ joŋgwɛ wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɛ Yesus yekiɗye wɛtɛ kanɔ nyɛ ɓo nde: «Wunɛ ɓɛ̂ŋa *figiye ko mɛjeti hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kɛ ŋgimɔ te yi jɔnja mɛmbɔru mɛ kɛ pundɔ kɛ mɛɓɔ mɛte, wunɛ nɛ ŋguru wun kɛ duwɛ nde, ŋgimɔ mbiyɔ ma wuta. ");
INSERT INTO kkj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɗete sendi, komɛ wunɛ ta ɓɛŋɛ nde, mɛyasi mɛte mɛ kɛ ɗya̧, wunɛ dûkwɛ nde, *Kandɔ Njambiyɛ ma wuta. ");
INSERT INTO kkj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ko ɓotu ɓete ɓe nɛ joŋ kɛ ŋgimɔ te yɔkɔ ɓaka tí gwe hɛnɛ kinɛ nde, mɛyasi mɛnɔri ɗyâŋ na. ");
INSERT INTO kkj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ɗyoɓɔ nɛ̀ mɛnɛti ta si kwa̧ yambile, ma ndi mɛlɛpi mɛmbɛ tí yambile wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Wunɛ ɗîy nɛ sɔsɔ nɛ mɛkele mun, ma temɔ yun mɛ nje tɛkɔ kɛto ɗyena mɛɗye nɛ̀ gwena mɛnjam kwa̧ to te. Wunɛ ɗîy sendi nɛ sɔsɔ, ma temɔ yun mɛ nje tɛkɔ kɛto mɛtakɛ kɛ kasi mɛyasi mɛte yi wunɛ ta joŋna nɔ kɛ́. Wunɛ ɗîy nɛ sɔsɔ, kambɔ yesɔ te mɛ nje ŋgbakɛ wunɛ ŋgbaka. ");
INSERT INTO kkj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kɛto yesɔ te ta ɗya̧ ŋgbakɛ ɓomɔ hɛnɛ ɓe ɗiyɛ kɛ to mɛnɛti, nda yi ɓo ɓetɛ nɛ bulajama kɛ ɗuku, ɓenjanjɔ má nje ŋgbakima, yo má kawule ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɗete, wunɛ tî yaki na. Wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ mɛŋgimɔ hɛnɛ, nɛ́ wunɛ ɓɛ nɛ ɗeti te yi diyɔ kɛ mɛyasi mɛte yi ta ɗya̧ kɛ́, nɛ́ wunɛ nje tɛm kɛ mbɔmbu *Mɔnɔ mumɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ nɛ yesɔ kɛ mɔy mbanjɔ Njambiyɛ. Yasi wɛtɛ, nɛ tu a ɗikima kwa̧ kɛ̀ ɗiyɔ kɛ *Keki mɛoliviye. ");
INSERT INTO kkj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ɓomɔ hɛnɛ ɗikima kɛ̀ ɓemɛŋmɛnɛ nɛ sut kɛ̀ mbanjɔ Njambiyɛ kɛ̀ wokɔ mɛlɛpi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ŋgimɔ jesɔ ɗyena mɛmampa mɛte yi kinɛ ŋga̧ kɛte kɛ́ ɓa̧ kɛ wuta. Ɓo jéɓaŋgwɛ jesɔ te nde *Paska Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ndana, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi sa̧ nje nda yi ɓo yakama wo nɛ Yesus kɛ́, kɛto ɓo ɓa̧ kɛ kambɔ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ndana, ɛ *Satan nyiŋɛ temɔ Yuda te yi ɓo ɗikima jeɓa sendi nde Iskariyot kɔ. A ɓa̧ kɛ njoka ɓejekɛ ɓe Yesus kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas kwaŋma kɛ̀ kombile ŋgiŋ ɓenɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓekum ɓe ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ yí ɓɛŋɛ nda yi nyɛ yakama ɗyaŋgwɛ nɛ Yesus nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓomɔ ɓaka wokuma mɛsosa ɓuɗyate. Ɛ ɓo pɛsɛ nde, ɓo ta nyɛ nyɛ mɔni. ");
INSERT INTO kkj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ɛ Yudas jayɛ. Ɛ nyɛ kandɛ saŋna kimɔ ŋgimɔ te yi nyɛ ta ɗyaŋgwɛ nɛ Yesus kinɛ nde, ɓomɔ dûkwɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yesɔ ɗyena mɛmampa mɛte yi kinɛ ŋga̧ kɛte kɛ́ ɗyaŋma. Yo ɓa̧ ŋgimɔ wona ɓɔnɔ ɓesam nɛ sadaka yi mɛɗye mɛ jesɔ *Paska Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ɛ Yesus tomɛ Piyɛr ɓenɛ Jaŋ lɛpɔ nde: «Wunɛ kɛ̂n kombile mɛɗye mɛ Paska te yusu, nɛ́ wusɛ ɗye.» ");
INSERT INTO kkj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɛ ɓo diyɛ nyɛ nde: «Wɛ kwáɗyikwɛ nde, wusɛ kɛ̂n kombile ɓa yo we?» ");
INSERT INTO kkj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Komɛ wunɛ ta kumɔ kɛ mɔy ɗya kɛ́, wunɛ ta saŋgwa nɛ wɛtɛ mbam nɛ mapi mɔrɔku. Wunɛ ɓêŋgwɛ nyɛ kumɔ kɛ tu̧ te yi nyɛ ta nyiŋɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɛ̀ wunɛ lɛ̂pi nyɛ sa tu̧ nde: ‹Yekele kɛ diyɛ wɛ nde: Mbɛy te yi sinɛ ɓejekɛ ɓembɛ ta ɗye Paska kɛte kɛ́ ɓa we?› ");
INSERT INTO kkj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A ta teɗye wɛtɛ nyaŋgwɛ toŋgari nyɛ wunɛ kɛ tu̧ kwey kɛ pay to te nɛ mɛyasi hɛnɛ gweya̧ kombilate kɛ mɔyte. Yo womɛte yi wunɛ ta kombile mɛɗye mɛ Paska.» ");
INSERT INTO kkj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓo ka̧, ɛ ɓo dolɛ mɛyasi hɛnɛ nda yi Yesus lɛpima nyɛ ɓo kɛ́. Ɛ ɓo kombile mɛɗye mɛ Paska. ");
INSERT INTO kkj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kɛ ŋgimɔ ɗyena mɛɗye mɛ Paska ma ɗya̧ kɛ́, ɛ nyɛ kɛ̀ ɗiyɔ ɓenɛ ɓotu ɓe tomun ɓenɛ yí ɗyena. ");
INSERT INTO kkj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Mi kwaɗya ɗye Paska te yɔkɔ nɛ temɔ mbɛ hɛnɛ sinɛ wunɛ kɛ ŋgimɔ te yi mi tì pa saŋgwa nɛ mɛbɔnɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kɛto mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Mi tí ɗye se yo na kumɔ kɛ ŋgimɔ te yi Njambiyɛ ta si teɗye to ɗyena mɛɗye mɛte kɛ *Kandɔ ɗyenɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɛ nyɛ ɓu̧ pelɔ nɛ tena mɛnjam kɛ mɔyte, nyɛ Njambiyɛ wosoko lɛpɔ nde: «Wunɛ ɓôŋ yo kaɓiɗya, ");
INSERT INTO kkj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kɛto mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Ko mi tí hɔɓiye se tena mɛnjam maka na kumɔ nde, *Kandɔ Njambiyɛ ɗyâŋ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kɛ kɔŋte, ɛ nyɛ ɓu̧ mampa. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ lekɛ yo nyɛ ɓo lɛpɔ nde: «Yikɛ mɛmbundɔ mɛmbɛ. Yo kɛ nyɛna kɛto yun. Wunɛ kɛ̂ kelɔ ɗekɛ ɗye takɛ nɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kɛ mɛɗye ma siyɔ kɛ́, ɛ nyɛ ɓu̧ sendi pelɔ tena mɛnjam nyɛ ɓo nda yi nyɛ kelma nɛ mampa kɛ́. Ɛ nyɛ lɛpɛ nde: «Pelɔ tena mɛnjam te yikɛ, yo jɔnja mbon te yi kɛ kelna nɛ mɛkiyɔ mɛmbɛ yi kɛ nyanja kɛto yun kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yasi wɛtɛ, wunɛ dûkwɛ nde: Mɔ te ɛ ta ɗyaŋgwɛ mi kɔ waka kɛ mɛɗye sinɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","*Mɔnɔ mumɔ ta kwa̧ gbate nda yi Njambiyɛ pɛsima kɛ́. Yasi wɛtɛ, mɛbɔnɛ ta ɓalɔ kɛ to mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndana, ɛ ɓo kandɛ mɛdiyna tandɛ yan kɛ kasi mɔ te ɛ yakama kelɔ kwalɔ mɛkele mɛte yite kɛ njoka yan kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɛ mɛtandɔ ɗya̧ sendi kɛ njoka ɓejekɛ, kɛto ɓo kwaɗya duwɛ mɔ te ɛ kwaŋma ɓɛsɔ kɛ njoka yan kɔ. ");
INSERT INTO kkj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Ɓekumande ɓe mɛnɛti kɛ ɗiyɔ nɛ ɓomɔ. Sendi, ɓotu ɓete ɓe namɛ ɓɛsɔ ɓaka, ɓo jéɓaŋgwɛ ɓo nde kimɔ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yasi wɛtɛ kɛ yun, kinɛ yaŋa ɗete na. Tomba kɛ njoka yun yâkaŋgwɛ ɓɛ nda jɔkiɗya. Mɔ te ɛ ɗiyɛ nɛ ɓɛsɔ kɔ yâkaŋgwɛ ɓɛ nda mɔnɔ mɛsay. ");
INSERT INTO kkj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nda kwa̧ jakɔsɔ? ’Yo mɔ te ɛ ɗiyɛ kɛ mbɛy mɛɗye laɗye kɔ, ho yɔkɔ ɛ ɓu̧ mɛɗye nje nyɛ jakɔsɔ kɔ? ’Yeti yɔkɔ ɛ ɗiyɛ kɛ mbɛy mɛɗye laɗye kɔ kwa̧ jakɔsɔ na? Yasi wɛtɛ, mi mbɛ nda mɔnɔ mɛsay kɛ njoka yun. ");
INSERT INTO kkj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wunɛ ɗiyma kpo nɛ kpo kɛ kɔŋ mbɛ kɛ ŋgimɔ te yi mi saŋgwama nɛ mɛbɔnɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ɗete, nda Saŋmbɛ nya mi ɗeti nde, mi nâm *Kandɔ ɗyenɛ kɛ́, mi sendi kɛ nyɛ wunɛ ɗeti te yi namɔ yo. ");
INSERT INTO kkj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ɗete, nɛ́ wunɛ ɗiy ɗyena, hɔɓiye kɛ mbɛy komɛ mi ɗyena kɛ Kandɔ ɗyembɛ kɛ́, nɛ́ wunɛ ɗiy kɛ nyaŋgwɛ mɛmbɛy pɛsɔ jɔsi mɛkandɔ kamɔ jɔ yiɓa ɓe kandɔ Isarayɛl.» ");
INSERT INTO kkj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ɛ Yesus lɛpɛ nyɛ Simɔn nde: «Simɔn, Simɔn, wokɔ kimɔte. *Satan diyma, na pɛpi wunɛ nda yi ɓo pɛpɛ nɛ lɛsi yí ɓakɛ nɛ njɔsɔ te nɛ̀ kopu te kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yasi wɛtɛ, mi ŋgwɛtama nɛ Njambiyɛ kɛto yɔ, ma wɛ mɛ nje ɗiyɔ kinɛ tikɔ se temɔ nɛ mi na. Yasi wɛtɛ, komɛ wɛ ta nje yeŋsa nɛ kɔkɔ jayɛ mi kɛ́, nɔ̀ nyɛ̂ki ɓemɔŋ ɗeti.» ");
INSERT INTO kkj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ko kɛna jɔɓɔ ko sɔŋ, mi gba nɛdɔ te yi kɛ̀ sinɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ɛ Yesus lɛpɛ nde: «Piyɛr, mi kɛ kombile lɛpɔ nyɛ wɛ nde: Wɛ ta tonɔ muka kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na, mbam kuɓɛ má nje kɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nyɛ ɓo nde: «Kɛ ŋgimɔ te yi mi tomma nɛ wunɛ kinɛ kom mɔni kinɛ koɓiyɛ kinɛ mɛnakala kɛ́, ’ɛ yaŋa ɓanɛ wunɛ?» Ɛ ɓo yeŋsa nde: «Ko yaŋa tì ɓanɛ wusɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ndana yɛy, mɔ te ɛ nɛ kom mɔni, a ɓôŋ. Mɔ te ɛ nɛ koɓiyɛ, a ɓôŋ. Ma yɔkɔ ɛ kinɛ kafa kɔ ɗyâŋgwɛ lambɔ nɛ ɓɔmɔ nɔ. ");
INSERT INTO kkj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kɛto mi kɛ kombile lɛpɔ nyɛ wunɛ nde: Mɛlɛpi mɛte yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ kasi mbɛ kɛ́ ta kelna gbate. Yo ɓa̧ kɛtinate nde: ‹Ɓo ɓoŋma nyɛ nda mɔ mɛɓeyɔ.› Yasi te yi yo kɛtinate kɛ kasi mbɛ kɛ́ ta ɓɛ kɛ si kelna.» ");
INSERT INTO kkj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɛ ɓejekɛ lɛpɛ nde: «Nyaŋgwɛ Kumande, mɛkafa yiɓa kɛ́.» Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yakama ɗete.» ");
INSERT INTO kkj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kɛ kɔŋte, ɛ Yesus pundɛ kɛ̀ kɛ *Keki mɛoliviye nda njɛl wenɛ. Ɛ ɓejekɛ ɓenɛ ɓeŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kɛ nyɛ ma kumɔ mate kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wunɛ ŋgwɛ̂taŋgwɛ nɛ Njambiyɛ, ma wunɛ mɛ nje ɓalɔ komɛ *Satan ta ɓoɓɛ wunɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kɛ kɔŋte, ɛ nyɛ jisɛ kɛ kɛki yan kɛ̀ nɛ naŋ nɛ mbɛt yaka lɔndɔ ɓetina kusu. Ɛ nyɛ kusɛ mɛɓɔŋ kɛ mɛnɛti ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Da, ŋgɛ wɛ kwaɗyɛ, kelɔ nde, nyaŋgwɛ mapi mɛbɔnɛ mɛte yikɛ ɗûkwɛ kɛ to mbɛ. Ma, yo tî kelnaŋgwɛ nda yi mi kwaɗyɛ kɛ́ na, yo kêlnaŋgwɛ nda yi wɛ kwaɗyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ndana, ɛ wɛtɛ jaki Njambiyɛ wulɛ ɗyoɓɔ nje nyɛ nyɛ ɗeti. ");
INSERT INTO kkj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dodo sɔŋ ɓiyma Yesus. Ɛ nyɛ ŋgwɛta nɛ Njambiyɛ nɛ tiŋ, ɓiriki punduma kɛ yotu nɛ ɓalɔ kɛ mɛnɛti nda yi mɛkiyɔ ɗɔɗya nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kɛ nyɛ ma si ŋgwɛta kɛ́, ɛ nyɛ tɛmɛ kɛ̀ komɛ ɓejekɛ ɗiyma kɛ́. A dolma ɓo kɛ jakɔ, kɛto mɛtakɛ kwaŋma ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ yáki kɛto ŋge? Wunɛ tɛ̂ma ŋgwɛta nɛ Njambiyɛ, ma mɛɓoɓilan nje laŋsa wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus ɓa̧ ndi kɛ lɛpina ɗete kɛ́, yaka nɔ, ŋgil kɛ ɗya̧. Yudas te ɛ ɓa̧ kɛ njoka ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kɔ ɓɛ to njɔŋ te. Ɛ nyɛ kɛ̀ kɛ kɛki Yesus, na dul numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Yudas, ’wɛ kɛ ɗyaŋgwɛ ka *Mɔnɔ mumɔ nɛ nje dulna numbu nɛ?» ");
INSERT INTO kkj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kɛ ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ Yesus ɓaka ma ɓɛŋɛ yasi te yi kɛ kwaɗyɛ kelna kɛ́, ɛ ɓo lɛpɛ nde: «Nyaŋgwɛ Kumande, ’wusɛ kɔ̂tu ɓo nɛ mɛkafa?» ");
INSERT INTO kkj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɛ wɛtɛ kɛ njoka yan kɔtɛ mɔ mɛsay mɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ pɛsɔ tɔ nɛ ɛ mbam ɓɔ ɓetɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yasi wɛtɛ, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ tîki, yo ɗîy ɗete.» Ɛ nyɛ kpokɛ tɔ mbam te joŋgwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ɛ Yesus nje lɛpɔ nyɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓekum ɓe ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya ɓe nja̧ kɛ ɓiyna nɛ ɓaka nde: «Wunɛ nja̧ nɛ mɛkafa nɛ̀ mɛtegbe yí nje ɓiye nɛ mi nda yi ɓo ɓeŋgwɛ nɛ mɔ guɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mi ɗikima ɗiyɔ mɛtu hɛnɛ sinɛ wunɛ kɛ mbanjɔ Njambiyɛ, wunɛ tì ɓiye mi na. Yo ndi nde, ŋgimɔ yun ɗyaŋma, ɓu̧ sendi ŋgimɔ te yi *Satan.» ");
INSERT INTO kkj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kɛ ɓo ma si ɓiye Yesus kɛ́, ɛ ɓo ɓu̧ nyɛ kɛ̀ nɔ kɛ tu̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. Piyɛr ɗikima ɓeŋgwɛ ɓo nɛ naŋ. ");
INSERT INTO kkj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɓo joŋgwa ɗitɛ kɛ ɓembe sɛ̧ ɗiyɔ kɛ kɛkite. Ɛ Piyɛr nje ɗiyɔ sendi kɛ njoka yan. ");
INSERT INTO kkj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Wɛtɛ nya te ɛ ɗikima kelɔ mɛsay kɛ tu̧ kɔ ɓɛŋma nyɛ kɛ ɗiyɔ kɛ kɛki ɗitɛ. Ɛ nyɛ seŋgile nyɛ lɛpɔ nde: «Mbam kɔ ɓa̧ sendi ɓenɛ nyɛ!» ");
INSERT INTO kkj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yasi wɛtɛ, ɛ Piyɛr tonɛ lɛpɔ nde: «Nyari, mi yeti kɛ duwɛ nyɛ na!» ");
INSERT INTO kkj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɗiyɔ nɛ mbɛt kɛ kɔŋte kɛ́, ɛ wɛtɛ mbam ɓɛŋɛ nyɛ lɛpɔ nde: «Wɛ sendi kɛ njoka ɓotu ɓete.» Ɛ Piyɛr lɛpɛ nde: «Mbam, mi yeti kɛ mɔyte na!» ");
INSERT INTO kkj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɗiyɔ nda hawa wɛtɛ kɛ kɔŋte kɛ́, ɛ wɛtɛ mbam nje ɓasiɗye lɛpɔ sendi nde: «Gbate, mbam kɔ ɓa̧ sendi ɓenɛ nyɛ, kɛto nyɛ sendi mɔ Galile!» ");
INSERT INTO kkj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɛ Piyɛr yeŋsa nde: «Mbam, mi yeti kɛ duwɛ yasi te yi wɛ kwaɗyɛ lɛpɔ kɛ́ na!» Piyɛr ɓa̧ ndi kɛ lɛpɔ ɗete kɛ́, ɛ mbam kuɓɛ kɔkɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ɛ Kumande Yesus yeŋsa ɓɛŋɛ Piyɛr nɛ ŋgoŋ. Ɛ Piyɛr nje takɛ lɛpi te yi Kumande Yesus ma lɛ́pi nyɛ nyɛ nde: ‹Wɛ ta tonɔ muka kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na, mbam kuɓɛ má nje kɔkɔ.› ");
INSERT INTO kkj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɛ Piyɛr pundɛ kɛ̀ lelɔ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɓembam ɓete ɓe ɓa̧ kɛ ɓakiɗye Yesus ɓaka ɗikima nyɛtɔ nyɛ, mɛndɛ sendi nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓo wotuma misi mɛnɛ nje lɛpɔ nyɛ nyɛ nde: «Tuɓɔ mɔ te ɛ mɛndima wɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓo ka̧ sendi mbɔmbu yí lɛpɔ sendi yiŋa ɓuɗya mɛlɛpi mɛ gbutu suŋgwɛ nɛ nyɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kɛ misi ma pupɔ kɛ́, ɛ njɔŋ ɓetomba ɓe ɗya wesiɗya ɓenɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe teɗya mɛmboŋga. Ɛ ɓo tomɛ ɓomɔ kɛ̀ ɓu̧ nɛ nyɛ nje nɔ kɛ mbɛy nyaŋgwɛ jɔsi yan. ");
INSERT INTO kkj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɛ ɓo lɛpɛ nde: «Ŋgɛ ɓɛ nde, wɛ *Krist, lɛpɔ nyɛ wusɛ.» Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ŋgɛ mi lɛpɛ nyɛ wunɛ, wunɛ tí jayɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sendi, ŋgɛ mi diyɛ wunɛ mɛdiyan, wunɛ tí yeŋsa nyɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kandɛ ndana *Mɔnɔ mumɔ ta ɗiyɔ kɛ mbam ɓɔ Njambiyɛ te ɛ nɛ ŋguŋguɗyɛ hɛnɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ndana, ɛ ɓo hɛnɛ lɛpɛ nde: «’Yite nde, wɛ Mɔnɔ Njambiyɛ?» Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yo nda yi wunɛ lɛpɛ kɛ́, mi Mɔnɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɛ ɓo nje lɛpɔ nde: «Ŋge yi ɓo ta lɛpɔ sendi nyɛ wusɛ kɛ́? Wusɛ ma wokɔ nda yi nyɛ lɛpima nɛ numbu nɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kɛ kɔŋte, ɛ nyaŋgwɛ ɓomɔ ɓaka hɛnɛ tɛmɛ nɛ gam ɓu̧ Yesus kɛ̀ nɔ kɛ yi Pilat. ");
INSERT INTO kkj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɛ ɓo kandɛ lɛpɔ mɛyasi suŋgwɛ nɛ nyɛ nde: «Wusɛ dolma mbam kɔ kɛ teɗye ɗetina to nyɛ ɓotu ɓe kandɔ ɗyusu. A kɛ kiɗyɛ ɓomɔ nde, ɓo tî gboku garama nyɛ *Sesar na. A kɛ lɛpɔ sendi nde, nyɛ *Krist, nyɛ kumande.» ");
INSERT INTO kkj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ɛ Pilat diyɛ nyɛ nde: «Wɛ kumande Ɓeyudɛn?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Yo nda yi wɛ lɛpɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ɛ Pilat nje lɛpɔ nyɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ŋgil ɓomɔ nde: «Mi yeti kɛ ɓɛŋɛ mbɛ yiŋa mɛjɔsɔ kɛ yotu mbam kɔ na.» ");
INSERT INTO kkj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko ɓɛkɔ ɗete, ɓo ka̧ ndi mbɔmbu lɛpɔ nɛ ɗeti kwa̧ to te nde: «A kɛ ɗesɛ to ɓomɔ nɛ teɗya yasi nɛ kandɛ kɛ Galile nɛ̀ Yuda hɛnɛ nje kumɔ nɔ ndana waka.» ");
INSERT INTO kkj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kɛ Pilat ma wokɔ kasi Galile kɛ́, ɛ nyɛ diyɛ nde: «Mbam kɔ mɔ Galile?» ");
INSERT INTO kkj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kɛ nyɛ ma wokɔ nde, Yesus wókunaŋgwɛ nɛ Herod kɛ́, ɛ nyɛ kwaŋɗye nyɛ kɛnjɛ nyɛ, kɛto Herod ɓa̧ sendi kɛ Yerusalɛm kɛ pɔku mɛtu mɛte yite. ");
INSERT INTO kkj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kɛ kumande Herod ma ɓɛŋɛ Yesus kɛ́, ɛ nyɛ sosa ɓuɗyate, kɛto a ɓa̧ nɛ yɛsiɗyɛ ɓɛŋna nɛ njombu yaŋa, kɛto mɛyasi mɛte yi nyɛ ɗikima wokɔ kɛ kasi nɛ kɛ́. Herod ɓa̧ kɛ takɛ sendi nde, Yesus ta kelɔ yiŋa mɛyekambiyɛ kɛ misi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɛ nyɛ diyɛ Yesus ɓuɗya mɛdiyan. Ko ɗete, a tì yeŋsa yaŋa nyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe kɛtina mɛyasi ɓa̧ sendi te, ɗiki pɛsɔ ɓeya mɛlɛpi nyɛ kɛ numbu nɛ nɛ ŋgaŋ. ");
INSERT INTO kkj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod ɓenɛ ɓesɔja ɓenɛ yɛliya nyɛ wuŋgwɛ nyɛ. Ɓo lɛnja nyɛ kpasa lambɔ. Kɛ kɔŋte, ɛ Herod yɔkiɗye nyɛ kɛnjɛ Pilat. ");
INSERT INTO kkj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kɛ kiya yesɔ te ɛ Pilat ɓenɛ Herod ɓiye mɛsɔ. Nɛ mbɔmbu, ɓo ɓa̧ nɛ pendɔ. ");
INSERT INTO kkj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ndana, ɛ Pilat wesiɗye ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓomɔ ɓe kandɔ Ɓeyudɛn nɛ̀ ɓekum ɓan hɛnɛ lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","«Wunɛ ɓoŋma mbam kɔ nje nɔ kɛ yembɛ nde, a kɛ ɗesɛ to ɓomɔ. Ndana ndana mi diyma nyɛ mɛdiyan kɛ misi mun. Yasi wɛtɛ, mi tì ɓɛŋɛ mɛjɔsɔ wɛtɛ nɛ wɛtɛ kɛ yotu nɛ nda yi wunɛ lɛpima kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod sendi tì ɓɛŋɛ mɛjɔsɔ kɛ yotu nɛ na, yori yi nyɛ yɔkiɗya sendi nyɛ njesɛ wusɛ kɛ́. Ɗete, mbam kɔ tì kelɛ yiŋa yaŋa yi yakama nde, a sɔ̂mbu sɔŋ kɛto te na.» ");
INSERT INTO kkj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ɛ Pilat lɛpɛ nde: «Yi ɓa̧ ɗete kɛ́, mi ta lɛpɔ nde, ɓo njûru nyɛ, má nje soŋɛ ɓɔ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yo ɓa̧ tumbu kɛ yan nde, kɛ ŋgimɔ jesɔ *Paska yan hɛnɛ Pilat sôŋa ɓɔ nɛ mɔ jɔɓɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɛ ɓo hɛnɛ ŋgbɔ kembɔ ndi tu wɛtɛ nde: «Mbam kɔ gwâki, nɔ̀ sôŋa ɓɔ nɛ Barabas yɔkiɗye nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ɓo nyɛ́ki Barabas kɛ jɔɓɔ, kɛto a ɗesa to ɓomɔ suŋgwɛ nɛ ɓekum ɓe ɗya nɛ̀ kɛto wona mumɔ. ");
INSERT INTO kkj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ɛ Pilat ɓasiɗye lɛpina nyɛ ɓomɔ, kɛto a kwaɗya soŋɛ ɓɔ nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko ɓɛkɔ ɗete, ɓo ka̧ mbɔmbu kembɔ nde: «Ŋgbakɔ nyɛ kɛ kroa. Ŋgbakɔ nyɛ kɛ kroa.» ");
INSERT INTO kkj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ɛ Pilat lɛpɛ nyɛ ɓo kɛ mɛŋga yitatite nde: «Ma yo kwalɔ ɓeya yasi te nda yi nyɛ kelma kɛ́? Mi tì ɓɛŋɛ yiŋa mɛjɔsɔ kɛ yotu nɛ yi yakama nde, a sɔ̂mbu sɔŋ kɛto te na. Mi ta lɛpɔ nde, ɓo njûru nyɛ, má nje soŋɛ ɓɔ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ko ɗete, ɓo ka̧ ndi mbɔmbu nɛ ɓeya mɛkembi lɛpɔ nde, ɓo ŋgbâki Yesus kɛ kroa. Ɛ mɛkembi man laŋsa. ");
INSERT INTO kkj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ɛ Pilat lɛpɛ nde, yasi te yi ɓo diyma kɛ́ ta kelna. ");
INSERT INTO kkj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɛ nyɛ nje soŋɛ ɓɔ nɛ yɔkɔ yi ɓo nya nyɛ kɛ jɔɓɔ kɛto ɗesa to ɓomɔ suŋgwɛ nɛ ɓekum ɓe ɗya nɛ̀ kɛto wona mumɔ kɔ. Yo nyɛ yi ɓo ɓa̧ kɛ kwaɗyɛ. Ɛ nyɛ nje kaŋɛ Yesus nyɛ ɓo, nɛ́ ɓo kel nɛ nyɛ nda yi ɓo kwaɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ ɓu̧ Yesus kwa̧ nɔ kɛ́, ɛ ɓo saŋgwa nɛ wɛtɛ mbam nde Simɔn, mɔ Sirɛn kɛ yɔkwɛ ŋgwaŋ. Ɛ ɓo ɓiye nyɛ soɓiɗye nyɛ kroa nde, a kɛ̂ndi nɔ kɛ kɔŋ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nyaŋgwɛ ŋgil ɓotu ɓe ɗya nɛ̀ ɓaŋa ɓomari ɓa̧ kɛ ɓeŋgwɛ Yesus. Ɓoma ɓete ɓa̧ kɛ jaɓa wo yotu kɛto nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ɛ Yesus yeŋsa ɓɛŋɛ ɓomari lɛpɔ nyɛ ɓo nde: «Wunɛ ɓoma ɓe Yerusalɛm, wunɛ tî lel kɛto mbɛ na, yasi wɛtɛ, wunɛ lêl kɛto yun nɛ̀ kɛto ɓɔnɔ ɓun. ");
INSERT INTO kkj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kɛto wunɛ dûkwɛ nde, mɛtu ta ɗya̧ yi ɓomɔ ta lɛpɔ nde: ‹Ɓekundu nɛ̀ ɓomari ɓete ɓe tì ja yí nyɛ nɛ ɓɔnɔsikɛ ɓɛri wɛtɛ yesɔ ɓaka nɛ mɛsosa.› ");
INSERT INTO kkj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kɛ ŋgimɔ te yite ɓomɔ ta lɛpɔ nyɛ mɛkeki nde: ‹Wunɛ ɓâl kɛ to su.› Ɓo ta lɛpɔ sendi nyɛ mɛkoru nde: ‹Wunɛ mbâsi wusɛ.› ");
INSERT INTO kkj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma ŋgɛ ɓo kelɛ ɗete nɛ ɓɔsuna jeti, yo má nje ɓɛ nan nɛ sɔsuna jeti?» ");
INSERT INTO kkj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kɛ ŋgimɔ te yi ɓo ɓoŋma Yesus kwa̧ nɔ kɛ́, ɛ ɓo ɓu̧ sendi ɓotu ɓe kelna nyaŋgwɛ ɓeya mɛkele yiɓa, nɛ́ ɓo kɛ̀ wo ɓo nda Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kɛ ɓo ma kumɔ kɛ mbɛy te yi ɓo jeɓa nde Gboŋgo to kɛ́, ɛ ɓo ŋgba Yesus womɛte kɛ kroa, ŋgba sendi ɓotu ɓe nyaŋgwɛ ɓeya mɛkele ɓaka yiɓa, wɛtɛ kɛ kroa te wenɛ pulɔ mbam ɓɔ Yesus, wɛtɛ kɛ wenɛ pulɔ gare nɛ. ");
INSERT INTO kkj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ɛ Yesus lɛpɛ nde: «Da, tikɔ ɓo nɛ ŋgwɛtɛ, kɛto ɓo yeti kɛ duwɛ yasi te yi ɓo kelɛ kɛ́ na.» Ɓo ɓoŋma mɛlambɔ mɛnɛ lu̧ kɛ mbari yí kaɓiɗya nɛ yo. ");
INSERT INTO kkj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓomɔ ɓa̧ womɛte ɗiki ɓɛŋɛ. Ɓekum ɗikima nyɛtɔ nyɛ lɛpɔ nde: «A ɗikima joŋgwɛ ɓaŋa ɓomɔ. Ma ndana, a jôŋgwɛ yotu nɛ nɛ ŋguru wenɛ, ŋgɛ ɓɛ nde, nyɛ *Krist te yi Njambiyɛ tɔkuma kɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ɓesɔja ɗikima nyɛtɔ nyɛ sendi. Ɓo ka̧ kɛ kɛki nɛ jɛkiɗye ɗyanjina mɛnjam nyɛ nyɛ ");
INSERT INTO kkj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","lɛpɔ nde: «Ŋgɛ ɓɛ nde, wɛ kumande Ɓeyudɛn, joŋgwɛ yotu yɔ nɛ ŋguru wɔ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɓo kɛtima yiŋa yasi ŋgba kɛ to kroa nɛ nde: ‹Yɔkɔ kumande Ɓeyudɛn.› ");
INSERT INTO kkj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kɛ njoka ɓotu ɓe kelna nyaŋgwɛ ɓeya mɛkele yi ɓo ŋgbama kɛ kroa ɓaka, wɛtɛ toyma Yesus lɛpɔ nyɛ nyɛ nde: «’Wɛ yeti *Krist na? Joŋgwɛ yotu yɔ nɛ ŋguru wɔ, nɛ̀ wɛ joŋgwɛ sendi wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɛ yɔru ndeyɛ nyɛ lɛpɔ nde: «Yo ŋge, wɛ ti kámbi Njambiyɛ na? Mbam kɔ kɛ saŋgwa nɛ kiya mɛndeya nɛ̀ mɛbɔnɛ nda wusɛ. ");
INSERT INTO kkj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nɛ̀ wɛ nɛ̀ mi, yusu yakama nɛ wusɛ ɓeŋgwɛ nyaŋgwɛ ɓeya mɛkele musu. Kɛ ɓɛ mbam te yɔkɔ, a tì kelɛ nɛ ɓeya yaŋa na.» ");
INSERT INTO kkj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɛ nyɛ nje lɛpɔ nde: «Yesus, nɔ̀ tâka mi komɛ wɛ ta nje namɔ mbokɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Muka sinɛ wɛ ta ɗiyɔ kɛ *Paradis!» ");
INSERT INTO kkj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yo ɓa̧ kɛ pɔku ɓembe yesɔ, ɛ yitil kelɛ kɛ to mɛnɛti hɛnɛ kumɔ kɛ hawa yitati te yi ɓekoko. ");
INSERT INTO kkj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ɛ misi mɛ yesɔ ɗiɓiɗya. Ɛ nyaŋgwɛ lambɔ te yi ɓa̧ kɛsate kɛ mbɛy te yi nɛ kiyɔ kɛ mbanjɔ Njambiyɛ kɛ́ nyaliyɛ kɛ ɓembe. ");
INSERT INTO kkj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɛ Yesus kembɛ lɛpɔ nɛ mɛn kɛ kwey nde: «Da, mi kɛ yɔkiɗye Sisiŋ mbɛ nyɛ kɛ mɛɓɔ mɔ!» Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ jɛyɛ gwe. ");
INSERT INTO kkj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kɛ kum ɓesɔja te ɛ ɓa̧ womɛte kɔ ma ɓɛŋɛ yasi te yi kwaŋnama kɛ́, ɛ nyɛ lukse Njambiyɛ lɛpɔ nde: «Mbam kɔ ɓa̧ gbate ŋgbeŋ mumɔ!» ");
INSERT INTO kkj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɓomɔ nja̧ nɛ ŋgil yí nje ɓɛŋɛ yasi te yi kwaŋnama kɛ́. Kɛ ɓo ma si ɓɛŋɛ mɛkele mɛnɔri kɛ́, ɛ ɓo hɛnɛ kpo ɓɔ kɛ ɓeti jaɓa ɗuwɛ nɔ. ");
INSERT INTO kkj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ɓenjɔŋ ɓe Yesus hɛnɛ nɛ̀ ɓoma ɓete ɓe ɓeŋgwa nyɛ kandɛ Galile ɓaka ɗiyma nɛ naŋ ɓɛŋɛ mɛyasi mɛte yi ɓa̧ kɛ kwaŋna kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wɛtɛ mbam nde Yosɛp ɓa̧ kɛ njɔŋ nyaŋgwɛ jɔsi Ɓeyudɛn. A ɓa̧ kimɔ mumɔ, ɓɛ sendi nɛ ŋgbeŋ. ");
INSERT INTO kkj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A ɓa̧ mɔ Arimate kɛ mɛnɛti mɛ Ɓeyudɛn. Sendi, a ɓa̧ kɛ laɗye *Kandɔ Njambiyɛ. A tì nyɛ numbu nɛ kɛ mɛlɛpi nɛ̀ kɛ mɛyasi mɛte yi ɓenjɔŋ ɓenɛ pɛsima kɛ kasi Yesus kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɛ nyɛ kɛ̀ kɛ yi Pilat kɛ̀ diyɛ muŋ Yesus. ");
INSERT INTO kkj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ɛ Pilat jayɛ. Ɛ Yosɛp piɗyɛ muŋ Yesus kɛ kroa ɓɔyɛ nɛ ndɔmbɔ ɓu̧ kɛ̀ niŋgwɛ kɛ mɔy ɓoŋsɔŋ te yi ɓo timma kɛ nyaŋgwɛ tari kɛ́. Ɓo tì pumbɛ wɛtɛ mumɔ kɛte nɛ mbɔmbu na. ");
INSERT INTO kkj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yo ɓa̧ yesɔ te yi ɓo ɗiki komsa kɛte kɛ́, sendi ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt, nɛ́ *Saba kandi. ");
INSERT INTO kkj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓoma ɓete ɓe ɓeŋgwa Yesus wulɛ Galile ɓaka ka̧ tikiɗye Yosɛp kɛ mbɛy ɓoŋsɔŋ. Ɓo ɓɛŋma ɓoŋsɔŋ ɓɛŋɛ sendi nda yi ɓo niŋgwa nɛ muŋ Yesus kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɓo yɔkwa̧ mate kɛ̀ kombile yiŋa mɛmutɔ mɛte yi ɓa̧ nɛ kimɔ mɛtul nɛ̀ mɛlɔbinda. Kɛ yesɔ Saba ma ɗya̧, ɛ ɓo wɛɗya ɓeŋgwɛ mɛmboŋga man. ");
INSERT INTO kkj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Misi pupɛ kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi, ɛ ɓoma ɓaka tɛmɛ ɓemɛŋmɛnɛ nɛ sut, ɓu̧ mɛmutɔ mɛte yi ɓo kombila kɛ́ kɛ̀ nɔ kɛ ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓo ka̧ dolɔ nde, ɓo ma njeŋɛ tari te yi ɓo ɗiɓima nɛ numbu ɓoŋsɔŋ kɛ́ soŋɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɛ ɓo nyiŋɛ kɛ mɔyte kinɛ ɓɛŋɛ muŋ Kumande Yesus na. ");
INSERT INTO kkj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kɛ ŋgimɔ te yi ɓo ɓa̧ ndi kɛ ŋgbakima yasi te yi kwaŋnama kɛ́, ɓo sém semɔ, ɓembam yiɓa kɛ kɛki yan nɛ wumna mɛlambɔ nɛ mboŋ mboŋ. ");
INSERT INTO kkj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɛ ɓoma gwe wɔ̧ ɓuɗyate sɔkwɛ mɛmbɔmbu ɓɛŋɛ mɛnɛti. Ɛ ɓembam ɓenɔri lɛpɛ nyɛ ɓo nde: «Ŋge kelɛ yi wunɛ sa̧ mɔ te ɛ nɛ joŋ kɛ mbɛy ɓemuŋ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesus yeti se waka na, a womiya. Wunɛ tâka yasi te yi nyɛ lɛpima nyɛ wunɛ kɛ ŋgimɔ te yi nyɛ ɓa̧ nɔ kɛ Galile kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A lɛpima nde: ‹Yo kponate nde, ɓo ta ɗyaŋgwɛ *Mɔnɔ mumɔ nyɛ ɓotu ɓe mɛɓeyɔ. Ɓo ta ŋgba nyɛ kɛ kroa, a má nje womiyɛ kɛ mɛtu yitati.› » ");
INSERT INTO kkj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ndana, ɛ ɓoma nje takɛ mɛlɛpi mɛte yi Yesus lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɛ ɓo yɔkwɛ kɛ ɓoŋsɔŋ kɛ̀ yekiɗye mɛyasi mɛte yi kwaŋnama hɛnɛ kɛ́ nyɛ ɓejekɛ kamɔ jɔ wɛtɛ nɛ̀ ɓari hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓoma ɓete ɓe yekiɗya mɛyasi mɛte nyɛ ɓotu ɓe tomun ɓe Yesus ɓaka ɓa̧ Mariya, ŋgɔndu Magdala nɛ̀ Yuwana nɛ̀ Mariya te nyaŋgwɛ nɛ Jak nje ɓu̧ ɓoma ɓete ɓe ɓenɛ ɓo ka̧ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɓotu ɓe tomun ɓe Yesus tì jayɛ mɛyasi mɛte yi ɓoma yekiɗya nyɛ ɓo kɛ́ na. Ɓo ɓoŋma yo nda kanɔ. ");
INSERT INTO kkj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ko ɗete, ɛ Piyɛr sɛɗyɛ kwa̧ kɛ̀ kɛ ɓoŋsɔŋ. A ɓutumama, ɛ nyɛ ɓɛŋɛ ndi mɛndɔmbɔ kɛ mɛnɛti. Kɛ kɔŋte, ɛ nyɛ ŋgbakima yasi te yi kwaŋnama kɛ́ ɓuɗyate kwa̧ nɔ kɛ̀ tu̧ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kɛ kiya yesɔ te ɓejekɛ ɓe Yesus yiɓa tɛmma yí kɛ̀ kɛ wɛtɛ ɗya nde Emayus, lɔndɔ te kilomɛta kamɔ jɔ wɛtɛ nɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɓo ɓa̧ kɛ nyɛ mɛsimɔ kɛ kasi mɛyasi mɛte yi kwaŋnama hɛnɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ nyɛ mɛsimɔ ɓiye nɛ mɛso ɗete kɛ́, ɛ Yesus nje dolɔ ɓo tɔkɛ kɛndi ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko ɗete, yiŋa yaŋa ɗiɓima misi man, ma ɓo mɛ nje duwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɛ nyɛ diyɛ ɓo nde: «Yo mɛsimɔ mɛ ŋge yi wunɛ nyɛ kɛndɔ nɔ kɛ́?» Ɛ ɓo tɛmɛ nɛ tiŋna mɛŋgembi. ");
INSERT INTO kkj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kɛ njoka yan yiɓa, ɛ wɛtɛ nde Kleyopas yeŋsa nyɛ nyɛ nde: «’Gba siya mɔ te ɛ ɗiyɛ kɛ Yerusalɛm kinɛ duwɛ mɛyasi mɛte yi kwaŋnama kɛ mɛtu mɛte yikɛ kɛ́ ndi gba wɛ nyɛpɔ?» ");
INSERT INTO kkj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ɛ Yesus diyɛ ɓo nde: «Yo ŋge yi kwaŋnama kɛ́?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Yo kasi Yesus te mɔ Nasarɛt. A ɓa̧ ɗetina mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ mɛkele nɛ̀ kɛ mɛlɛpi kɛ mbɔmbu Njambiyɛ nɛ̀ kɛ mbɔmbu ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɓekum ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓekum ɓusu ɓoŋma nyɛ nyɛ ɓekum ɓe Rom ɓe ɗiyɛ nɛ ɗya ɓaka, nɛ́ ɓo wo nyɛ. Ɛ ɓo ŋgba nyɛ kɛ kroa. ");
INSERT INTO kkj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wusɛ ɓa̧ nɛ ɓiɓina temɔ nde, yo nyɛ ta soŋɛ kandɔ Isarayɛl kɛ ɓeya ɗiyɔ. Yasi wɛtɛ, nɛ takinate yinɔri hɛnɛ, yo mɛ kɛ̀ muka mɛtu yitati yi mɛyasi mɛte kwaŋnama nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kɛ kimɔ lɛpinate ɓaŋa ɓoma kɛ njoka su nja̧ lekɛ temɔ su. Ɓo tɛmma muka ɓemɛŋmɛnɛ nɛ sut kɛ̀ kɛ ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yasi wɛtɛ, ɓo tì dolɛ muŋ nɛ na. Ɓo yɔkwa̧ nje yekiɗye nyɛ wusɛ nde, ɓejaki ɓe Njambiyɛ punja yotu nyɛ ɓo. Ɛ ɓejaki lɛpɛ nyɛ ɓo nde, a nɛ joŋ. ");
INSERT INTO kkj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kɛ kɔŋte, ɓaŋa ɓenjɔŋ ɓusu nja̧ kɛ̀ sendi kɛ ɓoŋsɔŋ. Ɛ ɓo ɓɛŋɛ mɛyasi ndi nda yi ɓomari yekiɗya kɛ̀. Ndi nyɛ, ɓo tì ɓɛŋɛ nyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ndana, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ ɓotu ɓete ɓe kinɛ ɗyanɔ ɓaka, wunɛ yeti kɛ tikɔ temɔ kɛ mɛyasi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ nɛdɔ na. ");
INSERT INTO kkj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","’Yo tì ɓɛ nde, *Krist sâŋgwaŋgwɛ nɛ mɛbɔnɛ ɗete, na nje ɓɛ nɛ mɛluksa mɛnɛ na?» ");
INSERT INTO kkj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɛ nyɛ nje nɛmbɛ kasi joŋgwɛ ɗyenɛ kɛ mɔy mɛkana mɛ Njambiyɛ hɛnɛ kandɛ kɛ mɛkana mɛte yi Mɔyisi kɛtima kɛ́ kɛ̀ nɔ kɛ mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kɛ ɓo ma wuta nɛ ɗya te yi ɓejekɛ ɓa̧ kɛ kɛ̀ kɛte kɛ́, ɛ nyɛ kelɛ nda a kɛ kwa̧ li̧ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yasi wɛtɛ, ɛ ɓejekɛ jeliyɛ nyɛ lɛpɔ nde: «Yakɔ sinɛ wunɛ, kɛto ɓekoko ma ɗya̧, yesɔ ma ɓalɔ.» Ɛ nyɛ nyiŋɛ tu̧, na kɛ̀ ya ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kɛ nyɛ ma kwa̧ ɗiyɔ ɓenɛ ɓo kɛ mbɛy mɛɗye kɛ́, ɛ nyɛ ɓu̧ mampa nyɛ Njambiyɛ wosoko lekɛ nje ɓu̧ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ndana, ɛ misi man ɓutuna, ɛ ɓo nje duwɛ nyɛ. Yasi wɛtɛ, ɛ nyɛ ɗimbiyɛ kɛ misi man. ");
INSERT INTO kkj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɛ ɓo lɛpɛ tandɛ yan nde: «’Lɛpi te yi nyɛ ɗikima lɛpɔ nyɛ wusɛ kɛ nje nɛ̀ nɛmbina mɛlɛpi mɛte yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ te yi nyɛ ɗikima nɛmbɛ kɛ́ tì lu̧ wusɛ kɛ temɔ na?» ");
INSERT INTO kkj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɛ ɓo tɛmɛ ndi kɛ kiya ŋgimɔ te yɔkwɛ kɛ̀ Yerusalɛm dolɔ ɓejekɛ kamɔ jɔ wɛtɛ nɛ̀ ɓenjɔŋ ɓan kɛ mbɛy wɛtɛ ");
INSERT INTO kkj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kɛ lɛpɔ nde: «Kumande Yesus womiya gbate. A punja yotu nyɛ Simɔn.» ");
INSERT INTO kkj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɛ ɓejekɛ ɓaka yiɓa nje yekiɗye sendi yasi te yi kwaŋnama nɛ ɓo kɛ nje kɛ́. Ɓo yekiɗya nda yi ɓo nja̧ duwɛ nɛ nyɛ kɛ ŋgimɔ te yi nyɛ lekima nɛ mampa kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kɛ ŋgimɔ te yi ɓo ɓa̧ ndi kɛ yekiɗye ɗete kɛ́, ɓo sém semɔ, Yesus ɗyaŋma kɛ njoka yan lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy nɛ tɛ!» ");
INSERT INTO kkj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɛ ɓo gwe wɔ̧ ŋgwaŋgwa takɛ nde, ɓo ɓɛ́ŋa ablasa. ");
INSERT INTO kkj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kɛto ŋge yi wunɛ gwe wɔ̧ kɛ́? Kɛto ŋge yi wunɛ ɓɛ sendi nɛ njɛl mɛtakɛ te yite kɛ mɔy mɛtemɔ mun kɛ́? ");
INSERT INTO kkj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wunɛ ɓɛ̂ŋa mɛɓɔ mɛmbɛ nɛ̀ mɛkol mɛmbɛ. Yo mi gbate gbate. Wunɛ ɓôɓila yotu mbɛ, nɛ́ wunɛ ɓɛŋa kimɔte, kɛto ablasa yeti nɛ mɛmbundɔ nɛ̀ mɛyesɔ nda yi mi tɛmɛ nɔ kɛ mbɔmbu wun kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɛ nyɛ lɛpɛ ɗete teɗye nɛ ɓo mɛɓɔ nɛ̀ mɛkol mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɓo tì jayɛ nɛdɔ na, kɛto mɛsosa kwaŋma ɓo. Nda ɓo ka̧ ndi mbɔmbu yi ŋgbakima kɛ́, ɛ nyɛ diyɛ ɓo nde: «Wunɛ nɛ yiŋa yasi waka yi mumɔ yakama ɗye?» ");
INSERT INTO kkj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɛ ɓo ɓu̧ ɓumbuna njanjɔ nɛ̀ papi jo wɛtɛ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɛ nyɛ ɓu̧ yo ɗye kɛ misi man. ");
INSERT INTO kkj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Kɛ ŋgimɔ te yi mi ɓa̧ nɔ sinɛ wunɛ kɛ́, mi ɗikima lɛpɔ nyɛ wunɛ nde: Mɛyasi hɛnɛ te yi ɓa̧ kɛtinate kɛ kasi mbɛ kɛ mɔy mɛkana mɛ mɛmboŋga te yi Mɔyisi kɛtima nɛ̀ kɛ mɔy mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ nɛ̀ kɛ mɔy mɛkana mɛ Ɓesom kɛ́ ta kelna gbate.» ");
INSERT INTO kkj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ndana, ɛ nyɛ ɓutɛ ɗyanɔ ɗyan, nɛ́ ɓo woku nɛ to mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yo kɛtinate nde, *Krist ta saŋgwa nɛ mɛbɔnɛ gwe nje womiyɛ kɛ njoka ɓemuŋ kɛ mɛtu yitati. ");
INSERT INTO kkj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɓo ta pelɛ nyɛ mɛkandɔ hɛnɛ nɛ ɗinɔ ɗyenɛ nde, ɓo yêŋsaŋgwɛ mɛtemɔ jayɛ mɛɓeyɔ man, nɛ́ Njambiyɛ tiki ɓo nɛ ŋgwɛtɛ. Ɓo ta pelɛ kandɛ kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wunɛ ta yekiɗye mɛyasi mɛte yi wunɛ ɓɛŋma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wunɛ dûkwɛ nde, mi ta njesɛ wunɛ Kimɔ Sisiŋ te yi Saŋmbɛ kpoma kɛ́ nɛ ŋguru wombɛ. Wunɛ ɗîy kɛ mɔy ɗya kumɔ kɛ ŋgimɔ te yi wunɛ ta ɓu̧ nɛ nyaŋgwɛ ɗeti te kɛ́. Yo ta wulɛ kɛ ɗyoɓɔ nje kɛ yotu yun.» ");
INSERT INTO kkj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɛ nyɛ ɓu̧ ɓo kɛ̀ nɔ pulɔ Betani. Ɛ nyɛ kaŋɛ mɛɓɔ kɛnjɛ kwey nyɛ ɓo mɛkombila. ");
INSERT INTO kkj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kɛ ŋgimɔ te yi nyɛ ɓa̧ ndi kɛ nyɛ ɓo mɛkombila ɗete kɛ́, ɛ nyɛ ɓaka nɛ ɓo. Ɛ Njambiyɛ yɔkiɗye nyɛ kɛnjɛ ɗyoɓɔ. ");
INSERT INTO kkj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kɛ ɓo ma si kanɔ nyɛ kɛ́, ɛ ɓo yɔkwɛ kɛ̀ Yerusalɛm nɛ nyaŋgwɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɓo ɗiyma mɛtu hɛnɛ kɛ mbanjɔ Njambiyɛ yí lukse Njambiyɛ.");
INSERT INTO kkj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Piŋɔ te yi Njambiyɛ tì pa kusɔ mbokɔ na, yɔkɔ yi ɓo jeɓa nde Lɛpi*f1* kɔ ɓa̧ kɛte. A ɓa̧ ɓenɛ Njambiyɛ. Lɛpi te ndi Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yɔkɔ yi ɓo jeɓa nde Lɛpi kɔ ɓa̧ ɓenɛ Njambiyɛ piŋɔ te yi Njambiyɛ tì pa kusɔ mbokɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yɔkɔ yi ɓo jeɓa nde Lɛpi kɔ kusɛ mɛyasi hɛnɛ. Kɛ mɛyasi mɛte yi ɗiyɛ kɛ́, kinɛ nyɛ na, ko ma yaŋa wɛtɛ nɛ wɛtɛ tì kusuna na. ");
INSERT INTO kkj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A ɓa̧ njuku joŋgwɛ, ɛ joŋgwɛ te ɓɛ mɛjasi mɛte yi ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma mɛjasi mɛte kɛ panɔ kɛ mɔy yitil. Yasi wɛtɛ, yitil tì jayɛ mɛjasi na. ");
INSERT INTO kkj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Njambiyɛ tomma wɛtɛ mbam njesɛ. Ɗinɔ ɗyenɛ ɓa̧ nde Jaŋ. ");
INSERT INTO kkj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A nja̧, na nje pel yasi te yi nyɛ ɓɛŋma nɛ̀ yi nyɛ duwa̧ kɛ kasi mɛjasi maka, nɛ́ ɓomɔ hɛnɛ kwa̧ nɛ nje yasi te yi nyɛ pelɛ kɛ́ yí tikɔ nɛ temɔ kɛ mɛjasi mɛte. ");
INSERT INTO kkj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ndi nde, gba nyɛ nɛ ŋguru wenɛ tì ɓɛ mɛjasi mɛte na. Yasi wɛtɛ, a njáki, na nje lɛpi yasi te yi nyɛ ɓɛŋma nɛ̀ yi nyɛ duwa̧ kɛ kasi mɛjasi mɛte. ");
INSERT INTO kkj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɛjasi mɛte ɓa̧ gbate kpasa mɛjasi mɛte yi nje kɛ to mɛnɛti paniyɛ puyɛ nyɛ mumɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yɔkɔ yi ɓo jeɓa nde Lɛpi kɔ ɓa̧ kɛ to mɛnɛti. Sendi, Njambiyɛ kwaŋma nɛ nyɛ yí kusɔ nɛ mɛnɛti. Yasi wɛtɛ, ɓotu ɓe mɛnɛti maka tì duwɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A ka̧ kɛ ɗya ɗyenɛ. Ko ɗete, ɓemaŋ tì jayɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yasi wɛtɛ, ɓomɔ hɛnɛ ɓe jayma nyɛ tikɔ temɔ nɛ nyɛ, a kelma nde, ɓo njâki nje ɓɛ ɓɔnɔ ɓe Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓotu ɓete tî njaki nje ɓɛ ɓɔnɔ ɓe Njambiyɛ nɛ nje te yi mɛmbundɔ nda yi nyari ja nɛ mɔnɔsikɛ ho nda yi mbam kwaɗyɛ ɓɛ nɛ ɓɔnɔsikɛ kɛ́ na. Yasi wɛtɛ, yo nde, yo Njambiyɛ nyɛ ɓo jɔnja joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yɔkɔ yi ɓo jeɓa nde Lɛpi kɔ nja̧ yeŋsa ɓɛ gba mumɔ nɛ mɛmbundɔ. Ɛ nyɛ ɗiyɛ kɛ njoka su. A ɓa̧ tondunate nɛ ŋgikwa nɛ̀ gbakasi. Ɛ wusɛ ɓɛŋɛ nyaŋgwɛ mɛkele mɛnɛ, nyaŋgwɛ mɛkele mɛte yi Da nya Kikɔ Mɔnɔ wenɛ ɗeti te yi kelɔ. ");
INSERT INTO kkj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jaŋ lɛpima yasi te yi nyɛ duwa̧ kɛ kasi nɛ, ɛ nyɛ kembiɗya lɛpɔ nde: «Yo nyɛ yi mi ɗikima lɛpɔ nde: ‹Yɔkɔ ɛ ta nje kɛ kɔŋ mbɛ kɔ kwa̧ mi, kɛto nyɛ kɛte kpo nɛ kpo. Yasi wɛtɛ, mi njáki nje mbɛ njimɛ.› » ");
INSERT INTO kkj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wusɛ hɛnɛ ɓoŋma kwalɔ kimɔ mɛyasi hɛnɛ te yi yo tondunate kɛ mɔy temɔ nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Njambiyɛ kwaŋma nɛ Mɔyisi yí nyɛ nɛ wusɛ mɛmboŋga mɛnɛ. Yasi wɛtɛ, yí teɗye ŋgikwa nɛ̀ gbakasi nyɛ ɓomɔ, a nja̧ kwa̧ nɛ Yesus Krist. ");
INSERT INTO kkj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛŋɛ Njambiyɛ wɛtɛ yesɔ, soŋɛ ndi Kikɔ Mɔnɔ Njambiyɛ, nyɛ ɛ ɗiyɛ ɓenɛ Saŋgwɛ nda kɔl ɓenɛ jon kɔ, yo ndi nyɛ kelma nde, ɓomɔ dûkwɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wɛtɛ yesɔ ɓaŋa ɓekum Ɓeyudɛn ɓe Yerusalɛm tomma ɓaŋa ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓaŋa ɓotu ɓe kandɔ *Levi kɛ̀ diyɛ Jaŋ nde: «Wɛ, wɛ nda?» Ɛ Jaŋ lɛpɛ yasi te yi nyɛ duwa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɛ nyɛ yeŋsa nɛ saŋsaŋ kinɛ sɔɗyɛ yaŋa na lɛpɔ nde: «Mi yeti mbɛ *Krist na.» ");
INSERT INTO kkj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɛ ɓo nje diyɛ nyɛ nde: «Wɛ ɓa nda, wɛ Eli?» Ɛ nyɛ lɛpɛ nde: «Ko na, mi yeti Eli na.» Ɛ ɓo kɛ̀ mbɔmbu diyɛ nyɛ nde: «Wɛ mɔ punja mɛlɛpi mɛ Njambiyɛ te yi ɓo ɗikima lɛpɔ nde, a ta nje kɔ?» Ɛ nyɛ yeŋsa nde: «Ɓɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɛ ɓo nje diyɛ nyɛ ndana nde: «Wɛ ɓa nda? Lɛpɔ nyɛ wusɛ, kɛto wusɛ yâkaŋgwɛ kɛ̀ lɛpɔ nyɛ ɓotu ɓete ɓe tomma wusɛ ɓaka. Ndana, wɛ nɛ ŋguru wɔ lɛ́pi nde, wɛ nda?» ");
INSERT INTO kkj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ɛ Jaŋ lɛpɛ nde: «Mi mbɛ mɔ te yɔkɔ yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima nde: ‹Wɛtɛ mumɔ kɛ kembiɗya kɛ mɔy koŋgor nde: Wunɛ tɛ̂mbiɗya nje Baba Mbokɔ nɛ ŋgbeŋ.› » ");
INSERT INTO kkj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ɓotu ɓete yi ɓo tomma ɓaka ɓa̧ kɛ njɔŋ *Ɓefarisɛ̧. ");
INSERT INTO kkj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɛ ɓo diyɛ Jaŋ nde: «Ŋgɛ ɓɛ nde, we yeti *Krist ho Eli ho mɔ punja mɛlɛpi mɛ Njambiyɛ, ma kɛto ŋge yi wɛ nje tɔpɛ ɓomɔ kɛ mɔrɔku kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ɛ Jaŋ yeŋsa nyɛ ɓo nde: «Mi tɔ́pa mbɛ ɓomɔ kɛ mɔrɔku. Yasi wɛtɛ, yo nɛ wɛtɛ mumɔ kɛ njoka yun yi wunɛ yeti kɛ duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mɔ te ta nje kɛ kɔŋ mbɛ. Yasi wɛtɛ, mi ti yaka wunjɛ kɔl mɛnakala kɛ kol nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mɛyasi mɛte kwáŋnaŋgwɛ kɛ wɛtɛ mbɛy nde Betani kɛ ŋginjɛ Yurdɛ̧, kɛ mbɛy te yi Jaŋ ɗikima tɔpɛ ɓomɔ kɛ mɔrɔku kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Misi pupɛ Jaŋ ɓɛ́ŋa Yesus kɛ nje kɛ yenɛ. Ɛ nyɛ lɛpɛ nde: «Nɛ ɓɛ̂ŋa *Mɔnɔ Sam Njambiyɛ ɛ soŋɛ mɛɓeyɔ mɛ ɓotu ɓe mɛnɛti maka kɔ! ");
INSERT INTO kkj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yo nyɛ yi mi ɗikima lɛpɔ mbɛ kasi nɛ nde: ‹Kɛ kɔŋ mbɛ, wɛtɛ mumɔ ta nje, nyɛ kwa̧ mi, kɛto nyɛ kɛte kpo nɛ kpo. Yasi wɛtɛ, mi njáki nje mbɛ njimɛ.› ");
INSERT INTO kkj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kɛ yembɛ, mi tì ɓɛ kɛ duwɛ tɛri nɛ na. Yasi wɛtɛ, mi nja̧ kɛ mɛsay mɛ tɔpuna ɓomɔ kɛ mɔrɔku, nɛ́ ɓotu ɓe kandɔ Isarayɛl duwɛ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ɛ Jaŋ kɛ̀ mbɔmbu lɛpɔ nɛ saŋsaŋ nde: «Mi ɓɛŋma Kimɔ Sisiŋ nɛ misi mɛmbɛ kɛ piyɛ wulɛ ɗyoɓɔ nda pepɔ nje ɗiyɔ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kɛ yembɛ, mi tì ɓɛ mbɛ kɛ duwɛ tɛri nɛ na. Yasi wɛtɛ, yɔkɔ ɛ tomma mi nde, mi njâki tɔpɛ ɓomɔ kɛ mɔrɔku kɔ lɛpima nyɛ mi nde: ‹Mɔ te yi wɛ ta ɓɛŋɛ Kimɔ Sisiŋ kɛ piyɛ nje ɗiyɔ kɛ yotu nɛ kɔ, yo nyɛ ta tɔpɛ ɓomɔ kɛ Kimɔ Sisiŋ.› ");
INSERT INTO kkj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mi ɓɛŋma mbɛ nyɛ nɛ gba misi mɛmbɛ, ɛ mi lɛpɛ nde: Yɔkɔ Mɔnɔ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ya tu wɛtɛ kɛ kɔŋte, ɛ Jaŋ ɓɛ ndi kɛ kiya mbɛy te yi nyɛ ɗikima kɛ̀ kɛte kɛ́ ɓenɛ ɓaŋa ɓejekɛ ɓenɛ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ndana, kɛ nyɛ ma kaŋɛ misi ɓɛŋɛ Yesus kɛ kwa̧ kɛ́, ɛ nyɛ lɛpɛ nde: «Nɛ ɓɛ̂ŋa, *Mɔnɔ Sam Njambiyɛ kɔ!» ");
INSERT INTO kkj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ɓejekɛ ɓenɛ ɓenɔri yiɓa wokuma yasi te yi nyɛ lɛpima kɛ́, ɛ ɓo tɛmɛ ɓeŋgwɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kɛ Yesus ma yeŋsa kɛ́, a ɓɛ́ŋa, ɓo kɛ ɓeŋgwɛ nyɛ. Ɛ nyɛ diyɛ ɓo nde: «Wunɛ sáŋ ŋge?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Rabi,» yite nde yekele, «wɛ ɗíy ɗiyɔ we?» ");
INSERT INTO kkj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ njâki ɓɛŋɛ.» Ɗete, ɛ ɓo kɛ̀ kɛ ɓɛŋɛ mbɛy nɛ. Ɛ ɓo kwaŋɗye ɓukwɛ yesɔ te ɓenɛ ɓe Yesus. Yo ɓa̧ kɛ pɔku ŋgimɔ yini te yi ɓekoko. ");
INSERT INTO kkj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kɛ njoka ɓejekɛ ɓaka yiɓa ɓe wokuma yasi te yi Jaŋ lɛpima, ɛ ɓo tɛmɛ ɓeŋgwɛ Yesus ɓaka, Andere te maŋ nɛ Simɔn Piyɛr ɓa̧ kɛ njokate. ");
INSERT INTO kkj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kɛ kɔŋte, ɛ Andere kwa̧ nɛdɔ kɛ dolɔ maŋ wenɛ Simɔn lɛpɔ nyɛ nyɛ nde: «Wusɛ ɓɛŋma Mɛsi,» yite nde *Krist. ");
INSERT INTO kkj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɛ nyɛ ɓu̧ Simɔn kɛ̀ nɔ kɛ yi Yesus. Ɛ Yesus kaŋɛ misi ɓɛŋɛ Simɔn lɛpɔ nde: «Ɗinɔ ɗyɔ nde Simɔn, ɗinɔ sɔŋgwɛ nde Jaŋ. Ɓo ta jeɓa wɛ nde Sefas, yo Piyɛr, yite nde tari.» ");
INSERT INTO kkj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Misi pupɛ ɛ Yesus pɛsɛ nde, a kɛ kwa̧ kɛ̀ Galile. Ɛ nyɛ saŋgwa nɛ wɛtɛ mbam nde Filip. Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Ɓeŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ɓa̧ mɔ ɗya Betsayda, ɗya ɓe Andere ɓenɛ Piyɛr. ");
INSERT INTO kkj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kɛ kɔŋte, ɛ Filip kwa̧ saŋgwa ɓenɛ Nataniyɛl. Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Wusɛ ɓɛŋma mɔ te yi Mɔyisi kɛtima yasi kɛ kasi nɛ kɛ mɛkana mɛ mɛmboŋga mɛ Njambiyɛ te yi nyɛ kɛtima kɛ́. Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima sendi kasi nɛ. Mɔ te, yo Yesus te mɔnɔ Yosɛp, ɗya ɗyenɛ kɛ Nasarɛt.» ");
INSERT INTO kkj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ɛ Nataniyɛl yeŋsa nyɛ nyɛ nde: «Kimɔ yasi te nda yakama wulɛ kɛ Nasarɛt kɔ?» Ɛ Filip nje yeŋsa nyɛ nyɛ nde: «Inja nje ɓɛŋɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus ɓɛŋma Nataniyɛl kɛ kɛ̀ kɛ yenɛ. Ɛ nyɛ lɛpɛ kɛ kasi nɛ nde: «Yɔkɔ gba mɔnɔ kandɔ Isarayɛl nɛ yotu. Ko mɔnɔ yekambiyɛ te yi seɓila mumɔ yeti kɛ yotu nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ɛ Nataniyɛl diyɛ nyɛ nde: «Wɛ dúkwɛ mi we?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Piŋɔ te yi Filip tì pa jeɓa wɛ na, kɛ ŋgimɔ te yi wɛ ɓa̧ kɛ nji̧ *figiye kɛ́, mi ɓɛŋma wɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ɛ Nataniyɛl yeŋsa nyɛ nyɛ nde: «Yekele, wɛ Mɔnɔ Njambiyɛ, wɛ Kumande Isarayɛl.» ");
INSERT INTO kkj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «’Yo kɛto mi lɛpima nyɛ wɛ nde, mi ɓɛŋma wɛ kɛ nji̧ *figiye, yori yi wɛ tikɛ nɛ temɔ ndana nɛ mi kɛ́? Ma wɛ ta ɓɛŋɛ yiŋa nyaŋgwɛ mɛkele kwa̧ yikɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nyɛ nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wunɛ ta ɓɛŋɛ ɗyoɓɔ nyasɛ, ɓɛŋɛ ɓejaki ɓe Njambiyɛ kɛ kɛ̀ kwey piyɛ yaka nɛ to *Mɔnɔ mumɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ya mɛtu yiɓa kɛ kɔŋte, ɛ yo ɓɛ nɛ yiŋa jesɔ gwaki kɛ Kana kɛ Galile. Nyaŋgwɛ nɛ Yesus ɓa̧ kɛte. ");
INSERT INTO kkj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ɓo jeɓama sendi Yesus ɓenɛ ɓejekɛ ɓenɛ kɛ jesɔ gwaki te. ");
INSERT INTO kkj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɗiyɔ kɛ́, ɛ mɛnjam siyɛ kɛ mbɛy jesɔ. Ɛ nyaŋgwɛ nɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Mɛnjam siyma.» ");
INSERT INTO kkj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Nyari, sinɛ wɛ nɛ lɛpi te nda? Ŋgimɔ te yembɛ tì pa ɗya̧ na.» ");
INSERT INTO kkj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ɛ nyaŋgwɛ lɛpɛ nyɛ ɓotu ɓe mɛsay nde: «Yasi hɛnɛ te yi nyɛ ta lɛpɔ nyɛ wunɛ, nɛ̀ wunɛ kêl yo.» ");
INSERT INTO kkj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yinɔri nyaŋgwɛ mɛmbe yitan jɔ wɛtɛ yi ɓo kelma nɛ tari kɛ́ ɓa̧ womɛte. Mɛmbe mɛte ɗikima ɓɛ nɛ mɔrɔku te yi Ɓeyudɛn ɗikima kitɔ nɛ yotu nda yi mɛmboŋga mɛ misɔn yan ɗikima teɗye kɛ. Mbe te wɛtɛ yakama ɓu̧ mɛndaki nda gɔmay wɛtɛ nɛ numbu te. ");
INSERT INTO kkj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ndana, ɛ Yesus lɛpɛ nyɛ ɓotu ɓe mɛsay nde: «Wunɛ tâya mɔrɔku tonjɛ mɛmbe mɛnɔri.» Ɛ ɓo tayɛ mɔrɔku tonjɛ mɛmbe nɛ lɛtɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Wunɛ tâya yo ndana nɛ mbɛt kɛ̀ nyɛ mɔ te ɛ ɗiyɛ nɛ kaɓina mɛɗye kɔ.» Ɛ ɓo tayɛ kɛ̀ nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɛ nyɛ ɓoɓɛ mɔrɔku mɛnɔri yi ma liŋgwɛ mɛnjam kɛ́, ma a tì duwɛ nɛ mbɛy te yi mɛnjam mɛte wulma nje nɔ kɛ́ na. Yasi wɛtɛ, ɓotu ɓe mɛsay, ɓo ɓotu ɓete ɓe tayma mɔrɔku ɓaka duwa̧ to te kimɔte. Ndana, ɛ nyɛ kwa̧ kɛ̀ jeɓa mbam te ɛ kelma gwaki kɔ lɛpɔ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Kɛ kaɓina mɛnjam hɛnɛ, ɓo kánda kaɓɔ kimɔ mɛnjam nyɛ ɓomɔ. Kɛ kɔŋte, ɓo má nje nyɛ ɓo yikɛ yi ti kumɔ nyɔŋɔ kɛ́ njimɛ, kɛ misi man mɛ kɛ linja. Ma yasi wɛtɛ, wɛ ɓakiɗya yɔ kimɔ mɛnjam yí laɗye nɛ ŋgimɔ te yɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kɛ njoka mɛyekambiyɛ hɛnɛ te yi Yesus kelma kɛ́, a kánda nɛ yɔkɔ yi nyɛ kelma ndana kɛ Kana kɛ Galile kɔ. Ɗete, a teɗya nyaŋgwɛ ɗeti nɛ, ɛ ɓejekɛ ɓenɛ tikɛ temɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kɛ kɔŋte, ɛ Yesus sɛliyɛ kɛ̀ kɛ Kapɛrnawum ɓenɛ nyaŋgwɛ nɛ̀ ɓemaŋ nɛ̀ ɓejekɛ ɓenɛ. Ɓo kwaŋɗya ndi mɔnɔ mɛtu nɛ mbɛt mate. ");
INSERT INTO kkj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kɛ ŋgimɔ te yite jesɔ *Paska Ɓeyudɛn ɓa̧ kɛ wuta. Ɛ Yesus kwa̧ kɛ̀ kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kɛ nyɛ ma ɗya̧ kɛ mbanjɔ Njambiyɛ kɛ́, a dól ɓomɔ kɛ ɗyaŋgwɛ mɛyasi, ɓe ɗyaŋgwɛ ɓenday, ɓe ɗyaŋgwɛ ɓesam nɛ̀ ɓe ɗyaŋgwɛ ɓepepɔ. A dolma sendi ɓotu ɓe sɛnjina mɔni kɛ ɗiyɔ. ");
INSERT INTO kkj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndana, ɛ nyɛ ɓu̧ mɛkɔl ɓɔyɛ kelɔ nɛ njambala ɗuɗye ɓo hɛnɛ punjɛ womɛte ɓenɛ ɓesam ɓan nɛ̀ ɓenday ɓan. Ɛ nyɛ si wanjɔ mɔni mɛ ɓotu ɓe sɛnjina mɔni tindɔ mɛteɓel ɓetɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɛ nyɛ lɛpɛ nyɛ ɓotu ɓe ɗyaŋgwa ɓepepɔ nde: «Wunɛ lɔ̂ndu nɛ mɛyasi mɛte yikɛ waka. Wunɛ tî yeŋsaŋgwɛ tu̧ Saŋmbɛ nɛ tu̧ mɛjɛŋ na.» ");
INSERT INTO kkj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ndana, ɛ ɓejekɛ ɓenɛ nje takɛ lɛpi te yi yo kɛtinate kɛ mɔy mɛkana mɛ Njambiyɛ kɛ́. Yo kɛtinate nde: ‹Mi kwaɗya tu̧ ɗyɔ nɛ temɔ mbɛ hɛnɛ. Yo ta kelɔ nde, mi sɔ̂mbu sɔŋ kɛto te.› ");
INSERT INTO kkj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kɛ ɓaŋa ɓekum Ɓeyudɛn ma ɓɛŋɛ ɗete kɛ́, ɛ ɓo diyɛ nyɛ nde: «Yo kwalɔ mɛyekambiyɛ te nda yi wɛ ta kelɔ yí teɗye nɛ wusɛ nde, ɓo nya wɛ ɗeti te yi kelɔ mɛyasi mɛte yi wɛ kelɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Wunɛ yâŋgila mbanjɔ Njambiyɛ te yikɛ, ndi kɛ mɛtu yitati mi ta si sumɔ yo nɛ kɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɛ ɓekum Ɓeyudɛn nje lɛpɔ nde: «Sumna mbanjɔ Njambiyɛ te yikɛ ɓoŋma wusɛ pɔkɛ mɛsew kamɔni jɔ yitan jɔ wɛtɛ. ’Wɛ lɛ́pi gba nde, wɛ ta nje sumɔ yo ndi kɛ mɛtu yitati nde?» ");
INSERT INTO kkj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yasi wɛtɛ, Yesus ti lɛ́pi kasi mbanjɔ Njambiyɛ na, a lɛ́pi nɛ yotu nɛ nɛ ŋguru wenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ndana, kɛ ŋgimɔ te yi Yesus ma nje womiyɛ kɛ njoka ɓemuŋ kɛ́, ɛ ɓejekɛ ɓenɛ takɛ lɛpi kɛ yi nyɛ ɗikima lɛpɔ kɛ́. Ɛ ɓo tikɛ temɔ kɛ mɛyasi mɛte yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́, tikɔ temɔ sendi kɛ lɛpi te yikɛ yi Yesus lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kɛ ŋgimɔ te yinɔri yi Yesus ɓa̧ kɛ Yerusalɛm kɛ jesɔ *Paska Ɓeyudɛn kɛ́, ɛ ɓuɗya ɓomɔ tikɛ temɔ nɛ nyɛ, kɛto ɓo ɓɛŋma mɛyekambiyɛ mɛte yi nyɛ ɗikima kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yasi wɛtɛ, Yesus tì tikɛ temɔ kɛ yan na, kɛto a ɓa̧ kɛ duwɛ ɓo hɛnɛ kandɛ nyiŋɔ to kumɔ nyɛy kol. ");
INSERT INTO kkj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kɛ yenɛ, yo tì ɓɛ nde, wɛtɛ mumɔ pâŋ pa lɛpɔ yiŋa yaŋa te yi mɔ te duwa̧ kɛ kasi wɛtɛ mumɔ nyɛ nyɛ na. Kɛto nyɛ nɛ ŋguru wenɛ duwa̧ yasi te yi ɗiyɛ kɛ mɔy temɔ mumɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wɛtɛ mbam ɓa̧ kɛ njɔŋ *Ɓefarisɛ̧ nde Nikɔdɛm. A ɓa̧ sendi wɛtɛ kum kɛ njoka Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɛ nyɛ kɛ̀ wɛtɛ yesɔ nɛ tu kɛ yi Yesus lɛpɔ nyɛ nyɛ nde: «Yekele, wusɛ duwa̧ nde, wɛ nyaŋgwɛ mɔ teɗya mɛmboŋga mɛ Njambiyɛ. Njambiyɛ tomma wɛ njesɛ, kɛto mumɔ wɛtɛ nɛ wɛtɛ ti yaka kelɔ kwalɔ mɛyekambiyɛ mɛte yi wɛ kelɛ kɛ́, ŋgɛ Njambiyɛ ti ɓɛ kɛ yenɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Ŋgɛ mumɔ ti jaɗyɛ nɛ kɔkɔ na, a ti yaka ɓɛŋɛ *Kandɔ Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ɛ Nikɔdɛm nje diyɛ nyɛ nde: «Ŋgɛ mumɔ si jombɛ, a yakama kelɔ nan yí jaɗyɛ nɔ nɛ kɔkɔ? ’A yakama yɔkwɛ sendi nyiŋɛ mɔy nyaŋgwɛ nje jaɗyɛ nɛ kɔkɔ?» ");
INSERT INTO kkj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ɛ Yesus yeŋsa nyɛ nde: «Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Ŋgɛ mumɔ ti jaɗyɛ nɛ kɔkɔ nɛ nje te yi mɔrɔku, jaɗyɛ sendi nɛ nje te yi Kimɔ Sisiŋ na, a ti yaka nyiŋɛ kɛ Kandɔ Njambiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yasi te yi wulɛ kɛ yi mumɔ nɛ nje te yi mɛmbundɔ ɓɛ́ŋnaŋgwɛ ɓɔnɛ ndi nde, yo wúla kɛ yi mɔ mɛmbundɔ. Yasi wɛtɛ, yasi te yi wulɛ kɛ yi Kimɔ Sisiŋ ɓɛ́ŋnaŋgwɛ ɓɔnɛ, ndi nde, yo wúla kɛ yi Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wɛ tî ŋgbakimaŋgwɛ lɛpi te yi mi lɛpima nyɛ wɛ nde: ‹Wunɛ yâkaŋgwɛ jaɗyɛ nɛ kɔkɔ kɛ́› na. ");
INSERT INTO kkj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pupɔ kwáŋ kɛ mbɛy hɛnɛ te yi nyɛ kwaɗyɛ kwa̧ kɛte kɛ́. Wɛ kɛ wokɔ nda yi yo muŋgula nɔ kɛ̀. Ma yasi wɛtɛ, wɛ yeti kɛ duwɛ mbɛy te yi yo wulma kɛte nɛ̀ mbɛy te yi yo kɛ̀ kɛte kɛ́ na. Yo kwáŋnaŋgwɛ ndi sendi ɗete kɛ yi mumɔ hɛnɛ ɛ jaɗyɛ nɛ nje te yi Kimɔ Sisiŋ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ɛ Nikɔdɛm nje ɗiyɔ diyɛ nyɛ nde: «Yo yakama kwaŋna nan?» ");
INSERT INTO kkj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Gba wɛ nyaŋgwɛ mɔ teɗya mɛmboŋga mɛ Njambiyɛ kɛ kandɔ Isarayɛl, ’wɛ kɛ ndekima mɛyasi mɛnɔri? ");
INSERT INTO kkj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Wusɛ lɛ́pi yasi te yi wusɛ duwa̧, yekiɗye yasi te yi wusɛ ɓɛŋma. Ko ɗete, ko wunɛ yeti kɛ jayɛ tikɔ temɔ kɛ mɛlɛpi mɛte yi wusɛ nje lɛpɔ kɛ mɛyasi mɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi lɛpinama kɛ mɛyasi mɛte yi kwaŋna kɛ to mɛnɛti waka kɛ nyɛ wunɛ, ma wunɛ tì jayɛ tikɔ temɔ kɛte na. Ndana, ŋgɛ ɓɛ nde, mi lɛ̂pinaŋgwɛ kɛ mɛyasi mɛte yi ɓɛŋɛ kasi ɗyoɓɔ kɛ́ nyɛ wunɛ, ŋge ta nje kelɔ nde, wunɛ jâya tikɔ temɔ kɛ mɛlɛpi mɛte? ");
INSERT INTO kkj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ɛ ɓendima kɛ ɗyoɓɔ na, soŋɛ ndi yɔkɔ ɛ piya wulɛ ɗyoɓɔ kɔ. Mɔ te, yo *Mɔnɔ mumɔ ɛ ɗiyɛ kɛ ɗyoɓɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kɛ ŋgimɔ te yi Mɔyisi ɓa̧ nɔ kɛ koŋgor kɛ́, ɛ nyɛ ɓu̧ yekambiyɛ nyɔŋɛ nyɛ kɛ jeti tɛmbiɗye kɛ kwey. Yo ndi ɗete sendi yi ɓo yâkaŋgwɛ kelɔ nɛ Mɔnɔ mumɔ tɛmbiɗye kɛ kwey. ");
INSERT INTO kkj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yo yâkaŋgwɛ kelna ɗete, nɛ́ mumɔ hɛnɛ ɛ tikɛ temɔ nɛ nyɛ kɔ ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yo nde, Njambiyɛ jekima kwaɗyɛ ɓotu ɓe mɛnɛti maka, ɛ nyɛ nyɛ nɛ Kikɔ Mɔnɔ wenɛ. Ɗete, mumɔ hɛnɛ ɛ ta tikɔ temɔ nɛ nyɛ, a tí gwe yambile na. Yasi wɛtɛ, a ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kɛto, Njambiyɛ ti ma njésikwɛ Mɔnɔ wenɛ kɛ mɛnɛti maka, na nje jɔse ɓomɔ na. Yasi wɛtɛ, a tomma nyɛ njesɛ nde, na kwa̧ nɛ nje nɛ joŋgwɛ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mɔ te ɛ tikɛ temɔ nɛ nyɛ, Njambiyɛ yeti kɛ jɔse nyɛ na. Ma yasi wɛtɛ, yɔkɔ ɛ ɗiyɛ kinɛ tikɔ temɔ nɛ nyɛ, Njambiyɛ ma jɔse nyɛ, kɛto a tì tikɛ temɔ kɛ yi Kikɔ Mɔnɔ Njambiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","To jɔsi te yo nde, mɛjasi nja̧ kɛ to mɛnɛti. Ɛ ɓomɔ yɔkwɛ kwaɗyɛ yitil sɛŋɛ mɛjasi, kɛto ɓo kwáɗyikwɛ kelɔ ndi ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yo nde, mumɔ hɛnɛ ɛ kelɛ ndi ɓeya mɛkele kɛ ɓenɔ mɛjasi. A ti njáki kɛ puyɛ na, kambɔ mɛkele mɛnɛ nje pundɔ puyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yasi wɛtɛ, mumɔ hɛnɛ ɛ wokuna nɛ Njambiyɛ kelɔ mɛyasi nɛ ŋgbeŋ, mɔ te njáki kɛ puyɛ, nɛ́ ɓomɔ ɓɛŋ gbate nde, a kél mɛyasi nda yi Njambiyɛ kwaɗyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ndana, kɛ kɔŋ mɛyasi mɛnɔri, ɛ Yesus tɛmɛ kwa̧ ɓenɛ ɓejekɛ ɓenɛ kɛ̀ kɛ mɛnɛti mɛ Yuda. Ɛ nyɛ kwaŋɗye ɓuɗya mɛtu mate ɓenɛ ɓo ɗiki tɔpɛ ɓomɔ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kɛ ŋgimɔ te yite Jaŋ ɓa̧ sendi kɛ ɗiki tɔpɛ ɓomɔ kɛ mɔrɔku kɛ wɛtɛ mbɛy nde Enɔŋ kɛ kɛki Salim. Jaŋ ɗikima kɛ̀ mate, kɛto mɔrɔku ɓa̧ ɓuɗyate mate. Ɗete, ɓomɔ ɗikima kɛ̀, ɛ nyɛ ɗiki tɔpɛ ɓo kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yo kwaŋnama ɗete, kɛto kɛ ŋgimɔ te yite ɓo tì pa nyɛ Jaŋ kɛ jɔɓɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ndana, ɛ wɛtɛ mɔ Ɓeyudɛn ɓɛ nɛ mɛtandɔ ɓenɛ ɓaŋa ɓejekɛ ɓe Jaŋ kɛ kasi mɛweya mɛsɛmbɔ te yi mɛmboŋga man teɗye kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɛ ɓo tɛmɛ kɛ̀ dolɔ Jaŋ lɛpɔ nyɛ nyɛ nde: «Yekele ɓɛŋa, mɔ te yi wúnɛ nyɛ ɓa̧ kɛ ŋginjɛ Yurdɛ̧ yi wɛ ɗikima lɛpɔ kasi nɛ nyɛ ɓomɔ kɔ mɛ nɛ kɛ tɔpɛ ɓomɔ ndana kɛ mɔrɔku. Ma ɓomɔ hɛnɛ kɛ si lekwɛ kɛ̀ pɛ yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ɛ Jaŋ yeŋsa nde: «Ŋgɛ Njambiyɛ ti nyɛ mumɔ ɗeti na, a ti yaka kelɔ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wunɛ nɛ ŋguru wun yakama lɛpɔ yasi te yi mi lɛpima kɛ́. Wunɛ wokuma nda yi mi lɛpima nde: Mi yeti mbɛ *Krist na. Yasi wɛtɛ, Njambiyɛ kandima tomɔ mi nde, mi kwâŋ mbɔmbu nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ɛ Jaŋ kɛ̀ sendi mbɔmbu lɛpɔ nde: «Nya gwaki wókunaŋgwɛ nɛ mbam gwaki. Ma sɔ nɛ mbam gwaki ɗíy nɛ ɗiyɔ kɛ kɛki sɔ wenɛ yí lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ lɛpɛ kɛ́. A nɛ mɛsosa ɓuɗyate komɛ nyɛ wokɛ mɛn mbam gwaki kɛ́. Njena nyaŋgwɛ mɛsosa yi mi nɔ ndana kɛ́, yo kwalɔ mɛsosa te yite.» ");
INSERT INTO kkj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɛ Jaŋ kɛ̀ mbɔmbu lɛpɔ nde: «Mɛkele mɛnɛ ɗɔ̂ku ɗɔkɔ kɛ̀ nɔ mbɔmbu, nɛ̀ yembɛ yɔ̂kwɛ sinɛ sina.» ");
INSERT INTO kkj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Yɔkɔ ɛ wulɛ kwey nje nɔ kɔ kwa̧ ɓomɔ hɛnɛ. Mɔ mɛnɛti maka ndi mɔ mɛnɛti, a lɛ́pi ndi sendi yasi te yi ɓɛŋɛ mɛnɛti. Yɔkɔ ɛ wulɛ ɗyoɓɔ nje nɔ kɔ kwa̧ ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mɛyasi mɛte yi nyɛ ɓɛŋma nɛ̀ yi nyɛ wokuma, yo yite yi nyɛ lɛpɛ nyɛ ɓomɔ. Ma ko mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ jayɛ tikɔ temɔ kɛ mɛlɛpi mɛte yi nyɛ lɛpɛ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mumɔ hɛnɛ ɛ ma jayɛ tikɔ temɔ kɛ mɛlɛpi mɛte yi nyɛ lɛpɛ kɛ́ ma pɛsɔ gbate nde, Njambiyɛ nyɛ yɔkɔ ɛ lɛpɛ gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yo nde, yɔkɔ yi Njambiyɛ tomma kɔ lɛ́pi ndi mɛlɛpi mɛ Njambiyɛ, kɛto Njambiyɛ tonja Sisiŋ nɛ kɛ yotu nɛ ndi tu wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Saŋgwɛ kɛ kwaɗyɛ Mɔnɔ, ɛ nyɛ nyɛ nyɛ ɗeti te yi namɔ mɛyasi hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mɔ te ɛ tikɛ temɔ nɛ Mɔnɔ, mɔ te nɛ joŋgwɛ te yi kpo nɛ kpo. Ma yɔkɔ ɛ kelɛ mbandɔ kinɛ tikɔ temɔ nɛ Mɔnɔ, mɔ te tí ɓɛ nɛ joŋgwɛ te na. Yasi wɛtɛ, ŋgambi Njambiyɛ ta ɗiyɔ ndi kɛ to nɛ, ɓɔnɛ kɛte.» ");
INSERT INTO kkj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesus duwa̧ nde, *Ɓefarisɛ̧ wokuma nde, a ma ɓu̧ ɓomɔ ɓuɗyate kɛnjɛ kɛ kɔŋ nɛ kwa̧ Jaŋ, wokɔ sendi nde, a kɛ tɔpɛ ɓomɔ ɓuɗyate kɛ mɔrɔku kwa̧ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kɛ yinɔri hɛnɛ, ko Yesus tì tɔpɛ mumɔ nɛ ɓɔ nɛ kɛ mɔrɔku na, yo ɓa̧ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ndana, kɛ Yesus ma duwɛ ɗete kɛ́, ɛ nyɛ ɗuwɛ kɛ Yuda yɔkwɛ nɛ kɔkɔ kɛ̀ Galile. ");
INSERT INTO kkj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yi yɔkwɛ kɛ̀ nɔ Galile, ɛ nyɛ pɛsɛ nde, a yâkaŋgwɛ kwa̧ nɛ Samari. ");
INSERT INTO kkj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ndana, ɛ nyɛ kwa̧ kumɔ kɛ kɛki wɛtɛ ɗya nde Sikar kɛ Samari. Ɗya te ɓa̧ kɛ kɛki pɛl mɛnɛti mɛte yi Yakɔp ma nyɛ́ki mɔnɔ wenɛ Yosɛp nɛ likɔ kɛ mɛtu mɛ mbɔmbu kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ŋgɛ̧ Yakɔp ɓa̧ womɛte. Nda yotu Yesus ɓa̧ katinate nɛ kɛndi kɛ́, ɛ nyɛ kwa̧ ɗiyɔ mɛtiɗyɛ kɛ kɛki ŋgɛ̧. Yo ɓa̧ kɛ pɔku ɓembe yesɔ. ");
INSERT INTO kkj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yaka nɔ, wɛtɛ nya Samari kɛ nje tayɛ mɔrɔku. Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Nyɛkɔ mi mɔrɔku, nɛ́ mi hɔɓiye.» ");
INSERT INTO kkj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yinɔri ɓejekɛ ɓenɛ ma kɛ̀ kɛ mɔy ɗya kɛ̀ ɓɔmɔ mɛɗye. ");
INSERT INTO kkj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɛ nya Samari kɔ nje ɗiyɔ lɛpɔ nyɛ nyɛ nde: «’Gba wɛ mɔ Ɓeyudɛn njáki diyɛ mi ŋgɔndu Samari mɔrɔku nɛ nje te yin?» Nya kɔ lɛ́pi ɗete, kɛto Ɓeyudɛn ɓenɛ ɓotu ɓe Samari ɓa̧ nda nja mbo ɓenɛ ɗitɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Wɛ má dukwɛ yasi te yi Njambiyɛ nyɛ kɛ́, duwɛ sendi mɔ te ɛ lɛpɛ nyɛ wɛ nde: ‹Nyɛkɔ mi mɔrɔku, nɛ́ mi hɔɓiye kɔ,› ma yo gba wɛ jɔmbɛ mɔrɔku kɛ ɓɔ nɛ. Ma nyɛ nya wɛ mɔrɔku mɛte yi kelɛ nde, mumɔ ɓɛ̂ki nɛ joŋgwɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɛ nyari lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ mbam, mapi te yi wɛ ta tayɛ nɛ mɔrɔku yeti. Sendi, mbɛy tayna mɔrɔku nɛ heɓeɓe. Ma wɛ ta nje ɓu̧ ɓa mɔrɔku mɛte yi kelɛ nde, ɓomɔ ɓɛ̂ki nɛ joŋgwɛ kɛ́ we? ");
INSERT INTO kkj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Saŋmbambɔ wusu Yakɔp tikima wusɛ nɛ ŋgɛ̧ kɛ. Nyɛ nɛ ŋguru wenɛ nɛ̀ ɓɔnɔ ɓenɛ nɛ̀ ɓetitɛr ɓenɛ hɔɓiya ndi mɔrɔku mɛ ŋgɛ̧ kɔ. Ma ndana, ’wɛ táka gba nde, wɛ kwa̧ nyɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Mumɔ hɛnɛ ɛ hɔɓiye mɔrɔku mɛte yikɛ ta kɛ̀ mbɔmbu gwe yɛsiɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yasi wɛtɛ, mɔ te ɛ ta hɔɓiye mɔrɔku mɛte yi mi ta nyɛ nyɛ kɛ́ tí gwe se yɛsiɗyɛ wɛtɛ yesɔ na. Yo nde, mɔrɔku mɛte yi mi ta nyɛ nyɛ kɛ́ ta nje ɓɛ kɛ yotu nɛ nda ŋgɛ̧ te yi sokula kɛ́, kelɔ nde, a ɓɛ̂ki nɛ joŋgwɛ te yi kpo nɛ kpo.» ");
INSERT INTO kkj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɛ nyari yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ mbam, nyɛkɔ mi mɔrɔku mɛte yite, ma mi nje kɛ̀ mbɔmbu gwe yesiɗyɛ yí kala nje sendi waka nje tayɛ mɔrɔku.» ");
INSERT INTO kkj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Kɛn jeɓa njoŋɔ, nɔ̀ yɔ̂kwɛ nje sendi waka.» ");
INSERT INTO kkj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɛ nyari yeŋsa nde: «Mi yeti nɛ mbam na.» ");
INSERT INTO kkj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Yi wɛ lɛpɛ kɛ́, gbakasi. Wɛ yeti nɛ mbam gbate na, kɛto kɛ joŋgwɛ ɗyɔ, wɛ ma ɓɛ nɛ ɓembam kumɔ yitan. Mbam te yi wúnɛ nyɛ joŋna ndana kɔ, yeti njoŋɔ na. Yasi te yi wɛ lɛpima kɛ́, yo gbakasi.» ");
INSERT INTO kkj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ndana, ɛ nyari yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ mbam, mi kɛ ɓɛŋɛ nde, wɛ wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɓesaŋmbambɔ ɓusu ɗikima kanɔ Njambiyɛ kɛ gba keki te yɔkɔ. Yasi wɛtɛ, wunɛ Ɓeyudɛn kpál lɛpɔ yun nde, mumɔ hɛnɛ yâkaŋgwɛ kanɔ Njambiyɛ ndi kɛ Yerusalɛm.» ");
INSERT INTO kkj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Nyari, jaya yasi te yi mi lɛpɛ nyɛ wɛ kɛ́ kimɔte. Ŋgimɔ kɛ nje yi wunɛ tí kanɔ se Saŋgwɛ Njambiyɛ ko kɛ keki te yɔkɔ ko kɛ Yerusalɛm na. ");
INSERT INTO kkj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wunɛ ɓotu ɓe Samari yeti kɛ duwɛ yasi te yi wunɛ kanɛ kɛ́ na. Ma wusɛ kán su yasi te yi wusɛ kɛ duwɛ. Kɛto nje joŋgwɛ wúla kɛ yi Ɓeyudɛn nje nɔ. ");
INSERT INTO kkj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yasi wɛtɛ, ŋgimɔ kɛ nje, yo ma si ɗya̧, ŋgimɔ te yi gba kpasa ɓotu ɓete ɓe kanɛ Saŋgwɛ Njambiyɛ ta kanɔ nyɛ nɛ nje te yi sisiŋ nɛ̀ gbakasi. Kɛto saŋgwɛ Njambiyɛ sáŋ kwalɔ ɓotu ɓete ɓe kanɛ nyɛ nɛ nje te yite. ");
INSERT INTO kkj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Njambiyɛ, nyɛ Sisiŋ. Ɗete, ɓomɔ ɓe kanɛ nyɛ, ɓo yâkaŋgwɛ kanɔ nyɛ nɛ nje te yi sisiŋ nɛ̀ gbakasi.» ");
INSERT INTO kkj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɛ nyari yeŋsa nyɛ nyɛ nde: «Mi duwa̧ nde, Mɛsi, yite nde *Krist ta nje. Komɛ nyɛ ta nje kɛ́, a ta nɛmbɛ to mɛyasi hɛnɛ nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Gba mi kɔ, mɔ te yi wɛ lɛpɛ kasi nɛ kɔ, gba mi ɛ lɛpina nyɛ wɛ kɔ!» ");
INSERT INTO kkj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yaka nɔ, ɓejekɛ ɓenɛ kɛ yɔkwɛ. Ɛ ɓo ŋgbakima yi ɓɛŋɛ nde, Yesus kɛ lɛpina ɓenɛ nyari. Ko ɗete, mumɔ wɛtɛ nɛ wɛtɛ tì ɓutɛ numbu lɛpɔ nde: ‹Wɛ díya ɓa nyɛ ŋge?› ho nde: ‹Yo lɛpi te nda yi wúnɛ nyɛ lɛpɛ kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ndana, ɛ nyari tikɛ mapi tayna mɔrɔku womɛte kwa̧ kɛ̀ kɛ mɔy ɗya lɛpɔ nyɛ ɓomɔ nde: ");
INSERT INTO kkj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Wunɛ njâki ɓɛŋɛ ndi wɛtɛ mbam. A lɛpima mɛyasi hɛnɛ te yi mi kelma kɛ joŋgwɛ ɗyembɛ kɛ́ nyɛ mi. ’Mbam te yeti *Krist na?» ");
INSERT INTO kkj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndana, ɛ ɓo pundɛ ɗuwɛ kɛ mɔy ɗya kɛ̀ komɛ Yesus ɓa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kɛ ŋgimɔ te yite ɓejekɛ ɓa̧ kɛ ŋgwɛta nɛ Yesus lɛpɔ nde: «Yekele, pa ɗyena wa.» ");
INSERT INTO kkj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yasi wɛtɛ, ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mi nɛ mɛɗye te yi ɗye, ma wunɛ yeti kɛ duwɛ mɛɗye mɛte na.» ");
INSERT INTO kkj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɛ ɓejekɛ lɛpɛ tandɛ yan nde: «’Yite nde, wɛtɛ mumɔ ma njesɛ nyɛ yiŋa mɛɗye?» ");
INSERT INTO kkj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Mɛɗye mɛmbɛ, yo nde, mi kêl yasi te yi Mɔ te ɛ tomma mi kɔ kwaɗyɛ, tonjɛ sendi mɛsay mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","’Wunɛ ti lɛ́pi lɛpɔ nde: ‹Ɓukwa̧ ndi ŋgwɛndɛ yini, nɛ́ ɓo kandi soŋna nyambi kɛ ŋgwaŋ na?› Nɛ lɛ̂ŋgwɛ mɛtɔ, mi kɛ lɛpɔ nyɛ wunɛ nde: Wunɛ kâŋa misi ɓɛŋɛ nɛ mɛŋgwaŋ. Nyambi ma ɗetɔ, ŋgimɔ soŋnate ma yaka. ");
INSERT INTO kkj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mɔ te ɛ soŋɛ nyambi kɔ kɛ dolɔ nduku mɛsay mɛnɛ kɛ ɓɔ masa mɛsay. A sóŋa nyambi te yi ma ɗetɔ kɛ́, nɛ́ yo ɗiy kpo nɛ kpo. Ɗete, nɛ́ mɔ te ɛ ɓɛ ɓɛkɔ kɔ ɓɛ nɛ kiya mɛsosa ɓenɛ yɔkɔ ɛ soŋɛ soŋa kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lɛpi te yi ɓo lɛpɛ nda kanɔ nde: ‹Mɔ te ɛ ɓɛ ɓɛkɔ kɔ dɛlɛ, ma yɔkɔ ɛ soŋɛ soŋa kɔ dɛlɛ› kɛ́, lɛpi te gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kɛ ɓɛ mi, mi tomma wunɛ kɛ̀ soŋɛ nyambi kinɛ pa ɓɛŋɛ bɔnɛ nɛ̀ mɛsay nɛ mbɔmbu na. Ɓaŋa ɓɛŋma bɔnɛ nɛ mɛsay, ɛ wunɛ nje kɛ̀ yun mbɔmbu nɛ mɛsay man.» ");
INSERT INTO kkj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kɛ njoka ɓotu ɓe Samari, ɓuɗyate tikima temɔ kɛ yi Yesus, kɛto lɛpi te yi nyari lɛpima kɛ́. A lɛpima nyɛ ɓo nde: ‹Mbam te lɛpima mɛyasi hɛnɛ te yi mi kelma kɛ joŋgwɛ ɗyembɛ kɛ́ nyɛ mi.› ");
INSERT INTO kkj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kɛ ɓotu ɓe Samari ma kɛ̀ dolɔ Yesus kɛ́, ɛ ɓo ŋgwɛta nɛ nyɛ nde, a kwâŋɗya mɔnɔ mɛtu ɓenɛ ɓo kɛ ɗya ɗyan. Ɛ nyɛ kwaŋɗye mɛtu yiɓa ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɛ ɓaŋa ɓuɗya ɓotu ɓe Samari nje tikɔ sendi temɔ kɛ yenɛ, kɛto lɛpi te yi nyɛ lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɛ ɓo lɛpɛ nyɛ nyari nde: «Wusɛ ti tíki temɔ ndana kɛ yenɛ, kɛto yasi te yi wɛ yekiɗya nyɛ wusɛ kɛ́ na, yo kɛto wusɛ wokuma yasi te yi nyɛ lɛpima kɛ́ nɛ mɛtɔ musu, duwɛ sendi nde, yo gba nyɛ Mɔ te ɛ joŋgwɛ ɓotu ɓe mɛnɛti maka.» ");
INSERT INTO kkj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kɛ kɔŋ mɛtu mɛnɔri yiɓa, ɛ Yesus tɛmɛ kwa̧ kɛ̀ kɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A kwáŋ kɛ̀ mate, kɛto nyɛ nɛ ŋguru wenɛ ɗikima lɛpɔ nde, ɓo ti jáya mɔ punja mɛlɛpi kɛ ŋgbak ŋgbak ɗya ɗyenɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ndana, kɛ nyɛ ma ɗya̧ kɛ Galile kɛ́, ɛ ɓotu ɓe Galile ɓu̧ nyɛ kimɔte, kɛto ɓo ɓɛŋma mɛyasi hɛnɛ te yi nyɛ kelma kɛ Yerusalɛm kɛ ŋgimɔ jesɔ *Paska Ɓeyudɛn kɛ́, kɛto ɓo sendi ka̧ kɛ jesɔ. ");
INSERT INTO kkj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ɛ Yesus tɛmɛ yɔkwɛ nɛ kɔkɔ kɛ̀ Kana kɛ Galile kɛ mbɛy te yi nyɛ ma yéŋsaŋgwɛ mɔrɔku nɛ mɛnjam kɛ́. Wɛtɛ nyaŋgwɛ sɔja kumande ɗya ɓa̧ kɛ Kapɛrnawum. Mɔnɔ wenɛ, mɔnɔ mbam ɓa̧ kɛ kɔnɔ. ");
INSERT INTO kkj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kɛ nyaŋgwɛ sɔja kɔ ma wokɔ nde, Yesus wulma Yuda ɗya̧ kɛ Galile kɛ́, ɛ nyɛ tɛmɛ kɛ̀ ɓɛŋɛ nyɛ ŋgwɛta nɛ nyɛ nde, a kɛ̂n kɛ̀ joŋgwɛ mɔnɔ wenɛ, kɛto a ɓa̧ nɛdɔ nɛ sɔŋ. ");
INSERT INTO kkj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Kɛ yun, kɛ wunɛ tì pa ɓɛŋɛ mɛyekambiyɛ nɛ̀ nyaŋgwɛ mɛkele na, wunɛ tí tikɔ temɔ nɛ mi na.» ");
INSERT INTO kkj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɛ nyaŋgwɛ sɔja kɔ yeŋsa nde: «Nyaŋgwɛ mbam, pa kumɔ nɛdɔ kɛ tu̧ mbɛ kɛ ŋgimɔ te yi mɔnmbɛ ndi kɛ sosɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Kwaŋgɔ, mɔnɔ wɔ ma ju̧.» Mbam kɔ tikima temɔ kɛ lɛpi te yi Yesus lɛpima nyɛ nyɛ kɛ́. Ɛ nyɛ tɔkɛ nje kwa̧. ");
INSERT INTO kkj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndana, kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ nje kɛ ɗuwɛ kɛ́, ɛ ɓotu ɓe mɛsay ɓenɛ nje saŋgwa nɛ nyɛ lɛpɔ nyɛ nyɛ nde, mɔnɔ wenɛ ma ju̧. ");
INSERT INTO kkj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɛ nyɛ nje diyɛ ɓo hawa te yi mɔnɔsikɛ kandima wokuna jɛwna yotu kɛte kɛ́. Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Lolna yotu síy kwey nɛ yesɔ kɛ hawa wɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɛ saŋgwɛ nɛ mɔnɔ duwɛ nde, yo kɛ kiya ŋgimɔ te yite yi Yesus lɛpima nyɛ nyɛ nde: ‹Mɔnɔ wɔ ma ju̧› kɛ́. Ɛ nyɛ tikɛ temɔ kɛ yi Yesus, nyɛ nɛ ŋguru wenɛ nɛ̀ ɓotu ɓe tu̧ ɗyenɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mɛyekambiyɛ yiɓate yi Yesus kelma kɛ Galile kɛ́, yo yɔkɔ yi nyɛ kelma ndana kɛ yɔkwa̧ Yuda kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kɛ kɔŋte, ɛ yo ɓɛ nɛ wɛtɛ jesɔ Ɓeyudɛn. Ɛ Yesus kwa̧ kɛ̀ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yiŋa mbɛy mɔrɔku nda nyaŋgwɛ matɔ ɓa̧ kɛ Yerusalɛm kɛ kɛki numɛy te yi ɓesam ɗikima kwa̧ kɛte nyiŋɛ nɔ kɛ mɔy ɗya kɛ́. Ɓo ɗikima jeɓa nyaŋgwɛ matɔ te kɛ numbu Hebere nde Betɛsda. Yo ɓa̧ nɛ mɛmbɛy womɛte yitan yi ɓomɔ ɗikima kɛndɔ ho wɛɗya kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɓuɗya ɓotu ɓekɔn ɓa̧ mɛtinɛŋgwɛ kɛ mɛmbɛy mɛnɔri. Yo ɓa̧ nɛ ɓotu ɓe ɗiɓina misi nɛ̀ ɓotu ɓe ndɛmbil nɛ̀ ɓotu ɓete ɓe mɛɓɔ ho ɓe mɛkol man ma jɛmɛ ɓɛ nɛ fɛŋgɛlɛŋ ɓaka. Ɓo ɗikima ɗiyɔ womɛte yí laɗye ŋgimɔ te yi mɔrɔku kandɛ nɛ watinate kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kɛto wɛtɛ jaki Njambiyɛ ɗikima piyɛ yaka nɛ mɛŋgimɔ kɛ nyaŋgwɛ matɔ yinɔri nje wasɛ mɔrɔku. Ɗete, bosa mumɔ te ɛ piyɛ ɗuku kɛ ŋgimɔ te yi yo nduŋgwɛ watinate kɛ́, kɔn mɔ te siyma, ko yo ɓɛ̂ki kwalɔ kɔn te nda. ");
INSERT INTO kkj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wɛtɛ mɔ jɛmti ɓa̧ kɛ njokate womɛte mɛ kɛ mɛsew kamɔtati jɔ yitan jɔ yitati yi nyɛ ɓalma nɛ kɔn te kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus ɓɛŋma nyɛ kɛ mɛtinɛŋgwɛ, duwɛ sendi nde, mbam kɔ ma kwaŋɗye ɓuɗya mɛsew kɛ tɛri te yinɔri. Ɛ nyɛ nje diyɛ nyɛ nde: «Wɛ kɛ kwaɗyɛ nde, kɔn yɔ sîy?» ");
INSERT INTO kkj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɛ mɔ jɛmti yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ mbam, mi kinɛ mɔ te ɛ ta ɓu̧ mi piɗyɛ kɛ nyaŋgwɛ matɔ kɛ ŋgimɔ te yi mɔrɔku watɛ kɛ́ na. Kɛ ŋgimɔ te yi mi ndi kɛ kɛ̀ kɛ́, wɛtɛ mumɔ ma kandɛ piyɛ nɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Tɛma, ɓoŋgɔ taŋ yɔ, kɛndɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ndana ndana, ɛ kɔn siyɛ, ɛ nyɛ ɓu̧ taŋ nɛ kandɛ kɛndi. Yo ɓa̧ yesɔ *Saba. ");
INSERT INTO kkj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɛ Ɓeyudɛn lɛpɛ nyɛ mbam te yi Yesus siɗya kɔn nɛ kɔ nde: «Muka, yo yesɔ Saba. Mɛmboŋga mɛ Njambiyɛ yeti kɛ nyɛ wɛ ɗeti te yi ɓu̧ taŋ yɔ kwa̧ nɔ na.» ");
INSERT INTO kkj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mɔ te ɛ siɗya kɔn mbɛ kɔ lɛpima nyɛ mi nde: ‹Ɓoŋgɔ taŋ yɔ, kɛndɔ.› » ");
INSERT INTO kkj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɛ ɓo nje diyɛ nyɛ nde: «Yo mɔ te nda lɛpɛ nyɛ wɛ nde: ‹Ɓoŋgɔ taŋ yɔ, kɛndɔ›?» ");
INSERT INTO kkj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yasi wɛtɛ, mbam kɔ tì duwɛ mɔ te ɛ siɗya kɔn nɛ kɔ na, yo nde, Yesus kwaŋma jisɛ womɛte, kɛto ŋgil ɓa̧ womɛte. ");
INSERT INTO kkj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɗiyɔ kɛ́, ɛ ɓenɛ Yesus kɛ̀ saŋgwa kɛ mbanjɔ Njambiyɛ. Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa, kɔn yɔ siyma. Ma wɛ tî ɓasiɗya kelɔ se ɓeya yasi na, wɛ mɛ nje saŋgwa nɛ mɛbɔnɛ kwa̧ yikɛ yi wɛ saŋgwama nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndana, ɛ mbam kwa̧ kɛ̀ lɛpɔ nyɛ ɓekum Ɓeyudɛn nde, yo Yesus siɗyɛ kɔn nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɗete, ɛ ɓo kandɛ saŋna Yesus nɛ mɛlɛpi, kɛto a kelma mɛkele mɛte kɛ yesɔ *Saba. ");
INSERT INTO kkj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yasi wɛtɛ, ɛ Yesus yeŋsa nyɛ ɓo nde: «Saŋmbɛ ndi kɛ kelɔ mɛsay kumɔ kɛ ŋgimɔ te yɔkɔ ndana. Mi sendi kɛ kelɔ mɛsay.» ");
INSERT INTO kkj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kɛ ɓekum Ɓeyudɛn ma wokɔ ɗete kɛ́, ɛ ɓo kɛ mbɔmbu yí sa̧ mɛnje hɛnɛ te yi wo nyɛ wokɔ. Ɓo saŋma mɛnje mɛte ndana kwa̧ yi mbɔmbu, yeti ndi kɛto a tì jɛsɛ yesɔ Saba na, yo kɛto a lɛpima sendi nde, Njambiyɛ gba saŋgwɛ wenɛ, ɓenɛ nyɛ ndi wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ *Mɔnɔ tì pa ɓɛŋɛ yasi nɛ Da na, a ti yaka kelɔ yasi nda yi nyɛ kwaɗyɛ kɛ́ na. Kɛto yasi te yi Da kelɛ, yo ndi yite sendi yi Mɔnɔ kelɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kɛto Da kɛ kwaɗyɛ Mɔnɔ. A kɛ teɗye Mɔnɔ mɛyasi hɛnɛ te yi nyɛ nɛ ŋguru wenɛ kelɛ kɛ́. A ta kɛ̀ mbɔmbu teɗye nyɛ nyaŋgwɛ mɛkele kwa̧ yikɛ, nɛ́ gba wunɛ ŋgbakima. ");
INSERT INTO kkj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nda Da kɛ womiyɛ ɓemuŋ kelɔ nde, ɓo ɓɛ̂ki nɛ joŋ, ɗete Mɔnɔ kɛ kelɔ sendi nde, mumɔ hɛnɛ te yi nyɛ kwaɗyɛ nyɛ nyɛ joŋgwɛ, a kɛ nyɛ nyɛ yo. ");
INSERT INTO kkj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yo sendi nde, Da yeti nɛ say pɛsina jɔsi mumɔ na. Yasi wɛtɛ, a ɓoŋma mɛsay mɛte hɛnɛ nyɛ Mɔnɔ. ");
INSERT INTO kkj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Da kelma ɗete, nɛ́ ɓomɔ hɛnɛ lukse Mɔnɔ nda yi ɓo lukse nɛ nyɛ kɛ́. Mɔ te ɛ ti lukse Mɔnɔ na, mɔ te yeti kɛ lukse sendi Da, mɔ te ɛ tomma nyɛ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔ te ɛ wokɛ yasi te yi mi lɛpɛ tikɔ temɔ kɛ yi Mɔ te ɛ tomma mi kɔ, mɔ te nɛ joŋgwɛ te yi kpo nɛ kpo, a tí saŋgwa nɛ jɔsi na. Yasi wɛtɛ, a ɗuwa̧ kɛ sɔŋ kɛ̀ kɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgimɔ mɛ kɛ wuta, yo ma si ɗya̧, ŋgimɔ te yi ɓemuŋ ta wokɔ nɛ mɛn Mɔnɔ Njambiyɛ. Ɓotu ɓete ɓe ta wokɔ mɛn nɛ ɓaka ta ju̧. ");
INSERT INTO kkj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kɛto nda Da njuku joŋgwɛ kɛ́, ɗete a kelma sendi nde, Mɔnɔ ɓɛ̂ki njuku joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A nya sendi nyɛ ɗeti te yi jɔse ɓomɔ, kɛto nyɛ *Mɔnɔ mumɔ. ");
INSERT INTO kkj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Lɛpi te yi mi lɛpɛ kɛ́ tî kel nde, wunɛ ŋgbâkimaŋgwɛ na, kɛto ŋgimɔ mɛ kɛ wuta yi ɓomɔ hɛnɛ ɓe kɛ mɔy mɛɓoŋsɔŋ ndana ɓaka ta wokɔ mɛn Mɔnɔ mumɔ. ");
INSERT INTO kkj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ɓaka ɓe kelma kimɔ mɛkele kɛ joŋgwɛ ɗyan ɓaka ta womiyɛ yí ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. Ma ɓaka ɓe kelma ɓeya mɛkele kɛ joŋgwɛ ɗyan ɓaka ta womiyɛ saŋgwa nɛ jɔsi. ");
INSERT INTO kkj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mi ti yaka kelɔ mbɛ yaŋa nda yi mi kwaɗyɛ kɛ́ na. Mi jɔ́sa lɛpi ɓeŋgwɛ yasi te yi mi wokɛ kɛ numbu Da kɛ́. Sendi, mi pɛ́si lɛpi nɛ ŋgbeŋ, kɛto mi ti sáŋ, nɛ́ mi kel yasi te yi mi kwaɗyɛ kɛ́ na. Yasi wɛtɛ, mi sáŋ, nɛ́ mi kel yasi te yi Mɔ te ɛ tomma mi kɔ kwaɗyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nde: «Kɛ gba mi nɛ ŋguru wombɛ lɛpɛ yasi te yi mi duwa̧ kɛ kasi mbɛ, yite mumɔ ti yaka jayɛ nde, mi lɛ́pi gbakasi na. ");
INSERT INTO kkj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yo wɛtɛ mumɔ dɛlɛ kɛ lɛpɔ yasi te yi nyɛ duwa̧ kɛ kasi mbɛ. Mi duwa̧ nde, yasi te yi nyɛ lɛpɛ kɛ kasi mbɛ kɛ́, gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gba wunɛ tomma ɓomɔ kɛnjɛ kɛ yi Jaŋ, ɛ nyɛ lɛpɛ gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yasi wɛtɛ kɛ yembɛ, yo yeti kɛ diyɛ nde, wɛtɛ mumɔ pâŋ lɛpɔ yiŋa yaŋa te yi nyɛ duwa̧ kɛ kasi mbɛ na. Ndi nde, yasi te yi mi lɛpima kɛ́, mi lɛ́pi, nɛ́ wunɛ ɓɛ nɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaŋ ɗiyma nda lambo te yi ju̧ nyɛ mɛjasi kɛ́. Ɛ gba wunɛ ɓɛ nɛ nyaŋgwɛ mɛsosa yaka mɔnɔ ŋgimɔ kɛ mɔy mɛjasi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Yasi wɛtɛ, mi mbɛ nɛ yasi te yi kɛ teɗye mi nyɛ ɓomɔ kwa̧ yi Jaŋ teɗya kɛ́. Yasi te yi teɗye yo kɛ́, yo mɛkele mɛte yi Da nya mi nde, mi tônjukwɛ kɛ́. Gba mɛkele mɛte yi mi kelɛ kɛ́ kɛ teɗye gbate nde, yo Da tomɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Da, Mɔ te ɛ tomma mi kɔ lɛpima gbakasi kɛ kasi mbɛ nɛ ŋguru wenɛ. Ko wunɛ tì wokɛ mɛn nɛ wɛtɛ yesɔ ho ɓɛŋɛ mbɔmbu nɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma wunɛ yeti kɛ ɓakiɗye mɛlɛpi mɛnɛ kɛ mɔy mɛtemɔ mun na. Kɛto wunɛ yeti kɛ tikɔ yun temɔ nɛ mɔ te yi nyɛ tomma kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Wunɛ nɛ́mba mɛkana mɛ Njambiyɛ, kɛto wunɛ kɛ tikɔ temɔ nde, wunɛ ta dolɔ nje joŋgwɛ te yi kpo nɛ kpo kɛ mɔyte. Yo gbate nde, mɛkana mɛte kɛ lɛpɔ gbakasi kɛ kasi mbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ko ɓɛkɔ ɗete, wunɛ yeti kɛ kwaɗyɛ ɓeŋgwɛ mi, nɛ́ wunɛ ɓɛ nɛ joŋgwɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi yeti kɛ sa̧ nde, ɓomɔ lûksa mi na. ");
INSERT INTO kkj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ndi nde, mi duwa̧ wunɛ kandɛ nyiŋɔ to kumɔ nyɛy kol. Wunɛ yeti kɛ kwaɗyɛ Njambiyɛ kɛ mɔy mɛtemɔ mun na. ");
INSERT INTO kkj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi nja̧ mbɛ nɛ ɗinɔ Saŋmbɛ nde, yo nyɛ tomɛ mi, ko wunɛ yeti kɛ jayɛ mi na. Ma ŋgɛ wɛtɛ mumɔ nje nɛ gba ɗinɔ te wenɛ nɛ ŋguru wenɛ nje lɛpɔ mɛyasi nyɛ wunɛ kɛ́, wunɛ ta jayɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nda yi wunɛ kwaɗyɛ ndi nde, yɔkɔ lûksa jakɔsɔ kinɛ sa̧ nde, Njambiyɛ nyɛpɔ lûksa wunɛ kɛ́, ’wunɛ ta tikɔ temɔ nɛ mi nan? ");
INSERT INTO kkj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wunɛ tî taka nde, mi ta pɛsɔ lɛpi nyɛ kɛ numbu yun kɛ mbɔmbu Da na. Mɔ te ɛ ta kelɔ ɗete kɔ, yo ndi Mɔyisi nyɛpɔ, nyɛ yi wunɛ ɓɛ nɛ ɓiɓina temɔ nɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kɛto wunɛ má tiki temɔ gbate nɛ Mɔyisi, ma wunɛ ta tikɔ sendi temɔ nɛ mi, kɛto a kɛtima mɛyasi kɛ kasi mbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma ŋgɛ wunɛ ti tikɛ temɔ kɛ mɛyasi mɛte yi Mɔyisi kɛtima kɛ́, wunɛ ma nje tikɔ temɔ kɛ mɛlɛpi mɛte yi mi lɛpɛ kɛ́ nɛ nje te yin?» ");
INSERT INTO kkj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kɛ kɔŋte, ɛ Yesus kwa̧ kɛ̀ kɛ ŋginjɛ nyaŋgwɛ matɔ te yi ɓo jeɓa nde Matɔ te yi Galile ho nde Matɔ te yi Tiberiyad kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɛ nyaŋgwɛ ŋgil ɓomɔ ɓeŋgwɛ nyɛ, kɛto ɓo ɗikima ɓɛŋɛ mɛyekambiyɛ mɛte yi nyɛ ɗikima kelɔ kɛ yotu ɓotu ɓe kɔn kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ɛ Yesus ɓendɛ keki kwa̧ ɗiyɔ mɛtiɗyɛ ɓenɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jesɔ *Paska Ɓeyudɛn ɓa̧ kɛ wuta. ");
INSERT INTO kkj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kɛ Yesus ma kaŋɛ misi ɓɛŋɛ nde, nyaŋgwɛ ŋgil kɛ nje kɛ yenɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ Filip nde: «Hɛ ta ɓɔmɔ ɓa mɛɗye we, nɛ́ ɓomɔ te ɓaka ɗye?» ");
INSERT INTO kkj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus lɛ́pi yinɔri, na pa woku nɛ yasi te yi Filip ta yeŋsa kɛ́. Kɛto nyɛ nɛ ŋguru wenɛ ma duwɛ yasi te yi nyɛ ta kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ɛ Filip yeŋsa nyɛ nyɛ nde: «Ko mɔni te yi yakama gbo mɔ mɛsay kɛ mɛyesɔ gɔmay yiɓa ti yaka ɓɔmɔ mɛɗye yi yaka nde, mumɔ hɛnɛ ɓɛ̂ki nɛ mɔnɔ mbulma yasi te yi ɗye na.» ");
INSERT INTO kkj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ɛ wɛtɛ jekɛ Yesus nde Andere te maŋ nɛ Simɔn Piyɛr lɛpɛ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Wɛtɛ mɔnɔ mbam waka nɛ mɛmampa yitan ɓu̧ ɓenjanjɔ yiɓa. Ma yite yakama kelɔ ŋge kɛ nyaŋgwɛ ŋgil te yikɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ɛ Yesus lɛpɛ nde: «Wunɛ lɛ̂pi nyɛ ɓomɔ nde, ɓo ɗîy mɛtiɗyɛ.» Pɔku te yi womɛte ɓa̧ tandɛ mɛmbunjɔ. Ɛ ɓomɔ ɗiyɛ mɛtiɗyɛ. Ɓembam nɛ ɓembam kumma nda ɓomɔ tomay yitan. ");
INSERT INTO kkj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ndana, ɛ Yesus ɓu̧ mɛmampa. Kɛ nyɛ ma si nyɛ Njambiyɛ wosoko kɛ́, ɛ nyɛ ɓu̧ yo kaɓɔ nyɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka, ɛ nyɛ kelɛ sendi ɗete nɛ ɓenjanjɔ. Mumɔ hɛnɛ ɓoŋma nda yi nyɛ kwaɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kɛ ɓomɔ ma si ɗyena ditɔ kɛ́, ɛ Yesus lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wunɛ sîki wesiɗye mɛɓukwɛ mɛte, ma yaŋa nje sambiyɛ nɛ gbɛlate.» ");
INSERT INTO kkj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kɛ mɛmampa mɛnɔri yitan yi ɓomɔ ɗya kɛ́, ɓo nja̧ wesiɗye mɛɓukwɛ mɛte tonjɛ mɛmakɔ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kɛ ɓomɔ ma ɓɛŋɛ mɛyekambiyɛ mɛte yite yi Yesus kelma kɛ́, ɛ ɓo ɗiki lɛpɔ nde: «Mbam kɔ gbate mɔ punja mɛlɛpi mɛ Njambiyɛ ɛ ɓa̧ nde, a ta nje kɛ to mɛnɛti kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kɛ Yesus ma duwɛ nde, ɓomɔ kɛ kwaɗyɛ nje ɓu̧ nyɛ kɛ̀ tɛmbiɗye kumande nɛ ɗeti kɛ́, ɛ nyɛ yɔkwɛ nɛ kɔkɔ kɛ̀ kɛ to keki ndi nyɛ nyɛpɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kɛ ɓekoko ma ɗya̧ kɛ́, ɛ ɓejekɛ ɓe Yesus sɛliyɛ kɛ̀ kɛ goŋ nyaŋgwɛ matɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɛ ɓo ɓendɛ wɛtɛ landi yí saɓiyɛ nɔ kɛ̀ nɔ pulɔ Kapɛrnawum. Yinɔri tu ma kelɔ. Sendi, Yesus tì pa yɔkwɛ nje dolɔ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nyaŋgwɛ pupɔ ɓa̧ kɛ kwa̧, ɛ mɛkumbɔ kelɛ kɛ ɗuku ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓo ɗukuma landi kɛndɔ kumɔ nda kilomɛta yitan nɛ yitan jɔ wɛtɛ. Ɓo ɓɛ́ŋa Yesus kɛ kɛndɔ kɛ to ɗuku kɛ̀ nɔ pulɔ landi. Ɛ ɓo gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yo mi, wunɛ tî gwaki wɔ̧ na.» ");
INSERT INTO kkj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ndana, ɛ ɓo ɓɛ nɛ mɛsosa yí nyinje nyɛ kɛ landi, yaka nɛ landi kɛ tɛmɛ kɛ mbɛy te yi ɓo kwaɗya kɛ̀ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Misi pupɛ ŋgil ɓotu ɓete ɓe tikama kɛ ŋginjɛ ɗuku ɓaka nja̧ takɛ duwɛ nde, landi ɓa̧ ndi wɛtɛ kwey mate. Ɓo duwa̧ sendi nde, Yesus tì nyiŋɛ landi ɓenɛ ɓejekɛ ɓenɛ na. Yo nde, ɓejekɛ kwaŋma ndi ɓo ɓepɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yasi wɛtɛ, ndana yiŋa mɛlandi nja̧ ɗya̧ wulɛ kɛ Tiberiyad kɛ kɛki mbɛy te yi ɓo ma ɗyáki mampa, yite Kumande Yesus paŋma pa nyɛ Njambiyɛ wosoko kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kɛ ŋgil ma ɓɛŋɛ nde, ko Yesus ko ɓejekɛ ɓenɛ tì ɓɛ womɛte kɛ́, ɛ ɓo ɓendɛ mɛlandi mɛnɔri kwa̧ kɛ̀ kɛ Kapɛrnawum kɛ̀ sa̧ nyɛ mate. ");
INSERT INTO kkj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kɛ ɓo ma dolɔ nyɛ mate kɛ ŋginjɛ ɗuku kɛ́, ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Yekele, ɔ njáki ɓa woŋga ndenɛn?» ");
INSERT INTO kkj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Yo gba gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wunɛ ti sáŋ mi, kɛto mɛyekambiyɛ mɛte yi wunɛ ɓɛŋma kɛ́ na. Yasi wɛtɛ, wunɛ sáŋ mi, kɛto wunɛ ɗya mampa ditɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wunɛ tî kel mɛsay kɛto mɛɗye mɛte yi ta ɓeyɔ gwe nɛ ŋgbɔt kɛ́ na. Yasi wɛtɛ, wunɛ kêl mɛsay kɛto mɛɗye mɛte yi ta ɗiyɔ kelɔ nde, wunɛ ɓɛ̂ki nɛ joŋgwɛ te yi kpo nɛ kpo. Mɛɗye mɛte, yo *Mɔnɔ mumɔ ta nyɛ wunɛ yo, kɛto yo ndi gba nyɛ yi Njambiyɛ tɔkuma.» ");
INSERT INTO kkj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ndana, ɛ ɓo nje diyɛ nyɛ nde: «Yo yasi te nda yi wusɛ yâkaŋgwɛ kelɔ, nɛ́ wusɛ kel mɛkele mɛte yi Njambiyɛ kwaɗyɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Yasi te yi Njambiyɛ kwaɗyɛ nde, wunɛ kêl kɛ́, yo nde, wunɛ tîki temɔ kɛ yi mɔ te yi nyɛ tomma kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɛ ɓo nje lɛpɔ nyɛ nyɛ nde: «Kwalɔ mɛyekambiyɛ te nda yi wɛ kelɛ yi wusɛ ta ɓɛŋɛ tikɔ nɛ temɔ kɛ yɔ kɛ́? Yo mɛsay te nda wɛ kelɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ɓesaŋmbambɔ ɓusu ɗya *man kɛ koŋgor nda yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹A nya ɓo mɛɗye mɛte yi wulɛ kɛ ɗyoɓɔ kɛ́ nde, ɓo ɗyâki.› » ");
INSERT INTO kkj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔyisi tì nyɛ wunɛ mɛɗye mɛte yi wulɛ kɛ ɗyoɓɔ kɛ́ na. Yasi wɛtɛ, yo Saŋmbɛ kɛ nyɛ wunɛ gba mɛɗye mɛte yi wulɛ kɛ ɗyoɓɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kɛto mɛɗye mɛte yi Njambiyɛ nyɛ kɛ́, yo yɔkɔ ɛ piyɛ wulɛ ɗyoɓɔ nje nyɛ ɓotu ɓe mɛnɛti maka joŋgwɛ te yi kpo nɛ kpo kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɛ ɓo nje lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ mbam, nyɛkɔ wusɛ mɛɗye mɛte yite mɛtu hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","«Mi mbɛ mɛɗye mɛte yi nyɛ mumɔ joŋgwɛ. Mɔ te ɛ nje kɛ yembɛ, mɔ te tí gwe nja wɛtɛ yesɔ na. Sendi, yɔkɔ ɛ tikɛ temɔ nɛ mi, mɔ te tí gwe yɛsiɗyɛ wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yasi wɛtɛ, mi ma lɛpɔ nyɛ wunɛ, ma ko ɓɛkɔ nde, wunɛ ɓɛŋma mi, wunɛ yeti kɛ tikɔ temɔ nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓomɔ hɛnɛ ɓe Da nyɛ mi, ɓo ta nje kɛ yembɛ. Ko mi tí sɛŋɛ mɔ te ɛ nje kɛ yembɛ kɔ na, ");
INSERT INTO kkj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kɛto mi ti píkwɛ wulɛ ɗyoɓɔ, nɛ́ mi nje kel yasi te yi mi kwaɗyɛ kɛ́ na. Yasi wɛtɛ, mi njáki nje kelɔ yasi te yi Mɔ te ɛ tomma mi kɔ kwaɗyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yo nde, Mɔ te ɛ tomma mi njesɛ kɔ kwáɗyikwɛ nde, kɛ njoka ɓomɔ hɛnɛ te yi nyɛ nya mi ɓaka, mi tî ɗimbiɗya mumɔ wɛtɛ nɛ wɛtɛ na. Yasi wɛtɛ, mi wômkwɛ ɓo hɛnɛ kɛ njena yesɔ siyna mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kɛto yasi te yi Saŋmbɛ kwaɗyɛ kɛ́, yo nde, mumɔ hɛnɛ ɛ kaŋɛ misi ɓɛŋɛ nɛ mi Mɔnɔ tikɔ temɔ nɛ mi, mɔ te ɓɛ̂ki nɛ joŋgwɛ te yi kpo nɛ kpo. Ma mi ta womiyɛ mbɛ nyɛ kɛ njena yesɔ siyna mbokɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ɗete, ɛ Ɓeyudɛn nyiŋgila nɛ nyɛ, kɛto a lɛpima nde: ‹Mi mbɛ mɛɗye mɛte yi piya wulɛ ɗyoɓɔ.› ");
INSERT INTO kkj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɛ ɓo ɗiki lɛpɔ nde: «’Yɔkɔ yeti gba Yesus te mɔnɔ Yosɛp na? ’Wusɛ yeti kɛ duwɛ saŋgwɛ ɓenɛ nyaŋgwɛ na? Ma ŋge ɓa yi nyɛ nje lɛpɔ nde, a píkwɛ wulɛ ɗyoɓɔ nje nɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ɛ Yesus nje yeŋsa nyɛ ɓo nde: «Wunɛ tîki mɛnyiŋgila. ");
INSERT INTO kkj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mumɔ ti yaka nje kɛ yembɛ kinɛ nde, Da, Mɔ te ɛ tomma mi kɔ ɗûla nyɛ na. Ma mi ta womiyɛ mbɛ mɔ te kɛ njena yesɔ siyna mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yo kɛtinate kɛ mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ nde: ‹Njambiyɛ ta teɗye ɓo hɛnɛ mɛyasi.› Mumɔ hɛnɛ ɛ lɛŋgwa mɛtɔ kɛ yasi te yi Da lɛpima ɓakiɗye yo, mɔ te kɛ nje kɛ yembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yeti nde, wɛtɛ mumɔ ɓɛŋma Da wɛtɛ yesɔ na, soŋɛ ndi yɔkɔ ɛ wulma pɛ yi Njambiyɛ nje nɔ kɔ. Yo ndi nyɛ ɓɛŋma Da. ");
INSERT INTO kkj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔ te ɛ tikɛ temɔ nɛ mi, mɔ te nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi mbɛ mɛɗye mɛte yi nyɛ mumɔ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ɓesaŋmbambɔ ɓun ɗya *man kɛ koŋgor. Ko ɓɛkɔ ɗete, ɓo gwa̧. ");
INSERT INTO kkj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mɛɗye mɛte yi piya wulɛ ɗyoɓɔ kɛ́ kél nde, mɔ te ɛ ɗye yo, a tí gwe na. ");
INSERT INTO kkj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi mbɛ mɛɗye mɛte yi kelɛ nde, mumɔ ɓɛ̂ki nɛ joŋgwɛ yi piya wulɛ ɗyoɓɔ kɛ́. Ŋgɛ mumɔ ɗye mɛɗye mɛte, a ta ɓɛ nɛ joŋgwɛ kpo nɛ kpo. Yo nde, mɛɗye mɛte yi mi ta nyɛ nyɛ kɛ́, yo mɛmbundɔ mɛmbɛ. Mi ta nyɛ yo, nɛ́ ɓotu ɓe mɛnɛti maka ɓɛ nɛ joŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ɗete, ɛ Ɓeyudɛn kandɛ nyɛna mɛso tandɛ yan lɛpɔ nde: «Mbam kɔ yakama nyɛ wusɛ mɛmbundɔ mɛnɛ nde, wusɛ ɗyâki nɛ nje te yin?» ");
INSERT INTO kkj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ wunɛ ti ɗye mɛmbundɔ mɛ *Mɔnɔ mumɔ, hɔɓiye sendi mɛkiyɔ mɛnɛ na, wunɛ yeti nɛ joŋgwɛ kɛ yotu yun na. ");
INSERT INTO kkj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mɔ te ɛ ɗye mɛmbundɔ mɛmbɛ, hɔɓiye sendi mɛkiyɔ mɛmbɛ, mɔ te nɛ joŋgwɛ te yi kpo nɛ kpo. Mi ta womiyɛ nyɛ kɛ njena yesɔ siyna mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yo nde, mɛmbundɔ mɛmbɛ gbate kpasa mɛɗye. Mɛkiyɔ mɛmbɛ sendi gbate kpasa yasi te yi siɗyɛ yɛsiɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mɔ te ɛ ɗye mɛmbundɔ mɛmbɛ, hɔɓiye sendi mɛkiyɔ mɛmbɛ, mɔ te kɛ temɔ mbɛ, mi sendi kɛ temɔ nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Da te ɛ kelɛ nde, mumɔ ɓɛ̂ki nɛ joŋgwɛ kɔ tomma mi. Mi jóŋnaŋgwɛ jakimɛ nyɛ. Ɗete sendi, mɔ te ɛ ɗye mi, mɔ te ta joŋna sendi jakimɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mɛɗye mɛte yi piya wulɛ ɗyoɓɔ kɛ́, yori. Yo yeti nda *man te yi ɓesaŋmbambɔ ɓun ɗya, ko ɓɛkɔ ɗete, ɛ ɓo ɗe ndi gwe kɛ́ na. Yasi wɛtɛ, mɔ te ɛ ta ɗye mɛɗye te yikɛ kɔ ta ɗiyɔ kpo nɛ kpo.» ");
INSERT INTO kkj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus lɛ́pi mɛlɛpi maka kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ Kapɛrnawum kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kɛ ɓo ma si wokɔ mɛlɛpi mɛte yi nyɛ lɛpima kɛ́, ɛ ɓaŋa ɓejekɛ ɓenɛ ɓuɗyate lɛpɛ kɛ kɔŋte nde: «Lɛpi te yikɛ nɛ ɗitɔ ɓuɗyate. Nda yakama ɓiye to te kɔ?» ");
INSERT INTO kkj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus duwa̧ kɛ mɔy temɔ nɛ nde, ɓejekɛ ɓenɛ kɛ nyiŋgila kɛto lɛpi te yi nyɛ lɛpima kɛ́. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «’Lɛpi kɛ kɛ njaŋgwɛ wunɛ? ");
INSERT INTO kkj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma yo ta nje ɓɛ ɓa nan, ŋgɛ wunɛ ɓɛŋɛ *Mɔnɔ mumɔ kɛ ɓendɔ yɔkwɛ kɛ̀ kɛ mbɛy te yi nyɛ paŋma ɗiyɔ kɛte kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yo Kimɔ Sisiŋ nyɛ mumɔ joŋgwɛ. Mɛmbundɔ yeti nɛ ɗeti te yi kelɔ yiŋa kimɔ yasi na. Mɛlɛpi mɛte yi mi lɛpima mbɛ nyɛ wunɛ kɛ́, yo mɛlɛpi mɛte yi nyɛ mumɔ Sisiŋ Njambiyɛ, nyɛ sendi nyɛ joŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yasi wɛtɛ, ɓaŋa waka kɛ njoka yun yeti kɛ tikɔ temɔ nɛ mi na.» Yesus lɛ́pi ɗete, kɛto a ma duwɛ ɓotu ɓete ɓe tì tikɛ temɔ nɛ nyɛ ɓaka njombu yaŋa, duwɛ sendi mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nde: «Yori yi mi lɛpima nyɛ wunɛ nde, mumɔ ti yaka nje kɛ yembɛ, ŋgɛ Da ti nyɛ nyɛ ɗeti na.» ");
INSERT INTO kkj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kandɛ kɛ ŋgimɔ te yite ɛ ɓaŋa ɓejekɛ ɓenɛ ɓuɗyate ɗuwɛ kɛ njɔŋ nɛ kinɛ kɛndɔ se ɓenɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ɛ Yesus nje ɗiyɔ lɛpɔ nyɛ ɓejekɛ te ɓari kamɔ jɔ yiɓa nde: «’Wunɛ sendi, wunɛ kɛ kwaɗyɛ kwa̧?» ");
INSERT INTO kkj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ɛ Simɔn Piyɛr yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, hɛ ta nje kwa̧ kɛ̀ pɛ yi nda? Yo wɛ ɓɛ nɛ mɛlɛpi mɛte yi nyɛ mumɔ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma wusɛ kɛ tikɔ su temɔ kɛ yɔ, duwɛ sendi nde, wɛ pupuna mɔ te yi Njambiyɛ tɔkuma njesɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ɛ Yesus yeŋsa nyɛ ɓo nde: «’Wunɛ ɓaka kamɔ jɔ yiɓa, yeti gba mi tɔkɛ wunɛ na? Ma wɛtɛ mumɔ kɛ njoka yun nɛ *Satan.» ");
INSERT INTO kkj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yasi yinɔri, a lɛ́pi nɛ Yudas te mɔnɔ Simɔn Iskariyot, kɛto yo gba nyɛ mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ. A ɓa̧ kɛ njoka ɓejekɛ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kɛ kɔŋ mɛyasi mɛnɔri ɛ Yesus kwa̧ kɛ̀ mɛɗya nɛ mɛɗya kɛ Galile. A tì kwaɗyɛ kɛ̀ kɛ mɛɗya mɛte yi Yuda na, kɛto ɓekum Ɓeyudɛn ɗikima sa̧ nje te yi wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yinɔri jesɔ Ɓeyudɛn yi ɓo ɗikima sumɔ mɛbala ya kɛte kɛ́ ɓa̧ kɛ wuta. ");
INSERT INTO kkj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɛ ɓemaŋ nɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ tî ɗiy se waka na, kwaŋgɔ kɛ̀ kɛ Yuda, nɛ́ ɓejekɛ ɓɔ ɓɛŋ sendi nyaŋgwɛ mɛkele mɛte yi wɛ kelɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kɛto ŋgɛ mumɔ kwaɗyɛ nde, ɓomɔ dûkwɛ nyɛ, a ti kél yasi sɔɗyate na. Ma nda wɛ kɛ kelɔ nyaŋgwɛ mɛkele ɗete kɛ́, punjukwɛ yotu yɔ nɛ ŋguru wɔ kɛ misi mɛ ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ko ɓemaŋ nɛ Yesus sendi tì ɓɛ kɛ tikɔ temɔ nɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Ŋgimɔ te yembɛ tì pa ɗya̧ na. Yasi wɛtɛ kɛ yun, ŋgimɔ hɛnɛ kimɔte. ");
INSERT INTO kkj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɓotu ɓe mɛnɛti maka ti yaka ɓenɔ wunɛ na. Yasi wɛtɛ, ɓo ɓén mi, kɛto mi kɛ ɓɛŋɛ mɛkele man lɛpɔ nde, yo ɓeyate. ");
INSERT INTO kkj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wunɛ kwâŋ yun kɛ̀ jesɔ te. Kɛ ɓɛ mi, mi yeti kɛ kɛ̀ mbɛ na, kɛto ŋgimɔ te yembɛ tì pa yaka na.» ");
INSERT INTO kkj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kɛ nyɛ ma si lɛpɔ ɗete nyɛ ɓo kɛ́, ɛ nyɛ kwa̧ ɗiyɔ ndi kɛ Galile. ");
INSERT INTO kkj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndana, kɛ ɓemaŋ ma si kwa̧ kɛ̀ jesɔ kɛ́, ɛ nyɛ tɛmɛ mbɔmbila kwa̧ kɛ̀ sendi mate kinɛ punjɛ yotu na. ");
INSERT INTO kkj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ɓekum Ɓeyudɛn ɗikima sa̧ nyɛ kɛ jesɔ lɛpɔ nde: «A we?» ");
INSERT INTO kkj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɓomɔ ɗikima lɛpɔ kasi nɛ ɓuɗyate nɛ hi̧hi̧hi̧ kɛ njoka ŋgil. Ɓaŋa ɗikima lɛpɔ nde: ‹Mbam te kimɔ mumɔ!› Ɓaŋa nde: ‹Ja̧, a kɛ seɓile ɓomɔ kɛnjɛ kɛ ɓeya nje.› ");
INSERT INTO kkj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yasi wɛtɛ, ko mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛ kɛ lɛpɔ kasi nɛ nɛ gbas gbas kɛ misi mɛ ɓomɔ na, kɛto ɓo ɗikima kambɔ ɓekum Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ndana, kɛ mɛtu mɛ jesɔ ma kumɔ kɛ ɓembe kɛ́, ɛ Yesus kwa̧ kɛ̀ kɛ mbanjɔ Njambiyɛ kandɛ teɗya ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɛ Ɓeyudɛn ŋgbakima lɛpɔ nde: «Mbam kɔ tì kelɛ yiŋa nyaŋgwɛ sukul na. Ma a njáki nje ɓɛ nɛ duwa̧ mɛkana mɛte yikɛ wulɛ nɔ we?» ");
INSERT INTO kkj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ɛ Yesus nje yeŋsa nyɛ ɓo nde: «Yasi te yi mi teɗye kɛ́ ti wúla kɛ ɗyanɔ ɗyembɛ nɛ ŋguru wombɛ na, yasi wɛtɛ, yo wúla kɛ yi Njambiyɛ, nyɛ Mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ŋgɛ mumɔ jayɛ nde, a ta kelɔ yasi te yi Njambiyɛ kwaɗyɛ, mɔ te ta duwɛ, ho yasi te yi mi teɗye kɛ́ wúla kɛ yi Njambiyɛ, ho yo wúla kɛ ɗyanɔ ɗyembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mɔ te ɛ lɛpɛ yasi te yi wulɛ kɛ ɗyanɔ ɗyenɛ kɔ sáŋ nde, ɓomɔ lûksa nyɛ. Yasi wɛtɛ, yɔkɔ ɛ kelɛ yasi sa̧ nde, ɓomɔ lûksa mɔ te ɛ tomma nyɛ kɔ kɛ lɛpɔ gbakasi. Sendi, a yeti mɔ kɔtu mɛkele na. ");
INSERT INTO kkj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Mɔyisi tì nyɛ wunɛ mɛmboŋga mɛ Njambiyɛ na? Ma ko mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yun yeti kɛ joŋna ɓeŋgwɛ mɛmboŋga mɛte na. Kɛto ŋge yi wunɛ sa̧ nje te, nɛ́ wunɛ wo mi kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɛ ɓotu ɓete ɓe ɓa̧ womɛte nɛ ŋgil te ɓaka yeŋsa nde: «Wɛ nɛ ɓeya sisiŋ kɛ yotu. Mɔ te nda kɛ sa̧ nje te yi wo wɛ kɔ?» ");
INSERT INTO kkj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Mi kelma ndi nyaŋgwɛ mɛkele wɛtɛ, ma wunɛ hɛnɛ kɛ ŋgbakima. ");
INSERT INTO kkj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mɔyisi nya wunɛ mboŋga nde, wunɛ pɛ̂si ɓɔnɔ ɓembam hɛnɛ. Yasi yinɔri ti kánda kɛ yi Mɔyisi na, yo wúla nɛ ɓesaŋmbambɔ ɓete. Yo kɛto mboŋga te yite yi Mɔyisi nya kɛ́, ko kɛ yesɔ *Saba wunɛ kɛ pɛsɔ ɓɔnɔ ɓembam. ");
INSERT INTO kkj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wunɛ kɛ pɛsɔ ɓɔnɔ ɓembam ko kɛ yesɔ Saba, kambɔ wunɛ mɛ nje jɔsiɗye mboŋga te yi Mɔyisi nya kɛ́. Ŋgɛ wunɛ kelɛ ɗete, kɛto ŋge yi wunɛ nje wokɔ ŋgambi nɛ mi, kɛto mi siɗya kɔn ndiŋgɛlɛ mumɔ kɛ yesɔ Saba kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wunɛ tî pɛsi jɔsi ɓeŋgwɛ mbɛri misi mɛ mumɔ na, yasi wɛtɛ, wunɛ pɛ̂si jɔsi nɛ ŋgbeŋ.» ");
INSERT INTO kkj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɛ ɓaŋa ɓomɔ ɓe Yerusalɛm ɗiki lɛpɔ nde: «’Yeti mbam kɔ yi ɓomɔ sa̧ nje te yi wo nyɛ kɔ na? ");
INSERT INTO kkj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nɛ ɓɛ̂ŋa ndi, a kɛ lɛpina kɛ misi mɛ ɓomɔ nɛ gbas gbas, ko ɗete, ɓo yeti kɛ lɛpɔ yaŋa nyɛ nyɛ na. ’Yite nde, ɓekum ma duwɛ gbate nde, nyɛ *Krist? ");
INSERT INTO kkj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yasi wɛtɛ, kɛ mbam te yɔkɔ, wusɛ duwa̧ su mbɛy te yi nyɛ wulma kɛte nje nɔ kɛ́. Ndi nde, komɛ Krist ta nje kɛ́, ko mumɔ tí duwɛ mbɛy te yi nyɛ wulma kɛte nje nɔ kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbanjɔ Njambiyɛ. Ɛ nyɛ lɛpɛ nɛ mɛn kɛ kwey nde: «’Wunɛ lɛ́pi gba nde, wunɛ duwa̧ mi, duwɛ sendi mbɛy te yi mi wulma kɛte nje nɔ kɛ́? Ndi nde, mi ti njáki nɛ ɗeti te yembɛ na. Mɔ te ɛ tomma mi kɔ, nyɛ mɔ te yi ɓomɔ yâkaŋgwɛ tikɔ temɔ nɛ nyɛ, ma wunɛ yeti kɛ duwɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndi mi kɛ duwɛ mbɛ nyɛ, kɛto mi wúla pɛ yenɛ nje nɔ. Yo nyɛ tomɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɛ ɓo sa̧ nje te yi ɓiye nyɛ, ko ɓɛkɔ ɗete, mumɔ wɛtɛ nɛ wɛtɛ tì kɛnjɛ ɓɔ kpokɛ nɛ nyɛ na, kɛto ŋgimɔ nɛ tì pa ɗya̧ na. ");
INSERT INTO kkj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɓomɔ ɓuɗyate kɛ njoka ŋgil tikima temɔ kɛ yenɛ. Ɛ ɓo ɗiki lɛpɔ nde: «Komɛ *Krist ta nje kɛ́, a ta kelɔ ka mɛyekambiyɛ kwa̧ yikɛ yi mbam kɔ kelma kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","*Ɓefarisɛ̧ wokuma mɛyasi mɛnɔri yi ɓomɔ ɗikima nyiŋgila kɛ njoka ŋgil kɛ kasi Yesus kɛ́. Ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ Ɓefarisɛ̧ tomɛ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ, nɛ́ ɓo kɛ̀ ɓiy nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ɛ Yesus lɛpɛ nde: «Mi ndi nɛ mɔnɔ ŋgimɔ te yi kwaŋɗye sinɛ wunɛ, kɛ kɔŋte, mi má yɔkwɛ kɛ̀ pɛ yi Mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wunɛ ta sa̧ mi, ko wunɛ tí dolɔ mi na. Sendi, wunɛ tí kumɔ yun kɛ mbɛy te yi mi ta ɗiyɔ mbɛ kɛte na.» ");
INSERT INTO kkj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ɛ Ɓeyudɛn nje lɛpɔ tandɛ yan nde: «Yite nde, a ta kɛ̀ ɓa we yi wusɛ ta ɗiyɔ kinɛ dolɔ nyɛ kɛ́? ’Yite nde, a ta kɛ̀ kɛ yi Ɓeyudɛn ɓete yi ɓo wanjima ɓo ɓe ɗiyɛ kɛ njoka Ɓegrɛk ɓaka? ’A ta kɛ̀ mate kɛ̀ teɗye Ɓegrɛk mɛlɛpi mɛ Njambiyɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yiŋa nde: « ‹Wunɛ ta sa̧ mi, ko wunɛ tí dolɔ mi na,› sendi, ‹wunɛ tí kumɔ kɛ mbɛy te yi mi ɗiyɛ mbɛ kɛte na,› a kwáɗyikwɛ lɛpɔ komɛte nde ŋge?» ");
INSERT INTO kkj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yesɔ siyna jesɔ ɓa̧ nyaŋgwɛ yesɔ jesɔ kwa̧ bosa mɛyesɔ mɛte yiri hɛnɛ. Yesɔ te ɛ Yesus tɛmɛ lɛpɔ nɛ mɛn kɛ kwey nde: «Mɔ te ɛ gwe yɛsiɗyɛ, a njâki kɛ yembɛ nje hɔɓiye yasi te yi ta siɗyɛ yɛsiɗyɛ nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mɛkana mɛ Njambiyɛ kɛ lɛpɔ nde: ‹Mɔ te ɛ tikɛ temɔ nɛ mi, nyaŋgwɛ mɛɗuku mɛte yi nyɛ joŋgwɛ ta sokula wulɛ kɛ mɔy nɛ.› » ");
INSERT INTO kkj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yinɔri Yesus lɛ́pi nɛ kasi Kimɔ Sisiŋ te yi ɓotu ɓete ɓe tikɛ temɔ nɛ nyɛ ta ɓɛ nɔ kɛ́. Yo nde, kɛ ŋgimɔ te yite Njambiyɛ tì pa njesɛ Kimɔ Sisiŋ na, kɛto a tì pa yɔkiɗye Yesus kɛnjɛ ɗyoɓɔ kɛ mbɛy mɛluksa mɛnɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kɛ ɓaŋa ɓotu ɓete ɓe ɓa̧ kɛ njoka ŋgil ɓaka ma wokɔ mɛlɛpi mɛte kɛ́, ɛ ɓo lɛpɛ nde: «Mbam kɔ gbate mɔ punja mɛlɛpi mɛ Njambiyɛ te yi ɓo ɗikima lɛpɔ nɔ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓaŋa ɗikima lɛpɔ nde: «Yɔkɔ gba *Krist.» Ɓaŋa nde: «’Yo Krist ta wulɛ Galile nje nɔ? ");
INSERT INTO kkj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","’Mɛkana mɛ Njambiyɛ ti lɛ́pi nde, Krist ta wulɛ kɛ kandɔ kumande Davit kɛ ɗya̧ Betɛlɛhɛm komɛ Davit ɗikima ɗiyɔ kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɛ ŋgil ɓaka kɛ ɓembe kɛto Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɓaŋa diyma kɛ̀ ɓiye nyɛ. Yasi wɛtɛ, ko mumɔ wɛtɛ nɛ wɛtɛ tì kpokɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ndana, ɛ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ yɔkwɛ kɛ̀ dolɔ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ Ɓefarisɛ̧. Ɛ ɓo diyɛ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ nde: «Ŋge kelɛ yi wunɛ tì nje nɛ nyɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɛ ɓo yeŋsa nde: «Ko mumɔ wɛtɛ nɛ wɛtɛ yeti kɛ duwɛ lɛpi nda mbam te na.» ");
INSERT INTO kkj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɛ Ɓefarisɛ̧ nje yeŋsa nde: «’Yite nde, wunɛ sendi, wunɛ jayma nde, a sêɓila wunɛ? ");
INSERT INTO kkj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","’Wunɛ wokuma wɛtɛ yesɔ nde, wɛtɛ kum wusu ho Ɓefarisɛ̧ tikima temɔ nɛ nyɛ nde?» ");
INSERT INTO kkj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɛ ɓo kɛ̀ mbɔmbu lɛpɔ nde: «Ndi nde, gba ɓotu ɓaka yeti kɛ duwɛ mɛmboŋga mɛ Njambiyɛ na. Njambiyɛ ma kita nɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wɛtɛ mbam nde Nikɔdɛm ɛ ka̧ kɛ̀ ɓɛŋɛ Yesus wɛtɛ ɗyoɓɔ nɛ tu kɔ ɓa̧ kɛ njoka Ɓefarisɛ̧. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«’Yite nde, mɛmboŋga musu lɛ́pi nde, ɓo têɗya mumɔ mɛbɔnɛ kinɛ pa wokɔ mɛn mɔ te yi duwɛ nɛ mɛjɔsɔ mɛte yi nyɛ kelma kɛ́ na?» ");
INSERT INTO kkj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «’Ma yite nde, wɛ sendi, wɛ mɔ Galile? Nɛmba kimɔte, wɛ ta ɓɛŋɛ nde, ko wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ tì wulɛ wɛtɛ yesɔ kɛ Galile na.»  ");
INSERT INTO kkj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kɛ kɔŋte, ɛ mumɔ hɛnɛ tɔkɛ nje ɗuwɛ kɛ̀ tu̧ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ɛ Yesus kwa̧ nɛ kɛ̀ kɛ *Keki mɛoliviye. ");
INSERT INTO kkj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɓemɛŋmɛnɛ sut, ɛ nyɛ yɔkwɛ kɛ̀ sendi kɛ mbanjɔ Njambiyɛ. Ɛ ŋgil ɓomɔ hɛnɛ kɛ̀ kɛ yenɛ. Ɛ nyɛ kwa̧ ɗiyɔ mɛtiɗyɛ kandɛ teɗya ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ndana, ɛ ɓotu ɓe kɛtina mɛyasi nɛ̀ Ɓefarisɛ̧ ɓu̧ wɛtɛ nya te yi ɓo dolma nyɛ kɛ kelɔ wanja kɔ kɛ̀ nɔ kɛ yi Yesus. Ɛ ɓo ɓu̧ nyɛ tɛmbiɗye kɛ mbɔmbu ɓomɔ kwa̧ lɛpɔ nyɛ Yesus nde: ");
INSERT INTO kkj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«Yekele, wusɛ dɔŋgiɗya nya kɔ kɛ gba kelna wanja. ");
INSERT INTO kkj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kɛ mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́, a pɛsima nde, wusɛ lôŋ njɛl nyari nda yɔkɔ nɛ mɛtari wo. Ma kɛ yɔ, wɛ lɛ́pi yɔ nɛ ŋge?» ");
INSERT INTO kkj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓo lɛ́pi yinɔri yí lɛɓiye nɛ nyɛ, nɛ́ ɓo lɛpi nde, a lɛpinama ɓeyate. Yasi wɛtɛ, ɛ Yesus ɓutuma kɛtina kɛ ŋgbutu nɛ nyɛy ɓɔ. ");
INSERT INTO kkj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nda yi ɓo ka̧ ndi mbɔmbu yí diyɛ nyɛ mɛdiyan kɛ́, ɛ nyɛ tɛmɛ lɛpɔ nyɛ ɓo nde: «Mɔ te ɛ duwa̧ kɛ njoka yun nde, a tì pa kelɔ yiŋa ɓeya yasi wɛtɛ yesɔ kɔ kânda ɓetɛ tari lu̧ nɛ nya kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kɛ kɔŋte, ɛ nyɛ ɓutuma sendi nɛ kɔkɔ kɛtina kɛ ŋgbutu. ");
INSERT INTO kkj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kɛ ɓo ma wokɔ ɗete kɛ́, ɛ ɓo pundɛ wɛtɛ wɛtɛ kwa̧ kandɛ nɛ ɓetomba ɓete kɛ̀ nɔ. Ɛ Yesus tika nyɛpɔ ɓenɛ nyari kɛ mbɔmbu wenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ndana, ɛ Yesus tɛmɛ lɛpɔ nyɛ nyari nde: «Nyari, ɓotu ɓete ɓe lɛpinama nɛ wɛ ɓaka mɛ we? ’Ko mumɔ wɛtɛ nɛ wɛtɛ tì teɗye wɛ mɛbɔnɛ na?» ");
INSERT INTO kkj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɛ nyɛ yeŋsa nde: «Ko na, nyaŋgwɛ mbam.» Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Mi sendi, mi yeti kɛ teɗye wɛ mɛbɔnɛ na. Kwaŋgɔ, yasi wɛtɛ, wɛ tî ɓasiɗya kelɔ se ɓeya yasi na.» ");
INSERT INTO kkj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɛ Yesus nje ɓasiɗye lɛpina nyɛ ŋgil ɓomɔ lɛpɔ nde: «Mi mbɛ mɛjasi mɛte yi paniyɛ puyɛ nyɛ ɓotu ɓe mɛnɛti maka. Mɔ te ɛ ɓeŋgwɛ mi, mɔ te tí kɛndɔ kɛ mɔy yitil na, yasi wɛtɛ, a ta ɓɛ nɛ mɛjasi mɛte yi teɗye mumɔ nda yi nyɛ yâkaŋgwɛ joŋna nɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ɛ *Ɓefarisɛ̧ lɛpɛ nyɛ nyɛ nde: «Wɛ kɛ lɛpɔ yasi te yi wɛ duwa̧ kɛ kasi yɔ kɛ́ nɛ ŋguru wɔ. Ŋgɛ ɓɛ ɗete, yasi te yi wɛ lɛpɛ kɛ́ gba ja̧.» ");
INSERT INTO kkj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Ko gba mi lɛ́pi yasi te yi mi duwa̧ kɛ kasi mbɛ nɛ ŋguru wombɛ, yasi te yi mi lɛpɛ kɛ́, gbakasi, kɛto mi duwa̧ mbɛy te yi mi wulma kɛte nɛ̀ mbɛy te yi mi kɛ kɛte kɛ́. Yasi wɛtɛ, wunɛ yeti kɛ duwɛ yun mbɛy te yi mi wulma kɛte nɛ̀ mbɛy te yi mi kɛ̀ kɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wunɛ pɛ́si yun jɔsi nɛ nje te yi ɓomɔ. Yasi wɛtɛ, mi yeti kɛ pɛsɔ mbɛ jɔsi wɛtɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ŋgɛ ɓɛ nde, gba mi pɛ̂si jɔsi, pɛsina jɔsi mbɛ kɛ nje, kɛto mi yeti nyɛpɔ na, mi sinɛ Da, Mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","’Yo yeti kɛtinate kɛ gba mɛkana mɛ mɛmboŋga mun nde, ŋgɛ ɓomɔ yiɓa nje lɛpɔ ndi kiya yasi kɛ yasi te yi ɓo ɓɛŋma nɛ̀ yi ɓo wokuma kɛ́, lɛpi te gbakasi na? ");
INSERT INTO kkj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gba mi nɛ ŋguru wombɛ kɛ lɛpɔ yasi te yi mi duwa̧ kɛ kasi mbɛ. Sendi, Da, Mɔ te ɛ tomma mi kɔ kɛ lɛpɔ yasi te yi nyɛ duwa̧ kɛ kasi mbɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɛ ɓo nje diyɛ nyɛ nde: «Sɔŋgwɛ we?» Ɛ nyɛ yeŋsa nde: «Ko mi ko Saŋmbɛ, wunɛ yeti kɛ duwɛ mbaŋa na. Wunɛ má dukwɛ mi gbate, ma wunɛ duwa̧ sendi Saŋmbɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A lɛ́pi mɛyasi mɛnɔri kɛ mbanjɔ Njambiyɛ kɛ ŋgimɔ te yi nyɛ ɓa̧ kɛ teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kɛ mbɛy te yi ɓomɔ ɗiki nyɛ mɛyasi nɛ sadaka nyɛ Njambiyɛ kɛ́. Ko mumɔ wɛtɛ nɛ wɛtɛ tì nyɛ ɓɔ kɛ yotu nɛ na, kɛto ŋgimɔ nɛ tì pa ɗya̧ na. ");
INSERT INTO kkj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɛ nyɛ nje lɛpɔ sendi nyɛ ɓo nde: «Mi kɛ kwa̧ mbɛ, wunɛ ta sa̧ mi, wunɛ ta gwe ndi kɛ mɔy mɛɓeyɔ mun. Kɛ mbɛy te yi mi kɛ̀ mbɛ kɛte kɛ́, wunɛ ti yaka kɛ̀ yun mate na.» ");
INSERT INTO kkj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ɛ Ɓeyudɛn ɗiki lɛpɔ tandɛ yan nde: «Yiŋa nde: ‹Kɛ mbɛy te yi mi kɛ̀ mbɛ kɛte kɛ́, wunɛ ti yaka kɛ̀ yun mate na,› ’yite nde, a ta wo yotu nɛ nɛ ŋguru wenɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Wunɛ wúla yun kɛ mɛnɛti waka, ma mi mbɛ mɔ kwey. Wunɛ ɓotu ɓe mɛnɛti maka, mi yeti mbɛ mɔ mɛnɛti maka na. ");
INSERT INTO kkj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yori yi mi lɛpima nyɛ wunɛ nde, wunɛ ta gwe ndi kɛ mɔy mɛɓeyɔ mun kɛ́. Kɛto ŋgɛ wunɛ ti tikɛ temɔ nde, yo gba mi mɔ te yi mi lɛpɛ nɔ kɔ na, wunɛ ta gwe ndi kɛ mɔy mɛɓeyɔ mun.» ");
INSERT INTO kkj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɛ ɓo nje diyɛ nyɛ nde: «Wɛ yɔ ɓa nda?» Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ma mi lɛ̂pi sendi nde ŋge, ’yo yeti yasi te yi mi ɗiki lɛpɔ nyɛ wunɛ mɛtu hɛnɛ kɛ́ na? ");
INSERT INTO kkj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi nɛ ɓuɗya mɛyasi mɛte yi mi yakama lɛpɔ kɛ kasi yun, pɛsɔ sendi mɛlɛpi mɛte yi ɓɛŋɛ wunɛ. Yasi wɛtɛ, Mɔ te ɛ tomma mi njesɛ kɔ, yo Mɔ te ɛ lɛpɛ ndi gbakasi. Mɛyasi mɛte yi mi wokuma kɛ numbu nɛ kɛ́, yo ndi yite yi mi lɛpɛ mbɛ nyɛ ɓotu ɓe mɛnɛti maka.» ");
INSERT INTO kkj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓomɔ tì ɓɛ kɛ duwɛ nde, a lɛ́pi kasi Da nyɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɗete, ɛ Yesus lɛpɛ nyɛ ɓo nde: «Komɛ wunɛ ta si ŋgba *Mɔnɔ mumɔ kɛ jeti tɛmbiɗye kɛ kwey kɛ́, yo komɛte yi wunɛ ta nje duwɛ sendi nde, yo gba mi mɔ te yi mi lɛpɛ nɔ kɔ. Wunɛ má nje duwɛ yɛy nde, mi ti kél yaŋa nɛ ɗyanɔ te yembɛ na, yasi wɛtɛ, mi lɛ́pi mɛyasi mɛte yi Da teɗya mi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mi sinɛ mɔ te ɛ njesa mi kɔ. A tì tikɛ mi nyɛpɔ na, kɛto mi kɛ kelɔ yasi te yi nyɛ nyɛ mɛsosa kɛ́ mɛtu hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kɛ Yesus ma lɛpɔ ɗete kɛ́, ɛ ɓomɔ ɓuɗyate tikɛ temɔ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndana, ɛ nyɛ lɛpɛ nyɛ Ɓeyudɛn ɓete ɓe tikima temɔ nɛ nyɛ ɓaka nde: «Ŋgɛ wunɛ kɛ̀ mbɔmbu tikɔ temɔ kɛ mɛlɛpi mɛmbɛ mɛtu hɛnɛ, yite wunɛ gba ɓejekɛ ɓembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ɗete, wunɛ ta duwɛ lɛpi te yi lɛpɛ gbakasi. Lɛpi te má kelɔ nde, wunɛ ɗûkwɛ kɛ ɗiyɔ bala.» ");
INSERT INTO kkj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Wusɛ ɓenday ɓe Abaraham, ko wusɛ tì pa ɗiyɔ bala mumɔ wɛtɛ yesɔ na. Kɛto nan yi wɛ nje lɛpɔ nde, wusɛ ta ɗuwɛ kɛ gba ɗiyɔ bala nje ɗiyɔ nɛ yotu su nɛ ŋguru wusu kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mumɔ hɛnɛ ɛ joŋna kɛ mɛɓeyɔ, nyɛ bala mɛɓeyɔ. ");
INSERT INTO kkj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yo nde, bala ti ɗíy kpo nɛ kpo kɛ mɔy kandɔ na, yasi wɛtɛ, yo mɔnɔ kandɔ ɗiyɛ kpo nɛ kpo kɛ mɔy kandɔ. ");
INSERT INTO kkj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ŋgɛ ɓɛ nde, mi *Mɔnɔ mumɔ sôŋa wunɛ kɛ ɗiyɔ bala, yite wunɛ ta ɗuwɛ gbate kɛ ɗiyɔ bala nje ɗiyɔ nɛ yotu yun nɛ ŋguru wun. ");
INSERT INTO kkj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi duwa̧ nde, wunɛ ɓenday ɓe Abaraham, ko ɓɛkɔ ɗete, wunɛ kɛ sa̧ nje te yi wo mi, kɛto mɛlɛpi mɛmbɛ yeti kɛ nyiŋɛ kɛ mɔy mɛtemɔ mun na. ");
INSERT INTO kkj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi lɛ́pi mbɛ yasi te yi mi ɓɛŋma kɛ yi Saŋmbɛ kɛ́. Wunɛ kél ndi sendi yun mɛyasi mɛte yi wunɛ wokuma nɛ saŋgwɛ te wun kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɛ ɓo yeŋsa lɛpɔ nyɛ nyɛ nde: «Abaraham saŋmbambɔ wusu.» Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ má ɓɛki ɓenday ɓe Abaraham, ma wunɛ kɛ kelɔ mɛyasi nda nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma ndana, gba mi mɔ te ɛ lɛpima gbakasi nyɛ wunɛ kɛ mɛyasi mɛte yi mi wokuma kɛ numbu Njambiyɛ kɛ́, wunɛ kɛ sa̧ nje te yi wo mi. Yinɔri Abaraham tì kelɛ ɗete na. ");
INSERT INTO kkj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wunɛ kɛ kelɔ mɛkele mɛ saŋgwɛ wun.» Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Wusɛ yeti ɓɔnɔ ɓe wanja na. Wusɛ ndi nɛ saŋgwɛ wɛtɛ, yo Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Njambiyɛ má ɓɛki saŋgwɛ wun, ma wunɛ kɛ kwaɗyɛ mi, kɛto mi wúla kɛ yenɛ nje nɔ, mi nja̧ jakimɛ nyɛ, mi tì nje nɛ ɗeti te yembɛ na, yo nde, yo nyɛ tomɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ŋge ɓa nje kelɔ yi wunɛ ti wóku yun lɛpi te yi mi lɛpɛ kɛ́? Yo kɛto wunɛ yeti nɛ ɗeti te yi lɛŋgwɛ mɛtɔ wokɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gba saŋgwɛ wun *Kum ɓeya mɛkele. Ma wunɛ kɛ kwaɗyɛ kelɔ mɛyasi mɛte yi saŋgwɛ wun ɓɛ nɛ mɛsosa kɛte kɛ́. Nyɛ mɔ wona ɓomɔ kandɛ njombu yaŋa. A yeti nɛ kasi nɛ gbakasi na, kɛto gbakasi yeti kɛ nyɛ na. Komɛ nyɛ kelɛ ja̧ kɛ́, a lɛ́pi ndi yasi te yi pundɛ ndi kɛ mɔy temɔ nɛ, kɛto nyɛ mɔ ja̧, yo nyɛ bosa mɔ ja̧. ");
INSERT INTO kkj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yasi wɛtɛ, kɛ ɓɛ mi, wunɛ yeti kɛ tikɔ temɔ nɛ mi na, kɛto mi lɛ́pi yasi te yi ɓɛ gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nda kɛ njoka yun yakama teɗye nde, mi kelma yiŋa ɓeya yasi kɔ? Ma ŋgɛ ɓɛ nde, yasi te yi mi lɛpɛ kɛ́ gbakasi, kɛto ŋge yi wunɛ ti tíki temɔ nɛ mi kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mɔ te ɛ ɓɛ mɔ Njambiyɛ, mɔ te kɛ ɓiye to mɛlɛpi mɛ Njambiyɛ, yo nde, yi wunɛ ti ɓíya yun to te kɛ́, kɛto wunɛ yeti yun ɓotu ɓe Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ɛ Ɓeyudɛn yeŋsa nyɛ nyɛ nde: «Yi wusɛ lɛpima nde, wɛ gba *Mɔ Samari, wɛ sendi nɛ ɓeya sisiŋ kɛ yotu kɛ́, ’wusɛ kelma ja̧?» ");
INSERT INTO kkj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ɛ nyɛ yeŋsa nde: «Ko mi yeti mbɛ nɛ ɓeya sisiŋ kɛ yotu na, yo nde, mi lúksa Saŋmbɛ, ma wunɛ kɛ kpalɔ nje yɛliyɛ yun mi. ");
INSERT INTO kkj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yasi wɛtɛ, kɛ ɓɛ mi, mi ti sáŋ nde, ɓomɔ lûksa mi na. Yo nɛ wɛtɛ mumɔ te ɛ sa̧ nde, ɓomɔ lûksa mi, yo nyɛ kɛ pɛsɔ jɔsi ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mumɔ ɓakiɗye mɛlɛpi mɛmbɛ, ko a tí gwe na.» ");
INSERT INTO kkj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ɛ Ɓeyudɛn nje lɛpɔ nyɛ nyɛ nde: «Hɛ duwa̧ ndana yɛy nde, wɛ nɛ ɓeya sisiŋ kɛ yotu. Abaraham gwa̧, ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ma gwe sendi, ma ŋge nje kelɔ yi wɛ lɛpɛ nde: ‹Ŋgɛ mumɔ ɓakiɗye mɛlɛpi mɛmbɛ, ko a tí gwe› kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wɛ táka nde, wɛ kwa̧ saŋmbambɔ wusu Abaraham ɛ gwa̧ kɔ nde? Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ma gwe sendi, wɛ táka yɔ nde, wɛ ɓa nda?» ");
INSERT INTO kkj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ɛ nyɛ yeŋsa nde: «Ŋgɛ gba mi nɛ ŋguru wombɛ lukse yotu mbɛ, luksa yotu te yite gbɛlate. Yo Saŋmbɛ te yi wunɛ lɛpɛ nde, nyɛ Njambiyɛ wun kɔ, yo nyɛ kɛ lukse mi. ");
INSERT INTO kkj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yasi wɛtɛ, wunɛ yeti kɛ duwɛ nyɛ na. Kɛ ɓɛ mi, mi kɛ duwɛ nyɛ. Ŋgɛ mi lɛpɛ nde, mi yeti kɛ duwɛ nyɛ na, yite mi mɛ mɔ ja̧ nda wunɛ. Yo nde, mi duwa̧ nyɛ, ɓakiɗye sendi mɛlɛpi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Saŋmbambɔ wun Abaraham ɗikima takɛ nde, a ta ɓɛŋɛ ŋgimɔ te yi mi ta nje kɛte kɛ́, ɛ nyɛ wokɛ mɛsosa ɓuɗyate. Kumɔ kɛ́, ɛ nyɛ ɓɛŋɛ ŋgimɔ te gbate, ɛ nyɛ sosa.» ");
INSERT INTO kkj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ɛ Ɓeyudɛn lɛpɛ nyɛ nyɛ nde: «Wɛ tì pa kumɔ gbɛla mɛsew kamɔtan na, ’wɛ nde, wɛ ɓɛŋma Abaraham nde?» ");
INSERT INTO kkj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Piŋɔ te yi ɓo tì pa ja Abaraham na, mi mɛ mbɛ kɛte.» ");
INSERT INTO kkj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ndana, ɛ ɓo tɔkɛ mɛtari, nɛ́ ɓo lu̧ nɛ nyɛ. Yasi wɛtɛ, ɛ nyɛ sɔma kwa̧ pundɔ kɛ mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ndana, kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ tɔkɛ nje kwa̧ nɔ kɛ́, ɛ nyɛ ɓɛŋɛ wɛtɛ mbam te ɛ jaɗya ndi nɛ ɗiɓina misi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɛ ɓejekɛ ɓenɛ diyɛ nyɛ nde: «Yekele, kɛto ŋge yi mbam kɔ jaɗya nɛ ɗiɓina misi kɛ́? ’Yo kɛto yiŋa ɓeya mɛkele mɛnɛ nɛ ŋguru wenɛ ho kɛto yiŋa ɓeya mɛkele mɛ saŋgwɛ ɓenɛ nyaŋgwɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ɛ Yesus yeŋsa nde: «Yeti nde, nyɛ ho saŋgwɛ ɓenɛ nyaŋgwɛ kelma yiŋa ɓeya mɛkele na. Yo nde, a jáɗyikwɛ nɛ ɗiɓina misi, nɛ́ Njambiyɛ punjɛ nyaŋgwɛ mɛkele mɛnɛ kɛ yotu nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kɛ ŋgimɔ te yi yesɔ ndi kɛte kɛ́, wusɛ yâkaŋgwɛ kelɔ mɛsay mɛ mɔ te ɛ tomma mi kɔ. Tu mɛ kɛ nje, ŋgimɔ te yi mumɔ ti yaka kelɔ se mɛsay na. ");
INSERT INTO kkj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Piŋɔ te yi mi ndi kɛ mɛnɛti maka, mi mbɛ mɛjasi te yi paniyɛ puyɛ nyɛ ɓotu ɓe mɛnɛti.» ");
INSERT INTO kkj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ sa mɛsɛri kɛ mɛnɛti ɓulɔ yo nɛ mɛsɛri lɔmbɛ kɛ misi mɛ mɔ ɗiɓina misi ");
INSERT INTO kkj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","lɛpɔ nyɛ nyɛ nde: «Kɛndɔ kɛ weyɛ misi mɔ kɛ Silɔy.» To Silɔy nde Mɔ te yi ɓo tomma nyɛ kɔ. Ɛ nyɛ tɛmɛ kwa̧ kɛ̀ weyɛ misi. A yɔkwa̧ mate, a mɛ kɛ ɓɛŋɛ yasi nɛ ŋgɛlɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndana, ɛ ɓotu ɓete ɓe ɗikima ɗiyɔ wɛtɛ ɓenɛ mbam kɔ nɛ̀ ɓotu ɓete ɓe ɗikima ɓɛŋɛ nyɛ kɛ jɔmbɔ mɛyasi ɓaka lɛpɛ nde: «’Yeti gba mbam kɔ ɛ ɗikima ɗiyɔ mɛtiɗyɛ ɗiki jɔmbɔ mɛyasi kɔ na?» ");
INSERT INTO kkj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɛ ɓaŋa ɗiki lɛpɔ nde: «Yo nyɛ.» Ɓaŋa nde: «Ja̧, ɓenɛ nyɛ ɓóŋnaŋgwɛ ɓoŋnaŋgwɛ.» Ɛ nyɛ nɛ ŋguru wenɛ lɛpɛ nde: «Yo gba mi kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɛ ɓo nje diyɛ nyɛ nde: «Yo kwaŋnama nan yi misi mɔ ɓutunama nɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɛ nyɛ yeŋsa nde: «Wɛtɛ mbam nde Yesus ɓulma mɛnɛti lɔmbɛ kɛ misi mɛmbɛ nje lɛpɔ nyɛ mi nde: ‹Kɛn kɛ Silɔy kɛ̀ weyɛ misi mɔ.› Mi ka̧. Kɛ mi ma si weyɛ misi mɛmbɛ kɛ́, ɛ mi kandɛ ɓɛŋna yasi.» ");
INSERT INTO kkj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɛ ɓo diyɛ nyɛ nde: «Mbam te we?» Ɛ nyɛ yeŋsa nde: «Mi ti duwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndana, ɛ ɓo ɓu̧ mɔ te ɛ ɓa̧ mbɔmbu nɛ ɗiɓina misi kɔ kɛ̀ nɔ kɛ yi *Ɓefarisɛ̧. ");
INSERT INTO kkj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yasi yinɔri Yesus ɓúl mɛnɛti ɓutɛ nɛ misi mɛ mbam kɔ kɛ yesɔ *Saba. ");
INSERT INTO kkj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yori yi Ɓefarisɛ̧ diyma sendi mbam kɔ yasi te yi kwaŋnama yi kelɔ nde, a ɓɛ̂ŋnaŋgwɛ ndana kɛ́. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «A lɔmbuma mɛsɔpɔ kɛ misi mɛmbɛ, ɛ mi kwa̧ kɛ̀ weyɛ misi, ma ndana mi kɛ ɓɛŋɛ yasi.» ");
INSERT INTO kkj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ɛ ɓaŋa Ɓefarisɛ̧ ɗiki lɛpɔ nde: «Yeti Njambiyɛ njesɛ nyɛ na, kɛto a yeti kɛ jesɔ mboŋga te ɛ lɛpɛ kasi Saba kɛ́ na.» Ɓaŋa ɗikima lɛpɔ yan nde: «’Mɔ mɛɓeyɔ yakama kelɔ ka kwalɔ mɛyekambiyɛ mɛte yikɛ yi nyɛ kelma kɛ́?» Ɛ ɓo ɓaka kɛ ɓembe. ");
INSERT INTO kkj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɛ ɓo nje kwa̧ sendi wolo diyɛ mɔ te ɛ ɓa̧ mbɔmbu nɛ ɗiɓina misi kɔ nde: «Wɛ lɛ́pi yɔ nɛ ŋge kɛ kasi mbam te? Wɛ lɛ́pi nɛ ŋge kɛ say te yi nyɛ kelma ɓutɛ nɛ misi mɔ kɛ́?» Ɛ nyɛ yeŋsa nde: «Nyɛ mɔ punja mɛlɛpi mɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ko ɓekum Ɓeyudɛn tì kwaɗyɛ jayɛ nde, mbam kɔ ɓa̧ mbɔmbu nɛ ɗiɓina misi, jayɛ sendi nde, a njáki nje ɓɛŋna ndana na. Ɗete, ɛ ɓo jeɓa saŋgwɛ ɓenɛ nyaŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɛ *Ɓefarisɛ̧ diyɛ ɓo nde: «Yɔkɔ mɔnɔ wun yi wunɛ lɛpɛ nde, a jaɗya nɛ ɗiɓina misi kɔ? Yo kwaŋnama nan yi nyɛ mɛ kɛ ɓɛŋɛ yasi ndana kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ɛ ɓo yeŋsa nde: «Wusɛ kɛ duwɛ nde, yɔkɔ mɔnɔ wusu, duwɛ sendi nde, a jaɗya nɛ ɗiɓina misi. ");
INSERT INTO kkj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ndi nde, yí lɛpɔ nɛ yasi te yi kwaŋnama nde, a ɓɛ̂ŋnaŋgwɛ ndana nɛ̀ mɔ te ɛ ɓutuma misi mɛnɛ kɔ, wusɛ yeti kɛ duwɛ yaŋa kɛte na. A mɛ mumɔ, wunɛ dîya ndi nyɛ, nyɛ nɛ ŋguru wenɛ ta yeŋsa nyɛ wunɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Saŋgwɛ ɓenɛ nyaŋgwɛ yéŋsaŋgwɛ ɗete, kɛto ɓo ɓa̧ kɛ kambɔ ɓekum Ɓeyudɛn, kɛto ɓekum Ɓeyudɛn ma nyɛ ŋgiŋ nde, ŋgɛ mumɔ jayɛ kɛ mbɔmbu ɓomɔ nde, Yesus nyɛ *Krist, ko mɔ te tí natɛ se mbanjɔ mɛwesiɗya man wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yo kɛto te yite yi saŋgwɛ ɓenɛ nyaŋgwɛ lɛpima nde: ‹A mɛ mumɔ, wunɛ dîya ndi nyɛ› kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ɗete, ɛ *Ɓefarisɛ̧ ɓasiɗye jeɓa mbam kɔ lɛpɔ nyɛ nyɛ nde: «Lɛpɔ gbakasi nyɛ wusɛ kɛ mbɔmbu Njambiyɛ. Hɛ duwa̧ nde, mbam te mɔ mɛɓeyɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɛ nyɛ nje yeŋsa nde: «Ŋgɛ ɓɛ nde, nyɛ mɔ mɛɓeyɔ, mi yeti kɛ duwɛ na, siya yasi te yi mi duwa̧, yo nde, mi tì ɓɛ kɛ ɓɛŋɛ yasi nɛ mbɔmbu na, ma ndana mi mɛ kɛ ɓɛŋɛ yasi.» ");
INSERT INTO kkj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɛ ɓo diyɛ nyɛ nde: «A kelma yasi te nda kɛ yotu yɔ? A kelma nan ɓutɛ nɛ misi mɔ?» ");
INSERT INTO kkj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Mi ma si lɛpɔ yasi te yi kwaŋnama kɛ́ nyɛ wunɛ, ma wunɛ tì kwaɗyɛ wokɔ na. ’Wunɛ kwáɗyikwɛ nde, mi kâlaŋgwɛ yekiɗye sendi nyɛ wunɛ kɛto ŋge? ’Wunɛ sendi kɛ kwaɗyɛ nje ɓɛ ɓejekɛ ɓenɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɛ ɓo toyɛ nyɛ lɛpɔ nde: «Yo gba wɛ ɓɛ jekɛ wenɛ, kɛ ɓɛ wusɛ, wusɛ su ɓejekɛ ɓe Mɔyisi. ");
INSERT INTO kkj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wusɛ duwa̧ su nde, Njambiyɛ lɛpinama nyɛ Mɔyisi. Ma kɛ ɓɛ mbam te yɔkɔ, ho a wúla we nje nɔ, wusɛ yeti kɛ duwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɛ mbam te ɛ ɓa̧ mbɔmbu nɛ ɗiɓina misi kɔ yeŋsa nyɛ ɓo nde: «Yo gba yasi te yi ŋgbakima yí wokɔ nde, ho a wúla we nje nɔ, wunɛ yeti kɛ duwɛ na, ma yo nyɛ ɓutɛ misi mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wusɛ duwa̧ nde, Njambiyɛ ti jáya mɛŋgwɛta mɛ ɓotu mɛɓeyɔ na. Yasi wɛtɛ, a jáya mɛŋgwɛta mɛ mɔ te ɛ kanɛ nyɛ tu nɛ yesɔ, kelɔ yasi te yi nyɛ Njambiyɛ kwaɗyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kandɛ nɛ ɓetomba mumɔ wɛtɛ nɛ wɛtɛ tì pa wokɔ wɛtɛ yesɔ nde, wɛtɛ mumɔ ɓutuma misi mɛ mɔ te ɛ jaɗya nɛ ɗiɓina misi kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Má ɓɛki nde, yeti Njambiyɛ tomɛ mbam te njesɛ na, ma nyɛ tì kelɛ yaŋa na.» ");
INSERT INTO kkj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɛ ɓo yeŋsa lɛpɔ nyɛ nyɛ nde: «Kandɛ yi ɓo ma jáki nɛ wɛ kumɔ ndana wɛ kɛ mɔy mɛɓeyɔ nɛ pitik, yasi te nda yi wɛ ta teɗye wusɛ kɛ́?» Ɛ ɓo ɗuɗye nyɛ punjɛ kɛnjɛ sɛ̧. ");
INSERT INTO kkj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus wokuma nde, ɓo ɗuɗya mbam te ɛ ɓa̧ mbɔmbu nɛ ɗiɓina misi kɔ. Ɛ Yesus saŋgwa nɛ nyɛ kwa̧ diyɛ nyɛ nde: «’Wɛ kɛ tikɔ temɔ kɛ yi *Mɔnɔ mumɔ?» ");
INSERT INTO kkj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɛ nyɛ yeŋsa nde: «Nyaŋgwɛ mbam, Mɔnɔ mumɔ te mbɛte ɓa nda? Lɛpɔ, nɛ́ mi tiki temɔ nɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ ma ɓɛŋɛ nyɛ, yo gba nyɛ ɛ kɛ lɛpina ndana nyɛ wɛ kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɛ mbam lɛpɛ nde: «Nyaŋgwɛ mbam, mi kɛ tikɔ temɔ nɛ nyɛ.» Ɛ nyɛ kwa̧ kusɛ mɛɓɔŋ kɛ mbɔmbu Yesus kanɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ɛ Yesus nje lɛpɔ nde: «Mi nja̧ kɛ mɛnɛti maka, nɛ́ jɔsi ɓɛ kɛte, nɛ́ ɓotu ɓete ɓe yeti kɛ ɓɛŋɛ yasi ɓaka ɓɛŋ yasi, nɛ́ ɓotu ɓete ɓe kɛ ɓɛŋɛ yasi ɓaka nje ɓɛ nɛ ɗiɓina misi.» ");
INSERT INTO kkj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kɛ ɓaŋa *Ɓefarisɛ̧ ɓete ɓe ɓa̧ ɓenɛ ɓe Yesus ɓaka ma wokɔ ɗete kɛ́, ɛ ɓo diyɛ nyɛ nde: «’Yite nde, wusɛ sendi, misi musu ɗiɓinate?» ");
INSERT INTO kkj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Misi mun má ɓɛki ɗiɓinate, ma wunɛ yeti nɛ mɛɓeyɔ na. Yasi wɛtɛ, wunɛ kɛ lɛpɔ ndana nde: ‹Wusɛ kɛ ɓɛŋɛ yasi kimɔte,› ɗete mɛɓeyɔ mun ta ɗiyɔ ɓɔnɛ kɛ to yun.» ");
INSERT INTO kkj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus nja̧ kɛ mbɔmbu lɛpɔ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: «Mɔ te ɛ ɗiyɛ kinɛ kwa̧ nɛ numɛy kakwɛ ɓesam yí nyiŋɛ nɔ kɛ mɔyte na, ŋgɛ nyɛ kpalɔ kwa̧ nɛ wɛtɛ nje dɛlɛ, mɔ te mɔ guɓɔ, nyɛ nyaŋgwɛ mɔ kelna ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yo nde, mɔ te ɛ kwa̧ nɛ numɛy nyiŋɛ nɔ kɛ mɔy kakwɛ, mɔ te mɔ ɓakiɗya ɓesam. ");
INSERT INTO kkj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sanjele te ɛ ɗiyɛ kɛ numɛy kakwɛ kɔ ɓúta numɛy nyɛ nyɛ, wɛ ɓɛ́ŋa kɛ́, ɓesam kɛ wokɔ mɛn nɛ. A má jeɓa ɓo wɛtɛ wɛtɛ nɛ ɗinɔ ɗyan ŋgbɔsɔ ɓo pundɔ nɔ. ");
INSERT INTO kkj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ŋgɛ nyɛ si punjɛ ɓesam ɓenɛ hɛnɛ ɗete kɛ́, a ma kwa̧ mbɔmbu, ɓo kɛ kɔŋ nɛ, kɛto ɓo kɛ duwɛ mɛn nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yasi wɛtɛ, ko ɓo yeti nɛ ɗeti te yi ɓeŋgwɛ gbɛla mumɔ na, ɓo ta kambɔ nyɛ lɔndɔ kɛ̀ nɛ naŋ, kɛto ɓo yeti kɛ duwɛ mɛn gbɛla ɓomɔ na.» ");
INSERT INTO kkj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus lɛpinama nɛ nje kanɔ ɗete nyɛ ɓo, yasi wɛtɛ, ɓo tì ɓiye to yasi te yi nyɛ lɛpima nyɛ ɓo kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛ Yesus nje lɛpɔ sendi nyɛ ɓo nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mi mbɛ numɛy te yi ɓesam kwa̧ kɛte yí nyiŋɛ nɔ kɛ mɔy kakwɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓomɔ hɛnɛ ɓe kandima nje nɛ mi ɓaka ɓotu ɓe guɓɔ, ɓo ɓotu ɓe nyaŋgwɛ kelna ɓeya mɛkele. Yasi wɛtɛ, ɓesam tì lɛŋgwɛ mɛtɔ kɛ mɛn yan na. ");
INSERT INTO kkj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi mbɛ numɛy, ŋgɛ mumɔ nyiŋɛ nɛ nje te wombɛ, a ta ju̧. A ta nyiŋɛ pundɔ dolɔ mɛɗye te yi ɗye. ");
INSERT INTO kkj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Siya yasi te yi mɔ guɓɔ nje kelɔ, yo ndi guɓuna yasi, ndi wonate nɛ̀ girisate. Mi nja̧ mbɛ, nɛ́ ɓesam ɓɛ nɛ joŋgwɛ, nɛ́ ɓo joŋna kɛ mɔy nyɛŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mi mbɛ kimɔ mɔ ɓakiɗya ɓesam. Kimɔ mɔ ɓakiɗya ɓesam nyɛ́ki joŋgwɛ ɗyenɛ kɛto ɓesam ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yasi wɛtɛ, mɔ te ɛ nje ɓakiɗye ɓesam kɛto mɔni kɔ yeti gba mɔ ɓakiɗya ɓesam na, kɛto ɓesam yeti ɓesam ɓenɛ na. Ŋgɛ nyɛ ɓɛŋɛ ŋgwɛy kɛ nje, wɛ ɓɛ́ŋa, a tikima ɓesam sɛɗyɛ kwa̧, ŋgwɛy má ɗya̧ ɓiye ɓaŋa, ɓari ma si wanja kwa̧. ");
INSERT INTO kkj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mɔ te ɛ nje ɓakiɗye ɓesam kɛto mɔni kɔ sɛ́ɗyikwɛ kwa̧, kɛto yo ndi kɛto mɔni yi nyɛ ɓakiɗye ɓesam, yeti kasi nɛ nɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mi mbɛ kimɔ mɔ ɓakiɗya ɓesam. Mi kɛ duwɛ ɓesam ɓembɛ, ɓesam ɓembɛ kɛ duwɛ sendi mi. ");
INSERT INTO kkj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Yo sendi ɗete nda yi Da kɛ duwɛ mi, mi sendi kɛ duwɛ nyɛ. Mi kɛ nyɛ joŋgwɛ ɗyembɛ kɛto ɓesam ɓembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi nɛ ɓaŋa ɓesam ɓembɛ ɓe yeti kɛ mɔy kakwɛ te yikɛ na. Mi yâkaŋgwɛ ŋgbɔsɔ sendi ɓo nje nɔ. Ɓo ta wokɔ mɛn mbɛ, ɓo má nje ɓɛ ndi kuru ɓesam wɛtɛ nɛ̀ mɔ ɓakiɗya yan wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Da kwáɗyikwɛ mi, yo kɛto mi kɛ nyɛ joŋgwɛ ɗyembɛ yí laɗye ɓu̧ sendi yo nɛ kɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ɛ yakama pɛsɔ joŋgwɛ ɗyembɛ na. Yasi wɛtɛ, yo mi nɛ ŋguru wombɛ kɛ nyɛ joŋgwɛ ɗyembɛ. Mi nɛ ɗeti te yi nyɛ joŋgwɛ ɗyembɛ, mi sendi nɛ ɗeti te yi ɓu̧ yo nɛ kɔkɔ. Yo Saŋmbɛ lɛpɛ nde, mi kêl ɗete.» ");
INSERT INTO kkj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɛ mɛlɛpi mɛnɔri kelɛ nde, Ɓeyudɛn ɓâkaŋgwɛ sendi wolo kɛ ɓembe. ");
INSERT INTO kkj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɛ ɓuɗya ɓomɔ kɛ njokate lɛpɛ nde: «A nɛ ɓeya sisiŋ kɛ yotu, a kɛ kɔnɔ nɛ ɓoku. Kɛto ŋge yi wunɛ lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ lɛpɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɛ ɓaŋa lɛpɛ yan nde: «Mɔ te ɛ nɛ ɓeya sisiŋ kɛ yotu kɔ ti lɛ́pinaŋgwɛ ɗekɛ na. ’Ɓeya sisiŋ nɛ ɗeti te yi kelɔ nde, mɔ ɗiɓina misi ɓɛ̂ŋnaŋgwɛ nde?» ");
INSERT INTO kkj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɓo ɓa̧ kɛ kelɔ jesɔ yí takɛ nɛ yesɔ te yi ɓo kaŋma nɛ mbanjɔ Njambiyɛ te ɛ Yerusalɛm nyɛ Njambiyɛ kɛ́. Yo ɓa̧ kɛ ŋgimɔ abekata. ");
INSERT INTO kkj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus ɓa̧ kɛ yombila kɛ mɔy mbanjɔ Njambiyɛ kɛ mbɛy te yi ɓo ɗikima jeɓa nde Nje Salomɔŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndana, ɛ Ɓeyudɛn nje litɔ nyɛ lɛpɔ nyɛ nyɛ nde: «’Wɛ kwáɗyikwɛ nde, wusɛ ɗîy nɛ mɛso kɛ temɔ kumɔ kɛ ŋgimɔ te yin? Ŋgɛ ɓɛ nde, yo wɛ *Krist, lɛpɔ nɛ saŋsaŋ nyɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Mi ma si lɛpɔ nyɛ wunɛ, ma wunɛ yeti kɛ tikɔ temɔ kɛ mɛlɛpi mɛte na. Mɛkele mɛte yi Saŋmbɛ nyɛ mi ɗeti nde, mi kêl kɛ́ kɛ teɗye mi nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yasi wɛtɛ, wunɛ yeti kɛ tikɔ yun temɔ kɛ yembɛ na, kɛto wunɛ yeti kɛ njoka ɓesam ɓembɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɓesam ɓembɛ kɛ wokɔ mɛn mbɛ, mi kɛ duwɛ mbɛ ɓo, ɓo kɛ ɓeŋgwɛ sendi mi. ");
INSERT INTO kkj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi kɛ nyɛ mbɛ ɓo joŋgwɛ te yi kpo nɛ kpo, ko ɓo tí gwe yambile na. Sendi, ko mumɔ wɛtɛ nɛ wɛtɛ tí sukɔ ɓo kɛ mɛɓɔ mɛmbɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Saŋmbɛ, mɔ te ɛ nya mi ɓo kɔ kwa̧ ɓomɔ hɛnɛ, ko mumɔ wɛtɛ nɛ wɛtɛ yeti nɛ ɗeti te yi sukɔ ɓo kɛ mɛɓɔ mɛ Da na. ");
INSERT INTO kkj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sinɛ Da ndi kiya yasi wɛtɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ndana, ɛ Ɓeyudɛn tɔkɛ sendi mɛtari wolo, nɛ́ ɓo lu̧ nɛ nyɛ wo. ");
INSERT INTO kkj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Mi kelma ɓuɗya kimɔ mɛkele mɛte yi Da lɛpima nde, mi kêl kɛ́ kɛ misi mun, ma kɛ njoka mɛkele mɛte, wunɛ kwáɗyikwɛ lu̧ mi nɛ mɛtari wo kɛto mɛkele te yɛn?» ");
INSERT INTO kkj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Wusɛ ti kwáɗyikwɛ lu̧ wɛ nɛ mɛtari wo kɛto wɛtɛ kimɔ mɛkele na, yasi wɛtɛ, wusɛ kwáɗyikwɛ lu̧ wɛ nɛ mɛtari wo, kɛto wɛ kɛ gbutɔ nɛ Njambiyɛ, kɛto gbɛla wɛ mumɔ kɛ kpalɔ lɛpɔ nde, wɛ Njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ɛ Yesus yeŋsa nyɛ ɓo nde: «’Yo yeti gba kɛtinate kɛ mɛkana mɛ mɛmboŋga mun nde: ‹Njambiyɛ lɛpima nde: Wunɛ ɓenjambiyɛ na?› ");
INSERT INTO kkj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wusɛ duwa̧ nde, mumɔ ti yaka soŋɛ yasi te yi yo ma ɓɛ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ na. Ma ŋgɛ Njambiyɛ jeɓa ɓotu ɓete ɓe mɛlɛpi mɛnɛ lɛpinama nyɛ ɓo ɓaka nde ɓenjambiyɛ, ");
INSERT INTO kkj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kɛto ŋge yi wunɛ nje lɛpɔ gba nɛ mi mɔ te ɛ Da tɔkuma tomɔ njesɛ kɛ mɛnɛti maka kɔ nde, mi kɛ gbutɔ nɛ nyɛ, kɛto mi lɛpima nde, mi Mɔnɔ wenɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ŋgɛ mi ɗiyɛ kinɛ kelɔ mɛkele mɛ Saŋmbɛ na, komɛte, wunɛ tî tiki temɔ nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yasi wɛtɛ, ŋgɛ ɓɛ nde, mi kɛ kelɔ mɛkele mɛ Saŋmbɛ, ko ɓɛkɔ nde, wunɛ tì tikɛ temɔ nɛ mi na, wunɛ yêkiɗya tikɔ temɔ kɛ mɛkele mɛte yi mi kelɛ kɛ́, nɛ́ wunɛ duwɛ kimɔte kɛ̀ nɔ mbɔmbu nde, Da kɛ yembɛ, mi sendi kɛ yenɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ndana, ɛ ɓo kala sa̧ nje te yi ɓiye nyɛ, yasi wɛtɛ, ɛ nyɛ bɔla kwa̧. ");
INSERT INTO kkj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɛ nyɛ ɗuwɛ nɛ kɔkɔ kɛ̀ kɛ ŋginjɛ Yurdɛ̧, kɛ mbɛy te yi Jaŋ ma kánda tɔpuna ɓomɔ kɛ mɔrɔku kɛte kɛ́. Ɛ nyɛ kwa̧ ɗiyɔ mate. ");
INSERT INTO kkj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɛ ɓomɔ ɓuɗyate nje kɛ yenɛ. Ɛ ɓo ɗiki lɛpɔ nde: «Jaŋ tì kelɛ ko mɛyekambiyɛ wɛtɛ nɛ wɛtɛ na, yasi wɛtɛ, yasi hɛnɛ te yi nyɛ lɛpima kɛ kasi mbam kɔ kɛ́, gbakasi.» ");
INSERT INTO kkj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɛ ɓomɔ ɓuɗyate tikɛ temɔ kɛ yi Yesus kɛ mbɛy yinɔri. ");
INSERT INTO kkj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wɛtɛ mbam nde Lasar ɓalma nɛ kɔn. A ɓa̧ mɔ Betani, ɗya Mariya ɓenɛ maŋ wenɛ Marta. ");
INSERT INTO kkj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yo ɓa̧ Mariya te ɛ lɔmbuma lɔbinda kɛ mɛkol mɛ Kumande Yesus titɔ yo nɛ nyiŋɔ to nɛ kɔ. Yo ɗyɔmbu ɗyenɛ Lasar kɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ɛ ɓeɗyɔmbu ɓenɛ ɓaka yiɓa tomɛ mumɔ kɛ̀ lɛpɔ nyɛ Yesus nde: «Nyaŋgwɛ Kumande ɓɛŋa, sɔŋ temɔ wɔ kɛ kɔnɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kɛ Yesus ma wokɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nde: «Kɔn te yeti kɔn sɔŋ na, yasi wɛtɛ, yo kɔn te yi Njambiyɛ ta teɗye nyaŋgwɛ ɗeti mɛluksa mɛnɛ, nɛ́ Mɔnɔ wenɛ ɓɛ nɛ mɛluksa kɛ kɔn te.» ");
INSERT INTO kkj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Temɔ Yesus ɓa̧ kɛ yotu Marta ɓenɛ maŋ ɓu̧ ɗyɔmbu ɗyan Lasar. ");
INSERT INTO kkj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kɛ nyɛ ma si wokɔ kasi kɔn Lasar kɛ́, ɛ nyɛ nje kwaŋɗye sendi mɛtu yiɓa ndi kɛ mbɛy te komɛ nyɛ ɓa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kɛ kɔŋte, ɛ nyɛ lɛpɛ nyɛ ɓejekɛ ɓenɛ nde: «Wusɛ yɔ̂kwɛ nɛ kɔkɔ kɛ̀ Yuda.» ");
INSERT INTO kkj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɛ ɓejekɛ lɛpɛ nyɛ nyɛ nde: «Yekele, kɔŋte tì pa kikɔ na, Ɓeyudɛn kwaɗya lu̧ wɛ nɛ mɛtari wo, ma ndana ’wɛ kɛ kwaɗyɛ yɔkwɛ nɛ kɔkɔ kɛ̀ sendi mate nde?» ");
INSERT INTO kkj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɛ nyɛ yeŋsa nde: «’Yesɔ wɛtɛ yeti nɛ hawa kamɔ jɔ yiɓa na? Ŋgɛ mumɔ kɛndɛ nɛ yesɔ, a yeti kɛ ɓomiyɛ ɓaki na, kɛto a kɛ ɓɛŋɛ mɛjasi mɛ yesɔ. ");
INSERT INTO kkj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma yasi wɛtɛ, ŋgɛ mumɔ kɛndɛ nɛ tu, a kɛ ɓomiyɛ ɓaki, kɛto a kinɛ mɛjasi kɛ yotu nɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ nje lɛpɔ nyɛ ɓo nde: «Sɔ wusu Lasar kɛ jakɔ, yasi wɛtɛ, mi ta kɛ̀ jemɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɛ ɓejekɛ lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ŋgɛ ɓɛ nde, a kɛ jakɔ, yotu nɛ ta ŋgbanjɔ lalɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yasi yinɔri Yesus lɛ́pi nɛ kasi sɔŋ Lasar. Yasi wɛtɛ, kɛ yan, ɓo takima yan nde, a lɛ́pi nɛ gbɛla jakɔ. ");
INSERT INTO kkj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɗete, ɛ Yesus nje lɛpɔ nɛ gbas gbas nyɛ ɓo nde: «Lasar ma gwe. ");
INSERT INTO kkj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma ŋgɛ mi ɓɛŋɛ wunɛ ɗekɛ kɛ́, mi nɛ mɛsosa, kɛto mi tì ɓɛ kɛ mbɛy te na. Ɗete, wunɛ ta nje tikɔ temɔ nɛ mi. Yasi wɛtɛ, hɛ kɛ̂n mate.» ");
INSERT INTO kkj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ndana, ɛ Tomasi te yi ɓo ɗikima jeɓa sendi nde Ɓeadan kɔ lɛpɛ nyɛ njɔŋ nɛ nde: «Wusɛ sendi, hɛ kɛ̂n mate, nɛ́ sinɛ ɓe Nyaŋgwɛ Kumande kɛ̀ gwe mate.» ");
INSERT INTO kkj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kɛ Yesus ma ɗya̧ kɛ́, a njáki dolɔ nde, yo mɛ mɛtu yini yi ɓo pumbuma nɛ Lasar kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ɓa̧ kɛ kɛki Yerusalɛm, njokate tì kumɛ kilomɛta yitati na. ");
INSERT INTO kkj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ɗete, ɛ Ɓeyudɛn ɓuɗyate nje ɓɛŋɛ Marta ɓenɛ Mariya kɛ sɔŋ ɗyɔmbu ɗyan yí nyɛ ɓo mɛŋgitɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ndana, kɛ Marta ma wokɔ nde, Yesus kɛ nje kɛ́, ɛ nyɛ kwa̧ kɛ̀ saŋgwa nɛ nyɛ, ɛ Mariya ɗiyɛ nɛ kɛ tu̧. ");
INSERT INTO kkj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ɛ Marta lɛpɛ nyɛ Yesus nde: «Nyaŋgwɛ Kumande, wɛ má ɓɛki waka, ma ɗyɔmbu ɗyembɛ tì gwe na. ");
INSERT INTO kkj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yasi wɛtɛ, mi duwa̧ nde, ko ndana yasi hɛnɛ te yi wɛ ta diyɛ Njambiyɛ, a ta nyɛ wɛ yo.» ");
INSERT INTO kkj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɗyɔmbu ɗyɔ ta womiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ɛ Marta yeŋsa nyɛ nyɛ nde: «Mi duwa̧ nde, a ta womiyɛ komɛ ɓemuŋ ta womiyɛ nɔ kɛ njena yesɔ siyna mbokɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Mi mbɛ mɔ womiya ɓemuŋ, mi sendi joŋgwɛ. Mɔ te ɛ tikɛ temɔ nɛ mi, mɔ te ta ju̧, ko ɓɛkɔ nde, a gwâki. ");
INSERT INTO kkj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sendi, mumɔ hɛnɛ ɛ joŋna tikɔ temɔ nɛ mi, ko mɔ te tí gwe na. ’Wɛ kɛ tikɔ temɔ kɛ lɛpi te nde?» ");
INSERT INTO kkj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɛ Marta yeŋsa nyɛ nyɛ nde: «I̧, Nyaŋgwɛ Kumande. Mi ma tikɔ temɔ nde, wɛ *Krist, Mɔnɔ Njambiyɛ, yɔkɔ yi ɓa̧ nde, a yâkaŋgwɛ nje kɛ mɛnɛti maka kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ kwa̧ mbɔmbila kɛ̀ lɛpɔ nyɛ maŋ wenɛ Mariya nde: «Yekele ma ɗya̧, a kɛ jeɓa wɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kɛ Mariya ma wokɔ ndi ɗete kɛ́, ɛ nyɛ tɛmɛ nɛ ŋgɛt kwa̧ kɛ̀ pɛ yi Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yinɔri Yesus tì pa nyiŋɛ mɔy ɗya na, a ɓa̧ ndi kɛ mbɛy te yi Marta ka̧ saŋgwa nɛ nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndana, kɛ Ɓeyudɛn ɓete ɓe ɓa̧ ɓenɛ ɓe Mariya kɛ tu̧ kɛ nyɛna nyɛ mɛŋgitɛ ɓaka ma ɓɛŋɛ nde, a tɛmma nɛ ŋgɛt pundɔ kɛ́, ɛ ɓo ɓeŋgwɛ nyɛ, takɛ nde, a kɛ́n kɛ ɓoŋsɔŋ kɛ̀ lelɔ. ");
INSERT INTO kkj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kɛ Mariya ma kumɔ kɛ mbɛy te yi Yesus ɓa̧ kɛte, kaŋɛ misi ɓɛŋɛ nɛ nyɛ kɛ́, ɛ nyɛ ɓalɛ kɛ mɛkol mɛnɛ lɛpɔ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wɛ má ɓɛki waka, ma ɗyɔmbu ɗyembɛ tì gwe na.» ");
INSERT INTO kkj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kɛ Yesus ma ɓɛŋɛ Mariya kɛ lelɔ, ɓɛŋɛ Ɓeyudɛn ɓete ɓe nja̧ ɓenɛ ɓe Mariya kɛ lelɔ sendi kɛ́, ɛ ŋgambi sɔŋ kwa̧ nyɛ, ɛ mɛtakina nje nyɛ kɛ temɔ. ");
INSERT INTO kkj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ɛ nyɛ diyɛ ɓo nde: «Wunɛ púmbu nyɛ we?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, inja ɓɛŋɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ɛ Yesus lelɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɛ Ɓeyudɛn ɗiyɛ lɛpɔ nde: «Nɛ ɓɛ̂ŋa ndi, a ɓa̧ kɛ kwaɗyɛ nyɛ ɓuɗyate.» ");
INSERT INTO kkj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɛ ɓaŋa kɛ njokate lɛpɛ yan nde: «’Gba mbam kɔ ɛ ɓutuma misi mɛ mɔ ɗiɓina misi kɔ, ma nyɛ ti yaka kelɔ nde, Lasar ti gwáki na?» ");
INSERT INTO kkj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɛ ŋgambi sɔŋ ɓasiɗye kwa̧ Yesus, ɛ nyɛ kwa̧ kɛ̀ kɛ ɓoŋsɔŋ. Ɓoŋsɔŋ te ɓa̧ ŋguku tari, ɓo ɓoŋma wɛtɛ tari ɗiɓɔ nɛ numbu te. ");
INSERT INTO kkj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ɛ Yesus lɛpɛ nde: «Wunɛ njêŋa tari soŋɛ.» Ɛ Marta te ɗyɔmbu nɛ Lasar te ɛ gwa̧ kɔ lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, a mɛ kɛ numbɔ ndana, kɛto yo mɛ mɛtu yini yi ɓo pumbuma nɛ nyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «’Mi tì lɛpɛ nyɛ wɛ nde, ŋgɛ wɛ tikɛ temɔ kɛ lɛpi te yi mi lɛpɛ kɛ́, wɛ ta ɓɛŋɛ nyaŋgwɛ ɗeti mɛluksa mɛ Njambiyɛ na?» ");
INSERT INTO kkj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ndana kɛ́, ɛ ɓo njeŋɛ tari soŋɛ. Ɛ Yesus kaŋɛ misi kɛnjɛ kwey lɛpɔ nde: «Da, mi kɛ nyɛ wɛ wosoko, kɛto wɛ ma wokɔ mɛŋgwɛta mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yo nde, mi duwa̧ mbɛ nde, wɛ kɛ wokɔ mɛŋgwɛta mɛmbɛ kpo nɛ kpo. Yasi wɛtɛ, mi lɛ́pi yikɛ kɛto ŋgil te yikɛ yi ma wesiɗya kɛ kɛki mbɛ kɛ́, nɛ́ ɓo tiki temɔ nde, yo wɛ tomɛ mi njesɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ kembiɗya lɛpɔ nɛ mɛn kɛ kwey nde: «Lasar, pundɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ɛ mɔ te ɛ ɓa̧ ndana muŋte kɔ pundɛ, mɛɓɔ nɛ̀ mɛkol ɓɔynate nɛ mɛlambɔ, to nɛ̀ mbɔmbu ɓa̧ sendi ɓɔynate nɛ wɛtɛ pɛl kandɔ. Ɛ Yesus lɛpɛ nyɛ ɓomɔ nde: «Wunɛ sôŋa mɛyasi mɛnɔri kɛ yotu nɛ, tikɔ nyɛ, na kwa̧.» ");
INSERT INTO kkj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ɓeyudɛn ɓuɗyate ɓe nja̧ kɛ yi Mariya ɓaka ɓɛŋma yasi te yi Yesus kelma kɛ́, ɛ ɓo tikɛ temɔ kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yasi wɛtɛ, ɓaŋa kɛ njokate kwaŋma kɛ̀ dolɔ *Ɓefarisɛ̧ yekiɗye yasi te yi Yesus kelma kɛ́ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ndana, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ Ɓefarisɛ̧ wesiɗye ɓotu ɓete ɓe ɓa̧ kɛ njoŋ ɓotu ɓe nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka lɛpɔ nde: «Hɛ ta kelɔ yikɛ nan, kɛto mbam kɔ kɛ kelɔ ɓuɗya mɛyekambiyɛ? ");
INSERT INTO kkj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma ŋgɛ wusɛ ɓɛŋɛ nɛ misi nde, a kɛ́n mbɔmbu yí kelɔ mɛkele mɛte, ɓomɔ hɛnɛ ta tikɔ temɔ kɛ yenɛ, wɛ ɓɛ́ŋa, ɓotu ɓete ɓe ɗiyɛ nɛ mɛnɛti mɛ Rom ɓaka ta nje yaŋgile mbanjɔ Njambiyɛ su nɛ kandɔ ɗyusu.» ");
INSERT INTO kkj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndana, ɛ wɛtɛ kɛ njoka yan nde Kayif ɛ ɓa̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kɛ sew te ɛte kɔ lɛpɛ nyɛ ɓo nde: «Ko gba wunɛ kinɛ ɗyɔŋgɔ na! ");
INSERT INTO kkj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","’Wunɛ yeti kɛ duwɛ nde, yo kimɔte pɛ yun nde, mumɔ wɛtɛ gwâki kɛ numbu kandɔ, laŋsa nde, ɓo gîrisa ndiŋgɛlɛ kandɔ na?» ");
INSERT INTO kkj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yinɔri yi Kayif lɛpima kɛ́, yo ti wúla kɛ ɗyanɔ ɗyenɛ nɛ ŋguru wenɛ na. Yo nde, a lɛ́pi kɛto a ɓa̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kɛ sew te ɛte, ɛ nyɛ punjɛ lɛpi te yi wulma kɛ numbu Njambiyɛ yi ɓa̧ nde, yo ta kelna kɛ́. Ɛ nyɛ kandɛ si lɛpɔ nde, Yesus yâkaŋgwɛ gwe kɛto kandɔ ɗyan Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma yo tí ɓɛ ndi kɛto kandɔ Ɓeyudɛn ɓepɔ na, yasi wɛtɛ, yo ta ɓɛ sendi yí saŋgwɛ ɓɔnɔ ɓe Njambiyɛ ɓe ɗiyɛ mɛmbɛy nɛ mɛmbɛy, nɛ́ ɓo nje ɓɛ ndi njɔŋ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kandɛ yesɔ te, ɛ ɓo nyɛ ŋgiŋ yí sa̧ nɛ nje te yi ɓo yakama wo nɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɗete, Yesus tì yombila punjɛ se yotu kɛ njoka Ɓeyudɛn na. Yasi wɛtɛ, a nja̧ ɗuwɛ komɛte kwa̧ kɛ̀ kɛ pɔku mɛnɛti mɛte yi kɛ̀ kɛki koŋgor kɛ́, kɛ wɛtɛ ɗya nde Efrayim. Ɛ nyɛ kwa̧ ɗiyɔ mate ɓenɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jesɔ *Paska Ɓeyudɛn ɓa̧ kɛ wuta, ɛ ɓuɗya ɓomɔ tɛmɛ kɛ mɛɗya yí kɛ̀ pɛ Yerusalɛm, yite jesɔ tì pa kandɛ na. Ɓo kandima kwa̧, nɛ́ ɓo pa kɛ̀ weya sɛmbɔ ɓeŋgwɛ mɛmboŋga mɛ misɔn yan. ");
INSERT INTO kkj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɛ ɓo ɗiki sa̧ Yesus, ɗiki lɛpɔ diyna tandɛ yan kɛ mbanjɔ Njambiyɛ nde: «Nɛ ɓɛ́ŋa nan? Nɛ táka gba nde, a ta nje kɛ jesɔ wa?» ");
INSERT INTO kkj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yinɔri ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ *Ɓefarisɛ̧ ma lɛpɔ nyɛ ɓomɔ nde, ŋgɛ wɛtɛ mumɔ duwɛ mbɛy te yi Yesus ɗiyɛ kɛte kɛ́, nɛ̀ nyɛ kɛ̂n lɛpɔ, nɛ́ ɓo kɛ̀ ɓiy nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Piŋɔ te yi jesɔ *Paska ɓukwa̧ mɛtu yitan jɔ wɛtɛ, ɛ Yesus kwa̧ kɛ̀ kɛ Betani, kɛ ɗya te komɛ Lasar te yi nyɛ joŋgwa kɛ njoka ɓemuŋ kɔ ɗikima ɗiyɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kumɔ mate, ɛ ɓo kelɛ mɛɗye jeɓa nɛ nyɛ. Marta ɓa̧ nɛ mɛsay mɛ kaɓina mɛɗye nyɛ ɓomɔ. Lasar ɓa̧ sendi kɛ njoka ɓotu ɓete yi ɓo ɓa̧ kɛ mbɛy mɛɗye ɓenɛ ɓe Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ɗiyɔ kɛ́, ɛ Mariya ɓu̧ wɛtɛ ndaki nɛ yiŋa lɔbinda te yi ɗye ɓuɗya mɔni yaka lita kɛ ɓembe. Yo ɓa̧ nɛ sɛŋgɛlɛŋ, ɓo tì pa pulɛ yo nɛ yiŋa yasi na. Ɛ nyɛ ɓu̧ nje lɔmbɛ kɛ mɛkol mɛ Yesus kwa̧ titɔ yo nɛ nyiŋɔ to nɛ. Ɛ tul te si ŋgaŋgile ndiŋgɛlɛ tu̧. ");
INSERT INTO kkj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ɛ Yudas Iskariyot te wɛtɛ jekɛ Yesus, yɔkɔ ɛ ta ɗyaŋgwɛ nyɛ kɔ lɛpɛ nde: ");
INSERT INTO kkj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Kɛto ŋge yi ɓo tì ɗyaŋgwɛ lɔbinda te yikɛ yi yaka ɓuyɔ mɔni te yi ɓo gbo nɛ mɔ mɛsay kɛ mɛtu mɛsay gɔmay yitati yí kamɛ nɛ ɓotu ɓe ŋgwɛtɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yinɔri yi Yudas lɛpima kɛ́, yo yeti kɛto a nɛ kasi nɛ ɓotu ɓe ŋgwɛtɛ na. A lɛ́pi ɗete, kɛto nyɛ mɔ guɓɔ. Yo nyɛ ɗiki ɓakiɗye kpoŋgi mɔni. A ɗikima nyɛ ɓɔ kɛ yasi te yi ɓo ɗikima komɔ kɛ mɔyte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɛ Yesus nje lɛpɔ nde: «Pa tikɔ nyɛ nɛ sɛm. Tikɔ, na ɓakiɗye yo laɗye nɛ yesɔ te yi ɓo ta nyɛ nɛ mi kɛ ɓoŋsɔŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yo nde, wúnɛ ɓotu ɓe ŋgwɛtɛ kɛ ɗiyɔ mɛtu hɛnɛ kɛ kiya mbɛy. Kɛ ɓɛ mi, mi tí ɗiyɔ mbɛ sinɛ wunɛ kɛ kiya mbɛy mɛtu hɛnɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ɓeyudɛn ɓuɗyate wokuma nde, Yesus womɛte kɛ Betani. Ɛ ɓo kɛ̀, yeti ndi kɛto Yesus nyɛpɔ na, yasi wɛtɛ, ɓo ka̧ sendi, nɛ́ ɓo kɛ̀ ɓɛŋ Lasar te yi Yesus joŋgwa kɛ njoka ɓemuŋ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ndana, ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nyɛ ŋgiŋ nde, ɓo ta wo sendi Lasar, ");
INSERT INTO kkj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kɛto nyaŋgwɛ mɛkele mɛte yi kelnama kɛ yotu nɛ kɛ́ kɛ kelɔ nde, ɓuɗya Ɓeyudɛn tûm kɔŋ ndana nɛ ɓo tikɔ temɔ kɛ yi Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Misi pupɛ nyaŋgwɛ ŋgil ɓete ɓe nja̧ kɛ jesɔ *Paska ɓaka wokuma nde, Yesus kɛ nje kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɛ ɓo pɛsɛ mbɔru mɛbaŋa yí kɛ̀ sosa nɛ nyɛ. Ɛ ɓo ɗiki kembiɗya nde: «*Hosana! Baba Mbokɔ nyɛ̂ki mɛkombila nyɛ yɔkɔ ɛ nje nɛ ɗinɔ ɗyenɛ nje namɔ kandɔ Isarayɛl kɔ!» ");
INSERT INTO kkj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus dolma wɛtɛ mɔnɔ tofu, ɛ nyɛ ɓendɛ nyɛ ɗiyɔ te ɓeŋgwɛ yasi te yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yo kɛtinate nde: ‹Ŋgɔndu Siyɔŋ,*f1* wɛ tî kambi yaŋa na. Ɓɛŋa kumande wɔ ɓendima mɔnɔ tofu yí nje nɔ.› ");
INSERT INTO kkj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kɛ ŋgimɔ te yinɔri ɓejekɛ ɓe Yesus tì wokɛ to mɛyasi mɛte yi ɓa̧ kɛ kwaŋna kɛ́ na. Yasi wɛtɛ, kɛ Yesus ma nje yɔkwɛ kɛ ɗyoɓɔ ɓu̧ mɛluksa mɛnɛ kɛ́, ɛ ɓo nje takɛ duwɛ nde, yasi te yi mɛkana mɛ Njambiyɛ ɗikima lɛpɔ nɔ kɛ́ ɓa̧ kɛ kasi nɛ. Ɓo nja̧ duwɛ sendi nde, gba mɛyasi mɛte yi ɓo kelma kɛ́, ɓo kelma yo kɛto nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kɛ ŋgimɔ te yi Yesus jeɓama nɛ Lasar joŋgwɛ kɛ njoka ɓemuŋ punjɛ kɛ ɓoŋsɔŋ kɛ́, ɓuɗya ɓomɔ ɓa̧ kɛte. Ɛ ɓo ɗiki yekiɗye yasi te yi ɓo ɓɛŋma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yo kɛto te yite yi ŋgil ɓomɔ ka̧ kɛ̀ sosa nyɛ kɛ́. Ɓo wokuma kasi mɛyekambiyɛ mɛnɔri yi nyɛ kelma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ndana, ɛ *Ɓefarisɛ̧ lɛpɛ tandɛ yan nde: «Nɛ ɓɛ̂ŋa, yasi te yi wunɛ yakama kelɔ sendi ndana yeti se na. Ɓomɔ hɛnɛ ma lekwɛ kɛ̀ kɛ kɔŋ nɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɓaŋa Ɓegrɛk ɓa̧ kɛ njoka ɓotu ɓete ɓe ka̧ kɛ Yerusalɛm yí kɛ̀ kanɔ Njambiyɛ kɛ jesɔ *Paska ɓaka. ");
INSERT INTO kkj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɛ ɓo kɛ̀ kɛ yi Filip te mɔ Betsayda kɛ Galile. Ɛ ɓo ŋgwɛta nɛ nyɛ lɛpɔ nde: «Nyaŋgwɛ mbam, wusɛ kɛ kwaɗyɛ ɓɛŋɛ Yesus.» ");
INSERT INTO kkj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ɛ Filip kɛ̀ lɛpɔ nyɛ Andere, ɛ ɓo hɛnɛ yiɓa nje kwa̧ kɛ̀ lɛpɔ nyɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Ŋgimɔ ma ɗya̧, ŋgimɔ te yi Njambiyɛ ta punjɛ nɛ mɛluksa mɛ *Mɔnɔ mumɔ yɛy. ");
INSERT INTO kkj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ mbumɔ mbusa tì pa kɛ̀ kɛ mɛnɛti pa gwe na, yo ta ɓɔnɛ ndi wɛtɛ. Ma yasi wɛtɛ, ŋgɛ yo pa gwe, yo ta nje wumɔ ɓuɗya mɛmbumɔ. ");
INSERT INTO kkj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mɔ te ɛ kwaɗyɛ kambiɗya nɛ joŋgwɛ ɗyenɛ nɛ ŋgom ŋgom kɔ ta ɗimbiɗye yo. Ma yɔkɔ ɛ ɗiyɛ kinɛ kambiɗya nɛ joŋgwɛ ɗyenɛ nɛ ŋguru wenɛ kɔ ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mumɔ hɛnɛ ɛ kwaɗyɛ kelɔ mɛsay nyɛ mi, mɔ te yâkaŋgwɛ ɓeŋgwɛ mi. Kɛ mbɛy te yi mi ɗiyɛ kɛte, mɔ mɛsay wombɛ ta ɗiyɔ sendi kɛte. Ŋgɛ mumɔ kelɛ mɛsay nyɛ mi, Da ta lukse nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Ndana temɔ mbɛ ɗekɛ nɛ haɓuɓu, mi duwa̧ nde, mi ta lɛpɔ nɛ ŋge? ’Mi lɛ́pi ka nde: Da joŋgwɛ mi kɛ yasi te yi kwaɗyɛ ɗya̧ mi ndana kɛ́? Ko na, kɛto yo kɛto te yite yi mi nja̧ nɔ kɛ mɛnɛti maka. ");
INSERT INTO kkj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Da, kelɔ nde, ɓomɔ lûksa ɗinɔ ɗyɔ.» Ndana, ɛ ɓo wokɛ yiŋa mɛn kɛ wulɛ ɗyoɓɔ lɛpɔ nde: «Mi ma kelɔ nde, ɓomɔ lûksa ɗinɔ ɗyembɛ. Mi ta ɓasiɗye kelɔ nde, ɓo lûksa sendi yo.» ");
INSERT INTO kkj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ŋgil ɓotu ɓete ɓe ɓa̧ womɛte wokɔ mɛn yinɔri ɓaka lɛpima nde: «Mbiyɔ lumma.» Ɓaŋa nde: «Wɛtɛ jaki Njambiyɛ lɛpinama nyɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɛ Yesus yeŋsa nde: «Mɛn te yi lɛpinama wulɛ ɗyoɓɔ kɛ́ ti lɛ́pinaŋgwɛ kɛto mbɛ na, yo lɛ́pinaŋgwɛ kɛto yun. ");
INSERT INTO kkj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ŋgimɔ te yi Njambiyɛ ta pɛsɔ nɛ jɔsi ɓotu ɓe mɛnɛti maka kɛ́ ma ɗya̧. Ndana Njambiyɛ ta ɗuɗye *Kum mɛnɛti maka soŋɛ. ");
INSERT INTO kkj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pɛ yembɛ, kɛ ɓo si ŋgba mi kɛ jeti tɛmbiɗye kɛ kwey, mi ta ɗulɛ ɓomɔ hɛnɛ njesɛ kɛ yembɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus lɛ́pi yinɔri yí teɗye nɛ kwalɔ sɔŋ te yi nyɛ ta saŋgwa nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɛ ŋgil ɓomɔ yeŋsa nyɛ nyɛ nde: «Wusɛ wokuma su kɛ mɛkana mɛ mɛmboŋga mɛ Njambiyɛ nde, *Krist ta ɗiyɔ kpo nɛ kpo. Ma nan yi wɛ nje lɛpɔ yɔ nde, ɓo yâkaŋgwɛ ŋgba *Mɔnɔ mumɔ kɛ jeti tɛmbiɗye kɛ kwey kɛ́? Mɔnɔ mumɔ te ɛte ɓa nda?» ");
INSERT INTO kkj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɛ Yesus nje lɛpɔ nyɛ ɓo nde: «Mɛjasi ndi kɛ njoka yun yi yaka mɔnɔ ŋgimɔ. Piŋɔ te yi yo ndi kɛ panɔ ɗete kɛ́, wunɛ kɛ̂ndi kɛ puyɛ te, kambɔ yitil mɛ nje ŋgbakɛ wunɛ. Yo nde, mɔ te ɛ kɛndɛ kɛ mɔy yitil kɔ kɛ́ndi tukute. ");
INSERT INTO kkj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kɛ ŋgimɔ te yi mɛjasi ndi kɛ panɔ kɛ njoka yun kɛ́, wunɛ tîki temɔ kɛ mɛjasi mɛte, nɛ́ wunɛ ɓɛ ɓotu ɓe mɛjasi.» Kɛ Yesus ma si lɛpɔ mɛyasi mɛnɔri kɛ́, ɛ nyɛ kwa̧ ɗuwɛ womɛte kɛ̀ mbɔmbu yan kɛ̀ sɔma. ");
INSERT INTO kkj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko ɓɛkɔ nde, a kelma ɓuɗya mɛyekambiyɛ ɗete kɛ misi mɛ ɓomɔ, ɓo tì tikɛ temɔ nɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yo kwaŋnama ɗete, nɛ́ mɛlɛpi mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ si tondu. A lɛpima nde: ‹Baba Mbokɔ, ma nda tikima temɔ kɛ yasi te yi wusɛ lɛpima kɛ́? Sendi, ’Baba Mbokɔ téɗya nda ɗeti nɛ?› ");
INSERT INTO kkj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ko, ma ɓo ti yaka tikɔ temɔ na, kɛto lɛpi te yi Esayi lɛpima sendi kɛ́. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‹Njambiyɛ ma ɗiɓɔ misi man, ɗesɛ mɛtemɔ man, kambɔ ɓo mɛ nje ɓɛŋɛ mɛyasi, ɓo mɛ nje ɓɛ nɛ ɗyanɔ, ɓo mɛ nje yeŋsa temɔ, ma nyɛ nje siɗyɛ kɔn yan.› ");
INSERT INTO kkj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esayi njáki lɛpɔ mɛyasi mɛnɔri kɛ kasi Yesus, kɛto a ɓɛŋma mɛluksa mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko ɓɛkɔ ɗete, ɓaŋa Ɓeyudɛn ɓuɗyate tikima temɔ kɛ yi Yesus. Yasi wɛtɛ, ɓo tì jayɛ punjɛ yo kɛ misi mɛ ɓomɔ na, kambɔ *Ɓefarisɛ̧ mɛ nje lɛpɔ nde, ɓo tî nata se mbanjɔ mɛwesiɗya na. ");
INSERT INTO kkj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ɓekum Ɓeyudɛn ɓaka kelma ɗete, kɛto ɓo kwaɗya nde, ɓomɔ lûksa ɓo kwa̧ mɛluksa mɛte yi Njambiyɛ yakama lukse nɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ndana, ɛ Yesus lɛpɛ nɛ mɛn kɛ kwey nde: «Mɔ te ɛ tikɛ temɔ nɛ mi, mɔ te ti tíki temɔ nɛ mi na, yo nde, a tíki temɔ nɛ Mɔ te ɛ tomma mi njesɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sendi, mɔ te ɛ ɓɛŋɛ mi, mɔ te ɓɛŋma Mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi nja̧ mbɛ kɛ mɛnɛti maka yí paniyɛ puyɛ nda yi mɛjasi panɛ nɔ kɛ́. Ɗete, mɔ te ɛ tikɛ temɔ nɛ mi, mɔ te tí ɗiyɔ kɛ mɔy yitil na. ");
INSERT INTO kkj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ŋgɛ mumɔ wokɛ mɛlɛpi mɛmbɛ pupɛ mɛtɔ, yeti mi jɔse nyɛ na, kɛto mi ti njáki nje jɔse ɓotu ɓe mɛnɛti maka na, yo nde, mi njáki nje joŋgwɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mɔ te ɛ sɛŋɛ mi pupɛ mɛtɔ kɛ mɛlɛpi mɛmbɛ, mɔ te nɛ mɔ te ɛ ta jɔse nyɛ. Gba lɛpi te yi mi lɛpima kɛ́ ta pɛsɔ jɔsi nɛ kɛ njena yesɔ siyna mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yo nde, mi tì lɛpina nɛ ɗeti te yembɛ na. Yasi wɛtɛ, Da, nyɛ Mɔ te ɛ tomma mi nɛ ŋguru wenɛ kɔ lɛpima nyɛ mi mɛyasi mɛte yi mi yâkaŋgwɛ lɛpɔ nɛ̀ mɛyasi mɛte yi mi yâkaŋgwɛ teɗye kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma mi duwa̧ nde, yasi te yi nyɛ lɛpɛ kɛ́ kél nde, mumɔ ɓɛ̂ki nɛ joŋgwɛ te yi kpo nɛ kpo. Ɗete, mɛyasi mɛte yi mi lɛpɛ mbɛ kɛ́, mi lɛ́pi ɓeŋgwɛ numbu Da.» ");
INSERT INTO kkj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Misi pupɛ yo ɓa̧ nde, ɓo ta kelɔ jesɔ *Paska. Yesus duwa̧ nde, ŋgimɔ nɛ ma ɗya̧, ŋgimɔ te yi nyɛ ta ɗuwɛ nɔ kɛ mɛnɛti maka kɛ̀ pɛ yi Da. A ɓa̧ kɛ kwaɗyɛ ɓotu ɓenɛ ɓe ɓa̧ kɛ mɛnɛti maka ɓaka mɛtu hɛnɛ. A kwaɗya ɓo kumɔ kɛ njena mɛtu mɛnɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesus ɓa̧ kɛ ɗyena ɓenɛ ɓejekɛ ɓenɛ ɓekoko. Yinɔri *Kum ɓeya mɛkele ma nyɛ ɓeya mɛtakɛ kɛ temɔ Yudas te mɔnɔ Simɔn Iskariyot nde, a ɗyâŋgwɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus duwa̧ nde, Da ma nyɛ nyɛ ɗeti te yi namɔ mɛyasi hɛnɛ. A duwa̧ sendi nde, a wúla kɛ yi Njambiyɛ nje nɔ, a ta yɔkwɛ kɛ̀ pɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɛ nyɛ tɛmɛ kɛ mbɛy mɛɗye soŋɛ nyaŋgwɛ lambɔ te yi ɓa̧ kɛ yotu nɛ kɛ̀ tikɔ nɛ naŋ. Ɛ nyɛ ɓu̧ yiŋa kum lambɔ wotɔ kɛ jon. ");
INSERT INTO kkj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ndana, ɛ nyɛ ɓu̧ mɔrɔku kumbɛ kɛ wɛtɛ pan nyɛ ɓɔ kɛ weyna mɛkol mɛ ɓejekɛ ɓenɛ nje titɔ nɛ kum lambɔ te yi ɓa̧ kɛ jon nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ɛ nyɛ nje kumɔ kɛ yi Simɔn Piyɛr. Ɛ Simɔn Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, yo gba wɛ kɛ kwaɗyɛ weyɛ mɛkol mɛmbɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Wɛ yeti kɛ ɓiye to yasi te yi mi kelɛ ndana kɛ́ na, yasi wɛtɛ, wɛ ta nje ɓiye yo wɛtɛ yesɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Ko wɛ tí weyɛ mɛkol mɛmbɛ wɛtɛ yesɔ na.» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ŋgɛ mi ti weyɛ mɛkol mɔ na, nam siyma sinɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ɛ Simɔn Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wɛ tî weya ndi mɛkol siyɛ na, weya sendi mɛɓɔ nɛ̀ to.» ");
INSERT INTO kkj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ɛ Yesus nje lɛpɔ nyɛ nyɛ nde: «Ŋgɛ mumɔ si weya nɛ yotu hɛnɛ, siya yasi te yi nyɛ yâkaŋgwɛ kelɔ kɛ kɔŋte, yo ndi weyna gbɛla mɛkol, kɛto yotu nɛ mɛ pupunate. Ma wunɛ mɛ yun pupunate. Yasi wɛtɛ, yeti wunɛ hɛnɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yo nde, Yesus duwa̧ mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ, yori yi nyɛ lɛpima nde: ‹Wunɛ hɛnɛ yeti pupunate› kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ndana, kɛ Yesus ma si weyɛ mɛkol man kɛ́, ɛ nyɛ tɔkɛ lambɔ nɛ lɛŋɛ nje kwa̧ ɗiyɔ kɛ mbɛy mɛɗye lɛpɔ nyɛ ɓo nde: «’Wunɛ ɓiyma to yasi te yi mi kelma ndana nɛ wunɛ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yi wunɛ jeɓa mi nde yekele ho nde kumande kɛ́, yo gbakasi, mi gbate yekele nɛ̀ kumande. ");
INSERT INTO kkj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma ŋgɛ ɓɛ nde, mi kumande, mi yekele weyma mɛkol mun, wunɛ sendi, wunɛ yâkaŋgwɛ weyɛ mɛkol mun tandɛ yun. ");
INSERT INTO kkj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yo nde, mi teɗya wunɛ nda yi wunɛ yâkaŋgwɛ kelɔ kɛ́, nɛ́ wunɛ kel sendi nda yi mi kelma nɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Kinɛ wɛtɛ mɔ mɛsay ɛ kwaŋma masa wenɛ na. Sendi, kinɛ wɛtɛ mɔ te yi ɓo tomɛ nyɛ tomɔ kwaŋma mɔ te ɛ tomma nyɛ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nda wunɛ ma duwɛ ɗete kɛ́, ŋgɛ wunɛ kelɛ ɗete, wunɛ ta ɓɛ nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Mi ti lɛ́pi nɛ wunɛ hɛnɛ na, mi duwa̧ gba ɓotu ɓete ɓe mi tɔkuma ɓaka. Yasi wɛtɛ, mɛlɛpi mɛte yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ yâkaŋgwɛ si tondɔ. Yo kɛtinate nde: ‹Mɔ te yi sinɛ nyɛ ɗyena ndi wɛtɛ kɔ ɓoŋma ɗyambi suŋgwɛ nɛ mi.› ");
INSERT INTO kkj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma yokɛ yi mi kandɛ lɛpɔ ndana nyɛ wunɛ kɛ ŋgimɔ te yi ɓeya yasi tì pa ɗya̧ kɛ́. Simande kɛ ŋgimɔ te yi yo ta ɗya̧ kɛ́, nɛ́ wunɛ tiki temɔ nde, yo mi mɔ te yi mi ɗikima lɛpɔ nɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔ te ɛ ɓu̧ mumɔ hɛnɛ te yi mi tomɛ kɔ kimɔte, mɔ te ɓóŋ mi. Sendi, mɔ te ɛ ɓu̧ mi kimɔte, mɔ te ɓóŋ Mɔ te ɛ tomma mi kɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kɛ Yesus ma si lɛpɔ ɗete kɛ́, temɔ nɛ tì ɓɛ nɛ tɛ kɛ kɔŋte na, ɛ nyɛ lɛpɛ nɛ saŋsaŋ nde: «Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wɛtɛ mumɔ kɛ njoka yun ta ɗyaŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ɛ lɛpi ɓanɛ ɓejekɛ, ɛ ɓo ɓɛŋna tandɛ yan nɛ hɛlɛ hɛlɛ hɛlɛ kinɛ duwɛ mɔ te yi nyɛ lɛpɛ nɔ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yinɔri wɛtɛ jekɛ te yi Yesus ɗikima kwaɗyɛ ɓuɗyate kɔ ɓa̧ mɛtiɗyɛ kɛ mbɛy mɛɗye kɛ kɛki Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ɛ Simɔn Piyɛr yɛsiɗyɛ misi nyɛ nyɛ nde, a dîya Yesus, na lɛpi mɔ te yi nyɛ lɛpɛ nɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ɛ jekɛ te lɛŋgwɛ yotu kɛnjɛ pulɔ Yesus diyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wɛ lɛ́pi yasi kɛ nɛ nda?» ");
INSERT INTO kkj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ɛ Yesus yeŋsa nde: «Mɔ te yi mi ta ɓu̧ mampa tɔpɛ kɛ mbe njay kaŋɛ nyɛ nyɛ kɔ, mɔ te ru.» Ɛ nyɛ ɓu̧ mampa tɔpɛ kɛ mbe njay kaŋɛ nyɛ Yudas te mɔnɔ Simɔn Iskariyot. ");
INSERT INTO kkj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kɛ Yesus ma kaŋɛ ndi yo nyɛ nyɛ ɗekɛ kɛ́, ɛ *Satan nyiŋɛ temɔ Yudas. Ɛ Yesus nje ɗiyɔ lɛpɔ nyɛ nyɛ nde: «Yasi te yi wɛ takɛ kelɔ kɛ́, kelɔ yo nɛdɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ko mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka ɓotu ɓete ɓe ɓa̧ kɛ mbɛy mɛɗye ɓaka tì ɓiye to lɛpi te yi nyɛ lɛpima nyɛ Yudas kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yo nde, ɓaŋa takima nde, nda yo Yudas ɓakiɗye kpoŋgi mɔni kɛ́, Yesus lɛ́pi yari nyɛ nyɛ nde, a ɓɔ̂m mɛyasi mɛte yi yo ta kamɛ ɓo kɛ jesɔ kɛ́, ho nde, a nyɛ̂ki yiŋa yasi nyɛ ɓotu ɓe ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kɛ Yudas ma kɛnjɛ ndi ɓɔ ɓiye nɛ mampa yinɔri kɛ́, ɛ nyɛ pundɛ nɛ put kwa̧. Yo ɓa̧ nɛ tu. ");
INSERT INTO kkj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kɛ Yudas ma si pundɔ kwa̧ kɛ́, ɛ Yesus lɛpɛ nde: «Ndana Njambiyɛ ma punjɛ mɛluksa mɛ *Mɔnɔ mumɔ. Sendi, Njambiyɛ ma punjɛ mɛluksa mɛnɛ nɛ ŋguru wenɛ nɛ nje Mɔnɔ. ");
INSERT INTO kkj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ŋgɛ ɓɛ nde, Njambiyɛ ma punjɛ mɛluksa mɛnɛ nɛ ŋguru wenɛ nɛ nje Mɔnɔ, a ta punjɛ mɛluksa mɛ Mɔnɔ kɛ yotu nɛ, Njambiyɛ nɛ ŋguru wenɛ. Ŋgimɔ te yi nyɛ ta punjɛ nɛ mɛluksa mɛ Mɔnɔ kɛ́ ɓukwa̧ nɛ mbɛt. ");
INSERT INTO kkj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wunɛ ɓɔnɔ, mi ndi nɛ mɔnɔ ŋgimɔ nɛ mbɛt yí kwaŋɗye sinɛ wunɛ. Wunɛ ta sa̧ mi. Mi lɛpima nyɛ Ɓeyudɛn nde, wunɛ yeti nɛ ɗeti te yi kɛ̀ kɛ mbɛy te yi mi kɛ̀ kɛte kɛ́ na. Yo ndi kiya mɛlɛpi mɛte yi mi lɛpɛ sendi ndana nyɛ gba wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi kɛ nyɛ wunɛ jɔnja mboŋga, yo nde: Wunɛ kwâɗyaŋgwɛ tandɛ yun nda yi mi kwaɗya nɛ wunɛ kɛ́. Wunɛ sendi, wunɛ kwâɗyaŋgwɛ ɗete. ");
INSERT INTO kkj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ŋgɛ wunɛ kwaɗya tandɛ yun, ɓomɔ ta duwɛ nde, wunɛ ɓejekɛ ɓembɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ɛ Simɔn Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, yite nde, wɛ kɛ́n we?» Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Wɛ yeti nɛ ɗeti te yi ɓeŋgwɛ mi kɛ mbɛy te yi mi kɛ̀ kɛte ndana kɛ́ na, yasi wɛtɛ, wɛ ta disɔ ɓeŋgwɛ mi kɛ yiŋa mɛŋgimɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, ŋge ta suŋɔ nde, mi tí ɓeŋgwɛ wɛ ndana kɛ́? Mi nɛdɔ te yi nyɛ joŋgwɛ ɗyembɛ kɛto yɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ɛ Yesus yeŋsa nde: «Wɛ lɛ́pi gba nde, wɛ nɛdɔ te yi nyɛ joŋgwɛ ɗyɔ kɛto mbɛ nde? Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Wɛ ta tonɔ kumɔ mɛŋga yitati nde, wɛ yeti kɛ duwɛ mi na, mbam kuɓɛ má nje kɔkɔ njimɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ɛ Yesus kɛ̀ mbɔmbu lɛpɔ nyɛ ɓejekɛ nde: «Temɔ yun tî kuɗyukwɛ na. Wunɛ kɛ̂n mbɔmbu yí tikɔ temɔ kɛ yi Njambiyɛ, tikɔ sendi temɔ nɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mɛmbɛy ɓuɗyate kɛ tu̧ Saŋmbɛ. Yo má ɗiy kinɛ ɓɛ ɗete na, ’ma mi tì lɛpɛ nyɛ wunɛ nde: Mi kɛ kɛ̀ kombile mbɛy tikɛ wunɛ na? ");
INSERT INTO kkj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ŋgɛ mi si kɛ̀ kombile mbɛy tikɛ wunɛ, mi ta yɔkwɛ nɛ kɔkɔ nje ɓu̧ wunɛ, nɛ́ wunɛ ɗiy sendi kɛ mbɛy te yi mi ɗiyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wunɛ duwa̧ mbɛy te yi mi kɛ̀ mbɛ kɛte kɛ́, wunɛ duwa̧ nje te.» ");
INSERT INTO kkj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ɛ Tomasi lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, wusɛ yeti kɛ duwɛ mbɛy te yi wɛ kɛ̀ kɛte kɛ́ na. Ma hɛ ta kelɔ nan yí duwɛ nɛ nje te?» ");
INSERT INTO kkj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Mi mbɛ nje, mi gbakasi, mi sendi joŋgwɛ. Kinɛ mumɔ ɛ yakama kumɔ kɛ yi Da kinɛ kwa̧ nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wunɛ má dukwɛ mi gbate, ma wunɛ ta duwɛ sendi Saŋmbɛ. Kandɛ ndana wunɛ ma duwɛ nyɛ, wunɛ sima ɓɛŋɛ nyɛ sendi.» ");
INSERT INTO kkj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ɛ Filip lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, teɗya wusɛ Da, yite ma yaka wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Wuy Filip, ɓuɗya nyaŋgwɛ mɛtu mɛte yi mi sima kwaŋɗye sinɛ wunɛ kɛ́, ’kumɔ ndana wɛ tì pa duwɛ mi na? Mɔ te ɛ ɓɛŋma mi, mɔ te sima ɓɛŋɛ Da. Ma nan yi wɛ nje lɛpɔ ndana nde: ‹Teɗya wusɛ Da› kɛ́? ");
INSERT INTO kkj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","’Wɛ yeti kɛ tikɔ temɔ nde, mi mbɛ pɛ yi Da, ma nyɛ sendi pɛ yembɛ na? Mɛlɛpi mɛte yi mi lɛpɛ mbɛ nyɛ wunɛ kɛ́, mi ti lɛ́pi nɛ ɗeti te yembɛ na. Yo nde, Da, nyɛ ɛ ɗiyɛ kɛ yembɛ kɔ kɛ punjɛ nyaŋgwɛ mɛkele mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wunɛ tîki temɔ kɛ lɛpi te yi mi lɛpɛ nde: Mi pɛ yi Da, Da sendi pɛ yembɛ kɛ́. Ŋgɛ wunɛ ti tikɛ temɔ nɛ mi kɛ lɛpi te yite na, wunɛ yêkiɗya tikɔ temɔ kɛto mɛkele mɛte yikɛ yi mi kelɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Mɔ te ɛ tikɛ temɔ nɛ mi, mɔ te ta kelɔ sendi kwalɔ mɛkele mɛte yi mi kelɛ kɛ́. A ta kelɔ nyaŋgwɛ mɛkele kwa̧ yikɛ, kɛto mi kɛ kwa̧ mbɛ kɛ̀ pɛ yi Da. ");
INSERT INTO kkj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma yasi hɛnɛ te yi wunɛ ta diyɛ nɛ ɗinɔ ɗyembɛ, mi ta kelɔ yo, nɛ́ Da ɓɛ nɛ mɛluksa nɛ nje Mɔnɔ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ŋgɛ wunɛ diyɛ yaŋa nɛ ɗinɔ ɗyembɛ, gba mi ta kelɔ yasi te.» ");
INSERT INTO kkj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ŋgɛ wunɛ kwaɗyɛ mi, wunɛ ta ɓakiɗye mɛmboŋga mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma mi ta ŋgwɛta mbɛ nɛ Da, a ta nyɛ wunɛ wɛtɛ *Mɔ mɛkamna te ɛ ta ɗiyɔ wúnɛ ɓo kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mɔ mɛkamna te, yo Sisiŋ te ɛ gbakasi. Ɓotu ɓe mɛnɛti maka yeti nɛ ɗeti te yi jayɛ nyɛ na, kɛto ɓo yeti kɛ ɓɛŋɛ nyɛ na. Sendi, ɓo yeti kɛ duwɛ nyɛ na. Yasi wɛtɛ, wunɛ kɛ duwɛ yun nyɛ, kɛto a kɛ ɗiyɔ wúnɛ ɓo, ɓɛ sendi pɛ yun. ");
INSERT INTO kkj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi tí tikɔ wunɛ nda ɓɔnɔ ɓenyuru na. Mi ta yɔkwɛ nje kɛ yun. ");
INSERT INTO kkj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt, ɓotu ɓe mɛnɛti maka tí ɓɛŋɛ se mi na. Yasi wɛtɛ, ndi wunɛ ta ɓɛŋɛ yun mi, kɛto mi mbɛ nɛ joŋ, ɗete wunɛ sendi ta ɓɛ yun nɛ joŋ. ");
INSERT INTO kkj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yesɔ te wunɛ ta duwɛ nde, mi mbɛ kɛ yi Saŋmbɛ, wunɛ yun pɛ mi, mi pɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mumɔ hɛnɛ ɛ jayɛ mɛmboŋga mɛmbɛ ɓakiɗye yo, yo mɔ te ɛ kɛ kwaɗyɛ mi. Mumɔ hɛnɛ ɛ kwaɗyɛ mi, Saŋmbɛ ta kwaɗyɛ nyɛ. Mi sendi ta kwaɗyɛ mɔ te punjɛ yotu nyɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ɛ Yudas, yeti Yudas te Iskariyot na lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, nan yi wɛ ta punjɛ ndi yotu nyɛ wusɛ kinɛ punjɛ nyɛ ɓotu ɓe mɛnɛti maka kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ŋgɛ mumɔ kwaɗyɛ mi, mɔ te ta ɓakiɗye mɛlɛpi mɛmbɛ, Saŋmbɛ ta kwaɗyɛ nyɛ. Sinɛ Saŋmbɛ ta kɛ̀ kɛ yenɛ ɓiye ɗya kɛ yenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ŋgɛ mumɔ ti kwaɗyɛ mi na, mɔ te ti yaka ɓakiɗye mɛlɛpi mɛmbɛ na. Yo nde, mɛlɛpi mɛte yi wunɛ wokɛ yi pundɛ kɛ numbu mbɛ kɛ́ ti wúla kɛ yembɛ nɛ ŋguru wombɛ na, yasi wɛtɛ, yo wúla kɛ yi Da, nyɛ mɔ te ɛ tomma mi kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Mi lɛ́pi mɛyasi maka ndana nyɛ wunɛ kɛ ŋgimɔ te yi mi ndi kɛte sinɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yo nde, *Mɔ mɛkamna te ɛ Da ta tomɔ nɛ ɗinɔ ɗyembɛ kɔ ta teɗye wunɛ mɛyasi hɛnɛ. A ta kelɔ sendi nde, wunɛ tâka mɛyasi hɛnɛ te yi mi lɛpima nyɛ wunɛ kɛ́. Mɔ mɛkamna te, yo Kimɔ Sisiŋ. ");
INSERT INTO kkj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Gba tɛte yi mi tikɛ nɛ wunɛ kɛ́! Mi kɛ nyɛ wunɛ tɛte yembɛ. Mi yeti kɛ nyɛ wunɛ yo nda yi ɓotu ɓe mɛnɛti maka nyɛ kɛ́ na. Temɔ yun tî kuɗyukwɛ na, wunɛ tî gwaki wɔ̧ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wunɛ ma wokɔ yasi te yi mi lɛpima nyɛ wunɛ kɛ́. Mi lɛpima nde: ‹Mi kɛ kwa̧, ma mi ta yɔkwɛ sendi nje kɛ yun.› Má ɓɛki nde, wunɛ kɛ kwaɗyɛ mi gbate, ma wunɛ nɛ mɛsosa yí wokɔ nde, mi kɛ kwa̧ kɛ pɛ yi Da, kɛto Da kwa̧ mi. ");
INSERT INTO kkj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma yokɛ yi mi kandɛ lɛpɔ ndana nyɛ wunɛ piŋɔ te yi yo tì pa kelna kɛ́. Simande kɛ ŋgimɔ te yi yo ta kelna kɛ́, nɛ́ wunɛ tiki temɔ kɛ yembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi tí lɛpina se ɓuɗyate sinɛ wunɛ na, kɛto *Kum mɛnɛti maka kɛ nje. A yeti nɛ ɗeti te yi kelɔ yiŋa yaŋa nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yo nde, mɛyasi ta kwaŋna ɗete, nɛ́ ɓotu ɓe mɛnɛti maka duwɛ gbate nde, mi kɛ kwaɗyɛ Da, nɛ́ ɓo duwɛ sendi nde, mi kél mɛyasi ɓeŋgwɛ lɛpi te yi Da lɛpima nyɛ mi kɛ́. Nɛ tɛ̂ma, hɛ jîsa waka kwa̧.» ");
INSERT INTO kkj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Mi mbɛ kpasa njuku *vinyɛ. Ma Saŋmbɛ, mɔ kombilate. ");
INSERT INTO kkj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ɓɔ jeti hɛnɛ ɛ ɗiyɛ kɛ mi kinɛ wumɔ mɛmbumɔ, Saŋmbɛ kɛ pɛsɔ yo soŋɛ. Ndi nde, a kɛ kombile soŋɛ ɓeya mɔnɔ mɛɓɔ mɛ jeti mɛte yi lo kɛ ɓɔ jeti te ɛ wumɛ mɛmbumɔ kɔ, nɛ́ yo wum kwa̧ yite. ");
INSERT INTO kkj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wunɛ mɛ yun pupunate kɛto mɛlɛpi mɛte yi mi lɛpima nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wunɛ ɗîy mɛtu hɛnɛ pɛ mi nda yi mi ɗiyɛ mɛtu hɛnɛ pɛ yun kɛ́. Ŋgɛ ɓɔ jeti ti ɗiyɛ saŋgwate nɛ njuku te na, a ti yaka ɗiyɔ nyɛpɔ wumɔ mbumɔ na. Yo sendi ɗete nɛ wunɛ. Ŋgɛ wunɛ ti ɗiyɛ mɛtu hɛnɛ pɛ mi, wunɛ ti yaka wumɔ mɛmbumɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi mbɛ njuku jeti, wunɛ yun mɛɓɔ mɛte. Mumɔ te ɛ ɗiyɛ mɛtu hɛnɛ pɛ mi, mi sendi pɛ nyɛ, mɔ te kɛ wumɔ ɓuɗya mɛmbumɔ, kɛto kinɛ mi, wunɛ ti yaka kelɔ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ŋgɛ mumɔ ti ɗiyɛ mɛtu hɛnɛ pɛ mi na, ɓo kɛ ɓu̧ nyɛ ɓetɛ nɛ vɛŋ nda yi ɓo ɓetɛ nɛ ɓɔ jeti kɛ́, ɔ ɓɛ́ŋa, yo ma si sɔsɔ, ɓo má nje ɓu̧ yo ɓetɛ kɛ ɗitɛ si loɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ŋgɛ wunɛ ɗiyɛ mɛtu hɛnɛ pɛ mi, sendi, ŋgɛ mɛlɛpi mɛmbɛ ɗiyɛ mɛtu hɛnɛ pɛ yun, komɛte, wunɛ dîya yasi hɛnɛ te yi wunɛ kwaɗyɛ, wunɛ ta ɓɛ nɛ yo. ");
INSERT INTO kkj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ŋgɛ wunɛ wumɛ ɓuɗya mɛmbumɔ, wunɛ ta teɗye nde, wunɛ ɓejekɛ ɓembɛ. Ɗete, mɛluksa mɛ Saŋmbɛ kɛ pundɔ kɛ puyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Mi kwaɗya wunɛ nda yi Da kwaɗya nɛ mi kɛ́. Wunɛ kɛ̂n mbɔmbu yí ɗiyɔ saŋgwate nɛ mi kɛ mɔy mɛkwaɗya mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ŋgɛ wunɛ ɓakiɗye mɛmboŋga mɛmbɛ, wunɛ ta kɛ̀ mbɔmbu yí ɗiyɔ mɛtu hɛnɛ pɛ mi kɛ mɔy mɛkwaɗya mɛmbɛ nda yi mi ɓakiɗya nɛ mɛmboŋga mɛ Saŋmbɛ yí ɗiyɔ nɔ mɛtu hɛnɛ pɛ yenɛ kɛ mɔy mɛkwaɗya mɛnɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi lɛ́pi mɛyasi mɛnɔri nyɛ wunɛ, nɛ́ wunɛ ɓɛ nɛ mɛsosa mɛte yi mi nɔ kɛ́, nɛ́ mɛsosa tondu kɛ temɔ yun. ");
INSERT INTO kkj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Mboŋga te yi mi nyɛ wunɛ kɛ́, yo nde: Wunɛ kwâɗyaŋgwɛ tandɛ yun nda yi mi kwaɗya nɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Njena nyaŋgwɛ mɛkwaɗya mɛte yi mumɔ yakama teɗye, yo komɛ nyɛ nyɛ joŋgwɛ ɗyenɛ kɛto ɓesɔ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ŋgɛ wunɛ kelɛ yasi te yi mi lɛpɛ nyɛ wunɛ kɛ́, yite wunɛ ɓesɔ ɓembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi yeti kɛ jeɓa se wunɛ nde ɓotu ɓe mɛsay na, kɛto mɔnɔ mɛsay ti dúkwɛ yasi te yi masa wenɛ kelɛ kɛ́ na. Mi kɛ jeɓa wunɛ ndana nde ɓesɔ ɓembɛ, kɛto mi ma teɗye wunɛ mɛyasi hɛnɛ te yi Saŋmbɛ lɛpima nyɛ mi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yeti wunɛ tɔkɛ mi na, yo mi tɔkɛ wunɛ tomɔ wunɛ, nɛ́ wunɛ kɛ̀ wum mɛmbumɔ, nɛ́ mɛmbumɔ mun kiki. Ɗete, yasi hɛnɛ te yi wunɛ ta diyɛ Da nɛ ɗinɔ ɗyembɛ, a ta nyɛ wunɛ yo. ");
INSERT INTO kkj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yasi hɛnɛ te yi mi kombile lɛpɔ nyɛ wunɛ, yo nde: Wunɛ kwâɗyaŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Ŋgɛ ɓɛ nde, ɓotu ɓe mɛnɛti maka kɛ ɓenɔ wunɛ, wunɛ dûkwɛ nde, ɓo kandima ɓenɔ mi nɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wunɛ má ɓɛki saŋgwate wunɛ ɓotu ɓe mɛnɛti maka, ma ɓotu ɓe mɛnɛti maka ta kwaɗyɛ wunɛ, kɛto wúnɛ ɓo ndi nɛ mɛkele wɛtɛ. Yasi wɛtɛ, wunɛ yeti saŋgwate wúnɛ ɓotu ɓe mɛnɛti maka na. Mi tɔkuma wunɛ soŋɛ kɛ njoka yan. Yo kɛto te yite yi ɓotu ɓe mɛnɛti maka ɓenɛ nɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wunɛ tâka lɛpi te yi mi lɛpima mbɛ nyɛ wunɛ kɛ́. Mi lɛpima nyɛ wunɛ nde: ‹Kinɛ wɛtɛ mɔ mɛsay ɛ kwaŋma masa wenɛ na.› Ŋgɛ ɓɛ nde, ɓo teɗya mi nyaŋgwɛ mɛbɔnɛ, ɓo ta teɗye sendi wunɛ mɛbɔnɛ ɗete. Ŋgɛ ɓɛ nde, ɓo ɓakiɗya mɛlɛpi mɛmbɛ, ɓo ta ɓakiɗye sendi mɛlɛpi mun. ");
INSERT INTO kkj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yo nde, ɓo ta kelɔ mɛyasi mɛnɔri hɛnɛ nɛ wunɛ kɛto ɗinɔ ɗyembɛ, kɛto ɓo yeti kɛ duwɛ Mɔ te ɛ tomma mi njesɛ kɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mi má ɗiy kinɛ nje, ɗiyɔ sendi kinɛ lɛpina nyɛ ɓo na, ma mɛɓeyɔ yeti kɛ to yan na. Ma ndana mi ma si nje lɛpina nyɛ ɓo. Ɗete, ɓo yeti se nɛ gbɛla mɔnɔ yaŋa te yi ɓo yakama jɔse kɛ kasi mɛɓeyɔ man na. ");
INSERT INTO kkj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mɔ te ɛ ɓenɛ mi, mɔ te ɓenma sendi Saŋmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi má ɗiy kinɛ kelɔ yiŋa mɛkele mɛte yi mumɔ wɛtɛ nɛ wɛtɛ tì kelɛ nɛ toru, ma mɛɓeyɔ yeti kɛ to yan na. Ma ndana ɓo ɓɛŋma nyaŋgwɛ mɛkele mɛte yi mi kelma kɛ́, ko ɓɛkɔ ɗete, ɓo kɛ ɓenɔ mi sinɛ Saŋmbɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yo nde, mɛyasi mɛte kélnaŋgwɛ ɗete yí tonjɛ nɛ mɛyasi mɛte yi yo kɛtinate kɛ mɛkana mɛ mɛmboŋga man kɛ́. Yo kɛtinate nde: ‹Ɓo ɓenma mi kinɛ to te na.› ");
INSERT INTO kkj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«*Mɔ mɛkamna wun ta nje. Mi ta njesɛ nyɛ wulɛ pɛ yi Da. Yo Sisiŋ te ɛ gbakasi, Sisiŋ te ɛ pundɛ wulɛ kɛ yi Da. Kɛ ŋgimɔ te yi nyɛ ta nje kɛ́, a ta lɛpɔ yasi te yi nyɛ duwa̧ kɛ kasi mbɛ kɛ́ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma wunɛ ta lɛpɔ sendi yasi te yi wunɛ duwa̧ nɛ̀ yi wunɛ ɓɛŋma kɛ kasi mbɛ kɛ́, kɛto sinɛ wunɛ kɛ joŋna wɛtɛ njombu yaŋa.» ");
INSERT INTO kkj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mɛyasi maka yi mi lɛpima nyɛ wunɛ kɛ́, mi lɛ́pi, kambɔ wunɛ mɛ nje ɗiyɔ kinɛ tikɔ se temɔ nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓo ta kiɗyɛ wunɛ nde, wunɛ tî nata se mɛmbanjɔ mɛwesiɗya man wɛtɛ yesɔ na. Gba ŋgimɔ ta ɗya̧ yi ɓo ta wo wunɛ, takɛ nde, yite yi ɓo kelɛ kɛ́, ɓo kɛ kanɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓo ta kelɔ mɛyasi mɛnɔri, kɛto ɓo tì duwɛ ko Da ko mi na. ");
INSERT INTO kkj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yo nde, mi lɛ́pi mɛyasi maka nyɛ wunɛ, simande komɛ ŋgimɔ te ta ɗya̧ kɛ́, nɛ́ wunɛ nje taki duwɛ nde, mi ma kandɛ lɛpɔ nyɛ wunɛ. Yasi wɛtɛ, mi tì lɛpɛ mɛyasi mɛte nyɛ wunɛ kɛ ŋgimɔ te yi mi kandima nɛ teɗya yun mɛyasi kɛ́ na, kɛto mi ɓa̧ ndi sinɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Ma ndana mi kɛ yɔkwɛ kɛ̀ pɛ yi Mɔ te ɛ tomma mi njesɛ kɔ. Ma ko mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yun yeti kɛ diyɛ mbɛy te yi mi kɛ̀ kɛte kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yasi wɛtɛ, temɔ yun ma tondɔ nɛ ŋgambi kɛto lɛpi te yi mi lɛpima nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yo nde, yo gba gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Yo ta ɓɛ kimɔte pɛ yun nde, mi kwâŋ, kɛto ŋgɛ mi ɗiyɛ kinɛ kwa̧ na, *Mɔ mɛkamna tí nje pɛ yun na. Yasi wɛtɛ, ŋgɛ mi kwa̧, mi ta tomɔ nyɛ njesɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma komɛ nyɛ ta nje kɛ́, a ta teɗye ɓotu ɓe mɛnɛti maka nɛ saŋsaŋ nde, kɛ kasi mɛɓeyɔ, mɛtakɛ man kɔtute. Kɛ kasi ŋgbeŋ mɛkele nɛ̀ kɛ kasi pɛsina jɔsi te yi Njambiyɛ, mɛtakɛ man sendi kɔtute. ");
INSERT INTO kkj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A ta teɗye ɓo nde, mɛtakɛ man kɔtute kɛ kasi mɛɓeyɔ, kɛto ɓo yeti kɛ tikɔ temɔ nɛ mi na. ");
INSERT INTO kkj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Sendi, mɛtakɛ man kɔtute kɛ kasi ŋgbeŋ mɛkele, kɛto mi kɛ yɔkwɛ kɛ̀ pɛ yi Da. Ɗete, wunɛ tí ɓɛŋɛ se mi na. ");
INSERT INTO kkj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A ta teɗye sendi ɓo nde, mɛtakɛ man kɔtute kɛ kasi pɛsina jɔsi te yi Njambiyɛ, kɛto Njambiyɛ sima pɛsɔ jɔsi *Kum mɛnɛti maka. ");
INSERT INTO kkj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mi ndi nɛ ɓuɗya mɛyasi mɛte yi mi yakama lɛpɔ nyɛ wunɛ, yasi wɛtɛ, wunɛ ti yaka wokɔ mɛyasi mɛte ndana na. ");
INSERT INTO kkj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Komɛ Sisiŋ te ɛ gbakasi ta nje kɛ́, a ta teɗye wunɛ yasi hɛnɛ te yi ɓɛ gbakasi kɛ́. Yo nde, a tí lɛpina nɛ ɗeti te yenɛ nɛ ŋguru wenɛ na, yasi wɛtɛ, a ta lɛpɔ yasi hɛnɛ te yi nyɛ wokuma kɛ numbu Da kɛ́. A ta nje pelɛ mɛyasi mɛte yi ta kwaŋna kɛ́ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yo nyɛ ta punjɛ mɛluksa mɛmbɛ, kɛto a ta ɓu̧ lɛpi kɛ numbu mbɛ nje pelɛ nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yasi hɛnɛ te yi Da nɔ, yo yembɛ. Yo kɛto te yite yi mi lɛpima nde: A ta ɓu̧ lɛpi kɛ numbu mbɛ nje pelɛ nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt, wunɛ tí ɓɛŋɛ se mi na. Ɗiyɔ kɛ kɔŋte sendi nɛ mbɛt, wunɛ má nje ɓɛŋɛ sendi mi nɛ kɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ndana, ɛ ɓaŋa ɓejekɛ ɓenɛ lɛpɛ tandɛ yan nde: «’A kwáɗyikwɛ lɛpɔ nɛ ŋge nyɛ wusɛ? Yiŋa nde: ‹Ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt, wunɛ tí ɓɛŋɛ se mi na. Ɗiyɔ kɛ kɔŋte sendi nɛ mbɛt, wunɛ má nje ɓɛŋɛ sendi mi nɛ kɔkɔ,› yiŋa sendi nde: ‹Kɛto mi kɛ yɔkwɛ kɛ̀ pɛ yi Da,› a kwáɗyikwɛ lɛpɔ nɛ ŋge nyɛ wusɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɛ ɓo kɛ̀ mbɔmbu lɛpɔ nde: «Yiŋa nde: ‹Ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt,› to lɛpi te yi nyɛ lɛpɛ ɗete kɛ́ nɛ ŋge? Wusɛ yeti kɛ ɓiye su to te na.» ");
INSERT INTO kkj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus duwa̧ nde, ɓo kwaɗya diyɛ nyɛ yiŋa yasi. Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ kɛ diyna tandɛ yun kɛ lɛpi te yi mi lɛpima nde: ‹Ɓukwa̧ ndi mɔnɔ ŋgimɔ nɛ mbɛt, wunɛ tí ɓɛŋɛ se mi, ɗiyɔ kɛ kɔŋte sendi nɛ mbɛt, wunɛ má nje ɓɛŋɛ sendi mi nɛ kɔkɔ kɛ́.› ’Wunɛ díynaŋgwɛ kɛto te yite? ");
INSERT INTO kkj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Wunɛ ta lelɔ gbate jaɓa, ɓotu ɓe mɛnɛti maka ta ɓɛ nɛ mɛsosa. Wunɛ ta kpalɔ ɓɛ nɛ ŋgambi, yasi wɛtɛ, ŋgambi yun ta nje yeŋsa ɓɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kɛ ŋgimɔ te yi nyari kɛ wa nɛ mi̧ kɛ́, temɔ nɛ ɗekɛ nɛ haɓuɓu, kɛto ŋgimɔ mɛbɔnɛ mɛte yenɛ ɗyaŋma. Yasi wɛtɛ, ŋgɛ nyɛ si punjɛ mɔnɔsikɛ kɛ puyɛ, a yeti kɛ takɛ se mɛbɔnɛ mɛte yite na, kɛto mɛsosa mɛte yi nyɛ mɛ nɔ kɛ́, kɛto a jama mumɔ njesɛ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wunɛ sendi ndana ɗete, mɛtemɔ mun nɛ ŋgambi. Ndi nde, mi ta ɓasiɗye ɓɛŋɛ wunɛ nɛ kɔkɔ, komɛte, wunɛ ta ɓɛ nɛ mɛsosa. Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ta soŋɛ mɛsosa mɛte kɛ temɔ yun na. ");
INSERT INTO kkj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Komɛ yesɔ te ta ɗya̧ kɛ́, wunɛ tí diyɛ mi mɛdiyan na. Gbakasi yi mi lɛpɛ nyɛ wunɛ kɛ́: Ŋgɛ wunɛ diyɛ Da yiŋa yasi nɛ ɗinɔ ɗyembɛ, a ta nyɛ wunɛ yo. ");
INSERT INTO kkj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kumɔ ndana wunɛ tì pa diyɛ yiŋa yaŋa nɛ ɗinɔ ɗyembɛ na. Wunɛ dîya, nɛ ta ɓɛ nɛ ya te. Ɗete, mɛsosa mɛte yi wunɛ ɓɛ nɔ kɛ́ ta tondɔ temɔ yun nɛ ŋgbɛŋ. ");
INSERT INTO kkj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mi lɛpima mɛyasi mɛte nyɛ wunɛ nɛ nje mɛkanɔ. Ŋgimɔ kɛ nje, ŋgimɔ te yi mi tí lɛpina se nyɛ wunɛ nɛ nje mɛkanɔ na. Yasi wɛtɛ, mi ta kombile lɛpɔ kasi Da nɛ gbas gbas nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Komɛ yesɔ te ta ɗya̧ kɛ́, wunɛ ta diyɛ Da yasi nɛ ɗinɔ ɗyembɛ. Mi yeti kɛ lɛpɔ nyɛ wunɛ nde, mi ta diyɛ Da yiŋa yaŋa kɛ numbu yun na. ");
INSERT INTO kkj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yo nde, Da nɛ ŋguru wenɛ kɛ kwaɗyɛ wunɛ, kɛto wunɛ kwaɗya mi tikɔ temɔ nde, mi wúla kɛ yi Njambiyɛ nje nɔ. ");
INSERT INTO kkj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi wúla kɛ yi Da nje nɔ kɛ mɛnɛti maka. Ma ndana mi kɛ ɗuwɛ kɛ̀ mɛnɛti maka yɔkwɛ kɛ̀ pɛ yi Da.» ");
INSERT INTO kkj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɛ ɓejekɛ ɓenɛ nje lɛpɔ nyɛ nyɛ nde: «Ɓɛŋa, ndana wɛ kɛ lɛpina nɛ gbas gbas kinɛ lɛpina se nɛ nje mɛkanɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndana wusɛ duwa̧ nde, wɛ kɛ duwɛ mɛyasi hɛnɛ. Wɛ kɛ kandɛ si duwɛ yasi te yi mumɔ kɛ kwaɗyɛ diyɛ wɛ kinɛ nde, wɛtɛ mumɔ pâŋ pa diyɛ wɛ yiŋa mɛdiyan na. Ɗete, wusɛ kɛ tikɔ temɔ nde, wɛ wúla kɛ yi Njambiyɛ nje nɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ɛ nyɛ yeŋsa nyɛ ɓo nde: «’Yo ndana yi wunɛ nje tikɔ temɔ nɛ mi yɛy? ");
INSERT INTO kkj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nɛ ɓɛ̂ŋa, ŋgimɔ kɛ nje, yo ma ɗya̧, ŋgimɔ te yi wunɛ ta wanja wɛtɛ wɛtɛ, mumɔ hɛnɛ kɛ tɔkɛ nje tu̧ ɗyenɛ tikɔ mi nyɛpɔ. Ko ɓɛkɔ ɗete, mi yeti nyɛpɔ na, kɛto Da pɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi lɛ́pi mɛyasi maka hɛnɛ nyɛ wunɛ, nɛ́ wunɛ ɓɛ nɛ tɛ, kɛto wunɛ mɛ saŋgwate nɛ mi. Wunɛ ta saŋgwa nɛ mɛbɔnɛ kɛ to mɛnɛti maka. Yasi wɛtɛ, wunɛ tî kambi yaŋa na, kɛto mi ma laŋsa mbɛ ɗeti mɛnɛti maka.» ");
INSERT INTO kkj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kɛ Yesus ma si lɛpɔ mɛlɛpi mɛnɔri kɛ́, ɛ nyɛ kaŋɛ misi kɛnjɛ kwey lɛpɔ nde: «Da, ŋgimɔ ma ɗya̧, punjukwɛ mɛluksa mɛ Mɔnɔ wɔ, nɛ́ Mɔnɔ wɔ punjɛ mɛluksa mɔ, ");
INSERT INTO kkj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kɛto wɛ nya nyɛ ɗeti te yi namɔ ɓomɔ hɛnɛ, na kel nde, ɓomɔ hɛnɛ te yi wɛ nya nyɛ ɓaka ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo. ");
INSERT INTO kkj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Joŋgwɛ te yi kpo nɛ kpo, yo nde, ɓo dûkwɛ wɛ, wɛ siya kpasa Njambiyɛ te ɛ kɛte gbate, duwɛ sendi Yesus Krist, yɔkɔ yi wɛ tomma kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi punja mɛluksa mɔ kɛ mɛnɛti maka, siɗyɛ sendi mɛsay mɛte yi wɛ nya mi nde, mi kêl kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma Da, ndana punjukwɛ mɛluksa mɛmbɛ kɛ kɛki yɔ. Punjukwɛ mɛluksa mɛte yi mi ɓa̧ nɔ kɛ kɛki yɔ yite mbokɔ tì pa kusuna kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Mi kelma nde, ɓotu ɓete ɓe wɛ soŋma kɛ njoka ɓotu ɓe mɛnɛti nyɛ mi ɓaka dûkwɛ ɗinɔ ɗyɔ. Ɓo ɓa̧ ɓotu ɓɔ, ɛ wɛ kaŋɛ ɓo nyɛ mi, ɛ ɓo ɓakiɗye mɛlɛpi mɔ. ");
INSERT INTO kkj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma ndana ɓo ma duwɛ nde, mɛyasi hɛnɛ te yi wɛ nya mi kɛ́ wúla gbate kɛ yɔ, ");
INSERT INTO kkj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kɛto mɛlɛpi mɛte yi wɛ teɗya mi kɛ́, mi kwaŋɗya yo nyɛ ɓo, ɛ ɓo tikɛ temɔ kɛte. Ɓo duwa̧ gbate nde, mi wúla pɛ yɔ nje nɔ, ɛ ɓo tikɛ temɔ nde, yo gba wɛ tomɛ mi njesɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi ŋgwɛ́taŋgwɛ nɛ wɛ kɛto yan, yeti kɛto ɓotu ɓe mɛnɛti maka na. Mi ŋgwɛ́taŋgwɛ nɛ wɛ ndi kɛto ɓotu ɓete yi wɛ nya mi ɓaka, kɛto ɓo wókunaŋgwɛ nɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɛyasi hɛnɛ te yi mi nɔ, yo yɔ. Sendi, mɛyasi hɛnɛ te yi wɛ nɔ, yo yembɛ. Ɓotu ɓete ɓe wɛ nya mi ɓaka kɛ punjɛ mɛluksa mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi yeti se kɛ mɛnɛti maka na, ndi ɓo kɛ tika kɛ mɛnɛti maka. Ma mi kɛ yɔkwɛ mbɛ kɛ̀ pɛ yɔ. Da, wɛ kiyɔ, ɓakiɗya ɓo nɛ ɗeti te yi wulɛ kɛ ɗinɔ ɗyɔ yi wɛ nya mi kɛ́, nɛ́ ɓo ɓɛ ndi yasi wɛtɛ nda sinɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kɛ ŋgimɔ te yi mi ɓa̧ sinɛ ɓo kɛ́, mi ɓakiɗya ɓo nɛ ɗeti te yi wulɛ kɛ ɗinɔ ɗyɔ yi wɛ nya mi kɛ́. Mi ɓakiɗya ɓo nda mbumɔ misi mɛmbɛ. Ko wɛtɛ kɛ njoka yan tì yambile na, soŋɛ ndi yɔkɔ yi ɓa̧ kponate kɛ yenɛ nde, a ta yambile kɔ. Yo kélnaŋgwɛ ɗete, nɛ́ mɛyasi mɛte yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tondu. ");
INSERT INTO kkj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ma ndana mi kɛ yɔkwɛ kɛ̀ pɛ yɔ. Mi lɛ́pi mɛyasi maka kɛ ŋgimɔ te yi mi ndi kɛ mɛnɛti maka kɛ́, nɛ́ mɛsosa tondu kɛ temɔ yan nda yi mi nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi kwaŋɗya mbɛ lɛpi yɔ nyɛ ɓo, ɛ ɓotu ɓe mɛnɛti maka ɓenɛ ɓo, kɛto ɓenɛ ɓotu ɓe mɛnɛti maka yeti saŋgwate na nda yi mi sendi yeti saŋgwate sinɛ ɓotu ɓe mɛnɛti maka kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi ti ŋgwɛ́taŋgwɛ nɛ wɛ nde, soŋa ɓo kɛ mɛnɛti maka na. Yo nde, ɓakiɗya ɓo, kambɔ nɛ *Mɔ ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓenɛ ɓotu ɓe mɛnɛti maka yeti saŋgwate nda yi mi yeti sendi saŋgwate sinɛ ɓotu ɓe mɛnɛti maka kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kelɔ nde, ɓo ɓɛ̂ki ɓotu ɓɔ nɛ nje mɛlɛpi mɔ yi ɓɛ gbakasi. Gba mɛlɛpi mɔ ndi gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mi kɛ tomɔ ɓo kɛnjɛ kɛ mɛnɛti maka nda yi wɛ tomma nɛ mi njesɛ kɛ mɛnɛti kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yo kɛ gba to yan yi mi nɛ ŋguru wombɛ kɛ kaŋɛ yotu mbɛ nyɛ wɛ, nɛ́ ɓo sendi kaŋ mɛyotu man gbate nyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Yo nde, mi ti ŋgwɛ́taŋgwɛ nɛ wɛ ndi kɛto yan ɓepɔ na. Yasi wɛtɛ, mi ŋgwɛ́taŋgwɛ sendi nɛ wɛ, kɛto ɓotu ɓete ɓe ta tikɔ temɔ nɛ mi kɛto lɛpi te yi ɓo ta lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mi ŋgwɛ́taŋgwɛ nɛ wɛ, nɛ́ ɓo hɛnɛ ɓɛ ndi yasi wɛtɛ nda yi wɛ Da ɗiyɛ nɔ pɛ yembɛ, mi sendi pɛ yɔ kɛ́. Mi ŋgwɛ́taŋgwɛ, nɛ́ ɓo sendi ɓɛ saŋgwate sinɛ ɓo, nɛ́ ɓotu ɓe mɛnɛti maka jay nde, yo wɛ tomɛ mi njesɛ. ");
INSERT INTO kkj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi kelma sendi nde, ɓo ɓɛ̂ki nɛ kiya mɛluksa mɛte yi wɛ kelma nde, mi ɓɛ̂ki nɔ kɛ́, nɛ́ ɓo ɓɛ ndi yasi wɛtɛ nda yi sinɛ wɛ ɗiyɛ nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi pɛ yan, wɛ pɛ mi, nɛ́ ɓo ɓɛ saŋgwate ndi wɛtɛ. Ɗete, ɓotu ɓe mɛnɛti maka ta duwɛ gbate nde, wɛ tomɛ mi njesɛ, nɛ́ ɓo duwɛ sendi nde, wɛ kɛ kwaɗyɛ ɓotu ɓete nda yi wɛ kwaɗyɛ nɛ mi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Da, mi kwáɗyikwɛ gba nde, mi ɗîy gba sinɛ ɓotu ɓete ɓe wɛ kaŋma nyɛ mi ɓaka kɛ mbɛy te yi mi ɗiyɛ kɛte kɛ́. Mi kwáɗyikwɛ ɗete, nɛ́ ɓo ɓɛŋ mɛluksa mɛte yi wɛ nya mi kɛ́. Wɛ nya mi mɛluksa mɛte, kɛto wɛ kwaɗya mi yite mbokɔ tì pa kusuna na. ");
INSERT INTO kkj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Da, wɛ yɔkɔ ɛ kelɛ yasi nɛ ŋgbeŋ, yo nde, ko ɓotu ɓe mɛnɛti maka tì duwɛ wɛ na, ndi mi duwa̧ wɛ, ɛ ɓaka duwɛ nde, yo wɛ tomɛ mi. ");
INSERT INTO kkj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi téɗya ɓo ɗinɔ ɗyɔ. Mi ta kɛ̀ mbɔmbu yí teɗye ɓo, nɛ́ mɛkwaɗya mɛte yi wɛ kwaɗya nɛ mi kɛ́ ɓɛ sendi pɛ yan, nɛ́ mi nɛ ŋguru wombɛ ɓɛ pɛ yan.» ");
INSERT INTO kkj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kɛ Yesus ma si lɛpina ɗete kɛ́, ɛ nyɛ pundɛ kwa̧ ɓenɛ ɓejekɛ ɓenɛ kɛ̀ kɛ ŋginjɛ mɔnɔ soy te yi Sedrɔŋ. Wɛtɛ ŋgwaŋ ɓa̧ womɛte, ɛ Yesus kwa̧ nyiŋɛ mɔy ŋgwaŋ ɓenɛ ɓejekɛ ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ duwa̧ sendi mbɛy yinɔri, kɛto Yesus ɓenɛ ɓejekɛ ɓenɛ ɗikima kɛ̀ wesiɗya mate. ");
INSERT INTO kkj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ɛ Yudas ɓu̧ njɔŋ ɓesɔja nɛ̀ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ ɗya̧ nɔ. Yo ɓe ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ *Ɓefarisɛ̧ tomɛ ɓo. Ɓo ka̧ nɛ mɛlambo nɛ̀ mɛnyan nɛ̀ mɛjɔlɛ mɛ ɗyambi. ");
INSERT INTO kkj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus ma duwɛ yasi hɛnɛ te yi yâkaŋgwɛ ɗya̧ nyɛ kɛ́. Ɛ nyɛ kɛ̀ kɛ mbɔmbu yan diyɛ ɓo nde: «Wunɛ sáŋ nda?» ");
INSERT INTO kkj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Wusɛ sáŋ Yesus te mɔ Nasarɛt.» Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Yo mi.» Yinɔri Yudas mɔ te ɛ ta ɗyaŋgwɛ nyɛ kɔ ɓa̧ ɓenɛ ɓotu ɓenɔri. ");
INSERT INTO kkj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kɛ Yesus ma lɛpɔ nyɛ ɓo nde: ‹Yo mi› kɛ́, ɛ ɓo yɔkwɛ nɛ kɔŋ ɓalɔ kɛ mɛnɛti nɛ mbelele. ");
INSERT INTO kkj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɛ Yesus ɓasiɗye diyɛ ɓo nde: «Wunɛ sáŋ nda?» Ɛ ɓo lɛpɛ nde: «Wusɛ sáŋ Yesus te mɔ Nasarɛt.» ");
INSERT INTO kkj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ɛ nyɛ yeŋsa nde: «’Mi tì si lɛpɔ nyɛ wunɛ nde, yo mi na? Ŋgɛ ɓɛ nde, wunɛ sáŋ mi, wunɛ tîki ɓotu ɓete ɓaka, nɛ́ ɓo kwa̧.» ");
INSERT INTO kkj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A lɛ́pi ɗete, nɛ́ lɛpi te yi nyɛ ma lɛ́pi kɛ́ si tondu. A ma lɛ́pi nde: ‹Kɛ njoka ɓotu ɓete yi wɛ nya mi ɓaka, mi tì kelɛ nde, wɛtɛ nɛ wɛtɛ yâmbila na.› ");
INSERT INTO kkj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔn Piyɛr ɓa̧ nɛ kafa. Ɛ nyɛ sutɛ yo kɔtɔ nɛ mɔ mɛsay mɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ pɛsɔ tɔ nɛ ɛ mbam ɓɔ ɓetɛ kɛ mɛnɛti. Ɗinɔ mɔ mɛsay te ɓa̧ nde Malkus. ");
INSERT INTO kkj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ɛ Yesus lɛpɛ nyɛ Piyɛr nde: «Yɔkiɗya kafa yɔ sɔmɔ kɛ ɓambi te. ’Wɛ táka ka nde, mi ɗîy kinɛ hɔɓiye pelɔ mɛbɔnɛ te yi Da nya mi nde, mi hɔ̂ɓiya kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ndana, ɛ ɓesɔja nɛ̀ nyaŋgwɛ kum ɓesɔja nɛ̀ Ɓeyudɛn ɓete ɓe ɗikima ɓakiɗye mbanjɔ Njambiyɛ ɓaka nje ɓiye Yesus wotɔ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɛ ɓo ɓu̧ nyɛ pa kɛ̀ nɔ kɛ yi Hana te ki nɛ Kayif. A ɓa̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kɛ sew te ɛte. ");
INSERT INTO kkj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yo Kayif te ɛ nya Ɓeyudɛn ŋgitɛ lɛpɔ nde: ‹Yo kimɔte nde, mumɔ wɛtɛ gwâki kɛ numbu kandɔ.› ");
INSERT INTO kkj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔn Piyɛr ɓenɛ wɛtɛ jekɛ ɓa̧ kɛ ɓeŋgwɛ Yesus. Nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ duwa̧ jekɛ te kimɔte. Ɛ jekɛ te nyiŋɛ kɛ tu̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓenɛ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yasi wɛtɛ, ɛ Piyɛr tika kɛ numɛy ndoko. Ɛ jekɛ te ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ duwa̧ kɔ pundɛ kɛ̀ lɛpina nyɛ nya te ɛ ɓa̧ sana mate ɛ ɓa̧ kɛ ɓakiɗye numɛy kɔ. Ɛ jekɛ te nyinje Piyɛr kɛ mɔy ndoko. ");
INSERT INTO kkj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɛ nya te nje ɗiyɔ lɛpɔ nyɛ Piyɛr nde: «’Wɛ yeti sendi gba wɛtɛ jekɛ mbam kɔ na?» Ɛ Piyɛr lɛpɛ nde: «Ko na.» ");
INSERT INTO kkj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɗuku ɓa̧ kɛ kwa̧, ɛ ɓotu ɓe mɛsay ɓenɛ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ joŋgwɛ ɗitɛ nɛ mɛma mɛ ɗitɛ kwa̧ wɛtina. Ɛ Piyɛr kwa̧ sendi ɗiyɔ kɛ njoka yan wɛtina ɗitɛ ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ndana, ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ kandɛ diyna Yesus mɛdiyan kɛ kasi ɓejekɛ ɓenɛ nɛ̀ kɛ kasi yasi te yi nyɛ ɗikima teɗye ɓomɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «Mi ɗikima lɛpina nɛ gbas gbas nyɛ ɓomɔ kɛ puyɛ. Mi ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ kpo nɛ kpo kɛ mbanjɔ mɛwesiɗya nɛ̀ kɛ mbanjɔ Njambiyɛ kɛ mbɛy te yi Ɓeyudɛn hɛnɛ ɗiki wesiɗya kɛ́. Mi tì lɛpɛ yiŋa yaŋa sɔɗyate na. ");
INSERT INTO kkj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kɛto ŋge yi wɛ diyɛ mi mɛdiyan kɛ́? Diya ɓotu ɓete ɓe wokuma mi kɛ lɛpina ɓaka, nɛ́ ɓo lɛpi yasi te yi mi lɛpima nyɛ ɓo kɛ́. Ɓotu ɓete duwa̧ yasi te yi mi lɛpima kɛ́ kimɔte.» ");
INSERT INTO kkj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kɛ Yesus ma lɛpɔ ɗete kɛ́, ɛ wɛtɛ mɔ ɓakiɗya mbanjɔ Njambiyɛ te ɛ ɓa̧ kɛ kɛki nɛ kɔ nyɛ nyɛ ɓanji kɛ pokɔ lɛpɔ nde: «’Yo ɗete yi wɛ yeŋsa nyɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ŋgɛ ɓɛ nde, mi lɛpinama ɓeyate, teɗya yasi te yi mi lɛpima ɓeyate kɛ́. Ma ŋgɛ ɓɛ nde, mi lɛpinama kimɔte, wɛ njáki nyɛ mi ɓanji kɛ pokɔ kɛto ŋge?» ");
INSERT INTO kkj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛ Hana nje kwaŋɗye Yesus ndi wotunate kɛnjɛ Kayif te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kɛ ŋgimɔ te yinɔri Simɔn Piyɛr ɓa̧ ndi womɛte kɛ wɛtina ɗitɛ. Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «’Gba wɛ sendi yeti wɛtɛ jekɛ wenɛ na?» Ɛ nyɛ tonɛ lɛpɔ nde: «Ko na.» ");
INSERT INTO kkj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɛ wɛtɛ mɔ mɛsay mɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɛ ɓa̧ nɛ jaɗyɛ ɓenɛ mbam te ɛ Piyɛr pɛsima tɔ nɛ kɔ lɛpɛ nde: «’Mi tì ɓɛŋɛ gba wɛ wúnɛ nyɛ kɛ ŋgwaŋ na?» ");
INSERT INTO kkj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ɛ Piyɛr tonɛ sendi, yaka nɛ mbam kuɓɛ kɛ kɔkɔ. ");
INSERT INTO kkj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kɛ kɔŋte, ɛ ɓo ɓu̧ Yesus wulɛ nɔ kɛ̀ yi Kayif kɛ̀ nɔ kɛ tu̧ Pilat te nyaŋgwɛ kum. Yinɔri yo ɓa̧ ɓemɛŋmɛnɛ nɛ sut. Ɓo nɛ ŋguru wan tì nyiŋɛ mɔy tu̧ na, kambɔ yo mɛ nje ɓɛ yasi sɛmbɔ kɛ yan, ɓo mɛ nje ɗiyɔ kinɛ ɗye mɛɗye mɛ jesɔ *Paska yan na. ");
INSERT INTO kkj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ɛ Pilat pundɛ kɛ̀ dolɔ ɓo mate lɛpɔ nde: «Yo kwalɔ ɓeya yasi te nda yi wunɛ lɛpɛ nde, mbam kɔ kelma kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɛ ɓo yeŋsa nyɛ nyɛ nde: «A má ɗiy kinɛ ɓɛ nyaŋgwɛ mɔ kelna ɓeya mɛkele na, ma wusɛ tì ɓu̧ nyɛ kaŋɛ nyɛ wɛ na.» ");
INSERT INTO kkj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ɛ Pilat lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun ɓôŋ nyɛ kɛ̀ pɛsɔ lɛpi nɛ ɓeŋgwɛ mɛmboŋga mun.» Ɛ Ɓeyudɛn yeŋsa nyɛ nyɛ nde: «Mɛmboŋga musu yeti kɛ nyɛ wusɛ ɗeti nde, wusɛ wôku mumɔ na.» ");
INSERT INTO kkj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɓo lɛpinama ɗete, nɛ́ lɛpi te yi Yesus lɛpima kɛ kasi kwalɔ sɔŋ te yi nyɛ yâkaŋgwɛ saŋgwa nɔ kɛ́ si tondu. ");
INSERT INTO kkj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ndana, ɛ Pilat yɔkwɛ nɛ kɔkɔ nyiŋɛ tu̧ jeɓa Yesus diyɛ nyɛ nde: «’Yo wɛ, kumande Ɓeyudɛn?» ");
INSERT INTO kkj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «’Yo wɛ nɛ ŋguru wɔ lɛpɛ ɗete, ho nde, ɓaŋa ɓomɔ lɛpɛ ɗete nyɛ wɛ kɛ kasi mbɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ɛ Pilat yeŋsa nyɛ nyɛ nde: «’Wɛ ɓɛŋma nde, mi Ɓeyudɛn? Yo ɓotu ɓe kandɔ yɔ nɛ̀ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓu̧ wɛ kaŋɛ nyɛ mi. Wɛ kelma yasi te nda?» ");
INSERT INTO kkj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ɛ Yesus yeŋsa nde: «*Kandɔ ɗyembɛ ti wúla kɛ mɛnɛti maka na. Kandɔ ɗyembɛ má wula kɛ mɛnɛti maka, ma ɓotu ɓe mɛsay ɓembɛ loŋma ɗyambi kɛto mbɛ, kambɔ ɓomɔ mɛ nje ɓu̧ mi nyɛ kɛ mɔy mɛɓɔ mɛ Ɓeyudɛn. Yasi wɛtɛ, Kandɔ te yembɛ ti wúla kɛ mɛnɛti maka na.» ");
INSERT INTO kkj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ɛ Pilat diyɛ nyɛ nde: «’Wɛ gbate kumande?» Ɛ Yesus yeŋsa nde: «Yo nda yi wɛ lɛpɛ kɛ́, mi kumande. Mi jaɗya, mi nja̧ kɛ mɛnɛti maka yí nje teɗye ɓomɔ mɛyasi kɛ kasi gbakasi. Mumɔ hɛnɛ ɛ ɓeŋgwɛ lɛpi te yi ɓɛ gbakasi kɛ wokɔ yasi te yi mi lɛpɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ɛ Pilat diyɛ nyɛ nde: «Gbakasi, yo ŋge?» Kɛ Pilat ma si lɛpɔ ɗete kɛ́, ɛ nyɛ ɓasiɗye pundɔ kɛ̀ dolɔ Ɓeyudɛn lɛpɔ nyɛ ɓo nde: «Mi tì dolɛ mbɛ yiŋa mɛjɔsɔ kɛ yotu mbam kɔ yi yakama kelɔ nde, a sɔ̂mbu mɛbɔnɛ kɛto te na. ");
INSERT INTO kkj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yasi wɛtɛ, yo mɛ kɛ mɛkiyɔ mun nde, kɛ jesɔ *Paska yun hɛnɛ, mi kɛ̂ soŋa ɓɔ nɛ wɛtɛ mɔ jɔɓɔ yɔkiɗye nyɛ nyɛ wunɛ. ’Ɗete, wunɛ kwáɗyikwɛ nde, mi sôŋa ɓɔ nɛ kumande Ɓeyudɛn yɔkiɗye nyɛ nyɛ wunɛ?» ");
INSERT INTO kkj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɛ ɓo kala kembiɗya lɛpɔ nde: «Ɓɛ, yeti nyɛ na! Hɛ kwáɗyikwɛ su Barabas.» Barabas ɓa̧ nyaŋgwɛ mɔ ɓeya mɛkele. ");
INSERT INTO kkj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ndana, ɛ Pilat nyɛ ɓesɔja ɗeti nde, ɓo ɓôŋ Yesus kɛ̀ njurɔ nyɛ nɛ njambala. ");
INSERT INTO kkj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɛ ɓo ɓu̧ yiŋa mɛkɔl nɛ mɛsɔru kɛte, jakɔ nɛ ɗuŋgwɛ te lɛnje nyɛ kɛ to, ɓu̧ sendi wɛtɛ kpasa tena nyaŋgwɛ gambo nyɛ nyɛ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɛ ɓo ɗiki nje kɛ kɛki nɛ lɛpɔ nde: «Kumande Ɓeyudɛn, hɛ lɛ̂pi!» Ɛ ɓo ɗiki nyɛ nyɛ ɓanji kɛ pokɔ. ");
INSERT INTO kkj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ɛ Pilat kala pundɔ lɛpɔ nyɛ Ɓeyudɛn nde: «Ndana mi kɛ ɓu̧ nyɛ punjɛ njesɛ sɛ̧, nɛ́ wunɛ duwɛ nde, mi tì dolɛ mbɛ yiŋa mɛjɔsɔ kɛ yotu nɛ yi yakama kelɔ nde, a sɔ̂mbu mɛbɔnɛ kɛto te na.» ");
INSERT INTO kkj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ɛ Yesus pundɛ nɛ ɗuŋgwɛ mɛsɔru kɛ to nɛ̀ tena kpasa nyaŋgwɛ gambo kɛ yotu. Ɛ Pilat lɛpɛ nyɛ ɓo nde: «Ma mbam te kɔ!» ");
INSERT INTO kkj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ ma kaŋɛ misi ɓɛŋɛ nɛ Yesus kɛ́, ɛ ɓo kembiɗya lɛpɔ nde: «Ŋgbakɔ nyɛ kɛ kroa! Ŋgbakɔ nyɛ kɛ kroa!» Ɛ Pilat lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun ɓôŋ nyɛ kɛ̀ ŋgba kɛ kroa, kɛto mi tì dolɛ mbɛ yiŋa yaŋa kɛ yotu nɛ yi yakama kelɔ nde, a sɔ̂mbu mɛbɔnɛ kɛto te na.» ");
INSERT INTO kkj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ɛ Ɓeyudɛn yeŋsa nyɛ nyɛ nde: «Wusɛ nɛ wɛtɛ mboŋga, mboŋga te kɛ teɗye nde, a yâkaŋgwɛ gwe, kɛto a ɓoŋma yotu nɛ nde, nyɛ Mɔnɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kɛ Pilat ma wokɔ ɗete kɛ́, ɛ nyɛ gwe wɔ̧ kwa̧ to te. ");
INSERT INTO kkj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɛ nyɛ yɔkwɛ nɛ kɔkɔ nyiŋɛ tu̧ diyɛ Yesus nde: «Wɛ wúla we nje nɔ?» Ko Yesus kinɛ yeŋsa yaŋa nyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɛ Pilat lɛpɛ nyɛ nyɛ nde: «’Wɛ ɗíy kinɛ yeŋsa kɛ numbu mbɛ? ’Wɛ yeti kɛ duwɛ nde, mi nɛ ɗeti te yi soŋɛ ɓɔ nɛ wɛ, mi sendi nɛ ɗeti te yi lɛpɔ nde, ɓo ŋgbâki wɛ kɛ kroa na?» ");
INSERT INTO kkj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ŋgɛ Njambiyɛ ti nyɛ wɛ ɗeti wulɛ kɛ kwey na, wɛ ti yaka kelɔ yaŋa nɛ mi na, ɗete mɔ te ɛ ɗyaŋgwa mi nyɛ wɛ kɔ kelma ɓeya yasi kwa̧ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kandɛ kɛ ŋgimɔ te yite, ɛ Pilat sa̧ nje te yi soŋɛ ɓɔ nɛ nyɛ. Yasi wɛtɛ, ɛ Ɓeyudɛn ɗiki kembiɗya nde: «Ŋgɛ wɛ soŋɛ ɓɔ nɛ mbam kɔ, yite wɛ yeti sɔ nɛ *Sesar na! Mumɔ hɛnɛ ɛ lɛpɛ nde, nyɛ kumande, mɔ te kɛ lu̧ ɗyambi suŋgwɛ nɛ Sesar.» ");
INSERT INTO kkj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kɛ Pilat ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ nyɛ ɓu̧ Yesus punjɛ kɛnjɛ sɛ̧ kwa̧ ɗiyɔ mɛtiɗyɛ kɛ mbɛy pɛsina jɔsi. Ɓo kombila mbɛy te nɛ mɛtari. Ɓo jéɓaŋgwɛ mbɛy te kɛ numbu Hebere nde Gabata. ");
INSERT INTO kkj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yinɔri yo ɓa̧ ŋgimɔ kombila mɛyasi mɛ jesɔ *Paska Ɓeyudɛn. Yo ɓa̧ kɛ pɔku ɓembe yesɔ. Ɛ Pilat lɛpɛ nyɛ Ɓeyudɛn nde: «Kumande wun ru!» ");
INSERT INTO kkj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yasi wɛtɛ, ɛ ɓo kembiɗya nde: «Soŋa ɗyan kɛ misi mɛnɛ! Soŋa ɗyan kɛ misi mɛnɛ! Ŋgbakɔ nyɛ kɛ kroa!» Ɛ Pilat lɛpɛ nyɛ ɓo nde: «Mi ŋgbâki kumande wun kɛ kroa?» Ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ yeŋsa nde: «Wusɛ kinɛ wɛtɛ kumande na, ndi Sesar!» ");
INSERT INTO kkj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndana, ɛ Pilat kaŋɛ Yesus nyɛ ɓo, nɛ́ ɓo kɛ̀ ŋgba nyɛ kɛ kroa. Ɛ ɓo ɓu̧ nyɛ kwa̧ nɔ. ");
INSERT INTO kkj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɛ Yesus nɛ ŋguru wenɛ soɓɛ kroa nɛ yí kwa̧ nɔ ɗuwɛ kɛ mɔy ɗya kumɔ nɔ kɛ wɛtɛ mbɛy nde Gboŋgo to, ɓo jéɓaŋgwɛ kɛ numbu Hebere nde Golgota. ");
INSERT INTO kkj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kumɔ mate, ɛ ɓo ŋgba nyɛ kɛ kroa, ŋgba sendi ɓaŋa ɓomɔ yiɓa kɛ mɛkroa mɛte yan. Wɛtɛ kɛ kroa te wenɛ pulɔ kaka, wɛtɛ pulɔ kaka, tikɔ Yesus kɛ ɓembe. ");
INSERT INTO kkj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat lɛpima nde, ɓo kɛ̂ti yiŋa yasi ŋgba kɛ to kroa Yesus. Ɛ ɓo kɛtɛ nde: ‹Yesus te mɔ Nasarɛt, kumande Ɓeyudɛn.› ");
INSERT INTO kkj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɓeyudɛn ɓuɗyate tɔlma yasi yinɔri, kɛto mbɛy te yi ɓo ŋgbama Yesus kɛ kroa kɛte kɛ́ ɓa̧ kɛ kɛki ɗya. Sendi, ɓo kɛtima yo kɛ mɛnumbu yitati: Kɛ numbu Hebere, kɛ numbu Latɛ̧ nɛ̀ kɛ numbu Grɛk. ");
INSERT INTO kkj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka ɓe Ɓeyudɛn lɛpɛ nyɛ Pilat nde: «Wɛ tî kɛti nde: ‹Kumande Ɓeyudɛn› na, yasi wɛtɛ, kpalɔ kɛtɔ nde: ‹Nyɛ nɛ ŋguru wenɛ lɛpima nde: Mi kumande Ɓeyudɛn.› » ");
INSERT INTO kkj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ɛ Pilat yeŋsa nde: «Yasi te yi mi ma kɛtɔ siyma ndi ɗete.» ");
INSERT INTO kkj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kɛ ɓesɔja ma si ŋgba Yesus kɛ kroa kɛ́, ɛ ɓo ɓu̧ mɛlambɔ mɛnɛ kaɓɔ kɛ mɛŋgaɓiyɛ yini yaka nɛ ɓo, ɓu̧ sendi lambɔ te yi nyɛ ɗikima lɛŋɛ kɛ nji̧ mɛlambɔ mɛte yiri kɛ́. Lambɔ te mbɛte tì ɓɛ nɛ nje fulnate na kandɛ kwey kumɔ nji̧. ");
INSERT INTO kkj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɛ ɓo lɛpɛ tandɛ yan nde: «Wusɛ tî nyal yo nyalɔ na, yasi wɛtɛ, wusɛ lôŋ loŋgɔ kɛ mbari yí duwɛ nɛ mɔ te ɛ ta namɔ yo kɔ.» Yo kelnama ɗete, nɛ́ mɛlɛpi mɛte yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tondu. Yo kɛtinate nde: ‹Ɓo kaɓiɗyama mɛlambɔ mɛmbɛ, lu̧ sendi lambɔ te yi mi ɗikima lɛŋɛ kɛ nji̧ mɛlambɔ mɛte yiri kɛ́ kɛ mbari.› Yasi te yi ɓesɔja kelma, yori. ");
INSERT INTO kkj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yinɔri nɛ̀ nyaŋgwɛ nɛ Yesus nɛ̀ maŋ nɛ nyaŋgwɛ nɛ̀ Mariya te nya Kolopas ɓu̧ Mariya te ŋgɔndu Magdala ɓa̧ womɛte kɛ ŋgimɔ te yi Yesus ɓa̧ kɛ kroa kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kɛ Yesus ma ɓɛŋɛ nyaŋgwɛ wenɛ, ɓɛŋɛ sendi jekɛ te yi nyɛ ɗikima kwaɗyɛ ɓuɗyate kɔ womɛte kɛ́, ɛ nyɛ lɛpɛ nyɛ nyaŋgwɛ nde: «Nyari, ɓɛŋa mɔnɔ wɔ kɔ!» ");
INSERT INTO kkj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɛ nyɛ nje lɛpɔ nyɛ jekɛ te nde: «Ɓɛŋa, nyɔŋgwɛ kɔ!» Kandɛ kɛ ŋgimɔ te yite ɛ jekɛ kɔ ɓu̧ nyaŋgwɛ nɛ Yesus kɛ̀ nɔ kɛ tu̧ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kɛ kɔŋte, nda yi Yesus duwa̧ nde, mɛyasi hɛnɛ ma si kelna kɛ́, ɛ nyɛ lɛpɛ nde: «Yɛsiɗyɛ mɔrɔku kɛ kelɔ mi.» A lɛ́pi ɗete, nɛ́ mɛyasi mɛte yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tondu. ");
INSERT INTO kkj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wɛtɛ mapi ɓa̧ womɛte nɛ yiŋa ɗyanjina mɛnjam kɛte nɛ lɛtɛtɛ. Ɛ ɓesɔja ɓu̧ yiŋa yasi nda kusa sɔmɔ kɛ wɛtɛ jeti te yi ɓo jeɓa nde *yisɔp, tɔpɛ kɛ ɗyanjina mɛnjam mɛnɔri kaŋɛ kɛnjɛ kɛ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kɛ nyɛ ma si ɗye ɗyanjina mɛnjam mɛnɔri kɛ́, ɛ nyɛ lɛpɛ nde: «Mɛyasi hɛnɛ sima si kelna.» Ɛ nyɛ sɔkwɛ to yɔkiɗye Sisiŋ nɛ nyɛ kɛ mɛɓɔ mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yo ɓa̧ yesɔ kombila mɛyasi mɛ jesɔ *Paska Ɓeyudɛn. Ɗete, ɓekum Ɓeyudɛn tì kwaɗyɛ nde, ɓotu ɓete yi ɓo ŋgbama kɛ kroa ɓaka ɗîy ndi kɛ kroa kumɔ yesɔ *Saba na, kɛto yesɔ Saba te mbɛte ɓa̧ nyaŋgwɛ yesɔ jesɔ. Ɛ ɓekum Ɓeyudɛn kɛ̀ kɛ diyɛ Pilat nde, ɓo sîki lekɛ mɛkol mɛ ɓotu ɓete yi ɓo ŋgbama kɛ kroa ɓaka piɗyɛ ɓo soŋɛ. ");
INSERT INTO kkj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ndana, ɛ ɓesɔja ɗya̧ lekɛ mɛkol mɛ bosa mumɔ, kwa̧ lekɛ sendi mɛkol mɛ mɔ te yɔru, ɓo hɛnɛ yiɓa yi ɓo ŋgbama kɛ kroa nda Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kɛ ɓesɔja ma kumɔ kɛ yi Yesus kɛ́, ɓo dól nde, a sima gwe. Ɗete, ɓo kinɛ lekɛ se mɛkol mɛnɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yasi wɛtɛ, ɛ wɛtɛ sɔja ɓu̧ kɔ̧ dumɔ nɛ nyɛ kɛ mbanjɔ. Kɛ nyɛ ma dumɔ ndi nyɛ ɗete kɛ́, ɛ mɛkiyɔ nɛ mɔrɔku pundɛ. ");
INSERT INTO kkj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mɔ te ɛ ɓɛŋma mɛyasi mɛte kɔ yekiɗye yo. Yasi te yi nyɛ yekiɗye kɛ́, gbakasi. A duwa̧ nde, yasi te yi nyɛ lɛpɛ kɛ́, yo gbate, nɛ́ wunɛ tiki sendi temɔ kɛ lɛpi te. ");
INSERT INTO kkj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yo nde, mɛyasi kwaŋnama ɗete, nɛ́ lɛpi te yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ si tondu. Yo kɛtinate nde: ‹Ko ɓo tì lekɛ yesɔ nɛ wɛtɛ nɛ wɛtɛ na.› ");
INSERT INTO kkj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yo sendi kɛtinate kɛ wɛtɛ mbɛy kɛ mɔy mɛkana mɛ Njambiyɛ nde: ‹Ɓo ta kaŋɛ misi ɓɛŋɛ nɛ mɔ te yi ɓo ma lóŋ nyɛ nɛ kɔ̧ kɔ nɛ misi man.› ");
INSERT INTO kkj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kɛ kɔŋte, ɛ Yosɛp te mɔ ɗya Arimate kɛ̀ diyɛ muŋ Yesus kɛ mɛɓɔ mɛ Pilat. Yosɛp ɓa̧ kɛ ɓeŋgwɛ mɛlɛpi mɛ Yesus, yasi wɛtɛ, a ɓa̧ kɛ ɓeŋgwɛ yo sɔɗyate kambɔ ɓekum Ɓeyudɛn. Kɛ nyɛ ma diyɛ muŋ Yesus ɗete kɛ́, ɛ Pilat jayɛ. Ɛ nyɛ kwa̧ kɛ̀ ɓu̧ muŋ Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ɛ Nikɔdɛm te ɛ ma kɛ́n wɛtɛ yesɔ nɛ tu kɛ̀ ɓɛŋɛ Yesus kɔ nje sendi nɛ yiŋa kimɔ mutɔ te yi ɓo kelma nɛ yiŋa mɛmbunjɔ nde *mir nɛ̀ *alowɛs kɛ́. Ɗitɔ yasi yinɔri kumma nda kilo kamɔtati. ");
INSERT INTO kkj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɛ ɓembam ɓaka yiɓa ɓu̧ muŋ Yesus ɓɔyɛ nɛ mɛndɔmbɔ saŋgwɛ nɛ kimɔ mutɔ mɛnɔri nda yi Ɓeyudɛn ɗikima kombile nɛ ɓemuŋ ɓan yí pumbɔ nɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wɛtɛ ŋgwaŋ ɓa̧ kɛ mbɛy te yi ɓo ŋgbama Yesus kɛ kroa kɛ́. Wɛtɛ jɔnja ɓoŋsɔŋ ɓa̧ kɛ ŋgwaŋ te, ɓo tì pumbɛ wɛtɛ mumɔ kɛte wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɛ ɓo pumbɛ Yesus womɛte, kɛto yo ɓa̧ ŋgimɔ te yi ɗiki komsa jesɔ *Paska yan kɛ́. Sendi, ɓoŋsɔŋ te ɓa̧ womɛte nɛdɔ. ");
INSERT INTO kkj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi ma ɗya̧, ɛ Mariya te ŋgɔndu Magdala tɛmɛ ɓemɛŋmɛnɛ nɛ sut kɛ̀ kɛ ɓoŋsɔŋ, yite yasi ndi nɛ mbimbi mbilip. A dolma nde, ɓo ma soŋɛ tari te yi ɓa̧ kɛ numbu ɓoŋsɔŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɛ nyɛ sɛɗyɛ kɛ̀ kɛ yi Simɔn Piyɛr, kɛ̀ sendi kɛ yi jekɛ te ɛ Yesus ɗikima kwaɗyɛ ɓuɗyate kɔ lɛpɔ nyɛ ɓo nde: «Ɓo ma soŋɛ muŋ Nyaŋgwɛ Kumande kɛ ɓoŋsɔŋ. Wusɛ yeti kɛ duwɛ mbɛy te yi ɓo ka̧ tikɔ nyɛ kɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ɛ Piyɛr tɛmɛ pundɔ ɓenɛ jekɛ te yɔru yí kɛ̀ kɛ ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓo hɛnɛ yiɓa ɓa̧ kɛ sɛɗyɛ, yasi wɛtɛ, jekɛ te yɔru nja̧ sɛɗyɛ kwa̧ Piyɛr, ɛ nyɛ kandɛ kumɔ nɛ kɛ ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kɛ nyɛ ma ɓutuma kɛ́, ɛ nyɛ ɓɛŋɛ mɛlambɔ kɛ mɛnɛti kɛ mɔy ɓoŋsɔŋ. Yasi wɛtɛ, a tì nyiŋɛ kɛ̀ mate na. ");
INSERT INTO kkj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Piyɛr ɓa̧ kɛ ɓeŋgwɛ nyɛ kɔŋ nɛ kɔŋ. Ɛ nyɛ ɗya̧ nyiŋɛ nɛ kɛ ɓoŋsɔŋ, ɛ nyɛ ɓɛŋɛ mɛlambɔ kɛ mɛnɛti, ");
INSERT INTO kkj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ɓɛŋɛ sendi kum kandɔ te yi ɓo ɓɔyma nɛ to nɛ kɛ́. Yasi wɛtɛ, kum kandɔ te yite tì ɓɛ kɛ kiya mbɛy wɛtɛ nɛ mɛndɔmbɔ mɛte yiri na. Yo nja̧ ɓɛ nɛ ɓɔynate kɛ mbɛy te wenɛ dɛlɛ. ");
INSERT INTO kkj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ndana kɛ́, ɛ jekɛ te ɛ kandima ɗya̧ kɔ nje nyiŋɛ sendi kɛ ɓoŋsɔŋ. Ɛ nyɛ ɓɛŋɛ tikɔ temɔ kɛ mɛlɛpi mɛ Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yo nde, kumɔ kɛ ŋgimɔ te yite ɓejekɛ tì ɓɛ kɛ ɓiye to mɛlɛpi mɛte yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ nde, Yesus yâkaŋgwɛ womiyɛ kɛ njoka ɓemuŋ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ndana, ɛ ɓejekɛ ɓaka yiɓa nje yɔkwɛ kɛ̀ kɛ mbɛy te yi ɓo ɗikima ɗiyɔ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yinɔri Mariya ɓa̧ nɛ kɛ kɛki ɓoŋsɔŋ kɛ puyɛ kɛ lelɔ. Ɛ nyɛ kwa̧ ɓutuma ndi nɛ ɗukwe kɛ numbu yi ɓɛŋɛ nɛ mɔy ɓoŋsɔŋ. ");
INSERT INTO kkj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɛ nyɛ ɓɛŋɛ ɓejaki Njambiyɛ yiɓa mɛtiɗyɛ nɛ wumna mɛlambɔ kɛ yotu kɛ mbɛy komɛ ɓo niŋgwa muŋ Yesus kɛ́. Wɛtɛ ɓa̧ mɛtiɗyɛ pulɔ to, wɛtɛ pulɔ mɛkol. ");
INSERT INTO kkj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ɛ ɓo diyɛ nyɛ nde: «Nyari, wɛ lél ŋge?» Ɛ nyɛ yeŋsa nyɛ ɓo nde: «Ɓo soŋma muŋ Nyaŋgwɛ Kumande wombɛ, ma mi yeti kɛ duwɛ mbɛy te yi ɓo ka̧ tikɔ nyɛ kɛte kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kɛ nyɛ ma lɛpɔ ɗete kɛ́, ɛ nyɛ nje yeŋsa ɓɛŋɛ pulɔ kɔŋ nɛ. A ɓɛ́ŋa Yesus tɛmnate, yasi wɛtɛ, a tì duwɛ nde, yo nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ɛ Yesus diyɛ nyɛ nde: «Nyari, wɛ lél ŋge? Wɛ sáŋ nda?» Mariya takima nde, yo mɔ ɓakiɗya ŋgwaŋ, ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ mbam, ŋgɛ ɓɛ nde, yo wɛ ɓu̧ nyɛ kwa̧ nɔ, teɗya mi mbɛy te yi wɛ tikima nyɛ kɛte kɛ́, nɛ́ mi kɛ̀ ɓu̧ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Mariya!» Ɛ Mariya yeŋsa ɓɛŋɛ pulɔ kɔŋ nɛ lɛpɔ nyɛ nyɛ kɛ numbu Hebere nde: «Rabuni!» Yite nde yekele. ");
INSERT INTO kkj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ tî kpoka mi na, kɛto mi tì pa ɓendɔ kɛ̀ pɛ yi Saŋmbɛ na. Yasi wɛtɛ, kɛn dolɔ ɓenjɔŋ ɓembɛ lɛpɔ nyɛ ɓo nde: Mi kɛ ɓendɔ kɛ̀ pɛ yi Saŋmbɛ te Saŋgwɛ wun sendi, kɛ̀ pɛ yi Njambiyɛ wombɛ te Njambiyɛ wun sendi.» ");
INSERT INTO kkj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ɛ Mariya te ŋgɔndu Magdala kwa̧ kɛ̀ lɛpɔ nyɛ ɓejekɛ nde: «Mi ɓɛŋma Nyaŋgwɛ Kumande.» Ɛ nyɛ lɛpɛ mɛyasi mɛte yi Kumande Yesus lɛpima kɛ́ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kɛ kiya yesɔ te ɓekoko, kɛ bosa yesɔ te ɛ kandɛ jɔnja sɔndi ɓejekɛ ɓa̧ kɛ mbɛy wɛtɛ kɛ tu̧. Ɓo ndaɗya mɛnumɛy, kɛto ɓo ɓa̧ kɛ kambɔ ɓekum Ɓeyudɛn. Ɓo sém semɔ nde, Yesus ɗyaŋma tɛmɛ kɛ njoka yan lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy nɛ tɛ!» ");
INSERT INTO kkj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ teɗye ɓo mɛɓɔ mɛnɛ nɛ̀ mbanjɔ nɛ. Ɛ ɓejekɛ sosa ɓuɗyate kɛ ŋgimɔ te yi ɓo ɓɛŋma Kumande Yesus kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɛ nyɛ ɓasiɗye lɛpɔ nyɛ ɓo nde: «Wunɛ ɗîy nɛ tɛ! Mi kɛ tomɔ sendi wunɛ nda yi Da tomma nɛ mi kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ wumbiɗye ɓo lɛpɔ nde: «Kimɔ Sisiŋ kɛ̂n kɛ yotu yun. ");
INSERT INTO kkj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mumɔ hɛnɛ te yi wunɛ ta tikɔ mɛɓeyɔ mɛnɛ nɛ ŋgwɛtɛ, yo kɛ ɗuwɛ kɛ to nɛ. Ma yɔkɔ yi wunɛ tí tikɔ mɛɓeyɔ mɛnɛ nɛ ŋgwɛtɛ na, yo ta ɓɔnɛ ndi kɛ to nɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yinɔri kɛ ŋgimɔ te yi Yesus nja̧ punjɛ nɛ yotu nyɛ ɓejekɛ ɓenɛ kɛ́, wɛtɛ jekɛ wenɛ ɛ ɓa̧ kɛ njoka ɓejekɛ ɓenɛ kamɔ jɔ yiɓa kɔ tì ɓɛ ɓenɛ ɓɛsɔ na. Yo ɓa̧ Tomasi te yi ɓo jeɓa sendi nde Ɓeadan kɔ. ");
INSERT INTO kkj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɛ ɓejekɛ te ɓari nje lɛpɔ nyɛ nyɛ nde: «Wusɛ ɓɛŋma Nyaŋgwɛ Kumande.» Yasi wɛtɛ, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Ŋgɛ mi tì pa ɓɛŋɛ mbɛy mɛpɔndi kɛ mɛɓɔ mɛnɛ, nyɛ nyɛy ɓɔ mbɛ kɛ mbɛy mɛpɔndi, nyɛ sendi ɓɔ mbɛ kɛ mbanjɔ nɛ na, ko mi tí jayɛ nde, a womiya na.» ");
INSERT INTO kkj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ya mɛtu yitan jɔ yitati kɛ kɔŋte, ɛ ɓejekɛ kala wesiɗya kɛ mbɛy wɛtɛ kɛ mɔy tu̧. Tomasi ɓa̧ ɓenɛ ɓo, mɛnumɛy ɓa̧ sendi ndaɗyate. Ɓo sém semɔ, Yesus ɗyaŋma tɛmɛ kɛ njoka yan lɛpɔ nde: «Wunɛ ɗîy nɛ tɛ!» ");
INSERT INTO kkj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kɛ kɔŋte, ɛ nyɛ ɗiyɛ lɛpɔ nyɛ Tomasi nde: «Sambila nyɛy ɓɔ yɔ waka, nɔ̀ ɓɛ̂ŋa mɛɓɔ mɛmbɛ. Sambila sendi ɓɔ yɔ ɓoɓile nɛ mbanjɔ mbɛ. Ma wɛ tî kɛn mbɔmbu yí sɛŋɛ na, yasi wɛtɛ, jaya.» ");
INSERT INTO kkj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ɛ Tomasi yeŋsa nyɛ nyɛ nde: «Wɛ Kumande wombɛ, wɛ Njambiyɛ wombɛ!» ");
INSERT INTO kkj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Wɛ tíki temɔ ndana, kɛto wɛ ɓɛŋma mi. Mɛsosa nɛ ɓotu ɓete ɓe tikɛ temɔ kinɛ pa ɓɛŋɛ ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus kelma sendi yiŋa ɓuɗya mɛyekambiyɛ kɛ misi mɛ ɓejekɛ ɓenɛ, ndi nde, ɓo tì kɛtɛ yo hɛnɛ kɛ mɛkana maka na. ");
INSERT INTO kkj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yo nde, ɓo kɛ́ti mɛyasi mɛte yikɛ, nɛ́ wunɛ tiki temɔ nde, Yesus, nyɛ *Krist, Mɔnɔ Njambiyɛ. Yaka nɔ, ŋgɛ wunɛ tikɛ temɔ ɗete, wunɛ ta ɓɛ nɛ joŋgwɛ kɛto ɗinɔ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kɛ kɔŋ mɛyasi mɛnɔri, ɛ Yesus ɓasiɗye punjɛ yotu nyɛ ɓejekɛ ɓenɛ kɛ goŋ nyaŋgwɛ matɔ te yi ɓo jeɓa nde Matɔ te yi Tiberiyad*f1* kɔ. Punja yotu te yi nyɛ punja kɛ́ kwaŋnama ɗekɛ: ");
INSERT INTO kkj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ɓejekɛ ɓete ɓa̧ kɛ mbɛy wɛtɛ. Yo ɓa̧ nɛ̀ Simɔn Piyɛr nɛ̀ Tomasi te yi ɓo jeɓa nde Ɓeadan kɔ ɓu̧ Nataniyɛl te mɔ Kana kɛ Galile ɓu̧ ɓɔnɔ ɓe Seɓede nje ɓu̧ sendi ɓaŋa ɓejekɛ ɓenɛ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔn Piyɛr lɛpima nyɛ ɓo nde: «Mi kɛ kɛ̀ ɓetɛ bulajama.» Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Sinɛ wunɛ ta kɛ̀.» Ɛ ɓo tɛmɛ pundɔ kwa̧ ɓendɔ landi. Ɓo kwaŋɗya ndiŋgɛlɛ tu kinɛ wo ko gbɛla mɔnɔ yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kɛ ŋgimɔ te yi mɛjasi nje nɔ nɛ ɓɛy ɓɛy kɛ́, ɛ Yesus ɗya̧ tɛmɛ kɛ ŋgindi. Yasi wɛtɛ, ɓo tì duwɛ nde, yo nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ndana, ɛ Yesus diyɛ ɓo nde: «Wunɛ ɓɔnɔ, ’wunɛ nɛ mɔnɔ yaŋa te yi wunɛ yakama ɗye?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Ko na.» ");
INSERT INTO kkj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ ɓêta bulajama yaka nɛ landi pulɔ mbam ɓɔ, wunɛ ta dolɔ yaŋa.» Ɗete, ɛ ɓo ɓetɛ bulajama kɛ ɗuku. Ndana, ɓo tì ɓɛ nɛ ɗeti te yi ɗalɛ yo na, kɛto ɓuɗya ɓenjanjɔ ɓete yi yo kawula kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ɛ jekɛ te yi Yesus ɗikima kwaɗyɛ ɓuɗyate kɔ lɛpɛ nyɛ Piyɛr nde: «Yo Nyaŋgwɛ Kumande.» Kɛ Simɔn Piyɛr ma wokɔ ɗete kɛ́, ɛ nyɛ tɔkɛ lambɔ nɛ lɛŋɛ, kɛto a tì ɓɛ nɛ lambɔ kɛ yotu na. Ɛ nyɛ kwa̧ ɓeta kɛ ɗuku. ");
INSERT INTO kkj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ndana, ɛ ɓejekɛ te ɓari ɓu̧ landi nje nɔ yí nje ɗalɛ bulajama nɛ̀ ɓenjanjɔ kɛte nɛ ŋgbɛŋ kɛ̀ nɔ ŋgindi, kɛto ɓo tì ɓɛ lɔndunate nɛ ŋgindi na. Lɔndɔ te nɛ ŋgindi yakama kumɔ nda mɛta gɔmay. ");
INSERT INTO kkj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kɛ ɓo ma kumɔ kɛ ŋgindi, ɓo ɓɛ́ŋa njanjɔ nɛ̀ mampa kasate kɛ to ɗitɛ. Ɗitɛ te ɓa̧ tandɛ mɛma nɛ nyɛŋ nyɛŋ. ");
INSERT INTO kkj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ ɓôŋ ɓaŋa ɓenjanjɔ ɓete yi wunɛ woma ndana kɛ́ nje nɔ.» ");
INSERT INTO kkj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ɛ Simɔn Piyɛr ɓendɛ landi kɛ̀ ɗalɛ bulajama kɛ̀ nɔ ŋgindi. Nyaŋgwɛ ɓenjanjɔ gɔmay jɔ kamɔtan jɔ yitati ɓa̧ kɛte nɛ ŋgbɛŋ, ko ɗete, bulajama tì nyaliyɛ na. ");
INSERT INTO kkj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ɛ Yesus lɛpɛ nyɛ ɓo nde: «Wunɛ njâki ɗyena.» Ko mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka ɓejekɛ tì ɓoɓɛ diyɛ nyɛ nde: ‹Wɛ ɓa nda?› Ko mumɔ tì diyɛ ɗete na, kɛto ɓo duwa̧ nde, yo Nyaŋgwɛ Kumande. ");
INSERT INTO kkj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ndana, ɛ Yesus kɛ̀ tɔkɛ mampa kaŋɛ nyɛ ɓo, kelɔ sendi ɗete nɛ njanjɔ. ");
INSERT INTO kkj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yo ɓa̧ mɛŋga yitatite yi nyɛ punjɛ nɛ yotu nyɛ ɓejekɛ ɓenɛ kɛ kɔŋ womiya nɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kɛ ɓo ma si ɗyena kɛ́, ɛ Yesus diyɛ Simɔn Piyɛr nde: «Simɔn te mɔnɔ Jaŋ, wɛ kɛ kwaɗyɛ mi gbate kwa̧ yi ɓaka kwaɗyɛ nɛ mi kɛ́?» Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «I̧, Nyaŋgwɛ Kumande. Wɛ duwa̧ nde, mi kɛ kwaɗyɛ wɛ.» Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Dalɔ ɓɔnɔ ɓesam ɓembɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɛ Yesus ɓasiɗye diyɛ nyɛ kɛ mɛŋga yiɓate nde: «Simɔn te mɔnɔ Jaŋ, wɛ kɛ kwaɗyɛ mi gbate?» Ɛ nyɛ yeŋsa nyɛ nyɛ nde: «I̧, Nyaŋgwɛ Kumande. Gba wɛ duwa̧ nde, mi kɛ kwaɗyɛ wɛ.» Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Ɓakiɗya ɓɔnɔ ɓesam ɓembɛ.» ");
INSERT INTO kkj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kɛ mɛŋga yitatite, ɛ Yesus diyɛ nyɛ nde: «Simɔn te mɔnɔ Jaŋ, wɛ kɛ kwaɗyɛ mi?» Ɛ yo kwaɗye temɔ Piyɛr, kɛto a diyma nyɛ kumɔ mɛŋga yitati nde: ‹Wɛ kɛ kwaɗyɛ mi?› Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Nyaŋgwɛ Kumande, gba wɛ kɛ duwɛ mɛyasi hɛnɛ, wɛ ma duwɛ nde, mi kɛ kwaɗyɛ wɛ.» Ɛ Yesus lɛpɛ nyɛ nyɛ nde: «Ɓakiɗya ɓɔnɔ ɓesam ɓembɛ. ");
INSERT INTO kkj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gbakasi yi mi lɛpɛ nyɛ wɛ kɛ́: Kɛ ŋgimɔ te yi wɛ ɓa̧ ndi gwanjɔ, wɛ nɛ ŋguru wɔ ɗikima nyɛ kanda kɛ jon yɔ, ɛ wɛ ɗiki kɛ̀ kɛ mbɛy hɛnɛ te yi wɛ kwaɗya kɛ́. Ma komɛ wɛ ta si jombɛ kɛ́, wɛ ta kaŋɛ mɛɓɔ kɛnjɛ kwey, wɛtɛ mumɔ má nje lɛnje wɛ kanda, kɛ̀ nɛ wɛ kɛ mbɛy te yi wɛ yeti kɛ gɔrɔ na.» ");
INSERT INTO kkj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus lɛ́pi yinɔri yí teɗye nɛ kwalɔ sɔŋ te yi Piyɛr ta saŋgwa nɔ yí nyɛ nɛ Njambiyɛ luksa kɛ́. Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ Piyɛr nde: «Ɓeŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kɛ Piyɛr ma yeŋsa, a ɓɛ́ŋa jekɛ te ɛ Yesus ɓa̧ kɛ kwaɗyɛ ɓuɗyate kɔ kɛ̀ nje kɛ kɔŋ nɛ. Yo jekɛ te ɛ ma lɛŋgwɛ yotu wɛtɛ yesɔ kɛnjɛ pulɔ Yesus kɛ mbɛy mɛɗye diyɛ nyɛ nde: ‹Nyaŋgwɛ Kumande, yo nda ɛ ta ɗyaŋgwɛ wɛ kɔ?› ");
INSERT INTO kkj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kɛ Piyɛr ma kaŋɛ misi ɓɛŋɛ nyɛ kɛ́, ɛ nyɛ lɛpɛ nyɛ Yesus nde: «Nyaŋgwɛ Kumande, ŋgɛ ɓɛ yɔkɔ, ŋge ta ɗya̧ nyɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ɛ Yesus yeŋsa nyɛ nyɛ nde: «Ŋgɛ mi kwaɗyɛ nde, a ɗîy kumɔ kɛ ŋgimɔ te yi mi ta kala nje kɛ́, yo ɓɛ́ŋa wɛ kɛ ŋge? Kɛ ɓɛ wɛ, ɓeŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɛ lɛpi yinɔri nyanja kɛ mɛtɔ mɛ ɓenjɔŋ ɓan nde: ‹Jekɛ te tí gwe na.› Yasi wɛtɛ, Yesus tì lɛpɛ nyɛ Piyɛr nde: ‹Jekɛ te tí gwe na,› a lɛpima nde: ‹Ŋgɛ mi kwaɗyɛ nde, a ɗîy kumɔ kɛ ŋgimɔ te yi mi ta kala nje kɛ́, yo ɓɛ́ŋa wɛ kɛ ŋge?› ");
INSERT INTO kkj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yo jekɛ te kɛ yekiɗye mɛyasi mɛte yi nyɛ ɓɛŋma kɛ́. Yo nyɛ kɛtɛ sendi yo. Wusɛ kɛ duwɛ nde, mɛyasi mɛte yi nyɛ yekiɗye kɛ́, gbakasi. ");
INSERT INTO kkj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus kelma yiŋa ɓuɗya mɛyasi sendi. Ɓo má kɛti mɛyasi mɛnɔri hɛnɛ wɛtɛ wɛtɛ, mi táka nde, ma mbɛy ta saŋna kɛ to mbokɔ yí tikɔ mɛkana mɛte yi ɓo yakama kɛtɔ kɛ́.");
INSERT INTO kkj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mbam Teyofil, kɛ bosa mɛkana mɛte yi mi kɛtima kɛ́, mi yekiɗya mɛyasi hɛnɛ te yi Yesus kelma nɛ̀ yi nyɛ teɗya ɓomɔ kɛ́. Mi yekiɗya yo kandɛ kɛ kandinate ");
INSERT INTO kkj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kumɔ kɛ yesɔ te yi Njambiyɛ yɔkiɗya nɛ nyɛ kɛnjɛ ɗyoɓɔ kɛ́. Piŋɔ te yi nyɛ tì pa ɓendɔ kɛ̀ ɗyoɓɔ, ɛ nyɛ kelɛ nde, Kimɔ Sisiŋ nyɛ̂ki mɛmboŋga nyɛ ɓotu ɓete ɓe nyɛ tɔkuma nde, ɓotu ɓe tomun ɓenɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A saŋgwama nɛ mɛbɔnɛ gwe. Kɛ kɔŋte, ɛ nyɛ nje punjɛ yotu nyɛ ɓo, gba nyɛ nɛ ŋguru wenɛ nɛ joŋ. A teɗya nyɛ ɓo nde, yo gbakasi nɛ mɛnje ɓuɗyate. Ɗete, a punja yotu nyɛ ɓo kɛ mɛtu kamɔni. Ɛ nyɛ ɗiki lɛpɔ mɛyasi nyɛ ɓo kɛ kasi *Kandɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wɛtɛ yesɔ kɛ ɓenɛ ɓo ma ɗiyɔ kɛ kiya mbɛy kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Kpɛ, wunɛ tî ɗukwɛ kɛ Yerusalɛm kɛ̀ womaŋa na. Yasi wɛtɛ, wunɛ ɗîy laɗye yasi te yi Saŋmbɛ kpoma kɛ́, yasi te yi mi lɛpima nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kɛto Jaŋ tɔpuma ɓomɔ kɛ mɔrɔku, yasi wɛtɛ, kɛ yun, ɓukwa̧ ndi mɔnɔ mɛtu nɛ mbɛt Njambiyɛ ta tɔpɛ wunɛ kɛ Kimɔ Sisiŋ.» ");
INSERT INTO kkj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ndana, ɛ ɓotu ɓe tomun ɓe wesiɗyama ɓaka diyɛ nyɛ nde: «Nyaŋgwɛ Kumande, yo kɛ ŋgimɔ te yɔkɔ yi wɛ kɛ nje tɛmbiɗye kandɔ Isarayɛl, na nam mɛnɛti mɛnɛ nɛ kɔkɔ?» ");
INSERT INTO kkj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ɛ Yesus yeŋsa nyɛ ɓo nde: «Yeti wunɛ yâkaŋgwɛ duwɛ mɛŋgimɔ nɛ̀ mɛtu mɛte na, kɛto yo Saŋmbɛ pɛsɛ yo nɛ ŋguru wenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yasi wɛtɛ, wunɛ ta ɓu̧ ɗeti komɛ Kimɔ Sisiŋ ta nje kɛ yotu yun kɛ́. Wunɛ ta ɓɛ ɓotu ɓete ɓe ta lɛpɔ gbakasi kɛ mɛyasi mɛte yi mi kelma kɛ́. Wunɛ ta lɛpɔ kasi mbɛ kɛ Yerusalɛm, kɛ Yuda hɛnɛ, kɛ Samari, kɛ̀ kumɔ kɛ njena mɛnɛti.» ");
INSERT INTO kkj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kɛ Yesus ma si lɛpina ɗete kɛ́, ɛ Njambiyɛ yɔkiɗye nyɛ kɛnjɛ ɗyoɓɔ kɛ misi man. Ɛ kulutu kwa̧ petɔ nyɛ, ɓo kinɛ ɓɛŋɛ nyɛ se na. ");
INSERT INTO kkj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Piŋɔ te yi ɓo ɓa̧ ndi kɛ seŋgile ɗyoɓɔ yite Yesus ndi kɛ kwa̧ nɛ kɛ́, ɓo sém semɔ, ɓembam yiɓa ɗyaŋma nɛ wumna mɛlambɔ kɛ yotu tɛmɛ kɛ kɛki yan ");
INSERT INTO kkj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","lɛpɔ nyɛ ɓo nde: «Wunɛ ɓotu ɓe Galile, kɛto ŋge yi wunɛ ɗiyɛ ndi womɛri yí seŋgile ɗyoɓɔ kɛ́? Yesus te yɔkɔ yi Njambiyɛ soŋma kɛ njoka yun kɛnjɛ ɗyoɓɔ kɔ ta ɓasiɗye nje ndi nda yi wunɛ ɓɛŋma nɛ nyɛ kɛ kwa̧ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ndana, ɛ ɓotu ɓe tomun ɓe Yesus nje yɔkwɛ mate kɛ *Keki mɛoliviye kɛ̀ Yerusalɛm. Keki te ɓa̧ kɛ kɛki Yerusalɛm, lɔndɔ te yakama kumɔ kilomɛta wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kɛ ɓo ma ɗya̧ kɛ Yerusalɛm kɛ́, ɛ ɓo ɓendɛ kɛ̀ kɛ wɛtɛ toŋgari kɛ tu̧ kwey kɛ njenate komɛ ɓo ɗikima wesiɗya kɛ́. Yo ɓa̧ Piyɛr nɛ̀ Jaŋ nɛ̀ Jak ɓenɛ Andere nɛ̀ Filip nɛ̀ Tomasi nɛ̀ Bartelemi ɓenɛ Matiyo ɓu̧ Jak te mɔnɔ Alfe nɛ̀ Simɔn te yi ɓo jeɓa nde Mɔnɔ kandɔ kɔ, nje ɓu̧ Yude, mɔnɔ Jak. ");
INSERT INTO kkj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓo hɛnɛ ɓa̧ ndi ŋgiŋ wɛtɛ, ɗiki wesiɗya yí ŋgwɛta ɓenɛ ɓaŋa ɓoma. Mariya te nyaŋgwɛ nɛ Yesus nɛ̀ ɓemaŋ nɛ Yesus ɓa̧ sendi kɛ njokate. ");
INSERT INTO kkj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kɛ wɛtɛ yesɔ mɛwesiɗya man ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka wesiɗyama kumɔ nda ɓomɔ gɔmay jɔ kaɓa. Ɛ Piyɛr tɛmɛ kɛ njoka yan lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Wunɛ njɔŋ, yo ɓa̧ nde, yasi te yi Kimɔ Sisiŋ kandima lɛpɔ nɛ mbɔmbu kɛ kasi Yudas kɛ́ kêlnaŋgwɛ. Kimɔ Sisiŋ kandima lɛpɔ yo kɛ mɛkana mɛ Njambiyɛ kɛ numbu Kumande Davit. Yo Yudas te kɛndɛ nɛ njɔŋ ɓotu ɓete ɓe ɓiyma Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas ɓa̧ wɛtɛ mɔ njɔŋ su, a ɓa̧ nɛ ŋgaɓiyɛ kɛ mɛsay musu. ");
INSERT INTO kkj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mbam kɔ ɓoŋma mɔni te yi ɓo nya nyɛ kɛto ɓeya kɔtu mɛkele mɛnɛ kɛ́ ɓɔmɔ nɛ ŋgwaŋ. Ɛ nyɛ nje ɓalɔ nɛ ŋgiŋ. Ɛ mɔy nɛ ɓundɛ nyaliyɛ kɛ ɓembe, ɛ mɛnja mɛnɛ hɛnɛ si nyɛŋgwɛ kɛ puyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓotu ɓe Yerusalɛm hɛnɛ wokuma kasi te, ɛ ɓo lo ŋgwaŋ te kɛ numbu yan nde Hakɛldama, yite nde Ŋgwaŋ mɛkiyɔ. ");
INSERT INTO kkj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ mɛkana mɛ Ɓesom nde: ‹Tu̧ nɛ ɓɛ̂ki welɛ. Mumɔ tî ɗiy sendi kɛte na.› Yo kɛtinate sendi nde: ‹Nɛ̀ wɛtɛ mumɔ ɓôŋ numbu mɛsay mɛnɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ɗete, yo kimɔte nde, wɛtɛ mumɔ njâki nje nyiŋɛ kɛ njɔŋ su. Mɔ te yâkaŋgwɛ ɓɛ kɛ njoka ɓotu ɓete ɓe sinɛ ɓo ɗikima kɛndɔ ɓaka. A yâkaŋgwɛ ɓɛ mɔ te yi sinɛ ɓo ɗikima kɛndɔ kɛ mɛtu hɛnɛ te yi Kumande Yesus joŋnama nɔ sinɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mɔ te yâkaŋgwɛ ɓɛ yɔkɔ ɛ joŋnama sinɛ ɓo kandɛ kɛ ŋgimɔ te yi Jaŋ tɔpuma nɛ Yesus kɛ mɔrɔku kumɔ kɛ yesɔ te yi nyɛ ɗuwa̧ nɔ kɛ njoka su kɛ ɗyoɓɔ kɛ́. Wɛtɛ mumɔ kɛ njoka ɓotu ɓete njâki nyiŋɛ kɛ njɔŋ su, na ɓɛ sendi mɔ te ɛ ta lɛpɔ gbakasi kɛ kasi womiya Kumande Yesus.» ");
INSERT INTO kkj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɛ ɓo tɛmbiɗye ɓembam yiɓa: Yosɛp te yi ɓo jeɓa nde Barsabas yi ɓo loma sendi nyɛ yiŋa ɗinɔ nde Yustus kɔ, nje ɓu̧ Matiyas. ");
INSERT INTO kkj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ndana, ɛ ɓo ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: «Nyaŋgwɛ Kumande, wɛ yɔkɔ ɛ duwɛ mɛtemɔ mɛ ɓomɔ hɛnɛ, teɗya wusɛ mɔ te yi wɛ tɔkuma kɛ njoka ɓomɔ ɓaka yiɓa, ");
INSERT INTO kkj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na ɓu̧ mbɛy Yudas kɛ mɛsay nɛ̀ kɛ lɛpina Kimɔ Tom te yi nyɛ tikima kɛ̀ kɛ mbɛy te yi yakama nɛ nyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kɛ kɔŋte, ɛ ɓo kelɛ tay. Ɛ tay teɗye Matiyas. Ɛ ɓo nyinje nyɛ kɛ njɔŋ ɓotu ɓe tomun ɓete ɓari kamɔ jɔ wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kɛ yesɔ Paŋtekot ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus *Krist ɓaka ɓa̧ hɛnɛ kɛ mbɛy wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Semɔ semɔ, ɛ yiŋa mɛɗuŋ wulɛ ɗyoɓɔ, yo ɓa̧ nda mɛɗuŋ mɛ nyaŋgwɛ pupɔ, ɛ yo tondɛ kɛ mɔy tu̧ hɛnɛ komɛ ɓo ɓa̧ mɛtiɗyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ɛ ɓo ɓɛŋɛ yiŋa mɛyasi nda mɛlam mɛ ɗitɛ. Ɛ yo ɓakina wɛtɛ wɛtɛ kɛ̀ ɗiyɔ kɛ yotu yan yaka nɛ ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɛ ɓo hɛnɛ tondɛ nɛ Kimɔ Sisiŋ, kandɛ lɛpina yiŋa mɛnumbu ɓeŋgwɛ yasi te yi Kimɔ Sisiŋ nya ɓo ɗeti te yi lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kɛ pɔku mɛtu te yite Ɓeyudɛn ɓete ɓe ɗikima kanɔ Njambiyɛ ɓaka ɗikima ɗiyɔ kɛ Yerusalɛm. Ɓo wulma kɛ mɛkandɔ hɛnɛ kɛ to mɛnɛti nje ɓiye ɗya womɛte. ");
INSERT INTO kkj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kɛ mɛɗuŋ mɛnɔri ma kelna kɛ́, ɛ ɓomɔ nje wesiɗya nɛ ŋgil. Ɓo ɓa̧ nɛ yekere, kɛto mumɔ hɛnɛ wokuma yasi te yi ɓejekɛ ɓa̧ kɛ lɛpɔ kɛ́ kɛ numbu ɗya ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yo kwaŋma ɓomɔ hɛnɛ, ɛ ɓo ŋgbakima ɗiki diyna nde: «Ɓembam ɓete ɓe lɛpina hɛnɛ ɓaka, yeti ɓotu ɓe Galile na? ");
INSERT INTO kkj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ŋge nje kelɔ nde, mumɔ hɛnɛ kɛ njoka su wôku yasi te yi ɓo lɛpɛ kɛ́ kɛ numbu ɗya ɗyenɛ, kɛ ŋgbak ŋgbak mɛnumbu musu? ");
INSERT INTO kkj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kɛ njoka su, ɓotu ɓe Partɛs kɛte, ɓotu ɓe Medi nɛ̀ Elam kɛte. Ɓotu ɓe Mɛsopotami, ɓotu ɓe Yuda nɛ̀ Kapadɔs kɛte. Ɓotu ɓe Pɔŋ nɛ̀ ɓotu ɓe Asi kɛte. ");
INSERT INTO kkj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ɓotu ɓe Friji nɛ̀ Pamfili nɛ̀ Ejipt nɛ̀ ɓotu ɓe Sirɛn kɛ mɛnɛti mɛ Libi kɛte. Ɓotu ɓe wulma Rom nje ɓiye ɗya waka ɓaka kɛte sendi. Kɛ njoka yan, yo nɛ ŋgbak ŋgbak Ɓeyudɛn nɛ̀ ɓotu ɓete ɓe nja̧ nyiŋɛ misɔn Ɓeyudɛn nyiŋa ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ɓotu ɓe Krɛt nɛ̀ ɓotu ɓe Arabi kɛte sendi. Ŋge nje kelɔ nde, mumɔ hɛnɛ woku nda yi ɓo kɛ lɛpɔ nyaŋgwɛ mɛkele mɛte yi Njambiyɛ kelma kɛ́ kɛ numbu ɗya ɗyenɛ?» ");
INSERT INTO kkj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓomɔ hɛnɛ ɓa̧ numbu nɛ haŋ kinɛ duwɛ yasi te yi ɓo yakama lɛpɔ kɛ́ na. Ɛ ɓo ɗiki lɛpɔ tandɛ yan nde: «Yikɛ ɓa ŋge?» ");
INSERT INTO kkj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko ɗete, ɓaŋa ɗikima nyɛtɔ ɓo lɛpɔ nde: «Ɓo ma gwe kimɔ mɔm mɔm mɛnjam kimɔ gwenate.» ");
INSERT INTO kkj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ndana, ɛ Piyɛr tɛmɛ ɓenɛ ɓejekɛ te ɓari kamɔ jɔ wɛtɛ lɛpɔ nɛ mɛn kɛ kwey nyɛ ŋgil ɓomɔ nde: «Wunɛ Ɓeyudɛn nɛ̀ wunɛ ɓomɔ hɛnɛ ɓe ɗiyɛ kɛ Yerusalɛm ɓaka, wunɛ lɛ̂ŋgwɛ mɛtɔ kimɔte kɛ yasi te yi mi ta lɛpɔ kɛ́, ");
INSERT INTO kkj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","kɛto ɓotu ɓaka yeti kɛ gwe mɛnjam nda yi wunɛ takɛ kɛ́ na, kɛto yo ndi ŋgimɔ yitan jɔ yini te yi ɓemɛŋmɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yasi wɛtɛ, yasi te yi Juwɛl te mɔ punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́ kɛ ɓɛŋna ndana. A lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Njambiyɛ kɛ lɛpɔ nde: Kɛ mɛtu mɛte yi mbokɔ ta ɓɛ kɛ siyɔ kɛ́, mi Njambiyɛ ta nyɛ Sisiŋ mbɛ kɛ yotu mumɔ hɛnɛ. Ɓɔnɔ ɓun ɓe ɓembam nɛ̀ ɓe ɓomari ta punjɛ mɛlɛpi mɛmbɛ. Ɓegwanjɔ ɓun ta ɓɛŋɛ nyaŋgwɛ mɛyasi, ɓenjombu ɓun sendi ta ɓɛŋɛ nyaŋgwɛ mɛnyɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gbate, kɛ mɛtu mɛte yite mi ta nyɛ Sisiŋ mbɛ kɛ yotu ɓembam nɛ̀ kɛ yotu ɓoma ɓete ɓe kelɛ mɛsay mɛmbɛ ɓaka. Ɗete, ɓo ta punjɛ mɛlɛpi mɛmbɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi ta punjɛ nyaŋgwɛ mɛyasi kɛ ɗyoɓɔ kɛ kwey, teɗye sendi mɛyekambiyɛ kɛ to mɛnɛti. Yo nde, wunɛ ta ɓɛŋɛ mɛkiyɔ, ɓɛŋɛ ɗitɛ, ɓɛŋɛ yiɗyɛ nɛ̀ tiɓa̧y nda kulutu. ");
INSERT INTO kkj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tu ta yinja nɛ yesɔ, ŋgwɛndɛ ta yeŋsa ɓɛ tenate nda mɛkiyɔ. Mɛyasi mɛte ta kelna yite nyaŋgwɛ *Yesɔ Baba Mbokɔ tì pa ɗya̧ na. Yesɔ te ta ɓɛ nyaŋgwɛ kpekum. ");
INSERT INTO kkj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yo ta ɓɛ nde, mumɔ hɛnɛ ɛ ta jeɓa ɗinɔ Baba Mbokɔ, mɔ te ta ju̧.› » ");
INSERT INTO kkj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Wunɛ ɓotu ɓe kandɔ Isarayɛl, wunɛ wôku yasi te yi mi ta lɛpɔ ndana nyɛ wunɛ kɛ́. Yesus te ɛ Nasarɛt, yo mɔ te yi Njambiyɛ teɗya wunɛ nde, yo nyɛ namɛ mɛyasi hɛnɛ. A teɗya yo kɛ misi mun nɛ nje kelna nyaŋgwɛ mɛkele, nɛ nje kelna yiŋa nyaŋgwɛ mɛyasi nɛ̀ kelna mɛyekambiyɛ mɛte yi Njambiyɛ nya nyɛ ɗeti te yi kelɔ kɛ njoka yun nda yi wunɛ nɛ ŋguru wun duwa̧ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɓo ɗyaŋgwa mbam kɔ nyɛ wunɛ ɓeŋgwɛ yasi te yi Njambiyɛ pɛsima kɛ́, ɓeŋgwɛ sendi nda yi Njambiyɛ ma si kombile njombu yaŋa kɛ́. Wunɛ ɓoŋma nyɛ nyɛ ɓotu ɓe mɛɓeyɔ, ɛ ɓo ŋgba nyɛ kɛ kroa, ɗete wunɛ wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Njambiyɛ nja̧ womiyɛ nyɛ joŋgwɛ nyɛ soŋɛ kɛ nyaŋgwɛ mɛbɔnɛ mɛte yi sɔŋ, kɛto sɔŋ tì ɓɛ nɛ ɗeti te yi ɓiye nyɛ nda nɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yo ɗete yi Davit lɛpima kasi nɛ nde: ‹Mi ɗikima ɓɛŋɛ Baba Mbokɔ mɛtu hɛnɛ kɛ mbɔmbu wombɛ, kɛto a kɛ mbam ɓɔ mbɛ, kambɔ mi nje ŋgwaŋgwa. ");
INSERT INTO kkj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɗete, temɔ mbɛ nɛ mɛsosa, mɛlɛpi mɛte yi pundɛ kɛ numbu mbɛ kɛ́ kɛ teɗye nde, mi nɛ nyaŋgwɛ mɛsosa. Sendi, mi ta wɛɗya ɓɛ nɛ ɓiɓina temɔ kɛ yɔ Njambiyɛ, ");
INSERT INTO kkj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kɛto wɛ tí tikɔ sisiŋ mbɛ kɛ ɗya ɓemuŋ na. Wɛ tí jayɛ nde, mumɔ wɔ ɓɔ̂ku na. ");
INSERT INTO kkj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wɛ ma teɗye mi mɛnje mɛte yi ɓɛ nɛ joŋgwɛ. Komɛ mi ta ɓɛŋɛ wɛ kɛ́, mi ta ɓɛ nɛ nyaŋgwɛ mɛsosa.› » ");
INSERT INTO kkj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Wunɛ njɔŋ, wunɛ tîki, nɛ́ mi pa lɛpi kasi saŋmbambɔ wusu Davit nɛ ŋgbak ŋgbak nyɛ wunɛ. Davit gwa̧, ɛ ɓo pumbɛ nyɛ. Ma kumɔ muka ɓoŋsɔŋ nɛ ndi kɛ njoka su. ");
INSERT INTO kkj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yasi wɛtɛ, Davit ɓa̧ mɔ punja mɛlɛpi mɛ Njambiyɛ. A duwa̧ sendi nde, Njambiyɛ kpoma kinja nyɛ nyɛ nde, kɛ njoka ɓenday ɓenɛ, nyɛ Njambiyɛ ta tɛmbiɗye wɛtɛ kɛ njokate ɛ ta ɓu̧ ɗiyɔ kumande kɛ mbɛy nɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davit kikima ɓɛŋɛ kasi womiya *Krist. Ɛ nyɛ kandɛ lɛpɔ nde: ‹Njambiyɛ tí li̧ Krist kɛ ɗya ɓemuŋ na, a tí ɓɔ na.› ");
INSERT INTO kkj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wusɛ hɛnɛ ɓɛŋma duwɛ nde, yo Yesus te yi Njambiyɛ womiya kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Njambiyɛ ɓendiɗya nyɛ tikɔ kɛ mbam ɓɔ nɛ. Ɛ saŋgwɛ nyɛ nyɛ Kimɔ Sisiŋ te yi nyɛ kpoma kɛ́. Yo Kimɔ Sisiŋ te yi nyɛ nya kɛ yotu su kɛ́, yo yo kelɛ nde, wunɛ ɓɛ̂ŋa nɛ̀ wunɛ wôku mɛyasi mɛte yikɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yeti Davit kelɛ mɛkele mɛte na, kɛto Davit tì ɓendɛ kɛ̀ ɗyoɓɔ na, yasi wɛtɛ, nyɛ nɛ ŋguru wenɛ kɛ lɛpɔ nde: ‹Baba Mbokɔ lɛpima nyɛ Kumande wombɛ nde: Ɗiyɔ mɛtiɗyɛ kɛ mbam ɓɔ mbɛ, ");
INSERT INTO kkj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kumɔ nde, mi sîki kawule ɓependɔ ɓɔ tikɔ kɛ nji̧ mɛkol mɔ.› ");
INSERT INTO kkj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ɗete, kandɔ Isarayɛl hɛnɛ dûkwɛ nde, yo gbate nde, Yesus te yi wunɛ ŋgbama kɛ kroa kɔ, yo nyɛ yi Njambiyɛ nja̧ tɛmbiɗye nde, nyɛ Nyaŋgwɛ Kumande, nyɛ Krist.» ");
INSERT INTO kkj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kɛ ɓomɔ ma si wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ yo lu̧ ɓo kɛ temɔ ɓuɗyate, ɛ ɓo diyɛ Piyɛr ɓenɛ ɓotu ɓe tomun te ɓari nde: «Wunɛ njɔŋ, wusɛ kêl ɓa nan?» ");
INSERT INTO kkj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ɛ Piyɛr yeŋsa nyɛ ɓo nde: «Wunɛ yêŋsaŋgwɛ temɔ, nɛ̀ mumɔ hɛnɛ jâya nde, ɓo tɔ̂pa nyɛ kɛ mɔrɔku nɛ ɗinɔ Yesus Krist, nɛ́ Njambiyɛ tiki mɛɓeyɔ mun nɛ ŋgwɛtɛ. Ɗete, Njambiyɛ ta nyɛ wunɛ Kimɔ Sisiŋ nɛ gbɛlate. ");
INSERT INTO kkj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kɛto yasi te yi Njambiyɛ kpoma kɛ́, yo kɛto yun nɛ̀ ɓɔnɔ ɓun nɛ̀ kɛto ɓomɔ hɛnɛ ɓe nɛ naŋ, ɓuɗya ɓomɔ hɛnɛ ɓe Baba Mbokɔ te Njambiyɛ wusu ta jeɓa kɛnjɛ kɛ yenɛ ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyɛr ka̧ mbɔmbu lɛpɔ yiŋa ɓuɗya mɛlɛpi nyɛ ɓo yí kitɛ nɛ ɓo. A ɗikima lɛpɔ nyɛ ɓo nde: «Wunɛ jôŋgwɛ yotu yun. Ɗete, wunɛ ɓâkaŋgwɛ nɛ ɓotu ɓe ŋgimɔ te yɔkɔ ɓe kelɛ ɓeya mɛkele ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓo tɔpuma ɓotu ɓete ɓe jayma mɛlɛpi mɛ Piyɛr ɓaka kɛ mɔrɔku. Yesɔ te ɛ Njambiyɛ kelɛ nde, ɓomɔ nda tomay yitati nyîŋa kɛ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓo ɓeŋgwa yasi te yi ɓotu ɓe tomun ɓe Yesus ɗikima teɗye ɓo kɛ́ mɛtu hɛnɛ. Ɓo ɗikima joŋna nda ɓemaŋ, ɗyena wɛtɛ, ɓɛ sendi saŋgwate kɛ mɛŋgwɛta. ");
INSERT INTO kkj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɛ ɓomɔ hɛnɛ gwe wɔ̧ yan. Ɓotu ɓe tomun ɓe Yesus ɗikima kelɔ ɓuɗya nyaŋgwɛ mɛyasi nɛ̀ ɓuɗya mɛyekambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓomɔ hɛnɛ ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka ɓa̧ kɛ ɗiyɔ mbɛy wɛtɛ. Ɓo ɗikima ŋgbɔ mɛyasi man hɛnɛ ɓakiɗye wɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓo ɗikima ɗyaŋgwɛ mɛkusuku man nɛ̀ mɛyasi man nje kaɓiɗya mɔni te ɓo hɛnɛ. Ɓo ɗikima nyɛ mumɔ hɛnɛ mɛyasi ɓeŋgwɛ mɛyasi mɛte yi ɓanɛ nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɓo ɗikima wesiɗya mɛtu hɛnɛ nɛ̀ mɛŋgimɔ hɛnɛ kɛ mbanjɔ Njambiyɛ, ŋgbɔ ɗyena kɛ mɔy mɛtu̧ man nɛ mɛsosa nɛ̀ kimɔ temɔ. ");
INSERT INTO kkj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɓo ɗikima lukse Njambiyɛ, ɛ ɓomɔ hɛnɛ tɔndɛ ɓo. Kumande Yesus ɗikima dokiɗye ɓotu ɓete ɓe ma yeŋsa temɔ jayɛ nyɛ ɓaka kɛ njɔŋ yan mɛtu hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wɛtɛ ɓekoko Piyɛr ɓenɛ Jaŋ ɓa̧ kɛ kɛ̀ kɛ mbanjɔ Njambiyɛ kɛ ŋgimɔ mɛŋgwɛta te yi hawa yitati. ");
INSERT INTO kkj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wɛtɛ mɔ jɛmti ɓa̧ kɛ kɛki numɛy mbanjɔ Njambiyɛ. Ɓo ɗikima jeɓa numɛy te nde Nyɔŋɔ. Kandɛ yi ɓo ma jáki nɛ mbam te, a tì kɛndɛ wɛtɛ yesɔ na. Ɓo ɗikima soɓɛ nyɛ mɛtu hɛnɛ kɛ̀ tikɔ kɛ kɛki numɛy, na ɗiki jɔmbu yasi kɛ mɛɓɔ mɛ ɓotu ɓete ɓe ɗikima nyiŋɛ kɛ mbanjɔ Njambiyɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kɛ nyɛ ma ɓɛŋɛ nde, Piyɛr ɓenɛ Jaŋ kɛ kwaɗyɛ nyiŋɛ mbanjɔ Njambiyɛ kɛ́, ɛ nyɛ jɔmbɛ yasi kɛ mɛɓɔ man. ");
INSERT INTO kkj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ɛ ɓo ɓɛŋɛ nyɛ nɛ ŋgoŋ. Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɛ nyɛ tikɛ misi kɛ yotu yan takɛ nde, ɓo ta nyɛ nyɛ yaŋa. ");
INSERT INTO kkj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yasi wɛtɛ, ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Nɛ̀ mɔni nɛ̀ lɔr, mi yeti nɔ na, yasi te yi mi nɔ kɛ́, mi kɛ nyɛ wɛ yo: Kɛ ɗinɔ Yesus Krist te ɛ Nasarɛt tɛma, kɛndɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ɛ Piyɛr kɛnjɛ ɓɔ ɓiye nɛ nyɛ kɛ mbam ɓɔ tɛmbiɗye. Ndana ndana, ɛ mɛkol mɛnɛ nɛ̀ mɛmbɔŋgɔlɔ mɛnɛ si ŋgbi. ");
INSERT INTO kkj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɛ nyɛ ɗo ndi ŋga wɛtɛ tɛmɛ kandɛ kɛndi nyiŋɛ nɔ ɓenɛ ɓo kɛ mbanjɔ Njambiyɛ ndi nɛ mɛɗɔ nɛ̀ luksa Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓomɔ hɛnɛ ɓɛŋma nyɛ kɛ kɛndɔ, ɓɛŋɛ sendi nyɛ kɛ lukse Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓo ɓɛŋma duwɛ nde, yo nyɛ ɛ ɗikima ɗiyɔ jɔmbɔ mɛyasi kɛ numɛy mbanjɔ Njambiyɛ te yi ɓo ɗikima jeɓa nde Nyɔŋɔ kɔ. Yo kwaŋma ɓomɔ, ɛ ɓo ŋgbakima ɓuɗyate kɛ yasi te yi kelnama kɛ yotu mbam kɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A tì kwaɗyɛ jisɛ kɛ kɛki Piyɛr ɓenɛ Jaŋ na. Ɓomɔ ŋgbakimama ɓuɗyate, ɛ ɓo sɛɗyɛ kɛ̀ komɛ ɓe Piyɛr ɓa̧ kɛ mbɛy komɛ ɓomɔ ɗikima kɛndɔ kɛte kɛ mbanjɔ Njambiyɛ kɛ́. Ɓo ɗikima jeɓa mbɛy te nde Nje Salomɔŋ. ");
INSERT INTO kkj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kɛ Piyɛr ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓomɔ nde: «Wunɛ ɓotu ɓe kandɔ Isarayɛl, kɛto ŋge yi wunɛ ŋgbakima yasi te yi kelnama kɛ yotu mbam kɔ kɛ́? Kɛto ŋge yi wunɛ ɓɛŋɛ wusɛ nɛ ŋgoŋ ɗete kɛ́? ’Wunɛ táka ka nde, yo wusɛ kelɛ nde, mbam kɔ kɛ̂ndi nɛ ɗeti te yusu, ho nde, a kɛ́ndi, kɛto wusɛ kɛ kanɔ Njambiyɛ ɓuɗyate? ");
INSERT INTO kkj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yo Njambiyɛ te ɛ ɓesaŋmbambɔ ɓusu Abaraham, Isak nɛ̀ Yakɔp, Njambiyɛ te yi ɓo ɓa̧ kanɔ kɔ nyɛ mɔ mɛsay wenɛ Yesus luksa, Yesus te yi wunɛ ɓoŋma nyɛ nyɛ ɓekum, sɛŋɛ nyɛ kɛ mbɔmbu yan kutuɗya kɔ, ko ɓɛkɔ nde, Pilat kwaɗya soŋɛ ɓɔ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wunɛ sɛŋma Mɔ te yi Njambiyɛ tɔkuma, ŋgbeŋ mɔ kɔ, kpalɔ diyɛ nde, ɓo sôŋa ɓɔ nɛ mɔ wona ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wunɛ woma Kumande te ɛ nyɛ joŋgwɛ kɔ. Ko ɗete, Njambiyɛ womiya nyɛ kɛ njoka ɓemuŋ. Wusɛ hɛnɛ ɓɛŋma duwɛ ɗete. ");
INSERT INTO kkj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yo ɗeti te yi ɗiyɛ kɛ ɗinɔ ɗyenɛ kɛ́ tɛmbiɗye mbam kɔ yi wunɛ ɓɛŋɛ nɛ̀ yi wunɛ duwa̧ kɔ kɛto tikina temɔ kɛ ɗinɔ te. Yo tikina temɔ kɛ yi Yesus te kelɛ nde, kɔsu mbam kɔ sîy nda yi wunɛ ɓɛŋma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Wunɛ njɔŋ, ndana mi duwa̧ nde, wúnɛ ɓekum ɓun kelma ɗete nɛ tum. ");
INSERT INTO kkj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yo nde, Njambiyɛ kelma ɗete yí tonjɛ nɛ mɛlɛpi mɛte yi nyɛ kikima lɛpɔ kɛ numbu ɓotu ɓe punja mɛlɛpi mɛnɛ hɛnɛ nde, *Krist wenɛ ta saŋgwa nɛ mɛbɔnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ɗete, wunɛ jâya mɛɓeyɔ mun, nɛ̀ wunɛ yêŋsaŋgwɛ temɔ, nɛ́ Njambiyɛ soŋ mɛɓeyɔ mun, ");
INSERT INTO kkj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nɛ́ Baba Mbokɔ njesɛ kimɔ tɛ ŋgimɔ. Ɗete, a ta njesɛ sendi *Krist, yite nde Yesus, mɔ te yi nyɛ kpoma nde, a ta tomɔ kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kɛ ŋgimɔ te yɔkɔ ndana Yesus Krist ta ɗiyɔ kɛ ɗyoɓɔ kumɔ kɛ ŋgimɔ te yi mɛyasi hɛnɛ ta si kombila nda yi Njambiyɛ kikima lɛpɔ kɛ́. Njambiyɛ lɛpima yo kɛ numbu pupuna ɓotu ɓe punja mɛlɛpi mɛnɛ ɓe ɗiyma kɛ mɛtu mɛ njimɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mɔyisi lɛpima nde: ‹Baba Mbokɔ te Njambiyɛ wun ta tɛmbiɗye wɛtɛ mumɔ kɛ njoka ɓemaŋ ɓun. A ta ɓɛ mɔ punja mɛlɛpi mɛnɛ nda mi. Wunɛ ta wokuna nɛ nyɛ kɛ mɛyasi hɛnɛ te yi nyɛ ta lɛpɔ nyɛ wunɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yasi wɛtɛ, mumɔ hɛnɛ ɛ ta ɗiyɔ kinɛ wokuna nɛ mɔ punja mɛlɛpi mɛ Njambiyɛ te kɔ, ɓo ta wo mɔ te soŋɛ kɛ *Kandɔ Njambiyɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ, kandɛ kɛ Samiyɛl kumɔ kɛ ɓaka ɓe nja̧ nje kɛ kɔŋ nɛ ɓaka, ɓo hɛnɛ tapitama lɛpɔ kasi mɛtu mɛte. ");
INSERT INTO kkj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Wunɛ ɓɔnɔ ɓe ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ, wunɛ jaɗya kɛ mɔy mbon te yi Njambiyɛ kelma ɓenɛ ɓesaŋmbambɔ ɓusu kɛ́. Njambiyɛ lɛpima nyɛ Abaraham nde: ‹Mɛkandɔ mɛ ɓomɔ hɛnɛ kɛ to mɛnɛti ta ɓɛ nɛ mɛkombila kɛto ɓenday ɓɔ.› ");
INSERT INTO kkj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yo ɗiŋ kɛto yun yi Njambiyɛ tɔkuma mɔ mɛsay wenɛ. A tomma nyɛ njesɛ, na nje nyɛ wunɛ mɛkombila yí kelɔ nde, mumɔ hɛnɛ tîki ɓeya mɛkele mɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piŋɔ te yi Piyɛr ɓenɛ Jaŋ ɓa̧ ndi kɛ lɛpina nyɛ ɓomɔ kɛ́, ɛ ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ kum ɓesɔja te ɛ ɗiyɛ nɛ ɓotu ɓete ɓe ɓakiɗye mbanjɔ Njambiyɛ ɓaka nɛ̀ *Ɓesadusɛ̧ nje dolɔ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɓo ɓa̧ nɛ ŋgambi suŋgwɛ nɛ Piyɛr ɓenɛ Jaŋ, kɛto ɓo ɗikima lɛpɔ nyɛ ɓomɔ nde, ɓemuŋ ta womiyɛ, kɛto Yesus womiya sendi kɛ njoka ɓemuŋ. ");
INSERT INTO kkj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɛ ɓo ɓiye ɓo yaɗyɛ kɛ tu̧ jɔɓɔ kumɔ misi pupɛ, kɛto ɓo ɓiya ɓo ɓekoko. ");
INSERT INTO kkj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ko ɓɛkɔ ɗete, kɛ njoka ɓotu ɓete ɓe wokuma mɛlɛpi mɛte yi Piyɛr ɓenɛ Jaŋ lɛpima kɛ́, ɓuɗyate tikima temɔ kɛ yi Kumande Yesus. Ɓotu ɓete ɓe tikima temɔ ɗete ɓaka kumma nda ɓembam tomay yitan. ");
INSERT INTO kkj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kɛ kiya misi pupɛ te, ɛ ɓekum nɛ̀ ɓetomba ɓe ɗya nɛ̀ ɓotu ɓe kɛtina mɛyasi wesiɗya kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hana te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓa̧ kɛ njokate. Kayif nɛ̀ Jaŋ nɛ̀ Alɛksaŋdɛrɛ nɛ̀ ɓomɔ hɛnɛ ɓe ɓa̧ nɛ jaɗyɛ ɓenɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɓaka ɓa̧ sendi kɛte. ");
INSERT INTO kkj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɛ ɓo ɓu̧ Piyɛr ɓenɛ Jaŋ tɛmbiɗye kɛ mbɔmbu yan diyɛ ɓo nde: «Yo nda nyɛ wunɛ ɗeti, ho yo kɛ ɗinɔ nda yi wunɛ siɗya nɛ kɔsu mbam kɔ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kimɔ Sisiŋ ɓa̧ tondunate kɛ yotu Piyɛr, ɛ nyɛ lɛpɛ nyɛ ɓo nde: «Wunɛ ɓekum nɛ̀ wunɛ ɓetomba ɓe kandɔ Isarayɛl, ");
INSERT INTO kkj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wunɛ kɛ diyɛ wusɛ mɛdiyan ndana kɛto kimɔ mɛkele mɛte yi kelnama kɛ yotu mɔ te ɛ ma kɔsɔ kɔ. Wunɛ kɛ diyɛ nde, wusɛ lɛ̂pi nda yi kɔsu nɛ siyma nɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wunɛ hɛnɛ nɛ̀ kandɔ Isarayɛl hɛnɛ, wunɛ dûkwɛ nde, wunɛ ɓɛ́ŋa mbam kɔ ndana nɛ kimɔ yotu nɛ hɛnɛ kɛ mbɔmbu yun kɛto ɗinɔ Yesus Krist te ɛ Nasarɛt. Yo Yesus te yi wunɛ ŋgbama kɛ kroa, ɛ Njambiyɛ nje womiyɛ nyɛ soŋɛ kɛ njoka ɓemuŋ kɔ, yo nyɛ kelɛ nde, wunɛ ɓɛ̂ŋa mbam kɔ ndana ɗekɛ. ");
INSERT INTO kkj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus nyɛ Tari*f1* te yi wunɛ ɓotu ɓe sumna njumɔ sɛŋma. Yo tari te nje ɓɛ saŋgwɛ kondu ndana. ");
INSERT INTO kkj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kinɛ wɛtɛ mumɔ yakama nyɛ ɓomɔ joŋgwɛ na, kɛto kinɛ wɛtɛ ɗinɔ yi Njambiyɛ nya kɛ njoka ɓomɔ yi yakama nyɛ wusɛ joŋgwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɓo ŋgbakimama ɓuɗyate, kɛto ɓo ɓɛŋma nde, Piyɛr ɓenɛ Jaŋ kɛ nyɛ temɔ yan hɛnɛ kɛ yasi te yi ɓo lɛpɛ kɛ́, duwɛ sendi nde, ɓo tì ɓɛ ɓotu ɓe duwa̧ mɛkana na. Ɓo duwa̧ ɓo, kɛto Piyɛr ɓenɛ Jaŋ joŋnama ɓenɛ ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ɓomɔ ɓaka ɓɛŋma mɔ kɔsu te yi Piyɛr ɓenɛ Jaŋ joŋgwa kɔ kɛ kɛki yan. Ɗete, ɓo tì ɓɛ se nɛ yaŋa te yi lɛpɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓo nja̧ lɛpɔ nyɛ ɓo nde, ɓo pûndu kɛ mbanjɔ jɔsi. Ɛ ɓo nje tika nɛmbɛ lɛpɔ tandɛ yan nde: ");
INSERT INTO kkj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Hɛ ta kelɔ nan nɛ ɓotu ɓaka? Kɛto yo yeti kɛ sɔ na, ɓomɔ hɛnɛ kɛ Yerusalɛm duwa̧ nde, ɓo kelma wɛtɛ mɛyekambiyɛ yi ɓa̧ kpekum. Sendi, wusɛ yeti nɛ ɗeti te yi ɓiye mɛso na. ");
INSERT INTO kkj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ko ɓɛkɔ ɗete, yí kelɔ nde, kasi te tî nyanjaŋgwɛ kɛ mɛtɔ mɛ ɓomɔ, wusɛ kîɗyikwɛ ɓo nɛ mɛnje hɛnɛ nde, ɓo tî lɛpi kasi Yesus te nyɛ wɛtɛ mumɔ na.» ");
INSERT INTO kkj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ɛ ɓo jeɓa Piyɛr ɓenɛ Jaŋ lɛpɔ kimɔte nyɛ ɓo nde, kpɛ, ɓo tî ɓuta se numbu lɛpɔ ho teɗye yiŋa yasi nyɛ ɓomɔ kɛ kasi Yesus na. ");
INSERT INTO kkj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ko ɓɛkɔ ɗete, ɛ Piyɛr ɓenɛ Jaŋ lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun pɛ̂si, ŋgɛ ɓɛ nde, yo nɛ ŋgbeŋ kɛ misi mɛ Njambiyɛ nde, ɓomɔ wôkunaŋgwɛ nɛ wunɛ ho ɓo wôkunaŋgwɛ nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yasi wɛtɛ, wusɛ tí yaka ɗiyɔ kinɛ lɛpɔ yasi te yi wusɛ ɓɛŋma nɛ̀ yi wusɛ wokuma kɛ́ na.» ");
INSERT INTO kkj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɛ ɓo ɓasiɗye ŋgaliyɛ misi nyɛ Piyɛr ɓenɛ Jaŋ. Kɛ kɔŋte, ɛ ɓo nje soŋɛ ɓɔ nɛ ɓo. Ɓo tì ɓɛ nɛ nje te yi pɔnse ɓo na, kɛto ɓo ɓa̧ kɛ kambɔ ɓomɔ, kɛto ɓomɔ ɓa̧ kɛ lukse Njambiyɛ kɛ yasi te yi kwaŋnama kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mɛsew mɛ mbam te yi Njambiyɛ kelma mɛyekambiyɛ te yinɔri kɛ yotu nɛ siɗyɛ kɔsu nɛ kɔ kwaŋma mɛsew kamɔni. ");
INSERT INTO kkj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kɛ ɓo ma soŋɛ ɓɔ nɛ ɓo kɛ́, ɛ ɓo kwa̧ kɛ̀ kɛ yasi ɓenjɔŋ ɓan. Ɛ ɓo yekiɗye yasi te yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba ɓe ɗya lɛpima nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kɛ ɓenjɔŋ ɓan ma wokɔ yasi te yi ɓe Piyɛr yekiɗya nyɛ ɓo kɛ́, ɛ ɓo hɛnɛ kaŋɛ mɛn ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: «Sa Mbokɔ, yo wɛ kusɛ ɗyoɓɔ nɛ̀ mɛnɛti nɛ̀ maŋ nɛ̀ mɛyasi hɛnɛ te yi ɗiyɛ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yo wɛ lɛpɛ nɛ nje Kimɔ Sisiŋ kɛ numbu saŋmbambɔ wusu, mɔ mɛsay wɔ Davit nde: ‹Ŋge kelɛ yi ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ kelɛ yasi ndana nda ŋgoŋgo njomɔ kɛ́? Ŋge kelɛ nde, mɛkandɔ mɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka ɓɛ̂ki nɛ ɓeya mɛtakɛ ɗekɛ? ");
INSERT INTO kkj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ɓekumande ɓete ɓe namɛ mɛnɛti ɓaka ma komsa ɗyambi. Ɓekum sendi ma saŋgwɛ ŋgiŋ suŋgwɛ nɛ Baba Mbokɔ ɓenɛ *Krist wenɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kɛto nɛ̀ Herod nɛ̀ Pɔnsi Pilat nɛ̀ yiŋa mɛkandɔ ɓu̧ sendi mɛkandɔ mɛ ɓotu ɓe Isarayɛl ma saŋgwɛ ŋgiŋ kɛ ɗyari kɛ suŋgwɛ nɛ kimɔ mɔ mɛsay wɔ Yesus te yi wɛ tɔkuma kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɓo kelma ɗete yí tonjɛ nɛ mɛyasi hɛnɛ te yi wɛ kikima si kpo nɛ ɗeti yɔ nda yi wɛ kwaɗya nde, yo kêlnaŋgwɛ ɗete kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yori Baba Mbokɔ, ɓɛŋa nda yi ɓo ɓeliyɛ misi suŋgwɛ nɛ wusɛ kɛ́. Kelɔ nde, wusɛ ɓotu ɓe mɛsay ɓɔ lɛ̂pi mɛlɛpi mɔ kinɛ wɔ̧ na. ");
INSERT INTO kkj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɗete, ɓuta ɓɔ yɔ, nɛ́ mɛkɔn mɛ ɓomɔ siy, nɛ́ mɛyekambiyɛ nɛ nyaŋgwɛ mɛyasi kelna nɛ ɗinɔ kimɔ mɔ mɛsay wɔ Yesus.» ");
INSERT INTO kkj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kɛ ɓo ma siɗyɛ mɛŋgwɛta nɛ Njambiyɛ kɛ́, ɛ mbɛy te yi ɓo wesiɗyama kɛte kɛ́ ŋgwaŋgwa. Ɛ Kimɔ Sisiŋ tondɛ kɛ yotu yan. Ɛ ɓo kandɛ lɛpina mɛlɛpi mɛ Njambiyɛ kinɛ wɔ̧ na. ");
INSERT INTO kkj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɓomɔ hɛnɛ ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka ɓa̧ ndi temɔ wɛtɛ nɛ mɛtakɛ wɛtɛ. Mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yan tì lɛpɛ nde, mɛyasi mɛnɛ wókunaŋgwɛ ndi nɛ nyɛ na. Yasi wɛtɛ, yasi hɛnɛ ɓa̧ yi ɓomɔ hɛnɛ kɛ njoka yan. ");
INSERT INTO kkj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɓotu ɓe tomun ɓe Yesus ɗikima lɛpɔ kasi womiya Kumande Yesus nɛ nyaŋgwɛ ɗeti. Njambiyɛ nya ɓo hɛnɛ nyaŋgwɛ mɛkombila. ");
INSERT INTO kkj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mumɔ wɛtɛ nɛ wɛtɛ tì ɓɛ nɛ ŋgwɛtɛ kɛ njoka yan na. Ɓotu ɓete ɓe ɓa̧ nɛ mɛŋgwaŋ ho nɛ mɛtu̧ ɓaka ɗikima ɗyaŋgwɛ yo, ɓu̧ mɔni te ");
INSERT INTO kkj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nje jokwɛ kɛ nji̧ mɛkol mɛ ɓotu ɓe tomun ɓe Yesus. Ɛ ɓo ɗiki nje kaɓɔ nyɛ ɓomɔ hɛnɛ. Ɓo nya mumɔ hɛnɛ ɓeŋgwɛ yasi te yi ɓanɛ nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yo ɓa̧ nɛ wɛtɛ mbam nde Yosɛp, mɔ kandɔ *Levi, ɓo jáki nyɛ kɛ Siprɛ. Ɓotu ɓe tomun ɓe Yesus loma nyɛ nde Barnabas, yite nde Mɔ nyɛna mɛŋgitɛ. ");
INSERT INTO kkj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A ɓa̧ nɛ ŋgwaŋ, ɛ nyɛ ɗyaŋgwɛ yo ɓu̧ mɔni te nje jokwɛ kɛ mɛkol mɛ ɓotu ɓe tomun ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Yasi wɛtɛ, wɛtɛ mbam nde Ananiyas ɓenɛ nyari wenɛ Safira ɗyaŋgwa pɛl mɛnɛti man. ");
INSERT INTO kkj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɛ nyɛ wokuna ɓenɛ nyari ɓakɛ sumba ɓakiɗye ŋgaɓiyɛ te wɛtɛ. Ɛ nyɛ nje ɓu̧ ɓukwɛ te kɛ̀ jokwɛ kɛ mɛkol mɛ ɓotu ɓe tomun ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ɛ Piyɛr diyɛ nyɛ nde: «Ananiyas, ŋge kelɛ nde, *Satan si ŋgaŋgile temɔ yɔ yí kelɔ nde, kelɔ ja̧ nyɛ Kimɔ Sisiŋ, yí kelɔ sendi nde, ɓakiɗya yiŋa ŋgaɓiyɛ mɔni ŋgwaŋ te yi wɛ ɗyaŋgwa kɛ́? ");
INSERT INTO kkj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wɛ má ɗiy kinɛ ɗyaŋgwɛ ŋgwaŋ te, ’ma yo yeti ndi ŋgwaŋ yɔ na? ’Kɛ kɔŋ ɗyaŋgwate, mɔni te yeti ndi yɔ na? Ŋge kelɛ yi wɛ ɓa̧ nɛ kwalɔ mɛtakɛ mɛte yikɛ kɛ temɔ yɔ kɛ́? Wɛ ti kél ja̧ nyɛ ɓomɔ na, yasi wɛtɛ, wɛ kél ja̧ nyɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kɛ Ananiyas ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ nyɛ ɓalɛ nɛ pet sanjaŋ kwa̧ gwe. Ɛ ɓomɔ hɛnɛ ɓe ɓa̧ womɛte ɓaka gwe wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ɛ ɓegwanjɔ nje ɓɔyɛ nyɛ nɛ lambɔ gbaŋgɛ nyɛ kɛ̀ pumbu. ");
INSERT INTO kkj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɗiyɔ nda hawa yitati kɛ kɔŋte kɛ́, ɛ nyari nyiŋɛ tu̧ kinɛ duwɛ yasi te yi kwaŋnama kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ɛ Piyɛr diyɛ nyɛ nde: «Lɛpɔ nyɛ mi, ŋgwaŋ te yi wunɛ ɗyaŋgwa kɛ́, ɓuyɔ mɔni te hɛnɛ kɛ?» Ɛ nyɛ yeŋsa nde: «I̧, siya te ri.» ");
INSERT INTO kkj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «’Wúnɛ njoŋɔ síki kpo ŋgiŋ yí ɓoɓɛ nɛ Sisiŋ Baba Mbokɔ kɛto ŋge? Dukwɛ nde: Ɓotu ɓete ɓe ɓoŋma njoŋɔ kɛ̀ pumbu ɓaka kɛ numɛy, ɓo ta gbaŋgɛ sendi wɛ kwa̧ nɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɛ Safira ɓalɛ nɛ pet sanjaŋ ndi ŋga wɛtɛ kɛ mɛkol mɛ Piyɛr kwa̧ gwe. Ɓegwanjɔ nyiŋma tu̧ dolɔ nde, a gwa̧, ɛ ɓo gbaŋgɛ nyɛ kwa̧ nɔ kɛ̀ pumbɔ kɛ kɛki njom. ");
INSERT INTO kkj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Njɔŋ ɓomɔ hɛnɛ ɓe tikima temɔ kɛ yi Kumande Yesus nɛ̀ ɓomɔ hɛnɛ ɓe wokuma mɛyasi mɛnɔri ɓaka gwa̧ wɔ̧ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɓotu ɓe tomun ɓe Yesus ɗikima kelɔ ɓuɗya mɛyekambiyɛ nɛ̀ ɓuɗya nyaŋgwɛ mɛyasi kɛ njoka ɓomɔ. Ɓo ɗikima wesiɗya ɓo hɛnɛ kɛ wɛtɛ mbɛy nde Nje Salomɔŋ kɛ mɔy mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gbɛla mumɔ wɛtɛ nɛ wɛtɛ tì ɓoɓɛ nyiŋɛ kɛ njɔŋ yan na, ko ɓɛkɔ ɗete, ɓomɔ ɓa̧ kɛ tɔndɔ ɓo ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɓomɔ ɓuɗyate ɓa̧ kɛ tikɔ temɔ kɛ yi Kumande Yesus. Yo ɓa̧ ɓembam nɛ̀ ɓomari. Njambiyɛ ɓa̧ kɛ dokiɗye ɓomɔ kɛ njɔŋ yan. ");
INSERT INTO kkj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɗete, ɓomɔ ɗikima ɓu̧ ɓotu ɓe kɔn kɛ̀ nɔ kɛ kɛki mɛnje niŋgwɛ ɓo kɛ mɛtaŋ nɛ̀ kɛ mɛdele, simande wukumɛ yotu Piyɛr ta kɛ̀ kɛ yotu ɓaŋa kɛ ŋgimɔ te yi nyɛ ta kwa̧ kɛ̀. ");
INSERT INTO kkj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɓaŋa ɓomɔ ɓuɗyate nja̧ sendi wulɛ kɛ mɛɗya mɛte yi ɓa̧ kɛ kɛki Yerusalɛm kɛ́. Ɓo nja̧ nɛ ɓotu ɓe kɔn nɛ̀ ɓotu ɓete ɓe ɓeya mɛsisiŋ ɗikima njaŋgwɛ ɓo ɓaka. Ɛ mɛkɔn man hɛnɛ siyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndana, ɛ ɓeya temɔ kwa̧ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓomɔ hɛnɛ ɓe ɓa̧ ɓenɛ ɓo ɓaka. Ɓo ɓa̧ kɛ njɔŋ *Ɓesadusɛ̧. ");
INSERT INTO kkj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓo ɓiyma ɓotu ɓe tomun ɓe Yesus kɛnjɛ kɛ nyaŋgwɛ tu̧ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ko ɓɛkɔ ɗete, wɛtɛ jaki Baba Mbokɔ nja̧ nɛ tu ɓutɛ mɛnumɛy mɛ tu̧ jɔɓɔ punjɛ ɓo lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Nɛ kwâŋ kɛ̀ kɛ mbanjɔ Njambiyɛ kɛ̀ lɛpɔ mɛlɛpi hɛnɛ kɛ kasi joŋgwɛ te yi kpo nɛ kpo te yikɛ nyɛ ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kɛ ɓo ma wokɔ ɗete kɛ́, ɛ ɓo kwa̧ ɓemɛŋmɛnɛ nɛ sut nyiŋɛ kɛ mbanjɔ Njambiyɛ. Kɛ kɔŋte, ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɗya̧ ɓenɛ ɓotu ɓenɛ, jeɓa ɓotu ɓe nyaŋgwɛ jɔsi Ɓeyudɛn nɛ̀ ɓetomba ɓe mɛmbanjɔ mɛwesiɗya Ɓeyudɛn hɛnɛ kɛ kandɔ Isarayɛl. Ɛ ɓo tomɛ ɓomɔ kɛ̀ jeɓa nɛ ɓotu ɓe tomun ɓe Yesus kɛ tu̧ jɔɓɔ nje nɔ. ");
INSERT INTO kkj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɓesɔja ɓete yi ɓo tomma ɓaka ka̧ kumɔ kɛ tu̧ jɔɓɔ kinɛ dolɔ ɓo na. Ɛ ɓo yɔkwɛ nje lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Wusɛ dolma numɛy tu̧ jɔɓɔ kimɔ ndaɗyate. Ɓotu ɓe ɓakiɗya tu̧ jɔɓɔ ɓa̧ sendi kɛ numɛy. Yasi wɛtɛ, kɛ wusɛ ma ɓutɛ numɛy, wusɛ tì dolɛ mumɔ wɛtɛ nɛ wɛtɛ kɛ mɔyte na.» ");
INSERT INTO kkj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kɛ kum ɓesɔja ɓe ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ nɛ̀ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ma wokɔ ɗete kɛ́, ɛ sosu yan siyɛ. Ɓo tì duwɛ nda yi ɓo yakama kɛ̀ nɛ lɛpi te mbɔmbu na. ");
INSERT INTO kkj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ɗiyɔ kɛ́, ɛ wɛtɛ mumɔ nje lɛpɔ nyɛ ɓo nde: «Wunɛ dûkwɛ nde, ɓembam ɓete ɓe wunɛ nya kɛ jɔɓɔ ɓaka mɛ kɛ mbanjɔ Njambiyɛ kɛ lɛpina nyɛ ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ndana, ɛ kum ɓesɔja ɓe ɓotu ɓe ɓakiɗya mbanjɔ Njambiyɛ ɓu̧ ɓesɔja kɛ̀ ɓu̧ nɛ ɓotu ɓe tomun ɓe Yesus nje nɔ. Ɓesɔja ɓa̧ kɛ gwe kaŋ yotu yan nde, ɓomɔ mɛ nje lu̧ ɓo nɛ mɛtari wo. Ɗete, ɛ ɓo ɓu̧ ɓotu ɓe tomun ɓe Yesus nɛ tɛ nje nɔ. Ɓo ɓoŋma ɓo nɛ tɛ nje nɔ, kɛto ɓesɔja ɓa̧ kɛ kambɔ nde, ɓomɔ mɛ nje lu̧ ɓo nɛ mɛtari wo. ");
INSERT INTO kkj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ɓo ɓoŋma ɓo ɗya̧ nɔ kɛ mbɔmbu ɓotu ɓe nyaŋgwɛ jɔsi Ɓeyudɛn. Ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ lɛpɛ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«’Wusɛ tì kiɗyɛ wunɛ nde, wunɛ tî ɓoɓa lɛpɔ kasi mbam ɛnɔru nyɛ ɓomɔ na? Ndana wunɛ ma si lapiɗye mɛlɛpi mɛte yi wunɛ teɗye kɛ́ kɛ Yerusalɛm. Sendi, wunɛ kɛ kwaɗyɛ kelɔ nde, simbo sɔŋ nɛ ɓâl kɛ to su.» ");
INSERT INTO kkj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ɛ Piyɛr ɓenɛ ɓotu ɓe tomun ɓe Yesus yeŋsa nde: «Nɛ̀ Njambiyɛ nɛ̀ ɓomɔ, wusɛ yâkaŋgwɛ wokuna nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Njambiyɛ te ɛ ɓesaŋmbambɔ ɓusu ɗikima kanɔ kɔ womiya Yesus te yi wunɛ ŋgbama kɛ kroa wo kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Njambiyɛ ɓendiɗya nyɛ tikɔ kɛ mbam ɓɔ nɛ, tɛmbiɗye nyɛ Nyaŋgwɛ Kumande, tɛmbiɗye sendi nyɛ mɔ te ɛ ta joŋgwɛ ɓomɔ kɔ. A ta kelɔ nde, ɓotu ɓe kandɔ Isarayɛl yêŋsaŋgwɛ temɔ, nɛ́ Njambiyɛ tiki mɛɓeyɔ man nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wusɛ kɛ lɛpɔ su sinɛ ɓe Kimɔ Sisiŋ te yi Njambiyɛ nya ɓotu ɓete ɓe wokuna nɛ nyɛ ɓaka nde, mɛyasi mɛte gbakasi.» ");
INSERT INTO kkj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kɛ ɓotu ɓete ɓe ɓa̧ kɛ nyaŋgwɛ jɔsi te ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ ɓoku nyiŋɛ to yan. Ɓo kwaɗya wo ɓotu ɓe tomun ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yasi wɛtɛ, ɛ wɛtɛ mbam nde Gamaliyɛl ɛ ɓa̧ kɛ njoka ɓotu ɓe nyaŋgwɛ jɔsi te kɔ tɛmɛ. A ɓa̧ kɛ njɔŋ *Ɓefarisɛ̧. A ɓa̧ sendi nyaŋgwɛ mɔ duwa̧ mɛmboŋga. Ɓomɔ hɛnɛ ɗikima jɛsɔ nyɛ. Ɛ nyɛ lɛpɛ nde, ɓo pâŋ pa punjɛ ɓotu ɓe tomun ɓe Yesus nɛ mbɛt kɛnjɛ sɛ̧. ");
INSERT INTO kkj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kɛ kɔŋte, ɛ nyɛ nje lɛpɔ nyɛ ɓotu ɓe nyaŋgwɛ jɔsi nde: «Wunɛ ɓotu ɓe kandɔ Isarayɛl, wunɛ ɗîy nɛ sɔsɔ kɛ yasi te yi wunɛ ta kelɔ nɛ ɓomɔ ɓaka kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kɛto mɛtu mɛte tì pa kikɔ na yi wɛtɛ mbam nde Tedas ɗyaŋma nɔ kɛ́. A ɗikima lɛpɔ nde, nyɛ mbendɔ, ɛ ɓomɔ nda gɔmay yini jaŋgwɛ kol nɛ nyɛ. Ɓaŋa ɓomɔ nja̧ wo Tedas, ɛ ɓomɔ hɛnɛ ɓe jaŋgwa kol nɛ nyɛ ɓaka si posiyɛ, ɛ kasi yan yambile. ");
INSERT INTO kkj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kɛ kɔŋ Tedas, ɛ Yude ɗya̧ kɛ ŋgimɔ tɔlna ɓomɔ. A ɓa̧ mɔ Galile, a ɗalma ɓomɔ ɓuɗyate nyinje kɛ njɔŋ nɛ. Ɛ ɓo wo nyɛ sendi, ɛ ɓomɔ hɛnɛ te ɓe jaŋgwa kol nɛ nyɛ ɓaka si posiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yori yi mi lɛpɛ ndana nyɛ wunɛ nde, wunɛ tî kel se yaŋa nɛ ɓotu ɓaka na, wunɛ tîki ɓo, nɛ́ ɓo kwa̧. Kɛto ŋgɛ ɓɛ nde, yasi te yi ɓo kwaɗyɛ kelɔ nɛ̀ mɛkele mɛte yi ɓo kelɛ kɛ́ wúla kɛ ɗyanɔ ɓomɔ, yo ta yambile. ");
INSERT INTO kkj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yasi wɛtɛ, ŋgɛ ɓɛ nde, yo mɛkele mɛ Njambiyɛ, wunɛ yeti nɛ ɗeti te yi yaŋgile yo na. Wunɛ ɗîy nɛ sɔsɔ, ma wunɛ mɛ nje lu̧ ɗyambi suŋgwɛ nɛ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɛ ɓo jayɛ lɛpi Gamaliyɛl. Ɛ ɓo jeɓa ɓotu ɓe tomun ɓe Yesus nje nɔ. Ɛ ɓo kwa̧ njurɔ ɓo kiɗyɛ ɓo nde, ɓo tî lɛpi se ɗinɔ Yesus na. Kɛ kɔŋte, ɛ ɓo nje soŋɛ ɓɔ nɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɓotu ɓe tomun ɓe Yesus yɔkwa̧ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn nɛ mɛsosa, kɛto Njambiyɛ ɓɛŋma nde, ɓo yakama saŋgwa nɛ mɛbɔnɛ kɛto ɗinɔ Yesus Krist. ");
INSERT INTO kkj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɓo ka̧ mbɔmbu teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ mɛtu hɛnɛ kɛ mɔy mbanjɔ Njambiyɛ nɛ̀ kɛ mɔy mɛtu̧, lɛpɔ sendi Kimɔ Tom *Krist, yite nde Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kɛ ŋgimɔ te yite ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus ɓaka ɓa̧ kɛ ɓuyɔ kɛ̀ nɔ mbɔmbu. Ɛ Ɓeyudɛn ɓete ɓe ɓa̧ kɛ njokate ɓe ɓa̧ kɛ lɛpɔ numbu Grɛk ɓaka lɛpina ɓeyate nɛ *Ɓehebere te ɓɔnɔ ɓe ɗya, kɛto ɓekusɔ ɓoma ɓete ɓe ɓa̧ kɛ njɔŋ te yan ɓaka. Ɓo lɛpinama ɗete kɛ kasi mɛsay mɛ kaɓina mɛyasi mɛte yi ɓo ɗikima kelɔ mɛtu hɛnɛ kɛ́. Kɛto Ɓeyudɛn te ɓɔnɔ ɓe ɗya tì ɓɛ kɛ takɛ ɓekusɔ ɓomari te ɓan na. ");
INSERT INTO kkj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɛ ɓotu ɓe tomun ɓe Yesus kamɔ jɔ yiɓa wesiɗye ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus hɛnɛ ɓaka lɛpɔ nyɛ ɓo nde: «Yo ti yaka nde, wusɛ tîki lɛpina Kimɔ Tom Njambiyɛ kpalɔ nje kelɔ mɛsay mɛ kaɓina mɛɗye na. ");
INSERT INTO kkj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wunɛ njɔŋ, ɗete wunɛ tɔ̂ka ɓembam yitan jɔ yiɓa kɛ njoka yun. Ɓo ɓɛ̂ki ɓotu ɓete ɓe ɓomɔ kɛ jayɛ ɓo, ɓɛ tondunate nɛ Kimɔ Sisiŋ, ɓɛ sendi ɓotu ɓe ɗyanɔ, nɛ́ wusɛ kaŋ mɛsay mɛte yite nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɗete, wusɛ ta kɛ̀ su mbɔmbu yí ŋgwɛta nɛ Njambiyɛ, yí lɛpɔ mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ mɛŋgimɔ hɛnɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɛ ɓomɔ hɛnɛ jayɛ lɛpi te. Ɛ ɓo tɔkɛ Itɛn. A ɓa̧ kɛ tikɔ temɔ nɛ hɛnɛ kɛ yi Njambiyɛ, ɓɛ sendi tondunate nɛ Kimɔ Sisiŋ. Ɛ ɓo tɔkɛ sendi Filip nɛ̀ Prokɔr nɛ̀ Nikanɔr nɛ̀ Timɔn, tɔkɛ sendi Parmenas nɛ̀ Nikola te mɔ ɗya Aŋtiyos. Nikola tikima mɛkele mɛ ɗya ɗyenɛ, nyiŋɛ misɔn Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kɛ kɔŋte, ɛ ɓo nje ɓu̧ ɓo teɗye ɓotu ɓe tomun ɓe Yesus. Ɛ ɓo ŋgwɛta nɛ Njambiyɛ kasɛ mɛɓɔ kɛ yotu yan. ");
INSERT INTO kkj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mɛlɛpi mɛ Njambiyɛ ka̧ kɛndɔ mbɔmbu. Ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka ɓa̧ kɛ ɓuyɔ ɓuɗyate kɛ Yerusalɛm. Ɛ ɓaŋa ɓuɗya ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ jayɛ tikɔ temɔ yan kɛ yi Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Njambiyɛ nya Itɛn temɔ ŋgikwa, nyɛ sendi nyɛ ɗeti ɓuɗyate. A ɗikima kelɔ nyaŋgwɛ mɛyasi nɛ̀ nyaŋgwɛ mɛkele kɛ misi mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ndana, ɛ ɓaŋa ɓomɔ kandɛ nyɛna mɛso nɛ nyɛ. Yo ɓa̧ ɓaŋa ɓotu ɓe mbanjɔ mɛwesiɗya te yi ɓo jeɓa nde ɓotu ɓe ma ɗuwɛ kɛ ɗiyɔ bala ɓaka. Yo ɓa̧ Ɓeyudɛn ɓete ɓe Sirɛn nɛ̀ ɓe Alɛksaŋdiri. Ɓaŋa ɓotu ɓete ɓe nya sendi mɛso nɛ Itɛn ɓaka ɓa̧ Ɓeyudɛn ɓe Silisi nɛ̀ ɓe Asi. ");
INSERT INTO kkj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ko ɓɛkɔ ɗete, ɓo tì ɓɛ nɛ ɗeti te yi sumɔ kol kɛ mbɔmbu wenɛ na, kɛto a ɓa̧ kɛ lɛpina nɛ ɗyanɔ te yi Kimɔ Sisiŋ nya nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ndana, ɛ ɓo nyɛ ɓomɔ mɔni nɛ sɔ. Ɛ ɓotu ɓete lɛpɛ nde: «Wusɛ wokuma mbam kɔ kɛ lɛpɔ lɛpi gbutu suŋgwɛ nɛ Mɔyisi nɛ̀ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɛ ɓo nyɛ ɗitɛ kɛ lɛpi te kɛ mɛtɔ mɛ ɓomɔ nɛ̀ kɛ mɛtɔ mɛ ɓetomba ɓe ɗya nɛ̀ ɓotu ɓe kɛtina mɛyasi. Ɛ ɓo tɛmɛ kɛ̀ komɛ Itɛn ɓa̧ kɛ́ ɓiye nyɛ kɛ̀ nɔ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɛ ɓo kɛ̀ nɛ ɓomɔ, nɛ́ ɓo kɛ̀ pɛsi lɛpi nyɛ kɛ numbu nɛ. Ɛ ɓotu ɓete lɛpɛ nde: «Mɛtu hɛnɛ mbam kɔ kɛ lɛpina ɓeyate suŋgwɛ nɛ mbanjɔ Njambiyɛ te yikɛ, mbɛy te yi nɛ kiyɔ kɛ́. A kɛ lɛpina sendi ɓeyate suŋgwɛ nɛ mɛmboŋga mɛ Njambiyɛ te yi Mɔyisi teɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wusɛ wokuma nyɛ kɛ lɛpɔ nde, Yesus te mɔ ɗya Nasarɛt kɔ ta yaŋgile mbanjɔ Njambiyɛ te yikɛ, sɛnjɔ sendi mɛyasi mɛte yi Mɔyisi teɗya wusɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɓomɔ hɛnɛ ɓe ɓa̧ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka ɓa̧ kɛ ɓɛŋɛ Itɛn nɛ ŋgoŋ. Ɛ ɓo ɓɛŋɛ nde, mbɔmbu nɛ kɛ ɓoŋna nɛ mbɔmbu wɛtɛ jaki Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ndana, ɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ diyɛ Itɛn nde: «Mɛyasi kwaŋnama gbate ɗete?» ");
INSERT INTO kkj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ɛ nyɛ yeŋsa nde: «Wunɛ njɔŋ nɛ̀ wunɛ ɓesaŋgwɛ ɓembɛ, wunɛ wôku yasi te yi mi ta lɛpɔ kɛ́. Njambiyɛ te yi ɓomɔ yâkaŋgwɛ lukse nyɛ kɔ punja yotu nyɛ saŋmbambɔ wusu Abaraham kɛ ŋgimɔ te yi nyɛ ɓa̧ ndi kɛ Mɛsopotami kɛ́, yite a tì pa kɛ̀ ɗiyɔ kɛ Karaŋ na. Ɛ Njambiyɛ lɛpɛ nyɛ nyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹Tikɔ kandɔ ɗyɔ nɛ̀ mɛnɛti mɔ kwa̧ kɛ̀ kɛ mɛnɛti mɛte yi mi ta teɗye wɛ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ndana, ɛ Abaraham tikɛ mɛnɛti mɛ Ɓekalde kɛ̀ ɗiyɔ kɛ Karaŋ. Kɛ kɔŋ sɔŋ saŋgwɛ wenɛ, ɛ Njambiyɛ soŋɛ nyɛ womɛte, njesɛ kɛ mɛnɛti mɛte yikɛ yi wunɛ ɗiyɛ kɛte ndana kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Njambiyɛ tì nyɛ Abaraham yiŋa yaŋa kɛ mɛnɛti mɛte na, ko mɔnɔ pɛl mɛnɛti nɛ mbɛt yi yakama yaka ko gbɛla ɓara kol nɛ na. Ko ɓɛkɔ ɗete, Njambiyɛ kpoma nyɛ nyɛ nde, a ta nyɛ nyɛ mɛnɛti, sendi, ɓenday ɓenɛ ta namɔ yo ɗiyɔ kɛte kɛ kɔŋ nɛ. Yasi wɛtɛ, Abaraham tì ɓɛ nɛ mɔnɔsikɛ kɛ ŋgimɔ te yite na. ");
INSERT INTO kkj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Njambiyɛ lɛpima sendi nyɛ nyɛ nde: ‹Ɓenday ɓɔ ta kɛ̀ ɗiyɔ kɛ ɗya tombɔ. Ɓetombɔ ta ɓu̧ ɓo nda ɓebala, teɗye ɓo nyaŋgwɛ mɛbɔnɛ kɛ mɛsew gɔmay yini, ");
INSERT INTO kkj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","yasi wɛtɛ, mi ta jɔse kandɔ te ɛ ta ɓiye ɓo nɛ bala kɔ. Kɛ kɔŋte, ɓo má yɔkwɛ mate nje kelɔ mɛsay nyɛ mi kɛ mbɛy te yikɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ndana, ɛ Njambiyɛ kelɛ mbon ɓenɛ Abaraham. Mbon te ta ɓɛŋna kɛ pɛsina ɓɔnɔ ɓembam. Ɗete, kɛ Abaraham ma ja mɔnɔ wenɛ Isak ya mɛtu yitan jɔ yitati kɛ́, ɛ nyɛ pɛsɛ nyɛ. Kɛ Isak ma ja mɔnɔ wenɛ Yakɔp kɛ́, ɛ nyɛ pɛsɛ nyɛ. Yakɔp nja̧ ja ɓɔnɔ ɓembam kamɔ jɔ yiɓa, ɛ nyɛ pɛsɛ ɓo. Yo ɓo kamɔ jɔ yiɓa nje ja ɓuɗya mɛkandɔ mɛte yikɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ɛ ɓesaŋmbambɔ ɓusu ɓenɔri ɓu̧ ɓeya temɔ suŋgwɛ nɛ Yosɛp kwa̧ ɗyaŋgwɛ nyɛ. Ɛ ɓotu ɓete ɓe ɓɔmma nyɛ ɓaka kwa̧ nɛ nyɛ kɛ ɗyaŋgwɛ kɛ Ejipt nda bala. ");
INSERT INTO kkj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ko ɓɛkɔ ɗete, Njambiyɛ ɗiyma pɛ yenɛ joŋgwɛ nyɛ soŋɛ kɛ ɓeya mɛyasi hɛnɛ te yi ɓo kelma nɛ nyɛ kɛ́. Njambiyɛ nya nyɛ ɗyanɔ yí kelɔ nɛ mɛsay kɛ kɛki Farawɔŋ, kumande Ejipt. A kelma sendi nde, Farawɔŋ kwâɗyikwɛ Yosɛp. Ɛ Farawɔŋ tɛmbiɗye nyɛ nde, a ɗîy nɛ mɛnɛti mɛ Ejipt, ɗiyɔ sendi nɛ tu̧ ɗyenɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɗiyɔ kɛ́, ɛ kolɔ ɗya̧ kɛ Ejipt nɛ̀ kɛ Kanan hɛnɛ. Yo ɓa̧ nyaŋgwɛ kemiyɛ, ɗete ɓesaŋmbambɔ ɓusu tì ɓɛ se nɛ mɛɗye na. ");
INSERT INTO kkj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kɛ Yakɔp ma wokɔ nde, mɛɗye kɛ Ejipt kɛ́, ɛ nyɛ tomɛ ɓesaŋmbambɔ ɓusu kɛnjɛ mate. Yo ɓa̧ bosa kɛndi. ");
INSERT INTO kkj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kɛ mɛŋga yiɓate, ɛ Yosɛp punjɛ yotu nyɛ ɓemaŋ ɓenɛ. Ndana, ɛ Farawɔŋ duwɛ kandɔ ɗyenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kɛ kɔŋte, ɛ Yosɛp kɛnjɛ tom nde, saŋgwɛ wenɛ Yakɔp njâki nɛ ɓejaɗyɛ ɓenɛ hɛnɛ. Ɓomɔ hɛnɛ ɓa̧ kamɔtan jɔ kaɓa jɔ yitan. ");
INSERT INTO kkj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","16","Ɛ Yakɔp kwa̧ kɛ̀ kɛ Ejipt. Ɗiyɔ kɛ́, ɛ saŋmbambɔ wusu Yakɔp nje gwe. Ɛ ɓo ɓu̧ muŋ nɛ kɛ̀ pumbɔ kɛ Sisɛm kɛ ɓoŋsɔŋ te yi Abaraham ɓɔmma nɛ mɔni kɛ mɛɓɔ mɛ ɓɔnɔ ɓe Emɔr kɛ Sisɛm kɛ́. Ɗiyɔ sendi kɛ́, ɛ ɓukwɛ ɓesaŋmbambɔ ɓusu si gwe. Ɓo ɗikima ɓu̧ ɓo kɛ̀ pumbɔ ndi kɛ kiya mbɛy te. ");
INSERT INTO kkj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Kɛ ŋgimɔ te yi mɛyasi mɛte yi Njambiyɛ kpoma nyɛ Abaraham nde, yo ta kelna kɛ́ ma ɓɛ kɛ wuta, ɛ ɓotu ɓe kandɔ ɗyusu nyɛɓɛ kwa̧ to te kɛ Ejipt ");
INSERT INTO kkj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","kumɔ kɛ mɛtu mɛte yi wɛtɛ kumande te ɛ ti duwɛ Yosɛp nɛ mbɔmbu kɔ ɓoŋma mbɛy. ");
INSERT INTO kkj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kumande te seɓila ɓotu ɓusu teɗye ɓesaŋmbambɔ ɓusu mɛbɔnɛ kelɔ sendi nde, ɓo lêŋ mbɔŋgɔ ɓɔnɔsikɛ, nɛ́ ɓo si gwe. ");
INSERT INTO kkj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kɛ ŋgimɔ te yite ɛ ɓo ja Mɔyisi. A ɓa̧ nɛ nyɔŋɔ ɓuɗyate kɛ misi mɛ Njambiyɛ. Ɓo ɓakiɗya nyɛ nyɛ nyɛ ɓɛri kumɔ ŋgwɛndɛ yitati kɛ tu̧ saŋgwɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kɛ kɔŋte, ɛ ɓo soŋɛ nyɛ kɛ mɔy tu̧ kɛ̀ tikɔ kɛ wɛtɛ mbɛy. Ɛ ŋgɔndu Farawɔŋ kɛ̀ sɔmbɔ nyɛ ɓu̧ nyɛ kɛ̀ ɗɔkwɛ nda mɔnɔ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ɗete, ɓo teɗya Mɔyisi mɛyasi hɛnɛ te yi ɓotu ɓe Ejipt duwa̧ kɛ́. Ɛ nyɛ ɓɛ ɗetina mumɔ kɛ mɛlɛpi nɛ̀ kɛ mɛkele mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«A ɗiyma kumɔ mɛsew kamɔni. Wɛtɛ yesɔ ɛ nyɛ pɛsɛ kɛ temɔ nɛ nde, a ta pa kɛ̀ ɓɛŋɛ ɓemaŋ ɓenɛ, ɓotu ɓe kandɔ Isarayɛl. ");
INSERT INTO kkj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɛ nyɛ kɛ̀ kumɔ dolɔ nde, wɛtɛ mɔ Ejipt kɛ teɗye wɛtɛ maŋ wenɛ, mɔ kandɔ Isarayɛl mɛbɔnɛ. Ɛ Mɔyisi kama kɛto nɛ wo mɔ Ejipt kundɔ nɔ. ");
INSERT INTO kkj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mɔyisi takima nde, ɓemaŋ ɓenɛ ta duwɛ nde, Njambiyɛ ta kwa̧ nɛ nyɛ yí joŋgwɛ nɛ ɓo. Ko ɓɛkɔ ɗete, ɓo tì duwɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Misi pupɛ ɛ nyɛ kɛ̀ dolɔ ɓemaŋ kɛ ɗuŋɔ tandɛ yan. Yí jaŋgwɛ nɛ njoka yan, ɛ nyɛ suŋɛ ɓo lɛpɔ nde: ‹Wunɛ njɔŋ, wunɛ ɓemaŋ nɛ ɓemaŋ, ŋge nje kelɔ nde, wunɛ ɗûŋ tandɛ yun?› ");
INSERT INTO kkj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ko ɓɛkɔ ɗete, yɔkɔ ɛ ɓa̧ kɛ teɗye jakɔsɔ mɛbɔnɛ kɔ pusuma Mɔyisi lɛpɔ nyɛ nyɛ nde: ‹Nda tɛmbiɗye wɛ kum nde, ɗiyɔ pɛsɔ mɛlɛpi musu? ");
INSERT INTO kkj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wɛ kɛ kwaɗyɛ wo mi nda yi wɛ woma nɛ mɔ Ejipt kwey kɛ́?› ");
INSERT INTO kkj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kɛ Mɔyisi ma wokɔ ɗete kɛ́, ɛ nyɛ ɓɔmbɛ kɛ̀ ɗiyɔ kɛ tombɔ kɛ wɛtɛ mɛnɛti nde Madiyaŋ. A ɗiyma mate ja ɓɔnɔ ɓembam yiɓa. ");
INSERT INTO kkj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ya mɛsew kamɔni kɛ kɔŋte, wɛtɛ yesɔ ɛ wɛtɛ jaki Njambiyɛ punjɛ yotu nyɛ nyɛ kɛ koŋgor kɛ kɛki keki te yi ɓo jeɓa nde Sinayi kɔ. Jaki Njambiyɛ te ɓa̧ kɛ mɔy lam ɗitɛ yi ɓa̧ kɛ ɓiye kɛ mbaŋa mɔnɔ jeti kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kɛ Mɔyisi ma ɓɛŋɛ ɗete kɛ́, ɛ nyɛ ŋgbakima yasi te. Ɛ nyɛ tutuɗya kɛ̀ mbɔmbu seŋgile kimɔte. Yasi wɛtɛ, ɛ Baba Mbokɔ lɛpɛ nde: ");
INSERT INTO kkj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Mi Njambiyɛ te ɛ ɓesaŋmbambɔ ɓɔ, Njambiyɛ te ɛ Abaraham, ɛ Isak nɛ̀ ɛ Yakɔp.› Ndana, ɛ Mɔyisi gwe wɔ̧ kwa̧ nɛ mɛŋgwaŋgwa. A tì ɓɛ se nɛ ɗeti te yi kaŋɛ misi seŋgile nɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ɛ Baba Mbokɔ lɛpɛ nyɛ nyɛ nde: ‹Sɔra mɛnakala kɛ mɛkol mɔ, kɛto mbɛy te yi wɛ tɛmɛ kɛte kɛ́, yo kiyɔ. ");
INSERT INTO kkj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi kaŋma misi ɓɛŋɛ nɛ mɛbɔnɛ mɛ ɓotu ɓembɛ kɛ Ejipt. Mi wokuma njim yan, yori yi mi piya nje joŋgwɛ ɓo soŋɛ kɛ mɛɓɔ man kɛ́. Ɗete, inja, ndana mi ta tomɔ wɛ kɛnjɛ kɛ Ejipt.› ");
INSERT INTO kkj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Yo Mɔyisi te yi Ɓɔnɔ ɓe Isarayɛl sɛŋma lɛpɔ nyɛ nyɛ nde: ‹Nda tɛmbiɗye wɛ kum nde, ɗiyɔ pɛsɔ mɛlɛpi musu kɔ?› Yo ndi kiya Mɔyisi te yi Njambiyɛ nja̧ tomɔ nɛ ɗeti jaki wenɛ te yi Mɔyisi ɓɛŋma kɛ mɔnɔ jeti kɔ. Njambiyɛ tomma nyɛ nde, a kɛ̂ndi nɛ ɓo nda kum wan joŋgwɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yo Mɔyisi te kelɛ nyaŋgwɛ mɛyasi nɛ̀ nyaŋgwɛ mɛyekambiyɛ, soŋɛ nɛ ɓo kɛ Ejipt. Yo nyɛ kelɛ sendi nyaŋgwɛ mɛkele nɛ̀ nyaŋgwɛ mɛyekambiyɛ kɛ Tena maŋ, kelɔ sendi kɛ mɔy koŋgor kɛ mɛsew kamɔni. ");
INSERT INTO kkj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yo ndi nyɛ lɛpɛ nyɛ kandɔ Isarayɛl nde: ‹Njambiyɛ ta tɛmbiɗye wɛtɛ mumɔ kɛ njoka ɓemaŋ ɓun. A ta ɓɛ mɔ punja mɛlɛpi mɛnɛ nda mi.› ");
INSERT INTO kkj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yo nyɛ Mɔyisi te ɛ ɓa̧ kɛ njoka ŋgil Ɓɔnɔ ɓe Isarayɛl komɛ ɓo ɓa̧ kɛ koŋgor kɛ́. A ɓa̧ ɓenɛ ɓesaŋmbambɔ ɓusu nɛ̀ jaki Njambiyɛ te ɛ lɛpinama nyɛ nyɛ kɛ keki Sinayi kɔ. Mɔyisi ɓoŋma mɛlɛpi mɛte yi ɗiyɛ kpo nɛ kpo kɛ́, na nje kwaŋɗye nyɛ wusɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ko ɓɛkɔ ɗete, ɓesaŋmbambɔ ɓusu tì kwaɗyɛ wokɔ mɛn nɛ na. Ɓo kinma nyɛ, ɛ ɓo yɔkiɗye mɛtemɔ man takɛ Ejipt. ");
INSERT INTO kkj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɛ ɓo nje lɛpɔ nyɛ *Arɔn nde: ‹Kelɔ ɓaŋa ɓenjambiyɛ ɓe ta ɗiyɔ nɛ wusɛ, kɛto ndana Mɔyisi te ɛ soŋma wusɛ kɛ Ejipt kɔ, wusɛ yeti kɛ duwɛ yasi te yi ɗyaŋma nyɛ kɛ́ na.› ");
INSERT INTO kkj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ɗete, ɛ ɓo tuyɛ yekambiyɛ mɔnɔ nday, ɛ ɓo kelɛ sadaka nyɛ yasi yinɔri yi ɓo tikɛ temɔ kɛte kɛ́. Ɛ ɓo sosa kɛ yasi te yi ɓo kelma nɛ mɛɓɔ man kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ndana, ɛ Njambiyɛ soŋɛ misi kɛ yotu yan tikɔ ɓo kelɔ nde, ɓo pâŋ kelɔ mɛsay nyɛ ɓuɗya mɛyasi hɛnɛ te yi ɗiyɛ kɛ kwey kɛ́. Yo kelnama ɗete ɓeŋgwɛ yasi te yi yo kɛtinate kɛ mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ kɛ́. Yo kɛtinate nde: ‹Wunɛ ɓotu ɓe kandɔ Isarayɛl, kɛ mɛsew kamɔni te yi wunɛ kwaŋɗya kɛ mɔy koŋgor kɛ́, ’wunɛ kilma ka yiŋa ŋgiŋ ɓenyamɔ nyɛ mi nɛ sadaka? ");
INSERT INTO kkj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma wunɛ kpalma soɓɛ tu̧ te yi ɓo kelma nɛ lambɔ yí ɓakiɗye nɛ njambiyɛ te yi ɓo jeɓa nde Mɔlɔk kɔ kɛndɔ nɔ, soɓɛ sendi yekambiyɛ sisɔ̧ nde njambiyɛ wun yi wunɛ jeɓa nde Refan kɔ. Wunɛ kelma yekambiyɛ mɛyasi mɛnɔri kanɔ yo. Ɗete, mi ta kwaŋɗye wunɛ kɛnjɛ lɔndunate kɛ mbɛy mɛbɔnɛ kɛ kɔŋ Babilɔn.› ");
INSERT INTO kkj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Kɛ ŋgimɔ te yi ɓesaŋmbambɔ ɓusu ɓa̧ nɔ kɛ mɔy koŋgor kɛ́, ɓo ɓa̧ nɛ tu̧ te yi ɓo kelma nɛ lambɔ kɛ́. Mɛkana mɛ mbon te yi Njambiyɛ kelma kɛ́ ɓa̧ kɛ mɔyte. Ɓo kelma tu̧ te ɓeŋgwɛ yekambiyɛ te yi Njambiyɛ teɗya Mɔyisi nde, a kêl ɗete kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kɛ kɔŋte, ɛ ɓesaŋgwɛ ɓusu ɓu̧ tu̧ te. Ɛ Yosuwa kɛndɛ nɛ ɓo kumɔ kɛ mɛnɛti mɛte yi Njambiyɛ ɗuɗya ɓesa ɓete kɛ mbɔmbu yan kɛ́. Tu̧ te ɗiyma kumɔ kɛ ŋgimɔ Davit. ");
INSERT INTO kkj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Njambiyɛ jayma nyɛ. Ɛ Davit ŋgwɛta nɛ Njambiyɛ nde, a ta sumɔ tu̧ nyɛ Njambiyɛ te ɛ Yakɔp. ");
INSERT INTO kkj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yasi wɛtɛ, yo Salomɔŋ nje sumɔ tu̧ te nyɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ko ɓɛkɔ ɗete, Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey ti jóŋnaŋgwɛ kɛ mɛtu̧ mɛte yi mumɔ sumɛ nɛ ɓɔ kɛ́ na. Mɔ punja mɛlɛpi mɛ Njambiyɛ kɛ lɛpɔ nde: ‹Baba Mbokɔ nde: ");
INSERT INTO kkj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mi ɗíy kɛ ɗyoɓɔ, mɛkol mɛmbɛ kɛ natɛ mɛnɛti. Yo kwalɔ tu̧ te yɛn yi wunɛ yakama sumɔ nyɛ mi kɔ? Yo kwalɔ mbɛy te yɛn yi mi yakama ɗiyɔ kɛte kɛ́? ");
INSERT INTO kkj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","’Yeti mi kusɛ mɛyasi mɛnɔri hɛnɛ na?› » ");
INSERT INTO kkj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ɛ Itɛn nje kɛ̀ mbɔmbu lɛpɔ nde: «Wunɛ nɛ mbandɔ, wunɛ yeti kɛ jayɛ mɛlɛpi mɛ Njambiyɛ na! Wunɛ ti wóku pɛ̧ na! Mɛtu hɛnɛ wunɛ yeti kɛ kwaɗyɛ wokɔ yasi te yi Kimɔ Sisiŋ lɛpɛ kɛ́ na, wunɛ ndi nda ɓesaŋmbambɔ ɓun! ");
INSERT INTO kkj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yo mɔ punja mɛlɛpi mɛ Njambiyɛ te nda yi ɓesaŋmbambɔ ɓun tì teɗye nyɛ mɛbɔnɛ kɔ? Ɓesaŋmbambɔ ɓun woma ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ɓe kandima lɛpɔ njombu yaŋa nde, wɛtɛ mɔ te ɛ nɛ ŋgbeŋ kɔ ta nje. Ndana, yo wunɛ nje ɗyaŋgwɛ ŋgbeŋ mɔ kɔ wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Njambiyɛ kwaŋɗya mɛmboŋga mɛnɛ nyɛ wunɛ kɛ numbu ɓejaki ɓenɛ. Ko ɓɛkɔ ɗete, wunɛ tì ɓakiɗye yo na!» ");
INSERT INTO kkj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kɛ ɓotu ɓete ɓe ɓa̧ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka ma wokɔ ɗete kɛ́, ɛ ɓoku nyiŋɛ to yan. Ɛ ɓo nyambɛ mɛsu̧ nɛ ŋgambi suŋgwɛ nɛ Itɛn. ");
INSERT INTO kkj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yasi wɛtɛ, Kimɔ Sisiŋ ɓa̧ tondunate kɛ yotu nɛ. Ɛ nyɛ kaŋɛ misi ɓɛŋɛ ɗyoɓɔ, ɓɛŋɛ nyaŋgwɛ mɛluksa mɛ Njambiyɛ, ɓɛŋɛ sendi Yesus tɛmnate kɛ mbam ɓɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ndana, ɛ nyɛ lɛpɛ nde: «Wunɛ pâŋ laɗye, mi kɛ ɓɛŋɛ ɗyoɓɔ nyasɛ kɛ misi mɛmbɛ, ɓɛŋɛ sendi *Mɔnɔ mumɔ tɛmnate kɛ mbam ɓɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kɛ ɓo ma wokɔ ɗete kɛ́, ɛ ɓo kembiɗya ɓeyate ɗiɓɔ mɛtɔ. Ɛ ɓo hɛnɛ ŋgbɔ sɛɗyɛ kɛ̀ kɛ yotu Itɛn. ");
INSERT INTO kkj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɛ ɓo nambɛ nyɛ jisɛ nɛ nyɛ kɛ mɔy ɗya kɛ̀ lu̧ nyɛ nɛ mɛtari wo. Ɓotu ɓete ɓe ɓa̧ kɛ mɛkele mɛnɔri ɓaka sɔruma mɛlambɔ man kɛ̀ jokwɛ nyɛ wɛtɛ gwanjɔ nde Sol. ");
INSERT INTO kkj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ lu̧ Itɛn nɛ mɛtari kɛ́, ɛ nyɛ ŋgwɛta nɛ Njambiyɛ lɛpɔ nde: «Kumande Yesus, ɓoŋgɔ sisiŋ mbɛ!» ");
INSERT INTO kkj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kɛ kɔŋte, ɛ nyɛ kusɛ mɛɓɔŋ kɛ mɛnɛti lɛpɔ nɛ mɛn kɛ kwey nde: «Nyaŋgwɛ Kumande, ɓɛŋa ɓotu ɓaka nɛ ŋgwɛtɛ kɛ ɓeya yasi te yikɛ yi ɓo kelɛ kɛ́!» Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ sɔŋ ɓu̧ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol sendi jayma nde, ɓo wôku Itɛn. Kɛ kiya yesɔ te ɛ ɓo kandɛ teɗya ɓeya nyaŋgwɛ mɛbɔnɛ nyɛ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus kɛ Yerusalɛm ɓaka. Ɛ ɓo hɛnɛ si wanja, kɛ̀ kɛ poku mɛnɛti mɛ Yuda nɛ̀ Samari. Ndi ɓotu ɓe tomun ɓe Yesus ɓepɔ tikama kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɓotu ɓete ɓe ɗikima kanɔ Njambiyɛ ɓaka ɓoŋma muŋ Itɛn kɛ̀ pumbɔ. Ɛ ɓo lelɛ nyɛ ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol ka̧ ndi nɛ mbɔmbu yí wanjɔ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka. A ɗikima nyiŋɛ kɛ mɔy mɛtu̧ ɗalɛ ɓembam nɛ̀ ɓomari kɛ̀ nyɛ kɛ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ɓotu ɓete yi ɓo wanjima ɓaka ka̧ mɛmbɛy nɛ mɛmbɛy yí lɛpɔ Kimɔ Tom Njambiyɛ nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ɛ Filip kɛ̀ kɛ wɛtɛ ɗya kɛ mɛnɛti mɛ Samari pelɛ kasi *Krist mate nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ŋgil ɓomɔ hɛnɛ ɗikima lɛŋgwɛ mɛtɔ wokɔ yasi te yi nyɛ ɗikima lɛpɔ kɛ́. Ɓo ɗikima ɓɛŋɛ nyaŋgwɛ mɛkele mɛte yi nyɛ ɗikima kelɔ kɛ́, ");
INSERT INTO kkj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","kɛto ɓeya mɛsisiŋ ɗikima pundɔ ɗuwɛ nɛ ɓeya kembi kɛ yotu ɓuɗya ɓomɔ. Filip siɗya sendi mɛkɔsu nɛ̀ mɛndɛmbil mɛ ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɛ ɓomɔ ɓe Samari sosa ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wɛtɛ mɔ kelna mɛyasi mɛ kifi nde Simɔn ɓa̧ njombu yaŋa kɛ Samari. Ɓomɔ ɗikima kambɔ nyɛ kɛ mɔy ɗya, ɛ nyɛ ɗiki ɓu̧ yotu nɛ nde, nyɛ kwa̧ ɓɛsɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kandɛ ɓɔnɔsikɛ kumɔ ɓetomba, ɓomɔ hɛnɛ ɗikima lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ ɗikima lɛpɔ kɛ́. Ɓo ɗikima lɛpɔ nde: «Mbam kɔ ŋguŋguɗyɛ Njambiyɛ. Ɓo jéɓaŋgwɛ yo nde Nyaŋgwɛ ɗeti.» ");
INSERT INTO kkj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓomɔ ɗikima lɛŋgwɛ mɛtɔ kɛ yasi te yi nyɛ ɗikima lɛpɔ kɛ́, kɛto ɓo kikima ɗiki ŋgbakima mɛkele mɛ kifi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yasi wɛtɛ, kɛ ɓomɔ ma jayɛ Kimɔ Tom te yi Filip ɗikima lɛpɔ kɛ kasi *Kandɔ Njambiyɛ nɛ̀ kɛ kasi ɗinɔ Yesus Krist kɛ́, ɛ ɓo tɔpɛ ɓo kɛ mɔrɔku. Yo ɓa̧ ɓembam nɛ̀ ɓomari. ");
INSERT INTO kkj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn te nɛ ŋguru wenɛ jayma sendi Kimɔ Tom, ɛ ɓo tɔpɛ nyɛ kɛ mɔrɔku. A tì ɗuwɛ se kɛ kɛki Filip na. A ɗikima ɓɛŋɛ nyaŋgwɛ mɛyasi nɛ̀ nyaŋgwɛ mɛkele mɛte yi Filip ɗikima kelɔ kɛ́, ɛ nyɛ ɗiki ŋgbakima ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kɛ ɓotu ɓe tomun ɓe Yesus ɓe ɓa̧ kɛ Yerusalɛm ɓaka ma wokɔ nde, ɓotu ɓe Samari jayma mɛlɛpi mɛ Njambiyɛ kɛ́, ɛ ɓo tomɛ Piyɛr ɓenɛ Jaŋ kɛnjɛ mate. ");
INSERT INTO kkj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kɛ ɓo ma ɗya̧ kɛ Samari kɛ́, ɛ ɓo ŋgwɛta nɛ Njambiyɛ kɛto ɓotu ɓete ɓe jayma ɗinɔ Yesus Krist mate ɓaka, nɛ́ Kimɔ Sisiŋ nyiŋ kɛ yotu yan, ");
INSERT INTO kkj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kɛto kɛ ŋgimɔ te yite, Kimɔ Sisiŋ tì pa piyɛ nje kɛ yotu mumɔ wɛtɛ nɛ wɛtɛ kɛ njoka yan na. Kɛ yi ɓo tɔpuma nɛ ɓo kɛ mɔrɔku kɛ́, ɓo tɔpuma ɓo ndi nɛ ɗinɔ Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndana, ɛ Piyɛr ɓenɛ Jaŋ nje kasɛ mɛɓɔ kɛ yotu yan, ɛ Kimɔ Sisiŋ nyiŋɛ yɛy kɛ yotu yan. ");
INSERT INTO kkj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɛ Simɔn ma ɓɛŋɛ nde, Kimɔ Sisiŋ nyiŋma kɛ yotu ɓotu ɓete kɛ ŋgimɔ te yi ɓotu ɓe tomun ɓe Yesus kasa mɛɓɔ kɛ yotu yan kɛ́, ɛ nyɛ ɓu̧ mɔni nyɛ Piyɛr ɓenɛ Jaŋ lɛpɔ nyɛ ɓo nde: ");
INSERT INTO kkj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Wunɛ nyɛ̂ki sendi mi kiya ɗeti te, ɗete ŋgɛ mi kasɛ mɛɓɔ kɛ yotu mumɔ, nɛ́ Kimɔ Sisiŋ nyiŋ kɛ yotu mɔ te sendi.» ");
INSERT INTO kkj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Mɔni yɔ yâmbila nɛ wɛ hɛnɛ, kɛto wɛ kɛ takɛ nde, yasi te yi Njambiyɛ nyɛ nɛ gbɛlate kɛ́, wɛ ta ɓɔmɔ yo ɓɔmɔ nɛ mɔni! ");
INSERT INTO kkj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wɛ kinɛ mɔnɔ ŋgaɓiyɛ ho mɔnɔ yaŋa kɛ yasi te yikɛ na, kɛto temɔ yɔ yeti nɛ ŋgbeŋ kɛ misi mɛ Njambiyɛ na! ");
INSERT INTO kkj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ɗete, yêŋsaŋgwɛ temɔ, tikɔ ɓeya ɗyanɔ te yi wɛ nɔ kɛ́, nɔ̀ ŋgwɛ̂taŋgwɛ nɛ Baba Mbokɔ, simande a ta tikɔ wɛ nɛ ŋgwɛtɛ kɛ ɓeya mɛtakɛ mɛte yi ɗyaŋma kɛ temɔ yɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kɛto mi kɛ ɓɛŋɛ nde, wɛ kɛ ɓeya nje nɛ pitik. Sendi, wɛ ma tɔta kɛ kɔtu mɛkele kumɔ kɛ ŋgiŋ.» ");
INSERT INTO kkj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ɛ Simɔn nje ɗiyɔ lɛpɔ nyɛ ɓo nde: «Wunɛ ŋgwɛ̂taŋgwɛ nɛ Baba Mbokɔ kɛto mbɛ, mi mɛ nje saŋgwa nɛ yasi te yi wunɛ lɛpima kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kɛ Piyɛr ɓenɛ Jaŋ ma si lɛpɔ yasi te yi ɓo duwa̧ gbate kɛ kasi Kumande Yesus, lɛpɔ sendi mɛlɛpi mɛnɛ kɛ́, ɛ ɓo nje yɔkwɛ kɛ̀ Yerusalɛm. Ɓo lɛpima Kimɔ Tom kɛ mɛɗya mɛte yi wokuna nɛ Samari kɛ́ yɔkwɛ nɔ. ");
INSERT INTO kkj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɗiyɔ kɛ́, ɛ wɛtɛ jaki Baba Mbokɔ nje lɛpɔ nyɛ Filip nde: «Tɛma kwa̧ kɛ̀ pulɔ njɛmbɔ kɛ nje te yi piyɛ wulɛ Yerusalɛm kɛ̀ nɔ Gasa kɛ́. Nje te kɛ mɔy gbala.» ");
INSERT INTO kkj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ɛ nyɛ tɛmɛ kwa̧. Ɛ nyɛ kɛ̀ saŋgwa nɛ wɛtɛ mbam, mɔ Etiyopi. A ɓa̧ nyakɔte. A ɓa̧ sendi nyaŋgwɛ mɔ mɛsay mɛ wɛtɛ nyari nde Kandas ɛ ɓa̧ kumande kɛ Etiyopi kɔ. Mbam kɔ ɛ ɗikima ɗiyɔ nɛ kpasa mɛyasi mɛ nya kɔ wúla Yerusalɛm kɛ̀ kanɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A ɓa̧ mɛtiɗyɛ kɛ mɔy matuwa nɛ kɛ tɔlɔ mɛkana mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɛ Kimɔ Sisiŋ lɛpɛ nyɛ Filip nde: «Kɛn kɛ kɛki matuwa yinɔri.» ");
INSERT INTO kkj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ɛ Filip sɛɗyɛ kumɔ kɛ kɛki matuwa. A wóku mbam kɔ kɛ tɔlɔ mɛkana mɛte yi Esayi te mɔ punja mɛlɛpi mɛ Njambiyɛ kɛtima kɛ́. Ɛ nyɛ diyɛ nyɛ nde: «Wɛ kɛ wokɔ to yasi te yi wɛ tɔlɛ kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɛ nyɛ yeŋsa nde: «Ŋgɛ mumɔ ti lɛpɛ to te nyɛ mi na, mi ta kelɔ nan yí wokɔ nɔ?» Ɛ nyɛ lɛpɛ nyɛ Filip nde, a ɓêndi matuwa kɛ̀ ɗiyɔ kɛ kɛki nɛ. ");
INSERT INTO kkj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mbɛy te yi mbam kɔ ɓa̧ kɛ tɔlɔ kɛ mɛkana mɛ Njambiyɛ kɛ́ lɛ́pi nde: ‹Ɓo ɓoŋma nyɛ kwa̧ nɔ nda sam te yi ɓo ɓu̧ nyɛ kɛ̀ kilɛ ŋgiŋ nɛ. A ɓa̧ sendi nda mɔnɔ sam te ɛ ɗiyɛ kinɛ kembɔ kɛ mɛɓɔ mɛ mɔ te ɛ pɛsɛ mɛmburu mɛnɛ kɔ. A tì ɓutɛ numbu na. ");
INSERT INTO kkj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɓo wuŋgwa nyɛ pɛsɔ lɛpi nɛ kɔtute. Yo mɔ te nda ta lɛpɔ kasi nɛ wɛtɛ yesɔ, jeɓa wɛtɛ mumɔ nde nday wenɛ kɔ? Kɛto ɓo pɛsima joŋgwɛ ɗyenɛ nɛ ɗeti kɛ to mɛnɛti.› ");
INSERT INTO kkj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɛ nyaŋgwɛ mɔ mɛsay kɔ diyɛ Filip nde: «Mɔ punja mɛlɛpi mɛ Njambiyɛ lɛ́pi kasi nda? Mi kɛ ŋgwɛta nɛ wɛ nde, lɛpɔ nyɛ mi. A lɛ́pi nɛ yotu nɛ ho a lɛ́pi nɛ wɛtɛ mumɔ?» ");
INSERT INTO kkj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ndana, ɛ Filip ɓu̧ lɛpi lɛpɔ Kimɔ Tom kɛ kasi Yesus nyɛ nyɛ. A lɛpima yo kandɛ kɛ mɛkana mɛte yi mbam tɔlma kɛ mɛkana mɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ɓo kɛndima ndi ɗete kɛ̀ nɔ mbɔmbu, ɛ ɓo kumɛ kɛ wɛtɛ mbɛy te yi ɓa̧ nɛ mɔrɔku kɛte kɛ́. Ɛ nyaŋgwɛ mɔ mɛsay kɔ lɛpɛ nyɛ Filip nde: «Ma mɔrɔku kɛ, ŋge yi njaŋgwɛ ndana nde, wɛ tî tɔpa mi kɛ mɔrɔku kɛ́?»  ");
INSERT INTO kkj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ɛ Filip lɛpɛ nyɛ nyɛ nde: «Ŋgɛ wɛ tikɛ temɔ yɔ hɛnɛ kɛ yi Kumande Yesus Krist, ɓo yakama tɔpɛ wɛ kɛ mɔrɔku.» Ɛ mbam yeŋsa nde: «Mi kɛ jayɛ nde, Yesus Krist Mɔnɔ Njambiyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ndana, ɛ nyɛ lɛpɛ nde, ɓo tɛ̂mbiɗya matuwa. Ɛ Filip ɓenɛ nyaŋgwɛ mɔ mɛsay kɔ piyɛ ɓo hɛnɛ yiɓa kɛ̀ kɛ mɔrɔku. Ɛ Filip tɔpɛ nyɛ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kɛ ɓo ma ɗuwɛ kɛ ɗuku ɓendɔ ŋgindi kɛ́, ɛ Sisiŋ Baba Mbokɔ soŋɛ Filip, ɛ nyɛ ɗimbiyɛ kɛ misi mɛ nyaŋgwɛ mɔ mɛsay kɔ. Ko ɓɛkɔ ɗete, nyaŋgwɛ mɔ mɛsay kɔ ka̧ nɛ kɛndi nɛ mbɔmbu nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kɛ ɓɛ Filip, ɓo nja̧ semɔ nyɛ kɛ Asot. A nja̧ tɛmɛ mate lɛpɔ Kimɔ Tom kwa̧ nɔ kɛ mɛɗya hɛnɛ te yi nyɛ kwaŋma kɛte kɛ́ kumɔ Sesare. ");
INSERT INTO kkj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol ka̧ ndi nɛ mbɔmbu yí lu̧ ɗyambi nɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka. A kwaɗya si wo ɓo. Ɗete, ɛ nyɛ tɛmɛ kɛ̀ kɛ yi nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ");
INSERT INTO kkj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kɛ̀ diyɛ mɛkana kɛ ɓɔ nɛ, na nyɛ ɓotu ɓete ɓe ɗiyɛ nɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ Damas ɓaka. A kelma ɗete, ta ɓɛ, a ta dolɔ ɓaŋa ɓomɔ, ko mbam ko nyari ɓe kɛ ɓeŋgwɛ nje Kumande Yesus mate, na ɓiy ɓo wotɔ yɔkwɛ nɔ kɛ̀ nɔ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kɛ nyɛ ma tɛmɛ kwa̧ kɛndɔ wuta nɛ Damas kɛ́, semɔ semɔ, yiŋa nyaŋgwɛ mɛjasi wulma kwey panɔ kɛ mbɛy te yi nyɛ ɓa̧ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɛ nyɛ ɓalɛ kɛ mɛnɛti. Ɛ nyɛ wokɛ wɛtɛ mɛn kɛ lɛpɔ nyɛ nyɛ nde: «Sol, Sol, wɛ téɗya mi mɛbɔnɛ kɛto ŋge?» ");
INSERT INTO kkj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ɛ nyɛ diyɛ nde: «Nyaŋgwɛ Kumande, yo wɛ nda?» Ɛ mɛn lɛpɛ nde: «Yo mi Yesus yi wɛ teɗye nyɛ mɛbɔnɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yasi wɛtɛ tɛma, nyiŋa kɛ mɔy ɗya. Ɓo ta lɛpɔ yasi te yi wɛ yâkaŋgwɛ kelɔ kɛ́ mate.» ");
INSERT INTO kkj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɓotu ɓete ɓe ɓa̧ kɛ njɔŋ kɛndi ɓenɛ ɓe Sol ɓaka tɛmma numbu kɔɓɔ. Ɓo ɓa̧ kɛ wokɔ mɛn kinɛ ɓɛŋɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ɗiyɔ kɛ́, ɛ nyɛ tɛmɛ kɛ mɛnɛti. Ma ko ɓɛkɔ nde, misi mɛnɛ ɓa̧ ɓutunate, a tì ɓɛ se kɛ ɓɛŋɛ yaŋa na. Ɓo ɓiyma nyɛ ɓiya kɛ ɓɔ kɛ̀ nɔ Damas. ");
INSERT INTO kkj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A kelma mɛtu yitati kinɛ ɓɛŋna, kinɛ ɗyena, kinɛ hɔɓiye yaŋa na. ");
INSERT INTO kkj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wɛtɛ mɔ te ɛ ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist nde Ananiyas kɔ ɓa̧ kɛ Damas. Ɛ Kumande Yesus lɛpina nyɛ nyɛ nɛ nje te yi nyɛnɔ jeɓa nyɛ nde: «Ananiyas!» Ɛ nyɛ yeŋsa nde: «Mi kɔ, Nyaŋgwɛ Kumande!» ");
INSERT INTO kkj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Tɛma, kwaŋgɔ kɛ̀ kɛ nje te yi ɓo jeɓa nde Nje te yi nɛ ŋgbeŋ kɔ. Kɛn kɛ tu̧ Yude kɛ̀ diyɛ wɛtɛ mbam nde Sol, mɔ Tars, a ndana kɛ ŋgwɛta. ");
INSERT INTO kkj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A ɓɛŋma nda nyɛnɔ nde, wɛtɛ mbam nde Ananiyas kɛ nyiŋɛ tu̧ nje kasɛ mɛɓɔ kɛ yotu nɛ, na ɓɛŋna nɛ kɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ɛ Ananiyas yeŋsa nde: «Nyaŋgwɛ Kumande, ɓomɔ ɓuɗyate kelma mɛsimɔ mɛ mbam ɛnɔru nyɛ mi. Ɓo yekiɗya ɓeya mɛkele hɛnɛ te yi nyɛ kelma nɛ ɓomɔ ɓɔ kɛ Yerusalɛm kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yikɛ yi nyɛ nja̧ woŋga kɛ́, ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nya nyɛ ɗeti nde, a ɓîya ɓomɔ hɛnɛ ɓe sombile ɗinɔ ɗyɔ ɓaka wotɔ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yasi wɛtɛ, ɛ Kumande Yesus lɛpɛ nyɛ nyɛ nde: «Kɛndɔ, kɛto mi tɔkuma gba mbam te. Mi ta ɓu̧ nyɛ nda jɔlɛ mɛsay mɛmbɛ. A ta lɛpɔ kasi mbɛ nyɛ mɛkandɔ mɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka, lɛpɔ nyɛ ɓekumande, lɛpɔ sendi nyɛ kandɔ Isarayɛl. ");
INSERT INTO kkj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi ta teɗye sendi nyɛ mɛyasi hɛnɛ te yi nyɛ yâkaŋgwɛ saŋgwa nɛ mɛbɔnɛ kɛte kɛto ɗinɔ ɗyembɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ndana, ɛ Ananiyas kwa̧ kumɔ nyiŋɛ tu̧ dolɔ Sol kasɛ mɛɓɔ kɛ yotu nɛ lɛpɔ nde: «Sol maŋmbɛ, Kumande Yesus te ɛ punja yotu nyɛ wɛ kɛ nje kɛ ŋgimɔ te yi wɛ ɓa̧ kɛ nje woŋga kɛ́ tomɛ mi njesɛ. A tomma mi njesɛ kɛ yɔ, nɔ́ ɓɛŋna nɛ kɔkɔ, nɔ́ ɓɛ sendi tondunate nɛ Kimɔ Sisiŋ.» ");
INSERT INTO kkj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ndana ndana, ɛ yiŋa yasi ɗuwɛ kɛ misi mɛ Sol ɓalɔ kɛ mɛnɛti nda mɛpay njanjɔ, ɛ nyɛ kandɛ ɓɛŋna yasi nɛ kɔkɔ. Sol tɛmma, ɛ ɓo tɔpɛ nyɛ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kɛ kɔŋte, ɛ nyɛ ɗyena, ɛ ɗeti nje nyɛ kɛ yotu. Ɛ nyɛ ya mɔnɔ mɛtu ɓenɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Damas ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kinɛ kikɔ kɛ́, ɛ nyɛ kandɛ kɛnate kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kɛ Damas, pelɛ kasi Yesus nde, nyɛ Mɔnɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɓomɔ hɛnɛ ɓe ɗikima wokɔ yasi te yi Sol ɓa̧ kɛ lɛpɔ kɛ́ ɓa̧ numbu nɛ haŋ. Ɛ ɓo ɗiki lɛpɔ nde: «’Yeti gba mbam kɔ ɛ ɗikima teɗye mɛbɔnɛ nyɛ ɓotu ɓete ɓe sombile ɗinɔ Yesus te kɛ Yerusalɛm kɔ na? A ti njáki woŋga, na nje ɓiy ɓo wotɔ kɛ̀ nɔ kɛ yi ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ na?» ");
INSERT INTO kkj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yasi wɛtɛ, Sol ɓa̧ kɛ lɛpɔ Kimɔ Tom ndana nɛ ɗeti kwa̧ yi mbɔmbu, teɗye gbate nyɛ ɓomɔ nde, Yesus nyɛ *Krist, yɔkɔ ɛ Njambiyɛ tɔkuma. Ɓeyudɛn ɓete ɓe ɗikima ɗiyɔ kɛ Damas ɓaka tì duwɛ se yasi te yi ɓo yakama lɛpɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yo kwaŋnama ɗete yaka ɓuɗya mɛtu, ɛ Ɓeyudɛn sa̧ nje te yi ɓo ta wo nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ɛ nyɛ wokɛ kasi te. Ɓo ɗikima pɛmɔ mɛnumɛy mɛ ɗya tu nɛ yesɔ yí sa̧ nje te yi wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ɗete, ɛ ɓejekɛ ɓenɛ ɓu̧ nyɛ wɛtɛ yesɔ nɛ tu nyɛ kɛ mɔy nyaŋgwɛ ndɔkɔ kwaŋɗye kɛ to nyaŋgwɛ ndoko te yi ɗikima litɔ ɗya kɛ́ piɗyɛ kɛ kɔŋte. ");
INSERT INTO kkj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kɛ nyɛ ma kwa̧ ɗya̧ kɛ Yerusalɛm kɛ́, ɛ nyɛ kwaɗyɛ nyiŋɛ kɛ njɔŋ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka. Ɛ ɓo hɛnɛ gwe wɔ̧, kɛto ɓo tì ɓɛ kɛ tikɔ temɔ nde, a mɛ mɔ te ɛ kɛ ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist gbate na. ");
INSERT INTO kkj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ɛ Barnabas nje ɓu̧ nyɛ kɛ̀ nɔ kɛ yi ɓotu ɓe tomun ɓe Yesus. Ɛ nyɛ yekiɗye nda yi Sol ɓɛŋma nɛ Kumande Yesus kɛ kɛna Damas, yekiɗye sendi nda yi Kumande Yesus lɛpinama nɔ nyɛ Sol kɛ́. Ɛ nyɛ lɛpɛ sendi nda yi Sol lɛpima Kimɔ Tom kɛ ɗinɔ Yesus kɛ misi mɛ ɓomɔ kɛ Damas kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ndana, ɛ Sol kandɛ kɛndi ɓenɛ ɓo kɛ mɛmbɛy hɛnɛ te yi ɓo ɗikima kɛ̀ kɛte kɛ Yerusalɛm kɛ́. Ɛ nyɛ ɗiki lɛpɔ Kimɔ Tom kɛ misi mɛ ɓomɔ kɛ ɗinɔ Nyaŋgwɛ Kumande kinɛ wɔ̧ na. ");
INSERT INTO kkj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A ɗikima lɛpina sendi nyɛ Ɓeyudɛn ɓete ɓe ɗikima lɛpɔ yan numbu Grɛk ɓaka. Ɓenɛ ɓo ɗikima nyɛ mɛso, ɛ ɓo sa̧ nje te yi wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kɛ ɓenjɔŋ ɓenɛ ma wokɔ kasi te kɛ́, ɛ ɓo ɓu̧ nyɛ kɛ̀ tikiɗye kɛ Sesare. Ɛ ɓo kwaŋɗye nyɛ kɛnjɛ Tars. ");
INSERT INTO kkj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus kɛ Yuda, kɛ Galile nɛ̀ kɛ Samari ɓaka ɓa̧ hɛnɛ nɛ tɛ. Ɓo ɓa̧ kɛ ɓu̧ ɗyanɔ kɛ mɛlɛpi mɛ Njambiyɛ kɛ̀ nɔ mbɔmbu, ɓakiɗye sendi mɛlɛpi mɛ Kumande Yesus. Kimɔ Sisiŋ ɗikima kelɔ nde, ɓo ɓûy ɓuyɔ kɛ̀ nɔ mbɔmbu. ");
INSERT INTO kkj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyɛr ɗikima kɛ̀ ɓɛŋɛ ɓotu ɓe Njambiyɛ kɛ mɛmbɛy hɛnɛ. Ɛ nyɛ kɛ̀ sendi kɛ̀ ɓɛŋɛ ɓaka ɓe ɓa̧ kɛ Lida ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɛ nyɛ dolɛ wɛtɛ mbam nde Ene mate. Mbam te ma kelɔ mɛsew yitan jɔ yitati mɛtinɛŋgwɛ kɛ taŋ, kɛto a ma kɔsɔ. ");
INSERT INTO kkj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ɛ Piyɛr lɛpɛ nyɛ nyɛ nde: «Ene, Yesus Krist kɛ siɗyɛ kɔsu yɔ. Tɛma, kombila taŋ yɔ.» Ndana ndana, ɛ nyɛ tɛmɛ. ");
INSERT INTO kkj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ɓomɔ hɛnɛ ɓe ɗikima ɗiyɔ kɛ Lida nɛ̀ kɛ Sarɔn ɓaka ɓɛŋma mbam kɔ, ɛ ɓo yeŋsa temɔ tikɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yo ɓa̧ nɛ wɛtɛ nyari ɛ ɗikima ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Yope. Ɗinɔ ɗyenɛ nde Tabita, kɛ numbu Grɛk nde Dɔrkas, yite nde mburu. Nya te ɓa̧ nɛ ŋgikwa ɓuɗyate. A ɗikima nyɛ buka ɓomɔ mɛyasi. ");
INSERT INTO kkj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kɛ ŋgimɔ te yinɔri, ɛ nyɛ ɓalɛ nɛ kɔn kwa̧ gwe. Kɛ ɓo ma si weyɛ nyɛ kɛ́, ɛ ɓo ŋgɛɓɛ nyɛ kɛ tikɔ kɛ wɛtɛ toŋgari kɛ tu̧ kwey kɛ njenate. ");
INSERT INTO kkj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida ɓa̧ kɛ kɛki Yope. Ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Yope ɓaka wokuma nde, Piyɛr kɛ Lida, ɛ ɓo tomɛ ɓomɔ yiɓa kɛnjɛ kɛ yenɛ ŋgwɛta nɛ nyɛ nde: ‹Tiso, pa nje nɛdɔ kɛ yusu.› ");
INSERT INTO kkj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ɛ nyɛ tɛmɛ kwa̧ ɓenɛ ɓo. Kɛ nyɛ ma ɗya̧ kɛ́, ɛ ɓo ɓu̧ nyɛ kɛ̀ nɔ kɛ toŋgari te kɛ kwey. Ɛ ɓekusɔ ɓomari hɛnɛ nje litɔ nyɛ nɛ ɗukwe kɛ numbu, teɗye sendi nyɛ ɓuɗya sɛkɛ sɛkɛ mɛlambɔ nɛ̀ nyaŋgwɛ mɛlambɔ mɛte yi Dɔrkas ɗikima kelɔ kɛ ŋgimɔ te yi nyɛ ɓa̧ nɛ joŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kɛ kɔŋte, ɛ Piyɛr punjɛ ɓomɔ hɛnɛ. Ɛ nyɛ kusɛ mɛɓɔŋ kɛ mɛnɛti ŋgwɛta nɛ Njambiyɛ yeŋsa ɓɛŋɛ muŋ lɛpɔ nde: «Tabita, tɛma.» Ɛ muŋ ɓutɛ misi. Kɛ nyɛ ma ɓɛŋɛ Piyɛr kɛ́, ɛ nyɛ kwa̧ ɗiyɔ. ");
INSERT INTO kkj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ɛ Piyɛr kɛnjɛ ɓɔ ɓiye nɛ nyɛ tɛmbiɗye. Ɛ Piyɛr jeɓa ɓotu ɓe Njambiyɛ nɛ̀ ɓekusɔ ɓomari ɓete ɓe ɓa̧ kɛ njoka yan ɓaka, kaŋɛ nyɛ ndana nɛ joŋ nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɓomɔ ɓe Yope hɛnɛ wokuma kasi te, ɛ ɓuɗya ɓomɔ tikɛ temɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyɛr nja̧ ya ɓuɗya mɛtu kɛ Yope kɛ yi wɛtɛ mbam nde Simɔn, mɔ kombila mɛkotu. ");
INSERT INTO kkj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wɛtɛ mbam nde Kɔrnɛy ɓa̧ kɛ Sesare. A ɓa̧ kum ɓesɔja gɔmay kɛ wɛtɛ njɔŋ ɓesɔja ɓe ɓotu ɓe Rom yi ɓo ɗikima jeɓa nde Njɔŋ te yi Itali kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔrnɛy ɓa̧ kɛ kanɔ Njambiyɛ kɛ joŋgwɛ ɗyenɛ, ɓakiɗye mɛmboŋga mɛnɛ ɓenɛ ɓotu ɓe tu̧ ɗyenɛ hɛnɛ. A ɗikima kamɛ buka ɓomɔ ɓe kandɔ Ɓeyudɛn nyɛ ɓo mɛyasi ɓuɗyate. A ɗikima ŋgwɛta sendi nɛ Njambiyɛ mɛtu hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wɛtɛ ɓekoko kɛ hawa yitati, ɛ yaŋa ɗya̧ nyɛ nda nyɛnɔ. A ɓɛŋma wɛtɛ jaki Njambiyɛ nɛ loŋgo loŋgo kɛ nyiŋɛ tu̧ ɗyenɛ jeɓa nde: «Kɔrnɛy!» ");
INSERT INTO kkj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ɛ nyɛ ɓɛŋɛ jaki Njambiyɛ nɛ ŋgoŋ, ɛ wɔ̧ nɛ ɓiye nyɛ ɓuɗyate. Ɛ nyɛ nje lɛpɔ nyɛ jaki Njambiyɛ nde: «Nan ɓa Baba?» Ɛ jaki yeŋsa nyɛ nyɛ nde: «Njambiyɛ jayma mɛŋgwɛta mɔ, jayɛ sendi wɛ kɛ mɛkamna mɛte yi wɛ kelɛ nɛ buka ɓomɔ kɛ́. A yeti kɛ leŋsa yo na. ");
INSERT INTO kkj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ndana, tomɔ ɓomɔ kɛnjɛ kɛ̀ Yope kɛ̀ jeɓa nɛ wɛtɛ mbam nde Simɔn, yiŋa ɗinɔ ɗyenɛ sendi nde Piyɛr. ");
INSERT INTO kkj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A yáki kɛ yasi wɛtɛ mbam nde Simɔn, mɔ kombila mɛkotu, tu̧ ɗyenɛ kɛ kɛki maŋ.» ");
INSERT INTO kkj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kɛ jaki Njambiyɛ te ɛ lɛpima yasi nyɛ nyɛ kɔ ma kwa̧ kɛ́, ɛ Kɔrnɛy jeɓa ɓaŋa ɓotu ɓe mɛsay ɓenɛ yiɓa nɛ̀ wɛtɛ sɔja te ɛ ɗikima kanɔ Njambiyɛ kɔ. Sɔja te ɓa̧ kɛ njoka ɓesɔja ɓete ɓe ɗikima kelɔ mɛsay nyɛ nyɛ tu nɛ̀ yesɔ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kɛ Kɔrnɛy ma si yekiɗye mɛyasi mɛte yi kwaŋnama hɛnɛ nyɛ ɓo kɛ́, ɛ nyɛ nje tomɔ ɓo kɛnjɛ Yope. ");
INSERT INTO kkj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Misi pupɛ te ɓo kɛndima wuta nɛ Yope. Kɛ ŋgimɔ te yite Piyɛr ɓendima tosiyɔ̧ tu̧ kɛ pɔku ɓembe yesɔ yí kɛ̀ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nja ɓa̧ kɛ kelɔ nyɛ, ɛ nyɛ kwaɗyɛ ɗyena. Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ kelɔ mɛɗye nyɛ nyɛ kɛ́, ɛ yaŋa ɗya̧ nyɛ nda nyɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A ɓɛŋma ɗyoɓɔ mɛ nyasɛ, yiŋa yasi kɛ piyɛ nje mɛnɛti nda nyaŋgwɛ gwey. Yo ɓa̧ kɛ piyɛ nda ɓo ɓiyma mɛɓoku mɛte yini. ");
INSERT INTO kkj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kwalɔ ɓenyamɔ hɛnɛ ɓe ɗiyɛ kɛ to mɛnɛti nɛ̀ ɓenyamɔ ɓete ɓe nɛ mɛkol yini nɛ̀ ɓaka ɓe kɛndɛ ɗulma nɛ mɔy nɛ̀ ɓenɔn ɓe jɛ kɛ kwey, ɓo hɛnɛ ɓa̧ kɛ mɔyte. ");
INSERT INTO kkj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɛ Piyɛr wokɛ wɛtɛ mɛn kɛ lɛpɔ nyɛ nyɛ nde: «Piyɛr, tɛma, wokɔ ɓenyamɔ ɓenɔri ɗye.» ");
INSERT INTO kkj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yasi wɛtɛ, ɛ nyɛ yeŋsa nde: «Ko na, Nyaŋgwɛ Kumande, kɛto ko mi tì ɗye yiŋa yasi te yi nɛ sɛmbɔ kɛte wɛtɛ yesɔ ho ɗye yiŋa yasi te yi mumɔ ti yaka ɗye na.» ");
INSERT INTO kkj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kɛ mɛŋga yiɓate, ɛ mɛn lɛpɛ nyɛ nyɛ nde: «Yasi te yi Njambiyɛ ma pupuɗye kɛ́, wɛ tî njaki sɛŋɛ nde, yo yasi te yi nɛ sɛmbɔ na.» ");
INSERT INTO kkj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yo kelnama ɗete kumɔ mɛŋga yitati. Kɛ kɔŋte, ɛ yasi yinɔri yɔkwɛ nɛdɔ kɛ̀ ɗyoɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kɛ ŋgimɔ te yi Piyɛr ɓa̧ ndi nɛ yekere kɛ sa̧ to yasi te yi nyɛ ɓɛŋma nda nyɛnɔ kɛ́, yaka nɔ, ɓotu ɓete ɓe Kɔrnɛy tomma ɓaka kɛ ɗya̧ kɛ numɛy tu̧. Ɓo saŋma tu̧ Simɔn ɗe dolɔ. ");
INSERT INTO kkj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɛ ɓo diyɛ nɛ mɛn kɛ kwey nde: «Piyɛr te yi ɓo jeɓa sendi nde Simɔn kɔ yáki waka?» ");
INSERT INTO kkj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kɛ ŋgimɔ te yi Piyɛr ɓa̧ ndi kɛ sa̧ to yasi te yi nyɛ ɓɛŋma nda nyɛnɔ kɛ́, ɛ Kimɔ Sisiŋ lɛpɛ nyɛ nyɛ nde: «Ɓɛŋa, ɓembam yitati kɛ diyɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tɛma, pikwɛ, nɔ̀ kwâŋ wúnɛ ɓo kinɛ pa simta yaŋa na, kɛto mi tomɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ndana, ɛ Piyɛr piyɛ kɛ̀ dolɔ ɓembam ɓaka lɛpɔ nyɛ ɓo nde: «Mɔ te yi wunɛ diyɛ kɔ, yo mi. To kɛndi yun nɛ ŋge?» ");
INSERT INTO kkj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɛ ɓo yeŋsa nde: «Yo Kɔrnɛy te kum ɓesɔja tomɛ wusɛ. Mbam te kɛ kɛndɔ nɛ ŋgbeŋ kɛ joŋgwɛ ɗyenɛ, ɓakiɗye mɛmboŋga mɛ Njambiyɛ. Sendi, Ɓeyudɛn hɛnɛ kɛ jɛsɔ nyɛ. Wɛtɛ jaki Njambiyɛ nja̧ lɛpɔ nyɛ nyɛ nde, a jêɓaŋgwɛ wɛ kɛ tu̧ ɗyenɛ, na woku yasi te yi wɛ ta lɛpɔ nyɛ nyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ɛ Piyɛr nyinje ɓo kɛ tu̧, nyɛ sendi ɓo mbɛy jakɔ. Misi pupɛ ɛ nyɛ nyiŋɛ nje kwa̧ ɓenɛ ɓo. Ɓaŋa ɓomɔ kɛ njoka ɓenjɔŋ ɓan ɓe Yope ka̧ tikiɗye nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Misi pupɛ te ɛ wɛtɛ ɛ ɓo kɛndɛ ɗya̧ kɛ Sesare. Kɔrnɛy ɓenɛ ɓemaŋ ɓenɛ nɛ̀ kimɔ ɓesɔ ɓenɛ te yi nyɛ jeɓama ɓaka ɓa̧ kɛ laɗye ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kɛ Piyɛr ma wuta nɛ tu̧, na nyiŋ kɛ́, ɛ Kɔrnɛy kɛ̀ saŋgwa nɛ nyɛ ɓutuma kusɛ mɛɓɔŋ kɛ mɛnɛti kɛ mbɔmbu wenɛ nyɛnɔ nɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yasi wɛtɛ, ɛ Piyɛr ɓiye nyɛ tɛmbiɗye lɛpɔ nyɛ nyɛ nde: «Tɛma, kɛto mi ndi sendi mumɔ nda wɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ɛ Piyɛr lɛpina ɓenɛ Kɔrnɛy nyiŋɛ nɛ tu̧ dolɔ nde, ɓuɗya ɓomɔ ma si wesiɗya. ");
INSERT INTO kkj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ɛ Piyɛr lɛpɛ nyɛ ɓo nde: «Wunɛ duwa̧ nde, yo mboŋga kɛ yi Ɓeyudɛn nde, mɔnɔ Ɓeyudɛn tî nyiŋa tu̧ mɔ te ɛ ti Yudɛn kɔ na. Ɓenɛ nyɛ tî kɛndi na. Ko ɓɛkɔ ɗete, Njambiyɛ teɗya mi nde, mi tî ɓɛŋa wɛtɛ mumɔ nda mɔ te ɛ nɛ sɛmbɔ na, ho sɛŋɛ mumɔ nde, sinɛ nyɛ ti yaka joŋna na. ");
INSERT INTO kkj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɗete, wunɛ jeɓama mi, mi nja̧ kinɛ pa simta yaŋa na. Ndana mi kɛ kwaɗyɛ duwɛ to te yi wunɛ jeɓama nɛ mi kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ɛ Kɔrnɛy lɛpɛ nde: «Yo mɛ muka mɛtu yitati ndi kɛ kiya ŋgimɔ te yikɛ, mi ɓa̧ kɛ tu̧ ɗyembɛ kɛ kelɔ mɛŋgwɛta kɛ hawa yitati te yi ɓekoko. Mi sém semɔ, wɛtɛ mbam tɛmnate kɛ mbɔmbu wombɛ nɛ mɛlambɔ wumnate nɛ mboŋ mboŋ. Ɛ nyɛ lɛpɛ nyɛ mi nde: ");
INSERT INTO kkj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹Kɔrnɛy, Njambiyɛ jayma mɛŋgwɛta mɔ. Sendi, a yeti kɛ leŋsa mɛyasi mɛte yi wɛ nyɛ buka ɓomɔ kɛ́ na, ");
INSERT INTO kkj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ɗete, tomɔ ɓomɔ kɛnjɛ Yope kɛ̀ jeɓa nɛ Simɔn te yi ɓo jeɓa sendi nde Piyɛr kɔ nje nɔ. A yáki kɛ tu̧ Simɔn te mɔ kombila mɛkotu, tu̧ ɗyenɛ kɛ kɛki maŋ.› ");
INSERT INTO kkj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɛ mi tomɛ ɓomɔ nɛdɔ kɛ̀ jeɓa nɛ wɛ, wɛ kelma kimɔte yí nje. Ndana wusɛ hɛnɛ waka kɛ mbɔmbu Njambiyɛ yí wokɔ mɛyasi hɛnɛ te yi nyɛ lɛpima nyɛ wɛ nde, lɛpɔ nyɛ wusɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ɛ Piyɛr nje ɓu̧ lɛpi lɛpɔ nde: «Mi kɛ kombile duwɛ gbate ndana nde, ɓomɔ hɛnɛ ndi wɛtɛ kɛ misi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yo nde, kɛ mɔy mɛkandɔ hɛnɛ, mɔ te ɛ kanɛ Njambiyɛ, kɛndɔ sendi nɛ ŋgbeŋ kɛ joŋgwɛ ɗyenɛ, Njambiyɛ kɛ kwaɗyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Njambiyɛ lɛpima yiŋa yasi kɛnjɛ kandɔ Isarayɛl. A lɛpima Kimɔ Tom kɛnjɛ ɓo nde: Wusɛ yakama ɓɛ nɛ tɛ kɛto Yesus Krist, kɛto nyɛ Kumande ɓomɔ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wunɛ duwa̧ yasi te yi kwaŋnama kɛ Galile nɛ̀ yi nja̧ nje kwaŋna kɛ Yuda hɛnɛ kɛ́. Yo njáki nje kelna, yite Jaŋ ma pelɛ kasi tɔpuna ɓomɔ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wunɛ duwa̧ nda yi Njambiyɛ nya nɛ Yesus te ɛ Nasarɛt Kimɔ Sisiŋ, nyɛ sendi nyɛ ɗeti kɛ́. A ɗikima kɛ̀ mɛmbɛy mɛmbɛy kamɛ ɓomɔ, joŋgwɛ sendi ɓomɔ hɛnɛ ɓe *Kum ɓeya mɛkele namɛ ɓaka, kɛto Njambiyɛ ɓa̧ kɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wusɛ gba ɓotu ɓete ɓe ɓa̧ kɛ mbɛy te, ɓɛŋɛ mɛyasi hɛnɛ te yi nyɛ kelma kɛ Yerusalɛm nɛ̀ kɛ mɛɗya mɛte yiri kɛ mɛnɛti mɛ Ɓeyudɛn kɛ́ nɛ misi musu. Ɓo ŋgbama nyɛ kɛ kroa wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yo nyɛ yi Njambiyɛ womiya kɛ mɛtu yitati kelɔ nde, ɓomɔ ɓɛ̂ŋa nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yasi wɛtɛ, Njambiyɛ tì nyɛ ɓomɔ hɛnɛ ɗeti nde, ɓo ɓɛ̂ŋa nyɛ na. A nya ndi ɓotu ɓete ɓe nyɛ Njambiyɛ nɛ ŋguru wenɛ kikima tɔkɛ ɓaka. Yo wusɛ ɓotu ɓete ɓe sinɛ ɓe Yesus ɗyenama hɔɓiye wɛtɛ kɛ kɔŋ te yi nyɛ womiya nɔ kɛ njoka ɓemuŋ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ɛ Yesus kombile lɛpɔ nyɛ wusɛ nde, wusɛ pêla nyɛ ɓomɔ, lɛpɔ gbate gbate nyɛ ɓo nde, yo nyɛ yi Njambiyɛ tɛmbiɗya nde, a ta pɛsɔ jɔsi ɓomɔ hɛnɛ, ko ɓe ma gwe ko ɓe ndi nɛ joŋ. ");
INSERT INTO kkj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ hɛnɛ kɛ lɛpɔ kasi nɛ nde, mumɔ hɛnɛ ɛ ta tikɔ temɔ nɛ nyɛ, Njambiyɛ ta tikɔ mɛɓeyɔ mɛ mɔ te nɛ ŋgwɛtɛ kɛto ɗinɔ ɗyenɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kɛ ŋgimɔ te yi Piyɛr ɓa̧ ndi kɛ lɛpina ɗete kɛ́, ɛ Kimɔ Sisiŋ piyɛ nje kɛ yotu ɓomɔ hɛnɛ ɓe ɓa̧ kɛ wokɔ Kimɔ Tom te yi nyɛ ɓa̧ kɛ lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ɓeyudɛn ɓete ɓe nja̧ ɓenɛ ɓe Piyɛr hɛnɛ ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka ŋgbakimama yí ɓɛŋɛ nde, Njambiyɛ kɛ nyɛ Kimɔ Sisiŋ nyɛ yiŋa mɛkandɔ sendi. ");
INSERT INTO kkj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yo nde, ɓo wokuma ɓo kɛ lɛpina nɛ yiŋa mɛnumbu lukse Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ɛ Piyɛr lɛpɛ nde: «Ɓotu ɓaka ma ɓu̧ sendi Kimɔ Sisiŋ nda wusɛ, ’ɓomɔ yakama sɛŋɛ nde, ɓo tî tɔpa ɓo kɛ mɔrɔku?» ");
INSERT INTO kkj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ɛ Piyɛr nyɛ ɗeti nde, ɓo tɔ̂pa ɓo kɛ mɔrɔku nɛ ɗinɔ Yesus Krist. Kɛ kɔŋte, ɛ ɓo ŋgwɛta nɛ Piyɛr nde, ɓenɛ ɓo pâŋ pa ya mɔnɔ mɛtu. ");
INSERT INTO kkj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yenɛ kɛ Yuda ɓaka wokuma nde, yiŋa mɛkandɔ jayma sendi mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kɛ Piyɛr ma yɔkwɛ ɗya̧ kɛ Yerusalɛm kɛ́, ɛ Ɓeyudɛn ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus Krist ɓaka ndeyɛ nyɛ ");
INSERT INTO kkj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","lɛpɔ nde: «Wɛ ka̧ kɛ yi ɓotu ɓete ɓe tì pɛsina ɓaka kwa̧ ɗyena wúnɛ ɓo.» ");
INSERT INTO kkj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ɛ Piyɛr nyɛ numbu yekiɗye mɛyasi mɛte yi kwaŋnama kɛ́ nɛ kwɛt kwɛt nyɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","A yekiɗya lɛpɔ nyɛ ɓo nde: «Mi ɓa̧ kɛ Yope. Kɛ ŋgimɔ te yi mi ɓa̧ kɛ ŋgwɛta nɛ Njambiyɛ kɛ́, ɛ ɗyanɔ ɗyembɛ ɗimbiyɛ, ɛ yaŋa ɗya̧ mi nda nyɛnɔ. Ɛ mi ɓɛŋɛ yiŋa yasi nda nyaŋgwɛ gwey kɛ piyɛ wulɛ ɗyoɓɔ nda ɓo ɓiyma mɛɓoku mɛte yini. Ɛ yo nje tɛmɛ kɛ mbɔmbu wombɛ. ");
INSERT INTO kkj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ɛ mi ɓɛŋɛ nyaŋgwɛ gwey yinɔri nɛ ŋgoŋ seŋgile yo. Ɛ mi ɓɛŋɛ ɓenyamɔ ɓete ɓe nɛ mɛkol yini ɓe ɗiyɛ kɛ to mɛnɛti nɛ̀ ɓaka ɓe ɗiyɛ kɛ mɔy likɔ nɛ̀ ɓaka ɓe kɛndɛ ɗulma nɛ mɔy nɛ̀ ɓenɔn ɓete ɓe jɛ kɛ kwey, ɓo hɛnɛ ɓa̧ kɛ mɔyte. ");
INSERT INTO kkj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kɛ kɔŋte, ɛ mi wokɛ wɛtɛ mɛn kɛ lɛpɔ nyɛ mi nde: ‹Piyɛr, tɛma, wokɔ ɓenyamɔ ɓenɔri ɗye.› ");
INSERT INTO kkj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yasi wɛtɛ, ɛ mi yeŋsa nde: ‹Ko na, Nyaŋgwɛ Kumande! Kɛto ko yiŋa yasi te yi nɛ sɛmbɔ ho yi nɛ mɛmi tì pa kɛ̀ wɛtɛ yesɔ kɛ numbu mbɛ na.› ");
INSERT INTO kkj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kɛ mɛŋga yiɓate, ɛ mɛn wulɛ ɗyoɓɔ lɛpɔ nde: ‹Yasi te yi Njambiyɛ ma pɛsɔ nde, yo mɛ pupunate, wɛ tî njaki ɓu̧ yo nda yasi te yi nɛ sɛmbɔ na!› ");
INSERT INTO kkj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yo kelnama ɗete kumɔ mɛŋga yitati. Kɛ kɔŋte, ɛ yasi yinɔri hɛnɛ yɔkwɛ kɛ̀ ɗyoɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yaka nɔ, ɓomɔ yitati kɛ ɗya̧ kɛ numɛy tu̧ komɛ mi ɓa̧ ya kɛ́. Ɓo tomma ɓo wulɛ Sesare njesɛ kɛ yembɛ. ");
INSERT INTO kkj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɛ Kimɔ Sisiŋ lɛpɛ nyɛ mi nde, mi kwâŋ sinɛ ɓo kinɛ pa simta na. Ɓemaŋ ɓusu yitan jɔ wɛtɛ ɓaka ka̧ tikiɗye mi, ɛ wusɛ ɗya̧ nyiŋɛ tu̧ Kɔrnɛy. ");
INSERT INTO kkj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɛ Kɔrnɛy yekiɗye nda yi nyɛ ɓɛŋma nɛ wɛtɛ jaki Njambiyɛ tɛmnate kɛ mɔy tu̧ ɗyenɛ kɛ́ nyɛ wusɛ, yekiɗye sendi nda yi jaki Njambiyɛ te lɛpima nyɛ nyɛ nde: ‹Tomɔ ɓomɔ kɛnjɛ kɛ Yope kɛ̀ jeɓa nɛ wɛtɛ mbam nde Simɔn, yiŋa ɗinɔ ɗyenɛ nde Piyɛr. ");
INSERT INTO kkj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A ta lɛpɔ mɛyasi mɛte yi ta joŋgwɛ wɛ wúnɛ ɓotu ɓe tu̧ ɗyɔ hɛnɛ kɛ́ nyɛ wɛ.› » ");
INSERT INTO kkj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ɛ Piyɛr kɛ̀ mbɔmbu lɛpɔ nde: «Kɛ mi ma nyɛ numbu kɛ lɛpi kɛ́, ɛ Kimɔ Sisiŋ piyɛ nje kɛ yotu ɓotu ɓete ɓe ɓa̧ kɛ tu̧ ɓaka, ndi nda yi Kimɔ Sisiŋ piya nɔ mbɔmbu nje kɛ yotu su ɓejekɛ ɓe Yesus kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ɛ mi takɛ lɛpi te yi Kumande Yesus lɛpima nde: ‹Jaŋ tɔpuma ɓomɔ kɛ mɔrɔku, kɛ ɓɛ wunɛ, Njambiyɛ ta tɔpɛ wunɛ kɛ Kimɔ Sisiŋ.› » ");
INSERT INTO kkj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Piyɛr ka̧ sendi mbɔmbu lɛpɔ nde: «Njambiyɛ nya ɓotu ɓete ndi kiya Kimɔ Sisiŋ te yi nyɛ nya wusɛ kɛ ŋgimɔ te yi wusɛ tikima nɛ temɔ kɛ yi Kumande Yesus Krist kɛ́. Ɗete, mi mɔ te nda, nɛ́ mi lu̧ ɗyambi nɛ Njambiyɛ?» ");
INSERT INTO kkj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kɛ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yenɛ kɛ Yuda ɓaka ma si wokɔ ɗete kɛ́, ɛ mɛtemɔ man si wɛyɛ. Ɛ ɓo lukse Njambiyɛ lɛpɔ nde: «Njambiyɛ jayma gbate nde, yiŋa mɛkandɔ yêŋsaŋgwɛ sendi temɔ, nɛ́ ɓo ɓɛ nɛ joŋgwɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ɓotu ɓete ɓe wanjama kɛto nyaŋgwɛ mɛbɔnɛ mɛte yi ɓo teɗya ɓo kɛto Itɛn kɛ́ ka̧ kumɔ Fenisi, kumɔ Siprɛ nɛ̀ Aŋtiyos. Ɓo ɗikima lɛpɔ Kimɔ Tom nyɛ ndi Ɓeyudɛn ɓepɔ. ");
INSERT INTO kkj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ko ɗete, ɓaŋa ɓomɔ kɛ njoka yan ɓe ɓa̧ ɓotu ɓe Siprɛ nɛ̀ ɓotu ɓe Sirɛn ɓaka ka̧ kumɔ kɛ Aŋtiyos. Ɛ ɓo lɛpɛ Kimɔ Tom kɛ kasi Kumande Yesus nyɛ Ɓegrɛk. ");
INSERT INTO kkj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ɗeti te yi Baba Mbokɔ ɗiyma kɛ yotu yan, ɛ ɓomɔ ɓuɗyate yeŋsa temɔ tikɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus kɛ Yerusalɛm ɓaka wokuma kasi te. Ɛ ɓo tomɛ Barnabas kɛnjɛ kɛ Aŋtiyos. ");
INSERT INTO kkj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kɛ Barnabas ma ɗya̧ mate ɓɛŋɛ nda yi Njambiyɛ teɗya nɛ ŋgikwa nɛ kɛ́, ɛ nyɛ sosa kitɛ ɓo hɛnɛ nde, ɓo kɛ̂n mbɔmbu wokuna nɛ Nyaŋgwɛ Kumande nɛ temɔ yan hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ɓa̧ mɔ ŋgikwa. Kimɔ Sisiŋ ɓa̧ tondunate kɛ yotu nɛ. A ɓa̧ sendi kɛ tikɔ temɔ kɛ yi Njambiyɛ. Ɗete, ɛ ɓomɔ ɓuɗyate nyiŋɛ kɛ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kɛ kɔŋte, ɛ nyɛ nje kwa̧ kɛ̀ kɛ Tars kɛ̀ gɔsɔ Sol. ");
INSERT INTO kkj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kɛ nyɛ ma si dolɔ nyɛ kɛ́, ɛ nyɛ ɓu̧ nyɛ kɛ̀ nɔ Aŋtiyos. Ɓo kwaŋɗya sew wɛtɛ nɛ yim mate. Kɛ sew wɛtɛ te, ɓo ɗikima wesiɗya ɓenɛ njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Kumande Yesus kɛ Aŋtiyos ɓaka. Ɛ ɓo ɗiki teɗye mɛlɛpi mɛ Njambiyɛ nyɛ ɓuɗya ɓomɔ. Yo kɛ Aŋtiyos yi ɓo kandima jeɓan ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka nde Kritɛn. ");
INSERT INTO kkj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kɛ ŋgimɔ te yite ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ tɛmma Yerusalɛm kɛ̀ kɛ Aŋtiyos. ");
INSERT INTO kkj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ɛ wɛtɛ kɛ njoka yan, ɗinɔ ɗyenɛ nde Agabus tɛmɛ. Kimɔ Sisiŋ lɛpinama nyɛ nyɛ, ɛ nyɛ pelɛ nde, nyaŋgwɛ kolɔ ta ɗya̧ kɛ to mɛnɛti hɛnɛ. Ɛ yo ɗya̧ gbate kɛ ŋgimɔ te yi Kolod ɓa̧ nyaŋgwɛ kumande kɛ to mɛnɛti kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka pɛsɛ nde, ɓo ta tomse mɛyasi yí kamɛ nɛ ɓenjɔŋ ɓan ɓe kɛ Yuda ɓaka. Mumɔ hɛnɛ nya ɓeŋgwɛ ɗeti te yenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɛ ɓo tomse yo nɛ Barnabas ɓenɛ Sol kɛ̀ nyɛ ɓetomba mbanjɔ Njambiyɛ kɛ Yerusalɛm ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kɛ pɔku mɛtu te yite ɛ kumande Herod nyɛ ɓɔ kɛ teɗya mɛbɔnɛ nyɛ ɓaŋa ɓomɔ kɛ njoka njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A nya ɗeti nde, ɓo wôku Jak te maŋ nɛ Jaŋ nɛ kafa. ");
INSERT INTO kkj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kɛ nyɛ ma ɓɛŋɛ nde, mɛkele mɛte kimɔte kɛ misi mɛ Ɓeyudɛn kɛ́, ɛ nyɛ nyɛ sendi ɗeti nde, ɓo ɓîya Piyɛr. Yo ɓa̧ kɛ ŋgimɔ jesɔ ɗyena mɛmampa mɛte yi kinɛ ŋga̧ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kɛ ɓo ma si ɓiye nyɛ ɗete kɛ́, ɛ Herod kwaŋɗye nyɛ kɛnjɛ kɛ tu̧ jɔɓɔ lɛpɔ nde, njɔŋ ɓesɔja yini ɗîki pɛmɔ Piyɛr. Njɔŋ ɓesɔja wɛtɛ ɓa̧ nɛ ɓesɔja yini. Herod kwaɗya jɔse Piyɛr kɛ misi mɛ ɓomɔ hɛnɛ kɛ kɔŋ jesɔ *Paska Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɗete, ɓo ɓa̧ kɛ pɛmɔ Piyɛr kɛ tu̧ jɔɓɔ. Yasi wɛtɛ, njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka ɗikima ŋgwɛta nɛ Njambiyɛ ɓuɗyate kɛto nɛ. ");
INSERT INTO kkj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kɛ tu te yi ɓa̧ nde, misi pupɛ te Herod ta jɔse Piyɛr kɛte kɛ́, Piyɛr ɓa̧ wotunate nɛ mɛkɔl sumba yiɓa. A yama kɛ njoka ɓesɔja yiɓa. Ɓesanjele ɓa̧ sendi kɛ pɛm kɛ numɛy tu̧ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Semɔ semɔ, ɛ wɛtɛ jaki Baba Mbokɔ ɗya̧, ɛ mɛjasi panɛ kɛ mɔy tu̧ jɔɓɔ. Ɛ nyɛ kpokɛ Piyɛr kɛ mbanjɔ jemɛ nyɛ lɛpɔ nde: «Tɛma nɛdɔ.» Ɛ mɛkɔl mɛ sumba te yi ɓo wotuma nɛ mɛɓɔ mɛnɛ kɛ́ si sɔriyɛ ɓalɔ kɛ mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kɛ kɔŋte, ɛ jaki te lɛpɛ nyɛ nyɛ nde: «Susula kanda yɔ, lɛŋa mɛnakala mɔ.» Ɛ Piyɛr si kelɔ ɗete. Ɛ jaki nje lɛpɔ sendi nyɛ nyɛ nde: «Petɔ yotu yɔ nɛ lambɔ ɗuku yɔ, nɔ̀ ɓêŋgwɛ mi.» ");
INSERT INTO kkj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ndana, ɛ Piyɛr pundɛ, ɓeŋgwɛ nyɛ. A tì ɓɛ kɛ duwɛ nde, yasi te yi jaki ɓa̧ kɛ kelɔ kɛ́ ɓa̧ gbakasi na, a takima nde, yo nyɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓo kɛndima kwa̧ bosa njɔŋ ɓotu ɓe pɛmna yasi, kɛndɔ kwa̧ sendi ɓe kɔŋte. Ɛ ɓo nje kɛndɔ kumɔ kɛ numɛy te yi ɓo kelma nɛ sumba kɔ. Wɛ kwáŋ numɛy te mbɛte nje pundɔ sɛ̧. Kɛ ɓo ma kumɔ womɛte kɛ́, ɛ numɛy ɓutuna nɛ ŋguru wenɛ kɛ mbɔmbu yan, ɛ ɓo pundɛ ɓu̧ wɛtɛ nyaŋgwɛ nje. Ndana ndana, ɛ jaki ɗimbiyɛ kɛ misi mɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ɗiyɔ kɛ́, ɛ ɗyanɔ ɗyenɛ yɔkwɛ, ɛ nyɛ lɛpɛ nde: «Mi kɛ ɓɛŋɛ ndana nde, yo gbakasi nde, Baba Mbokɔ tomma jaki wenɛ nde, a njâki joŋgwɛ mi soŋɛ kɛ mɛɓɔ mɛ Herod nɛ̀ kɛ ɓeya mɛyasi hɛnɛ te yi Ɓeyudɛn kwaɗya kelɔ nɛ mi kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kɛ ɗyanɔ ɗyenɛ ma si yɔkwɛ kɛ́, ɛ nyɛ kwa̧ tɔkɛ nje tu̧ Mariya te nyaŋgwɛ nɛ Jaŋ te yi ɓo jeɓa sendi nde Mark kɔ. Ɓaŋa ɓenjɔŋ ɓusu ɓuɗyate ɓa̧ womɛte kɛ mɛwesiɗya kɛ ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ɛ Piyɛr ɗya̧ ɗuŋgwɛ nyaŋgwɛ numɛy, ɛ wɛtɛ nyari nde Roda ɛ ɗikima kelɔ mɛsay womɛte kɔ kɛ̀ lɛŋgwɛ tɔ. ");
INSERT INTO kkj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ɛ nyɛ wokɛ mɛn wɛtɛ mumɔ duwɛ nde, yo mɛn Piyɛr, ɛ mɛsosa kwa̧ nyɛ. Ɛ nyɛ yɔkwɛ nɛ sokɔ kinɛ ɓutɛ numɛy na. Ɛ nyɛ kwa̧ kɛ̀ lɛpɔ nde, Piyɛr kɛ numɛy tu̧. ");
INSERT INTO kkj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «’Wɛ kɛ kɔnɔ ka nɛ to?» Ko ɓɛkɔ ɗete, ɛ nyɛ kombile lɛpɔ nyɛ ɓo nde, yo gbakasi. Ɛ ɓo lɛpɛ nde: «Yo yâkaŋgwɛ ɓɛ sisiŋ nɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ko ɗete, Piyɛr ka̧ ndi mbɔmbu yí ɗuŋgwɛ numɛy. Ɓo nja̧ ɓutɛ numɛy, ɛ ɓo ŋgbakima yí ɓɛŋɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ɛ nyɛ pɛpiɗye ɓɔ nyɛ ɓo nde, ɓo ɗîy nɛ sɛm. Ɛ nyɛ yekiɗye nda yi Baba Mbokɔ punja nɛ nyɛ kɛ tu̧ jɔɓɔ kɛ́. Ɛ nyɛ nje lɛpɔ nde: «Wunɛ kɛ̂n kɛ̀ yekiɗye ɗete nyɛ Jak, yekiɗye sendi ɗete nyɛ ɓemaŋ ɓusu ɓari.» Kɛ kɔŋte, ɛ nyɛ pundɛ kwa̧ kɛ̀ kɛ wɛtɛ mbɛy. ");
INSERT INTO kkj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kɛ misi ma pupɔ, ɛ lɛpi ɓanɛ ɓesɔja yí duwɛ nɛ mbɛy te yi Piyɛr ka̧ te kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ɛ Herod lɛpɛ nde, ɓo sâŋ nyɛ. Yasi wɛtɛ, ɓo sáŋ nyɛ kinɛ dolɔ na. Ɛ Herod ɓeŋgwɛ ɓotu ɓe pɛmna ɓotu ɓe jɔɓɔ nɛ lɛpi te. Kɛ kɔŋte, ɛ nyɛ pɛsɛ nde, ɓo ɓôŋ ɓo kɛ̀ wo. Ɛ nyɛ nje tɛmɛ kwa̧ kɛ̀ kɛ Yuda kɛ̀ kwaŋɗye ɓuɗya mɛtu kɛ Sesare. ");
INSERT INTO kkj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod ɓa̧ nɛ nyaŋgwɛ ŋgambi suŋgwɛ nɛ ɓotu ɓe Tir nɛ̀ Sidɔn. Ɛ ɓotu ɓaka saŋgwɛ mɛn tɛmɛ kɛ̀ ɓɛŋɛ nyɛ, yite ɓo sima kombile ŋgiŋ ɓenɛ ɓe wɛtɛ mbam nde Blat te ajiya kumande Herod. Ɓo ka̧ kɛ̀ ɓɛŋɛ Herod, nɛ́ ɓenɛ ɓo kel mbon, nɛ́ ɓo ɗiy nɛ tɛ, kɛto mɛyasi man hɛnɛ ɗikima wulɛ kɛ mɛnɛti mɛ kumande Herod. ");
INSERT INTO kkj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kɛ yesɔ te yi ɓo kpoma nde, ɓo ta saŋgwa kɛte kɛ́ ma ɗya̧, ɛ Herod lɛŋɛ nyaŋgwɛ lambɔ ɓekumande ɗiyɔ nɔ kɛ mbanjɔ lɛpina nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɛ ɓo lɛpɛ nɛ mɛn kɛ kwey nde: «Yikɛ yeti mɛn mumɔ na, yikɛ mɛn wɛtɛ njambiyɛ!» ");
INSERT INTO kkj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ɛ wɛtɛ jaki Baba Mbokɔ ɗiɓɛ numbu nɛ kɛ kiya mbɛy, kɛto a tikima Njambiyɛ lukse yotu nɛ. Ɛ ɓekon nyiŋɛ nyɛ kɛ yotu hɛnɛ wo nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ndana mɛlɛpi mɛ Njambiyɛ ka̧ ndi kɛndɔ mbɔmbu. ");
INSERT INTO kkj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kɛ Barnabas ɓenɛ Sol ma si siɗyɛ mɛsay man kɛ Yerusalɛm kɛ́, ɛ ɓo ɓu̧ Jaŋ te yi ɓo jeɓa nde Mark kɔ yɔkwɛ nɔ kɛ̀ Aŋtiyos. ");
INSERT INTO kkj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ nɛ̀ nyaŋgwɛ ɓotu ɓe teɗya mɛlɛpi mɛ Njambiyɛ ɓa̧ kɛ njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Kumande Yesus kɛ Aŋtiyos ɓaka. Yo ɓa̧ nɛ̀ Barnabas nɛ̀ Simeyɔŋ te yi ɓo ɗikima jeɓa nde Nijɛr kɔ. Yo ɓa̧ sendi nɛ̀ Likiyus, mɔ Sirɛn nɛ̀ Manahɛn te yi ɓo ɗɔkwa nyɛ ɓenɛ Herod kɔ nje ɓu̧ Sol. ");
INSERT INTO kkj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wɛtɛ yesɔ te yi ɓo ɓa̧ kɛ kanɔ Baba Mbokɔ kiyɔ mɛɗye kɛ́, ɛ Kimɔ Sisiŋ lɛpɛ nde: «Ndana wunɛ tɔ̂ka Barnabas ɓenɛ Sol soŋɛ kɛ njoka yun, nɛ́ ɓo kel mɛsay mɛte yi mi kpoma nde, ɓo ta kelɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kɛ kiyna mɛɗye nɛ̀ mɛŋgwɛta ma siyɔ kɛ́, ɛ ɓo kasɛ mɛɓɔ kɛ yotu Barnabas ɓenɛ Sol. Kɛ kɔŋte, ɛ ɓo tikɛ ɓo nde, ɓo kwâŋ. ");
INSERT INTO kkj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kimɔ Sisiŋ tomma Barnabas ɓenɛ Sol, ɛ ɓo kwa̧ kumɔ kɛ Selesi. Ɓo nja̧ tɛmɛ womɛte nyiŋɛ kuka kumɔ kɛ wɛtɛ kiriŋgira nde Siprɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kɛ ɓo ma kumɔ kɛ Salami kɛ́, ɛ ɓo lɛpɛ mɛlɛpi mɛ Njambiyɛ nyɛ ɓomɔ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. Jaŋ te yi ɓo jeɓa nde Mark kɔ ɗikima kamɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɓo nja̧ saɓiyɛ kiriŋgira hɛnɛ kumɔ kɛ Pafos. Kumɔ mate, ɛ ɓo dolɛ wɛtɛ mɔ kelna mɛyasi mɛ kifi, a ɓa̧ mɔ Ɓeyudɛn, ɗinɔ ɗyenɛ nde Baryesus. A ɓa̧ mɔ punja mɛlɛpi mɛ ja̧. ");
INSERT INTO kkj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A ɓa̧ kɛ joŋna ɓenɛ Sɛrgus Polos te kum kiriŋgira. Sɛrgus Polos ɓa̧ nɛ ɗyanɔ. A tomma ɓomɔ kɛ̀ jeɓa nɛ Barnabas ɓenɛ Sol, kɛto a kwaɗya wokɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yasi wɛtɛ, Elimas te mɔ kelna mɛyasi mɛ kifi kɔ ɗikima petɔ Barnabas ɓenɛ Sol, ma kum kiriŋgira mɛ nje tikɔ temɔ kɛ yasi te yi ɓo ta lɛpɔ nyɛ nyɛ kɛ́. Elimas, yo ɗinɔ Baryesus kɛ numbu Grɛk. ");
INSERT INTO kkj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ndana, ɛ Kimɔ Sisiŋ tondɛ nɛ ŋgbɛŋ kɛ yotu Sol te yi ɓo jeɓa sendi nde Pol kɔ. Ɛ nyɛ ɓɛŋɛ Elimas te mɔ kelna mɛyasi mɛ kifi kɔ nɛ ŋgoŋ ");
INSERT INTO kkj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","lɛpɔ nde: «Wɛ mɔ mɛseɓila nɛ̀ ɓeya mɛkele hɛnɛ! Wɛ mɔnɔ *Kum ɓeya mɛkele, wɛ kɛ lu̧ ɗyambi nɛ mɛyasi hɛnɛ te yi ɓɛ nɛ ŋgbeŋ! ’Wɛ ta ndulɔ yaŋgila yasi te yi Baba Mbokɔ si kpo kɛ́ ndenɛn? ");
INSERT INTO kkj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ɓɛŋa ndana, Baba Mbokɔ ta teɗye wɛ mɛbɔnɛ, misi mɔ ta ɗiɓina. Wɛ tí ɓɛŋɛ se mɛjasi mɛ yesɔ na kumɔ kɛ yiŋa ŋgimɔ.» Ndana ndana, ɛ misi mɛnɛ ɗiɓina nɛ kpikip, ɛ nyɛ kandɛ ɓoɓila yasi, sa̧ mɔ te ɛ ta ɓiye nyɛ kɛ ɓɔ teɗye nyɛ nje. ");
INSERT INTO kkj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kɛ kum kiriŋgira ma ɓɛŋɛ mɛyasi mɛte yi kwaŋnama kɛ́, ɛ nyɛ tikɛ temɔ kɛ yi Kumande Yesus, kɛto yasi te yi ɓo lɛpima nyɛ nyɛ kɛ kasi Kumande Yesus kɛ́ loŋma nyɛ kɛ temɔ. ");
INSERT INTO kkj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ɓenɛ ɓenjɔŋ ɓenɛ nyiŋma kuka kɛ Pafos kwa̧ kumɔ kɛ Pɛrgɛ kɛ Pamfili. Kumɔ mate, ɛ Jaŋ li̧ ɓo yɔkwɛ nɛ kɔkɔ kɛ̀ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pol ɓenɛ Barnabas nja̧ tɛmɛ kɛ Pɛrgɛ kumɔ kɛ Aŋtiyos kɛ Pisidi. Kɛ yesɔ *Saba ma ɗya̧ kɛ́, ɛ ɓo nyiŋɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kwa̧ ɗiyɔ mɛtiɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kɛ tɔlna mɛkana mɛ mɛmboŋga mɛ Njambiyɛ nɛ̀ tɔlna mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ ma siyɔ kɛ́, ɛ ɓotu ɓete ɓe ɗiyɛ nɛ mbanjɔ mɛwesiɗya ɓaka tomɛ ɓomɔ kɛnjɛ kɛ yi Pol ɓenɛ Barnabas kɛ̀ lɛpɔ nyɛ ɓo nde: «Wunɛ njɔŋ, ŋgɛ ɓɛ nde, wunɛ nɛ yiŋa yasi te yi wunɛ kɛ kwaɗyɛ lɛpɔ nyɛ ɓomɔ yí nyɛ nɛ ɓo mɛŋgitɛ, wunɛ lɛ̂pi.» ");
INSERT INTO kkj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ndana, ɛ Pol tɛmɛ kaŋɛ ɓɔ nyɛ ɓomɔ lɛpɔ nde: «Wunɛ ɓotu ɓe kandɔ Isarayɛl nɛ̀ wunɛ ɓotu ɓete ɓe kambɛ sendi Njambiyɛ ɓaka, wunɛ lɛ̂ŋgwɛ mɛtɔ! ");
INSERT INTO kkj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Njambiyɛ te ɛ kandɔ Isarayɛl tɔkuma ɓesaŋmbambɔ ɓusu. Ɛ nyɛ kelɛ nde, ɓo nyɛ̂ɓi ɓuɗyate kɛ ŋgimɔ te yi ɓo ɓa̧ nɔ kɛ mɛnɛti mɛ Ejipt kɛ́. Ɛ nyɛ soŋɛ ɓo kɛ Ejipt nɛ nyaŋgwɛ ɗeti nɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A disimama ɓo kɛ mɛsew nda kamɔni kɛ mɔy koŋgor. ");
INSERT INTO kkj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɛ nyɛ girise mɛkandɔ yitan jɔ yiɓa kɛ mɛnɛti mɛ Kanan nje ɓu̧ mɛnɛti man nyɛ kandɔ ɗyenɛ Isarayɛl nde, ɓo nâm. Mɛyasi mɛnɔri hɛnɛ kwaŋnama kɛ mɛsew gɔmay yini jɔ kamɔtan. ");
INSERT INTO kkj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kɛ kɔŋte, ɛ nyɛ tɛmbiɗye ɓotu ɓe pɛsina jɔsi kɛ njoka yan nyɛ ɓo kumɔ kɛ ŋgimɔ Samiyɛl te mɔ punja mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ɗiyɔ kɛ kɔŋte kɛ́, ɛ ɓesaŋmbambɔ ɓusu kwaɗyɛ ɓɛ nɛ kumande te ɛ ta ɗiyɔ nɛ ɓo. Ɛ Njambiyɛ tɛmbiɗye Sayul te mɔnɔ Kis, mɔ kandɔ Bɛŋjamɛ̧ nyɛ ɓo. Ɛ nyɛ ɗiyɛ nɛ ɓo yaka mɛsew kamɔni. ");
INSERT INTO kkj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kɛ Njambiyɛ ma soŋɛ Sayul kɛ́, ɛ nyɛ nje tɛmbiɗye Davit nde, a ɓɛ̂ki kumande wan. Njambiyɛ lɛpima kɛ kasi Davit nde: ‹Mi Njambiyɛ tɔkuma Davit te mɔnɔ Isay, temɔ mbɛ ɓiyma nyɛ. A ta kelɔ mɛyasi hɛnɛ te yi mi kwaɗyɛ kɛ́.› ");
INSERT INTO kkj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yo kɛ kandɔ Davit yi Njambiyɛ nya Isarayɛl Mɔ te ɛ ta joŋgwɛ ɓo nda yi nyɛ kpoma kɛ́. Mɔ te, yo Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Piŋɔ te yi Yesus tì pa nje na, Jaŋ ɗikima pelɛ kasi tɔpuna ɓomɔ kɛ mɔrɔku nyɛ kandɔ Isarayɛl hɛnɛ nde, ɓo yêŋsaŋgwɛ temɔ, nɛ́ ɓo tɔpi ɓo kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kɛ ŋgimɔ te yi mɛsay mɛ Jaŋ ɓa̧ kɛ kɛ̀ kɛ siynate kɛ́, a ɗikima lɛpɔ nyɛ ɓomɔ nde: ‹Wunɛ táka nde, mi nda? Mi yeti mɔ te yi wunɛ laɗye kɔ na. Wunɛ dûkwɛ nde, a ta nje kɛ kɔŋ mbɛ. Mi tí yaka wunjɛ kɔl mɛnakala kɛ kol nɛ na.› ");
INSERT INTO kkj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Wunɛ njɔŋ, wunɛ ɓenday ɓe Abaraham nɛ̀ wunɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka, Kimɔ Tom te yi Njambiyɛ njesa nde, a ta joŋgwɛ ɓomɔ kɛ́, a njésikwɛ tom te kɛto su. ");
INSERT INTO kkj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kɛto, ɓotu ɓe Yerusalɛm nɛ̀ ɓekum ɓan tì duwɛ nde, Yesus ɓa̧ mɔ te ɛ ta joŋgwɛ ɓo na. Ɓo tì ɓɛ sendi kɛ wokɔ to mɛlɛpi mɛte yi ɓomɔ ɗikima tɔlɔ kɛ mɛkana mɛ ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ mɛtu hɛnɛ kɛ yesɔ *Saba kɛ́ na. Ɓo pɛsima nde, Yesus sâŋgwaŋgwɛ nɛ mɛbɔnɛ. Ɗete, ɓo kelma yasi te yi mɛlɛpi mɛte lɛpima kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko ɓɛkɔ nde, ɓo tì ɓɛ nɛ to lɛpi te yi wo nɛ nyɛ, ɓo lɛpima nyɛ Pilat nde, a wôku nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kɛ ɓo ma si kelɔ yasi hɛnɛ te yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ kasi nɛ kɛ́, ɛ ɓo piɗyɛ muŋ nɛ kɛ kroa ɓu̧ kɛ̀ pumbɔ. ");
INSERT INTO kkj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ko ɗete, Njambiyɛ womiya nyɛ soŋɛ kɛ njoka ɓemuŋ. ");
INSERT INTO kkj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ɓotu ɓete ɓe wulma Galile ɓenɛ ɓe Yesus nje kɛ Yerusalɛm ɓaka ɓɛŋma nyɛ mɛtu ɓuɗyate kɛ kɔŋ womiya nɛ. Ɓotu ɓete ɓe ɓa̧ kɛte ɓɛŋɛ mɛyasi mɛte yi kwaŋnama kɛ́ kɛ lɛpɔ yo ndana nɛ ŋgbak ŋgbak nyɛ ɓotu ɓe kandɔ Isarayɛl. ");
INSERT INTO kkj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Wusɛ nɛ ŋguru wusu kɛ nje lɛpɔ Kimɔ Tom te nyɛ wunɛ nde, yasi te yi Njambiyɛ kpoma nyɛ ɓesaŋmbambɔ ɓusu kɛ́, ");
INSERT INTO kkj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","a ma si tonjɛ yo nyɛ wusɛ ɓenday ɓan kɛ ŋgimɔ te yi nyɛ womiya nɛ Yesus nda yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ Ɓesom yiɓa nde: ‹Wɛ mɔnmbɛ, kandɛ ndana mi mɛ sɔŋgwɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Njambiyɛ kandima si lɛpɔ nde, a ta womiyɛ Yesus soŋɛ kɛ njoka ɓemuŋ, ɗete ko a tí ɓɔ na. Njambiyɛ lɛpima kasi te nde: ‹Mi ta nyɛ wunɛ kpasa mɛkombila mɛte yi mi kpoma nyɛ Davit kɛ́. Ɓomɔ ɓɛ̂ki nɛ ɓiɓina temɔ nde, mɛkombila mɛte ta ɓɛŋna gbate.› ");
INSERT INTO kkj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Njambiyɛ kɛ lɛpɔ sendi kɛ wɛtɛ mbɛy kɛ mɔy mɛkana mɛnɛ nde: ‹Wɛ tí jayɛ nde, muŋ kimɔ mɔ mɛsay wɔ ɓɔ̂ku kɛ mɔy mɛnɛti na.› ");
INSERT INTO kkj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yasi wɛtɛ, kɛ Davit ma si kelɔ mɛsay kɛ ŋgimɔ te yenɛ ɓeŋgwɛ yasi te yi Njambiyɛ kombila kɛ́, ɛ nyɛ nje gwe. Ɛ ɓo pumbɛ nyɛ nda yi ɓo pumbuma sendi nɛ ɓesaŋmbambɔ kɛ́. Ɛ muŋ nɛ ɓɔ kɛ mɔy mɛnɛti. ");
INSERT INTO kkj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ndi nde, yɔkɔ yi Njambiyɛ womiya nyɛ kɔ tì ɓɔ nɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ɗete, wunɛ njɔŋ, wunɛ dûkwɛ nde, yo kɛ ɗinɔ ɗyenɛ yi ɓo lɛpɛ nyɛ wunɛ nde, Njambiyɛ ta tikɔ mɛɓeyɔ mun nɛ ŋgwɛtɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Yo sendi kɛ ɗinɔ ɗyenɛ, mumɔ te ɛ tikɛ temɔ nɛ nyɛ, Njambiyɛ kɛ pɛsɔ nde, mɔ te mɛ nɛ ŋgbeŋ kɛ mbɔmbu wenɛ. Yo yasi te yi mɛmboŋga mɛte yi Mɔyisi kɛtima tì ɓɛ nɛ ɗeti te yi kelɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɗete, wunɛ ɗîy nɛ sɔsɔ, ma wunɛ mɛ nje saŋgwa nɛ mɛyasi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. Ɓo lɛpima nde: ");
INSERT INTO kkj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Wunɛ ɓotu ɓe yɛliya, wunɛ ɓɛ̂ŋa, wunɛ ŋgbâkimaŋgwɛ ɓuɗyate kwa̧ yambile, kɛto mi ta kelɔ yiŋa mɛkele kɛ ŋgimɔ te yun, ko ɓo lɛ̂pi yo nyɛ wunɛ, wunɛ tí jayɛ na.› » ");
INSERT INTO kkj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kɛ Pol ɓenɛ Barnabas ma pundɔ kɛ mɔy mbanjɔ mɛwesiɗya kɛ́, ɛ ɓomɔ ŋgwɛta nɛ ɓo nde, ɓo kâlaŋgwɛ nje kɛ yesɔ *Saba te ɛ kɔŋte, nje lɛpina sendi kɛ kiya to lɛpi te. ");
INSERT INTO kkj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kɛ mɛwesiɗya ma siyɔ kɛ́, ɛ ɓuɗya Ɓeyudɛn nɛ̀ ɓaŋa gbɛla ɓomɔ ɓuɗyate ɓe nja̧ nyiŋɛ misɔn Ɓeyudɛn ɓaka ɓeŋgwɛ Pol ɓenɛ Barnabas. Ɛ Pol ɓenɛ Barnabas nyɛ mɛsimɔ ɓenɛ ɓo kitɛ ɓo nde, ɓo kɛ̂n mbɔmbu tikɔ temɔ nde, Njambiyɛ nɛ ŋgikwa. ");
INSERT INTO kkj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kɛ yesɔ Saba te ɛ kɔŋte ma ɗya̧ kɛ́, ɛ sulɔ ɓotu ɓe Aŋtiyos wesiɗya nje wokɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kɛ Ɓeyudɛn ma ɓɛŋɛ nyaŋgwɛ ŋgil ɗete kɛ́, ɛ ɓo kelɛ ɓeya temɔ, ɓiye mɛso nɛ Pol kɛ yasi te yi nyɛ ɗikima lɛpɔ kɛ́ toyɛ sendi nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ɛ Pol ɓenɛ Barnabas lɛpɛ misi nɛ misi nyɛ ɓo nde: «Yo ɓa̧ nde, wusɛ kânda lɛpɔ mɛlɛpi mɛ Njambiyɛ nyɛ wunɛ. Yasi wɛtɛ, nda yi wunɛ sɛŋma yo, pɛsɔ sendi jɔsi yun nɛ ŋguru wun nde, wunɛ ti yaka ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo na, ndana wusɛ kɛ tumɔ kɔŋ nɛ wunɛ kɛ̀ kɛ yi ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka, ");
INSERT INTO kkj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","kɛto Baba Mbokɔ lɛpima nyɛ wusɛ nde: ‹Mi tɛmbiɗya wɛ nda mɛjasi kɛ mɛkandɔ mɛ ɓotu ɓete ɓe yeti kɛ duwɛ Njambiyɛ ɓaka, nɛ́ wɛ joŋgwɛ ɓomɔ kumɔ kɛ njena mɛnɛti.› » ");
INSERT INTO kkj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ ɓo ɓɛ nɛ mɛsosa lɛpɔ nde, mɛlɛpi mɛ Baba Mbokɔ kimɔte ɓuɗyate. Ɓomɔ hɛnɛ te yi Njambiyɛ kpoma nde, ɓo ta ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo ɓaka yeŋsama temɔ tikɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kimɔ Tom Kumande Yesus ka̧ kɛndɔ mbɔmbu kɛ mɛnɛti mɛte hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yasi wɛtɛ, ɛ Ɓeyudɛn ɗesɛ to ɓoma ɓete ɓe ɓa̧ nɛ kusuku ɓe ɗikima ɓeŋgwɛ mɛlɛpi mɛ Njambiyɛ ɓaka nɛ̀ nyaŋgwɛ ɓotu ɓe ɗya suŋgwɛ nɛ Pol ɓenɛ Barnabas. Ɛ ɓo teɗye ɓo mɛbɔnɛ ɗuɗye ɓo kɛ ɗya ɗyan. ");
INSERT INTO kkj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ɛ Pol ɓenɛ Barnabas kutɛ mɛkol man soŋɛ ŋgbutu ɗya te yi teɗye ɓo nde, ɓo yeti nɛ mɛsosa nɛ ɓo na. Ɛ ɓo nje kwa̧ kɛ̀ kɛ Ikɔn. ");
INSERT INTO kkj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yasi wɛtɛ, jɔnja ɓotu ɓete ɓe nja̧ ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Aŋtiyos ɓaka ɓa̧ yan nɛ nyaŋgwɛ mɛsosa. Sendi, Kimɔ Sisiŋ ɓa̧ tondunate kɛ yotu yan. ");
INSERT INTO kkj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol ɓenɛ Barnabas ɗyaŋma kɛ Ikɔn, ɛ mɛyasi kwaŋna nda yi yo kwaŋnama kɛ mɛɗya mɛte yiri kɛ́. Ɛ ɓo hɛnɛ yiɓa nyiŋɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn lɛpina nyɛ ɓomɔ. Ɛ lɛpi yan kelɛ nde, ɓuɗya Ɓeyudɛn nɛ̀ ɓuɗya Ɓegrɛk tîki temɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yasi wɛtɛ, ɛ Ɓeyudɛn ɓete ɓe sɛŋma kinɛ tikɔ temɔ kɛ yi Kumande Yesus ɓaka ɗesɛ to ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka kelɔ nde, ɓo ɓɛ̂ki nɛ ɓeya mɛtakɛ suŋgwɛ nɛ njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Kumande Yesus ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ɗete, ɛ Pol ɓenɛ Barnabas kwaŋɗye ɓuɗya mɛtu kɛ Ikɔn. Ɓo ɗikima lɛpina kinɛ gwe wɔ̧ ɓomɔ na, tikɔ temɔ kɛ yi Kumande Yesus. Kumande Yesus ɗikima nyɛ ɓo ɗeti te yi kelɔ mɛyekambiyɛ nɛ̀ nyaŋgwɛ mɛyasi yí teɗye nde, Kimɔ Tom te yi ɓo lɛpɛ kɛ kasi ŋgikwa nɛ kɛ́, gbakasi. ");
INSERT INTO kkj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ɛ ɓotu ɓe ɗya ɓaka kɛ mɛŋgaɓiyɛ yiɓa, ɓaŋa kɛ kɔŋ Ɓeyudɛn, ɓaŋa kɛ kɔŋ ɓotu ɓe tomun ɓe Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka nɛ̀ Ɓeyudɛn nɛ ŋguru wan ɓenɛ ɓekum ɓan komsama, nɛ́ ɓo kɛ̀ teɗye Pol ɓenɛ Barnabas mɛbɔnɛ, lu̧ ɓo sendi nɛ mɛtari wo. ");
INSERT INTO kkj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kɛ Pol ɓenɛ Barnabas ma wokɔ kasi te kɛ́, ɛ ɓo mbɔmbila kwa̧ kɛ̀ ɗiyɔ kɛ Listɛr nɛ̀ Dɛrbɛ nɛ̀ kɛ pɔku te yite kɛ Likawoni. ");
INSERT INTO kkj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kumɔ mate, ɛ ɓo lɛpɛ Kimɔ Tom nyɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Wɛtɛ mɔ kɔsu ɓa̧ kɛ Listɛr, mɛkol mɛnɛ ma jɛmɛ. Ɓo jama ndi nyɛ ɗete, a tì kɛndɛ ko wɛtɛ yesɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mbam kɔ ɓa̧ kɛ wokɔ yasi te yi Pol ɓa̧ kɛ lɛpɔ kɛ́. Ɛ Pol ɓɛŋɛ nyɛ nɛ ŋgoŋ duwɛ nde, mbam te ɓa̧ kɛ tikɔ temɔ nde, kɔsu nɛ yakama siyɔ. ");
INSERT INTO kkj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ɛ Pol lɛpɛ nɛ mɛn kɛ kwey nyɛ nyɛ nde: «Tɛma, ɗiyɔ kɛ kwey nɛ ŋgbeŋ nɛ mɛkol mɔ.» Ɛ mbam ɗo tɛmɛ kɛndɔ. ");
INSERT INTO kkj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kɛ ŋgil ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ma ɓɛŋɛ yasi te yi Pol kelma kɛ́, ɛ ɓo lɛpɛ nɛ mɛn kɛ kwey nɛ numbu Likawoni nde: «Ɓaŋa ɓenjambiyɛ ma yeŋsa yotu nda ɓomɔ nje nɔ kɛ yusu.» ");
INSERT INTO kkj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓo loma Barnabas nde Seyus,*f1* nje lo Pol nde Hɛrmɛs,*f1* kɛto yo ndi nyɛ ɗikima lɛpina kɛ njoka yan yiɓa. ");
INSERT INTO kkj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mbanjɔ mbaŋa njambiyɛ te yi ɓo jeɓa nde Seyus kɔ ɓa̧ kɛ numbu ɗya. Ɛ mɔ te ɛ ɓa̧ nɛ mɛsay mɛ nyɛna sadaka nyɛ njambiyɛ te kɔ kwa̧ kɛ ɓu̧ ɓembam nday nje nɔ. Ɓo jakima njam mɛjeti lɛnje ɓembam ɓenday ɓete. Ɛ nyɛ ɓu̧ ɓo kɛ̀ nɔ kɛ mɛnumɛy mɛ ndoko te yi litɛ ɗya kɛ́. A kwaɗya wo ɓo kelɔ nɛ sadaka nyɛ Pol ɓenɛ Barnabas. Ŋgil ɓomɔ ɓa̧ sendi nɛ yɛsiɗyɛ kelnate ɗete. ");
INSERT INTO kkj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kɛ Barnabas ɓenɛ Pol te ɓotu ɓe tomun ɓe Yesus ma wokɔ kasi te kɛ́, ɛ ɓo nyalɛ mɛlambɔ kɛ yotu sɛɗyɛ nɛdɔ kɛ̀ kɛ mɔy ŋgil ɓomɔ kembiɗya lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Wunɛ njɔŋ, kɛto ŋge yi wunɛ kelɛ mɛyasi mɛte yinɔri kɛ́? Wusɛ ndi gbɛla ɓomɔ sendi nda wunɛ. Wusɛ njáki nje lɛpɔ Kimɔ Tom Yesus nyɛ wunɛ yí kitɛ wunɛ nde, wunɛ yêŋsaŋgwɛ temɔ tikɔ lem ɓenjambiyɛ ɓete kanɔ Njambiyɛ te ɛ nɛ joŋ kɔ. Yo nyɛ kusɛ ɗyoɓɔ nɛ̀ mɛnɛti nɛ̀ maŋ nɛ̀ mɛyasi hɛnɛ te yi ɗiyɛ kɛ mɔyte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Njombu yaŋa kɛ mɛtu mɛ njimɛ Njambiyɛ te tikima mɛkandɔ mɛ ɓomɔ hɛnɛ nde, ɓo kêl mɛyasi nda yi ɓo kwaɗyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ko ɓɛkɔ ɗete, mɛŋgimɔ hɛnɛ, a tì sɔɗyɛ yotu na. A ka̧ mbɔmbu teɗye gbate nde, a nɛ ŋgikwa, kɛto a kɛ nɔɗyɛ mbiyɔ njesɛ wunɛ wulɛ ɗyoɓɔ, nyɛ wunɛ nyambi yaka nɛ mɛŋgimɔ. A kɛ nyɛ wunɛ nyɛŋgwɛ, tonjɛ mɛsosa kɛ temɔ yun.» ");
INSERT INTO kkj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ko ɓɛkɔ nde, Pol ɓenɛ Barnabas lɛpinama ɗete, ɓo wɔnduma ɓiriki yí petɔ nɛ ɓomɔ nde, ɓo tî kel sadaka nyɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ndana, ɛ Ɓeyudɛn tɛmɛ wulɛ Aŋtiyos nɛ Ikɔn lɛpina nyɛ ŋgil ɓomɔ. Ɛ ɓomɔ yeŋsa ɗiyɔ kɛ kɔŋ yan lu̧ Pol nɛ mɛtari, nɛ́ ɓo wo nyɛ. Kɛ kɔŋte, ɛ ɓo ɗalɛ nyɛ soŋɛ kɛ mɔy ɗya takɛ nde, a ma gwe. ");
INSERT INTO kkj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yasi wɛtɛ, kɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Kumande Yesus Krist ɓaka ma wesiɗya litɔ nyɛ kɛ́, ɛ nyɛ tɛmɛ yɔkwɛ nyiŋɛ sendi kɛ mɔy ɗya. Misi pupɛ ɛ ɓenɛ Barnabas tɛmɛ kwa̧ kɛ̀ kɛ Dɛrbɛ. ");
INSERT INTO kkj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ɓo lɛpima Kimɔ Tom mate kelɔ nde, ɓuɗya ɓomɔ ɓɛ̂ki ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist. Kɛ kɔŋte, ɛ ɓo nje yɔkwɛ nɛ kɔkɔ kɛ̀ kɛ Listɛr nɛ̀ Ikɔn nɛ̀ Aŋtiyos. ");
INSERT INTO kkj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɓo ka̧ mbɔmbu nyɛ ɗeti nyɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka, kitɛ ɓo nde, ɓo kêl tiŋ te yi tikɔ temɔ kɛ yenɛ. Ɓo lɛpima sendi nyɛ ɓo nde: «Yí nyiŋɛ nɔ kɛ *Kandɔ Njambiyɛ, wusɛ ta pa saŋgwa nɛ ɓuɗya mɛbɔnɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ɓo ɗikima nyɛ ɓaŋa ɓomɔ ɗiyɔ ɓetomba mbanjɔ Njambiyɛ kɛ njoka mɛnjɔŋ mɛ ɓomɔ hɛnɛ ɓe tikima temɔ kɛ yi Kumande Yesus ɓaka. Kɛ kɔŋ tɛmbiɗya yan, ɓo ɗikima kiyɔ mɛɗye ŋgwɛta nɛ Njambiyɛ nje diyɛ Kumande mɔ te ɛ ɓotu ɓete tikima temɔ kɛ yenɛ kɔ nde, a ɓâkiɗya ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pol ɓenɛ Barnabas nja̧ kwa̧ nɛ Pisidi kumɔ kɛ Pamfili. ");
INSERT INTO kkj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓo ka̧ mbɔmbu lɛpɔ Kimɔ Tom kɛ Pɛrgɛ nje kwa̧ kumɔ Atali. ");
INSERT INTO kkj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ɓo nja̧ tɛmɛ womɛte nyiŋɛ kuka kɛndɔ kumɔ Aŋtiyos, kɛ mbɛy komɛ ɓomɔ kandima si diyɛ Njambiyɛ kɛto yan nde, a nyɛ̂ki ɓo mɛkombila kɛ mɛsay mɛte yi ɓo siyma si tonjɛ ndana kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kɛ ɓo ma ɗya̧ kɛ Aŋtiyos kɛ́, ɛ ɓo jeɓa njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka, yekiɗye mɛyasi hɛnɛ te yi Njambiyɛ nya ɓo ɗeti nde, ɓo kêl kɛ́. Ɓo yekiɗya sendi nda yi Njambiyɛ ɓutuma nje nyɛ yiŋa mɛkandɔ, nɛ́ ɓo sendi tiki temɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɓo yama mɔnɔ mɛtu womɛte kɛ Aŋtiyos ɓenɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɓaŋa ɓomɔ wulma Yuda kɛ̀ kɛ Aŋtiyos kɛ̀ teɗye yiŋa yasi dɛlɛ nyɛ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka. Ɓo lɛpima nyɛ ɓo nde: «Ŋgɛ wunɛ ti pɛsina ɓeŋgwɛ mboŋga te yi Mɔyisi nya kɛ́, wunɛ ti yaka ɓɛ nɛ joŋgwɛ na.» ");
INSERT INTO kkj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ɛ Pol ɓenɛ Barnabas nyɛ mɛso ɓeyate ɓenɛ ɓo lombiɗya kɛto te. Ɛ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka pɛsɛ nde, nɛ̀ Pol nɛ̀ Barnabas nɛ̀ ɓaŋa ɓenjɔŋ ɓan ta kɛ̀ kɛ Yerusalɛm kɛ̀ ɓɛŋɛ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ, nɛ́ ɓo nɛmbi lɛpi te. ");
INSERT INTO kkj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kɛ kɔŋte, ɛ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka kɛ̀ tikiɗye ɓo kɛ nje, ɛ ɓo kɛ̀ nɛ kɛndi yan mbɔmbu kwa̧ nɛ Fenisi nɛ̀ Samari yekiɗye nda yi ɓotu ɓete ɓe yeti Ɓeyudɛn yeŋsama temɔ kɛ́. Ɛ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus kɛ mɛɗya mɛte ɓaka wokɛ nyaŋgwɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kɛ ɓo ma ɗya̧ kɛ Yerusalɛm kɛ́, ɛ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka nɛ̀ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ ɓu̧ ɓo nɛ mɛsosa. Ɛ ɓo yekiɗye mɛyasi hɛnɛ te yi Njambiyɛ nya ɓo ɗeti nde, ɓo kêl kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ko ɓɛkɔ ɗete, ɛ ɓaŋa ɓomɔ kɛ njoka ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓe ɓa̧ kɛ njɔŋ *Ɓefarisɛ̧ ɓaka tɛmɛ lɛpɔ nde: «Ɓo pɛ̂si ɓotu ɓete ɓe yeti Ɓeyudɛn ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka, lɛpɔ sendi nyɛ ɓo nde, ɓo ɓêŋgwɛ mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ɛ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ nɛmbɛ lɛpi te. ");
INSERT INTO kkj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɛ ɓo lɛpina ɓiye mɛso ɓuɗyate. Kɛ kɔŋte, ɛ Piyɛr tɛmɛ lɛpɔ nyɛ ɓo nde: «Wunɛ njɔŋ, wunɛ duwa̧ nde, Njambiyɛ kikima tɔkɛ mi kɛ njoka yun, nɛ́ mi lɛpi Kimɔ Tom nyɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka, nɛ́ ɓo tiki temɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Njambiyɛ te ɛ duwɛ mɛtemɔ mɛ ɓomɔ kimɔte kɔ teɗya nde, a jayma ɓo, nyɛ ɓo Kimɔ Sisiŋ nda yi nyɛ nya wusɛ sendi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Njambiyɛ tì nɛmbɛ njoka su sinɛ ɓo na. A pupuɗya mɛtemɔ man, kɛto ɓo tikima temɔ kɛ yi Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kɛto ŋge yi wunɛ kwaɗyɛ ɓoɓile Njambiyɛ ndana yí soɓiɗye nyaŋgwɛ mapi nyɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka? Mapi te, sinɛ ɓesaŋmbambɔ ɓusu suɗya yo. ");
INSERT INTO kkj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yasi wɛtɛ, wusɛ kɛ tikɔ temɔ nde, wusɛ ta ɓɛ nɛ joŋgwɛ, kɛto Kumande Yesus nɛ ŋgikwa. Ɓo sendi ta ɓɛ nɛ joŋgwɛ kɛto te.» ");
INSERT INTO kkj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ndana, ɛ ɓomɔ hɛnɛ ɓe wesiɗyama ɓaka ɗiyɛ nɛ sɛm yí wokɔ nda yi Barnabas ɓenɛ Pol ɓa̧ kɛ yekiɗye kasi mɛyekambiyɛ nɛ̀ nyaŋgwɛ mɛyasi hɛnɛ te yi Njambiyɛ nya ɓo ɗeti nde, ɓo kêl kɛ njoka ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kɛ ɓo ma si lɛpina kɛ́, ɛ Jak ɓu̧ lɛpi lɛpɔ nde: «Wunɛ njɔŋ, wunɛ lɛ̂ŋgwɛ mɛtɔ kɛ yasi te yi mi ta lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔn yekiɗya nda yi Njambiyɛ kikima teɗye ŋgikwa nyɛ yiŋa mɛkandɔ yí tɔkɛ ɓaŋa ɓomɔ kɛ njoka yan ɓe ta ɓɛ ɓotu ɓenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mɛkele mɛte kɛ yaka nɛ mɛlɛpi mɛte yi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ lɛpima kɛ́. Kɛto yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ");
INSERT INTO kkj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Baba Mbokɔ kɛ lɛpɔ nde: Kɛ kɔŋte, mi ta yɔkwɛ nɛ kɔkɔ nje. Mi ta tɛmbiɗye mɔy tu̧ Davit yi ma ɓalɔ kɛ́. Mi ta tɛmbiɗye ɓɔru yasi te. ");
INSERT INTO kkj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ɗete, ɓukwɛ ɓomɔ te ɓaka hɛnɛ nɛ̀ mɛkandɔ hɛnɛ te yi mi kwaɗyɛ nde, ɓo ɓɛ̂ki ɓotu ɓembɛ ɓaka ta sa̧ nje Baba Mbokɔ. ");
INSERT INTO kkj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Baba Mbokɔ te ɛ kikima teɗye mɛyasi mɛte kɔ lɛpɛ ɗete.› ");
INSERT INTO kkj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Kɛ yembɛ, mi kɛ kombile ɓɛŋɛ nde, wusɛ tî njaŋgwɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓe yeŋsa temɔ tikɔ kɛ yi Njambiyɛ ɓaka na. ");
INSERT INTO kkj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yasi wɛtɛ, wusɛ kɛ̂ti mɛkana kɛnjɛ ɓo nde, ɓo tî ɓoɓa ɗye mɛnjay mɛte yi ɓo kelma nɛ sadaka nyɛ ɓaŋa ɓenjambiyɛ na, kɛto yo kɛ kelɔ nde, mumɔ ɓɛ̂ki nɛ sɛmbɔ. Ɗiyɔ mbam ɓenɛ nyari tî ɓɛŋnaŋgwɛ kinɛ nde, ɓo ɓɛ̂ki kɛ gwaki na. Ɓo tî ɗyaki nyamɔ te ɛ gwe gbɔŋgi ho ɗye mɛkiyɔ mɛ nyamɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kɛto kandɛ nɛ ɓetomba kɛ mɛɗya hɛnɛ ɓomɔ kɛ pelɛ yo wulɛ kɛ mɛkana mɛ mɛmboŋga mɛte yi Mɔyisi kɛtima kɛ́. Ɓo kɛ tɔlɔ sendi yo yesɔ *Saba hɛnɛ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn.» ");
INSERT INTO kkj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ndana, ɛ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ nɛ̀ njɔŋ ɓotu te ɓe tikima temɔ kɛ yi Kumande Yesus ɓaka ɓɛŋɛ kimɔte yí tɔkɛ ɓaŋa ɓomɔ kɛ njoka yan, tomɔ ɓo ɓenɛ ɓe Pol nɛ Barnabas kɛnjɛ Aŋtiyos. Ɓo tɔkuma Yude te yi ɓo jeɓa nde Barsabas kɔ, tɔkɛ sendi Silas. Ɓo hɛnɛ yiɓa ɓa̧ nda ɓetokondo kɛ njoka te ɓari. ");
INSERT INTO kkj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɛ ɓo ɓu̧ mɛkana nyɛ ɓo. Ɓo kɛtima kɛ mɔy mɛkana mɛte nde: ‹Wunɛ ɓemaŋ ɓusu ɓe yiŋa mɛkandɔ ɓe ɗiyɛ kɛ Aŋtiyos, kɛ Siri nɛ̀ kɛ Silisi ɓaka, wusɛ ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ nɛ̀ ɓemaŋ ɓusu, wusɛ kɛ nyɛnɔ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wusɛ wokuma nde, ɓaŋa ɓomɔ kɛ njoka su tɛmma woŋga kɛ̀ njaŋgwɛ wunɛ nɛ mɛlɛpi man, kelɔ nde, temɔ yun kûɗyukwɛ. Wusɛ tì lɛpɛ yiŋa yaŋa ɗete nyɛ ɓo na. ");
INSERT INTO kkj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Wusɛ hɛnɛ ɓa̧ ŋgiŋ wɛtɛ, ɛ wusɛ ɓɛŋɛ kimɔte yí tɔkɛ ɓaŋa ɓomɔ kɛ njoka su, tomɔ ɓo kɛnjɛ wunɛ ɓenɛ ɓenjɔŋ ɓusu Pol nɛ̀ Barnabas, sɔŋ temɔ su. ");
INSERT INTO kkj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ɓomɔ ɓaka yiɓa ɓa̧ nɛdɔ te yi ɗyaŋgwɛ joŋgwɛ ɗyan kɛto ɗinɔ Kumande wusu Yesus Krist. ");
INSERT INTO kkj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yo ɗete yi wusɛ kɛ tomɔ Yude ɓenɛ Silas, nɛ́ ɓo kɛ̀ lɛpi kiya mɛlɛpi mɛte nɛ numbu yan nyɛ wunɛ. ");
INSERT INTO kkj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kɛto Kimɔ Sisiŋ nɛ̀ wusɛ sendi ɓɛŋma nde, yo yeti kimɔte nde, wusɛ sôɓiɗya wunɛ yiŋa ɗitina mɛmapi te yi tí kamɛ wunɛ kɛ́ na. Yasi wɛtɛ, wunɛ ɓâkiɗya ndi nde, ");
INSERT INTO kkj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","wunɛ tî ɓoɓa ɗye mɛnjay mɛte yi ɓo kelma nɛ sadaka nyɛ ɓaŋa ɓenjambiyɛ kɛ́ na. Wunɛ tî ɗyaki mɛkiyɔ mɛ nyamɔ ho ɗye nyamɔ te ɛ gwe gbɔŋgi kɔ na. Ɗiyɔ mbam ɓenɛ nyari tî ɓɛŋnaŋgwɛ kinɛ nde, ɓo ɓɛ̂ki kɛ gwaki na. Yo kimɔte nde, wunɛ tî kel mɛyasi mɛte na. Hɛ saŋgwa!› ");
INSERT INTO kkj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ndana, ɛ ɓotu ɓete yi ɓo tɔkuma ɓaka jana nɛ njɔŋ ɓotu ɓete ɓe ma tikɔ temɔ kɛ yi Kumande Yesus ɓaka tɔkɛ kɛndi kɛ̀ Aŋtiyos. Kumɔ mate, ɛ ɓo wesiɗye ɓomɔ nyɛ ɓo mɛkana. ");
INSERT INTO kkj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kɛ ɓo ma si tɔlɔ mɛkana mɛte kɛ́, ɛ ɓomɔ ɓɛ nɛ mɛsosa kɛto kimɔ mɛlɛpi mɛte yi ɓo lɛpima nyɛ ɓo kɛ mɔyte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yude ɓenɛ Silas ɓa̧ sendi ɓotu ɓe punja mɛlɛpi mɛ Njambiyɛ. Ɛ ɓo lɛpina ɓuɗyate kitɛ ɓo nyɛ ɓo ɗeti. ");
INSERT INTO kkj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓo yama mɔnɔ mɛtu mate, ɛ ɓenjɔŋ ɓan ɓe mate jana nɛ ɓo lɛpɔ nde, ɓo kɛ̂n nɛ tɛ. Ɛ ɓo yɔkwɛ suŋgwɛ ɓotu ɓete ɓe tomma ɓo ɓaka.  ");
INSERT INTO kkj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Yasi wɛtɛ, ɛ Silas pɛsɛ nde, a ta tika nɛ mate. ");
INSERT INTO kkj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ɛ Pol ɓenɛ Barnabas tika kɛ Aŋtiyos. Ɓo ɗikima teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ, lɛpɔ sendi Kimɔ Tom Kumande Yesus ɓenɛ ɓaŋa ɓuɗya ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mɔnɔ mɛtu kwaŋma kɛ kɔŋte, ɛ Pol lɛpɛ nyɛ Barnabas nde: «Wusɛ yɔ̂kwɛ nɛ kɔkɔ kɛ̀ ɓɛŋɛ joŋgwɛ ɓenjɔŋ ɓusu kɛ mɛɗya hɛnɛ te yi wusɛ lɛpima Kimɔ Tom Kumande Yesus kɛte kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas kwaɗya nde, ɓo ɓôŋ Jaŋ te yi ɓo jeɓa sendi nde Mark kɔ kɛ̀ nɔ. ");
INSERT INTO kkj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Yasi wɛtɛ, Pol tì jayɛ nde, ɓenɛ ɓo kɛ̂n na, kɛto Jaŋ ma léŋ ɓo kɛ mɛnɛti mɛ Pamfili kinɛ kɛ̀ kamɛ ɓo kɛ mɛsay man na. ");
INSERT INTO kkj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yo nja̧ kwa̧ nɛ nyaŋgwɛ mɛlombɔ, ɛ ɓo ɓaka. Ɛ Barnabas ɓu̧ Mark nyiŋɛ nɛ kuka kwa̧ kɛ̀ Siprɛ. ");
INSERT INTO kkj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ɛ Pol tɔkɛ nɛ Silas. Kɛ ɓenjɔŋ ɓan ma si diyɛ Kumande Yesus nde, a nyɛ̂ki Pol mɛkombila kɛ́, ɛ nyɛ kwa̧ ɓenɛ Silas. ");
INSERT INTO kkj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɓo kwaŋma nɛ Siri, kwa̧ sendi nɛ Silisi yí nyɛ ɗeti nyɛ njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol nja̧ kwa̧ sendi kɛ̀ kɛ Dɛrbɛ toŋgiɗya kumɔ Listɛr. Wɛtɛ mɔ te ɛ ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɔ ɓa̧ mate, ɗinɔ ɗyenɛ nde Timɔte. Nyaŋgwɛ wenɛ ɓa̧ ŋgɔndu Ɓeyudɛn, a ɓa̧ kɛ ɓeŋgwɛ Kimɔ Tom Yesus. Saŋgwɛ wenɛ ɓa̧ mɔ Ɓegrɛk. ");
INSERT INTO kkj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist kɛ Listɛr nɛ̀ kɛ Ikɔn ɓaka ɓa̧ kɛ jayɛ joŋgwɛ Timɔte. ");
INSERT INTO kkj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol kwaɗya kwa̧ ɓenɛ nyɛ, ɗete ɛ nyɛ ɓu̧ nyɛ pɛsɔ, kɛto Ɓeyudɛn ɓete ɓe ɓa̧ kɛ pɔku te yite ɓaka duwa̧ hɛnɛ nde, saŋgwɛ nɛ Timɔte ɓa̧ mɔ Ɓegrɛk. ");
INSERT INTO kkj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kɛ mɛɗya mɛte yi ɓo kwaŋma kɛte kɛ́, ɓo ɗikima pelɛ nyɛ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka nde, ɓo ɓâkiɗya mɛmboŋga mɛte yi ɓotu ɓe tomun ɓe Yesus nɛ̀ ɓetomba mbanjɔ Njambiyɛ ɓe ɗiyɛ kɛ Yerusalɛm nya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ndana mɛnjɔŋ mɛ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka ɓa̧ kɛ tikɔ temɔ nɛ ŋgbik kɛ yenɛ. Ɓomɔ ɓa̧ kɛ ɓuyɔ mɛtu hɛnɛ kɛ njɔŋ yan. ");
INSERT INTO kkj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ɓo nja̧ kwa̧ nɛ Friji, kwa̧ sendi nɛ Galasi, kɛto Kimɔ Sisiŋ teɗya ɓo nde, ɓo tî lɛpi Kimɔ Tom kɛ Asi na. ");
INSERT INTO kkj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kɛ ɓo ma kumɔ kɛ kɛki Misi kɛ́, ɛ ɓo diy kɛ̀ kɛ Bitini. Yasi wɛtɛ, ɛ Sisiŋ Yesus sɛŋɛ nde, ɓo tî kɛn na. ");
INSERT INTO kkj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ɗete, ɛ ɓo nje kwa̧ nɛ Misi kumɔ kɛ Turuwas. ");
INSERT INTO kkj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nɛ tu ɛ Pol ɓɛŋɛ nda nyɛnɔ nde, wɛtɛ mɔ Maseduwan punduma kɛ to nɛ ŋgwɛta nɛ nyɛ lɛpɔ nde: «Inja kɛ Maseduwan nje kamɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kɛ kɔŋ nyɛnɔ Pol yinɔri, ɛ wusɛ*f1* sa̧ nje te yi kɛ̀ nɛdɔ kɛ Maseduwan, kɛto wusɛ duwa̧ nde, yo Njambiyɛ jeɓa wusɛ nde, wusɛ kɛ̂n lɛpɔ Kimɔ Tom mate. ");
INSERT INTO kkj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ɗete, ɛ wusɛ nyiŋɛ kuka kɛ Turuwas ɓu̧ nje nɛ ŋgbeŋ yí kɛ̀ kɛ Samɔtras. Misi pupɛ ɛ wusɛ kumɛ kɛ Neyapolis. ");
INSERT INTO kkj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kɛ kɔŋte, ɛ wusɛ nje kwa̧ mate kumɔ kɛ wɛtɛ ɗya nde Filipi. Mɛɗya hɛnɛ kɛ mɛnɛti mɛ Maseduwan wókunaŋgwɛ nɛ Filipi. Ɓotu ɓe ɗya te wúla Rom nje nɔ. Wusɛ yama mɔnɔ mɛtu womɛte. ");
INSERT INTO kkj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kɛ yesɔ *Saba ma ɗya̧, ɛ wusɛ ɗuwɛ kɛ mɔy ɗya kɛ̀ kɛ goŋ wɛtɛ ɗuku, kɛto wusɛ ɓa̧ kɛ takɛ nde, yiŋa mbɛy komɛ ɓomɔ ɗiki ŋgwɛta nɛ Njambiyɛ kɛ́ yâkaŋgwɛ ɓɛ mate. Kumɔ mate, ɛ wusɛ kwa̧ ɗiyɔ mɛtiɗyɛ. Ɛ wusɛ lɛpina nyɛ ɓoma ɓete ɓe wesiɗyama womɛte ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wɛtɛ nyari nde Lidiya, ŋgɔndu Tiyatir ɓa̧ kɛ njokate. A ɓa̧ mɔ ɗyaŋgwa kpasa to tena mɛlambɔ. A ɗikima kanɔ sendi Njambiyɛ. A ɗikima lɛŋgwɛ tɔ kɛ lɛpi te yi wusɛ ɓa̧ kɛ lɛpɔ kɛ́. Baba Mbokɔ kelma mɛsay kɛ temɔ nɛ, na woku yasi te yi Pol ɗikima lɛpɔ kɛ́ kimɔte. ");
INSERT INTO kkj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wusɛ tɔpuma nyɛ kɛ mɔrɔku ɓenɛ ɓotu ɓe tu̧ ɗyenɛ. Kɛ kɔŋte, ɛ nyɛ ŋgwɛta nɛ wusɛ lɛpɔ nde: «Ŋgɛ ɓɛ nde, wunɛ ɓɛŋma gbate nde, mi kɛ tikɔ temɔ kɛ yi Kumande Yesus, wunɛ nyîŋa tu̧ ɗyembɛ ɗiyɔ te.» Ɛ nyɛ jeliyɛ wusɛ nde, wusɛ jâya. ");
INSERT INTO kkj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wɛtɛ yesɔ wusɛ ɓa̧ kɛ kɛ̀ kɛ mbɛy komɛ ɓomɔ ɗikima wesiɗya ŋgwɛta nɛ Njambiyɛ kɛ́. Ɛ wusɛ saŋgwa nɛ wɛtɛ nyari kɛ nje. Nya te ɓa̧ bala. A ɓa̧ nɛ wɛtɛ ɓeya sisiŋ kɛ yotu yi ɗikima teɗye nyɛ mɛyasi mɛte yi ta kwaŋna kɛ́. Ɗete, ɓotu ɓete ɓe ɗikima ɗiyɔ nɛ nyɛ ɓaka ɗikima sɔmbɔ ɓuɗya mɔni. ");
INSERT INTO kkj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nya kɔ kandima ɓeŋgwa su sinɛ ɓe Pol ɗiki lɛpɔ nɛ mɛn kɛ kwey nde: «Ɓotu ɓaka, yo ɓotu ɓe mɛsay ɓe Njambiyɛ te ɛ kwaŋma mɛyasi hɛnɛ kɛ kwey kɔ. Ɓo kɛ teɗye wunɛ nje te yi Njambiyɛ yakama joŋgwɛ nɛ wunɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A kelma ɗete ɓuɗya mɛtu. Ɛ Pol wokɛ ŋgambi ɓuɗyate. Ɛ nyɛ yeŋsa ɓɛŋɛ njimɛ lɛpɔ nyɛ ɓeya sisiŋ te nde: «Nɛ ɗinɔ Yesus Krist, mi kɛ lɛpɔ nyɛ wɛ nde: Pundɔ ɗuwɛ kɛ yotu nya kɔ.» Ɛ ɓeya sisiŋ pundɛ kɛ yotu nɛ ndi kɛ kiya ŋgimɔ te. ");
INSERT INTO kkj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kɛ ɓotu ɓete ɓe ɓa̧ nɛ nya kɔ ma ɓɛŋɛ nde, ɓiɓina temɔ te yi ɓo ɓa̧ nɔ kɛ nje sɔmbuna mɔni yan ma ɗiɓina kɛ́, ɛ ɓo ɓiye Pol ɓenɛ Silas kpatile ɓo kumɔ nɔ kɛ ɓembe sɛ̧ kɛ misi mɛ ɓekum. ");
INSERT INTO kkj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɛ ɓo ɓu̧ ɓo kɛ̀ nɔ kɛ yi ɓotu ɓe pɛsina mɛlɛpi lɛpɔ nde: «Ɓotu ɓaka Ɓeyudɛn, ɓo kɛ potɔ ɗya ɗyusu. ");
INSERT INTO kkj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɓo kɛ teɗye sendi mɛkele mɛte yi mɛmboŋga musu kiɗyɛ kɛ́. Wusɛ yeti nɛ ɗeti te yi jayɛ yo ho ɓeŋgwɛ yo na, kɛto wusɛ su ɓotu ɓe Rom.» ");
INSERT INTO kkj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ɛ ŋgil ɓotu ɓete ɓe wesiɗyama womɛte ɓaka nje yeŋsa lu̧ ɗyambi nɛ Pol ɓenɛ Silas. Ɛ ɓotu ɓe pɛsina mɛlɛpi lɛpɛ nde, ɓo sîki sɔrɛ mɛkandɔ kɛ yotu yan, nyɛ sendi ɓomɔ ɗeti nde, ɓo njûru ɓo nɛ njambala. ");
INSERT INTO kkj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kɛ ɓo ma si njurɔ ɓo ɓuɗyate ɗete kɛ́, ɛ ɓo nje ɓu̧ ɓo kɛnjɛ kɛ tu̧ jɔɓɔ. Ɛ ɓo lɛpɛ nyɛ mɔ ɓakiɗya ɓejɔɓɔ nde, a pɛ̂m ɓo kimɔte. ");
INSERT INTO kkj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kɛ mɔ ɓakiɗya ɓejɔɓɔ ma wokɔ ɗete kɛ́, ɛ nyɛ ɓu̧ ɓo kɛ̀ ɗiɓɔ kɛ wɛtɛ mɔnɔ toŋgari kɛ njena tu̧ jɔɓɔ nyɛ mɛpoka kɛ mɛkol man. ");
INSERT INTO kkj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yi kɛ̀ nɔ ɓembe tu Pol ɓenɛ Silas ɗikima ŋgwɛta nɛ Njambiyɛ jembina yí lukse nɛ nyɛ. Ɓotu ɓe jɔɓɔ te ɓari ɗikima lɛŋgwɛ mɛtɔ wokɔ. ");
INSERT INTO kkj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Semɔ semɔ, ɛ mɛnɛti ŋgwaŋgwa ɓuɗyate. Ɛ tu̧ jɔɓɔ ŋgbɔkisa nɛ dimbi kumɔ nji̧. Ɛ mɛnumɛy mɛ tu̧ jɔɓɔ hɛnɛ si ɓutuna ndi ŋga wɛtɛ. Ɛ mɛyasi mɛte yi ɓo wotuma nɛ ɓejɔɓɔ hɛnɛ kɛ́ si pamiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kɛ mɔ ɓakiɗya ɓejɔɓɔ ma jemiyɛ ɓɛŋɛ mɛnumɛy nyasɛ kɛ́, ɛ nyɛ sutɛ kafa nɛ, na wo nɛ yotu nɛ, kɛto a takima nde, ɓejɔɓɔ ma ɓɔmbɔ. ");
INSERT INTO kkj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yasi wɛtɛ, ɛ Pol lɛpɛ nɛ mɛn kɛ kwey nde: «Wɛ tî woku yotu na, wusɛ hɛnɛ waka.» ");
INSERT INTO kkj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ɛ mɔ ɓakiɗya ɓejɔɓɔ diyɛ ɗitɛ, ɛ nyɛ nyiŋɛ ɓekɛ ɓekɛ kɛ mɔy tu̧ ɓalɔ nɛ mɛŋgwaŋgwa kɛ mɛkol mɛ Pol ɓenɛ Silas. ");
INSERT INTO kkj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ɛ nyɛ ɓu̧ ɓo kɛ̀ nɔ sɛ̧ diyɛ ɓo nde: «Wunɛ ɓebaba, mi kêl nan, nɛ́ mi ɓɛ nɛ joŋgwɛ te yi kpo nɛ kpo?» ");
INSERT INTO kkj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɛ ɓo yeŋsa nde: «Tikɔ temɔ kɛ yi Kumande Yesus, ɗete wɛ ta ɓɛ nɛ joŋgwɛ kandɛ wɛ nɛ ŋguru wɔ kumɔ ɓotu ɓe tu̧ ɗyɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɛ ɓo lɛpɛ kasi Kumande Yesus nyɛ nyɛ ɓenɛ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ mɔy tu̧ ɗyenɛ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ɛ nyɛ ɓu̧ ɓo weyɛ mɛpeŋ man ndi kɛ kiya ŋgimɔ te nɛ tu. Ndana ndana, ɛ ɓo tɔpɛ mɔ ɓakiɗya ɓejɔɓɔ kɔ ɓenɛ ɓotu ɓe tu̧ ɗyenɛ hɛnɛ kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kɛ kɔŋte, ɛ nyɛ ɓu̧ Pol ɓenɛ Silas kɛ̀ nɔ kɛ tu̧ ɗyenɛ kɛ̀ nyɛ ɓo mɛɗye. A ɓa̧ nɛ mɛsosa ɓuɗyate ɓenɛ ɓotu ɓe tu̧ ɗyenɛ hɛnɛ, kɛto a tikima temɔ kɛ yi Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kɛ misi ma pupɔ kɛ́, ɛ ɓotu ɓe pɛsina mɛlɛpi tomɛ ɓotu ɓe mɛsay ɓan lɛpɔ kɛnjɛ mɔ ɓakiɗya ɓejɔɓɔ nde, a sôŋa ɓɔ nɛ Pol ɓenɛ Silas. ");
INSERT INTO kkj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ɛ nyɛ nje lɛpɔ tom te nyɛ Pol nde: «Ɓotu ɓe pɛsina mɛlɛpi njesa mɛn nde, mi sôŋa ɓɔ nɛ wunɛ. Ɗete, ndana wunɛ pûndu kwa̧ nɛ tɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yasi wɛtɛ, ɛ Pol lɛpɛ nyɛ ɓotu ɓe tomun ɓete nde: «Wusɛ mɛ nɛ ɗiyɔ ɓotu ɓe Rom, ko ɓɛkɔ ɗete, ɓo nya ɗeti nde, ɓo njûru wusɛ nɛ njambala kɛ misi mɛ ɓomɔ kinɛ pa duwɛ to lɛpi na, kwaŋɗye wusɛ kɛnjɛ kɛ jɔɓɔ. Ndana ɓo kɛ kwaɗyɛ punjɛ wusɛ kɛ sɔ. Ko yaŋa tí kelna ɗete na. Ɓo nɛ ŋguru wan njâki soŋɛ ɓɔ nɛ wusɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɓotu ɓete yi ɓo tomma ɓaka yɔkwa̧ kɛ̀ lɛpɔ ɗete nyɛ ɓotu ɓe pɛsina mɛlɛpi. Kɛ ɓo ma wokɔ nde, Pol ɓenɛ Silas mɛ nɛ ɗiyɔ ɓotu ɓe Rom kɛ́, ɛ ɓo gwe wɔ̧ ɓuɗyate, ");
INSERT INTO kkj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ɛ ɓo tɛmɛ kɛ̀ ŋgwɛta nɛ ɓo. Ɛ ɓo punjɛ ɓo soŋɛ ɓɔ nɛ ɓo, ŋgwɛta sendi nɛ ɓo nde, ɓo kwâŋ jisɛ kɛ mɔy ɗya. ");
INSERT INTO kkj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kɛ Pol ɓenɛ Silas ma pundɔ kɛ tu̧ jɔɓɔ kɛ́, ɛ ɓo kwa̧ kɛ̀ kɛ yi Lidiya. Ɓo ɓɛŋma ɓenjɔŋ ɓan mate. Ɛ Pol ɓenɛ Silas kitɛ ɓo. Kɛ kɔŋte, ɛ ɓo nje kwa̧. ");
INSERT INTO kkj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol ɓenɛ Silas kwaŋma nɛ Aŋfipolis, kwa̧ sendi nɛ Apoloni nje kumɔ kɛ Tesalonik. Ɓeyudɛn ɓa̧ nɛ mbanjɔ mɛwesiɗya mate. ");
INSERT INTO kkj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ɛ Pol nyiŋɛ kɛ mbanjɔ mɛwesiɗya kɛ mɛyesɔ mɛ *Saba yitati nda yi nyɛ ɗikima kelɔ kɛ́. Ɓenɛ ɓomɔ lɛpinama kɛ mɛyasi mɛte yi yo kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́, ");
INSERT INTO kkj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nɛmbɛ teɗye nyɛ ɓo nde, yo ɓa̧ ndi nde, *Krist yâkaŋgwɛ saŋgwa nɛ mɛbɔnɛ gwe nje womiyɛ kɛ njoka ɓemuŋ. Ɛ nyɛ kɛ̀ mbɔmbu lɛpɔ nyɛ ɓo nde: «Yesus te yi mi lɛpɛ kasi nɛ nyɛ wunɛ kɔ nyɛ Krist.» ");
INSERT INTO kkj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ɓaŋa ɓomɔ kɛ njoka te yeŋsama temɔ jayɛ yasi te yi Pol lɛpima kɛ́, ɛ ɓo nyiŋɛ kɛ njɔŋ nɛ ɓenɛ Silas. Ɓegrɛk ɓuɗyate ɓe ɗikima kanɔ Njambiyɛ ɓaka nɛ̀ ɓuɗya kpasa ɓoma kelma sendi ɗete. ");
INSERT INTO kkj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yasi wɛtɛ, ɛ Ɓeyudɛn kelɛ ɓeya temɔ, ɛ ɓo jeɓa ɓaŋa ɓotu ɓe ɓeya to ɓe ɓa̧ kɛ wowɔ kinɛ misi mɛsay ɓaka, wesiɗye ɓo kandɛ njaŋgwa yasi kɛ mɔy ɗya. Ɛ ɓo ɗya̧ nɛ tululu kɛ tu̧ Jasɔn, sa̧ Pol ɓenɛ Silas, nɛ́ ɓo ɓu̧ ɓo kɛ̀ nɔ kɛ mbɔmbu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nda ɓo tì dolɛ ɓo kɛ́, ɛ ɓo nje kpatile Jasɔn ɓenɛ ɓaŋa ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka kɛ̀ nɔ kɛ mbɔmbu nyaŋgwɛ ɓomɔ ɓe ɗya lɛpɔ nɛ mɛn kɛ kwey nde: «Ɓotu ɓaka ma si potɔ mbokɔ kɛ hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ɓo ɗyaŋma sendi waka, ɛ Jasɔn jayɛ nde, ɓo ɗîy kɛ tu̧ ɗyenɛ. Ɓomɔ ɓaka hɛnɛ yeti kɛ ɓeŋgwɛ mɛmboŋga mɛ *Sesar na, ɓo kpál lɛpɔ yan nde, wɛtɛ kumande kɛte nde Yesus.» ");
INSERT INTO kkj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kɛ nyaŋgwɛ ɓomɔ ɓe ɗya nɛ̀ ŋgil hɛnɛ ma wokɔ ɗete kɛ́, ɛ ɓoku nyiŋɛ to yan. ");
INSERT INTO kkj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasɔn ɓenɛ ɓotu te ɓari ɓe tikima temɔ kɛ yi Yesus Krist ɓaka paŋma pa nyɛ mɔni yí gbo nɛ lɛpi, ɛ ɓo nje soŋɛ ɓɔ nɛ ɓo yɛy. ");
INSERT INTO kkj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kɛ tu ma ɗya̧ kɛ́, ɛ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka kwaŋɗye Pol ɓenɛ Silas ɓekɛ ɓekɛ kɛnjɛ Bere. Kɛ ɓo ma kumɔ mate kɛ́, ɛ ɓo kwa̧ nyiŋɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ɓeyudɛn te ɓe Bere ɓa̧ nɛ kimɔ temɔ kwa̧ ɓe Tesalonik. Ɓo wokuma jayɛ Kimɔ Tom nɛdɔ nɛ temɔ yan hɛnɛ. Ɓo ɗikima nɛmbɛ yasi te yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́ mɛtu hɛnɛ yí ɓɛŋɛ, simande mɛlɛpi mɛte yi ɓo ɗikima lɛpɔ nyɛ ɓo kɛ́ ɓa̧ nɛ ŋgbeŋ. ");
INSERT INTO kkj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɓomɔ ɓuɗyate kɛ njoka yan tikima temɔ kɛ yi Kumande Yesus. Kɛ njoka Ɓegrɛk sendi, ɓaŋa ɓuɗya kpasa ɓoma nɛ̀ ɓuɗya ɓembam kelma sendi ɗete. ");
INSERT INTO kkj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yasi wɛtɛ, kɛ Ɓeyudɛn te ɓe Tesalonik ma wokɔ nde, Pol kɛ lɛpɔ sendi mɛlɛpi mɛ Njambiyɛ kɛ Bere kɛ́, ɛ ɓo nje njaŋgwɛ yasi ɗesɛ to ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ɗete, ɛ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka kwaŋɗye Pol nɛdɔ kɛnjɛ pulɔ maŋ. Silas ɓenɛ Timɔte nja̧ tika yan kɛ Bere mate. ");
INSERT INTO kkj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓotu ɓete ɓe ka̧ tikiɗye Pol ɓaka ɓoŋma nyɛ kumɔ nɔ kɛ Atɛn. Ɛ ɓo nje yɔkwɛ nɛ kɔkɔ kɛ̀ Bere nɛ tomun te yi Pol kɛnja Silas ɓenɛ Timɔte nde, ɓo kɛ̂n dolɔ nyɛ nɛdɔ. ");
INSERT INTO kkj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kɛ ŋgimɔ te yi Pol ɓa̧ kɛ Atɛn kɛ laɗya Silas ɓenɛ Timɔte kɛ́, temɔ nɛ tì ɓɛ nɛ tɛ na, kɛto ɗya te ɓa̧ tondunate nɛ ŋgbɛŋ nɛ ɓaŋa ɓenjambiyɛ ɓete yi ɓo tuyma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɗete, ɛ Pol ɗiki lɛpina kɛ mbanjɔ mɛwesiɗya ɓenɛ Ɓeyudɛn nɛ̀ ɓotu ɓete ɓe ɓa̧ kanɔ Njambiyɛ ɓaka. A ɗikima lɛpina sendi mɛtu hɛnɛ ɓenɛ ɓotu ɓete ɓe nyɛ ɗikima saŋgwa ɓenɛ ɓo kɛ babal ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ɓaŋa nyaŋgwɛ ɓotu ɓe duwa̧ mɛyasi ɓe ɓa̧ kɛ njɔŋ ɓaŋa ɓomɔ nde Ɓepikuri nɛ̀ kɛ njɔŋ ɓaŋa nde Ɓestoyisiyɛ̧ ɓaka nja̧ lɛpina sendi ɓenɛ ɓe Pol. Ɛ ɓaŋa kɛ njoka yan lɛpɛ nde: «Ɓuɗya ndambu ndambu lɛpi te yi mbam kɔ lɛpɛ kɛ́, to te nɛ ŋge?» Kɛ ɓaŋa ma wokɔ nda Pol ɓa̧ kɛ lɛpɔ kasi Yesus, lɛpɔ sendi nde, ɓemuŋ ta womiyɛ kɛ́, ɛ ɓo lɛpɛ nde: «Ɗekɛ nda a kɛ lɛpɔ kasi ɓaŋa ɓenjambiyɛ dɛlɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ndana, ɛ ɓo ɓu̧ nyɛ kɛ̀ nɔ kɛ wɛtɛ mbɛy nde Aropagi kɛ mbɔmbu ɓetomba ɓe ɗya. Ɛ ɓo lɛpɛ nyɛ nyɛ nde: «Wusɛ kɛ kwaɗyɛ duwɛ jɔnja teɗya yasi te yi wɛ teɗye ɓomɔ ndana kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kɛto mɛyasi mɛte yi wɛ lɛpɛ kɛ́, wusɛ kɛte nda tu. Wusɛ kɛ kwaɗyɛ ɓiye to te.» ");
INSERT INTO kkj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ŋgbak ŋgbak ɓomɔ ɓe Atɛn nɛ̀ ɓejɛŋgwɛ ɓete ɓe ɗikima ɗiyɔ kɛ Atɛn ɓaka ɗikima kwaŋɗye ndi ŋgimɔ yan kɛ lɛpina jɔnja mɛyasi nɛ̀ kɛ wokuna jɔnja mɛtom. ");
INSERT INTO kkj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ndana, ɛ Pol tɛmɛ kɛ mbɔmbu ɓetomba ɓe ɗya lɛpɔ nde: «Wunɛ ɓotu ɓe Atɛn, kɛ mɛyasi hɛnɛ mi kɛ ɓɛŋɛ nde, wunɛ nya temɔ yun hɛnɛ kɛ kanna mɛyasi. ");
INSERT INTO kkj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kɛto kɛ mi ma kɛndɔ kɛ ɗya ɗyun seŋgile mɛmbɛy nɛ̀ mɛyasi mɛte yi wunɛ kanɛ kɛ́, ɛ mi ɓɛŋɛ wɛtɛ mbɛy nyɛna sadaka, ɓo kɛtima kɛte nde: ‹Mbɛy te yikɛ, yo yi njambiyɛ te yi ɓomɔ tì pa duwɛ kɔ.› Njambiyɛ te yi wunɛ kanɛ kinɛ duwɛ nyɛ kɔ, yo Njambiyɛ te ɛte yi mi lɛpɛ kasi nɛ ndana nyɛ wunɛ kɔ. ");
INSERT INTO kkj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yo Njambiyɛ te kusɛ mbokɔ nɛ̀ mɛyasi hɛnɛ te yi ɗiyɛ kɛte kɛ́. Nyɛ Kumande te ɛ namɛ ɗyoɓɔ nɛ̀ mɛnɛti. A ti jóŋnaŋgwɛ kɛ mɛmbanjɔ mɛte yi ɓomɔ sumɛ nɛ ɓɔ kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sendi, kinɛ yiŋa yaŋa te yi ɓomɔ yakama kelɔ nyɛ nyɛ na, kɛto kinɛ yiŋa yaŋa mbɛt nɛ mbɛt kɛ ɓanɔ nyɛ na. Yo nyɛ kelɛ nde, ɓomɔ hɛnɛ ɓɛ̂ki nɛ joŋ. Yo nyɛ nyɛ ɓo sosu, nyɛ ɓo mɛyasi hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A kusuma mɛkandɔ mɛ ɓomɔ hɛnɛ wulɛ ndi kɛ mumɔ wɛtɛ, nyɛ ɓo mbɛy kɛ to mɛnɛti maka hɛnɛ. A nya mɛŋgimɔ nyɛ ɓo, nyɛ sendi ɓo njena mɛ mɛnɛti mɛte yi ɓo ta ɗiyɔ kɛte. ");
INSERT INTO kkj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Njambiyɛ kelma ɗete, nɛ́ ɓomɔ sa̧ nyɛ, nɛ́ ɓo ɓoɓile ɗete, ta ɓɛ yari, ɓo ta duwɛ nyɛ. Ko ɗete, a kɛ kɛki mumɔ hɛnɛ, ");
INSERT INTO kkj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kɛto yo nyɛ kelɛ nde, wusɛ ɓɛ̂ki nɛ joŋ, wusɛ kɛ̂ndi, ɓɛ ɓomɔ. Ɓaŋa ɓomɔ ɓe kɛtɛ mɛkana kɛ njoka yun ɓaka ɗikima lɛpɔ nde: ‹Wusɛ sendi ɓɔnɔ ɓenɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ɗete, ŋgɛ wusɛ duwɛ nde, wusɛ ɓɔnɔ ɓe Njambiyɛ, wusɛ tî taka nde, a kɛ ɓoŋna nɛ lɔr ho nɛ sumba ho nɛ tari te yi ɓomɔ kwakɛ ɓeŋgwɛ mɛtakɛ mɛte yan kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ndana Njambiyɛ yeti kɛ ɓeŋgwɛ se ŋgimɔ te yi ɓomɔ ɗiyma kinɛ duwɛ mɛyasi kɛ́ na. A kɛ pelɛ ndana nyɛ ɓomɔ hɛnɛ kɛ mɛmbɛy hɛnɛ nde, ɓo yêŋsaŋgwɛ temɔ tikɔ ɓeya mɛkele man, ");
INSERT INTO kkj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kɛto a pɛsima yesɔ te yi mɔ te yi nyɛ tɛmbiɗya kɔ ta pɛsɔ mɛlɛpi mɛ ɓotu ɓe mɛnɛti maka hɛnɛ nɛ ŋgbeŋ. A teɗya gbate nyɛ ɓo hɛnɛ nde, yo mɔ te, kɛto a womiya nyɛ soŋɛ kɛ njoka ɓemuŋ.» ");
INSERT INTO kkj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kɛ ɓomɔ ma wokɔ kasi womiya ɓemuŋ kɛ́, ɛ ɓaŋa nyɛtɛ. Ɛ ɓaŋa lɛpɛ yan nde: «Wɛ ta nje kala lɛpɔ sendi lɛpi te nyɛ wusɛ kɛ yiŋa ŋgimɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ɗete, ɛ Pol kwa̧ tikɔ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ko ɓɛkɔ ɗete, ɓaŋa ɓomɔ kɛ njoka yan nyiŋma njɔŋ nɛ, tikɔ temɔ kɛ yi Kumande Yesus. Yo ɓa̧ Denis te wɛtɛ mɔ pɛsina mɛlɛpi kɛ Aropagi ɓu̧ wɛtɛ nyari nde Damaris nɛ̀ ɓaŋa sendi. ");
INSERT INTO kkj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kɛ Pol ma si lɛpina kɛ mbɔmbu ɓetomba kɛ Aropagi kɛ́, ɛ nyɛ nje tɛmɛ womɛte kɛ Atɛn kwa̧ kɛ̀ kɛ Kɔrɛŋt. ");
INSERT INTO kkj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kumɔ mate, ɛ nyɛ dolɛ wɛtɛ mbam nde Akilas, mɔ Ɓeyudɛn. Ɓo jáki nyɛ kɛ Pɔŋ. Akilas ɓenɛ nyari wenɛ Pirisil ɗyaŋma wulɛ Itali kɔkɔ te tì pa kikɔ na, kɛto nyaŋgwɛ kumande te yi ɓo jeɓa nde Kolod kɔ nya mboŋga nde, Ɓeyudɛn hɛnɛ ɗûkwɛ kɛ Rom. Ɛ Pol ɓu̧ yotu nyɛ Akilas ɓenɛ nyari. ");
INSERT INTO kkj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nda Pol ɓa̧ nɛ kiya misi mɛsay ɓenɛ ɓo kɛ́, ɛ nyɛ kɛ̀ ɗiyɔ kɛ yan kelɔ nɛ mɛsay mɛte. Ɓo ɗikima kelɔ mɛtu̧ nɛ to mɛlambɔ. ");
INSERT INTO kkj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kɛ yesɔ *Saba hɛnɛ Pol ɗikima lɛpina nɛ saŋsaŋ nyɛ ɓomɔ kɛ mbanjɔ mɛwesiɗya, sa̧ nje nde, Ɓeyudɛn nɛ̀ Ɓegrɛk jâya lɛpi te yi nyɛ ɗikima lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kɛ Silas ɓenɛ Timɔte ma ɗya̧ wulɛ Maseduwan kɛ́, ɛ Pol nyɛ sosu nɛ hɛnɛ kɛ lɛpina Kimɔ Tom, teɗye Ɓeyudɛn nde, Yesus gbate *Krist, yɔkɔ yi Njambiyɛ tɔkuma. ");
INSERT INTO kkj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nda Ɓeyudɛn ɓa̧ kɛ lu̧ ɗyambi nɛ nyɛ toyɛ nyɛ kɛ́, ɛ Pol kutɛ mɛlambɔ mɛnɛ lɛpɔ nde: «Simbo sɔŋ yun ɓâl kɛ to yun, yo ɓɛ́ŋa wunɛ, yite ti ɓɛ́ŋa se mi na. Mi kɛ tumɔ kɔŋ ndana nɛ wunɛ kɛ̀ kɛ yiŋa mɛkandɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ɛ nyɛ pundɛ womɛte kɛ̀ kɛ tu̧ wɛtɛ mbam nde Titus Yustus. Titus ɓa̧ kɛ kanɔ Njambiyɛ, tu̧ ɗyenɛ ɓa̧ kɛ kɛki mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Wɛtɛ mbam nde Kiripus ɛ ɓa̧ ɗiyɔ nɛ mbanjɔ mɛwesiɗya kɔ tikima temɔ kɛ yi Kumande Yesus ɓenɛ ɓotu ɓe tu̧ ɗyenɛ hɛnɛ. Sendi, ɓaŋa ɓomɔ ɓe Kɔrɛŋt ɓuɗyate ɓe wokuma yasi te yi Pol lɛpima kɛ́, tikima sendi temɔ kɛ yi Kumande Yesus. Ɛ ɓo tɔpɛ ɓo kɛ mɔrɔku. ");
INSERT INTO kkj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nɛ tu ɛ Kumande Yesus lɛpɛ nyɛ Pol nɛ nje te yi nyɛnɔ nde: «Wɛ tî kambi yaŋa na, kɛn mbɔmbu yí lɛpɔ. Wɛ tî ɗiɓi numbu na, ");
INSERT INTO kkj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kɛto mi kɛ kɔŋ yɔ. Kinɛ mumɔ wɛtɛ nɛ wɛtɛ ta kpokɛ wɛ na, kɛto mi nɛ ɓomɔ ɓuɗyate kɛ mɔy ɗya kɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol kwaŋɗya sew wɛtɛ nɛ̀ ŋgwɛndɛ yitan jɔ wɛtɛ kɛ Kɔrɛŋt teɗye ɓomɔ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ndana, ɛ Ɓeyudɛn saŋgwɛ ŋgiŋ suŋgwɛ nɛ nyɛ. Ɛ ɓo ɓu̧ nyɛ kɛ̀ nɔ kɛ mbɔmbu ɓotu ɓe pɛsina jɔsi. Yo ɓa̧ kɛ ŋgimɔ te yi ɓotu ɓe Rom tɛmbiɗya Galiyɔŋ kum kɛ Akay kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ɛ ɓo lɛpɛ nde: «Mbam kɔ kɛ kelɔ nde, ɓomɔ kân Njambiyɛ kinɛ ɓeŋgwɛ mɛmboŋga na.» ");
INSERT INTO kkj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kɛ Pol ma diy ɓutɛ numbu kɛ́, ɛ Galiyɔŋ lɛpɛ nyɛ Ɓeyudɛn nde: «Wunɛ Ɓeyudɛn, yo má ɓɛki yiŋa mɛjɔsɔ dɛlɛ ho yiŋa nyaŋgwɛ ɓeya mɛkele, ma mi nɛ ɗeti te yi lɛŋgwɛ mɛtɔ kɛ mɛlɛpi mɛte. ");
INSERT INTO kkj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma nda yo mɛlombɔ kɛ gbɛla mɛlɛpi kɛto mɛɗinɔ nɛ̀ kasi mɛmboŋga mun kɛ́, yite ɓɛ́ŋa wunɛ. Mi yeti kɛ kwaɗyɛ pɛsɔ mbɛ mɛlɛpi mɛte yite na.» ");
INSERT INTO kkj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ɛ nyɛ ɗuɗye ɓo kɛ mbɛy pɛsina jɔsi. ");
INSERT INTO kkj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ndana, ɛ ɓo hɛnɛ ŋgbɔ ɓiye Sɔsitɛn te kum mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, mɛndɛ nyɛ womɛte kɛ mbɔmbu ɓotu ɓe pɛsina jɔsi, Galiyɔŋ kinɛ ɓutɛ numbu na. ");
INSERT INTO kkj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Kɛ kɔŋte, ɛ Pol nje kwaŋɗye sendi ɓuɗya mɛtu kɛ Kɔrɛŋt. Ɛ nyɛ nje jana nɛ ɓenjɔŋ ɓan ɓe tikima temɔ kɛ yi Yesus Krist ɓaka nyiŋɛ kuka ɓenɛ Akilas nɛ̀ Pirisil yí kɛ̀ kɛ Siri, yite a ma si kɛ̧ to nɛ nɛ kpoŋ kɛ Kɛŋkere yí teɗye nde, a kinjama yaŋa. ");
INSERT INTO kkj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kɛ ɓo ma ɗya̧ kɛ Efɛs kɛ́, ɛ Pol tikɛ ɓenjɔŋ ɓe kɛndi nɛ womɛte. Ɛ nyɛ kwa̧ nyiŋɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn lɛpina ɓenɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓo ŋgwɛtama nɛ nyɛ nde, a pâŋ pa ya mɔnɔ mɛtu ɓenɛ ɓo. Yasi wɛtɛ, a tì jayɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kɛ kɔŋte, ɛ nyɛ jana nɛ ɓo lɛpɔ nde: «Ŋgɛ Njambiyɛ jayɛ, mi ta ɓasiɗye nje.» Ɛ nyɛ tɛmɛ nyiŋɛ kuka kɛ Efɛs womɛte kwa̧. ");
INSERT INTO kkj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kɛ nyɛ ma kumɔ kɛ Sesare kɛ́, ɛ nyɛ piyɛ kɛ kuka kɛ̀ nyɛnɔ njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Yesus Krist ɓaka. Kɛ kɔŋte, ɛ nyɛ sɛliyɛ kɛ̀ Aŋtiyos. ");
INSERT INTO kkj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kɛ nyɛ ma si kwaŋɗye mɔnɔ mɛtu mate kɛ́, ɛ nyɛ tɔkɛ nje kwa̧ nɛ mɛnɛti mɛ Galasi nɛ̀ Friji nyɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka ɗeti kɛ temɔ. ");
INSERT INTO kkj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yo ɓa̧ nɛ wɛtɛ mɔ Ɓeyudɛn nde Apolos. Ɓo jáki nyɛ kɛ Alɛksaŋdiri. Apolos ɓa̧ nɛ jɛŋ ndapi. A ɓa̧ sendi kɛ duwɛ mɛkana mɛ Njambiyɛ ɓuɗyate. Ɛ nyɛ tɛmɛ wɛtɛ yesɔ kɛ̀ kɛ Efɛs. ");
INSERT INTO kkj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ɓo teɗya nyɛ nje Baba Mbokɔ kɛ joŋgwɛ ɗyenɛ. A ɗikima nyɛ temɔ nɛ hɛnɛ kɛ yasi te yi nyɛ kelɛ kɛ́. A ɗikima lɛpɔ teɗye kasi Yesus nyɛ ɓomɔ nɛ nje te. Yasi wɛtɛ, a ɓa̧ kɛ duwɛ ndi kwalɔ tɔpuna ɓomɔ kɛ mɔrɔku te yi Jaŋ ɗikima kelɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɛ nyɛ lɛpina kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn kinɛ wɔ̧ na. Kɛ Akilas ɓenɛ Pirisil ma wokɔ nyɛ kɛ lɛpina kɛ́, ɛ ɓo ɓu̧ nyɛ kɛ̀ teɗye nje Njambiyɛ kpasa teɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kɛ kɔŋte, ɛ Apolos kwaɗyɛ kɛ̀ kɛ Akay. Ɛ ɓenjɔŋ ɓenɛ jayɛ kɛtɔ mɛkana kɛnjɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Akay ɓaka nde, ɓo ɓôŋ nyɛ kimɔte. Kɛ nyɛ ma kumɔ mate kɛ́, ɛ nyɛ kamɛ ɓotu ɓete ɓe Njambiyɛ teɗya ɓo ŋgikwa nde, ɓo jâya Yesus Krist ɓaka ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","A kamma ɓo, kɛto a ɗikima lɛpɔ nɛ saŋsaŋ nyɛ Ɓeyudɛn kɛ misi mɛ ɓomɔ nde, ɓo kɛ mɔy mɛjɔsɔ. A teɗya ɓo nde, Yesus nyɛ *Krist ɓeŋgwɛ yasi te yi ɓa̧ kɛtinate kɛ mɛkana mɛ Njambiyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kɛ ŋgimɔ te yi Apolos ɓa̧ kɛ Kɔrɛŋt kɛ́, ɛ Pol tɔkɛ nje kwa̧ nɛ mɛmbɛy mɛte yi ɓa̧ nɛ nyaŋgwɛ mɛkeki kɛ́ kumɔ Efɛs, dolɔ ɓaŋa ɓomɔ ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka mate. ");
INSERT INTO kkj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ɛ nyɛ diyɛ ɓo nde: «Kɛ ŋgimɔ te yi wunɛ tikima nɛ temɔ kɛ yi Yesus Krist kɛ́, Kimɔ Sisiŋ nja̧ kɛ yotu yun?» Ɛ ɓo yeŋsa nyɛ nyɛ nde: «Ko na, wusɛ tì wokɛ su kasi Kimɔ Sisiŋ te na.» ");
INSERT INTO kkj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ɛ nyɛ nje diyɛ ɓo nde: «Yo kwalɔ tɔpuna ɓomɔ kɛ mɔrɔku te yɛn yi ɓo tɔpuma nɛ wunɛ kɛ́?» Ɛ ɓo yeŋsa nde: «Yo ɓa̧ kwalɔ te yi Jaŋ ɗikima kelɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ɛ nyɛ lɛpɛ nde: «Yo tɔpuna ɓotu ɓete ɓe ɗikima yeŋsa temɔ yi Jaŋ ɗikima kelɔ kɛ́. Jaŋ ɗikima lɛpɔ nyɛ ɓomɔ nde: ‹Wunɛ tîki temɔ kɛ mɔ te ɛ ta nje kɛ kɔŋ mbɛ kɔ, mɔ te yo Yesus.› » ");
INSERT INTO kkj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kɛ ɓo ma si wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ ɓo tɔpɛ ɓo kɛ mɔrɔku nɛ ɗinɔ Kumande Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kɛ Pol ma kasɛ mɛɓɔ kɛ yotu yan kɛ́, ɛ Kimɔ Sisiŋ nje kɛ yotu yan. Ɛ ɓo lɛpina nɛ yiŋa mɛnumbu punjɛ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ɓo ɓa̧ hɛnɛ nda ɓomɔ kamɔ jɔ yiɓa. ");
INSERT INTO kkj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kɛ mɛŋgwɛndɛ yitati Pol ɗikima nyiŋɛ kɛ mbanjɔ mɛwesiɗya mɛ Ɓeyudɛn lɛpina nyɛ ɓomɔ kinɛ wɔ̧ na. A ɗikima lɛpina nyɛ ɓo kɛ kasi kandɔ Njambiyɛ nde, ɓo ɓêŋgwɛ yasi te yi nyɛ ɗikima lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ko ɓɛkɔ ɗete, ɓaŋa kelma ɗaŋna mɛtɔ kinɛ kwaɗyɛ jayɛ na. Ɓo ɗikima lɛpina ɓeyate nyɛ ŋgil ɓomɔ kɛ kasi nje joŋgwɛ te yi Kumande Yesus teɗya kɛ́. Ɛ Pol tikɛ ɓo soŋɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka kɛ njoka yan. A ɗikima lɛpina nyɛ ɓo mɛtu hɛnɛ kɛ mbɛy komɛ Tiranus ɗikima teɗye ɓomɔ yasi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Yo kwaŋnama ɗete yaka mɛsew yiɓa. Ɛ ɓomɔ hɛnɛ ɓe ɗikima ɗiyɔ kɛ Asi ɓaka wokɛ Kimɔ Tom Kumande Yesus. Yo ɓa̧ Ɓeyudɛn nɛ̀ Ɓegrɛk. ");
INSERT INTO kkj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Njambiyɛ ɗikima kwa̧ nɛ Pol yí kelɔ nɛ nyaŋgwɛ mɛkele mɛte yi ɓomɔ tì pa ɓɛŋɛ nɛ toru na. ");
INSERT INTO kkj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ɛ yo kelɛ nde, ɓomɔ ɓôŋ mɛlambɔ nɛ mɔnɔ pɛl mɛkandɔ mɛte yi kpokuma yotu Pol kɛ́ mɔlɔ nɛ ɓotu ɓekɔn, ɛ mɛkɔn ɗiki siyɔ, ɛ ɓeya mɛsisiŋ ɗiki ɗuwɛ kɛ yotu ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɓaŋa Ɓeyudɛn ɓete ɓe ɗikima kɛndɔ mɛɗya nɛ mɛɗya ɗiki kelɔ ŋga̧ soŋɛ nɛ ɓeya mɛsisiŋ kɛ yotu ɓomɔ ɓaka ɓoɓuma kelɔ mɛsay kɛ yotu ɓotu ɓete nɛ ɗinɔ Kumande Yesus. Ɛ ɓo lɛpɛ nyɛ ɓeya mɛsisiŋ nde: «Mi kɛ lɛpɔ nyɛ wunɛ nɛ ɗinɔ Yesus te yi Pol pelɛ kasi nɛ kɔ nde: Wunɛ pûndu ɗuwɛ kɛ yotu mɔ te yɔkɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɓɔnɔ ɓe Seva, ɓɔnɔ ɓembam yitan jɔ yiɓa kelma ɗete. Seva ɓa̧ wɛtɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ, a ɓa̧ Ɓeyudɛn. ");
INSERT INTO kkj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kɛ ɓo ma kelɔ ɗete kɛ́, ɛ ɓeya sisiŋ yeŋsa nde: «Mi duwa̧ Yesus, duwɛ sendi Pol, ma wunɛ yun ɓe nda?» ");
INSERT INTO kkj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɛ mbam te ɛ ɓa̧ nɛ ɓeya sisiŋ kɔ nje ɓiye ɓo natɛ ɓo tumbɔ hɛnɛ. Ɛ ɓo sɛɗyɛ pundɔ kɛ tu̧ sɔkɛrɛ nɛ mɛpeŋ kɛ yotu. ");
INSERT INTO kkj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɓomɔ hɛnɛ ɓe ɗikima ɗiyɔ kɛ Efɛs, ko Ɓeyudɛn ko Ɓegrɛk wokuma yasi te yi kwaŋnama kɛ́. Ɛ ɓo hɛnɛ gwe wɔ̧ lukse ɗinɔ Kumande Yesus ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ɓomɔ ɓuɗyate ɓe tikima temɔ kɛ yi Yesus Krist ɓaka nja̧ jayɛ mɛɓeyɔ man, lɛpɔ sendi ɓeya mɛyasi mɛte yi ɓo kelma kɛ́ kɛ misi mɛ ɓomɔ. ");
INSERT INTO kkj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ɓaŋa ɓomɔ ɓe ɗikima kelɔ mɛkele mɛ kifi ɓaka nja̧ nɛ mɛkana mɛte nje loɗyɛ kɛ misi mɛ ɓomɔ hɛnɛ. Ɓomɔ ɓɛŋma nde, mɔni mɛkana mɛte kumma nda miliyɔŋ kamɔtan. ");
INSERT INTO kkj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ɗete, Kimɔ Tom Kumande Yesus ɓa̧ kɛ kɛ̀ mbɔmbu nɛ nyaŋgwɛ ɗeti. ");
INSERT INTO kkj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kɛ kɔŋ mɛyasi mɛnɔri, ɛ Pol pɛsɛ kɛ temɔ nde, a ta kwa̧ nɛ Maseduwan kwa̧ nɛ Akay kumɔ kɛ Yerusalɛm. Ɛ nyɛ lɛpɛ nde: «Ŋgɛ mi si kɛ̀ mate, mi yâkaŋgwɛ kumɔ sendi kɛ Rom.» ");
INSERT INTO kkj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ɛ nyɛ tomɛ ɓomɔ yiɓa ɓe ɗikima kamɛ nyɛ kɛ mɛsay ɓaka kɛnjɛ kɛ Maseduwan, yo ɓa̧ Timɔte ɓenɛ Erast. Ɛ nyɛ nɛ ŋguru wenɛ tika kwaŋɗye sendi yiŋa mɔnɔ mɛtu kɛ Asi. ");
INSERT INTO kkj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kɛ mɛtu mɛte yite ɛ yiŋa nyaŋgwɛ mɛnjaŋgwɛ kelna kɛto kasi nje joŋgwɛ te yi Kumande Yesus teɗya kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wɛtɛ mbam nde Demiturus, mɔ tuyna mɛyasi nɛ sumba ɗikima tuyɔ yekambiyɛ mbanjɔ wɛtɛ njambiyɛ nde Artemis. Ɗete, ɓotu ɓe mɛsay ɓenɛ ɗikima ɓɛ nɛ ɓuɗya mɔni. ");
INSERT INTO kkj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ɛ nyɛ jeɓa ɓotu ɓe mɛsay ɓenɛ wesiɗye ɓo ɓenɛ ɓaŋa ɓotu ɓete ɓe ɗikima kelɔ kiya mɛsay mɛte ɓaka lɛpɔ nyɛ ɓo nde: «Wunɛ njɔŋ, wunɛ duwa̧ nde, wusɛ jóŋnaŋgwɛ kimɔte kɛto mbelɔ te yikɛ. ");
INSERT INTO kkj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ndana wunɛ kɛ ɓɛŋɛ wokɔ sendi nde, Pol te yɔkɔ ma si kelɔ nde, ɓuɗya ɓomɔ ɓeŋgwɛ yasi te yi nyɛ lɛpɛ kɛ́. Yeti ndi waka kɛ Efɛs na, ko kɛ pɔku mɛnɛti mɛ Asi hɛnɛ, a ma si nyɛ ɓo yiŋa mɛŋgitɛ lɛpɔ nde, ɓenjambiyɛ ɓete ɓe ɓomɔ kwakɛ nɛ mɛɓɔ man ɓaka yeti gba ɓenjambiyɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lɛpi te yakama kelɔ nde, mɛsay musu gwâki mɛsɛŋgɛ, kelɔ sendi nde, ɓomɔ ɓɛ̂sila mbanjɔ Artemis te nyaŋgwɛ njambiyɛ wusu ɛ nyari kɔ. Yo yakama kelɔ sendi nde, mɛluksa mɛ nyaŋgwɛ njambiyɛ wusu kɔ yi ɓomɔ ɓe Asi nɛ̀ ɓotu ɓe mɛnɛti hɛnɛ kanɛ kɔ sîy.» ");
INSERT INTO kkj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ŋgɛ ɓomɔ ma wokɔ mɛlɛpi mɛnɔri kɛ́, ɛ ɓo wokɛ ŋgambi ɓuɗyate. Ɛ ɓo kembiɗya lɛpɔ nde: «Artemis te ɛ ɓotu ɓe Efɛs nyaŋgwɛte!» ");
INSERT INTO kkj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ndana, ɛ ɓomɔ hɛnɛ ɓɛ nɛ kamtana kɛ ɗya, ɛ ɓo ŋgbɔ sɛɗyɛ nambɛ Gayus ɓenɛ Aristark kɛ̀ nɔ kɛ mbɛy komɛ ɓotu ɓe ɗya ɗikima wesiɗya kɛ́. Gayus ɓenɛ Aristark ɓa̧ ɓotu ɓe Maseduwan, ɓo ɓa̧ kɛ njɔŋ kɛndi Pol. ");
INSERT INTO kkj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol kwaɗya punjɛ yotu kɛ ŋgil ɓomɔ, ɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka suŋɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ɓaŋa nyaŋgwɛ ɓotu ɓete ɓe ɗiyɛ nɛ mɛnɛti mɛ Asi ɓe ɓa̧ ɓesɔ ɓe Pol ɓaka tomma mumɔ kɛ̀ lɛpɔ nyɛ nyɛ nde, a tî ɓoɓa kɛ̀ kɛ mbɛy komɛ ɓomɔ ɗiki wesiɗya kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ɓomɔ ɗikima lɛpɔ mɛyasi dɛlɛ dɛlɛ, kɛto mɛnjaŋgwɛ kwaŋma to te. Ɗete, sulɔ ɓomɔ tì ɓɛ kɛ duwɛ to mɛwesiɗya man na. ");
INSERT INTO kkj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ndana, ɛ ɓo ɗalɛ wɛtɛ mbam nde Alɛksaŋdɛrɛ soŋɛ kɛ mɔy ŋgil. Ɓeyudɛn ɗikima pusɔ nyɛ kɛnjɛ mbɔmbu. Ɛ nyɛ pɛpiɗye ɓɔ nyɛ ŋgil ɓomɔ nde, ɓo ɗîy nɛ sɛm. A kwaɗya lɛpina yí nɛmbɛ nɛ to yasi te yi kwaŋnama kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Yasi wɛtɛ, kɛ ɓomɔ ma duwɛ nde, nyɛ Ɓeyudɛn kɛ́, ɛ ɓomɔ hɛnɛ ŋgbɔ kembiɗya nde: «Artemis te ɛ ɓotu ɓe Efɛs nyaŋgwɛte!» Ɓo ɗikima kembiɗya ɗete kumɔ nda hawa yiɓa. ");
INSERT INTO kkj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kɛ kɔŋte, ɛ mɔ te ɛ ɗikima kɛtɔ mɛyasi kɔ nje wɛɗye mɛtemɔ man lɛpɔ nde: «Wunɛ ɓotu ɓe Efɛs, yo nda kɛ ndekima nde, yo Efɛs ɓakiɗye mbanjɔ nyaŋgwɛ njambiyɛ te Artemis kɔ? Yo nda kɛ ndekima sendi nde, yo Efɛs ɓakiɗye yasi te yi wulma ɗyoɓɔ ɓalɔ kɛ́? ");
INSERT INTO kkj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɓomɔ hɛnɛ ma duwɛ yo, ɗete wunɛ wɛ̂ɗya mɛtemɔ wo nyamɔ nɛ pi. ");
INSERT INTO kkj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kɛto wunɛ ɓoŋma ɓotu ɓaka nje nɔ, yasi wɛtɛ, ɓo tì kpokɛ yiŋa yaŋa kɛ mɔy mɛmbanjɔ mɛ ɓenjambiyɛ ɓusu na, ho lɛpɔ yiŋa lɛpi gbutu suŋgwɛ nɛ njambiyɛ wusu ɛ nyari kɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ŋgɛ ɓɛ nde, Demiturus nɛ̀ ɓotu ɓe mɛsay ɓenɛ nɛ mɛlɛpi suŋgwɛ nɛ wɛtɛ mumɔ, mbɛy pɛsina mɛlɛpi nɛ̀ ɓotu ɓe pɛsina mɛlɛpi kɛte, ɓo kɛ̂n putuna mate. ");
INSERT INTO kkj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ŋgɛ ɓɛ nde, wunɛ nɛ yiŋa mɛlɛpi sendi, ɓo ta kombile yo kɛ mbɔmbu ɓotu ɓete ɓe ɗiyɛ nɛ mɛsay mɛte ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Wusɛ ɗîy nɛ sɔsɔ kɛ yasi te yi kelnama muka kɛ́, ma ɓo mɛ nje ndeyɛ wusɛ lɛpɔ nde, wusɛ ɗesa to ɓomɔ suŋgwɛ nɛ ɓekum ɓe ɗya. Kɛto kinɛ to lɛpi wɛtɛ nɛ wɛtɛ yi wusɛ yakama pilɛ kɛto mɛwesiɗya mɛte yikɛ na.» ");
INSERT INTO kkj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kɛ nyɛ ma si lɛpɔ ɗete kɛ́, ɛ nyɛ lɛpɛ nyɛ ɓomɔ nde, ɓo sîki ɗuwɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kɛ nyaŋgwɛ mɛnjaŋgwɛ mɛnɔri ma si siyɔ kɛ́, ɛ Pol wesiɗye ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka kitɛ ɓo nyɛ ɓo ɗeti kɛ temɔ. Kɛ kɔŋte, ɛ nyɛ jana nɛ ɓo kwa̧ kɛ̀ Maseduwan. ");
INSERT INTO kkj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A kɛndima kɛ Maseduwan nyɛ ɓuɗya mɛŋgitɛ nyɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka. Kɛ kɔŋte, ɛ ɓo nje kwa̧ kumɔ kɛ mɛnɛti mɛ Ɓegrɛk. ");
INSERT INTO kkj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pol yama ŋgwɛndɛ yitati mate. Kɛ ŋgimɔ te yi nyɛ kwaɗya ɓu̧ kuka yí kɛ̀ nɔ Siri kɛ́, ɛ nyɛ wokɛ nde, Ɓeyudɛn ma lɛɓiye nyɛ. Ndana, ɛ nyɛ pɛsɛ nde, a ta yɔkwɛ nɛ kɔkɔ nje kwa̧ nɛ Maseduwan. ");
INSERT INTO kkj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatɛr te mɔnɔ Pirus te mɔ Bere ka̧ kɛ̀ tikiɗye nyɛ, nje ɓu̧ Aristark ɓenɛ Sekundus te ɓotu ɓe Tesalonik nɛ̀ Gayus mɔ Dɛrbɛ nɛ̀ Timɔte nje ɓu̧ sendi Tisik nɛ̀ Torofim te ɓotu ɓe Asi. ");
INSERT INTO kkj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓotu ɓaka kwaŋma mbɔmbu kɛ̀ laɗye wusɛ kɛ Turuwas. ");
INSERT INTO kkj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wusɛ nja̧ tɛmɛ su ɓu̧ kuka kɛ Filipi kɛ kɔŋ jesɔ ɗyena mɛmampa te yi kinɛ ŋga̧ kɛte kɛ́. Hɛ yama mɛtu yitan kɛ nje, ɛ wusɛ nje kumɔ kɛ Turuwas dolɔ ɓo, ɛ wusɛ nje ya mɛtu yitan jɔ yiɓa womɛte. ");
INSERT INTO kkj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kɛ yesɔ sɔndi ma ɗya̧ kɛ́, ɛ wusɛ wesiɗya yí ɗye mɛɗye mɛ Njambiyɛ. Misi pupɛ Pol ɓa̧ nɛ kɛndi. Ɗete, ɛ nyɛ lɛpina nyɛ ɓotu ɓete ɓe wesiɗyama ɓaka. A lɛpinama nɛ ndɛŋgɛlɛŋ kumɔ ɓembe tu. ");
INSERT INTO kkj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mɛlambo ɓa̧ ɓuɗyate kɛ mbɛy komɛ wusɛ wesiɗyama kɛ wɛtɛ toŋgari kɛ tu̧ kwey kɛ njenate. ");
INSERT INTO kkj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wɛtɛ mɔnɔ gwanjɔ nde Etis ɓa̧ mɛtiɗyɛ kɛ wunda. Ɛ nyɛ kwa̧ nɛ nyaŋgwɛ jakɔ kɛ ŋgimɔ te yi Pol ɓa̧ ndi kɛ lɛpina kɛ̀ nɔ mbɔmbu kɛ́. Ɛ nyɛ kɛtiyɛ mate kɛ toŋgari yitatite kɛ kwey ɓalɔ kɛ mɛnɛti, kɛto jakɔ kwaŋma nyɛ kɛ misi. Kɛ ɓo ma kɛ̀ kaŋɛ nyɛ kɛ́, ɓo dól, a ma gwe. ");
INSERT INTO kkj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ɛ Pol piyɛ ɓutuma kɛ to nɛ wuse nyɛ lɛpɔ nde: «Wunɛ tî gwaki kaŋ yaŋa na, kɛto sosu nɛ ndi kɛte.» ");
INSERT INTO kkj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kɛ kɔŋte, ɛ Pol nje ɓendɔ yɔkwɛ kɛ̀ mate. Ɛ nyɛ lekɛ mampa kwa̧ ɗye, lɛpina sendi kikwɛ kumɔ njenamɛnɔ. Kɛ kɔŋte, ɛ nyɛ nje tɔkɛ kɛndi kwa̧. ");
INSERT INTO kkj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɓo ɓoŋma mɔnɔ gwanjɔ kɔ nɛ joŋ nje nɔ. Ɛ temɔ ɓomɔ hɛnɛ wɛyɛ nɛ fɛm. ");
INSERT INTO kkj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɛ wusɛ kwa̧ su mbɔmbu nɛ kuka kumɔ Asos. Yo mate yi wusɛ yâkaŋgwɛ ɓu̧ Pol, kɛto nyɛ nɛ ŋguru wenɛ pɛsima nde, a ta kwa̧ nɛ nɛ ŋgindi nɛ kol. ");
INSERT INTO kkj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kɛ nyɛ ma nje dolɔ wusɛ kɛ Asos kɛ́, ɛ wusɛ nje nyinje nyɛ kɛ kuka kumɔ nɔ Mitilɛn. ");
INSERT INTO kkj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ɛ wusɛ nje tɛmɛ womɛte kwa̧. Misi pupɛ, ɛ wusɛ kumɛ kɛ kɛki wɛtɛ kiriŋgira nde Kiyɔs. Ya tu wɛtɛ kɛ kɔŋte, ɛ wusɛ kumɛ kɛ wɛtɛ kiriŋgira nde Samɔs. Misi pupɛ te, ɛ wusɛ kumɛ kɛ Milɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kɛto Pol pɛsima nde, a ta kwa̧ kɛ Efɛs kinɛ tɛmɛ na. A pɛsima ɗete, kambɔ a mɛ nje ɗimbiɗye ŋgimɔ kɛ Asi, kɛto a ɓa̧ kɛ kwaɗyɛ kwa̧ ɓekɛ ɓekɛ, simande yesɔ Paŋtekot yakama dolɔ nyɛ kɛ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kɛ ŋgimɔ te yi Pol ɓa̧ nɔ kɛ Milɛ kɛ́, ɛ nyɛ tomɛ ɓomɔ kɛnjɛ kɛ Efɛs kɛ̀ jeɓa nɛ ɓetomba mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kɛ ɓo ma ɗya̧ dolɔ nyɛ kɛ́, ɛ Pol lɛpɛ nyɛ ɓo nde: «Wunɛ nɛ ŋguru wun kɛ duwɛ nda yi mi joŋnama nɔ sinɛ wunɛ kandɛ kɛ yesɔ te yi mi ɗyaŋma nɔ kɛ Asi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi kelma mɛsay mɛ Nyaŋgwɛ Kumande kinɛ ɓendiɗye yotu yí lɛpɔ nde, mi yaŋa na. Mi kelma mɛsay nɛ misiɗyɛ kɛ misi kɛ mɔy mɛbɔnɛ mɛte yi Ɓeyudɛn ɗikima kelɔ nɛ mi kɛ ŋgimɔ te yi ɓo ɗikima ŋgɔmbile nɛ mi kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wunɛ kɛ duwɛ sendi nde, mi lɛpima mɛyasi hɛnɛ te yi yakama kamɛ wunɛ kɛ joŋgwɛ kinɛ sɔɗyɛ yaŋa na. Mi lɛpima mɛyasi hɛnɛ, teɗye sendi wunɛ mɛyasi kɛ misi mɛ ɓomɔ nɛ̀ kɛ mɔy mɛtu̧ mun. ");
INSERT INTO kkj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi pelma nyɛ Ɓeyudɛn, pelɛ sendi nyɛ Ɓegrɛk nde, ɓo yêŋsaŋgwɛ temɔ jayɛ Njambiyɛ, tikɔ sendi temɔ kɛ yi Kumande wusu Yesus. ");
INSERT INTO kkj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nɛ ɓɛ̂ŋa, ndana Kimɔ Sisiŋ kɛ jeliyɛ mi nde, mi kɛ̂n kɛ Yerusalɛm. Mi yeti kɛ duwɛ yasi te yi ta ɗya̧ mi mate kɛ́ na. ");
INSERT INTO kkj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yasi wɛtɛ, kɛ mɛɗya hɛnɛ te yi mi kwa̧ te, Kimɔ Sisiŋ kɛ kandɛ teɗye mi nde, mɛpoka nɛ̀ nyaŋgwɛ mɛbɔnɛ kɛ laɗye mi. ");
INSERT INTO kkj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ko ɓɛkɔ ɗete, mi yeti kɛ kambiɗya nɛ joŋgwɛ ɗyembɛ nda yo yiŋa sulna yasi na. Siya yasi te yembɛ ndi nde, mi kûm kɛ njena yasi te yi mi yâkaŋgwɛ kelɔ kɛ́, siɗyɛ mɛsay te yi Kumande Yesus nya mi kɛ́. Mɛsay mɛte, yo lɛpina Kimɔ Tom nde, Njambiyɛ nɛ ŋgikwa. ");
INSERT INTO kkj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mi kwaŋma ɓɛŋɛ wunɛ hɛnɛ pelɛ mɛyasi nyɛ wunɛ kɛ kasi *Kandɔ Njambiyɛ. Ma ndana, mi duwa̧ nde, wunɛ tí ɓɛŋɛ se mbɔmbu mbɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yori yi mi kombile lɛpɔ nyɛ wunɛ ndana nde, kɛ njoka yun hɛnɛ, ŋgɛ wɛtɛ mumɔ nje yambile, yite ti ɓɛ́ŋa se mi na. ");
INSERT INTO kkj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kɛto mi ma si lɛpɔ mɛyasi hɛnɛ te yi Njambiyɛ sima si kombile kɛ́ nyɛ wunɛ, mi tì sɔɗyɛ yiŋa yaŋa kɛte na. ");
INSERT INTO kkj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Wunɛ kômbila ɓakiɗye mɛyotu mun, ɓakiɗye sendi ŋgil ɓomɔ hɛnɛ ɓe Kimɔ Sisiŋ nya wunɛ mɛsay mɛ ɓakiɗya yan ɓaka. Wunɛ ɓâkiɗya njɔŋ ɓotu ɓete ɓe tikima temɔ kɛ yi Njambiyɛ ɓaka kimɔte. Njambiyɛ kolma njɔŋ ɓotu ɓete nɛ mɛkiyɔ mɛ mɔnɔ wenɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mi duwa̧ nde, ɓeŋgwɛy ta nyiŋɛ kɛ njoka yun kɛ kɔŋ mbɛ. Ɓo tí tikɔ ŋgil nɛ tɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sendi, kɛ njoka yun nɛ ŋguru wun ɓaŋa ɓomɔ ta tɛmɛ lɛpɔ mɛlɛpi mɛ ja̧ yí ɗulɛ nɛ ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka nyinje kɛ njɔŋ yan. ");
INSERT INTO kkj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɗete, wunɛ pɛ̂m yasi. Wunɛ tâka nda yi mi ɗikima nyɛ wunɛ hɛnɛ mɛŋgitɛ tu nɛ̀ yesɔ nɛ misiɗyɛ kɛ misi kɛ mɛsew yitati kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ndana, mi kɛ diyɛ Njambiyɛ nde, a ɓâkiɗya wunɛ nda yi Kimɔ Tom nɛ lɛpɛ nde, a nɛ ŋgikwa kɛ́. Yo nyɛ yakama nyɛ wunɛ ɗeti, nyɛ sendi wunɛ mɛyasi mɛte yi nyɛ kpoma nyɛ ɓomɔ ɓenɛ hɛnɛ ɓe nyɛ tɔkuma ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi tì ɓosa mɔni ho lɔr ho mɛlambɔ mɛ wɛtɛ mumɔ na. ");
INSERT INTO kkj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Wunɛ nɛ ŋguru wun kɛ duwɛ nde, mi kelma mɛsay nɛ mɛɓɔ mɛmbɛ yí joŋna nɔ, joŋgwɛ sendi ɓotu ɓete ɓe mi ɓa̧ sinɛ ɓo ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi teɗya wunɛ kɛ mɛyasi hɛnɛ nde, wunɛ kêl mɛsay ɗete yí kamɛ nɛ ɓotu ɓe kɔsɔ takɛ mɛlɛpi mɛte yi Kumande Yesus nɛ ŋguru wenɛ lɛpima nde: ‹Nɛ̀ mɔ te ɛ nyɛ mumɔ yasi, nɛ̀ yɔkɔ ɛ ɓu̧ ɓoŋgɔ kɔ, yɔkɔ ɛ nyɛ kɔ ta ɓu̧ mɛkombila.› » ");
INSERT INTO kkj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kɛ Pol ma si lɛpina ɗete kɛ́, ɛ nyɛ kusɛ mɛɓɔŋ kɛ mɛnɛti ŋgwɛta nɛ Njambiyɛ ɓenɛ ɓo hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɛ ɓomɔ hɛnɛ lelɛ ɓuɗyate wuse nyɛ dulɔ numbu nɛ. ");
INSERT INTO kkj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɓo ɓa̧ nɛ ɓuɗya mɛtakɛ kɛ lɛpi te yi nyɛ lɛpima nde, ɓo tí ɓɛŋɛ se mbɔmbu nɛ kɛ́. Kɛ kɔŋte, ɛ ɓo kɛ̀ tikiɗye nyɛ kɛ mbɛy ɓendina kuka. ");
INSERT INTO kkj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kɛ kɔŋte, ɛ wusɛ nje tikɔ ɓo nyiŋɛ kuka tɔkɛ nje nɛ ŋgbeŋ kumɔ kɛ Kos. Misi pupɛ, ɛ wusɛ kumɛ kɛ Rod. Ɛ wusɛ nje kwa̧ womɛte kumɔ kɛ Patara. ");
INSERT INTO kkj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wusɛ dolma wɛtɛ kuka mate kɛ kɛ̀ Fenisi, ɛ wusɛ nyiŋɛ yo kwa̧. ");
INSERT INTO kkj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kɛ wusɛ ma kumɔ kɛ kɛki Siprɛ kɛ́, ɛ wusɛ tikɛ yo pulɔ gare tɔkɛ nje Siri kɛndɔ ŋgbɔsɔ kuka kɛ Tir, kɛto yo ɓa̧ nde, ɓo sôŋa mɛmapi womɛte. ");
INSERT INTO kkj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Wusɛ dolma ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist ɓaka mate, ɛ sinɛ ɓo ya mɛtu yitan jɔ yiɓa. Ɛ Kimɔ Sisiŋ kelɛ nde, ɓo lɛ̂pi nyɛ Pol nde, a tî ɓoɓa ɓendɔ kɛ̀ pɛ Yerusalɛm na. ");
INSERT INTO kkj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kɛ mɛtu mɛte ma si kwa̧ kɛ́, ɛ wusɛ tɛmɛ tɔkɛ nje kwa̧. Ɛ ɓo hɛnɛ kɛ̀ tikiɗye wusɛ kɛ njena ɗya ɓenɛ ɓoma ɓan nɛ̀ ɓɔnɔ ɓan. Kumɔ kɛ goŋ maŋ, ɛ wusɛ kusɛ mɛɓɔŋ kɛ mɛnɛti ŋgwɛta nɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kɛ kɔŋte, ɛ wusɛ jana nɛ ɓo nyiŋɛ kuka, ɛ ɓo yɔkwɛ kɛ̀ ɗya. ");
INSERT INTO kkj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wusɛ tɛmma Tir kwa̧ ɗuku nɛ ɗuku kumɔ kɛ Tolemayis. Wusɛ piya womɛte nyɛnɔ ɓenjɔŋ ɓusu ya tu wɛtɛ sinɛ ɓo. ");
INSERT INTO kkj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Misi pupɛ ɛ wusɛ kwa̧ kumɔ Sesare nyiŋɛ tu̧ Filip dolɔ mbɛy womɛte. Filip ɓa̧ mɔ lɛpina Kimɔ Tom. A ɓa̧ sendi kɛ njoka ɓembam yitan jɔ yiɓa ɓete yi ɓo tɔkuma kɛ Yerusalɛm ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A ɓa̧ nɛ ɓɔnɔ ɓoma yini, ɓo ɓa̧ ɓindite. Ɓo ɗikima punjɛ mɛlɛpi mɛ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Wusɛ kwaŋɗya mɔnɔ mɛtu womɛte. Ɛ wɛtɛ mɔ punja mɛlɛpi mɛ Njambiyɛ nde Agabus ɗya̧ wulɛ Yuda. ");
INSERT INTO kkj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɛ nyɛ nyiŋɛ tu̧ dolɔ wusɛ ɓu̧ kanda Pol wotɔ nɛ mɛkol nɛ̀ mɛɓɔ mɛnɛ nɛ ŋguru wenɛ lɛpɔ nde: «Kimɔ Sisiŋ kɛ lɛpɔ nde: Ɓeyudɛn ta wotɔ sa kanda kɛ ɗekɛ kɛ Yerusalɛm kaŋɛ nyɛ nyɛ ɓotu ɓete ɓe yeti Ɓeyudɛn ɓaka.» ");
INSERT INTO kkj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kɛ wusɛ ma wokɔ ɗete kɛ́, ɛ sinɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka ŋgwɛta nɛ Pol nde, a tî kɛn Yerusalɛm na. ");
INSERT INTO kkj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yasi wɛtɛ, ɛ nyɛ lɛpɛ nde: «Wunɛ lél ŋge? Wunɛ tɛ́kwɛ yotu mbɛ, kɛto yasi te nda? Kɛ yembɛ, ɓo ta ɓɛ kɛ wotɔ mi, yeti ndi yite siyɛ na, mi ta ɓɛ kɛ saŋgwa nɛ sɔŋ kɛ Yerusalɛm kɛto ɗinɔ Kumande Yesus.» ");
INSERT INTO kkj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nda yi nyɛ ti kwaɗyɛ wokɔ kɛ́, ɛ wusɛ wɛɗya kwa̧ lɛpɔ nde: «Nyaŋgwɛ Kumande kêl nda yi nyɛ kwaɗyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kɛ kɔŋte, kɛ wusɛ ma si kwaŋɗye mɔnɔ mɛtu womɛte kɛ́, ɛ wusɛ kombile mɛyasi musu tɔkɛ kɛndi yí kɛ̀ Yerusalɛm. ");
INSERT INTO kkj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ɓaŋa ɓotu ɓete ɓe ɓeŋgwɛ mɛlɛpi mɛ Yesus Krist kɛ Sesare ɓaka ka̧ tikiɗye wusɛ. Ɓo ɓoŋma wusɛ kɛ̀ teɗye mbɛy jakɔ kɛ yasi wɛtɛ mbam nde Nasɔn, mɔ Siprɛ. Yo mɛ njombu yaŋa yi nyɛ ɓeŋgwɛ nɛ mɛlɛpi mɛ Yesus Krist kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kɛ wusɛ ma ɗya̧ kɛ Yerusalɛm kɛ́, ɛ ɓenjɔŋ ɓusu ɓu̧ wusɛ nɛ mɛsosa. ");
INSERT INTO kkj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Misi pupɛ ɛ sinɛ ɓe Pol kɛ̀ kɛ yi Jak. Ɛ ɓetomba mbanjɔ Njambiyɛ nje sendi womɛte. ");
INSERT INTO kkj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kɛ Pol ma si nyɛnɔ ɓo kɛ́, ɛ nyɛ yekiɗye tandɛ mɛyasi hɛnɛ te yi Njambiyɛ kelma kɛ yiŋa mɛkandɔ kɛ mɛsay mɛte yi nyɛ nya nyɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kɛ ɓo ma si wokɔ mɛyasi mɛte yi Pol yekiɗya kɛ́, ɛ ɓo lukse Njambiyɛ. Ɛ ɓo nje lɛpɔ nyɛ nyɛ nde: «Maŋ wusu, ɓɛŋa nde, Ɓeyudɛn ɓetomay ɓetomay ma tikɔ temɔ kɛ yi Yesus Krist. Ɓo hɛnɛ kɛ nyɛ sosu kɛ ɓeŋgwa mɛmboŋga mɛ Mɔyisi. ");
INSERT INTO kkj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓo wokuma nde, wɛ kɛ teɗye Ɓeyudɛn hɛnɛ ɓe ɗiyɛ kɛ tombɔ kɛ njoka yiŋa mɛkandɔ ɓaka nde, ɓo lêŋ mɛmboŋga mɛ Mɔyisi, ɓo tî pɛsi ɓɔnɔ ɓan ɓe ɓembam na, ɓo tî ɓeŋgwɛ sendi mɛtumbu musu na. ");
INSERT INTO kkj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hɛ ta kelɔ nan? Ɓo ta wokɔ nde, wɛ ɗyaŋma, yite kinɛ mɛso na. ");
INSERT INTO kkj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ɗete, kelɔ yasi te yi wusɛ ta lɛpɔ nyɛ wɛ kɛ́. Wusɛ waka nɛ ɓembam yini ɓe kinjama yotu yan ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ɓoŋgɔ ɓo, weya sɛmbɔ wúnɛ ɓo, nɛ̀ wɛ nyɛ̂ki ɓo yasi te yi ɓo diyɛ ɓo kɛ́, nɛ́ ɓo kɛ̧ mɛto man. Ɗete, ɓomɔ hɛnɛ ta duwɛ nde, yasi te yi ɓo wokuma kɛ kasi yɔ kɛ́, yo ja̧. Kelɔ ɗete, nɛ́ ɓo duwɛ nde, wɛ sendi kɛ kɛndɔ nɛ ŋgbeŋ ɓeŋgwɛ mɛmboŋga mɛ Mɔyisi. ");
INSERT INTO kkj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yasi wɛtɛ, kɛ kasi ɓotu ɓete ɓe yeti Ɓeyudɛn ɓe tikima temɔ kɛ yi Yesus Krist ɓaka, wusɛ pɛsima, ɛ wusɛ kɛtɛ mɛkana kɛnjɛ ɓo nde, ɓo tî kpoka ɗye njay te yi ɓo kelɛ nɛ sadaka nyɛ ɓaŋa ɓenjambiyɛ kɛ́ na. Ɓo tî ɗyaki mɛkiyɔ mɛ nyamɔ na, ho ɗye nyamɔ te ɛ gwe gbɔŋgi kɔ na. Sendi, ɗiyɔ mbam ɓenɛ nyari tî ɓɛŋnaŋgwɛ kinɛ gwaki kɛ njoka te na.» ");
INSERT INTO kkj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ndana, ɛ Pol ɓu̧ ɓembam ɓaka yini kwa̧ nɔ. Misi pupɛ ɛ nyɛ weya sɛmbɔ nda ɓo sendi. Ɛ ɓenɛ ɓo nyiŋɛ kɛ mbanjɔ Njambiyɛ. Ɛ nyɛ lɛpɛ yesɔ te yi mɛweya mɛsɛmbɔ ta siyɔ kɛte kɛ́, yo sendi yesɔ te yi mumɔ hɛnɛ kɛ njoka yan ta nyɛ sadaka te yenɛ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ndana, mɛtu yitan jɔ yiɓa te ɓukwa̧ nɛ mbɛt, nɛ́ yo siy, ɛ Ɓeyudɛn ɓete ɓe wulma Asi ɓaka semɛ Pol kɛ mɔy mbanjɔ Njambiyɛ. Ɛ ɓo sesiɗye ŋgil ɓomɔ hɛnɛ, ɛ ɓo kembiɗya kɛ̀ ɓiye nɛ Pol lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Wunɛ ɓotu ɓe Isarayɛl, nɛ njâki dɔ. Mɔ te ɛ lɛpina ɓeyate nɛ kandɔ su nyɛ ɓomɔ hɛnɛ kɛ̀ nɔ kɔ, ɛkɔ. A kɛ lɛpina ɓeyate suŋgwɛ nɛ mɛmboŋga mɛ Mɔyisi, lɛpina sendi ɓeyate yí wuŋgwɛ nɛ mbɛy te yikɛ. A ka̧ mbɔmbu nyinje Ɓegrɛk kɛ mbanjɔ Njambiyɛ yí wuŋgwɛ nɛ mbɛy te yikɛ yi nɛ kiyɔ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ɓo lɛ́pi ɗete, kɛto nɛ mbɔmbu ɓo ɓɛŋma Torofim te mɔ Efɛs ɓenɛ Pol kɛ mɔy sɛ̧, ɛ ɓo takɛ nde, Pol ɓoŋma nyɛ kɛ̀ nɔ kɛ mbanjɔ Njambiyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɛ ndiŋgɛlɛ ɗya hɛnɛ ɓɛ nɛ kamtana. Ɛ ɓomɔ sɛɗyɛ kɛ̀ wesiɗya kɛ mbɛy wɛtɛ. Ɛ ɓo ɓiye Pol kpatile nyɛ punjɛ kɛ mɔy mbanjɔ Njambiyɛ kwa̧ ɗiɓɔ mɛnumɛy nɛdɔ kɛ kɔŋte. ");
INSERT INTO kkj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nda ɓo ɓa̧ kɛ sa̧ nje te yi wo nyɛ kɛ́, ɛ nyaŋgwɛ kum ɓesɔja ɛ ɗikima ɗiyɔ nɛ ɓesɔja tomay kɔ wokɛ nde, mɛnjaŋgwɛ kɛ mɔy Yerusalɛm hɛnɛ. ");
INSERT INTO kkj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ndana ndana, ɛ nyɛ ɓu̧ ɓesɔja nɛ̀ ɓekum ɓesɔja ɓete ɓe ɓa̧ ɗiyɔ nɛ ɓesɔja gɔmay gɔmay ɓaka kɛ̀ nɔ nɛ sokɔ. Kɛ ɓomɔ ma ɓɛŋɛ nyaŋgwɛ kum ɓesɔja nɛ̀ ɓesɔja kɛ́, ɛ ɓo ndulɛ mɛndina Pol. ");
INSERT INTO kkj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ndana, ɛ nyaŋgwɛ kum ɓesɔja kɛ̀ kɛ kɛki Pol ɓiye nyɛ lɛpɔ nde, ɓo wôtu nyɛ nɛ kɔl sumba yiɓa. Kɛ kɔŋte, ɛ nyɛ diyɛ nde, Pol mɔ ɗya te yɛn, a kél say te nda, a kelma ŋge? ");
INSERT INTO kkj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ɓotu ɓete ɓe wesiɗyama ɓaka ɗikima kembiɗya lɛpɔ mɛyasi dɛlɛ dɛlɛ. Nyaŋgwɛ kum ɓesɔja tì ɓɛ nɛ ɗeti te yi ɓiye to lɛpi na kɛto ɓuɗya mɛɗuŋ. Ɗete, ɛ nyɛ lɛpɛ nde, ɓo ɓôŋ Pol kɛ̀ nɔ kɛ nyaŋgwɛ tu̧ ɓesɔja. ");
INSERT INTO kkj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kɛ Pol ma kumɔ kɛ mbɛy komɛ ɓomɔ ɓendɛ nyiŋɛ nɛ nyaŋgwɛ tu̧ ɓesɔja kɛ́, ɛ ɓesɔja soɓɛ nyɛ kɛto temɔ ɓomɔ ɓa̧ nɛ joŋjoŋ, ");
INSERT INTO kkj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","sendi, kɛto ŋgil ɗikima ɓeŋgwɛ ɓo. Ɓomɔ ɗikima kembiɗya lɛpɔ nde: «Soŋa wusɛ ɗyan kɛ misi.» ");
INSERT INTO kkj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kɛ ŋgimɔ te yi ɓo ɓa̧ kɛ nyinje Pol kɛ mɔy nyaŋgwɛ tu̧ ɓesɔja kɛ́, ɛ Pol lɛpɛ nyɛ nyaŋgwɛ kum ɓesɔja nde: «’Mi yakama lɛpɔ yiŋa yasi nyɛ wɛ?» Ɛ nyaŋgwɛ kum ɓesɔja lɛpɛ nyɛ nyɛ nde: «Ase, ’wɛ nɛ duwɛ lɛpina numbu Grɛk? ");
INSERT INTO kkj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","’Wɛ yeti mɔ Ejipt kɔ ɛ ɗesa to ɓomɔ kɛ mɛtu te yikɛ, ɓu̧ ɓotu ɓe wona ɓomɔ tomay yini nyiŋɛ nɛ likɔ kɔ na?» ");
INSERT INTO kkj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ɛ Pol yeŋsa nde: «Mi Ɓeyudɛn, gwanjɔ Tars kɛ Silisi. Ɗya ɗyembɛ nyaŋgwɛ ɗya. Mi kɛ ŋgwɛta nɛ wɛ nde: Tikɔ, nɛ́ mi lɛpina nyɛ ɓomɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ɛ nyaŋgwɛ kum ɓesɔja jayɛ. Ɛ Pol tɛmɛ kɛ gere gere mbɛy nyiŋna tu̧ pɛpiɗye ɓɔ nyɛ ɓomɔ nde, ɓo ɗîy nɛ sɛm. Ɛ ɓomɔ ɗiyɛ nɛ gbilik. Ɛ Pol ɓu̧ lɛpi nɛ numbu Hebere lɛpɔ nde: ");
INSERT INTO kkj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Wunɛ njɔŋ, wunɛ ɓesaŋgwɛ ɓembɛ, wunɛ lɛ̂ŋgwɛ mɛtɔ kɛ yasi te yi mi ta lɛpɔ ndana nyɛ wunɛ kɛ́, nɛ́ wunɛ duwɛ nde, mi tì kelɛ yiŋa ɓeya yaŋa na.» ");
INSERT INTO kkj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kɛ ɓo ma wokɔ nde, a kɛ lɛpina nyɛ ɓo nɛ numbu Hebere kɛ́, ɛ ɓo kɛ̀ mbɔmbu ɗiyɔ nɛ gbilik ko wati na. ");
INSERT INTO kkj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ɛ nyɛ lɛpɛ nde: «Mi Ɓeyudɛn, ɓo jáki mi kɛ Tars kɛ Silisi, yasi wɛtɛ, mi ɗɔ́ku waka kɛ Yerusalɛm. Ɛ mi jekɛ yasi kɛ nji̧ mɛkol mɛ Gamaliyɛl. Ɛ nyɛ teɗye mi mɛyasi ɓeŋgwɛ ndi mɛmboŋga mɛ ɓesaŋmbambɔ ɓusu. Mi kwaɗya kelɔ mɛsay nyɛ Njambiyɛ nɛ temɔ mbɛ hɛnɛ ndi nda wunɛ hɛnɛ muka. ");
INSERT INTO kkj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi teɗya ɓotu ɓete ɓe ɓeŋgwɛ nje Kumande Yesus ɓaka nyaŋgwɛ mɛbɔnɛ wo ɓo wotɔ ɓembam nɛ̀ ɓomari nyinje ɓo kɛ jɔɓɔ. ");
INSERT INTO kkj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ njɔŋ ɓetomba hɛnɛ yakama jayɛ kɛ numbu mbɛ. Ɓo sendi, ɓo nya mi mɛkana, nɛ́ mi kɛnjɛ ɓemaŋ ɓusu ɓe Damas yí kɛ̀ ɓiye ɓomɔ, nɛ́ mi wotu ɓo yɔkwɛ nje nɔ Yerusalɛm nje teɗye ɓo mɛbɔnɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ɗete, wɛtɛ yesɔ ɛ mi tɔkɛ nje kwa̧. Kɛ ŋgimɔ te yi mi ɓa̧ kɛ wuta nɛ Damas kɛ́, semɔ semɔ, kɛ pɔku ɓembe yesɔ ɛ yiŋa nyaŋgwɛ mɛjasi wulɛ kwey panɔ kɛ mbɛy te yi mi ɓa̧ kɛte kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ɛ mi ɓalɛ kɛ mɛnɛti, ɛ mi wokɛ yiŋa mɛn kɛ lɛpɔ nyɛ mi nde: ‹Sol, Sol, wɛ téɗya mi mɛbɔnɛ kɛto ŋge?› ");
INSERT INTO kkj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ɛ mi diyɛ nde: ‹Nyaŋgwɛ Kumande, yo wɛ nda?› Ɛ mɛn lɛpɛ nde: ‹Yo mi Yesus te ɛ Nasarɛt. Yo mi mɔ te yi wɛ teɗye nyɛ mɛbɔnɛ kɔ.› ");
INSERT INTO kkj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ɓotu ɓete ɓe sinɛ ɓo ɓa̧ ɓaka ɓɛŋma mɛjasi kimɔte, ko ɗete, ɓo tì wokɛ mɛn mɔ te ɛ ɓa̧ kɛ lɛpina kɔ na. Ndana, ɛ mi lɛpɛ nde: ‹Mi kêl ɓa nan, Nyaŋgwɛ Kumande?› ");
INSERT INTO kkj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ɛ Kumande Yesus lɛpɛ nyɛ mi nde: ‹Tɛma, kɛn kɛ Damas, ɓo ta lɛpɔ yasi hɛnɛ te yi Njambiyɛ ma pɛsɔ nde, kelɔ kɛ́ mate nyɛ wɛ.› ");
INSERT INTO kkj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nda yi mi ti ɓɛ kɛ ɓɛŋna se kɛto ŋguŋguɗyɛ mɛjasi mɛte kɛ́, ɛ ɓotu ɓete ɓe sinɛ ɓo ɓa̧ ɓaka nje ɓiye mi kɛ ɓɔ kumɔ nɔ Damas. ");
INSERT INTO kkj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Yo ɓa̧ nɛ wɛtɛ mbam mate nde Ananiyas, a ɗikima kanɔ Njambiyɛ nda yi mɛmboŋga musu teɗye kɛ́. Ɓeyudɛn hɛnɛ ɓe ɗikima ɗiyɔ kɛ Damas ɓaka ɗikima jayɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɛ nyɛ nje tɛmɛ dolɔ mi lɛpɔ nyɛ mi nde: ‹Sol maŋmbɛ, ɓɛŋnaŋgwɛ nɛ kɔkɔ.› Ndana ndana, ɛ misi mɛmbɛ ɓutuna, ɛ mi ɓɛŋɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ɛ nyɛ lɛpɛ nde: ‹Njambiyɛ te ɛ ɓesaŋmbambɔ ɓusu tɔkuma wɛ, nɛ́ wɛ duwɛ yasi te yi nyɛ kwaɗyɛ kɛ́, nɛ́ wɛ ɓɛŋ mɔ mɛsay wenɛ ɛ nɛ ŋgbeŋ kɔ, wokɔ sendi yasi te yi nyɛ ta lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kɛto wɛ ta lɛpɔ gbakasi kɛ kasi nɛ kɛ mbɔmbu ɓomɔ hɛnɛ yí lɛpɔ yasi te yi wɛ ɓɛŋma nɛ̀ yi wɛ wokuma kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wɛ láɗya sendi ŋge ndana? Tɛma, jaya nde, ɓo tɔ̂pa wɛ kɛ mɔrɔku, nɛ́ Njambiyɛ soŋ mɛɓeyɔ mɔ nɛ ɗinɔ Nyaŋgwɛ Kumande.› » ");
INSERT INTO kkj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ɛ Pol kɛ̀ mbɔmbu lɛpɔ nde: «Ɛ mi nje yɔkwɛ nje Yerusalɛm. Mi ɓa̧ kɛ ŋgwɛta kɛ mbanjɔ Njambiyɛ, ɛ yaŋa ɗya̧ mi nda nyɛnɔ. ");
INSERT INTO kkj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Yo nde, mi ɓɛŋma Kumande Yesus, ɛ nyɛ lɛpɛ nyɛ mi nde: ‹Jɛwɔ, jisa kɛ Yerusalɛm ndana ndana, kɛto ɓo tí jayɛ yasi te yi wɛ ta lɛpɔ kɛ kasi mbɛ kɛ́ na.› ");
INSERT INTO kkj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ɛ mi yeŋsa nde: ‹Nyaŋgwɛ Kumande, ɓo nɛ ŋguru wan kɛ duwɛ nde, mi ɗikima kɛ̀ kɛ mɛmbanjɔ mɛwesiɗya mɛ Ɓeyudɛn, kelɔ nde, ɓo nyînja ɓotu ɓete ɓe tikima temɔ kɛ yɔ ɓaka kɛ jɔɓɔ, njurɔ sendi ɓo nɛ ŋgbasi. ");
INSERT INTO kkj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mi ɓa̧ sendi kɛte komɛ ɓo woma nɛ Itɛn kɛ́. A ɗikima lɛpɔ mɛyasi mɛte yi nyɛ duwa̧ nɛ ŋgbak ŋgbak kɛ kasi yɔ. Mi jayma yasi te yi ɓo kelma nɛ nyɛ kɛ́. Yo mi ɓakiɗye mɛlambɔ mɛ ɓotu ɓete ɓe woma nyɛ ɓaka.› ");
INSERT INTO kkj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ɛ Kumande Yesus lɛpɛ nyɛ mi nde: ‹Tɛma kwa̧, kɛto mi ta tomɔ wɛ kɛnjɛ lɔndunate kɛ yi yiŋa mɛkandɔ.› » ");
INSERT INTO kkj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɓomɔ lɛŋgwa mɛtɔ kɛ yasi te yi Pol lɛpima kɛ́ kumɔ komɛte, ɛ ɓo kembiɗya lɛpɔ nde: «Kwalɔ mumɔ te yɔkɔ tî ɗiy kɛ to mɛnɛti na! Yo yeti kimɔte nde, a ɗîy nɛ joŋ na!» ");
INSERT INTO kkj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓo kembiɗyama sɔrɛ mɛlambɔ man ɓetɛ, wukɛ ŋgbutu nyanje kɛnjɛ kwey. ");
INSERT INTO kkj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ɛ nyaŋgwɛ kum ɓesɔja lɛpɛ nde, ɓo nyînja Pol kɛ mɔy nyaŋgwɛ tu̧ ɓesɔja, njurɔ nyɛ nɛ njambala, na pil nɛ to lɛpi, nɛ́ nyɛ nje duwɛ to te yi ɓomɔ kembiɗya suŋgwɛ nɛ Pol kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kɛ ɓo ma wotɔ nyɛ, nɛ́ ɓo njuru kɛ́, ɛ Pol lɛpɛ nyɛ kum ɓesɔja te ɛ ɗikima ɗiyɔ nɛ ɓesɔja gɔmay ɛ ɓa̧ womɛte kɔ nde: «’Ɓo nya wunɛ ɗeti te yi njurɔ mɔ te ɛ mɛ mɔ Rom kɔ kinɛ pa jɔse nyɛ na?» ");
INSERT INTO kkj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kɛ kum ɓesɔja te ma wokɔ ɗete kɛ́, ɛ nyɛ kwa̧ kɛ̀ lɛpɔ nyɛ nyaŋgwɛ kum ɓesɔja nde: «Wɛ ta kelɔ nan? Mbam kɔ mɛ mɔ Rom.» ");
INSERT INTO kkj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ɛ nyaŋgwɛ kum ɓesɔja nje dolɔ Pol diyɛ nyɛ nde: «Lɛpɔ nyɛ mi, wɛ mɛ mɔ Rom?» Ɛ Pol jayɛ nde: «I̧.» ");
INSERT INTO kkj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ɛ nyaŋgwɛ kum ɓesɔja lɛpɛ nde: «Mi kwaŋɗya ɓuɗya mɔni yí ɓɔmɔ nɛ ɗiyɔ mɔ Rom.» Ɛ Pol lɛpɛ nde: «Mi jaɗya mbɛ nɛ ɗiyɔ te.» ");
INSERT INTO kkj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ndana ndana, ɛ ɓotu ɓete ɓe diyma njurɔ nyɛ nde, na pil to lɛpi ɓaka si jisɛ. Kɛ nyaŋgwɛ kum ɓesɔja ma duwɛ nde, Pol mɔ Rom kɛ́, ɛ nyɛ gwe wɔ̧, kɛto a lɛpima nde, ɓo wôtu nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nyaŋgwɛ kum ɓesɔja kwaɗya duwɛ to lɛpi te yi Ɓeyudɛn ɓu̧ suŋgwɛ nɛ Pol kɛ́. Ɗete, misi pupɛ ɛ nyɛ lɛpɛ nde, ɓo wûnja mɛkɔl mɛte yi ɓo wotuma nɛ nyɛ kɛ́ soŋɛ. Ɛ nyɛ lɛpɛ nyɛ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓomɔ hɛnɛ ɓe ɓa̧ kɛ nyaŋgwɛ jɔsi Ɓeyudɛn ɓaka nde, ɓo wêsiɗyaŋgwɛ. Ɛ nyɛ lɛpɛ nde, ɓo ɓôŋ Pol nje tɛmbiɗye kɛ mbɔmbu yan. ");
INSERT INTO kkj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ɛ Pol kaŋɛ misi ɓɛŋɛ nɛ ɓotu ɓe nyaŋgwɛ jɔsi Ɓeyudɛn nɛ ŋgoŋ lɛpɔ nde: «Wunɛ njɔŋ, kumɔ ndana, kɛ joŋgwɛ ɗyembɛ temɔ mbɛ nɛ tɛ kinɛ yaŋa kɛ njaŋgwɛ mi kɛ njoka mbɛ sinɛ Njambiyɛ na.» ");
INSERT INTO kkj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ɛ Ananiyas te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ lɛpɛ nde, ɓo mɛ̂nda Pol kɛ numbu. ");
INSERT INTO kkj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ɛ Pol lɛpɛ nyɛ nyɛ nde: «Njambiyɛ ta mɛndɛ sendi wɛ. Wɛ nda guŋgu te yi ɓo nya konɔ kɛte kɛ́. Wɛ womɛri kɛ ɗiyɔ nde, nɛ́ wɛ jɔse mi ɓeŋgwɛ mɛmboŋga. Yasi wɛtɛ, wɛ kɛ yaŋgile mɛmboŋga. Wɛ kɛ lɛpɔ nde, ɓo mɛ̂nda mi.» ");
INSERT INTO kkj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ɛ ɓotu ɓete ɓe ɓa̧ womɛte ɓaka lɛpɛ nyɛ Pol nde: «Wɛ kɛ toyɛ nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ, mɔ te ɛ Njambiyɛ tɛmbiɗya kɔ.» ");
INSERT INTO kkj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ɛ nyɛ yeŋsa nde: «Wunɛ njɔŋ, mi tì duwɛ nde, yo nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ na. Kɛto yo kɛtinate kɛ mɛkana mɛ Njambiyɛ nde: ‹Wɛ tî lɛpinaŋgwɛ ɓeyate nɛ kum ɗya ɗyɔ na.› » ");
INSERT INTO kkj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nda Pol duwa̧ nde, kɛ njoka ɓotu ɓete ɓe ɓa̧ womɛte ɓaka yo ɓa̧ nɛ mɛnjɔŋ yiɓa, *Ɓesadusɛ̧ nɛ̀ *Ɓefarisɛ̧, ɛ nyɛ lɛpɛ nɛ mɛn kɛ kwey kɛ nyaŋgwɛ jɔsi Ɓeyudɛn nde: «Wunɛ njɔŋ, mi kɛ njɔŋ Ɓefarisɛ̧. Ɓotu ɓete ɓe jama mi ɓaka kɛ njɔŋ Ɓefarisɛ̧. Mi ndana kɛ jɔsi kɛto lɛpi te yi ɓomɔ ɓe nɛ ɓiɓina temɔ kɛte nde, ɓomɔ ta womiyɛ kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kɛ nyɛ ma lɛpɔ ɗete kɛ́, ɛ mɛtandɔ ɗya̧ kɛ njoka Ɓefarisɛ̧ ɓenɛ Ɓesadusɛ̧, ɛ ɓo ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ɓesadusɛ̧ lɛ́pi yan nde, ɓemuŋ tí womiyɛ na, sendi, kinɛ ɓejaki na kinɛ yiŋa nde sisiŋ na. Ɓefarisɛ̧ kɛ jayɛ yan nde, ɓemuŋ ta womiyɛ, ɓejaki kɛte, sendi sisiŋ kɛte. ");
INSERT INTO kkj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɛ nyaŋgwɛ mɛtandɔ ɓɛ kɛte. Ɛ ɓaŋa ɓotu ɓe kɛtina mɛyasi ɓe ɓa̧ kɛ njɔŋ Ɓefarisɛ̧ ɓaka tɛmɛ sɛŋɛ kutuɗya nde: «Wusɛ yeti kɛ ɓɛŋɛ yiŋa mɛjɔsɔ kɛ yotu mbam kɔ na, simande yiŋa sisiŋ ho wɛtɛ jaki Njambiyɛ lɛpinama nyɛ nyɛ ɓa.» ");
INSERT INTO kkj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mɛtandɔ nja̧ ɗɔkɔ kwa̧ to te. Ɛ nyaŋgwɛ kum ɓesɔja gwe wɔ̧ nde, ɓo ta nyalɔ Pol ndana. Ɛ nyɛ lɛpɛ nyɛ ɓesɔja nde, ɓo kɛ̂n kɛ̀ ɓu̧ Pol soŋɛ kɛ njoka ɓomɔ kɛ̀ nɛ nyɛ kɛ nyaŋgwɛ tu̧ ɓesɔja. ");
INSERT INTO kkj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nɛ tu ɛ Kumande Yesus pundɛ kɛ to Pol lɛpɔ nyɛ nyɛ nde: «Wɛ tî kambi yaŋa na, nda wɛ lɛpima yasi te yi wɛ duwa̧ gbate kɛ kasi mbɛ kɛ Yerusalɛm kɛ́, wɛ yâkaŋgwɛ lɛpɔ sendi ɗete kɛ Rom.» ");
INSERT INTO kkj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Misi pupɛ ɓemɛŋmɛnɛ ɛ ɓaŋa Ɓeyudɛn saŋgwɛ ŋgiŋ pɛsɔ kinja lɛpɔ nde, ɓo dîsɔ ɗyena hɔɓiye yaŋa komɛ ɓo wo Pol. ");
INSERT INTO kkj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓuyɔ ɓotu ɓete ɓe nya kutu te ɓaka kwaŋma ɓomɔ kamɔni. ");
INSERT INTO kkj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓo kwaŋma kɛ̀ dolɔ ɓekum ɓe ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ nɛ̀ ɓetomba lɛpɔ nyɛ ɓo nde: «Wusɛ pɛsima kinja ɗumna gbate gbate nde, wusɛ disɔ ɗyena komɛ wusɛ wo Pol. ");
INSERT INTO kkj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ndana, nɛ̀ wunɛ nɛ̀ ɓotu ɓe nyaŋgwɛ jɔsi Ɓeyudɛn, wunɛ kɛ̂n kɛ̀ lɛpɔ nyɛ nyaŋgwɛ kum ɓesɔja nde, a kwâŋɗya Pol njesɛ wunɛ. Wunɛ kêl nda wunɛ kɛ kwaɗyɛ nɛmbɛ lɛpi nɛ kimɔte. Ɗete, wusɛ ta komsa yí wo nyɛ, yite a tì pa wuta nɛ wunɛ na.» ");
INSERT INTO kkj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ta nɛ Pol ɛ mbam wokuma kasi kutu te. Ɛ nyɛ kwa̧ kɛ̀ kɛ nyaŋgwɛ tu̧ ɓesɔja kɛ̀ lɛpɔ nyɛ Pol. ");
INSERT INTO kkj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ɛ Pol jeɓa wɛtɛ kum ɓesɔja ɛ ɗikima ɗiyɔ nɛ ɓesɔja gɔmay kɔ lɛpɔ nyɛ nyɛ nde: «Ɓoŋgɔ mɔnɔ gwanjɔ kɔ kɛ̀ nɔ kɛ yi nyaŋgwɛ kum wun, kɛto a nɛ yiŋa yasi te yi nyɛ kɛ kwaɗyɛ lɛpɔ nyɛ nyɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ɛ kum ɓesɔja kɔ ɓu̧ mɔnɔ gwanjɔ kɔ kɛ̀ nɔ kɛ yi nyaŋgwɛ kum wan lɛpɔ nyɛ nyɛ nde: «Pol te ɛ ɗiyɛ kɛ jɔɓɔ kɔ jeɓama mi, ŋgwɛta nɛ mi nde, mi ɓôŋ mɔnɔ gwanjɔ kɔ nje nɔ kɛ yɔ nde, a nɛ yiŋa yasi te yi nyɛ ta lɛpɔ nyɛ wɛ.» ");
INSERT INTO kkj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ɛ nyaŋgwɛ kum ɓesɔja ɓiye mɔnɔ gwanjɔ kɛ ɓɔ kɛ̀ nɔ nɛ naŋ diyɛ nyɛ nde: «Yo yasi te nda yi wɛ kwaɗyɛ lɛpɔ nyɛ mi kɛ́?» ");
INSERT INTO kkj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ɛ nyɛ yeŋsa nde: «Ɓeyudɛn ma saŋgwɛ ŋgiŋ nde, ɓo ta nje ŋgwɛta nɛ wɛ nde: ‹Ɓoŋgɔ Pol nɛmɛnɔ kɛ̀ nɔ kɛ nyaŋgwɛ jɔsi.› Ɗete, ɓo kelma likisi nde, ɓo ta lɛpɔ nyɛ wɛ nde: ‹Ɓoŋgɔ nyɛ kɛ̀ nɔ›, nɛ́ ɓo kɛ̀ nɛmbi lɛpi nɛ kimɔte. ");
INSERT INTO kkj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wɛ tî woku yasi te yi ɓo ta lɛpɔ kɛ́ na, kɛto ɓotu ɓete ɓe ma lɛɓiye nyɛ ɓaka kwaŋma ɓomɔ kamɔni. Ɓo ma pɛsɔ kinja ɗumna nde, ɓo disɔ ɗyena ho hɔɓiye yaŋa komɛ ɓo wo Pol. Ndana ɓo ma komsa, ɓo láɗya ndi nde, jaya.» ");
INSERT INTO kkj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ɛ nyaŋgwɛ kum ɓesɔja nje lɛpɔ nyɛ mɔnɔ gwanjɔ kɔ nde, a ɗûkwɛ. Ɛ nyɛ lɛpɛ nyɛ nyɛ nde, kpɛ, a tî yekiɗya nyɛ wɛtɛ mumɔ nde, a nja̧ lɛpɔ yiŋa yaŋa ɗete nyɛ nyɛ na. ");
INSERT INTO kkj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kɛ kɔŋte, ɛ nyaŋgwɛ kum ɓesɔja jeɓa ɓekum ɓesɔja yiɓa lɛpɔ nyɛ ɓo nde: «Wunɛ jêɓaŋgwɛ ɓesɔja gɔmay yiɓa lɛpɔ nyɛ ɓo nde, ɓo kômsaŋgwɛ. Wunɛ jêɓaŋgwɛ sendi ɓomɔ kamɔtan jɔ kaɓa ɓe kɛndɛ kɛ to ɓeyaŋga, ɓu̧ sendi ɓomɔ gɔmay yiɓa ɓe ɓiye mɛkɔ̧ ɓaka. Kɛ ŋgimɔ yitan jɔ yini te yi tu, wunɛ hɛnɛ kɛ kwa̧ kɛ̀ Sesare.» ");
INSERT INTO kkj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ɛ nyɛ lɛpɛ sendi nde, ɓo ɓôŋ ɓenyamɔ ɓete ɓe ta soɓɛ Pol ɓaka, nɛ́ ɓo ɓoŋ nyɛ nɛ tɛ kumɔ nɔ kɛ yi Felis te nyaŋgwɛ kum. ");
INSERT INTO kkj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ɛ nyaŋgwɛ kum ɓesɔja kɛtɛ mɛkana kɛnjɛ nyaŋgwɛ kum Felis nde: ");
INSERT INTO kkj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","‹Mi kɛ lukse nyaŋgwɛ kum Felis. Yo mi Kolod Lisiyas nyɛnɛ wɛ. ");
INSERT INTO kkj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ɓeyudɛn ɓiyma mbam kɔ, nɛ́ ɓo wo nyɛ, ɛ mi kɛ̀ nɛ ɓesɔja kɛ̀ joŋgwɛ nyɛ soŋɛ kɛ mɛɓɔ man. Mi wokuma nde, a nɛ ɗiyɔ mɔ Rom. ");
INSERT INTO kkj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mi kwaɗya duwɛ to lɛpi te yi ɓo lɛpina ɓeyate nɛ nyɛ kɛte kɛ́. Ɗete, ɛ mi ɓu̧ nyɛ kɛ̀ nɔ kɛ nyaŋgwɛ jɔsi yan. ");
INSERT INTO kkj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mi ɓɛŋma nde, ɓo lɛ́pinaŋgwɛ nɛ nyɛ kɛ kasi mɛyasi mɛte yi ɓɛŋɛ mɛmboŋga man. Ko ɓɛkɔ ɗete, a tì kelɛ yiŋa nyaŋgwɛ ɓeya yasi te yi yakama nde, a sɔ̂mbu sɔŋ ho a nyîŋa jɔɓɔ kɛte na. ");
INSERT INTO kkj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mi wokuma nde, Ɓeyudɛn kɛ kwaɗyɛ kelɔ ɓeya yasi nɛ nyɛ. Ɗete, mi kɛ kwaŋɗye nyɛ nɛdɔ kɛnjɛ wɛ. Mi lɛpima nyɛ ɓotu ɓete ɓe lɛpina nɛ nyɛ ɓaka nde, ɓo ɓôŋ lɛpi te kɛ̀ nɔ kɛ yɔ. Hɛ saŋgwa!› ");
INSERT INTO kkj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ndana, ɛ ɓesɔja ɓu̧ Pol nɛ tu kwa̧ nɔ kumɔ nɔ kɛ̀ Antipatris nda yi ɓo lɛpima nyɛ ɓo kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Misi pupɛ ɛ ɓesɔja ɓete ɓe ɓa̧ kɛndɔ nɛ mɛkol ɓaka yɔkwɛ suŋgwɛ nyaŋgwɛ tu̧ ɓesɔja. Ɛ ɓari ɓe ɓa̧ kɛ to ɓeyaŋga ɓaka toŋgiɗya nɛ Pol. ");
INSERT INTO kkj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kɛ ɓo ma ɗya̧ kɛ Sesare kɛ́, ɛ ɓo ɓu̧ mɛkana nyɛ nyaŋgwɛ kum, kaŋɛ sendi Pol nyɛ nyɛ. ");
INSERT INTO kkj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kɛ nyɛ ma si tɔlɔ mɛkana kɛ́, ɛ nyɛ diyɛ nde, Pol mɔ ɗya te yɛn? Kɛ nyɛ ma si duwɛ nde, nyɛ mɔ Silisi kɛ́, ");
INSERT INTO kkj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ɛ nyɛ lɛpɛ nyɛ nyɛ nde: «Mi ta wokɔ mɛn yɔ kumɔ njena komɛ ɓotu ɓete ɓe lɛpina nɛ wɛ ɓaka ta ɗya̧ kɛ́.» Ɛ nyɛ lɛpɛ nde, ɓo ɓôŋ Pol kɛ̀ ɓakiɗye kɛ tu̧ kumande Herod. ");
INSERT INTO kkj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ya mɛtu yitan kɛ kɔŋte kɛ́, ɛ Ananiyas te nyaŋgwɛ kum ɓotu ɓe nyɛna sadaka nyɛ Njambiyɛ ɗya̧ ɓenɛ ɓetomba nɛ̀ wɛtɛ mɔ duwa̧ lɛpi nde Tɛrtul. Ɛ ɓo sɔmse Pol kɛ yi nyaŋgwɛ kum. ");
INSERT INTO kkj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ɛ ɓo kɛ̀ jeɓa nyɛ nje nɔ. Ɛ Tɛrtul nyɛ numbu kɛ lɛpi lɛpɔ nde: «Nyaŋgwɛ mumɔ Felis, wusɛ kɛ joŋna ndana nɛ piyɛm jakimɛ wɛ. Mɛyasi ma sɛnjɔ kimɔte ndana kɛ ɗya jakimɛ kimɔ ɗyanɔ ɗyɔ. ");
INSERT INTO kkj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Wusɛ kɛ jayɛ mɛkele mɛte kɛ mɛyasi hɛnɛ nɛ̀ kɛ mɛmbɛy hɛnɛ. Wusɛ kɛ nyɛ wɛ wosoko ɓuɗyate. ");
INSERT INTO kkj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi yeti kɛ kwaɗyɛ kɛ̀ mbɔmbu nɛ ndɛŋ ndɛŋ yí ɗimbiɗye nɛ ŋgimɔ yɔ na. Mi kɛ ŋgwɛta nɛ wɛ nde, ŋgɛ wɛ jayɛ, lɛŋgwɛ mɛtɔ kɛ mɔnɔ lɛpi te yi wusɛ ta lɛpɔ kɛ́. ");
INSERT INTO kkj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Wusɛ ɓɛŋma nde, mbam kɔ gba ŋgboro. A kɛ ɗesɛ to ɓomɔ kɛ njoka Ɓeyudɛn hɛnɛ kɛ to mɛnɛti. Nyɛ kum njɔŋ ɓotu ɓete ɓo jeɓa nde Ɓenasarɛ̧ ɓaka. ");
INSERT INTO kkj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A diyma ɓoɓɛ wuŋgwɛ mbanjɔ Njambiyɛ, ɛ wusɛ ɓiye nyɛ. Wusɛ kwaɗya jɔse lɛpi nɛ ɓeŋgwɛ mɛmboŋga musu. ");
INSERT INTO kkj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Yasi wɛtɛ, nyaŋgwɛ kum ɓesɔja Lisiyas nja̧ ɗya̧ sukɔ nyɛ kɛ mɛɓɔ musu nɛ ŋgaŋ ");
INSERT INTO kkj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","lɛpɔ nde, ɓotu ɓete ɓe lɛpina nɛ mbam kɔ ɓaka njâki kɛ yasi yɔ. Wɛ nɛ ŋguru wɔ ta wokɔ mɛyasi hɛnɛ te yi wusɛ lɛpɛ kɛ kasi nɛ kɛ́ kimɔte, komɛ wɛ ta diyɛ nyɛ mɛdiyan kɛ́.» ");
INSERT INTO kkj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ɛ Ɓeyudɛn ɗiyɛ kɛ kɔŋ nɛ lɛpɔ nde, yo gbate ɗete. ");
INSERT INTO kkj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kɛ kɔŋte, ɛ nyaŋgwɛ kum pɛpiɗye ɓɔ nyɛ Pol nde, a lɛ̂pinaŋgwɛ. Ɛ nyɛ ɓu̧ lɛpi lɛpɔ nde: «Mi duwa̧ nde, yo mɛ kɛ ɓuɗya mɛsew ndana, yo wɛ ɗiyɛ mɔ pɛsina jɔsi mɛ ɓotu ɓe kandɔ kɛ́. Ɗete, mi nɛ ɓiɓina temɔ yí ɓu̧ lɛpi pilɛ yembɛ. ");
INSERT INTO kkj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ŋgɛ wɛ diyɛ ɓomɔ, wɛ ta wokɔ nde, yo tì pa kwa̧ mɛtu 