﻿USE sofia;
DROP TABLE IF EXISTS sofia.kkc_vpl;
CREATE TABLE kkc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kkc_vpl WRITE;
INSERT INTO kkc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Keliso yo Deibidiyo amawe, osoloso Deibidi yo Eibalahameeyo amawe. Esiga Yesuwo amawe dio dia hu hagoso. ");
INSERT INTO kkc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibalahameeyo owolo Aisek, osoloso Aisekeeyo owolo ee Yekob, Yekobeeyo owolo ee Yuda, osoloso Yekobeeyo owolo dio abo. ");
INSERT INTO kkc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Osoloso Yudayo owolo ee Peles dio Sala dio (osoloso egee bia dia owee ee Tamala), osoloso Peleseeyo owolo ee Heslon, osoloso Hesloneeyo owolo ee Lam. ");
INSERT INTO kkc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Osoloso Lameeyo owolo ee Aminadab, osoloso Aminadabeeyo owolo ee Nason, osoloso Nasoneeyo owolo ee Salmon. ");
INSERT INTO kkc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Osoloso Salmonowo owolo ee Bowas (Bowaseeyo owee ee Leihab), osoloso Bowaseeyo owolo ee Obed (Obedeeyo owee ee Lut), osoloso Obedeeyo owolo ee Yesi. ");
INSERT INTO kkc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Osoloso Yesiyo owolo ee wiligi odoo toboloso badebei Deibidiso. Deibidiyo owolo ee Solomono. (Solomonowo owee ee daga Yulayayo osobo.) ");
INSERT INTO kkc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Osoloso Solomonowo owolo ee Lehobowam, osoloso Lehobowameeyo owolo ee Abiya, osoloso Abiyayo owolo ee Asa. ");
INSERT INTO kkc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Osoloso Asayo owolo ee Yehosapat, osoloso Yehosapateeyo owolo ee Yeholam, osoloso Yeholameeyo owolo ee Yusaya. ");
INSERT INTO kkc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osoloso Yusayayo owolo ee Yotam, osoloso Yotameeyo owolo ee Ahas, osoloso Ahaseeyo owolo ee Hesekaya. ");
INSERT INTO kkc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Osoloso Hesekayayo owolo ee Manase, osoloso Manaseyo owolo ee Amon, osoloso Amoneeyo owolo ee Yosaya. ");
INSERT INTO kkc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosayayo owolo ee Yekonaya, osoloso Yosayayo owolo dio abo. Biame domo omapoo Isalael odooso odoo abo sabolo ha temeleso, diba Babilon mi mapoo dabalame iyado diso. ");
INSERT INTO kkc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Esiga Isalael odooso Babilon mi mapoo dala ma kulodu debei biame omapoo Yekonayaye giso holo soomagooso, o hu ee Selatiyel. Osoloso Selatiyeleeyo owolo ee Selubabel. ");
INSERT INTO kkc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Osoloso Selubabeleeyo owolo ee Abiyud, osoloso Abiyudowo owolo ee Eliyakim, osoloso Eliyakimeeyo owolo ee Asol. ");
INSERT INTO kkc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Osoloso Asolowo owolo ee Sadok, osoloso Sadokowo owolo ee Akim, osoloso Akimeeyo owolo ee Eliyud. ");
INSERT INTO kkc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Osoloso Eliyudowo owolo ee Eliyasal, osoloso Eliyasaleeyo owolo ee Matan, osoloso Mataneeyo owolo ee Yekob. ");
INSERT INTO kkc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Osoloso Yekobowo owolo ee Yosep. Esiga Yosepeeye Meli huso. Osoloso Meliye Yesu edebeeyo takolone Keliso deli ee soomagooso. ");
INSERT INTO kkc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Esiga Eibalahameeye badebei biame omaga bei mooloogooloso di wiligi odoo Deibidiye badebei biame omapoo, Kelisowo amawe dio 14 odoo hagee biaso debeiso. Osoloso wiligi odoo Deibidiye badebei biame omaga bei mooloogooloso di Babilon odoo oso Isalael odoo dala ma kulodu gilimado di biame omapoo, Kelisowo amawe dio 14 odoo hagee biaso debeiso. Osoloso abaga bei mooloogooloso di Yesu soomagoo biame mapoo, Kelisowo amawe dio 14 odoo hagee biaso debeiso. ");
INSERT INTO kkc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keliso soomagoo goo ee egeesee moloso. Owee Meli Yosepeeye hulame dadagoloso debeiso. Esino diba huilega dobolone, Meli yo Dio Tei oso kitulugu maga koowasi moodoo goo ee eyo nediliyo ogoloso gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Esino Yosepeeye goo hagee duloso, gowoolone Meli pagalame gooleeso. Esino Yosep yo Godeeyo howo woola tekepo badeli. Esiga odoo susuga eyo howo woola Meli pagalai yo goomegele. Egeeseelone Meli hulame dadaga ee mada pagalame yo goomogaso. ");
INSERT INTO kkc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep yo goo hamaga goolone badoboome, Godeeyo momaiye oso sapootia mapoo yimapoo sibileso egeesee takaso, “Yosep, Deibidiyo amawe, no Meli hulei na ebi. Bei, yo Dio Tei oso kitulugu maga koowasi moodooloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Esiga yo giso holo soomagalaiso. Egeeseega nayo o hu Yesu hedi. Bei, o odoo oso dibada goo tokenee eyo nei telega pagalame, yayo diba pidileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Esiga Godeeye o odoo yimaga to toloso kokodo takomo sili odoo yimaga to taka goo oso tei dalame, goo susuga hagoso tei peledabaso. Bei, yayo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Sobo obuo giso dia goo gooleedele poogoo oso koowasi moodooloso giso holo soomagalaiso. Osoloso odoo susuga oso o hu ee Imanuwel dolone dabalaiso,” diso. Hu eyo bei ee Godee ibolo hodobo badoso. ");
INSERT INTO kkc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eseme Yosep yo tia hogabuloso Godeeyo momaiyeso yimapoo taka to ee dodolone Meli huso. ");
INSERT INTO kkc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Esino Yosep dio Meli dio hedebe delega badolone, Meliye giso holo soomagooso. Eseme Yosepeeye holope o hu Yesu hediso. ");
INSERT INTO kkc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helodeeye Yu odoowo wiligi odoo toboloso badebei biame omapoo, Yudiya mi toowa ma kulodu Betilihem mi pepooko mapoo Meliye Yesu soomagooso. Yesu soomagoloso hamamee giwo hesigeli odoo oso osokoso sibili maga Yelusalem mi mapoo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Diba Yelusalem mapoo peledoboloso egeesee takomo silesibiso, “Ibada midee mapoo dobolone egeino, giwo toowa osokoso sibili omapoo molome egeiso. Iyo giwo egee ogoloso, wiligi odoo hee olo soomagoo doloso gooleedoloso hamapoo ka sibadee. Esiga holope Yu odoowo wiligi odoo toboloso badalame soomagoo ee kasomo? Bei, iyo o hu dokodoo poudalame ka sibadee,” dee takomo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Esino wiligi odoo Helodee sabolo osoloso Yelusalem mapoo debeli odoo susuga sabolo oso goo hagee duloso diya gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Egeeseelone Helodeeye tei moso wiligi odoo tebisa sabolo osoloso tei eligili odoo gilimadoloso dimapoo egeesee takaso, “Godee maga to toloso kokodo takomo silesibili odoo oso takolone Keliso kamapoo soomagalaigonala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eseme diayo nei egeesee takaso, “Yudiya mi toowa ma kulodu Betilihem mi pepooko mapoo soomagalaigona diso. Bei, Godee maga to toloso kokodo takomo sili odoo oso egeesee hoguguso, ");
INSERT INTO kkc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betilihem Yuda mi ee ma kulodu, Nayo Yuda mi toowa ee ma kulodu goo toowa ka moloso. Bei, nee mi omaga wiligi odoo tabalai ee sibileiso. Yayo mo odoo Isalael mi mapoo debeli odoo ee bamalaiso,’ dee takeliso.” ");
INSERT INTO kkc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eseme Helodeeye goo hagee duloso, giwo hesigeli odoo mapoo giwoso peledaba biame ee gooleedalame diba mada gilimadooso. ");
INSERT INTO kkc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Osoloso diayo nei taka duloso diba Betilihem mapoo diye dolone to egeesee takaso, “Niba dileso holope egee medee esiameleso ogoloso see wedi sibileso amapoo takee. Egeeseega anosee yimapoo dileso o hu dokodoo poudileiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Eseme giwo hesigeli odoo oso Helodeeyo to duloso dulone, giwo diayo dia mi mapoo egei hedebe onosee see egeiso. Diba giwo egee ogoloso diya goomoga sabolo giwoso malalo dime hamamee deedee diso. Diba giwo egee hamamee dodomo dime, giwoso dileso holopeso badebei moso eyo tobudu pouni meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eseme giwo hesigeli odoo oso holopeso badebei moso eyo kulodu gadileso egeino, holope owee Meli dio badoboome egeiso. Eseme diayo gauwuloso dobolone holope eyo hu dokodoo poudooso. Osoloso emegei di bi gold molee, osoloso siga medee sisigageli bi medee tekepo, osoloso mopoodoo soo kolo mapoo hedili hageesee yimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Esino diba see wedi dilame tiano, sapootia mapoo Godeeye dimapoo egeesee takaso, “Niba see wedi duga, Helodeeye badebei maga na di. Esino niba eli hee maga nibada mi mapoo ka diyadee,” diso. Eseme diba to ee dodolone eli hee maga dibada mi mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Osoloso hamamee giwo hesigeli odoo olo dime, gesi omapoo Yosep tiamolome, sapootia mapoo Godeeyo momaiye oso sibileso yimapoo egeesee takaso, “No hogabuloso holope sabolo osoloso owee sabolo gilimadoloso Isipi mi mapoo kukulo di. Bei, Helodeeyo odoo oso holope egee wooloomalame esiamo sibileiso. Esiga niba kukulo dileso Isipi mi mapoo dabalame di. Niba omapoo dileso doga, niyo see wedi sibilei biame ee ayo nimapoo takalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Egeesee taka duloso gesi omapoo Yosep hogabuloso holope sabolo owee sabolo gilimadoloso Isipi mi mapoo kukulo diso. ");
INSERT INTO kkc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Diba omapoo dileso Helodee towa beleso bameleeso. Esiga goo hagee tei peledabaso, Godeeye o odoo yimaga to toloso kokodo takomo sili odoo yimaga taka to sabolo tebilame. To ee hagoso, “Ayo mo holo Isipi mi ee poogoloso sibilame iso.” ");
INSERT INTO kkc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Esino giwo hesigeli odoo oso Helodee mapoo takalame see wedi sibilega, eli hee maga dibada mi mapoo wedi di goo ee duloso yo diya kamanaso. Osoloso yayo eyo nediliyo egeesee gooleeso, “Giwo hesigeli odoo oso giwo dia midee mapoo egei biame omaga simi dugo bakadio olo poogooso. Esiga ayo mo odoo mapoo takolone, giso holaiso dugo bakadio poogoo sabolo osoloso dima hamamee soolooga magoo sabolo piligiye daga, holope egee sabolo wooloomalaiso,” diso. Esiga yayo o odoo mapoo to kitulugu teneeso, diayo Betilihem mi mapoo osoloso mi pepuso abo koola mapoo bumo di, omapoo dileso giso holaiso pepuso susuga piligilame. Eseme diayo dileso giso holaiso dugo bakadio osoloso dima hamamee soolooga magoo sabolo piliguso. ");
INSERT INTO kkc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Esiga goo hagoso peledoboome Godee maga to toloso kokodo takomo sili odoo Yelemayaye taka to sabolo teibaso. Bei, yayo egeesee hoguguso, ");
INSERT INTO kkc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Diya gooheleme Lama mi ee ma kuloduga pisa ee duso. Bei, sobo Laiseleeye owolo dio halo ka pusumo siloso. Esiga yo pisa koo koodobuoso. Bei, owolo dio susuga olo piliguga.” ");
INSERT INTO kkc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yosep Isipi mi mapoo osee badoboome, wiligi odoo taba Helodee taso. Eseme Yosep tiamolome sapootia mapoo Godeeyo momaiye oso sibileso yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“No hogabuloso holope sabolo owee sabolo gilimadoloso Isalael mi mapoo see wedi di. Bei, giso holo egee wooloomalame esieli odoo egee bia olo wediaso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eseme Yosep to hagee duloso, holope sabolo owee sabolo gilimadoloso see Isalael mi mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Esino Helodee teme, see owolo Akaleyoseeye Yudiya mi mapoo wiligi odoo toboloso badebeiso. Eseme Yosep goo hagee duloso mi omapoo dilei ebiaso. Eseme sapootia mapoo Godeeyo momaiye oso see tobu sibileso yimapoo egeesee takaso, “No Yudiya mi mapoo na di,” diso. Yosep yo momaiyeso egeesee taka duloso see Gelili mi toowa ma kulodu Nasalet mi pepooko mapoo badalame diso. Esiga Godee maga to toloso kokodo takomo silesibili odoo oso taka to sabolo teibaso. Bei, diayo egeesee takaso, “Edebeeyo yo Keliso dolone Nasalet odoo dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Osoloso Yesu Nasalet mi mapoo badoboome, Yonee odoo howo oluguli odoo oso sibileso Yudiya miwe poogoo mi mapoo Godeeyo to egeesee takomo siliso, ");
INSERT INTO kkc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Niba goo goolee su wudoloso nibada tokenee maga miligi pie. Bei, Godeeye wiligi doloso badeli goo oso sibilei olo koola tooboo,” dee takomo siliso. ");
INSERT INTO kkc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Esiga Yonee odoo howo oluguli odoo eyo goo maga Godee maga to toloso kokodo takomo sili odoo Aisayaye egeesee takaso, “Odoo heeso miwe poogoo mi omaga egeesee idagoo, ‘Lodeeye sibilei eli moodee. Osoloso o eli medee hoodo magee,’ dee takomoloso.” ");
INSERT INTO kkc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yonee yo kemol be too oso dugo dusa kaloso silone, gala koloso bagi mapoo gudu masi kaloso siliso. Osoloso nei yayo nali ee tapala sabolo koo sabolo nali. ");
INSERT INTO kkc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Odoo susuga oso Yelusalem abaga osoloso Yudiya abaga osoloso Yoden howo palaga debeli mi maga Yoneeye taka to ee dulame sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Diba Yoneeye taka to ee duloso dibada goo tokenee yilige bugume, Yoneeye diba Yoden howo mapoo howo oluguso. ");
INSERT INTO kkc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Esino Yoneeye odoo howo olugumolome, Pelisi odoo susuga sabolo osoloso Sedisi odoo susuga sibileso omapoo peledabaso. Eseme Yoneeye diba ogoloso dimapoo egeesee takaso, “Niba hebise, nimapoo odoo agayo takolone, niba Godeeye kamana goo egee sibo maga mada pia dabalai teiba, dee ka takana? ");
INSERT INTO kkc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Esiga niyo debei goo maga nibada goo tokenee mapoo tei miligi pia goo ee eligi. ");
INSERT INTO kkc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Osoloso niba niso nediliyo niba Eibalahameeyo amawe dioga, Godeeye kamana goo maga mada pia dabalaiso, dee na goolee. Bei, ayo nimapoo taka. Godee yimapoo kitulugu moloso, yo hagoso see Eibalahameeyo amawe dio palai. ");
INSERT INTO kkc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Esiga kabee homo bei mapoo olo magoo moloso. Esiga homo kaso ko tekepo pelega mologa, homo egee holoso dou mapoo toodalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nibada goo tokenee goo mapoo miligi pia maga ayo niba wulo howodee mapoo oluguso. Esino odoo ama hamamee egee sibo oso Dio Tei nima kulodu tenelaiso. Osoloso yayo yimapoo tei tele poogoo odoo ee dou mapoo toodalaiso. Esiga yayo kitulugu oso a dagadi. Esiga ayo o homo mapoo kali bi ee todilei a tebile. ");
INSERT INTO kkc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yayo witi wo ko sabolo osoloso so ee pilame o tou teli bi mopoodoo doloso badoso. Osoloso witi wo ko ee mosopoo kukuleiso. Osoloso witi wo so ee dou koo semili mapoo toodalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Biame domo omapoo Yesu Gelili mi maga Yoden howo mapoo Yoneeye yo howo olugulame simiso. ");
INSERT INTO kkc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Esino Yoneeye Yesu yo howo olugulei gowoolone yimapoo egeesee takaso, “Bei kasi maga no ayo howo olugulame amapoo ka simiyo? Nayo a howo olugulei tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eseme nei Yesuye yimapoo egeesee takaso, “Epedee hamapoo nayo a howo olugulei tekepo. Bei, goo hagee Godeeye goomoga goo oso,” diso. Eseme Yonee to hagee duloso Yesu howo oluguso. ");
INSERT INTO kkc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Osoloso Yesu howo oluguloso gasibileso tobudulone egeino, Kei mi osulu yamagoloso Dio Tei oso molo masi pusibileso yimapoo pubalegeme egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eseme Kei mi ma dokodooga toso egeesee taka, “Hagee ayo diya gooma mo Holo oso. Ayo yimapoo diya goomogo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Osoloso hamamee bo holo dia wiligi odoo Saitenso Yesu kukulo agalame, Dio Tei oso Yesu miwe poogoo mi mapoo ido palaso. ");
INSERT INTO kkc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yo biame 40 osoloso gesi 40 ee ma kulodu nei nelega sileeme yo diya hodiaso. ");
INSERT INTO kkc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eseme kukuli odoo Saitenso sibileso Yesu mapoo egeesee takaso, “No tei Godeeyo owolo daga, nayo yo hagoso see wo pe dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Esino Yesuye nei egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Edebeeyo hedebe nei nolone badoga, gie badeli talaime. Esino Godeeyo to wo masi nolone badoga, yo gie badeli talaiso,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eseme Saitenso see Yesu idoloso Godeeyo hu dokodoo poudili mi Yelusalem mapoo ido diso. Osoloso tei moso tegei omu ma dokodoo ido peleso tobudume yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“No tei Godeeyo owolo daga, no moso omu ma dokodooga miyomoo bologobigi. Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Godeeye o momaiye mapoo, no medee bamelee, dalaiso. Egeeseega diayo no dia deeso douguleiso, no yo mapoo homodobiyaga.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Eseme Yesuye nei egeesee takaso, “Godeeyo to booka mapoo hogugu oso see tobu egeesee takooso, ‘Nee wiligi odoo Godeeye taka to ee dada beleso agalame yimapoo na kukulo ege,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Osoloso Saitenso Yesu see mubi toowa ma dokodoo ido palaso. Osoloso yayo mi edebeeyo bia susuga oso toowa di sabolo osoloso oso tekepo ee yimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eseme Saitenso yimapoo see egeesee takaso, “Nayo amapoo gasuwoloso a dokodoo poudoga, mi susuga hagee ayo namapoo tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eseme Yesuye yimapoo egeesee takaso, “Saiten, no amaga peegoo di. Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘No hedebe nee wiligi odoo Godee mapoo gauwuloso o hu dokodoo poudoolone o to mapoo ka mesimo sile,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eseme Saitenso Yesu poogoloso diso. Eseme Godeeyo momaiyeso sibileso Yesu pidiso. ");
INSERT INTO kkc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yonee odoo howo oluguli odoo ee neliga moso ma kulodu magoo goo ee duloso, Yesu see Gelili mi toowa ee ma kulodu o midee Nasalet mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Osoloso yo Nasalet poogoloso see Kapeniyum mi mapoo badalame diso. Kapeniyum mi hagee Gelili abei palaga mapoo doso. Mi egee bala bakadio Sebulun dio osoloso Naptali egee bia dia mi. ");
INSERT INTO kkc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Godee maga to toloso kokodo takomo sili odoo Aisayaye taka to sabolo tebilame goo hagoso tei peledabaso. Bei, yayo to egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Gelili odoo, niba Yu odoonee sabolo doso. Nibada mi Yoden howo hodiokoo Gelili abei palaga mapoo moloso. Osoloso odoo aboso nibada mi ee Sebulun sabolo osoloso Naptali sabolo dia mi deliso. Esiga niba mo to dui. ");
INSERT INTO kkc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Neliga ma kulodu debeli odoo, niba gadeebugu toowa agalaiso. Osoloso odoo susuga oso teli mi mapoo debeli odoo, nimapoo gadeebugu toowa oso pounileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Osoloso biame domo omapoo Yesuye Godeeyo to takalame bei mooloogoolone egeesee takomo sileeso, “Nibada goo goolee su wuduloso nibada goo tokenee maga miligi pie. Bei, Godeeye wiligi doloso badeli goo oso sibilei olo koola toobooso,” dee takomo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Biame heeso Yesu Gelili abei palaga maga dimeleeno, di kebili odoo bakadio Saimon dio osoloso omolo Endulu dio egeiso. Saimonowo hu hee Pita. Eseme diba dia pei howo kulomoo ogusamo silesibume, Yesuye sibulone diba egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eseme dimapoo egeesee takaso, “Niba ama hamamee deedee sibe. Niba daga di kebigeli odoo doloso debeiso. Esino see epedee biame domo hamaga niba see odoo susuga Godee mapoo gilimadoloso sibili odoo doloso dabalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eseme diba to egee duloso dia pei omapoo saga poogoloso Yesubolo hodobo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Osoloso diba omaga dulone egeino, di kebili odoo Sebediyo owolo bakadio Yemes dio osoloso omolo Yonee dio egeiso. Dibada amabolo du ma kulodu pei mopoodoolone debeiso. Eseme Yesuye dimapoo egeesee takaso, “Niba ama hamamee deedee sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eseme diba to ee duloso dibada pei sabolo osoloso dibada ama sabolo du ma kulodu saga poogoloso Yesubolo hodobo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Esiga Yesuye Gelili mi toowa ma kulodu mosobia susuga mapoo silone, dibada howo gisili moso susuga ma kulodu to tekepo Godeeye wiligi doloso badeli eyo goo ee eligimo sileeso. Egeeseemo silone odoo paigiga susuga sabolo tekepo moodoogamo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eseme Gelili mi hodiokoo mi toowa Siliya deli omapoo debeli odoo oso yayo goo moodoomo silee goo ee duso. Goo egeesi maga odoo susuga oso paigiga opusomo opusomo di odoo ee Yesuye tekepo palame yayo badebei mapoo iyado sibadeeso. Esiga paiye opusomo opusomo di oso too odoo hagee diayo Yesu mapoo iyado sibadeeso. Odoo aboso odoo dala toowa too ee iyado simiso, osoloso odoo aboso odoo bo holo paladee iyado simiso, osoloso odoo aboso odoo todili iyado simiso, osoloso odoo aboso odoo su kakawa poogoo iyado simiso. Eseme Yesuye diba susuga tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Osoloso odoo mooloogoodoo bei oso Gelili abaga osoloso Dekapolisi abaga osoloso Yelusalem abaga osoloso Yudiya abaga osoloso mi abo Yoden howo hodiokoo debeli mi maga Yesuye badebei mapoo sibileso yima hamamee deedee diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuye odoo mooloogoodoo bei oso yimapoo sibadee ogoloso, mubi ma dokodoo peleso biaso. Eseme o hamamee dili odoo oso yimapoo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eseme omapoo yayo Godeeyo to dimapoo eligilame bei mooloogoolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Edebeeyo Godeeye diba pidilame yimapoo kibiloso doga, diba goomoga sabolo dabalaiso. Bei, diba Godeeye wiligi doloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Osoloso edebeeyo goohele sabolo pupusigilone doga, diba goomoga sabolo dabalaiso. Bei, Godeeye diba pidileiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Osoloso edebeeyo mesie sabolo doga, diba goomoga sabolo dabalaiso. Bei, hamamee mipoo susuga hagee dibada mi dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Osoloso edebeeyo goo tekepo Godeeye goomoga goo ee talai ono diya goolee sabolo doga, diba goomoga sabolo dabalaiso. Bei, diayo Godeeye goomoga goo ee talame, yayo diba pidileiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Osoloso edebeeyo emegei sooloo dolone doga, diba goomoga sabolo dabalaiso. Bei, nei Godeeye dimapoo sooloo dolone badalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Osoloso edebeeyo hedebe Godee mapoo goo hoodolone doga, diba goomoga sabolo dabalaiso. Bei, diayo Godee agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Osoloso mesie dabalame segeli odoo doloso doga, diba goomoga sabolo dabalaiso. Bei, Godeeye diba owolo dio dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Osoloso edebeeyo Godeeyo howo woola goo tekepo too maga dala tolone doga, diba goomoga sabolo dabalaiso. Bei, diba Godeeye wiligi doloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Osoloso niyo amapoo tei too goo maga edebeeyo nimapoo to tokenee takoloso dala tenelone nimaga gamenee goo takooga, niba goomoga sabolo dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Esiga niba sigabolone goomege. Bei, Kei mi mapoo nei toowa niyo talame nibada hu sabolo olo mopoodoo doloso moloso. Esiga nimapoo dala tenelone egee do egee dia amawe diayo Godee maga to toloso kokodo takomo silesibili odoo daga hoogoo debei mapoo dala hedebe egeesee tenemeleeso.” ");
INSERT INTO kkc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mi toowa mapoo debeli odoo mapoo niyo solu masi ka doso. Esino soluso hadali me poogooga, nayo solu ee see hadalame kasee moodoolaiyo? Esiga solu hadali me poogooga, yo goo mauwe malaiso. Osoloso mi mapoo togobuguga, edebeeyo dokodooga homoso ebidileiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Esiga mipoo toowa hamapoo debeli odoo susuga mapoo niyo gadeebugu masi ka doso. Bei, mubi ma dokodoo mi edebeeyo bia mologa, mi egee mada malaime. Haye. Yo medee woola molo egeliso. ");
INSERT INTO kkc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Esiga odoo heeso keme pouloso tolo oso koo gagali. Haye. Yo keme pouloso odoo susuga oso o moso kulodu dobolone gadeebugu ee agalame woola pou mageliso. ");
INSERT INTO kkc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Egeesi maga niyo mipoo toowa hamapoo debeli odoo mapoo gadeebuguloso dabalai tekepo. Egeeseega odoo susuga oso niyo goo tekepo tolone egee do ogoloso diayo nibada Ama Godee Kei mi ma dokodoo egee bado o hu dokodoo poudileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Esiga Moseseeye tei magoo hogugu sabolo osoloso Godee maga to toloso kokodo takomo silesibili odoo oso Godeeyo to hogugu ee ayo peegoo magalame ka simidoo, niyo dee na goolee. Haye, ayo egeesee selame ka sibile. Esino ayo wulo diayo taka goo susuga ee tobuloso talame ka simi. ");
INSERT INTO kkc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Esiga ayo nimapoo taka. Mipoo toowa sabolo kei sabolo mauwe pegelega osee mologa, Godeeye tei magoo ma kulodu hu bei pepuso heeso peegoo osugobalaime. Esino tei oso taka goo susuga oso tobuloso peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Esiga edebeeyo Godeeye tei magoo ma kulodu tei pepooko hedebe mapoo mesilega badolone, emegei dimapoo goo egeesi masi moodoolame eligimo siloga, yo Godeeye wiligi doloso badeli mapoo diya pepooko doloso badalaiso. Esino edebeeyo Godeeye tei magoo susuga mapoo mesiloso badolone, emegei dimapoo goo egeesi masi moodoolame eligimo siloga, yo Godeeye wiligi doloso badeli mapoo toowa doloso badalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Esiga ayo nimapoo taka. Niyo Godeeye tei magoo mapoo mesie goo oso tei eligili odoo sabolo, osoloso Pelisi odoo sabolo oso Godeeye tei magoo mapoo mesili goo ee dagadilega poogooga, niba Godeeye wiligi doloso badalaime.” ");
INSERT INTO kkc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Esiga Godeeye olo daga hoogoo ibada amawe dimapoo to egeesee taka goo ee niba olo duso, ‘Emegei bei mauwe wooloomalai tei. Esiga edebeeyo emegei bei mauwe wooloomaga, o goo midileiso.’ ");
INSERT INTO kkc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Esino goo hamaga ayo see egeesee takooso. Edebeeyo emegei dimapoo kamana sabolo badoga, yo goo midili mapoo ido palaiso. Osoloso edebeeyo emegei dimapoo no tokenee odoo daga, niyo yo wiligi odoo tebisa dimapoo ido peleso o goo midilei tekepo. Osoloso edebeeyo emegei dimapoo no boobada odoo daga, yo nei Dou mi mapoo toodalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Esiga nayo Godee mapoo emegei di bi tenelame badolone epedee omapoo nee odoo oso namapoo egee gowoomolo gooleebuguga, nee emegei di bi ee omapoo magoloso see saga dileso nee odoo omapoo emegei di to takee. Osoloso see wedi sibileso emegei di bi egee Godee mapoo tenee. ");
INSERT INTO kkc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Esiga namapoo goweli odoo oso no goo midilei mapoo ido duga, no eli domopoo yibolo dulone yayo namapoo gowe egee molo pagalame yibolo saga emegei dee. Esino nayo goo egeesi moodelega poogooga, yayo no goo midili odoo mapoo ido peleso nee goo midileiso. Egeeseega goo midili odoo oso no neliga moso gibadeli odoo mapoo tenelaiso. Egeeseega see yayo no neliga moso ma kulodu toosoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Esiga ayo namapoo taka, no neliga moso ee ma kulodu badolone nayo peegoo dilei eli agalaime. Esino molee yayo hesia sabolo tobuloso nayo yimapoo teneega, no peegoo dileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Esiga niba to egeesee taka olo duso, ‘Adaba kooka sobo sabolo kooka giso sabolo goo heli talai ee tei,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Esino ayo nimapoo egeesee takooso, edebeeyo emegei dia kooka sobo mapoo howo todolone goo goolee ma kuloduga yibolo goo heli talame gooleega, o goo goolee oso yo sobo egee olo goo heli tooso. ");
INSERT INTO kkc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Esiga nee howo deedee oso no goo tokenee talame gido duga, nee howo deedee egee tabigilei tekepo. Bei, nee howo bakadio sabolo badolone Dou mi mapoo dilei tekeponee. Esino nayo howo hedebe sabolo Kei mi ma dokodoo gadilei tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Osoloso nee dee deedee oso no goo tokenee talame gido duga, nee dee deedee ee kobigilei tekepo. Bei, nee dee bakadio sabolo badolone Dou mi mapoo dilei tekeponee. Esino nayo dee hedebe sabolo Kei mi ma dokodoo gadilei tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Osoloso niba to egeesee taka olo duso, ‘Edebeeyo osobo pagalame gooleega, yo sobo pegeli peipa mapoo to hoguguloso osobo mapoo tenee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Esino ayo nimapoo goo hamaga egeesee takooso, nosobo na peegee. Esino kooka sobo agayo giso hee sabolo goo heli too daga, yayo osobo egee pagalai tei mauwe. Esino yayo wulo goo hee maga osobo poogooga, yayo osobo ee goo tokenee mapoo gido duso. Bei, sobo ogoso giso hee mapoo obuoga, yo odoo heeyo giso ee peedee huso. Osoloso edebeeyo sobo omoye poogoo ee huga, yo odoo heeyo osobo ee peedee huso.” ");
INSERT INTO kkc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Osoloso daga hoogoo ibada amawe dimapoo to egeesee taka ee niba olo gooleedooso, ‘No goo tei moodoolame Godee mapoo tei magooga, tei egee na gababie,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Esino ayo goo hamaga see egeesee takooso, no goo hee moodoolame tei na ye. Esiga no Kei mi eyo hu hesialoso tei na ye. Bei, mi egee Godeeye wiligi doloso badeli oso. ");
INSERT INTO kkc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Osoloso mipoo toowa eyo hu hesialoso tei na ye. Bei, mi egee Godeeye o homo kokusoloso badeli mi oso. Osoloso Yelusalem mi eyo hu hesialoso tei na ye. Bei, mi egee wiligi odoo Godeeyo mi oso. ");
INSERT INTO kkc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Osoloso nee wiligi mapoo sigolone tei na ye. Bei, nayo egee takoo goo oso nee wiligi ma kulodu wudu heeso opusomo dalai tebile. ");
INSERT INTO kkc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Esiga odoo heeso nimapoo sibileso takolone tou hagee teye dee takooga, niyo goo egee talai goomogoga, yimapoo hedebe niyo goomoga goo ee takee. Osoloso niba goo ee talai gowooga, niyo hedebe gowe goo ee takee. Bei, niyo egeesee selega poogooga, niba gamenee takooso. Esiga gamenee takeli goo ee Saiten maga siboso.” ");
INSERT INTO kkc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Osoloso niba to egeesee taka olo duso, ‘Odoo heeso no woolone nee howo tabuguga, nei odoo o howo tabigilei tekepo. Osoloso see odoo heeso nee maga mapoo woolone mei hedebe dobuguga, nei o mei dobigilei tekepo.’ ");
INSERT INTO kkc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Esino ayo goo hamaga see egeesee takooso, no odoo heeso namapoo tokenee goo kasee moodooga, nayo yimapoo nei goo egeesi masi na moodee. Esiga odoo heeso nee haleegi mapoo kobuguga, see nee haleegi hodio mapoo kobugulame heligi magalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Osoloso edebeeyo nee sedi talame goomogolone no goo midili mapoo ido duga, nayo nee sedi egee sabolo osoloso nee kekeisu dugo sabolo yimapoo tenee. ");
INSERT INTO kkc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Osoloso odoo heeso o bi kadaloso yibolo mi hee koola mapoo dilame sibileso no giga, see nayo yibolo hodobo o bi eli sage kadadilei tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Esiga edebeeyo namapoo bi howaga, yimapoo wulo tenee. Osoloso edebeeyo namapoo bi hoowadalai goomogoga, yimapoo tenee.” ");
INSERT INTO kkc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Esiga niba to egeesee taka olo duso, ‘Nee odoo sooloo dolone namapoo ha teli odoo hegie,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Esino ayo goo hamaga nimapoo egeesee takooso, nimapoo ha teli odoo ee sooloo dele. Egeeseelone nimapoo dala teneli odoo halo Godee mapoo takolone ka debee. ");
INSERT INTO kkc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Esiga niyo goo hageesee tolone doga, goo oso niba tei ibada Ama Kei mi ma dokodoo badeli Godeeyo owolo dio doloso egee do goo ee ka eligiso. Egeesi ma kulodu Godeeyo howo woola tekepo debeli odoo sabolo osoloso tokenee teli odoo mapoo osoko pa sabolo howo sabolo tobuloso tenemoloso. ");
INSERT INTO kkc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Esiga niba hedebe nimapoo sooloo deli odoo ee sooloo dolone doga, niba nei tekepo talaisomo? Haye, talaime. Bei, tokenee teli odoo sabolo egeesee seliso. ");
INSERT INTO kkc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Osoloso niyo hedebe nee odoo mapoo mo odoo dolone badoga, egee goo tekepowo? Haye, peegoo debeli odoo sabolo goo hageesee teliso. ");
INSERT INTO kkc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Esiga nibada Ama Godeeye odoo susuga sooloo dolone egee bado egeesi masi niba nosee odoo susuga sooloo dolone ka debee.” ");
INSERT INTO kkc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Esiga niba wulo edebeeyo agalame goo tekepo na tomo silesibe. Bei, goo hageesee tomo silesiboga, nibada Ama Godee Kei mi ma dokodoo badeli maga nei talaime. ");
INSERT INTO kkc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Egeesi ma kulodu niba bi mauwe odoo mapoo bi teneega, odoo howo woola na tenee. Bei, goo goolee bakadio gweli odoo oso odoo susuga oso hedebe diba tekepo doloso takalame, diayo goo hageesee howo gisili moso mapoo osoloso mosobia domopoo tomo silesibiliso. Esiga ayo nimapoo taka. Diayo goo egeesi tomo silesibume, odoo susuga oso diba ogoloso goomogolone egee do maga dibada nei tolone ka doso. Esiga diba Godee maga nei hee talaime. ");
INSERT INTO kkc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Esiga nayo bi mauwe odoo mapoo bi tenelame gooleega, nayo dimapoo mada tenee. Egeeseega Nama Godeeye nayo mada tekepo goo egee tomolo ogoloso namapoo nei tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Esiga niyo Godee mapoo takolone goo goolee bakadio gweli odoo masi na debee. Bei, diba odoo susuga oso agalame, mosobia domopoo osoloso howo gisili moso ma kulodu malalo peleso tebisamolone Godee mapoo takalai, diba goomegeliso. Esiga ayo nimapoo taka. Diayo goo egeesi tolone egee do maga diba nei tolone doso. Esiga diba Godee maga nei hee talaime. ");
INSERT INTO kkc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Esino nayo Godee mapoo takalame gooleega, nee moso ma kulodu gadileso osulu kisiloso edebeeyo koo egeli Nama Godee mapoo ka takee. Egeeseega nayo mada yimapoo egee takomolo ogoloso yayo namapoo nei tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Osoloso niyo yimapoo takolone Godeeyo goo gooleedele poogoo odoo oso dibada godee mapoo takeli egeesi masi takolone na debee. Bei, diayo Godee mapoo taka ee ma kulodu goo mauwe to diya sage takeliso. Bei, diayo goolee diayo sage takooga, dia godeeso duleiso, dee gweliso. ");
INSERT INTO kkc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Esiga niyo diba egeesi masi goo mauwe Godee mapoo takolone na debee. Bei, niyo goomoga goo ee nibada Ama Godee yayo malalo olo gooleedoloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Esino niyo Godee mapoo takooga, hageesee takee, ‘Ibada Ama Kei mi ma dokodoo badeli, biame susuga ma kulodu hedebe nee hu oso toowa doloso mele dee, odoo susuga oso dokodoo poudalame. ");
INSERT INTO kkc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Esiga nayo wiligi doloso badeli goo oso sibilei iba goomogo. Osoloso Kei mi mapoo nayo goomoga goo egee tomolo goo ee see mipoo hamapoo debeli odoo oso tolone ka dabalame. ");
INSERT INTO kkc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Osoloso biame susuga ma kulodu nei iyo nalai imapoo tenee. ");
INSERT INTO kkc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Osoloso ibada goo tokenee hapoloso boobado bigi. Bei, iba nosee odoo susuga oso goo tokenee susuga imapoo moodeli ee boobado bigiliso. ");
INSERT INTO kkc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Osoloso iba goo tokenee mapoo na gido di dee. Esino iba Saitenso kitulugu omaga peegoo gilimado di. Bei, nayo wiligi doloso badeli goo sabolo, osoloso nayo kitulugu egee molo sabolo, osoloso nee hu oso toowa doloso kookaiyo moloso osee malaiso. Hagee tei goo.’ ");
INSERT INTO kkc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Esiga odoo aboso nimapoo tokenee goo moodooga, niyo dia tokenee ee boobado bigi. Niyo egeeseega, nei nibada Ama Kei mi ma dokodoo egee bado oso nibada goo tokenee hapoloso boobado bigileiso. ");
INSERT INTO kkc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Esino odoo aboso nimapoo goo tokenee moodooga, niyo dia tokenee ee boobado bigilega poogooga, nei nibada Ama oso nibada goo tokenee ee hapoloso boobado bigileime.” ");
INSERT INTO kkc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Osoloso niba nei tei doloso Godee mapoo takolone dobolone, goo goolee bakadio gweli odoo oso moodeli egeesee na moodee. Bei, diba nei tei doloso dobolone, mudu poudoloso debeliso, odoo susuga oso diba nei tei doloso debei ee ogoloso gooleedalame. Esiga ayo nimapoo taka. Diayo goo egeesi moodoolone egee do maga, edebeeyo dia hu dokodoo olo poudooso. Goo egeesi maga Godeeye dimapoo nei hee tenelaime. ");
INSERT INTO kkc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Esino no nei tei doloso badolone Godee mapoo takalame gooleega, nee mudu howo hapoloso wudu guloso ka badebee. ");
INSERT INTO kkc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","No egeesee badoga, odoo susuga oso nayo nei tei doloso egee bado goo ee diba gooleedalaime. Esino odoo susuga oso koo egeli Nama Godeeye nayo mada nei tei doloso egee bado goo ee ogoloso namapoo nei tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Esiga niba mi toowa hamapoo haga bi bei mooloogoo magoloso na debee. Bei, mi toowa hamapoo nibada bi abo siso naliso. Osoloso abo emisia ki nadoloso tokenee peliso. Osoloso abo heli teli odoo oso gasibileso heli teliso. ");
INSERT INTO kkc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Esino niba Godeeye goomoga goo ee tolone ka debee. Niyo egeesee seega, Godeeye Kei mi mapoo nei nimapoo tenelaiso. Mi omapoo siso nee bi koo nali, osoloso mi omapoo bi emisia ki nadoloso koo tokenee peli, osoloso heli teli odoo oso gasibileso nee bi heli koo teli. ");
INSERT INTO kkc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nimapoo bi bei toowa ma mologa, nibada goo goolee oso omapoo meliso. ");
INSERT INTO kkc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Esiga nee su mapoo nee howo oso keme masi ka moloso. Osoloso nee howo oso tekepo mologa, nee su susuga gadeebugu malaiso. ");
INSERT INTO kkc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Esino nee howo oso tokenee poga, nee su susuga neliga malaiso. Egeesi ma kulodu namapoo gadeebugu egee molo semidiloso badoga, no tei diya neliga ma kulodu badoso. ");
INSERT INTO kkc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Esiga edebeeyo wiligi odoo bakadio eyo to mapoo mesiloso silone tou talai tebile. Bei, yo o wiligi odoo hee goomogolone hee gowoolaiso. Egeeseelone yayo wiligi odoo heeyo to mapoo mesiloso silone, see heeyo to mapoo mesileime. Esiga niyo Godee mapoo mesimo silone molee toowa toloso badalai goo mapoo mesilei tebile.” ");
INSERT INTO kkc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Esiga ayo nimapoo taka, niyo dobolone nei nalai sabolo osoloso howo nalai sabolo osoloso dugo kalai sabolo omapoo haga na goolee. Bei, nei nalai bi oso goo toowa koo moloso. Haye. Esino nibada gie badeli goo oso goo toowa ka moloso. Osoloso kali bi oso goo toowa koo moloso. Haye. Esino nibada su oso goo toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Esiga niba só ogoloso goolee. Diba nali bi dieso sogoloso koo gooloogali. Osoloso diba nei nali bi magalai moso mauwe. Esino nibada Ama Godeeye Kei mi ma dokodoo egee bado oso dimapoo nei nali bi ka tenemoloso. Esino Godeeyo howo woola só oso goo toowa koo moloso. Esino niyo goo toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Esiga edebeeyo kali bi sabolo osoloso nei nali bi sabolo omapoo diya gooleega, o gie badeli see hoogoo sagelisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Esiga niba kasi maga kali bi mapoo haga goolee sabolo ka dabala? Esino niba dobudu meli palapalawa tekepo ogoloso goolee. Bei, diba dieso nediliyo pidilame tou koo teli. Osoloso dugo dieso kalai koo duseli. ");
INSERT INTO kkc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Esiga ayo nimapoo ka taka, daga Solomonoye wiligi odoo toboloso badebei mapoo yayo kali bi medee tekepo kalaga meleeso. Esino dobudu meli palapalawa oso tekepo oso dugo tekepo Solomonoye kali ee dagadi. ");
INSERT INTO kkc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Esiga dobudu meli palapalawa tekepo oso epei bou gasibileso moloso, see biame hee mapoo wooseliso. Esino Godeeye palapalawa omapoo dugo masi tekepo ka kadili daga, a tei toso, Godeeye nimapoo dugo tekepo tenelaiso. Bei, niyo Godeeyo howo woola goo toowa ka moloso. Odoo niba tei too kibile. ");
INSERT INTO kkc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Esiga niba goo koudulone dobolone egeesee na goolee, ‘Iyo nei sabolo howo sabolo kamapoo talaisoba? Osoloso iyo dugo kalai bi kamapoo talaisoba?’ dee na goolee. ");
INSERT INTO kkc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bei, peegoo debeli odoo oso bi hageesi maga diya goolone debeliso. Esino Nama Godeeye bi niyo talame goomegeli ee yayo malalo olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Esiga niba Godeeye wiligi doloso badeli goo ee goolone, daga malalo nibada Ama yayo goomoga goo ee tolone ka debee. Niyo egeeseega bi susuga niyo egee esigamolo ee nei yayo nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Esiga niba godigi gooso peledabalai mapoo goo haga koudulone na debee. Bei, godigi eyo goo ee godigi eyo goo oso. Esino niba epei eyo goo ee goolone ka debee.” ");
INSERT INTO kkc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Niyo nee odoo heeyo goo wulo goo mauwe na midi. Esino niyo egeesee midiga, nei Godeeye nibada goo onosee hedebe egeesee midileiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bei, niyo emegei dia goo kasee midiga, nei nibada goo onosee Godeeye hedebe egeesi midileiso. Niyo goo teiba hedebe egeesi midiga, nei yayo niba nosee teiba hedebe egeesi midileiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","No kasi maga nee odoowo howo mapoo gelesi pepooko egee molo medee ogolone, hee nee howo mapoo homo toowa egee molo egelega ka pagala? ");
INSERT INTO kkc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Osoloso nee howo mapoo homo toowa egee molo egelega no see kaseega nee odoo mapoo takolone, ‘Nee howo mapoo gelesi pepooko egee molo ayo tabiga,’ dee ka takeliyo? ");
INSERT INTO kkc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","No tei goo goolee bakadio gweli odoo. Bei, daga nee howo mapoo homo toowa egee molo ee tabigi. Egeeseega nee odoowo howo mapoo gelesi pepooko egee molo medee ogoloso nayo tabigilei tebileiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Godee mapoo tenelai bi ee so mapoo na tenee. Bei, soso namapoo see wedi sibileso no palaiso. Osoloso namapoo bi tekepo egee molo be mapoo na togobise. Bei, beso bi mapoo homoso tooboomo siloga tokenee palaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Esiga ayo nimapoo taka, niba woose. Egeeseega, nimapoo tenelaiso. Osoloso niba esie. Egeeseega, niyo agalaiso. Osoloso niba osulu mapoo kalamadi. Egeeseega osulu nimapoo yamagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bei, woosali odoo oso goo talaiso. Osoloso esieli odoo oso goo agalaiso. Osoloso osulu mapoo kalamadili odoo mapoo osulu yamagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Esiga edebeeyo owoloye wo nalame woosaga, yimapoo yo tenelaisomo? ");
INSERT INTO kkc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Osoloso yayo see di nalame woosaga, nayo yimapoo sa tenelaisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niba tokenee odoo, esino niyo nibada owolo dimapoo bi tekepo tenelai goo ee niba gooleedooso. Esiga ibada Ama Godee Kei mi ma dokodoo egee bado yayo yimapoo bi woosali odoo mapoo bi tekepo teneli goo ee niba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Niba edebeeyo goo hee nimapoo moodoolame goomogoga, daga niyo dimapoo goo egee moodee. Bei, Moseseeye eligi goo sabolo osoloso Godee maga to toloso kokodo takomo silesibili odoo oso to hogugu oso eligi goo eyo bei hagoso.” ");
INSERT INTO kkc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Esiga osulu pepooko maga gadi. Bei, Dou mi mapoo dili osulu ee diya toowa osoloso eli onosee diya toowa. Egeesi maga odoo bei oso osulu omaga galagadileso eli omaga ka diyadaga moloso. ");
INSERT INTO kkc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Esino gie badeli mapoo gadili osulu ee diya pepooko. Osoloso eli omapoo dili onosee diya pepooko. Esiga odoo aboso eli egee ogoloso omaga ka diyadaga moloso.” ");
INSERT INTO kkc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Niba obeeyamo! Gamenee goo eligili odoo medee ege. Bei, diba kolo ma dokodooga odoo tekepo masi nimapoo sibiliso. Esino dibada kulodu dobu so kamanali egeesi masi nimapoo sibiliso. ");
INSERT INTO kkc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Esiga niba diayo suso goo moodoo maga diayo egee do goo ee ogoloso gooleedeliso. Bei, pigi ko sabolo osoloso geleipi ko sabolo we ti maga ko koo peeya. ");
INSERT INTO kkc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Esiga homo su tekepo oso homokoko tekepo peliso. Osoloso homo su tokenee oso homokoko tokenee peliso. ");
INSERT INTO kkc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Esiga homo su tekepo oso homokoko tokenee koo peeya. Osoloso homo su tokenee oso homokoko tekepo koo peeya. Haye. ");
INSERT INTO kkc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Egeesi ma kulodu homo su kaso homokoko tekepo pelega mologa, homo egee heemagoloso dou mapoo toodalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Esiga gamenee goo eligili odoo ee diayo goo moodoo maga dia goo ee ogoloso niba gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Esiga haga odoo susuga oso amapoo Lodee, Lodee dolone egee do oso Godeeye wiligi doloso badeli mapoo gasibileime. Esino odoo agayo mo Ma Godee Kei mi ma dokodoo egee bado yayo goomoga goo ee tomo siloga, hedebe odoo egee bia oso gasibileiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Esiga goo midili biame mapoo odoo aboso sibileso amapoo egeesee takalaiso, ‘Lodee, Lodee, iyo nee hu maga Godeeyo to takomo silesibiliso, osoloso nee hu maga odoo bo holo paladee peegoo hasiso bugu dolone silesibulone goo toowa opusomo di moodoomo silesibiliso,’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Esino nei ayo dimapoo egeesee takalaiso, ‘Niba a gooleedele. Esiga niba amaga peegoo diyadee, niba tokenee teli odoo,’ dee takalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Edebeeyo to ayo eligi duloso mesiloso siloga, yo odoo goo medee gweli oso moso tegelame mi nelegedi dooloso omou sooloso moso tegei odoo egeesi masi badoso. ");
INSERT INTO kkc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bei, i sabolo howo sabolo simiso, osoloso howo duwa oso o moso mapoo weino, moso egee kibiya meleeso. Bei, moso omou mi nelegedi doloso omou ka sooga. ");
INSERT INTO kkc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Esino edebeeyo to ayo eligi duloso mesilega siloga, yo odoo goo medee koo gweli oso moso tegelame mi nelegedi doolega omou sooloso, moso tegei odoo egeesi masi badoso. ");
INSERT INTO kkc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bei, i sabolo howo sabolo simiso, osoloso howo duwa oso o moso mapoo woome, moso egee kibilega saga goboloso guobuguso.” ");
INSERT INTO kkc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuye goo hagee eligimeleso koodobume, odoo susuga yayo eligi du oso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bei, yayo eligi ma kulodu tei eligili odoo oso eligi egeesi masi koo eligime. Esino yayo odoo diya kitulugu oso eligi masi eligiso. ");
INSERT INTO kkc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu mubi ma dokodooga kumoo moumolome, odoo mooloogoodoo bei oso yima hamamee diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Egeesee semelee biame domo mapoo odoo agagisa bia sibileso Yesuwo homo beiyopoo ebiso miyomoo tugusaloso egeesee takaso, “Lodee, nayo a tekepo moodoolai goomogoga, a tekepo moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eseme Yesuye o deeso odoo egee sigolone egeesee takaso, “Ayo no tekepo palai a goomogo. Esiga no tekepo pe,” diso. Eseme epedee omapoo o kolo mapoo agagisa bia mauwe poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eseme Yesuye yimapoo egeesee takaso, “Nayo dileso no ayo tekepo moodoo goo ee odoo abo mapoo na takee. Esino nayo dileso Godee ogo odoo ogo doloso domo badeli odoo mapoo nee su tekepo pa goo ee ka eligi. Osoloso odoo susuga oso ogoloso no tekepo moodoo goo ee gooleedalame, nayo Moseseeye tei magoo ee dodolone, nee su tekepo moodoo omaga emegei di bi tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kapeniyum mi mapoo dileso peledoboome, Loum ha teli odoo 100 gibadeli odoo oso yo pidilame Yesu mapoo sibileso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Lodee, mo tou teli odoo hee diya paiyega su kakawoo buguloso tiamoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eseme Yesuye yimapoo egeesee takaso, “Ayo sibileso yo tekepo palaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Esino Loum ha teli odoo gibadeli odoo oso nei egeesee takaso, “Lodee, nayo mo mosopoo sibilei, a tebile. Esino mo tou teli odoo ee tekepo palame, no wulo omaga tobudulone toso idagee. ");
INSERT INTO kkc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bei, anosee odoo abo dia tou teli odoo. Osoloso odoo aboso mo tou teli odoo doloso dobolone mo to mapoo mesiloso silesibiliso. Esiga ayo mo tou teli odoo hee mapoo, ‘no koo diye’ daga, yo omapoo diliso. Osoloso see odoo hee mapoo takolone, ‘no hamapoo sibeye’ daga, yo sibiliso. Osoloso see mo tou teli odoo hee mapoo takolone, ‘no goo hagee teye’ daga, yo goo ee teliso. Esino mo tou teli odoo ee tekepo palame nayo wulo toso idagee.” ");
INSERT INTO kkc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu to hagee duloso howodolone yima hamamee sibadee odoo susuga mapoo egeesee takaso, “Ayo nimapoo taka, ayo Isalael mi mapoo silee ee ma kulodu kibiya tei too odoo hee yo egeesi egele. ");
INSERT INTO kkc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Esiga ayo nimapoo taka, mi opusomo opusomo di maga sibileso, Godeeye wiligi doloso badeli Kei mi mapoo Eibalaham, Aisek, osoloso Yekob sabolo hodobo mooloogoodoloso nei nalame dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Esino Yu odoo tei tele poogoo ee Dou mi mapoo toodalaiso. Egeeseega omapoo dobolone mei gisile sabolo pupusigilone dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eseme Yesuye Loum ha teli gibadeli odoo mapoo egeesee takaso, “No nee mosopoo di. Nayo goo peledabalaiso doloso tei too oso goo peledabalaiso,” diso. Egeesee semelee mapoo Loum ha teli gibadeli odoo o tou teli odoowo mosopoo paiyega tiamelee odoo ee olo weidooso. ");
INSERT INTO kkc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Osoloso Yesu Pitayo mosopoo diso. Yo omapoo dileso egeino, Pitayo nalobo paiyeso kolo dei moodoome tiamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eseme Yesuye sobo egeeyo dee mapoo sigime, paiye weidooso. Osoloso yo toboloso wo siloso Yesu mapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Osoloso habe omapoo odoo susuga oso bo holo paladee susuga Yesuye badebei mapoo iyado sibadeeso. Eseme yayo to kitulugu sabolo takeme, bo holo susuga odoo ma kuloduga peegoo hasiso buguloso, odoo paigiga susuga ee tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Esiga Godee maga to toloso kokodo takomo sili odoo Aisayaye daga hoogoo to taka sabolo tebilame siso. Bei, yayo egeesee takaso, “Yayo ibada paiye susuga egee molo yayo tolone iba tekepo paso.” ");
INSERT INTO kkc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuye odoo susuga oso yimapoo sibileso mooloogoodoo ogoloso, o hamamee dili odoo mapoo egeesee takaso, “Iba abei hodiokoo dalo soowoomo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Osoloso biame omapoo tei eligili odoo heeso sibileso yimapoo egeesee takaso, “Eligili odoo, nayo kamapoo dusomo, nayo di ayo hamamee deedee sileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuye nei yimapoo egeesee takaso, “Dobu soso debeli mi moloso, osoloso sóso tieseli dibada ou moloso. Esino Odoo Holo ayo tieli moso mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Osoloso odoo abo Yesu ma hamamee dadagamo silesibili ee ma kulodu odoo heeso Yesu mapoo egeesee takaso, “Lodee, a no dadalai goomogo. Esino nayo epedee amapoo biame tenee, a mo ma toga bouleiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Eseme Yesuye nei yimapoo egeesee takaso, “No a deedee sibe. Tei tele poogoo odoo ee odoo wedia masi doso. Esiga diayo dia odoo wedia eyo kou ee boulei tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Eseme Yesu o hamamee dili odoo sabolo abei mapoo meileso du mapoo dalaga poogoloso diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Diba diyadaga molome, haga booloogelega i toowa sibume, howo ki toowa simiso. Osoloso howo ki toowa oso sibulone dibada du ma kulodu howo sasooso. Esino Yesu du ma kulodu tiameleeso. ");
INSERT INTO kkc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eseme Yesu o hamamee dili odoo oso dileso Yesu tidibugulone yimapoo egeesee takaso, “Lodee, nayo iba pidi. Iba howoso nalasoo!” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Eseme Yesu yo tia hogabuloso dimapoo egeesee takaso, “Niba kaseega haga ka ebiala? Niyo tei too diya pepooko,” diso. Osoloso yayo toboloso i sabolo howo ki sabolo koodobilame to kitulugu sabolo takaso. Eseme i sabolo howo ki sabolo omapoo koodobume, abei see howo gie paso. ");
INSERT INTO kkc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eseme Yesu o hamamee dili odoo oso goo hagee ogoloso howoogadolone egeesee takaso, “Odoo hagee ogoo odoo bele? Poo sabolo osoloso howo ki sabolo oso o to mapoo duloso koodobiaso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Osoloso Yesu abei hodiokoo daboogoloso Gadala odoo eyo mi mapoo dileso peledabaso. Yo omapoo dileso peledoboome, odoo bo holo pala bakadio oso odoo bi maga yimapoo sibadeeso. Odoo bakadio hagoso halabagamo silesibulone diya kitulugu sabolo silesibume, mosobia odoo oso wedia eyo bi eli omaga koo silesibili. ");
INSERT INTO kkc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eseme odoo bo holo pala oso Yesu mapoo sibileso toso neligidi egeesee takaso, “Godeeyo owolo, nayo imapoo ogoo goo moodoolame ka simiyo? No Godeeye biame magoo mapoo sibilega wulo domo mapoo iba ee tokenee palame ka simiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Diayo tebisamelee koola mapoo be hu mooloogoodoo toowa oso mi namo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Osoloso bo holo oso Yesu mapoo howolone egeesee takaso, “Nayo iba peegoo hasiso buguga, iba be ma kulodu galaga di dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eseme Yesuye diba be ma kulodu galagadi diso. Egeesee semelee domo omapoo odoo bakadio hagee bia dia kuloduga bo holo peegoo galagadileso be ma kulodu galagadiso. Eseme be mooloogoodoo susuga oso godobia maga kukulo meileso, howomoo wediaso. ");
INSERT INTO kkc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Be bali odoo oso goo hagee ogoloso, saga o mosobia mapoo hoguo dileso be mapoo goo peledaba sabolo osoloso odoo bakadio tekepo pa goo ee oposusumo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eseme mosobia omapoo debeli odoo susuga oso Yesu agalame diyadeeso. Diba dileso yo ogoloso yimapoo howolone egeesee takaso, “No ibada mi hamaga peegoo di,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Osoloso see Yesu o hamamee dili odoo sabolo du ma kulodu meileso bulumaloso o midee Kapeniyum mapoo dalo soowaso. ");
INSERT INTO kkc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Diba omapoo dalo sooweleso peledoboome, odoo aboso odoo su kakawa poogoo ee kida mapoo tiediloso Yesu mapoo imado sibadeeso. Eseme Yesuye diayo tei too goo ee ogoloso odoo su kakawa poogoo yimapoo egeesee takaso, “Emegei, no howaleegee. Nee goo tokenee ee olo hapoloso boobado buguso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Esino tei eligili odoo abo oso Yesuye egeesee taka duloso gowoolone diesono egeesee takaso, “Odoo hagoso Godee bolo takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Esino Yesu diayo goo goolee olo ogoloso egeesee takaso, “Niba kasi maga ayo taka goo mapoo dooboo goolone diya gowoolone ka dabala? ");
INSERT INTO kkc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Niba odoo su kakawa poogoo hagee ege. Yimapoo goo kasee takalai oso sebe ka mololo? Ayo odoo su kakawa poogoo mapoo ‘Nee tokenee ayo olo boobado buguso,’ dee takooga, o tokenee boobado bugu ee niyo gooleedalaime. Esino ayo yimapoo takoo, ‘No toboloso nee kida toloso di,’ daga, yo toboloso duga, odoo tekepo peli kitulugu amapoo molo doloso niyo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Esino Odoo Holo amapoo kitulugu olo teneeso, mipoo hamapoo goo tokenee hapoloso boobado bigilei goo ee niyo ogoloso gooleedalame, ayo nimapoo eligileiso.” Osoloso yayo odoo su kakawa poogoo mapoo egeesee takaso, “No hogabuloso nee kida toloso mosopoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eseme odoo su kakawa poogoo toboloso o mosopoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eseme odoo susuga oso goo hagee ogoloso howoogadolone Godeeyo hu dokodoo poudoolone debeiso. Bei, Godeeye kitulugu hagee odoo mapoo tenee ogoloso. ");
INSERT INTO kkc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Goo hagee koodobume Yesuye dulone egeino, tekisi molee teli odoo Matiyuye tekisi molee mageli moso ee ma kulodu badoboome egeiso. Osoloso Yesuye yimapoo egeesee takaso, “Ama hamamee sibe,” diso. Eseme yo toboloso Yesuye di hamamee diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu o hamamee dili odoo sabolo Matiyuwo mosopoo peleso nei nolone doboome, tekisi molee teli odoo sabolo osoloso tokenee teli odoo oso sibileso dibolo mooloogoodoloso nei nolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Esino Pelisi odoo oso goo hagee ogoloso gowoolone Yesuwo hamamee dili odoo mapoo egeesee takaso, “Bei kasi maga nibada eligili odoo oso tekisi molee teli odoo sabolo osoloso tokenee teli odoo sabolo nei nolone ka badabala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Eseme Yesuye to hagee duloso nei egeesee takaso, “Odoo paile poogoo ee melesenee neli odoo mapoo koo diya. Esino hedebe odoo paigiga oso melesenee neli odoo mapoo ka diya. ");
INSERT INTO kkc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Esiga Godeeyo to booka ma hogugu oso egeesee takooso, ‘Emegei sooloo dolone nei pidi nei pidi dolone dabalai goo ee ayo diya gooleeso. Esino nei niyo amapoo gala hu wooloso tenelai goo ee ayo haga koo gweli,’ dee takooso. Esiga niyo dileso to hagee takoo goo eyo bei medee gooleede. Bei, ayo simi hagee, Godeeyo howo woola tekepo teli odoo ee gilimalame ka sibile. Esino tokenee teli odoo ee gilimadoloso Godee mapoo sibilame ka simi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Biame heeso Yoneeyo hamamee dili odoo oso sibileso Yesu mapoo egeesee takaso, “Ibolo osoloso Pelisi odoo sabolo Godee mapoo takolone dobolone nei tei doloso debeliso. Esino bei kasi maga nee hamamee dili odoo ee nei tei delega ka dabala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eseme Yesuye dimapoo wudu takolone nei egeesee takaso, “Sobo hulei odoo oso sobo hulame nei mopoodoo doloso o odoo gilimileiso. Egeeseega o odoo susuga sibileso gooholone nei tei doloso dabalaisomo? Haye. Diba goomoga sabolo sobo huli odoo sabolo hodobo dobolone nei nolone hodobo dabalaiso. Esino biame heeso sobo huli odoo ee dimaga peegoo ido duga, diba nei tei doloso dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesuye wudu takolone see egeesee takaso, “Edebeeyo dugo nape mapoo dugo dia koodoloso omapoo opodoloso koo dusiya. Bei, dugo egee hapoloso magooga, dugo dia oso gawoolone sesegawe oso, dugo nape ee tologodoloso ou toowa moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Osoloso see edebeeyo wain i dia katolo gout be koloso moodoo nape mapoo koo salama seeya. Bei, wain i dia oso kitulugu oso katolo be gout koloso moodoo nape ee gabuguga, wain i ee hodalaiso. Osoloso katolo gout be koloso moodoo ee tokenee palaiso. Esiga wain i dia ee medee katolo gout be koloso moodoo dia mapoo salama salai tekepo. Egeeseega wain i sabolo osoloso katolo gout be koloso moodoo sabolo tokenee palaime.” ");
INSERT INTO kkc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuye Yoneeyo hamamee dili odoo mapoo to osee takomolome, howo gisili moso gibadeli odoo oso sibileso Yesuwo homo beiyopoo gauwuloso badolone egeesee takaso, “Mo sobo holo epedee taso. Esiga nayo sibileso yo o gie badeli see talame nee deeso sige,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eseme odoo ogoso toboloso dime, Yesu o hamamee dili odoo sabolo tebisaloso yibolo hodobo diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Diba osee diyadaga molome, sobo hee aso woolooma koodobilega dugo 12 ma kulodu badebei oso Yesuwo dugo mapoo sigilame yima hamamee sibileso egeesee gooleeso, “Ayo dugo Yesuye ka eyo su mapoo wulo sigoga, a tekepo palaiso,” dee gooleeso. Osoloso hegi sibileso sigeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Eseme epedee omapoo Yesu bidi toboloso sobo ogoloso yimapoo egeesee takaso, “Mo holo, no howaleegee. Nayo amapoo tei too maga no olo tekepo paso,” diso. Eseme epedee omapoo sobo egee olo tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Osoloso Yesu see abaga howo gisili moso gibadeli odoo eyo mosopoo palaso. Diba omapoo peleso egeino, odoo aboso goohele sabolo dobolone bogobou masi gawulone doboome egeiso. Eseme odoo aboso pupusiga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesuye goo hagee ogoloso dimapoo egeesee takaso, “Niba peegoo diyadee. Sobo holo hagee koo tamoloso. Esino yo wulo tiamolo,” diso. Eseme diayo Yesuwo to duloso tei telega poogoloso wulo yiliga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Esino Yesuye odoo susuga peegoo diyadee doloso sobo holo oso tamelee moso ee ma kulodu peleso o dee mapoo tooso. Eseme sobo holo tamelee oso ta maga see hogabiaso. ");
INSERT INTO kkc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eseme mi su koola omapoo debeli odoo mapoo goo hagee dudobuguso. ");
INSERT INTO kkc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu moso omaga miyomoo meileso dimeleeno, odoo howo neliga bakadio oso yima hamamee toboloso dulone toso neligidi takolone egeesee takaso, “Deibidiyo amawe, nayo iba sooloo dologa, iba pidi,” dee takomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Osoloso Yesu yo see moso kulodu polome, odoo howo neliga bakadio oso yayo badebei mapoo sibadeeso. Eseme Yesuye dimapoo egeesee takaso, “Niba tei tosomo, ayo niba tekepo moodoolai a teiba?” dee takaso. Eseme diayo to nei egeesee takaso, “O, Lodee. Iba tei toso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eseme Yesuye dibada howo mapoo sigolone egeesee takaso, “Niyo amapoo tei too goo maga niyo goomoga goo ee peledabalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eseme dibada howo ee tekepo paso. Esino Yesuye to kitulugu sabolo dimapoo egeesee takaso, “Niyo dileso goo hagee odoo abo mapoo na takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Esino odoo bakadio oso mi su koola omapoo debeli odoo susuga mapoo Yesuwo goo ee oposusumo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Odoo howo neliga tekepo pa bakadio oso epedee omaga peegoo diyadaga molome, odoo aboso odoo bo holo pala Yesu mapoo ido simiso. Odoo hagee bo holoso yima kulodu badolone, to kelega badeliso. ");
INSERT INTO kkc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Esino Yesuye bo holo ee yimaga peegoo hasiso bugume, yo see to keiso. Eseme odoo susuga oso goo hagee ogoloso howoogadolone egeesee takaso, “Iba Isalael mi ma kulodu daga goo hageesee egele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Esino Pelisi odoo oso egeesee takaso, “Bo holo dia wiligi odoo oso Yesu mapoo kitulugu teneega, yayo kitulugu omaga bo holo peegoo hasiso bugulone ka silo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Osoloso Yesuye mi susuga ma kulodu silone, Yu odoowo howo gisili moso susuga ma kulodu to tekepo Godeeye wiligi doloso badeli goo ee eligimo sileeso. Osoloso yayo odoo paigiga susuga tekepo poomo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Egeeseelone Yesuye odoo susuga ogoloso diya sooloo dalaso. Bei, diba pidili odoo mauwe goo tiadoloso dobolone, sipi beso odoo diba bali mauwe debeli egeesi masi debeiso. ");
INSERT INTO kkc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eseme Yesuye o hamamee dili odoo mapoo egeesee takaso, “Homolee ma kulodu nei susuga olo bi moodooloso goolai ee moloso. Esino nei ee gooloogalai tou teli odoo haga beinee. ");
INSERT INTO kkc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Esiga homolee gibadeli odoo mapoo woose, yayo o homolee ma kulodu nei gooloogalame tou teli odoo abo diye dalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuye o hamamee dili odoo 12 gilimadoloso, yayo dimapoo kitulugu teneeso, diayo silesibulone odoo susuga dima kulodu bo holo paladee ee peegoo habuguloso, odoo paigiga susuga tekepo palame. ");
INSERT INTO kkc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Esiga Yesuye diye di odoo 12 hagee bia dia hu ee hagoso. Saimon, o hu hee Pita, osoloso omolo Endulu, osoloso Sebediyo owolo bakadio Yemes dio Yonee dio, ");
INSERT INTO kkc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","osoloso Pilipi, osoloso Batolome, osoloso Tomas, osoloso tekisi molee teli odoo Matiyu, osoloso Alpiyeseeyo owolo Yemes, osoloso Tadiyes, ");
INSERT INTO kkc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","osoloso Loum gamalee mapoo ha teli odoo Saimon, osoloso Yudas-Iskaliyot (yayo hamamee Yesu ha teli odoo dimapoo tiasooso). ");
INSERT INTO kkc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuye odoo 12 hagee bia diye dolone dimapoo egeesee takaso, “Niyo duga, Yu odoonee mapoo osoloso Samaliya odoo mapoo na di. ");
INSERT INTO kkc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Esino niba Isalael odoo mapoo di. Bei, diba sipi be hu oso diba bali odoo mauwe debeli egeesi masi doso. ");
INSERT INTO kkc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Esiga niyo dileso Godeeyo to egeesee takee, ‘Godeeye wiligi doloso badeli goo ee olo koola toobooso,’ dee takomo diyadee. ");
INSERT INTO kkc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Egeeseelone odoo paigiga susuga tekepo pe, osoloso odoo wedia mapoo see gie badeli tenee, osoloso odoo agagisa bia see tekepo pe, osoloso odoo ma kulodu bo holo paladee peegoo hasiso bigi. Ayo nimapoo kitulugu hagee nei mauwe teneeso. Esiga niyo odoo susuga pidimo silone, tou eyo nei talame na howamo silesibe. ");
INSERT INTO kkc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Niyo dulone molee sabolo, osoloso o sabolo, osoloso sedi bakadio sabolo, osoloso homo mapoo kali bi hee sabolo, osoloso susu sabolo toloso na diyadee. Bei, tou teli odoo ee dia tou eyo nei talai tebiliso. ");
INSERT INTO kkc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Niyo mi hee mapoo dileso, mi omapoo odoo hee niba medee egeli esie. Niba odoo egeesee ogoloso yibolo hodobo o mosopoo debee. Osoloso mi egee poogoo dilega osee dobolone, yibolo o moso omapoo debee. ");
INSERT INTO kkc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Osoloso niba moso hee mapoo ido pologa, niyo moso omapoo debeli odoo mapoo emegei di to egeesee takee, ‘Godeeyo mesie goo oso nibolo mele dee.’ ");
INSERT INTO kkc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Egeeseega moso ee ma kulodu debeli odoo oso emegei dolone mesie sabolo niba moso kulodu iyado pologa, Godeeyo mesie goo oso dibolo malaiso. Esino diayo niba dibada moso kulodu iyado pelega poogooga, Godeeyo mesie goo oso dibolo malaime. ");
INSERT INTO kkc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Esiga niba mi hee mapoo duga, edebeeyo niba idilega poogoloso nibada to mapoo mesilega poogooga, mi egee poogoloso dulone, megegu nibada homo mapoo mologa omapoo te, Godeeye komonolone dimapoo dia goo tokenee eyo nei tenelai goo ee gooleedalame. ");
INSERT INTO kkc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Esiga ayo nimapoo taka, mosodei kaso niba sibadeega, ogoloso goomoga sabolo niba iyadelega poogooga, nei Godeeye midilei biame omapoo, dala toowa diayo talai oso Sodom bia sabolo osoloso Gomola bia oso dala talai ee dagadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Esiga ayo niba sipi be hu masi dobu so kamanali ma kulodu diye deeso. Esiga niba hebise masi dobolone medee goolee sabolo bolone ka debee. Osoloso niba molo masi dobolone niyo debei ma kulodu goo tokenee mauwe debee. ");
INSERT INTO kkc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Esiga niba obeeyamo. Edebeeyo niba toloso goo midili moso mapoo ido polo dolone dabalaiso. Osoloso niba dibada howo gisili moso mapoo ido peleso wooloogolone dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Osoloso niba mo goo maga gamalee wiligi odoo tebisa sabolo osoloso wiligi odoo toowa tebisa abo dia mudugiyopoo ido peleso omapoo holoogalaiso. Esino niyo omapoo peleso mo goo ee dimapoo osoloso Yu odoonee mapoo takolone dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Egeesi ma kulodu edebeeyo niba goo midili moso mapoo ido pologa, niyo takalai goo ee haga na goolee. Bei, biame omapoo Dio Tei oso niyo takalai goo goolee tekepo ee nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Esiga niba niso goolee takalaime, esino Nama Godeeye Dio Tei nimapoo tenee oso nibolo toboloso goo goolee tekepo teneega niyo egeesee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Biame omapoo edebeeyo emei dio omolo dio wooloomalame diba goweli odoo mapoo tiasalaiso. Osoloso amaye owolo mapoo egeesee selaiso. Osoloso owoloye dibada ama dio owee dio mapoo mesilega poogoloso diba wooloomalame tiasalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bei, niyo amapoo tei too goo omaga odoo susuga oso nimapoo heiga toowa malaiso. Esino edebeeyo eyo tei too kibiloso badolone hoo poogoo mapoo dileso peledobooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Esiga odoo susuga oso nimapoo dala teneega, mi omaga mi hee mapoo kukulo diyadee. Esino ayo nimapoo taka. Niyo egeeseelone Isalael mi toowa ma kulodu mi pepooko susuga mapoo Godeeyo to osee takomo silesiboga, Odoo Holo ayo omapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Esiga hamamee dili odoo oso dia eligili odoo ee dagadileso koo badoso. Osoloso tou teli odoo oso dibada wiligi odoo taba ee dagadileso koo doso. ");
INSERT INTO kkc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Egeesi ma kulodu dibada eligili odoo mapoo goo heeso peledaba hedebe egeesi oso o hamamee dili odoo dimapoo peledobooga, diba goomoga sabolo dabalai tekepo. Osoloso wiligi odoo taba mapoo goo heeso peledaba hedebe egeesi oso o tou teli odoo dimapoo peledobooga, diba goomoga sabolo dabalai tekepo. A nibada wiligi odoo doloso ka badoso. Esiga odoo aboso a hu tokenee Belsebul hediga, niba nosee hu diya tokenee hedigileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Esiga niba goweli odoo ee bolo haga na ebi. Bei, goo susuga mada egee molo see woola peledabalaiso. Osoloso edebeeyo koo duli goo ee see woola takooga duleiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Esiga ayo nibolo silone goo abo hedebe nimapoo takeli susuga ee see niyo woola yilige bigi. Osoloso ayo nimapoo goo hee mada dulu mapoo takooga, goo egee niyo moso omu ma dokodoo peleso see woola takee. ");
INSERT INTO kkc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Esiga niba odoo nimapoo goweli ee bolo haga na ebi. Bei, diba hedebe su wooloomali ee gooleedoo, esino dio wooloomalai diba tebile. Esino niba hedebe Godeebolo obulone ka debee. Bei, yayo nibada su sabolo osoloso dio sabolo tokenee palame, Dou mi mapoo toodalai yo teiba. ");
INSERT INTO kkc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Esiga niba goolee, só pepuso bakadio ee wulo molee ko ta hedebeso teli. Esino ee ma kulodu só pe heeso talai ee ibada Ama Godeeye koo goomogoga, só pe egee talaime. ");
INSERT INTO kkc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Esiga nibada wiligi mapoo wudu susuga egee molo, Godee yo olo gooleedoo. Bei, yayo susuga olo hesigaso. ");
INSERT INTO kkc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Esiga niba haga obugulone na debee. Bei, Godeeyo howo woola sóso goo toowa koo moloso. Haye. Niyo goo toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Esiga odoo agayo odoo howo woola tobudulone yayo amapoo tei too goo ee yilige buguga, nei ayo mo Ma Godee Kei mi ma dokodoo egee bado eyo howo woola yo mo odoo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Esino odoo agayo odoo howo woola tobudulone yayo amapoo tei tele poogoo goo ee woola yilige buguga, nei ayo mo Ma Godee Kei mi ma dokodoo egee bado eyo howo woola yo mo odoonee dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Esiga niba ayo mi toowa hamapoo mesie goo tosimi dee na goolee. Haye, ayo mesie goo tosibile, esino domo pilame ka simi. ");
INSERT INTO kkc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Esiga ayo simi goo eyo bei egeesee moloso. Giso holo oso amabolo domo pileiso. Osoloso sobo holo oso oweebolo domo pileiso. Osoloso gisowo osobo oso odoowa dio domo pileiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Esiga egeesi ma kulodu nee soosooso namapoo ha teli odoo doloso dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Edebeeyo ama sabolo, owee sabolo, owolo giso holo sabolo, osoloso sobo holo mapoo diya goolee sabolo badolone, hee a goolee pepooko mologa, yo ayo di hamamee deedee sibilei tebile. ");
INSERT INTO kkc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Osoloso odoo agayo talai sabolo dala toowa talai sabolo goo medee moodelega poogoloso, ayo di hamamee dedelega poogooga, yo ayo di hamamee deedee sibilei tebile. ");
INSERT INTO kkc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Esiga edebeeyo o gie badeli eyo nediliyo balai daga, o gie badeli ee osugobalaiso. Esino edebeeyo mo goo maga o gie badeli osugobooga, yo badoboso kookaiyo gie badeli talaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Edebeeyo niba o mosopoo gilimado pologa, yayo a ido poloso. Esiga edebeeyo o mosopoo a ido pologa, yayo mo Ma Godee a diye di ee ido poloso. ");
INSERT INTO kkc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Osoloso edebeeyo Godee maga to toloso kokodo takomo sili odoo ee ogoloso, o mosopoo ido pologa, yo Godee maga to toloso kokodo takomo sili odoo oso nei teli yinosee hedebe egeesi masi talaiso. Osoloso edebeeyo Godeeyo howo woola odoo tekepo ogoloso, o mosopoo ido pologa, yo Godeeyo howo woola odoo tekepo oso nei teli yinosee hedebe egeesi masi talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Osoloso edebeeyo mo hamamee dili odoo hee wuluge ogoloso yimapoo bi pepooko wulo howo egeesi keneega, yo nei toowa talaiso. Esiga hagee tei goo.” ");
INSERT INTO kkc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu o hamamee dili odoo 12 mapoo goo hagee taka koodobuloso see Gelili mi toowa ee ma kulodu Godeeyo to takomo silame diso. ");
INSERT INTO kkc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yonee odoo howo oluguli oso neliga moso ma kulodu badolone, Kelisoye goo tomo silee duloso o hamamee dili odoo abo Yesu mapoo diye diso. ");
INSERT INTO kkc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eseme diba dileso Yesuye badebei mapoo peledoboloso yimapoo egeesee takaso, “Yoneeye iba namapoo diye dolone to egeesee takeeyena, ‘No tei Keliso iyo hagee bamolo odoo osomo? O, iba odoo hee bamalaiyo?’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eseme Yesuye nei dimapoo egeesee takaso, “Niba see wedi dileso niyo egei goo sabolo osoloso niyo du goo ee Yonee mapoo takee. ");
INSERT INTO kkc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bei, odoo howo neliga oso see medee ogowa. Osoloso odoo bagi daga poogoo sabolo see tekepo poloso ka silesiba. Osoloso odoo agagisa bia sabolo tekepo poloso ka silesiba. Osoloso odoo dulu tabaga onosee tekepo poloso to taka see duliso. Osoloso odoo wedia sabolo hogogabuloso see silesiboso. Osoloso to tekepo hagee bi mauwe odoo oso duluga moloso. ");
INSERT INTO kkc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Esiga odoo agayo ayo goo moodoo ee ogoloso diayo amapoo tei too goo ee pegelega poogooga, Godeeye dimapoo goomoga goo tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yonee o hamamee dili odoo oso see wedi diyadeeme, Yesuye odoo mooloogoodoo mapoo Yoneeyo goo takalame bei mooloogooso. Osoloso yayo egeesee takaso, “Niba miwe poogoo mi mapoo ogoo goo agalame ka diyo? Pooso sibulone obu dabisa ee agalame ka diyo? ");
INSERT INTO kkc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Niba edebeeyo dugo tekepo kaloso badoboome ee agalame ka diyo? Haye. Bei, dugo tekepo kalagali odoo ee wiligi odoo tebisa oso debeli moso tekepo mapoo debeli. ");
INSERT INTO kkc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Esino niba wulo Godee maga to toloso kokodo takomo sili odoo ee agalame ka diyo? O. Niyo dileso egei odoo Yonee hagoso Godee maga to toloso kokodo takomo sili odoo daga hoogoo debei ee yayo dagadileso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bei, Godeeyo to booka mapoo hogugu oso egeesee egee takoo ee Yoneeyo goo ee takooso, ‘Ayo mo to tosili odoo yo daga malalo diye dalaiso, odoo susuga oso nayo sibilei mapoo mopoodoo doloso debeeye dalame,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Esiga ayo nimapoo taka. Odoo daga hoogoo debei susuga ee Yoneeye dagadileso ka badoso. Esino edebeeyo Godeeye wiligi doloso badeli goo mapoo odoo wuluge oso Yonee dagadileso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Esiga odoo howo oluguli Yoneeye Godeeyo to takomo silee biame omaga bei mooloogoloso abaga simino epedee hamapoo tokenee teli odoo oso ha teli odoo masi Godeeye wiligi doloso badeli goo ee tokenee palame diya kituluguso. ");
INSERT INTO kkc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yonee sibilega badoboome, Moseseeye eligi goo sabolo osoloso Godee maga to toloso kokodo takomo sili odoo susuga oso hogugu oso Godeeye wiligi doloso badeli goo ee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Esiga niyo to diayo taka hamapoo tei toga, niyo Yonee see Ilaya dalaiso. Bei, Godeeyo to booka mapoo hogugu oso Ilayaye sibilei goo ee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Niba dulubolo, esiga ayo hagee takoo medee hoodo dui.” ");
INSERT INTO kkc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Osoloso Yesuye see egeesee takaso, “Odoo epedee biame hamapoo egee do odoo ee kasee masiso dosomo? Diba holaiso masi go domopoo dobolone emegei dimapoo nei takoo nei takoo dolone dobolone egeesee takaga meliso, ");
INSERT INTO kkc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Iyo goomoga kosaiya poume, niba hepele. Osoloso iyo goohele kosaiya poume, niba pisile,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Niba odoo egeesi masi doso. Bei, Yonee odoo howo oluguli yayo sibileso nei haga toowa namo sile, osoloso wain i keesoo nele. Esino niyo yo bo holo paladoo, dee takeliso. ");
INSERT INTO kkc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Osoloso hamamee Odoo Holo a olo simiso. Ayo sibileso wo sabolo wain i sabolo namo sileeme, niyo a nei sabolo yugune sabolo dooboo nali odoo, dee takeliso. Osoloso niyo a tekisi molee teli odoo sabolo, osoloso tokenee teli odoo sabolo hedebe doloso ka badeli deliso. Esino odoo agayo Godeeyo goo goolee tekepo gooleedoloso tomo siloga, yayo Godeeyo goo goolee ee tekepo dolone ka eligiso.” ");
INSERT INTO kkc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesuye mi abo mapoo goo toowa opusomo di moodoomo sileeme, odoo mi omapoo debeli oso dia goo tokenee su wudelega poogoome, yayo odoo egee bia dia goo ogoloso dimapoo diya takolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolasin bia sabolo Betesaida bia, dala toowaso niba bamoloso. Bei, ayo nibada mi mapoo goo toowa mudu opusomo opusomo di ee moodoogamo silee egeesi masi Taya bia mapoo osoloso Saidon bia mapoo moodoogamo silee diepi, diba haga booloogelega, dibada goo tokenee maga miligi pialoso debeliyo. Osoloso diayo dibada goo tokenee maga miligi pia goo ee eligilone dugo tokenee kelekaloso dosou holugaloso silesibiliyo. ");
INSERT INTO kkc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Esino ayo nimapoo taka, Godeeye goo midilei biame mapoo dala toowa Kolasin bia sabolo osoloso Betesaida bia oso talai oso Taya bia sabolo osoloso Saidon bia oso talai ee dagadileiso. ");
INSERT INTO kkc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Osoloso Kapeniyum mosobia niba Kei mi ma dokodoo ido palaiso, dee goolone ka dosomo? Haye. Niba toloso Dou mi mapoo toodalaiso. Ayo nibada mi mapoo goo toowa mudu opusomo di moodoogamo silee egeesi masi Sodom mi mapoo moodoogamo silee diepi, Sodom mi tokenee pelega epedee hamapoo osee meliyo. ");
INSERT INTO kkc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Esino ayo nimapoo taka, Godeeye goo midilei biame omapoo dala toowa Kapeniyum bia niyo talai oso Sodom bia oso talai ee dagadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eseme Yesuye egeesee takaso, “Ma, Kei mi sabolo osoloso mipoo sabolo nayo wiligi doloso ka badoso. Esiga a namapoo goomogo. Bei, nayo wiligi doloso badeli goo mada egee molo ee, odoo goo goolee toowa mapoo yilige bigile. Esino nayo goo goolee dele poogoo odoo mapoo yilige buguso. ");
INSERT INTO kkc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O. Tei takoo, Ma. Goo hagee nayo goomoga goo oso.” ");
INSERT INTO kkc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesuye see tobu egeesee takaso, “Mo Maye goo susuga amapoo olo teneeso. Esiga odoo heeso Owolo a gooleedele. Esino hedebe mo Maye Owolo, a ka gooleedoo. Osoloso odoo heeso mo Ma gooleedele. Esino hedebe Owolo ayo mo Ma ka gooleedoo. Odoo ogu bia mapoo Owolo ayo mo Mayo goo ee yilige bigilame goomogoga, odoo egee bia oso mo Mayo goo ee diba nosee gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Esiga edebeeyo hegi bi masi kadaloso silone kwasu sabolo siloga, niba amapoo sibe. Egeeseega ayo nimapoo hasali tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Osoloso ayo eligi goo ee ogoloso mo goo peedee. Bei, a mesie odoo. Esiga niba hasalame amapoo sibe. ");
INSERT INTO kkc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bei, goo ayo eligi ee dadalai haga kodianee. Osoloso bi masi ayo nimapoo eimedilame egee molo ee diya poopeeya.” ");
INSERT INTO kkc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yu odoowo hasali biame heeso, Yesu o hamamee dili odoo sabolo witi wo ko segei ee ma kuloduga diyadaga meleeso. Osoloso Yesu o hamamee dili odoo oso diya houdume, witi wo ko gooloogaloso nalagamo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eseme Pelisi odoo oso goo hagee ogoloso Yesu mapoo egeesee takaso, “Bei kasi maga nee hamamee dili odoo oso iyo hasali biame mapoo witi wo ko ka gooloogayo? Diayo ibada tei gababuoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuye nei egeesee takaso, “Deibidiye o odoo sabolo houdume diayo moodoo goo ee Godeeyo toso booka mapoo hogugu niyo hesigeleyo? ");
INSERT INTO kkc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bei, Deibidiye Godeeyo tei moso ma kulodu gadileso tei wo toloso o odoo sabolo neso. Esino tei wo hagee ibada tei ee dodolone Godee ogo odoo ogo doloso domo debeli odoo hedebe oso nali. Esino Deibidiye o odoo sabolo wo ne oso tei magoo ee gababiaso. ");
INSERT INTO kkc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Osoloso Moseseeye tei hogugu ma kulodu to hee hageesee egee takoo niyo hesigeleyo? Goo egee Godee ogo osoloso odoo ogo doloso debeli odoo oso hasali biame mapoo tei moso ma kulodu dia tou teliso. Diayo goo egeesi moodeli oso tei magoo gababiliso. Esino Godeeye goo egee ogoloso tokenee dee koo takeli. ");
INSERT INTO kkc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Esiga ayo nimapoo taka, goo hee dia epedee hamapoo sibileso egee molo oso tei moso oso kitulugu ee dagadileso ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Esiga Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Niyo emegei pidilei ono ayo diya goolone niyo nei amapoo gala wooloso teneli goo ee ayo haga koo gooleeso,’ diso. Niyo to eyo bei medee kibiya gooleedoloso ka debei diepi, niyo mo hamamee dili odoo ee tokenee odoo dee takele pegeliyo. ");
INSERT INTO kkc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bei, niyo hasali biame egee Odoo Holo ayo wiligi doloso ka badoso.” ");
INSERT INTO kkc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuye to taka hagee koodobuloso see omaga diayo howo gisili moso mapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Osoloso moso eyo kulodu odoo dee hodio seeseegedoo poogoo badoboome egeiso. Egeesi ma kulodu Pelisi odoo aboso Yesu tokenee odoo dalame eli esilone yimapoo egeesee takaso, “Ibada tei magoo oso takolone iyo hasali biame mapoo odoo tekepo palai tekepowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Esino Yesuye nei dimapoo egeesee takaso, “Nima kulodu odoo heeso o sipi be hedebe oso niyo hasali biame mapoo wulu ma kulodu toodobuoga, yayo yo hudilega pagalaisomo? Haye. Yayo yo wulu ma kulodu badoga see hudileiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Esiga Godeeyo howo woola sipi beso goo haga toowa koo moloso. Haye. Edebeeyo goo toowa ka moloso. Esiga edebeeyo ibada hasali biame mapoo goo tekepo talai ee tei mauwe.” ");
INSERT INTO kkc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eseme Yesuye odoo dee hodio seeseegedoo poogoo yimapoo egeesee takaso, “Nee dee seeseegedoo poogoo egee see hoodode,” diso. Eseme odoo egee o dee see hoododeme, dee egee tekepo poloso o dee tekepo hodio egeesi masi meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eseme Pelisi odoo oso goo hagee ogoloso komonolone dia howo gisili moso maga peegoo diyadeeso. Osoloso diayo dileso Yesu toloso woolame diesono to mouso. ");
INSERT INTO kkc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Esiga diayo to mou goo ee yo olo gooleedoloso, Yesu yo see mi hee mapoo diso. Eseme odoo susuga oso yo deedee diso. Eseme odoo paigiga susuga dima kulodu melee ee yayo tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Osoloso yayo dimapoo to kitulugu sabolo egeesee takaso, “Niyo mo goo hagee odoo susuga mapoo na oposisiye,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Godee maga to toloso kokodo takomo sili odoo Aisayaye taka to sabolo teibaso. Bei, yayo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ege, hagee mo tou teli odoo. Yo ayo hesia. Ayo yo diya goolone yimapoo diya goomogoso. Ayo mo Dio yimapoo tenelaiso. Osoloso tei goo ee yayo Yu odoonee susuga mapoo takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Osoloso yayo odoo hee sabolo toso agadigilone to boowoolaime. Osoloso yayo eli domopoo eligiga to neligidi takalaime. ");
INSERT INTO kkc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Osoloso yayo tiosi seegee magoo ee gobigileime. Osoloso keme pepooko paimologa yayo semidileime. Esiga odoo tei too kibile poogoo yayo egee pidimolo goo ee epedee pagalai mauwe. Esino odoo susuga oso Godeeye goomoga goo ee dodomolo ogoloso omapoo koodobileiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Esiga o hu maga Yu odoonee susuga oso diayo dulone egee bamolo gie badeli ee talaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Biame omapoo odoo aboso odoo hee howo neliga mapoo bo pala oso to kelega badebei odoo ee Yesu mapoo ido simiso. Eseme Yesuye yo tekepo paso. Eseme domo omapoo odoo egee olo howo puo ogoloso see to keiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Odoo susuga oso goo hagee ogoloso howoogadolone egeesee takaso, “Odoo hagee Deibidiyo amawe bele,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Esino Pelisi odoo oso goo hagee duloso egeesee takaso, “Yesuye Belsebul oso kitulugu maga bo holo peegoo hasiso bigiliso. Bei, Belsebul yo bo holo dia wiligi odoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Esino Yesuye diayo goolee goo ee gooleedoloso dimapoo egeesee takaso, “Mi toowa mapoo debeli odoo oso abo puloso dieso nediliyo ha toga, mi toowa egee malaime, tokenee palaiso. Osoloso soosoo heeso o, mosobia heeso abo puloso dieso nediliyo ha toga, diba dabalaime, tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Esiga Saiten oso bo holo peegoo hasiso buguga, dia mooloogoodoo ma kulodu abo puloso dieso nediliyo ha talaiso. Yayo egeesee seega, yayo wiligi doloso badeli goo oso kookaiyo osee malaisomo? Tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Esino ayo bo holo peegoo hasiso bigili kitulugu hagee tei Belsebul oso kitulugu maga ka hasisimo silo daga, nibada hamamee dili odoo oso bo holo peegoo egee hasisimo silesibo kitulugu egee kamapoo teliyo? Esiga diayo takooga niyo amapoo egee takoo goo ee tei goonee, dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Esino ayo Godeeyo Dio Tei oso kitulugu maga bo holo peegoo ka hasisimo siloso. Goo oso Godeeye wiligi doloso badeli goo oso olo nimapoo simi goo ee ka eligiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Esiga odoo heeso kitulugu odoo eyo moso mapoo peleso bi heli talame gooleega, yo daga kitulugu odoo egee tiso tialogoloso magalaiso. Osoloso hamamee o moso kulodu peleso o bi heli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Esiga edebeeyo abolo tebelega poogooga, yayo amapoo ha tomoloso. Osoloso edebeeyo abolo odoo Godee mapoo gilimado sibilega poogooga, yayo odoo Godee maga peegoo hasiso bugu domoloso. ");
INSERT INTO kkc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Esiga ayo nimapoo taka. Goo tokenee susuga edebeeyo teli sabolo osoloso emegei dimapoo to tokenee takeli goo ee Godeeye hapoloso boobado bigileiso. Esino edebeeyo Dio Tei eyo goo maga to tokenee takooga, o goo tokenee egee Godeeye hapoloso boobado bigileime. ");
INSERT INTO kkc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Osoloso edebeeyo Odoo Holo amaga to tokenee takooga, Godeeye o goo tokenee egee hapoloso boobado bigileiso. Esino edebeeyo Dio Tei eyo goo maga to tokenee takooga, yo goo tokenee moloso kookaiyo osee malai ee toso. Esiga o goo tokenee egee Godeeye hapoloso boobado bigileime.” ");
INSERT INTO kkc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Esiga homo tekepo oso homokoko tekepo peliso. Esino homo tokenee oso homokoko tokenee peliso. Esiga homo su susuga oso ko pa maga ka gooleedeeya. ");
INSERT INTO kkc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Esiga niba tokenee odoo hebise masi dobolone niyo see goo tekepo takalai tebile. Bei, edebeeyo goo goolee dia sooloo ma kulodu egee molo ee dia magaso takooga woola yilige bigiliso. ");
INSERT INTO kkc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Esiga goo tekepo teli odoo oso goo tekepo o goo goolee mapoo meli ee o magaso woola yilige bigiliso. Osoloso goo tokenee teli odoo oso goo tokenee o goo goolee mapoo meli ee o magaso woola yilige bigiliso. ");
INSERT INTO kkc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Egeesi ma kulodu ayo nimapoo taka. Goo midilei biame mapoo odoo susuga oso goo tokenee diayo taka goo eyo bei ee Godee mapoo woola yilige bigileiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Esiga Godeeye goo midilei biame mapoo, to no takeli goo sabolo teiba nee goo midileiso. Egeesi ma kulodu no to tekepo takomo sili daga, yayo no odoo tekepo dalaiso. Esino no to tokenee takomo sili daga, yayo no odoo tokenee dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Biame heeso Pelisi odoo abo sabolo osoloso tei eligili odoo sabolo oso Yesuye badebei mapoo sibileso egeesee takaso, “Eligili odoo, nayo kitulugu too egee tei Godee maga simidoo doloso gooleedalaiya, nayo goo toowa opusomo di hee moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Eseme Yesuye nei dimapoo egeesee takaso, “Odoo epedee hamapoo egee do niba diya tokenee. Osoloso niyo amapoo tei talai goweliso. Esiga niyo ayo wulo goo toowa opusomo di moodoo ee agalame amapoo takeliso. Esino ayo nimapoo goo toowa opusomo di hee eligilei mauwe. Esino hedebe Godee maga to toloso kokodo takomo sili odoo Yonayo goo ono nimapoo eligileiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona biame bakadio hedebe di osoloso gesi bakadio hedebe di ee ma kulodu di toowa eyo gemedei ma kulodu badebeiso. Esiga Odoo Holo anosee biame bakadio hedebe di osoloso gesi bakadio hedebe di mapoo midoo ma kulodu ta malaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Esiga Niniba odoo oso goo midilei biame mapoo nibolo hodobo toboloso nibada goo midiloso, niba tokenee odoo dalaiso. Bei, Yonaye Godeeyo to dimapoo takeme, diayo dia goo tokenee maga goo su wuduloso miligi piaso. Esino ayo Yona dagadileso ka badoso. Esino ayo Godeeyo to nimapoo takeme, niyo duloso nibada goo tokenee maga goo su wuduloso miligi pile. ");
INSERT INTO kkc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Osoloso goo midilei biame mapoo Siba mi eyo wiligi odoo taba sobo onosee nibolo hodobo nibada goo midiloso niba tokenee odoo dalaiso. Bei, wiligi odoo taba Solomonoye eligi goo ee dulame yo eli sage abaga simiso. Esino ayo Solomono dagadileso ka badoso. Esino niyo mo to dulei ka gowooso.” ");
INSERT INTO kkc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Esiga bo holoso odoo maga peegoo gaduga, yo dileso dobudu yayo badalai mi ee esiamo sileiso. Yo mi esiamo siloso koo ogoga, eyo nediliyo egeesee takalaiso, ");
INSERT INTO kkc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘A mawo daga badebei moso mapoo see wedi dileiso,’ dee takalaiso. Osoloso yo see sibileso ogoga, gelesi kadee doloso bi medee mopoodoo ma molo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eseega yo see dobudu wedi dileso bo holo diya kitulugu abo 7 gilimadoloso sibileso moso omapoo dabalaiso. Egeeseega odoo hagee eyo daga badebei poogoloso see diya tokenee badalaiso. Esiga goo tokenee teli odoo epedee hamapoo egee do niyo daga debei poogoloso see diya tokenee dabalaiso. Bei, niyo ayo eligi goo mapoo tei tele poogooga.” ");
INSERT INTO kkc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuye odoo mooloogoodoo mapoo to osee takomolome, owee dio osoloso omolo dio sibileso peegoo tebisamolone, yimapoo to takalame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eseme odoo heeso Yesu mapoo egeesee takaso, “No ege, noowee dio osoloso nomolo dio namapoo to takalame sibileso peegoo tebisamolo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Esino Yesuye nei yimapoo egeesee takaso, “Mo wee ogumo? Osoloso molo dio ogumo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eseme yayo o hamamee dili odoo dimapoo dee kou takolone egeesee takaso, “Niba ege, odoo egee bia ee mo wee osoloso molo dio oso. ");
INSERT INTO kkc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Esiga edebeeyo mo Ma Kei mi ma dokodoo badeli oso goomoga goo ee tomo siloga, odoo egee bia ee molo dio, osoloso mo booba dio, osoloso mo wee dio oso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Biame hedebe ogoso Yesu moso kuloduga peegoo dileso Gelili abei pee mapoo meileso biaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yo omapoo badoboome, odoo susuga oso yayo eligi goo ee dulame yimapoo sibileso diya mooloogoodooso. Eseme Yesu yo du mapoo daboogoloso eligilone badoboome, odoo susuga mubiyodoga tebisamolone duluga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Osoloso yayo goo susuga maga wudu takolone odoo susuga mapoo eligilone egeesee takaso, “Niba dui. Biame heeso odoo hee witi wo ko segelame diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yo witi wo ko sogomo sileeme, ko abo eli domopoo misigedibaso. Eseme só aboso sibileso neso. ");
INSERT INTO kkc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Osoloso witi wo ko abo yugo kauwe mi mapoo misigediba ee bou saga pisigaso. Esino osoko pa oso dei moodoolone witi wo ko saga wediaso. Bei, too delega. ");
INSERT INTO kkc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Osoloso witi wo ko abo dagi we ti kauwe kadee mapoo misigedibaso. Osoloso bou pisigaso. Esino we ti sabolo palaga tiso tiademe susuga wediaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Osoloso witi wo ko abo mi tekepo mapoo misigedibaso. Osoloso oso bou pisigaloso kakauwuloso ko diya palagaso. Egeesi ma kulodu witi wo ko aboso homokoko 100 egeesi palagaso. Osoloso aboso 60 egeesi palagaso. Osoloso aboso 30 egeesi palagaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Odoo niba dulubolo, esiga to ayo hagee takoo medee dui!” ");
INSERT INTO kkc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Osoloso Yesu o hamamee dili odoo oso sibileso Yesu mapoo egeesee takaso, “Nayo kasalame odoo mapoo wulo ka wudu takomo siliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo Godeeye wiligi doloso badeli goo ee diya gooleedalaiso. Godeeye wiligi doloso badeli goo ee daga mada meleeso. Esino Godeeye epedee hamapoo nimapoo olo yilige buguso. Esino yayo odoo abo mapoo yilige bigile. ");
INSERT INTO kkc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Esiga to taka duli odoo mapoo Godeeye goo goolee tekepo bei tenelaiso. Esino edebeeyo mo to dulega poogooga, Godeeye yimapoo goo goolee tekepo pepooko egee molo see eyo peedee dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ayo odoo mapoo wulo wudu takomo siliso. Bei, ‘diayo ogoloso medee kibiya egelega pagalame. Osoloso diayo duloso goo eyo bei medee kibiya gooleedelega pagalame.’ ");
INSERT INTO kkc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Osoloso Godee maga to toloso kokodo takomo sili odoo Aisayaye taka to oso goo diayo moodeli sabolo teibaso. Bei, yayo egeesee takaso, ‘Diayo medee hodu dileso to taka duleiso, esino goo eyo bei diayo medee kibiya gooleedalaime. Osoloso diayo medee hodu dileso agalaiso, esino goo eyo bei diayo ogoloso gooleedalaime. ");
INSERT INTO kkc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bei, diba tei goo ee gooleedalai gowoolone, dieso dibada deeso dia dulu tobodo osoloso dia howo gisigaso. Esiga diba goo eyo bei ee gooleedalai tebile. Esino diayo ogoloso, osoloso duloso goo goolee tekepo toloso, amapoo wedi simi diepi, ayo dibada goo tokenee hapoloso boobado bigiliyo.’ ");
INSERT INTO kkc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Esino Godeeye mo hamamee dili odoo nimapoo goomogoso. Bei, niyo ayo moodoo goo ee ogoloso duloso gooleedoo maga. ");
INSERT INTO kkc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Esiga ayo nimapoo taka. Godee maga to toloso kokodo takomo sili odoo daga debei sabolo osoloso Godeeyo howo woola tekepo debeli odoo oso niyo epedee egee ogomolo goo ee agalai doloso bameleeso. Esino diayo egele. Osoloso niyo epedee egee dumolo goo ee dulei doloso bameleeso. Esino diayo dule.” ");
INSERT INTO kkc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuye see tobu egeesee takaso, “Esiga witi wo ko segei maga wudu taka goo eyo bei medee dui. ");
INSERT INTO kkc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Esiga odoo abo witi wo ko oso eli domopoo misigediba egeesi masi doso. Diba to tekepo Godeeye wiligi doloso badeli goo ee duloso medee kibiya gooleedelega poogooga, Saitenso sibileso Godeeyo to dibada sooloo ma kulodu melee yayo peedee deliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Osoloso odoo abo witi wo ko oso yugo kauwe mi mapoo misigediba egeesi masi doso. Esiga diayo Godeeyo to taka duloso goomoga sabolo saga teliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Esino Godeeyo to oso dia sooloo ma kulodu too medee koo meili. Esiga diayo Godeeyo to duloso biame deiyepo mapoo tei teliso. Esino diayo Godeeyo to mapoo tei too goo maga hegi goo sabolo osoloso dala goo oso dimapoo siboga, diayo Godeeyo to mapoo tei too goo ee saga pegeliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Osoloso odoo abo witi wo ko oso dagi we ti kauwe kadee mapoo misigediba egeesi masi doso. Diba Godeeyo to duloso tei teliso. Esino mi hamapoo dabalai maga goo kodia sabolo osoloso bi bei doloso dabalame goolee oso dibada tei too tokenee peliso. Egeesi maga diayo tei too goo oso homokoko masi koo peli. ");
INSERT INTO kkc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Osoloso odoo abo witi wo ko oso mi tekepo mapoo misigediba egeesi masi doso. Diayo Godeeyo to duloso gooleedeliso. Esiga odoo aboso homokoko masi 100 egeesi peliso, osoloso aboso 60 egeesi peliso, osoloso aboso 30 egeesi peliso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Osoloso Yesuye see hee wudu takolone odoo mooloogoodoo mapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso witi wo ko o homolee mapoo segeiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Esino gesi odoo susuga tiesamolome, yimapoo ha teli odoo oso sibileso yayo witi wo ko segei homolee omapoo obu ko sogoloso diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Esiga witi wo ko segei olo kauwudoloso ko poome, obu ko segei sabolo hodobo palaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eseme o tou teli odoo aboso sibileso egeesee takaso, ‘Nee homolee ma kulodu hedebe witi wo ko segeino, see kasi maga obu sabolo ka paladeeyo?’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eseme yayo nei egeesee takaso, ‘Imapoo ha teli odoo oso sibileso ka segei molodoo,’ diso. Eseme o tou teli odoo oso yimapoo egeesee takaso, ‘Iyo dileso obu egee tigaloso peegoo togobisilei no goomogodo?’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Esino yayo dimapoo egeesee takaso, ‘Haye, niyo na tige. Bei, niyo tigaga, witi wo ko segei sabolo tigebigiyaga. ");
INSERT INTO kkc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Esiga o diesono hodobo esee paladee dee. Osoloso ko goolai biame mapoo mo tou teli odoo oso daga obu ee tigaloso dou mapoo toodee dalaiso. Esino witi wo ko segei oso paladee ee gooloogaloso mo nei mageli moso mapoo mooloogoo magee dalaiso.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Osoloso Yesuye see hee wudu takolone o hamamee dili odoo mapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso ko pepooko masted deli todileso o homolee mapoo segeiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Esino ko abo ma kulodu ko masted deli hagee diya pepooko. Esino ko pepooko oso bou pisaloso kauwuga, homolee ee ma kulodu homo su oso toowa malaiso. Osoloso sóso omapoo sibileso o dee mapoo ou tegelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Osoloso Yesuye see hee wudu takolone dimapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Soboso wo palawa silame daga homolone, wo toowa ee ma kulodu yist pepooko kukoseliso. Osoloso yist pepooko oso wo palawa ee diya koudiliso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Esiga Yesuye odoo mooloogoodoo mapoo goo susuga hagee eligilame dimapoo wulo wudu takeliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yayo goo hageesee tomo sili egee Godee maga to toloso kokodo takomo sili odoo oso taka sabolo tebilame ka eligimo sili. Bei, yayo egeesee takaso, “Ayo odoo mapoo Godeeyo to eligilone wulo wudu takomo sileiso. Osoloso mi toowa bei mooloogolone goo mada melee ee see ayo woola yilige bigileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuye odoo mooloogoodoo diye doloso, yo see moso kulodu palaso. Eseme o hamamee dili odoo oso yimapoo sibileso egeesee takaso, “Witi wo ko segei sabolo osoloso obu ko segei omaga wudu taka goo eyo bei nayo imapoo medee kibiya takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eseme Yesuye dimapoo egeesee takaso, “Witi wo ko segeli odoo ee Odoo Holo aso. ");
INSERT INTO kkc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Osoloso witi wo ko segei mi ee mipoo toowa hagoso. Osoloso witi wo ko ee Godeeyo owolo dioso. Esino obu ko ee Saiteneeyo owolo dioso. ");
INSERT INTO kkc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Egeesi ma kulodu obu ko segeli odoo ee Saitenso. Osoloso goolai biame ee biame hoo poogoo oso. Osoloso witi wo ko goolai odoo ee Godeeyo momaiye oso. ");
INSERT INTO kkc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Esiga obu tigaloso dou mapoo toodeli egeesi masi ee biame hoo poogoo mapoo Odoo Holo ayo Saiteneeyo owolo dio ee dou mapoo egeesee toodalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Egeesi ma kulodu Odoo Holo ayo mo momaiye diye dalaiso, diayo dileso odoo goo tokenee mapoo gido dili odoo sabolo osoloso goo tokenee teli odoo ee gilimadoloso dou mi mapoo toodalaiso. Eseega diayo ee ma kulodu dobolone pisa sabolo mei gisile sabolo dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Esino Godeeye tekepo deli odoo oso Ma Godeeye wiligi doloso badeli mi mapoo osokoso pa masi palaiso. Odoo niba dulubolo, esiga to ayo hagee takoo medee dui!” ");
INSERT INTO kkc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Esiga Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso daga hoogoo bi medee tekepo molee toowaso too mi ma kulodu mada magoo ee odoo heeso mi doomeleso egeiso. Yo bi egee ogoloso see tobu miso gagaso. Osoloso goomoga sabolo o mosopoo wedi dileso o bi susuga odoo abo mapoo teneloso nei molee tooso. Osoloso yayo molee oso mi egee tooso. Osoloso bi medee tekepo mada mi ma kulodu magoo sabolo yayo tooso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Esiga Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso beegee esiamo siliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yayo esiamo siloso beegee medee tekepo ogoga, yo see dileso o bi susuga odoo abo mapoo teneloso nei molee teliso. Osoloso yo molee oso beegee tekepo teliso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Esiga Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Pei howomoo oluguloso di bei mologa egee misiga egeesi masi moloso. ");
INSERT INTO kkc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Egeesi ma kulodu pei mapoo di bei mologa, di kebili odoo oso dia pei booboosee mapoo gimagoloso dobolone di piliso. Osoloso di tekepo ono o ma kulodu soliso, esino di edebeeyo koo nali ee peegoo togobiseliso. ");
INSERT INTO kkc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Esiga biame hoo poogoo mapoo goo hageesi masi oso peledabalaiso. Esiga Godeeyo momaiye aboso mipoo hamapoo sibileso Godeeyo howo woola tekepo debeli odoo sabolo osoloso goo tokenee teli odoo ee domo pileiso. ");
INSERT INTO kkc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Osoloso goo tokenee teli odoo ee Dou mi mapoo toodalaiso. Eseega diayo ee ma kulodu pisa sabolo dobolone mei gisile sabolo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuye o hamamee dili odoo mapoo egeesee takaso, “Niba ayo hagee takoo goo susuga eyo bei medee gooleedosomo?” diso. Eseme diayo nei egeesee takaso, “O. Iba gooleedoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eseme Yesuye dimapoo egeesee takaso, “Tei too odoo agayo Godeeyo to eligilone, Godeeye wiligi doloso badeli goo ee gooleedoloso badoga, yo moso eyo ama masi badoso. Yayo moso ee ma kuloduga bi dia sabolo osoloso nape sabolo toloso ka tosibo dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuye odoo susuga mapoo wudu takemelee koodobuloso mi hagee poogoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yo see wedi dileso o midee Nasalet mapoo badolone diayo howo gisili moso mapoo peleso Godeeyo to odoo mapoo eligilame bei mooloogooso. Eseme odoo susuga oso yayo eligi duloso diya howoogadolone egeesee takaso, “Odoo hagoso goo egee eligimo silo kapoo tobele? Osoloso yayo goo toowa opusomo di egee moodoomo silo, kitulugu kapoo tobele? ");
INSERT INTO kkc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yo wulo Meliyo owolo. Osoloso yo wulo moso tegeli odoo hamapoo badeli eyo owolo. Osoloso yo Yemes, Yosep, Saimon, osoloso Yudas egee bia dia emei. ");
INSERT INTO kkc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Osoloso obooba dio onosee ibolo hodobo hamapoo doso. Esiga goo susuga egee Yesuye kasee moodoomo silosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Esiga diayo egeesee goolone Yesuye eligi goo ee talai goweso. Eseme Yesuye dimapoo egeesee takaso, “Edebeeyo Godee maga to toloso kokodo takomo sili odoo eyo to duloso mesiliso. Esino o mosobia sabolo osoloso o soosoo oso o to mapoo duloso koo mesili,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Esiga Yesuye diayo tei telega poogoloso debei goo ee ogoloso o mi omapoo goo toowa opusomo di abo moodele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Biame omapoo Gelili mi gibadeli odoo Helodeeye Yesuye goo moodoomo silee duloso o tou teli odoo mapoo egeesee takaso, “Odoo hagee Yonee odoo howo oluguli oso molodoo. Yo ta maga olo hogabiadoo. Esiga yayo see goo toowa opusomo di hageesee ka moodoomo silo,” dee takaso. (Yayo hageesee takaso. Bei, Yonee telega badoboome, goo hagoso peledabaso.) ");
INSERT INTO kkc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Biame heeso Helodeeye omolo Pilipiyo osobo Helodiyes peedee huso. Eseme Yoneeye goo hagee ogoloso Helodee mapoo diya takolone egeesee takaso, “Nayo nomolowo osobo peedee hulei tekeponee. Bei, egee tei,” diso. Eseme Helodee diya komonolone, o ha teli odoo mapoo takolone, Yonee dee tialogoloso neliga moso ma kulodu huse diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eseme yo Yonee wooloomalame goomogaso. Esino odoobolo obulone wooloomele poogooso. Bei, odoo susuga oso takolone Yonee Godee maga to toloso kokodo takomo sili odoo deliso. ");
INSERT INTO kkc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Osoloso hamamee Helodee yo soomagoo biame tugodeme, yayo o odoo gilimadoloso sibileso wo nolone debeiso. Eseme Helodiyeseeyo sobo holo oso sibileso dia mudugiyopoo hopoome, Helodee diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eseme nei Helodeeye goo tei moodoolame takolone yimapoo egeesee takaso, “Nayo goomoga bi ee amapoo takooga, ayo bi egee namapoo tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yo to egeesee taka duloso hopoomelee koodobuloso owee mapoo dileso yayo goomoga goo ee duso. Osoloso see wedi sibileso Helodee mapoo egeesee takaso, “A Yonee odoo howo oluguli eyo wiligi ono goomogo. Esiga nayo epedee o wiligi koodoloso tolo mapoo magoloso amapoo tenee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Esino Helodee goo hagee duloso Yoneeyo wiligi koodoloso tenelai yo goomegele. Esino yayo sobo holo mapoo goo tei moodoolame taka ee dibolo hodobo nei nolone debei odoo oso olo duso. Esiga goo hagee pagalai yo goomegele. ");
INSERT INTO kkc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Eseme yayo o odoo mapoo to kitulugu teneeso, diayo dileso Yoneeyo wiligi koodoloso tosibilame. Osoloso o odoo oso neliga moso ma kulodu gadileso, Yoneeyo wiligi koodoloso tolo mapoo magoloso tosibileso, sobo holo mapoo teneeso. Eseme see yayo tosibileso owee mapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eseme Yonee o hamamee dili odoo oso sibileso Yoneeyo kou todileso bouso. Osoloso dileso Yesu mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Helodeeye Yonee woolooma goo ee Yesu duloso, o hamamee dili odoo sabolo du mapoo dalaga poogoloso, mi odoo mauwe mapoo hasalame diyadeeso. Esino mi opusomo opusomo di mapoo debeli odoo oso goo hagee duloso Yesuye badebei mapoo mubili sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu du maga mubiyodoo daboogoloso tobudulone, odoo susuga oso mooloogoodoo ogoloso yayo diba diya sooloo dolone odoo paigiga tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yesuye egeeseemo sileeme, o hamamee dili odoo oso habe sibileso yimapoo egeesee takaso, “Osoko olo todobuo. Esiga nayo odoo susuga egee do diyadee dee, diayo mosobia koola kee do mapoo dileso nei dieso nalai ee moleeso talame. Bei, mi iyo hagee do mapoo odoo mauwe. Esiga mi hamapoo nei mauwe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Eseme Yesuye dimapoo egeesee takaso, “Niyo diba nei talame diye dee na takee. Esino niyo nei dimapoo tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eseme nei diayo yimapoo egeesee takaso, “Imapoo wo si hedebe dee tiadoo sabolo osoloso di bakadio moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eseme Yesuye nei dimapoo egeesee takaso, “Wo si sabolo osoloso di sabolo amapoo tosibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eseme yayo odoo susuga pukusi mapoo bulume dee takoloso, wo si dee tiadoo sabolo di bakadio toloso Kei mi ma dokodoo bolone Godee mapoo goomoga to takoloso wo popeiso. Osoloso o hamamee dili odoo mapoo nei egee teneme, see diayo odoo mooloogoodoo mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eseme odoo susuga oso nei teiba nega diya edigime nei hosudelega abo poogooso. Osoloso diayo nei naloso abo poogoo ee, Yesu o hamamee dili odoo oso misigamo dileso bou ma kulodu soo bou 12 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Osoloso giso sabolo sobo sabolo osoloso holaiso sabolo oso nei hagee neso. Esino hedebe gisowe hesiga ee 5,000. ");
INSERT INTO kkc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuye 5,000 odoo mapoo nei pi koodobuloso, o hamamee dili odoo mapoo egeesee takaso, “Daga niyo du toloso abei hodiokoo dalo soowee. Ayo odoo hagee bia diye doloso a hamamee ka sibileigo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Osoloso yayo odoo mooloogoodoo olo diye doloso, see obusomo badalame mubi dokodoo howo gisilame palaso. Yo mubi dokodoo peleso badoboome neligaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Esino biame omapoo o hamamee dili odoo oso du mapoo toboloso abei domopooga diyadaga meleeso. Eseme poo sabolo howo ki sabolo simi oso dia du diya bidigaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Osoloso gesi domo kudi takeme, Yesuye abei ma dokodooga dimapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eseme diayo Yesuye simi ogoloso dio dulone diya ebigaso. Bei, diayo goolee boso siba bele dolone diya googaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Eseme Yesuye saga dimapoo egeesee takaso, “Niba howaleegee. Haga na ebi. Ayo siba,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eseme Pitaye egeesee takaso, “Lodee, tei nayo siboga, nayo anosee howomoo meledoboloso howo ma dokodooga namapoo sibeye dee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eseme Yesuye nei egeesee takaso, “Sibe.” Eseme Pita howomoo meledoboloso howo ma dokodooga Yesu mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Esino yo dulone egeino, poo toowa simi oso howo ki toowa sibume, yo diya ebiaso. Egeeseelone yo howo kulomoo oumo moume to neligidi egeesee takaso, “Lodee, a pidi,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eseme Yesuye o deeso Pita saga toloso yimapoo egeesee takaso, “Nayo tei too ee diya pepookodoo. Bei kasalame nayo tei too goo ee ka poogoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Osoloso o bakadio du ma kulodu daboogoome, poo simi omapoo koodobiaso. ");
INSERT INTO kkc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eseme o hamamee dili odoo oso Yesuwo homo bei mapoo gasuwoloso dobolone egeesee takaso, “No tei Godeeyo Owolodoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu o hamamee dili odoo sabolo abei daboogoloso Genesalet mi mapoo dia du oluguso. ");
INSERT INTO kkc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mi omapoo debeli odoo oso Yesu hoodo ogoloso mi opusomo opusomo di mapoo Yesu olo sibago doloso to takomo diso. Eseme odoo aboso odoo paigiga susuga Yesu mapoo ido sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Osoloso odoo paigiga oso Yesu mapoo howolone egeesee takaso, “Iyo wulo nee dugo su mapoo sigilei soowayo?” diso. Eseme odoo paigiga oso Yesuwo dugo su mapoo sigime, odoo egee bia wegigadooso. ");
INSERT INTO kkc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Biame hedebeso Pelisi odoo abo sabolo osoloso tei eligili odoo abo oso Yelusalem maga sibileso Yesuye badebei mapoo mooloogoodoloso yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bei kasalame nee hamamee dili odoo oso ibada adaga dia goo ee dedelega poogoloso dia dee hapelega nei ka nasomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eseme Yesuye nei dimapoo egeesee takaso, “Bei kasalame niyo tei Godeeye eligi goo ee poogoloso see nibada adaga dia goo ee ka dodomo silosomo? ");
INSERT INTO kkc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bei, Godeeye egeesee takaso, ‘Namamo to mapoo osoloso nooweeyo to mapoo mesiloso ka silesibe. Esino edebeeyo ama mapoo osoloso owee mapoo to tokenee takooga, yo wooloome,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Esino niyo egeesee eligiliso, odoo heeso ama dio owee dio biso pidilame tei magoo ee dadalai gowooga, yayo wulo takolone bi egee Godee mapoo tenelame olo to magoloso ka moloso, dee takalai tekepo deliso. ");
INSERT INTO kkc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Goo egeesi maga edebeeyo ama dio owee dio pidilame niyo hamaga takeliso. Niyo goo egeesi moodoolone, Godeeye tei magoo goo ee dedelega see nibada adaga dia goo ee dodolone ka doso. ");
INSERT INTO kkc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Niba goo bakadio gweli odoo. Godee maga to toloso kokodo takomo sili odoo Aisayaye nibada goo maga tei goo takaso. Bei, yayo goo Godeeye taka egeesee hoguguso, ");
INSERT INTO kkc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Odoo hagee bia oso dia magaso wulo gamenee amapoo goomoga poudiliso. Esino dibada sooloo ma kulodu tei amapoo mesili goo ee mauwe. ");
INSERT INTO kkc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Esiga diayo amapoo goomogolone mo hu dokodoo poudili goo eyo bei mauwe. Bei, diayo tei edebeeyo eligi goo ee ayo eligi masi see diayo odoo mapoo eligimo silesibiliso.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuye odoo susuga gilimadoloso dimapoo egeesee takaso, “Odoo susuga niba mo to hagee duloso medee gooleede. ");
INSERT INTO kkc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Esiga edebeeyo nei ne oso Godeeyo howo woola yo tokenee koo peli. Esino edebeeyo o sooloo ma kuloduga goolee to tokenee ee takooga oso Godeeyo howo woola yo tokenee peliso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Osoloso o hamamee dili odoo oso yimapoo sibileso egeesee takaso, “Pelisi odooso nayo taka goo mapoo egee kamanaga no ogoloso gooleedosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eseme Yesuye nei dimapoo egeesee takaso, “Nei howo mo Ma Kei mi ma dokodoo badeli yayo segele susuga ee o too sabolo tigadoloso togobileiso. ");
INSERT INTO kkc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Esiga Pelisi odoo ee nei howo segei egeesi masi moloso. Niyo diba haga na goolee. Diba odoo howo neliga masi doso. Esiga odoo howo neliga heeso odoo howo neliga hee ido duga, o bakadio ou mapoo tigedibileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eseme Pitaye egeesee takaso, “Nayo wudu taka goo eyo bei imapoo medee kibiya eligi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Eseme Yesuye nei egeesee takaso, “Niba to hageeyo bei gooleedelega osee dosomo? ");
INSERT INTO kkc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Esiga nei niyo toloso nali oso nibada sooloo ma kulodu tokenee koo peli. Bei, nei egee nayo nalo sooloogoloso see nee gemedei maga peegoo gadiliso. ");
INSERT INTO kkc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Esino odoo o magaso to tokenee takeli goo susuga oso o sooloo ma kuloduga woola takooga goo oso yo Godeeyo howo woola tokenee peliso. ");
INSERT INTO kkc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bei, o sooloo ma kuloduga goo tokenee susuga hagoso woola peledebeliso: tokenee gweli goo, osoloso odoo hee wooloomali goo, osoloso adaba kooka sobo sabolo kooka giso sabolo goo heli teli goo, osoloso sobo obuo sabolo giso kadiga sabolo goo heli teli goo, osoloso adaba bi heli teli goo, osoloso emegei dimaga gamenee takeli goo, osoloso emegei dia goo maga to tokenee takeli goo. ");
INSERT INTO kkc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Esiga goo tokenee susuga hagoso Godeeyo howo woola odoo tokenee peliso. Esino dee hapelega nei nali oso yo tokenee palaime.” ");
INSERT INTO kkc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu o hamamee dili odoo sabolo mi egee poogoloso see Taya mi toowa sabolo osoloso Saidon mi toowa koola mapoo mi pepuso mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Diba omapoo dileso peledoboome, sobo heeso Yesuye badebei mapoo simiso. Sobo egee Keinen sobo. Esiga yayo Yesu ogoloso to neligidi egeesee takaso, “Lodee, Deibidiyo amawe, nayo a sooloo dele. Bei, mo sobo holo yima kulodu bo holo peleso badolone yimapoo dala toowa tenee domoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Esino Yesuye to hagee duloso to nei takele. Eseme o hamamee dili odoo oso Yesu mapoo sibileso egeesee takaso, “Sobo hagoso iba deedee silone to neligidi takomo silo. Esiga nayo yo diye dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eseme Yesuye nei dimapoo egeesee takaso, “Godeeye a hedebe Isalael odoo sipi be hu masi osugobuloso egee do mapoo diye diso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eseme sobo hagoso see sibileso Yesu o homo bei mapoo gasuwoloso badolone egeesee takaso, “Lodee, a pidi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eseme Yesuye nei sobo yimapoo wudu takolone egeesee takaso, “Holaiso dia nei toloso see so mapoo tenelai tekeponee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Esino sobo hagoso Yesu mapoo egeesee takaso, “O. Lodee nayo tei takoo. Esino so ee amaye nei nolone kokou miyomoo mou ee nalagamo silesibiliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eseme Yesuye nei yimapoo egeesee takaso, “Sobo, nayo tei too diya toowadoo. Esiga nayo goomoga goo taka ee ayo moodoolaiso,” diso. Eseme biame omapoo sobo egeeyo owolo sobo holo olo tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu mi egee poogoloso see Gelili abei palaga dimeleeso. Yo see abaga peleso mubi dokodoo biaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Osoloso odoo mooloogoodoo oso odoo paigiga gilimado sibileso Yesuwo homo beiyopoo ibedigaso. Odoo abo bagi daga poogoo, osoloso odoo howo neliga, osoloso odoo su kakawa poogoo, osoloso odoo to koo keli, osoloso odoo paigiga opusomo opusomo di abo sabolo Yesu mapoo gilimado sibadeeso. Eseme Yesuye odoo paigiga susuga egee bia tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eseme odoo susuga oso goo hagee ogoloso diya howoogadolone Isalael odoo dia Godee mapoo goomoga toowa poudooso. Bei, to koo keli odoo see to keiso, osoloso odoo su kakawa poogoo see toboloso silesibiso, osoloso bagi daga poogoo odoo see tekepo poloso silesibiso, osoloso odoo howo neliga see egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Osoloso Yesuye o hamamee dili odoo gilimadoloso egeesee takaso, “Odoo mooloogoodoo hagee bia biame bakadio hedebe di ee ma kulodu abolo hodobo debeiso. Esino see diayo nei mauwe debei ogoloso diba diya sooloo dalaso. Ayo diba nei tenelega diye daga, diba eli domopoo dumologa houdulone diya wosalai malaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eseme o hamamee dili odoo oso yimapoo egeesee takaso, “Nei mauwe mi hamapoo iyo nei kapoo toloso odoo mooloogoodoo mapoo teiba ka tenelaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eseme Yesuye nei egeesee takaso, “Nimapoo wo si kasolo molosomo?” dee takaso. Eseme diayo nei egeesee takaso, “Imapoo wo si 7 sabolo osoloso di pepooko abo moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Eseme Yesuye odoo susuga mi mapoo bulume dee takoloso wo si 7 sabolo osoloso di pepooko abo toloso Godee mapoo goomoga to takaso. Osoloso wo si popei, di hwei agisaloso o hamamee dili odoo mapoo teneme, see diayo odoo mooloogoodoo mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Odoo susuga nei ne oso diya edigaso. Eseme nei naloso abo poogoo ee o hamamee dili odoo oso misigaloso bou tegei ma kulodu soo bou 7 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Osoloso giso sabolo sobo sabolo osoloso holaiso sabolo oso nei hagee neso. Esino hedebe gisowe hesiga ee 4,000. ");
INSERT INTO kkc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuye odoo susuga diye dee takoloso o hamamee dili odoo sabolo meileso du ma kulodu tebisaloso, Magadan mi koola mapoo dalo soowaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Osoloso Pelisi odoo sabolo osoloso Sedisi odoo oso Yesu mapoo sibileso yimapoo kukulo agalame egeesee takaso, “Nayo kitulugu too egee tei Godee maga simidoo doloso gooleedalaiya, nayo goo toowa opusomo di hee moodee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Esino Yesuye dimapoo egeesee takaso, “Habe osoko tekepo mouga ogoloso niyo egeesee takeliso, ‘Godigi osoko tekepo polodoo,’ dee takeliso. Osoloso gesikolo mi hemiye ogoloso, ‘Epei howo sibulodoo,’ deliso. Esiga goo egeesi oso peledabalai niba olo gooleedooso. Esino goo susuga ayo epedee hagee eligi sabolo osoloso goo susuga ayo epedee hagee moodoomolo eyo bei, niba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Odoo epedee hamapoo egee do niba diya tokenee. Osoloso niyo amapoo tei talai goweliso. Osoloso niyo wulo goo toowa opusomo di moodoo ee agalame amapoo takeliso. Esino ayo nimapoo goo toowa opusomo di hee eligilei mauwe. Esino hedebe Godee maga to toloso kokodo takomo sili odoo Yona eyo goo ono nimapoo eligileiso.” Yesuye goo hagee takemelee koodobuloso diba poogoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Osoloso Yesu o hamamee dili odoo sabolo abei dalo soowaso. Diba omapoo dileso dobolone egeino o hamamee dili odoo oso wo telega boobada neme goo diya koudiaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Diba goo koudulone doboome Yesuye dimapoo egeesee takaso, “Obeeyamo! Pelisi odoo sabolo osoloso Sedisi odoo dia wo ee habiaga, niba medee koolone ka debee.” ");
INSERT INTO kkc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Esino Yesu o hamamee dili odoo oso goo hagee duloso, diesono to moulone egeesee takaso, “Iyo wo telega boobada poogoo simiga Yesuye iba ogoloso egeesee ka takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Eseme diayo goo koudulone debei ee Yesuye ogoloso dimapoo egeesee takaso, “Bei kasi maga niyo wo telega boobada poogoo simi maga goo diya koudulone ka dabala? Niyo tei too goo ee diya pepookodoo. ");
INSERT INTO kkc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Esiga niba ayo kitulugu goo ee gooleedelega osee doso. Esiga niba ayo odoo 5,000 mapoo wo si dee tiadoo populoso pi goo ee boobado buguloso ka doso. Osoloso diayo wo naloso abo poogoo, niyo misigaloso bou ma kulodu soo bou bei metamagisa goo sabolo boobado buguso. ");
INSERT INTO kkc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Esiga niba ayo odoo 4,000 mapoo wo si 7 populoso pi goo ee boobado buguloso doso. Osoloso diayo wo naloso abo poogoo, niyo misigaloso bou ma kulodu soo bou bei metamagisa goo sabolo olo boobado buguso. ");
INSERT INTO kkc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Esiga ayo nimapoo wodee eyo goo maga takele. Esino bei kasi maga niyo goo hagee gooleedelega ka dosomo? Esiga ayo taka goo ee niyo Pelisi odoo sabolo osoloso Sedisi odoo oso eligi goo mapoo hamamee dedeyaga niso nediliyo medee balame to hagee nimapoo ka taka.” ");
INSERT INTO kkc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eseme Yesuye wodee eyo goo maga takelega, wulo Pelisi odoo sabolo osoloso Sedisi odoo oso eligi goo maga ka takeme, Yesu o hamamee dili odoo oso omapoo ogoloso olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu dileso Kasaliya-Pilipai mi mapoo silone o hamamee dili odoo mapoo egeesee takaso, “Edebeeyo Odoo Holo a odoo ogu deliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eseme diayo yimapoo egeesee takaso, “Odoo aboso no Yonee odoo howo oluguli odoo osodoo, dee takeliso. Osoloso odoo aboso no Ilaya, dee takeliso. Osoloso odoo aboso no Yelemaya deliso. Osoloso odoo aboso no Godee maga to toloso kokodo takomo sili odoo hee daga badebei oso molodoo, dee takeliso.” ");
INSERT INTO kkc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eseme Yesuye nei dimapoo egeesee takaso, “Esino hee niyo a odoo ogu deliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Eseme Saimon-Pitaye nei egeesee takaso, “No Keliso, Godeeye hudi magoo, kookaiyo badoboso gie badeli Godeeyo owolo osodoo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eseme Yesuye nei yimapoo egeesee takaso, “Saimon-Pita, Yonayo owolo, no goomege. Bei, odoo heeso goo hagee namapoo ka eligile. Esino mo Ma Kei mi ma dokodoo egee bado oso namapoo ka eligi. ");
INSERT INTO kkc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Esiga Pita, ayo namapoo taka, no yo masi badoso. Esiga ayo yo hagee ma dokodooga mo sosee bei mooloogoolaiso. Egeesi ma kulodu teliso kitulugu oso sosee hagee dagadileime. ");
INSERT INTO kkc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Osoloso ayo Godeeye wiligi doloso badeli osulu ee gibadalame kitulugu namapoo tenelaiso. Esiga nayo takolone, edebeeyo mipoo hamapoo goo moodoolai ee tei daga, goo egee Kei mi mapoo olo tei doloso moloso. Osoloso nayo takolone, edebeeyo mipoo hamapoo goo moodoolai ee tei me daga, goo egee Kei mi mapoo olo tei me moloso.” ");
INSERT INTO kkc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Osoloso yayo tobudulone to kitulugu sabolo o hamamee dili odoo mapoo egeesee takaso, “Niyo odoo abo mapoo takolone a Kelisoso, dee na takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Osoloso biame domo omaga Yesuye o hamamee dili odoo mapoo eyo talai eyo goo ee takomo silame bei mooloogooso. Egeeseelone yayo dimapoo egeesee takaso, “A Yelusalem mapoo pologa, Yu odoowo wiligi odoo sabolo, osoloso tei moso eyo wiligi odoo sabolo, osoloso tei eligili odoo oso amapoo dala tenelaiso. Osoloso edebeeyo a wooloomaloso, bi mapoo ta moloso biame bakadio hedebe di mapoo see bi maga hogadileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eseme Pitaye Yesu peegoo ido dileso tobudulone yimapoo diya kitulugu sabolo takolone egeesee takaso, “Haye Lodee, goo hagoso namapoo peledebeyaga, Godeeye no gooleegeeye dee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Esino Yesuye Pita mapoo bidi toboloso tobudulone egeesee takaso, “Saiten, no amaga peegoo di. To nayo egee takoo oso ayo Godeeye goomoga goo talai ee eli poo. Bei, nayo to egee takoo Godeeye taka ee koo takoo. Esino edebeeyo taka goo ee takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesuye o hamamee dili odoo mapoo see tobu egeesee takaso, “Edebeeyo ayo di hamamee sibilei goomogoga, yo daga eyo goomoga goo tomo sili ee poogoloso, eyo talai sabolo dala toowa talai goo sabolo medee mopoodoo doloso ama hamamee ka sibe. ");
INSERT INTO kkc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Esiga edebeeyo o gie badeli eyo goodogoga, o gie badeli ee osugobalaiso. Esino edebeeyo mo goo maga o gie badeli eyo goodegelega poogooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Esino edebeeyo mipoo hamapoo badolone, eyo goomoga goo susuga ee tomo siloso, hedebe gie badeli goo ee telega dagaduga, yo see ogoo goo talaisomo? Mauwe. Bei, yayo gie badeli eyo nei talai mipoo hamapoo bi hee mauwe. ");
INSERT INTO kkc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Esiga Odoo Holo ayo mo Maye toowa doloso badeli goo omaga o gadeebugu sabolo, osoloso o momaiye sabolo sibileso, odoo susuga oso goo tomo silee eyo nei ayo dimapoo teiba tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Egeesi ma kulodu ayo nimapoo taka. Nima kulodu odoo abo wedilega egee do ee osee doga, Odoo Holo ayo wiligi doloso badalame sibileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Osoloso biame 6 poogoloso Yesuye Pita, Yemes, osoloso Yemeseeyo omolo Yonee esee gilimadoloso mubi hoodee mapoo dabalame paladeeso. ");
INSERT INTO kkc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Diba omapoo peleso dobolone egeino, Yesu o su opusomo doloso osokoso poni masi o mudu maga poni molome egeiso. Osoloso o dugo oso heliye diya gadeebugu masi molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Diba omapoo dobolone egeino, Moses dio Ilaya dio peledoboloso Yesubolo to kesamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eseme Pitaye Yesu mapoo egeesee takaso, “Lodee, iba hamapoo dabalai tekepo. Esiga nayo goomogoga, iyo waseme bakadio hedebe di tegelaiso. Hee nee, osoloso hee Moseseeyo, osoloso hee Ilayayo dalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yo to osee komolome, kolobo diya heliye oso sibileso diba gidisooso. Eseme kolobo ma kuloduga toso egeesee takaso, “Hagee ayo gooma mo holo oso. A namapoo diya goomogo. Esiga o to mapoo medee dui,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eseme Pita diayo goo hagee duloso diya obulone miyomoo balaboo tiesaso. ");
INSERT INTO kkc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Esino Yesuye sibileso dimapoo sigolone egeesee takaso, “Niba tebise. Haga na ebi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eseme diba tebisaloso egeino Yesu obusomo tobudume egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Osoloso diba mubi dokodooga see kumoo moulone, Yesuye dimapoo egeesee takaso, “Goo niyo egei ee odoo abo mapoo na takee. Esino Odoo Holo a ta maga see hogado pala ogoloso, niyo hamamee ka takomo silesibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eseme Pita diayo Yesu mapoo egeesee woosaso, “Bei kasalame tei eligili odoo oso eligilone ‘Daga malalo Ilayaye sibileso Keliso hamamee sibileigo’ dee ka takeliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Eseme Yesuye dimapoo egeesee takaso, “Ilaya tei sibileso goo susuga see medee mopoodoo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Esino ayo nimapoo taka, Ilaya yo olo simiso. Esino edebeeyo yo medee kibiya hoodo egelega yimapoo dala tenemeleeso. Egeeseelone diayo Odoo Holo amapoo dala egeesi masi tenemalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Osoloso diayo Yesuye egeesee taka duloso nei diayo goolee, Yonee odoo howo oluguli eyo goo ee takoo doloso olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu o hamamee dili odoo bakadio hedebe di sabolo mubi dokodooga meileso, odoo susuga diba balagamelee omapoo peledoboome, odoo heeso sibileso Yesuwo homo beiyopoo gasuwoloso badolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lodee, nayo mo giso holo sooloo dologa yo pidi. Bei, yo todo dolone halaboomo silone, eyo nediliyo howomoo homodobuo osoloso dou mapoo homodobuo dolone dala toowa teliso. ");
INSERT INTO kkc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eseme ayo holope egee nee hamamee dili odoo mapoo ido simino, diayo yo tekepo moodoolai tebilena,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eseme Yesuye nei egeesee takaso, “Niba tokenee odoo, tei too mauwe. Niyo amapoo tei talame a biame kasolo nibolo hodobo ka badalaiyo? Ayo biame sage nibolo hodobo badebeino, niyo amapoo tei telega osee doga, a nimapoo diya gowooso. Esino holope egee amapoo ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eseme bo holo holopeyo kulodu pala mapoo Yesuye to kitulugu sabolo takeme peegoo diso. Eseme epedee omapoo holope egee see tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Goo hagoso dileso koodobume, Yesu o hamamee dili odoo oso dibusomo dobolone Yesu mapoo egeesee takaso, “Iyo kaseme bo holo holopeyo kulodu pala ee peegoo habigilei kitulugu mauwe ka poogoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo tei too ee diya pepooko. Goo egeesi maga niyo bo holo peegoo habigilei kitulugu mauwe ka poogoo. Esiga ayo nimapoo taka. Niyo tei too goo ee homokoko pepooko masi mologa, niyo mubi mapoo takolone ‘no see koo dileso mele’ dee takooga, tei egeesee selaiso. Esiga egeesi ma kulodu goo susuga niyo moodoolai tebileiso.  ");
INSERT INTO kkc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Esino bo holo hageesi masi peegoo habigili ee hedebe nei tei doloso dobolone Godee mapoo taka maga bo holo peegoo ka habigiya.” ");
INSERT INTO kkc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu o hamamee dili odoo oso sibileso Gelili mi mapoo mooloogoodoloso doboome, Yesuye dimapoo egeesee takaso, “Odoo Holo a odoo mapoo tiasalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Osoloso diayo a wooloomalaiso. Esino a bi mapoo ta moloso biame bakadio hedebe di mapoo gie badeli toloso hogadileiso.” Eseme Yesu o hamamee dili odoo oso to hagee duloso diya gooheleso. ");
INSERT INTO kkc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Osoloso see tobu Yesu o hamamee dili odoo sabolo dileso Kapeniyum mi mapoo peledoboome, tei moso ee pidilame tekisi molee teli odoo aboso sibileso Pita mapoo egeesee takaso, “Nibada eligili odoo yo tei moso ee pidilame tekisi molee tenelisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Eseme Pitaye nei egeesee takaso, “O. Teneliso,” diso. Esino Pita epedee omapoo moso kulodu Yesuye badebei mapoo gasibume, Yesuye Pita mapoo egeesee takaso, “Saimon, nayo goo hagee amapoo takee. Mipoo hageeyo wiligi odoo tebisa oso odoo ogu bia dimaga tekisi molee ka teliyo? Odoo diayo bali maga teliyo o, odoo abo maga ka teliyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eseme Pitaye nei egeesee takaso, “Odoo abo maga ka teli,” diso. Eseme Yesuye nei egeesee takaso, “Esiga wiligi odoo diayo bali odoo diba tekisi molee dia wiligi odoo mapoo koo teneli. ");
INSERT INTO kkc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Esino tei moso ee pidilame tekisi molee teli odoo hagee bia ee kemeneyaga, iyo tekisi molee tenelega pagalai tekeponee. Esiga no dileso abei mapoo kimaso di gi. Osoloso di malalo gi eyo maga gwaloso ogoga molee ko molo agalaiso. Eseega nayo molee egee toloso dimapoo ibada tekisi molee magee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Biame domo omapoo Yesu o hamamee dili odoo oso sibileso Yesu mapoo egeesee takaso, “Godeeye wiligi doloso badeli goo mapoo odoo agayo toowa doloso ka badosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eseme Yesuye holope hee idoloso dima domo tobudume, o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Ayo nimapoo taka. Nibada goo goolee su wudoloso holope hageesi masi badelega poogooga, niba Godeeye wiligi doloso badeli goo mapoo gadileime. ");
INSERT INTO kkc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Esiga odoo agayo holope pepooko hageesi masi o su eyo nediliyo pepooko daga, yo Godeeye wiligi doloso badeli goo mapoo toowa doloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Osoloso odoo agayo holope hageesi masi mo hu maga o mosopoo ido pologa, yo a ido pala masi ido poloso. ");
INSERT INTO kkc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Esino odoo heeso tei too odoo hee goo tokenee mapoo gido duga, nei odoo heeso o mu mapoo yo toowa bagagoloso howo bou mapoo toosoolai ee dala haga toowanee. Bei, hamamee Godeeye odoo goo egeesi moodeli mapoo dala toowa tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ye-ee, mipoo hamapoo debeli odoo, niba emegei! Bei, mipoo hamapoo niba goo tokenee mapoo gido dili goo diya bei moloso. Esiga goo egeeseeso sibileiso. Esino goo tokenee mapoo gido dili odoo, niba obeeyamo! Godeeye odoo egeesee seli mapoo dala diya toowa tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Osoloso nee dee hodio oso no goo tokenee talame gido duga, dee hodio egee kobigi, dee hediliwe badoboso kookaiyo gie badeli talai tekepo. Esino nee dee bakadio dou koo semili mapoo dilei tekeponee. Osoloso nee homo hodio oso no goo tokenee talame gido duga, homo hodio egee kobigi, homo hediliwe badoboso kookaiyo gie badeli talai tekepo. Esino nee homo bakadio dou koo semili mapoo dilei tekeponee. ");
INSERT INTO kkc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Osoloso nee howo hodio oso no goo tokenee talame gido duga, nee howo hodio egee tabigi, howo hediliwe badoboso kookaiyo gie badeli talai tekepo. Esino nee howo bakadio dou koo semili mapoo dilei tekeponee. ");
INSERT INTO kkc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Esiga niba obeeyamo. Holaiso hagee bia goo mauwe dee na goolee. Bei, Godeeyo momaiye oso Kei mi ma dokodooga Ma Godeeyo howo woola dimapoo ka bamoloso.  ");
INSERT INTO kkc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bei, Odoo Holo ayo simi hagee odoo Godee maga peegoo osugoba dimapoo gie badeli tenelame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Odoo heeso sipi be hu 100 gibadalaiso. Egeesi ma kulodu sipi be hedebe osugoboodoga, yayo see ogoo goo moodoolaisomo? Sipi be hu abo 99 ee omapoo doga, yo see hedebe osugoba ee esiamo dileiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Esiga ayo nimapoo taka. Sipi be hu 99 osugobele mapoo yo goomoga moloso. Esino sipi be hedebe osugoba ee esiameleso ogoga, yo diya goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Esiga holaiso hageesee heeso yimaga peegoo osugobalai nibada Ama Kei mi ma dokodoo egee bado yo koo goomogoso.” ");
INSERT INTO kkc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Esiga tei too odoo oso namapoo goo tokenee moodooga, nayo mada dileso yimapoo o goo tokenee ee takalai tekepo. Egeesi ma kulodu yayo nee to duloso mesioga, yo see goo tekepo mapoo ido siboso. ");
INSERT INTO kkc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Esino yayo nee to duloso mesile poogooga, nayo see tei telaga odoo hedebe, o, bakadio egeesi gilimadoloso yo agalame di, diayo to nayo taka ee tei takadoo dalame. ");
INSERT INTO kkc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Egeesi ma kulodu yayo dibada to duloso mesile poogooga, goo hagee tei telaga odoo susuga sosee ma kulodu egee do mapoo takee. Esino yayo see dibada to duloso mesile poogooga, yo see peegoo badeli odoo o, goo tokenee teli odoo dalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Esiga ayo nimapoo taka. Osoloso niyo ogoo goo ee mi hamapoo tiadoo mologa, Kei mi ma dokodoo osee tiadoo molo agalaiso. Osoloso niyo mi hamapoo ogoo goo ee puobuguga, Kei mi ma dokodoo puobugu molo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Esiga ayo see nimapoo taka. Mipoo hamapoo odoo bakadio oso goo goolee hedebe doloso ogoo goo talame Godee mapoo takooga, mo Ma Kei mi ma dokodoo egee bado oso diayo goomoga goo ee tei moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Esiga odoo bakadio egeesi o, bakadio hedebe di egeesi oso sibileso mo hu maga mooloogoodoloso doga, a dibolo hodobo badoso.” ");
INSERT INTO kkc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Osoloso domo omapoo Pitaye sibileso Yesu mapoo egeesee woosaso, “Lodee, mo tei too odoo oso amapoo goo tokenee toga, ayo nei o goo tokenee ee kasolo boobado bigileiyo? 7 mapoo toobooga ka koodobileiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eseme Yesuye nei egeesee takaso, “Haye, hedebe 7 mapoo toobooga o goo tokenee na boobado bigi. Esino o goo tokenee hapoloso boobado bigili ee na koodobie. ");
INSERT INTO kkc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Osoloso Godeeye wiligi doloso badeli goo ee egeesee moloso. Wiligi odoo o tou teli odoo oso molee howadooso, see hamamee teiba hedebe egeesi yimapoo ka tenelame. Eseme hamamee wiligi odoo oso molee egee see talai goomogolone, o odoo mapoo takolone, odoo molee howadoo egee bia yimapoo gilimado sibeye diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eseme o tou teli odoo hee daga molee toowa 10,000 talent deli ee howadoo ee yimapoo ido simiso. ");
INSERT INTO kkc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Eseme odoo ogoso molee teiba egeesi nei tenelai tebile. Eseme wiligi odoo oso o odoo mapoo egeesee takaso, ‘Odoo hagee sabolo, osoloso osobo, osoloso owolo dio, osoloso o bi susuga toloso odoo abo mapoo tenee, nei molee talame. Osoloso see molee egee amapoo tosibe,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Osoloso o tou teli odoo yayo o wiligi odoowo homo beiyopoo gasuwoloso ebiso miyomoo tugusaloso badolone howolone egeesee takaso, ‘Nayo a sooloo dologa biame deiyepo amapoo tenee. Ayo hamamee nee molee teiba hedebe egeesi namapoo tenelaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eseme wiligi odoo oso yo diya sooloo dolone yimapoo egeesee takaso, ‘Nayo mo molee howadoo eyo nei hamamee amapoo tenelaigo, dee takemeni ee bige peegee. Bei, ayo goo egee olo boobado buguso. Esiga no goomoga sabolo di,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Osoloso tou teli odoo ee see wedi dulone o odoo tugodooso. O odoo hagoso yimaga molee howadoo ee haga toowanee (goo egee, molee ko 100 denaliyus deli ee howadoo). Esino tou teli odoo oso yo ogoloso o gabada mapoo toloso debidolone egeesee takaso, ‘Nayo mo molee howadoo eyo nei teiba hedebe egeesi amapoo tenee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eseme odoo hagoso tou teli odoowo homo beiyopoo gasuwoloso ebiso miyomoo tugusaloso badolone yimapoo howolone egeesee takaso, ‘Nayo a sooloo dologa biame deiyepo amapoo tenee. Bei, ayo hamamee nee molee teiba hedebe egeesi namapoo tenelaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Esino tou teli odoo yo o odoo oso egeesee takeme gowoolone yo todileso neliga moso mapoo toosooso, yayo nei teiba egeesi yimapoo teneega peegoo ka tamagalame. ");
INSERT INTO kkc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Esino wiligi odoo o tou teli odoo aboso goo hagee ogoloso diya gowoolone wiligi odoo mapoo takalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eseme wiligi odoo yo goo hagee duloso o tou teli odoo ee idoloso yimapoo egeesee takaso, ‘No tei diya tokenee odoodoo. Nayo mo molee hoowadoloso see hamamee tenelai tebile neme, ayo no sooloo dolone bige peegee dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Goo egeesi maga, nayo mo tou teli odoo hee sooloo dala diepi, tekepo meliyo,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Egeesee takoloso wiligi odoo oso komonolone o tou teli odoo ee neliga moso gidebeli odoo mapoo teneeso, diayo yo neliga moso mapoo toosooloso dala tenelame. Osoloso yayo nei teiba hedebe egeesi yimapoo teneega peegoo ka tamagalame.” ");
INSERT INTO kkc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesuye to hagee taka koodobuloso see odoo mapoo egeesee takaso, “Esiga niyo nee sooloo ma kuloduga tei too odoo eyo goo tokenee boobado bigilega poogooga, wiligi odoo oso o tou teli odoo mapoo moodoo egeesi masi nei mo Ma Kei mi ma dokodoo egee bado oso nimapoo egeesee moodoolaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuye goo hagee takoloso koodobuloso Gelili mi poogoloso see Yudiya mi mapoo dulone Yoden howo daloso diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yo omapoo dime, odoo mooloogoodoo oso yo dodomo diso. Eseme Yesuye paiye dima kulodu melee susuga ee tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eseme biame omapoo Pelisi odoo aboso sibileso Yesu mapoo gamenee kukulo agalame yimapoo egeesee takaso, “Edebeeyo sobo huloso wulo goo hee maga osobo pagalai tei molosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Eseme Yesuye nei dimapoo egeesee takaso, “Niba Godeeyo to hesigeleyo? Godeeye mipoo hagee moodoo biame mapoo giso sabolo sobo sabolo moodooso. ");
INSERT INTO kkc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Osoloso Godeeye egeesee takaso, ‘Esiga gisoso ama dio owee dio poogoloso see osobo sabolo hedebe doloso badalaiso. Osoloso obakadio su hedebe doloso dabalaiso,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Esiga diayo debei ee ma kulodu diba bakadio nee, esino diba see olo hedebe doloso ka doso. Esiga Godeeye diba hedebe di goo ee see odoo heeso domo na pi.” ");
INSERT INTO kkc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Esino Pelisi odooso nei Yesu mapoo egeesee takaso, “Bei kasi maga Moseseeye takolone, sobo pagalame gooleega, sobo pegeli peipa mapoo hoguguloso sobo egee pagalai soowa, dee ka takayo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eseme Yesuye nei dimapoo egeesee takaso, “Moseseeye egeino yayo eligi goo mapoo niyo mesilega poogolo neme, bige, sobo pagalai soowa dee ka taka. Esino bei mooloogoo biame mapoo sobo huloso pagalai goo ee Godeeye takele. ");
INSERT INTO kkc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Esiga ayo nimapoo taka, gisoso osobo na peegee. Esino soboso giso hee sabolo olo goo heli too daga, omoye osobo egee pagalai tei mauwe. Esiga gisoso wulo goo hee maga osobo poogoloso see sobo hee huga, yo odoo heeyo osobo ee peedee huso.” ");
INSERT INTO kkc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eseme Yesu o hamamee dili odoo oso yimapoo egeesee takaso, “Esiga gisoso wulo goo hee maga osobo pagalai ee tei daga, gisoso sobo hulei tekeponee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Eseme Yesuye nei dimapoo egeesee takaso, “Goo hagee odoo susuga oso dadalai tebile. Esino hedebe Godeeye kitulugu tenee odoo oso goo hagee dadalai teiba. ");
INSERT INTO kkc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bei, odoo aboso sobo huloso holo soolooga magalai tebile. Bei, diba dibada oweeye ho mauwe soomagooga. Goo egeesi maga diba sobo koo huli. Osoloso odoo abo ho tigaga diba sobo koo huli. Esino odoo aboso Godeeye wiligi doloso badeli eyo goo maga sobo koo huli. Esiga edebeeyo sobo huli eyo goo maga ayo eligi goo ee talai teiba daga, yo goo ayo eligi hagee medee dadalai tekepo.” ");
INSERT INTO kkc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Odoo aboso owolo dio Yesu mapoo iyado simiso, Yesuye o deeso diba sigolone diba Godee mapoo takalame. Eseme o hamamee dili odoo diayo goo hagee ogoloso hamaga takaso. ");
INSERT INTO kkc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eseme Yesuye o hamamee dili odoo mapoo egeesee takaso, “Holaiso amapoo sibadee dee, diba na hamaga takee. Bei, edebeeyo holaiso hageesi masi oso Godeeye wiligi doloso badeli mapoo gadileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Osoloso yayo o deeso diba sigolone Godee mapoo takoloso see mi hee mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Odoo heeso Yesu mapoo sibileso egeesee takaso, “Eligili odoo, ayo ogoo goo tekepo ee toga, badoboso kookaiyo gie badeli ka talaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eseme Yesuye nei yimapoo egeesee takaso, “Bei kasalame nayo sibileso goo tekepo talai goo maga amapoo ka woosowala? Hedebe Godeeye tekepo ka badoso. Esiga no badoboso kookaiyo gie badeli talai goomogoga, no tei magoo goo ee medee deedee.” ");
INSERT INTO kkc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eseme odoo ogoso egeesee takaso, “Tei magoo kagee takala?” diso. Eseme Yesuye nei yimapoo egeesee takaso, “Odoo na wooloome, osoloso adaba kooka sobo sabolo goo heli na te, osoloso adaba bi heli na te, osoloso odoo hee mapoo gamenee na gigidi, ");
INSERT INTO kkc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","osoloso nama dio noowee dio oso taka to mapoo mesie, osoloso nee su no nediliyo egee sooloo dolo egeesi masi nee odoo hee nosee egeesee sooloo dele.” ");
INSERT INTO kkc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eseme odoo gie kauwa ogoso Yesu mapoo egeesee takaso, “Tei magoo goo susuga ayo tobuloso medee deedeeso. Esino ayo see ogoo goo hee ka moodoolaisomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eseme Yesuye nei yimapoo egeesee takaso, “No medee teedee badalai goomogoga, nee bi susuga odoo abo mapoo teneloso nei molee toloso odoo bi mauwe mapoo tenee. Nayo egeesee seega, Kei mi mapoo bi bei nee hu sabolo malaiso. Osoloso a dodomo sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eseme odoo gie kauwa ogoso Yesuwo to duloso diya goohele sabolo diso. Bei, yo bi bei doloso badebeiga. ");
INSERT INTO kkc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eseme Yesuye o hamamee dili odoo mapoo egeesee takaso, “Ayo nimapoo taka. Bi bei odoo oso Godeeye wiligi doloso badeli goo mapoo gadilei diya kalawa. ");
INSERT INTO kkc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Esiga ayo nimapoo see tobu taka, dugo duseli midole ou maga kemol be toowa oso gadilei kalawa. Esino bi bei odoo oso Godeeye wiligi doloso badeli mapoo gasibilei diya kalawa toowa,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eseme o hamamee dili odoo oso yayo eligi goo hagee duloso diya dio dulone egeesee takaso, “Goo egee diya kalawadoo. Esiga odoo agayo gadileisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eseme Yesuye dimapoo bolone egeesee takaso, “Edebeeyo o gie badeli eyo nediliyo pidilei tebile. Esino Godee yo teiba. Bei, goo susuga yayo moodoolai haga kalawanee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eseme Pitaye nei Yesu mapoo egeesee takaso, “Ibada bi susuga hoogoo poogoloso nayo di hamamee deedee simiso. Esiga iba nei ogoo bi talaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Eseme Yesuye nei egeesee takaso, “Ayo nimapoo taka. Godeeye goo susuga see dia moodoolai biame mapoo, Odoo Holo ayo wiligi doloso badeli mi mapoo badalaiso. Osoloso biame omapoo mo hamamee dili odoo 12 niba nosee wiligi odoo oso bili 12 mapoo dobolone, Isalael odoo bala 12 ee niyo gidabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Osoloso odoo agayo emei dio, omolo dio, omoo dio, ama dio, owee dio, owolo dio, osoloso dia mi sabolo, dia moso poogoloso mo goo tomo siloga, diba nei toowa talaiso. Osoloso diba kookaiyo badoboso gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Esiga odoo abo epedee hamapoo malalo hagee do ee see diba hamamee dabalaiso. Esino odoo abo epedee hamapoo hamamee hagee do oso see malalo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Homolee eyo amaye gesikolodee tou teli odoo gilimalame diso, diayo o homolee geleipi ko segei mapoo tou talame. ");
INSERT INTO kkc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Osoloso yayo odoo abo ogoloso yibolo hodobo to mouloso goomoga magooso, biame hedebe mapoo diayo tou too eyo nei odoo hedebe hedebe dimapoo molee ko hedebe tenelame. Osoloso diba tou talame diye diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Osoloso homolee eyo amaye osoko howo 9 domo mapoo yo see wedi dileso egeino, odoo abo tou telega wulo tebisamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eseme yayo dimapoo egeesee takaso, ‘Niba see mo homolee mapoo tou talame di. Eseega ayo habe nimapoo niyo tou too eyo nei molee teiba tenelaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eseme diba tou talame diso. Osoloso biame hedebe omapoo osoko oo domo tooboome, odoo abo gilimado dileso o homolee mapoo tou teye diso. Osoloso biame hedebe ososee osoko howo bakadio hedebe di mapoo, yayo see tobu odoo abo gilimado dileso o homolee hedebe omapoo tou teye diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Osoloso biame hedebe omapoo osoko howo dee tiadoo mapoo tooboome, yo see wedi dileso egeino, odoo abo tou telega wulo tebisamolome egeiso. Eseme yayo dimapoo egeesee takaso, ‘Niba kasalame tou telega biame toowa wulo hamapoo mosoowe ka tebisamalala?’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eseme diayo nei egeesee takaso, ‘Odoo heeso imapoo o tou teye dee takele,’ diso. Eseme yayo dimapoo egeesee takaso, ‘Niba nosee mo homolee mapoo tou talame sibe,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Eseme habe homolee eyo amaye o tou teli eyo wiligi odoo mapoo egeesee takaso, ‘Homolee ma kulodu tou telagali odoo gilimadoloso dia tou too eyo nei molee tenee. Esiga nayo nei molee teneega, tou talame hamameedee sibili odoo mapoo daga malalo ka tenee,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eseme tou teli odoo oso dia nei talame sibileso mooloogoodoome, odoo tou talame hamameedee sibili dimapoo tou too eyo nei molee ko hedebe hedebe di teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Osoloso gesikolodee odoo daga malalo tou talame diyadee oso goo egee ogoloso diayo goolee, diba dia tou eyo nei toowa talaiso, dee goolone debeiso. Esino diba onosee molee ko hedebe egeesi tooso. ");
INSERT INTO kkc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Diba molee egee toloso gowoolone homolee eyo ama mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Iba biame toowa osoko pa mapoo tou toowa telagameleeso. Esino odoo hagee bia wulo osoko howo deiyepo mapoo tou ka too. Esino nayo kasi maga molee dimapoo tenee hedebe egeesi masi imapoo ka tonowala?’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Eseme homolee eyo amaye dima kulodu odoo hee mapoo egeesee takaso, ‘Emegei, ayo goo tokenee hee namapoo moodele. Bei, no biame hedebe mapoo tou too eyo nei molee ko hedebe egeesi masi talai doloso tou talame goomoga magooso. ");
INSERT INTO kkc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Esiga nee molee egee toloso di. Ayo molee namapoo tenee hedebe egeesi masi odoo abo mapoo tenelai a goomogo. ");
INSERT INTO kkc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bei, mo molee oso mawo goomoga goo ee talai tekepo. Esino kasi maga goo tekepo ayo moodoo ee ogoloso, nayo amapoo ka komonowala?’ dee takaso.” ");
INSERT INTO kkc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eseme Yesuye see egeesee takaso, “Esiga odoo abo epedee hamapoo malalo hagee do ee see diba hamamee dabalaiso. Esino odoo abo epedee hamapoo hamamee hagee do oso see malalo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Yelusalem mapoo polone o hamamee dili odoo 12 peegoo gilimado dileso dobolone dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Goolee! Iba Yelusalem mapoo olo duso. Omapoo Odoo Holo a Yu odoo dia tei moso wiligi odoo tebisa sabolo osoloso tei eligili odoo mapoo tiasalaiso. Osoloso diayo mo goo midiloso ayo talai goo ee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Osoloso Yu odoonee oso a toloso manolone woolaiso. Osoloso a woomo dileso homo bulubo magoo ma dokodoo yoguso enigileiso. Esino a bi ma kulodu ta moloso biame bakadio hedebe di mapoo see gie badeli toloso hogadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Osoloso Sebediyo owolo Yemes dio Yonee dio oweeye gilimadoloso Yesu mapoo simiso. Osoloso oweeye goomoga goo ee Yesu mapoo ogo takalame, o homo beiyopoo gasuwoloso badebeiso. ");
INSERT INTO kkc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eseme Yesuye yimapoo egeesee takaso, “Nayo amapoo ogoo goo takalame ka simiyo?” diso. Eseme yayo Yesu mapoo nei egeesee takaso, “Nayo wiligi doloso badalai mi mapoo mo holo bakadio hagee heeso nee dee deedee dokolo bado, osoloso hee nee dee dobusu dokolo bado dalai tekepowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eseme Yesuye dimapoo egeesee takaso, “Niyo egee takoo goo ee niba koo gooleedo,” dee takaso. Osoloso yayo Yemes dio Yonee dio mapoo egeesee takaso, “Dala toowa ayo talame egee molo niba nosee egeesee talai teibayo?” diso. Eseme diayo nei egeesee takaso, “O. Iba teiba,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Eseme Yesuye nei dimapoo egeesee takaso, “Tei takoo, niba nosee dala hageesee talaiso. Esino mo dee deedee dokolo dabalai odoo sabolo, osoloso mo dee dobusu dokolo dabalai odoo hesigilei amapoo kitulugu mauwe. Esino hedebe mo Maye hesiga odoo oso mi omapoo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Egeesi ma kulodu Yesu o hamamee dili odoo abo 10 oso to hagee duloso Yemes dio Yonee dio mapoo diya kamanaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Eseme Yesuye o hamamee dili odoo susuga gilimadoloso dimapoo egeesee takaso, “Yu odoonee dia wiligi odoo oso dima hemidu debeli odoo ee kitulugu sabolo gidebeliso. ");
INSERT INTO kkc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Esino nima kulodu egeesee selai tekeponee. Esiga nima kulodu edebeeyo toowa doloso badalai goomogoga, yo tou teli odoo masi mesie sabolo odoo abo halo tou tolone ka badebee. ");
INSERT INTO kkc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Osoloso edebeeyo malalo badalai goomogoga, yo tou wulayo teli odoo masi odoo abo halo tou tolone ka badebee. ");
INSERT INTO kkc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bei, Odoo Holo ayo mipoo hamapoo simi hagee edebeeyo a pidilame ka sibile. Esino ayo odoo pidilame ka simi. Osoloso odoo susuga Godee mapoo iyado sibilame a talame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu o hamamee dili odoo sabolo Yeliko mi poogoloso diyadaga molome, odoo mooloogoodoo toowa oso diba dodomo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Egeesee semelee domo omapoo odoo howo neliga bakadio eli pee mapoo debeiso. Diayo Yesuye simi goo ee duloso to neligidi egeesee takaso, “Lodee, Deibidiyo amawe, nayo iba sooloo dolone pidi,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Esino odoo susuga oso dimapoo diya takolone egeesee takaso, “Niba to mauwe debee,” diso. Esino odoo susuga oso dimapoo egeesee takeme, diba dia to dulega see diya neligidi egeesee takaso, “Lodee, Deibidi amawe, nayo iba sooloo dolone pidi,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eseme Yesuye omapoo kookoodoboloso diba iyadoloso dimapoo egeesee takaso, “Ayo nimapoo ogoo goo moodoolai goomogolo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eseme diayo nei yimapoo egeesee takaso, “Ibada howo tekepo moodee. Iba agalai goomogo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuye diba sooloo dolone dibada howo deeso sigeso. Eseme saga omapoo dibada howo tekepo poome, Yesuye di hamamee diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu o hamamee dili odoo sabolo Yelusalem mi koola mapoo dulone, Olipi mubi kumoo mi pepooko Betapage mapoo peledabaso. Diba omapoo peledoboloso dobolone, Yesuye o hamamee dili odoo bakadio malalo diye dolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Niba mi hee malalo koogee mapoo di. Niba omapoo dileso ogoga, donki be o pe sabolo dia mu mapoo ebigiso bagagoloso, omou mapoo bagagoo mologa saga agalaiso. Eseega niyo ebigi pidiga poogoloso amapoo hado sibe. ");
INSERT INTO kkc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Egeesi ma kulodu odoo heeso nimapoo takooga, niyo nei yimapoo egeesee takee, ‘Lodeeye donki be bakadio egee goomogogona,’ dee takee. Egeeseega odoo ogoso saga nimapoo takolone donki be egee hado diye dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Esiga goo hagoso peledaba ee Godee maga to toloso kokodo takomo sili odoo oso to taka sabolo tebilame ka see. Bei, yayo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Niyo Yelusalem mapoo debeli odoo mapoo takee, ‘Ege, nibada wiligi odoo nimapoo olo sibo. Yo mesie taba. Yo donki be pepooko mapoo buloso ka siboso.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eseme Yesu o hamamee dili odoo bakadio oso Yesuye taka goo ee tobuloso moodooso. ");
INSERT INTO kkc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Diba dileso donki be owee sabolo osoloso o pe sabolo hado simiso. Osoloso dibada kekeisu dugo tigadoloso donki be dia wagi ma dokodoo palagaloso, Yesuye omapoo peleso biaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eseme odoo mooloogoodoo toowa oso dia kekeisu dugo tigadoloso eli domopoo palagamo dime, odoo aboso weiyo kookooloso Yesuye sibilei eli mapoo palagamo diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eseme Yesuye donki be ma dokodoo buloso dimolome, malalo diyadee odoo sabolo osoloso Yesu ma hamamee sibadee odoo oso to neligidi egeesee takaso, “Iba Deibidiyo amawe mapoo goomogo. Odoo Godeeyo hu maga kitulugu sabolo egee sibo yo Godeeye pidiye dee. Kei mi ma doko hodoo badeli Godee mapoo goomogo,” dee takagamo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu Yelusalem mi ma kulodu gadime, odoo susuga omapoo debei oso diya dio dulone egeesee takaga meleeso, “Hagee odoo ogubele?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eseme odoo mooloogoodoo oso nei egeesee takaso, “Hagee Godee maga to toloso kokodo takomo sili odoo Yesu oso. Yo Gelili mi toowa ma kulodu Nasalet mi pepooko maga ka siboso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuye Yelusalem mapoo sibileso tei moso mapoo peleso egeino, odoo susuga oso tei moso tegei ma kulodu gala sabolo bi abo sabolo neiso telaga molome egeiso. Yo goo egee agalai gowoolone, yayo moso ee ma kulodu melee bi eyo ama sabolo osoloso bi ee telaga odoo sabolo peegoo hasiso buguso. Osoloso molee piligeli odoo dia debi pooba sabolo bidige buguso. Osoloso molo huyado sibileso nei moleeso teli odoo susuga oso bili pooba sabolo bidige buguso. ");
INSERT INTO kkc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Osoloso Yesuye dimapoo egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Mo tei moso ee edebeeyo sibileso Godee mapoo takeli moso,’ diso. Esino niyo Godeeyo moso hagee heli teli odoo oso mada wuli moso ka poso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Egeesee semelee biame omapoo Yesu tei moso ma kulodu badoboome, howo neliga odoo abo sabolo, osoloso odoo bagi daga poogoo yimapoo sibadeeso. Eseme yayo diba tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Esino tei moso wiligi odoo tebisa sabolo osoloso tei eligili odoo oso Yesuye goo toowa opusomo di moodoomo silee ogoloso diya kamanaso. Egeeseelone holaisoso tei moso ma kulodu dobolone toso neligidi takolone egeesee takaso, “Deibidiyo amawe Yesu mapoo goomogo,” dee takaga melee duloso diayo dimapoo diya goweso. ");
INSERT INTO kkc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Osoloso diayo see Yesu mapoo egeesee takaso, “No holaisoso to egee takoo medee dusomo?” diso. Eseme Yesuye nei dimapoo egeesee takaso, “O. A duso. Esino niba Godeeyo to booka mapoo hogugu ee hesigelega dosomo? Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Godeeye holaiso sabolo osoloso holope oso o hu dokodoo poudilei goo ee dimapoo olo eligiso,’ dee takaso.” ");
INSERT INTO kkc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Osoloso Yesuye diba poogoo dileso Yelusalem mi maga see Betani mi mapoo tilame diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gesikolo Yesu Yelusalem mapoo see wedi dulone hodiaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eseme dulone pigi homo eli palaga mapoo dime ko pa beleso agalame diso. Esino ko pelega wulo duwe molome egeiso. Eseme Yesuye pigi homo hamapoo egeesee takaso, “No see tobu ko palaime,” diso. Eseme epedee omapoo homo saga siaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesu o hamamee dili odoo oso goo hagee ogoloso dio dulone egeesee takaso, “Pigi homo hagee saga kasee siabele?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo taka. Niyo tei toloso dobolone goo goolee bakadio delega doga, ayo homo hamapoo moodoo goo ee niba nosee egeesee moodoolai tebileiso. Osoloso goo hedebe hagonosee talai tebile. Esino niyo goo toowa abo moodoolaiso. Egeeseelone niyo mubi hamapoo takolone ‘no nediliyo tadoloso howomoo mei’ dee takooga, goo oso tei peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Esiga niyo tei tolone Godee mapoo takooga, yayo goo niyo hoowa eyo nei nimapoo tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu see Yu odoowo tei moso mapoo peleso Godeeyo to odoo susuga mapoo eligimolome, tei moso wiligi odoo tebisa sabolo osoloso Yu odoo dia wiligi odoo tebisa oso sibileso Yesu mapoo egeesee takaso, “No agamo kitulugu maga goo hagee ka moodoomo silala? Odoo agayo namapoo kitulugu hagee ka teneeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Eseme Yesuye nei dimapoo egeesee takaso, “Anosee woosali to hedebe nimapoo woosalaiso. Odoo agayo Yonee mapoo kitulugu ka teneeyo, yayo odoo howo olugulame? Kitulugu Godeeye teneeyo o, edebeeyo teneeyo? Esiga niyo to eyo nei amapoo takooga, anosee ayo kitulugu toloso hagee silo eyo goo ee nimapoo ka takalai,” diso. Eseme diayo to hagee duloso dieso nediliyo to moulone egeesee takaga meleeso, “Iyo kasee takalaisomo? Iyo takolone Yoneeye kitulugu ee Godeeye teneedoo, dee takooga, see nei Yesuye imapoo egeesee takalaiso, ‘Niba bei kaseme Yoneeyo to mapoo tei telega ka poogoowo?’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Osoloso iyo takolone kitulugu odoo maga simigo daga, odoo susuga oso imapoo diya kamanalaiso. Bei, odoo susuga oso takolone Yonee yo Godee maga to toloso kokodo takomo sili odoo deliso.” ");
INSERT INTO kkc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Egeeseelone diayo nei Yesu mapoo egeesee takaso, “Yoneeye kitulugu too goo eyo bei, iba gooleedele,” dee takaso. Eseme Yesuye nei dimapoo egeesee takaso, “Esiga ayo goo hagee moodoomo silame kitulugu too hagee nimapoo takalaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Esiga niba goo hamapoo kasee gooleesomo? Odoo heeso o giso holo bakadio gilimadoloso debeiso. Esiga yayo daga holo mapoo egeesee takaso, ‘Mo holo, no epei geleipi ko segei homolee mapoo tou talame di,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Esino giso holo oso nei egeesee takaso, ‘A gowoo,’ diso. Esino yo see hamamee o goo goolee su wuduloso tou talame diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Osoloso amaye see tobu owolo hee mapoo dileso egeesee takaso, ‘No geleipi ko segei homolee mapoo tou talame di,’ dee takaso. Eseme owoloye nei egeesee takaso, ‘O. A tou talame dileiso,’ diso. Esino yo dilega poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Esiga holaiso bakadio hagee bia hee kaso amaye goomoga goo ka toowo?” Eseme tei moso wiligi odoo tebisa sabolo osoloso Yu odoo dia wiligi odoo tebisa oso yimapoo egeesee takaso, “Daga holo oso amaye goomoga goo ee tooso,” dee takaso. Eseme Yesuye dimapoo egeesee takaso, “Ayo nimapoo taka. Tekisi molee teli odoo sabolo osoloso domo silesibili sobo oso daga diayo Godeeye wiligi doloso badeli goo mapoo gadulone hee niba peegoo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bei, Yoneeye nimapoo goo tekepo eligime, niyo o to duloso tei tele. Esino goo tokenee teli odoo hagee bia oso Yoneeyo to duloso tei tooso. Osoloso niyo diayo tei too goo ogoloso goo goolee su wuduloso Yoneeyo to mapoo tei tele poogooso.” ");
INSERT INTO kkc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Osoloso see hee hagee wudu takoo dui. Biame heeso homolee eyo amaye homolee mapoo geleipi ko segeiso, osoloso pee maga beeleeso. Osoloso ko i debilame yo ou poogoloso homolee egee gibadalame doko moso tegeiso. Osoloso yayo homolee bali odoo abo mapoo beye doloso, yo see mi eli sage mapoo badalame diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yo omapoo dileso badoboome, homokoko palagaloso olo bi moodoogaso. Eseme yayo o tou teli odoo abo mapoo takolone o homolee mapoo dileso homokoko egee gooloogaloso o hodio ee yimapoo tosibeye diso. ");
INSERT INTO kkc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Esino homolee bali odoo oso diayo sibadee ogoloso diba toloso, hee wulo woomele poogooso. Osoloso heeno wulo wooloomaso, osoloso hee yoso wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eseme homolee eyo amaye goo hagee duloso see tou teli odoo bei diyadeeye diso. Esino homolee bali odoo oso diba nosee toloso woomele poogoloso abo yoso piliguso. ");
INSERT INTO kkc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eseme see hamameedee owolo diye dolone egeesee gooleeso, ‘Homolee bali odoo oso mo holo mapoo mesilone yo wooloomalaime,’ dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Esino homolee bali odoo oso homolee eyo amayo owoloye simi ee ogoloso dieso nediliyo egeesee takaga meleeso, ‘Holo hagoso hamamee ama toga, yayo geleipi ko segei hagee talaiso. Esiga geleipi ko segei hagee see iyo talame yo wooloomamo,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eseme diayo holaiso hagee homolee maga peegoo ido dileso wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Esiga homolee eyo amaye sibileso o homolee bali odoo mapoo kasee moodoolaisomo?” ");
INSERT INTO kkc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eseme tei moso wiligi odoo tebisa sabolo osoloso Yu odoo dia wiligi odoo tebisa oso nei egeesee takaso, “Homolee eyo amaye sibileso homolee bali odoo wooloomaloso see bali odoo abo mapoo beye dalaiso. Osoloso odoo egee bia oso homokoko gooloogalai biame mapoo homokoko gooloogaloso homolee eyo ama mapoo hodio tenee demelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eseme Yesuye dimapoo egeesee takaso, “Niba Godeeyo to booka mapoo hogugu ee hesigeleyo? Bei, omapoo egeesee takooso, ‘Moso tegeli odoo oso omou gowoolone togobugu oso see epedee hamapoo moso omu domo pupodoo ka moloso. Esiga goo hagee Lodeeye ka moodoo. Esiga iba goo hagee ogoloso howoodolone tekepo deeso.’ ");
INSERT INTO kkc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Esiga ayo nimapoo taka. Godeeye wiligi doloso badeli goo ee nimaga peedee doloso, see Godeeye goomoga goo tomo silesibili odoo omapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Esiga odoo agayo omou omapoo takodee buguloso homodobuoga, yo ki gebisa pagalaiso. Osoloso omou oso odoo hee bulugu magooga, odoo egee balado dileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Eseme tei moso wiligi odoo tebisa sabolo osoloso Pelisi odoo oso Yesuye wudu taka goo ee duloso “ibada goo takolone bado,” doloso egeesee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Egeeseelone diayo Yesu talai eli esiaso. Esino odoo susuga oso Yesu yo tei Godee maga to toloso kokodo takomo sili odoo doloso takolone debei ee duloso, diayo yo talai ebiaso. ");
INSERT INTO kkc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eseme Yesuye see tobu wudu takolone, tei moso wiligi odoo tebisa sabolo, osoloso Yu odoo dia wiligi odoo tebisa mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godeeye wiligi doloso badeli goo ee egeesee moloso. Wiligi odoo taba eyo owoloye sobo hulei maga nei toowa mopoodoo dooso. ");
INSERT INTO kkc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yo nei mopoodoo koodobuloso o tou teli odoo diye dolone egeesee takaso, ‘Odoo daga ayo nei mopoodoo hamapoo sibilame taka ee niyo hamapoo gilimado sibe,’ diso. Eseme o tou teli odoo oso to hagee todileso odoo egee bia dimapoo takano, diba sibilei goweso. ");
INSERT INTO kkc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Eseme yo to egee duloso, wiligi odoo taba oso o tou teli odoo abo see tobu diye dolone egeesee takaso, ‘Niba dileso odoo daga ayo sibeye dee taka mapoo to egeesee takeeye diso, “Be hu olo piliguloso moloso, osoloso nei olo mopoodoo doloso moloso. Esiga niba sobo hu wo ne mapoo sibadeeye,” dee takee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eseme diayo to hagee todileso takano, odoo aboso to hagee duloso gowoolone see dia tou talame diyadeeso. Egeeseelone, odoo aboso dia homolee mapoo diyadeeso. Osoloso odoo aboso dia bi neiso teli moso mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eseme see odoo aboso to hagee duloso wiligi odoo taba o tou teli odoo ee toloso piliguso. ");
INSERT INTO kkc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eseme wiligi odoo taba oso goo hagee duloso diya komonolone o ha teli odoo mapoo egeesee takaso, ‘Emegei piligili odoo hagee bia piliguloso dia mi onosee dou gigaleegee,’ dee takeme, diayo egeesee moodooso. ");
INSERT INTO kkc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Eseme wiligi odoo taba oso o tou teli odoo mapoo see egeesee takaso, ‘Nei toowa olo mopoodoo doloso moloso. Esino odoo ayo gi hagee bia ee dia goo tokenee maga hamapoo sibilei tebile. ");
INSERT INTO kkc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Esiga niyo dileso mi domo omapoo silesibulone odoo susuga wo nalame gilimado sibe,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eseme o tou teli odoo oso dileso odoo susuga gilimadoloso wo nalame sibadeeso. Egeeseelone goo tekepo teli odoo sabolo, osoloso goo tokenee teli odoo sabolo sibadeeso. Eseme odoo moso ee ma kulodu diya muguleso. ");
INSERT INTO kkc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Esino wiligi odoo taba oso moso ee ma kulodu odoo agalame gapeleso egeino, odoo hee sobo hu wo ne mapoo kali bi ee kelega sibileso badoboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eseme wiligi odoo taba oso yimapoo egeesee takaso, ‘Emegei, no sobo hu wo ne mapoo kali bi ee kelega hagee bado, no moso hagee ma kulodu kasee gasimiyo?’ diso. Esino odoo egee to nei takele. ");
INSERT INTO kkc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Eseme wiligi odoo taba oso o tou teli odoo abo mapoo egeesee takaso, ‘Odoo hagee dee sabolo homo sabolo tiso tialogoloso moso peegoo neliga mapoo togobigi. Yo omapoo badolone pisa sabolo mei gisile sabolo badalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Esiga Godeeye odoo susuga yimapoo sibilame gilimolone ka badoso. Esino yo wulo odoo abo ono ka hesiga moloso.” ");
INSERT INTO kkc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Osoloso Pelisi odoo oso peegoo dileso Yesu kukulo agalame to mouso, yayo to tokenee takooga yo ka talame. ");
INSERT INTO kkc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Egeeseelone diayo dia hamamee dili odoo sabolo, osoloso Helodeeyo hamamee dili odoo sabolo Yesuye badebei mapoo diye diso. Eseme odoo egee bia oso dileso Yesu mapoo egeesee takaso, “Eligili odoo, iba gooleedoo, no tei goo moodeli odoo. Osoloso nayo Godeeyo goo eligilone hedebe tei goodee ee eligili. Osoloso no odoo bolo koo ebili. Osoloso no odoo su mapoo koo egeli. ");
INSERT INTO kkc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Esiga nayo kasee gooleedo? Imapoo takee, iyo Loum gamalee wiligi odoo Sisa mapoo tekisi molee tenelai tekepowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesuye diayo goo tokenee moodoolame to mou goo ee yo olo gooleedoloso dimapoo egeesee takaso, “Niba goo bakadio gweli odoo. Bei kasi maga niyo a kukulo agalame ka sala? ");
INSERT INTO kkc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Esiga niyo tekisi molee magalame mooloogoo molee ko hedebe amapoo eligi.” Eseme diayo molee ko hedebe yimapoo tosimiso. ");
INSERT INTO kkc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eseme Yesuye dimapoo egeesee takaso, “Molee hamapoo agamo mudu sabolo osoloso agamo hu oso ka mololo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eseme diayo nei egeesee takaso, “Sisayo mudu sabolo osoloso o hu oso ka molo,” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Niyo Sisayo bi ee Sisa mapoo tenee, osoloso Godeeyo bi ee Godee mapoo tenee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Diba to hagee duloso diya howoogadoloso Yesu poogoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Osoloso biame omapoo Sedisi odoo abo oso Yesuye badebei mapoo sibadeeso. Odoo hagee bia oso takolone, “Odoo wedia see hogabileime,” dee takeliso. Eseme diayo Yesu mapoo sibileso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Eligili odoo, tei magoo Moseseeye hogugu oso imapoo egeesee takooso. ‘Gisoso sobo huloso holo soomagelega toga, see omoloye emei tayo osobo bau ee huloso emeiyo hu maga holo soolooga magee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Esiga odoo heeso giso holo 7 soomagooso. Osoloso daga emeiye sobo huso. Osoloso yo holo soomagelega taso. Eseme omolo yima hamamee soomagoo oso emeiyo osobo bau ee huso. ");
INSERT INTO kkc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Esino yinosee holo soomagelega taso. Eseme see omolo yima hamamee soomagoo oso emeiyo osobo bau ee huso. Esino yinosee holo soomagelega taso. Egeeseelone giso holo 7 susuga hagee bia oso holo soolooga magelega wediaso. ");
INSERT INTO kkc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Osoloso hamameedee sobo bau yinosee taso. ");
INSERT INTO kkc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Esiga odoo wedia maga see hogogadilei biame mapoo sobo egee tei odoo agamo osobo dalaisomo? Bei, giso 7 oso sobo hedebe hagee huso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eseme Yesuye nei dimapoo egeesee takaso, “Niba goo dooboo gweli odoo. Bei, niba Godeeye kitulugu sabolo osoloso o to sabolo gooleedelega ka doso. ");
INSERT INTO kkc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bei, odoo wedia ee bi maga see hogogabuoga, diba see sobo huleime, osoloso giso obileime. Esino diba see Godeeyo momaiye oso Kei mi mapoo egee do egeesi masi dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Esiga niba Godeeye odoo wedia see hogogadilei eyo goo maga taka to hogugu hagee hesigeleyo? Bei, yayo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘A Eibalahameeyo Godee, Aisekeeyo Godee, osoloso Yekobowo Godee doloso ka badoso,’ dee takaso. Esiga Godee hagee odoo wedia eyo Godeenee. Haye, odoo gie egee do eyo Godee.” ");
INSERT INTO kkc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eseme odoo susuga oso Yesuye eligi goo hagee duloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sedisi odoo oso Yesuye taka eyo nei takalai tebile poogoo ogoloso Pelisi odoo susuga diesono hodobo mooloogoodoloso to mouso. ");
INSERT INTO kkc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Osoloso mooloogoodoo omaga tei eligili odoo heeso Yesu kukulo agalame yimapoo sibileso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Eligili odoo, Moseseeye tei magoo ma kulodu tei magoo kaso diya toowa ka molosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eseme Yesuye nei yimapoo egeesee takaso, “ ‘Nayo nee wiligi odoo Godee diya goolee, nee sooloo ma kuloduga goolee sabolo, osoloso nee dioso goolee sabolo, osoloso nayo goo goolee oso diya goolee.’ ");
INSERT INTO kkc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Esiga tei magoo susuga ee ma kulodu tei hedebe hagoso daga malalo diya toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Osoloso ee ma hamamee tei magoo toowa egeesi masi hee hagoso, ‘Nayo no nediliyo diya egee goolee, egeesee goolone nee odoo nosee diya egeesee goolee.’ ");
INSERT INTO kkc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Esiga Moseseeye tei magoo susuga sabolo osoloso Godee maga to toloso kokodo takomo sili odoo oso to hogugu susuga eyo bei ee tei magoo bakadio hamapoo moloso.” ");
INSERT INTO kkc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pelisi odoo hodobo mooloogoodoloso osee doboome, Yesuye dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Niba Kelisowo goo maga kasee gooleesomo, yo agamo owolowo?” dee takaso. Eseme diayo egeesee takaso, “Deibidiyo amawe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eseme Yesuye nei dimapoo egeesee takaso, “Bei kaseme Deibidiye Dio Tei maga takolone Keliso yo Lodee dee ka takayo? Bei, Deibidiye egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Godeeye mo Lodee mapoo egeesee takaso: No abolo wiligi doloso badalame mo dee deedee dokolo bie. Esiga nayo badolone namapoo ha teli odoo ee ayo dagadileiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Esiga Deibidiye Keliso o Lodee diso. Esiga kasi maga Keliso yo Deibidiyo amawe dee ka seeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eseme odoo heeso o to su mapoo to nei hee takele. Esiga biame domopooga dulone, odoo susuga oso Yesu mapoo woosalai obulone yimapoo hee woosele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Eseme Yesuye odoo mooloogoodoo mapoo, osoloso o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tei eligili odoo sabolo osoloso Pelisi odoo oso Moseseeye tei magoo nimapoo ee eligilei dimapoo kitulugu moloso. ");
INSERT INTO kkc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Esiga dibada to mapoo mesimo silesibulone, diayo taka goo ee tolone debee. Esino diayo suso goo moodeli ee ogoloso niyo na peedee. Bei, diayo tei ma goo ee nimapoo eligilino, see dieso suso koo edidili. ");
INSERT INTO kkc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Esiga diayo tei eligi goo oso odoo mapoo hegi toowa teneliso. Osoloso diayo emegei pidilone hegi su ee see dieso koo teli. ");
INSERT INTO kkc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Esiga goo susuga diayo moodoo ee wulo edebeeyo agalame ka moodeli. Osoloso diba Godeeyo to abo hogugu ee debege masi diya toowa kaloso ee ma kulodu sooloso edebeeyo agalame silesibiliso. Osoloso edebeeyo agalame, diayo howo gisilone, kali dugo su mapoo ti sage bagagoloso kalagaloso silesibiliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Osoloso ibada howo gisili moso ma kulodu, osoloso wo toowa ne mapoo diba medee malalo peleso bilei ono diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Osoloso mi domo mapoo edebeeyo dimapoo gauwuloso emegei di to takooga ee dulei onosee diya goomegeliso. Osoloso odoo susuga oso diba eligili odoo dalame diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Esino odoo susuga oso nimapoo takolone eligili odoo dalai tekeponee. Bei, nibada eligili odoo hedebe ayo ka badoso. Osoloso nima kulodu odoo heeso dagadileso koo badoso. ");
INSERT INTO kkc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Osoloso mipoo hamapoo odoo heeyo hu dokodoo poudoolone, yimapoo takolone ma dee na see. Bei, nibada Ama hedebe yayo Kei mi ma dokodoo ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Osoloso odoo heeso nimapoo takolone wiligi odoo dalai tekeponee. Bei, nibada wiligi odoo hedebe Keliso aso. ");
INSERT INTO kkc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Esiga nima kulodu odoo hu toowa too oso nibada tou teli odoo doloso badalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Osoloso odoo agayo dieso nediliyo diba si howolone doga, nei Godeeye diba pepooko dalaiso. Esino odoo agayo dieso pepooko doloso doga, diba nei Godeeye toowa dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tei eligili odoo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, niyo edebeeyo Godeeye wiligi doloso badeli goo mapoo gadilei eli poolone ka doga. Osoloso niba nosee omapoo koo gadili.  ");
INSERT INTO kkc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tei eligili odoo sabolo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, niyo sobo bauwe diba ebilame gamenee takoloso, dia moso sabolo bi sabolo niyo toloso omapoo dobolone, nibada goo gagaloso Godee mapoo taka diya sageliso, odoo aboso niba tekepo odoo dee goolame. Esiga goo egeesi maga niba nei dala toowa talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tei eligili odoo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, Yu odoonee oso see Yu odoo dalame niyo mipoo hamapoo odoo esiamo silesibiliga. Osoloso niyo odoo hee toloso goo tokenee niyo eligi oso yo diya tokenee peliso. Goo egeesee moodoo oso niyo yo Dou mi mapoo ido duso. Bei, goo tokenee yayo too oso goo tokenee niyo too ee dagadileso moloso. ");
INSERT INTO kkc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Niba odoo howo neliga oso odoo abo gilimado di masi gilimado duso. Esiga Godeeye nimapoo dala toowa tenelaiso. Bei, niyo egeesee eligiliso, ‘Odoo heeso to magolone tei moso eyo hu sabolo tei yeli ee goo haga toowanee,’ deliso. ‘Esino edebeeyo tei moso ma kulodu molee egee molo eyo hu sabolo tei yeli goo ono diya toowa,’ deliso. ‘Esiga see hamamee to magoo ee na gababie,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Niba howo neliga boobada odoo. Molee ee goo haga toowanee. Esino tei moso tegei oso goo diya toowa ka moloso. Bei, molee oso tei moso ma kulodu mologa, molee egee Godeeyo doloso ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Osoloso niyo see egeesee eligiliso, ‘Odoo heeso to magolone Godee mapoo emegei di bi tenelame nei sili dosulu tei moso ma kulodu egee molo eyo hu sabolo tei yeli ee goo haga toowanee,’ deliso. ‘Esino yayo to magolone dosulu mapoo emegei di bi magoo eyo hu sabolo tei yaga, goo ono diya toowa,’ deliso. ‘Esiga see hamamee to magoo ee na gababie,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Niba odoo howo neliga masi. Tei moso ma kulodu bi dosulu mapoo egee molo oso goo toowa koo moloso. Esino dosulu oso goo toowa ka moloso. Bei, emegei di bi teneli ee dosulu mapoo mologa, Godeeyo doloso ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Esiga odoo agayo to magolone dosulu eyo hu sabolo tei yaga, yo hedebe dosulu eyo hu sabolo koo yeli. Esino yo dosulu eyo hu sabolo osoloso dosulu mapoo emegei di bi magoo eyo hu sabolo tei ka yeli. ");
INSERT INTO kkc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Esiga odoo agayo to magolone tei moso eyo hu sabolo tei yaga, yo hedebe tei moso eyo hu sabolo koo yeli. Esino yo tei moso eyo hu sabolo osoloso ee ma kulodu badeli Godeeyo hu sabolo tei ka yeli. ");
INSERT INTO kkc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Osoloso odoo agayo to magolone Kei mi eyo hu sabolo tei yaga, yo hedebe Kei mi eyo hu sabolo koo yeli. Esino Godeeyo hu sabolo osoloso yayo bili eyo hu sabolo tei ka yaso. ");
INSERT INTO kkc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Tei eligili odoo sabolo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, niyo Godee mapoo emegei di bi tenelame kobu sabolo, osoloso nai sabolo, osoloso bi abo pepuso mooloogoo 10 egeesi mageliso. Osoloso 10 ee ma kulodu hedebe Godee mapoo tenelone debeliso. Esino nei tei magoo ee ma kulodu goo toowa egee molo ee talai boobado bigiliso. Goo ee, tekepo goo talai, osoloso emegei sooloo deli goo, osoloso tei talai goo. Esiga goo toowa hagee tolone medee ka debee. Egeeseelone goo pepuso talai na boobado bigi. ");
INSERT INTO kkc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niba odoo howo neliga oso odoo abo gilimado di masi ka gilimado duso. Niba kababoo nibada wo mapoo badoga ogoloso peegoo habigiliso. Esino kemol be toowa oso nibada mudugiyopoo tiamologa egelega poogoloso wulo sooloogeliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Tei eligili odoo sabolo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, nibada kapu sabolo osoloso peleta ee hedebe kolo ee hapoolone kulodu hapelega pegeli, niba egeesi masi doso. Bei, niyo hedebe kolo ono hapeli. Esino nibada sooloo ma kulodu bi goomegeli goo oso diya bei moloso. Osoloso niyo hedebe niso goomegeli goo ee tomo silesibiliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pelisi odoo niba howo neliga odoo. Niba daga nibada kapu sabolo osoloso peleta kulodu hapege. Egeeseega, kolo onosee dasegelega heliye malaiso. ");
INSERT INTO kkc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Tei eligili odoo sabolo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, niba odoo bi medee mopoodoo doloso meli egeesi masi doso. Bei, odoo bi ee dokodoo medee tekepo mopoodoo deliso. Esino odoo bi ee ma kulodu odoo wediayo ki sabolo ku sabolo bei meliso. ");
INSERT INTO kkc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Egeeseelone odoo aboso niba ogoloso niba odoo tekepo gweliso. Esino niba goo bakadio gweli odoo. Bei, nibada kulodu goo tokenee bei moloso. ");
INSERT INTO kkc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tei eligili odoo osoloso Pelisi odoo, niba goo bakadio gweli odoo! Godeeye nimapoo dala toowa tenelaiso. Bei, niyo Godee maga to toloso kokodo takomo sili odoo wedia dia bi ma dokodoo moso pepuso tegegaloso mopoodoo doloso doso. Egeeseelone Godeeyo howo woola tekepo debeli odoo oso wedia eyo bi sabolo niyo medee mopoodoo doloso doso. ");
INSERT INTO kkc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Osoloso niyo see egeesee takolone doso, ‘Ibada amawe diayo debei biame omapoo iba debei diepi, ibada amawe diayo Godee maga to toloso kokodo takomo sili odoo ee piligu sabolo hodobo hedebe delega pegeliyo,’ deeso. ");
INSERT INTO kkc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Esino niyo egeesee taka goo oso niso nediliyo takolone, Godee maga to toloso kokodo takomo sili odoo ee wooloomali odoo ee nibada amawe dio dee ka takooso. ");
INSERT INTO kkc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Esiga goo tokenee namawe diayo bei mooloogoloso poogoo ee see niyo hosude. ");
INSERT INTO kkc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Niba hebiseyo owolo dio masi. Niba Dou mi mapoo egee du peegoo pia dabalai gooleesomo? ");
INSERT INTO kkc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Esiga ayo nimapoo Godee maga to toloso kokodo takomo sili odoo, osoloso goo goolee tekepo gweli odoo, osoloso Godeeyo to eligili odoo sibeye dalaiso. Esino niyo odoo abo piligileiso. Osoloso abo homo bulubo magoo ma dokodoo yoguso enigileiso. Osoloso odoo abo Yu odoo dia howo gisili moso ma kulodu woolaiso. Osoloso odoo abo niyo dala tenelone dobolone, mi hee maga mi hee mapoo hasiso bugu dolone dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Esiga mipoo hamapoo nibada amawe diayo Godeeyo howo woola tekepo debeli odoo ee piligimo simiso. Egeeseelone diayo odoo tekepo Eibol woolooma maga bei mooloogooloso abaga simino Belekaya eyo owolo Sekalaya wooloomaso. Esiga diayo Sekalaya tei moso ogo osoloso Godee mapoo gala hu wooloso sili dosulu ogo doloso domopoo tobudume wooloomaso. Esiga nibada amawe dio oso daga hoogoo Godeeyo howo woola tekepo debeli odoo piligu eyo nei dala niyo talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Esiga ayo nimapoo taka. Yu odoo epedee hagee do niyo, nibada amawe dio eyo tokenee eyo nei niyo talaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalem odoo, niba kasi maga Godee maga to toloso kokodo takomo sili odoo ee piliguloso, Godeeye nimapoo diye di odoo ee yoso ka enigeliyo? Kolokoloso o pe gilimadoloso medee egee wuo egeesee selame, ayo biame susuga nowolo dio gilimadalai goomegeliso. Esino niba koo goomegelina. ");
INSERT INTO kkc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Esiga Yelusalem odoo, niba dui. Nibada tei moso tegei ee Godeeye poogoo duga, moso egee mosoowe malaiso. ");
INSERT INTO kkc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Esiga ayo nimapoo taka. Niyo a see agalaime. Esino biame oso siboga niyo egeesee takalaiso, ‘Odoo Godeeyo hu maga kitulugu sabolo egee sibo Godeeye yimapoo goomogoso,’ dalaiso. Biame omapoo niyo a see agalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu tei moso poogoo dileso dimolome, o hamamee dili odoo oso yimapoo sibileso egeesee takaso, “Tei moso tekepo tegei hagee ege,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eseme Yesuye egeesee takaso, “Niba goo susuga hagee medee ege. Ayo nimapoo taka. Moso hamapoo yo hedebeso yo hee ma tobudoo molo agalaime. Esino yo susuga mi mapoo misigeduboloso molo agalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Osoloso Yesu Olipi mubi ma dokodoo peleso badoboome, o hamamee dili odoo dibusomo sibileso yimapoo egeesee woosaso, “Tei moso guobigilei ogoo biameso ka guobigileiyo? Osoloso nayo sibilei mologa, malalo ogoo gooso ka peledabalaiyo? Osoloso mi hoo pagalai mologa, daga ogoo gooso imapoo ka eligileiyo? Nayo imapoo takee.” ");
INSERT INTO kkc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eseme Yesuye see dimapoo egeesee takaso, “Niba obeeyamo! Odoo heeso tei goodee maga niba peegoo gilimado diyaga. ");
INSERT INTO kkc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bei, odoo aboso mo hu maga sibileso takolone dieso nediliyo diba Kelisoso, dee takalaiso. Egeeseelone diayo odoo bei tei goo maga peegoo gilimado dileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Esiga ha too goo sabolo osoloso biliga goo oso peledoboomo duga goo ee duloso, niba haga na ebi. Bei, goo hageesi oso daga malalo peledabalaiso. Esino biame egee hoo poogoo osonee, hamamee sibileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mi toowa heeso mi toowa hee sabolo ha talaiso. Biame omapoo mi susuga mapoo nei mauwe pagalaiso. Osoloso mi susuga mapoo mibia toowa sibileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Goo hagoso peledobooga, dala biame oso bei mooloogolone ka seeso. ");
INSERT INTO kkc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Egeesi ma kulodu odoo aboso nimapoo dala teneloso niba piligilame odoo abo mapoo tenelaiso. Osoloso niyo amapoo tei too goo omaga odoo susuga oso nimapoo heiga toowa malaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Biame omapoo odoo aboso tei too goo ee pagalaiso. Egeeseelone diayo emegei tei too odoo ee hegilone, diba ha teli odoo mapoo tiasalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Osoloso gamenee godee maga to toloso kokodo takomo sili odoo aboso sibileso odoo abo peegoo gilimado dileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Egeesi ma kulodu goo tokenee goo oso diya toowa dolone, edebeeyo emegei sooloo deli goo ee me pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Esino odoo agayo o tei too medee kibiloso badolone hoo poogoo mapoo dileso peledobooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Esiga mipoo hamapoo to tekepo Godeeye wiligi doloso badeli goo ee odoo susuga oso dulame takomo dileiso. Osoloso to tekepo hagee odoo susuga oso olo dulugaloso doga, mi hoo pagalai biame omapoo peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Esiga hesigeli odoo, no to hageeyo bei medee gooleede. Bei, Godee maga to toloso kokodo takomo sili odoo Daniyeleeye egeesee takaso, ‘Niba bi diya tokenee mudu opusomo di oso tei moso ma kulodu molo agalaiso. Esiga bi ogoso Godeeyo howo woola tei moso tokenee palaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Egeeseega Yudiya mi toowa mapoo debeli odoo oso bi mudu opusomo di ee ogoga mubi ma dokodoo kukulo pele. ");
INSERT INTO kkc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Osoloso biame omapoo odoo moso hau mapoo badoga, see moso kulodu gadileso o bi na te. ");
INSERT INTO kkc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Osoloso odoo homolee ma kulodu siloga, o gidei talame mosopoo see na wedi di. ");
INSERT INTO kkc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Osoloso biame omapoo sobo koowasi sabolo, osoloso holope too nedili sobo ee kukulo dilei diya kalawa toowa molo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Esiga Godee mapoo takee, niyo kukulo dilei biame ee wau biame o, iyo hasali biame omapoo peledebelega pagalame. ");
INSERT INTO kkc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bei, biame omapoo dala toowa oso sibileiso. Esiga mi bei mooloogoo biame abaga simino epedee hamapoo, odoo susuga oso dala goo hageesi egele. Esino dala goo toowa hagoso sibileso koodobuoga, hamamee dala goo hageesi see agalaime. ");
INSERT INTO kkc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Esino dala biame hagee see Godeeye deiyepo moodoolaiso. Bei, yayo biame sage magoo diepi, odoo heeso dala ee ma kulodu badalai tebile pegeliyo. Esino dala ee ma kulodu Godee eyo hesiga odoo ee halo, yayo biame see deiyepo moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Biame omapoo odoo heeso sibileso nimapoo takolone, ‘Hamapoo ege, Keliso hagoso’ o, ‘Koo ege, Keliso ogoso,’ dee takooga, o to mapoo tei na te. ");
INSERT INTO kkc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bei, gamenee keliso deli sabolo, osoloso gamenee godee maga to toloso kokodo takomo sili odoo oso sibileso goo toowa opusomo di edebeeyo howeli moodoolaiso, odoo susuga sabolo osoloso odoo Godeeye hesiga oso peegoo dia beleso kukulo agalame. ");
INSERT INTO kkc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Esiga niba medee dui. Goo hagee peledebelega mologa, ayo daga nimapoo ka taka. ");
INSERT INTO kkc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Esiga odoo heeso nimapoo takolone, ‘Niba ege. Keliso dobudu badoso,’ dee takooga, yo agalame na di. Osoloso see yayo takolone, ‘Niba ege. Keliso moso kulodu badoso,’ dee takooga, omapoo tei na te. ");
INSERT INTO kkc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bei, kei ebiedigaga mi toowa egee gadeebugu egeesi masi ogoga, niyo Odoo Holo a sibo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Osoloso mi hee mapoo hune mologa, kukodeeso hune egee nalame omapoo busiliso.” ");
INSERT INTO kkc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Osoloso hamamee haga booloogelega dala biame hagoso dileso koodobuoga, ‘osoko semelaiso. Egeeseega anosee gadeebigileime. Osoloso giwo kei ma dokodoo egee molo mi hamapoo tigedibileiso. Osoloso kei ma dokodoo kitulugu bi egee molo Godeeye halabuga ki me pagalaiso.’ ");
INSERT INTO kkc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Osoloso biame omapoo Odoo Holo ayo sibilei eyo goo ee kei ma dokodooga eligiga, odoo susuga oso agalaiso. Eseega odoo susuga oso goohele sabolo pupusigileiso. Egeesi ma kulodu odoo susuga oso Odoo Holo ayo kolobo maga gadeebugu sabolo osoloso kitulugu toowa sabolo siboga agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Osoloso kibu neligidi iga, ayo mo momaiye diye dalaiso, diayo dileso odoo susuga Godeeye hesiga mi susuga mapoo egee do ee gilimalame. ");
INSERT INTO kkc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Osoloso niba sogai maga goo hagee medee gooleede. Sogai du pisigaga ogoloso wau biame koola tooboo doloso gooleedeliso. ");
INSERT INTO kkc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Esiga goo hagee egeesi masi moloso. Goo ayo taka hagoso peledaba ogoga, Odoo Holo ayo sibilei olo koola tooboo doloso niba olo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ayo nimapoo taka. Odoo epedee hamapoo egee do diba osee doga goo susuga hagoso peledaba ee diba agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Esiga kei sabolo mipoo sabolo mauwe pagalaiso. Esino mo to me pagalaime. ");
INSERT INTO kkc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Esiga Odoo Holo ayo sibilei biame ee odoo hee gooleedele. Osoloso Godeeyo momaiye Kei mi ma dokodoo egee do sabolo osoloso Godeeyo owolo anosee gooleedele. Esino hedebe mo Ma Godeeye biame egee gooleedoloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Esiga Nowaye badebei biame omapoo goo peledaba goo hedebe egeesi masi oso Odoo Holo ayo sibilei biame mapoo peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bei, Nowaye badebei biame omapoo, howo duwelega molome odoo susuga oso nei sabolo howo sabolo nolone dobolone sobo hulone debeiso. Diba egeeseelone doboome, biame heeso Nowa du toowa ma kulodu gadiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nowa du toowa ma kulodu gadime, odoo susuga oso goo peledabalai ee kibiya gooleedelega doboome, howo toowa duwa oso diba howoso neso. Esiga Odoo Holo ayo sibilei biame omapoo goo hedebe hageesi oso peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Esino biame omapoo odoo bakadio homolee ma kulodu tou tomo silesiboga, odoo heeno ido polone hee omapoo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Osoloso sobo bakadio wo galaga mologa, sobo heeno ido polone hee omapoo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Esiga niba mopoodoo doloso koolone ka debee. Bei, nibada Lodee ayo sibilei biame ee niba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Esino niba goo hagee medee gooleede. Edebeeyo mesiyaso o moso mapoo sibilei biame ee duga, yo mopoodoo doloso badolone medee bamalaiso. Osoloso mesiya olo siboga ogoloso yo habigileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Esiga niba nosee medee mopoodoo doloso ka debee. Bei, Odoo Holo ayo sibilei biame ee niba gooleedele.” ");
INSERT INTO kkc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Goo mapoo mesiloso silone tou tekepo teli odoo ee ogumo? Wiligi odoo oso odoo egeesi mapoo kitulugu tenelaiso, yayo o tou teli odoo susuga medee bolone yayo dimapoo nei nali pilame. ");
INSERT INTO kkc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bei, wiligi odoo yo peegoo dileso badoboso see sibileso ogoga, o tou teli odoo oso o tou medee tekepo too daga, yimapoo diya goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Esiga ayo nimapoo taka. Wiligi odoo oso o tou teli odoo oso tou medee tekepo too ogoloso, see yimapoo bi susuga ee yayo bamelee dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Esino tou tokenee teli odoo oso o wiligi odoo saga koo siboga eyo nediliyo egeesee takalai malaiso, ‘Mo wiligi odoo saga koo sibo,’ doloso tou teli odoo abo wooloogolone, yugune nali odoo gilimadoloso nei sabolo howo sabolo nolone dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yo egeeseemo silone mopoodoo delega badoga, o wiligi odoo omapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Osoloso o wiligi odoo oso sibileso yo diya wooloso peegoo habigileiso, goo bakadio gweli odoo sabolo dabalame. Osoloso diayo omapoo dobolone pisa sabolo osoloso mei gisile sabolo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Biame omapoo Godeeye wiligi doloso badeli goo oso sibilei ee egeesi masi malaiso. Sobo obuo 10 oso dia keme toloso giso sobo hulame siboga, yo tugodalame diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Osoloso dima kulodu sobo abo 5 ee goo medee koo gweli. Esino sobo abo 5 ee goo medee gweli. ");
INSERT INTO kkc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Egeesi ma kulodu sobo abo goo medee koo gweli oso dia keme howo keesoloso dulone, howo abo telega diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Esino sobo goo medee gweli oso dia keme sabolo osoloso howo abo keesoo sabolo toloso diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Diba dileso balaga meleeno, odoo sobo hulei ee saga sibile. Eseme diba diya tila poogoome tiesaso. ");
INSERT INTO kkc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Osoloso gesi domo mapoo odoo heeso to neligidi egeesee takaso, ‘Sobo hulei odoo ee olo koola sibo. Esiga niba dileso yo tugode,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Eseme sobo obuo susuga tiesamelee maga hogogabuloso dia keme wiki medee pailame hoo kookooso. ");
INSERT INTO kkc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Esino sobo obuo goo medee koo gweli oso sobo goo medee gweli mapoo egeesee takaso, ‘Ibada keme howo olo hosudalasoo. Esiga niyo iba howo tenee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eseme goo medee gweli sobo obuo oso nei dimapoo egeesee takaso, ‘Haye. Iyo ibada howo nibada keme mapoo keesoga, iba howo tebileime. Esiga niba howo abo neiso talame bi teli moso mapoo diyadee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eseme diba howo talame dime, odoo sobo hulei ee sibileso peledabaso. Eseme goo medee gweli sobo obuo yo bamelee diba yibolo hodobo nei nalame moso kulodu galagadiso. Diba moso kulodu doboome, osulu kisiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Esino sobo obuo goo medee koo gweli diba hamamee sibileso osulu mapoo kalamadulone egeesee takaso, ‘Wiligi odoo, osulu yade, iba moso kulodu gasibileiya,’ dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Esino odoo sobo hulame simi oso nei dimapoo egeesee takaso, ‘Haye. Niba gasibileime. Bei, ayo nimapoo tei taka. A niba gooleedele,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Esiga niba medee koolone ka debee. Bei, Odoo Holo ayo sibilei biame ee niba gooleedele.” ");
INSERT INTO kkc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Osoloso Godeeye wiligi doloso badeli goo ee egeesi masi malaiso. Wiligi odoo oso mi eli sage mapoo dilame, o tou teli odoo gilimadooso. Osoloso dimapoo o bi medee bameleeye diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Egeeseelone yayo o tou teli odoo mapoo molee tenelone dia goo goolee sabolo teiba teneeso. Egeesee solone yayo odoo hee mapoo molee ko 5,000 teneeso. Osoloso odoo hee yima hamamee taba mapoo molee ko 2,000 teneeso. Osoloso odoo hee ee ma hamamee taba mapoo molee ko 1,000 teneeso. Osoloso yo see mi eli sage mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Eseme o tou teli odoo molee ko 5,000 too odoo oso molee egee toloso dileso bi neiso teli moso togoloso badolone molee ko hodio 5,000 tooso. ");
INSERT INTO kkc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Osoloso molee ko 2,000 too odoo yinosee molee egee toloso dileso bi neiso teli moso togoloso badolone molee ko hodio 2,000 tooso. ");
INSERT INTO kkc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Esino odoo hee molee ko 1,000 too yo o wiligi odoowo molee egee toloso dileso mada mi doluguso. ");
INSERT INTO kkc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Wiligi odoo yo mi eli sage dileso biame sage omapoo badoboso see wedi simiso. Yo sibileso yayo molee pi odoo ee gilimadooso, molee oso goo hee moodoo beleso agalame. ");
INSERT INTO kkc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eseme molee ko 5,000 too odoo oso molee tosibileso egeesee takaso, ‘Wiligi odoo, nayo amapoo molee ko 5,000 tenee ee see ayo abaga odoomo dino 10,000 tugodoo hagoso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Eseme wiligi odoo oso nei yimapoo egeesee takaso, ‘No tou medee goosa teli odoo. Nayo tou tekepo too ee ogoloso a goomogoso. Esiga nayo bi pepooko medee bamelee maga nei ayo namapoo bi toowa bameleeye dalaiso. Esiga no mo moso kulodu abolo hodobo goomoga sabolo badalame gasibe,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Eseme molee ko 2,000 too odoo yinosee molee tosibileso egeesee takaso, ‘Wiligi odoo, nayo amapoo molee ko 2,000 tenee ee see ayo abaga odoomo dino 4,000 tugodoo hagoso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eseme wiligi odoo oso nei yimapoo egeesee takaso, ‘No tou medee goosa teli odoo. Nayo tou tekepo too ee ogoloso a goomogo. Esiga nayo bi pepooko medee bamelee maga nei ayo namapoo bi toowa bameleeye dalaiso. Esiga no mo moso kulodu abolo hodobo goomoga sabolo badalame gasibe,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Eseme molee ko 1,000 too odoo oso sibileso egeesee takaso, ‘Wiligi odoo, a gooleedoo, no kitulugu sabolo odoo mapoo diya seseli. Osoloso no odoo heeyo nei segei wulo goobada teli. ");
INSERT INTO kkc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Esiga a nobolo obulone nee molee oso goo hee moodelega, wulo dileso mada mi ka dolugu. Esiga nee molee amapoo tenee ee teiba osee hagee moloso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Eseme o wiligi odoo oso nei yimapoo egeesee takaso, ‘No tou diya tokenee teli wabada odoodoo. Nayo goolee, a emegei dia nei segei wulo gooloogali gweliso. ");
INSERT INTO kkc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Esino nayo kasalame mo molee kauwulame molee bali odoo dia moso mapoo magelega ka poogoowo? Nayo mo molee omapoo magoo diepi, ayo see wedi simi biame mapoo mo molee ogoso toowa poloso mologa teliyo,’ dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Osoloso wiligi odoo oso o odoo abo mapoo egeesee takaso, ‘Niyo yimapoo molee ko 1,000 egee molo toloso see odoo molee ko 10,000 too mapoo tenee. ");
INSERT INTO kkc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bei, odoo agayo dimapoo tenee bi ee medee bamologa, nei dimapoo bi bei tenelaiso. Esino odoo agayo dimapoo tenee bi ee medee belega poogooga, bi susuga dimapoo egee molo see padaga dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Esiga tou too tokenee bali odoo ee peegoo neliga ma kulodu togobigi. Osoloso yo omapoo pisa sabolo badolone mei gisile sabolo badalaiso.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Odoo Holo ayo kitulugu sabolo osoloso Godeeyo momaiye susuga sabolo siboga, biame omapoo ayo toowa doloso badeli goo omaga gadeebugu sabolo sibileso ayo wiligi doloso bili mapoo badalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Osoloso mi opusomo opusomo di mapoo debeli odoo susuga ee Godeeyo momaiye oso gilimado sibileso mo mudugiyopoo mooloogoodalaiso. Osoloso be bali odoo oso o be domo puloso sipi be dibusomo pi, osoloso gout be dibusomo pi deli, egeesi masi solone ayo mi odoo susuga domo puloso mooloogoodoo bakadio moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Egeeseelone ayo odoo mooloogoodoo hee sipi be masi ee mo dee deedee dokolo mapoo sibileso mooloogoode, osoloso odoo mooloogoodoo hee gout be masi ee mo dee dobusu dokolo mapoo sibileso mooloogoode, dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Osoloso wiligi odoo taba ayo mo dee deedee dokolo mooloogoodoo odoo mapoo egeesee takalaiso, ‘Mo Maye goomegeli odoo niba sibadee, Godeeye mipoo bei mooloogele mapoo Godeeye wiligi doloso badeli mi niyo dabalame mopoodoo doloso egee molo mapoo gasibadee. ");
INSERT INTO kkc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bei, a hodume niyo amapoo nei teneliso. Osoloso a howo na poogoome niyo amapoo howo keneliso. Osoloso a odoo soo masi sibume niyo a nibada moso mapoo ido peliso. ");
INSERT INTO kkc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Osoloso a boodo diwe badoboome, niyo amapoo dugo kalame teneliso. Osoloso a paiye badoboome, niyo a medee baliso. Osoloso a neliga moso ma kulodu badoboome, niyo a agalame sibiliso,’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Osoloso Godeeyo howo woola odoo tekepo debeli mo dee deedee dokolo mooloogoodoo oso nei egeesee takalaiso, ‘Lodee, kopolone no hodia badoboome, iyo no ogoloso nei ka teneeyo? Osoloso kopolone no howo na paga badoboome, iyo no ogoloso howo ka keneeyo? ");
INSERT INTO kkc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Osoloso kopolone no odoo soo masi sibume, iyo no ogoloso ibada moso ka ido palayo? Osoloso kopolone no boodo diwe badoboome, iyo no ogoloso dugo kalame ka teneeyo? ");
INSERT INTO kkc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Osoloso kopolone no paiye badoboome, iyo no ogoloso medee ka bameleeyo? Osoloso kopolone no neliga moso ma kulodu badoboome, iyo no agalame ka simiyo?’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Osoloso wiligi odoo taba ayo nei egeesee takalaiso, ‘Ayo nimapoo tei goo taka. Niyo tei telaga odoo abo wuluge pidimenee ee, niyo a pidi masi pidi,’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Osoloso wiligi odoo taba ayo mo dee dobusu dokolo mooloogoodoo odoo mapoo egeesee takalaiso, ‘Niba amaga peegoo diyadee. Bei, niba Godeeyo kamana ma hemidu doso. Esiga Godeeye Saiten sabolo osoloso o momaiye sabolo dou koo semili mopoodoo doloso magoo mapoo dabalame diyadee. ");
INSERT INTO kkc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bei, a hodume niyo amapoo nei tenele. Osoloso a howo na paga badoboome, niyo a howo kenele. ");
INSERT INTO kkc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Osoloso a odoo soo masi sibume, niyo a nibada moso mapoo ido pele. Osoloso a boodo diwe badoboome, niyo amapoo dugo kalame tenele. Osoloso a paiye badoboome, niyo a medee bele. Osoloso a neliga moso ma kulodu badoboome, niyo a agalame sibile,’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Egeeseega diayo nei egeesee takalaiso, ‘Lodee, kopolone no hodia sabolo osoloso howo na paga badoboome iyo no ka egeiyo? Osoloso kopolone no odoo soo masi sibume iyo no ka egeiyo? Osoloso kopolone no boodo diwe badoboome iyo no ka egeiyo? Osoloso kopolone no paiye badoboome iyo no ka egeiyo? Osoloso kopolone no neliga moso ma kulodu badoboome iyo no ka egeiyo? Osoloso iyo kopolone goo susuga hagee ogoloso no pidile ka poogoowo?’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Osoloso wiligi odoo taba ayo nei dimapoo egeesee takalaiso, ‘Ayo nimapoo tei goo taka. Niyo tei telaga odoo abo wuluge pidilega poogoomenee ee a pidile poogoo,’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Esiga odoo hagee bia peegoo dileso kookaiyo moloso osee malai dala goo mapoo dabalaiso. Esino Godeeye tekepo deli odoo ee Godee sabolo gie badoboso kookaiyo osee dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuye goo susuga hagee taka koodobuloso see o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Niba olo gooleedooso, Godeeye Gababia wo nalai ee bei mooloogalai biame hoogoo bakadio moloso. Osoloso biame omapoo Odoo Holo a homo bulubo magoo ma dokodoo yoguso enigilame ha teli odoo mapoo tiasalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Osoloso biame omapoo Yu odoowo wiligi odoo tebisa sabolo, osoloso tei moso eyo wiligi odoo tebisa, diayo dia wiligi odoo Kayapaseeyo moso mapoo mooloogoodoloso to mouso. ");
INSERT INTO kkc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Diayo gamenee goo maga Yesu toloso wooloomalame mada to mouso. ");
INSERT INTO kkc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Osoloso diayo egeesee takaso, “Iyo Gababia wo ne biame mapoo yo wooloomalaime. Bei, odoo susuga oso dimapoo komonolone biligiyaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani mi mapoo badolone, odoo daga agagisa bia Yesuye tekepo pa Saimonowo moso mapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yo omapoo nei nolone badoboome, sobo heeso kapu yoso moodoo mapoo mopoodoo soo medee tekepo keesoloso tosimiso. Yayo tosibileso Yesuwo wiligi mapoo sooso. Mopoodoo soo hagee molee toowaso teli. ");
INSERT INTO kkc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eseme Yesu o hamamee dili odoo oso goo hagee ogoloso diya komonolone egeesee takaso, “Bei kasalame sobo hagoso mopoodoo soo medee tekepo ee wulo goo mauwe yimapoo soomeleso ka hosudoowo? ");
INSERT INTO kkc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yayo mopoodoo soo medee tekepo hagee odoo mapoo neiso talame tenee diepi, molee toowa toloso bi mauwe odoo mapoo tenelai tebiliyo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Esino Yesuye diayo gowe goo ee ogoloso dimapoo egeesee takaso, “Sobo hagoso goo moodoo hagee ogoloso yimapoo to tokenee na takee. Bei, yayo amapoo goo tekepo moodoo. ");
INSERT INTO kkc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Esiga bi mauwe odoo ee biame susuga nibolo hodobo dabalaiso. Esino a biame susuga nibolo hodobo badalaime. ");
INSERT INTO kkc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yayo mopoodoo soo egee mo wiligi mapoo soo oso mo suso bi ma kulodu malai ee mopoodoo doo. ");
INSERT INTO kkc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ayo nimapoo ka taka. Edebeeyo mi kamapoo Godeeyo to tekepo takooga, diayo sobo hagoso goo moodoo onosee takalaiso. Osoloso edebeeyo o goo onosee osee goolee malaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Osoloso Yesu o hamamee dili odoo 12 ee ma kulodu badeli odoo hee Yudas-Iskaliyoteeye tei moso wiligi odoo tebisa mapoo dileso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ayo Yesu nimapoo tiasoga, niyo amapoo nei ogoo bi tenelaisomo?” diso. Eseme diayo nei molee ko 30 yimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eseme domo omaga bei mooloogoloso Yudaseeye Yesu dimapoo tiasalame eli esiamo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isipi mi maga peegoo di ee gooleebugu wo ne bei mooloogoo biame mapoo, Yesu o hamamee dili odoo oso dileso Yesu mapoo egeesee takaso, “Iba mi kamapoo dileso Gababia wo nalai ka mopoodoo dalaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eseme Yesuye nei egeesee takaso, “Niba Yelusalem mi mapoo dileso odoo hee ogoloso yimapoo egeesee takee, ‘Eligili odoo oso egeesee taka: Mo biame Godeeye hesia ee olo koola tooboogona. Esiga ayo mo hamamee dili odoo gilimadoloso nee moso mapoo Gababia wo ka nalaigona,’ dee takee.” ");
INSERT INTO kkc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesuye egeesee taka duloso o to ee dodolone o hamamee dili odoo oso dileso Gababia wo nalame mopoodoo dooso. ");
INSERT INTO kkc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Osoloso habe Yesuye o hamamee dili odoo gilimadoloso wo nalame bulumaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Diba omapoo nei nolone dobolone Yesuye egeesee takaso, “Ayo nimapoo taka. Nimaga odoo heeso a ha teli odoo mapoo tiasalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesu o hamamee dili odoo oso to hagee duloso goohele sabolo dobolone Yesu mapoo egeesee takaso, “Lodee, ayowo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuye nei dimapoo egeesee takaso, “Odoo agayo mo peleta mapoo abolo hodobo wo olugudoloso naga, a ha teli mapoo tiasalai odoo ogoso. ");
INSERT INTO kkc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Esino Godeeyo to booka mapoo hogugu oso taka ee dodolone, Odoo Holo a talaiso. Esino Odoo Holo a ha teli odoo mapoo tiaseli odoo yo dala toowa talaiso. Oweeye yo soomagelega poogoo diepi, yo dala tele pegeliyo.” ");
INSERT INTO kkc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eseme Yesu ha teli odoo mapoo tiaseli Yudaseeye egeesee takaso, “Eligili odoo, ayowo?” diso. Eseme Yesuye nei yimapoo egeesee takaso, “O. No olo egee takooso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Diba wo nolone doboome, Yesuye wo toloso Godee mapoo goomoga to takoloso wo popeiso. Osoloso o hamamee dili odoo mapoo wo pulone egeesee takaso, “Wo hagee toloso ne. Hagee mo suso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Osoloso see Yesuye kapu wain i keesoo toloso Godee mapoo goomoga to takoloso o hamamee dili odoo mapoo tenelone egeesee takaso, “Niba susuga wain i hagee ne. ");
INSERT INTO kkc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hagee mo sawo, odoo susuga dia tokenee hapalame ka sologo bugu. Mo sawo oso Godeeye o odoo mapoo to kitulugu magoo goo oso tei peledabalame. ");
INSERT INTO kkc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Esiga ayo nimapoo taka. Ayo epedee hamaga dulone wain i hagee see nalaime. Esino hamamee mo Maye wiligi doloso badeli mi mapoo ayo nibolo hodobo wain i dia see nalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Osoloso diba goomoga kosaiya hedebe pouloso Olipi mubi mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesuye see tobu o hamamee dili odoo mapoo egeesee takaso, “Epei gesi odoo susuga niyo a poogoo dileiso. Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Godeeye sipi be bali odoo ee wooloomaga, sipi be susuga oso yimaga peegoo kukulo dileiso.’ ” ");
INSERT INTO kkc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Osoloso Yesuye see egeesee takaso, “Esino a ta maga hogado dileso, ayo daga malalo Gelili mi mapoo dileso niba bamalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Eseme Pitaye nei Yesu mapoo egeesee takaso, “Odoo susuga oso namaga peegoo kukulo duga, hedebe ayo no poogoo dileime,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Eseme Yesuye yimapoo egeesee takaso, “Ayo namapoo tei taka. Epei gesi kolokolo takelega mologa, nayo mo goo gagadilei bakadio hedebe dalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eseme Pitaye yimapoo egeesee takaso, “Ayo egeesee selaime. Edebeeyo no wooloomaga, a nobolo hodobo talaiso,” diso. Eseme o hamamee dili odoo susuga oso to hedebe egeesee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuye o hamamee dili odoo sabolo Getesemeni homolee mapoo dileso dobolone dimapoo egeesee takaso, “Niba hamapoo debee. A koo dileso Godee mapoo takalaiya,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yayo egeesee takoloso hedebe Pita osoloso Sebediyo owolo bakadio esee ido palaso. Yo peleso badoboome, goohele goo sabolo osoloso su hegi goo oso yimapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Osoloso yayo dimapoo egeesee takaso, “Mo su ma kulodu hegi goo toowa oso molone ayo talai olo koola tooboo. Esiga niba hamapoo dobolone, abolo hodobo koolone ka bamo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu egeesee takoloso dimaga pepooko hoogoo dileso ebiso miyomoo tugusaloso balaboo tiamolone Godee mapoo takolone egeesee takaso, “Ma, no goomogoga, amapoo dala egee sibo ee nayo peegoo magee. Esino nayo goomoga goo ee moodee, ayo goomoga goonee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Osoloso yo Godee mapoo taka koodobuloso dileso egeino, o hamamee dili odoo bakadio hedebe di tiesamolome egeiso. Eseme Pita mapoo egeesee takaso, “Niba kaseega ka tiesamalala? Niba biame deiyepo mapoo abolo hodobo koolone dabalai tebiledoo. ");
INSERT INTO kkc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Niba bolone Godee mapoo takolone ka debee, kukuga homodobiyaga. Bei, niba goo tekepo talame goomogoso. Esino nibada su oso ki me ka poogooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yo see tobu dileso Godee mapoo takaso, “Ma, dala goo ayo talai oso a dagadilei tebile daga, a dala egee talaiso. Bei, ayo nayo goomoga goo ee talaiso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu see tobu dileso Godee mapoo takoloso sibileso egeino, o hamamee dili odoo bakadio hedebe di diba tila poogoome tiesa molo egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Osoloso Yesu see tobu bakadio hedebe di mapoo dileso goo hedebe eyo daga taka hedebe egeesee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Osoloso yo see wedi sibileso o hamamee dili odoo mapoo egeesee takaso, “Niba osee tiesa molosomo? Bei, Odoo Holo a tokenee odoo mapoo tiasalai biame olo siboso. ");
INSERT INTO kkc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Esiga koo ege, a tokenee odoo mapoo tiasalai odoo ee olo sibo. Esiga niba tebise, dimapoo dimo.” ");
INSERT INTO kkc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu to osee komolome, o hamamee dili odoo hee Yudaseeye Yesu talame odoo mooloogoodoo toowa gilimado simiso. Egeesi ma kulodu tei moso wiligi odoo tebisa sabolo, osoloso Yu odoowo wiligi odoo tebisa oso Yesu talame odoo hagee bia diye diso. Eseme diayo sibulone kaiya sabolo kodolo sabolo toloso sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Egeesi ma kulodu Yudas yo epedee sibilega badolone, odoo Yesu talai mapoo yayo egeesee takaso, “Ayo dileso adaga, odoo ogoso. Eseega niyo yo toloso ka ido di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Osoloso Yudaseeye odoo gilimado sibileso Yesu mapoo dileso egeesee takaso, “Emegei, eligili odoo,” dee takoloso yo adaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eseme Yesuye yimapoo egeesee takaso, “Emegei, nayo goo moodoolame simi egee moodee,” diso. Eseme odoo susuga oso sibileso Yesu tooso. ");
INSERT INTO kkc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Esino o hamamee dili odoo heeso kaiya toloso tei moso wiligi odoo taba eyo tou teli odoo eyo dulu koosooso. ");
INSERT INTO kkc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Eseme Yesuye yimapoo egeesee takaso, “Nee kaiya peegoo magee. Bei, emegei piligilame kaiya toloso silesibili odoo ee kaiyaso piligileiso. ");
INSERT INTO kkc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Esiga niba gooleedeleyo, ayo a pidilame mo Ma mapoo takooga, yayo o momaiye mooloogoodoo 12 egeesi sabolo osoloso abo epedee saga meiye dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Esino ayo egeesee seega, ayo dala toloso talai goo ee Godeeyo toso booka maga taka sabolo kasee tebileisomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eseme Yesuye yo talame sibadee odoo omapoo egeesee takaso, “Niyo ogoga a mesiya daga, a talame kaiya sabolo osoloso kodolo sabolo misigaloso ka sibadala? Esino ayo biame susuga tei moso ma kulodu eligimo sileeme, niyo a egeliso. Esiga bei kaseme ayo omapoo eligimo sileeme niyo a telega ka poogoowo? ");
INSERT INTO kkc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Esino niyo epei a talame simi hagoso Godee maga to toloso kokodo takomo silesibili odoo oso taka to sabolo olo tobuoso.” Eseme biame omapoo Yesu o hamamee dili odoo susuga oso yo poogoloso kukulo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Edebeeyo Yesu toloso tei moso wiligi odoo taba Kayapaseeyo moso mapoo ido palaso. Esiga moso ee ma kulodu tei eligili odoo sabolo osoloso Yu odoowo wiligi odoo tebisa oso daga olo mooloogoodoloso debeiso. ");
INSERT INTO kkc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eseme Pitaye hamameedee Yesu deedee dileso tei moso eyo wiligi odoo taba eyo moso beelee ma kulodu gadiso. Yo tei moso gidebeli odoo sabolo omapoo badolone, Yesu mapoo ogoo goo mooda beleso bameleeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eseme tei moso wiligi odoo tebisa sabolo osoloso Yu odoo dia goo midili wiligi odoo tebisa oso Yesuwo goo maga gamenee takeli odoo ee esiaso, yimapoo goo tokenee hee mologa, Yesu ka wooloomalame. ");
INSERT INTO kkc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Egeeseelone edebeeyo wulo gamenee takolone Yesuwo goo maga goo opusomo opusomo di takaso. Esino diayo taka ee ma kulodu tei goo hee molo egele. ");
INSERT INTO kkc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Eseme odoo bakadio oso see hamamee sibileso egeesee takaso, “Iba Yesuye egeesee takeme duso, Godeeyo tei moso hagee guobuguloso biame bakadio hedebe di ee ma kulodu see dia tegelai yimapoo kitulugu moloso, dee takeme duso.” ");
INSERT INTO kkc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eseme tei moso wiligi odoo taba oso toboloso Yesu mapoo egeesee takaso, “Odoo hagee biaso nee goo maga goo opusomo opusomo di egee takoo mapoo nayo to eyo nei takalaimeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Esino Yesu to hee takele. Eseme tei moso wiligi odoo taba oso see tobu yimapoo egeesee takaso, “Ayo gie badeli Godeeyo hu maga namapoo ka taka. No tei Godeeyo owolo Kelisosomo? Imapoo takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuye to nei yimapoo egeesee takaso, “O. Nayo olo egee takooso. Esino ayo nimapoo takooso. Hamamee niyo Odoo Holo a Kitulugu Godeeyo dee deedee dokolo mapoo badoga agalaiso. Osoloso ayo kei ma dokodooga kolobo maga siboga agalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Eseme tei moso wiligi odoo taba oso to hagee duloso diya gowoolone, o dugo tologo bugulone egeesee takaso, “Odoo hagoso Godeeyo goo maga to tokenee takoo. Esiga iyo o goo see midilame to abo taka ee dulei koo goomogo. Bei, yayo Godeeyo goo maga to tokenee taka niba olo duso. ");
INSERT INTO kkc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Esiga niyo yimapoo ogoo goo moodoolai gooleedo?” diso. Eseme tei eligili odoo sabolo osoloso Yu odoo dia wiligi odoo tebisa oso nei egeesee takaso, “Yo tokenee olo tooso, esiga yo talai tekepo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Osoloso diayo yo manolone o mudu mapoo magawo paganiso. Osoloso diayo o howo dugoso gagaloso, yo woolone yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Keliso, no tei Godee maga to toloso kokodo takomo sili odoo daga, no odoo agayo woolo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita epedee moso pee mapoo osee badoboome, tei moso wiligi odoo taba o tou teli sobo heeso sibileso yimapoo egeesee takaso, “Nonosee Gelili odoo Yesu bolo silee odoo hee noso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Eseme Pitaye odoo susuga eyo howo woola egeesee takaso, “Nayo egee takoo goo ee a gooleedele,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Osoloso yo dileso moso beelee osulu miyopoo tobudume, tou teli sobo heeso yo ogoloso odoo abo omapoo tebisamelee mapoo egeesee takaso, “Odoo hagee Nasalet odoo Yesu bolo sileeso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eseme Pitaye see to kitulugu sabolo egeesee takaso, “A tei goo taka. Odoo egeeyo goo a gooleedele,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Biame deiyepo poogoloso hamamee odoo susuga omapoo tebisamelee oso sibileso Pita mapoo egeesee takaso, “No tei Yesubolo silee odoo hee noso. Bei, nayo to egee ko ee Gelili odoo oso to keli egeesee masi ko. Esiga nayo to kei oso nee goo ee yilige buguso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eseme Pitaye to kitulugu sabolo dimapoo egeesee takaso, “Ayo Godeeyo hu hesilone tei taka. Odoo egee a gooleedele,” diso. Pitaye egeesee takoloso badoboome kolokolo takaso. ");
INSERT INTO kkc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Eseme Pita kolokolo taka duloso Yesuye taka to ee gooleebuguso. Bei, Yesuye yimapoo egeesee taka, “Kolokolo takelega mologa, nayo mo goo gagadi bakadio hedebe dalaiso,” diso. Eseme yo to egee gooleebuguloso peegoo gadileso diya gooholone pisaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gesikolodee mapoo tei moso wiligi odoo tebisa susuga sabolo, osoloso Yu odoo dia wiligi odoo tebisa susuga oso to mouloso, Yesu wooloomalame goomoga magooso. ");
INSERT INTO kkc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Osoloso diayo Yesuwo dee tiso tiegisaloso gamalee wiligi odoo taba Paileteeye badebei mapoo ido dileso yimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesu tiaseli odoo Yudaseeye Yesu tei olo wooloomalame badebei goo ee duloso, diya gooheleso. Eseme molee ko 30 yayo too ee see tei moso wiligi odoo tebisa sabolo, osoloso Yu odoo dia wiligi odoo tebisa mapoo tenelame diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yayo dileso dimapoo egeesee takaso, “Ayo odoo goo tokenee mauwe nimapoo tiasoo maga, a goo tokenee olo tooso,” diso. Esino wiligi odoo tebisa oso nei egeesee takaso, “Egee ibada goonee. Nee goo. Esiga no nobusomo tekepo moodee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Egeesee taka duloso Yudaseeye molee ko egee tei moso ma kulodu kugobuguloso, see wedi dileso eyo nediliyo tiso mu mapoo bagagoloso, homo dee ma dokodooga bagagoo sooloso taso. ");
INSERT INTO kkc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Eseme tei moso wiligi odoo tebisa oso molee ko misigelone egeesee takaso, “Ibada tei magoo oso egeesee takooso, ‘Molee hagee see tosibileso molee odoo aboso tenee sabolo hodobo magalai tei,’ deliso. Bei, molee hagee odoo wooloomalai eyo nei tenee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Osoloso diba molee oso goo talai to magoloso bogoso sesepeni moodoogali odoo eyo mi molee ogoso tooso, Yu odoonee wedioga omapoo boulame. ");
INSERT INTO kkc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bei egeeseega odoo susuga oso mi egee takolone sawo mi deliso. ");
INSERT INTO kkc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Eseme biame omapoo goo hagoso Godee maga to toloso kokodo takomo sili odoo Yelemayaye taka to sabolo teibaso. Bei, yayo egeesee takaso, “Isalael odoo diayo o su eyo nei magoo molee ko 30 ee toloso see odoo bogoso sesepeni moodoogali eyo mi ee tooso, Lodeeye amapoo taka to ee dodolone.” ");
INSERT INTO kkc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu Loum gamalee odoo Paileteeye badebei mapoo ido sibume, nei gamalee odoo oso yimapoo egeesee takaso, “No tei Yu odoo dia wiligi odoosomo?” diso. Eseme Yesuye yimapoo nei egeesee takaso, “O. No olo egee takooso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eseme tei moso wiligi odoo tebisa sabolo, osoloso Yu odoo dia wiligi odoo tebisa oso Yesuwo goo maga goo opusomo opusomo di takeme, yayo nei dimapoo to hee takele. ");
INSERT INTO kkc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eseme Paileteeye yimapoo egeesee takaso, “Odoo susuga oso nee goo maga goo opusomo opusomo di egee takaga, no dusomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Esino Yesuye to hee takelega poogoome, gamalee odoo yo goo egee ogoloso diya dio diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dugo susuga ma kulodu Paileteeye Yu odoo goomogalame, Godeeye Gababia wo ne biame mapoo odoo susuga oso goomoga odoo hee neliga moso ma kuloduga peegoo tamageeye deliso. ");
INSERT INTO kkc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Biame omapoo mesiya hedebe odoo susuga oso gooleedoo ee neliga moso ma kulodu badebeiso, o hu ee Balabas. ");
INSERT INTO kkc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Esiga odoo susuga olo mooloogoodeme, Paileteeye dimapoo egeesee woosaso, “Ayo odoo ogu ee neliga moso ma kuloduga peegoo ka tamagalaiyo? Balabas o, Yesu, edebeeyo Keliso deli ee tamagalaiyo?” ");
INSERT INTO kkc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Egeesi ma kulodu Yu odoo dia wiligi tebisa oso Yesu mapoo koolone, diayo Yesu yimapoo ido simi goo ee, yo ogoloso olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailet goo midili odoo oso bili mapoo osee badoboome, osoboye yimapoo to tenelone egeesee takaso, “Odoo goo tokenee mauwe omapoo nayo goo hee na moodeeye. Bei, eiyo gesi ayo o goo maga sapootia diya ku tiaga,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Esino tei moso wiligi odoo tebisa sabolo, osoloso Yu odoo dia wiligi odoo tebisa oso odoo susuga mapoo toso pupulone egeesee takaso, “Pailet mapoo egeesee takee, ‘Yesu ono wooloomolone Balabas ono peegoo tamageeye,’ dee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eseme Paileteeye odoo susuga mapoo egeesee takaso, “Niba ayo odoo ogu ee neliga moso ma kuloduga peegoo tamagalai ee ka goomogolo?” Eseme odoo susuga oso nei egeesee takaso, “Balabas ono peegoo ka tamagee,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eseme Paileteeye egeesee takaso, “Ayo Balabas yo neliga moso ma kuloduga peegoo tamagooga, hee Yesu edebeeyo Keliso deli ee kasee moodoolaisomo?” diso. Eseme nei odoo susuga oso to neligidi takolone egeesee takaga meleeso, “Yo homo bulubo magoo ma dokodoo yoguso enige,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Esino Paileteeye dimapoo egeesee takaso, “Yayo ogoo goo tokenee tooga, niyo yo wooloomalame ka sala?” diso. Esino odoo susuga oso to diya neligidi egeesee takaso, “Yo homo bulubo magoo ma dokodoo yoguso enige,” demeleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eseme odoo susuga oso Pailet yayo goomoga goo ee telega poogoome, diba komonolone biligalame see ogoloso, yo howo keedoloso odoo susuga eyo howo woola o dee hapoolone egeesee takaso, “Niyo odoo hagee wooloomaga, mo goonee, esino nibada goo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eseme odoo susuga oso egeesee takaso, “Yo wooloomaga eyo nei iyo ibada holaiso sabolo talaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Esiga Paileteeye Balabas neliga moso maga peegoo tamagooso. Eseme yayo o ha teli odoo mapoo takolone, Yesu we tiso wooloso homo bulubo magoo ma dokodoo yoguso enige, dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eseme Pailet o ha teli odoo oso Yesu we tiso wooloso Loum gamaleeyo moso mapoo ido palaso. Eseme ha teli odoo susuga sibileso Yesu domo tobudume toboloso silodabaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Diba omapoo mooloogoodoloso, Yesu manolone o dugo tigamagoloso see wiligi odoo tebisa oso kali dugo bige sage ee yimapoo kadiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Osoloso we ti sidoloso o wiligi mapoo kadiloso, o dee deedee mapoo homo magooso. Osoloso Yesu mapoo manolone yimapoo gauwuloso egeesee takaso, “Yu odoo dia wiligi odoo taba, iyo nee hu dokodoo poudoso,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Osoloso yimapoo magawo pogolone, homo o dee mapoo magoo ee see peedee doloso o wiligi mapoo osee woomeleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Egeesee soloso koodobuloso ha teli odoo oso dugo Yesuye ka ee tamagoloso see Yesu o dugo kadiso. Osoloso yo homo bulubo magoo ma dokodoo yoguso enigilame ido diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ha teli odoo oso Yesu idoloso Yelusalem mi maga peegoo gadulone, Kulene odoo Saimon tugodooso. Yo tugodoloso homo bulubo magoo Yesuye imado di ee see yayo ime diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Diba abaga dino Gologota mi mapoo peledabaso. Mi hu eyo bei ee wiligi ki mi. ");
INSERT INTO kkc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Diba omapoo sibileso Yesu mapoo wain i sabolo habili bi gal deli sabolo wuluguloso teneeso. Esino Yesuye howo egee wulo pepooko pia naloso poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Osoloso ha teli odoo oso Yesu homo bulubo magoo mapoo yoguso enigaloso tuluguloso, Yesu o dugo pilame diayo yoso dasigeli hee dasigaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Diba Yesuwo dugo puloso omapoo dobolone yo gibadebeiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Osoloso edebeeyo Yesu wooloomalai goo eyo bei ee odoo susuga oso gooleedalame, odoo heeso Yesuwo wiligi oo poogoo dokodooga to egeesee hoguguloso kalamaso, ");
INSERT INTO kkc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Osoloso mesiya bakadio sabolo homo bulubo magoo ma dokodoo yoguso enigaso. Odoo hee Yesu o dee deedee dokolo tulugu, osoloso hee o dee dobusu dokolo tulugu diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Osoloso odoo aboso eli omaga dulone, Yesu ogoloso manolone dia wiligi wabisaso. Osoloso diayo yimaga to tokenee yimapoo takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Egeeseelone diayo yimapoo egeesee takaso, “Nayo takolone, tei moso ee guobuguloso biame bakadio hedebe di ee ma kulodu see dia ka tegelaigona, dee taka. Esiga no tei Godeeyo Owolo daga, no homo bulubo magoo ma dokodooga miyomoo meileso no nediliyo pidi,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Osoloso tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo, osoloso Yu odoo dia wiligi odoo tebisa dibolosee Yesu manolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yayo odoo abono pidimo siliso. Esino yo epedee eyo nediliyo pidilei tebiledoo. Yo tei Keliso, Isalael odoo ibada wiligi odoo daga, yo homo bulubo magoo ma dokodooga miyomoo meilei tekepo. Egeeseega yayo mou ogoloso iyo yimapoo tei talaiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yo Godee mapoo tei teliso. Osoloso eyo takolone, yo Godeeyo Owolo, dee takomo siliso. Esiga iyo epedee yimapoo bamo, Godeeye goomogolone yo pida beleso agalame.” ");
INSERT INTO kkc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Goo hedebe egeesi masi moodoolone, mesiya bakadio onosee homo bulubo magoo ma dokodoo yoguso enigaloso molone, Yesu mapoo to tokenee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Osoko oo domo tooboome, mi toowa egee nolugo doloso melee osoko howo bakadio hedebe di poogooso. ");
INSERT INTO kkc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Osoloso neliga melee ee mauwe poogoome, Yesuye to neligidi egeesee iso, “Ilai, Ilai, lama sabakatani.” To hageeyo bei ee egeesi moloso, “Mo Godee, mo Godee, bei kasi maga nayo a ka pagala?” ");
INSERT INTO kkc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eseme odoo koola omapoo tebisa melee oso to hagee duloso egeesee takaso, “Niba dui. Yo Ilaya i,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Osoloso odoo heeso hoguo sibileso dugo toloso wain i mei nali mapoo olugu doloso homo sage su mapoo tialogoloso Yesuye nalame o maga mapoo heligiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Eseme odoo aboso egeesee takaso, “Ougo! Ilayaye sibileso yo toloso miyomoo mouwa beleso bamo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Eseme biame omapoo Yesu to neligidi idagoloso taso. ");
INSERT INTO kkc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eseme Yesuye ta biame omapoo, tei moso tegei ma kulodu dugo kodia oso kisi melee ee, dokodooga eyo tologomo abaga mouno miyomoo sabuguso. Osoloso mi halabulone yo toowa gagabuguso. ");
INSERT INTO kkc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Osoloso odoo bi goodogamo diso. Eseme Godee o odoo susuga wedia ee hogaduloso see gie badeli tooso. Osoloso odoo bi poogoloso diso. Osoloso Yesu ta maga hogaduloso hamamee, Yelusalem mapoo dileso dieso nediliyo diba odoo abo mapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eseme ha teli odoo gibadeli odoo sabolo, osoloso odoo yibolo Yesu gibadebei oso mibia simi sabolo, osoloso goo abo omapoo peledaba ogoloso diya obulone egeesee takaso, “Tei takoo, odoo hagee Godeeyo owolo doo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eseme sobo abo Gelili abaga Yesubolo sibadee oso eli sage abaga Yesu homo bulubo magoo ma dokodoo molome balaga meleeso. Sobo hagee biaso Gelili abaga Yesubolo sibulone yo pidiso. ");
INSERT INTO kkc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sobo hagee bia dima kulodu Meli-Magadalin, osoloso Yemes dio Yosep dio dibada owee Meli, osoloso Sebediyo osobo sabolo omapoo dobolone balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Habedee bi bei odoo hee Alimatiya mi maga simiso. O hu ee Yosep. Yinosee Yesuwo hamamee dili odoo hee yoso. ");
INSERT INTO kkc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Esiga yayo dileso Pailet mapoo Yesuwo kou talame woosaso. Eseme Paileteeye o odoo mapoo takolone, Yesuwo kou ee Yosep mapoo tenee, dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Eseme Yosepeeye Yesuwo kou toloso dugo dia heliyeso tiadoloso o bi dia yo ou poogoo ee ma kulodu magooso. Osoloso wulu ou mapoo yo toowa bidigamo dileso kisiloso diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Biame omapoo Meli-Magadalin dio osoloso Meli hee dio wulu koola omapoo dobolone balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Osoloso biame hee mapoo Yu odoowo hasali biame omapoo, tei moso wiligi odoo tebisa sabolo, osoloso Pelisi odoo oso Paileteeye badebei mapoo dileso egeesee takaso, “Wiligi odoo, iba goo hagee gooleebuguso. Goo ee, gamenee takeli odoo Yesu hagoso gie badolone egeesee takeliso, ‘Yo bi ma kulodu biame bakadio poogoloso see biame hee mapoo hogabileiso,’ dee takeliso. ");
INSERT INTO kkc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Esiga iba goomogo, nee odoo oso biame bakadio hedebe di ee ma kulodu bi egee medee gidabalame. Bei, o hamamee dili odoo oso sibileso o kou heli toloso see wulo gamenee takolone, Yesu olo hogaduloso dina, dee takeeyaga. Egeeseega hamamee gamenee taka goo hagoso daga yayo gamenee taka goo ee dagadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eseme Paileteeye egeesee takaso, “Niba mo ha teli odoo abo gilimado dileso bi egee medee gidebee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eseme diba susuga dileso bi omapoo dobolone yo ou yoso kisi mapoo eli peeso, odoo heeso mada sibileso yo peegoo bidibugu beleso agalame. Osoloso gidebeli odoo mapoo takolone, medee gidebeeye, dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yu odoowo hasali biame oso dileso koodobuloso biame hee mapoo gesikolodee Meli-Magadalin dio osoloso Meli hee dio Yesuwo bi agalame diso. ");
INSERT INTO kkc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Diba bi mapoo diyadaga molome, haga booloogelega mibia toowa simiso. Eseme Lodee o momaiye oso Kei mi ma dokodooga sibileso yo peegoo bidi buguloso ee ma dokodoo biaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yo dugo diya heliye kaloso, o su maga diya gadee magoloso badoboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Eseme bi gidebeli odoo oso diya obugulone kikiliga oso homodobuloso wulo wedia masi meleeso. ");
INSERT INTO kkc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Esino momaiye oso sobo bakadio mapoo egeesee takaso, “Niba haga na ebi. A gooleedooso, niba Yesu homo bulubo magoo ma dokodoo yoguso eniga ee esiamo silesibo. ");
INSERT INTO kkc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yo hamapoo koo moloso. Yo to eyo taka ee dodolone yo see hogado diso. Esiga niba sibileso o kouso melee mi mapoo ege. ");
INSERT INTO kkc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Osoloso niba see saga dileso o hamamee dili odoo mapoo egeesee takee, ‘Yesu ta maga see hogado dina. Osoloso yo malalo dileso Gelili mapoo diba bamoloso. Diba omapoo dileso yo agalaiso,’ dee takee. Mo to ayo nimapoo taka ee na boobado bigi.” ");
INSERT INTO kkc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Egeesee taka duloso sobo diba obulone see saga wedi dileso o hamamee dili odoo mapoo takalame diya goomoga sabolo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Diba diya goomoga sabolo diyadaga molome, haga booloogelega Yesuye eli domopoo diba tugodoloso egeesee takaso, “Emegei,” diso. Eseme sobo bakadio hagoso yimapoo sibileso gauwuloso dobolone, o homo mapoo toloso o hu dokodoo poudooso. ");
INSERT INTO kkc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Eseme Yesuye dimapoo egeesee takaso, “Niba haga na ebi. Niba dileso mo hamamee dili odoo mapoo takee, diba Gelili mapoo dileso omapoo a agalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sobo bakadio hagoso Yesu o hamamee dili odoo mapoo takalame osee diyadaga molome, odoo bi gidebeli odoo aboso dileso tei moso wiligi odoo tebisa mapoo goo susuga odoo bi omapoo peledaba ee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Egeesee taka duloso tei moso wiligi odoo tebisa oso Yu odoo dia wiligi odoo tebisa sabolo to mouso. Esiga diba dieso to magoo ee dodolone, molee toowa odoo bi gidebeli odoo mapoo tenelone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Niyo odoo susuga mapoo egeesee takee, ‘Niba gesi tiesamolome, Yesu o hamamee dili odoo oso mada sibileso Yesuwo kou todina,’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Osoloso gamalee odoo Paileteeye goo hagee duloso kamanaga, iyo yo hemisilame, nibada goo medee moodoolaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eseme odoo bi gidebeli odoo oso molee toloso, goo diayo moodeeye dee taka goo ee moodooso. Goo egeesi maga gamenee taka goo hagee Yu odooso dima kulodu osee takomo silesiboso. ");
INSERT INTO kkc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu o hamamee dili odoo 11 oso Gelili mapoo dileso Yesuye taka to ee dodolone mubi hee mapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Diba omapoo peleso Yesu ogoloso yimapoo goomoga poudooso. Esino dima kulodu odoo aboso yo tei Yesudoo doloso tei tele. ");
INSERT INTO kkc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eseme Yesuye dima hegi sibileso egeesee takaso, “Kei mi sabolo osoloso mipoo hamapoo goo susuga ee balai kitulugu amapoo olo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Esiga niba mipoo susuga omapoo debeli odoo susuga mapoo dileso, diayo amapoo tei toloso mo hamamee dili odoo dalame, Godeeyo to tekepo takomo di. Egeeseelone diba Mayo hu maga, osoloso Owolo mo hu maga, osoloso Dio Tei eyo hu maga diba howo olugi. ");
INSERT INTO kkc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Osoloso ayo kokodo taka to susuga niyo dodomo silesibilame nimapoo tenee ee see dimapoo eligi, diayo to egee dodolone ka dabalame. Esiga niba goo hagee medee gooleede, epedee hamaga bei mooloogoloso mi hoo poogoo mapoo duga, ayo biame susuga nibolo hodobo badalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","To tekepo bei mooloogoo hagoso, Godeeyo owolo Yesu Kelisowo goo. ");
INSERT INTO kkc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Daga hoogoo Godee maga to toloso kokodo takomo sili odoo Aisayaye o booka mapoo Godeeye Yesu mapoo to taka egeesee hoguguso: “Ayo mo to tosili odoo malalo diye dalaiso. Osoloso yayo dileso nee eli moodoolame. ");
INSERT INTO kkc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Miwe poogoo mi omaga edebeeyo egeesee idagoo, ‘Lodee yayo sibilei eli moodee. Osoloso medee hoodo magee.’” ");
INSERT INTO kkc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yonee odoo howo oluguli miwe poogoo mi mapoo peledoboloso, yayo odoo howo ogusulone to tekepo takolone egeesee takaso, “Nibada goo tokenee mapoo miligi pialoso howo ogusige. Eseega Godeeye nibada goo tokenee hapoloso boobado bigileiso,” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudiya mi mapoo debeli mosobia sabolo, osoloso Yelusalem mi toowa mapoo debeli odoo susuga oso Yoneeye to taka ee dulame sibadeeso. Diba Yoneeye taka to ee duloso dibada goo tokenee yilige bugume, Yoneeye diba Yoden howo mapoo howo oluguso. ");
INSERT INTO kkc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yonee yo kemol be too oso dugo dusa kaloso silone, gala koloso bagi mapoo gudu masi kaloso siliso. Osoloso nei yayo nali ee tapala toowa sabolo koo sabolo nali. ");
INSERT INTO kkc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yayo odoo susuga mapoo egeesee takeliso, “Odoo hee ama hamamee sibileiso. Yayo kitulugu oso ayo kitulugu ee dagadi. A tekeponee, o homo bei mapoo gauwuloso o homo bi ee pidigilei. ");
INSERT INTO kkc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ayo niba howodeeso oluguso. Esino hamamee yayo Dio Tei nima kulodu tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Haga booloogelega Yesu Gelili mi toowa ma kulodu mi pepooko Nasalet omaga sibume, Yoneeye yo Yoden howomoo howo oluguso. ");
INSERT INTO kkc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu howomooga gasibileso egeino, Kei mi osulu yamagoloso Dio Tei oso molo masi pusibileso yimapoo pubalegeme egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Osoloso Kei mi ma dokodooga to egeesee taka, “No ayo gooma mo holo noso, a namapoo diya goomogo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Osoloso biame omapoo Dio Teiso Yesu miwe poogoo mi omapoo diye diso. ");
INSERT INTO kkc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu biame 40 omapoo gala seebee sabolo badoboome, Saitenso kuku demeleeso. Esino Godeeyo momaiye sibileso yo pidiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yu odoo dia wiligi odoo taba Helodeeye, Yonee neliga moso ma kulodu husuloso hamamee, Yesu yo Gelili mi toowa mapoo dileso, to tekepo Godee maga simi takomo siliso. ");
INSERT INTO kkc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yayo egeesee takaso, “Biame tekepo olo simiso, osoloso Godeeye wiligi doloso badeli goo oso sibilei koola toobooso. Esiga niba goo tokenee maga miligi pialoso, to tekepo mapoo tei te.” ");
INSERT INTO kkc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Biame heeso, Yesu Gelili abei palaga maga dimeleeno, di kebigeli odoo bakadio Saimon dio omolo Endulu dio peiso di giligamolome yayo egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eseme Yesuye dimapoo egeesee takaso, “Niba ama hamamee sibadee, ayo niba odoo gilimeli eligileiya.” ");
INSERT INTO kkc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eseme diba Yesuwo to duloso, dia pei omapoo saga poogoloso, see Yesubolo hodobo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Osoloso yo pepooko hoogoo dileso, di kebigeli odoo abo Sebediyo owolo bakadio, Yemes dio omolo Yonee dio du ma kulodu dobolone pei moodoomolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Osoloso Yesu diba ogoloso, yayo diba gilimadooso. Eseme diayo dulone o tou telagali odoo sabolo ama Sebedi sabolo du ma kulodu gilimane poogoloso, Yesubolo hodobo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu o hamamee dili odoo sabolo Kapeniyum mi mapoo simiso. Osoloso Yu odoowo hasali biame hee mapoo, Yesu howo gisili moso omapoo peleso, Godeeyo to eligilame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Odoo susuga yayo eligi du oso diya howoogadooso. Bei, yayo eligi ma kulodu tei eligili odoo oso eligi egeesi masi koo eligime. Esino yayo odoo diya kitulugu oso eligi masi eligiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Epedee omapoo, howo gisili moso ma kulodu odoo bo holo pala hee omapoo badebeiso. Yayo to neligidi Yesu mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasalet odoo, nayo imapoo ogoo goo moodoolame ka simiyo? Nayo hamapoo iba tokenee palame ka simiyo? A gooleedooso, no Godeeyo tei odoo.” ");
INSERT INTO kkc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuye bo holo mapoo to kitulugu sabolo egeesee takaso, “No to koodobuloso, odoo ma kuloduga peegoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eseme bo holo oso odoo ma kulodu badolone neligidi kikiligameleso gwa sabolo peegoo gadiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eseme odoo susuga oso goo hagee ogoloso howoogadooso, osoloso diesono nei woosa nei woosa diso, “Goo hagee ogoo goowo? Eligili goo hagee dia, osoloso yayo kitulugu sabolo eligi. Bei, edebeeyo bo holo mapoo to takooga, peegoo koo gadili. Esino Yesuye bo holo mapoo to takooga, diba o to mapoo mesiloso peegoo gadiliso.” ");
INSERT INTO kkc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eseme Gelili mi toowa mapoo odoo susuga goo ee saga takomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Howo gisili moso poogoo dileso, Yesu Yonee sabolo Yemes sabolo, Saimon dio Endulu dio dibada moso mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonowo nalobo paiye kolo dei moodoome debi mapoo tiameleeso. Diayo Yesu mapoo sobo paiye eyo goo takaso. ");
INSERT INTO kkc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Osoloso Yesuye sobo paiye mapoo dileso, o dee mapoo toloso, “Tebee,” diso. Eseme paiye kolo dei saga yimaga koodo diso. Eseme yayo dimapoo nei teneeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Habe osoko todobume odoo abo oso odoo paigiga sabolo bo holo paladee odoo sabolo Yesu mapoo iyado sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Osoloso Kapeniyum mi toowa mapoo debeli odoo susuga oso Yesuye odoo paigiga moodoo ee agalame, osulu miyopoo mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eseme Yesuye odoo paigiga opusomo opusomo di yayo takeme tekepo poloso weido diso. Osoloso bo holo odoo ma kulodu debei peegoo hasisilone dimapoo egeesee takaso, “Mo goo na takee,” diso. Bei, bo holo susuga oso Yesu yo Godeeyo owolo doloso diba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gesikolodee mi hadobilega, Yesu tia maga hogabuloso moso poogoo dileso, obusomo odoo koola mauwe mi mapoo Godee mapoo takalame diso. ");
INSERT INTO kkc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hamamee Saimonbolo debei odoo abo sabolo Yesu esiamo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Diayo yo ogoloso yimapoo takaso, “Odoo susuga oso no esia moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuye nei egeesee takaso, “Iba mi abo mapoo dimo, omapoo dileso Godeeyo to takalame. Bei, a goo egee talame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Osoloso yo Gelili mi toowa ma kulodu mi pepooko susuga mapoo dileso, Yu odoowo howo gisili moso susuga ma kulodu Godeeyo to takomo sileeso. Osoloso bo holo odoo ma kulodu paladee peegoo hasiso bugu demeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Odoo agagisa bia Yesu mapoo sibileso ebiso miyomoo tugusaloso egeesee howaso, “Nayo a tekepo moodoolai goomogoga, a tekepo moodee.” ");
INSERT INTO kkc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuye yo diya sooloo dolone o kolo mapoo sigolone yimapoo egeesee takaso, “Ayo no tekepo palai, a goomogo. Esiga no tekepo pe.” ");
INSERT INTO kkc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eseme epedee omapoo o kolo mapoo agagisa bia mauwe poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuye yo diye dolone to kitulugu sabolo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nayo dileso no ayo tekepo pa goo ee odoo abo mapoo na takee. Esino, nee su tekepo pa goo ee, Godee ogo odoo ogo doloso domo badeli odoo mapoo dileso eligi. Osoloso nee su tekepo pa omaga emegei di bi tenee, Moseseeye tei magoo goo ee dodolone, odoo susuga oso ogoloso tekepo pa ee gooleedalame.” ");
INSERT INTO kkc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Esino yo Yesuwo to mapoo tei telega poogoloso, odoo susuga mapoo o agagisa bia tekepo moodoo goo ee oposususo. Bei egeesi maga Yesuye mi kamapoo disomo, odoo susuga oso Yesu agalame diya mooloogoodoo diso. Eseme Yesu mi abo mapoo odoo howo woola sile. Esino yo mi odoo mauwe mapoo bado neme, edebeeyo mi opusomo opusomo di maga yayo badebei mi mapoo yo agalame sibadee demeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Biame abo poogoloso hamamee, Yesu see Kapeniyum mi mapoo wedi sibume, edebeeyo Yesuye simi ogoloso, mi omapoo saga takomo diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Osoloso odoo susuga sibileso, o moso kulodu sabolo peegoo sabolo omapoo diya mooloogoodoome, Yesuye dimapoo Godeeyo to eligi meleeso. ");
INSERT INTO kkc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eseme mi omapoo odoo su kakawa poogoo badebei ee, odoo bakadio bakadio di oso kida mapoo tiediloso imado sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Osoloso diayo yo Yesuye badebei omapoo todilame goomogaso. Esino odoo beiga Yesu mapoo dilei eli egele. Eseme diayo odoo su kakawa poogoo kida sabolo moso omu ma dokodoo imado palaso. Osoloso Yesuye to kemelee domo omaga seme ou tologo poogoloso tiso kida mapoo bagagoloso kida sabolo moso kulodu toosooso. ");
INSERT INTO kkc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Diayo odoo su kakawa poogoo moso omu maga toosooloso goolee, odoo egee yayo moodoolai teiba doloso, Yesuye dia tei too ogoloso, odoo su kakawa poogoo mapoo takaso, “Mo odoo, nee goo tokenee ee olo hapoloso boobado buguso.” ");
INSERT INTO kkc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eseme tei eligili odoo omapoo dobolone dieso nediliyo egeesee gooleemeleeso, ");
INSERT INTO kkc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Odoo hagoso kaseme egeesee ka takayo? Yayo Godee dagadilame see, esino goo tokenee hapeli hedebe Godeeso.” ");
INSERT INTO kkc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu o dio oso diayo dibada sooloo ma kulodu goolee melee goo ee gooleedoloso dimapoo egeesee takaso, “Niyo kasi maga nibada sooloo ma kulodu egeesee ka goolee malala? ");
INSERT INTO kkc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Niba odoo su kakawa poogoo hagee ege. Yimapoo goo kasee takalai oso sebe ka mololo? Ayo odoo su kakawa poogoo mapoo ‘Nee tokenee ayo olo boobado buguso,’ dee takooga, o tokenee boobado bugu ee niyo gooleedalaime. Esino ayo yimapoo takoo ‘No toboloso nee kida toloso di,’ daga, yo toboloso duga, odoo tekepo peli kitulugu amapoo molo doloso niyo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Esino Odoo Holo amapoo kitulugu olo teneeso, mipoo hamapoo goo tokenee hapoloso boobado bigilei goo ee niyo ogoloso gooleedalame, ayo nimapoo eligileiso.” Osoloso yayo odoo su kakawa poogoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“No hogabuloso nee kida toloso mosopoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Diayo balaga molome, odoo su kakawa poogoo hogabuloso, o kida toloso saga diso. Diayo odoo su kakawa poogoo oso toboloso di ogoloso diya howoogadooso. Osoloso Godee mapoo goomoga poudooso. Osoloso diayo egeesee takaso, “Iba daga goo hageesee koo egeli.” ");
INSERT INTO kkc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu Gelili abei palaga maga see wedi dimeleeno, odoo susuga sibileso yimapoo mooloogoodoome, yayo Godeeyo to dimapoo eligi meleeso. ");
INSERT INTO kkc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu abei palaga dulone egeino, odoo Alpiyes eyo owolo Libai tekisi molee misigeli moso kulodu badoboome egeiso. Osoloso Yesuye yimapoo takaso, “Ama hamamee sibe.” Eseme Libaiye toboloso Yesuye di hamamee diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Habe Yesu Libaiyo mosopoo badebeino, tekisi molee misigeli odoo bei sabolo, goo tokenee teli odoo abo sabolo, osoloso Yesuwo hamamee dili odoo sabolo, Yesubolo nei nameleeso. Odoo bei hageesee oso yimapoo hamamee dili odoo. ");
INSERT INTO kkc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Esino Yesu tekisi molee misigeli odoo sabolo, osoloso goo tokenee teli odoo sabolo nei namolome, tei eligili Pelisi odoo oso ogoloso, o hamamee dili odoo mapoo egeesee woosaso, “Bei kasi maga Yesuye tekisi molee misigeli odoo sabolo goo tokenee teli odoo sabolo nei nolone ka badabala?” ");
INSERT INTO kkc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eseme Yesuye to hagee duloso nei dimapoo egeesee takaso, “Odoo paile poogoo ee melesenee neli odoo mapoo koo diya. Esino odoo paiye melesenee neli odoo mapoo ka diya. Ayo simi hagee, Godeeyo howo tekepo teli odoo doloso gweli odoo ee gilimalame ka sibile. Esino tokenee teli odoo doloso gooleedoo odoo ee gilimadoloso Godee mapoo sibilame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Biame aboso Yonee odoo howo oluguli o hamamee dili odoo sabolo, osoloso Pelisi odoo oso Godee mapoo takolone dobolone, nei tei doloso debeliso. Biame hedebeso odoo aboso sibileso Yesu mapoo egeesee woosaso, “Yoneeyo hamamee dili odoo sabolo, osoloso Pelisi odoowo hamamee dili odoo oso, nei tei doloso debeliso. Bei kasi maga nee hamamee dili odoo ee nei tei delega ka dabala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eseme Yesuye dimapoo wudu takolone nei egeesee takaso, “Sobo hulei odoo oso sobo hulame nei mopoodoo doloso o odoo gilimileiso. Egeeseega o odoo susuga sibileso gooholone nei tei doloso dabalaisomo? Haye. Diba goomoga sabolo sobo huli odoo sabolo hodobo dobolone nei nolone hodobo dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Esino biame heeso sobo huli odoo ee dimaga peegoo ido duga, diba nei tei doloso dabalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesuye wudu takolone see egeesee takaso, “Edebeeyo dugo nape mapoo dugo dia koodoloso omapoo opodoloso koo dusiya. Bei, dugo egee hapoloso magooga, dugo dia oso gawoolone sesegawe oso, dugo nape ee tologodoloso ou toowa moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Osoloso see edebeeyo wain i dia katolo gout be koloso moodoo nape mapoo koo salama seeya. Bei, wain i dia oso kitulugu oso katolo be gout koloso moodoo nape ee gabuguga, wain i ee hodalaiso. Osoloso katolo gout be koloso moodoo ee tokenee palaiso. Esiga wain i dia ee medee katolo gout be koloso moodoo dia mapoo salama salai tekepo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yu odoowo hasali biame heeso, Yesu o hamamee dili odoo sabolo witi wo ko segei ee ma kuloduga diyadaga meleeso. Osoloso Yesu o hamamee dili odoo oso witi wo ko gooloogaloso nalagamo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eseme Pelisi odoo oso ogoloso Yesu mapoo egeesee woosaso, “No ege, bei kasi maga nee hamamee dili odoo oso iyo hasali biame mapoo witi wo ko ka gooloogayo? Diayo ibada tei gababuoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuye nei egeesee takaso, “Wiligi odoo taba Deibidiye o odoo sabolo houdume, Deibidiye goo moodoo ee Godeeyo toso booka mapoo hogugu, niyo hesigeleyo? ");
INSERT INTO kkc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayata yayo Godeeyo tei moso wiligi odoo toboloso badebei omapoo, Deibidiye Godeeyo tei moso ma kulodu gadileso tei wo toloso o odoo sabolo neso. Esino tei wo hagee ibada tei ee dodolone, Godee ogo odoo ogo doloso domo debeli odoo hedebe oso nali. Esino Deibidiye o odoo sabolo wo ne oso tei magoo ee gababiaso. ");
INSERT INTO kkc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Godeeye edebeeyo hasali biame ee pidilame ka moodele. Godeeye odoo pidilame hasali biame ka moodoo. ");
INSERT INTO kkc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Esiga niyo hasali biame egee Odoo Holo ayo wiligi doloso ka badoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu see Yu odoowo howo gisili moso ma kulodu gapeleso egeino, odoo dee hodio seeseegedoo poogoo badoboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pelisi odoo aboso Yesu tokenee odoo dalame, Yesuwo goo ee medee balagamo silesibiso. Egeeseelone Yesuye dia hasali biame mapoo odoo dee hodio seeseegedoo poogoo tekepo moodabeleso bologolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eseme Yesuye odoo dee hodio seeseegedoo poogoo mapoo egeesee takaso, “No bia omaga tebee, odoo susuga oso agalame.” ");
INSERT INTO kkc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Osoloso Yesuye Pelisi odoo mapoo egeesee woosaso, “Ibada tei goo oso ibada hasali biame mapoo ogoo goo takoosomo? Biame omapoo goo tekepo talai ee tekepowo? O, goo tokenee talai ee tekepowo? Osoloso tei goo oso imapoo ibada hasali biame omapoo odoo gie badeli pidilei goo ee takoosomo? O, odoo gie badeli wooloomalai goo ee takoosomo?” diso. Esino Pelisi odoo oso Yesu mapoo to nei takele. ");
INSERT INTO kkc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dibada sooloo ma kulodu mesili goo mauwe poogoloso debeli ogoloso, Yesuye sooloo deleme kamana sabolo dimapoo egeino, odoo dee hodio seeseegedoo poogoo ogoloso yimapoo egeesee takaso, “Nee dee seeseegedoo poogoo egee see hoodode.” Eseme odoo egee o dee hoododeme, dee egee tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eseme Pelisi odoo oso Yu odoowo howo gisili moso maga peegoo dileso, Helodeeyo mooloogoodoo odoo tugodoloso, diayo Yesu toloso wooloomalame diesono to mouso. ");
INSERT INTO kkc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesuye o hamamee dili odoo sabolo Gelili abei mapoo dime, odoo mooloogoodoo toowa oso Yesuye di hamamee diyadeeso. Odoo susuga oso goo Yesuye moodoo duloso yimapoo sibadeeso. Odoo susuga hagee mi opusomo opusomo di mi hamaga sibadee: Gelili mi toowa, Yudiya mi toowa, Yelusalem mosobia, Idumiya mi toowa, Yoden howo hodio hoogoo debeli Taya mi toowa sabolo Saidon mi toowa omaga sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Eseme Yesuye odoo paigiga abo tekepo moodoome weido diso, osoloso odoo paigiga abo oso yimapoo sigilame hegi pupugamo sibume, yayo o hamamee dili odoo mapoo takaso, “Niba du hee tosibe, bei abei palaga omapoo odoo diya mooloogoo deeyaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Odoo bo holo paladee oso Yesu ogoga, diayo o homo beiyopoo gauwuloso goolone egeesee takeliso, “No Godeeyo owoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eseme Yesuye odoo bo holo paladee omapoo to kitulugu sabolo egeesee takeliso, “Nayo odoo abo mapoo a Godeeyo owolo dee na takee,” dee takeliso. ");
INSERT INTO kkc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu mubi ma dokodoo peleso yayo goomoga odoo hesigaloso yayo gilimademe, diba yimapoo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yesuye odoo 12 hesigaloso dimapoo egeesee takaso, “Niba abolo sile sibileiso, osoloso ayo niba diye dalaiso, Godeeyo to takomo sile sibilame. ");
INSERT INTO kkc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Osoloso, ayo nimapoo kitulugu tenelaiso, odoo bo holo pala peegoo hasisilame.” ");
INSERT INTO kkc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesuye gilimadoo odoo 12 dia hu hagoso: Saimon (odoo hagee Yesuye o hu hee Pita hediso); ");
INSERT INTO kkc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","osoloso Sebediyo owolo bakadio Yemes dio omolo Yonee dio (Yesuye hu hee hedi Bowaneges. Hu eyo bei ee to kei wei masi weli); ");
INSERT INTO kkc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","osoloso Endulu, Pilipi, Batolome, Matiyu, Tomas, Alpiyeseeyo owolo Yemes, Tadiyes, Loum gamalee mapoo ha teli odoo Saimon-Selot, ");
INSERT INTO kkc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","osoloso Yudas-Iskaliyot (yayo hamamee Yesu ha teli odoo dimapoo tiasooso). ");
INSERT INTO kkc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eseme Yesu o odoowo moso mapoo wedi dileso badoboome, odoo susuga oso see diya mooloogoodooso. Eseme Yesu sabolo o hamamee dili odoo sabolo diayo nei nalai biame egele. ");
INSERT INTO kkc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eseme o soosooso goo egee duloso, yo halaboomo sila pele dolone, yo dibada mosopoo ido dilame sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Esino tei eligili odoo Yelusalem maga sibadee oso egeesee takaso, “Yesu yo bo dia wiligi odoo taba Belsebul (Saiten o hu hee) o kulodu badoso. Esiga yayo bo wiligi taba oso kitulugu maga bo holo peegoo hasiso bugulone ka silo.” ");
INSERT INTO kkc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eseme Yesuye tei eligili odoo gilimadoloso wudu takolone egeesee takaso, “Saiten odoo ma kulodu badebei dieso nediliyo peegoo kasee hasiso bigileiyo? Eli mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi toowa mapoo debeli odoo oso abo puloso dieso nediliyo ha toga mi toowa egee malaime, tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Osoloso soosoo heeso abo puloso dieso nediliyo ha toga soosoo egee dabalaime, tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Osoloso Saiten eyo nediliyo o odoo sabolo ha toga, yayo kitulugu sagelaime, omapoo mauwe pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Esiga odoo heeso kitulugu odoo eyo mosopoo bi heli talame gooleega, yo daga kitulugu odoo tiso tiamagalaiso. Osoloso hamamee o moso kulodu peleso, o bi heli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Esiga ayo nimapoo taka, goo tokenee susuga edebeeyo teli sabolo, osoloso to tokenee Godee mapoo takeli ee Godeeye hapoloso boobado bigileiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Esino odoo agayo Dio Tei eyo goo maga to tokenee takooga, o goo tokenee egee hapalaime, o goo tokenee moloso kookaiyo osee malaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yayo goo hagee dimapoo takaso, bei diayo yo bo holo paladee dee takeme. ");
INSERT INTO kkc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesuwo owee sabolo omolo dio Yesuye eligimelee moso mapoo peledabaso. Diba Yesubolo to kalame peegoo tebisa molome, odoo heeso Yesu takalame moso kulodu gadiso. ");
INSERT INTO kkc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eseme odoo susuga Yesubolo debei odoo diayo ogoloso Yesu mapoo egeesee takaso, “Noowee sabolo no molo dio oso peegoo no esia molo.” ");
INSERT INTO kkc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesuye dimapoo eligilame to nei woosaso, “Mo wee sabolo molo dio odoo ogumo?” ");
INSERT INTO kkc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Osoloso see Yesuye odoo buluma omapoo ogogolone egeesee takaso, “Hamapoo ege, hagee mo wee sabolo molo dio oso. ");
INSERT INTO kkc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Odoo agayo Godeeye goomoga goo tomo siloga, diba tei molo dio osoloso mo wee dio oso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuye Gelili abei palaga odoo susuga mapoo see tobu eligimeleeso. Esino odoo susuga yimapoo mooloogoodeme, yo du ma kulodu meledoboloso buloso pepooko hoogoo dileso omaga to takaso. ");
INSERT INTO kkc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesuye wudu taka susuga dimapoo eligiliso. Yayo eligilone dimapoo takaso, ");
INSERT INTO kkc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Niba dui. Odoo hee ko segelame diso. ");
INSERT INTO kkc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yo omapoo ko kukobugumo sileeno, ko abo eli domopoo misigedibaso. Eseme só aboso sibileso neso. ");
INSERT INTO kkc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Osoloso ko abo yugogisi mi mapoo misigedibaso. Eseme mi sebega saga palaso. ");
INSERT INTO kkc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Esino osoko pa oso dei moodoome siligaloso wediaso. Bei, too mi ma kulomoo gameilega. ");
INSERT INTO kkc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Osoloso ko abo we ti bei kookoone poogoo omapoo misigedibaso. Eseme we ti ko sabolo palaso. Esino we tiso ko eyo bou tiademe dadailoso ko pele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Osoloso ko abo mi medee tekepo mapoo misigediba oso medee tekepo kauwa palaso. Osoloso ko paso, su aboso ko 30 egeesi paso, osoloso abo ko 60 egeesi paso, osoloso abo ko 100 egeesi paso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesuye egeesee takaso, “Niba dulubolo, esiga ayo hagee takoo medee hoodo dui.” ");
INSERT INTO kkc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hamamee Yesu obusomo badebeino, o hamamee dili 12 odoo sabolo, osoloso odoo abo yimapoo mooloogoo doloso debei odoo oso yimapoo, yayo wudu taka goo eyo bei woosaso. ");
INSERT INTO kkc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Eseme Yesuye nei dimapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee daga mada meleeso. Esino nimapoo woola yilige bigileiso. Esino peegoo debeli odoo mapoo ayo wudu takeliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Esiga Aisayaye taka hagee peegoo debeli odoo maga taka, ‘Diayo medee hodu dileso agalaiso. Esino goo eyo bei diayo ogoloso gooleedalaime. Osoloso diba medee hodu dileso to taka duleiso. Esino goo eyo bei diayo medee gooleedalaime. Diayo gooleedoo diepi, dibada goo tokenee maga miligi pialoso, Godeeye goo tokenee hapoloso boobado bigiliyo,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuye o hamamee dili sabolo odoo abo dimapoo egeesee takaso, “Bei kasi maga niba wudu taka hagee medee kibiya gooleedelega ka pagala? Wudu taka hageeyo bei niyo medee kibiya gooleedelega poogooga, wudu taka abo nimapoo ayo takooga, niyo kasee gooleedalaisomo? ");
INSERT INTO kkc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ko edebeeyo kukobigili ee Godeeyo to oso, osoloso yayo to egee odoo mapoo takeliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Esiga odoo abo ko oso eli domopoo misigediba egeesi masi doso. Diba Godeeyo to duliso. Esino Saitenso saga sibileso Godeeyo to dibada sooloo ma kulodu melee yayo peedee deliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Osoloso odoo abo ko yugogisi mi mapoo misigediba egeesi masi doso. Diba Godeeyo to taka duloso goomoga sabolo saga teliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Esino Godeeyo to oso dia sooloo ma kulodu too medee koo meili. Esiga diayo Godeeyo to duloso biame deiyepo mapoo tei teliso. Esino diayo Godeeyo to mapoo tei too goo maga hegi goo sabolo osoloso dala goo oso dimapoo siboga, diayo Godeeyo to mapoo tei too goo ee saga pegeliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Osoloso odoo abo ko oso dagi we ti kauwe kadee mapoo misigediba egeesi masi doso. Diba Godeeyo to duloso tei teliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Esino mipoo hageeyo gie badeli goolee sabolo, osoloso bi bei doloso badalai goolee sabolo, osoloso tokenee goo goolee sabolo oso dibada tei too tokenee peliso. Egeesi maga diayo tei too goo oso homokoko masi koo peli. ");
INSERT INTO kkc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Osoloso odoo abo ko mi tekepo mapoo misigediba egeesi masi doso. Diayo Godeeyo to duloso tei teliso. Osoloso diba Godeeyo to duloso dibada sooloo ma kulodu Godeeyo to oso homokoko masi peliso. Esiga odoo aboso homokoko masi 30 egeesi peliso, osoloso aboso homokoko 60 egeesi peliso, osoloso aboso homokoko 100 egeesi peliso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Osoloso Yesuye dimapoo wudu takolone woosaso, “Odoo heeso keme pouloso gadeebugu ee gooloogoolame, tolo ma hemidu o, debi ma hemidu mada magelisomo? Haye, yo keme pouloso dokodoo woola mageliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Goo susuga epedee hamapoo mada egee molo, see hamamee gooleedalame gadeebugu mapoo woola peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Niba dulubolo, esiga ayo hagee takoo medee hoodo dui.” ");
INSERT INTO kkc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Osoloso Yesuye dimapoo egeesee takaso, “To niyo du medee goolee. Niba to hagee medee kibiya gooleedoga, goo abo niyo medee gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Esiga to taka duli odoo mapoo Godeeye goo goolee tekepo bei tenelaiso. Esino edebeeyo mo to dulega poogooga, Godeeye yimapoo goo goolee tekepo pepooko egee molo see eyo peedee dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuye see wudu takolone egeesee takaso, “Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso witi ko o homolee mapoo segeiso. ");
INSERT INTO kkc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Osoloso yo biame susuga, gesi susuga tialo hogabuo tialo hogabuo dolone witi ko oso pala, yo gooleedele. ");
INSERT INTO kkc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Witi ko segei eyo mi naga obusomo peliso. Osoloso kauwulone daga bou gasibiliso, osoloso du teliso, osoloso hamameedee ko peliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Witi ko segei poloso telegeega, segeli odoo oso dileso gwaliso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuye egeesee takaso, “Godeeye wiligi doloso badeli goo ee kaseeyo? Ayo ogoo goo maga Godeeye wiligi doloso badeli goo ee nimapoo ka eligileiyo? ");
INSERT INTO kkc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Esiga Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso ko pepooko masted deli todileso o homolee mapoo segeiso. ");
INSERT INTO kkc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Esino ko abo ma kulodu ko masted deli hagee diya pepooko. Esino ko pepooko oso bou pisaloso kauwuga, homolee ee ma kulodu homo su oso toowa malaiso. Osoloso sóso omapoo sibileso o dee mapoo ou tegelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuye odoo mapoo wudu takolone, Godeeyo to takomo siliso. Eseme wudu taka oso dibada goo goolee sabolo teibaso. ");
INSERT INTO kkc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yayo odoo susuga mapoo hedebe wudu takemeliso. Esino Yesu o hamamee dili odoo sabolo diesono dobolone, yayo wudu taka eyo bei ee dimapoo takeliso. ");
INSERT INTO kkc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Biame hedebe omapoo osoko olo moume, Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Iba abei hodiokoo dalo soowoomo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eseme Yesuye odoo abo poogoloso, hedebe o hamamee dili odoo sabolo du maga abei daso. Esino odoo abo du hee mapoo toboloso hamamee daso. ");
INSERT INTO kkc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Diba olo abei domopoo damolome, i toowa sibume, howo ki toowa simiso. Osoloso howo ki toowa oso sibulone, dibada du ma kulodu howo sasooso. Esiga diba abei osee damolome, howo sasoo oso dibada du howomoo owulame siso. ");
INSERT INTO kkc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Esino Yesu yo du osio mapoo wolomai wolomaloso tiameleeso. Eseme o hamamee dili odoo diayo yo tidibuguloso yimapoo egeesee takaso, “Eligili odoo, iba howomoo meilame hagee see, nayo iba sooloo dolosomo?” ");
INSERT INTO kkc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eseme Yesu yo tia hogabuloso tobudulone, i sabolo howo ki sabolo omapoo egeesee takaso, “Epedee hamapoo koodobie!” Eseme i sabolo howo ki sabolo o to duloso, saga koodobiaso. ");
INSERT INTO kkc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eseme see Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Niba kaseega ka ebiala? Niba amapoo tei too meyo?” ");
INSERT INTO kkc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eseme Yesu o hamamee dili odoo diba diya obume, diesono nei woosa nei woosa dolone egeesee takaso, “Hagee odoo ogumo? Yayo i sabolo howo ki sabolo omapoo takeme o to duloso koodobiaso.” ");
INSERT INTO kkc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Osoloso Yesu o hamamee dili odoo sabolo Gelili abei daso. Osoloso dibada du Gelasa mosobia dibada mi su mapoo oluguso. ");
INSERT INTO kkc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Osoloso diba du olo oluguloso, Yesu yo mubi dokodoo polomeleeno, odoo bo holo pala oso odoo bi maga Yesu mapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Odoo hagee biame susuga odoo bi mapoo badeli, yo kitulugu toowaga edebeeyo yo ki tiso koo tialeegeeli. ");
INSERT INTO kkc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Biame susuga o homo sabolo dee sabolo ki tiso tialogoloso magooga eyo kitulugu oso ki ti kokisa bigiliso. Esiga edebeeyo yo balai eli opupa meli. ");
INSERT INTO kkc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Biame susuga osoloso gesi susuga odoo bi mapoo osoloso esia mapoo eyo nediliyo yoso kolo kookoome gwa sabolo siliso. ");
INSERT INTO kkc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu eli sage hoogooga sibumolome, odoo yo Yesu ogoloso yo tugodalame hoguo diso. Osoloso o homo beiyopoo gawuaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Eseme Yesuye yimapoo egeesee takaso, “Bo holo, no odoo yimaga peegoo gadi.” Esino odoo bo holo pala oso toso neligidi egeesee takaso, “Yesu, dokodoo badeli Godeeyo owolo, nayo amapoo ogoo goo moodoolame ka simiyo? Godeeyo goo maga nayo amapoo dala toowa na tenee!” ");
INSERT INTO kkc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eseme Yesuye yimapoo egeesee takaso, “Nee hu ogumo?” Eseme odoo oso to nei yimapoo egeesee takaso, “Mo hu Bei. Bei, iba bei odoo hageeyo kulodu.” ");
INSERT INTO kkc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Osoloso bo holo oso Yesu mapoo see howa see howa diso, bo holo mi hee mapoo seesee peegeeyaga. ");
INSERT INTO kkc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eseme koola omapoo esia ma dokodoo be hu mooloogoodoo toowa oso mi namo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eseme bo holo odoo ma kulodu debei oso Yesu mapoo see howolone egeesee takaso, “Nayo iba be mapoo palame seesee pagalai soowayo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eseme Yesuye diba be ma kulodu gasoowadee neme, bo holo odoo ma kuloduga galaga sibileso see be ma kulodu soowadeeso. Eseme be bei 2,000 egeesi oso esia dokodooga abei mapoo kukulo meileso, howomoo wediaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eseme be bali odoo oso goo hagee ogoloso kukulo dileso, dia mi mapoo osoloso mi pepooko abo mapoo goo egee takomo diso. Eseme odoo susuga oso to hagee duloso, diba agalame sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Odoo susuga oso Yesu mapoo sibileso mooloogoodooso. Esino odoo bo holo pala see tekepo poloso, goo tekepo gooleme dugo tekepo kaloso, Yesubolo badoboome ogoloso diya ebiaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eseme be bali odoo diayo goo odoo mapoo peledaba sabolo be mapoo peledaba sabolo ogoloso odoo susuga mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eseme odoo mooloogoodoo susuga oso to hagee duloso, Yesu mapoo see howa see howa diso, “No ibada mi hamaga peegoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu dilame du mapoo tooboome, odoo bo holo pala Yesuye tekepo moodoo oso Yesu mapoo egeesee howaso, “A nobolo dilei goomogo.” ");
INSERT INTO kkc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Esino Yesuye yimapoo egeesee takaso, “Haye, no mosopoo wedi dileso, Godeeye no sooloo dolone namapoo goo toowa moodoo goo ee nemisi dimapoo oposisi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eseme odoo yo see abaga wedi dino Dekapolisi mi mapoo mosobia 10 mapoo takomo diso. Odoo susuga oso to yayo taka ee duloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu o hamamee dili odoo sabolo abei hodiokoo dalo sibume, abei palaga mapoo odoo susuga oso yimapoo mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mi omapoo Yu odoowo howo gisili moso gibadeli odoo, o hu Yailas, yayo Yesu ogoloso o homo beiyopoo gawuaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Osoloso yayo see Yesu mapoo howolone egeesee takaso, “Mo sobo holo paiye moodoolame, yo talai koola taba. Esiga nee deeso yo sigilame sibe, yo paiye wediloso, see gie badalame.” ");
INSERT INTO kkc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eseme Yesu yibolo dime, odoo mooloogoodoo susuga oso hamamee yo pupugamo diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Osoloso mooloogoodoo ee ma kulodu sobo aso woolooma oso sawo dimeli ososee dugo 12 poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sobo yo melesenee neli odoo bei mapoo diayo pidilame dugo susuga dimeliso. Esino diayo yimapoo dala toowa tenemeleeso. Osoloso yayo dimapoo melesenee talame, melesenee eyo nei magolone o molee susuga hosudooso. Esino yo sawo dimeli koodobilega see toowa poloso, sawo osee dimeliso. ");
INSERT INTO kkc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Esino sobo yo daga Yesuye odoo tekepo moodoomo sili goo ee duloso, yayo odoo mooloogoodoo ee ma kuloduga Yesu yima hamamee sibileso o dugo sage yayo ka mapoo sigeso. ");
INSERT INTO kkc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sobo yayo goolee Yesuwo dugo sigoga yo tekepo palai gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yayo Yesuwo dugo sigime sawo dimeli saga koodobiaso. Eseme yo eyo egeesee gooleeso, “Sawo dimeli tekepo pa,” dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Eseme Yesu eyo gooleeno, odoo weidilame moodeli kitulugu yimaga peegoo di neme, yo odoo mooloogoodoo mapoo hodio bidi toboloso egeesee takaso, “Odoo agayo mo dugo sigoba?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eseme o hamamee dili odoo oso yimapoo egeesee takaso, “Odoo susuga oso nobolo hodobo dulone, no ka sigo domo du. Esiga nayo kasalame, ‘Odoo agayo mo dugo sigoba’ doloso ka takala? Bei, odoo susuga oso nama sigoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Esino Yesuye odoo mooloogoodoo kulodu osee esia meleeso, yo odoo agayo sigebeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eseme sobo Yesuwo dugo sige oso eyono moodoo gooleebuguloso obulone, kikiliga sabolo sibileso o homo beiyopoo gasuwoloso badebeiso, osoloso eyo goo moodoo Yesu mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eseme Yesuye nei yimapoo egeesee takaso, “Mo holo, nayo amapoo tei too maga no olo tekepo paso. Esiga no mesie sabolo di. No olo tekepo paso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Osoloso Yesu to osee takomolome, odoo aboso Yailaseeyo moso abaga sibileso Yailas mapoo egeesee takaso, “Nee sobo holo olo ta moloso. Esiga nayo eligili odoo hamapoo wulo goo mauwe na ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Esino Yesuye goo hagee duloso Yailas mapoo egeesee takaso, “No haga na ebi, wulo amapoo tei te.” ");
INSERT INTO kkc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Osoloso Yesuye egeesee takaso, “Odoo susuga, niba debee,” doloso hedebe Pita, Yemes, Yonee, osoloso Yailas esee Yesubolo diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Diba abaga dino Yailas eyo moso mapoo peledoboloso egeino, odoo susuga oso to boowa sabolo pupusiga molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesuye moso kulodu gadileso odoo susuga mapoo egeesee takaso, “Niba kaseega to boowa sabolo ka pupusiga malala? Sobo holo hagee koo tamoloso. Esino yo wulo tia moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eseme odoo susuga oso to Yesuye taka ee duloso yiligaso. Eseme Yesuye odoo susuga mapoo egeesee takaso, “Niba moso kuloduga peegoo galagadi,” diso. Osoloso Yesu yo sobo holo oso tia melee debi mapoo dulone, hedebe oma dio owee dio, osoloso o hamamee dili odoo sabolo kulodu gadiso. ");
INSERT INTO kkc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuye sobo holo ta o dee mapoo toloso yimapoo egeesee takaso, “Talita koum!” (To eyo bei sobo holo, no tebee.) ");
INSERT INTO kkc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eseme sobo holo yo epedee omapoo saga toboloso siliso (yo dugo 12). Eseme oma dio owee dio, osoloso Yesu o hamamee dili odoo sabolo diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuye dimapoo to kitulugu sabolo egeesee takaso, “Ayo sobo holo hagee wedilame moodoo goo ee, niyo odoo hee mapoo na takee,” diso. Osoloso oma dio owee dio mapoo Yesuye egeesee takaso, “Sobo holo mapoo nei tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu o hamamee dili odoo sabolo mi toowa omaga see o midee Nasalet mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Osoloso Yu odoowo hasali biame hee mapoo howo gisili moso mapoo peleso, Godeeyo to odoo mapoo eligilame bei mooloogooso. Eseme odoo susuga oso yayo eligi duloso diya howoogadolone, egeesee takaso, “Odoo hagoso goo susuga hagee kasee gooleedoowo? Yo goo goolee medee tekepo. Yayo goo toowa opusomo di moodeli kitulugu kapoo toowo? ");
INSERT INTO kkc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yo wulo moso tegeli odoo, osoloso Meliyo owolo. Osoloso yo Yemes, Yosep, Yudas, osoloso Saimon egee bia dia emei. Osoloso obooba dio onosee ibolo hodobo hamapoo doso,” diso. Esiga diayo egeesee goolone, Yesuye eligi goo ee talai goweso. ");
INSERT INTO kkc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eseme Yesuye dimapoo egeesee takaso, “Odoo susuga oso Godee maga to toloso kokodo takomo sili odoo eyo to duloso mesiliso. Esino o mosobia sabolo, osoloso o soosoo sabolo, osoloso o moso kulodu debeli odoo oso o to mapoo duloso koo mesili,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Esiga bei diayo Yesu mapoo gowoolone tei too mauwe poogoloso debei ogoloso, yayo o mi omapoo goo toowa opusomo di moodele poogooso. Esino odoo paigiga abo o deeso sigime weido diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu diayo yimapoo tei too mauwe poogoo ogoloso diya hoowaso. Eseme Yesu Nasalet mi omaga see poogoloso dileso mi pepooko abo mapoo Godeeyo to eligimo siliso. ");
INSERT INTO kkc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuye o hamamee dili odoo 12 gilimadoloso dieso nediliyo puloso bakadio tooboo, bakadio tooboo doloso mi opusomo opusomo di mapoo diye diso. Yayo diba diye dolone dimapoo kitulugu teneeso, diayo bo holo paladee ee peegoo hasisilame. ");
INSERT INTO kkc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Osoloso Yesuye dimapoo egeesee takaso, “Niyo dulone bi abo na todi. Esino niba wulo susu toloso diyadee. Osoloso nei sabolo, o sabolo, osoloso molee sabolo toloso na diyadee. ");
INSERT INTO kkc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Esino homo mapoo kali bi sabolo osoloso dugo niso ka hedebe egee mouloso dulone, dugo kali bi abo na te.” ");
INSERT INTO kkc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Osoloso Yesuye see dimapoo egeesee takaso, “Niyo mi omapoo dileso peledobooga, biame omapoo mosobia oso goomogolone moso teneega, moso hedebe omapoo doboso mi hee mapoo dulone ka poogoo di. ");
INSERT INTO kkc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Osoloso niba mi hee mapoo duga, edebeeyo niba idilega poogoloso nibada to mapoo mesilega poogooga, mi egee poogoloso dulone, megegu nibada homo mapoo mologa omapoo te, Godeeye komonolone dimapoo dia goo tokenee eyo nei tenelai goo ee gooleedalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eseme Yesu o hamamee dili odoo diayo dileso, odoo susuga mapoo Godeeyo to takomo sile sibilone egeesee takaso, “Nibada goo goolee su wuduloso goo tokenee maga miligi pie,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Osoloso bo holo odoo ma kulodu paladee diayo peegoo hasiso bugu dolone debeiso. Osoloso odoo paigiga sabolo diayo olipi iso dibada wiligi mapoo soome paigiga weido diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mi susuga mapoo odoo susuga oso Yesuwo goo takomo dime, wiligi odoo taba Helodeeye duloso gooleedooso. Odoo aboso egeesee takaso, “Yo Yonee Odoo Howo Oluguli ta maga see hogabia, esiga kitulugu goo toowa hagee yima kuloduga tou ka to,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Esino odoo aboso egeesee takaso, “Yo Ilaya.” Osoloso odoo aboso egeesee takaso, “Yo Godee maga to toloso kokodo takomo sili odoo hee daga badebei egeesi masi bado,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Esino Helodeeye goo hagee duloso yayo egeesee takaso, “Yonee Odoo Howo Oluguli, o wiligi kobugume ta odoo, yo see ta maga hogabia doo,” diso. (Yonee telega badolone, daga goo peledaba hagoso.) ");
INSERT INTO kkc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Biame heeso Helodeeye omolo Pilipiyo osobo Helodiyes peedee huso. Eseme Yoneeye goo hagee ogoloso Helodee mapoo diya takolone egeesee takaso, “Nayo nomolowo osobo peedee hulei tekeponee,” diso. Eseme Helodiyeseeye komonolone, Helodee mapoo dileso egeesee takaso, “Nayo Yonee neliga moso ma kulodu magee,” diso. Eseme yayo Yonee neliga moso ma kulodu magalame, o ha teli odoo diye dee takeme, diayo dileso yo neliga moso mapoo magooso. Esino Helodiyes Yonee mapoo hegilone, yayo yo wooloomalame gooleeso. Esino yayo yo wooloomele, bei Helodeeye Yonee wooloomalai ebiaso. Yo gooleedooso, Godeeyo howo woola Yonee goo tokenee mauwe, osoloso yo odoo medee tekepo. Esiga yayo Yonee medee bameleeso. Yayo Yoneeyo to duloso goo diya tiadiliso, esino o to mapoo dulei goomogolone, o sooloo ma kulodu goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Esino hamamee Yonee wooloomalame biame tekeposo Helodiyes mapoo simiso. Helodee soomagoo biame mapoo wo toowa nalame, gamalee wiligi odoo tebisa sabolo, osoloso o ha teli wiligi odoo tebisa sabolo, osoloso Gelili mi toowa ma kulodu wiligi odoo tebisaloso debei odoo sabolo Helodeeye gilimadoloso mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Diba wo nolone doboome, Helodiyeseeyo sobo holo oso diayo wo nolone debei moso ma kulodu gasibileso, dimapoo goomoga tenelone habaso. Eseme Helodeeye sobo yimapoo egeesee takaso, “Nayo goomoga goo amapoo takee, ayo bi egee namapoo tenelaiya,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Osoloso see Helodeeye tei yilone egeesee takaso, “Nayo goomoga goo amapoo takooga, ayo namapoo tenelaiso. Osoloso mi ayo hagee bamolo su sabolo nayo talai goomogoga, ayo namapoo tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eseme sobo yayo owee Helodiyes mapoo dileso, yayo goomoga goo ee dulame diso. Eseme sobo owee Helodiyeseeye nei egeesee takaso, “Nayo goomoga Yonee Odoo Howo Oluguli eyo wiligi goomogo dee takee.” ");
INSERT INTO kkc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eseme yayo oweeyo to duloso, saga wedi dileso Helodee mapoo egeesee takaso, “Epedee hamapoo Yonee Odoo Howo Oluguli eyo wiligi koodoloso tolo mapoo magoloso tosiboga ee talai, a goomogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Helodeeye to hagee duloso yo diya gooheleso. Esino yo odoo susuga eyo howo woola mapoo eyo tei magoo ee gababilei ebiaso. Esiga yayo sobo o to mapoo gowele. ");
INSERT INTO kkc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Osoloso Helodeeye o ha teli odoo hee neliga moso gibali oso Yoneeyo wiligi koodolame diye diso. Eseme yayo neliga moso mapoo dileso Yoneeyo wiligi koodoloso, odoo susuga oso agalame tolo mapoo magoloso, odoo howo woola tosibileso sobo holo mapoo teneeso. Eseme sobo yayo toloso owee mapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yonee o hamamee dili odoo oso goo hagee duloso, diayo sibileso o kou todileso wulu odoo toga tooseli omapoo kulodu magooso. ");
INSERT INTO kkc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesuye diye di odoo 12 diba see wedige sibileso, goo diayo moodoo sabolo osoloso goo diayo eligi susuga ee Yesu mapoo oposususo. ");
INSERT INTO kkc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Odoo susuga Yesuye badebei omapoo dile see sibo di oso, Yesu o hamamee dili odoo sabolo nei nalai biame tekepo egele. Eseme Yesuye o hamamee dili odoo mapoo egeesee takaso, “Iba ibusomo odoo mauwe poogoo mi mapoo dileso hasalame dimo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","33","Eseme Yesu o hamamee dili odoo sabolo du ma kulodu bulumaloso, abei hodiokoo odoo koola mauwe mi mapoo dalo soowoolame moumeleeno, odoo abei palaga debei oso ogoloso gooleedooso. Eseme odoo susuga oso mi opusomo opusomo di maga Yesuye di mi mapoo malalo mili hoguga diyadeeso. Diba malalo dileso balaga meleeno, Yesu o hamamee dili odoo sabolo du maga sibileso gimagooso. ");
INSERT INTO kkc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Osoloso Yesu du maga mi mapoo pubalogoloso, odoo susuga oso mooloogoodoloso debei ogoloso, yayo diba diya sooloo dalaso, bei sipi be hu masi bali odoo mauwe poogoloso doboome. Eseme yayo goo susuga dimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Osoko olo todobume, Yesu o hamamee dili odoo oso yimapoo sibileso egeesee takaso, “Osoko olo todobuo. Osoloso mi iyo hagee do mapoo odoo mauwe. Esiga mi hamapoo nei mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Esiga nayo odoo susuga egee do diyadee dee, diayo mosobia koola kee do mapoo dileso nei dieso nalai ee moleeso talame,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Esino Yesuye o hamamee dili odoo mapoo nei egeesee takaso, “Diayo nei nalai niso toloso dimapoo tenee,” diso. Eseme diayo Yesu mapoo egeesee takaso, “Iyo nei toloso dimapoo teneega, molee ko 200 oso teli, esino iba molee mauwe.” ");
INSERT INTO kkc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eseme Yesuye dimapoo egeesee woosaso, “Diba wo kasolo molosomo? Niyo agalame di.” Eseme diayo dileso ogoloso, diayo yimapoo egeesee takaso, “Wo si dee tiadoo sabolo osoloso di bakadio moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eseme Yesuye o hamamee dili odoo mapoo egeesee takaso, “Odoo susuga mapoo egeesee takee, ‘Niba mi mapoo pepooko mooloogoodoloso buluma mooloogoodoloso buluma,’ dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eseme diayo dimapoo takeme, diba mooloogoodoo opusomo opusomo doloso mooloogoodoo hee mapoo odoo 100, osoloso mooloogoodoo hee mapoo odoo 50 doloso bulumaso. ");
INSERT INTO kkc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eseme Yesuye wo si dee tiadoo sabolo di bakadio sabolo toloso, Kei mi ma dokodoo bolone, Godee mapoo goomoga to takaso. Osoloso yayo wo popeiloso di sabolo agisaloso o hamamee dili odoo mapoo piso, diayo odoo susuga mapoo pilame. Eseme diayo wo si popei sabolo di hwei sabolo odoo susuga mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eseme odoo susuga oso nei teiba nega diya edigaso. ");
INSERT INTO kkc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Osoloso diayo nei naloso abo poogoo ee, Yesu o hamamee dili odoo oso misigamo dileso bou tegei 12 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Osoloso sobo sabolo holaiso sabolo nei neso. Esino mooloogoodoo ee ma kulodu gisowe hesiga 5,000 oso nei ka ne. ");
INSERT INTO kkc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Diba nei nalaga koodobuloso, Yesuye o hamamee dili odoo malalo du maga Betesaida mi mapoo diye doloso, diba abei damolome, Yesuye odoo susuga dibada mi mapoo diye diso. ");
INSERT INTO kkc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Osoloso Yesuye odoo susuga diye doloso, yo obusomo Godee mapoo takalame mubi dokodoo palaso. ");
INSERT INTO kkc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gesi domo o hamamee dili odoo dibada du maga abei domo damolome, Yesu yo obusomo mubi dokodoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu mubi dokodoo badolone egeino, poo sabolo howo ki sabolo simi oso, o hamamee dili odoo dia du mapoo woome, diba kwasu sabolo du sulugamo diyadaga molome egeiso. Osoloso gesikolo kudi olo tadageme, yo howo dokodooga diba daga dilame dimeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Esino o hamamee dili odoo diayo Yesu howo dokodooga dimelee ogoloso, diayo goolee boso siba bele dolone diya googaso. ");
INSERT INTO kkc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yesu o hamamee dili odoo oso yo ogoloso obugume, yayo dimapoo egeesee takaso, “Niba howaleegee. Haga na ebi. Ayo siba.” ");
INSERT INTO kkc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Osoloso Yesu yo du ma kulodu daboogoome, howo ki sabolo poo sabolo saga koodobiaso. Eseme Yesu o hamamee dili odoo oso goo hagee ogoloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Diba Yesuwo kitulugu gooleedoo diepi, diba howoogele pegeliyo. Esino diba howoogadooso, bei dia goo goolee oso gooleedalai tebilega. ");
INSERT INTO kkc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Osoloso diba abei daloso abei hodiokoo Genesalet mi mapoo dibada du oluguso. ");
INSERT INTO kkc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Diba du oluguloso mubiyodoo dalaga poogoome, odoo omapoo tebisa melee oso yo kibiya hoodo egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Odoo susuga mi opusomo opusomo di mapoo hoguga dileso, odoo paigiga dibada kida mapoo tiedigaloso Yesu mapoo emigado sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu mi opusomo opusomo di mapoo silime, edebeeyo odoo paigiga kida mapoo tieduloso, bi teli go mapoo emigado sibileso magooso. Eseme odoo paigiga oso Yesu mapoo howolone egeesee takaso, “Iyo wulo nee dugo su mapoo sigilei soowayo?” diso. Osoloso odoo paigiga oso Yesuwo dugo su mapoo sigime, odoo egee bia wegigadooso. ");
INSERT INTO kkc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Biame hedebeso Pelisi odoo sabolo osoloso tei eligili odoo abo oso Yelusalem mi maga sibileso Yesu mapoo mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Osoloso diayo egeino, Yesu o hamamee dili odoo abo oso Yu odoowo tei dedelega poogoloso nei nalame, dibada dee howo koo hapagali. ");
INSERT INTO kkc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Esino Yu odoo sabolo Pelisi odoo sabolo dibada adaga dia tei eligi goo ee dodolone, daga nei nalame dee howo hapagaliso. ");
INSERT INTO kkc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Diba bi teli go mapoo bi toloso nala poogolone, daga dibada dee medee howo hapagaloso ka nali. Osoloso dibada adaga dia tei eligi goo ee dodolone, dibada kapu sabolo sesepeni sabolo osoloso disi sabolo howo hapagaliso.) ");
INSERT INTO kkc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eseme Pelisi odoo sabolo osoloso tei eligili odoo oso Yesu mapoo egeesee woosaso, “Bei kasalame nee hamamee dili odoo oso ibada adaga dia tei eligi goo ee dedelega ka pagala? Diba dee howo hapegelega nei naliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eseme Yesuye nei dimapoo egeesee takaso, “Niba goo bakadio gweli odoo. Godee maga to toloso kokodo takomo sili odoo hee Aisayaye nibada goo maga tei goo takaso. Bei, yayo goo Godeeye taka egeesee hoguguso, ‘Odoo hagee bia oso dia magaso wulo gamenee amapoo goomogolone mo hu dokodoo poudiliso. Esino dibada sooloo ma kulodu tei amapoo mesili goo ee mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Diayo amapoo goomogolone mo hu dokodoo poudili goo eyo bei mauwe. Bei, diayo tei edebeeyo eligi goo ee ayo eligi masi see diayo odoo mapoo eligimo silesibiliso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Niba Godeeyo tei eligi goo ee poogoloso, see nibada adaga dia tei eligi goo ee deedeeso.” ");
INSERT INTO kkc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesuye dimapoo see tobu egeesee takaso, “Niyo tei Godeeye eligi goo ee peegoo magoona, nibada adaga dia tei eligi goo ee talame. ");
INSERT INTO kkc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Esiga daga hoogoo Moseseeye tei goo Godee maga simi nimapoo tenee hagoso, ‘Nama dio noowee dio oso to taka duloso dimapoo mesie. Esino odoo agayo ama dio owee dio mapoo to tokenee takooga, yo wooloomalaiso.’ ");
INSERT INTO kkc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Esino niyo egeesee takeliso, ‘Soowa, edebeeyo ama dio owee dio mapoo takoo, “Emegei, niba ayo pidileime, bei molee amapoo egee molo Godee mapoo tenelame siga. Molee egee ibada toso hedi koloban.” ’ ");
INSERT INTO kkc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Niyo odoo owee dio ama dio ee pidilei tei magooso. ");
INSERT INTO kkc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Niyo tei magoo ee dodolone Godeeyo tei magoo peegoo magolone ka doso. Osoloso niba goo abo susuga egeesi masi tomo silesiboso.” ");
INSERT INTO kkc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eseme Yesuye odoo mooloogoodoo see gilimadoloso, dimapoo egeesee takaso, “Odoo susuga niba, mo to hagee duloso medee gooleede. ");
INSERT INTO kkc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Esiga edebeeyo nei nali oso o sooloo ma kulodu Godeeyo howo woola tokenee koo peli. Esino odoo o sooloo ma kulodu goo gooleemeleso, to tokenee taka sabolo, osoloso yayo goo tokenee tomo sili oso, o sooloo ma kulodu Godeeyo howo woola tokenee peliso.  ");
INSERT INTO kkc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Niba dulubolo, ayo hagee takoo niyo medee hoodo dui,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eseme Yesuye odoo mooloogoodoo poogoo dileso, moso kulodu gadime, o hamamee dili odoo oso dileso yimapoo egeesee takaso, “Nayo wudu taka goo eyo bei imapoo medee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Eseme Yesuye dimapoo egeesee takaso, “Niba goo eyo bei medee koo gooleedolo? Esiga nei niyo toloso nali oso nibada sooloo ma kulodu Godeeyo howo woola tokenee koo peli. Bei, nei egee sooloo ma kulodu koo gameli. Esino nayo nalo sooloogoloso see nee gemedei maga peegoo gadiliso.” (Yesuye goo hagee takolone, yayo to kitulugu sabolo takaso, nei nali bi susuga nalai tekepo, diso.) ");
INSERT INTO kkc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Esino Yesuye see egeesee takaso, “Odoo o sooloo ma kulodu goo gooleemeleso, to taka sabolo, osoloso yayo goo tokenee tomo sili oso, o sooloo ma kulodu Godeeyo howo woola tokenee peliso. ");
INSERT INTO kkc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Esino o sooloo ma kuloduga goo tokenee susuga hagoso woola peledebeliso: tokenee gweli goo, osoloso sobo obuo sabolo giso kadiga sabolo goo heli teli goo, osoloso adaba bi heli teli goo, osoloso odoo wooloomali goo, osoloso adaba kooka sobo sabolo kooka giso sabolo goo heli teli goo, ");
INSERT INTO kkc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bi bei doloso badalai gweli goo, osoloso tokenee teli goo, osoloso emegei dimapoo gamenee takeli goo, osoloso odoo susuga eyo howo woola ebili goo talai, osoloso emegei dimapoo kweli goo, osoloso emegei dia goo maga to tokenee takeli goo, osoloso suwa peli goo, osoloso goo tekepo goolee me sili goo. ");
INSERT INTO kkc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Esiga goo tokenee susuga egee talame odoo o sooloo ma kulodu gooleemeleso toga, o sooloo ma kulodu Godeeyo howo woola tokenee peliso.” ");
INSERT INTO kkc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu o hamamee dili odoo sabolo mi egee poogoloso, see Taya mi toowa koola mapoo diyadeeso. Osoloso yo dileso, odoo susuga oso yayo simi ogoloso gooleedeeyaga, moso hee mapoo kulodu gapeleso mada badebeiso. Esino odoo susuga oso yayo simi goo ee duloso, odoo abo mapoo saga takomo dime, diba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Eseme Yu sobonee hedebe Ponesiya Siliya mi mapoo badeli oso Yesuwo goo ee duloso, yayo badebei mi omapoo simiso. Yayo sibileso Yesuwo homo beiyopoo gauwuloso badolone egeesee hoowaso, “Mo sobo holo yima kulodu bo holo peleso badoso. Esiga nayo sibileso o kulodu bo holo egee bado peegoo habigilame sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","(Yu odoo oso Yu odoonee mapoo so, dee takeliso. Osoloso Yu odoo ee takolone odoo holaiso, deliso. Eseme sobo yayo goo egee moodoolai kitulugu teiba doloso yimapoo tei too mala beleso agalame) Yesuye sobo mapoo egeesee takaso, “Holaiso dia nei toloso so mapoo tenelai tekeponee. Esino daga holaiso dimapoo nei tenelai tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Eseme sobo hagoso Yesu mapoo nei egeesee takaso, “O. Lodee, nayo tei takoo. Esino so moso hemidu silesibulone, holaisoso nei nolone kokou miyomoo mou ee nalagamo silesibiliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eseme Yesuye sobo mapoo egeesee takaso, “Nayo amapoo to nei tekepo takaso. Esiga no mosopoo dileso nowolo sobo holo mapoo ege, yo tekepo badoso. Bo holo epedee o beliye ma kulodu mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eseme yo o mosopoo dileso, o sobo holo egeino bo holo o kulodu pala mauwe poogoloso, tekepo poloso debi mapoo wulo tia molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu o hamamee dili odoo sabolo Taya mi poogoloso Saidon mi mapoo peledabaso. Osoloso diba see abaga dino Dekapolisi mosobia mapoo peledoboloso, Gelili abei mapoo mouso. ");
INSERT INTO kkc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Osoloso odoo aboso odoo dulu taba ibaya Yesu mapoo ido sibileso howaso, yayo o deeso sigiloso tekepo palame. ");
INSERT INTO kkc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuye odoo dulu taba ibaya odoo mooloogoodoo omaga peegoo ido dileso, Yesuwo dee woluguso dulu taba ibaya eyo dulu ou mapoo tuluguloso, makawo o dee mapoo paga magoloso, odoo dulu taba ibaya eyo i mapoo sigeso. ");
INSERT INTO kkc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Osoloso Yesuye Kei mi ma dokodoo bolone sooloo toowa polomeleso homodobuloso yimapoo o toso egeesee takaso, “Epata!” (to eyo bei ee yiliga magee). ");
INSERT INTO kkc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eseme epedee omapoo dulu taba ibaya eyo dulu tekepo poloso to taka o duluso medee duso, osoloso o iso to medee kalame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Osoloso Yesuye odoo susuga mapoo takolone, goo yayo moodoo ee na oposisi doloso, dimapoo to kitulugu sabolo takeliso. Esino yayo takolone diayo odoo abo mapoo na oposisi dee taka poogoloso, see odoo abo mapoo oposisiliso. ");
INSERT INTO kkc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eseme odoo susuga oso Yesuye goo moodoo duloso diya howoogadooso. Osoloso diayo see egeesee takaso, “Yesu goo susuga tomo sili medee tekepo. Iyo goolee edebeeyo odoo dulu tabaga ibaya tekepo koo moodoogamo silabelee dee. Esino yayo odoo dulu tabaga osoloso to koo kalagali yayo tekepo moodoogamo siliso.” ");
INSERT INTO kkc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Biame heeso Yesuye goo eligi ee dulame see yimapoo odoo susuga mooloogoodoloso debeiso. Esino nei mauwe poogoome, Yesuye o hamamee dili odoo gilimadoloso dimapoo egeesee takaso, “Ayo odoo susuga hagee diya sooloo dolo, bei diba abolo dobolone biame bakadio hedebe di poogooga. Esiga diayo nei nalai mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Osoloso ayo diba nei tenelega, dibada mosopoo diyadee dee takooga, diba eli domopoo houdaso kitulugu me poogoloso howamadagalaiso, bei odoo abo dibada mi koola hapoonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eseme Yesu mapoo o hamamee dili odoo oso egeesee woosaso, “Nei mauwe, osoloso moso mauwe miwe poogoo mi hamapoo, iyo nei kamapoo toloso odoo susuga hamapoo ka tenelaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eseme Yesuye o hamamee dili odoo mapoo egeesee woosaso, “Nimapoo wo si kasolo molosomo?” dee takaso. Eseme diayo nei egeesee takaso, “Imapoo wo si 7 moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eseme Yesuye odoo susuga mi mapoo bulume diso. Osoloso yayo wo si 7 toloso Godee mapoo goomoga to takaso. Osoloso wo si popeiloso odoo susuga mapoo pilame, o hamamee dili odoo mapoo piso. Eseme diayo odoo mooloogoodoo susuga mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Osoloso odoo mooloogoodoo ma kulodu di pepooko abo molo egeiso. Eseme Yesuye di toloso Godee mapoo goomoga to takoloso, o hamamee dili odoo mapoo teneme, diayo toloso odoo mooloogoodoo mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eseme odoo susuga nei ne oso diya edigime, diayo nei naloso abo poogoo ee, Yesu o hamamee dili odoo oso misigaloso, bou tegei ma kulodu soo bou 7 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Esiga biame omapoo odoo 4,000 oso nei egee neso. Osoloso diba nei naloso, hamamee Yesuye dibada mi mapoo diyadee, diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Osoloso diba diye doloso, Yesu o hamamee dili odoo sabolo abei mapoo meileso du ma kulodu bulumaloso, Dalmanuta mi mapoo dalo soowaso. ");
INSERT INTO kkc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Diba Dalmanuta mi mapoo soowooleso peledoboome, Pelisi odoo oso Yesu mapoo toso agadilame sibadeeso. Bei, diba goomogaso, Yesuye kitulugu egee tomolo tei Godee maga simibeleso kukuloso agalame. Egeesee meleso, diayo Yesu mapoo goo toowa opusomo di moodee doloso takaso. ");
INSERT INTO kkc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eseme Yesuye goo hagee duloso, yo diba gooheleme sooloo toowa polomeleso homodobuloso dimapoo egeesee takaso, “Bei kasi maga epedee biame hamapoo odoo susuga hagee do oso goo toowa opusomo di moodoo ee agalame ka woosaliyo? Esiga ayo nimapoo tei goo taka, ayo goo toowa opusomo di odoo epedee biame hamapoo hagee do omapoo niyo agalame see moodoolaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Osoloso Yesuye goo hagee takemelee koodobuloso, see o hamamee dili odoo gilimadoloso du mapoo meileso, abei hodiokoo dalo soowaso. ");
INSERT INTO kkc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Diba abei hodiokoo dalo soowoolone wo talai boobado bugunabu. Esino du ma kulodu wo si hedebe molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eseme Yesuye dimapoo kokodo takalame, wudu takolone egeesee takaso, “Niba obeeyamo! Bei, Pelisi odoo sabolo osoloso Helodee dibada goo ee wo habili masi moloso. Osoloso wo giedege sabolo wo habia sabolo hamaga, wo giedege habia oso tokenee palaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eseme diayo Yesuye taka duloso diesono to moulone egeesee takaso, “Iyo wo telega boobada poogoo simiga Yesuye iba ogoloso egeesee ka takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Esino diayo to moulone debei ee Yesuye ogoloso dimapoo egeesee takaso, “Bei kasi maga niyo wo telega boobada poogoo simi maga goo diya koudulone ka dabala? Esiga niba ayo kitulugu goo ee gooleedelega osee doso. Nibada sooloo ma kulodu goo ayo eligi ee gooleedoloso, nibada sooloo ma kulodu magalai diya kalawado? ");
INSERT INTO kkc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Niba howo mauwega, egele ka pagala? Niba dulu mauwega, dule ka pagala? Niba ayo wo si dee tiadoo giso 5,000 mapoo pi goo ee boobadoolo? Diayo nei naloso, wo abo poogoome, niyo misigamo di bou tegei kasolo metamagisayo?” diso. Eseme diayo nei egeesee takaso, “Bou tegei 12.” ");
INSERT INTO kkc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Eseme Yesuye see egeesee takaso, “Ayo odoo 4,000 mapoo wo si 7 populoso pi, wo abo poogoome, niyo misigamo di bou tegei kasolo metamagisayo?” diso. Eseme diayo nei egeesee takaso, “Bou tegei 7.” ");
INSERT INTO kkc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eseme Yesuye egeesee takaso, “Ayo odoo susuga mapoo wo pi goo ee niyo egeiso. Esino bei kasi maga Pelisi odoo sabolo Helodee dibada goo wo habili masi maga ayo hagee takoo niyo gooleedelega osee ka dabala?” ");
INSERT INTO kkc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Osoloso diba Betesaida mi omapoo peledoboloso, odoo abo oso odoo howo bakadio si Yesu mapoo ido sibadeeso. Osoloso diayo Yesu mapoo howoolone egeesee takaso, “Odoo hagee nee deeso sigoloso yo tekepo pe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eseme Yesuye o hamamee dili odoo sabolo dulone, yayo odoo howo bakadio si eyo dee mapoo toloso mosobia omaga yo peegoo ido diso. Osoloso Yesuye o howo mapoo makawo paganuloso, yayo odoo egeeyo howo mapoo sigoloso, Yesuye yimapoo egeesee woosaso, “No epedee bi susuga ogolo?” ");
INSERT INTO kkc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eseme odoo yayo peegoo ogogolone egeesee takaso, “O, olo ogoso. Esino odoo silesibono medee koo ogo. Diba homo masi silesibo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eseme Yesuye o deeso see odoo howo bakadio si eyo howo mapoo sigeme, olo epedee omapoo o howo tekepo poloso bi ogogolone egeesee takaso, “Bi susuga medee ogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu odoo howo bakadio si tekepo moodooloso, Yesuye yo tekepo moodoo odoo abo mapoo takelega pagalame, yo mosopoo diye dolone yimapoo takaso, “No duga mosobia kuloduga na di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu o hamamee dili odoo sabolo abaga mosobia koola Kasaliya-Pilipai mi mapoo polone, eli domo dulone, Yesuye o hamamee dili odoo dimapoo egeesee woosaso, “Edebeeyo a odoo ogu deliyo?” ");
INSERT INTO kkc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eseme diayo Yesu mapoo nei egeesee takaso, “Odoo aboso taka, no Yonee odoo howo oluguli odoo toloso hogado simi deliso. Aboso taka, no Ilaya deliso, osoloso odoo aboso taka, no Godee maga to toloso kokodo takomo sili odoo hee daga badebei deliso.” ");
INSERT INTO kkc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuye dimapoo egeesee woosaso, “Niyo a odoo ogu deliyo?” Eseme Pitaye nei egeesee takaso, “No Keliso, Godeeye hudi magoo oso.” ");
INSERT INTO kkc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eseme Yesuye dimapoo to kitulugu sabolo egeesee takaso, “Odoo mapoo a Keliso Godeeye hudi magoo dee na takeeye!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuye o hamamee dili odoo eligi bei mooloogolone egeesee takaso, “Odoo Holo, a dala toowa bei talaiso, osoloso Yu odoowo wiligi odoo tebisa sabolo, tei moso wiligi odoo tebisa sabolo, tei eligili wiligi odoo tebisa sabolo oso a gowoolone pagalaiso. Osoloso edebeeyo a wooloomaloso, bi mapoo ta moloso biame bakadio hedebe di mapoo see bi maga hogadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesuye goo hagee o hamamee dili odoo dimapoo woola yilige bugume, Pitaye yo peegoo ido dileso yimapoo egeesee takaso, “No egeesee na takee.” ");
INSERT INTO kkc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Eseme Yesuye o hamamee dili odoo dimapoo bidi toboloso bolone, Pita mapoo egeesee takaso, “Saiten, no amaga peegoo di! Nayo to egee takoo Godeeye taka ee koo takoo. Esino edebeeyo taka goo ee takoo.” ");
INSERT INTO kkc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuye o hamamee dili odoo sabolo osoloso odoo mooloogoodoo gilimadoloso, dimapoo egeesee takaso, “Edebeeyo ayo di hamamee sibilei goomogoga, yo daga eyo goomoga goo tomo sili ee poogoloso, eyo talai sabolo dala toowa talai sabolo medee mopoodoo doloso ama hamamee ka sibe. ");
INSERT INTO kkc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Esiga edebeeyo o gie badeli eyo goodogoga, o gie badeli ee osugobalaiso. Esino edebeeyo mo goo maga sabolo osoloso to tekepo eyo goo maga o gie badeli eyo goodegelega poogooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Esino edebeeyo mipoo hamapoo badolone, eyo goomoga goo susuga ee tomo siloso, hedebe gie badeli goo ee telega dagaduga, yo see ogoo goo talaisomo? Mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bei, yayo gie badeli eyo nei talai mipoo hamapoo bi hee mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Esiga edebeeyo Godeebolo ebilega poogoloso, goo tokenee osee tomo silesibo epedee biame hamapoo, edebeeyo abolo osoloso mo to mapoo gowooga, hamamee ayo mo Maye toowa doloso badeli goo omaga o gadeebugu sabolo, osoloso o momaiye sabolo sibileso, nei ayo yo gowoolaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuye dimapoo egeesee takaso, “Ayo nimapoo ka taka, odoo abo hamapoo hagee do, niba epedee talaime. Esino daga malalo Godeeye wiligi doloso badalai biame goo kitulugu sabolo siboga agalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Osoloso biame 6 olo poogoloso, hamamee Yesuye Pita, Yemes, osoloso Yonee esee mubi hoo dokodoo odoo mauwe mapoo ido paladeeso. Mubi hoo dokodoo o hamamee dili odoo oso balaga molome Yesu o su opusomo paso. ");
INSERT INTO kkc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eseme egeino Yesu o dugo diya hohodi ka heliye omaga poni oso howo dooso. Esiga mi hamapoo odoo heeso dugo hapooga dugo heliye egeesi molo agalaime. ");
INSERT INTO kkc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Diba omapoo dobolone egeino, Moses dio Ilaya dio peledoboloso Yesubolo to kesamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitaye Yesu mapoo egeesee takaso, “Eligili odoo, iba hamapoo dabalai tekepo. Esiga iyo waseme bakadio hedebe di tegegalaiso, hee nee, hee Moseseeyo, osoloso hee Ilayayo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitaye takalai kibiya gooleedele, diba obume. ");
INSERT INTO kkc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eseme koloboso sibileso, diba gidisooso. Osoloso kolobo ma kuloduga toso egeesee takaso, “Hagee ayo gooma mo holo oso. Esiga o to mapoo medee dui,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eseme Pita, Yonee, osoloso Yemes to taka duloso egeino, Moses dio Ilaya dio mena, esino hedebe Yesu dibolo tobudume egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Osoloso diba mubi dokodooga see kumoo moulone, Yesuye to kitulugu sabolo dimapoo egeesee takaso, “Goo niyo egei ee odoo abo mapoo na takee. Esino Odoo Holo, a ta maga see hogado pala ogoloso, niyo hamamee ka takomo silesibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eseme Yesuye to taka diayo wulo kookoodooso. Esino diayo Yesu ta maga see hogado pala goo eyo bei ee diesono nei woosa nei woosa demeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Osoloso diayo Yesu mapoo egeesee woosaso, “Bei kasalame tei eligili odoo oso takolone, daga malalo Ilayaye sibileso, Keliso hamamee sibileigo, dee ka takeliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eseme Yesuye nei dimapoo egeesee takaso, “Ilaya tei sibileso goo susuga see medee mopoodoo dalaiso. Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Odoo Holo, a dala toowa talaiso, osoloso edebeeyo a gowoolaiso.’ ");
INSERT INTO kkc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Esino ayo nimapoo taka, Ilaya yo olo simiso. Osoloso edebeeyo yimapoo dala teneeso, bei Godeeyo to booka maga taka ee dodolone.” ");
INSERT INTO kkc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu o hamamee dili odoo bakadio hedebe di sabolo mubi dokodooga meileso egeino, Yesu o hamamee dili odoo abo oso tei eligili odoo sabolo agadiga molome egeiso. Eseme odoo susuga sibileso mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Diba diesono mooloogoodoloso balaga meleeno, Yesu dimapoo simi ogoloso, diya howoogadooso. Osoloso diayo Yesu mapoo goomoga sabolo hoguga sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eseme Yesuye dimapoo egeesee woosaso, “Niba ogoo goo maga agadiga malala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Osoloso mooloogoodoo ee ma kuloduga odoo heeso egeesee takaso, “Eligili odoo, mo giso holo bo holo pala oso ibaya paga, nayo moodoolame ido simino, no hamapoo mena. ");
INSERT INTO kkc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Esiga bo holo yimapoo pologa, yo miyomoo homodobuloso, kakawa molone o mei wulo tekeliso, osoloso maga maga makawo tiodiliso. Esino nee hamamee dili odoo dimapoo mo holo bo holo peegoo hasiso bigilame woosano, diayo bo holo peegoo hasiso bigile, bei diayo kitulugu tebilena.” ");
INSERT INTO kkc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eseme Yesuye dimapoo egeesee takaso, “Niba tei too mauwe odoo. Niyo amapoo tei talame, a biame kasolo nibolo hodobo ka badalaiyo? Ayo biame sage nibolo hodobo badebeino, niyo amapoo tei telega osee doga, a nimapoo diya gowooso. Esino giso holo egee amapoo ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eseme diayo giso holo Yesu mapoo ido simiso. Esino bo holo eyo Yesu ogoloso, giso holo yo bo holoso o kulodu degiga meleso miyomoo homodobiaso. Eseme maga mapoo makawo oudoo sabolo mi mapoo bidigamo sileeso. ");
INSERT INTO kkc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuye holopeyo ama mapoo egeesee woosaso, “Goo hagee kopolone holope yimapoo bei ka mooloogoowo?” Eseme holopeyo amameeye nei Yesu mapoo egeesee takaso, “Yo pepooko mapoo bei mooloogoo. ");
INSERT INTO kkc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Biame susuga bo holoso holope wooloomalame yo dou mapoo toodoo, osoloso howomoo huso demeleeso. Esiga no kitulugu teiba mologa, nayo iba sooloo dele, osoloso iba pidi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eseme Yesuye yimapoo egeesee takaso, “Nayo taka, ‘No kitulugu teiba daga iba pidi,’ diso. Esino edebeeyo amapoo tei toga, goo susuga haga kalawanee.” ");
INSERT INTO kkc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eseme holopeyo amameeye Yesu mapoo toso neligidi egeesee takaso, “Ayo namapoo tei tooso, esino nayo a pidi, mo tei too pepooko see toowa dee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eseme odoo susuga oso Yesu mapoo saga mooloogoodalame sibadee ogoloso, Yesuye bo holo mapoo toso neligidi egeesee takaso, “No odoo mapoo dulu taba ibaya teneli. Esiga ayo namapoo to kitulugu sabolo ka taka, no epedee holope hageeyo kuloduga peegoo gasiboga, see holope hageeyo kulodu na gadi.” ");
INSERT INTO kkc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Osoloso bo holo gwa sabolo diya degiga meleso holope miyomoo togobuloso, yo peegoo gadiso. Eseme holope mi mapoo degigilega kakawoloso meleeso. Eseme odoo aboso goolee, yo olo ta, dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Esino Yesuye holopeyo dee mapoo toloso, yo tabalame pidiso. Eseme holope yo tabaso. ");
INSERT INTO kkc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Osoloso Yesu o hamamee dili odoo sabolo dibusomo moso kulodu dobolone, diayo Yesu mapoo egeesee woosaso, “Iyo kaseme bo holo holopeyo kulodu pala ee peegoo habigilei kitulugu mauwe ka poogoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo daga Godee mapoo takooga, bo holo egeesi masi peegoo ka hasiso bigiya,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu o hamamee dili odoo sabolo mi egee poogoloso, see Gelili mi ee ma kuloduga diso. Osoloso Yesu yo goomegele, odoo heeso yo egeyaga. ");
INSERT INTO kkc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bei, Yesuye o hamamee dili odoo eligi meleeso. Yayo dimapoo egeesee takaso, “Odoo Holo, a amapoo ha teli odoo mapoo tenelame tiasalaiso. Osoloso diayo a wooloomalaiso, esino a bi mapoo ta moloso biame bakadio hedebe di mapoo gie badeli toloso hogadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Esino diayo Yesuye taka goo eyo bei medee kibiya gooleedele. Eseme diayo see Yesu mapoo woosalai ebigaso. ");
INSERT INTO kkc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu o hamamee dili odoo sabolo Kapeniyum mi mapoo peledabaso. Osoloso diba moso dieso dabalai mapoo dobolone, Yesuye o hamamee dili odoo mapoo egeesee woosaso, “Niba eli domopooga sibulone, ogoo goo maga toso agadigamo simiyo?” ");
INSERT INTO kkc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Esino diayo to nei wedi dile. Bei, diayo dieso nediliyo dima kulodu odoo agayo wiligi doloso badalai goo maga toso agadigaso. ");
INSERT INTO kkc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu yo biamolone o hamamee dili odoo gilimadoloso, dimapoo egeesee takaso, “Edebeeyo malalo wiligi doloso badalai goomogoga, yo eyo nediliyo pepooko doloso badebee, osoloso yo tou teli odoo masi mesie sabolo odoo susuga ee halo tou tolone ka badebee.” ");
INSERT INTO kkc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesuye holope hee ido sibileso, dibada mudugiyopoo tebidiso. Osoloso holope Yesuye maduloso dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Edebeeyo holope hageesi masi mo hu maga o mosopoo ido pologa, yayo a ido poloso. Osoloso edebeeyo o mosopoo a ido pologa, yayo mo Ma a diye di ee ido poloso.” ");
INSERT INTO kkc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Eseme Yoneeye Yesu mapoo egeesee takaso, “Eligili odoo, iba odoo heeso bo holo ee nee hu maga odoo ma kuloduga peegoo hasiso bugume egeiso. Eseme iyo yo hamaga takaso. Bei, yo ibada mooloogoodoo ma kulodu koo badeli.” ");
INSERT INTO kkc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eseme Yesuye egeesee takaso, “Na hamaga takee. Odoo heeso mo hu maga goo toowa opusomo di moodooga, yayo mo goo maga tokenee goo saga takalaime. ");
INSERT INTO kkc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Osoloso edebeeyo imapoo ha telega badoga, yo ibada odoo oso. ");
INSERT INTO kkc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ayo nimapoo taka, bei niba Kelisowo odooga, odoo heeso nimapoo howo keneega, yo nei toowa talaiso. Esiga hagee tei goo.” ");
INSERT INTO kkc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Eseme Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Odoo heeso tei too odoo hee goo tokenee mapoo gido duga, nei odoo heeso o mu mapoo yo toowa bagagoloso howo bou mapoo toosoolai ee dala haga toowanee. Bei, hamamee Godeeye odoo goo egeesi moodeli mapoo dala toowa tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Osoloso nee dee hodio oso no goo tokenee talame gido duga, dee hodio egee kobigi, dee hediliwe badoboso kookaiyo gie badeli talai tekepo. Esino nee dee bakadio sabolo Dou mi mapoo dilei tekeponee. Dou egee koo semili. ");
INSERT INTO kkc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Osoloso nee homo hodio oso no goo tokenee talame gido duga, homo hodio egee kobigi, homo hediliwe badoboso kookaiyo gie badeli talai tekepo. Esino nee homo bakadio sabolo Dou mi mapoo dilei tekeponee. ");
INSERT INTO kkc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Osoloso nee howo hodio oso no goo tokenee talame gido duga, nee howo hodio egee tabigi. Godeeye wiligi doloso badeli omapoo howo hediliwe gadilei tekepo. Esino howo bakadio sabolo Dou mi mapoo toodalai tekeponee. ");
INSERT INTO kkc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bei, mi omapoo ‘boobee egee molo koo wedili osoloso dou koo semili.’ ");
INSERT INTO kkc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Esiga odoo susuga dala toga douso gawe masi gawoolaiso. Bei, Godee yo goomogoso, iba medee tekepo dabalame. ");
INSERT INTO kkc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Solu ee bi tekepo. Esino soluso hadali me poogooga, nayo solu ee see hadalame kasee moodoolaiyo? Esiga niba solu masi molone nemegei dimapoo mesie sabolo debee.” ");
INSERT INTO kkc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu o hamamee dili odoo sabolo Kapeniyum mi poogoloso abaga dino Yudiya mi mapoo peledoboloso, see abaga dino Yoden howo daso. Osoloso omapoo egeino, odoo mooloogoodoo yimapoo sibademe, Yesuye dimapoo Godeeyo goo eyo daga eligi egeesee eligiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eseme Pelisi odoo aboso sibileso Yesuye to tokenee takabeleso, kukulo agalame yimapoo egeesee woosaso, “Edebeeyo sobo huloso wulo goo hee maga osobo pagalai tei molosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eseme Yesuye dimapoo nei egeesee takaso, “Sobo huloso pegeli eyo goo Moseseeye nimapoo tei kasee eligiliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eseme diayo egeesee takaso, “Moseseeye imapoo tei egeesee eligiso, gisoso sobo poogooga, daga sobo pegeli peipa mapoo to hoguguloso sobo yo ka peegeena.” ");
INSERT INTO kkc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Esino Yesuye nei dimapoo egeesee takaso, “Moseseeye egeino, yayo eligi goo mapoo niyo mesilega poogolo neme, bige, sobo pagalai soowa, dee takoloso tei hagee ka magoo. ");
INSERT INTO kkc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Godeeye mipoo hagee daga moodoo biame mapoo, giso sabolo sobo sabolo moodooso. ");
INSERT INTO kkc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Goo egeesi maga gisoso ama dio owee dio poogoloso, see osobo sabolo hedebe doloso dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Osoloso obakadio su hedebe doloso dabalaiso. Esiga diayo debei ee ma kulodu diba bakadio nee, esino diba see olo hedebe doloso ka doso. ");
INSERT INTO kkc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Esiga Godeeye diba hedebe di goo ee see odoo heeso domo na pi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Osoloso hamamee Yesu o hamamee dili odoo sabolo moso kulodu dobolone, sobo huloso pegeli goo maga diayo see tobu Yesu mapoo woosaso. ");
INSERT INTO kkc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eseme Yesuye dimapoo egeesee takaso, “Edebeeyo osobo poogoloso, see sobo hee huga, yo odoo heeyo osobo ee peedee huso. ");
INSERT INTO kkc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Osoloso sobo yo omo poogoloso, see giso hee mapoo obuoga, yo odoo heeyo giso ee peedee huso.” ");
INSERT INTO kkc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Biame hedebeso odoo aboso holaiso Yesu mapoo ido sibadeeso, o deeso sigoloso diba pidilame. Esino o hamamee dili odoo oso goo egee ogoloso hamaga takaso. ");
INSERT INTO kkc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eseme Yesuye o hamamee dili odoo oso holaiso hamaga taka ogoloso, komonolone dimapoo egeesee takaso, “Holaiso amapoo sibilei soowa. Niyo na hamaga takee. Bei, edebeeyo holaiso hageesi masi oso Godeeye wiligi doloso badeli mapoo gasibileiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ayo nimapoo taka, edebeeyo o goo holaiso masi amamo to mapoo mesimo sili, egeesi selega poogoloso, Godee mapoo mesilega poogooga, yo Godeeye wiligi doloso badeli mapoo gasibilei mauwe.” ");
INSERT INTO kkc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Osoloso Yesuye holaiso gilimadoloso, yayo hedebe maduloso o deeso sigolone Godeeye no pidi dee takoo, hedebe maduloso o deeso sigolone Godeeye no pidi dee takoo, diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu o hamamee dili odoo sabolo mi hee mapoo dimeleeno, odoo heeso hoguo sibileso, o homo beiyopoo gauwuloso, yimapoo egeesee takaso, “Eligili odoo tekepo, ayo ogoo goo toga badoboso kookaiyo gie badeli ka talaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eseme Yesu yo Godeeye hudi magoo doloso gooleedalame, yayo nei egeesee takaso, “Bei kasalame nayo a tekepo ka takala? Hedebe Godeeno medee tekepo. ");
INSERT INTO kkc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Esino nayo woosa to eyo nei, Godeeyo tei magoo no olo gooleedooso: odoo na wooloome, adaba kooka sobo sabolo kooka giso sabolo goo heli na te, heli na te, odoo hee mapoo gamenee na gigidi, odoo hee mapoo gamenee goo maga heli na te, osoloso nama dio noowee dio to taka mapoo mesie.” ");
INSERT INTO kkc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eseme odoo ogoso Yesu mapoo egeesee takaso, “Eligili odoo, a holope maga simi tei magoo susuga hagee ayo tobuloso tomo simiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eseme Yesuye sooloo dala sabolo odoo omapoo bolone yimapoo egeesee takaso, “No goo hedebe dooboo dagadi moloso. No dileso, nee bi susuga odoo abo mapoo nei moleeso talame todi. Osoloso bi too eyo nei molee bi mauwe odoo mapoo pi. Nayo egeesee seega, Kei mi ma dokodoo bi tekepo nee hu sabolo mologa agalaiso. Osoloso no a dodomo sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Osoloso bi bei odoo oso Yesuwo to duloso, diya goohele sabolo diso. Bei, yo bi bei doloso badebeiga. ");
INSERT INTO kkc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eseme bi bei odoo dime, Yesuye o hamamee dili odoo mapoo bolone egeesee takaso, “Bi bei odoo oso Godeeye wiligi doloso badeli mapoo gasibilei diya kalawa.” ");
INSERT INTO kkc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesuye to taka duloso diba howoogaso. Esino Yesuye see dimapoo egeesee takaso, “Mo holo dio, Godeeye wiligi doloso badeli mapoo gasibilei diya kalawa. ");
INSERT INTO kkc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Esiga dugo duseli midole ou maga kemol be toowa oso gadilei kalawa. Esino bi bei odoo oso Godeeye wiligi doloso badeli mapoo gasibilei diya kalawa toowa,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eseme o hamamee dili odoo oso yayo eligi goo hagee duloso diya howoogadooso. Osoloso diesono nei woosa nei woosa dolone egeesee takaso, “Goo egee diya kalawadoo. Esiga odoo agayo gie badeli ka talaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eseme Yesuye dimapoo bolone egeesee takaso, “Edebeeyo o gie badeli eyo nediliyo pidilei tebile. Esino Godee yo teiba. Bei, goo susuga yayo moodoolai haga kalawanee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eseme Pitaye Yesu mapoo egeesee takaso, “No ege, iba ibada bi susuga hoogoo poogoloso, nayo di hamamee deedee simiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Esino Yesuye egeesee takaso, “Ayo nimapoo taka, edebeeyo ayo di hamamee sibilame, osoloso to tekepo eyo goo maga, o moso, o emei, o omoo, o omolo, o owee, o ama, o holaiso, osoloso mi poogooga, ");
INSERT INTO kkc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","odoo yayo o bi susuga poogoo eyo nei toowa talaiso. Esiga yo mipoo hamapoo badolone, see moso, emei, omoo, omolo, owee, holaiso, osoloso mi bei malaiso. Osoloso edebeeyo yimapoo dala tenelaiso, bei yayo mo to mapoo mesiliga. Osoloso hamamee yo kookaiyo badoboso gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Esiga odoo abo epedee hamapoo malalo hagee do ee see diba hamamee dabalaiso. Esino odoo abo epedee hamapoo hamamee hagee do oso see malalo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu o hamamee dili odoo sabolo Yelusalem mi mapoo dulone, Yesuye malaso. Esino o hamamee dili odoo goo howoogamo dime, odoo abo hamamee sibadee diya ebigaso. Bei, odoo susuga oso goolee Yelusalem mapoo goo tokenee peledebeyaga. Osoloso Yesuye o hamamee dili odoowe peegoo gilimado dileso dobolone, Yelusalem mapoo gooso yimapoo peledabalai goo ee takolone dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Iba Yelusalem mapoo peledobooga, Odoo Holo, a Yu odoo dia tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo abo mapoo tiasalaiso. Osoloso diayo mo goo midiloso, ayo talai goo ee takalaiso. Osoloso Yu odoonee mapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Diayo a manalaiso, osoloso amapoo makawo pagalaiso, osoloso a tiso dabalaiso, osoloso a wooloomalaiso. Esino biame bakadio hedebe di poogoloso hamamee a ta maga see gie badeli toloso hogadileiso.” ");
INSERT INTO kkc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Osoloso Sebediyo owolo Yemes dio Yonee dio Yesu mapoo sibileso egeesee takaso, “Eligili odoo, goo iyo goomoga namapoo taka,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eseme Yesuye nei egeesee takaso, “Ogoo goowo?” ");
INSERT INTO kkc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eseme diayo nei egeesee takaso, “Nama Godeeye wiligi doloso badeli mi toowa mapoo siboga, iba goomogo, odoo hee nee dee deedee dokolo buo, osoloso hee nee dee dobusu dokolo buo doloso goo susuga nobolo wiligi dalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Esino Yesuye dimapoo nei egeesee takaso, “Niyo egee takoo goo ee niba koo gooleedo. Esiga dala toowa ayo talame egee molo, niba nosee dala egeesee talai teibayo? Osoloso niba ayo talame egee molo, niba egeesee talai teibayo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eseme diayo nei egeesee takaso, “O. Iba teiba,” dee takaso. Eseme Yesuye nei dimapoo egeesee takaso, “Dala toowa ayo talame egee molo, niba dala egeesee talaiso. Osoloso ayo talame egee molo, niba egeesee talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Esino mo dee deedee dokolo dabalai odoo sabolo, osoloso mo dee dobusu dokolo dabalai odoo hesigilei amapoo kitulugu mauwe. Esino hedebe Godeeye hesiga odoo oso mi omapoo dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Osoloso Yesu o hamamee dili odoo abo 10 diayo Yemes dio Yonee dio to taka duloso, dimapoo diya kamanaso. ");
INSERT INTO kkc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eseme Yesuye o hamamee dili odoo gilimadoloso, dimapoo egeesee takaso, “Yu odoonee dia wiligi odoo oso dima hemidu debeli odoo ee diya kitulugu sabolo gidebeliso. ");
INSERT INTO kkc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Esino nima kulodu egeesee selai tekeponee. Esiga nima kulodu edebeeyo toowa doloso badalai goomogoga, yo tou teli odoo masi mesie sabolo odoo abo halo tou tolone ka badebee. ");
INSERT INTO kkc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Osoloso edebeeyo malalo badalai goomogoga, yo tou wulayo teli odoo masi odoo susuga halo tou tolone ka badebee. ");
INSERT INTO kkc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bei, Odoo Holo, ayo mipoo hamapoo simi hagee, edebeeyo a pidilame ka sibile. Esino ayo odoo pidilame ka simi. Osoloso odoo susuga Godee mapoo iyado sibilame a talame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Osoloso diba Yeliko mi mapoo peledoboloso, Yesu o hamamee dili odoo sabolo mi egee poogoloso dimeleeno, odoo mooloogoodoo susuga diayo di hamamee simiso. Eseme odoo howo neliga o hu Batimeyes, Timayes eyo owolo, Yesuye sibilei eli pee mapoo badolone molee howameleeso. ");
INSERT INTO kkc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Esiga Batimeyesye Yesu Nasalet odoo sibogo di duloso, toso neligidi takolone Yesu mapoo egeesee takaso, “Yesu, Deibidiyo amawe, nayo a sooloo dolone a pidiye!” ");
INSERT INTO kkc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eseme odoo aboso yo hamaga takaso. Esino yo koodobilega, see diya neligidi egeesee takaso, “Deibidiyo amawe, nayo a sooloo dolone pidiye!” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eseme Yesuye o to duloso, kookoo toboloso tobudulone egeesee takaso, “Yo hapoo sibe dee takee.” Eseme diayo howo neliga odoo iso, osoloso yimapoo egeesee takaso, “Goomege. No toboloso, di. Yesuye no i,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eseme Batimeyes o gidei togobuloso, saga dokodoo pupeleso, Yesu mapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuye yimapoo egeesee takaso, “No ayo namapoo ogoo goo moodoolai goomogolo?” Eseme howo neliga odoo oso nei egeesee takaso, “Eligili odoo, a see agalai goomogo.” ");
INSERT INTO kkc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eseme Yesuye yimapoo egeesee takaso, “No wulo di. Nee tei too goo oso no tekepo paso.” Eseme howo neliga odoo yo epedee omapoo see medee egeiso, osoloso yo Yesubolo eli maga diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yesu o hamamee dili odoo sabolo Yelusalem mi koola mapoo dulone, Olipi mubi kumoo mosobia bakadio, Betapage osoloso Betani mapoo peledabaso. Osoloso Yesuye o hamamee dili odoo bakadio diye doloso dimapoo egeesee takaso, “Mosobia koogee mapoo dileso, omapoo ogoga be hu gie kauwa donki, edebeeyo wagi ma dokodoo buloso dilega poogoo ee, o mu mapoo ebigiso bagagoloso, omou mapoo bagagoo moloso. Esiga be ee niyo ebigi pidi poogoloso, hapoo hado sibe. ");
INSERT INTO kkc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Egeesi ma kulodu odoo heeso sibileso nimapoo takolone, niba ogoo toowala, dee takooga, niyo nei yimapoo egeesee takee, ‘Lodeeye donki be hagee epedee talai goomogogona, osoloso see hamamee odoo heeso ka hado sibileigo,’ dee takeeye,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu o hamamee dili odoo bakadio mosobia omapoo dileso, donki be moso peegoo ebigi bagagoloso eli palaga tobudume egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eseme diayo donki be ebigi bagagoo pidi meleeno, odoo abo omapoo debei oso dimapoo egeesee takaso, “Niyo ogoo talame donki be ebigi bagagoo egee ka pidala?” ");
INSERT INTO kkc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eseme Yesu o hamamee dili odoo oso to nei Yesuye dimapoo takee doloso taka tobuloso egeesee takaso. Eseme odoo abo oso donki be hado dilei soowa diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eseme diayo donki be Yesu mapoo hado sibume, o wagi mapoo dugo pooloso, Yesu dokodoo buloso diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eseme odoo susuga oso Yesu mapoo goomogolone dia kekeisu dugo tigadoloso, eli Yesuye dilei mapoo malalo palagamo dime, odoo aboso weiyo dibada go mapoo segei kookooloso eli mapoo palagamo diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eseme Yesuye donki be ma dokodoo buloso dimolome, malalo diyadee odoo sabolo osoloso Yesu ma hamamee sibadee odoo oso to neligidi egeesee takaso, “Inolome! Iba Godee mapoo goomogo! Odoo Godeeyo hu maga kitulugu sabolo egee sibo yo Godeeye pidiye dee! ");
INSERT INTO kkc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wiligi doloso badeli mi ee sibo Godeeye pidiye dee. Hagee ibada amawe Deibidiye wiligi doloso badebei mi egeesi masi malaiso. Osoloso iba Kei mi ma dokodoo badeli Godee mapoo goomogo,” dee takomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Osoloso Yesu o hamamee dili odoo sabolo Yelusalem mapoo sibileso, Yesu Yu odoo dia tei moso ma kulodu gadiso. Yo moso kulodu bi susuga mapoo egegemeleso diso. Bei olo neligime, osoloso o hamamee dili odoo 12 sabolo Betani mi mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yesu Betani mapoo tialoso, gesikolo Yelusalem mapoo dimeleeno, eli domopoo yo diya hodiaso. ");
INSERT INTO kkc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eseme Yesu eli sage abaga sibulone, pigi homo du egeiso. Eseme ko pa beleso agalame hodu diso. Esino ko pelega wulo duwe molome egeiso. Bei, pigi ko peli eyo biamenee. ");
INSERT INTO kkc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesuye pigi homo hamapoo egeesee takaso, “No hamamee homokoko see palaime!” Yesuye egeesee taka, o hamamee dili odoo duso. ");
INSERT INTO kkc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu o hamamee dili odoo sabolo Yelusalem mapoo peledoboloso, Yesu Yu odoo dia tei moso ma kulodu gadileso egeino, odoo aboso bi abo nei moleeso talame si sabolo, osoloso odoo aboso bi abo nei moleeso telaga molome egeiso. Osoloso molee piligeli odoo dia debi pooba sabolo bidige buguso. Osoloso molo huyado sibileso nei moleeso teli odoo susuga oso bili pooba sabolo bidege buguloso, diba susuga peegoo hasiso buguso. ");
INSERT INTO kkc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Osoloso odoo susuga bi toloso tei moso tegei eli pee kuloduga gadiyaga Yesuye hamaga takaso. ");
INSERT INTO kkc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yayo dimapoo eligilone egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Mo tei moso ee odoo mosobia susuga maga oso sibileso Godee mapoo takeli moso,’ diso. Esino niyo goo egeesi tolone, adaba molee heli teliso. Esiga niyo Godeeyo moso hagee heli teli odoo oso mada wuli moso paso.” ");
INSERT INTO kkc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Eseme tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo susuga oso to hagee duloso, diayo Yesu wooloomalame eli esigamo silesibiso. Bei, diayo Yesubolo ebiaso, bei diayo eligi mapoo odoo susuga oso tei telega peegeeyaga, osoloso odoo susuga oso Yesuye eligi goo ee duloso howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Osoloso habe omapoo Yesu o hamamee dili odoo sabolo Yelusalem poogoloso diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gesikolodee mapoo diba eli domopoo diyadeega meleeno, diayo pigi homo egeiso. Pigi homo o dee sabolo o kou sabolo, osoloso too susuga sio doloso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita Yesuye daga homo mapoo to taka gooleebuguloso, Yesu mapoo egeesee takaso, “Eligili odoo, no ege. Nayo daga pigi homo mapoo to taka oso olo sio doloso molo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eseme Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Niba Godee mapoo tei te,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Ayo nimapoo taka, edebeeyo mubi hamapoo egeesee takooga, ‘No dileso, abei mapoo kulodu mei,’ dee takooga, o sooloo ma kulodu goo goolee bakadio delega, yayo taka goo oso tei peledabalai dee gooleega, Godeeye goo hagee tei peledabalame moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Esiga ayo nimapoo taka, niyo bi talame Godee mapoo takoloso, see bi egee talai doloso tei toga, bi egee niyo talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Esiga niyo Godee mapoo takolone, odoo heeso nimapoo goo tokenee moodoo mologa, niyo odoo egeeyo goo tokenee daga malalo boobado bigi. Egeeseega nibada Ama Kei mi ma dokodoo egee bado, Godeeye nibada goo tokenee hapoloso boobado bigileiso.  ");
INSERT INTO kkc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Niyo odoo heeyo goo tokenee boobado bigilega poogooga, nei nibada Ama Kei mi ma dokodoo egee bado Godeeye nibada goo tokenee hapoloso boobado bigileime.” ");
INSERT INTO kkc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Diba see Yelusalem mapoo sibadeeso, osoloso Yesu Yu odoowo tei moso ma kulodu sileeme, tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo, osoloso Yu odoo dia wiligi odoo tebisa oso Yesu mapoo sibileso egeesee woosaso, “No agamo kitulugu maga goo hagee ka moodoomo silala? Odoo agayo namapoo kitulugu hagee ka teneeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eseme Yesuye dimapoo nei egeesee takaso, “Ayo woosali to hedebe nimapoo woosalaiso. Osoloso niyo to eyo nei amapoo takooga, ayo kitulugu toloso hagee silo eyo goo ee nimapoo takalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Esiga Yesuye dimapoo egeesee woosaso, “Odoo agayo Yonee mapoo kitulugu ka teneeyo, yayo odoo howo olugulame? Kitulugu Godeeye teneeyo, o, edebeeyo teneeyo? Niyo amapoo to nei takee!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eseme diayo to hagee duloso dieso nediliyo to moulone egeesee takaso, “Iyo kasee takalaisomo? Iyo takolone Yoneeye kitulugu ee Godeeye teneedoo, dee takooga, see nei Yesuye imapoo egeesee takalaiso, ‘Niba bei kaseme Yoneeyo to mapoo tei telega ka poogoowo?’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Esino iyo takolone yayo kitulugu egee odoo maga simi dee takooga, odoo susuga oso imapoo diya kamanalaiso.” Bei, odoo susuga oso goolee Yonee yo tei Godee maga to toloso kokodo takomo sili odoo, dee gweli. ");
INSERT INTO kkc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Egeeseelone diayo nei Yesu mapoo egeesee takaso, “Yoneeye kitulugu too goo eyo bei, iba gooleedele,” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Esiga ayo goo hagee moodoomo silame kitulugu too hagee nimapoo takalaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuye see wudu takolone Yu odoo dia wiligi odoo tebisa mapoo egeesee takaso, “Biame heeso odoo hee o homolee mapoo geleipi ko sogoloso, pee maga beeleeso. Osoloso ko i debilame, yo ou poogoloso, see homolee egee gibadalame doko moso tegeiso. Osoloso yayo homolee bali odoo abo mapoo bameleeye doloso, yo see mi eli sage mapoo badalame diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Osoloso yo omapoo dileso badoboome, homokoko palagaloso olo bi moodoogaso. Eseme yayo o tou teli odoo hee mapoo takolone, o homolee mapoo dileso homokoko egee gooloogaloso o hodio ee yimapoo tosibeye diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Esino yo omapoo dileso peledoboome, homolee bali odoo oso yo woomele poogoloso geleipi ko telega mosoowe see wedi diye diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eseme egeesee ogoloso, homolee eyo amaye see o tou teli odoo hee diye diso. Esino homolee bali odoo oso odoo hagee o wiligi mapoo wooloso, yimapoo ebili goo teneloso see wedi diye diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Eseme homolee eyo amaye o tou teli odoo hee diye diso. Esino homolee bali odoo oso yo wooloomaso. Eseme homolee eyo amaye o tou teli odoo abo susuga diye diso. Esino homolee bali odoo oso abo wulo wooloso poogooso, osoloso abo diayo piliguso. ");
INSERT INTO kkc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Esino yayo gooma owolo hedebe diye dolone egeesee gooleeso, ‘Homolee bali odoo oso mo holowo to duloso, yimapoo mesileiso,’ dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Esino homolee bali odoo diayo homolee eyo amayo owoloye simi ogoloso dieso nediliyo egeesee takaga meleeso, ‘Holo hagoso hamamee ama toga, yayo geleipi ko segei hagee talaiso. Esiga geleipi ko segei hagee see iyo talame yo wooloomamo,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eseme diayo homolee eyo amayo owolo toloso wooloomaso. Osoloso o kou homolee maga peegoo togobuguso.” ");
INSERT INTO kkc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesuye to hagee taka koodobuloso badolone, o to dulone debei odoo mapoo egeesee takaso, “Esiga homolee eyo amaye see kasee moodoolaisomo? Yayo sibileso homolee bali odoo piliguloso, see homolee bali odoo abo mapoo beye dalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Esiga niba Godeeyo to booka mapoo hogugu hagee hesigeleyo? Bei, omapoo egeesee takooso, ‘Moso tegeli odoo diayo omou gowoolone togobugu oso epedee hamapoo moso omu domo pupodoo ka moloso. ");
INSERT INTO kkc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Goo hagee Godeeye ka moodoo. Esiga iba goo hagee ogoloso howoodolone tekepo deeso.’” ");
INSERT INTO kkc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eseme Yu odoo dia wiligi odoo tebisa oso Yesuye wudu taka goo ee duloso, “Ibada goo takolone bado,” doloso egeesee gooleeso. Egeeseelone diayo Yesu talai eli esigamo silesibiso. Esino diba odoo mooloogoodoo toowa ogoloso, diayo yo talai ebigaso. Esiga Yesu telega poogoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Osoloso hamamee Yu odoo dia wiligi odoo tebisa oso Yesuye Loum gamalee mapoo goo tokenee abo takalame gooleeso. Eseme diayo Pelisi odoo abo sabolo Helodeeyo hamamee dili odoo abo sabolo Yesu mapoo gamenee takalame diye diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eseme odoo egee bia oso dileso Yesu mapoo egeesee takaso, “Eligili odoo, iba gooleedooso, no tei goo takeli odoo. Osoloso no odoo bolo koo ebili, osoloso nayo odoo kolo mapoo koo egeli. Osoloso nayo Godeeyo goo odoo susuga mapoo tei eligi moloso. Esiga Loum gamalee wiligi odoo Sisa mapoo tekisi molee tenelai tekepowo, o, tokeneeyo? ");
INSERT INTO kkc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iyo tenelaisomo, o, tenelaimeyo?” dee takaso. Esino Yesuye diayo goo tokenee moodoolame to mou goo ee, yo olo gooleedoloso dimapoo egeesee takaso, “Bei kasi maga niyo a kukulo agalame ka sala? Niba molee ko hedebe a agalaiya tosibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eseme diayo Yesu mapoo molee ko hedebe tosibileso teneme, yayo dimapoo egeesee takaso, “Molee hamapoo agamo mudu sabolo osoloso agamo hu oso ka mololo?” Eseme diayo nei yimapoo egeesee takaso, “Sisayo mudu sabolo, osoloso o hu oso ka molo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo Sisayo bi ee Sisa mapoo tenee. Osoloso Godeeyo bi ee Godee mapoo tenee,” diso. Eseme diba to hagee duloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Osoloso Sedisi odoo aboso Yesuye badebei mapoo sibadeeso. Odoo hagee bia oso takolone, “Odoo wedia see hogabileime,” dee takeliso. Eseme diayo Yesu mapoo sibileso egeesee woosaso, ");
INSERT INTO kkc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Eligili odoo, tei magoo Moseseeye hogugu oso imapoo egeesee takooso, ‘Gisoso sobo huloso holo soomagelega toga, see omoloye emei tayo osobo bau ee huloso emeiyo hu maga holo soolooga magee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Esiga odoo heeso giso holo 7 soomagooso. Osoloso daga emeiye sobo huso. Osoloso yo holo soomagelega taso. ");
INSERT INTO kkc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eseme omolo yima hamamee soomagoo oso emeiyo osobo bau ee huso. Esino yo holo soomagelega taso. Eseme see omolo yima hamamee soomagoo oso emeiyo osobo bau ee huso. Esino yinosee holo soomagelega taso. ");
INSERT INTO kkc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Egeeseelone giso holo 7 susuga hagee bia oso holo soolooga magelega wediaso. Osoloso hamameedee sobo bau yinosee taso. ");
INSERT INTO kkc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Esiga odoo wedia maga see hogogadilei biame mapoo sobo egee tei odoo agamo osobo dalaisomo? Bei, giso 7 oso sobo hedebe hagee huso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eseme Yesuye nei dimapoo egeesee takaso, “Niba goo dooboo gweli odoo. Bei, niba Godeeye kitulugu sabolo osoloso o to sabolo gooleedelega ka doso. ");
INSERT INTO kkc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bei, odoo wedia ee bi maga see hogogabuoga, diba see sobo huleime, osoloso giso obileime. Esino diba see Godeeyo momaiye oso Kei mi mapoo egee do egeesi masi dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Esiga Moseseeye odoo wedia see hogogadilei goo ee o book mapoo hogugu, niyo hesigeleyo? Eibalaham, Aisek, osoloso Yekob olo taso. Esino homo douso nademe, paiya biame omapoo Godeeye Moses mapoo egeesee takaso, ‘Epedee hamapoo a Eibalahameeyo Godee, Aisekeeyo Godee, osoloso Yekobowo Godee doloso ka badoso,’ diso. Odoo hagee wediaso, esino dibada dio oso epedee hamapoo gie doso. ");
INSERT INTO kkc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Esiga Godee hagee odoo wedia eyo Godeenee. Haye, odoo gie egee do eyo Godee. Esino niyo odoo toloso see gie badeli talaime dee gooleega, niba goo dooboo gweli odooso.” ");
INSERT INTO kkc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tei eligili odoo hee diayo toso agadigamelee omapoo sibileso badolone dumeleeso. Osoloso Yesuye Sedisi odoo mapoo to nei tekepo taka duloso, yayo Yesu mapoo egeesee woosaso, “Tei magoo kaso diya toowa ka molosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eseme Yesuye nei egeesee takaso, “Tei magoo toowa hagoso, ‘Isalael odoo niba dui! Ibada wiligi odoo Godee hedebe. ");
INSERT INTO kkc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Esiga nayo nee wiligi odoo Godee diya goolee, nee sooloo ma kuloduga goolee sabolo, osoloso nee dioso goolee sabolo, osoloso nayo goo goolee sabolo, osoloso nayo kitulugu oso diya goolee.’ ");
INSERT INTO kkc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Osoloso tei magoo toowa hee hagoso: ‘Nayo no nediliyo diya egee goolee, egeesee goolone nee odoo nosee diya egeesee goolee.’ Tei magoo toowa aboso, tei bakadio hagee dagadile,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eseme tei eligili odoo ogoso see Yesu mapoo egeesee takaso, “Eligili odoo, nayo tei goo olo takaso. Esiga Godee hedebe badoso, Godee hee mauwe. ");
INSERT INTO kkc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Esiga gala hu wooloso dou mapoo siloso Godee mapoo teneli sabolo, bi abo teneli sabolo, tei oso taka hagee haga goo toowanee. Esino tei magoo bakadio hagoso goo toowa ka moloso: Nayo Godee diya goolee, nee sooloo ma kuloduga goolee sabolo, osoloso nayo goo goolee sabolo, osoloso nayo kitulugu oso, diya goolee. Osoloso nayo no nediliyo diya egee goolee, egeesee goolone nee odoo nosee diya egeesee goolee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eseme Yesuye odoo ogoso to nei tekepo taka duloso yimapoo egeesee takaso, “No Godeeye wiligi doloso badeli mapoo gasibilei koola bado,” diso. Eseme odoo aboso goo abo Yesu mapoo woosalai obulone yimapoo hee woosele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hamamee Yesuye Yu odoo dia tei moso tegei ma kulodu odoo susuga mapoo eligilone yayo egeesee woosaso, “Bei kasi maga tei eligili odoo diayo Keliso ee Deibidiyo amawe, dee ka takeliyo? ");
INSERT INTO kkc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deibidiye to kitulugu sabolo Dio Tei maga egeesee takaso, ‘Godeeye mo Lodee mapoo egeesee takaso: “No abolo wiligi doloso badalame mo dee deedee dokolo bie. Esiga nayo badolone namapoo ha teli odoo ee ayo dagadileiso,” diso.’ ");
INSERT INTO kkc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deibidiye Keliso o Lodee diso. Esiga bei kasi maga tei eligili odoo diayo ‘Keliso Deibidiyo amawe’ dee ka takeliyo? Kelisoye Lodee osoloso Deibidiyo amawe dalai teibayo? O, Keliso yo Lodee osoloso yo Deibidiyo amawe oso.” Odoo susuga goomogolone o to mapoo medee duso. ");
INSERT INTO kkc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuye odoo susuga mapoo eligilone egeesee takaso, “Niba tei eligili odoo mapoo medee ege. Diba dugo medee tekepo megigaloso silesibiliso, osoloso bi neiso teli go mapoo debeli odoo oso diba ogoloso gauwuloso emegei di to takooga ee dulei onosee diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Diba howo gisili moso ma kulodu wiligi odoo taba eyo debi mapoo bulumulame, osoloso wo toowa nologolone debei mi mapoo wiligi odoo toowa taba eyo debi mapoo bulumulame goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Esino diayo sobo bauwe ebilame gamenee takoloso, dia moso sabolo bi sabolo diayo toloso omapoo dobolone, dia goo gagaloso Godee mapoo taka diya sageliso, odoo aboso diba tekepo odoo dee goolame. Esiga goo egeesi maga diba nei dala toowa talaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu tei moso tegei kulodu edebeeyo emegei di molee tooseli ki bi oso moodoo mapoo sooloogamelee koola mapoo badolone odoo susuga bameleeso. Bi bei odoo oso molee ko toowa sooso. ");
INSERT INTO kkc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Osoloso sobo bau bi mauwe oso sibileso molee ko ta bakadio toosooso. ");
INSERT INTO kkc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eseme Yesu o hamamee dili odoo gilimadoloso dimapoo egeesee takaso, “Ayo nimapoo taka, sobo bau bi mauwe hagoso tenee oso odoo abo susuga oso tenee ee dagadiso. ");
INSERT INTO kkc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bei, bi bei odoo dia molee toowa osee molome molee su pepooko teneeso. Esino sobo bau bi mauwe hagee yimapoo molee ko esiesibo meleeno teneeso. Esiga yo wo talai molee olo mauwe.” ");
INSERT INTO kkc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Biame omapoo Yesu tei moso poogoo dileso dimolome, o hamamee dili odoo heeso sibileso yimapoo egeesee takaso, “Eligili odoo, ibada tei moso yoso tegei medee tekepo hagee, no ege, osoloso yo toowa medee tekepo, no ege,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eseme Yesuye to nei yimapoo egeesee takaso, “Tei moso tekepo tegei epedee no hagee ogo, hamamee guobigileiso, eseega yo hedebeso yo hee ma tobudoo malaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Osoloso Yesu Olipi mubi ma dokodoo peleso, tei moso tegei ma hodiokoo bolone badoboome, Pita, Yemes, Yonee, osoloso Endulu diayo dibusomo sibileso yimapoo egeesee woosaso, ");
INSERT INTO kkc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nayo imapoo takee, goo susuga hagoso kopolone ka peledabalaiyo? Osoloso goo susuga hagoso peledabalame mologa, ogoo gooso imapoo ka eligileiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eseme Yesuye dimapoo to nei egeesee takaso, “Niba obeeyamo! Odoo heeso tei goodee maga niba peegoo gilimado diyaga. ");
INSERT INTO kkc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Odoo aboso mo hu maga sibileso takolone, dieso nediliyo diba Kelisoso, dee takalaiso. Egeeseelone diayo odoo bei tei goo maga peegoo gilimado dileiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Esiga ha too goo sabolo osoloso biliga goo oso peledoboomo duga goo ee duloso, niba haga na ebi. Bei, goo hageesi oso daga malalo peledabalaiso. Esino biame egee hoo poogoo osonee, hamamee sibileiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Osoloso mi toowa heeso mi toowa hee mapoo ha talaiso. Osoloso mi susuga mapoo mibia toowa sibileiso. Osoloso nei me pagalaiso. Esino goo susuga hagoso peledobooga, dala biame oso bei mooloogolone ka seeso. ");
INSERT INTO kkc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Esiga goo susuga hagoso peledobooga, niba obeeyamo. Edebeeyo niba toloso goo midili moso mapoo ido polo dolone dabalaiso. Osoloso niba dibada howo gisili moso mapoo ido peleso wooloogolone dabalaiso. Osoloso amapoo tei too goo maga niba gamalee wiligi odoo tebisa sabolo, osoloso wiligi odoo toowa tebisa abo dia mudugiyopoo gilimado peleso, niyo mo goo ee dimapoo takalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mi hoo pagalai hoogoo mologa, to tekepo hagee daga edebeeyo mi susuga mapoo takomo dileiso, odoo susuga oso to tekepo ee dulame. ");
INSERT INTO kkc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Osoloso edebeeyo niba goo midili moso mapoo ido pologa, niyo takalai goo ee haga na goolee. Bei, biame omapoo niyo takalai goo goolee tekepo ee nimapoo Godeeye tenelaiso. Esino niba niso goolee takalaime, Dio Tei oso nibolo toboloso to ka takalai. ");
INSERT INTO kkc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Biame omapoo edebeeyo emei dio omolo dio wooloomalame, diba goweli odoo mapoo tiasalaiso. Osoloso amaye owolo mapoo egeesee selaiso. Osoloso owoloye dibada ama dio owee dio mapoo mesilega poogoloso diba wooloomalame tiasalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bei niyo amapoo tei too goo omaga odoo susuga oso nimapoo heiga toowa malaiso. Esino edebeeyo eyo tei too kibiloso badolone, hoo poogoo mapoo dileso peledobooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Hesigeli odoo, no to hageeyo bei medee gooleede.) Niba bi diya tokenee mudu opusomo di oso tei moso ma kulodu molo agalaiso. Esiga bi ogoso Godeeyo howo woola tei moso tokenee palaiso. Egeeseega Yudiya mi toowa mapoo debeli odoo oso bi mudu opusomo di ee ogoga mubi ma dokodoo kukulo pele. ");
INSERT INTO kkc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Osoloso odoo moso hau mapoo badoga, bi talame moso kulodu na gadi. ");
INSERT INTO kkc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Osoloso odoo homolee mapoo nei howo sogomo siloga, o gidei talame mosopoo see na wedi di. ");
INSERT INTO kkc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Osoloso biame omapoo sobo koowasi sabolo, osoloso holope too nedili sobo ee kukulo dilei diya kalawa toowa molo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Esiga Godee mapoo takee, goo hagoso wau biame mapoo peledebelega pagalame. ");
INSERT INTO kkc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bei, biame omapoo dala toowa oso sibileiso. Esiga mi toowa bei mooloogoo biame abaga simino epedee hamapoo, odoo susuga oso dala goo hageesi egele. Esino dala goo toowa hagoso sibileso koodobuoga, hamamee dala goo hageesi see agalaime. ");
INSERT INTO kkc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Esiga Godeeye dala biame deiyepo moodoolaiso. Esino yayo biame sage magoo diepi, odoo heeso dala ee ma kulodu badalai tebile pegeliyo. Esino dala ee ma kulodu Godee eyo hesiga odoo ee halo, yayo dala biame see deiyepo moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Biame omapoo odoo heeso sibileso nimapoo takolone, ‘Hamapoo ege, Keliso hagoso’ o, ‘Koo ege, Keliso ogoso,’ dee takooga, o to mapoo tei na te. ");
INSERT INTO kkc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bei, gamenee keliso deli sabolo, osoloso gamenee godee maga to toloso kokodo takomo sili odoo oso sibileso goo toowa opusomo di edebeeyo howeli moodoolaiso, odoo susuga sabolo osoloso odoo Godeeye hesiga oso peegoo dia beleso kukulo agalame. ");
INSERT INTO kkc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Esiga niba obeeyamo! Goo hagee peledebelega mologa, ayo daga goo susuga nimapoo ka taka.” ");
INSERT INTO kkc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Osoloso hamamee, biame omapoo dala goo hagoso dileso koodobuoga, ‘osoko semelaiso. Egeeseega a nosee gadeebigileime. ");
INSERT INTO kkc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Osoloso giwo kei ma dokodoo egee molo mi hamapoo tigedibileiso. Osoloso kei ma dokodoo kitulugu bi egee molo Godeeye halabuga ki me pagalaiso.’ ");
INSERT INTO kkc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Biame omapoo odoo susuga oso Odoo Holo, ayo kolobo maga gadeebugu sabolo, osoloso kitulugu toowa sabolo siboga agalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Osoloso ayo sibileso, mo momaiye diye dalaiso, diayo dileso odoo susuga Godeeye hesiga mi susuga mapoo egee do ee gilimalame. ");
INSERT INTO kkc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Esiga niba sogai maga goo hagee medee gooleede. Sogai du pisigaga ogoloso, wau biame koola tooboo doloso gooleedeliso. ");
INSERT INTO kkc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Esiga goo hagee egeesi masi moloso. Goo ayo taka hagoso peledaba ogoga, Odoo Holo ayo sibilei olo koola tooboo doloso niba olo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ayo nimapoo taka, epedee biame hamapoo odoo hagee do wedilega doga, goo susuga hagoso peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kei sabolo mipoo sabolo mauwe pagalaiso. Esino mo to kookaiyo moloso osee malaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Esiga Odoo Holo ayo sibilei biame ee odoo hee gooleedele. Osoloso Godeeyo momaiye Kei mi ma dokodoo egee do sabolo osoloso Godeeyo owolo anosee gooleedele. Esino hedebe mo Ma Godeeye biame egee gooleedoloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Esiga niba medee koolone ka debee. Bei, biame ogoso sibilei ee niba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Odoo Holo, ayo sibilei goo ee egeesi moloso. Odoo heeso mi hee mapoo dulone, o tou teli odoo mapoo moso hagee medee bameleeye, dee takoloso dileiso. Osoloso yayo tou teli odoo mapoo moso egee bamalame, tou opusomo opusomo di pileiso. Osoloso osulu gibalai odoo mapoo yayo see wedi sibilei maga egeesee takalaiso, ‘Medee be!’ ");
INSERT INTO kkc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Esiga mosowo ama masi aso. Esiga niba mopoodoo doloso koolone ka debee. Bei, ayo sibilei biame ee niba gooleedele. Habe sibumobelee, o gesi domo sibumobelee, o kudi takooga sibumobelee, o gesikolodee sibumobelee. ");
INSERT INTO kkc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Osoloso ayo saga sibileso ogoga, niba tiesa molo agalai tekeponee. ");
INSERT INTO kkc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ayo nimapoo to taka see odoo susuga mapoo takooso, niba mopoodoo doloso, koolone ka debee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Osoloso Godeeye Gababia wo nalai sabolo osoloso wo mosoowe nalai biame bakadio hoogoo meleeso. Eseme tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo diayo Yesu toloso mada wooloomalame eli esiamo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Esino diayo dieso nediliyo egeesee takaso, “Iyo Gababia wo ne biame hamapoo yo toloso wooloomalaime. Bei, odoo susuga oso imapoo kamanaloso ibolo biligiyaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Betani mi mapoo badolone, odoo daga agagisa bia Yesuye tekepo pa Saimonowo moso mapoo palaso. Yo omapoo nei nolone badoboome, sobo heeso mai masi pepooko yo alabasta deli oso moodoo mapoo mopoodoo soo medee tekepo nad deli i salama soo tosimiso. Yayo tosibileso, me gooboo buguloso Yesuwo wiligi mapoo sooso. ");
INSERT INTO kkc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eseme odoo abo omapoo debei oso ogoloso komonolone dieso nediliyo egeesee woosagaso, “Bei kasalame sobo hagoso mopooodoo soo medee tekepo ee wulo goo mauwe yimapoo soomeleso ka hosudoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Yayo mopoodoo soo medee tekepo hagee odoo mapoo neiso talame tenee diepi, molee ko 300 ee toloso bi mauwe odoo mapoo tenelai tebiliyo.” Diayo dee takoloso, sobo yimapoo kamanaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eseme Yesuye dimapoo egeesee takaso, “Yimapoo egeesee na takee. Bei kasi maga niyo yimapoo kamanaloso ka takala? Yayo amapoo goo tekepo moodooso. ");
INSERT INTO kkc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Esiga bi mauwe odoo ee biame susuga nibolo hodobo dabalaiso. Esiga niyo diba gooleebuguga, diba biso pidilei tekepo. Esino biame susuga a nibolo hobobo badalaime. ");
INSERT INTO kkc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Esiga sobo hagoso yayo moodoolai dee goolee goo ee amapoo moodooso. Yayo mopoodoo soo egee mo wiligi mapoo soo oso mo suso bi ma kulodu malai ee mopoodoo doo. ");
INSERT INTO kkc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ayo nimapoo ka taka. Edebeeyo mi kamapoo Godeeyo to tekepo takooga, diayo sobo hagoso goo amapoo moodoo onosee takalaiso. Osoloso edebeeyo o goo onosee goolee malaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Osoloso Yesu o hamamee dili 12 ee ma kulodu odoo hee Yudas-Iskaliyot yayo tei moso wiligi odoo tebisa mapoo dileso Yesu dimapoo tiasalame diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eseme diayo o goo duloso, diya goomogolone yimapoo molee nei tenelame to takoloso edidi magooso. Eseme Yudaseeye Yesu dimapoo tiasalame eli esiamo silone biame tekepo bameleeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isipi mi maga peegoo di gooleebugu wo ne bei mooloogoo biame mapoo, Yu odooso Godeeye Gababia wo nalame, sipi be hu weliso. Eseme Yesuwo hamamee dili odoo oso Yesu mapoo egeesee woosaso, “Nayo iba kamapoo dileso Godeeye Gababia wo nalai mopoodoo dalai ka goomogolo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eseme Yesu o hamamee dili odoo bakadio diye dolone egeesee takaso, “Niba Yelusalem mi mapoo diyadee. Osoloso niba omapoo dileso ogoga odoo hee howo keedoloso eli domopoo dumologa tugodalaiso. Niba yo tugodoloso yo deedee di. ");
INSERT INTO kkc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Osoloso niba yayo dileso moso kulodu gaduga omapoo dobolone, mosowo ama mapoo egeesee takee, ‘Eligili odoo oso egeesee taka, “Ayo mo hamamee dili odoo gilimadoloso, Godeeye gababia wo nalame debi pooba gooboogoo kasomo?” ’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Osoloso yayo niba moso dokohodoo ido peleso debi pooba gooboogoo toowa olo moodoo doloso melee eligileiso. Esiga niba iyo Godeeye Gababia wo nalai omapoo ka mopoodoo de,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eseme Yesu o hamamee dili odoo bakadio oso Yelusalem mi mapoo diyadeeso. Diba omapoo dileso egeino, goo susuga ee Yesuye dimapoo taka goo sabolo tobuloso molome egeiso. Eseme diayo Godeeye Gababia wo nalame omapoo mopoodoo doloso, diba see Yesuye o hamamee dili odoo abo sabolo debei mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Osoloso habedee mapoo Yesu o hamamee dili 12 sabolo sibileso moso omapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Diba omapoo wo nolone doboome, Yesuye dimapoo egeesee takaso, “Ayo nimapoo taka, nima kuloduga odoo hee abolo wo hagee namolo oso a ha teli odoo mapoo tiasalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eseme Yesu o hamamee dili odoo oso to hagee duloso, goohele sabolo dobolone, Yesu mapoo egeesee takaso, “Ayonee, o ayowo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eseme yayo dimapoo nei takaso, “Odoo 12 mooloogoodoo hagee ma kulodu, odoo agayo mo peleta mapoo abolo hodobo wo olugudoloso naga, a ha teli mapoo tiasalai odoo ogoso. ");
INSERT INTO kkc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Esiga Godeeyo to booka mapoo hogugu oso taka ee dodolone, Odoo Holo a talaiso. Esino Odoo Holo a ha teli odoo mapoo tiaseli odoo yo dala toowa talaiso. Oweeye yo soomagelega poogoo diepi, yo dala tele pegeliyo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Diba wo nolone doboome, Yesuye wo toloso Godee mapoo goomoga to takoloso wo popeiso. Osoloso o hamamee dili odoo mapoo wo pulone egeesee takaso, “Wo hagee toloso ne. Hagee mo suso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Osoloso yo see kapu wain i keesoo toloso, Godee mapoo goomoga to takoloso, dimapoo teneme, diayo susuga wain i neso. ");
INSERT INTO kkc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Eseme Yesuye see egeesee takaso, “Hagee mo sawo, odoo susuga dia tokenee hapalame ka sologo bugu. Mo sawo oso Godeeye o odoo mapoo to kitulugu magoo goo oso tei peledabalame. ");
INSERT INTO kkc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Esiga ayo nimapoo taka. Ayo epedee hamaga dulone wain i see nalaime. Esino hamamee Godeeye wiligi doloso badeli mi mapoo wain i dia see nalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Osoloso diba goomoga kosaiya hedebe pouloso, see Olipi mubi dokodoo paladeeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Eseme Yesuye see o hamamee dili odoo mapoo egeesee takaso, “Odoo susuga niyo a poogoloso kukulo dileiso. Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Godeeye sipi be bali odoo ee wooloomaga, sipi be susuga oso yimaga peegoo kukulo dileiso.’” ");
INSERT INTO kkc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Osoloso Yesuye see egeesee takaso, “Esino a ta maga hogado dileso, ayo daga malalo dileso Gelili mi mapoo niba tugodalaiso.” ");
INSERT INTO kkc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eseme Pitaye nei Yesu mapoo egeesee takaso, “Odoo susuga oso namaga peegoo kukulo duga, hedebe ayo no poogoo dileime.” ");
INSERT INTO kkc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Esino Yesuye yimapoo see egeesee takaso, “Ayo namapoo tei goo taka. Epei gesi kolokoloso taka bakadio delega, malalo hoogoo mologa, nayo mo goo gagadilei ee bakadio hedebe dalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Esino Pitaye to kitulugu sabolo nei egeesee takaso, “Ayo egeesee selaime! Edebeeyo no wooloomaga, a nobolo hodobo talaiso,” diso. Eseme Yesuwo hamamee dili odoo susuga oso to hedebe egeesee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Osoloso Yesu o hamamee dili odoo sabolo Getesemeni olipi homo segei homolee omapoo sibadeeso. Osoloso Yesuye o hamamee dili odoo dimapoo egeesee takaso, “A dileso Godee mapoo takalaiya, niba hamapoo debee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Osoloso yayo egeesee takoloso, hedebe Pita, Yemes osoloso Yonee esee ido palaso. Yo peleso badoboome, goohele goo sabolo osoloso su hegi goo oso yimapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Osoloso yayo dimapoo egeesee takaso, “Mo su ma kulodu hegi goo toowa oso molone, ayo talai olo koola tooboo. Esiga niba hamapoo koolone debee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Osoloso Yesu egeesee takoloso, dimaga pepooko hoogoo dileso, ebiso miyomoo tugusaloso balaboo tialoso molone Godee mapoo takaso, yimapoo dala toowa egee sibo ee Godeeye peegoo magalame. ");
INSERT INTO kkc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yayo Godee mapoo takolone egeesee takaso, “Ma, mo Ma! Goo susuga namapoo kalawanee. Esiga dala toowa oso amapoo hagee sibo, nayo peegoo magalai soowayo? Esino nayo goomoga goo moodee, ayo goomoga goonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Osoloso yo Godee mapoo taka koodobuloso wedi dileso egeino, o hamamee dili odoo bakadio hedebe di tiesamolome egeiso. Eseme yayo Pita mapoo egeesee takaso, “Saimon, no tiayo? No biame deiyepo hamapoo abolo hodobo koolone badalai tebiledo? ");
INSERT INTO kkc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Esiga niba bolone Godee mapoo takolone ka debee, niba kukuli goo mapoo homodobiyaga. Bei nibada goo goolee oso goo tekepo talame goomogoso, esino nibada su oso ki me ka poogooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Osoloso yo see wedi dileso, Godee mapoo takolone goo hedebe onosee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Osoloso yo see dimapoo wedi sibileso egeino, diba tiesa molome egeiso, bei diba tila paga oso howo seme. Osoloso diayo Yesu mapoo to nei takalai gooleedele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu yo see bakadio hedebe di mapoo Godee mapoo takoloso, o hamamee dili odoo mapoo wedi sibileso, dimapoo egeesee takaso, “Niba hosolone wulo tiesa malala? Tia olo oso! Odoo Holo, a tokenee odoo mapoo toloso tenelai biame olo epedee hamapoo sibo. ");
INSERT INTO kkc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Esiga koo ege, a tokenee odoo mapoo tiasalai odoo ee olo sibo. Esiga niba tebise, dimapoo dimo!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu to osee komolome, o hamamee dili odoo hee Yudaseeye Yesu talame odoo mooloogoodoo toowa gilimado simiso. Egeesi ma kulodu tei moso wiligi odoo tebisa sabolo, tei eligili odoo tebisa sabolo, osoloso Yu odoowo wiligi odoo tebisa oso Yesu talame odoo hagee bia diye diso. Eseme diayo sibulone kaiya sabolo kodolo sabolo toloso sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Egeesi ma kulodu Yudas yo epedee sibilega badolone, odoo Yesu talai mapoo egeesee takaso, “Ayo dileso adaga, odoo ogoso. Eseega niyo yo toloso medee bolone ka ido di,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Osoloso Yudas yo odoo mooloogoodoo poogoloso dileso, Yesuye tebidi mapoo hoogoo dileso, yayo egeesee takaso, “Eligili odoo!” dee takoloso, Yesu adaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eseme odoo abo oso sibileso Yesu tooso. ");
INSERT INTO kkc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Esino Yesu o hamamee dili odoo hee koola omapoo tebidi oso o kaiya tadoloso, tei moso wiligi odoo taba eyo tou teli odoo kaiyaso woomeleso eyo dooboo poogoome, dulu asooso. ");
INSERT INTO kkc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eseme Yesuye yo talame sibadee odoo omapoo egeesee takaso, “Niyo ogoga a mesiya daga, a talame kaiya sabolo osoloso kodolo sabolo misigaloso ka sibadala? ");
INSERT INTO kkc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Esino ayo biame susuga tei moso ma kulodu eligimo sileeme, niyo a egeliso. Esiga bei kaseme niyo a omapoo telega ka poogoowo? Esino niyo epei a talame simi hagoso Godeeyo to booka mapoo hogugu oso taka to sabolo olo tobuoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eseme Yesu o hamamee dili odoo susuga oso yo poogoloso kukulo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Osoloso odoo gie kauwa dugo booloso, Yesu diayo toloso dime hamamee deedee diso. Eseme diayo yo ogoloso, yibolo talame o dugo mapoo temeleso, o dugo puobuguso. ");
INSERT INTO kkc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Esino o dugo dimapoo yane poogoloso, yo boodo diwe piaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Osoloso diayo Yesu toloso tei moso wiligi odoo taba eyo mosopoo ido diso. Esiga moso ee ma kulodu tei moso wiligi odoo tebisa sabolo, Yu odoowo wiligi odoo tebisa sabolo, osoloso tei eligili odoo oso daga olo mooloogoodoloso debeiso. ");
INSERT INTO kkc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Eseme Pitaye hamameedee Yesu deedee dileso, tei moso wiligi eyo moso eyo beelee ma kulodu gadiso. Yo omapoo badolone, tei moso gidebeli odoo sabolo kekeisime dou hameleeso. ");
INSERT INTO kkc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Eseme tei moso wiligi odoo tebisa sabolo, osoloso Yu odoo dia goo midili wiligi tebisa oso Yesuwo goo maga gamenee takeli odoo ee esiaso, yimapoo goo tokenee hee mologa, Yesu ka wooloomalame. Egeeseelone edebeeyo wulo gamenee takolone Yesuwo goo maga goo opusomo opusomo di takaso. Esino diayo taka ee ma kulodu, tei goo hee molo egele. ");
INSERT INTO kkc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Esino odoo aboso tebisaloso, Yesuwo goo maga gamenee egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Iba odoo hagoso egeesee takeme duso, ‘Edebeeyo tei moso tegei hagee ayo guobuguloso, see biame bakadio hedebe di ee ma kulodu tei moso dia tegelaiso. Esino edebeeyo tegelaime,’ yayo dee takeme duso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Esino diayo to opusomo opusomo di taka ee ma kulodu tei goo egele. ");
INSERT INTO kkc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eseme tei moso wiligi odoo taba oso odoo susuga mooloogoodoo ma kuloduga toboloso Yesu mapoo egeesee woosaso, “Odoo hagee biaso nee goo maga goo opusomo opusomo di egee takoo mapoo nayo to eyo nei takalaimeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Esino Yesuye to nei takele poogooso. Eseme tei moso wiligi odoo taba oso to see Yesu mapoo egeesee woosaso, “No Godeeyo owolo, Kelisosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eseme Yesuye to nei egeesee takaso, “O, aso. Esiga hamamee Odoo Holo, a Kitulugu Godeeyo dee deedee dokolo mapoo buloso yibolo wiligi doloso badoga niyo agalaiso, osoloso Kei mi ma dokodooga, kolobo ma kuloduga see wedi siboga niyo agalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eseme tei moso wiligi odoo taba oso to hagee duloso, diya komonolone o dugo tologo buguloso egeesee takaso, “Iyo o goo see midilame to abo taka ee dulei koo goomogo. ");
INSERT INTO kkc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bei yayo ‘a Godeeyo owolo oso’ dee taka maga, yayo Godee mapoo mesilega osoloso ebilega to tokenee taka, niyo olo duso. Esiga niyo goolee yimapoo ogoo goo moodoolaiyo?” diso. Eseme Yu odoo dia wiligi odoo tebisa susuga oso egeesee takaso, “Yesu diya tokenee odoo, esiga yo wooloomalai tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eseme odoo aboso Yesu mapoo makawo pagaso. Osoloso diayo o howo dugoso gagaloso, dibada dee tiadoo oso woolone yimapoo egeesee takaso, “Keliso, no tei Godee maga to toloso kokodo takomo sili odoo daga, no odoo agayo woolo?” dee takaga meleeso. Osoloso tei moso gidebeli odoo oso yo ido dulone woomodiso. ");
INSERT INTO kkc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Osoloso Pita yo tei moso wiligi odoo taba eyo moso beelee ma kulodu kekeisime dou holone badebeiso. Eseme tei moso wiligi odoo taba o tou teli sobo heeso sibileso yimapoo medee bolone, egeesee takaso, “No nosee Nasalet odoo Yesubolo silee odoo hee noso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eseme Pitaye sobo yimapoo gamenee egeesee takaso, “Nayo egee takoo eyo goo ee, a gooleedele,” diso. Osoloso Pita yayo egeesee takoloso, moso beelee osulu gasibili pee mapoo diso. Eseme kolokolo takaso. ");
INSERT INTO kkc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Osoloso tei moso wiligi odoo taba eyo tou teli sobo hagoso Pita see omapoo tebidi ogoloso, yayo odoo abo omapoo tebisamelee mapoo egeesee takaso, “Odoo hagee tei Yesubolo sili hee yoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eseme Pitaye see egeesee takaso, “Haye! Asonee,” diso. Eseme diba pepooko doboso hamamee, odoo abo koola omapoo tebisamelee oso Pita mapoo see egeesee takaso, “Bei no Gelili odoo osoloso Yesu sabolo Gelili odoo, esiga no Yesubolo sili odoo hee noso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Eseme Pitaye to kitulugu sabolo egeesee takaso, “Ayo tei goo takelega poogooga, Godeeye amapoo dala toowa tenelai goomogo! Niyo odoo egee takoo a gooleedele!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Osoloso Pita yo egeesee takoloso epedee omapoo, kolokolo taka bakadio diso. Eseme Pita Yesuye yimapoo to taka hagee gooleebuguso, “Epei gesi kolokoloso taka bakadio delega, malalo hoogoo mologa, nayo mo goo gagadilei ee bakadio hedebe dalaiso.” Eseme Pitaye to hagee gooleebugume, goohele toowa sibume, diya pisaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Osoloso gesikolodee mapoo tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo, osoloso Yu odoo dia wiligi odoo tebisa sabolo, osoloso wiligi odoo tebisa abo susuga oso goo hee moodoolai to mouso. Osoloso diayo to mouloso, Yesuwo dee tiso tiegisaloso, Loum gamalee mi toowa wiligi odoo taba, Paileteeye badebei mapoo ido dileso yimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Eseme Paileteeye Yesu mapoo egeesee woosaso, “No tei Yu odoo dia wiligi odoo taba nosomo?” diso. Eseme Yesuye nei egeesee takaso, “O, no olo egee takooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eseme tei moso wiligi odoo tebisa oso Yesu tokenee goo bei tooso doloso, diya gigidiso. ");
INSERT INTO kkc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Eseme Paileteeye see Yesu mapoo egeesee woosaso, “No odoo susuga oso nee goo maga goo opusomo opusomo di egee takoo omapoo nayo to nei takalaimeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Esino Yesuye to nei takele. Eseme Pailet yayo goo egee ogoloso diya dio diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dugo susuga ma kulodu Paileteeye Yu odoo goomogalame, Godeeye Gababia wo ne biame mapoo odoo susuga oso goomoga odoo hee neliga moso ma kuloduga peegoo tamageeye deliso. ");
INSERT INTO kkc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Biame omapoo odoo hee neliga moso ma kulodu badebeiso, o hu Balabas. Daga yayo o odoo sabolo oso Loum gamalee odoo mapoo ha temeleso, diayo odoo hee wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eseme odoo mooloogoodoo oso sibileso, Pailet mapoo egeesee takaso, “Nayo odoo hee neliga moso ma kuloduga peegoo tamageliso. Esiga nayo dugo hamapoo odoo hee neliga moso maga peegoo tamagee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Egeesi ma kulodu tei moso wiligi odoo tebisa oso Yesu mapoo koolone, yo Pailet mapoo ido simi goo ee, yo ogoloso olo gooleedooso. Eseme Paileteeye odoo susuga mapoo egeesee woosaso, “Ayo Yu odoo nibada wiligi odoo hagee peegoo tamagalai, niba goomogosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Esino tei moso wiligi odoo tebisa diayo odoo susuga mapoo toso pupulone, Pailet mapoo egeesee takee diso, “Iba Yesu gowoo, esino Balabas neliga moso ma kuloduga peegoo tamageeye, dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eseme Paileteeye dimapoo egeesee woosaso, “Ayo Balabas yo neliga moso ma kuloduga peegoo tamagooga, odoo hee hagee niyo Yu odoowo wiligi odoo taba deli ee, ayo kasee moodoolaisomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eseme nei diayo to neligidi takolone Pailet mapoo egeesee takaso, “Yo homo bulubo magoo ma dokodoo yoguso enige!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eseme Paileteeye egeesee woosaso, “Bei kasi magayo? Yayo ogoo goo tokenee toowo?” diso. Esino odoo susuga oso to diya neligidi egeesee takaso, “Yo homo bulubo magoo ma dokodoo yoguso enige!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eseme odoo susuga goomogalame, Paileteeye Balabas yo neliga moso maga peegoo tamagooso. Osoloso yayo o ha teli odoo mapoo takolone, Yesu we tiso wooloso homo bulubo magoo ma dokodoo yoguso enige, dee takaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eseme Pailet o ha teli odoo oso Yesu we tiso wooloso Loum gamaleeyo moso mapoo ido palaso. Osoloso omapoo ha teli odoo susuga gilimadoloso mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Osoloso diayo Yesu manolone gamenee yo wiligi odoo taba masi palame, kali dugo bige sage ee yimapoo kadiloso, we ti sidoloso o wiligi mapoo kadiso. ");
INSERT INTO kkc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Osoloso diayo Yesu mapoo manolone egeesee takaso, “Yu odoo dia wiligi odoo taba, iyo nee hu dokodoo poudoso,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Osoloso Yesuwo wiligi mapoo diayo weiso see woo see woo dolone, yimapoo makawo paga demeleeso. Osoloso diayo Yesu mapoo manolone o mudugiyopoo dibada ebiso miyomoo tugusaloso wiligi gauwuloso gamenee yimapoo tei to demeleeso. ");
INSERT INTO kkc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Egeesee soloso koodobuloso ha teli odoo oso dugo Yesuye ka ee tamagoloso see Yesu o dugo kadiso. Osoloso yo homo bulubo magoo ma dokodoo yoguso enigilame ido diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Osoloso ha teli odoo oso Yesu idoloso diyadaga meleeno, diayo Saimon eli domopoo Yelusalem mapoo sibumolome tugodooso. Osoloso diayo yo idoloso Yesuwo homo bulubo magoo imado diye, diso. (Saimon hagee Alesanda dio Lupus dio dibada ama. Yo Kulene mi mapoo badeli odoo.) ");
INSERT INTO kkc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Osoloso diayo Yesu toloso Gologota mi mapoo ido simiso. (Mi hu eyo bei ee wiligi ki mi.) ");
INSERT INTO kkc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Osoloso mi omapoo ido dileso, diayo Yesu mapoo sibileso wain i sabolo dala mauwe pegeli melesenee sabolo wuluguloso, Yesu mapoo tenelame siso. Esino Yesuye wain i egee nele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Eseme gesikolo osoko howo bakadio hedebe di poogoloso osoko pouneme, diayo Yesu homo bulubo magoo ma dokodoo yoguso enigaloso tuluguso. Osoloso Yesuwo dugo pilame, diayo yoso dasigeli hee dasigaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Osoloso edebeeyo Yesu woolooma goo eyo bei ee odoo susuga oso gooleedalame, odoo heeso Yesuwo wiligi oo poogoo dokodooga to egeesee hoguguloso kalamaso, ");
INSERT INTO kkc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Osoloso mesiya bakadio sabolo homo bulubo magoo ma dokodoo yoguso enigaso. Odoo hee Yesuwo dee deedee dokolo tulugu, osoloso odoo hee o dee dobusu dokolo tulugu diso.  ");
INSERT INTO kkc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Esiga Godeeyo to booka mapoo hogugu oso egeesee takooso, “Yo mesiya masi talaiso.” Esiga Yesuye mesiya masi talame homo bulubo magoo ma dokodoo molone, to hagee tei diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Osoloso odoo aboso eli omaga dulone, Yesu ogoloso manolone dia wiligi wabisaso. Osoloso diayo yimaga to tokenee yimapoo takaga meleeso. Egeeseelone diayo yimapoo egeesee takaso, “Nayo takolone, tei moso ee guobuguloso, biame bakadio hedebe di ee ma kulodu see dia ka tegelaigona, dee taka. ");
INSERT INTO kkc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Esiga no telega pagalame homo bulubo magoo ma dokodooga miyomoo mei!” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Osoloso tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo dibolosee Yesu manolone dieso dimapoo egeesee takaso, “Yayo odoo abo pidimo siliso. Esino yo epedee eyo nediliyo pidilei tebiledoo. ");
INSERT INTO kkc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keliso, Isalael odoo ibada wiligi odoo daga, yo homo bulubo magoo ma dokodooga miyomoo meilei tekepo. Egeeseega yayo mou ogoloso iyo yimapoo tei talaiso,” diso. Eseme mesiya bakadio oso, homo bulubo magoo ma dokodoo yoguso enigaloso molone, dibolosee Yesu mapoo maneso. ");
INSERT INTO kkc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Osoloso osoko olo oo domopoo tooboome, mi toowa egee nolugo doloso melee, osoko howo bakadio hedebe di poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Osoloso neliga melee ee mauwe poogoome, Yesuye o to oso neligidi egeesee iso, “Eloi, Eloi, lama sabakatani?” To hageeyo bei ee egeesi moloso, “Mo Godee, mo Godee, bei kasi maga nayo a ka pagala?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eseme odoo koola omapoo tebisa melee oso to hagee duloso, diayo egeesee takaso, “Dui! Yo Ilaya i,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eseme odoo heeso hoguo dileso dugo toloso wain i mei nali mapoo olugu doloso homo sage su mapoo tialogoloso Yesuye nalame o maga mapoo heligiso. Osoloso yayo egeesee takaso, “Ougo. Ilayaye sibileso yo toloso miyomoo mouwa beleso bamo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eseme epedee omapoo Yesuye neligidi iloso taso. ");
INSERT INTO kkc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eseme Yesuye ta biame omapoo, tei moso tegei ma kulodu dugo kodia oso kisi melee ee, dokodooga eyo tologomo abaga mouno miyomoo sabuguso. ");
INSERT INTO kkc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eseme ha teli odoo gibadeli odoo oso Yesuwo homo bulubo magoo ma koola omapoo tobudulone, Yesuye tolone goo moodoo ogoloso, yayo egeesee takaso, “Tei takoo, odoo hagee tei Godeeyo owolodoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Eseme sobo abo Yesubolo Gelili abaga Yelusalem mapoo sibadee oso, eli sage abaga Yesu homo bulubo magoo ma dokodoo molome balaga meleeso. Sobo mooloogoodoo egee ma kulodu debei, dibada hu Meli-Magadalin sabolo, osoloso Meli hee (Yemes pepooko dio Yosep dio dibada owee) sabolo, osoloso Salome sabolo, diayo Yesu mapoo bameleeso. Sobo bakadio hedebe di hagoso daga Yesubolo Gelili mapoo silone, Yesu pidimo siliso. ");
INSERT INTO kkc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yu odoowo hasali biame malalo hoogoo molome, diayo tei doloso dabalame bi mopoodoo doo biame habe omapoo, Yosep Alimatiya odoo yayo Paileteeye badebei omapoo diso. Yo Yu odoowo wiligi toboloso badolone, Godeeye wiligi doloso badeli oso sibilei omapoo bameli. Yayo ebilega Yesuwo kou talame Pailet mapoo woosaso. ");
INSERT INTO kkc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Eseme Yosepeeye Yesu taso dee takeme, Pailet diya hoowaso. Bei, Paileteeye goolee Yesu tele, dee gooleeso. Esino Yesu olo saga taso. Eseme yayo ha teli odoo gibadeli odoo Yesuye ta egei mapoo egeesee woosaso, “Yesu taso dee takemeni teiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eseme ha teli odoo gibadeli odoo oso Yesu tei taso dee takeme, Paileteeye Yosep mapoo egeesee takaso, “Yesuwo kou todi,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Eseme Yosepeeye dugo sage medee tekepo moleeso toloso, Yesuwo kou homo bulubo magoo ma dokodooga miyomoo tomeileso, dugoso tiadooso. Osoloso yayo Yesuwo kou toloso wulu ou sage yoso moodoo ma kulodu magooso. Osoloso yayo yo toowa bidigamo dileso, wulu ou miyopoo kisiso. ");
INSERT INTO kkc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Osoloso Meli-Magadalin dio Yosepeeyo owee Meli dio Yesuwo kou magoo mi diayo egeiso. ");
INSERT INTO kkc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Osoloso Yu odoowo hasali biame oso dileso koodobuloso, Meli-Magadalin, Yemeseeyo owee Meli, osoloso Salome, diayo sisigageli bi medee tekepo Yesuwo kou mapoo hedilame moleeso misigaso. ");
INSERT INTO kkc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Osoloso Sadee toowa biame gesikolodee osoko gie pouneme, diba Yesuwo bi agalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Diba eli domopoo diyadulone, dieso dimapoo egeesee takaso, “Yo toowa wulu ou miyopoo kisi ee, odoo agayo peegoo bidige bigileisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Esino diba dileso egeino, yo toowa wulu ou miyopoo kisi ee peegoo bidigamo dileso molome egeiso. Yo hagee diya toowa. ");
INSERT INTO kkc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eseme sobo diayo wulu ou ma kulodu galaga dileso egeino, odoo gie kauwa dugo sage heliye mouloso dee deedee dokolo badoboome egeiso. Eseme sobo diayo ogoloso, diba diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Esino yayo dimapoo egeesee takaso, “Niba haga na ebi. A gooleedooso, niba Yesu Nasalet odoo homo bulubo magoo ma dokodoo yoguso eniga odoo ee esiamo silesibo. Esino yo hamapoo koo moloso. Yo ta maga hogado diso. Esiga niba sibileso o kouso melee mi mapoo ege. ");
INSERT INTO kkc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Esiga niyo dileso, Yesu o hamamee dili Pita dimapoo takee, ‘Niba Gelili mapoo diyadee. Bei, Yesu yo daga malalo Gelili mapoo duso. Esiga niba dileso Gelili mapoo Yesu agalaiso. Bei, Yesu yayo to hagee daga nimapoo takaso,’” diso. ");
INSERT INTO kkc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eseme diayo goo tiadoo sabolo obulone kikiligolone midoo maga hoguo diyadeeso. Esino diayo eli domopooga diyadulone, odoo hee mapoo to takele poogooso, bei diba obume.  ");
INSERT INTO kkc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuye sadee toowa gesikolodee mapoo ta maga hogaduloso, yo daga Meli-Magadalin mapoo dileso peledabaso. Meli hagee Yesuye daga telega silone, bo holo 7 o kulodu doboome, yayo peegoo hasiso bugu sobo yoso. ");
INSERT INTO kkc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Eseme Meli yayo Yesu ta maga hogaduloso silee ogoloso, Yesuwo hamamee dili odoo diayo goohele sabolo pupusugulone debei mapoo dileso egeesee takaso, “Yesu ta maga hogaduloso sileeme, ayo egeiso,” diso. Esino diayo to hagee duloso, o to mapoo tei tele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Osoloso see hamamee Yesubolo silesibili odoo bakadio Yelusalem abaga sibadaga molome, Yesu yo mudu opusomo doloso dimapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eseme diayo Yesu ogoloso, diba see wedi dileso, Yesuwo hamamee dili odoo dimapoo diayo Yesu egei takeme, diayo dibada to mapoo tei tele poogooso. ");
INSERT INTO kkc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Osoloso hamamee, Yesuwo hamamee dili odoo 11 wo nalaga molome, Yesu omapoo dileso peledabaso. Osoloso Yesuye to kitulugu sabolo egeesee takaso, “Niba tei too mauwe odoo! Bei kasi maga odoo abo oso a ogoloso, sibileso nimapoo takeme, dimapoo tei telega ka poogoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Osoloso Yesuye dimapoo egeesee takaso, “Niba mi susuga mapoo dileso, to tekepo odoo susuga mapoo takomo di. ");
INSERT INTO kkc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Esiga odoo agayo to tekepo mapoo tei toloso howo oluguga, yo badoboso, kookaiyo gie badeli talaiso. Esino odoo agayo to tekepo mapoo tei telega poogooga, Godeeye goo midilei biame mapoo o goo midiloso yimapoo nei dala tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Osoloso edebeeyo to tekepo mapoo tei toga, diayo mo kitulugu sabolo goo toowa opusomo di moodoogamo silesibileiso. Egeesi ma kulodu diayo odoo bo holo oso paladee mo hu maga peegoo hasiso bigileiso. Osoloso diayo to opusomo opusomo di kalagalaiso. ");
INSERT INTO kkc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Osoloso dibada deeso sa talaiso, osoloso pei i nalagaga, diba wedileime. Osoloso odoo paigiga mapoo dibada deeso sigo daga, susuga weido dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Osoloso Lodee Yesuye dimapoo to taka koodobuloso, Godeeyo kitulugu oso yo Kei mi mapoo ido peleso, Godeebolo wiligi doloso badalame, Godeeyo dee deedee dokolo peleso biaso. ");
INSERT INTO kkc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eseme Yesu o hamamee dili odoo oso Yesuwo to ee mesilone, mi susuga mapoo to tekepo takomo diyadeeso. Egeeseelone diayo Lodeeye kitulugu sabolo goo toowa opusomo di moodoogaso. Bei, edebeeyo to tekepo mapoo tei doloso ogoloso gooleedalame. ");
INSERT INTO kkc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Godeeye ima kulodu tou temelee odoo aboso bei mooloogoo maga goo egee ogoloso diba see Godeeyo tou talame, odoo ma kulodu goo egee takomo silesibilame bei mooloogooso. Diayo egee takomo silesibo goo ee iba olo duso. Eseme goo tei duluga odoo sabolo osoloso goo tei egei odoo sabolo oso taka duloso, diayo goo ee hoguguso. ");
INSERT INTO kkc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Esino goo susuga bei mooloogoo maga ayo medee gooleedooga, ayo to hagee see medee ka hoguga. Esiga Tiyopoles wiligi odoo hu toowa too, nayo du goo ee medee tei goodoo dalame, ayo namapoo to hogugu hagee ka teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Helodeeye Yudiya mi mapoo wiligi toboloso badebei biame omapoo, Godee ogo odoo ogo doloso domo badeli odoo hee badebeiso, o hu Sekalaya. Yo Godee ogo odoo ogo doloso domo badeli odoo mooloogoodoo hee Abiyayo mooloogoodoo ma kulodu badebeiso. Osoloso osobowo hu Elisabet, obakadio Elonowo soosoo. ");
INSERT INTO kkc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekalaya dio Elisabet dio Godeeyo howo woola mapoo tekepo doloso dobolone, Godeeye kokodo taka to sabolo osoloso yayo tei magoo goo ee medee dodolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Esino diba holo soomagelega debeiso. Bei, Elisabet yo sobo deme taba, osoloso sobo adaga poloso badebei. Osoloso Sekalaya onosee olo adaga poloso badebei. ");
INSERT INTO kkc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Biame heeso Sekalaya o mooloogoodoo oso tou talai biame simiso. Eseme Sekalayaye Yu odoo dia tei moso mapoo peleso Godeeyo howo woola tobodulone tou temeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Osoloso Godee ogo odoo ogo doloso domo badeli odoo oso dima kulodu odoo hee hesilame diayo yo odoo hu ma ee kobumeleso Sekalaya hesiaso. Eseme diayo Sekalaya yo Godeeyo tei moso ma kulodu sisigageli medee tekepo Godee mapoo gigalagalame hesiaso. Eseme Sekalayaye Yu odoowo tei moso mapoo peleso sisigageli medee tekepo gigalegemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Eseme yayo sisigageli medee tekepo gigalogomolome, odoo susuga oso tei moso pee mapoo dobolone Godee mapoo takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekalaya yo tei moso ma kulodu osee badoboome, Godeeyo momaiye oso sisigageli medee tekepo gigaligili dosulu deedee dokolo mapoo peledoboloso tebidiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eseme Sekalayaye momaiye ogoloso dio dulone diya ebiaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Esino Godeeyo momaiye oso yimapoo egeesee takaso, “Sekalaya, no haga na ebi! Nayo Godee mapoo taka ee yayo olo duso. Nosobo Elisabet koowasi moodooloso giso holo soomagalaiso. Eseega nayo holope o hu Yonee hedi. ");
INSERT INTO kkc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yayo namapoo goomoga tosibileiso. Osoloso yo soomagooga, odoo susuga oso goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bei, yayo Godeeyo howo woola hu toowa toloso badalaiso. Osoloso yo yugune nalaime. Esino oweeye yo soomagoo maga bei mooloogoloso Dio Tei oso kitulugu sabolo badalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Osoloso yayo Isalael odoo see tobu dibada wiligi odoo Godee mapoo gilimado sibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yo Ilayaye kitulugu sabolo badebei egeesi masi badolone, Lodeeye sibilei mologa daga malalo yayo sibileiso. Osoloso yayo odoo susuga Lodeeye egee sibo goo omapoo mopoodoo dolone dobolone, ma dio sabolo owolo dio sabolo mesie goo mapoo gilimado sibileiso. Osoloso yayo Godeeyo to mapoo koo mesimo silesibili odoo dia goo goolee ee see Godeeyo howo woola tekepo goo talame dia goo goolee su wudileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Esino Sekalayaye Godeeyo momaiye mapoo egeesee takaso, “Ayo ogoo goo ogoloso nayo egee takoo goo mapoo tei doloso ka gooleedalaiyo? Bei, a olo giso adaga osoloso mo sobo onosee sobo adaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Godeeyo momaiye oso yimapoo nei egeesee takaso, “Mo hu ee Geibulu. A Godeeyo mudugiyopoo badeli. Ayo namapoo to tekepo hagee takalame, Godeeye a sibeye diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Esino no dui! No to kelega poogoloso badalaiso. Bei, nayo mo to mapoo koo tei to. Esiga no to kelega badoga, ayo namapoo taka goo hagoso peledabalai biame tugodoo omapoo ogoloso see to kalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekalayaye tei moso ma kulodu badebei diya koodoowoome, odoo aboso peegoo yo bolone dobolone egeesee takaga meleeso, “Yo ogoo goo tamalabele?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekalaya tei moso maga gasibileso, to kelega tobudulone, wulo deeso edidi takaso. Eseme odoo susuga oso goo ee ogoloso gooleedooso, yo tei moso tegei ma kulodu badolone o howo opusomo deme, goo hee egeidoo, diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekalayaye tei moso ma kulodu tou temelee biame ee koodobuloso, yo see o mi mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Osoloso hamamee Sekalayayo osobo Elisabet koowasi moodooloso badolone, a dee tiadoo ma kulodu Elisabeteeye o moso kuloduga peegoo gadile. ");
INSERT INTO kkc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Osoloso Elisabet eyo nediliyo egeesee gweliso, “Godeeye a pidiso, osoloso ayo deme toboloso badolone odoo howo woola simili goo ee yayo amaga peegoo togobuguso,” deliso. ");
INSERT INTO kkc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabet koowasi moodooloso badebei a 6 poogoloso badoboome, Godeeye o momaiye Geibulu sobo obuo Meli mapoo meiye, diso. Meli yo Gelili mi toowa ma kulodu Nasalet mi pepooko mapoo badeli. Esino odoo hee Meli hulame badebeiso, o hu ee Yosep, yo Deibidi dio bala hedebe. ");
INSERT INTO kkc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Osoloso Godeeyo momaiye oso meileso Meli mapoo egeesee takaso, “Emegei, Godeeye sobo no olo hesiaso. Osoloso Godeeye nobolo hodobo badoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meli to hagee duloso goo tiademe, to hageeyo bei ee diya goolee meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Esino Godeeyo momaiye oso Meli mapoo to nei egeesee takaso, “Meli, no haga na ebi. Bei, Godeeye namapoo diya goomogoso. ");
INSERT INTO kkc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","No koowasi moodooloso giso holo soomagalaiso. Osoloso nayo o hu Yesu hedi. ");
INSERT INTO kkc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yayo hu toowa toloso badalaiso. Osoloso yo Godeeyo owolo dalaiso. Osoloso amawe Deibidiye wiligi toboloso badebei goo ee see wiligi odoo Godeeye yimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Esiga yayo Yekobowo bala ma kulodu wiligi toboloso badalaiso. Osoloso yayo wiligi toboloso badoga hoo pagalai mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eseme Meliye Godeeyo momaiye mapoo to nei egeesee takaso, “Goo hagee amapoo egeesee kasee peledabalaiyo? A sobo obuo, esiga giso dia goo ee a gooleedele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Esino Godeeyo momaiye oso yimapoo egeesee takaso, “Dio Tei oso namapoo sibileiso, osoloso Godeeye kitulugu oso no gagalaiso. Esiga nayo holope soomagalame egee see ee tei holo, osoloso yo Godeeyo owolo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Esiga no dui! No nemisi Elisabet goolee. Yo sobo adaga poloso badolone deme toboloso badoso diso. Esino yo epedee koowasi badebei a 6 poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bei, Godeeye goo susuga ee moodoolai yo teiba,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meliye egeesee takaso, “A Godeeyo tou teli sobo. Esiga nayo amapoo taka goo ee amapoo moodoolai a goomogo,” diso. Eseme Godeeyo momaiye oso Meli poogoo diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Osoloso biame omapoo Meli yo mopoodoo doloso Elisabet agalame saga diso. Yo Yudiya esia mapoo peleso, Sekalayaye badebei mi pepooko mapoo peledoboloso, see Sekalayayo mosopoo diso. Yo Sekalayayo mosopoo dileso Elisabet ogoloso emegei di to takaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet Meliye emegei di to taka du domo mapoo holope oso o beliye ma kuloduga dabaso. Osoloso Dio Tei oso Elisabet mapoo sibume, yo kitulugu tooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Eseme yayo to neligidi egeesee takaso, “Sobo susuga ma kulodu Godeeye namapoo diya goomogolone, nama kulodu holope egee bado sabolo yimapoo diya goomogoso. ");
INSERT INTO kkc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A hu toowa too sobonee. Esino mo Lodeeyo oweeye a agalame simiso. Goo omapoo a diya goomogo. ");
INSERT INTO kkc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Eseme nayo amapoo emegei di to takeme, holope mo beliye ma kulodu badebei oso goomogolone dabaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Godeeye namapoo peledabalai goo ee takeme duloso tei too maga, Godeeye namapoo goomoga tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Osoloso Meliye egeesee takaso, “Mo sooloo ma kuloduga Godee mapoo goomoga to taka. ");
INSERT INTO kkc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Osoloso mo dio oso mo Godee mo gie badeli pidili mapoo goomogo. ");
INSERT INTO kkc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bei, yayo o tou teli wuluge sobo a toowa doloso gooleeso. Esiga epedee hamaga dulone odoo susuga oso a Godeeye pidi sobo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bei, Kitulugu Godeeye amapoo goo toowa abo olo moodooso. Yo tei. ");
INSERT INTO kkc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Edebeeyo Godee mapoo mesilone doga, Godeeye sooloo deli goo oso dimapoo kookaiyo osee malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Osoloso yayo kitulugu oso goo toowa abo olo moodoogaso. Osoloso yayo odoo dieso nediliyo tekepo doloso si howeli odoo ee peegoo hasiso buguso. ");
INSERT INTO kkc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Osoloso yayo wiligi odoo tebisa diayo wiligi dalame kitulugu too hu ee peegoo tabuguso. Esino odoo dieso pepooko doloso debeli odoo ee pidilone, diba dokodoo poudooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Osoloso yayo nei mauwe odoo ee bi tekepo oso pidiso. Esino bi bei odoo ee mosoowe peegoo hasiso buguso. ");
INSERT INTO kkc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Osoloso yayo ibada amawe dio sabolo to kitulugu magoo ee dodolone o to mapoo mesimo silesibili Isalael odoo pidiso. Esiga yayo sooloo deli goo oso Eibalaham sabolo osoloso amawe dimapoo kookaiyo moloso osee malaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meliye Elisabet dio badebei a bakadio hedebe di poogoloso see o mi mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet damamee ti biame omapoo, yayo giso holo soomagooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Godeeye Elisabet mapoo goo tekepo moodoo maga o soosoo sabolo, osoloso yima koola mapoo debeli odoo sabolo oso goo hagee duloso, goomoga hodobo Elisabet bolo poudooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Osoloso giso holo soomagoloso abaga dino biame 8 mapoo diayo holope o kolo koolame mooloogoodooso. Osoloso diayo holope o hu amamo hu Sekalaya hedilame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Esino owee Elisabeteeye egeesee takaso, “Haye, o hu Yonee hedilei,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Esino diayo yimapoo egeesee takaso, “Yonee egee namawe dio eyo hunee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Osoloso diayo see holope eyo ama mapoo o hu odoo ogu hedileiyo doloso deeso edidi takaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eseme Sekalayaye holope eyo hu magalame odoo susuga mapoo dasogo sabolo homo kolo sabolo yimapoo tenee doloso deeso edidi takaso. Eseme yayo holope eyo hu egeesee magooso, o hu Yonee. Eseme odoo susuga oso goo hagee ogoloso dio diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eseme epedee omapoo Sekalaya to kelega poogoloso badebei see to kolone Godeeyo hu dokodoo poudoomo sileeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Osoloso mi omapoo debeli odoo oso goo hagee ogoloso ebigaso. Osoloso Yudiya esia mapoo debeli odoo susuga oso goo hagee duloso to kesameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Osoloso goo hagee duli odoo oso goolone egeesee woosaso, “Holope hagee odoo kasi masi badobomobelee,” diso. Bei, diba egeiso, Godeeye kitulugu oso yibolo molome. ");
INSERT INTO kkc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yoneeyo ama Sekalayaye Dio Tei oso kitulugu toloso badolone malalo hoogoo peledabalai Godeeyo to ee yayo malalo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isalael odoo dia wiligi odoo Godeeyo hu dokodoo poude! Bei, yayo sibileso o odoo see eyo gilimadalame neiso tooso. ");
INSERT INTO kkc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Osoloso Godeeyo tou teli odoo Deibidiyo bala ee ma kuloduga gie badeli pidili odoo kitulugu toowa imapoo olo teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Daga hoogoo Godeeye goo hagee o howo woola todoloso dobolone Godee maga to toloso kokodo takomo sili odoo oso imapoo olo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Esiga imapoo ha teli odoo osoloso imapoo hegili odoo oso kitulugu ee ma kuloduga Godeeye iba peegoo gilimado dileiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Osoloso Godeeye ibada amawe dio sooloo dolone pidileiso diso. Osoloso yayo Eibalaham dio to kitulugu magoo ee osee goolee malaiso diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Esiga Godeeye imapoo ha teli odoo ma kuloduga gilimadoloso peegoo dileiso, iyo Godeeyo tou tolone dobolone ebia goo mauwe poogoloso dabalame. ");
INSERT INTO kkc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Esiga iyo debei ma kulodu Godeeyo howo woola tekepo dobolone todolone dabalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Esino mo holo, no odoo susuga oso dokodoo badeli Godee maga to toloso kokodo takomo sili odoo dalaiso. Bei, Lodee sibilega badoga, daga malalo nayo dileso yayo sibilei goo mapoo odoo mopoodoo dalame gu takala dileiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nayo o odoo gie badeli pidilei goo ee eligileiso. Goo ee dibada goo tokenee hapooga, gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Godeeye iba sooloo dolone diya goolee moloso. Esiga Kei mi ma dokodooga yayo hudi magoo odoo oso mi gie hadobuoga osokoso egee pouno egeesee masi imapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Godeeye hudi magoo odoo hagoso teli mapoo dili eli omapoo egee do sabolo osoloso neliga ma kulodu egee do odoo dimapoo pounileiso. Osoloso yayo iba gilimado dileiso, Godee sabolo mesie dabalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yonee kauwulone o dio oso kitulugu sabolo badebeiso. Yo miwe poogoo mi mapoo badoboso biame oso sibume, Isalael odoo dimapoo to tekepo takalame simiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Biame omapoo Sisa-Ogastas yayo Loum odoo dia wiligi odoo toboloso badolone, odoo susuga eyo hu booka mapoo magalame tei magooso. ");
INSERT INTO kkc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hu tomo di hagee hu telega moloso Kuliniyos yayo Siliya mi mapoo wiligi odoo toboloso badolone daga bei ka mooloogoo. ");
INSERT INTO kkc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eseme odoo susuga dibada midee mapoo dia hu magalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosep hagee Deibidiyo amawe. Esiga yo Gelili mi ee ma kulodu mi hee Nasalet maga, see Yudiya mi mapoo mi hee Betilihem mapoo o hu magalame palaso. Bei, Betilihem mi egee Deibidi o soosoo dibada midee. ");
INSERT INTO kkc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yo Meli hulame dadagoloso dia hu magalame palaso. Esino Meli yo olo koowasi moodooloso badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Diba Betilihem mi mapoo dileso peledoboloso omapoo doboome, Meli damamee tiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Osoloso yayo holope daga malalo giso holo soomagooso. Holope soomagoloso dugoso tiadoloso gala hu nei nedili moso tegei eyo kulodu howogi masi mapoo tiediso. Bei, odoo soo oso sibileso tieli moso ee ma kulodu debi mauwe neme. ");
INSERT INTO kkc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yesu soomagoo gesi omapoo sipi be bali oso Betilihem mi koola mapoo dibada sipi be balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eseme Godeeyo momaiye oso saga epedee omapoo dimapoo sibileso peledabaso. Osoloso Godee yayo toowa doloso badeli goo omaga o gadeebugu oso diba teme, diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Esino momaiyeso dimapoo egeesee takaso, “Niba haga na ebi. Bei, odoo susuga oso goomogalame ayo nimapoo to tekepo tosiba. ");
INSERT INTO kkc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Epei Deibidiyo mi mapoo odoo susuga eyo gie badeli pidilei holope ee soomagooso. Yo Keliso Lodee. ");
INSERT INTO kkc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yo dugoso tiadoloso gala hu nei nedili howogi masi mapoo tiamologa ogoloso gooleedalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Osoloso epedee saga omapoo momaiye mooloogoodoo toowa oso Kei mi maga sibileso, momaiye daga malalo simi sabolo hodobo mooloogoodooso. Osoloso momaiye susuga oso Godeeyo hu dokodoo poudoolone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kei mi ma dokodoo badeli Godee mapoo goomoga poude! Osoloso mipoo hamapoo Godeeye goomoga odoo dimapoo mesie goo oso mele dee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Osoloso momaiye susuga oso diba poogoloso Kei mi ma dokodoo see wedi paladeeso. Eseme sipi be bali odoo oso dieso nediliyo egeesee takaso, “Iba Betilihem mi mapoo Godeeye imapoo taka goo ee peledaba beleso agalame dimo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eseme diba saga dileso egeino, Meli dio Yosep dio holope gala hu nei nedili howogi masi mapoo tiedi molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Osoloso diba dileso holope ogoloso momaiyeso holopeyo goo dimapoo taka ee see diayo odoo abo omapoo debei mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eseme sipi be bali odoo oso holope eyo goo takeme duloso odoo susuga diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Esino Meli yo goo hagee duloso biame susuga ma kulodu boobado bigilega osee goolee meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eseme sipi be bali odoo diba see wedi dulone, diayo du goo sabolo osoloso diayo egei goo omaga Godee mapoo goomoga toowa poudooso. Bei, diayo egei goo susuga ee momaiyeso taka goo sabolo teibaneme. ");
INSERT INTO kkc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osoloso holope soomagoloso abaga dino biame 8 mapoo o kolo kooso. Osoloso yo Yesu hediso. Bei, daga yo Meliyo beliye ma kulodu mauwe mapoo momaiyeso hu hagee olo hediso. ");
INSERT INTO kkc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Meli dio Yosep dio Moseseeye tei magoo ee dodolone Godeeyo howo woola tokenee mauwe dabalame, mopoodoo doo biame koodobuloso, diayo Yesu idoloso Yelusalem mi mapoo diso. Osoloso diba Yu odoowo tei moso mapoo peleso, diba see Godeeyo howo woola tokenee mauwe dabalame, só bakadio wooloso Godee mapoo teneeso. Bei, Godee o tei magoo oso egeesee takooso, “Niba molo bakadio o, wi pepooko bakadio wooloso amapoo tenee,” deeso. Osoloso diba tei moso tegei mapoo peleso, Yesu see Godee mapoo teneeso. Bei, Godee o tei magoo oso egeesee takooso, “Malalo soolooga magoo giso holo susuga Godee mapoo tenee,” deeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Biame omapoo Yelusalem mi mapoo adaga hee badebeiso, o hu Simiyon. Yo Godeeyo howo woola tekepo doloso badolone, hedebe Godeeno diya goolee sabolo badeliso. Esino yayo Godeeye Isalael odoo mapoo hegi goo melee ee togobigilame biame oso sibilei ee bolone bameleeso. Osoloso Dio Tei oso yibolo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Esino yo adaga poloso telega badolone, Godeeye hesia Keliso yo agalai goo ee Dio Tei oso yimapoo olo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Osoloso Dio Tei oso Simiyon yo tei moso tegei mapoo ido diso. Osoloso Meli dio Yosep dio oso tei magoo ee dadalame holope Yesu yo tei moso mapoo ido palaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eseme adaga Simiyoneeye Yesu ogoloso maduloso Godee mapoo goomogolone to egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Godee nayo takolone a Keliso ogoloso ka talai diso. Esiga epei nee tou teli odoo ayo mesie sabolo talai tekepo. ");
INSERT INTO kkc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Bei, mo howoso gie badeli pidili odoo ee nayo odoo susuga mapoo tenee a egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yo gadeebugu, Yu odoonee dimapoo Godeeyo goo ee yilige bigilame. Osoloso yimaga nee Isalael odoo diba dokodoo poudileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesuwo ama dio owee dio Simiyoneeye taka to duloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Osoloso Simiyoneeye Godeeye diba pidilame takoloso Meli mapoo egeesee takaso, “Godeeye holope hagee hesiaso, Isalael odoo aboso holope hagee gowooga, Godeeye diba pepooko dalame. Osoloso odoo aboso holope hamapoo tei toga, Godeeye diba dokodoo poudileiso. Esiga odoo aboso o goo talai gowoolone yimapoo ha talaiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Goo egeesi maga dibada sooloo ma kulodu egee molo goo ee woola yilige bigileiso. Osoloso goohele goo oso nee sooloo mapoo kaiyaso heleegee masi halagalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Osoloso domo omapoo Godee maga to toloso kokodo takomo sili sobo hee tei moso tegei ma kulodu badebeiso, o hu Ana. Sobo yo o bala Asel. Osoloso amamo hu Panuwel. Yo sobo adaga poloso badebeiso. Yo daga gisoso huloso dugo 7 ma kulodu omobolo badoboso, omo taso. ");
INSERT INTO kkc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eseme yayo badebei dugo 84 poogoloso, omapoo yo bau osee badebeiso. Yo biame susuga tei moso tegei mapoo howo gisimo silone, biame sabolo osoloso gesi sabolo Godeeyo hu dokodoo poudoolone nei tei yuloso badolone Godee mapoo takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Osoloso Simiyoneeye Meli dio Yosep dio to kesamolome, yo domo omapoo simiso. Yo sibileso Godee mapoo goomoga to takaso. Osoloso Yelusalem mi eyo hegi goo ee ma kuloduga gilimadoloso peegoo dilame balagamelee odoo dimapoo Yesuwo goo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep dio Meli dio Godeeye taka tei goo susuga toloso koodobuloso, see Gelili mi ee ma kulodu dia midee Nasalet mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Osoloso holope oso kitulugu sabolo kauwuloso goo goolee medee tekepo yimapoo meleeso. Osoloso Godeeye yo sooloo dolone pidimeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dugo susuga ma kulodu biame hedebe mapoo Yesuwo owee dio ama dio Yelusalem mapoo Godeeye gababia wo nalame diliso. ");
INSERT INTO kkc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Osoloso dugo hee mapoo diba see gababia wo nalame dime, Yesu yo dibolo diso. Biame domo omaga Yesu o dugo 12. ");
INSERT INTO kkc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gababia wo ne biame koodobume, diba see wedi diso. Esino Yesu yo dibolo dilega, Yelusalem mapoo badebeiso. Yesuye Yelusalem mapoo badebei owee dio ama dio gooleedele. ");
INSERT INTO kkc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Esino ama dio owee dio goolee, Yesu odoo abo sabolo malalo di bele dolone, diba nosee diso. Diba dileso eli domopoo tilame dobolone, diayo dia soosoo ma kulodu osoloso dia odoo ma kulodu Yesu esiaso. ");
INSERT INTO kkc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Diba omapoo Yesu esiameleso koo egeme, see Yelusalem mapoo Yesu esilame wedi diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Osoloso biame bakadio hedebe di poogoloso hamamee diayo Yesu Yu odoo dia tei moso mapoo Yu odoowo tei eligili odoo abo sabolo to kolone doboome egeiso. Ee ma kulodu Yesuye tei eligili odoo oso eligi goo ee dulone badolone, yayo nei dimapoo woosa demeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Osoloso nei tei eligili odoo oso woosa to eyo nei dimapoo medee tekepo wedi di duloso, osoloso o goo goolee tekepo ogoloso odoo susuga oso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yesuwo owee dio ama dio oso Yesuye tei eligili odoo sabolo to kolone badoboome ogoloso dio diso. Eseme oweeye egeesee takaso, “Mo holo, nayo kasalame goo egeesee imapoo ka moodoowo? Nama asalo no esiamo silone diya kukuda sabolo sileeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Esino Yesuye nei dimapoo egeesee takaso, “Niyo kasalame a ka esiamo sileeyo? Ayo mo mayo moso mapoo badalai goo ee niba gooleedeleyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Esino Yesuye taka to eyo bei diba medee kibiya gooleedele. ");
INSERT INTO kkc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Osoloso Yesu see dibolo hodobo Nasalet mapoo wedi diso. Osoloso omapoo badolone, dibada to mapoo mesimo sileeso. Esino Meliye goo susuga hagee biame susuga osee goolee sabolo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu yo kauwulone goo goolee tekepo sabolo kauwaso. Eseme Godee sabolo osoloso odoo sabolo oso yimapoo diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa-Taibiliyeseeye Loum wiligi toboloso badebei dugo 15 poogoloso, odoo abo hagee bia oso yima hemi wiligi tebisaloso debeiso. Pontiyus-Paileteeye Yudiya mi bameleeso, osoloso Helodeeye Gelili mi bameleeso, osoloso omolo Pilipiye Ituliya mi sabolo Talakonitis mi sabolo bameleeso. Osoloso Lisaniyaseeye Abilene mi bameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Osoloso Anas dio Kayapas dio Yu odoo dia tei moso wiligi toboloso debeiso. Biame omapoo Sekalayayo owolo Yonee miwe poogoo mi mapoo badoboome, Godeeye o to yimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eseme yayo dileso Yoden howo koola ogolone debeli mi mapoo Godeeyo to takomo silone, odoo susuga mapoo egeesee takomo sileeso, “Nibada tokenee mapoo miligi pialoso howo ogusige. Eseega Godeeye nibada tokenee hapoloso boobado bigileiso,” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Goo hagee Godee maga to toloso kokodo takomo sili odoo Aisayaye o booka mapoo hogugu to sabolo tobuoso. Bei, yayo o booka mapoo hageesee hoguguso, “Miwe poogoo mi omaga edebeeyo egeesee idagoo, ‘Lodee yayo sibilei eli moodee, osoloso medee hoodo magee. ");
INSERT INTO kkc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Osoloso mi godobia mologa, omapoo mi abo kuge. Osoloso eli mapoo esia mologa, esia egee gebese. Osoloso eli halaga medee hoodo magee. Osoloso eli tokenee medee moodee. ");
INSERT INTO kkc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eseega odoo susuga oso gie badeli pidili Godee maga simi agalaiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Odoo mooloogoodoo Yoneeye diba howo ogusigilame sibademe, yayo dimapoo egeesee takaso, “Niba hebise, nimapoo odoo agayo takolone howo ogusiga goo oso Godeeye kamana goo egee sibo maga mada pia dabalaiso, dee ka takana? ");
INSERT INTO kkc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Esiga niyo debei goo maga nibada goo tokenee mapoo tei miligi pia goo ee eligi. Osoloso niba niso nediliyo iba Eibalahameeyo amawe dioga, Godeeye kamana maga mada pia dabalaiso dee na goolee. Bei, ayo nimapoo taka. Godee yimapoo kitulugu moloso, yo hagoso see Eibalahameeyo amawe dio palai. ");
INSERT INTO kkc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Esiga kabee homo bei mapoo olo magoo moloso. Esiga homo kaso ko tekepo pelega mologa, homo egee holoso dou mapoo toodalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eseme odoo susuga Yoneeye taka to ee duloso nei egeesee takaso, “Egeeseega iba ogoo goo moodoolaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eseme Yoneeye nei dimapoo egeesee takaso, “Namapoo sedi bakadio mologa, nee odoo sedi me daga, hee yimapoo tenee. Osoloso namapoo nei mologa, nee odoo hee nei me daga, abo yimapoo tenee.” ");
INSERT INTO kkc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Osoloso tekisi molee misigeli odoo abo diba nosee howo ogusigilame sibileso Yonee mapoo egeesee takaso, “Eligili odoo, iba ogoo goo moodoolaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eseme Yoneeye nei egeesee takaso, “Niyo odoo mapoo tekisi molee misigaga, hodio niyo talai ee goolone tekisi molee magalame tobuloso magoo ee na dagapele. Esino hedebe teiba ono odoo mapoo ka misige,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Osoloso ha teli odoo aboso Yonee mapoo egeesee takaso, “Iba nosee ogoo goo moodoolaisomo?” diso. Eseme Yoneeye nei dimapoo egeesee takaso, “Niyo emegei dia molee heli talame na seesee. Osoloso emegei dia molee heli talame dimaga gamenee goo na takee. Esino hedebe niso tou too eyo nei molee ee tolone goomoga sabolo ka debee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Odoo susuga oso Keliso bolone debei mapoo Yoneeye simi ogoloso, diayo goolee yo Keliso bele dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eseme nei Yoneeye dimapoo egeesee takaso, “Ayo niba howodeeso oluguliso. Esino odoo hee ama hamamee egee sibo yayo kitulugu oso ayo kitulugu dagadi. Esiga ayo o homo beiyopoo gauwuloso o homo bi ee pidigilei a tebile. Osoloso yayo Dio Tei nima kulodu tenelaiso. Esino yayo yimapoo tei tele poogoo odoo ee dou mapoo toodalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yayo witi wo ko sabolo osoloso so ee pilame o tou teli bi sabolo mopoodoo doloso badoso. Osoloso witi wo ko ee moso mapoo kukuleiso. Osoloso witi wo so dou koo semili mapoo toodalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoneeye to tekepo ee eli opusomo opusomo di maga odoo Godee mapoo gilimado sibilame, Godeeyo to tekepo takomo siliso. ");
INSERT INTO kkc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Esino Gelili mi eyo wiligi odoo taba Helodeeye goo tokenee tooso. Goo ee omolo osee badoboome, yayo omolowo osobo Helodiyes peedee huso. Eseme Yoneeye goo hagee ogoloso yimapoo diya takolone o tokenee goo abo sabolo yilige buguso. ");
INSERT INTO kkc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eseme hamamee Helodee komonolone yo tokenee hee toowa tooso. Goo ee yayo Yonee neliga moso ma kulodu husooso. ");
INSERT INTO kkc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Biame Yoneeye odoo howo ogusigamelee domo mapoo, Yesu yinosee howo oluguso. Yesu howo oluguloso gasibileso tobudulone Godee mapoo takomolome Kei mi osulu yamagooso. ");
INSERT INTO kkc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Eseme Dio Tei oso molo masi pusibileso yimapoo pubalagaso. Osoloso Kei mi ma dokodooga toso egeesee takaso, “No ayo gooma mo holo noso, a namapoo diya goomogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu yo dugo 30 domo mapoo badolone, o tou bei mooloogooso. Odoo susuga oso Yosepeeyo owolo gweliso. Yosep yo Heliyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli yo Matateeyo owolo. Matat yo Libaiyo owolo. Libai yo Melkiyo owolo. Melki yo Yanaiyo owolo. Yanai yo Yosepeeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep yo Matatiyaseeyo owolo. Matatiyas yo Amoseeyo owolo. Amos yo Nahumeeyo owolo. Nahum yo Esliyo owolo. Esli yo Nagaiyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yo Mateeyo owolo. Mat yo Matatiyaseeyo owolo. Matatiyas yo Semeineeyo owolo. Semein yo Yosekeeyo owolo. Yosek yo Yodayo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda yo Yohanayo owolo. Yohana yo Lesayo owolo. Lesa yo Selubabeleeyo owolo. Selubabel yo Selatiyeleeyo owolo. Selatiyel yo Neliyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli yo Melkiyo owolo. Melki yo Adiyo owolo. Adi yo Kosameeyo owolo. Kosam yo Elamadameeyo owolo. Elamadam yo Eleeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El yo Yosuwayo owolo. Yosuwa yo Eliyeseleeyo owolo. Eliyesel yo Yolimeeyo owolo. Yolim yo Matateeyo owolo. Matat yo Libaiyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai yo Simiyoneeyo owolo. Simiyon yo Yudayo owolo. Yuda yo Yosepeeyo owolo. Yosep yo Yonameeyo owolo. Yonam yo Eliyakimeeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim yo Meleyayo owolo. Meleya yo Menayo owolo. Mena yo Matatayo owolo Matata yo Neiteneeyo owolo. Neiten yo Deibidiyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibidi yo Yesiyo owolo. Yesi yo Obedeeyo owolo. Obed yo Bowaseeyo owolo. Bowas yo Salmoneeyo owolo. Salmon yo Nasoneeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason yo Aminadabeeyo owolo. Aminadab yo Adimineeyo owolo. Adimin yo Aliniyo owolo. Alini yo Hesloneeyo owolo. Heslon yo Peleseeyo owolo. Peles yo Yudayo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda yo Yekobeeyo owolo. Yekob yo Aisekeeyo owolo. Aisek yo Eibalahameeyo owolo. Eibalaham yo Telayo owolo. Tela yo Naholeeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol yo Selugeeyo owolo. Selug yo Lewuyo owolo. Lewu yo Pelegeeyo owolo. Peleg yo Ebeleeyo owolo. Ebel yo Selayo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela yo Keinaneeyo owolo. Keinan yo Alapakasadeeyo owolo. Alapakasad yo Semeeyo owolo. Sem yo Nowayo owolo. Nowa yo Lamekeeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek yo Metuselayo owolo. Metusela yo Inokeeyo owolo. Inok yo Yeledeeyo owolo. Yeled yo Mahalaleleeyo owolo. Mahalalel yo Kenaneeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan yo Enoseeyo owolo. Enos yo Seteeyo owolo. Set yo Adameeyo owolo. Adam yo Godeeyo owolo. ");
INSERT INTO kkc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu yo Yoden howo mapoo Yoneeye howo oluguloso, Yesu Dio Tei oso kitulugu toloso yo miwe poogoo mi mapoo Dio Tei oso ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesu miwe poogoo mi mapoo biame 40 ee ma kulodu nei nelega badoboome, Saitenso yo kukulo ogo demeleeso. Osoloso biame 40 poogoloso hamamee Yesu yo diya hodiaso. ");
INSERT INTO kkc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eseme Saitenso ogoloso yimapoo egeesee takaso, “No tei Godeeyo owolo daga, nayo yo hagoso see wo pe dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eseme Yesuye nei egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Edebeeyo hedebe nei nolone badoga oso gie badeli talaime,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eseme see Saitenso Yesu idoloso mubi dokodoo ido palaso. Eseme saga omapoo Saitenso mi edebeeyo bia susuga yimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Osoloso yayo Yesu mapoo egeesee takaso, “Daga Godeeye bi susuga hagee amapoo teneme, ayo bamo simiso. Esiga nayo amapoo gasuwoloso a dokodoo poudoga, mi susuga hagee sabolo, osoloso bi susuga ee ma kulodu egee molo sabolo, ayo namapoo tenelaiso. Bei, amapoo kitulugu moloso, odoo hee mapoo tenelai,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eseme Yesuye Saiten mapoo nei egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Nayo hedebe nee wiligi odoo Godee mapoo gauwuloso yo dokodoo poude. Osoloso hedebe o to mapoo mesie,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Osoloso see tobu Saitenso Yesu idoloso Yelusalem mapoo diso. Osoloso tei moso tegei omu ma dokodoo ido peleso tobudume yimapoo egeesee takaso, “No tei Godeeyo owolo daga, no moso omu ma dokodooga miyomoo bologobigi. ");
INSERT INTO kkc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Godeeye o momaiye mapoo no medee bamelee dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Esiga diayo no dia deeso douguleiso, no yo mapoo homodobiyaga,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Esino Yesuye egeesee takaso, “Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Nee wiligi odoo Godee oso kitulugu ee hoodo agalame yimapoo na kukulo ege,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saitenso Yesu kukulo ogomo silee koodobuloso yo see tobu kukulo agalame biame tekepo ee bolone Yesu epedee poogoloso diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu Dio Tei oso kitulugu sabolo Gelili mapoo wedi diso. Osoloso Gelili mi toowa ee ma kulodu odoo susuga oso Yesuwo goo dudobuguso. ");
INSERT INTO kkc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yayo Yu odoowo howo gisili moso susuga mapoo eligimo sileeme, odoo susuga oso yimapoo goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Biame heeso Yesu eyo yo kauwa o midee Nasalet mapoo diso. Osoloso Yu odoo oso hasali biame mapoo Yesu eyo seli egeesee solone, yo howo gisili moso mapoo palaso. Osoloso yo Godeeyo to booka mapoo hogugu ee hesigilame tabaso. ");
INSERT INTO kkc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Osoloso Godee maga to toloso kokodo takomo sili odoo Aisayaye hogugu booka ee yimapoo teneeso. Yo booka toloso piligamo abaga dino to hogugu domo ee ogoloso, to hagee hesigaso, ");
INSERT INTO kkc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Godeeyo dio abolo hodobo badoso. Bei, yayo a hesiaso, to tekepo bi mauwe odoo mapoo takalame. Osoloso Godeeye a diye diso, neliga moso ma kulodu debeli odoo mapoo yayo diba peegoo gilimado dileiso dee takalame. Osoloso howo siliga odoo see agalaiso dee takalame. Osoloso Godeeye a diye diso, edebeeyo hegili odoo hegi goo ma kuloduga ayo peegoo gilimado dilame. ");
INSERT INTO kkc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Osoloso Godeeye a diye diso, ayo Lodeeye o odoo mapoo goo tekepo moodoolai biame oso egee sibo goo ee odoo mapoo eligilame.” ");
INSERT INTO kkc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu booka hesigamelee koodobuloso, see booka bali odoo omapoo teneloso biaso. Eseme odoo susuga moso ee ma kulodu debei oso howoso medee kitulugu sabolo yimapoo bologolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Osoloso yayo dimapoo egeesee takaso, “Niyo Godeeyo to hogugu booka maga takeme du goo oso nimapoo epei olo simiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eseme o to du odoo susuga oso yo tekepo odoo doloso, yayo to taka susuga ee tekepo diso. Diayo egeesee takoloso, see egeesee takaga meleeso, “Iba gooleedooso yo Yosepeeyo owoloso. Egesino yayo kaseme to tekepo egeesee ka takayo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuye see dimapoo egeesee takaso, “A gooleedooso, niyo goo hamaga amapoo takalaiso, ‘Melesenee neli odoo, no no nediliyo tekepo moodee. Osoloso nayo Kapeniyum mi mapoo goo mudu opusomo di moodoogamelee see nee midee hamapoo moodee,’ dee takalai malaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Esino Yesuye see dimapoo egeesee takaso, “Ayo nimapoo taka, Godee maga to toloso kokodo takomo sili odoo yo o mosobia oso gowoolaiso. ");
INSERT INTO kkc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Esiga niba susuga dui. Ilayaye badebei biame omapoo mi toowa kibaso. Osoloso dugo bakadio hedebe osoloso a 6 ma kulodu howo sibilega nei mauwe badebeiso. Ee ma kulodu Isalael mi mapoo sobo bauwe debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Esino ee ma kulodu Godeeye Ilayaye diba pidiye doloso yimapoo takele. Esino yo Ilayaye wulo Yu dele poogoo sobo Saidon mi ma kulodu mi hee Salipat mi mapoo badeli sobo bau ono pidilame diye diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Osoloso Ilaisaye badebei biame omapoo, Isalael mi omapoo kolo tokenee odoo bei debeiso. Esino Ilaisaye odoo egee bia yayo pidile. Esino yayo Yu odoonee o hu Naman, Siliya mi mapoo badeli odoo ono tekepo moodooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eseme odoo howo gisili moso mapoo debei oso to hagee duloso diya kamanagaso. ");
INSERT INTO kkc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eseme diba tebisaloso Yesu toloso mosobia pee mapoo esia goosoo mapoo halagasalame ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Esino Yesu odoo mooloogoodoo ee ma kuloduga peegoo diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Osoloso Yesu Gelili mi toowa ma kulodu mi hee Kapeniyum mapoo diso. Yo omapoo dileso badolone Yu odoo oso hasali biame heeso yayo howo gisili moso ma kulodu Godeeyo to eligimeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eseme odoo susuga oso yayo eligi duloso diya howoogadooso. Bei, yayo diya kitulugu sabolo eligime. ");
INSERT INTO kkc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Howo gisili moso ma kulodu odoo bo holo pala hee omapoo badebeiso. Yayo to neligidi Yesu mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei, Yesu Nasalet odoo, nayo imapoo ogoo goo moodoolame ka simiyo? Nayo iba tokenee palame ka simiyo? Esiga no iba poogoloso di. Bei, a gooleedoo no Godeeye hesia odoo oso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eseme Yesuye to kitulugu sabolo bo holo mapoo egeesee takaso, “No to koodobuloso odoo ma kuloduga peegoo di,” diso. Yesuye egeesee takeme, bo holo oso peegoo poogolone odoo egee odoo howo woola miyomoo homodobuloso molone yimaga peegoo diyadeeso. Esino bo holo oso yimaga peegoo dulone yimapoo dala hee tenele. ");
INSERT INTO kkc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eseme odoo susuga oso goo hagee ogoloso howoogadolone egeesee takaga meleeso, “Yayo taka goo ee kasiyo? Bei, yayo to kitulugu sabolo bo holo mapoo takooga diba o to mapoo mesiloso peegoo dilidoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eseme odoo susuga oso goo hagee ogoloso mosobia susuga koola mapoo debeli mapoo takomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu howo gisili moso maga see Saimonowo mosopoo diso. Moso ee ma kulodu sobo Saimonowo nalobo pailone kolo diya dei moodoome tiameleeso. Eseme odoo susuga oso yo Yesuye tekepo moodoolame Yesu mapoo o goo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eseme Yesuye sibileso yayo tiamelee koola mapoo gauwuloso badolone paiye mapoo egeesee takaso, “Yo poogoloso di,” diso. Eseme paiye saga weidooso. Eseme yayo toboloso nei toloso dimapoo piso. ");
INSERT INTO kkc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eseme osoko todobume odoo susuga oso odoo paigiga susuga Yesu mapoo gilimado sibadeeso. Eseme yayo o deeso odoo paigiga susuga sigime wegigadooso. ");
INSERT INTO kkc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eseme Yesuye odoo bo holo paladee tekepo moodoogoome bo holo oso peegoo dulone to neligidi takolone egeesee takaso, “No Godeeyo owoloso,” dee takaga meleeso. Esino Yesuye to kitulugu sabolo dimapoo egeesee takaso, “Niba to na ke,” diso. Bei, bo holo oso Yesu yo Godeeye hesia Keliso doloso diba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gesikolodee mi hadobilega, Yesu tia maga hogabuloso odoo koola mauwe mi mapoo diso. Esino odoo susuga oso egeino yo me neme yima hamamee yo esiamo silesibiso. Diba Yesu esiamo silesiboso yo ogoloso yimapoo egeesee takaso, “No iba na poogoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Esino Yesuye dimapoo egeesee takaso, “A mi abo mapoo Godeeye wiligi doloso badeli goo ee takomo dilei tekepo. Bei, Godeeye goo hamaga a diye diso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Osoloso Yesuye Yudiya mi toowa mapoo diayo howo gisili moso susuga mapoo Godeeyo to eligimo sileeso. ");
INSERT INTO kkc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Biame hee mapoo Yesuye Gelili abei palaga mapoo Godeeyo to takomolome odoo susuga oso o to dulame diya mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu osee tobudulone di kebigeli odoo oso dia pei howo hapagalame dia du bakadio mubi dokodoo gisibado peleso ma molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu du bakadio ee ma kulodu Saimonowo du mapoo meileso badolone Saimon mapoo takaso, “Du abei pee maga pepooko hoogoo pupubigi,” diso. Eseme yo du ma kulodu badolone odoo susuga mubiyodoo doboome, yayo Godeeyo to dimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesuye odoo susuga mapoo Godeeyo to taka koodobuloso Saimon mapoo egeesee takaso, “Nee du howo bou mapoo sudo dileso di talame nibada pei howomoo oguse,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Esino Saimonoye egeesee takaso, “Wiligi odoo, iba eiyo gesi pei ogusulone tou toowa tooso, esino iba di giligile. Esino nayo amapoo takaga, mo pei howomoo ogusuleiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Osoloso diba dia pei howomoo ogusume di susuga oso dia pei mapoo tulone, dibada pei tologo bugulame seeso. ");
INSERT INTO kkc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eseme diayo dia odoo abo du hee mapoo debei deeso iso, diba pidilame. Eseme diba sibademe dibada du bakadio ee diso metamagisilone howomoo owulame sino poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon-Pitaye goo hagee ogoloso, Yesuwo homo beiyopoo gauwuloso egeesee takaso, “Lodee, amaga peegoo di, a tokenee odoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bei, yibolo osoloso o odoo sabolo diayo di bei giliga ogoloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Osoloso Saimonobolo tou teli odoo Yemes dio Yonee dio diba nosee goo hagee ogoloso diya howoogadooso. Odoo bakadio Yemes dio Yonee dio hagee Sebediyo owolo. Osoloso Yesuye Saimon mapoo egeesee takaso, “No haga na ebi! No daga di giligeli odoo badebeiso. Esino epei hamaga no see odoo Godee mapoo gilimado sibili doloso badalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Osoloso diba dileso dia du oluguloso bi susuga omapoo poogoloso, see Yesubolo hodobo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Biame heeso Yesu see mi hee mapoo diso. Mi omapoo odoo agagisa bia badebeiso. Odoo ogoso Yesu ogoloso o homo beiyopoo ebiso miyomoo tugusaloso egeesee howaso, “Lodee, nayo a tekepo moodoolai goomogoga, a tekepo moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eseme Yesuye o deeso odoo egee sigolone egeesee takaso, “Ayo no tekepo palai goomogo. Esiga no tekepo pe,” diso. Eseme omapoo o kolo mapoo agagisa bia saga mauwe poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eseme Yesuye yo diye dolone to kitulugu sabolo egeesee takaso, “Nayo dileso no ayo tekepo pa goo ee odoo abo mapoo na takee. Esino, nee su tekepo pa goo ee, Godee ogo odoo ogo doloso domo badeli odoo yimapoo dileso eligi. Osoloso nee su tekepo pa omaga emegei di bi tenee, Moseseeye tei magoo goo ee dodolone, odoo susuga oso ogoloso tekepo pa ee gooleedalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Esino odoo susuga oso Yesuwo goo ee mi susuga mapoo oposusumo dime, odoo susuga oso dulugaso. Eseme odoo susuga oso Yesuye Godeeyo to taka ee dulame sibadeeso. Osoloso Yesuye dimapoo paigiga egee molo tekepo palame. ");
INSERT INTO kkc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Esino Yesu biame susuga dimaga peegoo dileso, odoo koola mauwe mi mapoo Godee mapoo takalame diliso. ");
INSERT INTO kkc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Biame heeso Yesuye odoo susuga eligimolome, Pelisi odoo sabolo tei eligili odoo sabolo diba onosee omapoo debeiso. Odoo hagee bia Gelili mi susuga maga, osoloso abo oso Yudiya mi maga, osoloso odoo abo oso Yelusalem mi maga sibadeeso. Eseme Yesuye odoo paigiga susuga tekepo moodoogalame Godeeye kitulugu oso yibolo meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eseme mi omapoo odoo aboso odoo su kakawa poogoo kida mapoo magoloso tosimiso. Osoloso diayo yo Yesuye badebei mapoo todilame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Esino odoo beiga Yesu mapoo dilei eli egele. Eseme diayo odoo su kakawa poogoo kida sabolo moso omu ma dokodoo imado palaso. Osoloso Yesuye to kemelee domo omaga seme ou tologo poogoloso tiso kida mapoo bagagoloso kida sabolo moso kulodu toosooso. ");
INSERT INTO kkc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Diayo odoo su kakawa poogoo moso omu maga toosooloso goolee, odoo egee yayo moodoolai teiba doloso, Yesuye dia tei too ogoloso, odoo su kakawa poogoo mapoo egeesee takaso, “Mo odoo, nee goo tokenee olo hapoloso boobado buguso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eseme omapoo debei tei eligili odoo sabolo Pelisi odoo sabolo oso o to duloso, dieso nediliyo egeesee gooleemeleeso, “Odoo hagoso kaseme egeesee ka takayo? Yayo Godee dagadilame see, esino goo tokenee hapeli hedebe Godeeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Eseme Yesuye diayo dibada sooloo ma kulodu gooleemelee goo ee gooleedoloso dimapoo egeesee takaso, “Niyo kasi maga nibada sooloo ma kulodu egeesee ka goolee malala? ");
INSERT INTO kkc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Niba odoo su kakawa poogoo hagee ege. Yimapoo goo kasee takalai oso sebe ka mololo? Ayo odoo su kakawa poogoo mapoo ‘Nee tokenee ayo boobado buguso,’ dee takooga, o tokenee boobado bugu niyo gooleedalaime. Esino ayo yimapoo takoo, ‘No toboloso nee kida toloso di,’ dee takoloso, yo tobooga, amapoo odoo moodeli kitulugu molo doloso niyo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Esino Odoo Holo amapoo kitulugu olo teneeso, mipoo hamapoo goo tokenee hapoloso boobado bigilei goo ee niyo ogoloso gooleedalame, ayo nimapoo eligileiso,” doloso yayo odoo su kakawa poogoo mapoo egeesee takaso, “No hogabuloso nee kida toloso mosopoo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Diayo balaga molome odoo su kakawa poogoo hogabuloso, o kida toloso o mosopoo dulone Godee mapoo goomoga poudoomo diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Diayo odoo su kakawa poogoo toboloso di ogoloso diya howoogadooso, osoloso Godee mapoo goomoga poudooso. Osoloso diayo obulone egeesee takaso, “Iba epei goo toowa mudu opusomo di egeiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Goo hagee koodobuloso hamamee, Yesu moso kuloduga peegoo gadiso. Eseme yayo dulone egeino, tekisi molee misigeli odoo Libai tekisi molee misigeli moso kulodu badoboome egeiso. Osoloso Yesuye yimapoo egeesee takaso, “Ama hamamee sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eseme Libaiye bi susuga omapoo poogoloso Yesuye di hamamee diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Eseme Yesuye Libai yo idoo goo omaga Libaiye o mosopoo nei toowa siso. Eseme tekisi molee misigeli odoo bei sabolo osoloso odoo abo sabolo Yesubolo nei nameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Esino Pelisi odoo sabolo osoloso tei eligili odoo sabolo oso goo hagee ogoloso gowoolone Yesu o hamamee dili odoo mapoo egeesee woosaso, “Niyo kaseega tekisi molee misigeli odoo sabolo osoloso goo tokenee teli odoo sabolo nei nologolone ka dabala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Eseme Yesuye nei dimapoo egeesee takaso, “Odoo paiye mauwe melesenee neli odoo mapoo dileime. Esino odoo paiye ee melesenee neli odoo mapoo dileiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ayo simi hagee, Godeeyo howo woola tekepo teli odoo doloso gweli odoo ee gilimalame ka sibile. Esino tokenee teli odoo doloso gooleedoo odoo ee gilimadoloso Godee mapoo sibilame ka simi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eseme odoo aboso Yesu mapoo egeesee takaso, “Yoneeyo hamamee dili odoo oso howo gisilone nei tei doloso debeliso. Osoloso Pelisi dia hamamee dili odoo sabolo egeseliso. Esino bei kasi maga nee hamamee dili odoo oso biame susuga nei sabolo howo sabolo ka nalagamalala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eseme Yesuye dimapoo egeesee takaso, “Edebeeyo sobo hulei biame omapoo yo o odoo abo sabolo osee doga, diba nei nelega dabalaisomo? Haye! Diayo sobo hulei odoo sabolo hodobo dobolone goomoga sabolo nei nalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Esino biame heeso odoo hagee dimaga peegoo ido duga, nei nelega tei doloso dabalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eseme Yesuye dimapoo wudu taka hee hagee takaso, “Edebeeyo o sedi dia koodoloso sedi nape mapoo opodoloso koo duseli. Egeeseega o sedi dia tokenee palaiso. Osoloso sedi dia koodoloso sedi nape mapoo opodoloso dusa ee sedi nape sabolo tebileime. ");
INSERT INTO kkc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Osoloso see edebeeyo wain i dia katolo gout be koloso moodoo nape mapoo koo salama seli. Bei, wain i dia oso kitulugu oso katolo be gout koloso moodoo nape ee gabuguga, wain i ee peegoo sologo bigileiso. Osoloso katolo gout be koloso moodoo ee tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Esiga wain i dia ee medee katolo gout be koloso moodoo dia mapoo salama salai tekepo. ");
INSERT INTO kkc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Esiga edebeeyo wain i nape naga, yo see wain i dia nalai koo goomegeli. Bei, yayo egeesee takalaiso, ‘Wain i nape ono diya hadali,’ dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yu odooso hasali biame heeso, Yesu o hamamee dili odoo sabolo witi wo segei ma kuloduga diyadaga meleeso. Osoloso o hamamee dili odoo oso witi wo ko ee gooloogaloso kolo soosoo poloso ko kulodu melee ono nalagamo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eseme Pelisi odoo abo oso goo hagee ogoloso dimapoo egeesee takaso, “Niba bei kasi maga ibada hasali biame mapoo witi wo ka gwayo? Niyo ibada tei gababuo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuye dimapoo to nei egeesee takaso, “Deibidiye o odoo sabolo houdume diayo moodoo goo ee Godeeyo toso booka mapoo hogugu niyo hesigeleyo? ");
INSERT INTO kkc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bei, Deibidiye Godeeyo tei moso ma kulodu gadileso tei wo toloso o odoo sabolo neso. Esino tei wo hagee Godee ogo odoo ogo doloso domo badeli odoo hedebe oso nali. Esino Deibidiye o odoo sabolo wo ne oso tei magoo ee gababiaso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuye dimapoo see egeesee takaso, “Niyo hasali biame egee Odoo Holo ayo wiligi doloso ka badoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","See Yu odooso hasali biame hee mapoo, Yesu Yu odoowo howo gisili moso ma kulodu gapeleso odoo mapoo eligimeleeso. Moso ee ma kulodu odoo dee deedee seeseegedoo poogoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Esino tei eligili odoo sabolo Pelisi odoo sabolo oso Yesu tokenee odoo dalame, Yesuwo goo ee medee balagamo silesibiso. Egeeseelone Yesuye dia hasali biame mapoo odoo dee deedee seeseegedoo poogoo tekepo moodabeleso bologolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Esino diayo goo goolee melee Yesuye ogoloso gooleedoloso, dee seeseegedoo poogoo odoo mapoo egeesee takaso, “No toboloso woola hamapoo sibileso tebee,” diso. Eseme dee seeseegedoo poogoo odoo oso woola dileso tabaso. ");
INSERT INTO kkc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Osoloso Yesuye Pelisi odoo sabolo osoloso tei eligili odoo sabolo mapoo egeesee takaso, “Ibada tei goo oso ibada hasali biame mapoo ogoo goo takoosomo? Biame omapoo goo tekepo talai ee tekepowo? O, goo tokenee talai ee tekepowo? Osoloso tei goo oso imapoo ibada hasali biame omapoo odoo gie badeli pidilei goo ee takoosomo? O, odoo gie badeli wooloomalai goo ee takoosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesuye dimapoo egeesee takoloso, see dimapoo bolone odoo dee seeseegedoo poogoo mapoo egeesee takaso, “Nee dee seeseegedoo poogoo egee see hoodode,” diso. Eseme odoo dee seeseegedoo poogoo oso o dee hoododeme o dee see tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eseme Pelisi odoo sabolo tei eligili odoo sabolo oso goo hagee ogoloso diya komonogolone dieso nediliyo dima kulodu Yesu toloso kasee woolaisomo, doloso to mouso. ");
INSERT INTO kkc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Biame domo mapoo Yesu mubi ma dokodoo peleso gesi hedebe omapoo Godee mapoo takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eseme mi hadobume Yesu yima hamamee dodomo silesibili odoo susuga gilimadooso. Osoloso dima kulodu odoo 12 ono toloso, dimapoo diye di hu teneeso. Yesuye gilimadoo 12 odoo dia hu hagoso. ");
INSERT INTO kkc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon (odoo hagee Yesuye o hu hee Pita hediso), osoloso Saimonowo omolo Endulu sabolo, osoloso Yemes, osoloso Yonee, osoloso Pilipi, osoloso Batolome, ");
INSERT INTO kkc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","osoloso Matiyu, osoloso Tomas, osoloso Alpiyeseeyo owolo Yemes, osoloso Loum gamalee odoo mapoo ha teli odoo Saimon, ");
INSERT INTO kkc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","osoloso Yemeseeyo owolo Yudas, osoloso Yudas-Iskaliyot (yayo hamamee Yesu ha teli odoo dimapoo tiasooso). ");
INSERT INTO kkc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuye o hamamee dili odoo 12 sabolo mubi dokodooga meileso kubo mapoo debeiso. Diba omapoo meileso dobolone egeino, Yesu o hamamee dili odoo susuga sabolo, osoloso odoo abo susuga Yudiya maga osoloso Yelusalem maga osoloso abei toowa palaga debeli Taya mi sabolo Saidon mi sabolo omaga sibileso doboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Diayo Godeeyo to Yesuye taka ee dulame sibadeeso. Osoloso paiye dimapoo melee tekepo palame sibadeeso. Egeesi ma kulodu Yesuye odoo ma kulodu bo holoso dala tenemelee ee dimaga peegoo hasiso buguso. ");
INSERT INTO kkc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Odoo susuga oso Yesuwo kolo sigilame goomogaso. Bei, diayo egeino kitulugu Yesu maga simi oso odoo susuga tekepo moodooga neme. ");
INSERT INTO kkc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuye o hamamee dili odoo mapoo bolone egeesee takaso, “Bi mauwe odoo niba goomege. Bei, Godeeye wiligi doloso badeli ee ma kulodu niba gasibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Odoo epedee hodia hagee do, niba goomege. Bei, hamamee niba nei nameleso diya edigileiso. Osoloso goohele sabolo egee pupusiga molo, niba goomege. Bei, niyo goomogalai biame ee nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Odoo Holo mo goo maga edebeeyo niba heigoga, niba goomege, osoloso diayo niba tokenee odoo doloso gowoolone managa niba goomege. ");
INSERT INTO kkc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Esiga domo omapoo goomoga toowa sabolo debee. Bei, Kei mi ma dokodoo niyo talai nei ee nibada hu sabolo olo mopoodoo doloso moloso. Esiga niyo medee goolee, nimapoo dala teneli odoo egee bia dia amawe dio oso Godee maga to toloso kokodo takomo silesibili odoo daga hoogoo debei mapoo dala hedebe hageesee masi tenemeleeso.” ");
INSERT INTO kkc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ye-ee! Bi bei odoo niba obeeyamo! Bei, niso goomoga goo olo tooso. ");
INSERT INTO kkc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ye-ee! Niba epedee nei naloso oduguloso egee do odoo, niba obeeyamo! Bei, hamamee nimapoo hodia goo toowa oso sibileiso. Ye-ee! Yiligeli odoo niba obeeyamo! Bei, hamamee niba goohele goo sabolo dobolone pupusiga malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ye-ee! Odoo susuga oso niba tekepona deli odoo niba obeeyamo! Bei, nimapoo tekepona deli odoo egee bia dia amawe dio oso gamenee godee maga to toloso kokodo takomo sili odoo onosee diba tekepo odoo dee takaga meleeso.” ");
INSERT INTO kkc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mo to duli odoo, ayo nimapoo ka taka, nimapoo ha teli odoo ee sooloo dele osoloso niba hegili odoo mapoo goo tekepo moodee. ");
INSERT INTO kkc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nimapoo duwa takeli odoo dimapoo goo tekepo tolone dimapoo goomoga tenee. Osoloso nimapoo dala teneli odoo diba halo Godee mapoo takee. ");
INSERT INTO kkc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Osoloso odoo heeso nee haleegi mapoo kobuguga, see nee haleegi hodio mapoo kobugulame heligi magalai tekepo. Osoloso odoo heeso nee kekeisu sedi tadoduga, see yimapoo nee sedidee tenee. ");
INSERT INTO kkc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Osoloso odoo heeso namapoo bi howaga yimapoo wulo tenee. Osoloso odoo heeso nee bi toloso toduga nayo nei yimaga see peedee dalame na takee. ");
INSERT INTO kkc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Esiga edebeeyo nimapoo ogoo goo moodoolame ka gooleesomo, nei niyo dimapoo goo hedebe egeesi masi moodoolai tekepo. ");
INSERT INTO kkc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Niyo hedebe niba sooloo deli odoo mapoo sooloo dolone doga, odoo aboso niba tekepo odoo dalaisomo? Haye. Bei, tokenee teli odoo oso diba sooloo deli odoo mapoo nei diayo sooloo deliso. ");
INSERT INTO kkc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Osoloso niyo hedebe nimapoo goo tekepo moodeli odoo mapoo tekepo moodooga, edebeeyo niba tekepo odoo dalaisomo? Haye. Bei, tokenee teli odoo diba nosee egeesee seliso. ");
INSERT INTO kkc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Niyo teneega nei tobuloso teneli odoo hedebe mapoo bi ka tenee domologa, edebeeyo niba tekepo odoo dalaisomo? Haye. Bei, tokenee teli odoo diba nosee egeesee seliso. Diayo nei talai ee goolone dia bi odoo abo mapoo tenee deliso. ");
INSERT INTO kkc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Esino niba nimapoo ha teli odoo mapoo sooloo dolone ka debee. Osoloso dimapoo goo tekepo moodee. Osoloso dimapoo bi wulo wulayo teneloso see nei talai doloso na goolee. Niyo goo hageesi tolone doga, niba nei toowa talaiso. Osoloso niba dokodoo badeli Godeeyo owolo dalaiso. Bei, Godeeye yimapoo goomoga to koo takeli odoo sabolo osoloso tokenee teli odoo sabolo mapoo goo tekepo tenelone ka badoso. ");
INSERT INTO kkc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nibada Ama Godee yo emegei sooloo dolone badoso. Esiga niba nosee emegei sooloo dolone ka debee.” ");
INSERT INTO kkc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nayo nee odoo heeyo goo ee goo mauwe na midi, eseega nei nee goo midileime. Osoloso nee odoo ee tokenee odoo dee na takee, eseega nei no tokenee odoo dalaime. Osoloso nee odoo oso namapoo goo tokenee toga, nayo o tokenee goo ee boobado bigi. Nayo egeesee seega nei nee goo tokenee onosee boobado bigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Esiga nayo wulo tenemologa, no nei talaiso. Nayo odoo abo mapoo tenemologa, nei Godeeye namapoo toowa tenelaiso. Esiga Godeeye namapoo tenee goo hagoso bei molone abo peegoo misigedibileiso. Nayo bi kasee nee odoo mapoo ka teneesomo, nei Godeeye nei teiba egeesi namapoo tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Osoloso Yesuye see wudu takolone egeesee takaso, “Odoo howo si oso o odoo hee howo si ido dilei tekepowo? Haye. Bei, o bakadio wulu mapoo tigedibigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Esiga holaiso goo goolee gie tomolo oso o eligili odoo oso gooleedoo ee dagadileime. Haye. Esino yo o eligili odoo oso holaiso medee kibiya eligiga, holaiso yayo gooleedoo goo ee o eligili odoo oso gooleedoo goo sabolo tebileiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nayo kasi maga nee odoowo howo mapoo gelesi pepooko egee molo medee ogolone, hee nee howo mapoo homo toowa egee molo egelega ka pagala? ");
INSERT INTO kkc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Osoloso nee howo mapoo homo toowa egee molo egelega no see kaseega nee odoo mapoo takolone, ‘Nee howo mapoo gelesi pepooko egee molo ayo tabiga,’ dee ka takeliyo? No tei goo goolee bakadio gweli odoo. Bei, daga nee howo mapoo homo toowa egee molo ee tabigi. Egeeseega nee odoowo howo mapoo gelesi pepooko egee molo medee ogoloso nayo tabigilei tebileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Esiga homo ko tekepo peli oso ko tokenee koo peli. Osoloso homo ko tokenee peli oso ko tekepo koo peli. Haye. ");
INSERT INTO kkc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bei, homo susuga ee ko oso pa maga goolee deliso. Esiga pigi ko sabolo geleipi ko sabolo oso wulo homo hee mapoo ko koo peli. Haye. ");
INSERT INTO kkc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Esiga odoo tekepo oso o sooloo ma kulodu goo tekepo egee molo ee o maga maga woola yilige bigiliso. Osoloso odoo tokenee oso o sooloo ma kuloduga goo tokenee ee woola yilige bigiliso. Esiga ogoo goo oso odoo sooloo ma kulodu bei mologa, o maga maga goo egeesee takamalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Niyo kasi maga amapoo ‘Lodee, Lodee,’ dolone dobolone hee nei ayo taka goo ee telega ka poogoosomo? ");
INSERT INTO kkc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Odoo agayo amapoo sibileso mo to duloso mesimo siloga, yo egeesee badalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yo edebeeyo moso togolone mi nelegedi dooloso omou sooloso moso tegei egeesi masi badoso. Bei, howo duwolone howo ki simi oso moso omapoo weiso. Esino moso egee dabisile. Bei, moso medee kalawa tegeiga. ");
INSERT INTO kkc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Esino odoo agayo mo to duloso mesilega siloga, yo odoo heeso moso togolone omou mi nelegedi doolega, moso tegei egeesi masi badoso. Bei, howo duwolone howo ki simi oso moso omapoo woome kibilega saga goboloso guobuguso.” ");
INSERT INTO kkc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu goo susuga odoo mapoo eligimelee koodobuloso see Kapeniyum mi mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kapeniyum mi mapoo Loum ha teli odoo 100 gibadeli odoo badebeiso. Esino domo omapoo yo o tou teli odoo hee paiye oso talai koola taba molome egeiso. Osoloso yayo o tou teli odoo egee bia diya gweliso. ");
INSERT INTO kkc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Esiga yayo Yesuye simi duloso Yu odoowo wiligi odoo tebisa abo mapoo Yesu idilame diye diso, Yesuye sibileso o tou teli odoo ee tekepo palame. ");
INSERT INTO kkc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Osoloso Yu odoowo wiligi odoo tebisa egee bia oso sibileso Yesu mapoo howolone egeesee takaso, “Iba diya goomogo, nayo dileso ha teli odoo gibadeli ee pidilei. ");
INSERT INTO kkc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bei, yayo ibada odoo halo ibada howo gisili moso tegeiso.” ");
INSERT INTO kkc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eseme Yesu to hagee duloso dibolo diso. Yesu moso koola mapoo dimeleeno, ha teli gibadeli odoo oso o odoo abo diye neme, diayo sibileso Yesu mapoo egeesee takaso, “Ha teli odoo gibadeli odoo oso namapoo to egeesee taka, nayo o moso mapoo dilei yo koo goomogogona. Bei, yo tokenee odooga, no o moso mapoo na sibiyena. ");
INSERT INTO kkc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Esiga yo see nayo bado mapoo sibilei koo goomogogona. Esino yo goomogogona nayo wulo no egee bado maga toso takeeyena o tou teli odoo ee tekepo palame. ");
INSERT INTO kkc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Osoloso yayo see egeesee taka, yo odoo abo ma hemiduga tou tolone dia to mapoo mesiloso siliso. Osoloso yima hemi tou teli odoo abo dosogona. Esiga yayo dimapoo koo diye daga diliso. Osoloso yayo odoo hee mapoo no hamapoo sibeye daga sibiliso. Osoloso goo egee teye daga, yo see goo egee tobuloso teliso. Esiga yo goo egeesee teliga nayo see wulo hamaga badolone toso takeeyena, o tou teli odoo ee weidilame.” ");
INSERT INTO kkc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eseme Yesuye ha teli odoo gibadeli odoo oso to taka duloso diya howoodooso. Osoloso odoo mooloogoodoo yima hamamee simi omapoo bidi toboloso dimapoo bolone egeesee takaso, “Ayo nimapoo taka, ayo Isalael mi mapoo silee ee ma kulodu odoo kibiya tei too odoo hee egeesi egele,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Osoloso ha teli gibadeli odoo oso diye di odoo diayo see wedi dileso egeino, ha teli gibadeli odoo eyo tou teli odoo ee weidiloso badoboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Osoloso biame abo olo poogoloso hamamee Yesu mi hee Nein mapoo diso. Eseme o hamamee dili odoo sabolo osoloso odoo abo susuga oso yo dodomo diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesu dileso beelee osulu miyopoo dumolome odoo aboso edebeeyo bia mi maga giso holo gie kauwa ta eyo su imadoloso sibadeeso. Giso holo ta hagee sobo bau heeyo owolo hedebe oso. Osoloso odoo susuga oso sobo bau sabolo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lodeeye sobo bau hagee ogoloso yo diya sooloo dolone yimapoo egeesee takaso, “Haga na pise,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eseme Yesuye dileso giso holo ta eyo su magoo sa tegei homo su mapoo sigime, odoo ta imadoloso diyadee diba omapoo kookoodabaso. Eseme Yesuye giso holo ta yimapoo egeesee takaso, “Mo holo, ayo namapoo takooso, no tebee!” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eseme giso holo yo hogabuloso badolone to kemeleeso. Eseme Yesuye giso holo yo owee mapoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Odoo susuga oso goo hagee ogoloso diya dio dulone Godee mapoo goomoga goo poudo demeleeso. Egeeseelone diayo egeesee takaga meleeso, “Godee maga to toloso kokodo takomo sili kitulugu odoo oso imapoo peledabadoo. Osoloso Godeeye o odoo pidilame olo simidoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Edebeeyo Yesuye goo moodoo ogoloso Yu odoowo mi Yudiya mi susuga mapoo osoloso mi abo koola omapoo oposusumo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yonee o hamamee dili odoo oso Yesuye goo tomo silee ee Yonee mapoo takaso. Eseme Yoneeye goo hagee duloso o hamamee dili odoo bakadio oso dileso, Yesu mapoo hageesee woosalo egeye diso, ");
INSERT INTO kkc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“No tei Keliso iyo hagee bamolo osomo? O, iyo odoo hee bamalaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eseme Yoneeyo hamamee dili odoo oso dileso, Yesu mapoo egeesee takaso, “Yonee odoo howo oluguli oso iba namapoo sibeye dolone egeesee taka, ‘No tei Keliso iyo bamelee osomo? O, iyo see odoo hee bamalaiyo?’ dee taka,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Esino biame domo omapoo Yesuye odoo paigiga sabolo osoloso odoo bo holo paladee sabolo osoloso odoo howo siliga sabolo tekepo moodoomo sileeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yayo egeeseemo silone Yonee o hamamee dili odoo mapoo egeesee takaso, “Niba see wedi dileso Yonee mapoo niyo egei goo sabolo osoloso niyo du goo sabolo takee. Bei, odoo howo siliga oso see medee ogowa. Osoloso odoo kido tigediba sabolo see tekepo poloso silesiboso. Osoloso odoo kolo e bia sabolo tekepo poloso silesiboso. Osoloso odoo dulu tabaga nosee tekepo poloso to taka dulugamo silesiboso. Osoloso odoo wedia sabolo hogogabuloso see silesiboso. Osoloso to tekepo hagee bi mauwe odoo oso duluga moloso. ");
INSERT INTO kkc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Esiga odoo agayo ayo goo moodoo ee ogoloso diayo amapoo tei too goo ee pegelega poogooga, Godeeye dimapoo goomoga goo tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yonee o hamamee dili odoo oso see wedi dime Yesuye odoo mapoo Yoneeyo goo ee takalame bei mooloogooso. Osoloso yayo egeesee takaso, “Niba miwe poogoo mi mapoo ogoo goo agalame ka diyo? Pooso siboga obuso dabisa ee agalame ka diyo? ");
INSERT INTO kkc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Niba edebeeyo dugo tekepo kaloso badoboome ee agalame ka diyo? Haye. Bei, dugo tekepo kalagali odoo ee wiligi odoo oso debeli moso tekepo mapoo debeli. ");
INSERT INTO kkc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Esino niba wulo Godee maga to toloso kokodo takomo sili odoo ee agalame ka diyo? O. Niyo dileso egei odoo Yoneeye Godee maga to toloso kokodo takomo sili odoo daga hoogoo debei yayo dagadiso. ");
INSERT INTO kkc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bei, Godeeyo to booka mapoo hogugu oso egeesee egee takoo, o goo ee takooso, ‘Ayo mo to tosili odoo yo daga malalo diye dalaiso. Yayo nee eli hoodo magalame.’ ");
INSERT INTO kkc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Esiga ayo nimapoo taka, odoo daga hoogoo debei susuga ee Yoneeye dagadileso badoso. Esino Godeeye wiligi doloso badeli mapoo odoo wuluge oso Yonee dagadileso ka badoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Odoo susuga sabolo osoloso tekisi molee misigeli odoo abo sabolo to hagee duloso Godeeyo goo ee tekepo diso. Bei, diba nosee Yoneeye howo ogusigaso. ");
INSERT INTO kkc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Esino Pelisi odoo sabolo osoloso tei eligili odoo sabolo oso Godeeye goomoga goo diayo ee talai gowoolone diba howo ogusigilega poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Osoloso Yesuye see egeesee takaso, “Epedee domo hamapoo egee do odoo ee odoo kasi masiyo? ");
INSERT INTO kkc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Diba holaiso masi go domo mapoo dobolone emegei dimapoo nei takoo nei takoo dolone dobolone egeesee takaga meliso, ‘Iyo goomoga kosaiya poume niba hepele, osoloso iyo goohele kosaiya poume niba pupusigele.’ ");
INSERT INTO kkc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Niba odoo egeesi masi doso. Bei, Yonee odoo howo oluguli oso simi ee yo wo sabolo wain i sabolo namo sile. Esino niyo yo bo holo paladoo dee takeliso. ");
INSERT INTO kkc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Osoloso hamamee Odoo Holo anosee olo simiso. Ayo sibileso wo sabolo wain i sabolo namo siloga, niyo a wo sabolo yugune sabolo dooboo nali odoo deliso. Osoloso niyo a tekisi molee misigeli odoo sabolo osoloso tokenee teli odoo sabolo hedebe doloso ka badeli deliso. ");
INSERT INTO kkc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Esino odoo agayo Godeeye goo goolee tekepo gooleedoloso tomo siloga, yayo Godeeye goo goolee ee tekepo dolone ka eligiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Biame heeso Pelisi odoo Saimonoye Yesu idoloso o moso mapoo nei nalame diso. Eseme Yesu Saimonowo moso mapoo nei nalame biaso. ");
INSERT INTO kkc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi omapoo goo tokenee teli sobo hee badebeiso. Esino yayo Yesuye Pelisi odoowo moso mapoo nei namelee goo ee duloso sisigageli i medee tekepo yoso moodoo howogi mapoo salamasoloso tosimiso. ");
INSERT INTO kkc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Osoloso Yesuwo miligi maga gauwuloso pusulone o didawoso Yesuwo homo balagieso. Osoloso yayo see Yesuwo homo mapoo o wudu oso tolone adameleeso. Osoloso sisigageli i medee tekepo oso Yesuwo homo mapoo soomeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Osoloso Pelisi odoo Saimonoye goo hagee ogoloso egeesee goolee meleeso, “Odoo hagee tei Godee maga to toloso kokodo takomo sili odoo oso diepi, soboso yo sige medee hoodo egeliyo. Bei, sobo hagee goo tokenee teli sobo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eseme Yesuye Pelisi odoo mapoo egeesee takaso, “Saimon, ayo namapoo goo takalai, a goomogo,” diso. Eseme Saimonoye egeesee takaso, “Eligili odoo, takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Eseme Yesuye yimapoo egeesee takaso, “Odoo heeso odoo bakadio mapoo molee teneeso. Egeeseelone yayo odoo hee mapoo molee ko 500 tenelone, odoo hee mapoo hedebe molee ko 50 teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Esino hamamee odoo bakadio hagee bia dimapoo molee mauwe poogoome, nei o hedebe egeesi yimapoo tenelega poogooso. Eseme bi eyo amameeye goo hagee ogoloso dimapoo egeesee takaso, ‘Bige boobado bigi,’ diso. Esiga odoo bakadio hagee ma kulodu odoo hee kaso bi eyo ama diya ka gooleebuguba?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eseme Saimonoye nei yimapoo egeesee takaso, “A goolee, molee toowa too odoo oso ama diya goolee malaiso,” diso. Eseme nei Yesuye Saimon mapoo egeesee takaso, “Nayo tei goo takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesuye sobo mapoo bolone Saimon mapoo egeesee takaso, “No sobo hagee ege! Ayo nee moso mapoo sibume, nayo mo homo hapalame howo amapoo tenele. Esino sobo hagoso o didawoso mo homo hapoloso see o wuduso mo homo taso. ");
INSERT INTO kkc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Osoloso ayo nee moso sibume nayo goomogolone a edele. Esino ayo nee moso mapoo simi domo omaga sobo hagoso mo homo mapoo adamelee koodobile. ");
INSERT INTO kkc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Osoloso nayo olipi i oso mo wiligi mapoo soole. Esino sobo hagoso sisigageli i medee tekepo oso mo homo mapoo sooso. ");
INSERT INTO kkc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Esiga ayo namapoo taka. Sobo hagee o goo tokenee susuga olo hapoloso boobado buguso. Esiga sobo hagoso a diya goolee goo ee weliga yilige buguso. Esino odoo agayo ayo o goo tokenee pepooko hedebe hapoloso boobado buguga, yayo a goolee goo ee haga toowanee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Osoloso Yesuye sobo omapoo egeesee takaso, “No nee goo tokenee susuga ee olo hapoloso boobado buguso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eseme odoo abo yibolo hodobo dobolone nei nalaga melee odoo oso goo hagee ogoloso dieso nediliyo dima kulodu egeesee takaga meleeso, “Odoo hagee odoo ogumo? Yayo goo tokenee hapoloso kasee boobado bugu domo ka silosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Diayo egeesee takomolome Yesuye sobo yimapoo egeesee takaso, “Nayo tei too goo maga badoboso kookaiyo gie badeli nayo olo tooso. Esiga no goomoga sabolo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Goo hagoso dileso koodobume, Yesuye to tekepo Godeeye wiligi doloso badeli goo ee eligimo silone, mi hee maga mi hee mapoo du domo silesibiso. Osoloso o hamamee dili odoo 12 yibolo hodobo sileeso. ");
INSERT INTO kkc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Osoloso sobo paigiga Yesuye tekepo moodoo sabolo osoloso sobo bo holo paladee Yesuye tekepo moodoo oso Yesubolo sileeso. Sobo egee bia hagoso: Meli, o hu hee Magadalin. Yesuye sobo hageeyo kuloduga bo holo 7 peegoo hasiso buguso. ");
INSERT INTO kkc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Osoloso sobo hee Helodeeyo moso bali odoo hee Kusayo osobo Yowana, osoloso Susana, osoloso sobo abo dibolo silesibiso. Sobo hagee bia oso Yesu sabolo osoloso o hamamee dili odoo sabolo dimapoo diayo dia molee oso diba pidimo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Odoo susuga mi opusomo opusomo di maga sibileso mooloogoodeme Yesuye wudu taka hamaga oposususo, ");
INSERT INTO kkc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Biame heeso odoo hee witi wo ko segelame diso. Yo witi wo ko sogomo sileeme, ko abo eli domo mapoo misigedibaso. Eseme edebeeyo eli omaga silesibulone witi wo ko dia homoso topoomo dime sóso sibileso neso. ");
INSERT INTO kkc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eseme witi wo ko abo ee yugogisi mi mapoo misigedibaso. Osoloso bou gasibileso palame sino haga booloogelega wediaso. Bei, yugogisi mi ee ma kulodu howo mauwega. ");
INSERT INTO kkc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Osoloso witi wo ko abo obu ma kulodu misigedibaso. Esino haga booloogelega saga paladeeso. Esino oso polone obu sabolo palaga tiso tiadolone witi wo susuga wediaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Osoloso witi wo ko abo mi tekepo mapoo misigedibaso. Osoloso bou pisaloso kauwuloso ko diya palagaso. Eseme witi wo ko susuga oso ko pa homokoko 100 egeesi oso palagaso.” Yesuye to hagee takoloso tobudulone toso neligidi egeesee takaso, “Odoo niba dulubolo, esiga ayo hagee takoo medee hoodo dui!” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesuwo hamamee dili odoo oso Yesu mapoo egeesee takaso, “Wudu taka goo hageeyo bei kasiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo Godeeye wiligi doloso badeli goo ee ogoloso gooleedalaiso. Bei, daga Godeeye wiligi doloso badeli goo ee mada meleeso. Esino epei nimapoo woola ka yilige buguso. Esino odoo abo mapoo ayo biame susuga wudu takeliso. Bei, ‘diayo ogoloso medee kibiya egelega pagalame. Osoloso diayo duloso goo eyo bei medee kibiya gooleedelega pagalame.’ ");
INSERT INTO kkc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Esiga wudu taka goo eyo bei hagoso: Witi wo ko ee Godeeyo to oso. ");
INSERT INTO kkc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Esiga odoo abo witi wo ko eli domopoo misigediba egeesi masi doso. Diba to tekepo duliso. Esino Godeeyo to hagee dibada sooloo ma kulodu egee molo ee boobado bigilame Saitenso dimapoo boobado bigili goo teneliso. Bei, diayo to omapoo tei toloso gie badeli teyaga. ");
INSERT INTO kkc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Esiga odoo abo witi wo ko yugogisi mi mapoo misigediba egeesi masi doso. Esiga diba Godeeyo to taka duloso goomoga sabolo medee teliso. Esino witi wo ko oso yugogisi mi mapoo polone o too medee meilega poogoo egee, diba onosee egeesee seliso. Godeeyo to oso dibada sooloo ma kulodu too medee koo meili. Osoloso diayo Godeeyo to duloso biame deiyepo mapoo wulo tei teliso. Esino diayo Godeeyo to mapoo tei too maga, hegi goo sabolo dala goo sabolo oso dimapoo siboga, diayo Godeeyo to mapoo tei too goo ee saga pegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Osoloso odoo abo witi wo ko oso we ti kauwe kadee ma kulodu misigediba egeesi masi doso. Diba Godeeyo to duloso to ee teliso. Esino mi toowayo gie badeli goolee sabolo, osoloso bi bei doloso dabalai goo gweli sabolo, osoloso dibada su oso goomoga goo ee goolee sabolo diyadulone dibada tei too tokenee peliso. Goo egeesi maga diayo tei too goo oso homokoko masi koo peli. ");
INSERT INTO kkc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Osoloso odoo abo witi wo ko mi tekepo mapoo misigediba egeesi masi doso. Diayo dibada sooloo ma kuloduga tekepo goo gweli sabolo osoloso goomoga sabolo Godeeyo to duloso dibada sooloo ma kulodu medee tei teliso. Osoloso diayo o to kibiya kookoodoloso, dobolone homokoko masi diya peliso.” ");
INSERT INTO kkc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Edebeeyo keme pouloso tolo oso koo gagali, osoloso mada koo mageli. Yo keme pouloso woola mapoo pou mageliso, edebeeyo moso kulodu gasibileso gadeebugu ee agalame. ");
INSERT INTO kkc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bei, goo susuga epedee mada egee molo, see hamamee odoo susuga oso agalame woola peledabalaiso. Osoloso odoo susuga oso koo duli goo ee see odoo susuga oso dulame woola yilige bigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mo to hagee niyo medee dui. Bei, to taka medee duli odoo mapoo Godeeye goo goolee tekepo tenelaiso. Esino edebeeyo eyo nediliyo yo Godeeye wiligi doloso badeli goo ee yo gooleedoo doloso mo to dulega poogooga, Godeeye yimapoo goo goolee pepooko egee molo see eyo peedee dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Biame heeso Yesuwo owee sabolo omolo dio oso Yesu agalame sibadeeso. Esino odoo bei diya mooloogoodoloso ka doboome, diba Yesuye badebei mapoo hodu dilei tebile. ");
INSERT INTO kkc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eseme odoo heeso diba ogoloso, Yesu mapoo egeesee takaso, “Noowee sabolo osoloso nomolo dio sabolo oso peegoo no agalame balaga moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eseme Yesuye odoo mooloogoodoo mapoo nei egeesee takaso, “Edebeeyo Godeeye eligi goo ee duloso mesimo silesiboga, diba mo wee dio osoloso molo dio oso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Biame heeso Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Iba abei hodiokoo dalo soowoomo,” diso. Eseme diba du mapoo bulumaloso soowadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Diba abei domopooga damolome, Yesu tila poogoome tiaso. Eseme haga booloogelega i toowa sibume, abei omapoo howo ki toowa simiso. Eseme howo ki toowa oso sibulone dibada du ma kulodu howo sasoo oso diba dia du sabolo howomoo owulame siso. ");
INSERT INTO kkc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eseme Yesu o hamamee dili odoo oso dileso, Yesu tidilone egeesee takaso, “Wiligi odoo, iba howomoo owuloso wedilame see!” diso. Eseme Yesu tia hogabuloso tobudulone i sabolo howo ki sabolo koodobilame to kitulugu sabolo takaso. Eseme i sabolo howo ki sabolo simi saga omapoo koodobiaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eseme Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Niyo tei too kasomo?” diso. Eseme Yesuwo hamamee dili odoo oso goo hagee ogoloso howoogadoloso obugulone diesono egeesee takaga meleeso, “Odoo hagee odoo ogumo? I sabolo howo ki sabolo o to duloso koodobiaso,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Osoloso Yesu o hamamee dili odoo sabolo Gelili mi maga abei daloso Gelasa mi mapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu du maga widi pee mapoo pubalogolone egeino, odoo bo holo pala oso yo tugodalame sibume egeiso. Odoo hagee daga hoogoo dobudu boodo diwe silone biame susuga odoo bi mapoo badeli. ");
INSERT INTO kkc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bei, bo holo oso kitulugu oso yimapoo toga edebeeyo ki tiso yo tialogoloso mageliso. Esino bo holoso kitulugu oso ki tiso tialogoloso magoo ee kookoobuguloso odoo ee idoloso dobudu diliso. Esino odoo hagoso Yesu ogoloso miyomoo gasuwoloso gwa sabolo tiamolone toso neligidi yimapoo egeesee takaso, “Dokodoo badeli Godeeyo owolo Yesu, nayo amapoo ogoo goo moodoolame ka simiyo?” diso. Osoloso yayo Yesu mapoo howoolone see egeesee takaso, “Nayo amapoo dala na tenee,” diso. Odoo bo holo pala oso to hageesee taka. Bei, daga Yesuye bo holo odoo ma kulodu egee bado mapoo takolone peegoo gasibeye, dee takeme ka taka. ");
INSERT INTO kkc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eseme Yesuye yimapoo egeesee takaso, “Nee hu ogumo?” diso. Eseme yayo to nei egeesee takaso, “Ibada hu ee Bei,” diso. Bei, bo holo susuga oso yima kulodu doso. ");
INSERT INTO kkc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eseme bo holo odoo ma kulodu debei oso egeesee takaga meleeso, “Nayo iba Dou mi mapoo na seesee peegee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eseme biame omapoo, esia ma dokodoo be hu susuga oso mooloogoo doloso, mi nalagamo silesibiso. Eseme bo holo odoo ma kulodu debei oso Yesu mapoo howoolone egeesee takaso, “Iba be ma kulodu galaga di dee takee,” diso. Eseme Yesuye dimapoo egeesee takaso, “Niba be ma kulodu galaga dilei soowa!” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Eseme bo holo susuga oso odoo ma kuloduga peegoo galaga dileso see be ma kulodu galaga diso. Eseme be susuga oso godobia maga kukolo meileso, howomoo wediaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eseme be bali odoo oso goo hagee ogoloso kukulo dileso dia mi mapoo osoloso mi pepooko abo mapoo goo egee takomo diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eseme odoo susuga oso goo hagee duloso ee agalame sibadeeso. Diba sibileso egeino, bo holo pala odoo ee tekepo poloso Yesuwo homo beiyopoo badolone goo goolee tekepo toloso dugo kaloso badoboome egeiso. Eseme diba diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eseme Yesuye odoo bo holo pala ee tekepo moodoome egei odoo oso diayo egei goo ee agalame sibadee odoo dimapoo oposususo. ");
INSERT INTO kkc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eseme Gelasa mosobia odoo susuga sabolo osoloso koola omapoo debeli odoo susuga sabolo oso Yesu mapoo egeesee takaso, “No mi hamaga saga peegoo di,” diso. Bei, diba Yesuye goo moodoo mapoo ogoloso diya obugume. Eseme Yesu dilame yo du mapoo dabagaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Eseme odoo bo holo pala Yesuye tekepo moodoo oso Yesubolo dilame goomogaso. Esino Yesuye yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Haye. No abolo na sibe. No nee mi mapoo see wedi dileso Godeeye namapoo goo toowa moodoo goo ee oposisi,” diso. Eseme odoo yo o mi mapoo see wedi dileso, Yesuye yo tekepo moodoo goo ee oposusumo sileeso. ");
INSERT INTO kkc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu see abei hodiokoo dalo sibume, yo bolone debei odoo susuga oso yayo simi ogoloso diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eseme omapoo haga booloogelega odoo hee, Yu odoo dia howo gisili moso gibadeli odoo taba, Yailaseeye, sibileso Yesuwo homo beiyopoo gawusoloso badolone Yesu mapoo howoolone egeesee takaso, “No mo mosopoo sibe! ");
INSERT INTO kkc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bei, mo sobo holo hedebe, o dugo 12, paiye oso olo talame soomoloso,” diso. Eseme Yesuye Yailaseeyo mosopoo dumolome eli domopoo odoo susuga oso yima hodu diya mooloogoo doloso dulone nei halagabugu nei halagabugu domo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Osoloso odoo mooloogoo doloso diyadee ee ma kulodu sobo hee aso wooloomaloso badebei sabolo diso. Yo aso wooloomaloso badebei ososee dugo 12 poogooso. Esino odoo heeso yo tekepo moodoolai tebile. ");
INSERT INTO kkc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Esino sobo hagoso Yesu dumolome, mada miligiyopooga sibileso Yesuwo dugo su mapoo sigeme, aso woolooma oso sawo soomelee omapoo saga koodobiaso. ");
INSERT INTO kkc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eseme Yesuye egeesee takaso, “Odoo agayo a ka sigoba?” diso. Esino odoo susuga oso Yesu sigile doloso diya pulugume, Pitaye Yesu mapoo egeesee takaso, “Wiligi odoo, odoo susuga oso nobolo hodobo dulone no ka sigo domo du,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eseme Yesuye nei egeesee takaso, “Haye. Egeesee sele. Odoo heeso a ka sigiwa. Eseme odoo weidilame moodeli kitulugu ama melee oso peegoo di mawo gooleedoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sobo hagoso goo moodoo ee mada magalai tebile doloso gooleedoloso kikiliga sabolo dileso, Yesuwo homo beiyopoo gasuwoloso badebeiso. Osoloso Yesuye sobo yo weidilame moodoo goo sabolo, osoloso yayo Yesu sige goo ee oposusume odoo susuga oso duso. ");
INSERT INTO kkc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eseme Yesuye sobo yimapoo egeesee takaso, “Mo sobo holo, no tei too maga no olo tekepo paso, esiga no mesie sabolo di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Osoloso Yesuye sobo yimapoo to takomolome, odoo heeso Yailaseeyo moso abaga sibileso, Yailas mapoo egeesee takaso, “Nee sobo holo olo ta moloso. Esiga nayo eligili odoo hamapoo wulo goo mauwe na ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Esino Yesuye goo hagee duloso Yailas mapoo egeesee takaso, “No haga na ebi, wulo amapoo tei te. Egeeseega nee sobo holo ta egee molo see weidileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Diba dileso mosopoo doboome, Yesuye dulone hedebe Pita, Yonee, Yemes, osoloso sobo holo eyo owee dio ama dio ono gilimadoloso, moso kulodu galagadiso. ");
INSERT INTO kkc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Diba moso kulodu galagadileso egeino, odoo susuga oso sobo holo ta ee halo pupusiga molome egeiso. Eseme Yesuye dimapoo egeesee takaso, “Niba egee pupusiga molo epedee omapoo koodobie. Bei, sobo holo yo koo ta moloso. Esino yo wulo tia moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eseme Yesuye egeesee taka duloso diba yiligaso. Bei, sobo holo oso ta diba olo egeiga. ");
INSERT INTO kkc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Esino Yesuye sobo holo ta eyo dee mapoo toloso yimapoo egeesee takaso, “Sobo holo, no tebee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eseme sobo holo ta ee o gie badeli see wedi sibume, yo hogabuloso tabaso. Eseme Yesuye dimapoo egeesee takaso, “Sobo holo mapoo nei tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Esino sobo holo eyo ama dio owee dio goo hagee ogoloso diya howoogadooso. Eseme Yesuye dimapoo egeesee takaso, “Niso egei goo hagee odoo abo mapoo na takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuye o hamamee dili odoo 12 gilimadoloso dimapoo kitulugu teneeso, diayo bo holo odoo ma kuloduga peegoo hasiso bugu domo silesibulone odoo paigiga sabolo tekepo moodoo dalame. ");
INSERT INTO kkc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Osoloso yayo diba diye diso, diayo dileso Godeeye wiligi doloso badeli goo ee odoo mapoo eligimo silesibulone, odoo paigiga sabolo tekepo moodoo dalame. ");
INSERT INTO kkc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Osoloso yayo dimapoo egeesee takaso, “Niyo dulone, susu, osoloso o, osoloso wo, osoloso molee, osoloso kali bi bakadio na todi, wulo hedebe todi. ");
INSERT INTO kkc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Niba mi omapoo dileso peledobooga, omapoo edebeeyo niba o moso mapoo ido pologa, moso hedebe omapoo tia melee. Osoloso niyo mi omaga mi hee mapoo dulone, mi egee wulo poogoo du domo silesibe. ");
INSERT INTO kkc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Osoloso niyo mi hee mapoo dileso edebeeyo niba o moso mapoo ido pelega poogooga, niba mi egee poogoo dulone, nee homo mapoo basago mologa omapoo tegene peegee, Godeeye komonolone dimapoo dia goo tokenee eyo nei tenelai goo ee gooleedalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Osoloso diba see diyadeeso. Diba mi hee maga mi hee mapoo du domo silesibulone, Godeeyo to tekepo takomo silesibiso. Osoloso odoo paigiga susuga see tekepo moodoo domo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yesuye moodoomo sili goo susuga ee Gelili mi ee bali odoo Helodee duso. Eseme goo hagee duloso yo diya goo tiadooso. Bei, odoo aboso Yesuwo goo mapoo egeesee takaso, “Yo Yonee odoo howo oluguli ta maga see ka hogabiadoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Osoloso odoo aboso egeesee takaso, “Yo Ilayadoo.” Osoloso odoo aboso egeesee takaso, “Yo Godee maga to toloso kokodo takomo sili odoo hee daga badebei oso ta maga hogabuloso see ka simidoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eseme Helodeeye goo hagee duloso egeesee takaso, “Yonee ayo wooloomeye neme olo wooloomaso. Esino ayo goo toowa hagee dumolo ee agamo goo ee dumolosomo?” diso. Yo diya goo tiademe, yayo Yesu agalame diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesuye diye di odoo 12 diba see wedige sibileso, goo diayo moodoo sabolo osoloso goo diayo eligi susuga ee Yesu mapoo oposususo. Osoloso Yesuye diba gilimadoloso Betesaida mi mapoo dibusomo dabalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Esino odoo susuga oso goo hagee duloso diba nosee hamamee diyadeeso. Eseme diayo simi Yesuye ogoloso diba gilimadoloso dimapoo Godeeye wiligi doloso badeli goo ee eligilone odoo paigiga sabolo weidilame tekepo moodoo demeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yesu yo egeeseemo sileeme, o hamamee dili odoo oso habe sibileso yimapoo egeesee takaso, “Odoo susuga hagee epedee diye dee, diba mosobia koola omapoo dileso dieso nei nalai sabolo moso tilei sabolo ee esilame. Bei, mi iyo hagee do mapoo nei iyo nalai sabolo moso iyo tilei sabolo mauwedoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eseme Yesuye dimapoo nei egeesee takaso, “Niyo dimapoo nei tenee,” diso. Eseme diayo nei egeesee takaso, “Odoo hagee diya bei. Esino imapoo wo si hedebe dee tiadoo sabolo di bakadio sabolo moloso. Esino nayo imapoo nei abo talame diye doloso ka takala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bei, biame omapoo mooloogoodoo ee ma kulodu gisowe hesiga ee 5,000. Eseme Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Odoo susuga nei nalame odoo 50 egeesiso mooloogoodolo ka buluma, odoo 50 egeesiso mooloogoodolo ka buluma dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eseme odoo susuga olo nei nalame egeesee bulumamo diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Osoloso wo si dee tiadoo sabolo di bakadio Yesuye toloso, Kei mi ma dokodoo bolone nei pidilame goomoga goo Godee mapoo takaso. Osoloso yayo wo popeiloso di bakadio agisaloso, o hamamee dili odoo mapoo piso, see diayo odoo susuga mapoo pilame. Eseme diayo wo si popei sabolo di hwei sabolo odoo susuga mapoo piso. ");
INSERT INTO kkc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eseme odoo susuga nei ne oso diya edigime nei hosudelega abo poogooso. Osoloso diayo nei naloso abo poogoo ee Yesu o hamamee dili odoo oso misigamo dileso bou tegei mapoo soo 12 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Biame heeso Yesu obusomo Godee mapoo takolone badoboome, o hamamee dili odoo oso yimapoo sibadeeso. Eseme Yesuye dimapoo egeesee takaso, “Edebeeyo a odoo ogu deliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eseme diayo nei Yesu mapoo egeesee takaso, “Odoo aboso taka no Yonee odoo howo oluguli dee takeliso. Aboso taka no Ilaya deliso, osoloso odoo aboso taka no Godee maga to toloso kokodo takomo sili odoo hee daga badebei oso ta maga hogabuloso see ka simidoo, dee takeliso.” ");
INSERT INTO kkc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eseme Yesuye nei dimapoo egeesee takaso, “Esino nei niyo a odoo ogu deliyo?” diso. Eseme Pitaye nei egeesee takaso, “No Godeeye hudi magoo Kelisoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eseme see Yesuye nei o hamamee dili odoo dimapoo egeesee takaso, “Niyo odoo abo mapoo takolone a Keliso dee na takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Osoloso see tobu Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Odoo Holo, a dala toowa bei talaiso. Osoloso Yu odoowo wiligi odoo tebisa sabolo, tei moso wiligi odoo tebisa sabolo, tei eligili odoo sabolo oso a diya gowoolone pagalaiso. Osoloso edebeeyo a teli mapoo magalaiso. Esino biame bakadio midoo ma kulodu ta moloso biame hee mapoo see hogabileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuye see odoo susuga mapoo egeesee takaso, “Edebeeyo ayo di hamamee sibilei goomogoga, yo daga eyo goomoga goo tomo sili ee poogoloso, biame susuga ma kulodu eyo talai sabolo dala toowa talai goo sabolo medee mopoodoo doloso ama hamamee ka sibe. ");
INSERT INTO kkc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Osoloso odoo agayo o gie badeli eyo nediliyo pidilame seega, yo o gie badeli ee osugobalaiso. Esino odoo agayo mo goo maga o gie badeli peegoo magooga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Esino odoo agayo mipoo toowa hamapoo badolone, eyo goomoga goo susuga tomo siloso, hedebe gie badeli goo ee telega dagaduga, yo see ogoo goo talaisomo? Mauwe. ");
INSERT INTO kkc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Osoloso odoo agayo abolo osoloso mo to mapoo gowooga, Odoo Holo ayo toowa doloso badeli goo omaga mo gadeebugu sabolo, osoloso mo Maye toowa doloso badeli goo omaga o gadeebugu sabolo, osoloso Godeeyo momaiye oso toowa doloso debei omaga gadeebugu sabolo sibileso nei diba gowoolaiso. ");
INSERT INTO kkc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Esiga ayo nimapoo ka taka. Nima kulodu odoo abo olo doso, diba Godeeye wiligi doloso badalai biame oso simi ogoloso, hamamee wedileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Osoloso biame 8 egeesi poogoloso, hamamee Yesuye dulone, Pita, Yonee, osoloso Yemes esee gilimadoloso mubi dokodoo Godee mapoo takalame palaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesuye Godee mapoo takomolome, o mudu opusomo doloso o dugo diya heliye poloso omaga poniso. ");
INSERT INTO kkc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eseme haga booloogelega, Ilaya dio Moses dio galaga sibileso Yesubolo to kemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Diayo Kei mi diya gadeebugu sabolo peledoboloso Yesuye Godeeyo to dodolone Yelusalem mapoo dileso talai goo ee oposususo. ");
INSERT INTO kkc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita o odoo abo sabolo tiesaloso hogogabuloso keesee egeino, Yesu yayo toowa doloso badeli goo omaga o gadeebugu sabolo tobudulone odoo bakadio sabolo to kesamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Odoo bakadio oso Yesubolo to kesameleso dilame doboome, Pitaye medee goo goolega Yesu mapoo egeesee takaso, “Wiligi odoo, iba hamapoo dabalai tekepo. Esiga iyo waseme bakadio hedebe di tegegalaiso. Hee nee, hee Moseseeyo, osoloso hee Ilayayo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita to osee komolome, koloboso sibileso diba gidiseme, diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Osoloso kolobo maga toso egeesee taka, “Hagee mowolo, ayo hesia oso. Esiga o to medee dui!” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kolobo ma kuloduga to taka koodobuloso, diayo Yesu obusomo tobudume egeiso. Pita diayo mubi ma dokodoo egei goo ee odoo abo mapoo saga takele. ");
INSERT INTO kkc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Diba biame hee mapoo mubi maga kumoo meileso doboome, odoo susuga oso Yesuye badebei mapoo saga sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eseme odoo mooloogoodoo ma kuloduga odoo hedebeso toso neligidi Yesu mapoo egeesee takaso, “Eligili odoo, ayo namapoo howaso, nayo mo giso holo agalame sibe. Bei, yo mo holo hedebega. ");
INSERT INTO kkc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bei, bo holo oso yimapoo pologa, yo kikiliga sabolo homodobuloso gwa sabolo molone maga maga makawo tiodiliso. Bo holo oso yimapoo dala tenemolome yo biame susuga ma kulodu haga medee koo sili. ");
INSERT INTO kkc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Esino ayo nee hamamee dili odoo mapoo bo holo hagee peegoo hasiso bigi deme, diayo peegoo hasiso bigilei tebilena,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eseme Yesuye egeesee takaso, “Niba tei too mauwe tokenee odoo. Niyo amapoo tei talame a biame kasolo nibolo hodobo ka badalaiyo? Esino nowolo amapoo ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Giso holo Yesu mapoo ido sibumolome, bo holo yimapoo pala oso kilikolone mi mapoo homodobiaso. Eseme Yesuye bo holo peegoo hasiso buguloso, yo tekepo poloso oma mapoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eseme odoo susuga oso Godeeye kitulugu goo ogoloso diya howoogadooso. Odoo susuga oso Yesuye goo moodoo susuga ee osee goolone doboome, Yesuye o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Odoo Holo, a ha teli odoo mapoo tiasalaiso. Esiga niba ayo epedee goo hagee takoo na boobadee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Esino o hamamee dili odoo oso Yesuye taka goo eyo bei medee kibiya gooleedele poogooso. Bei, goo eyo bei ee dimaga mada magoloso meleeso. Eseme diayo see Yesu mapoo woosalai ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu o hamamee dili odoo oso dima kulodu odoo agayo toowa doloso ka badalaisomo, doloso dieso nediliyo toso agadigaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Esino Yesuye dibada goo goolee ogoloso holope idoloso yima koola mapoo sibileso tobudume, o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Odoo agayo holope hageesi masi mo hu maga yibolo badalame idoga, yayo a idoso. Osoloso odoo agayo a idoga, yayo mo Ma a diye di ee idoso. Esiga nima kulodu odoo agayo eyo nediliyo pepooko daga, yo see toowa doloso badalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eseme Yoneeye egeesee takaso, “Wiligi odoo, iba odoo heeso bo holo ee nee hu sabolo odoo ma kuloduga peegoo hasiso bugume egeiso. Eseme iyo yo hamaga takaso. Bei, yo ibada mooloogoodoo ma kulodu koo badeli,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Esino Yesuye yimapoo egeesee takaso, “Yo na hamaga takee. Bei, edebeeyo nimapoo ha telega badoga, yo nibada odoo oso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu yo Kei mi ma dokodoo ido palai biame ee olo koola tooboome, yo Yelusalem mapoo dilame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eseme yayo odoo abo Samaliya mi ee ma kulodu mi pepooko hee mapoo malalo diye diso, diayo dileso omapoo yayo tilei moso ee mopoodoo dalame. ");
INSERT INTO kkc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Esino mosobia oso Yesuye Yelusalem mapoo dileigo di goo ee duloso, diayo yo gowoolone yimapoo moso tenele. ");
INSERT INTO kkc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eseme Yesu o hamamee dili odoo Yonee dio Yemes dio goo hagee duloso yimapoo egeesee takaso, “Lodee, douso mosobia odoo hagee piligilame, iyo Kei mi ma dokodooga dou toose dee takalai, no goomogosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Esino Yesuye dimapoo bidi toboloso tobudulone dimapoo diya takaso. ");
INSERT INTO kkc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Osoloso diba see mi hee mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu o hamamee dili odoo sabolo eli maga diyadaga molome, odoo hedebe oso sibileso Yesu mapoo egeesee takaso, “Nayo mi hee kamapoo dusomo, ayo no deedee sileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuye yimapoo nei egeesee takaso, “Dobu so oso debeli mi ee moloso. Osoloso sóso tieseli ou moloso. Esino Odoo Holo, ayo tieli moso mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eseme Yesuye see odoo hee mapoo egeesee takaso, “Nayo a deedee sibe,” diso. Esino odoo ogoso nei egeesee takaso, “Lodee, nayo epedee amapoo biame tenee, ayo mo ma toga midoosoolaiya,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eseme Yesuye yimapoo nei egeesee takaso, “Dio maga odoo wedia oso dieso nediliyo odoo wedia ee midoosodolone dabalai tekepo. Esino no sibileso Godeeye wiligi doloso badeli goo ee odoo mapoo takomo sile,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eseme odoo heeso see egeesee takaso, “Lodee, a nama hamamee dadalai goomogo. Esino a epedee hamapoo mo soosoo dimapoo emegei di to takalame dia,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Eseme Yesuye see yimapoo nei egeesee takaso, “Odoo agayo ama hamamee dodolone see wedi dilame hamamee bidi ogo domo duga, odoo egeesi masi oso Godeeye wiligi doloso badeli goo ee halo tou talai tebile,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Goo hagoso dileso koodobume, Lodeeye odoo 72 hesigaso. Osoloso dima kulodu odoo bakadio tooboo bakadio tooboo doloso yayo dilei mosobia pepooko mapoo diba malalo diye diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Egeeseelone yayo dimapoo egeesee takaso, “Homolee ma kulodu bi susuga ee olo teeleegeeloso goolai ee moloso. Esino bi ee gooloogalai odoo ee haga beinee. Esiga homolee gibadeli odoo mapoo woose, yayo o homolee ma kulodu bi susuga teeleegee ee gooloogali odoo diye dalame. ");
INSERT INTO kkc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Esiga niba di! Esino niba goolee sabolo di. Bei, ayo niba sipi be hu pe masi dobu so kamanali oso egee do mi ma kulodu diye deeso. ");
INSERT INTO kkc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niba dulone molee sabolo, o sabolo, osoloso homo mapoo kali bi sabolo na todi. Osoloso niba eli domopoo dulone, odoo abo tugodoloso dibolo to na ke. ");
INSERT INTO kkc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Niyo mi hee mapoo dileso peledobooga, moso kamapoo gilimado polosomo, niyo daga moso mapoo egee do odoo mapoo emegei di to takolone, ‘Godeeyo mesie goo nibolo mele,’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Esiga mesie odoo oso moso ee ma kulodu doga, niyo emegei di to taka oso dibolo osee malaiso. Esino moso ee ma kulodu debeli odoo koo mesili daga, niyo emegei di to taka oso dibolo malaime. ");
INSERT INTO kkc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Osoloso moso kasee nimapoo ka teneesomo, niba moso hedebe omapoo debee. Osoloso niba moso hedebe omapoo dobolone, diayo nimapoo nei teneega, nei ee nolone ka debee. Bei, tou teli odoo ee dia nei talai tebiliso. Esiga niba moso hee mapoo dobolone, moso hee mapoo na du dee. ");
INSERT INTO kkc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Niba mi hee mapoo duga, mosobia odoo oso emegei dolone nei teneega, hedebe ee namelee. ");
INSERT INTO kkc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Osoloso mi omapoo odoo paigiga tekepo moodoogolone dimapoo ‘Godeeye wiligi doloso badeli goo ee nima koola mapoo moloso,’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Esino niba mi hee mapoo dileso peledobooga, mosobia oso niba gowoolone moso tenelega poogooga, niba diayo bia eli domopoo dileso, to kitulugu sabolo dia mi basago oso nibada homo mapoo obooga ee dia howo woola mapoo te, Godeeye komonolone dimapoo dia goo tokenee eyo nei tenelai goo ee gooleedalame. Osoloso niyo dimapoo egeesee takee, ‘Niba medee goolee, Godeeye wiligi doloso badeli goo ee koola hamapoo moloso.’ ");
INSERT INTO kkc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Esiga ayo nimapoo taka, mosobia kaso niba sibadeega, ogoloso goomoga sabolo niba iyadelega poogooga, nei Godeeye midilei biame omapoo dala toowa diayo talai oso Sodom mosobia oso dala talai ee dagadileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ye-ee! Kolasin mosobia odoo osoloso Betesaida mosobia odoo sabolo. Dala toowa oso niba bamoloso. Bei, ayo nibada mi mapoo goo toowa mudu opusomo opusomo di ee moodoogamo silee egeesi masi Yu odoonee mosobia Taya mapoo osoloso Saidon sabolo mapoo moodoogamo silee diepi, diba haga booloogelega, dibada goo tokenee maga miligi pialoso debeli. Osoloso diayo dibada goo tokenee maga miligi pia goo ee eligilone dugo tokenee megigaloso dosou holugaloso silesibili. ");
INSERT INTO kkc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Goo egeesi maga Godeeye goo midilei biame mapoo dala toowa Kolasin mosobia sabolo osoloso Betesaida mosobia oso talai oso Taya mosobia sabolo osoloso Saidon mosobia oso dala talai ee dagadileiso. ");
INSERT INTO kkc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Esino Kapeniyum mosobia odoo niba biame omapoo Kei mi ma dokodoo ido palaiso, doloso goolee sabolo dosomo? Haye, niba toloso Dou mi mapoo toodalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Esiga odoo agayo nibada to duloso toga, yo mo to tolone ka seeso. Esino odoo agayo nibada to duloso niba diya gowooga, yo a gowoolone ka seeso. Esino odoo agayo a gowooga, yayo mo Ma a diye di ee gowoolone ka seeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesuye odoo 72 diye di oso goomoga sabolo see wedi sibileso egeesee takaso, “Lodee, iyo nee hu sabolo takomo sileeme, bo holo odoo ma kulodu debei oso ibada to duloso mesiloso peegoo galagadiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuye dimapoo nei egeesee takaso, “Keiso saga egee ebedigebugu egeesi masi Kei mi ma dokodooga Saiten miyomoo homodobume ayo egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Esiga niba dui, niyo hebise sabolo homolobe sabolo mapoo dokodoo nibada homoso hamadabalame ayo nimapoo kitulugu olo teneeso. Esiga kitulugu oso Saitenso kitulugu ee dagadileso moloso. Esiga bi heeso nimapoo dala tenelai mauwe. ");
INSERT INTO kkc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Esino bo holo oso nibada to duloso mesiloso peegoo kukulo di goo mapoo haga na goomege. Esino nibada hu ee tei gie badeli booka mapoo egee molo omaga goomege,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesu yo Dio Tei oso kitulugu maga goomoga sabolo badolone egeesee takaso, “Ma, Kei mi sabolo osoloso mipoo sabolo nayo wiligi doloso badoso. Esiga a namapoo goomogo. Bei, nayo wiligi doloso badeli goo mada egee molo, goo goolee toowa odoo mapoo yilige bigile poogooso. Esino nayo goo goolee dele poogoo odoo mapoo yilige buguso. O. Tei takoo, Ma. Goo hagee nayo goomoga goo oso. ");
INSERT INTO kkc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mo Maye goo susuga amapoo olo teneeso. Esiga odoo heeso Owolo a gooleedele. Esino hedebe Maye Owolo, a ka gooleedoo. Osoloso odoo heeso Ma gooleedele. Esino hedebe Owolo ayo Ma ka gooleedoo. Esiga odoo ogu bia mapoo Owolo ayo Mayo goo ee yilige bigilame gooleega, odoo egee bia oso Mayo goo ee diba gooleedalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Osoloso o hamamee dili odoo mapoo bidi toboloso omapoo tobudulone dimapoo egeesee takaso, “Niyo egeli goo susuga mapoo goomege. ");
INSERT INTO kkc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bei, ayo nimapoo taka, Godee maga to toloso kokodo takomo sili odoo daga hoogoo debei sabolo osoloso Yu odoowo wiligi odoo tebisa daga debei oso niyo epedee hagee ogo goo ee agalai doloso balaga meleeso. Esino diayo egele. Osoloso diayo goo niyo epedee egee dumolo goo sabolo dulei doloso balaga meleeso. Esino diba dule,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Biame hee mapoo tei eligili odoo heeso sibileso Yesu tei ma susuga ee gooleedoloso badaba beleso egeesee takaso, “Eligili odoo, a gie badeli talame ogoo goo talaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuye to nei egeesee takaso, “Godeeyo to booka mapoo hogugu oso kasee takoolo? Nayo hesigaloso kasee gweliyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Odoo oso to nei egeesee takaso, “Nee sooloo ma kuloduga goolee sabolo, osoloso nee dio maga, osoloso nayo kitulugu sabolo, osoloso nayo goo goolee sabolo oso nee wiligi odoo Godee diya goolee. Osoloso no nediliyo diya gweli egeesi masi nee odoo onosee diya egeesee goolone ka badebee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuye yimapoo nei egeesee takaso, “Nayo tei goo takoo. Esiga no goo egeesi tolone badoga, goo oso no badoboso kookaiyo gie badeli talaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Esino odoo yayo eyo nediliyo yo tekepo dolone egeesee takaso, “Esino mo odoo ogumo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eseme Yesuye yimapoo oposusu hee hagee oposususo, “Odoo hee Yelusalem maga Yeliko mapoo moumeleeso. Yo eli domopoo moumolome, mesiya aboso yo woomele poogoloso eli domopoo magoloso o dugo yayo ka sabolo osoloso o bi susuga sabolo heli toloso diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yo eli domopoo talame seemolome, Godee ogo odoo ogo doloso domo badeli odoo oso eli hedebe omaga sibulone egeiso. Osoloso yayo sibulone egeino, odoo egee olo talame semelee ogoloso peegooga boloodabaso. ");
INSERT INTO kkc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Osoloso yima hamamee abaga tei moso tegei mapoo tou teli odoo, o bala Libai, yinosee sibulone egeino, odoo eli domopoo mi mapoo homodobuloso tiamolome, peegooga boloodabaso. ");
INSERT INTO kkc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Esino Samaliya odoo yinosee eli hedebe omaga sibulone egeino, odoo eli domopoo talame seemolome egeiso. Yayo odoo egee ogoloso yo diya sooloo dalaso. ");
INSERT INTO kkc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eseme yo odoo oso tiamelee mapoo dileso o kolo kookoo mapoo olipi i sabolo wain i sabolo oso hoduloso dugoso tialogooso. Osoloso yayo yo o be donki ma dokodoo tiedoloso, odoo soowo moso mapoo ido dileso yo bameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Osoloso see biame hee mapoo Samaliya odoo oso odoo soowo moso gibadeli odoo mapoo molee ko bakadio yimapoo tenelone egeesee takaso, ‘Odoo hagee nayo medee bamelee. Esino nayo odoo hagee bolone molee hagee hosudoloso, see nee molee oso pidimologa, ayo see wedi simi biame omapoo, nei o egeesi ayo namapoo tenelaiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Osoloso Yesuye see egeesee takaso, “Odoo bakadio hedebe di hageeyo kulodu mesiyaso wei eyo odoo tei ogumo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eseme tei eligili odoo oso nei egeesee takaso, “Edebeeyo yo sooloo dolone yo pidi odoo ono tei o odoo oso,” diso. Eseme Yesuye yimapoo egeesee takaso, “O. Tei takoo. Esiga no dileso goo egeesi tomo sile,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu o hamamee dili odoo sabolo dulone, mi hee mapoo dileso peledabaso. Eseme mi omapoo badeli sobo hedebe Mataye o moso mapoo Yesu ido palaso. ");
INSERT INTO kkc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Eseme Matayo omolo Meliye sibileso Yesuwo homo beiyopoo badolone o to dulone badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Biame omapoo Mataye moso kulodu Yesuwo mooloogoodoo odoo eyo wo silone, tou bei neme Yesu mapoo sibileso egeesee takaso, “Lodee, moloye nobolo badoga, ayo mobusomo tou ka toga, diya kwasio. Esiga yayo a pidilame nayo yo sibeye dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Esino Lodeeye egeesee takaso, “Mata emegei, no tou susuga tomo silone goolone goo diya kodio. ");
INSERT INTO kkc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Esino tou susuga ee ma kulodu tou hedebe hagono toowa ka moloso. Esino Meliye goo tekepo toowa olo tooso. Esiga odoo heeso goo egee yimaga peedee dalaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Biame heeso Yesu mi hee mapoo dileso Godee mapoo takemelee koodobume, o hamamee dili odoo heeso egeesee takaso, “Lodee, Yoneeye o hamamee dili odoo mapoo Godee mapoo takeli goo eligimo silee egeesi masi nayo iba nosee Godee mapoo takeli goo ee eligi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eseme Yesuye dimapoo egeesee takaso, “Niyo Godee mapoo takolone egeesee takee: ‘Ma, biame susuga ma kulodu hedebe nee hu oso toowa doloso mele dee, odoo susuga oso dokodoo poudalame. Esiga nayo wiligi doloso badeli goo oso sibilei iba goomogo. ");
INSERT INTO kkc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Osoloso biame susuga ma kulodu nei iyo nalai imapoo tenemelee. ");
INSERT INTO kkc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Osoloso ibada tokenee hapoloso boobado bigi. Bei, iba nosee odoo susuga oso goo tokenee susuga imapoo moodeli ee boobado bigiliso. Osoloso iba goo tokenee mapoo na gido di dee’,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yesu Godee mapoo takeli goo hagee eligimeleso koodobuloso dimapoo see egeesee takaso, “Niba to hee hagee goolee. Odoo soo heeso gesi domo mapoo nee mosopoo sibileiso. Esino nayo yimapoo nei siloso tenelai nei mauwe daga, mosobia ma kulodu nee odoo mapoo nei talame dileiso. No nee odoowo mosopoo dileso osulu mapoo kalamadulone egeesee takalaiso, ‘Mo odoo, odoo soo hee mo mosopoo simiga. Esino ayo yo pidilei nei mauwe. Esiga ayo namapoo nei talame ka siba,’ dee. ");
INSERT INTO kkc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eseega nee odoo moso kulodu badebei oso egeesee takalaiso, ‘No see wedi di. Bei, a mo holo dio sabolo osulu kisiloso tiesamoloso. Esiga a toboloso namapoo nei tenelaime,’ dee.” ");
INSERT INTO kkc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eseme Yesuye see dimapoo egeesee takaso, “Esino ayo nimapoo taka, yayo no wulo emegei doloso bi tenelaime. Esino nayo kalamadulone osee howamologa, yayo toboloso namapoo bi tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Esiga ayo nimapoo taka, niba woose. Egeeseega nimapoo tenelaiso. Osoloso niba esie. Egeeseega, niyo agalaiso. Osoloso niba osulu mapoo kalamadi. Egeeseega osulu ee nimapoo yamagalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bei, woosali odoo oso goo talaiso. Osoloso esieli odoo oso goo agalaiso. Osoloso osulu mapoo kalamadili odoo mapoo osulu yamagalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Esiga ma dio niba dui! Odoo agayo owoloye di nala poogoo daga, yimapoo sa tenelisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Osoloso yayo só ho nala poogoo daga, nayo yimapoo homolobe tenelisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niba tokenee odoo. Esino niba gooleedooso, nibada owolo dimapoo bi tekepo tenelai. Esiga iba gooleedooso, Ma Godee Kei mi ma dokodoo egee bado oso yimapoo woosali odoo mapoo Dio Tei wulo tenemoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Biame heeso odoo hee badebeiso. Daga bo holo oso odoo eyo su ma kulodu palademe, to kelega poogoloso badebeiso. Eseme Yesuye odoo eyo su ma kulodu bo holo paladee peegoo habuguso. Osoloso bo holo oso odoo ma kuloduga peegoo gadime, to koo keli odoo yo see to keiso. Eseme odoo susuga oso goo hagee ogoloso diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Esino odoo aboso egeesee takaga meleeso, “Yesu yo Belsebuleeye kitulugu maga bo holo peegoo ka hasiso bigili molodoo. Bei, Belsebul yo bo holo dia wiligi odoo taba oso,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Eseme odoo aboso Yesuye kitulugu egee tomolo tei Godee maga simibeleso agalame yimapoo egeesee takaso, “Nayo Kei mi ma dokodooga goo toowa opusomo di ee imapoo eligi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Esino Yesuye diayo goo goolee olo gooleedoloso dimapoo egeesee takaso, “Mi toowa mapoo debeli odoo oso abo puloso dieso nediliyo ha toga mi toowa egee malaime, tokenee palaiso. Osoloso soosoo heeso abo puloso dieso nediliyo ha toga soosoo egee pododalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Esiga Saitenso o mooloogoodoo ma kulodu domo puloso dieso nediliyo ha toga, kaseega yayo wiligi doloso badeli goo oso osee ka malaiyo? Tokenee palaiso. Bei, niyo a Belsebul oso kitulugu maga bo holo peegoo ka hasiso bugu deligo daga, ayo goo hagee nimapoo ka taka. ");
INSERT INTO kkc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Esino ayo bo holo peegoo hasiso bigili kitulugu hagee tei Belsebul oso kitulugu maga ka hasisimo silo daga, nibada hamamee dili odoo oso bo holo peegoo egee hasisimo silesibo kitulugu ee kamapoo toowo? Esiga diayo takooga, niyo amapoo egee takoo goo ee tei goonee, dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Esino ayo Godeeye kitulugu maga bo holo peegoo ka hasisimo silo daga, Godeeye wiligi doloso badeli goo ee nimapoo olo simiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Esiga kituluguli odoo oso tai sabolo tio sabolo toloso o moso gibadoga, o bi moso kulodu meli ee edebeeyo heli talaime. ");
INSERT INTO kkc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Esino see diya kitulugu odoo oso siboga, yayo moso gibadeli odoo wooloso o tai sabolo tio sabolo peedee dalaiso. Osoloso moso kulodu peleso o bi susuga toloso odoo abo mapoo pileiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Esiga odoo agayo a dokolo tebelega poogooga, yo amapoo ha tomoloso. Osoloso odoo agayo abolo odoo Godee mapoo gilimado sibilega poogooga, yayo odoo ee Godee maga peegoo hasiso bugu domoloso.” ");
INSERT INTO kkc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Eseme Yesuye egeesee takaso, “Esiga bo holo oso odoo maga peegoo gaduga, yo dileso miwe poogoo mi mapoo eyo badalai mi esiamo sileiso. Yo mi esiamo siloso koo ogoga, eyo nediliyo egeesee takalaiso, ‘A mawo daga badebei mapoo see wedi dia,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yo sibileso ogoga, moso gelesi kadoloso bi medee mopoodoo ma molo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Osoloso yo see wedi dileso bo holo diya kitulugu abo 7 gilimadoloso moso omapoo dabalaiso. Egeeseega odoo hagee eyo daga badeli poogoloso see diya tokenee badalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuye goo hagee odoo mapoo takomolome, odoo mooloogoodoo ma kuloduga sobo heeso toso neligidi egeesee takaso, “No soomagoloso too nedimo silee sobo omapoo Godeeye goomoga tenelai tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Esino Yesuye yimapoo egeesee takaso, “Haye, emegei. Goo egeesi koo moloso. Odoo agayo Godeeyo to duloso omapoo mesie sabolo siloga, odoo yimapoo Godeeye goomoga teneliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Edebeeyo Yesu mapoo sibileso mooloogoodeme, Yesuye dimapoo egeesee takaso, “Epedee hamapoo egee do odoo ee diya tokenee. Osoloso diba wulo goo opusomo di agalame amapoo takeliso. Esino ayo dimapoo goo toowa opusomo di hee eligileime. Esino hedebe Yonayo goo ono dimapoo ka eligilei. ");
INSERT INTO kkc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bei, Godeeye Yona mapoo moodoo goo oso Niniba odoo mapoo yayo tei Yona diye di goo ee eligiso. Esiga Odoo Holo amapoo goo peledabalai ee odoo epedee hagee do mapoo Godeeye tei a diye di goo ee eligileiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Osoloso goo midilei biame mapoo Siba mi eyo wiligi taba sobo onosee nibolo goo midi mapoo badolone nibada goo midiloso, niba tokenee odoo dalaiso. Bei, yayo eli sage abaga sibileso odoo toowa Solomonoye eligi goo ee dulame simiso. Esino ayo Solomono dagadileso ka badoso. Esino niyo mo to dulei ka gowooso. ");
INSERT INTO kkc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Esiga Niniba odoo oso goo midi mapoo nibolo dobolone, nibada goo midiloso, niba tokenee odoo dalaiso. Bei, Yonaye Godeeyo to dimapoo tosibume, diba dia goo tokenee mapoo miligi piaso. Esino Yona ayo dagadileso badoso. Esino ayo Godeeyo to nimapoo takomo sibume, niyo duloso nibada goo tokenee mapoo miligi pile.” ");
INSERT INTO kkc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Edebeeyo keme pouloso mada koo mageeya. Osoloso toloso koo geegeeya. Haye, keme pouloso woola mageeya edebeeyo moso kulodu gasiboga gadeebugu ee agalame. ");
INSERT INTO kkc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Esiga nee su mapoo nee howo oso keme masi ka moloso. Osoloso nee howo oso tekepo mologa, nee su susuga gadeebugu malaiso. Esino nee howo oso tokenee poga nee su susuga neliga malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Esiga obeeyamo. Nee su mapoo gadeebugu egee molo medee hoodo ege. Bei, gadeebugu ee neliga molo malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Esiga nee su ma kulodu gadeebugu toowa oso molone neliga hee me daga, nee su mapoo kemeso pouni masi gadeebugu malaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu to takameleso koodobume, Pelisi odoo heeso o mosopoo nei nalame ido diso. Eseme Yesu yibolo dileso nei nalame biaso. ");
INSERT INTO kkc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pelisi odoo oso Yesuye Yu odoo dia tei magoo ee dedelega poogoloso dee howo sauwilega nei ne ogoloso dio dulone diya gooleeso. ");
INSERT INTO kkc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eseme Lodeeye yimapoo egeesee takaso, “Pelisi odoo niba wulo nibada kapu sabolo peleta sabolo hedebe kolo ee hapoolone hee kulodu hapelega pegeli niba egeesi masi doso. Bei, niyo nibada kolo ono hapeliso. Esino sooloo ma kulodu tokenee goo sabolo osoloso bi goomegeli goo oso ka moloso. ");
INSERT INTO kkc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Niba boobada odoo! Bei, Godeeye kolo sabolo osoloso kulodu sabolo moodooso. ");
INSERT INTO kkc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Esiga nimapoo bi teiba mologa bi mauwe odoo pidi. Niyo egeesee seega niba tokenee goo mauwe malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ye-ee Pelisi odoo! Bei, niyo Godee mapoo emegei di bi kobu sabolo bi pepuso abo sabolo medee molone 10 ma kulodu hedebe Godee mapoo tenee dolone nei tei ma hogugu ee ma kulodu goo toowa magoo ee telega pegeliso. Goo ee odoo mapoo goo tekepo moodeli sabolo osoloso Godee gweli goo sabolo oso. Esiga niyo Godee mapoo emegei di bi tenelone goo toowa bakadio hagee tobuloso moodee. ");
INSERT INTO kkc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ye-ee Pelisi odoo! Bei, edebeeyo niba agalame howo gisili moso kulodu peleso odoo hu toowa too oso bili mapoo bilame goomegeliso. Osoloso eli domopoo edebeeyo nimapoo gauwuloso emegei di to takooga ee dulei, niba diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ye-ee Pelisi odoo! Niba odoo bi mada magoo masi moloso. Edebeeyo odoo bi egelega, dokodooga diliso. Niba egeesi masi moloso.” ");
INSERT INTO kkc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Osoloso tei eligili odoo heeso Yesu mapoo egeesee takaso, “Eligili odoo, nayo Pelisi odoo mapoo tokenee sisi oso ibolo hodobo tokenee ka susu,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Osoloso Yesuye see tei eligili odoo mapoo egeesee takaso, “Ye-ee, tei eligili odoo! Bei, niyo tei eligi goo oso odoo mapoo hegi goo teneliso. Esino niyo diba pidilone hegi goo ee see niso koo teli. ");
INSERT INTO kkc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ye-ee tei eligili odoo! Bei, niyo Godee maga to toloso kokodo takomo sili odoo ta eyo bi mapoo moso pepooko medee tekepo tegeliso. Esino niba gooleedeleyo, odoo egee bia namawe diayo piligu oso? ");
INSERT INTO kkc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Niyo namawe diayo goo moodoo tekepona doloso odoo dieso piligu eyo bi ma dokodoo moso pepooko tegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Esiga Godeeye niyo goo moodoo olo hoodo ogoloso egeesee takaso, ‘Ayo Godee maga to toloso kokodo takomo sili odoo sabolo diye di odoo sabolo Isalael odoo mapoo diye dalaiso. Esino diayo abo piligilone abono wulo dala tenelaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Osoloso mi bei mooloogoo omaga sibulone namawe diayo Godee maga to toloso kokodo takomo sili odoo piligimo simiso. Egeeseelone diayo Eibol maga wooloomalai bei mooloogooloso abaga simino Sekalaya wooloomaloso omapoo koodobiaso. Bei, diayo Sekalaya yo tei moso tegei ogo osoloso Godee mapoo gala wooloso sili dousulu ogo doloso domo omapoo wooloomaso. Esiga epedee hagee do odoo niyo namawe diayo Godee maga to toloso kokodo takomo sili odoo piligu eyo nei tokenee niyo talaiso. Esiga ayo nimapoo tei goo taka. Bei, niyo namawe diowo tokenee eyo nei talaiso. ");
INSERT INTO kkc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ye-ee tei eligili odoo! Bei, Godee gooleedalai osulu yeli ki bi niyo mada magoloso ka doso. Osoloso niyo edebeeyo osulu omaga gadiyaga, kisiloso see niso koo gadu domoloso.” ");
INSERT INTO kkc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesuye Pelisi odoo sabolo tei eligili odoo mapoo to takameleso koodoboloso diba poogoloso diso. Eseme diayo diya komonolone hamamee biame abo mapoo Yesu mapoo woosali goo opusomo opusomo di woosameleeso. Bei, diayo goomoga Yesuye to nei taka ee ma kulodu Moseseeye tei magoo gababuoga, yo toloso goo midilame. ");
INSERT INTO kkc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Osoloso biame domo omapoo odoo susuga oso Yesu mapoo mooloogoodolone diya kumugulone nei halagabugu nei halagabugu diso. Eseme Yesuye daga o hamamee dili odoo mapoo egeesee takaso, “Niba obeeyamo! Pelisi odoo oso goo bakadio gweli goo ee wo habia egeesi masi moloso. Bei, wo giedege wo habia sabolo hamaga, wo giedege tokenee palaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Esiga goo susuga mada egee molo see woola peledabalaiso. Osoloso edebeeyo koo duli goo ee see woola takooga duleiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Osoloso niyo mada taka to ee see woola takooga duleiso. Osoloso niyo moso kulodu dulu mapoo mada taka see hamamee odoo susuga dulame moso omu ma dokodooga neligidi woola takalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Esiga emegei, ayo nimapoo taka. Odoo wulo su hagee wooloomali yibolo na ebi. Bei, yo hedebe su wooloomali ee gooleedoo, esino dio wooloomali yo tebile. ");
INSERT INTO kkc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Esino ayo nimapoo taka. Niba hedebe Godeebolo obulone ka debee. Bei, odoo wooloomaloso dio Dou mi mapoo toodalai kitulugu yimapoo moloso. Esiga niba hedebe Godeebolo obulone ka debee. ");
INSERT INTO kkc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Esiga niyo só pepuso dee tiadoo molee ko ta oso teliso. Esino ee ma kulodu Godeeye só pepuso hedebe koo boobado bigili. ");
INSERT INTO kkc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Osoloso Godeeye nibada wudu susuga yo gooleedooso. Bei, wudu susuga egee yayo olo hesigaso. Esiga niba haga na ebi. Bei, Godeeyo howo woola só ee goo toowa koo moloso. Haye. Niyo goo toowa ka moloso.” ");
INSERT INTO kkc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Esiga ayo nimapoo taka. Odoo agayo odoo howo woola tobudulone yayo amapoo tei too goo ee woola yilige buguga, nei Odoo Holo ayo Godeeyo momaiye eyo mudugiyo abaga tobudulone yo mo odoo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Esino odoo agayo odoo howo woola tobudulone amapoo tei tele poogoo goo ee woola yilige buguga, nei ayo Godeeyo momaiye dia mudugiyo abaga tobudulone yo mo odoonee dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Osoloso odoo agayo Odoo Holo amaga to tokenee takooga, Godeeye o tokenee hapoloso boobado bigileiso. Esino odoo agayo Dio Tei eyo goo maga to tokenee takooga, o tokenee ee Godeeye hapalaime. ");
INSERT INTO kkc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Esiga edebeeyo niba howo gisili moso mapoo osoloso wiligi odoo taba eyo moso mapoo nibada goo midilame ido pologa, niyo nei takalai ee haga na goolee. ");
INSERT INTO kkc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bei, niyo omapoo peleso tobudulone, to takalai ee Dio Tei oso nimapoo eligileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Odoo mooloogoodoo ma kuloduga odoo heeso Yesu mapoo egeesee takaso, “Eligili odoo, nayo mo ei mapoo takee, yayo ibada ama ta eyo bi gilibo toloso badolone bi susuga yayo egee bamolo puloso abo hodio amapoo tenelame,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eseme Yesuye yimapoo nei egeesee takaso, “Emegei, amapoo kitulugu mauwe, nee bakadio nimapoo nibada nama ta eyo bi domo puloso pilei,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesuye see odoo omapoo debei mapoo egeesee takaso, “Niba obeeyamo! Niba bi bei doloso badalai goo omapoo haga na goomege. Bei, bi bei doloso badalai goo oso tei gie badeli koo teneli,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Osoloso Yesu to hagee takoloso see wudu taka hagee oposususo, “Bi bei odoo o mi mapoo yayo nei howo segei oso nali bi diya palagaso. ");
INSERT INTO kkc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Osoloso eyo nediliyo egeesee takaso, ‘Nei nali bi hagee malai amapoo moso hee mauwe. Esiga ayo ogoo goo talaiyo?’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eseme yayo egeesee takaso, ‘A mo nei nali bi mageli moso guobuguloso see moso toowa abo tegelaiso. Osoloso ayo nei nali bi sabolo bi abo sabolo moso ee ma kulodu malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Egeeseega amapoo bi tekepo bei oso dugo susuga ee ma kulodu osee ma malaiso. Esiga a tou hee talai mauwe. Esino a goomoga sabolo wulo badolone, wo sabolo osoloso howo sabolo namalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Eseme Godeeye yimapoo egeesee takaso, ‘No boobada odoodoo! Esiga epei gesi nee gie badeli ayo namaga peedee dalaiso. Osoloso nayo nee su pidilame bi maloso meli see odoo agayo ka talaiyo?’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Osoloso Yesuye see egeesee takaso, “Odoo agayo mipoo hamapoo bi bei mooloogoo maloso badolone, nei Godeeyo howo woola goo toowa telega poogooga, goo hageesi oso yimapoo peledabalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuye see o hamamee dili odoo mapoo egeesee takaso, “Ayo nimapoo taka. Niyo dobolone nei nalai sabolo osoloso dugo kalai sabolo omapoo haga na goolee. ");
INSERT INTO kkc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bei, nei nali bi oso goo toowa koo moloso. Haye. Esino nibada gie badeli goo oso goo toowa ka moloso. Osoloso kali bi oso goo toowa koo moloso. Haye. Esino nibada su oso goo toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Esiga niba só ogoloso goolee. Diba nei nali bi dieso sogoloso koo gooloogali. Osoloso diba nei nali bi magalai moso mauwe. Esino Godeeye dimapoo nei nali bi ka tenemoloso. Esino Godeeyo howo woola só oso goo toowa koo moloso. Esino niyo goo toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Esiga edebeeyo kali bi sabolo osoloso nei nali bi sabolo omapoo diya gooleega, o gie badeli see hoogoo sagelisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Goo pepooko hageesi moodoolai nimapoo kitulugu me daga, niba see goo abo mapoo haga na goolee. ");
INSERT INTO kkc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Osoloso niba see dobudu meli palapalawa tekepo ogoloso goolee. Bei, diayo dieso nediliyo pidilei tou koo teli. Osoloso dugo dieso kalai koo duseli. Esiga ayo nimapoo ka taka, daga Solomonoye wiligi odoo toboloso badebei mapoo yayo kali bi medee tekepo kalaga meleeso. Esino dobudu meli palapalawa oso tekepo oso dugo tekepo Solomonoye kali ee dagadi. ");
INSERT INTO kkc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Esiga dobudu meli palapalawa tekepo oso epei gasibileso moloso, see biame hee mapoo wooseliso. Esino Godeeye palapalawa omapoo dugo masi tekepo ka kadili daga, a tei toso, Godeeye nimapoo dugo tekepo tenelaiso. Niba tei too kibile odoo oso debei masi na debee. ");
INSERT INTO kkc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Esiga niba nei sabolo howo sabolo namalai mapoo haga na goolee. ");
INSERT INTO kkc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bei, mi odoo oso bi egee talame diya gweliso. Esino Nama Godeeye bi niyo talame goomegeli ee yayo malalo olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Esino niba daga malalo diya esie, Godeeye wiligi doloso badeli goo ee talame. Niyo egeesee seega nei yayo bi niyo goomoga ee nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Esiga niba haga na ebi. Bei, sipi be bali odoo oso o be medee bali egeesi masi, Godeeye niba medee egeesee bamoloso. Osoloso niba ebia sabolo na debee. Bei, Godeeye niba yibolo wiligi doloso badalame yayo goomoga sabolo niba olo hesiaso. ");
INSERT INTO kkc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nibada bi odoo mapoo teneloso nei molee toloso bi mauwe odoo mapoo pi. Niyo egeesee seega, nei Kei mi ma dokodoo bi bei nibada hu sabolo malaiso. Bi bei ogoso Kei mi ma dokodoo mologa mauwe pagalaime. Bei, mi omapoo heli teli odoo oso sibileso bi ee heli koo teli. Osoloso siso bi koo nali. ");
INSERT INTO kkc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nimapoo bi bei toowa ma mologa, nibada goo goolee oso omapoo meliso. ");
INSERT INTO kkc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Esiga niba bi mopoodoo doloso goo mapoo dulone dobolone keme peyigaloso debee. ");
INSERT INTO kkc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bei, tou teli odoo oso dia wiligi odoo ee sobo hu wo nalame di siboga, agalame bameli egeesi masi debee. Bei, yayo see wedi sibileso osulu mapoo kalamadiga osulu saga yadalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tou teli odoo oso sibilei mapoo dulone dobolone osee bamologa, yayo simi ogoloso dimapoo goomogalaiso. Esiga ayo nimapoo taka, wiligi odoo yayo o tou teli odoo ogoloso goomogolone, diba bulume doloso dimapoo nei nali tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Esiga wiligi odoo oso sibilei, yo gesi domo sibumobelee o, kudi daga takooga sibumobelee, biame diba gooleedele. Esino o tou teli odoo oso yayo egee sibo mapoo dulone dobolone osee bamologa, yayo sibileso diba ogoloso dimapoo goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Esino niba goo hagee medee goolee. Edebeeyo heli teli odoo oso o mosopoo sibilei biame ee duloso badebei diepi, yo olo mopoodoo doloso bolone badolone, heli teli odoo oso simi ogoloso yayo habigili. ");
INSERT INTO kkc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Esiga niba olo mopoodoo doloso dulone bolone ka debee. Bei, Odoo Holo ayo sibilei biame niba gooleedele.” ");
INSERT INTO kkc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eseme Pitaye egeesee takaso, “Lodee, no wudu hagee takoo wulo hedebe iyo dulame ka takala o, odoo susuga oso dulame ka takala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eseme Lodeeye nei egeesee takaso, “Goo mapoo mesimo silone tou tekepo teli bali odoo ogumo? Wiligi odoo oso odoo egeesi masi mapoo kitulugu tenelaiso, yayo o tou teli odoo susuga gibolone yayo dimapoo wo tenemalame. ");
INSERT INTO kkc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Osoloso wiligi odoo oso peegoo dileso badoboso see wedi sibileso ogoga o tou teli odoo oso o tou ee medee tekepo tolone badebei ogoloso yimapoo goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Esiga ayo nimapoo taka, wiligi odoo oso o tou teli odoo oso tou medee tekepo tolone badebei ogoga, yayo see yimapoo o bi susuga ee bamelee dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Esino tou tokenee teli odoo oso o wiligi odoo saga sibilega poogooga eyo nediliyo egeesee takalai malaiso, ‘Mo wiligi odoo saga koo sibo,’ doloso, emegei sobo sabolo giso sabolo tou teli odoo abo woomele poogoloso, wo sabolo yugune sabolo ee nolone halabolone badalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yo egeesee badolone mopoodoo delega badebei mapoo, o wiligi odoo oso sibileso peledabalaiso. Egeeseega o wiligi odoo oso sibileso yo Godee mapoo odoo koo mesili sabolo badalame, yo diya woomeleso peegoo togobigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Esiga tou teli odoo oso o wiligi odoo oso goomoga goo ee gooleedoloso tou ee telega poogoloso mopoodoo delega badoga, yo diya woolaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Esino tou teli odoo oso o wiligi odoo oso goomoga goo ee gooleedelega badolone goo ee telega badoga yo haga woolaime. Esiga Godeeye edebeeyo yo tou toowa talame goo goolee tekepo teneeso. Esiga yo goomogoso, goo goolee tekepo sabolo tou ee toowa tolone badalame. Osoloso Godeeye edebeeyo tou pepooko talame goo goolee tekepo teneeso. Esiga yo goomogoso, goo goolee tekepo sabolo tou pepooko ee tolone badalame. ");
INSERT INTO kkc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ayo odoo susuga domo puloso dou gigalagalame mi toowa mapoo ka simi. Esino dou oso paiya ee agalai a goomogo. ");
INSERT INTO kkc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Esino ayo dala talai biame olo siboso. Esiga amapoo goohele toowa oso moloso. Esino ayo dala ma kuloduga gaduga, goohele amapoo egee molo amapoo mauwe pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Esiga niyo goo goolee oso a mipoo hamapoo mesie goo tosimidoo dee gweliyo? Haye, domo pilei goo ee tosimi. ");
INSERT INTO kkc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Esiga epedee domo hamaga dulone soosoo ma kulodu domo pimalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Egeeseelone ama dio owolo giso holo dio domo pileiso. Osoloso owee dio owolo sobo holo dio domo pileiso. Osoloso gisowo owee dio osobo dio domo pileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuye see odoo susuga mapoo egeesee takaso, “Niba kei ma dokodoo ogoga hemiye mologa, niyo egeesee takeliso, ‘Epedee howo sibulodoo,’ deliso. Egeeseega howo tei sibiliso. ");
INSERT INTO kkc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Osoloso niba kei ma dokodoo ogoga kolobo me poogoloso kei dasege mologa, niyo egeesee takeliso, ‘Epei mi kibolodoo,’ deliso. Egeeseega mi kibiliso. ");
INSERT INTO kkc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Niba goo bakadio gweli odoo! Howo sibilei goo sabolo osoloso mi kibilei goo sabolo niba olo gooleedooso. Esino bei kasi maga niba epedee hamapoo goo egee peledoboo ogoloso gooleedelega ka dabala?” ");
INSERT INTO kkc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Niba kasi maga nisono goo tekepo talai goo ee gooleedelega ka dabala? ");
INSERT INTO kkc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Esiga namapoo goweli odoo oso no goo midilei mapoo ido duga, no saga eli domopoo yibolo dulone yayo namapoo gowe egee molo pagalame yibolo emegei dee. Esino nayo goo egeesi moodelega poogooga, yayo no goo midili odoo mapoo ido peleso nee goo midileiso. Egeeseega see goo midili odoo oso no neliga moso gibadeli odoo mapoo tenelaiso. Egeeseega see yayo no neliga moso ma kulodu toosoolaiso. ");
INSERT INTO kkc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Esiga ayo namapoo taka, no neliga moso ee ma kulodu badolone, nayo peegoo dilei eli agalaime. Esino molee yayo hesia sabolo tobuloso nayo yimapoo teneega, no peegoo dileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Biame omapoo odoo abo oso sibileso Yesu mapoo Gelili odoo aboso Godee mapoo gala hu wooloso tenelone doboome, Paileteeye diba piligu goo ee oposususo. ");
INSERT INTO kkc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eseme Yesuye nei dimapoo egeesee takaso, “Niyo goo hagee ogoloso kasee gooleesomo? Gelili odoo abo piligu odoo hagee biaso Gelili odoo susuga ma kulodu hedebe diayo goo tokenee toowa tomo silesibume ka seeyo? ");
INSERT INTO kkc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Haye, egeeseenee. Esino niyo nibada goo tokenee maga miligi pialoso Godee mapoo bidiga debelega poogooga, goo hedebe egeesee nosee nimapoo peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Osoloso niba goo hee hagee goolee. Sailowam mi mapoo moso egi doko tegei oso goboolone odoo 18 piliguso. Odoo 18 piligu hagee biaso Yelusalem odoo ma kulodu hedebe diayo goo tokenee toowa tomo silesibume ka seeyo? ");
INSERT INTO kkc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Haye, egeeseenee. Esino niyo nibada goo tokenee maga miligi pialoso Godee mapoo bidiga debelega poogooga, goo hedebe egeesee nosee nimapoo peledabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Osoloso Yesuye dimapoo wudu taka hee hagee takaso, “Odoo heeso geleipi ko segei ma kulodu pigi homo tabameleeso. Esino biame heeso segeli odoo oso pigi ko goolame agalame simiso. Esino sibileso egeino, pigi ko pelega molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eseme yayo o homolee bali tou teli odoo mapoo egeesee takaso, ‘Dugo bakadio hedebe di ma kulodu a goomogaso, pigi homo hagoso ko poga nalame. Esino yo ko pele. Esiga heemagee. Yayo mo homolee ma kulodu molone mi tekepo ee namalai tekeponee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eseme o tou teli odoo oso yimapoo egeesee takaso, ‘Iba epedee dugo hedebe ma kulodu bolone, ayo medee mi nemalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Egeesi ma kulodu yayo ko poga, tekepo. Esino yayo ko pelega poogooga, omapoo iba homo su egee heemagalaiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yu odoowo hasali biame hee mapoo Yesuye dia howo gisili moso mapoo peleso eligimeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Biame omapoo sobo hee dugo 18 ee ma kulodu badolone bo holoso o kulodu badoboome, yayo biame susuga ma kulodu gauwuloso siliso. ");
INSERT INTO kkc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Esino Yesuye yo ogoloso yo malalo hapoo sibe doloso yimapoo egeesee takaso, “Sobo no biame susuga ma kulodu gauwuloso egee silo epedee hamapoo olo mauwe poogooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Egeesee takoloso Yesuye o deeso sobo ee sigeso. Eseme biame omapoo sobo gauwuloso sili ee see hoododoloso tekepo silame bei mooloogooloso Godee mapoo goomoga poudooso. ");
INSERT INTO kkc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eseme howo gisili moso wiligi odoo taba oso Yesuye diayo hasali biame mapoo sobo tekepo moodoo ogoloso diya komonolone odoo susuga mapoo egeesee takaso, “Sadee hedebe ma kulodu biame 7 moloso. Esiga odoo susuga oso biame 6 ma kulodu tou talai tekepo. Esiga niyo biame 6 hama kulodu odoo paiye susuga gilimado sibileso tekepo moodoolai tekepo. Esino niyo iyo hasali biame mapoo sibileso goo egeesi moodoolai tekeponee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eseme Lodeeye nei yimapoo egeesee takaso, “Niba goo bakadio gweli odoo. Bei, niba susuga oso hasali biame mapoo bulumakau ebigi pidiga buguloso howo nalame hado diliso. ");
INSERT INTO kkc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Esiga niyo iyo hasali biame mapoo nibada be hu pidiliso. Esino iyo hasali biame mapoo Eibalahameeyo eiye hagee tiso tia masi tiamolome pidibugu egee tekeponeeyo? Bei, Saitenso kitulugu oso sobo hagee dugo 18 ee ma kulodu tiso tialoso melee masi meleeso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesuye to hagee taka goo oso yimapoo kamanali odoo mapoo simili goo teneeso. Esino odoo abo oso Yesuye goo medee tekepo moodoogamo sili ogoloso diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Osoloso Yesuye see dimapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee kaseeyo? Ayo ogoo goo maga Godeeye wiligi doloso badeli goo ee nimapoo ka eligileiyo? ");
INSERT INTO kkc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Esiga Godeeye wiligi doloso badeli goo ee egeesi masi moloso. Odoo heeso ko pepooko masted deli todileso o homolee mapoo segeiso. Esiga ko pepooko oso peleso homo toowa poloso, dee bo moodooga, sóso sibileso omapoo ou tegegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ayo ogoo goo maga Godeeye wiligi doloso badeli goo ee nimapoo ka eligileiyo? ");
INSERT INTO kkc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ee egeesi masi. Soboso palawa wo silame, daga homolone palawa wo toowa ma kulodu yist pepooko kuko siliso. Egeeseega yist pepooko oso palawa wo ee diya kodiliso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuye Yelusalem mapoo dulone, mosobia pepooko abo eli domopooga dagamo dulone, Godeeyo to eligimo diso. ");
INSERT INTO kkc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Egeeseemo dumolome odoo heeso Yesu mapoo egeesee woosaso, “Lodee, odoo wulo hedebe bakadio oso gie badeli ka talaiyo?” diso. Eseme yayo nei yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Niba osulu pepooko maga gadilame diya kitulugi. Bei, ayo nimapoo taka, odoo susuga oso osulu pepooko omaga gadilame diya kituluguleiso, esino diba omapoo gadilei tebileime. ");
INSERT INTO kkc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bei, moso eyo amaye toboloso osulu kisileiso. Egeeseega niyo peegooga silesibulone osulu yamagalame osulu mapoo kalamadileiso. Egeeseelone egeesee takalaiso, ‘Wiligi odoo, iba gasibileiya osulu yamagee,’ dalaiso. Esino yayo egeesee takalaiso, ‘A niba gooleedele. Niba mi kamaga sibadeeyo?’ ");
INSERT INTO kkc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Egeeseega niyo nei egeesee takalaiso, ‘Iba nobolo hodobo silesibulone wo sabolo howo sabolo namo siliso. Osoloso ibada mi mapoo nayo imapoo to tekepo eligimo siliso,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Esino yayo nimapoo see egeesee takalaiso, ‘A niba gooleedele. Niba mi kamaga sibadeeyo? Niba ayo hagee bado mapoo na sibadee. Amaga peegoo diyadee, niba goo tokenee tomo silesibili odoo,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Esiga niba Godeeye wiligi doloso badeli mi maga peegoo poogooga, peegooga dobolone, Eibalaham dio Yekob dio osoloso Aisek dio osoloso Godee maga to toloso kokodo takomo sili odoo susuga oso Godeeye wiligi doloso badeli mi mapoo do ogoloso gooholone mei kumudoo sabolo dobolone pupusiga malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Osoloso mipoo toowa hamapoo debeli mi susuga maga odoo susuga oso Godeeye wiligi doloso badeli mi mapoo wo nalame sibileso dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Esiga odoo susuga eyo howo woola odoo hu toowa toloso epedee hagee do, ee see hamamee Godeeyo howo woola odoo wuluge masi dabalaiso. Esino odoo susuga eyo howo woola odoo wuluge epedee hagee do, ee see hamamee Godeeyo howo woola diba hu toowa toloso dabalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Biame omapoo Pelisi odoo aboso sibileso Yesu mapoo egeesee takaso, “No mi hagee poogoloso see mi hee mapoo di. Bei, Helodeeye no wooloomalame ina,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eseme nei Yesuye dimapoo egeesee takaso, “Niba dileso dobu so masi Helodee mapoo takee, ‘A epei osoloso godigi mapoo bo holo paladee odoo sabolo osoloso odoo paigiga sabolo ee tekepo moodoolone badalaiso. Osoloso see biame bakadio hedebe di mapoo a mo tou hosudalaiso,’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tei taka, epei sabolo osoloso godigi sabolo osoloso biame hee sabolo mapoo mo tou ee osee tomo dileiso. Bei, edebeeyo Godee maga to toloso kokodo takomo sili odoo ee Yelusalem mi peegoo wooloomalai tekeponee. ");
INSERT INTO kkc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusalem, Yelusalem, nayo kasi maga Godee maga to toloso kokodo takomo sili odoo piliguloso see Godeeye diye di odoo ee piligilame yoso ka enigeliyo? A biame kasolo mapoo kolokoloso o pe medee gilimadoloso wili egeesee selame ayo nee holo gilimado sibilame goomegeliso. Esino no koo goomegeli. ");
INSERT INTO kkc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Esiga Yelusalem odoo, niba dui. Nibada tei moso ee mosoowe malaiso. Esiga ayo nimapoo taka. Niyo a see agalaime. Esino biame oso siboga, niyo egeesee takalaiso, ‘Odoo Godeeyo hu maga kitulugu sabolo egee sibo Godeeye yimapoo goomogoso,’ dalaiso. Biame omapoo niyo a see agalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yu odoo diayo hasali biame heeso Yesu Pelisi odoowo wiligi odoo taba eyo mosopoo peleso nei nalame badebeiso. Eseme odoo susuga oso Yesu mapoo medee hodu dileso yimapoo balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bei, moso ee ma kulodu odoo hee paiye toowa oso toloso o su susuga tidodoloso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Egeesee ogoloso Yesuye Pelisi odoo sabolo osoloso tei eligili odoo dimapoo egeesee takaso, “Iyo hasali biame mapoo odoo tekepo moodoolai ee ibada teiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Esino diba to hee takele. Eseme Yesuye odoo ee o deeso sigime tekepo paso. Osoloso yo diye diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Osoloso yayo see Pelisi odoo sabolo osoloso tei eligili odoo sabolo mapoo egeesee takaso, “Nima kulodu nibada holo hee, o, bulumakau egeesi oso iyo hasali biame mapoo midoo ma kulodu todobuoga, yo peegoo tamagelega pagalaisomo? Haye. Niyo yo midoo ma kuloduga peegoo tamagalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eseme diayo Yesu mapoo nei takalai me poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu moso ee ma kulodu badolone egeino, odoo susuga oso wo ne mapoo sibulone odoo hu toowa too oso bili mapoo bulumalame diya goolee sabolo sibume egeiso. Eseme Yesuye wudu taka hagee dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Odoo heeso namapoo takolone sobo hu wo ne mapoo sibeye daga, no sibileso wo nalame saga dileso odoo hu toowa too oso bili mapoo na bie. Bei, odoo hu toowa too hee nama hamamee sibilei malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Egeeseega mosowo amaye namapoo egeesee takalaiso, ‘Nayo egee bado mapoo odoo toowa oso bie dee. Esiga no toboloso hamamee koo bilame di,’ dalaiso. Egeeseega no hamameedee mapoo bilame diya simiye sabolo dileso bileiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Esino sobo hu wo nalame no sibeye daga, no sibileso hamameedee bie. Egeeseega mosowo amaye no hamameedee mapoo badebei ogoloso no see malalo koodoo peleso bie dalaiso. Osoloso wo ne mapoo buluma odoo oso goo hagee ogoloso no odoo toowa dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Esiga odoo agayo eyo nediliyo yo toowa daga, nei yo Godeeye pepooko dalaiso. Esino odoo agayo eyo nediliyo yo pepooko daga, nei yo Godeeye toowa dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Osoloso Yesuye see yo sibeye dee taka Pelisi odoo mapoo egeesee takaso, “No wo toowa nalame nee odoo sabolo osoloso nemei dio sabolo osoloso nee soosoo sabolo osoloso nee bi bei odoo sabolo na gilime. Bei, nayo diba gilimaga, nei diayo dibolo hodobo wo nalame no idileiso. Egeeseega no nei hee talaime. ");
INSERT INTO kkc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Esino no wo toowa nalame mopoodoo doloso wulo bi mauwe odoo sabolo, osoloso kido todobia odoo sabolo, osoloso su kakawa poogoo odoo sabolo, osoloso howo si odoo sabolo ee gilime. ");
INSERT INTO kkc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bei, nayo goo hageesi moodooga, Godeeye namapoo nei tenelaiso. Bei, diayo nei namapoo egeesi pidilei tebile. Esiga Godeeyo howo woola tekepo debeli odoo oso wedia maga hogadilei biame omapoo Godeeye namapoo nei tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesubolo hodobo wo nolone debei odoo heeso to hagee duloso Yesu mapoo egeesee takaso, “Godeeye wiligi doloso badeli mi mapoo peleso hodobo wo nalai odoo diba diya goomogalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eseme Yesuye yimapoo egeesee takaso, “Odoo heeso wo toowa nalame mopoodoo doloso odoo susuga gilimaso. ");
INSERT INTO kkc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Osoloso wo olo nalame o tou teli odoo hee mapoo dileso yayo gilimadoo odoo ee iyado sibe diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eseme o tou teli odoo oso diba gilimalame simi ogoloso diayo wo ne mapoo sibilei gowoolone goo abo maga gamenee goo takaso. Egeeseelone odoo heeso yimapoo egeesee takaso, ‘A mi neiso epedee too. Esiga a dileso mi egee agalaiso. Esiga nayo dileso nee wiligi odoo mapoo takee, a wo ne mapoo sibileimego dee takee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Eseme see odoo heeso egeesee takaso, ‘A bulumakau 10 neiso epedee too. Esiga bulumakau egee sabolo tou talai teiba beleso dibolo tou talame dileiso. Esiga nayo dileso nee wiligi odoo mapoo takee, a wo ne mapoo sibileimego dee takee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Osoloso see odoo heeso egeesee takaso, ‘A sobo epedee hu. Esiga a wo ne mapoo sibileime,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Odoo susuga oso egeesee takageme, to todili odoo oso see wedi dileso o wiligi odoo mapoo odoo susuga oso taka goo susuga ee yimapoo takaso. Eseme wo ne eyo wiligi odoo taba oso diya komonolone see o tou teli odoo mapoo egeesee takaso, ‘No saga dileso mosobia domopoo bi mauwe odoo sabolo, osoloso kido todobia odoo sabolo, osoloso su kakawa poogoo odoo sabolo, osoloso howo si odoo sabolo iyado sibe,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eseme o tou teli odoo oso saga dileso odoo iyado sibileso o wiligi odoo mapoo egeesee takaso, ‘Wiligi odoo, ayo odoo abo olo iyado simiso. Esino debi pooba abo odoo mauwe moloso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eseme wiligi odoo oso see o tou teli odoo mapoo egeesee takaso, ‘No see dileso odoo eli domopoo egee silesibo sabolo osoloso wadou moso mapoo debeli odoo ee hapoo sibilame to kitulugu sabolo takee, mo moso kulodu debi pooba ee edebeeyo tolo tebilame. ");
INSERT INTO kkc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Esiga ayo namapoo taka, wo ne hagee ma kulodu odoo daga ayo gilimome sibilei gowe odoo oso wo ayo mopoodoo doo nalaime,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Odoo susuga oso Yesu dedeme, Yesuye dimapoo bidi toboloso tobudulone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Odoo agayo ama sabolo, osoloso owee sabolo, osoloso osobo sabolo, osoloso owolo sabolo, osoloso o soosoo sabolo, osoloso o gie badeli sabolo mapoo diya goolone, nei a goolee pepooko daga, yo ayo di hamamee deedee sibilei tebile. ");
INSERT INTO kkc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Osoloso odoo agayo talai sabolo dala toowa talai sabolo goo medee moodelega poogoloso ayo di hamamee dedelega poogooga, yo ayo di hamamee deedee sibilei tebile. ");
INSERT INTO kkc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Edebeeyo kulo moso tegelame gooleega, yo daga badolone yayo kulo moso tegelai molee teiba beleso agalame hesigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Bei, yo daga molee hesigelega tou bei mooloogooga, molee hosudoga, tou hoo malaime. Egeeseega odoo susuga oso moso ee togodelega poogoo ogoloso manolone yiligilone egeesee takalaiso, ‘Odoo hagee moso tegelame bei mooloogooso. Esino hosudalai tebile,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wudu taka hee hagoso. Mi bakadio oso ha talaiso. Egeesi ma kulodu mosodei heeso odoo 10,000 gilimado sibileiso. Osoloso mosodei heeso odoo 20,000 gilimado sibileiso. Esino odoo 10,000 gilimadoo ha teli wiligi odoo taba oso daga medee badolone, odoo 20,000 mapoo ha talai teiba beleso goo ee goolone badalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Osoloso yayo o odoo sabolo odoo 20,000 mapoo ha talai ee koo tobuoga, yayo o odoo hee odoo 20,000 gilimado simi dia wiligi odoo taba mapoo to todi dalaiso, yibolo see mesilame. ");
INSERT INTO kkc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Esiga odoo agayo ama hamamee dadalame gooleega, yayo o bi susuga poogoloso a ka deedee sibe. ");
INSERT INTO kkc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Solu ee bi tekepo. Esino solu hadali me daga, nayo solu ee see hadalame kasee moodoolaiyo? ");
INSERT INTO kkc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Esiga solu egee goo mauwe mologa, odoo susuga oso solu egee togobigileiso. Odoo niba dulubolo, esiga ayo hagee takoo medee hoodo dui.” ");
INSERT INTO kkc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tekisi molee misigeli odoo sabolo osoloso goo tokenee teli odoo sabolo Yesuwo to dulame sibileso debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Esino Pelisi odoo sabolo osoloso tei eligili odoo sabolo oso goo hagee ogoloso gowoolone egeesee takaga meleeso, “Odoo hagoso tokenee teli odoo ee gilimadoloso dibolo hodobo wo namo siliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eseme Yesuye wudu taka hagee dimapoo takaso, ");
INSERT INTO kkc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sipi be hu bali odoo oso o sipi 100 bameleeso. Egeesi ma kulodu hedebe osugobooga, yayo ogoo goo moodoolaisomo? Yayo go woolalowe poogoo mapoo o sipi be abo 99 omapoo holoogoloso, see hedebe osugoba ee esiamo dileiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Yayo esiameleso ogoga, yo goomogolone sipi be ee mosopoo imado sibileiso. Osoloso o odoo abo ee gilimadoloso egeesee takalaiso, ‘Mo sipi be osugoba epedee olo egeiso. Esiga niba sibileso abolo goomoga poude,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Esiga ayo nimapoo taka, Kei mi mapoo odoo 99 Godeeyo howo woola tekepo debeli dia goo mapoo goomoga goo oso osee moloso. Esino goo tokenee teli odoo hedebeso o goo tokenee maga miligi pialoso see Godee mapoo bididoobooga, Kei mi mapoo goomoga toowa oso malaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Biame hee mapoo sobo hee o molee ko 10 ma kulodu hedebe osugobalaiso. Eseega yo ogoo goo moodoolaisomo? Yayo keme pudoloso esiamo silone, o moso kulodu goko oso kakabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Osoloso yayo o molee ko osugoba ee ogoga, yayo o odoo ee iyadoloso egeesee takalaiso, ‘Mo molee ko osugoba epedee olo egeiso. Esiga niba sibileso abolo hodobo goomoga poude,’ dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Esiga ayo nimapoo taka. Goo tokenee teli odoo hedebeso o goo tokenee maga miligi pialoso see Godee mapoo bididoobooga, Godeeyo momaiye susuga Kei mi ma dokodoo egee do oso goomoga toowa poudileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuye see wudu taka hee hagee odoo mapoo egeesee oposususo, “Odoo hee owolo giso holo bakadio debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Esino biame heeso omoloye ama mapoo egeesee takaso, ‘No toga nee bi ayo talai malalo epedee amapoo tenee,’ diso. Eseme amaye owolo bakadio ee ma kulodu o bi abo puloso dimapoo piso. ");
INSERT INTO kkc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eseme omoloye biame abo poogoloso hamamee amameeye yimapoo bi pi ee toloso see odoo abo mapoo neiso toloso see mi hee eli sage mapoo diso. Yo omapoo dileso tokenee goo ma kulodu badolone, o molee toowa hosudooso. ");
INSERT INTO kkc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yayo o molee toowa hosudoloso melee biame omapoo mi kibiya oso mi omapoo hodia goo meleeso. Eseme yayo see gilibo holo masi badolone, hodia goo toowa egeliso. ");
INSERT INTO kkc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Esiga yayo molee tou talame mosobia odoo hee mapoo dileso peledabaso. Eseme mosodei odoo ogoso yo o go mapoo dileso o be bamelee diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eseme yo dileso be hu nei nolone beso nali nei ee ogoloso nalame gweliso. Esino odoo heeso beyo nei sabolo osoloso nei abo sabolo yayo nalame koo tosibili. ");
INSERT INTO kkc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yayo egeesee badebei ma kulodu, biame heeso yimapoo goo goolee tekepo oso sibume, yayo egeesee gooleeso, ‘Mo mamo tou toloso nei teli odoo susuga ee hodia sabolo koo debeli. Esino a hamapoo hodia sabolo badolone talame ka seeso. ");
INSERT INTO kkc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Esiga a see wedi dileso mo ma mapoo egeesee takalaiso: Ma, ayo Godee mapoo osoloso namapoo goo tokenee olo tooso. ");
INSERT INTO kkc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A tokenee odoo. Esiga nayo see epedee amapoo mo holo dalai tekeponee. Esino tekepo, nayo a nee tou toloso nei teli odoo hee dee takee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Osoloso yo amameeye badebei mi mapoo diso. Esino yo eli sage abaga osee sibumolome, amaye ogoloso owolo diya sooloo dolone, yayo saga hoguo dileso owolo mapoo booloomaloso adaso. ");
INSERT INTO kkc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eseme owoloye yimapoo egeesee takaso, ‘Ma, a Godee mapoo osoloso namapoo goo tokenee olo tooso. A tokenee odoo. Esiga nayo amapoo mo holo dalai tekeponee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Esino amaye o tou teli odoo mapoo egeesee takaso, ‘Dugo tekepo sabolo osoloso homo bi sabolo osoloso dee sesa mapoo kali ki bi sabolo saga tosibileso yimapoo kadige. ");
INSERT INTO kkc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Osoloso mo gala hu ma kulodu bulumakau be hu kauwa wooloso si. Osoloso hodobo wo nolone goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bei, mo holo hagee olo tano, see epedee gie badoso. Osoloso olo dobudo diso, esino epedee ogoso,’ diso. Esiga diayo hodobo wo nolone goomoga poudooso. ");
INSERT INTO kkc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Diba egeeseelone doboome, emei o homolee ma kulodu tou temeleso sibulone, amayo moso kulodu odoo susuga goomogolone hopolone kosaiya pegigamolome duso. ");
INSERT INTO kkc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eseme yayo o tou teli odoo hee idoloso yimapoo woosaso, ‘Mo mamo moso ma kulodu ogoo goo tolo?’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eseme o tou teli odoo oso yimapoo egeesee takaso, ‘Nomolo epei simiso. Esiga namaye owolo yo medee tekepo wedi simi ogoloso, goomogolone bulumakau be hu kauwa wooloso siloso wo toowa ka nalagamoloso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Eseme emei goo hagee duloso komonolone wo ne mapoo dile. Eseme amaye sibileso o daga holo yo wo ne mapoo gadilame giso. ");
INSERT INTO kkc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Esino yayo ama mapoo egeesee takaso, ‘Ayo dugo susuga ma kulodu nee tou teli odoo masi silone nee to mapoo mesimo silone tou toowa temeleeso. Esino nayo gout be hu pepooko wooloso amapoo takolone, nee odoo sabolo neye, dee takele. ");
INSERT INTO kkc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Esino nowolo hagoso nee bi sabolo nee molee sabolo toloso domo sili sobo sabolo badolone hosudoloso sibume, nei nayo yimapoo goomogolone be kauwa wooloso wo toowa nolone ka dabala?’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Esino amaye owolo mapoo egeesee takaso, ‘Mo holo, nayo biame susuga abolo badebeiso. Esiga mo bi susuga ee nee. ");
INSERT INTO kkc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Esino epei iba goomogalai tekepo. Bei, nomolo hagee olo tano, epedee yo see gie ka badoso. Osoloso yo osugobano, see epei yo ogoso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuye o hamamee dili odoo mapoo egeesee takaso, “Biame heeso bi bei odooso o molee gibadeli idoloso badebeiso. Egeesi ma kulodu bi bei odoo o molee gibadeli odoo oso o molee mada namelee goo ee yo duso. ");
INSERT INTO kkc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Osoloso yayo o molee gibadeli odoo ee idoloso yimapoo egeesee takaso, ‘Nayo mo molee tokenee bameleena. Esiga no tekepo, nayo tou temelee goo susuga ee booka mapoo hoguguloso amapoo eligi. Bei, nayo see mo molee gibadalai tekeponee. Esiga no tou epedee pagalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Eseme molee gibadeli odoo oso egeesee gooleeso, ‘Mo wiligi odoo oso mo tou ee olo peegoo magooso. Esiga a see ogoo tou toomoba? A nei howo segelame mi gabalai a kitulugu mauwe. Osoloso ayo odoo mapoo wulo hoowamo silei diya simileeyo. ");
INSERT INTO kkc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Esino ayo mo tou poogooga, mo odooso a dia mosopoo ido palame, ayo goo talai epedee olo gooleedoso.’ ");
INSERT INTO kkc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Egeesee gooloso yayo o wiligi odoo mapoo bi wulayo temelee odoo ee gilimadooso. Osoloso daga odoo hee mapoo egeesee takaso, ‘Nayo mo wiligi odoo mapoo bi wulayo too eyo nei tenelega ka pagala? Nei kasolowo?’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eseme odoo ogoso nei egeesee takaso, ‘Ayo mo dalamoo 100 mapoo olipi i keedoo ee nei tenele,’ diso. Eseme molee gibadeli odoo oso nei yimapoo egeesee takaso, ‘Wiligi odoo o booka hagoso. Esiga no saga buloso booka hamapoo nayo dalamoo 100 mapoo olipi i keedeme hogugu ee tabuguloso, see dalamoo 50 mapoo olipi i keedoo ono too doloso hogugi,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Osoloso molee gibadeli oso see odoo hee mapoo egeesee takaso, ‘Nayo mo wiligi odoo mapoo bi wulayo too eyo nei tenelega ka molosomo? Nei kasolowo?’ diso. Eseme odoo ogoso nei egeesee takaso, ‘Ayo mo wogai 100 mapoo palawa wo soo too eyo nei tenele,’ diso. Eseme molee gibadeli odoo oso yimapoo nei egeesee takaso, ‘Wiligi odoo o booka hagoso. Esiga no saga buloso booka hamapoo nayo wogai 100 mapoo palawa wo soo too hogugu ee tabuguloso, see wogai 80 mapoo palawa wo soo ono too doloso hogugi,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Esino o wiligi odoo oso goo hagee duloso o molee tokenee gibadeli odoo mapoo egeesee takaso, ‘Nayo odoo abo pidi goo oso see hamamee no pidileiso,’ diso.” Eseme Yesuye see egeesee takaso, “O, mi odoo oso eyo nediliyo goolone emegei dimaga pidili goo susuga ee medee gooleedooso. Esino Godeeyo odoo oso goo egeesi moodoolai kibiya gooleedele. ");
INSERT INTO kkc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Esiga ayo nimapoo taka, niyo mipoo toowa hamapoo dobolone, nibada molee sabolo osoloso nibada bi sabolo oso emegei pidi osoloso emegei dolone ka debee. Niyo egeeseega nei bi egee mauwe poogooga, Godeeye niba Kei mi ma dokodoo kookaiyo moloso osee malai moso omapoo ido palaiso. ");
INSERT INTO kkc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Esiga edebeeyo goo pepooko medee kibiya bamologa, yo see goo toowa balai tebileiso. Osoloso odoo agayo goo pepooko balai tebilega poogooga, yo goo toowa balai tebileime. ");
INSERT INTO kkc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Esiga niyo mi toowa eyo bi medee belega poogooga, see niyo Kei mi eyo goo ee medee kasee balaisomo? ");
INSERT INTO kkc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Osoloso see niyo nee odoowo bi medee belega poogooga, odoo agayo nee bidee ee no balame namapoo ka tenelaiyo? ");
INSERT INTO kkc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Esiga edebeeyo wiligi odoo bakadio eyo to mapoo mesiloso silone tou talai tebile. Bei, yo o wiligi odoo hee goomogolone hee gowoolaiso. Egeeseelone yayo wiligi odoo heeyo to mapoo mesiloso silone, see heeyo to mapoo mesileime. Esiga edebeeyo Godee mapoo mesimo silone molee toowa toloso badalai goo mapoo mesilei tebile.” ");
INSERT INTO kkc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eseme Pelisi odoo oso Yesuye to taka hagee duloso manolone yiligaso. Bei, Pelisi odoo hagee bia molee diya goomegeli. ");
INSERT INTO kkc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eseme Yesuye dimapoo egeesee takaso, “Niba wulo edebeeyo tekepo odoo dalame, odoo howo woola gamenee goo tekepo moodeliso. Esino ee ma kulodu Godeeye niyo goo goolee olo gooleedooso. Esiga edebeeyo nibada goo ogoloso tekepo deli ee nei Godeeye nibada goo ee diya tokenee deliso. ");
INSERT INTO kkc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Godeeye tei magoo Moses mapoo tenee ee hogugu sabolo osoloso Godee maga to toloso kokodo takomo sili odoo oso to hogugu oso odoo abaga gilimado simino, Yoneeye badebei biame omapoo peledabaso. Osoloso Yoneeyo biame poogoloso hamamee mapoo to tekepo Godeeye wiligi doloso badeli goo ee odoo mapoo takaso. Esiga edebeeyo Godeeye wiligi doloso badeli goo mapoo gadilame diya ka kituluguso. ");
INSERT INTO kkc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Esiga mipoo sabolo kei sabolo oso me pagalai ee teiba. Esino Godeeye tei magoo hogugu ee ma kulodu hu bei pepuso hee peegoo pagalai tebile. ");
INSERT INTO kkc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Esiga edebeeyo osobo poogoloso, see sobo hee huga, yo sobo egee goo heli toso. Osoloso edebeeyo sobo omoye poogoo huga, yo odoo heeyo osobo ee peedee huso.” ");
INSERT INTO kkc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Biame heeso bi bei odoo badebeiso. Yo biame susuga dugo kali bi tekepo kaloso badolone nei medee tekepo nolone badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Biame domo mapoo bi mauwe odoo badebeiso, o hu Lasales. Yo o su susuga e buloso badebeiso. Esino yo biame susuga bi bei odoowo moso osulu miyopoo iboduloso badolone bi bei odoo oso nei ne kokou mou ee nalame goomegeliso. Osoloso soso sibileso o e mapoo pieliso. ");
INSERT INTO kkc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Osoloso biame abo poogoloso hamamee bi mauwe odoo Lasales taso. Eseme Godeeyo momaiye oso yo todileso Eibalahameeye badebei koola mapoo ibediso. Osoloso hamamee bi bei odoo taso. Eseme odoo aboso o su midoosooso. ");
INSERT INTO kkc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yo toloso abaga dino odoo wedia oso debeli mi mapoo dala ma kulodu badebeiso. Yo omapoo badolone, dokodoo egeino, Eibalaham eli sage badoboome ogoloso, yima koola mapoo Lasales badoboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eseme yo ilone egeesee takaso, ‘Ma Eibalaham, nayo a sooloo dele. Osoloso Lasales amapoo sibeye dee, yayo sibileso o dee wolugu oso howomoo olugudoloso, mo i mapoo sigoga, kekebie palame. Bei, a dou hagee ma kulodu dala sabolo bado,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Esino Eibalahameeye nei egeesee takaso, ‘Mo holo, no goolee. Nayo gie badebei biame omapoo bi medee tekepo ono temeleeso. Esino Lasales yo bi mauwe gilibo holo masi badebeiso. Esiga epedee Lasaleseeye hamapoo goomoga sabolo badoga, nei nayo dala ma kulodu ka badoso. ");
INSERT INTO kkc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osoloso goo hee ee, niba ogo osoloso iba ogo doloso domo omapoo goodobia diya toowa edebeeyo hodiokoo dabagalai tebile moloso. Esiga iyo hagee do omaga niyo egee do mapoo dabagalai eli mauwe. Osoloso niyo egee do omaga edebeeyo iyo hagee do mapoo dabagalai onosee eli mauwe,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Eseme bi bei odoo oso nei egeesee takaso, ‘Ma Eibalaham, ayo namapoo howaso, nayo Lasales mo mayo moso mapoo wedi diye dalame. ");
INSERT INTO kkc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bei, mo mayo moso mapoo molo dio dee tiadoo omapoo doso. Esiga Lasaleseeye see wedi dileso dimapoo kokodo takalai tekepo, diba toga see dala mi hamapoo sibiyaga,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eseme Eibalahameeye egeesee takaso, ‘Dimapoo Moseseeye tei hogugu sabolo osoloso Godee maga to toloso kokodo takomo sili odoo oso Godeeyo to hogugu sabolo olo moloso. Esiga dia goo goolee tekepo palame, diayo kokodo taka to ee dulei tekepo,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eseme bi bei odoo oso nei egeesee takaso, ‘Haye, egeesee selaime. Esino odoo hee ta maga see hogado sibileso dimapoo takooga, diayo dibada goo tokenee maga miligi pialoso Godee mapoo ka sibilei,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Esino Eibalahameeye see tobu yimapoo egeesee takaso, ‘Diayo Moseseeye tei hogugu sabolo osoloso Godee maga to toloso kokodo takomo sili odoo oso Godeeyo to hogugu omapoo tei telega poogooga, diayo see kasi maga odoo hee ta maga hogado sibileso to takooga, omapoo tei ka talaiyo?’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Biame heeso Yesuye o hamamee dili odoo mapoo egeesee takaso, “Edebeeyo goo tokenee mapoo gido dilei goo ee tei sibileiso. Esino goo egee bei mooloogoomo sili odoo mapoo, ayo yimapoo ka taka, ye-ee! ");
INSERT INTO kkc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Esiga odoo heeso tei too odoo hee goo tokenee mapoo gido duga, nei odoo heeso o mu mapoo yo toowa bagagoloso howo bou mapoo toosoolai ee dala haga toowanee. Bei, hamamee Godeeye odoo goo egeesi moodeli mapoo dala toowa tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Esiga niba niso nediliyo medee bamelee. Osoloso nee odoo tei too odoo oso goo tokenee toga, yimapoo takee. Osoloso yayo o goo tokenee mapoo goohele sabolo o tokenee mapoo miligi piaga, o tokenee egee boobado bigi. ");
INSERT INTO kkc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Osoloso yayo biame hedebe ma kulodu namapoo tokenee too ee 7 daga, osoloso namapoo sibileso yayo emegei di to taka onosee 7 daga, nayo o tokenee goo ee boobado bigi.” ");
INSERT INTO kkc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Diye di odoo oso Lodee mapoo egeesee takaso, “Iyo tei too goo ee toowa moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eseme Lodeeye nei egeesee takaso, “Niyo tei too goo oso homokoko pepooko egeesi masi nimapoo mologa, niba teiba niyo molobei hamapoo takolone, ‘No nee too sabolo tado dileso abei mapoo tebee,’ daga egeesee selaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tou teli odoo oso o wiligi odoowo homolee mapoo mi doomelee maga, o, sipi be hu bamelee maga siboga, yo wulo sibileso nei nalaime, haye. ");
INSERT INTO kkc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yo daga o wiligi odoo taba eyo nei siloso, dugo hapoo ee kaloso, nei si ee yimapoo tenelaiso. Osoloso o wiligi odoo taba oso nei naloso koodobuoga, see hamamee yayo wo sabolo howo sabolo nalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Esino yayo tou egeesi tomo siloga, o wiligi odoo taba oso nei yimapoo goomoga to takalaime. Bei, egee o tou. ");
INSERT INTO kkc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Esiga niba egeesee selai tekepo. Ayo nimapoo tou teye daga, niyo goo egee toloso egeesee takalai tekepo, ‘Iba wulo tou teli odoo. Esiga iyo tou hagee tomo silesibo goo hee talame koo seeso,’ dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yelusalem mi mapoo dulone, Gelili mi ogo osoloso Samaliya mi ogo doloso domo abaga diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yo eli domo mapoo mi pepooko hee mapoo dumolome, odoo e bia 10 egeiso. Odoo e bia 10 oso Yesu ogoloso yima hegi sibadele. Esino wulo eli sage tebisamolone, ");
INSERT INTO kkc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","toso neligidi yimapoo egeesee takaso, “Yesu, wiligi odoo, nayo iba sooloo dolone pidi!” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eseme yayo diba ogoloso egeesee takaso, “Niba dileso Godee ogo odoo ogo doloso domo debeli odoo mapoo nibada su eligi,” diso. Diba Yesuye egeesee taka duloso dimelee omapoo, dia kolo see tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Osoloso dima kulodu odoo hee o kolo tekepo pa ogoloso Yesu mapoo wedi sibulone, toso neligidi Godee mapoo goomoga poudoomo simiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Egeeseemo sibileso Yesuwo homo beiyopoo gasuwoloso badolone Yesu mapoo goomoga teneeso. Odoo hagee Samaliya odoo. ");
INSERT INTO kkc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Eseme Yesuye egeesee takaso, “Ayo odoo 10 olo tekepo moodooso. Esino odoo abo egee bia kasomo? ");
INSERT INTO kkc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bei kasi maga, Yu odoonee hedebe hagoso obusomo Godee mapoo goomoga tenelame ka wedi simiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Osoloso Yesuye odoo hamapoo egeesee takaso, “Nayo amapoo tei too maga no olo tekepo paso. Esiga no toboloso di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Biame heeso Pelisi odoo oso Yesu mapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee kopolone sibileiyo?” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Godeeye wiligi doloso badeli goo ee woola sibo agalaime. ");
INSERT INTO kkc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Osoloso edebeeyo Godeeye wiligi doloso badeli goo ee hamapoo hagee moloso, o, koogee moloso, dee takalaime. Bei, Godeeye wiligi doloso badeli goo ee nima kulodu moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Osoloso see o hamamee dili odoo mapoo egeesee takaso, “Odoo Holo mo biame oso siboga niyo agalame goomogalai biame ee sibileiso. Esino niba agalaime. ");
INSERT INTO kkc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Osoloso see edebeeyo nimapoo takolone, ‘Odoo Holo a koo badoso, o, hamapoo badoso,’ dee takooga, dia to mapoo tei toloso omapoo na agala di. ");
INSERT INTO kkc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Esino Odoo Holo ayo sibilei biame ee, kei ebiedi buguga mi susuga egee gadeebugu egeesee selaiso. Egeeseega odoo susuga oso agalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Esino daga Odoo Holo a dala toowa talaiso. Osoloso odoo epedee hagee do oso a diya gowoolaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowaye badebei biame omapoo goo peledaba, goo hedebe egeesi masi oso Odoo Holo ayo sibilei biame omapoo peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowaye badebei biame mapoo edebeeyo nei na howo na dolone dobolone, soboso giso obuo osoloso gisoso sobo huya dolone debeiso. Egeesee solone doboome, biame heeso Nowa du ma kulodu gadiso. Eseme howo toowa duwa oso sibileso odoo susuga piliguso. ");
INSERT INTO kkc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Osoloso goo hedebe egeesi masi oso Loteeye badebei biame mapoo peledabaso. Bei, Loteeye badebei biame mapoo edebeeyo nei na howo na dolone debeiso. Osoloso biso emegei nei pidi nei pidi dolone debeiso. Osoloso nei howo sogo, moso togo dolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Egeesee solone doboome biame heeso, Loteeye Sodom mi poogoloso dime, kei ma dokodooga dou sabolo osoloso yo dei heliye oso sibileso odoo Sodom mi mapoo debeli susuga piliguso. ");
INSERT INTO kkc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Esiga Odoo Holo ayo sibilei biame mapoo odoo susuga oso goo egeesi tolone doga, ee ma kulodu a ka sibilei. ");
INSERT INTO kkc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Esiga biame omapoo odoo hau mapoo badebei oso see moso kulodu o bi talame gadilei tekeponee. Osoloso odoo homolee mapoo nei howo sogomologa, yo see mosopoo wedi dilei tekeponee. ");
INSERT INTO kkc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Esiga niba Loteeyo osobowo goo ee goolee. ");
INSERT INTO kkc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Esiga odoo agayo o gie badeli eyo nediliyo pidilame wegegeega, o gie badeli egee osugobalaiso. Esino odoo agayo mo goo maga o gie badeli peegoo magooga, yo badoboso kookaiyo gie osee badalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Esiga ayo nimapoo taka, biame omapoo giso bakadio kida hedebe mapoo tileiso. Esino odoo hee ido polone, odoo heeno omapoo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Osoloso biame omapoo sobo bakadio wo gamalaiso. Esino sobo hee ido polone, sobo heeno omapoo pagalaiso.  ");
INSERT INTO kkc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Osoloso biame omapoo giso bakadio homolee ma kulodu tou tomo sileiso. Esino odoo hee ido polone, heeno omapoo pagalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesuye to hageesee takoloso koodobume, o hamamee dili odoo oso yimapoo egeesee takaso, “Lodee, goo hagee kamapoo peledabalaiyo?” diso. Eseme Lodeeye dimapoo nei egeesee takaso, “Mi hee mapoo gala ta eyo su hune mologa, kukodee susuga hune egee nalame omapoo busiliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Osoloso Yesuye see tobu wudu taka hamaga o hamamee dili odoo dimapoo eligiso, diayo biame susuga Godee mapoo takomo silone gowoolega pagalame. ");
INSERT INTO kkc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Egeeseelone yayo egeesee takaso, “Mi hee mapoo goo midili odoo badebeiso. Esino yo Godeebolo ebilega badolone, odoo koo gweli. ");
INSERT INTO kkc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Osoloso mi hedebe omapoo sobo bau hee badebeiso. Esino sobo hagoso biame susuga goo midili odoo hamapoo sibileso howolone egeesee takeliso, ‘Nayo a pidilone odoo amapoo ha egee tomolo eyo goo midi,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Esino goo midili odoo oso daga sobo hagee pidilei yo goomegele. Esino biame susuga sobo hagoso yimapoo sili sileeme ogoloso egeesee gooleeso, ‘A Godeebolo koo ebili osoloso a odoo koo gweli. ");
INSERT INTO kkc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Esino a sobo hageeyo to dumeleso diya gowoo. Esiga yayo see mo moso mapoo sibili ee pagalame yo pidileiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Esiga Lodeeye egeesee takaso, “Goo medee koo midili odoo eyo goo hagee ogoloso goo goolee medee kibiya te. Bei, goo midili odoo hagoso daga sobo hagee pidilei gowoomeleso see hamamee yo pidiso. ");
INSERT INTO kkc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Esiga Godeeye hesiga odoo oso biame sabolo gesi sabolo yimapoo hoowa mologa ogoloso diba tei pidileiso. Osoloso yayo diayo yimapoo taka to ee duloso nei tenelai koo dagili. ");
INSERT INTO kkc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Esiga ayo taka, Godee o odoo oso yimapoo hoowa duloso goomoga sabolo diba pidiliso. Esino Odoo Holo ayo see wedi sibilei biame mapoo, mipoo hamapoo tei too goo ee molo agalaisomo?” ");
INSERT INTO kkc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Odoo abo dieso nediliyo diba Godeeyo howo woola tekepo dolone, hee odoo abo tokenee deli odoo mapoo Yesuye wudu taka hageesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Odoo bakadio, Pelisi odoo sabolo osoloso tekisi molee misigeli odoo sabolo, Yu odoowo tei moso mapoo Godee mapoo takalame palaso. ");
INSERT INTO kkc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Osoloso Pelisi odoo oso toboloso obusomo tobudulone dokodoo hageesee takaso, ‘Godee, a namapoo goomoga to taka. Bei, a odoo abo egeesinee. Bei, diba adaba bi teliso, osoloso goo tokenee teliso, osoloso diba adaba sobo sabolo giso sabolo heli teliso. Osoloso a see tobu namapoo goomoga to taka. Bei, a tekisi molee misigeli odoo keeseenee. ");
INSERT INTO kkc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bei, a sadee hedebe ee ma kulodu biame bakadio nei nelega tei doloso badeliso. Osoloso ayo bi too biame mapoo mo bi 10 ee ma kulodu hedebe namapoo teneliso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Esino tekisi molee misigeli odoo oso hamameedee hoogoo bia omaga toboloso o goo tokenee mapoo gooholone o su eyo nediliyo o budo mapoo kobuguloso oo goobodo buloso tobudulone Godee mapoo egeesee takaso, ‘Godee, a tei medee diya tokenee odoo. Esiga nayo a sooloo dolone mo goo tokenee eyo nei na tenee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Esiga ayo nimapoo taka, tekisi molee misigeli odoo hagoso o mosopoo wedi dulone, Godeeyo howo woola abaga tekepo odoo doloso diso. Esino Pelisi odoo mapoo goo hageesi mauwe meleeso. Esiga odoo agayo eyo nediliyo yo toowa daga, nei yo Godeeye pepooko dalaiso. Esino odoo agayo eyo nediliyo yo pepooko daga, nei Godeeye yo toowa dalaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Biame hedebeso odoo aboso holope Yesu mapoo ido sibadeeso, o deeso sigoloso pidilame. Esino o hamamee dili odoo oso goo egee ogoloso hamaga takaso. ");
INSERT INTO kkc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Eseme Yesuye holaiso gilimadoloso, o hamamee dili odoo dimapoo egeesee takaso, “Holaiso amapoo sibilei soowa. Niyo na hamaga takee. Bei, edebeeyo holaiso hageesi masi poga, diba Godeeye wiligi doloso badeli mapoo gasibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ayo nimapoo taka, edebeeyo o goo holaiso masi amamo to mapoo mesimo sili, egeesi selega poogoloso, Godee mapoo mesilega poogooga, yo Godeeye wiligi doloso badeli mapoo gasibilei mauwe.” ");
INSERT INTO kkc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wiligi odoo heeso sibileso Yesu mapoo egeesee takaso, “Eligili odoo tekepo, ayo ogoo goo toga kookaiyo badoboso gie badeli ka talaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eseme Yesuye nei yimapoo egeesee takaso, “Bei kasalame nayo a tekepo odoo dee ka takala? Tekepo odoo hee koo badoso. Esino hedebe Godeeno tekepo. ");
INSERT INTO kkc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Esiga Godeeyo tei magoo no olo gooleedooso: adaba kooka sobo na peedee hui, osoloso odoo na wooloome, osoloso heli na te, osoloso odoo hee mapoo gamenee na gigidi, osoloso nama dio noowee dio oso taka to omapoo mesie.” ");
INSERT INTO kkc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eseme odoo oso Yesu mapoo egeesee takaso, “A holope pepooko maga simi tei magoo susuga hagee tobuloso tomo simiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eseme Yesuye o to duloso nei egeesee takaso, “No goo hedebe dooboo dagadi moloso. No dileso nee bi susuga odoo abo mapoo tenee, nei molee talame. Osoloso bi too eyo nei molee ee bi mauwe odoo mapoo pi. Nayo egeesee seega, Kei mi ma dokodoo bi tekepo nee hu sabolo mologa agalaiso. Esiga no a deedee sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Odoo hagoso Yesuwo to duloso diya pupudaso. Bei, yimapoo bi bei meleega. ");
INSERT INTO kkc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eseme Yesuye yimapoo bolone egeesee takaso, “Bi bei odoo oso Godeeye wiligi doloso badeli mapoo gadilei diya kalawa. ");
INSERT INTO kkc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Esiga dugo duseli midole ou maga kemol be toowa oso gadilei kalawa. Esino bi bei odoo oso Godeeye wiligi doloso badeli mapoo gasibilei diya kalawa toowa.” ");
INSERT INTO kkc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eseme o hamamee dili odoo oso eligi goo hagee duloso egeesee takaso, “Esino kalawa egee odoo agayo gie badeli ka talaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eseme Yesuye dimapoo egeesee takaso, “Edebeeyo eyo nediliyo o gie badeli pidilei tebile. Esino hedebe Godee yino teiba. Bei, yayo goo susuga ee moodoolai yimapoo kalawa mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eseme Pitaye Yesu mapoo egeesee takaso, “Iba ibada bi susuga poogoloso, no dodomo simiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Eseme Yesuye dimapoo nei egeesee takaso, “Ayo nimapoo taka, edebeeyo Godeeye wiligi doloso badeli goo maga o moso sabolo, osoloso osobo sabolo, osoloso emei dio sabolo omolo sabolo, osoloso ama dio owee dio sabolo, osoloso owolo dio sabolo poogoloso siboga, yayo epedee hamapoo nei toowa talaiso. Osoloso hamamee yo kookaiyo badoboso gie badeli talaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Osoloso see Yesuye o hamamee dili odoo 12 gilimadoloso peegoo gilimado dileso dobolone dimapoo egeesee takaso, “Iba epei Yelusalem mi mapoo poloso. Esiga Godee maga to toloso kokodo takomo sili odoo oso daga Odoo Holo mo goo hogugu susuga omapoo peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Osoloso a Yu odoonee mapoo tenelaiso. Osoloso diayo a manalaiso, osoloso amapoo tokenee goo moodoolaiso, osoloso amapoo makawo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Osoloso a tiso dabalaiso, osoloso a wooloomalaiso. Esino a midoo ma kulodu tamoloso, biame bakadio hedebe di poogoloso see gie badeli toloso hogabileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Esino Yesu o hamamee dili odoo oso to hagee duloso goo eyo bei medee kibiya gooleedele. Bei, goo eyo bei dimaga mada magooga. ");
INSERT INTO kkc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Yeliko mi koola mapoo sibumolome, odoo howo neliga oso Yesuye sibilei eli pee mapoo badolone molee howameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Egeeseelone odoo mooloogoodoo susuga oso to boowoomo sibume duloso odoo abo mapoo woosaso, ogoo goo oso peledaba beleso. ");
INSERT INTO kkc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eseme odoo aboso yimapoo takolone egeesee takaso, “Yesu Nasalet odoo oso odoo abo sabolo ka diyadee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yo to hagee duloso neligidi iso, “Yesu, Deibidiyo amawe, nayo a sooloo dolone a pidiye!” demeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Esino odoo malalo diyadee oso yimapoo to kitulugu sabolo egeesee takaso, “No to mauwe badebee,” diso. Esino edebeeyo yimapoo egeesee takeme, yayo dia to mapoo dulega, to kitulugu sabolo neligidi egeesee takolone badebeiso, “Deibidiyo amawe, nayo a sooloo dolone a pidiye!” demeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eseme Yesu o to duloso omapoo kookoo toboloso tobudulone, odoo abo dimapoo egeesee takaso, “Odoo egee hamapoo ido sibe,” diso. Osoloso odoo howo si olo Yesu mapoo ido sibileso badoboome, Yesuye yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“No ayo namapoo ogoo goo moodoolai goomogodo?” diso. Eseme howo neliga odoo oso nei yimapoo egeesee takaso, “Lodee, mo howo tekepo pe. A see agalai goomogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eseme Yesuye yimapoo egeesee takaso, “Esiga no epedee nee howo see ege. Bei, no tei tooga, no see olo tekepo paso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Eseme haga booloogelega o howo bakadio see tekepo paso. Eseme yayo Yesubolo dulone Godee mapoo goomoga poudoomo diso. Eseme goo peledaba hagee egei odoo susuga oso Godee mapoo goomoga poudoomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Yeliko mi mapoo peledoboloso, see mi domo abaga dimeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mi omapoo tekisi molee misigeli wiligi odoo taba badebeiso, o hu Sekiyes. Osoloso yo bi bei odoo. ");
INSERT INTO kkc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesu eli domo abaga dumolome, odoo susuga oso yo agalame diya mooloogoodooso. Sekiyes yo Yesu agalai goomogaso. Esino yo odoo diya deiyepoga, yayo Yesu agalai odoo mooloogoodoo oso yo gooloogooso. ");
INSERT INTO kkc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eseme Sekiyes yo Yesu agalame Yesu diayo sibademelee eli su mapoo malalo saga hoguo dileso homo ma dokodoo peleso badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eseme Yesuye sibileso egeino, Sekiyes yo homo ma dokodoo peleso badoboome ogoloso yimapoo egeesee takaso, “Sekiyes, no saga miyomoo mei. A epei nobolo hodobo nee mosopoo dilei goomogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eseme yo saga miyomoo meileso, goomoga sabolo Yesu o mosopoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Osoloso odoo susuga oso goo hagee ogoloso diya gowoolone egeesee takaso, “Yesu tokenee teli odoowo mosopoo diso,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Osoloso diba dileso Sekiyeseeyo moso mapoo dobolone Sekiyeseeye toboloso egeesee takaso, “Lodee, a epei goo hageesi moodoolaiso: Ayo mo bi abo hodio ee bi mauwe odoo mapoo pileiso. Osoloso adaba molee ayo gamenee taka maga ayo hedebe too eyo nei see mawo dimapoo nei toowa bakadio bakadio di egeesi dimapoo tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eseme Yesuye Sekiyeseeyo to duloso yimapoo egeesee takaso, “Epei moso hageeyo kulodu debeli odoo mapoo gie badeli goo olo tosimiso. Bei, Sekiyes hagee nosee Eibalahameeyo amawe. ");
INSERT INTO kkc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bei, Odoo Holo ayo simi hagee tei tele poogoo odoo peegoo osugoba ee esiameleso ogoloso diba gilimadoloso dimapoo gie badeli tenelame ka simi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Edebeeyo Yesuwo to hagee dulone dobolone egeesee goolone debeiso, “Yesu Yelusalem koola mapoo sibileso badoso. Esiga Godeeye wiligi doloso badeli goo onosee koola tooboo malaiso,” demeleeso. Egeesee gooloogamelee ogoloso, Yesuye wudu taka hagee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","“Osoloso wiligi odoo hee mi eli sage mapoo gibadeli hu tala dilame badolone, o tou teli odoo 10 gilimadoloso dimapoo molee ko mina deli hedebe tenee, hedebe tenee diso. Esiga yayo dimapoo egeesee takaso, ‘Niyo ayo see wedi sibilei ee bolone molee see toowa palame, biyo moso togoloso bei mooloogee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Osoloso yo dime, o mosobia oso yo diya gowoolone, yima hamamee odoo abo diye diso, yayo diba gibadalai goo maga diayo gowe goo ee takalame. ");
INSERT INTO kkc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Esino odoo egee gibadeli hu toowa toloso see wedi simiso. Yo see wedi sibileso odoo molee yayo pi ee gilimadooso, molee toowa mala beleso agalame. ");
INSERT INTO kkc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Osoloso daga odoo heeso malalo sibileso egeesee takaso, ‘Nayo molee amapoo tenemeni oso biyo moso togoloso bei mooloogoloso see molee ko mina deli abo 10 egeesi tooso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eseme gibadeli odoo oso yimapoo goomogolone egeesee takaso, ‘No tou medee tekepo todoo. Esiga nayo goo pepooko hagee medee bameleega, see nayo mi 10 wiligi doloso bolone badalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Eseme see omapoo badeli tou teli odoo hee oso sibileso egeesee takaso, ‘Nayo molee amapoo tenemeni oso biyo moso togoloso bei mooloogoloso see molee ko mina deli abo dee tiadoo egeesi tooso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eseme gibadeli odoo oso yimapoo egeesee takaso, ‘Nayo mi dee tiadoo wiligi doloso bolone badalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Osoloso see tou teli odoo hamameedee oso sibileso egeesee takaso, ‘Wiligi odoo, nee molee hagoso. Nayo amapoo teneme, todileso dugoso tiadoloso mada magooso. ");
INSERT INTO kkc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bei, no diya kitulugu odoo. Esiga a nobolo diya ebiaso. Osoloso nayo kitulugu maga odoo aboso bi ma ee teliso. Osoloso odoo aboso nei segei nayo gebiseliso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eseme o wiligi odoo taba oso yimapoo egeesee takaso, ‘No tou tokenee teli odoo. Esiga no to egeesee taka goo omaga, ayo nee goo midileiso. Bei, nayo takolone a diya kitulugu odoo diso. Osoloso nayo amapoo takolone ayo kitulugu maga odoo aboso bi ma ee teliso diso. Osoloso odoo aboso nei segei nayo wulo gebiseliso. ");
INSERT INTO kkc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Egeesi ma kulodu bei kasi maga molee toowa palame molee gibadeli odoowo mosopoo magelega ka poogoowo, ayo see wedi sibileso molee toowa poloso mologa ka talai?’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yo egeesee badolone odoo koola omapoo tebidi mapoo egeesee takaso, ‘Niba yimapoo molee ko mina deli egee molo toloso see molee ko mina deli 10 too odoo mapoo tenee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eseme diayo yimapoo egeesee takaso, ‘Wiligi odoo, no ege, yo molee ko mina deli 10 olo toloso badoso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Esino wiligi odoo oso dimapoo egeesee takaso, ‘Ayo nimapoo taka, odoo agayo dimapoo bi tenee ee medee gibadoga, dimapoo see bei tenelaiso. Esino odoo agayo dimapoo tenee bi ee medee gibadelega poogooga, dimapoo bi pepuso abo egee molo toloso peegoo todileiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Osoloso odoo agayo ayo diba gibadalame seme amapoo gowe, diba hamapoo iyado sibileso mo howo woola piligi,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuye to taka hagee koodobuloso see Yelusalem mapoo dimeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yo Olipi mubi kuli mapoo mosodei bakadio, Betapage osoloso Betani koola mapoo peledabaso. Osoloso o hamamee dili odoo bakadio diye dolone dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mosodei koogee mapoo dileso omapoo ogoga, be hu gie kauwa donki edebeeyo wagi ma dokodoo buloso dilega poogoo ee, o mu mapoo ebigiso bagagoloso, omou mapoo bagagoo moloso. Esiga be ee niyo ebigi pidi poogoloso, hapoo hado sibe. ");
INSERT INTO kkc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Egeeseega odoo heeso sibileso nimapoo takolone, ‘Bei kasalame be hu donki ebigi ka pidibagala’, dee takooga, niyo yimapoo to nei egeesee takee, ‘Lodeeye be hagee talai goomogona,’ dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eseme o hamamee dili odoo oso Yesuye taka to ee duloso mi omapoo diyadeeso. Diba dileso egeino, goo susuga Yesuye taka to sabolo tobuloso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eseme diba donki be hu ee ebigi pidimeleeno, be eyo amameeye dimapoo egeesee takaso, “Niba kasalame be ebigi ka pidibagala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eseme nei diayo dimapoo egeesee takaso, “Lodeeye be hagee talai goomogona,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eseme diayo donki be ee Yesu mapoo hado simiso. Osoloso dibada kekeisili dugo tigadoloso donki be eyo wagi ma dokodoo maloso, Yesu dee mapoo toloso dokodoo bediso. ");
INSERT INTO kkc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yo be ma dokodoo buloso dumolome, odoo susuga oso dibada kekeisu dugo susuga tigadoloso yayo dilei eli mapoo poomo diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Osoloso Yesuye Olipi mubi ma dokodooga Yelusalem mapoo moumolome, o hamamee dedeli odoo susuga oso yayo goo opusomo di moodoomo silee goo maga Godee mapoo goomoga neligidi poudoomo mouso. ");
INSERT INTO kkc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Egeeseelone diayo egeesee takaga meleeso, “Wiligi odoo taba ee Godeeyo hu maga kitulugu sabolo egee sibo o hu dokodoo poude! Osoloso Kei mi ma dokodoo mesie goo oso mele dee! Osoloso Kei mi ma dokodoo badeli Godee mapoo goomoga poude!” dee takolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Esino mooloogoodoo toowa ee ma kulodu Pelisi odoo abo omapoo debeiso. Diayo Yesu mapoo egeesee takaso, “Eligili odoo, no nee hamamee dedeli odoo diba to koodobilame dimapoo to kitulugu sabolo takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo taka, odoo hagee bia oso to mauwe duga, nei yo susuga hagoso to neligidi kesalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu Yelusalem koola mapoo dulone, Yelusalem mi ee malalo molo ogoloso pusulone egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yelusalem odoo, niba kaseeyo? A diya goomogo, epedee niyo mesie goo toloso sibilei goo ono diya gooleedalame. Esino niba goo hagee medee ogoloso koo gooleedo. Bei, mesie goo ee nimaga mada magoo moloso. ");
INSERT INTO kkc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Esiga nimapoo ha teli odoo oso nee mi beelee pee maga sulo doboloso mi kukaloso omaga peleso mi edebeeyo bia ee ma kulodu gadilei biame oso nimapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Osoloso diayo nibada moso guobuguloso odoo susuga piligileiso. Osoloso nibada mi guobugu ee ma kulodu yo heeso yo hee ma tobudoo molo agalaime. Esiga goo hageesi oso nimapoo peledabalaiso. Bei, Godeeye niba pidilame simi ee niyo medee ogoloso koo gooleedo.” ");
INSERT INTO kkc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu Yelusalem mi mapoo gadileso Yu odoowo tei moso mapoo palaso. Yo moso ee ma kulodu gapeleso tobudulone egeino, odoo susuga oso bi odoo abo mapoo tenelo nei ka to domolome egeiso. Eseme yayo bi eyo ama dio susuga moso ee ma kuloduga peegoo hasiso bugulone egeesee takomo sileeso, ");
INSERT INTO kkc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Niba goolee, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Mo tei moso ee howo gisili moso oso,’ diso. Esino niyo Godeeyo moso hagee heli teli odoo oso mada debeli moso paso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu Yelusalem mi mapoo dileso badolone biame susuga Yu odoowo tei moso ma gapeleso odoo susuga mapoo Godeeyo to eligimeleeso. Eseme tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo, osoloso Yu odoowo wiligi odoo tebisa oso Yesu wooloomalame eli esiamo silesibiso. ");
INSERT INTO kkc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Esino diba Yesu wooloomalai eli egele. Bei, odoo susuga oso Yesuye eligi goo ee hodu dileso diya goomoga sabolo duliso. ");
INSERT INTO kkc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Biame hee mapoo Yesu Yu odoowo tei moso mapoo peleso odoo susuga mapoo Godeeyo to eligimolome, tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo, osoloso Yu odoowo wiligi odoo oso Yesu mapoo sibileso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“No ogoso kitulugu maga goo hagee ka moodoomo silala? Odoo agayo namapoo kitulugu hagee ka teneeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Eseme Yesuye dimapoo nei egeesee takaso, “Ayo woosali to hedebe nimapoo woosalaiso. Esiga niyo amapoo takee, ");
INSERT INTO kkc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Odoo howo olugumo silame Yonee mapoo kitulugu odoo agayo ka teneeyo? Godeeye teneeyo, o, edebeeyo teneeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eseme diayo to hagee duloso, dieso nediliyo dima kulodu to moulone egeesee takaso, “Iyo kasee takalaiyo? Iyo Godee maga simi dee takooga, yayo imapoo egeesee takalaiso, ‘Bei kasi maga niyo Yoneeyo to mapoo tei telega ka poogoowo?’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Osoloso iyo see yayo kitulugu ee edebeeyo teneedoo, dee takooga, see odoo susuga oso imapoo komonolone iba wooloomalame yoso enigileiso. Bei, odoo susuga oso Yonee yo tei Godee maga to toloso kokodo takomo sili odoodoo, dee gweliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Egeeseelone diayo nei Yesu mapoo egeesee takaso, “Yoneeye kitulugu too eyo bei, iba gooleedele,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eseme Yesuye dimapoo egeesee takaso, “Esiga ayo kitulugu tomo hagee sulo goo ee nimapoo takalaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Osoloso Yesuye see wudu taka hamaga odoo mapoo egeesee takaso, “Biame heeso odoo hee o homolee ma kulodu geleipi howo segeiso. Yo geleipi howo sogoloso eyo nei odoo abo maga nei tamalame dimapoo bameleeye doloso, yo mi hee eli sage mapoo badalame diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yo omapoo dileso badoboome, homokokoso bi moodoolai biame oso simiso. Osoloso yayo o tou teli odoo hee mapoo o homolee mapoo dileso homokoko abo diayo goolooga ee tala dileso tosibeye diso. Esino omapoo dileso peledoboome, homolee gibadeli odoo oso yo woomele poogoloso bi mauwe see wedi di diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Egeesee ogoloso amameeye tou teli odoo hee diye diso. Esino gibadeli odoo oso odoo hagee sabolo woolone yimapoo ebili goo teneloso bi mauwe see wedi diye diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eseme amameeye see tobu o tou teli odoo hee diye diso. Esino yinosee gibadeli odoo oso woomele poogoloso peegoo habuguso. ");
INSERT INTO kkc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Egeesee see ogoloso amameeye eyo egeesee gooleeso, ‘Ayo ogoo goo moodoolaiyo? A see mo holo ayo gooma diye dalaiso. Egeesee seega diayo o to mapoo mesilei malaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Esino homolee gibadeli odoo oso homolee eyo amayo owoloye simi ogoloso dieso nediliyo egeesee takaga meleeso, ‘Holo hagoso ama toga, amamo bi gilibo susuga ee yayo talaiso. Esiga yo wooloomaloso homolee hagee iyo tomo,’ dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Egeeseelone diayo holo egee homolee peegoo ido dileso wooloomaso.” Yesuye to hagee taka koodobuloso badolone o to dulone debei odoo mapoo egeesee takaso, “Homolee eyo amameeye homolee gibadeli odoo mapoo ogoo goo moodoolaiyo? ");
INSERT INTO kkc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yo sibileso diba piliguloso see odoo dia toloso o homolee gidebeeye dalaiso,” diso. Eseme odoo susuga Yesuwo to dulone debei oso egeesee takaso, “Goo hageesi oso peledabalai tekeponee,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Esino Yesuye dimapoo bolone egeesee takaso, “Esino bei kasalame Godeeyo to booka mapoo hogugu oso egeesee ka takoosomo? ‘Moso tegeli odooso omou gowoolone togobugu oso see moso omu domo pupodoo ka moloso.’ ");
INSERT INTO kkc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Esiga odoo agayo omou omapoo takodee buguloso homodobuoga, yo dala toowa talaiso. Osoloso omou oso odoo hee bulugu magooga, odoo ee ebidi bigileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eseme tei eligili odoo sabolo osoloso tei moso wiligi odoo tebisa sabolo oso Yesuye wudu taka hagee gooleedoloso takolone, “Ibada goo ee takoo,” doloso, yo omapoo talame eli esiaso. Esino diba odoo mooloogoodoo toowa ogoloso Yesu talai ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Egeesi ma kulodu tei eligili odoo sabolo, osoloso tei moso wiligi odoo tebisa sabolo oso Yesu wooloomalame eli esilone, diayo eli kweli odoo abo diye dolone egeesee takaso, “Niba dileso gamenee odoo tekepo masi silesibulone, yimapoo woosali to oso woosamo silesibe. Egeesi ma kulodu Yesuye nei to tokenee kasee takooga, iyo yo toloso gamalee wiligi odoo mapoo tenelaiya,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eseme diayo Yesu mapoo dileso to hodolone egeesee takaso, “Eligili odoo, iba gooleedooso, nayo eligi ma kulodu no hedebe tekepo goo ono eligili. Osoloso no odoo su mapoo koo egeli. Esino no tei Godeeyo goo ono ka eligimo sili. ");
INSERT INTO kkc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Esiga Loum gamalee wiligi odoo Sisa mapoo tekisi molee tenelai tekepowo, o, tokeneeyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Esino diayo Yesu yimapoo gamenee takalame si gooleedoloso dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Amapoo molee ko hee eligi,” diso. Osoloso yayo molee ko toloso tobudulone egeesee takaso, “Molee hamapoo agamo mudu sabolo osoloso agamo hu sabolo mololo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eseme diayo nei yimapoo egeesee takaso, “Sisayo mudu sabolo, osoloso o hu sabolo oso ka molo,” diso. Eseme Yesuye tobudulone dimapoo egeesee takaso, “Niba Sisayo bi ee Sisa mapoo tenee, osoloso Godeeyo bi ee Godee mapoo tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eseme diayo Yesuye to nei tekepo taka duloso diya howoogadolone to abo takele poogooso. Egeesi ma kulodu Yesuye odoo howo woola to tokenee takelega poogoome, diayo yo talai eli egele poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Osoloso Sedisi odoo aboso Yesuye badebei mapoo sibadeeso. Odoo hagee biaso takolone odoo wedia see hogogabileime deliso. Eseme diayo sibileso Yesu mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Eligili odoo, Moseseeye imapoo kokodo takolone egeesee hoguguso, ‘Gisoso sobo huloso holo soomagelega toga, see omoloye emei ta eyo osobo bau huloso emeiyo hu maga holo soolooga magee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Esiga odoo heeso giso holo 7 soomagooso. Osoloso daga emeiye sobo huso. Osoloso yo holo soomagelega taso. ");
INSERT INTO kkc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Osoloso omoloye emei ta eyo osobo bau huso. Esino holo soomagelega taso. ");
INSERT INTO kkc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Osoloso omolo hee domo oso bau see huloso, holo soomagelega taso. Egeesee semelee ososee omolo dio 7 susuga holo soolooga magelega wediaso. ");
INSERT INTO kkc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Osoloso hamameedee sobo bau yinosee taso. ");
INSERT INTO kkc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Esiga odoo wedia maga see hogogadilei biame mapoo sobo egee tei odoo agamo osobo dalaisomo? Bei, giso 7 oso sobo hedebe hagee huso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Esino Yesuye to nei dimapoo egeesee takaso, “Epedee hagee do biame omapoo gisoso sobo huya, osoloso soboso giso obuo dolone ka doso. ");
INSERT INTO kkc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Esino Godeeye hesiga odoo oso wedia maga hogabuloso doga, diba see giso sabolo sobo sabolo huleime. ");
INSERT INTO kkc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bei, diba Godeeyo momaiye masi dobolone see wedileime. Osoloso diba Godeeyo owolo dio doloso dabalaiso. Bei, diba wedia maga hogogadi goo oso ka eligiso. ");
INSERT INTO kkc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Esiga Moseseeye daga hoogoo edebeeyo wedia maga hogogabilei goo ee o booka mapoo hoguguso. Bei, yayo homo du douso namolome, ogoloso goo ee hogugulone egeesee takaso, ‘Lodee yo Eibalaham, Aisek, osoloso Yekob dibada Godeeso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Esiga Godee hagee wedia odoo dia Godeenee. Haye, odoo gie egee do dia Godee. Bei, Godeeyo howo woola odoo susuga gie doso.” ");
INSERT INTO kkc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eseme tei eligili odoo abo oso Yesu mapoo nei egeesee takaso, “Eligili odoo, nayo egee takoo tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eseme ee ma kulodu odoo susuga oso see Yesu mapoo woosalai ebiaso. ");
INSERT INTO kkc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Osoloso Yesuye see odoo susuga mapoo woosali to hagee takaso, “Bei kasi maga odoo aboso takolone Keliso ee Deibidiyo amawe dee ka takeliyo? ");
INSERT INTO kkc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Esino Deibidi eyo Sam booka ma kulodu egeesee takaso, ‘Godeeye mo Lodee mapoo egeesee takaso: No abolo wiligi doloso badalame mo dee deedee dokolo bie. ");
INSERT INTO kkc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Esiga nayo badolone namapoo ha teli odoo ee ayo dagadileiso.’ ");
INSERT INTO kkc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Esiga Deibidiye Keliso o Lodee diso. Esino kasi maga Keliso ee Deibidiyo amawe dee ka takalaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Odoo susuga oso to dulone osee doboome, Yesuye o hamamee dili odoo mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Niba obeeyamo! Niyo tei eligili odoo mapoo medee ege. Diba dugo medee tekepo megigaloso silesibiliso, osoloso bi neiso teli mi mapoo debeli odoo oso diba ogoloso gauwuloso emegei di to takooga ee dulei onosee diya goomegeliso. Osoloso diba howo gisili moso ma kulodu wiligi odoo taba eyo debi mapoo bulumulame, osoloso wo toowa nolone odoo hu toowa too oso bili mapoo bulumulame goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Esino diayo sobo bauwe ebilame gamenee takoloso, dia moso sabolo bi sabolo diayo toloso omapoo dobolone, dia goo gagaloso Godee mapoo taka diya sageliso, odoo aboso diba tekepo odoo dee goolame. Esiga goo egeesi maga diba nei dala toowa talaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu tei moso mapoo osee badolone egeino, bi bei odoo oso emegei di molee tooseli ki bi oso moodoo mapoo soomolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Osoloso biame omapoo sobo bau bi mauwe oso molee ko ta bakadio tosibileso toosoome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eseme Yesuye goo hagee ogoloso egeesee takaso, “Ayo nimapoo taka, sobo bau bi mauwe hagoso tenee oso bi bei odoo oso tenee ee dagadiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bei, bi bei odoo dia molee toowa osee molome molee su pepooko teneeso. Esino sobo bau bi mauwe hagee yimapoo molee ko esiesibo meleeno teneeso. Esiga yo wo talai molee olo mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Biame omapoo odoo aboso tei moso yo tekeposo tegei sabolo osoloso odoo susuga oso Godee mapoo tenee bi tei moso ma kulodu ma molome ogoloso tekepo dee takaga meleeso. Esino Yesuye diayo takaga melee to ee duloso dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Niyo epedee moso sabolo osoloso bi sabolo ogoloso tekepo dee takemeni, ee hamamee guobigileiso. Egeesi ma kulodu yo heeso hee ma tobudoo malaime. Esino moso guobuguga, yo susuga oso mi mapoo misigeduboloso molo agalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eseme odoo aboso yimapoo egeesee takaso, “Eligili odoo, goo hagee kopolone ka peledabalaiyo? Osoloso goo hagoso peledabalame mologa, ogoo gooso imapoo ka eligileiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Esino Yesuye see dimapoo egeesee takaso, “Niba obeeyamo! Odoo heeso niba tei goo maga see peegoo gilimado diyaga. Bei, odoo aboso sibileso gamenee takolone ayo diba diye di, dee takolone dieso nediliyo diba Kelisoso dalaiso. Egeeseelone diayo takolone Godeeyo biame olo simiso dee takooga, dia to duloso omapoo tei na te. ");
INSERT INTO kkc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Esiga ha too goo sabolo osoloso galali goo sabolo oso peledoboomo duga, duloso niba haga na ebi. Bei, goo hageesi oso malalo peledabalaiso. Esino ee ma kulodu biame hamameedee saga sibileime.” ");
INSERT INTO kkc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Osoloso Yesuye see tobu dimapoo egeesee takaso, “Mi toowa heeso mi toowa hee mapoo ha talaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Osoloso biame omapoo mi abo mapoo mibia toowa sibileiso, osoloso hodia goo sibileiso. Osoloso paiye opusomo opusomo di oso mi abo mapoo sibileiso. Egeesee semelee mapoo goo opusomo di oso kei ma dokodoo peledaba ogoloso odoo susuga oso diya ebigileiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Esino goo hagoso epedee peledebelega mologa, niyo mo goo maga dala toowa talaiso. Egeesi ma kulodu odoo susuga oso nibada goo midilame dibada howo gisili moso mapoo ido polo dolone dabalaiso. Osoloso diayo niba neliga moso mapoo huyaso dolone dabalaiso. Osoloso see diayo mo goo maga niba gamalee wiligi odoo toowa tebisa mapoo gilimado peleso nibada goo midileiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Esino domo egee niyo mo goo ee dimapoo yilige bigilei biame tekepo ogoso. ");
INSERT INTO kkc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Esiga niba goo medee goolee. Bei, odoo susuga oso niba goo midilei mapoo ido duga, niyo to takalai goo mapoo haga na koude. ");
INSERT INTO kkc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bei, domo omapoo ayo nimapoo goo goolee tekepo sabolo osoloso to tekepo takalai goo sabolo tenelaiso, nimapoo goweli odoo oso nibada to ee duloso to nei takelega pagalame. ");
INSERT INTO kkc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Osoloso biame omapoo nibada ama dio sabolo, osoloso noowee dio sabolo, osoloso nemei dio sabolo, osoloso nomolo dio sabolo, osoloso nee soosoo sabolo, osoloso nemegei odoo sabolo oso nimapoo dala teneli odoo mapoo tiasalaiso. Osoloso diayo nima kulodu odoo abo piligileiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Esiga odoo susuga oso mo goo maga nimapoo heiga toowa malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Esino goo hagoso niba Godee maga pileime. ");
INSERT INTO kkc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Esiga medee kibiya debee. Niba kibiya doga, gie badeli talaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Esiga niba Yelusalem mi ee ha teli odoo oso moso silodoboloso tebisamelee ogoga, Yelusalem mi ee olo tokenee palame ka seeso doloso ogoloso niba gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Egeeseega biame omapoo Yudiya mi mapoo debeli niba mubi dokodoo kukulo pele. Osoloso edebeeyo biame omapoo Yelusalem mi ma kulodu osee doga, diba onosee saga kukulo di. Osoloso odoo agayo biame omapoo Yelusalem mi peegoo doga, diba mi ee ma kulodu na gadi. ");
INSERT INTO kkc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bei, biame omapoo Godeeyo to booka mapoo hogugu goo sabolo tobulone, nei dala tenelame ka selai. ");
INSERT INTO kkc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Osoloso biame omapoo sobo koowasi sabolo osoloso holope too nedili sobo oso dala toowa agalaiso. Bei, biame omapoo Godeeyo kamana goo oso siboga, goohele toowa sabolo osoloso dala toowa sabolo mi hamapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ee ma kulodu odoo abo ee ha teli odoo oso kaiyaso piligileiso. Osoloso odoo abo ee tiso tegisaloso tou nei mauwe talame mi abo mapoo iyado du dolone dabalaiso. Osoloso biame omapoo Yelusalem ee Yu odoonee oso gagalabuguloso homoso abalaiso. Diba osee tebisa mologa, diayo goo egeesee semelee oso hoo pagalai Godeeye biame ee tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Esiga goo opusomo di oso osoko mapoo, osoloso a mapoo, osoloso giwo mapoo peledabalaiso. Osoloso mi toowa hamapoo abei maga howo ki toowa oso goowa duleiso. Egeeseega odoo susuga oso dimapoo ogoo goo oso peledaba beleso obulone goo tiadalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Osoloso kei ma dokodoo kitulugu bi egee molo ee Godeeye halabigileiso. Egeeseega odoo susuga oso dimapoo ogoo goo oso peledaba beleso obugulone hoowama dalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Esiga biame omapoo Odoo Holo ayo kitulugu sabolo osoloso ayo toowa doloso badeli goo omaga mo gadeebugu sabolo osoloso kolobo sabolo siboga agalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Esiga niba goo susuga hagoso bei mooloogoo ogoga, ebilega toboloso bolone ka debee. Bei, Godeeye niba gilimado dilei biame ee koola toobooso.” ");
INSERT INTO kkc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuye see goo hamapoo wudu taka hamaga egeesee takaso, “Niba sogai ogoloso homo abo mapoo egege. ");
INSERT INTO kkc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sogai du pisigaga ogoloso, wau biame koola tooboo doloso gooleedeliso. ");
INSERT INTO kkc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Esiga hagonosee egeesi masi moloso. Niba goo ayo taka hagoso peledaba ogoga, Godeeye wiligi doloso badeli goo oso sibilei koola tooboo doloso gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ayo nimapoo taka, odoo biame omapoo dabalai ee osee doga, goo susuga hagoso peledabalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Esiga kei sabolo osoloso mi toowa sabolo mauwe pagalaiso. Esino mo to ee mauwe pagalaime.” ");
INSERT INTO kkc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Esiga niba niso nediliyo medee be. Osoloso niba wo sabolo howo sabolo nolone dobolone mi toowa eyo goo mapoo haga na goolee. Bei, ti gama mapoo beso gaduga, tiso be egee bagagooga egee dio du egeesi masi ayo sibilei biame oso nimapoo dio di egeesi masi tenelai malaiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bei, biame ogoso odoo susuga mi toowa hamapoo egee do mapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Esiga niba niso nediliyo medee bolone Godee mapoo takolone ka debee, niba biame oso peledabalai ee ma kuloduga kitulugu sabolo peegoo ka gadilame. Osoloso Odoo Holo mo mudugiyopoo kitulugu sabolo dabalame.” ");
INSERT INTO kkc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu biame susuga Yu odoowo tei moso mapoo peleso odoo susuga mapoo Godeeyo to eligimeleso koodobuloso, see tilame gesi Olipi mubi mapoo polo demeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eseme odoo susuga oso Yesuye eligi goo ee dulame gesikolodee tei moso mapoo sibileso mooloogoo deliso. ");
INSERT INTO kkc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Isipi mi maga peegoo di ee gooleebugu wo nalai biame ee koola tabaso. Wo nali hagee Yu odooso takolone Godeeye gababia wo nali deliso. ");
INSERT INTO kkc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Biame omapoo tei moso wiligi odoo tebisa sabolo osoloso tei eligili odoo sabolo oso odoo mooloogoodoo toowa ogoloso obugulone, mada Yesu wooloomalame eli esiaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Biame omapoo Saitenso Yudas-Iskaliyot eyo kulodu gapalaso. Yudas hagee Yesuwo hamamee dili odoo 12 ma kulodu odoo hee yoso. ");
INSERT INTO kkc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Esiga Yudaseeye tei moso wiligi odoo tebisa sabolo osoloso tei moso pee mapoo gidebeli dia wiligi odoo tebisa mapoo dileso, yayo Yesu toloso dimapoo tenelame dibolo to mouso. ");
INSERT INTO kkc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eseme diayo goo hagee duloso tekepo doloso goomogolone Yudas mapoo molee tenelame takaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eseme Yudaseeye yibolosee goo hamapoo tekepo dolone mada Yesu toloso dimapoo tenelame eli esiaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Isipi mi maga peegoo di gooleebugu wo ne bei mooloogoo biame mapoo, Yu odooso Godeeye gababia wo nalame, sipi be hu weliso. ");
INSERT INTO kkc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eseme Yesuye see Pita dio Yonee dio mapoo egeesee takaso, “Niba dileso iyo gababia wo nalai ee mopoodoo dalame di,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eseme diayo nei yimapoo egeesee takaso, “Iyo kamapoo dileso wo nalai ee ka mopoodoo dalaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Eseme Yesuye dimapoo nei egeesee takaso, “Niba Yelusalem mapoo gadi. Niba omapoo gadileso ogoga, odoo hee howo keedoloso dumologa tugodalaiso. Niba yo tugodoloso yo deedee di. Niba yayo dileso moso kulodu gaduga omapoo dobolone, mosowo ama mapoo egeesee takee, ‘Eligili odoo oso o hamamee dili odoo sabolo Godeeye gababia wo nalai debi ee kasomo?’ dee takee. ");
INSERT INTO kkc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Egeeseega yayo moso dokohodoo debi pooba toowa nimapoo eligileiso. Egeeseega niba iyo Godeeye gababia wo nalai omapoo ka mopoodoo de,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eseme Pita dio Yonee dio to hagee duloso dileso egeino, goo susuga ee Yesuye taka goo sabolo tobuloso molome egeiso. Eseme diba gababia wo nalame omapoo mopoodoo dooso. ");
INSERT INTO kkc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eseme diayo wo nalai biame ee sibume, Yesuye o hamamee dili odoo sabolo wo nalame bulumaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu badolone o hamamee dili odoo mapoo egeesee takaso, “A goomoga toowa sabolo badebeiso, ayo dala ma kulodu gadilega badolone, ayo nibolo Godeeye gababia wo nalai. ");
INSERT INTO kkc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bei, ayo nimapoo taka, ayo Godeeye gababia wo nali hagee hamamee see saga nalaime. Esino Godeeye wiligi doloso badeli mi oso sibulone wo nali hageeyo goo bei woola yilige buguga, ayo wo nali hagee see nalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eseme Yesuye kapu wain i keesoo toloso Godee mapoo goomoga takoloso koodobuloso dimapoo tenelone egeesee takaso, “Niba kapu wain i keesoo toloso odoo heeso naloso koodobuoga see odoo hee mapoo ka tenee domo di. ");
INSERT INTO kkc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bei, ayo nimapoo taka, a epedee wain i naloso hamamee see wain i saga nalaime. Esino Godeeye wiligi doloso badeli mi oso siboga, ayo see wain i ee nalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesu see wo toloso Godee mapoo goomoga takoloso wo popeiso. Osoloso o hamamee dili odoo mapoo pulone egeesee takaso, “Hagee mo suso, niba halo ka teneeso. Esiga niba a goolee sabolo dobolone wo hagee nolone ka debee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Diba wo naloso koodobuloso Yesu see kapu wain i keesoo toloso Godee mapoo goomoga takaso. Osoloso o hamamee dili odoo mapoo tenelone egeesee takaso, “Kapu wain i keesoo hagee Godeeye mo sawo maga to kitulugu magoo dia hagoso. Mo sawo hagoso niba halo ka sologo buguso. ");
INSERT INTO kkc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Esino niba ege. A ha teli odoo mapoo tiasalai odoo ee mooloogoodoo hageeyo kulodu abolo badolone wo namoloso. ");
INSERT INTO kkc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Esiga Godeeye to magoo ee dodolone Odoo Holo a talaiso. Esino Odoo Holo a ha teli odoo mapoo tiaseli odoo yo, ye-ee! Bei, odoo yo dala talaiso.” ");
INSERT INTO kkc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eseme o hamamee dili oso to hagee duloso dieso nediliyo dima kulodu egeesee takaga meleeso, “Agayo ima kulodu goo hageesi ka moodoolaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eseme Yesu o hamamee dili odoo oso dieso nediliyo dima kulodu odoo agayo toowa ka badosomo doloso wegigaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Osoloso Yesuye goo hagee ogoloso dimapoo egeesee takaso, “Yu odoonee dia wiligi odoo tebisa oso dima hemi debeli odoo ee diayo diya kitulugu sabolo gidebeliso. Esino diba dieso nediliyo odoo susuga mapoo takolone diba odoo susuga eyo odoo deliso. ");
INSERT INTO kkc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Esino niba nima kulodu egeesee selai tekeponee. Esiga nima kulodu odoo agayo toowa ka badosomo? Yo daga malalo eyo nediliyo pepooko doloso badebee. Osoloso nima kulodu odoo agayo gibadeli odoo masi ka badosomo? Yo tou teli odoo masi mesie sabolo tou tolone ka badebee. ");
INSERT INTO kkc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Niba medee goolee, wo nalame badeli odoo sabolo wo pili odoo sabolo dima kulodu, odoo agayo toowa doloso ka badosomo? Odoo ee badolone wo nalame badeli oso toowa doloso ka badoso. Esino nima kulodu a wo pili odoo masi badoso. ");
INSERT INTO kkc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Niba ayo hegi goo ee ma kulodu sileeme, a koo poogoo dili. ");
INSERT INTO kkc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Esiga mo Mameeye o odoo gibadalame kitulugu amapoo tenee egeesi ayo nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Esiga ayo wiligi doloso badeli mi oso siboga, ee ma kulodu niba abolo hodobo dobolone wo nalaiso. Osoloso niyo wiligi odoo oso debeli debi mapoo dobolone Isalael odoowo bala 12 ee gidobolone dia goo ee midileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu badolone Saimon-Pita mapoo egeesee takaso, “Saimon, Saimon, Saitenso niba tei kibiya beleso kukulo agalame Godee mapoo woosome, Godeeye yimapoo kitulugu olo teneeso, yayo egeesee moodoolame. ");
INSERT INTO kkc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Esino ayo no halo Godee mapoo dokodoo olo takaso, nayo tei too peegeeyaga. Osoloso nayo amapoo see wedi simi biame mapoo, mo hamamee dili odoo hagee bia oso tei too ma kulodu kibiya dabalame nayo diba pidi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eseme Pitaye nei yimapoo egeesee takaso, “Lodee, a nobolo neliga moso ma kulodu osoloso teli mapoo dilei mopoodoo doloso ka siloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eseme Yesuye Pita mapoo nei egeesee takaso, “Pita, ayo namapoo taka, epei gesi kolokolo takelega mologa, nayo a gooleedele doloso puodalai ee bakadio hedebe dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuye see o hamamee dili odoo mapoo egeesee takaso, “Ayo daga niyo to tekepo takomo silesibilame diye dolone molee sabolo, osoloso o sabolo, osoloso kali bi abo sabolo toloso na di diso. Esino niba ee ma kulodu silesibulone, hegi goo abo egeisomo?” diso. Eseme diayo nei egeesee takaso, “Haye, egele,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eseme Yesuye see dimapoo egeesee takaso, “Epedee hamapoo nimapoo molee sabolo o sabolo mologa, ee toloso di. Osoloso nimapoo kaiya mauwe daga, nibada kekeisu dugo odoo hee mapoo teneloso nei molee toloso kaiya te. ");
INSERT INTO kkc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Edebeeyo yo mesiya masi wooloomalaiso,’ diso. Esiga Godeeyo to booka mapoo hogugu oso taka goo oso amapoo peledabalaiso. O, tei takoo, Godeeyo to booka mapoo hogugu oso mo goo maga taka goo susuga oso peledabalame siboso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eseme o hamamee dili odoo oso yimapoo egeesee takaso, “Lodee, no ege. Iba kaiya bakadio moloso,” diso. Eseme Yesuye dimapoo egeesee takaso, “Bige oso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu goo eyo moodeli egeesee moodoolone Yelusalem maga peegoo dileso Olipi mubi mapoo palaso. Eseme o hamamee dili odoo yibolo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Osoloso diba dileso omapoo dobolone, Yesuye dimapoo egeesee takaso, “Niba Godee mapoo takolone ka debee, goo tokenee mapoo gido duga homodobiyaga.” ");
INSERT INTO kkc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yesu egeesee takoloso dimaga pepooko hoogoo dileso ebiso miyomoo tugusaloso Godee mapoo takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yesuye Godee mapoo takolone egeesee takaso, “Ma, no goomogoga, amapoo dala hagee sibo peegoo magee. Esino no goomoga goo ee te, ayo goomoga goo ee na te,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eseme Godeeyo momaiye oso Kei mi ma dokodooga sibileso yo pidilone kitulugu teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Egeesi ma kulodu Yesu dala talame hegi goo oso sibume, yo sooloo habasaga toowa sabolo Godee mapoo diya takaso. Eseme o debiaso sawo masi mi mapoo salagadibaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Osoloso yo Godee mapoo taka koodobuloso dileso egeino, o hamamee dili odoo goo halagameleso tiesamolome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eseme Yesuye dimapoo egeesee takaso, “Niba kaseega ka tiesamalala? Niba hogogabuloso Godee mapoo takolone ka debee, goo tokenee mapoo gido duga homodobiyaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu o hamamee dili odoo sabolo to osee komolome, o hamamee dili odoo hee Yudaseeye odoo mooloogoodoo gilimadoloso sibileso omapoo peledabaso. Eseme Yudaseeye Yesu adalame simiso. ");
INSERT INTO kkc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Esino Yesuye yimapoo egeesee takaso, “Yudas, nayo Odoo Holo a ada sabolo ha teli odoo mapoo tiasalame ka sala?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eseme Yesu o hamamee dili odoo diayo odoo susuga oso Yesu talame simi ogoloso egeesee takaso, “Lodee, iyo kaiyaso ka biligileiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Egeeseeme Yesu o hamamee dili odoo heeso tei moso wiligi odoo taba eyo tou teli odoo hee kaiyaso o dulu deedee dokolo ee kobuguso. ");
INSERT INTO kkc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Esino Yesuye o hamamee dili odoo mapoo egeesee takaso, “Omapoo koodobie! Goo egeesee na moodee!” diso. Osoloso Yesuye odoo o dulu mapoo sigime see tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu yo omapoo tobudulone yo talame sibadee, tei moso wiligi odoo tebisa sabolo, tei moso pee maga gidebeli dia wiligi odoo tebisa sabolo, Yu odoowo wiligi odoo tebisa sabolo mapoo egeesee takaso, “Niyo ogoga a mesiya daga a talame, kaiya sabolo wei sabolo toloso ka sibadeeyo? ");
INSERT INTO kkc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Esino niba ayo biame susuga tei moso ma kulodu eligimo sili egeliso. Esino niyo kaseme a omapoo badoboome telega ka poogoowo? Esino epedee hamapoo nibada biame oso olo siboso. Bei, epedee hagee neliga wiligi odoo taba Saiteneeyo biameso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Osoloso odoo susuga oso Yesu toloso tei moso wiligi odoo taba eyo mosopoo ido diso. Eseme Pitaye hamameedee toboloso deedee diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yo deedee dileso, odoo susuga oso moso pee beelee ma kulodu dou tooloso dou halagamolome, yo dibolo hodobo omapoo badolone dou hameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita omapoo dou holone badoboome, sobo obuo omapoo tou teli oso sibileso Pita mapoo medee bolone egeesee takaso, “Odoo hagee Yesubolo sili hee yoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Esino Pitaye nei egeesee takaso, “Sobo, odoo egee a gooleedele,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Osoloso see hamamee odoo heeso sibileso yo ogoloso yimapoo egeesee takaso, “No Yesubolo sili odoo hee noso,” diso. Eseme Pitaye nei egeesee takaso, “Giso, asonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Osoloso osoko howo hedebe poogoloso hamamee odoo heeso sibileso to kitulugu sabolo egeesee takaso, “Tei takoo, odoo hagee Yesubolo sili hee yoso. Bei, yinosee Gelili odooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Eseme Pitaye nei egeesee takaso, “Giso, nayo egee takoo goo ee tei a gooleedele,” diso. Pita to osee komolome, kolokolo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eseme Lodeeye hamameegoo bidi toboloso Pita mapoo bameleeso. Eseme biame omapoo Yesuye taka to hagee Pitaye gooleebuguso, “No epei gesi kolokolo takelega mologa nayo a gooleedele doloso puodalai ee bakadio hedebe dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Egeeseelone yo to hagee gooleebuguloso diya gooheleme peegoo gadileso pisaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Eseme Yesu yo gidebeli odoo oso yo manolone toloso weiso. ");
INSERT INTO kkc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Osoloso diayo o howo dugoso gagaloso wooloso egeesee takaso, “Imapoo takee, no odoo agayo wala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Egeeseelone to tokenee abo sabolo yimapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Osoloso mi hadobume gesikolodee Yu odoowo wiligi odoo tebisa sabolo, osoloso tei moso wiligi odoo tebisa sabolo, osoloso tei eligili odoo sabolo hodobo mooloogoodooso. Osoloso diayo to moulone debei mapoo Yesu ido palaso. ");
INSERT INTO kkc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Eseme diayo dobolone Yesu mapoo egeesee takaso, “Nayo imapoo takee, no tei Godeeye hudi magoo Keliso nosomo?” diso. Eseme Yesuye dimapoo nei egeesee takaso, “Ayo nimapoo takooga, niyo ayo taka goo mapoo tei talaime. ");
INSERT INTO kkc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ayo nimapoo woosaga, niyo amapoo to eyo nei takalaime. ");
INSERT INTO kkc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Esino epedee biame hamaga Odoo Holo a Godee kitulugu eyo dee deedee dokolo mapoo yibolo wiligi doloso badalame bileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eseme odoo susuga oso yimapoo egeesee takaso, “Esiga no tei Godeeyo owolowo?” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Niyo a Godeeyo owolo dee egee takoo ee tei goo takoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eseme diayo egeesee takaso, “Esiga iba o goo midilei maga to abo dulei koo goomogo. Bei, yo eyo o goo ee olo yebugulone yo Godeeyo owolo diso. Esiga yo wooloomalai tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Osoloso wiligi odoo tebisa mooloogoodoo oso tebisaloso Yesu Pailet mapoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Diayo dileso Pailet mapoo Yesuwo goo maga takolone egeesee takaso, “Odoo hagoso ibada odoo eli tokenee mapoo gilimado di ogoloso ka too. Bei, yayo ibada odoo oso Sisa mapoo tekisi molee misigeli hamaga takoloso see eyo nediliyo yo wiligi odoo Keliso dee takemeleeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eseme Paileteeye Yesu mapoo egeesee takaso, “No tei Yu odoo dia wiligi odoowo?” diso. Eseme Yesuye nei egeesee takaso, “O, nayo olo egee takooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Osoloso Paileteeye Yu odoowo tei moso wiligi odoo tebisa sabolo osoloso odoo abo omapoo mooloogoodoloso debei mapoo egeesee takaso, “Ayo yo talaino yimapoo goo tokenee hee koo ogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Esino diba goo egee pagalai gowoolone to kitulugu sabolo egeesee takaso, “Edebeeyo Loum gamalee mapoo kamanalame, yayo Yudiya mi toowa mapoo silone odoo goo tiadili goo ee eligimo siliso. Osoloso yayo goo hagee Gelili mi maga bei mooloogooloso see hamapoo sibileso ka eligimo siloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Osoloso Paileteeye goo hagee duloso, Yesu tei Gelili odoo beleso odoo mapoo woosaso. ");
INSERT INTO kkc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Egeesi ma kulodu yayo Yesu tei Gelili odoo dee taka goo ee duloso, Yesu Helodee mapoo ido di diso. Bei, Helodeeye Gelili mi mapoo wiligi odoo toboloso ka badebei. Biame omapoo Helodee Yelusalem mapoo sibileso badebeiso. ");
INSERT INTO kkc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ee ma kulodu Helodeeye Yesu ogoloso diya goomogaso. Bei, yo Yesuwo goo epedee eiyo dumelega, yo agalai goomegeliso. Osoloso Yesuye goo opusomo di o mudugiyo moodoolame diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eseme Helodeeye Yesu mapoo woosali to bei woosagaso. Esino ee ma kulodu Yesuye yimapoo to nei hee takele. ");
INSERT INTO kkc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Osoloso biame omapoo tei moso wiligi odoo tebisa sabolo osoloso tei eligili odoo tebisa sabolo oso to kitulugu sabolo takolone Yesu mapoo gigidiso. ");
INSERT INTO kkc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eseme Helodeeye o odoo sabolo Yesu manolone wiligi odooso kali dugo kadiso. Osoloso yo Pailet mapoo see ido di diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Biame domo omapoo Pailet dio Helodee dio emegei diso. Esino daga debei ee ma kulodu dieso nediliyo nei heigo nei heigo dolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Eseme Yesu Pailet mapoo see ido di ogoloso, Paileteeye tei moso wiligi odoo tebisa sabolo osoloso Yu odoowo wiligi odoo tebisa sabolo osoloso odoo susuga gilimadoloso egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Niyo odoo hagoso Yu odoo oso Loum gamalee mapoo kamanalame, odoo goo tiadili goo ee eligimo silo doloso, amapoo ka ido simi. Esino ayo nibada mudugiyo o goo midino, yimapoo goo tokenee hee molo egele. ");
INSERT INTO kkc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Osoloso Helodee nosee Yesu mapoo goo tokenee hee molo egele. Egeeseeme yayo yo see imapoo ido sibe dee takaso. Esiga niso ogoso, odoo hagee wooloomalai yimapoo goo tokenee hee mauwe. ");
INSERT INTO kkc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Esiga ayo yo wulo woomele poogoloso diye dalaiso.”  ");
INSERT INTO kkc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Esino Paileteeye Yu odoo oso goomogalame diayo Godeeye gababia wo nali biame mapoo odoo hee neliga moso ma kuloduga peegoo diye deliso. ");
INSERT INTO kkc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Osoloso odoo susuga oso to neligidi egeesee takaso, “Yesu wooloomolone, nei Balabas neliga moso ma kuloduga peegoo diye dee!” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabas hagoso daga Loum gamalee mapoo ha temeleso odoo hee wooloomaso. Egeeseega yo neliga moso ma kulodu husooso. ");
INSERT INTO kkc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paileteeye Yesu peegoo tamagalame diya goomogolone, see tobu odoo mooloogoodoo mapoo woosaso. ");
INSERT INTO kkc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Esino odoo susuga oso to neligidi yimapoo nei egeesee takaso, “Yo homo bulubo magoo ma dokodoo yoguso enige! Yo homo bulubo magoo ma dokodoo yoguso enige!” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eseme Paileteeye see tobu odoo mooloogoodoo mapoo egeesee takaso, “Bei, niyo kasalame yo wooloomalame ka sala? Yayo goo tokenee kasee toowo? Ayo o goo midi mapoo ayo yo wooloomalame ido dino, yimapoo goo tokenee hee molo egele. Esiga ayo yo wulo woomele poogoloso diye dalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Esino odoo susuga oso toso neligidi diya takaso, “Yesu homo bulubo magoo ma dokodoo yoguso enige!” dee takaga meleeso. Diayo egeesee takemelee Pailet to ee dulei diya gowoolone, bige dimapoo deedeebeegee diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Egeeseeme yayo dia to duloso odoo susuga oso goomoga goo ee tooso. ");
INSERT INTO kkc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Esiga Paileteeye Loum gamalee mapoo ha tolone odoo wooloomali Balabas ono neliga moso ma kuloduga peegoo diye diso. Esino Yesu homo bulubo magoo ma dokodoo talame yayo yo odoo susuga mapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Osoloso ha teli odoo oso Yesu toloso mi ee ma kuloduga peegoo ido dumolome, Kulene odoo Saimon Yelusalem mi mapoo dumolome eli domopoo tugodooso. Osoloso diayo homo bulubo magoo toloso see o ei mapoo imeduloso Yesu ma hamamee diye diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Osoloso biame omapoo, Yesu toloso diyadaga molome odoo susuga hamamee diyadeeso. Osoloso ee ma kulodu sobo abo sabolo dulone Yesu halo gooholone hamamee dulone pupusigamo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eseme Yesuye bidi toboloso dimapoo bolone egeesee takaso, “Yelusalem sobo, niba a halo haga na pupusige. Esino niso nediliyo osoloso nibada holo halo ka pupusige. ");
INSERT INTO kkc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bei, dala biame oso siboga, edebeeyo egeesee takagalaiso, ‘Sobo deme taba nibolo osoloso sobo holo soomagoloso too koo nedili niba diya goomege.’ ");
INSERT INTO kkc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bei, biame egeesi oso peledaba omapoo edebeeyo egeesee takagalaiso, ‘Mubi sabolo osoloso esia niyo goodobuloso iba toogoode!’ dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Esiga goo hageesi oso homo su gie mapoo peledobooga, see ogoo goo oso homo su sia mapoo ka peledabalaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Osoloso biame omapoo ha teli odoo oso Yesu ido dulone, mesiya bakadio homo bulubo magoo ma dokodoo wooloomalame ido diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Diba sibileso mubi hee, eyo hu Wiligi ki mi deli mapoo, Yesu homo bulubo magoo ma dokodoo yoguso enigaloso tuluguso. Osoloso mesiya bakadio onosee homo bulubo magoo mapoo yoguso enigaloso, odoo hee Yesuwo deedee dokolo tulugu, osoloso hee dobusu dokolo tulugu diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Osoloso Yesuye homo bulubo magoo ma dokodoo telega molone egeesee takaso, “Ma, odoo hagee bia oso goo tokenee amapoo egee moodoo ee nayo hapoloso boobado bigi. Bei, diayo goo egee moodoo eyo bei diba gooleedele,” diso. Osoloso ha teli odoo oso Yesuwo dugo talame diayo yo pepuso odoo hu ma ee kobuso. ");
INSERT INTO kkc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Odoo susuga oso peegooga tebisamolone balaga molome, Yu odoowo wiligi odoo tebisa oso manolone egeesee takaga meleeso, “Yayo odoo abo pidimo siliso. Esiga yo tei Godeeye hudi magoo Keliso oso daga, o su eyo nediliyo pidilei tekepo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Osoloso ha teli odoo sabolo oso Yesu manolone, wain i mei nali keesoloso Yesuye nalame tenelone yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“No medee tei Yu odoo dia wiligi odoo taba daga, no telega pagalame, no nediliyo pidi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yesu o wiligi oo poogoo dokodooga to hageesee hoguguloso kalamaso, ");
INSERT INTO kkc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mesiya hee Yesuwo ho hodiokooga eniga oso Yesu mapoo tokenee sisilone yimapoo egeesee takaso, “No medee tei Keliso daga, nee su no nediliyo pidilone, iba nosee pidi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Esino mesiya hee oso o odoowo to su maga to kitulugu sabolo egeesee takaso, “No Godeebolo koo obudo? Bei, yayo dala egee to, no nosee dala hedebe egeesi toso. ");
INSERT INTO kkc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Esiga iba asalo ibada tokenee eyo nei maga ka wodioso. Esino Yesu mapoo tokenee hee mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Osoloso yayo see Yesu mapoo egeesee takaso, “Yesu, nayo wiligi doloso badebei mapoo, nayo a gooleebigi,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eseme Yesu nei yimapoo egeesee takaso, “Ayo namapoo tei goo taka, esiga epei no abolo hodobo goomoga mi Paladais mapoo badalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Osoloso osoko olo oo domo tooboome, mi susuga neligaso, mi neligamelee ososee osoko howo bakadio hedebe di poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bei, goo ogoso peledoboome, osoko pelega poogooso. Osoloso tei moso tegei ma kulodu dugo kodia oso kisimelee ee eyo mosoowe domo tologodooso. ");
INSERT INTO kkc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eseme Yesuye to neligidi egeesee takaso, “Ma, a mo dio nee dee mapoo maga,” diso. Yesu to hamameedee hageesee takoloso taso. ");
INSERT INTO kkc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Osoloso ha teli odoo gibadeli odoo oso Yesuwo homo bulubo magoo ma hemidu badolone Yesuye ta goo ee ogoloso, Godeeyo hu dokodoo poudoolone egeesee takaso, “Tei takoo, odoo hagee Godeeyo howo woola tekepo odoodoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Osoloso odoo susuga oso gooso peledaba ee agalame omapoo dileso balagamelee odoo oso goo hagee ogoloso dulone diya gooholone dia budo mapoo kobugumo see wedi diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Osoloso Yesu o odoo sabolo osoloso sobo abo Yesubolo Gelili abaga sibadee oso wulo eli sage abaga tebisamolone goo hagoso peledaba mapoo balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Dima kulodu odoo hee badebeiso, o hu Yosep. Yudiya mi toowa ee ma kulodu mi pepooko Alimatiya ee o midee. Yo Godeeyo howo woola tekepo badolone Godeeye wiligi doloso badeli goo oso siba beleso bameleeso. Osoloso yo Yu odoowo wiligi odoo tebisa oso mooloogoodoo ee ma kulodu yo dibolo hodobo badebeiso. Esino Yu odoowo wiligi odoo tebisa oso Yesu Loum gamalee odoo oso wooloomalame dimapoo tiaseme, yo goo omapoo gowoolone yayo hamaga takaso. ");
INSERT INTO kkc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Osoloso yayo Yesu ta eyo su ee talame, Pailet mapoo dileso woosaso. ");
INSERT INTO kkc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Osoloso yayo Yesuwo kou homo bulubo magoo ma dokodooga miyomoo to meileso, dugoso tiadoloso yo ou madu magooso. Midoo hagee dia. Esiga daga odoo hee teme omapoo magele. ");
INSERT INTO kkc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Esino biame domo egee Yu odoo diayo hasali biame bei mooloogoolai osoko howo koola tooboome ka see. ");
INSERT INTO kkc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Osoloso sobo abo Yesubolo Gelili abaga sibadee oso Yosepeeye Yesuwo kou mi doo ma kulodu magalame todime, diba yima hamamee diyadeeso. Diba omapoo dileso Yosepeeye Yesuwo kou magoo medee egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Osoloso diba see wedi dileso sisigageli bi medee tekepo Yesuwo su mapoo hedilame mopoodoo dooso. Esino diba Yu odoo diayo hasali biame olo bei mooloogoome, Moseseeye tei magoo ee dodolone epedee koodobuloso hasaso. ");
INSERT INTO kkc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Esiga Sadee toowa biame gesikolodee sobo hagee bia oso sisigageli bi medee tekepo mopoodoo doo ee toloso Yesuwo bi mapoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Diba omapoo dileso egeino, yo toowa wulu ou miyopoo kisi ee peegoo bidigamo dileso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eseme diayo kulodu galagadileso egeino, Lodee Yesuwo su omapoo mauwe molo egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Osoloso diayo kulodu galagadileso goo tiademe balaga meleeno, odoo bakadio dugo diya gadeebugu kalaga oso saga peledoboloso soboso debei mapoo hodiokooga tebisaso. ");
INSERT INTO kkc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Osoloso sobo diba diya dio dulone, ebia sabolo miyomoo gawuaso. Eseme odoo bakadio oso dimapoo nei egeesee takaso, “Niyo kasalame odoo see gie badeli too ee midoo ma kulodu ka esiamo silesibala? ");
INSERT INTO kkc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yo kulo hadu mauwe. Esino yo see hogado dina. Esiga niba Yesubolo Gelili mapoo silone, yayo nimapoo taka goo ee gooleebigi. ");
INSERT INTO kkc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Bei, yayo egeesee takaso, ‘Odoo Holo, a tokenee teli odoo dimapoo tiasalaiso, osoloso a homo bulubo magoo ma dokodoo yoguso enigileiso. Osoloso a biame bakadio midoo ma kulodu tamoloso, biame bakadio hedebe di mapoo midoo ma kuloduga see hogado dileiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eseme sobo diba to hagee duloso Yesuye takomo sili to ee gooleebuguso. ");
INSERT INTO kkc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Osoloso diba midoo maga see wedi dileso, diye di odoo 11 sabolo osoloso odoo susuga mapoo diayo egei goo susuga ee dimapoo oposususo. ");
INSERT INTO kkc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Esiga sobo hagee bia oso goo peledaba hagee ka egei, Meli-Magadalin osoloso Yowana osoloso Yemeseeyo owee Meli osoloso sobo abo. ");
INSERT INTO kkc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Esino sobo hagee bia oso sibileso diye di odoo mapoo takeme diba duno, halabolone taka masi takeme to omapoo tei tele poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Esino Pita toboloso midoo ee agalame hoguo diso. Yo dileso gasuwoloso wulu ma kulodu egeino, dugo Yesuwo su tiadoloso magoo ee see mosoowe wulu ma kulodu molome egeiso. Eseme Pita goo hagee ogoloso howoodoomo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Biame hedebe omapoo Yesuwo hamamee dili odoo bakadio oso Yelusalem mi poogoloso, see Emaus mi mapoo diyadaga meleeso. Emaus mi egee Yelusalem omaga haga hoogoonee, wulo 11 kilomita egeesi masi. ");
INSERT INTO kkc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","O bakadio dumo dulone goo susuga Yesu mapoo peledaba goo ee oposusumo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Osoloso o bakadio osee oposusumo diyadaga molome, Yesu dima hamamee sibileso diba tugodoloso dibolo hodobo diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Esino odoo bakadio hagoso Yesu medee kibiya hoodo egele. Bei, diayo Yesu kibiya hoodo egeyaga, Godeeye diba gooloogooso. ");
INSERT INTO kkc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eseme Yesuye dimapoo egeesee takaso, “Niba ogoo goo oposusumo diyadaga malana?” diso. Eseme diba eli domo omapoo kookoo toboloso goohele sabolo mudu olugodoloso tebisameleeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Osoloso dima kulodu odoo hee, o hu Keleopas, yayo Yesu mapoo egeesee takaso, “Yelusalem mi mapoo odoo soo sibadee ee ma kulodu mi omapoo goo peledaba ee, no dulega badosoba?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eseme Yesuye nei dimapoo egeesee takaso, “Nayo egee takoo ogoo goo takala?” diso. Eseme diayo nei yimapoo egeesee takaso, “Iba Yesu Nasalet odoo eyo goo ee taka. Bei, yo Godee maga to toloso kokodo takomo sili odoo doloso badolone Godeeyo howo woola osoloso odoo susuga eyo mudugiyo Godeeyo to kitulugu sabolo takomo siliso. Osoloso yayo goo toowa opusomo di moodoomo siliso. ");
INSERT INTO kkc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Esino tei moso wiligi odoo tebisa sabolo osoloso ibada wiligi odoo tebisa oso Yesu Loum gamalee oso wooloomalame dimapoo teneeso. Eseme yo homo bulubo magoo ma dokodoo yoguso enigaloso taso. ");
INSERT INTO kkc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Esino iyo goolee, yayo Isalael odoo iba Loum gamalee gidebeli omaga peegoo gilimado dileiso doloso dobolone balaga meleeso. Esiga goo hagoso peledaba ee biame bakadio olo poogooso. ");
INSERT INTO kkc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Osoloso ibada mooloogoodoo ee ma kulodu sobo abo oso epei gesikolodee dileso midoo mapoo egeino, Yesuwo su mauwe molo egeiso. Eseme diayo sibileso imapoo takolone, ‘Ibada howo opusomo doloso Godeeyo momaiye egeiso,’ diso. Eseme momaiye oso Yesu ta maga hogado di goo ee dimapoo takaso. Eseme goo susuga hagee takeme, iba diya dio diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Osoloso ibada mooloogoodoo ma kulodu debeli odoo abo diba nosee dileso midoo egeino, soboso taka to sabolo tobulone, Yesuwo su midoo ma kulodu mauwe molo egeiso.” ");
INSERT INTO kkc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eseme Yesuye nei dimapoo egeesee takaso, “Niba medee diya boobada odoodoo. Niba kaseega Godee maga to toloso kokodo takomo sili odoo dia to mapoo tei telega ka dosomo? ");
INSERT INTO kkc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bei, diayo egeesee takaso, ‘Godeeye hesia Kelisoye dala goo hageesi toloso see Godeeye egee bado mapoo peleso hu toowa toloso kitulugu sabolo badalaiso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Osoloso Yesuye dimapoo Moses sabolo osoloso Godee maga to toloso kokodo takomo sili odoo susuga oso Kelisowo goo hogugu goo eyo bei dimapoo medee eligiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Osoloso diba Emaus mi olo koola tooboome omapoo dulone Yesuye dimapoo egeesee takaso, “A hamapoo hasalaime. Esino a olo wulo duso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Eseme odoo bakadio oso to kitulugu sabolo yimapoo egeesee takaso, “Emegei, no epedee na di, no ibolo hodobo tiamo. Bei, olo nolugo,” diso. Eseme Yesu yo dibolo hodobo tilame diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Osoloso diba moso kulodu peleso nei nalame dobolone, Yesuye wo toloso goomoga to takoloso koodobuloso wo populoso dimapoo piso. ");
INSERT INTO kkc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Egeesee semelee biame omapoo diayo Yesu medee kibiya hoodo egeiso. Omapoo diayo Yesu medee kibiya hoodo egeme, yo saga omapoo osugoboodooso. ");
INSERT INTO kkc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eseme obakadio dobolone dibusomo egeesee takaga meleeso, “O. Tei takoo, iba eli domo abaga sibadaga molome, yayo Godeeyo to eyo bei imapoo takeme, ibada sooloo ma kulodu diya goomogaso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Osoloso diba saga tebisaloso see Yelusalem mapoo wedi diyadeeso. Diba omapoo dileso egeino, diye di odoo 11 sabolo osoloso Yesuye di hamamee dedeli odoo susuga oso diesono hodobo mooloogoodoloso doboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eseme odoo omapoo mooloogoodoloso debei oso dimapoo egeesee takaso, “O. Tei takoo, Lodee yo ta maga see hogado didoo. Osoloso yo see Saimon-Pitaye badebei mapoo peledabadoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Osoloso odoo bakadio hagee bia oso Yesu eli domopoo diba tugodoloso di eyo goo sabolo osoloso Yesuye dibolo hodobo nei nalame dobolone, wo toloso popume, diayo yo medee kibiya hoodo egei goo ee dimapoo oposususo. ");
INSERT INTO kkc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Diba goo hamapoo to osee kesamolome, haga booloogelega diayo debei domo omaga Yesu peledoboloso tobudulone dimapoo egeesee takaso, “Emegei, mesie goo oso nibolo hodobo mele,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Esino diayo goolee yo odoo dio bele dolone, dio dulone diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eseme Yesuye nei dimapoo egeesee takaso, “Niba kaseega ebia sabolo goo tiadoo sabolo nibada goo goolee ma kulodu ka malana? ");
INSERT INTO kkc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Esiga niba mo dee sabolo osoloso mo homo sabolo ogoloso tei aso doloso gooleede. Osoloso mo su sige, niyo a tei su moloso doloso gooleedalame. Bei, odoo dio diba su mauwe,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yo to hagee takoloso o dee boowo sabolo osoloso o homo boowo sabolo dimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Esino diayo medee tei telega goomoga sabolo osoloso dio dulone debei ogoloso Yesuye dimapoo egeesee takaso, “Nimapoo nei nali hee molosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eseme diayo yimapoo di si pepooko teneeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Osoloso yayo dia howo woola di egee neso. ");
INSERT INTO kkc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Osoloso yayo dimapoo egeesee takaso, “Ayo nibolo hodobo silone nimapoo takeliso, ‘Mo goo maga Moseseeye hogugu sabolo, osoloso Godee maga to toloso kokodo takomo sili odoo oso hogugu sabolo, osoloso Sam booka mapoo hogugu goo oso amapoo peledabalaiso,’ deliso. Esiga epei goo hagoso amapoo olo ka peledobooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Osoloso Godeeyo to booka mapoo hogugu goo ee medee kibiya gooleedalame, Yesuye dibada goo goolee medee hoodo magooso. ");
INSERT INTO kkc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yesu egeesee solone tobudulone dimapoo egeesee takaso, “Esiga Godeeyo to booka mapoo hogugu ee egeesee moloso: Godeeye hesia Keliso, a dala toloso biame bakadio midoo ma kulodu ta moloso see biame bakadio hedebe di mapoo hogabuloso toboloso dileiso.” ");
INSERT INTO kkc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Osoloso Yesuye see tobu dimapoo egeesee takaso, “Niba Yelusalem abaga bei mooloogooloso mipoo toowa mapoo mo hu maga odoo mapoo hageesee eligimo silesibe, ‘Niba goo goolee su wuduloso nibada goo tokenee maga miligi pie. Eseega nibada goo tokenee hapoloso boobado bigileiso,’ dee takomo silesibe. ");
INSERT INTO kkc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Esiga niyo mo goo hagee ogoloso takomo silesibileiso. ");
INSERT INTO kkc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Osoloso niba Yelusalem poogoloso epedee na di. Esino niba epedee hamapoo osee doga, Kei mi ma dokodooga kitulugu siboga talaiso. Bei, ayo mo Maye taka to ee dodolone nimapoo Dio Tei tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Osoloso Yesuye o hamamee dili odoo gilimadoloso Betani mi koola mapoo diyadaga meleeso. Diba omapoo dileso peledoboloso Yesuye dee dokodoo poudoloso diba halo Godee mapoo takolone diba pidilame goomoga to takaso. ");
INSERT INTO kkc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yo egeesee takomolome, Yesu Kei mi ma dokodoo ido palaso. ");
INSERT INTO kkc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eseme diayo Yesuwo hu dokodoo poudoloso, goomoga sabolo Yelusalem mi mapoo see wedi diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Osoloso biame susuga ee ma kulodu, diba Yu odoowo tei moso mapoo dobolone, Godee mapoo goomoga poudoolone debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Daga mipoo hagee moodelega molome, To olo badebeiso. To oso Godee sabolo badebeiso. Osoloso To ee Godee. ");
INSERT INTO kkc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yo mipoo gie daga moodoo omapoo Godee sabolo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Esiga bi hee yo mauwe moodele poogoo me. Esino bi susuga hedebe yimaga ka moodoo. ");
INSERT INTO kkc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Esiga gie badeli eyo bei hedebe yoso. Gie badeli oso odoo susuga mapoo gadeebugu tenemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Esiga gadeebugu oso neliga ma kulodu ka pounimoloso. Esiga gadeebugu egee neligaso semidilei tebile. ");
INSERT INTO kkc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Esiga biame omapoo Godeeye odoo hee diye diso, o hu ee Yonee. ");
INSERT INTO kkc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yayo odoo mapoo gadeebugu oso sibilei goo ee takalame simiso. Osoloso odoo susuga oso to yayo taka ee duloso tei ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yonee yo gadeebugunee, esino yayo gadeebugu eyo goo ee odoo mapoo takalame ka simi. ");
INSERT INTO kkc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bei, tei gadeebugu oso odoo susuga mapoo pouni meli oso mipoo hamapoo sibilei ee olo koola tabaso. ");
INSERT INTO kkc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Esiga To ee mipoo hamapoo meleeso. Osoloso mipoo hagee yimaga moodooso. Esino mi odoo oso yo medee hoodo egele. ");
INSERT INTO kkc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yo o odoo mapoo simiso. Esino o odoo oso yo idile. ");
INSERT INTO kkc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Esino edebeeyo yo idoloso yimapoo tei teme, yayo odoo egee bia dimapoo kitulugu teneeso, diayo Godeeyo owolo dio doloso dabalame. ");
INSERT INTO kkc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Esino edebeeyo owee dio ama dio eyo sawoso, o, suso gilee, o, odoo heeso gilee goo maga diba Godeeyo owolo dio dee ka sele. Esino Godeeye goomoga goo omaga diba Godeeyo owolo dio diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Osoloso Toso odoo su poloso ima kulodu badebeiso. Yayo iba diya sooloo dolone pidiliso. Osoloso yayo tei goodee ee takeliso. Osoloso yayo hu toowa toloso badeli goo ee iyo egeiso. Esiga Ma Godee maga simi, Owolo hedebe yayo hu toowa egeesi toloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoneeye o goo maga takolone toso neligidi egeesee takaso, “Ayo takolone, odoo hee ama hamamee sibileiso dee takomo silimenee, odoo ee hagoso. Yayo kitulugu oso ayo kitulugu ee dagadi. Bei, a soomagelega badoboome, yo daga olo badebeiso.” ");
INSERT INTO kkc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Esiga sooloo dolone pidili goo toowa yimapoo egee molo maga biame susuga yayo iba ka pidimoloso. ");
INSERT INTO kkc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tei magoo goo ee Godeeye Moses maga imapoo teneeso. Esino sooloo dolone pidili goo sabolo osoloso tei goodee ee Yesu Keliso maga simi. ");
INSERT INTO kkc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Egeesi ma kulodu odoo heeso Godee egele. Esino hedebe Godeeyo Owolo yayo imapoo Godeeyo goo ee yilige buguso. Bei, yayo Godee koola ogolone badolone yo tei Godee doloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yelusalem mapoo debeli Yu odoo dia wiligi odoo oso Godee ogo odoo ogo doloso debeli sabolo, osoloso odoo abo Libaiyo bala maga Yonee mapoo diye diso, diayo Yonee yo tei odoo ogumo doloso woosalame. Eseme diayo Yonee mapoo dileso egeesee woosaso, “No tei odoo ogumo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Eseme Yonee yo to nei takalai gowele. Esino yayo nei dimapoo egeesee takaso, “A Kelisonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eseme diayo see yimapoo egeesee woosaso, “No odoo ogumo? No Ilayayo?” diso. Eseme yayo nei egeesee takaso, “Haye, a Ilayanee,” diso. Eseme see diayo yimapoo egeesee woosaso, “No Godee maga to toloso kokodo takomo sili odoo sibileigo neme bamelee, odoo ee nosomo?” dee takaso. Eseme yayo nei dimapoo egeesee takaso, “Haye, asonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eseme see diayo yimapoo egeesee takaso, “No tei odoo ogumo? Iba goomogo, to nei nayo taka ee iyo todileso ibada wiligi odoo iba diye di mapoo takalaiya. Esiga no tei odoo ogumo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eseme nei Yoneeye Godee maga to toloso kokodo takomo sili odoo Aisayaye taka to ee dimapoo egeesee takaso, “A miwe poogoo mi maga idageli odoo ee aso, Niba Lodeeye sibilei eli medee hoodo magee.” ");
INSERT INTO kkc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Eseme Pelisi odoo dia wiligi odoo oso diye di odoo oso dileso, nei Yonee mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Nayo takolone, no Kelisonee, osoloso no Ilayanee, osoloso no Godee maga to toloso kokodo takomo sili odoo osonee, dee takooso. Esino bei kasalame nayo odoo howo ka olugumo silala?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Eseme nei Yoneeye dimapoo egeesee takaso, “Ayo wulo odoo howomoo oluguliso. Esino odoo hee nima kulodu badoso. Esino niba yo gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yo ama hamamee egee siboso. Esino a tekeponee, ayo o homo mapoo kali bi ee pidigilei.” ");
INSERT INTO kkc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Osoloso Yoden howo hodiokoo Yoneeye odoo howo olugumelee Betani mi mapoo goo ogoso peledabaso. ");
INSERT INTO kkc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Biame hee mapoo Yesu Yonee mapoo sibume ogoloso Yoneeye egeesee takaso, “Ege, hagee Godeeyo Lam beso. Yayo mipoo hamapoo debeli odoo dia goo tokenee susuga ee hapoloso boobado bigileiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayo takolone, odoo sibileisogo doloso takomo sileemeni, odoo ee hagoso. Bei, ayo egeesee takomo sileeso, odoo hee ama hamamee sibileiso. Esino yayo kitulugu oso ayo kitulugu ee dagadi, dee takeliso. Bei, a soomagelega molome, yo daga olo badebeiso, dee takeliso. ");
INSERT INTO kkc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","Esiga Isalael odooso Kelisowo goo ee medee gooleedalame ayo diba howo olugulame ka simi.” Esiga Yonee eyo egei goo ee egeesee takaso, “Ayo daga Keliso odoo ogu bele dolone medee kibiya gooleedele. Esino ayo odoo howomoo olugulame, Godeeye a diye dolone amapoo egeesee taka, ‘Nayo Keliso egeesee gooleedalaiso. Dio Tei sibileso yibolo hodobo badoga agalaiso. Osoloso yayo odoo mapoo Dio Tei tenelaiso,’ diso. Godeeye egeesee taka duloso hamamee Dio Tei molo masi pusibileso yimapoo pubalegeme egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Esiga ayo goo hagee tei ogoloso yo tei Godeeyo Owolo dolone to hagee ayo nimapoo ka taka.” ");
INSERT INTO kkc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Biame hee mapoo Yonee o hamamee dili odoo bakadio dibolo hodobo mi hedebe omapoo tebisa meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Egeesee semelee omapoo Yesuye di ee ogoloso dimapoo egeesee takaso, “Niso ege, odoo egee Godeeyo Lam be ogoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eseme Yonee o hamamee dili odoo oso to egee duloso Yesuye di hamamee diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Eseme Yesuye bidi toboloso, odoo bakadio oso yima hamamee simi ee ogoloso, yayo dimapoo egeesee takaso, “Niba ogoo goo tala sibala?” diso. Eseme diayo nei yimapoo egeesee takaso, “Labai, no kapoo badeliyo?” diso. Labai hu eyo bei ee eligili odoo dolone ka takooso. ");
INSERT INTO kkc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eseme yayo nei egeesee takaso, “Niso sibileso ege,” diso. Osoloso neli tigime, odoo bakadio hagoso Yesubolo dileso yayo badeli mi ee egeiso. Eseme diba biame omapoo yibolo hodobo debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Odoo bakadio hagee bia dia kulodu odoo hee o hu ee Endulu. Endulu yo Saimon-Pitayo omolo. ");
INSERT INTO kkc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Esiga Enduluye Yesu ogoloso emei Saimon esiaso. Yo ogoloso yimapoo egeesee takaso, “Iba Mesaya egeiso,” diso. Mesaya hu eyo bei ee Keliso dolone ka takooso. ");
INSERT INTO kkc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Osoloso Enduluye Saimon Yesu mapoo ido diso. Eseme Yesuye yo ogoloso yimapoo egeesee takaso, “Saimon, Yoneeyo owolo, nee hu see Kepas hedileiso.” Kepas dee egee takoo ee Pita dolone ka takooso. ");
INSERT INTO kkc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Osoloso biame hee mapoo Yesu yo see Gelili mi mapoo dilame goomogaso. Esino biame omapoo yo odoo hee Pilipi tugodoloso yimapoo egeesee takaso, “No ama hamamee sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi hagee Betesaida odoo. Betesaida mi hagee Endulu dio Pita dio dia midee. ");
INSERT INTO kkc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Osoloso Pilipiye dileso Nataniyol ogoloso yimapoo egeesee takaso, “Moses sabolo osoloso Godee maga to toloso kokodo takomo sili odoo oso dia booka mapoo to hogugu oso takolone, odoo hee hamamee sibileisogo, dee takemelee odoo ee iyo olo egeiso. Yo Yesu, Nasalet mi mapoo badeli, yo Yosepeeyo owolo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Esino Nataniyoleeye Pilipi mapoo egeesee takaso, “Goo tekepo oso Nasalet mi maga kasee sibileiyo?” diso. Eseme Pilipiye nei yimapoo egeesee takaso, “No sibileso ege,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eseme Nataniyoleeye Yesu yima hegi simi ee ogoloso Yesuye o goo maga egeesee takaso, “Niso ege, odoo hagee tei Isalael odoo. Yo medee tei goo takeli odoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Eseme Nataniyoleeye nei yimapoo egeesee takaso, “Nayo a kasee gooleedoowo?” diso. Eseme Yesuye nei yimapoo egeesee takaso, “No daga Pilipiye dileso egelega badoboome, no pigi homo bei mapoo badoboome, ayo no egeiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Eseme Nataniyoleeye Yesu mapoo egeesee takaso, “Eligili odoo, no Godeeyo Owolo. Osoloso no Isalael odoo ibada wiligi odoo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Eseme Yesuye nei Nataniyol mapoo egeesee takaso, “No homo bei mapoo badoboome, ayo egei goo maga nayo amapoo tei ka toowala? Esino goo hagee pepooko, no hamamee goo toowa agalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Esiga ayo nimapoo tei goo taka. Niyo Kei mi osulu yamagoloso mologa, Godeeyo momaiye oso Odoo Holo amaga dokodoo polo osoloso amapoo sibo domologa agalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Biame bakadio poogoloso hamamee Gelili mi toowa ee ma kulodu Kana mi pepooko mapoo odoo heeso sobo hu wo neso. Biame domo omapoo Yesuwo owee onosee omapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Osoloso Yesu sabolo o hamamee dili odoo sabolo sobo hu wo ne ee agalame diba gilimadoloso debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wo ne biame domo mapoo wain i hosudoo ee ogoloso Yesuwo oweeye Yesu mapoo egeesee takaso, “Wain i olo hosudoona,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eseme Yesuye nei owee mapoo egeesee takaso, “Mo wee, ayo ogoo goo talame no amapoo ka simiyo? Mo biame tugodele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eseme oweeye nei odoo moso kulodu tou teli mapoo egeesee takaso, “Niba Yesuye to nimapoo takooga duloso to egee te,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Egeesi ma kulodu sesepeni yugoso moodoo 6 omapoo bediga meleeso. Sesepeni 6 hedebe hedebe di egee howo 100 lita egeesi keeseli. Yu odooso dia adaga dia goo ee dodolone, sesepeni howo keesoo hamapoo dee sabolo, homo sabolo, osoloso bi abo hapeliso. ");
INSERT INTO kkc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Eseme Yesuye odoo moso kulodu tou teli dimapoo egeesee takaso, “Sesepeni susuga hagee howoso metamagise,” diso. Eseme diayo sesepeni susuga egee howoso metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Eseme yayo tou teli odoo mapoo egeesee takaso, “Niba sesepeni omapoo howo keesaloso todileso, odoo sobo hu wo ne eyo wiligi odoo mapoo tenee,” diso. Eseme diayo egeesee moodooso. ");
INSERT INTO kkc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Esino howo eyo see wain i paso. Eseme wiligi odoo oso wain i egee wulo nalo egeiso. Egeesi ma kulodu wain i hagoso simi eyo bei yo gooleedele. Esino o tou teli odoo diba olo gooleedoo. ");
INSERT INTO kkc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Egeeseelone yayo sobo hulame simi giso ee idoloso yimapoo egeesee takaso, “Odoo susuga oso Yu odoo dia adaga dia goo ee dodolone, wo ne mapoo sibadee odoo mapoo daga wain i hadali keeneliso. Osoloso diba wain i toowa naloso halabolone doga, see wain i haga koo hadali ee dimapoo keeneliso. Esino nayo wain i dooboo hadali ee magoo moloso, see epedee keedoloso ka teneeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Esiga Gelili mi toowa ma kulodu Kana mi pepooko mapoo Yesuye daga malalo goo toowa opusomo di ee moodoo maga, yayo hu toowa toloso badeli goo ee eligiso. Eseme o hamamee dili odoo oso goo hagee ogoloso yimapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Osoloso goo hagoso dileso koodobume, Yesuye owee sabolo, osoloso omolo dio sabolo, osoloso o hamamee dili odoo sabolo Kapeniyum mi mapoo diso. Osoloso diba omapoo dileso dobolone biame abo poogooso. ");
INSERT INTO kkc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Osoloso Yu odoo dia Gababia wo nali biame ee olo koola tooboome, Yesu Yelusalem mi mapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Osoloso yo omapoo peleso egeino, odoo susuga oso tei moso beelee ma kulodu bulumakau be sabolo, osoloso sipi be sabolo, osoloso molo sabolo edebeeyo neiso talame, tosibileso odoo mapoo tenee domolome egeiso. Osoloso odoo aboso molee opusomo opusomo di ee tei moso eyo molee piligeli debi pooba mapoo doboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Osoloso Yesuye gowoolone tiso wei masi moodooloso wei oso sipi be sabolo, osoloso bulumakau be sabolo, osoloso odoo susuga peegoo hasiso buguso. Osoloso molee piligeli debi pooba bidige buguloso molee ko sabolo peegoo kugobuguso. ");
INSERT INTO kkc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Osoloso see molo neiso talame debei odoo mapoo egeesee takaso, “Bi susuga hagee toloso moso hamaga peegoo diyadee. Niyo mo Mamo moso ee bi teli moso dee na see,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Esiga goo hagoso peledaba ogoloso Yesu o hamamee dili odoo oso Godeeyo to booka mapoo hogugu oso taka goo ee egeesee gooleebuguso, “Ayo nee moso ee diya gooleeso. Esiga edebeeyo a wooloomalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eseme Yu odoo dia wiligi odoo tebisa oso bi susuga maloso gidebei odoo egee bia ee Yesuye tei moso ma kuloduga peegoo hasiso bugu goo ee ogoloso diayo yimapoo egeesee takaso, “No ogoso kitulugu toloso goo hageesee ka moodoowo? Esiga nayo kitulugu egee Godee maga too, dee takooga, nayo goo toowa opusomo di hee imapoo eligilei tekepo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eseme Yesuye dimapoo nei egeesee takaso, “Niyo tei moso hagee guobigi. Egeeseega, ayo see tobu biame bakadio hedebe di ee ma kulodu tegelaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Eseme diayo yimapoo egeesee takaso, “Iyo dugo 46 ee ma kulodu tei moso hagee tegeiso. Esiga biame bakadio hedebe di ee ma kulodu nayo saga kasee togo dalaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Esino Yu odoowo wiligi odoo hagee biaso Yesuye taka goo ee medee kibiya gooleedele. Bei, Yesuye tei moso eyo goo maga taka hagee, eyo nediliyo o su ee taka. ");
INSERT INTO kkc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Esiga Yesuye toloso hogado polome, hamamee Yesu o hamamee dili odoo oso Yesuye taka goo hagee gooleebuguso. Egeeseelone diayo Godeeyo to booka maga taka sabolo osoloso Yesuye taka to omapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuye Gababia wo ne biame omapoo Yelusalem mapoo peleso goo toowa opusomo di moodoo ogoloso odoo susuga oso yimapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Esino Yesuye dimapoo haga tei dele. Bei, yo odoo susuga dia sooloo ma kulodu goo goolee ee yo olo gooleedoo. ");
INSERT INTO kkc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Esiga yimapoo odoo heeso odoo dibada goo goolee ee takalai ee bei me. Bei, goo goolee susuga dibada sooloo ma kulodu egee molo ee, yayo malalo olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Esiga odoo hee badebeiso, o hu Nikodimas. Yo Pelisi odoo, osoloso Yu odoo dia wiligi odoo tebisa ee ma kulodu yinosee wiligi odoo hee yoso. ");
INSERT INTO kkc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Osoloso yayo gesi sibileso Yesu mapoo egeesee takaso, “Eligili odoo, iba gooleedoo, no eligili odoo Godeeye diye di ee noso. Bei, edebeeyo eyo goolee goo toowa opusomo di nayo egee moodoomo silo egeesi moodoolai tebile. Esino Godee nobolo hodobo badoga, nayo goo toowa opusomo di hageesi moodoolai tebileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Eseme Yesuye nei yimapoo egeesee takaso, “Ayo namapoo taka. Edebeeyo see soomagelega poogooga, yo Godeeye wiligi doloso badeli goo mapoo gadileime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Eseme Nikodimaseeye nei yimapoo egeesee takaso, “Odoo kauwa ee oweeyo beliye maga see tobu kasee soomagalaiyo? Yo see holope poloso oweeye see tobu soomagalai tebile,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Esino Yesuye see egeesee takaso, “Ayo namapoo taka. Edebeeyo howo maga osoloso Dio Tei maga see dia delega poogooga, yo Godeeye wiligi doloso badeli goo mapoo gadileime. ");
INSERT INTO kkc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mi odoo oso holope soomagoloso mi hamapoo debeliso. Esino Dio Tei oso gie badeli egee tenemolo odoo ee, Godeeyo owolo dio doloso badoboso kookaiyo gie badalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Esiga ayo namapoo takolone no see tobu soomagee dee hagee takoo duloso haga na dio di. ");
INSERT INTO kkc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","No pooso eyo goomoga maga sibulone goowa ee duliso. Esino yayo sibili eli sabolo osoloso yayo dili eli ee no gooleedele. Esiga Dio Tei oso odoo mapoo gie badeli egee tenemolo edebeeyo ogoloso koo gooleedeli.” ");
INSERT INTO kkc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Eseme Nikodimaseeye egeesee takaso, “Ha? Goo hagoso kasee peledabalaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Eseme Yesuye yimapoo egeesee takaso, “No Isalael odoo dia eligili odoo, esino no goo hagee koo gooleedolo? ");
INSERT INTO kkc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Esiga ayo namapoo taka. Iyo gooleedoo sabolo osoloso iyo egei goo ee Yu odoo nimapoo ka takomo siloso. Esino niyo ibada to mapoo tei talai ee ka gowooso. ");
INSERT INTO kkc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Esiga ayo nimapoo mi goo maga takeme, niyo tei tele. Egeesi ma kulodu ayo see nimapoo Kei mi eyo goo maga takooga, niyo kasee tei talaisomo? ");
INSERT INTO kkc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Odoo heeso bi Kei mi ma dokodoo egee molo ee agalame pele. Haye. Hedebe Odoo Holo ayo Kei mi mapoo ka badebei. Osoloso ayo Kei mi ma dokodooga mipoo hamapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Esiga daga hoogoo Isalael odoo diba miwe poogoo mi mapoo doboome, Moseseeye hebise ki biso moodoo ee homo sabolo poudooso. Goo hedebe egeesi masi, edebeeyo Odoo Holo anosee toloso egeesee poudileiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Goo egeesi maga edebeeyo amapoo tei toga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godeeye mi odoo diya sooloo dolone Owolo hedebe a meiye diso, ayo mi odoo ee halo talame. Esiga edebeeyo amapoo tei toga, diba Godee maga pileime, esino diba badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Esiga Godeeye Owolo a mipoo hamapoo meiye dee taka hagee, mi odoo dia goo tokenee eyo nei tenelame ka meiye dele. Esino mi odoo oso amaga gie badeli pidili talame ka simi. ");
INSERT INTO kkc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Osoloso edebeeyo Godeeyo Owolo amapoo tei toloso doga, dia goo tokenee eyo nei dimapoo dala tenelaime. Esino odoo agayo amapoo tei telega doga, diba dia goo tokenee eyo nei talame ka doso. Bei, diba Godeeyo Owolo hedebe amapoo tei telega. ");
INSERT INTO kkc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gadeebugu mipoo hamapoo simiso. Esino mi odoo oso gadeebugu egee goomegele poogoloso see neliga ono diya goomogaso. Bei, diayo dia suso goo moodoo ee diya tokeneega. Goo egeesi maga Godeeye dia goo tokenee eyo nei tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Esiga goo tokenee teli odoo ee gadeebugu hegilone gadeebugu mapoo sibilei diya ebiliso. Bei, gadeebugu oso dia goo tokenee ee woola eligiyaga. ");
INSERT INTO kkc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Esino edebeeyo Godeeye goomoga goo ee tomo siloga, diba gadeebugu mapoo sibilei ebileime. Bei, gadeebugu oso dia goo ee yilige buguga, goo susuga diayo moodoo ee Godeeye kitulugu maga ka moodoodoo doloso edebeeyo gooleedalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Osoloso goo hagoso dileso koodobume, Yesuye o hamamee dili odoo sabolo Yelusalem poogoloso see Yudiya mi toowa ee ma kulodu mi pepooko abo mapoo diso. Diba omapoo dileso dobolone odoo howo olugumeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Esino Yonee yo neliga moso ma kulodu tooselega badolone, Salim mi koola mapoo Ainon mi mapoo yayo odoo howo oluguso. Bei, mi omapoo howo toowa meleega, odoo susuga diba Yoneeye howo olugulame yimapoo sibumeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Egeesee semelee biame omapoo Yonee o hamamee dili odoo aboso Yu odoo dia adaga dia goo ee dodolone dee sabolo, homo sabolo, osoloso bi abo hapeli goo maga Yu odoo hee sabolo toso agadigaso. ");
INSERT INTO kkc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Osoloso diayo sibileso Yonee mapoo egeesee takaso, “Eligili odoo, daga Yoden howo hodiokoo odoo nobolo hodobo badebei ee no gooleedoo. Esiga nayo odoo egeeyo goo imapoo takemeni oso odoo howo ka olugumoloso. No ege, odoo susuga oso no poogoloso see yimapoo ka duso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Esino Yoneeye egeesee takaso, “Edebeeyo eyo goolee goo hee moodoolai tebile. Esino Godeeye yimapoo kitulugu teneega, yo goo egee moodoolai ee tebileiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Esiga ayo nimapoo takolone, a Kelisonee, dee taka goo ee niba olo duso. Esino a wulo o eli moodoolame malalo diye di odoo ee aso. ");
INSERT INTO kkc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Soboso giso obuoga, yo olo giso egeeyo. Odoo giso ido peli ee omapoo tobudulone, giso sibabeleso bameliso. Osoloso gisoso peledoboloso to taka ee duloso yo diya goomegeliso. Egeesi ma kulodu odoo giso ido peli masi ee aso. Esiga a epedee diya goomoga sabolo ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Esiga Kelisoye toowa dolone, nei ayo pepooko dolone badalai tekepo. ");
INSERT INTO kkc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Esiga Kei mi ma dokodooga simi odoo oso odoo susuga dagadileso ka badoso. Esino mipoo hamapoo soomagoo ee mi odooso. Esiga yo wulo mipoo hageeyo goo ee takomo sili. Esino Kei mi ma dokodooga simi odoo yayo goo susuga diya dagadileso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Osoloso yayo egei goo sabolo osoloso yayo du goo ee takeliso. Esino odoo heeso o to mapoo tei koo teli. ");
INSERT INTO kkc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Esino odoo agayo o to duloso tei too goo oso Godee yo tei goo takeli dolone ka eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Esiga Godeeye diye di odoo oso Godee maga to toloso takomo siliso. Bei, Godeeye o Dio Tei su goodegelega yimapoo olo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Godeeye Owolo sooloo dolone goo susuga ee yayo wiligi doloso badalame kitulugu yimapoo olo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Esiga odoo agayo Owolo mapoo tei toga, yo badoboso kookaiyo gie badeli talaiso. Esino odoo agayo Owolo mapoo mesile poogooga, yo badoboso kookaiyo gie badeli talaime. Esino Godeeyo kamana goo oso yimapoo kookaiyo osee malaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuye howo olugu odoo oso diya bei molone, yima hamamee deedeeso. Osoloso diayo Yoneeyo hamamee dili odoo ee dagadi goo ee, Pelisi odoo diba duso. ");
INSERT INTO kkc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Esino Yesuye odoo howo olugumo sile. Hedebe o hamamee dili odoo oso odoo howo ka olugumo silee. ");
INSERT INTO kkc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Esino Yesu yo Pelisi odoo oso o goo gooleedoo goo ee yo olo duloso, Yudiya mi poogoloso see Gelili mi mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Osoloso yo Gelili mi mapoo wedi dulone, Samaliya mi domo abaga dili eli omaga diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesuye Samaliya mi mapoo sibileso mi edebeeyo bia Saika deli mapoo peledabaso. Esiga Saika mi edebeeyo bia hagee mi hee daga hoogoo Yekobeeye owolo Yosep mapoo tenee eyo koola omapoo moloso. ");
INSERT INTO kkc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Esiga Yekobeeyo howo ou omapoo osee meleeso. Egeesi ma kulodu Yesu yo mi eli sage simiga kwasime, howo ou koola ogolone omapoo badebeiso. Biame egee osoko olo oo domo taba mapoo egeesee ka see. ");
INSERT INTO kkc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Osoloso Yesu o hamamee dili odoo ee edebeeyo bia mi mapoo nei neiso talame dime, Samaliya sobo howo ou omapoo howo kalame simiso. Eseme Yesuye yimapoo egeesee takaso, “Nayo a howo keenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Esino sobo egee yayo taka to ee duloso dio diso. Bei, Yu odooso Samaliya odoo maga peegooga booloogamo silesibiliso. Eseme sobo ogoso Yesu mapoo egeesee takaso, “Nayo kasi maga amapoo howo keenee dee ka takala? Bei, no Yu odoo. Esino a Samaliya sobo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eseme Yesuye nei yimapoo egeesee takaso, “Nayo Godeeye wulo egee tenemolo goo ee gooleedoloso, odoo namapoo howo hoowa mo goo ee, no gooleedoloso badebei diepi, nayo amapoo kookaiyo gie badeli teneli howo ee hoowali. Osoloso nayo amapoo hoowa diepi, ayo nei namapoo howo egee teneli,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Eseme sobo ogoso nei Yesu mapoo egeesee takaso, “Wiligi odoo, no gie badeli teneli howo ee kamapoo keelaiyo? Osoloso namapoo ou howo keli me. Osoloso howo ou hagonosee diya gooboodomou. ");
INSERT INTO kkc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Esiga ibada amawe Yekob pepooko dolone see nayo toowa dalame ka sala? Bei, ibada amawe Yekobeeye howo hagee ka ou, osoloso yayo owolo dio sabolo osoloso o be sabolo howo ou hedebe hagee naliso. Osoloso yayo howo ou hagee imapoo poogoo diso.” ");
INSERT INTO kkc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Eseme Yesuye nei yimapoo egeesee takaso, “Edebeeyo howo ou hamapoo howo naga, diba see howo nala pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Esino odoo agayo howo ayo hagee keenee ee naga, yo see howo nala pagalaime. Esiga kookaiyo gie badeli teneli howo ayo yimapoo tenelai oso yima kulodu howo ou masi molone, yimapoo badoboso kookaiyo gie badeli ee tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Eseme sobo ogoso nei yimapoo egeesee takaso, “Wiligi odoo, nayo egee takoo howo egee amapoo tenee, a hamamee see howo nala pegelega pagalame. Osoloso hamamee a hamapoo see howo kala sibilega pagalame,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Eseme Yesuye yimapoo egeesee takaso, “No dileso nomo ido sibe,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Eseme sobo ogoso nei yimapoo egeesee takaso, “A giso me,” diso. Eseme Yesuye nei egeesee takaso, “Nayo takolone, no giso me, dee egee takoo tei goo takoo. ");
INSERT INTO kkc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bei, no daga giso dee tiadoo egeesi mapoo obiaso. Esino giso epedee nobolo hagee bado ee tei nomonee. Esiga nayo egee takoo, tei goo takoo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Eseme sobo ogoso nei yimapoo egeesee takaso, “Wiligi odoo, a gooleedo, no Godee maga to toloso kokodo takomo sili odoo hee nosodoo. ");
INSERT INTO kkc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Samaliya bia ibada amawe dio oso mubi hagee ma dokodoo Godeeyo hu dokodoo poudiliso. Esino Yu odoo niyo takolone hedebe Yelusalem mi mapoo Godeeyo hu dokodoo ka poudilei tekepo dee takeliso. Esiga nayo amapoo takee, mi tekepo kamapoo iyo Godeeyo hu dokodoo ka poudileiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eseme Yesuye nei yimapoo egeesee takaso, “Emegei, no mo to mapoo tei te. Edebeeyo Ma Godeeyo hu dokodoo poudalame Yelusalem mapoo osoloso mubi hamapoo sibilega pagalai biame ee olo siboso. ");
INSERT INTO kkc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaliya odoo niyo goomoga poudili goo ee niba gooleedele. Esino Yu odoo iyo goomoga poudili goo ee iba gooleedooso. Bei, gie badeli pidili odoo ee hedebe Yu odoo imaga sibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Esiga biame olo siboso, esino biame ee olo simiso, tei yimapoo goomoga poudili odoo oso Dio Tei oso kitulugu maga, osoloso tei goo maga, Ma Godee mapoo goomoga poudalame. Bei, Ma Godeeye goo hageesi maga yimapoo goomoga poudili odoo omapoo diya goomegeliso. ");
INSERT INTO kkc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godee yo Dio. Osoloso yimapoo goomoga poudili odoo oso Dio Tei maga, osoloso tei goo maga yimapoo goomoga ka poudilei tekepo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Eseme sobo ogoso nei yimapoo egeesee takaso, “A gooleedooso, Mesaya edebeeyo takolone Keliso deli ee sibileiso. Osoloso yayo sibileso imapoo goo susuga medee eligileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Eseme Yesuye nei yimapoo egeesee takaso, “Odoo ee Mesaya aso, nobolo to egee komolo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Egeesee semelee mapoo Yesuwo hamamee dili odoo oso edebeeyo bia mi ee ma kuloduga wedi sibileso egeino, Yesuye sobo sabolo to komolome, diya dio diso. Esino odoo heeso sobo omapoo woosolone, no ogoo goomogolo, dee takele. Osoloso odoo heeso Yesu mapoo woosolone, nayo kasalame sobo sabolo to ka kamalala, dee takele. ");
INSERT INTO kkc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Osoloso sobo oso o ou howo keli omapoo magoloso see o moso bia takalame see wedi diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Sobo ogoso dileso egeesee takaso, “Niba odoo hee hagee agalame sibe. Yayo goo ayo moodoo susuga ee takaso. Esiga odoo egee Keliso malaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eseme moso bia susuga Yesu agalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Odoo susuga Yesu agalame sibadaga molome, Yesuwo hamamee dili odoo oso Yesu mapoo egeesee takaso, “Eligili odoo, no nei ne,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Esino Yesuye dimapoo egeesee takaso, “A nei moloso. Esino nei ayo nali ee niba gooleedele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Eseme Yesu o hamamee dili odoo oso diesono egeesee takaso, “Odoo heeso yimapoo nei tenee bele?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Eseme Yesuye dimapoo egeesee takaso, “Mo nei ee Godeeye goomoga goo talai goo oso. Osoloso yayo a diye diso, tou yayo amapoo tenee ee tomo dimeleso hoo poogoo mapoo hosudalame. ");
INSERT INTO kkc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Niyo egeesee takeliso, ‘a bakadio bakadio di poogoloso nei howo segei tala dileiso,’ dee takeliso. Esino ayo nimapoo taka. Niba howo puo ogoloso nei howo segei mapoo ege. Bei, epedee hagee nei telegee ee talai biame hagoso. ");
INSERT INTO kkc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Esiga nei howo segei teli odoo oso dia tou eyo nei epedee hamapoo toso. Osoloso diayo odoo ee homokoko masi gooloogaloso tosibileso kookaiyo gie badeli talai mi mapoo mooloogoo mageliso, nei howo segeli odoo sabolo, osoloso nei howo segei teli odoo sabolo hodobo goomogalame. ");
INSERT INTO kkc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Egeesi ma kulodu toso hagee takoo ee tei takooso, ‘Odoo heeso nei howo segeliso. Osoloso see odoo heeso nei howo segei ee teliso.’ ");
INSERT INTO kkc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Esiga a niyo nei howo segele poogoo mi mapoo nei howo segei ee talame diye diso. Bei, mi omapoo odoo aboso daga tou toowa tooso. Esino see niyo dileso talaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaliya soboso dileso o odoo mapoo takolone, “Goo susuga ayo moodoo ee yayo amapoo taka,” dee takeme, Samaliya odoo susuga mi omapoo debeli oso to hagee duloso Yesu mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Osoloso diayo sibileso Yesu mapoo egeesee takaso, “No epedee ibolo hodobo hamapoo badebee,” diso. Eseme Yesu yo biame bakadio dibolo hodobo omapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Egeesi ma kulodu odoo susuga oso to yayo taka ee duloso yimapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eseme diayo sobo omapoo egeesee takaso, “Nayo daga Yesuwo goo ee imapoo takeme, nee to duloso tei tooso. Esino iba epedee yayo takooga iso duloso tei toso. Esiga iba gooleedooso, odoo hagee mi odoo susuga dia gie badeli pidili odoo osodoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Egeesi ma kulodu Yesu eyo daga egeesee takaso, “Godee maga to toloso kokodo takomo sili odoo ee tei o moso bia oso goweliso,” diso. Yesu biame bakadio Samaliya mi mapoo badoboso see Gelili mapoo diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Osoloso yo Gelili mapoo sibileso peledoboome, edebeeyo yo ido diso. Bei, diba nosee Yesuye Yelusalem mapoo Gababia wo ne biame mapoo goo susuga yayo moodoo ee diba egeiga. ");
INSERT INTO kkc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Osoloso Yesu Gelili mi toowa omapoo badolone see Kana mi pepooko mapoo diso. Daga mi omapoo howodee ee see yayo wain i palame moodooso. Biame omapoo Kapeniyum mi mapoo gamalee odoo heeyo giso holo paiye badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Esino gamalee odoo ogoso Yesuye Yudiya mi maga see Gelili mi mapoo simi goo ee duloso Yesu mapoo diso. Yo dileso howolone egeesee takaso, “Mo holo paiyeso talame badoso. Esiga nayo mo holo tekepo palame Kapeniyum mi mapoo abolo sibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Esino Yesuye yimapoo egeesee takaso, “Niyo ayo goo toowa opusomo di moodoo ee egelega poogooga, amapoo tei talaime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eseme odoo ogoso nei Yesu mapoo egeesee takaso, “Wiligi odoo, mo holo teyaga, nayo saga sibileso yo tekepo palame moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Esino Yesuye yimapoo egeesee takaso, “No see wedi di. Nee holo wedileiso,” diso. Eseme odoo yo Yesuwo to duloso tei toloso see o mi mapoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Osoloso yo see eli domopoo osee dimolome, o tou teli odoo oso sibileso yimapoo egeesee takaso, “Nee holo olo weidiloso badoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eseme odoo ogoso nei dimapoo egeesee takaso, “Osoko howo domo kamapoo molome, yo kekebisa ka koododiala?” diso. Eseme diayo nei yimapoo egeesee takaso, “Eiyo osoko olo wudu magoo mapoo ka koododia,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eseme odoo yo gooleedoloso egeesee gooleebuguso, bei, eiyo osoko howo hedebe omapoo Yesuye yimapoo takolone, “nee holo weidileiso,” dee taka goo ee goolee buguso. Eseme odoo susuga o moso kulodu debeli sabolo osoloso yibolo Yesu mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Esiga Yesuye Yudiya mi maga see Gelili mi mapoo sibileso goo toowa opusomo di moodoo hagoso olo bakadio diso. ");
INSERT INTO kkc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Osoloso goo hagoso dileso koodobume, Yu odooso wo nali hee nalame Yelusalem mapoo polome, Yesu yinosee omapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Esiga Yelusalem mi beelee mapoo osulu hee Sipi Be Osulu deli meleeso. Osoloso ee ma kulodu howo sauwili dadabayo ou toowa meleeso. Howo sauwili dadabayo ou o hu ee Yu odoo dia toso takolone Betesada deliso. Osoloso howo ou pee mapoo hau pooba dee tiadoo egeesi meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Egeeseelone odoo paigiga sabolo, osoloso odoo howo neliga sabolo, osoloso odoo kido todobia sabolo, osoloso odoo su kakawa poogoo sabolo hau omapoo tieseliso. Osoloso diba omapoo tiesamolone, biame abo mapoo Godeeyo momaiye heeso sibileso howo egee wolabeleso bolone osee tiesameliso. Bei, momaiyeso howo wolomeleso koodobuoga, odoo daga malalo howo ee ma kulodu meili odoo ee tekepo peliso. ");
INSERT INTO kkc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Egeeseelone giso hee dugo 38 ee ma kulodu paiye melee onosee hau omapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Odoo daga yayo hoogoo pailoso badebei Yesuye ogoloso yimapoo egeesee takaso, “No see weidilei goomogolo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eseme odoo ogoso yimapoo nei egeesee takaso, “Wiligi odoo, howo weeleega, a pidilame ido meilei odoo hee me. Bei, a meilame seega, odoo heeso malalo meiliso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Eseme Yesuye yimapoo egeesee takaso, “No toboloso nee kida toloso di,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Osoloso biame omapoo odoo egee see olo tekepo poloso o kida toloso diso. Esino goo hagoso peledaba ee Yu odoo dia hasali biame omapoo ka peledaba. ");
INSERT INTO kkc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eseme Yu odoo dia wiligi odoo tebisa oso odoo hagoso o kida toloso di ee ogoloso yimapoo egeesee takaso, “Hasali biame hamapoo odoo heeso o kida toloso dilei tei,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eseme odoo ogoso nei egeesee takaso, “Odoo a tekepo pa oso amapoo takolone, mo kida toloso di, dee takeme a ka di,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eseme diayo yimapoo nei egeesee takaso, “Odoo agayo namapoo takolone, nee kida toloso di, dee ka takala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Esino odoo yo tekepo pa ee yo medee kibiya gooleedele. Bei, odoo susuga oso diya mooloogoodeme, Yesu yo mooloogoodoo ee ma kulodu esigaboodooso. ");
INSERT INTO kkc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","See hamamee Yesuye odoo egee tei moso tegei ma kulodu badebei ogoloso yimapoo egeesee takaso, “No, no medee goolee, no epedee olo tekepo paso. Esiga no see goo tokenee na te. Nayo goo tokenee see tobu tomo siloga, goo tokenee toowa see namapoo peledebeyaga,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eseme odoo ogoso dileso Yu odoo dia wiligi odoo dimapoo takolone egeesee takaso, “Yesuye a tekepo ka pa,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Egeesi ma kulodu Yesuye Yu odoo dia hasali biame mapoo goo hageesee teme, Yu odoo dia wiligi odoo tebisa oso komonolone yimapoo hegi goo tenelame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Esino Yesuye dimapoo egeesee takaso, “Mo Ma biame susuga tou tomoloso. Esiga anosee biame susuga tou ka tomoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuye to egeesee takeme, nei diayo yo wooloomalame diya goomogaso. Bei, yayo hedebe Yu odoo dia hasali biame ee gababile, esino yayo takolone, Godee yo tei Ama, dee taka goo omaga, eyo nediliyo yo Godee sabolo hodobo teiba neme. ");
INSERT INTO kkc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Esiga Yesuye Yu odoo dia wiligi odoo tebisa mapoo egeesee takaso, “Ayo nimapoo taka. Owolo ayo mawo goomoga goo hee talai tebile. Esino Owolo ayo hedebe Maye teli goo ee ogoloso anosee goo ee teliso. ");
INSERT INTO kkc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maye Owolo a diya sooloo dalaga, goo yayo teli susuga ee Owolo amapoo eligiliso. Eseme niyo Owolo ayo goo moodoo ee ogoloso hoowoolame, Maye amapoo goo diya toowa moodoolai eligileiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Egeesi ma kulodu Maye odoo wedia hogogaduloso see gie badeli egee tenemolo, egeesee solone, Owolo ayo odoo mawo goomoga mapoo gie badeli ka tenemoloso. ");
INSERT INTO kkc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Esiga Maye odoo goo koo midili. Esino yayo Owolo amapoo kitulugu olo teneeso, ayo odoo susuga dia goo ee midilame. ");
INSERT INTO kkc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Egeesi ma kulodu Maye goo egee moodooso, odoo susuga oso Ma mapoo goomogolone o hu dokodoo poudalame. Osoloso diayo Owolo amapoo goomogolone mo hu onosee dokodoo ka poudalame. Esiga odoo agayo Owolo amapoo goomoga poudilega badoga, yo Ma Godee a diye di odoo mapoo goomoga koo poudoso. ");
INSERT INTO kkc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Esiga ayo nimapoo ka taka. Mo to duloso a diye di odoo mapoo tei teli odoo ee badoboso kookaiyo gie badeli olo tooso. Odoo egeesee seli ee o goo tokenee eyo nei talaime. Yo teli maga dagadileso see gie badeli mapoo badoso. ");
INSERT INTO kkc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Esiga ayo nimapoo ka taka. Biame oso sibileiso, esino biame ee olo simiso, odoo tei telega wedia oso Godeeyo Owolo mo to dulei. Egeesi ma kulodu edebeeyo mo to duloso tei toga, yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bei, Ma yo gie badeli eyo bei yoso. Esiga Owolo ayo gie badeli eyo bei doloso badalame, yayo kitulugu amapoo olo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Osoloso Maye Owolo amapoo kitulugu olo teneeso, ayo odoo susuga dia goo ee midilame. Bei, a Odoo Holo. ");
INSERT INTO kkc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Esiga ayo taka to hagee duloso niba haga na dio di. Bei, biame oso sibileiso, odoo wedia dia bi mapoo egee tiesamolo oso Odoo Holo mo to duloso dia bi maga hogogadileiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Egeesi ma kulodu goo tekepo tomo sili odoo diba badoboso gie badeli talame hogogadileiso. Esino goo tokenee tomo sili odoo diba dia goo tokenee eyo nei talame hogogadileiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ayo goo mawo goolee ee tomo silei tebile. Bei, Ma a diye di oso goo midilei goo amapoo takooga, ayo goo egeesi ka midili. Esiga ayo goo midili ee diya tekepo. Bei, ayo mawo goomoga goo koo tomo sili. Esino ayo hedebe odoo a diye di oso goomoga goo ee ka tomo siloso. ");
INSERT INTO kkc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Esiga ayo hedebe mo goo maga takooga, edebeeyo mo to mapoo tei talai goo eyo bei mauwe dalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Esino mo Maye mo goo maga takomoloso. Bei, a gooleedoo, yayo mo goo maga egee takoo, ee tei takooso. ");
INSERT INTO kkc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Esiga niyo odoo abo Yonee mapoo diye diso. Eseme yayo dimapoo tei goo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Esino edebeeyo mo goo maga tei goo egee takoo goo ee tei beleso, a medee koo gooleeso. Esino niyo gie badeli talame ayo goo susuga hagee nimapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yonee yo keme masi gadeebugu nimapoo teneeso. Esiga niyo biame deiyepo ee ma kulodu gadeebugu sabolo dabalame diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Esiga Yoneeye mo goo maga tei goo takomo siliso. Esino tou ayo temeleso hosudalame Godeeye amapoo tenee oso Yoneeye mo goo takomo sili ee dagadiso. Bei, tou ayo tomo sili oso Maye a diye di goo ee ka eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Osoloso mo Maye a diye di oso mo goo maga tei goo ka takooso. Esino niyo to yayo taka ee dule, osoloso o mudu egele. ");
INSERT INTO kkc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Esiga niba Godeeyo to duloso nibada sooloo ma kulodu tei koo teli. Bei, niyo Maye diye di odoo amapoo tei koo teli. ");
INSERT INTO kkc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Niyo Godeeyo to booka mapoo hogugu medee hesigaloso gooleedoloso dobolone, nei to oso nimapoo gie badeli tenelaiso doloso doso. Esino niyo to hesiga ee mo goo takeli. ");
INSERT INTO kkc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Esino ayo nimapoo gie badeli tenelame seega, niyo amapoo sibilei koo goomegeli. ");
INSERT INTO kkc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Osoloso niyo see mo hu dokodoo poudilei, ayo haga koo gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bei, a gooleedooso, niyo nibada sooloo ma kulodu Godee goolee mauwe. ");
INSERT INTO kkc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Esiga ayo mo Ma Godeeyo hu maga simiso. Esino niyo a koo goomogoso. Esino edebeeyo eyo goolee o hu maga siboga, niyo odoo egee goomogolone yo idiliso. ");
INSERT INTO kkc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Esiga niyo wulo edebeeyo nibada hu dokodoo poudilei goomogolone debeliso. Esino Godee hedebe yayo nibada hu ono dokodoo poudalame, niyo ki koo kituluguli. Esiga niyo amapoo kasee tei talaiyo? ");
INSERT INTO kkc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Esiga ayo Mayo mudugiyopoo niba odoo tokenee dee takeeya dee na goolee. Niyo goolee, Moseseeye niba pidilei gooleeso. Esino yayo Mayo mudugiyopoo niba odoo tokenee dalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Egeesi ma kulodu niyo Moseseeye taka to mapoo tei too diepi, niba ayo taka to mapoo tei teliyo. Bei, Moseseeye mo goo ee Godeeyo to booka mapoo ka hogugu. ");
INSERT INTO kkc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Esino niyo Moseseeye to hogugu mapoo tei telega ka doso. Esiga niyo to ayo hagee takoo mapoo kasee tei talaiyo?” ");
INSERT INTO kkc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eseme goo hagoso dileso koodobume, Yesu yo see Gelili abei hodiokoo du maga dalo soowaso. Gelili abei hageeyo hu hee ee Taibiliyes deliso. ");
INSERT INTO kkc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Egeeseelone Yesuye goo toowa opusomo di moodoolone, odoo paigiga susuga tekepo moodoo demelee maga, odoo mooloogoodoo toowa oso goo egee ogoloso yima hamamee mili diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Eseme Yesuye o hamamee dili odoo sabolo mubi ma dokodoo peleso debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Osoloso biame omapoo Yu odoo dia Gababia wo nali biame ee olo koola tabaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Biame omapoo odoo mooloogoodoo toowa oso yimapoo sibadee ee ogoloso Yesuye Pilipi mapoo egeesee takaso, “Iyo nei moleeso kamapoo toloso odoo susuga hamapoo ka pileiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Esiga Yesuye odoo hagee bia dimapoo moodoolai goo ee yo olo gooleedoloso badolone, see wulo Pilipiye tei too ee agalame yimapoo egeesee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eseme Pilipiye nei egeesee takaso, “Odoo susuga hagee bia dimapoo iyo nei toloso pilei ee, molee toowa kamapoo talaiyo? Bei, edebeeyo odoo susuga hagee bia nei pilame molee talame biame 200 ee ma kulodu tou toowa toga, molee oso odoo hedebe hedebe di mapoo wulo nei pepooko pilei tebileime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Eseme Yesu o hamamee dili odoo hee Saimon-Pitayo omolo Enduluye Yesu mapoo egeesee takaso, “Hagee ma kulodu giso holo heeso wo si dee tiadoo sabolo osoloso di bakadio sabolo toloso badoso. Esino nei pepooko hagoso odoo susuga ee pilei tebile,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eseme Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Odoo susuga hagee bia bulume doloso takee,” diso. Mi omapoo obu bouwe meleeso. Eseme odoo susuga go domo omapoo bulumaso. Egeesi ma kulodu hedebe gisowe hesiga ee 5,000 egeesi tugodooso. ");
INSERT INTO kkc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Eseme Yesuye wo si toloso Godee mapoo goomoga to takoloso, wo si popeiloso odoo susuga mapoo piso. Osoloso di bakadio toloso goo hedebe o egeesi moodooso. Eseme odoo susuga oso nei egee naloso diya edigaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Diba nei naloso oduguloso doboome, Yesuye o hamamee dili odoo dimapoo egeesee takaso, “Nei abo poogoo susuga ee misigamo di. Nei abo wulo gamenee peegeeyaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eseme wo si dee tiadoo odoo susuga oso naloso abo poogoo ee, Yesu o hamamee dili odoo oso misigamo dileso bou tegei 12 egeesi metamagisaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Odoo susuga oso Yesuye goo toowa opusomo di moodoo hagee ogoloso egeesee takaso, “Tei takoo, odoo hagee Godee maga to toloso kokodo takomo sili odoo iyo sibileiso doloso bolone debei odoo ee hagosodoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eseme Yesuye dia wiligi odoo tabalame, Yesu mapoo sibileso seselame gooleemelee goo ee, yo olo gooleedooso. Esino Yesuye olo ogoloso diba poogoloso see obusomo mubi ma dokodoo palaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Olo habedee mapoo Yesu o hamamee dili odoo oso yo balame abei mapoo mouso. ");
INSERT INTO kkc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Esino Yesu sibilega molome olo neligaso. Eseme diba dia du mapoo toboloso Kapeniyum mi mapoo dalo soowaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Diba sudaso olo sulugamo diyadaga molome, i toowa simi oso howo ki toowa simiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Diba eli sage 5 kilomita egeesi diyadaga molome, Yesuye howo ma dokodooga dimapoo sibume egeiso. Eseme diba diya obulone dio diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Esino Yesuye dimapoo egeesee takaso, “Niba haga na ebi. Ayo siba,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eseme diayo goomoga sabolo yo dia du ma kulodu dabeegee diso. Egeesee semelee mapoo haga booloogelega mi diayo di omapoo peledoboloso dia du omapoo oluguso. ");
INSERT INTO kkc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Biame hee mapoo Yesuye nei pi odoo susuga oso du dali hedebe omapoo meileso Yesu bameleeso, daga omapoo du hedebe meleega, diayo goolee Yesu omapoo badaba bele dolone. Bei, Yesu o hamamee dili odoo dibusomo daga malalo du egee toloso dime diayo egeiga. ");
INSERT INTO kkc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eseme biame domo omapoo odoo du abo maga Taibiliyes mi maga sibileso odoo mooloogoodoo toowa oso debei mapoo peledabaso. Daga mi koola omapoo Yesuye Godee mapoo goomoga to takoloso odoo susuga mapoo nei piso. ");
INSERT INTO kkc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Esino diayo omapoo egeino, Yesu sabolo o hamamee dili odoo sabolo me neme, see diayo du omaga Yesu esilame Kapeniyum mi mapoo soowaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Diayo abei daloso Kapeniyum mi mapoo peledoboloso Yesu ogoloso yimapoo egeesee takaso, “Eligili odoo, no kopolone hamapoo ka simiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Eseme Yesuye nei egeesee takaso, “Ayo nimapoo taka. Niyo a esiamo simi egee, ayo goo toowa opusomo di moodoo ee egeiga, niyo a ka esiamo sibile. Esino niba ayo nei pime ne oso diya edigaga, niyo wulo a ka esiamo simidoo. ");
INSERT INTO kkc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Esiga niba nei saga me pegeli egeesi haga na esiamo silesibe. Esino niba kookaiyo moloso osee meli nei ono ka esiamo silesibe. Odoo Holo ayo nei hagee nimapoo tenelaiso. Bei, Ma Godeeye Owolo ayo goo hagee talame amapoo kitulugu olo teneeso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Eseme diayo nei egeesee takaso, “Godeeye iyo ogoo goo talame diya ka goomogosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eseme Yesuye nei dimapoo egeesee takaso, “Godee yo goomogoso, yayo diye di odoo amapoo tei talame.” ");
INSERT INTO kkc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Eseme odoo mooloogoodoo oso yimapoo egeesee takaso, “Iyo namapoo tei talame, nayo ogoo goo toowa opusomo di ka moodoolaiyo? Bei, Godeeyo to booka mapoo hogugu oso takolone, ibada amawe dio oso miwe poogoo mi mapoo silesibume, Moseseeye Kei mi ma dokodooga wo mana deli ee diayo nalame teneliso. Esiga Moseseeye ibada amawe dimapoo goo hagee moodooso. Esino iyo namapoo tei talame, nayo imapoo ogoo goo moodoolaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo taka. Moseseeye nibada amawe dio mapoo Kei mi wo ee tenele. Esino mo Maye dimapoo wo egee ka tenee. Goo hedebe egeesi masi, yayo Kei mi ma dokodooga tei wodee ee nimapoo ka tenemoloso. ");
INSERT INTO kkc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Esiga Godeeyo wo Kei mi ma dokodooga mi hamapoo sibeye dee taka ee aso. Bei, ayo mi odoo mapoo gie badeli ka tenemoloso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eseme nei diayo yimapoo egeesee takaso, “Wiligi odoo, biame susuga gie badeli wo egee nayo imapoo tenemelee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Eseme Yesuye egeesee takaso, “Gie badeli teneli wo aso. Esiga odoo agayo amapoo siboga, yo see hodileime. Osoloso odoo agayo amapoo tei toga, yo see howo nala pagalaime. ");
INSERT INTO kkc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Daga ayo nimapoo takolone, goo toowa opusomo di ayo moodoo ee niyo olo egeiso, dee takaso. Esino niba amapoo tei koo to. ");
INSERT INTO kkc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Odoo mo Maye amapoo tenee oso amapoo sibileiso. Esiga dima kulodu odoo hee ayo peegoo habigileime. ");
INSERT INTO kkc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bei, ayo Kei mi ma dokodooga mi hamapoo simi egee, mawo goomoga goo ee talame ka sibile. Esino mo Ma, a diye di odoo oso goomoga goo ee talame ka simi. ");
INSERT INTO kkc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Egeesi ma kulodu yayo goomoga goo ee hagoso. Odoo yayo amapoo tenee dima kulodu ayo hedebe osugobalai, yo koo goomogoso. Esino hamameedee biame mapoo ayo diba wedia maga see gie badeli talame hogogadileiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bei, mo Ma yo goomogoso, odoo agayo Owolo a ogoloso amapoo tei toga, diba badoboso kookaiyo gie badeli talaiso. Osoloso hamameedee biame mapoo ayo diba wedia maga see hogogadileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Egeesee semelee biame omapoo Yesuye takolone, “A Kei mi ma dokodooga simi wo aso,” dee takeme, Yu odoo oso duloso komonolone to boowaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eseme diayo egeesee takaso, “Odoo hagee Yosepeeyo owolo Yesuso. Esiga ama dio owee dio, iba gooleedoo. Esino yayo takolone, yo Kei mi maga simi, diso. Yayo kasalame egeesee ka takayo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Esino Yesuye nei dimapoo egeesee takaso, “Nima kulodu to boowa egee molo omapoo koodobie. ");
INSERT INTO kkc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bei, edebeeyo eyo goolee amapoo sibileime. Esino Ma a diye di oso amapoo sibilame gi odoo oso amapoo sibileiso. Osoloso hamameedee biame mapoo ayo yo ta maga see hogadileiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Osoloso Godee maga to toloso kokodo takomo sili odoo heeso egeesee hoguguso, ‘Godeeye odoo susuga eligileiso,’ diso. Esiga odoo agayo Mayo to duloso yimaga goo gooleedoga, diayo amapoo sibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Odoo heeso Ma egele. Esino hedebe Ma Godee maga simi odoo ayo Ma egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Esiga ayo nimapoo taka. Amapoo tei too odoo yo olo badoboso kookaiyo gie badeli tooso. ");
INSERT INTO kkc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gie badeli teneli wo ee aso. ");
INSERT INTO kkc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Esino nibada amawe dio oso miwe poogoo mi mapoo dobolone, wo mana deli ee nolone debeiso. Esino wo mana deli ee nali odoo egee bia olo wediaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Esino wo hagee Kei mi maga simi. Esiga wo hagee naga odoo egee bia wedileime. ");
INSERT INTO kkc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kei mi ma dokodooga simi gie badeli teneli wo ee aso. Esiga edebeeyo wo hagee naga, yo badoboso kookaiyo gie badalaiso. Osoloso wo ayo tenelai egee molo ee mo hwei, mi odoo oso gie badeli talame.” ");
INSERT INTO kkc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Eseme Yu odooso to hagee duloso dima kulodu to boowoolone egeesee takaso, “Odoo hagoso o hwei iyo nalame kasee tenelaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo taka. Niyo Odoo Holo mo sawo sabolo osoloso mo hwei sabolo nelega poogooga, niba gie badeli talaime. ");
INSERT INTO kkc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Esiga mo hwei sabolo osoloso mo sawo sabolo nali odoo, diba badoboso kookaiyo gie badeli talaiso. Osoloso hamameedee biame mapoo ayo diba wedia maga see hogogadileiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mo hwei sabolo osoloso mo sawo ee tei nei dee oso. ");
INSERT INTO kkc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Egeesi ma kulodu mo hwei sabolo osoloso mo sawo sabolo nali odoo oso abolo hedebe doloso ka badoso. Osoloso anosee dibolo hodobo badoso. ");
INSERT INTO kkc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Esiga Ma a diye di oso gie badoga anosee ka badoso. Esiga mo hwei sabolo osoloso mo sawo sabolo nali odoo oso amaga gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Egeesi ma kulodu a nibada amawe diayo namo silee wo egeesinee. Bei, diayo wo egee ne oso dimapoo gie badeli tenele. Esino a Kei mi ma dokodooga simi wo tei aso. Esiga edebeeyo wo hagee naga, diba badoboso kookaiyo gie badalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuye Kapeniyum mapoo howo gisili moso ma kulodu odoo susuga mapoo eligilone goo susuga egeesee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Esino Yesu yo deedee silesibili odoo oso Yesuye eligi goo ee duloso egeesee takaso, “Eligi goo hagee diya koudadoo. Odoo agayo to hagee talai ka teibayo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Egeesi ma kulodu Yesu yo deedee silesibili odoo oso dima kulodu to boowoogamelee ee gooleedoloso dimapoo egeesee takaso, “Goo ayo hagee takoo oso nimapoo dala teneedo? ");
INSERT INTO kkc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Goo hagoso nimapoo dala teneega, niyo Odoo Holo ayo see Kei mi ma dokodoo wedi pala ogoloso kasee goolaisomo? ");
INSERT INTO kkc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dio Tei oso gie badeli ka tenemoloso. Esino suso goomoga goo oso gie badeli koo tenemoloso. To ayo nimapoo taka ee Dio Tei maga simi, esiga to oso gie badeli ka tenemoloso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yesu yo daga malalo olo gooleedooso, yimapoo tei telega pagalai odoo ee. Osoloso yo toloso ha teli odoo mapoo tiasalai odoo onosee yo olo gooleedooso. Esiga yayo dimapoo egeesee takaso, “Odoo abo nima kulodu egee do amapoo tei koo toso. ");
INSERT INTO kkc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Goo egeesi maga ayo to hagee nimapoo olo takaso, ‘Edebeeyo eyo goolee amapoo sibileime. Esino Maye amapoo sibilame kitulugu tenee odoo oso amapoo sibileiso,’ dee takooso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesuye to hagee taka koodobume, yo deedee silesibili odoo aboso yo deedee silei gowoolone yo poogoo diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Eseme Yesuye o hamamee dili odoo 12 mapoo egeesee takaso, “Niba nosee a poogoo dilei goomogosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Eseme Saimon-Pitaye nei egeesee takaso, “Lodee, iba odoo ogu mapoo dileiyo? Hedebe nee to oso gie badeli ka tenemoloso. ");
INSERT INTO kkc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Esiga iyo namapoo tei toso. Osoloso iba gooleedooso, no tei odoo Godee maga simi oso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo odoo 12 niba olo hudi magooso. Esino nima kulodu odoo hedebe Saiteneeyo tou teli odoo badoso.” ");
INSERT INTO kkc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Esiga Yesuye to hageesee taka egee, Saimon-Iskaliyot eyo owolo Yudas eyo goo ee taka. Bei, Yudas yinosee Yesuwo hamamee dili odoo 12 ee ma kulodu badeli. Esino yayo hamamee Yesu ha teli odoo mapoo tiasalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Esiga goo hagoso dileso koodobume, Yesu yo Yudiya mi mapoo silei gowoolone, see Gelili mi mapoo dileso siliso. Bei, Yudiya mi omapoo Yu odoo dia wiligi odoo oso Yesu wooloomalame eli esiamo siliso. ");
INSERT INTO kkc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Osoloso Yu odoo dia Waseme moso maga wo nalai biame olo koola tabaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eseme Yesuwo omolo dio oso yimapoo egeesee takaso, “No mi hagee poogoloso see Yudiya mi mapoo di, no deedee silesibili odoo oso nayo goo toowa opusomo di moodooga ee agalame. ");
INSERT INTO kkc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bei, edebeeyo o goo ee odoo susuga oso gooleedalai goomogoga, yo goo mada koo moodoomo siliya. Esiga no goo toowa opusomo di medee woola moodoomo sile, odoo susuga oso nee goo ee ogoloso gooleedalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Goo egeesi ma kulodu Yesuwo omolo dio oso yimapoo tei telega debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo Yelusalem mapoo dilei biame koo tugodo. Esino niba dilei goomogoga, wulo biame hee mapoo dilei tekepo. ");
INSERT INTO kkc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mi odoo oso niba hegilei eyo bei me. Esino diayo a hegiliso. Bei, ayo dia goo tokenee ee woola yilige buguga. ");
INSERT INTO kkc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Esiga niba wo ne mapoo diyadee. Esino a dileime. Bei, mo biame tugodelega.” ");
INSERT INTO kkc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesuye egeesee takoloso Gelili mi mapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesuwo omolo dio oso Waseme moso maga wo nalame Yelusalem mapoo paladee neme, Yesu yinosee hamamee palaso. Esino odoo howo woola palai gowoolone mada palaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Osoloso wo ne ee ma kulodu Yu odoo dia wiligi odoo oso Yesu esilone egeesee takaso, “Yesu kasomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eseme odoo mooloogoodoo toowa oso mada dima kulodu Yesuwo goo maga mada takomo silesibulone, odoo aboso egeesee takaso, “Yesu odoo tekepo,” dee takaso. Esino odoo aboso takolone, “Haye, yo wulo gamenee goo maga odoo peegoo ka gilimado du,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Esino Yu odoo dia wiligi odoo bolo obulone, diayo Yesuwo goo maga to woola takele. ");
INSERT INTO kkc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Osoloso wo ne olo domo taba mapoo, Yesuye tei moso mapoo peleso Godeeyo to eligilame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Eseme Yu odoo oso yayo eligi goo ee duloso diya howoogadolone diayo egeesee takaso, “Odoo hagee kasi maga Godeeyo to susuga ka gooleedoowo? Bei, yo Godeeyo to gooleedeli sukulu mapoo dile,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo hagee eligi wulo mawo goolee koo eligili. Esino a diye di Godee maga simi goo ee eligili. ");
INSERT INTO kkc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Esiga Godeeye goomoga goo ee talame goomoga odoo oso ayo eligi goo hagee tei Godee maga simidoo doloso gooleedalaiso. Osoloso ayo mawo goolee koo eligili goo onosee gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Edebeeyo eyo goolee eligimo siloga, yo o hu eyo nediliyo doko topoloso. Esino edebeeyo yo diye di odoo oso goolee ee eligimo siloga, yo diye di odoo eyo hu ee doko topoloso. Esiga yo tei goo takeli, osoloso yo gamenee koo takeli. ");
INSERT INTO kkc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseseeye nimapoo tei magoo hogugu ee teneeso. Esino niba susuga tei magoo hagee koo dedeli. Esiga kasi maga niyo a wooloomalame ka sala?” ");
INSERT INTO kkc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eseme odoo mooloogoodoo oso nei yimapoo egeesee takaso, “Bo holoso nama kulodu palaga, no to egeesee ka takoo. Iba no wooloomalame koo seeso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Esino Yesuye dimapoo nei egeesee takaso, “Niyo hasali biame mapoo ayo goo toowa opusomo di hedebe moodoo ogoloso niba susuga dio diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Egeesi ma kulodu niba nosee Moseseeye tei magoo ee dodolone niyo hasali biame mapoo tou teliso. Bei, niyo Moseseeye tei magoo ee dodolone holope kolo kweliso. Esino holope kolo koolame tei magoo hagee Moseseeye magele. Esino nibada amawe diayo ka magoo. ");
INSERT INTO kkc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Esiga Moseseeye tei magoo gababiyaga hasali biame mapoo niyo holope kolo kweliso. Esino niyo kaseega ayo niyo hasali biame mapoo odoo paiye tekepo moodooga niyo amapoo ka komonowala? ");
INSERT INTO kkc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Esiga niyo wulo edebeeyo o suso goo moodoo ee ogoloso saga na midi. Esino tei goodee maga niyo o goo ka midi.” ");
INSERT INTO kkc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Osoloso Yesuye to taka hagee duloso, Yelusalem odoo aboso dieso nediliyo egeesee takaso, “Odoo hagee ibada wiligi odoo oso wooloomalaigo dee takemeni osobele? ");
INSERT INTO kkc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Niba ege, yayo odoo susuga eyo howo woola eligime, odoo heeso yimapoo to hee koo takooso. Esiga ibada wiligi odoo oso goolee yo tei Keliso goolee malaiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Esiga Kelisoye siboga, mi yayo simi ee odoo heeso gooleedalaime. Esino mi Yesuye simi ee iba gooleedooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eseme Yesuye tei moso mapoo osee eligilone toso neligidi egeesee takaso, “O. Tei takoo. Mo goo sabolo osoloso ayo simi mi sabolo niba olo gooleedoodoo. Esino a mawo goolee maga sibileso hamapoo koo badoso. Haye, a diye di odoo eyo goo ee tei, esino niba yo gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Esino hebebe ayo yo ka gooleedoo. Bei, a yimaga simi osoloso yayo a nimapoo sibeye diso.” ");
INSERT INTO kkc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Eseme biame omapoo wiligi odoo diba goomogaso, Yesu omapoo talame. Esino odoo heeso yimapoo goo hee moodele. Bei, o biame tugodelega. ");
INSERT INTO kkc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Esino odoo mooloogoodoo ee ma kulodu odoo aboso Yesu mapoo tei tolone egeesee takaso, “Odoo heeso sibileso goo toowa opusomo di moodooga, goo toowa opusomo di Yesuye moodoo hagee dagadileime. Esiga Yesu hagee tei iyo hagee bamolo Keliso oso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Esiga odoo mooloogoodoo oso Yesuwo goo maga taka ee Pelisi odoo oso duso. Esiga Pelisi odoo egee bia sabolo osoloso tei moso wiligi odoo tebisa oso tei moso gidebeli odoo diye diso, diayo dileso Yesu talame. ");
INSERT INTO kkc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuye see odoo mapoo takolone egeesee takaso, “A biame deiyepo hamapoo nibolo hodobo badalaiso. Osoloso a diye di odoo mapoo see wedi dileiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Niyo a esileiso. Esino niyo a agalaime. Bei, ayo badalai mi omapoo sibilei niba tebileime,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Eseme Yu odooso dieso nediliyo dima kulodu egeesee takaga meleeso, “Yo kamapoo duga iyo yo egelega ka pagalaiyo? Yo ibada odoo abo Guliki odooso debeli mi mapoo egee do mapoo dileso Guliki odoo mapoo Godeeyo to eligilame ka sabele. ");
INSERT INTO kkc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Osoloso yayo imapoo takolone, iyo yo esileiso, esino iyo yo agalaime. Osoloso, yayo badalai mi omapoo sibilei iba tebileime, dee taka eyo bei ogoobo?” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Esiga Waseme moso maga wo ne hamameedee biame egee goo toowa. Osoloso biame omapoo Yesuye toboloso to neligidi egeesee takaso, “Odoo agayo howo ka na poogoosomo, yo amapoo howo nala sibeye dee. ");
INSERT INTO kkc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Osoloso Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Edebeeyo amapoo tei toga, gie badeli teneli howo oso yima kuloduga gasibileiso.’ ” ");
INSERT INTO kkc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Esiga Yesuye goo taka hagee, yimapoo tei too odoo mapoo Dio Tei tenelai goo ee takolone egeesee ka taka. Esino epedee omapoo Dio Tei dimapoo tenele. Bei, Yesu yo Ama mapoo pelega. ");
INSERT INTO kkc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Esiga odoo mooloogoodoo ee ma kuloduga odoo aboso Yesuye taka to ee duloso egeesee takaso, “Odoo hagee tei Godee maga to toloso kokodo takomo sili odoo sibabeleso iyo bamelee osodoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Eseme odoo aboso egeesee takaso, “Yo Keliso,” dee takemeleeso. Esino aboso egeesee takaso, “Haye, yo Kelisonee. Bei, Keliso yo Gelili mi maga sibileime. ");
INSERT INTO kkc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bei, Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Keliso yo Deibidiyo amawe dio dima kuloduga sibileiso. Osoloso yo Deibidiye badebei mi Betilihem mapoo soomagalaiso,’ diso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Egeeseelone Yesuwo goo maga odoo abo puloso debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Osoloso odoo aboso Yesu talame goomogaso. Esino odoo heeso yimapoo goo hee moodele. ");
INSERT INTO kkc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eseme epedee omapoo tei moso gidebeli odoo oso see mosoowe wedi simi ogoloso, tei moso wiligi odoo tebisa sabolo, osoloso Pelisi odoo oso dimapoo egeesee takaso, “Bei kaseme niyo Yesu hamapoo ido sibilega ka poogoowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eseme diayo nei egeesee takaso, “Daga odoo heeso to Yesuye keli egeesee koo keli,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eseme Pelisi odooso nei dimapoo egeesee takaso, “Niba nosee yayo eligi goo oso peegoo gilimado disomo? ");
INSERT INTO kkc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Esino Pelisi odoo ima kulodu osoloso ibada wiligi odoo dima kulodu odoo heeso yimapoo tei too niyo egeisomo? Haye. ");
INSERT INTO kkc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Esino odoo mooloogoodoo hagee ma kulodu, odoo aboso Moseseeye tei magoo goo ee kibiya gooleedelega tei tooso. Esiga diba Godeeyo kamana ma hemidu doso.” ");
INSERT INTO kkc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Esiga dima kulodu Pelisi odoo hee badebeiso, o hu Nikodimas. Daga yayo gesi Yesu agalame diso. Esiga yayo dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Moseseeye tei magoo ee dodolone iyo daga odoo o goo midilega, wulo o tokenee eyo nei tenelai ee tekeponee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eseme Pelisi odoo abo sabolo osoloso wiligi odoo tebisa oso yimapoo egeesee takaso, “Nonosee Gelili odoowo? No Godeeyo to booka mapoo hogugu ee medee hesigaloso gooleede. Bei, Godeeyo toso egeesee takooso, Godee maga to toloso kokodo takomo sili odoo ee Gelili mi maga sibileime.”  ");
INSERT INTO kkc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Osoloso to kesamelee omapoo koodobuloso odoo susuga dia mosopoo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Esino Yesu Olipi mubi ma dokodoo palaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Osoloso gesikolodee Yesu yo tei moso mapoo wedi sibileso badoboome, odoo susuga oso yimapoo simiso. Eseme yayo omapoo badolone odoo eligimeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Eseme domo omapoo tei eligili odoo sabolo, osoloso Pelisi odoo oso kooka sobo heeso adaba giso goo heli too ee ogoloso, diayo yo ido sibileso odoo howo woola tebediso. ");
INSERT INTO kkc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Eseme diayo Yesu mapoo egeesee takaso, “Eligili odoo, kooka sobo hagoso adaba giso goo heli tomo sileeme ogoloso yo hamapoo ka ido simi. ");
INSERT INTO kkc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseseeye tei magoo hogugu oso egeesee takaso, ‘Sobo heeso goo hageesee toga, yo yoso enigameleso wooloome,’ dee takooso. Esiga nayo imapoo takee, iyo sobo hamapoo goo kasee moodoolaisomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Goo egeesi maga Yesuye to tokenee takooga ka midilame, diayo yo kukolo egeiso. Esino Yesu miyomoo gauwuloso dee woluguso mi mapoo hogugu meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Esino diayo yimapoo osee woosa molome, Yesu yo toboloso dimapoo egeesee takaso, “Esiga nima kulodu odoo hee goo tokenee koo teli daga, odoo ogoso malalo sobo omapoo yoso ka enige,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Osoloso Yesu see tobu miyomoo gauwuloso dee woluguso mi mapoo hogugu meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eseme odoo susuga sobo egee ido simi oso Yesuwo to duloso obulone, daga adaga dimaga bei mooloogooloso hedebe du, hedebe du diso. Osoloso odoo susuga olo poogoo dulone, hedebe Yesu dio sobo egee dio omapoo poogooso. ");
INSERT INTO kkc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Eseme Yesuye toboloso sobo mapoo egeesee takaso, “Sobo, no goweli odoo hamapoo debei ee kasomo? Odoo hee nee tokenee eyo nei namapoo dala tenelai hedebe badolo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Eseme sobo ogoso nei Yesu mapoo egeesee takaso, “Wiligi odoo, haye, odoo hee medoo,” diso. Eseme Yesuye yimapoo egeesee takaso, “Anosee nee tokenee eyo nei ayo namapoo dala tenelaime. Esiga no di. Esino no tokenee see tobu na te,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Eseme Yesuye odoo mooloogoodoo mapoo see egeesee takaso, “Mipoo hageeyo gadeebugu ee aso. Esiga a dodomo sili odoo yo neliga ma kulodu sileime. Esino yo gie badeli talai eligili gadeebugu ee talaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Eseme odoo mooloogoodoo ee ma kuloduga Pelisi odooso nei egeesee takaso, “No wulo nee goo ee takomolo. Esiga nayo egee takoo goo ee iba tei koo toso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Eseme Yesuye nei dimapoo egeesee takaso, “O. Tei takoo. A mo goo ee takooso. Esino ayo hagee takoo tei goo taka. Bei, ayo simi mi ee a gooleedoo. Osoloso ayo dileso badalai mi onosee a gooleedoo. Esino ayo simi mi sabolo, osoloso ayo dileso badalai mi ee, niba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Esiga mi odoo dia goo ee dodolone, niyo emegei dia goo ee midiliso. Esino ayo emegei dia goo ee koo midili. ");
INSERT INTO kkc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Esino ayo emegei dia goo midilei gooleega, ayo medee tei goo maga dia goo midileiso. Bei, ayo mobusomo koo midili. Esino mo Ma a diye di sabolo goo ka midili. ");
INSERT INTO kkc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Esiga Moseseeye tei magoo hogugu oso egeesee takooso, ‘Goo hedebe mapoo odoo bakadio oso to hedebe onosee takooga, diayo egee takoo ee tei goo takooso,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Esiga anosee tei magoo egee dodolone mawo nediliyo mo goo maga tei goo takooso. Osoloso mo Ma a diye di oso mo goo maga tei goo takeliso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eseme Pelisi odooso nei yimapoo egeesee takaso, “Nama kasomo?” diso. Esino Yesuye dimapoo egeesee takaso, “Mo Ma sabolo osoloso a, niba gooleedele. Niba a gooleedoo diepi, mo Ma nosee niba gooleedeliyo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuye tei moso ma kulodu emegei di molee tenee mageli koola omapoo tobodulone, goo susuga hagee eligimeleeso. Esino odoo heeso yo tele. Bei, o biame tugodelega. ");
INSERT INTO kkc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Eseme Yesuye see dimapoo egeesee takaso, “Ayo peegoo duga, niyo a esileiso. Esino niba goo tokenee ma kulodu dobolone, nibada goo tokenee hapelega poogoloso wedileiso. Osoloso ayo badalai mi omapoo sibilei, niba tebileime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Esino Yu odoo oso egeesee takaso, “Bei kasi maga Yesuye takolone, yayo badalai mi omapoo sibilei, iba tebileime, dee ka takayo? Iba gooleedele, Yesu eyo nediliyo wooloomalame ka sabele,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Eseme Yesuye dia to duloso nei egeesee takaso, “Niba mipoo hamapoo debeli odoo. Esino a Kei mi ma dokodooga simi. Esiga niba mi odoo. Esino a mi odoonee. ");
INSERT INTO kkc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Goo egeesi maga ayo nimapoo takolone, nibada goo tokenee hapelega poogoloso wedileiso, dee ka taka. Bei, ayo mo goo maga taka mapoo niyo tei telega poogooga, niba nibada goo tokenee hapelega poogoloso wedileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eseme diayo nei egeesee takaso, “No odoo ogumo?” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo eligi bei mooloogooloso abaga simino epedee hamapoo mo goo nimapoo olo eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Esiga ayo nimapoo tokenee odoo dee takalai goo bei moloso. Esino a diye di odoo oso takeme du goo ono ayo odoo mapoo ka takomo sili. Bei, yo tei goo takeli.” ");
INSERT INTO kkc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Egeesi ma kulodu Yesuye amamo goo takano, Yu odooso duloso medee kibiya gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eseme Yesuye see dimapoo egeesee takaso, “Niyo Odoo Holo a toloso dokodoo poudoga, omapoo niyo mo goo ee medee kibiya gooleedalaiso. Osoloso ayo mawo goomoga goo koo tomo sili goo onosee niba gooleedalaiso. Bei, mo Maye amapoo taka goo hedebe ee ayo ka eligimo sili. ");
INSERT INTO kkc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Esiga a diye di odoo ee abolo hodobo badoso. Yo a koo poogoo dili. Bei, ayo hedebe yo goomogalai goo ono tomo sili.” ");
INSERT INTO kkc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Esiga Yesuye goo hagee takeme, odoo susuga yimapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eseme Yesuye Yu odoo yimapoo tei telaga odoo mapoo egeesee takaso, “Niyo ayo eligi goo hamapoo medee kibiya kookoodoloso dodomo silesiboga, niba tei mo hamamee dili odoo dalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Esiga niba tei goo ee gooleedalaiso. Osoloso tei goo oso niba nei mauwe tou teli goo maga peegoo gilimado dileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eseme diayo Yesu mapoo egeesee takaso, “Eibalahameeyo amawe dio ibaso. Esiga iba odoo heeso wiligi doloso badoboome, hegi goo ma kulodu nei mauwe o tou tolone ka debele. Bei kasi maga nayo imapoo takolone, ‘hegi goo ma kuloduga puo pagalaiso,’ dee ka takala?” ");
INSERT INTO kkc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo taka. Edebeeyo goo tokenee tolone badoga, yo goo tokeneeso wiligi doloso ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Esiga nei mauwe tou teli odoo ee o wiligi odoo eyo soosoo sabolo kookaiyo osee koo badeli. Esino owoloye o soosoo sabolo kookaiyo osee badeliso. ");
INSERT INTO kkc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Esiga Owolo ayo niba tokenee goo ma kuloduga puo poogooga, niba tokenee goo ma kuloduga tei olo puo pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A gooleedooso, niba Eibalahameeyo amawe dio. Esino niyo a wooloomalame ka goomogoso. Bei, ayo eligi goo ee nima kulodu malai, niba koo goomogoso. ");
INSERT INTO kkc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mo Maye goo amapoo eligi ee ayo nimapoo ka takomo siloso. Esino niba nosee nibada amaye takeme du goo ee tomo silesiboso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eseme diayo nei Yesu mapoo egeesee takaso, “Ibada ama ee Eibalaham,” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Niba tei Eibalahameeyo owolo dio diepi, niyo goo Eibalahameeye moodoo egeesee moodoolone debeli. ");
INSERT INTO kkc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Esino tei goo Godeeye amapoo tenee ee ayo takomo sileeme, niyo a wooloomalame seeso. Esino Eibalaham goo egeesi moodele. ");
INSERT INTO kkc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Esiga goo nibada amaye moodoo hedebe onosee niyo ka moodoomo siloso.” Eseme diayo Yesu mapoo egeesee takaso, “Iba giba holonee. Esino ibada Amadee ee hedebe Godeeso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Eseme Yesuye nei dimapoo egeesee takaso, “Godee tei nibada Ama diepi, a niyo diya goolee sabolo debeliyo. Bei, a Godee maga sibileso hamapoo ka badoso. Yayo a diye diso. Esiga a mawo goolee sibileso hamapoo koo badoso. ");
INSERT INTO kkc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Niba kasi maga goo ayo taka ee duloso gooleedelega ka dabala? Niba goo ayo eligi ee dulei gowoolone ka seeso. ");
INSERT INTO kkc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Esiga nibada ama ee Saiten. Esiga niyo o goo ogoloso yayo goomoga goo ee talame diya goomegeliso. Bei, bei mooloogoo biame maga epedee hamapoo sibulone yo odoo wooloomali doloso badebeiso. Osoloso yo gamenee takeli odoo. Bei, yima kulodu tei goo takeli me. Osoloso yayo gamenee takooga, yayo wulo o goo ee takeli. Bei, yo gamenee takeli odoo. Osoloso gamenee takeli eyo bei yoso. ");
INSERT INTO kkc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Esino ayo nimapoo tei goo takeliso. Goo egeesi maga niyo mo to mapoo tei koo teli. ");
INSERT INTO kkc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Esiga goo tokenee ayo moodoo ee niyo egeisomo? Haye, me. Ayo tei goo takomo silino, niyo kaseega mo to mapoo tei tele ka pagala? ");
INSERT INTO kkc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godeeyo odoo oso o to duloso omapoo mesimo silesibiliso. Esino niba Godeeyo odoonee. Esiga goo egeesi maga niba o to duloso omapoo mesilega ka poogooso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Eseme Yu odooso nei Yesu mapoo egeesee takaso, “Iyo namapoo takolone no Samaliya odoo bo holo pala, dee takemeni ee tei taka.” ");
INSERT INTO kkc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Eseme Yesuye nei dimapoo egeesee takaso, “Mo kulodu bo holo koo badoso. Esino ayo mo Mayo hu dokodoo poudiliso. Esino niyo abolo takolone mo hu dokodoo poudilega pegeliso. ");
INSERT INTO kkc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Esiga edebeeyo mo hu dokodoo poudalame ayo goo hagee koo tomo siloso. Esino odoo heeso diya goomogoso, edebeeyo mo hu dokodoo poudalame. Yo goo midili odoo. ");
INSERT INTO kkc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Esiga ayo nimapoo tei goo taka. Odoo agayo mo to mapoo mesimo siloga, yo talaime.” ");
INSERT INTO kkc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Eseme Yu odooso Yesu mapoo egeesee takaso, “Iba epedee olo gooleedo, no tei nee kulodu bo holo bado. Bei, nayo daga egeesee takaso, ‘odoo agayo nee to mapoo mesimo siloga, yo talaime,’ diso. Esino ibada amawe Eibalaham dio osoloso Godee maga to toloso kokodo takomo silesibili odoo diba olo wediaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Esiga ibada amawe Eibalaham ee nayo dagadi doloso ka takala? Bei, ibada amawe Eibalaham olo taso, osoloso Godee maga to toloso kokodo takomo silesibili odoo onosee olo wediaso. Egeesi ma kulodu nayo goolee no odoo ogu gweliyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo goo tomo sili hagee mo hu dokodoo poudalame ka tomo sili diepi, goo hagee bei mauwe meliyo. Esino mo Maye mo hu dokodoo ka poudomoloso. Yo niyo takolone nibada Godee deliso. ");
INSERT INTO kkc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Esino niba yo gooleedele. Esino ayo yo ka gooleedoo. Esino ayo takolone, ‘a o goo gooleedele,’ dee takeli diepi, a gamenee takeli odoo niba egeesi masi badeliyo. Esino a o goo gooleedoo, osoloso a to yayo taka mapoo mesimo siliso. ");
INSERT INTO kkc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Esiga nibada amawe Eibalaham goomogaso, ayo mipoo hamapoo simi ee agalame. Osoloso a olo sibume, yayo ogoloso diya goomogaso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Eseme Yu odooso nei yimapoo egeesee takaso, “No dugo 50 tugodele. Esino nayo takolone, no Eibalaham olo egeiso, dee ka takala?” ");
INSERT INTO kkc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo tei goo nimapoo ka taka. Bei, Eibalaham soomagelega badoboome, daga a olo badebeiso.” ");
INSERT INTO kkc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesuye egeesee taka duloso diayo komonolone, yo toloso enigilame sino poogooso. Eseme Yesu mada wua moloso tei moso ma kuloduga peegoo diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Esiga Yesu yo dulone odoo hee egeiso. Odoo egee oweeye soomagolone howo neliga o egeesi soomagoona. ");
INSERT INTO kkc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eseme Yesu o hamamee dili odoo oso Yesu mapoo egeesee takaso, “Eligili odoo, odoo agamo goo tokenee oso yo howo neliga egeesee ka soomagoowo? O goo tokenee oso egeesee ka soomagoowo, o owee dio ama dio eyo goo tokenee maga howo neliga egeesee ka soomagoowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eseme Yesuye egeesee takaso, “Odoo howo neliga hagee o goo tokenee oso egeesee ka sele, osoloso ama dio owee dio eyo goo tokenee oso egeesee ka sele. Esino odoo howo neliga soomagoo goo eyo bei ee egeesi moloso. Godeeye kitulugu goo ee yimaga woola yilige bigilame, yo howo neliga egeesee ka soomagoo. ");
INSERT INTO kkc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Esiga biame osee mologa, iba odoo a diye di eyo tou ee tomo. Esino gesi olo siboga, odoo heeso tou hee talai tebileime. ");
INSERT INTO kkc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Esiga ayo mipoo hamapoo osee hagee bado oso mipoo hamapoo keme masi gadeebugu ka moloso.” ");
INSERT INTO kkc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu to hagee takoloso mi mapoo magawo pagamagoloso, deeso deeseegoloso omapoo beesee doloso odoo howo neliga eyo howo mapoo hediso. ");
INSERT INTO kkc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Osoloso odoo omapoo egeesee takaso, “No Sailowam howo ou mapoo nee howo hapalame di,” diso. Esiga Sailowam hu eyo bei ee diye dolone takeli. Eseme odoo egee dileso o howo hapoome tekepo paso. Eseme yo see wedi sibulone medee ogomo simiso. ");
INSERT INTO kkc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Egeesi ma kulodu odoo koola mapoo debeli sabolo osoloso odoo aboso yo daga eli domopoo bi howolone badoboome egei oso egeesee takaso, “Odoo hagee eli palaga bi howolone badoboomeni osobele,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eseme odoo aboso egeesee takaso, “O. Odoo hedebe ogoso,” dee takemeleeso. Esino odoo aboso egeesee takaso, “Haye, odoo ogosonee, odoo hee yo masi molodoo,” dee takemeleeso. Eseme odoo eyo egeesee takaso, “Odoo egee tei aso,” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eseme diayo yimapoo egeesee takaso, “Nee howo kaseme tekepo ka payo?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Eseme yayo egeesee takaso, “Edebeeyo takolone Yesu deli oso mi mapoo magawo pagamagoloso, deeso deeseegoloso omapoo beesee doloso mo howo mapoo basago hediloso amapoo egeesee taka, a Sailowam howo ou mapoo mo howo hapalame diyena. Eseme a dileso mo howo keesee hapoono tekepo ka poowa,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eseme diayo yimapoo egeesee takaso, “Odoo egee kasomo?” Eseme yayo dimapoo egeesee takaso, “A gooleedele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yesuye odoo howo neliga tekepo pa hagee, Yu odooso hasali biame mapoo tekepo ka pa. Esiga odoo aboso odoo howo neliga Yesuye tekepo pa ee Pelisi odoo mapoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eseme Pelisi odooso yimapoo egeesee takaso, “Nee howo kaseme tekepo ka payo?” diso. Eseme nei yayo dimapoo egeesee takaso, “Yesuye basago beesee doloso mo howo mapoo hedime, mo howo howomoo keesee hapoono, see tekepo ka pa,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Egeesee taka duloso Pelisi odoo aboso egeesee takaso, “Yesu hagee Godee maga sibile. Bei, yo Godee maga simi diepi, ibada hasali biame mapoo tou tolone tei magoo ee gababile pegeliyo,” diso. Esino odoo aboso egeesee takaso, “Kasee maga goo tokenee teli odoo oso goo toowa opusomo di hageesee ka moodoomo silosomo?” dee takemeleeso. Goo egeesi maga Pelisi odooso Yesuwo goo maga dieso dima kulodu domo pi meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Osoloso Pelisi odooso odoo howo neliga tekepo pa mapoo see tobu egeesee woosaso, “Odoo nee howo tekepo pa ee odoo ogu gooleesomo?” diso. Eseme odoo ogoso nei egeesee takaso, “Ayo goolee, yo Godee maga to toloso kokodo takomo sili odoo gooleeso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Esino odoo hagee daga tei howo noluguloso badebei goo omapoo Yu odoo dia wiligi odoo diba tei dele. Esiga tei goo beleso gooleedalame, diayo owee dio ama dio idooso. ");
INSERT INTO kkc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Osoloso diba olo sibileso tebisamolome, wiligi odooso dimapoo egeesee takaso, “Niyo takolone, nowolo howo neliga osee soomagoogo, dee takemeni ee hagosomo? Esiga kasi maga epedee o howo olo tekepo poloso ka badosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eseme owee dio ama dio oso nei egeesee takaso, “O. Hagee tei ibada owolo howo neliga osee soomagoo oso, goo ee iba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Esino o howo kasee tekepo payo? Iba gooleedele. Osoloso odoo yo tekepo pa onosee, iba gooleedele. Esiga niso ibada owolo mapoo woosalo ege. Bei, yo olo kauwudooga, yayo o goo ee nimapoo takalai teiba,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Diayo dia wiligi odoo tebisa ogoloso obulone wulo dimapoo to hageesee ka taka. Bei, Yu odoo dia wiligi odoo oso goomoga goo hageesee olo magooso, “Edebeeyo takolone Yesu ee Keliso dee takooga, yo Yu odoo dia howo gisili moso ma kuloduga hu taloso peegoo magoo damalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Goo egeesi maga owee dio ama dio oso takolone, “Yo olo kauwudooga, yayo o goo ee nimapoo takalai teiba,” dee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Esiga Yu odoo dia wiligi odoo oso see tobu odoo howo neliga tekepo pa ee idoloso yimapoo egeesee takaso, “Godeeyo howo woola nayo imapoo tei goo takee. Bei, odoo no tekepo pa egee goo tokenee teli odoo, iba gooleedoo.” ");
INSERT INTO kkc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eseme odoo ogoso nei egeesee takaso, “A gooleedele, yo goo tokenee teli odoo bele, o, goo tekepo teli odoowo. Egeesi ma kulodu goo hagee a gooleedoo, a daga howo neliga badebeiso. Esino epedee hamapoo mo howo olo tekepo poloso see ka ogomo siloso.” ");
INSERT INTO kkc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eseme diayo nei yimapoo egeesee takaso, “Odoo hagoso namapoo kasee moodoome, nee howo see tekepo ka payo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eseme odoo ogoso nei egeesee takaso, “Ayo nimapoo goo susuga olo takaso. Esino niyo mo to medee dule. Esiga niyo bei kasalame goo egee see dulame ka sala? Esiga niba nosee yayo di hamamee dilei goomogolone ka sala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eseme diayo yo manolone yimapoo egeesee takaso, “No o hamamee dili odoo. Esino iba Moseseeyo hamamee dili odoo. ");
INSERT INTO kkc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bei, Godeeye Moses mapoo to taka ee, iba gooleedooso. Esino odoo no tekepo pa ee, iba gooleedele.” ");
INSERT INTO kkc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eseme odoo ogoso nei egeesee takaso, “Goo hagee kaseeyo? Yayo mo howo tekepo paso. Esino niba o goo gooleedelega ka dosomo? ");
INSERT INTO kkc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bei, iba gooleedoo, Godee yo goo tokenee teli odoo eyo to koo duli. Esino yayo o to mapoo mesiloso yayo goomoga goo tomo silesibili odoo eyo to ee duli. ");
INSERT INTO kkc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Esiga mipoo hagee bei mooloogoo maga simino epedee hamapoo, odoo heeso odoo howo neliga soomagoo ee tekepo paso dee taka goo ee iba dule. ");
INSERT INTO kkc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Esino Yesuye mo howo tekepo ka pa. Esiga yo Godee maga sibile diepi, yayo goo hee moodoolai tebile pegeliyo.” ");
INSERT INTO kkc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eseme diayo gowoolone nei yimapoo egeesee takaso, “No gie daga soomagoo biame maga simino epedee hamapoo, no goo tokenee teli odoo doloso badebeiso. Esiga nayo kasalame imapoo goo eligilame ka sala?” dee takaso. Eseme diayo yo toloso howo gisili moso ma kuloduga peegoo ido diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Esino Yu odoo dia wiligi odoo tebisa oso odoo howo neliga tekepo pa ee howo gisili moso maga peegoo ido di goo ee Yesu yo duso. Esiga yayo odoo egee ogoloso yimapoo egeesee takaso, “No Odoo Holo mapoo tei tosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eseme odoo ogoso nei egeesee takaso, “Odoo Holo ee odoo ogumo? Amapoo takee, eseega ayo yimapoo tei ka talaiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eseme Yesuye yimapoo egeesee takaso, “No yo olo egeiso. Esiga yayo epedee nobolo to egee komoloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eseme odoo ogoso nei egeesee takaso, “Lodee, a namapoo tei toso.” Osoloso yo gasuwoloso badolone Yesuwo hu dokodoo poudooso. ");
INSERT INTO kkc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Eseme Yesuye egeesee takaso, “Ayo mipoo hamapoo goo midilame simiso. Goo ee odoo howo neliga oso see medee agalame, osoloso odoo howo tekepo ee see howo neligalame,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eseme Pelisi odoo abo koola omapoo tebisamelee oso Yesuye to egeesee taka ee duloso yimapoo egeesee takaso, “Nayo goolee, iba howo neliga goolone, egeesee ka takala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Eseme Yesuye nei dimapoo egeesee takaso, “Niba howo neliga odoo diepi, niba goo tokenee teli odoo dele pegeliyo. Esino niyo takolone, niba howo neliga odoonee dee egee takoo oso niba goo tokenee teli odoo doloso osee ka doso.” ");
INSERT INTO kkc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuye see egeesee takaso, “Ayo nimapoo taka. Edebeeyo sipi be beelee ma kulodu osulu maga gadilega, see eli hee maga sibileso kulodu gaduga, yo heli teli odooso. ");
INSERT INTO kkc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Esino osulu maga gadili odoo ee tei sipi be bali odoo oso. ");
INSERT INTO kkc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Esiga osulu gibadeli odoo oso osulu yadeliso, sipi be bali odoo oso kulodu gadilame. Osoloso sipi beso dia bali odoo eyo to duliso. Osoloso dia bali odooso dia hu hesigaloso, beelee ma kuloduga peegoo gilimado diliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Osoloso yayo o sipi be susuga peegoo gilimado dileso, daga yayo malalo duga, diba yima hamamee diliso. Bei, diba o to gooleedooga. ");
INSERT INTO kkc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Esino diba odoo heeso di hamamee koo dili. Esino ee ma kulodu odoo heeso diba sibilame haga, diayo yimaga kukulo dileiso. Bei, diba odoo egeeyo to gooleedelega.” ");
INSERT INTO kkc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuye wudu takolone odoo mapoo hageesee eligiso. Esino wudu taka goo eyo bei ee diba medee kibiya gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Osoloso Yesuye dimapoo see egeesee takaso, “Ayo nimapoo taka. Sipi be beelee eyo osulu ee aso. ");
INSERT INTO kkc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Esino a sibilega badoboome, odoo susuga daga malalo sibadee egee bia ee heli teli odooso. Esiga sipi beso dibada to duloso mesile. ");
INSERT INTO kkc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Osulu aso. Edebeeyo amaga gaduga, yo Godeeye wiligi doloso badeli goo mapoo gadileso, kookaiyo badoboso gie badeli talaiso. Osoloso yo siloga, Yesuye medee bamalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Esiga heli teli odoo ee wulo heli talame, osoloso odoo wooloomalame, osoloso tokenee palame ka sibili. Esino ayo simi hagee, niyo gie badeli toloso, goo tekepo susuga ee tolone dabalame ka simi.” ");
INSERT INTO kkc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Esiga sipi be medee bali odoo ee aso. Egeesi ma kulodu sipi be medee bali odoo oso o sipi be ee gooloogalame o gie badeli teli mapoo mageliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Esino nei talame tou teli odoo oso sipi be medee belega pegeliso. Bei, yo sipi be bali odoonee, osoloso sipi be hagee tei onee. Esiga dobu so simi ogoloso sipi be omapoo poogoloso yo pulo diliso. Eseega dobu soso sibileso sipi be abo wooloomaga, abo kukulo diliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bei, nei talame tou teli odoo oso sipi be medee goolega, wulo pulo diliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Esiga sipi be medee bali odoo ee aso. Egeesi ma kulodu mo Maye mo goo ee gooleedoloso ka badoso. Osoloso ayo mo Mayo goo onosee gooleedoloso ka badoso. Goo egeesi masi mo sipi beso a gooleedoloso ka doso, osoloso ayo diba gooleedoloso ka badoso. Esiga mo sipi be ee gooloogalame ayo mo gie badeli teli mapoo magalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Osoloso mo sipi be abo dono, diba mooloogoodoo hagee ma kulodu mauwe. Esiga a goomogoso, diba nosee gilimado sibilame. Osoloso diayo mo to duleiso. Osoloso diba soosoo hedebe doloso doga, bali odoo hedebeso bamalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Esiga mo Maye a diya gweliso. Bei, ayo mo gie badeli ee teli mapoo magalaiso, osoloso see ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Esiga odoo heeso mo gie badeli ee amaga peedee dalaime. Esino mawo goomoga goo ee dodolone, ayo mo gie badeli ee wulo wulayo tenelaiso. Esiga ee ma kulodu, ayo mo gie badeli ee odoo halo teli mapoo magalai amapoo kitulugu moloso, osoloso see peedee dalai amapoo kitulugu moloso. Bei, goo hagee mo Maye ayo moodoolame amapoo kitulugu sabolo olo takaso.” ");
INSERT INTO kkc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Eseme Yu odooso Yesuwo to duloso dieso dima kulodu toso agadigilone abo piso. ");
INSERT INTO kkc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Egeeseelone odoo aboso egeesee takaso, “Yo bo holo peleso badolone ka halaboomo silo. Esiga o to na dui,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Esino odoo aboso egeesee takaso, “Odoo bo holo pala oso goo tekepo hageesi kasee takomo sileiyo? Osoloso bo holoso odoo howo neliga tekepo palai teibayo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Esiga wau biame mapoo Yelusalem mi mapoo Yu odooso dia tei moso osulu ya ee gooleebugulone wo neso. ");
INSERT INTO kkc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Osoloso wo ne biame omapoo Yesuye tei moso tegei beelee ee ma kulodu Solomonowo hau mapoo sileeso. ");
INSERT INTO kkc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Eseme Yu odooso yo ogoloso sibileso tobolo sidiboloso yimapoo egeesee takaso, “Iba biame susuga nee goo mapoo diya goolone ka doso. Esiga nayo imapoo woola takee, no tei Kelisowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Eseme Yesuye nei dimapoo egeesee takaso, “Ayo nimapoo olo takaso. Esino niyo mo to mapoo tei tele. Esiga goo toowa opusomo di ayo mo Mayo hu maga moodeli oso nimapoo mo goo ee eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Esino niyo tei koo toso. Bei, niba mo sipi benee. ");
INSERT INTO kkc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mo sipi beso mo to duliso. Osoloso a diba gooleedoo. Osoloso diayo ama hamamee dedeliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Osoloso ayo dimapoo kookaiyo badoboso gie badeli teneliso. Osoloso diba Godee maga pileime. Osoloso diba mo dee maga odoo heeso peedee dalaime. ");
INSERT INTO kkc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mo Maye mo sipi be hagee amapoo olo teneeso. Osoloso yayo kitulugu oso odoo susuga oso kitulugu ee dagadi. Esiga odoo heeso mo Mayo dee maga peedee dalai tebile. ");
INSERT INTO kkc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","A mo Ma sabolo hedebe.” ");
INSERT INTO kkc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eseme Yu odooso Yesu enigilame yo see tobu misigaso. ");
INSERT INTO kkc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Eseme Yesuye nei dimapoo egeesee takaso, “Mo Maye amapoo kitulugu teneme, ayo nibada howo woola goo tekepo moodoomo sileeso. Esino goo tekepo susuga ayo moodoo ee ma kulodu goo hee kaso tokenee daga, niyo a wooloomalame ka sala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eseme see Yu odoo dia wiligi odoo tebisa oso egeesee takaso, “Nayo goo tekepo moodoo maga iyo no wooloomalame koo seeso. Esino nayo Godeeyo goo maga to tokenee taka ee duloso no wooloomalame ka seeso. Bei, no wulo odoo wuluge, esino see nayo takolone, no Godee, dee takeliso.” ");
INSERT INTO kkc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Eseme Yesuye nei dimapoo egeesee takaso, “Nibada tei magoo ee ma kulodu Godeeye egeesee takooso, ‘Niba godee,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Egeesi ma kulodu iba gooleedoo, Godeeyo to booka mapoo hogugu oso tei goo takooso. Esiga Godeeye o to mapoo tei teli odoo mapoo takolone, diba godee, deliso. ");
INSERT INTO kkc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Esiga ayo takolone, a Godeeyo Owolo doloso ka takano, bei kasi maga niyo takolone, ayo Godeeyo goo maga to tokenee takoo, dee ka takala? Bei, mo Maye a hesialoso mipoo hamapoo sibeye diso. ");
INSERT INTO kkc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Esiga ayo mo Maye goomoga goo ee moodelega badoga, niyo to ayo taka mapoo tei tele ka peegee. ");
INSERT INTO kkc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Esino niyo to ayo taka mapoo tei tele poogolone, wulo goo ayo hagee tomo silo ee ogoloso to ayo taka mapoo tei ka te. Bei, niyo egeesee seega, mo Ma asalo hedebe doloso hagee do goo ee niba gooleedalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Eseme odoo susuga oso to hagee duloso Yesu see talame seme, Yesu dimaga peegoo diso. ");
INSERT INTO kkc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Osoloso Yesu see Yoden howo dalo sooweleso, Yoneeye daga odoo howo olugumelee mi omapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Eseme odoo susuga oso yimapoo sibileso egeesee takaso, “Yoneeye goo toowa opusomo di moodoomo sile. Esino yayo Yesuwo goo maga taka goo susuga ee tei goodoo,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eseme odoo susuga omapoo debeli oso Yesu mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani mi mapoo badeli odoo hee paiye badebeiso, o hu Lasales. Osoloso omoo Meli dio Mata dio onosee Betani mi omapoo debeli. ");
INSERT INTO kkc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meli hagoso hamamee Lodeeyo homo mapoo mopoodoosoo sooloso o wuduso talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Esiga Meli dio Mata dio odoo hee mapoo dia to takaso, yayo dileso Yesu mapoo takalame. Eseme yayo dileso Yesu mapoo egeesee takaso, “Lodee, odoo no gooma ee paiyega badoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Esino Yesu to hagee duloso egeesee takaso, “Paiye ogoso yo talaime. Esiga goo hagoso peledabalaiso, edebeeyo goo hagee ogoloso Godeeye kitulugu sabolo osoloso Owolo ayo kitulugu ee gooleedalame,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Esiga ee ma kulodu Yesuye Mata dio, omolo Meli dio, osoloso Lasales diya gweliso. ");
INSERT INTO kkc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Esino yo Lasaleseeye paiye goo ee duloso saga dilega, biame bakadio omapoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Biame bakadio poogoloso Yesuye o hamamee dili odoo mapoo egeesee takaso, “Iba see Yudiya mi mapoo wedi dimo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Eseme o hamamee dili odoo oso yimapoo egeesee takaso, “Eligili odoo, no omapoo badoboome, Yu odooso no yoso wooloomalame sino poogooso. Esiga no see kasalame mi omapoo wedi dilame ka sala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Eseme Yesuye egeesee takaso, “Biame hedebe ma kulodu osoko howo 12 moloso. Esiga edebeeyo biame siloga, yo takodee bigileime. Bei, yo gadeebugu ma kulodu siloga. ");
INSERT INTO kkc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Esino edebeeyo gesi siloga, yo takodee bigileiso. Bei, yimapoo gadeebugu mega.” ");
INSERT INTO kkc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuye to hagee takoloso see egeesee takaso, “Ibada odoo Lasales yo tiamoloso. Esiga ayo yo tidibigileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eseme o hamamee dili odoo oso egeesee takaso, “Lodee, yo wulo tiaga, see weidileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Esino Yesuye taka goo ee ma kulodu Lasales yo tei olo ta neme ka taka. Esino Yesu o hamamee dili odoo oso goolee Lasales wulo tiamolo gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eseme Yesuye dimapoo woola egeesee takaso, “Lasales olo ta moloso. ");
INSERT INTO kkc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Esiga a goomogoso, ayo niba halo yo agalame dile. Esino ayo yimapoo goo moodoo ee niso ogoloso amapoo tei talaiso. Esiga yimapoo dimo.” ");
INSERT INTO kkc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eseme Tomas, o hu hee Didimas deli, oso Yesu o hamamee dili odoo abo mapoo egeesee takaso, “Iba nosee Yudiya mi mapoo dimo, Yesu bolo hodobo talame,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuye sibileso Betani mi mapoo peledoboloso egeino, Lasales bi ma kulodu tamelee biame bakadio bakadio di poogoloso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani mi hagee Yelusalem mi maga haga hoogoonee, wulo kilomita bakadio hedebe di egeesi. ");
INSERT INTO kkc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Osoloso Meli dio Mata dio omolo Lasaleseeye ta maga goohele sabolo doboome, Yu odoo aboso dibolo hodobo dabalame, Yelusalem maga sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eseme Mataye Yesuye simi goo ee duloso, yo eli domopoo tugodalame diso. Esino Meli yo mosopoo badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Eseme Mataye Yesu tugodoloso yimapoo egeesee takaso, “Lodee, no hamapoo badebei diepi, molo telega pegeliyo. ");
INSERT INTO kkc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Esino a gooleedoo, goo hagee ma kulodu, nayo ogoo goo ee Godee mapoo woosaga, Godeeye goo egee namapoo tenelaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eseme Yesuye yimapoo egeesee takaso, “Nomolo see hogabileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Eseme Mataye nei yimapoo egeesee takaso, “A gooleedoo, yo biame hamameedee mapoo odoo wedia oso hogogabuoga, yinosee omapoo hogadileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eseme Yesuye yimapoo egeesee takaso, “Odoo wedia maga hogogaduloso see gie badeli teneli ee aso. Esiga edebeeyo amapoo tei toloso badoboso toga, yo kookaiyo gie badalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Osoloso edebeeyo amapoo tei toga, o dio talaime, esino yo kookaiyo gie badalaiso. Esiga Mata no goo hamapoo tei tosomo?” ");
INSERT INTO kkc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eseme Mataye nei yimapoo egeesee takaso, “O, Lodee, a goo hamapoo tei toso. Bei, no Keliso, Godeeyo Owolo, mipoo hamapoo sibileigo dee takemelee ee noso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mataye to hagee taka koodobuloso see wedi dileso omolo Meli mapoo mada egeesee takaso, “Eligili odoo olo sibileso bado. Esiga yayo no agalai goomogona,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meli to hagee duloso toboloso Yesu agalame saga diso. ");
INSERT INTO kkc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu mosopoo peledebelega, Mataye dileso yo tugodoo mi omapoo osee badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eseme Yu odooso Meli pidilone diba yibolo hodobo mosopoo debeiso. Esino yayo saga toboloso di ogoloso yima hamamee diso. Diayo goolee Meli bi mapoo dileso pisilei gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Esino Meliye Yesuye badebei mapoo dileso o homo beiyopoo gauwuloso badolone egeesee takaso, “Lodee, no hamapoo badebei diepi, molo telega pegeliyo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuye Meli dio osoloso Yu odoo abo Melibolo sibadee oso hodobo pupusiga molome ogoloso su hegi sabolo badolone diya gooheleso. ");
INSERT INTO kkc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Osoloso yayo dimapoo egeesee takaso, “Niyo yo kapoo magooba?” diso. Eseme diayo nei egeesee takaso, “Lodee, no agalame ibolo hodobo sibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Eseme Yesu yinosee pisaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Eseme Yu odooso goo egee ogoloso egeesee takaso, “Yesuye Lasales diya gweli goo ee niso ege,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Esino odoo aboso egeesee takaso, “Odoo hagoso odoo howo neliga ee tekepo paso. Esiga bei kasi maga yayo Lasales telega pagalame pidile ka poogoowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu su hegi osee molone, Lasales magoo wulu ou miyopoo simiso. Osoloso wulu ou ee yo toowaso kisiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Osoloso Yesuye egeesee takaso, “Yo egee peegoo bidibigi,” diso. Eseme Lasaleseeyo omoo Mataye egeesee takaso, “Lodee, o kou ee wulu ma kulodu melee biame bakadio bakadio di egeesi poogooga, olo hune koko,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eseme Yesuye nei yimapoo egeesee takaso, “Ayo namapoo daga takolone egeesee takaso, nayo tei toga, no Godeeye kitulugu ee agalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eseme odoo aboso yo toowa wulu ou kisi ee peegoo bidibuguso. Eseme Yesuye dokodoo bolone egeesee takaso, “Ma, ayo namapoo goomoga to ka taka. Bei, ayo namapoo taka goo ee nayo duga. ");
INSERT INTO kkc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Osoloso a gooleedoo, nayo biame susuga ayo namapoo taka goo ee nayo duliso. Esino odoo hamapoo egee tebisamolo oso nayo a diye di goo mapoo tei talame, goo hagee ayo ka taka.” ");
INSERT INTO kkc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuye egeesee takoloso to neligidi egeesee takaso, “Lasales, no wulu ma kuloduga peegoo gasibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eseme Lasales o dee sabolo, osoloso o homo bodo sabolo, osoloso o mudu ee dugo semeso tiegisa sabolo wulu ma kuloduga peegoo gasibileso tobudume egeiso. Eseme Yesuye dimapoo egeesee takaso, “Dugo egee puobigi, osoloso yo diye dee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Esiga Yu odoo susuga Meli agalame sibadee oso goo Yesuye moodoo ee ogoloso yimapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Esino odoo aboso dileso goo Yesuye moodoo ee Pelisi odoo mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Esiga tei moso wiligi odoo tebisa sabolo osoloso Pelisi odoo oso Yu odoo dia wiligi odoo mooloogoodoo Sanhedelin deli ee gilimadoloso dimapoo egeesee takaso, “Iyo kasee selaisomo? Bei, odoo hagoso goo toowa mudu opusomo di bei moodoogamo siliso. ");
INSERT INTO kkc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Iyo wulo baga, odoo susuga oso yimapoo tei talaiso. Osoloso Loum gamalee odoo oso ibada tei moso ee guobuguloso ibada odoo tokenee palaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eseme dima kulodu odoo hee badebeiso, o hu Kayapas. Dugo omapoo yayo tei moso wiligi odoo toboloso badolone, odoo mooloogoodoo mapoo egeesee takaso, “Niba goo goolee mauwe odoo. ");
INSERT INTO kkc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Esiga niba koo gooleedolo? Odoo hedebeso odoo susuga ee halo talai tekepo. Egeeseega, Yu odoo susuga iba tokenee palaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Esiga Kayapaseeye taka goo hagee, wulo eyo goolee takele. Esino yayo dugo omapoo tei moso wiligi odoo toboloso badoboome, Yesuye Yu odoo halo talai goo ee Godeeye yimapoo eligime, yayo egeesee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Esino hedebe Yu odoo halo talaime. Esino Godeeyo odoo mi opusomo opusomo di mapoo egee do ee see hedebe dalame ka talai. ");
INSERT INTO kkc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Esiga biame omaga bei mooloogoloso dulone Yu odoo dia wiligi odoo tebisa oso Yesu wooloomalame eli esiameleeso. ");
INSERT INTO kkc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Goo egeesi maga Yesu see Yu odoo dia howo woola koo sili. Esino yayo o hamamee dili odoo sabolo mi egee poogoloso, see miwe poogoo mi koola mapoo mi hee, Epelaim deli, mapoo dileso debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Osoloso Godeeye Gababia wo nalai biame olo koola tooboome, Yu odoo dia mi pepuso maga Yelusalem mapoo palaso, Godeeyo howo woola diba medee mopoodoo doloso tekepo dabalame. ");
INSERT INTO kkc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Osoloso diayo Yelusalem mapoo dobolone Yesu esiamo silesibiso. Egeeseelone tei moso ma kulodu mooloogodoloso dieso nei woosa nei woosa demeleeso, “Niyo kasee gooleedo? Yesu wo ne hamapoo sibileisomo?” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Esino tei moso wiligi odoo tebisa sabolo osoloso Pelisi odoo oso to kitulugu sabolo odoo susuga mapoo egeesee takaso, “Odoo heeso Yesuye badebei egei daga, imapoo takee, egeeseega iyo dileso yo ka talaiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gababia wo nalai ee biame 6 malalo hoogoo molome, Yesu yo Lasaleseeyo mi Betani mapoo see wedi diso. Lasales hagee daga Yesuye ta maga hogadi ee yoso. ");
INSERT INTO kkc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Osoloso habe mi omapoo diayo Yesuwo nei toowa mopoodoo dooso. Osoloso Mataye nei piso. Osoloso Lasales yinosee ee ma kulodu dibolo hodobo dobolone Yesubolo nei nameleeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eseme Meliye mopoodoo soo tekepo nad deli i salama soo lita botoloo gegelee egeesi toloso Yesuwo homo mapoo sooso. Osoloso o homo o wuduso taso. Eseme mopoodoo soo oso sisigage oso moso kulodu tiadooso. Mopoodoo soo tekepo hagee molee toowaso teli. ");
INSERT INTO kkc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Esino domo omapoo Yesu o hamamee dili odoo hee badebeiso, o hu ee Yudas-Iskaliyot. Odoo hagoso hamamee Yesu ha teli odoo mapoo tiasalaiso. Osoloso yayo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mopoodoo soo tekepo hagee molee ko 300 oso teli. Esino bei kasi maga mopoodoo soo tekepo hagee, iyo odoo mapoo teneloso nei molee toloso bi mauwe odoo mapoo tenele ka poogoowo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Esino Yudaseeye to hageesee taka egee, yo bi mauwe odoo ee sooloo dolone to hagee ka takele. Esino yo heli teli odooga to hageesee ka taka. Bei, yayo Yesu o hamamee dili odoo dia molee ee gibadolone abo mada heli temeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eseme Yesuye egeesee takaso, “Meliye goo egee moodoo ogoloso yimapoo goo hee na moodee. Bei, yayo goo egeesi moodoo egee a toga mi doosalai ee gooleebugulone ka moodoo. ");
INSERT INTO kkc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Osoloso bi mauwe odoo oso biame susuga nibolo dabalaiso. Esino a biame susuga nibolo badalaime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Esiga biame domo omapoo Yu odoo mooloogoodoo toowa oso Yesuye Betani mi mapoo sibileso badebei goo ee duloso Yesu agalame dulone, Lasales yinosee agalame diyadeeso. Bei, Yesuye yo ta maga see hogadiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Goo egeesi maga tei moso wiligi odoo tebisa oso Lasales onosee wooloomalame to mouso. ");
INSERT INTO kkc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bei, Lasales see hogadi eyo goo maga Yu odoo aboso dia wiligi odoo ee poogoloso see Yesu mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Osoloso biame hee mapoo odoo mooloogoodoo toowa Yelusalem mapoo Gababia wo ne mapoo di odoo oso Yesu sibosogo di goo ee duso. ");
INSERT INTO kkc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Osoloso diayo weiyo kookoloso Yesu tugodalame dulone to neligidi egeesee takomo diyadeeso, “Iba Godeeyo hu dokodoo poudoomo. Odoo Godeeyo hu maga kitulugu sabolo egee sibo, yo wiligi odoo Godeeye pidiye dee. Osoloso Isalael odoo dia wiligi odoo, yo Godeeye pidiye dee,” dee takomo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Biame domo omapoo Yesuye donki be gie kauwa ogoloso o wagi ma dokodoo biaso. Goo peledaba hagee Godeeyo to booka mapoo hogugu sabolo tebilame ka seeso. Bei, Godeeyo toso egeesee takooso, ");
INSERT INTO kkc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalem odoo, niba haga na ebi. Nibada wiligi odoo donki be pe eyo wagi ma dokodoo buloso siboso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Esino biame omapoo Yesuwo hamamee dili odoo oso goo hagee medee kibiya gooleedele. Esino Yesu ta maga hogaduloso hamamee goo susuga Yesu mapoo moodoo oso Godeeyo to booka mapoo hogugu sabolo tobume, goo ee ogoloso gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Esiga Yesuye Lasales ta maga hogaduloso see wulu ou ma kuloduga peegoo gasibilame i goo ee egei odoo mooloogoodoo hagee biaso odoo abo mapoo takalame diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eseme odoo susuga oso goo toowa opusomo di Yesuye moodoo ee duga, diba Yesu tugodalame diso. ");
INSERT INTO kkc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eseme Pelisi odooso dieso dima kulodu egeesee takaso, “Niso ege. Iba kitulugu olo me poogoo. Bei, odoo susuga oso yima hamamee deedeeso,” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Osoloso Guliki odoo aboso odoo Yelusalem mapoo Gababia wo ne mapoo paladee sabolo palaso, Godeeyo hu dokodoo poudalame. ");
INSERT INTO kkc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Osoloso diba dileso Gelili mi ma kulodu mi pepooko Betesaida mapoo badeli odoo hee Pilipi mapoo egeesee takaso, “Emegei, iba Yesu agalai goomogo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Eseme Pilipiye Endulu takala dileso obakadio Yesu takalame diso. ");
INSERT INTO kkc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Eseme Yesuye nei dimapoo egeesee takaso, “Odoo Holo ayo toowa doloso badalai biame ee olo siboso. ");
INSERT INTO kkc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Esiga ayo nimapoo ka taka. Edebeeyo ko mi mapoo segele poogooga, ko egee see opusomo dalaime. Esino ko hedebe onosee osee malaiso. Esino ko mi mapoo sogoloso opusomo doloso pologa, bou dia gasibileso kauwuloso ko okopolo palaiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Esiga edebeeyo o gie badeli ee eyo diya goodogoga, o gie badeli ee osugobalaiso. Esino edebeeyo mipoo hamapoo badolone o gie badeli goodogelega badoga, odoo egee o gie badeli osugobalaime. Esino yo badoboso kookaiyo gie badeli talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Esiga edebeeyo mo tou talai goomogoga, yo a deedee sibe. Eseega, yo ayo egee bado mi omapoo yayo abolo hodobo badalaiso. Esiga mo tou teli odoo ee mo Maye o hu dokodoo poudileiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Epedee hamapoo a su diya hegi moodoo. Esiga ayo mo Ma mapoo takolone, ‘Ma, dala amapoo egee sibo nayo peegoo magee,’ dee takalai tekepowo? Haye, tekeponee. Bei, a dala egee talame mipoo hamapoo ka simi. ");
INSERT INTO kkc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Esiga Ma, nayo toowa doloso egee bado goo ee odoo mapoo eligi.” Eseme toso Kei mi ma dokodooga egeesee taka, “Ayo toowa doloso egee bado goo ee odoo mapoo olo eligiso. Osoloso ayo dimapoo see eligileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Esino odoo mooloogoodoo omapoo tebisamelee oso to hagee duloso egeesee takaso, “Kei woo,” diso. Osoloso odoo aboso takolone, momaiyeso Yesu mapoo to takoo, dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Osoloso Yesuye see egeesee takaso, “To taka hagee a pidilame ka takele. Esino niba pidilame ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Esiga Godeeye mi odoo dia goo midilei biame ee hagoso. Osoloso mipoo hageeyo wiligi odoo Saiten ee Godeeye daga dileiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Esiga edebeeyo a toloso mi hamaga dokodoo poudoga, ayo odoo susuga amapoo gido sibileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuye taka hagee, eyo talai goo ee kasee tomoba dolone ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eseme odoo mooloogoodoo oso egeesee takaso, “Ibada tei magoo oso egeesee taka duliso, Keliso yo badoboso kookaiyo badalaiso, dee takeliso. Esino bei kasi maga nayo takolone, Odoo Holo yo toloso mi hamaga dokodoo poudileiso, dee ka takeliyo? Osoloso Odoo Holo hagee odoo ogumo?” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Eseme Yesuye dimapoo egeesee takaso, “Gadeebugu oso biame deiyepo nibolo malaiso. Esiga gadeebugu nimapoo mologa, niba gadeebugu ee ma kulodu silesibe, neligaso niba gooloogeyaga. Egeesi ma kulodu niba neliga ma kulodu silesiboga, niba niso egee du eli ee medee ogoloso gooleedalaime. ");
INSERT INTO kkc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Esiga gadeebugu nimapoo osee egee molo mapoo tei te. Niyo egeesee seega, niba gadeebugu eyo owolo dio dalaiso.” Yesu to hagee takoloso koodobuloso peegoo dileso dimaga mada wuaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuye goo toowa opusomo di susuga odoo howo woola moodoogaso. Esino edebeeyo yimapoo tei tele. ");
INSERT INTO kkc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Esiga Godee maga to toloso kokodo takomo sili odoo Aisayaye taka goo sabolo tebilame, goo hagoso peledabaso. Aisayaye egeesee takaso, “Lodee, odoo agayo iyo taka goo ee tei ka toba? Osoloso Lodeeye kitulugu ee odoo ogu bia dimapoo ka yilige buguba?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Esiga edebeeyo Yesu mapoo tei talai tebile. Bei, Aisayaye see egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Godeeye odoo susuga dia howo gooloogooso. Osoloso yayo diba goo goole pagalame moodooso, dia howoso kibiya egelega pagalame, osoloso diayo medee kibiya gooleedelega pagalame, osoloso see Godee mapoo wedi sibileso tekepo pelega pagalame.” ");
INSERT INTO kkc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisayaye Yesuye toowa doloso badeli goo ee ogoloso o goo maga egeesee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Esino odoo abo sabolo osoloso Yu odoo dia wiligi odoo abo oso Yesu mapoo tei tooso. Esino diba Pelisi odoobolo obulone, diayo tei too goo ee woola yilige bigile. Bei, Pelisi odooso dia hu howo gisili moso ma kulodu magoo ee tabigiyaga. ");
INSERT INTO kkc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Osoloso diayo Godee maga goomoga talai haga goole poogoloso, hee odoo maga goomoga talai ono diya gweliso. ");
INSERT INTO kkc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Eseme Yesuye to neligidi egeesee takaso, “Edebeeyo amapoo tei toga, yo hedebe amapoo tei koo toso. Esino a diye di odoo omapoo nosee tei toso. ");
INSERT INTO kkc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Osoloso edebeeyo a ogoga, yo a diye di odoo onosee ogoso. ");
INSERT INTO kkc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Esiga ayo mipoo hamapoo neliga ma kulodu keme masi poudo simiso. Egeesi ma kulodu edebeeyo amapoo tei toga, yo neliga ma kulodu osee badalaime. ");
INSERT INTO kkc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Esiga edebeeyo mo to duloso mesilega poogooga, ayo o goo midileime. Bei, ayo mipoo hamapoo simi hagee, odoo goo midilame ka sibile. Esino odoo dia gie badeli ee pidilame ka simi. ");
INSERT INTO kkc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Esino edebeeyo a gowoolone mo to telega poogooga, Godeeye goo midilei biame mapoo to ayo taka oso nei dia goo ee midileiso. ");
INSERT INTO kkc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bei, a mawo gooleeso to hagee ka takele. Esino mo Ma, a diye di oso to ayo takalai sabolo osoloso ayo kasee takalai goo ee, yayo amapoo takaga, ayo egeesee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Esiga Godeeye taka to hagoso odoo mapoo gie badeli tosibiliso. Goo egeesi maga mo Maye amapoo taka goo ee see nimapoo ka takomoloso.” ");
INSERT INTO kkc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yu odooso Gababia wo nali biame olo koola tooboome, Yesu yo mipoo hagee poogoloso see Ama mapoo palai biame ee olo koola tooboo, doloso gooleedooso. Esiga yayo mipoo hamapoo gie badolone, o hamamee dili odoo ee sooloo deliso. Esino yayo diba diya sooloo deli goo ee epedee dimapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Osoloso Yesuye o hamamee dili odoo sabolo habe nei nolone debeiso. Esino ee ma kulodu Saimon-Iskaliyoteeyo owolo Yudas mapoo Saitenso goo goolee olo teneeso, yayo Yesu ha teli odoo mapoo tiasalame. ");
INSERT INTO kkc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Osoloso Amaye goo susuga ee balame kitulugu Yesu mapoo tenee goo ee yo olo gooleedooso. Osoloso yo Godee maga simi, esiga yo see Godee mapoo wedi palai goo ee yo olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Osoloso nei nolone debei maga toboloso o dugo sage tamagoloso see dugo howo i tali ee toloso o bagi mapoo booso. ");
INSERT INTO kkc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Osoloso katolo mapoo howo salama soloso o hamamee dili odoo hedebe hedebe di eyo homo hapoloso, dugo howo i tali o bagi mapoo boo oso howo i ka ta domo dilame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Egeeseelone Saimon-Pitayo homo hapalame seme, yayo egeesee takaso, “Lodee, nayo mo homo hapalame ka sala?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eseme Yesuye egeesee takaso, “Goo ayo hagee moodoo eyo bei no epedee koo gooleedoso. Esino no hamamee gooleedalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Eseme Pitaye egeesee takaso, “Nayo mo homo hapalaime,” diso. Eseme Yesuye nei yimapoo egeesee takaso, “Ayo nee homo hapelega poogooga, no mo hamamee dili odoonee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eseme Saimon-Pitaye see egeesee takaso, “Lodee, nayo hedebe mo homowe ono na hapee. Esino mo dee sabolo osoloso wiligi sabolosee hapee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eseme Yesuye egeesee takaso, “Odoo howo sauwe ee o su mapoo subugo me meleeya. Esiga hedebe o homowe hapalai tekepo. Esiga niba olo subugo mauwe. Esino nima kulodu odoo hee subugo sabolo badoso.” ");
INSERT INTO kkc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Osoloso Yesu yo ha teli odoo mapoo tiasalai odoo ee, yo olo gooleedooso. Esiga yayo egeesee ka taka, “Odoo hee nima kulodu subugo sabolo badoso,” dee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesuye o hamamee dili odoo dia homo hapaga koodobuloso o dugo sage kaloso wedi sibileso bulone egeesee takaso, “Niba goo ayo epedee nimapoo moodoo eyo bei gooleedoosomo? ");
INSERT INTO kkc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Esiga niyo amapoo takolone, ‘eligili odoo,’ osoloso ‘Lodee,’ deliso. Niyo amapoo egeesee takeli ee tei goo. Ee aso. ");
INSERT INTO kkc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Esiga nibada eligili odoo osoloso nibada Lodee ayo nibada homo ka hapooso. Esiga niyo nee odoowo homo nei hapoo nei hapoo dolone ka debee. ");
INSERT INTO kkc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Goo ayo nimapoo hagee edidi ee peedee. ");
INSERT INTO kkc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Esiga ayo nimapoo taka. Odoo tou nei mauwe teli oso o wiligi odoo dagadileso koo badoso. Osoloso to tosili odoo oso yo diye di odoo ee dagadileso koo badoso. ");
INSERT INTO kkc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Egeesi ma kulodu niyo goo hagee gooleedoloso peedeega, Godeeye goo hagee ogoloso nimapoo goomogalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Esiga goo ayo hagee takoo, haga odoo susuga nimapoo koo takooso. Bei, odoo ayo hesiga ee, a olo gooleedooso. Esino Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Odoo abolo wo nolone badebei oso amapoo ha talaiso.’ To hagoso gooso peledabalai sabolo tebilame ka hogugu. ");
INSERT INTO kkc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Esiga goo hagee peledebelega mologa, ayo nimapoo malalo ka taka. Goo hagoso tei peledobooga, niyo a tei Kelisodoo doloso tei ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Esiga ayo nimapoo taka. Edebeeyo odoo ayo diye di ee idoga, yayo a idoso. Osoloso edebeeyo a idoga, mo Ma a diye di ee idoso.” ");
INSERT INTO kkc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuye to hagee taka koodobuloso su hegi sabolo badolone, o hamamee dili odoo mapoo egeesee takaso, “Ayo nimapoo taka. Odoo heeso nima kuloduga a ha teli odoo mapoo tiasalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eseme o hamamee dili odoo oso dieso dima kulodu nei ogo nei ogo dolone egeesee gooleeso, “goo hagee odoo ogu mapoo takabele,” dee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Osoloso Yesu o hamamee dili odoo dima kulodu odoo hee Yesuye diya gooma ee yima koola ogolone badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eseme Saimon-Pitaye odoo omapoo howo gisoloogoso, Yesuye odoo ogu taka beleso yayo yimapoo woosalame. ");
INSERT INTO kkc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eseme yayo Yesu mapoo bouwa molone yimapoo egeesee takaso, “Lodee, odoo agayo no ha teli odoo mapoo ka tiasalaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Eseme Yesuye nei egeesee takaso, “Ayo wo i mapoo oluguloso teneega, odoo oso a ha teli odoo mapoo tiasalaiso.” Osoloso Yesuye wo toloso i mapoo oluguloso Saimon-Iskaliyoteeyo owolo Yudas mapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudaseeye wo teme, Saitenso o kulodu palaso. Eseme Yesuye yimapoo egeesee takaso, “Nayo goo talame egee gooleemolo goo ee saga moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Egeesi ma kulodu Yesuye Yudas mapoo egeesee taka goo eyo bei ee o hamamee dili odoo diba medee kibiya gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Esiga odoo aboso goolee, Yudaseeye Gababia wo nalame bi abo talame di, dee takoo gooleeso. Osoloso odoo aboso goolee, ee molee odoo bi mauwe mapoo tenelame di, dee takoo gooleeso. Bei, Yesu o hamamee dili odoo dia molee ee Yudaseeye gibadeliga. ");
INSERT INTO kkc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Osoloso gesi Yudaseeye wo Yesuye tenee ee toloso peegoo gadiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas olo peegoo dime, Yesuye egeesee takaso, “Epedee Odoo Holo ayo toowa doloso badeli goo ee woola yilige bigileiso. Osoloso Godeeye toowa doloso badeli goo ee amaga woola yilige bigileiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Esiga Godeeye toowa doloso badeli goo ee amaga woola yilige buguga, nei Godee eyo Odoo Holo ayo toowa doloso badeli goo onosee woola yilige bigileiso. Esiga goo hagee saga moodoolaiso. ");
INSERT INTO kkc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Esiga mo odoo, ayo biame deiyepo nibolo hodobo badalaiso. Osoloso a duga, niyo a esileiso. Esino niyo a agalaime. Esiga ayo Yu odoo dimapoo taka goo ee see tobu nimapoo ka taka. Niba mi ayo hagee du mapoo dilei tebile. ");
INSERT INTO kkc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Esiga kokodo takeli to dia hagee ayo nimapoo ka taka. Niyo nee odoo nei sooloo dolo, nei sooloo dolo dolone ka dabalame. Ayo niba goolee sabolo egee bado egeesee masi, nee odoo nei sooloo dolo, nei sooloo dolo dolone ka debee. ");
INSERT INTO kkc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Egeesi ma kulodu niyo emegei nei sooloo dolo, nei sooloo dolo dolone doga, odoo susuga oso niba tei mo hamamee dili odoodoo doloso gooleedalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Esino Saimon-Pitaye egeesee takaso, “Lodee, no kapoo dilame ka sala?” diso. Eseme Yesuye nei egeesee takaso, “No epedee ayo hagee du mapoo sibilei tebile. Esino no see hamamee sibileiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eseme Pitaye see egeesee takaso, “Lodee, bei kaseega ayo epedee nobolo sibilei tebile ka molosomo? Ayo no halo talame olo mopoodoo doloso ka badoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Eseme Yesuye nei egeesee takaso, “No tei a halo talame mopoodoo doloso ka badosomo? Esiga ayo namapoo tei goo taka. Kolokolo takelega mologa, nayo mo goo gagadilei ee bakadio hedebe dalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Eseme Yesuye egeesee takaso, “Niba goo haga koudulone na debee. Esino niba Godee mapoo tei tolone amapoosee tei te. ");
INSERT INTO kkc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bei, mo Mayo moso mapoo debi bei moloso. Esiga goo hagee tei goonee diepi, ayo goo hagee nimapoo takele pegeliyo. Esiga ayo omapoo niyo dabalai debi ee moodoolame dileiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Osoloso ayo omapoo dileso debi mopoodoo doloso see sibileso niba gilimadoloso abolo hodobo palaiso. Osoloso niba mi omapoo abolo hodobo dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Esiga ayo hagee du eli ee niba olo gooleedooso.” ");
INSERT INTO kkc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Eseme Tomaseeye Yesu mapoo egeesee takaso, “Lodee, mi nayo egee du, iba gooleedele. Nayo egee du eli ee iyo kasee gooleedalaiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Eseme Yesuye egeesee takaso, “Eli aso. Osoloso tei goo takeli eyo bei aso. Osoloso gie badeli eyo bei aso. Esiga odoo heeso eli hee maga Ma Godee mapoo palaime. Esino yo hedebe amaga Ma mapoo ka palai. ");
INSERT INTO kkc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Niyo mo goo gooleedoo diepi, niba mo Ma nosee gooleedeliyo. Esino epedee domo hamaga niyo yo olo gooleedooso. Osoloso yo olo egeiso.” ");
INSERT INTO kkc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Eseme Pilipiye egeesee takaso, “Lodee, nayo Ma imapoo eligi, iba hemisileiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eseme Yesuye nei Pilipi mapoo egeesee takaso, “Pilipi, ayo biame susuga nibolo hodobo badebeiso. Esino egeesi ma kulodu nayo a gooleedelega osee ka badosoba? Esiga edebeeyo a ogoga, yo Ma olo egeiso. Esiga bei kasi maga nayo amapoo takolone, ‘Ma imapoo eligi,’ dee ka takala? ");
INSERT INTO kkc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ayo mo Ma sabolo hedebe doloso egee bado sabolo, osoloso mo Maye abolo hedebe doloso egee bado goo mapoo no tei telega ka badosoba? Esiga to ayo nimapoo hagee takomo silo mawo goolee koo takomo siloso. Esino Maye abolo badolone yayo amaga o goo ee ka tomoloso. ");
INSERT INTO kkc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Esiga ayo takolone, ayo mo Ma sabolo hedebe doloso egee bado sabolo, osoloso mo Maye abolo hedebe doloso badoso, dee egee takoo goo omapoo tei te. Esino niyo to ayo taka mapoo tei telega poogooga, goo toowa opusomo di ayo moodoo ee ogoloso to ayo taka mapoo tei dee. ");
INSERT INTO kkc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Esiga ayo nimapoo taka. Edebeeyo amapoo tei toga, goo toowa opusomo di ayo moodeli egeesi masi yayo moodoolaiso. Osoloso goo toowa opusomo di abo yayo moodooga, oso ayo moodeli ee dagadileiso. Bei, a mo Ma mapoo duso. ");
INSERT INTO kkc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Osoloso niyo mo hu maga ogoo goo ee woosaga, ayo goo egee moodoolaiso, Maye toowa doloso egee bado goo ee Owolo amaga ka yilige bigilame. ");
INSERT INTO kkc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Esiga niyo amapoo mo hu maga ogoo goo talame woosaga, ayo goo egee moodoolaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Niyo a gooleega, niyo ayo kokodo taka goo mapoo mesimo silesibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Osoloso ayo Ma mapoo woosalaiso, yayo pidili odoo hee nimapoo tenelame. Pidili odoo hagoso kookaiyo nibolo hodobo osee badalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pidili odoo egee Dio Tei ee takooso. Yayo tei goodee ee eligiliso. Esino mi odooso yo talai tebile. Bei, diayo yo ogoloso koo gooleedeli. Esino niba o goo olo gooleedooso. Bei, yo nibolo hodobo badoso. Osoloso nima kulodu badalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Esiga ayo niba gilibo holo masi wulo domopoo poogoloso badalaime. Esino a see tobu nimapoo wedi sibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Osoloso biame deiyepo poogoloso mi odoo oso a see agalaime. Esino niyo a see agalaiso. Egeesi ma kulodu a gie badeliga, niba nosee gie dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Egeesi ma kulodu a ta maga see hogadiga, ayo mo Ma sabolo hedebe doloso egee bado goo ee, niba gooleedalaiso. Osoloso niyo abolo hedebe doloso egee do goo sabolo, osoloso ayo nibolo hedebe doloso egee bado goo ee gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Esiga edebeeyo ayo kokodo taka to ee duloso mesimo siloga, odoo egee a diya goolee sabolo badoso. Osoloso odoo a diya goolee sabolo badeli mapoo mo Maye yo sooloo dolone ka badoso. Osoloso anosee odoo egee diya sooloo dolone ka badoso. Osoloso ayo mo goo ee yimapoo yilige bigileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eseme Yudas-Iskaliyot nee, esino Yudas heeso egeesee takaso, “Lodee, bei kasi maga nayo nee goo ee mi odoo mapoo yilige bigile poogoloso, see imapoo ka yilige bigileiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Eseme Yesuye nei egeesee takaso, “Edebeeyo a diya gooleega, yayo goo ayo eligi mapoo mesimo sileiso. Osoloso mo Maye yo diya sooloo dalaiso. Osoloso mo Ma asalo sibileso yibolo hodobo badalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Esino edebeeyo a goolega badoga, yo goo ayo eligi mapoo mesiloso koo siloso. Egeesi ma kulodu goo ayo eligime niyo du ee, ayo mawo goolee eligimo sile. Esino eligi hagee mo Ma, a diye di oso taka ee eligi. ");
INSERT INTO kkc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Esiga ayo nibolo hodobo osee badolone, goo susuga hagee nimapoo olo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Esino mo Maye mo hu maga Dio Tei ee nimapoo meiye dalaiso. Osoloso yayo niba pidilone badolone goo susuga nimapoo eligileiso. Osoloso goo susuga ayo nimapoo taka ee see niyo goolee sabolo dabalame, yayo nibada goo goolee pileiso. ");
INSERT INTO kkc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Esiga mesili goo ayo nimapoo ka tonowa. Mo mesili goo ayo nimapoo hagee tenee ee mi odooso mesili goo egeesinee. Esiga niba goo diya koudulone ebia sabolo na debee. ");
INSERT INTO kkc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Esiga ayo nimapoo takolone, ‘a mo Ma mapoo peleso badoboso see nimapoo ka wedi sibileisogo,’ dee taka goo ee, niba olo duso. Esiga niyo a tei diya goolee sabolo debei diepi, ayo mo Ma mapoo pologa niba goomegeliyo. Bei, yayo toowa doloso badolone, a dagadileso ka badoga. ");
INSERT INTO kkc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Egeesi ma kulodu goo egee peledebelega molome, ayo goo susuga hagee nimapoo olo takaso, goo ogoso hamamee peledobooga ogoloso niyo tei ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Esiga ayo niba eligi ee koodobilei olo koola toobooso. Bei, mi odoo dia wiligi odoo Saiten olo sibo. Yayo a dagadilei yimapoo kitulugu mauwe. ");
INSERT INTO kkc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Esino ayo mo Ma diya goolee sabolo egee bado goo ee mi odoo oso ogoloso gooleedalame, to mo Maye amapoo taka ee ayo tobuloso moodeliso. Esiga niba tebise, iba dimo.” ");
INSERT INTO kkc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Esiga tei homokoko sudee aso. Osoloso mo Maye homo su ee ka gibadoso. ");
INSERT INTO kkc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Osoloso homo dee amaga agaga oso ko pelega mologa, yayo kookooloso peegoo togobiseliso. Esino homo dee ko peli eyo dee abo ee kookeliso, oso see homokoko okopolo palame. ");
INSERT INTO kkc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Egeesi ma kulodu goo ayo nimapoo eligi oso niba homo dee abo egeesi masi olo kookooloso subugo mauwe ka doso. ");
INSERT INTO kkc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Esiga niba amapoo oluguloso ka debee. Eseega ayo nimapoo oluguloso badalaiso. Esiga dee obusomo molone ko palai mauwe. Esino dee oso homo su mapoo oluguloso mologa, ko palaiso. Goo egeesi maga, niba amapoo olugulega doga, homokoko palaime. Esino niyo amapoo oluguloso doga, homokoko okopolo palaiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Esiga homokoko su aso. Osoloso homo dee ee nibaso. Egeesi ma kulodu edebeeyo amapoo sibileso oluguloso badoga, ayo yimapoo oluguloso badalaiso. Eseega yo homokoko okopolo palaiso. Esino niba a mauwe doga, niyo goo hee moodoolai tebileime. ");
INSERT INTO kkc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Esiga edebeeyo amapoo sibileso olugulega doga, yo homo dee ko koo peli koodoloso peegoo togobugu egeesi masi moloso. Esiga homo dee egee sioga misiga magoloso dou mapoo toodeliso. ");
INSERT INTO kkc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Goo egeesi maga niyo amapoo oluguloso dobolone, ayo eligi goo omapoo mesimo silesibulone, niyo ogoo goo talame amapoo woosaga, niba goo egee talaiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Esiga niyo homokoko okopolo poloso mologa, oso mo Mayo hu dokodoo poudiliso, osoloso niba mo hamamee dili odoo doloso egee do goo ee yilige bigiliso. ");
INSERT INTO kkc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Esiga mo Maye a diya sooloo dolone egee bado egeesi masi ayo niba diya sooloo dolone ka badoso. Esiga niba ayo sooloo deli goo ee ma kulodu debee. ");
INSERT INTO kkc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Egeesi ma kulodu ayo mo Maye kokodo taka to omapoo mesimo silone, yayo sooloo deli ma kulodu ka badoso. Osoloso hedebe egeesi masi niyo ayo kokodo taka to omapoo mesimo silesiboga, niba nosee ayo sooloo deli goo ee ma kulodu dabalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Esiga goo hagee ayo nimapoo olo takaso, goomoga goo amapoo egee molo niyo talame. Osoloso nimapoo goomoga goo oso kauwuloso ka malame. ");
INSERT INTO kkc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Esiga ayo kokodo taka to hagoso. Ayo niba sooloo deli egeesi masi niyo nee odoo nei sooloo dolo, nei sooloo dolo dolone ka debee. ");
INSERT INTO kkc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Egeesi ma kulodu edebeeyo o odoo diya sooloo dolone, yo halo o su teli mapoo magalai, goo oso toowa ka moloso. ");
INSERT INTO kkc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Esiga niyo ayo kokodo taka to mapoo mesimo siloga, niba tei mo odoo. ");
INSERT INTO kkc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Esiga niba ayo wulo mo tou teli odoo dee koo takooso. Bei, tou teli odoo ee o wiligi odoo eyo goo ee yo gooleedele. Esino niba tei mo odoo deeso. Bei, mo Maye amapoo taka goo susuga ee ayo nimapoo olo eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Egeesi ma kulodu niyo a ka hesile. Esino ayo niba ka hesiga, niyo homokoko okopolo palame. Homokoko egee kookaiyo moloso osee malaiso. Niyo egeesee solone, ogoo goo talame mo hu maga mo Ma mapoo woosaga, yayo nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Esiga ayo nimapoo kokodo taka to ee hagoso. Niyo nee odoo nei sooloo dolo, nei sooloo dolo dolone ka debee.” ");
INSERT INTO kkc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mi odoo oso niba heigoga, daga diayo a heigoso doloso gooleede. ");
INSERT INTO kkc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Esiga niba mi odoo sabolo hedebe doloso ka debei diepi, diayo niba dia odoo dolone diya goolee sabolo debeliyo. Esino ayo niba mi odoo dima kuloduga olo hesiaso, niyo dibolo hedebe doloso debelega pagalame. Goo egeesi maga diayo nimapoo heiga ka moloso. ");
INSERT INTO kkc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Esiga to ayo nimapoo taka ee medee goolee. Bei, ayo egeesee takaso. Wulo tou teli odoo oso o wiligi odoo ee dagadileso koo badoso. Egeesi ma kulodu edebeeyo amapoo dala olo teneega, diayo niba nosee dala tenelaiso. Osoloso diayo ayo eligi goo mapoo mesiega, diba nosee niyo eligi goo mapoo mesileiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Esino niba mo odooga, diayo goo susuga hagee nimapoo moodoolaiso. Bei, a diye di odoo ee diba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Egeesi ma kulodu ayo sibileso dimapoo to takele diepi, Godeeye dia goo tokenee midilei ee pegeliyo. Esino epedee hamapoo ayo sibileso olo takaso. Goo egeesi maga goo tokenee diayo moodoo ee Godeeye midileiso. Esino diayo to nei takalai tebileime. ");
INSERT INTO kkc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Edebeeyo a heigoga, yo mo Ma nosee heigoso. ");
INSERT INTO kkc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Esiga goo toowa opusomo di ayo moodoomo silee egeesi odoo heeso moodoomo sile. Osoloso ayo dima kulodu goo hageesee moodele diepi, Godeeye dia goo tokenee midilei ee pegeliyo. Esino diayo goo toowa ayo moodoo ee egeliso. Esino diayo mo Ma asalo imapoo heiga ka moloso. ");
INSERT INTO kkc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Esiga goo hagee olo peledabaso, Godeeyo to booka mapoo hogugu oso taka sabolo tebilame. Bei, Godeeyo toso egeesee takooso, ‘Diayo wulo goo mauwe amapoo heiga ka moloso,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ayo niba pidilame Dio Tei nimapoo diye dalaiso. Dio Tei oso mo Ma maga sibiliso, osoloso tei goodee eligiliso. Osoloso Dio Tei oso sibileso, mo goo ee woola yilige bigileiso. ");
INSERT INTO kkc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Osoloso niba nosee niyo mo goo odoo mapoo yilige bigi. Bei, niba daga bei mooloogoo biame omaga abolo hodobo sileeso.” ");
INSERT INTO kkc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Esiga niyo tei too goo maga peegoo diyaga, ayo goo susuga hagee nimapoo olo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bei, odoo aboso nibada hu howo gisili moso ma kulodu egee molo taloso niba peegoo hasiso bigileiso. Osoloso odoo aboso tei too odoo ee piliguga, diayo goolee Godeeyo tou to dee goolai, biame ee sibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Esiga diayo goo hageesee nimapoo moodoolaiso. Bei, mo goo sabolo osoloso mo Mayo goo ee diba gooleedelega. ");
INSERT INTO kkc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Esiga goo hagee ayo nimapoo olo takaso. Egeesi ma kulodu goo hagoso tei peledobooga, niba to ayo taka ee gooleebigileiso.” “Esiga ayo daga Godeeyo tou bei mooloogolone a nibolo hodobo badebeiso. Goo egeesi maga, ayo goo hagee nimapoo takele. ");
INSERT INTO kkc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Esino a epei odoo a diye di mapoo duso. Esino nima kulodu odoo heeso amapoo takolone, a kapoo diala, doloso koo woosa. ");
INSERT INTO kkc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Esiga ayo takolone, a epei dileiso, dee taka goo ee niyo duloso niba diya ka gooholoso. ");
INSERT INTO kkc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Esino ayo tei goo nimapoo ka taka. Ayo niba poogoloso duga, goo oso niba pidileiso. Bei, a duga, nei ayo Dio Tei nimapoo diye dalaiso, yayo niba pidilame. Esino a dilega poogooga, Dio Tei ee nimapoo sibileime. ");
INSERT INTO kkc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Egeesi ma kulodu Dio Tei siboga, yayo mi odoo mapoo goo tokenee eyo goo maga tei goo takalaiso. Osoloso odoo Godeeyo howo woola tekepo dabalai goo onosee takalaiso. Osoloso Godeeye goo midilei goo eyo bei onosee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Esiga Dio Tei oso goo tokenee eyo goo maga tei goo takolone, amapoo tei tele pagalai goo ee mi odoo dia goo tokenee toowa ka moloso, dee takalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Osoloso a mo Ma mapoo hagee polo see niyo a agalaime. Goo ogoso Godeeyo howo woola tekepo badalai goo ee yilige bigileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Osoloso Dio Tei oso Godeeye goo midili goo ee tei goo takolone, mi odoo dia goo ee midileiso, dee takalaiso. Bei, mi odoo dia wiligi odoo Saiteneeyo goo ee olo midiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Esiga amapoo goo bei moloso, ayo nimapoo takalai. Esino epedee niyo goo bei egee gooleedalai tebile. Esiga ayo goo egee nimapoo takalaime. ");
INSERT INTO kkc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Esino Dio Tei oso nimapoo siboga, yayo niba tei goo susuga mapoo gilimado dileiso. Yayo eyo goolee takalaime. Esino yayo to ayo takeme du goo ee takomo sileiso. Osoloso hamamee goo ogoso peledabalai ee yayo nimapoo eligileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Esiga Dio Tei oso to ayo yimapoo takalai ee see nimapoo takalaiso. Goo egeesi maga yayo mo hu dokodoo poudileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Esiga goo susuga mo Maye toloso hagee molo ee mo. Goo egeesi maga ayo takolone, Dio Tei oso to ayo taka ee nimapoo takalaiso, dee ka taka.” ");
INSERT INTO kkc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Biame deiyepo badoboso hamamee niyo a agalaime. Esino see biame deiyepo poogoloso hamamee niyo a see agalaiso.” ");
INSERT INTO kkc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Esiga Yesuwo hamamee dili odoo aboso dieso nediliyo egeesee takaso, “Yayo imapoo takolone, biame deiyepo badoboso hamamee iyo yo agalaime, doloso see, biame deiyepo poogoloso hamamee iyo yo see ka agalai, dee taka goo eyo bei ee ogoobo? Osoloso yayo takolone, yo Ama mapoo dia, dee taka goo eyo bei ee ogoobo? ");
INSERT INTO kkc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Osoloso yayo imapoo takolone, biame deiyepo, dee taka goo eyo bei ogoobo? Iba to yayo taka eyo bei medee koo gooleedo,” dee takemeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuye o hamamee dili odoo oso yimapoo woosalo agalame debei goo ee, yo olo gooleedoloso dimapoo egeesee takaso, “Ayo nimapoo takolone, ‘biame deiyepo badoboso hamamee niyo a agalaime,’ dee taka sabolo osoloso, ‘see biame deiyepo poogoloso hamamee niyo a see ka agalai,’ dee taka goo omaga niyo amapoo woosalame ka dabala? ");
INSERT INTO kkc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Egeesi ma kulodu ayo nimapoo taka. Niba gooholone pisileiso. Esino mi odoo ee goomogalaiso. O, tei takoo, niba goohalaiso. Esino goohele goo oso nimapoo goomoga goo tosibileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Esiga niba medee goolee, soboso holo soomagoo biame omapoo yo dala teliso. Esino yo holo soomagoloso hamamee eyo dala too goo ee boobado bigiliso. Bei, yayo holope soomagoo goo maga diya goomogolone. ");
INSERT INTO kkc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Esiga niba egeesi masi doso. Bei, niba epedee goohele sabolo doso. Esino a see wedi sibileso niba agalaiso. Eseega domo omapoo niba diya goomogalaiso. Goomoga goo hagee odoo heeso nimaga peedee dalaime. ");
INSERT INTO kkc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Biame omapoo niyo goo hee talame amapoo woosalaime. Esino ayo nimapoo tei taka. Niyo ogoo goo talame mo hu maga Ma mapoo woosaga, yayo nimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Esiga niyo daga goo abo talame mo hu maga woosalo egele. Esino epedee hamaga dulone niyo ogoo goo talame mo hu maga woosaga, niyo goo egee talaiso. Eseega goomoga goo nimapoo egee molo ee kauwuleiso.” ");
INSERT INTO kkc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Esiga ayo goo susuga hagee takomo silone, wulo wudu takomo sileeso. Esino biame siboga, ayo goo susuga ee see nimapoo wulo wudu takomo sileime. Esino ayo Mayo goo ee nimapoo woola takomo sileiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Esiga biame omapoo nibada goo ee ayo Ma mapoo woosalaime. Bei, niyo nibada goo ee mo hu maga Ma mapoo woosamalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bei, niyo tei tolone, a tei Ma maga simi doloso, a diya goolee sabolo egee do goo maga Maye niba diya sooloo dolone ka badoso. ");
INSERT INTO kkc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Esiga ayo Maye badeli mi maga mipoo hamapoo simiso. Osoloso see epedee mipoo hagee poogoloso Maye badeli mi mapoo ka wedi poloso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eseme o hamamee dili odoo oso yimapoo egeesee takaso, “Epedee nayo goo hagee imapoo wulo koo wudu takoo. Esino nayo goo susuga hagee imapoo woola yilige buguso. ");
INSERT INTO kkc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Esiga iba tei toso, no tei Godee maga simiga. Bei, goo susuga ee no diya gooleedoo. Osoloso odoo heeso namapoo woosalame gooleemelee ee ogoloso daga nayo yimapoo nei takeliso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Eseme Yesuye nei egeesee takaso, “Niba epedee tei tosomo? ");
INSERT INTO kkc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Esino niba medee dui. Biame olo sibileiso, osoloso olo simiso, niyo a poogoloso nibada mosopoo kukulo dilei. Esino a mobusomo koo badeli. Bei, mo Maye abolo hodobo badeliso. ");
INSERT INTO kkc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Niyo amapoo tei too goo maga nimapoo mesie goo oso malame, ayo goo susuga hagee nimapoo olo takaso. Niba mipoo hamapoo dala ma kulodu dabalaiso. Esino niba ebilega medee kibiya debee. Bei, mipoo hagoso kitulugu ee ayo dagadileso ka badoso.” ");
INSERT INTO kkc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu to hagee taka koodobuloso, Kei mi ma dokodoo bolone egeesee takaso, “Ma, mo biame olo siboso. Esiga Nowolo ayo toowa doloso badeli goo ee odoo susuga mapoo eligi, Nowolo ayo nei nayo toowa doloso badeli goo ee odoo susuga mapoo eligilame. ");
INSERT INTO kkc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bei, odoo susuga ee balame nayo Nowolo amapoo kitulugu olo teneeso, see ayo odoo nayo amapoo tenee dimapoo kookaiyo badoboso gie badeli tenelame. ");
INSERT INTO kkc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Osoloso kookaiyo badoboso gie badeli goo ee, tei Godee hedebe no gooleedalai sabolo, osoloso nayo diye di odoo, Yesu Keliso a gooleedalai ee takooso. ");
INSERT INTO kkc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tou nayo amapoo tenee ee ayo hosudoo maga, ayo mipoo hamapoo badolone, nayo toowa doloso badeli goo ee odoo susuga mapoo eligiso. ");
INSERT INTO kkc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Esiga Ma, mipoo hagee moodelega molome, ayo nobolo badolone ayo toowa doloso badebeiso. Esiga goo egee see epedee amapoo tenee.” ");
INSERT INTO kkc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ma, mipoo hagee ma kuloduga odoo nayo amapoo tenee mapoo ayo nee goo olo eligiso. Hagee nee odoo, nayo amapoo teneeso. Osoloso diayo nee to mapoo mesimo silesibiliso. ");
INSERT INTO kkc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Esiga goo susuga nayo amapoo tenee ee, namaga siboso doloso diba epedee olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Osoloso eligi goo nayo amapoo tenee ee, see ayo dimapoo teneme, see diayo eligi goo omapoo tei tooso. Osoloso ayo namaga simi goo ee, diba olo gooleedooso. Osoloso diba nosee nayo a diye di goo mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Esiga ayo namapoo hagee takoo mi odoo halo koo takooso. Esino odoo nayo amapoo tenee ee halo namapoo ka taka. Bei, odoo hagee nee odoo. ");
INSERT INTO kkc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Egeesi ma kulodu odoo hagee bia ee ibada odoo. Diba mo odoo osoloso diba nosee nee odoo oso. Osoloso ayo toowa doloso badeli goo ee dimaga woola yilige bigiliso. ");
INSERT INTO kkc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Esiga a mipoo hagee poogoo dileiso. Bei, a namapoo olo siboso. Esino mo hamamee dili odoo oso mipoo hamapoo osee dabalaiso. Ma, no tei. Nee hu oso kitulugu amapoo tenee oso odoo hagee bia medee bamelee, nayo abolo hedebe doloso egee bado egeesee solone, diba nosee dieso hedebe doloso dabalame. ");
INSERT INTO kkc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Egeesi ma kulodu ayo dibolo hodobo badolone, nee hu oso kitulugu nayo amapoo tenee goo oso ayo diba medee bameleeso. Eseme odoo hee osugobele. Esino odoo hee Godee maga pileigo dee taka hedebe ono osugobaso, Ma Godee nee to booka mapoo hogugu oso taka sabolo tebilame. ");
INSERT INTO kkc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Esiga a namapoo olo siboso. Esino a mipoo hamapoo osee badolone, goo hagee ayo namapoo ka taka, goomoga goo amapoo egee molo oso mo hamamee dili odoo dima kulodu toowa doloso malame. ");
INSERT INTO kkc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Esiga ayo nee to dimapoo olo takaso. Esino mi odoo oso diba heigaso. Bei, a mi odoonee, egeeseelone diba nosee mi odoo doloso koo doso. ");
INSERT INTO kkc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Esiga Ma, ayo namapoo hagee takoo, nayo mo hamamee dili odoo mi hamaga peegoo gilimado dilame koo takooso. Esino diba Saitenso tokenee peeyaga nayo medee balame ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Esiga a mi odoonee, egeeseelone diba nosee mi odoo doloso koo doso. ");
INSERT INTO kkc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nee to ee tei goo. Esiga nayo nee to omaga diba nee odoo dalame peegoo pi magee. ");
INSERT INTO kkc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Esiga nayo a diye di egeesee solone, ayo diba nosee mipoo hagee ma kulodu diye deeso. ");
INSERT INTO kkc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Osoloso ayo diba halo a namapoo teneeso, diba nosee tei nee odoo doloso peegoo pi magoloso ka dabalame.” ");
INSERT INTO kkc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Esiga ayo hedebe mo hamamee dili odoo ee halo namapoo koo takooso. Esino diayo eligi goo ee duloso edebeeyo amapoo tei talai odoo sabolosee diba halo ka takooso. ");
INSERT INTO kkc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Osoloso Ma, ayo namapoo to egeesee ka taka. Ayo nobolo hedebe doloso egee bado, egeesee solone nei nayo abolo hedebe doloso ka badoso. Egeesee solone diba nosee hedebe doloso dabalame ka taka. Osoloso diba nosee ibolo hedebe doloso dabalame ka taka. Egeeseega mi odoo oso a tei nayo diye di goo mapoo tei ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Esiga toowa doloso badeli goo nayo amapoo tenee ee, see ayo dimapoo teneeso, diba dieso hedebe doloso dabalame. Egeesi ma kulodu iba nosee hedebe doloso egeesee ka doso. ");
INSERT INTO kkc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Esiga ayo dibolo hodobo badoso, osoloso nayo abolo hodobo badoso. Iyo egee do egeesi masi diba nosee hedebe doloso dabalai a goomogo. Eseega mi odoo oso goo egee ogoloso a tei nayo diye di goo ee gooleedalaiso. Osoloso nayo a diya sooloo dolone egee bado, egeesee solone nayo tei telaga odoo diya sooloo dolone egee bado goo sabolo mi odoo gooleedalaiso. ");
INSERT INTO kkc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Esiga Ma, tei telaga odoo nayo amapoo tenee hagee bia ee ayo badalai mi mapoo abolo hodobo dabalai, a goomogoso. Osoloso toowa doloso badeli goo ee nayo amapoo tenee ee diayo agalai, a goomogo. Mipoo moodelega molome, nayo a sooloo dolone, toowa doloso badeli goo egee nayo amapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Esiga Ma, hedebe no tekepo. Mi odoo oso no gooleedele. Esino ayo no ka gooleedoo. Osoloso nayo a diye di goo ee tei telaga odoo diba olo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ayo nee goo dimapoo olo yilige buguso, osoloso see yilige bigileiso, nayo a sooloo dolone egee bado goo egeesi masi oso dima kulodu ka malame. Osoloso anosee dibolo hodobo badalame.” ");
INSERT INTO kkc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuye Godee mapoo taka koodobuloso, see o hamamee dili odoo sabolo Kidilon howo tolobo dalo diso. Osoloso mi omapoo olipi segei homolee meleeso. Eseme Yesuye o hamamee dili odoo sabolo omapoo gadiso. ");
INSERT INTO kkc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Egeesi ma kulodu Yudas, Yesu ha teli odoo mapoo tiaseli odoo onosee homolee ee yo gooleedoo. Bei, biame abo mapoo Yesuye o hamamee dili odoo sabolo omapoo dileso mooloogoodeliso. ");
INSERT INTO kkc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Esiga Yudaseeye Loum ha teli odoo mooloogoodoo sabolo osoloso tei moso gidebeli odoo gilimado simiso. Tei moso gidebeli odoo hagee bia ee tei moso eyo wiligi odoo tebisa sabolo osoloso Pelisi odoo oso ka diye di. Diayo sibulone keme sabolo, egime sabolo, osoloso ha teli bi toloso sibileso peledabaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Eseme Yesuye goo susuga yimapoo peledabalai ee yo olo gooleedoloso malalo toboloso dimapoo egeesee takaso, “Niba odoo ogu esiamo silala?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eseme diayo nei yimapoo egeesee takaso, “Iba Nasalet odoo Yesu ee esiamo sila,” diso. Eseme Yesuye nei dimapoo egeesee takaso, “Niyo egee esiamo silo odoo ee aso,” diso. Epedee egeesee semelee mapoo Yesu ha teli odoo mapoo tiaseli odoo Yudas yinosee omapoo dibolo hodobo tebidiso. ");
INSERT INTO kkc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eseme Yesuye dimapoo takolone, odoo egee aso, dee taka duloso diba badayo dileso miyomoo misigedibaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Eseme Yesuye see tobu dimapoo egeesee woosaso, “Niba odoo ogu esiamo silala?” Eseme see diayo nei yimapoo egeesee takaso, “Iba Nasalet odoo Yesu ee esiamo sila,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eseme Yesuye nei egeesee takaso, “Odoo egee aso doloso ayo nimapoo olo takaso. Esiga niyo tei a esiamo silesiboga, odoo abolo hagee silesibo diba nosee diye dalai tekepo.” ");
INSERT INTO kkc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Esiga goo hagoso egeesee peledabaso. Bei, Yesuye daga o hamamee dili odoo sabolo silesibulone taka to sabolo tebilame. Bei, yayo egeesee ka taka, “Ma, odoo nayo amapoo tenee ee ayo diba medee bameleeso, odoo hee peegoo osugobele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eseme Saimon-Pitaye o kaiya tadoloso tei moso wiligi odoo taba eyo tou teli odoo hee Malakuseeyo dulu deedee dokolo ee kobuguso. ");
INSERT INTO kkc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Eseme Yesuye Pita mapoo egeesee takaso, “Nee kaiya egee o moso mapoo toose. Maye dala amapoo tenelame egee molo, ayo talai tekepo,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eseme Loum ha teli odoo mooloogoodoo toowa sabolo, osoloso dia wiligi odoo taba sabolo, osoloso Yu odoo dia tei moso gidebeli odoo oso Yesu toloso dee tiaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Osoloso diayo yo Kayapaseeyo nalobo Anas mapoo ido diso. Kayapas hagoso dugo omapoo tei moso wiligi odoo toboloso badebeiso. ");
INSERT INTO kkc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas hedebe hagoso daga Yesuwo goo maga Yu odoo dia wiligi odoo mapoo takolone, “Odoo hedebeso odoo susuga ee halo talai tekepo,” dee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Edebeeyo Yesu toloso ido dime, Saimon-Pita dio osoloso Yesu o hamamee dili odoo hee dio hamamee diso. Esino tei moso wiligi odoo taba oso odoo Pitabolo di ee yo olo gooleedooso. Eseme yayo Yesuye di hamamee deedee dileso, tei moso wiligi odoo taba eyo moso beelee ee ma kulodu gadiso. ");
INSERT INTO kkc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Esino Pita yo beelee osulu miyopoo tebidiso. Eseme odoo Pitabolo simi oso see osulu miyopoo wedi dileso, sobo osulu gibadeli mapoo takoloso, Pita kulodu ido diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Eseme sobo ogoso Pita ogoloso yimapoo egeesee woosaso, “No nosee, Yesu o hamamee dili odoo hee nosomo?” dee takaso. Eseme Pitaye nei egeesee takaso, “Haye, asonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Biame omapoo tei moso wiligi odoo taba eyo tou teli odoo abo sabolo osoloso tei moso gidebeli odoo diba diya kekeisime, dou toloso dou halagameleeso. Eseme Pita yinosee dileso dibolo hodobo tobudulone dou hameleeso. ");
INSERT INTO kkc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Biame omapoo tei moso wiligi odoo taba oso Yesu yayo eligi goo sabolo, osoloso o hamamee dili odoo dia goo ee yimapoo woosaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Eseme Yesuye nei yimapoo egeesee takaso, “Odoo susuga eyo howo woola ayo goo susuga hagee takomo sileeso. Osoloso ayo ibada howo gisili moso mapoo osoloso tei moso ma kulodu peleso odoo mapoo eligimo siliso. Bei, Yu odoo susuga oso sibileso omapoo mooloogoo deliso. Egeesi ma kulodu ayo goo hee mada takele. ");
INSERT INTO kkc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Esiga bei kasi maga nayo amapoo ka woosowala? Nayo odoo ayo eligime du mapoo woose. Bei, to ayo taka ee, diba gooleedooga.” ");
INSERT INTO kkc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuye goo hagee takeme, tei moso gibadeli odoo hee koola omapoo tebidi oso Yesuwo mudu mapoo kobugulone egeesee takaso, “Nayo ibada tei moso wiligi odoo taba mapoo to nei egeesee takalai tekeponee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Eseme Yesuye odoo yo kobugu mapoo nei egeesee takaso, “To ayo taka ee ma kulodu to tokenee hee taka daga, nayo goo egee woola odoo susuga hamapoo yebigi. Esino ayo tei goo takano, bei kasalame nayo a ka kobuguwo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Eseme Yesu o dee tia sabolo osee tobudume, Anaseeye tei moso wiligi odoo taba Kayapas mapoo ido diye diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon-Pita dou holone osee tobudume, odoo aboso yo ogoloso yimapoo egeesee takaso, “No Yesu o hamamee dili odoo hee nosomo?” diso. Eseme Pitaye egeesee takaso, “Haye, asonee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Eseme tei moso wiligi odoo taba eyo tou teli odoo hee omapoo tebidiso, yo odoo Pitaye dulu kobugu sabolo soosoo hedebe. Osoloso yayo Pita mapoo egeesee takaso, “Ayo no Yesubolo olipi segei homolee ma kulodu sileeme egeiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eseme Pitaye see tobu egeesee takaso, “Odoo egee asonee,” diso. Eseme epedee omapoo kolokolo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gesikolodee Yu odoo dia wiligi odoo oso Yesu Kayapaseeyo moso abaga see Loum gamalee odoo Pailet mapoo ido diso. Esino diba moso ee ma kulodu gadilega peegoo debeiso. Bei, diba goomegele, diayo Yu odoonee dia moso ma kulodu gaduga goo oso diba subugo kauwe dolone Gababia wo nelega peegeeyaga. ");
INSERT INTO kkc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Eseme Pailet peegoo dileso tobudulone dimapoo egeesee takaso, “Odoo hagoso goo kasi moodoowo, esiga niyo yo hamapoo ka ido simiyo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eseme diayo nei yimapoo egeesee takaso, “Odoo hagee goo hee tele diepi, iyo yo namapoo ido sibile pegeliyo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Eseme Paileteeye dimapoo egeesee takaso, “Niso yo ido dileso nibada tei magoo sabolo tebilame o goo midi,” dee takaso. Eseme Yu odoo dia wiligi odoo oso nei egeesee takaso, “Iyo yo wooloomalai goomogo. Esino iyo odoo wooloomalai Loum gamalee odooso imapoo kitulugu tenele,” ");
INSERT INTO kkc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Esiga goo hagoso olo peledabaso, Yesuye eyo talai goo ee takomo silee sabolo tebilame. ");
INSERT INTO kkc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yayo egeesee taka duloso Pailet yo see moso kulodu gadileso badolone, Yesu idoloso yimapoo egeesee takaso, “No tei Yu odoo dia wiligi odoo taba nosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Eseme Yesuye nei egeesee takaso, “Nayo amapoo egee woosa ee no goolee takala, o, odoo heeso mo goo ee namapoo takaga ka takala?” diso. ");
INSERT INTO kkc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Eseme Paileteeye nei egeesee takaso, “Hagee mo goonee. Bei, a Yu odoonee. Teiyo? Esino nee odoo sabolo, osoloso tei moso wiligi odoo tebisa oso no amapoo ido simiso. Esiga no goo kasi moodoowo?” ");
INSERT INTO kkc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eseme Yesuye nei egeesee takaso, “Ayo wiligi doloso badeli goo ee mipoo hamaga koo siboso. Egeesi ma kulodu ayo wiligi doloso badeli goo ee mipoo hamapoo meli diepi, Yu odooso a teyaga, mo tou teli odooso a galalo biligeliyo. Esino ayo wiligi doloso badeli goo ee mipoo hamaga koo siboso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eseme Paileteeye see egeesee takaso, “Esiga no tei wiligi odoo. Teiyo, ha?” diso. Eseme Yesuye nei egeesee takaso, “Nayo amapoo takolone, a tei wiligi odoo, dee takemeni, ee tei taka. A mipoo hamapoo soomagooso, ayo odoo mapoo tei goodee takomo silame. Esiga edebeeyo tei goo ma kulodu doga, diba mo to dulone ka doso.” ");
INSERT INTO kkc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Eseme Paileteeye nei egeesee takaso, “Tei goo ee ogoobo?” diso. Pailet see peegoo gadileso tobudulone Yu odoo dia wiligi odoo tebisa mapoo egeesee takaso, “Ayo odoo hamapoo goo hee koo ogo. ");
INSERT INTO kkc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Esino ayo nibada adaga dia goo ee dodolone, niyo Gababia wo ne biame mapoo, ayo odoo hee neliga moso ma kuloduga peegoo tamageliso. Esiga ayo Yu odoo nibada wiligi odoo hagee peegoo tamagalai, niba goomogosomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eseme diayo toso neligidi nei egeesee takaso, “Haye, odoo egee peegoo tamagalai, iba koo goomogo. Esino nayo Balabas ono peegoo ka tamagee,” dee takaga meleeso. Esino Balabas hagoso Loum odoo dia wiligi odoo tebisa mapoo ha temeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Osoloso Paileteeye o ha teli odoo mapoo takolone, Yesu toloso we tiso weeye, diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Eseme diayo yo wooloso we ti sidoloso, o wiligi mapoo mediso, osoloso wiligi odoo tebisa oso kali dugo bige sage yimapoo kadiso. ");
INSERT INTO kkc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Osoloso diayo yo manolone yimapoo takolone, “Yu odoo dia wiligi odoo taba, iyo nee hu dokodoo poudoso,” dolone o mudu mapoo kobugu demeleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eseme Paileteeye see o moso kuloduga peegoo gadileso tobudulone odoo mooloogoodoo mapoo egeesee takaso, “Niso be, ayo Yesu nimapoo ido sibileiso, ayo yimapoo goo hee egele poogoo goo nimapoo ee eligileiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yayo egeesee takeme, Yesu we ti sidoo o wiligi mapoo mediloso dugo bige sage ka sabolo peegoo gasimiso. Eseme Paileteeye dimapoo egeesee takaso, “Niso ege, odoo hagoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Eseme epedee omapoo tei moso wiligi odoo tebisa sabolo, osoloso tei moso gidebeli odoo oso yo ogoloso toso neligidi egeesee takaso, “Yo homo bulubo magoo ma dokodoo yoguso enige. Yo homo bulubo magoo ma dokodoo yoguso enige,” dee takemeleeso. Eseme Paileteeye dimapoo egeesee takaso, “Niso yo homo bulubo magoo ma dokodoo yoguso enigilame ido di. Bei, ayo yimapoo goo hee koo ogo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Eseme Yu odoo dia wiligi odoo tebisa oso nei yimapoo egeesee takaso, “Ibada tei magoo oso egeesee takooso, yo talai tekepo. Bei, yayo takolone, yo Godeeyo Owolo, dee takeliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","9","Esino Pailet goo hagee duloso diya obulone, see moso kulodu gadileso tobudulone, Yesu mapoo egeesee takaso, “No odoo ogu biayo?” dee takaso. Eseme Yesuye Paileteeye taka to eyo su nei takele. ");
INSERT INTO kkc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Eseme Paileteeye yimapoo egeesee takaso, “Nayo amapoo to nei takele poogoosoba? Bei, no gooleedeleyo, ayo no peegoo tamagee dee takalai, osoloso no homo bulubo magoo ma dokodoo yoguso enige dee takalai, amapoo kitulugu moloso?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eseme Yesuye nei yimapoo egeesee takaso, “Kitulugu epedee namapoo egee molo ee no goolee tele. Esino kitulugu hagee Godeeye namapoo ka tenee. Esiga odoo a toloso namapoo tenee eyo goo tokenee oso nee goo tokenee ee dagadileso ka moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paileteeye to hagee duloso, Yesu peegoo tamagalai yo goomogaso. Esino Yu odoo dia wiligi odoo tebisa oso to neligidi egeesee takaso, “Odoo agayo eyo nediliyo takolone yo wiligi odoo, dee takomo siloga, yo Loum wiligi odoo Sisa mapoo ha toso. Osoloso nayo odoo hagee peegoo tamagooga, no Sisayo odoonee,” dee takaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paileteeye to hagee duloso, Yesu peegoo ido sibileso, yo goo midili odoo oso bili mapoo biaso. Bili mi egee takolone, yopoo mi, deliso. Osoloso Hibulu toso takolone, Gabata, deliso. ");
INSERT INTO kkc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Esiga goo hagee diayo Gababia wo nali sadee ee ma kulodu dia hasali biame ee mopoodoo dalai biame mapoo ka peledaba. Epedee omapoo osoko howo olo oo domo talai koola tabaso. Eseme Paileteeye Yu odoo mapoo egeesee takaso, “Niso ege. Nibada wiligi odoo hagoso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eseme diayo toso neligidi egeesee takaso, “Yo wooloome. Yo wooloome. Yo homo bulubo magoo ma dokodoo yoguso enige,” dee takemeleeso. Eseme Paileteeye dimapoo egeesee takaso, “Niba goomogosomo, ayo nibada wiligi odoo ee homo bulubo magoo ma dokodoo yoguso enigilei?” dee takaso. Eseme tei moso wiligi odoo tebisa oso nei yimapoo egeesee takaso, “Ibada wiligi odoo hedebe Sisaso, odoo hee me,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eseme Yesu homo bulubo magoo ma dokodoo yoguso enigilame, Paileteeye yo dimapoo teneeso. Eseme o ha teli odoo oso Yesu toloso ido diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ha teli odoo oso Yesu toloso ido dulone, o homo bulubo magoo ee eyo eimaloso mi hee eyo hu wiligi ki mi deli mapoo ido diso. Mi hagee Hibulu toso takolone Gologota deli. ");
INSERT INTO kkc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Osoloso mi omapoo diayo Yesu homo bulubo magoo ma dokodoo yoguso enigaloso tuluguso. Osoloso odoo bakadio onosee homo bulubo magoo mapoo yoguso enigaloso, odoo hee Yesuwo deedee dokolo tulugu, osoloso hee dobusu dokolo tulugu diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Osoloso Paileteeye o odoo mapoo takolone, to hogugiye dee takeme, diayo to hageesee hoguguloso Yesuwo oo poogoo ma dokodooga kalamaso, ");
INSERT INTO kkc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Esiga to hogugu hagee Yu odoo dia to sabolo, osoloso Loum odoo dia to sabolo, osoloso Guliki odoo dia to oso hogugu. Esiga odoo susuga to hogugu egee ogoloso hesigaso. Bei, Yesu homo bulubo magoo ma dokodoo yoguso eniga mi ee Yelusalem maga haga hoogoonee. ");
INSERT INTO kkc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Egeesi ma kulodu tei moso wiligi odoo tebisa oso sibileso Pailet mapoo egeesee takaso, “Nayo to hogugulone, yo Yu odoo dia wiligi odoo taba doloso na hogugi. Esino hageesee hogugi, ‘Odoo hagoso takolone, yo Yu odoo dia wiligi odoo taba, dee takomo siliso,’ dee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Eseme Paileteeye nei dimapoo egeesee takaso, “To ayo hogugu hagee osee hogugu malaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ha teli odoo bakadio bakadio di oso Yesu homo bulubo magoo ma dokodoo yoguso enigaloso, o dugo diesono domo puloso tooso. Osoloso o sedi sage edebeeyo dusele poogoo sabolo diayo tooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Osoloso ha teli odoo dieso nei takoo nei takoo dolone egeesee takaso, “Iba dugo hagee wulo domo na didamo. Esino dugo hagee odoo agayo toowa beleso yoso dasigeli hee dasigalo ogomo,” diso. Osoloso goo hagoso olo peledabaso, Godeeyo to booka mapoo hogugu sabolo tebilame. Bei, Godeeyo to oso egeesee takooso, “Diayo mo dugo diesono puloso tooso. Osoloso mo dugo sage ee talame yoso dasigeli hee dasigaso,” diso. Esiga ha teli odoo oso goo egee moodooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Egeesee somolome, Yesuwo owee sabolo, osoloso oweeyo omolo sabolo, osoloso Kolopaseeyo osobo Meli sabolo, osoloso Meli-Magadalin oso Yesu homo bulubo magoo ma dokodoo molome, koola omaga tebisamolone balaga meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eseme Yesuye owee sabolo osoloso o hamamee dili odoo yayo diya gweli diba koola mapoo tebisamolome ogoloso owee mapoo egeesee takaso, “Mo wee, odoo hagee nowoloso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Osoloso see o hamamee dili odoo hedebe omapoo egeesee takaso, “No ege, noowee hagoso,” diso. Biame domo omaga Yesuwo hamamee dili odoo hagoso o moso mapoo Meli ido dileso medee bameleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Esiga goo hagoso dileso koodobume, tou susuga Godeeye Yesu mapoo tenee ee yayo olo hosudooso doloso gooleedooso. Egeeseelone Godeeyo to booka mapoo hogugu sabolo tebilame egeesee takaso, “A howo na poogoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi omapoo wain i koo hadali katolo mapoo keesoo ee magoo meleeso. Eseme odoo heeso homo sage toloso su mapoo dugo tialogoloso, wain i omapoo olugu doloso yayo nalame, Yesuwo maga mapoo heligiso. ");
INSERT INTO kkc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eseme Yesuye wain i egee olo naloso egeesee takaso, “Goo susuga olo hosudooso,” dee takaso. Osoloso oo goobodo buloso taso. ");
INSERT INTO kkc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Esiga biame egee Yu odooso hasali biame ee mopoodoo deli biame oso. Esino dia hasali biame egee goo diya toowa. Bei, Godeeye Gababia goo ee Yu odooso gooleebigili sadee ee ma kulodu hasali biame egee meleeso. Goo egeesi maga Yu odoo dia wiligi odoo tebisa oso dia hasali biame mapoo odoo ta eyo kou ee homo bulubo magoo ma dokodoo osee malai, diba goomegele. Esiga diayo Pailet mapoo egeesee takaso, “Odoo homo bulubo magoo ma dokodoo egee molo saga wedilame, dibada homo gebisa poogoloso, dia kou miyomoo tomeileso peegoo todi,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eseme ha teli odoo oso dileso odoo hee Yesuwo dee deedee dokolo eniga eyo homo gebisa poogooso. Osoloso see odoo hee Yesuwo dee dobusu dokolo eniga eyo homo onosee gebisa poogooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Esino diayo sibileso egeino, Yesu olo taneme, o homo gebisa pegele. ");
INSERT INTO kkc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Esino ha teli odoo heeso o molo toloso Yesuwo ho hodio mapoo guso. Eseme haga booloogelega, sawo sabolo osoloso howo sabolo moloso gu omaga sooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Esiga goo hagoso peledaba egei odoo oso goo hamaga tei goo takaso. Osoloso yo gooleedoo, yo tei goo takeli. Egeesi ma kulodu goo yayo taka hamapoo niyo tei talame ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Esiga goo hagoso tei peledabaso, Godeeyo to booka mapoo hogugu oso taka sabolo tebilame. Bei, Godeeyo to oso egeesee takooso, “O ki hee gebisa pagalaime,” dee takooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Osoloso Godeeyo to hogugu heeso see egeesee takooso, “Edebeeyo odoo dieso moloso gu mapoo balaga malaiso,” dee takooso. ");
INSERT INTO kkc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Osoloso hamamee, odoo hee Alimatiya mi mapoo badeli, o hu Yosep, yayo Yesuwo kou talame Pailet mapoo dileso woosaso. Yosep hagee Yesu o hamamee dili odoo hee yoso. Esino yo Yu odoo dia wiligi odoo tebisa ee bolo obulone, mada Yesuye di hamamee diliso. Eseme Paileteeye yimapoo kitulugu teneeso, yayo Yesuwo kou talame. Eseme Yosepeeye dileso Yesuwo kou ee homo bulubo magoo ma dokodooga miyomoo tomeileso peegoo todiso. ");
INSERT INTO kkc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Eseme Nikodimaseeye yo pidimo diso. Nikodimas hagee daga gesi Yesu agalame di odoo oso. Yayo sisigageli bi medee tekepo Yesuwo kou mapoo hedilame todiso. Sisigageli bi medee tekepo hagoso hegi ee 30 kilo egeesi masi. ");
INSERT INTO kkc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Osoloso odoo bakadio oso Yesuwo kou toloso, Yu odooso odoo toga mi dooseli goo ee dodolone, sisigageli bi medee tekepo oso Yesuwo kou mapoo hediloso dugo semeso tiegisaso. ");
INSERT INTO kkc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Egeesi ma kulodu Yesu homo bulubo magoo ma dokodoo eniga mi eyo koola omapoo homolee meleeso. Homolee ee ma kulodu bi dia yo ou poogoo mapoo daga odoo tayo kou magele poogoo meleeso. ");
INSERT INTO kkc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Esiga dia hasali biame bei mooloogalai koola tooboome, diayo Yesuwo kou toloso saga yo ou poogoo ee ma kulodu magooso. Bei, yo ou poogoo egee haga hoogooneega. ");
INSERT INTO kkc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sadee toowa gesikolo mi hadobilega molome, Meli-Magadalineeye Yesuwo bi agalame diso. Yayo sibileso egeino, yo toowaso wulu ou kisi ee peegoo bidigamo dileso molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eseme Meliye see hoguo dileso Saimon-Pita dio osoloso Yesuwo hamamee dili odoo yayo diya gweli mapoo egeesee takaso, “Lodeeyo kou peegoo todina. Osoloso diayo o kou todileso magoo mi ee, iba gooleedele,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Eseme Pita dio osoloso o hamamee dili odoo hee egee dio bi mapoo agalame diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Diba hoguo diyadaga molome, o hamamee dili odoo heeso Pita dagadileso bi mapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Osoloso yo gauwuloso yo ou poogoo ma kulodu keesee egeino, hedebe dugo seme Yesuwo kou tiegisa ono molome egeiso. Esino yo yo ou poogoo ma kulodu gadile. ");
INSERT INTO kkc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Eseme Saimon-Pitaye hamamee sibileso peledoboloso, yo ou poogoo ma kulodu gadileso egeino, dugo Yesuwo kou tiadoo hedebe ono omapoo molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Osoloso dugo Yesuwo wiligi tiadoo ee medee tiadoloso obusomo peegoo magoo molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eseme o hamamee dili odoo hee bi mapoo daga malalo peledaba oso yo ou poogoo ma kulodu gadiso. Yo gadileso goo hagee ogoloso tei tooso. ");
INSERT INTO kkc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Egeesi ma kulodu Godeeyo to booka mapoo hogugu oso takolone, yo ta maga hogaduloso gie badalaiso, dee taka goo eyo bei ee, diba medee kibiya gooleedelega osee debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Osoloso o bakadio see mosopoo wedi diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Esino Meli-Magadalin bi ma peegoo tobudulone pusumeleeso. Yo omapoo pusulone gauwuloso, yo ou poogoo ma kulodu keesee egeino, Godeeyo momaiye bakadio dugo heliye kalagaloso doboome egeiso. Momaiye heeso Yesuwo wiligi poogoo dokolo buo, osoloso heeso kai poogoo dokolo buo doloso doboome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eseme momaiye bakadio oso yimapoo egeesee takaso, “Sobo no, bei kaseega ka pusumalala?” dee takaso. Eseme Meliye dimapoo egeesee takaso, “Diayo mo Lodeeyo kou ee peegoo todina. Esino diayo o kou magoo ee a gooleedele,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Meliye to egeesee takoloso bidi toboloso keesee egeino, Yesu tobudo egeiso. Esino yayo goolee, Yesu odoo hee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eseme Yesuye yimapoo egeesee takaso, “Sobo no, bei kaseega ka pusumalala? Osoloso no odoo ogu esiamo silala?” dee takaso. Eseme Meliye goolee yo homolee mapoo tou teli odoo oso bele dolone yimapoo egeesee takaso, “Emegei, nayo Yesuwo kou peegoo todileso ka magoo daga, mi egee amapoo takee. Eseega ayo dileso o kou egee ka talaiya,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Eseme Yesuye yimapoo egeesee takaso, “Meli,” diso. Eseme Meliye bidi toboloso yimapoo Hibulu toso egeesee takaso, “Laboni.” To hageeyo bei ee eligili odoo dolone ka takooso. ");
INSERT INTO kkc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Eseme Yesuye yimapoo egeesee takaso, “A nayo na gide. Bei, a mo Ma mapoo wedi pele. Esino nayo dileso mo hamamee dili odoo mapoo takee, ‘A mo Ma Godee mapoo palame ka seeso. Ma Godee hedebe onosee dibada Godee osoloso nibada Godee,’ dee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eseme Meli-Magadalineeye see wedi sibileso Yesu o hamamee dili odoo mapoo egeesee takaso, “Ayo Yesu olo egeiso,” diso. Osoloso goo susuga Yesuye yimapoo taka ee see yayo dimapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sadee toowa habe omapoo Yesu o hamamee dili odoo oso Yu odoo dia wiligi odoo tebisa ee bolo obulone, hodobo mooloogoo doloso moso osulu medee kisigaloso debeiso. Eseme omapoo Yesuye sibileso peledoboloso tobudulone dimapoo egeesee takaso, “Mesie goo oso nibolo osee mele dee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yayo to egeesee takoloso tobudulone, o dee boowo sabolo, osoloso o ho hodio mapoo moloso gu eyo boowo ee dimapoo eligiso. Eseme Yesu o hamamee dili odooso yo ogoloso diya goomogaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Osoloso Yesuye see tobu dimapoo egeesee takaso, “Mesie goo oso nibolo osee mele dee. Esiga Maye a diye diga, ayo niba nosee diye deeso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesuye goo hagee takoloso see dimapoo magaso hologoo nilone egeesee takaso, “Niba Dio Tei te,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Osoloso see dimapoo egeesee takaso, “Niyo odoo heeyo goo tokenee boobado buguga, odoo egee bia dia goo tokenee ee hapoloso boobado bigileiso. Esino niyo odoo heeyo goo tokenee boobado bigilega poogooga, odoo egee bia dia goo tokenee ee hapoloso boobado bigileime,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Esino Yesu o hamamee dili odoo hee Tomas, o hu hee Didimas deli, yo Yesuye o hamamee dili odoo mapoo dileso peledaba biame mapoo yo omapoo badele. ");
INSERT INTO kkc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eseme Yesu o hamamee dili odoo oso yimapoo egeesee takaso, “Iba Lodee olo egeiso,” dee takaga meleeso. Esino Tomaseeye dimapoo egeesee takaso, “A niyo egee takoo duloso epedee tei talaime. Esino a mawo o dee boowo ogoloso mo dee woluguso omapoo sigo, osoloso o ho hodio mapoo moloso gu eyo boowo ee ogo doloso mo deeso omapoo sigoga, a tei ka talai,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Osoloso sadee hedebe poogoloso hamamee, Yesu o hamamee dili odoo oso moso hedebe mapoo mooloogoo doloso debeiso. Biame omapoo Tomas yinosee dibolo hodobo omapoo badebeiso. Esino diba osulu susuga kisigaloso doboome, Yesuye diayo debei domo mapoo peledoboloso tobudulone egeesee takaso, “Mesie goo oso nibolo osee mele dee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Osoloso tobudulone Tomas mapoo egeesee takaso, “Nee dee wolugu oso mo dee boowo hamapoo sigolo ege. Osoloso mo ho hodio mapoo moloso gu eyo boowo mapoo nee deeso sige. No goo haga na egege, esino amapoo tei te,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Eseme Tomaseeye nei yimapoo egeesee takaso, “Mo Lodee osoloso mo Godee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Eseme Yesuye yimapoo egeesee takaso, “Nayo a egeiga, amapoo tei ka toso. Esino edebeeyo a egelega poogoloso wulo amapoo tei toga, Godeeye nei dimapoo diya goomogalaiso,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Esiga Yesuye o hamamee dili odoo dia howo woola goo toowa opusomo di abo hee moodoogamo siliso. Esino goo egee booka hagee ma kulodu hogugule. ");
INSERT INTO kkc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Esino to hagee hoguguso, niyo Yesu yo tei Kelisodoo doloso goo omapoo tei talame. Osoloso niyo yo tei Godeeyo Owolodoo doloso goo omapoo tei talame. Osoloso yimapoo tei too goo maga gie badeli ka talame. ");
INSERT INTO kkc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Osoloso see hamamee Yesu o hamamee dili odoo oso Gelili abei palaga mapoo doboome, yayo omapoo peledabaso. Goo hagoso egeesee peledabaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Biame omapoo Yesu o hamamee dili odoo hagee biaso hodobo debeiso. Saimon-Pita, osoloso Tomas (o hu hee Didimas), osoloso Gelili mi toowa ee ma kulodu mi pepooko Kana mapoo badeli odoo hee Nataniyol, osoloso Sebediyo owolo bakadio, osoloso Yesu o hamamee dili odoo bakadio omapoo debeiso. ");
INSERT INTO kkc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Eseme Saimon-Pitaye o odoo mapoo egeesee takaso, “A pei olugulei dia,” diso. Eseme odoo aboso egeesee takaso, “Iba nobolo hodobo siba,” dee takaso. Eseme diba du mapoo hodobo tebisaso. Esino diba gesi di kobumo sileeno, di hedebe gile. ");
INSERT INTO kkc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Egeeseelone gesikolodee Yesuye abei palaga mapoo tobudume egeiso. Esino Yesu o hamamee dili odoo du ma kulodu tebisamolone Yesu ogoloso, diayo goolee yo odoo hee gooleeso. ");
INSERT INTO kkc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eseme Yesuye abei palaga maga tobudulone dimapoo egeesee idagaso, “Emegei, niba di giligasomo?” diso. Eseme diayo nei egeesee takaso, “Haye, iba di hedebe gile,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eseme Yesuye dimapoo egeesee takaso, “Nibada pei toloso see deedee dokolo mapoo olugi, egeeseega niba di giligileiso,” diso. Eseme diba Yesuwo to duloso goo egeesi moodooso. Eseme di bei dia pei ma kulodu galagadiso. Eseme diayo dia pei pouduloso du ma kulodu magalai tebile poogooso. ");
INSERT INTO kkc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eseme Yesu o hamamee dili odoo hee yayo diya gweli oso Pita mapoo egeesee takaso, “Egee yo Lodeedoo,” diso. Pitaye to egeesee taka duloso o dugo tigamagoo see kaloso Yesu mapoo tabuo dilame howomoo bologobuguso. ");
INSERT INTO kkc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Esino Yesu o hamamee dili odoo aboso du sumo dulone, dia pei ee di sabolo howo kulomooga abei pee mapoo gisibamo diso. Bei, diayo pei olugu omaga widi pee ee haga hoogoonee, wulo 100 mita egeesi. ");
INSERT INTO kkc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Osoloso diba sibileso dia du gimagoloso mubi mapoo daboogoloso egeino, dou hoo mapoo di sabolo wo sabolo si molome egeiso. ");
INSERT INTO kkc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Eseme Yesuye dimapoo egeesee takaso, “Di niyo epedee giliga egee abo hamapoo tosibe,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eseme Saimon-Pitaye du ma kulodu daboogoloso pei di sabolo widi pee mapoo gisibamo dileso booboosee mapoo gisubu magooso. Pei ee ma kulodu di toowa bei, 153 egeesi molome egeiso. Esino pei ma kulodu di bei galaga dino dia pei tologo bigile. ");
INSERT INTO kkc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Eseme Yesuye dimapoo egeesee takaso, “Niba nei nalame sibadee,” diso. Esino Yesu o hamamee dili odoo dima kulodu odoo heeso Yesu mapoo takolone, “no odoo ogumo?” dee takele. Bei, diba olo gooleedoo, yo tei Lodee. ");
INSERT INTO kkc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eseme Yesuye di sabolo wo sabolo toloso dimapoo teneeso. ");
INSERT INTO kkc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Esiga Yesu ta maga hogaduloso hamamee, o hamamee dili odoo mapoo peledaba hagoso bakadio hedebe diso. ");
INSERT INTO kkc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Osoloso diba nei naloso koodobuloso, Yesuye Saimon-Pita mapoo egeesee takaso, “Saimon, Yoneeyo owolo, nayo a gweli oso odoo hagee biaso a gweli ee dagadusomo?” dee takaso. Eseme Pitaye nei egeesee takaso, “O, Lodee. Ayo no diya goolee sabolo hagee bado goo ee, no gooleedoo,” diso. Eseme Yesuye nei yimapoo egeesee takaso, “Mo sipi be ee nayo medee poopoomelee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Osoloso Yesuye see tobu egeesee takaso, “Saimon, Yoneeyo owolo, nayo a diya goolee sabolo badosomo?” diso. Eseme yayo nei Yesu mapoo egeesee takaso, “O, Lodee. Ayo no diya goolee sabolo hagee bado goo ee, no olo gooleedoo,” dee takaso. Eseme Yesuye yimapoo egeesee takaso, “Mo sipi be nayo medee bamelee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Osoloso see bakadio hedebe di mapoo Saimon-Pita mapoo egeesee takaso, “Saimon, Yoneeyo owolo, nayo a diya goolee sabolo badosomo?” dee takaso. Eseme Pita to hedebe hagonosee Yesuye bakadio hedebe di taka ee duloso diya gooheleso. Esiga yayo nei egeesee takaso, “Lodee, goo susuga no gooleedooso. Osoloso ayo no diya goolee sabolo hagee bado goo ee, no olo gooleedooso,” diso. Eseme Yesuye yimapoo egeesee takaso, “Mo sipi be nayo medee poopoomelee. ");
INSERT INTO kkc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Esiga ayo namapoo tei taka. No gie kauwa mapoo bi medee mopoodoo doloso no goomoga mi mapoo diliso. Esino no adaga poloso badoga, odoo heeso nee dee mapoo tiso bagagoloso, no mi nayo goweli mapoo gisibado dileiso.” ");
INSERT INTO kkc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuye Pita mapoo taka hagee, Pitaye dooboo kasee talai goo ee taka. Esiga Pitaye ta maga Godeeyo hu dokodoo poudileiso. Osoloso Yesuye yimapoo mapoo egeesee takaso, “No a deedee,” diso. ");
INSERT INTO kkc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eseme Pitaye bidi toboloso egeino, o hamamee dili odoo Yesuye diya gweli oso dima miligiyopooga sibume egeiso. Yesuwo hamamee dili odoo hagee biaso daga o hamamee dili odoo sabolo nei nolone dobolone, Yesu mapoo bouwa melee oso, yimapoo egeesee ka woosa, “Lodee, odoo agayo no ha teli odoo mapoo ka tiasalaiyo?” dee taka odoo ee hagoso. ");
INSERT INTO kkc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Eseme odoo ogoso dima hamamee simi ee ogoloso, Pitaye Yesu mapoo egeesee takaso, “Lodee, odoo hamapoo kasee moodoolaisomo?” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Eseme Yesuye yimapoo egeesee takaso, “Yo osee badoga, ayo see wedi sibileso yo agalai, a goomogoga, egeesee selaiso. Esino egee nee goonee. No wulo a deedee,” dee takaso. ");
INSERT INTO kkc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eseme Yesu o hamamee dili odoo egee talaime, dee taka goo ee tei telaga odoo abo mapoo dudobuguso. Esino Yesuye takolone odoo egee talaime, dee takele. Yo wulo egeesee taka, “Yo osee badoga, ayo see wedi sibileso yo agalai, a goomogoga, egeesee selaiso. Esino egee nee goonee,” dee ka taka. ");
INSERT INTO kkc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Esiga Yesu o hamamee dili odoo hagoso goo susuga yayo egei ee booka hamapoo hoguguso. Iba gooleedooso, goo susuga yayo hogugu ee tei goo. ");
INSERT INTO kkc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Esiga Yesuye goo hagee sabolo osoloso goo abo sabolo olo moodooso. Esino goo susuga egee booka hamapoo hogugule. Esino goo susuga egee booka abo mapoo hogugu diepi, mipoo hamapoo booka bei meliyo. Egeeseelone booka magalai debi me meliyo. ");
INSERT INTO kkc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiyopoles emegei, Ayo daga namapoo booka hoguguloso tenee omapoo, Yesuye goo tomo sili sabolo yayo eligi goo sabolo hoguguso. Osoloso yo kei mi mapoo ido palai goo sabolo hoguguso. Osoloso yo kei mi mapoo ido pelega badolone, Dio Tei oso kitulugu maga diye di odoo yayo gilimadoo odoo dimapoo kokodo takaso. ");
INSERT INTO kkc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Osoloso Yesu toloso midoo maga hogabuloso biame 40 eyo kulodu yayo tei hogabia goo ee diayo ogoloso tei talame yayo silone, o hamamee dili odoo mapoo peledoboo demeleeso. Osoloso dibolo silone, Godeeye wiligi doloso badeli goo dimapoo takomo siliso. ");
INSERT INTO kkc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Osoloso biame hedebeso Yesu o hamamee dili odoo gilimadoloso nei nolone badolone, Yesuye to kitulugu sabolo takaso, “Niba Yelusalem poogoloso na di! Esino mo Maye taka Dio Tei oso sibilei omapoo dulone bolone ka debee, bei mo Maye to hagee nimapoo olo takaso. ");
INSERT INTO kkc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Esiga Yoneeye niba howodeeso ogusigaso, esino biame koola mapoo Dio Tei oso sibileso nimapoo kitulugu tenelaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Eseme diye di odoo Yesubolo Olipi mubi mapoo mooloogoodoloso dobolone, diayo yimapoo woosaso, “Lodee, nayo epedee hamapoo Isalael odoo oso ibada mi gidabalame kitulugu see imapoo tenelaisomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Eseme Yesuye dimapoo nei egeesee takaso, “Hedebe Maye biame hageesi yayo kitulugu sabolo mageliso. Esiga biame egeesi niyo gooleedalai nibada goonee. ");
INSERT INTO kkc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Esino Dio Tei nimapoo meledobooga, niba kitulugu talaiso. Osoloso niyo mo goo mi toowa mapoo takomo dileiso, Yelusalem abaga bei mooloogoloso abaga dino, Yudiya mi toowa mapoo, osoloso Samaliya abaga dino mi toowa hoopoogoo mapoo takomo dileiso.” ");
INSERT INTO kkc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesuye to hagee takoloso tobudulone, diayo balaga molome, Godeeyo kitulugu oso kei mi mapoo yo ido palaso. Eseme kei ma dokodooga kolobo oso sibileso Yesu gooloogoo bugume diayo egele poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Diba Yesuye kei ma dokodoo pala mapoo osee balaga molome, odoo bakadio dugo heliye megiga oso dima koola omapoo saga sibileso, tebisa meleeso. ");
INSERT INTO kkc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Diayo egeesee takaso, “Gelili odoo, niba bei kasi maga kei ma dokodoo ka balaga malala? Nibada howo woola Godeeye Yesu kei mapoo ido palaso. Esiga Yesu kei ma dokodoo poolome niso egemenee, yayo hamamee kolobo ma dokodooga, see egeesee siboga agalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Diye di odoo oso Yesu kei mi ma dokodoo pala ogoloso, Olipi mubi maga Yelusalem mapoo wedi diyadeeso. Yelusalem ee Olipi mubi abaga hoogoonee. ");
INSERT INTO kkc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Diba Yelusalem mapoo peledoboloso, diso debeli moso mapoo paladeeso. Odoo abo hagoso moso eyo kulodu debeiso: Pita, Yonee, Yemes, Endulu, Pilipi, Tomas, Batolome, Matiyu, Alpiyeseeyo owolo Yemes, Saimon (daga Loum gamalee maga ha teli odoo), osoloso Yemeseeyo owolo Yudas. ");
INSERT INTO kkc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Diye di odoo, sobo abo sabolo, osoloso Yesuwo owee Meli sabolo, osoloso Yesuwo omolo dio sabolo hagee hodobo mooloogoodoloso biame susuga Godee mapoo takeliso. ");
INSERT INTO kkc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Biame hedebe mapoo tei telaga odoo susuga 120 oso hodobo mooloogoodoloso doboome, Pitaye toboloso dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Mo odoo, ayo Yudaseeyo goo nimapoo taka. Yo ibada mooloogoodoo ma kulodu Godeeyo tou hodobo tomo siliso. Esino yayo Yesu ha teli odoo mapoo tiasooso.” (Eseme tei moso wiligi odoo tebisa oso Yudas yimapoo molee teneme, yayo molee oso mi su neiso tooso. Osoloso yo mi omapoo dileso, miyomoo homodobuloso, beliye tologonuloso, kakobo gwadobuloso taso. Eseme Yelusalem mapoo debeli odoo susuga oso goo hagee duloso, mi egee dibada toso hu egeesee hediso, “Akeledama.” Hu hageeyo bei, “sawo go.”) Eseme Pitaye see egeesee takaso, “Esiga Godeeyo to booka mapoo hogugu oso tei diso. Bei, Dio Tei oso Deibidi mapoo eligi maga yayo Yudaseeyo goo daga hoogoo Godeeyo to hogugu Sam booka mapoo egeesee hoguguso, ‘O mi mapoo odoo mauwe pagalaiso. Odoo heeso omapoo badalaime.’ Osoloso see egeesee hoguguso, ‘O tou su see odoo heeso talaiso,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pitaye see egeesee takaso, “Esiga Yudaseeye tou teli ee see odoo heeso talame odoo hee hesiamo. Yayo ibolo silone Yesuye toloso hogabia goo ee takomo silame. Osoloso odoo yayo biame susuga ibolo hodobo silone, Yonee odoo howo ogusiga molome egei sabolo, osoloso abaga simino Yesuye kei ma dokodoo polome egei odoo ee hesileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eseme tei telaga odoo susuga oso Yosep dio Matiyas dio hesiaso. Yosep hagee hu bakadio hedebe di (Balasabas osoloso Yustus). ");
INSERT INTO kkc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Diayo odoo bakadio hagee hesialoso dobolone Yesu mapoo egeesee takaso, “Lodee, no odoo susuga oso goo goolee no gooleedooso. Esiga odoo bakadio hamapoo nayo hesia imapoo eligi, yayo Yudaseeyo debi omapoo badolone, diye di odoo eyo tou su ee talame. Bei, Yudas yo tokenee tooga, eyo nei yo dou mi mapoo diso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Diayo Yesu mapoo taka koodobuloso, diye di odoo heeso yo bakadio toloso hee mapoo Matiyaseeyo hu magoo, osoloso hee mapoo Yosepeeyo hu magoo doloso toloso halabume, yo hedebe miyomoo homodobiaso, diayo odoo bakadio hesia ma kulodu Godeeye hesia odoo ee talame. Diayo egeesee moodooloso, odoo hedebe Matiyas tooso. Eseme yo diye di tou ee talame diye di odoo 11 sabolo hedebe diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos biame omapoo, tei telaga odoo susuga moso hedebe mapoo mooloogoodoloso debeiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Eseme haga booloogelega kei ma dokodooga iso goowa masi oso diayo mooloogoodoloso debei moso omapoo tooso. ");
INSERT INTO kkc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eseme dou paiya masi oso odoo susuga moso kulodu mooloogoodoloso debei, dimapoo tugusume egeiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eseme Dio Tei oso dibada kulodu meledoboloso molome, Dio Tei oso kitulugu maga to opusomo opusomo di kesaso. ");
INSERT INTO kkc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Biame omapoo Godeeyo goo diya gooleedoo Yu odoo mi susuga maga sibileso, Yelusalem mapoo debeiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Esino diba iso goowa masi goowa ee duloso, goo ee agalame sibadeeso. Diba sibileso egeino, tei telaga odoo susuga oso to opusomo opusomo di kesamolome duso. Diayo to opusomo opusomo di kesamelee ma kulodu diayo dibada to kei duloso, diya howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eseme diba howoogadoloso goo tiadoo sabolo dobolone egeesee takaso, “Odoo to egee kesa, Gelili odoo oso kesa. ");
INSERT INTO kkc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bei kasi maga diayo ibada to kesa iyo ka dusomo? ");
INSERT INTO kkc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bei, iba mi opusomo opusomo di hamaga sibadee odoo: Patiya abaga, osoloso Mediya, Elam, Mesopotamiya, Yudiya, Kapadokiya, Pontus, Asiya, ");
INSERT INTO kkc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Piligiya, Pampiliya, Isipi, Libiya mi toowa ma kulodu mi pepooko Kulene abaga sibadee. Osoloso odoo abo Loum mi abaga sibadee. Osoloso Yu odoonee abo Loum mi abaga sibadee oso, Yu odoowo Godee mapoo tei too maga, Yu odoowo hu too odoo oso. Osoloso odoo abo Kiliti sabolo Alabiya mi abaga sibadee odoo oso. Iba mi opusomo opusomo di omaga sibadee oso. Esino diayo ibada to keseme duso. Esiga diayo to hagee boowoo Godeeye goo toowa moodoo maga ka boowoo,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Diba howooga sabolo, goo tiadoo sabolo, dobolone dieso nediliyo egeesee takaso, “Hagee ogoo goowo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Esino odoo abo Yelusalem mapoo sibadee oso tei telaga odoo dimapoo manolone dieso nediliyo egeesee takaso, “Odoo hagee yugune naloso ka halabaga,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eseme Pitaye goo hagee duloso, diye di odoo sabolo tebisaloso to neligidi takolone, odoo mooloogoodoo mapoo egeesee takaso, “Yu odoo Yelusalem mapoo debeli sabolo, osoloso odoo soo sibadee, niba mo to hagee medee dui! ");
INSERT INTO kkc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Odoo abo niyo imapoo takolone, iba yugune naloso ka halabaga, diso. Esino iba egeesee koo seeso. Bei, gesikolo osoko simi domo taba mapoo, edebeeyo yugune naloso koo halabagali. ");
INSERT INTO kkc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Esino to niyo du sabolo, osoloso goo niyo egei sabolo egee, Godee maga to toloso kokodo takomo sili odoo Yoweliye to taka goo sabolo olo teibaso: ");
INSERT INTO kkc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Godeeye egeesee takaso, “Biame hamameedee omapoo ayo Dio Tei odoo susuga mapoo tenelaiso. Osoloso nibada giso holaiso sabolo, sobo holaiso sabolo, oso to Godeeye taka goo ee takalaiso. Nibada holaiso gie kakauwa oso howo opusomo doloso, Godee maga simi goo ee agalaiso. Osoloso nibada adaga oso Godee maga simi goo ee sapootileiso.” ");
INSERT INTO kkc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Osoloso Godeeye see egeesee takaso, “Biame hamameedee omapoo mo tou teli odoo susuga, giso sabolo, sobo sabolo, dimapoo Dio Tei tenelaiso. Osoloso diayo Godeeye taka to ee duloso odoo mapoo takalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Osoloso kei ma dokodoo osoloso mi hamapoo goo mudu opusomo di moodoolaiso. Biame omapoo mi toowa hamapoo niyo ha too sabolo, dou sabolo, osoloso dei i toowa sabolo agalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Osoloso kei ma dokodoo osoko neligidi bigileiso. Osoloso a see sawo masi bigileiso. Goo egeesi oso peledobooga, Lodeeyo biame goo toowa oso sibilei koola toobooga ka selai. ");
INSERT INTO kkc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Osoloso edebeeyo Lodeeye pidilame yimapoo woosaga, nei yayo yimapoo gie badeli tenelaiso.” ’ ");
INSERT INTO kkc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Esiga Isalael odoo, niba to hagee dui! Yesu, Nasalet odoo, Godeeye niba gooleebugulone hesiaso. Osoloso Yesuye nima kulodu goo mudu opusomo opusomo di moodoomo silone, Godeeye yo hesia goo ee woola yilige buguso. Esiga goo oso peledaba niba gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Esino Godee eyo goomoga maga daga hoogoo Yesu toloso nimapoo tenelame to takoloso magooso. Egeesi maga yayo Yesu toloso nimapoo teneme, Yu odoo niyo osoloso Godeeye tei magoo mapoo koo mesili odoo sabolo oso yo homo bulubo magoo ma dokodoo yoguso eniga maga yo wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Esino Godeeye Yesu dala teli goo maga peegoo tamagalame, Godeeye yo ta maga hogabidiso. Bei, teli oso yo talai tebile. ");
INSERT INTO kkc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Esiga ibada amawe wiligi odoo taba Deibidiye Yesuwo goo Godeeyo to booka mapoo hogugu maga egeesee takooso, ‘A biame susuga Godeeye mo mudugiyopoo tobudo doloso gooleedeliso. Yo koola mapoo tobudoso. Esiga a ebileime. ");
INSERT INTO kkc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Esiga mo sooloo ma kulodu goomoga toowaso molone, goomoga goo hagee ka taka. A tei toso, mo su see gie badalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bei, Godee nayo a toga mo gie badeli ee odoo wedia eyo dio oso debeli mi mapoo a pagalaime. Nayo hesia odoo eyo su midoo ma kulodu hunulame pagalaime. ");
INSERT INTO kkc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Osoloso gie badeli eli nayo amapoo eligiso. Esiga ayo nobolo badolone, diya goomogalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Emegei, Deibidiye goo taka hagee, yayo o goo eyo nediliyo takele. Bei, yo teme midoosooso. Osoloso midoo ibolo moloso. ");
INSERT INTO kkc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Esiga Godee maga to toloso kokodo takomo sili odoo daga malalo badebeiso. Esiga Godeeye to takoloso magoo ee gooleemeleeso. Bei, Godeeye yimapoo to magolone egeesee takaso, ‘Deibidiyo amawe heeso Deibidiye wiligi doloso badeli mi omapoo, see yayo wiligi doloso badalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Esiga Deibidiye malalo hoogoo peledabalai goo ee ogoloso, Godeeye hesia Kelisoye midoo maga hogabilei maga egeesee takaso, ‘Godeeye yo midoo mapoo pagalaime, osoloso o su hunuleime,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Esiga Godeeye Yesu ta maga see gie badeli mapoo hogabidiso. Goo ee iyo susuga ogoloso ka takomo siloso. ");
INSERT INTO kkc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Osoloso Godeeye Yesu kei ma dokodoo ido peleso, o dee deedee dokolo badoso, yayo yimapoo hu toowa tenelame. Osoloso yayo to magoo ee dodolone, o Dio Tei Yesu mapoo teneme, see Yesuye imapoo teneeso. Goo hagee niyo epedee hamapoo ogolone dulone ka badoso. ");
INSERT INTO kkc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Esiga Deibidi yo kei ma dokodoo pele. Haye! Yayo taka egee Yesuwo goo ee taka, ‘Godeeye mo Lodee mapoo takaso: No abolo wiligi doloso badalame mo dee deedee dokolo bie. ");
INSERT INTO kkc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Esiga nayo badolone namapoo ha teli odoo ee ayo dagadileiso.’ ");
INSERT INTO kkc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Esiga Isalael odoo, niba goo hagee medee goolee! Niyo Yesu homo bulubo magoo ma dokodoo yoguso eniga ee, Godeeye yo Lodee wiligi toowa taba doloso hudi magoo Keliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eseme odoo mooloogoodoo oso to hagee duloso, dieso nediliyo dibada goo tokenee gooleedoloso, sooloo dala sabolo, ebia sabolo, Pita diye di odoo abo sabolo mapoo egeesee takaso, “Emegei, iyo ogoo goo moodoolaiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Eseme Pitaye dimapoo nei egeesee takaso, “Niba susuga nibada goo tokenee maga miligi pialoso, Yesu Kelisowo hu maga howo ogusige. Egeeseega nibada goo tokenee hapoloso boobado bigileiso. Egeeseega niba Godeeye Dio Tei wulayo egee tenemolo niyo talaiso. ");
INSERT INTO kkc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bei, Godeeye to magoo ee dodolone, yayo Dio Tei nimapoo, osoloso nowolo dimapoo, osoloso eli sage debeli odoo dimapoo tenelaiso. Osoloso odoo susuga Godeeye gilimadalai goo ee dimapoo tenelaiso.” ");
INSERT INTO kkc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eseme Pitaye to sage takolone kokodo takaso, “Goo tokenee teli odoo epedee hamapoo egee do dala talaiso. Esiga niba dala teyaga, goo tokenee ee pagalame Godeeye pidilame yimapoo takee.” ");
INSERT INTO kkc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eseme odoo Pitayo to duloso, tei too odoo diba howo ogusigaso. Esiga biame omapoo 3,000 odoo oso howo ogusigaloso, tei telaga odoo sabolo hedebe doloso mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Osoloso diba howo ogusigaloso, biame susuga eyo kulodu diesono mooloogoodoloso, diye di odoo oso eligime, medee duluga meleeso. Osoloso diba Lodee gooleebugu wo nalagamo silesibulone, biame susuga Godee mapoo takeliso. ");
INSERT INTO kkc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Diye di odoo diayo Godeeyo kitulugu sabolo goo mudu opusomo opusomo di moodoogamo silesibume, odoo susuga oso ogoloso diya ebia sabolo howoogadooso. ");
INSERT INTO kkc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Osoloso tei telaga odoo susuga oso biame susuga hodobo mooloogoodoloso, bi nei pidi, nei pidi deliso. ");
INSERT INTO kkc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Egeeseemo silesibulone, dibada mi sabolo, bi sabolo, odoo mapoo teneloso, nei molee tooso. Osoloso molee oso tei telaga odoo abo bi mauwe odoo ee pidigamo siliso. ");
INSERT INTO kkc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Osoloso biame susuga diayo howo gisilame, Yu odoowo tei moso beelee ma kulodu hodobo mooloogoo deliso. Osoloso diayo Yesu gooleebugu wo nolone, diba moso opusomo opusomo di mapoo nalagaliso. Osoloso diayo silesibulone, dibada sooloo ma kulodu goo goolee hedebe doloso, goomoga goo Godee mapoo poudiliso. Eseme Yelusalem odoo susuga oso dibada goo ogoloso tekepo deliso. Osoloso Lodeeye biame susuga odoo abo mapoo gie badeli teneliso. Egeeseelone tei telaga odoo bei deliso. ");
INSERT INTO kkc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Biame heeso habe Yu odooso Godee mapoo takeli osoko howo teme, Pita dio Yonee dio Yu odoowo tei moso mapoo palaso. ");
INSERT INTO kkc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Diba omapoo peleso egeino, odoo kido todobia osulu mi eyo hu Osulu Medee Tekepo deli omapoo badoboome egeiso. Odoo hagee soomagolone kido todobia sabolo soomagooso. Esiga biame susuga o odoo abo oso yo sa mapoo magoloso imado peleso, osulu mi hamapoo ka ibedi deliso. Osoloso yo omapoo badolone, odoo tei moso mapoo pala ogoga, yayo dimapoo molee howaliso. ");
INSERT INTO kkc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yo omapoo howolone badolone egeino, Pita dio Yonee dio moso kulodu gadime, dimapoo molee howaso. ");
INSERT INTO kkc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eseme Pita dio Yonee dio yimapoo bolone, Pitaye yimapoo egeesee takaso, “Imapoo ege!” diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eseme yayo goolee, yimapoo molee tenelame kasabele dolone dimapoo egeiso. ");
INSERT INTO kkc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Eseme Pitaye yimapoo egeesee takaso, “Amapoo molee tei mauwe. Esino goo hagee amapoo egee molo wulo namapoo tenelaiso. Esiga ayo Yesu Keliso Nasalet odoowo hu maga namapoo ka taka, no toboloso di,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yayo egeesee takoloso, odoo kido todobia o dee deedee mapoo toloso tebidime, o kido see tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yo o kido tekepo poloso silone, Pita dibolo tei moso ma kulodu galaga diso. Yo tei moso ma kulodu gadileso pupulodomo silone, Godee mapoo goomoga poudooso. ");
INSERT INTO kkc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Odoo susuga oso odoo kido todobia yayo Godee mapoo goomoga poudoomo sili ogoloso howoogadooso. Osoloso dieso nediliyo egeesee takaga meleeso, “Odoo hagee kido todobia Osulu Medee Tekepo deli eyo osulu miyopoo badolone molee howali hagoso. Esino yo kasee toboloso silone, goo hageesi ka tomo silosomo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Odoo daga kido todobia oso Pita dio Yonee dio dee mapoo toloso, Solomonowo hau mapoo silesibi ogoloso, odoo susuga oso howoogadoloso, diayo debei omapoo hoguga sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Eseme Pitaye odoo susuga ogoloso, dimapoo egeesee takaso, “Isalael odoo, niba bei kasi maga ka howoogowala? Osoloso bei kasi maga niyo imapoo bologolone, goo diya ka tiadowala? Bei, odoo hagee ibada kitulugu sabolo osoloso iyo tekepo doloso debei maga tekepo poloso koo siloso. ");
INSERT INTO kkc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Esino Eibalaham, Aisek, Yekob, osoloso ibada amawe dibada Godeeye o tou teli odoo Yesu mapoo kitulugu toowa olo teneloso, o hu dokodoo poudooso. Esino diayo yo wooloomalame, niyo yo Yu odoowo wiligi odoo tebisa mapoo teneeso. Osoloso yo goo midilame Pailet mapoo ido dime, Paileteeye egeesee takaso, ‘Ayo yimapoo goo tokenee koo ogo,’ dee takeme, niyo yo goweso. ");
INSERT INTO kkc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Esino Yesu tekepo, tokenee mauwe odoo oso. Esino niyo yo gowoolone, Balabas odoo wooloomali odoo ee Paileteeye neliga moso ma kuloduga peegoo di diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Esino niyo Yesu gie badeli teneli wooloomaso. Esino Godeeye yo ta maga see hogadiso. Esiga yo ta maga see hogabuloso silime, iyo egei goo ee ka takomo siloso. ");
INSERT INTO kkc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Esiga odoo kido todobia oso Yesu mapoo tei too maga yo tekepo paso. Esiga niba odoo hagee gooleedooso, yo daga kido todobuloso badebeiso. Esino yayo Yesuwo kitulugu mapoo tei too maga odoo susuga oso balaga molome, yo tekepo paso.” ");
INSERT INTO kkc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Osoloso Pitaye odoo mooloogoodoo mapoo see egeesee takaso, “Emegei, a gooleedooso, nibada wiligi odoo tebisa sabolo oso Yesu boobadolone, yimapoo goo moodoo eyo bei niba gooleedele. ");
INSERT INTO kkc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Esino daga hoogoo Godeeye o odoo yimaga to toloso kokodo takomo silesibili odoo dimaga Kelisoye dala talai goo ee malalo olo takaso. Esiga goo hagee peledabalame Godeeye moodooso. ");
INSERT INTO kkc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Esiga nibada goo su wuduloso, goo tokenee maga miligi pialoso, Godee mapoo bidiga debee. Egeeseega Godeeye nibada tokenee hapoloso boobado bigileiso. Nibada goo su wuduloso, goo tokenee maga miligi pialoso, Godee mapoo bidiga dobooga, Godeeye nimapoo kitulugu dia tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Osoloso owolo Yesu, Godee yayo hesia Keliso nimapoo di dalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Esiga epedee biame hamapoo Yesu kei ma dokodoo badoso. Yo kei ma dokodoo badolone Godeeye goo susuga dia daga, omapoo sibileiso. Esiga Godeeye o odoo yimaga to toloso kokodo takomo silesibili hesia odoo daga hoogoo debei dimaga goo hagee olo takaso. ");
INSERT INTO kkc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Esiga Godee maga to toloso kokodo takomo sili odoo hee Moseseeye Godeeyo to booka mapoo egeesee takaso, ‘Godeeye niba gooleebugulone, nima kuloduga o odoo yimaga to toloso kokodo takomo sili odoo hee a egeesi masi hesileiso. Esiga goo susuga yayo taka mapoo medee dui. ");
INSERT INTO kkc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Osoloso edebeeyo o to duloso, tei telega poogooga, odoo ee Godeeyo mooloogoodoo ma kuloduga peegoo peledoboloso, talaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Godee maga to toloso kokodo takomo sili odoo hee Semuweleeyo hamamee tebisa sabolo oso epedee biame hamapoo peledabalai goo ee takaso. ");
INSERT INTO kkc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Esiga Godeeye nibada amawe sabolo, osoloso o odoo yimaga to toloso kokodo takomo silesibili odoo daga hoogoo debei sabolo, oso to magoo ee nibada. Bei, yayo Eibalaham mapoo egeesee takaso, ‘Namawe hee maga ayo odoo susuga mi toowa mapoo hagee do ee pidileiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Esiga Godeeye hesia tou teli odoo Yesu ee nimapoo di diso, niyo malalo to tekepo dulame. Esiga yayo niba pidi maga nibada goo goolee mudu opusomo doloso, nibada tokenee maga miligi pilame,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","4","Pita dio Yonee dio odoo mooloogoodoo mapoo to takolone Yesuye ta maga hogabia eyo goo takaga meleeso. Esiga diayo egeesee takaso, “Yesu ta maga hogabia maga niba ta maga see hogabileiso,” diso. Eseme omapoo Pitaye to taka duloso tei telaga odoo sabolo, osoloso daga tei telaga odoo sabolo, hodobo mooloogoodeme 5,000 tugodooso. Eseme tei moso wiligi odoo tebisa sabolo, tei moso gidebeli odoo dia wiligi odoo taba sabolo, Sedisi odoo sabolo sibileso, Pitaye Godeeyo to takolone, ta maga see hogabilei goo maga taka duloso, diya kamanaso. Osoloso diayo Pita dio Yonee dio tooso. Osoloso olo neligime diba epedee neliga moso tegei ma kulodu toosooso, osoloso see gesikolo Yu odoowo wiligi odoo tebisa mapoo ka ido dilame. ");
INSERT INTO kkc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Osoloso gesikolo Yu odoowo tei moso wiligi odoo tebisa sabolo, osoloso Yu odoowo wiligi tebisa adaga susuga sabolo, osoloso Godeeye tei magoo ee eligili odoo susuga sabolo, Yelusalem mapoo mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dibada mooloogoodoo ma kulodu tei moso wiligi odoo taba Anas sabolo, o soosoo Kayapas sabolo, Yonee sabolo, Alesanda sabolo, osoloso o soosoo abo sabolo mooloogoodooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Esiga wiligi odoo tebisa susuga oso omapoo mooloogoodoloso dobolone, diayo odoo abo oso Pita dio Yonee dio ido sibe, diso. Eseme Pita dio Yonee dio omapoo doboome, wiligi odoo tebisa oso dimapoo egeesee woosaso, “Niyo odoo kido todobia tekepo kasee moodoowo? Niba agamo kitulugu osoloso agamo hu maga yo tekepo ka payo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita Dio Tei oso kitulugu toloso badolone Dio Tei maga dimapoo to nei egeesee takaso, “Wiligi odoo tebisa sabolo, Yu odoowo wiligi tebisa adaga sabolo, niba mo to dui. ");
INSERT INTO kkc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Niba iyo odoo kido todobia yo pidilone tekepo moodoome niyo ogoloso, ibada goo midilame ka ido diala? Niba yo tekepo pa eyo bei gooleedalai goomogosomo? ");
INSERT INTO kkc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Esino nibolo Yu odoo susuga sabolo goo hagee gooleedalai tekepo. Bei, Yesu Keliso, Nasalet odoo, niyo woolooma Godeeye ta maga hogadi eyo kitulugu maga, iyo epedee niyo egee ogo odoo hagee olo tekepo paso. ");
INSERT INTO kkc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Esiga Yesuwo goo maga Godeeyo to booka mapoo hogugu oso egeesee takooso, ‘Moso tegeli odoo diayo omou gowoolone togobugu oso epedee hamapoo moso omu domo pupodoo ka moloso.’ ");
INSERT INTO kkc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Esiga Yesu mapoo gie badeli teneli ka moloso. Esiga mi toowa hamapoo odoo hee mauwe edebeeyo badoboso gie badeli talai, hedebe Yesu yimapoo moloso.” ");
INSERT INTO kkc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Eseme Yu wiligi odoo tebisa oso Pita dio Yonee dio dimapoo ebilega, diayo dimapoo to nei tekepo taka duloso, diba diya howoogadooso. Pita dio Yonee dio sukulu tele osoloso wulo mosoowe odoo. Eseme wiligi odoo tebisa oso egeesee gooleedooso, odoo bakadio hagee Yesubolo silidoo, diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Osoloso diayo Pita dio Yonee dio odoo kido todobia tekepo moodooloso, Pita dibolo tebisa melee ogoloso, wiligi odoo tebisa oso to nei takele poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Diayo to nei takalai mauwe poogoome, Pita dio Yonee dio moso kuloduga peegoo galaga diye doloso, balaga melee diso. Osoloso wiligi odoo tebisa diesono to mouso. ");
INSERT INTO kkc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Eseme diesono to moulone egeesee takaso, “Iyo dimapoo ogoo goo moodoolaisomo? Bei, Yelusalem odoo susuga oso diayo mudu opusomo di goo toowa moodoo egee egeiso. Esiga iyo goo hamapoo gamenee takalai tekeponee. ");
INSERT INTO kkc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Esiga goo hageesi oso toowa diyaga, odoo bakadio hagee toloso, see Yesuwo hu maga odoo susuga mapoo na eligimo silesibe, kitulugu sabolo egeesee takalaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Esiga wiligi odoo tebisa oso Pita dio Yonee dio gilimadoloso dimapoo egeesee takaso, “Niyo silesibulone, Yesuwo hu maga goo abo na eligi,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Eseme Pita diayo dimapoo to nei egeesee takaso, “Esiga niba niso nediliyo goo hagee medee goolee. Godeeyo howo woola abaga, nibada to mapoo iyo mesilone, nei iyo Godeeyo to mapoo mesilega pagalai tekepodo? ");
INSERT INTO kkc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bei, iyo Yesuye goo tomo silime egei goo sabolo osoloso Yesuye takeme du goo ee takalai pagalaime,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Eseme wiligi odoo tebisa oso dimapoo to kitulugu sabolo takolone, “Yesuwo hu maga niyo see eligimo silesiboga, iyo nimapoo dala tenelaiso,” dee takoloso, goo midili moso maga peegoo diye diso. Bei, odoo susuga oso odoo kido todobia tekepo pa maga Godee mapoo diya goomogome. Eseme wiligi odoo tebisa oso Pita dimapoo dala tenelai biame egele poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Esiga odoo kido todobuloso badebei dugo 40 poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita dio Yonee dio goo midili moso maga peegoo galaga dileso, tei telaga odoo sabolo mooloogoodoloso tei moso wiligi odoo tebisa sabolo, osoloso Yu odoowo wiligi odoo tebisa diayo taka goo ee dimapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eseme tei telaga odoo oso to hagee duloso, diesono mooloogoodoloso Godee mapoo takolone egeesee takaso, “Kitulugu Godee, nayo mi sabolo, kei sabolo, osoloso abei sabolo, osoloso bi susuga ee ma kulodu egee molo moodooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Esiga nayo Dio Tei maga nee tou teli odoo ibada amawe Deibidiye egeesee takaso, ‘Bei kasi maga Yu odoonee oso diya ka kamanaliyo? Osoloso goo bei mauwe maga to wulo ka moumo siliyo? ");
INSERT INTO kkc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mi toowa eyo wiligi odoo tebisa oso diesono hodobo mooloogoodoloso kitulugu Godee sabolo, osoloso yayo hesia Keliso sabolo, mapoo ha talame mopoodoo doloso doso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Deibidiye tei goo takaso, bei Yu odoowo wiligi odoo taba Helodee sabolo, Loum gamalee odoo Pontiyus-Pailet sabolo, osoloso Isalael odoo sabolo, Yu odoonee sabolo, diesono Yelusalem omapoo mooloogoodoloso Yesu nayo hesia tou teli odoo Keliso wooloomalame to mouso. ");
INSERT INTO kkc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Esino diayo goo moodoo hagee, daga hoogoo nayo gooleedoloso, goo hagoso peledabalame, nayo kitulugu sabolo goomoga magooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Esiga kitulugu Godee, wiligi odoo tebisa hagoso epedee nee tou teli odoo imapoo ebili to taka ee nayo duso. Esiga imapoo kitulugu tenee, iyo nee to takomo silesibulone, ebia goo mauwe pagalame. ");
INSERT INTO kkc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Esiga nayo kitulugu eligilone, odoo paigiga tekepo pe. Osoloso nee tou teli odoo nayo hesia Yesuwo hu maga goo toowa mudu opusomo di moodee,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Esino diayo Godee mapoo taka koodobuloso, diayo debei moso ee halabume egeiso. Eseme Dio Tei oso dimapoo meledoboloso, diba Dio Tei oso kitulugu toloso dobolone, ebia goo mauwe poogoloso, Godeeyo to takomo silesibilame bei mooloogooso. ");
INSERT INTO kkc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Esiga tei telaga odoo mooloogoodoo oso dibada sooloo ma kulodu goo goolee hedebe doloso dobolone, odoo heeso bi koo goodegeli, diba diso biso nei pidi, nei pidi deliso. ");
INSERT INTO kkc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Egeeseelone diye di odoo oso kitulugu toowa sabolo silesibulone, Yesuye toloso hogabia eyo goo takomo silesibiliso. Osoloso Godeeye tei telaga odoo susuga dimapoo goo tekepo moodeliso. ");
INSERT INTO kkc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Esiga tei telaga odoo oso dibada mi sabolo moso sabolo odoo mapoo teneloso, nei molee toloso diye di odoo mapoo teneliso. Egeeseega diye di odoo oso molee egee papisaloso, tei telaga odoo abo bi tebile poogoo mapoo teneliso. Osoloso dibada kulodu odoo heeso bi mauwe koo sili. ");
INSERT INTO kkc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Osoloso tei too odoo hee Yosepeeye o mi odoo abo mapoo teneloso nei molee tooso. Osoloso yayo sibileso, molee ee diye di odoo dimapoo teneeso. (Yosep hagee Saiples mi te omapoo badeli, yo o bala Libai. Esino diye di odoo oso yimapoo hu hee teneeso, Banabas, hu eyo bei emegei pidili odoo.) ");
INSERT INTO kkc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Osoloso odoo hee badebeiso, o hu Ananayas, osoloso osobowo hu Sapila, diayo dibada mi su pepooko odoo mapoo teneloso nei molee tooso. ");
INSERT INTO kkc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Osoloso mosopoo sibileso, obakadio to mouloso, molee abo mada magoloso, Ananayaseeye diye di odoo dimapoo molee abo tosibileso teneeso. ");
INSERT INTO kkc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eseme Pitaye Ananayas mapoo egeesee takaso, “Bei kasi maga nayo Saitenso gamenee taka to mapoo mesilone, Godeeyo Dio Tei mapoo gamenee takolone, mi molee too abo mada ka magoowo? ");
INSERT INTO kkc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mi hagee odoo mapoo tenelega melee omapoo nee mi diso. Esino nayo odoo mapoo mi teneloso, nei molee too egee neeso. Esiga nee molee oso, no goomoga goo ee talai tekepo. Bei kasi maga, nayo molee abo nee mosopoo mada magoo egee imapoo takele, esino nayo gamenee takolone, ayo molee susuga tosimi hagoso, dee ka takayo? Esino nayo hedebe imapoo gamenee takele, esino nayo Godee mapoo gamenee takaso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Eseme Ananayaseeye to hagee duloso, yo toloso homodobiaso. Eseme odoo gie kakauwa oso dugoso o su tiadoloso midoosooso. Eseme goo hagee takeme duluga, odoo susuga oso diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Esino Ananayaseeyo osobo goo hagee dule. Esino yo osoko howo bakadio hedebe di poogoloso, hamamee Pita diayo debei mapoo simiso. ");
INSERT INTO kkc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Eseme Pitaye yimapoo egeesee takaso, “Amapoo takee, niyo mi su odoo mapoo teneme molee too ee hagosomo?” Eseme Ananayaseeyo osoboye nei egeesee takaso, “O, molee iyo too olo ogoso.” ");
INSERT INTO kkc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Esino Pitaye yimapoo egeesee takaso, “Bei kasi maga nee bakadio Godeeyo Dio Tei mapoo gamenee takalame goomoga ka magoowo? No ege, gie kakauwa odoo oso nomo midoosoo odoo, osulu miyopoo tebisa moloso. Osoloso no toga, diayo no midoosoolaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Osoloso yo to kemelee biame omapoo Ananayaseeyo osobo toloso, Pitayo homo beiyomoo homodobiaso. Eseme odoo gie kakauwa odoo oso sibileso ogoloso yo ta molome, diayo o su toloso, omowo midoo hodiokooga midoosooso. ");
INSERT INTO kkc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eseme tei telaga odoo susuga sabolo, osoloso goo hagee du odoo susuga sabolo oso diya ebigaso. ");
INSERT INTO kkc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Diye di odoo oso goo toowa mudu opusomo opusomo di odoo ma kulodu moodoogamo silesibiliso. Osoloso tei telaga odoo susuga oso tei moso tegei Solomonowo hau mapoo diesono mooloogoodeliso. ");
INSERT INTO kkc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Eseme tei tele poogoo odoo oso, diye di odoowo goo ee tekepo dee takeliso. Esino diayo dibolo hodobo mooloogoodoloso hedebe dalai diya ebigeliso. ");
INSERT INTO kkc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Esino biame susuga ma kulodu, sobo sabolo, giso sabolo, Lodee mapoo tei toloso, tei telaga odoo mooloogoodoo sabolo hedebe deliso. ");
INSERT INTO kkc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Diye di odoo oso goo mudu opusomo opusomo di moodoogamo silesimi ogoloso, odoo susuga oso odoo paigiga iyado sibileso, eli domopoo kida palagaloso, kida mapoo tiedigeliso. Bei, Pitaye osoko pa maga dulone, o dio taba oso gooloogooga, diba ka wedilame. ");
INSERT INTO kkc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eseme Yelusalem koola omapoo mosobia pepooko oso odoo paigiga sabolo, odoo bo holo paladee oso dala temelee sabolo, iyado sibadiliso. Egeeseega diye di odoo oso diba tekepo peliso. ");
INSERT INTO kkc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Diye di odoo oso goo mudu opusomo opusomo di hagee moodoogamo silesibume, tei moso wiligi odoo taba sabolo, osoloso o emegei Sedisi odoo sabolo, goo hagee ogoloso, diye di odoo dimapoo diya kooloogaso. ");
INSERT INTO kkc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eseme diayo diye di odoo toloso neliga moso tegei ma kulodu toosooso. ");
INSERT INTO kkc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Esino gesi mapoo Lodeeyo momaiye oso sibileso neliga moso eyo osulu kisi yamagooso. Eseme diye di odoo neliga moso ma kuloduga peegoo iyado dileso, dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Niba tei moso tegei mapoo dileso odoo mapoo gie badeli goo dia hagee takee,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eseme diye di odoo oso o to mapoo mesiloso, gesikolodee osoko gie sibume, tei moso ma kulodu galaga dileso, Yesuwo goo ee eligilame bei mooloogooso. Eseme tei moso wiligi odoo taba sabolo, osoloso Sedisi odoo sabolo, oso diye di odoo eyo goo mapoo to meilame, Yu odoowo wiligi odoo tebisa susuga gilimadooso. Osoloso diayo neliga moso gibadeli odoo dimapoo to takaso, diayo diye di odoo susuga iyado sibilame. ");
INSERT INTO kkc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eseme gibadeli odoo oso neliga moso tegei mapoo dileso egeino, diye di odoo me molo egeiso. Eseme diba see wedi dileso, wiligi odoo tebisa mapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Iyo dileso neliga moso mapoo egeino, osulu diya kisina, osoloso gibadeli odoo oso pee maga gidoboome egeiso. Eseme iyo osulu yamagoloso, moso kulodu galaga dileso egeino, diye di odoo mauwena,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eseme tei moso wiligi odoo tebisa sabolo, osoloso tei moso gidebeli odoo dia wiligi odoo taba oso goo hagee duloso, goo diya gooleeso, ogoo goo oso hamamee ka peledoboomobelee doloso. ");
INSERT INTO kkc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Eseme odoo heeso dimapoo sibileso egeesee takaso, “Dui! Niyo odoo neliga moso tegei mapoo toosoo ee, see dileso tei moso mapoo odoo eligi moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eseme to ee duloso, tei moso gibadeli dibada wiligi odoo taba oso o odoo sabolo diye di odoo ee see iyadalame, diso. Esino diayo diba iyadoloso wele. Bei, edebeeyo gibadeli odoo mapoo gowoolone, yoso diba piligiyaga. ");
INSERT INTO kkc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Esino diayo diye di odoo wiligi odoo tebisa dibada mudugiyopoo iyado simiso. Eseme tei moso wiligi odoo taba oso dimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Iyo to kitulugu sabolo nimapoo egeesee takaso, ‘Niyo Yesuwo goo eligimo na silesibe,’ diso. Esino niyo ibada to mapoo mesile. Esiga niba ege! Niyo eligi goo oso Yelusalem mi toowa ee tooso. Osoloso Yesuye ta goo ee see niyo imapoo gigidilame ka see,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Esino Pitaye diye di odoo abo sabolo to nei egeesee takaso, “Iba Godee mapoo mesimo silesibiliso. Esino edebeeyo goomoga goo ee talaime. ");
INSERT INTO kkc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O, tei takoo, niyo Yesu homo bulubo magoo mapoo yoguso eniga oso wooloomaso. Esino ibada amaweyo Godeeye Yesu niyo woolooma ta maga see hogadiso. ");
INSERT INTO kkc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Osoloso Godeeye Yesu ta maga hogadiloso o dee deedee dokolo mapoo ibediso, yayo wiligi doloso badolone gie badeli ee pidili odoo dalame. Esiga epedee hamapoo yimapoo kitulugu moloso, Yu odoo susuga oso dibada goo goolee opusomo doloso, dibada goo tokenee mapoo miligi piaga, goo tokenee hapoloso boobado bigileiso. ");
INSERT INTO kkc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Esiga goo susuga hagee Yesuye moodoomo sili goo sabolo, osoloso yimapoo peledaba goo sabolo, ee iyo ogoloso, see odoo mapoo takomo silesibiliso. Osoloso Dio Tei ima kulodu egee molo oso goo hamapoo tei takoo, deeso. Bei, Godeeyo to mapoo mesimo silesibili odoo mapoo Dio Tei teneliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Eseme Yu odoowo wiligi odoo tebisa oso goo hagee duloso komonolone, diye di odoo piligilame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Esino dima kulodu Pelisi odoo hee, o hu Gamaliyoye tabaso, odoo hagee Godeeye tei magoo ee eligili odoo. Osoloso odoo susuga oso yo tekepo odoo dolone, yo dokodoo maluguso. Esino yayo tobudulone, diye di ee epedee biame deiyepo peegoo gilimadoo di, diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eseme wiligi odoo tebisa mapoo egeesee takaso, “Isalael odoo, niyo odoo hagee dimapoo goo moodoolame medee gooleemeleso ka moodee. ");
INSERT INTO kkc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bei, niba goolee, daga odoo hee Tudaseeye goo hageesi moodoolone o su toowa diso. Osoloso 400 odoo oso yibolo silesibiliso. Esino edebeeyo yo wooloomome, yibolo silesibili odoo 400 diba kukulo diyadeeso. Egeesi maga goo mauwe poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Eseme yima hamamee, gamalee odoo oso odoo susugayo hu tomo silesimi biame omapoo odoo hee Yudas Gelili odoo oso peledabaso. Yibolosee o su toowa doloso, odoo gilimado sileeso. Eseme edebeeyo yo wooloomome, yibolo silesibili odoo ee kukulo diyadeeso. ");
INSERT INTO kkc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Esiga ayo goo hagee gooleebuguloso, nimapoo ka kokodo taka, odoo hagee dimapoo goo hee na moodee. Bei, diayo goo moodoogamo egee silesibo, odoo maga simi daga, goo hagoso mauwe pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Esino goo egee Godee maga siboga, niyo diba hamaga takooga tebileime. Esino wulo niyo Godee mapoo ha talame ka selai,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eseme wiligi odoo tebisa oso Gamaliyowo to mapoo tei takoo diso. Osoloso diayo diye di odoo see iyado sibe diso. Osoloso diye di odoo diba sibileso doboome, edebeeyo diba woolooge, diso. Osoloso diba wooloogaloso, wiligi odoo tebisa oso diba diye dolone to kitulugu sabolo egeesee takaso, “Niba see Yesuwo goo ee takolone eligimo na silesibe!” diso. ");
INSERT INTO kkc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Diye di odoo oso wiligi odoo tebisa diba poogoloso dulone, diya goomogaso. Bei, diayo Yesu mapoo tei too maga dala teme, Godeeye diba dokodoo poudooso. ");
INSERT INTO kkc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Osoloso diba biame susuga tei moso tegei ma kulodu, osoloso odoo abo dia moso ma kulodu odoo mapoo to hagee eligimo silesibulone, “Yesu Godeeye hudi magoo Keliso oso,” dee taka koodobile. ");
INSERT INTO kkc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Biame omapoo tei telaga odoo oso bei moodooso. Esino tei telaga odoo susuga ma kulodu, Guliki to kesali odoo oso Hibulu to kesali odoo sabolo toso agadigaso. Bei, diayo mooloogoodoo ma kulodu, Guliki to kesali dibada sobo bau mapoo nei koo teneme. ");
INSERT INTO kkc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eseme diye di odoo oso tei telaga odoo susuga gilimadoloso egeesee takaso, “Iyo Godeeyo to takomo sili poogoloso see sobo bau mapoo nei pilei ee tekeponee. ");
INSERT INTO kkc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Esiga emegei, nima kulodu pidili odoo giso 7 hesie. Niyo diba hesiaga, odoo goo goolee medee tekepo, osoloso Godeeyo Dio Tei oso kitulugu toloso debeli giso ee hesie. Egeeseega diba iyo emegei pidili tou dimapoo tenelaiso. ");
INSERT INTO kkc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Esino iba wulo Godeeyo to takomo silesibulone, yimapoo takomo silesibileiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Esiga tei telaga odoo susuga oso to hagee duloso tekepo doloso, odoo 7 hagee hesiaso: Sitiben (odoo hagee tei too kibiloso badolone Dio Tei oso kitulugu toloso badeli), osoloso Pilipi, osoloso Polokolus, osoloso Nikanolo, osoloso Timono, osoloso Palemenas, osoloso Antiyoka odoo, Nikolas. Odoo hagee Yu odoonee, esino yayo Yu odoowo Godee mapoo tei too maga Yu odoo dia hu ka too. ");
INSERT INTO kkc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Diba odoo 7 hagee hesialoso diye di odoo mapoo iyado sibadeeso. Eseme diye di odoo oso dimapoo deeso sigolone Godee mapoo takaso, bei diba tou hageesee teli odoo dalame. ");
INSERT INTO kkc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eseme tei telaga odoo oso odoo susuga mapoo Godeeyo to takomo sileeme, tei telaga odoo oso Yelusalem mi ee ma kulodu bei moodooso. Osoloso tei moso wiligi odoo tebisa bei oso Yesu mapoo tei tooso. ");
INSERT INTO kkc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Godeeye Sitiben tei pidilone kitulugu teneeso, yayo odoo ma kulodu goo toowa mudu opusomo opusomo di moodoolame. ");
INSERT INTO kkc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Esino Yu odoo abo Libetini howo gisili moso ma debeli odoo oso yimapoo toso agadigaso. Odoo hagee Kulene mi mapoo debeli, osoloso odoo abo Alesandiliya mi mapoo debeli, osoloso Kilikiya mi mapoo debeli, osoloso odoo abo Asiya mi mapoo debeli. Diayo sibileso Sitiben mapoo toso agadigaso. ");
INSERT INTO kkc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esino diayo toso agadiga ma kulodu, Sitibeneeye Dio Tei oso kitulugu maga to takeme, odoo susuga oso to takalai eli egele poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eseme Sitibenbolo toso agadiga melee odoo oso Sitiben maga gamenee takalame, odoo abo mapoo mada sibileso toso pupume, diayo egeesee takaso, “Sitibeneeye Godeeyo hu sabolo, osoloso Moseseeyo hu mapoo duwa takeme duso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eseme odoo susuga sabolo, osoloso Yu odoowo wiligi odoo tebisa sabolo, osoloso Godeeye tei magoo ee eligili odoo sabolo oso to hagee duloso, diya komonolone Sitiben tooso. Osoloso diayo Sitiben toloso wiligi odoo tebisa oso to kesamelee mapoo ido palaso. ");
INSERT INTO kkc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Diba omapoo peleso dobolone, Sitibeneeyo goo maga gamenee takeli odoo oso gamenee egeesee takaso, “Odoo hagoso ibada tei moso maga tokenee goo takeliso, osoloso Moseseeye eligi goo hogugu goo maga tokenee goo takeliso. ");
INSERT INTO kkc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Osoloso iba yayo egeesee takeme duso, ‘Yesu Nasalet odoo oso ibada tei moso tegei guobuguloso, see Moseseeye tei magoo hogugu ee abo poogoloso, see tei dia abo magalaiso,’ ” diso. ");
INSERT INTO kkc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eseme wiligi odoo tebisa susuga dobolone Sitiben mapoo bolone egeino, Sitibeneeyo mudu Godeeyo momaiye eyo mudu masi poloso tobudume egeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eseme tei moso wiligi odoo taba oso Sitiben mapoo egeesee woosaso, “Odoo susuga oso nee goo maga egee takoo teiyo?” diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eseme Sitibeneeye tei moso wiligi odoo tebisa dimapoo to nei takolone egeesee takaso, “Mo ei dio osoloso mo ma dio, niba mo to hagee medee dui. Ibada amawe Eibalaham yo Halan mi mapoo dilega, Mesopotamiya mi mapoo badoboome, ibada Godee kitulugu toowa oso yimapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Eseme Godeeye Eibalaham mapoo egeesee takaso, ‘Nee mi sabolo nee odoo sabolo poogoloso ayo namapoo eligilei mi mapoo di,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Esiga Eibalaham Mesopotamiya mi poogoloso see Halan mi mapoo badalame diso. Esino Eibalaham yo mi omapoo badoboso, ama teme, Godeeye yo see epedee niyo egee do mi hamapoo sibe, diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Eseme Godeeye mi hamapoo Eibalaham mapoo mi su pepooko tenele. Esino Godeeye Eibalaham bolo osoloso amawe dibolo oso hamamee mi hagee talai maga to takoloso magooso. Biame omapoo Eibalaham yo holo soomagelega badebeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Osoloso Godeeye yimapoo egeesee takaso, ‘Namawe dio oso mi hee mapoo dileso odoo soo masi dabalaiso. Egeeseega mosobia odoo oso namawe dimapoo tou nei mauwe wulayo talaiso. Osoloso diayo dala ma kulodu dobolone dugo 400 pagalaiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Esino namawe dimapoo dala egee tenemolo odoo dimapoo ayo nei dala tenelaiso. Egeeseega namawe diayo mi egee poogoloso see hamapoo sibileso, amapoo goomoga tenelone mo hu dokodoo poudileiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Osoloso Godeeye Eibalaham dio to takoloso magolone egeesee takaso, ‘Ayo nobolo osoloso namawe dio eyo Godee doloso badolone, nima koola hamapoo badalaiso. Osoloso niyo amapoo tei too goo ee eligilone nibolo, osoloso nowolo dibolo, osoloso namawe dio susuga hamamee soolooga magalai sabolo, kolo kookoolone dabalaiso,’ diso. Eseme Eibalahameeye giso holo Aisek soomageme, biame 8 poogoloso kolo kooso. Osoloso hamamee Aisekeeye giso holo Yekob soomageme, kolo kooso. Osoloso Yekob sabolo owolo giso holo 12 susuga kolo kookooso. Esiga Yekobowo owolo 12 odoo hagoso ibada bala 12 eyo bei ka moloso. ");
INSERT INTO kkc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Esino Yekobowo owolo susuga hagoso dibada omolo Yosep mapoo diya kweliso. Egeeseelone dibada omolo Yosep yo Isipi odoo mapoo ido dileso neiso talame teneeso. Yayo mi omapoo dileso, nei mauwe tou toowa wulayo tolone badalame. Esino Godee yibolo badolone, ");
INSERT INTO kkc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dala goo ma kuloduga yo medee pidiliso. Osoloso Godeeye Yosep mapoo goo goolee tekepo teneeso. Eseme Isipi odoowo wiligi odoo taba oso goo hagee ogoloso, Yosep mapoo diya goomogaso. Eseme Yosep mapoo egeesee takaso, ‘Nayo ama hemi tou tolone badolone, Isipi mi toowa nayo gibadalaiso. Osoloso mo moso sabolo nayo gibadalaiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Osoloso hamamee Isipi mi sabolo, ibada amawe diayo debei Keinen mi sabolo, mapoo osoko pa toowa biame oso nei mauwe poogooso. Eseme odoo omapoo debeli oso dala ma kulodu debeiso. Osoloso ibada amawe sabolo nei mauwe debeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Esino Yekobeeye Isipi mi mapoo nei melee goo ee duloso, owolo diayo nei ee neiso talame diye diso. Eseme diayo dileso nei toloso sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nei diayo tosibadee mauwe poogoome, see Isipi mi mapoo nei abo talame diyadeeso. Diba dileso nei talame doboome, Yosep yimapoo pelebada goo ee yayo emei dimapoo woola takaso. Eseme Isipi wiligi odoo taba oso Yosepeeyo soosoo eyo goo gooleedooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eseme Yosepeeye ama sabolo, o soosoo sabolo, Isipi mi mapoo sibileso dabalame to teneeso. Eseme diba Yosepeeye to egeesee taka duloso, diba susuga 75 odoo oso Isipi mi mapoo sibadeeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eseme Yekobowo owolo dio Isipi mi mapoo dileso dobolone, yibolo, osoloso owolo dibolo mi omapoo wediaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hamamee diba wedime, dibada su Sekem mi mapoo midoosalame todiyadeeso. Midoo wulu ou hagee daga hoogoo Eibalahameeye Hamolowo owolo mapoo neiso tooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Dugo bei poogoloso hamamee ibada amawe dio oso Isipi mi mapoo bei moodooso. Eseme biame omapoo Godeeye Keinen mi Eibalaham mapoo, osoloso amawe dimapoo tenelaiso, doloso to takoloso magoo biame oso koola simiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Esiga wiligi odoo taba dia, Yosepeeyo goo gooleedele poogoo odoo oso Isipi mi ee gibadebeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wiligi odoo taba hagoso ibada amawe dio diya gowoolone, dimapoo kukulone dala tenelone badebeiso. Osoloso yayo to kitulugu sabolo pupulone, ibada amawe dia holope gie soolooga magoo susuga ee wedilame, peegoo maloso peegee diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Egeeseelone debei biame omapoo, Isalael sobo hedebe oso giso holo mudu medee tekepo soomagooso, o hu Moses. Osoloso a bakadio hedebe di ma kulodu ama dio owee dio oso dibada moso kulodu mada gibadebeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Osoloso a bakadio hedebe di poogoloso holope peegoo magooso. Eseme Isipi wiligi odoo taba eyo owolo sobo holo oso holope ogoloso, yayo maduloso, owolo doloso mosopoo madio dileso poopooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eseme Moses kauwume, Isipi odoo oso yimapoo sukulu goo goolee tekepo eligiso. Osoloso yayo to taka sabolo, tou too sabolo, kitulugu toowa tomo sileeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Osoloso Moses dugo 40 poogoloso badolone, yayo o odoo Isalael odoo ee agalame dilame gooleeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yayo dulone egeino Isipi odoo heeso Isalael odoo hee woomelee ogoloso, yayo nei Isipi odoo hee wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Osoloso Moseseeye egeesee gooleeso, ‘Isalael odoo oso goolee, ayo diba dala ma kuloduga peegoo gilimado dilame, Godeeye a dimapoo ka sibeye di doo,’ dee gooleeso. Esino Isalael odoo oso goo ee gooleedele. ");
INSERT INTO kkc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Biame hee mapoo Moseseeye Isalael odoo bakadio biliga molome egeiso. Eseme yayo diba biliga melee hamaga takalame hodu dileso, egeesee takaso, ‘Emegei, niba kasi maga ka biliga malala? Niba soosoo hedebe,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Eseme odoo hee emegei woomelee oso Moses halaga buguloso egeesee takaso, ‘No ibada wiligi tabayo, osoloso goo midili odoowo? ");
INSERT INTO kkc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nayo eiyo Isipi odoo hee wooloomaso. Esiga nayo a wooloomalame ka sala?’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eseme Moseseeye to ee duloso obulone, Isipi mi maga see Midiyan mi mapoo pulo diso. Osoloso Midiyan mi omapoo odoo soo masi badolone sobo huloso, giso holo bakadio soolooga magooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","31","Moses Midiyan mi mapoo dileso dugo 40 poogoloso badolone, see Sainai mubi esia kumoo miwe poogoo mi mapoo silone egeino, homo su deiyepo o du douso nadelega dou omapoo paiya molome ogoloso howoodooso. Esino dou paiya oma kulodu Godeeyo momaiye oso tebidi egeiso. Eseme Moses yo dou paiya mapoo agalame hodu dimeleeno, Godeeye yimapoo egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘A namawe dio Eibalaham, Aisek, osoloso Yekob dibada Godee oso,’ diso. Eseme Moses ebia sabolo kikiligolone see tobu egele poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Esiga kitulugu Godeeye see yimapoo egeesee takaso, ‘Mi nayo taba egee molo tei mi. Esiga nee homo bi ka egee tiga magee. ");
INSERT INTO kkc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ayo mo odoo susuga oso Isipi mi mapoo dobolone dala egee tomolo, ayo egeiso. Osoloso diayo dala ma kulodu dobolone pupusiga melee ayo duso. Esiga ayo diba Isipi mi maga gilimadoloso peegoo dilame ka simi. Esiga no epedee Isipi mi mapoo see wedi di,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Esiga Moses hagee daga Isalael odoo oso gowoolone egeesee takaso, ‘No ibada wiligi tabayo, osoloso goo midili odoowo?’ diso. Esino Godeeye Moses hedebe yo hesiaso, yayo Isalael odoowo wiligi odoo toboloso badolone, diba dala ma kuloduga gilimadoloso peegoo dilame. Esiga homo deiyepo o du douso nadelega paiya molone, Godeeyo momaiye oso goo hagee takaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Osoloso Moseseeye o odoo Isipi mi maga gilimadoloso peegoo dilame, yayo goo toowa mudu opusomo opusomo di Isipi mi mapoo, osoloso Abei Bige mapoo moodoogaso. Eseme yayo o odoo Isalael odoo gilimadoloso Isipi mi maga peegoo diso. Osoloso yayo miwe poogoo mi mapoo o odoo gilimadoloso dugo 40 ma kulodu silone goo mudu opusomo opusomo di moodoogamo sileeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Osoloso Moses hedebe hagoso o odoo Isalael odoo dimapoo egeesee takaso, ‘Godeeye niba ee gooleebugulone, nima kuloduga o odoo yimaga to toloso kokodo takomo sili odoo a egeesi masi hesileiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Esiga Moses hedebe hagoso ibada amawe dio Isalael odoo sabolo, miwe poogoo mi mapoo silone, yayo Sainai mubi dokodoo peleso badoboome, Godeeyo momaiye oso yibolo to kolone yimapoo gie badeli to imapoo tenelame teneeso. ");
INSERT INTO kkc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Esino ibada amawe dio oso Moseseeyo to mapoo gowoolone, o to mapoo mesile. Eseme diba Isipi mi mapoo wedi dilame goomogaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Osoloso Moses Sainai mubi dokodoo osee badoboome, odoo susuga oso Moseseeyo emei Elon mapoo egeesee takaso, ‘Moseseeye iba Isipi mi maga gilimado simiso. Esino Moseseeye di, iba gooleedele. Esiga iba ee gilimado dilei godee masi deeso moodee,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eseme biame omapoo Isalael odoo oso gamenee godee bulumakau pe be masi dadabayo moodooso. Osoloso diayo gamenee godee omapoo goomogolone, o hu dokodoo poudalame gala hu wooloogaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Esiga Godeeye goo hagee ogoloso dimapoo miligi piaso. Eseme diba kei ma dokodoo bi egee molo, a, osoko, osoloso giwo, omapoo godee masi goomogolone doboome, Godeeye diba hamaga takele. Esiga goo hagee Godeeyo to oso booka mapoo taka Godee maga to toloso kokodo takomo sili odoo heeso booka maga egeesee hoguguso: ‘Isalael odoo, niba dui! Niyo miwe poogoo mi mapoo dugo 40 ma kulodu silesibulone, amapoo emegei di bi sabolo gala hu sabolo wooloso tenelisomo? Haye! Esino niyo gamenee godee mapoo teneliso. ");
INSERT INTO kkc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Esiga niba tei moso dugoso tegei ee imadoloso silesibiliso. Osoloso niyo moso oma kulodu goomoga poudili ee amapoo goomoga koo poudili. Esino niyo deeso moodoo gamenee godee Moloko sabolo Lepan godeeyo giwo sabolo omapoo goomoga poudiliso. Esiga niba ayo nibada midee hamaga see mi eli sage Babilon mi hodiokoo hasiso bigileiso,’ diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Esiga tei moso dugoso tegei hagee Godeeye Moses mapoo eligilone egeesee tege diso. Eseme edebeeyo Godeeyo to ee dodolone, moso hagee tegeiso. Osoloso ibada amawe diayo miwe poogoo mi mapoo moso hagee imado silesibulone, ‘Godeeye ibolo badoso,’ deliso. ");
INSERT INTO kkc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eseme dugo abo poogoloso hamamee see Yosuwaye ibada amawe dio gilimadoloso mi hagee talame silone, tei moso hagee sabolo imado sibadeeso. Eseme Godeeye ibada amawe dio ee pidilone, mibia odoo susuga ee mi hamaga peegoo hasiso buguso. Osoloso diayo mi hamapoo tei moso dugoso tegei ee toloso dobolone, wiligi odoo taba Deibidiyo biame mapoo peledabaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Eseme Godeeye Deibidi mapoo goomogaso. Eseme Deibidiye tei moso Godee eyo badalame tei moso dia tegelame woosaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Esino tei moso dia egee yayo tegele. Owolo Solomonoye tegei. ");
INSERT INTO kkc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Esino ibada Godee kitulugu toowa edebeeyo deeso tegei moso oma kulodu koo badeli. Esiga Godee maga to toloso kokodo takomo sili odoo oso Godeeyo goo maga egeesee takaso, ");
INSERT INTO kkc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Godeeye egeesee takooso: Kei mi mapoo ayo badolone ka gibadoso. Osoloso mi toowa hagee ayo mo homoso kokusoloso ka tobudoso. Esiga niyo moso togoga, ayo moso omapoo badalai koo tebili. Osoloso niyo ayo badeli moso ee tegelai koo tebili. ");
INSERT INTO kkc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ayo mi toowa sabolo, kei mi sabolo, osoloso bi susuga sabolo moodooso,’ diso.” ");
INSERT INTO kkc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Osoloso Sitibeneeye o to hamameedee see wiligi odoo tebisa mapoo egeesee takaso, “Niba koo mesili odoo. Osoloso nibada sooloo ma kulodu tei too goo mauwe. Esiga niba Godeeyo to mapoo koo duli. Osoloso namawe dio Dio Tei oso eligi goo ee gowoolone poogooso. Esiga niyo see egeeseelone, Dio Tei oso eligi goo ee gowoolone poogooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Osoloso namawe diayo Dio Tei oso eligi gowoolone, Godee maga to toloso kokodo takomo silesibili odoo susuga mapoo dala teneeso. Esiga Godee maga to toloso kokodo takomo silesibili odoo aboso egeesee takaso, ‘Odoo tekepo Keliso hamamee sibileiso,’ diso. Eseme namawe dio oso diba piliguso. Egeesi ma kulodu odoo tekepo Keliso simiso. Esino niyo gowoolone yo tiasoloso wooloomaso. ");
INSERT INTO kkc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Osoloso daga hoogoo Godeeyo momaiye oso Godeeyo tei magoo nimapoo olo teneme, niyo omapoo mesilega poogooso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Eseme wiligi odoo tebisa oso Sitibeneeyo to duloso, diya komonolone, dibada mei diya kumudooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Eseme Sitibeneeye Dio Tei oso kitulugu toloso badolone, kei mi ma dokodoo egeino, Godeeyo gadeebugu kitulugu toowa ma kulodu Yesu Godeeyo dee deedee dokolo mapoo tobudume egeiso. ");
INSERT INTO kkc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eseme yayo wiligi odoo tebisa mapoo egeesee takaso, “Ege! A kei mi yamagoloso Odoo Holo Godeeyo dee deedee dokolo mapoo tobudo ogoso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eseme odoo susuga oso Sitibeneeyo to ee dulei gowoolone neligidi agadiga sabolo, dibada dulu toobooga doloso sibileso Sitiben tooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Osoloso diayo Sitiben mosobia oma kuloduga peegoo ido dileso badoboome, yoso enigilame bei mooloogooso. Osoloso Sitibeneeyo goo mapoo gamenee takeli odoo abo oso dibada kekeisu dugo tigadoloso, odoo giekauwa, Solowo homo beiyomoo tigamagooso. ");
INSERT INTO kkc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Odoo susuga oso yimapoo yoso enigime, Sitibeneeye Godee mapoo takolone egeesee takaso, “Lodee Yesu, mo dio nayo te,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Diayo yoso enigime, yo mi mapoo ebiso tugusaloso badolone, toso neligidi takolone egeesee takaso, “Lodee, dibada goo tokenee hagee hapoloso boobado bigi!” diso. Sitiben to hagee takoloso taso. ");
INSERT INTO kkc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Solo omapoo tobudulone Sitiben yoso enigaloso wooloomalame odoo dimapoo goomoga goo takeme, yo wooloomaso. Eseme tei telaga odoo abo oso sibileso Sitibeneeyo su midoosoloso diya pupusigaso. Eseme Sitiben woolooma biame omapoo Yelusalem mapoo debeli tei telaga odoo mapoo odoo susuga oso gowoolone, dimapoo dala tenelame bei mooloogooso. Eseme Soloye moso susuga mapoo peleso tei telaga odoo, giso sabolo, sobo sabolo, toloso neliga moso mapoo huyaseliso. Eseme tei telaga odoo susuga oso Yelusalem maga kukulo dulone, mi pepooko abo susuga mapoo Yudiya mi mapoo osoloso Samaliya mi ma kulodu diyadeeso. Esino hedebe diye di odoo susuga Yelusalem mapoo debeiso. ");
INSERT INTO kkc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Esiga tei telaga odoo susuga oso Yelusalem maga kukulo dileso, mi pepooko opusomo opusomo di mapoo to tekepo takolone, Kelisowo goo takagamo silesibiliso. ");
INSERT INTO kkc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Osoloso Pilipiye Samaliya mi toowa ee ma kulodu Sebasete mi mapoo dileso peledoboloso, Kelisowo goo odoo susuga mapoo takaso. ");
INSERT INTO kkc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Eseme Pilipiye to tekepo Kelisowo goo takolone, goo opusomo opusomo di moodoogamo silee diayo ogoloso, odoo susuga oso o to medee duso. ");
INSERT INTO kkc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Osoloso odoo susuga mooloogoodoo oma kulodu bo holo odoo ma kulodu paladee, Pilipiye peegoo hasiso buguso. Eseme bo holo oso neligidi googa sabolo peegoo galagadiso. Osoloso odoo su kakawa poogoo sabolo, kido tigediba sabolo, tekepo moodoogaso. ");
INSERT INTO kkc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eseme Sebasete mi oma kulodu odoo susuga oso goomoga toowa meleeso. ");
INSERT INTO kkc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Esino Sebasete mi ma kulodu odoo googoo gooleedoo badebeiso, o hu Saimon. Esiga yayo biame susuga o googoo oso goo toowa opusomo opusomo di moodoogamo siloga, Samaliya mi toowa mapoo debeli odoo susuga oso ogoloso howoogadeliso. Egeeseelone yayo goolee, eyo nediliyo yo tekepo doloso, suwa peliso. Osoloso odoo susuga, hu toowa too odoo sabolo osoloso goo mauwe odoo sabolo oso, yayo goo opusomo opusomo di moodoo ogoloso, o to mapoo medee duloso tei tooso. Osoloso diayo egeesee takaso, “Odoo hagee Godee masi osoloso o hu Kitulugu Toowa,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Esino Pilipiye to tekepo takolone, Godeeye wiligi doloso badeli eyo goo sabolo, Yesu Kelisowo goo sabolo, taka duloso, to omapoo tei teme, giso sabolo, sobo sabolo, howo ogusigaso. ");
INSERT INTO kkc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Osoloso Saimoneeye Pilipiyo to mapoo tei toloso howo oluguloso, Pilipi bolo sileeso. Osoloso yayo yibolo silone, Pilipiye goo toowa opusomo opusomo di moodoogamo silee ogoloso, diya howoodooso. ");
INSERT INTO kkc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eseme Yelusalem mi mapoo diye di odoo oso Samaliya odoo oso Godeeyo to duloso tei too goo ee duloso, Pita dio Yonee dio Samaliya tei telaga odoo dimapoo diye, diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Esino Samaliya mi toowa ee ma kulodu Sebasete mi mapoo debeli tei telaga odoo oso Lodee Yesuwo hu maga howo ogusigaloso, debei odoo omapoo Dio Tei oso dimapoo meledebelega debeiso. Eseme Pita dio Yonee dio Sebasete mi mapoo sibileso, tei telaga odoo mapoo dibada deeso sigolone, Godee mapoo takeme, Dio Tei oso dimapoo meledabaso. ");
INSERT INTO kkc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eseme Saimoneeye goo hagee ogoloso, diye di odoo dimapoo molee ayo tosimi ee tenelame goolone, ");
INSERT INTO kkc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","egeesee takaso, “A goomogo, mo deeso odoo mapoo sigolone, Godee mapoo takooga, Dio Tei oso dimapoo ka meledoboo dalame. Niyo kitulugu egee tomo silesibo amapoo tenee,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Esino Pitaye yimapoo egeesee takaso, “No nee molee sabolo Dou mi mapoo dileiso. Bei, Godeeye emegei di bi maga Dio Tei wulayo hagee tenemolo, nayo see moleeso talai diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Osoloso no ibolo Godeeyo tou hodobo talai koo tobuo. Bei, Godeeyo howo woola nee goo goolee egee diya tokenee. ");
INSERT INTO kkc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Esiga no epedee nayo tokenee goolee omaga mudu opusomo doloso Godee mapoo takee. Egeeseega nayo tokenee egee goolee molo, yayo hapoloso boobado bigilei malaiso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Eseme Pitaye Saimon mapoo see egeesee takaso, “Ayo ogoso, nee sooloo ma kulodu emegei heiga toowa molone, goo tokenee mapoo hamamee dodomo siliso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Esiga Saimoneeye obulone see Pita dio Yonee dio dimapoo egeesee takaso, “A goomogo, niyo a Godee mapoo takee, bei niyo taka goo oso amapoo peledebelega pagalame,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Osoloso hamamee Pita dio Yonee dio oso Yesu sabolo silee goo ee odoo susuga mapoo takoloso, see Yelusalem mapoo dulone, Samaliya ma kulodu mibia pepooko abo mapoo to tekepo takomo diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Biame heeso Godeeyo momaiye oso Pilipi mapoo egeesee takaso, “No toboloso Yelusalem maga Gasa mi mapoo dili eli omapoo di. Eli egee osoko sibili deedee dokolo mapoo miwe poogoo mi mapoo moloso,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Eseme Pilipiye toboloso dulone eli domopoo egeino, Itiyopiya wiligi odoo hee, Itiyopiya mi eyo wiligi taba sobo Kandake eyo molee gibadeli odoo egeiso. Yo Yelusalem mapoo Godeeyo hu dokodoo poudalame di oso see wedi sibulone, talaka masi, esino hosee be omapoo bagagoloso, hosee be oso gisibamo dimolome mapoo buloso, Godee maga to toloso kokodo takomo sili odoo Aisayaye hogugu booka hesigamo sibumeleeso. ");
INSERT INTO kkc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eseme Dio Tei oso Pilipi mapoo egeesee takaso, “No dileso odoo koola omapoo tebee,” diso. ");
INSERT INTO kkc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eseme Pilipiye odoo hee yima koola omapoo hoguo sibileso tobudulone duno, odoo yayo Godee maga to toloso kokodo takomo sili odoo Aisayaye hogugu booka hesigamelee duso. Eseme Pilipiye yimapoo egeesee woosaso, “Nayo egee hesigamolo goo eyo bei no gooleedoosomo?”