﻿USE sofia;
DROP TABLE IF EXISTS sofia.kjs_vpl;
CREATE TABLE kjs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kjs_vpl WRITE;
INSERT INTO kjs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Go remaa madaare Yesu Keriso-na kasuanuna bi abala go-rupa lemena. Abalare Yesuna kasua Devit pirisa. Devit-na kasua medare Abraham pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham-re Aisak-na aaraa pirisa. Aisak-re Jekop-na aaraa pirisa. Gore Jekop-re Juda-para nipuna amenu-para nimuna aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda-re Peres-para Sera Iapona aaraa pirisa. Nipuna amare Tamar pirisa. Peres-re Hesron-na aaraa pirisa. Hesron-re Ram-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-re Aminadap-na aaraa pirisa. Aminadap-re Nason-na aaraa pirisa. Nason-re Salmon-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-re Boas-na aaraa pirisa. (Nipuna agiri Rehap.) Boas nipuri Obet-na aaraa pirisa. (Nipuna agiri Rut.) Obet-re Jesi-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi nipuri King Devit-na aaraa pirisa. Devit-ri Solomon-na aaraa pirisa. (Nipuna agiri abalade Uria ena pirisa.) ");
INSERT INTO kjs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon-re Rehoboam-na aaraa pirisa. Rehoboam-re Abiya-na aaraa pirisa. Abiya-re Asa-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa-re Jehosafat-na aaraa pirisa. Jehosafat-re Jehoram-na aaraa pirisa. Jehoram-re Usia-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia-re Jotam-na aaraa pirisa. Jotam-re Ahas-na aaraa pirisa. Ahas-re Hesekia-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia-re Manase-na aaraa pirisa. Manase-re Emon-na aaraa pirisa. Emon Josaia-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia-re Jehoiakin-para nipuna amenu medaloma nimuna aaraa pirisa. Go raburi mo Israel enaalinu nimu Babilon su-para karapo ada mapaitaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nimu Babilon su-para karapo palisimi raburi kasuanuna bi gu-rupa maasimi: Jehoiakin-re gore Sealtiel-na aaraa pirisa. Sealtiel-re Serubabel-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel-re Abiut-na aaraa pirisa. Abiut-ri Eliakim-na aaraa pirisa. Eliakim-ri Asor-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso-re Sadok-na aaraa pirisa. Sadok nipuri Akim-na aaraa pirisa. Akim-ri Eliut-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut-ri Eleasar-na aaraa pirisa. Eleasar-re Matan-na aaraa pirisa. Matan-re Jekop-na aaraa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop-re Josep-na aaraa pirisa. Josep-re Maria-na aali pirisa. Maria-re Yesuna agi pirisa. Yesuri nipuna biri Gote-na Maa Rapae Ali (Mesaia) maasimi. ");
INSERT INTO kjs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gore abalare Abraham-na ruru go pirisimi enaalina epaoma puma Devit madaare kasuanuna ruru 14-pela pirisimi. Abalade Devit pirisa rabu epaoma pumare nimu Babilon karapo ada mapaitaasimi raburi kasuanuna ruru 14-pela pirisimi. Gore mapaitaasimi enaalina epaoma pumare Gote-na Maa Rapae Ali madisa rabu go madaare kasuana ruru 14-pela pa palisimi. ");
INSERT INTO kjs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keriso nipu maitana remaare go-rupa pisa. Nipuna agi Maria-re abala Josep-na minalo mada misimi. Go-rupa pirisimi pare Josep nipumi abi namisa rabu Maria-me nipu madaa Holi Spirit-mi naaki padaa pa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Go ena nipuna pulalo pi aliri Josep yapare nipu ora epe ali yaa-pulu nipumi Maria yala namapolaano kone wisa. Go-rupa pisa-pulu nipumi pagaa wi kone suma pawasi giyalua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep nipumi go kone pa makuaaba pirina upaame Gote-na ensel meda adisa. Go ensel-me nipu-para talo: Josep nere Devit-na si. Nena ena Maria meape paalame nakomape. Paga, mo lo robaa-para pia naakiri Holi Spirit-mi mapiraaripade. ");
INSERT INTO kjs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nipumi naaki matia rabu nipuna biri Yesu lape. Gore nipumi enaali raayona koeyae elenu mea raakepe ruboma nimu epe-rupa raba muma mapiraalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gore Mudu Gote-na agale lakale ali meda agale lakalisa-pulu go ele raayo apo-rupa ora pisa. Go agale lakale alimi abalade go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pagelepa, ena maapua meda ali raapu napaitalia pare naaki padaa piruma naaki matia pare go naaki nipuna biri Emanuel lamina lisa. Go bina re-re go-rupa: Gote-re naa raapu pia. ");
INSERT INTO kjs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep nipu u paluma rekesa rabu mo Ali Mudu-na ensel-me lakalisa agale pagoma nipumi go ena nipuna were-rupa misa. ");
INSERT INTO kjs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pare nipuna ename naaki padaa pa pirina nipu raapu u napalisipi. Go naaki madisa rabu Josep-me bi Yesu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria-me Yesu Betlehem adare-para madisa. Go suri Judia su ru-nane wia. Go naaki nipu madisa raburi Herot nipu ali mudu pirisa. Gore abala madinaloma kuba kedo madaa kone makuaae alinu medaloma mo naare opa ipula-nane piruma Jerusalem su-para ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Epa opopaoma agale go-rupa lisimi: Go kagaa naaki nipu Juda enaalinuna ali mudu pirape aliri ane maita ya? Naame naana su-para piruma nipu madina su waalape kuba kedo adoma epama. nipuna bi minasaato. ");
INSERT INTO kjs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gore ali mudu Herot-me go remaa pagoma pogolasaasa. Go-rupa puma Jerusalem su-para piri enaali raayo kone adaapu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Go-rupa puma Herot-me Gote-na lodo kira-ae ali kalunu-para rekena agale maalape alinu-para makiritaasa. Nimu kiritame rabu Herot-me agale go-rupa lisa: Gote-na Maa Rapae Aliri aapina su-para maitia ya? ");
INSERT INTO kjs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gore nipu lakalisimi: Judia su ru-nane Betlehem adare-para maitaaya simi. Gote-na agale lakale alimi pepa madaa go-rupa lu wisa-le pagape lisimi: ");
INSERT INTO kjs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nimi Betlehem adare-para piri enaalinuri Juda su robo ru-nane pimi. Gore Juda suna ali kalununa kone madaa ora epe-rupa pimi. Go-rupa pea-le nimina su-parare ali mudu meda piralia. Go alimiri nimi-para Israel su-para piri enaalinu-para surubalia. ");
INSERT INTO kjs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Go lu wisa agale pagomare Herot nipumi pawasi kaledoma mo naare ipula-nane piri makuaae alinu ipulupa lo lakalisa. Go-rupa puma go kuba kedo opapaaripade Di-ri aa-rabo yalo agale lorapisa. ");
INSERT INTO kjs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Go agale muma sabaaoma nipumi go makuaae alinu Betlehem adare-para wala rapaaoma agale go-rupa lakalisa: Nimi pumare puri paloma go naaki waru asa pula pulupa. Nimimi abala adasaalimi-daare ni piri-para wala epa lagialepape. Go-rupa palimiri neme page nipuna bi minasaala palua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mo ali muduna agale abala pagomare nimu pisimi. Go adoma ipisimi kuba kedo wala epa opoma puaoma pumare mo naaki madu saapiri ada kulu madaa puma aasa. ");
INSERT INTO kjs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mo kuba kedo wala adomare nimuna pu robaa-para raaname ora waru komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nimu ru-nane puma kodobaoma lisimina mo naaki Maria agiaaya puma adisimi. Go rabu nimumi su adoma rumu pege puma mo naakina bi minasaasimi. Nimuna paus loboma epe kaa pi ele medaloma kalisimi. Nimumi abu pi gol kaname warili epe ele-para paura epe kaa pi elenu-para epe kaa pi wabola ele medaloma page epa kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gore upaame Gote-me nimu lakalisa-pulu nimu Herot piri wala napisimi. Nimuna pora rado meda mada puma nimuna ada wala pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nimu abala penaaloma Gote-na ensel-me ipuma upaame Josep go-rupa epa lakalisa: Nena naaki agiaaya maa pu no Isip su-para pogola pulupa. Ne go su-para piraina wala werepe go su giyape yapi di epa lagialua. Abiri Herot-me go naaki asa puma pia. ");
INSERT INTO kjs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gore Josep go agale pagoma lisana nipu u-rumu rumuna rekoma nipuna naaki agiaaya mo Isip su-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep nipu mo Isip su-para pirina Herot komisa. Josep nipu go su-para pisare Mudu Gote-na agale lakale alinu lakalisa-pulu pa pisa. Pipa madaa Gote-na agale lakale ali nipumi go-rupa lisaa-ya: Nina naaki Isip su-para pirisa pare neme yaalisuade lu wisaya. ");
INSERT INTO kjs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gore abalade mo naare ipula-nane piri alinumi Yesu madina su Herot nalakeloma pogola pisimi-pulu Herot-me nimu rono pagisa. Herot nipumi mo kimisu alinu-para agale lorapisa rabu go alinumi mo kuba kedo opisade di lakalisimi-pulu Herot-me mo naaki madina yapi di makuaaoma lu makomaatalo pisa. Go raburi nipumi Betlehem su-para piruma maali laapo abe napali naaki raayo lu makomaina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Go kone madaare abalade Gote-na agale lakale ali meda Jeremaia-me abalade saa pi agaleme go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama su adare-parare agale meda pago aaeme. Go agalere nimumiri re lo piruma kodome komo aaeme. Go rabu ena Resel-me nipuna nogo naakinu madaa re lo aaya. Go rabu enaalinumi go enanuna lo robaa namakuma paeme. Dia-le nipuna nogo naaki komisimi-pulu nipu re piru aaya. ");
INSERT INTO kjs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Werepe Herot abala komenaloma Ali Mudu-na ensel medame Isip su-para ipuma Josep nipu upaame go-rupa epa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne rekoma nena naaki agiaaya maa pu nimina su Israel su-para wala pulupa. Mo naaki tyalo paade aliri abala komaade. ");
INSERT INTO kjs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gore Josep nipu rekoma nipuna naaki agiaaya maa puma Israel su-para wala pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gore Arkelaus-me nipuna aaraa Herot-na pada muma nipu Judia suna ali mudu pirisa. Gore Josep-me go remaa abala pagisa-pulu nipu go su-para pope paalame komisa. Pare Gote-me Josep upaame agale lakalisa. Go-rupa pisa rabu nimu Galili su ru-nane wala pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nipu puma Nasaret adare-para pua pirisimi. Gore abalade Gote-na agale lakale alinumi ora agale go-rupa lisimide: Nipuri Nasaret su-para piri ali lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Go raburi Jon Batais ipuma lisana Judia suri enaali napiri su-nane epa aoma Gote-na agale lakelo aasa. ");
INSERT INTO kjs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Gore nipumi talo: Gote-na Surube Yapi Di-ri abala re-para go epalia-le nimina pupitagi nape kone giyalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Abalade Gote-na agale lakale ali Aisaia-me Jon-para agale go-rupa lisa: Ali medame enaali napiri su-para agale go-rupa yolo aaya: Ali Mudu nipuna poranu waru wari salepape. nipuna pamuape pora ma-redepo yalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nipumi abalade kamel menana iri maraoma mena yogaleme warili aako let-me rabuaniaaoma yamesa. Go-rupa pumare nipumi raa-para alubi kapa-para wasu no pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Go rabu mo Jerusalem su-para Judia su raayo-para piri enaalinu-para ipa Jordan pagi-para piri enaalinu page Jon nipu piri-para ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ipumare nimuna koae-aunu la yoke agale lakalisimi rabu Jon-me ipa Jordan-para kalu-ipa measa. ");
INSERT INTO kjs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yapare Jon nipumi Farisi alinu-para Sadyusi alinu-para nimumi kalu-ipa minalo adisa. Go-rupa puma nipumi nimu go-rupa lakalisa: Nimiri koe kero madi alinu pimi. Aapimi nimi go-rupa lagia ya? Gote-na werepe rono pagape konere nimimi adobaaoma piralimi. Go rono page konere nimimi madaa pogola palimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nimimi epe kogono puma palepape. Nimimi go-rupa puma kone rulalimi-daare ora kone rulae enaalinu pitaapape. ");
INSERT INTO kjs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nimina lo-parare Abraham-re naana aapa kone nasalepape. Neme nimi lagialo: Go wia kanare Gote-me Abraham-na sinu mada ma-aulaalia. ");
INSERT INTO kjs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rai gaapiri repena re-para abala apo wia le waru namaitiade repenare pitaa poma repena sulaa-para mea kiralia. ");
INSERT INTO kjs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nemere nimi kone perekealiminalo kalu-ipa meaato. Pare werepe epaliade ali medamere Holi Spirit-na puri-para repena sulaa ele raapu kalu-ipa mealia. Niri raba mi ali yaa-pulu neme go alina age ada kepema kege radepetalo palua pare mada dia. ");
INSERT INTO kjs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nipuna kelepa nipuna kimi ripinuma aaya. Go-rupa puma mo wit-na le raapu rilipu raloma go epe kilinu kama muma nipuna kiritape ada-para sulalo palia. Gore koe rilipuri wagepu nakudili repena sulaa-para mea kiralia rabu pa roalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Go raburi Yesu nipumi su Galili giyoma ipa Jordan-nane ipisa. Nipu Jon piri puma Jon-me kalu-ipa meanialo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Go-rupa pisa pare Jon-me Yesu go-rupa lakalisa: Neme ni kalu-ipa gialiri epelea-le ake paa-daa neme kalu-ipa gialua pae? ");
INSERT INTO kjs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gore Yesumi nipu agale go-rupa abulisa: Palaina abere neme loadeau pape. Naame go-rupa palimi-daare Gote-me pamina lea-ai raayo palima. Go-rupa lisa-pulu Jon-me nipuna agale ralisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu nipu kalu-ipa abala muma wagepu nipumi ipa Jordan giyoma so pagi-nane ipisa. Go-rupa puma Yesumi go-rupa adisa: Yaa-para pora gaape lobesa rabu Gote-na Holi Spirit yaa puluma biyaa ipuma nipu madaa epaa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Go rabu agale meda yaa-para go-rupa lanyaasa: Gore nina si-le neme nipu madaa ora pedo waru pe. ");
INSERT INTO kjs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Go raburi Holi Spirit-mi Yesu nipu enaali napiri su-para maa pisa. Go rabu Satan-me nipu kone makoyatalo lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu nipu raa-para yapi ali ria malapu piruma eda nanisa-pulu reame komisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Go rabu Satan-me ipuma lisana Yesu-para go-rupa lisa: Nere ora Gote-na Si teare neme te rabu go kaname bret ma-auloma maa naina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Go raburi Yesu nipumi agale go-rupa lakalisa: Gote-na buk madaa agale go-rupa wia: Enaalinumi bret kama noma epe-rupa napirualimi pare Gote-na lagi agale raayo waru pagomare ade abuna epe-rupa pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go raburi Satan-me Yesu nipu wala so epe Jerusalem siti-para lamua pisa. Gore nipu ora so lotu ada kulu madaa marekaaoma go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nere ora Gote-na Si tea-daare gore ne go lotu ada kuluna aoma su kamaa epa pogolape. Gore Gote-na buk madaa agale go-rupa wia: Gote-me ne madaa nipuna ensel-nu lakeloma ripinaalepa tea rabu ne waru surubuma kimi ripinaabalimi. Go-rupa pea-le pogola pali-daare kaname page nena age mada natia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Gore Yesumi nipu go-rupa lakalisa: Gote-na agale wi buk madaare agale meda go-rupa wia: Neme nena Mudu Gote-na kone adolalo namaperekeyape lea. ");
INSERT INTO kjs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan-me Yesu wala maa pumare ora so kari meda madaa puma aaomare su raayona wi elenu Yesu mawaalisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gore nipumi Yesu go-rupa lakalisa: Neme ni madaa rumu pege puma nina bi minasaali-daare go su kamaa wia ele raayo ne gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Go rabu Yesumi nipu go-rupa lakalisa: Satan nere pane pu. Gote-na buk-mi agale go-rupa lea: Nena Mudu Gote komea pia-le nipu komeana bi minasaoma nipu komeana kogono pape. ");
INSERT INTO kjs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Go raburi Satan-me Yesu nipu giyainaloma Gote-na ensel-numi nipu raba mula ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesumi Jon karapo ada mapaitaarimi remaa pagisa-pulu nipu Galili su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gore nipu Nasaret su-para napirisa pare Kaperneam su-para puma pirisa. Kaperneam suri ipa Galili le pagi-para aasa. Go Kaperneam adare-re Sebulun-para Naptali su laapona robo rikirana aasa. ");
INSERT INTO kjs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gore abala Gote-na agale lakale ali meda Aisaia-me laoma ipisa agale raluma pa kama ipisa agale raluma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun su-para Naptali su lapo-para piri enaalinuri nimina su laapona porare mo ipa pagi-nane puma ipa Jordan-na mone pane aina. Go su laapo-parare ora Galili su robo ru-nane aasa pare ruru rado enaali adaapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Go su ribaale-para pirisimi enaalinumiri nimumi epe adaa paa adalimi. Enaali raayore komape su ribaale-para piri enaalinu nimi pimi-para paa ora epalia. ");
INSERT INTO kjs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Go raburi Yesumi nipuna epe agale remaa lakalisa: Gote-na Surube Yapi Di ora re-para go ipula-le nimimi koe kone giyoma lo robaa perekealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu nipu ipa Galili le pagi-nane pamua aasa rabu nipumi ameaya laapo adisa. Go ameaya laapore Saimon Pita-para ame Andru laapome wena meape kogono puma agona pa kama pisipi. ");
INSERT INTO kjs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Gore Yesu nipumi talo: Nipiri ni raapu baina. Go wena meapenya-rupa nipimi enaali mealipinalo mogeaalua-le ipulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gore nipu laapome wagepu mo wena agona giyoma nipu raapu pisipi. ");
INSERT INTO kjs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nipumi wala ogesi-daa puma ameaya laapo meda adisa. Nipu laapore Sebedi-na si Jems-para Jon ameaya pirisipi. Nipuna aaraa Sebedi raapu ipinu madaa piruma nimuna wena agona rabu lala pirisipi. Yesumi nipu laapo ipulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gore nipuna aapa page mo ipinu page giyoma Yesu raapu pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nipu Galili su raayona pora pamuala pisa. Go-rupa pumare nipumi Juda alinuna lotu adanu-para enaalinu Gote-na surube suna agale pamu lakalisa. Gore nipumi Gote-na Surube Yapi Di madaa epe agale pamu lakeloma lisana mo enaalinu nimuna yaina rado rado maperekeaaoma nimuna yogale ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Go-rupa pisa-pulu nipuna bi so Siria su robo raayona piri enaalinumi pago kiritasimi. Go pagomare enaalinumi pago kiritasimi. Go pagomare enaalinuri nimuna yaina rado rado-para radaame komalimi enaali page mea ria ipisimi. Nimuna yainare koe remo nimu madaa piruma makeyae enaalinu page piruma kuli raayo koma pe page nimu mea ipisimi. Yesu nipumi nimu raayo maperekeaa kiritasa. ");
INSERT INTO kjs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Go rabu ora enaali adaapumi Yesu raita maa pisimi. Nimuna suri Galili-para adare Dikapolis-para Jerusalem su-para Judia su robo ru-nanepara ipa Jordan-na mone pane piri enaalinu-para ora raayore agale pagoma raita maa pamsimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu nipumi mogo enaali adaapu adoma nipu so rudu madaa opasaoma puma pirisa. Go rabu nipuna disaipel aalinu meda-para epa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Go rabu Yesumi nimu agale go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nimi raayona lo robaa-para epe kone mulalo piruma makuaalimi-daare raana komalepape. Gote-na Surube Yapi Di nimimi ora mealimina. ");
INSERT INTO kjs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nimi raayome re lo pimi-daare ranaa komo piramina. Gore Gote-me nimina lo robaa-para kuma mapainaalo go-rupa palimina. ");
INSERT INTO kjs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nimi raayome nimina bi rabuaniaalimiri gore ranaa komo piramina. Gore nimiri Gote-me su raayo gialia. ");
INSERT INTO kjs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nimi raayome Gote-na epe kone komea mulalo palimi-daare nimiri Gote-me eda rubitabenalo gialia. Go-rupa pea-le nimi ranaa komo piramina. ");
INSERT INTO kjs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nimi raayome enaalinu-para kodome komalimiri ranaa komo piramina. Gore nimi madaare Gote-me page kodome komalia. ");
INSERT INTO kjs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nimi raayona lo robaa-para epe yaaliare ranaa komo piralepape. Nimimi Gote mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nimi raayome yada mapaitaalo palimi-daare Gote-me nimi ora naa enaalinu tea. ");
INSERT INTO kjs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nimi raayome Gote-na pora raluma kedaa ritimi-daare ranaa komo piramina. Nimiri Gote-na Surube Yapi Di adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gore nimimi naa ruru pitalo raita mea epalimide rabu nimumi adoma nimi-para ero agale pu koe kedaa pi kone suma makirae agale medaloma teme-daare nimimi pa raaname komalepape. ");
INSERT INTO kjs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Go rabu nimina kone-para page raana waru komoma pedo waru palimina. Go-rupa pea-le nimi so yaa-para wi yoto epe adaapu gialia. Go koe konere nimumi abala Gote-na agale lakale alinu-para riri-nane abala mea kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nimi kone rulae enaalinuri go su kamaa piri enaalinuna rikirana aipa-rupa pimi. Go-rupa pea pare mogo aipa-na rede abala dia yaaliare gore naame ake palima rabu kusa wala ma-rede palima ya? Go pi aipare nipuna rede napea-pulu enaali mea ruboma alimi rabuaa timi. ");
INSERT INTO kjs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nimiri go su kamaa piri enaalinuna pea-rupa pimi. Go-rupa puma adare so rudu madaa warilimi rabu enaali raayome go adare-na paa waru ademe. ");
INSERT INTO kjs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Go page enaalinumiri lam meda kewoma baket rolo-para nasalimi. Dia, pare ora ada-para mudialimi-le gomere no ada ru-nane piri enaali raayo paa-para epe-rupa mada pimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Go-rupa pea-le nimina epe paame pa enaalinuna le agaa madaa raalia-daare nimumi nimina epe palimide kogono adoma nimina Aapana bi minasaalimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nimimiri neme Gote-na agale lakale alinuna agale-para rekena agale-para giyaliminalo ipisuade kone nasalepape. Dia, neme go elenu mea rubolalo naipisua pare apo rekena agalena re waatalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Neme ora nimi lagialo: Go su yaa laapo ora nadia yaaliade rabu page Gote-na rekena agalena oge lu saabae pepasinu page ora pa saabalia. Go rekena agalere ora pa saabaina Gote-me ele raayo kiritalia. ");
INSERT INTO kjs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Go-rupa pea-le enaali medalomame go rekena agalere oge agale meda kone suma enaalinumi giyalimi-daare mogo rekena agale agulaeme. Go puma Gote-na Surube Yapi-para nimu page oge enaalinu mapiraalia. Pare enaali raayome mo rekena agale waru pagoma enaali medaloma pagenalo mogeaalimi-daare gore so Gote-na Surube Yapi-para page bi adaalepe salia. ");
INSERT INTO kjs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Neme nimi lagialo: Gore nimimi Gote-na agale pagoma nimina epe koneme kogono palimiri mo rekena agale tisaanu-para mo Farisi alinu-para nimuna kogono ma-oge yalimi. Go-rupa napalimiri nimimi Gote-na Surube Yapi Di madaa na-adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Naana kasuanumi abalade pagisimi yade agalere go-rupa pagisimi: Ali meda nalu makomaape leade. Pare ali meda lu makomaliri kose pagape ali piri-para maa palimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pare neme abe nimi lagialo: Ali medame nipuna ame-para rono pagaaliare nipu kose pagape ali piri-para maa palimi. Go page ali medame nipuna ame-para agale koe tea-daare kaunsil piri-para kose talo lamua palimi. Gore ali medame ame-para ne ora makeyae ali yana tea-daare nipu mo koe repena sulaa-para maa pu palia. ");
INSERT INTO kjs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Go-rupa pumare neme Gote-para ora pili lape eda maa yawo sumare kana reke alta madaa mea epali rabu neme nena ameme ne madaa koe kone enare go kone ma-epe aape: ");
INSERT INTO kjs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Gore nena mo ritide ofa mo kana alta madaa pa yawo sape. Go-rupa puma nena ame piri wala puma mode agale koe wala puma ma-redepo yalepape. Go agale abala waru kiralumare werepe Gote-para mo eda maa puma ora pili paina. ");
INSERT INTO kjs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gore ali medame ne raapu kose loma agale salia-daare pena pora pagina palipi rabu epe kone suma agale ma-redepo yaaoma pulupape. Go-rupa napaliri go alimi ne wagepu kose pagape ali piri-para maa palia. Go-rupa pumare pagape mo alimi ne plisman-nu mea katea. Go-rupa pumare nimumi ne maa puma karapo ada mapaitaalia. ");
INSERT INTO kjs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Neme ora ne lagialo: Nena kose kabape kana raayo mada na-abulu kiritaliri gore neme mo karapo ada mada nagiyali. ");
INSERT INTO kjs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesumi go-rupa lisa nimimi go agalere abala pagisimide lisa: Neme ena paake nayolape. Neme ali paake narumape lemede lisa. ");
INSERT INTO kjs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Go agale abala pagisimide pare neme nimi wala go-rupa lagialo: Gore ali medame ena meda adalia pare nipumi go ena paake lamualua kone salia-daare go konemere mo ena abala paake nea. ");
INSERT INTO kjs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Go pea-le nena le popoke-naneme koe elenu adoma pulalo paliare neme go le yokoma rubape. Go-rupa puma nena le komea yoko rubali pare nena yogale raayo su koe-para namuma lopalia. ");
INSERT INTO kjs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Go page nena ora ki-naneme ne koe ele mulalo paliare go kiri rugulu rubape. Go-rupa puma nena yogale komea aaomare nena to yogale raayo su koe-para namuma lopalia. ");
INSERT INTO kjs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesumi wala lisa: Abalade go agale madaare kasuanumi go-rupa lisimi: Ali medame nipuna were giyalia-daare nipumi ena rugulape pepa meda were kalape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Go-rupa lisimide pare neme nimi lagialo: Ali raayome nipuna ena nagiyalepape pare go ena paake nea loma pa kama nagiyalepape. Go-rupa pea pare neme agale loma ena nagiyape. Giyaliare ne page repaayana pora rugiti. Go page pa ali medame giya ena lamualia-daare neme page ena paake yole ali pirali. Go-rupa puma repaaya makoyaali. ");
INSERT INTO kjs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesumi agale meda ora mone mone go-rupa lisa: Agale medare abalana kasuanumi go-rupa lisimi-daa abala pagemede agalere go-rupa: Nimi ora so le yaa madaa agale meda Gote-na le agaa madaa talo palimi-daare go abalana agale madaa kone waru suma palepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Go-rupa lisimi pare neme nimi lagialo: Nimimi yaa madaa pi natapape. Yaa madaare Gote nipuna pirape reke yade. Go paa-daa yaa madaa makuaa loma nimina agale puri namapalaalepape. ");
INSERT INTO kjs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Go page nimimi yaa madaa makuaa agale meda go suna bimi puri namapalaalepape. Dia-le go suri Gote nipuna age lopae su yade. Go page nimimi Jerusalem sumiri su yaa laapo makuaa agale meda natapape. Dia-le Jerusalem sumiri Ali Mudumi mea waalisade su yade. ");
INSERT INTO kjs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gore nimimi nimina kalu iri wala kaake pi pobere-daa mada namuma maalimi-pulu nimina kalu madaa yaa madaa makuaa agale page natapape. ");
INSERT INTO kjs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gore nimimi agale leme rabu e-para dia laapo agale kama tapape. Agale mone mone lemere Satan-me malaaya. ");
INSERT INTO kjs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nimimi agale abalade gu-rupa pagisimide: Ali meda nena le ape minaaliare nipuna le page ape minape. Ali medame nena agaa kimi koda tiare nipuna agaa page abuloma koda tyape lisimide. ");
INSERT INTO kjs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Go-rupa lisimi pare neme nimi lagialo: Ali medame nimi-para koeyae paliade raburi nipu-para rono napagaalepape. Dia, pare ali medame nena pa-ae ki waarame rola tiare gore perekema luma pa-ae meda-nane ora lina waalape. ");
INSERT INTO kjs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Go-rupa wala ali medame nena mamina muma ne kose madaa adialalo paliare gore nena mamina meda page nipu wala kalape. ");
INSERT INTO kjs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gore soldia ali medame nipuna elenu su ogesi-daa adaalu-para mea ria tea-daare gore neme wala ogesi-daa su rado meda adaalu nona pi-para page mea riape. ");
INSERT INTO kjs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Go page ali medame ne-para ele gi tea-daare neme nipu kalape. Gore ali medame ne-para pe meda gi tea-daare neme koau nawaalape. ");
INSERT INTO kjs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesumi agale meda wala gu-rupa lisa: Gore kasuanumi abalade lisimide agale go-rupa pageme: Nimina adami enaali-para epe pedo pi kone salepape pare nimina lore alinu-para koe kone salepape. ");
INSERT INTO kjs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Go pea pare neme nimi lagialo: Nimina lore alinu-para epe pedo pi kone waru salepape. Go-rupa page nimi-para koeyae palimiri go koe kone mea rubainalo Gote yaaloma beten tapape. ");
INSERT INTO kjs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Go-rupa palimiri nimiri so yaa-para pia Aapana enaalinu piralimi. Gote-me enaali koe epe laapo raita madaa naare apo marasaana-daa. Go page nipumi yai page ali koe epe laapo raita madaa apo epena lisana-daa. ");
INSERT INTO kjs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Go pea-le mo enaali medalomame nimi raana komalimide madaa nimu raana komalimiri go madaare epe yoto mealimina? Dia, mo takis meape alinumi page go-rupa peme. ");
INSERT INTO kjs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Go page nimina amenu-para abi paitalepape lemere mo-ainare ake leme pae? Gore kalu-ipa abi nami pa pimi enaalimi page go-rupa peme. ");
INSERT INTO kjs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gore nimi ora waru epe-rupa piralepape. Nimina aapa so yaa-para epe-rupa pia-rupa nimi page epe-rupa mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesumi go-rupa lisa: Nimimi waru adalepape. Nimimi lotu kogono pulalo peme rabu enaalinumi nimi adena kone suma napipape. Nimimi naana epe kogonore enaalimi adena kone salimiri nimina so yaa-para piri Aapame nimi yoto mada nagialia. ");
INSERT INTO kjs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Go page nimimi naarali kome enaalinu nimu ele raba mu kalemere gore nimimi penaame go ele mealepa loma yaalari napulupape. Go-rupa palimiri nimimi makirae agale le enaalinuna kone komea mogeleme. Nimuri lotu ada-para mo pora pagina page pamuma ele kaleme. Gore mo piri enaalinumiri nina bi komea minasaaina kone wimi. Nina agale pagalepa. Go-rupa pemere nimuna rudu elenu abala penaame go mu aaeme-daa. ");
INSERT INTO kjs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pare nimimi mo enaali naralinu raba mulalo palimiri ora ki-naneme palide ele pope ki-naneme namakuaaina lape. Nena adami ali page agale napagena lape. ");
INSERT INTO kjs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dia, pare pagaa wi kone suma epe bi mulalo kogono palepape. Go-rupa palimiri nimina Aapamere nimina epe pagaa wi kogono adoma nimi epe yotome abutea. ");
INSERT INTO kjs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesumi agale meda go-rupa lisa: Nimimi beten lemede raburi makirae agale le enaali-rupa natapape. Nimimi lotu ada ru-nane aoma beten tapape. Go page nimumi adaa pora kebo-nane page enaalinumi naa adena kone suma beten natapape. Go-rupa peme pare nina agale pagalepa. Gote-me nimuna yoto elenuri abala kalisa. ");
INSERT INTO kjs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Go yapare nimi beten ripia talo palimide raburi nimina ada rum-para puma pora poma nimi na-adape aapa madaa beten tapape. Go-rupa pumare nimina Aapame apo epe kaledoma leme beten adoma nipumi nimi-para page abutea. ");
INSERT INTO kjs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Go page nimimi beten lemede raburi pa agale meda yoloma nale giyalepape. Mo kalu-ipa nami enaalinumi beten yoloma adaapu leme rabu waru pagalia kone wimi. Go-rupa natapape. ");
INSERT INTO kjs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nimi nimuna kone naratalepape. Dia-le nimimi beten talo agaleme abala managolaeme raburi nimina aapa Gote-me nimi madaa rudu lea ele raayo abala adoma makuaaya. ");
INSERT INTO kjs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gore nimimi beten go-rupa tapape: Naana aapa, nere yaa-para pili. Nena biri ade abuna epe-rupa. ");
INSERT INTO kjs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nena Surube Yapi Di epena. Nena konemere so yaa-para go-rupa peme-rupa su kamaa naame page go-rupa palima. ");
INSERT INTO kjs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Abi go yapi komea madaare neme naana eda giape. ");
INSERT INTO kjs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Neme naana koe elenu mea rubaina-le naame page koe kone saapirape enaalinuna kone mea rubalima. ");
INSERT INTO kjs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Neme naare koe kedaa pi eleme ko nataina pare Satan-me naa natinalo surubape. ");
INSERT INTO kjs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pagalepa. Nimimi enaali medalomana koe elenu mea raakepe rubalimiri gore nimina so yaa-para pia Aapame nimina koe elenu page mea rubalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pare nimimi pa enaali medalomana koe elenu namuma raakepe rubalimiri nimina aapa nipumi page nimina koe elenu mada namuma rubalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesumi agale meda wala gu-rupa lisa: Gore nimimi lotu kone suma eda giyalimi rabu makirae agale le enaali-rupa napipape. Nimuna le agaa-para reame kome-rupa napiramina. Go-rupa puma nimi reame kome enaali kone suma kone minalo peme. Pagalepa. Nimuna yoto elere abala meme. ");
INSERT INTO kjs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pare nimimi nape ele madaa niti puma giyalimi rabu nimina kalu-para wel maa pumare nimina le agaa-para waswas tyalepape. ");
INSERT INTO kjs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Go-rupa palimi raburi nimimi eda giyalimina enaalinumi mada namakuaalimi. Nimumi mada na-adalimi pare nimina Aapame apo kudiri pu konere nipumi mada adalia. Go-rupa pumare nena epe yoto mada abutea. ");
INSERT INTO kjs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nimimi epe elenu go su kamaa nakirita salepape. Go su kamaare go epe elere bolonumi noma pa ramualia. Go su-para page paake ne alinumi pape aguloma meme. ");
INSERT INTO kjs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nimina epe elenu raayore go su kamaa nakirita salepape pare go elenu so yaa-para kirita salepape. So yaa-parare bolonumi nanoma mada naramualia. Go-rupa puma paake ne alinumi page so yaa-para elere namealimi-le so yaa-para ele epe-rupa pa saabalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gore epe ele kirita sali-parare nena kone page go-para pa saabalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Naana lere naana tona lam pea-rupa roaaya. Le epe yaaliare gore nena to raayo page epelea. ");
INSERT INTO kjs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pare le koyaliare gore nena to raayo-para ribaa yoma koyalia. Go-rupa pea rabu nena lo robaa-para roalia paa wala kudinalia. Go-rupa puma nena yogale-para ribaa yoma ne ora makoyaalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Bosboi laapona kogonore ali komeame mada napalia. Go-rupa palia raburi ali meda madaare epe kone suma ali meda madaare koe kone suma palia. Go-rupa napilia-le ali komea madaa ora raaname komoma ali meda-parare nipu rono pagaalia. Go page nimimi Gote-na kogono pala kana kogono pala mada napalimi. ");
INSERT INTO kjs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesumi agale meda wala gu-rupa lisa: Go-rupa pea-le neme nimi lagialo: Naa epe-rupa piramina kone adaapu nasalepape. Gore naame ipa eda laapo ele nalima pa naana yogale madaa ele maraalima pa loma kone adaapu nasalepape. Gore epe-rupa pirape konemere pa nape eda kone rabuaanaaya. Go page yogaleme pa mamina maraape kone rabuaanaaya. ");
INSERT INTO kjs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nimimi so biyaa pameme yaanu adalepape. Nimuna nape repena kili maapu napoma nimuna edare ada-para nakiritaeme. Go-rupa napeme pare nimina so yaa-para pia Aapame nimu eda kalea. Pare Aapame nimi madaa wia koneme go yaanu rabuniaaya. ");
INSERT INTO kjs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nimimi go su kamaa wi ele madaa kone adaapu salimiri go konemere nimina pirape maali ogesi-daa adaalu mada namayola salia. ");
INSERT INTO kjs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Go-rupa pea-le nimina konere ake paa-daa mamina ele madaa penaateme? Nimimi oge repena kili so kamaa-nane ope-ai adalepape. Gore nipu opea rabu nipumi kogono napuma mamina page nawarialia. ");
INSERT INTO kjs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Go-rupa pea pare neme nimi lagialo: Abaladere King Solomon nipuna au mamina epe epe ele kama yamesa rabu mo plaua kili madaa pea-rupa nipumi au go-rupa pisa pare plaua-me nipuna au rabuniaaya. ");
INSERT INTO kjs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Abi e-para rilipu puti wia pare ekera wala luma repena sulaa-para kiralimi. Pa rilipu go-rupamere Gote-me pa suna au laaya. Go-rupa pea-le nimi enaalinuri ni madaa kone ogepusi rulaeme. Nimina Gote-me nimi page waru surubalia. ");
INSERT INTO kjs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Go-rupa pea-le nimimi kone adaapu go-rupa nasalepape: Naame eda ipa laapore ele nalima palo mamina ele maraalima palo kone nasalepape. ");
INSERT INTO kjs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Go kone raayore su kamaa kone narulae pa piri enaalinumi nimuna meape kone yade. Pare nimina so yaa-para pia aapa nipumi nimi adoma ele gialia. ");
INSERT INTO kjs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Go kone nasalepape pare kone perekeyo suma Gote-na Surube Yapi Di madaa page nipuna pape kogono page go laapo madaa kone abala saapiralepape. Go-rupa palimi-daare nipumi ele radonu page mada nimi gialia. ");
INSERT INTO kjs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Go-rupa pea-le bureka-nane ake palua pe kone nasalepape. Dia-le bureka-nane pape kone sape elenu pa epalia. Gore yapi meda madaa kedaare pa narialepape. Gore pa kedaanu yaa-pulu nipuna pa epalia. ");
INSERT INTO kjs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesumi agale meda wala go-rupa lisa: Nimimi enaali medaloma pa kama namariaaoma kose laaoma namuma rumaalepape lisa. Go-rupa puma Gote-me nimi page go-rupa mada mea rumaalia. ");
INSERT INTO kjs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nimimi enaali meda pa kama mariaoma kose leme-daare gore Gote-me nimi madaa go-rupa komea-rupa abutea. Nimimi go-rupa rumaalua kone salemede-rupa go rumaape kone madaare Gote-me nimi komea-rupa abutea. ");
INSERT INTO kjs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gore nimina amena le-para oge le mare abala adema leme. Go-rupa pea pare nimina le-para wi repena reke pena ademe. ");
INSERT INTO kjs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gore nimina le-para repena reke wia-le ake paa-daa go-rupa leme: Naa ame, nena le-para wia oge le mare mea rubano leme. ");
INSERT INTO kjs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Go ali nere makirae agale le ali yade. Abala ririnare nena le-para wia repena rekelepena maa rubape. Go-rupa puma werepere le adolalo puma nena amena le-para aaya loma epe-rupa mada mu paina. ");
INSERT INTO kjs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nimimi Gote-na elere yananu nakatapape. Go-rupa pumare wala nimumi kauloma ne nolalo palia. Go page nimi kulubunu epe epe elenu menana maa-nane namaitialepape. Go-rupa pumare nimimi mogo epe kulubunu rugulabebe palimi. ");
INSERT INTO kjs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesumi go-rupa lisa: Nimimi Gote-para beten teme-daare nipumi mada gialia. Nimimi ele asa palimiri nimimi mada adasaalimi. Nimimi pora gaape puma tya tya palimiri Gote-me nimi-para pora gaape mada lobalia. ");
INSERT INTO kjs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Enaali raayome Gote-para beten lemere gore nimumi elenu mada mealimi. Enaali raayome elenu asa palimi-daare mada ada salimi. Gore alimi pora gaape tia-daare Gote-me pora mada lobalia. ");
INSERT INTO kjs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gore nimina naakinumi aapa yaaloma bret meda gi tea-daare nipumi kana meda mea katea ya? Dia. ");
INSERT INTO kjs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Go page mo naakimi aapa yaaloma wena page meda gi tea raburi koe kero meda katea ya? Go page mada nakaeta. ");
INSERT INTO kjs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Go-rupa pea-le nimi alinumi nimina naaki nogonu epe elenu pa kaleme-le nimina so yaa-para pia Aapamere nipu madaa beten leme-daare nipumi epe ele page pa maa gialia-le beten loma agale mealepape. ");
INSERT INTO kjs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pa enaalinumi epe kone muma ni komea go-rupa meda pina kone salimade-rupare neme page go-rupa pape. Gore apo kone madaare Moses-na rekena agale-para Gote-na agale lakale alina agale raayo go-para wia. ");
INSERT INTO kjs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesumi agale go-rupa lisa: Nimiri oge pora gaape-para ora puma puaa kodobalepape lisa. Pora medare mo koe su-para pope pora gaapere ora adaalepe mada lobapa wia. Enaali adaapu pere go pora-para pulalo peme. ");
INSERT INTO kjs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Go-rupa pea-le ade abuna kagaa pirape pora gaapere ora ogeasi yaa-pulu kalai waru palimi. Go-rupa pea-le enaali komea komea lo go pora-para mada palimi. ");
INSERT INTO kjs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesumi agale meda go-rupa lisa: Gote-na bi madaa makirae agale le alinuri waru adalepape. Nimi piri-para epalimi rabu nimumi epe sipsip menana yogale aako yameme pare nimuna lo robaa-para raa yana-na kone suma nimi nolalo peme. ");
INSERT INTO kjs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Go makirae agale le alinu epalimi rabu nimumi kogono palimi waru adoma makuaalepape. Repena keto keto aayari epe repena wain-na le mada namaitia. Go page repena fik-na epe kiliri mo po rilipu pepo puti-para mada naralemade ora dia. ");
INSERT INTO kjs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Go-rupa pea-le ipa waru piri repena raayo madaa kili epe-rupa maitaa. Pare koe kaapu le repena raayo le koe-rupa maitaa. ");
INSERT INTO kjs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Epe repenamere repena kili koe-daa mada namaitia. Go-rupa kama repena koeme epe repena kili meda namaitia. ");
INSERT INTO kjs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Repena raayo kili epe-rupa namaitalia-daare poma repena sulaa-para meakiralia. ");
INSERT INTO kjs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Go-rupa pea-le mo Gote-na bi madaa makirae agale loma makirae alinumiri kogono peme rabu nimuna maitialimi kili adalimina. ");
INSERT INTO kjs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gore enaali raayome ni-para Ali Mudu leme pare nimimi Gote-na Surube Yapi-para madaa na-adalimi. Dia, pare enaali raayome naana aapa so yaa-para piana kone raitalimiri Gote-na Surube Yapi-para mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Apo yapi di epaliade rabu enaali adaapumi go-rupa teme: Ali Mudu, neme abalade nena bi enaali laketalo epe agale mogeaasima leme. Nena bi lakeloma abalade naame enaalina koe remonu mea ruboma napi kogono adaapu pisima leme. ");
INSERT INTO kjs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Go raburi neme nimu-para go-rupa laketoa: Neme nimina le-para na-adisuade-le nimiri koe enaalinu-le ni piri-para pane pulupa toa. ");
INSERT INTO kjs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesumi agale meda go-rupa lisa: Enaali raayome nina go agale pago raitalimi-daare nimuna epe konere go-rupa wimi: Ali medame ada puma kaname puri mapalaasa. ");
INSERT INTO kjs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Go-rupa pumare yai ipisa raburi ipa roma rubisaaoma puri pale po rilipumi ipuma go ada walu walu malaasa. Go pisa pare mo ada ora kaname puri waru mapalaaoma pisa-pulu mada narobesa. ");
INSERT INTO kjs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yapare enaali raayome nina agale pagoma naraitalimiri nimuna kone go-rupa wimi: Go enaalinuna konere ada pigi puri namapaalae pa mabaoma peme. ");
INSERT INTO kjs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Go-rupa pumare yai ipuma ipa roma rubisaaoma puri pale po rilipu page ipuma mo ada epa marobaasa. Gore mo ada lopesa rabu ora e waru lisa. ");
INSERT INTO kjs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesumi go agale pu kiritasa rabu pirisimi enaali raayome pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gore nipumi agale lakalisa rabu nimuna rekena agalena lisimi tisaanu-rupa nalakalisa. Dia, pare nipumi puri pale alina agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu so rudu giyoma kilipiaoma ipisa pare enaali raayome wala nipu raita maa ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Go rabu yakilimi li ali meda Yesu piri-para epa rumu pege puma piruma nipumi talo: Mudu Ali, neme nina yaina mada ma-epeaaina kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesumi nipuna yogale madaa ki waraaoma talo: Go-rupa palua-le abe kaapu yaina. Go-rupa lisa rabu wagepu mo rere raayo kaapu yabesa. ");
INSERT INTO kjs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesumi nipu-para talo: Nere adobape. Neme enaali medaloma nalakelape. Nena yogalere Gote-na lodo kira-ae alimi adena pope. Go-rupa pumare Moses-me lisa-rupa eda yawape. Go-rupa pali raburi nena yainare abala go dia yanalo enaalinumi mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu nipu Kaperneam su-para pisa rabu soldia alinuna Ali Mudumi Yesu nipu-para agaleme go-rupa ogelisa: ");
INSERT INTO kjs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Mudu Ali, nina kogono naakiri yaina komoma ada saabaaya. Nipuna kuli raayo komapaoma radaa ora adaalepe pea. ");
INSERT INTO kjs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Gore Yesumi talo: Neme nipu maperekaala palua. ");
INSERT INTO kjs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yapare mo soldia alinuna Ali Mudumi Yesu nipu agale go-rupa lakalisa: Mudu Ali, niri epe ali-daa dia-le nere nina ada-para mada na-epali. Go-rupa pea-le neme pa agaleme te rabu nina kogono ali mada rekalia. ");
INSERT INTO kjs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ni page naa soldia ali kalunumi ni surubeme. Neme soldia alinu page surube. Go-rupa pea-le neme soldia ali komea-para ne pu toadere nipu mada palia. Ali meda ne nipu toa raburi gore nipu mada epalia. Gore mo nina kogono naaki-para go kogono pa leare gore nipumi mada palia. ");
INSERT INTO kjs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesumi go agale pagoma kone adaapu wisa-pulu mo nipu raapu ipisimi enaalinu-para go-rupa lakalisa: Neme ora nimi lagialo. Israel su-para ali go-rupa kone rulae ali meda abalade page napirisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gore agale pagalepa: Enaali adaapu mo naare opala-nane page pabala-nane page epalimi. Gore nimumi Abraham-para Aisak-para Jekop-para so Gote-me Surube-na Su-para piruma kasuanu raapu eda no piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Go-rupa palimi pare enaali medaloma so Gote-na Surube Yapi Di adolalo peme enaliari nimu ribaale-para wala mea ralu tia. Go raburi re waru loma nimuna kabulu regepe no radaa nalimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesumi mo soldia alinuna mudu ali go-rupa lakalisa: Nere abe pu. Neme kone rulaaye-pulu nena kone sae-rupa ora palia. Go-rupa lisa-pulu nipuna kogono naakiri ora go rabu-le ma-epe aasa. ");
INSERT INTO kjs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu nipu Pita-na ada-para puma kodobaoma Pita-na aayaa riripu yaina komoma paitae wina adisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gore Yesumi nipuna ki minaa misa rabu mo riripu yaina abala wagepu dialisa. Go rabu nipumi rekomare Yesuna eda kiraasa. ");
INSERT INTO kjs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gore alebore enaali medalomame koe remo piri enaali Yesu piri-para mea ipisimi. Nipumi agaleme loma go koe remo raayo ralu rubisa. Go-rupa puma nimuna yaina raayo page ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Go-rupa pisare abalade Gote-me agale meda Aisaia-na buk-para go-rupa lisa: Nipumi naana yaina raayore abala mea ruboma naana yaina rado rado page ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gore enaali adaapumi Yesu kutapu ma-aasimi rabu nipumi talo: Naare ipa mone pane kenao mone maa baina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Go rabu rekena agalena tisaa meda ipuma lisana Yesu go-rupa epa lakalisa: Tisaa, su raayona pamuali rabu ni ne raapu pamuapana. ");
INSERT INTO kjs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Gore Yesumi nipu lakalisa: Raa yana pali-parare su-para naaku wia. Yaanu page ada warilimi pare ni enaali Raapu Pirape alina Siri nina pomo mu piruma paitape ada dia yade. ");
INSERT INTO kjs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Go-rupa lisa rabu nipuna disaipel ali medame nipu go-rupa lakalisa: Mudu Ali, ora lale pare nina aapa abala rogala pono. ");
INSERT INTO kjs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pare Yesumi nipu lakalisa: Gore kome enaalinumi nimuna kome enaalinu yago rogaalimi. Nere saana bana lisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu nipu ipinu madaa piruma lisana nipuna disaipel alinu nipu raapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Go rabu mo ipa adaalepe porilipumi ipuma ipinu mapereke yolalo pisa. Go-rupa pisa pare Yesu nipu pa u paitae wisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Go-rupa pisa rabu mo alinumi Yesu nipu puma marekaaoma talo: Mudu Ali, neme naa raba mea. Naare go ipa madaa makoyaaoma ipa apo nalem-daa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gore nipumi nimu lakalisa: Ake pa-daa nimimi paala komoleme ya? Nimiri naa agale ogepusi lo robaa-para muma kone rulaeme. Gore nipu rekoma po rilipu-para ipa laapo puri pale agale lakalisa. Go rabu po rilipu loraoma ipa lewa ogesi-daa lewa napisa. ");
INSERT INTO kjs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Go rabu nimumi pogolasaoma talo: Go aliri ake pi ali ya lisimi? Go ipa-para po rilipu laapome nipuna agale pagala lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu nipu ipa mone pane puma mo Gadara ruruna su-para opapasa. Go-parare koe remo pabo piri ali laapome tapa apedaa giyoma Yesu nipu piri-para ipisipi. Nipuri ora raa-para makeyae ali laapo yaa-pulu enaali raayo pala komoma go nipu ae pora pagina napamisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gore nipu laapome puri paloma go-rupa yaalisipi: Nere Gote-na Si-le neme naa piri-parare ake pulalo epae? Gore go elenu pape di abe dia-le neme naa radaa maa gulalo ake paa-daa epae pa lisimi? ");
INSERT INTO kjs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Go rabu menanu adaapupe mo-pare aoma eda nala aasimi ");
INSERT INTO kjs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mo koe remome Yesu-para go-rupa ogesimi: Neme naa ralu tyalo pali-daare naa mogo menanuna lo robaa-para ralutape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Gore Yesumi mo remo-para nimi pulupa lisa-pulu nimumi mo ali laapo giyoma remo nimu mo menana lo robaa-para puma kodobasimi. Go mena raayo alo puma mo raita madaa lopoma ipa le-para puma ipa noma komabasimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Go rabu mo mena surube alinu nimu pogola pisimi. Nimu adare-para puma go remaa enaali raayo-para puma lakalisimi. Lakalisimi rabu mo koe remo pabo piri ali laapo madaa piai-nu raayo remaa puma lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Go rabu mo adare-para piri enaali raayome Yesu nipu madama ipisimi. Go-rupa puma nimumi nipu epa adoma go-rupa lakalisimi: Go su giyoma nena su rado-para pu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu nipu ipinu madaa piruma ipa mone pane puma nipu adare meda-para puma opapasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Go rabu yaina kome ali meda Yesu piri-para ria ipisimi. Go-rupa pirisimi pare nipuna kuliri raayo koma penaloma tapa madaa saabaasa. Yesumi nipuna kone rulae adisa rabu mo yaina kome ali lakalisa: Go naaki, paala nakomape. Nena koae-aunu raakepe rubaato. ");
INSERT INTO kjs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Gore rekena agale tisaa-nu medalomame go agale pagoma nimuna kone-para go-rupa wisimi: Go alimiri Gote-para ero lea, kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesumi mo nimuna kone-para abala adoma nimu-para talo: Ake paa-daa nimina kone-para go-rupa saleme? ");
INSERT INTO kjs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ake puma kuma pi agale toa ya? Nena koe elenu mea rubano kedaa pia? Ne rekoma pora pu lano kedaa pia? ");
INSERT INTO kjs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pare ni enaali Raapu Pirape alina Siri go su kamaa enaalinuna pupitagi neme kone mea raakepe rubalua-le puri adalimina. Go-rupa puma nipumi mo kuli koma pe ali-para talo: Ne rekoma nena u pali elenu mea ripinuma nena ada-para pu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Go-rupa lisa rabu nipu rekoma nipuna ada-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Enaali raayome go-ai adoma lisimina paalame komisimi. Gore Gote-me go au pinalo puri kalisa-pulu nimumi nipuna bi minasaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu nipu go su giyoma pisa rabu ali meda Matyu nipu kana takis mi ada-para pirina adisa. Go-rupa puma Yesumi nipu-para talo: Nere saana bana. Go-rupa lisa rabu nipu rekoma raita maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu go alina ada-para eda nala pirisa. Go rabu kana takis mi alinu-para narali pabe enaalinu medaloma-para Yesu page nipuna disaipel alinu raapu piruma eda komea-para nisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Go-rupa pirisimi rabu Farisi ali medalomame go kone adoma nipuna disaipel alinu lakalisimi: Nimina tisaa mo takis mi alinu-para naarali enaalinu raapu pia-le ake paa-daa go-rupa eda no piruaaya lisimi? ");
INSERT INTO kjs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nipumi go agale pagoma nipumi talo: Yaina nakome enaalinu nimuri dokta piri-para pemede. Dia, yaina kome alinu nimu dokta piri-para peme. ");
INSERT INTO kjs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nimimi Gote nipuna buk-para ria agale lagisade abala puma makuaalepa: Ofa sape kone madaare neme raana napea pare neme raba meape kone madaa pedo pi. Yesu wala talo: Neme ora epe enaalinu kama raba mulalo naipisua. Dia, pare naarali enaalinu page raba mulalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Go raburi Jon-na disaipel alinu Yesu piri-para ipuma nimumi nipu-para talo: Farisi alinu naa page eda madaa niti puma adoba aema. Go-rupa pema pare ake pea-daa nena disaipel alinumi eda pa nena lae ya? ");
INSERT INTO kjs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Gore Yesumi nimu lakalisa: Go ena lamulalo pe aliri nipuna rurunu raapu pa piralia rabu nimuna kone-para kedaa napalia. Pare werepere go ena lamulalo pea aliri wala giyalia-le go rabu mo nipuna rurunumi kodome komoma eda nape madaa niti puma pa piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ali medame kagaa mamina kuni nipuna abalana mamina podopele-para narabutea. Dia, pare nipumi go-rupa ruguluma rabutea-daare mo mamina wala mariripiaama puma adaapu riripi tyabalia. ");
INSERT INTO kjs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Go page abalana meme mena yogale-para ali medame kagaa ipa wain mada nakoeyaalia. Go-rupa pali-daare mo kagaa ipame meme mena yogale mariripiaaoma mo ipa su kamaa koyalia. Go-rupa pumare mo meme mena yogale page mapodopealia. Gore kagaa ipa wain-ri ora kagaa meme mena yogale raapu no ritimiri laapo raita epelea. ");
INSERT INTO kjs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesumi nimu-para go agale pena lakelala aina ali mudu meda Yesu piri-para ipuma rumu pege puma go-rupa lisa: Nina nogore abe ora le kadupia pare neme epa ki sali rabu mada rekalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Go-rupa lisa rabu Yesu nipu mo ali mudu raapu pulalo pisa rabu nipuna disaipel alinu page pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pora pagina pisimi rabu ena medare nipuna yapi pupulae yainare maali ki lapo pege puma agena lapo rupa-para popisa. Go ena nipu Yesuna koau-nane ipuma nipuna mamina kale-nane kimi waraasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Go ena nipuna lo robaa-para kone go-rupa wisa: Neme nipuna mamina madaa kimi waraaluare nina yaina mada dia yaalia kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Go-rupa pumare Yesumi nipu wala perekeyo adoma talo: Go nogo. Neme ni madaa kone rulaae-pulu nena yaina abi ma-dia yaato. Ora go raburi go yaina epeasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gore Yesu nipu mo ali muduna ada-para puma opapaasa. Go-parare enaalinumi pe ruli loma re adaa pu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gore Yesumi talo: Nimi pane piralepa. Go nogore pa u paitana. Ora lena kadupiana. Go rabu nimumi nipu giri laasimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mo enaali raayo pa pirinaloma Yesu nipumi mo nogona ada rum ru-nane puma ki mina muma nipu marekaasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Go-rupa pisa-pulu go remaa su raayo-para pago kiritasimi. Yesumi le rabuli ali lapo-para agale maarea alinu page puma ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu nipu go ada giyoma pora pamisa rabu le rubu pi ali laapome nipu raita mea ipuma go-rupa yaalisipi: Nere Devit-na si-le saa raba mea lisipi. ");
INSERT INTO kjs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Gore Yesu ada ru-nane penaaloma mo le rubu pi ali laapo nipu piri-para ipisipi rabu Yesumi nipu-para talo: Go kogono mada palua-le nipimi ni madaa kone rulalipi ya? Nipumi talo: E, Mudu Ali mada palipa lisipi. ");
INSERT INTO kjs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Go-rupa lisipi rabu Yesumi nipuna le kimi waraaoma talo: Nipimi ni madaa kone rulaalipi-daare nipina le madaa epetea. ");
INSERT INTO kjs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Go-rupa pumare nipuna le wala epe lisa. Go-rupa pumare Yesumi nipu-para puri pale agale go-rupa lakalisa: Nipimi waru kudiri palepape. Enaali medaloma nalaketapape. ");
INSERT INTO kjs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pare nipu giyoma pisa rabu go su raayona Yesuna remaa pamisa. ");
INSERT INTO kjs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Go-rupa palaina enaali medalomame agale maare koe remo pabo piri ali meda Yesu piri-para mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Gore Yesumi mo koe remo mea rakepeaasa rabu nipu laapome agale lopaasipi. Gore enaali raayome kone adaapu suma go-rupa lisimi: Go Israel su-para napi kogono go pamu pia-daa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pare Farisi alinumi talo: Koe remonuna ali mudumi nipu puri kalenaloma go remo koena ali kalunumi puri kalenaloma pamu pia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu nipu su adare raayo-nini pamuma lisana nimuna lotu ada-para agale pamu mogeaasa. Mogeaasa rabu nipumi Gote-na Surube Yapi Di madaa epe agaleme loma lisana enaalinuna yainanu ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nipumi mo enaali raayo kodome komisa. Gore nimuna kone mabebola luma koe-rupa pirisimi-pulu nipumi kodome komisa. Mo sipsip-mena puni aaraa napirisa-rupa go enaalinu kalae-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Go-rupa pirisimi-pulu Yesumi nipuna disaipel alinu lakalisa: Eda adaapu mo maapu-para poro aaya pare kogono pape alinu adaapu napimi. ");
INSERT INTO kjs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Go-rupa pea-le nimimi go maapuna aaraa-para eda kili maa kirita sula epena beten tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu nipuna aposel kogono ali 12-pela yaaloma nimu kogono pape-ai puri mapalaasa. Gore nimimi koe remo raluluma yaina raayo ma-edaoma enaali raba minalo puri gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mo ali 12-pela nimuna biri go-rupa: Saimon-re abala ririna Yesumi nipu abala mapiraasa. Nipuna bi medare Pita. Nipuna amere Andru page mapiraasa. Go-rupa puma meda Sebedi-na si Jems-para nipuna ame Jon laapo page mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Gore Filip-para Bartolomyu laapo mapiraasa. Medalomare Tomas-para takis mi ali Matyu laapo mapiraasa. Go-rupa puma Jems-re Alfius-na si Tadius laapo mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Go-rupa puma Saimon Selot-para Judas Iskariot page mapiraasa. Go alimiri piruma Yesu tyapena kabe reke misa. ");
INSERT INTO kjs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nipumi mo aposel kogono ali 12-pela maa penaalisa rabu agale mana go-rupa lakalisa: Nimi ali ruru radonu piri-para napulupape. Go-rupa puma nimi Samaria adare-para page napulupape. ");
INSERT INTO kjs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dia, pare nimiri Israel su-para piri enaalinuri ora alu pae sipsip-rupa pimi-le nimu piri-para pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nimimiri Gote-na Surube Yapi Di abe ora re-para ipu lalo laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nimimi yaina kome enaalinu ma-edalepape. Ora le kadupili enaalinu marekaatepape. Mo yakilimi li enaalinu ma-epeaatepape. Go page koe remo mea raakepe rubalepape. Gore nimimi go puri pa mealeme-pulu mo enaalinuna yaina yoto nami mada pa ma-epeaatepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nimimi kana yo-para kana kili-para ora kana komea-para nimina oge nusi-para namaitalepape. ");
INSERT INTO kjs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Go page nimimi palimi rabu rokanu namaita pulupape. Go page alo pape mamina meda-para ali ada-para pora pamuape rimaapu page namuma pulupape. Dia-le alimi pa palimi-daare nimumi eda mada gialimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Gore nimi adare page su rado-para palimiri nimimi abala waru adalepape. Nimimi epe amenu medaloma abala waru adoma go ali raapu piruma pumare nimi meape enaali dia yaaliare paaoma palepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gore nimimi ada meda-para palimi rabu go ada-para piri enaali-para epe-rupa piralepape tapape. ");
INSERT INTO kjs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Gore mogo ada-para piri enaali epe enaali yaalia-daare gore nimina epe kone nimu madaa pa salepape. Pare nimumi abe piralepape agale na-abutimi-daare nimina epe konere wala muma go ada giyalepape. ");
INSERT INTO kjs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gore ali medame nimina agale pagolalo nipuna ada-para nalamua palia-daare gore go adare giyoma pulupape. Go rabu nimumi nimuna koe kone adenalo nimina age madaa ae kege kunu suma pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pagalepa. Werepe Gote-me enaalinu yoto mea rumaaoma katea di raburi koe adare Sodom Gomora su lapo-para pirisimide enaalinu-para kedaa kalisade. Go-rupa pisade pare go kedaamere go su-para misimide kedaa rabuniaa mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesumi go-rupa lisa: Pagalepa. Neme nimiri makeae yananuna rikirana sipsip mena si-rupa mea rapaato. Go-rupa pea-le nimimi ora pawa puma paakanumi pawa yoloma pamuade kone-na pamualepape. Go page nimimi epe kone suma so yaa-para pirape kone mealimina pamualepape. ");
INSERT INTO kjs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nimimi alinu waru adalepape. Nimumi nimi adialalo kaunsil-na ada maa puma nimuna lotu ada-para kalipu kudumi timi. ");
INSERT INTO kjs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nimumi nimi kose talo mo ali mudu balinu piri-para maa palimi. Go-rupa puma nimimi nina kogono puma nimu-para pa ruru radonu-para page epe agale mada laketeme. ");
INSERT INTO kjs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gore nimumi nimi kose lape agale lemede raburi naa ake tema pe kone adaapu nasalepape. Dia-le Gote-me go rabu laketemenalo agale gialia. ");
INSERT INTO kjs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Go rabu nimimi kama apo kose lape agale nateme. Dia, Holi Spirit nimina lo robaa-para piralia rabu nimina Aapame agale lagialia. ");
INSERT INTO kjs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Go rabu alinu nipuna amenu kose-me mariaoma lisana nipuna ame lu makomalimi. Gore aaraanumi page nipuna si-para koeyae palia. Sinumi page agi aaraanu-para agale yokoma kose lape agale loma lu makomalimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Go raburi nimimi nina pora raitalimi-pulu enaali raayome nimi ronome komalimi. Pare enaali raayome puri paboma ni nagiaoma palimiri werepe go su yaa laapo dia yaalia rabu go enaalinu ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gore nimimi adare meda-para nimi kedaa gialimiri gore adare rado-para pogola pulupape. Neme ora nimi lagialo: Israel adare raayo-para kogono mada napu kiritalimi pare enaali Raapu Pirape alina Si abala epalia. ");
INSERT INTO kjs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Skul leme naaki nogo nimiri nimina tisaa-nu narabuainaaeme. Go-rupa kama kogono pape alinumiri nimuna surube ali mada narabuainaaeme. ");
INSERT INTO kjs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Go-rupa pea-le skul nogo naakimi nimuna tisaa-rupa piralimi-daare epelea. Go page kogono pape alimi ipuna ali mudu raapu piraliare epelea. Gore nimumi ada komea surube ali-para koe bi Belsebul leme-daare gore epelea. Nipumi go koe binu page pa mealimina. ");
INSERT INTO kjs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Go-rupa pea-le nimimi pa enaalinu paalame nakomalepape. Dia-le abere ele raayo kepeabaaya pare werepe pename suma pagaae kone raayo page enaalinumi mada adoma penaame kamaa pagalimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Neme go ribaale-para lagialo agalere nimimi naare paama laketapape. Nimimi pawasi pageme agalere su rudu madaa rekaoma laketapape. ");
INSERT INTO kjs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ali medalomame enaalinuna to yogale mada lu makomalimi pare wasa mada nalu makomalimi. Go-rupa pea-le nimimi nimu madaa paala nakomalepape. Yapare Gote-me yogale-para wasa laapo repena sulaa-para mada mea kiralia-le nipu madaa paala komalepape. ");
INSERT INTO kjs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nimimi oge yaasi laapore kana kale oge komeame kabeme. Go-rupa pea pare nimuna Aapame nalakelea-daare oge yaa komea su kamaa mada nalopalia. ");
INSERT INTO kjs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gore nimina kalu iri raayo Gote-me abala diminasa. ");
INSERT INTO kjs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Go-rupa pea-le nimimi paala nakomalepape. Nimimi mo ogege yaana kabape rudu ora ma-oge yateme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesumi agale meda go-rupa lisa: Enaali raayome pa enaalinuna le agaana naa Yesuna enaalinu pima lakelemere neme so yaa-para pia Aapa-para go enaalinuna bi page laketoa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pare enaali raayome pa enaalinuna le agaana ni koau rilalimiri so yaa-para pia Aapana le agaa madaa neme nimu page giyalua. ");
INSERT INTO kjs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nimimi niri go su kamaa epe-rupa pirape kone mea ipisuade kone nasalepape. Dia, pare neme rai kudu nona piale agaa mea ipisua. ");
INSERT INTO kjs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nina ipisuade kogono madaare yada pape kone adaapu go-rupa salimi. Alinu medaloma nimuna aapanu-para yada lore ali aulalimi nogonumi nimuna aginu-para yada lore ali aulalimi werenumi aayaanu-para yada lore ali aulaliminalo ipisuade. ");
INSERT INTO kjs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Go-rupa pumare ali medana koe lore aliri nipuna ada komea-para piri enaalinu re-para aulaoma ronome komalimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Enaali raayome nimuna aapa ama madaa ranaame-rupa ni madaa raana waru nakomalimiri gore go enaalinu ni raapu mada napiralimi. Go page enaali raayome nimuna nogo naakinu ranaame komoma ni madaa raaname waru nakomalimiri go page ni raapu mada napiralimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Enaali raayome nina repena polopeana kedaa naruma nina pora naralemere ora ni raapu mada napiralimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gore enaali raayome nimuna yogale madaa kogono kama pu piralimiri nimuna wasaanu pa alupalimi. Go-rupa pea pare enaali raayome ni madaa kone rulaoma nimuna yogale madaa kone narumalimiri nimuna wasaanu epe-rupa ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Enaali raayome nimi mealimi-daare gore ni page mealimi. Gore enaali raayome ni madaa kone rulaoma epe-rupa mealimi-daare Gote-me ni mea epenalisa-le nimumi nipu madaa page kone rulaoma mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Enaali raayome Gote-na agale lakale ali epe-rupa raba mealimi-daare Gote-me epe yoto gialia rabu waru mealimi. Mo agale lakale ali enaalinu yoto mealimi-rupa go komea-rupa rumaalia. Enaali raayome ora epe ali meda epalia rabu go ali adoma neme go ali raba mealua kone salimi-daare go nimu-para raba meape ali-para komea-rupa epe yoto mealimi. Go agale pagalepa. ");
INSERT INTO kjs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Enaali medalomame nina disaipel enaali meda kogore ipa nape pe meda kateme-daa go epe kone madaa epe yoto mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesumi go agalere nipuna aposel kogono ali 12-pela lakalisa. Go agale laketalo kiratomare nipu go adare giyoma mo-nane adare medaloma-para pumare go enaalinu-para epe agale lakeloma moge riaasa. ");
INSERT INTO kjs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon-me nipu karapo ada piruma Yesu madaa remaa pagisa. Go rabu nipuna disaipel ali medaloma Yesu piri-para mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Go alinu nimumi Yesu agale go-rupa misimi: Nere Jon-me abala epolalo lagisade yapae pa meda werepe epaliade adoba pima pae? ");
INSERT INTO kjs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gore Yesumi nimu go-rupa lakalisa: Nimimi puma kogono adamede raayo ora yade lo Jon puma laketapape. ");
INSERT INTO kjs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abi le rabuli enaalinumi ele waru adaleme. Ali koe enaalinu pora pamualeme. Yakilimi li enaalinuna rere kaapu yaa. Kale poae enaalinumiri abe kale loboma pageme. Abala kome enaalinu page wala rekoma pimi. Go enaali naaralinumi page Gote-na epe agale pageme. Go remaa raayore Jon puma laketapape. ");
INSERT INTO kjs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Enaali raayome ni madaa kone laapo nasu puri paloma kone rulalimi-daare go enaalinu ranaa komo waru piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mo Jon-na disaipel alinu pulaina Yesumi mo Jon-re go piale ali yade pu enaalinu lakalisa: Abalade nimi mo enaali napiri su-para pumare ake adolalo pisimi ya? Gore nimimi po rilipumi kabe ragualae adola pisimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nimi pumare ele adola pisimi ya? Epe mamina maarae alinu adola pisimi ya? Dia-le ali mudu nimuna epe mamina maraoma epe ada-para piru aaeme. ");
INSERT INTO kjs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gore ali adola pisimi ya? Gote-na agale lakale ali meda adola puame ya? E, gore neme nimi lagialo: Go alimiri Gote-na agale lakale ali medalomare nipumi rabuniaaya. ");
INSERT INTO kjs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Go ali madaare Gote-na buk madaa agale go-rupa wia: Gote-me talo: Pagalepa. Neme nina agale lape ali abala epenatoa. Go alimiri nimina lo robaa konena pora ma-redepo yaato tea. ");
INSERT INTO kjs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesumi talo: Pagalepa. Jon Baptais-ri go su kamaa madina enaali raayo rabuaniaaoma nipu ora epelea lisa. Pare Gote-na Surube Yapi-para pulalo nogo naaki-rupa pirimiri Jon page rabuniaame. ");
INSERT INTO kjs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Abalade Jon agale moge ali pirisa rabu page abe enaalinumi Gote-na Surube Yapi-na agale ralu rubulalo pisimi. Go page koe puri pale alinumi nimu ripinaalalo peme. ");
INSERT INTO kjs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gote-na agale lakale ali raayome page Moses-na rekena agaleme agale lakelaama ipumare Jon-me page Gote-na Surube Yapi-na agale lakelea-rupa moge kone rulaeme. ");
INSERT INTO kjs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gore nimimi nimuna agale pagoma kone salimi-daare gore Jon-re Gote-na agale lakale ali Elaija-rupa abala epalia lisimide. ");
INSERT INTO kjs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Enaali raayome go agalena re makuaama piralimiri waru pagalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Go rabu go enaalinuri nimiri ali madaa saa pi agale lagialua ya? Nimumiri kone go-rupa meme. Nogo naakinu-rupa maket su-para pimi. Go-rupa pumare go nogo naaki rado medanu-para go-rupa yaaloaaeme: ");
INSERT INTO kjs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naame nimi-para lemaa pe tyama pare nimimi yasa napabeme. Naame kodome komoma nimi-para rupale lema pare nimimi re-daa nateme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon nipu ipuma ipa wain-para eda medaloma-para nanisa-pulu nimimi nipu makeae ali lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gore enaali Raapu Pirape alina Si ni ipuma go edanu epa no ipa no pe-pulu enaalinumi talo: Adalepa. Go alimiri eda adaapupe noma ipa wain page adaapu nea teme. Go aliri kana takis mi alinu-para naarali enaalinu raapu pia teme. Go-rupa peme pare enaalinumi ora Gote pia kone suma kone rulalimina-le Gote-na makuaae kone mada adalimina. ");
INSERT INTO kjs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Go-rupa pumare su adare adaapu-para Yesu nipumi napi kogono waru pisa pare go pirisimi enaalinumi kone naperekelisimi. Go-rupa pea-le Yesumi nimu-para rono pagoma nimu-para arere enaalinu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gore nipumi talo: Korasin su-para mo Betsaida su lapo-para piri enaalinu madaa neme kodo waru pia. Gore neme Tair Saidon su lapo-para napi kogono go-rupa pula pirisua yalore go Tair Saidon su-para pimi enaalimiri kone pereketa pisimi. Go-rupa pula pisimi yalore nimuna kodo waatalore tagame pepeminuma mamina yamola pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pagalepa. Gore enaalinuna yoto rumaape yapi di raburi Gote-me Tair Saidon su laapo piri enaalinu kedaa katea. Go-rupa palia pare nimimi koe kedaa ora waru ritimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nimi Kaperneam su-para piri enaalinu nimimiri yaa-para pulalo peme pae? Gore nimi koe su-para palimi. Mo napi kogono pawade-rupare Sodom su-para pula peme yalore gore abi go raburi mo Sodom su pa aata paa. ");
INSERT INTO kjs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pagalepa. Gote-me enaalinu yoto rumaape di raburi nimina kedaamere mo Sodom su-para piri enaalinuna kedaa rabuniaa ya-ai mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Go raburi Yesumi Gote-para beten go-rupa lisa: O aapa, nere su yaa laapona Mudu pili. Gore abaladere neme kone makuaae enaalinu-para kone waru wi enaalinu-para nena kone kudiri puma nogo naakinu-rupa mea waaliside. Go madaa ora pili talo. ");
INSERT INTO kjs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gore Aapa nena raana-mere go-rupa pede. ");
INSERT INTO kjs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nina Aapamere ele raayo neme surubenalo gisa. Go-rupa pisa pare pa enaali medame nena Sina ni na-ademe pare ne aapa komea mamere makuaaya. Ali medame aapa na-adea pare Simi komea mere adea. Mo Simi enaalinu-para Aapa adolalo pemere nimumi Aapa ademe. ");
INSERT INTO kjs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nimi enaalinumiri kalai pu kogono puma kedaa ria epemere ni piri ipulupape. Go-rupa epalimiri nimi pomo mu mapiraalua. ");
INSERT INTO kjs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Go-rupa pumare nina pasaa madaa wia repenare gore nimimi muma nimina pasaa madaa mea rialepape. Gore neme epe kone su pawa pi-pulu nimimi nina kone adoma adaapu mogeleme. Go-rupa palimiri nimimi pomo mu piramina. ");
INSERT INTO kjs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gore nina abala riape repenare kedaa napea. Nimina pasaa-para riape ele salua-le yapa pealo marialepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pomo mu Pirape Yapi di medare Yesu nipu wit maapu pamisa. Go-rupa pumare nipuna disaipel alinu nimu reame komisimi-pulu mo wit-na kili ralo sabao maa nisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gore mo Farisi alinumi go adoma Yesu nipu gu-rupa lakalisimi: Adaina. Pomo mu Pirape Yapi di madaare rekena agaleme kogono dia lea pare nena alinumi agale yokoma pa peme. ");
INSERT INTO kjs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesumi nimu go-rupa lakalisa: Gore nimimi Devit-para nipuna alinu page reame komoma pisa yade remaare nadipialimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gore nipu Gote-na ada ru-nane puma kodobaoma mo Gote-na sape bret mea nisimi. Go bret-re Gote-na lodo kira-ae alinumi kama nisimi pare mo alinumi rekena agale yokesimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pare nimimi abalade Moses-na rekena agale-para go remaa nadipilisimi ya? Gore lotu ada-parare Gote-na lodo kira-ae alinumi kogono puma Pomo mu Pirape yapi-daa korona rekena agale yokesimi. Go-rupa pisimi pare nimumi pa koe ele meda napisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gore neme nimi lagialo. Ele go-para wia elemere lotu ada rabuaanaaya. ");
INSERT INTO kjs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pare nimimi Gote-na agale meda pagola peme yalore koeyae napeme enaalinu-para agale mada nalakela peme. Nipuna agale go wia-daa: Ofa sape kone madaare neme raaname nakome pare epe raba meape kone madaa pedo pe. ");
INSERT INTO kjs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Enaali Raapu Pirape alina Siri Pomo mu Pirape Yapi Di-na Ali Mudu yade. ");
INSERT INTO kjs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesumi go su-nane giyoma nimuna lotu ada meda-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Go-rupa pisa rabu ali meda nipuna ki meda-nane kome ali meda pirisa. Gore ali medalomame Yesu-para kose lape agale loma nipu-para agale go-rupa lisimi: Gore naana rekena agale madaare yaina kome enaaliri Sabat li yapi di rabu maperekeaamina yapae dia yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gore Yesumi nimu-para talo: Nimina rikirana ali komeamere mena sipsip punalia rabu medare Pomo mu Pirape Yapi di rabu kubu-para lopalia. Gore nimimi sipsip menare mogo yapina kamaa-nane nayola salimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gore enaaliri sipsip mena-rupadaa dia. Pomo mu Pirape Yapi Di-na page naame enaali raba mealimare rekena agale nayokalima. ");
INSERT INTO kjs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gore nipumi mo ki meda-nane kome ali-para talo: Nena ki ridula. Go-rupa pisa rabu go alina ki epe lisa-pulu wala epe ki meda nona pisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Go raburi Farisi alinu nimu rekoma pumare Yesu nipu lu makomaatalo yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gore Yesu nipumi go agale pagoma lisana go su giyoma pisa pare enaali adaapu nipu raita maa pisimi. Go-rupa pumare nipumi yaina kome enaali raayo ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Go-rupa pumare Yesumi nimu-para agale puri paloma talo: Nina kogonore enaali rado medanu-para agale napuma laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Go-rupa lakalisa agale madaare Gote-na agale lakale ali Aisaia-me agale go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gote-me talo: Go aliri nina raba meape ali yaa-pulu neme nipu raaname waru komoma nipu madaa pedo pe. Neme nina Holi Spirit kalaayo raburi nipumi su rado-para piri enaali nina yoto rumaape yapi di lakelena. ");
INSERT INTO kjs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gore nipumi agale puri palo naloma rono napagaalia. Go page nipu pora pagina pamuma yalaari ali pamualia. ");
INSERT INTO kjs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gore nipumi kogono pa kama puma nipumi enaali raayo ora epe kone winalo raba mealia. Go-rupa puma nipumi kabe meda rodopetabalalo po rilipumi rialaayare mada narodopetabalia. Go-rupa page lam meda repara kudinolalo paliare nipumi mada nakudinalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Go-rupa palia rabu ruru rado enaali raayome nipu madaa kone rulaoma nipu adoba piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Go raburi le rubupi ali medare nipu madaa remo pirisa-pulu nipuna agale maaresa. Go aliri nimumi Yesu nipu piri-para mea ipisimi. Go rabu Yesumi go ali ma-epeaasa-pulu mo alimi agale loma leme ele waru adisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gore enaali raayo nimu pogolasaoma talo: Go aliri nipu Devit-na si yapae dia yapae lisimi? ");
INSERT INTO kjs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gore mo Farisi alinumi enaalinuna agale pagoma go-rupa lisimi: Koe remona ali mudu Belsebul-mi go ali puri katea rabu nipumi go remo raapu piruma pia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gore Yesumi nimuna kone adoba karu muma nimu go-rupa lakalisa: Adare meda-para piri enaalinumi nimu rumaaoma yada palimi-daare gore reke pu lapoma piralimi lisa. Go adare-para aaraalu nimumi rugutalalo palimiri go ruru laapore mada nakibu mapiraalimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Go-rupa pea-le Satan-na su-parare ruru komeame wala yada puma meda ralu rubaliare wala mada nakiri talipi pare nipuna ruru rugutalalo pa pipi. Go raburi nimuna su ora ko yaalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gore nimimi go-rupa lamede: Belsebul-mi ne raba mea rabu neme koe remo mea rubaaede. Go-rupa pea-le nimina disaipel alinuri aapimi raba minalo nimumi koe remo mea rubaeme ya? Nimumi go-rupa peme-pulu nimina kose lape agale rabuaniaaeme. ");
INSERT INTO kjs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pare Gote-na Holi Spirit-mi ni raba mu puri gea-pulu neme go koe remonu mea rubaayo. Go-rupa pea-le Gote-na Surube Yapi Di nimi piri-para abala epaade. ");
INSERT INTO kjs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Gore ali medame puri pale ali medana ada-para puma kodobaoma nipuna elenu paake nolalo palia-daare gore nipu kopeme abala adialimi. Nipumi go-rupa pumare nipuna ada-para wi elenu raayo mada mealia. ");
INSERT INTO kjs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ali medame ni raapu napiraliare gore nina yada lore ali pia. Ali medame ni raapu sipsip mena namuma kirata mapiraaliare gore nipumi mo sipsip-nu pane mea ralu rubalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Go-rupa pea-le neme nimi lagialo: Gote-me enaalinuna koe elenu-para koe ero agalenu raayo mea rubalia pare enaali raayome Holi Spirit-para ero agale leme-daare go koe elere Gote-me mada namuma rubalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Enaali raayome enaali Raapu Pirape alina Si-para koe agale lemere Gote-me go koe elenu mea rubalia. Pare enaali raayome Holi Spirit-para koe agale lemere Gote-me go koe ele mada namuma rubalia. Gore abe page werepe page ora mada nama rubalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gore repena kili epe poasadere epe repena mada abala elalia. Koe repena opalia-daare koe kilinu madea. Go-rupa pea-le le abala madea rabu go repenare epelea palo kolea palo mada adema. ");
INSERT INTO kjs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nimiri koe kerome madi enaalinu-le nimimi epe agalere akepu leme ya? Nimiri koae-aunu pimi-pulu nimina lo robaa-para rubitaboma agalere pename waatea. ");
INSERT INTO kjs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ali epe medare nipuna lo robaa-para epe kone palea-pulu nipumi epe kone suma epe agale lea. Ali koe-mere nipumi koeyae kone lo robaa-para rubitabea-pulu nipumi koe agale lea. ");
INSERT INTO kjs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Go agale lagialo: Gote-me werepe enaalina yoto mea rumaaliade rabu nimuna piai-nu pa rado rado adoba kiraloma Gote-me yoto rumaaoma katea. ");
INSERT INTO kjs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nina le agaa madaare Gote-me nimi kose lape agale tea. Go leme agale madaare Gote-me nimi epe enaali pu koe enaali pu pagoma mea rumaalia. ");
INSERT INTO kjs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Go raburi rekena agale tisaa ali medaloma-para Farisi ali medaloma-para go-rupa lisimi: Tisaa-ya, naame nena napi kogono meda paina adamono lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Go raburi nipumi nimu go-rupa lakalisa: Go abe piri enaalinumi koeyae puma Gote giyeme-le ake paa-daa napi kogono adolalo pimi. Pare nimumi nipuna kogono meda na-adalimi. Pare neme ali Jona-na pisade kogono komeare palua rabu adalimina. ");
INSERT INTO kjs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Abalade Jona nipu adaa wenana lo-parare yapi repome pirisa. Go-rupa pisana-rupare enaali Raapu Pirape alina Siri tapa yapi repome piruma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pare Gote-me enaalina yoto maa rumaape yapi di epalia rabu Ninive pirisimide enaalinumi rekoma nimu kose-na le-agaana palimi lisa. Gore Jona-na agale lakalisa rabu nimumi pagoma koe elenu giyoma nimuna kone lo-pu perekelisimi. Go-rupa pisimi pare abe go pima yapi dimi Jona-na kogono ma-oge eleme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gore Gote-me enaalinuna yoto mea rumaape yapi di rabu no re-nane piri ena Mudu meda rekoma nimina koe ele raayo madaa kose tea. Go enana bi Mudu Shiba leme. Gore go ena nipu Solomon-na epe agale pagola pisa-pulu nipu su raayo kale-nane pamisa. Go-rupa pea pare ali go nimina rikirana pialimere Solomon-na kogono page rabuaaya. ");
INSERT INTO kjs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Gore koe remome ali meda abala giyoma paliare gore nipu su kaapule-para asa pulalo pea. Go remo nipu pamea pare epe su ora wasu na-adalia-daare nipumi wala go-rupa tea: Nina abala piruma epawade ada-para wala palua tea. Wala puma puaa adea pare adede ada-parare brum-mi ki maadu auloma wimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Go-rupa pisa raburi nipumi ora koe remo ki medane luma medane laapo wala puma lamu muma lisana nipu raapu ipumare mo ada ru-nane kodobaoma pirisimi. Apo ki medane luma medane laapo nimumi abala remona koe kone ma-oge eleme-pulu abala ririnare go ali koe-rupa pirisa pare abere ora koe-rupa pia. ");
INSERT INTO kjs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu nipu mo enaalinu raapu agale pa lala pirina agi amenu kamaa-nane epa aasimi. Nimumi nipu raapu agale talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gore ali medame nipu go-rupa lakalisa: Pagape. Nena agi-para nena amenu so kamaa epa aeme. Gore ne raapu agale talo pimi. ");
INSERT INTO kjs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pare nipumi mo enaali-para talo: Nina ama amenuri aapi ya? ");
INSERT INTO kjs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Go-rupa lomare nipuna ki maalame luma nipuna disaipel enaalinu-para wakima talo: Adalepa. Nina ama-para amenuri nimi yade. ");
INSERT INTO kjs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Enaali raayome nina so yaa-para piri Aapana agale waru pago raleme-daare gore go enaali nina ame-para bali-para ama-rupa piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Go raburi Yesumi mo ada giyoma puma ipa le pagi-nane puma pirisa. Go rabu nipumi enaalinu agale mogeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Go raburi ora enaali adaapu nipu piri-para ipuma pisimi-pulu nipu ipinu meda madaa pirisa. Go-rupa pisa raburi enaali raayo ipa le pagi-nane pa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Go rabu nipumi ele adaapu mogeama saa pi agaleme agale go-rupa lakalisa: Ali medame nipuna maapu-para kibita wai radala pisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gore mo maapu-para radala pisa raburi kibita kili medaloma mo pora pagina pa lopesa rabu yaanumi mea nisimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gore pulalo maa pisa rabu medaloma kana rote madaa lopesa. Gore go-para pobere su ogepusi madaa wisa-pulu go ora wagepu opisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pare naare epa roma radaa pea raburi su kaapu loma pitaa na-awoma kaapu lea. ");
INSERT INTO kjs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mo wit-na kili medaloma keto ketoae-para lopesa-pulu go repena opoma adaa yo puma maregepeasa. ");
INSERT INTO kjs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pare kili medaloma epe ipa piri su-para lopoma waru epe-rupa elesa. Go-rupa puma opesa rabu medalomame kili 100-pela maitala medaloma 60-pela maitala. Go-rupa pea pare medaloma pa komea komea laata pu 30-pela maitala pisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Enaali raayome go agalena re makuaaba piruma waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Go rabu nipuna disaipel alinu Yesu nipu piri-para ipuma go-rupa epa agale lorapisimi: Ake paa-daa ade abuna neme nimu-para saa pi agaleme lagele? ");
INSERT INTO kjs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesumi talo: Gote-na Surube Yapi Di madaa kudiri pu wi agale wia pare nimimi abala pageme. Go-rupa pea pare nimimi wala napageme. ");
INSERT INTO kjs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gore enaaali medame kone ele adaapu abala saapitimi-daare Gote-me wala adaapu medaloma page saba katea. Go-rupa puma nipumi paala pina pa salia. Pare enaali raayome kone ogepusi saapirumare gore mada nasaapiralimi pare go ogepusi mada maa palua. ");
INSERT INTO kjs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Neme nimi-para saa pi agale kama le-aina rere go-rupa: Nimuna leme ele pa ademe pare nimumi elena re waru na-ademe. Nimuna kaleme pageme pare nimumi kone-para waru nasalimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Go enaalinu madaare Gote-na agale lakale ali meda Aisaia-me agale ora go-rupa lisaya. Gore nipumi go-rupa lisa: Nimumi agale pago piralimi pare rere waru namakuaalimi. Nimina leme pa adapaba piralimi pare ele waru na-adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Go enaalinuna kone waru nasuma pimi. Nimimi nimuna kale pora poabaaya. Nimuna le pora po wisimi. Go-rupa napula pisimi yalore leme ele mada adola pisimi. Nimuna lo robaa-para paa mada epelea pisa. Agale pago mada makuaamina. Gote-me talo: Go rabu nimuna kone perekelena ni piri-para epenatepape. Go rabu neme nimu ma-epeaalua. ");
INSERT INTO kjs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pare nimimi ora epe-rupa pimi-daare pedo palepape. Nimina leme ele adoba kaleme agale pago pimi-le ora epelea. ");
INSERT INTO kjs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Go agale pagalepa. Abalade Gote-na agale lakale alinu-para Gote-na enaali medaloma page abe nimimi go adaleme ele adolalo raaname komisimi. Pare nimumi abalade na-adisimi. Abi nimi lagialo agale pagola pisimi-pulu raaname komala pirisimi pare go agale napagesimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gore ali medame nipuna maapu-para wit-na kili poasa remaana rere go-rupa pagalepa. ");
INSERT INTO kjs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Enaali medalomame Gote-na Surube Yapi Di madaa agale pagoma yapare namakuaaeme. Go enaalinuri apo pora pagina lope wit kili-rupa pimi pare lo robaa-para wi agalere Satan ipuma epa mabebola lia. ");
INSERT INTO kjs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Gore mo kibita kili kana madaa lopesanare enaali medalomame Gote-na agale wagepu pagoma raaname komoma raita maa peme-rupa yapare go agalere nimuna lo-pu ru-nane pitaa waru napea. Go-rupa pa-pulu nimuna pitaa ogepusi pea. Go-rupa pea-le epe agale madaa kedaa mariaalimi-daare nimumi Gote-na agale wagepu giyoma lopalimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mogo repena kili keto-para lopesana-rupare nimumi agale pageme pare kana kogono-para koe kone adaapu wi su-para pimi-pulu go koe kone raayome Gote-na agale marabuniaaya. Go-rupa pa-pulu kili waru namadea. ");
INSERT INTO kjs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mogo kili epe su-para lopesare gore enaali medalomame Gote-na agale pagoma lo robaa-para maa suma kone rulaeme. Go-rupa puma nimuna kili page waru adaapu 100-pela wakia kili-rupa madea. Gore medalomana kili 60-pela maitaa. Gore medaloma komea komea laata pina 30-pela maitaa. ");
INSERT INTO kjs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesumi nimu-para saa pi agale meda wala go-rupa lisa: Gote-na Surube Yapi Di nona pi-airi ali medame epe repena kili nipuna maapu-para poaaya. ");
INSERT INTO kjs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ribaa enaali u paitala peme raburi yada lore ali meda ipuma koe rilipu mo maapu-para epe kili radalea. ");
INSERT INTO kjs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Werepe go kili maetealo pea rabu mo koe rilipu raapu aaya. ");
INSERT INTO kjs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Go-rupa pumare kogono naakimi mo maapuna aaraa piri-para ipuma talo: Mudu Ali, naame abalade nena maapu-para epe kili poasima kone saoma pare ake pea-daa koe rilipu opea ya? ");
INSERT INTO kjs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gore Mudu Alimi nimu lakalisa: Yada lore ali medame pea. Gore mo kogono naakinumi talo: Mudu Ali, nena konemere naame koe rilipu mea ralu rubola pomona kone sale? ");
INSERT INTO kjs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Gore nipumi talo: Dia, nimimi mo koe rilipu yoko rubala aoma mo epe kibita kili yokalimi-le pa aainawa. ");
INSERT INTO kjs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gore pa aainaloma mo epe kili ralemade rabu go kogono naakinu-para go-rupa laketoa: Go rilipu koenuri abala raloma rogaaoma kiramina toa rilipu epenuri komea ada-para rogaa kirita salepape laketoa. ");
INSERT INTO kjs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesumi nimu saa pi agale meda go-rupa lakalisa: Gote-na Surube Yapi Di-ri gupiale: Repena yamo kili muma ali meda nipuna maapu-para poaaya. Gore opea raburi wala adaa yoma pa repena medaloma rabuaaya. Gore nipu repena aaliade raburi yaa medaloma ipuma go repena palaa madaa ada wari pitimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gore Yesumi saa pi agale meda go-rupa lakalisa: Gote-na Surube Yapi Di-ri bret ma-adaa sape yis-rupa yade lisa. Ena medame go bret ma-adaa sape yis-para plaua ipa repo raapu suma perekelisa. Wariaaoma pumare werepere go ele raayo ora adaa yaalia. Gote-na Surube Yapi Di-ri go-rupa adaa yaalia. ");
INSERT INTO kjs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesumi go enaali adaapu saa pi agaleme lakalisa. Yesumi nimu agale medana pagaa wi waru lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gore abalade Gote-na agale lakale alina agalena re adaliminalo go-rupa lakalisade: Gote-na agale lakale alimi go-rupa lisa: Neme agale puri paloma saa pi agale mada kama toa. Abalade su yaa warisade rabu paa-aenu raayo loma ipuma abe pia page toa. ");
INSERT INTO kjs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gore Yesu nipu mo enaalinu nimuna pirina nipuna ada-para pisa. Go raburi mo nipuna disaipel alinu ipuma go koe rilipu maapu-para opeana saa pi agale ake-para leme pu agale lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesumi talo: Ali medame maapu-para epe kili radateare gore enaali Raapu Pirape alina Simi radala. ");
INSERT INTO kjs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maapuri su ada raayo-para lawade. Epe lere gore Gote-na enaalinu-para lawade. Go rilipu koenuri gore Satan-na enaalinu-para lawade. ");
INSERT INTO kjs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mo lore alimi koe rilipu maa poaaya lawadere gore Satan-para lawade. Eda ralape di raburi gore go su kamaa enaali mea lamulalo epaliade yapi Yapi-para lawade. Maapu-para kogono naakinuri ensel-nupara lawade. ");
INSERT INTO kjs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nimumi rilipu koe raayo mea rogaa suma repena sulaa-para kiralimi-rupare werepe go su kamaa enaali mea rumaala epaliade rabu palia-para lawade. ");
INSERT INTO kjs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Go rabu enaali Raapu Pirape alina Simi nipuna ensel-nu mea rapaalia. Go-rupa puma go ensel-numi pupitagi manape enaali page koe enaalinu page kirita salimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Go-rupa pumare go enaalinuri repena sulaa-para mea rubalimi. Go adaa repena sulaa-parare re ora adaalepe loma radaa waru noma agaa kabulu regepe no piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Go-rupa pumare Gote-na enaalinuri Aapana Surube Yapi-para naare rea-rupa ranaa komo piralimi. Ali medame go agalena re makuaaba piralimiri waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Gote-na Surube Yapi Di-ri go-rupa: Abalade ali medame epe elenu su-para pa paga wisa. Go-rupa pea pare ali medame go ele adisa. Go rabu nipumi su-para wala maa pagaa wisa. Go-rupa adisa-pulu nipumi raaname waru komoma lisana nipu puma enaali medalomame nipuna ele kabeme. Go-rupa puma nipu go mone-me go su kabola pea. ");
INSERT INTO kjs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Gote-na Surube Yapi Di go-rupa: Ali medame sekere maitalo asa puma rome pea. ");
INSERT INTO kjs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nipumi ora sekere yaba adea-pulu nipuna ele raayo kabenaloma nipumi mode mone-me mo sekere ropo pea. ");
INSERT INTO kjs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Gote-na Surube Yapi Di page medare go-rupa pea lisa: Wena agona no ipa-para puma sumare wena nimumi rado rado piae meme. ");
INSERT INTO kjs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mo agona-parare wena epa piru kiritinalomare wena meape alinumi agona mea yola peme. Go-rupa puma nimumi epe wena yarepema maa suma koe yarepemare ipa-para wala mea rubea. ");
INSERT INTO kjs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Go konere werepe yapi di epaliade-rupa: Go rabu ensel-nu su kamaa ipuma enaali mea rumaalimi-le enaalina rikirana koe enaali piralimi-daare go enaali epa mea kiritalimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Go raburi nimi epa mumare mo koe repena sulaa-para epa mea rubalimi. Go repena sulaa-parare re ora adaalepe loma radaa waru noma agaa kabulu regepe no piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Gore Yesumi nimu agale lorapisa: Go agalena rere nimi raayo pago kiritame ya? Gore nimumi talo: E, raayo pago kiritema lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gore nipumi nimu lakalisa: Rekena agalena tisaa ali raayome Gote-na Surube Yapi-na agalere abala makuaasimi pare ada ru-para nipuna wi abalana koe elenu-para epe kagaa elenu puma muma kamaa-nane mea epalia-rupa mada lisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu nipumi go saa pi agale abala pu kiralomare nipumi go su giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gore nipuna adare-para ipumare nipuna ruru enaali lotu ada-para Gote-na agale moge riaasa. Mo enaalinumi nipuna agale pagoma pogolasaasimi. Go-rupa puma nimumi talo: Go epe makuaae kone raayo page go epe napi page gonuri ane-para mea ya? ");
INSERT INTO kjs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Go alina aaraare kamda kogono pi ali kone wima. Go page nipuna agiri Maria kone wima. Jems-para Josep-para Saimon-para Judas-para go-aenu nipuna amenu kone wima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gore nipuna kadipinu page raayo naa raapu komea-para go pima. Go-rupa pea-le go kone raayore ali-para mea ya? ");
INSERT INTO kjs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Go-rupa loma nipu-para rono pagesimi-ai adoma Yesumi nimu-para talo: Gote-na agale lakale alinuri su raayona epe bi minasaaeme pare ora nipuna adare komea-para epe bi naminasaaeme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nimumi kone narulasimi-pulu nipumi adenalo napi adaapu meda napisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Go raburi gavman-na ali mudu Herot Antipas-me Yesu madaa remaa pagisa. Go rabu nipumi Galili su robo surubisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gore nipuna kogono alinu lakalisa: Go Jon Baptais-ri tapa-para wala rekena kone salo lisa. Go-rupa pisa-pulu nipumi go puri muma napi kogono go-rupa mada pea lisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Gore go-rupa abalade Herot-me Jon nipu kose agale laaoma lama adiala karapo ada-para mapaitaasa. Gore Herot-me nipuna ame Filip-na were Herodias yotalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Go-rupa pisa pare Jon Baptais-mi Herot go-rupa lakalisa: Rekena go-rupa wia lisa. Nena amena were nayolape leade kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot-me Jon lu makomaatalo pisa pare nipumi Juda enaali raayo paalame komisa. Go enaalinuna konemere Jon Gote-na agale lakale ali meda kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gore agimi Herot nipu madina di wala ipisa-pulu enaali adaapu nipu raapu paita pu kirita pirisimi. Go raburi Herodias-na waneme nimuna rikirana aoma yasa pabisa. Go-rupa pisa-pulu Herot-me raaname ora waru komisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Go-rupa pisa-daa nipumi wane-para yaa madaa makuaa loma agale gu-rupa lakalisa: Gore neme ni-para ele medaloma gi te-re mada gialua. ");
INSERT INTO kjs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mo enana agimi kone kalisa rabu nipumi talo: Neme Jon Baptais-na kalu plet madaa suma ni giape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Go-rupa lisa raburi mo ali muduna kone-para kedaa pisa. Go-rupa pisa pare abalade nipumi mo nipu raapu eda no piri enaalinu-para yaa madaa makuaa agale lakalisa. Go kone wisa-pulu nipumi talo: Go ele mea katoa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nipumi koda alinu meda mo karapo ada-para penaaloma Jon-na kalu ruguta penaalisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Go-rupa pumare mo Jon nipuna kaluri plet madaa madaa suma mo ena maapua epa kalisimi. Gore nipuna agi piri-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Go-rupa pumare mo Jon nipuna disaipel alinu ipuma nipuna ro ria puma kana apedaa-para puma rogaasimi. Nimumi abala rogaabaoma lisiminare Yesu pua lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu nipu go agale pagomare ipinu meda madaa piruma enaali napiri su-para pira pale pisa. Nipu komea kama raapu pisa pare enaali raayome go remaa pagisimi. Go-rupa puma adare giyoma pisa rabu enaalinumi nipu raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Werepe Yesu nipuna ipinu mo ipa pagi-nane puma sumare enaali adaapupe adomare kodome komoma nimuna yainanu page ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gore ribaa lisa raburi nipuna disaipel alinu ipuma talo: Go su-para enaali napiri su-para epamade-le neme enaali raayo mea rapaaoma eda mo adarenu-para kabola penaala lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesumi talo: Ake paa-daa nimu penaalamono ya? Nimina eda katapa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gore nimumi talo: Naare eda adaapu nasaema. Pa bret supu-para wena ipa laapo sabaema lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesumi gore mea ipulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mo enaaliri rilipu madaa piralepa lomare mo wena lapo-para mo bret supu-para misa. Go-rupa puma nipumi yaa-para adasaaoma talo Gote-para ora pili loma bret maa piribima nipuna alinu kalisa. Go-rupa puma go alinumiri mo enaali raayo rumaaoma kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gore nimu raayome eda mada no kiralomare eda purupina basket 12-pela madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mo eda nisimi enaaliri ora adaapupe pirisimi. Ali 5000-pela pirisimi pare nimumi ena nogo naakinuri nadipi lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesumi nipuna disaipel alinu lakalisa-daa nimu ipa le mone pane abala pisimi. Go rabu nipu mo enaali mea rapaatalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nipumi mo enaali raayo abala penaaloma nipu komea beten talo so rudu madaa pisa. Ribaa nipu komea so rudu madaa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gore mo ipinu abala mo ipa rikirana penaaloma po rilipumi nimu pulalo pisimi-nane ipisa-pulu nimu ipa koauna pa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yapi pode lapaasa pare ribaa ogesi-daa pa yabaina Yesu nipu ipa koau madaa ipuma nipuna alinu piri-para epa opapasa. ");
INSERT INTO kjs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gore disaipel alinumi nipu mo ipa koauna ipisa adoma pogolasaoma talo: Gore masalai meda epa-aaya kone suma pogolasaoma paalame komoma puri palo yalaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Go raburi wagepu Yesumi nimu lakalisa: Puri mealepape. Ni epawade-le nimimi paalame nakomalepape. ");
INSERT INTO kjs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Go rabu Pita-me talo: Ali Mudu, ora ne yaalia-daare ni page apo ipa madaa, nipu epono lagi. ");
INSERT INTO kjs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesumi talo: Ne ipu lisa. Pita mo ipinu giyomare ipa koau-nane puma Yesu nipu aasa-para adolalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pare nipumi po rilipu adoma paalame komoma ipa le ru-nane kodobalalo pisa. Go-rupa pulalo pia-pulu nipumi talo: Ali Mudu, neme ni raba meape. ");
INSERT INTO kjs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Go raburi wagepu Yesu nipu kimi ripinaasa. Go-rupa puma nipu lakalisa: Ake paa-daa neme ni kone ogepusi rulaaripi ya? Neme kone laapore ake paa-daa sae ya? ");
INSERT INTO kjs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Go-rupa pumare nipu laapo so ipinu madaa opasaoma pirisipi raburi po rilipu dia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gore ipinu madaa pirisimide alinumi Yesu-para beten loma nimumi talo: Nere ora Gote-na si yana lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu-para nipuna moge riae alinu-para nimu ipa Genesaret ruguloma puma mone pane puma opopasimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Go su-para piri enaalimiri Yesuna le agaa adisimi rabu go su raayo-para pirisimi enaali lakeloma yaina kome enaali raayo Yesu piri-para lamua ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesu nipu agale ogelalo lisimi: Nena mamina pagi-nane yaina kome enaalinumi waraainalo ogesimi. Enaali raayome nipuna mamina madaa kimi waraaoma lisimina nimuna yaina raayo ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Go raburi Farisi alinu-para rekena agalena tisaanu-para Jerusalem su giyoma Yesu nipu piri-para ipuma lisimina nimumi talo: ");
INSERT INTO kjs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ake paa-daa nena disaipel alinumi naana kasuanuna abalana rekena agale naraleme? Nimu eda nolalore rekena agale yokoma nimuna ki naradepeateme lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Gore Yesumi nimu-para talo: Nimimi ake paa-daa abalana kone pa saapiruaeme? Go-rupa puma nimimi Gote-na rekena agale yokemena. ");
INSERT INTO kjs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gore Gote-me gu-rupa lea: Neme nena ama aapa laapona agale yokape lea. Ali medame nipuna ama apa-para koe agale leme enaaliri lu komalia lea. ");
INSERT INTO kjs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Go-rupa lea pare nimimi go-rupa leme: Ali meda nipuna aapa ama raba meape ele medaloma suma yapare wala Gote katoa tea. ");
INSERT INTO kjs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Go-rupa puma go rabu nipuna ama aapa raba meapere palaina tea. Go kone suma nimimi Gote-na agale yokoma nimina abalana kone waru su aaeme. ");
INSERT INTO kjs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nimiri ora makirae agale le enaalinu pimi. Gote-na agale lakale ali Aisaia-me nimi madaa agale waru lisade. Nipumi talo: ");
INSERT INTO kjs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gote-me talo: Go enaalinuri nimuna agaleme nina bi minasaaeme. Pare nimuna pu robaa-para wi koneme ni giyoma re-para napimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Go enaalinumi pa nimuna rekena agale mogeleme rabu ora Gote-na agale giyali. Go-rupa peme-pulu nimumi nina bi pa kama minasaaeme lea. ");
INSERT INTO kjs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Go rabu Yesumi enaali nipu piri-para ipulupa loma nimu gu-rupa lakalisa: Nimimi pagoma kone waru salepape. ");
INSERT INTO kjs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ali medame eda agaa-para mea neme rabu go eleme nimu koto namapaaya. Dia, pare enaalina lo robaa-para wi kone kamaa-nane popalia-daare go-rupa enaalinu makoyaalia. ");
INSERT INTO kjs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Go raburi nipuna disaipel alinumi nipu-para talo: Farisi alinumi nena remaa pagoma nimuna lo robaa ko-lea lamede? ");
INSERT INTO kjs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Gore Yesumi talo: Nina Aapa pia yaa-para nipuna maapu-para napoaaripa pare go opalia rabu pita apale yokalia. ");
INSERT INTO kjs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mo Farisi alinu madaa nimimi kone narulalepape. Gore nimu le rubu pi ali-rupa pimi pare le rubu pi yago pora mada nawatea. Dia-le nipu laapo raita naaku-para lopalipi. ");
INSERT INTO kjs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita-me Yesu nipu go-rupa lakalisa: Neme go agalena re waru lapa lisa. Naame waru makuaamona. ");
INSERT INTO kjs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Gore Yesumi talo: Nimi page kone nasalimi-le apo alinuna yago pimi pae? ");
INSERT INTO kjs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ora pagalepape. Gore ele raayo agale-para neme elenuri robaa ru-nane pea raburi oge ada-para rubemede. ");
INSERT INTO kjs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pare ele meda robaa ru-nane piruma agaa-para epe-rupa elere gore kone raapu epea-pulu enaalinu koto mapaalia. ");
INSERT INTO kjs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gore enaalina lo-parare koe kone go-rupa wimi. Enaali lu makomaape kone-para ena raluli meape kone-para ena paake yolape kone-para paake nape kone-para makirae agale lape-para enaali medalomana bi rabuaniaape kone-para go kone raayo lo robaa-para suma peme. ");
INSERT INTO kjs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Go ele raayomere enaali koto mapaaya. Go-rupa pea pare nimuna kone raluma ki radepea eda nalimiri go konemere enaalinu koto namapaalia. Ora dia. ");
INSERT INTO kjs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nipu go su giyoma nipu mo Tair Saidon su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Go-rupa pisa rabu Kenan su-para piri ena medare go su-para pirisa-pulu nipu ipuma go-rupa lisa: Mudu Ali, nere Devit-na si yade. Neme ni kodome komape. Koe remome nina wane ora koe-rupa lia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gore Yesu nipumi agale meda nalakalisa raburi nipuna kogono alinumi go-rupa lisimi: Go enamere e lama lama puaoma na raita maa ipula-le neme wala penaala lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gore Yesumi nimu agale go-rupa lakalisa: Gote-me ni mea rapaasadere neme go Israel su-para alupae sipsip menanu raba meanalo maa rapaasa-daa ipisuade. ");
INSERT INTO kjs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Go rabu mo ena nipu ipuma Yesuna kibu re-para lopoma lisana nipumi talo: Mudu Ali, neme ni raba meape. ");
INSERT INTO kjs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Gore Yesumi nipu agale go-rupa lakalisa: Naame nogo naakinuna eda muma pa yananuna agaa-para mea lopalimare epetea. ");
INSERT INTO kjs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Gore mo ename talo: Mudu Ali, neme ora lale pare mo yananumiri nimuna aapanuna eda purupi na nemede. ");
INSERT INTO kjs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nipumi go-rupa lisa rabu Yesumi nipu-para agale go-rupa lakalisa: Go ena nena kone rulae ora adaalepe saenale ne madaa pina kone sali-ae pina lisa. Go agale lakalisa rabu mo nogo wagepu rekisa. ");
INSERT INTO kjs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nipu go su giyoma ipa le Galili pagi-para pisa. Go-rupa puma nipu so rudu madaa-nane puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Enaali adaapupe nipu piri-para epa kiritaoma le koe kale poae agale maare yaina rado rado kome raayo lamua ipuma kiritasimi. Go-rupa pisimi-pulu nimuna yaina raayo ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Go raburi enaalinumi mo agale maare enaalinumi agale lisimi le koe enaalimi pora pamuma to kuli koyae pi igipili enaali epe-rupa pirina adisimi. Go-rupa pisa-pulu go Israel su-para piri enaalimi Gote-na bi minasaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesumi nipuna disaipel alinu-para ipulupa loma go-rupa lakalisa: Neme go enaalinu kodome komalo. Yapi repo ni raapu pirama-pulu nimu reaeme komoma pimi. Gore neme nimuna ada penaatoa. Nimu puma pora pagina pa lopalimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gore nipuna alinumi nipu lakalisimi: Go su-parare enaali adaapupe pimide-le bret ake puma muma go enaali adaapu mada rumaalima yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gore Yesumi nimu agale go-rupa lorapisa: Nimina bret-re akepu raapu saapimi? Gore nimumi talo: Ki medane luma medane laapo saapima. Wenare komea komea oge wenasi saapima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gore Yesumi mo enaali raayo-para su kamaa piralepa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Go-rupa puma nipumi mo ki medane luma medane laapo bret-para mo wena oge oge-para muma lisana Gote-para ora pili loma piribisa. Go-rupa puma nipuna disaipel alinu kalenaloma mo alinumi enaali raayo rumaaoma kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Go-rupa puma mogo ali raayome mo eda no mada nisimi disaipel alinumi eda purupi basket ki medane luma medane laapo madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gore alinuri ora adaapupe 4000 pirisimi pare enaali nogo naakinuri nadipiasimi. ");
INSERT INTO kjs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesumi mo enaali raayo nimuna ada penaaloma nipuri ipinu madaa piruma Magadan su robo-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi alinu-para Sadyusi alinu-para go alinumi Yesu epa ko lisimi. Gore nimumi talo: Puri pale napi kogono meda paina naame adamina lisimi. Go-rupa pali rabu Gote-na puri muma nipuna kogono pina lamona lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gore nipumi talo: Nare pabalaina nimimi so yaa madaa mole kale-ai ademe raburi nimimi abere pane palia leme. ");
INSERT INTO kjs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gore ribaa reka rabu page yaa-para koborea raburi po rilipu ipuma yai nipu epalia lemede. Gore nimimi so yaa-para adomare go-rupa lemede-le abe go di raburi nimimi ele adoma yapare mada na-adalimi? ");
INSERT INTO kjs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abi go yapi di madaa piri enaalinu nimiri koe pupitagi nape enaali piruma Gote madaa kone narulaeme. Neme napi kogono panolo leme pare neme mada namuma waatoa. Nimiri Jona-na pisade kogono komeare adalimina. Go-rupa loma nimu giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gore Yesuna disaipel alinu nimu ipa kenaoma mone pane pisimi pare bret medaloma namuma ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gore Yesumi nimu-para talo: Nimimi waru adalepape. Mo Farisi alinu-para Satyusi alinuna bret ma-adaape yis madaare waru adalepape. ");
INSERT INTO kjs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gore nimumi go-rupa lisimi: Naame bret namuma epamade madaa lea pa kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gore Yesumi nimu-para talo: Nimi kone waru narulaeme-le ake paa-daa naare bret nasalima lame? ");
INSERT INTO kjs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gore nimimi abe na-ademe? Gore nimimi go bret enaalimi 5000 nisimi remaa abala kone rugulaarimi? Go-rupa pisua rabu nimimi eda purupi nu akepu raapu madu wisimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Gore neme bret ki medane luma medane laapo mo alinu 4000 maa kalisuadere go madaa namakuaaeme? Go-rupa puma nimimi mo purupi nu akepu raapu madu wisimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Neme nimi-para pa bret madaa nalawade-le ake paa-daa nimimi namakuaarimi? Gore nimimi mo Farisi alinu-para Satyusi alinu-para nimuna bret ma-adaa sape yis-ri waru adalepape lawade. ");
INSERT INTO kjs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Go-rupa wala lisa-pulu go rabu nipuna disaipel alinumi bret ma-adaa sape yis-na agale-daa kone nawisimi. Dia, pare nipumi Farisi alinu-para Satyusi alinuna agale lea kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu nipu mo Sisaria Filipai adare-para pisa raburi nipumi nipuna disaipel alinu go-rupa lakalisa: Enaalinu nimi Raapu Pirape Aliri aapi leme pae? ");
INSERT INTO kjs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nimumi talo: Gore enaali medalomame nere Jon Baptais leme. Medalomamere nere Elaija leme. Medalomamere ne Jeremaia yapalo Gote-na agale lakale ali yapalo go-rupa leme. ");
INSERT INTO kjs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Gore Yesu nipumi talo: Nimimiri ni aapi leme ya? ");
INSERT INTO kjs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gore Saimon Pita-me go-rupa lisa: Nere enaali Raapu Pirape alina Si yaa-pulu ne Gote-na Si yade. ");
INSERT INTO kjs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gore Yesu nipumi talo: Jon-na si Saimon nere raaname waru komape. Go su kamaa piri enaali medame neme go lale agale nagiame pare nina so yaa-para pia Aapame ne go agale lagiana. ");
INSERT INTO kjs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gore neme ne lagialo: Ne Pita-re ne puri pale kana nona piale ne madaa nina ruru pirinalo enaali warialua. Go-rupa palua-pulu Satan-na komape purimi go ruru enaali mada narabuainalia. ");
INSERT INTO kjs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gore so yaa-para wia surube suna pora gaape lobape ki neme ne gialua. Ele meda neme go su kamaa pa saapiraliri gore Gote-me so yaa-para page pa saabalia. Go page neme go su kamaa ele kepealiri so yaa-para page Gote-me ma-kepeaalia. ");
INSERT INTO kjs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu nipumi agale puri paloma disaipel alinu-para talo: Nina bi Keriso yade-le enaali meda nalaketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Go raburi Yesumi nipuna disaipel alinu-para werepe epaliade yapi di madaa ni mada go-rupa palimi lo lapalasa. Nipumi nimu-para go-rupa lisa: Ni Jerusalem su-para palua rabu makuaae alinu-para ali kalunu-para Gote-na lodo kira-ae ali kalunu-para rekena agale tisaanu-para nimumi ni radaa adaa manaaoma lu makomaoma rogaalimi. Go-rupa palimi pare yapi repo tapa-para piruma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Gore Pita-me nipu mo renane lamua puma lisana nipu go-rupa lakalisa: Ali Mudu, nere ora go-rupa napina. Go koe elenu ne madaa na-epena. ");
INSERT INTO kjs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gore Yesumi wala pereke luma adoma talo: Nere Satan yaana. Nere nina koau-nane giyoma pupu. Nemere Gote-na kone na-adoma nina kone maa perekelalo lae? Dia, pare su kamaa piri alina kone meana. ");
INSERT INTO kjs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Go raburi Yesumi nipuna alinu lakalisa: Gore enaali raayome nina kone mu pora raitalimi-daare nimuna kone rabuainaoma nena repena polopea maa ruma ni raita maapulupape. ");
INSERT INTO kjs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gore pa ali meda nipuna yogale pa kiritao saapitia-daare gore nipuna wasa page alu palia. Pare enaali raayome ni madaa kone rulaoma epe-rupa mapiraape kone mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gore pa ali komeame su kamaa ele raayo saapiralia pare nipuna kone wasa alu palea. Go rabu go ele raayome nipu akepu abala mealia ya? Enaalina kone wasa alu pali-daare ora wala na-adasaalia. ");
INSERT INTO kjs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abiri enaali Raapu Pirape alina Siri nipuna Aapana epe paana purimi nipuna ensel-nu raapu epalia. Go raburi enaali raayo nimuna kogono peme-rupa mada yoto katea. ");
INSERT INTO kjs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pagalepape. Enaali medaloma go-pare pimiri abe nakomalimi pare nimumi enaali Raapu Pirape alina Sina puri mea epalia rabu adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yapi ki medane luma ki medanena egali abala penaloma Yesumi Pita-para nipuna ame Jems Jon laapo page nimu muma lisana so rudu medane ora so madaa lamua opapasa. Go-rupa puma nimu agu raapu puma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gore go ali repena kili agalena nipu adobaina Yesuna lakaatalo perekelema rado aoma pirisa. Nipuna le agaa-parare naare ipulae-para ade nona pisa. Nipuna mamina elere yaako pu luma lepo lepo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Go-rupa puma Moses-para Elaija laapo ipuma Yesu raapu agale lalaina adisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita-me go-rupa adoma Yesu go-rupa lakalisa: Ali Mudu, naa go-para pima pare ora epelea. Gore neme pokala ada repo go-para punu. Medare nena medare Moses-na medare Elija-na warialua. ");
INSERT INTO kjs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nipumi go agale pena lala pirina paa pu kepe ae mole medame nimu kepisa. Go molena ru-nanere agale meda go-rupa lisa: Go naakiri ora nina epe Si. Neme nipu madaa pedo waru pe. Go-rupa pe-le nipuna agale pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gore mo alinumi go agale pagoma lisimina pururumi komoma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gore Yesu nipu nimu piri-para ipuma nimu go-rupa epa lakalisa: Nimi paalame nakomalepape. Nimi rekalepa. ");
INSERT INTO kjs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Go-rupa lisa raburi nimumi adasaaoma alinu meda napirina Yesu nipu komea-mare adisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nimu so rudu giyoma ora kilipitaa pulaina Yesumi nimu-para puri paloma go-rupa lakalisa: Nimimi abe go adamede elere enaali meda ora napua laketapape. Ora nalapae pirumare ni enaali Raapu Pirape alina Siri tapa-para wala rekalua. ");
INSERT INTO kjs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gore nipuna alinumi nipu go-rupa agaa misimi: Ake paa-daa mo rekena agale tisaanumi mo Elaija abala epenalo leme pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Gore Yesu nipumi go-rupa lakalisa: Elaija ora abala ipumare nipumi ele raayo yarera palia. ");
INSERT INTO kjs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pare neme nimi lagialo: Elija-re abala ipisa pare enaalinumi nipu na-ademe. Na-ademe pare nimumi koe kone suma Elaija-para pisimi. Apo koae-au pisimide konere enaali raapu Pirape Ali radaa manaalimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesumi go-rupa lisa rabu nipuna disaipel alinumi Jon Baptais-para lakalisa-daa makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nimu adede enaali raayo piri-para puma opapasimi raburi ali meda ipuma Yesu madaa rumu pege puma agale go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Mudu Ali, nemere nina naaki madaa kodome komape. Nipu ade abuna makeyaoma repena sulaa-para page ipa-para pa kama popea. ");
INSERT INTO kjs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neme nena disaipel alinu piri-para lamua pe pare nimumi mada namaepeaeme. ");
INSERT INTO kjs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Gore Yesumi nipu lakalisa: Go enaalinu nimiri kone narulaoma pimi. Nimina lo-parare kolea. Nimi raapuri ni rana akepu raapu pitua ya? Nimina kedaare neme rana akepu raapu ritua ya? Gore mo naaki ni piri mea ipulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gore Yesumi mo koe remo-para puri pale agale loma lisana mo naaki nipuna koe remo mea rubaasa raburi go naaki ora wagepu rekesa. ");
INSERT INTO kjs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go raburi Yesu kama agu raapu pirina nipuna disaipel alinumi ipuma go-rupa epa lakalisimi: Ake puma naame go koe remo mada namuma rubema? ");
INSERT INTO kjs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Gore Yesumi nimu-para talo: Nimimi nina agale lo robaa-para waru namuma wimi. Pagalepa. Nimimi Gote-na agale mo repena kamana oge kili lo robaa-para maa salimiri nimimi go su rudu madaare ne lusuma ruma mogo-nane pu leme raburi mada palia. Go-rupa ogesi-daa kone rulalimiri nimimi kogono rado meda raayo mada pu kiritalimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Go-rupa koe remo mea rubapere pora komea wia-daa nimimi beten pu eda madaa niti puma go remo mada mea rubalimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gore Yesuna disaipel ali raayo Galili su-para epa pirisimi rabu Yesumi nimu-para talo: Enaali Raapu Pirape alina Siri nimumi lore alinu maa kateme. ");
INSERT INTO kjs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Go-rupa pumare nimumi nipu lu makomaoma maa rogaalimi. Go-rupa palimi pare wala yapi repome tapa-para wala rekalua. Go raburi mo enaalinuna kone-parare ora kedaame waru komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wala werepe Yesu-para nipuna disaipel enaalinu-para Kaperneam su-para pisimi. Go raburi no lotu adana kana takis mi alinumi Pita-para go-rupa epa lisimi: Gore nimina tisaa-mere lotu adana takis kana-re lopata ya? ");
INSERT INTO kjs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Gore Pita nipumi e loma lisana no ada ru-nane puma kodobasa rabu Yesumi nipuna agale abala loma Pita agale go-rupa misa: Saimon, nemere ake kone sale ya? Go su kamaa ali mudunu-parare aapimi kana takis ele kabape kana takis lopateme ya? Gore nimuna ruru lopateme pe pa kimisu ali rurumi radonumi lopateme ya? ");
INSERT INTO kjs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Gore Pita-me talo: Pa kimisu ali ruru radonumi lopateme. Gore Yesumi talo: Nimumi go-rupa peme-pulu nimuna rurumi takis nalopamina. ");
INSERT INTO kjs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Go-rupa peme pare neme nimuna kone nama-koeyaalua-pulu ne mo ipa le-para puma wena agona pua lopalisa. Wena ora abala mealiri nipuna agaa lobape. Go-rupa pumare wena goaina agaa-para kana salia rabu muma saa laapo raitana lotu adana kana takis mea kalape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Go raburi disaipel alinumi Yesu piri-para ipuma talo: Gote-na Surube Yapi Di-parare aapi ali mudu pitia ya lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gore Yesumi naaki oge meda nipu lomare nimuna rikirana mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Go rabu nipumi talo: Pagalepa. Nimina kone perekeloma oge nogo naaki-rupa piralimiri Gote-na surube su-para mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Enaali raayome oge nogo naaki-rupa piralia-daare go enaalinumiri Gote-na Surube Su-para ali mudu piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gore enaali raayome nina bi loma oge nogo naakinu-rupa epe kone su raba mealimi-daare gore ni-para page go-rupa palimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Go oge naaki-rupanuri ni madaa kone rulaeme. Go-rupa pea-le enaali medame nimuna kone rulaere makoyaalimiri gore nimu muma adaa kaname maa-para kopeme adibaoma ipa le-para maa rubalimiri ora epelea. ");
INSERT INTO kjs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Go su kamaa enaalinuri ade abuna koe elenumi nimuna kone rulae makoyaata-pulu kodo ora waru pea. Gore ade abuna koe ele epe-rupa pare go koe ele mea epe-rupa enaalinuri kodo ora waru pea. ");
INSERT INTO kjs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Gore nena kimi page age page ne koe ele meda palia-daare gore ki agenu kioma rubalepape. Gore nena ki age komea aaomare ne ade abuna epe-rupa piralimiri ora epelea. Pare nimina ki age laapo raita pa aoma piruma koe ele palimiri nakudili repena sulaa-para mea rubalimi-pulu ora kolea. ");
INSERT INTO kjs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Go page nimina leme koe ele meda adalimiri go nena le yoko rubape. Gore nimina le komea aaomare epe-rupa ora yalo piralimi-pulu ora epelea. Pare nimina le laapo raita pa riaoma pupitagi nalimiri nimi repena sulaa-para mea lopalimi-pulu ora kolea. ");
INSERT INTO kjs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nimimi waru adoma go oge enaalinu narabuainaatepape. Dia, gore neme nimi lagialo: Nina so yaa-para pi Aapana ensel-numi nogo naakinu waru adoaoma surubea. ");
INSERT INTO kjs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gore enaali Raapu Pirape alina Siri su kamaa ipuma koe-rupa alupae enaalinu raba mulalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nimimi ake kone salimi ya? Ali medame sipsip 100-pela punalia pare mena sipsip komea alu palia raburi mada na-alupalia ya? Gore nipumi mo 99-pela mena sipsip medaloma pa aainaloma nipumi go mena sipsip komea asa pula palia. ");
INSERT INTO kjs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Neme ora nimi lagialo: Mo sipsip alu paliade pare asa puma adoma mumare mo ali nipumi raaname komalia. Go-rupa pumare mo mena medaloma pa aaeme-nuri nimu madaa go-rupa raaname nakomalia. ");
INSERT INTO kjs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gore nimina so yaa-para pia Aapamere go oge nogo naakinu-rupa alu palimina kone nawia. ");
INSERT INTO kjs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gore nena ameme ne-para koeyae paliare ne puma nipi laapo meda-para piruma nena amena koe elenu mea waalape. Gore nena agale pagaliare gore nena ame wala epe-rupa piralipi. ");
INSERT INTO kjs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Go page nena agale napagaliare neme agale pagaliade ali medaloma lamua puma tapape. Go-rupa puma nimi repore mo ali laketa pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pare nena agale napagaliare gore neme lotu ada-para piri enaali laketapape. Go lotu ada-para piri enaalina agale page napagalia gore nipuna kama raapu pora pamina giyalepape. Go rabu nipu Gote-na agale napage ali-para takis koe-rupa mi ali-para go-rupa pitia. ");
INSERT INTO kjs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gore neme nimi lagialo: Ele raayo go su kamaa rogaa salimiri Gote-me so yaa-para page rogaalia. Pare go su kamaa kepe salimiri Gote-me so yaa-para page kepesaalia. ");
INSERT INTO kjs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gore neme ora nimi lagialo: Nimina rikirana piri enaali laapome kone komea suma ele meda mulalo beten tepere gore nina so yaa-para pia Aapame nipi mada gialia. ");
INSERT INTO kjs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gore enaali repo laapome nina bi madaa kone rulaoma ada komea-para piralimiri nimu raapu pitua. ");
INSERT INTO kjs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Go raburi Pita nipu Yesu piri-para ipuma agale go-rupa misa: Ali Mudu, nina ameme ni-para koeyae pina neme nipuna koe kone rana akepu raapu mea rubalua ya? Rana ki medane luma medane laapo pina giyalua ya? ");
INSERT INTO kjs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Gore Yesumi nipu lakalisa: Neme rana ki medane luma medane laapo pina giyape pi-daa nalawade. Dia, pare 70-pela taims ki medane luma medane laapo nipuna koeyae mea rubape. ");
INSERT INTO kjs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Go madaare Gote-na Surube Yapi Di-ri go-rupa yade: Ali mudu meda piruma nipumi yago mi kogono naakinu ma-redepo yaatalo pea lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nipumi yago ma-redepo yainaloma ripia pisa rabu kogono ali meda lamua ipisimi. Nipuna yagore ora adaapupe naame mada nadipialima. Ora adaapu 40 milion kina-rupa leme. ");
INSERT INTO kjs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pare mo alimi mogo kana yago mada na-abulisa-pulu nipuna Mudu Alimi go-rupa lakalisa: Go ali nere ora kogonome adili ali-rupa piraina. Go rabu nipuna ena-para nipuna nogo naaki-para ele raayo-para kabalimina. Go-rupa puma go kana-re mo yago medaloma abutea. ");
INSERT INTO kjs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Go-rupa lisa rabu mo kogono naaki nipu mo Mudu Ali-na kibu-para rumu pege puma piruma talo: Neme ni kodome komape. Go yago raayore neme mada abutua. ");
INSERT INTO kjs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Go kogono naakina Mudu Alimi nipu madaa kodome komoma nipu pirina giyesa. Go-rupa puma nipuna yago kana page giyesa. ");
INSERT INTO kjs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Go rabu go kogono naaki nipu kamaa pumare nipuna komea kogono pi naaki puma adisa. Go aliri nipuna yago kana ogeasi 40 kina go ali madaa wisa. Go ali adisa-pulu nipumi mo alina maa regepe minuma talo: Neme nina yago raayo abulape. ");
INSERT INTO kjs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Go-rupa pisa-pulu nipuna kogono komea pi ali nipu rumu pege puma agale go-rupa ogelisa: Neme ni kodome komoma ni adoba pirape. Gore neme yago ne mada abutua. ");
INSERT INTO kjs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pare nipumi giya komoma karapo ada mapaitaasa. Go-rupa puma nipuna yago abulanalo mada epeaalia. ");
INSERT INTO kjs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gore mo kogono komea pisimi alinumi go kone adoma nipuna lo robaa-para kolisa. Go-rupa puma raayo nimuna Mudu Ali piri puma puaa lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Go raburi Mudu Alimi mo kogono naaki nipu loma go-rupa lakalisa: Nere adili kogono naaki koeyana. Abalade neme ni piri ipuma re epa laede aaina nina rudu raayo giyawade. ");
INSERT INTO kjs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neme abalade ne komea kodome komisuade-le ake paa-daa nena kogono komea pi naaki kodome nakomae ya? ");
INSERT INTO kjs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gore nipuna Mudu Alimi nipu-para rono pagoma nipu karapo ada-para maa rapasa. Go-rupa puma nipu radaa manaaoma nipuna yago raayo abulenaloma mada epalimi. ");
INSERT INTO kjs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Go rabu Yesumi talo: Nimi raayona koneme nimina amena koe ele namuma rakepealimiri nina so yaa-para pia Aapame page nimi-para go-rupa palia. ");
INSERT INTO kjs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesumi go agale abala pu kiraloma Galili su giyoma mo ipa Jordan-na mone pane puma Judia su ru-nane pisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Go raburi enaali adaapumi nipu raita mea ipisimi rabu nipumi yaina kome enaali go su-para ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Gore mo Farisi alinumi Yesu kotalalo ipuma talo: Gore naana rekena agale madaare ali medame nipuna were pa kama mada nagiyalia ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesumi talo: Gore nimi abalade go agale buk-para go-rupa nadipiasimi ya? Abala ririnare Gote-me ele raayo wari lisana ena ali laapo abala warisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Go-rupa pisa-le ali medame nipuna aapa ama giyoma nipuna ena raapu komea-para piralipi. Go rabu nipu laapore ora komea piralipi. ");
INSERT INTO kjs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Go-rupa pisa-pulu nipu laapo komea-rupa piralipi. Gore Gote-me abala nipu laapo makibuma lapaasa-pulu wala repaaya mada narugulape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Gore mo Farisi alinumi nipu go-rupa lakalisimi: Go-rupa lae pare Moses-na rekena agalemere ali medame nipuna ena yokolalo pepa luma kaloma nipu penaatea. Ake paa-daa go-rupa pisa ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Gore Yesumi nimu lakalisa: Nimimi agale napagoma koe kone wimi-daa Moses-me nimina ena yokape pora mea waalisa. Pare ora abalade Gote-me ele warisa rabu go pora nawisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neme nimi go-rupa lagialo: Gore ali raayona werenumi ali paake nanalia pare aalimi pa maa raluma ena rado meda mealimi-daare go alinu nimumi ena paake yole ali-rupa piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gore Yesuna disaipel alinumi nipu lakalisimi: Gore ali nipu mo ena raapu go-rupa aawalipiri ena nami ali-rupa ora epelea lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gore nipumi nimu go-rupa lakalisa: Enaali raayome go agale mada napagoma kiritalimi. Gote-me abalade nimu puri pale enaalinu go agale lagisade. ");
INSERT INTO kjs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Paga, ali medalomame kone rado rado salimiri nimumi ena meda namealimi. Medaloma nimuna amanumi madisimi rabu nimuna to kolisa. Ali medalomamere abalade nimuna ru maa pasimi-pulu nimumi ena mada namealimi. Ali medalomamere Gote-na Surube Yapi Di madaa kone suma ena narumaasimi. Ali meda go agale pago kiritaliare nipumi mada palia. ");
INSERT INTO kjs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Go raburi Yesu piri-para oge nogo naaki medaloma mea ipisimi. Gore nipumi nimuna kalu madaa ki suma beten lalalo maa ipisimi. Go-rupa pisimi pare nipuna alinumi mo enaalinu-para rono pagisimi. ");
INSERT INTO kjs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Go rabu Yesu nipumi talo: Go-rupa natapape. Go nogo naakinuri ni piri-para epenatepa. Gote-na Surube Yapi Di-ri nogo naaki go pia mada mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Go-rupa loma lisana nipuna kimi kalu madaa su kodoboma nipu go su-para giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ali meda Yesu piri ipuma go-rupa lisa: Tisaa, neme ake puma ni epe-rupa ade abuna pitua ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Gore Yesumi nipuna agale lorapisa: Ake paa-daa neme ni-para epe ele madaa agale epa lorapeae? Ali komea epelea. Gore ne ora epe-rupa pitua kone saliri neme Gote-na rekena agale raayo waru raitape. ");
INSERT INTO kjs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gore mo alimi nipu agale lorapisa: Go rekena agalere ale ya? Gore Yesumi talo: Neme ali meda nalu makomaape. Neme ena paake nayolape. Neme paake nanape. Enaali meda-para makirae agale nalape. ");
INSERT INTO kjs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nena ama aapanu raapu pawa piruma nimuna bi minasaasape agale pagape. Nena ada lapa piri enaalinu raana kome-rupa nena yago meda raana komape. ");
INSERT INTO kjs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Go rabu Yesu mo ali lakalisa: Mo rekena agale raayore abala page. Go-rupa pawa-le meda abere ake palua ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Gore Yesumi nipu lakalisa: Neme ora epe-rupa pitua kone saliri nena ele raayo madaa kana muma naraalinu pabe enaali kalape. Go-rupa paliri nena epe yoto so yaa-para salia. Go-rupa puma ni raita mea epape. ");
INSERT INTO kjs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Go raburi mo penaalimi go agale raayo pagoma kedaame komo pirisa. Gore nipumi ele adaapu wisa-pulu kedaame komisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesumi nipuna disaipel alinu-para talo: Kamo le ele adaapu wi enaalinuri Gote-na Surube Yapi-para pope-airi kalai peme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Agale meda lagialo: Gore kamel mename noae kego-para pola pea pare ora kalai puma pea. Go-rupa pea pare kamope aliri so Gote-na Surube Yapi-para polalore apo mename noae kego-para kalai mada puma palia. ");
INSERT INTO kjs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gore nipuna alinumi go agale pagoma nimu waru pogolasaoma nimumi talo: Go-rupa pea-le ade abuna kagaa pirape konere aapimi mealia ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gore Yesumi nimu waru adaoma talo: Enaalinumiri mada napalimi pare Gote-me ele raayo mada palia. ");
INSERT INTO kjs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nipumi go-rupa lisa raburi Pita-me nipu-para go-rupa lisa: Pagape, naame naana ele raayo giyoma ne raita mea epamade. Go-rupa pamade-le naamere ali mealima ya? ");
INSERT INTO kjs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Gore Yesumi nimi ora lagialo loma go-rupa lakalisa: Werepe kagaa di opaliade raburi enaali Raapu Pirape alina Siri epe Siaa King madaa pitia. Go raburi nimi ni raita maa ipuma nimi page epe siaa King 12-pela madaa piruma Israel enaalina ruru 12-pela madaa kose lape agale pagaliminalo lisa. ");
INSERT INTO kjs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Go rabu enaali raayome abalade ni madaa kone rulaoma nimumi nimuna ada ama aapa nogo naaki ame balinu page maapu ele raayo giyasimi-pulu nimumi apo ele yoto ora waru mealimi. Go-rupa puma nimu ade abuna epe-rupa kagaa piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Abi enaali adaapu riri-nane pimi pare wala werepe koau-nane pimi enaali abala ririna epalimi. Go-rupa puma nimu riri-nane epalimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gore Gote-na Surube Yapi-na agale go-rupa wia lisa: Ali medame nipuna wain maapu surubisa. Go-rupa puma nipu ora abasade ribarego wain maapu kogono pinalo alinu mulalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gore nipumi mo kogono naakinu raapu kone komea sumare go yapi komeare kogono puma mone mea-rupa meaoma palimi lisa. Go-rupa lomare nimu mo wain maapu-para kogono pula penalo mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Go-rupa pumare naare ipulaina nipu kiritape su-para puma lisana ali medaloma pa aina adisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gore nipumi go alinu lakalisa: Nimi page neme epe kana mada gialua-le wain maapu kogono pula pulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Go-rupa loma nimu pisimi. Gore naare paame page naare pabola pulaina page ali medaloma wala kama mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gore ora alebo ribaa talo palaina maket-para puma ali medaloma pa aina adisa. Go rabu nipumi talo: Nimi go naare roaina ake puame pae? ");
INSERT INTO kjs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gore nimumi talo: Naa kogono giape ali meda dia yade lisimi. Gore nimi page mo wain maapu-para kogono puya pipa. ");
INSERT INTO kjs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ora ribaa lisa raburi mo wain maapuna aaraame surube ali go-rupa lakalisa: Neme kogono naakinu yaaloma nimuna kana kalape. Werepe epamede kogono naakinu kaloma puma abala ririna epamede kalo pora poape. ");
INSERT INTO kjs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gore alebo 5 klok raburi kogono epa pisimide alinumiri ten kina kama kalisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Go-rupa misimi-pulu ora abalade epa pisimide alinumiri nimu kana ora adaapupe mealima kone wisimi. Pare dia nimu page ten kina kama meaoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nimumi mumare mo maapuna aaraa-para rono pagesimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gore nimumi go-rupa lisimi: Go alinuri pena go epamede-le nimu kogono ogepusi pamede pare nimu kana naa giaede-rupa kama meame. Naamere naare paama kogono radaa pi pama. ");
INSERT INTO kjs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nimumi go-rupa lisimi raburi mo maapuna aaraame nimuna ali komea-mare go-rupa lakalisa: Adami ali, neme ni namakiraate. Gore abalade saa pi agale lapade rabu neme ten kina gialua laede. ");
INSERT INTO kjs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gore nena kana muma pu. Abalade neme ne gisuade-rupa werepe meawade alinu page gode-rupa katoa. ");
INSERT INTO kjs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gore nina go mone-me page nina yada pulalo paluare gore mada dia? Neme epe kone sawade pare nena pu-para kudipa kone sale ya? ");
INSERT INTO kjs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Go rabu Yesumi talo: Go-rupa pea pare werepe epeme enaalinuri nimu abala riri-nane popalimi. Yapare abala ririna epeme enaalinuri wala werepe epalimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu nipu Jerusalem su-para pulalo Go rabu nimumi kose lape agale loma lu makomalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","Gore nimumi mumare enaali ruru radonu mea kalomare nimumi koe ero agale loma kalipumi poteyoma repena polopea-para lu makomalimi. Go-rupa puma rogaalimi pare yapi repome tapa giyoma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Go raburi Sebedi-na weremere nipuna naaki laapo Yesu piri-para lamua ipisa. Gore go ena nipumi rumu pege puma su adainaaoma ele meda madaa Yesu-para ogelisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gore Yesumi nipuna agale abulisa: Nere ale raana pea? Go ename talo: Ne ali mudu pirali rabu naa naaki laapore meda nena pope ki-nane pirina meda koya ki-nane pirina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Gore Yesumi nipu lakalisa: Mo pada mulalo pape elere nipimi waru na-adepe. Gore nipimiri go neme ipa naluade kap madaare radaa pi ipa mada nalipi ya? Gore nipumi talo: Saa mada nalipa lisipi. ");
INSERT INTO kjs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Gore Yesumi nipu lakalisa: Nina kap mada nalipiri gore epelea pare nina pope ke-nane page koya ki-nane laapore aapi piralia palo go agalere nina-daa namakuaayo lisa. Apo pirape siaa-nuri Aapa nipuna kiritao saaya. ");
INSERT INTO kjs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mo 10-pela disaipel nimumi go remaa pagoma mo ameaya rono pagesimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Go-rupa pisimi pare Yesu nipumi nimu ipulupa loma lisana nimu-para talo: Nimimiri ademe. Ruru radona ali kalunumi enaali raayo rabuaniaaoma nimi puri waru paboma nimuna agale ora pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ali mudu medaloma go-rupa peme pare go konere nimina rikirana nasaapiralepape. Dia, pare ali meda nimina rikirana ali mudu pirulalo paliare gore nimi raba meape kogono ali abala piralia. ");
INSERT INTO kjs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ali medame ni mudu pitua kone salia-daare gore nimi raba mi ali-rupa abala pirina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Enaali Raapu Pirape Aliri nipu raba muma nipuna kogono paminalo-daa naipisa. Dia, pare enaali adaapu raba muma nimu madaa epa komalalo ipisade. Go-rupa puma nipuna kone wasa nimu raba meapena katalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gore nimu Jeriko su giyoma pisimi raburi enaali adaapumi Yesu nipu raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gore mo le rubu pi ali laapo mo pora kebo-nane pirisipi. Nipumi Yesu epea remaa abala pagoma nipumi puri paloma nipumi go-rupa yaalisipi: Nere Devit-na si neme saa laapo madaa kodome komape. ");
INSERT INTO kjs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Go-rupa lisipi rabu enaali raayome nipina agale loraatepa loma nipu-para arere lisimi. Yapare nipumi go agale yokoma wala ora puri palo yaalisipi: Mudu Ali, nere Devit-na si-le neme saa madaa kodome komape lisipi. ");
INSERT INTO kjs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gore Yesu nipu puma rekaoma nipu yaaloma talo: Neme nipiri ake pano ya? ");
INSERT INTO kjs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gore nipumi go-rupa lisipi: Mudu Ali, neme saana le ma-epeaaina kone salepa. ");
INSERT INTO kjs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Gore Yesumi kodome komoma nipuna le ma-epeaasa. Ora go raburi nipuna leme waru adoma lisipina nipu page Yesu raita maa pisipi. ");
INSERT INTO kjs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nimu Jerusalem su-para re-para puma opapasimi rabu Rudu Oliv re-para pamuasimi. Go-parare Betfage su adare meda wisa. Go rabu Yesumi nipuna disaipel ali laapo mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nipumi go ali laapo go-rupa lakalisa: Mogo adare-para pulupa. Pumare donki mena si agiaaya laapo apo kopeme adiba aaya-le puma adalepape. Nipimi puma koyoma mea ipulupape. ");
INSERT INTO kjs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Gore ali medame nipi-para agale meda epa teare nipimi go-rupa laketapape: Mudu Ali nipu kogono go donki mena madaa wia-pulu nipumi saa maa palipa. Go-rupa tepe rabu ali medame donki mena mea rapaalia. ");
INSERT INTO kjs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Go pisipina kogonore abalade Gote-na agale lakale alimi go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Abi Saion su-para piri enaalinu go-rupa laketapape: Nena ali mudu abe nimi piri apo ipula-daa. Nipu kone pawa suma donki mena koauna piruma no epea-daa. Nipumi mo oge donki mena si enaali meda abe napiri-ai madaa pia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gore mo disaipel ali laapomere mo Yesumi lakalesa-rupa go-rupa puma pisipi. ");
INSERT INTO kjs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nipumi mo donki mena adibae yare puma muma nipuna adaa mamina-nu donki mena koau mada suma ipisipi. Go-rupa pumare Yesu nipu so donki mena koauna pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nipu piruma ipisa rabu enaali adaapupeme so pora pagina lisimi. Go rabu medalomame nimuna mamina-nu pora pagina maa saapirisimi. Medalomamere repena alanu yado saapirisimi. Gore Yesumi rabuaaoma epenalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Go rabu enaali adaapu medaloma abala riri-nane pisimi medaloma pa aapu-nane ipuma go-rupa yalaasimi: King Devit-na siri ipula-daa. Nipuna bi minasalimina. Ali Mudu-na bi mea ipula-daa nipuna bi minasalimina yalaasimi. Gote-na ora so madaa pia alina bi kalamina yalaari puma mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu nipu Jerusalem su-para pisa raburi mogo adare-para piri enaali raayo pogolasaoma lisimina go aliri aapi ya lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gore mo nipu raapu pisimi enaalimi talo: Gore nipu Gote-na agale lakale ali Yesu lisimi. Nipu Galili su robo-para adare Nasaret piri ali yade lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu nipu mo lotu ada ru-nane puma kodobaoma nipumi lotu ada-para pisa rabu kana ele ropo pi alinu kamaa-nane ralu lisa. Nipumi puma kana kili ropo pi alinuna robole ale lakepe rubebe puma yaanu kabe alinuna rabole alenu lakepe lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Go-rupa pumare nipumi agale go-rupa lakalisa: Gote-na agale wi buk madaare nipumi go-rupa lea: Nina adare beten lape ada pu ma-alimi pare nimimi paake noma alinuna kaledape ada-rupa perekeyoma ma-aarimina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu nipu lotu ada-para pirina le koe enaalinu-para age koe enaali medaloma nipu piri-para ipisimi. Go-rupa pisimi rabu nipumi nimu ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Go-rupa pisa pare Gote-na lodo kira-ae ali kalunu-para mo rekena agale tisaa alinu-para nimumi mo Yesumi napi kogono pina adisimi. Gore mo nogo naakinumi lotu ada-para piruma go-rupa lisimi: King Devit-na sina bi minasalimina. Go-rupa lisimi rabu nimumi ronome komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Go-rupa puma nimumi Yesu-para talo: Neme mogo lamede agalere pagae? Gore nipumi talo: E, go agalere pagalo pare abalade nimimi agale go-rupa nadipiasimi kone salo: Nimimi abalade nogo naakinu-para madu saapiri rupame agale mana waru pagisimi-pulu nimumi bi minasaatalo pimi. Go agale napageme ya? ");
INSERT INTO kjs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Gore nimu pirina Yesu adare Betani su-para ribaa puma puaa palisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gore wala yapipu-nane yapi lapaasa rabu Yesu nipu so adare-para pisa rabu reame puma komisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gore nipumi repena fik kili pora pagina adoma go-para pisa. Puma adisa pare kili komea-daa page na-elesa pa kama yopisa. Gore Yesumi mo repena fik lakalisa: Nere kili wala meda ora namaitiape. Go-rupa lisa rabu ora wagepu mogo repena fik kaapu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gore disaipel alinumi go-rupa adoma paalame komisimi. Go repena fik ake puma wagepu kaapu yala kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesumi talo: Pagalepa. Nimimi kone waru rulaoma kone laapo nasalimiri go repena fik madaa pawade-rupa nimi page go-rupa mada palimi. Go-rupa madaare nimimi mogo aaya rudu ne yokoma no ipa solwara-para puma pogola leme raburi mada pagalia. ");
INSERT INTO kjs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gore nimimi ora kone rulaoma beten leme-daare gore ele raayo beten loma mada mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gore Yesu nipu lotu ada ru-nane piruma enaali raayo epe agale moge riaasa. Go rabu Gote-na lodo kira-ae Ali kalunu-para Israel ali kalunu-para ipuma Yesu nipu-para epa talo: Nere go kogonore aapina puri muma pae lisimi. Nere abalade go kogonore aapimi pape laa-daa pili pa lisimi. Nere go kogono painalo puriri aapimi gia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Gore Yesumi nimu go-rupa lakalisa: Neme page agale komea go-rupa nimi agale mealuame pi. Gore nimimi nina agale-daa abutimiri neme page nimi nina kogono go alimi gisa lo nimi lagialua. ");
INSERT INTO kjs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon-me abalade enaalina kalu-ipa mea saayade kogonore Gote-me kalisa pe pa enaalinumi kalisimi ya? Go agale pagoma nimuna agale lalaaoma go-rupa lisimi: Gore naa Gote-me kalisa tema-daare gore nipumi naa go-rupa lagialia: Ake paa-daa nimimi Jon madaa kone narulalisimi palo lagialia. ");
INSERT INTO kjs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gore naame pa enaalinumi kalisimi tema-daare naana enaalinu madaa paalame komalima. Gore enaali raayome Jon-re Gote-na agale lakale ali kone wimi temare naa timi. ");
INSERT INTO kjs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Go rabu Yesuna agale go-rupa abuloma lakalisimi: Na na-makuaama lisimi rabu Yesumi talo: Go-rupa leme-daare aapimi ni puri guma kogono gea aliri nimi page mada nalagialua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesumi adaa ali kalunu-para go-rupa lakalisa: Ali komeame naaki laapo madu wisa. Go remaare pagalepape. Go aaraame mupaa naaki lakeloma nere wain maapu kogono pula pu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Gore go naakimi gipia lomare wala werepe kone perekeyoma wala kogono pula pasa. ");
INSERT INTO kjs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gore aaraame wala mo naaki meda piri puma komea go-rupa puma lea. Gore go naakimi talo: Aapa, ni palua lo aaya pare napea. ");
INSERT INTO kjs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Go rabu Yesumi talo: Gore go naaki laapo madaare aapimi aaraana kone misa? Gore nimumi talo: Mupaa naakimi lisimi. Gore Yesumi nimu-para talo: Abalade Jon nimi piri-para ipuma nipumi epe pora madaa epe agale mogeaasa pare nimimi kone narulalisimi. Dia, pare mo takis mi alinu-para pora pami enanuri werepe nimumi Jon-na agale madaa kone rulasimi. Go-rupa pea-le takis mi alinu-para ali paake rume enanu-para nimuri Gote-na surube su-para abala riri-nane adalimi. Go-rupa pirisimi pare nipu abala adoma lisimina kone naperekea nipu madaa kone narulalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nimimi saa pi agale meda pagalepa. Ali medame nipuna su adaalepe saaya-pulu wain maapu adaalepe poasa. Nipumi pape pu mawaaoma go-para kili igipi pabo sape ele warisa. Go-rupa pumare nipumi maapu surubape ada adaalupe maasa. Go-rupa pumare nipumi kana yoto meape alinumi surubainaloma nipu kimisu pisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nipu puaoma werepe mo wain maapu kili ralape di rudu lisa rabu maapu surube alinu piri-para kogono ali medaloma penaalisa. Gore nipumi mo surube alinu mo wain kili napeae medaloma gina kone suma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Go kone wisa pare mo maapu suruba-ae alinumi nipuna kogono naaki meda lumare medare kaname lumare lu rubisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gore mo wain maapuna aaraame wala kogono naaki medaloma mea rapasa. Pare abala mo maapu suruba-ae alinumi pisimi-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wala werepere nipuna si mea rapasa. Aaraame nina naakina agale pagalimi kone suma maa rapasa. ");
INSERT INTO kjs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pare mo maapu suruba-ale alinu nimumi naaki adoma nimumi go-rupa lisimi: Go ipula alimiri aaraana moae-ele raayo mealia-le naame nipu wagepu lu makoma go maapuri naa ora meamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Go-rupa loma nipu lu makomaa muma so pape mopare mea rubisimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesumi agale go-rupa lisa: Werepe mo wain maapuna aaraa ipumare mo wain maapu suruba-ae alinu-parare ake palia kone wimi? ");
INSERT INTO kjs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nimumi talo: Go ali koe raayore waru tia. Go-rupa puma mo wain maapu wala ali ruru rado mea katea. Go alinumi surubenaloma kili eleade raburi raloma nipu epe kaleme. ");
INSERT INTO kjs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Gore Yesumi talo: Nimimi Gote-na agale wi buk madaa sade agalere abala pagamina: Abalade kamda kogono pi alinumi Mea rubesimi yade kanare Abiri ora epelea-daa ada palimi. Ali Mudumi abalade go-rupa pisa yaa-pulu Naame go kanamere epe rado pia ada ma-opaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Go-rupa pea-le neme nimi ora lagialo: Gote-na Surube Yapi-na eda ma-opaaeme enaali mea katea-daa adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Enaali raayome go kana madaa magaitabalimiri nimu pola tabebe palia. Go kaname enaali meda tiare gore go enaali palapi-rupa talia. ");
INSERT INTO kjs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gote-na lodo kira-ae ali kalunu-para Farisi alinumi Yesuna saa pi agale pagisimi rabu naa-para agale tea kone suma makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Go-rupa lisa raburi nipu ripinaalalo pisimi pare enaali paalame komisimi. Enaalimi Yesu Gote-na agale lakale ali kone wisimi-pulu go alinumi paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gore Yesumi nimu-para saa pi agale meda wala go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Gote-na Surube Yapi Di-ri gupiale: Ali mudu medame nipuna naakina ena mulalo pisa raburi adaa edape meda yawesa. ");
INSERT INTO kjs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Go-rupa pumare nipumi ena lamulalo yawe eda nola ipulupape loma nipuna kogono naakinu agale maa penaalisa. Laketa pisimi pare enaalinumi mo eda giyoma naipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gore naipisimi rabu ali mudumi wala kogono ali medaloma mea rapaaoma go-rupa lakalisa: Nimi pumare epape enaalinu-para go-rupa puma laketapape lisa: Pagalepa, nina edare abala yokoma gawa mena ru mena-para sinu page abala lu yawobayo lisa. Eda raayo abala yarera pama-le nimi ena rumaape eda nola ipulupape pua tapape. ");
INSERT INTO kjs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mo kogono naakinumi go agale puma lakalisimi pare eda nape enaalinumi go agale giyoma nimuna kogono pisimi. Medare nipuna maapu pisa. Medare nipuna bisnis kogono pula pisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Go-rupa pisimi pare ali medalomamere ali muduna kogono naakinu ripinaaoma lu makomasimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gore ali mudu rono pagoma nipuna soldia alinu maa rapasa. Nimumi mo kogono naaki alinu lu makomaoma nimuna ada raayo kirabasimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Go-rupa pumare ali mudumi nipuna kogono naakinu go-rupa lakalisa: Ena lamulalo yawe edare abala yarera pawade pare mo neme yaalawade enaalina konere kolea lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Go-rupa pea-le nimi mo pora pagina puma go adalimide enaali raayore eda yawe nola epena pua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nipumi go-rupa lisa raburi pora kepaa-nini pumare epe enaali-para koeyae enaali raayo makiritaaoma puma adisimi. Nimu raayo ipuma mo enaali rumaae kana ada epa marubitabasimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mo enaali epa kirita pirisimi raburi ali mudu nipu mo kiritape enaalinu adolalo epa kodobaoma adisa. Pare ali komeame ena rumaae rabu kalae mamina namaraasa. ");
INSERT INTO kjs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Gore ali mudumi mo ali-para talo: Adami ali, nere epe mamina nayamaina-le ake paa-daa pae lisa pare agale na-abulisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Go raburi ali mudumi kogono alinu go-rupa lakalisa: Nimimi nipuna ki age rogaaoma so kamaa mea lopalimi rabu nipu su ribaale-para pirina lisa. Go ribaale-para pirumare nipu re lo nipuna kidipaa rugulano piralia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesumi agale go-rupa pu kiritasa: Gore Gote-me enaali adaapu yaata pare nipumi adoma ali komea komea laatapu muma ru-nane maa pea lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gore Farisi alinumi Yesuna kone adolalo agaa misimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nimuna disaipel alinu-para Herot-na alinu-para meda rabu Yesu piri mea rapaasimi. Nimumi go-rupa puma lisimi: Tisaa, naame nere ora agale lape ali-rupa adema. Ora agalemere enaalinu madaa rumaalua. Go-rupa pe pare enaalinu raayo kone komea-rupa ade. Dia, neme enaali raayo agale komea-rupa lakete. ");
INSERT INTO kjs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Go-rupa pede-le neme abe aleda kone saliri naa lagi lisimi: Gore naame Rom-na ali mudu Sisar-para takis kana kalano yapae dia yapae agale lorapisimi. Naana rekena agaleme age lea pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gore Yesu nipumi nimuna koe kone abala adoma nimu-para talo: Nimiri makirae agale le alinu. Ake paa-daa nimimi ni-para makirae agale loma ni kotaleme? ");
INSERT INTO kjs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nimimi mo takis kalape kana meda mea waatapa lisa. Go-rupa lisa rabu nimumi kana meda mea ipuma waalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Go rabu Yesumi nimu agale lorapisa: Go mone-na bi-para piksa-parare aapina ya? Gore nimumi Sisar-na lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Go-rupa lisimi rabu Yesumi nimu lakalisa: Gore Sisar-na elere wala nipu puma katepape pare Gote-na elere Gote nipuna katepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nimumi go agale pagoma pogolasaoma Yesu giyoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Go raburi Sadyusi alinu nimu Yesu piri-para ipisimi. Go alinu nimumiri kome enaalinu wala narekalimi leme-daa go madaare Yesu epa agale lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nimu ipuma talo: Tisaa, Moses-me agale go-rupa mogeaasa: Ali meda nogo naaki napirina komaliare nipuna ena wasa ameme nogo naaki maitalo mada rumaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gore abalade nimu ameayalu ki medane luma medane laapo pirisimi. Pare ali mupaare ena lamuma komisa pare nipuna nogo naaki napirisa. Go-rupa pisa-pulu nipuna koau-nane ameme go ena wasa nipu lamisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wala ame laapo pa repo pa page nogo naaki napirina komoma pa kama pirisimi. Go-rupa pu kiraloma ki medane luma medane laapo ameaya raayo pa komisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mo ameaya raayo komabasimi raburi werepe mo ena page komisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gore neme mo kome enaali wala rekalimi rabu mo ena wasare mogo ali ki medane luma medane laapo wala rekalimi-daa aapina were ora piralia ya? Neme makuaaye nimu raayome mogo enana aaliri aapi ora piralia ya? ");
INSERT INTO kjs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Gore Yesumi nimu go-rupa lakalisa: Nimiri Gote-na agale napagoma nipuna puri page na-ademe-pulu nimimi agale pa-rupa leme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gore kome enaali wala rekalimide raburi mo ena wala ali napalia. Dia, so yaa-parare ensel-rupa piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pare go kome enaali wala rekape agalere neme nimi agale mealo: Gore nimimi abalade Gote-me go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Niri Abraham-para Aisak-para Jekop-para nimuna Gote pi lisa. Go-rupa paa-daa Gote-re abala kome enaalinuna Gote-daa dia, pare nipu kagaa piramala pope enaalinuna Gote yade. ");
INSERT INTO kjs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Enaali raayome Yesuna agale pagoma akepu lea pe kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gore Yesumi Farisi Sadyusi alinuna agale pora poasa rabu Farisi alinumi go agale pagoma nipu adola ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nimu go epa kirita pirisimi raburi nimuna rekena agalena tisaa komea pirabasa-pulu nipumi Yesu-para go-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisaa, mo rekena agale raayo ora epelea-le ora abala mudu rekena agalere aaya pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Gore Yesu nipumi go-rupa lakalisa: Nena Mudu Gote-re pu lome page kone wasaame page puri-para raayome raaname komoma ranaa komo piralepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Go rekena agalere ora abala mudu agale lagialo lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gore rekena agalena laapo pa komea go-rupa lagialo: Nimina yogale madaa raana komo pedo pi kone wimi-rupare pa enaali meda page komea-rupa raana komape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Go rekena agale laapore Moses-na rekena agale raayo-para Gote-na agale lakale alinu agale raayo go agale rolo-para epe-rupa. ");
INSERT INTO kjs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi alinu nimu pa kiritaba pirina Yesumi nimu agale go-rupa misa: ");
INSERT INTO kjs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nimimiri Keriso madaare ake kone wimi? Nipuri aapina si ya? Gore nimumi Devit-na si lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Go-rupa lisimi rabu nipumi nimu lakalisa: Holi Spirit-mi ake paa-daa Devit-na kone marekaasa-daa nipu ake paa-daa nina ali mudu lisana ya? Gore Devit-mi talo: ");
INSERT INTO kjs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Gote-me nina Ali Mudu go-rupa lakalisa: Nere nina pope ki-nane ali mudu piraina. Werepere nena lore alinuri nina age rolo-para mapiraalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gore enaali Raapu Pirape alina Siri nipu Devit-na si yade-le ake paa-daa Devit-mi bi nina Ali Mudu lakalisa ya? ");
INSERT INTO kjs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gore ali medame mo Yesu nipuna agale meda na-abulisimi. Gore nipu paalame komisimi-pulu wala go rabu page werepe page nipu-para agale meda nalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Werepe Yesu nipumi nipuna disaipel alinu-para enaali raayo-para agale go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mo rekena agale tisaanu-para Farisi alinu-para nimu Moses-na agale moge ria pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Go-rupa pea-le agale raayo nimi lagialimiri nimimi pagoma waru mogeaalepape. Go-rupa palimi pare kone meda nimumi nimi mogeaalimiri napagalepape. Go-rupa pea pare go agale napagoma raleme. ");
INSERT INTO kjs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gore nimumi ele adaapu rogaaoma alinuna pasaa madaa mariaaeme. Go-rupa peme pare nimuna kimi mo enaali naraba meape namakuaaeme. ");
INSERT INTO kjs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kogono raayo nimumi pemere pa enaalinumi nimu adena kone suma peme. Adalepa. Nimuna beten ta pulalo peme raburi rogope madu wimi. Go nu kamaare maduma ropaa-para wenone yapa ramu-rupa meme. Go page nimuna mamina kalena madaa ele au elenu awo kilipita peme. ");
INSERT INTO kjs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Go eda yawo saeme raburi nimumi mo riri-nane pirape siaa go kama raaname komeleme. Go-rupa pumare no lotu ada-para pimide-rupa riri-nane wi reke madaa raaname komeleme. ");
INSERT INTO kjs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Go page nimu mo maket-para adanu peme rabu nimimi abe piralepape loma naana tisaa leme rabu nimumi pedo peme. ");
INSERT INTO kjs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pare enaalinumi nimi-para tisaa pi-daa wala nateme. Dia, nimu raayo ameaya piralimi rabu tisaa komea piralia. ");
INSERT INTO kjs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Go page su kamaa enaali medame naana aapa go pi-daa natapape. Nimina aapa komea-mare so yaa-para pia. ");
INSERT INTO kjs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Go page nimi-para nimumi Mudu Ali go pi-daa natapape. Dia, nimina ali muduri komea piruma nipu Keriso pia. ");
INSERT INTO kjs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Go-rupa pumare nimi ali mudu pirulalo paliare nimi raayome raba meape ali-rupa abala pirina. ");
INSERT INTO kjs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ali medame nipuna gole ali mudu pirulalo nipu bi minasaaliare nipuna bi rolo-para palia. Pare ali medame nipuna bi rabuaniaaliare gore nipu ali mudu mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nimi rekena agalena tisaanu-para Farisi alinu nimiri waru adalepape. Nimiri makeae alinu pimi. Nimimi enaalinuna le agaa madaa Gote-na Surube Yapi-na pora gaape poaemede. Go-rupa peme pare nimina gore na-odobaeme. Go page enaali medaloma ru-nane puma kodobatalo peme pare nimimi pora poaeme. ");
INSERT INTO kjs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nimi rekena agale tisaanu-para Farisi alinu nimiri waru adalepape. Nimiri makeae alinu adaapu pimi. Nimimi ena wasanuna ada-para ele raayo paake nolalo peme. Go-rupa puma nimimi go pupitagi nape kone rabuaaniaalo beten adaalu pa leme. Go-rupa peme-pulu nimiri ora koe kedaa mealimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Rekena agalena tisaanu-para Farisi alinu nimi waru adalepape. Nimi ipinu madaa piruma ipa solwara raayona pamuma su raayona enaali raayo nimina disaipel ali-rupa pirinalo pamu aaeme. Nimina disaipel alinu mapiraaeme rabu nimu wala koe naaku-para go-rupa piru aaeme. Gore nimina koe naaku-para ora palimi pare nipu nimimi naaku-para penaateme. ");
INSERT INTO kjs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nimi le rabuli enaalimi enaali pora mea waalalo peme. Gore nimi abala waru adalepape. Nimimi go-rupa lemede: Ali medana lotu adana bi madaa yaa madaa makuaa tea-daare go agalere waru ele-daa dia. Pare so yaa-para aaya lotu adana gol kaname warili ele-daa lemere gore epelea leme. ");
INSERT INTO kjs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nimiri le rubu pi enaalinuri makeae pimi. Api madaa kone suma leme? Gore kaname warili kana mudu yapae mo kana warili kana wi epe lotu ada mudu yapae? ");
INSERT INTO kjs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gore nimimi go-rupa leme: Ali meda kana reke madaa yaa madaa makuaa tea-daare go agale mada giyalia leme. Go-rupa pea pare nipumi lodo kirita mo kana reke madaa suma yaa madaa makuaa tea-daare go agale mada nagiyalia leme. ");
INSERT INTO kjs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nimi ora le rubu pi enaali pimi. Gore kalea elere epelea-ae kone wimi? Gote-na lodo kira-ae epe-rupa palo Gote-na kana reke madaa lodo kirae-le ora epe-rupa ya? ");
INSERT INTO kjs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gore ali medame kana rekena bi madaa yada makuaa tea-daare ipuna agalere so reke madaa wi ele raapu tea. ");
INSERT INTO kjs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gore ali medame lotu adana bi madaa yaa madaa makuaa tea-daare Gote go ada-para pia-le Gote-na bi madaa page nipu agale tea. ");
INSERT INTO kjs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gore ali medame so yaa madaa makuaa loma tea-daare gore Gote so-para piruma nipu pia reke-para leme. ");
INSERT INTO kjs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nimi rekena agalena tisaanu-para Farisi alinu nimiri waru adalepape. Nimiri ora makeae alinu pimi. Nimiri pa yabe Rekena agale saapiruma Gote adalima konere nasalepape. ");
INSERT INTO kjs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nimimi enaali medaloma waalalo peme pare nimi abala le rubu pi ali pimi. Nimimi ogepuna meda ipa-para adobaaoma pia rabu mena kamel ipa-para peme laapo raita maa noma yolainaaya. ");
INSERT INTO kjs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Rekena agalena tisaa-nu nimi-para Farisi alinu nimiri makeae alinu-le nimimi waru adalepape. Nimimiri pa kap-para plet laapona kamaa-nane yogale radepealeme pare ru-nane pea koto pa pia. ");
INSERT INTO kjs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nimi Farisi alinuri le rubu pi alinu pimi. Abala ririnare mo kap-na ru-nane radepealimiri yogale page epelea. ");
INSERT INTO kjs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nimi rekena agale tisaanu-para Farisi alinu nimiri waru adalepape. Nimiri makeae ali-rupa pimi. Nimiri tapa madaa wape ele-rupa pimi. Nimimi kamaa-nane auri epe-rupa peme pare no ru-nanere ali kuli-para koe pugu pi elenu adaapu wia-rupa pimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nimiri apo tapa piruma kamaa-nane nimi epe-rupa pimi. Pa enaalinumi nimina yogale ademe raburi nimiri epe ali kone wimi pare nimina lo robaa-para ora agale raitape kone pagena rubitabea. ");
INSERT INTO kjs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nimi rekena agalena tisaanu-para Farisi alinu nimiri waru adalepape. Nimiri agale laapo le ali-rupa pimi. Nimimi mo Gote-na agale lakale alinuna tapa apedaa epe-rupa wariaoma kamaa-nane au waru laeme. ");
INSERT INTO kjs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Go-rupa puma nimimi go-rupa leme: Abalade naana kasuanu raapu pirisima yalo naame mo Gote-na agale lakale alinu nalu makomaa nimu naraba misima leme. ");
INSERT INTO kjs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Go agale leme rabu nimi Gote-na agale lakale alinu lu makomaape alinuna ruru pimi-daa leme. ");
INSERT INTO kjs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gore nimimi nimina kasuanuna kone muma abala pisimi-ae wala peme. ");
INSERT INTO kjs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nimiri koe kerome madi sinu pimi. Gote-me kose agale tea raburi nimimi ake puma mada giyoma koe naaku-para mada napiralimi ya? Dia, koe kedaa mu piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Go-rupa pea-le nimimi pagalepape. Neme Gote-na agale lakale alinu-para kone makuaae alinu-para Gote-na agale lakale tisaanu-para raayo nimi piri-para mea rapaalua. Go-rupa palua pare medalomare nimi lu makomalimi. Medalomare repena polopea mada nil-mi timi. Medaloma mo nimina lotu ada-para repena palaa timi. Medalomare nimimi adare meda-para raita moneaaoma adare rado-para raita maa palimi. ");
INSERT INTO kjs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Go-rupa palimi-pulu epe-rupa pirape enaalinuri nimumi lu makomalisimide-le to madaare koe kedaa raayo mealimina. E, gore epe ali Abel pirisa rabu lu makomaniaama ipumare Berekia-na si Sekaraia-me epe lu makomaoma kiritasimide madaare koe kedaa mealimina. Go alina siri abala lotu ada-para piruma kana reke madaa re-para piruma nimina paa-aenu epa rumaalia. ");
INSERT INTO kjs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gore neme nimi ora lagialo: Apo lu makomaasimide enaalina page abi go rabu pimi enaali nimuna koe kedaa ritimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem enaalinu-ya. Nimimi Gote-na agale lakale alinu lu makomaeme Gote-na Mea Rapaae Alinu page kaname limi. Ora rana adaapu neme nena sinu mea kirita suma kupitaalo pe. Go-rupa yaa kebome nipuna sinu nipuna popa-para mea kirita mapiraalade-rupa pe. Go-rupa pe pare nimimi ni giyamede. ");
INSERT INTO kjs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nimimi pagalepa. Abiri nimina adare pa aaina lo giyalua. ");
INSERT INTO kjs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","E, gore neme nimi go-rupa lagialo: Gore nimimi ni wala na-adalimi pare nimimi werepe go-rupa leme: Gote-me go Ali Mudu-na bi meape aliri nipu ora epelea leme lisa. ");
INSERT INTO kjs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nipu lotu ada-para piruma kamaa-nane pisa raburi nipuna disaipel alinu nipu mo lotu robele-rupa mea waalalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Go rabu nipumi nimu agale go-rupa lakalisa: Nimimi go epe lotu ada waru adalimina. Neme nimi ora lagialo: Kana go-rupa pubaaya-daare ora komea napubaalia pare raayo kilipi rubalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu nipu so Rudu Oliv madaa pirina disaipel alinu nimu komea pawa ipuma go-rupa epa lisimi: Go kedaare aa-rabo epalia yapae lo agale lorapisimi. Ora abala ririnare ake abala epalia-daa adalima ya? Go adalima raburi nena epape Yapi-para su yaa laapo maa perekealia rabu makuaalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Gore Yesu nipumi go-rupa lakalisa: Pa ali medame nimi makiraalia-daa nimimi abala waru adalepape. ");
INSERT INTO kjs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ali adaapu nimu nina bi madaa nimumi go-rupa teme: Niri Gote-na Mea Rapaae Ali pi-pulu loma enaali adaapu ora makiralimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Go raburi nimimi marekaape agale-para yada ora pape remaa pagalimi pare wala makirape agale adaapu natapape. Go elenu raayore abala epalia pare su yaa perekeape yapi di-ri go rabu abe na-epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Go-rupa pumare ruru medamere ruru rado radonu raapu yada palimi. Go page gavman-na adaa su rado radonu raapu yada palimi. Go rabu su raayo-parare reae adaa paboma sumimi palia. ");
INSERT INTO kjs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Go ele raayo abala ririna epalia pare ename naaki maitalo koau nalade-rupa epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Go raburi nimumi nimi adialalo muma kedaa guma radaa manaaoma nimi lu makomalimi. Go raburi nimimi nina agale waru pagalimi-pulu enaali raayome nimi-para kone koe salimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Go raburi enaali adaapumi nimuna epe kone rulaere giyoma wala nimuna amenu rono pagoma lore alinu le-rupa pia piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Go rabu makirae Gote-na agale lakale enaali adaapu lidi rala paliade-rupa ma-auliaa-pulu enaali adaapu makiralimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Go raburi koe elenu adaapu su raayo-para opoma epalia-pulu enaali adaapu nimuna epe raana komape kone mada giyalimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Go-rupa paliade raburi go enaali medame puri paboma kone rulaoma waru piraliare gore su yaa laapo dia yaalia rabu epe-rupa kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Go-rupa pea pare Gote-na Epe Agalere su raayo-para laketalo kiritalimi. Mo enaali raayome pago kiritinalo go rabu su yaa laapo dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gore werepe koe pugu pi eleme epe lotu ada-para rekaina adalimi. Abalade Gote-na agale lakale ali Daniel-me lisa-rupare epa rekalia. Ali medame go agalena re pagali-daare waru pagape. ");
INSERT INTO kjs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Go raburi Judia su-para piri enaali raayore so rudu apedaa-paranu pogola pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gore enaalinu nimuna ada perali piralimi pare nimuna ada ru-nane wi elere namula pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Go page enaalinuri maapu-para pitimiri nimina mamina wala namula pulupape. ");
INSERT INTO kjs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Go raburi ena nogo naaki adu nalae pirinu-para naaki padaa piri enanu-para gore nimu madaa ora kodo waru palia. ");
INSERT INTO kjs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yapare Pomo mu Pirape Yapi Di-ri koe kogore yai epe rabu nimi mada na-epalia-le nimimi Gote yaaloma beten waru tapape. ");
INSERT INTO kjs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Go raburi kedaa ora adaalepe opalia. Gore su kagaa warisa rabu epaoma puma abe page kedaa gupiale meda na-epea. ");
INSERT INTO kjs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Go-rupa pea pare Gote-me abalade go di rudupu namuma sula pisa yalore enaali raayo ora komola pisimi. Pare Gote-me nipuna kone mapiraae enaali nimu koe kone mealimi-pulu go yapi di marudu yaalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Go raburi ali medame nimi go agale lagialiare adalepa: Gote-na Mea Rapaae Ali go pia tea page mogo-nane epa pia tea page nimimi nipuna agale madaa kone narulaalepape ");
INSERT INTO kjs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Go rabu makirae agale lape ali Gote-me mea rapaaripa loma adaapu epalimi. Go rabu nimumi page napi kogono puma ele epape-rupa rado rado adaapu palimi. Go-aenu nimumi mada palimi pare Gote-me nipuna mapiraae enaali makiralimi. Go-rupa yapare mada dia. ");
INSERT INTO kjs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gore neme nimi abala lagiawade-le waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Go-rupa pa-pulu pa enaalinumi nimi go-rupa lagialimi: Mo enaali napiri su-para aaya-le leme-daare go su-para napulupape. Go-rupa page nimumi mogo kaleda yaa leme-daare nimuna agale napagalepape. ");
INSERT INTO kjs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di, Gote-me enaali Raapu Pirape alina Si epenatea rabu ari-yapa naare ipula-nane pabola-nane popea-rupa wagepu epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gore abala kome enaalina yogale wi-parare yaa itaayamanu epa kiritalimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Go rabu adaa kedaa abala pupu kiritinaloa wagepu naare kudunaoma ribaa yaalia. Go-rupa puma suba mada naraalia. Go-rupa puma kubanu page yaa-para giyoma lopalia. Go-rupa pumare yaa-para ae puri pale elenu page mada lewa lewa palia. ");
INSERT INTO kjs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Go raburi enaali Raapu Pirape alina Si epape Di-ri so yaa madaa ele adenalo palia. Go-rupa puma makuaamonalo. Go raburi go su kamaa enaali ruru raayome re waru leme pare enaali Raapu Pirape alina Siri so yaa mole yaako yaa madaa awoma ipuma nipu adaa puri paa raapu epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Go-rupa puma biugel-na agale pagenaloa nipuna ensel-nu mea rapaalia. Go-rupa palia raburi nipu abalade mapiraae enaalinu mea kiritalimi lisa. Kiritalimi rabu su yaa laapo yaruma aawaaya-nane pamuma nipuna ruru enaalinu epa mea kiritalimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nimimi repena fik kili madaa kone mealepape. Nipuna palaa-para ipaa rubima yo kagaa rekeyo rubea raburi gore abe pani palia kone wimide. ");
INSERT INTO kjs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Go raburi werepere apo ele raayo adalimi rabu epaliade yapi di ora re-para kiritaaoma aaya lisa. ");
INSERT INTO kjs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gore nimi waru pagalepa. Go pima enaaliri abe nakomalimi pare go ele raayo openaloma nimimi adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Go su yaa laapore mada dia yaalia pare nina agalere ade abuna kagaa pa salia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ali medame page go yapi-para naareme Pomo mu Pirape Yapi di page namakuaaeme. Yaa-para pimi ensel-numi page ni page go yapi di namakuaaema. Dia, naana aapa komea nipumi kama raapu go di saapia. ");
INSERT INTO kjs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Abalade Noa nipu raapu pirisimi enaalinumi rilisimi kedaare wala enaali Raapu Pirape alina Si su kamaa epaluade rabu go-rupa opalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Abalade go ali Noa pirisa rabu ipa abe narilisa pare nimumi eda yawo ipa no enaalinu rumaaoma go-rupa pu pirisimi. Go page Noa nipu ipa ipinu ru-nane kodobaoma pirina go-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Go-rupa pumare nimu naniminae pirina ipa roma enaali raayo tabisa. Go-rupa enaali Raapu Pirape alina Si epaliade rabu page go-rupa palia. ");
INSERT INTO kjs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Epalia raburi ali laapo maapu-para kogono pala pirina pare Gote-me meda muma medare giyalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ena laapome page bret wariala pirina Gote-me meda giyoma meda mealia. ");
INSERT INTO kjs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Go-rupa pea-le nimimi kone waru su piralepape. Nimimi nimina Ali Mudu-na epaliade yapi di namakuaaeme-le waru suruba piralepape. ");
INSERT INTO kjs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nimimiri go agale madaa kone mealepape. Gore nimimi paake ne ali epape yapi di makuaaoma suruba pimi gore nimimi u napali rabu page mada suruba piralimi? Go-rupa pumare mo paake ne alimi go kana ada ru-nane mada nakodabalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Go-rupa pea-le nimimi page enaali Raapu Pirape alina Siri aa-rabo epalia palo maarea-le nimimi page waru surubalepape. Gore nimimi na-adoba piralimi rabu epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gore epe kogono pi alimiri epe kogono kama pea? Go pi aliri nipuna adaa alimi nipuri nipuna kogono naakinu rado surubenaloma nipu surube ali mapiraaya. Go-rupa pumare nipumi nimuna eda nape yapi di rabu eda rumaainalo mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Werepe mo ali wala epalia rabu nipumi mo nipuna kogono naakimi mo kalisade kogono agale-para aalia rabu raaname waru komalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gore neme ora nimi lagialo: Mo Mudu Alimi go kogono naaki ele raayo surubenalo ali mudu mapiraalia ");
INSERT INTO kjs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pare mo kogono naakimi koe kogono pu piralia rabu ada aliri abe wagepu na-epalia kone wia. ");
INSERT INTO kjs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Go kone suma nipumi nipuna kogono naaki yagonu pamu loma nipumi puri pale ipa pamu noma alinu raapu aasa. ");
INSERT INTO kjs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Go-rupa pumare kogono naakimi nipu namakuaama pa aina kogono napalaina epa opopalia. Go-rupa palaina nipuna Mudu Ali ora meda wagepu epalia. ");
INSERT INTO kjs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Epalia rabu Mudu Alimi go kogono naaki rake loma mo makirae alinu raapu mapiraalia Go-nane pirumare nimuna kidipaa regepe no re lo koe-rupa piralimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Werepe Gote-na Suruba-ale Suri gupiale epalia: Ena maapua 10-pela pirisimi raburi ali meda ena pena lamulalo epalia remaa pagisimi. Gore pagisimi-pulu mo enanumi 10-pela lam-nu muma nimu rumaape eda yawe-para epolalo pora pagina maitaari pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Go-rupa pisimi pare mo ena supuri nimu makeyae pirisimi pare ena supuri epe kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gore mo makeae enanumi lam-re mea ipisimi yapare ru-nane koyape wel namuma ipisimi ya. ");
INSERT INTO kjs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pare mo nimu kone waru saapirisimi enanuri nimuna lam-para ru-nane mapiraape wel raapu makiritaaoma maa ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mo ena rumaape ali abe wagepu naipisa-daa adoba piruma nimuna le-para u ipisa-daa umi kole male lapirae suma u palisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Go rabu ribaare ora rumu-nane pirisimi raburi mo 10-pela ena go-rupa pagisimi: Mo ena rumaape ali go epea-le mo pora pagi-nini madaaoma pulupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gore mo ena maapua raayo rekoma nimuna lam kiritao su-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Go-rupa puma mo kone waru nawi enanumi mo kone waru wi enanu-para talo: Naana lam kudinolalo pia-le nimina wel meda gialepa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gore mo kone pa sae enanumi nimu agale go-rupa lakalisimi: Dia, go wel-re nimi page naa page mada dia lisimi. Go-rupa pea-le nimina stua-para puma puaa kabalepa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gore mo enanu nimu mo stua-para wabola kabola pisimi raburi mo ena rumaape ali ipisa. Gore mo ena medaloma kiritao pirisimi raayore mo ali raapu ena lamulalo yawe eda nola puma pora gaape garulabaoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Werepe mo ena maapua medaloma wala pora gaape epa luma talo: Mudu Ali, naa epamona pora loba lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gore nipumi nimu go-rupa lakalisa: Nimiri ali-para piruma epame? Neme nimi ora na-ade maarea lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Go remaa lakeloma Yesumi enaalinu-para talo: Go-rupa pea-le nimimi waru surubalepape lisa. Nina abala epape di-ri ribaa epalia paalo alebo epalia paalo ni na-ade lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gore Gote-na Surube Yapi Di-ri gupiale yade pi remaa lagialo: Ali meda su rado-para pora pamuala pulalo palia-le gore ipuna kogono naakinu-para ipulupa loma lisana ele raayore nimimi surubalepape tea. ");
INSERT INTO kjs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gore nipumi mo naakinuna puri adoma kone ado puma nipumi nimu ele rumaaoma katea. Gore ali medare kana 20,000 kina rumaasa. Go-rupa puma ali meda 8000 kina kalisa. Wala ali medare kana 4000 kina rumaaoma kalisa. Nipumi nimu kana go-rupa kaloma nipu pisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gore mo kana 20,000 kina misade alimi kogono wagepu pa kama pumare wala nipumi kana 20,000 kina meda lisana saaba pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Go page mo ali medame 8000 kina misade alimi kogono pa kama puma kana 8000 kina meda misa. ");
INSERT INTO kjs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pare mo ali meda nipumi kana 4000 kina misade Mudu Ali kana muma su naaku ruboma puma paga wisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Gore mo adaa ali nipu adaalu piruma lisana nipuna kogono naakinu kana adaapu kalisa-pulu nipu raapu agale ma-redepo yala palua kone suma ipisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Gore abalade kana 20,000 kina misade ali ipumare nipumi kana 20,00 kina muma nipumi epa talo: Mudu Ali, abalade neme ni kana 20,000 kina giside pare neme kana yoto kogono puma wala go mone-na yago pode meda 20,000 kina apo meawa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Gore nipuna Mudu Alimi nipu go-rupa lakalisa: Epe lea-le nere ora nina epe kogono naaki-le neme epe kogono paina lisa. Neme abalade oge elesinu page waru surubaina-daa neme nere ele adaapu surubainalo pi lisa. Ne nipu saa ni raapu ranaa komo pirapana. ");
INSERT INTO kjs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gore kana 8000 kina kalisade ali page ipuma go-rupa epa lisa: Mudu Ali, neme page bisnis kogono pa kama puma pode kana 8000 kina propet meawa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gore nipuna Mudu Ali mi nipu go-rupa lakalisa: Epe lea-le nere ora epe kogono naaki yana lisa. Neme abalade epe-rupa puma kogono waru surubisina. Neme abalade oge elesi waru surubaina-daa abe neme ele adaapu surubaina kone salo lisa. Go-rupa pea-le ipumare saa laapo ranaa komo pirapana. ");
INSERT INTO kjs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gore mo kana 4000 kina misade ali page ipuma go-rupa lisa: Mudu Ali, neme nere abala makuaayo. Nere puri pale ali yade. Ali meda nipuna sae maapu-para neme eda wai aoma nisi. Go page su kuni meda-nane ali medana poae edare neme go eda page madisi. ");
INSERT INTO kjs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Go-rupa paa-daa neme paala komoma nena kana su naaku roboma paga wisua. Abiri nena kana go ada lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Gore nipuna Mudu Alimi nipu-para talo: Nere kogono naaki koe yaana. Nere kia rakepele ali yaana. Gore ora abalade neme ali medame poae e maapu-para eda awesuade lae ya? Go page ali medame nape eda neme maitia yarina lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gore nina kana-re mo kana kiritape ada-para ake paa-daa namuma epae ya? Go-rupa pula pisi yalore ni wala ne piri ipuma kana pode medaloma raapu kana wala gula pe. ");
INSERT INTO kjs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Gore nimimi kana adaapu gisuade alinu wala muma mo kana 40,000 kina mi ali puma kala lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gore enaali medalomame ele saapitimi-daare gore neme wala medaloma lisana katoa lisa. Go page enaali medalomame ele ogepusi saapiralimiri mada nasaapitimiri nina wala raayo mealua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Go kogono naaki koere ora su ribaale-para pena ralusaatepa lisa. Gore nipuna kidipaa regepe no re lo piralia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Werepere enaali Raapu Pirape alina Simi ensel-nu raapu epalia raburi epe paa mea ipuma Siaa King madaa piruma epalia. ");
INSERT INTO kjs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Go raburi su kamaa piri enaali raayona epe makiritaaoma robo laapo rumaalia. Go rumaaliade konere sipsip meme menanu mo surube alinumi robo laapo rumaaoma meda-nane meda-nane palia. ");
INSERT INTO kjs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Go-rupa pumare nipumi sipsip menanuri nipuna ora ki-nane mea mapiraaomare mo meme menanuri koya ki-nane mea ma-aalia. ");
INSERT INTO kjs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Go-rupa palia-pulu mo ali mudu nipuna pope ki-nane pitimide enaalinu-parare go-rupa tea: Nimiri nina Aapana epe raba meape kone abala misuade-le ipulupa tea. Abalade su yaa laapo pena warisa rabu Aapame nimina Surube Yapi Di maa saasa-le nimimi epa mealepa tea. ");
INSERT INTO kjs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gore abalade ni ipa eda nalame komisua rabu eda ipa gisimide toa. Niri kimisu pisuade rabu nimina ada-para lamua pisimide toa. ");
INSERT INTO kjs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni mamina dia lisade raburi nimimi mamina gisimide toa. Ni yaina komisuade raburi nimimi ni raba misimide toa. Ni karapo ada palisua rabu ni adola ipisimide toa. Nimimi go-rupa pisimi-pulu nina Surube Yapi Di mealimina toa. ");
INSERT INTO kjs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Go raburi mo epe kone wi enaalinumi go-rupa leme: Ali Mudu, aa-rabo ne reame komisi rabu naame ne eda gisima ya? Ne aa-rabo ipa nalame komisi-daa naame ipa no giyasima ya leme? ");
INSERT INTO kjs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gore aa-rabo ne pora kimisu-para pamiside rabu ne naana ada-para lamua napamisima ya? Go page ne aa-rabo mamina dia yade rabu naame mamina gisima ya? ");
INSERT INTO kjs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ne yaina komisi rabu page ne karapo ada palisi rabu page naame aa-rabo adola ipisima ya? ");
INSERT INTO kjs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Go rabu ali mudu king-mi agale go-rupa abutea: Neme nimi ora ria lagialo. Gore nimimi nina aapa amenu-para pisimide alinuri gore nina ame ogenu-para pisimide. ");
INSERT INTO kjs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Go-rupa pu kiralomare neme mo koya ki-nane piralimidenu go-rupa laketoa: Nimiri alu pape enaalinu nimi neme na-ade-le pane pulupa toa lisa. Go-rupa puma repena nakudili-para palimina. Go repena sulaare Gote-me Satan-para nipuna ensel-nupara yarera paaya. ");
INSERT INTO kjs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gore abalade nimimi ni reame komo pirano eda ipa ele nagisimide toa. ");
INSERT INTO kjs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni pora kimisu piri ali ipisuade rabu nimimi ni nimina ada-para nalamua pisimide toa. Ni mamina dia lisa raburi ni naraba misimide toa. Ni yaina komisua rabu page karapo ada palisua rabu ni nasurubesimide toa. ");
INSERT INTO kjs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Go raburi nimumi page ipu-para go-rupa lakeleme: Ali Mudu, aa-rabo ne reame koma piraina adisima pe leme. Ne eda ipa nalame komisi page mamina dia lisa page yaina komisi rabu page karapo ada palisi page naame aa-rabo naraba misima ya? ");
INSERT INTO kjs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Go raburi Ali Mudumi agale go-rupa abutua: Gore neme ora nimi lagialo toa. Nimimi abalade rolo rolo pirae ame balinu naraba misimide-le go raburi nimimi abalade ni page naraba misimide toa. ");
INSERT INTO kjs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Go-rupa pe-pulu go enaali raayore repena sulaa-para puma piruma ade abuna radaa no piramina. Pare mo epe enaali raayore ade abuna epe-rupa piralimi toa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Go raburi Yesu nipumi go agale raayo pu kiraloma lisana nipumi nipuna disaipel alinu-para go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Gore nimimi makuaaeme. Go Pasova Eda Nape Di-ri wala yapi laapo dia yaalia rabu salia lisa. Go rabu enaali Raapu Pirape alina Siri repena polopea madaa timi rabu komalia pare wala rekalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Go raburi Gote-na lodo kira-ae ali kalunu-para mo Juda alinuna ali mudu-para nimu Gote-na lodo kira-ae ali Kaiafas-na ada-para puma kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Go-rupa pumare nimumi kudiri pu Yesu nipu ripinaaoma lu makomaatalo yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pare wala nimumi talo: Gore Pasova Eda yapi Di rabu naa go napamina-le mo enaalinumi naa raapu yada marekaalimi lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu nipu Betani su-para puma yakilimi li yaina-ae ali Saimon-na ada-para puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Go raburi Yesu eda nala pirisa pare ena meda nipu piri-para ipisa. Go enamere kaname warili botol-para roropo pi wabola pira palae meda mea ipisa. Go wabolana yotore ora ele adaapupeme kabeme. Yesu nipu reke madaa eda no pirisa raburi go ename Yesuna kaluna madaa koyasa. ");
INSERT INTO kjs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Go raburi disaipel alinumi rono waru pagoma nimumi talo: Go wabolare ake paa-daa pa koyaate pae? Mo nipuna kana elere ora adaalepe yade-le ake paa-daa mone ruba? ");
INSERT INTO kjs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Naame go wabola yoto mealima raburi ora ele adaapupe muma medaloma enaali riabo naralinu rumaaoma kalema lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesumi nimu adoma nimu go-rupa lakalisa: Gore ake paa-daa go ena rono pagaaleme? Nipumi abalade ni madaa ora epe kogono pisade. ");
INSERT INTO kjs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ade abuna enaali naralinu raapu komea-para pitimi pare niri nimi raapu-daa ade abuna napitima. ");
INSERT INTO kjs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Go ename ni mada wabola koyaaripadere gore nipumi nina ro tapa-para rogaalimi makiritaasade lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Waru pagalepa. Ora su raayo-para epe agale lakela palimi raburi go ename ni madaa pia page leme-le nipu madaa kone meamina. ");
INSERT INTO kjs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Go rabu disaipel ali 12-pela alina meda nipuna biri Judas Iskariot nipu Gote-na lodo kira-ae alinu piri-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Go-rupa puma nipumi nimu-para puma talo: Neme Yesu nimi maa gialua-le nimimiri ni ele gialimi pe lisa. Go agale lakalisa rabu nimumi kana silva kili 30 kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Go-rupa pumare Judas nipumi Yesu adi katalo puma nipumi pora asa pisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gore Bret Kaapu le Nape yapi Di raburi disaipel alinumi Yesu nipu piri-para nipu talo: Naame Pasova nape edare ale-para mea yarera palima ya? ");
INSERT INTO kjs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Go rabu nipumi talo: Nimi mo ada re-para puma ali meda piraliade-para go-rupa laketapape: Tisaa-me talo: Nina eda nape Di-ri abala rudu yaana. Go-rupa pea-le nena ada-para eda Pasova nola epalua lo robaama laketapape. ");
INSERT INTO kjs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gore disaipel alinumi Yesuna agale pagoma Pasova nape eda mo ada-para abala yarera pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gore ora alebore mo disaipel ali 12-pela Yesu raapu reke madaa eda nolalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nimu eda nolalo pirina Yesumi talo: Neme nimi ora ria lagialo: Nimina rikirana pia ali medame ni muma lore alinuna kinaa mea katea lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Go-rupa lisa rabu disaipel alinuna kone-para kedaa waru pisa-pulu nimu komea komeame go-rupa lisimi: Ali Mudu, ora ne madaa agale lae palo loma nipu agale go-rupa misimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pare nipumi go-rupa lakalisa: Ali meda ni raapu plet madaa-para ki salipa. Go alimiri ni madaa yada robo maduma ni tape ali piralia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gore enaali Raapu Pirape alina Siri Gote-na agale wi buk-mi lea-rupa raluma yawalimi lisa. Go-rupa palimi pare enaali Raapu Pirape Ali linalo koae makirae ali komeare ora kodo waru pea lisa. Go aliri nipuna agimi abala namadula pisa yalore ora epetea pisa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Gore koe makirae ali Judas nipumi go-rupa lakalisa Lisaa-ya, Ni-para lae? Yesumi talo: Nena lae lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nimu eda nala pirina Yesu nipumi bret muma piribima Gote-para ora pili loma lisana nipuna disaipel alinu kalisa: Go-rupa puma nipumi talo: Gore nina to-le mea nalepa. ");
INSERT INTO kjs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nimumi nala pirina ipa wain kap-para pira palae muma lisana Gote-para ora pili loma nimu kaloma talo: Nimi raayome mea nalepa. ");
INSERT INTO kjs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gore nina yaapimi Gote raapu meda-para pogalu piralimina koe elenu mea rubenalo koyaato. ");
INSERT INTO kjs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Abi neme nimi lagialo: Wain ipare abe wala nanalima pare nina Aapana surube su-para nimi raapu kagaa wain namina. ");
INSERT INTO kjs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Go-rupa lomare nimumi yasa meda abala loma lisimina kamaa puma su Rudu Oliv-nane pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesumi nimu-para talo: Abi go ribaa nimi raayome ni giyoma pogola palimi lisa. Go kone madaare Gote-na agale wi buk-mi go-rupa lu wia: Gote-na sipsip menasi surube ali lu makomalimi rabu sipsip raayo pu pa yabalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pare Gote-me ni tapa-para wala marekaalia rabu Galili su-para ni abala riri-nane popalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gore Pita-me Yesu agale go-rupa lakalisa: Go ali raayome ne mada palia-ai adoma giyalimi pare ni komeame nena giyalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Gore Yesumi nipu-para talo: Neme abe go ribaa yaa kebo agale abe narekena neme ni na-ade rana repo te. ");
INSERT INTO kjs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Gore Pita nipu-para talo: Niri ne raapu komea-para komalipa pare neme ne nagiyalua. Go-rupa lisa raburi disaipel ali raayome go-rupa kama lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu nipuna disaipel alinu raapu nimu Getsemani maapu-para pirisimi. Go-rupa puma nipuna disaipel alinu-para pawa piralepape lisa. Ni mogo-para puma beten ta pulu lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gore nipu raapuri Pita-para Sebedi-na si lapo-para nimu pisimi. Go raburi nipuna lo robaa-para kedaa puma nipu ora waru kodome komisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gore Yesumi nimu lakalisa: Nina kone-parare ora kedaa waru puma ni ora komape yaata-le nimi go-pare piruma ni adaba piralepape. ");
INSERT INTO kjs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gore nipu ogesi-daa puma nimuna le agaa madaa puma lopoma beten go-rupa lisa: O, nina aapa, neme ni mada raba mealia-daare neme go kedaa pi kap meape. Pare nena kone raluma pape. Nena koneme pa teau pape. ");
INSERT INTO kjs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gore nipu wala mo disaipel ali 12-pela piri pumare nimu abala palisimi ya. Go-rupa puma nipumi Pita go-rupa lakalisa: Nimimi niri naare le ogesi-daa mada na-ado pitimi ya? ");
INSERT INTO kjs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gore ni koe eleme epalia-le beten loma nimi waru adoba piralepape. Nimina konemere raaname komeleme pare yogalemere rana nakomae. ");
INSERT INTO kjs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nipu wala rana laapo puma beten go-rupa puma lisa: Nina aapa, go kedaa meape kap maa pu kone salo pare neme nape tedere nena raaname palia kama paina. ");
INSERT INTO kjs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nipu wala nipuna disaipel alinu epa adisa pare nimuna lo robaa-para kedaa pisa-daa wala pa paita wisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nimu pa u paitae ena puma beten rana repo wala puma lisa ");
INSERT INTO kjs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Go-rupa puma nipuna disaipel alinu piri-para wala ipuma talo: Nimiri abalade ora pa piruma pomo muaeme? Adalepa. Abiri enaali Raapu Pirape alina Si nimumi koe alinu piri-para mea kaleme. ");
INSERT INTO kjs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Baina nimi rekalepa. Yada lore alinu ni re-para mea kalalo go epea-daa. ");
INSERT INTO kjs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu nipu agale pa lala pirina disaipel alinu 12-pela nimuna ali komea Judas nipu ipisa. Go ipisa rabu enaali adaapu nipu raapu ipuma lisimina nimumi rai kudu-para repena kabenu-para rulubaoma ipisimi. Gore nipuri Gote-na lodo kira-ae ali kalunu-para Juda alinuna ali kalunu-para page nimumi maa penaalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Go koae makirae ali nipumi mo lore alinu-para go-rupa palua-le adalepape pi pagaa wi kone go-rupa lakalisa: Neme ali meda-para nunu paluare gore nipu Yesu yaa-pulu nipu ripinaalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Go-rupa lomare nipu wagepu alo puma lisana: Tisaa, epe-rupa aliri epa lomare nipuna le agaa-para puma nunu pisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Gore Yesumi nipu go-rupa lakalisa: Adami ali, mo nena pulalo epae kogonore abe wagepu pape. Go raburi nimu ipumare Yesu nipu epa ripinaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ali meda Yesu nipu raapu pirisipi alimiri nipuna kimi rai kudu yolomisa. Go-rupa puma nipumi mo Gote-na lodo kira-ae alina kogono naakina kale maa yada poasa. ");
INSERT INTO kjs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Go-rupa pisa raburi Yesumi nipu go-rupa lakalisa: Neme go naaki nena rai kudu wala abe nipuna ada-para maitaa lisa. Ali raayome rai kudu raapu yada palimiri gore rai kudumi ali raayo nabalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gore nimi namakuaaeme. Neme nina aapa yaatoade rabu nipumi yada pape ensel-nu go-rupa 12-pela ruru rabuniaae epenala toare mada pagola pea. ");
INSERT INTO kjs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pare neme go-rupa paluade raburi Gote-na buk madaa li agalena re mada na-epalia. ");
INSERT INTO kjs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Go rabu Yesumi enaali adaapu go-rupa lakalisa: Nimi ni mula ipumare nimina rai kudu-para repena kabe ripinaamare nimimi paake ne ali meda mula epame? Ade abuna ni lotu ada-para piruma neme enaalinu agale mogeaaripude pare go rabu nimimi ni na-epa misimide. ");
INSERT INTO kjs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Go-rupa pea pare mo Gote-na agale lakale alinumi buk madaa abala lisimi-rupa ora epenalo mada palimi. Go rabu disaipel ali raayome Yesu giyoma nimu pogola pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesu nipu epa ripinaaoma maa pisimi alinumiri Gote-na lodo kira-ae ali kalunumi Kaiafas-na ada-para maa pisimi. Go ada-parare rekena agalena tisaanu-para kone makuaa ali medaloma-para nimu komea-para kiritaba pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita nipu Yesu raita maa pisa pare ogesi-daa mo-pare pumare Gote-na lodo kira-ae alina epe pokaala ada ru-nane puma pirisa. Nipu puma kodobaoma mo surube plisman-nu raapu puma piruma mo nimuna pimi-ae adolalo pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Go rabu Gote-na lodo kira-ae ali kalunu-para kaunsil raayo-para nimumi Yesu madaa pa kama makirae agale mulalo Yesu nipu werepe lu makomaalalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Go-rupa pisimi rabu enaali adaapu epa kiritaoma makirae agale epa lisimi. Go-rupa pisimi pare nipu lu makomaape agale meda nalisimi. Go-rupa pisa pare werepe ali laapo ipisipi. ");
INSERT INTO kjs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Gore nipumi epa talo: Go alimiri Gote-na epe lotu ada lakepe ruboma wala yapi repome wala palua laalisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gore Gote-na lodo kira-ae ali mudu nipu rekoma awoma Yesu nipu agale lorapisa: Ne madaare agale adaapu pu aaeme-le nemere agale meda mada nate ya? ");
INSERT INTO kjs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Go-rupa lisa pare Yesu nipumi agale meda nalisa-pulu Gote-na lodo kerele alimi go-rupa lakalisa: Neme ade abuna pirape Gote-na bimi yaa madaa makuaa agale mealo-le neme agale meda naa lagiali. Nere enaali Raapu Pirape alina Si ya? Nere Gote-na Si ora ria ya? ");
INSERT INTO kjs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Gore Yesumi talo: Neme abala apo laede pare neme wala lagiano: Abi page werepe page enaali Raapu Pirape alina Si ade abuna Gote-na pope ki-nane pirano adalimi. Gore so yaa madaa mole raapu piruma epalua rabu adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesumi go-rupa lisa rabu Gote-na lodo kerele alimi nipuna mamina riripima talo: Gore nipumi Gote madaa ero agale lea-le nipuna adasae ali medana agale napagamina lisimi. Dia, go aliri Gote madaa ero agale lea-le napagalepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gore nimimiri ake kone saleme? Go raburi nimumi go-rupa lisimi: Gore nipu ora koe ali yaa-pulu nipu ora lu makomamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Go-rupa lomare Yesu nipuna le agaa-para supi raa kiraasimi. Nimumi nipu ki paarame luma nere Gote-na agale lakale ali yaa-pulu lagiali. Nere aapimi tala pae lisimi? ");
INSERT INTO kjs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Go rabu Pita nipu ada perali-na pape ru-para pirisa pare Gote-na lodo kirape ali muduna kogono ena medame Pita ali piri-para ipuma talo: Ne page abalade Yesu raapu so Galili su-para piraede lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Go-rupa lisa pare Pita nipumi enaali raayona le-aga madaa ni-daa dia yade loma go-rupa lisa: Neme go lae agalere ni maarea. ");
INSERT INTO kjs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Go-rupa loma lisana nipu puma so papena pora gaape-nane puma pirisa. Go rabu kogono ena medame nipu adoma go komea-para pirisimi alinu go-rupa lakalisa: Go aliri abalade Yesu raapu no Nasaret su-para pirisipi. ");
INSERT INTO kjs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gore Pita-me makirae agale wala go-rupa lisa: Ora yaa madaa neme go ali na-ade lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Werepe ogesi-daa piruma go re-para aasimi ali medalomame Pita-para go-rupa lakalisimi: Gore nere Yesu nipuna ruru piruma nipuna adaa agale-rupa le lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Go rabu Pita-me yada maduma agale puri palo talo: Ni ora agale nalagialore Gote-me ni lina talo. Go aliri ni na-ade. Nipumi go agale lalaaina yaa kebome gagara agale lisa. ");
INSERT INTO kjs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Go rabu Pita-me abalade Yesumi lakalisade agale wala makuaasa: Yaa gula agale abe narekaena neme rana repome ni giyali lo lakalisa. Go rabu Pita nipu so kamaa-nane puma re pua papirisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yapi lapaasa raburi Gote-na lodo kira-ae ali kalunu-para kone makuaae Juda ali kalunu-para nimumi mo Yesu lu makomaatalo yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nipu puri pale kopeme adiala so namba wan gavman Pailat piri-para lamua pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gore mo koae makirae ali Judas nipumi Yesu linalo kose loma nipu ora lu makoma linalo adisa. Go-rupa adisa-pulu nipumi wala kone perekeyo suma mo kana silva lili 30-pela wala mo Gote-na lodo kira-ae ali kalunu-p ara kone waru wi Juda ali mudunu piri wala maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Go-rupa puma nipumi talo: Neme abala koeyae puma ora epe ali tapena kabe reke abala meawade pare nipu koeyae meda napia. Gore nimumi nipu-para talo: Gore naana yada dia yapare nena kogono abala paede lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Go-rupa lisimi rabu Judas nipumi mo kana silva 30-pela no epe lotu ada ru-nane ruboma lisana nipu puma kope pua nisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gore mo Gote-na lodo kira-ae ali kalunumi go kana mumare gu-rupa lisimi: Gore ali lu makomaatalo yoto kale kana lisimi. Gore rekena wia-le lotu ada-para wi kana raapuri go kana nasamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Go kana madaa agale meda gu-rupa robo sumare go mone-mere sospen warili alinuna su kabamina lisimi. Go su-parare pora kimisu enaalina tapa wariamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Go-rupa pisimi-pulu go suna bi ali yapi koeyae bi maasimi. Go suri abe page pa wia. ");
INSERT INTO kjs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Go-rupa abalade agale meda Gote-na agale lakale ali Jeremaia-me lisade agalena rere ora go ipisa. Gore nipumi talo: Nimumi go kana silva 30-pela misimi. Go kana-re mo Israel su-para piri enaalinumi ali tapena kabe reke mi kana lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Go kana muma lisimina Ali Mudumi lagisa-rupa nimumi sospen warili alinuna su kabisimi. Go agalere Gote-na lakale ali Jeremaia-me lu wisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Go rabu Yesu ora ali mudu gavman-na le agaana rekainaloma mo gavman-na ali mudumi agale go-rupa misa: Nere Juda alinuna ali mudu ya? Yesu nipumi talo: Nena go laede ali lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Go-rupa lisa pare Gote-na lodo kira-ae Ali kalunu-para kone makuaae Juda ali kalunumi pa kama mariaoma kose lape agale lisimi. Go-rupa pirisimi pare Yesu nipumi agale meda na-abulisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Go-rupa pisa-pulu ali mudu gavman Pailat-me talo: Mudu Ali, mogo ne-para kose lape agale go lemere ne napage ya? ");
INSERT INTO kjs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Go-rupa lisa pare Yesu nipumi agale meda na-abulisa rabu gavman-na ali mudu Pailat nipumi kone adaapu wisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gore oro maali yalore Pasova Yapi Di rabu mo gavman Pailat-me karapo ada-para pali alinu komea maa penaalala pisa. Mo kamaa-nane piri enaalinumi naana go ali penaalape lisimi rabu go raana raluma penaalala pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Go rabu ora ali koe meda Jisas Barabas mo karapo ada-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Enaali raayo kiritaoma pirisimi raburi gavman-na ali mudu Pailat-me talo: Nimimi neme aapi rapano kone saleme lisa. Gore Jisas Barabas giano yapae Yesu nipuna bi meda Keriso giano ya lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Go-rupa lisa pare nipumi nimuna kone makuaa misa. Nimumi Yesu komea kudipa kone suma nipu maa kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat nipu kose pagape siaa madaa pirina nipuna wereme agale gupa rapaasa: Apo epe ali madaare neme aleda nalape. Neme abe ribaa upaa puma kedaa adaa mea-daa adawa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Go rabu Gote-na lodo kira-ae Ali kalunu-para kone makuaae Juda alinuna ali mudunu mi enaali raayo makiraoma lisimi: Barabas kepema Yesu ora lu makomamina tapape lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pare mo namba wan gavman ali Pailat-me nimu-para talo: Go ali laapore nimina konemere aapi penalano ya? Gore nimumi talo: Jisas Barabas lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Gore gavman ali Pailat nipumi talo: Yesu nipuna bi meda Keriso-re ake pano ya? Go-rupa lisa pare nimumi puri paloma talo: Nipu ora repena polopea mada komena tamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pare gavman-na ali Pailat-me talo: Ake paa-daa ya? Nipumi koe ele ake paa ya? Go-rupa lisa pare nimumi puri paloma talo: Nipu ora repena polopea mada tamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gore mo Pailat nipumi mo enaalinumi nipuna agale mada napagalimi kone adisa. Nipuna konere nimumi yada marekaalimi lo pisa. Go-rupa pea-le nipuna ki ipa-para pataoma mo enaalinumi adenalo radepelisa. Go-rupa puma nipumi mo enaalinu-para talo: Go ali lu makomapere ni-daa dia lisa yapare ora nimina kogono. ");
INSERT INTO kjs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Go-rupa lisa rabu enaali raayome agale go-rupa lisimi: Go lo makomaape aliri naa-para naana nogo naakinu madaa kedaa epenawa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gore go rabu gavman-me Jisas Barabas wala nimuna ada penaalo kepeasa. Go-rupa puma nipumi Yesu repena pata luma repena polopeana nil-mi linalo kalisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Go rabu mo gavman-na soldia alinumi Yesu nipu muma mo gavman-na surube ada-para maa pisimi. Go-rupa pumare soldia ali raayo nipu epa kutapu ma-aawasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Go-rupa puma nipuna mamina mea koyo ruboma kale mamina maa maara laasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Go-rupa puma keto keto raguna nipuna kalu madaa ma-adapasimi. Go-rupa puma nipuna pope ki-nane rama meda maa maripinaasimi. Go-rupa puma nipu re-para epa piruma rumu pege puma ero agale go-rupa lisimi: Nere Juda alinuna ali mudu yade-le ade abuna epe-rupa pirape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Go-rupa puma nimumi supi roma nipuna rimaapu muma nipuna kalu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nipu-para ero agale abala lomare mode kale mamina wala kolo ruboma nipuna abalana mamina-nu wala mea maraalisimi. Go-rupa pumare nipu repena polopeana nil-mi talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nimumi Yesu lamua pisimi rabu Sairini su-para piri ali meda Saimon pora pagina madaasimi. Go-rupa puma nimumi go ali-para Yesuna repena polopea mea raba mu riainalo mariaasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gore nimu pumare su meda-para opapasimi. Go suri Golgota lisimi. Go bina rere go-rupa: Ali kalu wi su maasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nimumi Yesu ipa wain koe rero pi marasin raapu kalisimi pare nipumi mea nadoma-le giyesa. ");
INSERT INTO kjs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gore nimumi nipu repena polopea madaa lumare nipuna mamina mulalo satu-rupa pu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Go-rupa pumare nimumi piruma Yesu adaba pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","So repena polopeana pagi-nanere nipuna kalu sone abalade nipu-para kose lape agale lisimide-rupa pepa madaa go-rupa lisimi: Go aliri Juda alinuna ali mudu yade lo pitasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Go raburi paake ne ali laapo Yesu nipu raapu nil lisimi. Go-rupa puma paake ne ali komea popoke-nane luma meda koya-nane lu mudiasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gore enaali raayo one pala mone puala pisimi enaalinumiri kalu wage alo puma ero agale laari lobasa pala pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Go-rupa puma nimumi talo: Nere lotu ada kilipima wala yapi repome ma-alua liside. Nere Gote-na Si yaaliare nena go-rupa raba meape. Nere ora Gote-na Si yaaliare apo repena polopea mada kilipima su kamaa nipu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Go-rupa lisimi rabu Gote-na lodo kira-ae ali kalunu-para rekena agale tisaa-nu kone makuaae Juda ali mudunu-parame ero agale go-rupa lisimi: ");
INSERT INTO kjs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Gore nipumi abala enaali medaloma raba muma ade abuna mapiraasa-pulu nipumi nipuna gole raba mu ade abuna piralia. Gore nipuri Israel enaalinuna mudu ya? Gore nipumi repena polopea giyoma su ama kilipialia-daare naame nipu madaa kone rulamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gore nipumi Gote madaa kone rulaoma niri Gote-na Si tea-daare Gote-me nipu abe raba meala paleme adamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Go-rupa pumare mo Yesu raapu nil-mi lisimide ali koe laapome page ero agale lisimi-rupa lisipi. ");
INSERT INTO kjs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gore naare rikirana aasa rabu raayo ribaame keapuma puma werepe naare nogo-nane pabola pupulaina yapi wala lapaasa. ");
INSERT INTO kjs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naare mogo-nane popa aaina alebo 3 klok rabu Yesu nipumi puri paloma go-rupa lisa: Eli, eli, laama sabaktani lisa. Go agalena rere go-rupa: O, naa aapa Gote, neme ni ake paa-daa giyatepa ya lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gore mo re-para rekesimi enaalinumi go agale pagoma nimumi talo: Go alimiri Elaija yaata lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Go raburi ali komeame abala alo puma lubi ele misa. Go-rupa pumare rero pi wain ipa paba palae repena kuli kuni-nane rogaa palaoma Yesu nipu nenalo kalisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Go-rupa pisa pare enaali medalomame talo: Abala adamina go ipa abe nakatapape lisimi. Elaija-me nipu raba mula ipula paleme adamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Go rabu Yesu nipumi wala puri paloma yaaloma nipuna pu imu lorasa. ");
INSERT INTO kjs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Go rabu mo lotu ada-para mudiabasimi mamina so pagi-nane riripi tyaboma none kuni-nane puma riripi tabisa. Go-rupa pumare su lewa puma kana adaapu lusaitabebe pisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Go rabu page tapa loba tabaoma puma Gote-na ruru enaali abala komisimi pare wala go rabu marekaasa. ");
INSERT INTO kjs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gore nimumi tapa ora giyoma rekesimi. Wala werepe Yesu rekesa rabu nimu epe adare Jerusalem su-para pisimi. Go raburi Mudu enaali adaapumi nimu adisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldia ali mudu-para nipuna soldia alinu-para su lewa-para ele raayo mo pisana adisimi-pulu nimumi paala waru komisimi. Go rabu nimumi go-rupa lisimi: Go aliri ora Gote-na Si yade. ");
INSERT INTO kjs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Go rabu Galili su giyoma Yesu nipu raita mea ipuma nipu raba mulalo ipisimide ena medaloma pirisimi. Nimu ogesi-daa mo-pare aoma nipu adisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gore nimuna rikiranare go enanu pisimi: Makdala su-para piri ena Maria-para ame Jems-para Josep laapona agi Maria-para Sebedi-na si laapona agi-para nimu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gore ribaa lisa raburi kamo ali meda Josep nipu Arimatea su-para piruma ipisa. Go ali nipuri abalade Yesuna disaipel ali pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nipu mo gavman-na opis-para ipuma Yesu nipuna ro ria ponoloma epa agale lorapisa. Go rabu gavman-me nipu lakeloma go ali Josep mea katapa lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Go-rupa pumare mo ali Josep-me Yesu nipuna ro mea ruma epe kagaa mamina yaako pimi rogaaoma ria pisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Go-rupa pumare nipumi mo Yesu nipuna ro ria pumare nipuna abalade warili kana apedaa-para puma rogaasa. Go-rupa pumare nipumi kana apedaa pora gaape-para kana adaalepe medame garulainaaoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala-para Maria rado-para nipu laapo pisipi. Nipu mo kana apedaa re-para piruma nipumi adapaba pirisipi. ");
INSERT INTO kjs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gore wala yapipu-nanere Pomo mu Pirape Yapi di abala ipisa. Go-rupa pisa-pulu Gote-na lodo kira-ae Ali mudu-para Farisi alinu-para mo Pailat raapu epa kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Go-rupa puma nimumi talo: Adaa ali-ya, gode makirae agale le alimiri nipu kagaa piruma go-rupa lisade: Gore yapi repo pa no tapa-para piruma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Go-rupa lisa-le yapi repo nimumi go tapa surubalepape agale lakela. Gore nipuna disaipel alinumi nipuna ro paake epa muma enaalinu-para nipu abala rekaaya loma naa makiraalimi-le soldia alinumi surubalimina. Go werepe lemede agalere abala lisimide-rupa ora mada yaalia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Gore Pailat-me talo: Nimumi surube ali medaloma lamua puma mo tapa ora puri pale alinumi puma surubalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Go-rupa lisa-pulu nimumi mo tapa kaname garulalisimi. Go-rupa puma nimumi mo kana rekena maa suma nimumi soldia ali medaloma surubaina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gore Pomo mu Pirape Yapi di abala dia lenalomare adaa koro rabu naare rapaasa. Go rabu Makdala su-para piri ena Maria-para Maria meda nipu laapome tapa-para adola ipisipi. ");
INSERT INTO kjs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pulaina wagepu su lewa pisa rabu yaa-para piri ensel meda ipisa. Gore nipumi kana apedaa-agaa pora gaape maa pereke pereke luma nipu go madaa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nipuna le agaare so yaa madaa piri paa nona pisa. Nipuna mamina-re ora mole yaa yaako nona pisa. ");
INSERT INTO kjs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Go ensel ipisa-pulu mo soldia alinu nimumi go-rupa adoma paalame ora waru komisimi. Go-rupa puma nimu pururu puma abala kome enaali pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pare mo ensel-me mo ena laapo go-rupa lakalisa: Gore nipimi paala nakomalepape lisa. Nimi repena polopea-para lu makomaarimide Yesu asa pula epamena-daa makuaato lisa. ");
INSERT INTO kjs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nipu go-para napia. Nipu abalade lisade-rupa wala rekaa pisa. Nipiri nipu rogaarimide-para epa adalepa. ");
INSERT INTO kjs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gore Nipi wagepu wala puma nipuna disaipel alinu puma laketapape: Nipu kana apedaa tapa-para wala abala rekaade. Nipu Galili su-para abala riri-nane pena nimumi go-para adalimi laketapape. Abiri neme lagiawade agalere koneme makuaalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Go agale pagisipi rabu mo ena laapo nipu paalame komoma raaname waru komisipi. Go-rupa pisipi-pulu nipu laapome wagepu mo kana apedaa tapa giyoma disaipel alinu laketalo alo pisipi. ");
INSERT INTO kjs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pare ora go rabu Yesu nipumi wagepu nipu laapo mo pora madama talo: Epe-rupa piralepa lisa. Go raburi nipumi nipuna kibu re-para puma ripinaa palae suma nipuna bi minasaasipi. ");
INSERT INTO kjs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gore Yesumi nipu go-rupa lakalisa: Nipimi paala nakomalepape. Nipimi nina amenu mo Galili su-para popena puma laketapape lisa. Go Galili su-parare ni mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mo ena laapo pena pora pagina pulaina mo tapa surube soldia ali medaloma mo adare-para wagepu pisimi. Go-rupa pumare Gote-na lodo kira-ale ali kalunu-para mo adisimi elena remaa pua lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Agale pagisimi-pulu Gote-na lodo kira-ale ali mudunu nimu raayo-para kone waru wi Juda ali kalunu-para nimu kirita piruma nimu agale robesimi. Go-rupa puma soldia alinu kana adaapu kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Go rabu nimimi agale go-rupa tapape lisimi: Ribaa naa paitala puama rabu nipuna disaipel alinumi maa puameya tapape lisimi. Go-rupa puma nipuna ro paake maa puame tapape lo robesimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gore mo namba wan gavman-me go remaa pagalia-daare naame agale medaloma wala lakelamina. Naa go-rupa palima rabu ne koe ele nasalia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Go raburi soldia alinumi kana mumare mo alinumi lisimi-rupa puma pirisimi. Go agale raayore Judia su-para laari laari pumare abe page pa lala pimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Disaipel ali 12-pela so Galili su rudu madaa pirisimi. Gore abalade Yesumi pulupape lisa-rupa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nimumi Yesu nipu adoma bi minasaasimi pare ali medalomame kone laapo wisimi, ");
INSERT INTO kjs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Go-rupa puma Yesu nipu ora re-para ipuma go-rupa epa lakalisa: Gote-me su yaa laapona puri raayo ni gia. ");
INSERT INTO kjs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Go-rupa pea-le nimimi su raayo-para puma nina disaipel enaalinu-rupa mapiraalepape. Go-rupa puma nimimi nimu Gote-na bi-para Sina bi-para Holi Spirit-na bimi kalu-ipa meatepape. ");
INSERT INTO kjs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Go-rupa puma neme abalade agale nimi mogeasude-rupa raayo puma laketapape. Pagalepa. Niri nimi raapu piraoma pumare go su yaa laapo dia yaalia rabu page nimi raapu pitua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gote-na si Yesu Keriso pirisa. Go buk madaare nipuna Epe Agale wia. ");
INSERT INTO kjs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ririnare Aisaia-me buk madaa agale gu-rupa lisa: Gote-me talo: Pagalepape. Neme nina agale laketapape ali abala epenatoa. Nimina lo robaa-para pora-rupa ma-redepo yatepape. ");
INSERT INTO kjs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mo aliri nipu enaali napiri su-para aoma gu-rupa yalisa: Ali Mudu epalia-le nipuna poranu epe-rupa kiritaaoma piralepape lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaia-me gu-rupa lisa-pulu Jon Baptais enaali napiri su-para abala ipuma gu-rupa lakalisa: Enaalinuna koe kone perekealimi-daare kalu-ipa mealimina. Gote-me nimina pupitagi maa raakepe rubalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gore Judia su robo ru-nane piri enaalinu-para Jerusalem su-para piri enaalinu page nimumi Jon-na agale pagola pirisimi. Nimu raayona koeyae puma la yoke agale lakeloma ipa Jordan-para kalu-ipa misimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon-me kamel menana yogale maraoma mena yogale aako yamesa. Go aliri enaali napiri su-para pirisa-pulu nipumi tapa-para alubi aapa wasu no pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon-me kiritaoma pirisimi enaalinu-para gu-rupa lisa: Naa koau-nane ali meda epalia. Niri koe ali yaa-pulu nipuna age ada koyona kege radepetalo palua madaare mada dia yade. ");
INSERT INTO kjs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neme nimi pa ipame kalu-ipa mu aayo pare Yesumiri ora Holi Spirit-na puri madaa kalu-ipa mealia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gore werepe Yesu nipu Galili su robo ru-nane go adare Nasaret su giyoma Jon piri-para pisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu nipu ipa pagi-nane abala yaa pora gaape lobesa-daa adisimi. Lobesa rabu Holi Spirit yaa biyaa ipuma saba Yesuna kaluna epa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Biyaalania yaa-para wi agale meda gu-rupa lisa: Nere ora nina si naaki-le neme ne madaa pedo pi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Go rabu Gote-na Siri Holi Spirit-mi enaali napiri su-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Go-para nipu yapi 40-pela puma pirina Satan-me Yesu pupitagi manaatalo kolisa. Go-para pirisa rabu kira menanu yaa yapanu Yesu raapu pirisimi pare ensel-numi nipu suruba pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gore Jon karapo ada mapaitaasimi raburi Yesumi Galili su-para ipuma lisana Gote-na kagaa agale pamu lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Lakalisa raburi gu-rupa lisa: Gote-na Surube Yapi di rudupu epalia-le koe kone perekelema kagaa agale madaa kone rulaalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu ipa Galili le pagi-nane pamisa rabu nipumi ali laapo adisa. Nipumi Saimon Andru ameaya laapo ipa le-para wena agona sala pirina adisa. Go ali laapona kogonore wena meape ali laapo pirisipi. ");
INSERT INTO kjs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesumi nipu lapo-para talo: Ni raita mea ipuma nina kone raitalipina. Go-rupa puma wena mepede-rupa enaalinu page go-rupa mada mealepape. ");
INSERT INTO kjs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Go-rupa lisa rabu go ali laapome wena agona wagepu giyoma Yesu raapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ipa mone pane ogesi-daa puma Sebedi-na si laapo adisa. Go ali laapona biri Jems-para Jon laapo. Go ameaya ipinu madaa piruma wena agona rabulala pirisipi. ");
INSERT INTO kjs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesumi go ali laapo adoma ipulupa lisa. Go-rupa lisa rabu go ali laapome nipuna aaraa-para kogono alinu-para giyoma Yesu raapu komea-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Go-rupa puma nimu Kaperneam su-para pirisimi. Go Pomo mu Pirape Yapi rabu Yesumi Juda alinuna lotu ada-para agale mogeaasa. ");
INSERT INTO kjs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mogeaasa rabu enaalinumi ki wage puma raaname komenalo rekena agalena tisaanu-rupa namogeasa. Dia, pare nipuna purimi rado-rupa agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Go agale mogeasa rabu koe remome makeae ali ipuma lisana agale puri palo e rui gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Go Nasaret su-para piri ali Yesu ya. Neme naa madaa ake pulalo epae ya? Nemere ne ade-le naa tyalalo epaina? ");
INSERT INTO kjs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Go-rupa lisa rabu Yesumi remo-para agale mana talo: Agale loraoma go ali giyape. ");
INSERT INTO kjs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yesumi go-rupa lisa raburi koe remome makeae ali pururu mapaaoma agale puri pale lomare giyoma pale popesa. ");
INSERT INTO kjs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gore rakepema pisa raburi enaali raayome kidipaa kuni luma meda lakelala pu pirisimi: Go aliri ake pia ali ya? Mogo alina agalere ora rado meda yade. Nipuna purimi koe remo agale mana tea-daa nimumi pageme lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Go-rupa pisa-pulu Yesuna bi Galili su-para mone mone laoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Go-rupa pisa raburi Yesu Juda alinuna lotu ada giyoma Saimon-para ame Andru laapona ada-para pisa. Jems page Jon page medaa rabu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gore Saimon-na aaya riripu pi yaina komisa-daa nimumi Yesu epa lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lakalisimi raburi Yesu ipuma lisana go enana ki ripinaaoma marekaaoma riripu pi yaina ma-epeaasa. Nipuna yaina dia lisa rabu nipumi nimu eda kalisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naare pabola pisa raburi enaalinu yaina komisimi page koau-nane remo piri enaalinu page Yesu piri-para mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mea ipisimi raburi su raayo-para piri enaalinu page Yesu adolalo ipuma pora gaape-para kiritao pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pirisimi rabu Yesumi enaali adaapuna yaina ma-epeaaoma lisana koe remonu page marakepeaasa. Koe remonumi Yesu abala adisimi-pulu Yesumi enaalinu-para go agale natapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gore wala yapi pena lapatalo palaina Yesu rekoma lisana enaali napiri su kamaa-nane puma Gote-para beten ta pisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Go raburi Saimon-para go adami ali medaloma page Yesu raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yesu adaoma pirisimi rabu gu-rupa lisimi: Enaali raayome ne asa pimi. ");
INSERT INTO kjs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesumi talo: Wala pa su meda-nane lakela bainalo nimi abala mogealalo pisa niri go-alenu lena. ");
INSERT INTO kjs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Go-rupa pumare nipu Galili su robo ru-nane su rado rado pamuma Juda alinuna lotu ada-para page lakeloma koe remonu page ralu rubisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Go-rupa pisa raburi yakilimi li ali medame ipuma rumu pege puma piruma Yesu gu-rupa kogelisa: Neme ni kone sali-daare naa rere makaapu yape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Gu-rupa kogelisa raburi Yesu nipumi kodome komoma nipuna ki ridulaoma go alina yogale waraaoma talo: Go-rupa pea-le abi kaapu yape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Go-rupa pisa raburi mogo yakilimi li alina yogalena rere kaapu yoma wala epe-rupa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesumi mo ali wagepu rapaoma puri paloma gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Waru pagape. Enaali raayo nalakelape pare Gote-na lodo kira-ae Ali piri-para nena yogale mea waalape. Moses-me Gote-para lodo kirita kalape abala lisa-pulu gu-rupa paina. Go pali raburi enaalinumi nena rere kaapu lea-daa mada adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesumi go-rupa lisa pare rere kaapu le alimiri agale adaapu one mone pamu lakalisa. Go-rupa pisa rabu Yesu adare meda-para kaledoma pisa. Nipu enaali napiri pa su meda-para pirina enaalinumi nipu piri-para agale pagolalo kiritata ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gore werepe yapi medame Yesu nipu mo Kaperneam su-para epa pia remaa pagisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pagisimi-pulu enaali adaapu kiritaoma ru-nane pora gaape-para page rubitabesa. Go-rupa pu pirisimi raburi Yesumi Epe Agale mogeasa. ");
INSERT INTO kjs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mogeasa rabu yaina komo pora napami aliri ali maalame ria ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gore enaali adaapumi mo pora gaape rubitabesimi-pulu Yesu piri-para mada nariaoma ipisimi. Go-rupa pisa rabu mo yaina kome ali ada koauna ria pisimi. Go-rupa puma ada-parae kulu minaala paoma rekele kopeme rogaabaoma apalae ru-nane pawa lopainaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Go-rupa pumare Yesumi nimuna kone muma pora napami ali-para talo: Ne naa naaki-le nena pupitagi ne kone mea rubaato. ");
INSERT INTO kjs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Go-rupa lisa raburi rekena agale tisaa-nu piruma nimuna lo robaa-para kone gu-rupa wisimi: ");
INSERT INTO kjs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Mo alimiri ake pea-daa lea pe lisimi. Nipumi Gote madaa ero agale leme paaya. Nipumi pupitagi ne kone mada rubalia ya? Gote nipu komeame mada rubalia kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Go kone wisimi raburi Yesumi nimuna lo robaa-para kone muma talo: Nimimi go piale konere ake pea-daa wimi pae? ");
INSERT INTO kjs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ale kogono puri mapalaatalo palua ya? Ni pora napami alina pupitagi ne kone mea rubaluare go kogono puri palea ya? Nipu pora mapamuaaomare go kogono ora puri palea ya? ");
INSERT INTO kjs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ni Gote-na Si komeamere su kamaa piri enaalinuna pupitagi mada mea rubalua-le adalepa. Go rabu yaina kome ali-para talo: ");
INSERT INTO kjs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yapara page u pali ele mea ripinuma rekoma ada pu. ");
INSERT INTO kjs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Go-rupa lisa raburi yaina kome ali wagepu rekoma yapara mea ripinuma pora pamisa. Pamisa raburi enaalinumi paalame komoma Gote-na bi minasaoma gu-rupa lisimi: Naame ele go piale na-adema lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ipa le pagi-nane wala pisa rabu enaali raayo Yesu piri-para epenaloma Yesumi agale moge riaasa. ");
INSERT INTO kjs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu pora pamisa rabu Alfius-na si Livai-ri takis mi ada-para pirisa. Yesumi go ali adoma talo: Ni raita mea nipu. Go-rupa lisa raburi Livai nipu rekoma Yesu raita maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Go-rupa pisa rabu werepe Yesu Livai-na ada-para eda nolalo pisa. Takis mi alinu-para pa riabo alinu-para Yesuna disaipel alinu-para nimu raayo ada ru-nane komea-para epa kiritaoma pirisimi. Gore enaalinumi Yesu raita mea ipisimi-pulu ora adaapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Go raapu pirisimi pare Yesu nipu pupitagi ne alinu-para takis mi alinu-para pirina Farisi alinuna pepa tyape alinumi nimu adisimi. Adisimi rabu nimumi disaipel alinu agaa gu-rupa misimi: Ake pea-daa Yesu takis mi alinu-para pupitagi ne alinu raapu piruma eda nala pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pepa tyape alinumi go-rupa lisimi rabu Yesumi nimuna agale pagoma talo: Yaina nakome enaalinuri dokta-na ada napeme pare yaina kome enaalinu pemede. Go-rupa neme page epe kone wi ali kama raba mula-daa naipisua pare enaali naraalinu raba mulalo ipisua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rana medare Jon-na disaipel alinu page Farisi alinu page Juda alinuna agale mogeama eda madaa niti puma pa pirisimi. Go rabu enaali medalomame Yesu piri-para agaa mula ipisimi: Gore ake pea-daa Jon-na disaipel alinu page Farisi alinu page eda nano pimi pare nena disaipel alinu eda pa neme lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Go-rupa lisimi rabu Yesumi saa pi agale gu-rupa lisa: Ali medame ena rumaalalo pia rabu nipuna adami alinumi eda kaleme ya? E, kaleme. Gore ena rumaape ali pia-pulu eda mada kaleme. ");
INSERT INTO kjs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Werepere ena rumaape ali lamua palia rabu adami alinumi eda nape ele madaa niti puma piralimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesumi kagaa ele laapo madaa saa pi agale gu-rupa lakalisa: Ali medame mamina kuni kagaa muma abalana mamina madaa rabutalia ya? Dia, gu-rupa rabulaaya rabu kagaa rabuli mamina-mere abalana mamina mariripiaaoma rugula tyabalia. ");
INSERT INTO kjs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Go page ali medame kagaa ipa wain-mi abala yapa yogale pe-para upialia ya? Dia, go-rupa palia-daa yogale podepe taboma kagaa ipa wain popalia. Gore kagaa wain-ri kagaa yapa yogale pe-para yupiape. Go-rupa pea-le abalana kone-para kagaa kone laapo komea-para nasalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wala Pomo mu Pirape Yapi rabu Yesu-para nipuna disaipel alinu-para wit maapu-para pamisimi. Gu-rupa pamualaoma disaipel alinumi wit-na kili keresimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gore keresimi rabu Farisi alinumi Yesu-para agale gu-rupa lakalisimi: Ada. Ake pea-daa Pomo mu Pirape Yapi rabu nena disaipel alinumi rekena agale yokoma kogono peme? ");
INSERT INTO kjs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesumi talo: Devit-mi lisade remaare nadipilisimi? Devit ali medaloma raapu eda dia yoma reame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Reame komisimi raburi ali meda Abaiata-re nipu Gote-na lodo kira-ae ali pirisa. Go ali mudu pirisa rabu Devit-miri lotu ada-para bret puma muma noma ali medaloma page kalisa. Go bret-re Gote-na kalape bret yaa-pulu Gote-na lodo kirae alinumi kama nisimi. Nimimi go agalena re makuaaeme ya? ");
INSERT INTO kjs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesumi talo: Gote-me Pomo mu Pirape Yapi robo wisare enaali raba minalo pisa. Gote-na Pomo mu Pirape Yapi madaa enaali nawarisa. ");
INSERT INTO kjs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni enaali Raapu Pirape Ali yaa-pulu niri Pomo mu Pirape yapina Ali Mudu pi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wala werepe Yesu Juda alinuna lotu ada-para pisa rabu ki meda-nane kome ali meda pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Go-rupa pisare Pomo mu Pirape Yapi yaa-pulu Farisi alinumi Yesu kose lape agale ta pulalo pisimi. Gore Yesumi ki meda-nane kome ali wala ma-epeaaliare kose laalima kone suma pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Go-rupa pisa rabu Yesumi ki meda-nane kome ali-para talo: Rekoma ipu. ");
INSERT INTO kjs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Go-rupa lisa raburi nipumi Farisi ali-para agale lorapisa: Kogonore age epelea? Gore neme enaali raba muma epe-rupa mapiraano epelea pe enaali lu makomaalimi epelea pae? Pomo mu Pirape Yapi Di-ri ali kogono mada pamina? Go agale lorapisa pare Farisi alinumi agale na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nimumi agale pa yola muma pu-para rero pia pisimi-daa Yesumi ralu lisa pare-le wala kodome komisa. Kodo komisa rabu ki meda-nane kome ali-para talo: Ki ridula. Mo alimi nipuna ki ridulasa rabu Yesumi ki ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Go-rupa pisa raburi Farisi alinumi ali mudu Herot-na adami alinu piri-para puma Yesu lu makomaatalo yada robo pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Go-rupa pisa rabu Yesumi nipuna disaipel alinu giyoma wala ipa pagi-nane pirisimi. Go-rupa pisimi raburi su Galili-nane piri enaalimi werepe raita mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Go-rupa page su Jerusalem su-para enaalinu page su Idumea enaalinu page ipa Jordan-na mo-nanena enaalinu page Tair Saidon su laapona piri enaalinu page go su raayona piri enaalinumi Yesuna epe remaa pagoma nipu piri-para kiritaoma ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kiritasimi rabu Yesumi nipuna disaipel alinu-para talo: Enaalinumi naa epa minabaalimi-le ipinu managola salepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesumi enaali adaapuna yaina abala ma-epeaasa-pulu enaali medalomame Yesuna to yogale waraatalo kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Go-rupa pisa rabu koe remo pabo piri alinumi Yesu adomare yala poloma pogola pisimi. Aiya, ne ora Gote-na Si lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Go-rupa lisimi raburi Yesumi talo: Naa bi natapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Go-rupa puma wala go rabu Yesumi su rudune puma nipuna kone suma ali medaloma-para ipulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Go-rupa puma Yesumi nipuna disaipel ali 12-pela mada muma talo: Ni raapu kogono pu epe kagaa agale lakelamina rapaalua. ");
INSERT INTO kjs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nimimi go-rupa palimi rabu nina purimi koe remo pabo piri alinu maepeaalimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nipuna aposel 12-pela nimuna bi gu-rupa maasa: Saimon yapare Yesumi Pita loma bi maasa. ");
INSERT INTO kjs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Medalomare Sebedi-na si Jems-para Jon laapo misa. Yesumi go ameaya Boanerges lo bi maasa. Go bi adaa agale madaare yakili kari tala naaki laapo leme lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yesumi ali medaloma gu-rupa mada misa: Andru-para Filip-para Batolomyu-para Matyu-para Tomas-para Alfius-na si Jems-para Tadius-para Saimon nipu Selot ruru pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Gore namba 12 aliri Judas nipu Keroit su-para pirisa pare go alimiri werepe Yesu tyalalo kawe madi ali pirisa. Go ali raayo Yesumi nipuna disaipel alinu mapiraoma ada wisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Go-rupa pisa rabu enaali ora adaapu wala kiritasimi-pulu Yesu nipuna disaipel alinu page eda nanisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eda nanisa remaa pagisimi rabu Yesuna adami alinumi nipu mula ipisimi. Gore Yesu kone makeyaoma eda nano piru aaya kone suma nipu mula ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Go-rupa pisa rabu rekena agale tisaanumi nimuna Jerusalem su-para giyoma epa talo: Yesuna koauna Belsebul pia-pulu go remonuna purimi remo medaloma mada magiyaalia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Go-rupa lisimi rabu Yesumi nimu yaaloma saa pi agale lakalisa: Satan-me nipuna puma giyape loma yalore mada tea ya? Dia, enaalina lo robaa-para piralia-pulu mada natea. ");
INSERT INTO kjs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gore pa su meda-parare ruru komea piruma rugutalalo paliare go suna puri ora mada dia yoma koyalia. ");
INSERT INTO kjs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Go page ada meda aaraalu rugutalalo puma yada palimiri go aaraaluna puri ora dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Go page Satan-me nipuna surube enaalinu rugutalalo palia yalore epe-rupa mada napiralimi pare puri ora dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yesumi Satan madaa saa pi agale meda gu-rupa lakalisa: Neme puri pale ali kopeme abala rogaaliri nipuna ada-para ele mada paake nalia. ");
INSERT INTO kjs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Go agale pagalepapa. Gote-me enaalina pupitagi mada mea rubalia. Go page enaalinumi ero agale rana adaapu lemere nipumi mada rabuaanaalia. ");
INSERT INTO kjs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Go-rupa pea pare enaalinumi Holi Spirit madaa ero leme-daare Gote-me go koe konere namuma rubalia. Go koe konere ora adaalepe yaa-pulu mo alina go koe kone ade abuna pa saapiralia. ");
INSERT INTO kjs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Enaali medalomame Yesuna koaune remo pia abala lisimi-pulu Yesumi apo agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Go-rupa pisa raburi Yesuna agi amenu ipuma ada perali-para piruma Yesu adola ipisimi-daa agale lo monealisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Agale rapaasimi rabu enaalinumi Yesu piri-para kiritaoma lisimi: Nena agi amenu ada perali pimi lisimi. Ne lamua pulalo epa yaalame lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Go-rupa lisimi rabu Yesumi talo: Nina ama ame balinuri aapi ya? ");
INSERT INTO kjs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Go rabu nipu pereke luma enaalinu adoma agale gu-rupa lakalisa: Go enaalinuri naa ama naa ame balinu pimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Enaali raayome Gote-na kone raitalimi-daare go enaalinu naa ame bali ama aapa pimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wala koro meda Yesumi ipa pagi-nane puma agale pamu moge riasa. Mogeasa rabu enaali adaapu kiritasimi-pulu nipumi ipinu madaa piruma ipa pagi-nane puma agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Enaali kiritasimi rabu Yesumi saa pi agaleme gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Gore wit-na kili poae alimi kili pola pisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Puma poasa rabu wit-na kili medaloma pora kuli madaa lopesa. Go rabu yaanumi epa mea nisimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kili medalomare no kana rote madaa lopesa. Go-rupa pisa rabu rote madaa-nane oge su pobere wisa-pulu leme wagepu opisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wagepu opisa pare naareme adisa rabu pita napuma kaapu lisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kili medalomare repena ketoae-para lopesa pare adaa lisa raburi etoto putimi maregepeaaoma wit-na kili na-elisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kili medalomare epe su pobere madaa lopesa-pulu opoma lisana kili epe-rupa elisa. Wit-na kili elisa rabu medalomare 30-pela elisa. Kili medalomare rikirana sone puma kili 60-pela elisa. Medalomare kili rubi kiraloma ora 100-pela elisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Go-rupa lisa rabu Yesumi talo: Enaali raayome go agalena re makuaalimiri waru pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Go-rupa puma kama raapu pirisa rabu nipuna disaipel alinu raapu pimide enaali medaloma ipuma saa pi agalena re epa agale lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gu-rupa agale lorapisimi rabu Yesumi talo: Nimimiri Gote-na Surube Yapi di madaa kudiri agale pageme. Go-rupa pea pare pape mopare piri enaalinu saa pi agale lakelalo pi. ");
INSERT INTO kjs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Go agalena re adalimi pare nimumi yada namakuaalimi: Enaalinumi adoba pimi pare namakuaalimi. Pagalimi pare namakuaalimi. Gore makuaaoma pupitagi ne kone giyalimiri Gote-me koeyae ele mea rubalia. ");
INSERT INTO kjs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesumi nimu-para talo: Go saa pi agalena re mada namakuaao pimi ya? Napagalimiri saa pi agalenare ake pea-daa makuaa pimi ya? ");
INSERT INTO kjs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Saa pi agalena re gu-rupa lisa: Wit-na li puma poae alimiri nipu Gote-na kagaa agale poaaya. ");
INSERT INTO kjs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gore pora kuli madaa lope wit-ri enaalinumi kagaa agale pagaminalo Satan-me wagepu epa mabebolaalia. ");
INSERT INTO kjs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Go kana rote madaa lope wit-ri enaalinumi kagaa agale pagoma raana komo pimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Raana komeleme pare nimuna lo robaa-para pita napuma pa ogeasi pea. Oge yapi di piruma kagaa agale pageme pare koe eleme nimu tia rabu Gote giyoma wagepu lopeme. ");
INSERT INTO kjs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Repena keto-para lopea wit-ri go enaalinumi kagaa agale pagoma pare nimuna koneme abi ele pema pe kone wimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Go-rupa puma nimu sekere menanu raana komoma ele mulalo peme. Go-rupa pea-pulu nimumi Gote-na kagaa agale lo robaa-para wia pare go koneme maregepeaoma makoyaalia. ");
INSERT INTO kjs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Epe su pobere-para lopesa wit-ri enaalinumi kagaa agale pagoma kili epe-rupa maitimi. Go raburi medalomana kiliri 30-pela elea. Medalomanare kili 60-pela elea pare medalomana kili rubi kiri lina gu-rupa 100-pela elea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesumi nimu agale gu-rupa misa: Enaalinumiri lam kewoma bet rolo-para wimi ya? Bet rolo-para sumare so madaa namaitimi ya? Dia, ora maitimide. ");
INSERT INTO kjs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gore ele pagaa sumare werepe maa walenalo peme. Ele kudiri pu salimiri werepe Gote-na paame ada salia. ");
INSERT INTO kjs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nimimi go agalena re makuaaba piralimiri waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesumi nimu-para wala talo: Pagemede agalere waru surubape. Nimimi agale mogeleme-daare Gote-me mogo kogonona yago wala abutea. Go-rupa puma medaloma page gialia. ");
INSERT INTO kjs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Enaali medalomame ele adaapu su pitimi-daare Gote-me medaloma page maa gialia. Pare enaali raayome ogepu ele su pitimiri oge abuna ora mu pa aalia. ");
INSERT INTO kjs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Go-rupa pisa rabu Yesumi wala talo: Gote-na Surube Yapi Di-ri go piale lo lagialo: Pa ali medame kili su madaa radalisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nipu u paluma rekoma kogono pula pea rabu mo kibita kili opoma adaa yaalia. Go-rupa pea pare go alimi go kili opea-rupa namakuaaya. ");
INSERT INTO kjs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sumi nipuna kili maitaa. Go-rupa puma abala ririnare yosi opoma walare kuli aoma walare nape ele elalia. ");
INSERT INTO kjs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Go-rupa puma go kili elea rabu mo alimi rai kudu muma kogono wagepu warita palia. Gote-na Surube Yapi di enaalinuri apo maapu madaa ele opea-rupa adaapu piralimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Go-rupa pisa raburi nipumi wala talo: Gote-na Surube Yapi Di-ri ele ya? Gote-na Surube Yapi Di-ri ele madaa lano ya? ");
INSERT INTO kjs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gote-na Surube Yapi di gu-rupa wia: Repena yamo mastet-me kili su kamaa radatea rabu nipuna kili ora ogege elesi. ");
INSERT INTO kjs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ogege elesi yapare opomare repena raayo minaabasa. Go repena palaa adaa yaalia-pulu yaanumi ipuma palaana ru-para ada peme. Gote-na Surube Yapi di madaa piri enaalinuri abala ogepu piruma werepe adaapu piralimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesumi saa pi agale go-rupa lakalisa. Nimumi agalena re makuaaeme rabu mogeaata pisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pare Yesumi nimu-para ade abuna saa pi agaleme kama mogealisa. Go-rupa pisa pare nipumi disaipel alinu-para saa pi agalena re lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Go yapi komeana alebo raburi Yesumi nimu-para talo: Abiri ipa le mone pane ba. ");
INSERT INTO kjs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Go-rupa lisa raburi Yesu ipinu ru-nane abala pirina disaipel alinu page epa pirisimi. Nimu pirisimi rabu ipinu medaloma page go-para wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Go-rupa puma ipa le madaa abala penaalomare po rilipu ipuma ipa kali lisa rabu ipinu-para ipa epa pabolalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Go rabu Yesumi ipinu koau-nane piruma kada suma u palisa. U palisa raburi nimumi nipu marekaaoma lisimina: Aya Tisaa, naa komalima-le kone nasale ya? ");
INSERT INTO kjs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Go-rupa lisimi rabu Yesumi rekoma po rilipu-para ipa laapo agale gu-rupa lakalisa: Mada-le lora. Go-rupa lisa rabu po rilipu loraoma ipa lewa napi pa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Go-rupa pisa raburi Yesumi nimu-para talo: Ake pea-daa paala komeleme ya? Abi page epe agalere nimina lo robaa-para waru nasame ya? ");
INSERT INTO kjs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Go-rupa lisa raburi nimu paala komoma lisimina agale lo pisimi: Go aliri aapi yapae lo pisimi. Go alina agalere po rilipu-para ipa le laapome pagea lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Go-rupa pisa raburi nimu ipa le Gerasa-repale mone pane pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mone pane opapasimi raburi Yesu ipinu giyoma popesa. Go rabu koe remo pabo piri ali meda tapa apedaa giyoma Yesu wagepu madaaoma ipisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Go remo pabo piri ali nipu tapa-na u palisa rabu enaalinumi nipu puri pale kopeme page mada na-adiasimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Go ali nipu ade abuna hankap kope laapo rugulu rubebe pala pisa-pulu mada na-adiasimi. Go-rupa pisa-pulu nimumi nipu mada kuma napeme. ");
INSERT INTO kjs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ade abuna mo ali tapa kamaa-para kari laapona pamisa. Pamisa raburi nipu eru loma kaname nipuna to mea rugulala pisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nipumi Yesu adisa rabu Yesu piri-para wagepu ipisa. Go rabu mo alimi Yesu madaa paala komoma rumu pege puma epa pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rumu pege pisa rabu puri paloma gu-rupa yalisa: Ne ora Mudu Gote-na Si Yesu yade. Neme ni-para ake pali ya? Gote-na bi madaa lalo-pulu neme ni giyoma pu. ");
INSERT INTO kjs_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gore Yesu abala nipu koe remonu nipu giyoma pope lo lakalisa-pulu apo agale lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Go-rupa lisa raburi Yesumi nipu-para wala talo: Nena biri aapi ya loma agale lorapisa. Koe remo aaya alimi lakalisa: Remo adaapu ni-para kodobaeme-pulu nina biri ruru yade. ");
INSERT INTO kjs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Go rabu mo alimi Yesu-para puri paloma kogelisa: Naa raayo pora kimisu-para naralu tape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Go-rupa pisa raburi menanumi rudu-nini e poalaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Koe remonumi Yesu-para talo: Naa mogo menanu-para mea rapaa-le nimuna lo robaa-para pomono gu-rupa kogesimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gu-rupa kogesimi raburi Yesumi nimu mea rapasa. Mea rapasa rabu koe remonu mo ali giyoma menana lo robaa-para puma kodobasimi. Go rabu mena-repaame raita-para kilipima ipa-para puma komisimi. Menanuri ora 2000-rupa komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gore mena puni alinumi go ele adoma adare-para pa su meda-nane pogola puma puaa lakalisimi. Lakalisimi raburi enaali raayo ipuma epa adisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nimu Yesu piri-para ipuma abala koe remo piri ali epa adisimi. Remo pirisade aliri nipu piruma mamina yamoma epe kone wisa. Mo ali adisimi rabu paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Go-rupa puma enaalinumi koe remo mena madaa puma kodobataina adisimi-pulu remaa pamu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Go-rupa pisa rabu nimumi Yesu-para talo: Naana su giyoma su meda-para poape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ipinu madaa pirulalo pisa rabu mo remo piri alimi ni page saana bana lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Go-rupa lisa pare Yesumi dia loma nena ruru piri-para puma ni madaa Ali Mudumi epe kogono palo puma laketapape lisa. Gote-me ni kodome komalo puma laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Go-rupa pisa raburi abala remo piri alimi Dekapolis su-para puma Yesuna kogono painalo lakalisa. Enaali raayome pagoma ora pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesumi ipinu madaa piruma ipa mone pane wala kenaasa rabu enaali kiritasimi. Kiritasimi rabu Yesu ipa le pagi-nane pisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Go-rupa pisa rabu ali meda nipuna bi Jairasi go alimi Yesu piri-para ipisa. Nipu mo Juda alinuna lotu adana ali mudu pirisa. Nipu Yesu adisa raburi Yesuna kibu re-para ipuma rumu pege puma agale mulalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rumu pege pisa rabu nipu talo: Naa oge nogo ora le kadupialia. Gore ne epape. Nipuna to madaa kimi waraaripu rabu nipuna yaina perekeasa. ");
INSERT INTO kjs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Go-rupa lisa raburi Yesu nipu raapu pisipi. Enaali adaapumi nipu raita maa pisimi rabu Yesu pamuape pora rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pora pisimi raburi ena meda nipuna yaapi yaina maali 12-pela madu lobasupaasa. ");
INSERT INTO kjs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mo ename dokta-nuna ada puma nipuna to mada radaa pina pisa pare namaperekeaasimi. Dia, pare go enana yaina adaa ya-maoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Go ena Yesuna bi pagisa-pulu enaali pabo kiritasimi-para ipuma Yesuna koau-nane mamina waraalalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ename mamina waraalua kone gu-rupa misa: Go alina mamina waraalua rabu ni mada maperekealia kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Go-rupa puma waraasa raburi nipuna yapi kaapu lisa rabu nipuna lo robaa-para epe-rupa pi kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mo ename waraasa raburi Yesuna puri medaloma ma-puaasa-daa koneme adisa. Nipu perekea luma enaalinu agale gu-rupa misa: Nina mamina aapimi waraaripa ya? ");
INSERT INTO kjs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Go agale mulalo pisa raburi Yesuna disaipel alinumi gu-rupa lisimi: Gore enaali adaapu reka pirina yapare naa mamina aapimi waraaripa pe piri ake pea-daa le? ");
INSERT INTO kjs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pare Yesumi pereke luma adobaasa. ");
INSERT INTO kjs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Go-rupa pisa rabu enana kone-para paalame komisa. Paala komoma pururu puma Yesuna kibu-para epa rumu kobopu pirisa. Go ename yala komoma neme pawade-le neme ni ma-epeaanalo pawa lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Go-rupa pisa raburi Yesumi mo ena gu-rupa lakalisa: Aina, neme Gote madaa kone rulaaripi-pulu ne epe-rupa pi-le abi pawa pope. Nena yaina dia yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesumi go-rupa lalaina Jairas-na mea rapaae ali medaloma go Juda ali muduna ada giyoma ipuma talo: Nena wane le kadupiaade. Nere ake pea-daa tisaa mea epali ya? ");
INSERT INTO kjs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Go-rupa lisimi pare Yesumi apo agale giyoma Juda alinuna ali mudu-para gu-rupa lisa: Paala nakomape. Dia, kone rulape. ");
INSERT INTO kjs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Go-rupa pisa raburi Yesumi Pita-para Jems-para nipuna ame Jon-para medaa-para baina lisa. Pirisimi raburi Yesumi talo: Enaali medaloma ada-para naipulupape lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nimu apo Ali Mudu-na ada re-para ipisimi rabu Yesumi enaali raayo puri paloma re lo pirina adisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ada-para pisa raburi enaali lakeloma talo: Ake pea-daa re lo pimi? Go nogo na-le kadupita pare pa u paitana lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Go-rupa lisa raburi nimumi nogo le kadupalisa-daa makuaasimi-pulu giri laasimi. Giri laasimi raburi enaalinu kamaa ralu lisa. Yesu-para mo nogona agi aaraa lapo-para disaipel alinu-para nimu raayo nogona ro aaya ru-nane pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesumi oge nogona ki muma Talita Kumi lisa. Go agalere gu-rupa lisa: Oge nogo abi rekoma lisa. ");
INSERT INTO kjs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Go-rupa lisa raburi go nogo wagepu rekoma pamisa. Go nogona maali 12-pela pirisa. Mo nogo pamisa raburi enaalinumi paala komoma kidipaa ragi lu pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesumi nimu-para talo: Enaali medaloma napuma lakelapa. Go nogo eda katepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu go su giyoma nipuna adare-para pisa. Pisa rabu nipuna disaipel alinumi nipu raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Go-rupa pisa raburi Yesu Pomo mu Pirape Yapi di rabu nipumi Juda alinuna lotu ada agale mogeaala pisa. Mogealisa rabu enaalimi pagoma pogolasaoma gu-rupa lisimi: Go alina kone ali-para misa? Ake puma go adaa puri misa? Puri pale kogono medaloma nipuna purimi wariala. ");
INSERT INTO kjs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Go aliri kamda kogono pi ali piruma nipuri Maria-na si yade. Go page Jems-para Josep-para Juda-para Saimon-para go alinu nipuna amenu yade. Nipuna balinu naa komea-para pima lisimi. Go-rupa lisimi rabu nimimi Yesu madaa lo robaa-para koe kone wisimi. Go-rupa puma nimumi Yesu giyasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Go-rupa pirisimi rabu Yesumi nimu-para talo: Gote-na agale lakale aliri su raayo-para enaalimi nipuna bi minasaaeme pare nipuna adare-para nipuna ruru-para nipuna aaraalu-para nimumi nipuna bi naminasaaeme. ");
INSERT INTO kjs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Go-rupa pirisimi rabu Yesumi puri pale kogono go-para mada nawarisa pare nipumi enaalina yaina komea komea lo ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu enaalinuna pu robaa-para kone waru narulasimi-pulu Yesu ora paalame komisa. Go-rupa puma Yesu adare raayo-para epe agale mogealalo pamisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Go-rupa pisa raburi Yesumi aposel kogono ali 12-pela rapasa. ");
INSERT INTO kjs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Go-rupa pisa rabu laapo laapo lo muma maa rapasa. Yesumi nipuna disaipel alinu puri kaloma koe remo mea rubaainalo pisa. Yesumi agale gu-rupa lakalisa: Pora kimisu-para palimi rabu ele namealepape pare rimaapu ripinuma pora pamea pulupape. Sapi-para nu-para kana pabe paus-para raayo namuma pulupape lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nimimi age ada suma palimi pare mamina komea yamalepape. ");
INSERT INTO kjs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesumi page nimu-para gu-rupa lakalisa: Ada adare-para puma kogono palimi raburi ada komea-para piruma eda namina. Adare rado-para palimi rabu go ada nagiyalepape. ");
INSERT INTO kjs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ada adare-para palimi rabu go enaalinumi nimi giyoma epe agale napagalimi-daare nimuna koe ele makuaamina nimina age madaa ae kege nimuna ada kunuma salepape. ");
INSERT INTO kjs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Go-rupa lisa raburi disaipel alinumi puma enaalinu lakeloma talo: Koe kone rabualepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Disaipel alinumi koe remo pabo piri ali ma-epeaaoma yaina pi enaalina kalu madaa wabola suma maepeaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Go-rupa pirisimi rabu gavman-na ali mudu Herot-me disaipel alinuna kogono madaa remaa pagisa. Yesuna bi sogo-nane puala nogo-nane puala pisa-pulu pagisa. Go-rupa pisa raburi enaali medalomame talo: Jon Baptais-ri tapa giyoma wala rekisa-pulu go puri muma apo kogono pamu pu aaya lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Go-rupa lisimi pare enaali medalomame talo: Go aliri nipuna bi Elaija lisimi. Medalomame page talo: Nipumi Gote-na agale lakale ali abalade pirisa yade lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Go-rupa lisimi pare Herot-me pagoma gu-rupa lisa: Neme Jon-na kalu rugulisua pare wala rekaade kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Abaladere Herot-me nipuna were Herodias-na agale pagoma Jon kopeme adiala karapo ada mapaitaasa. Go ali mudumiri nipuna ame Filip-na were Herodias paake yoloma pirisipi. ");
INSERT INTO kjs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Go kone wisa-pulu Jon-me ade abuna Herot gu-rupa lakalisa: Rekena wia-le nena amena were nayoloma pa lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Go-rupa lisa raburi Herot-na wereme Jon-para koe kone suma talalo pisa pare mada dia. ");
INSERT INTO kjs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Go-rupa pisa pare Jon epe kone su redepo le ali pirisa-pulu Herot-me nipu madaa paala komoma karapo ada epe-rupa surubisa. Herot-me Jon-na agale pagisa rabu nipu kone laapo wisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Go-rupa pisa pare were Herodias-me kone meda wisa. Nipuna aali Herot-na agimi nipu madi di ipisa rabu eda yawo kiritasimi. Ora nipuna gavman alinu-para soldia alinu-para Galili suna ali mudunu raayo epa kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Go-rupa pisa raburi Herodias-na wane ipuma Herot-na yaa le alinu-para epa pirina yalisa pabesa rabu raana komisimi. Go-rupa pisimi-pulu Herot ali mudu yaa-pulu nogo-para talo: Nena kone ali ya? Agale lainalo mada gialua. ");
INSERT INTO kjs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Go-rupa pisa rabu Herot-me nogo-para makuaa loma gu-rupa lakalisa: Neme agale meali rabu gialua. Nina adaa su rikirana rumaaoma ele adaapu gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Go-rupa lisa raburi nogome agi piri puma talo: Ake lano ya? Agimi nogo lakeloma talo: Jon-re kalu-ipa mi ali yade nipuna kalu rugulu meaina. ");
INSERT INTO kjs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Go-rupa pisa rabu nogome ali mudu piri-para wagepu puma agale mulalo gu-rupa lisa: Neme Jon-na kalu plet madaa suma giaina. ");
INSERT INTO kjs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Go-rupa lisa raburi ali mudumi Jon kodome komisa. Yapare ada makuaae agale lakalisa-pulu nipuna wamo pi alinu piruma ademede-pulu neme agale nogo-para nagiyalua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Go-rupa pisa raburi ali mudumi soldia-para talo: Jon-na kalu pua rugutapa lisa. Gore mo polis nipu karapo ada-para puma Jon-na kalu rugitisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Rugulisa rabu plet madaa suma wane kalisa rabu wanemere nipuna agi kalisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Go-rupa pisa raburi disaipel alinumi pagoma ipuma Jon-na ro ria puma rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Go-rupa pumare disaipel alinumi Yesu piri-para wala ipuma Herot-na kogono pisa-rupa agale epa lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Go rabu enaali adaapu epala puala pisimi-pulu Yesu-para disaipel alinu page eda nanisimi. Go-rupa pea-le Yesumi nipuna disaipel ali-para talo: Go su giyoma enaali napiri su-para puma pomo mu mada piramina lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Go-rupa pisa rabu nimu ipinu madaa piruma enaali napiri su-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yapare pisimi raburi enaali adaapumi nimu waru adisimi. Go-rupa puma enaalinumi adarenu giyoma pora pagina pisimi. Go-rupa puma go enaalinumi Yesuna ipinu madaa abala puma nimuna piri-para abala epa kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Go-rupa pisa raburi Yesumi ipinu giyoma enaali adaapu adisa rabu nipuna pu robaa-para kodome komisa. Go enaalinu ora sipsip mena-rupa pa pirina yapare nimuna puni alinu napimi-daa kodome komisa. Go-rupa pea-le go rabu nipumi agale adaapu mogealisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gore ora alebo rabu Yesuna disaipel alinumi ipuma nipu-para talo: Go su-para enaali ora dia lea. ");
INSERT INTO kjs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Abi ribaa lea-le enaalinu ada rapaape. Go-rupa puma nimuna eda kabola penaalo rapaape. ");
INSERT INTO kjs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Go-rupa lisimi pare Yesumi talo: Nimina nimu eda katepape. Go-rupa lisa pare nimumi Yesu-para talo: Naame bret kabolalo palimare kana 800 kina mada kaboma mea kalema ya? ");
INSERT INTO kjs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Go-rupa lisimi rabu Yesumi nimu-para talo: Nimina bret akepu raapu ya? Puma adalepa. Nimumi adoma gu-rupa lisimi: Bret ipa supu-para wena laapo wia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Go-rupa pirisimi rabu Yesumi talo: Nimu go-pare rilipu pole madaa mapiraalepape. ");
INSERT INTO kjs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yesumi gu-rupa lisa raburi go-para ena 100-pela kiritaoma pitaa meda-para enaali gu-rupa 50-pela kiritaoma laaoma pu pirisimi. Gore rado rado raayo gu-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Go-rupa pisa rabu Yesumi bret supu-para wena laapo muma yaa-para adasaaoma Gote-para ora pili lisa. Go-rupa loma bret piribima disaipel alinumi enaalinu rumaainalo kalisa. Go wena laapo page Yesumi enaali rumaainalo kalisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Go-rupa pisa rabu nimumi ora eda mada no pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No kiritinaloma disaipel alinumi eda purupi yarepema basket 12-pela madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Go-rupa pisa rabu enaali adaapu gu-rupa 5000-pela eda nisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Go-rupa pisa raburi Yesumi nipuna disaipel ali-para talo: Ipinu madaa piralepape. Nimi ipa mone pane Betsaida su abala pulupape. Gore disaipel alinu nimu penaaloma Yesumi enaali raayo mea rapaatalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesumi enaali pawa pulupape lo lakeloma so rudu madaa beten tea pisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Go-rupa puma ora ribaa yapaasa raburi nimu ipinu madaa pirinaloma Yesu agu raapo so rudune pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Go raburi disaipel alinumi ipinu yola muma ipa rupirari poma mu pirisimi rabu Yesumi nimu adisa. Po rilipu nimu pulalo pisimi-nane ipisa-pulu pomo mu pirisimi. Gore yapi pode talo pisa raburi Yesu nimu piri-para ipa koauna pamisa. Yesuna konere nimuna ipinu giyoma mogo-nane pa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Go-rupa pisa pare ipa koau-nane pamualaina nimumi Yesu remo meda kone suma pogolasaoma yalaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yalaasimi rabu nimumi adoma paala komisimi. Paala komisimi-pulu nipumi nimu-para talo: Paala nakomalepape. Ni Yesu yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Go-rupa pisa raburi Yesu nimuna ipinu ru-nane pirina po rilipu loraasa. Go-rupa pisa raburi nimu pogolasaoma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gore disaipel alinumi bret kogonona re namakuaasimi. Dia, nimuna lo robaa-para go konena re ora namakuaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Go-rupa pisa raburi nimu ipa mone pane puma Genesaret su opapaoma ipinu adibasimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nimumi ipinu giyasimi rabu enaalinumi Yesuna le-aga waru adisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Go rabu nimu su raayona wagepu pisimi. Wala ipisimi raburi Yesu piri-para yaina kome enaalinu reke madaa ria ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Go-rupa puma werepe Yesu ora oge su-paranu adare-paranu emaapu-paranu go su raayo-para pamisa rabu enaalinumi yaina kome enaali kiritape su maket kamaa ria ipisimi. Go-rupa puma nimumi Yesuna mamina kuni madaa waraamonalo kogelisimi. Gu-rupa waraainaloma nimuna yaina raayo ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Go-rupa pisa raburi Farisi alinu rekena agale tisaa-nu page Jerusalem su-para giyoma Yesu piri kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kiritasimi raburi disaipel ali medaloma eda nolalo piruma nimuna ki koto pimi nisimi-daa kiritape alinumi adoba pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gore Farisi alinu page Juda alinu page eda piruma neme rabu ki abala radepelisimi. Nimuna kasuana kone mogealalo ki radepealeme. ");
INSERT INTO kjs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Go page go Farisi alinumi maket-para kabeme eda abala radepealeme. Go-rupa puma nimuna pora meda rado rado page ralisimi. Kone medare nimumi kopo-nupara plet-nupara kap-nupara raayona pa radepealeme. ");
INSERT INTO kjs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Go-rupa pea-le Farisi ali page rekena agale tisaa-nu page Yesu agale mulalo pirisimi: Ake pea-daa nena disaipel alinumi nimumi kasuana kone namogeleme pae? Nimuna ki naradepeaoma koto pimi eda neme lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesumi nimu-para talo: Nimi ora makirae alinu pimi. Go madaare Gote-na agale lakale ali Aisaia-me pepa madaa gu-rupa lisa: Go enaalinuna agalemere nina bi minasaaeme pare nimuna lo robaa-para ni madaa kone nasalimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Go enaalinumi pa alinuna kone mogeleme pare ora Gote-na rekena agale pa leme. Go-rupa leme-pulu nimumi naa bi mada naminasaaeme. Yesumi Aisaia-na agale gu-rupa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Go-rupa puma Yesumi nimu-para talo: Nimi Gote-na rekena agale giyoma yapare kasuana kone mogeleme. ");
INSERT INTO kjs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesumi nimu-para talo: Nimina kone giyalalo peme rabu kudiri kone suma Gote-na rekena agale giyeme. ");
INSERT INTO kjs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses-me abala gu-rupa lisa: Nimina agi aaraa laapona agale pagoma bi minasaatepape lisa. Enaali raayome agi aaraa-para koe agale leme-daare nimu ora lu makomalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Moses-me gu-rupa lisa pare nimimi gu-rupa lisimi: Enaali raayome agi aaraanu-para talo: Kana neme saabaayo-airi Gote madaa imaa keae loma saato. Go-rupa pea-le ama aapa naraba mealua leme. ");
INSERT INTO kjs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Go-rupa peme-le nimimi nimina kasuanuna agale pagoma raleme raburi Gote-na agale yokeme. Go-rupa pumare nimimi kogono go-rupa adaapu pa peme lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Go-rupa pisa rabu Yesumi enaali adaapu wala yaaloma saa pi agaleme talo: Nimi raayo pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nimimi epe eda nalimi rabu go edame nimi-daa mada nabebolalia. Dia, pare nimina lo robaa-para wi koneme nimi makoyaalia. ");
INSERT INTO kjs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Enaali raayome go agalena re makuaaba piralimiri waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Go-rupa pisa raburi Yesumi enaali giyoma ada-para epenaloma disaipel alinumi saa pi agalena re madaa agale mulalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Go-rupa puma Yesumi nimu-para talo: Nimimi nimu-rupa piruma kone nasalimi. Nimi ora pagalepape. Enaalinumi eda nalimi-daare go nape eleme nimu mada nama-koeyaalia. ");
INSERT INTO kjs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dia-le go edare enaalina kone-para nasalia pare lo-pu aaya-daa wi tapa-para pea lisa. Yesu go-rupa lisa rabu pa nape eda raayore ora epe-rupa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesumi wala talo: Enaalinuna lo robaa-para wi koneme pupitagi manaalia. ");
INSERT INTO kjs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gore enaalinuna lo robaa-para wi kone suma gu-rupa peme: Ena paake yolape-para paake nape kone-para ali lu makomaape kone suma peme. ");
INSERT INTO kjs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Go page alinumi ena yoke meape kone-para ele madaa epame komape kone-para koeyae pape kone raayo peme. Go page makirae kone-para koe yalame komape kone-para koe kudipa kone-para enaalinuna bi rabuaniaape kone-para ali tyape kone-para pa makeae kone page ora go raayo lo robaa-para kone wimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Go koe kone raayore kone-para suma kana-nane enaali makoyaaya. Yapare eda nape eleme epe-aimi napea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Go-rupa puma Yesu go su giyoma kimisu Tair adare re-para pisa. Go-rupa pisa raburi nipu ada meda-para kodobaoma yapare enaalinu nalakalisa. Nalakalisa pare nimuna pa makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gore koe remo piri nogo medana agimi Yesu pia remaa pagisa. Go-rupa puma nipu Yesuna kibu re-para ipuma rumu pege puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mogo nogona agiri Siria adare Fonisia ename madisa. Gore nipu Yesumi mo nogo-para pia remo rakepeainalo kogelisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Go-rupa pisa raburi Yesumi Juda alinuna pora madaa kone suma saa pi agaleme gu-rupa lisa: Gore abala naame nogo naaki eda kalamina. Nogo naakina eda muma yana kalemare epe kone-daa dia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yapare mo ename Yesu gu-rupa lakalisa: Ali Mudu, ora lae pare reke rolo-para piri yananumi nogo naakina eda purupi neme. ");
INSERT INTO kjs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesumi nipu-para talo: Gu-rupa lae-le nena ada-para wala pu. Koe remore nena nogo giyoma puade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Go-rupa puma no agimi ada puma ru-nane kodobaoma nipuna nogo reke madaa epe-rupa pirina adisa. Go nogo-para rakepeaoma koe remo pane pisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Go-rupa pisa raburi Yesu Tair su-nane giyoma ipa Galili su-para wala pisa. Pamisa rabu nipu adaa su robo Saidon ru-nane pamuma puma adare Dekapolis-para page pisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Go-rupa pisa raburi enaali medalomame kale poma agale maare ali Yesu piri-para maa ipisimi. Mea ipuma Yesumi go yaina pi alina to madaa waraainalo kogelisimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesumi mo ali muma enaali napiri su-para maa puma kimi kale-para suma supi roma mo alina eke waraasa. ");
INSERT INTO kjs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Waraasa rabu Yesu yaa-para adasaaoma lisana kodome komoma komo misa. Go rabu mo ali-para talo: Lobape lisa. Yapare Yesuna adaa agaleme: Efata lisa. ");
INSERT INTO kjs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Go-rupa lisa raburi mo alina kale malobaaoma eke ma-epeaaoma agale epe-rupa malaasa. ");
INSERT INTO kjs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Go-rupa pisa raburi Yesumi enaalinu-para agale natapape lisa. Yapare natapape lo lakalisa raburi nimumi puri paboma lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Apo remaa pagisimi enaalinumi Yesumi go-rupa pisa-daa ora paalame komoma kidipaa raki luma talo: Mogo alimi ele raayo epe-rupa pea. Kale poae ali page agale maare ali page nipumi epe-rupa maperekeaaya lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gore werepe enaali adaapu epa kiritasimi. Werepe nimuna eda dia lisa rabu Yesumi nipuna disaipel alinu-para yaaloma talo: ");
INSERT INTO kjs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Go enaalinu yapi repome ni raapu piraoma pare eda naname-pulu ni kodome komalo. ");
INSERT INTO kjs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Neme nimuna ada penaatoare reae puma pora pagina lopalimi. Enaali medalomare pora adaalu-para epame. ");
INSERT INTO kjs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nipuna disaipel alinumi nipu-para talo: Gore go suri enaali napimi-le naa ali-para puma bret kaboma nimu rumaalima ya? ");
INSERT INTO kjs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesumi nimu-para talo: Nimina bret akepu raapu wia? Nimumi talo: Ki medane luma medane laapo wia lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Go rabu Yesumi enaali raayo su madaa mapiraasa. Go-rupa puma Yesumi bret ki medane luma medane laapo muma Gote-para ora pili loma lisana piribima nipuna disaipel alinu kalisa. Yesumi kalenaloma nimumi mumare enaali rumaaoma katea pirisimi. Go-rupa puma disaipel alinumi rumaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Go-rupa pirisimi raburi disaipel alinuna wena ogepusi page madu wisimi. Go page Yesumi muma lisana ora pili loma enaali-para rumaalepape lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Go-rupa pisa raburi nimu eda ora waru no pirisimi. Eda nabenaloma purupina basket ki medane luma medane laapo yarepema madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Go raburi enaalinuri 4000 pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Go-rupa puma werepe Yesumi nimu rapasa. Pirisimi raburi Yesu page nipuna disaipel alinu page ipinu madaa piruma Dalmanuta su robo ru-nane pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Go-para pirina Farisi alinu medalomame Yesu piri-para ipuma arere pirisimi. Nimumi Yesu ko tulalo ipuma napi kogono mada pali yapalo lakalisimi. Go adalimare Gote-me puri ne go aaya-daa makuaalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Go-rupa lisimi pare Yesumi nipuna pu lome komo mu rubuma gu-rupa lisa: Ake pea-daa go komea rabu enaalinumi napi kogono asa peme pae? Ni ora talo: Nimumi ora mada na-adalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Go-rupa puma nipumi go enaalinu giyoma ipinu madaa piruma disaipel alinu raapu ipa mone pane kenaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gore ipa mone pane pirisimi pare disaipel alinumi kone ruguloma bret namuma wisimi. Go kone ruguloma nimumi bret komea kama ipinu-para mea wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Go rabu Yesumi saa pi agaleme nimu-para talo: Pagalepape. Farisi alinu-para Herot-para nimuna bret ma-adaa sape yis waru adalepape. ");
INSERT INTO kjs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesumi go-rupa lisa raburi nimumi gu-rupa lala pirisimi: Naa bret nasalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Go-rupa pisa raburi Yesumi nimu adoma muma nimu-para talo: Naa bret nasalima leme-le ake pea-daa leme pae? Nimi abi namakuaaeme? Nimina kone nasalimi? ");
INSERT INTO kjs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nimina lemere na-ademe? Nimina kaleme agale napageme? Gore nimimi kone rugulaeme pae? ");
INSERT INTO kjs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Neme bret supu piribima enaali adaapu gu-rupa 5000-pela giawade raburi nu eda purapina nu akepu raapu yarepema madu wisimi ya? Nimumi 12-pela lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Go-rupa lisimi rabu Yesumi wala talo: Go page enaali adaapu gu-rupa 4000-pela bret ki medane luma medane laapo giawade raburi nu akepu raapu yarepema madu wisimi ya? Go rabu nimumi ki medane luma medane laapo madu wisima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Go-rupa lisimi raburi Yesumi nimu lakalisa: Go-rupa pawade pare abiri namakuaaeme? ");
INSERT INTO kjs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Go-rupa puma nimu Betsaida su-para pirisimi. Go rabu enaali medaloma le rubu pi ali Yesu piri-para mea ipuma talo: Go ali waraape lo kogelisimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Go-rupa puma Yesumi le rubu pi alina ki muma ada pera-le lamua pisa. Go-rupa pisa raburi Yesumi mo alina le-para supi raa rakisama ki tone waraaoma agale lorapisa: Ne ali ade pae? ");
INSERT INTO kjs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Go-rupa lisa raburi mo alimi adoma talo: Neme ali adalo pare nimu pamualeme raburi repena nona pea. ");
INSERT INTO kjs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Go-rupa lisa rabu Yesumi nipuna le wala waraainaloma waru perekelema adisa. Adisa raburi mo ali page ele raayo pa epe-rupa adisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Go-rupa puma Yesumi mo ali penalo rapaoma talo: Nena ada pumare adare-para wala napope lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Go-rupa puma Yesu nipuna disaipel alinu raapu Sisaria Filipai su laapo-nane pamisimi. Pamisimi raburi Yesumi nipuna disaipel alinu-para agale gu-rupa misa: Enaalinumi ni aapi leme? ");
INSERT INTO kjs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nimumi nipu-para talo: Gore enaali medalomame nere Jon Baptais leme. Medalomame nere Gote-na agale lakale ali Elaija leme. Medalomame nere Gote-na agale lakale ali meda leme. ");
INSERT INTO kjs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Go-rupa puma Yesumi nimu-para wala talo: Ora lale pare nimimi ni aapi ake kone wimi? Pita-me nipu-para talo: Ne ora enaali Raapu Pirape alina Si Keriso yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Go-rupa lisa raburi Yesumi nimu-para enaali raayo nalaketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Go-rupa pisa raburi Yesumi nimu gu-rupa mogealisa: Ni enaali Raapu Pirape alina Si radaa waru no pitua. Gore kone makuaae alinumi page Gote-na lodo kira ali mudunu page rekena agale tisaa-nu page nimu raayome ni giyalimi. Nimumi ni Yesu lu makomalimi pare yapi repo dia naloma wala rekalua. Yesumi agale gu-rupa mogealisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesumi nimu-para apo agalena re waru lakalisa. Go-rupa lisa rabu Pita-me Yesu-para talo: Ne timi agale gu-rupa nalape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Go-rupa lisa pare Yesumi perekea luma nipuna disaipel alinu adisa rabu Pita-para rono pagoma talo: Ne Satan-na kone wia-le nemere ni giyape. Ne Gote-na kone nasali pare ne su kamaanuna kone wi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Go-rupa pumare Yesumi enaalinu page disaipel alinu page yaaloma lakalisa: Werepere enaali raayome ni raita mea epalimi-daare repena polopeana kedaa ruma nimuna kone giyoma ni raita mea ipulupape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Enaali raayome nimuna yogale surubalimi-daare ade abuna alupalimi. Pare enaali raayome ni madaa page epe agale madaa nimuna kone giyalimi-daare ade abuna piralimi. ");
INSERT INTO kjs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pa ali medame su raayona kana yoto mealia pare nipuna kone wasa giyaliare go kone epelea? Dia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Go-rupa puma go alimi kone wasa ora wala mada mealia ya? Mada dia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Go-rupa pea-le abi go pupitagi no Gote giyape di rabu enaali raayome ni-para epe agale-para koau rilalimi-daare neme nimu page giyalua. Werepere ni enaali Raapu Pirape Aliri epe ensel-nupara Aapana epe puri raapu epalua-le go rabu giyalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Go-rupa puma Yesumi nipuna disaipel alinu-para enaalinu medaloma-para page talo: Neme nimi-para ora talo: Go-para pimi enaali medalomame nakomalimi pare nimumi abala Gote-na Surube Yapi-na puri mea epaliade adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wala yapi 6-pela dia naloma Yesu-para Pita-para Jems-para Jon-para nimu komea-para so rudu madaa pirisimi. Gore Yesumi to rado aoma pisa-daa adisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Go-rupa pirisimi raburi nipuna mamina-nu yaako puma lepo lepo pisa. Go yaako pu lisa rabu mamina raayo yaako pisa-rupadaa ali meda mada napia-rupa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Go-rupa pisa rabu Elaija page Moses page ipuma Yesu raapu agale epa lisipi. ");
INSERT INTO kjs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Go-rupa puma Pita-me Yesu-para talo: Tisaa, naa go-para pimare epelea. Pokaalo ada repo pamina. Medare nena medare Moses-na medare Elija-na pamina. ");
INSERT INTO kjs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gore Pita nimu page paala komoma age lema pae kone wisimi-pulu apo agale lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Go rabu mole medame naare makudinae ru-para pirisimi. Go yaa-para mole raapu agale gu-rupa pagisimi: Gore ora nina epe Si. Neme nipu madaa pedo pi. Nipuna agale pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Go-rupa lisa raburi disaipel alinumi wagepu pereke luma adisimi pare Yesu komea adisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nimu kari kilipisimi raburi Yesumi nimu-para talo: Nimimi abi adamede madaare enaali remaa natapape. Ni enaali Raapu Pirape Siri abala tapa-para madaa rekalua. ");
INSERT INTO kjs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nimumi nipuna agale pagisimi pare nimuna agale gu-rupa lo pirisimi: Go agale ni tapa-para rekalua agalere ake agale ya? ");
INSERT INTO kjs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Go-rupa puma nimumi Yesu-para talo: Rekena agale tisaanumi gu-rupa leme: Elija-me ele kiritao suma abala epena leme. Go agalena re ali ya? ");
INSERT INTO kjs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Go-rupa lisimi raburi Yesumi nimu-para talo: Elija-re ele raayo ameke pulalo abala epalia. Go-rupa pea pare Gote-na buk madaare enaali Raapu Pirape alina Si niri radaa abala waru no pitua. Go-rupa puma enaalinumi ni giyalimi. Go agalena re makuaaeme? ");
INSERT INTO kjs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yapare neme nimi lagialo: Elaija abala ipisa pare go rabu enaalinumi nimuna koe kone suma pirisimide lisa. Gote-na buk madaare Elaija tyalalo peme lagisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gore Yesu-para disaipel alinu ipa repo wala disaipel ali medaloma raapu kiritaoma enaali adaapu adisimi. Go rabu disaipel ali medalomame rekena agale tisaanu-para agale lape arere pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Go pirisimi enaalinumi Yesu adoma paala komomare wagepu ipuma ki kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kalisimi raburi Yesumi nimu-para agale gu-rupa lisa: Ake madaa arere pu pimi? ");
INSERT INTO kjs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Go agale lorapisa rabu go enaali adaapu rikirana pirisa alimi talo: Tisaa, nina naaki ne piri-para ma epawa. Go naaki madaa remo pia-pulu agale maarea. ");
INSERT INTO kjs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Remome naaki yoloma ria pea rabu malopaaoma agale yaruma rako supi madu to puri palea lisa. Neme disaipel ali-para ma-epaape lawade pare nimu mada dia lamede. ");
INSERT INTO kjs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Go-rupa lisa raburi Yesumi enaalinu-para talo: Nimiri epe agale yoke enaali pimi. Ni nimi-para koro di akepu raapu pa pitua ya? Neme nimi-para rana akepu raapu kogono waatoa ya? Go naaki mea ipu. ");
INSERT INTO kjs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Go lakenaloma naaki Yesu piri mea ipisimi. Remome Yesu adisa raburi naaki mapururu mapaaoma naaki su kamaa malopaasa. Go-rupa puma perekea pereke yalalaaoma rako supi raa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Go pisa raburi Yesumi go naakina aaraa-para talo: Go yaina maali akepu raapu wia? Aaraame talo: Oge naaki pirisa rabu pisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Remome go naaki tulalore repena sulaa-para page ipa-para page mea malopaaoma yogale makoyaatalo pea. Go-rupa pea pare neme naa madaa kodome komoma raba meali palo maarea. ");
INSERT INTO kjs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Go-rupa lisa rabu Yesumi talo: Neme mada palua palo maarea lae ya? Ali medame naa agale lo robaa-para maitimiri ele raayo ora mada palua. ");
INSERT INTO kjs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Go-rupa lisa raburi aaraame wagepu yaaloma lo robaa-para agale namade-le ni raba meape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gore Yesu enaali raayome nipu epa kiritaoma kuta pubasimi adisa-pulu koe remo-para puri pale agale gu-rupa lisa: Ne kale poae agale maare ne koe remore neme puri pale agale lagialo: Mo ali nipu rakepema nipu-para wala na-epa pirape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Go-rupa lisa raburi mo remome e loma naaki mapururu pawa pisa. Go-rupa pisa raburi mo naakina to kogore lisa-daa enaali medalomame talo: Nipu le kadupiaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yapare Yesumi nipuna ki muma marekaasa. Go-rupa pisa raburi rekaitabisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu ada-para wala pisa raburi disaipel alinumi enaali napimi rabu agale mulalo pirisimi: Ake pea-daa naana abala mada namaraakepeaarima pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesumi nimu-para talo: Remo gupialere beten-me kama mada maraakepealia. Kone ele medalomame mada dia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nimumi go su giyoma Galili su robo ru-nane pamisimi. Pamisimi pare enaalinumi nipu wala mada na-adalimilo Yesumi nimu nalakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nipumi disaipel alinu agale rado mogealisa-pulu kaleda pirisimi. Nipumi gu-rupa mogealisa: Ni enaali Raapu Pirape alina Siri werepe lore alinu linalo mea kaleme lisa. Linaloma wala yapi repo dia naloma rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Go-rupa lisa pare disaipel alinumi nipuna agalena re namakuaasimi. Go-rupa pirisimi pare paala komisimi-pulu medana agale namisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Go rabu nimu su Kapaneam-para pirisimi. Go rabu Yesumi ada puma piruma nimu-para agale gu-rupa lisa: Naa pora poamade raburi ali madaa arere paleme ya? ");
INSERT INTO kjs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Go-rupa lisa pare nimumi agale meda nalisimi-para pora pagina pulaaoma aapi ora ali mudu piruma yapae arere pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Go rabu Yesu nipu piruma disaipel ali 12-pela ipulupa lisa. Nipumi nimu-para talo: Ali medame ni riri-nane abala pitua kone saliare gore nipuna kone giyoma enaali raayo raba meape ali abala pirape. ");
INSERT INTO kjs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Go lisa raburi Yesumi naaki meda nipu lomare nimu piri rikirana mea mapiraasa. Go rabu nipumi go naaki kupima lisana nimu-para talo: ");
INSERT INTO kjs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Enaali raayome go nogo naakinu komea epe-rupa muma raba mealimi-daare ni page go kone salimi. Enaali raayome ni epe-rupa muma mealimi-daare nimumi ni mea rapaae Aapa page mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon-me Yesu-para talo: Tisaa, nena bimi ali medana koe remo pane maa rakepeaaripa. Go-rupa pea pare naa raapu napima-le naame go-rupa napape. ");
INSERT INTO kjs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Go-rupa lisa pare Yesumi talo: Nipu namagiyaape. Ali medame naa bi-para napi palia-daare werepe nipumi ni madaa koe agale mada natea. ");
INSERT INTO kjs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gore enaali raayome naa madaa yada lore ali na-aulaliare gore naana adami ali pitimi. ");
INSERT INTO kjs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pagalepa. Enaali raayome nimi ni Keriso-na nogo naakinu adoma epe nape ipa gialimi-daare nimuna epe yoto waru mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Go oge nogo naaki meda ni madaa kone rulalimi-daare enaali medame nimuna kone rulae bebolaliare ora kolea. Bebolalia-daare go enaalina maa-para adaa kana madu maduma ipa-para lopaliare ora epelea. ");
INSERT INTO kjs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yesumi saa pi agale gu-rupa lisa: Gore nena kimi ne pupitagi manaaliare mea kepema pope. Ki ruguli ali-rupa pirali-daare epelea pare epe ki laapo paina koe repena sulaa-para pitiri ora kolea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Go adaa repena sulaa-parare enaalina eteto piri elenu nakomea mo repena sulaa pa ralaina. ");
INSERT INTO kjs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nena agemi ne pupitagi manaliaare go page nena age kepema poape. Go sune age ruguloma pitiri gore epelea. Go-rupa pare epe age laapo raita paina piruma wala repena sulaa-para pitiri ora kolea. ");
INSERT INTO kjs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Go adaa repena sulaa-para enaalina lewa lewa piri elenu repena sulaa-para ratia. ");
INSERT INTO kjs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Go page nena leme ne pupitagi manaaliare ralu rubape. Gore le kalae rubuli ali-rupa piruma Gote-na Surube Yapi di puma adali-daare epelea. Go-rupa pea pare epe le laapo pa apalae pirina repena sulaa-para mea rubalimiri ora koyaalia. ");
INSERT INTO kjs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Go adaa repena sulaa-parare enaalina eteto piri elenu nakomalia pare repena sulaa pa roalia. ");
INSERT INTO kjs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gore enaalinumi pagalepa: Repena sulaare ora puri wia-rupa page kusa puri wia page nimimi Gote-na puri pale agale pagoma koeyae pape kone rabuaniaa tapape. ");
INSERT INTO kjs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kusa-re ora epelea pare nipuna rede dia yaalia rabu wala ane palima ya? Nimina kusa-rupa rede masaaoma lo robaa-para kuma mapaaoma enaali raapu epe-rupa piralepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu go su giyoma Judia su robo ru-nane puma ipa Jordan mone pane kenaoma pisa. Go rabu enaali adaapumi nipu piri-para wala epa kiritasimi. Go-rupa ipisimi raburi nipuna pisa-rupa enaalinu wala lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Go-rupa pisa raburi Farisi alinumi Yesu ko tulalo ipuma makirae agale gu-rupa lakalisimi: Gore naana makuaae agale madaare ali medame were giyalia-daare go kone epelea lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Go-rupa lisimi raburi Yesumi nimu agaa gu-rupa misa: Moses-me nimi-para ali lagisa ya? ");
INSERT INTO kjs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yesumi go-rupa lisa rabu nimumi talo: Ali medame ena giyalia-daare Moses-me go alimi pepa mada lina lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Go-rupa lisimi pare Yesumi agaa gu-rupa misa: Nimimi agale waru napageme-le Moses-me pepa madaa agale mana go-rupa gisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pare abala su yaa laapo warisa raburi Gote-me ena ali laapo warisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Go-rupa pisa-pulu ali medame nipuna aaraa agi giyoma nipuna were raapu ora komea-rupa piralepape. ");
INSERT INTO kjs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Go-rupa puma nipu laapo dia yapare ora komea pirapina. ");
INSERT INTO kjs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Go-rupa puma Gote-me rapaaya komea mapiraasa-pulu ali medame mada narugulatepape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gore nimu ada-para wala puma disaipel alinumi Yesu mo ena yoke madaa wala agale lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Go-rupa puma Yesumi nimu-para talo: Ali medame nipuna were giyoma ena rado meda rumaalia-daare go alimi ena paake lami ena mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Go page ename aali giyoma ali meda palia-daare go ename page nipuna ali paake rume kone suma palia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Enaali medaloma Yesumi nogo naaki kimi waraainalo nipu piri-para mea ipisimi. Yapare nipuna disaipel alinumi mo enaalinu-para arere lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesumi nipuna disaipel alinuna kone adoma nipumi rono pagoma nimu-para talo: Nogo naaki ni piri-para maa epenawa. Gote-na Surube Yapi di-parare nogo naaki-rupa piralimi-daa mealimina. ");
INSERT INTO kjs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pagalepa. Enaali raayome Gote-na Surube Yapi di adolalo pirimiri nimu abala nogo naakina kone mada muma adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Go-rupa lisa raburi Yesumi no go naaki kupima kimi waraaoma epe raba mi agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pora wala pulalo pisa rabu ali meda wagepu ipuma Yesu madaa rumu pege puma agaa mulalo: Epe Tisaa, ni ade abuna kagaa piramala pope kone mulalore ake palua pae? ");
INSERT INTO kjs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Go-rupa lisa raburi Yesumi nipu-para talo: Gote nipu komea ora epelea-le ake pea-daa ni epe ali lae ya? ");
INSERT INTO kjs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne Gote-na rekena wi agale napage? Go-rupa wia: Neme enaali meda nalu makomaape. Ena meda paake nayolape. Neme paake nanape. Enaali-para makirae agale nalape. Enaali medana ele mulalo makirae agale nalape. Nena ama aapa laapona bi minasaoma agale waru pagalepape. ");
INSERT INTO kjs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Go raburi nipumi Yesu-para talo: Tisaa, go rekena agale raayore ni oge naaki rabu page abi page pago mogeaayo lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Go rabu Yesumi nipu-para raana komoma adoma suma gu-rupa lisa: Ne kone komea nasali. Nena elenu puma muma kana yoto muma enaali naralinu kala. Go rabu so yaa-para epe ele meaina-le ni raita maa epape. ");
INSERT INTO kjs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesumi go-rupa lisa raburi go alina ele adaapu wisa-pulu nipuna le-aga adainaaoma kedaame komoma pisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Go-rupa pisa raburi Yesu perekea luma nipuna disaipel alinu adoma nimu-para talo: Ali kamore Gote-na Surube Yapi di pulalore ora kalai peme. ");
INSERT INTO kjs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Go-rupa lisa-pulu disaipel alinumi paalame komisimi. Yapare Yesumi nimu-para saa pi agaleme wala talo: Naa naakinu-le waru pagalepape. Enaali raayome Gote-na Surube Yapi di adolalo peme pare kedaa waru pea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gore kamel menare noai kego-para palia yalore kedaa pea. Yapare ali kamope Gote-na Surube Yapi-para pulalore kamel menana kego-para kedaa ma-oge yaalia. ");
INSERT INTO kjs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Go-rupa lisa raburi disaipel alinumi pogolasaoma gu-rupa lala pirisimi: Gore aapimi mada ade abuna kagaa piramala palia ya? ");
INSERT INTO kjs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesumi nimu waru adabaaoma talo: Enaalinumiri nimuna mada dia yapare Gote-mere enaali raba meape kogono raayo mada pea. ");
INSERT INTO kjs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Go rabu Pita-me Yesu-para talo: Ada, naame ele raayo giyoma ne raita mea epena. ");
INSERT INTO kjs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesumi nimu lakalisa: Ni ora lae-le pagalo. Enaali raayomere nimuna ada page ame page bali page ama aapa page nogo naaki page su page ni-para epe agale-para raitalalo giyalia-daare nipu go-rupa medaloma waru mealimi. Go-rupa puma abiri nimumi ora adanu page amenu page balinu page amanu page nogo naakinu page rudu rado rubilina mealimi. Go-rupa pea pare kedaa raapu mealimi lisa. Go-rupa puma werepe kagaa su-para ade abuna piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Enaali adaapu abi riri-nane pimi pare go enaalinuri werepe koau-nane piralimi. Go-rupa puma abi werepe piri enaalinuri abala riri-nane piralimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nimu so Jerusalem su-para su-nane pora pamisimi. Go-rupa puma Yesu abala pisa rabu disaipel alinumi paala komisimi. Go enaali medaloma nimu raapu pamisimi rabu nimu page paala komisimi. Go rabu nipumi disaipel ali 12-pela mo-nane ogeasi puma nimu-para werepe epaliade ele madaa agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesumi nimu-para talo: Gore naa so Jerusalem su-para baina. Go-parare pa enaalinumi Gote-na lodo kira-ae ali mudunu page Gote-na agale le tisaa-nu page nimu-para ni enaali Raapu Pirape alina Siri lamu mealimi. Go rabu go alinumi lu makomaape kose agale lakeleme rabu ruru radome lamu mealimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Go raburi nimumi ni-para ero loma supi raa piaoma repena kulimi lu makomalimi lisa. Go palimi pare yapi repo dia naloma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Go rabu Sebedi-na si Jems Jon laapo Yesu piri-para ipuma talo. Tisaa, saame ne agaa mulalo pipa elere neme ora painalo lisipi. ");
INSERT INTO kjs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Go-rupa lisipi raburi Yesumi nipu-para talo: Gore nipina kone-para neme ake palua ya? ");
INSERT INTO kjs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nipumi Yesu-para talo: Go-rupa pape. Nere nena epe pirape siaa king madaa piruma surube ali pirali rabu saa page pirapana. Meda nena popo ki-nane pirina meda nena koya ki-nane pirina lisipi. ");
INSERT INTO kjs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yapare Yesumi nipu-para talo: Nipi go siaa mulalo pape elere nipi namakuaaepe. Naa ipa naluade pe-rupa radaa mada nalipi ya? Niri kalu-ipa mealua-rupa nipiri go-rupa kalu-ipa mada mealipi ya? ");
INSERT INTO kjs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nipu laapome nipu-para talo: Saa mada lisipi. Yesumi nipu-para talo: Neme nalua ipa pere go-rupa mada nalipi. Go page nina mealua kalu-ipa go-rupa mada mealipi. ");
INSERT INTO kjs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Go mada palipi pare nina popo ki-nane page koya ki-nane mapiraape konere neme agale mada nalagialua. Go-para pirapere aapa komeame nipuna tea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gore disaipel ali medalomame go agale pagomare mo ameaya Jems Jon laapo-para rono pagesimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Go-rupa pisimi-pulu Yesumi nimu raayo yaaloma talo: Ruru radona ali kalunumi nimuna enaalinu madaa puri paloma nimuna koneme peme. Nimumi go enaalinu waru surubaeme. ");
INSERT INTO kjs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Go-rupa peme pare nimuna kone agale namogealepape. Nimina kalu ali mudu pirano kone salia-daare go aliri nipu nimi abala raba mealia. ");
INSERT INTO kjs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Go page nimina komea abala riri-nane pulalore nipu abala kogono ali-rupa piralia. ");
INSERT INTO kjs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ni enaali Raapu Pirape alina Siri enaalinumi nina kogono paminalo naipisua pare enaali raba mulalo ipisuade. Nina kone wasaame enaalinuna koe kone mea rubaitalo ipisuade. ");
INSERT INTO kjs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nimu Jeriko su-para ipisimi. Gore Yesu page nipuna disaipel alinu page enaalinu page Jeriko su giyasimi raburi ali meda Bartimeus-miri pora kebo-nane pirisa. Go aliri le rubu pi ali piruma kana kogetalo pirisa. Nipuna aaraare Timias yade. ");
INSERT INTO kjs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gore mo aliri nipu Nasaret su-para piri ali Yesu epaa remaa pagisa-pulu nipumi gu-rupa yalisa: Yesu-yo, Devit-na si-ya. Ni kodome komape. ");
INSERT INTO kjs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Go-rupa lisa raburi enaali medalomame nipu rono pagoma agale nalape lisimi. Go-rupa lisimi pare nipu ora puri paloma wala yalisa: Devit-na si ni kodome komape. ");
INSERT INTO kjs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Go rabu Yesumi pa aoma enaalinu-para talo: Go ali mea nipu lo lakalisa. Nimimi le rubu pi ali-para yaaloma talo: Paala nakomape. Ne yaata-le rekoma pu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Go-rupa lisimi raburi mo ali mamina kolo rubuma wagepu rekoma Yesu piri pisa. ");
INSERT INTO kjs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Go-rupa puma Yesumi nipu-para talo: Nena konere neme ne-para ake palua ya? Le rubu pi alimi nipu-para talo: Epe Tisaa, nina le ma-epeaaina ele adaluame pi. ");
INSERT INTO kjs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesumi nipu-para talo: Abi pu. Nina agale lo robaa-para makodaaoma kone rulaaripi-pulu nena leme ele mada adali. Ora go-rupa lisa raburi mo alina le epeaasa rabu nipu Yesu raita maa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Go-rupa puma nimu Rudu Oliv-na pora pagina ipuma su Jerusalem su-parana oge adare su Betfasi-para su Betani laapo re-para ipisimi. Ipisimi rabu Yesumi nipuna disaipel ali laapo maa rapasa. ");
INSERT INTO kjs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Go rabu nipumi nipu-para talo: Mogo-nane su adare-para pulupa. Go-parare donki mena meda adibaliare koloma mea ipulupape. Go donki menare nipuna koauna enaalinu abi napiri. ");
INSERT INTO kjs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Enaali medalomame ne-para go donki mena ake pea-daa maa pali pa lemere go-rupa tapape: Mudu Alimi go menana kogono saliare wala gialia lo tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Go-rupa lisa raburi nimu pora puma donki mena meda adisimi. Go donki mena abala medana pora gaape kuli-para aina rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Go rabu go-para reka aasimi enaalinumi nimu-para talo: Ake pea-daa go mena idi kolele ya? ");
INSERT INTO kjs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Go-rupa lisimi raburi Yesuna lisade agale lakelaasimi. Go-rupa puma nimumi pina maa pulupape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Go-rupa puma nimumi donki mena Yesu piri mea ipuma nimuna mamina-nu mena koauna winaloma Yesu pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Go-rupa pisa raburi enaalimi mamina-nu pora pagina rabulasimi. Medalomame maapu-nini repena palaa yo laapo poma pora pagina rabolaari ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Go-rupa puma riri-nane enaalinu-para aapu-nane ipisimide enaalinumi page gu-rupa yalaasimi: Gote-na bi minasalimina. Go aliri Gote-na bi madaa ipula-le Gote-na adaa bi kalamina loma yalaasimi: ");
INSERT INTO kjs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Naana kasua Devit-na Surube Yapi di epalia Gote-me puri kalaina. Gote-na bi minasalimina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Go-rupa puma Yesu Jerusalem su-para puma Juda alinuna epe lotu ada-para ele adola pisa. Nipumi ele adabaaoma ribaa lisa rabu nipu ali 12-pela raapu Betani su-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Go-rupa puma wala ekera-nane Betani su-para aoma ipisimi raburi Yesu reame komisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Reame komisa raburi nipumi mo-para aaya repena fik-na yo adomare kili elea palo adola pisa. Go kili raitalo pisa raburi nipumi kili na-elisa yo kama aasa adisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Go-rupa adisa-pulu Yesumi repena-para agale gu-rupa lakalisa: Nena kili meda ora mada namaitiape. Go-rupa lisa raburi disaipel alinumi go agale pagisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nimu Jerusalem su-para opapasimi rabu Yesu epe lotu ada ru-nane kodobasa. Go-rupa puma nipumi lotu ada-para bisnis rome pi alinu maa ralulisa. Go rabu nipumi kana ropo pi alinuna reke lakepe rubebe puma ele rome pi alinuna reke page puma lakepe rubebe pisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Go-rupa pumare enaalinumi lotu ada ru-para ele rialo ipisimi rabu Yesumi rekena wisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Go-rupa pisa raburi nipumi nimu-para agale moge riaoma talo: Gote-na pepa madaa gu-rupa lu wisa: Su raayona piri enaalinumi naa ada ora Gote-para beten lape adalu wisa. Yapare nimimi paake ne alinuna kaledape ada-rupa ma-aulaeme lisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Go-rupa lisa raburi Gote-na lodo kira-ae ali kalunumi page rekena tisaanumi page pagoma nimumi Yesu lu makomalima kone wisimi. Go-rupa pirisimi pare enaali raayome Yesuna epe agale madaa raana komoma pogolasaasimi-pulu go alinumi Yesu mada nalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ribaa Yesuna disaipel alinu raapu go adare giyasimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Go-rupa puma wala ekera-nane yapipu nimu pora pagina pisimi rabu nimumi mode repena fik aasa adisimi. Go adisimi raburi repena page no repena pitaa page abala kaapu lisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Go-rupa pisa raburi Pita-me abalade kone saapiruma Yesu-para talo: Tisaa ada, go yaina abala lae-le go repena fik ora kaapu lea. ");
INSERT INTO kjs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Yesumi nimu-para agale lakalisa: Pagalepape. Gote-na agale lo robaa-para kone rulaalepape. Nimimi mogo rudu-para ne rekaoma ipa-para puma pogola teme-daare go-rupa mada palia. Yapare agale gu-rupa teme rabu lo robaa-para kone laapo suma kone waru narulalimi-daare go-rupa mada napalia. ");
INSERT INTO kjs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Go-rupa pea-le neme nimi-para talo: Nimimi ele mulalo beten teme rabu ora mealima kone rulalimi-daare ele ora mada mealimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Go page nimi beten talore nimimi enaali meda madaa koe kone nimiri maa rubapape. Go-rupa puma nimina so yaa-para pia Aapa nipumi page nimina pupitagi maa rubalia. ");
INSERT INTO kjs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yapare enaali medalomana pupitagi namuma rubalimiri yaa-para pia Aapame abuna nimina pupitagi namuma rubalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Go-rupa pisa raburi nimu Jerusalem su-para wala pisimi. Yesu lotu ada-para pamualaina Gote-na lodo kira-ae ali mudunu page Gote-na agale lae tisaa-nu page makuaae alinu page Yesu piri-para ipuma talo: ");
INSERT INTO kjs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gore aapina puri muma neme kogono pe lisimi. Go kogono pe-le aapimi puri go aaya? ");
INSERT INTO kjs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesumi nimu-para talo: Neme page nimi-para agale komea mealuame pi. Agale yago timi rabu neme kogono pape puri aapimi gisare nimi madaa lagialua. ");
INSERT INTO kjs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Agale abutepape. Jon-re kalu-ipa meape lo robaari Gote-me kalisa pe enaalinumi kalisimi pae? Go agale abutapa. ");
INSERT INTO kjs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Go-rupa lisa raburi nimuna ape pirisimi. Gore naame Gote tema-daare nipumi ake pea-daa Jon-na agale madaa kone narulaeme pae? ");
INSERT INTO kjs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yapare naa alinumi puri kalisa lema page mada dia. Go-rupa lisimiri nimumi enaalinu madaa paalame komola lisimi. Gore enaali raayome Jon ora Gote-na agale lakale ali pirisa-daa kone rulaeme-pulu mo alinu paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Go-rupa puma nimumi Yesu-para agale gu-rupa lakalisimi: Naa maarea lisimi. Go-rupa lisimi-pulu Yesumi nimu-para talo: Gu-rupa leme-le aapina puri muma kogono pere nimi page nalagialua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Go raburi Yesumi nimu-para saa pi agale meda gu-rupa lisa: Ali medame nipuna wain kili maapu poasa. Go rabu nipumi pape waru puma naaku pu suma kili igipi sape warisa. Go-rupa pumare nipumi surubape ada meda warisa. Go-rupa puma nipumi kana yoto meape alinumi surubenalo pora kimisu pisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gore wala kili elesa raburi go maapuna aaraame kogono ali meda mo maapu surubape alinu piri-para mea rapasa. Maapuna aaraa kana yoto katoa rabu kogono ali mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Go-rupa pisa pare maapu surubape alinumi kogono ali ripinaaoma luma rapaasimi. Rapaasimi pare kana yoto nakalasimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Go-rupa pisa raburi kogono ali rado meda mea rapasa. Nipumi kana yoto mula pisa rabu nimumi go alina kalu luma koe-rupa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Go-rupa puma maapuna aaraame kogono ali meda mea rapasa rabu lu makomasimi. Go-rupa puma nimumi ali medaloma page luma ali medaloma page ora lu makomasimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Go-rupa puma maapuna aaraare nipuna si komea pirisa yapare ora nipuna epe naaki pirisa. Go-rupa puma kogono ali medaloma dia lisa-daa nipuna si page wala rapaoma kone gu-rupa wisa: Nina si yaa-pulu nipu madaa epe kone suma agale pagena kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Go-rupa pisa-para maapu surubape alinumi yada roboma gu-rupa lisimi: Go naakimi maapu nipu koro mealia-le tamina lisimi. Go maapu naa mada mealima lisimi go-rupa palimare. ");
INSERT INTO kjs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Go-rupa loma go naaki ripinaaoma lu makomaoma maapu pape mopare lu rubisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesumi go remaa madaa talo: Gore go kili maapuna aaraamere ake palia ya? Gore nipu puma maapu surubape alinu lu makomaoma ali medaloma maapu surubenalo katea. ");
INSERT INTO kjs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gore nimimi Gote-na buk madaa gu-rupa diminalimi: Kana medare kamda kogono alinumi giyoma yapare abi ora mupaa kana aaya lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Go kogonore Gote-na papea-le Naame ora epe rado ele adema lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesumi go saa pi agale lisa rabu Juda ali kalunumi nipu adialalo pirisimi. Yesuna saa pi agalere naa madaa lea kone wisimi. Yapare nimumi enaali adaapu madaa paalame komisimi-pulu Yesu giyoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Go raburi nimumi Farisi alinu page Herot-na adaami alinu page Yesu piri-para rapaasimi. Nimumi Yesu agale mu kolisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Go-rupa puma mo alinumi talo: Tisaa, naame ne adema-le ne enaali madaa paala nakome pare Gote-na kone madaa ora agale mogelele. Gore nena konemere ali mudu ali riabo laapo madaa kone komea su piruma Gote-na redepo le pora waru mogele. Go-rupa pea-le neme naa lagiape: Rom gavman ali mudu Sisar-na opis-para takis kana lopaemare go epelea palo kolea? ");
INSERT INTO kjs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Go takis kana-re lopamina yapae dia yapae lisimi. Go-rupa lisimi rabu Yesumi nimuna kone adoma muma makirae agale madaa kone wisa-pulu nimu-para talo: Ake pea-daa nimimi ni go agaleme kotalalo pimi pae? Gore kana kili komea adano mea ipulupa. ");
INSERT INTO kjs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Go-rupa lisa raburi kili komea mea kalisimi. Yesumi nimu-para talo: Go kana madaare aapina bi-para piksa-para wia pae? Nimumi nipu-para talo: Sisar-na piksa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Go-rupa lisimi raburi Yesumi nimu-para talo: Gore Sisar-na ele Sisar pa katapape pare Gote-na elenu Gote-para pa katepape. Go lisa raburi nimu pogolasaoma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Go-rupa pisa raburi Sadyusi ali medaloma Yesu piri-para ipisimi. Nimuna konere kome enaalinu tapa-para wala narekalimi kone wisimi. Nimumi agaa gu-rupa mulalo pisimi: ");
INSERT INTO kjs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisaa, Moses-me naa-para pepa gu-rupa lisa lisimi: Ali medana ame komenaloma were pia pare nogo naaki napiraliare go ena nipuna amena were rumaaoma nogo naaki matia. ");
INSERT INTO kjs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sadyusi alinumi wala lisimi: Gore ame 7-pela pa pirisimi. Mupaare ena mu ma-aoma komisa raburi nogo naaki namadisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gore ame laapome go alina ena wasa rumaaoma komisa pare nogo naaki dia lisa. Ame repome page go-rupa pisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Go-rupa puaoma pumare ame naba seven nipumi mo ena rumaaoma komisa pare go ename nogo naaki namaitisa. Werepere go alina ena wasa page komisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gore wala Gote-me enaali marekaara paliare go enare aapina ena piralia ya? Go ame ki medane luma medane laapo nimumi ena misimi-le lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesumi nimu-para talo: Gore nimimi Gote-na puri-para nipuna buk madaa wi agale-para ora na-ademe-pulu apo agale ma-koyaaleme. ");
INSERT INTO kjs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Werepe tapa-para enaali rekalimi rabu yaa-para piri ensel-nurupa piralimi. Go-rupa pea-le enare go rabu abi narumaalimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Go page kome alinu rekalimi rabu go madaa Moses-na buk madaa wi agale gu-rupa nadipilisimi ya? Go buk-ri repena raane remaa agalere Gote-me Moses-para agale gu-rupa lakalisa: Ni Abraham-para Aisak-para Jekop-para nimu raayona Gote pi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Go agalena re-re Gote-me ora kone wasa su aaeme enaalinuna mudu pia. Nipu pa kome enaalinu Gote-daa dia. Nimina agalere lo makoyaaleme lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Go agale lakalisa raburi rekena agalena tisaa meda piruma enaalinuna agale pagisa. Go alimi Yesu nimu-para agale epe-rupa abulisa-pulu nipumi Yesu-para agale gu-rupa mulalo pisa: Rekena agale medare ora mudu yaa-pulu medaloma makuaabaita ya? ");
INSERT INTO kjs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesumi talo: Mupaa rekena agale gu-rupa lisa: Israel enaali pagalepape. Naana Mudu Gote-re naana ora mudu komea pia. ");
INSERT INTO kjs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nimimi Mudu Gote madaa ranaame komalimiri nimuna lo robaa raayo-para kone wasa raayo-para go raayore Gote madaa raaname komoma ranaa komo piralepape. ");
INSERT INTO kjs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Rekena agale laapona mudu agale gu-rupa lisa: Nimina yogale surubeme-rupare nimimi pa enaalinu madaa raaname komoma ranaa komo piralepape. Go rekena agale laapore pa meda-rupa ora meda narabuainaaya. ");
INSERT INTO kjs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Go rabu mo rekena agale tisaa-me Yesu-para talo: Tisaa loma neme ora waru lae. Gote nipu ora Ali Mudu komea pia le. Go page Gote pia-rupare pa gotenu medaloma napimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Go-rupa pea-le enaalinumi Gote madaa raana komoma ranaa komo piralimi-daare nimina lo robaa raayo-para kone wasa raayo-para puri raayo-parame pamina. Go page nimina yogale surubeme-rupa nimina ame madaa raaname komoma ranaa komo piramina. Go konere ora epelea-le go konemere lodo kira-ae page ele lu yawape kone page ma-oge yaaya. ");
INSERT INTO kjs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesumi go alina epe makuaae kone adoma talo: Ne Gote-na Surube Yapi di-para pulalo pi. Go-rupa lisa raburi enaalinumi nipu agale namisimi pare paala komoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gore werepe Yesumi Juda alinuna epe lotu ada ru-para aoma agale mogeama talo: Ali puma rekena agale tisaanumi gu-rupa leme: Enaali Raapu Pirape alina Siri nipu Devit-na si piralia leme. ");
INSERT INTO kjs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Holi Spirit-mi Devit kone kalisa-pulu Devit-mi gu-rupa lisa: Gote-me nina Ali Mudu-para gu-rupa lakalisa: Nina popo ki-nane ali mudu piraina-le lore alinu nena age rolo-para marabuaniaalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gore Devit-mi nipuna Ali Mudu sa-le ake puma enaali Raapu Pirape alina Si Devit-na pa si mada piralia ya? Enaali adaapu piruma Yesuna agale pagape raaname waru komisimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuna disaipel ali-para agale gu-rupa lakalisa: Rekena agale tisaanuna kone waru adalepape. Nimumi mamina au pi adaalu yamoma su kamaa puma enaalinumi abi piralepape raana komeleme. ");
INSERT INTO kjs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Go alinuna konere Juda alinuna lotu ada-para kodobaoma riri-nane reke madaa pirulalo pedo peme. Go page eda adaa yaweme raburi rikirana madaa pirulalo pedo peme lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Go pi alinumi kone medare nimu ena wasaana ele paake neme. Go-rupa puma beten adaalu rudu leme rabu enaalinu makiraalimi. Go-rupa peme-pulu werepe di salia raburi nimuna koe kedaa ora adaalepe mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesumi lotu kana kiritasimi re-para piruma enaali adaapumi kana lopasimi-daa adisa. Go-rupa puma kamo alinumi kana adaapu lopasimi. ");
INSERT INTO kjs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Go-rupa puma ena wasa meda ipuma kana oge kale laapo epa lopasa. Go kana-re ora ogeasi lopasa. ");
INSERT INTO kjs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Go-rupa pisa raburi Yesumi nipuna disaipel alinu adaminalo ma-epaaoma agale talo: Nimi-para neme ora talo. Go ena wasaana kana-re ora ali medaloma nimuna kaleme ma-oge yaaya lisa. ");
INSERT INTO kjs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nimumi kaleme rabu kana adaapu wimi pare go ena nipuna katea rabu eda kabape kana raayo kalisa. Nipuna kana medaloma dia yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Go-rupa puma Yesu Juda alinuna lotu ada giyoma pisa. Go raburi disaipel ali komeame nipu-para talo: Tisaa, go adanu-para kananu page ora epelea-le adaina lisa. ");
INSERT INTO kjs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesumi nipu-para talo: Go adaa adanu waru adae? Gore go kiritasimi kananu ora komea-daa na-aalia pare raayo lakepema rubebe palimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gore koro meda Yesu Rudu Oliv-ne piruma mo Juda alinuna epe lotu ada kana adisa. Pirisa raburi Jems-para Jon-para Edaru-para nimumi Yesu piri-para ipuma komea-para pirisimi rabu agaa gu-rupa misimi: ");
INSERT INTO kjs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nena laede-rupa aa-rabo palia? Abi lagiape. Naame ele adalimare gore go ele epenalo mada makuaalima pae? ");
INSERT INTO kjs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesumi nimu-para agale abuloma lakalisa: Ali medalomame ne makirae agale mea lagialimiri waru adalepape. ");
INSERT INTO kjs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Werepe ali medaloma ipuma nina bi Yesu pa leme-le enaali adaapu epe pora makiralimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Go page nimimi yada marekaape agale-para ora yada pape remaa-para pagalimi rabu paala nakomalepape. Go-alenu abala palia pare su yaa perekeape yapiri go rabu-daa dia. ");
INSERT INTO kjs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Go-rupa pumare ruru medalomame ruru rado-para yada palimi. Go page gavman adaa su medalomame gavman su rado radonu raapu palimi. Go page su rado rado-para suminini palia. Go page su rado rado-para reae adaa pabalia. Go-rupa palia pare go elenuri naakimi koau nala-rupa mada epalia. Ele medaloma page werepe epalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yapare nimi koe enaalinu raapu piralimi rabu nimimi nina pora mea waateme. Nimumi nimi adialalo kaunsil-na ada-para maa puma kose leme. Go page nimumi nimi Juda alinuna lotu ada-para luma nimi balinu piri-para maaoma ali mudunu piri page ma-awalimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Go-rupa palia pare epe agalere enaali piri su raayona abala lakelalo kiritalimi. Go-rupa puma werepere go yapi di dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nimumi nimi mapaitaaoma kose-para maa palimi raburi ni ake lano yapae kone lo robaa-para namapiraalepape. Go raburi Holi Spirit-mi agale lagialia-pulu nimimi agale mada lakeleme. ");
INSERT INTO kjs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Go raburi ame balinumi nimuna ame bali medaloma enaalinu-para tyaminalo mea kaleme. Aaraanumi nogo naaki enaalinu-para mea tainalo kaleme. Nogo naakinumi agi aaraa-para rono pagoma linalo mea kaleme. ");
INSERT INTO kjs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nimiri nina si yaa-pulu enaali raayome nimi rono pagoma giyalimi. Go-rupa palimi pare enaali raayome ni nagiaoma palimiri werepe go su yaa dia yaalia rabu page ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gore nimimi mabebolaoma pugu pi ele adalimi rabu go ele epe ada-para rekalia-pulu go rabu su yaa laapo dia yaalia. Go rabu su Judia piri enaalimi rudu apedaa-para pogola pulupape. Gore buk Daniel-me lisa-daa enaalinumi go agalena re abala ademe-pulu mada makuaamina. ");
INSERT INTO kjs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Go rabu enaalinuri ada pera-le piralimiri ru-nane wi elenu namula pulupape. ");
INSERT INTO kjs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Go rabu page enaali medaloma maapu-para piralimiri nimuna mamina kura laapo namuma yamola pulupape. ");
INSERT INTO kjs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Go page ena medame nipuna nogo naaki padaa pia page adu nala ayaanu page pawa pogola palimi rabu ni kodo palia. ");
INSERT INTO kjs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yapare go piale koe kogono epe-rupa rabu na-epenalo beten tapape. ");
INSERT INTO kjs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Go rabu epaliade elere enaalinumi kedaa gu-rupa na-ademe. Gote-me su yaa laapo wariaaoma ipuma abi page radaa adaalepe go-rupa na-epea. ");
INSERT INTO kjs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gote-me go koe ele epaliade yapi di nama-rudu yaaliare enaali raayo ora komalimi. Yapare Gote-me nipuna mapiraae enaali madaa kone salia-daa nipumi go di marudu yaalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Go raburi enaali medalomame go-rupa leme: Maa Rapae Aliri go-para pia-le go page mogo-para pia leme-daare go agale napagalepape. ");
INSERT INTO kjs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gore makirae keriso-nu page makirae agale lakale alinu page opapalimi. Go rabu nimumi napi kogono puma ele epape di radonu pinalo adalimi. Go-rupa puma nimumi nimi Gote-na mapiraae enaalinu makiritalo epalimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Go-rupa palimi pare waru adalepa. Go epaliade ele raayo madaa agale abala lagu aayo. ");
INSERT INTO kjs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Go-rupa puma enaali madaa apo radaa abala nenalomare naare kudunaoma kasua naraalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kuba kedome yaa giyoma lopalia page yaa-para piri elenuna puri page ma-lewa lewa palia. ");
INSERT INTO kjs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Go-rupa palia raburi enaali Raapu Pirape alina Si adalimi. Nipumi yaa-para ipuma nipuna puri ora maa epalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Go-rupa pisa raburi nipumi ensel rapaoma nipu su raayona abalade mapiraae enare makiritaalia. Kiritalia rabu su yaa ruma aaya-nane puma re lapu lapu yarara yarara pu mea kiritalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kama fik repenana kone waru mealepape. Nipuna palaa-para ipa ruboma yo kagaa opea raburi go ele adoma pane pe-daa epelea kone su makuaamina. ");
INSERT INTO kjs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Go page apo koe ele epalia raburi kedaa meape yapi di ora re-para epalia-le makuaamina. ");
INSERT INTO kjs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Go agale pagalepa. Go pimi enaali abi nakomalimi pare go elenu abala epenalo adalimi. ");
INSERT INTO kjs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Su yaa laapo abala dia yaalia pare nina agale ade abuna pa sama palia. ");
INSERT INTO kjs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yapare go epaliade yapi di-ri enaali medame page namakuaaeme. Yaa-para piri ensel page Gote-na Simi page namakuaaeme pare aapa Gote-me agu raapu go yapi di adoma makuaaya. ");
INSERT INTO kjs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Go epaliade yapi di rabu namakuaaeme-le waru adoba piralepape. ");
INSERT INTO kjs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Go yapi di-na remaare gu-rupa lagialo: Pa ali meda pora kimisu pulalo pisa. Go rabu nipuna ada giyoma nipuna kogono alinu abala kogono rumaaoma pisa. Go rabu pora gaape surubape ali-para waru adobape loma pisa. ");
INSERT INTO kjs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gore adobalepape lisa. Adana aaraare aa-rabo epalia palo namakuaaeme. Ribaa epalia yapae rumu rumuna epalia yapae yaa kakarega agale piade rabu yapae yapipu epalia yapae maarea. Go-rupa pea-le ora waru adobalepape. ");
INSERT INTO kjs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mogo adana aaraa epalia rabu nimi paitalimiri ora koeyaalia. ");
INSERT INTO kjs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gore neme nimi-para lagialo-rupare enaali raayome ora adoba piralepape lano lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Go-rupa puma werepe wala yapi laapome Pasova eda di epalia. Go rabu page Bret Nama-adaape yapi di yaa-pulu enaalinu epa kiritasimi. Go raburi Gote-na lodo kira-ae ali kalunumi page rekena agalena tisaanumi page Yesu lu makomaatalo pisimi-pulu nipu adialalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Go-rupa pirisimi rabu nimumi talo: Enaalinumi koe-rupa pogolasaalimi-pulu go Pasova yawena yapi di rabu Yesu mada na-adiamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Gore Yesu Betani su-para ipuma Saimon-na ada-para piri ali yakilimi lisa pare ma-epeaasa. Pirisa raburi ena medame kana pe muma epe kaa wi wabola pira palae mea ipisa. Go ipare yoto ora adaalepe winalo ename go pe loboma Yesuna kaluna madaa koyasa. ");
INSERT INTO kjs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Koyasa rabu go piri enaali medalomame rono pagoma gu-rupa lo pirisimi: Ake pea-daa go epe ipa pa rubala? ");
INSERT INTO kjs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Go ipa kabola peme raburi kana yo adaapu gu-rupa 1200 kina mada muma riabo naralinu pa katea pema. Go-rupa loma nimu mo ena-para arere lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Go-rupa pisa raburi Yesumi talo: Go agale giyalepa. Ake pea-daa nipu madaa koe kone wimi pae? Nipumi ora epe kone suma pea. ");
INSERT INTO kjs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Riabo naaralinuri ade abuna nimi raapu piralimi-pulu nimu madaa raba meape kone salimi-daare go rabu palepape. Yapare neme nimi raapu ade abuna napitua. ");
INSERT INTO kjs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Go enana kone epelea-le palainawa. Naa ro rogaaliminalo naa to yogale madaa go epe ipame abala koyaala. ");
INSERT INTO kjs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pagalepa. Gore epe agale su raayona lakeleme rabu enaalinumi go enana bi pagenalo nipumi ni madaa ipa koyasa kone salimina. ");
INSERT INTO kjs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Go rabu disaipel 12-pela alina bi medare Judas Iskariot pirisa. Go aliri Gote-na lodo kirape ali mudunu piri-para puma Yesu tyalalo yada robisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Go ali kalunumi Judas-na agale pagoma raaname komoma kana gilima lisimi. Go-rupa lisimi-pulu Judas-me Yesu ora linalo mea katoa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Go Bret Yis Nasape Yapi di raburi disaipel alinumi Yesu-para agaa gu-rupa misimi: Naa aa-rabo puma nena Pasova eda kiritao salima ya? Go rabu Pasova-na sipsip lisimi-pulu go-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Go raburi Yesumi nipuna disaipel ali laapo mea rapaoma talo: Su yada-para palipi raburi ipa noria ipulae ali meda madaalipi. Nipu raita maa pulupape. ");
INSERT INTO kjs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nipu ada-para kodobalia rabu go adana aaraa-para gu-rupa lakatapape. Tisaa-me talo: Ni-para nina disaipel alinu-para naa Pasova eda nalima-pulu go ada rubene-para wia palo laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Go tepe raburi mo alimi nipi so-nane maa puma epe au pi ada ruboma mea waalea. Go rabu nipumi naana eda nape elenu mea kiritao salepape. ");
INSERT INTO kjs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Go-rupa lisa-pulu disaipel alinumi adare-para puma Yesumi lakalisade-rupa adisimi. Go-rupa puma nimumi Pasova eda yarera pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wala alebo raburi Yesu disaipel ali 12-pela komea-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Go-rupa pumare nimu reke madaa eda no pirisimi rabu Yesumi talo: Pagalepa. Nimina ali komeare ora koe makirae ali pia pare abi nipumi ni raapu eda pa no pia. ");
INSERT INTO kjs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Go-rupa lisa raburi nimu kodome komoma disaipel ali 12-pela alimi komea komea nipu-para puma agale gu-rupa misimi: Gore ni ora yapae lo gu-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesumi nimu-para talo Aposel ali 12-pelana komea abi saa laapo plet-para bret madaa ki sapalae no pipa. ");
INSERT INTO kjs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gote-na buk madaa lea-rupa enaali Raapu Pirape alina Si komalua lisa. Go-rupa pea pare go raburi nipuna koe makirae aliri koe ele epalia-na kodome komalo. Go aliri nipuna agimi abala namadea pisa yalore ora epelea lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eda nisimi raburi Yesu nipu bret muma Gote-para ora pili loma rukima nipuna disaipel alinu kalisa. Kalalaara gu-rupa lisa: Mealepa. Go bret-re nina yogale gialo-le muma nalepa. ");
INSERT INTO kjs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Go-rupa puma Yesumi kap muma Gote-para ora pili lomare kalisa. Kalisa rabu nimumi raayo nisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Go rabu Yesumi nimu-para talo: Go ipa wain-ri nina yaapi-rupa enaalinu madaa koyalo. Nina yaapi-miri Gote-na ora agaleme puri mapaayo. ");
INSERT INTO kjs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nimi-para ora talo: Neme-le ipa wain pa mada nanalua pare abala Gote-na surube su-para piruma nalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Go-rupa pisa raburi nimumi ora pili yalisa lomare su Rudu Oliv-nane pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pamisimi raburi Yesumi nimu-para talo: Nimi raayo ni giyalimi. Gote-na buk madaa gu-rupa lu wia lisa: Gote-me sipsip punili ali talia-pulu sipsip yola minaabalia lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yapare ni wala rekoma nimi Galili su-para palimi rabu ni abala riri-nane palua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Go-rupa lisa raburi Pita-me nipu-para talo: Nimu raayome ne giyalimi pare neme mada nagiyalua lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesumi nipu-para talo: Waru pagalepa. Go ribaare yaa gulame e rana laapo talo palia pare abala rana repo neme ni Yesu na-ade tea. ");
INSERT INTO kjs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Go-rupa lisa raburi Pita-me puri palo yaaloma gu-rupa lisa: Saa rana komea komalipa pare neme le naginalo lisa. Go disaipel ali raayome agale komea gu-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gore nimu su medana bi Getsemani-para pirisimi. Go-para Yesumi nipuna disaipel alinu-para talo: Go-para nimi piramina neme beten lalo pulu lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Go-rupa puma Yesumi Pita-para Jems-para Jon-para lamua pisa. Go rabu Yesuna pu imu-para ora radaa puma kedaame komisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nipumi nimu-para talo: Nina lo robaa-para kedaa puma ni komalua lisa. Go-nane adoma pitaapape. ");
INSERT INTO kjs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Go-rupa loma Yesu pora pagina wala ogeasi puma suna lopesa. Lopoma Gote-para beten gu-rupa lisa: Aapa, ni madaa ora kone saliri go radaa ni mada na-epena magiyaape. ");
INSERT INTO kjs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Go-rupa loma wala talo: Aapa, ne ele raayo mada pali-le ni radaa nape giyano kap pane meape. Yapare neme kone salo-rupa napeape. Dia, nena koneme makuaaoma pape. ");
INSERT INTO kjs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Go-rupa loma wala ipisa pare nipuna disaipel ali repo u pa palisimi. Go rabu Yesumi adoma Pita-para talo: Saimon-ya, ne u paitae ya? Ne go ogesi rabu mada narekali? ");
INSERT INTO kjs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gore koe ele-para lopali-le beten loma adaaba piralepape. Nimina konere puri palea pare nimina yogale koma paaya. ");
INSERT INTO kjs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Go-rupa loma nipu wala puma beten agale abala lisa-rupa wala lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nipu disaipel alinu piri-para wala ipisa rabu nimu pa u palisimi. Nimuna le-para u wala ipisa-daa u palisimi. Nimumi rekoma nipu-para agale wala meda na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Go-rupa puma wala rana repo Yesu ipuma nimu-para talo: Nimi penaa u paluma piralimi ya? Gore mada. Abiri nimumi enaali Raapu Pirape alina Si pupitagi ne enaalinu lamu kaleme. ");
INSERT INTO kjs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Rekoma baina. Ada, ni limina yada robo meade aliri abala go epea-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesumi agale lalaina go aposel-na rikiranare ali Judas page enaali adaapu page medaloma ipisimi. Nimumi nimuna repena kulinu nimuna rai kudunu mea ipisimi. Gote-na lodo kira-ae ali kalunumi page rekena agale tisaa-nu page ali kalunumi rapaasimi-pulu ipisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gu-rupa ipisimi rabu koe makirae ali Judas-mere nimu-para pagaa wi kone kaloma talo: Neme go ali puma nunu toa rabu go ali mealepape. Nipu adiala waru surubuma maa pulupape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gore Judas ipisa raburi nipumi Yesu piri wagepu puma puaa talo: Ali Mudu lisa. Go-rupa loma nipumi Yesu nunu lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Go rabu nimumi Yesu adialalo waru ripinaaoma misimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yapare ali meda re-para piri alimi rai kudu muma Gote-na ali mudu nipuna raba mi ali tulalo pisa pare kale rakepe poasa. ");
INSERT INTO kjs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Go-rupa puma Yesumi nimu-para talo: Ake pea-daa nimimi rai kudu-para repena kuli-para muma ni timi ya? Ni paake ne ali ya? ");
INSERT INTO kjs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ni ade abuna nimi raapu lotu ada-para piruma agale mogeaaripu pare go rabu ni adialalo naipisimide. Yapare Gote-na buk madaa wia-pulu mada palimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Go lisa raburi disaipel alinumi nipu giyoma pogola pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Go rabu penaali medame Yesu raita maa pisa. Go naakina to madaare mamina kaake pi kama yamesa. Go rabu ali medalomame nipu epa ripinaabasimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yapare nipu mamina malopaaoma pogola pisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Go raburi nimumi Yesu Gote-na ali mudunu piri-para maa pisimi. Go raburi Gote-na lodo kira-ae ali mudunumiri kone makuaae alinu-para rekena agalena tisaanu-para nimu komea-para kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Go raburi Pita-me Yesu raita maa ipisa pare re-para naipisa. Nipu Gote-na lodo kira-ae ali kalununa epe pokaalo ada ru-nane puma pirisa. Nipu plisman-nu raapu komea-para piru repena adola pisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Go raburi Gote-na lodo kira-ae ali mudunu page kaunsil alinumi page nimu raayome Yesu lu makomaalalo pisimi-pulu pa kama makirae agale mulalo pirisimi. Go-rupa pirisimi pare nimumi koe ele ora komea-daa na-adisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Enaali adaapumi Yesu madaa makirae agale lo pirisimi pare agale rado rado lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Go-rupa pisa-pulu ali medaloma rekoma Yesu madaa makiraoma talo: ");
INSERT INTO kjs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nipumi go epe lotu ada kimi warili-airi kilipitua lisa raburi naame pagisima lisimi. Wala yapi repome lotu ada rado wariabalua lisa pare kimi nama-alua lisa. Go lisa raburi naame pagisima lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nimumi remaa lakalisimi pare agale rado rado lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Go rabu Gote-na lodo kira-ae ali mudumi nimu piri-para rekoma Yesu agaa gu-rupa misa: Nimumi ne madaa go agale lame-le agale mada na-abuti ya? ");
INSERT INTO kjs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Go-rupa lisa raburi Yesu pa piruma agale nalisa. Gote-na lodo kira-ae ali mudumi agaa wala gu-rupa misa: Nere enaali Raapu Pirape alina Si ya? Nere epe puri wi Gote-na Si ya? ");
INSERT INTO kjs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesumi talo: E, ni enaali Raapu Pirape alina Si yaa-pulu Gote-na ora ki-nane pitua nipuna puri mada adalimi. Ni yaa mole raapu madaa piruma epalua-daa adalimina. ");
INSERT INTO kjs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Go-rupa lisa raburi Gote-na lodo kira-ae ali mudumi Yesu ero agale lea kone suma nipuna mamina mea riripima talo: Ake pea-daa go ali madaa medana agale pagamono ya? ");
INSERT INTO kjs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nimimi nipuna ero agale pagamede. Nimina kone age ya? Go-rupa lisa rabu enaalinumi nipu lu makomaape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Go-rupa pisa raburi enaalinumi Yesuna yogale madaa supi raa piaoma nipuna le agaa suma gu-rupa lisimi: Aapimi ne lea? Abi la. Go-rupa lisimi raburi plisman-nu page nipuna to yogale lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Go lisimi raburi Pita-me Ali Mudu-na ada pape ru-nane pua pirisa. Go rabu Gote-na lodo kira-ae ali muduna kogono ena meda ipisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Epenaloma Pita-me adisa-pulu go ename nipu waru adaba suma talo: Ne page go Nasaret su-para piri ali Yesu raapu piriside. ");
INSERT INTO kjs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yapare Pita-me dia loma gu-rupa lisa: Nena agalere neme napagoma namakuaato lisa. Go raburi ada perali-nane puma pora gaape-nane pisa. Go-para pulaina yaa gulame agale lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Go-nane pisa raburi kogono pape ename Pita adoma pa piri enaalinu-para lakalisa: Go aliri nipu Yesuna disaipel ali yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Go-rupa lisa pare Pita-me wala dia lisa. Wala werepe ogesi-daa pa piruma enaalinumi Pita-para gu-rupa lakalisimi: Nere ora disaipel ali yade. Makirae agale nalape. Ne ora Galili su piri ali yade lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Go rabu Pita-me nimu-para ora yaa madaa makuaa puri paloma talo: Niri go leme ali maarea ni ora dia yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Go-rupa lisa rabu yaa kakarega wala rana laapo agale lisa. Go rabu Pita-me Yesuna agale wala makuaasa. Yesumi abala gu-rupa lakalisa: Yaa kakarega agale rana laapo tea raburi neme nina bi rana repo giyali lisa. Go agale makuaasa-pulu nipumi kodome komoma re waru lo pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gore wala yapi lapaasa rabu Gote-na lodo kira-ae ali mudunu page kone makuaae alinu page rekena agalena tisaa-nu page kaunsel-nu page nimu raayo piruma yada robesimi. Go-rupa pisa raburi nimumi Yesu kopeme adiala Pailat piri-para maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Go-rupa pirisimi raburi Pailat-me Yesu nipu agale lorapisa: Ne Juda alinuna ora ali mudu ya lisa. Nipumi Pailat-para talo: Ne ora lae lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Go-rupa lisa raburi Gote-na lodo kira-ae ali kalunumi Yesu madaa koe ele pinalo agale adaapu lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Go-rupa lisimi rabu Pailat-me Yesu-para agale wala gu-rupa misa: Ne agale mada nate ya? Nimumi ne koe ele pape kone adaapu madaa agale lame-le neme napagae ya lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Go-rupa lisa pare Yesu agale meda yako nalisa rabu Pailat-me kone adaapu kibu pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gore ade abuna Pasova yapina di raburi enaalinumi karapo ada pali ali komea kepeape kone wisa-pulu Pailat-me go-rupa pulalo pisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Go raburi karapo ada-parare gavman-na lore alinu pirisimi. Nimuna rikiranare enaali lu makomaasade ali meda Barabas pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Go raburi enaali adaapumi Pailat-para ipuma talo: Ne Pasova-na maali di madaare ali meda rapape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Go-rupa lisimi rabu Pailat-me nimu-para agale gu-rupa misa: Nimina kone akepu saleme? Nimi Juda alinuna ali mudu rapaalua ya? ");
INSERT INTO kjs_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Go-rupa lisa pare Pailat-me nimuna kone abala adisa. Nipumi Gote-na lodo kirape ali kalunumi Yesu madaa kudipa kone suma adialalo ipisimi-daa adisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yapare Gote-na lodo kira-ae ali kalunumi enaalinu mapogolasaasimi rabu nimumi Pailat-para Barabas ma-kepeaape agale lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Go-rupa lisimi raburi Pailat-me nimu agale wala misa: Gore nimina Juda ali muduri nipu madaa ake palua ya lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nimumi nipu-para wala yalaasimi: Repena polopea madaa lu makomaape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Go-rupa lisimi raburi Pailat-me nimu-para talo: Ake pea-daa ya? Nipumi koe ele meda nawia lisa. Yapare nimumi puri paloma gu-rupa lisimi: Repena polopea madaa tamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Go-rupa lisimi raburi Pailat-me enaalinu madaa pedo pisa-pulu nipumi Barabas kepeasa. Go-rupa puma Pailat-me Yesu repena kulimi luma enaalinumi repena polopea madaa linalo mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Go-rupa puma soldia alinumi Yesu gavman-na kose lape ada ru-nane maa puma soldia alinu medaloma page maa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Go raburi go alinumi Yesu madaa epe kale mamina mayamaaoma kalu madaa kope keto keto muma raguna wariaoma ma-adipeasimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Go-rupa pirisimi raburi nimumi nipu madaa maraakepeae agale gu-rupa lisimi: Ne Juda enaalinuna ali mudu-le ade abuna epe-rupa pirape lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Go-rupa loma nimumi Yesuna kalu repena kulimi luma supi raa piaoma rumu pege puma adainaaoma mapiraasimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Gore nimumi nipu madaa giri laasimi raburi nipuna epe kale mamina koloma ora nipuna mamina mayamaasimi. Go-rupa pirisimi raburi repena polopean talo maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Go-rupa pirisimi raburi pa ali medana biri Saimon nipuna su Sairini giyoma pa ipisa rabu nimumi go ali repena polopea pasaane mariaasimi. Go aliri nipu Aleksanda-para Rufus-para go naaki laapona aaraa nipu Sairini su-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Go raburi nimumi Yesu Golgota su-nane lamua pirisimi. Go Golgota su biri adaa agale madaare kalu kuli rogaae su leme. ");
INSERT INTO kjs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Maa pisimi raburi nimumi nipu koe rero pi ipa kalalo pirisimi pare giyesa. Go ipare wain-para rero pi ele meda raapu perekema kalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Go-rupa pumare nimumi Yesu repena polopea madaa lisimi. Go-rupa pumare nimumi nipuna mamina-nu komea komea lo muma satu-rupa talalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gore go naare pena opalaina Yesu repena polopea madaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Go lisimi raburi nimumi kose lape agale pepa madaa gu-rupa lisimi: Go aliri Juda alinuna ali mudu yade lo lu wisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Go-rupa pirisimi rabu Yesu paake ne ali laapona rikirana luma ali meda ora ki-nane lu ali meda koya ki-nane tyalepa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Go-rupa pisimide konere Gote-na buk madaa abala gu-rupa lu wisa: Nipu koe paake ne ali raapu mapiraasimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Go-rupa pisa rabu pora one lobasa apone lobasa enaalinumiri nimuna kalu ma-wage alo puma ero agale gu-rupa lisimi: Neme lotu ada kilipima yapi repome wala ma-aulua abala liside. ");
INSERT INTO kjs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nena gole ne raba mea. Abiri repena polopea giyoma su kamaa nipu lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gote-na lodo kira-ae ali mudunu page rekena agale tisaa-nu page nimumi Yesu-para ero agale gu-rupa lo pirisimi: Nipumi enaali medaloma raba muma ade abuna mapiraasa-daa nipuna gole nipu raba muma ade abuna pirinalo adamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Go aliri enaali Raapu Pirape Ali page Israel ali mudu page nipu go-rupa pia-pulu go repena polopea giyalia-daare naame nipu madaa kone rulamina lisimi. Go repena polopea meda madaa madisimi ali laapome page Yesu-para arere lisipi. ");
INSERT INTO kjs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gore naare rikirana aasa rabu go su raayo ribaa yabaasa. Go-rupa puma su raayo ribaa loma puma naare nogo-nane pabola pupulaina yapi wala lapaasa. ");
INSERT INTO kjs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Go naare pabola popesa raburi Yesumi puri paloma gu-rupa yalisa: Eli Eli laama sabaktani lisa. Go adaa agalemere gu-rupa lisa: Naa Aapa Gote neme ni ake pea-daa giyae pe lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pa piri enaali medalomanu pagoma gu-rupa lisimi: Gore nipumi Elija yalaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Go-rupa lisa raburi ali komea wagepu ipuma lubi eleme rero pi ipa paba palae repena kuni-nane rukao palaoma nenalo kalisa. Yesu kaloma gu-rupa lisa: Adobape. Elija-mere nipu repena polopea madaa kepeaalia yapae naame adamono lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Go-rupa lisa raburi Yesu agale puri palo yaa loma pu nimu kudunasa rabu komisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Go-rupa pisa raburi lotu ada-para maitabae mamina so kuni-nane riripu taboma none kuni-nane puma riripi tabisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Go-rupa pisa raburi mo soldia ali mudumi Yesu le kadupia adisa-pulu gu-rupa lisimi: Go aliri Gote-na Si ora ria yade lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Go-rupa pisa rabu ena adaapu mo-para piruma adisimi. Ena medare Maria nipuna adare Makdala su-para pirisa. Ena medare Maria nipuna si Jems-para Joses-para nimu raapu pirisimi. Ena meda Salomi page pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abala Yesu Galili su-para pirisa raburi mo enaalinumi nipu raita maa puma nipu raba misimi. Ena medalomanuri Yesumi Jerusalem su-para giyoma ipisa rabu nimu raapu meda ipisimi enaalinu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gore ribaa yolalo palaina Arimatea su-para piri ali Josep ipisa. Go aliri ora epe kaunsil ali pirisa. Nipumi Gote-na Surube Yapi di epenalo adolalo pirisa. Nipu ipisa rabu ekera-nanere Pomo mu Pirape Yapi yaa-pulu nipumi Pailat piri-para puma Yesuna ro rogaaita ponolo puma kogelisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gore kogelisa raburi Pailat-me Yesu abala le kadupilisa lo napagesa. Go-rupa pisa-daa nipumi soldia-na surube ali meda yaaloma gu-rupa lakalisa: Mo ali le kadupia pe loma agale lorapisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gore yada pape surube alimi e lisa, ora komaade lisa-daa Pailat-me Josep gu-rupa lakalisa: Yesuna ro mada mula pope lisa. ");
INSERT INTO kjs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Go-rupa lisa raburi Josep-me kaake pi mamina muma ro rogaaoma kana apedaa tapa-para rogaasa. Nipumi rogaabaoma pora gaape-nane kaname pora poaniaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Go-rupa pisa raburi Makdala su-para piri Maria-me page Josep-na agi Maria-me page Yesuna ro mo mea rogaasa-para adisipi. ");
INSERT INTO kjs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gore Pomo mu Pirape Yapi dia naloma Makdala su-para piri Maria-para Jems-na agi Maria-para Salomi-para epe kaa pi wabala meda kabesimi. Nimumi Yesuna ro madaa sula pisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gore adaa korona ribaa reko rabu go enanu kana apedaa tapa-para adola pirisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Go-rupa pirisimi raburi nimumi agale gu-rupa laari simi: Aapimi pora gaape kana mea lusuma rubalia pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Go-rupa lisimi raburi nimumi adasaaoma adisimi pare kana lusuma rube adisimi. Go kanare ora adaalepe. ");
INSERT INTO kjs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gore nimumi kana apedaa tapa-para kodobatalo puma nimuna popoke-nane penaali meda adisimi. Nipuna kaake pi mamina yamoma pirisa. Adisimi raburi ora paala komoma pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Go-rupa pisa pare mo naakimi nimu-para talo: Paala nakomalepape. Nimimiri Nasaret su-para piri Yesu aasa pula epamede makuaato. Go aliri repena polopea madaa tamede. Yapare nipu abala laade-rupa rekaa puma go-para napia. Adalepa, go-para abala rogaarimide. ");
INSERT INTO kjs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yapare nimi abi puma nipuna disaipel alinu-para Pita-para nipu Galili su-para abala puma pirina laketapape. Nipumi nimi abala lakalesa-rupa go su-para mada adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Go-rupa lisa raburi nimumi kana apedaa tapa giyoma wagepu pisimi. Pirisimi rabu ora pururu aoma paalame komisimi. Nimu paalame komisimi-pulu enaalinu abi napuma lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Go-rupa pisa raburi Yesu adaa korona yapipu rekesa. Rekesa raburi Makdala su-para piri Maria-me Yesu abala adisa. Go ena madaare Yesumi koe remo ki medane luma medane laapo abala ma rubaasa. ");
INSERT INTO kjs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Go enamere nipu puma Yesuna adaami enaalinu-para lakalisa. Nimumi kodo komoma re lo pirisimi rabu lakalisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yapare ename neme Yesu adaoma pa pia lakalisa rabu nimumi kone narulalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Werepere Yesuna disaipel ali laapo pulaaoma ipisa raburi nipuna to rado pi nona pi pirisa. Go rabu go ali laapore su kamaa pora pagina pisipi. ");
INSERT INTO kjs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Go-rupa puma go ali laapome enaali medaloma-para puma lakalisipi pare nimumi go agale madaa kone narulalisimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wala werepere disaipel ali 11-pela rapuluma madaa eda no pirina Yesu ipisa. Gore abala enaali medalomame nimu-para Yesu pa pia epa lakalisimi pare kone narulalisimi go agale lo robaa-para nakodabasimi-pulu nipumi nimu mo lagiame agale madaa kone narulaasimi. ");
INSERT INTO kjs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Go raburi Yesumi nimu-para talo: Su ada raayo-nini puma enaali raayo-para epe agale puma lakelape lisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Enaali raayome go agale madaa kone rulaoma kalu-ipa mumare ade abuna kagaa piramala palimi. Pare enaali raayome go epe agale madaa kone narulalimi-daare pupitagi ne kone madaa koe kedaa mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kone rulae enaalinumi puri muma gu-rupa palimi: Naa bi loma koe remo maraita pealimi lisa. Nimumi abala napage adaa agale radonu page leme. ");
INSERT INTO kjs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nimumi kero ripinaalimi rabu nakomalimi. Nimumi romo maalu ipa nalimiri ora nakomalimi. Nimumi yaina kome enaalinu kaluna kimi waraalimi rabu perekealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gore Ali Mudu Yesumi nimu-para agale gu-rupa lakenaloma so yaa-para maa pisa. Go-rupa pumare Gote-na pope ki-nane pirisa. ");
INSERT INTO kjs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Go-rupa pisa raburi disaipel alinumi su raayone puma epe agale mogelesimi. Go-rupa pirisimi raburi Ali Mudumi nimu raba muma puri kalisa. Puri kalisa rabu nipumi disaipel alinumi agale pamu lo napi page pamu pirisimi enaalinu wai mulalo pirisimi. Go yade. ");
INSERT INTO kjs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yesa Tiofilus: Abaladere Mudu enaali adaapumi naana rikirana Gote-me ma-opasaade elenu pepa madaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gore ora ririna rabu go elenu adoma epe agale lakalisimi enaalinuna agale pagisimi. Nimumi naa lagisimi agalere ali adaapumi pepa madaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Go-rupa pea-pulu ali mudu Tiofilus-re neme page go remaa raayo pepa madaa luma ne piri-para rapaalua kone sawa. Go remaana re raayo madaa kone waru makuaaoma epe-rupa tyaato. ");
INSERT INTO kjs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gu-rupa tyaato-le neme apo agale raayona re makuaaoma kone re lainalo pepa lu rapaato. ");
INSERT INTO kjs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judia su-para ali mudu pirisa rabu Gote-na lodo kira-ae ali meda Sekaraia pirisa. Nipuri Gote-na lodo kira-ae ali meda Abaisa ruruna rikirana pirisa. Sekaraia-na werena biri Elisabet. Go ena page Gote-na lodo kira-ae ali ruruna ru-nane piruma madisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Go rapaayare Gote-na le agaana epe-rupa piruma rekena agale raayo pagoma epe-rupa pirisipi. Nipu laapome Ali Mudu-na agale waru pagoma epe-rupa ora pirisipi. ");
INSERT INTO kjs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pare Elisabet-re enagae pirisa-pulu nipu nogo naaki namaitisa. Go-rupa puma nipu ora enagae yomagae laapo pirisipi. ");
INSERT INTO kjs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Koro medare Sekaraia nipuna ruru alinu epa kiritaoma Gote-na kogono pulalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Go rabu lodo kira-ae alinuri nimumi ele kaas-rupa lumare alina reke madaa lodo kiritalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sekaraia-me Gote-na lotu ada ru-nane lodo kiratalo pirina enaali adaapu ada pera-le beten puma lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekeraia ru-nane pisa rabu Ali Mudu-na ensel meda so lodo kira-ae kana reke pope ki-nane epa rekesa. ");
INSERT INTO kjs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gore Sekaraia nipumi mo ensel adoma ora paalame waru komoma pogolasaasa. ");
INSERT INTO kjs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Go raburi ensel-me talo: Sekaraia, neme paala nakomape. Gote-me nena beten abala pagaa. Nena ename naaki matia. Nemere go naakina bi Jon ma-aape. ");
INSERT INTO kjs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Go raburi ne pedo puma raana waru komali. Nipu mati raburi enaali adaapumi nipu madaa pedo palimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gore nipu piralia rabu Ali Mudu-na ora ali mudu piralia. Nipumi ipa wain-para puri pale ipa bia nanalia. Nipuna agina lo robaa-para piralaina Gote-na Holi Spirit nipu madaa rubitabalia. ");
INSERT INTO kjs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mo Gote-na ruru Israel su-para piri enaali adaapumi kone perekema nimuna Mudu Gote madaa kone rulaliminalo Jon-me agale laketea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nipumi Elija-na kone mogeama puri waru paboma Mudu Ali piruma Gote-na agale laketea. Go-rupa pumare Jon-me agi aaraanumi nimuna nogo naaki epe-rupa mapiraalia. Nipumi agale yokeme enaalinuna kone ma-epeaaoma Ali Mudu-na epaliade yapi di madaa kone suma adoma pirinalo laketea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Go raburi Sekaraia-me ensel gu-rupa lakalisa: Neme go agalere ake puma ora lae kone salua ya? Saa ora enagae yomogea pipa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Go-rupa lisa rabu ensel-me Sekaraia-para gu-rupa lakalisa: Niri Gebriel. Neme Gote-na le-aga madaa rekaayo. Go-rupa pe-pulu Gote nipumi ni mea rapaaripa-daa neme ne go epe agale lagialuame epa pi. ");
INSERT INTO kjs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gore go agalena re ora palia pare neme go agale kone narulaale-pulu neme agale mada nate. Ne maara palae ali pirumare ora lagiawade agalena re opaliade raburi nena agale lapali lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia ada ru-nane adaalupu pirisa-pulu enaali raayome kone adaapu suma adobasimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gore nipu werepe kamaa-nane ipisa pare mo enaalinu agale mada nalakalaasa-pulu nipumi nimu adenalo pa ki maalame robo wisa. Nipu agale maare ali pirisa-pulu enaalinumi nipu lotu ada ru-nane upaa-rupa adisa-pulu makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wala werepere Sekaraia nipuna lodo kira-ae kogono pi yapi di dia lisa raburi nipuna ada wala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Werepe nipuna ena Elisabet naaki eke supumi padaa piruma kaledesa. Go rabu nipumi talo: ");
INSERT INTO kjs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Abiri Ali Mudumi ni madaa kodome komoma ni-para go-rupa pea. Gore abalade naaki napirisa rabu enanuna le-aga madaa yala polisua pare abi epelea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eke-alu 6-pela popesa rabu Elisabet naaki padaa abala pirina Gote-me ensel Gebriel mo Galili su robo ru-nane adare Nasaret-para penaalisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nipumi ena maapua meda piri-para pisa. Abalade go enare ali meda Josep-me rumaalalo ele kalabasa. Go aliri kasua Devit-na rurumi madi ali pirisa. Ena inamapuana biri Maria. ");
INSERT INTO kjs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Go rabu ensel mo ena Maria piri pumare go ena epe-rupa pirape lisa. Ali Mudumi nere kodome komoma ne raapu komea-para pia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ena Maria-me go ensel-na agale pagoma kone adaapu wisa. Go alina agalere akepu lena kone suma kedaa waru komisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Go raburi ensel-me Maria lakalisa: Neme paala nakomape. Gote-na konemere ne puri meainalo pi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Waru paga. Neme naaki padaa piruma naaki meda madi. Nipuna biri Yesu ma-aape. ");
INSERT INTO kjs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Go naaki nipu Mudu Ali piralia rabu enaalinumi nipu so yaa madaa pia Gote-na Si teme. Gore Gote-me nipu kasua Devit-na ruruna ora ali mudu mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nipuri Jekop-na ruruna ali mudu page ade abuna piralia. Go puma nipuna Surube Yapi di ora nadia yaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Go lisa rabu Maria-me mo ensel agale abulisa: Go naakiri ake puma maitialua ya? Neme ali page meda abi nape-le. ");
INSERT INTO kjs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Go raburi ensel-me gu-rupa lakalisa: Holi Spirit-mi ne madaa ipuma Gote-na puri ora so madaame ne waru surubalia. Go palia-pulu werepe go naaki neme mati. Gore enaalinumi go epe naaki nipu epe ali loma Gote-na Si teme. ");
INSERT INTO kjs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gore paga. Nena kai Elisabet abala enagae yapare nipuna lo robaa-para naaki meda pia. Abalare enaalinumi gu-rupa lisimi: Nipumi nogo naaki mada namaitia lisimide pare abi nipuna suba 6-pela popea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gore Gote-me napeape elere meda ora nawia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Gore Maria-me talo: Pagape. Niri Mudu Ali-na kogono ena yaa-pulu neme go lae elenu pa pinawa lisa. Go lisa raburi ensel-me pagoma wala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gore werepe Maria nipu rekoma wagepu so rudu-nane ae adare meda Judia pisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nipu puma no Sekaraia-na ada-para puma kodobaoma Elisabet-para epe naare pa lo agale puma lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet-me no Maria-na agale pagisa raburi mo Elisabet-na lo robaa-para piri naaki pogolasa. Go rabu Elisabet madaa Holi Spirit rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Go rabu Elisabet-me Maria-para puri paloma gu-rupa lisa: Robaa-para pirina page nipu epe puri mealia. ");
INSERT INTO kjs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Go rabu ename talo: Neme epe kogono napede ake paa-daa Mudu Ali-na agi ni adola epaa? ");
INSERT INTO kjs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pagape. Nena agale pagawade rabu no lo robaa-para piri naakimiri pedo puma popa pogolaade. ");
INSERT INTO kjs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mudu Alimi abalade ne lagisade agalere neme go ora adolalo pi lisa. Go pe-le neme raaname komape. Elisabet-me apo agale gu-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Gore Maria-me talo: Naa konemere Mudu Ali-na bi minasaayo. ");
INSERT INTO kjs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Go puma nina Raba Meape Ali Gote madaa pedo waru pe. ");
INSERT INTO kjs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Niri nipuna kogono ena madaare nipumi ni kodome komoma raba mu aaya. Gote-me puri pale epe ele medaloma ni madaa mea epea-pulu abi page werepe page go puri pale Gote-me ni raba mealia. Go pea-pulu enaali raayome ni ora epe ena teme. ");
INSERT INTO kjs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Go pea-le nipuna biri adae abuna epe aalia. ");
INSERT INTO kjs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Enaali raayome nipuna agale waru pagoma paala komalimiri nipumi adae abuna epe raba mi kone kalalo pia. Go pea rabu adae abuna madini-mi enaalinu madaa go kone salia. ");
INSERT INTO kjs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nipumiri abalade napi kogono pisaaya. Go rabu nipumi kone pogali enaali medaloma ralu lisaaya. ");
INSERT INTO kjs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nipumi su kamaa ali mudu puri pale alinu rabuaanaaoma enaali naaralinuna bi minasaasaya. ");
INSERT INTO kjs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Enaalimi nipuna agale pagolalo kone wimi enaaliri nipumi ele waru mea kalo aaya. Pare nipumi kamope enaalinu giyoma ele nakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Naana kasuanu-para kana waraaoma lakalisa agale nagiyasa. Nipumi naa Israel su-para piri kogono enaalinu raba mulalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Go yapare nipumi Abraham-para nipuna werepe madina naakinu-para adae abuna kodome komoma raba mu aaya lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet raapu Maria nipu suba repo pirisa pare werepe wala nipuna ada pisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet-na naaki maitape di raname lisa raburi mo naaki Jon madisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet nipuna rurunu-para nipuna adare komea-para piri enaalinumiri Elisabet naaki maitaade remaa pagisimi. Gore Mudu Alimi nipu kodome komoma raba misa-pulu nimu Elisabet raapu ranaa komo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gore yapi 8-pela pa pirumare mo naakina yogale rugulalo pisimi. Nipuna biri aaraana bi-rupa Sekaraia talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Go lisimi pare mo naakina agimi dia lisa. Nipuna biri Jon lamina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Go rabu nimumi talo: Nena kai aapa page nena ruru page go-rupa bi ma-ae meda dia yade lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Go rabu nimumi aaraa agaa mulalo pa kimi robo suma agale lorapisimi. Nipumi mo naakina biri akepu bi ma-aalia pe kone suma agale lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraia-me pepa tyape ele meda maa gialepa loma gu-rupa pepa madaa lisa: Go naakina biri Jon lu lisa. Go lisa raburi mogo pisimi enaalimi kone adaapu wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Go kone adaapu saapirinare mo Sekaraia-na agale lapaasa. Go rabu nipuna agale namaareasa raburi nipumi agale lapaoma Gote-na bi minasaasa. ");
INSERT INTO kjs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Go raburi mo nimuna adare komea-para pirisimi enaalimiri paalame komisimi. Go remaare Judia su raayona pagisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Enaali raayome go agale kone-para su kiraloma nimu kone adaapu wisimi. Nimumi gu-rupa lisimi: Werepe go naakimiri ake palia pae? Gore mo naaki madaa Mudu Alimi puri kalisa adisimi-pulu go-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Go rabu Holi Spirit aaraa Sekaraia madaa rubitabenaloa nipumi Gote-na lakale agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Naamere Israel su-para piri Gote ora Mudu Ali-na bi minasalimina. Nipu ipuma nipuna enaali raba mula epe-rupa. Go puma naa kepeasa. ");
INSERT INTO kjs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nipumi nipuna kogono ali Devit-na ruru-para naaki mapiraasa. Nipumi go puri pale Raba Meape Ali mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ora abalade go agalere Gote-me nipuna agale lakale alinu gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nipumi naana lore alinumi natinalo raba mealua lisa. Gore enaali raayome rono pagoma naa timiri nimuna puri mada mea kepealua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nipumi naana kasuanu madaa kodome komoma raba mealua lisa. Gote-me Abraham agale lakalisa waru makuaaoma makuaasa. ");
INSERT INTO kjs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Go rabu Gote-me yaa madaa makuaa loma kasua Abraham-para agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nimina lore alinuna puri madaa koe-rupa pitimiri kepealua lisa. Go pumare paala nakomalimi pare kogono waru palimi lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Go pea-le adae abuna naa piralima rabu nipuna le-aga madaa kogono waru pu epe kone su piralima. ");
INSERT INTO kjs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Go naaki nere werepere so yaa-para pia Gote-na agale le ali piraina teme. Ne Mudu Ali-na ripina puma nipuna pora kiritao saena. ");
INSERT INTO kjs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Go rabu nipumi enaalinuna pupitagi ne kone mea ruboma adae abuna kagaa pirape kone meaminalo laketea. ");
INSERT INTO kjs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gore naana Gote-re pawa piruma kodome komoma raba meape kogono pea. Go pea-le nipumi so yaa-para wi paa naa madaa epena tea. Go epe pare naare opea-rupa naana lo robaa-para ma-epaalia. ");
INSERT INTO kjs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Go puma so yaa-para wi pare komape kone su koe-rupa piri enaalinu madaa mea katea. Go puma naa epe-rupa pirape pora pamuamonolo paa gialia. ");
INSERT INTO kjs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Werepe go naaki Jon adaa yoma nipuna kone waru puri paboma pirisa. Go rabu nipu enaali napiri su-para puma pirisa. Werepe Israel su-para piri enaalinumi adalimide yapi rabu nipu go su giyoma opapaasa. ");
INSERT INTO kjs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Go raburi Rom su-para piri ali mudu Sisar Ogastus-mi puri pale lo meda wisa. Nipuna surube enaali raayona bi pepa madaa tyalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gore pena ripia bi pepa madaa lisimi raburi Kwirinius-ri nipu Siria suna namba wan gavman ali pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Go pumare enaali raayona bi pepa madaa maa sulalore nimuna adare-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep-re nipu Nasaret su-para pisa. Nipu ali mudu Devit-na ruru pirisa-pulu nipu Galili su robo ru-nane puma adare Nasaret giyoma su Yutia-para pisa. Go su-parare kasua Devit-na adare Betlehem-para pisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nipuna ena Maria raapu bi pepa madaa mea lu sulalo pisipi. Go raburi Josep-me Maria pena rumaasa pare nipu naaki padaa abala pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nipu go su Betlehem-para pa pirina Maria-na naaki madini di rudu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Go rabu nipuna naaki mupaa maduma pa laplap-me mea kepema wisa. Go puma gawana eda nape kepo madaa mea madu wisa. Mo kimisu enaali paitala pi ada abala rulaitabesa-pulu gawana ada-para epa piruma madisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Go raburi go su-parare mena sipsip puni alinu medaloma adare-para kamaa aasimi. Gore nimumi ribaale-para nimuna sipsip mena surubisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gore Mudu Ali-na ensel meda nimu pirisimi-para ipisa-pulu nimumi adisimi. Go rabu Mudu Ali nipuna epe paana purimi nimu pirisimide-para epaa roasa. Roasa rabu nimumi paalame komo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Paala komisimi pare ensel-me nimu gu-rupa lakalisa: Nimimi paala nakomalepape. Pagalepa. Neme nimi piri-para epe agale meawa-pulu go agale madaare enaali raayome raaname komalimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Abi go ribaare Devit-na adare-para ena komeame nimi Raba meape Ali maitaade lisa. Go aliri ora Mudu Ali Keriso yade. ");
INSERT INTO kjs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nimimi nipuri gu-rupa adoma makuaalimi lisa: Nimi pumare naaki meda laplap-me rogaae adalepape. Nipu gawana eda ne kepo madaa apo mapaitaaeme-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel-me go-rupa lisa raburi ora wagepu so yaa-para ensel-nu ora adaapu nipu raapu epa pabo aoma Gote-na bi gu-rupa minasaasimi: ");
INSERT INTO kjs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","So yaa-para piri Gote-na biri ora minasalimina lisimi. Go su kamaa enaalinuri Gote-me pedo pea-le epe-rupa pirina lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel-numi mo alinu giyoma so yaa-para penaaloma mo mena puni alinu nimumi gu-rupa lala pirisimi: Abi Mudu Alimi naa abala lagiade-le wagepu go naaki maitana-para adamina ba lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nimu wagepu puma Maria Josep nipu laapo asa puma adisimi. Go rabu mo naakiri gawana eda ne kawaso madaa madu saabaena adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nimumi puma adoma abala so ensel-numi mo naaki madaa lakalisimide remaa lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mo enaali raayome sipsip puni alinuna remaa pagoma kone adaapu wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yapare Maria-me mogo agale raayo nipuna kone-para maa suma kone adaapu su pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mo sipsip puni alinu nimu wala pisimi rabu nimumi pagoma ademe ele madaa Gote-na bi minasaaoma yalisa lisimi. Go remaare mo ensel-numi lakalisimide-rupa adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Werepe yapi ru laapo penaloma mo naakina yogale rugula pirisimi. Go rabu nipuna bi Yesu maasimi. Go biri agimi mo naaki nipu madaa napirina ensel-me go bi lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Werepe Josep Maria laapome Moses-na rekena agale mogeama to yogale ruguliae pisipi. Go rabu page nipu laapome naaki so Jerusalem su-para maita puma Mudu Ali kalalo lamua pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Go kone madaare Mudu Ali-na rekena agale madaa go-rupa lisa: Enaalinumi naaki mupaa madu saoma palimiri go naakinuri Mudu Ali-na kogono pinalo naaki mea kalape. ");
INSERT INTO kjs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mo Mudu Ali-na rekena agale meda page mogealalo pisipi. Gore to yogale ruguli rekena agale gu-rupa wisa: Lodo kirilalo yaa puluma ipa laapo pa epe yaa laapo puma mea kirapa wisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Go raburi ali meda Simeon Jerusalem su-para pirisa. Go aliri ora Gote-na pora raluma epe ali pirisa. Nipumi Israel su-para piri enaalinu raba mu mapiraape di adoba pirisa. Simeon-re Holi Spirit-mi rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Holi Spirit-mi nipu-para agale gu-rupa lakalisa: Nere abi nakomali pare Gote-me nipuna agale loraae ali Mea Rapaae Ali abala adainalo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gore Holi Spirit-mi Simeon go kone kalisa-pulu nipu epe adaa lotu ada-para kodobasa. Go puma agi aaraame rekena agale madaa mogeama mo naaki Yesu adaa lotu ada-para mea ipisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ipisipi rabu Simeon-me mo naaki Yesu nipuna kimi kupima Gote-na bi minasaoma gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","O Mudu Ali, neme madaa kone suma agale loraae. Go pea-le ni nena kogono ali komano laa. ");
INSERT INTO kjs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Neme naa raba mulalo paenare nina leme go adalo. ");
INSERT INTO kjs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Neme enaali raayona le agaa madaa go yarera puma pe. ");
INSERT INTO kjs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Go epe paa komeamere ruru rado-para nena pora mea waatea. Go pumare naa nena ruru Israel enaalinu madaare enaali medalomame epe kone salimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon-me mo naaki-para agale lakalisa rabu agi aaraa laapo nipu kone adaapu wisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gore Simeon-me nimu epe puri pale agale lakelalaoma mo naakina agi Maria gu-rupa lakalisa: Pagape. Gote-me go naaki mapiraasa-pulu nipumi Israel su-para piri enaalinu adaapu makoyaalia. Go pea pare medaloma page adae abuna mapiraalia Gote-me nipu rado piale ali mapiraalia rabu enaali adaapumi nipu madaa koeyae teme. ");
INSERT INTO kjs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Go leme raburi go enaalinumiri nimuna pagaa wi kone mea waateme. Pare nena pu robaa-para kodo komape konere rai napimi-rupa awalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gote-na agale lakale ali ena meda Ana pirisa. Nipu Fanuel-na wane-le Aser-na ruru-para pirisa. Nipuna aali raapu maali ki medane luma medane laapo pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Werepe nipuna piru aasa. Nipumi adae abuna lotu ada nagiyasa pare Gote-na kogonore ribaale-para page naare paame page ora pu pirisa. Go rabu nipumi eda madaa imaa niti puma beten kama lala pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yesu Gote-para kalisimi rabu Gote-para ora pili lisa. Go puma nipumi mo naaki madaa remaa lakalisa. Gore enaali raayore Gote-me Jerusalem su-para piri enaali ma-kepeanalo adoba piru aaeme-para remaa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Agi aaraa laapome mo Mudu Ali-na rekena agale raayo lo kiraluma so Galili su robo ru-nane puma nipuna adare Nasaret su pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mo naaki nipu abala adaa yoma puri palasa. Go rabu nipu kone ora waru mealaina Gote-me puri page waru kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mo Yesuna agi aaraa laapo nipuri adae abuna maali patinaloma nipu so Jerusalem su-para puala pisipi. Go rabu Juda alinuna olode meda Pasova di adola pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Go raburi Yesu nipu maali 12-pela pirisa. Go raburi mo olode rudu lisa rabu so Jerusalem su-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Werepe so Jerusalem su-para puma kiritaomare mo olode dia naloma ada re-nane ipisimi. Pare mo penaali naaki Yesu nipu Jerusalem su-para pa pirisa. Pirisa pare nipuna agi aaraa laapomere na-adisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Agi aaraa laapo nipuna konere abala enaali medaloma raapu puana kone suma nipu pisipi. Pulaina yapi meda dia lisa pare naaki na-adisipi-pulu nipuna ruru-para adami alinu medaloma adola pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nipumi asa pirisipi pare ora pename napirisa. Go raburi nipu laapo wala Jerusalem su-para asa pula pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nipumi asapala pirina yapi repo pa popesa. Go rabu mo lotu ada ru-nane wala asa pama ipuma epa adasaasipi. Nipu Juda tisaa-nu raapu pirisa aaya. Nipumi nimuna agale pago nipumi agale medaloma agaa mulalo pirisa aaya. ");
INSERT INTO kjs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mo nipuna agale pagisimi ena alinumiri go naakiri kone adalrpe waru inaloma nimu pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Agi aaraa laapome nipu puma adoma pogolasaoma agimi talo: Go naaki. Ake paa-daa neme saa giyae ya? Nena aaraa saa laapona lo-parare kedaa ora waru pea. Saame ne asa pirapa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nipumi agi aaraa laapo gu-rupa lakalisa: Nipimi niri ake paa-daa asa pape pae? Nipiri naa Aapana ada-para pirulalo pawa kone nasape pae? ");
INSERT INTO kjs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nipumi saa pi agale lisa pare go agalena re namakuaasipi. ");
INSERT INTO kjs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gore nipu agi aaraa laapo raapu puma Nasaret su-para puma pirisimi. Go Nasaret ada puma piruma agi aaraa laapona agale epe-rupa pagoma pirisa. Nipuna agimi mode agale raayo kone-para maa su pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gore Yesu nipu adaa lisa raburi nipuna to yogale-para page kone page ora adaa lisa. Go puma nipu Gote-para su kamaa piri enaalinu-para nimuna kone-para ora epe naaki kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ali mudu Sisar Taiberias-re nipuna surube su maali 15-pela popesa. Go rabu Pontius Pailat-re so Judia su robo-para namba wan gavman pirisa. Go raburi Herot-re Galili su-para adaa gavman piruma nipuna ame Filip-ri Ituria-para Trakonitis su lapone ali mudu pirisa. Go rabu page Lisanias-re Abilini su-para adaa gavman ali pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Go rabu page Anas-para Kaiafas laapore Gote-na lodo kira-ae ali mudu laapo pirisipi. Go rabu Sekaraia-na si Jon nipu enaali napiri su-para pirina Gote-me nipu agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Go agale pagoma nipu ipa Jordan popea-para go su raayona agale pamu lakalisa. Pamisa rabu go enaali nimimi kone perekelema kalu-ipa mealepa lo lakalisa. Go palimi-daare Gote-me nimina pupitagi nape kone mea rubalia lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Go madaare Gote-na agale lakale ali Aisaia-me pepa madaa gu-rupa lisa: Enaali abuna napiri su-parare ali medame agale gu-rupa yaatea lisa: Mudu ali-na pora kiritao salepape. Nipuna pami poranu ma-redepo yatepape. ");
INSERT INTO kjs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Su kawaro raayo-parare su awo pabalepape. Rudu-para raayo kadolo rubalepape. Koi koi pi pora raayo ma-epeaatepape. Pora raayo madaa kana wiare mea rubalepape. ");
INSERT INTO kjs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Go pumare enaali raayome Gote-na adae abuna mapiraape kone mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Enaali adaapuri Jon-me kalu-ipa kalenalo ipisimi. Ipisimi raburi nimu gu-rupa lakalisa: Nimiri koe kerome madi enaalinu pimi. Gote-me nipuna rono pagape kone epalia-le nimimi giyalepape lo aapimi lagu aaya pa wisa? ");
INSERT INTO kjs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nimina koe kone perekealimi-daa adalimina-le epe kogono puma palepape. Nimina pa agaleme marekaaoma gu-rupa natapape: Abraham-re ora naana kasua pirisa-le kone naperekealima lo natapape. Pagalepa. Gote-me go aaya kanare ora Abraham-na sinu mada ma-aulaalia. ");
INSERT INTO kjs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Rai gaapi abala no repena re-para apo wia-daa epe repena kili waru namaitiare po ruma repena sulaa-para mea kiralia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nipumi go-rupa lisa rabu enaali adaapumi nipu agale lorapisimi: Naamere ake palima ya? ");
INSERT INTO kjs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Gore nimu-para agale gu-rupa lakalisa: Ali medame mamina laapo saliare ali meda mamina nasaliare go ali kalape. Eda nape ele salia alimi page go-rupa rumaape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kana takis mi ali medaloma page nimu kalu-ipa mulalo ipisimi. Go puma nipu agale lorapisimi: Tisaa, naame ake palima ya? ");
INSERT INTO kjs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nipumi nimu lakalisa: Kana-re so gavman-me lea-rupa mealepape. Nimina kone suma meda pa namealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldia ali medalomame page Jon nipu agale lorapisimi: Naame ake palima ya? Gore nimu gu-rupa lakalisa: Nimimi paaoma kose natapape. Go page makirae agale naloma enaalinuna kana paake namealepape. Ora nimina kogono madaa kana mealimi-rupa gu-rupa mada kone suma mealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Go epe agale adaapu lakalisa-pulu enaalinumi kone puri paloma suma gu-rupa wisimi: Go Jon-re Gote-na Mea Rapaae Ali yapae dia yapae kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kone gu-rupa wisimi raburi Jon-me nimu gu-rupa lakalisa: Neme nimi madaa pa ipame kalu-ipa mu aayo pare werepe ali meda epaliare nipuna purimi ni ma-oge yaalia. Nipu ora epelea-pulu neme nipuna age ada kepema kege radepetalo palua. Pare nipumi kalu-ipa epa mealia rabu Holi Spirit-na puri repena sulaa nimi kalu-ipa gialia. ");
INSERT INTO kjs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nipuna lama nipuna kimi ripinuma epalia. Nipuna wit-na kili rilipu raapu raloma epe elenu kiritape ada-para sulalo palia lisa. Pare mo wit-na kili koyaliade-nuri nakudinape repena sulaa-para mea lopalia rabu pa roalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon-me nimuna kone ma-redepo yaatalo epe agale rado rado lakeloma mogealisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Go agale lakalisa pare Jon-me ali mudu Herot-para nena paa pia amena were Herodias nayolo meaape lo lakalisa. Go page Herot-me pisa koeyae raayo madaa agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Go pisa-pulu Herot-me go agale madaa yala poloma karapo ada-para mapaitaasa. ");
INSERT INTO kjs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Enaalinu raayo kalu-ipa misimi rabu Yesu nipu page kalu-ipa misa. Nipu kalu-ipa muma beten lala pirina yaa pora lobesa. ");
INSERT INTO kjs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Go puma Holi Spirit yaa puluma so yaa giyoma ipisa. Gore Yesu madaa ipisa raburi so yaa-para agale meda gu-rupa pagisimi: Nere ora nina epe Si. Neme ne madaa ora pedo pi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu nipuna kogono mea ripia pisa raburi nipuna maali 30-pela pirisa. Enaali raayomere nipu Josep-na si makuaasimi. Gore Josep-na aaraare Heli. ");
INSERT INTO kjs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nipuna aaraare Matat pirisa. Matat nipuna aaraare Livai pirisa. Livai nipuna aaraare Melki pirisa. Melki nipuna aaraare Janai pirisa. Janai nipuna aaraare Josep meda pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nipuna aaraare Matatias pirisa. Matatias nipuna aaraare Amos pirisa. Amos nipuna aaraare Nahum pirisa. Nahum nipuna aaraare Esli pirisa. Esli nipuna aaraare Nagai pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nipuna aaraare Mat pirisa. Mat nipuna aaraare Matatias meda pirisa. Matatias nipuna aaraare Semen pirisa. Semen nipuna aaraare Josek pirisa. Josek nipuna aaraare Joda pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nipuna aaraare Joanan pirisa. Joanan nipuna aaraare Resa pirisa. Resa nipuna aaraare Serubabel pirisa. Serubabel nipuna aaraare Sealtiel pirisa. Sealtiel nipuna aaraare Neri pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nipuna aaraare Melki pirisa. Melki nipuna aaraare Adi pirisa. Adi nipuna aaraare Kosam pirisa. Kosam nipuna aaraare Elmadam pirisa. Elmadam nipuna aaraare Er pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nipuna aaraare Josua pirisa. Josua nipuna aaraare Elieser pirisa. Elieser nipuna aaraare Jorim pirisa. Jorim nipuna aaraare Matat meda pirisa. Matat nipuna aaraare Livai meda pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai nipuna aaraare Simeon pirisa. Simeon nipuna aaraare Juda pirisa. Juda nipuna aaraare Josep meda pirisa. Josep nipuna aaraare Jonam pirisa. Jonam nipuna aaraare Eliakim pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nipuna aaraare Melea pirisa. Melea nipuna aaraare Mena pirisa. Mena nipuna aaraare Matata pirisa. Matata nipuna aaraare Netan pirisa. Netan nipuna aaraare Devit pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit-ri nipuna aaraare Jesi pirisa. Jesi nipuna aaraare Obet pirisa. Obet nipuna aaraare Boas pirisa. Boas nipuna aaraare Salmon pirisa. Salmon nipuna aaraare Nason pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nipuna aaraare Aminadap pirisa. Aminadap nipuna aaraare Atmin pirisa. Atmin nipuna aaraare Arni pirisa. Arni nipuna aaraare Hesron pirisa. Hesron nipuna aaraare Peres pirisa. Peres nipuna aaraare Juda meda pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nipuna aaraare Jekop pirisa. Jekop nipuna aaraare Aisak pirisa. Aisak nipuna aaraare Abraham pirisa. Abraham nipuna aaraare Tera pirisa. Tera nipuna aaraare Nahor pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor nipuna aaraare Seruk pirisa. Seruk nipuna aaraare Reu pirisa. Reu nipuna aaraare Pelek pirisa. Pelek nipuna aaraare Eber pirisa. Eber nipuna aaraare Sela pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nipuna aaraare Kainan pirisa. Kainan nipuna aaraare Arpaksat pirisa. Arpaksat nipuna aaraare Siem pirisa. Siem nipuna aaraare Noa pirisa. Noa nipuna aaraare Lamek pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nipuna aaraare Metusela pirisa. Metusela nipuna aaraare Enok pirisa. Enok nipuna aaraare Jaret pirisa. Jaret nipuna aaraare Mahalalel pirisa. Mahalalel nipuna aaraare Kenan meda pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nipuna aaraare Enos pirisa. Enos nipuna aaraare Set pirisa. Set nipuna aaraare Adam pirisa. Adam nipuna aaraare Gote pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Holi Spirit Yesu nipu madaa rubitabenaloa Yesu nipu ipa Jordan-na giyoma pisa. Go rabu Holi Spirit-mi enaali napiri su-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mo enaali napiri su-para Yesu nipu yapi 40-pela pirina Satan-me pupitagi manaalalo kolisa. Go raburi Yesu nipu eda ora nanisa-pulu go yapi raayo dia naloma Yesu nipu reame komisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gore Satan-me Yesu-para talo: Nere Gote-na Si yalore go kananu bret wapuama mea na lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Go rabu Yesumi Satan nipu-para gu-rupa lakalisa: Gote-na agale wi buk madaa gu-rupa wia lisa: Enaali bret kama nanalepape. Dia, pare Gote-na agale raayo pagoma adae abuna pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Go rabu Satan-me Yesu upaa mapaaoma sone lamua puma wagepu su kamaa piri enaali raayo ma-adaasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Go pumare Satan-me Yesu nipu lakalisa: Go su kamaa piri enaalinuri go puri raayo-para nimuna epe ele raayo neme ne mada gialua. Go elenu raayore ni misude yaa-pulu neme ali meda kalalo paluare mada palua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gore go ada elenuri ni madaa rumu pege puma beten te-daare raayo ne gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesumi talo: Gote-na agale wi buk madaare gu-rupa wia: Nimimi Adaa Gote komeana bi minasaoma nipuna kogono komea palepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wala Satan-me Yesu nipu so Jerusalem su-para lotu ada madaa maa puma puaa mapiraasa. Go-para mapiraasa rabu Yesu-para talo: Nere ora Gote-na Si yaaliare go-pare aoma no su kamaa pogola. ");
INSERT INTO kjs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Go madaare Gote-na agale wi buk-mi gu-rupa lea: Nipuna ensel-nu laketea raburi nimumi ne waru surubalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gote-na buk-mi page gu-rupa lea: Go pumare nimuna kimi ripinaalimi-pulu kana eke medame nena age mada natia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Go raburi Yesumi agale gu-rupa lakalisa: Gote-na buk madaa agale meda gu-rupa wia: Nena Adaa Gote-na kone adolalo koyae natape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan-me Yesu ele raayo mea mapaitaalo kolisa pare werepe Yesu giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Go pisa rabu Yesu Holi Spirit-na puri waru misa. Go rabu nipu Galili su-para wala pisa. Nipuna remaare go su raayona abala pago kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Go rabu nimuna lotu adanu-para puma enaali agale mogeaasa. Mogeaasa raburi nimumi nipuna bi minasaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Go pumare Yesu nipuna Nasaret su-para puaoma pisa. Go adare-para nipu oge naaki rabu piruma adaa lisa. Go pisa raburi Pomo mu Pirape yapiri nipumi abalade pala pisa-rupa lotu ada-para puma Gote-na agale yarepeala aasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Go rabu nimumi Gote-na agale lakenalo Aisaia-na buk Yesu nipu mea kalisimi. No buk loboma agale meda asa pumare gu-rupa yarepeasa: ");
INSERT INTO kjs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Mudu Ali-na Holi Spirit-ri ni madaa epa pia. Nipumi ni mudu ali mapiraoma enaali naaralinu nipuna epe agale lakelanolo pisa. Nipumi ni mea epenalisa-daa koe adili enaalinu epe agale lakelalo ipisua. Nimu le koe enaalinu wala ma-epeaatalo ipisua. Nimu koe-rupa piri enaali raayo ma-kepeaatalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mudu Ali nipuna enaalinu epe-rupa mapiraape yapi lakele. Go kogono madaare nipumi ni mea epenalisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesumi apo agale pepa madaa yarepe kiratainaloma buk mogaoma mo buk suruba-ae ali kalomare nipu agale lakelalo pirisa. Go pumare mo lotu ada-para pirisimi enaalimiri nipu komea adoba wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gore nimu agale ririnaoma lakalisa: Abiri go agale ririnaoma rabu pagamedere Gote-na agalena rere ora gu-rupa epaade. ");
INSERT INTO kjs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Go raburi enaalinumi nipu madaa epe kone suma nipuna ora epe lakale agale madaa ora raaname komisimi. Go pirisimi pare nimumi talo: Go aliri Josep-na liside kone wima. ");
INSERT INTO kjs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Go rabu nipumi nimu-para talo: Nimimi saa pi agale pagalimi kone salo. Gore dokta nipuna abala yaina ma-epeaaya leme kone salo. Go leme kone salo: Neme Kaperneam su-para napi pawade remaa pageme. Go pea-le neme go naana adare-para page abi pape leme kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pagalepa. Gote-na agale lakale aliri nipuna adare-para go enaalinumi nipu epe-rupa nasurubeleme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Go pea-le nina agale waru pagalepa: Elaija pirisade raburi ena wasa adaapu Israel su-para pirisimi. Go raburi maali repo-para suba 6-pela popesa pare yai naipisa. Go-rupa pumare su raayona reae adaalepe pabesa. ");
INSERT INTO kjs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Go pisa pare Gote-me Elaija mo Israel ena wasanu piri-para nama-penaalisa. Dia, pare nipumi no Saidon su-para Sarefat adare piri ena wasaa-para mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Go pumare Gote-na agale lakale ali Elisa pirisa raburi Israel su-para yakilimi li enaali adaapu pirisimi. Go pisa pare nimuna rikirana komea nama-kaapu yaaoma epeasa. Dia, pare Siria su-para piri ali Neman-na komeare ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesumi agale gu-rupa lisa rabu mo lotu ada-para pirisimi enaalinumi go agale pagoma nimuna pu robaa-para rono pagesimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nimumi rono pagoma Yesu ripinaaoma nipu so adare-nane mea ralu lisimi. Go adare-re rudu meda madaa warisimi rabu go kari raita maa puma nipu lopatalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Go pisimi pare nipu enaali raayona rikirana puma wala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu nipu adaa su robo Galili-na adare Kapaneam-para pisa. Go Pomo mu Pirape Yapi rabu nipumi enaali raayo Gote-na agale mogealisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mogealisa rabu ora puri pale agaleme lakalisa-pulu enaalinumi ora paalame komoma ki kidipaa ragi lu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Go rabu mogo lotu ada-para ali meda pirisa. Go ali madaare koe remo meda piruma nipumi go ali ora puri paloma e rui gu-rupa malaasa: ");
INSERT INTO kjs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Aya, go Nasaret su-para piri ali Yesu-yo. Nere naa madaa ake pulalo epae pae? Nemere ne adede-le neme naa tulalo epae pae? Nere ora Gote-na epe agale lagiape ali yade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Go lisa rabu Yesumi remo-para agale mana talo: Neme agale loraoma go ali giyoma pu lisa. Go puma mo koe remome mo ali luma gona rikirana malopaaoma go ali giyesa. Go puma mo koe remome mo ali luma malopaaoma go ali giyesa. Go pisa rabu go ali wala namakeyasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Go rabu enaali raayome ki kidipaa ragi luma nimumi lakelala pu pirisimi. Ora puma agale gu-rupa lisimi: Go agalere ali agake ya? Go alimi nipuna mo koe remo madaa agale mana lakenaloma nimumi agale pagomare mo ali giyoma pula lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Go pisa raburi Yesu nipuna remaa go su raayona mone laoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nipu rekoma go lotu ada giyoma pumare Saimon Pita-na ada-para puma kodobasa. Mo Saimon Pita-na werena agiri riripu yaina ora koe meda komisa-pulu Yesumi raba minalo lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu nipu mo yaina kome enana reke re-para puma mo yaina-para rakepema lo agale lakalisa. Go rabu-le mo enana yaina perekelema pora pamuma nimuna eda ele kiritao saasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Naare pabola pupulaina enaali medalomana adami alinu yaina komisimi-pulu go alinu Yesu piri-para lamua ipisimi. Yesu nipuna ki mo enaali raayona kalu madaa saoma pisa. Go pumare nimuna yaina raayo ma-epeaama pisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mo koe remonumi enaali adaapu giyasimi rabu gu-rupa yalaasimi: Nere Gote-na Si lisimi. Gore remonumi Yesu nipu ora Gote-na Mea Rapaae Ali makuaasimi-pulu nipumi nimu-para agale nalaketapape loma maepeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ora abasade yapi lapaasa rabu Yesu go adare giyoma enaali napiri su-para pisa. Go pisa pare enaali raayome nipu wasuma puma piri-para ipisimi. Go rabu nipuna pena-le pa piramina kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Go lisimi pare nipumi nimu gu-rupa lakalisa: Ni adare medaloma-para puma Gote-na Surube Su madaa Epe Agale laketoa. Gote-me ni mea rapaasare go kogono pamu panolo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gore nipumi Gote-na Epe Agale Judia su robona lotu adanu-para mogealisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Koro medare Yesu ipa Genesaret le repale-nane aasa. Go rabu enaalinu Gote-na agale pagolalo maregepeama puma nipu piri ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Go rabu ipa le repale-nane oge ipinu laapo mea adialabasimi-daa Yesumi adisa. Go wena meape alinumi mo ipinu giyoma wena agona radepeala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu nipu Saimon-na ipinu madaa puma pirisa. Go puma nipumi Saimon-para talo: Ipa repale-nane giyoma ipinu ogesi-daa yola puma bana lisa. Go rabu Yesu mole madaa pirumare enaali adaapu agale mogealisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mo enaali agale abala lakelalo kiralomare werepe Saimon gu-rupa lakalisa. Ipinu madaa mo ipa rikirana bana lisa. Go ipa rikirana pumare wena agona lopanyaoma wena mealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon-me gu-rupa lisa: Mudu Ali, abi go ribaare naa raayome kalai adaa pa kama pare naame wena meda abuna nameama. Yapare neme apo lae-daa neme wena agona lopanaa-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nimumi go-rupa pumare wena ora adaapupe misimi. Ora adaapu waru misimi-pulu agona kurupu tabolalo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Go pisa raburi mo nimuna yogonu medaloma ipinu rado madaa piruma raba minalo ki wagepu pisimi. Gore nimu ipumare mo ipinu laapo madaa mo wena mea marulataabasimi. Go raburi mo ipinu laapore ena kedaamere rodopetalo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita-me go adoma Yesuna kibu-para rumu pege puma gu-rupa lisa: Mudu Ali, neme ni giyoma ne pu. Niri epe ali-daa dia yapare ora koe ali pi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita-para ali medaloma nipu raapu aasimi alinumiri mogo wena adoma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon nipuna yago laapore Sebedi-na si laapo Jems-para Jon laapore nipu page pogolasaasipi. Gore Yesumi Saimon lakalisa: Neme paala nakomape. Werepe go wena meale-rupare enaali mealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Go raburi wena mi alinumi nimuna ipinu ipa rugi-nane yolisa sumare wena ele raayo giyoma Yesu nipu raapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Rana medare Yesu su adare meda-para pirisa rabu ali meda yakilimi luma ki age raayo rugula mealimi pi ali pirisa. Go ali nipumi Yesu adomare su kamaa lopoma nipuna le-aga adainaaoma gu-rupa lisa: Mudu Ali, nena koneme ni ma-epeaano kone sali-daare Gote-me ni ma-epealia. ");
INSERT INTO kjs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Go rabu Yesumi nipu madaa ki ridulaoma talo: Neme nena rerenu kaapu na kone salo lisa. Pena go-rupa lalana-le go yakilimi li alina rere abala dia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Go pisa rabu Yesumi nipu-para agale puri pale gu-rupa lisa: Neme wala ali meda nalakelape. Nena to yogalere Gote-na lodo kira-ae alimi adena abi pu. Go paliri Moses-me lisa-rupa lodo kira-ae ele kiraina. Go pali raburi enaalinumi mo nena yaina dia yana-rupa mada adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Go lisa pare mo Yesuna pisade kogonore su ada raayona pago kiritasimi. Go pisa raburi enaali adaapumi nipuna agale pagolalo ipisimi. Go page nimuna yaina raayo raakepeanalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Go pisimi raburi nipu adae abuna enaali napiri su-para pumare nipumi beten puma lo pitaa pisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Koro medare Yesu nipumi Gote-na agale enaali raayo mogeaata pirisa. Go rabu Farisi alinu-para rekena agalena tisaanu-para pirisimi. Nimuri Galili su robo-para Judia su robo-para Jerusalem su robo-para go su raayona adare-para epaoma puma ipisimi. Go rabu Mudu Alimi Yesu nipu puri kalisa-pulu yaina kome enaali adaapu ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Go rabu ali medalomame reke madaa ali meda riaa ipisimi. Go alina ki age kuli raayo komapasa. Nipu ada ru-nane puma riaa kodobaoma Yesu nipu piri re-para puma sulalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Go pisimi pare ada rubitabesa-pulu mo ali mada nariaoma ipisimi. Mo ada rubitabesa raburi mo yaina kome ali wala so ada koau-nane riaa opasaasimi. Riaa pumare ada pira kege pemina lapaoma mo enaali pirisimi rikirana madaa lopanaaoma Yesu re-para masaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesumi mo alinu nimu waru kone rulasimi-pulu nipumi go ali adoma talo: Nena pupitaginu mea rubaato lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Go lisa raburi rekena agale tisaanu-para Farisi alinu-para nimuna agale adaapu gu-rupa lisimi: Go aliri aapi ya? Nipumi Gote-para ero agale lea. Pupitaginu mea rubape aliri go su kamaa meda dia yade. Go kogonore Gote-me komea mada palia lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesumi nimuna kone-para abala adokaru misa-pulu nimu-para agale gu-rupa lakalisa: Nimina kone adaapuri ake paa-daa wimi ya? ");
INSERT INTO kjs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Akepu toa-daa epelea yapae? Pupitaginu mea rubaayo toa rabu epelea yapae? Neme ne rekoma pu toa puri palea yapae? ");
INSERT INTO kjs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yapare neme agale laketoa rabu Gote-na Mea Rapaae Aliri neme go su kamaa puri muma kogono mada palua-daa adalimina. Go puma koe elenu neme mea rubaato. Go rabu mo kuli koma pe ali-para agale gu-rupa lakalisa: Neme go lalo-le nena u pali elenu mea ripinuma nena ada pu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pena go-rupa lalaina go pirisimi enaalina le-aga madaa wagepu rekesa. Mo ali nipuna u pali elenu mea ripinuma ada pisa. Nipu puma re Gote-na bi minasaama pisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Go raburi enaali raayo ora pogolasaasimi. Nimumi paala komoma naame pora rado meda adaleme-daa Gote-na bi minasaasima. ");
INSERT INTO kjs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu nipu pumare kana takis mi ali Livai nipuna ada-para pirina adisa. Go aliri Yesumi gu-rupa lakalisa: Ni raita mea epape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gore mo ali nipuna elenu raayo giyoma Yesu raita maa pisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Go pumare Livai-mi Yesu eda adaalepe yawesimi. Yawesimi rabu takis mi enaali adaapu page pa enaali adaapu page nimu komea nipuna ada-para eda no pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Go rabu Farisi ali medaloma-para nimuna rekena agale tisaa-nu nimumi Yesuna disaipel alinu-para agale adaapu lisimi. Gore nimumi gu-rupa lisimi: Nimiri go takis mi alinu-para koe riabo alinu raapu go edare ake paa-daa neme pae? ");
INSERT INTO kjs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Go rabu Yesumi agale gu-rupa lakalisa: Yaina nakome enaaliri dokta piri-para napeme pare yaina kome enaaliri dokta piri-para pemede. ");
INSERT INTO kjs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neme ora epe kone wi enaalinu-para kone perekealiminalo agale nalakela ipisua. Dia, pare koe riabo enaali raayome kone perekealiminalo su kamaa ipisua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Enaali medalomame Yesu agaa gupa misimi: Jon-na disaipel alinumiri rana adaapu eda niti puma go eda giyoma beten leme. Farisi alinuna disaipel alinumi page go-rupa peme. Yapare nena disaipel alinumi eda pa no ipa ele pa apo neme-daa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Go lisimi rabu Yesumi nimu lakalisa: Ena lamulalo ali meda nipuna adami enaali raapu piralia-daare go adami enaalinu eda giyoma pa piralimi ya? Dia gu-rupa napemede. ");
INSERT INTO kjs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dia, pare go ena lamulalo pea aliri werepe nimumi nipuna adami enaalinu raapu maa palimi. Go di raburi eda madaa niti puma pa piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesumi nimu-para saa pi agale page meda gu-rupa lisa: Ali medame kagaa mamina meda mea riripima abalana mamina narabulemede. Pare ali medame go-rupa palimi-daare nipuna kagaa mamina makoyaaoma mo kagaa kuni mamina-re mogo abalana mamina rado-rupa aalia. ");
INSERT INTO kjs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Go page ali medame abalana meme mena yogale-para kagaa ipa wain nano pabalia. Yapare ali medame go-rupa paliare mo kagaa wain ipame abalana meme mena yogale rugula tyabalia. Go puma mo ipa wain su madaa koyoma mo meme mena yogale page mada koyalia. ");
INSERT INTO kjs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gu-rupa peme-le kagaa ipa wain-ri kagaa meme mena yogale-para mea koyo pabalepape. Go pali rabu ipa wain no pabape yogale laapo epelea. ");
INSERT INTO kjs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yapare pa ali medame abalana ipa wain abala nomare nipumi kagaa wain madaa kone nawia. Dia-le nipumi talo: Abala wain-ri ora epe tea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Werepe Pomo mu Pirape Yapi di meda rabu Yesu nipu wit-na kili maapu pamisa. Go rabu nipuna disaipel alinumi mo wit-na kili medaloma keresimi. Go pumare nimuna kimi rakepema nisimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Go kogono pisimi rabu Farisi alinu medalomame nimu-para talo: Go pemeare Pomo mu Pirape Yapi di rabu-le rekena wia-le ake paa-daa kili raluma kogono peme pae? ");
INSERT INTO kjs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Go raburi Yesumi nimu-para agale gu-rupa lakalisa: Nimimi Devit-para nipuna adami alinu-para nimumi reame komoma pisimi yaade remaa nadipilisimi ya? ");
INSERT INTO kjs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Reame komisimi rabu nipumi Gote-na ada ru-nane puma kodobasimi. Go puma lodo kira-ae alimi Gote madaa kale bret misa. Devit-mi nomare nipuna adami alinu page kalisa. Go pisa pare naana rekena wi agale madaare Gote-na lodo kira-ae alinu komeamere go bret mada nalimi lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesumi nimu gu-rupa lakalisa: Enaali Raapu Pirape Siri Pomo mu Pirape Yapi di-ri nipuna surubea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Werepe Pomo mu Pirape Yapi di meda raburi Yesu lotu ada-para puma enaalinu agale pamu lakalisa. Go ada-parare ali meda piruma nipuna popa ki-ri ora kolisa. ");
INSERT INTO kjs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Go rabu Farisi alinu-para rekena agale lisa alinumiri Yesu madaa kose lape agale talo pirisimi. Go pisimi-pulu nimumi waru adolalo mo yaina kome enaali Pomo mu Pirape Yapi di rabu Yesumi enaali maperekeaata palo kone mulalo adaba pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Go pisimi pare Yesumi nimuna kone adisa-pulu mo ki meda-nane kome ali gu-rupa lakalisa: Ne rekoma go-pare ipu. Go lisa rabu nipu rekoma puma aasa. ");
INSERT INTO kjs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gore Yesumi nimu-para talo: Naamere Pomo mu Pirape Yapi di raburi rekena agalemere ele lea pae? Naame epe kogono pamina yapae koyaape kogono pamina ya? Naame enaalinu raba meamina yapae naame enaalinu lu makomamina pae? ");
INSERT INTO kjs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Go rabu Yesumi ali raayo adabaaina go ali go-rupa lakalisa: Nena ki epe-rupa ridula lisa. Mo alimi nipuna ki ridulasa rabu nipuna ki ma-epeaasa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Go rabu nimumi Yesu-para rono waru pagoma nimumi Yesu madaa naame ake pamina yapae lisimi? ");
INSERT INTO kjs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Go raburi Yesu nipumi beten talo rudu meda madaa pisa. Go rabu Gote re-para beten lala pirina yapi paa lapaasa. ");
INSERT INTO kjs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Naare rapaasa raburi nipuna disaipel alinu-para ipulupa loma yalisa. Go puma nimuna rikirana piri ali ru repena bi loma lisana ora aposel kogono alinu mapiraasa. Nimuna bi gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon wala Yesumi bi Pita lakalisa. Nipuna ame Andru-para meda Jems-para Jon-para Filip-para Batolomyu-para ");
INSERT INTO kjs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu-para Alfius-na si Jems-para Saimon nipuna ruru bi Selot nipu-para ");
INSERT INTO kjs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jems-na si Judas-para Judas Iskariot-para go ali raayore Yesumi mapiraasa. Judas Iskariot-re nipu werepe Yesu lore alina kina mea wisade ali yade. ");
INSERT INTO kjs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Gore Yesu nimu raapu meda rabu rudu madaa kilipima ipumare su kamaa-para nipuna disaipel alinu raapu epa rekesimi. Go rabu enaali adaapu pirisimi. Nimuri Judia su raayo-para Jerusalem su-para nabisi adare Tair Saidon lapo-para piri enaalinu epa kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nimu raayo ipumare nipuna agale pagoma nimuna yaina ma-epeaanalo ipisimi. Go page enaali adaapu koe remome linu epenaloma Yesumi ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Go raburi enaali raayome nipu kimi waraatalo pirisimi. Nipuna purimi mo yaina kome enaali raayo maepeaasa-pulu go-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesumi nipuna aposel kogono alinu waru adaba suma talo: Nimi naaralinu raaname waru komalimina. Gote-na Surube Su raayo mada adalimina. ");
INSERT INTO kjs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nimi enaalinuri abi reame apo komalimi-le raaname komalimina. Nimina robaa rubitabenalo eda adaapu nalimina. Abi nimimi re apo lo pilimiri werepere giri lo epe-rupa piruma raaname komalimina. ");
INSERT INTO kjs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ni enaali Raapu Pirape alina Sina agale pagalimi rabu pa enaalinumi nimi adoma rono komoma nimi koau wateme. Go puma nimumi ero agale loma nimi koe bi gialimi pare go kone madaare pa raaname komalepape. ");
INSERT INTO kjs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nimumi nimi-para go-rupa palimi-daare nimimi raana ora waru komoma pedo palepape. Pagalepa. Abala nimuna kasuanumi apo kone mogeama agale lakale alinu-para page go-rupa pisimi. Gore nimina so yaa-para wi yotore ora epe adaalepe mealimina. ");
INSERT INTO kjs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pare nimi abi kamo le enaalinuri waru adalepape. Nimina pa epe-rupa pirape kone abala mu aaeme. ");
INSERT INTO kjs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Abi go enaalinu nimiri eda noma nimina lo robaa-para rubita-le werepere reame waru komalimina. Abi giri leme enaalinuri nimimi waru adalepape. Werepe nimi re ora waru lo pitimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Go page enaali raayome nimi madaa pedo palimiri nimimi waru adalepape. Nimuna kasuanumi makirae agale le alinu-para page abala gu-rupa pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yapare nina agale pageme enaalinu nimi lagialo: Nimina lore alinu madaa pedo pi kone salepape. Enaali medalomame nimi-para koe rono pagape kone salimiri ora pili loma epe kone suma raba meape. ");
INSERT INTO kjs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Enaali medalomame nimi-para koe agale lemere beten loma ma-epeaatepape. Enaali medalomame nimi makoyaatalo palimiri go page beten loma raba mealepape. ");
INSERT INTO kjs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gore enaali medame nena pae paarame rola taliare perekelema luma medane taina lape. Go page enaali medame nena seket maa paliare gore nena siot meda page kalape. ");
INSERT INTO kjs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ali medame ele rome teare gore kalape. Go page enaali medame nena ele muma saapiralimiri wala abi wagepu gi natapape. ");
INSERT INTO kjs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Enaalinumi raana pi kone sulalo palimi-daare nimi page kone komea go-rupa salepape. ");
INSERT INTO kjs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Gore nimimi enaali meda madaa pedo pi kone salimi-daare nimumi nimi madaa pedo pi kone salimi. Go pea-le go kone madaare puri mada namealimi. Dia-le pupitagi nape enaali medalomame page nimu madaa pedo pi kone salimi-daare nimumi go page kone komea-rupa salimina. ");
INSERT INTO kjs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Go page nimi-para epe kone salimide enaalinuri nimimi page nimu-para epe kone salimiri go madaare epe puri namealimi. Dia-le pupitagi ne enaalinumi page go-rupa peme. ");
INSERT INTO kjs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Go page nimimi enaali medaloma elenu kaloma wala abala gi kone salimiri go kone madaare epe puri namealimi. Dia-le pupitagi ne enaalinumi page koeyae peme enaalinu ele kateme. Gore yago mada abuleme kone suma kateme. ");
INSERT INTO kjs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pare nimimi go kone namogealepa. Nimimi lore alinu pedo puma raba mealepape. Go page elenu kaloma raba mealimi raburi gore naa madaa epe ele mada abuteme kone nasalepape. Gote-me ora pili nalo pupitagi neme enaalinu madaa epe kone suma kodome komea. Go epe-rupa palimiri nimi so yaa-para pia Gote-na si wanenu pitimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nimimi enaalinu kodome komalimiri aapa yaa madaa piame page kodome komalia. ");
INSERT INTO kjs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nimimi enaali medaloma madaa epe enaali koe enaali kone nasuma natapape. Go palimiri Gote-me page nimi madaa kose lape agale-rupa namuma rumaalia. Go page enaali medaloma madaa kedaa pi kone narumaalepape. Go palimiri Gote-me page nimina kedaa narumaalia. Nimimi enaali medana koae-aunu mea rubalimiri Gote-me page nimina koae-aunu mada mea rubalia. ");
INSERT INTO kjs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nimimi ele pa enaalinu pa katemere Gote-me page nimi go kone madaa elenu pa gialia. Gialia rabu nimina ki-para waru muma rubu aalia rabu rulaniaaoma marubiaoma koyaalia. Nimimi ele rumaaoma enaalinu katemede-rupare Gote-me gode kateme-rupa raayo abuloma sainaalia. ");
INSERT INTO kjs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesumi nimu-para saa pi agale meda wala gu-rupa lisa: Le rubu pi ali medame nipuna le rubu pi yago pora mada mea waatea ya? Dia-le nipu laapo raita naaku-para lopalipi. ");
INSERT INTO kjs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Go page skul leme nogo naakinuri nimuna tisaa-rupa mudu mada piralimi ya? Dia, pare nimu abala skul waru lomare nimu page wala mo tisaa nona palimi. ");
INSERT INTO kjs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gore mo nena amena le-para lemare apo wia te-daare nena le-para adalepe mo wia abala maa pape. ");
INSERT INTO kjs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Akea puma nimina ame gu-rupa madaa laketeme ya? Ame-ya, nena le-parare le mare wia. Go leme pare adaa repena rekepele nimina le-para aayare ora na-ademe. Nimina kone nama-redepo yaaoma pimi-pulu ora makeae enaali pimi. Abala ririnare nimina le-para aaya repena rekepele abala rasalepape. Werepe nimina le waru ria piruma mo nimina amena le-para aaya lomare mada yokalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesumi wala gu-rupa lisa: Epe repenamere koe kili-daa namadia. Go page koe repename epe kili namadea. ");
INSERT INTO kjs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Enaalinumiri repena kili abala elea adomare go kili epe talo kotalo abala makuaaeme. Enaalinumi repena keto madaa pa repena fik kili nakereleme. Go page kope meda madaa wain kili nakereleme. ");
INSERT INTO kjs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Epe enaalinumi nimuna lo robaa-para epe kone adaapu suma epeaanu adaapu peme. Koe alimi wain maapu puma nipuna kiageme page koeyae kama pea. Gore nimuna lo robaa-para go kone suma rubitabenaloma nimuna agale leme. ");
INSERT INTO kjs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ake pea nimimi ni-para Mudu Ali loma nina agale wala napageme? ");
INSERT INTO kjs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Enaali nimi ni piri-para ipuma nina agale pagoma kone rulaoma raitalimi-daare ora epe-rupa pimi. Nimuna kone madaa remaa lagialo. ");
INSERT INTO kjs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Go agale page aliri ali medame ada pulalo pea. Abala ririnare naaku ora no-para puma robo sumare ada pigi maa pabomare kana muma ruluaoma puri mapalaaya. Go pumare werepe ipa roma go ada marobaatalo pea pare mada dia. Mo ali nipumi abalade go ada waru pisa-pulu ora puri paloma aasa. ");
INSERT INTO kjs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pare ali medame nina agale pagoma naraitalia. Go aliri nipuna ada gu-rupa pisa: Nipumi no su ru-nane ada pigi puri namapalae pa kama awelisa. Werepe go adare ipa roma lisa rabu ora wagepu robesa. Gore lopesa rabu ora e waru lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesumi enaalinu agale lakelalo dianaloma Kaperneam su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gore soldia alinuna surube ali meda pirisa. Go kana kogono naaki yaina adai muma le kadupitalo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mo soldia ali mudumi Yesu pia remaa pagisa rabu nipumi kone makuaae Juda medalomame mo Yesu adola penaalisa. Nipumi mo naakina yaina epa ma-epeaana kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nimu Yesu piri-para puma agale puri paloma gu-rupa puma kogelisimi: Apo soldia aliri epe ali yaa-pulu neme raba meaina. ");
INSERT INTO kjs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nipumi naa Juda enaalinu madaa pedo pi kone suma nipumi naana lotu ada meda wariasa-daa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gore Yesu nimu raapu pisa. Nimu ada regepema abala puma opapasimi rabu mo ali mudumi adami ali medaloma Yesu-para agale gu-rupa rapasa: Mudu Ali, neme kedaa napeape. Ni epe ali dia yaa-pulu na ada-para na-epape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Go page ni epe ali-daa dia yaa-pulu ne piri-para page mada na-epalua. Pare neme abi pa agaleme le rabu nina kogono naakina yaina perekelena lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gore ni page soldia ali kalunumi agale lagialimi rabu pagalua. Gore ni page soldia alinu pawa surube. Gore neme soldia ali meda pu toare mada palia. Go puma neme soldia ali meda ipu toare mada epalia. Go puma nina kogono naaki-para kogono pa lo lakelaayore gore nipumi mada palia. ");
INSERT INTO kjs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesumi go agale pagoma mo ali madaa kone adaapu suma aasa. Nipumi wala perekea yoma mo nipu raita mea ipisimide enaali gu-rupa lakalisa: Gore pagalepa. Israel su-parare naa agale pagae enaali meda go-rupa na-ade. ");
INSERT INTO kjs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Go rabu mo agale mea ipisimi alinuri ada wala pumare mo kogono naaki abala perekealisa-daa adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Werepe ogeasi piruma Yesu nipu wala adare Nain pisa. Nipuna disaipel alinu-para enaali adaapupe nipu raapu pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Go adare-na pora pape-nane kodobatalo ipisimi rabu enaalinumi ali ro meda go ria ipisimi. Mo kome naakiri ena wasaana naaki komea pirisa. Go adare-para piri enaali raayore mo ena raapu re laari ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mudu Alimi go ena adoma nipumi kodome ora waru komisa. Go rabu nipumi mo ena-para gu-rupa lakalisa: Neme re nalape. ");
INSERT INTO kjs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Go lisa rabu nipu re-para puma mo ali ro wisa-para ipuma kimi waraasa. Go pisa rabu mo ali ro rilisimi alinuri pa reka aasimi. Yesumi talo: Go penaali neme lalo-le ne reka. ");
INSERT INTO kjs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mo aliri ora le kadupilisa pare rekaa piruma agale lo pirisa. Go pisa rabu Yesumi go naaki nipuna agi wala kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Go pisa raburi enaali raayome paalame komoma Gote-na bi minasaaoma talo: Gote-na agale lakale ali mudu meda naana rikirana abi go epa pia. Go loma nimumi talo: Gote su kamaa ipuma nipuna enaali adae abuna mapiraalalo epaana lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gore Yesuna remaare enaalinumi Judia su raayona pago kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Jon-na disaipel alinumi go remaa Jon lakalenalomare nipumi disaipel ali lapo-para ipulupa lisa. Go ali laapore Mudu Ali piri-para puma agale lorapealepa. Gupa tapape lisa: Nere Jon-me abala ali meda epalia lo lagisa ali yapae pa ali meda adoba piralima yapae tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Go ali laapore Yesu piri-para abala puma nipumi talo: Nere abalade epalia lisimide ali yapae pa rado ali meda adoba piralima yapae lisipi? ");
INSERT INTO kjs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Go raburi Yesumi enaali yaina rado rado kome enaali adaapu ma-epeaaoma koe remo nimu madaa piri raayo maa ralulisa. Nipumi le rubu pi enaali adaapu page ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesumi nipu agale gu-rupa puma laketapape lisa: Nipimi abi go adoma pagapede remaa Jon piri-para puma laketapape lisa: Le rabu pi enaalinumi ele wala waru adaame. Eke koe enaali page pora epe-rupa pamualeme. Yakilimi li enaalinuna rere page kaapu yade. Kale poae enaalinumi page kale lobenaloma agale pageme. Kome enaalinu page wala rekoma pimi. Enaali naaralinu-para page epe agale waru pageme. Go ele raayo madaa remaa puma tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ali medame ni madaa kone laapo nasuma puri paloma kone rulaliare go enaaliri pedo waru pu piralia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon-na agale mea rapaae ali laapore wala pisipi. Go rabu Yesumi Jon madaa enaali raayo-para remaa gu-rupa lakalisa: Abala Jon enaali napiri su-para pirina nimi go su-para pumare api adola pisimi pae? Nimimi po rilipumi kabe raguala adola puame ya? ");
INSERT INTO kjs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nimi pumare api adola puame pae? Nimi pumare ali medalomame epe epe set maarae adola puame pae? Dia-le epe epe set maarae go piale alinuri ali kalununa ada-para piralemede. ");
INSERT INTO kjs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gore nimi pumare ake adola puame pae? Nimimi Gote-na agale lakale ali mudu adola puame. Gore ora pagalepape. Go ali Gote-na agale lakale ali yapare ora Gote-na agale lakale alinu medalomare nipumi ma-oge yaaya. ");
INSERT INTO kjs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Go pea-le Jon madaare Gote-na agale wi buk-mi gu-rupa lea: Gote-me talo: Go aliri nina agale laketapape ali neme nipu abala maa penaatoa. Go alimiri nimina lo robaa ma-redepo yaata epalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pagalepa. Jon-mere go su kamaa madina enaali raayo ma-oge yaalia pare Gote-na Surube Su-para piri pa ali medame Jon page ma-oge yaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Go lisa rabu takis mi alinu-para enaali raayome pago kiritasimi. Nimumi Gote-na epe agale mana pagenaloa abalade Jon-me kalu-ipa kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Go pisimi pare Farisi alinu-para rekena agalena tisaanuri Jon-na kalu-ipa giyasimi. Go puma nimumi Gote-na epe pora giyasimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesumi talo: Gore abi reka piri enaalinuri ake piale enaalinu-rupa piralimi lano yapae? Nimuna kone-para ake kone saa pimi agale lano yapae? ");
INSERT INTO kjs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nimuri gu-rupa lano: Nogo naakinu maket kamaa piruma nogo naaki radonu-para gu-rupa leme: Naame nimi madaa lemaa lema pare nimimi yasa napabeme. Naame kodo kome yasa lema rabu nimimi re nateme. ");
INSERT INTO kjs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesumi wala gu-rupa lisa: Gore Jon-me kalu-ipa ipuma bret nanoma ipa wain page nanisa. Go pisa rabu nimimi nipu makeae ali lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Abiri enaali Raapu Pirape alina Si ni ipuma eda ipa no pi. Go pe pare nimimi talo: Adalepa. Go aliri eda adaapu noma ipa wain adaapu ne ali leme lisa. Go aliri mo takis mi alinu-para naaraalinu-para nimuna adami ali raapu piru aaya leme. ");
INSERT INTO kjs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nimimi go-rupa leme pare enaalinumi Gote-na kone memere naa nimuna makuaae ele-daa go-rupa waateme. ");
INSERT INTO kjs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi ali medame Yesu nipuna ada-para eda nola epape lisa. Yesu mo Farisi alina ada-para puma eda nala pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gore ena koe medame Yesu mo Farisi alina ada-para eda nala pia remaa pagisa. Go remaa pagoma mo ena nipumi epe kaapu le wabola kana pe-para pira palae Yesu piri-para mea ipisa. Go wabolana kana elere ora adaapu madaa ora adaalepe. ");
INSERT INTO kjs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mea ipumare Yesuna koau-nane puma age radepesa. Go puma nipu re lala pirisa. Nipumi re loma go ipa Yesuna age madaa pogolasa. Go pumare re ipare nipuna kalu irimi kunuma makaapu yalisa. Mo ename Yesuna age madaa nunu loma age madaa epe kaa pi wabola pepeminalisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mo Farisi alimi adoma nipumi gu-rupa kone wisa: Go aliri ora Gote-na agale lakale ali yalore nipu warata enana kone mada makuaaya. Go ename koe pupitagi ne ena-le mada adalia kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Go rabu Yesumi mo alina kone adoma talo: Saimon, neme ne remaa meda lagialo. Saimon-me talo: Tisaa, nena agale la. ");
INSERT INTO kjs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Gore Yesumi talo: Ali laapona kana rudu ali komea madaa aaya. Ali medana ruduri 2,000 kina misa. Ali medana rudu 200 kina misa. ");
INSERT INTO kjs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mo ali laapome go rudu abulape pomo komisipi. Go pea raburi mo rudu kale ali laapome mo ali laapo rudu na-abutapape lakalisa. Go pisa raburi mo ali laapomere aapimi pedo waru pisa pae? ");
INSERT INTO kjs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon-me agale gu-rupa lakalisa: Neme gu-rupa kone salo. Ali medame nipuna rudu adaapu mu ruguluma na-abuli aliri raaname komisa kone salo. Gore Yesumi talo: Gu-rupa ora lale lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Go lisa rabu nipumi go ena piri-para perekea luma Saimon-para neme go ena ada lisa. Ni nena ada ru-nane epawade pare nina age radepeape ipa nagiaede. Yapare go ena nipuna re ipame nina age radepeaoma nipuna kalu irimi makaapu yaripaade. ");
INSERT INTO kjs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nena ada ru-nane epawade rabu nunu nalaede pare go enamere nina age madaa nunu laade. ");
INSERT INTO kjs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neme nina kalu-para wabola napeaaripide pare go ename nina age madaa wabola paaripade. ");
INSERT INTO kjs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Go pea-le ne lagialo: Nipumi ni madaa raaname komoma ora nipuna koae-aunu adaapupe Gote-me mea rubata. Pare Gote-me enaali medana koae-aunu ogepusi mea rubaliare go enaaliri ogepu raaname komalia. ");
INSERT INTO kjs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gore Yesumi mo ena lakalisa: Neme nena koae-aunu mea rubaato lisa. ");
INSERT INTO kjs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Go lisa rabu ali medaloma nipu raapu rapula madaa piruma eda nala pirisimi alinuri agale makibumaaoma go-rupa lisimi: Go alimi aapimi koae-aunu mada mea rubalia ya? ");
INSERT INTO kjs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Go lisimi pare Yesumi go ena lakalisa: Nena kone rulaeme ne ma-epeaaoma ne Gote raapu mapiraala. Abi puma nena lo robaa epe-rupa aina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Werepe Yesu nipu su raayo-para mo pora pagina pamisa. Nipumi Gote-na Surube Yapi-na Epe Agale lakelalo mogealisa. Go rabu disaipel ali 12-pela nipu raapu pamisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yesumi ena medaloma nimuna koe remonu marakepeaaoma nimuna yainanu raayo ma-epeaasa. Go enanu nipu raapu pora pamisimi. Go enanuna bi gu-rupa: Makdala adare piri Maria-re abalade Yesumi koe remo ki medane luma medane laapo mea rubaasa. ");
INSERT INTO kjs_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ena medana bi Joana-re nipu ali mudu Herot-na ada surube ali Susa-na were pirisa. Ena medalomare Susana-para ena rado adaapu page nipu raapu pamisimi. Go enanumiri mo disaipel alinu-para Yesu-para nimuna ele raba meaa-ma pulalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ora adare rado rado-para piri enaali adaapumi Yesu piri-para epa kiritasimi. Go pirisimi rabu nipumi nimu-para saa pi agale meda gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ali medame wit-na kili maapu-para pola pisa. Nipumi kili maapu-para pulalo pisa rabu medaloma pora pagina lopesa. Go kiliri enaalinumi rabuaa luma yaanumi page nisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pare go alimi wit kili medaloma poasa rabu kana madaa lopesa. Go kana madaa lopesa rabu suri kana madaa ogepusi wisa-pulu raayo kaapu yabesa. ");
INSERT INTO kjs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit-na kili medalomare repena ketoae-para lopesa. Go-para opisa pare mo kope adaa yoma minabaasa. ");
INSERT INTO kjs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit-na kili medalomare epe su-para lopoma opea. Gore waru opomare wit-na kili elesa rabu kili 100-pela madisa. Go saa pi agale lomare Yesumi gu-rupa lisa: Enaali raayo nimi kale aalia-daare waru pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Go raburi nipuna disaipel alinumi go saa pi agalena re agaa lorapisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Go pumare nipumi talo: Gote-na Surube Yapi-na pagaa wi agalena re nimimi abala adame-daa lagialo. Yapare pa enaali medalomamere go Surube Su madaare pa saa pi agale pageme. Go puma nimuna leme pa ademe pare ele meda na-adalimi. Nimumi agale pa pageme pare go agalena re-re mada namakuaalimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Go saa pi agalena rere gu-rupa lisa: Go wit-na kiliri Gote-na agale yade. ");
INSERT INTO kjs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pora pagina lope-ae kiliri go-rupare enaalinumi agale pa pageme pare werepe Satan ipuma mogo agale nimuna lo robaa-para wala paake mea. Nimumi kone rulaoma adae abuna kagaa piramala palimi kone suma Satan-me paake mu aaya. ");
INSERT INTO kjs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kana wi su-para lope kiliri go enaalinumi epe agale pagomare pedo waru peme. Yapare ora robaa ru-nane pitaa napuma kodobaaya-pulu nimumi kone ogepusi rulaeme. Werepe Satan-me epa eleme kotalalo paa-daa wala Gote-na agale giyeme. ");
INSERT INTO kjs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Etolo etolo aaya su-para lope kiliri go enaalinumi agale pageme pare go su kamaana kedaanu page kamaa yape page go pedo pape kone raayome nimu minabaaya. Go pea-pulu regepe minaoma kili waru na-elea. ");
INSERT INTO kjs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Su epe-para lope-ae kiliri go enaalinumi epe agale pagoma lo robaa-para waru kirulu saapiruaeme. Nimu pawa piruma pageme-pulu nimumi kili waru madialimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesumi wala talo: Ali medame lam kewomare baket rolo-para page reke rolo-para napagaa salia. Dia, pare enaalinu ada ru-nane piruma lam-na paa minalo mudialimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gore ele adaapu kuduripu wimi elenuri gore raayo penaame paana maa salia. Go puma keapalimi ele raayore werepe penaame maa salia-daa mada adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nimina pageme agalere waru surubalepape. Enaali raayome kone waru su piralimi-daare Gote-me kone ele medaloma wala gialia. Pare enaali raayome kone ele waru nasu piralimi-daare gore nipuna saapia ele raayo abala mu paaya. ");
INSERT INTO kjs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu nipuna agi-para amenu nipu piri-para ipisimi. Go rabu enaali adaapu kiritasimi-pulu nipu pirisa re-para pirape ae nawisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Go raburi enaali medame nipu lakalisa: Nena agi-para nena amenuri nimumi ne adola ipuma kamaa-nane epa aeme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Go raburi Yesumi agale gu-rupa lakalisa: Enaalinumi Gote-na agale pagoma kone rulaoma raitalimi-daare gonuri nina ama-para nina amenu-para pimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Koro meda Yesu nipuna disaipel alinu raapu ipinu madaa pisimi. Gore nipumi nimu lakalisa: Nimi mo ipa le mone pane kenaama baina lisa. Go rabu nimu pulalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ipinu madaa piruma pisimi rabu Yesu nipu u palisa. Go rabu po rilipu adaa meda kawaro kanapu-nane ipisa. Go puma mo ipinu madaa ipa epa rubitalo pisa-pulu nimu paala komoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Go rabu disaipel alinumi Yesu puma marekaaoma talo: Mudu abiri naa ora apo tyala-daa lisimi. Yesu nipu rekoma lisana mo po rilipu-para mo adaa ipa lapo-para puri pale agale lakalisa. Go agale lakalisa rabu po rilipu ipa laapo raita loraoma ipame lewa lewa wala napisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Go raburi nipumi disaipel alinu-para agale lorapisa: Naa agale lo robaa-para mea wimi pae? Go lisa rabu nimumi pogolasaoma paala komoma agale lala piruma gu-rupa lisimi: Go aliri aapi ya? Po rilipu-para ipa laapo raita agale lakela rabu nipu agale pagaepe lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Go puma Yesu-para nipuna disaipel-nu ipinu madaa piruma Gerasa su-para pisimi. Go suri ipa Galili mone pane aasa. ");
INSERT INTO kjs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu nipu ipinu giyesa rabu mo ali madaala ipisa. Go aliri koe remo medaloma nipu madaa pirisa. Go ali ora abasade nipu mamina nayamoma ada-para napirisa pare enaali rogaae kana apedaa-para paitala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Go alimi Yesu adoma puri pale agale loma Yesuna kibu-para epa lopesa. Nipumi ora rui loma gu-rupa yalisa: Yesu, nere so yaa madaa pia Gote-na Si yade. Neme niri ake pali ya? Go puma go alimi agaa misa: Neme ni radaa manape ele nagiape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesumi mo koe remo pane pu lisa rabu mo koe remome agale puri palo yaaloma giyoma pane pisa. Enaalinumi adae abuna puri pale kopeme go alina ki age laapo rogaaoma nipu adilisimi pare go koe remonu nipu madaa epa pirisimi. Go pisimi-pulu nipumi go puri pale kopenu rugulu rubebe pala pisa. Go rabu koe remome mo enaali napiri su-para maa puala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gore Yesumi nipu gupa agaa misa: Nena biri aapi ya lisa? Nipumi talo: Paapu lisa. Gore koe remo adaapu nipuna yogale-para puma kodobasa-pulu go bi paapu lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Go koe remonumi puri paloma Yesu-para gu-rupa yalaasimi: Neme naa koe su naaku-para namuma mapiraape lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Go rabu mena adaapupeme oge rudu meda re-para eda epa nala aasimi. Go pea-pulu mo remo koe nimumi Yesu-para puri paloma gu-rupa lisimi: Neme naa pawa go mena madaa kodobamona lapa lisimi. Go lisimi rabu Yesumi nimu penaalisa rabu nimu go mena pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Go lisa-pulu gode koe remo raayomere mode aliri giyoma raayo mode mena madaa puma kodobasimi. Go pisimi rabu mena raayore oge rudu kilipima ipa le repale-nane kawaro-para lopoma komabesimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gore mo mena puni alinumi go-rupa adoma lisimina pogolasaasimi. Go pisimi rabu go agale remaare adare-para page puma lakeloma su raayona pago kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pagisimi rabu enaali raayome go remaana re adola ipisimi. Nimu Yesu piri-para ipuma ali epa adisimi pare koe remome mode ali abala giyoma pisa. Mo ali nipu mamina yamoma nipuna kone waru wisa. Go ali nipu Yesuna age re-para adainaaba pirisa aaya. Mo enaali raayome go-rupa adomare paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Enaalinu medalomame abala go pisade adisimi-pulu nimumi enaalinu-para gode aliri go-rupa palo remaa laoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go remaa pagisimi rabu mo Gerasa su robo ru-nane piri enaali raayomere Yesu nipu epa lakalisimi: Nere pane pu-le naa giyoma pane pu lisimi. Nimumi ora paalame waru komoma lisimi. Go rabu Yesu nipu ipinu madaa piruma wala pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Go rabu mo koe remome abala kiyasade aliri Yesu-para gu-rupa kogelisa: Niri ne raapu bana lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nena adare-para wala puma Gote-me ne-para paade remaa raayore enaalinu puma lakelapape lisa. Go rabu mo ali nipu puma mo nipuna adare-para piri enaalinu-para Yesumi nipu-para pisade remaa raayo puma lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu nipu ipa le one pane wala ipisa raburi enaali raayome nipu adoba pirisimi. Go puma nipu adoma lisimina raaname komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Go raburi ali meda nipuna biri Jairus ipisa. Go aliri lotu adana surube ali mudu pirisa. Nipu Yesuna age re-para epa lopoma agale puri paloma gu-rupa kogelisa: Nere nina ada-para epape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nipuna nogo komea madu wisa. Go nogona maaliri 12-pela yapare nipu le kadupitalo pisa. Go raburi enaalinumi Yesu marege paoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Go rabu ena meda nipu enaali raayo raapu pamisa. Go enare yapi pupulae yainare maali 12-pela palisa. Gore go ena nipumi mone elenu yaina ma-epeaanalo dokta-nu kalisa pare nipuna yaina mada nama-epeaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Go enare Yesuna koau-nane resi-para ipumare Yesu waraaoma mode yapi kaapu yoma wala napopisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Go rabu Yesumi talo: Niri enaali medame waraaripa kone salo lisa. Nimu raayome ni dia ni dia kama lakalisimi. Go rabu Pita-me talo: Mudu Ali, enaali adaapumi kuta puma ne maregepeaeme. ");
INSERT INTO kjs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Go lisa pare Yesumi talo: Ali medame ni waraaripa-le nina puri abala yola meade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mode enare nipu mada nakalisa-pulu nipu pururu puma Yesuna kibu re-para epa adainaa pirisa. Go pisa rabu enaali adaapuna le agaana lakalisa: Neme waraaripu rabu nina yaapi ora mogo wagepu kaapu yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gore Yesumi nipu lakalisa: Go nogo, nena kone rulaeme nena yaina ma-epeaaripi-le epe lo robaa raapu pu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nipumi mo agale pena lakelalaina mo adare ali muduna agale ma rapaape ali meda ipisa. Nipumi ali mudu Jairus-para yaaloma lakalisa: Nena nogo abala le kadupiaade lisa. Apo tisaa-para nena kogono namapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesumi go agale pagoma nipumi Jairus-para gu-rupa lakalisa: Neme paala nakomape pare kone waru rulape. Nena nogo wala epelea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gore Yesu nipu go ali muduna ada-para pumare ada ru-nane enaali raayo napulupape lo lakalisa. Dia, pare Pita-para Jon-para Jems-para mo agi aaraa lapo-para go-rupare Yesu nipu raapu ru-nane pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Enaali raayo mo nogo madaa re lala pirisimi. Go rabu Yesumi talo: Nipu nakomaana-le re natapape. Nipu pa u palea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Go lisa rabu mo nogo ora abala komisa adisimi-pulu Yesu madaa giri laasimi. ");
INSERT INTO kjs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gore Yesumi nogona ki mina muma gu-rupa yalisa: Go nogo, ne reka lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Go lisa rabu mo nogona wasa wala epa kodobaoma nipu wagepu rekesa. Go pumare Yesumi nimu lakalisa: Nimimi eda medaloma katapa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mo nogona agi aaraa nipu laapore ora paalame komisipi pare Yesumi nipu-para agale puri paloma gu-rupa lisa: Go remaare enaali meda nalaketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesumi disaipel ali 12-pela yaaloma nipumi puri-para surubuma paade kogono laapo kalaaoma pisa. Nimumi koe remonu raakepeanalo yaina ma-epeaanalo page puri kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Go pisare nimumi Gote-na Surube Yapi-na agale mogeama yaina kome enaalinu medaloma ma-epeaanalo mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Go puma nimu lakalisa: Nimimi pora pamualimi rabu ele namuma pulupape lisa. Nimimi lama-para roka-para nu-para sapi-para monenu page namuma pulupape lisa. Nimimi go page mamina laapo namealepape. ");
INSERT INTO kjs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nimumi nimi ada ru-nane epe-rupa lamua palimiri gore nimi go ada komea-para pawa puma piralepape lisa. Werepe nimina kogono dia naloma go adare giyoma pulupape. ");
INSERT INTO kjs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yapare nimumi nimi ada-para nalamua palimiri gore nimimi go adare giyalepape lisa. Go puma nimina age madaa kege kunuma salepape lisa. Go kunuma salimi rabu go enaalimi nimuna koe kone mada makuaalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Go lisa-pulu nimi puma su adare rado rado-para pu pu yabesimi. Go puma Gote-na Epe Agale remaa pamu lakeloma yaina kome enaalina yaina ma-epeaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili adare-na ali mudu Herot-me go remaa raayo abala pago kiritasa-pulu nipumi aapi-para leme pe loma kone adaapu wisa. Gore enaali medalomame Jon tapa-para wala reka lisimi-pulu nipumi kone gu-rupa wisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gore enaali medalomame Elaija wala epa pia lisimi. Medalomame Gote-na ora abalade agale lakale ali komea wala rekaana lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Go agale madaare Herot-me talo: Jon-na maare abala rugulisuade lisa. Go remaa pagalo aliri aapi yapae? Go loma nipumi Yesu adolalo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Disaipel alinu nimu wala ipuma naa kogono gu-rupa pa kama lo Yesu nipu epa lakalisimi. Go rabu nipumi nimu maa puma enaali giyoma adare meda Betsaida-para kama raapu pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Werepe enaalinumiri nimu puame lo remaa pagisimi-pulu nipu raita maa pisimi. Nimu nipu piri-para ipisimi raburi nipumi piralepa loma lisana nipumi nimu Gote-na Surube Su madaa agale lakalisa. Go rabu page nipumi yaina kome enaalinu page medaloma ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gore naare pabalaina mo ali 12-pela nipu piri-para ipuma talo: Neme go enaalinuri nimuna ada penaala lisimi. Go-parare enaali adaapu napimi. Go pea-le mo-nane adare eda kabo u paitape ada page wasa puma kabena penaala lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pare Yesumi nimu lakalisa: Nimimi eda kalapa lisa. Nimumi talo: Naana edare gu-rupa: Bret supu-para wena laapo wima. Nemere go enaali raayona eda kabamona kone sale ya? ");
INSERT INTO kjs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gore alinu 5000 pabo pirisimi. Go rabu Yesumi nipuna disaipel alinu lakalisa: Nimimi mo enaalinu 50, 50 lo mapiraalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Go puma disaipel alinumi enaali raayo mapiraaoma kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu nipumi mo bret supu-para mo wena muma yaa-para adaba suma Gote-para ora pili lisa. Go pumare nipumi bret piribima disaipel alinu kalanaloma nimumi enaalinu rumaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gore nimu raayome ora mada nisimi. No kiralomare eda purupi nu 12-pela madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Koro meda Yesu nipu komea beten lala pirina nipuna disaipel alinuri nipu piri-para ipisimi. Go rabu nipumi nimu agale lorapisa: Enaalinumiri niri aapi leme pae? ");
INSERT INTO kjs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gore nimumi agale gu-rupa lakalisimi: Medalomamere nere Jon Baptais leme pare medalomamere ne Elaija leme. Medalomare ne abalade Gote-na agale lakale ali meda wala rekaana leme. ");
INSERT INTO kjs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Gore nipumi nimu lakalisa: Nimimiri ni aapi leme ya? Gore Pita-me gu-rupa lisa: Nere enaali Raapu Pirape alina Si yade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Go lomare Yesumi nimu ora puri paloma agale mana lakalisa: Go agalere pa enaali nalaketapape. ");
INSERT INTO kjs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gore nipumi talo: Ni enaali Raapu Pirape alina Siri kedaa adaalepe ritua. Go puma kone makuaae Juda alinu page Gote-na lodo kira-ae ali mudunu page rekena agale tisaa alinu page go ali raayome ni koau wateme. Go puma ni lu makomalimi pare wala yapi repo dia naloma wala tapa-para rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gore nipumi enaali raayo lakalisa: Gore enaali raayome ni madaa kone rulaoma palimi-daare nimuna kone rabuainaoma repena polopeane kedaa adalepe abuna ruma nina pora raitalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gore ali medame nipuna kone wasa pa irulu saapitiare gore nipuna wasupa page alupalia. Pare ali medame ni madaa kone suma nipuna yogale madaa kone nasaliare nipuna wasupare gore adae abuna piramala palia. ");
INSERT INTO kjs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pare ali medame kana ele waru muma su kamaa elenu page raayo waru saliare nipuna kone wasupa go elenumi akepu raba mealia ya? ");
INSERT INTO kjs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gore enaali raayome ni-para nina epe agale-para koau wateme-daare ni enaali Raapu Pirape Alimiri go enaali koau walalua. Wala epalua rabu naa puri pale Aapana epe paana puri page epe ensel-nuna page mea epalua. ");
INSERT INTO kjs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pagalepa. Enaali medaloma go-para pimiri abi nakomalimi. Dia, pare abala nimumi Gote-na Surube Su epenalo adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesumi apo agale abalana lomare sarere komea abala dia lisa. Go rabu nipumi Pita-para Jon-para Jems-para lamua puma rudu medana beten talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nipumi beten lala pirina nipuna le-aga abala rado pereke yoma lisana nipuna mamina page yaako pu luma lepo lepo aasa. ");
INSERT INTO kjs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Go pumare wagepu ali laapome nipu raapu agale lala pirisipi. Go ali laapore Moses-para Elaija laapo Yesu raapu agale lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nipuri yaa madaana epe paana puri raapu ipisipi. Nipu laapome Yesu-para werepe Gote-na kogono pu kiritinalo Jerusalem su-para komali agale lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Go rabu Pita-para mo adami alinu-para u waru palisimi. Gore nimumi rekoma puma Yesuna epe paana puri-para mo rekasipide ali laapo page adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gore mo ali laapome Yesu giyoma polalo pisipi rabu Pita-me Yesu gu-rupa lakalisa: Mudu Ali, naa go-para pimare ora epelea. Gore naana pokaalo ada ipa repo paminapa. Medare nena meda Moses-na medare Elija-na pamina lisa. Pita nipumi go agale lakalisa pare go agalena re namakuaasa. ");
INSERT INTO kjs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nipumi go agale pa lalaina mole medame nimu abala kepisa. Moleme nimu rabuaanaalisa rabu nimumi paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Go mole-parare agale meda gu-rupa lakalisa: Gore ora nina epe naaki-le neme nipu abala mapiraasua. Nimimi nipuna agale pagalepape. ");
INSERT INTO kjs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gote-me agale lakenaloma Yesu nipu komea pirina adisimi. Gore disaipel alinu nimumi agale loraoma go adisimide elenu madaa remaa nalakelesimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ekerare so rudu giyoma kilipisimi rabu enaali adaapumi Yesu nipu pora pagina madaala ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Go enaalina rikirana ali medame gu-rupa yaaloma kogelisa: Tisaa, neme nina naaki kodome komoma adape. Go naakiri ora naa komea naaki yade. ");
INSERT INTO kjs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Koe remo medame nipu irulu ripinaaya. Go pea raburi mo koe remome nipu malopaoma makeaaya. Go puma nipuna agaa-para rako supi raa piasa. Go rabu nipuna yogale makoyaeya. Go puma go remome naa naaki abi naminarepaaya. ");
INSERT INTO kjs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Neme abalade nena disaipel alinumi go koe remo ma rakepealepa lo kogelisuade pare nimumi mada naralu lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesumi go pirisimi enaalinu-para gu-rupa lakalisa: Nimiri kone waru narulaoma nimina lo robaa-para page ora kolea. Nimi raapu ni rana akepu raapu pitua pae? Nimina koe kedaanu akepu raapu ritua pae? Go lomare go ali-para lakalisa: Nena naaki lamua ipu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nipuna naakiri pena ipulaina mo koe remome ora lopaoma makeaasa. Go rabu Yesumi go remo-para puri pale agale lakeloma mo naaki ma-epeaasa. Go puma nipuna aaraa mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Enaali raayome Gote-na adaa puri adisimi-pulu nimu ora pogolasaasimi Go rabu Yesumi nipuna disaipel alinu gu-rupa lisa: Neme agale lagialua-le nimimi go agale waru pago piralepape. Ni enaali Raapu Pirape alina Siri ali medalomame koe alinu mea kateme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pare nimumi go saa pi agalena re namakuaasimi-pulu nimu paalame komoma nipu agale namisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gore disaipel alinumi ape puma naana rikiranare riri-nane aape aliri aapi yapae lo agale lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gore Yesumi nimuna kone adoma nipumi oge naaki meda nipu raapu mea mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Go pumare nipumi nimu lakalisa: Enaali raayo naa bi loma go oge naaki raba mealimi-daare nimimi ni page raba meme lisa. Enaali raayo kogono puma naaki ora oge gupiale raba mealimi-daare enaali mudu-rupa pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Go rabu Jon-me agale gu-rupa abulisa: Mudu Ali, ali medame nena bi loma koe remo mea rakepea-daa adama lisa. Go pea pare go alimi naana rikirana disaipel ali napia-pulu nipu giyape lo lakelama. ");
INSERT INTO kjs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Go rabu Yesumi nipuna disaipel ali medaloma gu-rupa lakalisa: Nimimi nipu giyoma natapape lisa. Enaali raayo nimi-para yada lore ali na-aulalimi-daare gore nimina adami enaali pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gote-me Yesu so yaa-para maa pope yapi rudu lisa. Go pisa raburi Yesu nipu Jerusalem palua kone suma pisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Go raburi ali medaloma-para kalu agale abala lo rapasa. Go alinu nimu pumare Samaria adare meda-para kodobaoma nipuna elenu kirita polalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Go pisa pare go su-para piri enaalinumi Yesu nimuna adare-para lamua pope giyasimi. Gore Yesuri nimuna lore alina su Jerusalem su-para penaalo adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Disaipel ali Jon Jems laapome go kone adoma nipu laapome wala puma Yesu-para talo: Mudu Ali, naame so yaa-para wia repena sulaame go enaalinu rabenalo mea rapaamina ya? ");
INSERT INTO kjs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Go lisimi pare Yesumi wala perekea luma nipu-para ora dia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Go puma nimu su rado-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nimu pora pagina pisimi rabu ali medame Yesu go-rupa lakalisa: Ne su raayona pali-parare ni go-para raita mea epalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Go lisa rabu Yesumi nipu gu-rupa lakalisa: Raa yananuri nimuna kana apedaa-para ada aaya. Go page yaanuri nimuna ada aaya pare Ni Enaalinu Raapu Pirape Alina Siri paitape ada meda na-aaya lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nipumi ali rado meda gu-rupa lakalisa: Neme ni raita mea ipu lisa. Go lisa pare mo ali nipumi lalaara gupa lisa: Neme nina aapa abala rogala pono laa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesumi nipu gupa lakalisa: Dia, nimuna wasa kome enaalinuri ora nimuna kome yagonumi rogaaina lape. Ne puma Gote-na Surube Su madaa agale puma lakelape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ali medame gu-rupa lisa: Mudu Ali, neme ne raapu banalo pi pare neme nina enaalinu abi piralepape lo ta pono laa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gore Yesumi nipu go-rupa lakalisa: Ali medame nipuna koau-nane wala perekeyo adalia-daare Gote-na Surube Su mada namilia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Werepe Mudu Alimi ali 72-pela medaloma mumare laapo laapo lo mea rapasa. Gore Yesu werepe penaalo adare su raayo-parare nimumi abala agale lakelaari pasimi. ");
INSERT INTO kjs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Go pisa rabu nipumi nimu gu-rupa lakalisa: Eda adaapu apo maapunu-para wia pare kogono enaali adaapu napimi. Go pea-le nimimi apo maapuna aaraa-para beten tapape. Go puma aaraame ali medaloma mo edanu mea kirita winalo beten tapape. ");
INSERT INTO kjs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pulupa. Nimiri sipsip mena-rupa mo raa yanana rikirana apo mea rapaato. ");
INSERT INTO kjs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nimina kana paus-para roka nu-para age ada go elenu nama-pulupape. Go puma pora pagina ae enaali-para abi piralepape pi natapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gore nimimi ada meda-para puma kodobalimi-daare abala nipu gu-rupa tapape: Go ada-para piri enariri epe-rupa piralepa tapape. Gore epe kone wi ali meda go ada-para pitia-daare nipumi nena epe kone muma abutea. ");
INSERT INTO kjs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pare ali meda gu-rupa napitia-daare nimina epe konere wala na-abuteare nimina wala mealimina. ");
INSERT INTO kjs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nimi ada meda-para puma piramina gialimide nape eda elenuri nalepape. Go puare kogono aliri nipu yoto ele mada mealia. Pare nimuna ada rado radonu-para ele namula pulupape. ");
INSERT INTO kjs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nimi adare meda-para palimi rabu nimuna ada-para epe-rupa mea kodobalimiri gore eda nimumi gialimide nalepape. ");
INSERT INTO kjs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Go adare-para yaina kome enaalinu ma-epeaalepape. Go pumare nimimi nimu gu-rupa laketapape: Gote-na Surube Su nimi piri re-para epea tapape. ");
INSERT INTO kjs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Go puma nimi adare meda-para pumare nimi nimuna ada-para nalamua palimiri go adare riri-nane puma aoma gu-rupa tapape: ");
INSERT INTO kjs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nimina adare-na kegere naana age madaa wina apo kunuma salema-daa tapape. Pare Gote-na Surube Su abi go re-para epaade tapape. ");
INSERT INTO kjs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neme nimi lagialo: Sodom adare-para koe enaalinu pisimi-pulu kedaa adaa meda kalisa. Go pisa pare go adare-para epe agale giyalimiri kedaa ora waru katea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesumi wala talo: Korasin su-para mo Betsaida go laapo piri enaalinu-para page ora kodo waru pia. Nimina su-para napi kogono pisade-rupa Tair su-para Saidon su lapo-para go-rupa pula pisa yalore go su lapona piri enaalinumi pupitagi giyoma kone pereketa pame. Go pula pisimi yalore nimumi mamina pobere yamoma repena sulaa taga-para pita pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gore Gote-me enaali koe kedaa katea raburi go koe su laapo Tair Saidon lapo-para kodome komoma kedaa katea. Go palia pare go adare-para piruma kone narulae enaalinuri nimi ora adaa kedaa meda mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nimi Kaperneam su-para piri enaalinuri nimina so yaa-para polalo peme pae? Dia nimi koe repena sulaa-para mea lopalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Go loma nipuna disaipel alinu lakalisa: Enaali raayome nimina agale pagalimiri gore nina agale page pageme. Pare enaali raayome ni koau wateme-daare gore ni page koau wateme. Gore ni koau wateme-daa abalade nimumi ni rapaasade Aapa page koau wateme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Werepe mo epe kogono ali 72-pela wala ipuma raaname komo aasimi. Gore nimumi talo: Mudu Ali, naame abalade nena bi lakelama pasima rabu koe remonu page naana agale pagame lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Go rabu Yesumi nimu go-rupa lakalisa: Go lisimi rabu yaa madaare Satan so repena sulaa-rupa wagepu lopesa-daa adisua. ");
INSERT INTO kjs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pagalepa. Neme nimi puri abala gisuade-pulu nimimi kero-para supi kalainu-para agale mada rogaalimi lisa. Go pumare nimimi Satan-na puri raayo rabuaaniaalimi rabu ele medame nimi mada nama-koeyaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pare koe remome nimina agale pa pageme-pulu go komea madaa raaname nakomalepape. Dia, pare nimina bi so yaa-para abala tapaya go madaa rana komoma palepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Go raburi Holi Spirit-mi Yesuna lo robaa-para raana komape kone kalisa rabu rubitabesa. Go rabu Yesumi talo: O Aapa, nere su kamaa page yaa-para page ora Mudu Ali pi. Abi neme kone adaapu wi enaalinu-para makuaae enaalinu-para nena kone kudiri puma skul-nane enaalinu mea waatede lisa. Ora gore Aapa, nena raanana pagaa wi gu-rupa pede-pulu ora pili. ");
INSERT INTO kjs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Naa Aapame kone-para ele raayo neme surubenalo gisa. Pare enaali raayome Sina kone na-ademe. Dia, pare Aapa komeamere adea. Go page enaali raayome Aapana kone na-ademe pare Simi komeamere Aapa adea. Go pea pare Simi enaalinu Aapana kone waalalo palia-daare nimumi page aapa mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Go rabu Yesumi perekea luma disaipel alinu-para talo: Nimimi go adaleme ele madaare nimi ranaa komo piramina. ");
INSERT INTO kjs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Neme nimi lagialo: Abalade ali mudunu page Gote-na agale lakale alinumi page abi nimi ademe ele adolalo pisimi. Pare nimumi go ele na-adisimi. Go page abi nimimi go pageme agale pagolalo pisimi pare napagesimiya lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gore rekena agalena tisaa meda Yesu piri-para ipuma Yesu kotalalo pisa. Tisaa-ya, neme ake puma adae abuna kagaa pirape kone wasa mealua ya? ");
INSERT INTO kjs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Gore Yesumi nipu go-rupa lakalisa: Gote-na buk-parare ale lea wia? Neme akepu diminaaripi pae? ");
INSERT INTO kjs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Gore nipumi agale gu-rupa lakalisa: Nena Adaa Gote madaare lo robaa raayome page kone wasa raayome page puri raayome page raana komalepape lea. Go page nimina nimi raana komalimi-rupare nimina yagonu page komea-rupa go palepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Gore Yesumi nipu go-rupa lakalisa: Gore neme agale waru abulae. Neme go-rupa pali-daare ne adae abuna epe-rupa kagaa pirali lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yapare go rekena agale lisa alimiri nipuna bi komea waru epena kone wisa-pulu nipumi Yesu wala lakalisa: Gore rekena agaleme nina ada lapa piri enaalinuri aapi-para lea pae? ");
INSERT INTO kjs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Gore Yesu nipumi remaa gu-rupa lakalisa: Ali medame nipuna Jerusalem su-para giyoma Jeriko su-nane pisa. Go rabu koe paake ne alinu nimu pora madaasimi rabu luma nipuna mamina-nu koyoma nipuna elenu misimi. Go pumare nipu waru luma pornane pa le kadupitalo palaina giyoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Go raburi Gote-na Lodo Kirae Ali meda go pora kuru maa pisa. Gore nipumi go mudu ali giyoma mo pora renane pakeama puma pisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Go pisa rabu ali meda nipu Livai-repaa ruru piri ali nipu ipisa. Nipu pora renane ipuma mode ali tapae wisa ai adomare mo pora kebo-nane pakeaoma giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Go pisa pare Samaria su-para piri ali komeare mo pora pagina ipuma go ali tyapaina adoma lisana nipuna pu-para ora kodome komisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Go pisa-pulu nipu re-para puma minasaoma marasin wel-para ipa wain koyo paboma mo nipuna rere rogaasa. Mo rere rogaa kiraloma mo ali marekaaoma nipuna donki mena koauna mea mapiraasa. Go pumare nipumi pora kimisu alinu paitape ada meda-para puma waru piama surubisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ekera-nanere go alimi kimisu alinu paitape adana aaraa kana 100 kina-rupa puma kalisa. Go puma nipumi gu-rupa lakalisa: Neme go ali waru surubape. Gore nena kana medaloma mogo ali madaa palia-rupa wala ipuma epa abutua. ");
INSERT INTO kjs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Go loma lisana Yesumi wala talo: Gore abi neme ake kone sale pae? Ali repo pora pagina epame pare mode tyapasade alina adami aliri aapi ya? ");
INSERT INTO kjs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Go rabu mo rekena agalena tisaa-me talo: Go kimisu aliri kodome komoma raba meaana lisa. Go rabu Yesumi nipu lakalisa: Ne pumare neme go-rupa puma pape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu nipuna disaipel alinu raapu adare meda-para pisimi. Go-parare ena meda nipuna biri Marta go ename Yesu nipuna ada-para epe-rupa lamua pisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nipuna aki meda nipuna biri Maria pirisa. Maria nipu Mudu Ali-na age re-para epa piruma nipuna agale pagisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Go pisa pare Marta-re kogono adaapu puma nimuna nape eda yarera pirisa. Go pisa rabu Marta nipu Yesu piri-para puma agale lorapisa: Mudu Ali, nina akimi ni giyaade-le neme komea eda kiru pi-le go kone madaare ake kone sali pae? Ni epa raba mina neme lakala lisa. ");
INSERT INTO kjs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Go lisa pare Mudu Alimi nipu-para agale go-rupa lakalisa: Marta, kodo pia. Neme kone adaapu suma nena lo robaa-para kari-yapa pea. Nere ele raayo madaa kone sale. ");
INSERT INTO kjs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Go pea pare neme kone komea sape. Go nena aki Maria-me mulalo pia elere naame koe kone nasamina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yapi medame Yesu nipu su meda-nane beten lala pirisa. Werepe beten abala lo kiritinalomare nipuna disaipel ali medame nipu go-rupa lakalisa: Mudu Ali, neme naare beten lape-rupa moge riape. Abalade Jon-me nipuna disaipel alinu lariaaripa neme page naa lariape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Gore nipumi nimu go-rupa lakalisa: Beten lape agale leme raburi nimimi gu-rupa tapape lisa: O Aapa, Nena biri adae abuna ora epe-rupa wina. Nena Surube Su epena. ");
INSERT INTO kjs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Abi go yapi komea madaare naana eda giyaina. ");
INSERT INTO kjs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Naana koe elenu mea rubaina-le naame page abala koe kone saapirape enaalinuna kone mea rubalima. Neme naa kedaame komape elere koe nalina. ");
INSERT INTO kjs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesumi go-rupa loma lisana nipuna disaipel alinu go-rupa lakalisa: Gore nimi medamere ribaa rumu rumuna puma nipuna adami ali gupa agaa mealimi: Adami ali, neme ni bret ipa repo giaina puma le. ");
INSERT INTO kjs_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Naa adami ali meda pora kimisu pamuma reame komoma nina ada-para epa pia. Go pea pare neme kalape eda dia yaade. ");
INSERT INTO kjs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Go le raburi mo ada ru-nane pia adami alimi go-rupa tea: Neme ni radaa pi kogono nagiape. Pora gaape ora poma abala luma nina nogo naakinu raapu abala paitawa tea. Neme rekoma ele mada nagialua tea. ");
INSERT INTO kjs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Go tea rabu neme ake pali ya? Neme nimi lagialo: Gore mo alimi ne nipuna adami enaalinu bret nagilia-daare ne yala napote pare ne rekoma agale wala laina. Agale pa lalaina-pulu nipu rekoma nena elenu gialia. ");
INSERT INTO kjs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Go remaana re neme nimi lagialo: Gore nimimi Gote-para beten go-rupa tapape. Go palimiri nipumi nimi ele su gialia. Nimimi ele asa palimiri nimimi mada adasaalimi. Nimimi pora gaape lu piralimiri Gote-me pora gaape mada epa lobalia. ");
INSERT INTO kjs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Enaalinumi Gote-para beten temere gore ele mada mealimi. Enaalinu ele asa palimiri nimumi ele mada adasaalimi. Enaalinumi pora gaape timiri gore Gote-me nimu-para pora ora lobalia. ");
INSERT INTO kjs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gore nimina naaki nogonumi nimi-para wena meda gialepa leme-daare koe kero meda mea kaleme ya? ");
INSERT INTO kjs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Dia-le mo naakimi yaa kapa meda gi tea-daare betamu meda mea kaleme ya? Dia-le mada nakaleme. ");
INSERT INTO kjs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gore nimi koe alinu pimi pare nimina naaki-para epe elenu kalemede. Go pemede-le waru pagalepa. Naana so yaa-para pia Aapamere enaalinumi beten teme-daare Holi Spirit gialia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Koe remome ali medana agale mea maraasa rabu Yesumi go remo mea rubisa. Go rabu go alina agale lapaasa. Go puma enaali raayome kone adaapu suma pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Go pisa pare enaali medalomame talo: Koe remonuna ali mudu Belsebul-mi Yesu puri kalea rabu mea rubaaya lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Go lisimi pare ali medalomame Yesu kotalalo pisimi-pulu Yesumi napi kogono meda pinaloma adamono lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pare Yesumi nimuna kone adoma nimu gu-rupa lakalisa: Adare meda-para piri enaalinu rugutalalo puma yada palimiri go adaa rururi koro dia yalimi. Go page ada medana aaraalu rugutalalo paliare go aaraalu mada nakibuma piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gore Satan-me nipuna surube enaalinuri rugutalalo mapeaalia yalore nipuna puri page ake puma epe-rupa nasalia ya? Mada Dia, pare nimimi koe remonuna mudu Belsebul-na purimi mea rubaayo teme. ");
INSERT INTO kjs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Neme go purimi mea rubaayo teme-daare gore nimina naakinu madaare ake puma neme nimuna remonu mea rubaayo pae? Nimina naakinuna koe remo radonu puma mea rubaayo-le nimimi ora agale nalaeme. ");
INSERT INTO kjs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dia-le Gote-na purimi ni puri gisa-pulu go koe remonu mea rubaayo. Go pe-pulu Gote-na Surube Su nimi piri-para abala epaade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gore puri pale ali medame edali ripinuma nipuna ada-para surubaliare gore nipuna ele raayo epe-rupa pa salia. ");
INSERT INTO kjs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Go palia pare puri waru pale ali rado apo alina ada-para ipuma lumare mako saalia. Go pumare apo alina eda-para rai napi-para go surubape ele paake noma ali medalomanu-para surubape ele ruma katea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Enaali raayo nina adami enaali napitimi-daare gore nina yada lore ali pimi. Enaali raayome ni raapu ele nakiritemere gore nimumi raa-para mea ralu rubalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gore koe remome ali meda giyaliare gore nipu su kaapu le-para pomo mu pirape su asapulalo pea. Gore nipumi go su meda na-adomare nipumi talo: Abalade nina pirisuade ada-para wala palua tea. ");
INSERT INTO kjs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Go paa-daa nipu puma nipuna abalana ada-para wala puma adea rabu nimumi puluma ki age au puma wari. ");
INSERT INTO kjs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Go adea raburi wala ora koe remo ki medane luma medane laapo medaloma puma lamu misa. Go pumare nimu raayo mo ada ru-nane puma kodobaoma pimi. Go peme rabu abalade mo ali nipuri koe-rupa pirisa pare wala abi raayo piruaeme-pulu go ali abi ora koe-rupa pa pilia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesumi enaali adaapu kirata pirinaloma agale gu-rupa lisa: Go enaalina rikirana pirina ena komeame agale gupa yaalasa: Gore abalade ne maduma adu gisade enare nipu komeamere pedo waru pina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Go lisa pare Yesumi gu-rupa lisa: Ora lale pare enaalimi Gote-na epe agale wala pagoma raitalimi enaalinumiri gore ora pedo pina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Enaali adaapu pa epa kiritaba pirina nimu gu-rupa lakalisa: Abi go yapi di rabu pimi enaalinuri ora koe enaali pimi. Nimumi napi kogono meda adamono leme pare neme go-rupa kogono meda nawatoa. Dia, pare Jona nipuna napi kogono pisade go komea mea waatoa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Abalade Jona Gote-na agale lakale ali pirina mo Ninive su-para piri enaalinumi Gote-na puri pale kogono adisimi. Abi go rabu page ni enaali Raapu Pirape Alina Si Gote-me go enaalinumi adenalo napi kogono palua rabu adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Werepe Gote-me enaalinuna kose lape di madaare no re-nane ena mudu komeame rekoma abi piri enaalinu nimuna koe ele madaa kose lape agale lagialia. Gore go ename abalade Solomon-na epe mogeape agale pagola ipisa-pulu nipu su raayona kale-nane pamisa. Go pisa pare nimina rikirana eleme apo Solomon-na kone ora ma-oge yaaya. Go pea pare enaalinumi nipuna agale napageme. ");
INSERT INTO kjs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gote-me enaalinuna kose lape agale di madaare gore Ninive su enaalinumi rekoma lisimina go abi piri enaalinumiri Joname agale lakalisa-daa nimumi kone perekealisimi. Go pisimi-pulu nimi madaa kose lape agale mada lagialia. Go palia pare abi nimina rikirana piri alimi Jona ma-oge yaaya lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesumi wala talo: Enaalinumi lam kewoma go lam baket rolo-para nasalemede lisa. Dia, pare nipumi madumaloma enaalinumi go paa adoma ada ru-nane epa kodobalimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nena lere nena yogalena paa lam-rupa roaaya. Gore nena le laapo epe yaaliare gore nena to yogale raayo paa rubitabalia. Pare nena le koyaliare gore nena to yogale raayo ribaa yabalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gore nena lo robaa-para wia paa wala ribaa yaalia waru adalepape. ");
INSERT INTO kjs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gore nena to raayo-para paa paliare kalekale-nane page ribaa nayaabalia. Go rabu lam-na paa le madaa piraita ipulade-rupa nena to yogale-para paa gu-rupa rubitabalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesumi go agale abala naloma Farisi ali medame nipuna ada-para eda nola ipu lisa. Go lisa rabu mo ali nipuna ada-para puma eda nala pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gore Yesumi eda nala piruma waswas abala nalisa-pulu mo Farisi alimi adoma nipumi kone adaapu wisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Go pisa rabu Mudu Alimi nipu gu-rupa lakalisa: Gore nimi Farisi alinuri nimimi plet kap-nuna yogale radepealeme. Go pea pare nimimi plet kap-nuna ru-parare naradepealeme. Go pea pare nimina lo robaa-para ele adaapu saapirape kone su pupitagi nape kone page apo rubitabea-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nimiri makeae alinu pimi. Gote-me enaalina to yogale warilalo nipuna robaa page nawarisa pae? ");
INSERT INTO kjs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pare nimina plet kap-nupara saapiri elenu medalomame naaralinu katepape. Go palimi rabu nimi epe-rupa piralimina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pare Farisi alinu nimi waru adalepape. Nimi yabia meda-para rakia-para padi raani medaloma-para warea go oge ele page Gote medaloma kaleme. Go peme pare nimimi epe-rupa sape kone-para Gote madaa kone rulape kone-para giyeme. Pare nimimi go kone suma moge nagiyalimiri gore epelea. ");
INSERT INTO kjs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nimi Farisi alinu nimimi waru adalepape. Nimi lotu ada ru-nane puma ora-nane pirape siaa madaa raaname apo komalimi-daa. Go page nimi kiritape maket ada-para puma enaalinumi nimi-para abi piralepape leme-daa raaname komeleme. ");
INSERT INTO kjs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nimiri waru adalepape. Nimina kone gu-rupa: Nimi pa awemede tapa-rupaga gore pa enaalinumi na-adomare rekena lusuma rabuaemede. ");
INSERT INTO kjs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Go rabu rekena agalena tisaa medame gu-rupa lisa: Tisaa, neme go-rupa loma naa-para ero agale naa mariaaye. ");
INSERT INTO kjs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesumi talo: Nimi rekena agalena tisaanuri waru adalepape. Nimimi kedaa pi ele enaalinuna koau-nane mea mariaaeme. Go peme pare nimu riape-rupa maarea pare go kedaa pi ele rinalo nimimi raba meape kone nasalimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nimimiri waru adalepape. Nimina kasuanumiri Gote-na agale lakale alinu lisimiya. Go pirisimi pare nimimi go kasuanuna rogaape apedaa wariaoma au epe-rupa paeme. ");
INSERT INTO kjs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Go peme rabu nimimi nimina kasuanuna koe pisimide kone makuaaoma raaname komeleme. Nimina kasuanumi Gote-na agale lakale alinu lu makomeama rogaasimi-le nimimi nimuna tapa wariaoma au pame. ");
INSERT INTO kjs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Go madaare Gote-me epe makuaae kone suma talo: Neme nina agale lakale alinu page aposel kogono alinu page nimu piri-para penaaato. Go palua pare nimumi go ali medaloma lu makomeama medaloma kedaa pi ele kaleme. ");
INSERT INTO kjs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Go lisa-pulu go piri enaalinuri abalade mo Gote-na agale lakale alinu lu makomasimi madaa abi page ora kedaa adaae mealimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abala Gote-me su ya warinaloma mo ali Abel lu makoma ipuma Sekaraia epe lu makomasimi rabu page kedaa adaae mealimi. Go aliri Gote-na ada ru-nane pirisa rabu kana reke-para Gote-na epe pirape ada laapona rikirana lu makomasimi. Gore neme nimi lagialo: Abalade Gote-na alinu lisimide kogonona kedaare abi go piri enaalinu nimimi ritimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nimiri rekena agale tisaanu-ri nimimi waru adalepape. Nimimi kone makuaae meapena pora lobape ki nimimi riti peme. Go peme pare nimina kadobaitalo pora gaape nalobeme. Go page enaali meda kodobalalo page kone salimi pare nimimi pora poame. ");
INSERT INTO kjs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesumi go su giyesa rabu mo rekena agale tisaanu-para Farisi alinu-para Yesu madaa koe ero agale loma nipu madaa agale rado rado misimi. ");
INSERT INTO kjs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nimumi agale loma nipu kotalalo pisimi-pulu nipu agale adaapu agale lorapisimi. Nipumi aleda tea-daare nimumi nipu kose madaa mea adialalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Enaalinu ora adaapupe kiritaoma rubitabaomaa medana ali madaa aata pisimi rabu Yesumi nipuna disaipel alinu-para agale abala gu-rupa lisa: Nimi go Farisi alinuna bret ma-adaa sape yis-ri waru adalepape. Neme nimuna makirae agale madaa talo. ");
INSERT INTO kjs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ele raayo pagaa sabaaya elere werepere kamaa salia. Go page ele raayo kudiri pu wiare werepere pename waatea. ");
INSERT INTO kjs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Go pea-pulu agale raayo ribaale-para lisimi yaade agalere enaalinumi epe paa-para piruma pagalimi. Gore agale medaloma pawasi ru-para piruma lisimi yaadere so rudu madaa aoma lamonealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Naa adami enaalinu nimiri gu-rupa lagiano: Enaalinumi to yogale timi-daare paalame nakomalepape. Go pumare werepe nimumi yada meda mada napalimi. ");
INSERT INTO kjs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nimi paala komape enaali nimi lagiano. Gote madaa paala waru komalepape. Nipumi enaali lu makomeama werepe repena sulaa-para mada mea lopalia. Gore neme nimi lagialo. Go ali komea madaa paalame komalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nimimi ademe kana 2 toea-rupa yaa magaita supu kabeme. Pare Gote-me yaa oge-ai go-rupa madaare kone narugulaaya. ");
INSERT INTO kjs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nipumi nimina kalu-para iri raayo abala yarepelea. Gore nimimi paala nakomeleme-le nimimi ogege kabape yaa-rupa gona yoto ma-oge eleme. ");
INSERT INTO kjs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gore neme nimi lagialo. Enaali raayo pa enaalinuna le-aga madaa nina bi lakelemere gore ni enaali Raapu Pirape alina Si neme page Gote-na ensel-nuna le-aga madaa go enaalinuna bi laketoa. ");
INSERT INTO kjs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Go palua pare enaali raayome enaalina le-aga madaa ni koau waatemere gore Gote-na ensel-na le-agaa madaa enaali Raapu Pirape alina Si neme nimu koau waatoa. ");
INSERT INTO kjs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Enaali raayome enaali Raapu Pirape alina Si madaa koe agale leme-daare gore Gote-me go enaalina koe ele mada mea rubalia. Go palia pare enaali raayome Holi Spirit madaa ero agale teme-daare Gote-me go enaalina koe ele nama rubalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Gore nimumi nimi lotu ada-para maa puma namba wan gavman page adare ali kalunumi page kose pagenalo maa palimi. Go rabu nimimi paalame nakomoma kone adaapu nasalepape. Gore naame agale akepu abutema yapae naame agale akepu laketema yapae kone nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gore nimimi lape agalere Holi Spirit-mi nimina kone-para mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Go rabu go pirisimi enaalina rikirana piri ali medame gu-rupa lisa: Tisaa-ya, Aapana moae-elenu mo ameme rumaaoma gina. Neme rumaaoma ni gina neme lakela lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Go lisa pare Yesumi nipu go-rupa lakalisa: Ali ya? Ni nimina kose pagape ali-para nimina ele rumaape ali-para ni-daa dia. ");
INSERT INTO kjs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gore nipumi nimu gu-rupa lakalisa: Nimimi waru adoma surubalepape. Nimimi epame komape kone giyalepa. Ali medame nipu ele adaapu salia-daare nipumi go elenu madaa epe pirape kone mada namealia. ");
INSERT INTO kjs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Go rabu Yesumi nimu-para saa pi agale meda gu-rupa lisa: Kamope medana epe su adaapu wi-para maapu eda ele adaapu opoma nape lea. ");
INSERT INTO kjs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Go raburi go kamo le ali nipuna kone-para gu-rupa wisa: Abiri mo eda medaloma kirita sape adare dia yade-le neme ake palua pe kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gore nipumi kone gu-rupa wisa: Neme go-rupa palua. Neme nina eda sape adanu kilipima ada ora adaae medaloma palua. Go pumare nina wit-na kili-para mo eda raayo go adanu-para mea kirita salua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Go palua kone salo: Go ali nipuna epe ele raayore saapirano maali adaapumi popalia pare epe-rupa pitua. Go pea-le abiri neme pomo mu piruma eda ipa nala pumare ranaa komo pitua kone wisa: ");
INSERT INTO kjs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Go kone wisa pare Gote-me nipu lakalisa: Nere makeae ali lisa. Abi go ribaa ne komali-le abalade nena mea kiritaoma saede elenuri aapimi meali ya? ");
INSERT INTO kjs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Go rabu Yesumi agale gu-rupa lo kiritasa: Enaalinumi epe ele adaapu salimiri apo makeae alina kone mogeleme. Go palimi pare nimu Gote-na le-aga-para kamo enaali napimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Go rabu Yesumi nipuna disaipel alinu gu-rupa lakalisa: Go remaa madaa kone mealepa. Naame ele nalima palo epe-rupa piralima palo kone adaapu nasalepape. Go page nimimi naare yogale madaa ele maraalima palo kone adaapu nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gore epe-rupa piruma yogale surubalima rabu eda nape ele-para mamina maraape-para go madaa kone adaapu nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nimimi yaanuri adalepape. Nimumi enaalina kone namogeaoma nape repena kili napoma eda namuma kereme. Nimuna eda kiritape ada page na-aaya. Dia, pare Gote-me nimu raba muma eda katea. Gore nimi enaalimiri mo yaanu ora rabuaniaaeme. ");
INSERT INTO kjs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nimina enaali medame go ele madaa kone adaapu salia-daare gore nipuna maali ogesi-daa wala adaalupu mada yoloma pitia yapae? ");
INSERT INTO kjs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dia-le gore nimimi oge eda elenu nasurubeme-le nimimi pa ele medaloma madaa kone adaapu nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nimimi plaua kili adalepape. Nimumiri kogono napuma mamina page nawaritimide. Dia, pare pagalepa. Abalade mo kamope Solomon-mere nipuna au raayo pisa pare mo plaua kilinumi nipuna au ma-oge yaaya. ");
INSERT INTO kjs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gore Gote-me mo su kamaa rilipu ma-opaaoma nipuna au paaya. Go pea pare go pa rilipinu ekera-nanere nimumi poma repena sulaa-para kiralimi. Go puma nimimi go rilipu ma-oge saleme-pulu Gote-me nimina maraape mamina guma nimi waru surubalia. Go kone adaapu saleme rabu nimina kone rulapere ora ogepu saapiruaeme. ");
INSERT INTO kjs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Go pea-le nimimi nape ele madaa kone adaapu nasalepape. Go page naa ele nalima palo kone nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gore go su kamaa piruma kone narulae enaalinumi go elenu raayo asa peme. Pare Aapame nimina kone gu-rupa wimilo abala makuaaya. ");
INSERT INTO kjs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nimimi Gote-na Surube Su madaa kone rulaalepape. Go palimi rabu mo elenu page mada gialia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nimi oge sipsip menasinuri nimimi paala nakomalepape. Nimina Aapame nipuna Surube Su gulalo ranaa komo pia. ");
INSERT INTO kjs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Go pea-le nimina ele raayore nimumi kabenaloma kana-re mo enaali naralinu katepape. Go palimiri nimina kana paus ora puri pale suma so yaa-para epe elenu mada kirita salimina. Go puma so yaa-para wi elere na-alupalia. Go page so yaa-parare paake ne alimi page namula epea. Go page so yaa-parare alurai-para daalinu-para nimumi page go ele nanola epea. ");
INSERT INTO kjs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gore nimimi epe elenu kiritaeme-parare nimina kone page go-para kama pea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nimina mamina aako let-me marudu yaatapape. Go puma lam kewoma kiritaoma piralepape. ");
INSERT INTO kjs_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nimi go-rupa piralepa lisa: Kogono naakinuri nimuna Mudu Ali madaa adoba piralemede-rupa piralepape. Go surube aliri nipu mo ena lamulalo eda yaweme-para adola epalia. Go pea-le mo kogono naakinu adoba pimi. Nipu ipuma pora gaape epa tiare kogono naakinumi pora gaape wagepu mada lobalimi. ");
INSERT INTO kjs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Go adaa ali epa adalia rabu nipuna kogono naakinumi u napaluma adaba pitimi. Go pea-le go kogono naakinuri ranaa komo maa pitimi. Pagalepa. Go Mudu Alimi raaname komoma mamina aako let-me ma-rudu yaaoma nimu reke madaa mapiraalia Go pumare nipuna eda epa katea. ");
INSERT INTO kjs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gore nipu ora rumu rumuna epalia palo yaa kakarega ripia rekaliade rabu epalia palo marea pare nimi u napatalimi. Gore nipumi go kogono naakinu madaa ora pedo pedo waru palia. ");
INSERT INTO kjs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nimi go agale pagalepa. Gore adana aaraame paake ne ali nipuna ada opalialo kone suma napaitalia pare pa pitia. Go rabu mo paake ne ali epalia mada nakodobalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gore enaali Raapu Pirape alina Si nimimi namakuaaoma pa piralimi rabu epalia. Go pea-le nimimi page waru adoba pitaapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Go rabu Pita-me go-rupa lisa: Mudu Ali, neme go lae agalere naa-para kama lae pe pa enaalinu raayo-para lae ya? ");
INSERT INTO kjs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gore Mudu Alimi talo: Gore epe kogono puma kone wi naakiri aapi ya? Go naakiri nipuna Mudu Alimi ada piri enaalinu surubenalo kogono katea. Go naakimiri enaali medaloma nimuna eda rumaainalo mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Werepe Mudu Ali ada wala ipuma mo kogono naakimi lakalesa-rupa kogono pina adaliare nipu madaa raaname komalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neme nimi ora lagialo. Go rabu Mudu Alimi nipu ele raayo surubenalo ali mudu mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yapare mo kogono naakimi kone gu-rupa mada salia: Naa ali adare abi wagepu na-epalia kone salo. Go kone suma nipumi kogono naaki nogo medaloma luma eda no ipa bia noma nipu makeyaalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kogono naakimi go-rupa pu piruma Mudu Ali abi na-epea kone su epe-rupa nasuruba pitia. Go palia rabu nipuna Mudu Ali koro meda wagepu epalia. Ipumare raimi muma mo kogono naaki nipu waru luma nipu kogono waru nasurube naakinu raapu maa rubalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mo kogono naakimiri mo nipuna Mudu Ali-na kone adea pare nipumi Mudu Alina kogono napaliare Mudu Alimi ora puri waru paboma poteyaalia. ");
INSERT INTO kjs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pare mo kogono naakimi nipuna Mudu Alina kone na-adea pare koe kedaa kogono pinaloma Mudu Alimi ogepusi poteyaalia. Gore enaalinu ele adaapu palimiri nimumi page ele adaapu wala mada abuleme. Go pea-le enaalinu ora ele adaapu mu aaemere nimumi ora ele adaapu medaloma page abuleme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Neme go su kamaa ipisuare repena marekaata ipisua. Go pea-le go repenare abi rena kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Neme kedaa pi kalu-ipa rado nona pi mealua pare nina lo robaa-para kedaa waru pia. ");
INSERT INTO kjs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gore nimimiri niri go su kamaa piri enaali epe-rupa mapiraalalo ipisua kone wimi pae? Neme pa su kamaa epe-rupa pirape kone namuma ipisua. Dia, pare enaalina rurunu marugulala ipisua. ");
INSERT INTO kjs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Abi page werepe page enaali supu komea ada-para pitimiri nimu rugutalalo pama piralimi. Go puma ali repomere mo ali laapo-para yada lore ali aulalimi. Go-rupa puma mo ali laapomere mo ali repo-para yada lore ali aulalipi. ");
INSERT INTO kjs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Go rabu aaraame nipuna naakinu raapu yada lorealia. Go puma naakinumi nimuna aaraa-para yada lore ali aulalimi. Go page agimiri nipuna wanenu raapu yada lorealipi-pulu wanenumi nimuna aginu madaa yada lore ali aulalimi. Ayaa medalomame nipuna naakina were madaa yada lorealia-pulu go werenumi nimuna aayaanu madaa yada lore ali aulalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesumi go enaalinu-para page lakalisa: Nimi naare pabala aaya-nane mole meda rekalaina ademe rabu wagepu nimimi yai epolalo pia leme. Gore ora leme rabu yai ora mada epea. ");
INSERT INTO kjs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Go page no re-nane puri pale po rilipu epea rabu ademere abi pani pia leme. Gore ora leme rabu naare reade. ");
INSERT INTO kjs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nimiri makirae enaalinu pimi. Nimimi yaa-para su laapona robore waru adoa makuaaeme. Go peme pare nimimi abi go yapi di meda sade elena re na-ademe lisa. ");
INSERT INTO kjs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Gore nimimi ele ademe rabu nimimi ake paa-daa waru na-ado rekele peme? ");
INSERT INTO kjs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ali medame ne kose laaoma adialalo palia-daare nipi pena pora pagina pulaaoma nipina agale ma-redepo yaaoma pulupape. Go napaliri nipumi ne mo kose page ali piri-para maa palia. Gore kose pagape alimiri edali rili alinu mea katea. Go rabu edali rili alinumiri mo karapo ada-para mea mapaitaalimi. ");
INSERT INTO kjs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Go pea-le neme ne lagialo: Ne mo karapo ada-para wagepu mada na-kepealimi pare abala ririna oge yago abala mada abulaina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Go raburi enaali medaloma piruma Yesu-para Galili su-para piri alinu medaloma remaa lakalisimi. Go alinumiri nimumi Gote madaa mena yapi ele raapu kana reke madaa kirisimi rabu Pailat-me nimu lu makomasa. ");
INSERT INTO kjs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Gore Yesumi nimu-para agale gu-rupa lakalisa: Nipumi Galili alinu gu-rupa lu makomasa-pulu nimumi Galili su-para piri enaali medalomana pupitagi nape kone ma-oge yaasimi kone wimi pae? ");
INSERT INTO kjs_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Neme ora nimi lagialo. Ora dia-le nimi raayo pupitagi nape kone naperekealimiri nimu komisimi-rupa kama komalimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gore abalade Siloam su-para piri ali 18-pela nimuna remaa napageme pae? Nimu kogono puma kaname warili adaalu ada meda nimu madaa lopoma lu makomasa. Go pisa-pulu nimumi mo Jerusalem su-para piri enaali medalomana pupitagi nape kone ma-oge yalisade kone wimi pae? ");
INSERT INTO kjs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dia-le nimi waru lagialo. Nimina pupitagi nape kone nagiyoma kone naperekealimiri nimi raayo go-rupa koe su-para kama palimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gore Yesumi saa pi agale meda gu-rupa lisa: Ali medame nipuna wain maapu rikirana repena fik poasa. Werepe nipu nape kili medaloma elea paleme adama ipisa pare na-elesa. ");
INSERT INTO kjs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Go pisa raburi nipumi mo maapu surube ali gu-rupa lakalisa: Abiri maali repome go maapu-para repena kili elaana paleme asa pula epawa pare na-elaana. Go repena po rubape-le go repename mo suna ipa pa noma ma-koyaaripana lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mo maapu surube alimi agale gu-rupa lakalisa: Mudu Ali, abi go maali komeare pa aainawa. Gore nipuna pitaa re-para aoma piriri puma gawa menana i mea awo pabalua. ");
INSERT INTO kjs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wala go ma-alimi kili matiare epe tea pare namaitiare gore po rubaina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pomo mu Pirape Yapi di meda rabu Yesumi lotu ada ru-nane piruma agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Go-para ena meda pirisa ena nipu madaa koe remo meda pirisa. Gore romome mo ena nipuri yaina maali 18-pela palisa rabu mo koau roboma nipu mada namaridulaasa. ");
INSERT INTO kjs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesumi go ena adomare gu-rupa yalisa: Go ena, nena yainare abala mea rubaaripude. ");
INSERT INTO kjs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nipumi mo enana kalu madaa ki wisa rabu wagepu mode ename koau maridulaaoma rekoma aasa. Go rabu ename Gote-na bi minasaasa. ");
INSERT INTO kjs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Go raburi Pomo mu Pirape Yapi di yade. Go pea-le Yesumi go enana yaina ma-epeaanyaloma mo lotu ada surube ali mudumi koe kone yawesa. Go pisa rabu ali mudumi enaalinu gu-rupa lakalisa: Gore kogono pape yapi 6-pela wia. Nimimi yaina maperekeaina kone salimi-daare kogono pape di rabu ipulupape. Pare go kone salimiri Pomo mu Pirape Yapi rabu naipulupape. ");
INSERT INTO kjs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Go raburi Mudu Alimi nipu gu-rupa lakalisa: Nere makirae agale le ali yana. Nimiri Pomo mu Pirape Yapi rabu nimina gawa mena-para donki mena-para gonumi ipa nenalo ada-para puma kepealalo peme. ");
INSERT INTO kjs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Go peme pare go enare nipu kasua Abraham-na wane pia pare Satan-me maali adaapu (18) nipu madaa palisa. Go pea-pulu Pomo mu Pirape Yapi korome nipuna yaina adialape kope-rupa mada na-kepealua yapae? ");
INSERT INTO kjs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nipumi go-rupa lisa rabu nipuna lore alinumi yala polasimi. Go pea pare enaalinumi nipuna epe ele raayo madaa raaname waru komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesumi gu-rupa lakalisa: Gote-na Surube Yapi di-ri ele madaa meano ya? Ake madaa mealua-daa epelea ya? ");
INSERT INTO kjs_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Go pi lano: Oge repena mastet kiliri ali medame go kili muma nipuna maapu-para poasa. Gore werepe opoma lisana adaa repena opalia. Go rabu yaanuri go repenana palaa madaa nimu ada wari piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gore Yesumi wala lisa: Neme Gote-na Surube Su madaare ake lagiano ya? ");
INSERT INTO kjs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gu-rupa lagiano: Gore bret ma-adaa sape yis-rupa ena medame go yis muma palaoma ipa raapu adaa pe-para mea perekelisa. Go palaoma ora adaa salia. Go yapare Gote-na Surube Su adaa salia rabu enaalinu adaapu pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesumi oge adare-para page oge adare-nini page pamisa. Go rabu nipumi enaali medaloma agale mogeaa-ma puma nipu Jerusalem su-para pulalo pisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Go rabu ali medame nipu lorapisa: Mudu Ali-ya, gore Gote-me enaali ogepusi ade abuna kagaa piramala mapuaalia ya? Go rabu Yesumi nimu go-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Abi nimimi oge pora gaape-para ora kodobata pulalo pulupape. Neme nimi lagialo. Enaali adaapu go pora gaape-para werepe kodobatalo palimi pare mada dia. ");
INSERT INTO kjs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Werepe mo ada surube alimi rekoma ada pora gaape po salia. Go palia rabu nimi kamaa-nane epa rekaoma pora gaape luma gu-rupa lalima: Mudu Ali, naa epamono pora loba lalima. Go rabu nipumi nimi-para gu-rupa tea: Nimi na-adawade-le aa-para piruma epame pe ni maarea tea. ");
INSERT INTO kjs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Go rabu nimimi nipu gu-rupa lakeleme: Naare abalade ne raapu ipa no eda namade lalima. Neme abalade naana adare-para ipuma naa agale page lagiade. ");
INSERT INTO kjs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pare nipumi nimi gu-rupa tea: Nimiri aa-para piruma ipulumi palo gore ni maarea tea. Nimi raayo pupitagi noae enaalinu pimi-le nimi raayo ni piri-para giyoma pulupa tea. ");
INSERT INTO kjs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gore Abraham-para Aisak-para Jekop-para Gote-na agale lakale ali raayo-para nimumiri Gote-na Surube Yapi-para pitimi. Go puma nimimi nimu adalimi pare nimi kamaa-nane mapiraalia Go rabu nimimi kabulu regepe noma re lo piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Go rabu pa enaalinuri naare opala aaya-nane page naare pabala aaya-nane page re lapone page epalimi. Go raayore Gote-na reke madaa eda no piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Go rabu abi aapu-nane pimi enaali medaloma riri-nane puma abala mudu piralimi. Go page abi mudu enaali medaloma pirimiri go rabu nimu ora werepe aapu-nane piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oge-daa piruma Farisi alinu medaloma Yesu piri-para ipuma agale lakalisimi: Ali mudu Herot-me ne lu makomaatalo pia-le neme go su giyoma su rado-para pu lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gore Yesumi nimu go-rupa lakalisa: Nimimi go kira yanana si-para gu-rupa puma laketapape: Abi-para ekera laapore neme go koe remonu mea ruboma yaina kome enaalinu maperekeyatalo pi. Go puma kogono repome nina kogono dia yaalia-le puma laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Go rabu Yesumi nimu agale gu-rupa lakalisa: Pare abi ekera rudane ni pamualua. Go puma Jerusalem su-para komea-para nimumi Gote-na agale lakale ali mada lu makomalimina. ");
INSERT INTO kjs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Go rabu Yesumi talo: Jerusalem su-para piri enaalinu-ya. Nimimi Gote-na agale lakale alinu lu makomaeme. Gote-me mea rapaae enaalinu page kaname lemede. Ora rana adaapu go su-para piri enaali raayo nina kimi mea kiritaoma kupitaalo pe. Gore yaa kakarega kebome nipuna sinu popaa rolo-para mea mapiraalade-rupa nimi kupiaatalo pe pare nimimi ni giyemede. ");
INSERT INTO kjs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pagalepa. Gote-me nimina su Jerusalem su-para abala giya aaya. Nimimi ni abi na-adalimi pare werepe ni mada adalimi. Nimimi mada adalimi pare abala gu-rupa teme: Mudu Ali-na bi mea ipisana aliri nipu ora puri mina teme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pomo mu Pirape Yapi di meda rabu Yesu nipu Farisi alinuna ali mudu medana ada-para eda nola pisa. Go pisa raburi enaalinumi nipu ora waru adaba pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Go rabu ki age laapo pabopae ali medare nipu mo Yesu piri-para ipisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesumi go ali kodoma lisana mo rekena agale tisaanu-para mo Farisi alinu-para agale gu-rupa misa: Naana rekena agale madaare Pomo mu Pirape Yapi di rabu yaina kome ali mada maperekeana yapae dia yapae? ");
INSERT INTO kjs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Go lisa pare nimu agale nale pa pirisimi. Go pirisimi raburi Yesumi mo ali muma nipuna yaina ma-epeaaoma nipuna ada penaalisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Go pumare nipumi nimu lakalisa: Ali komeamere nipuna mena gawa ipa naaku-para lopaliare nimimi Pomo mu Pirape Yapi di rabu kamaa-nane nayola salia ya? ");
INSERT INTO kjs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Go lisa pare nimumi go agale mada na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesumi eda nala pirisa rabu ali medaloma abala riri-nane reke madaa kama pirulalo pirisimi rabu Yesumi go-rupa adisa-pulu nipumi saa pi agaleme nimu gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Gore ali medame nimi ena rumaape eda yawe-para yateare abala ririna wi reke madaa napuma piralepa. Dia-le mo ne yateade alimi adaa bi wia page ali mudu meda go-pare epa pira tea rabu puma piruma agale pagaina. ");
INSERT INTO kjs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Go rabu mo ne yateade alimi gu-rupa epa lagialia: Neme go riri-nane wia sekere mo ali mudu kala tea. Go rabu ne ora yala adaapu poloma nipuna reke minarepaoma koau-nane popali. ");
INSERT INTO kjs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Go pea pare ali medame eda nola epape tea raburi reke koau-nane puma piralepa. Go raburi mo ne yaata alimi ne epa adoma gu-rupa lagialia: Adami aaya tea. Nere go riri-nane epa pira tea. Go rabu mo ne raapu eda no piralimi alinumi ne adaa bi gialimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gore enaali raayome nimuna bi minasaatalo palimiri werepe nipu yala poloma oge ali pitia. Go pea pare enaali raayome nimuna kone rabuaniaalimiri go enare nimuna bi minasaalia. ");
INSERT INTO kjs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Go rabu Yesumi nipu eda nola epapa laade ali gu-rupa lakalisa: Neme eda yawali raburi nena adami enaalinu-para amenu-para rurunu-para nena su medanu kana adaapu wimi enaalinu raayo-para naipulapape tapape. Dia-le nimumi ne yalaateme rabu nimuna ada-para eda nanalomare nena eda abuteme. ");
INSERT INTO kjs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dia, pare nimi eda yawalimi rabu gore naarali enaalinu-para koe enaalinu-para le rabuli enaalinu-para eda nenalo ipulapape tapape. ");
INSERT INTO kjs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Go enaalinumiri nena eda mada na-abuteme pare nimu puri waru mealimi. Werepe Gote-me epe enaalinu tapa-para marekaaliade yapi di rabu Gote-me abutea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu go agale lakalisa rabu reke madaa piruma eda nisade ali medaa adoma Yesumi gu-rupa lakalisa: Enaalinumi Gote-na Surube Yapi-para ru-nane puma nipuna reke madaa piruma eda nalimi-daare nimuri rana rana komo piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pare nipumi saa pi agale gu-rupa lakalisa: Ali medame eda adaalepe yawolalo pisa rabu enaali adaapupe-para eda nola ipulupape lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gore eda nape yapi rudu lisa rabu nipumi kogono naakinu mea rapaaoma mo eda nenalo yalisade alinu ipulupa lo roboma lakelapa lisa. Eda raayo abala kiritao kiritaarima tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pare mo enaali komea komea lo nimumi pa agale loma mada napalima lisimi. Ali medame agale gu-rupa lisa: Naa emaapu meda kabawa-le ni go adola palua lisa. Go pe-pulu ni ora kodo pia abi mada napalima. ");
INSERT INTO kjs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gore ali medame agale gu-rupa lakalisa: Naa mena gawa 10-pela kabawa-pulu pabola kuta-para maa pulu. Go kogono abi wia-daa kodo pia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gore ali medame agale gu-rupa lakalisa: Abi ni ena pena go ropopi-pulu ni mada napalipa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Go raburi mo kogono naaki nipu wala puma nipu ali mudu lakelalo pisa. Go rabu mo Mudu Alimi rono pagoma nipuna kogono naaki go-rupa lakalisa: Mogo adare-nane puma pora pagina page wagepu puma enaalinu mealepa lisa. Go pumare neme naarali onaalinu-para ne koe enaalinu-para le rabuli enaalinu-para nimu raayo nina ada ru-nane lamua epape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Werepe go kogono naakimi ipuma talo: Mudu Ali, nena agale abala pamu lawade pare pada medaloma pa pu pa wia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Go rabu ali mudumi kogono naaki gu-rupa lakalisa: Ne puma adaa pora kepaa-nini puma mo maapu pora kepaa-nini page pumare nina ada ora rubilina enaali raayo ora lamua epape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Neme ne lagialo. Abalade enaali raayo neme yalawade enaalinumiri naa eda ora ogeasi page mada nanalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Enaali adaapupe Yesu raapu pamisimi rabu nipu perekeyoma nimu agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Gore enaali raayo ni raita maa epalimiri gore nimumi nimuna ama aapanu-para were-para nogo naakinu-para ame balinu-para nipuna kone-para ora giyoma epalimi. Go puma nimu naa disaipel enaalinu piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Enaali raayome repena polopea waru mea ruma ni raita mea epalimi-daare gore ora nina disaipel enaali piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nimina enaali medame ada adaalupe meda palua kone saliare nipu piruma go ada mada pu ma-adiaalua palo waru piruma koneme makuaalia. ");
INSERT INTO kjs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Go napalia-daare nipumi ada pa puma kone abala nasalia-daare enaalimi nipu giri laalimi. Ake paa-daa ya? Kone waru nasuma ada paleme pea-pulu giri laalimi. ");
INSERT INTO kjs_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Go rabu nimumi talo: Go alimiri mopo ada pulalo pea pare nipumi go ada mada nadia yaalia teme. ");
INSERT INTO kjs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gore ali mudu medame ali mudu rado meda raapu yada pula pulalo palia-daare nipumi kone waru makuaa piralia. Gore nipuna yada pape alinuri 10,000-pela pimi pare mo ali meda nipuna yada pape alinu 20,000-pela mea epalia. Go pea-pulu nipu mada raitalia kone suma giyalia. ");
INSERT INTO kjs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gore mo ali mudu nipumi mada naratia kone salia-daare gore nipumi agale lo moyaape alinu ali mudu meda piri-para maa penaatea. Go puma naa yada giyoma epe-rupa pirapana lakela penaatea. ");
INSERT INTO kjs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Apo remaana re madaare Yesumi gu-rupa lakalisa: Nimina rikirana enaali medame epe kogono pape kone nasuma nipuna ele raayo-para koau nawateare go aliri nina disaipel enaali-rupa mada napiralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Epe kogono napeo piralimiri ora koe kusa-rupa piralimi. Kusare ora epe ele wia pare mo aipa-na rede dia yaalia rabu naame ele puma nipuna epe rede wala mapaalima pae? ");
INSERT INTO kjs_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Go pi kusare maapu-para poae ele page mada namaopaalia. Go puma mena gawana i re-para mea wimi page madaa namaopaalia. Enaali raayome go agalena re makuaaba piralimiri waru pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Koro medare takis mi mudu alinu-para riabo enaalinu medaloma Yesuna agale pagolalo epa kiritaoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pirisimi rabu Farisi alinu-para rekena agalena tisaanu-parame rono page agale gu-rupa lisimi: Go alimiri koe alinu raapu piruma eda nala lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Go lisimi raburi Yesumi nimu-para saa pi agale meda gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Gore nimina rikirana ali medame sipsip 100-pela punalia-daare go sipsip mena komea alupalia. Go palia raburi mo 99-pela su meda-para eda nalaina puni alimi mo komea alupaaripade asapama pumare mada pua mealia. ");
INSERT INTO kjs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Gore nipumi ora puma adasaaoma mumare nipuna pasaa madaa maa ruma rana komo puma ria epalia. ");
INSERT INTO kjs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Go puma nipuna ada-para epa opapalia rabu nipuna adami alinu-para nipuna ada komea-para ae alinu-para ipulupa tea. Nimu epa kirita pirinaloma nipumi nimu go-rupa laketea: Nimiri ni raapu ranaa komo piraminapa tea. Naa sipsip meda alupaaripa pare neme asapuma puma adasaaoma meawa tea. ");
INSERT INTO kjs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Neme go saa pi agalena re wala nimi lagialo: Enaali adaapumi gu-rupa 99-pela ora epe-rupa piruma wala kone lo robaa wala meda mada naperekealimi-pulu yaa-para nimumi raaname komeleme. Go peme pare koe ali komeame kone perekea rabu so yaa-para raana pia ora waru komalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Gore ena medame kana kili 10-pela salia pare komea ma-alupalia rabu nipu ake pali ya? Gore nipumi lam kewoma ada waru wasuma puma adoma mealia. ");
INSERT INTO kjs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nipumi abala adasaaoma mumare nipuna adami enaalinu-para ada komea-para ae enaalinu-para ipulupa tea. Nimu epa kirita pirinaloma nimu gu-rupa laketea: Nimiri ni raapu pedo pedo paminapa tea. Naa kana-re komea alupaaripa pare neme wala asa puma meawa tea. ");
INSERT INTO kjs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Neme nimi-para go remaana re lagialo: Gote-na ensel-numi koe ali komea kone perekealia rabu rana komalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesumi wala talo: Ali medame naaki laapo madu wia. ");
INSERT INTO kjs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gore laapo pa naakimi aapa yaaloma talo: Nena moae-elenuri rumaaoma nina gili-rupare abi gi lisa. Go raburi aaraame ele raayo rumaaoma mo nipuna naaki laapo kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gore mo naaki nipuna rumaaoma kale omo ale raayo kabenaloma kana mubisa. Go pumare su adaalu-para pisa. Go pumare nipu su adaalu meda-para puma pirisa. Go puma nipuna monedere nipuna pupitagi noma abala yoloma rubebe pisa rabu dia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Go pumare nipuna kana elede raayo pa rubebe pisa raburi werepe go su-para rea ada meda pabesa. Go rabu nipu ele ogesi-daa abuna meda nawisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Go pisa raburi nipu go su-para ae ali meda piri-para kogono asapulalo pisa. Go alimi kogono mumare mena surubainalo go kogono mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mo menanu nimuri pesaa abu nisimi rabu go naakimi menana eda nalua kone wisa. Go pisa pare pa ali medame page eda nakalesimi. ");
INSERT INTO kjs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Go pisa raburi nipuna kone abala makuaaoma gu-rupa kone wisa: Naa Aapana kogono naaki raayona eda adaapu su aayade kone wisa. Gore ni go ada su-para aaomare ora reame ni go komalo-daa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neme go su giyoma nina aapa piri wala palua kone wisa. Gore neme aapa yaaloma gu-rupa puma toa kone wisa: Gote-na le-aga madaa page nena le agaa madaa page neme pupitagi no pirisuade toa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Abiri ni epe naaki-daa dia-le nina si pi nalape toa kone wisa. Niri pa nena kogono naaki-rupa mapiraaina toa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Go kone sumare nipu rekoma aaraa piri wala polalo pisa. Go pisa pare nipu su adaalu-para pena ipulaina aaraame abala adisa. Go rabu aaraa nipuna lo robaa-para kodo ora waru komisa. Go puma aaraa nipu alo pumare mo si pua kupi palae suma nunu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Go rabu mo naakimi aapa yaaloma neme Gote madaa page ne-para page pupitagi nape ali-rupa pirawade. Niri neme nena si pi-daa nalape. Niri epe naaki-daa dia. ");
INSERT INTO kjs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Go lisa pare aaraame nipuna kogono naaki yaaloma go-rupa lakalisa: Nimimi ora epe mamina adaalu maa ipuma epe adaalu-ai yamalepa. Go puma nipuna ki madaa rini meda maa mapiraalepa. Go puma age ada page maa maraatepa. ");
INSERT INTO kjs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Go puma epe kapa midi waru-ae gawa menana si mea ipuma lu yawalepa. Gore naame eda yawoma noma epe kone suma pedo pedo waru paminapa. ");
INSERT INTO kjs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gore nina naakiri abala komaana kone wisuade pare wala epa papia. Abalare ora alupaaripade pare wala go adasaayo-daa. Go rabu nimumi pedo waru pu piruma eda no pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Go pisa pare nipuna mupaa naakiri maapu-nane pirisa. Werepe nipu wala ada ipuma re-para opapaoma rabialo-para yasa-para pagisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pagisa rabu nipumi kogono naaki meda yaaloma lorapisa: Apo ada-parare ake peme? ");
INSERT INTO kjs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mo mupaa naakimi nipu lakalisa: Nena ame ada wala epa yade-le nena Aapame gawa kapa waru aayade lu yawea. Gore mo naaki abala alupasade wala nena ada-para epe-rupa epa pia-daa pedo pimi. ");
INSERT INTO kjs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Go lisa raburi mo naaki mupaa nipu rono pagoma nipu ru-nane napua kodobasa. Go pisa raburi nipuna aaraa kamaa-nane epenaloma ora ru-nane bainalo kogelisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Go lisa pare mupaa naakimi aaraa gu-rupa lakalisa: Paga. Maali adaapumiri ni nena kogono adili naaki-rupa piruma nena kogono pisuade. Neme nena agale rana komea-daa nagiyasuade. Go pede pare neme ake giae ya? Gore neme pa meme menasi meda gula pisi yalore naa adami alinu raapu ranaa komo piruma mada yawo nola pisima pare go-rupa piside. ");
INSERT INTO kjs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pare go nena naakimiri nena elenu raayo koe enanu madaa apo rubebe pisa. Wala epaana rabu page nipu kodome komoma gawa epe ele apo lu yawaaripina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Go rabu aaraame nipu-para agale gu-rupa lakalisa: Go naaki-ya. Ade abuna yalo nere saana apo pipa. Go pea-le naa ele raayore ora nena yade. ");
INSERT INTO kjs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Go pea pare abi naame eda yawoma pedo paminapa. Go nena amere abala komaana kone wisuade-le abiri wala go epe-rupa go epaana-daa. Gore ora alupasade pare abiri wala epaana-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesumi nipuna disaipel alinu gu-rupa lakalisa: Ali mudu meda nipuna kana ele surubape ali meda mapirasa. Go rabu ali medaloma mo ali mudu piri ipuma agale meda gu-rupa epa lakalisimi: Nena kana ele surubape alimiri nena ele mea mabebolaaripa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Go raburi mo ele surube ali nipu-para nipu loma lakalisa: Nemere yada paina lame-le ali pae? Nemere nina ele raayo surubenede-le ele puma yarepea lisa. Go pumare nere nina ele wala nasurubaina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Gore mo kogono ali nipuna konere gu-rupa: Nemere ake palua kone wisa. Mudu Alimi abi ni raitalo pia. Go pea-le neme su awape kogono wala meda papere neme pa enaalinu meda-para eda ele gialepa lapere yalame komalua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pare neme ora go palua kone wisa: Go paluare nina kogono mada mea raitaliade rabu adami enaalinumi nimuna ada-para epe-rupa mada palua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Piruma kone gu-rupa wisa mo surubape alimi nipuna ali mudu yago wi enaalinuri komea komea lo rumaasa. Go raburi nipu piri ipisimi. Gore ali komeare nipu abala epenaloma mo kana surube alimi nipu lorapisa: Naa ali muduna yagore neme akepu mea ya? ");
INSERT INTO kjs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Gore nipumi talo: Wabala repenare 100 dram misuade lisa. Go rabu surube alimi nipu gu-rupa lakalisa: Neme go yago tape pepare abi meano ne pa wagepu piruma yago 50 dram abulape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Werepe ali meda epenaloma mo ele surubape alimi nipu lorapisa: Nena yagore akepu raapu ya? Gore nipumi talo: Neme wit-na kiliri bek 100 misua lisa. Go rabu nipu go-rupa lakalisa: Neme go yagona pepare wi-le gore neme medaloma giyoma 80 bek abulape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gore go surube alimi su kamaa kone suma go-rupa kogono pisa. Go pisa-pulu werepere mo ali mudumi makirae surube ali kana bi minasaasa. Gore pa su kamaa piri enaalinu nimumi yago madaa kogono pumare ali-kone suma peme. Go puma nimumi epe paa-para piri enaalinu makiraoma nimuna kogono peme-rupa ma-oge yaeme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Go rabu Yesumi wala go-rupa lisa: Gore neme nimi lagialo. Go suna kana mu surube alinuri nimina adami enaalinu raapu piralepape. Go puma kana dia yaalia raburi nimi adae abuna pirape ada-para epe-rupa mada piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oge elesinu kalenaloma enaali raayome waru epe-rupa surubalimi-daare gore adaa elenu page nimumi waru surubalimi. Go-rupa page enaali raayome oge elenu epe-rupa napaliare ele adaa page epeala palia. ");
INSERT INTO kjs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nimimi go su kamaa piruma go su kamaa wia ele waru nasurubaemere nimimi ora adaa ele mada nasurubalimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Go page nimimi enaali medana ele waru nasurubalimiri aapimi nimina meape ele mada gialia ya? ");
INSERT INTO kjs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kogono naaki medare nipumi ali laapona kogono mada napalia. Dia-le nipumi ali meda epe kone masaaoma meda ralu yaaoma nipumi meda madaare ora raaname komoma-le medare giyape kone salia. Nimimiri Gote-para kana kogono laapo raita raana raapu mada napalimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mo Farisi alinuri ora kana madaa raaname komoma-le Yesuna agale raayo pagisimi rabu nipu-para ero agale lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Go lisimi raburi Yesumi nimu gu-rupa lakalisa: Nimina kogono pa puma enaalinuna le agaa madaa epe-rupa pirulalo makiraeme. Nimimi go-rupa peme pare Gote-me nimina lo robaa-para adea. Enaalinumi pa ele madaa pedo peme pare Gote-na le agaa madaare go ele ora ramea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gore Gote-na agale lakale alinuna agale-para Moses-na rekena agale-para go laapore Jon namadisa rabu page pagisimi. Pare mo Jon maita yapi di-na ipumare abi page Gote-na Surube Su madaa Epe Agale su raayo-para abala pageme. Go peme-pulu enaalinu raayo Gote-na pape ru-nane kodobatalo peme. ");
INSERT INTO kjs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gore su yaa laapo ora wagepu mada dia yaalia pare rekena agalena kunisi-daa page ora mada nadia yaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ali raayome were giyoma rado mealimi-daare ena paake yole ali pitimi. Go page ali raayome raluli ena rumaalimi-daare nimu ena paake yole ali-rupa pitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Abalade kamo le ali meda piruma nipumi adae abuna epe kale mamina kama maraoma epe mamina page yamoma epe eda kama no aasa. ");
INSERT INTO kjs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gore nipuna ada pora gaape resi-para ali Lasarus naarali meda nimumi ria ipisimi. Go alina to madaare rere putipe pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gore Lasarus nipumi mo kamo le kana ada reke rolo-para lope ele eda purupi wasu nolalo pirisa. Go pisa rabu yana medaloma ipuma mo nipuna rere-re epa pete pete puma sala pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Gore werepe mo Lasara nipu komenaloma yaa madaa ensel-numi go alina wasa maa ria puma Abraham raapu so yaa-para mapiraasimi. Werepe mode kamope nipu page komisa rabu rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gore nipu koe naaku-para puma piruma nipu radaa adaae nisa. Go pirisa rabu nipumi ora so-pare Abraham adasaasa rabu Lasarus raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Go adasaasa rabu mo kamo le alimi gu-rupa yalisa: Aapa Abraham. Neme ni kodome komape lisa. Neme Lasarus wala epenaloma nipuna ki maalame ipa paitaoma nina eke madaa epa saena. Go puma nina eke madaa ogeasi kogorena lisa. Neme go repena sulaa-para radaa ora adaae nalo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Go lisa rabu Abraham-me gu-rupa lisa: Naa naaki. Neme kone narugulape. Abalade su kamaare ne epe-rupa piruma epe epe elenu kama meade pare Lasarus-ri no su kamaa piruma koe elenu mu pirisa. Go pisade pare abi go-para nipu epe-rupa pirina ne wala koe-rupa apo pinale-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gore ele meda page gu-rupa apo wia-daa lisa: Apone pimina ali-para one pima ali pare rikiranare Gote-me adaa kubu meda apo wisana-daa lisa. Go pisana-pulu naa-para nimi-para komea-para mada nakibu mapiralima lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Go rabu mo kamo alimi gu-rupa ogelisa: Aapa, neme Lasarus su kamaa wala penaalo nina Aapana ada-para lakela penaala lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Naa ame supu pimi-le Lasaaraame nimu puri pale agale laketa penaaloma nimu page go radaa no piru aape su-para mada epalimi lo tapena lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Go raburi Abraham-me talo: Nena amenuri Moses-na agale remaa-para Gote-na agale lakale alinuna agale pagenawa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Go rabu mo kamo alimi Abraham-para talo: Aapa Abraham dia. Go yapare mada napagalimi pare abala kome ali meda wala tapa madaa rekoma puma laketeare gore mada pagalimi. Go raburi paala komoma kone mada perekealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Go lisa pare Abraham-me nipu lakalisa: Gore Moses-na agale-para Gote-na agale lakale alinuna agale napagalimiri ali meda tapa madaa wala rekoma penaaloma go alimi pua tea agale madaa kone narulalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Go raburi Yesumi nipuna disaipel alinu gu-rupa lakalisa: Pa epaliade ele koe ele raayomere enaalinu pupitagi manaalia. Go palia pare enaali medame go pupitagi nape ele palia-daare nipu madaa kodo waru pea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gore enaali medame oge nogo naakinuna kone rulaere mabebolalia-daare gore waru adalepape. Go palimi-daare nimuna maa-para adaa kana maduma ipa le-para mea lopalimiri ora kolea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Go kone namogealimi-daare nimi waru adoba piralepape toa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gore yapi komea madaare nipumi ne-para rana ki medane luma medane laapo koeyae palia pare nipu wala ipuma ne-para ni kodo pia lomare kone perekealia. Go tea-daare nipuna koe ele rana ki medane luma medane laapo maa rubape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel alinumi Mudu Ali-para gupa lakalisimi: Neme naana kone rulaere ora waru ma-adaa yape lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Go rabu Mudu Alimi nimu gu-rupa lakalisa: Gore nimina kone rulae konere go oge yamo kili-rupa yaalia go repena gu-rupa mada lakeleme: Nena pitaa yokoma no ipa solwara koauna pua aape te-daare go repename nena agale pagoma go-rupa mada palia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesumi wala talo: Gore nimi komeamere nimina kogono naaki medame maapu-para su awoma page mena sipsip punalia leme. Go puma nipu kogono giyoma ada-para epalia raburi neme go naaki wagepu nena eda naina? ");
INSERT INTO kjs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Gore dia-le neme nipu gu-rupa lakete: Naa eda abala mea rumaa te. Go pumare nena mamina yamoma neme eda abala no pirano pa adoma pira te. Ni abala no makomaaoma werepe ne naina te. ");
INSERT INTO kjs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gore nena kogono naakimiri nena agale pagalia-daa ora pili mada te ya? Mada dia nipu kogono napuma eda page nanaade. ");
INSERT INTO kjs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Go palia-le nimimi page Gote-me lagiali elenu raayo pu dia yaoma gupa tapape: Naare pa kogono naakinu pima. Go puma naame ele pemare ora naana kogono pema tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu nipu Jerusalem su-para pora pagina pumare Samaria Galili su laapona robo rikirana pamisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nipu oge adare meda-para pamisa rabu yakilimi li ali 10-pela nimu pora madaalisimi. Go rabu nimu ogesi-daa mo-para rekoma puri paloma gu-rupa yalisimi: Yesu, ne Mudu Ali-le naa madaa kodome komape lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gore Yesumi nimu adoma gu-rupa lakalisa: Nimina yogalere mo Gote-na lodo kira-ae alinu puma mea waalepa. Go lisa-pulu nimu pirisimi rabu nimuna rerenu kaapu yoma ora raayo epe lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Go rabu ali komea nipuna yogale wala epe lisa adisa-pulu nipu Yesu piri-para wala pumare Gote-na bi minasaasa. ");
INSERT INTO kjs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesu piri-para puma Yesuna kibu re-para wagepu lopoma nipu-para ora pili lisa. Go aliri nipu Samaria adare-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu nipumi go ali adoma gu-rupa lisa: Nemere ali ki laapona yaina madia yaaru-pulu ali medalomare aa-para puame pae? ");
INSERT INTO kjs_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Go pora kimisu ali komeare wala Gote-para ora pili lo laketa epaana. Go ali medaloma aa-para pimi pae? ");
INSERT INTO kjs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Go rabu Yesumi nipu gu-rupa lakalisa: Nere abalade kone rulaaripi-pulu nena yaina epeade-le rekoma adaa pu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gore Farisi alinumi Yesu gu-rupa agale lorapisimi: Gote-na Surube Yapi-na yapiri aa-rabo epalia yapae lisimi? Go raburi Yesumi nimu gu-rupa lakalisa: Gote-na Surube Su epaliade di raburi nimina pa elenu mada na-adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Enaalinumi Gote-na Surube Yapi Di-ri mogo-nane wia-le adalepa pi-daa mada nateme pare Gote-na Surube elere abala epa wia. ");
INSERT INTO kjs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Go rabu Yesumi nipuna disaipel alinu lakalisa: Werepe epaliade di rabu nimimi kone gu-rupa salimi: Enaali Raapu Pirape alina Siri yapi komeare naame wagepu abi adamina leme. Pare nimimi mada na-adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gore nimina rikirana pimi enaali medalomame nimi gu-rupa lagialimi: Adalepa. Mogo-nane nipu mo aaya-daa. Go-rupa lagialimi pare nimuna agale naraitalepape. ");
INSERT INTO kjs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","So yaa-para kari-yapa pula popeade-rupa enaali Raapu Pirape alina Sina yapi di wagepu go-rupa epalia. ");
INSERT INTO kjs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Go palua pare neme kedaa adaapu abala ritua rabu go abi go piri enaalinumi ni madaa koau wateme lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Gore abalade mo Noa pirina nimu pirisimide-rupa abi ni enaali Raapu Pirape alina Si madaa page gu-rupa palimi: ");
INSERT INTO kjs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa pirisa rabu enaalinu piruma nimumi eda ipa bia nama pu ena ropo pu puma mo Noa nipu ipinu-para puma kodobasa rabu page paoma pu pirisimi. Go rabu ipa adaalepe roma lisana enaali raayo tabisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot pirisa rabu page komea-rupa pisimi. Nipu pirisa rabu enaalinumi ipa no eda no ele kaboma rumaama puaoma emaapu pua ada waru go-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pare go ali Lot-me Sodom su giyoma pisa raburi ora go yapimi so yaa-para wi repena sulaa page kana meda pugu pi ele laapore yai su kamaa madu lopesa. Go puma go su ada enaali raayo raabisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Apo pirisade-rupare enaali Raapu Pirape Alina Si nina yapi di pename waatoa raburi gu-rupa wala palimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Go di raburi enaalinu nimina ada kamaa-nane pa piralimiri gore nimina elenu ada ru-nane ena mada namula palimi. Go page enaalinu nimuna maapu-para pitimiri gore nimu ada-para ele wala namula palimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nimimi Lot-na wereme pereke luma ele adisade remaa waru makuaalepape. ");
INSERT INTO kjs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gore enaali raayome nimuna yogale surubolalo palimiri nimuna wasa page alupalia. Go palia pare enaali raayome nimuna yogale giyomare nimu adae abuna pa pitimi. ");
INSERT INTO kjs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Neme nimi lagialo: Go ribaare ali laapo komea reke madaa paitalipi pare Gote-me medare muma medare pa paitae ena giyalia. ");
INSERT INTO kjs_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Go rabu ena laapome eda wariape kogono palipi pare Gote-me meda muma medare pa pirina giyalia. ");
INSERT INTO kjs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gore ali laapo maapu-para kogono palipi pare Gote-me ali medare muma ali meda giyalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Go rabu disaipel alinumi agale gu-rupa lorapisimi: Ali Mudu-ya. Gore aa-rabo palia yapae lisimi. Gore Yesumi nimu gu-rupa lakalisa: Paga, mo kome enaalina ro pa rogaabaayare yaa itaayama epa kiritaoma aalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Go rabu Yesumi nimu saa pi agale meda mogeaasa. Go agalena rere beten nagiyalepape lo lakalisa. Yesumi talo: ");
INSERT INTO kjs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Taun meda-parare kose page ali meda pirisa. Go kose page alimiri Gote madaa paalame nakomoma enaalinu madaa page kone waru namapiraasa. ");
INSERT INTO kjs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Gore ena wasa medare go adare-para piruma adae abuna kose page ali piri-para ipuma gu-rupa epa lakelala pisa: Naa lore alimi ni madaa koeyae pea-le kose pagali rabu ni raba meape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Abala ririna go kose page alimi naraba mulalo pisa pare werepe nipuna lo robaa-para gu-rupa kone wisa: Nemere Gote page paala napea enaalinu page paalame nakome. ");
INSERT INTO kjs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Go pea pare go ena wasaame ni rono mapaaya-le nipu kose madaa raba mealua kone wisa. Gore guma-daa napaluare nipu adae abuna kose madaa kama epalia rabu werepe ni ora waru komo palia kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Go rabu Mudu Alimi gu-rupa lisa: Nimimi go kose page koe kana konere waru adalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gore Gote nipuna enaalinumiri nipu-para adae abuna ribaa alebo page nipu yaaloma re lo pimi. Go pea pare Gote-me nimuna kose madaa epe-rupa naraba mealia ya? Nipumi adoba piraoma piraoma puma abi naraba mealia yapae? ");
INSERT INTO kjs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nipumi nimi wagepu epe-rupa raba muma beten pagalia. Go pea pare werepere ni enaali Raapu Pirape alina Si epalua rabu su kamaa piralimide enaalinumi kone rulalimi yapae? ");
INSERT INTO kjs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Gore enaali medaloma ora koe enaalinu kone wisimi. Go pisimi-pulu Yesumi saa pi agale gu-rupa lakalisa: Ali laapome beten talo lotu ada-para pisipi. Ali medare Farisi ali yade. Ali medare kana takis mi ali yade. ");
INSERT INTO kjs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi aliri nipu agu raapu rekaoma beten gu-rupa lisa: O Gote, niri pa ali radonu-rupa napi-le neme ne-para ora pili talo. Nimumi ele paake no ena ralu mo go-rupa peme pare niri nimu-rupa napi. Go page abi mo kana takis mi ali go aaya-daa niri nipu-rupa napi-le ora pili talo. ");
INSERT INTO kjs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gore sarere raayona ru-para yapi laapome eda madaa niti puma giyede. Gore neme ele raayo medalomare ruguluma ne pa gede. ");
INSERT INTO kjs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Go lisa pare mo kana takis mi aliri mo-para yola moneaaoma nipumi beten lisa rabu yala polasa-pulu na-adasaasa. Dia, pare nipuna aako luma beten gu-rupa lisa: O Gote, niri ora koe ali yaa-pulu neme ni madaa kodome komape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesumi talo: Neme nimi lagialo. Go takis mi aliri nipuna ada-para wala pisa rabu Gote-na le agaana nipu redepo le ali-rupa pirisa. Pare mo Farisi aliri pisa rabu redepo le ali-rupa napirisa. Enaali raayome nimuna bi minasaalimi-daare Gote-me go enaali rabuaanaalia. Pare enaali raayome Gote-na le agaana nimuna bi rabuaaniaalimi-daare go enaalina biri Gote-me nipuna bi minasaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Go rabu enaali medaloma nimuna adu nala piri nogo naaki nimu Yesu piri maa ipisimi. Yesumi nipuna kimi kalu madaa waraainalo maa ipisimi. Go pisimi pare disaipel alinumi go kone adisimi rabu nimu-para rono lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Go lisimi pare Yesumi mo nogo naakinu re-para ipulupa loma talo: Nimimi apo nogo naakinuri ni piri-para epenaapa. Gote-na Surube Yapi-para go pia nogo naaki adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pagalepa. Enaali raayome Gote-na Surube Su go oge nogo naaki-rupa namu piralimiri ora mada na-adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda ali mudu medame Yesu agale gu-rupa lisa: Epe tisaa-ya. Neme adae abuna kagaa piramala pope konere ake puma mealua yapae? ");
INSERT INTO kjs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Gore Yesumi nipu agale gu-rupa lisa: Niri ake paa-daa epe ali lae ya? Gote komeare ora epelea. ");
INSERT INTO kjs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nemere rekena agale abala pagemede. Neme ena paake nayolape. Enaali meda nalu makomaape. Neme paake nanape. Neme ali meda-para makirae agale nalape. Nena ama Aapana bi minasaasa agale waru pagape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gore ali mudumi talo: Abala ni oge naaki rabu page abi go rabu page neme rekena agale raayo waru pagoma rate lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesumi go agale pagoma nipu go-rupa lakalisa: Ora lale pare ne apo agalena pora komea nakurili: Nena ele madaa mi kana-re enaali naarali pabenu pua rumaaoma kalape. Go pali raburi so yaa-para nena epe yoto rado ora puma meaina. Go pumare ni raita mea ipu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gore mo ali mudumi go agale pagoma nipuna lo robaa-para kedaame ora waru komisa. Ake paa-daa ya? Nipu ele adaapu wisa-pulu. ");
INSERT INTO kjs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesumi nipuna kedaa pi kone adoma talo: Kamo enaalinuri ele adaapu wimi-le Gote-na Surube Yapi-para polalore kedaa peme. ");
INSERT INTO kjs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gore mena kamel-me noae kego nona pia-para palia-daare kedaa waru palia. Gore ora kedaa kogono yapare kamopenu Gote-na Surube Su adola pulalore apo agalere ma-oge yaaya. ");
INSERT INTO kjs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Enaalinumi go agale pagoma nimumi talo: Go laede-le adae abuna kagaa pirape kone popo aapimi mada mealia yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesumi talo: Go-rupa piralimi-daare enaalinumi mada napalia kone wi elere Gote-me mada palia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Gore Pita-me talo: Paga. Naame ne raita mea epolalo naana elenu-para adanu-para abala giyoma epama lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesumi nimu go-rupa lakalisa: E, yapare nimi lagialo: Enaali raayome Gote-na Surube Su kone madaa rulaoma nimuna su adarenu-para enaalinu-para amenu-para ama aapa laapo nu-para nogo naakinu-para giyoma epalimi-daare gore abi gore yoto waru mealimi. Go puma werepe kagaa di rabu page Gote-me adae abuna kagaa pirape kone kalo abutua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesumi nipuna 12-pela disaipel alinu mo-para kama agu raapu maa pumare nipumi talo: Abiri naa Jerusalem su-para baina. Go su-parare abalade Gote-na agale lakale alinumi enaali Raapu Pirape alina Si madaa lakeloma pepa madaa lisimide agalere gore ora opolalo pia. ");
INSERT INTO kjs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Go su-parare nimumi ni pa ruru radonu lamu kaleme. Go puma nimumi ni madaa giri laaoma ero agale loma supi raa pialimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Go puma nimumi ni repena kulimi kudu lumare mada lu makomalimi. Go palimi pare wala yapi repo dia naloma wala rekalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Go agale lakalisa pare disaipel alinu nimumi go saa pi agalena re namakuaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Jeriko su-para pisa rabu le rabuli ali meda pora pagi-nane piruma enaalinu-para kana kogeyo pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Gore nipumi enaali adaapupe epeme remaa pagisa-pulu nipumi enaali medaloma agale gu-rupa lorapisa: Gore apo enaalinumi ake leme pae? ");
INSERT INTO kjs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Gore nipu go-rupa lakalisimi: Nasaret ada-para aede Yesu epe-rupa leme lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gore nipumi puri paloma gu-rupa yalisa: Yesu, nere Devit-na si yade. Neme ni madaa kodome komape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gu-rupa yalisa rabu abala riri-nane pisimide enaalinumi nipu-para ape gu-rupa lisimi: Nena agale loraa lisimi. Pare nipumi agale wala ora puri paloma yalisa: Nere Devit-na si-le neme ni kodome komape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Go rabu Yesu nipu pa aoma nimu lakalisa: Apo aliri ni piri-para lamua ipulupa lisa. Nipu re-para ipisa raburi Yesumi nipu lorapisa: ");
INSERT INTO kjs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Neme nere ake pano kone sale? Nipumi talo: Mudu Ali, nina le ma-epe aape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Go rabu Yesumi nipu gu-rupa lakalisa: Nena leme ele ada. Neme kone rulaaripi-pulu nena le ma-epeaato lisa. ");
INSERT INTO kjs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Go lisa rabu wagepu nipuna leme ele adisa. Go puma nipumi Yesu raita maa puma Gote-na bi minasaasa. Enaalinumi page go-rupa adoma Gote-na bi minasaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Yesu nipu Jeriko su-nane pisa rabu ali meda nipuna biri Sakius nipu go-para pirisa. Go aliri takis mi alinuna ali mudu piruma nipu kana adaapu wisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Go alimiri Yesuri aapi yapae kone suma waru adolalo pisa. Go pisa pare enaali adaapupe rekaoma ma-ebesimi-pulu nipu ora rudu alisi-le Yesu adaape-rupa maaresa. ");
INSERT INTO kjs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gore nipu wagepu riri-nane abala puma Yesu adolalo repena meda puma rumaasa. Yesu go riri-nane epalia kone suma ruma pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gore Yesu nipumi mo pora pagina puma so Sakius pirisade-para adasaaoma gu-rupa lakalisa: Sakius, ne wagepu kilipima ipu. Abiri nena ada-para pirapana lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Go lisa rabu nipu wagepu kilipima pedo puma nipuna ada-para lamua pisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Go pisa pare enaali raayome go kone adomare rono pagoma gu-rupa lisimi: Nipuri ali koe medana ada-para paitula pula lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Go rabu Sakius nipu rekaoma Mudu Ali gu-rupa lakalisa: Mudu Ali pagape, abiri nina ele raayo rikirana rumaaoma medalomare enaali naralinu katoa. Go page abalade neme makiraoma enaali medana ele paake meala pawa-airi go yagore rana maalapu pa abutua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesumi nipu gu-rupa lakalisa: Abiri go nena ada-para piri enaalinu madaare adae abuna kagaa pirape kone mealimi. Ne go ali page Abraham-na ruruna si piraena. ");
INSERT INTO kjs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni enaali Raapu Pirape alina Siri neme alu pae enaalinu asa puma raba mulalo ipisua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nimumi go agale pago pirisimi enaalinuri Yesumi saa pi agale rado meda lakalisa. Go rabu nipu Jerusalem su re-para pisa-pulu nimumi Gote-na Surube Yapi-na di abala epena kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Go kone wisimi rabu Yesumi nimu gu-rupa lakalisa: Epe ali mudu meda su adaalu-para pulalo pisa. Go su-parare nimumi nipu ali mudu mapiraanaloma werepe wala nipuna enaalinu puma surubalia. ");
INSERT INTO kjs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gore nipu pulalo pisa rabu nipuna kogono naaki 10-pela yaalomare nipumi 800 kina komea komea lo rumaaoma kalisa. Go puma nimu gu-rupa lakalisa: Ni apo su-para pitua rabu go kana-re rome pa kama pu piralepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pare mo nipuna ada komea-para piri enaalinumi nipu giyalalo rono waru pagesimi. Go pumare nipu abala penaalomare ali medaloma wala werepe maa penaalisimi. Gonu nimumi mo mudu mapiraape alinu-para go ali naana ali mudu mada napiralia lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pare apo su-para nipu ali mudu mapiraanaloma nipuna adaa re-para wala werepe ipisa. Go rabu nipumi abalade kana kalisade kogono naaki-para wagepu ni piri-para ipulupape lo agale rapasa. Nipumi nimuna kode mone-me akepu raapu saapimi palo adano kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gore ali medame abala ririna kana misade aliri nipu ipuma lisa: Mudu Ali-ya. Neme gode 800 kina giside pare neme rome pa kama pumare wala kana kode 8000 kina meda page meawa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Gore ali mudumi nipu gu-rupa lakalisa: Nere ora epe kogono pape naaki. Neme nina oge elenu page waru surubaina-pulu abi neme adare 10-pela mada surubaina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gore naaki laapo ipuma epa talo: Mudu Ali, neme nena 800 kina rome pa kama pirisua pare wala 4000 kina meda pa kode maa sawa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Gore ali mudumi talo: Epe lea-le nere adare supu mada surubaina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Gore mo naaki meda ipuma epa talo: Mudu Ali, nena rudu madaare go-para wia-le neme abalade hankisip-mi rogaaoma pagasaawa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nere ora puri pale ali yaa-pulu ele waru muaayede pima ni paala komoma nena kana pagaa saaripu. Neme enaali radonuna ele mu pa enaali radome eda poaemedere neme aoma melede lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gore mo ali mudumi go kogono naakiri gu-rupa lakalisa. Nere ora kogono naaki koe yana. Neme go laede agale madaa kose lape. Niri ora puri pabe ali lore neme ade pae? Pa ele pa enaali radome saapiri-ai gore neme mede lae? Eda pa enaali radome poae-airi awede lae? ");
INSERT INTO kjs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Go paena-le neme nina kana-re abalade mo kana kiritape ada-para nasaaripi pae? Go pula pisi yalore ni wala ipumare medaloma raapu epa mula pawa-le ake paa-daa gu-rupa napaaripi pae? ");
INSERT INTO kjs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Go rabu nipumi mo epa rekasimide enaalinu-para gu-rupa lakalisa: Nimimi go saapirana kana 800 kina-re muma mo 4000 kina saapi naaki maa kata pa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Go lisa rabu mo enaalimi nipu lakalisimi: Mudu Ali, nipuri 8000 kina kode abala go misa-daa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gore nipumi talo: Pagalepa. Enaali raayome ele saapitimi-daare neme medaloma wala katoa lisa. Yapare enaali medalomame ele waru nasaapitimi-daare go nimuna saapimi oge elenu page wala mealua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pare nina lore alinuri ni nimuna ali mudu napirina kone nimi-le go enaalinuri go-pare mea ipuma nina le-agaa mada epa lu makomalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nipumi go agale lomare Jerusalem su-para pora pagina abala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nipu Betepasi su robo ru-nane pumare Betani adare re-para pisa rabu nipu Rudu Oliv re-para pisa. Go pumare nipuna disaipel ali laapo abala penalisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Go ali lapo-para gu-rupa lakalisa: Nipiri mogo adare mo-nane aaya-para pulupape. Go-para pumare mena donki mena si-daa abalade ali meda nipuna koauna napirina kope pua koyoma maa ipulupape. ");
INSERT INTO kjs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Gore ali medame go mena donki ake paa-daa nipimi lidi kepealepa teare nipimi agale gu-rupa laketapape: Mudu Ali-na kogono wia-daa mula pulupapa la tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesumi nipu laapo mea rapasa raburi mo nipumi lakalesa-rupa ele raayo gu-rupa adisipi. ");
INSERT INTO kjs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nipumi mo donki mena kope koyala pirina mo donki menana aaraanumi nipu gu-rupa lakalisimi: Ake paa-daa nipimi go donki mena si koyalape pae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nipumi talo: Mudu Ali-na kogono wia-daa pipa lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gore nipumi mo donki mena si Yesu piri mea ipisipi rabu nimuna mamina meda mo donki mena madaa madu wisipi. Go puma Yesu nipu mo mena donki mena koauna mapiraasipi. ");
INSERT INTO kjs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gore nipu mo donki mena koauna piruma pisa rabu enaali raayo nimuna mamina-nu pora pagina saapirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nipu Oliv Rudu-nane pe pora rugulaniaoma re-para ipisa rabu nipuna disaipel enaali adaapumi pedo pisimi. Nimumi abalade mo napi kogono adisimi-pulu nimumi puri paloma Gote-para ora pili loma nipuna bi minasaoma pu yaloma pu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Go rabu nimumi gu-rupa yalaasimi: Mudu Ali-na bi mea epe ali muduna bi minasalimina lisimi. Gote so yaa madaa epe-rupa piana alina bi kalamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Go rabu Farisi alinu medalomare mo enaalinu raapu pirisimi. Go alinumi Yesu-para gu-rupa lakalisimi: Tisaa-ya, nena disaipel-nu agale loraalepa lo lakela lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Gore Yesumi agale gu-rupa lakalisa: Pagalepa. Nimuna agale loraala peme yalore gore mo kana Gote-na bi minasaainapa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu nipu Jerusalem su-para re-para pisa rabu nipumi adoma re lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Re lisa rabu nipumi talo: Go su-para piri enaalinu-ya, abi go yapi di madaa nimimi epe-rupa pirape kone mada namealimi. Go pea pare nimimi na-ademe. ");
INSERT INTO kjs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Werepe yapi medame lore alinumi ipuma yada pape epa kutapuba piralimi. Go pumare nimi mada napogola palimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Go rabu nimumi go nimina adare Jerusalem su-para kana pape komea komea lakepe rubalimi. Nimimi raba meape yapi di na-ademe-pulu go pape ru-nane piralimi enaali raayo lu makomalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Go puma Yesu nipu lotu ada-para puma kodobaoma mo rome pape kogono pi alinu puma ralu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Go rabu nipumi nimu go-rupa lakalisa: Gote nipuna buk madaa gu-rupa lu wisa: Naa adare beten lape adaae yade lo lisana. Go pea pare nimimi go epe kone giyoma paake ne alinuna kaledape ada-rupa wariamena lisa. ");
INSERT INTO kjs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Go puma Yesu ade abuna lotu ada-para enaali agale mogealisa. Go pisa-pulu Gote-na lodo kira-ae ali kalunu-para rekena agalena tisaanu-para enaalinuna ali mudu-para nimu raayo kiritaoma Yesu lu makomaatalo yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Go pirisimi pare enaali raayome Yesuna agale waru pago pisimi-pulu ali kalunumi go rabu mada nalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Koro meda Yesumi lotu ada ru-nane enaalinu Epe Agale lakalisa rabu Gote-na lodo kira-ae alinu-para rekena agalena tisaanu-para kone makuaae alinu-para nimu raayo Yesu nipu piri-para ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ipisimi rabu nipu gu-rupa lakalisimi: Neme naa lagiali. Nena go kogonore aapimi mogeaaripae-daa neme go kogono pamu pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Gore Yesumi nimu-para agale gu-rupa lakalisa: Neme page nimi agale meda agaa mealua-le nimimi ni lagialimina lisa: ");
INSERT INTO kjs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon Baptais-mi kogonore Gote-me kalisa palo pa enaalinumi kalisimi pae? ");
INSERT INTO kjs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gore nimuna kiritaoma agale gu-rupa lisimi: Naame ake tema pae? Gore naame Gote-me kalisa tema-daare nipumi gu-rupa tea: Nimimiri ake paa-daa Jon madaa kone narulaeme pe lagialia. ");
INSERT INTO kjs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gore naame pa enaalinumi kalisimi tema-daare go piri enaali raayome kaname naa tyalimi. Go piri enaalinumi Jon-re ora Gote-na agale lakale ali kone waru rulaeme. Go pea-le pa enaalinumi Jon kogono kalisimide mada natema lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nimumi Yesuna agale abulisimi rabu naare Jon-na kalu-ipa kogonore aapimi kalisa pe maarea lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Go rabu Yesumi nimu go-rupa lakalisa: Gore nimimi maarea lamede-le neme go kogonore aapimi puri ni go aaya-daa pe palo nalagialua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Go rabu Yesumi enaalinu-para saa pi agale meda gu-rupa lakalisa: Ali medame nipu wain maapu poasa. Go pumare nipuna maapuri yoto meape alinumi surubenaloma nipu pora kimisu adaalu-para pisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gore ora epe kili elesa raburi nipumi kogono ali meda maapu surubape alinu maapu-para eda kilinu mula penaalisa. Go pisa pare maapu surubape alinumi go ali ripinaaoma luma wala penaalisimi pare ele nakalasimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Go pisimi-pulu mo maapuna aaraame kogono naaki meda penaalisa. Go pisa pare mo alinumi nipu page ero agale loma nipu luma ele nakalasimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Go pumare mo alimi kogono ali repo mea rapasa. Gore maapu surubape alinumi go naaki nipu page radaa kaloma pape kamaa-nane puma lu rubisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Go pirisimi raburi mo wain maapuna aaraame talo: Neme ake palua ya? Gore nina epe naaki komea mea rapaalua raburi nipuna agale mada pagalimi kone salo lisa. Go puma nipuna si mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Go pisa pare mo maapu surubape alinumi mo nipuna naaki ipisa adisimi rabu nimumi go-rupa lisimi: Go naakimiri werepe aaraana moae-elenu mealia-le naame lu makomaamina lisimi. Go pumare go maapu naana mada surubamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gore mo naaki pape ru-nane epenaloma nimumi lu makomaoma kamaa-nane pua rubisimi. Go puma go maapuna aaraare nipumi ake palia pae? ");
INSERT INTO kjs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nipumi gu-rupa palia lo lagialo: Nipumi ipuma mo maapu surubape alinu epa lu makomaoma go wain maapuri pa alinu medalomame surubenalo maa katea lisa. Gore go enaalinumi go Yesuna agale pagoma nimumi talo: Dia, nipumi go-rupa napalia lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Go lisimi rabu Yesumi nimu adaba suma talo: Dia leme pare Gote-na buk-mi sade agalena re madaa ake leme ya? Pagalepa lisa: Kamda kogono pi alinumi kana meda mea rubisimide. Pare go kanare ora epe Mudu Ali-na aaya-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Enaali raayome go kana madaa palega tabalimiri nimu ogegepu rugula tyabebe palia. Go kaname enaali meda palega tabama lopaliare go aliri aasaluma rugula palia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesumi go saa pi agale lakalisa rabu rekena agalena tisaanu-para Gote-na lodo kira-ae ali kalunu-para naa madaa go agale tea kone wisimi. Ora go raburi nimumi nipu ripinaalalo pirisimi. Go pirisimi pare enaalinu madaa paala komoma giyasimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Go pumare nimumi nipu ripinaalalo waru adapaba aasimi. Go puma go alinumi pa ali medalomana kana kalanaloma makirae kone suma Yesu piri penaalisimi. Nimumi Yesu agale loralo pirisimi pare nipu kolisimi. Go pumare mo namba wan gavman-na purimi kose pagenalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Go makirae alinumi Yesu agale go-rupa lakalisa: Tisaa, nena agalere ora epelea. Neme enaali raayo epe agale mogelele. Neme Gote-na pora madaa ora agale kama mogeaaye rabu ali kalununa biri paalame nakome. ");
INSERT INTO kjs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Go pe-le nemere ake kone sale pae? Naana rekena agale madaare naame Rom suna ali mudu Sisar-para takis kalamina yapae dia yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pare Yesumi nimuna makirae agale madaare makuaama misa-pulu nipumi nimu lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kana meda ni mea waalepa. Go kana madaa pia piksa-para bi laapore aapina yapae? ");
INSERT INTO kjs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gore nimumi talo: Sisar-na lisimi. Go lisimi-pulu Yesumi nimu-para gu-rupa lakalisa: Sisar-na elere nipuna katepape pare Gote-na elere Gote nipuna katepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gore makirae alinumi enaalinuna le agaa madaa Yesu namakiraeme-pulu nimu agale loraoma pa pirisimi. Go page nipuna agale madaa kone adaapu wisimi-pulu agale nale pa aasimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi alinu medaloma Yesu nipu piri ipisimi. Mo Sadyusi alinu nimuna konere kome enaalinuri wala mada narekalimi kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gore nipu lorapisimi: Tisaa-ya, Moses-me agale meda naa-para gu-rupa lisana: Ali meda ena rumaaoma komalia pare nogo naaki meda namade saaya. Go pumare go ena wasaame kome alina nogo naaki matia-daare go kome alina ameme go ena mada meaalia ya? Moses-me gu-rupa lisana lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gore ameaya ki medane luma medane laapo pirisimi. Abala mupaamere ena raapu pisa pare nipuna nogo naaki namaduma nipu komisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gore laapopa alimi mo ena wasa nipu misa. ");
INSERT INTO kjs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wala go alina koau-nane alimi repome page go-rupa pisa. Go pama pumare mo ameaya ki medane luma medane laapo nimumi mo ena komea misimi pare nimu nogo naaki namaduma pa komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Werepe go ena page komisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gore abala kome enaali wala rekalimide raburi go ena komeare aapina were ora pitia ya? Mo ali ki medane luma medane laapome go ena abala komea rumaasimide lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Gore Yesumi nimu go-rupa lakalisa: Abi go rabu su kamaa pimi enaalimiri repaya pitimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pare werepe kome enaali wala rekoma piralimide enaalinumiri nimu rapaaya aulape kone nasalia. ");
INSERT INTO kjs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nimu Gote-na ensel-rupa piralimi-pulu nimu wala mada nakomalimi. Gote-me nimu tapa-para marekaalia-pulu nimu Gote-na si wane-rupa ade abuna piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kome enaali tapa-para wala rekapere Moses-me page abala lisaaya. Go buk-ri repena sulaa roape remaa lakalisa rabu nipu Ali Mundu-ri ora Abraham-para Jekop-para Aisak go repena Gote pa pia-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Go agalena re gu-rupa lisa: Gote-re kome enaalinuna Gote-daa dia, pare nipu kagaa piramala pope enaalinuna Gote yaade. Enaali raayo wala rekalimi lo go agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nipumi go-rupa lisa raburi rekena agale tisaanumi gu-rupa lisimi: Tisaa, neme ora waru lae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Go lisimi pare nipu wala agale meape paalame komisimi pare pa ora lae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesumi nimu go-rupa lakalisa: Gore nimumi enaali Raapu Pirape alina Siri nipu Devit-na si piralia leme. Go agalena re ali ya? ");
INSERT INTO kjs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Buk Sam madaare Devit nipuna agale gu-rupa lisa: Gote-me nina Ali Mudu-para gu-rupa lakalisa: Naa popeke ki-nane ali mudu mapiraalia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Werepe neme lore alinu nena age rolo-para marabuainaalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gore Devit-mi naa Mudu Ali nipu lakalisa. Go lakalisa-pulu enaali Raapu Pirape alina Siri Devit-na si-daa napiralia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Go enaali raayome pa piruma Yesuna agale pago pirisimi rabu Yesumi nipuna disaipel alinu gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Rekena agale tisaanuna kone waru adalepape. Nimumi mamina epe yamoma maket-na puma enaalinumi abi piralepape leme rabu raaname komeleme. Go alinumiri Juda alinuna lotu ada-para page eda yawaeme-para page pada riri-nane nimu abala pua pimi. ");
INSERT INTO kjs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Go alinumiri ena wasaana ele paake no peme. Go puma nimumi beten adaalupu yoloma leme rabu enaalinu makiraeme. Go peme-pulu werepe Gote-me kose talia rabu nimuna koe kedaa ora adaalepe mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesumi adisa rabu kamo le alinumi lotu ada-para kana wi pe-para kana epa lopaeme. ");
INSERT INTO kjs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Go rabu naarali pabe ena wasa meda nipuna oge kana ipa laapo epa lopasa. Go kana-re ora ogeasi gu-rupa 2 toea yade. ");
INSERT INTO kjs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Go pisa pare Yesumi talo: Neme nimi lagialo. Go naarali piri ena wasaame kana lopata rabu nipumi enaali medalomana kana ma-oge yaoma rabunaaya. ");
INSERT INTO kjs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Medalomamere kana adaapu wimi-pulu pa kode meda muma go kana epa lopasimi pare mo ena naaralimiri nipuna eda kabape kana raayo epa lopasa. ");
INSERT INTO kjs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Enaali medalomame lotu ada madaa agale lala pirisimi. Nimumi go lotu adana kana aulaoma Gote repara katemede elenu epetea lisimi. Go rabu Yesumi talo: ");
INSERT INTO kjs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Abi nimimi go adaleme elenuri werepe yapi di epaliade rabu go adaa lakepe rubalimi-pulu kana komeade page na-ralapatia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gore nimumi Yesu nipu agale gu-rupa lisimi: Tisaa, nena laede elenuri aa-rabo epalia ya? Naame ele adalima rabu go elena yapi di epalia mada makuaaoma makuaalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesumi talo: Nimimi waru adalepape. Makirae enaali adaapu ipuma nina bina gu-rupa lagialimi: Niri enaali Raapu Pirape Alina Si yade lalimi. Medalomamere go epaliade yapi di abi go epaana-daa lalimi. Pare nimu naraita maa pulupape. ");
INSERT INTO kjs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Werepe nimimi yada pape remaa-para koe-rupa pogolasaape remaa pagalimiri paalame nakoma piralepape. Go elenu abala palia pare su yaa perekele di-ri go-daa dia. ");
INSERT INTO kjs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesumi agale meda wala gu-rupa lisa: Go raburi ruru rado radonu yada palimi. Go-rupa gavman adaa su robo rado radonu page yada palimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Go raburi su rado rado-para suminini lewa lewa adaa puma reae adaa paboma koe yainanu page epalia. Go raburi so yaa-parare koe ele adaapu puma koe ele epape di page epalia. ");
INSERT INTO kjs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pare go ele raayo abi na-epalia. Dia, abala nimumi nimi ripinaaba piruma koe kedaanu gialimi. Nimi mo lotu adanu ru-nane maa puma kose loma karapo ada mapaitaalimi. Go pumare nimumi nina kogono enaali rabuaniaalalo palimi rabu nimiri kadipinu-para adaa ali mudunu nimuna le agaa madaa maa palimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Go rabu nimimi nina Epe Agale lakeleme-daa go-rupa palimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nimumi nimi kose-na maa palimi raburi ni ake lano yapae agalere kone abala namasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Dia-le neme agale-para epe kone-para lagialua rabu nimina yada lore ali raayome nimina agale mada nagiyoma raitalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Go rabu nimina ama aapanu-para ame balinu-para nena ruru-para adami alinu-para nimumi lore alinu maa kateme. Go puma nimumi nimi medaloma lu makomalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nimi nina agale ralimi-pulu enaali raayome nimi-para ora rono pago giyalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Go palimi pare nimina kalu-para ae iri meda mada ora napudia alupalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nimimi puri paloma adoba piralimiri ade abuna kagaa piramala palimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Gore nimimi soldia alinu so Jerusalem su epa kuta pina adalimiri go su adare pabo tyape yapi di go opapa yada. ");
INSERT INTO kjs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Go rabu Judia piri enaalinu nimiri ora rudu-nini kana apedaa-para pogola pulupape. Enaali medaloma ada-para piralimiri pogola pulupape. Go page pa su mopare ae enaalinu wala adare-para na-epa kodobalepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gore Gote-na buk madaa wi agale raayore ora go raburi Gote-na ronore go enaalinu madaa koyaalia rabu koe kedaa yapi di maa salia. ");
INSERT INTO kjs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Go raburi nogo naaki padaa piri enanu-para adu nalae-para wagepu napalimi-le ora kodo pea. Go su madaare ora adaa kedaape meda epalia-le Gote-me go su kamaa piri enaalinu madaa ora rono waru pagalia. ");
INSERT INTO kjs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Go rabu nimumi enaali medalomanu rai kudumi luma medaloma lore alinumi adi rulubaoma ruru radona rikirana puma mapiraalimi. Go rabu page pa enaali ruru rado medame Jerusalem mabebolaama pumare werepe go koe yapi di dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Go raburi naare suba kubanuri rado rado aalimi. Go su kamaa enaalinu raayona lo-parare adaa kedaa mu piralimi. Go ipa solwarame agale loma ralia-daa paalame waru komalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Enaali adaapumi go su-para ele meda ipula kone suma pu robaa-para paala waru komalimi pare le-para page lemelalu mapaalia. Gore so yaa-para kuba kedo ele lewa lewa palia-daa paalame waru komalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Go pinaloma enaali Raapu Pirape alina Siri yaa mole raapu ipulaina puri adaae adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gore werepe gode elenu ripia epalia rabu wagepu rekoma nimina kalumi waru adalepape. Go raburi Gote-me nimina ade abuna kagaa Pirape Yapi di-ri go maa epea-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Go rabu Yesumi nimu saa pi agale meda gu-rupa lakalisa: Nimimi repena fik madaa pa repena medanu page adalepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kagaa ma-pulaoma yo palia-daare gore pane puma naare ralia kone salepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Go-rupa elenu adalimi-daare gore Gote-na Surube Yapi-na di abi re-para go epea-daa kone salepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Go agale pagalepa: Abi go pimi enaali nakomalimi pare go elenu abala epenalo adalimi. ");
INSERT INTO kjs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Su yaa raayona elere abala dia yaalia pare nina agale adae abuna pa salia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Gore nimimi waru adalepape. Nimimi adae abuna eda adaapu nayawoma ipa bia noma makeae ali-rupa napiralepape. Go page go su kamaa yogalena elenu madaa kone adaapu nasalepape. ");
INSERT INTO kjs_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Go yapi di-ri nimi piri ora wagepu epalia-le gu-rupa napiralepape. Go yapi di epalia rabu konape-rupa enaalinu madaa perekelema tyaboma palia. ");
INSERT INTO kjs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Go palia-pulu nimi ade abuna adoba piralepape. Go puma Gote-me nimi puri gina ora yalo beten tapape. Go palimiri koe elenumi nimi piri epalia pare nimimi puri muma enaali Raapu Pirape Alina Si raapu epe-rupa mada piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ade abuna Yesumi enaali lotu ada-para puma lakalisa. Go puma ribaale-para nipu mo Oliv Rudu madaa paitalo pumare lotu ada wala ribaa reko epala pisa. ");
INSERT INTO kjs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Go pisa rabu enaalimi Yesuna agale pagolalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret-para yis nasape Pasova Yapi di-ri abala rudu lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gote-na lodo kira-ae ali kalunu-para rekena agalena tisaanu-para nimumi Yesu talalo pirisimi. Go pisimi pare enaalinu madaa paalame komoma pagaa wi kone su pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Go raburi Satan-me Judas-na lo robaa-para puma kodobasa. Mo Judas-na bi medare Iskariot leme. Go ali nipu mo 12-pela disaipel ali ru-nane pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan nipuna lo robaa-para kodobasa-pulu Judas nipu puma Gote-na lodo kira-ae ali kalunu-para mo lotu ada surube surube alinu-para agale nimu raapu pua lo pirisimi. Nipumi Yesu nimumi linalo yada robisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Go raburi nimu pedo pedo waru pumare nipu kalape kana medaloma kirita su pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Gore Judas agale pagoma epelea lisimi. Go pumare nipuri ake pua mada mea waatoa pe kone suma kone kone adaapu mu pirisa. Nipumi rana meda enaali adaapu raapu napitimide rabu nimu waatoa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Olode rabu bret-para yis nasape di rudu lisa raburi Pasova eda kirape sipsip mena si meda talalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Go rabu Pita-para Jon laapo Yesu nipumi rapaoma agale gu-rupa lakalisa: Nipimi naana Pasova eda namina ele puma kiritaoma salepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gore nipumi agale gu-rupa misipi: Naame aa-para puma kiritao suma namina yapae lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Gore Yesumi nipu gu-rupa lakalisa: Pagalepa. Nipimi adare-para palipi rabu ipa norili ali meda madaalipi. Go ali nipu raita maa pulupape. Go puma kodobaliade ada-para pulupape. ");
INSERT INTO kjs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Go pumare nipimi go adana aaraa gu-rupa lakelapape lisa: Tisaa-me ne agale meape laa: Nipuna disaipel alinu raapu Pasova eda nalima-pulu neme go eda kiritape ada rum meda waalape lo robaama agale meape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Go tepe raburi mo alimi nipi adaa so madaa-nane maa puma epe au pi ada rum-aepara mea waatea. Go-parare reke madaa ele kiritao salepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Go agale lakenaloma mo ali laapo puma nipumi lakalisade-rupa adisipi. Go rabu nipu laapome Pasova eda kiritoma sasipi. ");
INSERT INTO kjs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eda nape di raburi Yesu nipuna disaipel alinu raapu rapaluma madaa pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gore nipumi nimu gu-rupa lakalisa: Neme go edare nimi raapu nolalo ora raaname waru komalo. Gu-rupa noma werepere neme kedaa pi elenu ritua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Neme nimi lagialo: Neme eda wala meda nimi raapu nanalua pare Gote-na Surube Yapi di rabu elaana re adalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Go rabu nipumi kap-para madaa pira palae wain muma Gote-para ora pili loma nimu-para kalataoma talo: Nimimi go kap-para muma rumaaoma nalepa. ");
INSERT INTO kjs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Neme nimi lagialo: Abi neme nimi raapu wain ipare wala nanalua. Dia, pare Gote-na Surube Su madaa go elena re adoma nalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Go pumare nipumi bret muma Gote-para ora pili loma piribliisa. Go puma nimu kalaoma talo: Go bret-re nina yogale-le nimi raba minalo gialo. Nimimi ni madaa kone suma nalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Go pumare werepe abala no kiritinaloa ipa wain pira palae muma kalaoma talo: Go koyaape kap-parare wain-ri nina yaapimi nimi raba minalo koyaato. Gore Gote raapu pogalu pirapena nimi madaa komalua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yapare adalepa. Ni yada lore alinu mea kalape aliri abi ni raapu go reke madaa komea-para eda go no pima-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Enaali Raapu Pirape alina Siri Gote-na agale raluma komalua lisa. Go pea pare mo ni lore alinuna ki-nane mea kateade aliri ora kedaa waru mealia-daa kodome komalo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nipumi go-rupa lisa raburi nimumi aapimi palia yapae lala pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Disaipel alinumi ape puma nimuna rikiranare ali muduri aapi ora yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gore Yesumi nimu gu-rupa lakalisa: Ruru radona ali mudunu nimumi puri paloma nimuna ruru enaalinu surubeme. Go pumare mo surube enaalinumi bi enaalinuna raba mi alinu lo bi ma-aeme. ");
INSERT INTO kjs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pare nimi gu-rupa napiralepape. Dia-le ali meda nimina rikirana ali mudu abala piralia-daare gore nipu pora poma madina ali-rupa abala piralia. Nimina mudu pirape aliri abala kogono puma nimina raba mi ali-rupa piralia. ");
INSERT INTO kjs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gore ali medame eda pa nolalo piru aaya pare ali medame kogono puma eda rumaaya. Gore mo eda abala nolalo pia aliri nipu ali mudu yana. Pare ni nimina rikirana piru aayo rabu nimi raba muaayo. ");
INSERT INTO kjs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Neme kedaa ru aayo rabu nimi ni raapu piruma nagiyasimide. ");
INSERT INTO kjs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gore neme su raayo surubenalo Aapame nipuna puri gisa. Go pea-le neme page nimi surube kogono gialua. ");
INSERT INTO kjs_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gore nina Surube Yapi-para piruma nimi naa reke madaa piruma eda namina. Go puma nimi epe reke madaa piruma Israel su-para piri ruru 12-pela enaalina kose agale pagolalo piralimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ora Saimon, neme pagape. Gore wit poape alimiri nipuna edare epelea palo kolea palo eda waru adalia. Go yapare neme puri kalisua-pulu Satan-me nimi kotalalo epalia. ");
INSERT INTO kjs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yapare Saimon neme kone rulaere nagiyaliminalo neme ne raba mulalo beten loaayo. Werepe neme ni madaa kone wala perekea suma nena amenu puri kalape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Gore Pita-me go-rupa lisa: Mudu Ali, niri ne raapu abi bainalo karapo ada page ni ne raapu mada komalua kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Gore Yesumi talo: Pita ne lagialo. Abi go ribaare yaa kagarame e talo palia rabu neme Yesu ni na-ade rana repo te lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Go rabu Yesumi nimu gu-rupa lakalisa: Nimiri abalade mea rapaaripude raburi nimina kana paus-para mainu-para age ada go elenu namuma pisimide. Go pisimide-le nimi ele meda rudu lisa pae? Gore nimumi talo: Naa mu aaema lisimide. ");
INSERT INTO kjs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gore nimu gu-rupa lakalisa: Abiri enaali raayome kana paus-para mainu-para saapitimiri maa pulupape. Enaali raayome nipu adaalu rai kudu nasalimiri nimina mamina madaa kana muma rai kudu kabalepape. ");
INSERT INTO kjs_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gore nimi lagialo: Gote-na buk madaa ni-para gu-rupa lisa: Nipu enaali koae aunu raapu page mapiraaeme lo lisana. Go agalena re-re werepe ni madaa epalia-le adalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Go rabu disaipel alinumi talo: Mudu Ali, neme ade. Naame adaalu rai kudu laapo go saapima lisimi. Gore nipumi talo: Apo saapimi mada lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nipu kamaa puma lisana nipuna ade abuna puala pi-rupa Oliv Rudu madaa puma pisa. Go rabu nipuna disaipel alinumiri nipu raapu pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mo Oliv Ruduna pumare nipuna disaipel alinu gu-rupa lakalisa: Koe eleme nimi namakolinalo beten tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Go lomare nimu giyoma ogesi-daa pumare rumu pege puma beten lisa. Nipu pisade-rupare kana mea lopalema-rupa mada pisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Go rabu nipumi talo: Aapa, neme kone saliri ni radaa nape pe kap maa pu. Yapare nina kone giyoma nena raana raitano lape. ");
INSERT INTO kjs_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Go rabu yaa-para piri ensel meda nipu piri-para ipuma nipu epa puri mapalaasa. ");
INSERT INTO kjs_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nipu madaa kedaa adaalepe ritinalo pisa-pulu nipumi beten puri paboma wala lisa. Go pumare nipuna puduri yaapi-rupa kilipima su kamaa popesa. ");
INSERT INTO kjs_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nipumi beten abala loma lisana rekaoma nipuna disaipel alinu piri-para pisa. Nipumi puma adisa pare nimuna lo robaa-para kedaa waru pisa-daa u palisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gore nimu gu-rupa puma lakalisa: Nimiri ake paa-daa u paita piruaeme? Nimi madaa koe eleme nakolinalo beten lo piralepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nipumi agale pa lakelalana enaalinu adaapupe meda ipisimi. Gore Juda alinu riri-nane epena enaalinu nipu raita mea ipisimi. Go aliri disaipel alinuna ru-para pirisa. Nipu re-para ipuma Yesu-para nunu tyalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Go pisa pare Yesumi Juda alinu gu-rupa lakalisa: Neme enaali Raapu Pirape alina Si nunu loma mea waaloma yada lore alinu kalalo pae? ");
INSERT INTO kjs_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gore disaipel alinu nipu raapu pirisimi alinu mo ipisimide adoma nimumi talo: Mudu Ali, naame nimuri go adaalu rai kudumi tyamono ya? ");
INSERT INTO kjs_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Go rabu disaipel ali medame kogonome adili naaki meda rai kudumi lisa. Go naakiri Gote-na lodo kira-ae alina kogono pisa. Lisa rabu mo popoke-nane kale poaina tyaboma lopesa. ");
INSERT INTO kjs_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Go pisa pare Yesu nipumi go-rupa adoma talo: Go yada giyalepa. Nipuna kimi muma mo kale wala mea masaa. ");
INSERT INTO kjs_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Go pumare mo alinumi Yesu ripinaalalo ipisimi. Gore Gote-na lodo kira-ae ali kalunu-para lotu ada surube alinu-para ali mudu medalomanu-para ipisimi. Ipisimi rabu nipumi talo: Nimina rai kudunu-para repena kulinu mea epamena-le gore nimimi ni paake ne ali kone suma tyalalo epame pae? ");
INSERT INTO kjs_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ade abuna niri nimi raapu lotu ada-para pimade pare nimimi ni tima kone nasalimide. Go pemede pare abi go yapi di raburi ora nimina puri-para ribaana purimi rabuaata lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Go pumare nimumi Yesu epa adiala Gote-na lodo kira-ae ali muduna ada-para maa pisimi. Go pirisimi raburi Pita nipumi nimu raita maa pisa pare nipu ogesi-daa mo-pare puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Go rabu ali medalomame epe pokaalo ada ru-nane repena adola kirisimi-pulu Pita nipu page nimu raapu puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Gore kogono ena medame Pita repena re-para pirina adisa rabu go ename Pita nipu-para go-rupa lisa: Go ali page abalade Yesu raapu pirisa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pare Pita-me talo: Go ena ni-daa dia-le go ali-daa ni na-ade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pare wala ogesi-daa piruma ali medame wala nipu adoma talo: Ne page Yesu raapu piriside lisa. Gore Pita nipumi talo: Go ali ni-daa ora dia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Werepe ogesi-daa adaalupu piruma ali medame agale ora puri paloma gu-rupa lisa: Go ali nipuna adare Galili yaa-pulu nipu abalade Yesu raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Go lisa pare Pita-me talo: Nemere go laede go ali ora ni na-ade lisa. Nipumi go-rupa pa lalaina yaa gulame abala wagepu rekoma agale lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Go rabu Mudu Alimi perekea luma Pita ada monelisa. Go pisa rabu Pita-me Mudu Ali abalade nipu-para lakalaade agale wala makuaasa. Abala Yesumi gu-rupa lakalisade: Go rabu yaa kakarega abi rekoma agale tea pare neme ni rana repo abala giyali lakalisade. ");
INSERT INTO kjs_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Go raburi Pita nipu so kamaa-nane puma re puri palo pua pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Go rabu Yesu surube alinu nimumi nipu epa ripinaabaoma ero agale loma nipu lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nipuna le laplap-me kepuma nipu agale gu-rupa misimi: Nere aapimi taa pa lisimi. Nere Gote-na agale lakale ali ya-pulu agale lagiape lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Go pumare nimumi ero agale rado rado lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Werepe yapi lapaasa raburi Israel enaalina ali kalunu-para Gote-na lodo kira-ae alinu-para mo rekena agale tisaa-nu page epa kiritasimi. Go pumare Yesu nipu kaunsil piri maa puma agale gu-rupa misimi: ");
INSERT INTO kjs_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nere enaali maa Rapae Alina Si yapae dia pe lisimi. Gore nipumi nimu lakalisa: Gore mada lagialua pare nimimi ni kone narulalimi. ");
INSERT INTO kjs_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Go page neme nimi agale medaloma mealuare nimimi agale mada na-abuteme. ");
INSERT INTO kjs_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Abi page werepe page ni enaali Raapu Pirape alina Siri so yaa-para puri pale Gote-na popo ki-nane ade abuna pitua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Go raburi nimu raayome talo: Gore nere ora Gote-na Si yapae lisimi. Nipumi nimu go-rupa lakalisa: Naa bi go laede lisa. ");
INSERT INTO kjs_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gore nimumi talo: Naame ali wala tema ya? Naame nipuna agale go pagema-pulu pa adasae alinuna agale medaloma giyalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Go rabu kaunsil raayo wagepu rekoma Yesu ali mudu Pailat piri maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Go pumare nimumi kose gu-rupa laa lisimi: Go alimiri naana kone rado mogema Sisar-para kana takis nakatapape laa lisimi. Go page niri ora ali mudu Keriso laa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Go rabu Pailat-me nipu lorapisa: Nere Juda enaalinuna Mudu Ali yapae lisa. Yesumi talo: Nena go laede lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Go rabu Pailat-me Gote-na lodo kira-ae Mudu Alinu-para enaali raayo-para gu-rupa lakalisa: Neme apo alina koe kone meda pename na-adalo-le ake paa-daa koe kedaa katoa pe lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Go lisa pare nimumi agale puri paloma gu-rupa lisimi: Nipumi enaalinu-para agale mogeaaya rabu nimu koe-rupa pogolasaasimi. Go kogonore pa kama puma Galili su-para puma Judia su-para puma abi go su-para page epa pia lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat-me go agale pagoma nipumi agale gu-rupa lisa: Go ali nipuna suri Galili ya? ");
INSERT INTO kjs_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gore nimumi e lisimi-pulu Pailat-me Yesu Herot piri-para maa penaalisa. Gore Herot-mere Yesu madi su surubisa-pulu go-rupa pisa. Go rabu Herot nipu page Jerusalem-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot-me Yesu adoma raaname waru komisa. Yesu madaa remaa abalade pagisa-pulu nipumi Yesu adolalo pisa. Herot nipuna konere Yesumi napi kogono pinalo palia rabu adalua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Go rabu Herot nipumi Yesu nipu agale rado rado lorapisa pare Yesu nipumi agale meda na-abulisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Go rabu Gote-na lodo kira-ae Mudu Alinu-para rekena agalena tisaanu-para nimumi rekaoma Yesu madaa puri pale kose agale lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Go rabu Herot-para nipuna soldia alinumi Yesu-para makiraoma ero agale waru lisimi. Nimumi ora au epe-rupa pi adaalu mamina meda muma Yesu madaa yamasimi. Go puma Pailat piri lamua pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Abaladere Herot nipumi Pailat raapu lore ali-rupa pirisa pare wala go rabu kone komea suma adami ali-rupa wala pirisipi. ");
INSERT INTO kjs_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Go rabu Pailat-me Gote-na lodo kira-ae Mudu Alinu-para Juda alinuna Mudu Ali medalomanu-para enaali raayo page yaaloma makiritaasa. ");
INSERT INTO kjs_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Go rabu nimu gu-rupa lakalisa: Nimimi abalade go ali ni piri lamua epame yade. Nipumi koe pora rado enaalinu mea waatea lamede. Go agale madaare nimina le-aga madaa nipu apo agale meawade pare nimimi mo nipu kose talo pimi pare go ali nipumiri go koeyae meda napaa kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot-me page go alina koeyae meda na-adisa. Pare na-adea-le wala naa piri-para go epenalana. Pagalepa. Go alimiri abalade nipumi koeyae meda napana-daa naame nipu madaa nalu makomalimina. ");
INSERT INTO kjs_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Go pea-le neme repena kulimi nipu mea kudu lumare nipu mea rapaano lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Gore adae abuna eda yawe nape Pasova Yapi Su rabu Pailat-me karapo ada piri ali komea ma-asaata pisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Go rabu mo piri enaali raayome puri paloma gu-rupa yalaasimi: Apo aliri lu makomamina. Go ali Jisas Barabas-re naana wala wasama epenala lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jisas Barabas-me abalade go adare-para yada meda marekaaoma ali meda lu makomaa nipu karapo ada-para mapaitaasimi ali-para lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gore Pailat-me Yesu wala ma-rapaalalo kone suma enaalinu-para agale wala yalisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Go pisa pare nimumi ora puri paloma gu-rupa lisimi: Repena polopea madaa mea tyaminapa. Repena polopea madaa tyaminapa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Go lisimi pare Pailat-me wala rana repo gu-rupa lakalisa: Go alimiri nipuna koe ele meda akeane pana? Neme koe ele meda ora na-adawade. Go pea-pulu neme repename nipu luma maa kepealua lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Go lisa pare nimumi ora puri paloma Yesu repena polopea madaa lu makomamina lisimi. Go puma nimumi Pailat-na agale rabuaniaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Go puma Pailat-me Yesu tyalepa loma nimuna agale ralisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nimuna koe ali Jisas Barabas maa rapaasa. Go alimiri abala enaali koe-rupa mapogolasaaoma ali meda lu makomasa rabu nipu karapo ada-para mapaitaasimi. Go pisa pare Pailat-me Yesu mo enaalinuna agale pagoma nimuna pinalo maa kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nimumi Yesu nipu maa pisimi rabu pa ali meda madaalisimi. Go alina biri Saimon nipuna su Sairini giyoma ipuma no adare-para pulalo pisa. Go rabu nimumi repena polopea nipuna pasaane mariaasimi. Nipumi mea rumare Yesuna koau-nane raita maa pisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Go pumare ora enaali adaapumi Yesu raita maa pisimi. Nimuna rikiranare ena medalomame re loma kodo pia lama pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pare Yesu nipumi wala pereke luma nimu gu-rupa lakalisa: Nimiri Jerusalem enanu-yo. Ni madaa re natepape pare nimi madaa page nimina nogo naaki madaa re lo piralapape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pagalepa. Werepe kedaa meape di epalia rabu nogo naaki namaduma adu nakale enanuri wagepu mada pogola palimiri ora epelea lee lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Go di raburi enaalinumi mo rudunu-para gu-rupa lakeleme: Naana koau-nane lopoma naa lu makomaape leme. Gore wala oge rudunu-para gu-rupa laketeme: Naa ma-kaledaape leme. ");
INSERT INTO kjs_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Abiri ora pane pia-daa go kedaa pia peme-le werepe koe yai epalia rabu ele kedaa ora komalimi ya? ");
INSERT INTO kjs_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Go rabu nimumi pupitagi ne ali laapo page lamua puma Yesu raapu nil talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nimu puma su meda Kalu Rogaae su lemede go-para puma aasimi. Go-para Yesu repena polopea madaa nil lisimi. Mo koe ali laapo page nil-mi luma meda pare Yesuna popoke-nane luma medare koya-nane lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gore Yesumi talo: Aapa, nimumi kone nasuma pimi-le nimuna koe ele maa ruba lisa. Go pimi aliri nimumi go elena re na-adoma pimi lisa. Go rabu go alinu nimumi Yesu nipuna mamina koyo muma satu lu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Go rabu pa enaalinumi pa rekaoma adapaba pirisimi. Go pirisimi pare mo Juda ali kalunumi Yesu-para ero gu-rupa lisimi: Nipumi abalade enaali medaloma raba mu aaripa-le nipuna gole nipu raba mea lisimi. Gore Gote-me nipu Mea Rapaae Ali yaa-pulu mada palia lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldia alinumi page nipu-para ero agale lisimi. Nimumi Yesu re-para ipuma rero pi ipa wain epa kalalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gore nimumi gu-rupa lisimi: Nere ora Juda alinuna Mudu Ali yaalia-daare gore nena gole raba muma no suna nipu lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pepa meda so repena polopea kuni madaa lu saabaasimi: Go aliri Juda alinuna Mudu Ali yade lo lisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mo ali koe laapo abalade lu mudiasimide medame Yesu-para ero agale gu-rupa lisa: Ne Enaali Raapu Pirape Alina Si laede-pulu ne page saa page raba mea lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Go rabu mode mudiasimide ali medame ali-para gu-rupa arere lisa: Naame kedaa komea-rupana meamade-le nere Gote paala napea pe lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Saana kedaare saana komea-aena ora mada gialeme. Pare abi go aliri nipumi abalade koeyae meda nawisa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Go puma nipumi Yesu-para talo: Yesu nere Mudu Ali pirali raburi ni madaa kone saena lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Gore Yesu nipumi nipu gu-rupa lakalisa: Neme ora ne lagialo. Abiri nere ni raapu so Gote-na epe maapu-para pirapana lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Go naare paame naare kudunoma ribaa yoma su raayo keapuma naare nogo-nane pabola popesa. ");
INSERT INTO kjs_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Go pisa raburi mo lotu ada ru-nane mudiabaaya adaa mamina so kuni-nane riripitaaboma none kuni-nane puma riripi tabisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu nipumi puri paloma gu-rupa lisa: Aapa, nina kone popo nena ki-nane madaa apo salo-daa lisa. Nipumi go-rupa lisa rabu pu imu kudinasa. ");
INSERT INTO kjs_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mo soldia alinuna Mudu Alimi go adisa-pulu nipumi Gote-na bi minasaoma talo: Ora yana go aliri ora epe ali yana lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Enaali adaapumi nipu pia adolalo epa adoba pisimi-pulu nimuna aako luma ada wala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuna adami alinu raayo-para enanu medaloma abala so Galili su-para piruma Yesu nipu raita mea ipisimi. Nimu ogesi-daa mo-para rekaoma mo ele raayo adoba kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ali meda nipuna biri Josep pirisa. Nipuri Juda alinuna adare meda biri Arimatea su-para piruma nipu ora epe ali piruma Gote-na Surube Su epenalo adolalo pirisa. Gore nipumi kaunsil raapu pirisa pare Yesu lu makomamina lisimi rabu nipumi dia lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Go ali nipu Pailat piri puma Yesuna rore nina mea ria pono lisa. ");
INSERT INTO kjs_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Go puma nipuna ro mea rumare mamina yaako pimi rogaa palae maa pisa. Go puma nipu kana apedaa meda-para puma rogaasa. Go-parare abalade ali meda abi narogaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Go yapi di-ri Pomo mu Pirape Yapi rudu lisa rabu ada koro rabu madaa nape edanu ma-redepo yaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Enaalinu abalade Yesu nipu Galili su giyesa rabu nimumi nipu raita mea ipisimi. Nimumi Josep raapu puma mo kana apedaa tapa-para Josep-me rogaasa-rupa adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Go puma nimumi adoma nimuna ada wala puma epe kaa pi elenu Yesuna ro madaa sainalo kiritao pisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gore adaa koro rabu kogono mupaa yapi di rabu mo enaalinu tapa-para pisimi. Nimumi mode kaa pide elenu-para abala kirtao suma mea madisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tapa-para ipisimi rabu mode pora gaape kana abala maa rubuma lobapaina adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Go pea nimumi no tapa apedaa-para puma adisimi pare Mudu Ali Yesu nipuna rode nasaaya. ");
INSERT INTO kjs_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Go puma nimu pa rekaoma kone adaapu su pirisimi rabu ali laapo nimu re-para wagepu opapasipi. Go ali laapore nipuna mamina-nu ora yaako pi-ai maraasipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Enanu nimuri paalame komoma su adainaaoma pirina ali laapome nimu gu-rupa lakalisipi: Nimimiri ake paa-daa tapa-para go ali asa peme pae? Go ali ora pa pia-le go-para mada na-adalimi lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nipuri go-paradaa napia nipu abala rekaade. Abalade nipu so Galili su-para pa piruma nimi lagisade agale wala makuaalepa. Abala gu-rupa lagisa: ");
INSERT INTO kjs_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Enaalina Si Mea Rapaae Aliri koe enaalinuna ki madaa mea kaleme rabu nipu repena polopea madaa lu makomalimi. Go pea pare wala yapi repo dialenaloma wala rekalua lo lagisade lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Go rabu enanumi Yesu nipuna abalade lakalisade agale makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Go rabu nimumi mo tapa apedaa giyoma wala pisimi. Go rabu nimumi pa enaali medaloma-para disaipel ali 11-pela raayo piri-para puma mo nimumi adisimi elenu raayo puma lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tapa-para puma adisimide enanuna biri gu-rupa: Maria nipuna su Magadala-para Jon-para Jems-na agi Maria-para go enanu nimumi go ele adisimi. Go enaalinu-para pa ena medaloma-para mo agalere mogeaae alinu lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakalisimi pare aposel kogono alinumi mo enanu pa kama po rilipu agale pa teme kone wisimi-pulu nimuna agale madaa kone narulalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pare Pita nipu rekoma tapa-para wala wage adola pisa. Nipumi no kana apedaa tapa-para puma adainaaoma mamina komea adisa. Nipu wala ada-para puma kone adaapu suma gore ake pana pe kone wisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Go raburi mo disaipel alinu ipa laapo Emeus su-para pulalo pisipi. Nipu Jerusalem su giyoma Emeasa pora pagina ogesi-daa adaalu pu pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nipu go pora pagina pulaomare mo abalade adisipide remaa laaoma pisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nipu laapome agale laaoma pula pirina Yesu nipu ipuma nipu raapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Go nipu laapome nipu adisipi pare ora Yesu-rupa namakuaasipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Go rabu Yesumi nipu laapo lakalisa: Nipimiri ake laaoma pula pipi? Nipumi go-rupa lisa rabu nipu laapo pa rekabaoma nipuna kone pu rabaa-para kedaa puma le agaa-para kodo pina aasipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Go ali meda nipuna biri Kliopas go alimi agale gu-rupa lisa: Jerusalem su-para palemede alinu-para lapade pare enaalinu-para kimisu enaalinu-para nimumi ademe-le ne komea-mare abalade go-aina remaa napage aa-para piruma lae pae? ");
INSERT INTO kjs_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu nipumi nipu agale gu-rupa lorapisa: Ali madaa tyape pae? Nipumi nipu gu-rupa lakalisipi: Nasaret Yesuna remaa-para lapade. Go aliri ora Gote-na agale lakale ali piruma Gote-na le agaa-para ena raayona le agaa-para ora puri pale agale madaa kogono laapo pea. ");
INSERT INTO kjs_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pare naana lodo kira-ae Mudu Alinu-para naana Mudu Ali medalomanu-parame kaunsil mea kalamede lisipi. Gore nimumi nipu lu makomaape lakenaloma nipu repena polopea madaa tyamede lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Gore abalade naame go alimiri Israel enaalinu naa wala minalo maa rapaae ali kone wima. Gonu raayo paleme raburi abiri yapi repo abala go popaade. ");
INSERT INTO kjs_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Abiri naana ruru ena medalomame naa mapogolasaarimi. Ora abalade yapipu nimu tapa kana apedaa-para adola puame ya. ");
INSERT INTO kjs_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pare Yesu nipuna ro na-adame ya. Go puma nimu wala ipuma naame ensel medaloma adama lo lagiame. Gore ensel-numi Yesuri abala rekoma epe-rupa pia lo lagiame lame. ");
INSERT INTO kjs_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naana ruru ali medalomame tapa-para puma mo enanumi epa lagiamede-rupa puma adaame pare nipu na-adameya lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Go rabu Yesumi nipu gu-rupa lakalisa: Gore nipiri pa kone nasalepape. Nipina lo-parare mo Gote-na agale lakale alinumi lagisimide remaa madaa kone ora ogepusi rulaarina. ");
INSERT INTO kjs_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nipi namakuaaepe? Gote-na enaalinu wala minalo Mea Rapaae Alimi abala ririna radaa noma epe paana puri mealia lo napagapena? ");
INSERT INTO kjs_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gore Yesumi Moses-na agale madaa mea ririnaoma Gote-na agale lakale alinuna remaa raayo lakeloma Gote-na buk madaa wi agaleme nipu madaa lea-rupa go raayo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nimu agale laaoma puma mo ali laapo nipuna pulalo pisipi adare re-para opapasimi. Go rabu Yesu nipuna raaname ogesi-daa wala pa palima kone wisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Go puma mo ali laapome nipu-para talo: Adoba. Ogesi-daa pa piramina. Naare pabola pea-le nere saa raapu piramina lisipi. Go rabu nipu ada ru-nane puma nipu raapu komea-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gore eda nolalore Yesu nipu raapu rapaluma madaa pirisipi. Go rabu nipumi bret muma Gote-para ora pili loma piribima mo ali laapo kalisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nipumi go-rupa pisa rabu nipu laapome le rupaoma lo robaa-para paa ipisa rabu waru adisipi. Go pisipi pare go rabu Yesu pa wagepu pisa-le wala na-adisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gore go ali laapome talo: Saa abala pora pagina epapade rabu nipumi saa Gote-na agale mogeaaripa-daa saana pu robaa-para rekataba lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nipu laapome go-rupa lomare wagepu rekoma wala Jerusalem su-para pisipi. Nipumi mo aposel kogono ali 11-pela page pa adami ali medaloma page nimu kiritaba pirina adisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Gore mo alinumi nipu gu-rupa lakalisimi: Mudu Ali ora rekaa yade lisimi. Saimon-me nipu ora adaa yaade lisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Go raburi go ali laapome mo enaalinu-para mo pora pagina pisade remaa lakalisipi. Go puma Mudu Ali nipumi bret maa piribiaoma naa kalisa rabu saame waru adapa lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nimumi go agale lala pirina Yesu wagepu nimuna rikirana epa rekesa. Go rabu nipumi nimu-para talo: Nimuna lo robaa-para epe kuma pi kone su piralepa lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pare nimumi remo meda adoma kone wisimi-pulu nimumi paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gore nipumi nimu gu-rupa lakalisa: Nimiri ake paa-daa pogolasaarimi ya? Nimina lo robaa-para kone adaapuri ake paa-daa saleme pae? ");
INSERT INTO kjs_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gore ora ni yade-le nina ki age raayo adalepa. Nimina kimi naa yogale kuli lapo-para waraatepa. Remore gupa-daa dia yade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nipumi go-rupa lomare nipuna ki age laapo nimumi adenalo mea waalisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nimumi pedo ora waru puma kone adaapu wisimi-pulu nimumi kone narulasimi. Go raburi nipumi nimu lorapisa: Nimiri eda medaloma saapimi pe lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nimumi abala kirabae wena piribili mea kalisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gore nimumi adabaaina nipumi muma nisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nipumi nimu go-rupa lakalisa: Abalade ni nimi raapu pa pirisuade rabu nimi go ele madaa abala lagelisude. Gore mo Moses-na rekena agaleme page Gote-na agale lakale alinumi page buk Sam-para page ni madaa loma lisimi yaade. Go remaana re ora adalimina lagiawade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Go rabu nipumi nimuna lo robaa-para paa ma-epasa-pulu nimumi mo Gote-na agale waru adisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Go rabu nipumi Gote-me enaalinu wala minalo Mea Rapaae Alimiri kedaa adaae meda ruma tapa-para piruma yapi repo dialenaloma kome su giyoma rekalia lo wi yade lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nipuna bina purimi su raayona piri enaalinumi kone perekeaminalo agale laketapape lisa. Go pumare Gote-me enaalinuna koe ele mea rubalia-le agale laketapape lisa. Go kogonore so Jerusalem-para ripimaa puma su raayona pinalo lakelapa. ");
INSERT INTO kjs_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yesumi apo agale lo kiraloma nimu-para wala talo: Nimimi go adalemade elenu madaa remaa laketapape. ");
INSERT INTO kjs_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Abalade Gote-me puri gialua lo lagisa-pulu neme ora maa rapaalua. Pare nimimi so yaa-para wi puri nimi madaa epenalo Jerusalem siti-para adobalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Go rabu nimu go adare giyoma nipu Betani su-para lamua pisa. Go-parare nipuna ki minasaoma nimu-para epe puri minalo agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nimu-para lakeloma puma nimu piri-para giyesa. Go puma Gote-me nipu yaa-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gore nimumi nipuna bi minasaoma Jerusalem su-para wala pisimi. Pisimi rabu pedo waru puma raaname komoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Go pumare adae abuna nimu lotu ada-para piruma Gote-para ora pili lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Abalade su yaa laapo nawarili rabu Gote-na Agale abala pirisa. Go Agalere nipuna nipu Gote-rupa pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Abala ririnare go Agale nipu Gote raapu pirisipi. ");
INSERT INTO kjs_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gote-me ele raayo go Agaleme warisa-pulu wariape ele meda pa-rupa na-opapalisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Go pirisa Agalere nipuna kagaa piramala pope kone wisa-pulu nipumi go kone su kamaa mea ipuma enaalia lo robaa-para paa mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Go pare ora ribaale-para roasa-pulu ribaana koe elenumi go paa nama-kudunaaya. ");
INSERT INTO kjs_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gote-me ali medana bi Jon lemenalo mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Go alimiri go epe paa madaa agale lakelalo ipisa. Lakelalo ipisa pare enaalinumi go agale pagoma Yesu madaa kone rulaminalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Go aliri nipu gu paa meape ali-daa dia yapare nipumi mo paa madaa agale lakelalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ora go epe pare su kamaa madisa rabu enaali raayona lo robaa-para makuaa adenalo paa kalalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Go Agalere su kamaa ipisa. Gote-me warisa elere go Agaleme warisa. Nipu epa Agale pirisa pare enaalinumi go Agale waru na-adisimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Go Agalere nipuna adare-para epa pirisa pare nipuna enaalinumi nipuna agale giyoma napagesimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Go rabu enaali medalomame nipuna pora raluma nipu madaa kone rulaeme. Go peme-pulu Gote-me nimu ora nipuna nogo naaki-rupa mapiraaya. ");
INSERT INTO kjs_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nimu Gote-na nogo naaki-rupa piru aaeme agi aaraa laapome madina nogo naaki napiruaeme. Dia, nimuna aaraare Gote komeame madisa-pulu rado-rupa piru aaeme. ");
INSERT INTO kjs_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Go Agalere nipu yogale ma-aoma saba ali-rupa pirumare naana rikirana epa pirisa. Nipuri nipuna Aapana Si komea yaa-pulu Aaraana puri paa mu pirina adema. Naana rikirana pirisa rabu ora agale-para raba meape kone page nipuna lo robaa-para rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon-me nipu madaa gu-rupa lakalisa: Go ali madaare neme abalade agale gu-rupa lakesuade: Nipuri nina koau-nane epalia pare nipuna purimi ni ma-oge yaalia. Nipu ali mudu piralia pare ni abi namadele raburi nipu abala pa pirisa lagiasuade. ");
INSERT INTO kjs_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nipuna epe raba meape kone-para kodome komea-para rubilina nipumi naa komea komea lo epe raba meapa kone page titame komea page gisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gore Gote-me rekena agale kalisa rabu Moses-me mea ipisa. Go pisa pare epe kone-para ora agale-parare Yesu Keriso-me mea ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ali medame Gote ora na-ademe. Ora dia. Mo nipuna naaki nipu komea Gote raapu meda-rupa pipi. Go naakimi nipuna Aapana agale naa piri-para mea ipuma waatea. ");
INSERT INTO kjs_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem su-para piri Juda alinumi Gote-na lodo kira-ae alinu-para Livai ali-para nimu raayo Jon piri-para mea rapaasimi. Go puma nimumi Jon agale gu-rupa misimi: Nere aapi ya? ");
INSERT INTO kjs_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Go rabu Jon-me agalena pagae wi redepo le agale gu-rupa lakalisa: Niri Keriso-daa dia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Go rabu nimumi talo: Gore nere Keriso-daa dia yaana-le nere Elaija yapae lisimi. Dia lisa. Gore ne Gote-na agale lakale ali ya? Dia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Go rabu nimumi wala lapopa Jon-para talo: Gore nere aapi yapae lisimi. Naame mo naa mea rapaarimi alinu-para agale waru ipuma laketema-pulu ne-parare naame ake leme ya? ");
INSERT INTO kjs_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Go rabu Jon-me Aisaia-na agale mogeaoma lakalisa: Niri gu-rupa polalo pi: Neme enaali napiri su-para agaleme yaalano: Mudu Ali-na pamuape pora ma-redepo yaatapape lo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Go agale mulalo pirisimi alinuri Farisi alinuna rurumi rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nimumi Jon agale meda wala agale gu-rupa misimi. Gore nere Keriso-daa dia laede. Go page nere Gote-na agale lakale ali-daa dia laede. Go page ne Elaija dia laede. Go pea-le neme enaalina kalu-ipa ake pea-daa kate pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Go lisimi rabu Jon-me gu-rupa lisa: Neme pa ipame kalu-ipa meaalua pare nimina rikirana ali meda rekaaya pare nimimi na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Go aliri nina koau-nane epalia pare nipu ora epe ali aaya-pulu nipuna age ada wasama kege radepeta palua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Apo agalere Betani su-para pisa. Go suri ipa Jordan-na mone pane go su-para Jon-me kalu-ipa kalaaoma piruma lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ekera-nanere Jon-me Yesu ipisa rabu adoma talo: Adalepa. Gote-na sipsip si-rupa yaa-pulu nipumi su kamaa piri enaali raayona pupitagi ne kone koe raayo mea rubaalia. ");
INSERT INTO kjs_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Go ali madaare abalade neme gu-rupa lisuade: Naa koau-nane ali meda epalia pare nipuri ni namadisa rabu nipu abala pirisa-pulu nipu adaalepe pia. ");
INSERT INTO kjs_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neme abalade nipu na-adisua pare Juda enaalinumi nipu adenalo kalu-ipa mula ipisuade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon agale gu-rupa lakalisa: Neme abala Holi Spirit yaa biyaa ipuma Yesuna kaluna epa pirisa rabu adisua. ");
INSERT INTO kjs_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Go raburi niri Yesu yapae lo waru namakuaasua pare Gote-me ni gu-rupa lagisa: Holi Spirit yaa biyaa ipuma ali meda madaa epa piraliade alimiri Holi Spirit-na kalu-ipa meala epalia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon-me wala talo: Neme ora adawa pare nipu Gote-na Si kama yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ekera-nane Jon nipuna disaipel ali laapo raapu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Go rabu Yesu pamualaina adoma nipumi talo: Nipu adalepa. Go aliri Gote-na sipsip mena si yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mo disaipel ali laapome go agale pagoma Yesu raita maa pisipi. ");
INSERT INTO kjs_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Raita maa pisipi rabu Yesumi pereke luma nipu adisa-pulu agale gu-rupa misa: Gore nipiri ali asapipi? Nipu laapome talo: Rabai, nere aapina ada-para pili? Go bi Rapaaina re-re tisaa leme. ");
INSERT INTO kjs_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Go rabu nipumi talo: Epa adalepa. Go lisa-pulu nipu raapu puma nipu piri ada-para puma pirisimi. Go yapi raayo nipu raapu pirisimi. Ada-para pirina naare nogo-nane pabola popesa. ");
INSERT INTO kjs_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gore ali laapome Yesuna agale pagisipi go ali medare Yesu raapu pisipi. Go alina biri Andru nipu Saimon Pita-na ame pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Go rabu Andru-mi ame Saimon adasaaoma agale gu-rupa lakalisa: Naame Mea Rapaae Ali abala adama lisa. Mea Rapaae bina re gu-rupa Mesaia Keriso leme. ");
INSERT INTO kjs_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Go rabu Andru-mi ame Yesu piri-para mea ipisa. Yesumi go ame adoma talo: Nere Jon-na si Saimon yapare werepere nena bi Sifas leme lisa. Go bi perekeaere Pita lemena pare go bina re-re kana yaade. ");
INSERT INTO kjs_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ekera-nane Yesu nipu Galili su-para pulalo pisa-pulu nipumi Filip adasaaoma talo: Saana bana lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nipu madisa suri Betsaida. Go adare-re Andru Pita laapona adare-para pirisipi. ");
INSERT INTO kjs_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Gore Filip-mi Nataniel asa pumare gu-rupa lakalisa: Moses-me abalade rekena agale madaa remaa lisade aliri naame abala adasaarima. Gote-na agale lakale alinumi page go ali epalia lo pepa madaa lu wisimide. Go aliri Nasaret su-para piri Josep-na si yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Go lisa-pulu Nataniel-me agale gu-rupa lorapisa: Gore epe elenuri Nasaret su-para mada epena ya? Filip-mi agale go-rupa lisa: Adola bana lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gore Yesumi Nataniel nipu piri ipisa rabu nipu agale gu-rupa lakalisa: Go aliri nipu ora Israel ali meda yaade. Nipumi makirae agale nale ali yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Go rabu Nataniel-me nipu-para agale gu-rupa misa: Niri aa-rabo makuaaripi ya? Gore Yesumi talo: Abalade Filip nipi repena fik re-para piralaina adawade. ");
INSERT INTO kjs_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Go lisa rabu Nataniel-me talo: Tisaa, ne ora Gote-na Si yaade. Ne ora Israel enaalina Mudu Ali pili lisa. ");
INSERT INTO kjs_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Go lisa rabu Yesumi talo: Neme nere mo repena fik re-para pirae lawade-le go madaa kone rulaaripi ya? Werepe adali elena purimi go abi adae elenu ma-oge yaalia lisa. Werepe ele medalomame nina puri waru mea waatea. ");
INSERT INTO kjs_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesumi nimu-para talo: Neme ora ria lagialo. Werepe yaa-para pora lobenaloma Gote-na ensel-nu ni nipuna enaalinu Raapu Pirape Alina Si madaa epala puala palia-daa adalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Wala yapi laapo dialenaloma ali medame Galili su ru-nane piruma Kena adare-para ena rumaasa. Nipumi ena rumaasa-pulu Yesuna agi-para nipuna disaipel alinu-para yalaasimi rabu adola ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nimumi yawe eda abala noma werepere wain ipa dia lisa rabu Yesuna agimi nipu-para talo: Nimuna ipa wain dia yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Gore Yesumi talo: Go ena, nina kogono ali neme agale meda abi nakalape. Naa kogono pape yapi di-ri abi na-epea. ");
INSERT INTO kjs_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Go pisa rabu Yesuna agimi disaipel alinu gu-rupa lakalisa: Nipumi gu-rupa palepape teare nimimi go-rupa ora palepape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Go ada kaname warili ipa pe ki medane luma ki medana egali wisa. Go kana pe komeare wabola piralade pe dila wisa. Juda alinu nimuna rekena kone wisimi-pulu ade abuna nimuna waswas tyape ipa pe mea wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesumi nipuna disaipel alinu-para talo: Mogo kana pe madaa ipa nalepa lisa. Go lisa-pulu nimumi no rubiaoma palala puma wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Go rabu Yesumi nimu-para talo: Abi go ipa meda noria puma mo eda surube ali puama katapa. Nimu mo ipa maa puma kalisimi rabu mo alimi mo ipa rede pea paleme mea nadesa. Go elere abalade pa ipa pirisa pare abi ipa wain-le go eda surube alimi ipa ali-para meape loma namakuaasimi. Yapare ipa no pabe kogono alinu nimumi adisimi. Go pea-pulu mo eda surube alimi mo ena lamulalo pi ali-para lakeloma ipu lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Go rabu nipumi talo: Ali medalomame epe ipa wain abala rumaainaloma enaalinumi adaapu nenalomare wala werepe koe wain rumaasimi. Go peme pare neme epe wain werepe mea rumaaripina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Go puri pale kogonore Yesumi Galili su robo ru-nane aaya Kena adare-para abala ripia pisa. Go adare-parare Yesumi nipuna epe paana puri walenaloma nipuna disaipel alinumi nipu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Go pumare Yesu-para nipuna agi-para amenu-para disaipel alinu-para mo Kaperneam adare-para puma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gore Juda alinuna Pasova eda ne adaa yapi di rudu lisa-pulu Yesu Jerusalem su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lotu ada ru-nanere alinumi maket puma gawa sipsip yaa madaa yoto mealaina Yesumi adisa. Go puma kana sens pape alinu reke madaa pirina adisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesumi kope muma waruma mo mena-para mena puni alinu-para lotu ada kamaa-nane ralu lisa. Go page mo kana misimi alinuna rapuluma musaaoma kana lakepe rubebe pisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Go rabu mo yaa madaa yoto mealae alinu-para Yesumi talo: Go yaanu kamaa maa pulupa. Naa Aapana lotu ada namabebolalepa. Dia nimina stua ada-rupa nama-aulapape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Go lisa rabu nipuna disaipel alinumi Gote-na agale wi buk madaa kone wala rulasimi. Mo buk madaa agale gu-rupa wisa: Gote, nena lotu ada madaare neme kone mapiraae-pulu nina lo robaa ora rekoaaya. ");
INSERT INTO kjs_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Go rabu Juda alinu Yesu agaa gu-rupa misimi: Naame nena puri waru adamono ake pi kogono pali-daa adalima pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesumi nimu agale gu-rupa lakalisa: Nimi go Gote-na ada kilipialimi rabu neme yapi repena ru-para wala wariabalua. ");
INSERT INTO kjs_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Go lisa rabu nimumi pogolasaoma Yesu-para agale wala gu-rupa lakalisimi. Neme go ada yapi repena ru-para mada wariali ya? Go lotu ada warisima di-ri maali 46-pela ru-para warisima lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yapare Yesumi lotu ada warialua agale lakalisa rabu nipuna to yogale go-rupa palia lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gore werepe Gote-me Yesu tapa madaa marekaainaloma nipuna disaipel alinumi mo lisade agale wala makuaasimi. Go rabu nimumi Yesuna agale-para Gote-na buk madaa wi agale-para kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","So Jerusalem su-para Pasova eda ne adaa yapi di wisimi rabu Yesu page pisa. Go rabu Yesumi napi kogono pisa-pulu enaali adaapumi nipu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pare Yesumi enaali raayona kone adisa-pulu pa enaalinu raapu piruapena kone narulasa. ");
INSERT INTO kjs_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nipumi enaali raayona lo robaa-para ado kone misa-pulu pa enaali medame nipu kone makuaae meda nalakelesimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisi ruruna ali medana biri Nikodemus laminyare nipu Juda alinuna ali mudu pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Go alimi koro meda ribaa Yesu piri-para ipuma gu-rupa lisa: Tisaa, nere Gote-na agale mogeainalo mea rapasa. Go konere naame makuaaema pare Gote ne raapu pia-pulu neme napi kogono epe-rupa pe lisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesumi saa pi agale gu-rupa lisa: Neme ne ora lagialo. Ali medame agina lo robaa-para wala napiralia-daare Gote-na Surube Su mada na-adalia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Go rabu Nikodemus-me talo: Akea puma ali meda lo robaa-para wala mea matia ya? Ali meda agina lo robaa-para wala piralia rabu rana laapo mada namaitia. ");
INSERT INTO kjs_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Go lisa rabu Yesumi talo: Neme ora lagialo. Ali medamere nipu ipa-para Holi Spirit-para namuma piraliare Gote-na Surube Su mada na-adalia. ");
INSERT INTO kjs_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Enaalina yogaleme madi enaaliri yogale pa wia. Go page Holi Spirit-mi madina enaaliri Holi Spirit raapu pia. ");
INSERT INTO kjs_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Go pea pare ne kagaa opainalo remaa lagiawade-le kone adaapu nasape. ");
INSERT INTO kjs_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Po rilipu nipuri aa-para popea palo madaa na-ade. Naame nipuna kete-daa pagema raburi aa-para epelea pe aa-para pea palo naame na-adema. Holi Spirit-mi madina enaalimiri po rilipu-rupa go elena re madaa ademe. ");
INSERT INTO kjs_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Go lisa rabu Nikodemus-mi talo: Go agale madaare ake palia ya? ");
INSERT INTO kjs_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesumi talo: Nere ora Israel enaalinuna profet yaa-pulu neme go agale namakuaate? ");
INSERT INTO kjs_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Neme ne lagialo. Naame agale lema rabu naana ade ele-para page agale lema pare nimi raayome go agale giyaleme. ");
INSERT INTO kjs_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Neme go su kamaa elenuna re lagialo rabu kone narulaeme. Go pea-pulu werepe yaa madaa elenuna re lagialua rabu page kone ora narulalimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gore pa enaali meda yaa-para abi napeme. Enaalinu Raapu Pirape Alina Siri ni komea yaa-para piruma su kamaa ipisuade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Abaladere Moses-me enaali napiri su-para puma repena kuni madaa kero rogaaoma minasaasa. Go yapare werepe nimumi enaalinu Raapu Pirape Alina Si mea luma pitaalimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Go pea-pulu enaali raayome ni madaa kone rulalimiri go enaali raayo ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gore Gote-me su kamaa piri enaali raayo madaa ranaame komisa-pulu ora nipuna Si komea mea rapasa. Go pea-le enaali raayome ni madaa kone mapiraalimiri nimu ora nakomalimi pare ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Go pea-pulu Gote-me ni nipuna Si su kamaa kose agale pagenalo namuma rapasa. Dia, pare enaali epe pora mea walenalo mea rapasa. ");
INSERT INTO kjs_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Enaali raayome ni madaa kone rulalimiri nipu kose agale natea. Yapare enaali medalomame ni madaa kone narulalimiri nimu kose madaa abala popalimi. Go enaalinuri ni Gote-na Si komea madaa kone narulaeme-pulu kose madaa koe kedaa mulalo pimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Go kose lena re-re gu-rupa: Epe paa go su kamaa abala ipisa pare enaalinumi koae-aunu pu pimi. Nimumi go epe paa giyoma ribaa madaa raana komoma pimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Go koeyae peme enaalinuri epe paame nimuna koe elenu penaame waatea lo go paa koau-nane mea roto lu ruboma pimi. Go puma nimu epe paa roaaya-para na-epeme. ");
INSERT INTO kjs_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Go pea pare ipuma peme enaalinuri Gote-na agale pago pimi-pulu paa-para peme epe kogono walenalo epeme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Werepe Yesu nipuna disaipel alinu raapu Judia su robona ru-nane pirisimi. Go su-parare Yesu nimu raapu piruma kalu-ipa kalisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Go rabu Jon-me Ainon su-para ipa adaapu popesa-pulu kalu-ipa go-para puma kalisa. Haran suri Salim su re-para aasa. Enaalinu nipu pirisa-para epenaloma kalu-ipa kalisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Go raburi Herot-me Jon karapo ada abi namapaitasa. ");
INSERT INTO kjs_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Go rabu Jon-na disaipel ali medalomame Juda ali meda-para ipame radepele rekena agale madaa ape lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ape lisimi rabu nimu Jon piri ipuma talo: Tisaa, ali meda abalade ne raapu ipa Jordan-na mone pane pisipide kone makuaate? Go ali madaa agale abala lagisi. Go aliri abi kalu-ipa kale ali yaa-pulu enaali raayo nipu piri-para puma kalu-ipa meme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Go rabu Jon-me talo: Gote-me enaalinu ele nakateare nimumi mada namealimi. ");
INSERT INTO kjs_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nimimi nina agale abala pagisimi rabu neme agale gu-rupa lisuade: Niri ora Gote-na Mea Rapaae Ali-daa dia yapare Gote-me ni abala mea epenalisade. ");
INSERT INTO kjs_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ali medame nipuna ena rumaalalo paliare go ena ora nipuna were piralia. Go rabu go alina adami alinumi pago piralimi. Go adami alimi ena rumaalalo alina agale pagalia rabu raaname komalia. Go konere nina raaname komape kone go-rupa ora epelea. ");
INSERT INTO kjs_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gore Yesuna biri ora sone minasalimina pare nina biri su kamaa pa rabuaniaalimina. ");
INSERT INTO kjs_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","So yaa-para piru aaya epe aliri naa raayona ali mudu pia. Su kamaa madina enare ora su kamaa enaali yaa-pulu su kamaa agale madaa lakeleme. Go pea pare so yaa-para piruma none epe wi aliri ele raayona ali mudu pia. ");
INSERT INTO kjs_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nipumi adoma pagea ele madaa agale lakelea pare enaalinumi nipuna agale madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Go pea pare enaali raayome nipuna agale madaa kone rulaeme-pulu Gote-re ora agale le ali yaade. ");
INSERT INTO kjs_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gote-me epenalisa aliri Gote-na Holi Spirit lo robaa-para marubotabaaya-pulu go alimiri Gote-na agale lakelea. ");
INSERT INTO kjs_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gore Aapame nipuna naaki madaa ranaame komoma nipuna puri kalenaloma ele raayo surubea. ");
INSERT INTO kjs_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Go pea-pulu enaali raayome Gote-na Si madaa kone rulalimi-daare ade abuna kagaa piramala palimi. Yapare enaali raayome Gote-na Sina agale yokalimiri ade abuna napiralimi. Dia, pare Gote-na rono page konere go enaalinumi ade abuna mealimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi alinumiri Yesumi nipuna disaipel enaali adaapu muma kalu-ipa katalo pagisimi. Go pisa-pulu Yesuna disaipel enaalinumiri Jon-na disaipel enaali ma-oge yaasa-daa pagisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yapare Yesumi kalu-ipa nakalisa pare nipuna disaipel alinumi kama kalu-ipa kalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesumi go agale pagoma Judia su giyoma Galili su-para wala pisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gore Judia su giyoma Galili su puaoma pumare Samaria su-para puma opopasa. ");
INSERT INTO kjs_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mo Samaria suna adarena bi medare Sikar lisimi. Go adare-re abalade Jekop-me nipuna si Josep rumaaoma kalisade su maapuri go adare-para aasa. ");
INSERT INTO kjs_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Go su-parare abalade Jekop-me ipa nape naaku awesade. Yesu nipu pora puma paalame komisa-pulu mo ipa naaku re-para puma pomo mu pirisa. Go puma pirisa naare lere ki lapo pegepuma ki medane lapo rabu pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Go rabu Samaria ena meda ipa nola ipisa rabu Yesumi nipu-para talo: Ipa meda no gi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Go raburi nipuna disaipel alinuri abala mo adare-para eda kabolalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Go lisa rabu Samaria ename Yesu-para talo: Nere Juda ali yapare niri Samaria ena yaa-pulu ake pea-daa ni-para ipa nano gi lae ya? Gore Juda alinuri Samaria enaali raapu eda meda-para nanisimide. ");
INSERT INTO kjs_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nipumi mo ena-para agale gu-rupa lakalisa: Neme Gote-me pa giape ele makuaaoma go ipa nano gi lea alina bi pagola pae-daare gore ni agaa mula pe yaalore ora ipa yokea-rupa epe agale mada lagula pawa. ");
INSERT INTO kjs_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mo ename talo: Mudu Ali-ya, nena ipa nape pe nasana. Go ipa naaku ora no-para pia-le go epe ipa yokea-rupa aa-para meali ya? ");
INSERT INTO kjs_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naana kasua Jekop-me go ipa nape naaku waru gisa. Gore nipumi page sinumi page mena gawa sipsip-numi page go ipa no aema. Go pea-le nere Jekop rabuanaaoma pi ya? ");
INSERT INTO kjs_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu nipumi talo: Enaali raayome go ipa nalimi-daare werepe nimuna pedo kaapu yaalia rabu wala nolalo epalimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yapare enaalimi nina gulalo pi ipa nalimi-daare ora mada teme. Naa ipare enaalina lo robaa-para ipa yokea-rupa mapiraalua-pulu pa ipa meda nane. Go ipame ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Go lisa-pulu ename talo: Mudu Ali, go laede ipa giaina ni werepe go ipa naaku-para wala nanola epalua. ");
INSERT INTO kjs_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Go lisa rabu Yesumi nipu-para talo: Nena aali abala puma yaaloma one ipulupape. ");
INSERT INTO kjs_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ename talo: Ni ali meda napia lisa. Yesumi talo: Nena aali napia lalere gore ora lale. ");
INSERT INTO kjs_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nere ali supu piside pare go abi ne raapu pipi aliri ora nena aali-daa dia. Go nena agalere ora lale. ");
INSERT INTO kjs_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Go lisa rabu ename talo: Mudu Ali-ya, abi neme nere adalo pare ne Gote-na agale lakale ali yaana. ");
INSERT INTO kjs_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naana Samaria kasuanumi go rudu madaa rumuma kiritaoma Gote-na bi minasaasimi. Go pirisimi pare nimi Juda alinumiri no Jerusalem su-para Gote-na bi minasalimina leme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesumi nipu-para talo: Ena, naa agale waru paga. Werepe epaliade yapi di rabu enaalinumi go rudu madaa page Jerusalem su-para page Gote-na bi naminaasalimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nimi Samaria enaalinuri nimi kone nasuma bi minasaaeme pare naa Juda enaalinumiri bi makuaaoma minasaaema. Ade abuna pirape konere Juda alinumi mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pare abi page werepe epaliade yapi di rabu page enaalinumi Aapana bi kama epe-rupa minasaalimi. Nipuna bi epe-rupa minasaaeme enaalinuri Aapame raaname komea. ");
INSERT INTO kjs_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gote-re nipu ora Holi Spirit pia-pulu enaalinumi nipuna bi minaasaalimi-daare nimuna kone wasaapuni-para ora agaleme lotu loma bi minasalimina. ");
INSERT INTO kjs_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Go rabu ename Yesu-para talo: Gote-na Mea Rapaae Ali nipuna bi meda Keriso-re nipu epalia lisimi-daa makuaato lisa. Go ali epalia rabu naa ele raayona re lagialia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesumi talo: Go aliri ni yaade. Abi ne raapu agale go tapa-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Go lalaina Yesuna disaipel alinu ipuma Yesu pa ena meda raapu agale lakelala aaya-le kone adaapu wisimi. Pare disaipel alinumi paala komoma nalakelesimi: Neme ake puma go ena rakelae nalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Go rabu go ename nipuna ipa pe giyoma mo adare-para puma enaalinu-para gu-rupa pua lakalisa: ");
INSERT INTO kjs_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Go ali meda epa adalepa. Nipumi nina pisuade-alenu raayo epa lagiala-pulu nipu Gote-me Mea Rapaae Ali yapae lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Go lisa rabu nimu su adare giyoma Yesu piri-para adola ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Go ipisimi raburi mo disaipel alinumi nipu-para talo: Tisaa, ne eda na lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pare Yesu nipumi talo: Naa eda medaloma wina nimimi na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Go lisa-pulu disaipel alinumi nimuna lala piruma gu-rupa lisimi: Ali medame nipuna eda epa kalame ya? ");
INSERT INTO kjs_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesumi nimu-para talo: Nipumi ni maa epenalisadere nipuna agale pagoma kogono pu kiritaayo. Go kogonore nina eda yaade. ");
INSERT INTO kjs_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nimina saa pi agale gu-rupa leme: Suba 12-pela pirumare eda nape awalimi. Naa saa pi agale pagalepa. Mo maapu-para adalepape. Mo maapu-para nape eda adaapu elea-le ralalimina. ");
INSERT INTO kjs_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maapuna eda kiritape aliri yoto abala mea-pulu edamere ade abuna kagaa piramala mapuaalia. Go pea-pulu eda poale enaali-para eda aawae enaali-para nimu raapu raaname komalimina. ");
INSERT INTO kjs_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Saa agale meda gu-rupa leme: Ali komeame maapu-para eda wai poaaya pare ali medame eda awoma nalia leme. ");
INSERT INTO kjs_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Apo saa pi agalena re gu-rupa lisa: Nimi go maapu-para e napoaeme pare aawalimina. Enaali medalomame go maapu eda poasimi-pulu nimimi nipuna kogono madaare eda mealimina. ");
INSERT INTO kjs_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gore mo adare-para Samaria enaali adaapumi mo enana agale pagisimi-pulu Yesuna agale madaa kone rulasimi. Mo ename abala gu-rupa lisa: Naa abalade pisuade koe ele raayo lagiaa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gore Samaria enaalinumi Yesu piri-para ipuma talo: Naana adare-para pa piramina. Go lisimi rabu Yesu nipu yapi laapome go su-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesumi epe agale lakalisa-pulu enaali adaapumi nipu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Go pirisimi rabu mo ena-para gu-rupa lakalisimi: Abi kone rulalema pare nena agale kama-daa komea madaa kone narulatema. Dia, pare nipuna agale pagemade-pulu enaali raayona Raba Meape Ali yaanaloma kone rulaema lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu yapi laapo dialenaloma Galili su-para puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Go puma Yesumi gu-rupa lisa: Gote-na agale lakale aliri nipuna madina su-parare nipuna bi naminasaaeme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Go pea-pulu go su-para giyoma Galili su-para pisa raburi enaalinumi nipuna ki muma raaname komisimi. Abalare nimumi Juda alinuna eda yawo ne adaa yapi di rabu Jerusalem su-para Yesu pisa-daa adisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gore Yesu Kena adare-para wala ipisa. Go adare Galili su ru-nane aaya pare nipumi go su-para kagaa ipa wain abala warisaaya. Go su-parare gavman surube ali meda pirisa. Nipu Kaperneam su-para piri naakiri yaina komisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gore go alimiri Yesu Judia su giyoma Galili epaade remaa pagisa-pulu Yesu piri ipisa. Pisa rabu nipuna naaki le kadupitalo pisa-pulu Yesu Kaperneam su-para ipuma nipuna naakina yaina ma-epeaanalo lorapisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesumi nipu-para talo: Nimumi napi kogono rado rado na-adalimi-daare ni madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bosboi-mi Yesu-para talo: Mudu Ali, nina naaki abala le kadupia-le wagepu bana lisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesumi nipu-para talo: Ne pu, nena naakiri abala rekoma pia lisa. Go lisa rabu mo alimi Yesuna agale madaa kone rulaoma ada pisa. ");
INSERT INTO kjs_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nipu pora-nane pulaina nipuna kogono naakinumi pora madoma talo: Nena naakiri abala rekoma pa pia lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Go lisimi raburi nipumi nimu agale gu-rupa misa: Aa-rabu yaina diaaya pae? Nimumi talo: Abala alebo bero raburi diaayoma nipuna riripu dia yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Go lisimi raburi mo naakina aaraame ora go rabu Yesumi nena naaki pa pia lakelaa-daa makuaasa. Go agale makuaaya-pulu go alimi page nipuna ena nogo naakinu page Yesu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesumi Judia su giyoma Galili su-para pisa rabu napi kogonore nipumi rana laapo pisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gore apo napi kogono dia lisa raburi werepere Juda alinuna eda nape olode yapi di rudu lisa rabu Yesu Jerusalem su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","So Jerusalem su-para adarena pape rikirana pora gaape meda wisa. Go pora gaapena biri sipsip menana pora gaape lisimi. Go pora gaapena re-parare oge ipa le meda wisa. Go ipa lena pagi-parare pokaalo ada supu aasa. Juda alinuna adaa agale madaare go ipa le biri Betesda leme. ");
INSERT INTO kjs_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Go pokaalo ada ru-nanere yaina kome enaali adaapu epa pirisimi. Nimuna yainare le rubu pi enaalinu page age koe enaalinu page pora napami enaalinu page epa pirisimi. Nimu mo ipame etoto pia-rupa adolalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Go puma Gote-na ensel medame no ipa le-para puma kodobaoma mo ipa ma-lewa lewa mapaasa. Go palia rabu ali medame abala no lewa piade ipa le-para kodobaliare nipuna yaina dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gore ali meda mo pokaalo ada-para nipu yaina pa winare maali 38-pela palisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesumi mo alina yaina maali adaapu palisa adisa-pulu nipu-para talo: Nena konemere yaina maperekealua kone wi? ");
INSERT INTO kjs_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yaina kome alimi talo: Mudu Ali, mogo ipame lewa palaina ni no ipa-para makodobape aliri meda dia ya. Naa ipa-para kodobatalo pe rabu pa ali meda abala ipa-para puma kodobaaya lisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesumi nipu-para talo: Ne rekoma nena yapara mea ruma pora pamua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Go lisa rabu mo alina yaina wagepu pua nipu rekomo yapara mua pora pamisa. Mo alina yaina epeaasa raburi Pomo mu Pirape Yapi di ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Go raburi Juda alinumi mo marekaaripa ali-para talo: Abiri Pomo mu Pirape Yapi di yaade. Nena yapara rili kogonore naana rekena agale rugulaede lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Go alimi talo: Mo nina yaina maperekeae alimi ni-para talo: Nena yapara mea ruma pora pamua laade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Go lisa rabu nimumi nipu-para talo: Gore nena yapara mea ruma pora pamua lore aapimi lagiaa ya? ");
INSERT INTO kjs_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Go lisimi pare yaina maperekeae alimi Yesu leme waru na-adisa. Go pokaalo ada ru-nane enaali adaapu abala pisimi-pulu Yesu pisa rabu mo alimi waru na-adisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Werepe Yesumi mo ali Juda alinuna lotu ada-para adisa. Go raburi Yesumi talo: Paga, abi nena yogalere epe-rupa aaya. Go pea-le ora adaa keda meda ne mada epalia-le nena pupitagi ne kone giyape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Go rabu mo Juda ali piri-para puma Yesumi ni marekaaripa lo remaa puma lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Go lisa rabu Yesumi Pomo mu Pirape Yapi di madaa go ali maperekeasa rabu Juda alinumi koeyae puma Yesu kedaa kalalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Go pisa-daa Yesumi nimu lakalisa: Naa Aapame ade abuna kogono pala pia-le neme page go pora raluma pe. ");
INSERT INTO kjs_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Go lisa rabu Juda alinumi nipu ora tima kone wisimi. Nimuna konere Yesumi Pomo mu Pirape Yapi di korona rekena agale yokesa. Go page Yesumi Gote-re nina Aapa lisa-pulu nipuri Gote pia-daa Juda alinumi lu makomaatalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Go kone wisimi rabu Yesumi nimu-para talo: Gore neme ora lagialo. Naa kogono pa kamaa nape. Ni Aapana Si ora ria yaalo Aapana kogono pe. Naa Aapame kogono pea-rupa adoma pe. Aapame pea-rupa adoma moge aayo. ");
INSERT INTO kjs_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Go pea-le nina Aapame ni nipuna naaki madaa ranaame komoma nipuna pape kogono ni waalea. ");
INSERT INTO kjs_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Go pea-pulu Aapame kome enaali marekaaoma ade abuna mapiraalia-rupa go kone mogeaoma nina kone suma enaalinu ade abuna kagaa piramala mapualua. ");
INSERT INTO kjs_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Go page Aapame kose lape agale enaali madaa natea pare ni nipuna naaki go puri gisa-daa neme palua. ");
INSERT INTO kjs_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Go palua-pulu enaalinumi Aapana bi minasaaeme-rupa nina bi page minasaalimina. Yapare enaalinumi nina bi naminasaalimiri ni mea rapasa Aapana bi page naminasaaeme. ");
INSERT INTO kjs_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Neme ora lagialo: Enaali raayome nina agale pagoma ni mea epenalisa Aapa madaa kone rulalimiri ade abuna kagaa piramala palimi. Go enaali madaare kose lape agale natoa pare nimu komape kone abala giyoma ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neme ora lagialo lisa: Abi go yapi di rabu page werepe epaliade di rabu page kome enaalinumi Gote-na Sina agale pagalimi. Pagalimi-pulu ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gore Aapare ade abuna kagaa pirape konena re pia-pulu nipumi nipuna naaki ni page go mapiraape re gisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Niri enaalinu Raapu Pirape Alina Si yaa-pulu Aapame ni kose lape agalena puri gisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Go agale madaare kone adaapu nasalepape. Gore yapi di meda epalia rabu tapa-para rogaae enaalinumi nimu yaatea rabu pagalimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pagalimi-pulu nimu tapa su giyoma kamaa epalimi. Go pea-le enaali medaloma epe-rupa palimi-nuri marekaaoma ade abuna kagaa piramala mapuaalia. Pare enaali medalomame koeyae palimiri marekaaoma kose lape agale loma koe kedaa katoa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Go elere neme kama raapu napalua pare Gote-me lagialia kose lape agale toa. Go pea-le nina kone kama namogele pare ni mea rapasa Aapana kone rale. Go pea-pulu nina kose lape agalere ora redepo le yaade. ");
INSERT INTO kjs_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pare neme nina agale lagere makirae agale le kone saleme. ");
INSERT INTO kjs_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yapare ali medame ni madaa agale lakelea rabu ora lea kone salimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gore nimimi Jon piri ali medaloma agale mea rapaainalo penaalisimi rabu nipu ora agale madaa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gore neme enaali medana agale madaa kone namapiraayo pare Gote-me enaali raba minalo go agale nimi lagialo. ");
INSERT INTO kjs_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon-re epe paata nona pi ipuma nipuna roasa paa enaalinu kalisa-pulu nimi Juda alinumi nipuna paa adoma ranaa komo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon-me ni madaa puri pale agale lakalisa pare nina Aapame gisa kogono pe rabu Jon-na agale ma-oge yaato. Go kogono palua rabu Aapame ni mea epenalisa-daa madaa adamina. ");
INSERT INTO kjs_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Gore Aapame ni mea rapaasa-daa neme lagula ipisua. Nimimi nipuna agale napagoma nipuna le agaa na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nipumi ni mea rapaoma nipuna agale lo robaa-para nasalimi-pulu ni madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nimumi ade abuna kagaa piramala pulalo kone nimi-le Gote-na buk yarepeleme. ");
INSERT INTO kjs_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Go peme pare nimi ni piri ade abuna kagaa pirape kone-daa namula epeme. ");
INSERT INTO kjs_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Niri enaalinu pedo puma agale pagoma raana komenalo nale. ");
INSERT INTO kjs_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Go pea pare nimina kone ade. Nimina lo robaa-para Gote madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ni ipisuade rabu Aapame mea rapaoma puri gisa pare nimimi ni ora giyeme. Go pea pare ali meda nipuna puri mea epalia-daare nimimi nipu madaa epe kone suma mealimi. ");
INSERT INTO kjs_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nimina konere pa pedo pedo pala pimi. Yapare Gote-na pedo pi agalere kone nasalimi-pulu ake pea-daa kone rulalimi ya? ");
INSERT INTO kjs_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pare nimina kose lape agale Aapa laketoa kone nasalepape. Dia, nimimi Moses madaa kone rulasimi-pulu nipumi nimi kose lape agale madaa lea. ");
INSERT INTO kjs_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pare nimimi Moses-na agale madaa kone waru rulasimi-daare Moses-me ni madaa pepa lisa-le ni madaa page kone mada rulasimina. ");
INSERT INTO kjs_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pare nipuna lisade agale madaa kone narulaeme-pulu nina agale madaa page kone mada narulalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Go agale lakeloma Yesu nipu Galili ipa le mone pane wala pisa. Go ipa lena bi medare ipa Taiberias leme. ");
INSERT INTO kjs_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Go raburi enaali adaapumi Yesuna puri pale kogonome yaina kome enaali marekaasa-daa adisimi-pulu nimumi nipu raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Go rabu Yesu-para nipuna disaipel alinu-para nimu rudu meda rumuma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Go rabu Juda enaalinuna Pasova eda ne adaa yapi di rudu lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Go rabu Yesumi enaali adaapu nipu piri epenalo adisa-pulu nipumi Filip-para talo: Gore mo enaali adaapu epa pimi-le nimuna nape edare aa-para kabalima ya lisa? ");
INSERT INTO kjs_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nipumi Filip-na kone adolalo go agale lisa pare Yesu nipuna pape kone abala makuaasa. ");
INSERT INTO kjs_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Go agale lisa rabu Filip-mi talo: Go enaali raayome eda ogepusi nalimi lisa. Naame bret kabape kana ora adaapu rubuma kabalima lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gore Saimon Pita-na ame Andru-mi talo: ");
INSERT INTO kjs_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Naaki ogeasi meda go pia-le nipuna bret supu-para wena laapo-para saapia. Go pea pare go enaali adaapu pimi-pulu mada nanalima lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesumi nipuna disaipel alinu-para talo: Go enaalinu mapiraalepa lisa. Go suna rilipu adaapupe aasa. Go rilipu aasa-para enaali raayo pirisimi. Go puma nimu 5000-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Go rabu Yesumi bret muma Gote-para ora pili loma rilipu madaa piri enaalinu wena maa rumaasa. Mo wena oge-ai laapo piribinaloma enaalinumi mo eda raapu nisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eda noma purupi rubisimi rabu Yesumi nipuna disaipel alinu-para talo: Nimimi eda purapina nu raayore makiritaalepa. Medaloma narubalimina dia. ");
INSERT INTO kjs_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Go lisa-pulu bret supuna purupina basket 12-pela madu wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Enaalinumiri Yesuna napi kogono adisimi-pulu gu-rupa lisimi: Go aliri Gote-na agale lakale ali su kamaa epa yaade ali lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Go lisimi rabu mo enaalinumi Yesu nipu ali mudu mapiraalalo pisimi. Pare Yesumi go kone adisa-pulu nipu wala so rudu madaa kama puma pisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ora alebo raburi nipuna disaipel alinu mo ipa le mone pane Kaperneam su-para polalo ipinu madaa piruma pirisimi. Go puma ribaa yabaasa pare Yesu nimu piri-para abi napisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Go raburi po rilipu adaapu ipuma ipa le madaare erepea erepea laari ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gore mo disaipel alinumi ipinu madaa piruma ipa oge-daa adaalu-para modo kepaame ade eleme ipa apeama pisimi. Gu-rupa polalo pisimi rabu Yesu ipa koauna pamisa-daa nimumi nipu adoma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Go rabu Yesumi nimu-para talo: Nimimi paala nakomalepape. Gore ni yaade. ");
INSERT INTO kjs_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Go lisa rabu nimumi nipu ipinu madaa epa pirina kone wisimi. Go puma go ipinu pulalo pisimide su-para wagepu maa pisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ekera-nanere ipa le mone pane pirisimi enaalinumi ipinu komea abala ena adisimi. Gore Yesu nipuna disaipel alinu raapu ipinu madaa napirina disaipel alinu nimuna pisimi-daa enaalinumi makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Go pea pare ipinu medaloma Taberias su giyoma ipa le pagi-nane wisa. Go ipa pagi-nanere Yesumi abala-rupa bret madaa ora pili loma rumaainaloma enaalinu adaapu nisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gore enaalinumi Yesu-para nipuna disaipel alinu-para nimu raapu napirina adisimi. Go-rupa puma nimimi mo Taiberias su polalo pi ipinu madaa piruma Kaperneam su-para Yesu asa polalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gore enaalinumi Yesu ipa le mone pane puma adomare agale gu-rupa misimi: Tisaa, go-parare aa-rabo epae ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesumi talo: Neme nimi ora lagialo. Neme napi kogono pawade rabu nimimi ni asa pulalo epame ya? Dia, pare nimimi bret abala noma robaa rubitaba-daa nimimi ni asa pulalo epamena. ");
INSERT INTO kjs_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Go edare ramuaalia-le nimimi go eda madaa kogono napipape. Dia, pare ade abuna noma kagaa pirape eda madaa kogono palepape. Eda go-rupare ni enaalinu Raapu Pirape Alina Si yaade pare Gote nina Aapame ni madaa pedo puma mea rapasa-pulu neme go eda gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Go rabu nimumi nipu-para agale gu-rupa misimi: Naame ake pua Gote-na kogono madaa palima ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesumi agale gu-rupa abulisa: Gote-na kogonore gu-rupa wia lisa: Niri nipumi mea epenalisa-le ni madaa kone rulaalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nimumi talo: Naame na-adema ele meda mada pali ya lisimi? Gore ali kogono pali ya? Naame nena napi kogono adalima-daa ne madaa kone rulalima. ");
INSERT INTO kjs_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Naana kasuanumi enaali napiri su-para eda nisimi. Go madaare Gote-na buk madaa agale gu-rupa wia lisimi: Nipumi yaa-para wisade bret eda kalisa-pulu nisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesumi wala talo: Neme nimi ora lagialo. Moses-na bret nisimidere ora yaa-para wi bret-daa dia lisa. Dia, nina Aapame ora yaa-para sade wi bret go aaya. ");
INSERT INTO kjs_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Naa Aapame go aaya bret-re neme yaa madaa giyoma su kamaa ipuma nimi enaalinu ade abuna mapiraape kone raapu gialua. ");
INSERT INTO kjs_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nimumi nipu-para gu-rupa lisimi: Adaa Ali, go ade abuna kagaa mapiraape bret naa ora giape lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesumi nimu-para talo: Niri ade abuna kagaa piruae bret yaade. Enaali raayo ni piri-para epalimiri ade abuna reaeme nakomalimi. Enaali raayome ni madaa kone rulalimiri nimuna lo robaa-para ipa mada roalia. ");
INSERT INTO kjs_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gore nimi abala lagiawade. Nimimi ni ali ademe pare kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naa Aapame enaali raayo ni gea-pulu ni piri-para epalimi. Go puma enaali ni piri-para epalimiri nagiyalua. ");
INSERT INTO kjs_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Naa Aapame ni su kamaa mea epenalisare nina kogono pinalo namuma epenalisa. Ora dia yapare nipuna gisade kogono palua. ");
INSERT INTO kjs_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nipumi ni kogono Go maa pisa kogono gu-rupa palua. Nipuna giape enaalinuri ora na-alupalimina pare werepe epaliade yapi di rabu nimu raayo tapa-para marekaaoma ade abuna mapiraalua. ");
INSERT INTO kjs_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Naa Aapana kone gu-rupa wia. Enaali raayome niri Aapana Si adomare ni madaa kone rulalimiri ade abuna epe-rupa kagaa piramala palimi. Go pea pare werepe porapo yapi di madaare neme nimu marekaalua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu nipu yaa-para wi bret epawa lisa rabu Juda alinumi mumu agale loma arere lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Go raburi nimumi talo: Go ali Yesuri ora Josep-na si yaade. Naame nipuna agi aaraa laapo page ademade. Gore ake pea-daa yaa-para giyoma ipisua ta? ");
INSERT INTO kjs_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesumi agale gu-rupa abulisa: Nimimi mumu agale nalala piralepape. ");
INSERT INTO kjs_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Enaali meda ni piri-para pa mada na-epalimi. Dia, Aapame enaali meda mea epena kone saliare mada epealimi. Go Aapamere ni page epenalisa. Go pea-pulu werepe go yapi epalia raburi neme nimu tapa-para marekaalua. ");
INSERT INTO kjs_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Abala Gote-na agale lakale alinumi buk madaa agale gu-rupa lisimide: Enaali raayore Gote-me nimu mogealalo pea agale gu-rupa lisimide. Enaali raayore nina Aapana agale pagoma nipu kone mapiraalimiri ni piri-para mada epalimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Go agale lagialo pare enaali komeame page Aapa abi na-ademe. Dia, ni Gote raapu piruma ipisuade-pulu neme kama Aapa ade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neme nimi ora lagialo. Enaali raayome ni madaa kone rulalimiri ade abuna epe-rupa kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nemere enaalinu ade abuna kagaa mapiraoma nape bret yaade. ");
INSERT INTO kjs_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nimina kasuanumi yaa-para wi bret eda enaali napiri su-para nisimi pare nimu abala komisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pare yaa-para piruma su kamaa epaawade bret enaalinumi go bret nalimiri nimu nakomalimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","So yaa-para piruma su kamaa epawa bret-re ni yaa-pulu ni ade abuna pirulalo nape bret yaade. Enaalinumi go bret nalimiri ade abuna kagaa piramala palimi. Gore nina yogalere bret ele yaa-pulu neme go yogale enaali nimu gialua-pulu go su kamaa piri enaalinuri ade abuna piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Go lisa-pulu mo Juda alinumi koe arere lo piruma gu-rupa lisimi: Gore ake puma nipuna yogale naame namonolo mada gialia ya lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Go rabu Yesumi nimu-para talo: Neme nimi-para ora pi lagialo. Ni enaalinu Raapu Pirape Alina Si yaa-pulu nimimi nina yogale yaapi laapo namuma nalimiri nimi epe-rupa ade abuna mada napiralimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pare enaali raayome nina yogale mea nalimiri nimu epe-rupa ade abuna yaalo piralimi. Go puma werepe epaliade porapo yapi di rabu neme nimu tapa-para marekaalua. ");
INSERT INTO kjs_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Go lano-le nina yogale-para yapi laapore ora eda ria yaade. ");
INSERT INTO kjs_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Enaali raayome nina yogale-para nina yapi laapo nalimiri nimu ni raapu piralimi ni page nimuna lo robaa-para pitua. ");
INSERT INTO kjs_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Naa ade abuna kagaa pirape Aapame ni mea rapasa. Gore nipuna purimi ni raba minaabala ade abuna piru aayo. Go yapare enaali raayome ni nalimiri nimu ade abuna piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaa-para suma none epe-ae bret-re abalade kasuanumi nisimide bret nona piale dia go bret rado yaade. Kasuanumi nisimi bret-re noma komisimi pare enaali raayome nina bret nalimiri ade abuna kagaa piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Go agalere Yesumi Kaperneam lotu ada-para aoma lapedepelisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gore nipuna disaipel ali medalomame go agale pagoma talo: Go agalere ora kedaa pia. Aapimi go agale pago raitalia ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ali medame Yesu agale nalakalisa pare nipuna disaipel alinumi go agale madaa mumu agale lisimi-daa nipumi nimu-para talo: Go agalemere nimina kone makoyaaoma ni giyalimi ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gore ni enaalinu Raapu Pirape Alina Siri nipuna piruma epe-para wala palia rabu nimimi ake leme ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Holi Spirit-mi ade abuna kagaa pirape kone wasa nipumi gu-rupa aaya-le pa yogaleme naa madaa naraba mealia. Go nimi lagialo agalemere nimi Holi Spirit-para ade abuna kagaa pirape kone-para mealimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pare nimuna rikiranare enaali medalomame kone narulaeme. Gore abala ririna enaali medalomame nipu madaa kone narubitalo pisimi-daa makuaasa. Go page ali medame nipuna koe makirae ali pirisa-daa adisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nipumi agale meda gu-rupa lisa: Gore neme abala lagiawade. Ni madaa kone narulaliare enaali medame nina Aapame naraba mina ni piri-para mada ma-epaalia. ");
INSERT INTO kjs_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Go kedaa pi agale lakalisa-pulu Gote-na disaipel enaali adaapumi Yesu koau walaoma nipu raapu wala napamisimi. ");
INSERT INTO kjs_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Go pisimi-pulu Yesumi nipuna disaipel ali 12-pela go-rupa lakalisa: Gore nimi page ni giyoma palimi ya? ");
INSERT INTO kjs_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Go lisa raburi Saimon Pita-me Yesu-para agale gu-rupa abulisa: Mudu Ali, naare aapi piri pomonalo lae ya? Nena agaleme naa ade abuna kagaa pirape ele guaalia. ");
INSERT INTO kjs_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gore naame abi ne madaa kone rulaarimaade. Nere Gote-me nipuna epe naaki komea epenalisa-daa makuaaema. ");
INSERT INTO kjs_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesumi agale gu-rupa lakalisa: Gore ake lano ya? Neme nimi 12-pela ali mada misuade pare nimina rikirana ali meda nipu ora koe remo medana si pisa. ");
INSERT INTO kjs_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nipumi Judas madaa lakalisa. Judas-re Saimon Iskariot-na si pirisa. Gore Judas-re nipu disaipel ali ru repena rikirana pirisa pare werepe nipumi Yesu linalo yada roboma pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu nipu Galili su robo ru-nane pamisa. Go pisa pare Juda alinumi Yesu lulalo pisimi-pulu Yesu Judia su robo ru-para giyoma napamisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Go rabu Juda alinuna olodere pokaalo ada wari eda nape yapi di olode rudu lisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Go rabu Yesuna amenumi nipu-para talo: Nena disaipel alinumiri napi kogono adenalo go su giyoma Judia su-para pope lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ali medame kogono pulalo palia-daare nipumi ele kudiripu napea. Gore neme go napi kogono pe rabu su kamaa pima enaali raayome adenalo go kogono mea waalale lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gore nimuna amenu page nipu madaa kone narulasimi-pulu go agale lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesumi nimu-para talo: Enaali raayome ni adape yapi di-ri abi na-epa pare nimina di ade abuna pa wia. ");
INSERT INTO kjs_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Enaalinumi nimi madaa yada lore ali aulape kone nasalimi pare ni madaa go-rupa peme. Neme nimuna koeyae madaa agale lakele-pulu go koe yada lore ali kone wimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nimina apo eda yawo ne adaa yapi di adola pulupa lisa pare nina popede yapi di-ri abi na-epaa-daa abi napalua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nipumi nimu go-rupa lakeloma Galili su-para pa pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pare nipuna amenu eda yawe nape yapi adola abala pirisimi rabu Yesumi page adola werepe pisa. Pisa rabu nipu kaleda-ma puma oge pora pagina pisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gore Juda alinumi eda yawo ne adaa yapi di rabu su-para pirabana na-adisimi-pulu Yesu nipu aa-para pia pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Enaali adaapumi page Yesu madaa mumu agale lo piru aasimi. Go puma medalomame nipu epe ali yaade loma medalomame dia lisa rabu nipumi makirae agale lea lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Go lisimi pare enaalinumi Juda enaali madaa paala komoma pa mumu agale lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Go eda yawo ne adaa yapi di rabu Yesumi lotu ada-para puma kodobaoma enaalinu-para agale moge riaasa. ");
INSERT INTO kjs_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mogealisa rabu Juda alinumi kone adaapu suma talo: Akea puma go alimi kone adaapu wia pe loma nipu skul aa-para puma laa ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesumi talo: Neme mogeaayo agalena re-re nina agale-daa dia. Gote-me ni mea epenalisa-pulu nipuna agale moge aayo. ");
INSERT INTO kjs_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Enaali raayome Gote-na agale waru pagalimi-daare nina agale gore ora nina agale yapalo Gote-na agale yapalo mada waru makuaalimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ali medame pa nipuna kone madaa agale tea-daare gore nipuna bi minasaatalo pea. Pare nina Aapame ni mea epenalisa-daa neme ora agale loma makirae agale meda na-toa. ");
INSERT INTO kjs_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gore Moses-me rekena agale gisade pare nimina rikirana ali medame go rekena agale naralea. Gore ake pea-daa nimimi ni lu makomaatalo pimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Go lisa-pulu mo enaali raayome nipu-para go-rupa lisimi: Koe remo meda nena koau madaa pia. Nere aapimi lu makomalia ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesumi talo: Neme abalade napi kogono pawade rabu nimimi pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-me abalade yogale ruguli agale mana lagisa-pulu nimimi Pomo mu Pirape Yapi di rabu naakinuna yogale rugulimi. Pare nimina kasuanumi go kone abala gisimi-le Moses-me abala nagisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Gore nimimi Moses-na rekena agale giyoma pisimiri Pomo mu Pirape Yapi di rabu oge naakinuna yogale kepelisimide. Go pea pare neme Pomo mu Pirape Yapi di rabu ali medana yaina marekaayo rabu nimimi ni rono ake pea-daa pagalimi ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nimi kose lape agale-rupa leme rabu pa kone suma leme. Gu-rupa napiape yapare redepo le kone suma kose lape agale-rupa tapape. ");
INSERT INTO kjs_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem su-para pirisimi enaali medalomame talo: Go aliri nimumi lu makomaalalo peme ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gore adalepa. Nipumi pa enaalina le agaa madaa lalaina nimumi nipu madaa agale meda natlme. Go pea-le mo ali kalunumi go aliri ora Gote-na Mea Rapaae ali ya-daa kone wimi? ");
INSERT INTO kjs_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pare go alina adare-re naame adema-pulu nipu-daa dia. Gote-na Mea Rapaae Ali epaliade raburi nipuna adare-re ali medame mada na-adalia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu adaa lotu ada-para agale mogeaoma puri pale agaleme talo: Nimimi ni-para nina adare-para waru ademe kone wimi? Gore nina kone suma naipisuade. Dia, pare Aapame ni mea epenalisare nipu ora agalena aaraa pia. Nimimi nipu na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yapare nipumi ni epenalisa-pulu nipu piri-para giyoma ipisuade. ");
INSERT INTO kjs_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Go lisa rabu nipu karapo ada adialalo pirisimi pare nipuna yapi di naipisa-daa kimi naripinaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pare go kiritasimide enaalina rikiranare enaali adaapumi nipu madaa kone rulaoma talo: Gore Gote-na Mea Rapaae ali epalia raburi go alina napi kogono mada ma-oge yaalia ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi alinumi Yesu madaa mumu agale lisimi-daa pagisimi. Go pisimi-pulu nimu-para Gote-na lodo kira-ae ali mudunu-para nimumi Yesu karapo ada patinalo polis medaloma mea rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gore Yesumi talo: Abi ni nimi raapu rudupu pirumare wala nipumi ni mea epenalisade ali piri-para wala palua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Go rabu ni asapalimi pare nimimi ni na-adasaalimi. Ni pitua su-parare mada na-epalimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Go lisa rabu Juda alinu nimuna agale gu-rupa lo pirisimi: Nipu aa-para palia rabu naame asapu piralima ya? Gore Grik adare-para kimisu palia ya? Go-parare Juda alinu piruma nipumi Grik enaali mogeleme-pulu go-para palia ya? Go kone su pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yesumi talo: Nimimi ni asapalimi pare nimimi ni mada na-adasaalimi. Go page nipumi talo: Naa palua su-parare nimi mada na-epalimi. Go lisa-pulu go agalena re-re akepu ta pae kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gore mo eda yawo ne adaa yapi di komeare ora mudu yapi di yaade. Go rabu Yesu rekoma puri pale agale gu-rupa lakalisa: Enaali meda nimu ipa nalame komalimi-daare nimi ipa giano ipulupape. ");
INSERT INTO kjs_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gote-na buk madaa gu-rupa lisana: Enaali raayome ni madaa kone rulalimi-daare nimuna lo-parare ade abuna yokala pia ipa popea-rupa pimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nimumi Yesu madaa kone rulalimi-pulu Holi Spirit mealimina-le Yesumi Holi Spirit madaa go saa pi agale lakalisa. Go raburi Gote-me Yesu wala namarekaaoma epe paana puri abi nakalisa-pulu enaalinumi Holi Spirit abi namisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gore mo Yesuna agale pagisimi-pulu nimumi talo: Go aliri ora Gote-na agale lakale ali yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Medalomame talo: Nipuri Gote-na Mea Rapaae Ali yaade lisimi. Pare medalomame talo: Gote-me Mea Rapaae Aliri Galili su-para mada na-epalia. ");
INSERT INTO kjs_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gote-na buk madaare Gote-na Mea Rapaae Ali Devit-na ruru piralia pare Devit madisade su adare-para epalia. ");
INSERT INTO kjs_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Go agale rado rado Yesu madaa lisimi-pulu enaali raayo yada rugulala paoma pisipi. ");
INSERT INTO kjs_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Medalomame nipu kose laaoma adialalo pisimi pare namula pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Go raburi polisman-nupara Gote-na lodo kira-ae ali mudunu-para Farisi alinu-para wala pisimi. Gore nimumi mo alinu-para gu-rupa lisimi: Ake paa-daa mo ali nalamua epame ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Plisman-numi talo: Gore abalade go alimi agale lakela-rupadaa wala ali medame gu-rupa mada nalemede. ");
INSERT INTO kjs_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Go lisa-pulu Farisi alinumi nimu-para agale gu-rupa misimi: Go alimi nimi page makiraaripa ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gore naana ali mudu komeame page Farisi ali komeame page nipu madaa kone rulaemede remaa pageme ya? ");
INSERT INTO kjs_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Go kiritape enaalinumi Moses-na rekena agale napageme-pulu Gote-me koe kedaa katea. ");
INSERT INTO kjs_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gore go enaalinuna rikiranare ali meda Nikodemus pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nipuri abalade Yesu adola pisa. Nipumi enaalinu-para talo: Naana rekena agalemere pa enaali-para kose lape agale tema-daare nipuna agale abala pagoma nipuna koe kone makuaamona lisa. ");
INSERT INTO kjs_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Go lisa-pulu enaalinumi nipu-para arere agale gu-rupa lisimi. Gore ne page Galili piri ali ya? Rekena agale yarepema makuaali. Gote-na agale lakale aliri Galili su-para mada na-opalia lisade. ");
INSERT INTO kjs_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Go puma enaali raayo nimuna adarenu-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Go raburi enaali raayo nimuna ada pirisimi pare Yesu Oliv rudune pisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ekera-nanere yapi lapaasa raburi Yesu nipu rekoma lotu ada ru-nane wala pisa. Go rabu enaali adaapu nipu piri-para kiritainaloma Yesumi piruma nimu agale moge riaasa. ");
INSERT INTO kjs_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Go rabu rekena agalena tisaa-nu page Farisi alinu page nimumi ali paake nalania adisimi-pulu mo enaali piri-para go ena mea ipuma waalalo rikirana ma-rekaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Go alinumi Yesu-para talo: Tisaa, go ename ali paake nalaina rabu adema. ");
INSERT INTO kjs_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Naana rekena agale madaare Moses-me gu-rupa lisa: Ena medame ali paake nalalia-daare kana muma lu makomatepape lo buk madaa gu-rupa lu wisa. Gore nemere ake le pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Go makirae agale madaare nimumi Yesu kose lape agale kotalalo pirisimi. Yapare Yesumi kubunaoma nipuna ki maalame su madaa pepa-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nimu paboma aoma lorapisimi rabu Yesumi rekoma nimu-para talo: Gore nimina rikiranare pupitagi nane ali meda pia ya? Go-rupa piri aliri nipumi ena kaname abala lina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Go lomare wala kubunaoma ki maalame su madaa pepa-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nimumi go agale pagoma nimu komea komea laatapu popesimi rabu ali mudunu abala penaaloma ali medalomanu werepe pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nimu penaalomare Yesumi rekoma ena-para talo. Go ena, mo alinuri aa-para pimi? Ali medame ne raapu kose lape agale-daa nalea? ");
INSERT INTO kjs_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ename talo: Adaa Ali, raayo abala puame. Yesumi talo: Gore neme page kose agale nalano. Abi paina yapare pupitagi wala nanape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesumi nimu wala gu-rupa lakalisa: Niri su raayona pimi enaali raayona epe paa yaade lisa. Enaali raayome ni madaa kone rulalimi-daare nimu ribaale-para napamualimi pare nina paamere nimuna ade abuna pirama pope pora waatoa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Go rabu alinumi nipu-para talo: Gore abi nere agale te-pulu nena go te agalere ora agale-daa dia lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesumi agale gu-rupa abulisa: Gore nina agale lagedere neme ipisuade su-para wala paluade su page ade-pulu ora agale lagialo. Gote ni aa-para palua palo aa-para ipisua palo nimimi na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nimina kose lape agalere go su kamaa kone madaa leme. ");
INSERT INTO kjs_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pare neme kose lape agale toa-daare ni komeame natoa dia. Nina kose lape agale ora lagialua. Aapame ni epenalisare ni raapu pia. ");
INSERT INTO kjs_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nimina rekena agale madaa gu-rupa lu sade: Ali laapome ele meda madaa komea agale tepere nipu laapona agale ora epelea toa. ");
INSERT INTO kjs_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Go pea-le neme nina agalere lagialo rabu Aapame ni mea epenalisa-le nipumi ni madaa agale page lagelea. ");
INSERT INTO kjs_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Go lisa-pulu nimumi nipu agale mulalo pirisimi: Nena Aapare aa-para pia ya? Yesumi talo: Nimimiri ni-para nina Aapa page na-ademe. Pare nimimi ni ademe-rupa Aapa page ademe lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nipu adaa lotu adana kana paus kiritape ada ru-nane piruma go agale lakalisa. Gore go-rupa lisa rabu nipuna yapi di narudu lisa-pulu pa ali medame nipu na-adialalo pisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesumi nimu-para wala talo: Ni palua-pulu nimimi ni asapalimi pare nimina pupitagi nape kone pa saapimi-pulu nimi komalimi. Ni palua su-parare mada na-epalimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Go lisa rabu Juda alinumi talo: Nipuna talo ni palua su-para mada napalima ta-le ake paa-daa ta pe lisimi? Go agalena re-re nipuna kope nalia ya? ");
INSERT INTO kjs_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesumi talo: Nimiri go su kamaa pimi enaali yapare niri sogo yaa-para piruma ipisua. Nimiri su kamaa madina enaali yapare niri su kamaa ali-daa dia. ");
INSERT INTO kjs_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Go pea-pulu nimina pupitagi nape kone saapiruma komalimi-daa abala lagiawade. ");
INSERT INTO kjs_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Go lisa rabu nimumi nipuna agale mulalo pirisimi: Nere aapi ya? Yesumi talo: Abala ririna nimi lisuade niri go te yaade. ");
INSERT INTO kjs_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nimina pupitagi nape kone wimi madaa neme agale adaapu lagialua. Go palua pare nipumi ni maa epenalisadere nipu ora pia-pulu nipuna agale pagaliminalo lagu aayo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mo saa pi agalere Aapame lakale agale yapare namakuaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Go pea-pulu Yesumi nimu-para talo: Werepe nimimi ni enaalinu Raapu Pirape Alina Si minasaalimi rabu niri go agalena re yaa-pulu mada makuaalimi. Go rabu nimimi nina koneme ele napawa pare Aapame lagi agale nimi laguaayo-daa makuaalimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nipumi ni epenalisadere abala ni raapu pia. Nipuna kone ade abuna mogeaayo-pulu Aapame ni madaa pedo palia. Go pea-le ni kama agu raapu napiruaayo. ");
INSERT INTO kjs_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesumi go agale lisa rabu enaali adaapumi nipu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Juda medalomame Yesu madaa kone rulasimi-daa Yesumi nimu-para talo: Gore nimiri nina agale pago mogealimiri nimi ora nina disaipel enaali piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nimimi ora agale makuaalimi rabu ora agaleme nimi epe-rupa ma-piraalia. ");
INSERT INTO kjs_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Go lisa-pulu nimumi talo: Gore naare Abraham-na si wane kasuanu pima-pulu naare ali medana kogonome adili ali-rupa napirama. Go pea-pulu neme ake pea-daa naa kode mapiraalua lae ya? ");
INSERT INTO kjs_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesumi nimu-para talo: Enaalinumi pupitagi ne kone saapiralimiri nimuri pupitagina kogonome adili enaali-rupa pimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kogono adili ali meda nipuna kogono pi aaraana ada-para ade abuna napiralia. Dia, alina siri ade abuna kode mada piralia. ");
INSERT INTO kjs_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Niri Aapana Si yaa-pulu neme nimi kepealuame nimi ade abuna kode enaali-rupa piraminalo pi. ");
INSERT INTO kjs_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ni makuaayo, nimiri Abraham-na si kasuanu yaade. Pare nina agalere nimina lo robaa-para nawia-pulu nimimi ni lu makomaatalo pimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aapame ni maa waalisade ele madaa lagialo pare nimimiri nimina aapanumi lagisade-ale pa peme. ");
INSERT INTO kjs_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nimumi nipu-para talo: Naana Aapare Abraham pirisade lisimi. Yesumi talo: Nimi Abraham-na sinu pirisimi rabu nipuna pisade kogono mogeleme. ");
INSERT INTO kjs_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pare neme Gote-na lagi agale nimi ora agale ade abuna lagu aayo. Neme lagu aayo pare nimumi ni lu makomaatalo peme. Go konere Abraham page nawisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Go konere nimina Aapame pisade-ae peme. Nimumi talo: Naana Aapa Gote komea pia. Go Aapare Gote yaa-pulu naa pa paake ali yoloma madina naakinu-daa dia lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesumi nimu-para talo: Gore Gote-re nimina Aapa ria yaalore ni madaa raaname komola pame. Akepa-daa? Ni Gote raapu piruma go su kamaa epawa. Nipumi ni mea epenalisa rabu ipisua pa kamaa nina kone suma naipisuade. ");
INSERT INTO kjs_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Go lagialo agale ake puma mada namakuaaeme? Gore nina agale giyoma napageme-pulu namakuaaeme. ");
INSERT INTO kjs_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nimi Satan-na sinu yaa-pulu nimina Aapana kone mogealalo pimi. Nipuri ora abalade enaali lu makomaa-ae ali pirisade. Nipuri ora agale nale ali yaa-pulu nipuna kone suma ora agale le ali pia. Nipumi makirae agale tea rabu nipuna kone suma mogeaaya. Nipu makirae agalena le ali piruma makirae agale raayona aaraa pia-pulu go kone mogeaaya. ");
INSERT INTO kjs_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Neme ora agale lagialo pare nimimi ni madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nimina rikiranare ali medame nina pupitagi nape kone meda adea? Dia-le neme ora agale lagialo-le ake pea-daa ni madaa kone narulaeme? ");
INSERT INTO kjs_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gote-na si wanenumiri nipuna agale pageme pare nimi Gote-na sinu-daa dia yaa-pulu nina agale napageme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Go lisa-pulu Juda alinumi Yesu-para talo: Ne Samaria su-para piri ali loma nena raapu remo meda pia lama-le ora lama pae? ");
INSERT INTO kjs_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesumi talo: Remo-daa nina koauna napia. Neme Aapana bi minasaayo pare nimimi nina bi rabuaniaaeme. ");
INSERT INTO kjs_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Neme nina bi napamu minasaayo dia. Ali medame nina bi minasaatalo pia-pulu go aliri ni madaa kose lape agale epe-rupa mada lea. ");
INSERT INTO kjs_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neme nimi-para ora talo: Enaali raayome nina agale pagoma saapiralimiri ade abuna nakomalimi pare kagaa piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Go lisa-pulu Juda alinumi Yesu-para talo: Abiri nena koau-nane remo pia-daa naame waru adema. Enaali raayome nina agale pagalimiri ade abuna nakomalimi laede. ");
INSERT INTO kjs_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Go lae pare Abraham-para Gote-na agale lakele ali-para komisimi. Nere naana Aapa Abraham mada ma-oge yaate lisimi? Gore Gote-na agale lakale alinu page komisimi-le ne aapi nona pi pirali ya? ");
INSERT INTO kjs_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesumi talo: Neme nina bi puma nina minasaalua dia. Pare nina Aapame nina bi minasaaya-le go Aapare naana Gote komea abala lamede go yaade. ");
INSERT INTO kjs_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nimimi nipu na-ademe pare neme nipu ade. Neme nipu na-adolape yaalore ni nimi makirae agale le alinu piru aayo. Pare neme nipu ade-pulu nipuna agale mogeaayo. ");
INSERT INTO kjs_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nimina kasua Abraham ni madina adolalo pisa-pulu ranaa komo pirisa. Gore adisa rabu ora raaname waru komo pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Go raburi Juda alinumi nipu-para talo: Ne madina di-ri maali 50 dia yaa-pulu ake pea-daa neme Abraham ade lae ya? ");
INSERT INTO kjs_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesumi talo: Neme ora talo. Abalade Abraham namadisa rabu ni abala pirisuade. ");
INSERT INTO kjs_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Go raburi nimumi kana muma nipu tyalalo pisimi pare Yesu nipu kaledoma adaa lotu adaa giyoma kamaa pisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu pora pamisa raburi nipumi le rubu pi ali meda adisa. Go aliri agimi le rabu pu palae madisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Go ali adisa rabu disaipel alinumi Yesu nipu agale gu-rupa misimi: Tisaa, go le rubu pi ali yaa-pulu aapimi pupitagi noma le rubu mapaasa ya? Go ali nipuna pupitagi nisa palo nipuna agi aaraa laapome pupitagi nisipi-daa pisa pae lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesumi talo: Go alina lere nipuna pupitagi page agi aaraa lapo pupitagi page go madaa nanisa. Dia, pare nimimi Gote-na kogono adenalo agina robaa-para pupalae madisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Abi naare rea raburi naame nipuna le epeaina Aapana kogono pamina. Werepe ribaa yaalia rabu kogono madaa napalima-pulu Aapana kogono abi pamina. ");
INSERT INTO kjs_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ni su kamaa enaali raapu pa pi rabu nimu paa mea katoa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Go lomare Yesumi supi raa kirasa. Mo sopere su raapu medale yaoma sabaoa mo alina le paa suma palae kimi maa waraasa. ");
INSERT INTO kjs_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Go rabu nipumi agale gu-rupa lisa: Go Siloam ipa pia-para pu lisa. Go ipa Siloam-na biri adaa agale meda madaa maa penaalisa leme. Go lakalisa rabu go ali ipa puma le radepea wala ipumare le epe-rupa ruma ele adisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Gore nipuna adare-para piri enaali medalomame nipu ele ogetalo adisimi-pulu agale gu-rupa misimi: Abalade go alimiri ele oge muma gialepa lala pirisa lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Enaali medalomame talo: E, go ali yaade lisimi. Pare enaali medalomame talo: Dia, nena pi alina yago yaade lisimi. Go lisimi-pulu go alimi talo: Gore ni yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nimumi nipu lorapisimi: Nena lere ake puma epea pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Gore alimi talo: Nimina ali Yesu lemede alimi supi su raapu mokopea nina le-para pepeminuma go rabu nipumi ni-para ne no ipa Siloam le madaa ipa isula pu laa. Go laa rabu waswas tula puaware le rupaoma ele waru adawa. ");
INSERT INTO kjs_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nimumi lorapisimi: Mo alina adare aa-para pia ya lisimi. Nipumi maarea lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Go raburi mo le rubu pi ali Farisi alinu piri-para maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gore Yesumi mo alina le-para kege mokopea ma-epeaaripa di-ri Pomo mu Pirape Yapi rabu pa lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Go rabu Farisi alinumi go ali-para talo. Nena lere ake puma wala epea pe lisimi. Nipumi nimu-para talo. Nipumi nina le-para kege tanaloma nina le agaa radepeaoma abi neme ele epe-rupa ada lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisi ali medalomame talo: Nipumi rekena agale ralu Pomo mu Pirape Yapi di madaa kogono pea-pulu Gote-me go ali namuma epenalisa lisimi. Medalomame talo: Pupitagi ne alimiri go napi kogono mada pea pa lisimi. Apo agaleme nimu rugutalalo pa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mo ali wala lorapisimi: Gore nipumi nena le maepeaaripa-daa lae-pulu nemere nipu madaa ake le ya? Go alimi talo: Nipuri Gote-na agale lakale ali kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yapare Juda alinuna konere nipu abala le rubu pi ali piruma pare abi nipuna le ma-epeaaripa-daa dia kone yaalisimi. Go kone wisimi-pulu nimumi go alina agi aaraa yalaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Go puma nimumi agaa gu-rupa misimi: Go naakiri nena ya? Neme madisi raburi le rubu pi madu wi si palo lagi. Gore ake puma nipumi abi ele mada adea? ");
INSERT INTO kjs_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Go puma nipuna agi aaraa laapome talo: Ora saana si yaade. Go page agimi le rabupu palae madu wisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pare abi nipuna lere ake puma rupaaripa lisa rabu saa namakuaaepa lisipi. Go page aapimi nipuna le marupaaripa palo nipu puma agale mealepa. Nipu oge naaki-daa dia yaa-pulu nimi mada lagialia lisipi. ");
INSERT INTO kjs_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Agi aaraa nipu laapo Juda alinu paalame komisipi-pulu nipumi go-rupa lisipi. Abalare Juda alinumi agale gu-rupa robesimi: Ali medame Yesuri Gote-na Mea Rapaae Ali mo lotu ada-para leme-daare so kamaa rasamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Go lisimi-pulu agi aaraame talo: Nipu adaa ali yaa-pulu nipu puma agale lorapealepa lisipi. ");
INSERT INTO kjs_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Go rabu mo le rubu pi ali wala yaaloma nipu-para talo: Gote-me ne adea-le neme so yaa madaa loma ora agale lape. Go nena le marupa-ae aliri pupitagi ne ali-rupa makuaatema. ");
INSERT INTO kjs_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Go alimi talo: Nipu pupitagi nea palo epe ali yapalo ni maarea. Pare komea ele-daa makuaato. Abalade nina amame ni madisa raburi le rubu pi ali pirisuade. Go pea pare abi nina le epelea-daa pi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nimumi talo: Nipumi ne mada ake paa? Nena lere ake puma ma-epeaaripa pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Gore nipumi talo: Neme nimi abala mo lagiawade pare nina agale napagoma wala agale mealimi: Gore ake pea-daa wala pagalimi? Gore nimi nipuna disaipel ali-rupa piralimi pe lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Go lisa-pulu nimumi nipu-para ero agale gu-rupa lisimi: Ne komeare go alina disaipel ali pi. Naare Moses-na disaipel alinu pima. ");
INSERT INTO kjs_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Naare Gote-me abalade Moses agale lakalisa-daa makuaaoma go aliri aa-para epa palo naa maarea lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Go raburi mo alimi talo: Go leme agalere ora rado meda. Go aliri ali-para epa palo nimimi na-ademe pare nina le nipumi ma-epe yaaripa. ");
INSERT INTO kjs_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gore naame ademe-le Gote-me pupitagi ne enaalinuna beten mada napageade. Dia, pare enaalinumi nipuna bi minasaoma nipuna agale mogalimi-daare go enaalina beten-re Gote-me pagea. ");
INSERT INTO kjs_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ora su yaa warisa rabu enaalinu komala ralala puma abi page ali medana agimi le rabula palae-rupa nipuna le ma-epe yaaripade remaa napageme. ");
INSERT INTO kjs_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Gore Gote-me go ali-daa namuma epenala pisa yaalore nipumi go kogono mada napula paa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nimumi agale go-rupa abulisimi: Nena amame nere pupitagi noma maitaana. Gore neme naa agale lagiali ya? Go lomare go ali lotu adaa kamaa-nane ralisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gore nimumi mo ali lotu ada kamaa-nane ralisimi rabu Yesu go remaa pagisa. Go rabu mo ali asa puma adasaaoma agale go-rupa lorapisa: Ne enaalinu Raapu Pirape Alina Si madaa kone rulaale pe lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Go alimi talo: Tisaa, go aliri aapi ya? Neme ni lagiali-daare neme nipu madaa kone rulano. ");
INSERT INTO kjs_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesumi nipu-para talo: Neme nipu ade-le abi saa laapo agale tepa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Go rabu go alimi talo: Mudu Ali, neme kone rulaato. Go lomare nipuna rumu pege puma Yesu re-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Go rabu Yesumi talo: Ni go su kamaa ipumare kose lape agale lamulalo pi. Go puma le rubu pi enaalinumi ele mada adalimi pare ele ademe enaalinuri le rubu pi enaalinu piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Go lisa-pulu Farisi ali medaloma nipu raapu pirisimi rabu go agale pagomare agale gu-rupa misimi: Gore naa le rubu pi ali-rupa pima lae pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesumi talo: Nimi le rubu pula pea yaalore nimi pupitagi nape kone nasula peme. Go pea pare nimimi naana lere epelea leme-pulu nimina pupitagi nape kone pa saapitimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesumi nimu-para talo: Neme ora lagialo. Ali medame mena sipsip-na pape ru-nane pulalo paliare nipumi pora gaape abala lobalia. Go pea pare pape abulalia-daare nipu paake ne ali yaalo pea. ");
INSERT INTO kjs_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gore pora gaape-para kodobaoma ru-nane poape aliri nipu sipsip puni ali yaade. ");
INSERT INTO kjs_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Go pea-le pora gaape surube alimi pora lobalia. Go rabu mo alimi sipsip nimuna bi komea komea lo yaaloma kamaa-nane maa penaatea. ");
INSERT INTO kjs_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Go pumare sipsip puni alimi kamaa maa pumare nipu abala palia. Go puma sipsip puni alina agale pageme-pulu raita maa palimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipsip amena adobalia ali komeana agale pagalimi-pulu pa ali medana agale pagoma pogola peme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesumi nimu saa pi agale lakalisa pare go agalena re namakuaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesumi agale wala talo: Neme nimi ora lagialo. Niri sipsip mena-na pora gaape pi. ");
INSERT INTO kjs_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Abala ririna ipisimi enaalinuri paake ne enaali ipisimi. Go pirisimi pare mena sipsip-numi nimuna agale napagesimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Niri pora gaape yaa-pulu pora gaape lobanolomare enaalinu ru-nane mada kodobaoma ade abuna epe-rupa kagaa piramala palimi. Go pea-pulu nimu ru-nane kodobaoma kamaa puma go-rupa eda nalimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Go pea pare paake ne alimi ele paake nolalo ipuma sipsip lu makomaatalo epelea. Enaalinumi ni raita mea ipumare ade abuna kagaa piramala palimi. Ni ipisuare enaalinuna lo robaa-para ade abuna kagaa pirape epe kone mea kaloma rubitabenalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Niri sipsip epe-rupa punili ali yaa-pulu nina sipsip-nu nimu madaa komaluame pi. ");
INSERT INTO kjs_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pare kana kogono pi ali medare nipu sipsip-na aaraa dia-le koe yana epenalo adaliare go aliri pogola palia. Go pea-pulu koe yaname sipsip ralu noma ralu rubebe palia. ");
INSERT INTO kjs_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Go aliri nipu pa kana yoto kogono pi ali yaa-pulu nipumi sipsip madaa kone waru nawia pare koe yana epalia rabu pogola palimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Go pea pare niri ora sipsip epe-rupa puni ali yaade. Go kone madaare neme sipsip ade-rupa nimumi ni ademe. Nimumi ni mada timi pare neme nimu punulalo piru aayo. Gore Aapame ni adea-rupare neme Aapa ade. Gore neme nina sipsip raba mulalore nimu madaa komaluame pi. ");
INSERT INTO kjs_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naa pa sipsip medaloma page pimi pare go pape ru-nane napimi. Go pea-le nimu page ru-nane maa epalua. Go rabu nina agale pagena loma komea kuta-para kiritinaloma nimu surubalua. ");
INSERT INTO kjs_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Go pea-le nimu madaa komaluame pi-pulu Aapame ni madaa ranaame komea. Nimumi ni lu makomalimi rabu neme wala rekoma epe-rupa pitua. ");
INSERT INTO kjs_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pa enaalimi ni mada nalu makomalimi. Dia, nina kone suma ni mada linalo giyalua. Naa ade abuna kagaa pirape kone wasupare nimumi lina toa page neme wala mealua page nina palua. Aapame go agale abala lagisa-pulu go-rupa palua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda alinumi go agale pagisimi-pulu nimu rikirana rugulalapa maa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Enaali medalomame talo: Nipuna koauna remo pia-pulu nipu makeyaaya lisimi. Ake pea nimimi nipuna agale pageme lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pare enaali medalomame talo: Dia, remome koauna pirumare agale go-rupa mada natea. Ake pea remome le rubu pi alina le ma-epeaaripa ya lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gore Jerusalem su-para Pomo mu Pirape Yapi di rudu lisa. Go yapi di raburi abalade nimuna lotu adana pora gaape lobesimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Go rabu Yesu mo lotu ada-para puma Solomon-na robele rum-para pamisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Go raburi Juda alinumi Yesu piri-para epa kutapubaoma nimumi gu-rupa lakalisimi: Ake pea neme naana pu marekaaripi ya? Go puma go agale lagiali ya? Nere Gote-na Mea Rapaae ali yaalo agale waru lagiape lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesumi talo: Neme abala lagiawade pare nimimi go agale napageme. Aapana purina kogono pe rabu naa bi ma-adaa ademe. ");
INSERT INTO kjs_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ademe pare nimiri nina sipsip dia yaa-pulu ni madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Naa sipsip-mi ni adoma nina agale pagoma ni raita maa epeme. ");
INSERT INTO kjs_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neme nimu ade abuna pirama pope kone wasa kale-pulu ora mada nakomalimi. Go puma nina sipsip nina surubaayo-le pa enaali medalomame mada napaake mealimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Naa Aapare enaali raayona mudu ali yaa-pulu nipumi nimu surubena pa enaali medalomame mada napaake mealimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aapa saa laapore ora komea-rupa pipa. ");
INSERT INTO kjs_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Go lisa rabu Juda alinumi kana muma nipu talo pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesumi nimu-para talo: Aapame napanolo kogono adaapu go aaya-pulu gore nimu abala waalawade wala ele kogono madaa kone suma kaname ni lu makomaalalo palimi pe lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda alinumi agale gu-rupa abulisimi: Nena epe kogono madaa kaname nalu makomalima yapare ne Gote-para ero agale lae-pulu kaname lu makomalima lisimi. Nere pa agaleme ake pea-daa ne Gote pirali pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesumi talo: Gore nimina rekena agalena buk madaare Gote-me gu-rupa lisa: Nimiri Gote pimi lo lu wisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gore Gote-na buk-ri ade abuna ora agale lo aaya-daa pageme. Gore Gote-me nipuna agale enaali lakeloma nimi Gote pimi lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Niri Aapame nipuna saba piruma su kamaa mea rapasa. Go pisa-le neme Gote-para ake pea-daa ero agale toa lo lame ya? Niri Gote-na Si lawa-daa lame ya? ");
INSERT INTO kjs_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Neme Aapana kogono napaayo kone suma ni madaa kone narulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pare nipuna kogono paluare go napi kogono madaa kone rulala peme. Go pea-pulu Aapa saa laapo komea-rupa pipa-le makuaamina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Go rabu nimumi wala adialalo pisimi pare mada naripinaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Go raburi Yesu nipu wala ipa Jordan kenaoma mone pamisare abalade Jon-me enaali kalu-ipa kalisade-para puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Go rabu enaali adaapumi nipu piri-para ipuma talo: Jon-me go napi kogono napisa pare nipumi go ali madaa lagisade agalere ora yaana lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Go raburi enaali adaapumi Yesu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ali medana biri Lasarus nipu Betani su-para piruma yaina komisa. Go adare-parare nipuna bali Maria Marta laapo raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Go Maria-mere abalade epe kaa pi wabola medame Yesuna age laapo madaa koya sumare nipuna irimi makaapu yalisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Go enana bali Lasarus yaina komisa-pulu nipuna bali laapo Yesu piri-para agale laketa pisipi. Nipumi talo: Abi nena epe adami aliri yaina komea lisipi. ");
INSERT INTO kjs_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesumi go agale pagoma gu-rupa lakalisa: Lasarus-re ora le kadupiapa yaina-daa dia. Gote-me nipuna epe paana puri werepe adaminalo abi yaina komea. Go yaina madaare Gote-me nipuna naaki page epe bi gialiminalo meapana lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesumi Marta-para aki-para bali Lasarus-para ranaame komisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Go pisa pare nipumi Lasarus yaina komea remaa pagisa rabu yapi laapome nipu su-para pa pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pirumare nipumi disaipel ali-para talo: Naa wala Judia su-para baina. ");
INSERT INTO kjs_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mo disaipel alinumi talo: Tisaa, go su-parare Juda alinumi kaname ne lu makomaalalo pamede-le ne go su-para ake pea-daa pali pa? ");
INSERT INTO kjs_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesumi saa pi agale gu-rupa lisa: Naare ralade rabu ali meda pora go rabu paame nipu raba mealia-pulu pora-nani namagalataboma lopalia. ");
INSERT INTO kjs_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pare ribaa pora pamualimi go alina lo robaa-para paa nawia-pulu go ali pora-nane magalataboma lopalia. ");
INSERT INTO kjs_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Go lomare Yesumi wala go-rupa lakalisa: Naana adami ali Lasarus-ri abala u paitaade pare neme nipu wala marekaata palua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mogo alinumi talo: Gore nipu u paitaare epelea-le nipuna mada rekalia lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pare Yesumi go saa pi agalena re-re Lasarus pa le kadupiaade lakalisa pare disaipel alinumi pa u paitana kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Go kone wisimi-pulu Yesumi go saa pi agalena re gu-rupa lakalisa: Lasarus le kadupia yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pare neme nipu piri-para napirawa-le epelea. Nimumi ni madaa kone rulalimi-daare abiri nipu piri palima. ");
INSERT INTO kjs_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas-na bi medare Didimus nipumi disaipel ali medaloma-para talo: Tisaa, nipu raapu bana-le le komamona lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gore Yesu Betani su-para puma puaa adisa pare Lasarus yapi maalapu tapa-para rogaabasaaya. ");
INSERT INTO kjs_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Gore Betani su oge-daa mo-pare aoma Jerusalem su-para oge-daa mo-para aasa. Go pisa-daa Juda enaali adaapumi Lasarus le kadupia remaa pagomare nimu Maria Marta laapo piri-para ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Go pumare go ena laapona lo robaa-para makumaa palalo komaa-daa ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta-me Yesu epea remaa pagisa rabu nipu pora-nane madaata pisa pare Maria ada-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta-me Yesu-para talo: Mudu Ali, ne go su-para pirula epola pae yaalore nina bali mada nakomala paa. ");
INSERT INTO kjs_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gore abi page neme ele meda Gote-para beten te-daare nipumi mada gialia-daa makuaali lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesumi talo: Nena baaliri wala rekoma piralia. ");
INSERT INTO kjs_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Go ename talo: Gore wala werepe epaliade yapi di rabu nipuna rekalia-daa makuaato lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesumi talo: Gore niri enaalinu wala marekaape re page nimuna kone wasa ade abuna kagaa mapiraapena re page pi. Enaali raayome ni madaa kone rulalimi-daare komalimi rabu nimuna kone wasupa ade abuna kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Go pea-le enaali raayome piruma ni madaa kone rulalimiri ora mada nakomalimi. Neme go agale madaa kone rulaale pe dia ya? ");
INSERT INTO kjs_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta-me talo: Mudu Ali, neme ne madaa kone rulaayo. Nere Gote-na Mea Rapaae Ali yaade. Nere Gote-me su kamaa mea rapaasa-pulu ne ora Gote-na Si kone suma kone rulaayo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta-me gu-rupa lakeloma lisana nipuna aki Maria-para pawasi yaaloma lakalisa: Tisaa epa piruma ne yaata pulade lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria nipumi go agale pagoma Yesu wagepu madaaoma pisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nipu adare-para abi na-opapesa pare abala Marta nipu laapo madaasipi-para aasa. ");
INSERT INTO kjs_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gore Maria rekoma pisa rabu Juda alinumi nipuna pu robaa-para makumaa patalo pisimi-pulu Maria raita maa pisimi. Nimumi Maria tapa-para re ta polalo pula kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria Yesu pirisa-nane puma nipu adomare kibu ripinaaba piruma talo: Mudu Ali, ne go su-para epa pirula pe yaalore nina bali mada nakomala paa kone salo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesumi Maria-para Juda alinu nimu raapu piruma re lala pirina adisa. Go puma nipuna lo robaa-para kedaa puma nipuna pu kolisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Go raburi nipumi nimu-para talo: Nipu aa-para rogaarimi pae? ");
INSERT INTO kjs_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Nimumi talo: Mudu Ali, epa ada lisimi. Yesumi re lisa-daa mo Juda alinumi talo: Adalepa. Mo kome ali madaa pedo puma re ta lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pare ali medalomame talo: Gore nipumi le rubu pi alina le ma-epeaaripa. Go pea-le ake pea-daa nipumi Lasarus komaade mada namarekaalia ya? ");
INSERT INTO kjs_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Gore Yesuna pu robaa-para wala koyaasa-daa nipu tapa-para pisa. Go tapa-re ora kana apedaa-para aasa pare adaa kaname pora gaape garulalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Go raburi Yesumi talo: Go pora gaape garulaarimide kana pane mealepa lisa. Mo kome alina bali Marta-me talo: Mudu Ali, nipu rogaabaina yapi maalapu popea-pulu abiri nipuna ro pugu palia. ");
INSERT INTO kjs_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesumi nipu-para talo: Gore abalade neme lagiawade. Neme kone rulali-daare Gote-na epe paana puri mada adaina lawade. ");
INSERT INTO kjs_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Go lisa raburi kana kapea mu pasa. Go rabu Yesumi yaa-para adasaaoma talo: Aapa, nina agale waru pagele lalo-daa ora pili lalo. ");
INSERT INTO kjs_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ade abuna nina agale page pare go enaalinu madaa apo lalo-daa. Go lalo-le nimumiri neme ni go su kamaa maa rapaasi-daa kone rulalimi lo talo lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nipumi go-rupa loma lisana puri paloma gu-rupa yalisa: Lasarus, ne rekoma kamaa-nane nipu lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Gore mo abala kome ali rekoma ipisa rabu nipuna ki agenuri abalade rogaae mamina ralapaita palae ipisa. Nipuna le agaa page laplap-me rogaae-rupa pa rogaa palae ipisa. Go rabu Yesumi nimu-para talo: Nipu pora pamina kepealepa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Go rabu Maria adola ipisimide Juda enaali adaapumi Yesuna pisa adomare nipu madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pare ali medaloma Farisi-numi alinu piri-para puma mo Yesumi pisa elenu puma lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Go lisimi-pulu Farisi alinu-para Gote-na Lodo Kirae Ali mudunu-para nimumi kaunsil alinu piri-para puma kiritaoma yada robesimi. Go raburi nimumi talo: Go alimi napi kogono adaapu pia-le naame ake pamina ya? ");
INSERT INTO kjs_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nipumi ade abuna go-rupa paliare enaali raayome nipu madaa kone rulalimi. Go palimiri Rom suna surube alinumi ipuma naana lotu ada epa kilipima naana rurunu raayo page yada puma lu makomali lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Go lisimi pare nimuna rikirana ali meda pirisa. Go alina biri Kaiafas nipu go maali komeame Gote-na lodo kira-ae ali mapiraasimi. Go alimi ero agale gu-rupa lisa: Nimiri ora kone nasuma agale pa leme. ");
INSERT INTO kjs_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gore ali komeame enaali raayo madaa komaliare ora epelea. Pare naana rurunu lu makomalimiri kolea lisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Go agale lisa pare go agalena re namakuaasa. Yapare nipu Gote-na lodo kira-ae ali mudu go maali napirisa-pulu nipu Gote-na agale lakale ali-rupa piruma lakalisa. Go lakalisade agalena re-re Yesumi Juda enaali madaa komoma raba minalo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesumi enaali raayo madaa komali-pulu Gote-na enaali raayo ruru komea-para mapiraaliminalo go agale Kaiafas-me lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Go lisa-pulu go yapimi ripima pumare Juda surube ali alinumi Yesu lu makomaalalo yada robo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Go pisa-pulu Yesu Judia su-para mada nawisa pare go su giyoma adare meda-para puma pirisa. Go adarena biri Efraim. Go-parare nipuna disaipel alinu raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juda alinuna eda yawe nape Pasova Yapi Su abala napena mo su kale-nane adare-para piri enaali adaapu Jerusalem su-para ipisimi. Go pirisimi rabu nimuna yogale Gote-na le agaa ma-epeaalalo puma kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Go rabu enaalimi asa pulalo pisimi. Nimu lotu ada ru-nane epa kiritaoma agale gu-rupa lisimi: Ake kone saleme pa? Nipuri go eda yawo ne Pasova Yapi di adola epalia pe lisimi? ");
INSERT INTO kjs_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Farisi alinu-para Gote-na Lodo Kirae Ali kalunumi agale gu-rupa lakalisimi: Ali medame Yesu nipu adalia-daare naa lagialepa lisimi. Nimumi Yesu adialalo pisimi-pulu go agale lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gore yapi di ki medane luma medane kina egali abala dia naloma Juda alinuna Pasova ne yapi di sula palimi-pulu Yesu nipu Betani su-para pisa. Go suri Lasarus komisa rabu Yesumi nipu tapa-para marekaatalo pisade su yaade. ");
INSERT INTO kjs_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Go adare-parare nimumi Yesuna eda yawasimi-pulu Marta-me eda panapu kalisa rabu Lasarus-para enaali medaloma Yesu raapu eda no pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Go rabu Maria nipu wabola pe raayo maa ipumare Yesuna age mada koyo suma pisa. Koyomare nipuna kalu irimi makaapu yalisa. Go wabolana epe kaa piri ada ru-nane rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Go pisa pare Yesu nipuna disaipel ali medare Judas Iskariot werepe Yesu giyaliade ali nipumi talo: ");
INSERT INTO kjs_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ake pea go wabola madaa kana 1,200 kina nameape ya? Go puma kana-re ali naralinu kalamina. ");
INSERT INTO kjs_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Go lisa pare nipumi naralinu madaa kone nawisa. Dia, pare nipu kana paus surubape ali pirisa pare medaloma paake no pisa. Nipuri paake ne ali yaa-pulu apo makirae agale lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Go lisa rabu Yesumi talo: Pinawa. Nipuna wabola koyaade konere werepe komalua rabu rogaalimide enaalinumi nipuna kone madaa agale loma piramina. ");
INSERT INTO kjs_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gore naralimi kome enaalinuri ade abuna nimi raapu piralimi pare ni nimi raapu ade abuna napitua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu nipu mo Betani su-para pirisa rabu Juda Mudu enaali adaapumi remaa pagoma Betani su-para ipisimi. Nimu Yesu komea adola pisimi pare Yesumi Lasarus tapa-para marekaasade ali page adola ipisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasarus marekaasa-pulu Juda adaapumi nimuna ali mudu giyoma Yesu madaa kone rulasimi. Go puma Gote-na lodo kira-ae ali kalunumi Lasarus lu makomaape yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ekerare eda yawo ne Pasova Yapi Su epalia-pulu enaali adaapumi Yesu Jerusalem su-para epalia lo remaa pagisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pagisimi-pulu nimumi repena yonu mumare Yesu epape pora-nane sulalo ria pirimi. Pa ipulaoma gu-rupa yalaasimi: Gote-na bi minasalimina lisimi. Go aliri Gote-na bi madaa ipula-le Gote-me raba mina lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Gore Gote-na buk madaa wisa-rupare raluma Yesumi donki mena adibae muma go donki menana koauna pirisa. Gote-na buk madaa agale gu-rupa wisa: ");
INSERT INTO kjs_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Su adare Saion enaalinu paalame nakomalepape. Nena ali mudumi donki menana koauna piruma epelea-le adalepa. ");
INSERT INTO kjs_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pare go raburi Yesuna disaipel alinumi go buk madaa wi agale namakuaasimi. Pare werepe Yesu nipu epe paana puri mula rekena loma disaipel alinumi apo buk madaa wi agalere abala pisimi-daa wala makuaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abalare Yesumi Lasarus tapa-para marekaasa rabu enaali adaapumi adisimi-pulu go remaa laari pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Go pisimi-pulu enaali adaapumi Yesuna napi kogono madaa remaa pagisimi-pulu nimumi nipu pora-nane madaala pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Go rabu Farisi alinumi gu-rupa lisimi: Gore su kamaa enaali raayome Yesuna pora raleme-le naame agale mada nayokalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Enaalinu Jerusalem su-para ipuma Gote-na bi minasaata pirisimi rabu nimuna rikiranare Grik enaali medaloma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nimu Filip piri-para ipuma talo: Naame Yesu adamono lisimi. Go Filip-na ada Galili su ru-nane aasa. Go suna biri Betsaida lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip-mi Andru puma lakeloma nipu laapome Yesu lakela pisipi. ");
INSERT INTO kjs_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesumi nipu-para talo: Abiri enaalinu Raapu Pirape Alina Siri nipuna epe paana puri meape di-ri epaade. ");
INSERT INTO kjs_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Neme nipi ora lagialo: Wit-na kili komeare su kamaa poaeme pare na-ope pa saliare ora epelea-daa dia. Pare go kili su-para poainaloma kaapu yomare wala opoma kili adaapu madialia. ");
INSERT INTO kjs_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ali medame nipuna yogale kone wasupaa madaa ranaa komo piraliare mada nasaapiralia. Pare ali medame su kamaa piruma yogale waru ele-daa kone dia salia-daare nipu ade abuna kagaa piramala palia. ");
INSERT INTO kjs_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Enaali raayome nina kogono palua leme-daare ni raita mea ipulupape. Go pea-pulu enaali medame nina kogono raba meape enaali piraliare ni nipu raapu pitua. Ali medame nina kogono paliare nina Aapame go kana bi minasaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesumi talo: Abiri neme kone adaapu lo robaa-para muma kedaame komalo-le neme ake lano ya? Aapame abi go di ni madaa giyena toa. Gu-rupa lano ya? Dia, go-rupa natoa-le ni madaa go kedaa ginalo ipisuade. ");
INSERT INTO kjs_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aapa, nena bi madaa puri mapalaaina. Go lisa rabu yaa-para agale meda gu-rupa ipisa: Naa bi madaare puri masaaoma werepe page masaalua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gore re-para piri enaali raayome go agale pagoma gu-rupa lisimi: Yaa-para kari kululu ta lisimi. Pare enaali medalomame talo: Ensel medame nipu-para agale ta lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pare Yesumi nimu-para talo: Go lea agalere ni pagape agale-daa dia. Nimi raba mulalo pagaliminalo epaa lea. ");
INSERT INTO kjs_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Abiri go su kamaa enaali madaa kose lape agale ipula. Abiri go su kamaa ali mudu Satan rabuaanaalia. ");
INSERT INTO kjs_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pare ni su kamaa piranore repena polopea madaa maa luma pitabalimi rabu neme enaali raayo page raba muma maa palua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Apo agalena re-re nipumi kedaa ruma komaliade madaa ta lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Enaalinumi Yesu-para talo: Naana rekena agale madaa gu-rupa pagema lisimi: Gote-na Mea Rapaae Aliri ade abuna piralima lo buk madaa luma wia lisimi. Gore ake puma nimumi enaali Raapu Pirape alina Si mea mudiadalimi ya? Go aliri aapi yapae? ");
INSERT INTO kjs_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesumi saa pi agale gu-rupa abulisa: Oge rudu yapina nimi raapuri ni paa pitua. Go pea-le nimi paa raapu epe-rupa piralepape. Go palimiri ribaame nimi nakepeapalia. Enaalimi ribaale-para pamualimiri aa-para pora pamualimi palo na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Go pea-pulu paa raapu piralimi raburi go paa madaa kone rulalimina. Go pare nimina lo robaa-para epenala lisa. Yesumi go agale loma lisana nimu piri-para giyoma lisana kaleda pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesumi abalade napi kogono pisa-daa adoma nipu madaa kone narulalisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Go pisa-daa Gote-na agale lakale ali Aisaia-me nipuna agale moyaa penaalo go-rupa pisimi. Nipumi agale gu-rupa lu wisa: Mudu Ali, naana lakale agale madaare aapimi kone rulaaya? Mudu Ali-na puriri aapi-para maa waatea yapae? ");
INSERT INTO kjs_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gore nimumi kone mada narulasimi-rupare Aisaia-me agale abala lu wisa-pulu go-rupa pisimi. Agale go-rupa lu wisa: ");
INSERT INTO kjs_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Gote-me nimuna le abala kepisa. Nipumi nimuna pu robaa-para kana ma-aulaaomaa nimuna kone ma-dia yalisa. Go pisa-pulu nimuna leme ele waru na-ademe. Nimuna lo robaa-para paa na-epena-le ni kone naperekeleme. Go pea-le neme nimu mada nama-epealua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Apo agalere Aisaia-me Keriso-na epe paana puri adisa-pulu nipumi go agale mada lo wisa. ");
INSERT INTO kjs_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Go rabu page Juda alinuna ali kalunumi Yesu madaa kone rulasimi pare Farisi alinu madaa paala komisimi-pulu agale kudiripu lisimi. Go rabu Farisi alinumi nimu lotu ada kamaa-nane ralu timi loma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nimuna konere enaalina pedo pape agale loma Gote-me nimu raaname komea kone nawisimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gore Yesumi puri paloma agale gu-rupa lisa: Enaali raayome ni madaa kone rulalimi nimumi ni madaa komea-daa narulalimi. Dia, pare nimimi ni maa rapaasade Aapa madaa page kone rulalimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Enaali raayome ni ademe rabu nimimi ni mea rapaasade ali page ademe. ");
INSERT INTO kjs_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neme go su kamaa ipisuare pea-rupa ipisua-pulu enaali raayome ni madaa kone rulalimiri ribaale-para mada napiralimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Enaali raayome nina agale pagoma yokalimiri neme nimu madaa kose lape agale natoa. Dia, neme su kamaa piri enaali raapu kose talo naipisua pare nimi raba mulalo ipisua. ");
INSERT INTO kjs_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Enaali raayome ni giyoma naa agale napagalimiri nimuna kose pagape ali meda pa pia. Gore werepe yapinu dia yaalia rabu nina lagialo agaleme nimuna kose agale pagalimi. ");
INSERT INTO kjs_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Naa koneme agale palano kone suma nalage. Ni maa rapasa Aapame ni lagisa agale nimi lagu aayo. ");
INSERT INTO kjs_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nipuna lagialia agalemere ade abuna kagaa piramala pope kone gia-daa makuaato. Go pea-daa Aapame lagisade agale toame pi. ");
INSERT INTO kjs_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mo Juda alinuna Pasova ne yapi di-ri wala yapi di meda popenaloma epalia. Go raburi Yesumi nipu go su giyoma Aaraa piri-para wala palua kone makuaasa. Nipumi nipuna su kamaa enaali raayo madaa ade abuna ranaa komape kone kalo kirita wisa-pulu abi page go kone wia. ");
INSERT INTO kjs_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gore werepe alebo Yesu nipuna disaipel alinu raapu eda nisimi. Go rabu Saimon Iskariot-na si Judas-me Satan-na kone kalisa rabu Yesu madaa yada robo pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Gote-me Yesu nipu puri raayo kalisa. Go pisa-pulu Yesumi nipu Aaraa raapu abala piruma ipisua-para palua kone suma makuaasa. ");
INSERT INTO kjs_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Go pea-le Yesumi nipu eda nane giyoma rekisa rabu nipuna mamina koyo wisa. Go pumare nipuna mamina meda muma kego madaa yamesa. ");
INSERT INTO kjs_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Go pumare nipumi kopo-para ipa koyo pabomare nipumi moge ria-ae alinuna age radepeasa. Go pa kamaa pumare nipuna mamina taul mumare kunama pisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Go pumare nipu Saimon Pita piri ipisa rabu Pita-me talo: Mudu Ali, nemere nina age radepetalo pae? ");
INSERT INTO kjs_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Go lisa rabu Yesumi nipu-para talo: Abiri namakuaate pare werepe mada makuaali lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita-me talo: Naa age naradepeape lisa. Yesumi talo: Neme nena age-daa naradepealuare ne nina disaipel ali-rupa mada napirali lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Go rabu Saimon Pita-me talo: Mudu Ali, gore nina age kama naradepeape pare nina ki agelu page raayo radepeaina. ");
INSERT INTO kjs_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesumi saa pi agale gu-rupa lisa: Ali medame nipuna to raayo abala radepealiare nipuna koto madaa wala ipa naisalia. Nipuna age kama radepeaalia. Nimi raayo koto pea pare age komea kotona pea. ");
INSERT INTO kjs_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuna aposel kogono ali medame yada roboma abala adisa-pulu nipumi nimi raayo koto pi-daa napimi pare ali komea koto pia lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gore Yesuna disaipel ali raayona age radepea kiritasa. Go puma nipuna mamina mea maraoma nipuna eda nape siaa madaa puma piruma nimu agale gu-rupa lorapisa: Gore abi neme nimi madaa pawade-aina re-re makuaaeme pae? ");
INSERT INTO kjs_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nimimi niri Tisaa-para Ali Mudu-para leme. Go leme pare ni ora go-rupa pi. ");
INSERT INTO kjs_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Niri Tisaa page Mudu Ali page yapare nimina age apo radepeaato. Go pea-le nimimi nimina amenuna age page radepealepape. ");
INSERT INTO kjs_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Neme nimi waalalo kone muma nimimi go-rupa raitalepape. ");
INSERT INTO kjs_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Neme nimi-para ora lagialo. Kogonome adili alimiri nipuna kogono surube ali wala narabuaaya. Go page agale wai lo rapaae alimiri nipuna mea rapasa ali narabualia. ");
INSERT INTO kjs_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Abi ora agale page pare go agale pagoma kogono palimi-daare raaname komalimi. ");
INSERT INTO kjs_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Neme nimi raayo-para nolalo. Dia, nina mapiraaripude alinu-para talo. Pare go agale madaare Gote-na buk madaa gu-rupa adalimina: Ali meda ni raapu eda nalipa pare go alimi ni rabuaanaalia. ");
INSERT INTO kjs_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Abi go elenu abi napea pare agale lagialo-le go di epaliade raburi nimimi ni mea rapaae Ali madaa kone rulaalepape. ");
INSERT INTO kjs_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neme ora agale lagialo. Ali medame neme mea rapaato enaalinu mealimiri ni page mealimi. Go pea-le nimimi ni mealimi rabu nimumi ni maa rapaa wisade Aapa page mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesumi go-rupa lomare nipuna lo robaa-para kedaa pisua-daa agale gu-rupa lisa: Neme nimi-para ora talo. Ali medame nimina rikirana piruma ni yada lore alinu maa waatea. ");
INSERT INTO kjs_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Go lisa rabu nimuna le agaa-para one adala mone adala pisimi-daa aapi-para ta pae kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Disaipel ali meda Jon-re Yesu re-para pirisa. Yesumi nipu raaname komisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Go pisa-pulu Saimon Pita-me ni-para le pobolo ridipiaoma aapi-para lama palo agaa muma lagisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Go pisa rabu nipumi neme Yesu ora re-para puma piruma talo: Mudu Ali, nemere aapi-para lae ya? ");
INSERT INTO kjs_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesumi talo: Neme oge bret sapalae katoa aliri go ali yaade. Go lomare oge bret muma Judas kalisa. Go aliri Saimon Iskariot-na si pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas-me mo eda misa rabu Satan wagepu nipuna lo robaa-para pua kodobasa. Go rabu Yesu nipu-para talo: Neme yada pulalo pali-daare wagepu pape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Go lisa pare nimumi go agalena re waru napagesimi. ");
INSERT INTO kjs_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas nipu kana paus surube ali yaa-pulu nimumi Yesumi Judas ekera yawape eda kabola penaalo laketa kone wisimi. Gupi ta paleme medalomame Yesumi Judas madaa naarali enaalinu ele kata penaalo ta kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pare Judas go eda muma lisana kamaa-nane wagepu pisa. Go rabu ribaa mogolisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas penaaloma Yesumi talo: Abiri ni enaalinu Raapu Pirape Alina Siri nipuna epe paana puri maa waatea-daa adalimina. ");
INSERT INTO kjs_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Gore Gote-me nipuna epe paana puri ni madaa waatea-le ni enaalinu Raapu Pirape Alina Si mada adalimina. Ora abi go nipumi waatea lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Go rabu Yesumi talo: Naa naakinu, abi oge rudupu yapi di-na piramina. Werepe nimimi ni asapalimi pare ni paluade su-para mada na-epalimi. Go agalere abalade Juda enaalinu page lagelisuade. ");
INSERT INTO kjs_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Abiri neme nimi kagaa rekena agale lagialo. Neme nimi madaa raana komalo kone wia-rupare nimina yagonu raapu kone komea go-rupa suma piralepape. ");
INSERT INTO kjs_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nimimi enaali madaa ranaa komo raana komalimiri pa enaali raayome nimiri nina disaipel ali-rupa pirualimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita-me Yesu-para talo: Mudu Ali, nere aa-para pali pae? Yesumi talo: Ni palua-parare neme ni mada naraita mea epali pare werepe mada raita mea epali. ");
INSERT INTO kjs_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Go lisa rabu Pita-me agale gu-rupa misa: Mudu Ali, ne raapu abi mada napalipa ya? Nimumi ne lu makomalimiri ni page lina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesumi talo: Neme ni madaa ora mada komalua lo ora lale palo maarea. Neme ne ora lagialo: Yaa gula mupaa narekena neme nina bi rana repo ni namakuaayo te lisa. ");
INSERT INTO kjs_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesumi nipuna disaipel alinu-para talo: Nimina lo robaa-para kone adaapu nasuma kedaame komape kone page nasalepape. Nimimi Gote madaa kone rulaoma ni madaa page kone rulaalepape. ");
INSERT INTO kjs_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naa Aapana ada adaapu aaya-le nimina ada robe ameke puma kiritao saata palua. Neme makirae agale nalagialo. ");
INSERT INTO kjs_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nimina pirape su puma makiritaoma sumare nimi mulalo epalua. Go pea-le naa raapu piramina. ");
INSERT INTO kjs_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni palua-para nimimi pora mada adoma epalimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas-me Yesu-para talo: Mudu Ali, ne pali-parare abi namakuaatema. Akea puma naame adoma pamualima ya? ");
INSERT INTO kjs_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesumi nipu-para talo: Niri nimina epape pora page ora agalena re page ade abuna kagaa piraamala popena re page. Ni komea go-rupa pe-pulu enaali medame pora rado meda asa pumare Aapa piri-para mada napalia. ");
INSERT INTO kjs_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nimimi ni ademe-pulu nina Aapa page mada adalimi. Gore abi ripia pumare nimimi Aapa adoma nipu makuaaba piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip-mi Yesu-para talo: Mudu Ali, neme Aapa naa walaina naame nipu komea adoma raaname komamona. ");
INSERT INTO kjs_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesumi talo: Nimi raapuri koro adaapu piruaaripude. Gore Filip neme ni waru na-adae lisa. Ali medame ni adea rabu Aapa page adea. Go pea-le ake pea-daa neme ni Aapa waalaina lae ya? ");
INSERT INTO kjs_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Gore Aapa saa meda pipa-para kone narulaaye? Neme lagiawade agalere nina agale-daa dia. Aapa ni raapu piruma nipuna kogono pea. ");
INSERT INTO kjs_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aapa saa komea-para pirapa lo lagiawade-le go-ai madaa kone narulalimiri gore napi kogono neme pisuade madaa kone rulaalepape. ");
INSERT INTO kjs_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neme nimi-para ora lagialo. Enaali raayome ni madaa kone rulalimiri neme pe kogono-rupa palimi. Nimumi go-rupa pumare kogono adaapupe rado meda page mada palimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nimimi nina bi madaa ali agale mealimiri go elenu mada gialua. Gore Aapana epe paana puri nipuna Si mada epenalea-le adalimina. ");
INSERT INTO kjs_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nimimi nina bimi beten lemere neme ele mada gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nimimi ni madaa ranaame komalimiri nina agale mana waru raitalepape. ");
INSERT INTO kjs_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neme aapa-para agale mealua-le nipumi nimi raba meape ali meda mea epenalea. Go aliri ora agalena Holi Spirit yaa-pulu ade abuna nimi raapu komea-para piralia. ");
INSERT INTO kjs_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pa su kamaa enaalinumi nipu na-adoma namakuaaeme-pulu mada namealimi. Pare nipu nimi raapu piru lo robaa-para rubitabalia-pulu nimimi nipu mada adalimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Gore ni palua rabu nimi kama napiralimi. Niri nimi piri-para wala epalua. ");
INSERT INTO kjs_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wala werepe oge-daa go su kamaa enaalimi ni wala na-adalimi pare nimimi ni mada adalimi. Go rabu neme ade abuna pitua-pulu nimi page go-rupa ade abuna piralimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Go di raburi nimimi ni Aapa raapu piralipa-daa adalimi. Nimi ni raapu piralimiri ni page nimi raapu piramina. ");
INSERT INTO kjs_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Enaali raayome nina kagaa agale mana pagoma mogealimiri nimumi ni madaa ranaame komalimi. Go puma ni madaa raaname komape enaalinuri Aapame page nimu ranaame komea. Go puma neme nimu madaa ranaame komoma nina kone mea waatoa. ");
INSERT INTO kjs_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Go rabu Judas medame nipu Judas Iskeriot ali-daa dia nipumi talo: Mudu Ali, nena kone naa-para mea waalale pare ake pea-daa pa su kamaa pimi enaalinu page nawaale? ");
INSERT INTO kjs_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesumi talo: Gore ali medane ni madaa raaname komalia-daare nipumi nina agale mogealia. Go palia-pulu Aapame page go ali madaa ranaame komalia. Go pea-le Aapa saa go ali nipu piri-para puma nipu raapu piralipa. ");
INSERT INTO kjs_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Enaali raayome ni madaa ranaame nakomalimiri nina agale napageme. Go pea pare go pagamede agalere ora nina-daa dia yapare Aapame ni mea rapaaoma lagisa. ");
INSERT INTO kjs_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","26","Go nimi raba meape aliri Aapame ni madaa alopae ali meda epenalea. Go aliri Holi Spirit yaa-pulu nipumi nimi ele raayo mogeaoma neme abala lagi agale page nimina kone-para maa saapiralia. ");
INSERT INTO kjs_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Niri nimi giyoma nimi kuma pi kone lo robaa-para winalo gialua. Neme go kuma pi kone gialo pare go su kamaa piri enaalinumi nimi guaaeme-rupa naguaayo. Go pea-le kone adaapu nasu paalame nakomalepape. ");
INSERT INTO kjs_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni palua pare nimi piri-para wala epalua lagiawade agalere abala pagemede. Nimimi ni madaa ranaame komola peme yaalore ni Aapa piri-para palua-pulu nimi ranaame komalimina. Naa Aapa ali mudu yaa-pulu nimimi go madaa pedo peme. ");
INSERT INTO kjs_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gore abi agale go lagialo-le apo epapede di epalia rabu nimi ni mada kone rulalimi. ");
INSERT INTO kjs_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Go su kamaa nimi raapu agale adaapu nayoloma lagialua. Dia-le go su kamaa piri enaalinuna ali mudu Satan epalia. Go pea pare nipuna purimi ni mada narabuainalia. ");
INSERT INTO kjs_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gore neme Aapana agale raayo moge aayo pare su kamaa piri enaalimi neme Aapa madaa ranaame komalo-daa makuaamina. Yapare baina rekalepa. Naa go su giyoma baina. ");
INSERT INTO kjs_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesumi talo: Niri ora wain. Naa Aapare nipu pia pare nina wain kope surubape maapuna aaraa pia. ");
INSERT INTO kjs_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gore nina kope palaa raayome kili namaitiare Aapame go kope palaa pona lu rubea. Pare medalomame kili adaapu elea-pulu Aapame go palaana rikilinu raayo yadea. Go pumare go palaame epe-rupa aoma kili ora adaapu matia. ");
INSERT INTO kjs_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Neme nimi-para agale abala lagisuade-pulu nimi repena palaa koe-rupa aalimina yado rubuma maa epe aaripude. ");
INSERT INTO kjs_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ni nimi raapu pirumare naa ade abuna epe-rupa piramina. Naa gu-rupa napiralimare nimi kili namaitimi. Go palaare repena madaa waru na-opaliare nipuna kili page mada ma-elaalia. ");
INSERT INTO kjs_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Niri repena ria pi pare nimiri go repenana palaa pimi. Ali meda ni raapu piralia-daare go alimi nina agale pagoma nipuna kili madea. Go puma nimimi go kogono komea raapu napalimi. ");
INSERT INTO kjs_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ali medame saa raapu napiralipa-daare go aliri pa repena palaa-rupa yado rubalia. Go pumare kaapu lenalomare nimu maa puma kiritaoma repena sulaa-para kiralia. ");
INSERT INTO kjs_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Go pea pare nimi ni raapu piruma nina agale pago piralimiri gore nimina raana madaa beten leme ele mealimina. ");
INSERT INTO kjs_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Gore nimi opoma kili waru maitialimi rabu nina Aapana bi minasaalimi. Go palimiri nimi nina disaipel enaali-rupa piramina. ");
INSERT INTO kjs_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aapame ni madaa ranaame komea-rupare neme nimi madaa page go kone mapiraayo. Nimimi go kone muma saapiralepape. ");
INSERT INTO kjs_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nimimi nina agale pago piralimiri nina ranaa komape kone ru-para pimi. Gore neme Aapana agale pago nipuna ranaa komape kone muaayo-rupa mealimina. ");
INSERT INTO kjs_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","12","Naa agale manare gu-rupa: Neme nimi madaa ranaame kome-rupa nimina ame balinu madaa page ranaame komape kone mealepape. ");
INSERT INTO kjs_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ali medame nipuna adami ali madaa ranaa komo raana waru komaliare adami ali lu makomaatalo palimi rabu page nipu tyalepa teare gore ora epelea pea. ");
INSERT INTO kjs_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gore nimimi nina agale pagalimi-daare nina adami enaali piramina. ");
INSERT INTO kjs_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Go pea-le pagalepa. Kogono pi alinuri nimumi nimuna surube alina kone na-ademe. Go pea pare Aapame ni lagi agale raayo nimi lagiawade-pulu neme nimi-parare adami alina bi toa. ");
INSERT INTO kjs_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nimimi ni abalade namapiraasimi pare neme nimi abala nina epe kogono mapaaoma kili adaapu madialiminalo mapiraasuade. Go epe kogonona kilinu ade abuna pa madu aalia. Go pea-le nimimi nina bi madaa beten lemere Aapame go ele gialia. ");
INSERT INTO kjs_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Go pea-le neme go agale mana lagialo: Nimina ame balinu madaa ranaame komalepape. ");
INSERT INTO kjs_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Gore su kamaa enaalinumi nimi madaa pu nimu-para koe rero pi kone salimiri nimumi ni madaa page go kone abala wisimi-le makuaalepa. ");
INSERT INTO kjs_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gore nimi go su kamaa enaalina ruru pimi-daare nimumi ora raaname komena nimuna si wane-rupa piramina. Yapare nimi su kamaa pirisimi rabu neme nimi yaaloma rado-rupa mapiraasua-pulu go enaalinumi nimi madaa koe kone wimi. ");
INSERT INTO kjs_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Neme abala lagiawade agale pagalepa: Gore kogono alimiri nipuna Mudu Ali mada narabuainaaya. Go pea-le nimumi ni taelo pisimi-pulu nimi page taelo palimi. Nimumi nina agale pagalimiri nimina agale page mada pagalimi. ");
INSERT INTO kjs_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Gore nimiri nina kone rulae enaali yaa-pulu nimumi nimi page tyalo palimi. Naa Aapame ni mea rapaasa-daa namakuaaoma peme. ");
INSERT INTO kjs_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Neme nimu-para agale nalakeloma pola pisua yaalore nimuna pupitagi ne kone nasaapiruma peme. Yapare ni ipuma lakalisuade-pulu nimuna pupitagi ne kone saapiruaeme. ");
INSERT INTO kjs_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gore ali medame ni madaa yada lore ali aulaalia-daare naa Aapa page go-rupa yada lore ali aulaalimi. ");
INSERT INTO kjs_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neme nimu piri napi kogono ora rado-rupa napula pisua yaalore nimuna pupitagi ne kone nasaapiramala palimi. Pare nina kogono adisimi pare nimumi ni-para naa Aapa saa raapu yada lore ali auloame. ");
INSERT INTO kjs_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yapare go-rupa pea-le nimuna rekena agale madaa abala lisimide-rupa abi epaade: Nimumi pa kamaa ni madaa rono page kone su aaeme pepa madaa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Gore nimina raba meape aliri Aapa raapu piruma epalia. Nipu ora agalena Holi Spirit yaa-pulu Aapame maa rapaalia rabu nimi piri-para epalia. Neme nipu Aapa piri-para maa penaatoa-pulu nipumi ni madaa agale lagialia. ");
INSERT INTO kjs_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gore nimi page abala ririna ni raapu piruma abi page go-rupa pima-pulu nimimi page ni madaa agale lakelapape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nimimi epe kone rulae agale nagiyaliminalo agale abi lagiawade. ");
INSERT INTO kjs_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Werepe nimumi nimi lotu ada kamaa ralu timi. Werepe yapi di meda epalia rabu nimi lu makomalimi-daa ora naame Gote-na kogono pema kone suma palimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nimumi Aapa saa laapo na-ademe-pulu go lawade-rupa palimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pare neme go agale lagialo-pulu nimuna palimide yapi di epalia rabu nimimi go agalena re makuaaba piramina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Abala ririna nimi raapu epa pirisuade rabu go agale nalagisuade. Pare abi nipumi ni abalade maa rapaasade-para palua. Go palua pare nimina rikiranare ali medame ne aa-para pali palo agale nameme. ");
INSERT INTO kjs_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Abala lagiawade-pulu nimina lo robaa-para kedaame komoma pimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yapare neme nimi ora agale lagialo: Neme nimi giyoma paluare epelea. Ake pa epelea toa ya? Gore ni napaluare raba meape ali na-epalia. Pare ni palua-le nipu nimi piri-para mea epenatoa. ");
INSERT INTO kjs_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Gore nipu epalia rabu su kamaa piri enaalinumi pupitagi ne kone-para redepo le kone-para Gote-na kose lape agale-para go raayona re makuaaliminalo nipumi mea waatea. ");
INSERT INTO kjs_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gore su kamaa piri enaalinumi ni madaa kone narulaeme-pulu nimimi pupitagi nape konena re na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Go puma ni Aapa piri-para ponoloma nimimi ni na-ademe-pulu nimumi redepo le konena re na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Go puma go su kamaa piri ali mudu Satan madaa kose lape agale abala lakalisade-pulu nimumi kose lape konena re na-ademe. ");
INSERT INTO kjs_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nimi agale adaapu lagialua pare nimimi mada napagalimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yapare ora agale le Holi Spirit epalia rabu nipumi ora agalena re raayo mea waatea. Nipumi agale lagialia rabu nipu agale natea. Dia, pare agale lagialia rabu nipumi pagaliade agale-para werepe epaliade ele-para lagialia. ");
INSERT INTO kjs_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nipumi nina agale pagoma nimi lagialia-pulu nipumi nina bi minasaalia. ");
INSERT INTO kjs_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aapana ele raayore nina saapiruaayo-pulu neme nimi abala gu-rupa lawade: Neme Holi Spirit lakale agalere nipumi nimi maa lagialia-daa makuaalimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yapi di rudu rabu nimimi ni na-adalimi pare wala werepe ogesi-daa piruma nimimi ni wala adalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Go lisa-pulu disaipel ali medalomame nimuna yagonu-para agale gu-rupa lisimi: Go lea agalena re-re ake pu lea pae? Nipumi gu-rupa laade lisimi: Werepe ogesi-daa piruma nimimi ni na-adialimi laade pare werepe wala nimimi ni adalimi laade lisimi. Go page nipumi gu-rupa laade: Naa Aapa piri-para palua-pulu go agale lagialo laade lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Go laade-le go agalena re akepu ya? Go agalena re naa maarea lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesumi nipu agale mulalo pisimi-daa adisa rabu nipumi nimu gu-rupa lakalisa: Gore werepe nimumi ni ogesi-daa piruma na-adalimi pare werepe wala nimimi ni mada adalimi lawade. Apo agale madaa agale mulalo pimi pae? ");
INSERT INTO kjs_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neme nimi-para ora lagialo. Nimimi kodo adaa komoma re adaa leme pare go su kamaa piri enaalimiri raaname komalimi. Nimina lo robaa-para kedaa palia pare werepe nimina lo robaa-para wi kone perekelema wala raaname komalimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Go-rupa lisa: Nogo naaki madialimi rabu enanumi nimuna madini di rudu lea rabu enanuna pu robaa-para kedaa pea. Pare nimumi mo nogo naaki madu sumare pedo pedo puma kedaa pi kone nasalimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Go-rupa abi nimuna lo robaa-para kedaa palia pare neme nimi wala adalua rabu nimi raaname komalimi. Gore nimimi raaname komalimi rabu ali medame go raana komape kone mada namu palimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Go yapi di epalia raburi nimimi ni-para ele meape agale nateme. Neme nimi ora lagialo: Nimimi aapa-para nina bina beten lemere Aapame go ele gialia. ");
INSERT INTO kjs_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Abaladere nimimi nina bi madaa beten nalisimide. Go pisa pare abi agale mealimina go ele gialia rabu nimina lo robaa-para raaname waru komalimi. ");
INSERT INTO kjs_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Neme saa pi agaleme abala lisuade. Go pea pare werepere saa pi agale madaa natoa. Go rabu Aapana ora agaleme lagialua. ");
INSERT INTO kjs_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Go yapi di epalia raburi nimimi nipu-para nina bimi beten lamina. Gore nimimi beten leme rabu nimi raba minalo neme beten ake pea-daa toa ya? ");
INSERT INTO kjs_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aapare nipu nimi madaa ranaame komea-pulu nimi nagialia. Nimimi ni madaa raaname komena ni Aapa piri-para ipisua-daa kone rulaarimi-pulu Aapame go kone wia. ");
INSERT INTO kjs_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gore Aapa piri giyoma su kamaa ipisuade-le abiri su kamaa giyoma Aapa piri wala palua. ");
INSERT INTO kjs_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Go rabu nipuna disaipel alinumi nipu-para talo: Abiri neme saa pi agale nalae pare agale epe-rupa lagiaede. ");
INSERT INTO kjs_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Abiri neme ele raayo lagiade-ai makuaatema. Go pea-le ali medame agale wala mada namealia. Go pea-pulu ne Gote raapu piruma giyoma ipiside-ai kone rulaema. Yesumi talo: Abi kone waru narulaeme lisa? ");
INSERT INTO kjs_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","32","Pagalepa. Abi yapi di apo rudu yala-daa nimimi ni piri-para giyomare nimina ada komea komea pogola puma piralimi. Go rabu ni kama raapu pitua. Yapare Aapa saa pipa-pulu ni komea napi. ");
INSERT INTO kjs_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Gore nimi ni raapu piruma nimina lo robaa-para kuma pi kone winalo apo agale lagiawade. Go su kamaa piri enaalinumi nimi kedaa waru gialimi-le paalame nakomalepape. Neme go su kamaa piri enaalinuna koe kone mea rubalua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesumi agale loma lisana so yaa-para adasaaoma talo: Aapa, nina yapi di rudu yala. Neme nena Si ni-para epe paana puri giali-li neme page ne puri gialua. ");
INSERT INTO kjs_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gore neme su kamaa enaali raayo surubape kogono giside-pulu nena giside enaalinu ade abuna kagaa piramala pope kone kalaayo. ");
INSERT INTO kjs_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ade abuna kagaa piramala pope agalena re-re gu-rupa: Enaalinumi ne ora Gote komea kone rulaoma neme ni rapaaside Yesu Keriso madaa page kone rulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neme nina kogono pu kiritasua-pulu nena epe paana puri mea waalisuade. ");
INSERT INTO kjs_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aapa-ya, abala su yaa laapo wari pirisipa-rupare nina epe paana puri misuade-rupa abi wala giaina. ");
INSERT INTO kjs_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Go su kamaa piruma nena disaipel enaalinuri neme ni giside-pulu neme nena bi lakelalo kiritasuade. Nimu nena enaalinu yapare neme abala rumaaoma giside. ");
INSERT INTO kjs_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gore nimumi nena agale pago mogesimi-pulu neme ni ele raayo gisi-daa abi makuaaeme. ");
INSERT INTO kjs_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neme agale ni gisidere nimu abala lakalisua rabu nimumi go agale madaa kone rulaeme. Abalade ne raapu piruma ipisuade-pulu nimumi ora agale makuaaoma neme ni mea epenaliside-daa kone rulaeme. ");
INSERT INTO kjs_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Neme nimu madaa beten gu-rupa laalua: Neme pa su kamaa enaali madaa beten na-laato pare neme giside enaalinuri nena enaalinu yaa-pulu nimu madaa beten loaayo. ");
INSERT INTO kjs_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Neme kone rulae enaaliri neme surubano-le neme nina kone rulae enaali page surubaina. Go pea-le abi go enaalinumi nina bi minasaaeme. ");
INSERT INTO kjs_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Abiri ne piri epalua-le ni su kamaa piri ali dia yapare go enaalinuri su kamaa pimi. Ora epe Aapa-ya, nena puri pale bimi nimu surubape. Saa pirapade-rupare nimu page naa komea-rupa piramina. ");
INSERT INTO kjs_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nena bi giside-le enaali raapu pirumare neme nena bina purimi surubisuade. Neme nimu surubisua-pulu nimu komea-daa na-alupalimi. Nena buk madaa abala lisa-rupare ali komea nipu abala alupasa. ");
INSERT INTO kjs_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Abiri ne piri epalua pare go su kamaa piri enaalina lo robaa-para ni madaa raana waru komalimi-pulu go agale lagialo. ");
INSERT INTO kjs_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neme kone rulae enaalinu-para nena agale lagisuade rabu go su kamaa enaalinumi rono pagesimi. Gore kone rulae enaalinuri ni raapu pimi-pulu go su kamaare ora nimuna adare-daa dia. ");
INSERT INTO kjs_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gore abi neme kone rulae enaalinu so yaa-para maa epainalo ne agale go-rupa nalorapealo. Dia, pare neme nimu waru surubaina Satan-me nimu mada nama-bebolaainalo beten loaayo. ");
INSERT INTO kjs_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ni page nimu page naana ora adare go su kamaa-daa dia-le naana adare ora yaa-para aaya. ");
INSERT INTO kjs_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nena agalere ora agale ria yaa-pulu go agaleme nimu ne raapu mada mapiraalia ");
INSERT INTO kjs_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Abalade neme ni su kamaa maa rapaaside-rupa neme nimu su kamaa piri enaali-para epe agale lakelapape loma lagisuade. ");
INSERT INTO kjs_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Neme nimu ora nena si wanenu piramina kone suma ni maa pu lo ne lagialo. ");
INSERT INTO kjs_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pare neme go enaali komea madaa beten nalaayo. Dia, pare enaali raayome epe agale pago ni madaa kone rulaeme-daa beten loaayo. ");
INSERT INTO kjs_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aapa-ya, saa pirapanare nimu page piramina. Go pumare su kamaa enaalimi neme ni maa epenalisi-daa kone rulalimi. ");
INSERT INTO kjs_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neme ni giside epe paana puri komea-rupa nimu kalisua-pulu saa komea pirisipa-rupa nimu page lo robaa komea-rupa su piralimi lo beten loaayo. ");
INSERT INTO kjs_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Saame nimu raba muma pirina labana. Saa pipa-rupare nimuna lo robaa komea-rupa su pirina lapana. Go pea-pulu su kamaa enaalinumi neme ni mea epenaliside makuaalimi. Go page neme ni madaa ranaame kome-rupa nimu madaa go kone saena. ");
INSERT INTO kjs_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Gore Aapa-ya, Nemere abala go enaalinu ni giside. Go pea-le ni piri-para epalimi rabu nimu saa raapu piramina kone salo. Go rabu neme epe paana puri ni giside-daa go paa ade. Gore su yaa nawarisua rabu neme ni madaa ranaame komiside. ");
INSERT INTO kjs_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Gore redepo le Aapa-yo, su kamaa enaalinumi ne na-ademe. Go pea pare neme ne ade-rupa kone rulae enaalimi page ne ademe. ");
INSERT INTO kjs_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neme nena kone-rupa muma nimu laketalo pu pitua. Go pumare ni madaa ranaa komo raana komape-rupa nimu page mogeleme. Go pumare ni nimu raapu pitua. ");
INSERT INTO kjs_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesumi beten abala lomare nipuna disaipel alinu raapu go su giyoma oge ipa Kidron pua kenaasimi. Go su-parare maapu meda wisa-le Yesu nipuna disaipel alinu raapu go maapu-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuna disaipel alinu raapu mo maapu-para abala kiritasimi-pulu Yesu madaa koe makirae ali Judas-me page mo maapu abala adisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juda ali medaloma maapu-para lamua pisa. Go ipisimi alinuri soldia alinu-para lotu ada surube plisman-nupara nimu Judas raapu pisimi. Go surube alinuri Gote-na lodo kira-ae ali mudunu-para Farisi alinumi page maa rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesumi ele raayo nipu madaa nipumi adisa-pulu nipumi go aasimi alinu-para talo: Gore nimimi aapi asapimi? ");
INSERT INTO kjs_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nimumi talo: Nasaret su-para piri ali Yesu lisimi. Nipumi talo: Ni yaade lisa. Go rabu yada robe ali Judas nimu raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Gore Yesumi ni yaade lisa rabu nimu pogolasaoma lisimina su kamaa lopesimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesumi nimu wala agaa misa: Nimiri aapi asapimi pae lisa. Nimumi talo. Nasaret su-para piri Yesu lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesumi talo: Nimiri ni asapimi-daa lagiawade. Nimimi ni adaarimi-le go disaipel alinu maa penaatapa. ");
INSERT INTO kjs_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesumi gu-rupa lisa: Aapa, neme giside enaalinuri ora komea na-alupalimi. Nipumi nimu go abala lakale agalena re ora adaminalo nimu maa penaatapa lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Go raburi Saimon Pita-me nipuna rai kudu muma Gote-na lodo kira-ae ali muduna kogonome adili naaki meda nipuna kale popo ki-nane pona lu rubisa. Go kogono adili naakina biri Malkus. ");
INSERT INTO kjs_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Go pisa-pulu Yesumi Pita-para agale gu-rupa lakalisa: Neme mo rai kudu nipuna ada-para wala paba. Naa Aapame ni maa gi kap-na kedaa pi elere mada nanalua kone sale ya? ");
INSERT INTO kjs_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Go raburi soldia alinuri nimuna surube ali mudu page Juda alinuna plisman-nu page nimumi Yesu ripinaaoma kopeme rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Go puma Anas piri-para maa pisimi. Go maali ru-nanere Kaiafas nipu Gote-na lodo kira-ae ali mudu pirisa. Nipuri Anas-na kasua pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Go alimiri abala Juda alinu-para gu-rupa lakalisa: Ali medame enaali raayo raba mulalo nipu komalia-daare ora epelea lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita Jon saa laapome Yesu raita maa pisipa. Gote-na lodo kira-ae ali mudumi nipu abala waru adisa-pulu ni Yesu raapu ni Mudu Ali-na ada perali pua pirisipa. ");
INSERT INTO kjs_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Go pisa pare Pita kamaa-nane pora gaape regepea pirisa. Go rabu nipu Gote-na lodo kira-ae ali mudumi adisa-pulu nipu kamaa-nane wala puma mo pora gaape surube ena agale lakalisa. Go rabu nipumi Pita ru-nane maa ipisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Go rabu pora gaape surube ename Pita-para gu-rupa lakalisa: Ne page mogo Yesuna disaipel ali kone salo. Pita-me talo: Ni-daa dia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Go rabu ora kupaa pisa-daa kogono alinumi page plisman-numi page repena meda kirita adisimi. Go pea-pulu Pita nipu nimu piri-para puma rekaoma repena adola pisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Go raburi Gote-na lodo kira-ae ali mudumi Yesu-para nipuna disaipel alinu madaa nipuna moge ria-ae agale page lorapisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesumi talo: Neme pagaa wi kone nawi. Naa disaipel alinu agalere lotu ada-para Juda alinu kiritasimi rabu go-para lakalisua. ");
INSERT INTO kjs_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Go pawa-pulu ake pea-daa ni agale lorapae la? Agale pagemede enaalinu agaa meape. Abalade nimumi nina agale pagisimi-pulu nimu agale lorapea. ");
INSERT INTO kjs_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesumi go-rupa lisa rabu polisman medame Yesu kimi paara luma lisana talo: Ake pea Gote-na lodo kira-ae ali mudu-para ero agale lae pae? ");
INSERT INTO kjs_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesumi talo: Neme agale koe laware go piri enaalinu-para go agale laketapape. Yapare neme ora agale lakelawa-le niri ake pea-daa tyae ya? ");
INSERT INTO kjs_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Go lisa rabu nipu pena adibaina Anas-me Gote-na lodo kira-ae ali Kaiafas piri-para maa pisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita piruma repena adola pirina go pirisimi ali medalomame nipu-para talo: Go ali page nipuna disaipel ali kone wima lisimi. Pare Pita-me makirae agale gu-rupa lisa: Ni-daa dia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Go puma Gote-na lodo kirae ali muduna kogono ali medame Pita adoma talo: Nere neme adawade rabu nipu raapu mo maapu aaripide kone salo lisa. Go lisade aliri abalade Pita-me kale ponapo lu rubisa alina ruru piri ali yaa-pulu adisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Go rabu Pita-me wala talo: Ni-daa dia lisa. Go lisa rabu yaa kokolo rekoma agale lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Go rabu nimumi Yesu mumare Kaiafas-na ada giyoma mo nambawan gavman-na ada maa pisimi. Gore ora yapi lapaasa rabu Juda alinumi yogale koto napinalo ruru rado piri gavman madaa niti puma ru-nane napisimi. Yogale koto pi yaalore Juda alinumi Pasova eda mada naneme. ");
INSERT INTO kjs_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Go pirisimi rabu ali mudu Pailat-me nimu madaala puma kamaa-nane aaoma talo: Go aliri ake pea-daa adialalo pimi pa lisa? ");
INSERT INTO kjs_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nimumi talo: Go alimiri koe ele meda napula pa yaalore ne piri-para mada nama-epola pama lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat-me nimu-para talo: Gore nimimi nimina nipu maa epame-rupa nimina kose lape agale nipu madaa tapape. Gore nimina kogono lisa. Pare Juda alinumi talo: Gore naame ali meda lu makomapenare rekena agale wia-pulu mada natalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Go agale madaare abalade Yesumi nipuna komape agale lo mapaitasa lisa-rupa lakalisa-pulu abi go agale ora ya talo pisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Go raburi Pailat gavman ada ru-nane wala puma Yesu-para talo: Nere Juda alinuna ali mudu? ");
INSERT INTO kjs_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesumi talo: Go laede agalere ora neme lae palo ali medalomame lagiame-daa lae ya? ");
INSERT INTO kjs_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat-me agale gu-rupa abulisa: Niri Juda ali pi kone sale ya? Gore nina ruru-para nimuna lodo kirae Ali mudunu page nimumi ne ni piri-para maa epame yaade. Go pea-le abalade neme ake pisa pae? ");
INSERT INTO kjs_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesumi talo: Naa surubape suri go su-daa dia. Go su kamaa enaali surubola pulape yaalore naa disaipel enaalinumi ni raba minaloma yada pula peme. Go pula pema pare Juda alinumi ni madaa namealimi. Dia, su kamaare nina surube su-daa dia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Go lisa-pulu Pailat-me agale gu-rupa misa: Nere enaali raayona ali mudu yapae lisa. Yesumi talo: Nena laede-le ni ali mudu pi. Gore neme ora agale lakelalo pare amame ni maitana rabu go su kamaa epa piruma go kogono komea pe. Go puma enaali raayo ora agalena pora mogealimiri nina agale pageme lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Go raburi Pailat-me talo: Ora agalere ali ya? Go raburi Pailat kamaa-nane puma Juda enaalinu piri-para puma talo: Neme go alina koae meda na-adawade. Ake pea lu makomalepape toa ya? ");
INSERT INTO kjs_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Go raburi nimumi aapa kasuanuna kone moge Pasova Yapi di rabu karapo ada pali ali meda penalo pisimi. Go pea-le Pailat-me talo: Go Yesu Juda alinuna ali mudu kepeano yapae abi tyapa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Go rabu nimumi puri paloma gu-rupa lisimi: Go ali ora dia. Mo ali Jisas Barabas kepe rapaaina. Go ali Jisas Barabas-re nipumi pora pamuma enaali luma ele paake no pisa pare go ali kepe rapaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Go lisimi rabu Pailat-me Yesu mea epenalisa rabu aipuyame kudu lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Go rabu soldia alinumi kope keto-keto raguna meda waruma Yesuna kalu madaa ma-adipasimi. Go pumare nimumi mamina kale-ai muma Yesu madaa maraasimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Go puma nimumi nipu-para talo: Juda alinuna ali muduri abi epe-rupa pirape lisimi. Go lomare mo Yesu nipu ki paarame puma lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat-re nipu ada giyoma wala kamaa puma lisana talo: Adalepa. Nipu madaa koe elenu meda na-adalo-pulu nipu kamaa-nane lamua epalua-daa adamina lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Gore Yesu nipu kamaa pumare nipuna kope keto-keto raguna ma-adipae-para kale mamina-para page maraasa. Go rabu Pailat-me enaalinu lakalisa: Go ali adalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gore Gote-na lodo kira-ae ali mudunu-para plisman-nupara go raayome Yesu adoma gu-rupa lisimi: Nipu repena polopea madaa nil-mi taminapa. Nipu repena polopeana nil-mi taminapa lisimi raburi Pailat-me nimu-para talo: Gore nimina kogono-le muma repena polopea madaa nil-mi tyalepa. Nipu madaa koe ele meda na-ade-le nimina mea tyalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda alinumi talo: Naana rekena agale madaare go ali nipu Gote-na Si lea-pulu naame rekena agalena pora raluma nipu lu makomalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat-me go agale pagomare paalame waru komisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nipuna gavman ada ru-nane pumare Yesu-para talo: Nena suri aa-para piruma epae? Pare Yesumi agale na-abulisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Go puma Pailat-me nipu-para talo: Ake pea ni agale nalagiae ya? Ni ali mudu yaa-pulu ne mada mea rapaao ne repena polopea madaa tyaminalo page neme mada toa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesumi talo: Gote-me ni surubenalo puri gula pisa yaalore neme go-au mada pula pisua. Go pea-le abalade ni ne piri-para mea epamede aliri nipuna pupitagi ne kone ora adaalepe saapia. ");
INSERT INTO kjs_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat-me go agale pagoma kone adaapu suma Yesu rapaalua kone wisa. Pare Juda alinumi gu-rupa yaaloma talo: Neme go ali rapaaliri ne ora nambawan gavman Sisar-na adami ali-daa dia lisimi. Go aliri nipu ali mudu laa-pulu nipuri Sisar-na yada lore ali pia lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat-me go agale pagomare nipumi Yesu so kamaa-nane lamua ipisa. Go pumare nipuna kose pagape siaa madaa pua pirisa. Go pirisimi su madaare biri Kaname Warili Pora lisimi. Juda alinuna Hibru agale madaare Gabata bi maasimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Go pirisimi rabu naare rikirana aaina ekera adaa eda Pasova nape yapi di epalia. Go rabu Pailat-me Juda alinu-para talo: Nimina ali mudu adalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nimumi puri paloma gu-rupa yaaloma talo: Nipu tyamina nipu tyamina pu lisimi. Repena polopea madaa nil-mi tyaminapa lisimi. Pailat-me nimu agale gu-rupa lakalisa. Gore nimimiri nimina ali mudu repena polopea madaa lu makomamina kone saleme? Go lisa rabu lodo kira-ae ali kalunumi talo: Ora ali mudu komea pia go aliri Sisar yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Go rabu Pailat-me Yesu maa puma kalisa rabu repena polopea madaa tyalo maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Go puma nimumi Yesu maa pisimi. Maa pisimi rabu Yesu repena polopea mariaoma lamua pisimi. Go pumare nipu su rado-para maa pisimi. Go pirisimi suna biri Ali Kalu Rogaae Su leme. Go suri Hibru agalemere Golgota bi maasimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Go su-parare nimumi nipu repena polopea madaa nil-mi lisimi. Lisimi rabu koe ali laapo page repena polopea madaa luma Yesuri rikirana lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Go rabu Pailat-me pepa meda luma so repena polopea kunina mudiasa. Go pepa madaa agale gu-rupa luma mudiasa: Nasaret su-para piri Yesuri Juda alinuna Mudu Ali yaade. ");
INSERT INTO kjs_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gore Yesu nipu lisimi-parare adare adaalepe meda re-para aasa-pulu Juda adaapumi mo pepa yarepealisimi. Go pepare Pailat-me Juda agale-para Rom agale-para Grik agale-para lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gu-rupa linaloma lodo kira-ae Juda ali kalunumi Pailat-para talo: Gore nipu Juda alinuna ali mudu lo pepa madaa nalu saabape lisimi. Pepa gu-rupa tyape lisimi: Go alimi talo: Ni Juda alinuna Mudu Ali yaade laa tyape lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Go lisimi pare Pailat-me talo: Mo pepa madaa tyawade agalere naperekealepape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mo soldia alinumi Yesu abala repena polopea madaa lu makomaoma lisimina mo Yesuna mamina rekelepuma malaapu rumaasimi. Go puma edali rili ali maalapu pirisimi. Nimumi nipuna mamina misimi pare go mamina rabula pala yai-daa dia. ");
INSERT INTO kjs_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Go pea-le soldia alinumi talo: Go mamina-re adaalupe yaa-pulu nariripiamina. Go mamina satu luma ali komeame mina lisimi. Go pisimi-daa Gote-na agale wi buk madaa agale gu-rupa wisa: Nimumi nina mamina ele maa rumaaoma go madaa satu luma misimi. Pepa madaa gu-rupa lisa-pulu soldia alinumi go-rupa pisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lisimi rabu go alinu nimu Yesuna repena polopea re-para puma rekaasimi. Yesuna agi-para nipuna papa-para nipuna agina yago Maria laapo page go raayo pirisimi. Go yago laapo medare komea Klopas-na were pirina medare nipuna bi Maria Makdala bi ma-aasimide ena pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gore Yesumi nipuna agi aaraa Jon laapo adoma agi-para talo: Go ena gore nena naaki lisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Go lomare Jon-para talo: Go enare nena ama pia. Go lisa-pulu neme nipuna agi nina ada-para lamua puma pisua. ");
INSERT INTO kjs_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Go raburi Yesumi nipuna kogono dia lisa-daa go-rupa lisa: Ni ipa nalame komalo lisa. Nipuna agale abala Gote-na buk madaa wisa-pulu go agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Go lisa rabu rero pi ipa meda kap-para pira palae wisa. Soldia alinumi lubi koma-ae ele meda muma go eleme oge kap-para rero pi ipa meda puma kalisimi. Go pumare nimumi repena kuli madaa rukaluma Yesu nipu nenalo manaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesumi rero pi ipa noma talo: Naa go su kamaa kogono ora dia yaade lisa. Go loma lisana nipuna kalu adainaaoma nipuna le kadupilisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Go raburi Juda alinumi Pailat agale gu-rupa misimi: Naame mo repena polopea madaa li alinuna ali kuli rodope lumare mo ali ro mapomono lisimi. Gore ekera-nanere nimu Pomo mu Pirape Yapi kone wisimi-pulu apo ali ronu repena polopea-para pa saabaliare koeyaalia kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailat-me e lisa-pulu soldia alinumi mo Yesu raapu nil lisimide ali laapona kibu rodope lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Go puma nimu Yesu nil tyabae-para kibu rodopeta ipisimi. Go pisimi pare nipu abala le kadupilisa-daa adisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Go pisa pare soldia ali komeame nipuna ramame Yesuna perali-para awisa rabu yaapi-para ipa laapo wagepu raa kilipisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni Jon-re neme waru adisua-pulu lagialo. Gore naame nipu laketema agale ora agale kone suma makuaamina. Go puma nipumi page kone mada rulalimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Soldia alinumi go pisimi-auri Gote-na buk madaa gu-rupa wisa: Nipuna kuli meda mada narodopetaliminalo buk madaa gu-rupa wisa-daa agale ralisimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gote-na agale meda buk madaa gu-rupa wia: Enaalinumi nimina ramame awede ali adalimina lu wia. ");
INSERT INTO kjs_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gore Yesu maa rogalalo adare Arimatea su-para piri ali Josep nipumi Pailat lakeloma Yesu nipuna ro ria pono lisa. Go Josep-re nipumi no Juda alinu madaa paalame komea-pulu nipumi pagaa wi kone suma Yesu madaa kone rulasa. Pailat-me e lisa-pulu nipumi ria pisa. ");
INSERT INTO kjs_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Gore Nikodemus-mi page go ali abalade ribaa Yesu piri-para ipisade aliri nipu Josep raapu pisa. Nipumi repena ipaa-para repena yo rado meda-para go ele laapo maa pisipi. Go elenuna kedaare 30 kilo maa pisipi. ");
INSERT INTO kjs_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Go ali laapome Yesuna ro muma apo repena ipaa yo laapo sapalae mamina-para rogaaoma ruma pisipi. ");
INSERT INTO kjs_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mo Yesu repena polopea madaa lisimide re-para maapu meda saabaasa. Go maapu-parare kana apedaa tapa kagaa meda wisa. Go kana apedaa-para ali meda abala narogaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gore Juda alinuna Pomo mu Pirape Yapi di-ri ekera-rupa yaa-pulu Yesu ro go re-para wisa kana apedaa-para rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gore adaa koro rabu ribaa pa yabaina Makdala su-para piri Maria mo kana apedaa tapa-para ipisa. Go rabu nipumi go kana apedaa pora gaape abala lobapaina mo-pare aaoma adisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Go rabu Maria-me wagepu ipuma Saimon Pita-para ni Jon Yesuna raaname kome disaipel ali saa-para talo: Mudu Ali-na rodere abala maa ria puamena-le aa-para puma ru wimi palo maarea lisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Go lisa rabu Pita saa laapo nipu giyoma mo kana apedaa tapa-para adola pisipa. ");
INSERT INTO kjs_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gore Pita saa laapo alo pisipa pare neme Pita werepe ma-aaoma abala alo pisua. ");
INSERT INTO kjs_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ni mo apedaa-para puma none paitabaoma rogaae mamina adisua pare no ru-nane na-adola pisua. ");
INSERT INTO kjs_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Pare Saimon Pita-re werepe aapu-nane ipumare mo apedaa-para ora kodobaoma puma adisa. Nipumi rogaae mamina komea wina adisa. Go puma mo mamina medaloma raapu nawisa pare nipu pakipu pale wisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Go rabu kana apedaa-para ni abala alo puma neme kodobaoma ru-nane puma adisua-pulu kone rulasua. ");
INSERT INTO kjs_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gore Gote-na buk-mi Yesu wala rekalia lisa pare saame namakuaasipa. ");
INSERT INTO kjs_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Go pumare saa disaipel ali laapore ada wala pisipa. ");
INSERT INTO kjs_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria kana apedaa pagi-nane puma rekaoma relala aasa. Re epa lala aoma lisana nipu kubunaoma kana apedaa ru-nane adainaasa. ");
INSERT INTO kjs_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Go rabu nipumi mamina kaake pi maarae ensel laapo adisa. Go ensel laapore Yesu ro rogaasimi-para pirisipi. Medare kalu-nane pirina medare ke-nane pirisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Go ensel laapome Maria-para talo: Go ena, ake pea-daa re lae? Ename talo: Naa Mudu Ali mea ruma piamena-le aa-para mea ru wimi pae? ");
INSERT INTO kjs_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Go lomare nipu wala pereke lumare Yesu rekasa-daa adisa pare go ali Yesu lo namakuaasa. ");
INSERT INTO kjs_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesumi nipu agale gu-rupa lisa: Go ena, neme ake pea-daa re lae? Nere aapi aasa pili? Maria-na konere go ali mo maapu surube ali kone suma nipu-para talo: Mudu Ali, nipu aa-para ria puame? Naa mea ria pono ni lagi. ");
INSERT INTO kjs_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesumi nipu-para talo: Maria lisa. Go lisa-pulu Maria pereke luma Juda alinuna agaleme Rabonai yalisa. Go bina re-re ada agaleme tisaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesumi nipu-para talo: Naa Aapa piri-para abi nape-pulu ni nasaapirana-le nina amenu gu-rupa puma lakelape: Ni so yaa-para pumare naana Aapa piri wala palua. So yaa-parare naana Aapa Gote piri palua lo lakelape. ");
INSERT INTO kjs_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Go lisa-pulu Makdala su-para piri ena nipu pumare naa disaipel alinu-para gu-rupa epa lagisa: Neme Mudu Ali adawa. Nipuri naana Gote piri-para palua lagia. ");
INSERT INTO kjs_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Go adaa koro rabu naare pabola pulaina naa disaipel alinuri Juda alinu paala komisima-pulu ada ru-nane kiritaoma pora gaape garulaoma pirisima. Go rabu Yesu nipu pa ipuma naa piri-para epa aoma talo: Nimina lo robaa kuma puma epe kone su piralepape. ");
INSERT INTO kjs_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Go loma lisana nipuna ki laapo-para perali page mea waalisa. Go rabu naame Mudu Ali adisima-pulu raaname komoma pedo pirisima. ");
INSERT INTO kjs_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Go raburi Yesumi naa-para wala lagisa: Nimina lo robaa epe kumapu ena piralepape. Aapame ni mea epenalisa-rupa neme enaalinu piri-para mea rapaalua. ");
INSERT INTO kjs_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Go loma lisana nipuna popome naa madaa ma-paama paboma talo: Nimimi Holi Spirit mealepa. ");
INSERT INTO kjs_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Enaali raayona koe elenu raakepe rubalimiri go koe elere ora dia yaalia. Go puma narakepe rubalimiri go koe elere namuma rabuniaalia lisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu naa piri-para ipisa rabu disaipel ali komea-mare napirisa. Go aliri Tomas pare nipuna bi medare Didimus. ");
INSERT INTO kjs_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Go ali napirisa-pulu naame nipu lakelesima: Paga, naame Mudu Ali adama lisima. Pare Tomas-me talo: Gore nipuna ki madaa nil-mi lide kodo page nipuna perali-para nil-mi lide kodo waraalua-daare go rabu kone rulalua lisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wala sarara meda penaaloma naa disaipel alinu ada ru-nane pirisima. Go rabu Tomas naa raapu pirisima. Naame pora gaape garulasima pare Yesu naana rikirana epa opapaoma talo: Nimina lo robaa kuma pu piralepape. ");
INSERT INTO kjs_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Go loma lisana Tomas-para talo: Nena kimi nina ki kodo wara. Ora waraaoma adape. Gore waraaomare nena ki ridulaoma nina perali-para lide kodo page waraape. Nere kone laapo nasape. Ni madaa kone rulape. ");
INSERT INTO kjs_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Go rabu Tomas nipumi talo: Naa Mudu Ali loma nina Gote lisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesumi nipu-para talo: Neme ni adale-pulu ni madaa kone rulaali? Enaalinumi ni na-adoma kone rulalimide enaaliri nimu raana komoma piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu napi kogono medaloma pisa rabu naa disaipel alinumi adisima. Go pisa pare go buk madaa raayo nalu wima. ");
INSERT INTO kjs_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pare go buk-para sade agalere nimimi Yesu ora Gote-na Si page ora Gote-na Mea Rapaae Ali kone rulaminalo lisuade. Go puma go kone nimuna lo robaa-para makodobaaoma nipu madaa kagaa piramala palimi. ");
INSERT INTO kjs_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Werepe naa nipuna disaipel alinu ipa le Taiberias pagi-nane pirisima rabu Yesu ipisa-daa naame nipu adisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naa piri-para gu-rupa ipisa. Yesu nipuna disaipel alinu Saimon Pita-para Tomas nipuna bi meda Didimus-para Nataniel-para pirisima. Go ali Nataniel nipuri Galili adaa su robo ru-nane Kena adare-para madina ali pirisa. Gore nipu-para Sebedi-na naakinu-para ali meda laapo-para naa raayo meda-para pirisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Go rabu Saimon Pita-me naa-para talo: Neme wena mula pulu lisa. Go lisa rabu neme talo: Naa page baina lisima. Go lomare naa ipinu madaa puma pisima. Go pisima pare go ribaa wena komea-daa meda namisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gore naare opapatalo palaina Yesu nipu no ipa pagi-nane epa rekaoma aasa. Reka aasa pare naame Yesu kone-daa nawisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Go rabu nipumi naa lorapisa: Nopo naaki-repaaya, nimimi wena medaloma meame? Naame talo: Nameama lisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Go rabu nipumi talo: Nimina wena agona mo ipinu popo ki-nane lopatepa lisa. Go pumare go agona-para wena rubitaboma wenana kedaa pisa rabu ipinu ru-nane mada nayolasaasima. ");
INSERT INTO kjs_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Go raburi neme Jon Pita-para lakalisua: Go aliri Mudu Ali lisuade. Gore Saimon Pita-me nipuna mamina koyo ruboma kogono pala aasa. Yapare nina agale pagomare nipuna mamina maraoma ipa-para puma pogoloma ki mogema puma Yesu aasa-pari pisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Naa disaipel ali medalomare ipinu madaa pirumare mo wena agona yola pisima. Naa ipa pagi adaalu pu napirisima-pulu disaipel alinumi mo wena agona ogeasi adaalu (gu-rupa 100 mita) yolapisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Naa ipa pagi-nane ipisima rabu repena meda rala aasa-daa adisima. Go-para wena-para bret-para go repena sulaa-para kiraba aasa-daa adisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Go rabu Yesumi naa-para talo: Meamede wena medaloma mea ipulupa. ");
INSERT INTO kjs_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Go lisa-pulu Saimon Pita nipu mo ipinu madaa puma lisana mo wena agona yola ipisa. Go wena agona-parare wena ora rubitabesa pare agona narugulatabisa. Gore wena diminasima pare wena 153 pirisa-ya. ");
INSERT INTO kjs_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Go rabu Yesumi naa-para talo: Epa nalepa. Go lisa pare naame nere aapi yapae lo gu-rupa nalisima. Ora Mudu Ali makuaasima-pulu agale nalisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Go rabu Yesumi bret muma naa gisa. Mo wena page go-rupa maa gisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu tapa madaa abala rekoma pumare naa piri-para rana repo ipisa-daa adisima. ");
INSERT INTO kjs_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naa eda abala nomare Yesumi Pita-para talo: Nere Jon-na si Saimon yaade. Ni madaa pedo pi kone guaayere go konemere disaipel alinuna go kone rabuaaye? Pita-me talo: Mudu Ali, neme ne madaa pedo waru pe lisa. Yesumi nipu-para wala lakalisa: Naa sipsip sinu surubuma eda kalape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wala rana laapo Yesumi talo: Jon-na si Saimon-re neme ni madaa ranaa kome kone waru sale pae? Pitame talo: Mudu Ali, neme ne madaa pedo waru pe-daa adele lisa. Yesumi nipu-para talo: Gore neme nina sipsip menanu eda kalape lisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wala rana repo Yesumi Pita-para talo: Saimon ne Jon-na si nemere ni madaa ranaame komele ya? Gore Yesumi rana repopa agale lorapisa-daa Pita-me kodome komoma talo: Mudu Ali, neme ele raayo ade-le neme ne madaa ranaame komoma makuaate lisa. Yesumi nipu-para talo: Gore nina sipsip menanu surubuma eda kalape. ");
INSERT INTO kjs_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne-para ora agale lagialo. Ne penaali pirisi rabu nena kone suma aako ramu laapo yamoma pora pamisi. Pare ne yomagae pirali rabu nena ki ridulainaloma ali medame ki adiala nipuna kone suma ne maa palia. ");
INSERT INTO kjs_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesumi go saa pi agale lisa-daare werepe Pita-na komape di rabu nimumi ki adiala lu makomaliminaloma Gote-na bi minasaalia lisa. Go rabu Yesumi Pita-para talo: Ni raita mea nipu lisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Abalare ni Yesu re-para piruma eda nisipa rabu Pita-me agale gu-rupa misa: Mudu Ali, nena koe makirae aliri aapi yapae? Gore abi Pita-me pereke luma ni adisa rabu nipumi talo: Go ali madaare ake palia ya? ");
INSERT INTO kjs_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesumi talo: Gore nipu pa pirina epalua kone sanore nena kogono ya? Ne-para lawade ni raita mea nipu. ");
INSERT INTO kjs_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesumi go agale lisa-pulu ni mada nakomaluade remaa lakalisa pare Yesu gu-rupa nalisa. Dia, nipu pa pirina epalua kone saluare nena kogono yapae lo gu-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ni Jon neme go elenu madaa remaa lagisuade. Neme page pepa madaa lisua. Go agale madaare Yesu ora agalena re adema. ");
INSERT INTO kjs_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pare Yesumi kogono medaloma adaapu pisa. Go kogono raayo rado rado pepa talo palimare go su kamaa buk ora rubitabalia kone salo. Ni Jon go buk lisuade. Go yaade. ");
INSERT INTO kjs_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yesa Tiofilus: Naa abala pepa komea madaare neme abala Yesuna pisade kogono-para nipuna agale-para apo pepa madaa luma rapaasuade. ");
INSERT INTO kjs_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nipuna kogono ripia pa kamaa puma so yaa-para penaalo go agale raayo pepa luma rapaasuade. Go puma Yesumi Holi Spirit-na purimi nipuna mapiraasade aposel kogono alinu-para agale mana lakeloma sone pisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gore abala komenaloma yapi di 40 popenaloma aposel kogono alinu raapu epa kiritaoma pirisa. Nimu raapu pirisa rabu nimumi nipu ora pa pia kone winalo ele adaapu pisa. Go puma epe kogono radonu pu Gote-na Surube Su madaa agale adaapu lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aposel alinu raapu kirita pirisa rabu Yesumi nimu agale gu-rupa lakalisa: Nimimi Jerusalem suri nagiyalepape. Naa Aapame giliade ele mealiminapa adoma piralepape. Go ele madaare neme agale abala lagisuade. ");
INSERT INTO kjs_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gore Jon-me enaalinu pa ipame kalu-ipa measa pare wala ogesi-daa pa piruma Holi Spirit-na puri mada kalu-ipa mealimina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposel alinumi Yesu raapu kiritasimi rabu nipu agale gu-rupa lorapisimi: Mudu Ali, naa Israel enaalinuri aa-rabo naame go su-para suruba piralima yapae? ");
INSERT INTO kjs_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesumi talo: Aapana yapi dinu nipuna wia-rupa mada na-adema. Aapa nipuna di wia-pulu ni namakuaayo. ");
INSERT INTO kjs_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yapare Holi Spirit nimi madaa epenalea rabu puri mealimi-pulu nina pisuade remaa Jerusalem su-nane page Judia Samaria laapona apo ipanu popea-nane su raayona lakela pulupape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nipumi go agale loma nimumi adapaba pirina Yesu yaa-para puma mole kaaka medame nipu maa puma kepisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu so yaa-para pisa rabu aposel kogono alinumi adaba pirina ali laapo nipu raapu rekasipi. Go ali laapona mamina-re kaake pi maraasipi. ");
INSERT INTO kjs_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nipu laapome talo: Galili alinu-ya, ake paa-daa yaa-para adaba pimi pae? Go puade Yesuri wala werepe go-rupa wala epalia lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Go puma aposel kogono alinu Rudu Oliv kilipima wala Jerusalem su-para pisimi. Rudu Oliv-ri Jerusalem su-para siti re-para gu-rupa wan kilomita-rupa adaalupu aasa. ");
INSERT INTO kjs_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem su-para pumare nimuna so ada rum-aepara puma pirisimi. Go puma pirisimi alinuna biri go-rupa: Pita-para Jon-para Jems Andru laapo page Filip Tomas laapo page Bartolomyu Matyu laapo page Jems medare Alfius-na si page Saimon-re nipu Selot-repaa page Juda-re Jems medana si page nimu raayo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Go alinu raayo nimuna kone komea-para suma beten lala pirisimi. Go ena raapu page Yesuna agi ame balinu page beten lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Go puma yapi medaloma pisa rabu kone rulae enaalinu kiritasimi. Enaaliri gu-rupa 120 kiritasimi. Go rabu Pita-me rekoma agale gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ame balinu, pagalepape. Gote-na pepa madaa Holi Spirit-mi Juda enaalinuna kone Devit abala kalisa-pulu nipumi pepa madaa lisa. Go Juda-re Yesu giyoma lore alinumi linalo yada robisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Go pisa pare Judas-re ora naa raapu piruma naana kogono raba minalo Yesumi Judas mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yapare go alimi yada roboma kana misa. Go mone-mere su meda kaboma werepe kope noma lopoma robaa rugulataboma lo koyapape puma komisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem su-para piri enaalinu pagoma go suna biri Akeldama maasimi. Go bina re ali yaapi wi su leme. ");
INSERT INTO kjs_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Go madaare Buk Sam-para go ali madaa agale gu-rupa lisimiya: Nipuna ada pa rai aina. Ali medaloma go ada-para mada napirina lisa. Go page lisa: Ali medame nipuna kogono mina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Go pea-le abiri naame ali meda meamina. Go ali nipuri naa raapu ade abuna Yesumi agale mogealisa rabu page naa pamisima rabu page go raayo adoba kiriti ali adoma meamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon-me Yesu kalu-ipa mea kalisa rabu page Yesu komoma rekoma wala yaa madaa pisa rabu page go raayo adoba piri ali meamina lisimi. Go nasamina ali muma naa raapu Yesuna komoma wala rekesa-le pamu lamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita go-rupa lisa rabu ali laapo mada minalo gu-rupa lisimi: Medare Josep nipuna bi medare Barsabas page Justus page lemede. Ali medare nipuna bi Matias leme. ");
INSERT INTO kjs_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Go rabu beten gu-rupa lisimi: O Mudu Ali, ne enaali raayona kone ade. Go ali laapo naame makeme talo palima ali neme ali komea mea waalape. ");
INSERT INTO kjs_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Go pumare go alupaleme alimi Judas-na kogono mina. Go ali Judas-re nipuna yoto muma ora koe su-para puade lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Go loma nimumi ali laapo adoma Matias madaa raana komisimi. Go ali kogono ali 11 raapu aasimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yapi di Pentikos rudu lisa rabu kone rulae enaalinu ada meda-para epa kiritasimi. Kiritasimi enaalinuri 120 pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Go Pentikos yapi rabu ele medame yaa madaa mu mu loma lisana wagepu adaa po rilipu-rupa ipisa. Go rabu nimu piri ada-para epa rubitabesa. ");
INSERT INTO kjs_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Go pisa rabu nimumi repena sulaa-rupa rugula rugula pisa rabu nimumi adisimi. Rugula rugula puma rabu repena sulaa elere nimu madaa komea komea lo epa pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Go pisa rabu nimu madaa Holi Spirit-mi epa rubitabesa-pulu adaa agale rado rado lisimi. Go agalere Holi Spirit-mi nimu kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Go pisa rabu Juda alinu medaloma Jerusalem su-para epa pirisimi. Gote madaa kone rulae alinuri adare su raayona page giyoma epa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gore enaali raayome go po rilipu ele pagisimi rabu nimu raayo adola kiritasimi. Go puma nimuna adaa agale pagisimi rabu nimu ora paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Go puma nimumi kidipaa ragi luma gu-rupa lisimi: Go adaa agale leme alinuri ora Galili su-para piri enaalinu yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Go pea pare nimumi agale lalaina pagaleme rabu naana adaa agale pagalima lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Naana suri Partia-para Midia-para Elam-para Mesopotemia-para Judia-para Kapadosia-para Pontus-para Esia-para ");
INSERT INTO kjs_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia-para Pamfilia-para Isip-para mo adaa su Libia-para Sairini su page piruma epama. Gore naa medalomare Rom page pima lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Naare ora Juda-para ruru rado enaalinu lotu komea tema enaali page pima. Naa medalomare su Krit Arebia laapo page pima. Go pea pare kone rulae enaalinumi agale leme rabu nimu raayome naana adaa agale pagoma Gote-na epe kogono madaa pagamade lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Go pisa-pulu alinuri ora pogolasaoma ki wage alo puma agale gu-rupa lo pirisimi: Go elere ake yapae lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Go lo pirisimi pare pa ali medalomame giri laaoma gu-rupa lisimi: Go alinuri ipa wain (bia) noma makeateme lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Go rabu Pita aposel kogono alinu 11 raapu rekaoma enaali raayo-para agale puri paloma gu-rupa lisa: Juda enaali-para, Jerusalem su-para enaalinu-ya, nimimi go agale pagalepa. ");
INSERT INTO kjs_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nimina konere mogo alinu ipa bia noma makeateme kone saeme pare abi naare pena ipulaina pa 9 klok rabu aema lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ribaa rabu ipa bia nemede. Go kone madaare Gote-na agale lakale ali Joel-me Gote-na buk madaa abala agale gu-rupa lu wisaya: ");
INSERT INTO kjs_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Gote-me talo: Werepe su yaa dia yaaliade rabu neme gu-rupa palua: Naa Holi Spirit enaali raayo madaa mapiraalua. Go puma nimina nogo naakinu nina agale lakeleme. Go puma nimina alinumi ele adalimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Go di rabu neme nina kogono enaalinuri Holi Spirit-na puri katoa. Katoa rabu nina epe agale lakeleme. ");
INSERT INTO kjs_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Go puma neme so yaa-para ele radonu maa salua. Go puma su kamaa ele radonu maa salua rabu yapi page repena sulaa page koe lodo page ma-opasaalua. ");
INSERT INTO kjs_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Go Mudu Ali epaliade yapi di madaare naare abala kudinina toa lisa. Go puma subare yaapi pi ma-aalia. ");
INSERT INTO kjs_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Go rabu enaali raayome Mudu Ali-na bi madaa agale loma kone rulalimiri ade abuna kagaa piramala palimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita-me lisa: Israel enaalinu-ya, go agale pagalepape: Neme Nasaret ali Yesu madaa lalo. Yesuri Gote-me nipu mapiraoma puri kalisa-pulu kogono waru pisa. Go-rupa puma nipumi puri pale kogono-para ora epe kogono rado rado-para Gote-na puri maa waalisa-daa makuaaeme. ");
INSERT INTO kjs_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesuri Gote-me kone mapiraasa-pulu koe kimisu enaalinumi repena polopea madaa linalo maa rapasa. ");
INSERT INTO kjs_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Go pirisimi pare komape ele kepenalo Gote-me nipu marekaasa. Gore komape eleme Yesu tapame naripinaasa. ");
INSERT INTO kjs_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Go madaare Devit-mi Yesu madaa abala gu-rupa lisa: Ali Mundu-ri ade abuna ni raapu pipa-daa ade. Go puma ni raba mea-le ni paala nakomalua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Go pea-pulu epe koneme lo robaa-para rubitabea-daa pedo pi. Naa yogale tapa-para rogaalimi pare Nina kone wasupa ade abuna kagaa piralia. ");
INSERT INTO kjs_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Neme nina kone wasupare Komape su-para napenalo surubape. Naa epe kogono alina yogale mada naramualia. ");
INSERT INTO kjs_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Neme epe pora waaloma go pora ade abuna Kagaa pirape pora yaa-pulu Ne raapu raana komona pitua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ame balinu-ya, naana kasua Devit-na agale epe-rupa lagialo. Nipu komenaloma tapa-para rogaasimi. Go puma nipu rogaae kana apedaa go su-para aaya. ");
INSERT INTO kjs_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nipu Gote-na agale lakale ali piruma Gote-na ora agale waru makuaasa. Gote-me yaa madaa makuaa loma lisana gu-rupa lisa: Devit madi su-para ora Mudu Ali meda piralia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit-mi Yesuna papeanu werepe epaliade elenu adisa-pulu nipu rekape-ai agale lakalisa. Go puma Keriso kome enaalina su-para napiruma yogale page naramualua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pagalepa. Gote-me go ali Yesu Keriso marekaasa-daa naame leme adisima. ");
INSERT INTO kjs_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gore Yesu marekaasa rabu Gote-na popo ki-nane puma pirisa. Go puma Gote-me ora agale loma Holi Spirit gialua lisa. Go lisa-pulu nimimi abi go ademede elere Holi Spirit nipumi mea epenalade. ");
INSERT INTO kjs_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gore Devit-ri Yesu pisa-rupa so yaa mada napirisa. Devit-mi talo: Gote-me Mudu Ali Yesu-para. Naa popo ki-nane piraina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Lore alinu nena rolo-para mapiraalua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israel su-para piri enaali raayore ora Gote-me go Yesu Mudu Ali mapiraasade kone makuaalepape. Go Yesuri nimi repena polopea madaa lisimi pare Gote-me nipu ora makuaa loma Mea Rapaae Ali yaade lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Enaalinu go agale pagisimi rabu nimuna lo robaa-para kedaa pisa-daa nimumi Pita-para aposel kogono ali medaloma-para go-rupa lisimi: Amenu, naa ake palima ya? ");
INSERT INTO kjs_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita-me lakalisa: Nimi komea komea lo kone pereke yoma Yesu Keriso-na bi madaa kalu-ipa mealepa. Go puma nipumi nimina pupitagi marabuaaoma Holi Spirit nimi pa gialia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gote-na ora agalere nimi-para nimina sinu-para su raayona lo kiritasimi. Go enaali raayore naana Adaa Gote-me nipu raapu mapiraalia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Go puri pale agale Pita-me nimu lakalisa. Go puma agale mana adaapu loma gu-rupa lisa: Abiri pupitagi ne enaali adaapu pimi-le nimiri nimu giyoma koe kone nasalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Go lisa rabu enaali adaapu nipuna agale madaa raaname komoma pagoma kalu-ipa misimi. Go yapi di rabu enaali 3000 disaipel enaali raapu epa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nimumi moge ria-ae alinuna agale pagoma epe-rupa piruma kone komea suma eda noma beten lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Go puma aposel kogono alinumi napi kogono page epe rado kogononu page pisimi-pulu enaali raayome paala komoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Go puma kone rulae enaali raayome kone komea suma nimuna elenu kiritaoma rumaaoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Go puma pa enaalinumi mo kone rulae enaalinuna ele kabenalo nimumi kana muma pa piri enaali rumaaoma kaloma nimu raayo epe-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Go puma nimumi kone komea suma yapi meda meda lo lotu ada-para kiritasimi. Go page nimuna ada-para eda noma ora raaname komo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Go puma nimumi Gote-na bi minasaasa piruma enaali raayome talo: Nimi epe-rupa pimi enaali. Go puma ade abuna Gote-me kone rulae enaali raapu enaali medaloma adaapu mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gore beten lape di rabu Pita-para Jon nipu laapo alebo lotu ada-para pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pisipi rabu go epe lotu adana pora gaape-nane pora napami ali meda pirisa. Go aliri agimi age koeyae pale madu wisa. Ade abuna epe pora gaape temede kamaa-nane ria ipuma mapiraasimi. Go alimi lotu ada-para kodobalimide enaalinu-para kana ele meda ogenalo mea mapiraasimi. ");
INSERT INTO kjs_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita Jon laapo lotu ada ru-nane kodobatalo pisipi rabu go alimi ele meda gialepa loma ogelisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Go lisa rabu mo ali laapome pora napami alina le agaa waru adaba suma Pita-me talo: Saa adape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gore pora napami ali nipumi kone gu-rupa wisa: Ora ele gialipi kone wisa-pulu go alimi waru adaba wisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Go rabu Pita-me nipu go-rupa lakalisa: Ni kana ele nasabaayo-pulu ele meda gialuame pi lisa. Nasaret su-para piri Yesuna bina purimi ne marekaaluame talo lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Go loma go alina ki mina marekaasa. Marekaasa rabu go alina age galo puri pasa. ");
INSERT INTO kjs_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Go ali raana komomare rekoma pora pamisa. Go puma nipu page Pita Jon raapu epe lotu ada-para pisimi. Pisimi rabu go alimi ora pogolaari puma Gote-na bi minasaasa. ");
INSERT INTO kjs_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nipu pamuma Gote-na bi minasaasa rabu enaali adaapumi nipu adisimi. ");
INSERT INTO kjs_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Go ali ade abuna epe pora gaape-nane piruma kana ogelisa-pulu enaalinumi nimuna le agaame adisimi. Gore nipu abi pora epe-rupa pamuma ru-nane ipisa-daa go enaalinumi paala komoma ki wagepu pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Go lotu adana pokaalo ada meda aasa. Gona biri Solomon-na pokaalo ada lisimi. Mo alimi Pita Jon laapo waru kupima go pokaalo ada aasa-para enaali adaapu nipu wagepu adola pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita-me enaali raayo adoma agale gu-rupa lakalisa: Israel enaalinuri ake paa-daa nimimi ki wagepu puma pimi pe lisa. Gore ake paa-daa saa adoba wimi pae? Nimi ake kone wimi pae? Saame epe kone suma saana purimi go ali ma-epeaaripa ya? Ora saana purimi-daa dia. ");
INSERT INTO kjs_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gore Gote-me paa. Ora naana kasua Abraham-para Aisak-para Jekop-para nimuna Gote-me go ali ma-epeaaripa. Nipumi nipuna raba mi naaki Yesuna bi minasaatalo paa. Go Yesuri nimimi apo kadipi Pailat-na le agaana yada roboma koau waalisimide. Pailat-mere Yesu rapaalua kone wisa pare nimimi go agale napagesimide. ");
INSERT INTO kjs_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Go puma Yesu ora Gote-na epe redepo le ali pirisa pare nimimi nipu giyoma Pailat-para enaali lu makome ali epenala lisimide. ");
INSERT INTO kjs_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Go puma nimimi ade abuna kagaa pirapena re Yesu yapare lisimide. Lisimi pare Gote-me tapa-para marekaasa. Naame go raayo adoma lalema. ");
INSERT INTO kjs_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Go Yesu nipuna bimi go pora napami ali ma-epeaaripa. Nipumi Yesu madaa kone rulaasipi-daa Gote-me nipu puri kalisa. E, gore nimimi go ali adaba pimi. Go alimi Yesuna agale lo robaa-para makodabaripa-pulu nipu epe-rupa pia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Naa ame balinu, nimi page nimina ali kalunumi page Yesu-para pisimide elere namakuaaoma pisimi yaade. ");
INSERT INTO kjs_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Go pea pare Gote-me nipuna agale lakale alinu-para gu-rupa lakalisa: Keriso Mesaia radaa noma komalia lakalisa. Go alinumi agale lakenaloma go agalena re makoyatalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Go pimi-le kone pereke yoma Gote-na kone muma nimina pupitagi giyalimina go rabu nipumi mea rubaalia. ");
INSERT INTO kjs_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gote-me kagaa puri ginalo go-rupa palepape. Go puma Gote-me Yesuri makuaa loma Mea Rapaae Ali yaa-pulu abala mada muma mea rapa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pare nipu abi yaa-para ora piruma werepe su kamaa ipuma kagaa elenu masaalia. Go madaare Gote-me nipuna agale lakale alinu lakenaloma nimumi lisimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Go madaare Moses-me abala gu-rupa lisa: Gote-me ni nipuna kogono panolo mapiraasa lisa. Go pea-le nipuna lakale alina agale raayome pagalepape. ");
INSERT INTO kjs_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Go puma enaali raayome nipuna agale napagalimi-daare Israel su giyoma ora nimu komabalimina. Moses-me agale gu-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pita-me wala talo: Gote-me agale lakale ali Samuel madaa piruaama ipumare agale lakale alinumi raayo go agale komea gu-rupa lisimide. Nimuna agalena re abi go yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gote-me kasuanu raapu kana waraaoma agale lakale alinu agale lakalisa. Go ora agalere ora nimina pagoma meape agale yaade. Gote-me Abraham-para agaleme pogalulalo gu-rupa lisa: Nena madi si kasuanumi su kamaa piri enaali raayo puri kainalo mapiraalua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Go lisa-pulu Gote-me naa raba meape ali Yesu mea epenalisa. Gote-me Yesu marekaaoma nimi piri-para abala epenalisa. Go puma nimimi pupitagi ne kone koau walanalo epe puri mea epenalisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita-para Jon laapome enaali agale lakalisimi rabu alinumi nipu laapo adialalo ipisimi. Alinu gu-rupa ipisimi: Gote-na lodo kira-ae alinu page lotu adana Mudu Ali polis page Juda alinuna page Sadyusi ruru alinu page adialalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gore Pita Jon laapome enaalinu-para Yesu tapa-para rekoma pia lisipi. Go lisipi-pulu enaalinumi kome enaalinu page wala rekoma piralimi. Go lisipi-pulu mo alinumi rono waru pagoma adialalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Go puma adilisimi pare ribaa lisa rabu ekera kose lemena lisa. Go puma kose nalo pi ada-para surubisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Go pirisimi pare enaali adaapumi nipu laapona agale pagoma kone rulasimi. Go rabu Mudu enaali adaapumi gu-rupa 5000 kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wala ekera-nane kaunsil-na ali mudunu page kone makuaae alinu page rekena agale tisaa-nu page Jerusalem su-para kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gote-na lodo kira-ae alinuna mudu Anas-para Kaiafas-para Jon-para Aleksader-para lodo kira-ae Mudu Ali raayo kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Go puma nimumi aposel kogono ali laapo lorapisimi. Nipina kogonore aapina bi madaa puri mealepa lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Go lisimi rabu Pita madaare Holi Spirit kodobasa-pulu gu-rupa abulisa: Enaali raayona mudunu page kone makuaae alinu page nina agale pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Gore nimimi agale mulalore saame pora napami ali raba muma ma-epeaaripade agale laketepa lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Go madaa waru pagalepape. Go rekoma pia aliri Nasaret su-para piri Yesu Keriso-na purimi nipu ora ma-epeaaripa. Go Yesuri nimimi repena polopea madaa nil-mi lisimide pare Gote-me nipu tapa-para marekaasa. Nipuna purimi pisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gote-na buk madaa wi agaleme Yesu madaa saa pi agale gu-rupa wisa: Nimi kamda kogono pulalo meme kanare giyasimide pare go kana abi ora riri-nane ali lisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Gore nipu komeame ade abuna kagaa piramala pope kone wasupa mada gialia. Su raayo-para pimi enaalinumi Yesuna bi komeame naa epe-rupa mapiraalia leme lisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Go lisa rabu kaunsil piri alinu paala komisimi pare Pita Jon laapome puri pale agale lisipi. Go ali laapore skul nalo agale mana waru napage ali lapo-le puri pale agale lisipi-daa adisimi. Nipu Yesu raapu pirisipi-daa adisimi. Go puma mo alinumi kone adaapu wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yapare pora napami ali pereke yoma nimu raapu pirisa-pulu nimumi Pita Jon laapo-para agale na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Go puma nimumi go ali laapo kaunsil ada giyoma kamaa maa pulupa lisimi. Nimumi nipu laapo madaa kose lape agale mea robesimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Go ali laapo madaare ake palima ya? Nipuna puri pale napinu kogono Jerusalem su-para enaali raayome pagamede. Go pea-le naame go ali laapome ne koe ali nama-epeaaripiri mada natema lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yapare go agale su raayome puma pagena-le go ali laapo-para Yesuna remaa enaali medaloma nalakelaina lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Go loma go ali laapo ru-nane mea ipulupa loma lisana agale mana gu-rupa lisimi: Yesuna agale-para nipuna bi-para enaali medaloma nalakelape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Go lisimi pare Pita Jon laapome agale gu-rupa abulisipi: Nimimi tapape. Nimina agale pageme palo ora Gote-na agale pageme palo tapape. Gote-me lisa adea-le nimimi tapape. ");
INSERT INTO kjs_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gore saame adoma pagisipa-pulu agale mada tepa lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Go lisipi rabu kaunsil alinumi nipu-para yada malue tyape agale wala loma mea rapaasimi. Enaali raayome go ali laapona kogono madaa Gote-na bi minasaasimi rabu kaunsil alinumi nipu laapo nalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mo wala yaina perekele aliri nipuna madina maaliri 40 pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Rapaasimi rabu Pita Jon laapome adami enaali piri puma Gote-na lodo kira-ae ali mudu-para kone makuaae alinu-para nimumi pisimide agale puma lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Go enaalimi pagisimi rabu Gote madaa kone komea suma agale talo: Aapa, ne ora adaa. Neme su yaa laapo page ipa page ele raayo page warisi. ");
INSERT INTO kjs_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nena Holi Spirit-mi naana kasua Devit agale lakalisa rabu nipumi pepa madaa gu-rupa lisa: Ake pea ruru rado enaalinu rono pagoma koe agale lo pimi? ");
INSERT INTO kjs_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Su raayona ali kalunumi au puma mudu ruru kiritasimi. Nimumi Gote-para nipuna Raba Meape Ali madaa page rabuaalalo kirita pirisimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Devit-mi gu-rupa lisa-le abi Herot page Pontius Pailat page go ali mudu ruru rado enaalinu page Israel su-para piri enaalinu page nimu raayo kiritaoma nena raba mi ali Mesaia mapiraasimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gote neme abala kone wina go mada palimi-pulu nimu kiritalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gote abiri neme nimuna yada palimiri waru adobaina. Go puma naare nena raba mi enaalinumi nena agale puri paloma lakelamona puri giape. ");
INSERT INTO kjs_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nena koneme enaalina yaina ma-epeaaoma epe kogono mapaaoma puri pale kogononu rado pamona puri giape lisimi. Nena Epe Raba Meape Si Yesuna bimi giape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Go beten lo kiritasimi rabu nimu piri-para pururu aasa. Go puma Holi Spirit-mi nimu raayo rubitabenaloa Gote-na epe agale puri paloma lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kone rulae enaalinumi kone komea suma nimuna elenu lamulalo komea-rupa pirisimi. Ali medamere nipuna kama raapu saapitua kone nawisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Go puma aposel kogono alinumi Mudu Ali Yesu tapa-para abala rekesa-daa agale puri paloma lakalisimi. Ora go-rupa puma nimu madaare Gote-na epe raba meape kone mea wisa. ");
INSERT INTO kjs_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Go puma kone rulae enaalinuna rikiranare naarali enaali meda ora napirisa. Dia, enaali raayome su ada laapo yoto misimi rabu aposel kogono alinu kalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Go puma nimumi ele dia-le enaalinu-para mea rumaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Go pisimi rabu ali medalomame Josep nipuna su kabesimi. Go aliri nipu Livai-repaa su Saiprus madina ali pirisa pare aposel kogono alinumi bi Barnabas maasimi. Adaa agale madaare go biri epe kone sape ali. ");
INSERT INTO kjs_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Go aliri yoto muma aposel kogono alinu kana puma kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kone rulae enaalinu ele gu-rupa rumaasimi pare Ananaias Safaira repaaya lapo pirisipi. Ananaias-me nipuna su meda madaa kana yoto misa. ");
INSERT INTO kjs_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Go rabu nipumi medaloma paga suma medalomare aposel kogono alinu kalisa. Go konere nipuna wereme kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Go pisa rabu Pita-me talo: Ananaias, ake paa-daa Satan-me ne makirae kone maa gia pa. Go pea-le neme Holi Spirit-para makirae agale lae. Kone gu-rupa saere su rudu yoto medaloma nena pa pagaa saama lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Go suri ora nena su yaade. Gore yoto meaede kana page nena yaade. Ora-le ake paa-daa ne kone laapo suma kana pagaa wi pae? Ne pa enaalinu-para makirae agale nalakelae pare neme ora Gote-para makirae agale lakelaede lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias-me go agale pagoma lisana nipu lopoma ora komisa. Go puma enaali medalomame go remaa pagomare paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Go pisa rabu penaalinu ipuma Ananaias-na ro mea ruma tapa-para puma rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wala werepe ogesi-daa piruma Ananaias-na were Pita piri-para ipuma mo pisana remaa napagesa. ");
INSERT INTO kjs_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita-me mo ena lorapisa: Ne page nena aali laapo mo su madaa kana go-rupa meapede lalo pare akepu meape lisa. E, meapade pare medaloma dia yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Go lisa rabu Pita-me lakalisa: Ake pea nena aali raapu koe kone suma Gote-na Holi Spirit-para makirae agale lakelapape pae? Nena aalina ro rogaae alinu riri-nane pimi-le nena yogale page go enaalinumi rogaalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Go lisa rabu go ena Pita-na age re-para lopoma komisa. Go puma alinumi ipuma go enana ro ria puma aalina tapa re-para puma rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gore Yesuna disaipel enaalinu page enaali medalomanu page apo remaa pagoma ora paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel alinumi enaalina rikirana napi kogono page epe rado kogononu page pisimi. Koro meda aposel kogono alinu-para enaali medaloma Solomon-na pokaalo ada-para puma kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Go rabu pa enaali medaloma nimu raapu nakiritasimi pare kone rulae enaalinu pala komoma nimu raapu nakiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Go pisa rabu Mudu Ali madaa kone rulae enaali adaapu nimu raapu meda-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposel alinumi kogono waru pisimi-daa enaalinumi yaina kome enaali pora-nane ria puma reke madaa page yapara madaa page mapiraasimi. Go puma Pita pamisa rabu nipuna wasupame yaina wi enaali madaa kabulisa rabu kome enaali ma-epeaanalo mapiraasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Go puma Jerusalem su mone pane piri yaina wi enaali page remo pabo piri enaali page ma-epeaanyalo mea ipisimi. Go pirisimi rabu aposel kogono alinumi nimu maperekeasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Go pirisimi rabu Gote-na lodo kira-ae ali kalunumi page Sadyusi alinu page nimumi aposel kogono alinu madaa koe kudipa kone wisimi. Go rabu nimumi ralu waru yawesimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nimumi aposel kogono ali mapaitaalalo koe enaali piri karapo ada-para maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Go pirisimi pare go ribaa Gote-na ensel medame karapo adana pora loboma aposel kogono ali meda kamaa-nane maa puma agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Epe lotu ada-para puma enaali raayo Yesumi kagaa kone gina laketapape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Go lisa rabu aposel kogono alinumi ensel-na agale pagoma yapi lapaasa rabu epe lotu ada-para puma agale pamu mogelisimi. Gote-na lodo kira-ae mudu-para nipuna kogono alinu-para nimumi mo Juda alinuna kaunsil raayo kiritainalo yaalasimi. Go rabu karapo ada-para agale rapaoma disaipel alinu mea epenalo lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Go pisa pare polis karapo ada ru-nane puma kodobasimi rabu aposel kogono alinu napirisimi. Na-adisimi rabu nimu kaunsil piri-para agale gu-rupa puma lakalisimi: ");
INSERT INTO kjs_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Naa karapo ada adola puaama pare pora gaape ora loko luma polis adaba pirina lisima. Go puma pora gaape loboma ru-nane puma go alinu-daa naame na-adama lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Epe lotu adana mudu polis page Gote-na lodo kira-ae ali mudunu polis page Gote-na lodo kira-ae ali mudunu page nimumi go aposel kogono alinu pa puamede remaa pagomare kone adaapu wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Go kone su pirisimi rabu ali medame ipuma talo: Pagalepa. Apo paleme alinumiri lotu ada-para piruma enaalinu agale mogeaeme lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Go lisa raburi plisman-nu nimuna mudu raapu aposel kogono alinu mula puma wala ipisimi. Go pirisimi pare enaalinumi nimu kaname tyalimi kone suma pawa mea ipisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Go puma aposel kogono alinuri ru-nane maa puma kaunsil piri-para ma-aainalo Gote-na lodo kira-ae alimi agale mulalo pisa: ");
INSERT INTO kjs_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Yesuna bi madaare agale nalakelape abala lamade. Go lamade pare nimimi ora pa leme-daa adema. Go Jerusalem su-para raayome nimina lakale agale pageme. Go pea-le lu makomaape kone naa madaa masaatalo peme. ");
INSERT INTO kjs_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Go lisa rabu Pita-para aposel kogono alinu medalomame agale gu-rupa abulisimi: Naa Gote-na agale mana pagoma makuaaema. Go puma ali medaloma agale mana napageme. ");
INSERT INTO kjs_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Naana kasuanuna Gote-me tapa-para Yesu marekaasa. Go pisa pare nimimi abala repena polopea madaa nil-mi lu makomasimide. ");
INSERT INTO kjs_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Go pirisimi pare Gote-me Yesu marekaaoma ki popa ki-nane piruma ora Mudu Ali page enaali Raba Meape Ali mapiraasa. Nipumi Israel enaali raayo koe kone perekeamina koe kone rabuaamina puri pasa. ");
INSERT INTO kjs_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naame page go kogono abala adisima. Go pea-le Gote-me Holi Spirit-na puriri nipuna agale pagemede enaalinu-para kalisa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsil alinumi go agale pagisimi rabu ralu waru yawoma aposel kogono alinu tyamono kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Go kone wisimi rabu Farisi ali medare nipuna bi Gamaliel pirisa. Go aliri kaunsil alinu piri-para puma rekesa. Go aliri rekena agale mogeasa-pulu enaali raayome nipuna bi minasaasimi. Nipumi rekoma talo: Go aposel alinu kamaa maa pulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kamaa pisa rabu kaunsil-nupara go-rupa lakalisa: Israel alinu, nimimi go ali laapore ele palima kone saleme. ");
INSERT INTO kjs_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Abaladere Theudas ipuma ni ora Mudu Ali yaade lakalisa. Go lisa-pulu enaali adaapu go-rupa 400 nipu raapu pisimi. Go pisa pare lu makomasimi rabu nipuna disaipel ali raayo pogola pirisimi rabu nipuna kogono dia lisade. ");
INSERT INTO kjs_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wala werepe nimumi enaalinuna bi tyalo ipisimi rabu Galili ali Juda epa pirisa. Go puma enaali adaapumi nipuna agale pagisimi. Pagisimi pare komenaloma nipuna disaipel enaali pa giyoma pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Go pisa-pulu abi neme agale lagialo. Go ali laapo madaa kose natepape. Go ali laapo giyalepa. Nipuna pulalo pi kogonore go pa su kamaa kogono-rupadaa ora dia yaalia. ");
INSERT INTO kjs_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yapare go alinumi Gote-na kogono peme-pulu nimimi mada nayokalimi. Nimimi ora Gote madaa koeyae puma kogono makoyaalimi lo talo lisa. Go lisa rabu kaunsil alinumi Gameliel-na agale pagisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Go pisa rabu aposel kogono ali linalo ru-nane wala mea ipuma agale mana puri pale go-rupa lakalisimi: Yesuna bi mada agale natepape loma rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Go rabu aposel kogono ali laapo kaunsil giyoma pisipi. Giyoma pisimi rabu nimumi Yesuna bi madaa kedaa risimi-pulu nimu ora raana komoma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Go pumare yapi raayome aposel kogono alinu lotu ada-para page enaalinuna ada-para page Gote-na Mea Rapaae Ali Yesu madaa Epe Agale mogeasimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Go raburi disaipel enaalina ruru adaa ya-maoma pisa. Gore mo disaipel enaali Grik agale lisimi rapaame mo Hibru agale le rapaa rono pagesimi. Go lisimi: Nimimi eda wasa enanu nakaleme. Dia pare naana wasa ena eda nakaleme-pulu epe-rupa nasurubeleme lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Go lisimi rabu aposel-na 12 page disaipel enaali raayo makiritaaoma gu-rupa lisimi: Naame Gote-na agale giyoma eda ele rumaalima-daare go kone ora ko yaalia. ");
INSERT INTO kjs_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amenu, go-rupa pamina. Nimina rikirana ali 7 ele rumaaina mapiraalepape. Go mapiraalimide alinuri epe bi mealimi rabu nimu Holi Spirit waru mu redepo le kone waru su ele surubenalo mapiraalepa. ");
INSERT INTO kjs_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Go palimiri naame ade abuna beten loma Gote-na agale laketema lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aposel alina agale pagoma nimumi raana komoma pirisimi. Go puma alina bi Stiven-re Gote-na agale page Holi Spirit page nipuna lo robaa-para rubitabesa. Nipu ma-paamisa. Go puma Filip-para Prokorus-para Nikanor-para Timon-para Parmenas-para Nikolas-para go raayo madaa misa. Nikoas-re Antiok su piruma abala Juda alinu raapu kone rulae abala misa. ");
INSERT INTO kjs_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Go kone rulae enaalinumi mo disaipel ali 7-pela maa ipisimi. Go pirisimi rabu aposel kogono alinumi beten loma lisimina go alinu kalu madaa ki saasimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Go raburi su raayona enaali adaapumi Gote-na agale pagoma kone rulasimi. Go puma Jerusalem su-para kone rulae enaali adaa yoma adaapu pirisimi. Go page Gote-na lodo kirae enaali adaapu nimumi Yesuna agale waru pago kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gore Stiven-re Gote-na raba meape kone page Holi Spirit-na puri page waru misa-pulu nipumi enaali piri-para puri pale kogono-para epe rado kogononu-para puma pisa. ");
INSERT INTO kjs_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Go pisa pare enaali medalomame Stiven raapu agale ape pula pisimi. Go enaalinuri Juda enaalinuna lotu ada medana bi kepena alinu lisimi. Go enaalinu page lotu adare Sairini suna Juda enaalinu page Aleksandria suna Juda enaalinu page Silisia Esia su laapo piri Juda enaalinu page Stiven raapu agaleme ape pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Go pirisimi pare Stiven-re Holi Spirit-na puri-para nipuna makuaae kone page adoma lisimina nipuna agale mada naralisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mada naralisimi-pulu ali medaloma kana kaloma gu-rupa tapape lisimi: Stiven-me Moses-para page Gote-para page ero agale lea-daa pagema tapape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Go puma lakenaloma kone makuaae enaalinu-para rekena agale tisaanu-para nimuna kone koe-rupa ma-rekaasimi. Go puma nimumi Stiven piri ipuma kaunsil-na ada-para adiala ria pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Go puma nimuna makirae agale le alinumi ru-nane maa penaaloma makirae agale gu-rupa lisimi: Go aliri ade abuna naana Gote piri lotu ada-para nipumi Moses-na agale madaa ero agale lo aaya lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gu-rupa pagisima lisimi: Go alimi talo: Nasaret su-para piri Yesumi epe lotu ada kilipima Moses-me naa gisade rekena agale perekealia laasimi. ");
INSERT INTO kjs_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Go loma makirasimi rabu kaunsil alinumi Stiven-na le agaare ora ensel-na le agaa-rupa adisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Go lisimi rabu Gote-na lodo kira-ae ali kalunumi Stiven lorapisimi: Nimumi ne-para lamede agalere ora leme pe lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven-me go remaa gu-rupa abulisa: Amenu aapanu, pagalepape. Naana kasua Abraham Haran su-para na-pirisa rabu epe paa pi Gote-me Mesopotemia su-para opapaoma agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nena su-para piri ruru giyoma su rado-para pope. Go suri neme waatoa. ");
INSERT INTO kjs_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Go lisa-pulu Abraham Kaldia su giyoma Haran su-nane pisa. Go puma nipuna aaraa komenaloma Gote-me nipu go su-para ma epenalisa. Nimi abi go pimi su madaa talo. ");
INSERT INTO kjs_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Go rabu Gote-me Abraham nipuna surubape su kalisa. Dia, nipuna kama agu raapu pirape oge regepele su-daa nakalisa. Yapare Gote-me werepe Abraham nipuna sinu-para rurunu-para minalo ora agale lakalisa. Gote-me go-rupa lakalisa raburi Abraham-me naaki meda abi namaitisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gote-me gu-rupa wala lakalisa: Nena werepe madi naakina rurunuri pa kimisu naakinu ruru piruma nimu ora kogono madaa adili ali-rupa piralimi. Go puma nimu ora maali 400 koe-rupa piralimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gore Gote-me Abraham-para wala lakalisa: Apo ada kimisu-para piri gavman-mere nena naakina rurunu kogono madaa adiala surubalimi. Go palimi pare neme koe kedaa abulanoloma nena madina rurunu ne piri-para nina bi minasaatalo epalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Go loma lisana Gote-me Abraham yogale ruguli kone kalisa. Go pisa-pulu Abraham-me Aisak madisa rabu yapi 8 piruma go naakina yogale rugulisa. Go puma werepe Aisak Jekop madisa. Jekop-mere naana kasua 12 madisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Stiven-me agale gu-rupa lakalisa: Jekop-na sinumi Josep-para koe kone suma Isip yoto muma kimisu kogono ali-rupa maa puma yoto misimi. Yapare Gote-me Josep raapu piruma kedaa epalia lo surubisa. Go rabu Fero ora Isip-na ali mudu pirisa. Go puma Josep kabesimi rabu Gote-me Josep epe makuaae kone kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nipumi go kone kalisa-pulu Fero-me Josep-para epe kone suma Josep ora Isip su raayona namba wan gavman ali mapiraasa. Go puma nipuna ada page surubenalo surube ali mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Go pisa-le Isip su-para Kenan su laapo-para reae adaa paboma sapi e poape giya komisimi. Go pisimi rabu naana kasuanu eda asa pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Go pisa rabu naana kasua Jekop-me Isip su-para eda salo remaa pagoma nipuna sinu rana komea pora kimisu-para ma rapasa. ");
INSERT INTO kjs_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Rana laapo pisimi rabu Josep-me ameaya-para nipuna kone lakalisa rabu Fero-me Josep nipuna ruru adisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Go pisa rabu Josep-me nipuna aaraa Jekop-para agale rapaoma nipuna ruru Isip su-para ipulupape lo lakalisa. Go pisa rabu enaali 75 no-para puma ipisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Go pisa rabu Jekop Isip su-para puma komenaloma naana kasuanu page go su-para puma komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Komenaloma nimuna ronu Sikem su-para mea ria puma rogaasimi. Go suri Abraham-me ali rogaape tapa kabenalo Hamo-na naakinu kana kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Go pisa pare Gote-me Abraham-para pogalu pirape agale kalenalo di rudu lisa rabu naana ruru enaali adaapu Isip su-para kimisu puma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Go-para pirisimi pare werepere Isip-na ali mudu meda piruma go alimi Josep na-adisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Go ali mudumi naana ruru yala mapolaaoma kasuanu radaa mapaaoma nimuna nogo naaki pa komenalo su kamaa-nane mea mapiraasa. ");
INSERT INTO kjs_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Go rabu Moses-na agimi nipu madisa. Go naakiri le-wili kaapu epe-rupa ae naaki yaa-pulu agimi suba repo ada-para madu saapirisa. Go pisa pare werepe nipu kalae naaki-rupa pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Go rabu ali mudu Fero-na waneme muma ora nipuna si-rupa surubisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Go rabu Isip kone makuaae alinumi nipu mogealisimi. Go pisa-pulu Moses-ri nipu yaba yapipi le ali piruma puri pale agaa-para kogono-para puma ali mudu-rupa pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wala werepe Moses-na maali 40 palinaloma nipumi Israel su-para piri amenu adalua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Go pisa rabu Moses-me Isip ali medame ame ralu talaina adisa. Adisa-pulu nipumi ame raba mulalo puma nipumi Isip ali lu makomeama rudu abulisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Go pisa rabu Moses-me kone gu-rupa wisa: Gote-me ni puri ginalo neme amenu raba mealua rabu adalimi kone wisa. Go kone wisa pare amenumi kone gu-rupa nawisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wala ekera-nanere ame laapome yada pisipi rabu Moses adoma yada napipape lo agale gu-rupa lakalisa: Ame laapo, nipiri ora ameaya-le nipimi ake paa-daa makoyaaripi ya? ");
INSERT INTO kjs_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Go lisa pare mo alimi rono pagoma go Moses warolo paoma talo: Aapimi ne ora ali mudu-rupa mapiraaripa ya? ");
INSERT INTO kjs_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Abala go Isip ali meda tyade-rupa ni tyalalo pi pae? ");
INSERT INTO kjs_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Gu-rupa pagisa rabu Moses paala komoma Midian su-para pogola puma yada tyape ali-rupa puma pirisa. Go puma werepere nipumi naaki laapo madisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Maali 40 palisa rabu Moses enaali napiri su Rudu Sainai re-para puma ensel meda adisa. Adisa rabu repena sulaa ralae-na adisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses-me adisa rabu nipumi pala komoma rabu nipu re-para puma adolalo pisa. Go rabu nipumi Mudu Ali-na agale gu-rupa pagisa: ");
INSERT INTO kjs_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Niri nena kasuanuna Gote yaade. Niri Abraham-para Aisak-para Jekop-para nimuna Gote yaade lisa. Go lisa rabu Moses paala komoma pururu pisa pare Gote piri-para na-adisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Go pisa rabu Gote-me nipu-para talo: Nena age ada koyape. Abi ne rekoma aate suri ora Gote-na epe su yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Neme nina Isip su-para piri enaalinuna koe radaa pi kogono-daa ora ade. Nimuna re pagoma nimu raba mulalo epawa. Go pea-le ne rekoma ne Isip su-para painalo pi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Go Moses komeare Israel su-para piri enaalinumi abala giyoma gu-rupa lisimi: Aapimi ne ali mudu-para kose pagape ali-rupa mapiraaripa pae? Go lisimi pare Gote-me Moses ali mudu-para raba mi ali-para pirinalo mea rapasa. Go repena sulaa ralae-para pirisa ensel-me Moses raba minalo Gote-me Moses puri mapabaasa. ");
INSERT INTO kjs_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses-mere Isip su-para napi kogono page rado kogononu page pisa. Nipumi enaalinu Kale Ipa kenaoma enaali napiri su-para maali 40 nimu surubisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses-miri Israel su-para piri enaali abala gu-rupa lakalisa: Gote-me ni mapiraasa-rupa nimina rikirana agale lakale ali meda mapiraalia. ");
INSERT INTO kjs_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses-re Israel su-para piri enaalinu kiritasimi rabu nipumi raba misa. Nipumi ensel raapu Rudu Sainai madaa piruma agale lakalisa. Go ensel-me kasuanu page agale lakalisa. Apo ade abuna mapiraape agale pagisimi rabu nimi page pagaliminalo lagisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Go pisa pare go Moses-re naana kasuanumi koau rilalisimi. Nimimi nipu giyoma wala Isip su-para palima kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Go puma nimumi Aron gu-rupa lakalisimi: Remo medaloma wari lisimi. Go puma nimumi pora walenaloma werepe pomona. Moses-re naa Isip su-para mea epaade pare nipu aa-para puma palo maarea lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Go lisimi rabu nimumi remo mena gawa-rupa warisimi. Nimumi pa kimi warili mena gawa madaa gote ma-aulaaomaa rana ranaa komo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Go rabu Gote-me nimu yaa-para aatade kuba kedonuna bi minasaainalo giyesa. Go madaare Gote-na agale lakale alinumi buk madaa gu-rupa lu wisimi: Nimi Israel su-para piri enaalinu-ya. Nimimi maali 40 su kamaa piruma mena gawanu luma lodo kirisimide-le gore ni-para pisimi pae? Ora dia. ");
INSERT INTO kjs_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nimimi mo remo Molek-na mamina warili abala mea kilipima ria pisimi. Go raapu mo remo Refan-na kuba kedo page minasaasimi. Go remo wasaare nimimi waria kiritasimi. Go pumare neme nimi Babilon su-para maa pua mapiraalua lisa. Profet alimi buk madaa apo agale lu wisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stiven-me agale pena lala lisa: Naana kasuanuri enaali napiri su-para piruma lotu ada sel laplap-me warisimi. Go adare Gote-me Moses-para wariape lo robo wisa-rupa warisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Werepe go laplap-me warili adare kasuanumi sinu-para kalaama puma kasuanumi kilipima ru pisimi. Go puma Josua-me ruru radonu raita maa pisa rabu kasuanu sel ada go-para ma ria pisimi. Go pulalo pisimi rabu Gote-me lore alinu abala ralu rubesa. Go su-parare Devit madisa rabu page sel ada wisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit-ri Gote-me epe ali kone wisa-pulu nipumi Gote-para ne ora kasua Jekop-na Gote yaa-pulu nena pirape lotu ada warialuame pi lo beten lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Go beten lisa pare Devit-na naaki King Solomon nipumi go lotu ada warisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yapare so Adaa Gote-re pa kimi warili ada-para napia. Go madaare Gote-na agale lakale alimi gu-rupa lisa: ");
INSERT INTO kjs_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mudu Alimi gu-rupa lisa: Yaa-parare ora nina piri siaa yaade. No suri ora nina age wi-para yaade. Go pe-le nimimi nina adare ake pu palimi yapae? Go page nina Pomo mu Pirape su yaade. ");
INSERT INTO kjs_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neme go elenuri nina kimi waritu lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven-me kaunsil gu-rupa lakalisa: Nimiri pupitagi no raa-para piri enaali pimi. Nimina kale poaoma Gote-na agale napageme. Nimiri nimina kasuanumi Holi Spirit giyasimide-rupa peme. ");
INSERT INTO kjs_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Profet ora komea nimina kasuanumi radaa nakalasimi ya? Go page nimina kasuanumi epe redepo le ali madaa pora mea waalape ali lu makomasimi. Go puma abi page nimimi nipu koe maduma lu makomasimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nimiri ensel-me Gote-na rekena agale mea lagisa. Go pisa pare nimimi go agale yokoma napagaeme. ");
INSERT INTO kjs_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsil piri alinumi Stiven-na agale pagomare waru rono pagesimi-pulu nimuna kabulu regepe no pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yapare Stiven-re Holi Spirit nipuna lo robaa-para rubitabesa-pulu nipumi so yaa-para Gote-na epe paa adisa. Yesu Gote-na popo ki-nane pirina adisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Adalepa. So yaa lobapaina Gote-na ki popa ki-nane enaali Raapu Pirape alina Si so pia-daa lo Stiven-me gu-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Go lisa rabu nimumi ali-ya loma nimuna kale pora poaoma Stiven wagepu adialalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nimumi nipu adare kamaa-nane raita maa puma kaname lisimi. Go puma nipu lu makomaape alinumi mamina kaloma penaali meda mea kalisimi. Go alina biri Sol yaade. ");
INSERT INTO kjs_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nimumi kaname talaina Stiven-me Gote-para beten gu-rupa lisa: Mudu Ali Yesu, nina wasupa mea lisa. ");
INSERT INTO kjs_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Go lisa rabu rumu pege puma agale puri paloma lisa: Mudu Ali, go alinuna pupitagi koe kedaa na-abulape. Go loma nipu komoma u palisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stiven lisimi go raburi Jerusalem su-para piri kone rulae enaalinu madaa koe kedaa yapi di marekaasa. Go pisa-pulu nimu su rado rado-para yada tya rekoma pisimi. Nimu Judia Samaria su-para yada tya pisimi pare aposel kogono alinu komea napisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Go raburi Gote madaa kone waru rulae ali medalomame Stiven-na ro rogaaoma re lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yapare Sol-me Gote-na ruru kedaa kalalo makoyaasa. Nipu ada komea komea lo pu-para pamuma kone rulae enaalinu aditama karapo ada-para mapaitaasa. ");
INSERT INTO kjs_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yadatape pirisimi kone rulae enaalinumi su raayona puma epe agale la yokesimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip-ri nipu su Samaria adare-para puma apo piri enaalinu-para Gote-me Mea Rapaae Kana agale mogealisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nipumi napi kogono pisa rabu enaali adaapumi nipuna agale pagoma kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Go pisa rabu Filip-mi remo pabo piri enaali adaapuna remo kamaa mapisa. Go remo pisa-daa agale puri pale lisimi. Go puma pora napami ki koe enaalinu page yaina komo pa wi enaalinu page ma-epeaasa. ");
INSERT INTO kjs_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Go rabu Samaria su-parare enaalinumi ora raaname komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Go adare-parare ali meda nipuna bi Saimon pirisa. Go aliri nipu yaina pia ali yaa-pulu Samaria su-para piri enaali raayome nipu paala komisimi. Nipumi ni ora ali mudu lisa-pulu enaalinumi nipuna puri adoma paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samaria su-para piri enaali raayo ora ali mudunu page riabo enaalinu page go yaina pi alina bi waru minasaasimi. Go ali madaa gu-rupa lisimi: Nipu Gote-na puri wia-pulu bi Ora Puri lamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ora raana adaapu nipuna yaina pi kone adoma enaalinumi nipu waru pagisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Go pirisimi pare Filip-mi Gote-na Surube Su madaa Yesu Keriso-na bi madaa Epe Agale lakalisa rabu Samaria su enaalimi agale madaa kone rulaoma kalu-ipa misimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Go yaina pia ali Saimon page kone rulaoma kalu-ipa muma lisana Filip re-para pisa. Go puma nipumi puri pale kogono-para kogono radonu-para adisa rabu paala komoma ki wakepu lisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria enaali Gote-na agale lo robaa-para misimi rabu Jerusalem su-para piri aposel kogono alinumi remaa pagisimi. Go puma nimumi Samaria su-nane Pita Jon laapo maa penaalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Go ali laapo ipisipi rabu nipumi kone rulae enaalinu Holi Spirit minalo beten laasipi. ");
INSERT INTO kjs_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Holi Spirit enaalimi abalade namisimi-pulu nipumi go-rupa pisipi. Nimu kalu-ipa misimi rabu Yesuna bi madaa pagoma misimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Go pisa-pulu Pita Jon laapome nimuna kalu madaa ki winaloma Holi Spirit misimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposel ali laapome kalu madaa ki wisipi rabu go yaina pi ali Saimon-me enaalinu Holi Spirit misimi rabu adisa. Adisa rabu Pita Jon lapo-para mone-me kabano tapa lo agale gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Go puriri ni gialepa. Naa kimi pa enaalinuna kaluna sanoloma Holi Spirit mealimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Go lisa pare Pita-me agale gu-rupa abulisa: Nena kana raapu koe repena sulaa-para pope. Neme Gote-na pa kama gea elere mone-me kabalua kone nasape. ");
INSERT INTO kjs_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nemere kogono pulalo naa raapu kogono ali mada napirali. Nena lo robaa-para epe redepo le kone napia. ");
INSERT INTO kjs_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pare nena lo robaa-para kone ma-epaaoma Ali Mudu-para beten lape. Go puma koe kone marabuaaina beten lape. ");
INSERT INTO kjs_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gore ne kudipa kone suae ali-rupa adalo lisa. Go koneme ne karapo ada mapiraaya. ");
INSERT INTO kjs_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Go lisa-pulu Saimon-me Pita Jon lapo-para talo: Aya, nena lae-rupa ni mada koe elenu na-epena beten tapape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Go puma Jon Pita laapome Mudu Ali-na agale kone polao mogeaoma Jerusalem su-para wala pisipi. Pora kepa pisipi rabu Samaria su-para piri enaalinu Gote-na Epe Agale lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Werepe Gote-na ensel medame Filip agale gu-rupa lakalisa: Nena omoale yarera puma no-nane pumare Jerusalem su wadioma Gasa su lapona pora pope lisa. Go porare enaali napiri su-para go popesa. ");
INSERT INTO kjs_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Go lisa rabu Filip-mi omoale yarera puma pisa. Go pisa rabu Itiopia su-para piri ali meda nipuna ada wala polalo pisa. Go aliri naaki namade abe ali yapare ora ali mudu piruma Kwin ena muduna kana surubisa. Go enana biri Kadasi nipu Itiopia piri enaalinu surubisa. Itiopia alimi Jerusalem su-para Gote-na bi minasaoma ada wala polalo lotu ta pisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nipu hos-me yole kaaris madaa piruma popesa. Pira pale pulaaoma agale lakale ali Aisaia-na pepa madaa yarepeama pisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Go puma Holi Spirit-mi Filip lakalisa: Mogo hos-me yole kaaris re-para puma aasa. ");
INSERT INTO kjs_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Go lisa rabu Filip go ali piri-para wagepu puma agale lakale ali Aisaia-na buk yarepealaina pagisa. Pagoma agale gu-rupa misa: Go yarepeale agalena re makuaae pa? ");
INSERT INTO kjs_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Go alimi talo: Ali medame go agalena re nalagialiadere ake puma makuaalua yapae? Itiopia surube alimi Filip gu-rupa loma lisana hos-me yole kaaris madaa ni raapu epa pira lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mo yarepelisade agalena re gu-rupa lakalisa: Gore nipu tyape mena sipsip-rupa nimumi nipu maa pisimi. Oge mena sipsip-ri iri podetalo rogaaoma pemede-rupa agale lorainaloma nipu maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gore nimumi nipu ora rabuaanaaoma nipu maria-ae kose agale lisimi. Gore nipu nogo naakinu page meda ora napiri. Go puma nimumi nipu lu makomainaloma so yaa-para pisa. Go agalere Aisaia-na buk madaa apo-rupa lu wisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Apode alimi Aisaia-na buk yarepeari Filip-para agale gu-rupa misa: Go agale lakale alina agalere aapi madaa lo aaya pae? Ora nipu madaa lea pae pa ali meda madaa lea pae? ");
INSERT INTO kjs_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Go lisa rabu Filip-mi Epe Agale adaapu mogealisa. Go ali madaa abala yarepelisa agalena re lomare Yesuna Epe Agale mogealalo pisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Go puma pora pulaomare Itiopia surube alimi ipa le meda adisa. Go puma nipumi talo: Go ipa ada. Ake pea neme kalu-ipa namealua yapae lisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip-mi nipu-para talo: Nena pu lome kone waru rulali-daare kalu-ipa mada meali lisa. Go lisa rabu go alimi talo: Abi Yesu Keriso-re ora Gote-na Si yaade kone rulaayo lisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Go rabu mo alimi hos-mena yole kaaris maloraaoma nipu Filip laapo no ipa-para pisipi. Go puma Filip-mi kalu-ipa kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ipa koauna giyoma ipisipi rabu Holi Spirit-mi Filip pane maa pisa. Mo alimi Filip wala na-adisa pare nipu pora-nane pisa rabu nipuna lo robaa-para raana ora waru pisa. ");
INSERT INTO kjs_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip-mi kone muma nipu Asdot su-para pa epa pirisa. Nipumi adare raayona Epe Agale lakelaama pumare Sisaria su-para puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yapare go rabu Sol-me koe agale lala puma Gote-na aposel kogono alinu lu makomaalalo pisa. Go puma nipumi Gote-na lodo kira-ae ali mudu piri puma adisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Go ali mudumi pepa linalo laketa pisa. Go puma Damaskus su-parare Sol-me Juda alinuna lotu ada ru-nane pulalore Gote-na pora raati enaali lotu ada-para madaa wasala pea. Go puma nipumi nimu Jerusalem su-para karapo ada adialalo maa pisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Gore Sol puma Damaskus adare resi-para pamisa rabu nipu piri-para so yaa-para wi paame nipuna le agaa-para pea-rupa ipisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Go rabu Sol nipu su kamaa lopoma agale meda gu-rupa pagisa: Sol Sol, neme niri ake paa-daa makoyaate pae? ");
INSERT INTO kjs_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Gore Sol-me talo: Mudu Ali, nere aapi ya? Agale gu-rupa abulisa: Niri Yesu yaade. Nemere ni ade abuna makoyaaye. ");
INSERT INTO kjs_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yapare ne rekoma so adare-para pu. Neme werepe pali ele ali medame lagialia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Go agale lisa rabu ali medaloma Sol raapu pisimiri pa rekaoma agale nalisimi. Nimumi go agale pagisimi pare pa ele meda na-adisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol su madaa rekesa pare le-para ribaa pa yabaasa. Go pisa-pulu nipuna adami alinumi ki mina muma Damaskus su-para mea lamua pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gore yapi repome Sol-na le-para ribaa pa yabaina eda nanisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Go puma Damaskus su adare-para Gote-na agale lae disaipel ali meda Ananaias pirisa. Nipumi upaa adisa rabu Gote-me agale gu-rupa lakalisa: Ananaias-ya lisa. Nipumi talo: Mudu Ali, ni go pi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gote-me nipu-para talo: Ne rekoma go pora-para pu. Mo porana biri Redepo le Pora, go pora-para pope. Ne Juda alinuna ada puma Tasas su-para piri ali Sol asa pape. Abi go ali Sol-me beten lala pia. ");
INSERT INTO kjs_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nipuna kone-parare ali meda ne Ananaias nipuna ada-para puma kalu madaa ki epa saena kone saapia. Go pali rabu nipuna le wala rupaloma kone saapia. ");
INSERT INTO kjs_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias-me gu-rupa lisa: Mudu Ali, enaali adaapumi go alina koe kone adoma ni lagiame. Jerusalem su-parare nipumi nena epe kone rulae enaali madaa koe kedaa mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gote-na lodo kira-ae ali nimu nipu pepa kalisimi-pulu go ali Damaskus su-para ipumare nena bi minasaa-ae enaali adialalo pea. ");
INSERT INTO kjs_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mudu Alimi nipu-para talo: Abi pu. Neme nipu nina epe raba mi ali mapiraayo. Nipumi nina bi su raayona maa puma ruru radonu page nimuna ali mudunu page Israel enaalinu page nimumi pagenalo maa palia. ");
INSERT INTO kjs_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naa kogono madaare neme nipuna radaa nape elenu mea waatoa. ");
INSERT INTO kjs_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Go lisa-pulu Ananaias puma go ada ru-nane puma kodobaoma Sol-na kaluna nipuna kimi warisa. Go puma nipumi talo: Ame-ya Sol, abala ne pora-nane pamuma Mudu Ali Yesu adaede. Nipumi nena le rupaoma Holi Spirit nena lo robaa-para rubitabenalo ni mea epenala lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Go lisa rabu Sol-na le madaa kepisa ele rakepe pasa rabu le wala rupasa. Go pisa rabu nipu rekoma kalu-ipa misa. ");
INSERT INTO kjs_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Go puma eda noma yogale-para puri wala misa. ");
INSERT INTO kjs_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nipu Juda alinuna lotu adanu-para puma kodobaoma Yesuna bi madaa agale lakalisa. Gore gu-rupa lisa: Yesu ora Gote-na Si yaade lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Go enaalinumi pagomare kidipaa wake lu piruma agale gu-rupa lisimi: Go aliri abala Jerusalem su-para maa piruma Gote-na bi minasaa-ae enaali lu makomasade ali yaade. Go aliri go-para ipuma nipumi Gote-na pora raali enaali adialalo ipisa. Go puma Gote-na lodo kira-ae ali mudunu piri-para maa polalo pi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Go lisimi pare Sol-me agale mogealisa rabu puri meaa-ma pu pirisa. Nipumi Damaskus piri Juda alinu-para Yesu ora Gote-na Mea Rapaae Ali yaade lakenaloma agale mada na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Go puma koro medare Juda alinumi nimu kirita piruma Sol tyalalo yada robesimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pare Sol-me nipu tyalalo pirisimi remaa abala pagisa. Go puma Juda alinumi Sol tyalo pirisimi rabu ada pora gaapenu ora ribaa page alebo page kaleda pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Go pisa pare Sol disaipel enaalinumi nipu lamu muma adaa nu basket-para kaleda mapiraasimi. Go puma pape rarane basket-para maduma puma mea lopaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem su-para puma disaipel alinu raapu pirulalo pisa. Go pisa pare nimumi nipu Gote-na disaipel ali diana kone suma paala komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Go rabu Barnabas-me nipu raba muma disaipel alinu piri lamua pisa. Go puma Barnabas-me Sol pora pamisa rabu Mudu Ali adisade remaa lakalisa. Go puma Barnabas-me Mudu Ali Solo-para agale lakalisade remaa lakalisa. Sol Damaskus su-para pirisa rabu Yesuna agale puri paloma mogeasade page remaa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Go lakalisa-pulu Sol-me disaipel alinu raapu piruma ora paala nakomisa pare Jerusalem raayona puma Mudu Ali-na bi madaa puri pale agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Go puma nipumi Grik agale le Juda alinu-para ape agale lo pirisa rabu nimumi nipu tyalalo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Go disaipel alinumi go remaa pagomare nimu Sol Sisaria su-nane lamua pumare Tasas su-para penaalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Go pisa rabu Judia su robo-para Galili su robo-para Samaria su robo-para kone rulae enanu epe-rupa pirisimi. Go puma Holi Spirit-mi puri kalisa-pulu Gote-na ruru adaa yoma puri palo pisimi. Go puma Gote-na ruru piri enaalinumi nipuna bi waru minasaasa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita nipuri su raayona pamuma agale mogealisa rabu koro medare Lida su-para piri kone rulae enaalinu adola pisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Go-parare ali meda nipuna bi Ainias-re nipu pora napami ali yaa-pulu reke madaa pa pirisa. Go yainare nipu maali 8 ru-nane pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita-me nipu-para talo: Ainias, Yesu Keriso-me ne ma-epelea-le rekoma nena yapara lodea ma-redepoaya lisa. Go lisa rabu Ainias wagepu rekisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nipu rekoma pisa-pulu Lida Saron su laapo piri enanumi nipu adoma nimuna kone pereke yoma Gote-na agale ralisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mo Jopa su-para Gote-na disaipel ena meda pirisa. Nipuna biri Tabita yapare Grik agale madaa Dorkas lisimi. Go bina re-re ora wagepu pope ele-daa leme. Go enare ade abuna epe kogono puma narali enaalinu ele kalala pisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Go rabu nipu yaina meda muma le kadupilisa. Gore nipuna to radepea ada rum sone maa ria puma wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gore adaa kagure Jopare su Lida repara aasa. Go puma Jopa su-para piri disaipel alinumi Pita Lida su-para pia remaa pagisimi rabu ali laapo rapaoma agale gu-rupa lakalisimi: Naa piri wagepu epape lo lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita-me pagoma go su giyoma nimu raapu wala pisa. Opapasa rabu so ada rum ae madaa-nane lamua pirisimi. Go puma ena wasa raayome Pita kutapu ma-awabaaoma re lo pirisimi. Nimumi Dorkas nipuna warili mamina-nu elenu Pita mea waalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita-me enaali raayo kamaa pulupa lomare rumu pege puma beten lisa. Beten lomare go enana ro wi-para leme nipu adoma gu-rupa lisa: Tabita, nere rekoma. Go lisa rabu ename nipuna le rupoma Pita adoma rekoma pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Go rabu Pita-me nipuna ki muma marekaasa. Go rabu nipumi kone rulae enaali-para ena wasanu-para yaaloma go ena epa adalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Go remaare Jopa su one mone lakelalo kiritasimi-pulu enaali adaapumi Gote-na agale madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Go puma Pita nipu Jopa su-para yapi adaapu piruma nipu Saimon raapu pirisipi. Go Saimon-re mena gawana yogaleme ele warili ali. ");
INSERT INTO kjs_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ali meda nipuna bi Kornilius-ri nipu Sisaria su-para pirisa. Nipuri Rom suna ali mudu piruma nipumi soldia ali 100 surubisa. Gore nipuna soldia alinuri nimu madi suri Itali yaa-pulu go bi Itali-repaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Go surube aliri nipu ade abuna lotu lo nimu raapu Gote-na bi minasaaeme. Nipumi kana ele Juda alinuna naraali enaalinu kaloma ade abuna Gote-para beten lala piralia. ");
INSERT INTO kjs_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Koro medare naare alebo ta pulaina 3 klok rabu nipumi upaa-rupa puma ele adisa. Adisa rabu Gote-na ensel meda ipuma epa talo: Kornilius-ya. ");
INSERT INTO kjs_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nipumi mo ensel paala komoma pa adabaaoma talo: Mudu Ali, ake palua ya? Go rabu ensel-me gu-rupa abulisa: Nena beten-para ele raba mi kone-parare Gote-me adaba pia. ");
INSERT INTO kjs_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Abiri neme agale maa pope naaki medaloma Jopa su-para penaala. Nimumi ali meda lamua ipulupape lo laketapape. Go adola palimide alina biri Saimon yapare nipuna bi meda Pita leme. ");
INSERT INTO kjs_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Go aliri nipuna bi komea-rupa ne ali medana ada-para piralia. Nipuri mena gawana yogale raapu kogono pi ali yaade. Nipuna adare no ipa solwara kuni-nane aaya-daa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel-me Kornilius agale gu-rupa lakeloma pisa. Kornilius-mi nipuna kogono naaki laapo-para soldia ali meda page nimu yalisa. Mo soldia ali medare nipu lotu agale pagoma nipumi ade abuna Kornilius raapu piruma raba meape kogono pisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornilius-mi go ali repo-para ensel-na remaa lakeloma mo Jopa su-para maa penaalisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nimu puma pora-nane paluma yapi lapisa raburi wala pumare Jopa su re-para puma opapasimi. Go rabu naare rikirana aina Pita-me ada koauna beten tea pisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Go ada koauna pirisa rabu nipu reame komoma eda nolalo pisa. Gore nimumi eda kiritao kiritasimi rabu Pita-me upaa ele meda ado sa. ");
INSERT INTO kjs_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","So yaa-para pora gaape lobenaloma nipumi ele meda adisa. Adaa mamina elere nimumi kuni maala ripinoma lopataina adisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Go mamina-na ru-nanere mena yaa yapa waalisa kero ele pabo pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Go rabu agale meda gu-rupa pagisa: Pita, ne rekoma mogo elenu lu nape. ");
INSERT INTO kjs_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pare Pita-me talo: Mudu Ali, ni mada dia. Naana rekena agale wia-pulu neme koe edanu-daa nanalua. ");
INSERT INTO kjs_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gore wala rana lapopa agale gu-rupa lakalisa: Gote-me eda ele ma-epeaayare neme go koe edanu-daa nalape. ");
INSERT INTO kjs_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Go agalere rana repo loma lisana mamina ele so yaa-para wagepu maa pisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Gore Pita-me kone adaapu suma apo upaame adalo elere ali yapae kone wisa. Go kone saapiralaina Kornilius-mi mo maa epenalisa alinumi agale meaoma ipumare Saimon-na ada pora gaape-nane epa rekesimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nimumi gu-rupa yaalasimi: Saimon nipuna bi medare Pita. Go aliri go ada-para pia pae napia pae lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita-me nipuna upaa pa makuaaya pirina Holi Spirit-mi gu-rupa lakalisa: Pora gaape-nanere ali repome ne go asapeme-daa lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Go pea-le ne rekoma nimu raapu pope. Neme go alinu maa epenalawa-le kone adaapu nasape pare wagepu pope lisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Go lisa rabu Pita ada-para puma alinu-para talo: Nimimi asapuaarimide aliri ni yaade. Nimi ake pula epame pea lisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nimumi agale gu-rupa lisimi: Surube ali Kornilius-mi pulupa laa-daa epama. Go aliri epe ali piruma Gote-na bi minasaa-ae ali yaade. Juda enaali raayome nipu-para epe kone wimi. Go ali-parare Gote-na ensel medame gu-rupa lakalisa: Neme Pita-na agale maa rapaape. ");
INSERT INTO kjs_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Go agale pagomare Pita-me nimu ada ru-nane lamua puma eda kalo surubisa. Wala ribaa reko Pita-me onale yarera puma nimu raapu pisa. Jopa su-para piri kone rulae amenu medaloma page pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nimu pumare pora meda kura palae pumare Sisaria su-para puma opapasimi. Gore Kornilius-mi nimu adaba pirisa-pulu nipuna ruru-para nipuna adami enaalinu-para yaaloma adola kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ada ru-nane abala ririna kodobasa rabu Kornilius Pita-na kibu re-para puma lopisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Go pisa pare Pita-me nipu marekaaoma talo: Ne reka. Ni page pa nena yago yaade. ");
INSERT INTO kjs_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Go puma Pita Kornilius laapo agale laari puma ada ru-nane kodobasipi. Go ada ru-nanere enaali adaapu kirita pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita-me nimu-para talo: Nimimi ademe. Juda enaalinuri pa ruru enaali radonu raapu mada napitimi. Naa Juda alinuna rekena agaleme gu-rupa lea: Neme ruru radonu-para koeyae pi ena-rupadaa natoa. Dia-le Gote-me ni-para go kone giyala. ");
INSERT INTO kjs_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Go pea-le nimimi ni lamua ipisimide rabu neme agale nagiyasuade pare agale pagoma ni epawa. Gore neme nimi abi agale mealo: Ni ake paa-daa yala simi? ");
INSERT INTO kjs_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornilius-mi talo: Gore numumare rabu naare pereke luma aina ada-para piruma beten lala pirisua. Go rabu ali meda nipu epe kaake pi mamina maaroma ni piri-para epa rekaoma talo: ");
INSERT INTO kjs_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kornilius, Gote-me nena beten-para ele kalaina kogono-para adobaaya. ");
INSERT INTO kjs_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Neme ali meda no Jopa su-para penaaloma ali Saimon Pita lamu mula penaalawa. Go aliri bi komea ne yagona ada-para pirina go ada ipa solwara repale-para aaya. Yagore mena gawa yogale warili ali. ");
INSERT INTO kjs_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Go lisa rabu neme ali medaloma wagepu ne piri epena lawa. Ne waru pagoma epae-le naa raayo abi Gote-na le agaa-para epa pima. Go agalere ake ya? Gote-me ne lagi agale manare naame pagolalo adoba pima. ");
INSERT INTO kjs_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita-me agale abala gu-rupa la yokisa: Gote-me ruru raayo madaa kone meda wia-daa makuaato. ");
INSERT INTO kjs_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Go puma enaali raayome Gote-na bi minasaoma nipu madaa epe kone rulaeme-daare Gote-me nimu raaname komea. Su raayona piri enaalinu madaa epe kone wia. ");
INSERT INTO kjs_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Abala Gote-me naa Israel su-para piri enaalinu-para Yesumi epe-rupa pirape agale laginalo mea rapasa. Yesuri enaali raayona Mudu Ali pia. ");
INSERT INTO kjs_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nimimi Jon-me abala Epe Agale mogeaoma kalu-ipa kalisa-daa pageme kone salo. Werepe Yesumi Galili su-para agale lakelomare Juda su raayona Epe Agale mogealisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nimimi Gote-me Yesu Holi Spirit-para puri kalisade remaa pageme kone salo. Gote-re Yesu raapu pirisa-pulu nipumi su raayo pamuma epe kogono pisa. Go puma enaali raayo Satan-na puri rolo pimiri Yesu-mi nimu maa rapasa. ");
INSERT INTO kjs_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naame Yesuna kogono raayo adema. Juda su-para Jerusalem su-para page enaalinumi Yesuna kogono adema. Go pisa pare nimumi go ali repena polopea madaa lu makomasimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Go pirisimi pare yapi repo tapa-para pirinaloma Gote-me nipu tapa-para wala marekaasa. ");
INSERT INTO kjs_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Go puma naame adamonolo Gote-me marekaasa. Naame kama adaminalo namarekaalisa pare enaali medalomame page adenalo pisa. Nipu tapa-para rekoma ipisa rabu naa nipu raapu meda-para eda no pirisima. ");
INSERT INTO kjs_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Go puma Yesumi naa-para epe agale puma laketapape lisa-pulu go epe agalere enaalinu pamu laketema. Gote-me nipu komea kose pagape ali mapiraasa-pulu naame go agale laketema. Gore ora pa pitimi enaalinu page abala kome enaali page Yesumi nimuna kose pago rumaalia. ");
INSERT INTO kjs_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Gote-na agale lakale alinumi Yesu madaa agale lakalisimi. Enaali raayome Yesu madaa kone rulalimiri Yesuna bina purimi nimina pupitagi ralu rubalia. ");
INSERT INTO kjs_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita-me go agale lalaina Holi Spirit nipuna agale pago pirisimi alinu raayo madaa ipisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Go puma kone rulae Juda alinuri Pita raapu piruma paalame komisimi. Gote-me nipuna Holi Spirit ruru rado enaalinu-para kalisa-pulu Juda alinumi ki ragi luma paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gore ruru rado enaalinumi adaa agale rado rado lo Gote-na bi minasaasimi rabu Juda alinumi paalame komisimi. Go puma Pita-me adoma talo: ");
INSERT INTO kjs_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Go alinuri Holi Spirit meamedere naame page go-rupa misima, Go pea-le aapimi madaa rekena salia ya? Kalu-ipa mada mealimina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Go lisa rabu Pita-me agale mana gu-rupa lakalisa: Yesuna bi madaa kalu-ipa katapape. Go puma Pita-me mo alinu nimuna kone muma yapi medaloma nimu raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Go pisa rabu Judia piri disaipel alinu-para kone rulae alinu-para nimumi pa ruru radome page Gote-na epe agale pageme remaa pagisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Go puma Pita Jerusalem su-para wala pisa rabu oge naakina yogale rugutalo peme alinumi Pita-para rono komoma rono pagesimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nimumi Pita-para talo: Ne abalade ruru radonu yogale naruguli ali raapu eda no pirisimide. ");
INSERT INTO kjs_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Go lisimi rabu Pita-me go agalena re waru gu-rupa lakalisa: ");
INSERT INTO kjs_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Niri Jopa adare-para piruma beten lala pirisua. Go rabu nina kone maa perekema upaa meda adisua. Go puma ora mamina ele meda nipuna kuni ripinaaoma yaa-para epa kilipima ni piri epa wisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gore neme mamina ru-nane waru adisua rabu neme ku-yarinu-para keronu-para yaa yapanu ele raayo adisua. ");
INSERT INTO kjs_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Go rabu agale medame ni gu-rupa lagisa: Pita, neme rekoma mo yarinu lu nape. ");
INSERT INTO kjs_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pare neme gu-rupa lawa: Mudu Ali, neme madaa dia. Neme abalade rekena wi arinu madaa eda-rupadaa ora nanisuade. ");
INSERT INTO kjs_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pare yaa-para agale wala lagisa: Gote-me ele raayo ma-epeaaya-le koto pi ele kone nasape. ");
INSERT INTO kjs_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Go agalere rana repo paganoloma mo yarinu ele raayo wala so yaa-para yola pua. ");
INSERT INTO kjs_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ora go raburi Sisaria piri ali repo ni lamua pulalo nina ada-para epa opapasimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Holi Spirit-mi ne nimi raapu pu lo gu-rupa lagisa-pulu neme kone adaapu nawisua. Go ali ni raapu Sisaria su-para pumare Kornilius-na ada-para pisima. ");
INSERT INTO kjs_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Gore Kornilius-mi ensel meda nipuna ada-para pirina adisa remaare naa lagisa. Go ensel-me nipu lakalisa: Neme Jopa su-para ali maa rapaaoma Saimon lamua ipulupape. Go ali nipuna bi laapopare Saimon Pita leme. ");
INSERT INTO kjs_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Go ali nipumi epe agale lagialia rabu ne-para nena ada-para piri enaalinu-para nimi ade abuna kagaa piramala pope remaa lagialia. Go ensel-me gu-rupa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Gore neme agale pena lalano Holi Spirit nimu madaa ipisa. Abalade naa madaa ipisade-rupa ipisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ipisa rabu neme Mudu Alimi agale lagisade-rupa kone-para wala wisua. Nipumi abala gu-rupa lisa: Jon-mere enaalinu kalu-ipa kalisa rabu pa ipame kalisa pare nimiri Holi Spirit-na kalu-ipa mealimina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Naame Mudu Ali Yesu Keriso madaa kone rulaoma Holi Spirit misima. Go puma Abiri go ruru rado enaalinu komea-rupa misimi. Gore komea-rupa misimi-pulu neme Gote-na kogono mada nama-koeyaalua kone wisua. ");
INSERT INTO kjs_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Gore nimumi Pita-na agale pagomare nimuna rono agale giyoma Gote-na bi minasaasimi. Nimumi talo: Gote-me ruru rado enaalinu page ade abuna kagaa piramala paliminalo kone perekeape pora waalisa. ");
INSERT INTO kjs_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiven lisimi rabu adaa kedaa maa kalisa-pulu kone rulae enaalinu pu pa yabesimi. Go puma Fonisia su-para Saiprus su-para Antiok su-para page epe agale lakalisimi pare nimumi Juda enaalinu kama agale lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Go pisimi pare Saiprus Sairini su laapo piri kone rulae ali medaloma Antiok su-para puma ruru rado enaali-para Mudu Ali Yesuna Epe Agale pua lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Go puma Mudu Alimi puri kalisa-pulu enaali adaapumi Epe Agale madaa kone rulaoma Gote-para kone perekelisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Go pirisimi rabu apo Jerusalem su-para kone rulae enaalinumi remaa pagisimi-pulu Barnabas mo Antiok su-para penaalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas nipu puma opapasa rabu nipumi Gote-me go enaalinu raba mina adoma raaname komoma agale gu-rupa lakalisa: Go epe agale nagiyoma Mudu Ali raapu puri paloma kogono pu piralepape. ");
INSERT INTO kjs_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ora epe ali piruma nipumi Gote-na agale waru pagoma Holi Spirit nipu madaa waru rubitabisa. Go rabu enaali adaapumi Mudu Ali-na agale madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Go puma Barnabas-me Sol mo Tasas su-para asa pula pisa. Nipu abala adasaaoma mo Antiok su-para lamua ipisa. Go puma maali komeamere mo Antiok su-para Gote madaa kone rulae enaali raapu piruma enaali adaapu mogeasipi. Go Antiok su-parare nimumi disaipel enaalinu Keriso-na bi abala kalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Go rabu Gote-na agale lakale ali medaloma Jerusalem giyoma Antiok su-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pisimi rabu agale lakale ali meda Agabus page ipisa. Holi Spirit-mi su raayona rea ora adaae pabenalo go alina kone-para mea kalisa. Go puma Agabus-me enanu gu-rupa lakalisa. Gore werepe ali mudu Sisa Klodius pirisa rabu reame waru komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Go agale pagisimi rabu disaipel enaalinu Judia su-para piri ame bali enaalinu-para eda kabape kana maa pena kone wisimi. Nimuna kone suma kana komea komea kaloma gu-rupa raba misimi. ");
INSERT INTO kjs_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nimumi go-rupa puma Barnabas Sol laapo kana kalenaloma lotu ada surube alinu-para maa pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Go rabu ali mudu Herot-me Gote-na ruru medaloma-para kedaa waru mea kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nipumi Jon-na ame Jems rai kudumi lu makomasa. ");
INSERT INTO kjs_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Go pumare Juda alinumi nipu madaa pedo pisimi. Go pisa-pulu Herot-me Pita page karapo mapaitaasa. Go pisa yapi di-ri olode raburi bret ma-adaa yis nasape di rabu pisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita adiala karapo ada-para soldia 16 nimumi Pita surubisimi. Go pirisimi pare maalapumi surubenaloma maalapumi rado medame surubisimi. Herot-na konere go olode Pasova dia naloma Juda alinu piri-para Pita maa palua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Go pulalo pisa-pulu Pita karapo ada-para waru surubisimi. Go rabu Gote-na rurumi Pita raba minalo Gote-para beten waru laasimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Go ribaa raburi Herot-me Pita ekera-nane kose talo pisa. Go puma go ribaa rabu Pita nipu soldia ali laapona rikirana palisa. Nimu hankap adaalepe laapome adima plisman-numi karapo ada pora gaape-para surubisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ora go rabu Mudu Ali-na ensel epa aasa rabu karapo ada-para nipuna paa kewo aasa. Ensel-me Pita-na pasaa luma marekaasa. Marekaaoma gu-rupa lisa: Ne wagepu ipu. Go lisa rabu hankap su kamaa koyataboma lopisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ensel-me talo: Aako let yamoma age ada maara lisa. Pita-me go-rupa pisa rabu ensel-me talo: Nena mamina maraoma ni raita mea epape. ");
INSERT INTO kjs_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita go ensel raita maa puma karapo ada giyesa pare go ensel-me pisare Pita maaresa. Nipuna konere pa upaa pi kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pare nipu laapo puma polis komea pirina popesipi wala laapo pa pora gaape-para pirina popesipi pare puri pale pora gaape-para pisipi. Go pora gaapere nipu pulaina nipuna pa lobesa. Nipu kamaa pumare pora-nane pisipi rabu ensel-me Pita wagepu giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Go rabu Pita nipuna kone epa lobaitaboma gu-rupa kone wisa. Abiri neme go paede elere ora neme makuaato. Mudu Alimi nipuna ensel mi epenala-pulu go ensel-me Herot-na puri giyanolo epenalisa. Go pea-le Juda rurumi ni madaa pulalo palemedere mada napalimi lisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nipumi go kone suma Maria-na ada-para pisa. Go enare Jon-na agi pirisa. Jon-na bi medare Mak. Gore enaali adaapu go ada-para piruma beten lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Go rabu Pita-me kamaa pora gaape tyaara kogono ena Roda-me pora lobolalo ipisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nipumi Pita-na agale pagomare lo robaa-para raana komisa-le pora gaape nalobe ru-nane wagepu wala pisa. Gore Pita ada pora gaape-para epa aaya-le nimi rekalepa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Go nogome nimu gu-rupa lakalisa rabu nimumi talo: Nere makeyatepa pe lisimi. Pare nogome talo: Ora lawade lisa. Go puma enaalinumi talo: Gore Pita-daa dia yapare nipuna ensel yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Go agale lisimi rabu Pita-me awoma kimi pora gaape luma adobaasa. Go puma ru-nane piri enaali ipuma pora gaape loboma Pita-na le agaa adisimi-pulu paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Go raburi Pita-me nipuna ki musaoma wa loma agale maloraasa. Go puma mo karapo ada-para Mudu Alimi nipu mea rapaaripa remaa lakalisa. Go puma Pita-me talo: Nimi Jems-para nipuna amenu-para go remaa laketapape lisa. Go loma ada giyoma wala su rado-para pisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Gore naare rapasa raburi Pita napirisa-pulu mo soldia alinumi pogolasaoma agale adaapu lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gore ali mudu Herot-me puri pale agale lakenaloma asapisimi pare na-adasasimi. Go puma ali mudumi mo surube alinu agale mulalo ipulupa lisa. Nimuna agale pagomare apo surube alinu puma lu makomaalepa lo lakalisa. Go rabu Herot Judia su giyoma mo Sisaria su-para puma pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Gore Herot-me Tair Saidon su laapona piri enaalinu-para rono pagisa. Go pisa rabu go su laapo piri enaalinu nimumi Herot adola pirisimi. Nimumi kiritaoma ali Blastus-me nimu raba minalo yaalisimi. Go aliri nipumi Herot-na adana surube ali pirisa. Go pirisa rabu Herot piri-para puma naa epe-rupa piramina puma lisimi. Herot-na Surube Su raayo madaa nimuna eda misa-pulu go agale lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Enaalinumi gu-rupa lakalisimi-pulu Herot-me agale pagape yapi raburi nipuna epe au pawa nipuna epe pirape siaa madaa piruma enaalinu-para remaa lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Go agale lisa rabu enaalinumi lalaaoma gu-rupa yalaasimi: Go agalere ora Gote-na agale ta-le ora pa ali medana agale-daa dia lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Go lisimi rabu Herot-me Gote-na bi namakuaasa-pulu ensel medame Herot lu makomasa. Go puma ora komenalo kolaimi nipuna yogale waru nisimi. ");
INSERT INTO kjs_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Go pisa pare Gote-na epe agale puri paboma su raayona pisa. ");
INSERT INTO kjs_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas Sol laapome kogono pu kiraluma Jerusalem giyoma go ali Jon Mak maa puma Antiok su-para pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok su-para piri enaalinuna lotu ada-parare Gote-na agale lakale alinu-para tisaa-nu page pirisimi. Nimuna biri go-rupa: Barnabas-para Simeon nipuna bi medare Niger-para Sairini su-para piri ali Lusius-para gavman adaa ali Herot-na ame Manain-para Sol-para nimu raayo lotu ada komea-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Go alinuri koro meda lotu ada-para kiritaoma Gote-para beten loma eda adaaoma pirisimi. Go rabu Holi Spirit-mi nimu-para talo: Go ali Barnabas Sol laapore neme kogono madaa mapiraayo-pulu go ali laapome kogono palipinalo laketape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Go lisa rabu kiritape alinumi eda wala giyoma beten medaloma nimuna kimi kaluna suma nipu laapo maa penaalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Holi Spirit-mi Barnabas-para Sol laapo maa penaaloma ali laapo no Selusia su puma Saiprus su pulalo ipa sip kaboma pisipi. Go Saiprus suri ipa solwara rikirana aasa. ");
INSERT INTO kjs_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Go Saiprus su opapasipi rabu Salamis adare-para pisipi. Go rabu nipu Juda alinuna lotu ada-para puma kodobaa-ma Gote-na epe agale la yokesipi. Mogeasipi rabu Jon Mak-me mo ali laapona kogono raba misa. ");
INSERT INTO kjs_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nimu go ipa solwara rikirana wi su Saiprus pamuma lakalisimi rabu Pafos su adare-para pisimi. Go su-para pisimi rabu nimumi yaina pi ali meda adisimi. Go Juda alinuna biri Bar Jisasre nipumi ni agale lakale ali pi loma enaalinu makiralisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Go yaina pi aliri nipu mo ipa solwara rikirana wi su-para gavman-na mudu ali raapu pirisa. Ali mudu nipuna bi Sergius Paulus loma kone makuaae ali lisimide. Apo ali mudumi Gote-na epe agale pagenalo Barnabas-para Sol laapo ipulupape lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Go pisa pare yaina pape alimi aposel kogono ali laapona kogono makoyaatalo pisa. Go yaina aaraana biri Bar Jisas yapare adaa agalemere Elimas lisimide. Nipumi gavman-na ali mudumi Mudu Ali-na epe agale lo robaa-para makodobalia lo agale mabebolaasa. ");
INSERT INTO kjs_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Go pisa pare Sol-re nipuna bi meda Pol Holi Spirit-na puri nipu waru rubitabisa-pulu nipumi Elimas-na le agaa waru adabaaoma talo: ");
INSERT INTO kjs_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nere ora Satan-na si yaade. Nere epe kone raayona yada lore ali. Nere makirae ali piruma neme Gote-na ora redepo le pora makoyaalalo paina. ");
INSERT INTO kjs_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Neme gu-rupa pe-pulu Gote-na kimi ne abi lina. Abi ne le rubu pi ali piruma naare mada na-adali. Gu-rupa lisa rabu Elimas-na le-para pobere mole eleme le epa keapisa. Go pisa-pulu nipumi enaalina ki ripinaalalo waalisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gore gavman-na ali mudumi go ele adisa rabu nipumi epe agale madaa kone rulasa. Nipumi Mudu Ali-na epe agale pago pirisa-pulu nipu ora paala komisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol nipuna ame raapu ipa sip madaa pua piruma Pafos su giyoma Perga adare su-para pisimi. Perga adare-re Pamfilia su robo ru-nane aasa. Go pirisimi pare Jon Mak-me nimu giyoma Jerusalem su-para wala pisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nimumi su Pega giyoma pumare Antiok suri Pisidia su robo ru-nane puma opapasimi. Go puma oge koro rabu Juda alinuna lotu ada-para puma pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Go Juda alinuna lotu ada-para piri ali kalunumi Moses-na rekena agale yarepema Gote-na ali lakale agale yarepeare nimumi Pol-na amenu piri-para agale meda gu-rupa penaalisimi: Amenu, nimimi enaalinuna lo robaa-para puri mapalaape agale saliare meda lagialepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Go lisa-pulu Pol rekoma ki wageoma pagalepa loma lisana talo: Israel enaalinu nimimi pagalepape. Gote-na bi minasaaeme ruru rado enaalinu nimimi page pagalepape. ");
INSERT INTO kjs_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Gore Israel su-para piri enaalinuna Gote-me naana kasuanu mapiraaoma nimu Isip su-para yadala pe alinu pirisimi rabu nipumi puri kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Go puma nimu maali 40 enaali napiri su-para pamuma kedaa mu pirisimi. Go rabu Gote-me nimu pa adabaasa. ");
INSERT INTO kjs_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Go puma Kenan su-para pirisimi rabu Gote-me enaali ruru 7 lu bebolasa. Go puma nipumi nimu go su kalenaloma maali adaapu gu-rupa 450 go su-para pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Go puma werepere nipumi kose pagape alinu mapiraoma pumare agale lakale ali Samuel pirisa rabu dia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Go puma Israel enaalinumi ali mudu meda mulalo pirisimi rabu Gote-me Sol mapiraasa. Solo-re nipu Kis-na si ora Benjamin-na ruru ru-para pirisa. Nimuna ali mudu maali 40 pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Go puma Gote-me nipu raluma Devit ali mudu mapiraasa. Go ali madaare Gote-me nipu remaa gu-rupa lakalisa: Go ali Jesi-na si Devit-ri nina kone mogealalo pia-le nipumi nina kone raayo adoma palia. ");
INSERT INTO kjs_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gote-me kana waraaoma lakalisa-pulu ali Devit-na madina sinu Israel enaalinu raba minalo lakalisa. Go lakalisa-pulu Yesu Devit-na ruru raapu pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Gore Yesu naipisa rabu Jon abala ipuma Yesuna pora maredepo yaasa pisa. Go puma nipumi Israel su-para piri enaalinu-para pupitagi ne kone pereke yoma kalu-ipa mealepape lo lakalisa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon-na kogono dia talo pisa rabu nipumi enaalinu-para talo: Nimimiri ni aapi kone wimi? Niri mo nimina ada paba pimi ali-daa dia-le pagalepape. Go aliri nina koau-nane epalia pare ni raba mi ali yaa-pulu nipuna age ada kepema kege radepe yaala palua. ");
INSERT INTO kjs_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Go loma Sol-me wala talo: Amenu page Abraham-na madina sinu page ruru rado Gote-na bi minasaaeme enaalinu page pagalepape. Gote-na agale naa raba minalo nipuna epe agale naa re-para epenalisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Go Jerusalem su-para piri enaalinumi page nimina ali kalunumi page Yesu ora raba mi ali lo na-adisimi. Go page ade abuna Pomo mu Pirape Yapi rabu Gote-na agale lakale alinuna buk yarepema giyoma napagesimi. Go peme pare Yesu madaa kose lape agale lisimi rabu nimumi Gote-na agale lakale alina agale ora yaana lo adisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Gore nimumi Yesuna koe elenu page meda na-adisimi pare Pailat-para Yesu linalo agale mulalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gore nimumi Yesu madaa buk-para wisade agale raayo nalisimi. Go puma nipu repena polopea madaa kilipima kana apedaa-para rogaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Go pirisimi pare ora komape su-para pirisa rabu Gote-me nipu wala marekaasa. ");
INSERT INTO kjs_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Go puma abala Galili su giyoma Jerusalem su-para nipu raapu pora pamisimide alinumi nipu rana adaapu adisimi. Go adisimide alinumi abi pa pimi Juda enaalinu-para agale lakeleme. ");
INSERT INTO kjs_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Naa go-para epa pimare Gote-na Epe Agale nimi lagula epama. Go Epe Agalere Gote-me abala naana kasuanu lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Go lakalisade agalere naana kasuanumi Si Yesu tapa-para marekaasa-daa madaa pisa. Go madaare Buk Sam madaa agale gu-rupa wisa: Nere nina si. Abiri neme kogono gialo lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Gote-me Yesu nipu tapa-para marekainaloma nipuna yogale mada naramualia. Go madaare Gote-me buk-para gu-rupa lisa: Neme Devit-na epe raba meape puri ora gialua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Go puma Buk Sam-na agale meda gu-rupa lu wisa: Nena ade abuna epe-rupa pirape alina yogale mada naramualia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Go Devit piruma Gote-na kogono puma nipu komeame enaali raba mulalo pisa. Go puma komisa rabu nipuna ro kasuanauna tapa kamaa rogaaoma yogale ramisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Go pisa pare Gote-me marekaasade aliri nipuna yogale naramisaaya. ");
INSERT INTO kjs_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Go pea-le amenu pagalepape. Neme go ali Yesuna bi madaa lagialo. Nipumi enaalinuna pupitagi nape kone rakepema rubalia. ");
INSERT INTO kjs_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Go puma enaali raayome nipu madaa kone rulaoma pupitagi ne kone madaa giyalimi. Moses-na rekena agaleme go pupitagi ne kone mada namarakepeaasa pare Yesumi ora pisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gore waru pagalepape. Abalade Gote-na agale lakale alinumi lakalisimi-daa nimi piri-para epalia lo lisa. Nimumi gu-rupa lisimi: ");
INSERT INTO kjs_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nimi ero le alinuri paalame komoma waru adalepape. Gore nimi abi pimi rabu neme epe kogono pe. Neme go kogono pe pare ali medame go elena re mea waateare kone mada narulalimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Barnabas Pol laapome go remaa lakeloma Juda alinuna lotu ada kamaa pisipi. Go puma enaali medalomame talo: Wala Pomo mu Pirape Yapi rabu naa kiritaminaloma go agale medaloma epa lagialepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Go lotu ada giyoma pirisimi Juda enaalinu page ruru rado kone rulae enaalinu page Barnabas Pol laapo raita maa pisimi. Go rabu ali laapome talo: Gote-na raba meape kone waru saapiruma nipu madaa kone rulaalepape lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Go puma wala Pomo mu Pirape Yapi di rabu adare-para piri enaali raayo epa kiritaoma Gote-na epe agale pagolalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Go pirisimi pare Juda enaalinumi go enaali adaapu epa kiritaaoma adisimi rabu nimuna lo robaa-para kudipa kone wisimi. Go puma nimumi Pol-na agale rabuaalalo ero agale lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Go pirisimi pare Pol Barnabas nipu laapomere Gote-na agale puri paloma gu-rupa lakalisipi: Saame nimi Gote-na agale abala lagisipade pare giyamede. Go giyamede pare nimimi go agale giyoma naa ade abuna kagaa piramala pope kone mada napalima leme-pulu adalepa. Abi saa ruru rado meda-para palipa. ");
INSERT INTO kjs_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mudu Alimi saa pi agale mana gu-rupa lagia: Neme ne ali ruru rado madaa kewape paa maa salua. Go pea-le su raayona piri enaalinumi epe agale pagoma kagaa piramala paliminalo nina paa nana pi piramina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Gore ruru rado piri enaalinumi go remaa pagisimi rabu nimu raaname komoma Gote-para epe agale madaa ora pili lisimi. Gote-me abala ade abuna mapiraalalo mada misade enaalinumi epe agale madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Go puma go su-parare enaali raayome Mudu Ali-na agale pago kiritasimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Go pisa rabu Juda alinumi go adare-para piri lotu leme alinu-para epe enaalinu-para mudu enaali medaloma page koe-rupa ma-rekaasimi. Go puma go enaalinumi Pol Barnabas laapo kedaa kaloma pa su meda-nane ralisimi. ");
INSERT INTO kjs_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Go pisimi pare aposel kogono ali laapome enaalinu nimuna koe-rupa peme-daa kone winalo age kege radepesipi. Go puma nipu wala Aikoniam su-para pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Go puma aposel kogono alinuri Holi Spirit-na puri nimuna lo robaa-para rubitabesa rabu raaname komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Go puma abala mogeasipi-rupa Pol Barnabas laapo Aikoniam su-para Juda alinuna lotu ada-para puma mogesipi. Go pisa rabu Juda enaali adaapu page ruru rado enaali adaapu page epe agale madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Go pisa pare kone narulae Juda enaalinumi ruru rado enaalinuna kone makoyaasimi rabu ame balinu madaa koe kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Go pisa-pulu Pol Barnabas nipu laapo go su-para yapi adaapu pirisipi. Pirisipi rabu Mudu Ali madaa agale puri paloma lisipi. Go rabu Gote-me ora nipuna raba meape kone madaa agale lakenalo waalisa. Go puma go ali laapome napi kogono page epe rado kogononu page pinalo puri kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Go pisa pare go adare-para piri enaalinuri kone laapo suma rugulalapa pirisimi. Enaali medalomame Juda alinuna pora raitalalo pirisimi pare enaali medalomame aposel kogono alina pora raitalalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Go rabu ruru rado enaalinu-para Juda alinu-para surube alinu page nimumi aposel kogono alinu madaa koe kone suma kaname tyalalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Go pisa pare aposel kogono alinumi go remaa pagisimi rabu nimu Listra Derbe su laapo adare-para pogola pisimi. Go adare laapore Likonia su robo ru-nane aasa. Go su raayona page pogola pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Go su-paranu nimumi Epe Agale mogealisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Go adare Listra-parare pora napame ali meda piruma nipuna age laapo komapasa. Agimi madisa rabu ali koeya palae madu wisa-pulu pora mada napamisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Gore Pol-me agale lakalisa rabu go alimi waru pagisa. Pol-me nipu waru adabaaoma nipuna lo robaa-para yaina perekele kone adisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Go pisa-pulu nipumi puri paloma talo: Waru rekape lisa. Go lisa rabu mo ali wagepu rekoma pora pamisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gore go-para piri enaali adaapumi Pol-na kogono adoma nimumi adaa agale Likioniame gu-rupa lisimi: Sogo yaa-para remonu-rupa pirisimi pare yaa giyoma none ipuma ali-rupa pipi lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Go loma nimumi Banabas-na bi Remo Sus bi maasimi. Go pumare Pol-na bi Remo Hermes maasimi. Gore Pol agale adaapu le ali pirisa-pulu nimuna Hermes remo kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Go puma Remo Sus-na adarena pora gaape-nane aasa. Go remo Mudu Ali repame mena gawana madaa repena kaladina kili suma ipisimi. Nimumi kolo ria ipisimi rabu enaali adaapuna konemere mena gawa luma aposel kogono alinu kalema kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Go pisa pare Barnabas Pol laapo go remaa pagisipi rabu nipuna yagaa iri pudia enaalinu piri rikirana wagepu puma yaalisipi: ");
INSERT INTO kjs_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Go konere ake paa-daa wimi pae? Saa ora nimi pa ali laapo pipa. Saame Epe Agale lagula epapa. Nimimi komape remonu giyoma ade abuna piri Gote madaa kone rulalimina. Gote-mere su yaa ipa page nipuna piri ele page warisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Abasadere go pirisimide kasuanu nimuna kone ele rado wisimi rabu Gote-me nimuna go-rupa ora pa pina kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Go pisa pare nimimi kone adaliminalo epe kogono pu pirisa. Go puma nipumi epe maapu ele waru openalo yai ma-epeaasa. Go pisa-pulu nimimi eda mada noma lo robaa-para epe kone su pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Go agale lisipi pare enaalinumi mena gawa aposel kogono ali laapo kalalo pode pisimi. Go pisimi pare nipumi rono lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Go pisa rabu Antiok Aikoniam su lapo-para piri Juda enaali medaloma Pol piri-para ipisimi. Go puma go Juda alinumi enaalinu-para kaname Pol tyalalo kone kalisimi. Nimumi Pol luma adarenu su kamaa mea yoloma rubisimi. Nimumi Pol ora komena kone wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Go pisimi pare disaipel enaalinumi Pol piri-para kiritainaloma Pol ora rekoma adare-para wala pamisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Go puma ekera-nanere Pol Barnabas laapo Derbe su-para pisipi. Pol Barnabas laapome Derbe su-para Epe Agale mogesipi rabu enaali adaapumi Gote-na pora ralisimi. Go puma nipu Listra su-para wala pumare wala Aikoniam su-para pumare wala Antiok su-para pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nipumi kone rulae enaalina lo robaa-para puri mapalaasipi. Agale mana gu-rupa lakalisipi: Nimiri epe agale waru surubuma mealepape. Gote-na Surube Su pope pora madaare kalai puma kedaa pi ele ria puma adalimina. ");
INSERT INTO kjs_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Go puma nipumi lotu ada komea komea lo surube alinu mada mulalore beten lo eda nano pirisimi. Go puma nipuna Gote-na purimi go alinu surubenalo beten lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Werepe nipu laapo Pisidia su robo ru-nane puma giyomare Pamfilia su-para opapasipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Go puma nipumi epe agale Pega su-para piri enaalinu Gote-na agale mogeaoma no Atalia su-para pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Sip mumare wala Antiok su-para pisipi. Go su-parare lotu surube alinumi nipu laapo Gote-me surubenalo beten loma penaalisimi. Go pula penaalisimide kogonore abi dia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Gore Antiok su-para opapasipi rabu Gote-na ruru enaalinu kiritainalo yaalisipi. Go puma Gote-na kogono madaa agale lakalisipi. Gote-me ruru rado piri enaalinu-para epe agale kone rulainalo pora mea waaloma remaa lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Go puma yapi adaapu mo kone rulae enaali raapu pirisipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ali medalomare Judia su giyoma Antiok su-para ipuma Keriso-na enaalinu-para gu-rupa mogealisimi: Moses-na rekena agale madaare nimimi yogale kuni narugulimi-daare Gote raapu ora mada napitimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Go lisimi rabu Pol Barnabas laapo nimu raapu ape loma ape pisimi. Go pisimi-pulu Pol Barnabas laapo page Antiok su piri ali medaloma page Jerusalem su-para pulalo pisimi. Go puma nimumi aposel kogono alinu-para lotu surube alinu-para yogale ruguli kone madaa agaa mulalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Go puma Yesuna pora rali enaalinumi nipu maa penaalisimi. Go puma Fonisia su-para Samaria su-para pumare agale gu-rupa lisimi: Adaa ruru rado enaalinumi koe kone pereke yoma Gote-na epe agale lo robaa-para makodasimi. Go lisimi rabu Keriso-na enaalinumi raana komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Go puma Jerusalem su-para opapasimi rabu Gote-na ruru-para aposel kogono alinu-para lotu surube alinu-para nimu raayome nimu ki muma ora raana komisimi. Go rabu nimumi nimu-para Gote-na pisade kogono madaa remaa lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Go rabu Farisi kone rulae ali medalomame rekoma talo: Gore apo ruru rado alinumi page yogale kuni rugutapape leme. Nimumi Moses-na rekena agale go-rupa pagaliminalo laketapape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Go lisimi-pulu aposel kogono alinu-para lotu ada surube alinu raapu kiritaoma apo agale madaa kone meda sulalo wisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Go agale loma yoloma kiritainaloma Pita-me rekoma talo: Ame balinu, Gote-me ni abala mada misa-daa adisimide. Go pea-le neme Gote-na epe agale ruru radonu-para mogeasua. Nimimi pagoma kone rulaliminalo mogeaayo. ");
INSERT INTO kjs_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Gore Gote-me enaali raayona lo robaa-para adea-le nipumi ruru rado enaali nagieyeme yapare Holi Spirit misima-rupa ada ruru rado enaalinumi page misimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gote-me naa Juda ruru enaalinu mo ruru rado enaalinu kone komea suma Holi Spirit gisa. Nimumi kone rulasimi-pulu Gote-me nimuna pupitagi ne kone rakepema rubaasa. ");
INSERT INTO kjs_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Go pisa-pulu ake paa-daa naame ruru rado-para Moses-na kedaa pi kone mogealima ya? Abalare naa-para kasuanu-para go kedaa pi kone mada nawaatema. ");
INSERT INTO kjs_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dia, naame Mudu Ali Yesu madaa kone rulaema rabu nipumi nipuna epe raba mi koneme naana lo robaa-para paa ginaloma ade abuna kagaa piramala palima. Ada ruru rado nimumi page go kone komea salima. ");
INSERT INTO kjs_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Go agale lakelenaloma enaalinumi agale na-abulisimi. Dia, pare Barnabas Pol laapome Gote-na puri pale kogono-para kogono radonu-para lakalisipi rabu waru pagisimi. Go remaare ruru rado piri enaalina su-para pisipi rabu lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Gore agale lakelenaloma Jems-me talo: Amenu, nina agale pagalepape. ");
INSERT INTO kjs_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Gore Gote-me ruru rado enaalimi nipuna bi pagenalo mapiraasa. Go madaare Simiono-me naa-para go abala pisade alinuna remaa lagisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Go madaare Gote-na agale le alinumi go pora adoma nimumi buk madaa gu-rupa lu wisimi: ");
INSERT INTO kjs_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mudu Alimi talo: Werepe ni wala epalua. Go puma neme Devit-na sinumi kilipili ada marekaalua. Wala marekaalua rabu puri katoa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ruru rado raayona enaalinumi ni Mudu Ali asapalimi. Go ruru raayore ora nina kone rulae enaalinu mapiraalua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mudu Alimi gu-rupa lisade agalere ora abalade nipuna kogono waalalo go agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems-me wala talo: Naa konere ruru rado piri enaalinumi Gote-na agale lo robaa-para makodabalimiri nimu kone kedaa nakatema. ");
INSERT INTO kjs_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Dia, pare naame nimu-para agale meda gu-rupa luma rapaaeme. Nimumi remo yawoma kale eda nanalepape lema. Go page ena paake yolape kone giyoma mena yapa maa erepele yariri nanalepape lema. Go page yaapi nanalepape lema. ");
INSERT INTO kjs_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gore ora abalade abi page tisaanumi Moses-na rekena agale madaa adare raayo-para piruma ade abuna Pomo mu Pirape Yapi rabu rekena agale yarepealimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Go rabu aposel kogono alinu-para lotu ada surube alinu-para piri enaali-para go nimu raayome kone komea suma ali medaloma mada muma Antiok su-para penaalisimi. Go puma nimumi Pol Barnabas laapore ali medaloma raapu penaalisimi. Go puma epe ali mudu laapo Judas Sailas laapo page mada muma penaalisimi. Judas-na bi medare Barsabas. ");
INSERT INTO kjs_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Maa pisimi rabu pepa luma kalisimi: Naa aposel kogono alinu page lotu surube alinu page naame nipi Antiok su-para Syria su-para Silisia su-para ruru rado amenu epe-rupa piralepape lo rapaatema. Naame go agale lo rapaatema. ");
INSERT INTO kjs_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gore naame remaa meda gu-rupa pagisima. Naana ruru piri ali medalomame agale mana epaloma nimi mareko koyaarimi. Go pagisimi pare naame go agale mana nalakalisima. ");
INSERT INTO kjs_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pare go-rupa lisimi-pulu naa kiritaoma agale laketema ali medaloma muma maa penaatema. Go naana epe adami alinu Barnabas Pol laapo nimu raapu epalimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Go ali laapore naana Mudu Ali Yesuna kogono pisipi rabu lore alinumi nimu ora lu makomasimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Go puma mea rapaarimade aliri Juda Sailas laapo penaatema. Go ali laapore naana agale muma nimina le agaa-para piruma go agale wala lagialimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gore Holi Spirit-mi naa agale lagisa-pulu naame kedaa pi pora medaloma nalagialima. Dia, pare go rekena agale kama lagialima: ");
INSERT INTO kjs_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gore remo yawoma kale eda nanalepape. Gore yaapi page nanalepape. Go page mena yaa yapa maa erepele-ai page nanalepape. Go page ena paake yolape kone nasalepape. Apo rekena agale maalappu mogeaalepape. Go koe elenu-daa giyalimiri ora epe-rupa mada piralimi. Abi patalepape. ");
INSERT INTO kjs_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Go rabu agale lakale alinu maa penaaloma Antiok su-para pisimi. Go su-para opapasimi rabu kone rulae enaalinu makiritaoma pepa kalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Go puma mo enaalinumi go pepa yarepema go remaa madaa raaname komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda Sailas laapore ora Gote-na agale lakale ali yaa-pulu Keriso-na enaalinu-para agale lala pirisipi. Go puma nimuna robaa puri mapalainalo agale lala pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Go puma koro meda nimu raapu piruma wala rapaasimide enaalinu piri wala pulupape lisimi. Nipu pulalo pisipi rabu nimi epe-rupa piru paitalepape lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pisipi rabu Sailas nipuna konere pa pitua kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Gore Pol Barnabas laapo Antiok su-para page piruma enaali adaapu raapu Gote-na epe agale mogeaasipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wala werepere Pol-me Barnabas-para talo: Gore abala Mudu Ali-na epe agale lakalisipa su raayona wala bana. Go puma nimu epe-rupa pimi palo adola bana lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Go lisa pare Barnabas-mere Jon Mak raapu maa palipa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Go lisa pare Mak-me Pol Barnabas laapo abala giyoma Pamfilia su-para kogono napula pisa. Go pisa-pulu Pol-me dia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Go rabu ape loma agaleme ape puma rugulala pasipi. Go puma Barnabas-me Mak muma wala Saiprus su-para sip madaa piruma pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Go rabu Pol-re Sailas raapu pisipi. Go rabu Keriso-na enaalinumi Gote-me nipu raba minalo lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Go puma Pol-me Siria Silisia su laapo pamuma kone rulae enaalinuna lo robaa-para puri mapalaasa. ");
INSERT INTO kjs_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol nipu Derbe su-para adola puma lisana wala Listra su-para pamisa. Go su-parare nipumi disaipel ali Timoti adisa. Go Timoti-na kone rulae agiri Juda ena yapare nipuna aaraare Grik su-para pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Go Listra Aikoniam su lapona piri Keriso-na enaalinumi Timoti-ri epe agale lea lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Go puma Pol-re Timoti nipu raapu palipa kone suma Pol-me Timoti-na yogale kuni rugulasa. Go konere nipu laapo pora pamualipide su-parare mo Juda alinumi Timoti-na aaraare Grik ali remaa pagalimi lo yogale rugulasa. ");
INSERT INTO kjs_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Go adarenu-para pamisipi rabu abalade so Jerusalem su-para piri aposel kogono alinu lotu ada surube alinu nimumi abala lisimide remaa lakalisipi. Nipumi kone rulae enaalinu-para go rekena agalena pora raitalepape lo lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Go lisipi raburi Gote-na ruru enaalinumi Gote-na agale lo robaa-para waru mapira-ma pirisimi. Go rabu nimu raapu enaali adaapu ralaama pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Gore nimu Frigia Galesia su lapo-para pamuma Gote-na epe agale mogealisimi. Go-para sone Esia su-para epe agale lakela pisipi rabu Holi Spirit-mi go su-para napulupape loma dia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Go puma nipu Misia su robo ru-nane pisipi rabu nipuna konere Bitinia su-para polalo pisipi. Go pisa pare Yesuna Holi Spirit-mi wala rekena wisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Go pisa rabu nipu Misia su giyoma Troas adare-para pua pirisipi. ");
INSERT INTO kjs_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Go su-parare ribaa Pol-me Masedonia su-para piri ali upaame adisa. Go alimi rekoma Pol-para puri paloma gu-rupa lisa: Naana Masedonia su-para ipuma neme naa raba mea lisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gore Pol-me go upaa pinaloma naa wagepu Masedonia su polalo pisima. Niri Luk page pisua. Naana konere Gote-me naa mo Masedonia su-para piri enaalinu epe agale lakela pomonalo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Go pea-le naa ipa sip madaa piruma mo Troas su giyoma puma Samotres su redepo le pora madaa puma opapasima. Gore ekera-nane Neapolis su-para pisima. ");
INSERT INTO kjs_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Go ipa repale-para wisa su giyomare go suna ru-nane pumare Filipai su-para puma opapasima. Go Filipai suri Masedonia suna ru-para aasa. Go Filipai su-parare abalade Rom su enaali epa pirisimi. Gore naa yapi medaloma go su-para pirisima. ");
INSERT INTO kjs_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Go puma naame Juda alinuna beten lape su meda apo popea ipa repale-para aaya kone wisima. Go pisa-pulu Pomo mu Pirape Yapi Di-ri go su adarena popea ipa repale-para puma pirisima. Go rabu naame kiritasimide enaalinu epe agale lakalisima. ");
INSERT INTO kjs_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Go kiritasimi ena medana biri Lidia nipu pirisa. Go enare Taiataira su-para piruma nipumi dolo le mamina-nu suma bisnis kogono pisa. Go enare abala nipumi Gote madaa kone rulasa. Go puma Pol-me agale lisa rabu agale pagenalo Mudu Alimi nipuna kone malobaasa. ");
INSERT INTO kjs_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Go rabu nipu-para nipuna ada-para piri enaalinu page kalu-ipa misimi. Go puma nipumi naa-para talo: Nimi ali kone wimi pae? Neme Gote madaa kone rulaayo kone salimiri nina ada-para epa piralepa. Nipumi go agale puri pale lisa-pulu nipuna agale pagisima. ");
INSERT INTO kjs_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Koro meda naa beten lape su-para pisima rabu kogono nogo pora-nane madaasima. Go nogore nipuna koauna koe remo pirisa-pulu go nogome werepe epaliade kone agaleme pa lakalisa. Go werepe epaliade agale lakalisa rabu nipuna kogonona aaraanumi kana yoto adaapu misimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Go nogome Pol naa raapu raita mea ipuma gu-rupa yalisa: Go alinuri so yaa madaa Gote-na kogono pi alinu yaalisa. Nimumi ade abuna kagaa pirape pora ma waateme. ");
INSERT INTO kjs_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Go nogome ade abuna nimu yalisa-daa naa gu-rupa raita mea ipuma yaalisa rabu Pol-na koneme adisa-pulu perekeyoma nogona remo-para go-rupa lakalisa: Neme Yesu Keriso-na bi madaa talo: Go nogona koauna abi rakepe pu lisa. Go lisa rabu remome go nogo giyoma wagepu rakepema pogola pisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Gore nogona aaraanumi nimuna kana yoto mi yaade kone suma Pol Sailas laapo kopeme adibasimi. Nimumi adibasimi rabu maket kamaa ae ali mudunu piri-para maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Go-parare Rom su gavman-na ali mudunu piri maa puma talo: Go alinuri Juda yaade. Nimuri naana adare su mabebolaaeme. ");
INSERT INTO kjs_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nipumi naa Rom su-para piri alinu-para pora rado mogetape pare go agale madaa rekena yalaaya-pulu mada namogealima. ");
INSERT INTO kjs_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Go lisimi rabu enaali adaapumi page Pol Sailas laapo-para koe agale lisimi. Go puma ali kalunumi Pol Sailas laapona mamina koya paoma repena kudu tamina lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gore patame kudu tyabebe puma karapo ada-para mea mapaitaasimi. Go rabu karapusa ada surube ali-para waru surubape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Go karapo ada surube ali go agale mana pagomare mo aliri kedaa pi repename age rikirana ma rogaasa. ");
INSERT INTO kjs_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Go pisa pare ribaa rumu rumunare Pol Sailas laapome Gote-para beten loma yasa lo pirisipi. Go raburi nimuna mo karapo yagonumi pago pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Go pisa pare ora puri pale sumininimi karapo adana adaa repena raayo mayogapape pisa. Go puma pora gaape wagepu lobapama mo alinu adili kope sen page kepepisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Gore mo karapo ada surube ali rekoma mo karapo ada pora gaape raayo lobapa wisare adisa. Nipumi karapo alinu kamaa pogola puamena kone suma rai napi muma nipuna nipu lu makomalalo kepetalo pisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Go pisa pare Pol-me yaaloma gu-rupa lakalisa: Nena ne natyape. Naa raayo pa pima. ");
INSERT INTO kjs_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Go rabu mo surube alimi lam mea ipulupa lisa. Nipumi mumare Pol Sailas piri-para wagepu pumare paalame komoma nipuna kibu re-para lopisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Go puma nipumi nimu kamaa-nane maa puma talo: Adaa ali laapo-yo, Gote-me ni raba minalo neme ake palua ya? ");
INSERT INTO kjs_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nipumi go-rupa lisipi: Neme Mudu Ali Yesu madaa kone rulape. Go paliri Gote-me ne raba muma ne-para nena nogo naakinu page ade abuna piralimi lisipi. ");
INSERT INTO kjs_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Go rabu nipu laapome Gote-na epe agale mo ali-para nipuna ada-para piri enaalinu-para page mogeasipi. ");
INSERT INTO kjs_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Go rabu ora go ribaa kama mo ali laapo muma nipuna rere radepeasa. Go pumare nimu-repaa kalu-ipa misimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Go puma karapo ada surube alimi Pol Sailas laapo nipuna ada-para maa puma eda kalisa. Go rabu go ali-para nimu-repaapara Gote-na agale lo robaa-para ma misimi-pulu raaname komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Gore yapi lapaasa rabu Rom ali kalunumi plisman-na ali kalunu-para agale gu-rupa rapaasimi: Apo ali laapo mea rapaape lo lakalisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Go agale pagisa rabu karapo ada surube alimi Pol-para talo: Bosboi alinumi ne Sailas laapo abi pulupape lo lagiame-pulu pawa pulupa lisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Go lisa pare Pol-me polisman-na ali kalunu-para talo: Nimimi koeyae meda papa-daa adaame pae? Nimimi enaalinuna le agaana pote yaarimide saa tyamede. Go pumare saa karapo ada-para mapaitaarimide. Abiri go kone madaa wala pagaa wi kone suma saa rapaalimi ya? Dia, saana adare Rom su yaa-pulu mo surube ali nimuna go-para ipuma saa rapaalimina lisa. ");
INSERT INTO kjs_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Gore plisman-numi Pol-na agale Rom su gavman alinu lakalisimi. Gore gavman alinumi Pol Sailas nipuna adare Rom su pagisimi rabu paalame komisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nimu paalame komoma pua talo: Naa kodome komelema. Go rabu nimu kamaa lamua ipuma talo: Abi go adare giyalepape lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Go rabu Pol Sailas laapo karapo ada giyoma mo Litiana ada adola pisipi. Go puma nipumi Keriso-na enaalinu adoma epe agaleme nimuna lo robaa puri mapalaatalo agale lakeloma pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol Sailas laapo Amfipolis su-para pamuma pumare wala Apolonia su-para puma giyomare Tesalonaika su-para pisipi. Go su-parare Juda enaalinuna lotu ada meda aasa. ");
INSERT INTO kjs_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Gore Pol-me nipuna pi-rupa mo lotu ada-para pisa. Go puma Pomo mu Pirape Yapi repome nipumi Juda alinu raapu Gote-na buk madaa wi agale lala pisimi. Go rabu Pol-me Juda alinu raapu agaleme ape pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Go puma agale lakalisa rabu Gote-na buk madaa yarepeamina lakalisa. Pol-me gu-rupa lisa: Go Yesu nipu ora Gote-na Mea Rapaae Ali Keriso yaade. Nipumi enaalinuna kedaa ruma tapa-para nipu wala rekesi-daa go agale lagialo lisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Go puma enaalinu medaloma kone rulaoma Pol Sailas raapu pisimi. Go puma kone rulae Grik enaali adaapu page ena mudu medaloma page Pol-para Sailas laapo raita maa pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Go pisa pare Juda alinumi koe kudipa kone suma pa piri riabo alinu medaloma yaaloma enaali adaapu makiraatasimi. Go puma adare-para piri enaali raayome mapogolasaaoma Jeson-na ada kutapu ma-aasimi. Gore nimumi Pol Sailas laapo asa puma mo kiritape enaalinu lamu katalo pisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Gore asa puma napirisipi rabu Jeson-para kone rulae amenu medaloma adiala gavman-na surube ali piri-para maa pisimi. Nimumi go-rupa pumare puri paloma gupa yaalisimi: Go alinuri mo su raayona koae-aunu adaapu pamu peme rabu enaalinu koe-rupa mapogolasaala pipi. Abiri naana adare-para page epa pipi lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Go Jeson-me nimu eda kalo wamo pu aaya. Nimumi nabawan gavman ali muduna rekena agale ralimi. Nimuna ali mudu rado meda pia nipuna biri Yesu leme. ");
INSERT INTO kjs_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Go agale lomare enaali raayome page gavman ali mudunu page go agale pagomare nimu ora pogolasaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Go rabu surube alinumi Jeson-para go ali lapo-para kose kabalepa lisimi. Go puma nimumi ma rapaasimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Gore ribaa lisade raburi amenumi Pol Sailas laapo wagepu mo Beria su-para penaalisimi. Nipu go su-para opapaomare Juda alinuna lotu ada-para pisipi. ");
INSERT INTO kjs_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mo Beria su-para piri Juda enaalinumi nimuna lo robaa-para epe kone suma mo Tesalonaika su-para piri enaalinu-rupa napisimi. Go Beria su-para piri Juda enaalinumi epe agale pagisimi rabu raana waru komoma pago pirisimi. Go puma ade abuna Gote-na buk-para enaalinumi waru yarepea lakelalo pirisimi. Gore mo ali laapona agale ora yaana palo dia palo adolalo kone suma buk yarepelisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Go pisimi-pulu enaali adaapumi epe agale madaa kone rulasimi. Go puma Grik mudu enanu page Grik alinu page epe agale madaa kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Go pisa pare Tesalonaika su-para piri Juda alinumi Pol epe agale Beria su-para mogeaala epelea lo pagisimi. Pagisimi rabu nimu Beria su-para piri enaali makoyaalalo ipisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Go raburi Keriso-na amenumi Pol wagepu no nabisi su-para maa penaalisimi. Go pisa pare Sailas Timoti laapo mo Beria su-para pa pirisipi. ");
INSERT INTO kjs_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Go rabu Pol lamua pisimide alinu Pol raapu puma Atens su-para puma opapasimi. Go puma mo alinu Beria su-para wala puma Pol-me Sailas Timoti laapo ni piri wagepu ipulupape lo agale rapaasa. ");
INSERT INTO kjs_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol-me Sailas Timoti laapo Atens su-para pa adoba pirisa. Go raburi Pol-me go adare-para piri enaalinuna ribu robake koe remona kapa adisa-pulu nipuna lo robaa kolisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Go pumare nipumi Juda alinuna lotu ada-para piri enaalinu-para ruru rado Gote-na bi minasaaeme enaalinu raapu yada loro pirisimi. Go puma nipumi maket su-para piruma pora pamuala-ae enaalinu page agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gore Pol-me Yesu-para nipuna wala marekaape yapi di madaa agale lakalisa. Go lakalisa-pulu mo Epikurius alinu-para Stoik agale maalape alinu page Pol-para ero agale gu-rupa lisimi: Go aliri nipu agale loboma agale le ali yaa-pulu ake talo pia? Medalomame gu-rupa lisimi: Go alina agalere pa su rado-para piri enaalinuna yaa-para piri yakilinu madaa ta pae lisimi. Gore Pol-me Yesu tapa-para rekesa-para pa yakinu-para agale lo aaya-daa kone gu-rupa lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Go pisa-pulu nimumi Pol kaunsil piri maa puma rudu Areopagus madaa kiritasimi. Nimumi maa puma gu-rupa lisimi: Neme abala pamu laede kagaa agale pagamona wia lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nena agale medalomare ora rado pi agale yaa-pulu go agalena re-re ora waru pagamono lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Go Atens su-para piri enaalinumi page go su adolalo pora kimisu enaalinumi page ade abuna piruma kagaa agale madaa yada robesimi-pulu Pol-para mo remaa lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Go rabu Pol nipu mo rudu Areopagus madaa piruma kaunsil alinuna rikirana rekoma gu-rupa lakalisa: Atens alinu, nimiri neme adawade rabu nimimi lotu lape-rupa kone waru raitalepape. ");
INSERT INTO kjs_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ni go nimina adare pora-nane pamuma nimina bi minasaame elenu waru ade. Go puma neme kana reke meda ade. Go reke madaa agale gu-rupa lu wisa: Go kana sekere pa na-ade yaa-para piri Gote-na yaade. Abiri neme go na-ademe Gote madaa agale lagiano pagalepape lisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Gore Gote-me su kamaa wi elenu-para su raapu warisa. Go Gote-re su yaa laapona Mudu Ali yaa-pulu enaalinumi warili adanu-para napia. ");
INSERT INTO kjs_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Go puma go yakili gote-me alinu warili ele madaa kone nawia. Gore nipumi enaalinu raayo kone wasupa go pomo page ele raayo gu-rupa go aaya. ");
INSERT INTO kjs_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Gote-me naana kasua komea wari raayo go kasuame madisa. Nipumi enaali su raayo-para mapiraoma nimuna pirape su robo kalo nimuna komape di kalo pisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Go enaalinumi Gote asa puma nipu adaliminalo go-rupa pisa. Go pisa pare Gote naa raapu re-para pia. ");
INSERT INTO kjs_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gore nimina pepa tyape alimi gu-rupa lisa: Naa Gote raapu pima. Nipuna purina piruaema. Go nimina kone makuaae alinumi page pepa madaa gu-rupa lisimi: Naa page ora nipuna si yaade lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Naa Gote-na si pima-pulu nipuna kone wasupare epe gol kaname page epe kana silva-para pa kaname warili ele-para go kone nasamina. ");
INSERT INTO kjs_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Abaladere enaali nimu kone waru nasu ribaa-para pirisimi rabu Gote-me waru na-waru adabasa. Go pisa pare abiri nipumi su raayona piri enaalinumi koe kone perekeaminalo agale mana lagu aaya. ");
INSERT INTO kjs_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Go madaare nipumi su raayona enaalinuna kose lape agale pagolalo di meda abala mada misa. Go epaliade yapi di rabu nipuna mapiraae alimi redepo le kone suma yoto rumaalia. Nipumi go ali marekaasa-le apo epaliade yapi di madaa agale pagoma kone rulao piramina. ");
INSERT INTO kjs_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Gore Pol-me go enaali piri-para wala marekaasade remaa lakalisa rabu enaali medalomame ero agale-daa loma giri laasimi. Pare medalomame gu-rupa lakalisimi: Gore nena go remaa wala pagamono lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Go raburi Pol-me nimu kiritae-para giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Go puma enaali medalomame Pol raapu piruma epe agale pago kone rulasimi. Nimuna rikiranare rudu Areopagus madaa kaunsil piri ali Dionisius-mi kone rulasa. Go ena Damaris-para medalomanu nimumi page kone rulasimi. ");
INSERT INTO kjs_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Go pisa raburi werepe Pol-me Atens su giyoma Korin su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Go su-parare nipumi Juda medana biri Akwila adisa. Nipuna agi madina suri Pontus yapare oge-daa abalade Itali su giyoma nipuna were Prisila raapu Rom su-para ipisa. Gore gavman ali mudu Klodius-mi Juda enaalinu raayo Rom su giyalepape lo lakalisa-pulu Akwila Prisila laapo Korin su giyoma ipisipi. Go rabu Pol-me nipu adola pisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol nimuna kogono pisimi-pulu nimu raapu piruma mamina rabulape kogono pu ma-dia yaoma kana yoto misimi. ");
INSERT INTO kjs_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Go puma ade abuna Pomo mu Pirape Yapi rabu Pol nipu Juda enaalinuna lotu ada-para piruma nimu raapu agale lala pirisimi. Nipumi mo Juda enaalinu-para Grik enaali nu-para nimumi Gote-na bi minasaa minalo agale lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Go Sailas Timoti laapo Masedonia su giyoma ipisipi rabu Pol-me enaalinu-para epe agale ade abuna lakelalo pirisa. Nipumi Juda enaalinu-para Yesuri ora Gote-na Mea Rapaae Ali yaade lo lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Go pisa pare Juda alinumi mo agale yokoma nipu-para ero agale lisimi. Go raburi Pol-me nipuna mamina-na koto radepea talo: Nimina koto adalepa. Gore abi neme nimi giyoma ruru radonu lakela palua pare abala lagiaade lo nimi kone masaalua lisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Go loma Pol-me giyoma ali Titius Jastus-na ada-para pua pirisa. Go aliri ruru rado piri ali yapare Gote-na bi minasaaae ali yaade. Nipuna adare Juda alinuna lotu ada resi-para aasa. ");
INSERT INTO kjs_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Go rabu go Juda alinuna lotu adana ali mudu Krispus-para nipuri paa nimumi Mudu Ali Yesu madaa kone rulasimi. Go puma Korin su-para piri enaali adaapumi epe agale pagoma kone rulaoma kalu-ipa misimi. ");
INSERT INTO kjs_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Go puma koro meda ribaare Pol-me upaa palaina Mudu Alimi nipu-para talo: Neme paala nakomape pare agale waru lakelape. ");
INSERT INTO kjs_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Niri ne raapu komea-para pipa. Go pea-pulu pa ali medame ne mada natia. Dia-le go adare-parare nina enaali adaapu pimi. ");
INSERT INTO kjs_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Go pisa-pulu Pol nipu Korin su-para pirinare maali komea paluma suba waraapu popesa. Go raburi nipumi nimu Gote-na epe agale moge riasa. ");
INSERT INTO kjs_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gore werepe Galio nipu Akaia suna namba wan gavman surubalalo pisa. Go rabu Juda alinu kiritaoma Pol aditalo kose lalala maa polalo gu-rupa lisimi: ");
INSERT INTO kjs_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Go alimiri enaalinuna kone mabebolaoma Gote-na bi minasaasa agale lo mogeaaya. Go rabu naana rekena agale yokesimi. ");
INSERT INTO kjs_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Gore Pol-me agale laketalo pisa pare Galio-me Juda enaalinu-para talo: Go ali pupitagi noma koe ele piare neme pawa piruma pagolalo pi. ");
INSERT INTO kjs_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pare nimina yadanuna binu rekena agalenu leme-le nimina kose tapape. Neme kose go-rupa napagalua. ");
INSERT INTO kjs_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Go lisa rabu nipumi nimu kamaa mea ralisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Go pisa rabu enaali medalomame lotu adana ali mudu Sostenes maa ripinuma kose pagape ada re-para maa pua lisimi. Go lisimi pare Galio-me linawa kone wisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Go puma Pol Keriso-na enaalinu raapu yapi medaloma go Korin su-para pirisa. Go puma walare nipumi Prisila Akwila laapo muma go su giyoma ipa sip madaa piruma Siria su-para pisimi. Gore Pol mo Senkria su-para pirisa rabu Gote-para agale lisa-pulu kalu iri napodelisa. Werepe nipuna kogono dia lisa rabu kalu iri wala podelisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Gore nimu Efesus su-para opapasimi raburi Pol Juda alinuna lotu ada-para puma nimu raapu agaleme ape pisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Go puma Juda alinumi Pol-para naa raapu yapi medaloma piramina lisimi pare Pol-me mada dia lisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Go puma nimu-para abi paitalepape lakeloma talo: Gote-me e tea-daare wala epalua. Go puma nipumi ipa sip madaa piruma Efesus su giyoma pisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pol sip madaa piruma Sisaria su-para puma lisana wala Jerusalem su-para piri kone rulae enaalinu epe-rupa piralepa lo lakalisa. Go loma ogeasi piruma Antiok su-para pisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiok su-para ogeasi pirumare giyoma Galesia Frigia su laapona oge adarenu-para puma kone rulae enaalinuna lo robaa-para puri mapalaaoma pamisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Go Juda ali meda nipuna bi Apolos-re nipu madi su Aleksandria-para pirisa. Go ali Efesus su-para epa pirisa. Nipu agale waru le ali piruma Gote-na buk wi agale raayo yarepeama makuaasa. ");
INSERT INTO kjs_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Enaalinumi nipu abalade Mudu Ali-na pora madaa mogealisimi. Nipumi Yesuna agale lakalisa rabu puri paboma ora waru epe-rupa lakalisa. Go pisa pare nipuri Jon-na kalu-ipa misa komea abala makuaasa. ");
INSERT INTO kjs_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Gore nipumi Juda alinuna lotu ada-para puma puri paloma lakalisa. Go rabu Prisila Akwila laapome nipuna agale pagomare nipuna ada maa puma Gote-na disaipel agale ma-redepo lakalisipi. ");
INSERT INTO kjs_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Go puma werepere Apolos nipu Grik su Akaia-para polalo pisa. Go rabu Efesus su-para piri Keriso-na enaalinumi Grik su-para piri Kristen enaali-para pepa luma rapaasimi. Go pepa madaare go ali Apolos raba mu ki waru mealepa lo rapaasimi. Apolos Grik su-para ipisa rabu Gote-na epe raba meape kone makuaaoma kone rulae enaalinu-para puri waru kalisa. ");
INSERT INTO kjs_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Go Juda alinu maket-para ipisimi rabu Apolos-me enaalinuna le agaana ape waru pisa. Go pisa rabu nipumi Yesu ora Gote-na Mea Rapaae Ali waalalo Gote-na buk yarepelisa. Go rabu Juda alinumi agale waru na-abulisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Korin su-para pirisa rabu Pol nipu mo adaa su robo ru-nane puma pamumare Efesus su-para opapasa. Go su-parare nipumi kone rulae enaali medaloma adisa. ");
INSERT INTO kjs_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Adisa rabu agale gu-rupa misa: Abaladere epe agale madaa kone rulasimi rabu Holi Spirit page misimi ya? Nimumi agale gu-rupa abulisimi: Dia, Holi Spirit piare naa napagema. ");
INSERT INTO kjs_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Go rabu Pol-me talo: Gore nimina baptais-ri ake pi-ae misimi ya? Nimumi talo: Jon-na kalu-ipa misima lisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Gore Pol-me talo: Jon-na baptais-ri enaalinumi pupitagi ne kone perekelalo misimi. Go pea pare Jon-me Israel enaalinu kalu-ipa kalalaina agale gu-rupa lakalisa: Naa koau-nane epaliade ali Yesu madaa kone rulaalepape lakalisa. ");
INSERT INTO kjs_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mo Efesus piri alinumi Pol-na agale pagomare nimumi Mudu Ali Yesuna bi madaa kalu-ipa measimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Go puma Pol-me nimuna kalu madaa ki sanaloma Holi Spirit nimuna lo robaa-para ipisa. Go rabu nimumi adaa agale rado rado loma lisimina Gote-na agale le ali-rupa pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Go-rupa lisimide alinuri 12 pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Gore Pol nipumi Juda alinuna lotu ada-para Gote-na epe agale mogeala pirinare suba repo popesa. Nipumi Juda raapu agale puri palo piruma Gote-na Surube Su madaa lakalalo pirisa. ");
INSERT INTO kjs_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Go pisa pare enaali medaloma nimuna pu-para rero pisa-daa kone narulalisimi. Go rabu nimumi enaali raayona le agaana Mudu Ali-na agale madaa koe ero agale lisimi. Go lisimi-pulu Pol-me aposel kogono alinu muma nimu giyoma pirisimi. Go puma ade abuna nipu Keriso-na enaali raapu piruma Tiranus-na skul ada-para agale lo pirisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gore nipumi maali laapome epe agale lakelala pirina Esia su-para piri enaali raayome Mudu Ali-na epe agale pagisimi. Go puma Juda enaalinu page ruru rado piri Grik enaalinu page epe agale pagisimi. ");
INSERT INTO kjs_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Go rabu Gote-me Pol napi kogono pinalo raba misa. ");
INSERT INTO kjs_vpl VALUES ("AC19_12","074_19_12","ACT","1