﻿USE sofia;
DROP TABLE IF EXISTS sofia.kjl_vpl;
CREATE TABLE kjl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kjl_vpl WRITE;
INSERT INTO kjl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","येसु ख्रीस अब्राहाम स़ोनो दाऊदनी निथोनी ज़ हुके। नोराए यामिनर आवर ज़, ");
INSERT INTO kjl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहामए ओज़ा इसहाक, इसहाकए ओज़ा याकूब, याकूबए ओज़ा यहूदा, यहूदाए छुत ओदाज्‍यु भाइर मनी याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदाए ओज्‍या तामार बातनी दुई भाइ ताकिनी। तोबोए उमिन फारेस, तोबोए उमिन जाहेर। फारेसए ओज़ा हेस्रोन, हेस्रोनए ओज़ा आराम, ");
INSERT INTO kjl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","आरामए ओज़ा अम्‍मीनादाब, अम्‍मीनादाबए ओज़ा नहसोन, नहसोनए ओज़ा सल्‍मोन, ");
INSERT INTO kjl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सल्‍मोनए फरी ओज्‍या राहाबनी बोअजलाई दैक्‍यो। बोअजए मनी ओज्‍या रूथनी ओबेदलाई दैक्‍यो। ओबेदए ओज़ा यिसै, ");
INSERT INTO kjl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिसैए ओज़ा दाऊद राजा। दाऊदए उरियाए ओज्‍या बातनी सोलोमनलाई दैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सोलोमनए ओज़ा रहबाम, रहबामए ओज़ा अबिया, अबियाए ओज़ा आसा, ");
INSERT INTO kjl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसाए ओज़ा यहोसापात, यहोसापातए ओज़ा यहोराम, यहोरामए ओज़ा उज्‍जिया, ");
INSERT INTO kjl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्‍जियाए ओज़ा योताम, योतामए ओज़ा आहाज, आहाजए ओज़ा हिजकिया, ");
INSERT INTO kjl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकियाए ओज़ा मनस्‍से, मनस्‍सेए ओज़ा अमोन, अमोनए ओज़ा योसिया, ");
INSERT INTO kjl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","योसियाए ओज़ा यकोनियास। यकोनियासए छुत ओभाइर मनी याल्‍यो। नो बेलाक ज़ इस्राएलीरालाई बेबिलोनदा क्‍योःद यारालाँकेर। ");
INSERT INTO kjl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबिलोनल ज़ यकोनियासए ओज़ा सालतिएल जर्मिके। नकिन सालतिएलए ओज़ा यरूबाबेल, ");
INSERT INTO kjl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","यरूबाबेलए ओज़ा अबिउद, अबिउदए ओज़ा एल्‍याकीम, एल्‍याकीमए ओज़ा आजोर, ");
INSERT INTO kjl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","आजोरए ओज़ा सादोक, सादोकए ओज़ा आखिम, आखिमए ओज़ा एलिउद, ");
INSERT INTO kjl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलिउदए ओज़ा एलाजार, एलाजारए ओज़ा मत्तान, मत्तानए ओज़ा याकूब, ");
INSERT INTO kjl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूबए ओज़ा योसेफ, योसेफए ओज्‍या मरियमनी ज़ येसु जर्मिके। नोलाई ज़ ख्रीस है दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","है जैद अब्राहामकिन दाऊद राजा पै चौध प़िरी ताके। दाऊद राजाकिन बेबिलोनदा क्‍योःद यारालाँवक पै ब चौध प़िरी ज़ ताके। नकिन ख्रीस ओजर्मिउक पै ब चौध प़िरी ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","येसु ख्रीस उजर्मिउ इतावनी ज़ — येसुए ओआमा मरियमलाई भर्ज़ा योसेफत ऩिद यानैज़्‍याव। नोनी बिह्‍या निमादोद ज़ मरियम परमेस्‍वरए छैंव उपुरूसनी ज़ा दैन्‍या ताद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","नो मरियमलाई ऩिज़्‍याव योसेफ धर्मी मिँ ओतावए मरियम ज़ा दैन्‍या ताद उलिज़्‍याव सैंद ओपाहा झाःद मायाद अलगज़ा ऱासो ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","निताव जैव ओपैंज़्‍याक ज़ तछा उमँल परमेस्‍वरए ओचाकर्‍या हुद, “नँ दाऊदए ओथोलाव योसेफ, मरियमलाई रैन्‍या ताछे·नी। नो उफूलाव ज़ा ते परमेस्‍वरए छैंव उपुरूसनिकाव ची। ");
INSERT INTO kjl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","नो ओज़ा खेपा तारिज़्‍या। नोए उमिन ‘येसु’ नैदियो, काराव ल्‍यो ताकिन नोए उमींरालाई यादोव पापनी याऱास्‍रिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","आव भरी परमेस्‍वरए अगमबक्तालाई सरो उपरींव मिताव ज़ यो·के। नोए अइ लिद सर्द ओनैज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“तोबो कन्‍या ल़ुज़ा गर्बवती ताद खेपा ज़ा तोबो दैरिज़्‍याव। होए उमिन इम्‍मानुएल नैद्यान्‍या लेर।” होए ओअर्थ — परमेस्‍वर गेस ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","है जैद योसेफ सैंसिद परमेस्‍वरए ओचाकर्‍याए है ओदोव मिताव ओज्‍या मरियमलाई रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","खाली मरियमए ज़ा ओमादैवा पै निक्‍याँ मासदैकिनी। ओदैवत फरी नो भाउज़ाए उमिन येसु नैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","राजा हेरोदए ओपालाक येसु यहूदिया खन्‍दलाव बेथलेहेम नाखारल ज़ जर्मिके। उजर्मिउ छींनी जैंसीर पुर्ब त॰नी यरूसलेमल हुद, ");
INSERT INTO kjl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“जर्मिउ यहूदीराए याराजा काङ्क उलिज़्‍याव? नोलाई सरेस्‍न्‍या सोरो पुर्बल गेरँःके। है जैद नोलाई धो गेदोया लिद हुद गेले,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","नो पाँ राजा हेरोदए थैद उयुँर आँचा पाँचा ताके। हिताव ज़ यरूसलेमलाव लिज़्‍याव भरी ब राजाए उयुँ स्‍यासो ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","है जैद राजा हेरोदए ओदेसलाव लिज़्‍याव घेप्‍पा घेप्‍पा पुजारीर स़ोनो सास्‍त्री भरी ब दुप्‍द, “नो धर्मसास्‍त्रलाव सर्सिउ ख्रीस जर्मिन्‍या पो काङ्क उलिज़्‍याव?” है लिद यासुधिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","नोराए, “यहूदियालाव बेथलेहेमल ज़ ताव परिन्‍या। अगमबक्ताए ब अइ लिद सर्द नैव, ");
INSERT INTO kjl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘अ यहूदिया खन्‍दलाव बेथलेहेम, नँ यहूदिया भरिलाव घेप्‍पारानी नँ नमिन ज़िम्‍ज़ा माले। नँनी ज़ तोबो याङ़ैताव हुद ङामीं इस्राएलीराए यार्गे गावला तान्‍या ले।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","राजा हेरोदए आव भरी थैद जैंसीरालाई अलगज़ा खुल्‍द, “नो सोरो खाक जेरँःव?” है दाद थ·रैद, ");
INSERT INTO kjl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","नोरालाई, “बाचिकेदा, नो जर्मिउ भाउज़ालाई बनै चावस खिम्च्‍यो। जेदैवत ङालाई मनी है दाव ताके। ङा ब बाद नोलाई धो ङादोरिज़्‍या,” है दाद बेथलेहेमदा यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","नोर राजाए ओपाँ भैंःद याबाज़्‍याक फरी नो पुर्बलाव यारँःव सोरो याङ़ा याङ़ा बाद नो भाउज़ा जर्मिद उलिज़्‍याव पोक ज़ अदिके। ");
INSERT INTO kjl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","नो सोरोलाई रँःद बनै रेंए रेंए, ");
INSERT INTO kjl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","नो झ़िमल ज़ पसिकेर। नल नो भाउज़ालाई ओआमा मरियमस उलिज़्‍याव दैद ओङ़ाक फुलुप्‍सिद धो दाद यासुन्‍दुसर फैद सुनर धुपर बनै चाव चाव यासी ङरोर ब चरैःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","हाः बेलाक ज़ तछा यामँल परमेस्‍वरए, “जे हेरोदए ल्‍योदा फरी ओल्‍द ताबाच्‍यो,” है ओरादोज़्‍याव रँःकेर। है जैद नोर हेरोदए ओल्‍योलाव घ्याँ माबाद तँनिकाव घ्याँ यादेसदा ओल्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","नो जैंसीर याबाव छींनी तछा योसेफए उमँल मनी परमेस्‍वरए ओचाकर्‍या हुद, “नँ सोद हतप्‍त ज़ भाउज़ा स़ोनो ओआमालाई लाँद इजिपदा धोंःचिके। फरी ‘हुचिके’ है ङामादाचिवा पै होङ ज़ लिच्‍यो। हेरोद राजाए नो भाउज़ालाई खिम्‍द सैःव पैंज़्‍याव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","हाःत ज़ योसेफ सैंसिद रील ज़ नो भाउज़ालाई ओआमास इजिपदा निलाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","हेरोद ओमासिवा पै होङ ज़ लिकेर। है जैद नत ज़ परमेस्‍वरए अगमबक्तालाई सरो उपरींव पाँ यो·के। नोए ओसरो आव ज़, “ङाज़ा इजिपनी खुल्‍द रैद ङानै।” ");
INSERT INTO kjl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","नो जैंसीर याबाव छींनी, ‘जैंसीराए ते याछकैनाव ची ओल्‍यो’ लिन्‍या सैंद हेरोद बनै रसिद बेथलेहेम स़ोनो नजीलाव खेपा ताद लिज़्‍याव भाउज़ार ऩेरिमकिन मेदाङाव भरी ओपो·स ज़ सैःव यापरींक्‍यो। नो ओरासैःव, जैंसीराए ङ़ादा सोरो यारँःव गोइँनी ज़। ");
INSERT INTO kjl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","नत ज़ यर्मिया अगमबक्ताए ओसरो पाँ यो·के। नोए ओसरो आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाल चिर्लनी बिर्ल थास्‍ज़्‍या। राहेल ओज़ाराए जूँनी घरो ज़ लिज़्‍या। प़ाइँ यासिधुवए सभैंःद ब मासभैंःधुर।” ");
INSERT INTO kjl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोद राजा उसिउ छींनी योसेफ इजिपल उलिज़्‍याक ज़ तछा उमँल परमेस्‍वरए ओचाकर्‍या फरी हुद, ");
INSERT INTO kjl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“नँ सोद भाउज़ालाई ओआमास लाँद इस्राएलीराए जेपोदा ओल्‍द बाचिके। भाउज़ालाई सैःव पैंज़्‍याव ओल ज़ सिधुके,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","योसेफ सैंसिद भाउज़ालाई ओआमास इस्राएल देसदा ज़ निलाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","होङ ओकेसोत हेरोदए ओपोल ओज़ा अर्खिलाउसए यहूदीराए यादेस ओचलैज़्‍याव सैंद योसेफ नल लिन्‍या ओछे·ज़्‍याव। है जैद तछा उमँल, ‘गालील खन्‍दल बाद तोबोक लिन्‍के’ लिद परमेस्‍वरए है ओदोव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","है जैद गालीललाव नासरत यादोज़्‍याव सहरल लिनाकेर। नो भरी ब अगमबक्ताराए यासरो मिताव ज़ यो·के। नो सर्सिउ आव ज़, “नोलाई नासरतलाव है दान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","नकिन तछा ऱील सछैंज़्‍याव यूहन्‍ना यहूदियालाव बनल अइ लिद यासथैहुक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“स्‍वर्गताव राज्‍या सो हुरिके। जेपापलाई ऱास्‍द परमेस्‍वरए ल्‍योदा जेयुँ फर्कैचिके।” ");
INSERT INTO kjl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","आव ऱील सछैंज़्‍याव यूहन्‍नाए उजूँनी यसैया अगमबक्ताए अइ लिद सर्द ओनैज़्‍याव, “तोबोए ओर्गा बनल अइ लिद उक़िज़्याव थास्‍रिज़्‍या, ‘हुरिज़्‍याव प्रभुए ओयेम बनैद गाँत्‍या गुँतीलाई सदाँचिके।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्‍ना ऊँतए ओसनए क्‍वा ओक्‍वाइसिज़्‍याव, ओवाँःत स्‍यालोए वाँःफो ओपो·सिज़्‍याव। नोए स॰ल॰र कोस्‍योर ओराकैज़्‍याव, ज़ेंराए राप उज़्‍युज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","नोए ओल्‍योक यरूसलेमलावर, यहूदिया खन्‍दलावर स़ोनो यर्दन भै जीदाङावर ओपो·स ज़ ओपाँ थैना याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","नोराए सु सु यादोव यापाप यूहन्‍नालाई है यादोक ते यूहन्‍नाए यर्दन भैल यासछैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","फरिसीर स़ोनो सदुकीर यासछैंसिहुज़्‍याव रँःद यूहन्‍नाए नोरालाई, “ए घुलए ओथोर, जे परमेस्‍वरए उरिसनी धोंःन्‍या सुए है ओदाचिउ? ");
INSERT INTO kjl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","जे साचो ज़ परमेस्‍वरए ल्‍योदा जेयुँ फर्कैन्‍या ल्‍यो ताकिन साचो हो मिताव य़ेन ब दाव ताके। ");
INSERT INTO kjl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","जे फरी, ‘गेपुर्खा अब्राहामनी ज़ परमेस्‍वरए ओज़ार ताद गेले,’ है जेमालिदी ब ताए। ङा साचो है ङादाचिज़्‍या, परमेस्‍वरए सींर लुँरानी तादी ब अब्राहामए ओथोर याजैधुव। ");
INSERT INTO kjl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","किताव तोबो मिँए चाव सै माझाःज़्‍याव सींर धलैद मेंःल ओराख्‍याज़्‍याव, हिताव ज़ परमेस्‍वरए ब धलैन्‍याए जूँनी ओरोवा सींए ओजराक झाःद नैव। ");
INSERT INTO kjl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ङा ते परमेस्‍वरए ल्‍योदा जेयुँ जेफर्कैवनी ऱील ङासछैंचिज़्‍या। खाली ङा ङाछींनी ङाकिन ओसक्ती ल्‍यो तोबो हुरिज़्‍या। ङा होए ओपोला हाइद्यान्‍या स्‍यासो ब ङामाले। होए परमेस्‍वरए छैंव उपुरूस स़ोनो मेंःनी सछैंचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","होए गेदा भरी नाङलील च्‍याप्‍द चाव भरी धन्‍सारल झाःद पुल भरिलाई खर्क ज़ माजिप्‍तिन्‍या मेंःल म़ुन्‍या ले,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","हाःत ज़ येसु ब गालीलनी हुद यर्दन भैल यूहन्‍नाए ल्‍योक सछैंसिहुके। ");
INSERT INTO kjl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","यूहन्‍नाए येसुलाई भैंःद मायाद, “ङानी माःक, बुरू ङा ची नँनी सछैंसिउ परिन्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","येसुए, “आख पै नँनी ज़ जैव ताके। परमेस्‍वरए ओपैंज़्याव मिताव प़ाइँ य़ेन गिन सयो·द्याव ज़ परिके,” है ओदोक ते, यूहन्‍ना भैंःके। ");
INSERT INTO kjl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","येसु सछैंसिद ऱीनी उपुलुसो प़ाइँना ज़ नम फैसिद परमेस्‍वरए उपुरूस कुइतम मिताव भुर्हुद ओक्‍याँत उच़ुसिज़्याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","हाःत ज़ नमतिन तोबो गा अइ लिद थास्‍के, “आव ङायुँलाव ङाज़ा ज़। आवलाई रँःद ङायुँ होलाँ ताज़्‍या,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","येसु ननी पुलुस्‍द ओबाज़्‍याक ‘येसुलाई सैतानए घजाँचिउक’ लिद परमेस्‍वरए छैंव उपुरूसए तोबो साइँसुइँव पोङ लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","नल चालीस दिन, चालीस रात भरी काता ज़ माज़्‍याद ओल्‍योए ओकरेए माधुनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","हाःत ज़ सैतानए येसुलाई झुकैन्‍याए जूँनी ओल्‍योक हुद, “नँ साचो ज़ परमेस्‍वरए ओज़ा ताकिन आव लुँरालाई भरेस याजैके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","येसुए, “धर्मसास्‍त्रल अइ लिद सर्सिउ लिज़्‍या, ‘मिँलाई ज़्‍यावए वाज़ माङाव। ङाज़्‍याव परमेस्‍वरए ओयाःनी पुलुस्‍ज़्याव पाँए ची,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","नकिन सैतानए येसुलाई यरूसलेमल लाँद ध्‍यान झ़िमए उतुपात बैद, ");
INSERT INTO kjl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“नँ साचो ज़ परमेस्‍वरए ओज़ा ताकिन आतिनी मेल ज़ो·निके। धर्मसास्‍त्रल अइ लिद सर्सिउ लिज़्‍या, ‘नँलाई बाँचैन्‍याए जूँनी परमेस्‍वरए ओचाकर्‍यार परींदींरिज़्‍याव। नोराए नँलाई छींद नखँ लुँत बजारिउ यान्‍या मालेर,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","नकिन येसुए सैतानलाई, “धर्मसास्‍त्रल आव मनी सर्सिउ लिज़्‍या, ‘नप्रभु परमेस्‍वरलाई जाँचिन्‍या माताए,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फरी सैतानए येसुलाई तोबो झेंःव गोंत लाँद संसारलाव राज्‍या भरी ज़गै मगैवस सतैंद्याद, ");
INSERT INTO kjl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“नँ ङाखँत फुलुप्‍सिद धो नदाँकिन नो नरँःव भरी नमीं ज़ जैद ङाईंरिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","नाःत ज़ येसुए, “ए सैतान, ङानी पुलुस्‍द बान्‍के। धर्मसास्‍त्रल इताव सर्सिउ लिज़्‍या, ‘नप्रभु परमेस्‍वरए ओङ़ाक फुलुप्‍सिद होए ओसेवा वाज़ दान्‍या ताए,’ ” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","सैतानए येसुलाई ऱास्‍द बाके। हाःत ज़ परमेस्‍वरए ओचाकर्‍यार हुद येसुए ओसेवा दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","हो बेलाक ज़ ‘ऱील सछैंज़्‍याव यूहन्‍नालाई क्‍योःकेर दी’ लिन्‍या येसुए थैद ननी हाइसिद गालीलदा बाके। ");
INSERT INTO kjl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","है जैद येसु उलिज़्‍याव नासरतलाई ऱास्‍द जबूलून स़ोनो नप्‍तालीनी निथोराए यापो लापकाव, गालील दह छ्योकाव कफर्नहुम सहरल लिनाके। ");
INSERT INTO kjl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","नो भरी यसैया अगमबक्ताए ओसरो मिताव ज़ यो·के। होए ओसरो आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“यर्दन भै होफताव दह छ्यो जीकाव जबूलून स़ोनो नप्‍तालीनी निपो लापकाव गालील खन्‍दलाव चुम चुमोल लिज़्‍याव छुत जातलावराए बनै घ्‍योःव ज़गै रँःद नैर। सिन्‍या सजाल परिउरालाई नम ज़राँः ज़राँः उसँनाव मिताव ताद ले।” ");
INSERT INTO kjl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","है जैद येसु गालीलल ओबावकिन ज़ परमेस्‍वरए ओपाँ अइ लिद यासथैक्‍यो, “स्‍वर्गताव राज्‍या सो हुरिके। है जैद जेपापलाई ऱास्‍द परमेस्‍वरए ल्‍योदा जेयुँ फर्कैचिके।” ");
INSERT INTO kjl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","तछा येसु गालील दह छ्यो छ्यो ओबाज़्‍याक पत्रुस है यादोज़्‍याव सिमोन स़ोनो ओभाइ अन्‍द्रियासनी दहल जाल निरैःसिज़्‍याव निरँःक्‍यो। नोनी ङाँःर क्‍योःज़्‍यावनी निल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","येसुए नोनिलाई, “ङास हुचिन्‍के, जिनलाई ङाँःर जिन्‍राखिम्‍ज़्‍याव मिताव मिँर खिम्‍न्‍या ङाजैचिन्‍रिज़्‍या,” है उनिदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","नोनी निजालर ख्‍यानैद ओलस ज़ बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","जाँ होकसै याबावत फरी जब्‍दियाए ओज़ानी ओदाज्‍यु याकूब स़ोनो ओभाइ यूहन्‍नानी निबाबु जब्‍दियास दोङ्गात च़ुसिद जालर यारातालिज़्‍याव रँःद नोनिलाई मनी “ङास हुचिन्‍के,” लिद निखुल्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","नोनी बेहार ज़ निबाबुलाई दोङ्गात ख्‍यानैद येसुस बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","येसु गालील खन्‍द भरिल यहूदीराए धर्मसास्‍त्र झ़िम झ़िमक बाद ‘स्‍वर्गताव राज्‍या हुरिके’ लिन्‍या चाव था सथैद भाँती भाँतिलाव रोगनी याजोरो हुवरालाई ब ओरासगराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","है जैद ‘येसुए निताव य़ेन दोक्‍यो दी’ लिन्‍या सिरिया खन्‍द भरी फींजिद याजोरो हुवर, याक्‍याँत माचाव पुरूस ल्‍योर, पुल्‍ज़्‍यावर स़ोनो याक्‍याँ सिउरालाई मनी येसुए ल्‍योक यारारैक सगराँद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","नो य़ेनर थैद गालील खन्‍दलावर, देकापोलिसलावर, यरूसलेमलावर, यहूदिया खन्‍दलावर स़ोनो यर्दन भै होफताव जीलावर बनै माहोल्‍या ज़ येसुए उछीं उछीं याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","येसुए नो माहोल्‍यारालाई रँःद तोबो दाँदात बाद उच़ुसिक उछींत हुज़्‍याव भरी ब ओल्‍योक ज़ हुकेर। ");
INSERT INTO kjl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","हाःत ज़ येसुए अइ लिद यासथैक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्‍या, यायुँल मासघ्‍योःसिज़्‍यावर, स्‍वर्गताव राज्‍या नितावराए जूँनी ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्‍या, आज्‍याल सोगोल लिज़्‍यावर, यायुँ होलाँ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्‍या, परमेस्‍वरए ओक्‍याँत ख्‍यासिद यातहस लिज़्‍यावर, आव मानुवाताव हक दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्‍या, परमेस्‍वरए ओपैंज़्‍याव मिताव सयो·न्‍याए जूँनी यास॰ तरा चींज़्‍यावर, यापैंज़्‍याव भरी यो·न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्‍या, छुतए ल्‍योदा यायुँ नाज़्‍यावर, याल्‍योदा मनी परमेस्‍वरए उयुँ नान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्‍या, आज्‍याल यायुँ छैंवर, परमेस्‍वरलाई रँःन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्‍या, माखैज़्‍यावरालाई सखैज़्‍यावर, यामिन परमेस्‍वरए ओज़ाल गनिसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्‍या, परमेस्‍वरए उयुँलाव मिताव य़ेनत याखिरी पसिद दुखर दैज़्‍यावर, स्‍वर्गताव राज्‍या नोराए जूँनी ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ङा ङामिनत जेलाई अऩाकलाव पाँर ससैद, जेखिरी पसिद, उल्‍ली गिल्‍ली दाद जेमिन बले·द यायाचिक धन्‍याकावर ज़ जेताज़्या। ");
INSERT INTO kjl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","जेयुँर मासतेद रेंच्‍यो, काराव ल्‍यो ताकिन स्‍वर्गताव घ्‍योःव इनाम दैन्‍या जेले। अगमबक्ता भरिरालाई मनी जेकिन ङ़ादा निताव दुखर याव ज़ यारानैज़्याव।” ");
INSERT INTO kjl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“जे आव मानुवात सापी मितावर जेलिज़्‍या। सापीए ओदार ओमालिकिन नोलाई कै जैद ची ओदार ल्‍यो जैन्‍या? है जैद नो काम मालागिउ ओतावए नोलाई ख्‍याद मिँराए छिल्‍सी ऩिन्‍या वाज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“जे आव मानुवाताव ज़गै स्‍यासो ब जेलिज़्‍या। झेंःवताव जैसिउ सहर ब माम़ोंसिए। ");
INSERT INTO kjl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","स़ोनो मिँराए ल़ोसै तैंःद जाए माकपर, दिउ बाल्‍न्‍यात ची झाःर। हुनी वाज़ झ़िमल लिज़्‍यावरालाई पलाँ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","हिताव ज़ जे मनी मिँराए याङ़ाक जेज़गै ओरैंःक। हो ताकिन ची चाव जेय़ेन रँःद स्‍वर्गताव जेबाबुए उमिन ब सघ्‍योःद्यान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“जे ङालाई ‘मोसाए ओकानुन स़ोनो अगमबक्ताराए याय़ेन सम़ैना उहुव’ है तालिच्‍यो। सम़ैना माःक, सयो·ना ङाहुव ची। ");
INSERT INTO kjl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ङा साचो है ङादाचिज़्‍या, आव नाम नम ओमाखेमा पै, धर्मसास्‍त्रलाव सर्सिउ पाँ ओमायो·वा पै, तोबो ब खेर बान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","है जैद जोए धर्मसास्‍त्रलाव पाँ तकेज़ा तादी ब ओबले·किन स़ोनो छुतलाई तँनी ओपैकिन नोए उमिन स्‍वर्गताव राज्‍याल प़ाइँरानी ज़िम्‍ज़ा तान्‍या ले। फरी नो भरी ओल माबिरैद ओदोकिन छुतलाई ब दान्‍या ओपैकिन नोए उमिन स्‍वर्गताव राज्‍याल घ्‍योःव ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","है जैद ज़ ङा साचो है ङादाचिज़्‍या, सास्‍त्रीर स़ोनो फरिसीराए यादोज़्‍याव धर्मकिन जे कोसै जेमादोकिन, स्‍वर्गताव राज्‍याल पसिउ दैन्‍या जेमाले।” ");
INSERT INTO kjl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“जे ब थैद जेनैज़्‍याखेहो, भाःकाव जेसाखा पुर्खारालाई ‘मिँ मासैःन्‍या,’ स़ोनो, ‘जोए मिँ सैःज़्‍याव, होए सजा ब दैव ज़ परिके’ है लिद सथैव ज़ यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ङा ते झन जेलाई इतावनी है ङादाचिज़्‍या, जोए ओभाइलाई रसिद वाज़ ओएकिन नोलाई ब सजा दैन्‍या ओछ्यास लिज़्‍या, स़ोनो जोए छुतलाई, ‘नँ कान्‍ल ज़ काम मालागिउ भोकोता,’ है दोज़्‍याव, नोलाई झन घ्‍योःव कचरील लाँन्‍या ओछ्यास लिज़्‍या। फरी जोए छुतलाई, ‘मुर्ख नफ्या·हुव,’ है दोज़्‍याव, नोलाई नर्गलाव मेंःए ओज़्‍यास तान्‍या ओछ्यास लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","है जैद नँ ध्‍यान झ़िमल परमेस्‍वरए उमिनत कातार चरैःना नबाक ननैंए उयुँल नउपर्त कातार उलिज़्याव नसैंकिन, ");
INSERT INTO kjl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","नो चरैःना नरैवलाई होक ज़ ख्‍यानैद ङ़ादा नो ननैंस सखैसिद वाज़ चरैःयो। ");
INSERT INTO kjl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“नजगर्‍याए अदालतदा मुद्दा झाःनाद उईंकिन होङ ओमाकेस्‍द येमक ज़ खैनानी, म़ानी नोए न्‍याधिसए उकुइत सूँपिद, न्‍याधिसए फरी पुलिसए उकुइत सूँपिद झ्यालखानाल झाःनिरिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","साचो ज़, नल नपरिकिन तपैसा तादी ब ओपो·स ज़ नमाफो·वा पै पुलुसो दैन्‍या नमाले।” ");
INSERT INTO kjl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“जे आव ब थैद जेनैज़्‍याखेहो, ‘अर्काए ओज्‍याए ल्‍योदा माबान्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ङा ते झन है ङादाचिज़्‍या, जोए तोबो मेंमालाई चाव रँःद उयुँल बले·व ओपैंकिन होए पाखात ब ओबले·धुव मिताव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","है जैद तँनिकाव नमीए माचावल ओपारैनिकिन नोलाई कोला·द ख्‍याके। नक्‍याँ भरी नर्गल ओबाज़्‍याव देखा बुरू तोबो ओमाल्‍यो पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","हिताव ज़ तँनिकाव नकुइए माचावल ओपारैनिकिन नोलाई च़म्‍द ख्‍याके। नक्‍याँ भरी नर्गल ओबाज़्‍याव देखा बुरू तोबो च़म्‍द ख्‍यान्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“फरी कानुनलाव आव मनी जेसैंज़्‍याखेहो, ‘जोए ओज्‍यालाई ऱासो ओपैंकिन होए ऱास्‍न्‍या कागत सर्द ओऱासोक।’ ");
INSERT INTO kjl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ङा ते झन है ङादाचिज़्‍या, जोए ओज्‍या ओरेए ओसतत उलिज़्‍यावत ब ओरेए ओऱास्‍किन, फरी नो मेंमाए छुत रे ओदोकिन, नो ऱास्‍ज़्‍याव ओरेए नो मेंमालाई जारी य़ेन ज़ दाव परींक्‍यो। फरी जोए नो ऱास्‍सिउ मेंमालाई रैज़्‍याव, होए मनी जारी य़ेन ज़ दोक्यो।” ");
INSERT INTO kjl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“आव ब थैद जेनैज़्याखेहो, भाःकाव जेसाखा पुर्खारालाई, ‘धुत किर्‍या झाःन्‍या माताए,’ स़ोनो, ‘परमेस्‍वरए उमिनत काताराल किर्‍या जेझाःकिन नोलाई जुनी ब सयो·व ज़ परिए’ है लिद सथैव ज़ यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ङा ते झन है ङादाचिज़्‍या, किर्‍या झाः ज़ ताझाःच्‍यो। नम छुद तादी ब ताझाःच्‍यो, नत परमेस्‍वरए उसिंहासन लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","नाम छुद ब ताझाःच्‍यो, नाम परमेस्‍वरए उखँ नैन्‍या पो ची। यरूसलेमए उमिननी ब ताझाःच्‍यो, नो राजाराए याराजाए ओसहर ची। ");
INSERT INTO kjl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","जेङ़ै छुद ब ताझाःच्‍यो, जेङ़ैताव चेमलाई पालो ब जेमाजैधुइ, मोलो ब जेमाजैधुइ। ");
INSERT INTO kjl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","है जैद जे हैज़लाई हैज़, माःकलाई माःक ज़ है लिच्‍यो। नोकिन आगल्‍या भरी ओचाहित माल्‍यो ज़ लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“आव ब थैद जेनैज़्‍याखेहो, ‘छुतलाई ओहा केःद ओएकिन, उमी पा·द ओएकिन, हाए ओपोल हा, मीए ओपोल मी ताव ज़ उपरिज़्‍याव।’ ");
INSERT INTO kjl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ङा ते झन जेलाई है ङादाचिज़्‍या, माचाव य़ेनत खिस ताफेरैच्‍यो। काताकावए तँनिकाव नगालात लप्‍तैद उईंकिन, तँनिकाव नगाला ब थाँदियो। ");
INSERT INTO kjl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","स़ोनो काताकावए नचूबन्‍दी नैंन्‍याए जूँनी मुद्दा झाःद उईंकिन नफुतु ब हाइद एयो। ");
INSERT INTO kjl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","फरी काताकावए करस ज़ तकिलोमितर लाँव ओपैंकिन नोस अझ ऩेकिलोमितर पै बानी। ");
INSERT INTO kjl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","नँस ऩिज़्‍यावलाई एयो, नँस कातार लोसो ओपैंकिन ‘माले’ है मादाद लोइयो।” ");
INSERT INTO kjl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“आव ब थैद जेनैज़्‍याखेहो, ‘नैं मेंलाई समारिन्‍या, सुतुरलाई सोन्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ङा ते झन जेलाई है ङादाचिज़्‍या, जेसुतुररालाई मनी यारासमारिच्यो, जेखिरी पसिज़्‍यावराए याजूँनी पोंखारिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","हो ताकिन ची स्‍वर्गताव जेबाबुए ओज़ार तान्‍या जेले। होए चाव माचाव प़ाइँलाई निमी ब पले·द याएज़्‍याव, धर्मीर स़ोनो अधर्मीरालाई नम ब सवाद याएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","जेलाई समारिज़्यावरालाई वाज़ जेरासमारिकिन स्‍वर्गताव जेजुँ कातानी जेदैरिज़्‍याव? नाःवाकाव य़ेन ते पापी है यारादोज़्‍याव सिर्मा स्‍यो·ज़्‍यावराए मनी दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","जेक्‍याँदाङावरालाई वाज़ मानस जेरासुम्‍किन नो काता ज़ माःक। नाःवाकाव ते परमेस्‍वरलाई मासरेस्‍ज़्‍यावराए ब दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","है जैद स्‍वर्गताव जेबाबु किताव ओखत माल्‍यो छैंव लिज़्‍या, जे ब हिताव ज़ ताव परिके।” ");
INSERT INTO kjl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“मिँराए याङ़ाक वाज़ सतैंसिन्‍या धर्मनी जोगोइसिद लिच्‍यो, म़ानी स्‍वर्गताव जेबाबुए ल्‍योनी काता ज़ दैन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","है जैद जे मायो·व माथैंवरालाई जेराएक नो कैफतीराए याराएज़्‍याव मिताव माःक। नोर मिँराए ङ़ाक चाव धर्मी सरैंःसिन्‍याए जूँनी धर्मसास्‍त्र झ़िम जीदा, बजार जीदा भोंकरर तप्‍द दुलिज़्‍यार। जेलाई साचो है ङादाचिज़्‍या, नोराए याइनाम नाः ज़। ");
INSERT INTO kjl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","है जैद जे मायो·व माथैंवरालाई जेराएक वोर्फताव जेकुइए जेभाःव दाबर्‍याफताव जेकुइए तासैंवक। ");
INSERT INTO kjl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","सुए ज़ यामासैंद जेभाःव मिताव ओताक। हो ताकिन ची म़ोंसिउलाव रँःज़्‍याव परमेस्‍वर जेबाबुए नो जेदोव रँःद स्‍वर्गताव जेइनाम यान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“परमेस्‍वरलाई जेपोंखारिक ब नो कैफतीराए यापोंखारिज़्‍याव मिताव पोंखारिन्‍या माःक। नोर धर्मसास्‍त्र झ़िम जीदा, येम खार जीदा ‘प़ाइँए घरँःसिरक’ लिद च्‍याँःसिद पोंखारिन्‍या युँ दोज़्‍यार। साचो है ङादाचिज़्‍या, नोराए याइनाम नाः ज़। ");
INSERT INTO kjl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","बुरू जे ते परमेस्‍वरलाई जेपोंखारिक तोबो कुन्‍तील पसिद य़ाम गल्द सुए ज़ यामारँःद स्‍वर्गताव जेबाबुलाई पोंखारिच्‍यो। हो ताकिन ची म़ोंसिउलाव रँःज़्‍याव परमेस्‍वर जेबाबुए स्‍वर्गताव इनाम यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","फरी जे जेपोंखारिक परमेस्‍वरलाई मासरेस्‍ज़्‍यावराए माँःती पर्बख्‍यान तालिच्‍यो। नोराए ‘कुधु ख्यो·व गेपोंखारिकिन थैद्यासिवा’ लिन्‍या सम्‍जिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","जे ते नितावर ताताच्‍यो। जे जेमापोंखारिद ज़ परमेस्‍वर जेबाबुए ‘आव आव चाहिज़्‍या’ लिन्‍या ङ़ादा ज़ सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","जे जेपोंखारिक इतावनी पोंखारिच्‍यो, ‘अ स्‍वर्गत लिज़्‍याव गेबाबु, नँ नमिन प़ाइँए ज़ छैंव ओथ·रैरक। ");
INSERT INTO kjl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","स्‍वर्गताव नराज्‍या आव नामल उहुक, स्‍वर्गताव है नलिज़्‍याव मिताव आव मानुवाल ब ओताक। ");
INSERT INTO kjl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","गेलाई चाहिज़्‍याव ज़्‍याव दिनकाव ज़ जोरैद्यासियो। ");
INSERT INTO kjl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","नउपर्त गेदोव पापरानी ऱास्‍सियो। हो मिताव ज़ गे ब मिँराए गेउपर्त यादोव पापरानी गेराऱास्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","गेलाई माचाव चेतैन्यारानी जोगोइद माचाव भरिनी पले·द पाथस नैसियो। खर्क ज़ माखेम्‍न्‍या राज्‍या ब नमीं ज़, सक्ती ब नमीं ज़, ज़गै मगै ब नमीं ज़। आमेन।’ ");
INSERT INTO kjl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","जे जेङ़ैताव पाप दोज़्‍यावलाई जेऱास्‍किन, स्‍वर्गताव जेबाबुए जेलाई मनी ऱास्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","फरी जे जेङ़ैताव पाप दोज़्‍यावलाई ऱासो जेमाभैंःकिन स्‍वर्गताव जेबाबुए जेलाई ब ऱास्‍न्‍या माले।” ");
INSERT INTO kjl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“जे जेउपासिक कैफतीराए यादोज़्‍याव मिताव तादोच्‍यो। नोर, ‘हत्‍या गेकातिज़्‍याव प़ाइँए घरँःसिरक’ लिद याङाःर ब हुली हुली च्‍या·व जैसिज़्‍यार। जेलाई साचो है ङादाचिज़्‍या, नोराए याइनाम नाः ज़। ");
INSERT INTO kjl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","जे ते जेउपासिक ‘मिँराए तासरेस्‍सिरक’ लिद जेङाःर हुर्सिद म़ासर थीसिद ल्‍यो ताके। ");
INSERT INTO kjl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","हो ताकिन ची म़ोंसिउलाव रँःज़्‍याव स्‍वर्गताव जेबाबुए ओल ज़ सैंद स्‍वर्गताव जेइनाम नैद्यान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“जे आव मानुवात जेजूँनी धन सम्‍पती तादुप्‍च्‍यो। आव मानुवाताव धन भरी घुनराए ब ज़्‍युज़्‍यार, खैए ब कैज़्‍याव, चोरराए ब झ़िम पा·द कुज़्यार। ");
INSERT INTO kjl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","है जैद जे जेसम्‍पती स्‍वर्गत दुप्‍चिके। नल घुनए ब माज़्‍युव, खैए ब माकैव, चोरराए ब मालाँर। ");
INSERT INTO kjl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काराव ल्‍यो ताकिन जोङ जेधन लिज़्‍या, जेयुँ ब होङ ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“जेक्‍याँताव बत्ती जेमी लिज़्‍या। है जैद जेमी चाव उलिकिन जेक्‍याँ भरी पलाँव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","फरी जेमी माचाव उलिकिन जेक्‍याँ भरी चुम चुमोल ज़ ताज़्‍या। है जैद नो जेक्‍याँताव पलाँव ताव परिन्‍या चुम चुमो ओताकिन झन ज़ छाम छाम तान्‍या ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“तोबो बाँदाए ऩेब्‍लो साहुनी निय़ेन मादोधुव। दाव उपरिकिन नोए तोबोलाई सोद तोबोलाई चाव रँःन्‍या ले, कितर तोबोए ओपाँ भैंःद तोबोलाई ओलेखा नैद्यान्‍या माले। हिताव ज़ जे मनी परमेस्‍वरए ओसेवा स़ोनो पैसाए ओसेवा तखेप्‍त जेमादोधुइ।” ");
INSERT INTO kjl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“है जैद ङा जेलाई है ङादाचिज़्‍या, जे जेक्‍याँए उजूँनी ‘काता ङाज़्‍युके, काता ङाओके, काता ङाक्‍वाइसिके’ लिद व़ीनी फुइ तालिच्‍यो। आव गेजिउ ज़्‍यान्‍या क्‍वाइसिन्‍याए जूँनी वाज़ माःक। ");
INSERT INTO kjl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","नमताव बाज़ारालाई याराचिऊचिके। नोराए धुर ब माझाःर, क्‍या·न्‍या ब माक्‍या·र, ज़्‍याव ब मादुप्‍र। हितावत ब नोरालाई चाहिज़्‍याव भरी स्‍वर्गताव जेबाबुए याएज़्‍याव। परमेस्‍वरए जेलाई झन बाज़ाराकिन घेप्‍पा रँःचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","जेनी सुए ची सोगो दाद जेजिउत तघन्‍ता जेचा·धुरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“है जैद काताए जूँनी क्‍वाइसिन्‍या क्‍वारात सोगो जेदोज़्‍याव? बुखीताव वासर याराचिऊचिके। नोराए धामा दाद माखल्‍र। ");
INSERT INTO kjl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","हितावत ब सोलोमन राजा बनै तह महौ ओजैसिदी ब वास तकल माताए। ");
INSERT INTO kjl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","परमेस्‍वरए आछिम वैद पराःती मेंःल बाज़्‍याव छीर नाः चाव याजैज़्‍याव ल्यो ताकिन जेलाई झन कै जैद माक्‍वाइचिउके? काता नाः जेयुँ माहुबोर जेलिज़्‍याव! ");
INSERT INTO kjl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“है जैद जे ‘काता ङाज़्‍युके, काता ङाओके, काता ङाक्‍वाइसिके’ लिन्‍यादा जेयुँ थू जैद व़ीनी फुइ तालिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","आव भरी ते परमेस्‍वरलाई मासरेस्‍ज़्‍यावराए याध्‍यावना ची। जे जेजूँनी चाहिज़्‍याव भरी ते स्‍वर्गताव जेबाबुए ज़ सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","बुरू जे प़ाइँरानी ङ़ात परमेस्‍वरए ओराज्‍या खिम्‍द उयुँलाव मिताव य़ेन दान्‍या जैसिचिके। हो ताकिन ची जेलाई चाहिज़्‍याव भरी ओल ज़ जोरैद्याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","है जैद जे पराःतीकावए जूँनी सोगो तादोच्‍यो। पराःतीकाव सोगो हो छ्याम ज़ खेम्‍ज़्‍या। काताए जूँनी आछिमकाव सोगोत झन होलाई ब चा·व जेपैंज़्‍याव?” ");
INSERT INTO kjl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“जे अर्काए ओखत पले·द ताएच्‍यो, म़ानी परमेस्‍वरए जे जेखत ब पले·द्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","जे छुतलाई कितावनी जेथ·रैज़्‍या, जे मनी हितावनी ज़ जेथ॰रिरिज़्‍या। स़ोनो किताव गोइँनी जेगोइँज़्या, जे मनी हिताव गोइँनी ज़ दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","फरी कै जैद ननैंए उमीलाव तकेज़ा सींका नरँःज़्‍याव, नँ नमीलाव नाःल्‍दिउ मुँदा ताकितर नमारँःज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","नमीलाव नाःल्‍दिउ मुँदा लिज़्‍यावत कै जैद ननैंलाई, ‘नमीलाव सींका हाइद ङाईं’ है नदोधुरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ए निताव पाँज़्‍याव कैफती, ङ़ादा नमीलाव मुँदा हाइकेदा, ननैंए उमीलाव सींका नहाइक छर्लङ्ग रँःन्‍या नले।” ");
INSERT INTO kjl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“छैंव पाँर काः स्‍यासोरालाई ताराएच्‍यो, म़ानी नोर जेल्‍योदा हुद छुपिहुन्‍या लेर। स़ोनो हिरामुती स्‍यासोर ऊ स्‍यासोराए याङ़ाक ताख्‍याच्‍यो, म़ानी नोराए हिलाल छिल्‍न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“फरी ब तोबो है ङादाचिज़्‍या, परमेस्‍वरस जेऩिकिन जेलाई यान्‍या ज़ ले, जेखिम्‍किन दैन्‍या ज़ जेले, य़ाम कोतो कोतो जेजैकिन जेजूँनी फैसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","जोए ऩिज़्‍याव होलाई यान्‍या ले, जोए खिम्‍ज़्‍याव होए दैन्‍या ले, जोए कोतो कोतो जैज़्‍याव होए उजूँनी फैसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","फरी तोबो ज़िम्‍ज़ा ल़ुज़ाए ओबाबुस भरेस उऩिकिन लुँ ते मायो, ");
INSERT INTO kjl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ङाँः उऩिक घुल ते मायो। ");
INSERT INTO kjl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","है जैद जे निताव पापल लिज़्‍याव मिँराए जेज़ारालाई निताव चाव चाव यान्‍या जेसैंकिन, स्‍वर्गताव जेबाबुए झन ओलस जेऩिकिन चाव चाव कै जैद मायाचिउके? ");
INSERT INTO kjl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","है जैद जे छुतए ल्‍योनी किताव जेपैंज़्‍या, जे ब छुतए ल्‍योदा हितावनी ज़ दोचिके। मोसाए ओकानुन स़ोनो अगमबक्ताराए यासरो ब नत ज़ तुपिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“चूव य़ामनी ज़ पसिच्‍यो। नासदा बान्‍या येम ते राँव, पसिन्‍या य़ाम ब बनै वैःव लिज़्‍या। नो येमनी बाज़्‍यावर बनै कुधु ज़ लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","खाली अजम्‍बरी जुनीदा बान्‍या येम स़ोनो य़ाम चूव, धो पसिउ ओतावए नो येमल बान्‍यार छ्या ज़ ताज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“परमेस्‍वरए ओपाँ बले·द तँनी पैज़्‍यावराए ल्‍योनी जोगोइसिद लिच्‍यो। नोर पाखात बगाललाव बेधा स्‍यासोर जैसिज़्‍यार, यायुँल ते छे छे ङम्‍सिउ प़र स्‍यासोर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","किताव सींरालाई यासैनी जेरासरेस्‍ज़्‍या, हिताव ज़ नोरालाई मनी याय़ेननी ज़ सरेस्‍न्‍या जेले। कारज़ुत जोम्‍परसै मासैए, ज़ुसैत कोराली ब मासैए। ");
INSERT INTO kjl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","हिताव ज़ चाव सींए चाव सै ज़ झाःज़्याव, माचाव सींए माचाव सै ज़ झाःज़्याव। ");
INSERT INTO kjl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","फरी चाव सींए माचाव सै माझाःव, माचाव सींए चाव सै ब माझाःव। ");
INSERT INTO kjl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जो सींए चाव सै माझाःव नो सीं पल्‍द मेंःल ख्‍यान्‍या वाज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","है जैद जे हो तँनी पैज़्‍यावरालाई याय़ेननी ज़ सरेस्‍न्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“जोए ओयाःए वाज़ ङालाई ‘प्रभु, प्रभु’ है दाँज़्‍याव, नो स्‍वर्गताव राज्‍याल पसिधुन्‍या माले। जोए स्‍वर्गताव ङाबाबुए उयुँलाव मिताव य़ेन दोज़्‍याव, हो वाज़ पसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","नो छ्याम कुधुए ङालाई, ‘अ प्रभु, अ प्रभु, गे नमिननी परमेस्‍वरए ओपाँ ब गेरासथैके, माचाव पुरूसर ब गेरापले·के, अचम्‍बलाव सरेसर ब गेरासतैंके,’ है यादाँकिन, ");
INSERT INTO kjl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ङा नोरालाई, ‘जेलाई खर्क ज़ ङामासरेस्‍चिए, जे निताव परमेस्‍वरकिन तँदाङाव य़ेन दाज़्‍यावर, आनी पुलुस्‍द बाचिके,’ है दान्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“है जैद जोए आव ङापाँ थैद दोज़्‍याव, नो तोबो ओगहक ल्‍यो मिँए झ़िम ओजैक पतालल लुँ तर्त गज ओथाँज़्‍याव स्‍यासो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","नम बनै वाद, ल्‍यो माल्‍यो बतासर भलर उहुक नो झ़िम लुँ तर्त ओतावए माधलिके। ");
INSERT INTO kjl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","हो मिताव ज़ जोए आव ङापाँर थैद ओमादोकिन तोबो ओगहक माल्‍यो मिँए झ़िम ओजैक बालुवा तर्त ओजैव स्‍यासो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","बतासर दाद, नमर वाद, भलर हुद नो झ़िमलाई धलैद प्‍याःपी जैद लाँज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","येसुए आव पाँर सथैद उतुपैवत, नो माहोल्‍यार येसुए ओपाँ थैद अचम्‍ब ताकेर, ");
INSERT INTO kjl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काराव ल्‍यो ताकिन होए यासास्‍त्रीराए यारापैज़्याव मिताव माताद बनै हकस ओरापैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","नाःत ज़ येसु नो दाँदातिन झरिके। उछींत बाज़्‍याव मिँर बनै माहोल्‍या यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","नो बेलाक ज़ तोबो कुऱी ओल्‍योक हुद उखँत फुलुप्‍सिद, “अ प्रभु, ङाल्‍योदा नयुँ ओताकिन ङालाई सगराँन्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","येसुए नोलाई उकुइए छाप्‍द, “नल्‍योदा ङायुँ लिज़्‍या ज़, गराँनिके,” है ओदोव प़ाइँना ज़ नो ओक्‍याँताव कुऱीए ऱास्‍द सोजोकाव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","येसुए नो गराँवलाई, “आव नक्‍याँताव ङादोव य़ेन सुलाई ज़ है तारादोयो। बुरू नगराँव साचो ज़ ओल्‍यो लिन्‍या थ·रैव परींन्‍याए जूँनी पुजारीए ल्‍योक सतैंसिनाद मोसाए ओकानुनलाव मिताव चरैःन्‍यार चरैःनाके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","फरी येसु कफर्नहुमल ओकेस्‍नावत तोबो रोमी कप्‍तान ओल्‍योक हुद, ");
INSERT INTO kjl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“अ प्रभु, तोबो ङानोकोर ओजोरो हुद उखँ उकुइ माचलिद झ़िमक ज़ घ्याँसिद ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","येसुए, “ताए, ङा हुद सगराँन्‍या ङाले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","नो कप्‍तानए फरी, “अ प्रभु, ङा इतावए ङाझ़िमक नँलाई लाँन्‍या स्‍यासो ङामाले। बुरू आकिन ज़ ‘गराँनिके’ है नलिकिन ङानोकोर गराँन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ङा ब छुतए ओहक धूँलाव मिँ ज़, ङा ङाधूँल मनी कुधु सिपाईंर लिज़्‍यार। नोरालाई ‘बाचिके’ है ङारादोक बाज़्‍यार, ‘हुचिके’ है ङारादोक हुज़्‍यार। ङाबाँदालाई ब ‘इताव दोके’ है ङादोक दोज़्‍याव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","येसुए नो कप्‍तानए ओपाँ थैद अचम्‍ब ताद ओलस बाऱिज़्‍यावरालाई, “ङा जेलाई साचो है ङादाचिज़्‍या, इस्राएलीराए खार्ल मनी आव मिताव ङाल्‍योदा उयुँ हुबो सु ज़ ङामादैताए। ");
INSERT INTO kjl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","आदा थैचिके, स्‍वर्गताव राज्‍यालाव भत्‍यारल पुर्ब-पछ्युँनी छुत जातलाव मिँर ब बनै कुधु ज़ हुद अब्राहाम, इसहाक, याकूबरास सिप ज़ च़ुसिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","इस्राएली राज्‍यालाव ताव परिन्‍याकावर ते नल मापसिद चुम चुमोल परिरिज़्‍यार। नल याहार ङर ङर कैद चिर्लनी बिर्ल घर्न्‍या लेर,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","फरी नो कप्‍तानलाई, “बानिके, ङालाई किताव नयुँ उहुबो हिताव ज़ तान्‍या ले,” है दोक्‍यो। नो कप्‍तानए ओनोकोर येसुए है ओदोव बेलाक ज़ होङ ओगराँधुव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","नकिन येसु पत्रुसए उझ़िमक ओबाक पत्रुसए उमुइँज्‍यु ओजोरो हुद घ्याँसिद उलिज़्‍याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","येसुए नोलाई उकुइ छाप्‍द ओयो प़ाइँना ज़ ओजोरोए ऱास्‍क्‍यो। नो सोद बेहार ज़ येसुलाई ज़्‍यावर ब जैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ऱिमदा ऱिमदा मिँराए याजोरो हुवर, माचाव पुरूसराए क्‍योःद यारानैज़्‍यावरालाई येसुए ओल्‍योक यारारैकेर। येसुए ओपाँए ज़ नो माचाव पुरूसर पुलुस्‍द धोंःकेर, याजोरो हुवर ब गराँकेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","नो ओदोव य़ेन यसैया अगमबक्ताए सर्द ओनैज़्‍याव मितावनी ज़ ताके। नोए ओसरो आव ज़, “गेदुखर ब पले·द्यासिक्‍यो, गेजोरोर ब सगराँद्यासिक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","येसुए ल्‍योक तछा मिँर ल्‍यो माल्‍यो याछुइसिहुवए दोङ्गाल पसिद उसिसरालाई, “दह होफत गेबाया,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","हाःत ज़ तोबो सास्‍त्री येसुए ल्‍योक हुद, “गुर्बा, नँ जोदा नबाज़्‍या, ङा ब नँस ज़ ङाबाया,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","येसुए, “स्‍यालर लिन्‍या कुँ ब लिज़्‍या, बाज़ार लिन्‍या सिप ब लिज़्‍या। ङा मिँ मिन्‍सिद हुवलाई ते ङ़ै कप्‍न्‍या पो ब माले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","फरी तोबो ओलस बाज़्‍यावए, “अ प्रभु, ङ़ादा ङाबाबुलाई ङागादैदा, नँस ङाबाया,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","येसुए, “सिउरालाई सिउ स्‍यासोराए घरागादैज़्‍यारक, नँ ते ङास घुहुनी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","नकिन येसु दोङ्गाल उपसिउत उसिसर ब ओलस ज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","दह माँजल याबाज़्‍याक उमँःजानी ल्‍यो माल्‍यो बतास हुद ऱीए ओछल्‍कार दोङ्गाल पसिद दोङ्गालाई गदैवा गदैवा जैक्‍यो। हो बेलाक येसु ङ़ल्‍द उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","उसिसराए येसुलाई सोचोइद, “प्रभु, गेलाई बाँचैसिके, खदम ज़ गेतारिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","येसु सोद, “जे काराव जेछे·ज़्‍याव? जेयुँ नाः माहुबोर,” है दाद बतास स़ोनो ऱीनिलाई उनिसिङारो प़ाइँना थपक ज़ अदिके। ");
INSERT INTO kjl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","निताव रँःद उसिसर अचम्‍ब ताद, “आव किताव मिँ ओताव? बतासर ऱीराए ब ओपाँ यादोज़्‍याव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","येसु उसिसरास दह होफताव गदरिनीराए यापोङ याकेसो प़ाइँना ज़ माचाव पुरूसराए क्‍योःद यारानैज़्‍यावनी ऩेब्‍लो खादर पोनी पुलुस्‍द नोस दैसिहुकिनी। नोनी बनै निछ्यास ल्‍योनी निल्‍यो, नलाव घ्याँ सु ज़ आदा होदा यामालिधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","नोनी बनै चोइस अइ लिद क़िकिनी, “अ परमेस्‍वरए ओज़ा, गिनस नखै काता उलिज़्‍याव? परमेस्‍वरए गोइँद ओनैज़्‍याव बेला ओमाहुद ज़ गिनलाई दुख याना नहुव रो?” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","नो बेलाक जाँ होकसैक ऊर तबगाल यालाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","नो माचाव पुरूसराए, “गेलाई पले·न्‍या ताकिन नो ऊराए क्‍याँत बाव यासिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“ताए, नोनी निक्‍याँनी पुलुस्‍द बाचिके,” है ओरादोक ते, नोर पुलुस्‍द ऊराए याक्‍याँत यापसिउ प़ाइँना ज़ ऊर ओपो·स ज़ बूलिद दाँदातिन सुइँःकिनाद दहल ज़ो·द प़ाइँ ज़ स़ुद सिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","निताव रँःद नो ऊ गावलार ननी धोंःनाद सहर जीदा बाद प़ाइँलाई ज़ ‘माचाव पुरूसराए क्‍योःद यारानैज़्याव मिँनिलाई इताव इताव ताके’ है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","नो याथैव प़ाइँना ज़ सहरलावर ओपो·स ज़ येसुए ल्‍योक बाद, “आनी पुलुस्‍द बान्‍के,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","हाःत ज़ येसु उसिसरास दोङ्गाल पसिद ङ़ादाङाव यालिज़्‍याव कफर्नहुमल ज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","नल तोबो उखँ उकुइ सिउलाई झेलोङ्गाल झाःद येसुए ल्‍योक रैकेर। येसुए नोराए यायुँ उहुबो रँःद नो उखँ उकुइ सिउलाई, “अ कान्‍छा, नयुँ होलाँ जैके, नपाप क्‍याल्‍सिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","नो है ओदोव सास्‍त्रीराए थैद या याल, “आव मिँए काराव ब्‍याँ इताव परमेस्‍वरए उमिन ओबले·ज़्याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","येसुए नोराए यायुँलाव पाँ सैंद, “जे काराव जेयुँल आव ङापाँ माचाव जेथ·रैज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","नो मिँलाई ‘नपाप क्‍याल्सिके’ है दान्‍या सैं ‘सोद बान्‍के’ है दान्‍या काताकाव सजालो उलिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","अब ङा मिँ मिन्‍सिद हुवए आव मानुवात पाप क्‍याल्‍न्‍या ङाकुइत उलिज़्‍याव सैं ओमालिज़्‍याव, चिऊचिके,” है दाद नो उखँ उकुइ सिउलाई, “नँ सोद नझेलोङ्गार घुर्द नझ़िमदा बान्‍के,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","नो उखँ उकुइ सिउ थर च्‍याँःसिद ओझेलोङ्गार घुर्द उझ़िमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","नो रँःज़्‍याव माहोल्‍याराए निताव य़ेनर रँःद छे·द, “परमेस्‍वरए मिँरालाई ब इताव अचम्‍बलाव सक्तीर ओराएज़्‍याव ओल्‍यो,” लिद परमेस्‍वरए उमिन सघ्‍योःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","येसु ननी ओबाज़्‍याक तोबो मत्ती यादोज़्‍यावलाई सिर्मा स्‍यो·न्‍या अद्दाक च़ुसिद उलिज़्‍याव रँःद नोलाई, “ङास हुन्‍के,” है ओदोव प़ाइँना ज़ नो च्‍याँःसिद येसुए उछींत बाके। ");
INSERT INTO kjl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","येसु उसिसरास होए उझ़िमक बाद ज़्‍यान्‍याए जूँनी च़ुसिकेर। नो बेलाक ओलस सिप ज़्‍युज़्‍यावर सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापी है यारादोज़्‍यावर बनै कुधु ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","फरिसीराए निताव रँःद येसुए उसिसरालाई, “जेगुर्बाए कै जैद निताव सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापीरास सिप उज़्‍युज़्‍याव?” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","येसुए नो यापाँ थैद, “याजोरो माहुज़्‍यावरालाई सगराँन्‍या मिँ माचाहिए, याजोरो हुज़्‍यावरालाई वाज़ चाहिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","हिताव ज़ ङा मनी ‘गे धर्मी’ है लिज़्‍यावराए जूँनी ङाहुव माःक, ‘गे पापीर ज़’ है लिज़्‍यावराए जूँनी ङाहुव ची। आव धर्मसास्‍त्रलाव पाँए ओअर्थ ब सैंच्‍यो, ‘पाथा पल्‍द चरैःज़्यावरास माःक, यादया ल्‍योरास ङायुँ होलाँ ताज़्‍या।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","हो बेलाक ज़ ऱील सछैंज़्‍याव यूहन्‍नाए उसिसर येसुए ल्‍योक हुद, “गे स़ोनो फरिसीर गेउपासिज़्‍या, नँ नसिसर काराव यामाउपासिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","येसुए नोरालाई, “जन्‍तीर ब्‍याहोल्‍यास यालेवा पै सोगोल यालिज़्‍याव रो? खाली जो छ्यामकिन ब्‍याहोल्‍यालाई छुतैर, हो छ्यामकिन वाज़ उपासिन्‍या लेर,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","फरी घर्ती झाःद याएक्‍यो, “सुए ज़ ओरे छिबो क्‍वालाई साःरो क्‍वाए मातालिउ, ओतालिकिन नो साःरोए पुराँदोलाई ओल्‍योदा स़ेल्‍द झन ज़ चीज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","स़ोनो, साःरो दाखमद्य पुराँदो प़िर्गुलल सुए ज़ माझाःर। म़ानी उस॰ए प़िर्गुललाई सुफुद दाखमद्य ब भोन्‍या ले, प़िर्गुल ब खेर ज़ बान्‍या ले। है जैद साःरो दाखमद्य साःरो प़िर्गुलल झाःकिन वाज़ ऩेथो ज़ खेर बान्‍या मालिनी।” ");
INSERT INTO kjl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","येसुए नो पाँर ओरासथैज़्‍याक ज़ धर्मसास्‍त्र झ़िमलाव याघेप्‍पा तोबो हुद येसुए उखँत फुलुप्‍सिद, “मेंमा ङाज़ा भर्ज़ा ज़ सिद ले। नँ हुद नोए ओक्‍याँत नकुइ नैद नएकिन नो सैंसिन्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","येसु ननी च्‍याँःसिद उसिसरास नोस बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","येमत याबाज़्‍याक तोबो बाह्र बर्स भरी ओक्‍याँतिन झी भोन्‍या बेथाए क्‍योःद ओनैज़्‍याव मेंमा येसुए उछींनी हुद ओक्‍वाए उतुपात छाप्‍दिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","नो मेंमाए उयुँल उयुँल ‘येसुए ओक्‍वा वाज़ छापो ङादैकिन आव बेथानी गराँन्‍या ङाले’ है लिद ओखामिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","येसु उछींदा फर्किद नोलाई रँःद, “अ माँज़ा, नयुँ होलाँ जैके, ङालाई नयुँ नसुहुबोनी ज़ नगराँके,” है ओदोव प़ाइँना ज़ नो मेंमा गराँके। ");
INSERT INTO kjl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","हाःत ज़ येसु उसिसरास नो धर्मसास्‍त्र झ़िमलाव याघेप्‍पाए उझ़िमक याकेस्‍क नो सिउए उजूँनी सहन यातप्‍ज़्‍याव, चिर्लनी बिर्ल याघर्ज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","येसुए नोरालाई, “लाँःदा बाचिके, ल़ुज़ा मासिए, अइज़ ङ़ल्‍द ले,” है यादोक्‍यो। येसुए ओपाँ थैद हसैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","येसुए नोरालाई लाँःदा पुलुसो परींद ओल झ़िमल पसिद नो सिउ ल़ुज़ालाई उकुइनी ओक्‍योःव प़ाइँना थर च्‍याँःसिके। ");
INSERT INTO kjl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","निताव अचम्‍बलाव पाँ नो खन्‍द भरिदा ज़ थास्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","येसु ननी पुलुस्‍द ओबाज़्‍याक ऩेब्‍लो निमी मारैंःवनी उछीं उछीं बाद, “अ दाऊदए ओथोलाव, गिनलाई नयुँ ओनाक,” लिद बनै चोइस क़िकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","येसु झ़िमल उपसिउत नो निमी मारैंःवनी ब ओल्‍योक ज़ हुकिनी। येसुए नोनिलाई, “ङालाई ‘नसगराँसिन्‍धुया ज़’ लिद जिनयुँ माहुप्‍ज़्‍या?” है उनिदोक ते, “गिनयुँ हुप्‍ज़्‍या, प्रभु,” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","हाःत ज़ येसुए नोनिलाई निमीत छाप्‍द्याद, “जिनयुँ उहुबो मिताव ज़ ओताक,” है उनिदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","रँःधुन्‍या ताकिनी। येसुए नोनिलाई फरी, “आव जिनक्‍याँताव ङादोव य़ेन सुए ज़ तासैंरक,” है दाद निअर्थैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","नोनी झन ननी बाद येसुए ओदोव भरी प़ाइँङ ज़ है यारादोनाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","नोनी निबाव छींनी फरी माचाव पुरूसए क्‍योःद ओनैज़्‍याव तोबो लातालाई येसुए ल्‍योक रैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","येसुए नो माचाव पुरूस पले·द ओयो प़ाइँना ज़ नो लाता पाँधुन्‍या ताके। नो य़ेनर रँःद नक लिज़्‍याव माहोल्‍याराए, “इताव य़ेनर ते इस्राएलीराए गेपोल खर्क ज़ गेमारँःए!” लिद अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","फरिसी भरिए ते, “आवए माचाव पुरूसराए याघेप्‍पाए उमिननी माचाव पुरूसर यापले·ज़्‍याव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","येसु सहर सहर, नाखार नाखार यादुप्‍सिज़्‍याव धर्मसास्‍त्र झ़िम झ़िमक बाद परमेस्‍वरए ओराज्‍यालाव चाव था ब ओरासथैज़्‍याव, भाँती भाँतिलाव रोगनी याजोरो हुवरालाई मनी ओरासगराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","नो ओल्‍योदा हुज़्‍याव माहोल्‍यारालाई यागावला माल्‍यो यार्च्‍या सिद थलिउ बेधा स्‍यासोरालाई रँःद, येसुए उयुँ नाद, ");
INSERT INTO kjl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","उसिसरालाई है यादोक्‍यो, “तामर चिकार यामींःनाव मिताव, परमेस्‍वरए ओराज्‍याल हुन्‍यार कुधु ज़ ताद लेर। खाली नोरालाई रैन्‍या बाहोर्‍यार ते छ्या ज़ ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","है जैद नोरालाई रैन्‍या मिँर ओरापरींवक लिद परमेस्‍वरलाई पोंखारिच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","येसुए बाह्र जना उसिसरालाई खुल्‍द माचाव पुरूसर पले·न्‍या स़ोनो भाँती भाँतिलाव रोगनी सगराँन्‍या सक्तीर ब याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","नो बाह्र जना ओसाचीराए यामिनर आवर ज़ — प़ाइँरानी ङ़ाताव उसिस पत्रुस यादोज़्याव सिमोन, नकिन नोए ओभाइ अन्‍द्रियास, जब्‍दियाए ओज़ानी याकूब स़ोनो यूहन्‍नानी। ");
INSERT INTO kjl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","नकिन फिलिप, बारथोलोमाइ, थोमा, सिर्मा स्‍यो·ज़्‍याव मत्ती, अल्‍फयसए ओज़ा याकूब, थेदियस, ");
INSERT INTO kjl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","देसभक्ता सिमोन स़ोनो छींनी येसुलाई धोका याज़्‍याव यहूदा इस्‍करियोत। ");
INSERT INTO kjl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","नो बाह्र जनारालाई येसुए अइ लिद यापरींक्‍यो, “जे जेबाक यहूदीराकिन छुत जातलावराए ल्‍योदा ताबाच्‍यो, स़ोनो सामरीराए यासहरल ब तापसिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बुरू एकसब्‍द्या ज़ इस्राएली जातलाव ङोइव बेधा स्‍यासोराए ल्‍योङ ज़ बाच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","नङ बाद पो पोङ, ‘स्‍वर्गताव राज्‍या सो हुरिके’ है लिद यारासथैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","याजोरो हुवरालाई ब यारासगराँच्‍यो, सिउरालाई याराजागैच्‍यो, कुऱीरालाई सोजोकाव ज़ याराजैच्‍यो, माचाव पुरूसर यारापले·च्‍यो। आव सक्ती भरी अइज़ जेदैके, अइज़ याराएच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","जेवाँःफोत सुन चाँदीर पैसार तालाँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","येमत जेबाक झ़ैं ब तालाँच्‍यो, फेरैसिन्‍या क्‍वा ब तालाँच्‍यो, छुत पोला ब तालाँच्‍यो, झुइ ब तालाँच्‍यो। जो य़ेनत तादी ब य़ेन दाज़्‍यावए ज़्याव दैव ज़। ");
INSERT INTO kjl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“फरी जो नाखारल जो सहरल तादी ब जेबाक जे लिन्‍या स्‍यासो सोजो मिँए उझ़िमक लिच्‍यो। ननी जेमापुलुसा पै नक ज़ लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","नो झ़िमल जेपसिक, ‘आव झ़िमलाई असिक ओताक,’ है लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","है जैद नो झ़िमलावराए जेलाई नैन्‍या स्‍यासोर यालिकिन नो जेदोव असिक नोरास ज़ ओताक। फरी नोर जेलाई नैन्‍या स्‍यासोर यामालिकिन नो जेदोव असिक नोरास ताताक। ");
INSERT INTO kjl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जोराए जेलाई ल्‍यो मायाद जेपाँ ब थैव यामाभैंःकिन नो झ़िमनी तादी ब सहरनी तादी ब जेपुलुस्‍क नो पोलाव जेखँताव गालो धुइरो नल ज़ थरैद ख्‍यानैद याराएच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ङा जेलाई साचो है ङादाचिज़्‍या, परमेस्‍वरए फाल्‍न्‍या छ्याम नो सहरलाव मिँराकिन बुरू सदोम स़ोनो गमोरालावरालाई सहिधुन्‍या तारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“जे फरी जोगोइसिद बाच्‍यो। जेलाई प़र मितावराए खार्ल बेधा पाथा मितावर जैद ङापरींचिज़्‍या। है जैद जे सैंन्‍यात घुल मिताव बाथो, दान्‍यात कुइतम मिताव लातो ताच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","है जैद माचाव मिँराए ल्‍योनी जोगोइसिच्‍यो। नोराए जेलाई अदालतदा लाँद सूँपिचिरिज़्‍यार, धर्मसास्‍त्र झ़िम झ़िमल रीःचिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","स़ोनो ङा ङाजूँनी हाकिमर राजाराए ङ़ाक सच्‍याँद खोले·चिरिज़्‍यार। ननी ज़ जे नोरालाई स़ोनो छुत जातलावरालाई ङासाची यान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","है जैद नोराए जेलाई यासूँपिचिक, ‘ङा कै लिन्‍या, काता पाँन्‍या ओताव’ लिद जेयुँ आँचा पाँचा ताजैच्‍यो। नो बेलाक जे पाँव परिन्‍या भरी परमेस्‍वरए ल्‍योनी ज़ दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","नो बेलाक पाँन्‍यार जे माःक, परमेस्‍वर जेबाबुए छैंव उपुरूस जेयाःत च़ुसिद पाँन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“हो बेलाक ओभाइए ओदाज्‍युलाई, ओबाबुए ओज़ालाई सैःन्‍या सजाल यारापारैरिज़्‍यार। याबाबु याआमाकिन तँदा जैसिद याज़ाराए सैःन्‍या सजाल यारापारैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","जे ङामिनतावर जेतावए जेलाई प़ाइँए सोन्‍या लेर। खाली जो आव भरी ओमाखेमा पै थ॰रिज़्‍या, होए अजम्‍बरी जुनी दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जो नाखारल जेबाज़्‍या होल जेखिरी यापसिकिन ननी हाइसिद छुत नाखारल धोंःच्‍यो। साचो है ङादाचिज़्‍या, जे इस्राएलीराए यासहर भरिल आव य़ेन जेमातुपैद ज़ ङा मिँ मिन्‍सिउ हुन्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","फरी, “उगुर्बाकिन उसिस घेप्‍पा माताए, ओय़ेन दाज़्‍याव ब ओघरपतीकिन घेप्‍पा माताए। ");
INSERT INTO kjl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","उसिस उगुर्बा ओतावक पै वाज़ ताज़्‍या, ओनोकोर मनी ओघरपतीए ओहक भरी ओदैदी ब ओघरपती ओतावक पै वाज़ ताज़्‍या। है जैद ङा झ़िमए ओर्गेलाई ज़ माचाव पुरूसराए याघेप्‍पा ‘बालजिबुल’ है यादाँकिन झन जे ङाझ़िमलावरालाई कै जैद है मादाचिरके?” ");
INSERT INTO kjl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“है जैद जे नोरालाई रँःद ताछे·च्‍यो। नो बेलाक कप्‍सिउल लिज़्‍याव भरी प़ाइँए सैंन्‍या लेर, म़ोंसिउल लिज़्याव भरी ब छर्लङ्ग ज़ रैंःरिज़्यार। ");
INSERT INTO kjl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","है जैद जेलाई म़ोंसिउलाव है ङादाचिउ भरी जे पाखाङ ज़ यारासथैनाच्‍यो। ङाल्‍योनी जेर्नाल खुस खुसनी जेथैव भरी ब थालातिन यारासथैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जेक्‍याँलाई वाज़ सैःद्याज़्‍यावर जेपुरूसलाई कैज़ माजैधुज़्‍याव मिँर रँःद ताछे·च्‍यो। बुरू जेपुरूस जेक्‍याँलाई नर्गल ख्‍याद चुयाप जैधुज़्‍याव परमेस्‍वरलाई रँःद वाज़ छे·च्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“ऩेब्‍लो बिङर्‍या तपैसाल ओमाबिकैज़्याव रो? बिङर्‍या नाः सोङ्गो ओतादी ब स्‍वर्गताव जेबाबुए ओमासैंद तोबो ब नामल तेन्या माले। ");
INSERT INTO kjl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","होए जेङ़ैताव जेचेम आः लिज़्‍या लिन्‍या ब सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","है जैद काताल ज़ ताछे·च्‍यो। कुधु बिङर्‍याराकिन होए जेलाई घेप्‍पा रँःचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“है जैद जोए मिँराए ङ़ाक ओलाज माहुद ‘ङा येसुसकाव ज़’ है लिज़्‍या, ङा ब नोलाई स्‍वर्गताव ङाबाबुए ओङ़ाक ‘ङासकाव ज़’ है दान्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","हो मिताव ज़ फरी जोए मिँराए ङ़ाक ‘ङा येसुसकाव माःक’ है लिज़्‍या, ङा मनी स्‍वर्गताव ङाबाबुए ओङ़ाक ‘आव ङासकाव माःक’ है दान्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“जे ङालाई ‘आव मानुवाताव मिँरालाई सखैना हुव लिज़्‍या’ है तालिच्‍यो। ङा ते झन जेखार्ल तरवाली रैद ङाहुव मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","आव ङापाँए ज़ा बाबुनिलाई माखैव निजैरिज़्‍याव। हिताव ज़ ज़ा-मा तादी ब, फुबु भदै तादी ब माखैव याजैरिज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","स़ोनो यासुतुर याझ़िमल ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","जोए ङाकिन ओबाबु ओआमानी निल्‍योदा उयुँ थू ओजैकिन नो ङासकाव तान्‍या स्‍यासो माले। स़ोनो ङाकिन ओज़ाराए ल्‍योदा उयुँ थू ओजैकिन हो ब हिताव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","है जैद जोए क्रुसत सिन्‍या मिताव दुखर सहिउ माभैंःद ङाछींत ओमाहुकिन नो ङासकाव तान्‍या स्‍यासो माले। ");
INSERT INTO kjl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जोए आव उजिउत ओललाई तान्‍या वाज़ खिम्‍ज़्याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव उजिउत उजिउए मया मादाद ङा ङाजूँनी दोज़्याव, होए जुनी दैरिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जे परमेस्‍वरए ओपाँ जेरासथैनाक जोए जेलाई ल्‍यो याचिज़्‍याव, होए ङालाई ब ल्‍यो ओयाँव मिताव ज़ लिज़्‍या। नो ङालाई वाज़ माःक, ङालाई परींज़्‍यावलाई मनी ल्‍यो ओयो मिताव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जोए अगमबक्तालाई ओय़ेन सरेस्‍द उझ़िमक ल्‍यो एज़्‍याव, नोए मनी नो अगमबक्ताए ओदैरिज़्‍याव मिताव ओल ब दैन्‍या ले। हो मिताव ज़ जोए धर्मी मिँलाई ओय़ेन सरेस्‍द उझ़िमक हुव एज़्‍याव, होए मनी नो धर्मीए ओदैरिज़्‍याव मिताव ओल ब दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ङा जेलाई साचो है ङादाचिज़्या, जोए ज़िम्‍ज़ारालाई तादी ब ङासकावर याल्‍यो लिद सरेस्‍द तुखुरी स़ोमो ऱी वाज़ ओराएदी ब नोए उइनाम जुनी ब दैन्‍या ज़ ले।” ");
INSERT INTO kjl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","येसुए बाह्र जना उसिसरालाई आव पाँ भरी है दाद ओरापरींवत ओल मनी नलाव सहर सहर, नाखार नाखार जीदा परमेस्‍वरए ओपाँ यासथैनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ऱील सछैंज़्‍याव यूहन्‍ना झ्यालखानाल उलिज़्‍याक ज़ ख्रीसए ओय़ेन भरी थैद तोबो ऩेब्‍लो उसिसरालाई येसुए ल्‍योक, ");
INSERT INTO kjl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“नो धर्मसास्‍त्रलाव सर्सिउ ‘हुरिज़्‍या’ है यालिज़्‍याव नँ ज़ रो, सैं छुतलाई कींन्‍या?” है दोनाव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","येसुए नो है यादोव थैद नोरालाई, “आव ङादोव जेरँःव जेथैव भरी यूहन्‍नालाई है दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘यामी मारैंःवरालाई सरैंःद याएज़्‍याव, माबाधुन्‍यारालाई बाधुन्‍या याजैज़्‍याव, कुऱीरालाई यासगराँज़्‍याव, यार्ना माथासोरालाई थैधुन्‍या याजैज़्‍याव, सिउरालाई याजागैज़्‍याव, गरीबरालाई ब परमेस्‍वरए ओपाँ यासथैज़्‍याव,’ है दोनाच्यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ङालाई रँःद यायुँ माकेःज़्‍यावर असिक दैवर लिज़्‍यार,” है दाद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","नोर याबाव छींनी येसुए माहोल्‍यारालाई यूहन्‍नाए उजूँनी अइ यादोक्‍यो, “जे यूहन्‍नाए ल्‍योक बनल जेबाक नोलाई किताव जेरँःया? बतासए आदा फुलुपनी होदा फुलुप ओजैज़्‍याव छी स्‍यासो ते जेमारँःखेहो। ");
INSERT INTO kjl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","हिताव ओमालिकिन किताव जेरँःया? सैं बनै चाव चाव क्‍वा क्‍वाइसिउ मिँलाई जेरँःव? निताव क्‍वा क्‍वाइसिज़्‍यावर ते दरबारल वाज़ लिज़्‍यार सानी। ");
INSERT INTO kjl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","है जैद ओल्‍योक जेबाक नोलाई किताव जेरँःया? अगमबक्ता ज़ जेरँःखेहो सानी। ङा फरी है ङादाचिज़्‍या, अगमबक्ताकिन झन घेप्‍पालाई ज़ जेरँःके। ");
INSERT INTO kjl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","नो यूहन्‍ना धर्मसास्‍त्रलाव सर्सिउ मिँ ज़। नोए उजूँनी सर्सिउ आव ज़, ‘ङाकत्‍वाल्‍यालाई नङ़ा नङ़ा परींद ङाईंज़्‍या। नजूँनी नोए नङ़ादा ज़ नयेम तयार जैदींरिज़्‍याव।’ ");
INSERT INTO kjl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","है जैद ङा जेलाई है ङादाचिज़्‍या, मिँनी जर्मिउ भरिरानी ऱील सछैंज़्‍याव यूहन्‍नाकिन घेप्‍पा सु ज़ माले। हैदी ब स्‍वर्गताव राज्‍यालाव गोइँनी ताकिन ते प़ाइँरानी ज़िम्‍ज़ा नोकिन घेप्‍पा लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","है जैद ऱील सछैंज़्‍याव यूहन्‍नाए ओरासथैहुवकिन आक पै ज़ मिँर स्‍वर्गताव राज्‍याल पसिन्‍याए जूँनी याजिउ च्‍यो च्‍यो झाःद काला मुलु छुइसिनाज़्‍यार। फरी तँदा जैसिज़्‍यावर नोलाई हारैद वैंन्‍या बनै धामा दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","मोसाए ओसरो कानुनलाव स़ोनो अगमबक्ताराए यापालाकिन यूहन्‍नाए ओपाला पैकाव यापाँव भरी ब हुज़्‍याव ख्रीसए उजूँनी ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","स़ोनो आव ब जेमातीधुरिज़्‍या, नो ख्रीसकिन ङ़ादा हुरिज़्‍या है यालिज़्‍याव एलिया ते नो यूहन्‍ना ज़। ");
INSERT INTO kjl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","येसुए फरी, “आव बेलाकाव मिँर कितावर यालिज़्‍याव लिक ते, बजार खार्ल रैःसिज़्‍याव ल़ुज़ा स्‍यासोर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","नोर यानैंरास गन्गनैद, ‘बाँसुली तप्‍द गेयाचिक ब जेमास़्‍याके, लँसिद गेयाचिक ब जेमाघर्के।’ ");
INSERT INTO kjl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","हो मिताव ज़ ऱील सछैंज़्‍याव यूहन्‍नाए ज़्यान्‍यार ओमाज़्युक, ओन्‍यार ओमाओक नोलाई ‘दैनी परिद ले’ है दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ङा मिँ मिन्‍सिद हुवए फरी ज़्‍यान्‍यार ङाज़्‍युक, ओन्‍यार ङाओक, ‘चिऊचिके, काता ज़ मानैज़्‍याव ज़्‍यास्‍ती, दाखमद्य ओए ओए बाऱिज़्‍याव, सिर्मा स्‍यो·ज़्‍याव पापीराए यानैं’ है दाँज़्‍यार। हैदी ब ङा ङागहक थ॰रिउ लिज़्‍या लिन्‍या ङाय़ेनए ज़ थ·रैज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","नकिन येसुए अचम्‍बलाव ओय़ेन सतैंद ओरायो सहरलाव मिँराए यायुँ यामाफर्कैवनी नोरालाई अइ लिद यासिङार्क्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“जे खोराजीन स़ोनो बेथसेदालावरालाई थैए माँतकन ज़ लिज़्‍या। जे जेरँःव परमेस्‍वरए ओसक्तीलाव य़ेनर तुरोस स़ोनो सीदोनलावराए यारँःव ताकिन आः झरी यापापए जूँनी यायुँ माचाव दाद बर्ला सुर्सिद धुलील च़ुसिद यायुँ फर्कैद यापापर ऱास्‍धुखेरहो। ");
INSERT INTO kjl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","है जैद परमेस्‍वरए फाल्‍न्‍या छ्याम जेकिन बुरू तुरोस स़ोनो सीदोनलावरालाई सहिधुन्‍या तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“हिताव ज़ फरी जे कफर्नहुमलाव मिँर, स्‍वर्गत केसो मितावर जेङम्सिज़्‍या, झन नर्गल ज़ बान्‍या जेले। जेल्‍योङाव अचम्‍बलाव य़ेनर सदोम सहरल सतैंद ङारायो ताकिन नो सहर आःपै रहिन्‍या ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","है जैद जेलाई है ङादाचिज़्‍या, परमेस्‍वरए फाल्‍न्‍या छ्याम जेकिन बुरू सदोमलावरालाई सहिधुन्‍या तारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","नाःत ज़ येसुए परमेस्‍वरलाई, “अ बाबु, नाम नमलावराए याङ़ैताव, नँलाई धन्‍याबाद ङाचरैःनिज़्‍या। नँ नपाँर सैंन्‍या जैसिज़्‍यावर, याबुद्धी ल्‍यो जैसिज़्‍यावरालाई सतैंद मायाद, भाउज़ा मितावरालाई सतैंद नराएके। ");
INSERT INTO kjl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हैज़ बाबु, नल्‍योदा बान्‍या येम नो ज़ चाव नथ·रैके,” है लिद पोंखारिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","नकिन येसुए, “ताव भरी ङाबाबुए ङाकुइत ज़ याद नैनाव। किताव परमेस्‍वरए वाज़ ओज़ालाई सरेस्‍ज़्‍याव, हिताव ज़ ओज़ाए वाज़ परमेस्‍वरलाई सरेस्‍ज़्‍याव। है जैद ङा छुतलाई सतैंद ङाएकिन वाज़ होए परमेस्‍वर ङाबाबुलाई सरेस्‍धुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","जे व़ीनी फुइ ताद थलिद लिज़्‍यावर, ङाल्‍योक हुद जेर्सा नैचिके, ङा जेयुँर होलाँ जैद्यान्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ङाकुम नधेंल झाःद ङास सिऊसिन्‍के। ङा ङायुँ य़ालो स़ोनो ङायुँ नाज़्‍याव ङालिज़्‍या। है जैद जे ङाल्‍योक जेहुकिन जेस॰ होलाँ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ङाकुम ब सजालो लिज़्‍या, ङागुर ब बोमो लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","हो बेलाक तछा ऩासिन्‍या छ्याम येसु उसिसरास एँः खार्लाव घ्याँ याबाज़्‍याक उसिसर याकरेए बाला फ्या·द याकैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरिसीराए निताव रँःद येसुलाई, “चिऊके, नसिसराए ऩासिन्‍या छ्याम मादान्‍या य़ेन ज़ दोज़्यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","येसुए, “धर्मसास्‍त्रलाव सर्सिउ दाऊद राजा ओनैंरास याकरेकाव यादोव य़ेन जेमाप़रिए रो? ");
INSERT INTO kjl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","दाऊद ध्‍यान झ़िमल पसिद परमेस्‍वरलाई चरैःसिउ भरेस हाइद ओनैंरास भाःद ज़्‍युकेर। नो भरेस पुजारीराए वाज़ ज़्‍यान्‍या ओताज़्‍याव, दाऊद ओनैंरास ज़्‍यान्‍या ओमाताज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","काता मोसाए ओकानुन जेमाप़रिए रो? ऩासिन्‍या छ्याम ध्‍यान झ़िमल पुजारीराए य़ेन दाद कानुनलाई बले·ज़्यार। कानुननी फरी नोराए याखत ते माले। ");
INSERT INTO kjl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ङा फरी जेलाई साचो है ङादाचिज़्‍या, ध्‍यान झ़िमकिन घेप्‍पा तोबो आक लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","जे धर्मसास्‍त्रलाव सर्सिउ ‘पाथा पल्‍द चरैःज़्यावरास माःक, यादया ल्‍योरास ङायुँ होलाँ ताज़्‍या’ परमेस्‍वरए है ओल्‍यो पाँर जेथ·रैधुव ताकिन जे ब जेदया ल्‍योर तान्‍या जेल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ङा मिँ मिन्‍सिद हुव ऩासिन्‍या छ्यामकिन ब घेप्‍पा ज़ ङालिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","येसु ननी पुलुस्‍द नोराए याधर्मसास्‍त्र झ़िमल बाके। ");
INSERT INTO kjl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","नल उकुइ थँव मिँ तोबो उलिज़्‍याव। नल लिज़्‍यावराए येसुए ओपाहा झाःद्यान्‍याए जूँनी येसुलाई, “ऩासिन्‍या छ्याम ओजोरो हुवलाई सगराँन्‍या ओताज़्‍याव सैं ओमाताज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","येसुए, “जे सुवाराए तोबो जेबेधा ऩासिन्‍या छ्याम भल्‍खादाल ओतेकिन होल ज़ जेमानैज़्‍याखेहो, जेहाइज़्‍याखेहो सानी। ");
INSERT INTO kjl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","बेधाराकिन मिँर घेप्‍पाल गनिसिउर लिज़्‍यार। है जैद ऩासिन्‍या छ्याम कानुनलाव सर्सिउ मिताव मिँए जूँनी चाव दाव परिके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","नो उकुइ थँवलाई, “नकुइ तङ्गैके,” है दोक्‍यो। नोए उकुइ ओतङ्गैव प़ाइँना तँनिकाव उकुइ स्‍यासो सोजोकाव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","नो फरिसीराए निताव रँःद लाँःदा पुलुस्‍द, ‘आवलाई कै जैद सैःन्‍या ओताव?’ लिद गुमुस्‍ता दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","येसुए नो सैःव यापैंज़्‍याव सैंद ननी हाइसिद छुतङ बाके। ओलस बावर ब बनै माहोल्‍या ज़ यालिज़्‍याव। नलाव याजोरो हुव भरिलाई ब यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","फरी नोरालाई, “आव जेक्‍याँताव ङादोव य़ेन सुलाई ज़ है तारादोच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ननी ज़ यसैया अगमबक्ताए ओसरो ब यो·के। नोए ओसरो आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“आव छाँतिद ङानैज़्‍याव ङायुँलाव ङानोकोरलाई चिऊचिके। नोलाई रँःद ङायुँ होलाँ ताज़्‍या। नोए ओक्‍याँत ज़ ङापुरूस ङानैरिज़्‍या, नोए प़ाइँ जातलाव मिँरालाई सतलाव पाँ सथैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","नो सुस ज़ इ़सिन्‍या माले, बजार जीदा ब स्‍याप स्‍याप ख्‍यान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","बुरू कान्‍ल ज़ मागनिसिउरालाई यायुँ केःद्यान्या माले, यायुँ स्‍यासे तेवरालाई ब यायुँ होलाँ जैद्यान्‍या ले। सतलाव ओय़ेन ओमासझेंःवा पै नो य़ेन दाव ज़ नैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","है जैद प़ाइँ जातलाव मिँराए होए ओक्‍याँत ज़ आस दान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","हाः बेलाक ज़ माचाव पुरूसए क्‍योःद ओनैज़्याव तोबो मिँलाई येसुए ल्‍योक रैकेर। नो मिँ उमी मारैंःव लाता उलिज़्याव। येसुए नोलाई ओसगराँवत उमी ब रैंःके, पाँधुन्‍या ब ताके। ");
INSERT INTO kjl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","नो य़ेन रँःद माहोल्‍यार अचम्‍ब ताद, “आव ज़ सा, दाऊदए ओथोलाव ‘हुरिज़्‍या’ है यालिज़्‍याव ख्रीस?” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","फरिसीराए थैद, “आव ते झन माचाव पुरूसराए याघेप्‍पा बालजिबुलए उमिननी माचाव पुरूसर पले·ज़्‍याव ची,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","येसुए नोराए यायुँलाव पाँ सैंद, “तोबो राज्‍यालाव मिँर या या यामाखैकिन राज्‍याए उमिन ज़ म़ाज़्या। हो मिताव ज़ तोबो सहरलावर तादी ब तोबो झ़िमलावर तादी ब या या यामाखैकिन चितराँ पुतराँ तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","है जैद सैतानए ओराज्‍यालावर ब या या माखैद तोबोए तोबोलाई ओपले·किन होए ओराज्‍या कातानी उरहिरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ङा बालजिबुलए उमिननी माचाव पुरूसर ङारापले·ज़्‍याव ताकिन जेसकावराए कातानी यारापले·ज़्‍याव? है जैद नो जेपाँ जेसकावराए ज़ जेङ़ैत फुलुप्‍द्यान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","खाली ङा परमेस्‍वरए उपुरूसनी ङारापले·ज़्‍याव ताकिन परमेस्‍वरए ओराज्‍या जेखार्ल ज़ हुद ले। ");
INSERT INTO kjl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","फरी तोबो ओर्सा ल्‍यो मिँलाई ङ़ादा यामाकिवा पै उझ़िम पा·द ओजा-यार हाइद मालाँधुर। ");
INSERT INTO kjl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जो ङास माखैए नो ङाकिन तँदाङाव ज़ लिज़्‍या। हिताव ज़ फरी जोए ङाल्‍योदा मारारैव, होए ङाकिन तँदा ज़ याख्‍यानाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, मिँराए जो पाप यादोदी ब, परमेस्‍वरए उमिन याबले·दी ब नोराए यापाप क्‍यालो दैसिए। खाली जोए परमेस्‍वरए छैंव उपुरूसए उमिन बले·दिज़्‍याव, होए ओपाप क्‍यालो मादैसिए। ");
INSERT INTO kjl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","हो मिताव ज़ जोए ङा मिँ मिन्‍सिद हुवए ङाङ़ैत माचाहिउ पाँर झाःद ङामिन बले·ज़्‍याव, होए ओपाप क्‍यालो दैसिए। खाली जोए परमेस्‍वरए छैंव उपुरूसए उमिन बले·द ओएकिन, नो पाप आव जुनील तादी ब अजम्‍बरी जुनील तादी ब क्‍यालो मादैसिए।” ");
INSERT INTO kjl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“गराँव सीं ताकिन ओसै ब गराँव ज़ ताज़्‍या। काना सीं ताकिन ओसै ब काना ज़ ताज़्‍या। है जैद सींलाई ओसैनी ज़ सरेस्‍सिए। ");
INSERT INTO kjl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","हिताव ज़ जे घुलए ओथोर, माचाव जेयुँनी कातानी ची चाव जेपले·धुरिज़्‍याव? युँल किताव लिज़्‍या याःनी ब हिताव ज़ हुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","चाव मिँए उयुँनी चाव वाज़ हुज़्‍या, माचाव मिँए उयुँनी माचाव वाज़ हुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ङा साचो है ङादाचिज़्‍या, मिँराए यापाँव माचाहिउ पाँ भरी तछा परमेस्‍वरए ओङ़ाक फाल्‍सिन्‍या छ्याम नो भरी थ·रैव परिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","है जैद हो छ्याम धर्मी थ॰रिन्‍या सैं पापी थ॰रिन्‍या जेसाची जेपाँ ज़ तारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","हाःत ज़ नक लिज़्‍याव सास्‍त्रीर स़ोनो फरिसीराए, “अ गुर्बा, गेलाई नसरेस तोबो सतैंद्यासिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","येसुए, “जे आव जुकलाव जेयुँ माहुबो पापीराए सरेस वाज़ जेखिम्‍ज़्‍या। खाली जेदैरिज़्‍याव सरेस ते योना अगमबक्ताए ओक्‍याँत ताव सरेस वाज़ जेदैरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","किताव योना नो घेप्‍पा ङाँःए उफूल स़ोंला स़ोंरी ओल्‍यो, हिताव ज़ ङा मिँ मिन्‍सिउ मनी नाम जींल स़ोंला स़ोंरी ङालिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","निनवे सहरलाव मिँराए योनाए ओरासथैव पाँर थैद परमेस्‍वरए ल्‍योदा यायुँ फर्कैकेर। खाली जे ते झन जेखार्ल हुद लिज़्‍याव योनाकिन घेप्‍पाए ओसथैचिक ब परमेस्‍वरए ल्‍योदा जेयुँ जेमाफर्कैके। है जैद परमेस्‍वरए मिँरालाई ओराफाल्‍रिज़्‍याव छ्याम नो ङ़ादाङाव मिँराए यायुँ याफर्कैवनी ज़ जेगल्‍ती थ॰रिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","हिताव ज़ नो दखिन देसलाव रानीए परमेस्‍वरए ओपाँ सोलोमनए ओयाःनी थैना बनै तादानी हुके। जे जेखार्ल हुद लिज़्‍याव ते सोलोमनकिन झन घेप्‍पा लिज़्या। है जैद परमेस्‍वरए ओराफाल्‍रिज़्‍याव छ्याम आव बेलाकाव मिँराए यागल्‍ती नो रानीए ओक्‍याँनी ज़ थ॰रिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“मिँनी पले·सिउ माचाव पुरूस नो मिँए ओक्‍याँनी उपुलुसोत ऱी माल्‍यो साइँसुइँवक ऩासिन्‍या पो खिम्नाज़्याव। लिन्‍या पो ओमादैकिन, ");
INSERT INTO kjl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","फरी ओल्‍द ङ़ादाङाव उपुलुसोए ओक्‍याँत ज़ पसिउ पैंज़्‍याव। नल ओबाक स्‍यासी जैद थिक थाक जैसिउ खाली पो रँःद, ");
INSERT INTO kjl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ओलकिन माचाव पुरूसर सात गोता ओलस रैद नल पसिद नो मिँलाई ङ़ादाङावकिन झन ज़ माचावए क्‍योःज़्‍याव। आज्‍यालकाव पापी मिँर ब हिताव ज़ जेतारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","येसु नो माहोल्‍यारास ओपाँज़्‍याक ज़ ओआमा स़ोनो ओभाइर हुद लाँःक च्‍याँःसिद येसुलाई क़िउ यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ननी येसुए ल्‍योक तोबो बाद, “लाँःक नआमा स़ोनो नभाइर नँस दैसिना हुद लेर,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","येसुए नो है दाना हुवलाई, “ङाआमार ङाभाइर कितावर?” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","उकुइ उसिसराए ल्‍योदा छों जैद, “चिऊके, ङाआमार ङाभाइर आवर ज़। ");
INSERT INTO kjl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","जोराए स्‍वर्गताव ङाबाबुए ओपाँ थैद दोज़्‍यार, होर ज़ ङाआमार ङाभाइ बैंनीर ताज़्‍यार,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","हो छ्याम येसु नो झ़िमनी पुलुस्‍द दह छ्योक बाद च़ुसिद उलिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ल्‍यो माल्‍यो मिँर ओल्‍योक छुइसिहुकेर। है जैद येसु दोङ्गाल च़ुसिद दोङ्गालाई ऱील छ्यावा होकसै लाँक्‍यो। माहोल्‍या भरी ओङ़ाक दह छ्योक च्याँःसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","येसुए नोरालाई ओपाँ घर्ती झाःद यासथैक्‍यो। तोबो ओरासथैव आव ज़, “तोबो मिँ ओएँःल धुर वास्‍ना बाके दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","धुर ओवास्ज़्याक ख्‍वा येम जीदा परिके दी। नो येमलाव परिउ बाज़ाराए ज़्‍युकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ख्‍वा धुर गम छ्या छ्या ल्‍यो ओदादरत परिके दी। नत गम छ्या छ्या वाज़ ल्‍यो ओतावए हतप्‍त ज़ परीके दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","खाली निमी ओसोराक उहुवत ओजरा नाम जींल ओमाल्‍योए च्‍याकराप चिकुरूप थँके दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","फरी ख्‍वा धुर ज़ुर ऱमराए खार्ल परिके दी। नोलाई ज़ुर ऱमराए गाल्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","फरी ख्‍वा धुर ते चाव गमस्‍याल परिके दी। नो ओसै बनै झाःद ख्‍वात तीस, ख्‍वात साथी, ख्‍वात सय दोबोर यासै झाःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","येसुए उसिसर ओल्‍योक हुद, “काराव मिँरालाई घर्ती झाःद वाज़ नरासथैज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","येसुए, “जेलाई वाज़ स्‍वर्गताव राज्‍यालाव कप्‍सिउ पाँर छर्लङ्ग सतैंसिउ लिज़्‍या, उपुर्कावरालाई ते म़ोंसिउ मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","है जैद जोए परमेस्‍वरए ओपाँ रैद नैव, होए झन ज़ तीधुन्‍या ले। जोए परमेस्‍वरए ओपाँ माभैंःए, होए ओरैव ब ओपो·स ज़ म़ान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","होए उजूँनी ज़ घर्ती झाःद ङारासथैज़्‍याव। नोराए रँःज़्‍यावत ब मारँःधुर, थैज़्‍यावत ब मातीधुर। ");
INSERT INTO kjl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","नितावराए जूँनी ङ़ादा ज़ यसैयाए धर्मसास्‍त्रल अइ लिद सर्द नैद यायो, ‘थैन्‍या ते जेथैज़्‍या, जेमातीधुइ। रँःन्‍या ते जेरँःज़्‍या, जेमासरेस्‍धुइ। ");
INSERT INTO kjl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","आवराए यायुँ काता ज़ मातीधुन्‍या भुत्‍यासो ताद ले। यार्ना ब सूइसिउ मिताव ताद ले। यामी ब च़िम जैद यानैज़्‍याव मिताव लिज़्‍या। निताव यामाताव ताकिन आः झरी यामीए रँःधुखेरहो, यार्नाए थैधुखेरहो, यायुँल तीधुखेरहो। ङाल्‍योदा यायुँ ते फर्कैधुखेरहो। सोजोकावर ब ङाराजैधुखेहो।’ ");
INSERT INTO kjl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","जे ते परमेस्‍वर दाइनो तावर जेलिज़्‍या, जेमीए ब जेरँःधुज़्‍या, जेर्नाए ब जेथैधुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","जेलाई साचो है ङादाचिज़्‍या, अगमबक्तार, घेप्‍पा धर्मी मिँराए ब आव जे जेरँःव पाँर रँःन्‍याए जूँनी यायुँ थू जैद ब रँःव मादैकेर, थैन्‍या युँ दाद ब थैव मादैकेर।” ");
INSERT INTO kjl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“है जैद जे नो धुर वास्‍सिउ घर्तीए ओअर्थ थैचिके। ");
INSERT INTO kjl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जोए परमेस्‍वरए ओराज्‍यालाव पाँ थैद ओमाबुझिधुकिन, सैतान ओल्‍योक हुद उयुँलाव वास्‍सिउ पाँ भरी स्‍याप सिप जैद लाँदिज़्‍याव। नो ज़ नो येमलाव परिउ धुर। ");
INSERT INTO kjl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","फरी नो ओदादरताव परिउ आव ज़, जोए परमेस्‍वरए ओपाँ थैद बेहार ज़ तीद खुसी ब ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","खाली नो मिँ परमेस्‍वरए ओपाँत उयुँल ओजरा माल्‍यो मिताव ओतावए नो पाँ छ्यावा पै वाज़ रहिज़्‍या। नो पाँनी नोए ओक्‍याँत खिरीर उपसिकिन दुखर ओदैकिन नो पाँत उयुँ क़्याज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","फरी नो ज़ुर ऱमराए खार्लाव परिउ धुर आव ज़, जोए परमेस्‍वरए ओपाँ ते थैज़्‍याव, खाली धन सम्‍पतीदा उयुँ थू जैद ‘आव ङाजिउत कै तान्‍या ओताव’ लिद व़ीनी फुइ ब लिज़्‍या। है जैद नितावराए परमेस्‍वरए ओपाँलाई यागालोए नो पाँ ओसै माझाःज़्याव ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","फरी नो चाव गमस्‍याल परिउ धुर आव ज़, जो मिँए परमेस्‍वरए ओपाँ थैद चावस उतीकिन नो मिँ परमेस्‍वरए ओराज्‍याल ख्‍वात तीस, ख्‍वात साथी, ख्‍वात सय दोबोर ओसै झाःज़्याव धुर स्‍यासो ज़ ताज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","नकिन येसुए फरी तोबो घर्ती झाःद अइ लिद यासथैक्‍यो, “स्‍वर्गताव राज्‍या किताव उलिज़्‍याव लिक ते, तोबो मिँए ओएँःल बनै चाव धुर ओवासो मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","नो ओवासोत तछा रील ओल स्‍याँद उलिज़्‍याक उसुतुर हुद ओएँःलाव ओवासो धुर खार्ल खु वास्‍द ख्‍यानैदिक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","छींनी नो धुर परीद ओबालार ओझाःवत नल खुर ब रैंःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","नो एँःए ओर्गेए ओय़ेन दाज़्‍यावर याघरपतीए ल्‍योक हुद, ‘आव नएँःल ते चाव धुर वाज़ नवास्‍ज़्‍याव सानी, आव खुर कातानी याहुव ओताव?’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","नो याघरपतीए, ‘काताकाव ङासुतुर हुद खु ओवासो ताखेहो,’ है यादोक्‍यो दी। ओय़ेन दाज़्‍यावराए फरी, ‘कै नलिज़्‍या? नो खुर गेराखुल्‍कैना रो?’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘खुल्‍कैन्‍या माःक, नोलाई जेखुल्‍कैक कसाराक तामर ब जेराखुल्‍कैया। ");
INSERT INTO kjl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","क्‍या·न्‍या बेला ओमातावा पै निताव ज़ घलिज़्‍याक, सिप सिप ज़ घमींःरक। यामींःवत क्‍या·ना बाज़्‍यावरालाई ङ़ादा खु भरी खुल्‍कैव परींद पोला पोला जैद मेंःल म़ुव ङारापरींरिज़्‍या। ताम भरिलाई ते सिम्‍द दहरा बुमल झाःव ङारापरींरिज़्‍या,’ है यादोक्‍यो दी।” ");
INSERT INTO kjl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","नकिन येसुए फरी तोबो घर्तीनी अइ लिद यासथैक्‍यो, “स्‍वर्गताव राज्‍या तोबो मिँए बाजीए उधुर बारील ओझाःव मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","नो धुर प़ाइँरानी तकेज़ा ओतादी ब, परीद ओघ्‍योःवत नो बारीलाव ङ़ैंराकिन प़ाइँरानी घेप्‍पा ताद नोए ओखारत नमताव भुर्ज़्‍याव बाज़ार सिपर जैद बासिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","“हिताव ज़ फरी स्‍वर्गताव राज्‍या भरेस सोगोइन्‍या वासः स्‍यासो ब लिज़्‍या। सोंःसेमे मुछिसिउ कनेल तोचोप झाःदी ब प़ाइँ सरालिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","येसुए माहोल्‍यारालाई ओपाँ ओरासथैक घर्ती ओमाझाःवा पै ओमारासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ननी ज़ अगमबक्ताए धर्मसास्‍त्रलाव ओसरो यो·के। नोए ओसरो आव ज़, “ङापाँ भरी घर्तीर झाःद ङारासथैरिज़्‍या। नाम नम ओतावकिनकाव कप्‍सिउ पाँर ब सतैंद्यान्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","नकिन येसुए नो माहोल्‍यारालाई ख्‍यानैद झ़िमल बाके। उसिसर ओल्‍योक हुद, “गुर्बा, नो आछ्याकाव नझाःव एँःलाव खुए ओअर्थ गेलाई पलास्‍द्याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","येसुए, “नो चाव धुर वास्‍ना बाज़्‍याव मिँ मिन्‍सिउ ख्रीस ज़। ");
INSERT INTO kjl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","एँः आव मानुवा ज़। नो चाव धुर परमेस्‍वरए ओराज्‍यालाव मिँर ज़। नो खु फरी, सैतानए उमींर ज़। ");
INSERT INTO kjl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","नो खु वास्‍ज़्‍याव उसुतुर ओल सैतान ज़। नो क्‍या·न्‍या बेला आव जुक खेम्‍न्‍या बेला ज़। नो क्‍या·ना बाज़्‍यावर परमेस्‍वरए ओचाकर्‍यार ज़। ");
INSERT INTO kjl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","किताव नो एँःए ओर्गेए खु भरी खुल्‍कैद मेंःल म़ुज़्‍याव, हिताव ज़ आव जुक ओखेमोत, ");
INSERT INTO kjl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ङा मिँ मिन्‍सिद हुवए स्‍वर्गताव ङाचाकर्‍यारालाई ङारापरींरिज़्‍या। नोराए बले·ज़्‍यावर, अधर्म दाज़्‍यावरालाई दुप्‍द परमेस्‍वरए ओराज्‍यानी पले·द, ");
INSERT INTO kjl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","मेंःए मुल्‍काल याराख्‍यारिज़्‍यार। नल याहार ङर ङर कैद चिर्लनी बिर्ल घर्न्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","धर्मी भरी ते परमेस्‍वर याबाबुए ओराज्‍याल निमी मिताव झ़ार झ़ारोर तारिज़्‍यार। आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“फरी, स्‍वर्गताव राज्‍या तोबो एँःल गादैसिउ गदान्‍त मिताव ब लिज़्‍या। नोलाई तोबो मिँए ओदैकिन नो एँःए ओएः ओमासुदुमा पै पाखात मापले·द नल ज़ नैज़्‍याव। नो बनै रेंए रेंए उझ़िमदा बाद ओलसकाव लिज़्‍याव भरी यो·द नो गदान्‍त ल्‍यो एँःलाई लँःज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“फरी, स्‍वर्गताव राज्‍या तोबो बेपारीए असली हिरामुती उखिम्‍ज़्‍याव मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","नोए बनै ओएः ल्‍यो ओदैकिन ओलसकाव लिज़्‍याव भरी यो·द तादी ब लँःज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फरी, स्‍वर्गताव राज्‍या तोबो जाल रैःसिज़्‍यावए दहल जाल ओख्‍याव मिताव लिज़्‍या। नो ओजाल ओस़ेल्‍क चाव माचाव ङाँः भरी स्‍याप सिप जैद यारैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","नो जाल दहनी ओहाइवत च़ुसिद चाव भरी ओजाल झाःद माचाव भरी याख्‍याज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","आव जुक खेम्‍न्‍या बेला ब हिताव ज़ तारिज़्‍या। परमेस्‍वरए ओचाकर्‍यार हुद धर्मीराए खार्लाव लिज़्‍याव पापीरालाई स़ेल्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","मेंःए मुल्‍काल याराख्‍यारिज़्‍यार। नल याहार ङर ङर कैद चिर्लनी बिर्ल घर्न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","नकिन येसुए उसिसरालाई, “आव ङापाँव भरी जेमातीया?” है ओरादोक ते, “गेतीके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","येसुए फरी, “चाव ताके। धर्मसास्‍त्रलाव पाँ सैंज़्‍याव सास्त्री स्‍वर्गताव राज्‍यालाव पाँर ब उसिऊसिकिन तोबो बनै धनी मिँ स्‍यासो ताज़्‍या। नोए उझ़िमनी बनै याएः ल्‍योर, साःरोर पुराँदोर पुलुस्‍न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","येसुए आव घर्तीलाव ओपाँ भरी तुपैद ननी पुलुस्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ओल ओनाखारल बाद नलाव धर्मसास्‍त्र झ़िमल ब परमेस्‍वरए ओपाँ यासथैक्‍यो। नलावर येसुए ओपाँ थैद अचम्‍ब ताद, “आवए इताव ग्‍यानर, अचम्‍बलाव सक्तीर कातानी ओरैव? ");
INSERT INTO kjl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","काता, आव नो सीं त़ुज़्‍यावए ओज़ा माःक रो? आवए ओआमा ब गेसकाव लिज़्‍याव मरियम ज़ सानी। ओभाइर ब याकूब, योसेफ, सिमोन, यहूदार ज़ सानी। ");
INSERT INTO kjl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ओबैंनीर ब गेस ज़ लिज़्‍यार सानी। नितावए इताव पाँर कातानी ओरैव ओताव?” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","जाँ सोव माँःती जैकेर। येसुए नो यापाँ सैंद, “अगमबक्तालाई ओल ओनाखारलावर स़ोनो ओक्‍याँदाङावराए वाज़ ओमान नैद माएर, उपुर्कावराए ते नैदिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","नोर येसुलाई यायुँ ओमाहुबोए नल अचम्‍बलाव ओय़ेनर कोसै मादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","हाः बेलाक राजा हेरोदए येसुए अचम्‍बलाव ओय़ेनर थैद, ");
INSERT INTO kjl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ओय़ेन दाज़्‍यावरालाई, “आव ते ऱील सछैंज़्‍याव यूहन्‍ना ची जन्‍द उहुव सा। है जैद ज़ ताखेहो नाः सक्तीलाव य़ेनर ओदोज़्‍याव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","नो हेरोदए ङ़ादा ओभाइ फिलिपए ओज्‍या हेरोदियासए ओपाँनी यूहन्‍नालाई क्‍योःद किद झ्यालखानाल झाःद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","नो यूहन्‍नाए ङ़ादा नो राजालाई, “नँ नभाइए ओज्‍यालाई रैन्‍या माताए,” है ओदोवए, ");
INSERT INTO kjl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","राजाए नोलाई सैःन्‍या युँ दाद ओनैज़्याव। खाली जनता भरिए ‘यूहन्‍ना अगमबक्ता ज़ लिज़्‍या’ लिद याथ·रैवए हेरोदए नोलाई सैःन्‍या जाँ ओछे·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","तछा राजा हेरोद उजर्मिउ मानिन्‍या छ्याम उहुवत हेरोदियासए मेंमा ओज़ा नो भत्‍यार ज़्‍युना हुवराए याङ़ाक बाद स़्याद याएक्‍यो। राजा हेरोद बनै खुसी ताद, ");
INSERT INTO kjl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","नो ल़ुज़ालाई, “नँ जो नपैंज़्‍या, हो ज़ ङायाँ” लिद किर्‍या झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","नो ल़ुज़ाए फरी, ओआमाए ओपैव मिताव ज़, “ङालाई ऱील सछैंज़्‍याव यूहन्‍नाए ओङ़ै च़म्‍द ताथील झाःद आक ज़ रैद्याँके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राजाए उयुँर स्‍यासे सतेक्‍यो। खाली ओपाहुनाराए ङ़ाकाव ओझाःव किर्‍या ओमाख्‍याधुवए, ");
INSERT INTO kjl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","झ्यालखानाल लिज़्‍याव यूहन्‍नाए ओङ़ै च़मो यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","नोर बाद यूहन्‍नाए ओङ़ै च़म्‍द ताथील झाःद नो ल़ुज़ालाई एकेर। नो ल़ुज़ाए फरी ओआमालाई लाँदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","छींनी यूहन्‍नाए उसिसराए ओमोरोलाई च़िहुद लाँद यागादैवत येसुलाई है दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","येसुए नो पाँ थैद दोङ्गाल पसिद तोबो साइँसुइँव पोक ओबातङ बाके। नो माहोल्‍यार ओबाज़्‍याव सैंद सहररानी पुलुस्‍द याखँनी ज़ दह छ्यो छ्यो ओल्‍योदा ज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","येसु दोङ्गातिन उझरिउ प़ाइँना मिँर बनै माहोल्‍या रँःद उयुँ नाद याजोरो हुवरालाई यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जाँ ऱिमदा ऱिमदा उसिसर ओल्‍योक हुद, “गे इताव साइँसुइँवक गेलिज़्‍या, नम ब नुप्नाके। आव माहोल्‍यारालाई नाखार जीदा यापरींके, ज़्‍यावर लँःद घज़्‍युरक,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","येसुए, “आवर आनी यामाबादी ब ताए। जे ज़ ज़्‍यावर याव ताके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","उसिसराए “गेस भरेस पाँच गोता, ङाँः ऩेब्‍लो वाज़ लिज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","येसुए “जेस लिज़्‍याव भरेस स़ोनो ङाँः ङालाई रैद्याँचिके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","नो माहोल्‍यारालाई बाँल च़ुसिउ परींद नो पाँच गोता भरेस ऩेब्‍लो ङाँः उकुइत रैद स्‍वर्गदा भाल्‍सिद, असिक ऩिद भरेसर केःद उसिसरालाई नो माहोल्‍यारालाई भाःद्याव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","नोर प़ाइँए याफू तसी ज़्‍युकेर। नो यासय़ेलोर यादुप्‍क बाह्र झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","नो भरेस ज़्‍युज़्‍यावर, मेंमार स़ोनो ल़ुज़ार माझाःद, खेपार वाज़ पाँच हजारा याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","हाःत ज़ येसुए उसिसरालाई दोङ्गाल पसिउ परींद दह होफत ओलकिन ङ़ादा ज़ यापरींक्‍यो। ओल येसुए ते नो माहोल्‍यारालाई याझ़िमदा याझ़िमदा ओरापरींज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","नोरालाई ओरापरींधुव छींनी ओल तोबो दाँदात बाद पोंखारिनाक्‍यो। नो बेलाक नम झ्यानाद उलिज़्‍याव, नो दाँदात ओबातङ ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","फरी उसिसर यालिज़्‍याव दोङ्गा दहल कुधु होङ ज़ केस्‍द उलिज़्‍याव। नो बेलाक ज़ बतास उसिसराए ल्‍योदा बनै चोइस हुद ऱीए ओछल्‍काए नो दोङ्गालाई आदानी होदा ओजैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","हाःत ज़ रीलाव तीन बजेवाक येसु ऱी तर्त तर्त याल्‍योदा ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","उसिसराए ऱी तर्त तर्त उहुज़्‍याव रँःद, “आव ते झ़्या ची सा!” है लिद याछ्याचेए बनै क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","हाःत ज़ येसुए, “ताछे·च्‍यो, जेयुँ होलाँ जैचिके, ङा ची,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पत्रुसए, “प्रभु, साचो नँ ज़ ताकिन, ङालाई ब ऱी तर्त तर्त नल्‍योदा हुव याँके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","येसुए, “ताए, हुन्‍के,” है ओदोव प़ाइँना पत्रुस दोङ्गातिन झरिद ऱी तर्त तर्त येसुए ल्‍योदा ओबाज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ऱीए ओछल्‍का उहुज़्‍याव रँःद छे·द ऱील गदिउ ओपैंज़्‍याक, “दे प्रभु, ङालाई जोगोइनाके,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","येसुए नोलाई उकुइनी क्‍योःद, “नँ किताव मिँ नल्‍यो, नयुँ माथ॰रिद आःपै ङालाई नयुँ ओमाहुप्‍ज़्‍याव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","नोनी दोङ्गाल निपसिउ प़ाइँना ज़ बतास ब थकनिके। ");
INSERT INTO kjl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","नो दोङ्गाल लिज़्‍यावराए फरी, “नँ साचो ज़ परमेस्‍वरए ओज़ा नल्‍यो,” लिद उखँत फुलुप्‍सिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","दह होफताव गनेसरेत यादोज़्‍याव पोङ याकेसोत, ");
INSERT INTO kjl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","नलाव लिज़्‍याव मिँराए येसुलाई सरेस्‍द नजीदाङाव याजोरो हुव भरिरालाई दुप्‍द ओल्‍योक यारारैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","नोराए, “नक्‍वाए उतुपा वाज़ छापो गेदैक,” है दाद छापो भरी ओपो·स ज़ गराँकेर। ");
INSERT INTO kjl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तछा यरूसलेम सहरनी फरिसीर स़ोनो सास्‍त्रीर येसुए ल्‍योक हुद, ");
INSERT INTO kjl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“नसिसराए काराव गेसाखा पुर्खारानी हुव चलन यामादोज़्‍याव? आवराए याकुइ माचोखोइद ज़ ज़्‍युज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","येसुए नोरालाई, “जे ते झन जेसाखा पुर्खाराए याचलननी परमेस्‍वरए ओकानुनलाई जेबले·ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","परमेस्‍वरए, ‘बाबु आमाए ओमान नैद्याव ज़ परिए,’ स़ोनो, ‘जोए ओबाबु ओआमाए उमिन बले·दिज़्‍याव, होलाई सैःव ज़ परिए’ है लिज़्या। ");
INSERT INTO kjl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","जे ते झन, ‘जोए ओबाबु ओआमानिलाई, ‘जिन ङानिकाव दैव परिन्‍या भरी परमेस्‍वरए उमिनत ची नैद ङानै,’ है उलिकिन, ");
INSERT INTO kjl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","नो मिँलाई ओबाबु ओआमानी निभार मालागिए,’ है जेलिज़्‍या। है जैद जे निताव जेय़ेननी ज़ जेचलनलाई सघ्‍योःद परमेस्‍वरए ओपाँलाई अऩाकलाव जेजैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","जे मिताव कैफतीराए जूँनी यसैयाए ङ़ादा ज़ थिक सर्द नैद्याचिउ। नोए ओसरो आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘आवराए यायाःए वाज़ ङामान नैद्याँज़्‍यार। यायुँ ते ङाकिन तादाङ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","मिँराए याससैव चलनलाई सघ्‍योःद, अऩाकल ज़ ङासेवा दोज़्‍यार,’ ” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","नकिन येसुए नक लिज़्‍याव माहोल्‍यारालाई ओल्‍योदा खुल्‍द, “आव ङापाँ चावस थ·रैच्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","पाखानी याःल पसिज़्‍यावए मिँलाई माछैंव माजैव। मिँलाई माछैंव जैज़्‍याव ते याःनी पुलुस्‍ज़्यावए ची,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","उसिसराए नो ओपाँ थैद येसुलाई, “प्रभु, आव नपाँए फरिसीराए यायुँ कोला कोला जैद नरायो नमासैंए रो?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","येसुए, “स्‍वर्गताव ङाबाबुए ओमारारूपिउ भरी तछा भोस्‍रिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","हैज़ घताज़्‍यारक, नोर तोबो उमी मारैंःवए उमी मारैंःवलाई दोरैद ओलाँज़्‍याव मितावर लिज़्‍यार। नितावनी दोरैसिद निबाक ऩेब्‍लो ज़ भल्‍खादाल तेन्‍या लिनी,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","हाःत ज़ पत्रुसए फरी, “ङ़ादाङाव नपाँए ओअर्थ गेलाई पलास्‍द्याव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","येसुए, “जे किताव मिँर जेल्‍यो, आःपै ङापाँ जेमातीधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","जो ज़्‍याव ज़्‍युदी ब नो ज़्‍याव अइज़ फूल पसिद छींनी पुलुस्‍द बाज़्‍या लिन्‍या जेमासैंए रो? ");
INSERT INTO kjl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","मिँलाई बले·ज़्याव ते युँल सिर्जैद याःनी पुलुस्‍ज़्‍याव पाँए ची। ");
INSERT INTO kjl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","युँलाव माचाहिउ पाँर आवर ज़ — माचाव चेतैन्‍या, मिँ सैःन्‍या, अर्काए ओज्‍याए ल्‍योदा बान्‍या, पातर्‍या पातर्नी जैसिन्‍या, कुन्‍या, धुत गोहाई यान्‍या, अर्काए उमिन बले·द्यान्‍या, ");
INSERT INTO kjl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","आवर ज़ मिँलाई बले·न्‍या पाँर। निताव कुइ माचोखोइद ज़्‍यान्‍याए काता ज़ माबले·व।” ");
INSERT INTO kjl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","येसु ननी पुलुस्‍द तुरोस सीदोन जीदा बाके। ");
INSERT INTO kjl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","नलाव तोबो कनानी मेंमा येसुए ल्‍योक हुद, “अ प्रभु, दाऊदए ओथोलाव येसु, ङाल्‍योदा नयुँ ओनाक। मेंमा ङाज़ालाई माचाव पुरूसए क्‍योःद बनै हत्‍या याद नैव,” है लिद उक़िक, ");
INSERT INTO kjl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","येसुए घाइ ज़ मादोक्‍यो। उसिसराए फरी, “आव मेंमा बनै झ्याउँ झ्याउँ लिज़्‍या, हतप्‍त ज़ पले·के,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","येसुए नो मेंमालाई, “ङा इस्राएली जातलाव म़ाव ङोइव बेधा स्‍यासोराए जूँनी वाज़ ङाहुव ची,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","नो मेंमाए येसुए उखँत फुलुप्‍सिद, “जेरो ङाप्रभु, ङाल्‍योदा नयुँ ओनाक,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","येसुए फरी, “ल़ुज़ाराए याज़्‍युज़्‍याव ज़्‍याव नैंद काःरालाई यान्‍या माताए,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","नो मेंमाए, “हैज़ प्रभु, हैदी ब यार्गेराए तेबलतिन यासतेव ज़्‍याव काःराए मनी ज़्‍याव दैर सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","येसुए, “अ माँ, नँ बनै नयुँ हुबो मेंमा नल्यो। है नल्‍यो भरी यो·न्‍या ले,” है ओदोव प़ाइँना होङ ओज़ा ओगराँधुव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","येसु ननी पुलुस्‍द गालील दहलाव घ्याँ बाद तोबो दाँदात पुलुस्‍द च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","नत च़ुसिद उलिज़्‍याक नजीलाव माहोल्‍याराए काना दूँदार, लुला लङरार, लाता भैरार, याजोरो हुवरालाई ब येसुए ल्‍योक रैद ओङ़ाक यारानैकेर। येसुए नो भरिलाई ओपो·स ज़ यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","नो माहोल्‍याराए निताव मापाँधुन्‍यार पाँधुन्‍या याताव, यामी मारैंःवर रँःधुन्‍या याताव, माबाधुन्‍यार बाधुन्‍या याताव रँःद नोर बनै अचम्‍ब ताद इस्राएलीराए यापरमेस्‍वरलाई बनै घ्‍योःव ज़ थ·रैद उमिन ब सघ्‍योःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","नकिन येसुए उसिसरालाई ओल्‍योदा खुल्‍द, “आव माहोल्‍यार रँःद ङायुँ नाज़्‍या। आवर ङास याल्‍यो आछिम स़ोंला ताकेर। याज़्‍याव भरी ब खेम्‍के। आवरालाई करे ज़ परींन्‍या ङायुँए माभैंःए, अइज़ परींकिन येमत याकरेए माधुन्‍या लेर,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","उसिसराए, “इताव साइँसुइँवक आःकाव माहोल्‍यारालाई गे कातानी ज़्‍यावर रैद सव़ाँन्‍या की?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","येसुए, “जेस भरेस खागोता उलिज़्‍याव?” है ओरादोक ते, “भरेस सात गोता, ङाँःजुँर ऩेबरेंवा लिज़्‍यार,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","नकिन येसुए नो माहोल्‍यारालाई नामक च़ुसिउ परींद, ");
INSERT INTO kjl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","नो सात गोता भरेस स़ोनो ङाँःजुँर उकुइत रैद धन्‍याबाद चरैःद नो भरेसलाई केःद उसिसरालाई नो माहोल्‍यारालाई भाःद्याव ओरापरींक ते, भाःद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","नोर प़ाइँए याफू तसी ज़्‍याद यासय़ेलो यादुप्‍क सात झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","नो ज़्‍युज़्‍यावर, मेंमार स़ोनो ल़ुज़ार माझाःद, खेपा भरी वाज़ चार हजारा याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","नकिन नो माहोल्‍यारालाई याझ़िमदा याझ़िमदा परींद येसु दोङ्गाल पसिद मगादान खन्‍द जीदा बाके। ");
INSERT INTO kjl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","नल फरिसीर स़ोनो सदुकीराए येसुलाई जाँचिन्‍याए जूँनी ओल्‍योक हुद, “गेलाई स्‍वर्गताव नसरेस तोबो सतैंद्याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","येसुए, “जे ऱिमदा नम घाव जेरँःकिन ‘पराःती बेल्‍न्‍या ले’ है लिन्‍या जेसैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","छकाल्‍न्‍या नम घाव जेरँःकिन ‘आछिम नम वान्‍या ले’ लिन्‍या ब जेसैंज़्‍या। है जैद जे निताव नमताव सरेसर थ·रैधुज़्‍यावराए कै जैद बेलाए ओसरेसर ताकितर जेमाथ·रैधुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","आव जुकलाव यायुँ माहुबो पापीराए सरेस वाज़ खिम्‍ज़्‍यार। खाली यादैरिज़्याव सरेस ते योनाए ओक्‍याँत ताव सरेस वाज़ दैरिज़्यार,” है दाद याख्‍यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","नकिन येसु उसिसरास दह होफत याबाक उसिसराए यास भरेस लाँन्‍या यामेंःव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","नक याकेसोत येसुए उसिसरालाई, “जे फरिसीर स़ोनो सदुकीराए भरेसल याझाःज़्याव वासःनी जोगोइसिद लिच्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","नोराए या याल, “भरेस रैन्‍या गेमेंःवए नै ओदासिज़्‍याव ताक्‍या,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","येसुए थैद, “ए जेयुँ माहुबोर, काराव जे ङापाँलाई झन भरेस त॰दा जेथ·रैनाज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","आःपै जेमातीधुइ रो? पाँच गोता भरेसए पाँच हजारए याफू तसी ज़्‍यादकाव यासय़ेलो कुधु झुर्नु ओताव माःक रो? काता घरी जेमेंःधुव। ");
INSERT INTO kjl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","स़ोनो सात गोता भरेसए चार हजार मिँए याफू तसी ज़्‍यादकाव यासय़ेलो कुधु झुर्नु ओताव माःक रो? ");
INSERT INTO kjl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","कै जैद जेमाबुझिधुज़्याव? ङा ते भरेसए जूँनी ङापाँव माःक। फरिसीर स़ोनो सदुकीराए जूँनी ङापाँव ची,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","बल्‍ल, “भरेसए जूँनी ते माःक ची ओल्‍यो, फरिसीर स़ोनो सदुकीराए यापाँनी जोगोइसिद लिच्‍यो है ओदासिउ ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","नकिन येसु कैसरिया फिलिप्‍पी खन्‍द जीदा ओबावत उसिसरालाई, “ङा मिँ मिन्‍सिद हुवलाई मिँराए सु है दाँज़्‍यार?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","उसिसराए, “ख्‍वाराए ऱील सछैंज़्‍याव यूहन्‍ना है दींज़्‍यार, ख्‍वाराए एलिया है दींज़्‍यार, ख्‍वाराए फरी यर्मिया ताक्‍या, सैं काताकाव अगमबक्ता ताक्‍या है दींज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","येसुए, “जे ङालाई सु है जेदाँज़्‍या नी?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सिमोन पत्रुसए, “नँ जींदो परमेस्‍वरए ओज़ा ख्रीस ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","येसुए नो थैद पत्रुसलाई, “धन्‍याकाव, योनाए ओज़ा सिमोन पत्रुस, नल्‍योदा परमेस्‍वर दाइनो ताव। आव पाँ मिँए बुद्धीनी नथ·रैव माःक, स्‍वर्गताव ङाबाबुनी नथ·रैव ची। ");
INSERT INTO kjl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","है जैद ङा नमिन पत्रुस जैद ङाईंज़्‍या। नो पहर तर्त ज़ ङामन्‍दली ङाजैरिज़्या, स़ोनो नर्गलाव सक्तीराए नोलाई पल्‍तैधुन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","स्‍वर्गताव राज्‍यालाव साँचार ब नँलाई ङाईंरिज़्‍या। है जैद नँ आव मानुवात जो नथ·रैज़्‍या, स्‍वर्गत ब हो ज़ थ॰रिन्‍या ले। फरी, आव मानुवात जो य़ेन मादान्‍या नथ·रैज़्‍या, स्‍वर्गत मनी हिताव ज़ थ॰रिन्‍या ले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","नकिन उसिस भरिरालाई, “ङा ख्रीस ज़ लिद सुलाई ज़ है तारादोच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","हो बेलाकिन ज़ येसुए यरूसलेमल ओक्‍याँत हुरिज़्‍याव दुखर उसिसरालाई है यादोनाक्‍यो। “ङा यरूसलेमल ङाकेसोत गेदेसलाव स़ेरर, मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ल्‍योनी बनै धो सहिउ दुखर ङादैरिज़्‍या। नोराए यासैःनाव स़ोंलात सिउनी सैंसिद ङासोरिज़्‍या,” लिद उसिसरालाई है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पत्रुसए येसुलाई तँदा लाँद सिङार्द, “प्रभु, परमेस्‍वरए निताव ताव तायोक, नक्‍याँत निताव खर्क ज़ ताताक,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","येसु पत्रुसए ल्‍योदा भाल्‍सिद, “ए सैतान, ङाङ़ाकिन पुलुस्‍निके। नँ ते ङालाई परमेस्‍वरए ओय़ेनत ङायुँ केःद्यान्‍या ची नपैंके। नँ नयुँ परमेस्‍वरए ल्‍योदा माझाःद मिँराए याझाःज़्‍यावदा ची नझाःके,” है दोक्यो। ");
INSERT INTO kjl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","उसिस भरिरालाई येसुए, “जोए ङास हुन्‍या युँ दोज़्‍याव, होए उजिउए मया मादाद क्रुसत सिन्‍या मिताव दुखर सहिद ङाछींत उहुक। ");
INSERT INTO kjl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","जोए आव उजिउत ओललाई तान्‍या वाज़ खिम्‍ज़्याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव उजिउत उजिउए मया मादाद ङा ङाजूँनी दोज़्याव, होए जुनी दैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","जोए आव मानुवात लिज़्‍याव भरी दुप्‍द उजुनीलाई ओसम़ैकिन नोलाई काता फाइदा ची तायादा? नोए उजुनीए ओपोल काता यान्‍या? ");
INSERT INTO kjl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ङा मिँ मिन्‍सिउ तछा स्‍वर्गताव ङाबाबुए ओज़गै मगैरास ओचाकर्‍यारास आव मानुवात फरी तखेप हुद मिँराए यादोव याय़ेनए ओजेला ङाराएरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ङा जेलाई साचो है ङादाचिज़्‍या, आकाव च्‍याँःसिद लिज़्‍यावरानी जे ख्‍वा ख्‍वाराए ङा मिँ मिन्‍सिउलाई ङाराज्‍यास ङाहुज़्याव जेमारँःवा पै सिन्‍या जेमाले,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","नकिन छ दिनत येसुए पत्रुस, याकूब स़ोनो होए ओभाइ यूहन्‍नारालाई याबातङ तोबो झेंःव गोंत ओलस यालाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","नक याकेसोत येसुए ओक्‍याँर त़ोसिद, ओङाःर ब निमी स्‍यासो झ़ार झ़ारो ताके, ओक्‍वार ब तक तकौ मी झीःन्‍या ताके। ");
INSERT INTO kjl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","नाःत ज़ मोसा स़ोनो एलियानी नक ज़ सरैंःसिद येसुस पाँकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","नो रँःद पत्रुसए येसुलाई, “अ प्रभु, गे आक लिन्‍या बनै चाव लिज़्‍या। नयुँ ओताकिन, ङा जेलाई स़ोम्‍लो पाल तङ्गैद ङायाच्‍यो, तोबो नँलाई, तोबो मोसालाई, तोबो एलियालाई,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ओपाँज़्‍याक ज़ तोबो बनै धोइ धोइव बादल हुद नोरालाई याकप्‍क्‍यो। नो बादल जींनी तोबो गा अइ लिद थास्‍के, “आव ङायुँलाव ङाज़ा ज़, आवलाई रँःद ङायुँ होलाँ ताज़्‍या। जे आवए ओपाँ थैच्‍यो,” ");
INSERT INTO kjl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","है उलिज़्‍याव नो स़ोम्‍लोए थैद नोर याछ्याचेए फुलुपसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","हाःत ज़ येसु हुद नोरालाई छाप्‍द, “सोचिके, ताछे·च्‍यो,” है ओरादोवत, ");
INSERT INTO kjl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","आदा होदा याभाल्‍सिक येसुलाई वाज़ रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","नो गोंतिन याझरिज़्‍याक येसुए नोरालाई “आव जेरँःव भरी ङा मिँ मिन्‍सिउ सिद ङामासैंसिवा पै सुलाई ज़ है तारादोच्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","नो स़ोम्‍लोए, “सास्‍त्रीराए काराव ख्रीसकिन ङ़ादा एलिया हुन्‍या ले है यालिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","येसुए, “हैज़, एलिया ङ़ादा ज़ हुद प़ाइँलाई ताव परिन्‍या मिताव जैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","खाली ङा जेलाई आव मनी है ङादाचिज़्या, एलिया ते ङ़ादा ज़ हुधुके। आलाव मिँराए झन नोलाई मासरेस्‍द यामन लागिउ ज़ जैकेर। हिताव ज़ ङा मिँ मिन्‍सिउलाई मनी दुखर याद सैःनारिज़्यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","हाःत ज़ नो स़ोम्‍लोए एलियाए ओय़ेन ऱील सछैंज़्‍याव यूहन्‍नाए ओक्‍याँत ची ओताव ओल्‍यो लिन्‍या थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","येसु नो स़ोम्‍लोरास नो गोंतिन झरिद माहोल्‍याराए ल्‍योक याबाक ननी तोबो हुद येसुए उखँत फुलुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“अ प्रभु, ङाज़ालाई नयुँ ओनाक, नोलाई पुल्‍न्‍या बेथाए क्योःद बनै दुख याद नैव। कैताक मेंःल ब परिज़्या, कैताक ऱील ब परिज़्या। ");
INSERT INTO kjl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","नोलाई नसिसराए ल्‍योक ङारैक सगराँद मायाँधुकेर,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","येसुए, “ए जेयुँ माहुबोर, परमेस्‍वरस माखैवर, ङा जेस खा ची ङालिरिज़्‍याव, खा ङासहिचिके!” है दाद नो छोर्‍याए ओबाबुलाई, “नज़ालाई आदा रैके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","नो माचाव पुरूसलाई ओहप्कैव प़ाइँना ओक्‍याँतिन पुलुस्‍द बाके। नो छोर्‍या ब हो प़ाइँना ज़ गराँके। ");
INSERT INTO kjl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","नकिन जाँ छ्यावाक उसिसराए येसुलाई सुए ज़ यामासैंद, “गे कै जैद नो माचाव पुरूसलाई गेमापले·धुव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","येसुए, “परमेस्‍वरए ओल्‍योदा जेयुँ ओमाहुबोए ज़ जेमापले·धुव। ङा जेलाई साचो है ङादाचिज़्‍या, परमेस्‍वरए ओल्‍योदा बाजीए ओसै हावालिउ तादी ब जेयुँ जेसुहुप्‍किनी तोबो हाँलाई ‘भोस्‍निके’ है जेदोकिन भोस्‍न्‍या ज़ ले। है जैद जे मादाधुन्‍या काता ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","हैदी ब इताव पुरूसलाई पले·न्‍या ते उपासिद मापोंखारिवा पै मापले·सिधुइ।” ");
INSERT INTO kjl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","छींनी तछा येसु उसिसरास गालीलल यादुप्‍सिक उसिसरालाई, “ङा मिँ मिन्‍सिउलाई तछा मिँराए याकुइत सूँपिनारिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","नोराए ङालाई सैःनारिज़्‍यार। हैदी ब स़ोंलात परमेस्‍वरए सोचोइनारिज़्‍याव,” है यादोक्‍यो। नो थैद उसिसराए यायुँ माचाव जैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","छींनी कफर्नहुमल याबावत ध्‍यान झ़िमलाव सिर्मा स्‍यो·ज़्‍यावर हुद पत्रुसलाई, “जेगुर्बाए ध्‍यान झ़िमलाव सिर्मा ओफो·ज़्‍याव सैं ओमाफो·ज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“फो·ज़्‍याव ज़,” है दाद पत्रुस झ़िमल उपसिउत येसुए, “अ सिमोन, नँ कै नलिज़्‍या? आव मानुवाताव राजाराए सिर्मा स़ोनो दोरो सुरालाई याराहाइज़्‍याव? याझ़िमलावरालाई सैं छुतङावरालाई?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","सिमोनए, “छुतङावरालाई,” है दोक्‍यो। येसुए, “हो ताकिन ते गे नो झ़िमलावराए ते माफो·व परिन्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","हैदी ब नोरालाई सभैंःन्‍याए जूँनी बल्‍छी लाँद दहल रैःसिनान्‍केदा, प़ाइँरानी उस॰कताव नहाइव ङाँःए ओयाः नफैक गिन फो·न्‍या चाँदीए सिक्‍का नोए ओयाःल दैन्‍या नले। हो ज़ लाँद गिनजूँनी फो·नायो।” ");
INSERT INTO kjl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","हो बेलाक ज़ येसुए उसिसर ओल्‍योक हुद, “स्‍वर्गताव राज्‍याल प़ाइँरानी घेप्‍पा सु गेलिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","येसुए तोबो ज़िम्‍ज़ा ल़ुज़ालाई रैद याङ़ाक सच्‍याँद, ");
INSERT INTO kjl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“जेलाई साचो है ङादाचिज़्‍या, जे जेयुँर त़ोद ल़ुज़ा मिताव जेमातावा पै स्‍वर्गताव राज्‍याल पसिउ दैन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जो आव ल़ुज़ा मिताव मासघ्‍योःसिद सज़िम्‍सिज़्‍या, हो ज़ स्‍वर्गताव राज्‍याल घेप्‍पा ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","फरी जोए ङामिनत आव मिताव ज़िम्ज़ारालाई यासुम्‍ज़्‍याव, होए ङालाई ब सुम्‍नाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","फरी जोए आव मिताव ङालाई यायुँ हुबो ज़िम्‍ज़ारालाई पापल ओरापारैकिन, नितावलाई ते बुरू ओधेंल राँथै सुर्द्याद समुन्‍द्रल ख्‍यान्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","पापल पारैज़्‍याव पाँराए जूँनी आव मानुवालाई थैए माँतकन ज़ लिज़्‍या। निताव पाँर ते जुनी ब हुन्‍या ज़ लेर, खाली निताव पाँर पले·ज़्यावलाई थैए माँतकन ज़ लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“नखँए तादी ब नकुइए तादी ब माचावल ओपारैनिकिन च़म्‍द ख्‍याके। नो नखँ नकुइए माजिप्‍तिन्‍या मेंःल ख्‍याव ओदोज़्‍याव देखा बुरू अजम्‍बरी जुनील थूँद्यासो पसिन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","हो मिताव ज़ नमीए माचावल ओपारैनिकिन, नो नमीलाई कोला·द ख्‍याके। नो नमीए नर्गलाव मेंःल ख्‍याव ओदोज़्‍याव देखा बुरू परमेस्‍वरए ओराज्‍याल काना ताद पसिन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","है जैद जे आव मिताव ज़िम्‍ज़ारालाई सुए ज़ तारासोच्‍यो। नोरालाई समारिज़्‍याव परमेस्‍वरए ओचाकर्‍यार एकतार ज़ स्‍वर्गताव परमेस्‍वर ङाबाबुए ओङ़ाक ज़ लिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“है जैद ङा मिँ मिन्‍सिद हुवए म़ाव ङोइवरालाई साप्‍द परमेस्‍वरए ल्‍योदा लाँन्‍याए जूँनी ङाहुव ज़। ");
INSERT INTO kjl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","जे कै जेलिज़्‍या? तोबोए ओबेधार तसय यालिकिन ननी तोबो फातिद ओङोइकिन नो उनान्‍सयरालाई बनल ज़ ख्‍यानैद नो ङोइवलाई खिम्‍नाज़्‍याखेहो सानी। ");
INSERT INTO kjl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ङा साचो है ङादाचिज़्‍या, नोलाई ओदैकिन नो माङोइव उनान्‍सयराकिन नो तोबोए ल्‍योदा झन उयुँ होलाँ ताद रेंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","हो मिताव ज़ स्‍वर्गताव जेबाबुए ब इताव ज़िम्‍ज़ा तादी ब ‘तँदा बाद ताङोइक’ लिद उयुँ थू जैज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“तोबो ननैंए मादान्‍या ओदोज़्‍याव नरँःकिन ङ़ादा नोलाई अलगज़ा ओखत सतैंदियो। नोए नपाँ थैद ओभैंःकिन नोलाई नबाँचैव मिताव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","फरी नोए नपाँ थैव ओमाभैंःकिन छुतर ब तोबो ऩेब्‍लो बाद सम्‍जैव ताके। धर्मसास्‍त्रल ब नोए उजूँनी इताव सर्सिउ लिज़्‍या, ‘छुतए ओङ़ैताव पाँ ऩेब्‍लो स़ोम्‍लोए यासाची ओखैकिन नो पाँ ज़ थ॰रिउ ताज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","नोए नोराए यापाँ ब ओमाभैंःकिन नोलाई परमेस्‍वरए उमिनताव भरिराए ङ़ाक ज़ है दाव ताके। नोराए यापाँ ब ओमाभैंःकिन नो मिँलाई परमेस्‍वरकिन तँदाङावरासकाव स़ोनो सिर्मा स्‍यो·ज़्यावरासकाव गनिउ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, जे आव मानुवात जो जेथ·रैज़्‍या, स्‍वर्गत ब हो ज़ थ॰रिन्‍या ले। फरी, आव मानुवात जो य़ेन मादान्‍या जेथ·रैज़्‍या, स्‍वर्गत मनी हिताव ज़ थ॰रिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","फरी ङा जेलाई है ङादाचिज़्या, आव मानुवात ऩेब्‍लोए वाज़ तयुँ जैद काताराए जूँनी जेपोंखारिकिन, नो जेपाँ स्‍वर्गताव ङाबाबुए सयो·द्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","है जैद जोक तादी ब ङामिनत ऩेब्‍लोकिन यादा जेदुप्‍सिकिन ङा ब जेस ज़ ङातारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","नकिन पत्रुस येसुए ल्‍योक बाद, “प्रभु, तोबोए ङाउपर्त मादान्‍या ओदोकिन, नोलाई ङा खापाला ऱास्‍न्‍या, सात पाला सैं खापाला?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","येसुए, “ङा नँलाई सात पाला वाज़ है ङामादींए। नोकिन झन सत्तरी दोबोर सात पाला ऱासो ताके है ङादींज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“है जैद स्‍वर्गताव राज्‍या तोबो राजाए ओनोकोररास हिसाप ओसखैज़्‍याव मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","नो राजाए निताव हिसाप ओसखैज़्‍याक तोबोए ओलाँव दस हजार सुनए सिक्‍कालाव तुम्‍सुक पुलुस्‍के दी। नोए उरिन ओमाफो·धुवए राजाए ओय़ेन दाज़्‍यावराए ओललाई ज़ राजाए ल्‍योक रैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","राजाए नोरालाई, ‘आवलाई ओज्‍या ओज़ारास स़ोनो ओलसकाव लिज़्‍याव भरी यो·द तादी ब जुनी ब सयो·द रैचिके,’ है यादोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","नो नोकोरए आव थैद राजाए उखँत फुलुप्‍सिद, ‘जेरो प्रभु, ङालाई नयुँ ओनाक, छ्यावा पै कींनाके। तछा जुनी ब ङाफो·या ज़,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","नो राजाए उयुँ नाद उतुम्‍सुक चीद्याद अइज़ ऱास्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","नो नोकोर ते झन ननी पुलुस्‍द बाद, ओलस य़ेन दाज़्याव तोबो ओनैंए ल्‍योक तसय चाँदीए सिक्‍का ओकाछ थाँनाक्‍यो दी। नोलाई ओधेंनी क्‍योःद, ‘ङाकाछ नमाफो·रिज़्‍या?’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","नो ओनैं उखँत फुलुप्‍सिद, ‘जेरो ङानैं, ङालाई नयुँ ओनाक। छ्यावा पै कींनाके, तछा प़ाइँ ज़ ङायाँ,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","माभैंःद, ‘हुकी नमासयो·वा पै झ्यालखानाल ल्‍यो ताके’ लिद झ्यालखानाल झाःक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“ओनैंलाई नै ओजैव राजाए ओय़ेन दाज़्‍यावराए रँःद यायुँ बनै नाद राजाए ल्‍योक पैंनाकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","नो पाँ थैद राजाए नो ओऱासो नोकोरलाई खुल्‍द, ‘ए हरामी, नँ ङास बिन्‍ती नदोक नङ़ैताव रिन भरी ख्‍याद ङाईंके। ");
INSERT INTO kjl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ङा किताव नँलाई ङायुँ नाद ङाऱास्‍निउ, नँ कै जैद नो नँस य़ेन दोज़्याव ननैंलाई नयुँ नाद नमाऱासो?’ है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","नो राजा रसिद ओऱासो रिन भरी फरी ब सुघुर्द प़ाइँ ओमाफो·वा पै झ्यालखानालाव हाकिमए उकुइत सूँपिक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, हो मिताव ज़ स्‍वर्गताव ङाबाबुए मनी जे जेउपर्त मादान्‍या दोज़्‍यावलाई जेयुँल नैद जेमाऱास्‍किन जेलाई मनी हिताव ज़ जैचिरिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","येसुए आव पाँर ओरासथैवत गालीलनी पुलुस्‍द यर्दन भै होफताव यहूदिया खन्‍दल बाके। ");
INSERT INTO kjl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","नल ब मिँर बनै माहोल्‍या ओल्‍योक याहुज़्‍याव। नो हुवरानी याजोरो हुवरालाई यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","फरिसीराए येसुलाई जाँचिन्‍याए जूँनी ओल्‍योक हुद, “जुनी तादी ब ज्‍यालाई ऱासो दैसिए सैं मादैसिए?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","येसुए, “भाःङ स्रिस्‍तील परमेस्‍वरए मिँ ओजैक खेपा स़ोनो मेंमानी निजैक्‍यो लिन्‍या प़रिद जेमाले? ");
INSERT INTO kjl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","है जैद ज़ खेपाए ओबाबु ओआमालाई ऱास्‍द ओज्‍यास सिप ताद, नोनी तक्‍याँ ज़ ताज़्‍यानी। ");
INSERT INTO kjl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","हाःकिन नोनी ऩेब्‍लो माःक, तक्‍याँल गनिसिज़्‍यानी। है जैद जोनिलाई परमेस्‍वरए जोरैद निनैव, होनिलाई मिँराए ताराभाःरक,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","नोराए फरी, “हिताव ताकिन कै जैद मोसाए ओकानुनल ऱास्‍न्‍या कागत तोबो सर्किन ऱासो दैसिए लिन्‍या सर्सिउ उलिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","येसुए, “जेदिउदी ल्‍योर जेतावए ज़ मोसाए निताव कानुन ओरायो, म़ानी ङ़ादाकिन ते हिताव ओमाल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","है जैद ङा जेलाई है ङादाचिज़्‍या, जोए ओज्‍या ओरेए ओसतत उलिज़्‍यावत ब नो ओज्‍यालाई ऱास्‍द छुतलाई ओरैकिन नोए जारी य़ेन ज़ दोक्‍यो। फरी जोए नो ऱास्‍सिउ मेंमालाई रैज़्‍याव, होए मनी जारी य़ेन ज़ दोक्यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","हाःत ज़ उसिसराए, “निताव ज्‍यालाई ऱास्‍क पाप गेदोव उथ॰रिकिन बुरू ज्‍या मादान्‍या पाथ लिज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","येसुए, “बिनु ज्‍या, बिनु रे प़ाइँ ते मालिधुर। परमेस्‍वरए जोलाई बिनु ज्‍या, बिनु रे लिधुन्‍या जैद नैव हो वाज़ लिधुइ। ");
INSERT INTO kjl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ख्‍वार जर्मननी ज़ सिङारू ताज़्‍यार, ख्‍वार फरी मिँराए सिङारू याराजैवए ज्‍या मादोर, ख्‍वार फरी या याखुसीनी ज़ स्‍वर्गताव राज्‍यालाव य़ेन दान्‍याए जूँनी ज्‍या मादोर। खाली निताव य़ेन ते जोए सहिधुज़्‍याव, होए वाज़ ओदोवक।” ");
INSERT INTO kjl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","नकिन नलाव मिँराए ज़िम्‍ज़ा याज़ारालाई ‘येसुए उकुइ नैद असिक घरायोक’ लिद ओल्‍योक यारारैकेर। नो रैज़्‍यावरालाई उसिसराए सिङार्द यारावैंकेर। ");
INSERT INTO kjl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","येसुए निताव रँःद उसिसरालाई, “नो ज़िम्‍ज़ा ल़ुज़ारालाई तारावैंच्‍यो, ङाल्‍योदा हुव याराएचिके। स्‍वर्गताव राज्‍या नितावराए जूँनी ज़ लिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","नो ल़ुज़ाराए याक्‍याँत उकुइ नैद असिक याद येसु ननी पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","येसुए ल्‍योक तोबो धापाज़ाकाव मिँ हुद, “अ गुर्बा, ङा अजम्‍बरी जुनी दैन्‍याए जूँनी चाव य़ेन किताव दान्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","येसुए, “ङालाई काराव ‘किताव चाव उलिज़्‍याव’ है नदाँज़्‍याव? चाव तोबोका तोबो परमेस्‍वर वाज़ लिज़्‍या। नँ अजम्‍बरी जुनील बान्‍या युँ नदोकिन नो धर्मसास्‍त्रलाव सर्सिउ दान्‍या मादान्‍या य़ेन दाव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“प्रभु, नो भरिनी ङा काताकाव दान्‍या?” है ओदोक ते, येसुए, “मिँ मासैःन्‍या, अर्काए ओज्‍याए ल्‍योदा माबान्‍या, माकुन्‍या, धुत गोहाई मायान्‍या, ");
INSERT INTO kjl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","बाबु आमाए ओमान नैद्यान्‍या, स़ोनो नक्‍याँलाई किताव नसमारिज़्‍या, छुतलाई ब हिताव ज़ समारिन्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","नोए नो पाँर थैद, “आव भरी ते दाव ज़ ङानैज़्‍या, फरी मायो·व काताकाव उलिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","येसुए “नँ साचो सयो·न्‍या ताकिन नँस लिज़्‍याव भरी यो·द काता ज़ माल्‍योरालाई भाःद याएकेदा, नँ स्‍वर्गताव धन दैन्‍या नले। नो य़ेन भरी दाद नँ ङाछींत हुन्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","नो धापाज़ाकावए नो पाँ थैद उयुँर स्‍यासे सतेद ओल्‍द बाके। नोए ओधन सम्‍पती बनै कुधु ज़ ओल्‍योए माऱास्‍धुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","नो ओबावत येसुए उसिसरालाई, “ङा जेलाई साचो है ङादाचिज़्‍या, धनी मिँ स्‍वर्गताव राज्‍याल पसिन्‍या बनै धो ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","फरी ब ङा जेलाई है ङादाचिज़्या, गपए उकुँल ऊँत उछिरिज़्‍यावकिन धनी मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या झन धो ताज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","उसिसर आव पाँत अचम्‍ब ताद, “इताव ताकिन ते सुए ची अजम्‍बरी जुनी ओदैधुरिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","येसुए, “मिँर यानी सु ज़ माबाँचिधुर, खाली परमेस्‍वरनी मातान्‍या काता ज़ माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","हाःत ज़ पत्रुसए, “गे ते प़ाइँ ज़ ख्‍यानैद नछींत हुद गेले, गे काता दैन्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, आव जुक त़ोसिद प़ाइँ साःरो ओतावत ङा मिँ मिन्‍सिउ बनै ज़गै मगैव ङाराज्‍या ङाचलैहुवत जे ङाछींत हुद लिज़्‍यावराए बाह्र थर इस्राएलीराए याङ़ैतावर ताद याय़ेन फाल्‍द्यान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","आव बेलाक जोए ङाजूँनी ओएँःर उझ़िमर, ओदाज्‍यु भाइर, ओनाना बैंनीर, ओबाबु ओआमार, ओज़ार ऱास्‍द याख्‍यानैज़्‍याव, होए आव उजिउत ज़ सय दोबोर ब दैन्‍या ले, अजम्‍बरी जुनी ब दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","खाली ख्‍वा ख्‍वा ङ़ातावर छींत तारिज़्‍यार, छींतावर ङ़ात तारिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“है जैद स्‍वर्गताव राज्‍या तोबो एँःए ओर्गे स्‍यासो लिज़्‍या। नो मिँ छकाल्‍न्‍या घग ज़ ओएँःल य़ेन दान्‍या मिँर याखिम्नाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","नोरास तला भरिकाव जेला यान्‍या कबल दाद ओय़ेन दाना यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","नौ बजेवाक फरी नो एँःए ओर्गे बजार जीदा ओबाक याय़ेन माल्‍योरालाई रँःद, ");
INSERT INTO kjl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","नोरालाई, ‘जे अइज़ जेलिज़्‍याव देखा ङाएँःल य़ेन दोनाचिके, जेजेला ङायाच्‍या,’ है ओरादोक ते, नोर बाद य़ेन दोनाकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","नो एँःए ओर्गे फरी बाह्र बजेवाक तखेप, तीन बजेवाक तखेप फरी ब बाहोर्‍यार जैद यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","पाँच बजेवाक फरी ब नो एँःए ओर्गेए तोबोक अइज़ च्‍याँःसिद लिज़्‍यावरालाई रँःद, ‘जे काराव बिनु य़ेन च्‍याँःसिद जेलिज़्‍याव?’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","नोराए, ‘गेलाई सुए ज़ य़ेन मायासिर,’ है यादोक ते, नोरालाई मनी ओय़ेन दाना यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“नम ओझ्यानाक नो एँःए ओर्गेए नो य़ेन दोज़्‍यावराए याङ़ैतावलाई खुल्‍द, ‘नो ङाय़ेन दाज़्‍यावरालाई दुप्‍द याजेला भाःद याएके, प़ाइँरानी छींनी हुवरालाई प़ाइँरानी ङ़ात याएयो,’ है ओदोक ते, नोए नो य़ेन दाज़्‍यावरालाई खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","पाँच बजे हुवरालाई ङ़ात याएक्‍यो। नोराए तछाकाव याजेला दैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","नो छकाल्‍न्‍या हुवराए निताव रँःद ‘नोराकिन गे ते कुधु ज़ गेदैया,’ है यालिज़्‍याव। खाली छींनी ते या ब हाःज़ दैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","नै ओतावए नोर एँःए ओर्गेए ल्‍योक बाद, ");
INSERT INTO kjl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘नो प़ाइँरानी छींनी हुवर तघन्‍ता वाज़ य़ेन दोकेर, नोर कै जैद गे तला भरी घाम सोता सोता ताद दावरास सम सम नजैसिउ?’ लिद गन गन दोकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","है जैद नो एँःए ओर्गेए तोबोलाई, ‘ङानैं, नँस छकाल्‍न्‍या ज़ तला भरिकाव जेलाल गिन्कबलिसिउ माःक रो? ङा नउपर्त मादान्‍या ङामादोए। ");
INSERT INTO kjl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","नजेला तीद बानिके। आव छींनी हुवरालाई मनी नँसकाव जुँ ज़ याव ङापैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","पैसा ङामीं ज़, ङापैसा जोलाई यान्‍या ङायुँ लिज़्‍या, होलाई यान्‍या ओमाताज़्‍याव रो? ङायुँ ओगराँव काराव नमी उतूज़्‍याव?’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“हो मिताव ज़ ख्‍वा ख्‍वा छींतावर ङ़ात तारिज़्‍यार, ङ़ातावर छींत तारिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","नकिन येसु यरूसलेमदा ओबाज़्‍याक बाह्र जना उसिसरालाई याबातङ खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“गे यरूसलेमदा गेपुलुस्‍नाज़्‍या। नल गेकेसोत ङा मिँ मिन्‍सिउलाई मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए याकुइत सूँपिन्‍या ज़ लेर। नोराए ङालाई सैःन्‍या ज़ थ·रैद, ");
INSERT INTO kjl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","रोमी सरकारए उकुइत याझाःनावत नोराए फरी उल्‍ली गिल्‍ली दाद, रीःद, क्रुसत तङ्गैद सैःनारिज़्‍यार। हैदी ब स़ोंलात सिउनी सैंसिद सोन्‍या ङाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","नकिन जब्दियाए ओज़ानी याकूब स़ोनो यूहन्‍नानी निआमास येसुए ल्‍योक हुद, निआमाए धो दाद, “जेरो प्रभु,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","येसुए, “काता दाद्यान्‍या नपैंज़्याव?” है ओदोक ते, नो मेंमाए, “नराज्‍याल आव ङाज़ानिलाई तोबोलाई नवोर्दा, तोबोलाई नदाबर्‍यादा च़ुसिन्‍या निजैयो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","येसुए, “नँ नज़ारास आव जेऩिज़्यावए जूँनी जेमासैंए। ङा जाँवाक धो सहिउ दुखर ङासहिरिज़्‍याव नोनी मासहिधुरिज़्‍यानी?” है ओरादोक ते, नोनी, “गिन्सहिधुया ज़,” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","हाःत ज़ येसुए, “हैज़, ङा ङादैरिज़्याव धो सहिउ दुखर जिन मनी दैन्‍या ज़ जिन्‍ले, खाली ङावोर्दा ङादाबर्‍यादा च़ुसिउ यान्‍या ते ङा ङाकुइत माले। निताव दैन्‍या स्‍वर्गताव ङाबाबुए जोलाई एज़्याव, होए उजूँनी वाज़ लिज़्‍या,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","उपुर्काव दस जना उसिसराए नो पाँ थैद नोनिलाई रँःद यारिस चोके। ");
INSERT INTO kjl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","नाःत ज़ येसुए उसिस भरिरालाई ओल्‍योदा खुल्‍द, “जे ज़ जेसैंज़्‍याखेहो, आव मानुवाताव याघेप्‍पार याधूँलावराए ङ़ैत बनै अखत्‍यासोर ताद हाप हाप ख्‍याज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","जे जेल ते निताव जैसिन्‍या माताए। है जैद जेनी जो स़ेर जैसिउ जेपैंज़्‍या, हो प़ाइँए यासेवा दान्‍या ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","स़ोनो जेनी जो घेप्‍पा जैसिउ जेपैंज़्‍या, हो प़ाइँए याबाँदा ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ङा मिँ मिन्‍सिउ ब ‘ङासेवा घदोरक’ लिद ङाहुव माःक, कुधुलाई बाँचैन्‍याए जूँनी ङाजिउ झाःद यासेवा ङादोहुव ची,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","येसु उसिसरास यरीहो सहरनी पुलुस्‍द याबाज़्‍याक मिँर ब बनै माहोल्‍या यास ज़ याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","येमक ऩेब्‍लो निमी मारैंःवनी च़ुसिद निलिज़्‍याव। नोनी ‘येसु आलाव घ्याँ हुज़्‍या दी’ लिन्‍या थैद, बनै चोइस, “अ दाऊदए ओथोलाव प्रभु, गिनलाई नयुँ ओनाक,” है लिद निक़िज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","नो माहोल्‍याराए ‘झ्याउँ तालिचिन’ लिद यारासिङार्केर। नोनी झन ज़ चोइस क़िद, “अ दाऊदए ओथोलाव प्रभु, गिनलाई नयुँ ओनाक,” है निलिक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","येसु नक च्‍याँःसिद नो निमी मारैंःवनिलाई ओल्‍योक खुल्‍द, “ङा जिनजूँनी काता दाद्यान्‍या?” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“प्रभु, गिन रँःधुन्या गिन्‍ताक,” है निदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","येसुए उयुँ नाद निमीत छाप्‍द उनियो प़ाइँना ज़ रँःधुन्या ताद उछींत बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","येसु उसिसरास यरूसलेम छ्योकाव जैतून दाँदाकिन जाँ होकसैकाव बेथफागे नाखार याकेस्‍नावत येसुए ऩेब्‍लो उसिसनिलाई, ");
INSERT INTO kjl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“जिन आव गेङ़ाकाव नाखारल बाचिन्‍केदा, नल तोबोक गधाहानी ज़ा-मा सुर्सिउनी दैन्‍या जिन्ले। नोनिलाई पला·द यारारैचिन्‍के। ");
INSERT INTO kjl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","सुवाराए, ‘काराव पला·द जिन्‍रालाँज़्‍याव?’ है यादाचिन्‍किन, ‘गिनप्रभुलाई चाहिज़्‍या,’ है जिन्‍रादोकिन नोराए हतप्‍त ज़ परींद्यान्‍या लेर,” है लिद निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","नो पाँ भरी अगमबक्ताए ओसरो पाँ सयो·न्‍याए जूँनी ताके। नो सर्सिउ आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सियोनए ओज़ालाई है दोक्‍यो, ‘चिऊके, नराजा काता ज़ माल्‍यो मिताव जैसिद, गधाहाए ओज़ा बछेरालाई चेप्‍द जेल्‍योक हुज़्‍या।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","है जैद नो ऩेब्‍लो उसिसनी येसुए है उनिदोव मिताव ज़ नाखारल बाद, ");
INSERT INTO kjl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","नो गधाहानिलाई दैद येसुए ल्‍योक रैद उसिसराए तोबो गधाहाए ओतर्त याक्‍वार झाःद्याद येसुलाई चेपो परींकेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","नकाव लिज़्‍याव माहोल्‍याराए याक्‍वार येमल तैंदिकेर। ख्‍वाराए फरी नजीलाव स्‍यावलार रैद येमल तैंद्याद, ");
INSERT INTO kjl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","नो माहोल्‍यार ख्‍वा येसुए ओङ़ात ख्‍वा उछींत जैसिद अइ लिद क़िए क़िए बाकेर, “होसन्‍ना! दाऊदए ओथोलाव येसुलाई दाइनो दाइनो ओताक। परमेस्‍वरए उमिनत हुव राजा धन्‍याकाव ओताक, स्‍वर्गताव परमेस्‍वरए उमिन बनै ओघ्‍योःक।” ");
INSERT INTO kjl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","नोर यरूसलेमल याकेसोत नो सहरलाव मिँराए ‘आव सु ओताव?’ लिद काला मुलु ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ओलस हुज़्‍याव माहोल्‍याराए, “आव गालीललाव नासरतनी हुव अगमबक्ता येसु ज़,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","नकिन येसु ध्‍यान झ़िमल पसिद नलाव लँःज़्‍यावर यो·ज़्‍यावरालाई पले·द पैसा त़ोज़्‍यावराए यातेबलर पल्‍तैद्याद, कुइतम यो·ज़्‍यावराए याकुर्चीर ब ख्‍याद्याद, ");
INSERT INTO kjl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“धर्मसास्‍त्रल परमेस्‍वरए ओपाँ इताव सर्सिउ लिज़्‍या, ‘ङा ङाझ़िम पोंखारिन्‍या झ़िम जैसिउ लिज़्‍या।’ जे ते झन आवलाई चोरराए पुप मिताव जैद जेनै,” है लिद याखेपैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","नकिन नलाव काना दूँदार ध्‍यान झ़िमल येसुए ल्‍योक याहुक नोरालाई यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","येसुए निताव अचम्‍बलाव य़ेनर ओदोव रँःद, स़ोनो ध्‍यान झ़िमलाव ल़ुज़ाराए ‘होसन्‍ना! दाऊदए ओथोलाव येसुलाई दाइनो दाइनो ओताक’ लिद याक़िज़्‍याव थैद नलाव मुख्‍या पुजारीर स़ोनो सास्‍त्रीर यारिस चोद, ");
INSERT INTO kjl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","येसुलाई, “आवराए याक़िज़्‍याव नँ ज़ नथैज़्‍याखेहो, काराव च़िम दाव नमारापरींज़्‍याव?” है यादोक ते, येसुए, “हैज़, ङा थैव ज़ ङालिज़्‍या। धर्मसास्‍त्रलाव सर्सिउ, ‘अ प्रभु, नँ नमिन सघ्योःन्‍या ल़ुज़ार स़ोनो नुइँ ओज़्‍याव भाउज़ाराए यायाःनी ज़ जैद ननै’ लिन्‍या जेमाप़रिए रो?” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","नोरालाई ख्‍यानैद सहरनी पुलुस्‍द बेथानिया नाखारल बासिनाके। ");
INSERT INTO kjl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","हो पराःती छकाल्‍न्‍या फरी यरूसलेमदा ओल्‍द ओबाज़्‍याक ओकरेए, ");
INSERT INTO kjl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","येम छ्योक ओख्‍यार ल़पलपौ तोबो नेभारा सीं रँःद ‘ओसैर ले सैं’ लिद उचिऊनाक ते ओसै तोबो ब मादैक्‍यो। ओख्‍यार वाज़ रँःद नो सींलाई, “आकिनी नसै काता ज़ ताताक,” है ओदोव प़ाइँना ज़ नो सीं थँके। ");
INSERT INTO kjl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","निताव रँःद उसिसर अचम्‍ब ताद, “आव सीं कै जैद बेहार ज़ उथँव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","येसुए फरी, “ङा जेलाई साचो है ङादाचिज़्‍या, युँ सुहुप्‍द तयुँ जैकिन आव नेभारा सींलाई ङाजैव मिताव वाज़ माःक, तोबो हाँलाई ‘नँ नतिन भोस्‍द समुन्‍द्रल ख्‍यासिन्‍के,’ है दाकिन, नो हैज़ तान्या ले। ");
INSERT INTO kjl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","है जैद जे जोत मनी जेयुँ हुप्‍द जेपोंखारिकिन नो दैन्‍या ज़ जेले।” ");
INSERT INTO kjl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","येसुए ध्‍यान झ़िमल ओपाँ ओरासथैज़्‍याक नलाव मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरर हुद येसुलाई, “आव नदोज़्‍याव य़ेनर नँलाई सुए है उदींव, सुए हक उईंव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","येसुए, “ङा ब जेलाई तोबो है ङादाचिदा, नोए ओजवाप जेयाँकिन ङा ब आव य़ेन दान्‍या हक सुए ओयाँव है ङादाचिया,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“ऱील सछैंज़्‍याव यूहन्‍नाए ओय़ेन परमेस्‍वरए ल्‍योनी ताव सैं मिँराए ल्‍योनी ताव?” है ओरादोक ते, नोर या याल, “ ‘यूहन्‍नाए ओय़ेन परमेस्‍वरनी ताव’ है गेद्या गेलिकिन, ‘हुकी काराव यूहन्‍नाए ओपाँ जेमाभैंःव?’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","फरी ‘मिँनी’ है गेद्या गेलिकिन मिँराए ल्‍योनी ओछ्यास लिज़्‍या। मिँ भरिए यूहन्‍नालाई अगमबक्ता ज़ है लिद थ·रैद नैर,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","नोराए येसुलाई, “गेमासैंए,” है दोकेर। हाःत ज़ येसुए मनी, “हो ची ताकिन्‍दा ङालाई आव य़ेन दान्‍या हक सुए ओयाँव ङा ब है ङामादाच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“जे आव पाँलाई फाल्‍चिके — तोबोए ओज़ानी ऩेब्‍लो निल्‍यो दी। नो निबाबु जेथाए ओल्‍योक बाद, ‘अ ङाज़ा, आछिम नँ ङाएँःल य़ेन दानाद्याव ताके,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘ङा ङामाबा, बाबु,’ है दोक्‍यो दी। खाली छींनी ते उयुँ फर्कैद बाके दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","हिताव ज़ फरी नो कान्‍छा ओज़ालाई है ओदोनाक, ‘ताए बाबु, ङा ङाबाया,’ है ते दोक्‍यो दी। खाली छींनी ते माबाके दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","है जैद नो ऩेब्‍लोनी काताकावए निबाबुए ओपाँ दोन्‍या?” है ओरादोक ते, “ङामाबा है लिद बाव ज़ ताखेहो,” है दोकेर। नाःत ज़ येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, हिताव ज़ सिर्मा स्‍यो·ज़्‍याव पापीर स़ोनो पातर्नी मेंमार जेकिन ङ़ादा परमेस्‍वरए ओराज्‍याल बान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","यूहन्‍नाए जेल्‍योक धर्मलाव येम सतैंना हुके, जे ते नोए ओपाँ जेमाभैंःके। झन सिर्मा स्‍यो·ज़्‍याव पापीर स़ोनो पातर्नी मेंमाराए नोए ओपाँ भैंःकेर। जे निताव रँःद ब जेयुँ जेमाफर्कैए, भैंःन्‍या ब जेमाभैंःए।” ");
INSERT INTO kjl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“फरी आव ब तोबो थैचिके — तोबो धनीए ओएँः भरिल जोम्‍परसै झाःद प़ाइँनी भार्नाए घिरिद, जोम्‍परसै पीन्‍या कोलो ब तोबो झाःद, मिँ लिन्‍या खोपोरा ब तोबो जैद, नो एँःलाई अधियाल याद ओल तोबो तादा देसङ लिनाके दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","नलाव जोम्‍परसैर किन्‍या बेला ओतावत ओय़ेन दाज़्‍यावरालाई उजुँ भरी च़ानाव यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","नो अधिया कमैज़्‍यावराए झन नोरालाई क्‍योःद ख्‍वारालाई याराप़ोकेर दी, ख्‍वारालाई लुँ लुँराए याराझेःकेर दी, ख्‍वारालाई यारासैःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फरी छींनी जाँ माहोल्‍या ओय़ेन दाज़्‍यावर ओरापरींक होरालाई मनी हैज़ याराजैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“प़ाइँरानी छींत ओज़ालाई ‘आवलाई ताकिन ओमान नैदिर सैं’ लिद नोलाई परींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","खाली नो अधिया कमैज़्‍यावराए ओज़ा उहुज़्‍याव रँःद या या पाँसिद, ‘आव ते एँः दैन्‍या मिँ ची। नोलाई सैःद आव एँः गेमी ज़ गेजैया’ लिद, ");
INSERT INTO kjl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","नोलाई क्‍योःद नो एँःनी पाखाङ लाँद सैःकेर दी।” ");
INSERT INTO kjl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","नकिन येसुए नो मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेररालाई, “नो एँःए ओर्गेए अधिया कमैज़्‍यावरालाई कै याजैवके, है दाँचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","नोराए, “निताव याफ्या·हुवरालाई सफ्या·द नो एँः बेला बेलाक ओल उजुँ यान्‍यारालाई यान्‍या ले,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","हाःत ज़ येसुए फरी, “जे आव धर्मसास्‍त्रलाव पाँ जेप़रिखेहो, ‘भुलीराए कान्‍ल ज़ माज़्‍यासे लिद याख्‍याव लुँ नो ज़ झन भुयाँरलाव लुँ ताके। आव ओल परमेस्‍वरनी ताव पाँर ज़, इताव रँःद गे अचम्‍ब गेताज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","है जैद ङा जेलाई है ङादाचिज़्‍या, परमेस्‍वरए ओराज्‍या जेलाई नैंद उगुन मामेंःद ओय़ेन दाज़्‍यावरालाई यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","फरी जो मिँ नो भुयाँरलाव लुँत पाज़्‍या ओल ज़ कुतु कुतु तान्‍या ले। नो लुँ फरी ओतर्त उहुकिन झन नप नप ज़ तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","नो मुख्‍या पुजारीर स़ोनो फरिसीराए येसुए ओपाँ थैद, “आव पाँ भरी ते गेङ़ैत झाःद ची पाँके,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","येसुलाई क्‍योःव पैंकेर। खाली ओलस लिज़्‍याव माहोल्‍यारालाई रँःद छे·केर, काराव ल्यो ताकिन नो माहोल्‍याराए येसुलाई अगमबक्ता ज़ है यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","येसुए नोर यारसिउ रँःद अइ लिद घर्ती तोबो झाःद याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्‍वर्गताव राज्‍या ते तोबो राजा स्‍यासो लिज़्या। नोए खेपा ओज़ाए उबिह्‍याए जूँनी भत्‍यार जैद, ");
INSERT INTO kjl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ओनोकोररालाई नो भत्‍यारल हुन्‍या सोर ओरायोरालाई खुल्‍नाव यापरींक्यो दी। नो सोर दैवर झन हुव माभैंःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","है जैद फरी ब छुत ओनोकोररालाई खुल्‍द, ‘जे नो सोर दैवराए ल्‍योक फरी ब बाद, ‘राजाए जेजूँनी सोइव सोइव मारर सैःद ज़्‍याव भरी जैधुक्यो दी, जे काचाबुल ज़ बान्‍या दी,’ है यारादोनाचिके,’ लिद यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","नोर झन सोर माथैव मिताव जैसिद याय़ेन माऱास्‍द ख्‍वार याएँःदा, ख्‍वार बेपार दाना बाकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ख्‍वाराए झन नो क़िना बाव ओनोकोररालाई क्‍योःद बीज्‍यात जैद यारासैःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“छींनी नो राजाए नो भरी थैद उरिस चोद उसिपाईंर परींद नो सैःज़्‍यावरालाई खदम जैद यानाखारलाई ब मेंः लैद याराएकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","नकिन नो राजाए ओनोकोररालाई खुल्‍द, ‘भत्‍यार भरी जैसिधुके, नो सोर दैवर भत्‍यार ज़्‍यान्‍या स्‍यासोर माताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","है जैद जे येम जीदा बाद जो जोर जेरादैज़्‍या, हो होर ज़ भत्‍यारल यारारैच्‍यो,’ है दाद यापरींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","है जैद नो ओनोकोरर येम जीदा बाद चाव माचाव यारादैव भरी दुप्‍द भत्‍यारल यारारैकेर दी। नोर राजाए उझ़िमल तसी ज़ ब्‍याल्‍केर दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“नकिन राजा ओपाहुनारास दैसिना हुके दी। नल तोबोलाई बिह्‍यालाव क्‍वा माक्‍वाइसिउ रँःद, ");
INSERT INTO kjl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","राजाए नोलाई, ‘ङानैं, बिह्‍यालाव क्‍वा माक्‍वाइसिद कै जैद आल नपसिहुव?’ है ओदोक ते, नो मिँ लोलोतोःव ज़ ताके दी। ");
INSERT INTO kjl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","हाःत ज़ नो राजाए ओनोकोररालाई खुल्‍द, ‘आवलाई उखँ उकुइ किद लाँःकाव चुम चुमोल ख्‍यानाचिके। नल ओहार ङर ङर कैद चिर चिर क़िद गघर्क।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","येसुए नो घर्ती नत ज़ तुपैद, “हिताव ज़ खुल्‍सिउर कुधु ज़ लिज़्‍यार, छाँतिसिउर ते छ्या ज़ लिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","नो पाँर थैद फरिसीराए, “येसुए ओपाँ कान्‍नी क्‍योःद गेएके?” लिद गुमुस्‍ता दाद, ");
INSERT INTO kjl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","यासिसर स़ोनो हेरोद राजासकावरालाई येसुए ल्‍योक यारापरींकेर। नोर ओल्‍योक बाद, “गुर्बा, नँ गेस नपाँज़्याव भरी साचो वाज़ लिज़्‍या। परमेस्‍वरए ल्‍योदा बान्‍या येम ब साचोस नपैसिज़्या। मिँ रँःद ब नमादोए, सुए ल्‍योदा ब नमाजैसिए। ");
INSERT INTO kjl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","है जैद गेलाई तोबो पाँ है दाव ताके, माहाराजालाई गे सिर्मा यान्‍या सैं मायान्‍या?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","येसुए नोराए याचाल सैंद, “ए कैफतीर, ङालाई काराव जेजाँचिनाज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","सिर्मा फो·न्‍या पैसा ङालाई तोबो सतैंद्याँचिके,” है ओरादोक ते, पैसा रैदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","येसुए फरी, “आत सुए उसुरूप, सुए उमिन उलिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“माहाराजाए उमीं ज़,” है दोकेर। नकिन येसुए, “हो ची ताकिन्‍दा माहाराजाए उमीं भरी माहाराजालाई ज़ एच्‍यो, परमेस्‍वरए उमीं भरी परमेस्‍वरलाई ज़ एच्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","नोर अचम्‍ब ताद नोलाई ऱास्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","नकिन हो छ्याम ज़ सदुकीर ब येसुए ल्‍योक तोबो पाँ है दोहुकेर। सदुकी है यारादोज़्‍यावराए ‘सिउकिन सैंसिन्‍या माताए’ है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","है जैद नोराए, “गुर्बा, मोसाए ओकानुनल तोबो अइ लिद सर्सिउ लिज़्‍या, ‘तोबोए ज्‍या दाद ज़ार मादैद उसिकिन, ओभाइए ओदाज्‍युए ओथोर माफ्या·न्‍याए जूँनी ओमारूमलाई ओरैवक।’ ");
INSERT INTO kjl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","किताव गेस तोबोए ओज़ार सात भाइ याल्‍यो। यादाज्‍युए ज्‍या दाद ज़ार मादैद ज़ सिके। ओज़ार यामाल्‍योए ओज्‍या ओभाइलाई ख्‍यानैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","फरी होए उधूँलावए नो ओमारूमलाई रैद नो मनी ज़ार मादैद ज़ सिके। नकिन साइँला मनी हिताव ज़ ताके। नितावनी ज़ नो मेंमालाई सात भाइए ज़ रैकेर। नोर प़ाइँ ज़ार मादैद ज़ सिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","प़ाइँरानी छींनी नो मेंमा ब सिके। ");
INSERT INTO kjl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","है जैद नो मेंमा सात भाइए याज्‍या ओतावए अजम्‍बरी जुनील काताकावए याज्‍या तान्‍या?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","हाःत ज़ येसुए, “जे धर्मसास्‍त्रलाव पाँ मातीद परमेस्‍वरए ओसक्ती ब जेमाथ·रैधुवए ज़ चबनै बिरैद जेनै। ");
INSERT INTO kjl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","अजम्‍बरी जुनील सुए ज़ ज्‍या ब मादोर, रे ब मादोर। प़ाइँ ज़ स्‍वर्गताव चाकर्‍या स्‍यासोर ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","है जैद जे ‘सिउकिन सैंसिन्‍या माताए’ है ल्‍यो पैंज़्‍यावर आव धर्मसास्‍त्रलाव परमेस्‍वरए ओपाँव पाँ थैचिके, ");
INSERT INTO kjl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ङा अब्राहामए ओपरमेस्‍वर, इसहाकए ओपरमेस्‍वर स़ोनो याकूबए ओपरमेस्‍वर ज़।’ है जैद मोरोराए यापरमेस्‍वर माःक, जींदो तावराए यापरमेस्‍वर ची,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","नक लिज़्‍याव माहोल्‍यार येसुए ओपाँ थैद अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","येसुए सदुकीरालाई थाम थुम ओराख्‍याव थैद नक लिज़्‍याव फरिसीर दुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","कानुनलाव तोबो यागुर्बालाई येसुलाई जाँचिना परींकेर। नोए येसुलाई, ");
INSERT INTO kjl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“गुर्बा, कानुन भरिरानी प़ाइँरानी दान्‍या काताकाव उलिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","येसुए, “ ‘जेयुँलाई आदा होदा मादुलैद, जेर्सा माम़ोंद, जेप्रभु परमेस्‍वरए ल्‍योदा युँ थू जैद ओललाई वाज़ मया दान्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","प़ाइँरानी ङ़ात दान्‍या य़ेन नो ज़। ");
INSERT INTO kjl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","होए उधूँलाव य़ेन ब हो मिताव ज़, ‘जेक्‍याँलाई किताव जेसमारिज़्‍या, छुतलाई ब हिताव ज़ समारिन्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","मोसाए ओकानुन भरी स़ोनो अगमबक्ताराए यासरो भरी ब आव ऩेब्‍लोत थोम्‍सिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","नकिन नो दुप्‍सिद लिज़्‍याव फरिसीरालाई येसुए, “जे ङालाई है दाँचिके, ");
INSERT INTO kjl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ख्रीस सुए ओथोलाव ओताज़्याव है जेलिज़्‍या?” है ओरादोक ते, “दाऊदए ओथोलाव ज़,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","येसुए फरी, “दाऊदए ओथोलाव वाज़ ओताकिन कै जैद धर्मसास्‍त्रल ओल दाऊदए मनी परमेस्‍वरए उपुरूसनी ओपाँक ख्रीसलाई ‘ङाप्रभु ज़’ है ओदोज़्‍याव? नो धर्मसास्‍त्रलाव ओपाँव आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘परमेस्‍वरए ङाप्रभुलाई, ‘नसुतुररालाई नखँ धूँल झाःद ङामाईंवा पै, ङावोर्दा च़ुसिद लिन्‍के,’ है दोक्‍यो।’ ");
INSERT INTO kjl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","है जैद ओल दाऊदए ब ख्रीसलाई ‘ङाप्रभु ज़’ है ओदोकिन नो कै जैद दाऊदए ओथोल वाज़ उगनिसिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","येसुस सु ज़ मापाँधुकेर। हो छ्यामकिन ज़ सुए ज़ येसुस पाँन्‍या आँत मादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","नकिन येसुए उसिसर स़ोनो नल लिज़्‍याव माहोल्‍यारालाई अइ लिद यासथैक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“सास्‍त्रीर स़ोनो फरिसीराए मोसाए ओकानुन पैन्‍या हक दैद नैर। ");
INSERT INTO kjl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","है जैद नोराए है यादाचिज़्‍याव मिताव जेदोदी ब थिक ज़, खाली नोराए यादोज़्‍याव मिताव य़ेन ते तादोच्‍यो। नोराए यायाःए वाज़ दोज़्‍यार, याकुइए ते मादोर। ");
INSERT INTO kjl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","नोर सुए ज़ यामासयो·धुज़्‍याव कानुनर जैद छुतरालाई वाज़ दाव यारापरींज़्‍यार, या ताकितर तके ओछ्यो ब माछुर। ");
INSERT INTO kjl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","नोराए यादोज़्‍याव भरी ते मिँराए ङ़ाक सतैंन्‍या वाज़ लिज़्‍या। नोर परमेस्‍वरए ओकानुन सर्सिउ पत्रीलाई घेप्‍पा जैद याचाँदीत स़ोनो यापाखोरात पो·द बाऱिज़्यार। याक्‍वारात ब झुम्‍कार ता·द बाऱिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","नोर स॰द घ्योःव घ्योःव भत्‍यारराल स़ोनो धर्मसास्‍त्र झ़िमराल प़ाइँराए रँःन्‍या पोक च़ुसिउ पैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","बजार जीदा ब ‘मिँराए गुर्बा लिद धो घदासिरक’ लिन्‍या युँ दाद बाऱिज़्यार। ");
INSERT INTO kjl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“जे ते फरी ‘प़ाइँए गुर्बा है घदासिरक’ लिन्‍यार ताजैसिच्‍यो। जे जेगुर्बा ते तोबो वाज़ लिज़्‍या, जे ते दाज्‍यु भाइर ची। ");
INSERT INTO kjl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","जे आव मानुवाताव मिँरालाई ब कोभालाई बाबु है तारादोच्‍यो। जे जेबाबु ते स्‍वर्गत तोबो वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","फरी जे स॰द प़ाइँए याङ़ैताव मिताव ब ताजैसिच्‍यो। जे जेङ़ैत तोबो वाज़ लिज़्‍या, हो ख्रीस ज़। ");
INSERT INTO kjl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","है जैद जे जेल ते जो घेप्‍पा जेताज़्‍या, हो प़ाइँए यासेवा दान्‍या ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो ओलनी सघ्‍योःसिज़्‍या, हो ज़िम्‍रिज़्‍या। फरी जो ओलनी सज़िम्‍सिज़्‍या, हो घ्‍योःरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“जे कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे स्‍वर्गताव राज्‍याल बाज़्‍यावरालाई जेरावैंज़्‍या। नो राज्‍याल जे ते पसिउ जेमाभैंःके, झन पसिउ पैंज़्‍यावरालाई ब पसिउ जेमाराएए। ");
INSERT INTO kjl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“फरी ब सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे कैफतीर राँदी मेंमारालाई तँनी छाम छुम जेराख्‍याज़्या, मिँराए ङ़ाक वाज़ बनै चाव चाव पोंखारिउ जेजैसिज़्‍या। जे ते प़ाइँरानी घ्‍योःव सजा ज़ जेदैरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“जे कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे तोबोलाई जेचलनल रैन्‍याए जूँनी समुन्‍द्र तरिद जेराखिम्‍नाज़्‍या, झेंःव झेंःव गोंर ब कातिद जेराखिम्‍नाज़्‍या। तोबोलाई जेदैकिन जेकिन झन ज़ नोलाई नर्गए ओथोलाव जेजैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“जे उमी पा·वए येम पैन्‍या ओजैसिज़्‍याव मितावर जेलिज़्‍या। जे अऩाकलाव कानुनर जैद, ‘ध्‍यान झ़िम छुद किर्‍या झाःसिउ, नो किर्‍या माथ॰रिए,’ है जेलिज़्‍या। ‘ध्‍यान झ़िमलाव सुनलाई छुद झाःकिन वाज़ थ॰रिज़्‍या,’ है जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","जे किताव जेमी मारैंःव भाँकात्‍यार जेल्‍यो, कै जैद नो सुनलाई चोखैज़्‍याव ध्‍यान झ़िमकिन नलाव लिज़्‍याव सुन घेप्‍पा ओताज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","जे फरी, ‘थानलाई छुद किर्‍या झाःसिउ, नो ब माथ॰रिए। नो थानल लिज़्‍यावलाई छुद झाःकिन वाज़ किर्‍या थ॰रिज़्‍या,’ है जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","जे किताव जेमी मारैंःवर जेल्‍यो, कै जैद नो चरैःसिउलाई चोखैज़्‍याव थानकिन नलाव चरैःसिउ ओघ्योःज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","है जैद किर्‍या झाःज़्‍याव मिँए थानलाई छुद किर्‍या ओझाःकिन नलाव लिज़्‍याव भरी ब माहुइ रो? ");
INSERT INTO kjl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","हो मिताव ज़ ध्‍यान झ़िमलाई छुद झाःकिन नलाव लिज़्‍याव भरी ब हुज़्‍या। नलाव लिज़्‍याव परमेस्‍वर ब हुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","फरी नमलाई छुद किर्‍या झाःकिन परमेस्‍वरए उसिंहासनलाई छुद ओझाःव मिताव ब लिज़्‍या, ओल परमेस्‍वरए उमिन ज़ छुद ओझाःव मिताव ब लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“जे कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे तके दँ जरार घोद दस भा जैद तभा भितील झाःन्‍या य़ेन ते जेमाबिरैए। झन प़ाइँरानी ओचाहित ल्‍यो कानुनलाव सर्सिउ पाँ, सतस दान्‍या, सतत लिन्‍या, छुतए ल्‍योदा युँ नान्‍या, नो भरी ते जेऱास्‍के। जे ते झन नो ओचाहित ल्‍योलाई ब ऱासो मापरिन्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","जे किताव भाँकात्‍यार जेल्‍यो, तोबो ओभार भाँती ल्‍यो मिँए ऊँतलाई गाल्‍द, तकेज़ा ऱूइलाई उरँःक उयुँ माजाम्‍द हाइद ख्‍याज़्‍याव मिँ स्‍यासोर जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“जे कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे ताथीर खुरीर जेराचोखोइज़्‍याव नो पाखाताव वाज़ लिज़्‍या। जेयुँल ते लोभ स़ोनो जोत ब युँ मानैधुन्‍या वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","जे भाँकात्‍या फरिसीर, ङ़ादा जेयुँलाई सछैंचिकेदा, पाखाताव जेक्‍याँ ब चोखो ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“जे कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे सरा थीसिउ मथ स्‍यासोर जेलिज़्‍या। नो मथ पाखानी बनै चाव पोरो·व रैंःज़्‍या, उजींल ते चिची सी ङरो मिँराए ऱूसर वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","हिताव ज़ जे मनी मिँराए ङ़ाक बनै चाव धर्मी मिताव जेजैसिज़्‍या, जेयुँल ते कैफत स़ोनो अधर्म वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“जे निताव कैफती सास्‍त्रीर स़ोनो फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। अगमबक्ताराए याखादरर जेराबनैज़्‍या, यामिनताव नैर ब स्‍यासी जैद, ");
INSERT INTO kjl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘गे गेसाखा पुर्खाराए याबेलाक यास गेल्‍यो ताकिन इताव अगमबक्तारालाई सैःन्‍या गेमाल्‍यो,’ है जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","है जैद ननी ज़, ‘अगमबक्तारालाई सैःज़्यावराए याथोर गे ज़ गेल्‍यो’ लिन्‍या जे ज़ जेथ·रैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","है जैद जे मनी जेसाखा पुर्खाराए यादोज़्‍याव य़ेन घसयो·च्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ए घुलर, घुलए ओथोर! जे नर्गलाव सजानी कै जैद उस्‍किउ जेदैरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ङा जेल्‍योदा अगमबक्तार, याबुद्धी ल्‍योर, स़ोनो ओल्‍योदा बान्‍या येम पैज़्‍यावर परींद ङायाचिरिज़्‍या। जे नोरानी ख्‍वारालाई जेरासैःरिज़्‍या, ख्‍वारालाई क्रुसत जेरातङ्गैरिज़्‍या, ख्‍वारालाई धर्मसास्‍त्र झ़िम झ़िमल जेराप़ोरिज़्‍या, ख्‍वारालाई सहर सहरदा जेराखेपैरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","है जैद यारासैःव धर्मी भरी नो ओदाज्‍युए ओसैःव हाबिलए ओपालाकिन नो थान स़ोनो ध्‍यान झ़िमनी निखार्लाव जेसैःव बेरेक्‍याहए ओज़ा जकरिया पैकावराए याझी जेलाई ज़ लागिस्‍रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","जेलाई साचो है ङादाचिज़्‍या, आव भरी आव बेलाकाव मिँराए ङ़ैत ज़ फुलुप्‍सिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ए यरूसलेमलाव मिँर, कै जैद अगमबक्ता भरिरालाई जेरासैःज़्‍याव, जेल्‍योक परींसिउरालाई ब लुँ लुँए जेराझेःज़्‍याव? बामाए ओचर्ल्‍यानीर ओकर धूँल ओरादुप्‍ज़्‍याव मिताव, ङा ब जेलाई कुधु पाला ज़ ङाल्‍योदा पाथस दुपो ङापैंके, खाली जे ते जेमाभैंःके। ");
INSERT INTO kjl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","है जैद जेझ़िम रितो ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ङा जेलाई है ङादाचिज़्‍या, आकिन ते ‘परमेस्‍वरए उमिनताव हुज़्‍याव धन्‍याकाव ओताक’ है जेमादाँवा पै ङालाई फरी रँःन्‍या जेमाले।” ");
INSERT INTO kjl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","नकिन येसु ध्‍यान झ़िमनी पुलुस्‍द ओबाज़्‍याक उसिसराए, “गुर्बा, आव ध्‍यान झ़िम काता आः चाव जैसिउ उलिज़्‍याव,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","येसुए, “हैज़, आव भरी चिऊचिके। खाली ङा जेलाई साचो है ङादाचिज़्या, छींनी तछा आव भरी तैःद लुँए तर्त लुँ ब रहिन्‍या माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","नकिन जाँवाक येसु जैतून दाँदात च़ुसिद उलिज़्‍याक उसिसर याबातङ अलगज़ा ओल्‍योक बाद, “आव नपाँ भरी खर्क ओतारिज़्‍याव, नँ हुन्‍या बेला स़ोनो आव जुक खेम्‍न्‍या बेलाकाव सरेस किताव ओतारिज़्‍याव? गेलाई है दासिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","येसुए, “जेलाई सुवाराए झुकैचिर्‍या, जे सैंसिद जोगोइसिद लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","मिँर ङा ङामिन कुद ‘ङा ज़ ख्रीस’ है लिद कुधु ज़ हुद कुधुलाई याराझुकैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","स़ोनो ‘आङ लरैं ताज़्या, होङ लरैं ताज़्या’ है यालिज़्‍याव जेथैक जे ताछे·च्‍यो। आव जुनी ब ताव ज़ परिए, खाली नो खेम्‍न्‍या बेला माःक। ");
INSERT INTO kjl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","नोकिन ङ़ादा जात जात, राज्‍या राज्‍या लरैं दान्‍या लेर। पो पोल भोंचालोर अनिकालर ब तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","आव भरी मेंमाए ज़ा दैन्‍या बेलाक ओघर्लिज़्याव मिताव सुरूलाव दुख वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“नो बेलाक जेलाई मनी जेखिरी पसिद सूँपिद सैःचिरिज़्‍यार। जे ङामिनतावर जेतावए प़ाइँ जातलाव मिँराए सोचिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","नो बेलाक कुधुए ज़ यायुँ क़्याद ङालाई ऱास्‍नारिज़्‍यार। नोर ख्‍वा ख्‍वार या याल ब सोसिद धोका यासिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","फरी कुधुए ज़ आव ङापाँ बले·द तँदा पैन्‍यार जैसिद कुधुलाई ज़ याराबले·रिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","आव मानुवात अधर्मलाव य़ेन बनै ज़ उमचिउए कुधु मिँराए यामया खेस्‍रिज़्या। ");
INSERT INTO kjl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","खाली जो आव दुखर ओमाखेमा पै थ॰रिज़्‍या, होए ज़ अजम्‍बरी जुनी दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","परमेस्‍वरए ओराज्‍यालाव आव चाव था संसार भरिलाव काना कुनीङाव प़ाइँ जातलाव मिँराए थैद परमेस्‍वरए ओसाची यादैवत, बल्‍ल आव जुक ब खेम्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“है जैद आव ब सैंच्‍यो, जे दानिएल अगमबक्ताए ओसरो मिताव नो ध्‍यान झ़िमलाव चोखो पोल तोबो फुरी हुद ऩुल्‍पा ऩुल्‍मा ओजैहुव जेरँःक, ");
INSERT INTO kjl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","हो बेलाक यहूदियाल लिज़्‍यावर गों जीदा ओधोंःरक। ");
INSERT INTO kjl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","थालात लिज़्‍यावर ब याझ़िमलाव याआल मालर ताच़ानारक। ");
INSERT INTO kjl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","एँःल लिज़्‍यावर मनी याक्‍वार च़ाना याझ़िमदा ताबारक। ");
INSERT INTO kjl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","नो बेलाक याफूल याज़ा ल्‍योर स़ोनो नुइँ सवैज़्याव आमार युँ नावज़ार। ");
INSERT INTO kjl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","खाली धोंःन्‍या बेला ज़्‍यूँःव साहाक स़ोनो ऩासिन्‍या छ्याम ताताक लिद परमेस्‍वरलाई पोंखारिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","हो बेलाकाव दुख बनै धो सहिउ तारिज़्‍या। निताव दुख आव संसार सुरू ओतावकिन आःपै माहुताए, निताव दुख नोकिन छींनी ब तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","निताव बेला तावका ताव ज़ उलिकिन सु ज़ रहिन्‍या मालेर। खाली ओल परमेस्‍वरए छाँतिद ओरानैज़्‍याव उमींराए जूँनी नो बेला सुतुईंद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“नो बेलाक जेलाई सुवाराए, ‘ख्रीस आङ हुद ले, होङ हुद ले,’ है यादाचिकिन नोरालाई तारापतिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ख्‍वार ङा ङामिन कुद ख्रीस जैसिद हुन्‍या लेर, ख्‍वार परमेस्‍वरए उपुरूसनी पाँव जैसिद हुन्‍या लेर। नोराए अचम्‍ब अचम्‍बलाव सरेसर य़ेनर जैद कुधुलाई झुकैन्‍या लेर। परमेस्‍वरए ओराछाँतिउरालाई मनी झुकैन्‍या छ्यास लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","है जैद आव पाँर जेलाई ङ़ादा ज़ है दाद ङानैचिए। ");
INSERT INTO kjl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","मिँराए जेलाई, ‘ख्रीस फलाना बनल हुद ले,’ है यादाचिक होदा ताबाच्‍यो, फरी ‘झ़िम जींल लिज़्‍या,’ है यादाचिकिन नोराए यापाँ ब तापतिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ङा मिँ मिन्‍सिउ ङाहुन्‍या छ्याम किताव पुर्बङ बिजुली उमिल्‍किक पछ्युँङ पै ज़गै जैज़्‍याव, हिताव ज़ ङा मनी प़ाइँए रँःन्‍याक मी चिकलामत ज़ हुन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","किताव खरल ओताक वाज़ का गिद्दर हुज़्‍यार, हिताव ज़ तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“हो बेलाकाव दुख ओखेमोत निमी ब चुम चुमो तारिज़्‍या, स़्यावैए ओज़गै ब म़ारिज़्‍या, सोरोर ब नमतिन तेरिज़्‍यार, नमताव भरी ब यासतर म़ाद थोनो·सिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","नाःत ज़ मिँ मिन्‍सिउ ङाहुन्‍या सरेस नमत रैंःरिज़्‍या। बनै ज़गै मगैव ङासक्तीरास बादलरास स्‍वर्गनी ङाहुज़्‍याव आव मानुवाताव प़ाइँ जातलाव मिँराए रँःद नोर यायुँर स्‍यासे सतेन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","नाःत ज़ तोबो भोंकरए ओर्गात स्‍वर्गताव ङाचाकर्‍यार ङारापरींवत नोराए नाम नमलाव प़ाइँ काना कुनीलाव छाँतिद ङारानैज़्‍याव ङामींरालाई ङाल्‍योक यारादुप्‍रिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“आव ब सैंच्‍यो, किताव नेभारा सीं ओमोम्‍नाक ‘उभ्‍याली उहुनाव ची ओल्‍यो’ है जेलिज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","हिताव ज़ नो है ङादाचिउ पाँ भरी ओतानाज़्याव जेरँःक ‘ख्रीस उहुन्‍या बेला ओतानाव ची ओल्‍यो’ लिन्‍या सैंच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ङा जेलाई साचो है ङादाचिज़्‍या, आव भरी ओमातावा पै आव जुक खेम्‍न्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","आव नाम नम ते खेम्‍न्‍या ले, ङा ङापाँ ते खर्क ज़ म़ान्‍या माले।” ");
INSERT INTO kjl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“नो छ्याम, नो बेला सुए ज़ मासैंर। स्‍वर्गताव चाकर्‍याराए ब मासैंर, परमेस्‍वरए ओज़ाए ब मासैंव, स्‍वर्गताव ङाबाबुए वाज़ सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","है जैद ङा मिँ मिन्‍सिउ ङाहुन्‍या बेला नोआए ओपालाकाव मिताव ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","नोआए ओपालाकाव मिँर ब ऱीए ओमारागदैवा पै ज़्‍याद ओद, ज्‍यार रेर ब दाव य़ेन ज़ यादोज़्‍याव। नोआ ऱी जहाजल ओमापसिवा पै नोर नो य़ेन दाव ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ऱीए साम सुम ओमारागदैवा पै ‘इताव गेतारिज़्‍या’ लिन्‍या मासैंकेर। ङा मिँ मिन्‍सिउ ङाहुन्‍या छ्याम ब हिताव ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","नो बेलाक एँःल य़ेन दाज़्‍यावनिलाई तोबोलाई लाँरिज़्‍याव, तोबोलाई ख्‍यानैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","हिताव ज़ फरी राँथै हे·ज़्‍याव मेंमानिलाई तोबोलाई लाँरिज़्‍याव, तोबोलाई ख्‍यानैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“है जैद सैंसिद लिच्‍यो, जेप्रभु आव छ्याम हुरिज़्‍या लिन्‍या जेमासैंए। ");
INSERT INTO kjl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","आव ब सैंच्‍यो, तोबो झ़िमए ओर्गेए ‘चोर आछिम रील आः बेलाक हुरिज़्‍या’ लिन्‍या ओसैंकिन नो सैंसिद लिद उझ़िम पा·व माएखेहो। ");
INSERT INTO kjl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","हिताव ज़ जे मनी सैंसिद लिच्‍यो, काराव ल्‍यो ताकिन ङा मिँ मिन्‍सिउ मनी जेमासैंद उमँःजानी ज़ ङाहुरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“किताव तोबो धनी मिँए सतस दाज़्याव ओतह ल्‍यो ओनोकोरलाई उझ़िमलाव य़ेन भरी उकुइत याद ओय़ेन दाज़्यावरालाई थिक बेलाक ज़्‍यावर यान्‍या जैद ओख्‍यानैक, ");
INSERT INTO kjl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","नो नोकोरए सतस य़ेन ओदोज़्‍याव ओघरपतीए ओदैहुकिन नो नोकोर असिक दैव ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ङा साचो है ङादाचिज़्‍या, नो ओघरपतीए प़ाइँ ज़ उकुइत यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","फरी नो नोकोर माचाव ओताकिन, ‘ङाघरपती हतप्‍त माहु,’ लिद, ");
INSERT INTO kjl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ओलस य़ेन दोज़्यावरालाई प़ोद, ओल ज़्‍याद ओद मँःए मँःए ओबाऱिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ओमासैंद ओघरपतीए ओदैहुकिन, ");
INSERT INTO kjl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","नोलाई चम चम जैद कैफतीर ओराख्‍याज़्‍याव पोल ख्‍यान्‍या ले। नल नलावरास याहार ङर ङर कैद चिर्लनी बिर्ल घर्न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“हाः बेलाक स्‍वर्गताव राज्‍याल पसिन्‍यार कितावर तारके लिक ते, दस जना मुँद्याल्‍नीर सु सु याबत्तीस ओज्‍या च़ाना हुज़्‍याव ब्‍याहोल्‍यालाई कींद नैज़्‍याव मितावर तारिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","नोर पाँच जना यासामा ल्‍योर, पाँच जना यासामा माल्‍यो मितावर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","नो यासामा माल्‍यो पाँच जनाराए ते बत्ती वाज़ लाँकेर दी, बत्तील झाःन्‍या म़ास ते मालाँकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","फरी नो यासामा ल्‍योराए ते बत्तील झाःन्‍या म़ास ब लाँद यानैज़्‍याव दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","नो मुँद्याल्‍नीर ब्‍याहोल्‍या हुन्‍या धिलो ओतावए यामीर पातिद होक ज़ स्‍याँकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आधा रील तोबोए, ‘दे सोचिके, ब्‍याहोल्‍या हुरिके, सु सु जेबत्ती तैंःद ब्‍याहोल्‍यास दैसिनाचिके,’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","प़ाइँ सोद याबत्तीर बनैद झाःसिकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","नकिन नो यासामा माल्‍योराए यासामा ल्‍योरास, ‘गेलाई जेम़ास तुपुरू याव ताके, गे ते गेबत्तीर सिरिकेर,’ है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","नो यासामा ल्‍योराए, ‘जेलाई गेयाचिकिन गेलाई ब थैंन्‍या माले। बुरू जे पसलदा लँःनाचिके,’ है यारादोकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","नोर लँःना याबाव प़ाइँना ज़ ब्‍याहोल्‍या केस्‍हुके दी। हाःत ज़ नो ब्‍याहोल्‍याए यासामा ल्‍योरास बिह्‍यालाव भत्‍यारल पसिद य़ाम गल्क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“छींनी नो यासामा माल्‍योर म़ासर लँःद याहुवत य़ाम गल्सिउ रँःद य़ामत कोतो कोतो जैद, ‘प्रभु, गेलाई य़ाम फैद्यासिके,’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ब्‍याहोल्‍याए नोरालाई, ‘साचो है ङादाचिज़्या, ङा जेलाई ङामासरेस्‍चिए,’ है यादोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“है जैद जे ब सैंसिद लिच्‍यो। जे ‘आव छ्याम, आव बेलाक तारिज़्‍या’ लिन्‍या जेमासैंए।” ");
INSERT INTO kjl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“फरी स्‍वर्गताव राज्‍या तोबो मिँए ओनोकोर भरिलाई खुल्‍द ओलसकाव लिज़्‍याव भरी नोराए यापासल झाःद तादा देसदा ओबाव मिताव ब लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","नो ओबान्‍या बेलाक सु सु यागहक रँःद तोबोलाई पाँच तोला सुन, तोबोलाई ऩेतोला, तोबोलाई त़ोतोला याद याख्‍यानैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","नो ओबाव छींनी नो पाँच तोला दैवए बेहार ज़ खेलैसिद ओयाःत पाँच तोला हाइक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","हिताव ज़ फरी नो ऩेतोला दैवए मनी खेलैसिद ओयाःत ऩेतोला हाइक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","नो त़ोतोला दैवए ते ओघरपतीए उसुनलाई नामल गादैद म़ोंद नैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“कुधु छींनी नो याघरपती हुद, ‘ङारायो सुन कै जैर्‍या’ लिद ओनोकोररालाई याखुल्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","नो पाँच तोला दैव हुद, ‘प्रभु, नयाँव पाँच तोला सुन खेलैसिद ओयाःत पाँच तोला हाइद ङानै,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओघरपतीए, ‘स्‍याबास सतस दाज़्‍याव ङानोकोर, ङायुँलाव मिताव मिँ नलिज़्‍या। तकेज़ा य़ेनलाई ब सतस नदोवए झन कुधु ज़ नकुइत जैद ङाईंरिज़्‍या। है जैद नयुँ होलाँ जैद ङास रेंनिके,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“नकिन फरी नो ऩेतोला दैव हुद, ‘प्रभु, नो नयाँव ऩेतोला सुन खेलैसिद फरी ओयाःत ऩेतोला हाइद ङानै,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओघरपतीए नोलाई मनी, ‘स्‍याबास सतस दाज़्‍याव ङानोकोर, ङायुँलाव मिताव मिँ नलिज़्‍या। इताव तकेज़ा य़ेनलाई सतस नदोवए झन कुधु ज़ नकुइत जैद ङाईंरिज़्‍या। नँ मनी नयुँ होलाँ जैद ङास रेंनिके,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“प़ाइँरानी छींत नो त़ोतोला दैव हुद, ‘प्रभु, नँ बनै कर्रा नतावए नँ ते नमाझाःव ब नसिम्‍ज़्‍या, नमानैव ब नलाँज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","है जैद ङाछ्याचेए नो नयाँव सुन नामल गादैद ङानैके। किताव नयाँव हिताव ज़ लिज़्‍या,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ओघरपतीए नोलाई, ‘ए मीसी, कान्‍ल ज़ काम मालागिउ ङानोकोर, ङालाई निताव ‘ओमाझाःव ब सिम्‍ज़्‍याव, ओमानैव ब लाँज़्‍याव’ है नदाँज़्‍याव ताकिन, ");
INSERT INTO kjl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","काराव नो सुन ब्याङ्कल नमाझाःव? नल नझाःव ताकिन ङाहुवत ओब्‍याजस दैन्‍या ङाल्‍यो,’ है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","नक लिज़्‍यावरालाई, ‘नोलाई नो त़ोतोला नैंद दस तोला ल्‍योलाई एचिके। ");
INSERT INTO kjl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","जोए ओदैवलाई चावस चलैज़्याव, होलाई झन ज़ चा·सिद धोल पोगोल ज़ तारिज़्‍या। जोए ओदैवलाई चावस माचलैव, होस छ्या छ्या लिज़्याव ब नैंसिरिज़्या। ");
INSERT INTO kjl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","नो काम मालागिउ ङानोकोरलाई ते चुम चुमोल ख्‍याचिके। नल ओहार ङर ङर कैद धस धस गघर्क।’ ” ");
INSERT INTO kjl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“तछा मिँ मिन्‍सिउ स्‍वर्गताव ओचाकर्‍यारास बनै ज़गै मगैवस हुद ओराज्‍या चलैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","नो बेलाक प़ाइँ देसलाव, प़ाइँ जातलाव मिँरालाई ओल्‍योक दुप्‍द किताव बेधा गावलाए बेधा भरी तँदा बाकरा भरी तँदा ओराजैज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","हिताव ज़ नो राज्‍या चलैज़्‍यावए मनी नो बेलाक नोरालाई बेधा स्‍यासो भरी ओवोर्दा, बाकरा स्‍यासो भरी ओदाबर्‍यादा जैद, ");
INSERT INTO kjl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","नो राजाए ओवोर्दाङावरालाई है दान्‍या ले, ‘हुचिके ङाबाबुए उयुँलाव मिताव मिँर। नाम नम ओतावकिनकाव जेमिनत नैद ओयाचिउ राज्‍या जेकुइत रैचिके। ");
INSERT INTO kjl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","जे ङाकरेव बेलाक ङाकरे सैःद जेयाँके, ऱी ङाछोसो बेलाक ङाऱीछो सैःद जेयाँके, ङादुलिरिज़्‍याक ब बासिउ जेयाँके, ");
INSERT INTO kjl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","नाङग्‍या ङालिज़्‍याक ब जेक्‍वाइनाके, ङाजोरो उहुक ब जेसमारिनाके, झ्यालखानाल ङालिज़्‍याक ब जेचिऊहुनाके,’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","नो ओवोर्दाङाव धर्मीराए, ‘अ प्रभु, खर्क करे नल्‍योदा नकरे सैःद गेईंव, खर्क नऱीछो सैःद गेईंव, ");
INSERT INTO kjl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","खर्क नदुलिरिज़्‍याक बासिउ गेईंव, खर्क नाङग्‍या नल्‍योदा गेक्‍वाइनिउ? ");
INSERT INTO kjl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","खर्क नजोरो उहुक गेसमारिनिउ, खर्क झ्यालखानाल नलिक गेचिऊहुनिउ?’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","नो राजाए, ‘जेलाई साचो है ङादाचिज़्‍या, ङासकाव प़ाइँरानी ज़िम्‍ज़ा काता ज़ माल्‍योरालाई जेराचिऊव, नोरालाई माःक, ङालाई जेचिऊनाव मिताव ज़ लिज़्‍या,’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“नकिन फरी राजाए नो ओदाबर्‍यादाङावरालाई, ‘ए जेफ्या·हुवर, जे ङानी पुलुस्‍द सैतान स़ोनो ओचाकर्‍याराए जूँनी जैसिउ नर्गलाव चुयाप मातान्‍या मेंःल बाचिके। ");
INSERT INTO kjl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ङा ङाकरेव बेलाक ङाकरे सैःद जेमायाँके, ऱी ङाछोसो बेलाक ङाऱीछो ब सैःद जेमायाँके, ");
INSERT INTO kjl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ङादुलिरिज़्‍याक ब बासिउ जेमायाँके, नाङग्‍या ङालिज़्‍याक ब जेमाक्‍वाइनाके, ङाजोरो उहुक स़ोनो झ्यालखानाल ङालिज़्‍याक ब जेमाचिऊनाके,’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","नो ओदाबर्‍यादाङाव पापीर, ‘प्रभु, खर्क करे नल्‍यो गेरँःनिउ, खर्क ऱी नछोसो गेरँःनिउ, खर्क नदुलिरिज़्‍याव गेरँःनिउ, खर्क नाङग्‍या नल्‍यो गेरँःनिउ, खर्क नजोरो उहुव स़ोनो झ्यालखानाल नल्‍यो गेरँःनिउदा गेमाचिऊनिउ?’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","राजाए नोरालाई, ‘ङा जेलाई साचो है ङादाचिज़्‍या, जे ङासकाव प़ाइँरानी ज़िम्‍ज़ा काता ज़ माल्‍योरालाई जेमाराचिऊवए, ङालाई जेमाचिऊनाव मिताव ज़ लिज़्‍या,’ है दान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","नकिन येसुए, “है जैद जे आव ब सैंच्‍यो, नो ओदाबर्‍यादाङावर खर्क ज़ माउस्‍किधुन्‍या सजाल परिरिज़्‍यार, नो ओवोर्दाङाव धर्मी भरी ते अजम्‍बरी जुनील बारिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","येसुए आव पाँ भरी ओखेमोत उसिसरालाई है यादोक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“आछिमकिन ऩेलात निस्‍तार पर्ब हुरिज़्‍या। नो बेलाक ज़ ङा मिँ मिन्‍सिउलाई क्रुसत तङ्गैद सैःनारिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","येसुए है ओल्‍यो मिताव ज़ मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरर तोबो कैयाफा यादोज़्‍याव प्रधान पुजारीए उझ़िमक दुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","येसुलाई झुकैद क्‍योःद सैःन्‍या गुमुस्‍ता दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","खाली, “पर्ब बेलाक माता, मिँर मचिन्‍या ओछ्यास लिज़्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","हाः बेलाक येसु बेथानिया नाखारल तोबो सिमोन यादोज़्‍याव कुऱीए उझ़िमक उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","येसुए नो झ़िमक काँ उज़्‍युज़्‍याक तोबो मेंमाए बनै चाव ज़िम्‍ज़ा लुँ जाल उसी ङरो बनै ओएः ल्‍यो म़ास रैद येसुए ओङ़ैत ओपो·स ज़ थीदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","येसुए उसिसराए निताव रँःद जाँ यारिस चोद, “आव मेंमाए काराव नाः ओएः ल्‍यो म़ास खेर ओझाःज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","बुरू नोलाई यो·द नो पैसाए काता ज़ माल्‍योरालाई भाःद ओराएकिन तान्‍या ओल्‍यो,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","येसुए थैद, “काराव आव मेंमाए उयुँ केःद जेएज़्याव? नोए ते ङाजूँनी बनै चाव य़ेन दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","काता ज़ माल्‍योर ते जेस एकतार ज़ लिज़्‍यार, ङा ते जेस एकतार लिन्‍या ङामाले। ");
INSERT INTO kjl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","आवए ङाक्‍याँताव थीद ओयाँव म़ास, ङा मासिद ज़ गादैन्‍या छ्यामकावए जूँनी ङामोरोलाई थीद ओयाँव मिताव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, संसार भरिल जोङ जोङ आव चाव था यारासथैज़्यार, होङ होङ आव मेंमाए ओदोव य़ेन थास्‍द उमिन ब रहिन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","नकिन बाह्र जना उसिसरानी यहूदा इस्‍करियोत मुख्‍या पुजारीराए ल्‍योक बाद, ");
INSERT INTO kjl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ङा येसुलाई जेकुइत पारैद ङायाचिकिन ङालाई काता जेयाँके?” है ओरादोक ते, नोर खुसी ताद चाँदीए पैसा तीस गोता एकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","हाःकिन नोए येसुलाई धोका यान्‍या मौका खिम्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","हाःत ज़ माँदा भरेस ज़्‍यान्‍या पर्ब सुरू ओतावत उस॰कताव छ्याम येसुए उसिसर ओल्‍योक हुद, “नँ कै नलिज़्या, आव पर्ब मानिन्‍याए जूँनी ज़्‍यावर काङ्क जैनान्‍या?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","येसुए, “नो सहरल बाचिकेदा, नक तोबो मिँस दैसिन्‍या जेले। नोलाई, ‘गेगुर्बाए है दींज़्‍याव, ओल बान्‍या बेला ताद ले दी। है जैद गे उसिसरास आव पर्ब नझ़िमक मानिउ पैंज़्‍याव,’ है दोच्‍यो,” है दाद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","येसुए है ओरादोव मिताव ज़ उसिसराए पर्बताव ज़्‍याव भरी जैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","हो छ्याम ऱिमक येसु बाह्र जना उसिसरास नो झ़िमल दुप्‍सिद ज़्‍यान्‍याए जूँनी च़ुसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ज़्‍यावर याज़्‍युज़्‍याक येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, जेनी तोबोए ङालाई धोका यान्‍या ले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","उसिसर यागहरास, “ङा ते माताखेहो सा, प्रभु,” है लिद पालास है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","नाःत ज़ येसुए, “जोए ङास भरेस चिपल छोइद ज़्‍युज़्‍याव, हो ज़। ");
INSERT INTO kjl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ङा मिँ मिन्‍सिउए ते धर्मसास्‍त्रलाव सर्सिउ दुखर जुनी ब सयो·व ज़ परिए, खाली ङालाई धोका याज़्याव मिँलाई ते थैए माँतकन ज़ लिज़्‍या। निताव मिँ बुरू ओमाजर्मिकिन तान्‍या ओल्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","नो धोका याव पैंज़्‍याव यहूदा ओल ज़ पर्सिद, “सैं ङा ओताव, गुर्बा?” है ओदोक ते, येसुए, “हैज़, नँ ज़ है नलिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","नकिन नो याज़्‍युज़्‍यावत ज़ येसुए उकुइत भरेस तोबो रैद, असिक ऩिद नो भरेसलाई केःद, “हाँ, आव ज़्‍युचिके। आव ङाक्‍याँ ज़,” है दाद भाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","हो मिताव ज़ फरी खुरी उकुइत रैद धन्‍याबाद चरैःद, “जे प़ाइँए आव खुरीनी ज़ ओचिके,” है लिद नोरालाई याद, ");
INSERT INTO kjl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“आव जेओज़्‍याव कुधु मिँराए पाप क्‍याल्‍द्यान्‍याए जूँनी ङासोभोरिज़्‍याव ङाझी ज़। आनी ज़ परमेस्‍वरए जेस साःरो बाचा नैद्याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ङा जेलाई है ङादाचिज़्या, ङा स्‍वर्गताव ङाबाबुए ओराज्‍याल जेस सिप गेमातावा पै आव भत्‍यारलाव दाखमद्य आछिमकिन ओन्‍या ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","नकिन भजन तोबो गैद ननी पुलुस्‍द जैतून दाँदादा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","नक याकेसोत येसुए उसिसरालाई, “जे आछिम रील ज़ ङालाई प़ाइँए ऱास्‍न्‍या जेले। धर्मसास्‍त्रल इताव सर्सिउ लिज़्‍या, ‘बेधाराए यार्गे गावलालाई प़ोद ङासैःवत, बेधार चितराँ पुतराँ तारिज़्‍यार।’ ");
INSERT INTO kjl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","हैदी ब सिउनी सैंसिद जेङ़ादा ज़ गालीलल ङाबारिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","हाःत ज़ पत्रुसए, “उपुर्कावराए प़ाइँए याऱास्‍निदी ब ङा ते नँलाई खर्क ज़ ऱास्‍न्‍या ङामाले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","येसुए, “ङा नँलाई साचो है ङादींज़्‍या, आछिम रील ज़ भाल्‍या ओमाकोद ङालाई स़ोंखेप ‘ङामासरेसे’ है दान्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पत्रुसए फरी, “माःक, ङा नँस सिन्‍या ओतादी ब ङा नँलाई ङामासरेसे है लिन्‍या ङामाले,” है दोक्‍यो। उपुर्कावराए मनी हैज़ लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","नकिन येसु उसिसरास गेतसमनी यादोज़्‍याव बगैचाल बाद उसिसरालाई, “ङा जाँ होकसैकावक बाद ङापोंखारिवा पै जे आक ज़ लिच्‍यो,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","पत्रुस स़ोनो जब्‍दियाए ओज़ानी याकूब स़ोनो यूहन्‍नारालाई ओलस यालाँक्‍यो। हाःत ज़ येसु उयुँर स्‍यासे सतेद धो थाइव तानाद, ");
INSERT INTO kjl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","नो स़ोम्‍लोरालाई, “ङायुँर स्‍यासे तेद सिवा सिवा ताद ङाले। जे आक ज़ लिद ङास सैंसिद लिचिके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","नोराकिन छ्यावा होकसै बाद नामक फुलुप्‍सिद अइ लिद पोंखारिक्‍यो, “अ बाबु, आव ङाक्‍याँत हुरिज़्‍याव धो सहिउ दुखर भर्सकी वैंद्याँके। खाली ङा ङायुँ माःक, नँ नयुँ ओताकिन वाज़,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","नो स़ोम्‍लोराए ल्‍योक उहुवत नोर ङ़ल्‍द यालिज़्‍याव दैहुद पत्रुसलाई, “जे कै जैद ङास तघन्‍ता पै ब जेमालिधुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","सैंसिद पोंखारिचिके, म़ानी दुखराल जेमाथ॰रिधुया। जेयुँए ते दान्‍या ज़ पैंज़्‍याव, खाली पाखाताव जेक्‍याँए ते मासहिधुन्‍या ओछ्यास लिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","नकिन येसु फरी ब ङ़ादाङाव ओपोंखारिज़्‍याव पोक बाद अइ लिद पोंखारिक्‍यो, “ङाबाबु, आव ङाक्‍याँत हुरिज़्‍याव धो सहिउ दुखर ङा मासहिद ज़ मातान्‍या ओल्‍यो ताकिन, है नलिज़्‍याव मिताव ज़ ओताक,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","नो स़ोम्‍लोराए ल्‍योक उहुक फरी ङ़ल्‍द यालिज़्‍याव ज़ यादैक्‍यो। नोराए यामीर बनै पातिद मासहिधुकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","है जैद नोरालाई ख्‍यानैद फरी ब ङ़ादाङाव पोक बाद ङ़ादाकिनकाव मिताव ज़ पोंखारिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","नकिन फरी नो स़ोम्‍लोराए याल्‍योक हुद, “आःपै जेमीर मायो·ताए रो? अब ते ङा मिँ मिन्‍सिउ पापीराए कुइत सूँपिसिन्‍या बेला हुके। ");
INSERT INTO kjl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","च्‍याँःसिचिके, गेबा। ङालाई धोका याज़्‍याव मिँ नक ज़ हुद ले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","येसु ओपाँज़्याक ज़ नो बाह्र जना उसिसरानिकाव यहूदा इस्‍करियोत बनै माहोल्‍या मिँरास तरवालीर खोंतार रैद हुकेर। नोर मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरराए ल्‍योनी हुवर याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","नो इस्‍करियोतए ङ़ादा ज़ नो क्‍योःना हुज़्‍यावरालाई, “ङा जोलाई माइँ ङादोए, होलाई ज़ क्‍योःच्‍यो,” लिद सरेस याद ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","है जैद बगैचाल याकेसो प़ाइँना इस्‍करियोत येसुए ल्‍योक बाद, “जेरो गुर्बा,” लिद माइँ दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","हाःत ज़ येसुए, “अ ङानैं, ङाक्‍याँत नदान्‍या दोके,” है ओदोव प़ाइँना ज़ नो माहोल्‍यार हुद येसुलाई ताप तप क्‍योःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","हाःत ज़ येसुसकाव तोबोए ओतरवाली हाइद प्रधान पुजारीए ओनोकोरलाई तँनिकाव ओर्ना पल्‍द सतेदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","येसुए निताव रँःद, “नतरवाली उसिपल झाःके। तरवाली चलैज़्‍यावर तरवालीनी ज़ सिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ङा ङाबाबु परमेस्‍वरस ङाऩिकिन बाह्र पल्‍तन ओचाकर्‍यार तादी ब ङालाई परींद्यान्‍या ले, नो जेमासैंए रो? ");
INSERT INTO kjl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","खाली निताव ङाऩिकिन आव ङाक्‍याँत ताव परिन्‍या धर्मसास्‍त्रलाव सर्सिउ पाँर कातानी ओयो·रिज़्‍याव?” ");
INSERT INTO kjl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","नकिन येसुए नो क्‍योःना हुव माहोल्‍यारालाई, “काराव ङालाई दाँकालाई मिताव तरवालीर खोंतार दाद जेक्‍योःहुनाव? ङा जेलाई दिनकाव ज़ ध्‍यान झ़िमल परमेस्‍वरए ओपाँ ङासथैचिक जेमाक्‍योःनाके। ");
INSERT INTO kjl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","खाली अगमबक्ताराए धर्मसास्‍त्रल यासरो मिताव सयो·न्‍याए जूँनी ची इताव ताके,” है ओरादोव प़ाइँना उसिस भरी येसुलाई ऱास्‍द चितराँ पुतराँ धोंःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","नकिन नो क्‍योःना हुवराए येसुलाई प्रधान पुजारी कैयाफाए ल्‍योक लाँकेर। नक सास्‍त्रीर स़ोनो यहूदीराए यास़ेरर दुप्‍सिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","नो बेलाक पत्रुस जाँ तादाङ याछीं याछीं हुद नो प्रधान पुजारीए ओचतराक ज़ हुद ‘येसुलाई कै याजैज़्‍याव ब्‍याँ?’ लिद पाल्‍याराए छ्योक ज़ च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","नो झ़िमल मुख्‍या पुजारीर स़ोनो घ्‍योःव कचरीलाव स़ेर भरिए येसुए ओङ़ैत माचाहिउ पाँर झाःद सैःन्‍या कर याखिम्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","धुत गोहाई पाँन्‍यार कुधु ज़ ताकेर, खाली कर ते कान्‍त ज़ मादैकेर। बल्‍ल प़ाइँरानी छींनी ऩेब्‍लो हुद, ");
INSERT INTO kjl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“आवए, ‘परमेस्‍वरए ओध्‍यान झ़िमलाई तैःद फरी स़ोंलात हिताव ज़ ङाजैरिज़्‍या,’ है ओल्‍यो गिन ज़ गिन्‍थैके,” है निरादोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","प्रधान पुजारी च्‍याँःसिद येसुलाई, “नँ नपाँ काता ज़ ओमालिज़्‍याव रो? आवनी नङ़ैत झाःद निईंव पाँ किताव उलिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","येसुए घाइ ज़ मादोक्‍यो। फरी प्रधान पुजारीए, “जींदो परमेस्‍वरए उमिननी है ङादींज़्‍या, नँ गेलाई है दासिके, नँ परमेस्‍वरए ओज़ा ख्रीस सैं माःक?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","येसुए, “नँ है नलिज़्‍याव मिताव ङा साचो हो ज़। तछा ङा मिँ मिन्‍सिउलाई माहान परमेस्‍वरए ओवोर्दा च़ुसिद ङालिज़्‍याव ब रँःन्‍या जेले, स़ोनो स्‍वर्गतिन बादलरास ङाहुज़्‍याव ब रँःन्‍या जेले,” है यादोक्यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","हो प़ाइँना ज़ प्रधान पुजारीए उरिसए ओक्‍वार चीए चीए, “जे ज़ जेथैके, आवए परमेस्‍वरए उमिन ओबले·ज़्याव। छुत गोहाई काता ओचाहिउ? ");
INSERT INTO kjl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","जे कै जेलिज़्‍या?” है ओरादोक ते, नोराए प़ाइँए, “आवलाई सैःन्‍या ज़,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ख्‍वाराए मुत्‍काए प़ोकेर, ख्‍वाराए लप्‍ताए प़ोकेर, ख्‍वाराए त़िल्‍केर। ");
INSERT INTO kjl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","नै जैज़्‍यावराए फरी, “नँ साचो ख्रीस ताकिन, गेलाई है दासिके, नँलाई प़ोज़्‍याव सु?” है लिद बरे·केर। ");
INSERT INTO kjl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","येसुलाई नै याजैज़्‍याक पत्रुस चतराक ज़ च़ुसिद उलिज़्‍याव। नो बेलाक ज़ तोबो नलाव य़ेन दाज़्‍याव मेंमा हुद पत्रुसलाई, “नँ मनी गालीललाव येसुस नल्‍यो सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","पत्रुसए प़ाइँए याङ़ाक, “नँ काता नपाँज़्‍याव इताव, ङा ते ङामासैंए,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","साँबिलाक उच़ुसिनाक फरी छुत तोबो य़ेन दाज़्याव मेंमा हुद नक लिज़्‍यावरालाई है यादोक्‍यो, “आव मिँ ते नासरतलाव येसुसकाव ज़,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पत्रुसए किर्‍या झाःद, “ङा नो है नलिज़्‍यावलाई सरेस ज़ ङामासरेसे,” है दोक्यो। ");
INSERT INTO kjl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","फरी छ्यावाक नक लिज़्‍यावर पत्रुसए ल्‍योक हुद, “नँ साचो उसिसरासकाव ज़, नपाँनी ज़ गेसरेस्‍निज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","पत्रुस बनै थल्‍सिद किर्‍या झाःद, “ङा नो मिँलाई सरेस ज़ ङामासरेसे,” है ओरादोव प़ाइँना ज़ भाल्‍या कोके। ");
INSERT INTO kjl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","नाःत ज़ ङ़ादा येसुए पत्रुसलाई, “भाल्‍या ओमाकोद ज़ ङालाई स़ोंखेप ‘ङामासरेसे’ है लिन्‍या नले,” है ओदोव पाँ ब चेतैक्‍यो। नो चेतैद पत्रुस लाँःक पुलुस्‍द धस धस घर्के। ");
INSERT INTO kjl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","छकाल्‍न्‍या घग ज़ मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरराए येसुलाई सैःन्‍याए जूँनी सल्‍ला दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","येसुलाई किद रोमी सरकारलाव पिलातसए ल्‍योक लाँद सूँपिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","नाःत ज़ येसुलाई धोका याज़्‍याव यहूदा इस्‍करियोतए येसुलाई सैःन्‍या ज़ याथ·रैव रँःद, ‘ङा ते मादान्‍या य़ेन ची ङादोव ओल्‍यो’ लिद उयुँर माचाव दाद मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरराए ल्‍योक बाद नो यायो तीस गोता चाँदीए पैसा यालाई ज़ सोवोल्‍द्याद, ");
INSERT INTO kjl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ङा ते कान्‍त ज़ ओखत माल्‍योलाई अऩाकल ज़ धोका याद मादान्‍या ची ङादोव ओल्‍यो,” है ओरादोक ते, नोराए, “जो तादी ब ताधुके, गेलाई घाइ तादासियो,” है यादोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","इस्‍करियोतए नो यायो चाँदीए पैसा याङ़ाक ज़ ध्‍यान झ़िमल ओदोइद ख्‍यानैद ननी पुलुस्‍द बाद ओल ज़ झुन्‍दैसिद सैःसिके। ");
INSERT INTO kjl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","मुख्‍या पुजारीराए ते नो ओख्‍याव पैसार तीद, “आव ते झीए ओएःलाव पैसा ची, ध्‍यान झ़िमलाव भितील थोम्‍न्‍या माताए,” लिद, ");
INSERT INTO kjl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","या याल सल्‍ला दाद नो पैसाए तादा तादानी हुव मिँरालाई यासिक गादैन्‍याए जूँनी तोबो कुमाल्‍याए ओएँः लँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","है जैद हो छ्यामकिन ज़ नो एँःए उमिन ‘झीए एँः’ ताके। ");
INSERT INTO kjl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","आनी ज़ यर्मिया अगमबक्ताए ओसरो मिताव यो·के। नोए ओसरो आव ज़, ‘इस्राएलीए ओथोराए नोए ओक्‍याँताव यामुलिउ ओएः चाँदीए पैसा तीस गोताए ");
INSERT INTO kjl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","परमेस्‍वरए है ओल्‍यो मितावनी ज़ कुमाल्‍याए ओएँः लँःन्‍या लेर।’ ");
INSERT INTO kjl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","नाःत ज़ येसुलाई रोमी सरकारलाव पिलातसए ओङ़ाक यासच्‍याँक पिलातसए येसुलाई, “नँ साचो यहूदीराए याराजा ज़ रो?” है ओदोक ते, येसुए, “नँ ज़ नथ·रैनाके सानी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","नाःत ज़ मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरराए येसुलाई खत यालैज़्यावत ब येसुए घाइ ज़ मारादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","निताव थैद पिलातसए येसुलाई, “काता नाः कुधु पाँर नङ़ैत झाःद याईंज़्‍याव नमाथैए रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","झन ज़ घाइ मालिद तोबो ब मापाँके। निताव रँःद पिलातस बक्‍क ताके। ");
INSERT INTO kjl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","नोए सालकाव तखेप निस्‍तार पर्बत यहूदीराए जो कैदीलाई ‘ऱास्‍द्यासिके’ है लिज़्‍यार, होलाई ज़ ऱास्‍द ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","नो बेलाक तोबो बारब्‍बा यादोज़्‍याव बनै उमिन थासो कैदी झ्यालखानाल उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","है जैद माहोल्‍यार यादुप्‍सिज़्याक पिलातसए, “झ्यालखानाल लिज़्‍याव बारब्‍बालाई ऱास्‍न्‍या सैं ख्रीस यादोज़्‍याव येसुलाई ऱास्‍द्यान्‍या? जे ज़ है लिचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ओल पिलातसए ते ‘आवराए येसुलाई अऩाकल ज़ यामी तूद सूँपिद नैनार’ लिन्‍या सैंद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","फाल्‍न्‍याए जूँनी उच़ुसिउत पिलातसए ओज्‍याए येसुए उजूँनी अइ लिद तोबो था परींक्‍यो, “नो सैःव यापैंज़्‍याव धर्मी मिँए उउपर्त नँ मादान्‍या तादोयो। आछ्या रीलाव ङामँल आव मिँए उजूँनी ङायुँर स्‍यासे तेद बनै धो थाइव ङाताके,” है लिद परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरराए ते झन मिँरालाई प़ाइँ याल्‍योदा जैद नो झ्यालखानाल लिज़्‍याव बारब्‍बालाई ऱास्‍द येसुलाई सैःन्‍या है लिच्‍यो है दाद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","पिलातसए फरी, “नोनी काताकावलाई ऱास्‍द्यान्‍या?” है ओरादोक ते, “बारब्‍बालाई ऱास्‍द्यासिके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातसए, “हुकी नो ख्रीस यादोज़्‍याव येसुलाई ङा कै जैन्‍या की?” है ओरादोक ते, नोराए प़ाइँए तपाँ जैद, “क्रुसत तङ्गैद सैःन्‍या,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातसए फरी, “काराव? आवए मादान्‍या काता दाद ओनैज़्‍याव?” है ओरादोक ते, नोर झन ज़ मचिद, “क्रुसत तङ्गैद सैःन्‍या,” है लिद बनै ज़ क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","नाःत ज़ पिलातसए, आवरालाई ते कै जैद ब माताके, झन ज़ मचिरिकेर लिद ऱी रैद नोराए याङ़ाक उकुइर हुर्सिद, “दे चिऊनाचिके, आव य़ेननी ङाछेसिके। आवए उझी ङालाई तालागिस्‍क, जेलाई ज़ ओलागिस्‍क,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","नो माहोल्‍याराए, “नोए उझी ओलागिस्‍किन गे गेक्‍याँत स़ोनो गेज़ाराए क्‍याँत ज़ ओलागिस्‍क,” है याल्‍यो प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","पिलातसए बारब्‍बालाई ऱास्‍द्याद येसुलाई रीःद, क्रुसत तङ्गैद सैःन्‍याए जूँनी सिपाईंरालाई ज़ यासूँपिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","नकिन पिलातसए उसिपाईंराए येसुलाई दरबार जींल लाँद रोमी पल्‍तन भरी यारादुप्‍केर। ");
INSERT INTO kjl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","नोराए येसुए ओक्‍वार सिउःद्याद राजाराए याक्‍वाइसिज़्‍याव मिताव घ्यामो क्‍वा जास्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ज़ुए मुकुत तोबो ऱ॰द ओङ़ैत जास्‍द वोर्फताव उकुइत भाताए झुइ तोबो सक्‍योःद ओङ़ाक याघूँदानी तिकिसिद, “ए यहूदीराए याराजा, जय जय ओताक,” है लिद बरे·द, ");
INSERT INTO kjl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","त़िल्‍द, उकुइताव भाताए झुइए ज़ ओङ़ैत प़ोदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","गिल्‍लैद गिल्‍लैद च़िम यादोवत नो घ्यामो क्‍वा सिउःद्याद ङ़ादाङाव ओक्‍वार ज़ जास्‍द क्रुसत तङ्गैना लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","येसुलाई सैःना यालाँज़्‍याक येमक तोबो कुरेनीलाव सिमोन यादोज़्‍यावस यादैसिक नोलाई येसुए ओलाँज़्‍याव क्रुस सुघुर्द, ");
INSERT INTO kjl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","गलगथा यादोज़्‍यावक केस्‍केर। नो पोए उमिन ‘खप्‍पर्‍या पो’ है ब यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","नक येसुलाई काव वासः झाःसिउ दाखमद्य सवैकेर। येसुए दार्द ओव माभैंःके। ");
INSERT INTO kjl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","येसुलाई क्रुसत तङ्गैद ओक्‍वारात गोला झाःद भाःद, ");
INSERT INTO kjl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","नक ज़ च़ुसिद येसुलाई गुद नैकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ओललाई तङ्गैद यानैज़्‍याव क्रुसए ओङ़ैत, “आव यहूदीराए याराजा येसु ज़” है लिद तोबो फल्‍यात ओखत सर्द चकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","हो छ्याम ऩेब्‍लो चोरनिलाई मनी, तोबोलाई ओवोर्दा तोबोलाई ओदाबर्‍यादा जैद क्रुसत तङ्गैद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","आनी हुनी भाल्‍सिना हुवराए याङ़ैर ङ़त ङ़त जैद थल्‍द, ");
INSERT INTO kjl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“नँ ध्‍यान झ़िमलाई तैःद स़ोंलात ङाजैरिज़्‍या है लिज़्‍याव मिँ, नक्‍याँलाई कै जैद नमाबाँचैधुज़्‍याव? नँ साचो ज़ परमेस्‍वरए ओज़ा ताकिन नो क्रुसतिन झरिद हुन्‍के,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","हिताव ज़ मुख्‍या पुजारीर स़ोनो यहूदीराए यास़ेरर, सास्‍त्रीराए मनी येसुलाई गिल्‍लैद, ");
INSERT INTO kjl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“आवए छुतरालाई ताकितर याबाँचैज़्‍याव, ओल ओक्‍याँलाई कै जैद ओमाबाँचैधुज़्‍याव? इस्राएलीराए याराजा है लिज़्‍याव नो क्रुसतिन झरिद उहुकिन वाज़ ओपाँ पतिन्‍या गेले। ");
INSERT INTO kjl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","आव मिँ परमेस्‍वरए ओक्‍याँत ख्‍यासिद लिज़्‍याव ओताव ताकिन परमेस्‍वरए ओल्‍योदा उयुँ थू जैद पला·हुखेहो। ओल कै जैद ‘ङा परमेस्‍वरए ओज़ा ज़’ है उलिज़्‍याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ओलस तङ्गैसिउ चोरनी मनी नोराए है याल्‍यो मिताव ज़ है लिकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","नकिन अधमर लावाकिन तीन बजे पै देस भरी काल्‍या कले झ्याके। ");
INSERT INTO kjl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तीन बजेवाक येसु बनै चोइस, “इलोई, इलोई, लामा सबखथनी?” है लिद क़िके। नोए ओसै, “अ ङापरमेस्‍वर, अ ङापरमेस्‍वर, ङालाई काराव नऱास्‍नाव?” ");
INSERT INTO kjl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","नक च्‍याँःसिद लिज़्‍यावराए नो पाँ थैद ख्‍वाराए, “आवए ते एलियालाई ची उखुल्‍ज़्‍याव सा,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","तोबोए धोंःनाद भाताए उतुपात थाकना पो·द सिरो दाखमद्यल छिम्‍द येसुए ओयाःत झाःद्याद पिउ परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","उपुर्कावराए ते, “अब ते चिऊद गेनैया, एलिया कातारानी हुद माहाइज़्‍याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","नाःत ज़ येसु फरी ब बनै चोइस क़िद उस॰ सफ्या·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","हो प़ाइँना ज़ ध्‍यान झ़िमलाव बारिसिउ क्‍वा ब उतुपानी ओजराङ पै ओलनी ज़ ऩेपरा ताद चिस्‍के। नामर थोनो·सिद, हाँर पा·द, ");
INSERT INTO kjl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","सिउराए याखादरर ब फुकेर। सिउ धर्मी मिँर ब कुधु सैंसिद सोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","खाली येसु सिउनी सैंसिद ओसोव छींनी वाज़ नोर याखादरनी पुलुस्‍द यरूसलेम सहरल याबावत कुधु मिँराए याङ़ाक सरैंःसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","नो येसुलाई गुज़्‍याव कप्‍तान स़ोनो ओलस लिज़्‍याव पाल्‍याराए निताव भोंचालोर, अचम्‍ब अचम्‍बलावर रँःद नोर बनै छे·द, “आव ते साचो ज़ परमेस्‍वरए ओज़ा ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","हो बेलाक गालीलनी हुव मेंमार येसुस बाऱिद ओसेवा दाज़्‍यावर जाँ तादानी येसुलाई चिऊद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","नोरानी मरियम मग्‍दलिनी, याकूब स़ोनो योसेफनी निआमा मरियम, जब्‍दियाए ओज़ानी निआमा ब ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","र्‍याम्‍या रिमी ओझ्यानाक तोबो अरिमाथियालाव धनी मिँ योसेफ यादोज़्‍याव हुके। नो मिँ ओल मनी येसुए ओपाँत बाज़्‍याव मिँ ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","नोए पिलातसए ल्‍योक बाद येसुए ओमोरो ऩिक्‍यो। पिलातसए नोए ओपाँ थैद येसुए ओमोरो लाँव एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","है जैद योसेफए येसुलाई नो क्रुसतिन हाइद पालो क्‍वाए लुम्‍बैद, ");
INSERT INTO kjl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ओल उजूँनी दावन खुपिद पुप जैद ओनैज़्‍याव साःरो खादरल झाःद ओय़ामक घ्‍योःव लुँए कद ख्‍यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","योसेफए येसुलाई खादरल ओझाःज़्‍याव बेलाक मरियम मग्‍दलिनी स़ोनो ओनैं मरियमनी नक चिऊद निनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","हो पराःती ऩासिन्‍या छ्याम ओतावत मुख्‍या पुजारीर स़ोनो फरिसीर दुप्‍सिद पिलातसए ल्‍योक बाद, ");
INSERT INTO kjl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“हाकिम सायेब, नो छुल्‍या ओमासिद ज़, ‘स़ोंलात सैंसिद ङासोरिज़्‍या,’ है उलिज़्‍याव थैद गेनै। ");
INSERT INTO kjl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","है जैद नँ नो स़ोंला भरी ओमाखेमा पै गुन्‍या पाल्‍या खादरक नैद्याव ताके, म़ानी कातारानी उसिसर हुद ओमोरो हाइद लाँद मिँरालाई ‘सिउनी सैंसिद सोके’ है ल्‍यो ब पैंर्‍या। नै ओताकिन ङ़ादाङावकिन झन ज़ बलेस्‍न्‍या ले,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातसए, “सिपाईंर लाँद जे ज़ नोरालाई पाथस गुव यारापरींचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","नोर ननी बाद नो खादर पोक सु ज़ माबाधुन्‍या जैद पाल्‍यार नैद नो कसिउ लुँत माफैन्‍या छाप ब झाःकेर। ");
INSERT INTO kjl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ऩासिन्‍या छ्याम ओखेमोत सातालाव उस॰कताव छ्याम नम उसँनाक मरियम मग्‍दलिनी, ओनैं मरियमस खादर पोदा चिऊनाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","हाःत ज़ तोबो बनै घ्‍योःव भोंचालो हुद परमेस्‍वरए ओचाकर्‍या स्‍वर्गतिन झरिहुद नो कसिउ लुँलाई पल्‍तैद नो लुँत च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","नो चाकर्‍याए ओङाः बनै ज़ झिलिक झिलिको उलिज़्‍याव, ओक्‍वार ब पोम स्‍यासो तक तकौर यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","नो गुज़्‍याव पाल्‍यार नोलाई रँःद याछ्याचेए भुम भुम गूद धलिद सिउ स्‍यासो ज़ ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","नो चाकर्‍याए नो मेंमानिलाई, “जिन ताछे·चिन, नो क्रुसत तङ्गैद यासैःव येसुलाई जिन्‍खिम्‍हुज़्‍याव ज़ ताखेहो। ");
INSERT INTO kjl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","नो आल माले। ङ़ादाकिनकाव है ओदाचिज़्‍याव मिताव नो सैंसिद सोधुके। अछादी आव यानैव पो चिऊचिन्‍केदा, ");
INSERT INTO kjl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","उसिसराए ल्‍योदा हतप्‍त ज़ बाद, ‘गेप्रभु सिउनी सैंसिद सोके। जेङ़ादा ज़ गालीलदा बाज़्या दी, होङ ज़ ओलस दैसिन्‍या जेले,’ है यारादोनाचिन्‍के,” है दाद फरी नोनिलाई, “आव भरी साचो ज़ है दाद ङानैचिने,” है उनिदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","नोनी बनै छे·द निरेंतए चह चह ताद खादर पुपनी पुलुस्‍द धोंःनाद उसिसरालाई है यारादोनाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","निबाज़्‍याक येमक ज़ येसु उमँःजानी निङ़ाक च्‍याँःसिद, “जिनयुँ होलाँ जैचिन्‍के,” है उनिदोव प़ाइँना ज़, नोनी उखँ क्‍योःद धो दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","नकिन येसुए नोनिलाई, “ताछे·चिन, नो ङाभाइरालाई, ‘जे प़ाइँ गालीलदा बाचिके दी, प्रभुस होङ ज़ दैसिन्‍या जेले दी,’ है यारादोचिन,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","नोनी येमत निबाज़्‍याव बेलाक, येसुए ओमोरोलाई गुज़्‍याव ख्‍वा पाल्‍यार सहरल बाद नो यारँःव भरी प़ाइँ ज़ मुख्‍या पुजारीरालाई है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","नो पुजारीराए पाल्‍याराए यापाँ थैद यहूदीराए यास़ेररास दुप्‍सिद सल्‍ला दाद नो पाल्‍यारालाई, कुधु पैसार याद, ");
INSERT INTO kjl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“आव जेपाँ सुलाई ज़ है तारादोच्‍यो। बुरू जे, ‘गे रील ङ़ल्‍द गेलिज़्‍याक उसिसर हुद गेमासैंद हाइद यालाँव ओल्‍यो,’ है लिच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","फरी, “आव पाँर कैताराक हाकिमए ल्‍योक ओकेस्‍किन जे ताछे·च्‍यो, जेजूँनी पाँन्‍या गे ज़ गेलिज़्‍या,” है लिद यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","है जैद नो पाल्‍याराए नो पैसार रैद नो है यारादोव मिताव ज़ है यारादोनाकेर। है जैद नो पाँ हो छ्यामकिन ज़ यहूदीराए खार्ल प़ाइँदा ज़ फींजिके। ");
INSERT INTO kjl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","नकिन एघार जना येसुए उसिसर गालील खन्‍दल बाद येसुए है ओरादोव दाँदात बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","नङ येसुस यादैसिउ प़ाइँना ज़ उसिसर उखँत फुलुप्‍सिद धो दोकेर। तोबो ऩेब्‍लोए फरी, ‘आव ओल ज़ सैं माःक ओताव’ लिद जाँ यायुँ ओमाहुप्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","नाःत ज़ येसुए, “नाम नमलाव हक भरी परमेस्‍वरए ङाकुइत ज़ याद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","है जैद जे बाद प़ाइँ जातलाव मिँरालाई ङासिसर जैद ङाबाबु परमेस्‍वरए उमिननी, ङा ओज़ाए ङामिननी, छैंव पुरूसए उमिननी सछैंद, ");
INSERT INTO kjl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ङा जेलाई किताव किताव ङापैचिउ, जे होरालाई मनी हितावनी ज़ यारापैच्‍यो। आव ब सैंच्‍यो, आव जुक ओमाखेमा पै ङा जेस ज़ ङातारिज़्‍या,” है यादोक्‍यो।");
INSERT INTO kjl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","आलाव सर्सिउ परमेस्‍वरए ओज़ा येसु ख्रीसए चाव ओथा ज़। ");
INSERT INTO kjl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","यसैया अगमबक्ताए धर्मसास्‍त्रल किताव ओसरो हिताव ज़ ताके। होए ओसरो आव ज़, “ङाकत्‍वाल्‍यालाई नङ़ा नङ़ा परींद ङाईंज़्‍या। नजूँनी नोए नयेम तयार जैदींरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","नोए ओर्गा बनल अइ लिद उक़िज़्‍याव थास्‍रिज़्‍या, ‘हुरिज़्‍याव प्रभुए ओयेम बनैद गाँत्‍या गुँतीलाई सदाँचिके।’ ” ");
INSERT INTO kjl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","हिताव ज़ ऱील सछैंज़्‍याव तोबो यूहन्‍नाए बनल अइ लिद यासथैहुक्‍यो, “जेपापलाई ऱास्‍द जेयुँ परमेस्‍वरए ल्‍योदा फर्कैद ऱील सछैंसिचिके। हो ताकिन ची जेपापर क्‍याल्‍सिद परमेस्‍वरस खैवर तान्‍या जेले।” ");
INSERT INTO kjl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","नोए ओल्‍योक यहूदिया खन्‍दलावर स़ोनो यरूसलेम सहरलावर ओपो·स ज़ ओपाँ थैना याहुज़्‍याव। नोराए सु सु यादोव यापाप यूहन्‍नालाई है यादोक ते यूहन्‍नाए यर्दन भैल यासछैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्‍नाए ऊँतए ओसनए क्‍वा ओक्‍वाइसिज़्‍याव, ओवाँःत स्‍यालोए वाँःफो ओपो·सिज़्‍याव। नोए स॰ल॰र कोस्‍योर ओराकैज़्‍याव, ज़ेंराए राप उज़्‍युज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","नोए अइ लिद यासथैक्‍यो, “ङा ङाछींनी ङाकिन ओसक्ती ल्‍यो तोबो हुरिज़्‍या। ङा होए ओपोलाए ओच़ें घोम लिद पला·न्‍या स्‍यासो ब ङामाले। ");
INSERT INTO kjl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ङा जेलाई ऱील ङासछैंचिज़्‍या, होए परमेस्‍वरए छैंव उपुरूसनी सछैंचिरिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","नो बेलाक येसु मनी गालील खन्‍दलाव नासरत सहरनी यूहन्‍नाए ल्‍योक हुके। नो ब यूहन्‍नानी यर्दन भैल सछैंसिके। ");
INSERT INTO kjl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ऱीनी उपुलुसो प़ाइँना ज़ नम फैसिद परमेस्‍वरए उपुरूस कुइतम मिताव भुर्हुद ओक्‍याँत उच़ुसिज़्याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","हाःत ज़ नमतिन तोबो गा अइ लिद थास्‍के, “नँ ङायुँलाव ङाज़ा ज़। नँलाई रँःद ङायुँ होलाँ ताज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","येसु ननी पुलुस्‍द ओबाव प़ाइँना ज़ परमेस्‍वरए छैंव उपुरूसए तोबो साइँसुइँव पोङ लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","नल चालीस दिन पै बनलाव स्‍यारास उलिज़्‍याक सैतानए येसुलाई जाँचिउ ज़ नैक्‍यो। नाःत ज़ स्‍वर्गताव परमेस्‍वरए ओचाकर्‍यार येसुए ल्‍योक हुद समारिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","छींनी तछा ऱील सछैंज़्‍याव यूहन्‍ना क्‍योःसिके। नोलाई याक्‍योःव छ्यामकिन येसु गालील खन्‍दल हुद परमेस्‍वरए चाव ओथा अइ लिद यासथैक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“बेला यो·के, परमेस्‍वरए ओराज्‍या सो हुरिके। परमेस्‍वरए ल्‍योदा जेयुँर फर्कैद चाव थात जेयुँ सुहुप्‍चिके।” ");
INSERT INTO kjl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","तछा येसु गालील दह छ्यो छ्यो ओबाज़्‍याक सिमोन स़ोनो ओभाइ अन्‍द्रियासनी दहल जाल निरैःसिज़्‍याव निरँःक्‍यो। नोनी ङाँःर क्‍योःज़्‍यावनी निल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","येसुए नोनिलाई, “ङास हुचिन्‍के, जिनलाई ङाँःर जिन्‍राखिम्‍ज़्‍याव मिताव मिँर खिम्‍न्‍या ङाजैचिन्‍रिज़्‍या,” ");
INSERT INTO kjl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","है उनिदोव प़ाइँना ज़ नोनी निजालर ख्‍यानैद ओलस ज़ बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","जाँ होकसै याबावत फरी जब्‍दियाए ओज़ानी ओदाज्‍यु याकूब स़ोनो ओभाइ यूहन्‍नानी दोङ्गात च़ुसिद जालर निरातालिज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","बेहार ज़ नोनिलाई ब निखुल्‍क्‍यो। नोनी निबाबु जब्‍दियालाई ओबाहोर्‍यारास दोङ्गात ख्‍यानैद येसुस बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","नकिन येसु चार जना ओराखुलोरास कफर्नहुम सहरल बाकेर। ओल येसुए ऩासिन्‍या छ्याम ओतावत नलाव धर्मसास्‍त्र झ़िमल बाद परमेस्‍वरए ओपाँ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","नलावर येसुए ओपाँ थैद अचम्‍ब ताकेर, काराव ल्‍यो ताकिन होए सास्‍त्रीराए यारापैज़्याव मिताव माताद बनै हकस ओरापैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","नो बेलाक धर्मसास्‍त्र झ़िमल माचाव पुरूसए क्‍योःद ओनैज़्‍याव तोबो मिँ ब उलिज़्‍याव। नो बनै चिर चिर क़िद, ");
INSERT INTO kjl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“अ नासरतलाव येसु, गेस नखै काता उलिज़्‍याव? गेलाई खेम्‍ना नहुव रो? ङा नँलाई ङासरेस्‍निज़्‍या, नँ परमेस्‍वरए छैंव उमीं ज़,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","येसुए नोलाई हप्‍कैद, “झ्याउँ तालिनी, आवए ओक्‍याँतिन पुलुस्‍द बान्‍के,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","नो माचाव पुरूसए नो मिँलाई कारापनी कुरूप जैद चिर चिर क़िद पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","निताव रँःद प़ाइँ ज़ अचम्‍ब ताद या याल, “आव काता ओताव इताव? आवए ते साःरो पाँर नाः हकस ची ओरापैज़्याव ओल्‍यो। माचाव पुरूसरालाई ओराहप्‍कैक मनी ओपाँर यादोज़्‍याव ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","है जैद ‘येसुए निताव य़ेनर दोक्‍यो दी’ लिन्‍या गालील खन्‍द भरिल प़ाइँदा ज़ थास्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","धर्मसास्‍त्र झ़िमनी यापुलुसो प़ाइँना ज़ येसु चार जना उसिसरास सिमोन स़ोनो अन्‍द्रियासनी निझ़िमक बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","नक सिमोनए उमुइँज्‍यु ओजोरो हुद घ्याँसिद उलिज़्‍याव। उझ़िमक याबाव प़ाइँना ज़ ‘ओजोरो हुज़्‍या’ लिद येसुलाई है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","येसु नो ओजोरो हुज़्यावए ल्‍योक बाद उकुइनी क्‍योःद ओसोचोइव प़ाइँना ज़ ओजोरोए ऱास्‍क्‍यो। हाःत ज़ नोए येसु स़ोनो उसिसरालाई ज़्‍यावर जैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ऱिमदा ऱिमदा नम उनुपोत नलाव मिँराए याजोरो हुवर स़ोनो माचाव पुरूसराए क्‍योःद यारानैज़्‍यावरालाई येसुए ओल्‍योक यारारैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","सहरलाव मिँ भरी य़ामक छुइसिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","येसुए कुधु बेथाए क्‍योःद ओरानैज़्‍यावरालाई ब यासगराँक्‍यो, याक्‍याँत माचाव पुरूस ल्‍योरालाई ब याक्‍याँतिन माचाव पुरूसर पले·द्याद यासगराँक्‍यो। नो पुरूसराए येसुलाई यासरेस्‍ज़्‍यावए येसुए पाँव ज़ ओमाराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","छकाल्‍न्‍या ओमासँद ज़ येसु सोद झ़िमनी पुलुस्‍द साइँसुइँव पोक बाद परमेस्‍वरलाई ओपोंखारिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","सिमोन स़ोनो ओलस लिज़्‍यावराए ‘काना ओबाव’ लिद खिम्‍नाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","यादैक, “नँलाई प़ाइँए ज़ खिम्‍निज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","येसुए, “परमेस्‍वरए ओपाँ आजीलावरालाई वाज़ ङारासथैहुव माःक, हुजीदाङावराए जूँनी पाला ज़। हुचिके, नदा ब गेरासथैना,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","है जैद ननी बाद गालील खन्‍द भरिलाव यहूदीराए धर्मसास्‍त्र झ़िम झ़िमक बाद परमेस्‍वरए ओपाँ प़ाइँलाई ज़ यासथैक्‍यो। याक्‍याँत माचाव पुरूस ल्‍योरालाई ब माचाव पुरूसर पले·द याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","हो बेलाक ज़ तोबो कुऱी येसुए ल्‍योक हुद उखँत फुलुप्‍सिद, “अ प्रभु, ङाल्‍योदा नयुँ ओताकिन ङालाई सगराँन्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","येसुए उयुँ नाद नोलाई उकुइए छाप्‍द, “नल्‍योदा ङायुँ लिज़्‍या ज़, गराँनिके,” ");
INSERT INTO kjl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","है ओदोव प़ाइँना ज़, नो ओक्‍याँताव कुऱीए ऱास्‍द सोजोकाव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","येसुए नो गराँवलाई अइ लिद अऱैद बेहार ज़ परींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“आव नक्‍याँताव ङादोव य़ेन सुलाई ज़ है तारादोयो। बुरू नगराँव साचो ज़ ओल्‍यो लिन्‍या थ·रैव परींन्‍याए जूँनी पुजारीए ल्‍योक सतैंसिनाद मोसाए ओकानुनलाव मिताव चरैःन्‍यार चरैःनाके।” ");
INSERT INTO kjl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","खाली नो गराँवए झन ननी पुलुस्‍द ओक्‍याँत ताव भरी प़ाइँदा ज़ फींजैक्‍यो। है जैद येसुए उमिन बनै ओथासोए नजीलाव सहर नाखार जीदा बाव मादैद साइँसुइँवक लिनाके। हितावत ब मिँर प़ाइँनी ज़ ओल्‍योक दैसिहुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","तछा छींनी येसु कफर्नहुम सहरल उहुवत, ‘येसु उलिज़्‍याव झ़िमक हुके दी’ लिन्‍या थास्‍के। ");
INSERT INTO kjl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ओल्‍योक मिँर बनै सुइँः मासुइँः छुइसिहुद झ़िम भरी, मैरा भरी ब मासुइँःकेर। येसुए नोरालाई परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","नो बेलाक ज़ तोबो उखँ उकुइ सिउलाई चार जनाए घुर्द यारैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","खाली येसुए ल्‍योक मिँर बनै माहोल्‍या यातावए ओल्‍योक बान्‍या येम मादैद नोर थालात बाद झ़िम कप्‍सिउ फल्‍यार जाँवा हाइद सघ्वाँःद नो उखँ उकुइ सिउलाई ओझेलोङ्गारास येसुए ओङ़ाक झरैदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","येसुए नोराए यायुँ उहुबो रँःद नो उखँ उकुइ सिउलाई, “अ कान्‍छा, नपाप क्‍याल्‍सिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","नो है ओदोव नक लिज़्‍याव सास्‍त्रीराए थैद यायुँल यायुँल, ");
INSERT INTO kjl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“आव मिँ काराव ब्‍याँ इताव ओपाँज़्‍याव, परमेस्‍वरए उमिन ओबले·ज़्याव। मिँए ओपाप क्‍याल्‍न्‍या परमेस्‍वरकिन सु ची उलिज़्‍यावदा?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","हाःत ज़ येसुए नोराए यायुँलाव पाँ सैंद, “जे काराव जेयुँल नै जेलिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","नो घ्याँस्यालाई, ‘नपाप क्‍याल्सिके’ है दान्‍या सैं ‘सोद नझेलोङ्गार घुर्द बान्‍के’ है दान्‍या काताकाव सजालो उलिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","अब ङा मिँ मिन्‍सिद हुवए आव मानुवात पाप क्‍याल्‍न्‍या ङाकुइत उलिज़्‍याव सैं ओमालिज़्‍याव, चिऊचिके,” है दाद नो उखँ उकुइ सिउलाई, ");
INSERT INTO kjl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ङा नँलाई है ङादींज़्‍या, नँ सोद नझेलोङ्गार घुर्द नझ़िमदा बान्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","नो उखँ उकुइ सिउ थर च्‍याँःसिद ओझेलोङ्गार घुर्द याङ़ाकिन पुलुस्‍द बाके। निताव रँःद प़ाइँ ज़ अचम्‍ब ताद, “इताव ते खर्क ज़ गेमारँःए,” लिद परमेस्‍वरए उमिन सघ्‍योःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","नकिन येसु फरी दह छ्योक बाके। ओल्‍योक मिँर बनै माहोल्‍या याहुज़्‍याव। नोरालाई परमेस्‍वरए ओपाँ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ननी पुलुस्‍द ओबाज़्‍याक तोबो अल्‍फयसए ओज़ा लेबीलाई सिर्मा स्‍यो·न्‍या अद्दाक च़ुसिद उलिज़्‍याव रँःद नोलाई, “ङास हुन्‍के,” है ओदोव प़ाइँना ज़ नो च्‍याँःसिद येसुए उछींत बाके। ");
INSERT INTO kjl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","नकिन जाँवाक येसु उसिसरास लेबीए उझ़िमक बाद ज़्‍यान्‍याए जूँनी च़ुसिकेर। नो बेलाक यास सिप ज़्‍युज़्‍यावर सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापी है यारादोज़्‍यावर बनै कुधु ज़ यालिज़्‍याव। निताव मिँर येसुस बाऱिज़्‍यावर कुधु ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","नितावरास येसुए सिप उज़्‍युज़्‍याव फरिसीरासकाव सास्‍त्रीराए रँःद येसुए उसिसरालाई, “जेगुर्बा काराव निताव सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापीरास सिप उज़्‍युज़्‍याव?” है यारादोज़्‍याव ");
INSERT INTO kjl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","येसुए थैद, “याजोरो माहुज़्‍यावरालाई सगराँन्‍या मिँ माचाहिए, याजोरो हुज़्‍यावरालाई वाज़ चाहिज़्‍या। हिताव ज़ ङा मनी ‘गे धर्मी’ है लिज़्‍यावराए जूँनी ङाहुव माःक, ‘गे पापीर ज़’ है लिज़्‍यावराए जूँनी ङाहुव ची।” ");
INSERT INTO kjl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ख्‍वा मिँर ऱील सछैंज़्‍याव यूहन्‍नाए उसिसर स़ोनो फरिसीरासकावर याउपासिज़्‍याव रँःद येसुए ल्‍योक हुद, “यूहन्‍नाए उसिसर स़ोनो फरिसीर ते उपासिज़्‍यार, नँ नसिसर काराव यामाउपासिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","येसुए नोरालाई, “जन्‍तीर ब्‍याहोल्‍यास यालेवा पै याउपासिज़्‍याव रो? ब्‍याहोल्‍या यास ओलेवा पै माउपासिर। ");
INSERT INTO kjl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","खाली जो छ्यामकिन ब्‍याहोल्‍यालाई छुतैर, हो छ्यामकिन वाज़ उपासिन्‍या लेर,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","फरी, “सुए ज़ ओरे छिबो क्‍वालाई साःरो क्‍वाए मातालिउ। ओतालिकिन नो साःरोए पुराँदोलाई ओल्‍योदा स़ेल्‍द झन ज़ चीज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","स़ोनो, साःरो दाखमद्य पुराँदो प़िर्गुलल सुए ज़ माझाःर। म़ानी उस॰ए प़िर्गुललाई सुफुद दाखमद्य ब भोन्‍या ले, प़िर्गुल ब खेर ज़ बान्‍या ले। है जैद साःरो दाखमद्य साःरो प़िर्गुलल वाज़ झाःर।” ");
INSERT INTO kjl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","हो बेलाक तछा ऩासिन्‍या छ्याम येसु उसिसरास एँः खार्लाव घ्याँ याबाज़्‍याक उसिसराए बाला फ्या·द याकैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","फरिसीराए येसुलाई, “चिऊके, नसिसराए ऩासिन्‍या छ्याम मादान्‍या य़ेन काराव यादोज़्याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","येसुए, “धर्मसास्‍त्रलाव सर्सिउ दाऊद राजा ओनैंरास याकरेकाव यादोव य़ेन जेमाप़रिए रो? ");
INSERT INTO kjl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","दाऊद प्रधान पुजारी अबियाथारए ओपालाक ध्‍यान झ़िमल पसिद परमेस्‍वरलाई चरैःसिउ भरेस हाइद ओल मनी ज़्‍युक्‍यो, ओनैंरालाई मनी याएक्‍यो। नो भरेस पुजारीराए वाज़ ज़्‍यान्‍या ओताज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","जे आव ब सैंच्‍यो, मिँर ऩासिन्‍या छ्यामए जूँनी जैसिउ माःक, ऩासिन्‍या छ्याम मिँराए जूँनी ज़ जैसिउ ची। ");
INSERT INTO kjl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","है जैद ङा मिँ मिन्‍सिद हुव ऩासिन्‍या छ्यामकिन ब घेप्‍पा ज़ ङालिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","फरी तछा येसु धर्मसास्‍त्र झ़िमल बाके। नल उकुइ थँव मिँ तोबो उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","नल लिज़्‍यावराए येसुए ओपाहा झाःद्यान्‍याए जूँनी ऩासिन्‍या छ्याम नो उकुइ थँवलाई मासगराँज़्‍याव ब्‍याँ लिद चिऊद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","नाःत ज़ येसुए नो उकुइ थँवलाई, “आक हुद च्‍याँःसिन्‍के,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","नोरालाई, “ऩासिन्‍या छ्यामकाव य़ेन चाव जैन्‍या सैं माचाव जैन्‍या? मिँलाई बाँचैन्‍या सैं बले·न्‍या? कानुनए कै उलिज़्याव?” है ओरादोक ते, सुए ज़ घाइ मालिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","येसुए, काता नाः यायुँ खावर यालिज़्‍याव लिद उयुँ माचाव दाद उरिसए प़ाइँलाई तछ्योनी चिऊद नो उकुइ थँवलाई, “नकुइ तङ्गैके,” है ओदोक ते, उकुइ ओतङ्गैव प़ाइँना सोजोकाव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","नो फरिसीराए निताव रँःद लाँःदा पुलुस्‍द, ‘आवलाई कै जैद सैःन्‍या ओताव?’ लिद बेहार ज़ हेरोद राजासकावरास गुमुस्‍ता दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","येसु उसिसरास ननी हाइसिद गालील दह जीदा बाकेर। नल कुधु मिँर गालील स़ोनो यहूदिया खन्‍दनी उछींत याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","येसुए ओय़ेनर थैद ख्‍वार यरूसलेम सहरनी, ख्‍वार इदुमिआ खन्‍दनी, ख्‍वार यर्दन भै होफतिन, ख्‍वार तुरोस स़ोनो सीदोन जीनी ब याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","है जैद मिँर बनै काला मुलु ताद ओललाई बनै छिला छिला याजैवए उसिसरालाई दोङ्गा तोबो रैव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","मिँर बनै कुधु ओरासगराँवए याजोरो हुज़्‍याव भरिए येसुलाई छाप्‍न्‍याए जूँनी बनै याछुइसिहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","जोक ब माचाव पुरूसराए येसुलाई यारँःव प़ाइँना होक ज़ ओङ़ाक फुलुप्‍सिद, “नँ परमेस्‍वरए ओज़ा ज़,” है लिद याक़िज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","खाली येसुए नोरालाई, “ङा परमेस्‍वरए ओज़ा ज़ लिन्‍या सुलाई ज़ है तारादोच्‍यो,” है ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","नकिन येसु तोबो दाँदात पुलुस्‍द उयुँलाव मिताव मिँ भरिलाई ओराखुल्‍क नोर ओल्‍योक हुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","नो भरिरानी बाह्र जना ओलस लिन्‍या ओसाचीर जैद नोरालाई चाव था सथैन्‍या, ");
INSERT INTO kjl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","स़ोनो माचाव पुरूसर पले·न्‍या हक ब याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","नो बाह्र जनाराए यामिनर आवर ज़ — सिमोन (छींनी होए उमिन पत्रुस जैदिक्‍यो), ");
INSERT INTO kjl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्‍दियाए ओज़ानी याकूब स़ोनो यूहन्‍नानी (छींनी नोनी निपाँःच्‍या ‘बोअनर्गेस’ नैद निएक्‍यो। नोए ओअर्थ ‘गर्जिज़्‍यावनी’।) ");
INSERT INTO kjl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","नकिन अन्‍द्रियास, फिलिप, बारथोलोमाइ, मत्ती, थोमा, अल्‍फयसए ओज़ा याकूब, थेदियस, देसभक्ता सिमोन, ");
INSERT INTO kjl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","स़ोनो छींनी येसुलाई धोका याज़्‍याव यहूदा इस्‍करियोत। ");
INSERT INTO kjl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","येसु फरी उझ़िमक उहुक मिँर बनै काला मुलु याहुज़्‍यावए उसिसरास ज़्‍यावर ब ज़्‍युव मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ख्‍वाराए येसुलाई ‘दासानी बिसा ताज़्‍या’ है ब यादोज़्‍याव। ओक्‍याँदाङावराए फरी निताव पाँर थैद येसुलाई च़िहुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","यरूसलेमनी हुव सास्‍त्रीराए मनी, “आवए ओक्‍याँत ते माचाव पुरूसराए याघेप्‍पा बालजिबुल च़रिद ले। होए उमिननी ज़ माचाव पुरूसरालाई ओरापले·ज़्‍याव ची,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","येसुए नोरालाई ओल्‍योदा खुल्‍द अइ लिद घर्ती झाःद याएक्‍यो, “सैतानए ओल सैतानलाई कै जैद ओपले·ज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","तोबो राज्‍यालाव मिँर या या यामाखैकिन नो राज्‍या माथ॰रिए। ");
INSERT INTO kjl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","हो मिताव ज़ तोबो झ़िमलावर या या यामाखैकिन चितराँ पुतराँ तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","है जैद सैतानए ओराज्‍यालावर ब या या माखैद तँदा तँदा याजैसिकिन नोर मनी माथ॰रिद यामिन ज़ म़ान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","फरी तोबो ओर्सा ल्‍यो मिँलाई ङ़ादा यामाकिवा पै उझ़िम पा·द ओजा-यार हाइद मालाँधुर। ");
INSERT INTO kjl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ङा जेलाई साचो है ङादाचिज़्‍या, मिँराए जो पाप यादोदी ब, परमेस्‍वरए उमिन याबले·दी ब नोराए यापाप क्‍यालो दैसिए। ");
INSERT INTO kjl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","खाली जोए परमेस्‍वरए छैंव उपुरूसए उमिन बले·दिज़्‍याव, होए ओपाप क्‍यालो मादैसिए। नितावए ओपाप खर्क ज़ माखेमे,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","नो सास्‍त्रीराए ‘येसुए ओक्‍याँत माचाव पुरूस च़रिद ले’ है यादोज़्‍यावए येसुए आव पाँ ओरासथैव। ");
INSERT INTO kjl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","हाःत ज़ येसुए ओआमा स़ोनो ओभाइर हुद लाँःक च्‍याँःसिद येसुलाई क़िउ यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","झ़िमल येसुए ओलापक मिँर माहोल्‍या च़ुसिद यालिज़्‍याव। है जैद नो क़िउ यारापरींवराए, “लाँःक नआमा स़ोनो नभाइर नँस दैसिना हुद लेर,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","येसुए, “ङाआमार ङाभाइर कितावर?” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ओलापक च़ुसिद लिज़्‍यावराए ल्‍योदा भाल्‍सिद, “चिऊचिके, ङाआमार ङाभाइर आवर ज़। ");
INSERT INTO kjl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","जोराए परमेस्‍वरए ओपाँ थैद दोज़्‍यार, होर ज़ ङाआमार ङाभाइ बैंनीर,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","फरी तछा येसु दह छ्योक च़ुसिद परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ओल्‍योक मिँर बनै ल्‍यो माल्‍यो यातावए येसु दोङ्गाल च़ुसिद दोङ्गालाई ऱील जाँ होकसै लाँक्‍यो। माहोल्‍या भरी ओङ़ाक दह छ्योक च़ुसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","याच़ुसिउत येसुए नोरालाई ओपाँ घर्ती झाःद यासथैक्‍यो। तोबो ओरासथैव आव ज़, ");
INSERT INTO kjl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“थैचिके, तोबो मिँ ओएँःल धुर वास्‍ना बाके दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","धुर ओवास्ज़्याक ख्‍वा येम जीदा परिके दी। नो येमलाव परिउ बाज़ाराए ज़्‍युकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ख्‍वा धुर गम छ्या छ्या ल्‍यो ओदादरत परिके दी। नत गम छ्या छ्या वाज़ ल्‍यो ओतावए हतप्‍त ज़ परीके दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","खाली निमी ओसोराक उहुवत ओजरा नाम जींल ओमाल्‍योए च्‍याकराप चिकुरूप थँके दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","फरी ख्‍वा धुर ज़ुर ऱमराए खार्ल परिके दी। नोलाई ज़ुर ऱमराए गाल्‍द ओसै माल्‍यो दाँथ्‍या ताके दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","फरी ख्‍वा धुर ते चाव गमस्‍याल परिके दी। नो बनै चावस परीद झेंःद ओसै बनै झाःद ख्‍वात तीस, ख्‍वात साथी, ख्‍वात सय दोबोर यासै झाःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","नो माहोल्‍यार याबाव छींनी बाह्र जना उसिसर स़ोनो ओलस बाऱिज़्‍यावराए, “नो नझाःव घर्तीए ओअर्थ काता?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","येसुए, “जेलाई वाज़ परमेस्‍वरए ओराज्‍यालाव कप्‍सिउ पाँर छर्लङ्ग सतैंसिउ लिज़्‍या, उपुर्कावरालाई ते घर्ती मिताव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","है जैद ज़, ‘नोराए रँःन्‍या ते रँःज़्‍यार, मासरेस्‍धुर। थैन्‍या ते थैज़्‍यार, मातीधुर। नितावर यामाताव ताकिन परमेस्‍वरए ल्‍योदा यायुँ फर्कैद यापाप ब क्‍याल्‍सिखेहो।’ ” ");
INSERT INTO kjl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","नकिन येसुए नोरालाई है यादोक्‍यो, “काता जे मनी नो ङाझाःव घर्तीए ओअर्थ जेमासैंए रो? छुत झन कै जैद जेतीधुके? ");
INSERT INTO kjl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","धुर वास्‍ज़्‍याव, परमेस्‍वरए ओपाँ सथैज़्‍याव मिँ ज़। ");
INSERT INTO kjl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","नो येमलाव परिउ भरी जोए परमेस्‍वरए ओपाँ ओथैव प़ाइँना सैतान हुद उयुँलाव वास्‍सिउ पाँ भरी स्‍याप सिप जैद लाँदिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","हो मिताव ज़ नो ओदादरताव परिउ भरी जोए परमेस्‍वरए ओपाँ थैद बेहार ज़ तीद खुसी ब ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","खाली नो मिँ परमेस्‍वरए ओपाँत उयुँल ओजरा माल्‍यो मिताव ओतावए नो पाँ छ्यावा पै वाज़ रहिज़्‍या। नो पाँनी नोए ओक्‍याँत खिरीर उपसिकिन दुखर ओदैकिन नो पाँत उयुँ क़्याज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","नो ज़ुर ऱमराए खार्लाव परिउ भरी आव ज़, नोराए परमेस्‍वरए ओपाँ ते थैज़्‍यार, ");
INSERT INTO kjl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","खाली धन सम्‍पतीदा यायुँ थू जैद ‘आव गेजिउत कै तान्‍या ओताव, कातानी थाँतस लिन्‍या’ लिद व़ीनी फुइ ब लिज़्‍यार। है जैद नितावराए परमेस्‍वरए ओपाँलाई यागालोए नो पाँ ओसै माझाःज़्याव ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","नो चाव गमस्‍याल परिउ भरी आव ज़, जोए परमेस्‍वरए ओपाँ थैद चावस रैद ओसै झाःज़्‍याव धुर स्‍यासो ख्‍वात तीस, ख्‍वात साथी, ख्‍वात सय दोबोर झाःज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","येसुए फरी तोबो घर्ती अइ लिद झाःक्‍यो, “सुए ज़ ल़ोसै तैंःद जाए माकबो, खात खँल माम़ोंव। दिउ बाल्‍न्‍यात ची झाःव। ");
INSERT INTO kjl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","हिताव ज़ मारैंःव भरी तछा रैंःन्‍या ज़ ले, कप्‍सिउ भरी ब पलाँवल तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","आव पाँत जोए थैन्‍या उयुँ लिज़्‍या, ओर्ना घ्याँ जैद ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","फरी नोरालाई, “जेथैज़्‍याव भरी बनै धिद थैच्‍यो। किताव गोइँनी जेगोइँज़्या, जे मनी हिताव गोइँनी ज़ दैन्‍या जेले, झन कुधु ब दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","है जैद जोए धिद थैज़्‍याव, होए झन ज़ तीधुन्‍या ले। जोए चावस माथैव, होए झन ज़ थैन्‍या युँ मादाद ङ़ादाङाव ओथैव ब ओपो·स ज़ म़ान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","फरी, “परमेस्‍वरए ओराज्‍या तोबो मिँए ओएँःल धुर ओवासो मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","नोए धुर ओवासोत स्‍याँन्‍या बेलाक स्‍याँज़्‍या, सोन्‍या बेलाक सोज़्‍या। उपुर काता य़ेन ज़ ओमादोदी ब नो धुर ओलनी ज़ परीद झेंःज़्‍या। कै जैद ओताज़्‍याव ओल ब मासैंव। ");
INSERT INTO kjl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","गमए ओल ज़ नो धुरलाई सपरीज़्‍याव। है जैद नो धुर ङ़ादा तआखला ऩेआखला ताद झेंःद से·ज़्‍या, नकिन ओबाला ब झाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ओसै उमींःवत नो वासोए ओराँकासीस हुद ओएँःलाव अन भरी एन्‍ज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","येसु फरी, “परमेस्‍वरए ओराज्‍या किताव उलिज़्‍याव, किताव अर्थनी पलास्‍द ङायाचिके लिक ते, ");
INSERT INTO kjl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","परमेस्‍वरए ओराज्‍या तोबो बाजीए उधुर स्‍यासो लिज़्‍या। नो धुर प़ाइँरानी तकेज़ा ओतादी ब बारील रूपिक, ");
INSERT INTO kjl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","परीद ओघ्‍योःवत नो बारीलाव ङ़ैंराकिन प़ाइँरानी घेप्‍पा ताद ओखारर ब झाःज़्‍याव। नत नमताव भुर्ज़्‍याव बाज़ार ओछैंयाल सिपर जैद बासिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","मिँराए परमेस्‍वरए ओपाँ घतीधुरक लिद येसुए इताव कुधु घर्तीर झाःद ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","घर्ती ओमाझाःवा पै ओमारासथैज़्‍याव। याबातङ याताक उसिसरालाई वाज़ ओअर्थ भरी पलास्‍द ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","हो छ्याम ऱिमक येसुए उसिसरालाई, “दह होफत गेबाया,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","उसिसर नो माहोल्‍यारास भाःसिद येसु च़ुसिद उलिज़्‍याव दोङ्गाल पसिद बाकेर। यास बाज़्‍यावर छुत दोङ्गार ब यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","याबाज़्‍याक उमँःजानी घ्‍योःव हुरी बतास हुद ऱीए ओछल्‍कार दोङ्गाल पसिद नोलाई गदैवा गदैवा जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","हो बेलाक येसु दोङ्गाए ओर्मेःत गुम जैद ङ़ल्‍द उलिज़्‍याव। उसिसराए येसुलाई सोचोइद, “गुर्बा, खदम ज़ गेतारिके, काराव घाइ नमालिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","येसु सोद बतासलाई सिङार्द ऱीलाई ब “च़िम दोके,” है ओदोव प़ाइँना ज़ बतास ब थकनिके, ऱी ब अदिके। ");
INSERT INTO kjl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","हाःत ज़ येसुए, “जे काराव जेछे·ज़्‍याव, कै जैद जेयुँ ओमाहुप्‍ज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","नोर बनै छे·द या याल, “आव किताव मिँ ओताव? बतासर ऱीराए ब ओपाँ यादोज़्‍याव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","येसु उसिसरास दह होफताव गेरासेनस यादोज़्‍याव पोङ केस्‍द, ");
INSERT INTO kjl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येसु दोङ्गातिन उझरिउ प़ाइँना ज़ माचाव पुरूसए क्‍योःद ओनैज़्‍याव तोबो मिँ खादर पोनी पुलुस्‍द येसुए ल्‍योक दैसिहुके। ");
INSERT INTO kjl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","नो मिँ एकतार खादर जीदा ज़ उलिज़्‍याव। नोलाई सुए ज़ साँगलए ब यामाकिधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","कुधु पाला साँगलए किद, हलाल याझाःदी ब, साँगलर पाता पत॰ ओराफ्या·ज़्‍याव, हलार ब कुतु कुतु केःद ओराख्‍याज़्‍याव। है जैद सुए ज़ यामाहारैधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","नो लाकनी रील खादर जीदा, हाँ जीदा चिर चिर क़िद लुँ लुँराए उरूम्‍सिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","नोए येसुलाई तादानी उरँःव प़ाइँना ओल्‍योक धोंःहुद उखँत फुलुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","बनै चोइस, “अ येसु, माहान परमेस्‍वरए ओज़ा, ङास नखै काता उलिज़्‍याव? परमेस्‍वरए उमिननी है ङादींज़्‍या, ङालाई दुख तायाँ,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","नो माचाव पुरूसलाई येसुए ङ़ादा ज़, “ए माचाव पुरूस, आव मिँए ओक्‍याँतिन पुलुस्‍द बान्‍के,” है दाद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","येसुए फरी, “नमिन कै?” है ओदोक ते, “ङामिन फौजी, गे कुधु ज़ गेलिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","नोराए, “गेलाई आव पोनी तापले·सियो,” है लिद बिन्‍ती दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","नो बेलाक ज़ नक तोबो दाँदात ऊर तबगाल यालाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","नो माचाव पुरूसराए, “गेलाई बुरू नो ऊराए क्‍याँत बाव यासिके,” लिद बिन्‍ती यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","येसुए भैंःद याएक्‍यो। है जैद नो माचाव पुरूसर नो मिँए ओक्‍याँतिन पुलुस्‍द ऊराए क्‍याँत बाकेर। हो प़ाइँना ज़ ऊ भरी बूलिद दाँदातिन सुइँःकिनाद दहल ज़ो·द प़ाइँ ज़ स़ुद सिकेर। नो ऊर ऩेहजाराकाव बगाल याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","निताव रँःद नो ऊ गावलार धोंःनाद सहर जीदा, नाखार जीदा बाद नो यारँःव भरी है यारादोकेर। नो पाँ थैव भरी कै ओताव लिद चिऊना हुवर, ");
INSERT INTO kjl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","येसुए ल्‍योक याबाक नो माचाव पुरूसराए याऱासो मिँ ओक्‍वार क्‍वाइसिद सोजोकाव ज़ च़ुसिद उलिज़्‍याव रँःकेर। निताव रँःद नोर छे·केर। ");
INSERT INTO kjl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","नो चिऊना हुवरालाई, नो य़ेन रँःव भरिए, “बूलिउलाई इताव इताव ताके, ऊरालाई इताव इताव ताके,” लिद है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","है जैद नो गेरासेनस खन्‍दलाव मिँराए येसुलाई, “आनी पुलुस्‍द बान्‍के,” है लिद बिन्‍ती दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","येसु दोङ्गाल उपसिज़्‍याक नो माचाव पुरूसराए याऱासो मिँए, “ङालाई ब नँस लाँनाके,” है लिद बिन्‍ती ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","येसुए भैंःद मायाद, “बुरू नँ नझ़िमदा बाद ननैं नमेंरालाई, ‘परमेस्‍वरए ङालाई उयुँ नाद ङाजूँनी आःल्‍दिउ य़ेन दाद्याँक्‍यो,’ है लिद यासथैनाके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","है जैद नो मिँ देकापोलिस खन्‍दल बाद ओल उजूँनी येसुए ओदोव य़ेन यासथैक्‍यो। थैज़्‍याव भरी अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","येसु दोङ्गाल ओल्‍द दह आफत उहुत मिँर बनै माहोल्‍या दुप्‍सिहुकेर। ओल दह छ्योक ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","नाःत ज़ धर्मसास्‍त्र झ़िमलाव तोबो याघेप्‍पा याइरस यादोज़्‍याव नक हुद येसुलाई रँःद उखँत फुलुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ज़िम्ज़ा मेंमा ङाज़ा सिउ पैंज़्‍याव। नँ हुद नोए ओक्‍याँत नकुइ नैद नएकिन नो गराँद बाँचिन्‍या ले,” लिद बिन्‍ती ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","येसु नोस ज़ बाके। मिँर बनै माहोल्‍या येसुए उछीं उछीं येमत बनै याछुइसिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","नो माहोल्‍याराए याखार्ल तोबो बाह्र बर्स भरी ओक्‍याँतिन झी भोन्‍या बेथाए क्‍योःद ओनैज़्‍याव मेंमा ब उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","नो मेंमा सगराँसिन्‍याए जूँनी वासः जैज़्‍याव कुधुराए ल्‍योक ओलसकाव लिज़्‍याव भरी ओपो·स ज़ खेम्‍द ब जात्त ज़ मागराँके, झन ज़ हया गती तानाद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","है जैद नोए येसुए ओदोव य़ेन भरी थैद माहोल्‍याराए खार्ल पसिद येसुए उछींनी हुद ओक्‍वात छाप्‍दिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","नो मेंमाए उयुँल उयुँल, “येसुए ओक्‍वा वाज़ छापो ङादैकिन आव बेथानी गराँन्‍या ङाले,” है उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ओछापो प़ाइँना नो झी भोन्‍या बेथा ब गराँके, ओगराँव ओक्‍याँत ब दार्सिके। ");
INSERT INTO kjl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","हाःत ज़ येसुए ओक्‍याँतिन सगराँन्‍या सक्ती पुलुस्‍द ओबाव दार्सिद नो माहोल्‍याराए खार्ल उछींदा फर्किद, “ङाक्‍वात सुए ओछापो?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","उसिसराए, “आः याछुइसिज़्‍यावल कै जैद ‘सुए ओछाप्‍नाव,’ है नलिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","येसुए झन ‘सुए ओछाप्‍नाव?’ है लिद आदा होदा याचिऊक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","नो मेंमा ‘ङागराँके’ लिन्‍या सैंद ओछ्याचेए गूए गूए येसुए उखँत फुलुप्‍सिद ओक्‍याँत ताव पाँ भरी ओपो·स ज़ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","येसुए नोलाई, “अ माँ, ङालाई नयुँ नसुहुबोनी ज़ नगराँके। चावस बानी। नबेथाए ऱास्‍निक्‍यो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येसु नो मेंमास ओपाँज़्‍याक ज़ धर्मसास्‍त्र झ़िमलाव याघेप्‍पा याइरसए उझ़िमनिकावर हुद याइरसलाई, “गुर्बालाई काराव हत्‍या यान्‍या, नज़ा सिधुके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","नोराए यापाँ येसुए माथैव जैसिद याइरसलाई, “नयुँ तासतेयो, नयुँ वाज़ उहुप्‍क,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","छुतरालाई ओलस बाव मायाद पत्रुस, याकूब स़ोनो याकूबए ओभाइ यूहन्‍नारालाई वाज़ यालाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","नो धर्मसास्‍त्र झ़िमलाव याघेप्‍पाए उझ़िमक याकेसोत मिँर बनै चिर्लनी बिर्ल याघर्ज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","येसु नो झ़िमल पसिद, “काराव इताव च्‍याउँनी म्‍याउँ लँःसिद जेघर्ज्याव? ल़ुज़ा मासिए, अइज़ ङ़ल्‍द ले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","येसुलाई हसैकेर। हाःत ज़ येसुए मिँ भरी लाँःदा परींद नो ल़ुज़ाए ओबाबु ओआमानी स़ोनो ओलस लिज़्‍याव स़ोम्‍लो उसिसरालाई वाज़ लाँद ल़ुज़ाए उकुन्तील पसिद, ");
INSERT INTO kjl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","नो ल़ुज़ालाई उकुइनी क्‍योःद, “तालिता कूमी,” है दोक्‍यो। (तालिता कूमीए ओअर्थ — अ बुची, सोनिके।) ");
INSERT INTO kjl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","हो प़ाइँना ज़ नो ल़ुज़ा थर च्‍याँःसिद आदा होदा लिके। नो ल़ुज़ा बाह्र बर्सवाकाव ओल्‍यो। निताव रँःद नोर बनै अचम्‍ब ज़ ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","नकिन येसुए, “आव य़ेन सुलाई ज़ है तारादोच्‍यो,” है लिद अर्थैद, “आवलाई ज़्‍यान्‍यार जैदिचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","येसु ननी पुलुस्‍द ओल ओनाखारल ज़ बाके। उसिसर मनी ओलस ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ऩासिन्‍या छ्याम उहुवत धर्मसास्‍त्र झ़िमक बाद येसुए परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। नो पाँ थैज़्‍यावर बनै अचम्‍ब ताद, “आवए इताव अचम्‍बलाव पाँर, अचम्‍बलाव सक्तीर कातानी ओरैव? आवए ओदैव किताव ग्‍यान ओल्‍यो! ");
INSERT INTO kjl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","काता, आव नो सीं त़ुज़्‍याव माःक रो? आव नो गेस लिज़्‍याव मरियमए ओज़ा ज़ सानी। आव ते याकूब, योसेफ, यहूदा स़ोनो सिमोनराए यादाज्‍यु ज़ सानी। ओबैंनीर मनी गेस ज़ लिज़्‍यार,” है लिद जाँ सोव माँःती जैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","येसुए नो यापाँ सैंद, “अगमबक्तालाई ओल ओनाखारलावर स़ोनो ओक्‍याँदाङावराए वाज़ ओमान नैद माएर, उपुर्कावराए ते नैदिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","है जैद येसु नक उलिज़्‍याक अचम्‍बलाव य़ेनर ब कोसै मादोधुक्‍यो, खाली तोबो ऩेब्‍लो याजोरो हुवरालाई वाज़ याक्‍याँत उकुइ नैद्याद यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ओललाई यायुँ ओमाहुप्‍ज़्‍यावए येसु अचम्‍ब ताके। येसु ननी पुलुस्‍द नाखार नाखार बाद परमेस्‍वरए ओपाँ यासथैनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","हाः बेलाक बाह्र जना उसिसरालाई ओल्‍योक खुल्‍द नोरालाई ऩेबरें ऩेबरें जैद माचाव पुरूसर पले·न्‍या सक्तीर याद यापरींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“येमत जेबाक जेस काता ज़ तालाँच्‍यो। जेकुइताव झुइस वाज़ बाच्‍यो। अर्नी तादी ब, झ़ैं तादी ब, जेवाँःत पैसा तादी ब, काता ज़ तालाँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","जेखँताव पोला स़ोनो जेक्‍याँताव क्‍वास वाज़ बाच्‍यो,” है लिद याअर्थैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","फरी, “जो झ़िमक जेपसिज़्‍या नो नाखारनी जेमापुलुसा पै नक ज़ लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","फरी जेबाव पोल जेलाई ल्‍यो मायाद जेपाँ ब थैव यामाभैंःकिन नो पोनी जेपुलुस्‍क नोरालाई चेतावनी यान्‍याए जूँनी जेखँताव गालो धुइरो ब नल ज़ थरैद ख्‍यानैद याराएच्‍यो,” है लिद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","है जैद नोर ननी पुलुस्‍द बाद प़ाइँलाई ज़, “मादान्‍या जेदोज़्‍याव भरी ऱास्‍द जेयुँ परमेस्‍वरए ल्‍योदा फर्कैचिके,” है लिद यारासथैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","मिँराए याक्‍याँताव माचाव पुरूसर मनी कुधु ज़ यारापले·केर, याजोरो हुवरालाई ब परमेस्‍वरए उमिननी म़ास थीद नोरालाई यारासगराँकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हाः बेलाक येसुए उमिन बनै ओथास्‍नावए हेरोद राजाए मनी ओय़ेनर थैक्‍यो। येसुए उजूँनी ख्‍वाराए, “आव ते ऱील सछैंज़्‍याव यूहन्‍ना जन्‍द ची उहुव सा। है जैद ज़ ताखेहो नाः सक्तीलाव य़ेनर ओदोज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ख्‍वाराए फरी, “आव ते एलिया ची सा।” ख्‍वाराए फरी, “भाःकाव अगमबक्ता मितावर फरी तोबो उपुलुसो ताखेहो,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ओल हेरोदए फरी निताव पाँर थैद, “ओहो! ओङ़ै च़म्‍द ङासैःव यूहन्‍ना ते जन्‍द ची हुके काना,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","नो हेरोदए ङ़ादा ओभाइ फिलिपए ओज्‍या हेरोदियासए ओपाँनी यूहन्‍नालाई क्‍योःद किद झ्यालखानाल झाःद ओनैज़्‍याव। हेरोदए हेरोदियासलाई ओरैवए, ");
INSERT INTO kjl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","यूहन्‍नाए नो राजालाई, “नँ नभाइए ओज्‍यालाई रैन्‍या माताए,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","हेरोदियासए यूहन्‍नालाई रँःद उरिस चोद, ‘आवलाई कै जैद ङासैःके’ लिद उयुँल ओनैज़्‍याव। खाली सैःन्‍या मौका ओमादैताव। ");
INSERT INTO kjl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ओल राजाए ते यूहन्‍नालाई बनै सतलाव धर्मी मिँ ज़ थ·रैद ओछे·ज़्‍याव। है जैद नोए यूहन्‍नालाई जोगोइद नैक्‍यो। यूहन्‍नाए ओपाँत फरी उयुँ आँचानी पाँचा ओताज़्‍यावत ब सर्बा थैन्‍या युँ ओदोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","तछा राजा हेरोद उजर्मिउ छ्याम मानिन्‍या उहुवत ओज्‍याए मौका छुपिक्‍यो। नो छ्याम मानिन्‍याए जूँनी बनै घ्‍योःव भत्‍यार जैद घ्‍योःव घ्‍योःव ओकर्मचारीर, फौजीलाव ओअफिसरर स़ोनो गालीललाव घ्‍योःव घ्‍योःव मिँरालाई याखुल्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","नो बेलाक ज़ हेरोदियासए मेंमा ओज़ा नो भत्‍यार ज़्‍युना हुवराए याङ़ाक बाद स़्याद याएक्‍यो। राजा हेरोद स़ोनो ओपाहुनार बनै खुसी ताद राजाए नो ल़ुज़ालाई, “नँ जो नपैंज़्‍या ङास ऩिके, हो ज़ ङायाँ,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","फरी, “नँ नपैंकिन तभा ङाराज्‍या तादी ब ङायाँ,” है लिद किर्‍या झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","है जैद नो ल़ुज़ा ओआमाए ल्‍योक बाद, “आमा, ङा काता ङाऩिके?” है ओदोक ते, ओआमाए, “ऱील सछैंज़्‍याव यूहन्‍नाए ओङ़ै ऩिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","नो ल़ुज़ा बेहार ज़ राजाए ल्‍योक बाद, “ङालाई ऱील सछैंज़्‍याव यूहन्‍नाए ओङ़ै ताथील झाःद आख ज़ याँके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","राजाए नो पाँ थैद उयुँर स्‍यासे सतेक्‍यो। खाली ओपाहुनाराए ङ़ाक किर्‍या ओझाःवए नो ल़ुज़ाए ओपाँ माख्‍याधुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","है जैद ओपाल्‍यारानी तोबोलाई खुल्‍द, “झ्यालखानाल लिज़्‍याव यूहन्‍नाए ओङ़ै च़म्‍द रैके,” है दाद परींक्‍यो। नो झ्यालखानाल बाद यूहन्‍नाए ओङ़ै च़म्‍द, ");
INSERT INTO kjl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ताथील झाःद नो ल़ुज़ालाई रैदिक्‍यो। नो ल़ुज़ाए फरी ओआमालाई लाँदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","छींनी यूहन्‍नाए उसिसराए नो पाँर थैद ओमोरोलाई च़िहुद लाँद गादैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","येसुए नो ओरापरींव ओसाचीर ओल्‍द हुद ओल्‍योक दुप्‍सिद यादोव य़ेन भरी, यारासथैव पाँ भरी है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","नकिन येसुए नोरालाई, “जे जाँवा पै ऩासिन्‍याए जूँनी ङास तोबो साइँसुइँवक हुव ताके,” है यादोक्‍यो। काराव ल्‍यो ताकिन हो बेलाक मिँर याल्‍योक बनै कुधु ज़ आदा होदा लिन्‍यार यातावए काँर ज़्‍यान्‍या ब यामाधाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","है जैद येसु उसिसरास दोङ्गाल पसिद तोबो साइँसुइँव पोक बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","खाली मिँराए याबाज़्‍याव रँःद, “नोर ज़ याल्‍यो,” लिन्‍या सरेस्‍द प़ाइँनी ज़ धोंःहुद दह छ्यो छ्यो बाद नोरालाई बलेंद याङ़ात ज़ केस्‍नाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","येसु दोङ्गातिन उझरिउ प़ाइँना मिँर बनै माहोल्‍या यारँःक्‍यो। नोर यागावला माल्‍यो बेधा स्‍यासोर यातावए येसुए उयुँ नाद परमेस्‍वरए ओपाँर कुधु ज़ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जाँ ऱिमदा ऱिमदा येसुए उसिसर ओल्‍योक हुद, “गे इताव साइँसुइँवक गेलिज़्‍या, नम ब नुप्नाके। ");
INSERT INTO kjl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","आव माहोल्‍यारालाई आजीलाव नाखार जीदा यापरींके, ज़्‍यावर लँःद घज़्‍युरक,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","येसुए, “आवरालाई ज़्‍यावर जे ज़ याव ताके,” है ओरादोक ते, उसिसराए, “हुकी आवरालाई ऩेसय तोला चाँदीए उमींवा भरेस रैद्यान्‍या है नलिज़्‍याव रो?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","येसुए, “जेस भरेस खागोता उलिज़्‍याव, चिऊनाचिके,” है ओरादोक ते, नोर चिऊनाद गनिद, “गेस भरेस पाँच गोता, ङाँः ऩेब्‍लो वाज़ लिज़्‍या,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","हाःत ज़ येसुए उसिसरालाई नो माहोल्‍यारालाई पींव छी ल्‍यो बाँल ताना ताना जैद सोचोइँव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","नोर पचास पचास स़ोनो सय सयलाव ताना जैसिद च़ुसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","हाःत ज़ येसुए नो पाँच गोता भरेस ऩेब्‍लो ङाँः उकुइत रैद स्‍वर्गदा भाल्‍सिद, असिक ऩिद भरेसर केःद उसिसरालाई नो माहोल्‍याराए याङ़ाक याङ़ाक भाःद्याव यापरींक्‍यो। फरी नो ऩेब्‍लो ङाँःनिलाई मनी हिताव ज़ जैद भाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","नोर प़ाइँए याफू तसी ज़्‍युकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","नो यासय़ेलो भरेस स़ोनो ङाँःए उकुतुरार यादुप्‍क बाह्र झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","नो भरेस ज़्‍याज़्‍यावर खेपार वाज़ पाँच हजारा याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","हाःत ज़ येसुए उसिसरालाई दोङ्गाल पसिउ परींद दह होफताव बेथसेदा यादोज़्‍याव पोदा ओलकिन ङ़ादा ज़ यापरींक्‍यो। ओल येसुए ते नो माहोल्‍यारालाई याझ़िमदा याझ़िमदा ओरापरींज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","नोरालाई ओरापरींधुव छींनी ओल तोबो दाँदात बाद पोंखारिनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","नम ओझ्यानाक उसिसर दोङ्गात दह माँजल ज़ यालिज़्‍याव। येसु ओबातङ पाखाक उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","छींनी बतास उसिसराए ल्‍योदा बनै चोइस हुद नोर यादोङ्गालाई बनै धो धो यालाँज़्‍याव। येसुए नोरालाई रँःद रीलाव तीन बजेवाक ऱी तर्त तर्त याल्‍योदा ज़ बाके। यालापनिकाव घ्याँ बाव ओपैंज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","नोराए येसुलाई ऱी तर्त तर्त उहुज़्‍याव रँःद, “आव ते झ़्या ची सा!” लिद, ");
INSERT INTO kjl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","बनै छे·द चिर चिर क़िकेर। हाःत ज़ येसुए, “ताछे·च्‍यो, जेयुँ होलाँ जैचिके, ङा ची,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","यास दोङ्गाल उपसिउ प़ाइँना ज़ बतास ब थकनिके। निताव रँःद उसिसर बनै अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","येसुए निताव भरेस ओसबा·व रँःद ब ओय़ेन चावस यामाथ·रैताव। यायुँ बनै खाव ओतावए मातीधुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","दह होफताव गनेसरेत यादोज़्‍याव पोङ केस्‍द यादोङ्गालाई दह छ्योक सुर्द, ");
INSERT INTO kjl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","पाखाक यापुलुसो प़ाइँना नलाव मिँराए येसुलाई बेहार ज़ सरेस्‍द, ");
INSERT INTO kjl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","नजीलाव भरिल सरसाप बाद याजोरो हुव भरिरालाई याझेलोङ्गारास घुर्द येसु जोक जोक बाज़्‍या होक होक ज़ यारालाँकेर। ");
INSERT INTO kjl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","है जैद सहरल तादी ब, नाखारल तादी ब, पाखाङ तादी ब येसु जोक बाज़्‍या, होक ज़ मिँराए याजोरो हुवरालाई तोबोक यारादुप्‍ज़्‍याव। नोराए, “नक्‍वाए उतुपा वाज़ छापो गेदैक,” है दाद छापो भरी ओपो·स ज़ गराँकेर। ");
INSERT INTO kjl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","यरूसलेमनी हुव फरिसीर स़ोनो सास्‍त्रीर येसुए ल्‍योक यादुप्‍सिउत, ");
INSERT INTO kjl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","येसुए ख्‍वा ख्‍वा उसिसराए याकुइ माचोखोइसिद काँ याज़्‍युज़्‍याव यारारँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","फरिसीर स़ोनो उपुर्काव यहूदी भरिराए यासाखा पुर्खारानी हुव चलन दाद याकुइ यामाचोखोइसिवा पै काता ज़ यामाज़्‍युज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","फरी बजारनी याहुवत ब ऱीए यामाचोखोइसिवा पै काता ज़ यामाज़्‍युज़्‍याव। छुत भाःकिनकाव चलनर ब कुधु ज़ यादोज़्‍याव, कैताक जार याचोखोइज़्‍याव, कैताक खुरीर भोप्‍कार याचोखोइज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","है जैद नो फरिसीर स़ोनो सास्‍त्रीराए येसुलाई, “नसिसराए काराव गेसाखा पुर्खारानी हुव चलन यामादोज़्‍याव? आवराए याकुइ माचोखोइसिद ज़ ज़्‍युज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","येसुए, “जे मिताव कैफतीराए जूँनी यसैयाए ङ़ादा ज़ थिक सर्द नैद्याचिउ। नोए ओसरो आव ज़, ‘आवराए यायाःए वाज़ ङामान नैद्याँज़्‍यार। यायुँ ते ङाकिन तादाङ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","मिँराए याससैव चलनलाई सघ्‍योःद, अऩाकल ज़ ङासेवा दोज़्‍यार।’ ");
INSERT INTO kjl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","है जैद जे परमेस्‍वरए ओकानुनलाई ऱास्‍द झन मिँराए याजैव चलनलाई जेमानिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","निताव दान्‍यात बनै ज़ जेजम्‍कैज़्‍या — परमेस्‍वरए ओकानुनलाई ख्याद, जेचलनलाई जेसघ्‍योःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","अछादी परमेस्‍वरए ओकानुन सर्ज़्‍याव मोसाए इताव सर्द नैव, ‘बाबु आमाए ओमान नैद्याव ज़ परिए।’ स़ोनो, ‘जोए ओबाबु ओआमाए उमिन बले·दिज़्‍याव, होलाई सैःव ज़ परिए।’ ");
INSERT INTO kjl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","जे ते झन, ‘जोए ओबाबु ओआमानिलाई, ‘जिन ङानिकाव दैव परिन्‍या भरी कुर्बान ताद ले,’ है उलिकिन, नो मिँलाई ओबाबु ओआमानी निभार मालागिद काता ज़ याव मापरिए,’ है जेलिज़्‍या। (कुर्बानए ओअर्थ — ङाधन भरी परमेस्‍वरए उमिनत नैसिउ लिज़्‍या।) ");
INSERT INTO kjl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","है जैद जे निताव जेसाखा पुर्खारानी हुव चलननी परमेस्‍वरए ओपाँलाई अऩाकलाव ज़ जेजैज़्या। हो मिताव य़ेन छुत मनी कुधु ज़ जेदोज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","नकिन येसुए नक लिज़्‍याव माहोल्‍यारालाई ओल्‍योदा खुल्‍द, “आव ङापाँ जे भरिए थैद चावस थ·रैच्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","पाखानी क्‍याँल पसिज़्‍यावए मिँलाई माछैंव माजैधुव। मिँलाई माछैंव जैज़्याव ते क्याँनी पुलुस्‍ज़्‍यावए ची। ");
INSERT INTO kjl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","हाःत ज़ येसुए नो माहोल्‍यारालाई ख्‍यानैद तोबो झ़िमल उपसिउत उसिसराए नो पाँए ओअर्थ सुधिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","येसुए, “जे मनी अझ ङापाँ जेमातीधुज़्‍याव रो? याःनी पसिज़्‍याव ज़्यावए मिँलाई माबले·व लिन्‍या जेमासैंए रो? ");
INSERT INTO kjl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","नो ज़्‍याव युँदा माबाए, अइज़ फूल पसिद छींनी पुलुस्‍द बाज़्‍या।” नो पाँनी ज़ येसुए ज़्‍याव भरी चोखो ज़ थ·रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","फरी, “मिँलाई बले·ज़्‍याव ते युँल सिर्जैद याःनी पुलुसज़्‍याव पाँए ची। ");
INSERT INTO kjl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","युँलाव माचाहिउ पाँर आवर ज़ — माचाव चेतैन्‍या, पातर्‍या पातर्नी जैसिन्‍या, कुन्‍या, मिँ सैःन्‍या, अर्काए ओज्‍याए ल्‍योदा बान्‍या, ");
INSERT INTO kjl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","अर्काए उमीं कोसै रँःन्‍या, माचाव य़ेन दान्‍या, धुत पाँन्‍या, जोत ब युँ मानैधुन्‍या, मी तून्‍या, अर्काए उमिन बले·द्यान्‍या, स॰द सघ्‍योःसिन्या, उर्ती माल्‍यो जैसिन्‍या, ");
INSERT INTO kjl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","आवर ज़ युँनी पुलुस्‍द मिँलाई बले·न्‍या पाँर।” ");
INSERT INTO kjl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","येसु ननी पुलुस्‍द तुरोस स़ोनो सीदोन खन्‍द त॰दा बाके। नल तोबो झ़िमल पसिद, ‘आल ङाहुव सुए ज़ यामासैंकिन ताखेहो,’ है उलिज़्‍यावत ब माम़ोंसिधुके। ");
INSERT INTO kjl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","बेहार ज़ तोबो मेंमाए, ‘येसु हुके दी’ लिन्‍या थैद ओल्‍योक हुद उखँत फुलुप्‍सिके। नोए मेंमा ओज़ालाई माचाव पुरूसए क्‍योःद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ओल मेंमा फरी ग्रीक जातलाव ओल्‍यो, उझ़िम सिरिया फोनिके खन्‍दल ओल्‍यो। नोए, “अ प्रभु, ङाज़ाए ओक्‍याँताव माचाव पुरूस पले·द एके,” लिद बिन्‍ती चरैःव ज़ ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","येसुए फरी, “ल़ुज़ाराए याज़्‍युज़्‍याव ज़्‍याव नैंद काःरालाई यान्‍या माताए। ङ़ादा ल़ुज़ार घवाँःरक,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","नो मेंमाए, “हैज़ प्रभु, हैदी ब ल़ुज़ाराए यासय़ेलो ज़्‍यावर तेबल खँकाव काःराए मनी ज़्‍याव दैर सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","येसुए, “आव नपाँए ज़ नज़ाए ओक्‍याँताव माचाव पुरूस पुलुस्‍द बाधुके, नँ नझ़िमदा चावस बान्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","नो मेंमा उझ़िमक ओबाक ओज़ालाई तैंत घ्याँसिद उलिज़्‍याव रँःक्‍यो। माचाव पुरूस ओबाधुव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","नकिन येसु तुरोसनी पुलुस्‍द सीदोन स़ोनो देकापोलिसलाव घ्याँ गालील दह छ्योक बाके। ");
INSERT INTO kjl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","नलाव मिँराए येसुए ल्‍योक तोबो ओर्ना माथासो स़ोनो मापाँधुन्‍यालाई रैद, “आवए ओक्‍याँत नकुइ नैद सगराँके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","येसुए नोलाई माहोल्‍यारानी अछतङ लाँद ओआङुला ओर्ना कुँल झाःद्याद ओसेत उत़िल झाःद्याद, ");
INSERT INTO kjl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","नमदा परमेस्‍वरए ल्‍योदा भाल्‍सिद, ख्‍यो·व स॰ दोहोरैद नो मिँलाई, “इफ्‍फाता,” है दोक्‍यो। (इफ्‍फाताए ओअर्थ — नर्ना ओफैसिक।) ");
INSERT INTO kjl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","हो प़ाइँना ज़ नो मिँए ओर्ना फैसिद थैन्‍या ताके। ओसेर ब पलास्‍सिद चावस ज़ पाँके। ");
INSERT INTO kjl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","हाःत ज़ येसुए नक लिज़्‍यावरालाई, “आव ङादोव य़ेन सुलाई ज़ है तारादोच्‍यो,” है लिद याअर्थैक्‍यो। खाली नोराए खा ओराअर्थैव हाःज़ नो पाँलाई फींजैद यारासथैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","नोर बनै अचम्‍ब ताद, “काता आः चाव य़ेन ओदोज़्‍याव। यार्ना माथासोरालाई ब थैन्‍या याजैज़्‍याव, मापाँधुन्‍यारालाई ब पाँधुन्‍या याजैज़्‍याव,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","फरी तछा येसुए ल्‍योक मिँर बनै माहोल्‍या दुप्‍सिहुद यालिज़्‍याव। यास ज़्‍यान्‍यार प़ाइँ खेम्‍द उलिज़्‍याव। है जैद येसुए उसिसरालाई ओल्‍योदा खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“आव माहोल्‍यार रँःद ङायुँ नाज़्‍या। आवर ङास याल्‍यो आछिम स़ोंला ताकेर। याज़्‍याव भरी ब खेम्‍के। ");
INSERT INTO kjl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","आवरालाई अइज़ झ़िमदा परींकिन येमत याकरेए माधुन्‍या लेर। आवर ख्‍वा ख्‍वार ते तादानी हुवर लिज़्‍यार,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","उसिसराए, “इताव साइँसुइँवक आःकाव मिँरालाई कातानी ज़्‍यावर रैद सव़ाँन्‍या की?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","येसुए, “जेस भरेस खागोता उलिज़्‍याव?” है ओरादोक ते, “भरेस सात गोता लिज़्‍या,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","नकिन येसुए नो माहोल्‍यारालाई नामक च़ुसिउ परींद नो सात गोता भरेस उकुइत रैद, धन्‍याबाद चरैःद नो भरेसलाई केःद उसिसरालाई नो माहोल्‍यारालाई भाःद्याव ओरापरींक ते, भाःद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","नोरास ङाँःजुँर ब ऩेबरेंवा यालिज़्‍याव। येसुए नोरालाई मनी उकुइत रैद, असिक ऩिद माहोल्‍याराए याङ़ाक याङ़ाक भाःद्याव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","नोराए याफू तसी ज़्‍याद यासय़ेलो यादुप्‍क सात झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","नो भरेस ज़्‍युज़्‍यावर चार हजारा याल्‍यो। नकिन येसुए नो माहोल्‍यारालाई याझ़िमदा याझ़िमदा यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ओल बेहार ज़ उसिसरास दोङ्गाल पसिद दलमनुथा खन्‍द जीदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","नल फरिसीर येसुलाई जाँचिन्‍याए जूँनी ओल्‍योक हुद खर्लेसिद, “गेलाई स्‍वर्गताव नसरेस तोबो सतैंद्याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","येसु ओनालर क़्याद, “आव जुकलाव मिँराए काराव सरेस वाज़ याखिम्‍ज़्‍याव? ङा साचो है ङादाचिज़्‍या, आव जुकलाव मिँराए ङासरेस काता ज़ दैन्‍या मालेर,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","नोरालाई ख्‍यानैद उसिसरास दोङ्गाल पसिद दह होफत बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","येसुए उसिसराए यास भरेस लाँन्‍या मेंःद यानैज़्‍याव। दोङ्गाल नोरास भरेस तोबो वाज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","याबाज़्‍याक येसुए नोरालाई सम्‍जैद, “जे हेरोद राजा स़ोनो फरिसीराए भरेसल याझाःज़्याव वासःनी जोगोइसिद लिच्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","नोर, “भरेस रैन्‍या गेमेंःवए नै ओदासिज़्याव ताक्‍या,” है लिद या याल यापाँनाज़्याव ");
INSERT INTO kjl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","येसुए थैद, “काराव ङापाँलाई झन भरेस त॰दा जेथ·रैनाज़्‍याव? आःपै जेमातीधुइ रो? काता जेयुँ आः खाव उलिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","जेमी लिज़्‍यावत ब जेमारँःधुज़्‍याव रो? जेर्ना लिज़्‍यावत ब जेमाथैधुज़्‍याव रो? काता घरी जेमेंःधुव, ");
INSERT INTO kjl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","पाँच गोता भरेसए पाँच हजारए याफू तसी ज़्‍यादकाव यासय़ेलो जेदुप्‍क खाझुर्नु ओताव?” है ओरादोक ते, “बाह्र झुर्नु ताके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“फरी सात गोता भरेसए चार हजार मिँए याफू तसी ज़्‍यादकाव यासय़ेलो जेदुप्‍क खाझुर्नु ओताव?” है ओरादोक ते, “सात झुर्नु ताके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","येसुए फरी, “कै जैद आःपै जेमाबुझिधुज़्‍याव?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","नकिन येसु उसिसरास बेथसेदा नाखारल बाकेर। नक मिँराए तोबो उमी मारैंःवलाई ओल्‍योक रैद, “आवलाई छुद सगराँके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","येसुए नो उमी मारैंःवलाई उकुइनी क्‍योःद दोरैद नाखारनी अछतङ लाँद, उमीत त़िल्‍द्याद ओक्‍याँत उकुइ नैद्याद, “कातार नमारँःज़्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","नोए आदा होदा भाल्‍सिद, “रँःन्‍या ते ङारँःज़्‍या, खाली मिँर ते सींर आदा होदा याबाज़्‍याव स्‍यासो ङारारँःज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","हाःत ज़ येसुए फरी नोए उमीत उकुइ नैद ओएक ते नो मिँए लँ लँ चिऊद प़ाइँ ज़ छर्लङ्ग रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","है जैद येसुए नोलाई, “नाखारल मापसिद ज़ नझ़िमदा बान्‍के,” है दाद परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","नकिन येसु उसिसरास कैसरिया फिलिप्‍पी सहर लापजीकाव नाखार नाखार याबाज़्‍याक येमत येसुए उसिसरालाई, “ङालाई मिँराए सु है दाँज़्‍यार?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","उसिसराए, “ख्‍वाराए ऱील सछैंज़्‍याव यूहन्‍ना है दींज़्‍यार, ख्‍वाराए एलिया है दींज़्‍यार, ख्‍वाराए फरी काताकाव अगमबक्ता ताक्‍या है दींज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","येसुए, “जे ङालाई सु है जेदाँज़्‍या नी?” है ओरादोक ते, पत्रुसए, “नँ ख्रीस ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","नकिन येसुए नोरालाई, “ङा हो ज़ लिद सुलाई ज़ है तारादोच्‍यो,” है दाद याअर्थैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","हो बेलाक येसुए, “ङा मिँ मिन्‍सिउए कुधु दुखर दैद आव गेदेसलाव स़ेरर, मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ल्‍योनी सोसी ऩिन्‍या ङातारिज़्‍या। नोराए यासैःनाव स़ोंलात सिउनी सैंसिद ङासोरिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","उसिसरालाई ओक्‍याँत हुरिज़्‍याव दुखर ङ़ादाकिन ज़ छर्लङ्ग सतैंद याएक्‍यो। हाःत ज़ पत्रुसए येसुलाई तँदा लाँद उसिङार्क ते, ");
INSERT INTO kjl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","येसु उछींदा फर्किद उसिस भरिरालाई चिऊद पत्रुसलाई, “ए सैतान, ङाङ़ाकिन पुलुस्‍निके। नँ नयुँ परमेस्‍वरए ल्‍योदा माझाःद मिँराए याझाःज़्‍यावदा नझाःके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","नकिन येसुए उसिसर स़ोनो नक लिज़्याव माहोल्‍यारालाई ओल्‍योक खुल्‍द प़ाइँलाई ज़, “जोए ङास हुन्‍या युँ दोज़्‍याव, होए उजिउए मया मादाद क्रुसत सिन्‍या मिताव दुखर सहिद ङाछींत उहुक। ");
INSERT INTO kjl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","जोए आव उजिउत ओललाई तान्‍या वाज़ खिम्‍ज़्याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव उजिउत उजिउए मया मादाद ङाजूँनी स़ोनो चाव थाए उजूँनी दोज़्याव, होए जुनी दैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","जोए आव मानुवात लिज़्‍याव भरी दुप्‍द उजुनीलाई ओसम़ैकिन नोलाई काता फाइदा ची तायादा? ");
INSERT INTO kjl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","नोए उजुनीए ओपोल काता यान्‍या? ");
INSERT INTO kjl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो आव पापी जुकलाव परमेस्‍वरकिन तँदाङाव मिँराए खार्ल ङा स़ोनो ङापाँत ओलाज हुज़्‍या, ङा मिँ मिन्‍सिउ ब फरी छैंव ङाचाकर्‍यारास ङाबाबुए ओज़गै मगैरास ङाहुक ङा ब नोलाई रँःद ङालाज हुन्‍या ले,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","फरी, “ङा जेलाई साचो है ङादाचिज़्‍या, आकाव च्‍याँःसिद लिज़्‍यावरानी जे ख्‍वा ख्‍वाराए परमेस्‍वरए ओराज्‍या ओसक्तीरास उहुज़्‍याव जेमारँःवा पै सिन्‍या जेमाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","नकिन छ दिनत येसुए पत्रुस, याकूब स़ोनो यूहन्‍नारालाई याबातङ तोबो झेंःव गोंत ओलस यालाँक्‍यो। नक याकेसोत येसुए ओक्‍याँर त़ोसिद, ");
INSERT INTO kjl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ओक्‍वार बनै मी झीःन्‍या, तक तकौ ताके। आव मानुवात सुए ज़ जती छेदी ब निताव तक तकौ माजैधुर। ");
INSERT INTO kjl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","नाःत ज़ एलिया स़ोनो मोसानी नक ज़ सरैंःसिद येसुस पाँकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","नो रँःद पत्रुसए येसुलाई, “गुर्बा, गे आक लिन्‍या बनै चाव ताके। गे जेलाई स़ोम्‍लो पाल तङ्गैद गेयाच्‍यो, तोबो नँलाई, तोबो मोसालाई, तोबो एलियालाई,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","बनै याछे·वए पत्रुसए काता पाँन्‍या लिन्‍या ब ओमासैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","नाःत ज़ बादल तोबो हुद नोरालाई याकप्‍क्‍यो। नो बादल जींनी तोबो गा अइ लिद थास्‍के, “आव ङायुँलाव ङाज़ा ज़, जे आवए ओपाँ थैच्‍यो,” ");
INSERT INTO kjl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","है उलिज़्याव याथैव प़ाइँना नोर आदा होदा याभाल्‍सिक उपुर सु ज़ यामाल्‍यो, येसुलाई वाज़ रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","नो गोंतिन याझरिज़्‍याक येसुए नोरालाई, “आव जेरँःव भरी ङा मिँ मिन्‍सिउ सिद ङामासैंसिवा पै सुलाई ज़ है तारादोच्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","नोराए सुलाई ज़ है मादाद या याल वाज़, “आव सिद सैंसिन्‍या है उलिज़्‍याव पाँ काता ओताव?” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","नोराए येसुलाई फरी, “सास्‍त्रीराए काराव ख्रीसकिन ङ़ादा एलिया हुन्‍या ले है यालिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","येसुए, “हैज़, एलिया ङ़ादा ज़ हुद प़ाइँलाई ताव परिन्‍या मिताव जैन्‍या ले। हैदी मनी आव ब सर्सिउ लिज़्‍या — हो बेलाकाव मिँराए मिँ मिन्‍सिउलाई दुखर याद बीज्‍यात जैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","खाली ङा जेलाई आव मनी है ङादाचिज़्‍या, एलिया ते ङ़ादा ज़ हुधुके। आलाव मिँराए झन किताव सर्सिउ ओल्‍यो हिताव ज़ जैद नोलाई यामन लागिउ ज़ जैकेर।” ");
INSERT INTO kjl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","येसु नो स़ोम्‍लोरास उपुर्काव उसिसराए ल्‍योक याकेस्‍नाक बनै माहोल्‍या मिँराए याखार्ल घिरिद सास्‍त्रीर नोरास याखर्लेसिज़्‍याव यारारँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","हाःत ज़ नो माहोल्‍याराए येसु उहुज़्‍याव रँःद नोर बनै अचम्‍ब ताद ओल्‍योक धोंःनाद धो यादोक, ");
INSERT INTO kjl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","येसुए नोरालाई, “काताए जूँनी जेखर्लेसिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","माहोल्‍यारानी तोबोए, “गुर्बा, ङा नल्‍योक ङाज़ालाई रैद ङानै। नोलाई माचाव पुरूसए लाता जैद नैव। ");
INSERT INTO kjl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","नो पुरूस ओक्‍याँत उहुव बेलाक झन नामक पछारिसिद, ओहार सजम्‍द, ओयाःनी फुइ गज्‍या पले·द बनै ख्‍याङग्‍याँ खेङ्गे जैज़्‍याव। ङा नसिसरालाई, ‘माचाव पुरूसलाई पले·दिचिके,’ है ङारादोक ते मापले·धुकेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","हाःत ज़ येसुए, “ए जेयुँ माहुबोर, ङा जेस खा ची ङालिरिज़्‍याव, खा ङासहिचिके! नोलाई ङाल्‍योक रैचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","नो छोर्‍यालाई ओल्‍योक रैदिकेर। हाःत ज़ नो पुरूसए येसुलाई उरँःव प़ाइँना ज़ नो छोर्‍यालाई बेहार ज़ खागरा खगर॰ जैक्‍यो। नो छोर्‍या नक ज़ गुधु धलिद फलीं फलीं पल्‍तैसिद ओयाःनी फुइ गज्‍या पले·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","येसुए छोर्‍याए ओबाबुलाई, “आव खर्किन अइ ओताव?” है ओदोक ते, ओबाबुए, “ज़िम्‍ज़ाकिन ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","फरी, “आव ङाज़ालाई सैःन्‍याए जूँनी कैताक मेंःल ब ख्‍याज़्‍याव, कैताक ऱील ब ख्‍याज़्‍याव। नँ कातार नदोधुकिन गेल्‍योदा नयुँ नाद सगराँद्याव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","येसुए, “नँ कै जैद ङालाई, ‘कातार नदोधुकिन,’ है नदाँज़्‍याव? उयुँ हुबोलाई मातान्‍या काता ज़ माले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","नो छोर्‍याए ओबाबुए, “अ प्रभु, ङायुँ हुबो ज़ लिज़्‍या, माहुबो ङायुँलाई सुहुप्‍द्याँके,” है लिद बनै चोइस ज़ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","हाःत ज़ येसुए मिँर बनै काला मुलु याधोंःहुज़्‍याव रँःद नो माचाव पुरूसलाई सिङार्द, “ए लाता भैरा जैन्‍या पुरूस, नोए ओक्‍याँतिन पुलुस्‍द बान्‍के। फरी नल खर्क ज़ तापसिनी,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","नो माचाव पुरूस बनै चिर चिर क़िद नो छोर्‍यालाई कारापनी कुरूप जैद पुलुस्‍द बाके। हाःत ज़ नो छोर्‍या चबनै सिउ स्‍यासो ओतावए नो भाल्‍सिज़्‍यावराए, “उसिउ ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","खाली येसुए नोलाई उकुइनी क्‍योःद पोंला ओसोचोइक ते थर च्‍याँःसिके। ");
INSERT INTO kjl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","छींनी येसु उसिसरास झ़िमल याबातङ यातावत उसिसराए, “गे कै जैद नो माचाव पुरूसलाई गेमापले·धुव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","येसुए, “इताव पुरूसलाई पले·न्‍या ते मापोंखारिवा पै मापले·सिधुइ,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","येसु उसिसरास ननी पुलुस्‍द गालील खन्‍दलाव घ्याँ बाकेर। ‘आल गेलिज़्‍याव सुए ज़ तासैंरक’ है उलिज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","काराव ल्‍यो ताकिन उसिसरालाई वाज़ पैन्‍या ओपैंज़्याव। नोए, “ङा मिँ मिन्‍सिउलाई तछा मिँराए याकुइत सूँपिनारिज़्‍यार। नोराए ङालाई सैःनारिज़्‍यार। हैदी ब ङासिउ स़ोंलात सैंसिद ङासोरिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","नोराए नो पाँ यामाबुझिदी ब येसुलाई सुधिन्‍या छे·केर। ");
INSERT INTO kjl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","नकिन येसु उसिसरास कफर्नहुमल बाकेर। झ़िमल यापसिउत येसुए उसिसरालाई, “येमत जे काता खास खासनी खुस खुस जेपाँहुज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","नोराए सुए ज़ घाइ मादोकेर, काराव ल्‍यो ताकिन नोर येमत, “गे सु घेप्‍पा गेलिज़्‍याव,” लिद याखर्लेसिहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","है जैद येसु नक च़ुसिद बाह्र जना उसिसरालाई ओल्‍योक खुल्‍द, “जो प़ाइँरानी ङ़ात जैसिउ पैंज़्‍याव, हो प़ाइँराए याधूँलाव जैसिद प़ाइँए यासेवा दान्‍या ओजैसिक,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तोबो ज़िम्‍ज़ा ल़ुज़ालाई रैद याङ़ाक सच्‍याँद, नो ल़ुज़ालाई ओघोइँल छींद, ");
INSERT INTO kjl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जोए ङामिनत आव मिताव ज़िम्‍ज़ारालाई यासुम्‍ज़्‍याव, होए ङालाई ब सुम्‍नाज़्याव। जोए ङालाई सुम्‍नाज़्‍याव, होए ङालाई वाज़ माःक, ङालाई परींज़्‍यावलाई ब सुम्‍ज़्‍याव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","यूहन्‍नाए, “गुर्बा, तोबोए नमिननी माचाव पुरूसर ओरापले·ज़्‍याव गेरँःके। नो गेस ओमाल्‍योए पले·व गेमाएके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","येसुए, “नोलाई तावैंच्‍यो, जोए ङामिननी सक्तीलाव य़ेन दोज़्‍याव, होए सिती मिती ङामिन बले·द मायाँव। ");
INSERT INTO kjl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","जो गेकिन तँदा माजैसिए, हो गेस ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ङा जेलाई साचो है ङादाचिज़्‍या, जोए जेलाई ख्रीसए उमींर जेल्‍यो लिद सरेस्‍द ङामिननी तुखुरी ऱी वाज़ ओयाचिदी ब नोए उइनाम जुनी ब दैन्‍या ज़ ले।” ");
INSERT INTO kjl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","फरी, “जोए आव मिताव ङालाई यायुँ हुबो ज़िम्‍ज़ारालाई पापल ओरापारैकिन, नितावलाई ते बुरू ओधेंल राँथै सुर्द्याद समुन्‍द्रल ख्‍यान्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","फरी नकुइए माचावल ओपारैनिकिन नोलाई च़म्के। नो नकुइए नर्गलाव माजिप्‍तिन्‍या मेंःल ख्‍याव ओदोज़्‍याव देखा बुरू अजम्‍बरी जुनील थूँद्यासो पसिन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","नर्गलाव ऱूइराए याभोगोन ब खर्क ज़ माखेमे, मेंः ब खर्क ज़ माजिप्‍तिए। ");
INSERT INTO kjl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","फरी नखँए माचावल ओपारैनिकिन नोलाई ब च़म्के। नो नखँए नर्गल ख्‍याव ओदोज़्‍याव देखा बुरू अजम्‍बरी जुनील थूँद्यासो पसिन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","नर्गलाव ऱूइराए याभोगोन ब खर्क ज़ माखेमे, मेंः ब खर्क ज़ माजिप्‍तिए। ");
INSERT INTO kjl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","हो मिताव ज़ नमीए माचावल ओपारैनिकिन, नो नमीलाई कोला·द ख्‍याके। नो नमीए नर्गल ख्‍याव ओदोज़्‍याव देखा बुरू परमेस्‍वरए ओराज्‍याल काना ताद पसिन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","नर्गलाव ऱूइराए याभोगोन ब खर्क ज़ माखेमे, मेंः ब खर्क ज़ माजिप्‍तिए। ");
INSERT INTO kjl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“मिँ भरी प़ाइँ ज़ मेंःनी सापी दार मिताव तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","सापी चाव ज़ लिज़्‍या, खाली ओदार ओमालिकिन नोलाई कै जैद ची ओदार ल्‍यो जैन्‍या? है जैद जे ब सापी मिताव ताद जे जेल खैद लिच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","येसु ननी पुलुस्‍द यर्दन भै होफताव यहूदिया खन्‍दल बाके। नल ब मिँर बनै माहोल्‍या ओल्‍योक याहुज़्‍याव। येसुए पो पोक ओदोज़्‍याव मिताव नोरालाई मनी परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","नल फरिसीराए येसुलाई जाँचिन्‍याए जूँनी ओल्‍योक हुद, “ज्‍यालाई ऱासो दैसिए सैं मादैसिए?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","येसुए, “मोसाए ओकानुनल किताव सर्सिउ उलिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","नोराए, “मोसाए ओकानुननी ते ऱास्‍न्‍या कागत तोबो सर्किन ऱासो दैसिए,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","येसुए फरी, “जेदिउदी ल्‍योर जेतावए ज़ मोसाए निताव कानुन सर्द ओयाचिउ। ");
INSERT INTO kjl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","भाःङ स्रिस्‍तील परमेस्‍वरए मिँ ओजैक खेपा स़ोनो मेंमानी निजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","है जैद ज़ खेपाए ओबाबु ओआमालाई ऱास्‍द ओज्‍यास सिप ताद, ");
INSERT INTO kjl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","नोनी तक्‍याँ ज़ ताज़्‍यानी। हाःकिन नोनी ऩेब्‍लो माःक, तक्‍याँल गनिसिज़्‍यानी। ");
INSERT INTO kjl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","है जैद जोनिलाई परमेस्‍वरए जोरैद निनैव, होनिलाई मिँराए ताराभाःरक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","फरी झ़िमल उसिसराए नो पाँए उजूँनी फरी ब सुधिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","है जैद येसुए, “जोए ओज्‍यालाई ऱास्‍द छुतलाई ओरैकिन नोए जारी य़ेन ज़ दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","हो मिताव ज़ जो मेंमाए ओरेलाई ऱास्‍द छुतस ओरेस्‍किन हो ब हिताव ज़,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","नकिन नलाव मिँराए ज़िम्‍ज़ा याज़ारालाई ‘येसुए उकुइ नैद असिक घरायोक’ लिद ओल्‍योक यारारैकेर। नो रैज़्‍यावरालाई उसिसराए सिङार्द यारावैंकेर। ");
INSERT INTO kjl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","येसुए निताव रँःद उसिसरालाई जाँ रसिद, “नो ज़िम्‍ज़ा ल़ुज़ारालाई तारावैंच्‍यो, ङाल्‍योदा हुव याराएचिके। परमेस्‍वरए ओराज्‍या नितावराए जूँनी ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ङा साचो है ङादाचिज़्‍या, जोर आव ल़ुज़ाराए माँःती परमेस्‍वरए ओराज्‍याल पसिन्‍या युँ मादोर, नोर खर्क ज़ पसिउ दैन्‍या मालेर,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","नो ल़ुज़ारालाई ओघोइँल छींद याक्‍याँत उकुइ नैद असिक याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","येसु ननी पुलुस्‍द येमत ओबाज़्‍याक तोबो मिँ धोंःहुद ओङ़ाक फुलुप्‍सिद, “अ धर्मी गुर्बा, ङा अजम्‍बरी जुनी दैन्‍या किताव दान्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","येसुए, “ङालाई काराव धर्मी है नदाँज़्‍याव? परमेस्‍वरकिन धर्मी सु ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","धर्मसास्त्रलाव सर्सिउ दान्‍या मादान्‍या य़ेन नँ ज़ नसैंज़्‍याखेहो — मिँ मासैःन्‍या, अर्काए ओज्‍याए ल्‍योदा माबान्‍या, माकुन्‍या, धुत गोहाई मायान्‍या, धुतैद माज़्‍यान्‍या, बाबु आमाए ओमान नैद्यान्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","नोए नो पाँर थैद, “गुर्बा, आव भरी ते ज़िम्‍ज़ाकिन दाहुव ज़ ङानैज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","येसुए नोलाई रँःद मया दाद, “अझ तोबो नमासयो·ताए। नँस लिज़्‍याव भरी यो·द काता ज़ माल्‍योरालाई भाःद याएकेदा, नँ स्‍वर्गताव धन दैन्‍या नले। नो य़ेन भरी दाद नँ ङाछींत हुन्‍के,” ");
INSERT INTO kjl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","है ओदोव भरी थैद ओङाः चुम चुमो जैद उयुँर स्‍यासे सतेद ओल्‍द बाके। नोए ओधन सम्‍पती बनै कुधु ज़ ओल्‍योए माऱास्‍धुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","नो ओबावत येसु उसिसराए ल्‍योदा भाल्‍सिद, “धनी मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या बनै धो ताज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","उसिसर नो पाँत बनै अचम्‍ब ताकेर। नकिन येसुए फरी, “साचो ज़ बाबुज़ार, परमेस्‍वरए ओराज्‍याल पसिन्‍या बनै धो ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","गपए उकुँल ऊँत उछिरिज़्‍यावकिन धनी मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या झन धो ताज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","नोर झन ज़ अचम्‍ब ताद, “इताव ताकिन ते सुए ची अजम्‍बरी जुनी ओदैधुरिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","येसुए नोरालाई चिऊद, “मिँर यानी सु ज़ माबाँचिधुर, परमेस्‍वरनी वाज़ ताज़्‍या। परमेस्‍वरनी मातान्‍या काता ज़ माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","हाःत ज़ पत्रुसए, “गे ते प़ाइँ ज़ ख्‍यानैद नछींत हुद गेले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, जोए ङाजूँनी स़ोनो चाव थाए उजूँनी ओएँःर उझ़िमर, ओदाज्‍यु भाइर, ओनाना बैंनीर, ओबाबु ओआमार स़ोनो ओज़ार ऱास्‍द याख्‍यानैज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","होए आव उजिउत ज़ दुख दैज़्‍यावत ब एँःर झ़िमर, दाज्‍यु भाइर, नाना बैंनीर, आमार स़ोनो ज़ार सय दोबोर ब दैन्‍या ले। फरिकाव जुनील अजम्‍बरी जुनी ब दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","खाली ख्‍वा ख्‍वा ङ़ातावर छींत तारिज़्‍यार, छींतावर ङ़ात तारिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","नकिन येसु उसिसरास यरूसलेमदा याबाज़्‍याक ओल ङ़ात ओबाज़्‍याव। उसिसर अचम्‍ब ताद यालिज़्याव, उछीं उछीं हुज़्‍यावर फरी छे·द यालिज़्याव। येसुए बाह्र जना उसिसरालाई अछतङ लाँद ओललाई छींनी तान्‍या पाँ भरी है यादोक्‍यो — ");
INSERT INTO kjl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“गे यरूसलेमदा गेपुलुस्‍नाज़्‍या। नल गेकेसोत ङा मिँ मिन्‍सिउलाई मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए याकुइत सूँपिन्‍या लेर। नोराए ङालाई सैःन्‍या ज़ थ·रैद रोमी सरकारए उकुइत याझाःनावत, ");
INSERT INTO kjl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","नोराए फरी ङालाई उल्‍ली गिल्‍ली दाद, त़िल्‍द, यारीःनावत सैःन्‍या लेर। हैदी ब स़ोंलात सिउनी सैंसिद सोन्‍या ङाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","नकिन जब्‍दियाए ओज़ानी याकूब स़ोनो यूहन्‍नानी येसुए ल्‍योक हुद, “गुर्बा, नँस जो गिन्‍ऩिज़्‍या हो ज़ नयासिने सैं है गिन्‍लिज़्‍या,” है निदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","येसुए, “ङा जिनजूँनी काता दाद्यान्‍या जिन्‍पैंज़्‍याव?” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","नोनी फरी, “स्‍वर्गत नँस तोबो नवोर्दा, तोबो नदाबर्‍यादा च़ुसिउ गिन्‍दैक,” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","येसुए फरी, “जिन आव जिन्ऩिज़्‍यावए जूँनी जिन्‍मासैंए। ङा जाँवाक धो सहिउ दुखर ङासहिरिज़्‍या। जिन जिन्‍मासहिधुरिज़्‍या नी? ऱीए ओरागदैज़्‍याव मिताव, ङा ब दुखल ङागदिरिज़्‍या। जिन जिन्‍मागदिधुरिज़्‍या नी?” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“गिन्‍धुया ज़,” है दोकिनी। हाःत ज़ येसुए, “हैज़, ङा ङादैरिज़्याव धो सहिउ दुखर जिन मनी दैन्‍या ज़ जिन्‍ले, दुखल ङागदिज़्याव मिताव जिन ब गदिन्‍या जिन्‍ले। ");
INSERT INTO kjl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","खाली ङावोर्दा ङादाबर्‍यादा च़ुसिउ यान्‍या ते ङा ङाकुइत माले। निताव दैन्‍या जोलाई यासिउ लिज़्‍या, होए उजूँनी वाज़ लिज़्‍या,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","उपुर्काव दस जना उसिसराए नो पाँ थैद याकूब स़ोनो यूहन्‍नानिलाई रँःद यारिस चोके। ");
INSERT INTO kjl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","नाःत ज़ येसुए उसिस भरिरालाई ओल्‍योदा खुल्‍द, “जे ज़ जेसैंज़्‍याखेहो, आव मानुवाताव घेप्‍पा है यारादोज़्‍यावर याधूँलावराए ङ़ैत बनै अखत्‍यासोर ताद हाप हाप ख्‍याज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","जे जेल ते निताव जैसिन्‍या माताए। खाली जे ते जो स़ेर जैसिउ जेपैंज़्‍या, हो प़ाइँए यासेवा दान्‍या ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","स़ोनो जेनी जो घेप्‍पा जैसिउ जेपैंज़्‍या, हो प़ाइँए याबाँदा ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ङा मिँ मिन्‍सिउ ब ‘ङासेवा घदोरक’ लिद ङाहुव माःक, कुधुलाई बाँचैन्‍याए जूँनी ङाजिउ झाःद यासेवा ङादोहुव ची,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","नकिन येसु उसिसरास यरीहो सहरल बाकेर। छींनी ते बनै माहोल्‍यारास ननी पुलुस्‍द याबाज़्‍याक तोबो तिमैए ओज़ा बारतिमै उमी मारैंःव ऩिद ङासिज़्‍याव येमक च़ुसिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","नोए ‘नासरतलाव येसु हुज़्‍या दी’ लिन्‍या थैद बनै चोइस, “अ दाऊदए ओथोलाव येसु, ङालाई नयुँ ओनाक,” है लिद उक़िज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","नो माहोल्‍याराए, “झ्याउँ तालिनी,” लिद सिङार्केर। नोए झन ज़ चोइस क़िद, “अ दाऊदए ओथोलाव, ङालाई नयुँ ओनाक,” है उलिक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","येसु नक च्‍याँःसिद, “नोलाई आदा रैचिके,” है ओरादोक ते, नो माहोल्‍याराए नो उमी मारैंःवलाई, “नयुँ सुहुप्‍द च्‍याँःसिन्‍के, प्रभुए खुल्‍निज़्‍याव,” है यादोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","नो मिँ ओकाँःबुलर ह्‍या ह्‍यी ख्‍याद थर च्‍याँःसिद येसुए ल्‍योक बाके। ");
INSERT INTO kjl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","हाःत ज़ येसुए, “ङा नजूँनी काता दाद्यान्‍या?” है ओदोक ते, नो उमी मारैंःवए, “गुर्बा, ङा रँःधुन्या ङाताक,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","येसुए, “बान्‍के, नयुँ उहुबोए ज़ नगराँके,” है ओदोव प़ाइँना नो मिँ रँःधुन्या ताद येमत येसुए उछीं उछीं ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","येसु उसिसरास यरूसलेम छ्योकाव जैतून दाँदाकिन जाँ होकसैकाव बेथफागे स़ोनो बेथानिया नाखार याकेस्‍नावत येसुए ऩेब्‍लो उसिसनिलाई अइ लिद ङ़ादा निपरींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“जिन आव गेङ़ाकाव नाखारल बाचिन्‍केदा, नल जिन्‍पसिउ प़ाइँना तोबो आःपै सुए ज़ यामाचेप्‍ताव बछेरा दैन्‍या जिन्‍ले। नोलाई पला·द रैचिन्‍के। ");
INSERT INTO kjl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","सुवाराए, ‘काराव पला·द जिन्‍लाँज़्‍याव?’ है यादाचिन्‍किन, ‘गिनप्रभुलाई चाहिज़्‍या, बेहार ज़ फर्कैद याचिवा दी,’ है यारादोचिन,” है दाद, नोनिलाई निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","है जैद नोनी नाखारल बाद येसुए है उनिदोव मिताव ज़ बछेरालाई येमक, झ़िम ङ़ाकाव साँबिलाक सुर्सिउ दैकिनी। नोलाई निपला·ज़्‍याक ज़, ");
INSERT INTO kjl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","नकाव च्‍याँःसिद लिज़्‍यावराए, “काराव पला·द जिन्‍लाँज़्‍याव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","नोनी येसुए उनिपैव मिताव ज़ है निरादोक ते भैंःद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","है जैद नोनी नो बछेरालाई येसुए ल्‍योक लाँद याक्‍वार ओतर्त याझाःवत येसुए नोलाई चेप्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","नकाव लिज़्‍याव मिँराए याक्‍वार येमल तैंदिकेर। ख्‍वाराए फरी पाखाजीलाव स्‍यावलार फूइँद तैंदिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","नो माहोल्‍यार ख्‍वार येसुए ओङ़ात, ख्‍वार उछींत जैसिद अइ लिद क़िए क़िए बाकेर, “होसन्‍ना! परमेस्‍वरए उमिनत हुव राजा धन्‍याकाव ओताक। ");
INSERT INTO kjl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","गेपुर्खा दाऊद राजाए उमिनत हुव राज्या जय जय ओताक, स्‍वर्गताव परमेस्‍वरए उमिन बनै ओघ्‍योःक।” ");
INSERT INTO kjl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","है जैद नोर यरूसलेमल याकेसोत येसु ध्‍यान झ़िमल पसिद आदा होदा प़ाइँदा चिऊद जाँ कुबिला ओतावए ननी पुलुस्‍द बाह्र जना उसिसरास बेथानियादा बासिनाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","हो पराःती बेथानियानी पुलुस्‍द याबाज़्‍याक येसु ओकरेक, ");
INSERT INTO kjl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","जाँ होकसै ओख्‍यार ल़पलपौ नेभारा सीं तोबो रँःद ‘ओसैर ले सैं’ लिद उचिऊनाक ओसै तोबो ब मादैक्‍यो। सैन्‍या बेला ओमातातावए ओख्‍या वाज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","निताव रँःद येसुए नो सींलाई, “आकिनी नसै सुए ज़ ज़्‍याव तादैरक,” है ओदोज़्याव उसिसराए थैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","हाःत ज़ येसु उसिसरास यरूसलेमल केस्‍केर। ओल ध्यान झ़िमल पसिद नलाव लँःज़्‍यावर यो·ज़्‍यावरालाई पले·द, पैसा त़ोज़्‍यावराए यातेबलर पल्‍तैद्याद, कुइतम यो·ज़्‍यावराए याकुर्चीर ब ख्‍याद्याद, ");
INSERT INTO kjl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","सुलाई ज़ यासमानरास ध्‍यान झ़िमलाव घ्याँ आदा होदा बाव मायाद, ");
INSERT INTO kjl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","येसुए नोरालाई, “धर्मसास्‍त्रल परमेस्‍वरए ओपाँ इताव सर्सिउ ओमालिज़्‍याव रो? ‘ङा ङाझ़िम प़ाइँ जातलाव मिँराए जूँनी पोंखारिन्‍या झ़िम जैसिउ लिज़्‍या।’ जे ते झन आवलाई चोरराए पुप मिताव जैद जेनै,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","नो पाँ नलाव मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए थैद यारिस चोद, ‘आवलाई कै जैद गेसैःके?’ लिद निउँ खिम्‍केर। खाली माहोल्‍या भरी येसुए ओपाँत बनै अचम्‍ब ताद यालिज़्‍यावए नो सैःव पैंज़्‍यावर येसुलाई रँःद याछे·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ऱिमदा ऱिमदा येसु उसिसरास सहरनी पुलुस्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","हो पराःती छकाल्‍न्‍या येसु उसिसरास नो नेभारा सीं लिज़्‍याव येमलाव घ्याँ याबाज़्‍याक नो सीं ओजरानी थँद उलिज़्‍याव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पत्रुसए नो ङ़ादाङाव चेतैद, “गुर्बा चिऊसाँकी, सराप नयो नेभारा सीं ते उथँव ची ओल्‍यो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","येसुए उसिसरालाई, “परमेस्‍वरए ल्‍योदा जेयुँ उहुप्‍क। ");
INSERT INTO kjl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ङा जेलाई साचो है ङादाचिज़्‍या, जोए उयुँ आदा होदा माजैद, ‘जुनी ब ङादैया ज़’ लिद उयुँ उहुप्‍किन, तोबो हाँलाई, ‘नँ नतिन भोस्‍द समुन्‍द्रल ख्‍यासिन्‍के,’ है ओदोकिन, नो हैज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","है जैद ङा जेलाई है ङादाचिज़्‍या, जोत जेयुँ हुप्‍द ‘ङादैया ज़’ है लिद जेपोंखारिकिन नो दैन्‍या ज़ जेले। ");
INSERT INTO kjl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","परमेस्‍वरलाई जेपोंखारिन्‍या बेलाक सुवारास माखैव काता पाँर जेयुँल जेनैकिन, ङ़ादा होलाई ऱास्‍द बल्‍ल पोंखारिच्‍यो। हो ताकिन ची स्‍वर्गताव जेबाबुए जेलाई मनी जेदोव पाप भरी ऱास्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","फरी नो मिँलाई ऱासो जेमाभैंःकिन स्‍वर्गताव जेबाबुए जेलाई ब ऱास्‍न्‍या माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","येसु उसिसरास फरी यरूसलेमल बाद ध्‍यान झ़िमल यालिज़्‍याक नलाव मुख्‍या पुजारीर, सास्‍त्रीर स़ोनो यहूदीराए यास़ेरर येसुए ल्‍योक हुद, ");
INSERT INTO kjl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“आव नदोज़्‍याव य़ेनर नँलाई सुए है उदींव, सुए हक उईंव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","येसुए, “ङा ब जेलाई तोबो है ङादाचिदा, नोए ओजवाप जेयाँकिन ङा ब आव य़ेन दान्‍या हक सुए ओयाँव है ङादाचिया,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“ऱील सछैंज़्‍याव यूहन्‍नाए ओय़ेन परमेस्‍वरए ल्‍योनी ताव सैं मिँराए ल्‍योनी ताव? है दाँचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","नोर या याल, “ ‘यूहन्‍नाए ओय़ेन परमेस्‍वरनी ताव’ है गेद्या गेलिकिन, ‘हुकी काराव यूहन्‍नाए ओपाँ जेमाभैंःव?’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","फरी ‘मिँनी’ है गेद्या गेलिकिन मिँराए ल्‍योनी ओछ्यास लिज़्‍या,” है लिकेर। मिँ भरिए यूहन्‍नालाई अगमबक्ता ज़ है लिद थ·रैद यानैज़्यावए छे·द नै यालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","है जैद नोराए येसुलाई, “गेमासैंए,” है दोकेर। हाःत ज़ येसुए मनी, “हो ची ताकिन्‍दा ङालाई आव य़ेन दान्‍या हक सुए ओयाँव ङा ब है ङामादाच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","येसुए घर्ती झाःद अइ लिद यासथैक्‍यो, “तोबो मिँए ओएँः भरिल जोम्‍परसै झाःद, प़ाइँनी भार्नाए घिरिद, खादर घोद जोम्‍परसै पीन्‍या कोलो तोबो झाःद, मिँ लिन्‍या खोपोरा ब तोबो जैद, नो एँःलाई अधियाल याद, ओल तोबो तादा देसङ लिनाके दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","नलाव जोम्‍परसैर किन्‍या बेला ओतावत तोबो ओय़ेन दाज़्‍यावलाई उजुँ भरी च़ानाव परींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","नो अधिया कमैज़्‍यावराए झन नोलाई क्‍योःद प़ोद रितो ज़ खेपैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","फरी छींनी छुत ओय़ेन दाज़्‍यावलाई उपरींक नोलाई मनी ओङ़ै पा·द्याद बीज्‍यात जैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","छींनी फरी तोबोलाई उपरींक नोलाई ते झन सैःकेर दी। हिताव ज़ छुत ओरापरींवर ब ख्‍वारालाई याराप़ोकेर दी, ख्‍वारालाई यारासैःकेर दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“ओमापरींव जम्‍मा तोबो बनै उयुँलाव ओज़ा वाज़ रहिके दी। है जैद एँःए ओर्गेए, ‘आवलाई ताकिन ओमान नैदिर सैं’ लिद प़ाइँरानी छींनी नो ओज़ालाई ब परींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","खाली नो ओज़ा उहुज़्‍याव रँःद नो अधिया कमैज़्‍यावर झन या या पाँसिद, ‘आव ते एँः दैन्‍या मिँ ची, आवलाई गेसैःकिन आव एँः गेमीं ज़ तान्‍या ले,’ लिद, ");
INSERT INTO kjl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","नोलाई क्‍योःद सैःद पाखाङ ख्‍याकेर दी।” ");
INSERT INTO kjl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","नकिन येसुए नो मुख्‍या पुजारीर स़ोनो सास्‍त्रीरालाई, “नो एँःए ओर्गेए अधिया कमैज़्‍यावरालाई कै याजैवके लिक ते, नोर प़ाइँलाई ज़ सैःद नो एँः छुतरालाई यान्‍या ले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","येसुए नोरालाई फरी, “जे आव धर्मसास्‍त्रलाव पाँ जेप़रिखेहो, ‘भुलीराए कान्‍ल ज़ माज़्‍यासे लिद याख्‍याव लुँ नो ज़ झन भुयाँरलाव लुँ ताके। ");
INSERT INTO kjl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","आव ओल परमेस्‍वरनी ताव पाँर ज़, इताव रँःद गे अचम्‍ब गेताज़्‍या।’ ” ");
INSERT INTO kjl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","नकिन नो मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ‘आव घर्ती ते गेङ़ैत ज़ झाःद्यासिक्‍यो’ लिन्या सैंद येसुलाई क्‍योःव पैंकेर। खाली ओलस लिज़्‍याव माहोल्‍यारालाई रँःद छे·केर। है जैद कैज़ माजैद अइज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","नोराए छींनी येसुए ओपाँ क्‍योःद्यान्‍याए जूँनी फरिसीर स़ोनो हेरोद राजासकावरालाई येसुए ल्‍योक यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","नोर ओल्‍योक बाद, “गुर्बा, नँ गेस नपाँज़्याव भरी साचो वाज़ लिज़्‍या। परमेस्‍वरए ल्‍योदा बान्‍या येम ब साचोस नपैसिज़्या। मिँ रँःद ब नमादोए, सुए ल्‍योदा ब नमाजैसिए। है जैद गेलाई तोबो पाँ है दाव ताके, माहाराजालाई गे सिर्मा यान्‍या सैं मायान्‍या? ");
INSERT INTO kjl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","किताव दान्‍या?” है यादोक ते, येसुए नोराए याकप्‍तैं सैंद, “ङालाई काराव जेजाँचिनाज़्‍याव? पैसा तोबो रैद्याँचिकेदा, ङाचिऊरिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","नोराए पैसा तोबो रैद याएक ते, येसुए, “आत सुए उसुरूप, सुए उमिन उलिज़्‍याव?” है ओरादोक ते, “माहाराजाए उमीं ज़,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“हो ची ताकिन्‍दा माहाराजाए उमीं भरी माहाराजालाई ज़ एच्‍यो, परमेस्‍वरए उमीं भरी परमेस्‍वरलाई ज़ एच्‍यो,” है ओरादोक ते, नोर नो पाँत बनै अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","नकिन ख्‍वा सदुकीर ब येसुए ल्‍योक पजैना हुकेर। सदुकी है यारादोज़्यावराए ‘सिउकिन सैंसिन्‍या माताए’ है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","है जैद नोराए, “गुर्बा, मोसाए ओकानुनल तोबो अइ लिद सर्सिउ लिज़्‍या, ‘तोबोए ज्‍या दाद ज़ार मादैद उसिकिन, ओभाइए ओदाज्‍युए ओथोर माफ्या·न्‍याए जूँनी ओमारूमलाई ओरैवक।’ ");
INSERT INTO kjl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","है जैद तोबोए ओज़ार सात भाइ याल्‍यो। यादाज्‍युए ज्‍या दाद ज़ार मादैद ज़ सिके। ");
INSERT INTO kjl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","होए उधूँलावए फरी नो ओमारूमलाई रैद नो मनी ज़ार मादैद ज़ सिके। नकिन साइँला मनी हिताव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","नितावनी ज़ सात भाइ भरिए ज़ नो मेंमालाई रैद ज़ार मादैद ज़ सिकेर। प़ाइँरानी छींनी नो मेंमा ब सिके। ");
INSERT INTO kjl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","है जैद नो मेंमा सात भाइए याज्‍या ओतावए अजम्‍बरी जुनील काताकावए याज्‍या तान्‍या?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","हाःत ज़ येसुए, “जे धर्मसास्‍त्रलाव पाँ मातीद परमेस्‍वरए ओसक्ती ब जेमाथ·रैधुवए ज़ चबनै बिरैद जेनै। ");
INSERT INTO kjl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","सिउनी सैंसिद स्‍वर्गत बावर ते सुए ज़ ज्‍या ब मादोर, रे ब मादोर। प़ाइँ ज़ स्‍वर्गताव चाकर्‍या स्‍यासोर ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","फरी जे ‘सिउकिन सैंसिन्‍या माताए’ है ल्‍यो पैंज़्‍यावर धर्मसास्‍त्रलाव मोसाए ओसरोल झोपोरा ओचाँःज़्‍याव जेमाप़रिए रो? नो चाँःज़्‍यावनी परमेस्‍वरए ओपाँ अइ लिद हुके, ‘ङा अब्राहामए ओपरमेस्‍वर, इसहाकए ओपरमेस्‍वर स़ोनो याकूबए ओपरमेस्‍वर ज़।’ ");
INSERT INTO kjl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ओल ते मोरोराए यापरमेस्‍वर माःक, जींदोराए यापरमेस्‍वर ची। है जैद जे चबनै बिरैद जेनै,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","येसु सदुकीरास याखर्लेसिज़्‍याव तोबो सास्‍त्रीए थैद, ‘येसुए थिक जवाप याएक्‍यो’ लिद येसुए ल्‍योक बाद, “गुर्बा, मिँए दान्‍या मादान्‍या य़ेन भरिनी प़ाइँरानी दान्‍या काताकाव उलिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","येसुए, “सर्सिउ भरिनी प़ाइँरानी दान्‍या आव ज़, ‘अ इस्राएलीर थैचिके, जेप्रभु परमेस्‍वर तोबोका तोबो वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","जेयुँलाई आदा होदा मादुलैद, जेर्सा माम़ोंद, जेप्रभु परमेस्‍वरए ल्‍योदा युँ थू जैद ओललाई वाज़ मया दान्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","होए उछींताव दान्‍या य़ेन फरी आव ज़, ‘जेक्‍याँलाई किताव जेसमारिज़्‍या, छुतलाई ब हिताव ज़ समारिन्‍या।’ आव ऩेब्‍लोकिन घेप्‍पा काता ज़ माले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","नो सास्‍त्रीए, “साचो ज़ है नलिके गुर्बा, परमेस्‍वर तोबोका तोबो ज़ लिज़्‍या, छुत माले। ");
INSERT INTO kjl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","फरी नँ है नलिज़्‍याव मिताव युँलाई मादुलैद, सा माम़ोंद, परमेस्‍वरए ल्‍योदा युँ थू जैद ओललाई वाज़ मया दान्‍या, स़ोनो छुतलाई समारिन्‍या बनै ओचाहित ल्‍यो ज़ लिज़्‍या। निताव य़ेन दान्‍या मेंःनी चरैःन्‍या पुजा स़ोनो पाथा पल्‍द चरैःन्‍या पुजाकिन घेप्‍पा लिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","येसुए नोए नाः सैंद ओपाँव थैद, “नँ परमेस्‍वरए ओराज्‍याकिन तादाङ नमाले,” है दोक्‍यो। हाःकिन सुए ज़ येसुस पाँन्‍या आँत मादोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","येसुए ध्‍यान झ़िमल लिज़्‍यावरालाई अइ लिद यासथैक्‍यो, “सास्‍त्रीराए ‘ख्रीस दाऊदए ओथोलाव’ कातानी है यालिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ओल दाऊदए मनी छैंव पुरूसनी अइ लिद पाँद ले, ‘परमेस्‍वरए ङाप्रभुलाई, ‘नसुतुररालाई नखँ धूँल झाःद ङामाईंवा पै, ङावोर्दा च़ुसिद लिन्‍के,’ है दोक्‍यो।’ ");
INSERT INTO kjl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","है जैद ओल दाऊदए मनी ख्रीसलाई ‘ङाप्रभु ज़’ है ओदोकिन नो कै जैद होए ओथोलाव ओताज़्‍याव?” है यादोक्‍यो। माहोल्‍याराए येसुए निताव ओपाँ बनै थै थै ङम्‍सिउ याथ·रैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","येसुए ओपाँ ओरासथैज़्‍याक अइ लिद यासथैक्‍यो, “सास्‍त्रीराए याय़ेननी जोगोइसिद लिच्‍यो। नोर रेरे बेन्बेनो क्‍वा क्‍वाइसिद ‘प़ाइँए धो घदासिरक’ लिन्‍या युँ दाद बजार जीदा दुलिरिज़्यार। ");
INSERT INTO kjl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","नोर फरी धर्मसास्‍त्र झ़िमराल, घ्योःव घ्योःव भत्‍यारल ब प़ाइँए रँःन्‍याक ओमान ल्‍यो पोल वाज़ च़ुसिउ पैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","नो सास्‍त्रीराए झन राँदी मेंमारालाई तँनी छाम छुम याराख्‍याज़्‍यार, मिँराए ङ़ाक वाज़ बनै चाव चाव पोंखारिउ जैसिज़्‍यार। नोराए ते प़ाइँरानी घ्‍योःव सजा ज़ दैरिज़्‍यार,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","नल ध्‍यान झ़िमल येसुए भिती याचरैःज़्‍याव बाकस छ्योक च़ुसिद मिँराए भिती याचरैःज़्‍याव ओराचिऊज़्‍याव। धनी धनीराए बनै कुधु कुधु याझाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","नो बेलाक तोबो काता ज़ माल्‍यो राँदी मेंमा हुद ऩेब्‍लो पैसा चरैःक्‍यो। नो ऩेब्‍लो थोम्‍द तपैसावाकाव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","नो रँःद येसुए उसिसरालाई ओल्‍योक खुल्‍द, “ङा साचो है ङादाचिज़्‍या, आव काता ज़ माल्‍यो राँदी मेंमाए छुतराकिन कुधु चरैःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","धनीराए ते यासय़ेलोनी वाज़ चरैःकेर। नो राँदी मेंमाए ते ओललाई ओमाथैंज़्यावत ब ओलस लिज़्‍याव भरी प़ाइँ ज़ चरैःक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","येसु ध्‍यान झ़िमनी पुलुस्‍द ओबाज़्‍याक तोबो उसिसए, “गुर्बा चिऊसाँकी, काता आः घ्‍योःव घ्‍योःव लुँर, आः चाव झ़िमर,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","येसुए, “हैज़, आव भरी चिऊचिके। खाली छींनी तछा आव भरी तैःद लुँए तर्त लुँ ब रहिन्‍या माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","नकिन जाँवाक येसु ध्‍यान झ़िम होफताव जैतून दाँदात च़ुसिद उलिज़्‍याक पत्रुस, याकूब, यूहन्‍ना स़ोनो अन्‍द्रियासराए अलगज़ा येसुलाई, ");
INSERT INTO kjl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“आव नपाँ भरी खर्क ओतारिज़्‍याव? नोर तान्‍या सरेस किताव ओतारिज़्‍याव? गेलाई है दासिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","येसुए, “जेलाई सुवाराए झुकैचिर्‍या, जे सैंसिद जोगोइसिद लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","मिँर ङा ङामिन कुद ‘ङा ज़ ख्रीस’ है लिद कुधु ज़ हुद कुधुलाई ज़ याराझुकैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","स़ोनो ‘आङ लरैं ताज़्‍या, होङ लरैं ताज़्‍या’ है यालिज़्‍याव जेथैक जे ताछे·च्‍यो। आव भरी जुनी ब ताव ज़ परिए, खाली नो खेम्‍न्‍या बेला माःक। ");
INSERT INTO kjl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","नोकिन ङ़ादा जात जात, राज्‍या राज्‍या लरैं दान्‍या लेर। पो पोल भोंचालोर अनिकालर ब तारिज़्‍या। आव भरी मेंमाए ज़ा दैन्‍या बेलाक ओघर्लिज़्‍याव मिताव सुरूलाव दुख वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“जे फरी सैंसिद लिच्‍यो। हो बेलाक जेलाई मनी अदालतदा लाँद सूँपिचिरिज़्‍यार, धर्मसास्‍त्र झ़िम झ़िमल जेलाई प़ोचिरिज़्‍यार। ङा ङाजूँनी हाकिमर राजाराए ङ़ाक सच्‍याँद खोले·चिरिज़्‍यार। ननी ज़ जे नोरालाई ङासाची यान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","खेम्‍न्‍या बेला ओमाताद ङ़ादा चाव था प़ाइँ जातलाव मिँराए खार्ल थासो ज़ परिके। ");
INSERT INTO kjl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","है जैद नोराए जेलाई क्‍योःद यासूँपिचिक, ‘ङा कै लिन्‍या, काता पाँन्‍या ओताव?’ लिद जेयुँ आँचा पाँचा ताजैच्‍यो। नो बेलाक जो हुज़्‍या हो ज़ पाँच्‍यो। नो पाँज़्‍याव जे माःक, परमेस्‍वरए छैंव उपुरूस जेस लिद ओल ज़ पाँन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","हो बेलाक ओभाइए ओदाज्‍युलाई, ओबाबुए ओज़ालाई सैःन्‍या सजाल यारापारैरिज़्‍यार। याज़ाराए याबाबु याआमाकिन तँदा जैसिद सैःन्‍या सजाल यारापारैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","जे ङामिनतावर जेतावए जेलाई प़ाइँए सोन्‍या लेर। खाली जो आव दुखर ओमाखेमा पै थ॰रिज़्‍या, होए ज़ अजम्‍बरी जुनी दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“आव ब सैंच्‍यो, नो भाःकिनकाव सर्सिउ मिताव तोबो युँ माजामोए ध्‍यान झ़िमलाव चोखो पोल तोबो फुरी हुद ऩुल्‍पा ऩुल्‍मा ओजैहुव जेरँःक यहूदियाल लिज़्‍यावर गों जीदा ओधोंःरक। ");
INSERT INTO kjl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","थालात लिज़्‍यावर ब याझ़िमलाव याआल मालर ताच़ानारक। ");
INSERT INTO kjl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","एँःल लिज़्‍यावर मनी याक्‍वार च़ाना याझ़िमदा ताबारक। ");
INSERT INTO kjl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","हो बेलाक याफूल याज़ा ल्‍योर स़ोनो नुइँ सवैज़्‍याव आमार युँ नावज़ार। ");
INSERT INTO kjl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","निताव दुख ज़्‍यूँःव साहाक ताताक लिद परमेस्‍वरलाई पोंखारिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","हो बेलाकाव दुख बनै धो सहिउ तारिज़्‍या। निताव दुख आव संसार परमेस्‍वरए ओजैवकिन आःपै माहुताए, निताव दुख नोकिन छींनी ब तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","निताव बेला तावका ताव ज़ उलिकिन सु ज़ रहिन्‍या मालेर। खाली ओल परमेस्‍वरए छाँतिद ओरानैज़्‍याव उमींराए जूँनी नो बेला सुतुईंद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“नो बेलाक जेलाई सुवाराए, ‘ख्रीस आङ हुद ले, होङ हुद ले,’ है यादाचिकिन नोरालाई तारापतिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ख्‍वार ङा ङामिन कुद ख्रीस जैसिद हुन्‍या लेर, ख्‍वार परमेस्‍वरए उपुरूसनी पाँव जैसिद हुन्‍या लेर। नोराए अचम्‍ब अचम्‍बलाव सरेसर य़ेनर जैद कुधुलाई झुकैन्‍या लेर। परमेस्‍वरए ओराछाँतिउरालाई मनी झुकैन्‍या छ्यास लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","है जैद जे सैंसिद लिच्‍यो। आव पाँर जेलाई ङ़ादा ज़ है दाद ङानैचिए।” ");
INSERT INTO kjl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“हो बेलाकाव दुख ओखेमोत निमी ब चुम चुमो तारिज़्‍या, स़्यावैए ओज़गै ब म़ारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","सोरोर ब नमतिन तेरिज़्‍यार, नमताव भरी ब यासतर म़ाद थोनो·सिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","हाःत ज़ मिँ मिन्‍सिउलाई बनै ज़गै मगैव ओसक्तीरास बादल जींल उहुज़्‍याव मिँ भरिराए रँःन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","हाःत ज़ स्‍वर्गताव ओचाकर्‍या भरी परींद नाम नमलाव काना कुनीङ लिज़्‍याव चार चौकालाव छाँतिद ओरानैज़्‍याव उमींरालाई ओल्‍योक यादुप्‍रिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“नेभारा सींनी आव अर्थ ब सैंच्‍यो, किताव सींर यामोम्‍नाक ‘उभ्‍याली उहुनाव ची ओल्‍यो’ है जेलिज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","हिताव ज़ नो है ङादाचिउ पाँ भरी ओतानाज़्‍याव जेरँःक ‘ख्रीस उहुन्‍या बेला ओतानाव ची ओल्‍यो’ लिन्‍या सैंच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ङा जेलाई साचो है ङादाचिज़्‍या, आव भरी ओमातावा पै आव जुक खेम्‍न्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","आव नाम नम ते खेम्‍न्‍या ले, ङा ङापाँ ते खर्क ज़ म़ान्‍या माले।” ");
INSERT INTO kjl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“खाली नो छ्याम, नो बेला सुए ज़ मासैंर। स्‍वर्गताव चाकर्‍याराए ब मासैंर, परमेस्‍वरए ओज़ाए ब मासैंव, स्‍वर्गताव ङाबाबुए वाज़ सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","है जैद जे सैंसिद लिच्‍यो। आव छ्याम हुरिज़्‍या लिन्‍या जे जेमासैंए। ");
INSERT INTO kjl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","आव भरी तोबो तादा देसदा बाज़्‍याव मिँ स्‍यासो लिज़्‍या। उझ़िम ओख्‍यानैज़्‍याव बेलाक ओलसकाव लिज़्‍याव भरी ओय़ेन दाज़्‍यावराए यापासल झाःद सु सु याय़ेन जैद्याद, य़ाम गुज़्‍याव पाल्‍यालाई, ‘सैंसिद लिनी,’ है दाद बाज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","है जैद जे ब सैंसिद लिच्‍यो। जेघरपती हुन्‍या ऱिमक ताक्‍या, आधा रील ताक्या, भाल्‍या कोनादा ताक्‍या, नम उसँक ताक्या, जे जेमासैंए। ");
INSERT INTO kjl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","सैंसिद जेमालिकिन उमँःजानी उहुक जेलाई ङ़ल्‍द जेलिज़्‍याव दैहुन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","है जैद जेलाई है ङादाचिउ पाँ प़ाइँलाई ज़ है ङारादोज़्‍या — सैंसिद लिच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","निस्‍तार यादोज़्‍याव माँदा भरेस ज़्‍यान्‍या पर्ब ऩेलाए ओङ़ाल उलिज़्‍याव। हो बेलाक ज़ मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ‘येसुलाई कातानी झुकैद क्‍योःद सैःन्‍या ओताव?’ लिद गुमुस्‍ता यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","नोर, “पर्ब बेलाक माता, म़ानी मिँर मचिन्‍या ओछ्यास लिज़्‍या,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","येसु बेथानिया नाखारल तोबो सिमोन यादोज़्‍याव कुऱीए उझ़िमक काँ उज़्‍युज़्‍याव। हो बेलाक तोबो मेंमाए बनै चाव ज़िम्‍ज़ा लुँ जाल उसी ङरो बनै ओएः ल्‍यो जतामसीए म़ास रैद जाए ओङ़ै केःद येसुए ओङ़ैत ओपो·स ज़ थीदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","निताव रँःद नक लिज़्‍यावर ख्‍वा ख्‍वाराए यायुँ वा वा कैद, “आव मेंमाए काराव नाः ओएः ल्‍यो म़ास खेर ओझाःज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","बुरू नोलाई स़ोंसय चाँदीए सिक्‍काल यो·द नो पैसाए काता ज़ माल्‍योरालाई भाःद ओराएकिन तान्‍या ओल्‍यो,” है लिद नो मेंमालाई सिङार्केर। ");
INSERT INTO kjl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","हाःत ज़ येसुए, “घदोज़्‍यावक, काराव उयुँ केःद जेएज़्‍याव? नोए ते ङाजूँनी बनै चाव य़ेन दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","काता ज़ माल्‍योर ते जेस एकतार ज़ लिज़्‍यार। नोरालाई जो बेलाक जेराएदी ब ताए। ङा ते जेस एकतार लिन्‍या ङामाले। ");
INSERT INTO kjl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","आव मेंमाए उधुवा भरी दाद्याँक्‍यो। ङा ङामासिद ज़ गादैन्‍या छ्यामकावए जूँनी ङामोरोलाई ङ़ादा ज़ थीद ओयाँव मिताव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, संसार भरिल जोङ जोङ चाव था यारासथैज़्‍यार, होङ होङ आव मेंमाए ओदोव य़ेन थास्‍द उमिन ब रहिन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","नकिन बाह्र जना उसिसरानी यहूदा इस्‍करियोतए येसुलाई मुख्‍या पुजारीराए याकुइत पारैन्‍याए जूँनी याल्‍योक बाके। ");
INSERT INTO kjl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","नोर नोए ओपाँ थैद बनै रेंद नोलाई पैसा यान्‍या ब जैकेर। हाःकिन इस्‍करियोतए ‘येसुलाई कै जैद ङासूँपिके?’ लिद मौका खिम्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","हाःत ज़ नो माँदा भरेस ज़्‍यान्‍या पर्ब सुरू ओतावत पाथा पल्‍न्‍या छ्याम येसुए उसिसर ओल्‍योक हुद, “नँ कै नलिज़्या, आव पर्ब मानिन्‍याए जूँनी ज़्‍यावर काङ्क जैनान्‍या?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","येसुए ऩेब्‍लो उसिसनिलाई, “जिन सहरल बाचिन्‍केदा, नल तोबो ऱी गप्‍द ओघागरी छींद बाज़्‍याव मिँ दैन्‍या जिन्‍ले। नोए उछीं उछीं बाद, ");
INSERT INTO kjl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","जोल पसिज़्‍या होल ज़ पसिद नो झ़िमए ओर्गेलाई, ‘नँलाई गेगुर्बाए है दींज़्‍याव, पाहुना लिन्‍या कुन्‍ती काङ्क उलिज़्‍याव? आव पर्ब उसिसरास नल मानिरिज़्‍याव दी,’ है दोचिन। ");
INSERT INTO kjl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","है जिन्‍दोव प़ाइँना नोए ओतर्ताव तालल तोबो घेप्‍पा कुन्‍ती चावस सजैसिउ जिनलाई सतैंद्यान्‍या ले। गेज़्‍याव भरी नल ज़ जैचिन,” है दाद निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","है जैद नोनी ननी पुलुस्‍द सहरल बाद है उनिदोव मिताव ज़ दैद पर्बताव ज़्‍याव भरी जैकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","हो छ्याम ऱिमक येसु बाह्र जना उसिसरास नो झ़िमल दुप्‍सिहुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","नोर च़ुसिद ज़्‍यावर याज़्‍युज़्‍याक येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, जेनी तोबोए ङालाई धोका यान्‍या ले, आख ङास सिप ज़्‍युज़्‍याव मिँ ज़,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","उसिसर यायुँ माचाव दाद, “ङा ते माताखेहो सा,” है लिद पालास पालास है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","हाःत ज़ येसुए, “बाह्र जना भरिनी जोए ङास भरेस चिपल छोइद ज़्‍युज़्‍याव, हो ज़। ");
INSERT INTO kjl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ङा मिँ मिन्‍सिउए ते धर्मसास्‍त्रलाव सर्सिउ मिताव दुखर जुनी ब सयो·व ज़ परिए, खाली ङालाई धोका याज़्याव मिँलाई ते थैए माँतकन ज़ लिज़्‍या। निताव मिँ बुरू ओमाजर्मिकिन तान्‍या ओल्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","नकिन नो याज़्‍युज़्‍यावत ज़ येसुए उकुइत भरेस तोबो रैद, असिक ऩिद नो भरेसलाई केःद, “हाँ, आव ज़्‍युचिके। आव ङाक्‍याँ ज़,” है दाद भाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","हो मिताव ज़ फरी खुरी उकुइत रैद धन्‍याबाद चरैःद नोरालाई याएक्‍यो। प़ाइँए ननी याओवत, ");
INSERT INTO kjl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","येसुए, “आव जेओज़्‍याव कुधु मिँराए जूँनी ङासोभोरिज़्‍याव ङाझी ज़। आनी ज़ परमेस्‍वरए जेस साःरो बाचा नैद्याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ङा साचो ज़ है ङादाचिज़्‍या, परमेस्‍वरए ओराज्‍याल साःरोनी ङामाओवा पै ङा आव भत्‍यारलाव दाखमद्य आछिमकिन ओन्‍या ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","नकिन भजन तोबो गैद ननी पुलुस्‍द जैतून दाँदादा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","नकिन येसुए उसिसरालाई, “जे ङालाई प़ाइँए ऱास्‍न्‍या जेले। धर्मसास्‍त्रल इताव सर्सिउ लिज़्‍या, ‘बेधाराए यार्गे गावलालाई प़ोद ङासैःवत, बेधार चितराँ पुतराँ तारिज़्‍यार।’ ");
INSERT INTO kjl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","हैदी ब सिउनी सैंसिद जेङ़ादा ज़ गालीलल ङाबारिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पत्रुसए, “प्रभु, उपुर्कावराए प़ाइँए याऱास्‍निदी ब ङा ते नँलाई ङामाऱास्‍नी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","येसुए, “ङा नँलाई साचो है ङादींज़्‍या, आछिम रील भाल्‍या ऩेकराँ ओमाकोद ज़ ङालाई स़ोंखेप, ‘ङामासरेसे,’ है दान्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पत्रुसए झन ज़, “माःक, ङा नँस सिन्‍या ओतादी ब ङा नँलाई ङामासरेसे है लिन्‍या ङामाले,” है दोक्‍यो। उपुर्कावराए मनी हैज़ लिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","नकिन येसु उसिसरास गेतसमनी यादोज़्‍याव बगैचाल बाद उसिसरालाई, “ङा ङापोंखारिवा पै जे आक ज़ लिच्‍यो,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","पत्रुस, याकूब स़ोनो यूहन्‍नारालाई ओलस यालाँक्‍यो। हाःत ज़ येसु उयुँर स्‍यासे सतेद धो थाइव तानाद, ");
INSERT INTO kjl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","नो स़ोम्‍लोरालाई, “ङायुँर स्‍यासे तेद सिवा सिवा ताद ङाले। जे आक ज़ लिद सैंसिद लिचिके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","नोराकिन छ्यावा होकसै बाद नामक फुलुप्‍सिद ओक्‍याँत हुरिज़्‍याव दुखर भर्सकी ताहुक लिद, ");
INSERT INTO kjl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“अब्बा, बाबु, नँ नमादोधुव काता ज़ माले, आव ङाक्‍याँत हुरिज़्‍याव धो सहिउ दुखर वैंद्याँके। खाली ङा ङायुँ ते माःक, नँ नयुँ ओताकिन वाज़,” है लिद पोंखारिद, ");
INSERT INTO kjl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","नो स़ोम्‍लोराए ल्‍योक उहुवत नोर ङ़ल्‍द यालिज़्‍याव दैहुद पत्रुसलाई, “सिमोन, नँ ङ़ल्‍द नलिज़्‍याव रो? नँ कै जैद ङास तघन्‍ता पै ब नमालिधुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जे प़ाइँ ज़ सैंसिद पोंखारिचिके, म़ानी दुखराल जेमाथ॰रिधुया। जेयुँए ते दान्‍या ज़ पैंज़्याव, खाली पाखाताव जेक्‍याँए ते मासहिधुन्‍या ओछ्यास लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","नकिन येसु फरी ब ङ़ादाङाव ओपोंखारिज़्‍याव पोक बाद हो मिताव ज़ पोंखारिद, ");
INSERT INTO kjl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","नो स़ोम्‍लोराए ल्‍योक उहुक फरी ब ङ़ल्‍द यालिज़्‍याव ज़ यादैहुक्‍यो। नोराए यामीर बनै पातिद यामासहिधुवए यालाजए येसुस काता ज़ मापाँधुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फरी तखेप छींनी ब नोरालाई ङ़ल्‍द यालिज़्‍याव ज़ दैहुद, “आःपै जेमीर मायो·ताए रो? ताया, अब बेला यो·के। ङा मिँ मिन्‍सिउ पापीराए कुइत ङासूँपिसिरिके। ");
INSERT INTO kjl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","च्‍याँःसिचिके, गेबा। ङालाई धोका याज़्‍याव मिँ नक ज़ हुद ले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","येसु ओपाँज़्‍याक ज़ नो बाह्र जना उसिसरानिकाव यहूदा इस्‍करियोत बनै माहोल्‍या मिँरास तरवालीर खोंतार रैद हुकेर। नोर मुख्‍या पुजारीर, सास्‍त्रीर स़ोनो यहूदीराए यास़ेरराए ल्‍योनी हुद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","नो इस्‍करियोतए ङ़ादा ज़ नो क्‍योःना हुज़्‍यावरालाई, “ङा जोलाई माइँ ङादोए, होलाई ज़ क्‍योःद लाँच्‍यो,” लिद सरेस याद ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","है जैद बगैचाल याकेसो प़ाइँना इस्‍करियोत येसुए ल्‍योक बाद, “जेरो गुर्बा,” लिद माइँ दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","हाःत ज़ नो माहोल्‍याराए येसुलाई ताप तप क्‍योःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","नकाव च्‍याँःसिद लिज़्‍याव तोबोए ओतरवाली हाइद प्रधान पुजारीए ओनोकोरलाई तँनिकाव ओर्ना पल्‍द सतेदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","नकिन येसुए नो क्‍योःना हुव माहोल्‍यारालाई, “काराव ङालाई दाँकालाई मिताव तरवालीर खोंतार दाद जेक्‍योःहुनाव? ");
INSERT INTO kjl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","जेलाई दिनकाव ज़ ध्‍यान झ़िमल परमेस्‍वरए ओपाँ ङासथैचिक जेमाक्‍योःनाके। खाली धर्मसास्‍त्रलाव सर्सिउ पाँ सयो·व ज़ परिके,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","उसिस भरी येसुलाई ऱास्‍द चितराँ पुतराँ धोंःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","हो बेलाक तोबो धापाज़ाकाव छोर्‍या नाङग्‍या ओक्‍याँत पालो क्‍वा वाज़ भिरिसिउ उलिज़्‍याव। होलाई मनी याक्‍योःव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ओक्‍वार ख्‍यानैद नाङग्‍या ज़ धोंःके। ");
INSERT INTO kjl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","नकिन नो क्‍योःना हुवराए येसुलाई प्रधान पुजारीए ल्‍योक लाँकेर। नक मुख्‍या पुजारीर, यहूदीराए यास़ेरर स़ोनो सास्‍त्रीर दुप्‍सिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","हो बेलाक पत्रुस जाँ तादाङ याछीं याछीं हुद नो प्रधान पुजारीए ओचतराक ज़ हुद नलाव पाल्‍यारास च़ुसिद मेंः उमुइँसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","नो झ़िमल मुख्‍या पुजारीर स़ोनो घ्‍योःव कचरीलाव स़ेर भरिए सैःन्‍या कर याखिम्‍ज़्‍याव, कर ते कान्‍त ज़ मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","धुत गोहाई पाँन्‍यार कुधु ज़ यातावए सु सु यापाँ ब माखैके। ");
INSERT INTO kjl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","बल्‍ल तोबो ऩेब्‍लो च्‍याँःसिद अऩाकलाव पाँर पले·द अइ लिकेर, ");
INSERT INTO kjl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“आवए, ‘ङा आव कुइए जैसिउ ध्‍यान झ़िमलाई तैःद फरी स़ोंलात कुइए माजैसिउ ध्‍यान झ़िम ङाजैरिज़्‍या,’ है ओल्‍यो गे ज़ गेथैके,” है यादोक ब, ");
INSERT INTO kjl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","नोराए यापाँ ब माखैके। ");
INSERT INTO kjl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","हाःत ज़ नो प्रधान पुजारी याखार्ल च्‍याँःसिद येसुलाई, “नँ नपाँ काता ज़ ओमालिज़्‍याव रो? आवराए नङ़ैत झाःद याईंव पाँ किताव उलिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","येसुए घाइ ज़ मादोक्‍यो। फरी नो प्रधान पुजारीए, “नँ माहान परमेस्‍वरए ओज़ा ख्रीस सैं माःक?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","येसुए, “ङा साचो हो ज़। तछा ङा मिँ मिन्‍सिउलाई माहान परमेस्‍वरए ओवोर्दा च़ुसिद ङालिज़्‍याव ब रँःन्‍या जेले, स़ोनो स्‍वर्गतिन बादलरास ङाहुज़्‍याव ब रँःन्‍या जेले,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","प्रधान पुजारीए उरिसए ओक्‍वार चीए चीए, “छुत गोहाई काता ओचाहिउ? ");
INSERT INTO kjl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","जे ज़ जेथैके, आवए परमेस्‍वरए उमिन ओबले·ज़्याव। जे कै जेलिज़्‍या?” है ओरादोक ते, प़ाइँए ज़ सैःन्‍या थ·रैद, ");
INSERT INTO kjl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ख्‍वाराए येसुलाई त़िल्‍द, उमीर कप्‍द्याद मुत्‍काए प़ोकेर। नै जैज़्‍यावराए फरी, “नँलाई प़ोज़्‍याव सु,” है लिद बरे·केर। सिपाईंराए पाला येसुलाई प़ोए प़ोए लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","पत्रुस मेल चतराक ज़ उलिज़्‍याव। नो बेलाक प्रधान पुजारीए ओय़ेन दाज़्‍याव तोबो मेंमा हुद, ");
INSERT INTO kjl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","पत्रुसलाई मेंः उमुइँसिज़्‍याव रँःद, नोलाई लँ लँ चिऊद, “नँ मनी नासरतलाव येसुस नल्‍यो सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","पत्रुस माभैंःद, “नँ काता नपाँज़्‍याव इताव, ङा ते काता ज़ ङामासैंए,” है दाद ननी पुलुस्‍द साँबिलाक बाके। हो प़ाइँना ज़ भाल्‍या कोके। ");
INSERT INTO kjl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","नकिन जाँ छ्यावाक नो मेंमाए फरी पत्रुसलाई रँःद नक लिज़्‍यावरालाई, “आव ते साचो होसकाव ज़ ओल्‍यो,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पत्रुस फरी ब माभैंःके। फरी छ्यावाक नक लिज़्‍यावराए, “नँ ब साचो उसिसरासकाव ज़, नँ ते गालीललाव ज़ ची,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पत्रुस बनै थल्‍सिद किर्‍या झाःद, “नो है जेलिज़्‍याव मिँलाई सरेस ज़ ङामासरेसे,” है ओरादोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","भाल्‍या ऩेकराँ कोके। नाःत ज़ ङ़ादा येसुए पत्रुसलाई, “भाल्‍या ऩेकराँ ओमाकोद ज़ स़ोंखेप ङालाई, ‘ङामासरेसे’ है लिन्‍या नले,” है ओदोव पाँ ब चेतैक्‍यो। नो चेतैद पत्रुस बनै घर्के। ");
INSERT INTO kjl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","छकाल्न्या घग ज़ मुख्‍या पुजारीर, यहूदीराए यास़ेरर, सास्‍त्रीर स़ोनो घ्‍योःव कचरीलाव भरी यासल्‍ला खैद येसुलाई किद पिलातसए ल्‍योक लाँद सूँपिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","है जैद पिलातसए येसुलाई, “नँ साचो यहूदीराए याराजा ज़ रो?” है ओदोक ते, येसुए, “नँ ज़ नथ·रैनाके सानी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","नाःत ज़ मुख्‍या पुजारीराए येसुलाई कुधु ज़ खतर लैकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातसए, “काराव घाइ नमालिज़्‍याव? नाः कुधु पाँर नङ़ैत झाःद याईंज़्‍याव नमाथैए रो?” है ओदोक ब, ");
INSERT INTO kjl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","येसु झन ज़ तोबो ब मापाँके। निताव रँःद पिलातस अचम्‍ब ताके। ");
INSERT INTO kjl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पिलातसए ओपालाक सालकाव तखेप निस्‍तार पर्बत यहूदीराए जो कैदीलाई ‘ऱास्‍द्यासिके’ है लिज़्‍यार, होलाई ज़ ऱास्‍द ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","हो बेलाक तोबो बारब्‍बा यादोज़्‍याव ओनैंरास झ्यालखानाल यालिज़्‍याव। नोर सरकारकिन तँदा जैसिद मिँरालाई मचैद तोबो ऩेब्‍लोलाई सैःद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","है जैद माहोल्‍याराए पिलातसए ल्‍योक बाद, “सालकाव तखेप तोबो कैदीलाई ऱास्‍द नयासिज़्‍याव मिताव आथ पाला ब तोबोलाई ऱास्‍द्याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातसए, “हुकी यहूदीराए याराजालाई ऱास्‍द ङायाच्‍यो रो?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ओल पिलातसए ते ‘आवराए येसुलाई अऩाकल ज़ यामी तूद सूँपिद नैनार’ लिन्‍या सैंद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","मुख्‍या पुजारीराए झन मिँरालाई मचैद, “माःक, नो बारब्‍बालाई ऱास्‍द्यासिके,” है दाव यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","नो पाँ थैद पिलातसए फरी, “हुकी नो यहूदीराए याराजा जेदोज़्‍यावलाई ङा कै जैन्‍या की?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","नोर, “क्रुसत तङ्गैद सैःन्‍या,” है लिद क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातसए फरी, “काराव? आवए मादान्‍या काता दाद ओनैज़्‍याव?” है ओरादोक ते, नोर झन ज़ मचिद, “क्रुसत तङ्गैद सैःन्‍या,” है लिद बनै ज़ क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","है जैद पिलातसए माहोल्‍यारालाई सभैंःन्‍याए जूँनी बारब्‍बालाई ऱास्‍द्याद येसुलाई रीःद, क्रुसत तङ्गैद सैःन्‍याए जूँनी सिपाईंरालाई ज़ यासूँपिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","हाःत ज़ सिपाईंराए येसुलाई प्रेतोरियन यादोज़्याव दरबार जींल लाँद रोमी पल्‍तन भरी यारादुप्‍केर। ");
INSERT INTO kjl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","नोराए येसुलाई घ्यामर्‍यासो क्‍वा जास्‍द, ज़ुए मुकुत ऱ॰द ओङ़ैत जास्‍द, ");
INSERT INTO kjl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“ए यहूदीराए याराजा, जय जय ओताक,” है लिद बरे·द, ");
INSERT INTO kjl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ओङ़ैत भाताए प़ोद्याद, त़िल्‍द, ओङ़ाक याघूँदानी फुलुप्‍सिद धो दाद ओमान नैद्याव मिताव जैसिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","गिल्‍लैद गिल्‍लैद च़िम यादोवत नो घ्यामर्‍यासो क्‍वा सिउःद्याद, ङ़ादाङाव ओक्‍वार जास्‍द क्रुसत तङ्गैना लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","यालाँज़्‍याक तोबो नाखारनी हुज़्‍याव कुरेनीलाव सिमोनलाई येसुए ओलाँज़्‍याव क्रुस सुघुर्केर। नो मिँ अलेक्‍जेन्‍दर स़ोनो रूफसनी निबाबु ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","येसुलाई गलगथा यादोज़्‍यावक सकेस्‍केर। नो पोए उमिन ‘खप्‍पर्‍या पो’ है ब यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","नक येसुलाई वासः झाःसिउ दाखमद्य यासवैक ते येसुए ओव माभैंःके। ");
INSERT INTO kjl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","हाःत ज़ येसुलाई क्रुसत तङ्गैकेर। यातङ्गैवत ओक्‍वारात गोला झाःद भाःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","क्रुसत यातङ्गैव बेलाक नौ बजिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ओललाई तङ्गैद यानैज़्‍याव क्रुसए ओङ़ैत, “आव यहूदीराए याराजा ज़” है लिद तोबो फल्‍यात ओखत सर्द चकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","नो छ्याम ऩेब्‍लो चोरनिलाई मनी तोबोलाई ओवोर्दा तोबोलाई ओदाबर्‍यादा जैद क्रुसत तङ्गैद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","है जैद धर्मसास्‍त्रलाव सर्सिउ पाँ ब नत ज़ यो·के। नलाव सर्सिउ आव ज़, “नो अपराधीरास गनिसिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","आनी हुनी भाल्‍सिना हुवराए याङ़ैर ङ़त ङ़त जैद थल्‍द, “हाइ! हाइ! नँ ‘ध्‍यान झ़िमलाई तैःद स़ोंलात ङाजैरिज़्‍या’ है लिज़्‍याव मिँ, ");
INSERT INTO kjl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","नँ क्रुसतिन झरिद हुद नक्‍याँलाई बाँचैके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","हिताव ज़ मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए या याल येसुलाई गिल्‍लैद, “आवए छुतरालाई ताकितर याबाँचैज़्‍याव, ओल ओक्‍याँलाई कै जैद ओमाबाँचैधुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएलीराए याराजा ख्रीस जैसिज़्‍याव नो क्रुसतिन झरिद उहुकदा, गे नो रँःद ओपाँ पतिन्‍या गेले,” है लिकेर। ओलस तङ्गैसिउ चोरनी मनी हैज़ लिकिनी। ");
INSERT INTO kjl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","नकिन बाह्र बजेकिन तीन बजे पै देस भरी काल्‍या कले झ्याके। ");
INSERT INTO kjl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","तीन बजेवाक येसु बनै चोइस, “इलोई, इलोई, लामा सबखथनी?” है लिद क़िके। नोए ओसै, “अ ङापरमेस्‍वर, अ ङापरमेस्‍वर, ङालाई काराव नऱास्‍नाव?” ");
INSERT INTO kjl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","नक च्‍याँःसिद लिज़्‍यावराए नो पाँ थैद ख्‍वाराए, “थैचिसाँ, आवए ते एलियालाई ची उखुल्‍ज़्‍याव सा,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तोबोए धोंःनाद भाताए उतुपात थाकना पो·द सिरो दाखमद्यल छिम्‍द येसुए ओयाःत झाःद्याद पिउ परींद, “अब ते चिऊद गेनैया, एलिया कातारानी हुद माहाइज़्‍याव?” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","नाःत ज़ येसु बनै चोइस क़िद उस॰ सफ्या·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","हो प़ाइँना ज़ ध्‍यान झ़िमलाव बारिसिउ क्‍वा ब उतुपानी ओजराङ पै ओलनी ज़ ऩेपरा ताद चिस्‍के। ");
INSERT INTO kjl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","येसुए ओङ़ाक च्‍याँःसिद लिज़्‍याव कप्‍तानए निताव उस॰ ओफ्या·व रँःद, “आव ते साचो ज़ परमेस्‍वरए ओज़ा ची ओल्‍यो,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","हो बेलाक ख्‍वा मेंमाराए ब जाँ तादानी येसुलाई चिऊद यानैज़्‍याव। नोरानी मरियम मग्‍दलिनी, ज़िम्‍ज़ा याकूब स़ोनो योसीनी निआमा मरियम, स़ोनो नोनिस सलोमी ब ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","येसु गालीलल उलिज़्‍याव बेलाक नोर ओलस ओलस बाऱिद ओसेवा यादोज़्‍याव। यरूसलेम पै ओलस हुव छुत मेंमार ब कुधु ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ऩासिन्‍या छ्यामए ओङ़ालाव तयारीलाव दिन ओल्‍यो। हो छ्याम र्‍याम्‍या रिमी ओझ्यानाक, ");
INSERT INTO kjl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","तोबो अरिमाथियालाव योसेफए घ्‍योःव युँस पिलातसए ल्‍योक बाद येसुए ओमोरो ऩिक्‍यो। नो घ्‍योःव कचरीलाव घेप्‍पा मिँ ओल्‍यो। ओल मनी परमेस्‍वरए ओराज्‍यालाव येम खिम्‍ज़्‍याव मिँ ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातसए येसु ङ़ादा ज़ उसिधुव पाँ थैद अचम्‍ब ताद कप्‍तानलाई ओल्‍योक खुल्‍द, “येसु साचो उसिधुव रो?” है लिद सुधिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","है जैद नोए ओल्‍योनी येसु सिके लिन्‍या ओथैवत ओमोरो योसेफलाई लाँव एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","योसेफए फरी पालो क्‍वा लँःद येसुए ओमोरोलाई क्रुसतिन हाइद, नो क्‍वाए लुम्‍बैद दावन खुपिद पुप जैद ओनैज़्याव खादरल झाःद ओय़ामक घ्‍योःव लुँए कक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मग्‍दलिनी स़ोनो योसीए ओआमा मरियमनी नो ओझाःज़्‍याव पो चिऊद निनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ऩासिन्‍या छ्याम ओखेमोत मरियम मग्‍दलिनी, याकूबए ओआमा मरियम, नोनी निनैं सलोमीरास येसुए ओमोरोलाई थीद्यान्‍याए जूँनी चाव सी ङरो म़ासर अतरर लँःद, ");
INSERT INTO kjl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","सातालाव उस॰कताव छ्याम घग ज़ घाम पले·क नोर खादर पोदा याबाज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","नोराए, “गेलाई नो कसिउ लुँ सुए पल्‍तैद्यासिउके?” है लिद, ");
INSERT INTO kjl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","खादरदा याभाल्‍सिक ते नो बनै घ्‍योःव लुँ पल्‍तैसिउ उलिज़्‍याव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","नोर फरी खादर पुपल पसिद नल उजींल तोबो पालो क्‍वा क्‍वाइसिउ धापाज़ाकाव मिँ खादरए ओवोर त॰दा च़ुसिद उलिज़्‍याव रँःद बनै ज़ अचम्‍ब ताद यालिज़्‍याक ते, ");
INSERT INTO kjl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","नोए, “अचम्‍ब ताताच्‍यो, नो जेखिम्‍ज़्‍याव क्रुसत यासैःव नासरतलाव येसु आल माले, सैंसिद सोधुके। अछादी आव यानैव पो चिऊचिकेदा, ");
INSERT INTO kjl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","जे पत्रुस स़ोनो उपुर्काव उसिसराए ल्‍योदा बाद, ‘येसु जेङ़ादा ज़ गालीलदा बाज़्‍या दी। ओल है उलिज़्‍याव मिताव, होङ ज़ ओलस दैसिन्‍या जेले,’ है यारादोनाचिके,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","नोर ननी धोंःद याछ्याचेए बनै भुम भुम गूद सुलाई ज़ नो पाँ है मारादोधुकेर। ");
INSERT INTO kjl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","सातालाव उस॰कताव छ्याम छकाल्‍न्‍या घग ज़ येसु सिउनी सैंसिद ओसोवत प़ाइँरानी ङ़ादा मरियम मग्‍दलिनीए ओल्‍योक सरैंःसिके। नो मेंमाए ओक्‍याँतिन येसुए ङ़ादा सात गोता माचाव पुरूसर पले·द ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","है जैद नोए उसिसराए ल्‍योक बाद उरँःव भरी है यादोक्‍यो। नो बेलाक नोर यायुँ बनै माचाव दाद घरो ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","खाली नोराए, ‘येसु सैंसिके, ङा ज़ रँःद ङानै,’ है ओल्‍यो पाँ याथैज़्‍यावत ब मापतिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","फरी छींनी येसुए उसिसनी नाखारदा निबाज़्‍याक येमत येसु छुत सुरूप जैसिद निङ़ाक सरैंःसिके। ");
INSERT INTO kjl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","नोनी ओल्‍द बाद उपुर्कावरालाई है निरादोक ते, नोनी निपाँ ब मापतिकेर। ");
INSERT INTO kjl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","नकिन छींनी एघार जना उसिसर काँ याज़्‍युज़्‍याक येसु नोराए याङ़ाक ब सरैंःसिके। नोराए खाव यायुँए जूँनी येसु सिउनी ओसैंसिउत ओललाई रँःज़्यावराए यापाँत यायुँ ओमाहुबोए येसुए नोरालाई यासिङार्क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","स़ोनो, “जे आव संसार भरिल प़ाइँदा ज़ बाद चाव था प़ाइँलाई ज़ यारासथैनाच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जोए उयुँ हुप्‍द परमेस्‍वरए उमिनत सछैंसिज़्‍या, हो बाँचिन्‍या ले। फरी जोए उयुँ माहुबे, होए परमेस्‍वरए ओसजा दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","यायुँ हुप्‍ज़्‍यावराए याक्‍याँत इताव सरेसर ब तान्‍या लेर — ङा ङामिननी माचाव पुरूसर ब पले·न्‍या लेर, साःरो साःरो खामनी ब पाँन्‍या लेर, ");
INSERT INTO kjl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","घुलरालाई याराक्‍योःदी ब, तुन्‍यार याज़्‍युदी ब कैज़ तान्‍या मालेर। याजोरो हुवराए याक्‍याँत याकुइ नैद याराएक नोर गराँन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","है जैद प्रभु येसुए ओपाँ भरी है ओरादोवत याङ़ाकिन ज़ स्‍वर्गदा छींसिद परमेस्‍वरए ओवोर्दा च़ुसिनाके। ");
INSERT INTO kjl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","उसिसर ते ननी बाद परमेस्‍वरए ओपाँर प़ाइँदा ज़ यारासथैनाकेर। प्रभु यास यास ज़ लिद नो यारासथैज़्‍याव पाँत अचम्‍बलाव सरेसर जैद्याद नो यापाँ थैज़्‍याव भरिरालाई साचो ज़ थ·रैद याएक्‍यो। आमेन।");
INSERT INTO kjl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","प़ाइँए गेखार्लाव ताव भरी कुधुए कागतत चरैःन्‍या उदिम दाद नैर। ");
INSERT INTO kjl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","नोराए यासरो भरी ङ़ादाकिन ज़ येसुस लिद ओय़ेन रँःवर ओपाँ सथैज़्‍यावराए ल्‍योनी ज़ सर्द नैर। ");
INSERT INTO kjl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","गेङ़ैताव थियोफिलस, ङा ब ङ़ादाकिन ज़ बनै चावस तहकैद प़ाइँ पाँ भरी खिम्‍द ङानै, स़ोनो नजूँनी तोबो ओमेलास ताव पाँ सर्न्या युँ ङादोके। ");
INSERT INTO kjl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","हो ताकिन नँलाई है दासिउ पाँर साचो ज़ ओल्‍यो लिन्‍या सैंन्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदियालाव राजा हेरोदए ओपालाक अबिया थरलाव तोबो पुजारी जकरिया यादोज़्‍याव उलिज़्‍याव। नोए ओज्‍या ब हारून पुजारीए ओखलकलाव ज़, उमिन एलीसिबा ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","नोनी ज्‍या-री ज़ परमेस्‍वरए ओङ़ाक धर्मलाव य़ेन दाद निजुनी निझाःज़्‍याव, परमेस्‍वरए ओकानुन ब माबिरैद ज़ निदोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","खाली एलीसिबा जर्मननी ज़ थारी ओल्‍योए नोनी निज़ार तोबो ब यामालिज़्‍याव। नोनी ऩेब्‍लो ज़ निबेला बाद सेर्द जूचास्‍द निलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","तछा जकरिया परमेस्‍वरए ओङ़ाक पुजारी य़ेन ओदोज़्‍याव। हो साता भरिल ध्‍यान झ़िमलाव सेवा दान्‍या नोए ओखलकराए यापाला ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","पुजारीराए याचलन मिताव परमेस्‍वरए ओध्‍यान झ़िमल धुप झाःन्‍याए जूँनी गोला याझाःक जकरिया परिके। ");
INSERT INTO kjl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","नो उजींल पसिद धुप ओझाःज़्‍याक उपुर्काव मिँ भरिए लाँःक पोंखारिउ ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","नल उलिज़्‍याक परमेस्‍वरए ओचाकर्‍यालाई धुप ओझाःज़्‍याव पोए ओवोर्दा च्‍याँःसिद उलिज़्‍याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","नोलाई रँःद जकरियाए उयुँ स्‍यासे सतेद बनै छे·के। ");
INSERT INTO kjl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","नाःत ज़ परमेस्‍वरए ओचाकर्‍याए, “नँ ताछे·नी जकरिया, नपोंखारिज़्‍याव परमेस्‍वरए थैक्‍यो। है जैद नज्‍या एलीसिबाए ज़ा तोबो दैरिज़्‍याव। नँ नोए उमिन यूहन्‍ना नैदियो। ");
INSERT INTO kjl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","नो उजर्मिक नयुँ बनै होलाँ ताद रेंन्‍या नले। छुतर ब रेंन्‍या लेर, ");
INSERT INTO kjl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","काराव ल्‍यो ताकिन नो परमेस्‍वरए ओङ़ाक घेप्‍पा मिँ थ॰रिन्‍या ले। नोए ज़िम्‍ज़ाकिन ज़ मद छोकोरा जात्त ज़ ओन्‍या माले। नो ओआमाए उफूल ज़ छैंव पुरूस दैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","नोए इस्राएलीरालाई याप्रभु परमेस्‍वरए ल्‍योदा कुधुलाई ज़ यायुँ फर्कैद याएरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","नोए एलियाए ओसक्ती ओगेर रैद हुरिज़्‍याव ख्रीसए ओङ़ादा बाद होए उजूँनी मिँरालाई तयार याजैरिज़्‍याव। बाबुरालाई याज़ारास यासखैरिज़्‍याव, पापीरालाई ब धर्मलाव येमल याझाःरिज़्‍याव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","हाःत ज़ जकरियाए परमेस्‍वरए ओचाकर्‍यालाई, “आव भरी ङा कै जैद पतिन्‍या? ङा ङासेरधुके, ङाज्‍या ब जूचास्‍धुके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","परमेस्‍वरए ओचाकर्‍याए, “ङा एकतार परमेस्‍वरए ओङ़ाकाव च्‍याँःसिज़्‍याव गब्रिएल ज़। नल्‍योदा आव चाव था सथैना परींद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ङालाई नमापतिनाव प़ाइँना आव है ङादींव य़ाका भरी ओमातावा पै नँ लाता ताद मापाँधुन्‍या तान्‍या नले। ङा है ङादींव पाँ थिक हो बेलाक ज़ यो·न्‍या ले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","हाः बेलाक नो लाँःकाव लिज़्‍यावराए ‘काता ओदोव?’ लिद जकरियालाई कींद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","बल्‍ल बल्‍लङ नोराए ल्‍योङ पुलुस्‍द नोरास काता ज़ मापाँधुद उकुइए सान दाद ओरायोए नोराए, “आवए ते ध्‍यान झ़िमल परमेस्‍वरए ओदर्सन ओदैव ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जकरिया ध्‍यान झ़िमलाव सेवा दान्‍या ओपाला ओयो·वत उझ़िमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","नाःकिन ज़ ओज्‍या एलीसिबा ज़ा दैन्‍या ताद पाँच मैना भरी आदा होदा माबाद उझ़िमल ज़ लिद, ");
INSERT INTO kjl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“मिँराए ङालाई अइज़ फ्या·के है यादाँदी ब परमेस्‍वरए ङालाई उयुँ नाद ज़ा दैन्‍या जैनाक्‍यो,” है उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलीसिबा छ मैना ओतावत परमेस्‍वरए फरी ओचाकर्‍या गब्रिएललाई ज़ गालील खन्‍दलाव नासरत सहरल ");
INSERT INTO kjl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","तोबो कन्‍या ल़ुज़ाए ल्‍योक परींक्‍यो। नो ल़ुज़ालाई भर्ज़ा दाऊदए ओथोलाव योसेफ यादोज़्‍यावत ऩिद यानैज़्‍याव। नोए उमिन मरियम ओल्यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","परमेस्‍वरए ओचाकर्‍या ओल्‍योक बाद, “जेरो प़ाइँरानी असिक दैव मेंमा, परमेस्‍वर नँस ज़ लिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","‘आव काता ओपाँव ओताव?’ लिद उयुँ काता माँःती जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","नो चाकर्‍याए फरी, “ताछे·नी मरियम, परमेस्‍वरए उयुँ नल्‍योदा गराँद ले। ");
INSERT INTO kjl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","नँ गर्बवती ताद खेपा ज़ा तोबो नदैरिज़्‍या। नोए उमिन येसु नैदियो। ");
INSERT INTO kjl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","नो बनै घ्‍योःव मिँ ताद माहान परमेस्‍वरए ओज़ा ज़ लिद थ·रैरिज़्‍यार। नोलाई परमेस्‍वरए, ओल उपुर्खा दाऊदए ओराज्‍या चलैन्‍या जैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","है जैद याकूबए ओथोलावराए याङ़ैताव ज़ ताद नोए ओराज्‍या खर्क ज़ खेम्‍न्‍या माले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","हाःत ज़ मरियमए, “आव भरी कै जैद तान्‍या? ङा आःपै कन्‍या ज़ ङालिज़्या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","नो चाकर्‍याए, “नँ नक्‍याँत परमेस्‍वरए छैंव उपुरूस हुद माहान परमेस्‍वरए ओसक्तीनी ज़ा नदैरिज़्‍या। है जैद नो छैंव पुरूसनिकाव भाउज़ालाई परमेस्‍वरए ओज़ा ज़ है दान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अछादी नँ नक्‍याँदाङाव एलीसिबाए पाला जूचास्‍द ब ज़ा दैन्‍या ताद ले। नो खर्क ज़ ज़ा मादैव है यादोज़्‍याव एलीसिबाए उफूलाव ओज़ा छ मैना ताधुके। ");
INSERT INTO kjl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","परमेस्‍वरए ओमादोधुव काता ज़ माले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियमए, “ङा परमेस्‍वरए ओबाँदानी ज़। है नलिज़्‍याव मिताव ज़ ओताक,” है ओदोव प़ाइँना ज़ परमेस्‍वरए ओचाकर्‍या पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","तछा छींनी मरियम झाःसिद लाला लुलु यहूदियालाव गोंल जकरियाए ओनाखारल बाके। ");
INSERT INTO kjl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","जकरियाए उझ़िमल पसिद मरियमए एलीसिबालाई जेरो है ओदोज़्याव ");
INSERT INTO kjl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ओथैव प़ाइँना एलीसिबाए उफूलाव ओज़ा ज़ो·के। हाःत ज़ एलीसिबा छैंव पुरूसए ब्याल्‍द, ");
INSERT INTO kjl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","बनै रेंद, “मेंमा भरिरानी नँ असिक दैव ज़ नलिज़्‍या। नफूलाव नज़ा ब असिक दैव ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","काता ङालाई आः परमेस्‍वर दाइनो ओताव, ङाप्रभुए ओआमा ङाल्‍योक नहुव। ");
INSERT INTO kjl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","नँ नयाःनी जेरो है नल्‍यो प़ाइँना ज़ ङाफूलाव ङाज़ा रेंद ज़ो·के। ");
INSERT INTO kjl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","नँ परमेस्‍वरए है उलिज़्‍याव भरी सयो·द्यान्‍या ज़ ले लिद नयुँ हुबो मेंमा धन्‍याकाव नलिज़्‍या,” है लिद पाँके। ");
INSERT INTO kjl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","मरियम नो भरी थैद है लिके, “ङा ङाप्रभु परमेस्‍वरए उमिन बनै सघ्‍योःद ङाएज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ङालाई बाँचैज़्‍याव परमेस्‍वरस बनै रेंद ज़ ङापाँज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","नोए ङा इताव ज़िम्‍ज़ा ओबाँदानीलाई मामेंःद ङाल्‍योदा उयुँ य़ाल्‍के। ननी ज़ मिँराए ङालाई प़िरी प़िरी पै असिक दैव थ·रैनारिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ङाजूँनी आःल्‍दिउ य़ेन दाद्याज़्‍याव माहान परमेस्‍वरए उमिन बनै छैंव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","परमेस्‍वरलाई रँःद छे·ज़्‍यावरालाई ओल प़िरी प़िरी पै उयुँ नाज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","नोराए जूँनी उकुइए बनै सक्तीलाव य़ेन दाद्याव ज़ नैज़्‍याव। यायुँल सघ्‍योःसिज़्‍यावरालाई ते चितराँ पुतराँ जैद यामिन सम़ैद याएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","घेप्‍पारालाई यासिंहासनतिन स़ेल्‍द नल ज़िम्‍ज़ारालाई याझाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","करेज़्‍यावरालाई चाव चाव याद याकरे सैःद याएज़्‍याव। साहुरालाई ते रितो ज़ याजैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ओय़ाकार मामेंःद ओसेवा दोज़्याव इस्राएली उमींरालाई सघैव ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","है जैद अब्राहाम स़ोनो ओथोरालाई है ओरादोव मिताव याल्‍योदा एकम्‍न्‍या उयुँ गराँव ज़ लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम एलीसिबाए उझ़िमक ओल्‍यो स़ोंमैना ओतावत उझ़िमदा ओल्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","एलीसिबाए ज़ा दैन्‍या ओमास ओयो·वत खेपा ज़ा दैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","‘परमेस्‍वरए उयुँ य़ाल्‍द अचम्‍बलाव य़ेन दोदिक्‍यो दी’ लिन्‍या थैद ओलापजीकावर स़ोनो ओक्‍याँदाङावर बनै रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","नो भाउज़ा उजर्मिउ आथ दिनत याचलन मिताव क्‍याल्‍न्‍या सरेस जैन्‍याए जूँनी प़ाइँ दुप्‍सिद उमिन ब ओबाबुए उमिन स्‍यासो ‘जकरिया’ नैद्याव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","खाली ओआमाए भैंःद मायाद, “माःक, आवए उमिन यूहन्‍ना तारिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","नोराए, “नथोल इताव मिन ते माले सानी,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","फरी नोराए ओबाबु जकरियालाई सान दाद्याद, “नो नज़ाए उमिन काता नैद्याव नपैंज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","जकरियाए फल्‍या तोबो रैव परींद नत, ‘आवए उमिन यूहन्‍ना’ लिद सर्द याएक्‍यो। नोराए निताव रँःद प़ाइँ ज़ अचम्ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","हो प़ाइँना ज़ जकरियाए ओसेर पलास्‍सिद पाँधुन्‍या ताद परमेस्‍वरलाई धन्‍या धन्‍या है ल्‍यो ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","नो हुद लिज़्‍यावर नो भरी रँःद अचम्ब ताद छे·द नो पाँ भरी यहूदिया गों जीदा प़ाइँदा ज़ थास्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","‘नो भाउज़ा ओघ्‍योःक किताव तान्‍या ओताव?’ लिद थैज़्‍याव भरिए यायुँल है लिकेर। नोए ओक्‍याँत परमेस्‍वरए बास दाद ओनैज़्‍याव ओल्‍यो लिन्‍या थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ओबाबु जकरिया छैंव पुरूसए ब्याल्‍द अइ लिद पाँके, ");
INSERT INTO kjl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राएलीराए याप्रभु परमेस्‍वरए उमिन बनै ओघ्‍योःक। गे उमींराए गेल्‍योक हुद बाँचैसिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ओनोकोर दाऊद राजाए ओथोल गेलाई जोगोइद बाँचैन्‍या तोबो झेंःस्‍या उथैद नैद्यासिउ। ");
INSERT INTO kjl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","नोए उजूँनी परमेस्‍वरए भाःकिन ज़ छैंव उमीं अगमबक्ताराए यायाःनी पाँव ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","नोराए यापाँ आव ब लिज़्‍या — ‘गेसुतुरराए ल्‍योनी जोगोइद, गेलाई सोज़्‍यावराए याकुइनी ब पाथस पले·न्‍या ले।’ ");
INSERT INTO kjl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","है जैद गेसाखा पुर्खाराए ल्‍योदा उयुँ गराँद, नोरालाई ओरायो छैंव बाचालाई सयो·द्याव ज़ नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","नो बाचा गेपुर्खा अब्राहामलाई तोबो किर्‍या झाःद — ");
INSERT INTO kjl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘गेलाई गेसुतुरराए ल्‍योनी पले·न्‍या, स़ोनो गेजिउ भरी ओलस लिद उयुँलाव मिताव छैंव य़ेन सुलाई रँःद ब माछे·द ज़ दान्‍या जैद नैद्यासिउ।’ ");
INSERT INTO kjl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","अब ते नँ ङाज़ा यूहन्‍ना, नँलाई माहान परमेस्‍वरए अगमबक्ता थ·रैनिरिज़्‍यार। नँ हुरिज़्‍याव प्रभुए ओङ़ा ओङ़ा बाद ओयेम बनैद्यान्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","स़ोनो परमेस्‍वरए उमीं इस्राएलीरालाई ‘जेपाप क्‍याल्‍द याचिरिज़्‍याव’ लिद अजम्‍बरी जुनील बान्‍या येम सतैंद्यान्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","गेल्‍योदा परमेस्‍वरए उयुँ ओगराँवनी स्‍वर्गताव झ़ार झ़ारो ज़गै ब गेल्‍योक ज़ हुरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","नो उहुवत सिन्‍या सजालाव चुम चुमोल लिज़्‍यावराए याक्‍याँत पलाँव जैद्याद गेलाई मनी परमेस्‍वरए ल्‍योदा खैन्‍या येम सरैंःद्यासिरिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","नो भाउज़ा यूहन्‍ना ओघ्‍योःनावत ओसक्ती ल्‍यो तानाके। इस्राएलीराए याङ़ाक ओमासतैंसिवा पै बनङ ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","हो बेलाक तछा रोमी माहाराजा अगस्‍तसए रोमी राज्या भरिलाव जनसंख्‍या सर्न्‍या हुकुम याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","नो उस॰कताव यासरो जनसंख्‍या सिरिया खन्‍दलाव हाकिम कुरेनियसए ओपालाक ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","यामिन सर्सिना प़ाइँ ज़ सु सु यासाखा पुर्खार याजर्मिउ सहर सहरदा ज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","है जैद योसेफ पाला उलिज़्‍याव गालील खन्‍दलाव नासरतनी यहूदिया खन्‍दलाव बेथलेहेम यादोज़्याव दाऊद राजाए ओनाखारल उमिन सर्सिना बाके, काराव ल्‍यो ताकिन योसेफ दाऊदए ओथोलाव ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ऩिद यानैज़्‍याव ओज्‍या मरियमलाई ब ओलस ज़ लाँक्‍यो। नो बेलाक मरियम गिसो क्‍याँस उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","बेथलेहेमल निलिज़्‍याक ज़ सुत्‍क्‍याल्‍नी तान्‍या बेला ताद, ");
INSERT INTO kjl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","जेथा ज़ा दैक्‍यो। नो उजर्मिउ प़ाइँना ज़ दालए दाल्द बाछाराए छी ज़्‍यान्‍या पोल नैक्‍यो। भत्तील लिन्‍या पो निमादैवए गोथल निलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","हो छ्याम रील नो नाखारकिन पाखाङ तोबो बाँल गावलाराए बेधार तबगाल खर्कैद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","हाः बेलाक ज़ परमेस्‍वरए तोबो ओचाकर्‍या उमँःजानी गावलाराए याल्‍योक सरैंःसिहुद परमेस्‍वरए ओज़गै ब प़ाइँदा ज़ ज़गै जैक्‍यो। नो रँःद बनै छे·केर। ");
INSERT INTO kjl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","हाःत ज़ नो चाकर्‍याए, “जे ताछे·च्‍यो, ङा जेलाई बनै चाव था रैद नैद ङायाचिए। नो थात मिँ भरी बनै रेंन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","आछिम दाऊदए ओनाखारल इस्राएलीरालाई बाँचैन्‍या तोबो जर्मिद ले। नो जर्मिउ प्रभु ख्रीस ज़। ");
INSERT INTO kjl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","जे नोलाई सरेस्‍न्‍या सरेस, नो भाउज़ालाई बाछाराए छी ज़्‍यान्‍या पोल दालए दाल्‍सिउ सेप्‍सिउ दैन्‍या जेले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","हाःत ज़ नो चाकर्‍याए ओनैंर बनै माहोल्‍या हुद परमेस्‍वरए ल्‍योदा बनै खुसी ताद है लिकेर, ");
INSERT INTO kjl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्‍वर्गताव परमेस्‍वरलाई ज़गै मगै ओताक, मानुवाताव उयुँलाव मिताव मिँराए यायुँ ब होलाँ ओताक।” ");
INSERT INTO kjl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","नो परमेस्‍वरए ओचाकर्‍यार स्‍वर्गदा याबाव छींनी नो बेधा गावलाराए या याल, “दे, गे बेथलेहेमदा गेबा, प्रभुए है ओदासिउ गेचिऊना,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","लाला लुलु नाखारल धोंःनाद मरियम स़ोनो योसेफनिलाई यारादैकेर। नो भाउज़ालाई ब बाछाराए छी ज़्‍यान्‍या पोल सेप्‍सिउ दैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","है जैद आव रँःद नो भाउज़ाए उजूँनी परमेस्‍वरए ओचाकर्‍याए है ओरादोव भरी है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","नो गावलाराए यापाँ थैव भरी प़ाइँ ज़ अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","मरियम ते नो पाँ भरी उयुँल नैद खामिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","नो गावलाराए नो चाकर्‍याए है ओरादोव मिताव याथैव यारँःवए परमेस्‍वरए उमिन सघ्‍योःद्याद ओल्‍योदा बनै खुसी ताद रेंए रेंए ओल्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","नो भाउज़ा उजर्मिउ आथ दिनत क्‍याल्‍न्‍या सरेस जैन्‍या छ्याम उमिन ब येसु नैदिकेर। नो मिन ओआमाए उफूल ओमासिर्जिद ज़ परमेस्‍वरए ओचाकर्‍याए नैद ओयो मिन ज़। ");
INSERT INTO kjl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","मोसाए ओकानुनलाव मिताव मरियम सुत्‍क्‍याल्‍नी चोखोइसिन्‍या बेला ओयो·वत यरूसलेमलाव ध्‍यान झ़िमल बाद येसुलाई परमेस्‍वरए उमिनत नैकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","परमेस्‍वरए ओकानुनलाव सर्सिउ मिताव, “ङ़ाताव जर्मिउ खेपा भरी परमेस्‍वरए उमिनत नैव ज़ परिए।” ");
INSERT INTO kjl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","हो छ्याम ज़ फरी ओआमा चोखोइसिन्‍याए जूँनी परमेस्‍वरए ओकानुन मिताव, कुइतम तादी ब परिवा तादी ब तोजोर लाँद चरैःव उपरिज़्‍याव। हो मिताव ज़ नोनी लाँद चरैःकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","हो बेलाक यरूसलेमल तोबो सिमियोन यादोज़्‍याव उलिज़्‍याव। नो मिँ चाव धर्मी मिँ ओल्‍यो। इस्राएलीरालाई बाँचैना हुन्‍यालाई कींव ज़ ओनैज़्‍याव। नोस परमेस्‍वरए छैंव उपुरूसए बास दाद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","नोए ‘परमेस्‍वरए ओज़ा ख्रीसलाई ङामारँःवा पै सिन्‍या ङामाले’ लिद परमेस्‍वरए छैंव उपुरूसनी सैंद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","है जैद तछा नोलाई परमेस्‍वरए उपुरूसए ध्‍यान झ़िमल लाँक्‍यो। हो बेलाक ज़ येसुलाई ब ओबाबु स़ोनो ओआमानी कानुन मितावनी परमेस्‍वरए उमिनत नैन्‍याए जूँनी ध्‍यान झ़िमल हुद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","सिमियोनए नो भाउज़ालाई उरँःव प़ाइँना ज़ नोलाई ओघोइँल छींद अइ लिद परमेस्‍वरलाई धन्‍याबाद चरैःक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“अ परमेस्‍वर, अब ते है नदाँव मिताव ताके। अब ते आव संसारनी ङा ननोकोरलाई खुसीस बिदा नयाँदी ब ताए। ");
INSERT INTO kjl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","संसारलाई बाँचैन्‍याए जूँनी नपरींव मिँलाई आव ङामीए ज़ ङारँःके। ");
INSERT INTO kjl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","नोलाई प़ाइँ मिँराए याङ़ाक तयार जैद नराएके। ");
INSERT INTO kjl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","छुत जातलावरालाई आवए ओक्‍याँनी ज़ नय़ेन सतैंद नराएरिज़्‍या। स़ोनो नमीं इस्राएलीरालाई ब आवए ओक्‍याँनी ज़ याइज्‍यात नैद नराएरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","येसुए ओबाबु ओआमानी सिमियोनए ओपाँ भरी थैद बनै ज़ अचम्ब ताकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","नकिन सिमियोनए नोरालाई असिक याद ओआमा मरियमलाई, “इस्राएलीराए याखार्ल आव भाउज़ाए ओपाँत कुधुए यायुँ त़ोल्‍रिज़्‍या, कुधुए यायुँ थ॰रिरिज़्‍या। परमेस्‍वरए आव भाउज़ालाई ओल ओसरेस मिताव जैद नैव। नोलाई कुधुए यामाभैंःज़्‍यावए, ");
INSERT INTO kjl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","यायुँलाव पाँ भरी ननी ज़ रैंःरिज़्‍या। नयुँलाई पाला तरवालीए आनी हुनी सफेर्सिउ मिताव जैदींरिज़्‍याव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","हो बेलाक ज़ ध्‍यान झ़िमल आसेरए ओथोलाव फनुएलए ओज़ा बनै जूचासो तोबो हन्‍ना यादोज़्‍याव मनी उलिज़्‍याव। नो ब अगमबादिनी ज़ ओल्‍यो। नोए रे ओदोव सात बर्सत ज़ ओरे सिद, ");
INSERT INTO kjl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","चौरासी बर्स पै बिनु रे ज़ ध्‍यान झ़िमल लिद उपासिद लाकनी रील परमेस्‍वरलाई पोंखारिउ ज़ ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","नोए ब येसुलाई उरँःव प़ाइँना परमेस्‍वरलाई धन्‍याबाद चरैःद यरूसलेम सहरलाव ‘गेलाई बाँचैज़्याव हुरिज़्‍या’ लिद कींद नैज़्‍यावरालाई येसुए उजूँनी हो छ्यामकिन सथैव ज़ यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","योसेफ स़ोनो मरियमनी परमेस्‍वरए ओकानुनलाव ध्‍यान झ़िमलाव याय़ेन भरी ओखेमोत निझ़िम गालीललाव नासरतदा निज़ा लाँद बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","नो भाउज़ा घ्‍योःनाद ओर्सा ब ज़्‍यास्‍नाके, उबुद्धी ब छिप्‍नाके। परमेस्‍वरए ओअसिक ब ओक्‍याँत ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","येसुए ओबाबु ओआमानी यरूसलेमलाव निस्‍तार पर्ब मानिन्‍याए जूँनी सालकाव तखेप निबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","तछा येसु बाह्र बर्स ओतावत सालकाव याबाज़्‍याव मिताव ज़ फरी ब बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","नो पर्ब भरी ओखेमोत याझ़िमदा याबाज़्‍याक येसु यरूसलेमल ज़ उरहिउ ओल्‍यो। ओबाबु ओआमानी मासैंकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","नोनी ‘गेनैंरास हुज़्‍याखेहो’ लिद तछाकाव येम भरी ज़ बाकिनी। छींनी यानैंराए ल्‍यो जीदा साप्‍द, ");
INSERT INTO kjl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","निमादैक ते सापे सापे यरूसलेमदा ज़ ओल्‍द बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","स़ोंलात ध्‍यान झ़िमल घेप्‍पा घेप्‍पा धर्मगुरूराए खार्ल च़ुसिद यापाँ थैद ओअर्थ ल्‍यो पाँ तीद पलासो ओरापरींज़्‍याव रँःकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","नलाव थैज़्‍याव भरी येसुए उबुद्धीसकाव ओपाँर थैद प़ाइँ ज़ अचम्ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ओबाबु ओआमानी ब निताव रँःद अचम्ब ताद ओआमाए, “काराव ङाज़ा आः दुख नयासिनो? गिन नँलाई साप्‍द गिन्‍च्‍या सिके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","येसुए, “जिन काराव ङालाई जिन्‍साप्‍नाज़्‍याव? ङा ङाबाबुए उझ़िमल ल्‍यो परिए लिन्‍या जिन्‍मासैंए रो?” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","नोनी है उनिदोव पाँए ओअर्थ मातीधुकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","येसु ओबाबु ओआमानिस नासरतल बाद नोनी निपाँल ज़ लिके। ओआमाए आव पाँ भरी उयुँल खामिउ ज़ नैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","येसुए ओर्सा ब छिप्‍नाके, उबुद्धी ब झन ज़ पुलुस्‍नाके। परमेस्‍वरए स़ोनो मिँराए बनै चाव ज़ रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","माहाराजा तिबेरिअसए राज्‍या ओदोव पन्‍ध्र बर्स ओतावत पन्‍तियस पिलातस यहूदियालाव हाकिम उलिज़्‍याव। नो बेलाक हेरोद गालील खन्‍दलाव राजा उलिज़्‍याव। ओभाइ फिलिप ईतुरिया स़ोनो त्राखोनितिस खन्‍दलाव राजा उलिज़्‍याव, फरी लुसानियास अबिलेने खन्‍दलाव राजा उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हन्‍नास स़ोनो कैयाफानी फरी ध्‍यान झ़िमलाव पुजारीराए याघेप्‍पानी निलिज़्‍याव। नो बेलाक ज़ परमेस्‍वरए ओपाँ जकरियाए ओज़ा यूहन्‍नाए ओक्‍याँत हुके। नो मिँ बनल उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","हो बेलाकिन ज़ नोए मिँरालाई, “जेपापलाई ऱास्‍द, जेयुँ परमेस्‍वरए ल्‍योदा फर्कैद ऱील सछैंसिचिके। हो ताकिन ची जेपापर क्‍याल्‍सिद परमेस्‍वरस खैवर तान्‍या जेले,” है लिद सथैए सथैए यर्दन भै याक प़ाइँदा ज़ हुके। ");
INSERT INTO kjl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","किताव यसैया अगमबक्ताए ओसरो, हो मिताव ज़ ताके। होए ओसरो आव ज़, “बनल तोबोए ओर्गा अइ लिद यासथैरिज़्‍याव, ‘हुरिज़्‍याव प्रभुए ओयेम बनैद गाँत्‍या गुँतीलाई सदाँचिके। ");
INSERT INTO kjl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","झेंःवर तैःद घैराल सब्‍याल्‍चिके, गाँत्‍या गुँतीलाई सदाँद काँ काँ कुँ कुँर सरिप्‍चिके। ");
INSERT INTO kjl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","हाःकिन मिँ भरिए परमेस्‍वरनी बाँचैना हुवलाई रँःन्‍या जेले।’ ” ");
INSERT INTO kjl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","हो मिताव ज़ यूहन्‍नाए ल्‍योक ऱील सछैंसिना हुव माहोल्‍यारालाई, “ए घुलए ओथोर, जे परमेस्‍वरए उरिसनी धोंःन्‍या सुए है ओदाचिउ? ");
INSERT INTO kjl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","जे साचो ज़ परमेस्‍वरए ल्‍योदा जेयुँ फर्कैन्‍या ल्‍यो ताकिन साचो हो मिताव य़ेन ब दाव ताके। जे फरी, ‘गेपुर्खा अब्राहामनी ज़ परमेस्‍वरए ओज़ार ताद गेले’ है जेमालिदी ब ताए। ङा साचो है ङादाचिज़्‍या, परमेस्‍वरए सींर लुँरानी तादी ब अब्राहामए ओथोर याजैधुव। ");
INSERT INTO kjl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","किताव तोबो मिँए चाव सै माझाःज़्‍याव सींर धलैद मेंःल ओराख्‍याज़्‍याव, हिताव ज़ परमेस्‍वरए ब धलैन्‍याए जूँनी ओरोवा सींए ओजराक झाःद नैव।” ");
INSERT INTO kjl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","हाःत ज़ नो माहोल्‍याराए, “हिताव ताकिन ते गे कै लिन्‍या ओताव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्‍नाए, “जे जोस ऩेब्‍लो क्‍वा उलिकिन माल्‍योलाई तोबो ओयोक, स़ोनो ज़्‍याव उलिकिन माल्‍योलाई ब ओयोक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","सिर्मा स्‍यो·ज़्‍यावर मनी सछैंसिना हुद, “गुर्बा, गे कै लिन्‍या?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","यूहन्‍नाए, “जेलाई खा स्‍यो·न्‍या है दाद नैचिर, हाःज़ स्‍यो·च्‍यो, आगल्‍या ताराहाइच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","फरी सिपाईंराए पाला, “गे कै लिन्‍या?” है यादोक ते, यूहन्‍नाए, “जे कोभालाई सचे·द धुत खत लैद हाइद ताराज़्‍युच्‍यो। जेतलब खा लिज़्‍या हाःत ज़ लिच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","हाः बेलाक प़ाइँ मिँराए यूहन्‍नाए ओपाँ थैद, “आव ते आस दाद कींद गेनैज़्‍याव ख्रीस ची सा,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","यूहन्‍नाए नो यापाँ थैद, “ङा जेलाई ऱील सछैंज़्‍याव वाज़ ची। ङा ङाछींनी ङाकिन ओसक्ती ल्‍यो तोबो हुरिज़्‍या। ङा होए ओपोलाए ओच़ें पला·न्‍या स्‍यासो ब ङामाले। होए परमेस्‍वरए छैंव उपुरूस स़ोनो मेंःनी सछैंचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","होए गेदा भरी नाङलील च्‍याप्‍द चाव भरी धन्‍सारल झाःद पुल भरिलाई खर्क ज़ माजिप्‍तिन्‍या मेंःल म़ुन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","इताव अर्थर कुधु ज़ झाःद यूहन्‍नाए मिँरालाई परमेस्‍वरए ओपाँ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","हाः बेलाक राजा हेरोदए, ओभाइए ओज्‍या हेरोदियासलाई रैद ओनैज़्‍याव। यूहन्‍नाए, “नभाइए ओज्‍या नँ रैन्‍या माताए। नँ प़ाइँल ज़ माचाव य़ेन नदोज़्‍या,” है ओदोवए, ");
INSERT INTO kjl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","यूहन्‍नालाई झ्यालखानाल झाःक्‍यो। है जैद हेरोदलाई पापए तर्त पाप चा·सिके। ");
INSERT INTO kjl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","यूहन्‍ना झ्यालखानाल ओमाबाद मिँ भरी प़ाइँ यूहन्‍नानी यासछैंसिज़्‍याक येसु पाला सछैंसिके। येसु ऱील सछैंसिद ओपोंखारिज़्‍याक नम फैसिद, ");
INSERT INTO kjl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","परमेस्‍वरए छैंव उपुरूस कुइतम मिताव भुर्हुद येसुए ओक्‍याँत च़ुसिके। हाःत ज़ नमतिन तोबो गा अइ लिद हुके, “नँ ङायुँलाव ङाज़ा ज़। नँलाई रँःद ङायुँ होलाँ ताज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","येसु ओय़ेनत उथूसिज़्‍याक तीस बर्सवाकाव ओल्‍यो। नोलाई मिँराए योसेफए ओज़ाल यागनिज़्‍याव। योसेफए ओबाबु एली, ");
INSERT INTO kjl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एलीए ओबाबु मत्तात, मत्तातए ओबाबु लेबी, लेबीए ओबाबु मल्‍की, मल्‍कीए ओबाबु यान्‍ना, यान्‍नाए ओबाबु योसेफ, ");
INSERT INTO kjl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","योसेफए ओबाबु मत्ताथियास, मत्ताथियासए ओबाबु आमोस, आमोसए ओबाबु नहूम, नहूमए ओबाबु इसली, इसलीए ओबाबु नग्‍गै, ");
INSERT INTO kjl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नग्‍गैए ओबाबु माथ, माथए ओबाबु मत्ताथियास, मत्ताथियासए ओबाबु सेमैन, सेमैनए ओबाबु योसेख, योसेखए ओबाबु योदा, ");
INSERT INTO kjl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाए ओबाबु योआनन, योआननए ओबाबु रेसा, रेसाए ओबाबु यरूबाबेल, यरूबाबेलए ओबाबु सालतिएल, सालतिएलए ओबाबु नेरी, ");
INSERT INTO kjl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरीए ओबाबु मल्‍की, मल्‍कीए ओबाबु अद्दी, अद्दीए ओबाबु कोसाम, कोसामए ओबाबु एलमादम, एलमादमए ओबाबु एर, ");
INSERT INTO kjl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एरए ओबाबु यहोसू, यहोसूए ओबाबु एलीएजर, एलीएजरए ओबाबु योरीम, योरीमए ओबाबु मत्तात, मत्तातए ओबाबु लेबी, ");
INSERT INTO kjl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेबीए ओबाबु सिमियोन, सिमियोनए ओबाबु यहूदा, यहूदाए ओबाबु योसेफ, योसेफए ओबाबु योनान, योनानए ओबाबु एल्‍याकीम, ");
INSERT INTO kjl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एल्‍याकीमए ओबाबु मलेआ, मलेआए ओबाबु मिन्‍ना, मिन्‍नाए ओबाबु मत्ताथा, मत्ताथाए ओबाबु नातान, नातानए ओबाबु दाऊद, ");
INSERT INTO kjl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊदए ओबाबु यिसै, यिसैए ओबाबु ओबेद, ओबेदए ओबाबु बोअज, बोअजए ओबाबु सल्‍मोन, सल्‍मोनए ओबाबु नहसोन, ");
INSERT INTO kjl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहसोनए ओबाबु अम्‍मीनादाब, अम्‍मीनादाबए ओबाबु आराम, आरामए ओबाबु हेस्रोन, हेस्रोनए ओबाबु फारेस, फारेसए ओबाबु यहूदा, ");
INSERT INTO kjl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदाए ओबाबु याकूब, याकूबए ओबाबु इसहाक, इसहाकए ओबाबु अब्राहाम, अब्राहामए ओबाबु तेरह, तेरहए ओबाबु नाहोर, ");
INSERT INTO kjl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोरए ओबाबु सरूग, सरूगए ओबाबु रऊ, रऊए ओबाबु पेलेग, पेलेगए ओबाबु एबेर, एबेरए ओबाबु सेलह, ");
INSERT INTO kjl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","सेलहए ओबाबु केनान, केनानए ओबाबु अर्पसद, अर्पसदए ओबाबु सेम, सेमए ओबाबु नोआ, नोआए ओबाबु लेमेख, ");
INSERT INTO kjl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लेमेखए ओबाबु मतूसेलह, मतूसेलहए ओबाबु हनोक, हनोकए ओबाबु येरेद, येरेदए ओबाबु महलालेल, महलालेलए ओबाबु केनान, ");
INSERT INTO kjl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनानए ओबाबु एनोस, एनोसए ओबाबु सेत, सेतए ओबाबु आदम, आदम फरी परमेस्‍वरनिकाव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","येसु यर्दन भैल ओसछैंसिउत छैंव पुरूसए ब्याल्‍द ननी पुलुस्‍द ओबाज़्‍याक नो पुरूसए तोबो साइँसुइँव पोङ लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","नल चालीस दिन भरी सैतानए येसुलाई झुकैन्‍याए जूँनी जाँचिउ ज़ नैक्‍यो। नाः भरिल येसु काता ज़ माज़्‍याद लिके। चालीस दिन ओतावत ओकरेए माधुनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","हाःत ज़ सैतान ओल्‍योक हुद, “नँ साचो ज़ परमेस्‍वरए ओज़ा ताकिन आव लुँलाई भरेस जैके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","येसुए, “धर्मसास्‍त्रल अइ लिद सर्सिउ लिज़्‍या, ‘मिँलाई ज़्‍यावए वाज़ माङाव,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","नकिन सैतानए तोबो झेंःव पोत लाँद संसारलाव राज्‍या भरी तोचोइत ज़ सतैंद्याद, ");
INSERT INTO kjl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“नो नरँःज़्‍याव राज्‍या भरी ज़गै मगैवस नमीं ज़ जैद ङाईंरिज़्‍या। आव भरी ङाकुइत ज़ लिज़्या, जोलाई ङा याव ङापैंज़्‍या होलाई ज़ ङाएधुइ। ");
INSERT INTO kjl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","है जैद नँ ङाङ़ाक फुलुप्‍सिद धो नदाँकिन नो भरी नमींर ज़ तान्‍या लेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","नाःत ज़ फरी येसुए, “धर्मसास्‍त्रल अइ लिद सर्सिउ लिज़्‍या, ‘नप्रभु परमेस्‍वरए ओङ़ाक फुलुप्‍सिद होए ओसेवा वाज़ दान्‍या ताए,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","सैतानए फरी येसुलाई यरूसलेमल लाँद ध्‍यान झ़िमए उतुपात बैद, “नँ साचो ज़ परमेस्‍वरए ओज़ा ताकिन आतिनी मेल ज़ो·निके। ");
INSERT INTO kjl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","धर्मसास्‍त्रल अइ लिद सर्सिउ लिज़्‍या, ‘नँलाई बाँचैन्‍याए जूँनी परमेस्‍वरए ओचाकर्‍यार परींदींरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","नोराए नँलाई छींद नखँ लुँत बजारिउ यान्‍या मालेर,’ ” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","येसुए, “धर्मसास्‍त्रल आव ब सर्सिउ लिज़्‍या, ‘नप्रभु परमेस्‍वरलाई जाँचिन्‍या माताए,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","सैतानए येसुलाई प़ाइँनी ज़ जाँचिद छुत मौका ओमादैवा पै ऱास्‍द ख्‍यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","हाःत ज़ येसु छैंव पुरूसए ओसक्ती दैद गालीलदा ज़ ओल्‍द बाके। हाःकिन येसुए ओय़ेन नयाल प़ाइँदा ज़ थास्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","धर्मसास्‍त्र झ़िम झ़िमक बाद परमेस्‍वरए ओपाँ ब प़ाइँलाई ज़ यासथैक्‍यो। नो पाँ थैद प़ाइँए ज़ येसुए उमिन सघ्‍योःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","नकिन येसु ओल ओघ्‍योःव नाखार नासरतल ज़ हुके। एकतारकाव ओदोज़्‍याव मिताव ज़ ऩासिन्‍या छ्याम धर्मसास्‍त्र झ़िमल बाद परमेस्‍वरए ओपाँ प़रिन्‍याए जूँनी च्‍याँःसिके। ");
INSERT INTO kjl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","नलावराए यसैया अगमबक्ताए ओसरो पोस्‍तोको एकेर। येसुए नो पोस्‍तोको फैद नल ओल उजूँनी सर्सिउलाई पले·क्‍यो। नलाव सर्सिउ आव ज़, ");
INSERT INTO kjl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“परमेस्‍वरए उपुरूस ङाक्‍याँत लिज़्‍या। गरीबरालाई चाव था सथैन्‍या ङालाई खतैद नैनाव। कैतल लिज़्‍यावरालाई पुलुस्‍न्‍या येम आव ज़ लिद सथैन्‍याए जूँनी, मारँःज़्‍यावरालाई यामी फैद्यान्‍याए जूँनी, दुखल लिज़्‍यावरालाई ऱास्‍न्‍याए जूँनी, ");
INSERT INTO kjl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","स़ोनो परमेस्‍वरए ओल उमींरालाई ओराबाँचैरिज़्‍याव था सथैन्‍याए जूँनी परींद नैनाव।” ");
INSERT INTO kjl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","हाःत ज़ येसुए नो पोस्‍तोकोलाई बन जैद नो याज़्‍यावलाई सोवोल्‍द्याद च़ुसिके। नलाव दुप्‍सिद लिज़्‍याव भरिराए यामी येसुए ओक्‍याँत ज़ उलिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","येसुए नोरालाई, “आछिमकाव प़रिद ङायाचिउ धर्मसास्‍त्रलाव पाँ जेथैज़्‍याक ज़ यो·के,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","नलाव लिज़्‍याव भरिए येसुए ओपाँ बनै चाव थ·रैद अचम्‍ब ताद, “काता आव योसेफए ओज़ा माःक रो?” है लिद जाँ मापतिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","है जैद येसुए नोरालाई, “जे ङालाई प़ाइँए याझाःज़्‍याव घर्ती स्‍यासो जेजैनाज़्‍याखेहो। नो घर्ती आव ज़ — ‘ए सगराँज़्‍याव, ङ़ादा नक्‍याँलाई नसगराँधुज़्‍याव सतैंके।’ जे कफर्नहुमल ङादोव जेथैव मिताव ‘आव ननाखारल ब दोके,’ है जेदाँज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","है जैद ङा जेलाई साचो है ङादाचिज़्‍या, अगमबक्तालाई ओल ओनाखारलावराए खर्क ज़ ओमान नैद माएर। ");
INSERT INTO kjl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","जे आव ब चेतैच्‍यो, एलियाए ओपालाक ब स़ोंरिम छ मैना पै नम मावाद बनै घ्‍योःव अनिकाल उलिज़्‍याक ओल उलिज़्‍याव इस्राएल देसल राँदी मेंमार कुधु ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","हितावत ब परमेस्‍वरए एलियालाई नोराए ल्‍योक मापरींद झन सीदोन खन्‍दलाव सारपत नाखारलाव राँदी मेंमाए ल्‍योक वाज़ परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","फरी एलीसा अगमबक्ताए ओपालाक ब इस्राएल देसल कुऱीर बनै ज़ याल्‍यो। हितावत ब नोरालाई सुलाई ज़ मासगराँद झन सिरिया देसलाव नामानलाई वाज़ सगराँक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","नो धर्मसास्‍त्र झ़िमलाव मिँराए येसुए ओपाँर थैद बनै ज़ रसिद, ");
INSERT INTO kjl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","थर च्‍याँःसिद नोलाई नाखारनी पले·द यानाखारलाव दाँदातिन हाँदा ख्‍याव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","खाली येसु नोराए खार्नी सिउःसिद बाके। ");
INSERT INTO kjl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","छींनी येसु फरी गालीललाव कफर्नहुम सहरल झरिद ऩासिन्‍या छ्याम मिँरालाई परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","नलावर येसुए ओपाँ थैद अचम्‍ब ताकेर, काराव ल्‍यो ताकिन होए बनै हकस ओरापैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","नो बेलाक ज़ दुप्‍सिद यालिज़्‍याव धर्मसास्‍त्र झ़िमल बो·लैज़्‍याव पुरूसए क्‍योःद ओनैज़्‍याव तोबो मिँ उलिज़्‍याव। नो पुरूस बनै चोइस क़िद, ");
INSERT INTO kjl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“अ नासरतलाव येसु, गेस नखै काता उलिज़्‍याव? गेलाई खेम्‍ना नहुव रो? ङा नँलाई ङासरेस्‍निज़्‍या। नँ परमेस्‍वरए छैंव उमीं ज़,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","हाःत ज़ येसुए नोलाई हप्कैद, “झ्याउँ तालिनी, आवए ओक्‍याँतिन पुलुस्‍द बान्‍के,” है ओदोव प़ाइँना ज़ नो माचाव पुरूसए नो मिँलाई याखार्ल पछारिद कैज़ माजैद पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","निताव रँःद नलावर अचम्‍ब ताद या याल, “आवए ओपाँ किताव ओताव? नाः ओसक्ती ल्‍यो, नाः ओहक ल्‍यो। माचाव पुरूसरालाई ओराहप्‍कैक मनी ओपाँर यादोज़्याव ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","हाःकिन येसुए ओदोव य़ेन भरी नजीलाव पो पोङ प़ाइँदा ज़ थास्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","नकिन येसु नो धर्मसास्‍त्र झ़िमनी पुलुस्‍द सिमोनए उझ़िमक बाके। नल सिमोनए उमुइँज्‍यु ओजोरो हुद घ्याँसिद उलिज़्‍याव। नलावराए नो ओजोरो हुवए उजूँनी येसुलाई है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","है जैद येसु नो ओजोरो हुज़्‍यावए ल्‍योक बाद नो जोरोलाई उसिङारो प़ाइँना ज़ जोरोए ऱास्‍द नो मेंमा सोद नोरालाई ज़्‍यावर जैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","निमी ओफेरनाव बेलाक नजीलाव याजोरो हुज़्‍याव भरी येसुए ओल्‍योक यारारैकेर। येसुए नोरालाई उकुइए छाप्‍द प़ाइँलाई ज़ यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","कुधु मिँराए याक्‍याँतिन माचाव पुरूसर ब चिर चिर क़िद, ‘नँ परमेस्‍वरए ओज़ा ज़’ लिद पुलुस्‍द बाकेर। नोराए येसुलाई ‘ख्रीस ज़’ लिद यासरेसोए येसुए नोरालाई हप्कैद पाँव ज़ ओमाराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","हो पराःती नम उसँवत येसु तोबो साइँसुइँव पोक बाके। माहोल्‍याराए येसुलाई खिम्‍द दैद यास नैन्‍याए जूँनी छुतदा बान्‍या वैंव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","येसुए फरी नोरालाई, “ङा परमेस्‍वरए ओराज्‍यालाव पाँ छुत नाखार नाखार, सहर सहरल ब सथैव ज़ परिके। नोए उजूँनी ज़ परमेस्‍वरए उपरींनाव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","है जैद येसुए यहूदिया खन्‍द भरिलाव धर्मसास्‍त्र झ़िम झ़िमक परमेस्‍वरए ओपाँ यासथैनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","तछा गनेसरेत दह छ्योक च्‍याँःसिद येसुए परमेस्‍वरए ओपाँ ओरासथैज़्‍याक माहोल्‍यार येसुए ओपाँ थैन्‍याए जूँनी बनै याछुइसिहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","हो बेलाक दह छ्योक ऩेब्‍लो दोङ्गानी निरँःक्‍यो। नो दोङ्गा चलैज़्‍यावर ङाँः क्‍योःज़्‍यावर याल्‍यो। नोर दोङ्गानी हाइसिद याजालर याछेज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","येसु सिमोनए ओदोङ्गाल पसिद ऱील जाँ होकसै लाँव परींद ननी ज़ परमेस्‍वरए ओपाँ माहोल्‍यारालाई यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ओपाँ ओखेमोत सिमोनलाई, “नदोङ्गा उर्जीं ल्‍योदा लाँद ङाँःर यान्‍न्‍याए जूँनी नजाल ख्‍याके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","सिमोनए, “तुबुरी ज़ धामा दाद गेनाल क़्‍याके गुर्बा, तोबो ङाँः ज़ गेमादैए। हैदी ब नँ है नलिकिन नँ नपाँनी ज़ ङाख्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ओजाल ख्‍याक्‍यो। ओख्‍याव प़ाइँना ज़ ङाँःर बनै कुधु परिद जाल ज़ चीवा चीवा जैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","है जैद ओलापकाव छुत दोङ्गात लिज़्‍याव यानैंरालाई ‘सघैहुसिचिके’ लिद सान दाद यारायो प़ाइँना ज़ नोर हुकेर। नो ऩेब्‍लो दोङ्गाल ङाँःर ब्‍याल्‍द दोङ्गानी ब गदिवा गदिवा ताकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","है जैद सिमोन पत्रुसए नो रँःद येसुए उखँत फुलुप्‍सिद, “अ प्रभु, ङा इताव पापी नङ़ाक लिन्‍या स्‍यासो ङामाले। नँ ङानी बाव ताके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ङाँःर बनै ल्‍यो माल्‍यो यापरिउए सिमोन ओनैंरास अचम्‍ब ताद यालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","हो बेलाक सिमोनस य़ेन दोज़्‍यावनी जब्‍दियाए ओज़ानी याकूब स़ोनो यूहन्‍नानी निल्‍यो। नोनी ब अचम्‍ब ताकिनी। हाःत ज़ येसुए सिमोनलाई, “ताछे·नी, अबकिन नँलाई ङाँःर माःक, मिँर खिम्न्‍या ङाजैनिरिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","है जैद नोर यादोङ्गार पाखाक यारारैव प़ाइँना ज़ यादोङ्गार याजालर ऱास्‍द येसुस बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","तछा येसु नजीलाव तोबो नाखारल उलिज़्‍याक तोबो कुऱीए येसुलाई रँःद ओङ़ाक फुलुप्‍सिद, “अ प्रभु, ङाल्‍योदा नयुँ ओताकिन ङालाई सगराँन्‍या नले,” है लिद बिन्‍ती ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","येसुए नोलाई उकुइए छाप्‍द, “नल्‍योदा ङायुँ लिज़्‍या ज़, गराँनिके,” है ओदोव प़ाइँना ज़ नो कुऱीए ओबेथा चक चक ज़ म़ाके। ");
INSERT INTO kjl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","येसुए फरी नोलाई, “आव नक्‍याँताव ङादोव य़ेन सुलाई ज़ है तारादोयो। बुरू नगराँव साचो ज़ ओल्‍यो लिन्‍या थ·रैव परींन्‍याए जूँनी पुजारीए ल्‍योक सतैंसिनाद मोसाए ओकानुनलाव मिताव चरैःन्‍यार चरैःनाके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","हितावत ब येसुए ओबयेन झन ज़ तादा तादाङ थास्‍नाके। है जैद ओपाँ थैन्‍याए जूँनी स़ोनो याजोरो हुवर सगराँसिन्‍याए जूँनी मिँर ल्‍यो माल्‍यो याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ओल कैताक याल्‍योनी अलगज़ा हाइसिद साइँसुइँवक बाद ओपोंखारिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","तछा येसुए परमेस्‍वरए ओपाँ ओरासथैज़्‍याक फरिसीर स़ोनो कानुनलाव यागुर्बार नल च़ुसिद यालिज़्‍याव। नोर ख्‍वार गालील स़ोनो यहूदिया खन्‍दलाव नाखार नाखारनी हुवर यालिज़्‍याव, ख्‍वार यरूसलेमनी हुवर यालिज़्‍याव। हो बेलाक परमेस्‍वरए सगराँन्‍या ओसक्ती येसुए ओक्‍याँत उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","फरी नो बेलाक ज़ तोबो उखँ उकुइ सिउलाई झेलोङ्गाल झाःद येसुए ल्‍योक यारैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","खाली मिँर बनै माहोल्‍या यातावए येसुए ल्‍योक बान्‍या येम मादैद नोर थालात बाद झ़िम कप्‍सिउ फल्‍यार जाँवा हाइद सघ्वाँःद नो उखँ उकुइ सिउलाई ओझेलोङ्गारास येसुए ओङ़ाक झरैदिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","येसुए नोराए यायुँ उहुबो रँःद नो उखँ उकुइ सिउलाई, “अ कान्‍छा, नपाप क्‍याल्‍सिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","नो थैद नलाव हुव सास्त्रीर स़ोनो फरिसीराए या याल रूम्‍रूमैद, “आव मिँए कै जैद परमेस्‍वरए उमिन ओबले·ज़्याव? मिँए ओपाप क्‍याल्‍न्‍या ते परमेस्‍वरकिन सु ची उलिज़्‍यावदा?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","येसुए नोराए यायुँलाव पाँ सैंद, “जे काराव जेयुँल नै जेलिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","नो मिँलाई ‘नपाप क्‍याल्सिके’ है दान्‍या सैं ‘सोद बान्‍के’ है दान्‍या काताकाव सजालो उलिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","अब ङा मिँ मिन्‍सिद हुवए आव मानुवात पाप क्‍याल्‍न्‍या ङाकुइत उलिज़्‍याव सैं ओमालिज़्‍याव चिऊचिके,” है दाद नो उखँ उकुइ सिउलाई, “ङा नँलाई है ङादींज़्‍या, सोद नझेलोङ्गार घुर्द नझ़िमदा बान्‍के,” ");
INSERT INTO kjl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","है ओदोव प़ाइँना ज़ नो उखँ उकुइ सिउ याङ़ाकिन ज़ सोद ओझेलोङ्गार घुर्द परमेस्‍वरए उमिनर सघ्‍योःद्याद रेंए रेंए उझ़िमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","नो रँःव भरी बनै अचम्‍ब ताद छे·द, “आछिम काता गेरँःव इताव?” लिद परमेस्‍वरलाई बनै घ्‍योःव ज़ थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","येसु ननी पुलुस्‍द ओबाज़्‍याक तोबो सिर्मा स्‍यो·ज़्‍याव लेबी यादोज़्‍यावलाई सिर्मा स्‍यो·न्‍या अद्दाक च़ुसिद उलिज़्‍याव रँःक्‍यो। येसुए नोलाई, “ङास हुन्‍के,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","नो च्‍याँःसिद ओय़ेन भरी ऱास्‍द येसुए उछींत बाके। ");
INSERT INTO kjl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","नकिन लेबीए येसुलाई उझ़िमक लाँद बनै घ्योःव भत्‍यार जैक्‍यो। नो भत्‍यारल लेबीए ओनैंर स़ोनो सिर्मा स्‍यो·ज़्‍यावर ब कुधु ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","फरिसीर स़ोनो यासकाव सास्त्रीराए नोरालाई येसुस सिप याज़्‍युज़्‍याव रँःद येसुए उसिसरालाई, “जे कै जैद निताव सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापीरास सिप जेज़्‍युज़्‍याव?” है लिद गन गन यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","नो है यारादोज़्‍याव येसुए थैद, “याजोरो माहुज़्‍यावरालाई सगराँन्‍या मिँ माचाहिए, याजोरो हुज़्‍यावरालाई वाज़ चाहिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","हो मिताव ज़ ङा मनी ‘गे धर्मीर’ है लिज़्‍यावरालाई परमेस्‍वरए ल्‍योदा बान्‍या ङाराखुल्‍हुव माःक, ‘गे पापीर’ है लिज़्‍यावरालाई ङाराखुल्‍हुव ची,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ख्‍वा ख्‍वा मिँराए येसुलाई, “ऱील सछैंज़्‍याव यूहन्‍नाए उसिसर स़ोनो फरिसीराए यासिसर एकतार ज़ उपासिद पोंखारिज़्‍यार। नँ नसिसर ते माउपासिद ज़्‍याद ओद लिज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","येसुए, “जन्तीर ब्‍याहोल्‍यास यालेवा पै कै जैद याउपासिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","खाली जो छ्यामकिन ब्‍याहोल्‍यालाई छुतैर, हो छ्यामकिन वाज़ उपासिन्‍या लेर,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","फरी घर्ती तोबो झाःद याएक्‍यो, “ओरे छिबो क्‍वालाई तालिन्‍याए जूँनी सुए ज़ साःरो क्‍वा चीद मातालिउ, म़ानी साःरो क्‍वा ब बलेस्‍ज़्‍या, पुराँदोत साःरो तालिसिउ ब माखैए। ");
INSERT INTO kjl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“हो मिताव ज़ पुराँदो प़िर्गुलल साःरो दाखमद्य सुए ज़ माझाःर, म़ानी उस॰ए प़िर्गुललाई सुफुद दाखमद्य ब भोन्‍या ले, प़िर्गुल ब खेर बान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","है जैद साःरो दाखमद्य साःरो प़िर्गुलल वाज़ झाःर। ");
INSERT INTO kjl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","पुराँदो दाखमद्य ओद बानी परिउए ‘आव ची ङमो लिज़्‍या’ लिद साःरो दाखमद्य ओव माभैंःए।” ");
INSERT INTO kjl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ऩासिन्‍या छ्याम येसु उसिसरास एँः खार्लाव घ्याँ याबाज़्‍याक उसिसराए बाला फ्या·द ज़ुद याकैज़्‍याव ");
INSERT INTO kjl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","फरिसीराए रँःद येसुलाई, “ऩासिन्‍या छ्याम मादान्‍या य़ेन काराव जेदोज़्याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","येसुए, “धर्मसास्‍त्रलाव सर्सिउ दाऊद राजा ओनैंरास याकरेकाव यादोव य़ेन जेमाप़रिए रो? ");
INSERT INTO kjl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","दाऊद ध्‍यान झ़िमल पसिद परमेस्‍वरलाई चरैःसिउ भरेस हाइद ओल मनी ज़्‍युक्‍यो, ओनैंरालाई मनी याएक्‍यो। नो भरेस पुजारीराए वाज़ ज़्‍यान्‍या ओताज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","नकिन येसुए फरी, “ङा मिँ मिन्‍सिद हुव ऩासिन्‍या छ्यामकिन ब घेप्‍पा ज़ ङालिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","फरी हुकिनकाव ऩासिन्‍या छ्याम येसुए धर्मसास्‍त्र झ़िमल परमेस्‍वरए ओपाँ ओरासथैज़्‍याक नल तोबो वोर्फताव उकुइ थँव मिँ ब उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","हो बेलाक सास्‍त्रीर स़ोनो फरिसीराए येसुए ओपाहा झाःद्यान्‍याए जूँनी ऩासिन्‍या छ्याम सगराँन्‍या य़ेन मादोज़्‍याव ब्‍याँ लिद चिऊद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","येसुए नोराए यायुँलाव यापाँ सैंद झन नो उकुइ थँवलाई, “आक हुद च्‍याँःसिन्‍के,” है ओदोक ते, नो प़ाइँए याङ़ाक च्‍याँःसिके। ");
INSERT INTO kjl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","येसुए नो सास्त्रीरालाई, “दे, ङालाई है दाँचिके, ऩासिन्‍या छ्यामकाव य़ेन चाव जैन्‍या सैं माचाव जैन्‍या? मिँलाई बाँचैन्‍या सैं बले·न्‍या? कानुनए कै उलिज़्याव?” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","प़ाइँलाई तछ्योनी चिऊद नो उकुइ थँवलाई, “नकुइ तङ्गैके,” है दोक्‍यो। नोए उकुइ ओतङ्गैव प़ाइँना सोजोकाव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","नो सास्त्रीर स़ोनो फरिसीराए येसुए ओदोव य़ेनलाई रँःद यारिस बनै चोद ‘आवलाई कै जैन्‍या ओताव?’ लिद सल्‍ला दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","हाः बेलाक तछा येसु तोबो दाँदात पोंखारिना बाके। नत परमेस्‍वरलाई तुबुरी पोंखारिद ज़ झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","हो पराःती छकाल्‍न्‍या ओलस बाऱिज़्‍यावरालाई ओल्‍योदा खुल्‍द, हो भरिनी बाह्र जनालाई छाँतिद ओसाचीर याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","नोराए यामिनर आवर ज़ — ङ़ादाकिनकाव उमिन सिमोन (छींनी होए उमिन पत्रुस जैदिक्‍यो), होए ओभाइ अन्‍द्रियास, नकिन याकूब, यूहन्‍ना, फिलिप, बारथोलोमाइ, ");
INSERT INTO kjl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, अल्‍फयसए ओज़ा याकूब, देसभक्ता है यादोज़्‍याव सिमोन, ");
INSERT INTO kjl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूबए ओज़ा यहूदा स़ोनो छींनी येसुलाई धोका याज़्‍याव यहूदा इस्‍करियोत। ");
INSERT INTO kjl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","नकिन नोरास दाँदातिन झरिद येसु तोबो बाँक च्‍याँःसिके। नक ओलस ओलस बाऱिज़्‍याव माहोल्‍यार ब यालिज़्‍याव। यहूदिया खन्‍दलाव मिँर, यरूसलेम सहरलाव मिँर, समुन्‍द्र छ्योकाव तुरोस स़ोनो सीदोन खन्‍द जीदाङाव मिँर ब बनै माहोल्‍या यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","नोर ख्‍वा ओपाँ थैना हुवर, ख्‍वार याजोरोनी सगराँसिना हुवर, ख्‍वार याक्‍याँताव माचाव पुरूस पले·ना हुवर यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","येसुए ओक्‍याँताव अचम्‍बलाव ओसक्तीए प़ाइँलाई ओरासगराँज़्‍यावए ओललाई छाप्‍न्‍याए जूँनी नो माहोल्‍यार ओल्‍योक बनै याछुइसिहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","नकिन येसुए ओलस बाऱिज़्‍यावरालाई चिऊद अइ लिद पाँके, “धन्‍या, जे गरीबर, परमेस्‍वरए ओराज्‍या जेमीं ज़। ");
INSERT INTO kjl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्‍या, जे आज्‍याल करे लिज़्‍यावर, जेकरे सिन्‍या ले। धन्‍या, जे आज्‍याल घर्ज़्‍यावर, रेंन्‍या ज़ जेले। ");
INSERT INTO kjl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ङा मिँ मिन्‍सिद हुवए ङाजूँनी जेलाई सोद, याखार्नी पले·द, बीज्‍यात जैद, जेमिन बले·द यायाचिक धन्‍याकावर ज़ जेताज़्या। ");
INSERT INTO kjl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","हो छ्याम जेरेंतए ज़ो·चिके, काराव ल्‍यो ताकिन स्‍वर्गताव घ्योःव इनाम दैन्‍या जेले। नो जेखिरी पसिज़्‍यावराए यासाखा पुर्खाराए ब अगमबक्ता भरिरालाई ब हैज़ याराजैकेर।” ");
INSERT INTO kjl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“जे धनीरालाई थैए माँतकन, आव जेजिउत वाज़ जेयुँ होलाँ ताद जेलिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","जे आज्‍याल द॰ द॰ सव़ाँसिज़्‍यावरालाई थैए माँतकन, करे ज़ जेतारिज़्‍या। स़ास्‍द रेंद लिज़्‍यावरालाई थैए माँतकन, पाँकी पाँ घर्न्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","जे प़ाइँ मिँराए यासघ्‍योःचिज़्‍यावर थैए माँतकन, नो सघ्‍योःज़्‍यावराए यासाखा पुर्खाराए तँनी पैज़्‍यावरालाई ब हिताव ज़ यारासघ्‍योःज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“जे थैज़्‍यावरालाई है ङादाचिज़्‍या, जेसुतुररालाई यारासमारिच्‍यो, जेलाई सोज़्‍यावरालाई चाव य़ेन दाद याराएच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जेलाई थल्‍ज़्‍यावरालाई असिक याराएच्‍यो, जेलाई बले·व पैंज़्‍यावराए जूँनी पोंखारिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","तँनिकाव नगालात प़ोद याईंकिन फरी तँनिकाव नगाला ब थाँद याएयो। नफुतु यानैंनिकिन नकमेस ब सिउःद याएयो। ");
INSERT INTO kjl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","नँस ऩिज़्‍यावरालाई याएयो, नमीं हाइद लाँज़्‍यावरास फरी ताऩियो। ");
INSERT INTO kjl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","जे छुतए ल्‍योनी किताव जेपैंज़्‍या, जे ब छुतए ल्‍योदा हितावनी ज़ दोचिके। ");
INSERT INTO kjl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“जेलाई समारिज़्‍यावरालाई वाज़ जेरासमारिकिन नो ते काता ज़ माताके। नाःवाकाव य़ेन ते पापीराए ब दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","फरी जेलाई चाव य़ेन दाद्याज़्‍यावरालाई वाज़ चाव जेराजैकिन नो ब काता ज़ माताके। निताव ते पापीराए ब दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","सोवोल्‍धुन्‍यारालाई वाज़ जेरालोइकिन नो ब काता ज़ माताके। निताव ते पापीराए ब ‘ङालाई सोवोल्‍द्याँवा ज़’ लिद यारालोइज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“है जैद जे ते जेसुतुररालाई चाव य़ेन दाद यारासमारिच्‍यो। रिन जेराएक ‘खर्क सोवोलोके’ लिद आस मादाद याराएच्‍यो। हो ताकिन ची माहान परमेस्‍वरनी घेप्‍पा इनाम दैन्‍या ताद ओज़ार ब तान्‍या जेले। ओल ब उगुन माचेतैज़्‍याव पापीराए ल्‍योदा उयुँ य़ालो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","किताव स्‍वर्गताव जेबाबुए उयुँ जेल्‍योदा नाज़्‍या, हिताव ज़ जे ब छुतए ल्‍योदा जेयुँ ओनाक।” ");
INSERT INTO kjl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“जे अर्काए ओखत पले·द ताएच्‍यो, म़ानी परमेस्‍वरए जे जेखत ब पले·द्यान्‍या ले। अर्कालाई ‘इताव हिताव’ है दान्‍या ब माःक, म़ानी परमेस्‍वरए जेलाई मनी है दान्‍या ले। जेउपर्त मादान्‍या दोज़्‍यावलाई जेऱास्‍किन परमेस्‍वरए जेलाई मनी ऱास्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","है जैद जे छुतलाई जेएकिन जे मनी जेदैरिज़्‍या। किताव गोइँनी जेगोइँज़्या, जे मनी हिताव गोइँनी ज़ दैन्‍या जेले, झन हर्लैद छुइए छुइए ज्‍याल्‍द जेघोइँल ब भोन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","नकिन येसुए फरी अइ लिद घर्तीरानी यासथैक्‍यो — “उमी मारैंःवए उमी मारैंःवलाई दोरैद ओलाँकिन नोनी ऩेब्‍लो ज़ भल्‍खादाल तेन्‍या लिनी। ");
INSERT INTO kjl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“फरी, उगुर्बाकिन उसिस घेप्‍पा माताए। प़ाइँ उतीधुवत वाज़ उगुर्बा स्‍यासो ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“हिताव ज़ फरी, कै जैद ननैंए उमीलाव तकेज़ा सींका नरँःज़्‍याव, नँ नमीलाव नाःल्‍दिउ मुँदा ताकितर नमारँःज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","नमीलाव नाःल्‍दिउ मुँदा मारँःद कै जैद ननैंलाई, ‘नमीलाव सींका हाइद ङाईं’ है नदोधुरिज़्‍याव? ए निताव पाँज़्‍याव कैफती, ङ़ादा नमीलाव मुँदा हाइकेदा, ननैंए उमीलाव सींका नहाइक छर्लङ्ग रँःन्‍या नले।” ");
INSERT INTO kjl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“चाव सींए माचाव सै माझाःव, माचाव सींए चाव सै ब माझाःव। ");
INSERT INTO kjl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","है जैद जो मिताव सीं तादी ब ओसैनी ज़ सरेस्‍सिज़्‍या। ज़ुसैत कोराली मासैए, कारज़ुत जोम्‍परसै ब मासैए। ");
INSERT INTO kjl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","हो मिताव ज़ चाव मिँए उयुँनी चाव वाज़ हुज़्‍या, माचाव मिँए उयुँनी माचाव वाज़ हुज़्‍या। युँल किताव लिज़्‍या याःनी ब हिताव ज़ हुज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जे ङापाँ जेमादोकिन ङालाई ‘प्रभु, प्रभु’ है जेमादाँदी ब ताए। ");
INSERT INTO kjl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जोए ङाल्‍योदा हुद ङापाँ थैद दोज़्‍याव, नो मिँ किताव उलिज़्‍याव सतैंद ङायाचिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","नो तोबो झ़िम जैज़्‍याव मिँए गज बनै पतालल लुँ तर्त ओझाःव स्‍यासो लिज़्‍या। नो झ़िम बनै पक्‍कास जैसिउ ओतावए घ्‍योःव भल उहुदी ब कैज़ माजैधुव। ");
INSERT INTO kjl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","फरी जो मिँए ङापाँ थैद ओमादोकिन नो गज माखालिद झ़िम जैज़्‍याव मिँ स्‍यासो लिज़्‍या। नो झ़िमलाई भल उहुक तैःद प्‍याःपी जैद लाँद उमिन ज़ सम़ैदिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","येसुए नो ओपाँ भरी मिँरालाई ओरासथैवत फरी कफर्नहुमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","हाः बेलाक नल तोबो रोमी कप्‍तानए उयुँलाव मिताव ओनोकोर ओजोरो हुद सिउ ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","नो कप्‍तानए येसुए ओबयेन थैद ओनोकोरलाई सगराँन्‍याए जूँनी यहूदीराए यास़ेरर ऩेबरेंवा परींद येसुलाई क़िनाव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","नोर येसुए ओल्‍योक बाद बिन्‍ती दाद, “नो कप्‍तानए नँ नसाएता दैन्‍याकाव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","नोए गेजातलाव मिँराए ल्‍योदा उयुँ ताद गेजूँनी धर्मसास्‍त्र झ़िम ब जैद्यासिक्‍यो,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","है जैद येसु नोरास बाके। याबाज़्‍याक कप्‍तानए नोर झ़िमकिन सर्बा तादाङ याहुज़्‍याव रँःद तोबो ऩेब्‍लो ओनैंरालाई येसुए ल्‍योदा, “ ‘अ प्रभु, ङाजूँनी आः दुख तादैयो। ङा इतावए ङाझ़िमक नँलाई लाँन्‍या स्‍यासो ङामाले। ");
INSERT INTO kjl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ङा नङ़ाक सतैंसिन्‍या स्‍यासो ब ङामाले। बुरू ननी ज़ ‘गराँनिके’ है नलिकिन ङानोकोर गराँन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ङा ब छुतए ओहक धूँलाव मिँ ज़। ङा ङाधूँल मनी कुधु सिपाईंर लिज़्‍यार। नोरालाई ‘बाचिके’ है ङारादोक बाज़्‍यार, ‘हुचिके’ है ङारादोक हुज़्‍यार। ङानोकोरलाई ब ‘इताव दोके’ है ङादोक दोज़्‍याव’ है दोच्‍यो,” है लिद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","येसुए कप्‍तानए ओरापरींवराए यापाँ थैद कप्‍तानस अचम्‍ब ताद ओलस बाज़्‍याव माहोल्‍याराए ल्‍योदा भाल्‍सिद, “ङा जेलाई है ङादाचिज़्या, इस्राएलीराए याखार्ल मनी आव मिताव ङाल्‍योदा उयुँ हुबो सु ज़ ङामादैताए,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","नकिन नो कप्‍तानए ओरापरींवर ओल्‍द झ़िमक याबाक नो ओजोरो हुज़्‍याव गराँद उलिज़्‍याव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","येसु नकिन फरी जाँवाक नाइन यादोज़्‍याव नाखारदा बाके। नो बेलाक उसिसर स़ोनो माहोल्‍यार ब ओलस कुधु ज़ याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","नाखार ङ़ाक याकेसोत तोबो मोरो घुर्द यालाँज़्‍याव यारँःक्‍यो। नो सिउ छोर्‍या तोबो राँदी मेंमाए ओज़ा नाः तोबो ज़ ओल्‍यो। नो लाँज़्‍याव मलामीर सर्बा कुधु ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","प्रभुए नो राँदी मेंमालाई रँःद उयुँ नाद ओल्‍योक बाद, “ताघर्नी,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","मोरो झाःसिउ बाकसलाई ओछापोत नो मोरो बैज़्‍यावर ब च्‍याँःसिकेर। याच्‍याँःसिक येसुए नो मोरोलाई, “अ बुचा, सोनिके,” है ओदोव प़ाइँना ");
INSERT INTO kjl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","नो सिउ छोर्‍या सैंसिद च़ुसिद पाँके। है जैद येसुए नो छोर्‍यालाई ओआमाए ओजिम्‍बाल झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","निताव रँःद मलामीर बनै छे·द परमेस्‍वरलाई बनै घ्‍योःव थ·रैद, “माहान अगमबक्ता ज़ गेखार्ल हुद ले, ओल परमेस्‍वर ज़ उमींरास दैसिहुद ले,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","है जैद ‘येसुए इताव य़ेन दोक्‍यो दी’ लिन्‍या यहूदियाल स़ोनो नजीलाव खन्‍द भरिल प़ाइँदा ज़ थास्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ऱील सछैंज़्‍याव यूहन्‍नाए उसिसराए ब आव भरी यूहन्‍नालाई है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","है जैद यूहन्‍नाए ऩेब्‍लो उसिसनिलाई खुल्‍द प्रभुए ल्‍योक, “नो धर्मसास्‍त्रलाव सर्सिउ ‘हुरिज़्‍या’ है यालिज़्‍याव नँ ज़ रो, सैं छुतलाई कींन्‍या?” है दोनाव निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","है जैद नोनी येसुए ल्‍योक बाद, “गिनलाई ऱील सछैंज़्‍याव यूहन्‍नाए उपरींसिनो। होए नँलाई है दींज़्‍याव — नो धर्मसास्‍त्रलाव सर्सिउ ‘हुरिज़्‍या’ है यालिज़्‍याव नँ ज़ रो, सैं छुतलाई कींन्‍या?” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","नो बेलाक येसुए याजोरो हुवरालाई, माचाव पुरूसराए क्‍योःद यारानैज़्‍यावरालाई स़ोनो यामी मारैंःवर कुधुलाई ओरासगराँज़्याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","है जैद येसुए नोनिलाई, “आव ङादोव जिन्‍रँःव जिन्‍थैव भरी यूहन्‍नालाई है दोचिन। ‘यामी मारैंःवरालाई सरैंःद याएज़्‍याव, माबाधुन्‍यारालाई बाधुन्‍या याजैज़्‍याव, कुऱीरालाई यासगराँज़्‍याव, यार्ना माथासोरालाई थैधुन्‍या याजैज़्‍याव, सिउरालाई याजागैज़्‍याव, गरीबरालाई ब परमेस्‍वरए ओपाँ यासथैज़्‍याव,’ है दोनाचिन्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ङालाई रँःद यायुँ माक़्‍याज़्‍यावर असिक दैवर लिज़्‍यार,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","यूहन्‍नाए उनिपरींवनी निबाव छींनी येसुए माहोल्‍यारालाई यूहन्‍नाए उजूँनी अइ यादोक्‍यो, “जे यूहन्‍नाए ल्‍योक बनल जेबाक नोलाई किताव जेरँःया? बतासए आदा फुलुपनी होदा फुलुप ओजैज़्‍याव छी स्‍यासो ते जेमारँःखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","हिताव ओमालिकिन किताव जेरँःया? सैं बनै चाव चाव क्‍वा क्‍वाइसिउ मिँलाई जेरँःव? निताव क्‍वा क्‍वाइसिद थाँतस लिज़्‍यावर ते दरबारल वाज़ लिज़्‍यार सानी। ");
INSERT INTO kjl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","है जैद ओल्‍योक जेबाक नोलाई किताव जेरँःया? अगमबक्ता ज़ जेरँःखेहो सानी। ङा फरी है ङादाचिज़्‍या, अगमबक्ताकिन झन घेप्‍पालाई ज़ जेरँःके। ");
INSERT INTO kjl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","नो यूहन्‍ना धर्मसास्‍त्रलाव सर्सिउ मिँ ज़। नोए उजूँनी सर्सिउ आव ज़, ‘ङाकत्वाल्‍यालाई नङ़ा नङ़ा परींद ङाईंज़्‍या। नजूँनी नोए नङ़ादा ज़ नयेम तयार जैदींरिज़्‍याव।’ ");
INSERT INTO kjl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","है जैद ङा जेलाई है ङादाचिज़्‍या, मिँनी जर्मिउ भरिरानी यूहन्‍नाकिन घेप्‍पा सु ज़ माले। हैदी ब परमेस्‍वरए ओराज्‍यालाव गोइँनी ताकिन ते प़ाइँरानी ज़िम्‍ज़ा नोकिन घेप्‍पा लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","नो पाँ थैज़्‍याव मिँर स़ोनो सिर्मा स्‍यो·ज़्‍याव पापीर यातादी ब जाँकोसै यूहन्‍नानी यासछैंसिउए नोराए ङ़ादाकिन ज़ ‘परमेस्‍वरए ओय़ेन साचो ज़ लिज़्‍या’ लिद याथ·रैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","फरिसीर स़ोनो कानुनलाव यागुर्बार ते यूहन्‍नानी मासछैंसिद नोराए जूँनी परमेस्‍वरए ओदोज़्‍याव य़ेन माभैंःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","है जैद येसुए, “आव बेलाकाव मिँर कितावर यालिज़्‍याव, किताव अर्थनी है ङादाचिके, है लिक ते, ");
INSERT INTO kjl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","आव बेलाकाव मिँर बजार खार्ल रैःसिज़्‍याव ल़ुज़ा स्‍यासोर लिज़्‍यार। नोर यानैंरास गन्गनैद, ‘बाँसुली तप्‍द गेयाचिक ब जेमास़्‍याके, लँसिद गेयाचिक ब जेमाघर्के।’ ");
INSERT INTO kjl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","हो मिताव ज़ ऱील सछैंज़्‍याव यूहन्‍नाए ज़्‍यान्‍यार ओमाज़्युक, दाखमद्य ओमाओक नोलाई ‘दैनी परिद ले’ है जेदोज़्या। ");
INSERT INTO kjl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ङा मिँ मिन्‍सिद हुवए फरी ज़्‍यान्‍यार ङाज़्‍युक, ओन्‍यार ङाओक ‘चिऊचिके, काता ज़ मानैज़्‍याव ज़्‍यास्‍ती, दाखमद्य ओए ओए बाऱिज़्‍याव, सिर्मा स्‍यो·ज़्‍याव पापीराए यानैं’ है जेदाँज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","हैदी ब परमेस्‍वरए ओगहक थ॰रिउ लिज़्‍या लिन्‍या ओल उबुद्धी दैवराए ज़ थ·रैज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","तोबो फरिसीए येसुलाई उझ़िमक काँ ज़्‍यान्‍या खुल्‍क्‍यो। येसु नोए उझ़िमक बाद च़ुसिद काँ उज़्‍युज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","नो सहरलाव तोबो पातर्नी मेंमाए ‘येसु फरिसीए उझ़िमक काँ ज़्‍युना बाद ले दी’ लिन्‍या थैद नो मेंमाए बनै चाव ज़िम्‍ज़ा लुँ जाल उसी ङरो बनै ओएः ल्‍यो म़ास लाँद येसुए ल्‍योक बाके। ");
INSERT INTO kjl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","नक उछींक बाद घर्द उप़िलए उखँलाई सचिऊद्याद ओचेमए सीद नो ओरैव म़ास थीद्याद उखँलाई माइँ दोदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","नो येसुलाई काँ याज़्‍याव फरिसीए नो मेंमाए ओदोव य़ेन रँःद उयुँल उयुँल, “आव साचो अगमबक्ता ओताव ताकिन नो उखँ छाप्‍ज़्‍याव मेंमा माचाव पापीनी ओल्‍यो लिन्‍या सरेस्‍खेहो,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","हाःत ज़ येसुए नो फरिसीए उयुँलाव पाँ सैंद, “अ सिमोन, नँलाई तोबो पाँ है ङादींरिज़्‍या,” है ओदोक ते, “ताए गुर्बा, है दाँके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","नकिन येसुए, “तोबो साहुए उरूप्‍या रिन लाँवनी ऩेब्‍लो निल्‍यो। नोनी तोबोए चाँदीए सिक्‍का पाँच सय, तोबोए पचास लाँद निनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","नोनी नो रिन निमाफो·धुवए साहुए ऩेब्‍लोलाई ज़ निऱास्‍क्‍यो। नोनी साहुए उगुन काताकावए कोसै चेतैनिके? है दाँके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","नो सिमोनए, “नो कुधु ओऱासोए ज़ ताखेहो,” है ओदोक ते, येसुए, “थिक ज़ है नदाँके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","नो मेंमाए ल्‍योदा भाल्‍सिद सिमोनलाई है दोक्‍यो, “आव मेंमाए ओदोव नरँःखेहो। ङा नझ़िमक ङाहुक ङाखँ हुर्न्‍या ऱी ब नमायाँके, आवए ते उप़िलए ङाखँ हुर्द्याद ओचेमए सीद्याँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","नल्‍योक ङाहुक माइँ ब नमादाँके, आवए ते ङाहुवकिन ज़ ङाखँत माइँ दाव ज़ नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","नँ फरी ङाङ़ैत म़ास ब थीद नमायाँके, आवए ते झन ङाखँत चाव सी ङरो म़ास ब थीद्याँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","है जैद ङा नँलाई है ङादींज़्‍या, आव मेंमाए ओपाप कुधु ज़ उलिदी ब ओपो·स ज़ ओक्‍याल्‍सिउए ङागुन कुधु ज़ चेतैक्‍यो। फरी छ्या ऱास्‍सिउए छ्या गुन ज़ चेतैज़्‍याव,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","येसुए नो मेंमालाई, “नपाप प़ाइँ ज़ क्‍याल्‍सिके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ओलस काँ ज़्‍युज़्‍यावराए नो पाँ थैद, “आव मिँ कै जैद पाप क्‍याल्‍धुन्‍या ओजैसिज़्‍याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","येसुए फरी नो मेंमालाई, “ङालाई नयुँ उहुबोए नबाँचिके, नझ़िमदा चावस बानी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","नकिन जाँवाक येसु सहर सहर, नाखार नाखार भरी ब परमेस्‍वरए ओराज्‍यालाव चाव था ओरासथैज़्‍याव। बाह्र जना उसिसर ब ओलस ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","येसुए ङ़ादा माचाव बेथारानी, माचाव पुरूसरानी ओरासगराँव मेंमार ब तोबो ऩेब्‍लो ओलस ज़ यालिज़्‍याव। नोरानी तोबो मरियम मग्‍दलिनी, नोए ओक्‍याँतिन सात गोता माचाव पुरूसर पले·द ओयो। ");
INSERT INTO kjl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","फरी राजा हेरोदए उझ़िमलाव य़ेन चलैज़्‍याव खुजासए ओज्‍या योअन्‍ना, स़ोनो सुसन्‍ना, नोराकिन छुतर ब याल्‍यो। नो भरिए या याझ़िमनी ज़ येसुलाई उसिसरास माथैंव मायो·वल सयो·द याराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","नजीलाव नाखार नाखारलाव मिँर येसुए ओल्‍योक बनै माहोल्‍या याहुज़्‍याव। नोरालाई अइ लिद घर्ती तोबो झाःद याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“तोबो मिँ ओएँःल धुर वास्‍ना बाके दी। धुर ओवास्ज़्याक ख्‍वा धुर येम जीदा परिके दी। नो येमलाव परिउ ख्‍वा मिँराए छिल्‍केर दी, ख्‍वा बाज़ाराए ज़्‍युकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","फरी ख्‍वा धुर गम छ्या छ्या ल्‍यो ओदादरत परिके दी। नत उझी ओमाल्‍योए उपरीव प़ाइँना ज़ थँके दी। ");
INSERT INTO kjl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","फरी ख्‍वा धुर ज़ुर ऱमराए खार्ल परिके दी। नो ज़ुर ऱमरास सरा भरी परीद ज़ुर ऱमराए गाल्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","फरी ख्‍वा धुर ते गमस्‍याल परिके दी। नो बनै चावस परीद सय गुना सैके दी।” येसुए निताव पाँर सथैद माहोल्‍यारालाई है ओरादोज़्‍याव, “आव पाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","येसुए उसिसराए ओललाई, “आव नझाःव घर्तीए ओअर्थ काता?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","येसुए, “जेलाई वाज़ परमेस्‍वरए ओराज्‍यालाव कप्‍सिउ पाँर छर्लङ्ग सतैंसिउ लिज़्‍या, उपुर्कावरालाई ते घर्ती मिताव ज़ लिज़्‍या। है जैद, ‘नोराए रँःद ब मारँःधुर, थैद ब मातीधुर।’ ");
INSERT INTO kjl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“है जैद नो आछ्याकाव ङाझाःव घर्तीए ओअर्थ आव ज़ — धुर परमेस्‍वरए ओपाँ ज़। ");
INSERT INTO kjl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","नो येमलाव परिउ धुर आव ज़, जोए परमेस्‍वरए ओपाँ ओथैक सैतान हुद ‘आव ते परमेस्‍वरए ल्‍योदा बाद अजम्‍बरी जुनी दैवा’ लिद उयुँलाव पसिउ पाँ ब स्‍याप सिप जैद लाँदिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","फरी नो ओदादरताव परिउ आव ज़, जोए परमेस्‍वरए ओपाँ ओथैव प़ाइँना रेंद ज़ भैंःज़्‍या। खाली ओजरा माल्‍यो मिताव ओतावए नो पाँत जाँवा पै बाद कातारानी दुखर खिरीर उपसिकिन ह्‍वाँ हों ऱास्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","फरी नो ज़ुर ऱमराए खार्लाव परिउ आव ज़, जोए थैन्‍या ते थैज़्‍याव, खाली नोए ‘आव ङाजिउत कै तान्‍या ओताव, कातानी कोसै जैद थाँतस लिन्‍या?’ लिद व़ीनी फुइ उलिज़्‍यावए नो परमेस्‍वरए ओपाँत ओसै माझाःज़्याव ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","फरी नो गमस्‍याल परिउ आव ज़, जोए परमेस्‍वरए ओपाँ थैद जात्त ज़ माऱास्‍द चाव साचो युँस दोज़्‍याव, नो परमेस्‍वरए ओपाँत थ॰रिद ओसै झाःज़्याव चाव धुर स्‍यासो ज़ ताज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“सुए ज़ ल़ोसै तैंःद जाए माकबो, खात खँल ब माम़ोंव। बुरू ‘झ़िमल पसिज़्‍यावरालाई पलाँ घताक’ लिद दिउ बाल्‍न्‍यात झाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","हिताव ज़ मारैंःव भरी तछा रैंःन्‍या ज़ ले, कप्‍सिउ भरी ब फैसिद पलाँवल तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","है जैद जे नो पाँलाई पाथस थैच्‍यो। जोए धिद थैज़्‍याव, होए झन ज़ तीधुन्‍या ले। जोए चावस माथैव, होए झन ज़ थैन्‍या युँ मादाद ङ़ादाङाव ओथैव ब ओपो·स ज़ म़ान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","छींनी तछा येसुए ओआमा स़ोनो ओभाइर येसुस दैसिना याहुक मिँर बनै माहोल्‍या यातावए ओल्‍योक बान्‍या येम मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","नलाव तोबो ऩेब्‍लो मिँराए येसुलाई, “लाँःक नआमा स़ोनो नभाइर नँस दैसिना हुद लेर,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","येसुए, “जोराए परमेस्‍वरए ओपाँ थैद दोज़्‍यार, होर ज़ ङाआमार ङाभाइर,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","तछा येसु उसिसरास दोङ्गाल पसिद नोरालाई, “दह होफत गेबाया,” है दाद नो यालिज़्‍याव दोङ्गास बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","याबाज़्‍याक येसु उमीर हुद ङ़ल्‍द उलिज़्‍याव। नाःत ज़ दहल ल्‍यो माल्‍यो बतास हुद ऱी बनै छल्‍किद दोङ्गाल पसिद नोरालाई गदैवा गदैवा याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","उसिसराए येसुलाई सोचोइद, “गुर्बा, गुर्बा, खदम ज़ गेतारिके,” है यादोक ते, येसु सोद बतास स़ोनो ऱीनिलाई निसिङार्क्‍यो। हो प़ाइँना ज़ बतास ब थकनिके, ऱी ब अदिके। ");
INSERT INTO kjl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","हाःत ज़ उसिसरालाई, “खैकी जेयुँ उहुबो?” है ओरादोक ते, नोर छे·द अचम्‍ब ताद या याल, “आव किताव मिँ ओताव? बतासर ऱीराए ब ओपाँ यादोज़्‍याव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","येसु उसिसरास गालील दह होफताव गेरासेनस यादोज़्‍याव पोङ केस्‍केर। ");
INSERT INTO kjl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","दोङ्गानी यापुलुसोत नलाव सहरनी बो·लैज़्‍याव पुरूसए क्‍योःद ओनैज़्‍याव तोबो मिँस दैसिकिनी। नो मिँ क्‍वार ब ओमाक्‍वाइसिज़्‍याव, झ़िमक मालिद रील ब खादर जीदा ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","नोए येसुलाई उरँःव प़ाइँना बनै चिर चिर क़िद येसुए उखँत फुलुप्‍सिद बनै चोइस, “अ येसु, माहान परमेस्‍वरए ओज़ा, ङास नखै काता उलिज़्‍याव? नँस ङाबिन्‍ती लिज़्‍या, ङालाई दुख तायाँयो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","नो माचाव पुरूसलाई येसुए ङ़ादा ज़ “पुलुस्‍नी” है दाद ओनैज़्‍याव। नो माचाव पुरूसए नो मिँलाई घरी पाला ज़ ओक्‍योःज़्‍याव। कैताक मिँराए झँए साँगलए किद गुन्‍या मिँर यारानैदी ब साँगलर फ्या·द नो माचाव पुरूसए साइँसुइँवक ओलाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","येसुए फरी, “नमिन कै?” है ओदोक ते, “ङामिन फौजी,” है दोक्‍यो। नोए ओक्‍याँत माचाव पुरूसर कुधु याल्‍योए ज़ ‘फौजी’ है ओदोव। ");
INSERT INTO kjl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","फरी नोराए, “गेलाई नो नर्गलाव भल्‍खादाल ताझाःसियो,” लिद बिन्‍ती यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","नो बेलाक ज़ नक तोबो दाँदात ऊर तबगाल यालाज़्‍याव। नो माचाव पुरूसराए, “गेलाई बुरू नो ऊराए क्‍याँत बाव यासिके,” लिद बिन्‍ती यादोक ते, येसुए भैंःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","है जैद नो माचाव पुरूसर नो बूलिउ मिँए ओक्‍याँतिन पुलुस्‍द ऊराए क्‍याँत बाकेर। हो प़ाइँना ज़ ऊ भरी बूलिद दाँदातिन सुइँःकिनाद दहल ज़ो·द प़ाइँ ज़ स़ुद सिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","निताव रँःद नो ऊ गावलार धोंःनाद नाखार जीदा, सहर जीदा बाद नो यारँःव भरी है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","नो पाँ थैव भरी साचो सैं माःक लिद चिऊना हुवर येसुए ल्‍योक याबाक नो माचाव पुरूसराए याऱासो मिँ ओक्‍वार क्‍वाइसिद येसुए उखँक सोजोकाव ज़ च़ुसिद उलिज़्‍याव रँःकेर। निताव रँःद नोर छे·केर। ");
INSERT INTO kjl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","नो चिऊना हुवरालाई, नो य़ेन रँःव भरिए, “बूलिउ इतावनी ज़ गराँके,” लिद है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","नो गेरासेनस खन्‍द जीलाव मिँराए याछ्याचेए येसुलाई, “आनी पुलुस्‍द बान्‍के,” लिद बिन्‍ती दोकेर। है जैद येसु दोङ्गाल पसिद ओल्‍द बाव ओपैंज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","निताव रँःद नो माचाव पुरूसराए याऱासो मिँए, “ङालाई ब नँस लाँनाके,” है लिद बिन्‍ती ओदोक ते, येसुए अइ लिद परींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“नँ नझ़िमदा बाद ‘परमेस्‍वरए ङाजूँनी आःल्‍दिउ य़ेन दाद्याँक्‍यो’ है लिद सथैनाव ताके।” है जैद नो मिँ बाद सहर भरी ओल उजूँनी येसुए ओदोव य़ेन यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","आफताव मिँर बनै माहोल्‍या दुप्‍सिद ‘येसु खर्क हुके’ लिद कींद यानैज़्‍याव। येसु ओल्‍द उहुवत नोराए सुम्‍केर। ");
INSERT INTO kjl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","नोरास तोबो याइरस यादोज़्‍याव धर्मसास्‍त्र झ़िमलाव याघेप्‍पा उलिज़्‍याव। नो मिँ येसुए ल्‍योक हुद उखँत फुलुप्‍सिद, “ङाझ़िमक तखेप बाद्याव ताके,” लिद बिन्‍ती दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","नोए तोबोका तोबो बाह्र बर्सकाव मेंमा ओज़ा ओजोरो हुद सिउ ओपैंज़्‍याव। है जैद येसु नोस ओबाज़्‍याक मिँर बनै माहोल्‍या ओलस याछुइसिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","नो माहोल्‍याराए याखार्ल तोबो बाह्र बर्स भरी ओक्‍याँतिन झी भोन्‍या बेथाए क्‍योःद ओनैज़्‍याव मेंमा ब उलिज़्‍याव। नो मेंमालाई सुए ब यामासगराँधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","है जैद नो मेंमा माहोल्‍याराए खार्ल छुइसिनाद येसुए उछींनी हुद ओक्‍वाए उतुपात छाप्‍दिक्‍यो। ओछापो प़ाइँना नो झी भोन्‍या बेथा गराँके। ");
INSERT INTO kjl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","हाःत ज़ येसुए, “ङालाई सुए ओछाप्‍नाव?” है ओरादोक ते, प़ाइँए ज़ “ङा माःक” है दोकेर। पत्रुसए फरी, “प्रभु, माहोल्‍यार बनै छुइसिहुज़्‍यार सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","येसुए, “ङालाई तोबोए छाप्‍द ज़ नैनाव। ङाक्‍याँतिन सगराँन्‍या सक्ती पुलुस्‍द ओबाव दार्सिद ङाले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","हाःत ज़ नो मेंमाए ‘ङा ङामाम़ोंसिधुके ब’ लिद ओछ्याचेए गूद येसुए उखँत फुलुप्‍सिद प़ाइँराए ङ़ाक येसुलाई, “ङा सुए ज़ यामासगराँनाधुज़्‍याव बेथाए उजूँनी ज़ ङाछाप्‍निउ। ङाछाप्‍निउ प़ाइँना ज़ ङागराँके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","येसुए, “अ माँज़ा, ङालाई नयुँ नसुहुबोनी ज़ नगराँके। चावस बानी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","येसु नो मेंमास ओपाँज़्‍याक ज़ धर्मसास्‍त्र झ़िमलाव याघेप्‍पा याइरसए उझ़िमनी तोबो मिँ हुद याइरसलाई, “गुर्बालाई काराव हत्‍या यान्‍या, नज़ा सिधुके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","नोए ओपाँ थैद येसुए याइरसलाई, “नयुँ तासतेयो, नयुँ वाज़ उहुप्‍क। नो नज़ा बाँचिन्‍या ले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","याइरसए उझ़िमक याकेसोत छुतरालाई ओलस बाव मायाद पत्रुस, यूहन्‍ना, याकूब स़ोनो नो ल़ुज़ाए ओबाबु ओआमानी वाज़ लाँद झ़िमल पसिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","नल नो ल़ुज़ाए उजूँनी मिँर बनै याघर्ज़्‍याव रँःद येसुए, “ताघर्च्‍यो, ल़ुज़ा मासिए, अइज़ ङ़ल्‍द ले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","नो घर्ज़्‍यावराए ‘सिधुव ज़’ लिन्‍या यासैंवए येसुलाई हसैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","हाःत ज़ येसुए नो ल़ुज़ालाई उकुइनी क्‍योःद, “अ बुची सोनिके,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","उपुरूस ओल्‍द हुद सोके। नकिन येसुए, “आवलाई ज़्‍यान्‍यार जैदिचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","येसुए ओय़ेन रँःद नो ल़ुज़ाए ओबाबु ओआमानी अचम्ब ज़ ताकिनी। खाली येसुए, “आव य़ेन सुलाई ज़ है तारादोच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","येसुए तछा बाह्र जना उसिसरालाई खुल्‍द माचाव पुरूसर पले·न्‍या स़ोनो याजोरो हुवरालाई सगराँन्‍या सक्तीर याद, ");
INSERT INTO kjl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","परमेस्‍वरए ओराज्‍यालाव पाँ सथैना स़ोनो याजोरो हुवरालाई सगराँना अइ लिद यापरींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“येमत जेबाक जेस काता ज़ तालाँच्‍यो। झुइ तादी ब, झ़ैं तादी ब, अर्नी तादी ब, पैसा तादी ब, फेरैसिन्‍या क्‍वा तादी ब काता ज़ तालाँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जो नाखारल जेबाज़्‍या, जेमापुलुसा पै तोबो झ़िमक वाज़ लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","फरी जेबाव नाखारल जेलाई ल्‍यो यामायाचिकिन ननी जेपुलुस्‍क नोरालाई चेतावनी यान्‍याए जूँनी जेखँताव गालो धुइरो नल ज़ थरैद ख्‍यानैद याराएच्‍यो,” है लिद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","है जैद नोर येसुए ल्‍योनी पुलुस्‍द नाखार नाखारल चाव था सथैए सथैए, याजोरो हुवरालाई सगराँए सगराँए बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","गालील खन्‍दलाव राजा हेरोदए येसुए ओदोज़्‍याव य़ेनर थैद उथुपुल ताके। येसुए उजूँनी ख्‍वाराए, “ऱील सछैंज़्‍याव यूहन्‍ना जन्‍द हुद ले,” है यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ख्‍वाराए, “एलिया फरी हुद ले,” है यादोज़्‍याव। ख्‍वाराए फरी, “काताकाव भाःकाव अगमबक्ता सिउनी सैसिद उहुव सा,” है यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हेरोदए है लिके, “यूहन्‍नालाई ते ङा ज़ ओङ़ै च़म्‍द सैःव ङारापरींव ची। आव इताव य़ेन दाज़्‍याव सु ओताव?” लिद नोलाई तखेप सरेसो ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","येसुए नो ओरापरींव ओसाचीर ओल्‍द हुद, यादोव य़ेन भरी है दोकेर। नकिन येसुए नोरालाई सुए यामासैंद बेथसेदा यादोज़्‍याव नाखारदा यालाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","छींनी माहोल्‍याराए ओबाव सैंद ओल्‍योदा ज़ बाकेर। याहुज़्‍याव रँःद येसुए नोरालाई ओल्‍योक हुव याद परमेस्‍वरए ओराज्‍यालाव पाँ यासथैक्‍यो स़ोनो याजोरो हुवरालाई ब यासगराँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जाँ ऱिमदा ऱिमदा बाह्र जना उसिसर ओल्‍योक हुद, “आव माहोल्‍यारालाई यापरींके। गे इताव साइँसुइँवक गेलिज़्‍या। हो ताकिन आजीलाव नाखार जीदा बासिन्‍या बासर खिम्‍द ज़्‍यावर लँःद घज़्‍युनारक,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","येसुए, “आवरालाई ज़्‍यावर जे ज़ याव ताके,” है ओरादोक ते, उसिसराए, “गेस भरेस पाँच गोता, ङाँः ऩेब्‍लो वाज़ लिज़्‍या। सैं ज़्‍यावर लँःद रैद्यान्‍या है नलिज़्‍याव?” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","नो माहोल्‍यार खेपार वाज़ पाँच हजारा याल्‍यो। नकिन येसुए उसिसरालाई नो माहोल्‍यारालाई पचास पचासलाव ताना जैद सोचोइँव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","नोराए हैज़ जैद प़ाइँलाई यारासोचोइँकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","नकिन येसुए नो पाँच गोता भरेस स़ोनो ऩेब्‍लो ङाँः उकुइत रैद स्‍वर्गदा भाल्‍सिद, असिक ऩिद भरेसर ङाँःर केःद, उसिसरालाई माहोल्‍याराए याङ़ाक याङ़ाक झाःद्याव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","नोर प़ाइँए याफू तसी ज़्‍याद यासय़ेलोर यादुप्‍क बाह्र झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","छींनी तछा येसु उसिसरास बाद ओबातङ ज़ ओपोंखारिज़्‍याव। पोंखारिद ओखेमोत उसिसरालाई, “माहोल्‍याराए ङालाई सु है दाँज़्‍यार?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","उसिसराए, “ख्‍वाराए ऱील सछैंज़्‍याव यूहन्‍ना है दींज़्‍यार, ख्‍वाराए एलिया है दींज़्‍यार, ख्‍वाराए फरी काताकाव भाःकाव अगमबक्ता सिउनी सैंसिउ ताखेहो है दींज़्‍यार,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","येसुए फरी, “जे ङालाई सु है जेदाँज़्‍या नी?” है ओरादोक ते, पत्रुसए, “नँ परमेस्‍वरनी हुव ख्रीस ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","नकिन येसुए, “आव पत्रुसए है ओल्‍यो पाँ सुलाई ज़ है तारादोच्‍यो,” लिद नोरालाई अर्थैद, ");
INSERT INTO kjl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“ङा मिँ मिन्‍सिउए कुधु दुखर दैद आव गेदेसलाव स़ेरर, मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ल्‍योनी सोसी ऩिन्‍या ङातारिज़्‍या। नोराए यासैःनाव स़ोंलात सिउनी सैंसिद ङासोरिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","नकिन फरी माहोल्‍याराए ल्‍योदा भाल्‍सिद प़ाइँलाई ज़, “जोए ङास हुन्‍या युँ दोज़्याव, होए उजिउए मया मादाद दिनकाव ज़ क्रुसत सिन्‍या मिताव दुखर सहिद ङाछींत उहुक। ");
INSERT INTO kjl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","जोए आव उजिउत ओललाई तान्‍या वाज़ खिम्‍ज़्याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव उजिउत उजिउए मया मादाद ङा ङाजूँनी दोज़्याव, होए जुनी दैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","जोए आव मानुवात लिज़्‍याव भरी दैद उजुनीलाई ओसम़ैकिन नोलाई काता ची ता? ");
INSERT INTO kjl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जो आव बेलाक ङा स़ोनो ङापाँत ओलाज हुज़्‍या, ङा मिँ मिन्‍सिउ ब फरी छैंव ङाचाकर्‍यारास ङाबाबुए ओज़गै मगैरास ङाहुक ङा ब नोलाई रँःद ङालाज हुन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ङा साचो है ङादाचिज़्‍या, आकाव च्‍याँःसिद लिज़्‍यावरानी जे ख्‍वा ख्‍वाराए परमेस्‍वरए ओराज्‍या जेमारँःवा पै सिन्‍या जेमाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","नो है ओरादोव छ्यामकिन तसातावाक येसुए ओलस पत्रुस, यूहन्‍ना स़ोनो याकूबलाई लाँद तोबो गोंत पोंखारिनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","नक येसुए ओपोंखारिज़्‍यावत ज़ ओङाःर चबनै त़ोसिद ओक्‍वार ब तक तकौ ताद मी झीःन्‍या ताके। ");
INSERT INTO kjl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","हाःत ज़ फरी मोसा स़ोनो एलियानी हुद येसुस पाँकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","नोनी ब बनै ज़गै ज़गैवनी निरैंःज़्‍याव। स़ोनो येसुए यरूसलेमल उजिउ ओझाःरिज़्‍यावए जूँनी यापाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रुस ङ़ादा ओनैंनिस यामीर पातिद ङ़ल्‍द यालिज़्‍याव। यासैंसिउत येसु ओज़गै मगैस नो मिँनिस ओपाँज़्‍याव यारारँःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","नकिन मोसा स़ोनो एलियानी येसुस भाःसिद निबाज़्‍याव रँःद पत्रुसए येसुलाई, “अ गुर्बा, गे आक लिन्‍या बनै चाव लिज़्‍या। गे जेलाई स़ोम्‍लो पाल तङ्गैद गेयाच्‍यो, तोबो नँलाई, तोबो मोसालाई, तोबो एलियालाई,” है दोक्‍यो। पत्रुस ओछ्याचेए काता पाँन्‍या लिन्‍या ब ओमासैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ओपाँज़्याक ज़ बादल तोबो हुद नोरालाई याकप्‍क्‍यो। उसिसर बनै छे·केर। ");
INSERT INTO kjl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","नो बादल जींनी तोबो गा अइ लिद थास्‍के, “आव ङा ङाछाँतिउ ङाज़ा ज़, जे आवए ओपाँ थैच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","नाः ओपाँवत नक येसुलाई वाज़ रँःकेर। नो स़ोम्‍लोराए फरी नो यारँःव भरी हाः बेलाक सुलाई ज़ है मारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","हो पराःती नो गोंतिन याझरिउत मिँर बनै माहोल्‍या येसुस दैसिना हुकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","नो माहोल्‍यारानी तोबोए, “अ गुर्बा, नँस ङाबिन्‍ती लिज़्‍या। ङाज़ा तोबोका तोबो ज़ लिज़्‍या, नोलाई नयुँ नाद चिऊद्याँके। ");
INSERT INTO kjl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","नोलाई कैताक माचाव पुरूसए क्‍योःद, चिर चिर क़िउ परींद, उमँःजानी ख्‍याङग्‍याँ खेङ्गे जैद ओयाःनी फुइ गज्‍या पले·द बनै दुख ओमाएवा पै माऱासो। ");
INSERT INTO kjl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","नसिसरालाई ‘पले·दिचिके’ है ङारादोक ते मापले·धुकेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","नकिन येसुए नक लिज़्‍यावरालाई, “ए जेयुँ माहुबोर, परमेस्‍वरस माखैवर, ङा जेस खा ची ङालिरिज़्‍याव, खा ङासहिचिके!” है दाद छोर्‍याए ओबाबुलाई, “नज़ालाई आदा रैके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ओबाबुए ओरैज़्‍यावत ज़ नो पुरूसए छोर्‍यालाई नक ज़ पछारिद खागरा खगर॰ जैक्‍यो। है जैद येसुए नो माचाव पुरूसलाई हप्कैद पले·द्याद सोजोकाव जैद ओबाबुलाई एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","नकाव लिज़्‍यावर परमेस्‍वरए अचम्‍बलाव ओसक्तीर रँःद अचम्‍ब ज़ ताकेर। नोर अचम्‍ब ताद यालिज़्‍याक ज़ येसुए उसिसरालाई, ");
INSERT INTO kjl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“आव ङापाँ जेर्ना घ्याँ जैद थैच्‍यो। ङा मिँ मिन्‍सिद हुवलाई मिँराए याकुइत सूँपिनारिज़्‍यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","नोराए नो पाँ यामाबुझिदी ब येसुलाई सुधिन्‍या छे·केर। नो पाँए ओअर्थ कप्‍सिउ उलिज़्‍यावए माबुझिधुकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","नकिन येसुए उसिसर या याल, “गे सु घेप्‍पा गेलिज़्‍याव?” लिद याखर्लेसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","नोर याखर्लेसिज़्‍याव सैंद येसुए तोबो ज़िम्‍ज़ा ल़ुज़ालाई रैद ओलापक सच्‍याँद, ");
INSERT INTO kjl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","उसिसरालाई है यादोक्‍यो, “जोए ङा ङामिनत आव मिताव ज़िम्‍ज़ारालाई यासुम्‍ज़्‍याव, होए ङालाई मनी सुम्‍नाज़्‍याव। ङालाई सुम्‍ज़्‍यावए फरी ङालाई वाज़ माःक, ङालाई परींज़्‍यावलाई ब सुम्‍ज़्‍याव। है जैद जे जेखार्ल जो सज़िम्‍सिज़्‍या, हो ज़ घेप्‍पा लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","फरी यूहन्‍नाए, “गुर्बा, तोबोए नमिननी माचाव पुरूसर ओरापले·ज़्‍याव गेरँःके। नो गेस ओमाल्‍योए नोलाई पले·व गेमाएके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","येसुए, “नोलाई तावैंच्‍यो। जो जेकिन तँदा माजैसिए, हो जेस ज़ लिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","येसु स्‍वर्गदा बान्‍या बेला उहुनावए यरूसलेमदा बान्‍या पक्‍का युँ दाद, ");
INSERT INTO kjl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","उजूँनी पोर जैन्‍याए जूँनी तोबो ऩेब्‍लो उमींर ङ़ादा ज़ यापरींक्‍यो। नोर सामरिया खन्‍दलाव तोबो नाखारल बन्‍दोबस्‍त जैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","नो नाखारलावराए फरी, येसुए यरूसलेमदा बान्‍या उयुँ थू ओजैवए नल ल्यो माएकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","निताव रँःद उसिसनी याकूब स़ोनो यूहन्‍नानी येसुलाई, “अ प्रभु, सैं आवरालाई नमतिन मेंः सवाद्याद चुयाप जैन्‍या?” है निदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","येसुए, “निताव जैन्‍या माःक,” है दाद नोनिलाई सिङार्द, ");
INSERT INTO kjl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","छुत नाखारदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","याबाज़्‍याक येमक येसुस तोबो दैसिद, “नँ जोदा नबाज़्‍या, ङा ब होदा ज़ ङाबाया,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","येसुए, “स्‍यालर लिन्‍या कुँ लिज़्‍या, बाज़ार लिन्‍या सिप ब लिज़्‍या। ङा मिँ मिन्‍सिद हुवलाई ते ङ़ै कप्‍न्‍या पो ब माले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","फरी येसुए तोबोलाई, “ङास हुन्‍के,” है ओदोक ते, नोए, “अ प्रभु, ङ़ादा ङाबाबुलाई ङागादैदा,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","येसुए फरी, “सिउरालाई सिउ स्‍यासोराए घरागादैज़्‍यारक, नँ भन्‍या परमेस्‍वरए ओराज्‍यालाव पाँ सथैना बान्‍के,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","फरी छुत तोबो हुद, “प्रभु, ङा ते नँस ज़ ङाबारिज़्‍या, खाली ङ़ादा ङाझ़िमलावरास तखेप बिदा ङाऩिनारिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","येसुए नोलाई, “एँः कीक घोर क्‍योःद उछींदा भाल्‍सिज़्‍याव मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या स्‍यासो माताए,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","नकिन जाँवाक प्रभुए उसिसराकिन छुतर सत्तरी जनालाई खतैद ऩेबरें ऩेबरें जैद ओल ओबारिज़्‍याव पो पोङ ङ़ादा बान्‍या याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","नोरालाई दुप्‍द है यादोक्‍यो, “तामर चिकार यामींःनाव मिताव, परमेस्‍वरए ओराज्‍याल हुन्‍यार कुधु ज़ ताद लेर। खाली नोरालाई रैन्‍या बाहोर्‍यार ते छ्या ज़ ताकेर। है जैद नोरालाई रैन्‍या मिँर ओरापरींवक लिद परमेस्‍वरलाई पोंखारिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जे फरी जोगोइसिद बाच्‍यो, जेलाई प़र मितावराए खार्ल बेधा पाथा मितावर जैद ङापरींचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","जेबाक पैसा ब तालाँच्‍यो, झ़ैं ब तालाँच्‍यो, पोला ब तालाँच्‍यो। काङ्क ज़ ताँपै तोंपै मालिद ज़ बाच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“जो झ़िमक जेपसिज़्‍या, ङ़ादा ‘आव झ़िमलाई चाव ओताक’ है लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","नल घच सहिन्‍या मिँर यालिकिन, नो जेरायो असिक नोराए याक्‍याँत ज़ रहिरिज़्‍या। फरी नलावर घच मासहिन्‍यार यालिकिन, जेअसिक याक्‍याँत रहिन्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","फरी जो झ़िमक ल्‍यो याचिज़्‍यार, हो झ़िमकिन आदा होदा माबाद जो याचिज़्‍यार हो ज़ ज़्‍याद ओद लिच्‍यो। जो य़ेनत तादी ब य़ेन दाज़्‍यावए ओजेला दैव ज़। ");
INSERT INTO kjl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“फरी जो नाखारल जेबादी ब जेलाई ल्‍यो यायाचिकिन, जो मिताव ज़्‍याव याचिज़्‍यार हो ज़ ज़्‍युच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","नलाव याजोरो हुवर ब यारासगराँच्‍यो। नोरालाई ‘परमेस्‍वरए ओराज्‍या सो हुरिके’ है यारादोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","फरी जो नाखारल जेलाई ल्‍यो यामायाचिकिन, दोहाक बाद, ");
INSERT INTO kjl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘जेनाखारलाव गेखँताव गालो धुइरो ब आल ज़ थरैद ख्‍यानैद गेयाचिज़्‍या। खाली आव ब सैंच्‍यो, परमेस्‍वरए ओराज्‍या सो हुरिके,’ है यारादोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ङा जेलाई है ङादाचिज़्‍या, परमेस्‍वरए फाल्‍न्‍या छ्याम नो नाखारलाव मिँराकिन बुरू सदोमलावरालाई सहिधुन्‍या तारिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“हिताव ज़ जे खोराजीन स़ोनो बेथसेदालावरालाई थैए माँतकन ज़ लिज़्‍या। जे जेरँःव परमेस्‍वरए ओसक्तीलाव य़ेनर तुरोस स़ोनो सीदोनलावराए यारँःव ताकिन आः झरी यापापए जूँनी यायुँ माचाव दाद बर्ला सुर्सिद धुलील च़ुसिद यायुँ फर्कैद यापापर ऱास्‍धुखेरहो। ");
INSERT INTO kjl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","है जैद परमेस्‍वरए फाल्‍न्‍या छ्याम जेकिन बुरू तुरोस स़ोनो सीदोनलावरालाई सहिधुन्‍या तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","हिताव ज़ फरी जे कफर्नहुमलाव मिँर, स्‍वर्गत केसो मितावर जेङम्सिज़्‍या, झन नर्गल ज़ बान्‍या जेले।” ");
INSERT INTO kjl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","नकिन येसुए उसिसरालाई, “जोए जेपाँ थैज़्‍याव होए ङा ङापाँ ब थैज़्‍याव। हिताव ज़ जोए जेलाई मासुम्चिउ, होए ङालाई ब मासुम्नाव। फरी जोए ङालाई मासुम्नाव, होए ङालाई परींज़्‍यावलाई ब मासुमो,” है लिद यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","छींनी नो सत्तरी जना बाद ओल्‍द याहुवत येसुए ल्‍योक बनै रेंए रेंए बाद, “प्रभु, नँ नमिननी माचाव पुरूसर ब गेपाँ धूँल ज़ ताकेर,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","येसुए, “सैतानलाई बिजुली मिताव नमतिन ओतेहुज़्‍याव ङारँःके। ");
INSERT INTO kjl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ङा सैतानए ओसक्ती भरी जेधूँल ज़ जैद नैद ङायाचिए। है जैद ज़ निताव घुल स्‍यासोर बिछी स्‍यासोर जेराछिल्‍क कै मै ज़ जेमाताके। ");
INSERT INTO kjl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","हैदी ब ननी जे तारेंच्‍यो, बुरू स्‍वर्गत जेमिन सर्द नैसिउ उलिज़्‍यावनी रेंच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","नाःत ज़ येसु छैंव पुरूसनी बनै रेंद, “अ बाबु, नाम नमलावराए याङ़ैताव, नँलाई धन्‍याबाद ङाचरैःनिज़्‍या। नँ नपाँर सैंन्‍या जैसिज़्‍यावर, याबुद्धी ल्‍यो जैसिज़्‍यावरालाई सतैंद मायाद, भाउज़ा मितावरालाई सतैंद नराएके। हैज़ बाबु, नल्‍योदा बान्‍या येम नो ज़ चाव नथ·रैके,” है लिद पोंखारिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","नकिन येसुए, “ताव भरी ङाबाबुए ङाकुइत ज़ याद नैनाव। किताव परमेस्‍वरए वाज़ ओज़ालाई सरेस्‍ज़्‍याव, हिताव ज़ ओज़ाए वाज़ परमेस्‍वरलाई सरेस्‍ज़्‍याव। है जैद ङा छुतलाई सतैंद ङाएकिन वाज़ होए परमेस्‍वर ङाबाबुलाई सरेस्‍धुज़्‍याव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","नकिन येसुए उसिसरालाई अलगज़ा है यादोक्‍यो, “जे जेरँःव भरी रँःज़्‍यावर असिक दैवर ज़। ");
INSERT INTO kjl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ङा जेलाई है ङादाचिज़्या, अगमबक्तार, घेप्‍पा राजाराए ब आव जे जेरँःव पाँर रँःन्‍याए जूँनी यायुँ थू जैद ब रँःव मादैकेर, थैन्‍या युँ दाद ब थैव मादैकेर।” ");
INSERT INTO kjl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","येसुलाई जाँचिन्‍याए जूँनी, तछा कानुनलाव तोबो यागुर्बा हुद, “अ गुर्बा, ङा अजम्‍बरी जुनी दैन्‍या किताव दान्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","येसुए, “मोसाए ओकानुनल किताव सर्सिउ उलिज़्‍याव, नोए ओअर्थ किताव नथ·रैज़्‍याव?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","नो कानुनलाव यागुर्बाए फरी, “ ‘जेयुँलाई आदा होदा मादुलैद, जेर्सा माम़ोंद, जेप्रभु परमेस्वरए ल्‍योदा युँ थू जैद ओललाई वाज़ मया दान्‍या,’ स़ोनो, ‘जेक्‍याँलाई किताव जेसमारिज़्‍या, नैं मेंलाई ब हिताव ज़ समारिन्‍या,’ ” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","येसुए, “थिक ज़ है नदाँके। आव भरी नदोकिन ननी ज़ अजम्‍बरी जुनी दैन्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","नो कानुनलाव यागुर्बाए ओल थिक उलिज़्याव सतैंन्‍याए जूँनी, “ङानैं ङामेंर कितावर तार?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","है जैद येसुए अइ लिद घर्ती तोबो झाःदिक्‍यो, “तोबो मिँ यरूसलेमनी यरीहोदा ओबाज़्‍याक चोरराए फेला पारैद, प़ोद, ओक्‍वार हाइद लाँद, ओललाई येमक ज़ लल्‍यातोरो जैद ख्‍यानैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","कातानी तोबो पुजारी नो येम हुद नो याप़ोव मिँलाई रँःद झन तँनिकाव घ्याँ बाके दी। ");
INSERT INTO kjl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","फरी तोबो लेबी थरलाव मिँ हुद नोए पाला नोलाई रँःद तँनिकाव घ्याँ ज़ बाके दी। ");
INSERT INTO kjl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","बल्‍ल तोबो तादादा बाज़्‍याव सामरियालाव मिँ हुद, नो याप़ोवलाई रँःद, उयुँ नाद, ");
INSERT INTO kjl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ओल्‍योदा बाद, ओघाइर छेद्याद, वासःर झाःद, क्‍वाराए पो·द्याद, गधाहा तर्त झाःद तोबो भत्तीक लाँद पाथस नैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","हो पराःती नो भत्ती वालालाई, ‘आव मिँलाई पाथस नैयो,’ है दाद चाँदीए सिक्‍का ऩेब्‍लो याद, ‘आवकिन आगल्‍या ओलागिकिन फरी ङाहुक ङायाँ,’ है दाद ख्‍यानैक्‍यो दी।” ");
INSERT INTO kjl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","नकिन येसुए नो कानुनलाव यागुर्बालाई, “नो स़ोम्‍लोरानी नो चोरराए याप़ोवए ओनैं काताकाव ताया?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","नो कानुनलाव यागुर्बाए, “नो उयुँ नाज़्‍याव ज़,” है दोक्‍यो। येसुए फरी, “नँ ब बाद हिताव ज़ दोयो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","येसु उसिसरास यरूसलेमदा याबाज़्‍याक येमक तोबो नाखारल पसिकेर। नो नाखारल मार्था यादोज़्‍याव तोबो मेंमाए येसुलाई बनै मानस उझ़िमक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","मार्थाए ओबैंनी मरियम ब नल ज़ उलिज़्‍याव। नो येसुए उखँक च़ुसिद ओपाँ बनै धिद ओथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","मार्थाए ते ज़्‍यावर काता कातार ओजैज़्‍यावए नो पाँ थैव मादैक्‍यो। है जैद मार्था येसुए ल्‍योक बाद, “प्रभु, ङाबैंनीए आव य़ेनत ओमासघैनाज़्‍याव नरँःज़्‍याखेहो। नोलाई नँ तखेप है दाद्याव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभुए, “अ मार्था माँज़ा, नँ काताए जूँनी प़ाइँत व़ीनी फुइ नताज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","खास तोबोए ओचाहित वाज़ लिज़्‍या। नो ओचाहित ल्‍यो मरियमए रैद ओनैज़्‍याव पाँ ज़। है जैद नो रैद ओनैज़्‍याव नोनी सुए ज़ मालाँधुव।” ");
INSERT INTO kjl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","येसुए तछा पोंखारिद ओखेमोत, उसिसरानी तोबोए, “प्रभु ऱील सछैंज़्‍याव यूहन्‍नाए उसिसरालाई पोंखारिन्‍या ओरासिऊव मिताव गेलाई ब पोंखारिन्‍या सिऊसियो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","येसुए, “जेपोंखारिक इतावनी पोंखारिच्‍यो, ‘परमेस्‍वर बाबु, नमिन प़ाइँए ज़ छैंव ओथ·रैरक। स्‍वर्गताव नराज्‍या आव नामल उहुक। ");
INSERT INTO kjl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","गेलाई चाहिज़्‍याव ज़्‍याव दिनकाव ज़ जोरैद्यासियो। ");
INSERT INTO kjl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","नउपर्त गेदोव पापरानी ऱास्‍सियो। हो मिताव ज़ गे ब मिँराए गेउपर्त यादोव पापरानी गेराऱास्‍ज़्‍या। स़ोनो गेलाई माचाव चेतैन्यारानी जोगोइसियो,’ है लिच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","फरी येसुए उसिसरालाई है यादोक्‍यो, “जेनी तोबोए जेनैं लिज़्याखेहो। आधा रील नो जेनैंए ल्‍योक बाद, ‘अ ङानैं, भरेस स़ोम्‍लो लोइव ताके। ");
INSERT INTO kjl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","तोबो ङानैं बनै तादानी हुद ले, ङा नोलाई यान्‍या काता ज़ माले,’ है जेदोकिन, ");
INSERT INTO kjl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","नो झ़िमलावए, ‘ङालाई दुख तायाँ, य़ामर ङागल्‍धुके, ङाज़ारास स्‍याँद गेले। ङा सोद नँलाई ङामाईंधुइ,’ है उलिकिन, ");
INSERT INTO kjl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","नोए नैं नैं नितावए ओमाएदी ब फरी ओनैंए ‘मायाद माताए’ लिद जात्त ज़ ओमाऱासोए करनी वाज़ उऩिउ भरी एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“हिताव ज़ ङा जेलाई है ङादाचिज़्‍या, परमेस्‍वरस जेऩिकिन जेलाई यान्‍या ज़ ले, जेखिम्‍किन दैन्‍या ज़ जेले, य़ाम कोतो कोतो जेजैकिन जेजूँनी फैसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","जोए ऩिज़्‍याव होलाई यान्‍या ले, जोए खिम्‍ज़्‍याव होए दैन्‍या ले, जोए कोतो कोतो जैज़्‍याव होए उजूँनी फैसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","जेनी किताव बाबु लिके? ओज़ाए भरेस उऩिकिन लुँ यान्‍या? ङाँः उऩिकिन घुल यान्‍या, ");
INSERT INTO kjl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","बाज़ुरी उऩिकिन बिछी यान्‍या? ");
INSERT INTO kjl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","है जैद जे निताव पापल लिज़्‍याव मिँराए जेज़ारालाई निताव चाव चाव यान्‍या जेसैंकिन, स्‍वर्गताव जेबाबुए झन ओलस जेऩिकिन छैंव पुरूस कै जैद मायाचिउके?” ");
INSERT INTO kjl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फरी तछा येसुए तोबो मिँए ओक्‍याँनी माचाव पुरूस पले·दिक्‍यो। नो पुरूस मापाँधुन्‍या लाता जैज़्‍याव पुरूस ओल्‍यो। नो पुरूस उपुलुसो प़ाइँना नो मिँ पाँधुन्‍या ताके। निताव रँःद नक लिज़्‍याव माहोल्‍यार अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ख्‍वा ख्‍वाराए, “आवए ते माचाव पुरूसराए याघेप्‍पा बालजिबुलए उमिननी ओरापले·ज़्‍याव ची,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ख्‍वाराए फरी येसुलाई जाँचिन्‍याए जूँनी, “स्‍वर्गताव नसरेस तोबो सतैंके,” है यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","येसुए नोराए यायुँलाव पाँ सैंद, “तोबो राज्‍यालाव मिँर या या यामाखैकिन नो राज्‍याए उमिन ज़ म़ाज़्‍या। हो मिताव ज़ तोबो झ़िमलावर या या यामाखैकिन चितराँ पुतराँ तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","हिताव ज़ सैतानए ओराज्‍यालावर पाला या या यामाखैकिन नोराए यामिन कातानी ओरहिरिज़्‍याव? जे ते झन ङालाई ‘बालजिबुलए उमिननी माचाव पुरूसर यापले·ज़्‍याव’ है जेदाँज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ङा ननी ङारापले·ज़्‍याव ताकिन जेसकावराए कातानी यारापले·ज़्‍याव? है जैद नो जेपाँ जेसकावराए ज़ जेङ़ैत फुलुप्‍द्यान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","खाली ङा परमेस्‍वरए ओसक्तीनी ङारापले·ज़्‍याव ताकिन परमेस्‍वरए ओराज्‍या जेखार्ल ज़ हुद ले। ");
INSERT INTO kjl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“तोबो ओर्सा ल्‍यो मिँए ओहत्‍यारर रैद उझ़िमलाई उगुकिन नोए उझ़िमलाव भरी सुए ज़ मालाँधुर। ");
INSERT INTO kjl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","नोकिन ओर्सा ल्‍यो हुद खप्‍द ओहारैधुकिन वाज़ ओहत्‍यारर नैंद उझ़िमलाव जा-यार हाइद लाँद भाःन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“जो ङास माखैए, हो ङाकिन तँदाङाव ज़ लिज़्‍या। फरी जोए ङास मादोव, होए ज़ ङापाँ बले·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“मिँनी पले·सिउ माचाव पुरूस नो मिँए ओक्‍याँनी उपुलुसोत ऱी माल्‍यो साइँसुइँवक ऩासिन्‍या पो खिम्नाज़्‍याव। लिन्‍या पो ओमादैकिन फरी ओल्‍द ङ़ादाङाव उपुलुसोए ओक्‍याँत ज़ पसिउ पैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","नल ओबाक स्‍यासी जैद थिक थाक जैसिउ पो रँःद, ");
INSERT INTO kjl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ओलकिन माचाव पुरूसर सात गोता ओलस रैद नल पसिद नो मिँलाई ङ़ादाङावकिन झन ज़ माचावए क्‍योःज़्‍याव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","येसुए नाः ओपाँवत नो माहोल्‍यारानी तोबो मेंमाए येसुलाई, “नँलाई जर्मैद नुइँ सवैव मेंमा असिक दैव लिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","येसुए, “नोकिन बुरू परमेस्‍वरए ओपाँ थैद ओपाँ दोज़्‍यावर असिक दैवर लिज़्‍यार,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","माहोल्‍यार झन ज़ माहोल्‍या यातावत येसुए है यादोक्‍यो, “आव जुकलाव मिँर बनै पापीर लिज़्‍यार। ङासरेस वाज़ खिम्‍ज़्‍यार। खाली यादैरिज़्‍याव सरेस ते योनाए ओक्‍याँत ताव सरेस वाज़ दैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","किताव योनाए ओक्‍याँत ताव पाँर निनवे सहरलाव मिँरालाई सरेस ओताव, हिताव ज़ ङा मिँ मिन्‍सिद हुवए ङाक्‍याँत हुरिज़्‍याव पाँर ब आव जुकलाव मिँरालाई सरेस तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","नो दखिन देसलाव रानीए परमेस्‍वरए ओपाँ सोलोमनए ओयाःनी थैना बनै तादानी हुके। जे जेखार्ल हुद लिज़्‍याव ते सोलोमनकिन झन घेप्पा लिज़्या। है जैद परमेस्‍वरए ओराफाल्‍रिज़्‍याव छ्याम आव बेलाकाव मिँराए यागल्‍ती नो रानीए ओक्‍याँनी ज़ थ॰रिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","हो मिताव ज़ नो निनवे सहरलाव मिँराए योनाए ओरासथैव पाँर थैद परमेस्‍वरए ल्‍योदा यायुँ फर्कैकेर। जेखार्ल हुद लिज़्‍याव ते योनाकिन ब घेप्‍पा लिज़्‍या। है जैद परमेस्‍वरए ओराफाल्‍रिज़्‍याव छ्याम नोराए याक्‍याँनी ब आव बेलाकाव मिँराए यागल्‍ती थ॰रिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“सुए ज़ ल़ोसै तैंःद मारैंःवल ब मानैव, जाए ब माकबो। बुरू ‘झ़िमल पसिज़्यावरालाई पलाँ घताक’ लिद दिउ बाल्‍न्‍यात झाःज़्याव। ");
INSERT INTO kjl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","हिताव ज़ जेक्‍याँताव बत्ती जेमी लिज़्‍या। नो जेमी चाव उलिकिन जेक्‍याँ भरी पलाँव ज़ ताज़्‍या। फरी नो जेमी ज़्याज़्या ज़िझ़िव उलिकिन जेक्‍याँ भरी ओपो·स ज़ चुम चुमोल ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","है जैद नो जेक्‍याँताव पलाँव ताव परिन्‍या चुम चुमो ताताक। ");
INSERT INTO kjl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","पलाँवल लिज़्‍याव मिँ चुम चुमोल माताद दिउ बाल्‍न्‍या ङ़ाकाव ज़गैवल उलिज़्‍याव मिताव लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","येसुए नो पाँ भरी ओरासथैवत तोबो फरिसी हुद येसुलाई काँ यान्‍याए जूँनी खुल्‍क्‍यो। येसु नोए उझ़िमक बाद, ");
INSERT INTO kjl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","उकुइ माचोखोइद ज़ ज़्‍यान्‍यात थूसिके। नो फरिसीए निताव रँःद बनै हार मानिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","प्रभुए नोलाई, “जे फरिसीर, ताथीर खुरीर जेराचोखोइज़्‍याव नो पाखाताव वाज़ लिज़्या। जेयुँल ते लोभ स़ोनो माचाव वाज़ जेनैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ए जेर्ती माल्‍योर, परमेस्‍वरए पाखाताव जेक्‍याँ वाज़ जैद ओयाचिउ माःक, जेयुँ ब जैद्याचिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","जेयुँनी माथैंव मायो·वरालाई जेराचिऊकिन जेयुँ ब चोखो तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“जे फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे तके दँ जरार घोद दस भा जैद तभा भितील जेझाःज़्‍या। नो जेदोज़्‍याव ते चाव ज़, खाली नत वाज़ जेयुँ थू जैद झन ओचाहित ल्‍यो सतस दान्‍या स़ोनो परमेस्‍वरए ल्‍योदा युँ थू जैन्‍या भरी जेऱास्‍के। जे झन नो ओचाहित ल्‍योलाई ब ऱासो मापरिन्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“फरी ब जे फरिसीरालाई थैए माँतकन ज़ लिज़्‍या। जे सघ्‍योःसिद धर्मसास्‍त्र झ़िमराल प़ाइँराए रँःन्‍या पोक च़ुसिउ जेपैंज़्‍या। बजार जीदा ब ‘मिँराए धो घदासिरक’ लिद जेदुलिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“जेलाई थैए माँतकन ज़ लिज़्‍या, जे मारैंःव खादर स्‍यासोर जेलिज़्‍या। जेल्‍योदा हुज़्‍यावर मासैंद ज़ बलेस्‍ज़्यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","आव भरी थैद कानुनलाव तोबो यागुर्बाए येसुलाई, “गुर्बा, इताव नपाँए ते गेइज्‍यात ब खुलिद नयासिके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","येसुए, “जे कानुनलाव यागुर्बारालाई ब थैए माँतकन ज़ लिज़्‍या। जे सुए ज़ यामासयो·धुज़्‍याव कानुनर जैद छुतरालाई वाज़ दाव जेरापरींज़्‍या, जे ताकितर तोबो ओछ्यो ब जेमाछुए। ");
INSERT INTO kjl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“जेलाई थैए माँतकन ज़ लिज़्‍या, जेसाखा पुर्खाराए अगमबक्ता भरिरालाई यारासैःकेर। जे फरी नोराए याखादरर जेराबनैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","है जैद जेसाखा पुर्खाराए यादोव य़ेन जे ज़ जेथ·रैज़्‍या। यारासैःवराए यापो जेबनैक फरी नोरास झन खदेप ब जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","है जैद जे मितावराए जेजूँनी परमेस्‍वरए ङ़ादा ज़ थिक है लिद ले। नो पाँ आव ज़, ‘ङा नोराए ल्‍योदा अगमबक्तार स़ोनो ङापाँ सथैन्‍यार ङारापरींज़्‍या। नोरानी ख्‍वारालाई यारासैःरिज़्‍यार, ख्‍वारालाई याखिरी पसिद्यान्‍या लेर।’ ");
INSERT INTO kjl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“है जैद आव संसार सुरू ओतावकिनकाव अगमबक्तारालाई यारासैःव भरिराए याझी आज्‍यालकाव मिँराए याक्‍याँत ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ओदाज्‍युए ओसैःव हाबिलए ओपालाकिन, नो थान स़ोनो ध्‍यान झ़िमनी निखार्लाव यासैःव जकरिया पैकावराए याझी आव बेलाकाव मिँराए याक्‍याँत लागिस्‍रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“जे कानुनलाव यागुर्बारालाई थैए माँतकन ज़ लिज़्‍या। जे धर्मसास्‍त्रलाव सर्सिउ परमेस्‍वरए ओराज्‍याल पसिन्‍या साँचा जेम़ोंके। है जैद जे ननी ज़ परमेस्‍वरए ओराज्‍याल पसिउ जेमाभैंःए, पसिउ पैंज़्‍यावरालाई ब जे ज़ जेरावैंके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","येसु ननी पुलुस्‍द ओबाज़्‍याक नो फरिसीर स़ोनो कानुनलाव यागुर्बार येसुकिन तँदा जैसिद बनै कुधु पाँर सुधिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","नोराए यायुँल ‘ओल ओयाःनी पुलोसो पाँनी ज़ गेक्‍योःया’ लिन्‍या उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","हाः बेलाक बनै माहोल्‍या मिँर येसुए ओपाँ थैन्‍याए जूँनी छिल्‍सिवा छिल्‍सिवा जैसिद बनै याछुइसिज़्‍याव। नो बेलाक ज़ उस॰कत उसिसरालाई इतावनी यासथैक्‍यो, “जे फरिसीराए यादोज़्‍याव मिताव कप्‍तैं य़ेननी जोगोइसिद लिच्‍यो। निताव य़ेन सरालिसिज़्‍याव वासः मिताव ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कप्‍सिउल लिज़्‍याव भरी तछा प़ाइँए सैंन्‍या लेर, म़ोंसिउल लिज़्याव भरी ब छर्लङ्ग ज़ रैंःरिज़्यार। ");
INSERT INTO kjl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","है जैद जे आज्‍याल म़ोंसिद जेपाँदी ब तछा पाखात थास्‍रिज़्‍या। झ़िमलाव खुस खुसनी जेपाँव भरी ब थालातिन यारासथैरिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","येसुए फरी, “जे ङानैंरालाई है ङादाचिज़्‍या, जेक्‍याँलाई वाज़ सैःद छुत काता ज़ माजैधुज़्‍यावर रँःद ताछे·च्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","बुरू जेक्‍याँलाई सैःद नर्गल ख्‍यान्‍या ओहक ल्‍योलाई रँःद वाज़ छे·च्‍यो। साचो है ङादाचिज़्‍या, नोलाई रँःद जुनी ब छे·व ज़ परिके। ");
INSERT INTO kjl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","आव ब चेतैच्‍यो। पाँच गोता बिङर्‍या ऩेपैसाल ओमाबिकैज़्याव रो? नाः सोङ्गो ओतादी ब परमेस्‍वरए तोबो ब मारामेंःव। ");
INSERT INTO kjl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","होए जेङ़ैताव जेचेम आः लिज़्‍या लिन्‍या ब सैंज़्‍याव। है जैद काताल ज़ ताछे·च्‍यो। कुधु बिङर्‍याराकिन होए जेलाई घेप्‍पा रँःचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“है जैद ङा जेलाई है ङादाचिज़्‍या, जोए मिँराए ङ़ाक ओलाज माहुद ‘ङा येसुसकाव ज़’ है लिज़्‍या, ङा मिँ मिन्‍सिउए ब नोलाई परमेस्‍वरए ओचाकर्‍याराए याङ़ाक ‘ङासकाव ज़’ है लिन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","फरी जोए मिँराए ङ़ाक ‘ङा येसुसकाव माःक’ है दाँज़्‍याव, ङा ब परमेस्‍वरए ओचाकर्‍याराए याङ़ाक ‘आव ङासकाव माःक’ है दान्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","जोए ङा मिँ मिन्‍सिद हुवए ङाङ़ैत माचाहिउ पाँर झाःद ङामिन बले·ज़्‍याव, होए ओपाप क्‍यालो दैसिए। खाली जोए परमेस्‍वरए छैंव उपुरूसए उमिन बले·दिज़्‍याव, नो पाप क्‍यालो मादैसिए। ");
INSERT INTO kjl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","है जैद जेलाई धर्मसास्‍त्र झ़िमलाव स़ेरर, घेप्‍पा घेप्‍पार स़ोनो हाकिमराए याङ़ाक यालाँचिकिन, नो बेलाक ‘ङा नोरास काता पाँन्‍या, काता जवाप यान्‍या ओताव?’ लिद जेयुँ आँचा पाँचा ताजैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","नो बेलाक परमेस्‍वरए छैंव उपुरूसए जे काता पाँन्‍या ओल ज़ पैन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","हाःत ज़ नो माहोल्‍यारानी तोबोए येसुलाई, “गुर्बा, ङादाज्‍युलाई ‘नभाइस जिनबताहा भाःचिन्‍के’ है दाद्याँसाँ,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","येसुए, “ङा जेत्याला जैसिद जिनबताहा भाःद्यान्‍या ङा ङाय़ेन माःक,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","नकाव लिज़्‍यावरालाई प़ाइँलाई ज़, “प़ाइँनिकाव लोभनी जोगोइसिद लिच्‍यो। जती उलिदी ब मिँए उजिउलाई धनए साचो जुनी माएधुव,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","घर्ती तोबो झाःद याएक्‍यो — “तोबो धनी मिँए ओएँःलाव ज़्‍यावर बनै सैद, ");
INSERT INTO kjl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","उयुँल उयुँल, ‘आःकाव ङाज़्‍यावर कान्‍ल ङाससुइँःके?’ लिद, ");
INSERT INTO kjl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘बुरू ङादहरा बुम भरी उफारैद प़ाइँ नल ज़ झाःद, ");
INSERT INTO kjl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ङाक्‍याँलाई, कुधु बर्स पै चाव चाव ज़्‍याद ओद थाँतस लिन्‍के, है दान्‍या ङाले,’ है लिके दी। ");
INSERT INTO kjl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","नो उयुँलाव पाँ परमेस्‍वरए सैंद, ‘ए मुर्ख, काता नपाँज़्‍याव इताव? आछिम रील ज़ नस॰ हाइद ङाईंरिज़्‍या। नो नदुपो भरी सुए उज़्‍युरिज़्‍याव?’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“है जैद जोए ओधन सम्‍पती परमेस्‍वरए ल्‍योदा मादुप्‍द ओल उजूँनी वाज़ दुप्‍ज़्‍याव, नो आव घर्तीलाव मिँ स्‍यासो तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","नकिन येसुए उसिसरालाई है यादोक्‍यो, “है जैद ङा जेलाई ब है ङादाचिज़्‍या, जे जेक्‍याँए उजूँनी ‘काता ङाज़्‍युके, काता ङाक्‍वाइसिके?’ लिद व़ीनी फुइ तालिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","आव गेजिउ ज़्‍यान्‍या क्‍वाइसिन्‍याए जूँनी वाज़ माःक। ");
INSERT INTO kjl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कारालाई याराचिऊचिके। नोराए धुर ब माझाःर, क्‍या·न्‍या ब माक्‍या·र, ज़्‍याव ब मादुपर। हितावत ब चाहिज़्‍याव भरी परमेस्‍वरए जोरैद याएज़्‍याव। परमेस्‍वरए जेलाई झन बाज़ाराकिन घेप्‍पा रँःचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“जेनी सुए ची सोगो दाद जेजिउत तघन्‍ता जेचा·धुरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","निताव तकेज़ा य़ेन जेमादोधुकिन जे काराव व़ीनी फुइ जेलिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","वासर ब याराचिऊचिके। नोराए धामा दाद माखल्‍र। हितावत ब सोलोमन राजा बनै तह महौ ओजैसिदी ब वास तकल माताए। ");
INSERT INTO kjl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","परमेस्‍वरए आछिम वैद पराःती मेंःल बाज़्याव छीर नाः चाव याजैज़्‍याव ल्यो ताकिन जेलाई झन कै जैद माक्‍वाइचिउके? काता नाः जेयुँ माहुबोर जेलिज़्‍याव! ");
INSERT INTO kjl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","हिताव ज़ जे ‘काता ङाज़्‍युके, काता ङाओके’ लिन्‍यादा जेयुँ थू जैद व़ीनी फुइ तालिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","आव भरी ते परमेस्‍वरलाई मासरेस्‍ज़्याव मिँराए याध्‍यावना ची। जे जेजूँनी चाहिज़्‍याव भरी ते परमेस्‍वर जेबाबुए सैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","है जैद जे परमेस्‍वरए ओराज्‍या खिम्‍चिके। हो ताकिन ची जेलाई चाहिज़्‍याव भरी ओल ज़ जोरैद्याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“है जैद जे ज़िम्‍ज़ा ङाबगालर, ताछे·च्‍यो। जेलाई जेबाबु परमेस्‍वरए ओल ओराज्‍या खुसीस यान्‍या युँ दाद नैव। ");
INSERT INTO kjl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","जे जेसम्‍पतीर यो·द माल्‍योरालाई भाःद याराएचिके। स्‍वर्गताव खर्क ज़ माचिस्‍न्‍या जेस्‍याकलर ऱूप्‍द नैचिके। नलाव जेदुपो धन कै मै ज़ माताए। चोरराए ब मालाँधुर, घुनराए ब माज़्‍युधुर। ");
INSERT INTO kjl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","काराव ल्‍यो ताकिन जोङ जेधन लिज़्‍या, जेयुँ ब होङ ज़ तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“जे जेवाँःफोर पो·सिद बत्तीर तैंःद झाःसिद लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","भत्‍यारल बाव तोबो धनी मिँए ओय़ेन दाज़्‍याव मितावर जैसिउ ताके। नोर जो बेलाक तादी ब याघरपती हुद य़ाम कोतो कोतो ओजैहुव प़ाइँना फैदिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","सैंसिद लिद ओय़ेन यादोज़्‍याव याघरपतीए ओरादैहुकिन नोर असिक दैवर तान्‍या लेर। ङा साचो है ङादाचिज़्‍या, नो याघरपतीए ओल ज़ झन ओवाँःफोर पो·सिद ओय़ेन दाज़्‍यावरालाई सोचोइँद ज़्‍यावर भाःद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","है जैद नो धनी मिँ आधा री उघर्किनावत उहुदी ब, उसँनाक उहुदी ब सैंसिद यालिज़्याव ज़ ओरादैहुकिन नोर असिक दैवर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“फरी आव ब सैंच्‍यो, तोबो झ़िमए ओर्गेए ‘चोर आः बेलाक हुरिज़्‍या’ लिन्‍या ओसैंकिन झाःसिद लिद उझ़िम पा·व माएखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","हिताव ज़ जे मनी सैंसिद लिच्‍यो, काराव ल्‍यो ताकिन ङा मिँ मिन्‍सिउ मनी जेमासैंद उमँःजानी ज़ ङाहुरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","हाःत ज़ पत्रुसए येसुलाई, “प्रभु, आव नपाँ गेजूँनी वाज़ सैं प़ाइँए जूँनी की?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","येसुए, “किताव तोबो धनी मिँए सतस दाज़्‍याव ओतह ल्‍यो ओनोकोरलाई उझ़िमलाव य़ेन भरी उकुइत याद ओय़ेन दाज़्‍यावरालाई थिक बेलाक ज़्‍यावर यान्‍या जैद ओख्‍यानैक, ");
INSERT INTO kjl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","नो नोकोर सतस य़ेन ओदोज़्याव ओघरपतीए ओदैहुकिन नो नोकोर असिक दैव ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ङा साचो है ङादाचिज़्‍या, नो ओघरपतीए प़ाइँ ज़ उकुइत यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“फरी नो नोकोरए, ‘ङाघरपती हतप्‍त माहु’ लिद उधूँलाव लिज़्‍याव बाँदा बाँदानीरालाई प़ोद, ओल ज़्‍याद ओद मँःए मँःए ओबाऱिज़्याक, ");
INSERT INTO kjl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ओमासैंद ओघरपतीए ओदैहुकिन, नोलाई चम चम जैद यायुँ माहुप्ज़्‍यावर ओराख्‍याज़्‍याव पोल ख्‍यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“जोए ओघरपतीए ओय़ेन सैंद ब मादोव नो कुधु प़ोसिनिन्‍या तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","जोए मासैंद प़ोसिनिन्‍या मिताव य़ेन दोज़्‍याव हो छ्यावा वाज़ प़ोसिरिज़्‍या। जोलाई कोसै यासिउ लिज़्या होए कोसै ज़ सोवोलो परिज़्या। फरी जोए कोसै जिम्‍बा दैद नैव होए कोसै ज़ बुझैव परिके।” ");
INSERT INTO kjl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ङा ङापाँए आव मानुवात मेंः लैना ङाहुव मिताव लिज़्‍या। नो ङाय़ेन चाँदो ज़ ओखेम्‍किन ताखेहो है ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","खाली नोकिन ङ़ादा तोबो दुखल गदिउ परिन्‍या लिज़्‍या। नो ओमायो·वा पै ङायुँ धो थाइव ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","जे ङालाई ‘आव मानुवाताव मिँरालाई सखैना उहुव ताखेहो’ है जेलिज़्‍याखेहो। आव ङापाँए झन मिँरालाई याफातैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","अबकिन तोबो झ़िमलावर पाँच जना यालिकिन स़ोम्‍लो तँदा ऩेब्‍लो तँदा तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ज़ा बाबुनी ब माखैद ओज़ा तँदा ओबाबु तँदा तान्‍या लिनी। हिताव ज़ ज़ा-मा तादी ब, फुबु भदै तादी ब, या याल माखैव तान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","येसुए माहोल्‍यारालाई ब है यादोक्‍यो, “जे आव गेपोल बादल पछ्युँनी उहुज़्‍याव जेरँःक ‘नम वान्‍या ले’ लिद जेथ·रैज़्‍या। हिताव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","दखिननी बतास उहुज़्‍याव जेरँःक ‘आछिम बनै घाम तारिज़्‍या’ है जेलिज़्‍या। हिताव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ए कैफतीर, नाम नमलाव सरेसर ते जेथ·रैज़्‍या, कै जैद आखकाव बेला ताकितर जेमाथ·रैधुज़्याव? ");
INSERT INTO kjl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ओलेखा ल्‍योलाई झन कै जैद जेमाप़ाल्‍धुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","नँलाई तोबो नजगर्‍याए अदालतदा ओलाँनिक होङ माकेस्‍द येमक ज़ नोस खैन्‍या उदिम दाव ताके, म़ानी नोए न्‍याधिसए ल्‍योक सकेस्‍निरिज़्‍याव। न्‍याधिसए पुलिसलाई सूँपिद, पुलिसए फरी झ्यालखानाल झाःनिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","साचो ज़, नल नपरिकिन तपैसा तादी ब ओपो·स ज़ नमाफो·वा पै पुलुसो दैन्‍या नमाले।” ");
INSERT INTO kjl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","हो बेलाक तोबो ऩेब्‍लो हुद येसुलाई, “पिलातसए मार पल्‍हुज़्‍याव गालीललावरालाई सैःद होराए याझी मारए उझीस बरे·केर,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","येसुए नोरालाई, “नोर निताव दुखस यासिउए ‘यादेसलाव भरिरानी प़ाइँरानी पापीर ज़ याल्‍यो ओल्‍यो’ है जेलिज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ङा ते निताव ते माःक है ङादाचिज़्‍या। हैदी मनी जे परमेस्‍वरए ल्‍योदा जेयुँ जेमाफर्कैकिन फाल्‍न्‍या छ्याम जेलाई ब नो मिताव ओछ्यास लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","हिताव ज़ फरी नो यरूसलेमलाव सिलोआम धरर धलिद अथार जना नल यासिक, नोरालाई ब ‘यरूसलेम भरिनी अपराधीर ज़ ताखेरहो’ है जेलिखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ङा फरी हिताव ते माःक है ङादाचिज़्‍या। हैदी ब परमेस्‍वरए ल्‍योदा जेयुँ जेमाफर्कैकिन फाल्‍न्‍या छ्याम जेलाई ब नो मिताव ओछ्यास लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","नकिन येसुए नोरालाई तोबो घर्ती झाःद यासथैक्‍यो, “तोबोए ओएँःल कोराली तोबो रूपिद ओनैज़्‍याव। तछा ओसै उचिऊनाक ते मादैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","नकिन ओय़ेन दाज़्‍यावलाई, ‘आव कोरालीलाई धलैके। स़ोंरिम ताके सै ज़ मासैए, एँः वाज़ छ्याज़्‍याव,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ओय़ेन दाज़्‍यावए, ‘थारे सायेब, आइँसी पै नैव ताके। ओजरा जीदा घोद मलर झाःद ङाएरिज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","कसा मासैए। नाःत ब ओमासैकिन नधलैया,’ है दोक्‍यो दी।” ");
INSERT INTO kjl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","तछा येसुए ऩासिन्‍या छ्याम धर्मसास्‍त्र झ़िमक परमेस्‍वरए ओपाँ ओरासथैज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","नल तोबो थ॰ मालिधुज़्याव घोंत्‍यानिसो मेंमा उलिज़्‍याव। नोलाई माचाव पुरूसए नै ओजैव अथार बर्स ताद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","येसुए नोलाई रँःद ओल्‍योक खुल्‍द, “अ माँ आछिमकिन आव नदुखनी नऱास्‍सिके,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","नोए ओक्‍याँत उकुइ नैद ओयो प़ाइँना सोजोकाव ज़ ताद परमेस्‍वरलाई बनै घ्‍योःव ज़ थ·रैद उमिन सघ्‍योःदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","हाःत ज़ नो धर्मसास्‍त्र झ़िम चलैज़्‍यावए ऩासिन्‍या छ्याम येसुए नो मेंमालाई ओसगराँव रँःद बनै रसिद नक लिज़्‍यावरालाई, “य़ेन दान्‍या छ दिन जैसिउ लिज़्‍या। सगराँसिन्‍या ताकिन नाः भरिल ज़ सगराँसिहुच्‍यो। ऩासिन्‍या छ्याम माःक,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","प्रभुए नोलाई रँःद, “ए कैफतीर, जे ऩासिन्‍या छ्याम जेघें जेगधाहारालाई बँनी पला·द ऱी जेरासवैनाज़्‍याखेहो सानी। ");
INSERT INTO kjl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","झन आव अब्राहामए ओथोलाव सैतानए अथार बर्स पै किद ओनैज़्‍याव मेंमालाई कै जैद ऩासिन्‍या छ्याम मापला·न्‍या?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","निताव ओपाँए ओलकिन तँदा जैसिउ भरी लाज मोर्नो ज़ ताकेर। माहोल्‍याराए ते येसुए अचम्‍बलाव ओय़ेन रँःद यायुँ होलाँ ताद रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","है जैद येसुए नोरालाई, “परमेस्‍वरए ओराज्‍या किताव उलिज़्‍याव, कितावनी पलास्‍द ङायाचिके लिक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","परमेस्‍वरए ओराज्‍या तोबो बाजीए उधुर स्‍यासो लिज़्‍या। बारील झाःकिन परीद ओघ्‍योःवत नमताव भुर्ज़्याव बाज़ार सिपर जैद ओखारत बासिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","फरी येसुए, “परमेस्‍वरए ओराज्‍यालाई ङा कातास ङागोइँके ल्‍यो ताकिन, ");
INSERT INTO kjl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","परमेस्‍वरए ओराज्‍या भरेस सोगोइन्‍या वासः स्‍यासो ब लिज़्‍या। सोंःसेमे मुछिसिउ कनेल तोचोप झाःदी ब प़ाइँ सरालिज़्‍याव,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","येसुए नाखार नाखार, सहर सहर जीदा परमेस्‍वरए ओपाँ सथैए सथैए यरूसलेमदा ओबाज़्‍याक ");
INSERT INTO kjl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","येमक तोबोए, “प्रभु, अजम्‍बरी जुनी दैन्‍यार छ्या वाज़ यालिज़्‍याव सा?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","येसुए, “चूव य़ामनी पसिन्‍या जोर दोच्‍यो। कुधु पसिउ पैंज़्‍यावर पसिधुन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","झ़िमए ओर्गेए य़ाम ओगलो छींनी जेबाकिन लाँःक च्‍याँःसिद, य़ाम कोतो कोतो जैद, ‘प्रभु, गेलाई य़ाम फैद्यासिके’ है जेदोकिन, झ़िमए ओर्गेए, ‘जे काताङावर, ङा ङामासरेस्‍चिए,’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","जे फरी, ‘गे नँस ज़्‍युज़्‍यावर ज़, नसथैसिज़्‍याव नाखारलावर ज़,’ है जेदोकिन, ");
INSERT INTO kjl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ओल फरी, ‘जे काताङावर, जात्त ज़ ङामासरेस्‍चिए। जे पापीर आनी पुलुस्‍द बाचिके,’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","हाः बेलाक जे अब्राहाम, इसहाक, याकूब स़ोनो अगमबक्ता भरी परमेस्‍वरए ओराज्‍याल यालिज़्‍याव रँःन्‍या जेले। जे फरी, ‘गे ते लाँःक लिन्‍यार ची गेताव ओल्‍यो’ लिद जेहार ङर ङर कैद चिर्लनी बिर्ल घर्न्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","हो छ्याम मिँर आव संसारलाव चार कोन्‍यानी हुद परमेस्‍वरए ओराज्‍यालाव भत्‍यारल च़ुसिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","नो भरिनी ख्‍वा ख्‍वा ङ़ात लिज़्‍यावर छींत तारिज़्‍यार, छींत लिज़्‍यावर ङ़ात तारिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","नाः बेलाक ज़ फरिसीर तोबो ऩेब्‍लो हुद येसुलाई, “हेरोद राजाए नँलाई सैःव पैंज़्‍याव, नँ आनी पुलुस्‍द बाव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","येसुए, “नो स्‍याललाई है दोनाचिके, ‘तछा ऩेला पै माचाव पुरूसर पले·द यासगराँरिज़्‍याव दी। नकिन ओय़ेन भरी तुपिन्‍या ले दी।’ ");
INSERT INTO kjl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","जुनी तादी ब ऩेला स़ोंलात ङाबान्‍या पोङ माकेस्‍द माताए, म़ानी अगमबक्ता यरूसलेमल मासिद काङ्ङ उसिरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ए यरूसलेमलाव मिँर, कै जैद अगमबक्ता भरिरालाई जेरासैःज़्‍याव, जेल्‍योक परींसिउरालाई ब लुँ लुँए जेराझेःज़्‍याव? बामाए ओचर्ल्‍यानीर ओकर धूँल ओरादुप्‍ज़्‍याव मिताव, ङा ब जेलाई कुधु पाला ज़ ङाल्‍योदा पाथस दुपो ङापैंके, खाली जे ते जेमाभैंःके। ");
INSERT INTO kjl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","है जैद जेझ़िम रितो ज़ तारिज़्या। ङा जेलाई है ङादाचिज़्या, आकिन ते ‘परमेस्‍वरए उमिनताव हुज़्‍याव धन्‍याकाव ओताक’ है जेमादाँवा पै ङालाई फरी रँःन्‍या जेमाले।” ");
INSERT INTO kjl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ऩासिन्‍या छ्याम येसु तोबो फरिसीराए याघेप्‍पाए उझ़िमक काँ ज़्‍युना बाके। नक छुत फरिसीर पाला येसुए उचिवार्‍या यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","नल गोन्‍या बेथाए क्योःद ओनैज़्‍याव तोबो मिँ ब येसुए ओङ़ाक च़ुसिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","हाःत ज़ येसुए नलाव लिज़्‍याव फरिसीर स़ोनो कानुनलाव यागुर्बारालाई, “ऩासिन्‍या छ्याम याजोरो हुवरालाई मासगराँन्‍या कानुन उलिज़्‍याव रो?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","सु ज़ यामापाँधुवए येसुए नो ओजोरो हुवलाई छाप्‍द याङ़ाक ज़ सगराँद ननी परींद, ");
INSERT INTO kjl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","नलाव लिज़्‍यावरालाई, “जे ऩासिन्‍या छ्याम जेज़ा तादी ब जेघें तादी ब भल्‍खादाल ओतेकिन होल ज़ जेनैज़्‍याव सैं जेहाइज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","येसुस सु ज़ मापाँधुकेर। ");
INSERT INTO kjl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","नकिन येसुए नो भत्‍यारल खुल्‍सिउ पाहुनाराए ओमान ल्‍यो पो याखिम्‍ज़्‍याव रँःद अइ लिद घर्ती तोबो झाःद याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“बिह्‍यालाव भत्‍यारल जेलाई सुवाराए याखुल्‍चिकिन ओमान ल्‍यो पो ताखिम्‍च्‍यो। नँकिन घेप्‍पा मिँलाई ब खुल्‍द ओनैज़्‍याव ताकिन, ");
INSERT INTO kjl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","नो भत्‍यारल खुल्ज़्यावए, ‘नँ आवलाई पो ऱास्‍द्याव ताके,’ है दान्‍या ले। ननी मेकसै ओसारैनिकिन लाज मोर्नो तान्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","बुरू ङ़ादा ज़ प़ाइँरानी ओछ्योङाव पोङ च़ुसिउ ताके। हो ताकिन ची भत्‍यारल खुल्ज़्यावए, ‘अ ङानैं, जाँ रोकसै हुन्‍के,’ है उदींकिन प़ाइँराए ङ़ाक नइज्‍यात रहिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","है जैद जो ओलनी सघ्‍योःसिज़्‍या, हो ज़िम्‍रिज़्‍या। फरी जो ओलनी सज़िम्‍सिज़्‍या, हो घ्‍योःरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","नकिन येसुए ओललाई काँ ज़्‍युना खुल्‍ज़्‍यावलाई ब है दोक्‍यो, “नँ भत्‍यार जैद मिँरालाई नराखुल्‍क नक्‍याँदाङावर, नदाज्‍यु भाइर, ननैं मेंर स़ोनो घेप्‍पा मिँर वाज़ ताराखुल्‍यो। म़ानी नोराए फरी नँलाई ब भत्‍यारल खुल्‍द नलोइ फो·न्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","बुरू भत्‍यार नजैक काता ज़ माल्‍योर काना दूँदारालाई दुप्‍द याज़्‍यास्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","नोराए नलोइ यामाफो·धुवए नोए ओपोल असिक दैन्‍या नले। धर्मीर सैंसिद यासोव छ्याम परमेस्‍वरए ल्‍योनी नलोइ दैन्‍या नले।” ");
INSERT INTO kjl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","हाःत ज़ नो भत्‍यारल लिज़्‍यावरानी तोबोए, “साचो ज़ प्रभु, परमेस्‍वरए ओराज्‍यालाव भत्‍यारल ज़्‍याव दैज़्‍याव ओभागी ल्‍यो ज़,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","येसुए अइ लिद घर्ती तोबो झाःक्‍यो, “तोबो मिँए तछा बनै घ्‍योःव भत्‍यार जैद कुधुलाई याखुल्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ज़्‍याव भरी ओतावत तोबो ओनोकोरलाई नो है ओरादोव भरिलाई खुल्‍नाव परींक्‍यो दी। नो बाद, ‘ज़्‍याव भरी ताधुके, हुचिके दी,’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","नोराए तोबो तोबो निउँ जैद, उस॰कतावए, ‘ङा एँः तोथो लँःद ङानै, नो एँः ङाचिऊनारिज़्‍या। है जैद ‘माधाःए दी’ है दोयो।’ ");
INSERT INTO kjl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","हुकिनकावए, ‘ङा घेंर पाँच हल लँःद ङारानै, नोरालाई बिचारिना ङाबारिज़्‍या। है जैद ‘माधाःए दी’ है दोयो।’ ");
INSERT INTO kjl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","प़ाइँरानी छींनीकावए, ‘ङा भर्ज़ा ज्‍या रैद ङानै, है जैद ‘माधाःए दी’ है दोयो।’ ");
INSERT INTO kjl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“है जैद नो ओय़ेन दाज़्‍याव ओघरपतीए ल्‍योक बाद किताव है यादोव हिताव ज़ है दोक्‍यो। नो घरपती रसिद, ‘हो ची ताकिन्‍दा नँ चाँदो बाद सहरलाव दोहा जीलाव गरीब गुरूवा, काना दूँदारालाई खिम्‍द यारैके,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","नो ओय़ेन दाज़्‍यावए ओघरपतीए है ओदोव मिताव मिँर रैद, ‘है नदाँव मिताव मिँर रैद ङारानै। हैदी ब पो लिज़्‍या,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ओघरपतीए फरी, ‘येम जीलावर काना कुनी जीलावर काचाबुल घरारैयो, ङाझ़िमल घब्‍याल्‍रक,’ है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘ङ़ादाङाव खुल्‍सिउराए ङाभत्‍यारल तके ब दारो तादैरक,’ है दोक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","हाः बेलाक येसुस ल्‍यो माल्‍यो मिँर उछीं उछीं याबाज़्‍याव। येसु नोराए ल्‍योदा भाल्‍सिद अइ लिद यासथैक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“जो ङास हुव पैंज़्‍याव, होए ओबाबु ओआमा, ओज्‍या ओज़ा, ओदाज्‍यु भाइ, ओनाना बैंनीर स़ोनो उजिउलाई ङाकिन कोसै मया ओरादोकिन, हो ङासिस तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ङाजूँनी क्रुसत सिन्‍या मिताव दुखर सहिउ माभैंःद ङाछींत ओमाहुकिन हो ब ङासिस तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","हिताव ज़ जे झ़िम तोबो जेजैक ‘आः लागिरिज़्‍या’ लिद ङ़ादा ज़ हिसाप जेदोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","हिसाप मादाद गज वाज़ थालिद ओमातुपैधुकिन मिँराए नोलाई हसैद, ");
INSERT INTO kjl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘मातुपैधुन्‍यालाई ज़ काराव ओथालिउ?’ है लिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","हिताव ज़ तोबो राजाए ब छुत राजास लरैं ओताकिन ङ़ादा हुनी हुज़्‍याव बीस हजार मिँरालाई दस हजार मिँरास गेमाराखेपैधुके लिद, उधूँलाव घेप्‍पा घेप्‍पारास सल्‍ला दोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नोरालाई माहारैधुन्‍या मिताव ताकिन नोर तादाङ यालिज़्‍याक ज़ सखैन्‍या मिँर यापरींज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","है जैद जे ब जेस लिज़्‍याव भरी जेमाऱास्‍धुकिन ङासिस तान्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“सापी चाव ज़ लिज़्‍या, खाली ओदार ओमालिकिन नोलाई कै जैद ची ओदार ल्‍यो जैन्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","नोलाई एँःल झाःद ब माताए, मलल झाःद ब माताए, ख्‍यान्‍या वाज़ ताज़्‍या। आव ङापाँ जोए थैन्‍या उयुँ लिज़्‍या, चावस ओथैवक।” ");
INSERT INTO kjl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","येसुए ल्‍योक सिर्मा स्‍यो·ज़्‍यावर स़ोनो पापीर कुधु ज़ ओपाँ थैना याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","हिताव रँःद नकाव फरिसीर स़ोनो सास्‍त्रीराए, “आवए कै जैद निताव पापीरालाई सुम्‍द नोरास उज़्‍युज़्‍याव?” है लिद रूम्‍रूमैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","येसुए नोराए यापाँ थैद अइ लिद घर्ती तोबो झाःद याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“तोबोए ओबेधार तसय यालिकिन, ननी तोबो ओङोइकिन उनान्‍सयलाई बनल ज़ ख्‍यानैद नो ङोइवलाई ओमादैवा पै खिम्‍ज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","नोलाई ओदैक रेंए रेंए ओधेंल छींद, ");
INSERT INTO kjl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ओबासक रैद ओनैंरालाई खुल्‍द, ‘आव म़ाव ङाबेधालाई ङादैके। जे ब ङास रेंचिके,’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ङा साचो है ङादाचिज़्‍या, परमेस्‍वरस खैव उनान्‍सयराकिन तोबो पापी ओपाप ऱास्‍द परमेस्‍वरए ल्‍योदा उहुकिन नोलाई रँःद स्‍वर्गत बनै रेंन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“फरी हो मिताव ज़ तोबो मेंमाए चाँदीए सिक्‍का दस गोता उलिकिन, ननी तोबो ओसम़ैकिन नोलाई ओमादैवा पै मेंः तैंःद झ़िम सीद खिमो ज़ नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ओदैवत ओनैंरालाई खुल्‍द, ‘ङा नो ङासम़ैव सिक्‍का ङादैके। जे ब ङास रेंचिके,’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","हो मिताव ज़ तोबो पापी परमेस्‍वरए ल्‍योदा उहुकिन परमेस्‍वर मनी ओचाकर्‍यारास बनै रेंन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“हो मिताव ज़ फरी तोबो मिँए ओज़ानी दुई भाइ निल्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ओभाइए ओबाबुलाई, ‘बाबु, ङालाई ङाबताहा भरी याव ताके,’ है ओदोक ते, ओबाबुए ओज़ानिलाई सु सु निबताहा निएक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“हुकिन जाँवाक नोए उजुँ भरी यो·द पैसा भरी दुप्‍द तादा देसदा बाके दी। होङ बाद ओमन लागिउ य़ेन दाद ओपैसा भरी ओदोइक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","प़ाइँ ओखेमोत नो देसल बनै घ्‍योःव अनिकाल हुद नोलाई माथैंक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","है जैद नो देसलाव तोबोए ल्‍योक बाद, ‘नँस य़ेनर मादैसिके’ है ओदोक ते, नोए ऊ गावला जैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ऊ गावला उलिज़्‍याक ओकरेए माधुद ऊराए यापुल ब ज़्‍याव पैंक्‍यो दी। नोलाई सुए ज़ काता ज़ यामाएज़्‍याव दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“बल्‍ल बल्‍लङ ओचेतर फर्किद, ‘ङाबाबुए उझ़िमलाव ओनोकोरर ते याफू तसी ज़्‍याद ब सय़ेल्‍ज़्‍यार। ङा ताकितर करे करेए ङाघ्याज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","माताके ब, ङाबाबुए ल्‍योदा ओल्‍द बाद ची, ‘जेरो बाबु, ङा परमेस्‍वरए उउपर्त स़ोनो नँ नउपर्त पाप ङादोके। ");
INSERT INTO kjl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","अब ते ङा नज़ा है लिन्‍या स्‍यासो ब ङामाले। तोबो ननोकोरल गनिनाके,’ है ङाद्या ब,’ लिद, ");
INSERT INTO kjl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ननी पुलुस्‍द ओबाबुए ल्‍योदा बाके दी। “ओबाबुए झ़िमकिन जाँ तादाङ उहुज़्‍याव रँःद उयुँ नाद होङ ज़ धोंःनाद लाप्‍द माइँ दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ओज़ाए, ‘बाबु, ङा परमेस्‍वरए उउपर्त स़ोनो नँ नउपर्त पाप ङादोके। ङा फरी नज़ा है लिन्‍या स्‍यासो ङामाले,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","हाःत ज़ ओबाबुए ओनोकोररालाई, ‘आवलाई चाँदो ज़ प़ाइँरानी चाव क्‍वा रैद जास्‍चिके, उकुइत कुइची, उखँत पोला ब जास्‍चिके। ");
INSERT INTO kjl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","प़ाइँरानी सोइव मार तोबो रैद सैःचिके। बनै चावस ज़्‍याद ओद गेरेंया। ");
INSERT INTO kjl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","आव ङाज़ा सिउल गनिसिउनी, बाँचिद हुके, म़ाव ङोइवलाई ङादैके,’ है दाद भत्‍यार जैद बनै रेंकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“यामानिज़्‍याक ज़ जेथा ओज़ा एँःनी भर उहुज़्‍याव। झ़िमक ओकेस्‍हुक झ़िमल गित गैद यास़्याज़्‍याव थैद, ");
INSERT INTO kjl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तोबो नोकोरलाई खुल्‍द, ‘आव काता याजैज़्‍याव इताव?’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘नभाइ हुद ले। सिउल गनिसिउनी बाँचिद उहुए नोए उजूँनी नबाबुए प़ाइँरानी सोइव मार सैःक्यो,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","नो बनै रसिद झ़िमल पसिउ माभैंःके दी। है जैद ओबाबु ओल ज़ ओल्‍योक बाद फकैनाक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ओज़ाए माभैंःद, ‘ङा आः बर्स भरी नबाँदा मिताव जैसिद नपाँ खर्क ज़ माख्‍याद नसेवा ङादोके। हितावत ब ङालाई ङानैंरास ‘तोबो बाकरा बाली ब सैःद कैचिके’ है नमादाँए। ");
INSERT INTO kjl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","झन निताव नसम्‍पती भरी पातर्नीरास ओदोइद हुव नज़ालाई ताकितर सोइव मार सैःद नएके,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ओबाबुए, ‘अ ङाज़ा, नँ एकतार ङास ज़ नलिज़्‍या सानी। ङास लिज़्‍याव भरी नमींर ज़। ");
INSERT INTO kjl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","आछिम आव नभाइ सिउल गनिसिउनी बाँचिद हुव, म़ाव ङोइवनी दैसिउए उजूँनी कै जैद मामानिन्‍या, कै जैद मारेंन्‍या?’ है दोक्‍यो दी।” ");
INSERT INTO kjl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","नकिन येसुए फरी उसिसरालाई तोबो घर्ती झाःद है यादोक्‍यो, “तोबो धनी मिँए ओय़ेन चलैन्‍या मिँ तोबो ओनैज़्‍याव दी। नोए ओघरपतीए ओपैसा ओओदोइज़्‍याव छुतराए रँःद, धनीलाई है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","नो धनीए नोलाई खुल्‍द, ‘नय़ेन जाँ माचाव ङाथैज़्‍या, नँसकाव हिसाप भरी ङालाई याव ताके। आकिनी नँ आव य़ेन दाव दैन्‍या नमाले,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","नो य़ेन चलैज़्‍यावए, ‘ङाघरपतीए आव ङाय़ेननी पले·नारिक्‍यो, ङा कै लिन्‍या ओताव? कीन्‍या घोन्‍या ङार्सा माले, ऩिद ज़्‍यान्‍या ङालाज हुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","है जैद आनी ओपले·नावत मिँराए ङालाई याझ़िमक नैन्‍याए जूँनी तोबो बुद्धी पले·द अइ ची ङाजैया ब’ लिद, ");
INSERT INTO kjl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ओघरपतीए उरिन लाँव भरिलाई तोबो तोबोनी खुल्‍द प़ाइँरानी ङ़ातावलाई, ‘ङाघरपतीए ओकाछ नँस खा उलिज़्‍याव?’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘म़ास तसय गाधु लिज़्‍या,’ है दोक्‍यो दी। ‘हुकी नतुम्‍सुक रैकेदा, तसयकाव पचास वाज़ गिन्‍जैया,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","नकिन फरी छुतलाई खुल्‍द, ‘नँस ङाघरपतीए ओकाछ खा उलिज़्‍याव?’ है ओदोक ते, ‘गेदा तसय धु लिज़्‍या,’ है दोक्‍यो दी। ‘हुकी नतुम्‍सुक रैकेदा, तसयकाव असी वाज़ गिन्‍जैया,’ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“छींनी ओघरपतीए ओय़ेन भरी ओसैंवत, ओबाथैंनिकाव ओदोव सामा ते चाव ज़ रँःक्‍यो दी। है जैद परमेस्‍वरए ओपाँताव मिँराए अजम्‍बरी जुनीए जूँनी यादोज़्‍याव सामाकिन आव मानुवाताव मिँराए याजूँनी वाज़ यादोज़्‍याव सामा झन ज़ ओबाथैं ल्‍यो रैंःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“है जैद ङा जेलाई है ङादाचिज़्‍या, जे ते आव मानुवाताव जेधनए बुरू जेनैंर याराजैचिके। हो ताकिन ची सिन्‍या बेलाक पैसाए ओचाहित भरी ओखेमोत स्‍वर्गताव एकम्‍न्‍या लिन्‍या पोल जेलाई सुम्‍न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“जोए तकेज़ा य़ेनत सतस दोज़्‍याव, होए घेप्‍पा य़ेनत ब सतस दान्‍या ले। फरी जोए तकेज़ा य़ेनत असत दोज़्‍याव, होए घेप्‍पा य़ेनत ब असत दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","है जैद जे आव मानुवाताव धन असतस जेचलैकिन, परमेस्‍वरए ल्‍योङाव साचो धन कातानी जेदैरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","जेलाई यासिउ छुतए उमींलाई चावस जेमाचलैकिन, जे दैव परिन्‍या सुए ची ओयाचिरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","है जैद तोबो बाँदाए ऩेब्‍लो साहुनी निय़ेन मादोधुव। दाव उपरिकिन नोए तोबोलाई सोद तोबोलाई चाव रँःन्‍या ले, कितर तोबोए ओपाँ भैंःद तोबोलाई ओलेखा नैद्यान्‍या माले। हिताव ज़ जे मनी परमेस्‍वरए ओसेवा स़ोनो पैसाए ओसेवा तखेप्‍त जेमादोधुइ।” ");
INSERT INTO kjl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","नकाव ओपाँ थैज़्‍याव फरिसीर, यायुँ जम्‍मा पैसा कमैन्‍यादा वाज़ ओतावए येसुस याः दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","है जैद येसुए नोरालाई, “जे फरिसीर मिँराए ङ़ाक वाज़ धर्मी जैसिज़्‍यावर, जेयुँलाव पाँ भरी परमेस्‍वरए सैंज़्‍याव। है जैद मिँराए घेप्‍पा यारँःचिदी ब परमेस्‍वरए ल्‍योनी ते जेय़ेन युँ माजामो ज़ लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“यूहन्‍नाए ओपालाक पै मोसाए ओकानुन स़ोनो अगमबक्ताराए यापाँ उलिज़्याव। हाःकिन परमेस्‍वरए ओराज्‍यालाव पाँ हुद नल पसिन्‍या मिँर बनै छुइसिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","हैदी मनी नाम नम ओखेम्‍दी ब नो कानुनलाव पाँ तोबो ब खेर बान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","है जैद मोसाए ओकानुनलाव सर्सिउ मिताव, तोबोए ओज्‍यालाई ऱास्‍द छुतलाई ओरैकिन जारी य़ेन ओदोव ज़ गनिसिज़्‍या। फरी ओरेलाई ऱासो मेंमालाई ओरैकिन नो ब हितावल ज़ गनिसिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","फरी ब येसुए घर्ती तोबो झाःद है यादोक्‍यो, “तोबो धनी मिँ चाव चाव ज़्‍याद चाव चाव क्‍वाइसिद दिनकाव ज़ बनै थाँतस उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","तोबो ऩिद ज़्‍याज़्‍याव लाजरस यादोज़्‍यावलाई दिनकाव ज़ नोए ओसाँबिलाक यारैज़्‍याव। नोए ओक्‍याँ भरी खतेरा वाज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","नोए ओखतेरार काःराए लेप्‍हुद याएज़्‍याव। नोए ‘नो धनी मिँए ओसतेवर ज़्‍याव ङादैकिन ताखेहो’ लिद आस ओदोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“तछा नो ऩिद ज़्‍युज़्‍याव लाजरस सिके। उसिउ प़ाइँना ज़ परमेस्‍वरए ओचाकर्‍यार हुद छींद स्‍वर्गताव अब्राहामए ओल्‍योक लाँकेर। फरी नो धनी मिँ ब सिके। मिँर हुद लाँद गादैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","नो मिँ नर्गल बाद नलाव मेंःए ओसचप्‍क नमदा ओभाल्‍सिक नो लाजरस अब्राहामस उलिज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","अइ लिद बनै चोइस क़िके, ‘अ अब्राहाम बाबु, ङालाई नयुँ ओनाक। नँस लिज़्‍याव लाजरसलाई ओआङुला ऱील झाःद ङासेत सथेप्‍द्यान्याए जूँनी परींद्याँके। आव मेंःए सचप्‍द धो सहिउ ताद ङाले,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","अब्राहामए, ‘अ बाबुज़ा, नँ मानुवात नलेवा भरी बनै थाँतस नलिके, अब ते नल दुखस नलिज़्या। लाजरस ते बनै दुखस लिके, अब ते सन्‍चस लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","फरी नँस गेखार्ल बनै घ्‍योःव भल्‍खादा नैसिउ लिज़्‍या। है जैद गे नल्‍योदा हुव गेपैंदी ब गेमाहुधुइ, नँ ब गेल्‍योदा नमाहुधुइ,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","नो धनीए, ‘हो ची ताकिन्‍दा बाबु, नँस ङाबिन्‍ती लिज़्‍या। नोलाई ङाबाबुए उझ़िमदा परींद्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ङाभाइर पाँच जना लिज़्‍यार। नोरालाई घरासथैनावक, म़ानी आव ङापरिउल परिन्‍या ओछ्यास लिज़्‍या,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहामए, ‘नोर नल मापरिन्‍याए जूँनी यास मोसाए ओकानुन ब लिज़्‍या, अगमबक्ताराए यासरो पोस्‍तोको ब लिज़्‍या। नो ज़ ओथैरक,’ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","नो धनीए फरी, ‘हिताव ते माता, अब्राहाम बाबु। तोबो सिउनी बावए है ओरादोकिन वाज़ परमेस्‍वरए ल्‍योदा यायुँ फर्कैन्‍या लेर,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अब्राहामए, ‘मोसाए ओकानुन स़ोनो अगमबक्ताराए यापाँ यामाभैंःकिन सिउनी सैंसिद बावए ओपाँ कातानी याभैंःरिज़्‍याव?’ है दोक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","येसुए उसिसरालाई, “पापल पारैन्‍या पाँर ते जुनी ब हुन्‍या ज़ लेर, खाली निताव पाँर पले·ज़्यावलाई थैए माँतकन ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जोए आव मिताव ज़िम्‍ज़ारालाई पापल ओरापारैकिन, नितावलाई ते बुरू ओधेंल राँथै सुर्द्याद समुन्‍द्रल ख्‍यान्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","है जैद जे ननी जोगोइसिद ल्‍यो ताके। “ननैंए निताव पाप ओदोज़्‍याव नरँःकिन नोलाई सिङारो ताके। नसिङार्क ओपापनी ओओल्किन नोलाई ऱासो ताके। ");
INSERT INTO kjl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","फरी नँ नउपर्त तछात ज़ सात पाला मादान्‍या य़ेन दाव य़ेन नँस खैहुव य़ेन ओदोदी ब, नोलाई ब ऱासो ताके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","फरी येसुए ओसाचीराए ओललाई, “अ प्रभु, परमेस्‍वरए ओपाँत गेयुँलाई झन ज़ सुहुप्‍द्यासियो,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","येसुए, “परमेस्‍वरए ओल्‍योदा बाजीए ओसै हावालिउ तादी ब जेयुँ जेसुहुप्‍किनी तोबो बनै घ्‍योःव ऱूम्‍बू सींलाई ‘भोस्‍द समुन्‍द्रल रूपिसिनान्‍के,’ है जेदोकिन जेपाँ भैंःन्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“जेनी सुए ची जेबाँदालाई एँः कीन्‍यानी तादी ब बेधा छोन्‍यानी तादी ब, उहुव प़ाइँना ज़्‍यावर जैद ओसेवा जेदोज़्‍यादा? ");
INSERT INTO kjl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","बुरू उहुव प़ाइँना नोलाई, ‘नँ नक्‍वार फेरैसिद ज़्‍यावर जैद ङालाई रैद्याँकेदा, ङा ज़्‍याद ङाखेमोत नँ ब नज़्‍युया,’ है ची जेदोज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","है जैद नो जेबाँदाए है दासिउनी वाज़ ओदोवए नोलाई कातानी ची धन्‍याबाद जेएरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","हिताव ज़ जे ब परमेस्‍वरए है ओदाचिउ भरी जेदोदी ब ‘गे ते असिक दैन्‍या स्‍यासोर गेमाले। गे ते है ओदासिउ य़ेन दाज़्‍यावर वाज़ ची गेल्‍यो ओल्‍यो’ लिद य़ाका दोच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","येसु यरूसलेमदा ओबाज़्‍याक सामरिया स़ोनो गालीलनी निखार्लाव घ्याँ ओबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","तोबो नाखारल उपसिक कुऱीर दस जना येसुस दैसिहुकेर। नोर जाँ अछतङ च्‍याँःसिद, ");
INSERT INTO kjl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“अ येसु गुर्बा, गेलाई नयुँ ओनाक,” है लिद याक़िक ते, ");
INSERT INTO kjl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","येसुए नोरालाई रँःद, “जे पुजारीराए ल्‍योक सतैंसिना बाचिके,” है ओरादोक ते, नोर येमत याबाज़्‍याक ज़ प़ाइँ गराँकेर। ");
INSERT INTO kjl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","नोर यागराँव सैंद तोबो वाज़ येसुए ल्‍योक ओल्‍द हुद, बनै चोइस क़िद परमेस्‍वरए उमिन बनै सघ्‍योःद्याद, ");
INSERT INTO kjl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","येसुए उखँत फुलुप्‍सिद धन्‍याबाद चरैःक्‍यो। नो मिँ सामरिया जातलाव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","येसुए नोलाई, “जे गराँवर दस जना माःक रो? नँसकाव नौ जना काना याबाव?” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","नकाव लिज़्‍यावरालाई, “काता, परमेस्‍वरलाई धन्‍याबाद चरैःन्‍या आव तोबो छुत जातलाव मिँ वाज़ उलिज़्‍याव रो?” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","नो गराँवलाई, “च्‍याँःसिद चावस बान्‍के। ङालाई नयुँ उहुबोए नगराँके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","फरिसीराए येसुलाई, “परमेस्‍वरए ओराज्‍या खर्क उहुरिज़्‍याव?” है लिद यासुधिक येसुए, “परमेस्‍वरए ओराज्‍या रँःन्‍या सरेसरास माहुइ। ");
INSERT INTO kjl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","मिँराए फरी, ‘आङ लिज़्‍या, होङ लिज़्‍या,’ है ब लिन्‍या मालेर। है जैद जे ज़ सैंच्‍यो, परमेस्‍वरए ओराज्‍या जेयुँल ज़ ताज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","नकिन फरी उसिसरालाई, “तछा मिँ मिन्‍सिउलाई फरी तखेप रँःव गेदैकिन ताखेहो है लिन्‍या बेला ब हुन्‍या ले। हैदी ब रँःव दैन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","है जैद मिँराए ‘आङ लिज़्‍या, होङ लिज़्‍या’ है यालिज़्‍यावङ ताबाच्‍यो, नोराए यापाँ ब तापतिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","किताव नमत बिजुली उमिल्‍किक प़ाइँदा ज़ ज़गै ओजैज़्‍याव, हिताव ज़ ङा मिँ मिन्‍सिउ ब प़ाइँए रँःन्‍या जैद हुन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","खाली नोकिन ङ़ादा दुखर सहिद आव बेलाकाव मिँराए ल्‍योनी सोसी ऩिन्‍या ङातारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ङा मिँ मिन्‍सिउ ङाहुन्‍या बेला, नोआए ओपालाकाव मिताव ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोआए ओपालाकाव मिँर ज़्‍याव ज़ यालिज़्‍याव, ओव ज़ यालिज़्‍याव, ज्‍यार रेर ब दाव ज़ यानैज़्‍याव। हाःत ज़ नोआ ऱी जहाजल उपसिउ प़ाइँना ऱीर ज्‍याल्‍हुद प़ाइँलाई यागदैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“लोतए ओपालाकाव मिँर ब हितावर ज़ याल्‍यो। नोर मनी ज़्‍याद ओद यालिज़्‍याव, लँःन्‍यार लँःव ज़ यालिज़्‍याव, यो·न्‍यार ब यो·व ज़ यालिज़्‍याव, धुर ब झाःव ज़ यालिज़्‍याव, झ़िमर ब जैव ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","खाली लोत सदोमनी उपुलुसो प़ाइँना ज़ परमेस्‍वरए नमतिन मेंः सवाद याखेम्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“मिँ मिन्‍सिउ उहुन्‍या छ्याम ब हिताव ज़ तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","है जैद जे हो बेलाक थालात लिज़्‍यावए ओधन सम्‍पती जोगोइन्‍याए जूँनी उझ़िमल तापसिक। हिताव ज़ एँःल लिज़्‍याव ब उझ़िमदा ओल्‍द ताबाक। ");
INSERT INTO kjl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोतए ओज्‍यालाई य़ाका दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","है जैद जोए आव उजिउत ओललाई तान्‍या वाज़ खिम्‍ज़्याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव जुनील उजिउए मया मादोव, होए उजुनीलाई बाँचैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ङा जेलाई है ङादाचिज़्‍या, हो बेलाक, रील तोबो तैंत स्‍याँद लिज़्‍यावनिलाई तोबोलाई लाँरिज़्‍याव, तोबोलाई ख्‍यानैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","हिताव ज़ फरी राँथै हे·ज़्‍यावनिलाई तोबोलाई लाँरिज़्‍याव, तोबोलाई ख्‍यानैरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","फरी एँःल य़ेन दाज़्‍यावनिलाई ब तोबोलाई लाँरिज़्‍याव, तोबोलाई ख्‍यानैरिज़्‍याव,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","नकिन उसिसराए, “प्रभु, निताव खा बेलाक, काङ्क ओतारिज़्‍याव?” है यादोक ते, येसुए, “किताव खरल ओताक वाज़ का गिद्दर हुज़्‍यार, हिताव ज़ तान्‍या ले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","तछा येसुए पोंखारिन्‍यात यार्च्‍या मासैःन्‍याए जूँनी अइ लिद घर्ती तोबो झाःद याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“तोबो सहरल परमेस्‍वरलाई रँःद ब माछे·ज़्‍याव, मिँरालाई ब उयुँ मानाज़्‍याव तोबो न्‍याधिस उलिज़्‍याव दी। ");
INSERT INTO kjl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","नो सहरल ज़ फरी तोबो राँदी मेंमा ब उलिज़्‍याव दी। नोए न्‍याधिसए ल्‍योक बाद, ‘तोबोए ङाउपर्त अन्‍याय दाद नैव। नो सखैद्याव ताके,’ लिद दिनकाव ज़ है ओदोनाज़्‍याव दी। ");
INSERT INTO kjl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","नो न्‍याधिसए जाँवा भरी घाइ ज़ मादोक्‍यो दी। छींनी ते उयुँल उयुँल, ‘ङा परमेस्‍वरलाई रँःद ब ङामाछे·ए, मिँरालाई ब ङायुँ मानाए। ");
INSERT INTO kjl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","खाली आव मेंमाए बनै ङार्च्‍या सैःद ओयाँवए आवलाई सखैद्याव ज़ ताके, म़ानी घरी पाला हुद ङार्च्‍या सैःद्यान्‍या ले,’ है लिके दी।” ");
INSERT INTO kjl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","प्रभुए नाः है दाद फरी ब है यादोक्‍यो, “जे नो अन्‍याय न्‍याधिसए है उलिज़्‍याव चेतैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","है जैद परमेस्‍वरए ओराछाँतिउरालाई धिलो मिताव ओरैंःदी ब लाकनी रील यापोंखारिज़्‍यावए कै जैद माराजोगोइवके? ");
INSERT INTO kjl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","साचो है ङादाचिज़्‍या, जुनी ब नोरालाई मामेंःद चाँदो ज़ सखैद्यान्‍या ले। हैदी ब ङा मिँ मिन्‍सिउ फरी ङाहुक आव मानुवात ङालाई यायुँ हुप्‍ज़्‍यावर ङामारादैहुरिज़्‍या ब?” ");
INSERT INTO kjl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","येसुए यानी धर्मी जैसिद ‘गे मिताव सु ज़ मालेर’ लिद स॰ज़्‍यावराए जूँनी घर्ती तोबो झाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ऩेब्‍लो मिँनी ध्‍यान झ़िमल पोंखारिना बाकिनी दी। नोनी तोबो फरिसी ओल्‍यो दी, तोबो सिर्मा स्‍यो·ज़्‍याव ओल्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","नो फरिसीए जाँ तँदा बैसिद, ‘अ परमेस्‍वर, ङा नँलाई धन्‍याबाद ङाचरैःनिज़्‍या। ङा छुतराए मिताव लुभी ब ङामाले, अन्‍याय ब ङामादोए, पातर्‍या ब ङामाजैसिए। ङा नकाव सिर्मा स्‍यो·ज़्‍याव मिँ स्‍यासो ब ङामाले। ");
INSERT INTO kjl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","साताकाव ऩेखेप ब ङाउपासिज़्‍या। ङास लिज़्‍याव भरिनी दस भानी तभा ब ङाईंज़्‍या,’ है लिद पोंखारिक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“नो सिर्मा स्‍यो·ज़्‍यावए ते जाँ तादाङ च्‍याँःसिद ओलाजए परमेस्‍वरए ल्‍योदा माभाल्‍सिधुद ओछाती तपे तपे, ‘अ परमेस्‍वर, ङा मिताव पापीलाई नयुँ ओनाक,’ लिद पोंखारिक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“ङा जेलाई है ङादाचिज़्‍या, नोनी ननी निपुलुसोत फरिसीकिन बुरू सिर्मा स्‍यो·ज़्‍याव ज़ परमेस्‍वरए ओङ़ाक धर्मी थ॰रिके। जो ओलनी सघ्‍योःसिज़्‍या, हो ज़िम्‍रिज़्‍या। फरी जो ओलनी सज़िम्‍सिज़्‍या, हो घ्योःरिज़्या।” ");
INSERT INTO kjl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","नकिन मिँराए ज़िम्‍ज़ा याज़ार ‘येसुए छाप्‍द असिक घरायोक’ लिद ओल्‍योक यारारैज़्‍याक उसिसराए नोरालाई सिङार्द यारावैंकेर। ");
INSERT INTO kjl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","येसुए निताव रँःद ल़ुज़ारालाई ओल्‍योदा खुल्‍द, “नो ज़िम्‍ज़ा ल़ुज़ारालाई तारावैंच्‍यो, ङाल्‍योदा हुव याराएचिके। परमेस्‍वरए ओराज्‍या नितावराए जूँनी ज़ लिज़्या। ");
INSERT INTO kjl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ङा साचो है ङादाचिज़्‍या, जोर आव ल़ुज़ाराए माँःती परमेस्‍वरए ओराज्‍याल पसिन्‍या युँ मादोर, नोर खर्क ज़ पसिउ दैन्‍या मालेर,” है लिद उसिसरालाई है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","हाःत ज़ तोबो यहूदीराए याघेप्‍पा हुद, “अ धर्मी गुर्बा, ङा अजम्‍बरी जुनी दैन्‍या किताव दान्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","येसुए, “ङालाई काराव धर्मी है नदाँज़्‍याव? परमेस्‍वरकिन धर्मी सु ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","धर्मसास्‍त्रलाव सर्सिउ दान्‍या मादान्‍या य़ेन नँ ज़ नसैंज़्‍याखेहो — अर्काए ओज्‍याए ल्‍योदा माबान्‍या, मिँ मासैःन्‍या, माकुन्‍या, धुत गोहाई मायान्‍या, बाबु आमाए ओमान नैद्यान्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","नो याघेप्‍पाए, “आव भरी ते ज़िम्‍ज़ाकिन दाहुव ज़ ङानैज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","येसुए नो थैद, “अझ तोबो नमासयो·ताए। नँस लिज़्‍याव भरी यो·द काता ज़ माल्‍योरालाई भाःद याएकेदा, नँ स्‍वर्गताव धन दैन्‍या नले। नो य़ेन भरी दाद नँ ङाछींत हुन्‍के,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","नो पाँ थैद उयुँर स्‍यासे सतेक्‍यो, काराव ल्‍यो ताकिन नोए ओधन बनै कुधु ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","येसुए नो ओबाज़्याव रँःद नक लिज़्यावरालाई, “धनी मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या बनै धो ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","गपए उकुँल ऊँत उछिरिज़्‍यावकिन धनी मिँ परमेस्‍वरए ओराज्‍याल पसिन्‍या झन धो ताज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","नो पाँ थैज़्‍यावराए, “इताव ताकिन ते सुए ची अजम्‍बरी जुनी ओदैधुरिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","येसुए, “मिँर यानी सु ज़ माबाँचिधुर, खाली परमेस्‍वरनी मातान्‍या काता ज़ माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","हाःत ज़ पत्रुसए, “गे ते प़ाइँ ख्‍यानैद नछींत हुद गेले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","येसुए प़ाइँलाई, “ङा साचो है ङादाचिज़्‍या, परमेस्‍वरए ओराज्‍याए जूँनी जोए उझ़िम, ओज्‍या ओज़ार, ओदाज्‍यु भाइर, ओबाबु ओआमार याऱास्‍ज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","होए आव उजिउत ज़ कुधु गुना दैज़्‍याव, फरिकाव जुनील अजम्‍बरी जुनी ब दैन्‍या ले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","नकिन येसुए बाह्र जना उसिसरालाई अछतङ लाँद, “गे यरूसलेमदा गेपुलुस्‍नाज़्‍या। नल ङा मिँ मिन्‍सिउए ङाजूँनी अगमबक्ताराए यासरो भरी यो·न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","है जैद ङालाई छुत जातलावराए याकुइत सूँपिद उल्‍ली गिल्‍ली दाद, बीज्‍यात जैद, त़िल्‍द, ");
INSERT INTO kjl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","यारीःनावत सैःन्‍या लेर। हैदी ब स़ोंलात सिउनी सैंसिद सोन्‍या ङाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","खाली नो पाँए ओअर्थ भरी नोरालाई कप्‍सिउ मिताव ओतावए है ओरादोव भरी माबुझिधुकेर। ");
INSERT INTO kjl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","नकिन येसु यरीहो सहरल ओकेस्‍नाक नक उमी मारैंःव तोबो मिँ येम छ्योक च़ुसिद उऩिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","नोए माहोल्‍यार याहुज़्‍याव थैद मिँरालाई, “आव काता याजैज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","नोराए, “नासरतलाव येसु आलाव घ्याँ हुज़्‍या,” है यादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","नो बनै चोइस क़िद, “अ दाऊदए ओथोलाव येसु, ङालाई नयुँ ओनाक,” है ल्‍यो ज़ उलिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","नलावराए, “झ्याउँ तालिनी,” लिद सिङार्केर। खाली नो झन ज़ चोइस, “अ दाऊदए ओथोलाव, ङालाई नयुँ ओनाक,” है लिद क़िउ ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","येसु नक च्‍याँःसिद, “नोलाई आदा रैचिके,” है यादोक्‍यो। नोलाई यारैवत, ");
INSERT INTO kjl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","येसुए, “ङा नजूँनी काता दाद्यान्‍या?” है ओदोक ते, “प्रभु, ङा रँःधुन्या ङाताक,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","हाःत ज़ येसुए, “रँःन्‍या तान्‍के, ङालाई नयुँ उहुबोए ज़ नगराँके,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","नो मिँ रँःधुन्या ताके। नोए फरी परमेस्‍वरलाई घ्‍योःव ज़ थ·रैद येसुए उछीं उछीं ज़ बाके। नकाव लिज़्‍यावराए मनी निताव रँःद परमेस्‍वरए ल्‍योदा बनै खुसी ताद उमिन सघ्‍योःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","येसु यरीहो सहरल पसिद नलाव घ्याँ ओबाज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","नल तोबो जखायस यादोज़्‍याव सिर्मा स्‍यो·ज़्‍याव मुख्‍या उलिज़्‍याव। नो मिँ बनै धनी ब उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","नोए नो हुज़्‍याव येसुलाई चिऊन्‍या ओपैंज़्‍याव। खाली बनै तेंक्‍यासो ओतावए माहोल्‍याराए खार्नी मारँःधुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","है जैद येसु ओबान्‍या येमदा ङ़ादा ज़ धोंःनाद येसुलाई चिऊन्‍याए जूँनी तोबो सींत पुलुस्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","येसु नक ओकेसोत जखायस उलिज़्‍याव सींदा भाल्‍सिद, “अ जखायस, चाँदो झरिन्‍के। आछिम नझ़िमक ङाबासिरिज़्‍या,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","लाला लुलु झरिद बनै रेंए रेंए येसुलाई उझ़िमक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","नलाव मिँराए निताव रँःद रूम्‍रूमैद, “कै जैद निताव पापीए ल्‍योक बासिउ ओपैंज़्‍याव ओताव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जखायस ते येसुए ओङ़ाक च्‍याँःसिद, “अ प्रभु, ङास लिज़्‍याव भरी ऩेभा जैद तभा भरी माथैंव मायो·वरालाई ङाराएरिज़्‍या। हो वाज़ माःक, छुतरालाई हाइद ङाराज़्‍युव भरी चार दोबोर सोवोल्‍द ङाराएरिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","येसुए, “आव मिँ आछिमकिन उझ़िमलावरास परमेस्‍वरए ल्‍योदा बान्‍या येम ब दैक्‍यो, अब्राहामए साचो ओज़ाल ब गनिसिके। ");
INSERT INTO kjl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ङा मिँ मिन्‍सिउ इताव म़ाव ङोइवरालाई खिम्‍द बाँचैना ङाहुव ज़।” ");
INSERT INTO kjl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","नलाव मिँराए नो पाँ याथैज़्‍याक येसु यरूसलेमल ओकेस्‍नावए नोराए ‘परमेस्‍वरए ओराज्‍या आव मानुवात बेहार ज़ ओरैरिज़्‍याव सा’ है यालिज़्‍याव। नोराए यापाँ सदाँद्यान्‍याए जूँनी येसुए घर्ती तोबो झाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“तोबो राजाए ओथोलाव मिँ ओल उलिज़्‍याव पोङाव राज्‍या चलैन्‍याए जूँनी तादाङ राजाए ल्‍योक ओहक च़ानाक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ओमाबाद ङ़ादा दस जना ओय़ेन दाज़्‍यावरालाई खुल्‍द नोरालाई त़ोतोला त़ोतोला सुन याद, ‘ङा ङामाहुवा पै आव खेलैसिच्‍यो,’ है दाद याख्‍यानैक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","खाली नलाव ख्‍वा ख्‍वा मिँराए नो राजा खलकलाव मिँलाई यासोवए, ‘आवलाई गेङ़ैताव जैद तायासियो,’ लिद राजाए ल्‍योदा मिँर यारापरींकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“छींनी नो ओहक भरी दैद उहुवत नो ङ़ादाङाव सुन ओरायो ओय़ेन दाज़्‍यावराए ‘कै जैर्‍या’ लिद याखुल्‍क्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","उस॰कताव हुवए, ‘प्रभु, ङालाई नयाँव सुन खेलैसिद ओयाःत दस तोला हाइद ङानै,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ओघरपतीए, ‘स्‍याबास, नँ चाव य़ेन दाज़्‍याव। तकेज़ालाई ब सतस नदोवए ङाराज्‍यालाव दस गोता सहरराए याङ़ैताव ङाजैनिरिज़्‍या,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","फरी नोए उछींताव हुवए, ‘प्रभु, नयाँव सुन खेलैसिद ओयाःत पाँच तोला हाइद ङानै,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ओघरपतीए, ‘नँलाई ब पाँच गोता सहरराए याङ़ैताव ङाजैनिरिज़्‍या,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“फरी नोए उछींताव हुद, ‘प्रभु, नयाँव सुन हिताव ज़ लिज़्‍या। रूमालल ज़ पो·द ङानै। ");
INSERT INTO kjl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","नँ ते नमाझाःव ब नसिम्‍ज़्‍या, नमानैव ब नलाँज़्‍या। है जैद निताव कर्रा नतावए नँलाई रँःद ङाछे·के,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ओघरपतीए नोलाई, ‘नँ कान्‍ल ज़ काम मालागिउ ङाबाँदा, नँलाई नपाँनी ज़ ङाफाल्‍निरिज़्‍या। ङालाई ‘ओमाझाःव ब सिम्‍ज़्‍याव, ओमानैव ब लाँज़्‍याव, नाः कर्रा लिज़्‍या’ लिन्‍या नसैंव ताकिन, ");
INSERT INTO kjl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","काराव नो सुन ब्याङ्कल नमाझाःव? नल नझाःव ताकिन ङाहुवत ओब्‍याजस दैन्‍या ङाल्‍यो,’ है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","नक च्‍याँःसिद लिज़्‍यावरालाई, ‘आवलाई नो सुन नैंद दस तोला ल्‍योलाई एचिके,’ है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","नोराए, ‘प्रभु, ओलस ज़ दस तोला लिज़्‍या सानी,’ है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","नो राजाए, ‘ङा जेलाई साचो है ङादाचिज़्‍या, जोए ओदैवलाई चावस चलैज़्याव, होए फरी ब दैरिज़्‍याव। जोए ओदैवलाई चावस माचलैव, होस छ्या छ्या लिज़्‍याव ब नैंसिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","फरी नो ङालाई याङ़ैताव तान्‍या माभैंःज़्‍याव ङासुतुररालाई आल रैद ङाङ़ाक ज़ याराखेम्‍चिके,’ है यादोक्‍यो दी।” ");
INSERT INTO kjl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","येसुए नो घर्तीलाव पाँर तुपैद ननी पुलुस्‍द यरूसलेमदा पुलुस्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","नकिन जैतून दाँदा यादोज़्‍यावए उखँकाव बेथफागे स़ोनो बेथानिया नाखार जीदा ओकेस्‍नाक ऩेब्‍लो उसिसनिलाई अइ लिद ङ़ादा निपरींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“जिन आव गेङ़ाकाव नाखारल बाचिन्‍केदा। नल तोबो सुए ज़ यामाचेप्‍ताव बछेरा सुर्सिउ दैन्‍या जिन्‍ले। नोलाई पला·द रैचिन्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","सुवाराए, ‘काराव जिन्‍पला·ज़्‍याव?’ है यादाचिन्‍किन, ‘गिनप्रभुलाई चाहिज़्‍या,’ है यारादोचिन,” है लिद निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","नोनी बाद है उनिदोव मिताव ज़ बछेरालाई दैकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","नोलाई निपला·ज़्‍याक बछेराए ओर्गेर हुद, “काराव जिन्‍पला·ज़्‍याव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“गिनप्रभुलाई चाहिज़्‍या,” है यारादोकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","नोनी नो बछेरालाई येसुए ल्‍योक रैद, बछेराए ओतर्त याक्‍वार झाःद येसुलाई चेपो परींकेर। ");
INSERT INTO kjl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","येमत ओबाज़्‍याक मिँराए याक्‍वार येमल तैंदिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","जैतून दाँदातिन सहरदा उझरिनावत नो माहोल्‍यार येसुए ओपाँत बाज़्‍याव भरिए अचम्‍ब अचम्‍बलाव ओय़ेनर यारँःवनी परमेस्‍वरए ल्‍योदा बनै रेंए रेंए अइ लिद याक़िज़्‍याव — ");
INSERT INTO kjl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“परमेस्‍वरए उमिनत हुव राजा धन्‍याकाव ओताक, परमेस्‍वरए उयुँ ब होलाँ ओताक, स्‍वर्गतावर ब ओरेंरक।” ");
INSERT INTO kjl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","नोराए खार्नी ख्‍वा फरिसीराए नो पाँ थैद येसुलाई, “गुर्बा, नसिसरालाई च़िम दाव यापरींके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","येसुए, “ङा साचो है ङादाचिज़्‍या, नोराए च़िम यादोकिन लुँर ब क़िन्‍या लेर,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","येसु सहर छ्योक ओकेस्‍नाक सहरलाई रँःद उप़िलर ऱास्‍द अइ लिके, ");
INSERT INTO kjl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ए यरूसलेमलाव लिज़्‍यावर, जे आछिमकाव जेल्‍योक हुव परमेस्‍वरस खैन्‍या, युँ होलाँ दाव पाँर जेथ·रैव ताकिन तान्‍या ओल्‍यो। अब ते नो जेमारँःधुइ। ");
INSERT INTO kjl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","जेलाई छींनी तछा जेसुतुरर हुद गरर जैद प़ाइँनी घिरिचिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","परमेस्‍वर जेल्‍योक उहुव जेमाथ·रैधुवए जेसुतुरराए जेसहरलाई तैःद लुँए तर्त लुँ ब नैन्‍या मालेर। जेलाई स़ोनो जेज़ारालाई ब पछारिद यारासैःरिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","नकिन येसु यरूसलेमलाव ध्‍यान झ़िमल बाद नलाव पसल्‍यारालाई पले·द, ");
INSERT INTO kjl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","नोरालाई, “धर्मसास्‍त्रल परमेस्‍वरए ओपाँ अइ लिद सर्सिउ लिज़्‍या, ‘ङा ङाझ़िम पोंखारिन्‍या झ़िम जैसिउ लिज़्‍या।’ जे ते झन चोरराए पुप मिताव जैद जेनै,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","नकिन येसुए नो ध्‍यान झ़िमल दिनकाव ज़ परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। खाली नलाव मुख्‍या पुजारीर, सास्‍त्रीर स़ोनो नलाव स़ेर स़ेरर झन येसुलाई सैःन्‍याए जूँनी यापाँसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","हितावत ब मिँ भरिए येसुए ओपाँ थैद घेप्‍पा यारँःवए सैःन्‍या येम मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","हाः बेलाक तछा यरूसलेमलाव ध्‍यान झ़िमल येसुए चाव था ओरासथैज़्‍याक नलाव मुख्‍या पुजारीर, सास्‍त्रीर स़ोनो यहूदीराए यास़ेरर ओल्‍योक हुद, ");
INSERT INTO kjl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“गेलाई है दासिके, आव नदोज़्‍याव य़ेनर नँलाई सुए है उदींव, सुए हक उईंव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","येसुए, “ङा ब जेलाई तोबो है ङादाचिज़्या, नो पाँ है दाँचिके। ");
INSERT INTO kjl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ऱील सछैंज़्‍याव यूहन्‍नाए ओय़ेन परमेस्‍वरए ल्‍योनी ओताव सैं मिँराए ल्‍योनी ओताव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","या याल, “ ‘परमेस्‍वरए ल्‍योनी ओताव’ है गेद्या गेलिकिन, ‘हुकी काराव यूहन्‍नाए ओपाँ जेमाभैंःव?’ है दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","फरी ‘मिँनी’ है गेद्या गेलिकिन, मिँ भरिए यूहन्‍नालाई अगमबक्ता ज़ याथ·रैवए गेलाई झेःद सैःन्‍या ओछ्यास ब लिज़्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","है जैद नोराए येसुलाई, “यूहन्‍नाए ओय़ेन कान्‍नी ओताव गेमासैंए,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","येसुए, “हो ची ताकिन्दा ङालाई आव य़ेन दान्‍या हक सुए ओयाँव ङा ब है ङामादाच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","नकिन नलाव मिँरालाई घर्ती तोबो झाःद अइ लिद यासथैक्‍यो, “तोबो मिँए ओएँः भरिल जोम्‍परसै झाःद मिँरालाई अधियाल याद, ओल जाँवा पै तोबो तादा देसङ लिनाके दी। ");
INSERT INTO kjl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","नो जोम्‍परसै किन्‍या बेलाक तोबो ओनोकोरलाई उजुँ च़ानाव परींक्‍यो। खाली नो अधिया कमैज़्‍यावराए झन नोलाई प़ोद रितो ज़ खेपैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फरी छींनी छुत ओनोकोरलाई उपरींक नोलाई ब प़ोद बीज्‍यात जैद रितो ज़ खेपैकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","छींनी फरी ब तोबोलाई उपरींक हिताव ज़ नोलाई ब प़ोद लल्‍यातोरो जैद ख्‍याकेर दी। ");
INSERT INTO kjl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“नकिन छींनी नो एँःए ओर्गेए, ‘कै जैन्‍या ओताव? ङायुँलाव ङाज़ालाई ज़ परींव ताके। नोलाई ताकिन ओमान नैदिर सैं’ लिद नो ओज़ालाई परींक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","खाली नो ओज़ा उहुज़्‍याव रँःद नो अधिया कमैज़्‍यावर झन या या पाँसिद, ‘आव ते एँः दैन्‍या मिँ ची, आवलाई गेसैःकिन आव एँः गेमीं ज़ तान्या ले,’ लिद, ");
INSERT INTO kjl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","नो मिँलाई एँःनी पाखाङ लाँद सैःकेर दी।” नकिन येसुए, “नो एँःए ओर्गेए अधिया कमैज़्‍यावरालाई कै याजैवके लिक ते, ");
INSERT INTO kjl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","नोर प़ाइँलाई ज़ सैःद नो एँः छुतरालाई अधियाल यान्‍या ले,” है ओरादोक ते, नो पाँ थैज़्‍यावराए यायुँ कैद, “निताव ते खर्क ज़ ताताक,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","नकिन येसुए, “हिताव ताकिन आव धर्मसास्‍त्रलाव पाँए ओअर्थ किताव जेङम्‍सिज़्‍या? ‘भुलीराए कान्‍ल ज़ माज़्‍यासे लिद याख्‍याव लुँ नो ज़ झन भुयाँरलाव लुँ ताके।’ ");
INSERT INTO kjl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","नो लुँत पाज़्याव भरी कुतु कुतु ज़ तान्‍या लेर। नो लुँ फरी यातर्त उहुकिन झन नप नप ज़ तान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","नाःत ज़ सास्‍त्रीर स़ोनो मुख्‍या पुजारीराए ‘आव घर्ती ते गेङ़ैत ज़ झाःद्यासिक्‍यो’ लिन्‍या सैंद येसुलाई हो प़ाइँना ज़ क्‍योःव पैंकेर। खाली मिँर रँःद छे·केर। ");
INSERT INTO kjl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","है जैद नोराए, ‘आवलाई ओपाँ क्‍योःद्याद हाकिमए उकुइत सूँपिउ ताके’ लिद मौका चिऊद, यासकावर ऩेबरेंवा येसुस खैव मिताव जैसिउ परींद येसुए ओय़ेन साँना यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","नो साँना बावराए येसुलाई, “गुर्बा, नँ गेस नपाँज़्याव भरी साचो वाज़ लिज़्‍या। परमेस्‍वरए ल्‍योदा बान्‍या येम नपैसिक ब मिँ रँःद नमादोए, सोजोनी ज़ नदोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","है जैद गेलाई है दाव ताके, माहाराजालाई गे सिर्मा यान्‍या सैं मायान्‍या?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","येसुए नोराए याचाल सैंद, ");
INSERT INTO kjl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“तोबो पैसा सतैंचिसाँकी। नत सुए उसुरूप, सुए उमिन उलिज़्‍याव?” है ओरादोक ते, “माहाराजाए उमीं ज़,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“हो ची ताकिन्‍दा माहाराजाए उमीं भरी माहाराजालाई ज़ एच्‍यो, परमेस्‍वरए उमीं भरी परमेस्‍वरलाई ज़ एच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","है जैद नोराए मिँराए ङ़ाक येसुए ओपाँ क्‍योःव मादैद, झन अचम्‍ब ताद च़िम दाद लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","नकिन सदुकीराए ब येसुलाई पजैना हुकेर। सदुकी है यारादोज़्‍यावराए ‘सिउकिन सैंसिन्‍या माताए’ है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","है जैद नोर हुद, “गुर्बा, मोसाए ओकानुनल इताव सर्सिउ लिज़्‍या, ‘तोबोए ज्‍या दाद ज़ार मादैद उसिकिन, ओभाइए ओदाज्‍युए ओथोर माफ्या·न्‍याए जूँनी ओमारूमलाई ओरैवक।’ ");
INSERT INTO kjl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","है जैद तोबोए ओज़ार सात भाइ याल्‍यो। यादाज्युए ज्‍या दाद ज़ार मादैद ज़ सिके। ");
INSERT INTO kjl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","होए उधूँलावए ओमारूमलाई रैद, नो ब ज़ार मादैद ज़ सिके। ");
INSERT INTO kjl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","नकिन साइँला मनी हिताव ज़ ताके। नितावनी ज़ सात भाइ भरिए ज़ नोलाई रैद ज़ार मादैद ज़ सिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","प़ाइँरानी छींनी नो मेंमा ब सिके। ");
INSERT INTO kjl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","है जैद नो मेंमा सात भाइए याज्‍या ओतावए अजम्‍बरी जुनील काताकावए याज्‍या तान्‍या?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","हाःत ज़ येसुए, “आव मानुवाताव मिँराए ज्‍या ब दोज़्‍यार, रे ब दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","अजम्‍बरी जुनी दैन्‍या तावराए ते स्‍वर्गत ज्‍या ब मादोर, रे ब मादोर। ");
INSERT INTO kjl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","नोर सिउनी यासैंसिउत परमेस्‍वरए ओज़ार ताद ओचाकर्‍या स्‍यासोर यातावए फरी खर्क ज़ सिन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","है जैद सिउकिन सैंसिन्‍या ओताज़्याव सैं ओमाताज़्याव मोसाए ओसरोनी ब सैंच्‍यो। नोए झोपोरा ओचाँःज़्‍यावनी परमेस्‍वरए ओर्गा थैद अइ लिद सर्क्‍यो, ‘ङा अब्राहामए ओपरमेस्‍वर, इसहाकए ओपरमेस्‍वर स़ोनो याकूबए ओपरमेस्‍वर ज़।’ ");
INSERT INTO kjl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ओल ते मोरोराए यापरमेस्‍वर माःक, जींदोराए यापरमेस्‍वर ची। है जैद ओलस लिज़्‍याव भरी जींदो ज़ ताज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","नो पाँ थैद नलाव सास्‍त्रीराए येसुलाई, “थिक ज़ है नरादोके, गुर्बा,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","हाःकिन सुए ज़ येसुस पाँन्‍या आँत मादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","नकिन येसुए है यादोक्‍यो, “मिँराए कै जैद ख्रीसलाई दाऊदए ओथोलाव है यादोज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","ओल दाऊदए ज़ ख्रीसए उजूँनी भजन पोस्‍तोकोल अइ लिद सर्द नैव, ‘परमेस्‍वरए ङाप्रभुलाई, ‘नसुतुररालाई नखँ धूँल झाःद ङामाईंवा पै, ङावोर्दा च़ुसिद लिन्‍के,’ है दोक्‍यो।’ ");
INSERT INTO kjl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","है जैद ओल दाऊदए मनी ख्रीसलाई ‘ङाप्रभु ज़’ है ओदोकिन नो कै जैद ओल ओथोलाव ओताज़्‍याव?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","मिँ भरिए येसुए ओपाँ याथैज़्‍याक उसिसरालाई, ");
INSERT INTO kjl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“जे ते सास्‍त्रीराए यादोज़्‍याव मिताव य़ेन दान्‍या माःक। नोर रेरे बेन्बेनो क्‍वा क्‍वाइसिद ‘प़ाइँए धो घदासिरक’ लिद बजार जीदा दुलिरिज़्‍यार, स़ोनो धर्मसास्‍त्र झ़िमराल, घ्योःव घ्योःव भत्‍यारल प़ाइँए रँःन्‍याक ओमान ल्‍यो पोल वाज़ च़ुसिउ पैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","नो सास्‍त्रीराए झन राँदी मेंमारालाई तँनी छाम छुम याराख्‍याज़्‍यार, मिँराए ङ़ाक वाज़ बनै चाव चाव पोंखारिउ जैसिज़्‍यार। नोराए ते प़ाइँरानी घ्‍योःव सजा ज़ दैरिज़्‍यार,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","नकिन येसुए यरूसलेमलाव ध्‍यान झ़िमल धनी धनीराए परमेस्‍वरलाई भिती याचरैःज़्‍याव ओराचिऊज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","तोबो काता ज़ माल्‍यो राँदी मेंमाए ऩेब्‍लो पैसा ओचरैःज़्‍याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","नो रँःद येसुए नलावरालाई, “ङा साचो ज़ है ङादाचिज़्‍या, आव काता ज़ माल्‍यो राँदी मेंमाए छुतराकिन कुधु चरैःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","धनीराए ते यासय़ेलोनी वाज़ चरैःकेर। नो राँदी मेंमाए ते ओललाई ओमाथैंज़्यावत ब ओलस लिज़्‍याव भरी प़ाइँ ज़ चरैःक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ध्‍यान झ़िमनी पुलुस्‍द याबाज़्‍याक ख्‍वा ख्‍वा मिँराए, ‘आव ध्‍यान झ़िमलाव लुँर काता आः चावर, काता आः चावराए सिङारैद यानैज़्‍याव’ है लिद या या यापाँज़्‍याव येसुए थैद, ");
INSERT INTO kjl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“आव जेरँःज़्‍याव भरी तछा तैःद लुँए तर्त लुँ ब रहिन्‍या माले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","नोराए, “गुर्बा, आव नपाँ भरी खर्क ओतारिज़्‍याव? नोर तान्‍या सरेस किताव ओतारिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","येसुए, “जे जोगोइसिद लिच्‍यो, म़ानी सुवाराए झुकैचिर्‍या। ङा ङामिन कुद ‘ख्रीस ङा ज़’ है लिज़्‍यावर स़ोनो ‘बेला हुके’ है लिज़्‍यावर कुधु ज़ हुन्‍या लेर। जे नोराए पाँत ताबाच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","फरी ‘आङ लरैं ताज़्‍या, होङ लरैं ताज़्‍या’ लिन्‍या जेथैक जे ताछे·च्‍यो। नो भरी ङ़ादा ताव परिए, खाली नो खेम्‍न्‍या बेला माःक। ");
INSERT INTO kjl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“नोकिन ङ़ादा जात जात, राज्‍या राज्‍या लरैं दान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","घ्‍योःव घ्‍योःव भोंचालोर हुद, पो पोङ अनिकालर स़ोनो ऩुल्‍पा ऩुल्‍मार ताद, नमत ब बनै छे छे ङम्‍सिउ सरेसर तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“खाली आव भरी ओमाताद ज़ ङाजूँनी जेखिरी पसिद क्‍योःद झ्यालखानाल झाःचिरिज़्यार। कचरील लाँद हाकिमर स़ोनो राजाराए ङ़ाक सच्‍याँचिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","आव भरिनी जे नोरालाई ङासाची यान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","नो बेलाक जेक्‍याँलाई जोगोइन्‍याए जूँनी ‘ङा कै लिन्‍या, काता पाँन्‍या ओताव?’ लिद जेयुँ आँचा पाँचा ताजैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ङा ज़ जेलाई नो जेखिरी पसिज़्‍यावराए मापल्‍तैधुन्‍या पाँर स़ोनो बुद्धीर यान्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","हैदी ब जे ख्‍वारालाई जेबाबु जेआमाराए, जेदाज्‍यु भाइराए, जेरला मेलाराए स़ोनो जेनैं मेंराए ब जेलाई सैःन्‍याए जूँनी सूँपिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","जे ङामिनतावर जेतावए जेलाई प़ाइँए सोन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","हैदी ब तोबो जेचेम ब जेङ़ैतिन गलिन्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ङामिनत थ॰रिद जेलिज़्‍यावए साचो जुनी दैन्‍या जेले।” ");
INSERT INTO kjl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“यरूसलेम सहर ओखेम्‍रिज़्‍याव बेला आव सरेसनी ज़ सैंच्‍यो। तछा आव यरूसलेमस लरैं दाना हुव फौजीराए घिरिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","हो बेलाक यहूदियाल लिज़्‍यावर गों जीदा ओधोंःरक। सहरल लिज़्‍यावर ब पुलुस्‍द ओधोंःरक। फरी नाखारल लिज़्‍यावर यरूसलेमल ताबारक। ");
INSERT INTO kjl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","नो बेला नो धर्मसास्‍त्रलाव सर्सिउ मिताव परमेस्‍वरए ओराएरिज़्‍याव सजा ओसयो·ज़्‍याव बेला ज़। ");
INSERT INTO kjl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","नो बेलाक याफूल याज़ा ल्‍योर स़ोनो नुइँ सवैज़्‍याव आमार युँ नावज़ार। आव देसलाव मिँरालाई बनै छे छे ङम्‍सिउ धो सहिउ परमेस्‍वरए ओसजा हुरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","कुधुलाई तरवालीराए याराफूइँरिज़्‍यार। कुधुलाई कैत जैद देस देसदा यारालाँरिज़्‍यार। छुत जातलाव मिँराए याबेला ओमायो·वा पै यरूसलेमलाई छिल्‍द नैन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“नकिन निमीत, स़्यावैत, सोरोरात मनी सरेसर रैंःन्‍या लेर। आव नामल फरी समुन्‍द्रलाव ऱीर बनै छल्‍किद नम मिताव यागर्जिक मानुवाताव मिँर यायुँ आँचा पाँचा ताद बनै छे·न्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","नमतावर यासतर म़ाद याथोनो·सिज़्‍याव रँःद ‘आव मानुवा कै तान्‍या ओताव’ लिद मिँर याछ्याचेए मुर्छा परिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","हाःत ज़ मिँ मिन्‍सिउलाई बनै ज़गै मगैव ओसक्तीरास बादल जींल उहुज़्‍याव रँःन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","है जैद जे ते इतावर ओतानाज़्‍याव जेरँःक, ‘परमेस्‍वरए गेलाई उस्‍कैन्‍या बेला हुके’ लिद जेयुँर सझेंःद रेंचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","नकिन तोबो घर्ती झाःद याएक्‍यो, “नेभारा सीं तादी ब, जो सीं तादी ब, ");
INSERT INTO kjl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","नोर यामोम्‍नाक ‘उभ्‍याली उहुव ची ओल्‍यो’ लिन्‍या जेसैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","हिताव ज़ आव है ङादाचिउ पाँ भरी ओतानाज़्याव जेरँःक ‘परमेस्‍वरए ओराज्‍या उहुनाव ची ओल्‍यो’ लिन्‍या सैंच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ङा जेलाई साचो है ङादाचिज़्‍या, आव भरी ओमातावा पै आव जुक खेम्‍न्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","आव नाम नम ते खेम्‍न्‍या ले, खाली ङा ङापाँ ते खर्क ज़ म़ान्‍या माले।” ");
INSERT INTO kjl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“है जैद जे ते जेमन लागिउ य़ेनर दाद मँःए मँःए बाऱिन्‍या, स़ोनो ‘आव ङाजिउत कै तान्‍या ओताव?’ लिद व़ीनी फुइ लिन्‍या, निताव य़ेनरानी जोगोइसिद लिच्‍यो, म़ानी हो छ्याम झिबलाल परिउ मिताव जेताया। ");
INSERT INTO kjl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","हो छ्याम परमेस्‍वरए ओसजा आव मानुवाताव मिँ भरिराए याक्‍याँत तछ्योनी ज़ हुरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","है जैद जे निताव छे छे ङम्‍सिउ सजारानी पुलुस्‍द मिँ मिन्‍सिउए ओङ़ाक माछे·द ज़ थ॰रिन्‍याए जूँनी अल्‍सैं मादाद पोंखारिउ ज़ नैच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","येसुए दिनकाव ज़ लाक लाक यरूसलेमलाव ध्‍यान झ़िमल परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ऱिमक ऱिमक ननी पुलुस्‍द जैतून दाँदा जीदा ओबासिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","है जैद मिँर ओपाँ थैन्‍याए जूँनी छकाल्‍न्‍या घग ध्‍यान झ़िमल याहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","निस्‍तार यादोज़्‍याव माँदा भरेस ज़्‍यान्‍या पर्ब हुनाद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","नो बेलाक ज़ मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए ‘येसुलाई कै जैद सैःन्‍या ओताव?’ लिद बुद्धी याकलैज़्‍याव। ‘मिँराए ङ़ाक सैःकिन मिँर मचिर्‍या’ लिद याछे·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","हाःत ज़ सैतान नो बाह्र जना उसिसरासकाव यहूदा इस्‍करियोतए ओक्‍याँत पसिके। ");
INSERT INTO kjl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","है जैद नो ननी पुलुस्‍द मुख्‍या पुजारीर स़ोनो ध्‍यान झ़िमलाव पुलिसराए ल्‍योक बाद ‘येसुलाई इतावनी जेकुइत जैद ङायाचिरिज़्‍या’ लिद पाँसिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","नोर बनै रेंद नोलाई पैसा यान्‍या जैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","इस्‍करियोत ब उचित बुझिद हाःकिन मिँर यामाल्‍यो बेलाक क्‍योःन्‍या मौका उखिम्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","हाःत ज़ नो माँदा भरेस ज़्‍यान्‍या पर्ब सुरू ओतावत पाथा पल्‍न्‍या छ्याम ताके। ");
INSERT INTO kjl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","है जैद येसुए पत्रुस स़ोनो यूहन्‍नानिलाई अइ लिद निपरींक्‍यो, “गे आव पर्ब मानिन्‍याए जूँनी जिन ज़्‍यावर जैनाचिन्‍के,” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“नँ कै नलिज़्या, गिन काङ्ङ बाद जैनान्‍या?” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","येसुए फरी, “जिन सहरल जिन्‍पसिउ प़ाइँना तोबो ऱी गप्‍द ओघागरी छींद बाज़्‍याव मिँ दैन्‍या जिन्‍ले। नोए उछीं उछीं बाद उपसिज़्‍याव झ़िमक ज़ बाचिन। ");
INSERT INTO kjl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","नक बाद नो झ़िमए ओर्गेलाई है दोचिन, ‘नँलाई गेगुर्बाए है दींज़्‍याव, पाहुना लिन्‍या कुन्‍ती काङ्क उलिज़्‍याव? आव पर्ब उसिसरास नल ज़ मानिरिज़्‍याव दी,’ है दोचिन। ");
INSERT INTO kjl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","है जिन्‍दोव प़ाइँना नोए ओतर्ताव तालल तोबो घेप्‍पा कुन्‍ती चावस सजैसिउ जिनलाई सतैंद्यान्‍या ले। गेज़्‍याव भरी नल ज़ जैचिन,” है दाद निपरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","है जैद नोनी बाद है उनिदोव मिताव ज़ दैद, पर्बताव ज़्‍याव भरी जैकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","मानिन्‍या बेला ओतावत येसु ओसाचीरास नो कुन्‍तील दुप्‍सिद ज़्‍यावर ज़्‍यान्‍याए जूँनी याच़ुसिउत, ");
INSERT INTO kjl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","येसुए, “आव पर्ब ङाक्‍याँत हुरिज़्‍याव दुखर ओमाताद ज़ जेस मानिउ ङापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ङा जेलाई है ङादाचिज़्‍या, परमेस्‍वरए ओभत्‍यारल उमिनतावर यामादुप्‍सिवा पै ङा जेस फरी सिप ज़्‍यान्‍या ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","नकिन येसुए खुरी उकुइत रैद धन्‍याबाद चरैःद उसिसरालाई याद, “हाँ, आव भाःचिके। ");
INSERT INTO kjl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ङा जेलाई है ङादाचिज़्‍या, परमेस्‍वरए ओराज्‍या ओमाहुवा पै दाखमद्य फरी ओन्‍या ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","नकिन येसुए उकुइत भरेस तोबो रैद, धन्‍याबाद चरैःद, नो भरेस केःद उसिसरालाई अइ लिद भाःद याएक्‍यो, “आव भरेस जेजूँनी झाःद ङायाचिरिज़्‍याव ङाक्‍याँ ज़। आकिनी ङालाई मामेंःन्‍याए जूँनी आव भत्‍यार दाव य़ेन ज़ दोच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","हिताव ज़ फरी नो भरेस याज़्‍युवत येसुए खुरी उकुइत रैद, “आव जेजूँनी ङासोभोरिज़्‍याव ङाझी ज़। आनी ज़ परमेस्‍वरए जेस साःरो बाचा नैद्याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ङालाई धोका याज़्याव मिँ जेखार्ल ज़ लिज़्‍या, ङास सिप ज़ ज़्‍युज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","मिँ मिन्‍सिउए ते गोइँसिउ मिताव सयो·व ज़ परिए, खाली नोलाई धोका याज़्याव मिँलाई ते थैए माँतकन ज़ लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","नकिन उसिसर या याल, “गेनी निताव य़ेन दान्‍या सु ओताव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","नकिन जाँवाक उसिसर, ‘गे भरिनी सु घेप्‍पा गेलिज़्‍याव?’ लिद याखर्लेसिनाक, ");
INSERT INTO kjl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","येसुए, “आव मानुवाताव चलननी जोर राजा ताज़्‍यार, होर याधूँलावराए याङ़ैत बनै अखत्‍यासो ताज़्‍यार। याधूँलावराए फरी नोरालाई ‘गेधर्मीदातार’ है दाव ज़ परिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","खाली जे ते निताव जैसिन्‍या माःक, बुरू जेनी जो स़ेर ताज़्‍या, हो प़ाइँए याधूँलाव ओजैसिक। फरी जोए हक दैज़्‍याव, नो प़ाइँए यासेवा दान्‍या ओजैसिक। ");
INSERT INTO kjl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","भत्‍यारल च़ुसिज़्‍याव घेप्‍पा ओताज़्‍याव, सैं ज़्‍याव लाँज़्‍याव घेप्‍पा ओताज़्‍याव? नो च़ुसिज़्‍याव ज़ घेप्‍पा ताज़्‍या सानी सैं माःक? हैदी ब ङा झन जेसेवा दान्‍या ङाजैसिके। ");
INSERT INTO kjl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“जे फरी आव मानुवाताव ङादुख भरिल ङास ङासतत लिन्‍यार जेतावए, ");
INSERT INTO kjl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","किताव ङालाई ङाबाबुए ओराज्‍या याद नैनाव, हिताव ज़ ङा ब जेलाई तोबो हक ङायाचिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","नो ङाराज्‍याल जे ङास ज़ तोबोल सिप ज़ ज़्‍यान्‍या जेले, स़ोनो बाह्र थर इस्राएलीराए याङ़ैतावर ताद याय़ेन फाल्‍द्यान्‍या ब जेले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","नकिन येसुए पत्रुसलाई, “अ सिमोन, सिमोन, किताव मनमलाई छिन्‍कैज़्यार, हिताव ज़ सैतानए नँलाई ब जाँचिन्‍या झाःसिद ले। ");
INSERT INTO kjl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","है जैद ङा नजूँनी ङाल्‍योदा नदोव सत ताऱासोक लिद पोंखारिद ङाईंज़्‍या। फरी तखेप नबादी ब ओल्‍द नहुवत नँ ननैंरालाई पाथ पारैव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पत्रुसए, “प्रभु, नँस झ्यालखानाल बान्‍या ब तयार ज़ ङालिज़्या, नँस सिन्‍या ब तयार ज़ ङालिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","येसुए फरी, “पत्रुस, नँलाई है ङादींज़्‍या, आछिम रील भाल्‍या ओमाकोद ङालाई स़ोंखेप ‘ङामासरेसे’ है दान्‍या नले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","नकिन येसुए प़ाइँलाई, “ङा नो ङ़ादा जेलाई पैसा, पोला, झ़ैंर मालाँद ज़ ङापरींचिक, काताराए खाँचो माताया?” है ओरादोक ते, “काताए खाँचो ज़ माताके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","नकिन फरी, “आकिन ते जेबाक हो मिताव तान्‍या माले। फरी जेबाक पैसाए ओचाहित ब तारिज़्‍या, जेझ़ैं लाँन्‍या ओचाहित ब तारिज़्‍या, स़ोनो जेस तरवाली ओमालिकिन जेक्‍वार यो·द तादी ब लँःद लाँन्‍या बेला हुके। ");
INSERT INTO kjl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","नो ङाजूँनी धर्मसास्‍त्रलाव सर्सिउ पाँ ब यो·नारिके। नलाव सर्सिउ आव ज़, ‘नोलाई सिन्‍या सजा दैवरास तोबोल गनिरिज़्‍यार।’ नो पाँ ङाक्‍याँत जुनी ब यो·व ज़ परिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","हाःत ज़ उसिसराए झन, “प्रभु, गेस ऩेब्‍लो तरवाली लिज़्‍या,” है यादोक ते, “ङापाँ जेमातीधुव प़ाइँना घलिज़्‍याक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","येसु ननी पुलुस्‍द एकतारकाव ओबाज़्‍याव जैतून दाँदादा बाके। उसिसर ब ओलस ज़ बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","नो पोत याकेसोत उसिसरालाई, “पोंखारिचिके, म़ानी दुखराल जेमाथ॰रिधुया,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ओल याकिन जाँ अछतङ लुँ झोमक केस्‍न्‍यावाक बाद नामक उघूँदानी तिकिसिद, ");
INSERT INTO kjl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“अ बाबु, नयुँ ओताकिन आव ङाक्‍याँत हुरिज़्‍याव दुखर वैंद्याँके। खाली ङा ङायुँ माःक, नँ नयुँ ओताकिन वाज़,” है लिद पोंखारिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","हाःत ज़ स्‍वर्गनी परमेस्‍वरए तोबो ओचाकर्‍या हुद येसुलाई सघैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","उयुँर बनै धो थाइव ताद बनै धामास पोंखारिद ओक्‍याँतिन ओपस्‍योंर ब झी स्‍यासो हुद बाप बाप यातेज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","पोंखारिद ओखेमोत उसिसराए ल्‍योक ओबाक नोर प़ाइँ यासोगोए स्‍याँद यालिज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“काराव जेस्‍याँज़्‍याव? सैंसिद पोंखारिचिके, म़ानी दुखराल जेमाथ॰रिधुया,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","येसु ओपाँज़्‍याक ज़ मिँर तबगाल हुकेर। नोराए याङ़ा याङ़ा बाह्र जना उसिसरानिकाव यहूदा इस्‍करियोत उहुज़्‍याव। नो येसुए ल्‍योक हुद माइँ ओदोक, ");
INSERT INTO kjl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","येसुए, “अ यहूदा, मिँ मिन्‍सिउलाई माइँ दाव जैसिद धोका याव नपैंज़्‍याव रो?” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","येसुस लिज़्‍यावराए, ‘याक्‍योःरिज़्‍याव ची ओल्‍यो’ लिन्‍या सैंद, “प्रभु, आवरालाई तरवालीए गेरापल रो?” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","तोबोए ते ओतरवाली हाइद प्रधान पुजारीए ओनोकोरलाई वोर्निकाव ओर्ना पल्‍द सतेदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","नो रँःद येसुए, “च़िम दोके, अइ जैन्‍या माःक,” है दाद नो मिँए ओर्ना छाप्‍द्याद सोजोकाव ज़ जैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","नकिन येसुए ओललाई क्‍योःना हुव मुख्‍या पुजारीर, यहूदीराए यास़ेरर स़ोनो ध्‍यान झ़िमलाव पुलिसरालाई, “काता ङालाई दाँकालाई मिताव तरवालीर खोंतार दाद जेक्‍योःहुनाव? ");
INSERT INTO kjl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ङा दिनकाव ज़ जेस ध्‍यान झ़िमल ङालिज़्‍याव बेलाक जेमाक्‍योःनाके। हैदी ब गोइँसिउ मिताव चुम चुमोए ओहक चलैन्‍या जेबेला आव ज़,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","नकिन येसुलाई क्‍योःद प्रधान पुजारीए उझ़िमक लाँकेर। पत्रुस ब याछीं याछीं जाँ तादाङ ओबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","मिँर प्रधान पुजारीए ओचतराक मेंः दाद यामुइँसिज़्‍याक पत्रुस ब नोराए ल्‍योक ज़ च़ुसिनाके। ");
INSERT INTO kjl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","नलाव तोबो नोकोर्नी मेंमाए पत्रुस मेंःए ओपलाँक च़ुसिद उलिज़्‍याव रँःद नोलाई लँ लँ चिऊद, “आव ब येसुस उलिज़्‍याव,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पत्रुसए, “अ बुची, ङा ते नो है नलिज़्‍याव मिँलाई ङामासरेसे,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","नकिन जाँवाक फरी तोबोए पत्रुसलाई सरेस्‍द, “नँ ते होसकाव ज़ सानी,” है ओदोक ते, पत्रुसए फरी, “ङा ते होसकाव माःक ब्‍याँ,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","नकिन तघन्‍तावाक फरी तोबो हुद, “आव ब पक्‍का नोसकाव ज़, आव ते गालीललाव ज़ ची,” है दाव ज़ ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पत्रुसए झन, “नँ काता नपाँज़्‍याव इताव, ङा काता ज़ ङामासैंए,” है ओदोव प़ाइँना भाल्‍या ब कोके। ");
INSERT INTO kjl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","हाःत ज़ येसु पत्रुसए ल्‍योदा भाल्‍सिके। पत्रुसए नो रँःद ङ़ादा प्रभुए, “भाल्‍या ओमाकोद ज़ ङालाई स़ोंखेप ‘ङामासरेसे’ है लिन्‍या नले,” है ओदोव चेतैद, ");
INSERT INTO kjl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","लाँःक पुलुस्‍द धस धस घर्के। ");
INSERT INTO kjl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","नकिन येसुलाई गुद नैज़्यावराए प़ोद बरे·द, ");
INSERT INTO kjl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","उमी कप्‍द्याद, “नँलाई प़ोज़्‍याव सु? है लिन्‍के,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","फरी बनै उल्‍लिनी गिल्‍ली दाद ब थल्‍केर। ");
INSERT INTO kjl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","नम उसँव प़ाइँना यहूदीराए यास़ेरर, मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए घ्‍योःव कचरी जैद प़ाइँ दुप्‍सिद, येसुलाई याङ़ाक सच्‍याँद, ");
INSERT INTO kjl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“नँ नो धर्मसास्‍त्रलाव हुरिज़्‍याव ख्रीस ज़ रो? नँ साचो हो ज़ ताकिन गेलाई है दासिके,” है यादोक ते, येसुए, “है ङादाचिदी ब जे ङालाई पतिन्‍या जेमाले, ");
INSERT INTO kjl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ङा जेलाई ङासुधिचिदी ब जे जवाप यान्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","खाली अबकिन मिँ मिन्‍सिउ माहान परमेस्‍वरए ओवोर्दा च़ुसिन्‍या ङाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","हाःत ज़ नलाव भरिए, “हुकी नँ परमेस्‍वरए ओज़ा ज़ रो?” है यादोक ते, येसुए, “हैज़, जे है जेलिज़्‍याव मिताव ज़,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","नोर झन, “अब ते गेलाई छुत साची माचाहिए, साची भरी ओयाःनी ज़ गेथैके,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","नलाव दुप्‍सिउ भरिए येसुलाई पिलातसए ल्‍योक लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","नक लाँद येसुलाई खत लैद नोराए, “आव मिँ ख्रीस जैसिद, गेराजा ब जैसिउ पैंद, रोमी सरकारलाई सिर्मा यान्‍या माःक लिद गेदेसलाव मिँरालाई यामचैज़्‍याव,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातसए नोराए यापाँ थैद येसुलाई, “नँ साचो यहूदीराए याराजा ज़ रो?” है ओदोक ते, “नँ ज़ नथ·रैनाके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","नकिन पिलातसए मुख्‍या पुजारीर स़ोनो नो माहोल्‍यारालाई, “आवए ओखत ते काता ज़ ङामारँःए,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","नोराए झन, “यहूदिया खन्‍द भरिल गालीलकिन आङ पै ज़ ओपाँर सथैद मिँरालाई यामचैज़्‍याव,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","पिलातसए नोराए यापाँ थैद आव गालीललाव सैं माःक लिद सुधिद, ");
INSERT INTO kjl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","‘आव ते हेरोदए उकुइताव ज़ ची ओल्‍यो’ लिन्‍या थ·रैद हेरोदए ल्‍योदा परींक्‍यो। हेरोद ब हाः बेलाक यरूसलेमल हुद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदए येसुलाई रँःद बनै खुसी ताके। नोए ङ़ादाकिन ज़ येसुए उजूँनी थैद ‘ओदोज़्‍याव सरेसर ब रँःव ङादैकिन ताखेहो’ लिद दैसिउ ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","है जैद हेरोदए येसुलाई बनै ज़ खोले·क्‍यो। खाली येसुए घाइ ज़ मादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","हो बेलाक मुख्‍या पुजारीर स़ोनो सास्‍त्रीराए नक च्‍याँःसिद येसुलाई खत लैव ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हाःत ज़ हेरोदए उसिपाईंरास येसुलाई बनै हेलारी मिताव जैद बरे·न्‍याए जूँनी राजाए जासिन्‍या मिताव क्‍वा जास्‍द फरी पिलातसए ल्‍योदा ज़ लाँव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","हो छ्यामकिन ज़ हेरोद स़ोनो पिलातसनी नी नील खैद नैं नैं ब ताकिनी। नोनी ङ़ादाकिन निमाखैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातसए मुख्‍या पुजारीर, मिँराए याघेप्‍पार स़ोनो माहोल्‍यारालाई फरी ब दुप्‍द, ");
INSERT INTO kjl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“जे ते आव मिँलाई ‘मिँरालाई यामचैज़्‍याव’ लिद ङाल्‍योक जेरैके। नोलाई जेङ़ाक ङाफाल्‍क जे है जेलिज़्‍याव मिताव ओखतर ते काता ज़ ङामादैके। ");
INSERT INTO kjl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हेरोदए मनी ओखत काता ज़ मादैद ङाल्‍योदा सोवोल्‍द्याँक्‍यो। है जैद आव मिँए सिन्‍या मिताव य़ेन ओदोव कान्‍नी ज़ मारैंःए। ");
INSERT INTO kjl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","है जैद ङा आवलाई तखेप सजा याद ङाऱास्‍रिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","नोराए याचलनल पर्बत सालकाव तखेप तोबो कैदीलाई याऱास्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","हाःत ज़ नलावराए, “आवलाई सैःद बारब्‍बालाई ऱास्‍द्यासिके,” है लिद बनै क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","नो बारब्‍बा सरकारकिन तँदा जैसिद मिँरालाई मचैद तोबो ऩेब्‍लोलाई ओरासैःवनी झ्यालखानाल उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातसए फरी येसुलाई ऱासो ओपैंज़्‍यावए माहोल्‍यारालाई फरी तखेप यासम्‍जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","हितावत ब, “आवलाई क्रुसत तङ्गैद सैःन्‍या ज़,” लिद बनै क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","हाःत ज़ पिलातसए फरी, “काराव? आवए मादान्‍या काता दाद ओनैज़्‍याव? ङा ते आवलाई सैःन्‍या मिताव ओय़ेन कान्‍त ज़ ङामादैए। है जैद ङा आवलाई तखेप सजा याद ङाऱास्‍रिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","नोर झन बनै ज़ मचिद, ‘क्रुसत तङ्गैन्‍या ज़’ है लिद याक़िक पिलातसए ओपाँ ज़ सोङोइदिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","है जैद पिलातसए यापाँ ज़ थ·रैद्याद, ");
INSERT INTO kjl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","नो याऩिउ झ्यालखानाल लिज़्‍याव मिँ सैःद मिँरालाई मचैव बारब्‍बालाई ऱास्‍द्याद येसुलाई ‘जेजैन्‍या जैचिके’ लिद यालाई ज़ यासूँपिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","येसुलाई सैःना यालाँज़्‍याक नाखारनी हुज़्‍याव कुरेनीलाव तोबो सिमोनलाई येसुए ओलाँज़्‍याव क्रुस सुघुर्द येसुए उछीं उछीं बाव परींकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","येसुए उछीं उछीं बाज़्‍यावर कुधु माहोल्‍या ज़ यालिज़्‍याव। नोरास मेंमार ब घरे घरे याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","नोराए ल्योदा येसु उछींदा भाल्‍सिद, “अ यरूसलेमलाव मेंमार, ङाजूँनी ताघर्च्‍यो। बुरू जेजूँनी स़ोनो जेज़ाराए जूँनी घर्चिके। ");
INSERT INTO kjl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","तछा परमेस्‍वरए ओसजा उहुक आलाव मिँराए, ‘ज़ा मादैज़्‍याव थारी मेंमार, नुइँ सोवैन्‍या याज़ा माल्‍योर याभागी ल्‍योर ज़ लिज़्‍यार,’ है लिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","स़ोनो, ‘हाँरालाई ब ‘गेतर्त तेचिके’, गोंरालाई ब ‘गेलाई राल्‍सिके’ है दान्‍या लेर।’ ");
INSERT INTO kjl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ङा काचो सीं स्‍यासोलाई अइ याजैनाकिन, या थँव सीं स्‍यासोरालाई परमेस्‍वरए कै याजैवके?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","येसुस तखेप्‍त सैःन्‍याए जूँनी ऩेब्‍लो अपराधीनिलाई ब यारालाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","नोर खप्‍पर्‍या पो यादोज़्‍यावक याकेसोत क्रुसत यारातङ्गैकेर। नो अपराधीनिलाई तोबोलाई ओवोर्दा, तोबोलाई ओदाबर्‍यादा याराजैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","येसुए अइ लिद पोंखारिक्‍यो, “परमेस्‍वर बाबु, आवरालाई कैज़ ताराजैयो, यादोज़्‍याव य़ेन मासैंर।” नोराए फरी येसुए ओक्‍वारात गोला झाःद भाःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","मिँर नक च्‍याँःसिद याभाल्‍सिज़्‍याव। याघेप्‍पाराए फरी, “आवए छुतरालाई ते याबाँचैक्‍यो, परमेस्‍वरए साचो ओछाँतिउ ख्रीस ज़ ताकिन ओक्‍याँलाई ब ओबाँचैवक,” है लिद बरे·केर। ");
INSERT INTO kjl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपाईंराए ब गिल्‍लैद ओल्‍योक बाद सिरो दाखमद्य याद, ");
INSERT INTO kjl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“नँ यहूदीराए याराजा ताकिन नक्‍याँलाई बाँचैके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ओललाई तङ्गैद यानैज़्‍याव क्रुसए ओङ़ैत फरी, ‘आव यहूदीराए याराजा ज़’ है लिद तोबो फल्‍यात सर्द चकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","येसुस तङ्गैसिउ अपराधीनी ब तोबोए येसुलाई गिल्‍लैद, “नँ ख्रीस माःक रो? ख्रीस नताकिन नक्‍याँलाई मनी गिनलाई मनी बाँचैसिन्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ओनैंए नोलाई सिङार्द, “नँ सिन्‍या सजा दैद नैज़्‍यावत ब परमेस्‍वरलाई रँःद नमाछे·ए रो? ");
INSERT INTO kjl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","गिन ते गिनय़ेननी ज़ इताव सजा दैन्‍या गिन्ताके। आव मिँए ते मादान्‍या काता ज़ मादोव,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","येसुलाई, “अ येसु, नँ नराज्‍याल नपसिक ङालाई ब तामेंःनायो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","येसुए, “नँलाई साचो है ङादींज़्‍या, आछिमकिन ज़ नँ ङास स्‍वर्गत नतारिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","हो बेलाक बाह्र बजेवाकिन तीन बजे पै देस भरी काल्‍या कले झ्याद, ");
INSERT INTO kjl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","निमीए ओज़गै ज़ मारैंःके। थिक हो बेलाक ज़ ध्‍यान झ़िमलाव बारिसिउ क्‍वा ब ओलनी ज़ ऩेपरा ताद चिस्‍के। ");
INSERT INTO kjl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","हाःत ज़ येसु ब बनै चोइस अइ लिद क़िके, “अ परमेस्‍वर बाबु, आव ङापुरूस नपिछाल ज़ ङाईंज़्‍या,” है लिद उस॰ सफ्या·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","नक च्‍याँःसिद लिज़्‍याव कप्‍तानए नो भरी रँःद, “आव ते साचो धर्मी मिँ ज़ ची ओल्‍यो,” लिद परमेस्‍वरए उमिन सघ्‍योःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","नो भाल्‍सिना हुव माहोल्‍याराए नो भरी रँःद घरे घरे याझ़िमदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ओल येसुस बाऱिज़्‍याव मिँर स़ोनो गालीलनी ओलस हुव मेंमार जाँ तादाङ च्‍याँःसिद याभाल्‍सिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","यहूदिया खन्‍दलाव अरिमाथिया नाखारलाव तोबो योसेफ यादोज़्‍याव घ्‍योःव कचरीलाव मिँ ओल्‍यो। नो धर्मी, परमेस्‍वरए ओराज्‍या खिम्‍ज़्‍याव मिँ ओतावए येसुलाई सैःन्‍या यासल्‍लाल माखैद भैंःद ओमाराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","नोए पिलातसए ल्‍योक येसुए ओमोरो ऩिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","नो मोरोलाई क्रुसतिन हाइद, पालो क्‍वाए लुम्‍बैद सुलाई ज़ यामाराझाःताव दावन खुपिद पुप जैद ओनैज़्याव खादरल झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","हो छ्याम तयारीलाव दिन ओल्‍यो। ऩासिन्‍या छ्याम सुरू तानाद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","येसुए उछींताव हुव गालीललाव मेंमार योसेफए उछीं उछीं बाद नो मोरो ओझाःव खादर चिऊकेर। ");
INSERT INTO kjl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","नो मेंमार ओल्‍द बाद येसुए ओमोरोलाई थीन्‍याए जूँनी चाव सी ङरो म़ासर, अतरर सरजाम जैद हो पराःती ऩासिन्‍या छ्याम ओतावए कानुनलाई भैंःद ऩासिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","सातालाव उस॰कताव छ्याम, नो मेंमार छकाल्‍न्‍या घग ज़ सोद नो सरजाम याजैव अतररास येसुए ओखादरदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","नक याकेसोत नो खादरलाई कसिउ घ्योःव लुँ पल्‍तैसिउ रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","नल यापसिक प्रभु येसुए ओमोरो मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","‘आव कै ओताव’ लिद यायुँ आँचा पाँचा ओताज़्‍याक ऩेब्‍लो बनै तक तकौ क्‍वा क्‍वाइसिउनी उमँःजानी याङ़ाक निच्‍याँःसिहुव यारारँःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","यारारँःव प़ाइँना बनै छे·द नामक याफुलुप्‍सिक, नो चाकर्‍यानी है यारादोकिनी, “जे जींदोलाई सिउराए पोल काराव जेखिम्‍हुज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","नो आल माले, सैंसिद सोधुके। जेस गालीलल उलिज़्‍याकाव है ओदाचिउ पाँर य़ाका दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘ङा मिँ मिन्‍सिउ पापीराए कुइत सूँपिनारिज़्‍यार। नोराए क्रुसत तङ्गैद यासैःनाव स़ोंलात ङासैंसिरिज़्‍या,’ है ओदाचिउ सैं माःक?” है निरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","नो मेंमाराए नो पाँ चेतैद, ");
INSERT INTO kjl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","खादरनी ओल्‍द बाद एघार जना उसिसर स़ोनो ओलस बाऱिज़्‍याव छुतरालाई ब नो पाँ भरी है यारादोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","नो पाँ सथैज़्‍याव मेंमार तोबो मरियम मग्‍दलिनी, तोबो योअन्‍ना स़ोनो तोबो याकूबए ओआमा मरियम याल्‍यो। यास बाव छुत मेंमाराए ब येसुए ओसाचीरालाई है यारादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","नोराए नो पाँ याथैक ओअर्थ माल्‍यो मिताव थ·रैद मारापतिकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","पत्रुस ते थर च्‍याँःसिद खादरदा धोंःनाद, खादरल घोम लिद उचिऊक येसुलाई लुम्‍बैसिउ क्‍वार वाज़ रँःक्‍यो। नलाव ताव भरी उयुँल खामिद ओल्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","हो छ्याम ज़ फरी ऩेब्‍लो ओलस बाऱिज़्‍यावनी यरूसलेमनी एघार किलोमितरवा तादाङ लिज़्‍याव इम्‍माउस यादोज़्‍याव नाखारदा निबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","निबाज़्‍याक ताव पाँ भरी नी नील निपाँनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","नोनी पाँए पाँए निबाज़्‍याक येसु कातानी हुद नीस नीस ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","येसुए नोनिलाई ओललाई मासरेस्‍न्‍या जैद उनिनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","हाःत ज़ येसुए, “जिन काता जिन्‍पाँहुज़्‍याव?” है उनिदोक ते, नोनी च्‍याँःसिद निङाः चुम चुमो जैद, ");
INSERT INTO kjl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","क्‍लेओपास यादोज़्‍यावए, “यरूसलेमल बाव भरिरानी नलाव आछिम पराःती ताव पाँ मासैंज़्‍याव नँ वाज़ नलिज़्‍याव सा,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","येसुए, “यरूसलेमल किताव पाँ ओताव?” है उनिदोक ते, नोनी, “नासरतलाव येसु यादोज़्‍याव तोबो मिँ ओल्‍यो। नो अगमबक्ता ओतावए परमेस्‍वर स़ोनो मिँराए ङ़ाक सक्तीलाव य़ेन दाद चावस ओरापैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","नोलाई मुख्‍या पुजारीर स़ोनो गेघेप्‍पाराए सिन्‍या सजाल सूँपिद क्रुसत तङ्गैद सैःकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","गे ते इस्राएलीरालाई बाँचैना हुव ज़ ताखेहो है ची गेल्‍यो। नो पाँर ओताव आख ते स़ोंला ताधुके। ");
INSERT INTO kjl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","हैदी ब गेसकाव ख्‍वा ख्‍वा मेंमाराए अचम्‍बलाव पाँ ज़ है दासिकेर। नोर आछ्या छकाल्‍न्‍या घग ज़ येसुए ओखादरक याबाक, ");
INSERT INTO kjl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","येसुए ओमोरो खादरल ओमालिज़्‍याव दी। नक परमेस्‍वरए ओचाकर्‍यानिलाई ब यारारँःकेर दी। नोनी फरी ‘येसु जींदो ज़ लिज़्‍या’ है ब यारादोकिनी दी। ");
INSERT INTO kjl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","है जैद गेसकाव तोबो ऩेब्‍लोए नो खादरक याबाक नो मेंमाराए है यालिज़्‍याव मिताव ज़ ताके। खाली येसुलाई ते मारँःकेर,” है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","हाःत ज़ येसुए, “जे अधमर, अगमबक्ताराए यासरो पाँ खर्क जेतीधुरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","नल, ‘ख्रीसए दुखर सहिद वाज़ बल्‍ल ज़गै मगैव ओराज्‍या दैरिज़्‍याव’ लिन्‍या सर्सिउ लिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","मोसाए ओसरोकिन अगमबक्ताराए यासरो पैकाव ओल उजूँनी धर्मसास्‍त्रलाव सर्सिउ पाँर पलास्‍द निएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","हाःत ज़ नो नाखार याकेस्‍हुवत येसु नोनिकिन जाँ ङ़ादा बाव ओपैंज़्‍याव मिताव ओजैसिक, ");
INSERT INTO kjl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","नोनी घलैद है दोकिनी, “नम झ्यानाके। आछिम गिनस ज़ लिन्‍के,” है निदोक ते, भैंःद नीस ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","नोनिस ज़्‍यान्‍याए जूँनी च़ुसिद, भरेस उकुइत रैद, असिक ऩिद, केःद निएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","उनियो प़ाइँना ज़ ‘आव ते येसु ची ओल्‍यो’ लिद सरेस्‍किनी। हाःत ज़ येसु ब नक ज़ सम़ैसिके। ");
INSERT INTO kjl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","नोनी फरी नी नील है लिकिनी, “येसु गिनस ज़ ओल्‍योए ची ओल्‍यो, नो येमत गिन्‍हुज़्‍याकाव धर्मसास्‍त्रलाव पाँर पलास्‍द ओयासिन्‍क गिनयुँर हाः होलाँ ओताव,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","हतप्‍त ज़ च्‍याँःसिद यरूसलेमदा ओल्‍द बाद एघार जना उसिसर छुत यानैंरास दुप्‍सिद यालिज़्‍याव निरादैनाक, ");
INSERT INTO kjl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","नोनी निपाँ निमापाँद ज़ नोराए, “साचो ज़ ओल्‍यो, गेप्रभु जींदो ज़ उलिज़्‍याव ओल्‍यो। सिमोनए ओङ़ाक ब सरैंःसिके,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","फरी नोनी ब नो येमताव पाँ भरी है दाद, “भरेस केःद ओभाःव प़ाइँना ज़ गिन्‍सरेस्‍के,” है यारादोकिनी। ");
INSERT INTO kjl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","निताव यापाँज़्‍यावत ज़ येसु उमँःजानी ज़ याखार्ल च्‍याँःसिहुद नोरालाई, “जेयुँर होलाँ ओताक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","नो यारँःव प़ाइँना तखँङरी छे·द, ‘आव ते झ़्या ची सा’ है लिद बनै याछे·ज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","येसुए, “जे कै जैद ‘हो ज़’ लिद जेयुँ माहुप्‍द जेछ्याचेए जेयुँर भुतु भुतु जेजैज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","आव ते ङा ज़ ची, ङाखँ ङाकुइताव घाइर चिऊद सरेस्‍नाचिके। जे है जेलिज़्‍याव मिताव झ़्या ङाताकिन ते ङास्‍या ङाऱूसर मालिखेहो। जेयुँ ओमाहुप्‍किन छाप्‍नाचिके,” ");
INSERT INTO kjl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","है दाद उखँ उकुइर सतैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","निताव रँःद बनै अचम्ब ताद यारेंतए, ‘आव गेमँच्‍यानी गेरँःज़्‍याव सैं साचो गेरँःज़्‍याव ओताव’ है यालिज़्‍याक, येसुए, “जेस ज़्‍यान्‍यार मालिज़्‍या?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","हिप्‍सिउ ङाँः तगेंदा याएक ते, ");
INSERT INTO kjl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","प़ाइँए याङ़ाक ज़ कैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","नकिन येसुए, “ङा जेस ङालिज़्‍याकाव मोसाए ओकानुनल, अगमबक्ताराए यासरोल स़ोनो भजन पोस्‍तोकोल ब ङा ङाजूँनी सर्सिउ भरी जुनी ब ङाक्‍याँत यो·व ज़ परिके लिद है दाव ज़ ङानैचिज़्‍याव,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","धर्मसास्‍त्रलाव सर्सिउ पाँए ओअर्थ भरी पलास्‍द्याद, ");
INSERT INTO kjl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“धर्मसास्‍त्रल ब ‘ख्रीस दुखर सहिद उसिउ स़ोंलात सैंसिरिज़्‍या’ लिद सर्सिउ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","स़ोनो यरूसलेमनी सुरू जैद प़ाइँ जातलाव मिँराए ल्‍योङ बाद, ‘जेयुँ परमेस्‍वरए ल्‍योदा फर्कैचिकेदा, जेपाप भरी ख्रीसए उमिननी क्‍याल्‍सिरिज़्‍या,’ है लिद प़ाइँदा ज़ यारासथैनाचिके। ");
INSERT INTO kjl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","जे आव पाँत ङासाचीर ताद जेले। ");
INSERT INTO kjl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","है जैद ङा ङाबाबुए ओय़ाकालाव छैंव पुरूस परींद ङायाचिरिज़्‍या। खाली जे नोए ल्‍योनिकाव सक्तीर जेमादैवा पै यरूसलेमल ज़ लिच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","नकिन येसुए नोरालाई बेथानिया नाखारक पै ओलस ओलस ज़ लाँद उकुइर रा·द नोरालाई असिक याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","नो असिक ओराएज़्‍याक ज़ नोराए ल्‍योनी छींसिद स्‍वर्गदा बाके। ");
INSERT INTO kjl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","नोराए उमिनर बनै सघ्‍योःद्याद रेंए रेंए यरूसलेमदा ओल्‍द बाद, ");
INSERT INTO kjl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","दिनकाव ज़ ध्‍यान झ़िमल परमेस्‍वरए उमिन सघ्‍योःद्याव ज़ नैकेर।");
INSERT INTO kjl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","भाःङ पाँ उलिज़्‍याव ज़। नो पाँ परमेस्‍वरस उलिज़्‍याव। नो पाँ ओल परमेस्‍वर ज़। ");
INSERT INTO kjl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","नो ङ़ादाकिन ज़ परमेस्‍वरस उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ताव भरी ब नो पाँनी ज़ ताहुकेर। नो पाँनी माताहुव काता ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","नो पाँनी ज़ पोहोन ब ताके। नो पोहोन ज़ मिँरालाई पलाँ जैद्यान्‍या ज़गै ब ताके। ");
INSERT INTO kjl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","नो ज़गैए चुम चुमोल पलाँ जैज़्‍याव। नो ज़गैलाई चुम चुमोए माहातैधुव। ");
INSERT INTO kjl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","तछा परमेस्‍वरए उपरींव यूहन्‍ना यादोज़्‍याव मिँ तोबो हुके। ");
INSERT INTO kjl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","नो मिँ परमेस्‍वरनी हुव ज़गैवलाई प़ाइँए सरेस्‍द यायुँ घुहुप्‍क लिद साचीए जूँनी हुके। ");
INSERT INTO kjl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ओल ते नो ज़गै माःक, ज़गैवलाई मिँरालाई सरेसो परींन्‍याए जूँनी उहुव ची। ");
INSERT INTO kjl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","नो ज़गै साचो ज़गै ज़ ओल्‍यो। नो आव मानुवात हुद प़ाइँ मिँरालाई पलाँ जैद याएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","नो मानुवात हुवए ज़ आव नाम नम जैक्‍यो। हितावत ब आव मानुवाताव मिँराए ओललाई मासरेस्‍धुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ओल नो उमींराए याल्‍योक ज़ हुके। खाली नोराए झन मासुम्‍केर। ");
INSERT INTO kjl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","हैदी मनी जो जोराए ओपाँर भैंःद यायुँ हुप्‍ज़्‍या, हो होरालाई परमेस्‍वरए ओज़ार तान्‍या हक याएज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","नोर परमेस्‍वरए ओज़ार याताव संसारलाव बाबु आमानी ब माःक, क्‍याँए ओपैंज़्यावनी ब माःक, मिँए गोहाईनी ब माःक, परमेस्‍वरनी वाज़ ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","नो पाँ ज़ मिँ मिन्‍सिद गेल्‍योक हुके। ओबाबुनी हुव तोबोका तोबो ओज़ाए ओज़गै गेरँःके। नत ज़ परमेस्‍वरए ओसत स़ोनो गेल्‍योदा उयुँ ओय़ालो ब रैंःके। ");
INSERT INTO kjl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","नोए उजूँनी यूहन्‍नाए चोइस क़िद, “आवए उजूँनी ज़ जेलाई ङ़ादाकिन है ङादाचिज़्‍याव, ‘ङाछींनी हुव ङाकिन घ्योःव लिज़्‍या, काराव ल्‍यो ताकिन नो ङाकिन ङ़ादाकिन ज़ उलिज़्‍याव,’ ” है लिद गोहाई याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","होए ओक्‍याँनी ज़ गे परमेस्‍वरए उयुँलाव भरी दैद असिकए तर्त असिक गेदैके। ");
INSERT INTO kjl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ङ़ादा मोसाए ल्‍योनी परमेस्‍वरए ओकानुन गेदैके, आज्‍याल फरी परमेस्‍वरए उयुँ ओय़ालो स़ोनो साचो ओपाँ येसु ख्रीसनी गेदैके। ");
INSERT INTO kjl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेस्‍वरलाई खर्क ज़ सुए ज़ मारँःर, ओबाबुए उयुँ स्‍याताव तोबोका तोबो ओज़ाए ओक्‍याँत ज़ सतैंसिउ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यरूसलेम सहरनिकाव यहूदीराए यासकाव पुजारीर स़ोनो लेबीरालाई यूहन्‍नालाई, “नँ सु?” है दानाव यारापरींक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","यूहन्‍नाए माम़ोंसिद, “परमेस्‍वरए उपरींज़्‍याव ख्रीस ङा माःक,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“हुकी नँ सुकी, सैं एलिया रो?” है यादोक ते, “अहँ, ङा हो माःक,” है यादोक्‍यो। “हुकी नँ नो परमेस्‍वरए ‘अगमबक्ता तोबो ङापरींरिज़्या’ है उलिज़्याव मिँ रो?” है यादोक ते, फरी ब, “ङा हो ब माःक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“हुकी नँ ज़ गेलाई है दाव ताके, नँ सु? गेलाई परींज़्‍यावरालाई नजूँनी गे है दाव ज़ परिके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्‍नाए, “ङा यसैया अगमबक्ताए सर्द ओनैज़्याव मिँ ज़। नोए ङाजूँनी ओसरो आव ज़ — ‘तोबोए ओर्गा बनल अइ लिद उक़िज़्याव थास्‍रिज़्या, हुरिज़्याव प्रभुए ओयेम गाँत्‍या गुँतीलाई सदाँचिके,’ ” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","नो पजैना हुवर फरिसीराए यारापरींवर याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","नोराए फरी ब यूहन्‍नालाई, “नँ ख्रीस ब माःक, एलिया ब माःक, नो अगमबक्ता ब माःक ताकिन, नँ काराव मिँरालाई ऱील नरासछैंज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्‍नाए, “ङा ते ऱील ङारासछैंज़्‍या, खाली जेखार्ल ज़ तोबो लिज़्‍या, होलाई जे जेमासरेसे। ");
INSERT INTO kjl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","नो ज़ ङाछींनी हुरिज़्‍या है ङालिज़्‍याव मिँ। ङा ते नोए ओपोलाए ओच़ें पला·न्‍या स्‍यासो ब ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","आव पाँ भरी यूहन्‍नाए ओरासछैंज़्‍याव यर्दन भै होफताव बेथानिया यादोज़्‍याव पोल ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","हो पराःती येसु ओल्‍योदा उहुज़्‍याव रँःद यूहन्‍नाए प़ाइँलाई है यादोक्‍यो, “चिऊचिके, नो ज़ आव मानुवातावराए यापाप हाइद ख्याद्याज़्‍याव परमेस्‍वरए ओपाथा। ");
INSERT INTO kjl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","नोए उजूँनी ज़ ङ़ादाकिन है ङादाचिज़्‍याव, ‘ङाछींनी तोबो हुरिज़्‍या। नो ङाकिन ङ़ादा ज़ उलिज़्‍यावए ङाकिन घ्‍योःव लिज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","नोलाई ङा मनी ङामासरेस्‍ताव। हितावत मनी नोलाई इस्राएलीराए खार्नी पले·द सतैंद्यान्‍याए जूँनी ऱील ङारासछैंज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","यूहन्‍नाए नोरालाई अइ लिद गोहाई याएक्‍यो, “ङा परमेस्‍वरए उपुरूस कुइतम मिताव नमतिन भुर्हुद ओक्‍याँत उच़ुसिज़्याव ङारँःके। ");
INSERT INTO kjl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","नोलाई ङानी ते ङामासरेस्‍ताव, खाली ङालाई ऱीनी सछैंव परींज़्‍यावए है दाँक्‍यो, ‘जोए ओक्‍याँत परमेस्‍वरए उपुरूस हुद उच़ुसिउ नरँःज़्‍या, होए ज़ परमेस्‍वरए छैंव उपुरूसनी मिँरालाई यासछैंरिज़्‍याव।’ ");
INSERT INTO kjl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","है जैद आव ङामीए ङारँःवनी ज़ जेलाई आव ज़ परमेस्‍वरए ओज़ा लिद थ·रैद ङायाचिके।” ");
INSERT INTO kjl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","हो पराःती फरी यूहन्‍ना ऩेब्‍लो उसिसनिस हो पोक ज़ च्‍याँःसिद यालिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","यूहन्‍नाए येसुलाई याङ़ालाव घ्याँ ओबाज़्‍याव रँःद उसिसनिलाई, “चिऊचिन्‍के, नो ज़ परमेस्‍वरए ओपाथा,” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","नोनी नो पाँ थैद येसुए उछींत बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","येसु उछींदा ओभाल्‍सिक नोनिलाई उछीं उछीं निहुज़्‍याव रँःद, “जिन काता जिन्‍खिम्‍ज़्‍याव?” है उनिदोक ते, नोनी, “गुर्बा, नँ काङ्क नलिज़्‍याव?” है निदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","येसुए, “हुद चिऊचिन्‍के,” है निदोक्‍यो। नोनी उछीं उछीं बाद उलिज़्‍याव पोक ज़ बाद हो छ्याम ओलस ज़ लिकिनी। नो याकेसो ऱिमदाङाव चार बजेवाक ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","नो यूहन्‍नाए ओपाँ थैद येसुए उछींत बावनी तोबो सिमोन पत्रुसए ओभाइ अन्‍द्रियास ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","नो ननी बाद ओदाज्‍यु सिमोनस दैसिद, “गिन मसीहलाई गिन्‍दैके,” है दोक्‍यो। (हिब्रू खामनी मसीहए ओअर्थ ‘ख्रीस’।) ");
INSERT INTO kjl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","नकिन ओदाज्‍युलाई ब येसुए ल्‍योक लाँक्‍यो। येसुए नोलाई लँ लँ चिऊद, “नँ यूहन्‍नाए ओज़ा सिमोन ज़, आकिनी नमिन केफास नैद ङाईंज़्‍या,” है दोक्‍यो। (ग्रीक खामनी केफासए ओअर्थ ‘पहर’।) ");
INSERT INTO kjl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","हुकिन हो पराःती येसु गालीलदा बान्‍या युँ दाद होदा ओबाज़्‍याक फिलिपलाई रँःद, “नँ ङास हुन्‍के,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","नो फिलिप, अन्‍द्रियास स़ोनो पत्रुसनी निलिज़्‍याव बेथसेदा नाखारलाव मिँ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","नो फिलिपए फरी नथानेलस दैसिद नोलाई, “गे मोसाए ओकानुनल स़ोनो अगमबक्ताराए धर्मसास्‍त्रलाव सर्द यानैज़्‍याव मिँस गेदैसिके — नो ते योसेफए ओज़ा नासरतलाव येसु ची ओल्‍यो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","हाःत ज़ नथानेलए, “निताव नासरतनी सु ची चाव उहुरिज़्‍याव?” है ओदोक ते, फिलिपए, “नँ ज़ हुद चिऊके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","नथानेललाई ओल्‍योदा उहुज़्‍याव रँःद, येसुए नोए उजूँनी नक लिज़्‍यावरालाई, “चिऊचिके, नो साचो इस्राएली, ओखत माल्‍यो मिँ,” है ओरादोज़्‍याव ");
INSERT INTO kjl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नथानेलए थैद येसुलाई, “ङालाई कै जैद नसरेस्‍नाव?” है ओदोक ते, येसुए, “फिलिपए नँलाई ओमाखुल्‍निद नेभारा सीं खँक नलिज़्‍याक ज़ ङारँःनिउ,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","हाःत ज़ नथानेलए, “गुर्बा, नँ साचो ज़ परमेस्‍वरए ओज़ा, इस्राएलीराए राजा ज़ नल्‍यो,” लिद है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","येसुए, “काता नेभारा सीं खँक ङारँःनिउ है ङादींवए, ङालाई नयुँ उहुबो रो? साचो ज़ छींनी आवकिन घ्योःव घ्योःव ङाय़ेनर ब रँःन्‍या नले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फरी प़ाइँलाई है यादोक्‍यो, “ङा जेलाई साचो है ङादाचिज़्‍या, जे तछा नम फैसिउ स़ोनो ननी परमेस्‍वरए ओचाकर्‍यार ङा मिँ मिन्‍सिउए ङाल्‍योक हुव य़ेन बाव य़ेन यादोज़्‍याव रँःन्‍या जेले।” ");
INSERT INTO kjl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","गालीलल याहुव स़ोंलात काना यादोज़्‍याव नाखारल तोबो बिह्‍या ओल्‍यो। येसुए ओआमा ब नक ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","येसुलाई ब उसिसरास नो बिह्‍यालाव भत्‍यारल याराखुल्‍केर। ");
INSERT INTO kjl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","नो बिह्‍याल याओज़्‍याव दाखमद्य ओखेमोत येसुए ओआमाए येसुलाई, “नलाव याओज़्‍याव दाखमद्य खेम्‍द ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","येसुए ओआमालाई, “अ माँ, आव य़ेनत ङालाई है तादाँयो, ङाबेला माताताए,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","नकिन येसुए ओआमाए नक लिज़्‍याव नोकोररालाई, “येसुए जो है दाचिज़्‍याव, हो ज़ दोच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","हाः बेलाक नल यहूदीराए याचलन मिताव चोखोइसिन्‍या ऱी नैन्‍या दस पन्‍ध्र सेमे बाज़्‍याव लुँए घागरीर छ गोता यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","येसुए नलाव य़ेन दाज़्‍यावरालाई, “आव घागरी भरिल ऱी तसी तसी जैचिके,” है ओरादोव प़ाइँना नोराए घागरी भरी यारासब्‍याल्‍केर। ");
INSERT INTO kjl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","हाःत ज़, “आव ऱी आनी तुपुरू क्‍यो·द भत्‍यारलाव य़ेन चलैज़्‍यावलाई लाँदिचिके,” है ओरादोक ते, नोराए लाँदिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","नो य़ेन चलैज़्‍यावए नो दाखमद्य जैसिउ ऱी ओदारक, आः ङमो दाखमद्य कातानी ओताव लिन्‍या मासैंक्‍यो। नो ताव ऱी गप्‍ज़्‍यावराए वाज़ यासैंज़्‍याव। है जैद नो य़ेन चलैज़्‍यावए ब्‍याहोल्‍यालाई खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“उपुर्कावराए ते चाव दाखमद्य भरी ङ़ादा ज़ भाःज़्‍यार, ओपाहुनाराए कुधु याओवत वाज़ जाँ छ्यावाकाव याराएज़्‍यार। नँ ते प़ाइँरानी चाव छींङ पै साँचिद ननैज़्‍याव ओल्‍यो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","येसुए आव प़ाइँरानी उस॰कताव ओसरेस गालीललाव काना नाखारल सतैंक्‍यो। निताव अचम्‍बलाव ओसक्तीर रँःद उसिसराए येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","नकिन येसु ओआमा, ओभाइ स़ोनो उसिसरास कफर्नहुम सहरल बाद जाँवा पै लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","नाः बेलाक यहूदीराए निस्‍तार पर्ब हुनाद उलिज़्‍याव। नोए उजूँनी येसु यरूसलेमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","यरूसलेमलाव ध्‍यान झ़िमल मिँराए घेंर, बेधार, परिवार यो·व ज़ यारानैज़्‍याव स़ोनो पैसा त़ोज़्‍यावर ब नल च़ुसिद यालिज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","येसुए उकुइत तोबो च़ें रैद कोर्रा जैद नो ध्‍यान झ़िमलाव लँःज़्‍यावर यो·ज़्‍यावरालाई रीःद याबेधा याघेंरास यापले·क्‍यो। पैसा त़ोज़्‍यावराए यातेबलर पल्‍तैद्याद यापैसार सोभोद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","परिवा यो·ज़्‍यावरालाई, “जे जेसमानरास आनी पुलुस्‍द बाचिके। आव ङाबाबुए उझ़िमलाई काराव जे पसल जेजैज़्‍याव?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","हाःत ज़ उसिसराए नो धर्मसास्‍त्रलाव सर्सिउ पाँलाई चेतैकेर। नलाव सर्सिउ आव ज़, “अ परमेस्‍वर, नझ़िमए जूँनी ङादोज़्‍याव ध्‍यावनाए ङायुँल मेंः माँःती चाँःज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","नाःत ज़ यहूदीराए यास़ेरराए येसुलाई, “नँ इताव य़ेन दान्‍या परमेस्‍वरनी नदैव ताकिन गेलाई तोबो सरेस सतैंद्याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","येसुए, “जे आव ध्‍यान झ़िमलाई तैःचिकेदा, ङा स़ोंलात सोचोइन्‍या ङाले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","नोराए, “आव ध्‍यान झ़िमलाई छयालीस बर्सत गेजैके, कै जैद नँ स़ोंलात नसोचोइधुरिज़्‍याव?” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","खाली नो ध्‍यान झ़िम ते येसुए ओल ओक्‍याँए उजूँनी है ओरादोव ची। ");
INSERT INTO kjl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","येसु सिउनी ओसोवत वाज़ उसिसराए नो है ओरादोव भरी य़ाका दोकेर। ननी ज़ नो धर्मसास्‍त्रलाव सर्सिउ पाँ स़ोनो येसुए ओपाँव पाँ भरी थ·रैद पतिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","निस्‍तार पर्ब उहुवत येसु यरूसलेमल उलिज़्‍याक, अचम्‍बलाव ओदोव य़ेनर रँःद नलाव मिँर कुधुए येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","हैदी ब ओल येसुए मिँराए यायुँलाव पाँ भरी ओसैंज़्‍यावए नोराए याभर मादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","सुए ज़ येसुलाई ‘आव मिँ इताव लिज़्‍या’ है दाव ओमापरिज़्‍याव, ओल ज़ प़ाइँए युँलाव पाँ ओसैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","यहूदीराए घ्योःव याकचरीलाव निकोदेमस यादोज़्‍याव फरिसी तोबो उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","नो मिँ रील अलगज़ा येसुए ल्‍योक हुद, “गुर्बा, नँ परमेस्‍वरए ल्‍योनी गे मिँरालाई परमेस्‍वरए ओपाँ पैना हुव ज़ लिन्‍या गेसैंज़्‍या। नँस परमेस्‍वर ओमाल्‍यो ताकिन नँ निताव य़ेनर कातानी नदोधुरिज़्‍याव,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","येसुए, “नँलाई साचो है ङादींज़्‍या, मिँ साःरोल ओमाजर्मिवा पै परमेस्‍वरए ओराज्‍या मारँःधुव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","निकोदेमसए फरी, “मिँ सेर्द कै जैद फरी उजर्मिज़्याव? सैं फरी ओआमाए उफूल पसिद उजर्मिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","येसुए, “फरी साचो है ङादींज़्‍या, जो मिँ ऱीनी स़ोनो परमेस्‍वरए उपुरूसनी माजर्मिए, नो मिँ परमेस्‍वरए ओराज्‍याल मापसिधुइ। ");
INSERT INTO kjl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","है जैद मिँनी जर्मिज़्‍याव मिँ ज़ ताज़्‍या, परमेस्‍वरए उपुरूसनी जर्मिज़्‍याव परमेस्‍वरए उमीं ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ङा नँलाई, ‘साःरोल जर्मिउ ताके,’ है ङादींवनी अचम्‍ब तातानी। ");
INSERT INTO kjl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","बतास मनी जोदा बान्‍या उयुँ लिज़्‍या, होदा ज़ बाज़्‍या। नोए ओर्गा ते थास्‍ज़्‍या, खाली कातानी उहुज़्‍याव, काना ओबाज़्‍याव लिन्‍या सुए ज़ मासैंर। परमेस्‍वरए उपुरूसनी जर्मिज़्‍यावर ब हितावर ज़ ताज़्‍यार,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","हाःत ज़ निकोदेमसए, “आव नपाँज़्‍याव कै जैद ओताज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","येसुए, “नँ इस्राएलीराए यागुर्बा ताद ब नाः कै जैद नमासैंज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ङा नँलाई साचो है ङादींज़्‍या, गे जो गेसैंज़्‍या हो ज़ गेपाँज़्‍या, जो गेरँःज़्‍या हो ज़ गेरासथैज़्‍या। खाली ङा ङासैंव ङारँःव भरी है ङादाचिक जे जेमापतिनाए। ");
INSERT INTO kjl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","आव मानुवाताव पाँ है ङादाचिक जेमापतिनाकिन, स्‍वर्गताव पाँर है ङादाचिक झन कातानी जेपतिरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","स्‍वर्गनी हुव ङा मिँ मिन्‍सिउकिन आव मानुवानी स्‍वर्गत बाव सु ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","किताव मोसाए बनल पितले घुल जैद तङ्गैद ओरायो, हिताव ज़ ङा मिँ मिन्‍सिउ ब तङ्गैसिउ परिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","है जैद जो जोराए ङालाई यायुँ हुप्‍ज़्या, हो होराए अजम्‍बरी जुनी दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“परमेस्‍वरए आव मानुवाताव मिँरालाई उयुँ नाद तोबोका तोबो ओज़ा ब याएक्‍यो। है जैद जोए नो ओज़ालाई उयुँ हुप्‍ज़्‍या, नो कै मै माताद अजम्‍बरी जुनी दैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेस्‍वरए ओज़ालाई मानुवाताव मिँरालाई खेम्‍न्‍याए जूँनी उपरींव माःक, बुरू मानुवाताव मिँरालाई बाँचैन्‍याए जूँनी उपरींव ची। ");
INSERT INTO kjl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","है जैद जोए ओज़ालाई उयुँ हुप्‍ज़्‍या, होए परमेस्‍वरए ओसजा दैन्‍या माले। फरी जोए परमेस्‍वरए ओज़ालाई उयुँ माहुबे, होए तोबोका तोबो परमेस्‍वरए ओज़ालाई उयुँ ओमाहुबोए ज़ परमेस्‍वरनिकाव सजाल परिधुके। ");
INSERT INTO kjl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","परमेस्‍वरए मिँरालाई ओराफाल्‍ज़्‍याव आनी ज़ तारिज़्‍या — आव मानुवाल ओज़ाए ओक्‍याँत ज़गै जैद नैव। मिँर ते झन याय़ेन माचाव ओतावए नो ज़गैलाई देखा चुम चुमोलाई यामन लागिके। ");
INSERT INTO kjl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","जोए माचाव य़ेन दोज़्‍याव, होए ज़गैवलाई सोद ‘ङापाहा बाया’ लिद ओछ्याचेए ज़गैवदा माहुइ। ");
INSERT INTO kjl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","फरी जोए साचो य़ेन दोज़्‍याव, होए ‘ङाय़ेन भरी परमेस्‍वरनी ज़ ताव घरैंःक’ लिद ज़गैवदा हुज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","आव भरी ओतावत येसु उसिसरास यहूदिया खन्‍दल बाद नोरास जाँवा पै नल ज़ लिद नलाव मिँरालाई ब ऱील यासछैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्‍नाए मनी सालीम छ्योकाव एनोन यादोज़्‍याव पोक ओरासछैंज़्‍याव, काराव ल्यो ताकिन नक ऱी सर्बा ज़ उलिज़्याव। मिँर ओल्‍योक हुद ऱील यासछैंसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","हाःक पै यूहन्‍नालाई झ्‍यालखानाल यामाझाःताव। ");
INSERT INTO kjl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","नो बेलाक ज़ यूहन्‍नाए उसिसर तोबो यहूदीस सछैंसिन्‍याए जूँनी याखर्लेसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","नोर यूहन्‍नाए ल्‍योक हुद, “गुर्बा, यर्दन भै होफताव नँस लिज़्‍याव सतैंद नयासिउ मिँए ब ऱील यासछैंज़्‍याव। झन प़ाइँ होए ओल्‍योक ज़ बाज़्‍यार,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्‍नाए, “परमेस्‍वरए ओमाएकिन सुए ज़ काता ज़ मादैधुव। ");
INSERT INTO kjl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","नोए उजूँनी ङापाँव पाँ जे ब थैद जेनै। हाःक ज़, ‘ङा ख्रीस माःक, ङा ते होए ओङ़ा ओङ़ा परींसिउ मिँ,’ है ङादाचिउ ची। ");
INSERT INTO kjl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","किताव बिह्‍याल ल़ुज़ालाई लाँज़्‍याव ब्‍याहोल्‍या ताज़्‍या, स़ोनो ब्‍याहोल्‍याए ओलाप्‍क च्‍याँःसिज़्‍यावए ओनैं ब्‍याहोल्‍याए ओर्गा थैद रेंज़्‍या, हिताव ज़ ङा मनी आव पाँर थैद ङायुँ होलाँ ताज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ओल झन यादा ज़ तानाव परिज़्‍या, ङा ते मेदा ज़ तानाव परिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“रूतिन हुव प़ाइँए तर्ताव ज़ ताज़्‍या। आव मानुवाताव मिँर ते मानुवानी ज़ ताद मानुवाताव पाँ ज़ दोज़्‍यार। स्‍वर्गनी हुव प़ाइँए ङ़ैताव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","नोए स्‍वर्गताव ओथैव उरँःव भरी प़ाइँलाई ज़ ओरासथैक ओपाँ सुए ज़ मापतिर। ");
INSERT INTO kjl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ओपाँ भैंःज़्‍यावर ते परमेस्‍वर साचो ज़ लिज़्‍या लिद यासही छाप याझाःव मिताव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काराव ल्‍यो ताकिन परमेस्‍वरए उपरींव मिँ परमेस्‍वरए ओपाँ वाज़ पाँज़्‍या। नोए ओक्‍याँत परमेस्‍वरए ओल उपुरूस मागोइँद धोल पोगोल ज़ थुदिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","है जैद स्‍वर्गताव ओबाबुए ओज़ालाई मया दाद प़ाइँ उकुइत ज़ याद नैव। ");
INSERT INTO kjl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो जोराए ओज़ालाई यायुँ हुप्‍ज़्‍या, नोर अजम्‍बरी जुनी दैन्‍यार ताज़्‍यार। फरी जो जोराए ओज़ाए ओपाँ माभैंःर, नोराए अजम्‍बरी जुनी दैन्‍या मालेर, झन परमेस्‍वरए उरिस चोवर ताज़्यार,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ऱील सछैंज़्‍याव यूहन्‍नाकिन येसुए मिँर कुधु ओल्‍योदा जैद ऱील यासछैंज़्‍याव दी लिन्‍या फरिसीराए थैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","हैदी ब सछैंज़्‍याव ओल येसुए ते माःक, उसिसराए ची। ");
INSERT INTO kjl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","है जैद येसुए निताव पाँ सैंद यहूदियालाई ऱास्‍द ङ़ादाङाव उलिज़्‍याव गालीलदा ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","नदा बान्‍या सामरिया खन्‍दलाव घ्याँ बाव उपरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","नलाव घ्याँ ओबाज़्‍याक सामरियालाव तोबो सुखार यादोज़्‍याव नाखारल हुके। नो नाखार याकूबए ओज़ा योसेफलाई ओयो पो छ्योक उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","नक याकूबए ओघोव कुवा ब उलिज़्‍याव। है जैद येसु बाद बाद बनै उथलिउए अधमर लावाक नो कुवाक ऩासिके। ");
INSERT INTO kjl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","हाःत ज़ सामरियालाव तोबो मेंमा ऱी गप्‍ना हुके। येसुए नोलाई, “ङालाई ऱी तुपुरू ओन्‍या याव ताके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","नो बेलाक उसिसर नाखार जीदा ज़्‍यान्‍यार लँःना बाद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","नो मेंमाए येसुलाई, “नँ यहूदी ताद कै जैद ङा सामरी मेंमाए ङाकुइताव ऱी ओव नपैंज़्‍याव?” है दोक्‍यो। हाः बेलाक यहूदीर सामरीरास काता सर्‍यो ज़ यामानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","येसुए नोलाई, “परमेस्‍वरए नँलाई याव ओपैंज़्‍याव ब नमासैंए, नँस ऱी ऩिज़्‍यावलाई ब नमासरेसे। होलाई नसरेसो ताकिन नँ ची होस ऩिन्‍या नल्‍यो। होए नँलाई जींदो ऱी यान्‍या ओल्‍यो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","नो मेंमाए, “प्रभु, नँस ऱी गप्‍न्‍या जा ब माले, कुवा ब बनै पतालल लिज़्‍या। कातानी नो जींदो ऱी नयाँरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","आव कुवा ते गेपुर्खा याकूबए ओघोव ची। आव कुवानी ज़ ओज़ार स़ोनो ओहार बेधाराए ऱी याओज़्‍याव। काता नँ याकूबकिन ब घ्योःव नलिज़्‍याव रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","येसुए, “आव कुवानी ऱी ओज़्‍याव फरी ब छोस्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ङा ङाराएज़्‍याव ऱी ओज़्‍यावर ते खर्क ज़ छोस्‍न्‍या मालेर। बुरू नो ऱी नोए ओक्‍याँत परीज़्याव ऱीमुल स्यासो तान्‍या ले। नोए ज़ अजम्‍बरी जुनील सकेस्‍न्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","नो मेंमाए, “हो ची ताकिन्‍दा प्रभु, ङालाई नो ऱी याव ताके। ङा फरी खर्क ज़ ऱी ब छोस्‍न्‍या ङामाले, गप्हुव ब परिन्‍या माले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","नकिन येसुए नोलाई, “नँ नझ़िमक बान्‍केदा, नरेलाई खुल्‍द रैके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","नो मेंमाए, “ङा ङारे ज़ माले,” है ओदोक ते, येसुए, “ ‘ङारे माले’ है नलिज़्‍याव ते साचो ज़। ");
INSERT INTO kjl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","नरेर पाँच जना ताधुकेर। आज्‍याल नँस लिज़्‍याव ब नरे माःक। नो नपाँ ते साचो ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","नो मेंमाए, “प्रभु, नँ ते अगमबक्ता ची नल्‍यो लिद ङासरेस्‍निके। ");
INSERT INTO kjl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","गे सामरीराए गेसाखा पुर्खाराए भाःकिन ज़ आव दाँदात पुजा दोहुकेर। जे यहूदीर ते ‘परमेस्‍वरए उपुजा यरूसलेमल वाज़ दान्‍या ताए’ है जेलिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","येसुए नोलाई, “अ माँ, ङालाई पतिनायो, तछा स्‍वर्गताव ङाबाबुए ओसेवा आव दाँदात स़ोनो यरूसलेमल वाज़ तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","जे सामरीराए परमेस्‍वरए ओसेवा मासैंद ज़ जेदोज़्‍या, गे ते सैंद ज़ गेदोज़्‍या। बाँचिन्‍या येम यहूदीराए ल्‍योनी वाज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","खाली तोबो बेला हुज़्‍या, नो हुद ब ले। नो बेलाक साचोस परमेस्‍वर बाबुए ओसेवा दोज़्‍यावर साचो युँनी ज़ दान्‍या लेर। परमेस्‍वर बाबुए ओसेवा दान्‍यार नितावर ज़ याखिम्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेस्‍वर ते पुरूस ज़। है जैद ओसेवा दोज़्‍यावराए साचो युँनी ज़ दोज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","हाःत ज़ नो मेंमाए, “ख्रीस यादोज़्‍याव मसीह हुरिज़्‍या लिन्‍या ङासैंज़्‍या। हो हुद आव पाँ भरी ओपो·स ज़ गेलाई पलास्‍द्यान्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","येसुए नोलाई, “नँस पाँज़्‍याव ङा हो ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","हाःत ज़ येसुए उसिसर नाखारनी केस्‍हुकेर। येसु तोबो मेंमास ओपाँज़्‍याव रँःद अचम्‍ब ताकेर। खाली येसुलाई, “काता नखिम्‍ज़्‍याव, काताए जूँनी जिन्पाँज़्‍याव?” सुए ज़ है मादोधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","हुकिन नो मेंमाए ओघागरीर ख्यानैद नाखारदा बाद नलाव मिँरालाई, ");
INSERT INTO kjl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“हुचिके, तोबो मिँलाई गेचिऊना। होए ङादोव य़ेन भरी ज़ है दाँक्‍यो। सैं ख्रीस नो ज़ ओताव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","नो नाखारलाव मिँर ननी पुलुस्‍द येसुए ल्‍योक बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","नो मिँर येसुए ल्‍योक यामाकेस्‍हुद ज़ उसिसराए, “गुर्बा, आव गेरैव ज़्‍यावर ज़्‍युके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","येसुए, “जे जेमासैंज़्‍याव ज़्‍यावर ङास ज़ लिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","उसिसर या याल, “सुवाराए ओललाई ज़्‍यावर रैद यायो सैं?” है यालिज़्‍याव थैद, ");
INSERT INTO kjl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","येसुए नोरालाई, “ङा ङाज़्‍याव ते ङालाई परींज़्‍यावए उयुँलाव मिताव य़ेन दाद, ओय़ेन सयो·न्‍या ची। ");
INSERT INTO kjl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","जे है जेलिज़्‍या, ‘एँःलाव गेझाःव धुर चार मैना छींनी वाज़ क्‍या·न्‍या ताज़्‍या।’ ङा ते है ङादाचिज़्‍या, एँःदा भाल्‍सिचिके, क्‍या·न्‍या बेला ताद ले। ");
INSERT INTO kjl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","आख मनी नो क्‍या·ज़्‍यावए ओजेला दैज़्‍याव, ओदोव य़ेन मनी अजम्‍बरी जुनी पै रहिन्‍या ले। है जैद वास्‍ज़्‍याव स़ोनो क्‍या·ज़्‍यावनी तछा सिप ज़ रेंन्‍या लिनी। ");
INSERT INTO kjl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","याझाःज़्याव आहाती साचो ज़ थ॰रिज़्‍या — ‘तोबोए वास्‍ज़्‍याव, तोबोए क्‍या·ज़्‍याव।’ ");
INSERT INTO kjl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","हिताव ज़ ङा मनी जेलाई जे काता ज़ जेमादोव पोल क्‍या·ना परींद ङानैचिए। छुतराए यादोव य़ेननी जेजुँ दैन्‍या जेले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","नो सामरी मेंमाए नो नाखारलाव मिँरालाई, “येसुए ङा ङादोव य़ेन भरी प़ाइँ ज़ पाँद्याँक्‍यो,” है ओरादोवए नलाव सामरीर कुधुए ज़ येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","है जैद येसुए ओल्‍योक हुद, “नँ गेस ज़ ल्‍यो ताके,” है यादोक ते, येसु यास ज़ ऩेला लिके। ");
INSERT INTO kjl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","नोर येसुए ओपाँ थैद झन कुधुए ज़ यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","नो मेंमालाई, “अब ते नँ नपाँ थैद वाज़ माःक, आव गेर्नाए ज़ ओपाँ थैद, ‘आव ज़ ओल्‍यो मानुवाताव मिँरालाई बाँचैना हुव ख्रीस’ लिन्‍या थ·रैद गेयुँ हुप्‍के” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","येसु नल ओल्‍यो ऩेला ओतावत ननी पुलुस्‍द गालीलदा बाके। ");
INSERT INTO kjl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ओल येसुए मनी है उलिज़्‍याव, “अगमबक्तालाई ओनाखारलाव मिँराए सुए ज़ ओमान नैद माएर।” ");
INSERT INTO kjl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","येसु गालीलल उहुवत नलावराए ओमान नैद्याद चावस नैकेर। नलावराए ङ़ादा यरूसलेमलाव पर्बत येसुए ओदोव य़ेन भरी रँःद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","येसु फरी गालीललाव काना यादोज़्‍याव नाखारल हुके। नल ज़ ङ़ादा ऱीलाई दाखमद्य ओजैव। नाः बेलाक ज़ राजाए तोबो ओकर्मचारीए ओज़ा कफर्नहुम सहरल ओजोरो उहुज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","है जैद नो कर्मचारीए, ‘येसु यहूदियानी गालीलल हुद ले दी’ लिन्‍या थैद, येसुए ल्‍योक बाद सिउ पैंज़्याव ओज़ालाई सगराँन्‍याए जूँनी ओलस लाँव ओपैंज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","येसुए नोलाई, “जे सरेसर स़ोनो अचम्‍बलाव य़ेनर जेमारँःवा जेमापतिए,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","नो कर्मचारीए, “प्रभु, ङाज़ा उस॰ ओमाफ्या·द तखेप हुद्याव ताके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","नाःत ज़ येसुए नोलाई, “बान्‍के, नज़ा गराँधुके,” है ओदोव प़ाइँना नो मिँ उयुँ हुप्‍द उझ़िमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","नो ओबाज़्‍याक ज़ ओनोकोरर झ़िमनी ओलस दैसिहुद, “नज़ा गराँधुके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","होए, “नो खा बेलाकिन ओगराँव?” है ओरादोक ते, “आझ्‍यो लाकाव एक बजेकिन ओजोरोए ऱास्‍क्‍यो,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","नाःत ज़ नो कर्मचारीए, “येसुए ङालाई ‘नज़ा गराँधुके’ है ओदाँव बेला ब नाःक ज़ ओल्‍यो,” लिन्‍या सैंक्‍यो। है जैद ओल स़ोनो उझ़िमलावरास येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","येसु यहूदियानी हुद गालीलल अचम्‍बलाव य़ेन ओदोव आवस ऩेखेप ताके। ");
INSERT INTO kjl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","नकिन यहूदीराए पर्ब तोबो उलिज़्‍याव। होए उजूँनी येसु ननी पुलुस्‍द यरूसलेमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूसलेम सहर बारिसिउ भार्नानी पुलुस्‍न्‍या तोबो ‘बेधा य़ाम’ उलिज़्‍याव। होए ओङ़ाक तोबो दह उलिज़्‍याव। नोलाई हिब्रू खामनी ‘बेथेस्‍दा’ है यादोज़्‍याव। नो दह घ्वाँगिल पाँच गोता छान्‍या झाःसिउ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","नल याजोरो हुवर, याखँ याकुइ सिउर, काना दूँदाराए ऱी खा बेलाक छल्‍किके लिद कींद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","नो दहल कैताक कैताक परमेस्‍वरए ओचाकर्‍या हुद ऱी ओचलैज़्‍याव। नो ऱी ओचलैव बेलाक जो ङ़ात नो दहल पसिज़्‍या, हो जो मिताव बेथा उलिदी ब ओगराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","नल अरतीस बर्स भरी ओजोरो हुव तोबो मिँ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","येसुए नोलाई घ्याँसिद उलिज़्‍याव रँःद, ‘आव ते कुधु बर्स ची ताके’ लिन्‍या सैंद नोलाई, “नँ सगराँसिउ नपैंज़्‍याव रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","नो ओजोरो हुवए, “प्रभु, सगराँसिउ ते ङापैंज़्‍या। खाली ऱी उछल्‍किक ङालाई दहल सुए ची झाःनाव केदा? ङा धो धो ङाबाज़्‍याक ज़ ङालाई बलेंद छुत पसिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","येसुए, “ङा नँलाई है ङादींज़्‍या, च्‍याँःसिद नतैंर सिम्‍द बान्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","बेहार ज़ नो मिँ गराँद ओतैंर सिम्‍द बाके। नो छ्याम ऩासिन्‍या छ्याम ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","है जैद यहूदीराए यास़ेरराए नो गराँवलाई रँःद, “आछिम ऩासिन्‍या छ्याम ची, नँ इताव गुर घुर्न्‍या माताए,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","नो गराँवए, “ङालाई सगराँज़्‍यावए ज़, ‘नतैंर सिम्‍द बान्‍के,’ है ओदाँव ची,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“नँलाई निताव है दाज़्‍याव सु?” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","खाली नो गराँव मिँए ओललाई सगराँज़्‍यावलाई ब ओमासरेस्‍ज़्‍याव। नो बेलाक मिँर बनै काला मुलु यातावए येसु ङ़ादा ज़ ननी पुलुस्‍द ओबाधुव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","छींनी येसुए नो गराँवलाई ध्‍यान झ़िमल रँःद, “नँ आख ते नगराँके, आकिनी फरी पाप तादोयो, म़ानी झन ज़ माचाव तान्‍या नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","नो मिँ झन ननी पुलुस्‍द बाद यहूदीराए यास़ेररालाई, “ङालाई सगराँव ते येसु ची ओल्‍यो,” है यादोनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","येसुए ऩासिन्‍या छ्याम मनी निताव य़ेन ओदोवए यहूदीराए यास़ेरर नाःकिन ज़ उखिरी पसिनाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","येसुए फरी नोरालाई, “ङाबाबुए आःपै ओय़ेन दाव ज़ नैज़्‍याव। है जैद ङा मनी ङादोज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","नो पाँ थैद नोर झन ज़ मचिद, “आवए ‘ऩासिन्‍या छ्याम य़ेन दान्‍या माताए’ लिन्‍या कानुनलाई वाज़ ओख्याव माःक, परमेस्‍वरलाई ज़ ‘ङाबाबु’ है लिद ओल मनी परमेस्‍वरस सम सम जैसिज़्‍या। आवलाई ते सैःव ज़ परिए,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","येसुए नोरालाई, “ङा जेलाई साचो है ङादाचिज़्‍या, ङा ओज़ाए ङाबाबुए ओदोज़्‍याव य़ेन ङामारँःवा पै ङानी काता ज़ ङामादोधुइ। ङाबाबुए जोनी दोज़्‍याव, ङा मनी हुनी वाज़ ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ङाबाबुए ङा ओज़ालाई मया दाँज़्‍याव। है जैद ओदोज़्‍याव य़ेन भरी ङालाई मनी सतैंद्याँज़्‍याव। जे आव जेरँःज़्यावकिन झन घेप्‍पा य़ेन सतैंद्यान्‍या ले। ननी झन ज़ अचम्‍ब तान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","किताव ङाबाबुए सिउरालाई सोचोइद जींदो याजैज़्‍याव, हिताव ज़ ङा मनी जोलाई ङायुँ लिज़्‍या होलाई अजम्‍बरी जुनील बान्‍या ङाजैज़्‍या ");
INSERT INTO kjl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","है जैद, ङाबाबुए सुए ओय़ेन ज़ माफालो, नो फाल्‍न्‍या भरी ङा ओज़ाए ङाकुइत ज़ याद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ननी ज़ किताव ङाबाबुए ओमान नैद याएज़्‍याव, हिताव ज़ ङा ओज़ाए ङामान ब प़ाइँए नैद्यान्‍या लेर। जोए ङामान नैद मायाँव, होए ङालाई परींज़्‍याव ङाबाबुए ओमान ब नैद मायो। ");
INSERT INTO kjl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ङा जेलाई साचो है ङादाचिज़्‍या, जोए ङापाँ थैद ङालाई परींज़्‍यावलाई उयुँ हुप्‍ज़्‍या, नोए अजम्‍बरी जुनी दैद सजाल परिन्‍या माले। नो मिँ सिउल गनिसिउनी पुलुस्‍द साःरो जुनी दैन्‍याल गनिसिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","फरी ब जेलाई साचो है ङादाचिज़्‍या, नो बेला हुज़्‍या, हुद मनी ले, जोए परमेस्‍वरए ओज़ाए ओर्गा ओथैकिन, नो मिँ सिउ उलिदी ब साःरोल सैंसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","किताव ङाबाबुए ल्‍योनी पोहोन ताज़्‍या, ङा ओज़ालाई मनी नो पोहोन यान्‍या जैद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","है जैद ङा ओलनी ज़ मिँ मिन्‍सिद ङाहुवए मिँरालाई फाल्‍न्‍या हक ब ङाकुइत ज़ याद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","आव ङापाँत अचम्‍ब ताताच्‍यो। तछा इताव बेला हुरिज़्‍या, खादरल लिज़्‍यावराए मनी ङा ओज़ाए ङार्गा थैद, ");
INSERT INTO kjl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","सैंसिद खादरनी पुलुस्‍न्‍या लेर। नोरानी चाव य़ेन दाव भरी अजम्‍बरी जुनील बान्‍या लेर, माचाव य़ेन दाव भरी सजाल बान्‍या लेर,” है ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ङा ङानी ते काता ज़ ङामादोधुइ। ङाबाबुए ल्‍योनी किताव ङाथैज़्‍या, हितावनी ज़ ङाफाल्‍ज़्‍या। नो ङाफाल्‍ज़्‍याव भरी न्‍यायस ङादोज़्या, काराव ल्‍यो ताकिन नो ङादोज़्‍याव ङा ङापैंज़्‍यावनी माःक, ङालाई परींज़्‍यावए ओपैंज़्‍याव मितावनी वाज़ ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ङाजूँनी ङा ज़ ङापाँकिन, नो पाँ साचो माथ॰रिए। ");
INSERT INTO kjl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ङाजूँनी पाँद ङालाई थ·रैद्याज़्‍याव छुत ज़ लिज़्‍या। होए ङाजूँनी पाँद ओयाँज़्‍याव भरी साचो थ॰रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","जे ऱील सछैंज़्‍याव यूहन्‍नाए ल्‍योक मिँर जेरापरींक मनी, नोए ब ङाजूँनी साचो थ॰रिउ पाँ ज़ पाँके। ");
INSERT INTO kjl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","हैदी ब मिँनी हुज़्‍याव पाँनी ते साचो ङामाथ॰रिए। अइज़ जे यूहन्‍नाए ओरायो गोहाई रैद बाँचिर सैं लिद होए उमिन तखेप ङाहाइज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्‍ना पलाँ जैज़्‍याव बत्ती स्‍यासो ओल्‍यो। जे नोए ओजैव पलाँवल जाँवा पै रेंद जेलिके। ");
INSERT INTO kjl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","खाली ङास लिज़्‍याव गोहाई यूहन्‍नाकिन ब घेप्‍पा लिज़्‍या। ङाबाबुए ङालाई दाव उपरींनाज़्‍याव य़ेन ङा ङादोज़्‍या, आव य़ेनरानी ज़ परमेस्‍वरए उपरींव ज़ ओल्‍यो लिद सरेस्‍नाज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ङालाई परींज़्‍याव ङाबाबुए मनी ङाजूँनी ओल ज़ पाँद याँज़्‍याव। जे होए ओर्गा ब जेमाथैताए, ओललाई ब जेमारँःताए। ");
INSERT INTO kjl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","जे ते झन परमेस्‍वरए ओपाँ ब जेयुँल जेमानैए, उपरींव ओज़ालाई ब जेयुँ माहुबे। ");
INSERT INTO kjl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","जे अजम्‍बरी जुनी दैन्‍याए जूँनी धर्मसास्‍त्रल खिमो ज़ जेनैज़्‍या। नो जेखिम्‍ज़्‍याव धर्मसास्‍त्रए ज़ ङाजूँनी गोहाई याचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","हितावत ब नो जुनीए उजूँनी ङाल्‍योदा हुव जेमाभैंःए। ");
INSERT INTO kjl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ङा मिँराए ल्‍योनी घेप्‍पा मिन ते ङामाखिमे। ");
INSERT INTO kjl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","खाली जे परमेस्‍वरए ल्‍योदा जेयुँ ज़ माले लिन्‍या ङासैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ङा ङाबाबुए उमिननी ज़ हुद ङाले, जे ते झन ङालाई जेसोनाज़्‍या। छुत सुवार या यामिननी याहुकिन होरालाई ते झन यामानर नैद्याद जेरासुम्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","जे तोबोका तोबो परमेस्‍वरए ल्‍योनिकाव दैन्‍या मान माखिम्‍द जे जेल मान खिम्‍ज़्‍यावराए कातानी ची परमेस्‍वरए उपरींवलाई जेयुँ उहुप्‍रिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","है जैद तछा परमेस्‍वर ङाबाबुए ओङ़ाक जेगल्‍ती थ·रैद्यान्‍या ङा पाँव मापरिए। जे जेखत पले·द्यान्‍या जेयुँ जेसुहुप्‍ज़्‍याव मोसा ज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","जे मोसाए ओपाँलाई साचो जेयुँ उहुप्ज़्‍याव ताकिन ङालाई मनी जेयुँ हुप्‍न्‍या ओल्‍यो। होए ङा ङाजूँनी ज़ सर्द ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","खाली जे होए ओसरो पाँलाई जेयुँ ओमाहुबो प़ाइँना, ङा ङापाँत झन कातानी ची जेयुँ उहुप्‍रिज़्‍याव?” ");
INSERT INTO kjl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","आव पाँ भरी ओतावत येसु गालील दह होफत बाके। नो दहलाई तिबेरियास मनी है यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","येसुए अचम्‍बलाव य़ेनर ओदोज़्‍याव, याजोरो हुवरालाई ओरासगराँज़्‍याव मनी यारँःज़्‍यावए ओल जोदा जोदा बाज़्‍या मिँर ब उछीं उछीं बनै माहोल्‍या ज़ याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","हो बेलाक येसु उसिसरास तोबो दाँदात बाद च़ुसिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","नो बेलाक यहूदीराए निस्‍तार पर्ब हुनाद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","येसुए ओल्‍योदा हुज़्‍याव माहोल्‍यार रँःद तोबो उसिस फिलिपलाई, “गे आव माहोल्‍यारालाई ज़्‍यावर कान्‍नी लँःद रैद्यान्‍या?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","खाली आव पाँ फिलिपलाई जाँचिन्‍याए जूँनी वाज़ ओल्‍यो। येसुए ओल दाव ओपैंज़्‍याव य़ेन ते ङ़ादा ज़ थ·रैद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","हाःत ज़ फिलिपए, “आः कुधुलाई तके तके वाज़ गेराएदी ब चाँदीए सिक्‍का ऩेसयवाए ब थैंन्‍या माले,” है ओदोज़्‍याक ज़, ");
INSERT INTO kjl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","छुत उसिस सिमोन पत्रुसए ओभाइ अन्‍द्रियासए येसुलाई, ");
INSERT INTO kjl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“आक तोबो छोर्‍यास पाँच गोता चिकाए भरेस स़ोनो ऩेब्‍लो ङाँः लिज़्‍या। खाली नाःकाव मिँरालाई काता ची ओतारिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","येसुए उसिसरालाई, “नो माहोल्‍यारालाई बाँल च़ुसिउ यारापरींचिके,” है यादोक्‍यो। नल छी खार्ल च़ुसिन्‍या पो बनै चाव उलिज़्‍याव। नो माहोल्‍यारानी खेपार वाज़ पाँच हजारा यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","नोर याच़ुसिउत येसुए नो पाँच गोता भरेस रैद धन्‍याबाद चरैःद ‘नो च़ुसिद लिज़्‍यावराए घज़्‍युरक’ लिद भाःद याएक्‍यो। फरी नो ऩेब्‍लो ङाँःनिलाई मनी हिताव ज़ जैद भाःद याएक्‍यो। नोराए याफू तसी ज़्‍युकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","नोर ज़्‍याद यावाँःवत उसिसरालाई, “नो ज़्‍यादकाव यासय़ेलोर तके ब माख्यानैद दुप्‍चिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","नोराए यासय़ेलो पाँच गोता चिका भरेसए उकुतुरार यादुप्‍क बाह्र झुर्नु ताके। ");
INSERT INTO kjl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","मिँराए येसुए इताव अचम्‍बलाव य़ेनर ओदोव रँःद, “आव मानुवात हुरिज़्‍या है यालिज़्याव अगमबक्ता साचो आव ज़ ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","है जैद नोराए येसुलाई करस याराजा जैव यापैंज़्‍याव सैंद येसु ननी पुलुस्‍द ओबातङ ज़ तोबो दाँदात बाके। ");
INSERT INTO kjl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","नम ओझ्यानाक येसुए उसिसर दह छ्योक झरिद, ");
INSERT INTO kjl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","दोङ्गाल पसिद दह होफताव कफर्नहुमदा बाव यापैंज़्‍याव। खाली नम झ्याद चुम चुम ताद ब येसु ओमाहुवए या वाज़ दोङ्गाल पसिद बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","याबाज़्‍याक बनै घ्योःव बतास हुद ऱीलाई बनै ओहर्लैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","हितावल ज़ यादोङ्गालाई छ किलोमितरवा यालाँवत येसु ऱी तर्त तर्त याल्‍योदा उहुज़्‍याव रँःद बनै छे·केर। ");
INSERT INTO kjl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","हाःत ज़ येसुए, “ताछे·च्‍यो, ङा ची,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","नोर यायुँर होलाँ ताद दोङ्गाल हुव एकेर। याकेस्‍न्‍या पोक ब बेहार ज़ केस्‍केर। ");
INSERT INTO kjl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","हो पराःती नो याराख्यानैव माहोल्‍याराए, ‘दह आफत दोङ्गा तोबो वाज़ ओल्‍यो, नो दोङ्गाल ओल येसु ते माबाए, उसिसर वाज़ याबाव’ लिन्‍या यासैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","येसुए धन्‍याबाद चरैःद मिँरालाई भरेस भाःद ओरायो पोक तिबेरियास सहरनी छुत दोङ्गार ब हुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","नो मिँराए येसुलाई स़ोनो उसिसरालाई काङ्क ज़ यामारारँःवए नोर दोङ्गाल पसिद कफर्नहुमदा येसुलाई साप्‍नाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","नोराए दह होफत येसुलाई यारँःव प़ाइँना, “गुर्बा, नँ खा बेलाक आङ नहुव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, जे ङालाई अचम्‍बलाव ङाय़ेनर रँःद जेसाप्‍नाज़्‍याव माःक, नो जेफू तसी भरेस ज़्‍याव जेदैवनी जेसाप्‍नाज़्‍याव ची। ");
INSERT INTO kjl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","निताव ज़्‍याद खेम्‍न्‍या भरेसलाई ताखिम्‍च्‍यो, बुरू अजम्‍बरी जुनील लाँज़्‍याव ज़्‍याव खिम्‍चिके। निताव ज़्‍याव ङा मिँ मिन्‍सिउए वाज़ यान्‍या ङाले। होए उजूँनी ज़ परमेस्‍वर ङाबाबुए ङालाई खतैद नैनाव।” ");
INSERT INTO kjl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","हाःत ज़ नो मिँराए, “हिताव ताकिन गे परमेस्‍वरए उयुँलाव मिताव य़ेन काता दान्‍या की?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","येसुए, “जे परमेस्‍वरए ओय़ेन दान्‍या आव ज़ — परमेस्‍वरए उपरींव ओज़ालाई जेयुँ सुहुप्‍चिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","नोराए, “नँ गेलाई गेयुँ सुहुप्‍द्यान्‍या ताकिन, किताव नसरेस सतैंद नयासिरिज़्‍याव, किताव य़ेन नदोरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","भाःक गेसाखा पुर्खाराए नाङग्‍या पात्‍या बनल मन्‍न ज़्‍युकेर। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, ‘मोसाए मिँरालाई स्‍वर्गनी हुव ज़्‍याव याएक्‍यो,’ ” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","येसुए नोरालाई, “हैदी ब ङा जेलाई साचो है ङादाचिज़्‍या, जेलाई स्‍वर्गनी हुज़्‍याव साचो ज़्‍याव मोसाए ओयाचिज़्‍याव ते माःक, साचो ज़्‍याव याज़्‍याव ते परमेस्‍वर ङाबाबुए ची। ");
INSERT INTO kjl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ङाबाबु परमेस्‍वरए ओराएज़्‍याव स्‍वर्गनी हुव ज़्‍याव नो ज़ मानुवाताव मिँरालाई बाँचैज़्याव,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","नोराए, “हो ची ताकिन्‍दा प्रभु, गेलाई मनी नो ज़्‍याव याव ताके,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","येसुए नोरालाई, “मिँरालाई बाँचैज़्‍याव ज़्‍याव ङा ज़। ङाल्‍योक हुज़्‍याव करेन्‍या माले, ङालाई उयुँ हुप्‍ज़्‍याव खर्क ज़ ऱी छोस्‍न्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","खाली ङा जेलाई है दाद ङानैचिए, जे ङालाई रँःद ब जेयुँ ज़ माहुबे। ");
INSERT INTO kjl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","हैदी ब ङाबाबु परमेस्‍वरए ओयाँज़्‍याव भरी ङाल्‍योदा ज़ हुज़्‍यार। ङाल्‍योक हुज़्‍याव भरी ङा सुलाई ज़ ङामारासोवोले। ");
INSERT INTO kjl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","स्‍वर्गनी ङा ङापैंज़्‍याव मिताव सयो·न्‍याए जूँनी ङाहुव माःक, ङालाई परींज़्‍याव परमेस्‍वरए उयुँलाव मिताव सयो·ना ङाहुव ची। ");
INSERT INTO kjl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ङालाई परींज़्‍यावए ओपैंज़्‍याव आव ज़ — ङालाई ओयाँज़्‍याव भरिरानी ङा सुलाई ज़ मासम़ैद परमेस्‍वरए ओराफाल्‍रिज़्‍याव छ्याम नोरालाई सिउनी सोचोइन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","है जैद परमेस्‍वर ङाबाबुए उयुँ आव ज़ — ङा ओज़ालाई रँःद यायुँ हुप्‍ज़्‍यावरालाई संसार खेम्‍न्‍या छ्याम ङा नोरालाई सिउनी सोचोइद अजम्‍बरी जुनील लाँन्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","येसुए ‘स्‍वर्गनी हुव ज़्‍याव ङा ज़’ है ओरादोवए यहूदीर झन रूम्‍रूमैद, ");
INSERT INTO kjl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“आवए कै जैद ‘ङा स्‍वर्गनी हुव’ है उलिज़्‍याव? आवए ओबाबु ओआमानिलाई गे ज़ गेरासरेस्‍ज़्‍या। आव येसु ते योसेफए ओज़ा ज़ सानी,” है यालिक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","येसुए, “जे काराव जेरूम्‍रूमैज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ङालाई परींज़्‍याव ङाबाबु परमेस्‍वरए ङाल्‍योदा हुन्‍या युँ जैद ओमाराएकिन सु ज़ ङाल्‍योक माहुधुर। ङाल्‍योदा हुज़्‍यावरालाई ते आव मानुवा ओखेमो छ्याम सोचोइन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","अगमबक्ताराए यासरोल मनी इताव सर्सिउ लिज़्‍या, ‘प़ाइँलाई ओल परमेस्‍वरए ज़ यापैरिज़्‍याव।’ जोए ङाबाबु परमेस्‍वरए ओपाँ थैद सिऊसिज़्‍या, हो ङाल्‍योक हुज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","परमेस्‍वर ङाबाबुलाई सुए ज़ मारँःतार। खाली ओलनी हुव ङा ओज़ाए वाज़ रँःद ङानै। ");
INSERT INTO kjl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ङा जेलाई साचो है ङादाचिज़्‍या, जोए ङालाई उयुँ हुप्‍ज़्‍या, होस अजम्‍बरी जुनी लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","प़ाइँलाई बाँचैज़्‍याव ज़्‍याव ङा ज़। ");
INSERT INTO kjl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","जेसाखा पुर्खार ते बनल मन्‍न याज़्‍युदी ब सिद बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","स्‍वर्गनी हुव ज़्याव ज़्‍युज़्‍याव ते खर्क ज़ सिन्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","नो स्‍वर्गनी हुव ज़्‍याव ङा ज़। आव ज़्‍याव ज़्‍युज़्‍याव मिँ खर्क ज़ सिन्‍या माले। आव मानुवाताव मिँरालाई बाँचैन्‍याए जूँनी याव ङापैंज़्‍याव ज़्याव आव ङाक्‍याँ ज़।” ");
INSERT INTO kjl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","आव पाँत यहूदीर या याल खर्लेसिद, “आव मिँए कै जैद गेलाई ओक्‍याँ याद सव़ाँव ओपैंज़्‍याव ओताव?” है यालिज़्‍याव थैद, ");
INSERT INTO kjl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","येसुए, “ङा जेलाई साचो है ङादाचिज़्‍या, जे परमेस्‍वरनी हुव मिँ मिन्‍सिउए ओक्‍याँत जेकरे जेमासैःकिन, उझीत जेऱीछो जेमासैःकिन अइज़ सिउ स्‍यासोर जेताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जोए फरी ङाक्‍याँत ओकरे सैःज़्‍याव, ङाझीत उऱीछो सैःज़्‍याव, हो अजम्‍बरी जुनील गनिसिउ लिज़्‍या। खेम्‍न्‍या छ्याम नोलाई सोचोइन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काराव ल्‍यो ताकिन आव ङाक्‍याँ साचो ज़्‍यान्‍या ज़्‍याव ज़, ङाझी साचो ओन्‍या ऱी ज़। ");
INSERT INTO kjl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ङाक्‍याँत ओकरे सैःज़्‍याव, ङाझीत उऱीछो सैःज़्‍याव, हो ङास ज़ लिज़्‍या, ङा ओलस ज़ ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","किताव ङालाई परींज़्‍याव ङाबाबुए ल्‍योनी बाँचिउ ज़ ङालिज़्या, हिताव ज़ ङाक्‍याँत ओकरे सैःज़्‍याव मनी ङानी ज़ बाँचिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","है जैद ङा ज़ स्‍वर्गनी हुव ज़्याव। नो ज़्‍याव जेसाखा पुर्खाराए याज़्‍युव ज़्याव मिताव ते माःक। नोर नो ज़्याव ज़्‍याद माबाँचिर। आव है ङालिज़्‍याव ज़्याव ज़्‍युज़्‍याव ते खर्क ज़ सिन्‍या माले।” ");
INSERT INTO kjl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","आव पाँ भरी येसुए कफर्नहुमलाव धर्मसास्‍त्र झ़िमल ओरासथैज़्याक ज़ है ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","आव पाँ थैद येसुए उछींत बाज़्‍यावर कुधुए, “आव पाँ बनै नाल क़्याव लिज़्‍या, सुए ची ओथैधुरिज़्‍याव?” है लिद ");
INSERT INTO kjl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यागन्‍गनैज़्‍याव येसुए सैंद नोरालाई, “आव पाँए जेयुँ केःद ओयाचिज़्‍याव रो? ");
INSERT INTO kjl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","हिताव ताकिन ङा मिँ मिन्‍सिउ जुनी ङाहुव होदा ज़ तछा ओल्‍द ङाबाज़्‍याव जेरँःनाक झन हो छ्याम कै जेलिरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","क्‍याँलाई बाँचैज़्‍याव पाखाताव रैंःज़्‍यावए माःक, परमेस्‍वरए उपुरूसए ची। जेलाई है ङादाचिउ पाँल मनी उपुरूस उलिज़्यावए हो पाँए ज़ जेबाँचिज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","खाली आव पाँ है ङादाचिदी ब जे ख्वार आव पाँत जेयुँ ज़ माहुबे,” है यादोक्‍यो। येसुए ओललाई यायुँ माहुप्‍ज़्‍यावर ङ़ादाकिन ज़ सरेस्‍द ओरानैज़्‍याव। ओललाई धोका याव पैंज़्‍यावलाई मनी ङ़ादाकिन ज़ सरेस्‍द ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","फरी नोरालाई, “है जैद ज़ जेलाई है ङादाचिउ, ङाबाबु परमेस्‍वरए सुवारालाई ङाल्‍योदा हुन्‍या युँ जैद ओमाराएकिन सु ज़ ङाल्‍योदा हुधुन्‍या मालेर,” है ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","निताव ओपाँए येसुस बाज़्‍यावर कुधुए ज़ ओललाई ऱास्‍द ओल्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","हाःत ज़ येसुए बाह्र जना उसिसरालाई, “जे मनी बाव जेपैंज़्‍याव रो?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सिमोन पत्रुसए, “प्रभु, गे नँलाई ऱास्‍द सुए ल्‍योदा बान्‍या? अजम्‍बरी जुनील बान्‍या पाँ ते नँस वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","परमेस्‍वरनी हुव छैंव ओज़ा मनी नँ ज़ लिद सरेस्‍द गेयुँ हुप्‍द ज़ ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","येसुए नोरालाई, “जे बाह्र जनालाई छाँतिज़्‍याव ङा ज़। हैदी ब जेखार्ल तोबो ते सैतानसकाव लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","येसुए आव पाँ सिमोन इस्‍करियोतए ओज़ा यहूदाए उजूँनी है ओरादोव। नो मिँ बाह्र जना उसिसरानी ओललाई धोका याज़्‍याव मिँ ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","आव भरी ओतावत येसु गालील जीदा आदा होदा लिनाके। यहूदियालाव यहूदीराए यास़ेरराए ओललाई सैःव यापैंज़्‍यावए नजीदा नोराए ल्‍योनी ओतर्किज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","नो बेलाक यहूदीर सालकाव तखेप छापरा जैद यामानिज़्‍याव पर्ब हुनाद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","है जैद येसुए ओभाइराए, “नँ आव पोलाई ऱास्‍द यहूदियाल बान्‍के। हो ताकिन नसिसराए नङ मनी नदोज़्‍याव य़ेनर रँःन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","उमिन सथासो पैंज़्‍याव मिँए मनी सुए ज़ ओय़ेन म़ोंद मादोव। नँ इताव य़ेनर दोव नपैंकिन मिँ भरिराए ङ़ाक सतैंसिउ ताके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काराव ल्‍यो ताकिन नो ओभाइराए मनी ओललाई यायुँ ओमाहुप्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","येसुए नोरालाई, “ङा निताव य़ेन दान्‍या बेला माहुताए, खाली जे जेजूँनी ते बेला एकम्‍न्‍या लिज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","जेलाई आव मानुवाताव मिँराए सुए ज़ मासोचिर। ङा फरी आव मानुवाताव मिँराए माचाव याय़ेन सतैंद ङाराएज़्‍यावए ङालाई सोनाज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","जे आव पर्ब मानिना बाचिके, ङा आख ङामाबा, ङाबेला माहुताए,” ");
INSERT INTO kjl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","है दाद ओल गालीलल ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","हैदी ब येसुए ओभाइर पर्ब मानिना याबाव छींनी ओल मनी सुए यामासैंद होदा ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","हो बेलाक पर्बत यहूदीराए यास़ेरराए, ‘येसु काङ्क उलिज़्‍याव?’ लिद सापो ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","नो माहोल्‍याराए मनी येसुए उजूँनी कुधु ज़ यापाँज़्‍याव। ख्वाराए, “नो मिँ बनै चाव लिज़्‍या,” है यालिज़्‍याव, ख्वाराए फरी, “माःक, नोए ते झन मिँर तँदा ज़ यालाँज़्‍याव,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","हैदी ब यहूदीराए यास़ेरराए छ्याचेए सुए ज़ पाखात मापाँधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","नो पर्ब ऩेला स़ोंला ओतावत येसु ध्‍यान झ़िमल बाद परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ओपाँ थैद यहूदीराए यास़ेरर अचम्‍ब ताद, “आव मिँ प़रि ज़ माप़रिउए कै जैद नाः ओसैंज़्‍याव?” है यालिज़्‍याव ");
INSERT INTO kjl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","येसुए थैद, “आव ङासथैचिज़्‍याव पाँ ङा ङापाँ माःक, ङालाई परींज़्‍यावए ओपाँ ची। ");
INSERT INTO kjl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","परमेस्‍वरए उयुँलाव मिताव य़ेन दोव पैंज़्‍यावए वाज़ आव पाँ परमेस्‍वरए ओपाँ सैं ङा ङापाँ ओताव लिन्‍या प़ाल्‍धुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ओलनी पाँज़्‍यावए ते ओल उमिन सथासो पैंज़्‍याव। ओललाई परींज़्‍यावए उमिन सथासो पैंज़्‍याव ते ओखत माल्‍यो सोजो मिँ ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","जे परमेस्‍वरए ओकानुन मोसाए ल्‍योनी जेदैके, खाली जे नो कानुनलाव य़ेन ते जेमादोके। झन ङालाई सैःव जेपैंज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","नो माहोल्‍याराए, “नँ दासा बिसा ताद नले, नँलाई सुए सैःव ओपैंज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","येसुए नोरालाई, “जे काराव ऩासिन्‍या छ्याम तोबो य़ेन ङादोक हार जेमानिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","मोसाए जेलाई क्‍याल्‍न्‍या सरेस जैन्‍या कानुन याद नैचिउ। तान्‍या ते नो कानुन मोसाए ओयाचिउ ते माःक, जेसाखा पुर्खाराए यायाचिउ ची। नो सरेस जैन्‍या ऩासिन्‍या छ्याम उपरिकिन जे मनी ते हो छ्याम क्‍याल्न्‍या सरेस जेराजैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","निताव मोसाए ओकानुनलाई माबिरैन्‍याए जूँनी ऩासिन्‍या छ्याम क्‍याल्‍न्‍या सरेस जैन्‍या ओताज़्‍याव ताकिन, ऩासिन्‍या छ्याम ङा तोबो मिँलाई ङासगराँक जे काराव जेरिस ओचोज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","जे मिँ रँःद माःक, साचो युँनी फाल्‍नाच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","हाःत ज़ यरूसलेमलाव ख्वा ख्वा मिँराए, “नो सैःव यापैंज़्‍याव मिँ आव माःक रो? ");
INSERT INTO kjl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","झन निताव प़ाइँए ङ़ाक माम़ोंसिद ओपाँक ब सुए ज़ घाइ मादोर। सैं गेस़ेरराए मनी ‘गेलाई बाँचैना हुव ख्रीस आव ज़’ है लिद याथ·रैज़्‍याव ओताव? ");
INSERT INTO kjl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","साचो ख्रीस ओताव ताकिन ते आनी उहुव लिन्‍या सुए ज़ मासैंखेरहो। गे ते आवलाई आनी हुव ज़ लिन्‍या प़ाइँए गेसैंज़्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","हाःत ज़ येसुए ध्‍यान झ़िमल ओर्गा बनै सघ्‍योःद अइ लिद यासथैक्‍यो, “जे ङालाई ब जेसरेस्‍नाज़्‍या, आनी उहुव लिन्‍या ब जेसैंज़्‍या। हैदी ब ङानी ङाहुव माःक, ङालाई परींव ओल साचो परमेस्‍वरए ज़। नोलाई ते जेमासरेसे। ");
INSERT INTO kjl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ङा ते ङासरेस्‍ज़्‍या। ङा ओल्‍योनी ज़ ङाहुके, ङालाई परींज़्‍याव ब ओल ज़,” है ओरादोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","नोराए क्‍योःव पैंकेर। खाली ओबेला ओमाहुतावए सुए ज़ हिउ माझाःधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","हितावत ब नलाव लिज़्‍यावर कुधुए ज़ येसुलाई यायुँ हुप्‍द, “नो हुरिज़्‍या है यालिज़्‍याव ख्रीस उहुवत, आव मिँकिन घेप्‍पा य़ेन ओदोधुरिज़्‍याव रो?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","नो मोहोल्‍याराए येसुए उजूँनी इताव खास खासनी खुस खुस यापाँज़्‍याव फरिसीराए थैद नोर मुख्या पुजारीरास खैद ओललाई क्‍योःना ध्‍यान झ़िमलाव पाल्‍यार यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","नो बेलाक ज़ येसुए, “ङा जाँवा पै वाज़ जेस ङालिरिज़्‍या, नकिन ङालाई परींज़्‍यावए ल्‍योदा ङाबारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","हाःकिन ङालाई जेसाप्नादी ब दैधुन्‍या जेमाले, ङालिज़्‍याव पोल जे हुधुन्‍या ब जेमाले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदीराए यास़ेरर या याल है लिकेर, “आव मिँ काताङ म़ोंसिनाव ओपैंज़्‍याव ब्‍याँ? ‘ङालाई दैधुन्‍या जेमाले’ है लिज़्‍या। सैं आव देसलाई ऱास्‍द ग्रीकराए खार्लाव चितराँ पुतराँ ताव यहूदीराए खार्ल लिनाद नोरालाई ओल्‍योदा ओराजैनारिज़्‍याव ओताव? ");
INSERT INTO kjl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","नोए, ‘ङालाई जेसाप्‍नादी ब दैधुन्‍या जेमाले, ङालिज़्‍याव पोल ब हुधुन्‍या जेमाले,’ है उलिज़्‍यावए ओअर्थ काता ओताव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","पर्ब स्‍यो·न्‍या, प़ाइँरानी घेप्‍पा छ्याम, येसुए प़ाइँराए ङ़ाक च्‍याँःसिद ओर्गा बनै सथास्‍द, “छोस्‍ज़्‍याव मिँ ङाल्‍योक हुद उऱीछो ओसैःहुवक। ");
INSERT INTO kjl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","धर्मसास्‍त्रलाव सर्सिउ मिताव, जोए ङालाई उयुँ हुप्‍ज़्‍या, होए उयुँनी जींदो ऱीमुल मिताव पुलुस्‍न्‍या ले,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","नो जींदो ऱी है उलिज़्याव ओललाई यायुँ हुप्‍ज़्‍यावराए छैंव पुरूस यादैरिज़्‍यावए जूँनी ज़ ओपाँज़्‍याव। हाः बेलाक पै येसु स्‍वर्गदा ओमाबातावए छैंव पुरूस परमेस्‍वरए ओमाराएताव। ");
INSERT INTO kjl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","हाःत ज़ नो माहोल्‍यारानी ख्वा ख्वाराए येसुए ओपाँ चावस थैद, “साचो आव ज़ ओल्‍यो, हुरिज़्‍या है यालिज़्‍याव अगमबक्ता,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ख्वाराए फरी, “नो ते परमेस्‍वरनी बाँचैना हुरिज़्‍या है यालिज़्‍याव ख्रीस ज़,” है लिकेर। ख्वाराए फरी, “ख्रीस ताकिन गालीलनी ते हुव मापरिन्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ख्रीस दाऊदए ओथोल जर्मिद दाऊदए ओनाखार बेथलेहेमनी हुन्‍या ले लिद धर्मसास्‍त्रल सर्सिउ लिज़्‍या सानी।” ");
INSERT INTO kjl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","है जैद येसुए उजूँनी नो माहोल्‍यार यापाँ माखैद कुधु खर्लेसिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ख्वाराए ते ओललाई क्‍योःव यापैंज़्‍याव, खाली सुए ज़ हिउ माझाःकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","छींनी नो फरिसीर स़ोनो मुख्या पुजारीराए येसुलाई क्‍योःना यारापरींव ध्‍यान झ़िमलाव पाल्‍यार अइज़ ओल्‍द याहुवए फरिसीराए, “येसुलाई काराव क्‍योःद जेमारैव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","नो पाल्‍याराए, “नोए ओपाँज़्‍याव मिताव ते आःपै खर्क ज़ गेमाथैताए,” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","नो फरिसीराए, “जे मनी काता घरी नोए ओपाँ थैद तँदा जेबाधुव। ");
INSERT INTO kjl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","गे फरिसीर स़ोनो स़ेरर ते नोए ओपाँत तोबो ब गेमाबाए सानी। ");
INSERT INTO kjl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","इताव मोसाए ओपाँ मासैंज़्‍याव याफ्या·हुव माहोल्‍याराए वाज़ नोए ओपाँ थैज़्‍यार,” है लिद यारासिङार्केर। ");
INSERT INTO kjl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","हाःत ज़ नक लिज़्‍याव फरिसीरानी येसुलाई ङ़ादा तखेप दैना हुज़्‍याव नो निकोदेमसए, ");
INSERT INTO kjl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“गे गेकानुनल जो मिँलाई तादी ब नोए ओपाँ माफाल्‍द ओय़ेनताव ओगल्‍ती माथ·रैद कै जैद नोलाई सजा यान्‍या ओताज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","नोराए, “काता नँ मनी नोसकाव गालीललाव ज़ रो? अगमबक्ता गालीलनी सु ज़ हुन्‍या माले, अछादी नँ ज़ धर्मसास्‍त्रल चावस चिऊके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","हाःत ज़ मिँ भरी सु सु याझ़िमदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ओल येसु ते जैतून दाँदात बाके। ");
INSERT INTO kjl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","हो पराःती छकाल्‍न्‍या घग ज़ फरी ध्‍यान झ़िमल उहुवत मिँर बनै माहोल्‍या ओल्‍योक दुप्‍सिहुकेर। हाःत ज़ येसु च़ुसिद ओपाँ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","नो बेलाक ज़ सास्‍त्रीर स़ोनो फरिसीराए तोबो पातर्नी य़ेनल क्‍योःसिउ मेंमालाई रैद प़ाइँराए ङ़ाक सच्‍याँद, ");
INSERT INTO kjl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","येसुलाई, “गुर्बा, आव मेंमाए पातर्नी य़ेन ओदोज़्‍याक ज़ क्‍योःद नल्‍योक रैद गेनै। ");
INSERT INTO kjl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मोसाए ओकानुननी ते निताव य़ेन दाज़्‍यावलाई लुँए झेःद सैःन्‍या लिज़्‍या, नँ कै नलिज़्‍या नी?” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","आव पाँ येसुलाई क्‍योःन्‍याए जूँनी अइज़ अखतैं थाँद यानैज़्‍याव। खाली येसुए नोरालाई घाइ मादाद घोम लिद ओआङुलाए नामक सर्क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","नोराए घरी पाला यासुधिक येसु च्‍याँःसिद, “जेनी जोए काता पाप ज़ मादोव, होए ज़ आव मेंमालाई प़ाइँरानी ङ़ात लुँए ओझेःवक,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","फरी ब घोम लिद नामक सर्क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","नो पाँ थैद नोर यास़ेरनी यास़ेरनी तोबो तोबोनी ओपो·स ज़ बाकेर। नो भरी याबावत नो मेंमा स़ोनो येसुनी वाज़ रहिकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","येसु फरी ब च्‍याँःसिद नो मेंमालाई, “अ माँ, नँलाई रैज़्‍यावर काना याबाव? सुए ज़ नपाहा झाःद यामाईंधुव रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","नो मेंमाए, “हैज़ प्रभु, ङापाहा झाःद्यान्‍या सु ज़ मापुलुस्‍केर,” है दोक्‍यो। हाःत ज़ येसुए, “ङा ब नखत पले·द ङामाईंए, नझ़िमदा बान्‍के। आव माचाव नय़ेन फरी तादोयो,” है दाद परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","येसुए फरी मिँरालाई, “ङा ज़ आव मानुवाताव ज़गै। ङाछींत हुज़्‍याव मिँ चुम चुमोल बाव मापरिए, अजम्‍बरी जुनील लाँज़्‍याव ज़गैवल ताज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","हाःत ज़ नलाव फरिसीराए निताव पाँ थैद, “नँ नजूँनी नँ ज़ गोहाई नएज़्‍यावए नगोहाई अऩाकलाव ज़ लिज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","येसुए, “ङा ङाजूँनी ङा ज़ गोहाई ङाएदी ब नो पाँ अऩाकलाव माले, काराव ल्‍यो ताकिन ङा वाज़ कान्‍नी ङाहुव, काना ङाबारिज़्‍याव लिन्‍या ङासैंज़्‍या। जे ते नो भरी जेमासैंए। ");
INSERT INTO kjl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","जे ते मिँराए गोइँनी वाज़ छ्याप जेलैनाज़्या। ङा ते सुलाई ज़ छ्याप ङामारालैए। ");
INSERT INTO kjl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","खाली ङा निताव य़ेन ङादोदी ब नो साचो ज़ थ॰रिज़्‍या, काराव ल्‍यो ताकिन नो य़ेन ङा वाज़ ङामादोए, ङालाई परींज़्‍याव ङाबाबुए मनी ङास ज़ दोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","जे जेकानुनल मनी ‘ऩेब्‍लोए निपाँ ओखैकिन वाज़ नो पाँ साचो थ॰रिज़्‍या’ लिद सर्सिउ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","हिताव ज़ ङा ङाजूँनी पाँज़्‍याव तोबो ङा ज़, तोबो ङालाई परींज़्‍याव ङाबाबु ज़,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","फरिसीराए, “हुकी, नबाबु काङ्ङ उलिज़्‍याव की?” है यादोक ते, येसुए, “जे ना ङालाई जेसरेस्‍नाज़्या, ना ङाबाबुलाई जेसरेस्‍ज़्या। जे ङालाई जेसरेस्‍नाव ताकिन ङाबाबुलाई मनी सरेस्‍न्‍या जेल्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","येसुए आव पाँ भरी ध्‍यान झ़िमलाव भिती याचरैःज़्‍याव पोक ज़ ओरासथैज़्‍याव। हितावत ब ओबेला ओमाहुतावए सुए ज़ माक्‍योःधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","येसुए फरी नोरालाई, “ङा जाँवाक आनी ङाबारिज़्‍या। हाः बेलाक ङालाई जेसाप्‍नादी ब जेपापल ज़ सिन्‍या जेले। ङा ङाबाज़्‍याव पोङ जे हुधुन्‍या जेमाले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","यहूदीराए यास़ेरर या याल, “आवए काता ओपाँज़्‍याव इताव — ‘ङा ङाबाज़्‍याव पोङ जे हुधुन्‍या जेमाले,’ है लिज़्‍या? सैं ओलनी ज़ सैःसिउ ओपैंज़्‍याव ओताव?” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","येसुए फरी, “जे मेलावर ज़, ङा रोताव ज़। जे आव मानुवातावर, ङा ते आव मानुवाताव माःक। ");
INSERT INTO kjl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","है जैद ज़ जेलाई है ङादाचिउ, जे जेपापल ज़ सिन्‍या जेले। ‘ङा हो ज़’ है दाद ब जेमापतिनाव प़ाइँना नो जेपापनी कातानी उस्‍किउ जेदैरिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","नोराए फरी ब, “हुकी, नँ सुकी?” है यादोक ते, येसुए, “ङाजूँनी जेलाई ङ़ादाकिन ज़ है दाव ज़ ङानैचिज़्या सानी। ");
INSERT INTO kjl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ङानी ताकिन ते जेलाई है दान्‍या ब कुधु ज़ लिज़्‍या, जेखत पले·द्यान्‍या ब कुधु ज़ लिज़्‍या। खाली ङालाई परींज़्‍यावए ल्‍योनी ङाथैव भरी वाज़ आव मानुवाताव मिँरालाई ङारासथैज़्‍या। होए ओपाँ थ॰रिउ ज़ लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","खाली येसुए नो भरी ओबाबु परमेस्‍वरए उजूँनी ओपाँव नोराए अझ मनी माबुझिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","येसुए फरी ब है यादोक्‍यो, “जे ङा मिँ मिन्‍सिउलाई क्रुसत जेतङ्गैनारिज़्याव छ्याम वाज़ ‘ङा हो ज़’ लिन्‍या सरेस्‍न्‍या जेले। ङादोज़्‍याव भरी ङानी काता ज़ ङामादोए, ङाबाबुए ओपैनाव वाज़ ङापाँज़्‍या लिन्‍या ब सैंन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ङालाई परींज़्‍याव ङास ज़ लिज़्‍या। ङादोज़्‍याव य़ेन भरी ब उयुँलाव मिताव ओतावए ङालाई ङाबातङ मानैनाव।” ");
INSERT INTO kjl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","नो पाँत नक लिज़्‍यावर कुधुए ज़ येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","येसुए ओललाई यायुँ हुप्‍ज़्‍याव यहूदीरालाई है यादोक्‍यो, “आव ङापाँत धिद जेलिकिन जे साचो ङासिसर ज़ जेताज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","साचो पाँर सैंद, नो पाँए जे पला·सिउर जेतारिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","नोराए, “गे ते अब्राहामए ओथोर ची, सुए उधूँल ज़ गेमालिताए। नँ कै जैद गेलाई ‘पला·सिउर जेतारिज़्‍या’ है नदासिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","येसुए, “जेलाई साचो है ङादाचिज़्‍या, पाप दाज़्‍याव मिँ पापए धूँल बाँदा मिताव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","बाँदा एकम्‍न्‍या झ़िमलाव माताए, झ़िमए ओर्गेए ओज़ा ते एकम्‍न्‍या झ़िमलाव ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","है जैद ङा परमेस्‍वरए ओज़ाए जेलाई पला·द ङाऱास्‍चिकिन, जे ननी चबनै पला·सिउर ज़ जेताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","जे अब्राहामए ओथोर लिन्‍या ङा ज़ ङासैंज़्‍या। हितावत मनी ङा ङापाँए जेयुँल लिन्‍या पो ओमादैवए ङालाई सैःव जेपैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ङा ङापाँज़्‍याव भरी ङाबाबुए ल्‍योङाव ङारँःव वाज़ ङापाँज़्‍या। हिताव ज़ जे मनी जेबाबुए ल्‍योनी जेथैव वाज़ जेदोज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","नोराए झन, “गे गेबाबु ते अब्राहाम ज़,” है लिकेर। येसुए, “जे साचो अब्राहामए ओज़ार जेताकिन जे मनी होए ओदोव मिताव य़ेन दान्‍या जेल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","जे ते झन परमेस्‍वरनिकाव ङाथैव सतलाव पाँर जेलाई ङासथैचिक ङालाई सैःव जेपैंज़्‍या। अब्राहामए ते निताव य़ेन मादोव। ");
INSERT INTO kjl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","जे ते छुत जेबाबुए ओय़ेन जेदोज़्‍या,” है ओरादोक ते, नोराए, “गे नामर्‍यार माःक, गे गेबाबु तोबो ज़ लिज़्‍या, ओल परमेस्‍वर ज़,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","हाःत ज़ येसुए, “साचो जे जेबाबु परमेस्‍वर ज़ ताकिन जे ङालाई मया दान्‍या जेल्‍यो। ङा ओल परमेस्‍वरनी हुव ज़। आव मानुवात ङानी ङाहुव माःक, ओल उपरींनाव ज़। ");
INSERT INTO kjl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","आव ङापाँ कै जैद जेमातीधुज़्‍याव? थैन्‍या युँ जेमादोज़्‍याक ज़ जेमातीधुइ। ");
INSERT INTO kjl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","जे जेबाबु सैतानए ओज़ार जेतावए होए उयुँलाव मिताव य़ेन दोव जेपैंज़्‍या। नोए ओय़ेन मनी भाःकिन ज़ सैःन्‍या उलिज़्‍याव। नोस साचो काता ज़ ओमाल्‍योए साचो पाँलाई मासहिधुव। नोए ओबानी धुत पाँन्‍या ओतावए धुत ज़ पाँज़्या। है जैद नो धुत पाँज़्यावराए याबाबु ज़। ");
INSERT INTO kjl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","खाली ङा साचो ङापाँज़्‍यावए ङालाई जेयुँ माहुबे। ");
INSERT INTO kjl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","जेनी ङालाई पापी थ·रैन्‍या सु उलिज़्‍याव? ङा साचो ङापाँकिन कै जैद ङापाँत जेयुँ ओमाहुप्‍ज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","परमेस्‍वरए उमींराए ते परमेस्‍वरए ओपाँ ज़ थैज़्‍यार। जे ते परमेस्‍वरए उमींर जेमातावए ओपाँ ब जेमाथैधुइ।” ");
INSERT INTO kjl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","हाःत ज़ यहूदीराए येसुलाई, “नँलाई प़ाइँए ज़ सामरी है यादींज़्‍याव ते साचो ज़ ओल्‍यो! नँलाई माचाव पुरूसए क्‍योःद ओनैनिज़्‍याव मिताव ब गेरँःनिज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","येसुए, “जे कै जैद ङाक्‍याँत माचाव पुरूस जेरँःज़्‍याव? ङा छैंव परमेस्‍वरए ओमान नैद ङाएज़्या। जे ते ङालाई ङापाहा झाःद जेयाँज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","हैदी ब ङा ते ङामान ङामाखिमे। ङा ङाय़ेनर छ्यानिद ङालाई मान याज़्‍याव छुत तोबो लिज़्‍या — नो परमेस्‍वर ज़। ");
INSERT INTO kjl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","जेलाई साचो है ङादाचिज़्‍या, ङा ङापाँ भैंःद दोज़्‍याव मिँ खर्क ज़ सिन्‍या माले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","नो यहूदीराए झन, “अब ते नक्‍याँत माचाव पुरूस च़रिद उलिज़्‍याव साचो ज़ गेथ·रैके। अब्राहाम गेपुर्खा ब सिके, अगमबक्ता भरी ब सिकेर। नँ कै जैद ‘ङापाँ भैंःद दोज़्‍याव मिँ खर्क ज़ सिन्‍या माले’ है नलिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","काता, नँ सिद बाव गेपुर्खा अब्राहाम स़ोनो अगमबक्ताराकिन ब घ्योःव नलिज़्‍याव रो? नँ काता नसम्‍जिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","येसुए, “ङा ङानी ज़ सघ्‍योःसिउ ङापैंकिन ङामिन अऩाकलाव ज़ ताज़्या। खाली ङालाई सघ्‍योःज़्‍याव ङाबाबु परमेस्‍वरए ज़। नोलाई जे मनी ‘गेपरमेस्‍वर ज़’ है जेदोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","खाली जे परमेस्‍वरलाई ते खर्क ज़ जेमासरेसे, ङा ते ङासरेस्‍ज़्‍या। ङा होलाई ङामासरेसे है ङालिकिन, ङा मनी जे मिताव धुत पाँज़्‍याव ज़ थ॰रिन्‍या ङाले। ङा होलाई ब ङासरेस्‍ज़्‍या, ओपाँ ब भैंःद ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","जेपुर्खा अब्राहाम मनी आव ङाबेलार सैंद उयुँर होलाँ ताके, रँःद खुसी ब ताके।” ");
INSERT INTO kjl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","हाःत ज़ यहूदीराए, “नँ पचास बर्स मायो·ताव मिँए कै जैद ‘अब्राहामलाई ङारँःके’ है नलिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","येसुए, “जेलाई साचो है ङादाचिज़्‍या, ङा अब्राहाम ओमाजर्मिद ङ़ादाकिन ज़ ङालिज़्‍या,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","नोराए झन लुँर तीद येसुलाई झेःव पैंकेर। हाःत ज़ येसु ध्‍यान झ़िमनी अलगज़ा पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","येसु येमत ओबाज़्‍याक तोबो जर्मननी ज़ उमी मारैंःवलाई रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","नाःत ज़ उसिसराए, “गुर्बा, आव उमी मारैंःव सुए ओदोव पापए अइ ओताव? ओल ओदोवए सैं ओबाबु ओआमाराए यादोवए अइ ओताव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","येसुए, “आव ओल ओदोव पापनी ब माःक, ओबाबु ओआमाराए यादोव पापनी ब माःक। परमेस्‍वरए ओसक्ती ओक्‍याँत सरैंःन्‍याए जूँनी अइ ओताव ची। ");
INSERT INTO kjl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","आव पलाँव बेला उलिज़्‍याक ज़ ङालाई परींज़्‍यावए ओय़ेन गे दाव ताके। चुम चुमो ओतावकिन ते सुए ज़ य़ेन मादोधुव। ");
INSERT INTO kjl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","आव मानुवात ङालेवा भरी, मानुवाताव ज़गै ङा ज़,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","येसुए नामक त़िल्‍द, गम मुछिद, नो उमी मारैंःवए उमीत थीद्याद, ");
INSERT INTO kjl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“आव नमीताव हिला सिलोआम दहल च़्‍यानाके,” है दाद परींक्‍यो। (सिलोआमए ओअर्थ परींसिउ।) नो दहल बाद उमीताव हिला ओच़्‍याव प़ाइँना उमी रैंःके। ");
INSERT INTO kjl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","निताव रँःद ओनाखार जीलावर स़ोनो ङ़ादाकिन ऩिद ओङासिज़्‍याव रँःज़्‍यावराए, “आव ते नो ङ़ादाकिनकाव ऩिज़्‍याव मिँ ची सानी!” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ख्वाराए फरी, “हैज़, आव हो ज़,” है लिकेर। ख्वाराए फरी, “आव हो माःक, नो उमी मारैंःवस जेसोबोरोल्‍ज़्‍याव ताखेहो,” है लिकेर। नो उमी मारैंःज़्‍यावए फरी नो यापाँ थैद, “ङा हो ज़ ब्‍याँ,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","नोराए, “हुकी, नँ नमी कै जैद ओरैंःव की?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","नोए, “येसु है यादोज़्‍यावए हिला जैद ङामीत थीद्याद सिलोआम दहल च़्‍यानाव परींनाक्‍यो। नल बाद ङाच़्‍याव प़ाइँना रँःधुन्‍या ङाताके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","नोराए, “आव है नलिज़्‍याव मिँ काना ओबाव?” है यादोक ते, “माँ, ङा ते ङामासैंए,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","हाःत ज़ नोराए उमी गराँवलाई फरिसीराए ल्‍योक लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","येसुए नोलाई उमीत हिला थीद्याद रँःधुन्‍या ओजैव ऩासिन्‍या छ्याम ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","नो फरिसीराए मनी, “नँ कै जैद रँःधुन्‍या नताव?” है यादोक ते, नोरालाई मनी नो रँःधुन्‍या तावए, “होए ङामीत हिला थीद ओयाँव, ङाच़्‍याव प़ाइँना रँःधुन्‍या ङाताके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","नलाव फरिसीर ख्वा ख्वाराए नो ओपाँ थैद, “आव सगराँज़्‍याव मिँ परमेस्‍वरनी हुव ते माःक, म़ानी ऩासिन्‍या छ्यामकाव य़ेन मादान्‍या कानुनलाई माख्याखेहो,” है लिकेर। ख्वाराए फरी, “नो मिँ पापी ताकिन इताव अचम्‍बलाव य़ेन कै जैद ओदोधुरिज़्‍याव?” है लिद या याल माखैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","नोराए उमी गराँवलाई, “नँ नमी सगराँद्याज़्‍यावलाई किताव नङम्‍सिज़्‍या?” है यादोक ते, नोए, “नो अगमबक्ता ज़,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","नो यहूदीराए यास़ेरराए, “आव मिँ ते ङ़ादा उमी मारैंःव ओल्‍यो माताखेहो,” लिद नोए ओपाँ मापतिकेर। है जैद ओबाबु ओआमानिलाई याल्‍योक खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“आव जर्मननी ज़ उमी मारैंःव है यादोज़्‍याव जिनज़ा रो? निताव ओल्‍यो ताकिन कै जैद रँःधुन्‍या ओताव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओबाबु ओआमानी, “हैज़, आव गिनज़ा ज़, जर्मननी ज़ उमी मारैंःव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","खाली कै जैद रँःधुन्‍या ओताव, सुए ओजैव गिन गिन्‍मासैंए। ओललाई ज़ है दोचिके, नो ल़ुज़ा माले, ओल ज़ पाँधुन्‍या ले,” है यारादोकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","नोनी यहूदीराए यास़ेरराए छ्याचेए नितावनी निपाँव। नो स़ेरराए ङ़ादा ज़, “जोए ‘येसु परमेस्‍वरनी बाँचैना हुव ख्रीस ज़’ है लिज़्‍या, होलाई धर्मसास्‍त्र झ़िमनी पले·न्या,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","है जैद ज़ नो ओबाबु ओआमानी, “नो ल़ुज़ा माले, ओललाई ज़ है दोचिके,” है निरादोव। ");
INSERT INTO kjl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","नकिन नो यहूदीराए यास़ेरराए फरी ब नो उमी गराँवलाई याल्‍योक खुल्‍द, “नो मिँ ते पापी ची लिन्‍या गे गेसैंज़्या। कै जैद नँ ‘परमेस्‍वरए ओसगराँनाव’ है नमालिधुज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","नोए, “ङा नो मिँ पापी उलिज़्‍याव सैं ओमालिज़्‍याव लिन्‍या ङामासैंए। तोबो वाज़ ङासैंज़्‍या, ङ़ादा मारँःधुन्‍या ङाल्‍यो, अब रँःधुन्‍या ङाताके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","फरी ब नोराए, “नोए नँलाई कै कै जैद रँःधुन्‍या ओजैनिउ?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","नोए फरी, “है दाव ज़ ङानैचिज़्‍या सानी, जेमाथैधुइ रो? तोबो पाँलाई खा ची है दान्‍या, सैं जे मनी उसिसर जैसिउ जेपैंज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","नोराए थल्‍द, “नँ ची होए उसिस ते, गे ते मोसाए उसिसर ची। ");
INSERT INTO kjl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","मोसास परमेस्‍वर ओपाँव ते गेसैंज़्‍या, आव मिँ सुए ल्‍योनी हुव गे गेमासैंए,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","हाःत ज़ नो उमी गराँवए, “आव ते बनै अनवार्‍यासो पाँ ज़ जेपाँके। ङालाई रँःधुन्‍या ओजैनाज़्‍यावत ब कै जैद आनी हुव लिन्‍या जेमासैंज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","परमेस्‍वरए पापीराए यापाँ माथैव, ओमान नैद्याज़्‍याव उयुँलाव मिताव य़ेन दाज़्‍यावराए यापाँ वाज़ थैज़्‍याव लिन्‍या प़ाइँए गेसैंज़्‍या सानी। ");
INSERT INTO kjl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","आव संसार ओतावकिन जर्मननी ज़ मारँःधुज़्‍यावलाई रँःधुन्‍या जैक्‍यो लिन्‍या आःपै सुए ज़ गेमाथैताए। ");
INSERT INTO kjl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","नो मिँ परमेस्‍वरनी हुव ओमाताव ताकिन, कै जैद निताव य़ेन ओदोधुरिज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","नोराए झन नोलाई, “नँ पापल जर्मिद नपाप भुगिउ प़ैक्‍याए गेलाई पैव नपैंज़्‍याव रो?” है लिद नोलाई धर्मसास्‍त्र झ़िमनी हुतैद पले·केर। ");
INSERT INTO kjl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","येसुए नोलाई पले·केर दी लिन्‍या थैद नोस दैसिनाद, “मिँ मिन्‍सिउलाई नयुँ माहुप्‍ज़्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“नो मिँ मिन्‍सिउ है नलिज़्‍याव सु ओताव, प्रभु? ङा नोलाई ङारँःकिन ङायुँ हुप्‍न्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","येसुए, “नो मिँलाई रँःद ब ननै, ङा नँस पाँज़्‍याव ब हो ज़,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","नो मिँ ओङ़ाक फुलुप्‍सिद, “प्रभु, ङा नँलाई ङायुँ हुप्‍के,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","हाःत ज़ येसुए, “काता ज़ मासैंन्‍यार मारँःधुन्‍यार सैंन्‍या रँःधुन्‍या ओतारक, फरी ‘गेसैंज़्‍या गेरँःज़्‍या’ है लिज़्‍यावर काता ज़ मासैंन्‍या छाम छामोर ओतारक लिद आव मानुवाताव मिँरालाई ङाराछ्यानिहुव,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","नक लिज़्‍याव फरिसीराए थैद, “हुकी, गेलाई मनी गेमी मारैंःव मितावर नजैसिज़्‍याव रो?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","येसुए, “जे साचो काता ज़ मासैंधुन्‍या मारँःधुन्‍यार जेताव ताकिन जेखत माल्‍योर तान्‍या जेल्‍यो। खाली जे ‘सैंद रँःद ज़ गेदोज़्‍या’ है जेलिज़्‍यावए जेखत ल्‍योर जेताके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","नकिन येसुए फरी, “ङा जेलाई साचो है ङादाचिज़्‍या, बेधा खोरल य़ामनी मापसिद तँनी पसिज़्‍याव ते चोर दाँका ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","य़ामनी पसिज़्‍याव ते साचो बेधाराए यागावला ज़। ");
INSERT INTO kjl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","य़ाम गुज़्‍यावए नोलाई य़ाम फैदिज़्‍याव। नो गावलाए फरी ओबेधारालाई यामिन हाइए हाइए ओराक़िक नोर ओर्गा थैद ओल्‍योदा याहुवत खोरनी याहाइज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","प़ाइँ पाखात यापुलुसोत फरी ओल याङ़ा याङ़ा बाज़्‍या। बेधार फरी ओर्गा सरेस्‍द उछीं उछीं हुज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","नो बेधार यामासरेसो मिँए उछींत ते माबार। ओर्गा यामासरेसोए झन छे·द धोंःज़्‍यार,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","येसुए आव बेधा गावलाए घर्ती झाःद ओरासथैव पाँ नो थैज़्‍यावराए ओअर्थ मातीधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","है जैद येसुए फरी है यादोक्‍यो, “ङा जेलाई साचो है ङादाचिज़्‍या, नो बेधाराए याखोरलाव य़ाम ङा ज़। ");
INSERT INTO kjl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ङाकिन ङ़ादा हुव भरी जाँकोसै चोरर दाँकार वाज़ याल्‍यो। है जैद बेधाराए नोराए यार्गा माथैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","साचो य़ाम ते ङा ज़। ङाल्‍योनी पसिज़्‍यावर प़ाइँ बाँचिन्‍या लेर। आदा होदा लिद चाव चरनल लाव ब दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोरए ओय़ेन ते कुन्‍या, सैःन्‍या, खेम्‍न्‍या वाज़ लिज़्‍या। ङा ते ङाबगालराए बनै धोल पोगोल जुनी ओदैरक लिद ङाहुव ची। ");
INSERT INTO kjl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ङा ज़ बेधाराए चाव यार्गे गावला। चाव गावलाए ओबेधाराए जूँनी उजिउ झाःद्यान्‍या ब तयार ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","बाहोर्‍या गावला ते, बेधार ओल उमींर यामातावए प़रर याहुज़्‍याव रँःद बेधार ऱास्‍द धोंःद बाज़्‍या। है जैद प़रर हुद बेधारालाई छुपिद चितराँ पुतराँ याराजैज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","नो बाहोर्‍या वाज़ ओतावए बेधाराए ल्‍योदा उयुँ ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ङा फरी चाव यार्गे गावला ज़। किताव ङा ङाबेधारालाई ङारासरेस्‍ज़्‍या, स़ोनो या ङालाई सरेस्‍नाज़्यार, ");
INSERT INTO kjl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","हिताव ज़ ङाबाबुए ङालाई सरेस्‍नाज़्‍याव, स़ोनो ङा मनी ओललाई ङासरेस्‍ज़्‍या। है जैद नो ङाबेधाराए जूँनी तछा ङाजिउ ब ङाझाःरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","आव खोरल माल्‍यो छुत ङाबेधार ब लिज़्‍यार। नोरालाई मनी तछा ङारारैरिज़्‍या। नोराए मनी ङार्गा याथैवत, बगाल ब तोबो वाज़ तान्‍या ले, गावला मनी तोबो वाज़ तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ङाबाबुए ङालाई मया दाँज़्याव, काराव ल्‍यो ताकिन ङा ङाबेधाराए जूँनी ङाजिउ झाःद, नो ङापोहोन फरी रैन्या ङाले। ");
INSERT INTO kjl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","नो ङापोहोन ङानी सुए ज़ मालाँधुर, ङा ङायुँ स्‍यानी ज़ ङाझाःरिज़्‍या। झाःन्‍या, सोवोल्‍न्‍या ङा ङाकुइत ज़ लिज़्‍या। निताव य़ेन दान्‍या परमेस्‍वर ङाबाबुए ज़ ङालाई याद नैनाव।” ");
INSERT INTO kjl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","आव पाँत यहूदीर या याल माखैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ख्वाराए, “आवलाई माचाव पुरूसए क्‍योःद बो·लैद नैव। काराव नितावए ओपाँ जेथैज़्‍याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ख्वाराए फरी, “इताव पाँ कै जैद बूलिउ मिँए ओपाँ ओताज़्‍याव? माचाव पुरूसए सुलाई ज़ रँःधुन्‍या माराजैव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","हाः बेलाक यरूसलेमलाव ध्‍यान झ़िमलाई चोखोइन्‍या पर्ब हुद उलिज़्‍याव। नो पर्ब सालकाव तखेप य़ुँदाक ओताज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","नो बेलाक येसु ध्‍यान झ़िम जींलाव सोलोमन मैराल उलिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","यहूदीर ओल्‍योक गुरिगाँ हुद, “नँ साचो ख्रीस ताकिन गेलाई छर्लङ्ग ज़ है दासिके। खा पै गेलाई आदा तान्‍यानी होदा तान्‍याल ननैसिरिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","येसुए, “जेलाई ङ़ादाकिन ज़ है दाव ज़ ङानैचिज़्‍या, हितावत ब जेयुँ ज़ माहुबे। ङाबाबुए उमिननी ङादोज़्‍याव य़ेनराए ज़ ‘ङा हो ज़’ लिद सतैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","खाली जे ङाबगाललावर जेमातावए ज़ ङालाई जेयुँ माहुबे। ");
INSERT INTO kjl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ङाबगाललाव बेधाराए ते ङार्गा थैज़्‍यार। ङा नोरालाई ङारासरेस्‍ज़्‍या, नोर मनी ङाछींत हुज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ङा नोरालाई अजम्‍बरी जुनी ङाराएज़्‍या। है जैद नोर खर्क ज़ कै मै तान्‍या मालेर। ङाल्‍योनी सुए मनी नैंद लाँधुन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","नोरालाई ङाकुइत याज़्‍याव परमेस्‍वर ङाबाबु बनै ओसक्ती ल्‍यो प़ाइँरानी घेप्‍पा लिज़्‍या। है जैद नोए ओल्‍योनी ब सुए ज़ नैंद लाँधुन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ङाबाबुस गिन तोबो ज़ गिन्‍लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदीराए आव पाँ थैद यारिसए लुँर तीद येसुलाई झेःव यापैंज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","येसुए, “ङाबाबुए ल्‍योनी चाव य़ेनर जेङ़ाक कुधु ज़ सतैंद ङायाचिके, नो भरिनी काताकाव य़ेनए उजूँनी लुँए झेःव जेपैंज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदीराए, “नँलाई चाव य़ेनए जूँनी झेःव गेपैंज़्‍याव माःक, परमेस्‍वरए उमिन नबले·ज़्‍यावए जूँनी ची। नँ मिँ ताद कै जैद परमेस्‍वरस सम सम नजैसिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","येसुए, “जेधर्मसास्‍त्रल परमेस्‍वरए है लिज़्या — ‘जे मिँर ईस्‍वर मितावर ज़।’ ");
INSERT INTO kjl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","धर्मसास्‍त्रलाव सर्सिउ पाँ अऩाकलाव माले लिन्‍या जे मनी जेसैंज़्‍या। है जैद परमेस्‍वरए ओल ओपाँ दैवरालाई ईस्‍वर मितावर ज़ है ओरादोकिन, ");
INSERT INTO kjl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ङाबाबुए ङालाई खतैद आव मानुवात उपरींनावए, ‘ङा परमेस्‍वरए ओज़ा ज़’ है ङादाचिक, जे कै जैद ‘परमेस्‍वरए उमिन नबले·ज़्या’ है जेदाँज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ङा ङाबाबुए ओय़ेन ङामादोज़्‍याव ताकिन जे ङालाई जेमापतिनादी ब ताए। ");
INSERT INTO kjl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","फरी नो य़ेन ङादोज़्‍याव ताकिन ङालाई जेमापतिनादी ब, ङादोज़्‍याव य़ेनत ते जेयुँ हुबो ज़ परिके। हो ताकिन ची परमेस्‍वर ङाबाबु ङास लिद तोबो ज़ गिन्लिज़्‍याव सैंद थ·रैन्‍या जेले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","नोर झन नो पाँ थैद फरी ब येसुलाई क्‍योःव पैंकेर। येसुए फरी नोराए ल्‍योनी छाँसिद याखार्नी ज़ पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","नकिन येसु ननी पुलुस्‍द यर्दन भै होफताव यूहन्‍नाए ङ़ादा ऱीनी ओरासछैंज़्‍याव पोङ ज़ लिनाके। ");
INSERT INTO kjl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","नक मिँर येसुए ल्‍योक बनै माहोल्‍या हुद, “यूहन्‍नाए ते अचम्‍बलाव य़ेनर काता ज़ मादोव। हैदी ब आव मिँए उजूँनी ओपाँव पाँ भरी साचो ज़ ओल्‍यो,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","नलावर कुधु ज़ येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","नाः बेलाक बेथानिया नाखारल तोबो लाजरस यादोज़्‍याव मिँ ओजोरो हुद थलिद उलिज़्‍याव। नो मिँ मरियम स़ोनो मार्थानी निभाइ ज़। ");
INSERT INTO kjl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","नो मरियम ज़ छींनी येसुलाई उखँत म़ास थीद्याद ओचेमए सीद्याज़्‍याव। नो ओजोरो हुव लाजरस नोए ओभाइ ज़। ");
INSERT INTO kjl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","नोए ओनानानी येसुलाई, “प्रभु, नयुँलाव लाजरस ओजोरो हुद थलिद ले,” है लिद तोबो सोर परींकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","येसुए नो सोर थैद, “आव जोरोए लाजरसलाई सिउका सिउ जैन्‍या माले, परमेस्‍वर ङाबाबुए उमिन झन ज़ सघ्‍योःन्‍याए जूँनी ची। ङा ओज़ाए ङामिन मनी झन ज़ घ्‍योःन्‍या ले,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","येसुए मार्था, मरियम स़ोनो लाजरसरालाई बनै मया ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","निताव ओजोरो उहुज़्‍याव सोर थैद ब हतप्‍त ज़ माबाद नो उलिज़्‍याव पोक ज़ अझ ऩेला लिके। ");
INSERT INTO kjl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","नकिन येसुए उसिसरालाई, “गे फरी यहूदियादा गेबा,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","उसिसराए, “गुर्बा, ताला नलाव यहूदीराए नँलाई लुँए झेःव यापैंज़्‍यावत ब काराव फरी नदा ज़ बाव नपैंज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","येसुए, “तछात बाह्र घन्‍ता पलाँ ताज़्‍या। लाक बाज़्‍याव मिँ आव मानुवाताव ज़गै ओलस ओतावए कान्‍त ज़ मात़ुमे। ");
INSERT INTO kjl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","रील बाज़्‍याव ते, ओलस ज़गै ओमातावए त़ुम्द पाज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","नकिन फरी, “गेनैं लाजरस घेप्‍पा ङ़लत बाद ले, ङा नोलाई ङासोचोइनारिज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","उसिसराए, “प्रभु, अइज़ घेप्‍पा ङ़लत उलिज़्‍याव ताकिन ते, जुनी ब गराँया ज़,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","खास येसुए ते लाजरस उसिधुवए उजूँनी ज़ ओपाँज़्‍याव, उसिसराए माबुझिद साचो ङ़ल्‍द उलिज़्‍याव ज़ याजैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","है जैद येसुए छर्लङ्ग ज़ है यादोक्‍यो, “लाजरस सिधुके। ");
INSERT INTO kjl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","खाली जे जेयुँ झन ज़ सुहुप्‍द्यान्‍याए जूँनी हतप्‍त ङामाबाव चाव ज़ ताके। अब ते हुचिके, लाजरसए ल्‍योदा गेबा,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","दिदुमस यादोज़्‍याव थोमाए ओलसकाव येसुए उसिसरालाई, “दे च्‍याँःसिचिके, गेबा। गेलाई मनी ओलस ज़ यासैःसिकिन्‍दा सैःसिकेर ब!” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","येसु उसिसरास लाजरसए ओनाखारल याकेस्‍नाक, लाजरसलाई खादरल याझाःव चार दिन ताके है लिन्‍या थैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","लाजरस ओनाखार बेथानिया यरूसलेमकिन स़ोंकिलोमितरवा उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","निभाइ उसिउए मार्था स़ोनो मरियमनिलाई यहूदीराए कुधुए याराचिऊहुज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","मार्थाए, ‘येसु हुज़्‍या दी’ लिन्‍या थैद मरियमलाई झ़िमक ज़ ख्यानैद येमङ ज़ दैसिनाद, ");
INSERT INTO kjl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","येसुलाई, “प्रभु, नँ नल्‍यो ताकिन ते ङाभाइ सिन्‍या ओमाल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","हैदी ब आख मनी नँ परमेस्‍वरस जो नऩिज़्‍या हो ज़ यान्‍या ले लिन्‍या ङासैंज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","येसुए, “नभाइ फरी ब सोन्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्थाए, “हैज़ प्रभु, परमेस्‍वरए मिँरालाई अजम्‍बरी जुनील ओरासोचोइव छ्याम नो मनी सैंसिद सोन्‍या ले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","हाःत ज़ येसुए, “सिउरालाई सोचोइज़्‍याव ब ङा ज़, अजम्‍बरी जुनी याज़्‍याव ब ङा ज़। है जैद जोए ङालाई उयुँ हुप्‍ज़्‍या, हो उसिदी ब फरी सैंसिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ङालाई यायुँ हुप्‍द बाँचिन्‍यार ते खर्क ज़ सिन्‍या मालेर। आव ङापाँत नयुँ माहुप्‍ज़्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्थाए, “हैज़ प्रभु, नँ आव मानुवात हुरिज़्‍या है यालिज़्‍याव परमेस्‍वरए ओज़ा ख्रीस ज़ लिद ङायुँ हुबो ज़ लिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","उझ़िमदा बाद ओबैंनी मरियमलाई अलगज़ा खुल्‍द, “गुर्बा आल हुद ले, नँलाई साप्‍निज़्‍याव,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","मरियम हतप्‍त ज़ च्‍याँःसिद दैसिनाके। ");
INSERT INTO kjl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","हाःपै येसु नाखारल ओमाहुताव, मार्थाए ओख्यानैव पोक ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","नो झ़िमक लिज़्‍याव चिऊना हुव यहूदीर मरियम थर च्‍याँःसिद ओबाज़्‍याव रँःद, ‘फरी खादरक ओघर्नाज़्‍याव ताक्‍या’ लिद उछीं उछीं बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","मरियम येसुए ल्‍योक केस्‍द उखँत फुलुप्‍सिद, “प्रभु, नँ नल्‍यो ताकिन ङाभाइ सिन्‍या ओमाल्‍यो,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","घर्के। उछीं उछीं हुव यहूदीर मनी ओलस ज़ याघर्ज़्‍याव। येसुए निताव रँःद उयुँ बनै माचाव दाद, ");
INSERT INTO kjl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“नोलाई काङ्क झाःद जेनैज़्‍याव?” है ओरादोक ते, “हुद चिऊके, प्रभु,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","हाःत ज़ येसु मनी घर्के। ");
INSERT INTO kjl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","नो रँःद नलाव यहूदीराए, “लाजरस बनै उयुँलाव मिताव मिँ ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ख्वाराए फरी, “आव मिँ मारँःधुन्‍यालाई रँःधुन्‍या जैज़्‍यावए लाजरसलाई ओमाबाँचैधुव रो?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","हाःत ज़ येसु उयुँर धो थाइव ताद खादरक बाके। नो खादर तोबो पुप ओल्‍यो, ओयाःत बनै घ्योःव लुँ कसिउ उलिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","येसुए, “नो कसिउ लुँ हाइचिके,” है ओरादोक ते, लाजरसए ओनाना मार्थाए, “आवलाई गेगादैव चार दिन ताधुके, प्रभु। गेफैकिन उसी ङर्न्‍या ले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","येसुए, “नँलाई नयुँ उहुप्‍किन परमेस्‍वरए ओज़गै रँःन्‍या नले है ङादींव माःक रो?” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","उपुर्कावराए नो कसिउ लुँ हाइकेर। हाःत ज़ येसुए नमदा परमेस्‍वरए ल्‍योदा भाल्‍सिद, “अ परमेस्‍वर ङाबाबु, नँलाई धन्‍याबाद लिज़्‍या, आव ङाबिन्‍ती नथैधुके। ");
INSERT INTO kjl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ङापाँ भरी थैव ज़ ननैज़्‍या लिन्‍या ङासैंज़्‍या। खाली आक लिज़्‍याव मिँराए आव ङापाँ थैद नँ ज़ नपरींनाव घथ·रैनारक लिद है ङादींज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","येसु बनै चोइस क़िद, “लाजरस, ननी पुलुस्‍द हुन्‍के,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","नो सिउ लाजरस ओङ़ैनी उखँङ पै लुम्‍बैसिउ क्‍वारास पुलुस्‍के। हाःत ज़ येसुए नक लिज़्‍यावरालाई, “ओक्‍वार पला·द्याद बाव एचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","निताव रँःद नो मरियमलाई चिऊना हुव यहूदीराए मनी कुधुए ज़ येसुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ख्वाराए फरी येसुए ओदोव य़ेन भरी रँःद फरिसीरालाई है यारादोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","नो फरिसीर स़ोनो मुख्या पुजारीराए घ्योःव कचरी जैद, “गे कै लिन्‍या ओताव? आवए ते कुधु अचम्‍बलाव य़ेनर दोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","नोलाई मावैंद दोव गेएकिन, मिँ भरी ओपो·स ज़ नोलाई यायुँ हुप्‍द ओल्‍योदा बान्‍या लेर। नदा याबाकिन रोमी सरकारए उसिपाईंर हुद गेध्‍यान झ़िमलाई तैःद्याद गे यहूदीरालाई मनी खेम्‍न्‍या ओछ्यास लिज़्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","हाःत ज़ कैयाफा यादोज़्‍याव हो साललाव प्रधान पुजारीए, “जे काता ज़ मासैंन्‍यार जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","गेदेस भरी उमिन ओम़ाज़्‍याव देखा बुरू प़ाइँए जूँनी तोबो मिँ सिन्‍या लेखा लिज़्‍या लिन्‍या जेमासैंए रो?” है लिके। ");
INSERT INTO kjl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","नोए निताव ओपाँव ओलनी ते माःक। येसुए यहूदी जातलाव मिँराए जूँनी उजिउ झाःद याएरिज़्‍याव लिन्‍या परमेस्‍वरए ङ़ादा ज़ नो प्रधान पुजारीए ओयाःत झाःद ओयोनी ज़ ओपाँव ची। ");
INSERT INTO kjl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","येसुए उजिउ ओझाःरिज़्‍याव यहूदीराए जूँनी वाज़ माःक, संसार भरिलाव काना कुनीङ लिज़्‍याव परमेस्वरए उमिनतावरालाई तोबो ज़ जैन्‍याए जूँनी ब ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","हो छ्यामकिन ज़ येसुलाई कातानी सैःन्‍या लिद गुमुस्‍ता दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","है जैद हाःकिन येसु यहूदियाल मासरैंःसिद ननी पुलुस्‍द उसिसरास बन छ्योकाव एफ्राइम यादोज़्‍याव नाखारल लिनाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","हाः बेलाक यहूदीराए यामानिज़्‍याव निस्‍तार पर्ब हुनाद उलिज़्‍याव। है जैद नो पर्बए जूँनी मिँर ङ़ादा ज़ नाखार नाखारनी यरूसलेमल बाद हुर्सिद याचोखोइसिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","नोर ध्‍यान झ़िमल याहुवत येसुलाई मारँःद या याल ज़, “जे कै जेलिज़्‍या, नो मिँ आव पर्बल जाँ ओमाहुरिज़्‍याव सा,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","फरिसीर स़ोनो मुख्या पुजारीराए येसुलाई क्‍योःन्‍याए जूँनी ङ़ादा ज़ नल हुवरालाई, “येसुलाई जेरँःकिन गेलाई है दासिच्‍यो,” है दाद यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","येसु निस्‍तार पर्बकिन छ दिन ओङ़ाल बेथानियाल बाके। नल नो सिउनी ओसोचोइव लाजरसए ओल्‍योक ज़ लिनाके। ");
INSERT INTO kjl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","नोराए येसुए उजूँनी ऱिमकाव ज़्‍यावर थिक थाक जैद मार्थाए ज़्‍यावर भाःद ओराएज़्‍याव। लाजरस फरी येसुस ज़्‍यान्‍याए जूँनी च़ुसिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","हाः बेलाक मरियमए बनै ओएः ल्‍यो चाव सी ङरो जतामसीए म़ास तर्‍या·वा रैद येसुए उखँत थीद्याद ओचेमए सीदिक्‍यो। झ़िम भरी ज़ बनै चाव सी फाँ फाँ ङर्के। ");
INSERT INTO kjl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","नाःत ज़ छींनी येसुलाई धोका याज़्‍याव उसिस यहूदा इस्‍करियोतए, ");
INSERT INTO kjl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“बुरू आव म़ास स़ोंसय चाँदीए सिक्‍काल यो·द काता ज़ माल्‍योरालाई भाःद ओराएकिन तान्‍या ओल्‍यो,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","खाली नोए माल्‍योराए जूँनी उयुँ नाद है उलिज़्‍याव ते माःक, ओल कुन्‍याए जूँनी है उलिज़्‍याव ची। याखार्ताव पैसा ओल ज़ ओनैज़्‍याव, ननी कुव य़ेन ओदोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","हाःत ज़ येसुए, “घदोज़्‍यावक। ङालाई गादैन्‍या छ्यामकावए जूँनी सामा दाद ओनैव ची। ");
INSERT INTO kjl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काता ज़ माल्‍योर ते जेस एकतार ज़ लिज़्‍यार, ङा ते जेस एकतार लिन्‍या ङामाले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","येसु नक लिज़्‍या दी लिन्‍या थैद नजीलाव यहूदीर कुधु ज़ ओल्‍योक हुकेर। नोर येसुए उजूँनी वाज़ याहुव माःक, नो सिउनी ओसोचोइव लाजरसलाई चिऊन्‍याए जूँनी ब हुद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","है जैद ज़ मुख्या पुजारीराए लाजरसलाई ब सैःव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काराव ल्‍यो ताकिन येसुए नोए ओक्‍याँताव ओदोव य़ेननी ज़ यहूदीर कुधु ज़ मुख्या पुजारीरालाई ऱास्‍द येसुलाई यायुँ हुप्‍नाके। ");
INSERT INTO kjl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","हो पराःती नो पर्बत हुव माहोल्‍यार ‘येसु यरूसलेमल हुज़्‍या दी’ लिन्‍या थैद, ");
INSERT INTO kjl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","नोराए खजुर सींए ओस्‍यावलार रैद येसुस दैसिनाद, “होसन्‍ना! परमेस्‍वरए उमिनत हुव इस्राएलीराए याराजा धन्‍याकाव ओताक,” है लिद क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","येसु तोबो गधाहाए ओबछेरा चेप्‍द उहुज़्‍याव। नोए उजूँनी धर्मसास्‍त्रल इताव सर्सिउ उलिज़्‍याव, ");
INSERT INTO kjl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ताछे·नी सियोनए ओज़ा, नराजा गधाहाए ओबछेरा चेप्‍द हुज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","नो बेलाक येसुए उसिसराए नो पाँर माबुझिधुकेर। येसु स्‍वर्गत ओल्‍द ओबाव छींनी वाज़ नो धर्मसास्‍त्रलाव सर्सिउ पाँर चेतैद ‘नो पाँ गेसयो·धुव ची ओल्‍यो’ लिन्‍या सैंकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","नो माहोल्‍यारानी जो जोराए येसुए लाजरसलाई खादरनी क़िद सिउनी ओसोचोइव रँःद नैर, होराए प़ाइँलाई ज़ है यारादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","होए उजूँनी ज़ येसुए नाःल्‍दिउ य़ेन ओदोव ओल्‍यो लिन्‍या थैद निताव ल्‍यो माल्‍यो मिँर ओलस दैसिहुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","निताव रँःद फरिसीर या याल, “आव मानुवाताव मिँ भरी ओपो·स ज़ नोए ओपाँत बाज़्‍यार, गे ते अबकिन नोस कातानी ज़ गेमाधुके ब,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","नो पर्ब मानिना हुवर ख्वार ग्रीक यारादोज़्यावर मनी याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","नोर गालीललाव बेथसेदा नाखारलाव फिलिपए ल्‍योक बाद, “अ स़ेर, गे येसुस तखेप दैसिउ गेपैंज़्‍या,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिपए नो पाँ फरी अन्‍द्रियासलाई मनी है दोक्‍यो। है जैद नोनी ऩेब्‍लो ज़ येसुए ल्‍योक बाद नो पाँ है दोकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","नाःत ज़ येसुए नक लिज़्यावरालाई, “अब ते परमेस्‍वरए ङा मिँ मिन्‍सिउए ङामिनलाई सघ्योःद्यान्‍या बेला हुके। ");
INSERT INTO kjl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ङा जेलाई साचो है ङादाचिज़्‍या, तोबो तामए ओसै गमल बाद ओमासिवा पै हाःकाव ज़ लिज़्‍या। गमल बाद उसिउत वाज़ कुधु ओसै झाःज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","हिताव ज़ जोए उजिउए मया दोज़्‍याव, होए उजुनीलाई सम़ैज़्‍याव। फरी जोए आव जुनील उजिउए मया मादोव, होए उजिउलाई अजम्‍बरी जुनीए जूँनी जोगोइद नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","जोए ङासेवा दोव पैंज़्‍याव, हो ङाछींत उहुक। हो ताकिन ची ङा जोङ जोङ ङाताज़्‍या, नो ङासेवा दोज़्‍याव ब होङ ङास ज़ तान्‍या ले। जोए ङासेवा दोज़्‍याव, होलाई परमेस्‍वर ङाबाबुए मनी ओमान नैद्यान्‍या ले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","हाःत ज़ फरी, “ङा आख बनै धो थाइव ताद ङाले। ङा कै लिन्‍या? सैं ङाबाबुलाई, ‘अ बाबु, आव ङाक्‍याँत हुरिज़्‍याव दुखरानी जोगोइनाके,’ है दान्‍या ओताव? हिताव ते माता, ङा नो दुखर सहिद सयो·ना ङाहुव ची,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“अ बाबु, अब ते घ्‍योःव नमिन सरैंःके,” है लिद ओपोंखारिउ प़ाइँना नमतिन तोबो गाए, “ङामिन ते ङासरैंःधुके, फरी झन ज़ सरैंःन्‍या ङाले,” है उलिज़्याव थास्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","नक लिज़्‍याव माहोल्‍याराए नो गा थैद ख्वाराए ‘नम गर्जिज़्‍या’ है लिकेर, ख्वाराए फरी ‘येसु परमेस्‍वरए ओचाकर्‍यास ओपाँज़्‍याव ची’ है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","हाःत ज़ येसुए, “आव जेथैव गा ङा ङाजूँनी माःक, जे ङालाई सरेस्‍न्‍याए जूँनी ची। ");
INSERT INTO kjl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अबकिन आव मानुवाताव मिँर फाल्‍सिरिज़्‍यार, यास़ेर सैतान मनी ख्यासिद उमिन म़ारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","स़ोनो ङा आव नामनी छींसिद ङातङ्गैसिउत प़ाइँ मिँरालाई ङाल्‍योदा ङारारैरिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","नो है ओल्‍यो भरी ओल उसिरिज़्‍यावए जूँनी ज़ ओपाँव। ");
INSERT INTO kjl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","नो माहोल्‍याराए, “धर्मसास्‍त्रल गेचिऊक नो बाँचैना हुरिज़्‍या है यालिज़्‍याव ख्रीस खर्क ज़ सिन्‍या माले लिन्‍या लिज़्‍या। नँ कै जैद मिँ मिन्‍सिउ तङ्गैसिद सिरिज़्‍या है नलिज़्‍याव? नो मिँ मिन्‍सिउ सु?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","येसुए, “अझ छ्यावा पै वाज़ ङाज़गै जेखार्ल रहिरिज़्‍या। नो ज़गै जेखार्ल ओलेवा भरी नो बेला ताचुकैच्‍यो, म़ानी चुम चुमोल जेपरिया। नल जेपरिकिन ‘आदा ङाबाज़्‍या’ लिन्‍या ब सैंन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","है जैद नो ज़गै उलिज़्‍याक ज़ ज़गैवलाई जेयुँ उहुप्‍क। हो ताकिन ची ज़गैवए ओथोर जेतारिज़्‍या,” है दाद येसु ननी पुलुस्‍द सम़ैसिनाके। ");
INSERT INTO kjl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","येसुए मिँराए ङ़ाक अचम्‍ब अचम्‍बलाव य़ेनर दाद ब नोराए यायुँ ज़ माहुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ननी ज़ यसैया अगमबक्ताए ओसरो यो·के। नोए ओसरो आव ज़, “प्रभु, गेरासथैव पाँत सुए यायुँ ज़ माहुप्‍के। परमेस्‍वरए सतैंद ओरायो ओसक्तीलाव य़ेनर ब सुलाई ज़ माताके।” ");
INSERT INTO kjl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","नितावनी ज़ नोराए यायुँ माहुप्‍के। यसैयाए फरी ब तोथोल अइ लिद सर्द नैव, ");
INSERT INTO kjl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“परमेस्‍वरए नोरालाई मुन्‍दुक्‍यासो जैद यानैव, यायुँ ब बनै खाव जैद नैद यायो। है जैद ज़ यामी लिज़्‍यावत ब मारँःधुर, थैद ब यायुँल मातीधुर। ननी ज़ नोर ङाल्‍योदा यायुँ फर्कैद सगराँसिना माहुर।” ");
INSERT INTO kjl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसैयाए ङ़ादा ज़ ख्रीसए ओज़गै रँःद आव पाँ भरी ख्रीसए उजूँनी ज़ सर्द ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","हैदी ब यहूदीराए यास़ेरर कुधुए यायुँ हुप्‍के। खाली ‘धर्मसास्‍त्र झ़िमनी फरिसीराए पले·सिर्‍या’ लिद याछ्याचेए पाखात मापाँधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","नोराए परमेस्‍वरनिकाव दैन्‍या स्‍याबासकिन मिँनिकाव दैन्‍या स्‍याबास घ्‍योःव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","हाःत ज़ येसुए बनै चोइस अइ लिद यासथैक्‍यो, “जोए ङालाई उयुँ हुप्‍ज़्‍या, होए ङालाई वाज़ माःक, ङालाई परींज़्‍यावलाई मनी उयुँ हुप्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","हिताव ज़ फरी ङालाई रँःज़्‍यावए ङालाई परींज़्‍यावलाई ब रँःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ङा आव मानुवाताव ज़गै ताद ङाहुके। ङालाई यायुँ हुप्‍न्‍यार चुम चुमोल तान्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","फरी ङापाँ थैद माभैंःज़्‍यावरालाई ङा याखत पले·द्याव मापरिए। ङा आव मानुवाताव मिँरालाई याखत पले·द्याद सजा याना ङाहुव माःक, बाँचैना ङाहुव ची। ");
INSERT INTO kjl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","हैदी ब ङालाई सोद ङापाँ माभैंःज़्‍यावरालाई याखत सतैंद्यान्‍या ङापाँ ज़। नो ङापाँ ओमाभैंःवए, फाल्‍सिन्‍या छ्याम ननी ज़ फाल्‍सिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","नो ङापाँ ङानी सिर्जैद ङापाँव माःक, ङालाई परींज़्‍याव ङाबाबुए ‘आव पाँनिके’ है ओदाँव ची। ");
INSERT INTO kjl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ओल ङालाई पाँव उपरींनाव भरी अजम्‍बरी जुनी यान्‍या लिज़्‍या। है जैद ङापाँज़्‍याव भरी परमेस्‍वर ङाबाबुए है ओदाँव वाज़ ङापाँज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","निस्‍तार पर्बए ओङ़ादा येसुए, ‘आव मानुवानी पुलुस्‍द परमेस्‍वर ङाबाबुए ल्‍योदा बान्‍या बेला ताके’ लिन्‍या सैंक्‍यो। ओमासिवा पै आव मानुवाताव ओल उमींरालाई मया दाव ज़ ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","हो छ्याम ऱिमक येसु उसिसरास ज़्‍यावर याज़्‍युज़्‍यावकिन ङ़ादा ज़ सिमोनए ओज़ा यहूदा इस्‍करियोतए उयुँल सैतानए येसुलाई धोका यान्‍या युँ जैद नैद ओएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","हाःत ज़ येसुए उयुँल, ‘परमेस्‍वर ङाबाबुए प़ाइँ ङाकुइत ज़ याद नैनाव, ओल्‍योनी ज़ ङाहुके, फरी ओल्‍योदा ज़ ङाबारिज़्‍या’ है लिन्‍या ओसैंज़्‍यावए, ");
INSERT INTO kjl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","उसिसराए याङ़ाक नो ज़्‍यान्‍यार याज़्‍युज़्‍याव बेलाक ज़ याखार्नी च्‍याँःसिद ओबर्की हाइद रूमाल भिरिसिद, ");
INSERT INTO kjl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तोबो जाल ऱी झाःद, उसिसराए याखँर हुर्द्याद नो उभिरिसिउ रूमालए ज़ याखँर सीद ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","है जैद याखँर हुरे हुरे सिमोन पत्रुसए ल्‍योक उहुवत पत्रुसए, “प्रभु, नँ कै जैद इतावए ङाखँ हुर्द्याव नपैंज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","येसुए, “आव ङादोज़्‍याव य़ेन आख ते नमासैंए, छींनी नसैंया,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","फरी ब पत्रुसए, “नँ ङाखँ खर्क ज़ हुर्द्यान्‍या माताए,” है ओदोक ते, येसुए, “नँ नखँ हुर्द्याव भैंःद नमायाँकिन नँ ङासकाव तान्‍या नमाले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","हाःत ज़ सिमोन पत्रुसए, “हो ची ताकिन्‍दा प्रभु, ङाखँ वाज़ माःक, ङाकुइर ङाङ़ैर ब हुर्द्याव ताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","येसुए, “हुर्सिउ मिँ ओक्‍याँ भरी छैंव ओतावए उखँ वाज़ हुर्द्याकिन ताए। जे भरी प़ाइँ छैंवर ज़ जेलिज़्‍या। हैदी ब जेखार्ल तोबो ते माछैंव लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","येसुए ओललाई धोका याव पैंज़्‍याव मिँलाई ङ़ादाकिन ज़ सरेस्‍द ओनैज़्‍यावए नो माछैंवए उजूँनी ज़ पाँके। ");
INSERT INTO kjl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","येसुए याखँ हुर्द्याद ङ़ादाङाव ओहाइव ओक्‍वार जासिद फरी यास ज़ ज़्‍यान्‍याल च़ुसिद है यादोक्‍यो, “आव जेखँ हुर्द ङायाचिउ य़ेनए ओअर्थ जेमासैंज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","जे ङालाई ‘गुर्बा’ स़ोनो ‘प्रभु’ है जेदाँज़्‍याव, नो ते थिक ज़। है जेलिज़्‍याव मिताव ङा हो ज़। ");
INSERT INTO kjl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","खाली ङा जेप्रभु जेगुर्बा ताद जेखँ हुर्द ङायाचिज़्‍या ल्‍यो ताकिन जे मनी तोबोए तोबोलाई उखँ हुर्द्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ङा ङादोज़्‍याव मिताव य़ेन जे मनी ‘जेदोया’ लिद नो य़ेन जेङ़ाक सतैंद नैद ङायाचिए। ");
INSERT INTO kjl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ङा जेलाई साचो है ङादाचिज़्‍या, छुतए ओय़ेन दाज़्‍याव मिँ ओसाहुकिन घ्योःव माताए। हिताव ज़ य़ेनदा परींसिउ मिँ परींज़्‍यावकिन घ्योःव माताए। ");
INSERT INTO kjl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","है जैद जे आव ङापाँर तीद ननी ज़ जेदोकिन असिक दैवर तान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“खाली आव पाँ प़ाइँए जेजूँनी ते माःक। हैदी ब ङाछाँतिचिउ भरिलाई ते ङा ज़ ङासरेस्‍चिज़्‍या। आव पाँ धर्मसास्‍त्रलाव सर्सिउ पाँ सयो·न्‍याए जूँनी लिज़्‍या। नलाव सर्सिउ आव ज़, ‘ङास सिप ज़्‍युज़्‍याव ज़ ङाकिन तँदा जैसिरिज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","आव पाँ भरी ओमाहुद ङ़ादा ज़ है दाद ङानैचिज़्‍या। हो ताकिन ची नो पाँ भरी ओतावत ङालाई ‘हो ज़ ची ओल्‍यो’ लिद सरेस्‍न्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ङा जेलाई साचो है ङादाचिज़्‍या, जोए ङापरींव मिँलाई ओल्‍योक हुव एज़्‍याव, होए ङालाई मनी हुव याँज़्‍याव। ङालाई वाज़ माःक, ङालाई परींज़्‍यावलाई ब हुव एज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","नाः है दाद येसुए उयुँर धो थाइव ताद ओपाँ भरी काता ज़ माम़ोंद उसिसरालाई, “ङा जेलाई साचो है ङादाचिज़्‍या, जेनी तोबोए ङालाई धोका याँरिज़्‍याव,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","‘काताकाव गेताव’ लिद उसिसर या याल चिऊसिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","नो बेलाक येसुए उयुँलाव मिताव तोबो उसिस ओक्‍याँत खदेप लिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","सिमोन पत्रुसए नोलाई सान दाद्याद, “नो सु है दोसाँ,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","नोए येसुए ओक्‍याँत कँ लिद, “प्रभु, नो सुकी?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","येसुए, “आव भरेस जोलाई चिपल छोइद ङाएज़्‍या, हो ज़,” है दाद नो भरेसलाई केःद छोइद सिमोन इस्‍करियोतए ओज़ा यहूदालाई एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","भरेस ओक्‍योःव प़ाइँना ज़ सैतान उयुँल पसिके। है जैद येसुए नोलाई, “नँ दान्‍या नपैंज़्‍याव चाँदो ज़ दोके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","नो ज़्‍यान्‍याल च़ुसिद लिज़्‍यावराए, ‘काताए जूँनी नै ओल्‍यो?’ लिन्‍या मासैंकेर। ");
INSERT INTO kjl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ख्वा ख्वाराए, याखार्ताव पैसा यहूदाए ओक्‍याँत उलिज़्‍यावए, “पर्बए जूँनी कातार लँःनाव उपरींज़्‍याव ताक्‍या, सैं काता ज़ माल्‍योरालाई पैसार यानाव उपरींज़्‍याव ओताव,” लिन्‍या सम्‍जिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","यहूदा नो भरेस ज़्‍याद बेहार ज़ पुलुस्‍के। नो बेलाक री ताद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","इस्‍करियोत उपुलुसो छींनी येसु ओल उजूँनी अइ लिद पाँके, “अब ते मिँ मिन्‍सिउए उमिन ब रैंःरिके, परमेस्‍वरए उमिन ब नोए ओक्‍याँनी झन ज़ रैंःन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","परमेस्‍वरए उमिन नोए ओक्‍याँत रैंःन्‍या ओतावए, ओल परमेस्‍वरए मनी नोस उलिज़्‍याव सरैंःन्‍या ले। नो य़ेन परमेस्‍वरए हतप्‍त ज़ दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","अ ङाबाबुज़ार, अब ङा जेस कोसै लिन्‍या ङामाले। ङाबाव छींनी जे ङालाई खिम्‍न्‍या जेले। खाली यहूदीराए यास़ेररालाई है ङारादोव मिताव जेलाई मनी है ङादाचिज़्‍या, ङा ङाबाव पोङ जे हुधुन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ङा जेलाई तोबो साःरो कानुन ङायाचिज़्‍या — जे जेल मया दासिच्‍यो। किताव ङा मनी जेलाई मया ङादाचिउ, हिताव ज़ जे मनी जे जेल मया दासिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","निताव जे जेल मया जेदासिकिन, ‘ङासिसर ज़ जेल्‍यो’ लिन्‍या प़ाइँए सरेस्‍न्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","हाःत ज़ सिमोन पत्रुसए, “प्रभु, नँ काना नबाज़्याव?” है ओदोक ते, येसुए, “आव बेलाक ते ङा ङाबाज़्‍यावदा नँ बाधुन्‍या नमाले, छींनी ते हुन्‍या ज़ नले,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पत्रुसए, “कै जैद प्रभु, ङा नँस माबाधुन्‍या? ङा नजूँनी सिन्‍या ब तयार ज़ ङालिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","येसुए, “हुकी, ङा ङाजूँनी नजिउ झाःद्यान्‍या तयार नलिज़्‍याव रो? ङा ते नँलाई साचो है ङादींज़्‍या, भाल्‍या ओमाकोद ज़ ङालाई स़ोंखेप ‘ङामासरेसे’ है दान्‍या नले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“जे जेयुँर तासतेच्‍यो, परमेस्‍वरलाई जेयुँ उहुप्‍क। ङालाई मनी जेयुँ उहुप्‍क। ");
INSERT INTO kjl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","परमेस्‍वर ङाबाबुए उझ़िमल लिन्‍या पो कुधु ज़ लिज़्‍या। हिताव ओमाल्‍यो ताकिन है मनी ङामादाचिखेहो। नो ङापाँ हैज़ ओतावए जेजूँनी जेपोर बनैनाद ङायाचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","जेजूँनी पोर स्‍यासी ङाजैवत ङा फरी जेलाई च़ाना ङाहुरिज़्‍या। हाःकिन जे ङाल्‍योक ङास सिप ज़ तान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ङा ङाबाज़्‍याव येम जे ब जेसैंज़्‍याखेहो।” ");
INSERT INTO kjl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","हाःत ज़ थोमाए, “प्रभु, नँ काना नबाज़्‍याव गे गेमासैंए, झन नो नयेम कै जैद गेसैंरिज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","येसुए, “येम ब ङा ज़, साचो पाँ ब ङा ज़, अजम्‍बरी जुनी याज़्‍याव ब ङा ज़। ङाकिन छुतनी सु ज़ ङाबाबुए ल्‍योङ माकेस्‍धुर। ");
INSERT INTO kjl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ङालाई जेसरेस्‍नाव ताकिन ङाबाबुलाई मनी सरेस्‍न्‍या जेल्‍यो। आकिन ते जे ङाबाबुलाई सरेस्‍न्‍या जेले, जेमीए ज़ जेरँःधुके।” ");
INSERT INTO kjl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","हाःत ज़ फिलिपए, “प्रभु, गेलाई परमेस्‍वर नबाबु सतैंद्यासिके, गेपैंज़्‍याव नाः ज़,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","येसुए, “ङा आःपै जेस ज़ लिज़्‍यावत ब नँ कै जैद नमासरेस्‍नाज़्‍याव, फिलिप? ङालाई रँःवए परमेस्‍वर ङाबाबुलाई ब रँःक्‍यो। कै जैद नँ ङालाई रँःद मनी ‘नबाबु परमेस्‍वरलाई सतैंद्यासिके’ है नदाँज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","‘ङा ङाबाबुस ङालिज़्‍या, ङाबाबु ङास लिज़्‍या’ लिन्‍या पाँत नयुँ माहुबे रो? ङा जेलाई है ङादाचिज़्‍याव पाँ भरी ङानी सिर्जैद ङापाँज़्‍याव माःक, ङाक्‍याँत लिज़्‍याव ङाबाबुए ओय़ेनर ङानी ओदोज़्‍याव ची। ");
INSERT INTO kjl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‘ङा ङाबाबुस ङालिज़्या, ङाबाबु ङास लिज़्या’ लिन्‍या पाँत जेयुँ उहुप्‍क। नो पाँत जेयुँ ओमाहुप्‍दी ब ङादोव य़ेननी ते जेयुँ सुहुप्‍चिके। ");
INSERT INTO kjl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“ङा जेलाई साचो है ङादाचिज़्‍या, ङालाई उयुँ हुप्‍ज़्‍याव मिँए ङादोज़्‍याव मिताव य़ेनर दोरिज़्‍याव। ङा ङाबाबुए ल्‍योदा बाद नोस ङालिरिज़्‍यावए होए झन नोकिन घेप्‍पा य़ेनर ब दोरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","जे परमेस्‍वरलाई ङा ङामिननी जो है जेदोदी ब नो य़ेन ङा सयो·द्यान्‍या ङाले। ननी ज़ परमेस्‍वर ङाबाबुए ओज़गै ओज़ाए ङाक्‍याँत रैंःन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","जे ङामिननी ङालाई कातार है जेदाँकिन नो दान्‍या ज़ ङाले। ");
INSERT INTO kjl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","जे ङालाई मया जेदाँकिन ङा है ङादाचिउ पाँर दान्‍या जेले।” ");
INSERT INTO kjl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“ङा ङाबाबु परमेस्‍वरलाई जेजूँनी तोबो है दाद ङायाचिरिज़्‍या। होए जेलाई सघैन्‍या तोबो परींद्याचिरिज़्‍याव। नो एकम्‍न्‍या जेस ज़ लिन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","नो सतलाव छैंव पुरूस ज़। नोलाई आव मानुवाताव मिँराए यामारँःव यामासरेसोए मादैधुर। जे ते जेस लिद जेक्‍याँत बास ओदोहुरिज़्‍यावए जेसरेस्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ङा जेलाई जेबाबु जेआमा माल्‍यो मितावर जैद ते ङामाख्यानैचिए। फरी जेल्‍योक ङाहुरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","छ्यावाकिन आव मानुवाताव मिँराए ङालाई रँःन्‍या मालेर, जे ते रँःन्‍या ज़ जेले। हाःकिन ङा खर्क ज़ मासिन्‍या ङातावए जे मनी सिउका सिउ तान्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","हो छ्याम, ‘ङा ङाबाबुस ङालिज़्‍या, जे ङास जेलिज़्या, ङा जेस ङालिज़्‍या’ लिन्‍या सैंन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जोए ङापाँ थैद दोज़्‍याव, हो ज़ ङालाई मया दाज़्‍याव मिँ। जोए ङालाई मया दाँज़्याव, होलाई ङाबाबुए मनी मया दोज़्‍याव। ङा मनी होलाई मया दाद ओल्‍योक सरैंःसिन्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","यहूदा इस्‍करियोतए माःक, छुत उसिस यहूदाए, “प्रभु, काराव आव मानुवाताव मिँराए ल्‍योक मासरैंःसिन्‍या, गेल्‍योक वाज़ सरैंःसिउ नपैंज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","येसुए, “ङालाई मया दाज़्‍यावए वाज़ ङापाँ दोज़्‍याव। ङाबाबुए मनी नोलाई मया ओदोज़्यावए गिन नोए ल्‍योक हुद नोस बास गिन्‍दोरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ङालाई मया मादाज़्‍यावर ते ङापाँ माभैंःर। हैदी ब नो जेथैज़्‍याव ङापाँ ङानिकाव माःक, ङालाई परींज़्‍याव ङाबाबु परमेस्‍वरए ल्‍योनी हुव ची। ");
INSERT INTO kjl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“आव पाँ भरी जेस ङालिज़्‍याक ज़ है दाद ङानैचिए। ");
INSERT INTO kjl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","छींनी परमेस्‍वर ङाबाबुए ङा ङामिननी जेलाई सघैन्‍या छैंव पुरूस परींद्याचिरिज़्‍याव। नो जेस लिद प़ाइँ पैचिरिज़्‍याव। आव ङापाँर मनी य़ाका दाव परींचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","युँ होलाँ तान्‍या ङाअसिक जेलाई याद ङाख्यानैचिरिज़्‍या। नो ङाअसिक आव मानुवातावराए यान्‍या मिताव ते माःक। जेयुँर सतेद ताछे·च्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ङा ङाबाज़्‍या, फरी ङाहुरिज़्‍या’ लिन्‍या ङापाँर थैव ज़ जेलिज़्‍या। जे ङालाई साचो मया जेदाँज़्‍याव ताकिन ङा ङाबाबुए ल्‍योदा ङाबारिज़्‍या है ङालिक जेरेंखेहो। नो ङाबाबु ङाकिन घ्योःव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","आव भरी ओमाताद ङ़ादा ज़ जेलाई है दाद ङानैचिए। नो ओताव जेरँःवत जेयुँ हुप्‍न्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","अब ते ङा जेस कोसै पाँव दैन्‍या ङामाले। आव मानुवातावराए यास़ेर सैतान हुनाके। उहुदी ब ङाक्‍याँत ओहक ते माले। ");
INSERT INTO kjl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","खाली आव मानुवाताव मिँराए, ङा ङाबाबुलाई मया दाद है ओदाँव भरी ङादोज़्‍याव घसैंरक लिद सरैंःद्याव ताके,” है लिद उसिसरालाई, “च्‍याँःसिचिके, गेबा,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ङा जोम्‍परसैए साचो ओजरा ज़, ङाबाबु जोम्‍परसैए ओर्गे ज़। ");
INSERT INTO kjl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ङाक्‍याँताव यासै माझाःज़्‍याव खार भरी ङाबाबुए यालो·ज़्‍याव। फरी यासै झाःज़्‍याव खार भरी झन ज़ घझाःवक लिद नत ताज़्‍याव तके दँ जोखारीर ब याच़म्‍ज़्याव। ");
INSERT INTO kjl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","हो मिताव ज़ जे ते है ङादाचिउ पाँए जेक्‍याँताव माचाव भरी हाइद ख्याद छैंवर जेताधुके। ");
INSERT INTO kjl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","है जैद जे ङास ज़ लिचिके, ङा जेस ज़ लिन्‍या ङाले। किताव जोम्‍परसैए ओखार ओक्‍याँत जोरैसिउ ओमालिकिन ओसै ब माझाःव, हिताव ज़ जे मनी ङाक्‍याँत जेमालिकिन जेसै ज़ झाःन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ङा जोम्‍परसैए ओजरा ज़, जे ओखारर ज़। जे नो खार माँःती ङाक्‍याँत जेलिकिन ङा मनी जेस ज़ तान्‍या ङाले। ननी ज़ बनै जेसै ल्‍योर तान्‍या जेले। ङा जेस ङामालिकिन जेनी काता ज़ दाधुन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ङाक्‍याँत मालिज़्‍यावर ते पल्‍द ख्यासिउ खार उथँव मिताव अऩाकलावर तान्‍या लेर। निताव खारर दुप्‍द मेंःल झाःद चुयाप जैन्‍या वाज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","खाली जे ङाक्‍याँत लिद ङापाँर भैंःद जेयुँल जेनैकिन, जो जेपैंदी ब दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","जे बनै जेसैर झाःद ङासिसर तान्‍या मितावर जेताकिन परमेस्‍वर ङाबाबुए उमिन ननी ज़ घ्योःन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“किताव ङाबाबुए ङालाई मया दाँज़्‍याव, हिताव ज़ ङा मनी जेलाई मया ङादाचिज़्‍या। है जैद जे ङामयाल ज़ लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ङापाँ भरी भैंःद जेदोकिन, जेल्‍योदा लिज़्‍याव ङामयाल ज़ लिन्‍या जेले। ङा मनी परमेस्‍वर ङाबाबुए ओपाँ भरी भैंःद दाद ङाल्‍योदा लिज़्‍याव ओमयाल ज़ ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ङाल्‍योनिकाव होलाँ तान्‍या युँ जेस ओताक, स़ोनो नो होलाँ तान्‍या प़ाइँत ओयो·क लिद आव पाँ भरी है दाद ङानैचिए। ");
INSERT INTO kjl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“जेलाई ख्यानैद ङायाचिज़्‍याव दान्‍या य़ेन आव ज़, किताव ङा जेलाई मया ङादाचिउ, हिताव ज़ जे मनी तोबोए तोबोलाई मया दासिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","नैं मेंए ल्‍योदा मया उलिज़्‍याव आनी ज़ रैंःज़्‍या — जोए ओनैंए उजूँनी उजिउ झाःज़्‍याव, हो ज़ प़ाइँरानी घेप्‍पा मया। ");
INSERT INTO kjl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जे है ङादाचिउ पाँल जेलिकिन, जे ङानैंर ज़ जेताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","आकिन ते जेलाई ङाबाँदार है ङामादाचिए। ओबाँदारालाई ते यासाहुए ओदाँजीं प़ाइँ सतैंद मारायो। ङा ते ङाबाबु परमेस्‍वरए ल्‍योनी ङादैव भरी ओपो·स ज़ सतैंद ङायाचिउए जेलाई ङानैंर है ङादाचिज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","जे फरी ङालाई जे जेछाँतिनाव माःक, बुरू ङा जेलाई थ॰रिन्‍या सैर ओझाःनारक लिद छाँतिद ङाखतैचिके। है जैद जे परमेस्‍वर ङाबाबुस ङा ङामिननी जेऩिउ भरी यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","फरी ब नो दान्‍या य़ेन ज़ ख्यानैद ङायाचिज़्‍या — तोबोए तोबोलाई मया दासिच्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“जेलाई आव मानुवाताव मिँराए यासोचिक नोकिन ङ़ादा ङालाई यासोनाव लिन्या य़ाका दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","जे आव मानुवानी तावर जेताव ताकिन आव मानुवाताव मिँराए गेमींर लिद मया दाचिखेरहो। खाली ङा जेलाई आव मानुवानी ङाछाँतिचिउए जे आव मानुवातावर माःक। है जैद मानुवाताव मिँराए जेलाई सोचिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ङ़ादा है ङादाचिउ पाँ आःपै य़ाका जेदोज़्‍याखेहो। छुतए ओय़ेन दाज़्‍याव मिँ ओसाहुकिन घ्योःव माताए। है जैद नोर ङाखिरी यापसिकिन जे जेखिरी ब पसिन्‍या लेर। हिताव ज़ ङा ङापाँ याभैंःव ताकिन जे जेपाँ ब भैंःन्‍या याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","खाली नोराए ङालाई परींज़्‍यावलाई यामासरेस्‍ज़्‍यावए जे ङामिनतावर जेतावए जेलाई दुख यान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ङा आव मानुवात परमेस्‍वरए ओपाँ ङामारासथैहुव ताकिन नोराए याखत ब माताखेहो। खाली अब ते नोरालाई काता निउँ ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ङालाई सोज़्‍यावराए ङाबाबु परमेस्‍वरलाई ब सोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","हिताव ज़ फरी सुए ज़ यामादोताव अचम्‍बलाव य़ेनर नोराए ङ़ाक ङामादोव ताकिन ननी ब याखत माताखेहो। खाली निताव य़ेनर रँःज़्‍यावत ब ङालाई यासोनाव प़ाइँना ङाबाबुलाई ब सोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","नोराए निताव याय़ेननी धर्मसास्‍त्रलाव सर्सिउ पाँ सयो·ज़्‍यार। नलाव सर्सिउ आव ज़, ‘नोराए अऩाकल ज़ सोनाकेर।’ ");
INSERT INTO kjl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","छींनी ङा ङाबाबु परमेस्‍वरए ल्‍योनी जेलाई सघैन्‍याए जूँनी सतलाव छैंव पुरूस परींद ङायाचिरिज़्‍या। नो पुरूस ङाबाबुए ल्‍योनी हुद ङा ङाजूँनी ताव पाँ भरिए गोहाई तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","जे मनी ङ़ादाकिन ज़ ङास जेल्‍योए जे ब ङागोहाईर जेतारिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“जेयुँर ताक़्याक लिद आव पाँर ङ़ादा ज़ ङासथैचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","जेलाई इताव ब हुरिज़्‍या — यहूदीराए धर्मसास्‍त्र झ़िमनी पले·चिरिज़्‍यार। फरी जेलाई सैःन्‍या सजा याज़्‍यावर ‘परमेस्‍वरए ओय़ेन ज़ गेदोज़्‍या’ है लिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","निताव य़ेन नोराए ङाबाबुलाई ब यामासरेसोए, ङालाई ब यामासरेसनावए दान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","आव पाँ भरी जेलाई ङ़ादा ज़ है ङादाचिज़्‍या। हो ताकिन ची जेलाई नितावर याहुक आव ङापाँर य़ाका दान्‍या जेले। नो पाँर आःपै जेस ज़ ङाल्‍योए है ङामादाचिताव।” ");
INSERT INTO kjl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“अब ते ङालाई परींज़्यावए ल्‍योदा ङाबारिके, खाली ‘नँ काना नबाज़्याव?’ है जेमादाँए। ");
INSERT INTO kjl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","आव है ङादाचिज़्याव पाँए जेयुँर माचाव जैद नैद्याचिउ। ");
INSERT INTO kjl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","खाली ङा साचो ज़ है ङादाचिज़्‍या, ङा आनी बान्‍या जेलाई पाथ लिज़्‍या। ङा आनी ङामाबाकिन जेलाई सघैन्‍या छैंव पुरूस हुन्‍या माले। ङा ङाबावत वाज़ नोलाई परींद ङायाचिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","नो उहुवत आव मानुवाताव मिँरालाई यापाप सतैंद्याद, परमेस्‍वरए ओन्‍याय स़ोनो ओसजा आव ज़ लिद थ·रैद याएरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","नो सतैंद ओराएरिज़्‍याव यापाप ङालाई यायुँ ओमाहुबोनी ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","नो सतैंद ओराएरिज़्‍याव परमेस्‍वरए ओन्‍याय फरी ङा जेङ़ाकिन ङाबाबु परमेस्‍वरए ओल्‍योक ङाबावत रैंःरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","नो सतैंद ओराएरिज़्‍याव परमेस्‍वरए ओसजा फरी ङा आव मानुवातावराए यास़ेर सैतानलाई ओपाहा झाःद्याद उमिन सम़ैद ङायोत रैंःरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“अझ ङा जेलाई है दान्‍या पाँर कुधु ज़ ओल्‍यो, खाली आवकिन कुधु ज़ है ङादाचिकिन जेयुँल नैधुन्‍या जेमाले। ");
INSERT INTO kjl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","नो छैंव पुरूस उहुवत वाज़ नोए ज़ साचो पाँर थ·रैव परींद पैचिरिज़्‍याव। नोए ओल उयुँ स्‍यानी सिर्जैसिउ पाँर पाँन्‍या माले, ओथैव वाज़ पाँन्‍या ले। नोए ज़ हुन्‍या पाँर ब सतैंद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","नोए ङा ङाल्‍योनिकाव पाँर ओपो·स ज़ छर्लङ्ग सतैंद्याद ङामिन ब सघ्योःद्याँरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ङाबाबु परमेस्‍वरस लिज़्‍याव भरी ङा ङामीं ज़। है जैद ज़ है ङादाचिउ, ‘नो पुरूसए जेलाई सतैंद ओयाचिरिज़्‍याव भरी ङा ङाल्‍योनी ज़ ङा ङाजूँनी ज़ तारिज़्‍या।’ ” ");
INSERT INTO kjl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“आकिनी जाँवाक जे ङालाई रँःन्‍या जेमाले। नकिन फरी जाँवाक वाज़ रँःन्‍या जेले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","उसिसर या याल, “आव काता ओपाँज़्‍याव इताव — ‘छ्यावाकिन जे ङालाई रँःन्‍या जेमाले, फरी छ्यावाक वाज़ रँःन्‍या जेले’ है लिज़्‍या? स़ोनो, ‘ङा ङाबाबुए ल्‍योदा ङाबारिज़्‍या,’ है मनी लिज़्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","नोराए, “आव ‘छ्यावाक’ है ओल्‍यो काता ओताव? आव पाँ जाँ गेमाबुझिधुके,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","हाःत ज़ येसुए ‘नो पाँर ङालाई है दाव यापैंज़्‍याव ताखेहो’ लिद नोरालाई है यादोक्‍यो, “नो ‘छ्यावाक रँःन्‍या जेमाले, छ्यावाक फरी जेरँःनारिज़्‍या’ है ङादाचिउ पाँत काताए जूँनी उल्‍तानी पाल्‍ता जेताज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","नोए जूँनी साचो ज़ है ङादाचिज़्‍या, आव पाँत जे ते जेसोगोए चिर्लनी बिर्ल घर्न्‍या जेले, मानुवाताव मिँर ते बनै रेंन्‍या लेर। खाली नो जेसोगो रेंतल त़ोसिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","किताव तोबो ज़ा दैन्‍या मेंमाए ज़ा दैन्‍या बेलाक घर्लिद दुख दैज़्‍याव, फरी भाउज़ा उजर्मिउत नो मेंमा उदुखर मेंःद उयुँर होलाँ ताद रेंज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","हिताव ज़ जे मनी छ्यावा पै वाज़ सोगो दान्‍या जेले। फरी जेस ङादैसिउत जेयुँर होलाँ ताद रेंन्‍या जेले। नो जेरेंत सुए ज़ जेनी नैद लाँधुन्‍या मालेर। ");
INSERT INTO kjl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","नो बेला उहुवत जे ङालाई सुधिउ परिन्‍या माले। ङा जेलाई साचो है ङादाचिज़्‍या, ङामिननी जो जेऩिदी ब ङाबाबुए नो याचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","आःपै ते जे ङामिननी काता ज़ जेमाऩिताए। अबकिन ते ऩिचिकेदा दैन्‍या जेले। हो ताकिन ची जेरेंत ब सयो·द्यान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“आःपै ते आव ङापाँर जेस बिन्‍ज़ा बिन मितावनी ज़ ङापाँके। तछा छींनी नो ङाबाबुए उजूँनी ङापाँव पाँर ओपो·स ज़ छर्लङ्ग तारिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","हो छ्याम जे ज़ ङामिननी ऩिन्‍या जेले, ङा जेजूँनी ङाबाबुस ऩिद्याव मापरिए। ");
INSERT INTO kjl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ङा ङाबाबुए ल्‍योनी ङाहुव लिद जेयुँ हुप्द ङालाई मया जेदाँवए ङाबाबुए मनी जेलाई मया दान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ङा ङाबाबुए ल्‍योनी ज़ आव मानुवात ङाहुके, फरी आव मानुवालाई ऱास्‍द ङाबाबुए ल्‍योदा ज़ ङाबारिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","हाःत ज़ उसिसराए, “अब ते नपाँ बिन्‍ज़ा बिननी माजैद चावस ज़ पलास्‍द नयासिके। ");
INSERT INTO kjl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","अब ते गेसैंके, नँ प़ाइँ ज़ नसैंज़्‍या, आकिन गे नँलाई सुधिउ ब मापरिके। नँ परमेस्‍वरनी हुव ज़ लिद गेयुँ मनी हुप्‍के,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","येसुए, “ङालाई बल्‍ल जेयुँ जेसुहुबो रो? ");
INSERT INTO kjl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","आव मनी थैच्‍यो, तछा इताव बेला हुरिज़्‍या, नो बेला उहुधुव मिताव ब लिज़्‍या, जे जेछ्याचेए चितराँ पुतराँ ताद सु सु जेझ़िमदा बाद ङालाई ङाबातङ ज़ जेजैनारिज़्‍या। हैदी ब ङा ङाबातङ ङामाले, परमेस्‍वर ङाबाबु ङास ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","आव पाँ भरी जे ङास लिद जेयुँ होलाँ ओताक लिद ङ़ादा ज़ है दाद ङानैचिए। जे आव मानुवात दुखर वाज़ दैन्‍या जेले। हितावत ब जेयुँर तासतेच्‍यो, ङा आव मानुवालाई हारैद ङानै,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","येसु आव भरी पाँद नमदा भाल्‍सिद, “अ परमेस्‍वर ङाबाबु, बेला यो·हुके। ङा नँ नमिन सघ्‍योःद्यान्‍याए जूँनी ङा नज़ाए ङामिनलाई ब सघ्‍योःद्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","किताव नज़ालाई मिँ भरिराए याङ़ैताव नजैनाव, आथ पाला मनी ङालाई नयाँव मिँ भरिरालाई अजम्‍बरी जुनी यान्‍याए जूँनी ङामिन सघ्‍योःद्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","नोर अजम्‍बरी जुनी दैन्‍या इतावनी ज़ ताज़्या — नँ तोबोका तोबो साचो परमेस्‍वरलाई सरेस्‍न्‍या स़ोनो ङा नपरींनाव येसु ख्रीसलाई सरेस्‍न्‍यानी ज़। ");
INSERT INTO kjl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ङालाई ‘दोयो’ लिद नपरींनाव य़ेन भरी सयो·द आव मानुवात नमिन ब सघ्‍योःद नैद ङाईंए। ");
INSERT INTO kjl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अ बाबु, अब ते ङालाई नँस ज़ नैद आव नाम नम ओमाताद नँस गिन्‍लिज़्‍याकाव ङाज़गै फरी ङालाई याँयो,” है लिद पोंखारिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“आव मानुवानी ङालाई नयाँव मिँरालाई नमिन सतैंद नैद ङाराएए। नोर नमींर ज़ याल्‍यो, नोर ज़ ङालाई नयाँके। नोराए नपाँर भैंःद ज़ लेर। ");
INSERT INTO kjl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","नँ ङालाई नयाँव पाँ भरी नँनी ज़ हुव लिद नोराए सैंद नैर। ");
INSERT INTO kjl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","नँ ङालाई नयाँव पाँ भरी नोरालाई याद ङारानै। नोराए नो पाँ भरी रैद ङा नल्‍योनी हुव ज़ लिद थ·रैद, नँ ज़ ङालाई नपरींनाव लिद यायुँ ब हुप्‍द ले। ");
INSERT INTO kjl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","नो ङालाई नयाँव मिँराए जूँनी ङा पोंखारिउ ज़ ङालिज़्‍या, नोर नमींर ज़। उपुर्कावराए जूँनी ते ङामादोए। ");
INSERT INTO kjl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ङास लिज़्‍याव भरी प़ाइँ नमींर ज़, नँस लिज़्‍याव भरी ब प़ाइँ ङामींर ज़। नोराए याक्‍याँत ज़ ङाज़गै रैंःद ले। ");
INSERT INTO kjl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","अब ते ङा आव मानुवात कोसै ङामाले, नल्‍योदा ङाहुरिज़्‍या। नो नयाँवर ते आव मानुवात ज़ ङाराख्यानैरिज़्‍या। है जैद अ छैंव ङाबाबु, नोरालाई नमिनत पाथस ज़ यानैयो। नँस गिन तोबो ज़ गिन्‍लिज़्‍याव मिताव नोर मनी तोबो ज़ ओतारक। ");
INSERT INTO kjl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ङा नोरास ङालेवा पै नोरालाई खेर बान्‍यानी जोगोइद नमिनत पाथस ज़ ङारानैके। खाली धर्मसास्‍त्रलाव पाँलाई सयो·न्‍याए जूँनी तोबो नर्गए ओज़ा वाज़ खेर बाके। ");
INSERT INTO kjl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","अब ते ङा नल्‍योदा ङाहुरिके। खाली आव नयाँवराए यायुँर होलाँ ताद रेंद लिन्‍या ओतारक लिद ङा आव मानुवालाई माख्यानैद ङ़ादा ज़ ङापोंखारिनिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ङा नोरालाई नँ नपाँ ज़ ङाराएके। नोर ङा मिताव आव मानुवातावर यामातावए मानुवाताव मिँराए यारासोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","नोरालाई ‘आव मानुवानी नल्‍योदा यालाँके’ लिद ते ङामापोंखारिए, खाली ‘झुकैज़्‍याव सैताननी पाथस यानैयो’ है ङादींज़्‍याव ची। ");
INSERT INTO kjl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","किताव ङा आव मानुवाताव माःक, हिताव ज़ नोर मनी आव मानुवातावर माःक। ");
INSERT INTO kjl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","नोरालाई साचो नपाँल सतस दान्‍या याखत माल्‍यो छैंवर याजैयो। नँ नपाँ सतलाव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","किताव ङालाई आव मानुवात नपरींनाव, हिताव ज़ ङा मनी नोरालाई मानुवात परींद ङारानै। ");
INSERT INTO kjl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","नोर साचो नपाँल याखत माल्‍यो छैंवर घतारक लिद ङा नोराए जूँनी नयुँलाव मिताव य़ेन दान्‍यात थाँसिद ङाले।” ");
INSERT INTO kjl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“आव ङापोंखारिनिज़्‍याव नोराए जूँनी वाज़ माःक, नोराए यापाँ थैद ङाल्‍योदा यायुँ हुप्‍ज़्‍यावराए जूँनी पाला ज़। ");
INSERT INTO kjl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","अ परमेस्‍वर ङाबाबु, किताव ङा नँस ङालिज़्‍या, नँ ङास नलिज़्‍या, हिताव ज़ नोर मनी प़ाइँ तोबो ज़ ताद गिनस खैवर ओतारक। हो ताकिन ची आव मानुवाताव मिँराए ङालाई नँ ज़ नपरींनाव थ·रैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","गिन तोबो ज़ गिन्‍लिज़्‍याव मिताव नोर ब तोबो ज़ ओतारक लिद ङालाई नयाँव ज़गै नोरालाई मनी याद ङारानैए। ");
INSERT INTO kjl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","है जैद नोर प़ाइँ तोबो ज़ ओतानारक, ङा नोरास, नँ ङास ओताक। ननी ज़ आव मानुवाताव मिँराए ङालाई नँ ज़ नपरींनाव सैंन्‍या लेर। स़ोनो किताव ङालाई मया नदाँव, नोरालाई मनी मया नरादोज़्‍याव सैंन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","अ बाबु, ङालाई नयाँव मिँर जोङ ङालिज़्‍या होङ ज़ ओतारक है ङालिज़्‍या। हो ताकिन ची ङालाई नयाँव ज़गै नोराए रँःधुन्‍या लेर। आव नाम नम ओमाताद ज़ ङालाई मया दाद नज़गैर नयाँके। ");
INSERT INTO kjl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","अ सतस न्‍याय दाज़्याव ङाबाबु, आव मानुवाताव मिँराए नँलाई यामासरेस्‍निदी ब ङा ते ङासरेस्‍निज़्‍या। आव नमींराए मनी ङा नल्‍योनी ज़ ङाहुव लिन्‍या सैंद नैर। ");
INSERT INTO kjl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ङा नोरालाई नमिन ङारासथैके, फरी ब सथैन्‍या ज़ ङाले। हो ताकिन ची ङालाई नदाँज़्‍याव मया नोरास तान्‍या ले, ङा ब नोरास ज़ तान्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","येसुए आव भरी पोंखारिद उसिसरास किद्रोन घैरा होफताव बगैचाल बाकेर। ");
INSERT INTO kjl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","नो पो येसुलाई सूँपिज़्‍याव यहूदा इस्‍करियोतए मनी सैंद ओनैज़्‍याव। येसु उसिसरास एकतार नो पोक याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","है जैद यहूदा इस्‍करियोतए फरिसीर स़ोनो मुख्या पुजारीराए यारापरींव ध्‍यान झ़िमलाव पाल्‍यार स़ोनो सिपाईंर लाँद नो बगैचाल बाकेर। नोरास हत्‍यारर, लाल्‍तिनर भाँर ब लाँद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","येसुए ओक्‍याँत हुरिज़्‍याव दुखर सैंद ओल ज़ नोराए याल्‍योक बाद, “जे सुलाई जेखिम्‍ज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","नोराए, “नासरतलाव येसुलाई,” है दोकेर। नाःत ज़ येसुए, “हो ताकिन ते नासरतलाव येसु ङा ज़,” है यादोक्‍यो। येसुलाई धोका याज़्‍याव यहूदा इस्‍करियोत ब नोरास नक ज़ च्‍याँःसिद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","येसुए, “ङा हो ज़,” है ओरादोव प़ाइँना नोर प़ाइँ ज़ याछींदा सरिद पल्‍तिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","येसुए फरी ब, “जे सुलाई जेखिम्‍ज़्‍याव?” है ओरादोक ते, “नासरतलाव येसुलाई,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","येसुए, “जेलाई आछ्या ज़ ‘ङा हो ज़’ है ङामादाचिउ रो? साचो ङालाई वाज़ जेखिम्‍नाज़्‍याव ताकिन आव ङानैंरालाई बाव याराएचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","नो है ओरादोव ङ़ादाङाव ओपोंखारिकाव मिताव ‘तोबो ज़ कै मै तातारक’ है ओल्‍यो पाँ सयो·न्‍याए जूँनी ज़ है ओरादोव। ");
INSERT INTO kjl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","हाःत ज़ सिमोन पत्रुसए ओतरवाली हाइद प्रधान पुजारीए ओनोकोरलाई वोर्निकाव ओर्ना पल्‍द सतेदिक्‍यो। नो नोकोरए उमिन माल्‍खस ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","येसुए पत्रुसलाई, “नतरवाली उसिपल झाःके। ङाबाबु परमेस्‍वरए गोइँद ओयाँव दुखर ङा कै जैद मासहिन्‍या?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","हाःत ज़ नक लिज़्‍याव कप्‍तान, उसिपाईंर स़ोनो यहूदीराए यास़ेरराए यारापरींव पाल्‍याराए येसुलाई क्‍योःद किद, ");
INSERT INTO kjl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","हन्‍नासए ओल्‍योक लाँकेर। नो हन्‍नास नो साललाव प्रधान पुजारी कैयाफाए ओबागे ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","नो कैयाफाए ज़ ङ़ादा यहूदीराए यास़ेररालाई, “प़ाइँ यासिज़्‍याव देखा बुरू नोराए पोल तोबो सिन्‍या पाथ लिज़्‍या,” है दाद सल्‍ला याज़्‍याव मिँ। ");
INSERT INTO kjl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","हाः बेलाक पै सिमोन पत्रुस स़ोनो छुत तोबो उसिस येसुए उछीं उछीं निबाज़्‍याव। नो तोबो उसिस प्रधान पुजारीस ङ़ादाकिन ज़ निसरेस्‍सिज़्‍यावए नो उसिस प्रधान पुजारीए ओचतराक पै येसुस ज़ बाके। ");
INSERT INTO kjl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","सिमोन पत्रुस ते साँबिलाक च्‍याँःसिद उलिज़्‍याव। नो प्रधान पुजारीस सरेस्‍सिउ उसिस ओल्द बाद साँबिलाक पाल्‍या लिज़्‍याव ल़ुज़ालाई है दाद पत्रुसलाई ओलस ज़ चतराक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","पत्रुस साँबिलाक उपसिज़्‍याक नो ल़ुज़ाए, “नँ ब नो मिँए उसिस ज़ सा?” है ओदोक ते, पत्रुसए, “अहँ, ङा माःक,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","नो चतराक नलाव य़ेन दाज़्‍यावर स़ोनो पाल्‍यार याज़्‍यूँःवए मेंः दाद यामुइँसिज़्‍याव। पत्रुस मनी नोराए ल्‍योक बाद मेंः मुइँसिनाके। ");
INSERT INTO kjl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","नकिन नो प्रधान पुजारीए येसुलाई ओरापैज़्याव स़ोनो उसिसराए जूँनी ओखोले·क ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","येसुए, “ङा ङारासिऊज़्‍याव पाँर म़ोंसिद माःक, प़ाइँए रँःन्‍याक, प़ाइँए ङ़ाक ज़ ङारापैज़्‍या। यहूदीर यादुप्‍सिज़्याव धर्मसास्‍त्र झ़िम झ़िमक स़ोनो ध्‍यान झ़िमल ज़ ङारासथैके। ");
INSERT INTO kjl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","काराव ङालाई नखोले·नाज़्‍याव? ङापाँ थैवरालाई ज़ यासुधिके, नोराए ज़ नँलाई है दान्‍या लेर,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","नक लिज़्‍याव तोबो पाल्‍याए, “नँ कै जैद नाःल्‍दिउ प्रधान पुजारीस याः नदोज़्‍याव?” लिद तखेप लप्‍तैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","हाःत ज़ फरी येसुए, “ङा मापाँन्‍या ङापाँव ताकिन ङागल्‍ती सतैंके, ङा थिक ज़ ङापाँज़्याव ताकिन काराव नप़ोनाज़्याव?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","नकिन हन्‍नासए येसुलाई किसिउ ज़ प्रधान पुजारी कैयाफाए ल्‍योदा परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","नाःपै सिमोन पत्रुस लाँःक च्‍याँःसिद मेंः मुइँसिउ ज़ उलिज़्‍याव। नक लिज़्यावराए, “नँ ब नोए उसिस ज़ सा?” है यादोक ते, पत्रुस माभैंःद, “ङा हो माःक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","प्रधान पुजारीए तोबो ओनोकोर, ङ़ादा पत्रुसए ओर्ना पल्‍द सतेद ओएज़्‍यावए ओक्‍याँदाङाव ब नक उलिज़्‍याव। होए मनी पत्रुसलाई, “नँलाई आछ्याक येसुस बगैचाल नलिज़्‍याव ङारँःनिउ सानी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पत्रुसए फरी ब माभैंःद, “ङा माःक,” है ओदोव प़ाइँना ज़ भाल्या कोके। ");
INSERT INTO kjl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","नकिन छकाल्‍न्‍या घग ज़ कैयाफाए उझ़िमनी येसुलाई रोमी हाकिमए ओमहलल लाँकेर। नो लाँज़्‍याव यहूदीर ते, ‘झुथो ताद निस्‍तार पर्बत भत्‍यार ज़्याव गेमादैया’ लिन्‍या छ्यासए महलल मापसिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","है जैद हाकिम पिलातस ओल ज़ महलनी लाँःक पुलुस्‍द नोराए ल्‍योक बाद, “जे आव मिँलाई काता ओखत पले·द जेएज़्‍याव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","प़ाइँए ज़ तपाँ जैद, “आवए ओखत ओमाल्‍यो ताकिनी, नल्‍योक काराव गेरैरिज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातसए, “जे ज़ लाँद जे यहूदीराए जेकानुननी ज़ फाल्‍चिके,” है ओरादोक ते, यहूदीराए यास़ेरराए, “गे गेकुइत सैःन्‍या हक माले,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","नो पाँत ज़ येसुए ङ़ादा ‘इतावनी ङासिरिज़्‍या’ है उलिज़्‍याव पाँ यो·के। ");
INSERT INTO kjl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","नकिन पिलातस महलल पसिद येसुलाई खुल्‍द, “नँ साचो यहूदीराए याराजा ज़ रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","येसुए, “आव पाँ नँ ज़ नसैंव सैं ङाजूँनी सुवाराए है यादींव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातसए, “ङा काता ङासैंए, ङा यहूदी माःक। नँ नजातलाव मिँर स़ोनो मुख्या पुजारीराए ज़ ङाल्‍योक रैद नैनिर। नँ मादान्‍या य़ेन काता नदोव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","येसुए, “ङा ङाराज्‍या आव मानुवाताव माःक। ङाराज्‍या मानुवाताव ताकिन, आव ङालाई क्‍योःज़्‍याव यहूदीराए कुइनी जोगोइन्‍याए जूँनी ङाधूँलावर खप्‍सिना हुखेरहो। खाली ङा ङाराज्‍या आलाव माःक,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","हाःत ज़ पिलातसए फरी, “हुकी नँ राजा ज़ रो?” है ओदोक ते, येसुए, “ङा राजा ङालिज़्‍याव नँ ज़ है नदाँज़्‍या सानी। होए उजूँनी ज़ ङा आव मानुवात जर्मिद साचो पाँए ओगोहाई याना ङाहुके। है जैद सतलाव पाँल लिज़्‍याव भरी ङापाँ थैद दोज़्यार,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातसए, “सतलाव पाँ काताकी?” है दाद लाँःक यहूदीराए ल्‍योक बाद, “ङा आव जेरैव मिँए ओखत कान्‍त ज़ ङामादैए। ");
INSERT INTO kjl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","जेकानुनल निस्‍तार पर्ब छ्याम तोबो कैदीलाई ऱास्‍न्‍या चलन लिज़्‍या। है जैद सैं आथ पाला आव यहूदीराए याराजालाई ऱास्‍द ङायाच्‍यो रो?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","नोराए, “आवलाई माःक, बारब्‍बालाई ऱास्‍द्यासिके,” लिद क़िकेर। बारब्‍बा तोबो चोर दाँका ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","नाःत ज़ पिलातसए येसुलाई रीःन्‍याए जूँनी सिपाईंरालाई यासूँपिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाईंराए ज़ुए मुकुत ऱ॰द ओङ़ैत जास्‍द घ्यामर्‍यासो क्‍वा जास्‍द, ");
INSERT INTO kjl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ओङ़ाक बाद बरे·द, “यहूदीराए याराजा, जय जय ओताक,” है ल्‍यो जैसिउ य़ेन ओङाःत लफरैदिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातस फरी तखेप लाँःदा पुलुस्‍द नो माहोल्‍यारालाई, “दे आवलाई जेलाई ज़ रैद ङायाचिज़्‍या। ङा ङाल्‍योनी ते आवए ओक्‍याँत काता खत ज़ ङामादैए, जे ज़ सैंचिके,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","येसु ओल ज़ नो ज़ुए मुकुत जासिसिउ, घ्यामो क्‍वार क्‍वाइसिसिउ याङ़ाक पुलुस्‍के। हाःत ज़ पिलातसए, “चिऊचिके, आव ज़ जेरैव मिँ,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","हाःत ज़ नक लिज़्‍याव मुख्या पुजारीर स़ोनो पाल्‍यार येसुलाई यारँःव प़ाइँना ज़ बनै चोइस क़िद, “क्रुसत तङ्गैद सैःन्‍या!” है यादोक ते, पिलातसए, “हो ची ताकिन्‍दा जे ज़ लाँद क्रुसत तङ्गैचिके। ङा ते आवए ओखत काता ज़ ङामादैए,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदीराए, “आव मिँ ओलनी ज़ परमेस्‍वरए ओज़ा ओजैसिउनी गे यहूदीराए गेकानुननी सिन्‍या सजा दैव ज़ परिए,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","पिलातस इताव पाँ थैद झन ज़ छे·द, ");
INSERT INTO kjl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","येसुलाई महलल लाँद फरी ब, “नँ काताङाव नताव?” है ओदोक ते, येसुए झन ज़ घाइ ज़ मादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातसए फरी, “ङालाई काराव घाइ नमादाँज़्‍याव? नँलाई तङ्गैन्‍या तादी ब ऱास्‍न्‍या तादी ब ङा ङाकुइत उलिज़्‍याव नमासैंए रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","येसुए, “परमेस्‍वरए नँलाई ओमाईंव ताकिन ङा ङाक्‍याँत नहक काता ज़ मालिखेहो। है जैद ङालाई क्‍योःद नँलाई याज़्‍यावर नँकिन घ्‍योःव पापल ज़ परिकेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","पिलातसए निताव ओपाँ थैद येसुलाई ऱास्‍न्‍या बनै धामा दोक्‍यो। हितावत ब यहूदीर झन ज़ क़िद, “आव मिँलाई नऱास्‍किन नँ माहाराजाए ओनैं ज़ माःक। यानी राजा जैसिज़्‍याव भरी माहाराजाकिन तँदाङावर ज़ ताज़्‍यार सानी,” ");
INSERT INTO kjl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","है यालिज़्‍याव थैद पिलातसए येसुलाई लाँःक रैद हिब्रू खामनी गब्‍बथा यादोज़्‍याव लुँ छापिसिउ चतराक लाँद ओल फाल्‍न्‍या पोल च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","नो छ्याम निस्‍तार पर्बए ओङ़ालाव तयारीलाव दिन लाकाव बाह्र बजेवाक ओल्‍यो। पिलातसए यहूदीरालाई, “चिऊचिके, आव ज़ जेराजा,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","नोराए झन, “आवलाई नैन्‍या माःक, क्रुसत तङ्गैद सैःन्‍या ची,” है लिद क़िकेर। पिलातसए फरी, “काराव जे जेराजालाई क्रुसत तङ्गैद सैःन्‍या है जेदाँज़्‍याव?” है ओरादोक ते, मुख्या पुजारीराए, “गेराजा रोमी माहाराजाकिन सु ज़ माले,” है यालिज़्याव ");
INSERT INTO kjl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","थैद पिलातसए येसुलाई क्रुसत तङ्गैद सैःन्‍याए जूँनी यहूदीरालाई ज़ याभीःक्‍यो। सिपाईंराए येसुलाई यापासल रैद, ");
INSERT INTO kjl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","नोराए येसुलाई उक्रुस ओललाई ज़ सुघुर्द गलगथा यादोज़्‍याव पोक लाँकेर। हिब्रू खामनी गलगथाए ओअर्थ ‘खप्‍पर्‍या पो’ ज़। ");
INSERT INTO kjl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","नक नोराए येसुलाई क्रुसत तङ्गैकेर। हो छ्याम ओलस छुत ऩेब्‍लोनिलाई मनी ओलस ज़ यारातङ्गैकेर। येसुलाई खार्ल जैद तोबोलाई ओवोर्दा, तोबोलाई ओदाबर्‍यादा जैद सु सु याक्रुसत यारातङ्गैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातसए फरी फल्‍यात तोबो सर्द, “आव नासरतलाव येसु, यहूदीराए याराजा ज़” लिद येसुए उक्रुसत चदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","नो सर्सिउ हिब्रू, ल्‍यातिन स़ोनो ग्रीक खामनी ब उलिज़्‍याव। येसु क्रुसत तङ्गैसिउ पो सहर छ्योक ओतावए यहूदीराए कुधुए ज़ रँःद, ");
INSERT INTO kjl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहूदीराए मुख्‍या पुजारीर पिलातसए ल्‍योक बाद, “नताव नसरो ‘आव यहूदीराए याराजा ज़’ है लिद सर्न्‍या माःक, बुरू ओल ज़, ‘ङा यहूदीराए याराजा ज़ है ओल्‍यो,’ सर्न्‍या ची,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातसए, “ताधुके, जो मिताव तादी ब ङासर्धुके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","नकिन येसुलाई तङ्गैद सैःज़्‍याव सिपाईंराए येसुए ओक्‍वार चार भा जैद सु सु याजुँ लाँकेर। ओतर्ताव ओक्‍वाइसिज़्‍याव ओक्‍वा ते तपाता ज़ काङ्क ज़ माऱूप्‍सिउ ओल्‍योए, ");
INSERT INTO kjl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“आवलाई चीन्‍या माःक, जोए ओल्‍योदा ओबादी ब गोला झाःव ताके,” है लिकेर। नो पाँत ज़ धर्मसास्‍त्रलाव पाँ ब यो·के। नो पाँ आव ज़, “नोराए ङाक्‍वार भाःद लाँन्‍या लेर। ओतर्ताव ङाक्‍वात गोला झाःन्‍या लेर।” है जैद सिपाईंराए हैज़ जैकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","हो बेलाक क्रुसकिन जाँ होकसैक येसुए ओआमा, ओआमाए ओबैंनी, क्‍लोपासए ओज्‍या मरियम स़ोनो मरियम मग्‍दलिनीर च्‍याँःसिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","येसुए ओआमा स़ोनो उयुँलाव उसिसनी नक च्‍याँःसिद निलिज़्‍याव रँःद ओआमालाई, “आमा, नज़ा आव ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","नकिन फरी उसिसलाई, “चिऊके, आव नआमा ज़,” है दोक्‍यो। है जैद हो छ्यामकिन ज़ नो उसिसए येसुए ओआमालाई उझ़िमक लाँद ओलस ज़ नैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","हाःत ज़ येसुए, ‘अब ते ङाय़ेन भरी यो·के’ लिन्‍या सैंद धर्मसास्‍त्रलाव पाँ सयो·न्‍याए जूँनी, “ऱी ङाछोस्‍ज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","हाः बेलाक नक तोबो जाल सिरो दाखमद्य झाःद यानैज़्‍याव। नक लिज़्‍यावराए भाताए उतुपात थाकना पो·द नो सिरो ऱील छिम्‍द ओयाःत पिउ परींकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","येसुए नो पिद, “अब ते ङाय़ेन भरी दुम्‍के,” है लिद ओङ़ै घोम जैद उस॰ सफ्या·क्यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","हो छ्याम तयारीलाव दिन ओल्‍यो, स़ोनो घेप्‍पा पर्बए ओङ़ालाव छ्याम ब उलिज़्‍याव। यहूदीराए याकानुननी हो छ्याम नो यारासैःवरालाई क्रुसत नैन्‍या ओमाताज़्‍याव। है जैद नोराए नो क्रुसत तङ्गैसिउरालाई यास॰ सफ्या·द्यान्‍याए जूँनी ‘याखँर केःद्याद क्रुसतिन झरैव ताके’ है लिद पिलातसलाई बिन्‍ती दाद, ");
INSERT INTO kjl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","येसुए ओवोर्दाङाव मिँलाई उखँर केःदिकेर। नकिन ओदाबर्‍यादाङावलाई मनी उखँर केःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","नकिन येसुए उखँर केःना याबाक उसिधुव रँःद उखँर केःद माएकेर। ");
INSERT INTO kjl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","हाःत ज़ नक लिज़्‍याव तोबो सिपाईंए ओज़लए येसुए ओकोखाल घोइदिक्‍यो। ओघोइव प़ाइँना ओकोखानी झी स़ोनो ऱी हुके। ");
INSERT INTO kjl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","आव पाँ भरी तोबो मिँए ओल ज़ उरँःव। नोए ओपाँ साचो थ॰रिउ ज़ लिज़्‍या। है जैद आव पाँत जेयुँ उहुप्‍क। ");
INSERT INTO kjl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","आव पाँ भरी धर्मसास्‍त्रलाव पाँ सयो·न्‍याए जूँनी ज़ ताके। नलाव सर्सिउ आव ज़, “नोलाई तके उऱूस ब केःद्यान्‍या मालेर।” ");
INSERT INTO kjl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फरी तोथोल इताव मनी सर्सिउ लिज़्‍या, “नो ज़लए याघोइवलाई प़ाइँए ज़ रँःन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","आव भरी ओतावत अरिमाथियालाव योसेफ पिलातसए ल्‍योक बाद येसुए ओमोरो ऩिक्‍यो। नो मिँ मनी येसुए ओपाँत बाज़्‍याव मिँ ज़ ओल्‍यो। खाली नोए यहूदीराए यास़ेरराए छ्याचेए येसुए ओपाँ जाँ म़ोंसिद ओदोज़्‍याव। नोए पिलातसए ल्‍योनी हक रैद येसुए ओमोरो लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नो ङ़ादा रील म़ोंसिद येसुए ल्‍योक हुज़्‍याव निकोदेमस मनी योसेफस उलिज़्याव। नोए बनै चाव सी ङरो जरार हे·सिउ बरे·द तुगुर ज़ घुर्द रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","नोनी यहूदीराए याचलन मितावनी येसुए ओमोरोलाई नो उसी ङरो जरार झाःद क्‍वाए लुम्‍बैकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","येसुलाई क्रुसत तङ्गैसिउ पोकिन जाँ होकसैक तोबो बगैचा उलिज़्‍याव। नो बगैचाल सुलाई ज़ यामाझाःताव साःरो खादर तोबो उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","है जैद यहूदीराए तयारीलाव दिन ओतावए, नो नजिककाव लिज़्‍याव खादरल ज़ येसुए ओमोरोलाई झाःकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","सातालाव उस॰कताव छ्याम छकाल्‍न्‍या ओमासँद ज़ मरियम मग्‍दलिनी बनै घग ज़ येसुए ओखादरक ओबाक नो खादर याःताव कसिउ घ्योःव लुँ हाइसिउ रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","निताव रँःद ननी धोंःनाद सिमोन पत्रुस स़ोनो येसुए उयुँलाव उसिसनी निल्‍योक बाद, “गेप्रभुलाई ते काताकावराए खादरनी हाइद यालाँव ओल्‍यो। काना यालाँव गेमासैंए,” है उनिदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","पत्रुस स़ोनो येसुए छुत उसिसनी हतप्‍त ज़ खादर पोदा धोंःनाकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","निधोंःनाज़्‍याक पत्रुसलाई बलेंद ओनैं ङ़ादा खादरक केस्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","नो खादरल मापसिद घोम लिद उचिऊक येसुलाई लुम्‍बैसिउ क्‍वार वाज़ रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","नकिन छ्यावाक सिमोन पत्रुस मनी खादरक ओकेस्‍हुव प़ाइँना ज़ खादरल पसिद उचिऊक होए मनी येसुए ओमोरो लुम्‍बैसिउ क्‍वार वाज़ रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","नो ओङ़ैताव पो·सिउ क्‍वालाई फरी नो ओमोरो लुम्‍बैसिउ क्‍वाकिन जाँ अछतङ पतैद नैसिउ रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","हाःत ज़ नो ङ़ादा हुव येसुए छुत उसिस मनी खादरल पसिद प़ाइँ चिऊद येसु ओसोव ज़ ओल्‍यो लिद उयुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","नोनी नोकिन ङ़ादा नो धर्मसास्‍त्रलाव सर्सिउ पाँ ‘येसु उसिदी ब सोन्‍या ले’ लिन्‍या निमाथ·रैताव। ");
INSERT INTO kjl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","नकिन नो उसिसनी निझ़िमदा ओल्‍द बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मरियम मग्‍दलिनी ते खादर छ्योक च्‍याँःसिद घरो ज़ उलिज़्‍याव। नाःत ज़ घोम लिद खादरल तखेप ओभाल्‍सिक, ");
INSERT INTO kjl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","परमेस्‍वरए ओचाकर्‍यानी ऩेब्‍लो पाल पालो क्‍वा क्‍वाइसिउनी निरँःक्‍यो। नोनी येसुलाई नैसिउ पोक तोबो उगुमदा, तोबो उखँदा च़ुसिद निलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","नोनी मरियमलाई, “अ माँ, नँ काराव नघर्ज़्‍याव?” है निदोक ते, नोए, “ङाप्रभुलाई काताकावराए आव खादरनी हाइद यालाँव ओल्‍यो। काना यालाँव ओताव ङामासैंए,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","नाः है दाद नो मेंमा उछींदा ओभाल्‍सिक येसु नक च्‍याँःसिद उलिज़्‍याव रँःक्‍यो। खाली येसु ज़ लिन्‍या मासरेस्‍धुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","हाःत ज़ येसुए, “अ माँ, नँ काराव नघर्ज़्‍याव, सुलाई नखिम्‍ज़्‍याव?” है ओदोक ते, नो मेंमाए, आव ते बगैचालाव माली ची सा लिद, “अ दाज्‍यु, येसुलाई नँ आनी हाइद नलाँव ताकिन, ‘आक ङानैज़्‍या’ है दाव ताके। ङा होलाई ङालाँरिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","येसुए, “अ मरियम,” है ओदोव प़ाइँना नो मेंमा ओल्‍योदा फर्किद, “रब्बोनी!” है दोक्‍यो। (हिब्रू खामनी रब्बोनीए ओअर्थ ‘गुर्बा’।) ");
INSERT INTO kjl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","हाःत ज़ येसुए, “ङालाई ताछाप्‍नायो, ङा आःपै ङाबाबुए ल्‍योक ङामाबाताए। बुरू ङानैंरालाई, ‘ङाबाबु परमेस्‍वर स़ोनो जेबाबु परमेस्‍वरए ल्‍योदा ङाबारिज़्‍या’ है यादोनाके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","हो प़ाइँना ज़ मरियम मग्‍दलिनी उसिसराए ल्‍योदा धोंःनाद प्रभुलाई उरँःव स़ोनो है ओदोव पाँ भरी ब है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","हो छ्याम ऱिमक ज़ येसुए उसिसर यहूदीराए छ्याचेए य़ाम गल्द झ़िमल यालिज़्‍याव। नो छ्याम आइतबार ओल्‍यो। नाःत ज़ येसु उमँःजानी उसिसराए खार्ल च्‍याँःसिहुद, “जेयुँर होलाँ ओताक,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","येसुए उकुइर ओकोखार सतैंद याएक्‍यो। याप्रभुलाई रँःद नोर यायुँर होलाँ ताद बनै रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","येसुए फरी ब, “जेयुँर होलाँ ओताक। किताव ङाबाबुए ङालाई उपरींनाव, हिताव ज़ जेलाई मनी ङापरींचिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","नोराए ल्‍योदा उस॰ ह्‍वास जैद, “आख ते छैंव पुरूस दोचिके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","नकिन फरी, “जे मिँरालाई यापाप क्‍याल्‍द जेराएकिन, नोराए यापाप क्‍याल्‍सिद परमेस्‍वरस खैवर तान्‍या लेर। फरी यापाप क्‍याल्‍द जेमाराएकिन नोराए यापाप हिताव ज़ रहिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","येसु उसिसराए ल्‍योक उहुव छ्याम दिदुमस यादोज़्याव थोमा नल ओमाल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","छींनी उपुर्काव उसिसराए थोमालाई, “गे गेप्रभुलाई गेरँःके,” है यादोक ते, नोए, “ङा झँ किलाए उकुइ सघ्वाँःसिउ कुँ रँःद होल ङाआङुला ङामालुइवा पै स़ोनो ओकोखाल ङाकुइ ङामालुइवा पै ङायुँ ज़ माहुबे,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","हुकिनकाव साताक फरी उसिस भरी य़ाम गल्‍सिद झ़िमल यालिज़्‍याव। हो छ्याम ते थोमा ब यास ज़ उलिज़्‍याव। हाःत ज़ निताव य़ाम गल्‍सिउ उलिज़्‍यावत ब येसु उमँःजानी याखार्ल च्‍याँःसिहुद, “जेयुँ होलाँ ओताक,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","नकिन थोमालाई, “आव ङाकुइ सघ्वाँःसिउल नआङुला लुइके, ङाकोखाल ब नकुइ लुइद माहुबो नयुँलाई सुहुप्‍के,” है ओदोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमाए, “अ ङाप्रभु, ङापरमेस्‍वर, नँ ज़ ची नल्‍यो,” है लिके। ");
INSERT INTO kjl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","हाःत ज़ येसुए, “थोमा, नँ ते ङालाई रँःद नयुँ हुप्‍के। खाली ङालाई मारँःद उयुँ हुप्‍ज़्‍याव ते झन धन्‍याकाव लिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","येसुए उसिसराए याङ़ाक आव पोस्‍तोकोल मासर्सिउ छुत सरेसर मनी कुधु ज़ सतैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","खाली आलाव सर्सिउ भरी जे येसुलाई, परमेस्‍वरए ओज़ा गेलाई बाँचैज़्‍याव ख्रीस ज़ लिद जेयुँ सुहुप्‍द्यान्‍याए जूँनी सर्द ङायाचिके। हो ताकिन ची जे नोए ल्‍योदा जेयुँ जेसुहुप्‍किन होए उमिननी अजम्‍बरी जुनी दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","फरी छींनी मनी तछा येसु उसिसराए याङ़ाक गालील खन्‍दलाव तिबेरियास दहक सरैंःसिके। नक इताव ताके — ");
INSERT INTO kjl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","नक लिज़्‍यावर सिमोन पत्रुस, दिदुमस यादोज़्याव थोमा, गालीललाव काना नाखारलाव नथानेल, जब्‍दियाए ओज़ानी स़ोनो छुत ऩेब्‍लो उसिसनी याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","नो बेलाक सिमोन पत्रुसए ओनैंरालाई, “ङा ते ङाँःर क्‍योःना ची तखेप ङाबारिज़्‍या,” है ओरादोक ते, ओनैंराए, “गे मनी नँस ज़ गेबारिज़्‍या,” है दाद नोर प़ाइँ दोङ्गाल पसिद ऱील तुबुरी लिद ब ङाँःर तोबो ब माताकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","नम ज़राँः ज़राँः उसँनाक येसु दह छ्योक च्‍याँःसिद उलिज़्‍याव। खाली उसिसराए येसु ज़ लिद मासरेस्‍धुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","हाःत ज़ येसुए, “अ बाबुज़ार, ङाँःर खावा तार्‍या की?” है ओरादोक ते, “अहँ, तोबो ब मातार,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","नकिन येसुए, “जेदोङ्गाए ओवोर्दा जेजाल ख्याचिके, नल ङाँःर दैन्‍या जेले,” है ओरादोक ते, याजालर याख्याक ल्‍यो माल्‍यो ङाँःर हुद याजाल ब मास़ेल्‍धुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","हाःत ज़ येसुए उयुँलाव उसिसए पत्रुसलाई, “नो ते गेप्रभु ज़ ची ओल्‍यो,” है ओदोव प़ाइँना पत्रुस लाला लुलु हाइसिउ ओक्‍वार क्‍वाइसिद दहल ज़ो·द येसुए ल्‍योदा बाके। ");
INSERT INTO kjl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","उपुर्काव उसिसर ते दोङ्गाल ज़ लिद ङाँःर ल्‍यो जाललाई स़ेले स़ेले पाखात पुलुस्‍केर। नो ङाँःर याराक्‍योःव पो कोसै तादाङ ते ओमाल्‍यो, दह छ्योकिन तसय मितरवा वाज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","नोर दह छ्योक याहुवत मेंः दासिउ म़ुथाल येसुए भरेसर ङाँःर हिप्‍द ओनैज़्‍याव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","नाःत ज़ येसुए, “जेराक्‍योःव ङाँःर ऩेबरेंवा रैचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","सिमोन पत्रुस दोङ्गाल पसिद नो ङाँःर लिज़्‍याव जाललाई पाखात स़ेल्‍द रैक्‍यो। नल घेप्‍पा घेप्‍पा ङाँःर तसय त्रिपन्‍न गोता यागैव ओल्‍यो। हितावत मनी नो जाल जात्त ज़ ओमाचिसो ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","नकिन येसुए फरी नोरालाई क़िद, “जेयाः बितालिहुचिके,” है यादोक्‍यो। नोराए फरी येसुलाई यासरेस्‍दी ब सुए ज़ ‘नँ ते गेप्रभु ची सा’ है मादोधुकेर। ");
INSERT INTO kjl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","येसु हुद भरेसर ङाँःर उकुइत रैद नोरालाई भाःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","येसु सिद सैंसिद ओसोव छींनी उसिसराए ङ़ाक आवस स़ोंखेप सरैंःसिके। ");
INSERT INTO kjl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","नोर यायाःर याबितालिउत येसुए सिमोन पत्रुसलाई, “अ यूहन्‍नाए ओज़ा सिमोन, नँ ङालाई आवराकिन कुधु ज़ मया नदाँज़्याव रो?” है ओदोक ते, पत्रुसए, “हैज़ प्रभु, नँलाई मया ङादींज़्याव नँ ज़ नसैंज़्‍या,” है ओदोक ते, येसुए, “हो ची ताकिन्‍दा ङापाथार छोद्याँके।” ");
INSERT INTO kjl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","नकिन येसुए फरी ब, “अ यूहन्‍नाए ओज़ा सिमोन, ङालाई साचो ज़ मया नदाँज़्याव रो?” है ओदोक ते, पत्रुसए, “हैज़ प्रभु, नँलाई मया ङादींज़्याव नँ ज़ नसैंज़्‍या,” है ओदोक ते, येसुए, “हो ची ताकिन्‍दा ङाबेधारालाई याचिऊयो,” है दोक्यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","फरी ब येसुए, “अ यूहन्‍नाए ओज़ा सिमोन, है जैद ङालाई मया नदाँज़्याव ज़ रो?” है ओदोक ते, पत्रुसलाई नो पाँ स़ोंखेप है ओदोवए पत्रुसए उयुँ माचाव दाद, “प्रभु प़ाइँ युँलाव पाँ नसैंज़्‍या। नँलाई मया ङादींज़्याव मनी नँ ज़ नसैंज़्या सानी,” है ओदोक ते, येसुए, “हो ची ताकिन्‍दा ङाबेधार पाथस छोद्याँके। ");
INSERT INTO kjl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ङा नँलाई साचो है ङादींज़्‍या, नर्सार उलिज़्‍याव बेलाक नवाँःफोर पो·सिद जोदा बान्‍या नयुँ लिज़्‍या होदा ज़ नबाज़्‍याव। खाली नर्सार खेम्‍द नसेरोत नकरर रा·द्याद नवाँःफोर छुतए पो·द्याद बान्‍या युँ नमादोज़्‍यावदा करस ज़ लाँन्‍या लेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","येसुए आव पाँर, ‘पत्रुस इतावनी सिद परमेस्‍वरए उमिन सघ्‍योःद्यान्‍या ले’ लिद ङ़ादा ज़ सतैंदिक्‍यो। है जैद येसुए पत्रुसलाई आव भरी है दाद, “ङाछींत हुन्‍के,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","नाःत ज़ पत्रुस उछींदा ओभाल्‍सिक येसुए उयुँलाव उसिस मनी उछीं उछीं उहुज़्‍याव रँःक्‍यो। नो उसिस ज़ ङ़ादाङाव नो भत्‍यारल येसुए ओछातीत कँ लिद, “प्रभु, नँलाई धोका याज़्‍याव सु?” है दाज़्‍याव मिँ। ");
INSERT INTO kjl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पत्रुसए नोलाई रँःद येसुलाई, “प्रभु, आवलाई छींनी कै तान्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","येसुए, “ङा फरी ङामाहुवा पै नो मिँलाई मासिन्‍या ङाजैदी ब नँ है लिन्‍या काता ओमेला ज़ माले, नँ ङाछींत घुहुनी,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","नो येसुए ओपाँनी ज़ नो उसिस सिन्‍या माले लिन्‍या यायुँ हुबोराए खार्ल फींजिके। खाली ओल येसुए ते ‘आव सिन्‍या माले’ है ओदोव ते माःक। ‘ङा फरी ङामाहुवा पै आव मिँ ओमासिदी ब नँ है लिन्‍या ओमेला माले,’ है वाज़ ओदोव ची। ");
INSERT INTO kjl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","आव पाँर ङामीए रँःद सर्ज़्‍याव ङा नो उसिस ज़। आव ङासरो पाँ भरी साचो थ॰रिउ ज़ लिज़्या। ");
INSERT INTO kjl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","आव ङासरोकिन येसुए छुत ब कुधु य़ेनर ज़ दाद नैव। खाली तोबो तोबोनी सर्न्‍या ताकिन सर्सिउ पोस्‍तोकोर आव मानुवात ब मासुइँःखेहो।");
INSERT INTO kjl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","माननिय थियोफिलस ज्‍यू, ङ़ादाङाव ङासरो पोस्‍तोकोल, येसु ओय़ेनत उथूसिउकिन स्‍वर्गत ओबाज़्‍याव छ्याम पैकाव ओय़ेनर ओपाँर प़ाइँ ज़ सर्द नैद ङाईंए। हो छ्याम ज़ ओराछाँतिउ ओसाचीरालाई छैंव पुरूसए ओसक्तीनी ‘आव आव दोच्‍यो’ है दाद याख्यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","होकिन ङ़ादा ज़ बनै दुखस उसिउ छींनी येसु सैंसिद चालीस दिन भरी घरी पाला ज़ नोराए याङ़ाक सरैंःसिद, ‘आव ङा ज़’ लिद ओसरेसर ब सतैंद ओराएज़्‍याव, परमेस्‍वरए ओराज्‍यालाव पाँर ब ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","तछा नोरास ज़्यान्याए जूँनी दुप्‍सिद यालिज़्याक, “जे यरूसलेम माऱास्‍द ङाबाबु परमेस्‍वरए ओय़ाकालाई कींद नैचिके। ङा जेलाई नो ओय़ाकाए जूँनी ङ़ादाकिन ज़ है दाद ङानैचिए। ");
INSERT INTO kjl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","किताव यूहन्‍नाए जेलाई ऱील ओसछैंचिउ, हिताव ज़ जाँ छींनी छैंव पुरूसनी जेछैंरिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","नोर तछा दुप्‍सिद यालिज़्‍याक उसिसराए येसुलाई, “प्रभु, सैं आव बेलाक ज़ इस्राएलीराए गेराज्‍या रोमीरानी सोवोल्‍द नयासिरिज़्‍याव रो?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","येसुए, “बेला त़ोन्‍या, जुक त़ोन्‍या ङाबाबु परमेस्‍वरए उकुइत लिज़्‍या, जे सैंन्‍या ओमेला माले। ");
INSERT INTO kjl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","बुरू जे जेक्‍याँत छैंव पुरूस उहुक बनै घ्‍योःव सक्ती दैद यरूसलेमल, यहूदियाल, सामरियाल स़ोनो नामलाव काना कुनीङ पै ङासाचीर जेतारिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","हाःत ज़ येसु नोराए याङ़ाकिन ज़ याचिऊज़्‍याक ज़ नमदा छींसिद बादलए लुम्‍बैद मासरैंःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","नोराए नमदा लँ लँ याचिऊज़्‍याक होक ज़ उमँःजानी पालो क्‍वा क्‍वाइसिउनी ऩेब्‍लो याङ़ाक च्‍याँःसिहुकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","नोनी, “अ गालीललाव मिँर, काराव नमदा भाल्‍सिद जेलिज़्‍याव? नो जेङ़ाकिन बाव येसु किताव नमदा उछींसिज़्‍याव जेरँःव, हिताव ज़ फरी तछा झरिहुरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","हाःत ज़ येसुए उसिसर जैतून दाँदातिन झरिद नजिककाव यरूसलेम सहरदा बाकेर। नो दाँदातिन आधा घन्‍तावाकाव येम उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","सहरल केस्‍द नोर हाः बेलाकाव यालिज़्‍याव ओतर्ताव ताललाव कुन्‍तील बाकेर। नो कुन्‍तील पत्रुस, यूहन्‍ना, याकूब, अन्‍द्रियास, फिलिप, थोमा, बारथोलोमाइ, मत्ती, अल्‍फयसए ओज़ा याकूब, देसभक्ता सिमोन स़ोनो याकूबए ओज़ा यहूदास सिप ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","नोरास नल येसुए ओआमा मरियम, येसुए ओभाइर स़ोनो येसुसकाव मेंमार दिनकाव ज़ दुप्‍सिद प़ाइँए तयुँ जैद पोंखारिउ ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","तछा यायुँ हुबोर तसय बीसा दुप्‍सिद यालिज़्‍याक पत्रुस नोराए याङ़ाक च्‍याँःसिद अइ लिद पाँके, ");
INSERT INTO kjl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“अ ङानैं ङामेंर, आदा थैचिके। येसुलाई सूँपिज़्‍याव यहूदा इस्‍करियोतए उजूँनी भाःकाव धर्मसास्‍त्रलाव सर्सिउ पाँ भरी यो·के। नो पाँ भरी छैंव पुरूसए ङ़ादा ज़ दाऊद राजाए ओयाःनी है लिद ले। ");
INSERT INTO kjl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","नो मिँ ङ़ादा गेस ज़ ओल्‍यो। आव गेय़ेनत मनी नोए उजुँ ब ओल्‍यो ज़।” ");
INSERT INTO kjl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","नो मिँ येसुलाई क्‍योःन्‍या घुस ज़्‍याद नो पैसाए एँः तोबो लँःक्‍यो। नो एँःल ज़ बाप तेद उभूँदीर पा·द च्याल्नी ब्याल ताद सिके। ");
INSERT INTO kjl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","यरूसलेम सहर भरिल नो पाँ थास्‍द नो एँःए उमिन या याखामनी आखेल्‍दामा नैदिकेर। नोए ओअर्थ ‘झीए एँः’। ");
INSERT INTO kjl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पत्रुस फरी, “होए उजूँनी ङानैं ङामेंर, भजन पोस्‍तोकोल इताव सर्सिउ लिज़्‍या, ‘नोए ओपो रितो ओताक, नल बासिन्‍या सु ज़ तातारक।’ स़ोनो, ‘ओदैव य़ेन ब छुतए ओनैंवक।’ ");
INSERT INTO kjl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","है जैद गेप्रभु येसुलाई रँःव, ङ़ादाकिन गेस गेस बाऱिउ मिँ नोए ओपोल तोबो जैव ताके — गे मिताव ज़ नो मनी येसु सिउनी सैंसिद ओसोव साची याधुन्‍याकाव ओताक। नो मिँ ऱील सछैंज़्‍याव यूहन्‍नाए ओपालाकिन येसु स्‍वर्गत ओबाज़्‍याव पै गेस गेस लिज़्‍याव मिँ ज़ ताव परिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","नोराए तोबो योसेफ बारसाबास यादोज़्याव (नोलाई युस्‍तस मनी है यादोज़्याव), स़ोनो तोबो मतियास यादोज़्‍याव, नोनी ऩेब्लोए निमिन हाइद, ");
INSERT INTO kjl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","अइ लिद परमेस्‍वरलाई पोंखारिकेर, “अ प्रभु प़ाइँए युँलाव पाँ सैंज़्याव, यहूदाए ते गेसकाव ओय़ेनलाई ऱास्‍द सराप दैन्‍या ओपोल ज़ बाके। है जैद नोए ओऱासो य़ेनत आव ऩेब्‍लोनी काताकावलाई नैन्‍या नपैंज़्याव, गेलाई सतैंद्याव ताके।” ");
INSERT INTO kjl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","नोनी निमिनत गोला याझाःक मतियासए उमिन परिके। है जैद नो एघार जनात चा·सिके। ");
INSERT INTO kjl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","पेन्‍तिकोस पर्ब हुद उलिज़्‍याव। हो छ्याम पोंखारिन्‍याए जूँनी येसुए उमिनतावर प़ाइँ दुप्‍सिद यालिज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","उमँःजानी नमतिन बुर बुर फर्लेसिहुज़्‍याव बनै घ्‍योःव बतासए ओर्गा मिताव थास्द नो दुप्‍सिद यालिज़्‍याव झ़िमल ज़ तसी ताके। ");
INSERT INTO kjl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","हाःत ज़ मेंःए मुल्‍का स्‍यासोर रैंःहुद नो मुल्‍कार आदा होदा रा·सिनाद प़ाइँए याक्‍याँत ज़ तोबो तोबो च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","नाःत ज़ नोर छैंव पुरूसए ब्याल्‍द नो पुरूसए ओरायो मिताव प़ाइँ ज़ छुत छुत खामनी पाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","नो बेलाक पर्बए जूँनी प़ाइँ राज्‍यानिकाव यहूदीर यरूसलेमल हुद यालिज़्‍याव। नोर परमेस्‍वरलाई रँःद छे·ज़्यावर याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","नो घ्योःव गा थैद मिँर बनै माहोल्‍या प़ाइँनी ज़ धोंःहुद नो झ़िमलाव दुप्‍सिउराए यापाँज़्‍याव सु सु याखामनी ज़ थैद अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","नोर बनै अचम्‍ब ताद, “आव पाँज़्‍यावर ते प़ाइँ गालीललाव मिँर ची सानी। ");
INSERT INTO kjl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","कै जैद आवराए यापाँ सु सु गेखामनी गेथैज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","गे ख्वार पार्थीया, मादी स़ोनो एलामीनी हुवर गेलिज़्‍या। ख्वार फरी मेसोपोतामियालावर, यहूदियालावर, कापादोकियालावर, पोन्‍तसलावर, एसियालावर, ");
INSERT INTO kjl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रिगियालावर, पामफिलियालावर, इजिपलावर स़ोनो लिबिया देसलाव कुरेनी जीदाङावर गेलिज़्‍या। ख्वार फरी रोमनी हुवर ब लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(नोर ख्वार यहूदी जातलावर लिज़्‍यार, ख्वार यहूदी धर्म मानिज़्याव छुत जातलावर ब लिज़्‍यार।) ख्वार फरी क्रेत तापु स़ोनो अरब देसनी हुवर गेलिज़्‍या। कै जैद परमेस्‍वरए ओसक्तीलाव ओदोव य़ेनर सु सु गेखामनी ज़ यापाँज़्‍याव गेथैज़्‍याव?” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","है जैद नोर बनै अचम्‍ब ताद ‘आवए ओअर्थ काता ओताव?’ लिद या याल सुधिसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ख्वाराए फरी ल़॰द, “आवर ते मँःवर ची सा,” है ब लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","हाःत ज़ पत्रुस स़ोनो एघार जना येसुए उसिसर च्‍याँःसिद पत्रुसए ओर्गा बनै सघ्‍योःद नो माहोल्‍यारालाई है यादोक्‍यो, “अ यहूदियालाव मिँर स़ोनो यरूसलेमल लिज़्‍यावर, आदा थैचिके। आव जेरँःव भरी पलास्‍द ङायाचिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जे है जेलिज़्‍याव मिताव आवर मँःवर माःक। भर्ज़ा ज़ छकाल्‍न्‍याकाव नौ बजिद ले सानी। ");
INSERT INTO kjl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","आव जेरँःज़्‍याव भरी ते योएल अगमबक्ताए सर्द ओनैज़्‍याव पाँ ची। नोए ओसरो आव ज़, ");
INSERT INTO kjl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘परमेस्‍वरए है लिज़्‍या, जुक खेम्‍न्‍या बेलाक ङा मिँ भरिराए क्‍याँत ङापुरूस थुद ङाराएरिज़्‍या। जे खेपा मेंमा जेज़ाराए ङापुरूसनी पाँन्‍या लेर। जेसकाव धापाज़ाकावराए दर्सनर रँःन्‍या लेर। जेसकाव सेरोराए मनी अचम्‍बलाव मँर मँन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हो बेलाक ङाय़ेन दाज़्‍याव ङाबाँदा ङाबाँदानीराए याक्‍याँत ङापुरूस थुद ङाराएक नोर ङापुरूसनी पाँन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","रोताव नमत छे छे ङम्‍सिउर रैंःन्‍यार ङाराजैरिज़्‍या, उधूँलाव नामल मनी अचम्‍बलाव सरेसर ङासतैंरिज़्‍या — झी स्‍यासोर, मेंःए मुल्‍कार, सुम्‍ला सुम्‍ला म़िकुइर। ");
INSERT INTO kjl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","परमेस्‍वर बनै ज़गै मगैवस उहुरिज़्‍याव छ्याम ओमाताद ङ़ादा निमीए ओझ़ार ब चुम चुमो तारिज़्‍या, स़्यावै मनी झी स्‍यासो घ्याम घ्यामो तारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","हो बेलाक जोए परमेस्‍वरए उमिन हाइद ओललाई खिम्‍ज़्‍याव, नो सजानी पुलुस्‍द बाँचिन्‍या ले।’ ");
INSERT INTO kjl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“जे इस्राएली ङानैं ङामें भरिए, आव ब सैंच्‍यो। नासरतलाव येसुए परमेस्‍वरए ओसक्ती दैद जे जेखार्ल ज़ अचम्‍बलाव य़ेनर स़ोनो सरेसर ओदोव जे ज़ जेरँःके। नो ओदोव ओय़ेननी ज़ परमेस्‍वरए, ‘ङा ज़ ङापरींव’ लिद जेलाई ज़ थ·रैव परींचिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","जे ते झन नो मिँलाई परमेस्‍वरए ङ़ादाकिन ज़ गोइँद ओनैज़्‍याव मितावनी ज़ नोलाई परमेस्‍वरए ओपाँ मासैंज़्‍यावराए कुइत सूँपिद क्रुसत तङ्गैद सैःव जेरापरींके। ");
INSERT INTO kjl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","परमेस्‍वरए फरी नोलाई सिउनी सोचोइद सिउका सिउ तान्‍यानी उस्‍कैक्‍यो। है जैद नोलाई खादरल काताए ब मानैधुक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","नोए उजूँनी दाऊद राजाए मनी ङ़ादा ज़ धर्मसास्‍त्रल अइ लिद सर्द नैव, ‘ङाप्रभुलाई एकतार ङास ज़ उलिज़्‍याव ङारँःज़्‍या। ङावोर्दा च्‍याँःसिद धुरिद ओयाँज़्‍यावए, काताए ब ङायुँलाई काता माँःती माजैधुव। ");
INSERT INTO kjl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","है जैद ङायुँर बनै होलाँ ताद, ङायाःए ब रेंद ङापाँज़्‍या। ‘ङापुरूसलाई सिउराए याल्‍योल ख्यानैद्यान्‍या नमाले’ लिद, आव ङाजिउत ङायुँ हुबो ज़ लिज़्‍या। ङा, छैंव नमींलाई खादरल चिउ यान्‍या नमाले। ");
INSERT INTO kjl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","अजम्‍बरी जुनील बान्‍या येम ङालाई नपैनाके। है जैद नँ ङालाई नँस ज़ नैद, ङायुँर होलाँ जैद्यान्‍या नले।’ ” ");
INSERT INTO kjl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","हाःत ज़ पत्रुसए फरी ब है यादोक्‍यो, “अ ङानैं ङामेंर, साचो ज़ है ङालिज़्या — गेपुर्खा दाऊद ते ङ़ाङ ज़ सिद गमल बाके। ओखादर आःपै गेस ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","खाली नो मिँ अगमबक्ता ओतावए छींनी हुन्‍या पाँर ब सैंद ओनैज़्‍याव। परमेस्‍वरए नोलाई ङ़ादा ज़ किर्‍या झाःद, ‘नँ नथोरानी ज़ ङाराज्‍या चलैन्‍या मिँ ङाउथैरिज़्‍या,’ है दाद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","है जैद दाऊदए छींनी तान्‍या पाँर उरँःव मिताव ज़ ताद ख्रीस सिउनी ओसैंसिरिज़्‍यावए जूँनी ज़ ओपाँव। है जैद ङ़ादा है उलिज़्‍याव मिताव ज़ ख्रीस सिउराए ल्‍योल ब मारहिए, ओक्‍याँ ब खादरल माचिए। ");
INSERT INTO kjl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","नोलाई ओल परमेस्‍वरए ज़ सोचोइक्‍यो। नो पाँ रँःज़्‍यावर गे प़ाइँ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ओबाबु परमेस्‍वरए येसुलाई मान याद ओवोर्दा च़ुसिउ परींद ओय़ाकालाव छैंव पुरूस एक्‍यो। येसुए नो पुरूसलाई ज़ आछिम गेक्‍याँत थुद्यासिक्‍यो। नो जेरँःज़्‍याव जेथैज़्‍याव भरी हो ज़। ");
INSERT INTO kjl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","स्‍वर्गत पुलुस्‍द परमेस्‍वरए ओल्‍योङ बाव दाऊद माःक। नोए उजूँनी ब ओल दाऊदए अइ लिद पाँके, ‘परमेस्‍वरए ङाप्रभुलाई, ‘नसुतुररालाई नखँ धूँल झाःद ङामाईंवा पै, ङावोर्दा च़ुसिद लिन्‍के,’ है दोक्‍यो।’ ");
INSERT INTO kjl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","है जैद जे इस्राएली जातलाव प़ाइँ मिँराए आव सैंच्‍यो, नो क्रुसत जेसैःव येसुलाई ओल परमेस्‍वरए ज़ अजम्‍बरी जुनी यान्‍या ख्रीस ब थ·रैद्यासिक्‍यो, नाम स़ोनो नमतावराए गेप्रभु ब जैद्यासिक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","नो माहोल्‍याराए पत्रुसए ओपाँ थैद यायुँ माचाव दाद पत्रुस स़ोनो येसुए छुत ओसाचीरालाई, “ओहो! ङादाज्‍यु भाइर, हिताव ताकिन ते गे कै लिन्‍या ओताव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पत्रुसए फरी, “जेपापलाई ऱास्‍द परमेस्‍वरस सखैसिन्‍याए जूँनी जेयुँर त़ोद येसु ख्रीसए उमिनत ऱील सछैंसिचिके। हो ताकिन ची छैंव पुरूस परमेस्‍वरए ल्‍योनी बरदान मिताव दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","नो पुरूस दैन्‍या य़ाका जेलाई, जेज़ारालाई स़ोनो तादा तादा लिज़्यावर, जो जोलाई गेप्रभु परमेस्‍वरए ओल्‍योदा खुल्‍सिउर लिज़्यार, होराए जूँनी ज़ लिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पत्रुसए कुधु पाँर सथैद, “आव जुकलाव पापी मिँराए ल्‍योनी पुलुस्‍द बाँचैसिचिके,” लिद यासम्‍जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","हो छ्याम पत्रुसए ओपाँ भैंःद परमेस्‍वरए उमिनत चा·सिहुवर स़ोंहजारा याल्‍यो। नोर प़ाइँ ज़ ऱील सछैंसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","नोर हाःकिन येसुए ओसाचीरास प़ाइँ तोबो झ़िमलाव मिताव ताद, नोराए यापाँ पैसिद, प्रभु-भोजल दुप्‍सिद पोंखारिउ ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","मिँ भरी प़ाइँ छे·वर यालिज़्‍याव। येसुए ओसाचीराए अचम्‍बलाव य़ेनर, अचम्‍बलाव सरेसर दाव ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","येसुए ओपाँत हुव भरी ते प़ाइँ तोबो झ़िमलाव मिताव ताद यासकाव लिज़्‍याव भरी दुप्‍द याखार्त ज़ जैद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","याधन सम्‍पतीर यो·द या या माथैंव मायो·वल सघैसिउ ज़ यानैसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","दिनकाव ज़ ध्‍यान झ़िमल दुप्‍सिद ननी भाःसिद याबावत झ़िम झ़िमक यानैंरास दैसिद या याल बनै खैद रेंद काँर ब सिप याज़्‍युज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","परमेस्‍वरए ल्‍योदा खुसी ताद परमेस्‍वरए उमिन ब सघ्‍योःद याएज़्‍याव। मिँराए ब नोरालाई चाव ज़ यारारँःज़्‍याव। है जैद यायुँ हुप्‍ज़्यावर परमेस्‍वरए दिनकाव ज़ याबगालल चा·द ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","तछा पोंखारिन्‍या बेलाक तीन बजेवाक पत्रुस स़ोनो यूहन्‍नानी ध्‍यान झ़िमदा निबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","हो बेलाक तोबो जर्मननी ज़ घ्‍याँस्‍या ताव मिँलाई ओनैंराए ध्‍यान झ़िमदा घुर्द यालाँज़्‍याव। नो मिँ दिनकाव ज़ ‘चाव’ यादोज़्‍याव य़ामक च़ुसिद ध्‍यान झ़िमल पसिज़्‍यावरास पैसा उऩिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पत्रुस स़ोनो यूहन्‍नानी ध्‍यान झ़िमल निहुज़्‍याव रँःद नो मिँए नोनिस ब ऩिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","हाःत ज़ पत्रुसए, ओनैं यूहन्‍नास, नोलाई चिऊद, “आदा भाल्‍सिन्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","नोए, ‘कातार याँनी सैं’ लिद उयुँ नदा ज़ झाःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पत्रुसए फरी, “ङास सुन चाँदी ते माले, खाली जो लिज़्‍या, हो ज़ ङाईंरिज़्‍या। नासरतलाव येसु ख्रीसए उमिननी च्‍याँःसिद बान्‍के,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","नोलाई वोर्फताव उकुइनी क्‍योःद ओसोचोइव प़ाइँना ज़ उखँर पलास्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","नो फुतु ज़ो·द च्‍याँःसिद आदा होदा लिके। पत्रुस स़ोनो यूहन्‍नानिस ध्‍यान झ़िमल पसिद बनै ज़ो·द परमेस्‍वरए उमिन सघ्‍योःद ‘धन्‍या धन्‍या’ है ल्‍यो ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","परमेस्‍वरए उमिन निताव सघ्योःद ओबाऱिज़्याव रँःद ध्‍यान झ़िमल लिज़्‍याव मिँ भरिए नोलाई सरेस्‍द, ");
INSERT INTO kjl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“ओहो! आव ते नो ‘चाव य़ामक’ च़ुसिद ऩिज़्‍याव घ्याँस्‍या ची सानी। कै जैद बाधुन्‍या ओताव?” लिद अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","हाःत ज़ मिँ भरी बनै अचम्‍ब ताद नो ध्‍यान झ़िमलाव सोलोमन मैरा यादोज़्‍यावल पत्रुस स़ोनो यूहन्‍नानी निल्‍योक धोंःहुकेर। हाःपै नो गराँव घ्याँस्‍या ओरेंतए नोनिलाई लाप्‍द उनिनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","पत्रुसए मिँर याहुज़्‍याव रँःद नोरालाई, “अ इस्राएली ङादाज्‍यु भाइर, काराव आवलाई रँःद अचम्‍ब ताद जेलिज़्‍याव? सैं गिनलाई, ‘नी निसक्ती नितपसनी ज़ सोजोकाव निजैव ताखेहो,’ है लिद जेचिऊसिज़्‍याव रो? ");
INSERT INTO kjl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","गेपुर्खा अब्राहाम, इसहाक स़ोनो याकूबराए यापरमेस्‍वर, ओल ज़ आज्‍याल ओज़ा येसुलाई ज़गै मगै जैक्‍यो। नो येसुलाई जे ते झन सूँपिद सैःन्‍या जेथ·रैके। पिलातसए नोलाई ऱासो ओपैंज़्‍यावत ब जे भैंःद जेमाएके। ");
INSERT INTO kjl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","है जैद ओखत माल्‍यो छैंव मिँलाई अऩाकल ज़ भीःद झन होए ओपोल मिँ सैःज़्‍यावलाई ऱासो परींद, ");
INSERT INTO kjl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","प़ाइँए गेस॰ झाःद्याज़्‍याव गेधर्मीलाई जेसैःके। नोलाई फरी परमेस्‍वरए सिउनी ओसोचोइव गे गेमीए ज़ गेरँःके। ");
INSERT INTO kjl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","नो है ङालिज़्‍याव येसुए उमिननिकाव सक्तीए ज़ आव जेरँःज़्‍याव जेसरेस्‍ज़्‍याव मिँ सोजोकाव ताद ले। नो येसुए उमिनत गिनयुँ गिन्सुहुबोनी ज़ आल जेङ़ाक ओक्‍याँर हालाँ होलों गराँद ले। ");
INSERT INTO kjl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“आव ब ङासैंज़्‍या ङानैं ङामेंर, जेघेप्‍पाराए यादोव मिताव ज़ जे मनी येसुए ओक्‍याँताव जेदोव भरी मासैंद ज़ जेदोके। ");
INSERT INTO kjl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","हुनी ज़ अगमबक्ताराए यायाःनी ङ़ादा ज़ ‘ख्रीसए दुखर दैन्‍या ले’ लिद ओपाँव पाँर यो·के। ");
INSERT INTO kjl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","है जैद जेपापलाई क्‍याल्‍न्‍याए जूँनी जेयुँर त़ोद परमेस्‍वरए ल्‍योदा सखैसिचिके। हो ताकिन ची परमेस्‍वरए युँलाई होलाँ जैद्यान्‍या असिकर जेक्‍याँत जैद्याद, ");
INSERT INTO kjl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","जेजूँनी ङ़ादाकिन ज़ खतैद नैद ओयाचिउ येसु ख्रीसलाई फरी तछा परींद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","खाली नोकिन ङ़ादा आव नाम नमलाव परमेस्‍वरए ओय़ेन भरी दाद ओमातुपैवा पै येसु स्‍वर्गत ज़ लिन्‍या ले। नो बेलाए जूँनी परमेस्‍वरए भाःकिन ज़ छैंव अगमबक्ताराए यायाःनी है ल्‍यो ज़ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मोसाए मनी अइ लिद पाँके, ‘जेजातलाव मिँराए याखार्नी ज़ परमेस्‍वरए जेजूँनी तोबो ङा मिताव अगमबक्ता उथैद्याचिरिज़्‍याव। जे नोए ओपाँ भरित बनै धिद ल्‍यो ताके। ");
INSERT INTO kjl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","जोराए नोए ओपाँ माभैंःर होराए यामिन ओपो·स ज़ परमेस्‍वरए ओथोनी क्‍याल्‍सिन्‍या ले।’ ");
INSERT INTO kjl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“हो मिताव ज़ अगमबक्ता भरी, समूएलए ओपालाकिन छींनीकाव पाला पैकावर प़ाइँए आव बेलाए जूँनी ज़ पाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","नो अगमबक्ताराए याथोर जे ज़ जेतावए नो जेजिज्‍यु बाज्‍युरास परमेस्‍वरए ओनैव बाचालाव पाँ भरी जे जेक्‍याँत ज़ हुके। नो पाँ ङ़ादा परमेस्‍वरए अब्राहामलाई अइ लिद एक्‍यो, ‘नँ नथोरानी ज़ मानुवाताव प़ाइँ जातलाव मिँराए असिक दैन्‍या लेर।’ ");
INSERT INTO kjl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","है जैद जेदोज़्‍याव पापरानी फर्कैद असिकर यान्‍याए जूँनी परमेस्‍वरए ओसेवा दान्‍या उथैद ओनैज़्‍याव येसुलाई उस॰कत जे जेल्‍योक ज़ परींद्याचिक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","हाःत ज़ पत्रुस स़ोनो यूहन्‍नानी माहोल्‍यारास निपाँज़्‍याक ज़ ध्‍यान झ़िमलाव पाल्‍याराए कप्‍तान, नलाव पुजारीर स़ोनो सदुकीर नोनी निल्‍योक केस्‍हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","पत्रुस स़ोनो यूहन्‍नानी ‘येसु सिउनी ओसैंसिउए छुत सिउर ब सैंसिन्‍या लेर’ लिद थ·रैद निराएज़्यावए नोर बनै यारिस चोके। ");
INSERT INTO kjl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","है जैद नोनिलाई क्‍योःद जाँ ऱिमदा ऱिमदा ओतानावए हो पराःती खोले·न्‍याए जूँनी झ्यालखानाल यारानैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","हैदी मनी नोनी निपाँ थैज़्‍यावरानी कुधुए भैंःद येसुए ओपाँत चा·सिहुकेर। नो ङ़ादाङाव भैंःज़्‍यावरास प़ाइँ जैद पाँच हजारा तानाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","हो पराःती यहूदीराए याघेप्‍पार, यास़ेरर स़ोनो सास्‍त्रीर प़ाइँ यरूसलेमल दुप्‍सिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","नोरास प्रधान पुजारी हन्‍नास ब उलिज़्‍याव। नोस फरी कैयाफा, यूहन्‍ना, अलेक्‍जेन्‍दर स़ोनो छुत नोए ओखलकलाव घेप्‍पा पुजारीर ब यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","नोराए पत्रुस स़ोनो यूहन्‍नानिलाई घ्‍योःव कचरी ङ़ाक यारासच्‍याँक नो घेप्‍पाराए नोनिलाई खोले·द, “आव घ्याँस्‍यालाई काताए ओसक्तीनी, सुए उमिननी जिन्‍सगराँव?” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","पत्रुस छैंव पुरूसए ब्याल्‍द, “अ यहूदीराए याघेप्‍पार, यास़ेरर, ");
INSERT INTO kjl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","गिन आव घ्याँस्‍यालाई गिनयुँ नाद गिन्‍सगराँवए जूँनी जेखोले·सिज़्‍याव ताकिन, गिन नोलाई कै जैद गिन्‍सगराँव लिक ते, ");
INSERT INTO kjl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","जे स़ोनो इस्राएली भरिराए आव सैंच्‍यो — जे क्रुसत जेसैःव, परमेस्‍वरए सिउनी ओसोचोइव नासरतलाव येसु ख्रीसए उमिननी आव मिँ जेङ़ाक सोजोकाव ताद च्‍याँःसिद ले। ");
INSERT INTO kjl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","धर्मसास्‍त्रलाव आव पाँ होए उजूँनी ज़ सर्सिउ लिज़्या — ‘भुलीराए कान्‍ल ज़ माज़्‍यासे लिद याख्याव लुँ नो ज़ झन भुयाँरलाव लुँ ताके।’ ");
INSERT INTO kjl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","है जैद पापए सजानी पुलुस्‍न्‍या उपुर सुए ओल्‍योनी ब माले। गे मिँरालाई अजम्‍बरी जुनी दैन्‍या मनी आव मानुवाताव मिन भरिरानी उपुर सुए उमिन ब यासिउ माले,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","पत्रुस स़ोनो यूहन्‍नानी निलेखा प़री काता ज़ ओमालिदी ब नियुँ हुप्‍द पक्‍कास निपाँज़्‍याव रँःद नो कचरीलाव घेप्‍पार बनै अचम्‍ब ताद, ‘आवनी ते येसुसकावनी ज़ निल्‍यो’ लिन्‍या थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","फरी नो निसगराँव मिँ ब याङ़ाक सोजोकाव ज़ च्‍याँःसिद उलिज़्‍याव रँःद कातानी ज़ मापाँधुद थाम थुम ज़ ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","है जैद नोनिलाई कचरीनी लाँःदा पले·द या याज़ जलफल दाद, ");
INSERT INTO kjl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“आवनिलाई कै जैन्‍या ओताव? आवनी तोबो अचम्‍बलाव य़ेन निदोव यरूसलेम भरी प़ाइँए सैंज़्‍यार, नो पाँत ‘माःक’ है गेमालिधुइ। ");
INSERT INTO kjl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","खाली नो पाँ झन आदा होदा माफींजैन्‍याए जूँनी नोनिलाई हप्‍कैद, ‘येसुए उमिननी सुरास ज़ तापाँचिन’ है लिद अर्थैव ताके,” है लिन्‍या थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","है जैद नोनिलाई कचरील फरी ब खुल्‍द रैद, “जिन अबकिन येसुए उमिननी सुलाई ज़ काता पाँर सथैन्‍या ब माःक, पैन्‍या ब माःक,” है लिद याराअर्थैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","हाःत ज़ पत्रुस स़ोनो यूहन्‍नानी, “परमेस्‍वरए उयुँ किताव उलिज़्‍याव, जे ज़ सैंचिके — जे जेपाँ दान्‍या सैं ओल ओपाँ दान्‍या? ");
INSERT INTO kjl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","गिन ते गिन्थैव स़ोनो गिन्‍रँःव भरी कै जैद मापाँन्‍या?” है निरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","नो घेप्‍पाराए फरी ब यारासिङार्केर। खाली मिँ भरिए नोनी निदोव य़ेनत परमेस्‍वरए उमिन बनै सघ्‍योःद यापाँज़्‍यावए नोनिलाई कैज़ माजैधुद याराऱास्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","निताव अचम्‍बलाव य़ेननी निसगराँव मिँ ते चालीस बर्सकिन यादाङाव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पत्रुस स़ोनो यूहन्‍नानी निऱास्‍सिउ छींनी निनैंराए ल्‍योक बाद नो मुख्या पुजारीर स़ोनो यहूदीराए यास़ेरराए है यारादोव भरी है यारादोकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","नोराए निपाँ भरी थैद प़ाइँए तयुँ जैद परमेस्‍वरलाई अइ लिद पोंखारिकेर, “अ गेप्रभु, आव नाम नम स़ोनो ऱीर जैज़्‍याव नँ ज़। नलाव लिज़्‍याव भरी जैज़्‍याव ब नँ ज़। ");
INSERT INTO kjl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","नँ छैंव नपुरूसनी ज़ ननोकोर गेपुर्खा दाऊद राजाए ओयाःनी अइ लिद नपाँके, ‘मानुवाताव मिँर काराव यारसिज़्‍याव? काराव अऩाकलाव य़ेनत बुद्धी याकलैज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","मानुवाताव राजार स़ोनो मिँराए याघेप्‍पार प़ाइँ दुप्‍सिद परमेस्‍वर स़ोनो छाँतिद ओनैज़्‍याव ख्रीसकिन तँदा जैसिकेर।’ ");
INSERT INTO kjl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","साचो ज़ प्रभु, आव सहरल ज़ हेरोद स़ोनो पन्‍तियस पिलातसनी छुत जातलाव मिँर स़ोनो इस्राएलीरास खैद, छाँतिद ननैज़्‍याव छैंव नज़ा येसुकिन तँदा जैसिद, ");
INSERT INTO kjl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","नँ ङ़ादाकिन ज़ नयुँल गोइँद नरायो य़ेन ब दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","अब ते, गेलाई हप्‍कैद सचे·व यापैंज़्याव नँ ज़ चिऊके, प्रभु। स़ोनो गे ननोकोररालाई ब नपाँ सथैन्‍या माछे·द ज़ पाँन्‍या जैसियो। ");
INSERT INTO kjl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","नो गेरासथैज़्‍याव पाँत फरी नँ नसक्तीए ज़ छैंव नज़ा येसुए उमिननी याजोरो हुवर ब ओगराँरक, अचम्‍बलाव सरेसर, अचम्‍बलाव य़ेनर ब ओतारक,” ");
INSERT INTO kjl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","है लिद पोंखारिकेर। हो प़ाइँना ज़ नो दुप्‍सिद यालिज़्याव झ़िम बनै थोनो·सिद, छैंव पुरूसए ब्याल्‍द प़ाइँए परमेस्‍वरए ओपाँ माछे·द ज़ यारासथैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","येसुए ओपाँत बाज़्‍यावर प़ाइँ खैद तोबो युँस ज़ यालिज़्‍याव। यासकाव लिज़्‍याव भरी ब प़ाइँ याखार्त जैद ‘आव ङामीं ज़’ है लिद सुए ज़ है यामालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","येसुए ओसाचीराए फरी बनै सक्तीस, ‘येसु सिउनी सैंसिद स्‍वर्गत बाके’ है लिद प़ाइँलाई ज़ सथैद प्रभुए ओसाची याराएज़्‍याव। उपुर्काव येसुए ओपाँत लिज़्‍यावरालाई मनी परमेस्‍वरए ओअसिक याक्‍याँत ज़ ओताज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","याखार्ल माथैंव मायो·व मिँर ब सु ज़ यामालिज़्‍याव। याझ़िम, याएँः ल्‍योर नो भरी यो·द ओएः भरी रैद, ");
INSERT INTO kjl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","नो पैसार येसुए ओसाचीराए ल्‍योक यादुप्‍ज़्‍याव। स़ोनो जोल चाहिज़्‍या होल नो पैसार भाःद याराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","हाः बेलाक नोरास तोबो साइप्रस तापुनी हुव लेबी थरलाव योसेफ यादोज़्‍याव उलिज़्‍याव। येसुए ओसाचीराए नोए उमिन बारनाबास नैदिकेर। (नोए ओअर्थ ‘युँ सझेंःद्यान्‍या’।) ");
INSERT INTO kjl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","नोए पाला तोबो ओएँःलाई यो·द ओएः भरी येसुए ओसाचीराए ल्‍योक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","फरी तोबो हननिया यादोज़्‍यावए ओज्‍या सफीरास निएँः तोथो यो·द, ");
INSERT INTO kjl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ओरेए नो एँःए ओएः ओज्‍यासकाव निसल्‍लाए तभा ओलस नैद उपुर्काव भरी येसुए ओसाचीराए ल्‍योक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ओसाचीराए ल्‍योक ओरैव प़ाइँना ज़ पत्रुसए, “ए हननिया, कै जैद सैतानए नयुँल पसिद छैंव पुरूसलाई धुतैव उपरींनिज़्‍याव? नो एँःए ओएः तभा नँस नैद ‘आःज़’ है नलिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","नो एँः ङ़ादा नँ नमीं ज़ ओल्‍यो। यो·द ओएः भरी जो नजैदी ब नमाहाँ ज़ ओल्‍यो। कै जैद नयुँल इताव नचेतैव? नँ गेलाई नधुतैसिज़्‍याव माःक, परमेस्‍वरलाई नधुतैज़्‍याव ची,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हननिया नो पाँ भरी ओथैव प़ाइँना नक ज़ धलिद सिके। नो थैवर प़ाइँ ज़ बनै छे·केर। ");
INSERT INTO kjl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","हाःत ज़ नक लिज़्‍याव धापाज़ाकावराए नोए ओमोरोलाई क्‍वाए लुम्‍बैद गादैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","नो भरी ओताव स़ोंघन्‍ता छींनी हननियाए ओज्‍या सफीरा मनी नक हुके। ओरेलाई अइ ताके लिन्‍या काता ज़ ओमासैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","हाःत ज़ पत्रुसए, “नो जिन्‍यो·व एँःए ओएः आःज़ रो?” है ओदोक ते, नोए, “नाः ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","नकिन पत्रुसए फरी, “जिन ज्‍या-रीए काराव परमेस्‍वरए उपुरूसलाई उयुँ कोला कोला जैद्यान्‍या बुद्धी जिन्कमैव? दे, नरेलाई गादैना बावर य़ामक ज़ हुद लेर। नँलाई मनी लाँद गादैनिरिज़्‍यार,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","नो मनी होक ज़ धलिद उस॰ फ्या·के। हाःत ज़ नो ओरेलाई गादैना बाव छोर्‍यार खादरनी ओल्‍द हुद झ़िमल यापसिक ओज्‍यालाई मनी सिउ ज़ दैकेर। नोलाई मनी लाँद ओरेए ओलापक ज़ गादैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","नो पाँनी ज़ मन्‍दली भरी स़ोनो उपुर्काव थैज़्‍याव मिँ भरी ब बनै छे·केर। ");
INSERT INTO kjl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","हाः बेलाक मिँराए याखार्ल येसुए ओसाचीराए याक्‍याँनी ज़ अचम्‍बलाव सरेसर ओताज़्‍याव। येसुए ओपाँत लिज़्‍यावर प़ाइँए तयुँ जैद ध्‍यान झ़िमलाव सोलोमन मैराल दुप्‍सिउ ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","उपुर्काव मिँराए नोरालाई बनै घ्‍योःव यारामानिदी ब नोरास खदेप लिन्‍या याछे·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","हैदी ब कुधु मिँर, खेपा मेंमा प़ाइँ प्रभुए ओपाँत चा·सिहुव ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","मिँराए, “याजोरो हुवराए याक्‍याँत पत्रुसए ओसाँ वाज़ उपरिदी ब गराँन्‍या ज़ लेर,” लिद नो याजोरो हुवरालाई याझेलोङ्गा यातैंरास पत्रुसए ओयेमक यारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरूसलेम सहर लापजीकाव नाखार नाखारलाव मिँराए मनी याजोरो हुवर स़ोनो माचाव पुरूसराए क्‍योःद यारानैज़्‍यावरालाई येसुए उसिसराए ल्‍योक यारारैक नोर मनी यागराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","छींनी प्रधान पुजारी स़ोनो ओलसकाव सदुकी दललाव ओनैंराए येसुए ओसाचीरालाई रँःद यामी बनै तूद, ");
INSERT INTO kjl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","नोरालाई क्‍योःद झ्यालखानाल याराझाःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","हो छ्याम रील परमेस्‍वरए ओचाकर्‍या हुद झ्यालखानालाव य़ामर फैद्याद नोरालाई पले·द, ");
INSERT INTO kjl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जे ध्‍यान झ़िमल बाद प़ाइँए याङ़ाक च्‍याँःसिद आव साःरो जुनीए जूँनी ओपो·स ज़ यारासथैचिके,” है दाद याख्यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","नोए है ओरादो पाँ भैंःद नोर नम उसँनाक ध्‍यान झ़िमल बाद मिँरालाई यारासथैकेर। हो छ्याम ज़ छकाल्‍न्‍या प्रधान पुजारी स़ोनो ओलसकाव लिज़्‍याव ओनैंराए इस्राएल देसलाव यास़ेररालाई घ्योःव कचरील दुप्‍द तोबो ऩेब्‍लो यासिपाईंरालाई नो झ्यालखानाल लिज़्‍याव येसुए ओसाचीरालाई च़ानाव यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","नोर बाद झ्यालखानाल सुलाई ज़ यामारादैवए ननी ओल्‍द बाद नो घेप्‍पारालाई, ");
INSERT INTO kjl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“गे झ्यालखानाल गेबाक प़ाइँत ज़ तालकुची झाःसिउ लिज़्‍या, पाल्‍यार मनी य़ामक च्‍याँःसिउ ज़ लिज़्‍यार। खाली य़ाम फैद नल गेराचिऊक ते सु ज़ मालेर,” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","नो ध्‍यान झ़िमलाव पाल्‍याराए याकप्‍तान स़ोनो मुख्या पुजारीराए नो पाँ थैद, “अब कै तान्‍या ओताव?” लिद यायुँ बनै आँचानी पाँचा ओताज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","हो प़ाइँना ज़ याल्‍योक तोबो मिँ हुद, “दे, नो झ्यालखानाल जेराझाःव मिँर ते ध्‍यान झ़िमल ची च्‍याँःसिद प़ाइँलाई ज़ येसुए ओपाँ यारासथैज़्‍यार,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","नो ध्‍यान झ़िमलाव कप्‍तान उसिपाईंरास लाला लुलु बाद नोरालाई ननी कचरी झ़िमल चावस ज़ यारारैकेर। “मिँराए गेलाई लुँराए प़ोसिर्‍या,” लिद जबरज्‍यास्‍ती क्‍योःन्‍या याछे·ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","नो घ्योःव कचरील दुप्‍सिउ स़ेरराए याङ़ाक फरी ब यारासच्‍याँवत नो प्रधान पुजारीए, ");
INSERT INTO kjl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“गे जेलाई ‘येसुए उमिननी काता पाँर ब तारासथैच्‍यो’ है गेदाचिउ सैं माःक? जे ते झन नोए ओपाँ यरूसलेम भरिल फींजैद, नोलाई यासैःव गल्‍ती ब गे गेङ़ैत झाःव जेपैंज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पत्रुस स़ोनो येसुए छुत ओसाचीराए, “मिँराए यापाँकिन बुरू गे परमेस्‍वरए ओपाँ भैंःव ताके। ");
INSERT INTO kjl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","नो क्रुसत तङ्गैद जेसैःव येसुलाई गेजिज्‍यु बाज्‍युराए यापरमेस्‍वरए ज़ सिउनी सोचोइक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","नोलाई ज़ फरी परमेस्‍वरए स्‍वर्गताव प़ाइँरानी ओमान ल्‍यो झेंःव पोल नैद गेराजा जैद्यासिक्‍यो, पापनी ऱास्‍न्‍या ब जैद्यासिक्‍यो। गे इस्राएलीरालाई गेयुँर त़ोद्याद गेपापर क्‍याल्‍द्यान्‍या ओल ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","गे फरी नो पाँ भरित ओसाचीर गेलिज़्‍या। खाली गे वाज़ माःक, छैंव पुरूस ब लिज़्‍या। नो पुरूस गे परमेस्‍वरए ओपाँ भैंःज़्याव भरिरालाई गेक्‍याँत ज़ याद नैसिउ,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","नो घ्‍योःव कचरीलाव मिँराए पत्रुसए ओपाँ भरी थैद यायुँर बनै कोला कोला ताद नो उसिसरालाई सैःव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","हाःत ज़ तोबो यासकाव गमलिएल यादोज़्‍याव नो कचरीराए याङ़ाक च्‍याँःसिके। नो मिँ बनै मान दैव फरिसीरासकाव कानुनलाव यागुर्बा ओल्‍यो। है जैद नोए येसुए उसिसरालाई तखेप लाँःदा पले·व परींद नो घेप्‍पारालाई है यादोक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“अ इस्राएली ङानैंर, आवराए याक्‍याँत जेदोरिज़्‍याव य़ेन बनै जोगोइसिद वाज़ दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","नो तालाङाव थुदासए मनी तघरीत ज़ उमिन बनै सघ्‍योःद ओल्‍योदा चार सयवा मिँर याजैक्‍यो। छींनी नोलाई यासैःवत उमींर प़ाइँ चितराँ पुतराँ ताद उमिन ज़ म़ाके। ");
INSERT INTO kjl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","नकिन फरी नो गालीललाव यहूदाए मनी, जनसंख्‍या यासर्ज़्‍याव बेलाक, मिँरालाई सर्बा ज़ ओल्‍योदा याजैक्‍यो। नोलाई मनी यासैःक उमींर आदा बाकेर लिन्‍या ज़ माताके। ");
INSERT INTO kjl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","है जैद आछिम ङा जेलाई आव सल्‍ला ङायाचिज़्‍या — आव मिँरालाई कैज़ ताराजैच्‍यो, बुरू याराऱास्‍चिके। आवराए याबिचार याय़ेनर अइज़ मिँनिकाव हुव ताकिन नो ओलनी ज़ म़ान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","नो याय़ेन फरी परमेस्‍वरनिकाव हुव ताकिन जे वैंधुन्‍या जेमाले। झन परमेस्‍वरकिन तँदा जैसिद ओलस लरैं जेदोज़्‍याव मिताव तान्‍या ले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","नोराए नोए ओपाँ भैंःद येसुए ओसाचीरालाई फरी ब याल्‍योक खुल्‍द, “येसुए उमिननी काता पाँर ब तारासथैच्‍यो,” लिद हप्‍कैद रीःद अइज़ याराऱास्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","नोर नो कचरीनी पुलुस्‍द, ‘परमेस्‍वरए गेलाई येसुए उमिनत दुख सहिन्‍या स्‍यासोर ओथ·रैसिउ ओल्‍यो’ लिद बनै रेंए रेंए बाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","नकिन दिनकाव ज़ ध्‍यान झ़िमल स़ोनो मिँराए झ़िम झ़िमक दुप्‍सिद, “येसु परमेस्‍वरनी हुव ख्रीस ज़,” लिद च़िम मादाद सथैव ज़ यारानैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","हाः बेलाक येसुए ओपाँत बाज़्‍यावर सर्बा याबा·नावत यासकाव ग्रीक पाँज़्याव यहूदीर हिब्रू पाँज़्याव यहूदीराए याङ़ैत जाँ यारूम्‍रूमैज़्‍याव। हिब्रू पाँज़्याव यहूदीराए माथैंव मायो·वरालाई दिनकाव ज़्‍यावर भाःद याराएक कैताक ग्रीक पाँज़्याव राँदी मेंमारालाई बलेंद याराख्यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","है जैद बाह्र जना येसुए उसिसराए परमेस्‍वरए उमिनतावरालाई दुप्‍द, “गे परमेस्‍वरए ओपाँ सथैज़्‍यावराए नो गेध्‍यावनालाई ऱास्‍द ज़्‍यावर भाःद्यान्‍या जाँ माज़्‍यासे। ");
INSERT INTO kjl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ङानैं ङामेंर, बुरू जे ज़ नो य़ेन चलैन्‍यात जे जेखार्नी ज़ सात जना यातह ल्‍यो छैंव पुरूसए ब्यालो यामान ल्‍योरालाई याराखतैचिके। ");
INSERT INTO kjl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","गे ते परमेस्‍वरलाई पोंखारिद ओपाँ सथैन्‍या ध्‍यावना वाज़ गेदोरिज़्‍या,” है यारादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","प़ाइँए ज़ भैंःद नोरालाई याराखतैकेर। उस॰कतावए उमिन स्‍तिफनस। नो मिँ परमेस्‍वरए ओपाँत बनै थ॰रिउ, छैंव पुरूस दैव मिँ ओल्‍यो। नकिन फिलिप, प्रखरस, निकनोर, तीमोन, पर्मिनास, स़ोनो एन्‍तिओखिया सहरनी हुद ङ़ादा ज़ यहूदी जैसिउ निकोलाउसलाई ब जैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","आव भरिरालाई येसुए ओसाचीराए याल्‍योक यारारैक, नोराए पोंखारिद असिक ऩिद्याद याकुइ याङ़ैत झाःद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","परमेस्‍वरए ओपाँ झन ज़ फैलिद, यरूसलेमल येसुए ओपाँत हुज़्‍यावर बनै ज़ याबा·ज़्‍याव। पुजारीर मनी कुधुए ज़ यायुँ उहुप्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","नो स्‍तिफनसए परमेस्‍वरए ओअसिक स़ोनो ओसक्तीर ओक्‍याँत ओतावए, मिँराए खार्ल बनै अचम्‍बलाव य़ेनर ओदोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","हो बेलाक ज़ यरूसलेम सहरल ‘फुर्सुल ताव’ है यारादोज़्याव यहूदीराए धर्मसास्‍त्र झ़िम तोबो जैद यानैज़्‍याव। नोर ख्वार कुरेनी स़ोनो अलेक्‍जेन्‍द्रिया सहरनी हुवर, ख्वार किलिकिया स़ोनो एसिया खन्‍दनी हुवर यालिज़्‍याव। नोर स्‍तिफनसकिन तँदा जैसिद नोस खर्लेसिउ ज़ यालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","खाली स्‍तिफनस परमेस्‍वरए उपुरूसनी ओदैव बुद्धीनी ओपाँवए नोराए ओपाँ जात्त ज़ मापल्‍तैधुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","है जैद नोराए अऩाकलाव पाँर ससैद, “ ‘आव मिँ मोसाए उउपर्त स़ोनो परमेस्‍वरए उउपर्त माचाव ओपाँज़्‍याव गे ज़ गेथैके’ है लिचिके,” लिद मिँरालाई यारामचैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","नोराए माहोल्‍यार, यहूदीराए यास़ेरर स़ोनो सास्‍त्रीरालाई मनी यारामचैकेर। नकिन प़ाइँ ज़ स्‍तिफनसए ल्‍योक हुद नोलाई क्‍योःद, नो घ्योःव कचरीलाव घेप्‍पाराए ङ़ाक लाँद सच्‍याँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","नोए उजूँनी ख्वार धुत गोहाईर जैसिद, “आव मिँ एकतार ज़ गेध्‍यान झ़िम स़ोनो मोसाए ओकानुनए उउपर्त पाँव ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","आवए ते झन, ‘नो नासरतलाव येसुए ध्‍यान झ़िमलाई तैःद, मोसाए ओयासिउ चलनर ब त़ोद्यान्‍या ले,’ इताव पाँर है उलिज़्‍याव ब गेथैके,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","हाःत ज़ नो घ्योःव कचरील दुप्‍सिद लिज़्‍याव भरिए स्‍तिफनसलाई लँ लँ याचिऊक ओङाः परमेस्‍वरए ओचाकर्‍याए ओङाः मिताव ज़गै ज़गैव रँःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","हाःत ज़ नो घ्योःव कचरीलाव प्रधान पुजारीए, “आव नङ़ैत झाःद याईंज़्‍याव पाँर साचो सैं माःक?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्‍तिफनसए, “अ ङास़ेरर, ङादाज्‍यु भाइर, आव ङापाँ थैचिके। गेपुर्खा अब्राहाम हारानल ओमाबाद, ङ़ादा मेसोपोतामिया देसल उलिज़्‍याक ज़ ज़गै मगैव परमेस्‍वर ओङ़ाक सरैंःसिद, ");
INSERT INTO kjl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘आव नलिज़्‍याव देस स़ोनो नक्‍याँदाङावरालाई ऱास्‍द नँलाई सतैंद ङाईंरिज़्‍याव पोङ लिनान्‍के,’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","अब्राहाम ओल उलिज़्‍याव कल्‍दीराए यादेसलाई ऱास्‍द हारानल बाद नल ज़ जाँवा पै लिके। नकिन ओबाबु उसिउ छींनी परमेस्‍वरए आव गेलिज़्‍याव पोल ज़ सारैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“खाली हो बेलाक आव देसल ओल लिन्‍या पो परमेस्‍वरए तके ब ओमाएताव, ओज़ार मनी तोबो ब यामाताताव। हितावत मनी परमेस्‍वरए नोलाई, ‘आव पो नँ नपो स़ोनो नथोर लिन्‍या पो जैद ङायाचिरिज़्‍या,’ है लिद य़ाका याद ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","खाली होए उजूँनी परमेस्‍वरए इतावनी ब पाँके, ‘नँ नथोर छुतराए यादेसल खासिद लिद नोराए याधूँल चार सय बर्स पै याबाँदार ताद दुख ब दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","छींनी ङा ज़ नो बाँदा ताद यालिज़्‍याव देसलाई सजा ङाएरिज़्‍या। हाःकिन नो नथोर ननी पुलुस्‍द आव ङायाचिरिज़्‍याव पोल ङासेवा दाहुन्‍या लेर,’ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","नकिन परमेस्‍वरए अब्राहामलाई बाचालाव क्‍याल्‍न्‍या सरेस एक्‍यो। है जैद अब्राहामए ओज़ा इसहाक उजर्मिउ आथ दिनत नो सरेस जैदिक्‍यो। नकिन इसहाकए ओज़ा याकूब ताके, याकूबए ओज़ार बाह्र जना बाह्र थरराए यापुर्खार ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“याकूबए ओज़ा योसेफलाई छुत ओदाज्‍युराए यामी तूद इजिप देसदा यो·केर। हैदी ब परमेस्‍वर योसेफस ओल्‍योए, ");
INSERT INTO kjl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","उदुख भरिनी जोगोइद, नोलाई बनै अचम्‍बलाव बुद्धीर याद इजिपलाव राजा फारोलाई योसेफए ओल्‍योदा दाइनो जैक्‍यो। है जैद नो राजाए योसेफलाई इजिपलाव हाकिम जैद दरबार चलैन्‍या ब जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“छींनी इजिप स़ोनो कनान देस भरिल घ्‍योःव अनिकाल हुद प़ाइँलाई ज़ बनै दुख ताके। गेपुर्खाराए मनी ज़्‍याव मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","है जैद याकूबए ‘इजिपल ज़्‍यावर दैसिज़्‍या दी’ लिन्‍या बयेन थैद ओज़ारालाई नदा तखेप ज़्‍यावर लँःनाव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","फरी छींनीकाव पालाकाव ओरापरींक योसेफ ओदाज्‍यु भाइराए याङ़ाक सरेस्‍सिके। हाःकिन राजा फारोए मनी योसेफए उझ़िमलावरालाई यासरेस्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","नाःत ज़ योसेफए, ओबाबु याकूब स़ोनो ओक्‍याँदाङाव भरिरालाई ‘आदा ज़ उहुरक’ लिद क़िनाव यापरींक्‍यो। नोर प़ाइँ जैद पचहत्तर जना याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","है जैद याकूब इजिपल बाद नल ज़ सिके। गेपुर्खार ब नल ज़ सिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","खाली नोराए यामोरोर नल मानैद, अब्राहामए हमोरए ओज़ाराए याल्‍योनी उलँःव सकेम नाखार ङ़ाकाव खादर पुपल ज़ यारागादैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“हाःकिन ज़ परमेस्‍वरए अब्राहामलाई ओयो य़ाका सयो·न्‍या बेला उहुनावत नोए ओथोर इजिपल ज़ लिद बनै ज़ बा·नाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","छींनी इजिपल योसेफए उमिन माथैव तोबो साःरो राजा पुलुस्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","नो राजाए गेखलक भरिरालाई जाल दाद बनै दुख याएक्‍यो। याभाउज़ारालाई मनी सफ्या·न्‍याए जूँनी करस ज़ पाखादा पले·व ओरापरींज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“होए ओपालाक ज़ मोसा जर्मिके। नो भाउज़ा परमेस्‍वरए उयुँलाव ज़ ओल्‍यो। नोलाई स़ोंमैना पै ओबाबु ओआमानी निझ़िमल ज़ म़ोंद ङाकेनी। ");
INSERT INTO kjl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","छींनी नोलाई पाला पाखाङ ख्‍याद यानैज़्याक राजाए मेंमा ओज़ाए नोलाई लाँद ओल ओज़ा ज़ जैद ङाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","है जैद मोसाए इजिपलाव प़ाइँ ग्‍यान सिऊसिद, सैंन्‍या स़ोनो दान्‍या भरित बनै ओगहक ल्‍यो मिँ ताके। ");
INSERT INTO kjl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“चालीस बर्स ओतावत ओभेरा इस्राएलीरास दैसिन्‍या युँ दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","है जैद तछा याल्‍योक ओबाक तोबो इजिपीए इस्राएलीलाई ओप़ोज़्‍याव रँःद नो प़ोसिउलाई धुरिद्याद उखिस फेरैद्याद, प़ोज़्‍यावलाई सैःदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ओल उयुँल ते, ‘ङाभेरारालाई यादुखरानी फुर्सुल जैन्‍या परमेस्‍वरए ङालाई जैद नैनाव। आव पाँ नोराए मनी सैंज़्‍याखेरहो,’ है उलिज़्‍याव। खाली नोराए मासैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","है जैद हो पराःती मनी याल्‍योक ओबाक ऩेब्‍लो इस्राएलीनी नी नी निखप्‍सिज़्‍याव रँःद, ‘अ ङानैंनी, जिन दाज्‍यु भाइनी काराव जिन जिन ज़ जिन्प़ोसिज़्‍याव?’ लिद नोनिलाई सखैव ओपैंज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","नो ङ़ादा छुपिउए मोसालाई हुतैद, ‘नँलाई गेङ़ैताव ताद पाँ फाल्‍न्‍या सुए ओजैनिउ? ");
INSERT INTO kjl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","काता नँ आझ्‍योकाव इजिपीलाई नसैःव मिताव ङालाई ब सैःव नपैंज़्‍याव रो?’ है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","मोसाए नो पाँ थैद ओछ्याचेए धोंःद मिद्यान देसल खासिद लिनाके। नल ज़ ओज़ानी ब दुई भाइ ताकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“मोसा नल ओल्‍यो चालीस बर्स ओतावत सीनै खागरताव बनल झोपोरा चाँःज़्‍यावनी परमेस्‍वरए ओचाकर्‍या ओङ़ाक सरैंःसिके। ");
INSERT INTO kjl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मोसाए नो झोपोरा ओलनी ज़ ओचाँःज़्‍याव रँःद बनै अचम्‍ब ताद जाँ ओल्‍योकसै बाद चिऊद ओनैज़्‍याक परमेस्‍वरए ओर्गाए, ");
INSERT INTO kjl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ङा जेजिज्‍यु बाज्‍युराए यापरमेस्‍वर, अब्राहाम, इसहाक स़ोनो याकूबराए यापरमेस्‍वर ज़,’ है लिन्‍या ओथैव प़ाइँना मोसा ओछ्याचेए बनै गूद माभाल्‍सिधुके। ");
INSERT INTO kjl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","हाःत ज़ परमेस्‍वरए, ‘नखँताव पोला हाइके, नँ च्‍याँःसिद नलिज़्‍याव पो चोखो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","इजिपल लिज़्‍याव ङामीं इस्राएलीराए धो सहिउ दुखर यादैज़्‍याव ङा ज़ रँःद ङानै। नोर यागहनिज़्‍याव ब थैद ङानै। है जैद नोरालाई जोगोइना हुद ङाले। दे नँ झाःसिन्‍केदा, इजिपदा ङापरींनिरिज़्‍या,’ है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“है जैद नो ङ़ादा ‘नँलाई गेङ़ैताव ताद पाँ फाल्‍न्‍या सुए ओजैनिउ?’ है लिद यामाभैंःव मोसालाई ओल परमेस्‍वरए ज़ चाँःज़्याव झोपोरानी पाँज़्याव ओचाकर्‍यालाई ओल्‍योक परींद्याद झन यालाई जोगोइन्‍या याङ़ैताव जैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","मोसाए नोरालाई ननी ओरासारैक इजिपल, लाल समुन्‍द्रल, स़ोनो चालीस बर्स पै याल्‍यो बनल अचम्‍बलाव य़ेनर सतैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","नो मोसाए ज़ फरी नोरालाई, ‘परमेस्‍वरए जेजातलाव मिँराए याखार्नी ज़ जेजूँनी तोबो ङा मिताव अगमबक्ता उथैद्याचिरिज़्‍याव,’ है ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","नो मोसा मनी नोरास चालीस बर्स भरी बनल लिद सीनै खागरत परमेस्‍वरए ओचाकर्‍या स़ोनो गेसाखा पुर्खाराए याखार्लाव त्‍याला ताद नो बाँचिन्‍या पाँर गेलाई मनी यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“खाली नोराए झन ओपाँर माभैंःद ओललाई ज़ भीःकेर। यायुँ जम्‍मा याऱासो पो इजिपदा वाज़ खोतोरो याजैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","है जैद नोराए मोसाए ओदाज्‍यु हारूनलाई, ‘गेलाई इजिपनी पले·ज़्‍याव मोसा काना ओबाव सुए ज़ गेमासैंए। है जैद नँ ज़ गेलाई गेङ़ा गेङ़ा बान्‍या देवतार जैद्याव ताके,’ है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","नो बेलाक बाछाए अङग्‍या तोबो जैद नो अङग्‍याए उमिनत मार सैःद चरैःद बनै घ्‍योःव जात्रा जैकेर। नो अङग्या याज़ याजैवए बनै रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“है जैद परमेस्‍वरए ओङाः तँदा फर्कैद, ‘आवरालाई कै जैद ब माताके’ लिद, ‘नमताव स़्यावै, निमी, सोरोरालाई ब पुजा घदोज़्‍यारक ते,’ है लिद याऱास्‍क्‍यो। होए उजूँनी अगमबक्ताराए यासरो पोस्‍तोकोल ब इताव सर्सिउ लिज़्‍या, ‘अ इस्राएललाव मिँर, नो चालीस बर्स भरी बनल जेलिज़्‍याकाव मारर सैःद जेचरैःव ङा ङाजूँनी माःक। ");
INSERT INTO kjl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","खास जे यासेवा दान्‍याए जूँनी जैद जेस जेरालाँव मोलोख देवता लिन्‍या पाल स़ोनो सोम्‍पा सोरोए ओअङग्‍यानी ची। है जैद ङा जेलाई जबरज्‍यास्‍तीस बेबिलोन देसदा ङालाँचिरिज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“हो बेलाक ज़ गेसाखा पुर्खारास बनल यालिज़्‍याक परमेस्‍वरए ओध्‍यान दान्‍या पाल ब उलिज़्‍याव। नो पाल परमेस्‍वरए मोसालाई सतैंद ओयो गोइँनी ज़ जैसिउ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","छींनीकाव प़िरील मनी गेसाखा पुर्खाराए यहोसूस कनान देसल याबाक नो पाल यास ज़ यालाँज़्‍याव। हो बेलाक ज़ नो देसलाव छुत जातरालाई परमेस्‍वरए खेपैद ओरायोनी नो पो गेसाखा पुर्खाराए यामीं ज़ ताके। है जैद नोर नल लिद दाऊद राजाए ओपालाक पै नो पाल यास ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद परमेस्‍वरए उयुँलाव मिताव मिँ ओतावए नोए ‘नँलाई लिन्‍या पो तोबो झ़िम जैद गेईं रो’ लिद याकूबए ओपरमेस्‍वरलाई बिन्‍ती दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","खाली नो झ़िम होए ओपालाक माताद ओज़ा सोलोमनए ओपालाक वाज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“हैदी ब ओल माहान परमेस्‍वर उलिन्‍या पो ते मिँए जैसिउ झ़िमल माःक। अगमबक्ताए मनी परमेस्‍वरए ओपाँ अइ लिद सर्द नैव, ");
INSERT INTO kjl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ङा ङासिंहासन स्‍वर्गत लिज़्‍या। ङाखँ नैन्‍या पो नामल लिज़्‍या। इतावए ङाजूँनी किताव झ़िम ची जैद जेयाँरिज़्‍याव? ङा ङाऩासिन्‍या पो काङ्क ची उलिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","आव जेरँःज़्‍याव नाम नम भरी आव ङाकुइए ज़ ङाजैव माःक रो?’ ");
INSERT INTO kjl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“जे बनै मामुइलिउर, जेयुँ परमेस्‍वरए ओपाँ मासैंज़्‍यावराए यायुँ स्‍यासो लिज़्‍या। जेर्ना ब सूइसिउ मिताव ज़ ताद छैंव पुरूसनिकाव हुज़्‍याव पाँ भरी काता ज़ जेमाथैधुइ। जे जेय़ेन चबनै जेसाखा पुर्खाराए याय़ेन स्‍यासो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","नोरानी खिरी मापसिउ अगमबक्तार सु ची यालिज़्यावदा? नो ङ़ादा ‘परमेस्‍वरए छैंव उमीं गेल्‍योक हुरिज़्‍या’ है लिद सथैज़्‍याव भरिरालाई मनी ओपो·स ज़ यारासैःकेर। जे ते झन नो हुव ओज़ालाई ज़ धोका याद जेसैःके। ");
INSERT INTO kjl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","है जैद जे परमेस्‍वरए ओचाकर्‍यारानी परमेस्‍वरए ओकानुन दैवराए ते, जे ज़ झन नो कानुन जेमाभैंःके,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","नो घ्योःव कचरीलाव घेप्‍पाराए स्‍तिफनसए ओपाँ याथैवत यारिसए बूलिवा ताद याहार ङर ङर कैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","स्‍तिफनस ते छैंव पुरूसए ब्याल्‍द नमदा ओभाल्‍सिक परमेस्‍वरए ओज़गै ब रँःक्‍यो, परमेस्‍वरए ओवोर्दा येसु च्‍याँःसिद उलिज़्‍याव ब रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","हाःत ज़, “ओहो! नम फैसिउल मिँ मिन्‍सिउलाई परमेस्‍वरए ओवोर्दा च्‍याँःसिद उलिज़्‍याव ङारँःज़्‍या,” है ओल्‍यो प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","नोर बनै चिर चिर क़िद यार्नार सूइद, प़ाइँ ज़ भोरो·सिनाद, ");
INSERT INTO kjl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","नोलाई लुँए झेःद सैःन्‍याए जूँनी सहरनी स़ेल्‍द पाखाङ लाँकेर। हो बेलाक नोरास बाव तोबो साऊल यादोज़्‍याव धापाज़ाकाव ब उलिज़्‍याव। नो छ्याप लैज़्यावराए याफुतुर हाइद नोए उजिम्‍बाल नैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","नोलाई लुँ लुँए याझेःज़्‍याक स्‍तिफनसए परमेस्‍वरए उमिन हाइद, “अ प्रभु येसु, ङापुरूस नल्‍योदा लाँद्याँके,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","उघूँदानी तिकिसिद बनै चोइस, “अ प्रभु, आवराए ङाक्‍याँत यादोज़्‍याव पाप याक्‍याँत ताताक,” है ओल्‍यो प़ाइँना ज़ उस॰ फ्या·के। ");
INSERT INTO kjl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","नो साऊलए मनी, ‘आवलाई सैःन्या ज़’ लिद नोरास तयुँ ज़ ओजैज़्याव। हो छ्यामकिन ज़ यरूसलेम सहरलाव मन्‍दलीए उखिरी बनै पसिनाकेर। हुनी ज़ नोर प़ाइँ यहूदिया स़ोनो सामरिया खन्‍दल धोंःद रा·सिनाकेर। येसुए ओसाचीर वाज़ यरूसलेमल रहिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","हाः बेलाक फरी, धर्मी मिँराए स्‍तिफनसए ओमोरोलाई बनै घरे घरे लाँद गादैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","साऊलए ते मन्‍दलीलावरालाई बनै ज़ हाप हाप ख्याद झ़िम झ़िमक बाद खेपा मेंमा प़ाइँलाई ज़ क्‍योःद स़ेले स़ेले लाँद झ्यालखानाल ओराझाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","नो यरूसलेमनी धोंःद बावर प़ाइँदा रा·सिद जोङ याकेस्‍दी ब येसुए ओपाँ यारासथैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिपए सामरिया सहरल बाद परमेस्‍वरनी हुव ख्रीसए उजूँनी यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","नलाव मिँराए नोए ओपाँर थैद अचम्‍बलाव ओदोव य़ेनर रँःद ओपाँ बनै चावस थैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","माचाव पुरूसर कुधु मिँराए याक्‍याँतिन बनै चिर चिर क़िद पुलुस्‍द याबाज़्‍याव, स़ोनो याखँ याकुइ सिउर, दूँदार यागराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","है जैद नो सहरल मिँर बनै ज़ यारेंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","नो सहरल तोबो सिमोन यादोज़्‍याव बनै उमिन थासो धामी ब उलिज़्‍याव। नो बनै सघ्‍योःसिद ओमन्‍तर तन्‍तरए सामरियालाव मिँरालाई ङ़ादाकिन ज़ अचम्‍ब जैद ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","घेप्‍पा ज़िम्‍ज़ा मिँराए नोलाई बनै घ्‍योःव थ·रैद, “आव ज़ ची ओल्‍यो, परमेस्‍वरए ओसक्ती ल्‍यो मिँ,” है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","है जैद कुधु बर्स पै ओमन्‍तर तन्‍तरए अचम्‍ब ओराजैवए, प़ाइँए ज़ यामानिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","हाःत ज़ फिलिप यासहरल हुद येसु ख्रीसए उमिननी परमेस्‍वरए ओराज्‍यालाव चाव था ओरासथैक खेपा मेंमार कुधु ज़ ओपाँर भैंःद ऱील सछैंसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ओल सिमोन धामी मनी परमेस्‍वरए ओपाँत उयुँ हुप्‍द सछैंसिके। ओसछैंसिउ छींनी फिलिपस आदा होदा सिप सिप लिद फिलिपए ओदोज़्‍याव अचम्‍बलाव सरेसर य़ेनर रँःद बनै ज़ अचम्‍ब ताद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","छींनी यरूसलेमल लिज़्‍याव येसुए ओसाचीराए ‘सामरियालाव मिँराए मनी परमेस्‍वरए ओपाँ भैंःद लेर दी’ लिन्‍या याथैवत पत्रुस स़ोनो यूहन्‍नानिलाई नदा यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","नोनी नङ बाद नोरालाई छैंव पुरूस दैन्‍याए जूँनी परमेस्‍वरस पोंखारिद ऩिद याराएकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","हाःपै छैंव पुरूस याक्‍याँत ओमाहुताव, नोर प्रभु येसुए उमिननी वाज़ सछैंसिद यालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","है जैद नोनी निकुइ याक्‍याँत नैद्याद निपोंखारिक छैंव पुरूस दैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","नो सिमोन धामीए अइज़ निकुइ नैद निरायोनी ज़ नो पुरूस उहुज़्‍याव रँःद, होक ज़ ओपैसार हाइद, ");
INSERT INTO kjl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“दे ङास़ेरनी, निताव सक्ती ङालाई ब याव ताके। ङा मनी मिँराए याक्‍याँत ङाकुइ नैद ङाराएक छैंव पुरूस ओदैरक,” है उलिक ते, ");
INSERT INTO kjl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पत्रुसए, “नो नपैसा नँस ज़ ओम़ाक। नँ है नलिज़्‍याव मिताव परमेस्‍वरए ओअसिक ज़ खर्क पैसाए लँःद ओदैसिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","नँ नयुँ परमेस्‍वरकिन तँदा ओतावए आव पाँत नजुँ काता ज़ दैन्‍या नमाले। ");
INSERT INTO kjl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","आव दोव नपैंज़्‍याव माचाव य़ेननी नयुँर त़ोद परमेस्‍वरलाई पोंखारिद माफी ऩिके, कसा नपाप क्‍याल्‍द माईंव। ");
INSERT INTO kjl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","माछैंव य़ेनत नयुँ मानैधुद पापल सुर्सिउ मिताव नलिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","हाःत ज़ सिमोन बनै छे·द, “जिन ज़ परमेस्‍वरलाई पोंखारिद्याव ताके। आव है जिन्‍लिज़्‍याव मिताव काता ज़ ङाक्‍याँत ताताक,” है लिद बिन्‍ती दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","नकिन पत्रुस स़ोनो यूहन्‍नानी नो सहरल परमेस्‍वरए ओपाँ बनै चावस थ·रैद पलास्‍द निरायोत, फरी नोनी ननी पुलुस्‍द सामरियालाव नाखार याल चाव था सथैए सथैए यरूसलेमदा ओल्‍द बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","हाःत ज़ परमेस्‍वरए ओचाकर्‍या फिलिपए ल्‍योक सरैंःसिद, “नँ आनी बाद नो दखिनलाव यरूसलेमनी झरिद नाङग्‍या पात्‍या बनलाव घ्याँ गाजा सहरदा बाज़्याव येमदा बान्‍के,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","फिलिप च्‍याँःसिद बाके। नो येमत ओबाज़्‍याक नक तोबो इथियोपिया देसलाव सिङारू मिँ ब नदा ज़ ओबाज़्‍याव। नो मिँ इथियोपियालाव माहारानी कन्‍दाकीए ओपैसा चलैज़्‍याव मन्‍त्री ओल्‍यो। नो यरूसलेमल बाद ध्‍यान दाद, ");
INSERT INTO kjl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","उझ़िमदा ओल्‍द ओबाज़्‍याव। नो मिँ उगद्दील च़ुसिद यसैया अगमबक्ताए ओसरो पोस्‍तोको उप़रिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","हाःत ज़ परमेस्‍वरए उपुरूसए फिलिपलाई, “नँ नो गद्दीलाई दैनाद नोस बान्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिपए नोलाई धोंःनाद ओदैनाक नो मन्‍त्रीए यसैया अगमबक्ताए ओसरो पोस्‍तोको उप़रिज़्‍याव थैद, “नो नप़रिज़्‍यावए ओअर्थ नमाबुझिज़्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","नो मन्‍त्रीए, “ङालाई पैन्‍या मिँ माल्‍यो। कै जैद ङाबुझिधुरिज़्‍याव?” है दाद, फिलिपलाई ओलस च़ुसिउ परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","नो धर्मसास्‍त्रलाव उप़रिज़्‍याव खन्‍द आव ज़ ओल्‍यो, “पल्‍ना यालाँज़्‍याव बेधा माँःती नोलाई ब लाँकेर। याएन्‍ज़्‍याव पाथा ओमाक़िज़्‍याव मिताव नो मनी घाइ ज़ मालिके। ");
INSERT INTO kjl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","बिनु न्‍याय ज़ बीज्‍यात जैकेर। ओललाई ज़ यासफ्या·वए, ओथोर कातानी ची यारैंःरिज़्‍याव?” ");
INSERT INTO kjl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","नो मन्‍त्रीए फिलिपलाई, “ङालाई है दाँके, अगमबक्ताए आव पाँर ओल उजूँनी ओपाँव सैं छुतए उजूँनी ओपाँव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","फिलिपए, “आव भरी येसुए ओक्‍याँत ताव पाँर ज़,” लिद नो धर्मसास्‍त्रलाव खन्‍दनी ज़ येसुए उजूँनी चाव था पलास्‍दिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","येमत निबाज़्‍याक तोबो ऱी लिज़्‍याव पोक निहुवत नो मन्‍त्रीए, “दे आक ऱी लिज़्‍या, ङा नल सछैंसिन्‍या माताज़्‍या?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिपए, “नँ येसुए ओपाँत नयुँ उहुप्‍किन, ताए ज़,” है दोक्‍यो। हाःत ज़ नो मन्‍त्रीए, “येसु ख्रीस परमेस्‍वरए साचो ओज़ा ज़ लिद ङायुँ हुबो ज़ लिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","नो गद्दी चलैज़्‍यावलाई अदैव परींद नोनी ऩेब्‍लो ऱील बाद फिलिपए मन्‍त्रीलाई होक ज़ सछैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","नोनी ऱीनी निपुलुसो प़ाइँना परमेस्‍वरए उपुरूसए फिलिपलाई क्‍योःद छुतदा ज़ लाँक्‍यो। मन्‍त्री ते बनै रेंए रेंए उझ़िमदा बाद फिलिपस फरी मादैसिकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","नकिन फिलिपए ओल ओक्‍याँलाई अस्दोद सहरल दैद नजीदाङाव नाखार नाखार भरिल बाद कैसरिया सहरक पै चाव था यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साऊलए हाःपै प्रभुए ओपाँत लिज़्यावरालाई यामिन सम़ैद्यान्‍याए जूँनी उसुनी बनै फों फों ओमोज़्‍याव। है जैद प्रधान पुजारीए ल्‍योक बाद, ");
INSERT INTO kjl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","दमस्‍कस सहरलाव धर्मसास्‍त्र झ़िमलाव घेप्‍पारालाई सतैंद्यान्‍याए जूँनी पुर्जी कागत ऩिद ओनैज़्याव। नोए येसुए ओपाँत बाज़्‍याव खेपा मेंमारालाई साप्‍द क्‍योःद, यरूसलेमदा लाँन्‍या ओपैंज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","येमत ओबाज़्‍याक दमस्‍कस केस्‍न्‍यावाक उमँःजानी बनै मी झीःन्‍या ज़गै नमतिन म्‍याल्‍याकनी मिलिक हुके। ");
INSERT INTO kjl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","साऊल होक ज़ धलिद कातानी तोबो गाए, “ए साऊल, ए साऊल, नँ काराव ङाखिरी नपसिज़्‍याव?” है लिद ओपाँज़्‍याव थैक्यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","साऊलए फरी, “नँ सु प्रभु?” है ओदोक ते, नो गाए, “ङा नो ङाखिरी नपसिज़्‍याव येसु ज़। ");
INSERT INTO kjl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","नँ सोद सहरल बान्‍केदा, नङ ज़ नँ दान्‍या य़ेन भरी थैन्‍या नले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","साऊलस बाज़्‍याव ओनैंराए ते नो गा थैज़्‍यावत ब सुलाई ज़ यामारँःवए नोर बनै तोतास्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","हाःत ज़ साऊल सोद च्‍याँःसिद आदा होदा ओभाल्‍सिक उमी ज़ मारैंःके। है जैद ओनैंराए उकुइनी दोरैद दमस्‍कसल लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","स़ोंला भरी उमी मारैंःद, ज़्‍याव ब माज़्‍युक्‍यो, ऱी ब माओक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमस्‍कसल येसुए ओपाँत बाज़्‍याव तोबो हननिया यादोज़्‍याव उलिज़्‍याव। नोलाई दर्सनल परमेस्‍वरए, “अ हननिया,” है ओदोव ओथैक, “काराव प्रभु?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","परमेस्‍वरए फरी, “नँ सोद बजारलाव दाँव येम यादोज़्‍याव दोहाल बाद यहूदाए उझ़िमल पसिद, ‘तार्ससलाव साऊल काङ्क उलिज़्‍याव?’ है यादोनाके। नो साऊलए भर्ज़ा ज़ पोंखारिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","होए मनी दर्सनल नँलाई ज़ रँःनिज़्‍याव। नँ ओल्‍योक बाद, नकुइ ओक्‍याँत नैद उमी सरैंःद नएरिज़्‍याव ब सतैंद ङाएके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हाःत ज़ हननियाए, “ओहो प्रभु! आव है नलिज़्‍याव मिँए उजूँनी कुधु ज़ थैद ङानै। नोए यरूसलेमलाव छैंव नमींरालाई बनै ज़ दुख याएज़्‍याव दी। ");
INSERT INTO kjl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","झन आल मनी मुख्या पुजारीराए ल्‍योनी नमिन हाइज़्‍याव भरिरालाई क्‍योःन्‍या हक ब रैद नैव दी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","परमेस्‍वरए, “नँ घबानी, नो मिँलाई ङाय़ेनत छाँतिद ङानै। नोए ङामिन छुत जातलावर, इस्राएलीर स़ोनो राजाराए ल्‍योदा सथैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","नोए ङामिनताव दैन्‍या दुख भरी नोलाई ङा ज़ सतैंद्यान्‍या ङाले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","है जैद हननिया ननी पुलुस्‍द परमेस्‍वरए ओपैव झ़िमक बाद, साऊलए ओक्‍याँत उकुइ नैद, “अ भाइ साऊल, नँ आदा येमत नहुज़्‍याकाव नङ़ाक सरैंःसिउ प्रभु येसुए ङालाई नल्‍योदा नमी सरैंःद्यान्‍याए जूँनी स़ोनो छैंव पुरूसए घब्‍याल्‍क लिद उपरींनाव,” है ओदोव प़ाइँना ज़, ");
INSERT INTO kjl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","साऊलए उमीनी सींका मिताव कातार तेद उमी रैंःके। हाःत ज़ ननी च्‍याँःसिद ऱील सछैंसिनाद, ");
INSERT INTO kjl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ज़्‍यावर ज़्‍याद ओर्सार पुलुस्‍के। साऊल येसुए ओपाँत लिज़्‍यावरास जाँवा पै दमस्‍कसल लिद, ");
INSERT INTO kjl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","धर्मसास्‍त्र झ़िम झ़िमल बाद, “येसु परमेस्‍वरए ओज़ा ज़,” लिद ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ओपाँ थैज़्‍याव भरी बनै अचम्‍ब ताद, “आव ते नो यरूसलेमल येसुए उमिनत लिज़्‍यावरालाई खेमो पैंज़्‍याव मिँ माःक रो? आवए ते आल मनी नितावरालाई क्‍योःद, मुख्या पुजारीराए याकचरील स़ेले स़ेले लाँन्‍याए जूँनी हुव ची सानी,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","खाली साऊलए ओसक्ती झन ज़ घ्‍योःनाद, “येसु परमेस्‍वरए ओज़ा ख्रीस ज़,” लिद थ·रैद ओरायोनी दमस्‍कसलाव यहूदीराए यायुँ बनै आँचानी पाँचा जैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","छींनी सर्बा कुधु दिन ओतावत नलाव यहूदीराए साऊललाई सैःन्‍या बुद्धी कलैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","खाली नो पाँ ओल साऊलए मनी थैद ओनैज़्‍याव। है जैद नोराए, ‘जुनी ब सैःन्‍या ज़’ लिद नो सहरनी पुलुस्‍न्‍या येम भरिल पाल्‍यार नैद लाकनी रील वैंसिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","खाली ओनैंराए तछा रील साऊललाई भेल झाःद नो सहर घिरिसिउ भार्नातिन झरैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","साऊल दमस्‍कसनी पुलुस्‍द यरूसलेमल बाद येसुए ओपाँत बाज़्‍यावरास तखेप सरेस्‍सिउ ओपैंज़्‍याव। खाली नोलाई यायुँ माहुप्द, “आव ते येसुए ओपाँत साचो लिज़्याव माःक सानी,” है लिद छे·केर। ");
INSERT INTO kjl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","बारनाबासए वाज़ साऊललाई पतिद येसुए ओसाचीराए ल्‍योक लाँद, “आव मिँ दमस्‍कसदा ओबाज़्‍याक प्रभु येसु ओल्‍योक सरैंःसिद, ओलस ज़ पाँके दी। दमस्‍कसल मनी येसुए उमिन माछे·द ज़ यासथैक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","है जैद साऊल नोरास यरूसलेम सहरल आदा होदा लिद, नल ब प्रभुए उमिन माछे·द ज़ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","खाली नलाव ग्रीक खामनी पाँज़्‍याव यहूदीरास याखर्लेसिक ते नोराए झन साऊललाई सैःन्‍या निउँ याखिम्‍ज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ओनैंराए नो पाँ थैद साऊललाई ननी पले·द कैसरिया सहरक पै सारैद, नकिन उझ़िम तार्सस सहरदा परींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","हाः बेलाक यहूदिया, गालील स़ोनो सामरिया खन्‍दलाव मन्‍दली जाँवा पै रान छानस लिन्‍या ताके। येसुए ओपाँत बाज़्यावर परमेस्‍वरलाई यायुँल चेतैद, छैंव पुरूसनी यायुँर झेंःद, झन ज़ याबा·नाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पत्रुस नजीदा आदा होदा उलिज़्‍याक लुद्दा नाखारल परमेस्‍वरए उमिनत लिज़्‍यावरास दैसिनाके। ");
INSERT INTO kjl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","नल तोबो एनियास यादोज़्‍याव उखँ उकुइ सिउ, आथ बर्स भरी घ्याँसिद लिज़्‍याव मिँलाई दैक्यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पत्रुसए नोलाई रँःद, “अ एनियास, येसु ख्रीसए नँलाई सगराँनिज़्‍याव। नँ सोद नतैंर यारूल्‍के,” है ओदोव प़ाइँना ज़, नो मिँ थर च्‍याँःसिके। ");
INSERT INTO kjl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","नकाव लुद्दा स़ोनो सारोन नाखारल लिज़्‍यावराए निताव रँःद यायुँ हुप्‍द प्रभुए ओपाँत हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","फरी योप्‍पा सहरल तोबो तबीता यादोज़्‍याव परमेस्‍वरए ओपाँताव मेंमा ओल्‍यो। ग्रीक खामनी होए उमिन दोरकास है यादोज़्‍याव। नो मेंमा बनै उयुँ गराँद प़ाइँलाई सघैव ज़ ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तछा नो मेंमा ओजोरो हुद सिके। मिँराए ओमोरोलाई हुर्द ओतर्ताव ताललाव कुन्‍तील नैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","हाः बेलाक पै पत्रुस योप्‍पाकिन नजिकक लिज़्‍याव लुद्दाल उलिज़्‍याव सैंद नलाव यायुँ हुबोराए ऩेब्‍लो मिँनिलाई, “जिन पत्रुसलाई, ‘हतप्‍त ज़ हुन्‍साँ दी’ है दोचिन,” है लिद क़िनाव यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","है जैद पत्रुसए नो पाँर थैद नोनिस बाके। योप्‍पाल याकेसो प़ाइँना पत्रुसलाई नो सिउ मेंमालाई यानैज़्‍याव ओतर्ताव कुन्‍तील लाँकेर। नल नो नाखारलाव राँदी मेंमार दोरकासए जैद ओरायो क्‍वार सतैंद याघर्ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पत्रुसए नोरालाई लाँःदा परींद नो सिउए ओलापक उघूँदानी तिकिसिद परमेस्‍वरलाई पोंखारिद, सिउए ल्‍योदा भाल्‍सिद, “अ तबीता, सोनिके,” है ओदोव प़ाइँना नो मेंमा सैंसिद भाल्‍सिके। पत्रुसलाई उरँःव प़ाइँना सोद च़ुसिके। ");
INSERT INTO kjl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","हाःत ज़ पत्रुसए नोलाई उकुइनी क्‍योःद सच्‍याँद, नो लाँःक लिज़्‍याव परमेस्‍वरए उमिनताव राँदी मेंमारालाई खुल्‍द सिउनी बाँचिउलाई सतैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","नो पाँ योप्‍पा भरिल प़ाइँदा ज़ थास्‍द कुधुए प्रभुलाई यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","नो भरी ओतावत पत्रुस कुधु दिन पै योप्‍पाल तोबो स्‍यालोए य़ेन दाज़्‍याव सिमोन यादोज़्‍यावए उझ़िमक ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","हाः बेलाक कैसरिया सहरल तोबो कर्नेलियस यादोज़्‍याव मिँ इतालिया फौजीलाव कप्‍तान उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","नो मिँ बनै धर्मी ओल्‍यो, उझ़िमलावरास परमेस्‍वरए ओमान नैज़्‍याव मिँ ओल्‍यो। उयुँ गराँव ओतावए गरीबरालाई ज़्‍यावर पैसार ब याव ज़ उलिज़्‍याव, परमेस्‍वरलाई ब पोंखारिउ ज़ ओनैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","तछा लाकाव तीन बजेवाक कर्नेलियस झजल्‍किद परमेस्‍वरए ओचाकर्‍या ओल्‍योदा उहुज़्‍याव रँःक्‍यो। नो चाकर्‍याए कर्नेलियसए उमिन ओहाइक ते, ");
INSERT INTO kjl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कर्नेलियस बनै छे·द ओल्‍योदा लँ लँ चिऊद, “काराव प्रभु?” है दोक्‍यो। हाःत ज़ नो चाकर्‍याए, “परमेस्‍वरलाई नपोंखारिज़्‍याव स़ोनो गरीबराए ल्‍योदा नयुँ य़ाल्‍द नदोज़्‍याव य़ेनर परमेस्‍वरए ओल्‍योक केस्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","नँ तोबो ऩेब्‍लो नमींरालाई योप्‍पाल तोबो सिमोन पत्रुस यादोज़्‍यावलाई च़ानाव यापरींके। ");
INSERT INTO kjl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","नो मिँ समुन्‍द्र छ्योकाव स्‍यालोए य़ेन दाज़्‍याव सिमोनए उझ़िमक लिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","नो चाकर्‍या ओबाव छींनी, कर्नेलियसए ओय़ेन दाज़्‍याव भरिरानी ओसेवा दोज़्याव तोबो धर्मी उसिपाईं स़ोनो ऩेब्‍लो ओनोकोरनिलाई खुल्‍द, ");
INSERT INTO kjl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","नो चाकर्‍याए है ओदोव पाँ भरी नोरालाई है दाद योप्‍पादा यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","हो पराःती लाकाव बाह्र बजेवाक नो स़ोम्‍लो योप्‍पाल याकेस्‍नाव बेलाक ज़ पत्रुस थालात बाद परमेस्‍वरलाई ओपोंखारिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","पत्रुस बनै करेद काँ ज़्‍युव ओपैंज़्‍याव। खाली काँ ओमाताताव, भर याजैज़्‍याव। हाःत ज़ पत्रुस झजल्‍किद, ");
INSERT INTO kjl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","नम फैसिउ रँःक्‍यो। नमतिन तोबो घ्‍योःव फेरवा स्‍यासो चार चोंच्‍यानी क्‍योःसिउ उझरिहुज़्‍याव रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","नो फेरवाल जै जन्‍तुर, ऱूइज़ा वान्‍ज़ार स़ोनो बाज़ा बिज़ार यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","हाःत ज़ तोबो गाए, “अ पत्रुस, नँ सोद आवरालाई सैःद याकैके,” है ओदोज़्याव थैद, ");
INSERT INTO kjl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पत्रुसए, “माता प्रभु, निताव कैन्‍या माताज़्‍यावर खर्क ज़ ङामाकैए,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","नो गा फरी ब हुद, “जोलाई परमेस्‍वरए चोखो थ·रैद नैव, होलाई नँ माछैंव थ·रैन्‍या माताए,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","निताव स़ोंखेप ओतावत नो फेरवा नमदा छींसिद मारैंःके। ");
INSERT INTO kjl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","पत्रुस बनै अचम्‍ब ताद, “आव ङारँःवए ओअर्थ काता ओताव?” लिद उयुँल ओखामिज़्याक ज़ कर्नेलियसए ओरापरींव मिँराए, “सिमोनए उझ़िम काङ्क उलिज़्‍याव?” लिद पैसी पैसी साँबिलाक हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","साँबिलाक च्‍याँःसिद, “सिमोन पत्रुस यादोज़्‍याव आल मालिज़्‍या?” है लिद क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","हाःपै पत्रुस थालात च़ुसिद दर्सनलाव पाँ ओखामिज़्‍याव। हाःत ज़ परमेस्‍वरए उपुरूसए, “स़ोम्‍लो मिँराए नँलाई खिम्‍निज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","नँ च्‍याँःसिद मेल झरिद नयुँ धुक्‍क जैद नोरास बान्‍के। नोरालाई ङा ज़ ङारापरींव,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","है जैद पत्रुस मेल झरिद नोरास दैसिद, “जेखिम्‍नाज़्‍याव मिँ ङा ज़, काताए जूँनी जेहुव?” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","नोराए, “तोबो कर्नेलियस यादोज़्‍याव रोमी कप्‍तानए गेलाई उपरींसिउ। नो मिँ बनै धर्मी, परमेस्‍वरए ओमान नैद्याज़्‍याव मिँ ज़, यहूदी भरिराए बनै चाव थ·रैज़्‍यार। नोलाई परमेस्‍वरए ओचाकर्‍याए, ‘योप्‍पाल लिज़्‍याव पत्रुसलाई नझ़िमक रैव यापरींके। नो मिँए नँलाई तोबो पाँ सथैनिरिज़्‍याव’ है दोक्‍यो दी,” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","पत्रुसए नोरालाई उलिज़्याव झ़िमक चावस नैद नल ज़ याबासैक्‍यो। हो पराःती येसुए ओपाँत लिज़्याव योप्‍पालाव ओनैंरालाई तोबो ऩेब्‍लो लाँद नो खुल्‍ना हुवरास बाके। ");
INSERT INTO kjl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","हो पराःती पत्रुस ओनैंरास कैसरिया सहरल केस्‍केर। ओल कर्नेलियसए ते ओनैंर स़ोनो ओक्‍याँदाङावरालाई उझ़िमक दुप्‍द पत्रुसलाई कींद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पत्रुस हुद झ़िमल उपसिज़्याक कर्नेलियस ओल्‍योक दैसिनाद उखँत फुलुप्‍सिद धो दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पत्रुसए नोलाई सोचोइद, “ङालाई धो दान्‍या माःक, च्‍याँःसिन्‍के। ङा मनी नँ स्‍यासो मिँ ज़ ची,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","पाँए पाँए झ़िमल निपसिक नल मिँर बनै कुधु दुप्‍सिद यालिज़्‍याव रँःद, ");
INSERT INTO kjl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","नोरालाई, “गे यहूदीर जे मिताव छुत जातलावरास सिप लिन्‍या ब माताए, जेझ़िमल पसिन्‍या ब माताए लिन्‍या जे ज़ जेसैंज़्‍या। हितावत ब परमेस्‍वरए ङालाई, ‘सु मिँ ज़ माछैंव माले, अछुत्‍या ब माले’ है लिन्‍या सतैंद्याँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","है जैद ङालाई जेखुल्‍नाक ‘माता’ है मालिद ज़ ङाहुके। अब काताए जूँनी जेखुल्‍नाव, है दाँचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कर्नेलियसए, “चार दिन ङ़ादा लाकाव तीन बजेवाक ङाझ़िमक परमेस्‍वरलाई ङापोंखारिज़्‍याक तक तकौ क्‍वा क्‍वाइसिउ परमेस्‍वरए ओचाकर्‍या ङाङ़ाक सरैंःसिहुद, ");
INSERT INTO kjl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ङालाई, ‘अ कर्नेलियस, परमेस्‍वरलाई नपोंखारिज़्‍याव स़ोनो गरीबराए ल्‍योदा नयुँ य़ाल्‍द नदोज़्‍याव य़ेन परमेस्‍वरए रँःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","नँ योप्‍पाल लिज़्‍याव सिमोन पत्रुस यादोज़्‍यावलाई नमींरालाई क़िनाव यापरींके। नो मिँ समुन्‍द्र छ्योकाव स्‍यालोए य़ेन दाज़्‍याव सिमोनए उझ़िमक लिज़्‍या,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","है जैद ङा नँलाई हतप्‍त ज़ ङाथानिके। नँ ब नयुँ नाद हुद नयासिके। गे परमेस्‍वरए ओपैनिउ पाँर थैन्‍याए जूँनी आव ङानैंरास दुप्‍सिद गेले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","हाःत ज़ पत्रुसए अइ लिद यासथैक्‍यो, “साचो ज़ ओल्‍यो ङानैं ङामेंर, परमेस्‍वरए जात रँःद ओमादोज़्‍याव ओल्‍यो, ङा मनी आछिमकिन ज़ ङासैंके। ");
INSERT INTO kjl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","जो जातल तादी ब, जो मिँए परमेस्‍वरए ओमान नैज़्‍याव, चाव य़ेन ब दोज़्‍याव, होलाई ज़ परमेस्‍वरए चाव रँःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","गे उमीं इस्राएलीरालाई ओज़ा येसु ख्रीसनी सखैन्‍या येम ब सतैंद्यासिक्‍यो — नो प़ाइँ मिँराए गेप्रभु ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ऱील सछैंज़्‍याव यूहन्‍नाए ओय़ेन उतुपैवकिन गालील खन्‍दनी सुरू ताद, यहूदिया खन्‍द भरिल रा·सिनाव पाँर जे मनी थैद जेनैज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","नो पाँर आव ज़ — परमेस्‍वरए नासरतलाव येसुए ओक्‍याँत छैंव पुरूस ब झाःद्याद ओसक्तीर ब एक्‍यो। परमेस्‍वर ओलस ज़ उलिज़्‍यावए येसु आदा होदा बाद चाव य़ेनर दाद याजोरो हुवर स़ोनो माचाव पुरूसए क्‍योःद ओरानैज़्यावरालाई ब ओरासगराँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","गे उसिसर फरी नो यरूसलेमल स़ोनो यहूदीराए यादेसलाव ओदोव य़ेनरात ओसाचीर ताद गेले। नोलाई झन तछा क्रुसत तङ्गैद सैःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","हैदी ब उसिउ स़ोंलात परमेस्‍वरए नोलाई सोचोइद गेल्‍योक सरैंःद्यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सरैंःद ओरायो प़ाइँ मिँरालाई माःक, परमेस्‍वरए गे ङ़ादाकिनकाव रूजिद ओनैसिउ ओसाचीरालाई वाज़ ची। सैंसिद ओसोव छींनी गेस सिप ज़ ज़्‍युक्‍यो, सिप ज़ ओक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","गेलाई ओसाचीर जैद, ‘जे प़ाइँ मिँरालाई ङापाँ सथैद, ‘सिउ मासिउरालाई यान्‍याय फाल्‍न्‍या ओल परमेस्‍वरए ज़ ङा ओज़ालाई जैद नैनाव’ लिद यारासथैनाच्‍यो,’ लिद गेलाई अर्थैसिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","अगमबक्ता भरिराए मनी नो हुरिज़्‍याव येसुए उजूँनी ज़ पाँकेर। नोराए यापाँल मनी, ‘जोए नोलाई उयुँ हुप्‍ज़्‍या, हो नोए उमिननी ज़ ओपापर क्‍याल्‍सिद परमेस्‍वरस खैरिज़्या,’ है लिद लेर।” ");
INSERT INTO kjl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुस आव पाँर ओपाँज़्‍याक ज़ नो ओपाँ थैज़्‍यावराए याक्‍याँत छैंव पुरूस हुके। ");
INSERT INTO kjl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","नो पत्रुसस हुव येसुए ओपाँत बाज़्‍याव यहूदीराए, छुत जातलाव मिँराए याक्‍याँत मनी छैंव पुरूस उहुव रँःद, ");
INSERT INTO kjl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","“नोराए ते छुत छुत खामनी पाँद, परमेस्‍वरए उमिन ची सघ्‍योःज़्यार!” है लिद अचम्‍ब ताकेर। हाःत ज़ पत्रुसए ओनैंरालाई, ");
INSERT INTO kjl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“आवरालाई गे काराव ऱील सछैंसिन्‍या भैंःद मायान्‍या? आवर मनी गे मिताव छैंव पुरूस दैवर ज़ लिज़्‍यार सानी,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","येसु ख्रीसए उमिननी ऱील सछैंसिउ यापरींक्‍यो। नकिन कर्नेलियस ओनैंरास, “गेस जाँवा पै ल्‍यो ताके,” है यारादोक ते, नोर जाँवा पै लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","छींनी येसुए ओसाचीर स़ोनो यहूदिया खन्‍दलाव येसुए ओपाँत बाज़्‍यावराए, ‘छुत जातलावर मनी परमेस्‍वरए ओपाँत हुकेर दी’ लिन्‍या थैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","है जैद पत्रुस यरूसलेमल ओल्‍द ओबाक नलाव येसुए ओपाँत हुव यहूदीराए ओदोव य़ेनर माभैंःद, ");
INSERT INTO kjl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“नँ काराव छुत जातलावराए ल्‍योक बाद नोरास सिप नज़्‍यु?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","पत्रुसए नोराए यापाँए ओअर्थ ओजरानी ज़ अइ लिद पलास्‍द याएक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ङा योप्‍पाल ङालिज़्‍याक तछा परमेस्‍वरलाई ङापोंखारिज़्याक, झजल्‍किद तोबो फेरवा स्‍यासो चार चोंच्‍यानी क्‍योःसिउ, नमतिन ङाल्‍योक उझरिहुज़्‍याव ङारँःके। ");
INSERT INTO kjl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","नोलाई लँ लँ चिऊद ङानैज़्‍याक नल जै जन्‍तुर, ऱूइज़ा वान्‍ज़ार स़ोनो स्‍यार बाज़ार ङारारँःके। ");
INSERT INTO kjl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","हाःत ज़ कातानी तोबो गाए, ‘अ पत्रुस, नँ सोद आवरालाई सैःद याकैके,’ है ओदाँज़्‍याव ङाथैके। ");
INSERT INTO kjl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ङा फरी, ‘माता प्रभु, निताव कैन्‍या माताज़्‍यावर ङासेत खर्क ज़ ङामाझाःए,’ है ङादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","नो गा फरी ब नमतिन हुद, ‘जोलाई परमेस्‍वरए चोखो थ·रैद नैव, होलाई नँ माछैंव थ·रैन्‍या माताए,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","निताव पाँर स़ोंखेप ओतावत नो फेरवा नमदा स़ेल्‍सिद मारैंःके। ");
INSERT INTO kjl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“हाःत ज़ ङालिज़्‍याव झ़िम ङ़ाकाव साँबिलाक स़ोम्‍लो मिँर हुद यालिज़्‍याव। नोर ङाल्‍योक कैसरियानी परींसिउर याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","परमेस्‍वरए उपुरूसए फरी, ‘आवरास माअन्‍कनिद घबानी,’ है दाँक्‍यो। है जैद आव ङास लिज़्‍याव छ जना ङानैंर लाँद नो परींज़्‍याव मिँए उझ़िमल गेपसिके। ");
INSERT INTO kjl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","हो प़ाइँना ज़ ङ़ादा उरँःव भरी गेलाई है दासिक्‍यो — नो मिँए उझ़िमल परमेस्‍वरए ओचाकर्‍या च्‍याँःसिद उलिज़्‍याव रँःक्‍यो दी। नो चाकर्‍याए फरी, ‘योप्‍पाल लिज़्‍याव सिमोन पत्रुसलाई च़ानाव यापरींके। ");
INSERT INTO kjl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","नो सिमोन आल हुद नझ़िमलावरास जेलाई अजम्‍बरी जुनी दैन्‍या पाँर सथैचिरिज़्‍याव,’ है दोक्‍यो दी। ");
INSERT INTO kjl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“है जैद ङा नोरालाई परमेस्‍वरए ओपाँ ङारासथैज़्‍याक ज़ किताव ङ़ादा छैंव पुरूस गे गेक्‍याँत उहुव, हिताव ज़ नोराए याक्‍याँत मनी हुके। ");
INSERT INTO kjl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","हाःत ज़ गेप्रभु येसुए ङ़ादा गे उसिसरालाई है ओदासिउ पाँर य़ाका ङादोके — ‘यूहन्‍नाए किताव जेलाई ऱीनी ओसछैंचिउ, हिताव ज़ छींनी तछा छैंव पुरूसनी जेछैंरिज़्‍या।’ ");
INSERT INTO kjl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","है जैद परमेस्‍वरए गेलाई गेप्रभु येसु ख्रीसलाई गेयुँ सुहुप्‍दकाव ओयासिउ असिकर नोरालाई मनी ओरायोए ङा परमेस्‍वरए ओय़ेनलाई कै जैद ङावैंधुरिज़्‍याव?” है लिद पत्रुसए है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","नोर सुए ज़ काता ज़ मापाँधुद परमेस्‍वरए उमिन सघ्योःद्याद, “परमेस्‍वरए छुत जातलाव मिँरालाई मनी यायुँ याफर्कैवनी अजम्‍बरी जुनी दैन्‍या असिक ओरायो ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्‍तिफनसए ओपालाकिनकाव यरूसलेमलाव येसुए ओपाँत हुवरालाई याखिरी यापसिक ख्वार फोनिके खन्‍ददा, ख्वार साइप्रस तापुदा, ख्वार एन्‍तिओखिया सहरदा धोंःद खासिद लिनाकेर। नोराए नङ मनी येसुए ओपाँ यारासथैक यहूदीरालाई वाज़ यारासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","खाली नोराए याखार्नी साइप्रस तापु स़ोनो कुरेनी देसनी हुवर तोबो ऩेब्‍लोए एन्‍तिओखियाल बाद छुत जातलाव मिँरालाई मनी प्रभु येसुए ओपाँ यारासथैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","परमेस्‍वर नोरास उलिज़्‍यावए बनै कुधुए यायुँ हुप्‍द प्रभु येसुए ओपाँत हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","नो पाँर छींनी यरूसलेमलाव मन्‍दलील मनी थास्‍द बारनाबासलाई एन्‍तिओखियादा परींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","बारनाबास होङ ओकेस्‍क परमेस्‍वरए नोराए याखार्ल ओदोव असिकर रँःद बनै खुसी ताके। नोरालाई, “प्रभुए ल्‍योदा जेयुँ थ·रैद ओसत ताऱास्‍च्‍यो,” लिद यायुँ सझेंःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","बारनाबास धर्मी, उयुँ हुबो, छैंव पुरूसए ब्यालो मिँ ओल्‍यो। नोए ओपाँ थैद मिँर सर्बा माहोल्‍या ज़ येसुए ओपाँत चा·सिहुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","नकिन जाँवाक बारनाबास तार्सस सहरल बाद साऊललाई खिम्‍नाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ओदैवत नोलाई मनी एन्‍तिओखियाल रैक्‍यो। नोनी ऩेब्‍लो बर्सदिन पै नल ज़ लिद मन्‍दलीलाव मिँरास खैद परमेस्‍वरए ओयेम कुधुलाई यारापैकिनी। नो एन्‍तिओखियाल येसुए ओपाँत बाज़्‍यावरालाई हाःकिन यामिन ख्रीस्त्‍यान जैद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","हाः बेलाक यरूसलेमनी अगमबक्तार तोबो ऩेब्‍लो एन्‍तिओखियाल हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","नोरानी तोबो अगाबस यादोज़्‍यावए छैंव पुरूसनी, “संसार भरिल बनै घ्‍योःव अनिकाल हुरिज़्‍या,” है लिद ङ़ादा ज़ पाँके। थिक है ओल्‍यो मिताव ज़ नो पाँ रोमी माहाराजा क्‍लौदियसए ओपालाक यो·के। ");
INSERT INTO kjl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","है जैद एन्‍तिओखियालाव यायुँ हुबोराए यहूदिया खन्‍दल लिज़्‍याव यादाज्‍यु भाइरालाई सघैन्‍या युँ दाद याधुवा भरी सु सु यापैसार स्‍यो·द, ");
INSERT INTO kjl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","नो पैसा बारनाबास स़ोनो साऊलनी निकुइत यरूसलेम मन्‍दलीलाव स़ेररालाई परींद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","हाः बेलाक हेरोद राजाए मन्‍दलीलाव ख्वा ख्वारालाई क्‍योःद बनै दुख याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","यूहन्‍नाए ओदाज्‍यु याकूबलाई ते झन खोर्च्‍योए पल्‍द सैःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","यहूदीर ननी बनै खुसी याताव रँःद हेरोदए पत्रुसलाई मनी क्‍योःव यापरींक्‍यो। नो बेलाक माँदा भरेस ज़्‍यान्‍या पर्ब ताद उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","पत्रुसलाई क्‍योःद, झ्यालखानाल झाःद सोह्र जना सिपाईंराए याजिम्‍बाल नैद, ‘पर्ब ओखेमोत ची जनताराए याङ़ाक ङासतैंया ब’ है उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","पत्रुस झ्यालखानाल उलिज़्‍याक मन्‍दलीए नोए उजूँनी परमेस्‍वरलाई बनै पोंखारिउ ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","हेरोद राजाए जनताराए ङ़ाक पत्रुसलाई सतैंव ओपैंज़्‍याव ओङ़ालाव छ्याम रील, पत्रुस झ्‍यालखाना जींल ऩेब्‍लो सिपाईंनी निखार्ल साँगलए किसिउ स्‍याँद उलिज़्‍याव। य़ामक मनी पाल्‍यार च्‍याँःसिद गुद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","हाःत ज़ उमँःजानी परमेस्‍वरए ओचाकर्‍या सरैंःसिद ओज़गैए झ्यालखानाल पलाँ जैद, पत्रुसलाई कोतैद, “सोद घल्‍सिन्‍के,” है दाद ओसोचोइव प़ाइँना ज़ ओसाँगलर यानी ज़ पला·सिद तेकेर। ");
INSERT INTO kjl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","हाःत ज़ नो चाकर्‍याए, “नवाँःफोर पो·सिद नपोलार जासिन्‍के,” है ओदोक ते, पत्रुसए हैज़ जैक्‍यो। नकिन, “नबर्की क्‍वाइसिद ङाछींत हुन्‍के,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","पत्रुस लाँःदा पुलुस्‍द उछीं उछीं ज़ बाके। खाली उयुँल ते, ‘आव भरी झजल्‍किद ङारँःज़्‍याव ज़ ताखेहो’ लिद नो साचो ज़ ओल्‍यो लिन्‍या ओमासैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","नोनी उस॰कताव पाल्‍यालाई बलेंद, फरी हुकिनकाव पाल्‍यालाई ब बलेंद सहरल बाज़्‍याव झँए य़ामक निकेस्‍क नो य़ाम ओलनी ज़ फैसिके। ननी पुलुस्‍द येमत निबाज़्‍याक नो चाकर्‍या उमँःजानी सम़ैसिके। ");
INSERT INTO kjl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","हाःत ज़ पत्रुसए ओचेत फर्किद, “साचो ज़ ओल्‍यो, परमेस्‍वरए ङाल्‍योक ओचाकर्‍यालाई परींद ओयाँव ची ओल्‍यो। नोए ङालाई राजा हेरोद स़ोनो यहूदीराए याजालनी जोगोइद ओपले·नाव ची ओल्‍यो!” है लिके। ");
INSERT INTO kjl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","है जैद आव पाँ भरी चेतैद पत्रुस मरियमए उझ़िमक बाके। नो मरियम मर्कूस यादोज़्‍याव यूहन्‍नाए ओआमा ओल्‍यो। नल हो बेलाक कुधु मिँर दुप्‍सिद परमेस्‍वरलाई यापोंखारिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पत्रुस य़ामक हुद कोतो कोतो ओजैक तोबो रोदा यादोज़्‍याव नोकोर्नी मेंमाए य़ामक चिऊनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","रोदाए पत्रुसए ओर्गा ओसरेसो प़ाइँना ओरेंतए य़ाम माफैद झन झ़िमल धोंःनाद, “दे, पत्रुस हुद य़ामक च्‍याँःसिद ले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","प़ाइँए, “काता नपाँज़्‍याव निताव स्‍यावदिनी ब्‍यावदी?” है यादोक ते, नो ल़ुज़ाए, “हो ज़ ब्‍याँ, हो ज़,” है यादोक्‍यो। नोराए झन, “उपुरूस नरँःव ताखेहो,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","नाः भरिल पत्रुस य़ामक च्‍याँःसिद कोतोका कोतो जैव ज़ ओनैज़्‍याव। बल्‍ल नोराए य़ामक बाद याफैनाक पत्रुसलाई रँःद बनै अचम्‍ब ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","पत्रुसए ‘झ्याउँ तालिच्‍यो’ लिद उकुइए सान दाद परमेस्‍वरए झ्यालखानानी ओपले·काव पाँ भरी है यादोक्‍यो। नकिन, “आव पाँ भरी याकूब स़ोनो उपुर्काव गेनैंरालाई मनी है यारादोच्‍यो,” है दाद ओल ननी पुलुस्‍द छुतङ बाके। ");
INSERT INTO kjl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","हो पराःती झ्यालखानाल ‘पत्रुस काना ओबाव’ लिद पाल्‍याराए याखार्ल राउँनी झ्याउँ ताके। ");
INSERT INTO kjl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोदए उसिपाईंरालाई नोलाई सापो ओरापरींक यामादैवए नो पाल्‍यारालाई तोबो तोबोनी खोले·द, नोरालाई सैःन्‍या सजा याएक्‍यो। नकिन हेरोद राजा यहूदियानी पुलुस्‍द कैसरिया सहरल बाद नल ज़ उलिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हाः बेलाक तुरोस स़ोनो सीदोन सहरलाव मिँरास हेरोद बनै रसिद उलिज़्‍याव। खाली नोराए याज़्‍याव भरी हेरोदए ओपोनी उहुज़्‍यावए नोराए होस सखैसिउ यापैंज़्‍याव। है जैद याघेप्‍पार हेरोदए ल्‍योक हुद तोबो उयुँ हुबो ओकर्मचारी बलस्‍तसलाई याल्‍योदा जैद राजास पाँव यापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","जलफल दान्‍या याथ·रैव छ्याम, हेरोद बनै तह महौ जैसिद उसिंहासनत च़ुसिद ओपाँ यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ओपाँ थैज़्‍यावराए, “आव पाँ ते मिँए ओपाँ माःक, ईस्‍वरए ओपाँ ची,” है लिद बनै ज़ क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","हाःत ज़ हेरोद स॰द परमेस्‍वरलाई ओमान नैद ओमायोए प्रभुए तोबो ओचाकर्‍याए फार्लाप फुर्लुप ओख्याक ऱूइद सिके। ");
INSERT INTO kjl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","परमेस्‍वरए ओपाँ झन ज़ बा·द प़ाइँदा ज़ रा·सिनाके। ");
INSERT INTO kjl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","बारनाबास स़ोनो साऊलनी यरूसलेम मन्‍दलीलाव पैसा भाःन्‍या निय़ेन निखेमोत, यूहन्‍ना यादोज़्‍याव मर्कूसलाई ब नीस ज़ लाँद एन्‍तिओखियादा ओल्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","एन्‍तिओखियालाव मन्‍दलीए खार्ल अगमबक्तार स़ोनो परमेस्‍वरए ओपाँ पलास्‍ज़्‍यावर यालिज़्‍याव। नोराए यामिनर आवर ज़ — बारनाबास, काल्‍या यादोज़्याव सिमियोन, कुरेनीलाव लुकियस, साऊल, स़ोनो ज़िम्‍ज़ाकिन ज़ हेरोद राजास तोबो झ़िमल सिप हुर्किउ मनेन याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","नोर तछा दुप्‍सिद, उपासिद परमेस्‍वरलाई यापोंखारिज़्याव बेलाक छैंव पुरूसए, “ङा बारनाबास स़ोनो साऊलनिलाई ङाजूँनी ङानिउथैव य़ेनत जे ज़ नोनिलाई खतैद यारापरींच्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","है जैद नोर उपासिद पोंखारिद नोनी निक्‍याँत याकुइ नैद्याद हो य़ेनत यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","है जैद बारनाबास स़ोनो साऊलनी छैंव पुरूसए उनिखतैव य़ेनत बाकिनी। सिलुकिया सहर पै झरिद, नकिन ऱी जहाजल पसिद साइप्रस तापुत बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","नल सलामिस सहर निकेसोत यहूदीराए धर्मसास्‍त्र झ़िमल बाद परमेस्‍वरए ओपाँ यारासथैकिनी। नोनिलाई सघैन्‍या यूहन्‍ना ब उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","नो तापु भरिल तछ्योनी ज़ दुलिद पाफोस सहर याकेसोत नल तोबो बार-येसु यादोज़्‍याव यहूदी धामीस दैसिकेर। नोए परमेस्‍वरए उमिन हाइद धुतनी ओरापैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","नो धामी तापुताव हाकिम सर्गियस पौलुसए ओसेवात उलिज़्‍याव। नो हाकिम बनै ओगहक ल्‍यो मिँ ओल्‍यो। नोए परमेस्‍वरए ओपाँ थैन्‍याए जूँनी बारनाबास स़ोनो साऊलनिलाई ओल्‍योदा सथैना निखुल्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","खाली बार-येसु यादोज़्‍याव एलुमास धामीए (ग्रीक खामनी एलुमासए ओअर्थ ‘धामी’ ज़) नोनी निपाँलाई वैंद, हाकिमलाई नो पाँनी तँदा बले·व ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","है जैद साऊल (छींनी उमिन पावल) छैंव पुरूसए ब्याल्‍द, नोलाई लँ लँ चिऊद, ");
INSERT INTO kjl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ए सैतानए ओज़ा, धुतैद ज़्‍याज़्‍याव, साचो पाँ भरी वैंज़्‍याव, नँ खा पै परमेस्‍वरए दाँव ओयेमलाई गाँत्‍या गुँती जैव नपैंज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","नँ इताव नदोवए आछिमकिन परमेस्‍वरए ओसजा नक्‍याँत हुद जाँवा पै नमी लाम लुम ताद निमीए ओज़लाँ ब रँःन्‍या नमाले,” है ओदोव प़ाइँना ज़ उमी मारैंःद छाम छाम ताद दोरैन्‍या मिँ खिम्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","नो हाकिमए निताव रँःद परमेस्‍वरए ओपाँत अचम्‍ब ताद उयुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","नकिन पावल ओनैंनिस ऱी जहाजल पसिद पाफोसनी बाद पामफिलिया खन्‍दलाव पर्गा सहरल केस्‍केर। नकिन ज़ यूहन्‍ना नोनिस भाःसिद यरूसलेमदा ओल्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पावल स़ोनो बारनाबासनी ते पिसिदिया खन्‍दलाव एन्‍तिओखियाल बाद ऩासिन्‍या छ्याम ओतावए धर्मसास्‍त्र झ़िमल बाद च़ुसिकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","नो झ़िमलाव घेप्‍पाराए मोसाए ओकानुन स़ोनो अगमबक्ताराए यापाँर यारासथैवत बारनाबास स़ोनो पावलनिलाई, “अ भाइनी, जिनस युँ सझेंःन्‍या काता पाँर उलिकिन गेलाई सथैव ताके,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","हाःत ज़ पावल याङ़ाक च्‍याँःसिद उकुइए सान दाद, “अ इस्राएली ङानैंर स़ोनो परमेस्‍वरए ओमान नैज़्‍याव छुत जातलाव मिँर, आदा थैचिके। ");
INSERT INTO kjl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएली जातलावराए गेपरमेस्‍वरए गेसाखा पुर्खारालाई छाँतिद, इजिपल खासिद यालिज़्‍याव बेलाक नोरालाई बनै ज़ सबा·द, ओल उकुइनी ननी पले·द दोरैद यालाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","माचाव यादिउदीलाई ब चालीस बर्स भरी सहिद बनल पाथस यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","नोरालाई लिन्‍या पो जैद्यान्‍याए जूँनी कनान देसलाव सात राज्‍यारालाई यामिन सम़ैद्याद नो पो यामीं ज़ जैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","नो भरी चार सय पचास बर्सवा लागिके। “नकिन समूएल अगमबक्ताए ओपालाक पै नोरालाई याराज्‍या चलैन्‍याए जूँनी परमेस्‍वरए न्‍याधिसर खतैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","हाः बेलाक इस्राएलीराए, ‘गेलाई चलैन्‍या तोबो राजा जैद्यासिके,’ है यादोक ते, परमेस्‍वरए नोरालाई तोबो साऊललाई याराजा जैद याएक्‍यो। नो मिँ बेन्‍यामीन थरलाव कीसए ओज़ा ओल्‍यो। नो मिँए चालीस बर्स पै याराज्‍या चलैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","छींनी परमेस्‍वरए नोलाई पले·द दाऊदलाई याराजा जैद याएक्‍यो। होए उजूँनी ओल परमेस्‍वर ज़ अइ लिद उलिज़्‍याव, ‘यिसैए ओज़ा दाऊदलाई ङायुँलाव मिँ ज़ थ·रैद ङानै। नोए ङाय़ेन भरी चावस ज़ दान्‍या ले।’ ");
INSERT INTO kjl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","परमेस्‍वरए नो मिँए ओथोनी ज़ गे इस्राएलीरालाई ओय़ाकालाव पाँर सयो·द्याद गेलाई तोबो बाँचैज़्याव परींद्यासिक्‍यो। नोए उमिन येसु ज़। ");
INSERT INTO kjl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","खाली नो ओमाहुवा पै, ऱील सछैंज़्‍याव यूहन्‍नाए इस्राएलीरालाई, ‘जेपापलाई ऱास्‍द ऱील सछैंसिहुचिके,’ है लिद ओरासथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","नोए ओय़ेन ओखेम्‍नावत, ‘जे ख्वाराए ङालाई ख्रीस है जेदाँज़्‍याखेहो। ङा हो माःक, नो ङाकिन छींनी हुरिज़्‍या। ङा ते नोए ओपोलाए ओच़ें पला·न्‍या स्‍यासो ब ङामाले,’ है ओरादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“जे ङादाज्‍यु भाइर, अब्राहामए ओथोर स़ोनो परमेस्‍वरए ओमान नैज़्‍याव छुत जातलाव मिँर, आव है ङादाचिज़्‍याव परमेस्‍वरनिकाव बाँचैन्‍या पाँर गे प़ाइँए गेजूँनी ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूसलेमलाव मिँर स़ोनो गेघेप्‍पाराए झन नो येसुलाई ज़ मासरेस्‍धुकेर। ऩासिन्‍या छ्याम साताकाव तखेप दुप्‍सिद अगमबक्ताराए यापाँर प़रिद ब नो पाँए ओअर्थ माप़ाल्‍धुकेर। है जैद झन येसुलाई सैःन्‍या थ·रैद, मासैंद ज़ नो पाँर सयो·केर। ");
INSERT INTO kjl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","नोलाई सैःन्‍या खत कान्‍त ज़ यामादैज़्‍यावत ब, ‘सैःन्‍या ज़’ लिद पिलातसलाई सूँपिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","नोए उजूँनी धर्मसास्‍त्रलाव सर्सिउ पाँ भरी प़ाइँ ज़ यासयो·वत ओमोरोलाई क्रुसतिन हाइद खादरल झाःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","खाली परमेस्‍वरए झन नोलाई सिउनी सोचोइक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","सिउनी ओसोवत ओलस गालील खन्‍दनी यरूसलेमल हुव ओनैंराए ल्‍योक कुधु दिन पै सरैंःसिके। नोर ज़ आज्‍याल ओसाचीर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“है जैद गेसथैचिज़्‍याव चाव था आव ज़ — गेसाखा पुर्खारालाई ओरायो य़ाका भरी ");
INSERT INTO kjl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","येसुलाई सिउनी सोचोइद गे याथोराए गेक्‍याँत ज़ सयो·द्यासिक्‍यो। किताव भजन पोस्‍तोकोलाव दुईल सर्सिउ लिज़्‍या, हिताव ज़ यो·के। नलाव सर्सिउ आव ज़, ‘नँ ङाज़ा ज़, आछिम ज़ नँलाई ङाजर्मैनिके।’ ");
INSERT INTO kjl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","फरी धर्मसास्‍त्रल परमेस्‍वरए येसुलाई सिउनी सोचोइद फरी ब सिउ यान्‍या माले लिन्‍या ङ़ादाकिन ज़ ओरैंःज़्‍याव। तोथो आव ज़, ‘दाऊदलाई ङायो य़ाकालाव थ॰रिउ छैंव असिकर, जे छींनीकावराए जेक्‍याँत ज़ सयो·द्यान्‍या ङाले।’ ");
INSERT INTO kjl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","फरी तोथोल अइ लिद ब सर्सिउ लिज़्‍या, ‘अ परमेस्‍वर, नँ छैंव नज़ालाई, खादरल चिउ यान्‍या नमाले।’ ");
INSERT INTO kjl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“ओल दाऊद ते उप़िरील वाज़ लिद, परमेस्‍वरए ओय़ेनर सयो·द उजिज्‍यु बाज्‍युराए माँःती सिद खादरल बाद चिके। ");
INSERT INTO kjl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","खाली परमेस्‍वरए येसुलाई सिउनी ओसोचोइवए ओक्‍याँ माचिए। ");
INSERT INTO kjl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","है जैद ङादाज्‍यु भाइर, आव ब सैंच्‍यो — आव है ङादाचिज़्‍याव येसुनी, जेदोव पापए सजा क्‍याल्‍सिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","मोसाए ओकानुननी उस्‍किउ गेमादैवए जो मिँए येसुलाई उयुँ हुप्‍ज़्‍या, नो प़ाइँनी ज़ फुर्सुल ताद परमेस्‍वरस खैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","है जैद आव पाँत जोगोइसिच्‍यो, म़ानी अगमबक्ताराए यापाँ जे जेक्‍याँत ज़ तान्‍या ले। नो पाँ आव ज़, ");
INSERT INTO kjl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘अ ङापाँलाई हसैद ल़॰ज़्‍यावर, अचम्‍ब ताद नास ताच्‍यो। जे जेपालाक ज़ अचम्‍बलाव य़ेन तोबो ङादोरिज़्‍या। नो य़ेन सुवाराए है यादाचिदी ब पतिन्‍या जेमाले।’ ” ");
INSERT INTO kjl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पावल स़ोनो बारनाबासनी धर्मसास्‍त्र झ़िमनी पुलुस्‍द निबाज़्‍याक नो थैवराए, “आव जिनपाँ फरिकाव साताक मनी गेलाई सथैव ताके,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","भाःसिद निबावत मनी कुधु यहूदीर स़ोनो छुत जातलाव यहूदी धर्म मानिज़्‍यावर नीस ज़ बाकेर। है जैद पावल स़ोनो बारनाबासनी, “आव जेथैव पाँत थ॰रिद परमेस्‍वरए ओयाचिउ असिकलाई ताऱास्‍च्‍यो,” है लिद यारासथैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","नो हुव साताकाव ऩासिन्‍या छ्याम सहरलाव लिज़्याव जाँकोसै मिँर परमेस्‍वरए ओपाँ थैना हुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","यहूदीराए, मिँर नाः कुधु याहुज़्‍याव रँःद यामी तूद पावलए ओपाँ पल्‍तैद्याव पैंद नोलाई थल्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","नाःत ज़ पावल स़ोनो बारनाबासनी, निपाँ छत्‍कैद है यारादोकिनी, “परमेस्‍वरए ओपाँ थैन्‍या मौका ङ़ादा ते जे यहूदीरालाई ज़ याव ताके है गिन्लिज़्‍याव। खाली जे नो पाँलाई भीःद अजम्‍बरी जुनी दैन्‍या मौका जेमाभैंःवए, गिन ते छुत जातलाव मिँरालाई गिन्‍रासथैनारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","आवए उजूँनी परमेस्‍वरए धर्मसास्‍त्रल मनी अइ लिद ले, ‘बाँचैन्‍या ङापाँ मानुवाताव काना कुनीङ पै जेनी ज़ ओकेस्‍क लिद, छुत जातलाव मिँराए ल्‍योदा ब ज़गै मिताव जैद ङानैचिए।’ ” ");
INSERT INTO kjl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","नो परमेस्‍वरए ओपाँ थैद नकाव लिज़्‍याव छुत जातलाव मिँर बनै रेंद नो पाँए उजूँनी धन्‍या धन्‍या है लिकेर। है जैद परमेस्‍वरए अजम्‍बरी जुनील बान्‍या थ·रैद ओरानैज़्‍याव भरिए नो पाँत यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","है जैद परमेस्‍वरए ओपाँ नो खन्‍द भरिल प़ाइँदा ज़ ओरा·सिनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","खाली नलाव यहूदीराए माभैंःद याधर्म मानिज़्‍याव धनी मेंमार स़ोनो सहरलाव घेप्‍पारालाई मचैद पावल स़ोनो बारनाबासनी निखिरी पसिउ परींद यापोनी याराखेपैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","है जैद पावल स़ोनो बारनाबासनी, माभैंःज़्यावरालाई परमेस्‍वरए ज़ न्‍याय ओदोवक लिद निखँताव गालो धुइरो ब सीद ख्यानैद्याद आइकोनियन सहरदा बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","परमेस्‍वरए ओपाँत हुव भरी ते छैंव पुरूसए ब्याल्‍द रेंव ज़ यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","आइकोनियन सहरल मनी पावल स़ोनो बारनाबासनी यहूदीराए धर्मसास्‍त्र झ़िमल बाद परमेस्‍वरए ओपाँ निरासथैक चावस पलास्‍द निरायोए यहूदीर स़ोनो छुत जातलावर बनै कुधु ज़ नो पाँत यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","खाली माभैंःज़्‍याव यहूदीराए ते छुत जातलाव मिँरालाई मचैद, ‘नोनी निपाँ ताथैच्‍यो’ लिद यार्नाल झाःद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","हितावत मनी नोनी नो सहरल कुधु पै लिद प्रभुए ओक्‍याँत ख्‍यासिद माछे·द ज़ ओपाँर यारासथैकिनी। परमेस्‍वरए मनी थैज़्‍यावराए यायुँल य़ालो ओपाँर साचो ज़ थ·रैद्यान्‍याए जूँनी पावल स़ोनो बारनाबासनी निक्‍याँनी अचम्‍बलाव य़ेनर सरेसर ब दाव उनिएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","है जैद नो सहरलाव मिँर ऩेभा ताकेर। तभा यहूदीराए ल्‍योदा यालिज़्‍याव, तभा पावल स़ोनो बारनाबासनी निल्‍योदा यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","छींनी नलाव छुत जातलाव मिँर स़ोनो यहूदीर याघेप्‍पारास तोबो बुद्धी कलैद नोनिलाई बीज्‍यात जैद लुँए झेःव यापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","नोनी था निदैवत ननी धोंःद लुकोनिया खन्‍दलाव लुस्‍त्रा स़ोनो दर्बी सहर जीदा बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","नल मनी परमेस्‍वरए ओपाँ यारासथैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्‍त्राल तोबो मिँ जर्मननी ज़ उखँ सिउ च़ुसिद उलिज़्‍याव। नो मिँ खर्क ज़ ओमाबाधुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","पावलए नल मनी परमेस्‍वरए ओपाँ ओरासथैज़्‍याक नो मिँए बनै धिद ओथैज़्‍याव। पावलए नोलाई रँःद सगराँसिन्‍याए जूँनी उयुँ उहुप्‍ज़्‍याव मिताव रँःद, ");
INSERT INTO kjl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","बनै चोइस, “नखँर पलास्‍द च्‍याँःसिन्‍के,” है ओदोव प़ाइँना नो मिँ थर च्‍याँःसिद आदा होदा लिके। ");
INSERT INTO kjl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","नलाव माहोल्‍याराए पावलए ओदोव य़ेन रँःद अचम्‍ब ताद, लुकोनिया खामनी, “देवतार मिँ जैसिद गेल्‍योक ज़ याहुव ओल्‍यो,” है लिद क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","बारनाबासलाई ‘जिउस’ देवता है दोकेर, पावललाई परमेस्‍वरए ओपाँ सथैज़्याव मुख्‍या मिँ ओतावए ‘हर्मेस’ देवता है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","जिउस देवताए ओथान सहर लापक उलिज़्‍याव। है जैद नो देवताए उपुजारीए माहोल्‍यारास खैद, वासर जास्‍सिउ बहरर सहरलाव य़ामक रैद, नोनिलाई पुजा दाव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","हाःत ज़ बारनाबास स़ोनो पावलनी ‘अइ ची याजैज़्‍याव ओल्‍यो’ लिन्‍या सैंद, हार मानिद निक्‍वार चीए चीए माहोल्‍याराए याखार्ल बाद, ");
INSERT INTO kjl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“काता जेजैसिज़्‍याव इताव? गिन मनी जे स्‍यासो मिँनी ज़ ची। गिन गिन्सथैचिज़्‍याव चाव पाँनी ते इताव माचाहिउ पुजा दान्‍यालाई ऱास्‍द, नाम नम स़ोनो नलाव लिज़्‍याव भरी जैज़्‍याव, जींदो परमेस्‍वरलाई मानिन्‍या लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","परमेस्‍वरए ङ़ादाकिन जे मिताव छुत जातलाव मिँरालाई जेमन लागिउदा बाव ओयाचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","हैदी मनी ओललाई सरेस्‍न्‍या सरेसर प़ाइँलाई ज़ याएक्‍यो। जेल्‍योदा मनी दाइनो ताद नम सवाद्याद, ज़्‍यावर सपरीद्याचिज़्‍याव। जेचाहिज़्‍याव भरी जोरैद्याद जेफू तसी जैद्याद जेयुँर होलाँ जैद्याचिज़्‍याव,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","है निरादोज़्‍यावत मनी नो माहोल्‍यारालाई पुजा दान्‍यात धो वैंव ताकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","छींनी एन्‍तिओखिया स़ोनो आइकोनियनलाव यहूदीराए लुस्‍त्राल हुद नलाव माहोल्‍यारालाई मचैद, पावललाई लुँ लुँए झेःद लल्‍यातोरो जैद, ‘उसिउ ची ओल्‍यो’ लिद सहरकिन पाखाङ ख्याकेर। ");
INSERT INTO kjl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","खाली नो सहरलाव येसुए ओपाँत बाज़्‍यावर पावलए ओल्‍योक गुरिगाँ यादुप्‍सिक, पावल सोद यास ज़ सहरदा बाके। हो पराःती बारनाबासस दर्बी सहरदा बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पावल स़ोनो बारनाबासनी दर्बील मनी चाव था सथैद येसुए ओपाँत हुन्‍यार कुधु ज़ याराजैकिनी। नकिन फरी ओल्‍द लुस्‍त्रा स़ोनो आइकोनियन सहरलाव घ्याँ पिसिदिया खन्‍दलाव एन्‍तिओखियादा बाद, ");
INSERT INTO kjl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","नलाव, परमेस्‍वरए ओपाँत हुवरालाई, “परमेस्‍वरए ओपाँ ताऱास्‍च्‍यो,” लिद यायुँर सझेंःद्याद, “परमेस्‍वरए ओराज्‍याल कुधु दुखर सहिद वाज़ केस्‍न्‍या गेले,” लिद यारासम्‍जैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","सु सु यामन्‍दलील सेवा चलैन्‍या स़ेरर खतैद्याद नोराए जूँनी उपासिद पोंखारिद यायुँ यासुहुबो परमेस्‍वरए ओपासल याराझाःकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","नकिन पिसिदिया खन्‍दलाव घ्याँ बाद पामफिलिया खन्‍दल केस्‍किनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","नल पर्गा सहरल बाद फरी ब परमेस्‍वरए ओपाँ यारासथैकिनी। ननी पुलुस्‍द अतालिया सहरल बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","नकिन फरी ऱी जहाजल पसिद सिरिया खन्‍दलाव एन्‍तिओखियादा बाकिनी। ङ़ादा नो एन्‍तिओखियानी ज़ नोनिलाई परमेस्‍वरए ओपाँ सथैन्‍याए जूँनी नलाव यायुँ हुबोराए परमेस्‍वरए ओपासल झाःद परींद यारानैज़्याव। है जैद नो य़ेन सयो·द नल ज़ ओल्किनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","पावल स़ोनो बारनाबासनी नल निकेसो प़ाइँना मन्‍दलीलाव मिँरालाई दुप्‍द परमेस्‍वरए नीस ओदोव य़ेन भरी है यारादोकिनी। “परमेस्‍वर गिनस गिनस बाद छुत जातलाव मिँरालाई पाला ओराज्‍याल पसिन्‍या येम फैद याएक्‍यो,” है लिन्‍या पाँर ब यारासथैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","नोनी नो सहरल यायुँ हुबो निनैंरास कुधु पै लिकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","पावल स़ोनो बारनाबासनी एन्‍तिओखियाल निलिज़्‍याक यहूदिया खन्‍दनी तोबो ऩेब्‍लो मिँर हुद नलाव येसुए ओपाँत हुवरालाई, “जे मोसाए ओकानुननी क्‍याल्‍न्‍या सरेस जेमाजैसिवा पै अजम्‍बरी जुनी दैन्‍या जेमाले,” है यारादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","नो पाँत पावल स़ोनो बारनाबासनी नोरास माखैद बनै खर्लेसिकेर। छींनी नलाव यायुँ हुबोराए या यामींर तोबो ऩेब्‍लो जैद पावल स़ोनो बारनाबासनिस यरूसलेमदा बान्‍या थ·रैकेर। ‘होङ बाद येसुए ओसाचीर स़ोनो मन्‍दलीलाव स़ेररास दैसिद आव पाँए उजूँनी सल्‍ला दाव ताके’ लिद, ");
INSERT INTO kjl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","मन्‍दलीए नोरालाई यापरींक्‍यो। नोर ननी पुलुस्‍द फोनिके स़ोनो सामरिया खन्‍दलाव घ्याँ बाद, ‘छुत जातलाव मिँर मनी परमेस्‍वरए ओपाँत हुज़्‍यार’ है लिन्‍या थार यारासथैक, नलाव यादाज्‍यु भाइर बनै ज़ रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","यरूसलेम याकेसोत नलाव मन्‍दलीलावर यास़ेररास स़ोनो येसुए ओसाचीराए नोरालाई यारासुम्‍केर। पावल स़ोनो बारनाबासनिस परमेस्‍वरए ओदोव य़ेन भरी है यारादोकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","निताव पाँ थैद येसुए ओपाँत हुव फरिसीर ख्वा ख्वार जाँ माभैंःद च्‍याँःसिद, “छुत जातलाव मिँर मनी परमेस्‍वरए ओपाँत याहुव प़ाइँना क्‍याल्‍न्‍या सरेस जैसिद, मोसाए ओकानुन ब सयो·व ज़ परींव ताके,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","है जैद नो पाँ थ·रैन्‍याए जूँनी येसुए ओसाचीर स़ोनो मन्‍दलीलाव स़ेरर दुप्‍सिद, ");
INSERT INTO kjl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","कुधु यापाँवत पत्रुस याङ़ाक च्‍याँःसिद अइ लिद यासथैक्‍यो, “अ ङादाज्‍यु भाइर, आदा थैचिके। छुत जातलाव मिँरालाई चाव था सथैद परमेस्‍वरए ओल्‍योदा जैन्‍याए जूँनी ङालाई जेखार्नी ङ़ादाकिन ज़ खतैद ओनैनाज़्‍याव जे ज़ जेसैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","प़ाइँए यायुँलाव पाँ सैंज़्‍याव परमेस्‍वरए गेलाई ओयासिउ मिताव ज़ नोरालाई मनी छैंव पुरूस याद उमींर ज़ ओराजैव सतैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","स़ोनो परमेस्‍वरए जातए ओलेखा मानैद नोरालाई मनी यायुँ यासुहुबोनी ज़ यायुँर सछैंद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","है जैद काराव गेसाखा पुर्खाराकिन ज़ गेमासहिधुहुज़्‍याव चलनर झन नोरालाई दाव परींद परमेस्‍वरलाई जाँचिन्‍या? ");
INSERT INTO kjl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","नोराए मिताव, गे मनी प्रभु येसुए गेल्‍योदा उयुँ ओगराँवनी वाज़ अजम्‍बरी जुनी दैन्‍या गेताज़्‍या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","नो पाँत प़ाइँ ज़ थाम थुम ताकेर। नकिन पावल स़ोनो बारनाबासनी निपाला ताद छुत जातलाव मिँराए याखार्ल नोनी निक्‍याँनी ज़ परमेस्‍वरए दाद ओरायो अचम्‍बलाव य़ेनर है निरादोक ते नोराए बनै ज़ धिद थैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","नोनी निपाँ ओखेमोत याकूबए अइ लिद यासथैक्‍यो, “अ ङादाज्‍यु भाइर, आदा थैचिके। ");
INSERT INTO kjl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","सिमोन पत्रुसए ओयाःनी जे ज़ थैद जेनै — परमेस्‍वरए छुत जातलाव मिँराए याखार्नी मनी ओल उमींर ओराजैज़्‍याव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","नो पाँत अगमबक्ताराए यापाँ ब चबनै खैज़्‍या। नोराए यापाँ इताव सर्सिउ लिज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘नाः भरी ओतावत ङा फरी हुद, चितराँ पुतराँ ताव दाऊदए ओराज्‍या बनैद्यान्‍या ङाले। त़ाव ओभार्नारालाई फरी ऱिम्‍द, म़ाव उमिन फरी ब नैद्यान्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","नाःत ज़ मानुवाताव मिँर प़ाइँए ज़ परमेस्‍वरलाई खिम्‍न्‍या लेर। ङामिनत ङाराछाँतिउ छुत जातलाव मिँर ब ङाल्‍योदा हुन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","आव पाँर परमेस्‍वरए नाम नम ओजैवकिन ज़ गोइँद ओनैज़्याव।’ ");
INSERT INTO kjl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“है जैद ङादाज्‍यु भाइर, ङा ङाबिचार इताव लिज़्‍या — नो परमेस्‍वरए ल्‍योदा हुज़्‍याव छुत जातलाव मिँरालाई माचाहिउ वैंन्‍या मिताव पाँर झाःद्यान्‍या माःक। ");
INSERT INTO kjl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","बुरू नोरालाई गेल्‍योनी चिथी तोबो परींद, नो चिथील ‘खाली अङग्‍यालाई चरैःसिउ ज़्‍यावर ताज़्‍युच्‍यो, ओधें फर्लेद सैःसिउ स्‍याकरी ताकैच्‍यो, झी ताज़्‍युच्‍यो, पातर्‍या पातर्नी ब ताजैसिच्‍यो’ है लिन्‍या पाँर वाज़ सर्द परींव ताके। ");
INSERT INTO kjl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","नोरालाई मोसाए ओकानुन थैन्‍या मौका ते भाःकिन ज़ उलिज़्‍याव। नोए ओपाँ सहर सहरल धर्मसास्‍त्र झ़िम झ़िमक ऩासिन्‍या छ्याम सथैव ज़ यारानैज़्‍यार,” है लिद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","है जैद येसुए ओसाचीर, ओपाँत बाज़्‍याव स़ेरर स़ोनो मन्‍दलीलाव मिँर प़ाइँ तोबो पाँत खैद यासकाव ऩेब्‍लो मिँनिलाई पावल स़ोनो बारनाबासनिस एन्‍तिओखियादा बान्‍या याराखतैकेर। नोनी घेप्‍पा मान दैव मिँनी ज़ निल्‍यो, निमिन बारसाबास यादोज़्‍याव यहूदा, स़ोनो सिलासनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","नोनी निकुइत इताव चिथी परींकेर, “गे येसुए ओसाचीर स़ोनो मन्‍दलीलाव लोम्‍बा जेदाज्‍यु भाइराए गेल्‍योनी, जे एन्‍तिओखिया, सिरिया स़ोनो किलिकियाल लिज़्‍याव छुत जातलाव गेदाज्‍यु भाइरालाई आव चिथी परींद गेयाचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","गेल्‍योनी बाव तोबो ऩेब्‍लो मिँर जेल्‍योङ हुद यापाँए जेयुँलाई आँचा पाँचा जैद याचिकेर दी लिन्‍या गेथैके। निताव सल्‍ला गे गेल्‍योनी हुव माःक, यानी ज़ ची। ");
INSERT INTO kjl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","है जैद गे भरी दुप्‍सिद तोबो ऩेब्‍लो गेमींरालाई गेयुँलाव पावल स़ोनो बारनाबासनिस जेल्‍योदा परींन्‍या गेथ·रैके। ");
INSERT INTO kjl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","नो पावल स़ोनो बारनाबासनी गेप्रभु येसु ख्रीसए ओय़ेनत निक्‍याँलाई मया मारिद निजिउ ज़ थाँद नैनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","है जैद नोनिस यहूदा स़ोनो सिलासनिलाई मनी गेरापरींज़्‍या। नोनी ज़ आलाव सर्सिउ पाँर साचो गेनी ज़ हुव लिद जेलाई है दान्‍या लिनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","अब गे भरी दुप्‍सिद छैंव पुरूसनी जे दान्‍या य़ेन आव ज़ थ·रैद गेनै — उपुर काता कर ज़ माले, खाली आव खास पाँर भन्‍या भैंःव ताके — ");
INSERT INTO kjl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","अङग्‍यालाई चरैःसिउ ज़्‍यावर ताज़्‍युच्‍यो, झी ताज़्‍युच्‍यो, ओधें फर्लेद सैःसिउ स्‍याकरी ताकैच्‍यो, पातर्‍या पातर्नी ब ताजैसिच्‍यो। आव मादान्‍या य़ेनर जेमादोकिन जेलाई चाव तान्‍या ले। गेपाँ आःज़, जेरो।” ");
INSERT INTO kjl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","नो चार जना यारापरींवर एन्‍तिओखियाल बाद नलाव मन्‍दलीलाव मिँरालाई दुप्‍द नो चिथी याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","नो युँ सझेंःन्‍या चिथी दैवराए प़ाइँलाई प़रिद यारासथैक यायुँ होलाँ ताद प़ाइँ ज़ बनै रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा स़ोनो सिलासनी मनी अगमबक्ता नितावए नोनी मनी नलाव मिँरालाई परमेस्‍वरए ओपाँर सथैद यायुँर बनै सझेंःद याराएकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","नो सहरल सर्बा ज़ निल्‍योत नलाव यायुँ हुबोराए फरी यरूसलेमदा चावस यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","खाली सिलासए नल ज़ लिन्‍या चाव ङम्सिके। ");
INSERT INTO kjl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पावल स़ोनो बारनाबासनी ते एन्‍तिओखियाल ज़ लिद छुत कुधुरास खैद परमेस्‍वरए ओपाँ पैद यारासथैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","छींनी तछा पावलए बारनाबासलाई, “गिन नो परमेस्‍वरए ओपाँ गिन्‍रासथैव पो पोङ बाद नलाव दाज्‍यु भाइर किताव यालिज़्‍याव फरी तखेप चिऊना गिन्बा,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बारनाबास मनी भैंःद निनैं यूहन्‍ना यादोज़्‍याव मर्कूसलाई ब लाँव ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","खाली पावलए ते माभैंःद, “आव य़ेनत ओजाँगर माहुद गिनलाई पामफिलियाल ऱास्‍द ख्यानैव मिँलाई गिन काराव लाँन्‍या?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","है जैद नोए उजूँनी नोनी जात्त ज़ माखैद भाःसिकिनी। बारनाबासए मर्कूसलाई ओलस ज़ लाँद ऱी जहाजल पसिद साइप्रस तापुदा बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पावलए ते सिलासलाई रूजिद ओनैं जैक्‍यो। नलाव लिज़्याव दाज्‍यु भाइराए नोनिलाई उयुँ य़ाल्‍ज़्याव परमेस्‍वरए ओपासल झाःद चावस यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","नोनी सिरिया स़ोनो किलिकिया खन्‍दल बाद नलाव मन्‍दलीलाव मिँरालाई पाथ पारैद यायुँर सझेंःद याराएकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","नकिन पावल स़ोनो सिलासनी दर्बी स़ोनो लुस्‍त्रा सहरल बाकिनी। नल परमेस्‍वरए ओपाँत तोबो उयुँ हुबो तिमोथी यादोज़्‍याव उलिज़्‍याव। होए ओआमा पाला उयुँ हुबो यहूदिनी ओल्‍यो, ओबाबु ग्रीक जातलाव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्‍त्रा स़ोनो आइकोनियनलाव यायुँ हुबोराए तिमोथीलाई बनै चाव मिँ थ·रैद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पावलए मनी नो मिँलाई ओलस बान्‍या ओनैं जैव ओपैंज़्‍याव। खाली नजीदाङाव यहूदीराए ग्रीक जातलाव ओबाबुलाई प़ाइँए ज़ यासरेस्‍ज़्‍याव। है जैद नोरालाई सभैंःन्‍याए जूँनी तिमोथीलाई क्‍याल्‍न्‍या सरेस जैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","हाःकिन नोनी सहर सहर, पो पोङ ‘यरूसलेमलाव येसुए ओसाचीर स़ोनो नलाव स़ेरराए याथ·रैव पाँर दोच्‍यो’ लिद याराअर्थैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ननी ज़ मन्‍दलीर यायुँर झन ज़ हुप्‍नाद, या ब झन ज़ बा·नाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","छैंव पुरूसए पावल स़ोनो सिलासनिलाई एसिया खन्‍दल परमेस्‍वरए ओपाँ सथैन्‍या उनिवैंवए फ्रिगिया स़ोनो गलातिया खन्‍दलाव घ्याँ बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","नकिन माइसिया खन्‍द निकेसोत बिथिनिया खन्‍दल बाव निपैंज़्‍याक येसुए उपुरूसए फरी ब निवैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","है जैद माइसियानी पुलुस्‍द त्रोआस सहरल बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","नल निलिज़्‍याक तछा रील पावलए दर्सनल माकेदोनियालाव मिँलाई च्‍याँःसिद उलिज़्याव रँःक्‍यो। नोए, “जिन माकेदोनिया खन्‍दल हुद गेलाई ब परमेस्‍वरए ओपाँ सथैव ताके,” है लिद बिन्‍ती दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","है जैद पावलए निताव दर्सन उरँःव छींनी, “परमेस्‍वरए गेलाई नदा मनी चाव था सथैना उपरींसिज़्‍याव ओल्‍यो,” लिन्‍या थ·रैद हतप्‍त ज़ बान्‍या गेझाःसिके। ");
INSERT INTO kjl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","त्रोआसकिन ऱी जहाजल पसिद एकसब्‍द्या ज़ सामोथ्राके तापुदा गेबाके। नकिन हो पराःती नियापोलिस सहरदा गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","नकिन बल्‍ल माकेदोनिया खन्‍दलाव तोबो फिलिप्‍पी यादोज़्‍याव मुख्या सहरल गेकेस्‍के। नलाव मिँर जाँकोसै रोमी जातलावर यालिज़्‍याव। नो सहरल सर्बा ज़ गेलिके। ");
INSERT INTO kjl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ऩासिन्‍या छ्याम सहरलाव य़ामनी पुलुस्‍द, ‘भै छ्योक पोंखारिन्‍या पो लिज़्याखेहो’ लिद नदा ज़ गेबाके। नङ दुप्‍सिद लिज़्‍याव मेंमारालाई मनी परमेस्‍वरए ओपाँ गेरासथैके। ");
INSERT INTO kjl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","नोरास परमेस्‍वरए ओमान नैज़्याव थिआतीरा सहरनी हुव तोबो लिदिया यादोज़्‍याव मेंमाए बनै धिद ओथैज़्याव। नो मेंमाए घ्‍यामो क्‍वाए बेपार ओदोज़्‍याव। प्रभुए नोलाई पावलए है ओरादोज़्‍याव पाँर बुझिन्‍या युँ जैदिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ओल स़ोनो उझ़िमलाव भरी ऱील सछैंसिद, “ङालाई परमेस्‍वरलाई उयुँ हुबो मेंमा जेथ·रैनाकिन ङा ङाझ़िमक हुद गेस ज़ ल्‍यो ताके,” है दाद गेलाई मालाँद मातान्‍या जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","फरी तछा नो पोंखारिन्‍या पोदा गेबाज़्‍याक तोबो जोखना चिऊन्‍या पुरूस दैव बाँदानी ल़ुज़ास गेदैसिके। नो ल़ुज़ाए, ओल्‍योक हुज़्‍यावरालाई हुन्‍या पाँर पाँद्याद ओघरपतीरालाई कुधु पैसा कमैद ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","हो छ्याम नो मेंमा गेछीं गेछीं हुद बनै चोइस, “आवर माहान परमेस्‍वरए ओनोकोरर ज़। यासथैचिज़्‍याव पाँर अजम्‍बरी जुनील सकेस्‍न्‍या पाँर ज़,” है लिद उक़िज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","कुधु दिन पै निताव क़िउ ज़ उलिज़्‍याव। तछा पावलए उयुँ कोला कोला ताद नो मेंमाए ल्‍योदा भाल्‍सिद ओक्‍याँताव च़रिउ पुरूसलाई, “ङा नँलाई येसु ख्रीसए उमिननी है ङादींज़्‍या, नोए ओक्‍याँतिन पुलुस्‍द बान्‍के,” है ओदोव प़ाइँना ज़ पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","नो ल़ुज़ाए ओघरपतीराए निताव रँःद, ‘गेपैसा हुन्‍या येम सूइद्यासिकिनी’ लिद पावल स़ोनो सिलासनिलाई क्‍योःद बजार खार्ल स़ेले स़ेले अदालतल लाँद, ");
INSERT INTO kjl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","हाकिमराए याङ़ाक सच्‍याँद, “आव यहूदीनी गेसहरलाव मिँरालाई गरबर याराजैज़्यानी। ");
INSERT INTO kjl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","गे रोमीराए गेकानुनस माखैव, गेमाभैंःज़्याव रितिथितीर यारापैज़्यानी,” है यारादोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","हाःत ज़ नलाव माहोल्‍याराए नोनी निक्‍याँत भोरो·सिउ पैंकेर। है जैद हाकिमराए नोनी निक्‍वार सिउःद्याद स्याकोराए रीःव यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","बनै ज़ प़ोद झ्यालखानाल झाःद पाल्‍यालाई बनै चावस गुव परींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","है जैद नो पाल्‍याए नोनिलाई प़ाइँरानी उजींलाव कुन्‍तील झाःद, निखँत हला झाःद निएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आधा रील पावल स़ोनो सिलासनी पोंखारिद परमेस्‍वरए उमिनत भजन निगैज़्‍याक, नीस लिज़्‍याव उपुर्काव कैदीराए याथैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","हाःत ज़ उमँःजानी बनै घ्‍योःव भोंचालो हुद झ्यालखाना भरी बनै थोनो·सिद य़ामर ब यानी ज़ फैसिकेर। कैदीराए यासाँगलर ब पला·सिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","हाःत ज़ नो पाल्‍या सैंसिद य़ाम भरी फैसिउ रँःद, “ओहो! कैदीर पुलुस्‍द याधोंःव ची ओल्‍यो,” लिद ओखोर्च्‍यो हाइद ओल ज़ सैःसिउ ओपैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पावलए निताव रँःद बनै चोइस क़िद, “थारे थारे, तासैःसिनी। गे प़ाइँ आल ज़ गेलिज़्‍या,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","नो पाल्‍याए ओनैंरालाई बत्ती रैव परींद, बनै भुम भुम गूद झ्यालखानाल धोंःनाद पावल स़ोनो सिलासनी निखँत फुलुप्‍सिके। ");
INSERT INTO kjl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","नोनिलाई ननी पले·द, “दे ङाधर्मीनी, ङा कै जैद बाँचिन्‍या ओताव?” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“प्रभु येसुलाई नयुँ सुहुप्‍द ओक्‍याँत नख्यासिकिन नँ स़ोनो नझ़िमलावरास बाँचिद अजम्‍बरी जुनी दैन्‍या जेले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","नो पाल्‍यालाई उझ़िमलाव भरिरास परमेस्‍वरए ओपाँ यारासथैकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","निताव आधा रील मनी नो पाल्‍याए पावल स़ोनो सिलासनिलाई निघाइर छेद निएक्‍यो। हो प़ाइँना ज़ पाल्‍या उझ़िमलावरास ऱील सछैंसिद, ");
INSERT INTO kjl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","पावल स़ोनो सिलासनिलाई उझ़िमक लाँद, ज़्‍यावर जैद निएक्‍यो। उझ़िमलावरास परमेस्‍वरए ल्‍योदा यायुँ यासुहुबोए बनै रेंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","नम छेलाला उसँक हाकिमराए, “पावल स़ोनो सिलासनिलाई निऱास्‍के,” लिद सिपाईंरालाई झ्यालखानादा है दानाव यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","है जैद पाल्‍याए नो था दैद पावललाई, “हाकिमराए जिनलाई ‘ऱास्‍न्‍या’ लिद था परींद नैर। है जैद जिन आनी पुलुस्‍द चावस बाचिन्‍के,” है उनिदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पावलए नो सिपाईंरालाई, “गिन रोमी नागरिकनिलाई मनी नाःकाव जनताराए ङ़ाक अऩाकल ज़ गिनलाई प़ोद गिनन्‍याय माफाल्‍द ज़ झ्यालखानाल झाःसिन्केर। अब कै जैद गिनलाई अलगज़ा पले·व यापैंज़्‍याव? माता। पले·न्‍या ताकिन याज़ ओपले·सिहुरक,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","नो सिपाईंराए हाकिमरालाई है यारादोनाकेर। नोराए नोनी रोमी नागरिकनी निल्‍यो लिन्‍या यामासैंज़्‍याव। है जैद नो पाँ थैद, हाकिमर बनै छे·द, ");
INSERT INTO kjl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","याज़ निल्‍योक बाद माफी ऩिद लाँःदा पले·द, “गेसहरलाई ऱास्‍द बाचिन्के,” है दाव ज़ यारानैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","है जैद नोनी झ्यालखानानी पुलुस्‍द लिदियाए उझ़िमक बाद येसुए ओपाँत बाज़्‍यावरास फरी तखेप दैसिद यायुँर सझेंःद्याद बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","नकिन पावल स़ोनो सिलासनी अम्‍फिपोलिस स़ोनो अपोल्‍लोनिया सहरलाव घ्याँ बाद थेसलोनिके सहरल केस्‍किनी। नल यहूदीराए धर्मसास्‍त्र झ़िम तोबो उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पावलए ङ़ादाकिनकाव ओदोज़्‍याव मिताव ज़ स़ोंसाता पै ऩासिन्‍या छ्याम नो याझ़िमल बाद धर्मसास्‍त्रलाव सर्सिउ पाँर पलास्‍द्याद, ");
INSERT INTO kjl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“ ‘ख्रीस दुखर सहिद, सिद सैंसिउ परिन्‍या ज़’ लिद भाःकिन ज़ धर्मसास्‍त्रल सर्सिउ उलिज़्‍याव,” है दाद थ·रैद याएक्‍यो। फरी, “आव है ङादाचिज़्याव येसु ज़ नो ख्रीस,” है मनी यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","नो पाँत ख्वा ख्वा यहूदीर यायुँ हुप्‍द पावल स़ोनो सिलासनिस खैकेर। परमेस्‍वरए ओमान नैज़्याव कुधु ग्रीकर स़ोनो सहरलाव यामिन थासो मेंमाराए ब यायुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","छुत यहूदीर ते यामी तूद बजार जीलाव अइज़ दुलिरिज़्‍याव सँधुवारालाई दुप्‍द नो सहरल खैलानी बैला जैव यारापरींकेर। नोर पावल स़ोनो सिलासनी निलिज़्‍याव तोबो यासोनए उझ़िमक बाद नोनिलाई पले·व पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","खाली नोनिलाई मादैद झन यासोनलाई ख्‍वा ख्‍वा यायुँ हुबोरास क्‍योःद अदालतदा स़ेले स़ेले लाँद, “नो सहर सहर दुलिद खैलानी बैला जैज़्‍यावनी गे गेसहरल ब निहुवत, ");
INSERT INTO kjl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","यासोनए ओल्‍योक बासिउ निएक्‍यो दी। नोर माहाराजाकिन प़ाइँ तँदा जैसिद नोराए याराजा येसु ज़ है लिज़्‍यार,” है लिद क़िउ ज़ लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","नोराए यापाँ थैद सहरलाव मिँर स़ोनो याघेप्‍पार बनै ज़ मचिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","है जैद यासोन स़ोनो ओनैंरालाई धरौतील याराऱास्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","नम ओझ्याक नलाव दाज्‍यु भाइराए पावल स़ोनो सिलासनिलाई हतप्‍त ज़ बेरिया सहरदा यारापरींकेर। नल निकेसोत फरी ब यहूदीराए धर्मसास्‍त्र झ़िमक बाकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","बेरियालाव यहूदीर ते थेसलोनिकेलाव मिँराकिन यातह ल्‍योर यालिज़्‍याव। नोराए पावल स़ोनो सिलासनी निपाँत बनै ज़ धिद थैद, ‘आवनी निपाँ साचो मालिज़्‍या’ लिद दिनकाव ज़ धर्मसास्‍त्रल याचिऊज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","है जैद नोर येसुए ओपाँत कुधुए यायुँ हुप्‍के। नोरास यामान ल्‍यो ग्रीक खेपा मेंमार ब सर्बा ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","खाली थेसलोनिकेलाव यहूदीराए, ‘पावलए बेरियाल मनी परमेस्‍वरए ओपाँ यासथैज़्‍याव दी’ लिन्‍या थैद, नदा मनी माहोल्‍यारालाई यारामचैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","है जैद नलाव यायुँ हुबोराए पावललाई जोगोइन्‍याए जूँनी समुन्‍द्र छ्योक पै सारैनाकेर। सिलास ते तिमोथीस नल ज़ लिकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","है जैद पावललाई सारैना बावराए एथेन्‍स सहरक पै लाँकेर। ननी ओल्‍द बाव यापैंज़्‍याक पावलए नोराए कुइत सिलास स़ोनो तिमोथीनिलाई, ‘ओताकिन चाँदो ज़ हुचिन’ लिन्‍या था परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पावलए एथेन्‍स सहरल सिलास स़ोनो तिमोथीनिलाई कींद उनिनैज़्‍याक नलाव कुधु अङग्‍यार रँःद उयुँर माचाव दाद, ");
INSERT INTO kjl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","धर्मसास्‍त्र झ़िमल बाद नलाव यहूदीर स़ोनो परमेस्‍वरए ओमान नैज़्याव ग्रीकरास कुधु ज़ याखर्लेसिज़्याव। बजार जील आदा होदा लिज़्‍यावरास मनी दिनकाव ज़ ओपाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तछा इपिक्‍युरी स़ोनो स्‍तोइकी यादोज़्‍याव धर्म मानिज़्‍यावर हुद ओपाँ थैद खर्लेसिनाकेर। पावलए येसुए ओपाँ सथैद, ‘सिउनी सैंसिके’ है लिन्‍या पाँर ओरासथैवए नोर ख्वा ख्वाराए, “काता ओपाँज़्‍याव, निताव त्‍यात्‍यानी तितिव?” है यालिज़्‍याव। ख्वाराए फरी, “काताङाव देवताराए यापाँ ओपाँज़्‍याव ताक्‍या?” है ब यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","छींनी नोराए अरियोपागस कचरीक लाँद, “नो साःरो पाँए ओअर्थ खास काता उलिज़्‍याव? गेलाई है दासिके। ");
INSERT INTO kjl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","गे अनवार्‍यासो ज़ गेथैज़्‍या। ओअर्थ पलास्‍द्याद फरी ब तखेप थैव गेदैक,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","नो एथेन्‍सलाव मिँर स़ोनो यासहरल छुतनी हुद लिज़्‍यावराए पाला जम्‍मा साःरो पाँर थैन्‍यात वाज़ लहर यादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","है जैद अरियोपागस कचरीक पावल प़ाइँए याङ़ाक च्‍याँःसिद, “अ एथेन्‍सलाव मिँर, जे धर्म खिम्‍न्‍यार जेलिज़्‍याव ओल्‍यो ङामीए ज़ रँःद ङानैचिए। ");
INSERT INTO kjl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","जेसहरलाव पुजा दान्‍या पोर आदा होदा ङालिक तोबो थानत, ‘सुए ज़ यामासरेस्‍ताव ईस्‍वर’ सर्सिउ उलिज़्‍याव ङारँःके। ङा है ङादाचिज़्‍याव परमेस्‍वर नो मासरेस्‍द जेमानिज़्‍याव ईस्‍वर ज़। ");
INSERT INTO kjl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","प़ाइँ जैज़्‍याव परमेस्‍वर नाम नमलावराए गेङ़ैताव ओतावए कुइए जैसिउ मन्‍दिरल मालिधुइ। ");
INSERT INTO kjl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","होलाई मिँए ल्‍योनी काता ज़ खाँचो ब माले। झन गेलाई चाहिज़्‍याव भरी होए ओल्‍योनी ज़ हुज़्‍या। आव गेजिउ ब होए ओल्‍योनी ज़, गेस॰ ब ओल झाःद ओयासिउ ज़। ");
INSERT INTO kjl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","तोबो मिँए ओक्‍याँनी ज़ आव मानुवाताव प़ाइँ जातलाव मिँरालाई याजैक्‍यो। नोरालाई सु सु लिन्‍या यापो, सु सु याबेला ब ओल ज़ थ·रैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","है जैद ‘ङालाई छाम छाम जैद तादी ब कसा खिम्‍द मादैनार’ है लिद ओल ज़ इताव जैक्‍यो। हैदी ब परमेस्‍वर गेकिन तादाङ माले। ");
INSERT INTO kjl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","गे होए उकुइत ज़ ताद ओलनी ज़ गेबाँचिज़्‍या, ओलनी ज़ गेचलिज़्‍या। जेसकाव सैंन्‍याराए मनी, ‘गे ओल ओज़ार ज़ गेलिज़्‍या,’ है लिद लेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“है जैद गे परमेस्‍वरए ओज़ार गेताकिन, कै जैद ओल ते सीं लुँ ओताज़्‍याव? सुन चाँदीए जैसिउ अङग्‍या ते अइज़ मिँए युँ स्‍यानी जैसिउ ची। ");
INSERT INTO kjl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ङ़ादाकिन परमेस्‍वरलाई मासरेस्‍दकाव अऩाकलाव गेदोव भरी ते आथ पाला पै गेचार ताके। आकिनी ते परमेस्‍वरए प़ाइँनिकाव मिँरालाई ‘निताव माचाहिउ य़ेन भरी ऱास्‍द ङाल्‍योदा हुचिके,’ है दासिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","मानुवाताव मिँराए न्‍याय फाल्‍न्‍या ब ‘आव छ्याम ज़ तारिज़्‍या’ लिद थ·रैद नैव। सतस न्‍याय फाल्‍न्‍या मिँ ब ‘आव ज़’ लिद प़ाइँए याङ़ाक सिउनी सोचोइद थ·रैद याएक्‍यो,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","‘सिउनी ओसोचोइव’ है ओरादोव याथैक ख्वा ख्वार स़ास्‍केर। ख्वाराए फरी, “छींनी ब तछा नपाँ थैव गेदैक,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","है जैद पावल ननी पुलुस्‍द ओबाक, ");
INSERT INTO kjl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ख्वा ख्वार ओल्‍योदा जैसिद ओपाँत यायुँ हुप्‍के। नोरानी अरियोपागस कचरीलाव तोबो दियनुसियस ओल्‍यो, तोबो दामारिस यादोज़्‍याव मेंमा ब ओल्‍यो। नोनिस छुतर ब याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","नकिन पावल एथेन्‍स सहरलाई ऱास्‍द कोरिन्‍थ सहरदा बाके। ");
INSERT INTO kjl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","होङ बाद तोबो पोन्‍तस खन्‍दल जर्मिउ अकिलास यादोज़्‍याव यहूदीस दैसिकिनी। ओज्‍याए उमिन प्रिस्‍किला। माहाराजा क्‍लौदियसए यहूदी भरिरालाई रोम सहरनी ओरापले·वए नोनी ज्‍या-री भर ज़ इतालिया देसनी कोरिन्‍थल हुद निलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","नोनी निय़ेन ब पावलए ओय़ेन स्‍यासो पाल जैन्‍या ओतावए, पावल नोनिस लिद याय़ेन ब सिप ज़ दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","साताकाव तखेप ऩासिन्‍या छ्याम धर्मसास्‍त्र झ़िमल बाद यहूदीर स़ोनो ग्रीकरास खर्लेसिद सभैंःन्‍या ओपैंज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","छींनी सिलास स़ोनो तिमोथीनी पावलए ल्‍योक माकेदोनिया खन्‍दनी निहुवत पावलए ओध्‍यावना परमेस्‍वरए ओपाँ सथैन्‍या वाज़ जैद, यहूदीरालाई ‘येसु ज़ पापनी ऱास्‍ज़्याव ख्रीस’ लिद साची ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","नोर पावलए ओपाँर माभैंःद ओपाँलाई थल्‍द बीज्‍यात जैव यापैंवए पावलए ओक्‍वाताव गालो धुइरोर याङ़ाक थरैद्याद, “जेपाप भरी जे जेङ़ैत ज़ ओताक। जे नो पाँ जेमाभैंःव प़ाइँना फुर्सुल ङाताके। अबकिन ङा छुत जातलावरालाई ची ङारासथैनारिज़्‍या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ननी पुलुस्‍द धर्मसास्‍त्र झ़िम लापकाव तीतस युस्‍तसए उझ़िमक बाके। नो मिँ ब परमेस्‍वरए ओमान नैज़्याव ज़ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","धर्मसास्‍त्र झ़िमलावराए याघेप्‍पा ब तोबो क्रिस्‍पसए उझ़िमलाव भरिरास परमेस्‍वरए ओपाँत यायुँ हुप्‍के। कोरिन्‍थलाव छुत छुतराए मनी परमेस्‍वरए ओपाँ थैद, यायुँ हुप्‍द ऱील सछैंसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","तछा रील पावलए दर्सनल प्रभु ओपाँज़्‍याव रँःक्‍यो। प्रभुए, “पावल, नँ माछे·द ज़ आव सहरल ङापाँ सथैव ज़ घरानैयो, च़िम दान्‍या माःक। ");
INSERT INTO kjl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ङा नँस ज़ ङालिज़्‍या। सुए ज़ नँलाई कैज़ जैन्‍या मालेर। आव सहरल ङामींर कुधु ज़ तान्‍या लेर,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","है जैद पावल नो सहरल अथार मैना लिद परमेस्‍वरए ओपाँ पलास्‍द ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","अखैया खन्‍दल गलियोन हाकिम उलिज़्‍याव बेलाक, यहूदीर पावलकिन तँदा जैसिद पावललाई क्‍योःद अदालतदा लाँद, ");
INSERT INTO kjl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“आव मिँए परमेस्‍वरए ओसेवा तँदा बङ्गैद मोसाए ओकानुनकिन छुत येम यापैज़्‍याव,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पावलए जवाप याव ओपैंज़्‍याक ज़ गलियोनए ओल ज़, “अ यहूदीर, आव मिँए मादान्‍या य़ेनर ओदोव ताकिन ङा जेपाँ सहिद ङायाचिखेहो। ");
INSERT INTO kjl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","खाली जे जेधर्म रोक मेक ताद, काता काताराए यामिनर ओत़ोसिक जे ते जम्‍मा इ़सिउ वाज़ जेपैंज़्‍या। ङा निताव पाँ कै जैद थैन्‍या? जे ज़ सैंच्‍यो,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अदालतनी यापले·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","हाःत ज़ झन नोराए धर्मसास्‍त्र झ़िमलाव याघेप्‍पा सोस्‍थेनेसलाई क्‍योःद अदालत ङ़ाक ज़ प़ोकेर। खाली गलियोनए घाइ ज़ मारादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पावल कोरिन्‍थ सहरल सर्बा ज़ लिद यायुँ हुबोराए ल्‍योनी बिदा ऩिद, ‘सिरिया खन्‍ददा ओल्‍द बान्‍या’ लिद ऱी जहाजल पसिके। ओलस अकिलास स़ोनो प्रिस्‍किलानिलाई ब निलाँक्‍यो। नोकिन ङ़ादा कोरिन्‍थ लापकाव किंक्रिया सहरल किर्‍या झाःद ओचेम ब एन्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","नकिन ऱी जहाजल एफिसस सहर पै बाद अकिलास स़ोनो प्रिस्‍किलानिलाई नल ज़ निख्यानैक्‍यो। ओल ते जाँवा पै वाज़ लिद धर्मसास्‍त्र झ़िमल बाद यहूदीरास खर्लेसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","नकिन नोराए, “गेस ज़ जाँवा पै ल्‍यो ताके,” है यादोक ते, पावलए माभैंःद, ");
INSERT INTO kjl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“परमेस्‍वरए उयुँ ओताकिन फरी ङाहुया ज़,” है दाद ऱी जहाजल पसिद एफिससनी बाके। ");
INSERT INTO kjl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","सिरिया खन्‍दलाव कैसरियाल केस्‍द जहाजतिन झरिद यरूसलेम पै बाद नलाव मन्‍दलीस दैसिद एन्‍तिओखियादा बाके। ");
INSERT INTO kjl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","नल जाँवा लिद गलातिया स़ोनो फ्रिगिया खन्‍द जीलाव पो पोक लिज़्‍याव येसुए ओपाँत बाज़्‍याव भरिरास दैसिद परमेस्‍वरए ओपाँत यायुँ सझेंःद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अलेक्‍जेन्‍द्रिया सहरलाव तोबो अपोल्‍लोस यादोज़्‍याव यहूदी एफिससल केस्‍हुके। नो मिँए ओपाँ बनै ङमो, धर्मसास्‍त्रलाव पाँ ब बनै ओसैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","प्रभुए ओपाँ ब सर्बा ज़ सिऊसिद बनै जाँगरस येसुए ओपाँर सथैद चावस ज़ पलास्‍द ओराएज़्‍याव। खाली यूहन्‍नाए ओरासछैंज़्याव वाज़ ओसैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","नोए धर्मसास्‍त्र झ़िमल बनै घ्‍योःव युँस परमेस्‍वरए ओपाँ ओरासथैज़्‍याव। अकिलास स़ोनो प्रिस्‍किलानी नोए ओपाँ थैद नोलाई निझ़िमदा लाँद येसुए उजूँनी ओमासैंज़्‍याव पाँ भरी पलास्‍दिकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","नकिन अपोल्‍लोस अखैयादा बान्‍या युँ दोक्‍यो। है जैद नलाव यायुँ हुबोराए उयुँर सझेंःद्याद, ‘आव मिँलाई चावस नैच्‍यो’ लिद होङाव यायुँ हुबोरालाई तोबो चिथी परींद याराएकेर। अपोल्‍लोस होङ केस्‍द परमेस्‍वरए उयुँ ओगराँवनी यायुँ हुबोरालाई कुधु ज़ यासघैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","प़ाइँए याङ़ाक यहूदीराए यापाँ पल्‍तैद्याद, ‘येसु ज़ परमेस्‍वरए खतैद उपरींव ख्रीस’ लिद धर्मसास्‍त्रनी थ·रैद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अपोल्‍लोस कोरिन्‍थल उलिज़्‍याक पावल रूनिकाव घ्याँ हुद एफिसस सहरल केस्‍हुके। नल ख्‍वा ख्‍वा येसुए ओपाँत बाज़्‍यावरास दैसिद, ");
INSERT INTO kjl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“जे येसुए ओपाँत जेहुव बेलाक छैंव पुरूस दैद जेमानै?” है ओरादोक ते, नोराए, “छैंव पुरूसए उमिन आःपै गेमाथैताए,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","नकिन पावलए, “हिताव ताकिन ते, जे काताए ओपाँनी जेसछैंसिउ की?” है ओरादोक ते, “गे ते यूहन्‍नाए ओपाँनी गेसछैंसिउ ची,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","है जैद पावलए याबिरैव भरी चावस पलास्‍द्याद, “ऱील सछैंज़्‍याव यूहन्‍नाए मिँरालाई यादोव पापनी यायुँ फर्कैद्याद ओलकिन छींनी हुज़्‍याव येसुए ल्‍योदा यायुँ सुहुप्‍द्यान्‍याए जूँनी ओरासछैंज़्‍याव ची,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","नोराए निताव पाँ थैद प्रभु येसुए उमिननी ज़ सछैंसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","नकिन पावलए याक्‍याँत उकुइ नैद ओरायो प़ाइँना छैंव पुरूस याक्‍याँत हुद नोर छुत छुत खामनी ब पाँकेर, छैंव पुरूसनी अचम्‍बलाव पाँर ब पाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","नोर बाह्र जनावा याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","नकिन स़ोंमैना पै पावलए धर्मसास्‍त्र झ़िमल परमेस्‍वरए ओराज्‍यालाव पाँर सथैद नोरास खर्लेसिद नोरालाई सभैंःन्‍यात बनै ज़ धामा दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","हितावत मनी ख्वा ख्वाराए परमेस्‍वरए ल्‍योदा यायुँ जात्त ज़ माफर्कैद, झन ज़ एकोहोर्‍यासो जैसिद माहोल्‍याराए याङ़ाक येसुए ओपाँ बले·व पैंकेर। है जैद पावल येसुए ओपाँत हुव भरिरास ननी भाःसिद हाःकिन तुरान्‍नस इस्‍कुलल यादुप्‍सिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ऩेरिम भरी नल दुप्‍सिद एसिया खन्‍द भरिल लिज़्याव यहूदीर स़ोनो छुत जातलाव मिँराए परमेस्‍वरए ओपाँ थैन्‍या मौका दैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेस्‍वरए पावलए ओक्‍याँनी अचम्‍बलाव ओय़ेनर सतैंद ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","क्‍वार रैद पावललाई छापो परींद याजोरो हुवर लाँद याराएक, नो याजोरो हुवर यागराँज़्‍याव, माचाव पुरूसर ब पुलुस्‍द याबाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","यहूदीराए याखार्ल मनी माचाव पुरूसर पले·न्‍यार यालिज़्‍याव। नोराए माचाव पुरूसरालाई प्रभु येसुए उमिननी पले·न्‍या धामा दाद, “गे है गेदाचिज़्‍या, पावलए ओरासथैज़्‍याव येसुए उमिननी जे पुलुस्‍द बाचिके,” है यारादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","तोबो स्‍केवास यादोज़्‍याव यहूदी मुख्या पुजारीए सात भाइ ओज़ाराए मनी निताव य़ेन यादोज़्‍याक, ");
INSERT INTO kjl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","नो माचाव पुरूसए, “येसुलाई ङासरेस्‍ज़्‍या, पावललाई मनी ङासरेस्‍ज़्‍या, जेलाई ते ङामासरेस्‍चिए,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","नो माचाव पुरूसए क्‍योःद ओनैज़्‍याव मिँए नोरालाई खप्‍द हारैद, नोर नो झ़िमनी नाङग्‍या पात्‍या, झीर्घ्यामनी मर्घ्यामोर ताद पुलुस्‍द धोंःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","एफिससल लिज़्‍याव भरिराए, यहूदीर स़ोनो छुत जातलावर, आव पाँर थैद बनै ज़ छे·केर। है जैद प्रभु येसुए उमिन बनै घ्‍योःद ओमान ब रहिके। ");
INSERT INTO kjl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","प्रभु येसुए ओपाँत हुवर मनी कुधुए ङ़ादाकिनकाव माचाव याय़ेनर प़ाइँए याङ़ाक माम़ोंद ज़ यापाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ङ़ादाकिन मन्‍तर तन्‍तर दाज़्‍यावराए ते यापोस्‍तोकोर रैद दुप्‍द प़ाइँए याङ़ाक ज़ याराम़ुकेर। नो याराम़ुव पोस्‍तोकोराए याएः याजाँचिक चाँदीए सिक्‍का पचास हजारा ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","है जैद परमेस्‍वरए ओपाँ प़ाइँनी प़ाइँनी ज़ घ्‍योःद आदा होदा बनै ज़ उफींजिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","आव भरी ओतावत पावलए उयुँल, माकेदोनिया स़ोनो अखैयालाव घ्याँ बाद फरी यरूसलेमदा बान्‍या थ·रैक्‍यो। ‘हुकिन छींनी रोम सहरदा मनी बाव ताके’ है उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","है जैद ओसेवा दाज़्‍यावनी, तिमोथी स़ोनो इरास्‍तसनिलाई, ओलकिन ङ़ादा ज़ माकेदोनियादा निपरींक्‍यो। ओल ते जाँवा पै एसिया खन्‍दल ज़ लिके। ");
INSERT INTO kjl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","हाः बेलाक एफिसस सहरल येसुए ओपाँत छ्याल्‍दिउ खैलानी बैला माताके। ");
INSERT INTO kjl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","तोबो देमेत्रियस यादोज़्‍याव सोनारए, आर्तेमिस देबीए ज़िम्ज़ा ज़िम्ज़ा चाँदीए अङग्‍यार जैद सहरलाव तुप्‍न्‍यारालाई कुधु फाइदा जैद ओराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","तछा नोरालाई स़ोनो छुत नो मिताव य़ेन दाज़्यावरालाई दुप्‍द, “अ ङादाज्‍यु भाइर, जे ज़ जेसैंज़्‍या, आव गेय़ेननी ज़ चाव कमाइ ताज़्या। ");
INSERT INTO kjl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","नो पावलए झन आव गेसहरल स़ोनो एसिया भरिल, ‘कुइए जैसिउ अङग्‍यार काता देवतार ब माःक’ है दाद कुधु मिँरालाई तँदा ज़ याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","है जैद नोए ओपाँए ज़ आव गेय़ेन वाज़ माःक, झन आर्तेमिस गेदेवत्‍यानीए ओमन्‍दिर ब कान्‍ल ज़ गनिसिन्‍या माले। हिताव ओताकिन ते एसिया भरिल स़ोनो मानुवाताव मिँराए गेमानिज़्‍याव देवत्‍यानीए ओज़गै मगै ब म़ान्‍या ओछ्यास लिज़्या,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","प़ाइँ ज़ यारिस बनै चोद, “एफिससल लिज़्याव आर्तेमिस देवत्‍यानी जय जय,” है लिद बनै क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","नो पाँत सहरलाव मिँर कुधु ज़ मचिद माकेदोनियानी हुव पावलए ओनैंनी गायस स़ोनो अरिस्‍तार्खसनिलाई क्‍योःद राम दान्‍या पोल स़ेले स़ेले यारालाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पावलए नो पाँ थैद ओनैंनी निजूँनी राम दान्‍या पोदा बाव ओपैंज़्‍याव, नलाव यायुँ हुबोराए भैंःद माएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","एसिया खन्‍दलाव सरकारए ओय़ेन दाज़्‍याव ख्‍वा ख्‍वा ओनैंराए मनी, “राम दान्‍या पोदा ताबानी,” लिद ओल्‍योदा था परींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","नल बावर ख्वाराए ‘आव ज़’, ख्वाराए ‘हो ज़’ लिद बनै याक़िक सुए ज़ काता ज़ माथ·रैधुकेर। खाली कुधु मिँराए ‘काराव यादुप्‍सिउ’ लिन्‍या ब यामासैंज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","छींनी नलाव यहूदीराए तोबो अलेक्‍जेन्‍दरलाई जवाप याव परींकेर। है जैद नोए, ‘आदा थैचिके’ लिद उकुइए सान दाद याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","खाली नोराए ‘यहूदी ज़ ओल्‍यो’ लिन्‍या सरेस्‍द प़ाइँए यार्गा तोबो जैद, “एफिससल लिज़्याव आर्तेमिस देवत्‍यानी जय जय,” है लिद ऩेघन्‍ता भरी क़िउका क़िउ ज़ लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","बल्‍ल बल्‍लङ नो सहरलाव प्रधानए नोरालाई चाप चुप जैद, “अ एफिससलाव मिँर, आदा थैचिके। नो नमतिन तेव माहान देवत्‍यानी आर्तेमिस स़ोनो होए ओमन्‍दिर आव गेसहरल गेमीं ज़ लिज़्‍या लिन्‍या प़ाइँए ज़ सैंज़्‍यार सानी। ");
INSERT INTO kjl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","‘माःक’ लिन्‍या सु ज़ मालेर। जे काराव जेमचिज़्‍याव? च़िम दोचिके, मुर्खलाव य़ेन तादोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","आव स़ेल्‍द जेरारैव मिँनी ते गेमन्‍दिरनी काता ब माहाइनी, गेदेवताए उमिन ब बले·द मायासिर। ");
INSERT INTO kjl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","है जैद देमेत्रियस स़ोनो ओलसकाव ओनैंराए यामुद्दा कातार उलिकिन अदालतल बाद उजुर ओदोरक। ");
INSERT INTO kjl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","छुत यापाँ उलिकिन जनताराए कचरी मनी लिज़्‍या सानी। ");
INSERT INTO kjl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","खाली अऩाकलाव आछिमकाव जेदोज़्‍याव मिताव ते दान्‍या माःक, म़ानी रोमी सरकारए गेलाई गेगल्‍ती थ·रैद्यान्‍या ओछ्यास लिज़्‍या। मचिन्‍या निउँ काता ज़ ओमाल्‍योए गे काता जवाप यान्‍या?” ");
INSERT INTO kjl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","है दाद प़ाइँलाई भाःसिउ यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","राउँनी झ्याउँ ओखेमोत पावलए नलाव यायुँ हुबोरालाई दुप्‍द परमेस्‍वरए ओपाँनी यायुँ सझेंःद्याद, बिदा ऩिद माकेदोनिया खन्‍ददा बाके। ");
INSERT INTO kjl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","नदाङाव यायुँ हुबोरालाई मनी परमेस्‍वरए ओपाँर सथैद यायुँ सझेंःद याएक्‍यो। नकिन ग्रीस देसदा बाद, ");
INSERT INTO kjl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","नल स़ोंमैना पै लिके। ननी ऱी जहाजनी सिरिया खन्‍ददा बाव ओपैंज़्‍याक, ‘यहूदीराए पावललाई सैःव पैंज़्‍यार दी’ लिन्‍या थैद नो येमनी माबाद फरी माकेदोनियालाव घ्याँ बान्‍या थ·रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ओलस छुत मिँर मनी बाकेर। नोराए यामिनर आवर ज़ — बेरिया सहरलाव पुरसए ओज़ा सोपात्रोस, थेसलोनिके सहरलाव अरिस्‍तार्खस स़ोनो सिकन्‍दसनी, दर्बी सहरलाव गायस, तिमोथी, स़ोनो एसिया खन्‍दलाव तुखिकस स़ोनो त्रोफिमसर ज़। ");
INSERT INTO kjl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","नोर गेकिन ङ़ादा बाद त्रोआस सहरल याकींसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","माँदा भरेस ज़्‍यान्‍या पर्ब ओमाखेमा पै फिलिप्‍पी सहरल गेलिके। पर्ब ओखेमोत ऱी जहाजल पसिद पाँच दिनत त्रोआसल केस्‍द ङ़ादा बावरास दैसिद, नल सात दिन गेलिके। ");
INSERT INTO kjl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","सातालाव उस॰कताव छ्याम ऱिमक त्रोआसलाव यायुँ हुबोरास दुप्‍सिद प्रभु-भोज गेमानिज़्‍याव। पावल हो पराःती बाव ओपैंज़्‍यावए आधा री पै परमेस्‍वरए ओपाँ ओसथैसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","नो दुप्‍सिद गेलिज़्‍याव ओतर्ताव तालल कुधु बत्तीर तैंःसिउ यालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","झ्यालत तोबो धापाज़ाकाव युतिकस यादोज़्‍याव च़ुसिद उउङ्गिज़्याव। पावलए ओपाँ बनै ओख्यो·वए नो छोर्‍या घेप्‍पा ङ़लत बाद स़ोंताल्‍यातिन तेके। नोलाई याच़ानाक सिउ दैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पावल रूतिन झरिद नो छोर्‍यालाई लाप्‍द प़ाइँलाई, “जेयुँ होलाँ जैचिके, उस॰ लिज़्या,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","फरी रोत बाद येसुए उमिनताव भरेस केःद भाःद्याद, नम उसँवा पै परमेस्‍वरए ओपाँर सथैद ननी पुलुस्‍द बाके। ");
INSERT INTO kjl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","नो छोर्‍या मासिद ओबाँचिउए प़ाइँए यायुँ बनै होलाँ ताद झ़िमक लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","पावल त्रोआसकिन अस्‍सोस सहरक पै उखँनी ज़ बान्‍या थ·रैद गेलाई ऱी जहाजल बाव परींसिक्‍यो। ओल अस्‍सोसकिन वाज़ ऱी जहाजल पसिन्‍या युँ ओदोवए, ");
INSERT INTO kjl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","नल ओल गेस दैसिद हाःकिन ऱी जहाजल गेस ज़ बाके। मितिलेने सहरल गेकेसोत, ");
INSERT INTO kjl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","हो पराःती खियस तापुए ओसोराक गेबाके। हुकिन सामोस तापुल बाद, हुकिनकाव हो पराःती मिलेतस सहरल गेकेस्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पावलए, ‘एसिया खन्‍दल गेबाकिन यरूसलेमलाव पेन्‍तिकोस पर्बदा गेमाताप्‍नाधुया’ लिद बनै घल्‍सिद एफिसस सहरदा माबान्‍या जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","बुरू एफिससलाव मन्‍दलीलाव स़ेररालाई मिलेतसनी थार परींद ओल्‍योदा ज़ याथाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","एफिससलाव मन्‍दलीलाव स़ेरर पावलए ओल्‍योक याकेस्‍हुवत पावलए, “ङा एसियाल ङाकेस्‍हुव छ्यामकिन ङादोव भरी जे ज़ जेसैंज़्‍या। ङा जेस लिद, ");
INSERT INTO kjl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यहूदीराए ल्‍योनी कुधु दुखर ङादैज़्‍यावत ब, जेजूँनी ङा सज़िम्‍सिद परमेस्‍वरए ओसेवा दाद ङाप़िलर ब ङाऱास्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","जेलाई ओचाहित ल्‍यो पाँर सथैन्‍या माअन्‍कनिद ज़ जेदुप्‍सिज़्‍याव पो पोक, जेझ़िमक जेझ़िमक ब ङासथैचिके। ");
INSERT INTO kjl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","जेदेसलाव यहूदीर स़ोनो छुत जातलाव मिँरालाई, ‘जेपापलाई ऱास्‍द, परमेस्‍वरए ल्‍योदा सखैसिद, गेप्रभु येसु ख्रीसए ओपाँत जेयुँ सुहुप्‍चिके,’ लिद प़ाइँलाई ज़ ङारासथैके। ");
INSERT INTO kjl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“अब ते छैंव पुरूसए है ओदाँव भैंःद यरूसलेमदा ङाबाज़्‍या। होङ केस्‍द ‘अइ ङातारिज़्‍या’ लिन्‍या ते ङामासैंए। ");
INSERT INTO kjl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","खाली जो सहरल ङाबादी ब छैंव पुरूसए, ‘नजुँ आव ज़ — दुखर दैन्‍या स़ोनो झ्‍यालखानाल लिन्‍या’ लिद है दाँज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","हैदी ब ङाजिउए मया माले, खाली ङाय़ेन भरी सुदुम्‍द, प्रभु येसुए ङालाई ओयाँव य़ेनलाई सयो·न्‍यात वाज़ ङायुँ थू ताज़्‍या। नो ओयाँव ङाय़ेन ते, ‘परमेस्‍वर गेल्‍योदा उयुँ ओगराँव’ है लिन्‍या चाव था सथैन्‍या ज़। ");
INSERT INTO kjl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“अबकिन ते जे परमेस्‍वरए ओराज्‍यालाव पाँ जेल्‍योङाव ङासथैचिउ मिँराए फरी ङाङाः रँःव दैन्‍या जेमाले लिन्‍या ङासैंज़्या। ");
INSERT INTO kjl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","है जैद जे आछिम आव सैंचिके — जे सुवाराए तछा परमेस्‍वरए ओसजा जेदैकिन, नो ङा ङागल्‍ती तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","परमेस्‍वरए ओगोइँ भरी ओपो·स ज़ जेल्‍योङ सथैद ङासयो·के। ");
INSERT INTO kjl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“है जैद जे परमेस्‍वरए ओबगाललाव यालोम्‍बार, छैंव पुरूसए ओखतैचिउर, जेक्‍याँलाई जोगोइद ख्रीसए उझीए ओरालँःव परमेस्‍वरए ओमन्‍दलीलाई पाथस याराछोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ङा ङाबाव छींनी जेबगालल छे छे ङम्‍सिउ प़र स्‍यासोर पसिद रन्‍दनी बन्‍द जैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","जेखार्लाव मिँराए मनी ख्वा ख्वार तँदा जैसिद परमेस्‍वरए ओपाँताव मिँरालाई याल्‍योदा जैन्‍याए जूँनी धुत पाँर ब पैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","है जैद जे सैंसिद लिच्‍यो। ङा जेल्‍योङाव स़ोंरिम भरी लाकनी रील परमेस्‍वरए ओपाँर तोबो तोबोनी पैद ङाप़िलर ङाऱासो ब तामेंःच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“अब ते ङा जेलाई परमेस्‍वरए ओपासल ङाझाःचिज़्‍या। गराँव ओपाँ ब जेस ज़ लिज़्‍या। नो पाँए जेलाई थ॰रिउ जैद, परमेस्‍वरए उमिनत लिज़्‍यावरास जेलाई मनी परमेस्‍वरनिकाव जुँ दैन्‍या जैचिरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ङा जेस ङालिज़्‍याक सुए जेल्‍योनी ब पैसार क्‍वाराए लोभ ङामादोए। ");
INSERT INTO kjl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","जे ज़ जेसैंज़्‍या, ङा स़ोनो ङानैंरालाई ओचाहिज़्‍याव भरी आव ङाकुइए ज़ य़ेन दाद गेङासिके। ");
INSERT INTO kjl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","है जैद प़ाइँनी ज़ जेल्‍योङ मनी ङासतैंके — गेकुइए य़ेन बनै दाद माधुन्‍यारालाई मनी सघैव ताके। आवए जूँनी गेप्रभु येसुए ओपाँ ब तामेंःच्‍यो — ‘छुतए ल्‍योनी दैन्‍या देखा, छुतलाई यान्‍या पाथ लिज़्‍या।’ ” ");
INSERT INTO kjl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","पावल आव भरी पाँद उघूँदानी तिकिसिद नो भरिरास प़ाइँए पोंखारिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","हाःत ज़ यायुँ माचाव दाद पावललाई लाप्‍द, माइँ दाद प़ाइँ ज़ घर्केर। ");
INSERT INTO kjl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","‘जे ङाङाः फरी रँःव दैन्‍या जेमाले’ है ओल्‍योए, होए ज़ प़ाइँरानी यायुँ माचाव जैद ओरायो। हाःत ज़ पावललाई ऱी जहाजक पै सारैनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","गे नोरास भाःसिद पावलस ऱी जहाजल पसिद एकसब्‍द्या कोस तापुदा गेबाके। हो पराःती रोदस तापुल गेबाके। नकिन पतारा सहरल केस्‍द, ");
INSERT INTO kjl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","फोनिके खन्‍ददा बान्‍या ऱी जहाजलाई दैद होल ज़ गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","साइप्रस तापु रैंःन्‍याक केस्‍द, तापुकिन दखिनलाव घ्याँ बाद सिरिया खन्‍द पै सिधा गेबाके। नो जहाजलाव मालसामान हाइन्‍याए जूँनी तुरोस सहरल ज़ गेथकनिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","नलाव यायुँ हुबोरास दैसिनाद नोरास सात दिन गेलिके। नाः भरिल नोराए परमेस्‍वरए उपुरूसनी पावललाई, “यरूसलेमदा बान्‍या माःक,” है दाव ज़ यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","है यादोज़्‍यावत ब जहाज बान्‍या बेला ओतावत गे ननी पुलुस्‍द फरी गेबाके। नोर खेपा मेंमार याज़ारास ज़ गेलाई सहरनी जहाजक पै सारैसिहुकेर। समुन्‍द्र छ्योक गेघूँदानी तिकिसिद पोंखारिद, ");
INSERT INTO kjl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","प़ाइँलाई जेरो दाद जहाजल गेपसिके। नोर ओल्‍द याझ़िमदा बाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","है जैद तुरोसनी तोलेमाइस सहरल बाद नलाव यायुँ हुबोरास दैसिद, तरी नोरास गेलिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","नकिन हो पराःती फरी जहाजल बाद कैसरिया सहरल केस्‍द जहाजतिन हाइसिद नो सात जनारासकाव परमेस्‍वरए ओपाँ सथैज़्‍याव फिलिपए उझ़िमक बाद नोस ज़ गेलिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","नोए ओज़ार चार जना रे मादोताव मेंमार यालिज़्‍याव। नोर प़ाइँ परमेस्‍वरए उपुरूसनी पाँज़्यावर यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","फिलिपस गेल्‍यो स़ोंला चार दिन गेतावत तोबो अगाबस यादोज़्‍याव अगमबक्ता यहूदिया खन्‍दनी गेस दैसिहुद, ");
INSERT INTO kjl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","पावलए ओवाँःफो बैद ओल ज़ उखँ उकुइर किद, “छैंव पुरूसए है लिज़्‍या, ‘यरूसलेमलाव यहूदीराए आव वाँःफोए ओर्गेलाई अइ जैद किद, छुत जातलावरालाई सूँपिरिज़्‍यार,’ ” है लिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","नोए ओपाँ थैद, पावललाई, “यरूसलेमदा ताबानी,” है लिद गे स़ोनो नलाव यायुँ हुबोराए है दाव ज़ गेनैके। ");
INSERT INTO kjl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","खाली पावलए झन, “जे काता जेजैसिज़्‍याव इताव, घर्द्याद नदा बान्‍या ङायुँ केःद जेयाँज़्‍याव? ङा किसिन्‍या वाज़ माःक, यरूसलेमल बाद प्रभु येसुए उमिनत सिन्‍या ब तयार ज़ ङालिज़्‍या,” है दासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","है जैद गे कै जैद ब गेमासभैंःधुवए, ‘परमेस्‍वरए उयुँ ज़ ओताक’ लिद च़िम गेदोके। ");
INSERT INTO kjl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","हुकिन ते गे भरी झाःसिद यरूसलेमदा बान्‍या गेथूसिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरियालाव यायुँ हुबोर मनी तोबो ऩेब्‍लो गेस ज़ बाद यरूसलेमदा मनासोनए उझ़िमक पै लाँसिकेर। नो मिँ साइप्रसनी हुव, ङ़ादाकिन येसुए ओपाँत हुव मिँ ज़ ओल्‍यो। है जैद नोए ओल्‍योक गेबासिके। ");
INSERT INTO kjl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","यरूसलेमलाव यायुँ हुबोराए गेलाई रँःद खुसी ताद चावस ज़ सुम्सिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","हो पराःती गे पावलस याकूबए ल्योदा गेदैसिनाके। मन्दलीलाव स़ेरर मनी याकूबए ल्योक दुप्‍सिद यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","पावलए नोरालाई जेरो दाद, परमेस्‍वरए ओय़ेननी ज़ छुत जातलाव मिँरालाई याक्‍याँताव ओदोव भरी तोबो तोबोनी है दाद यासथैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","नो पाँ थैद नोर परमेस्‍वरए ल्‍योदा बनै खुसी ताद धन्‍याबाद चरैःकेर। नकिन पावललाई, “भाइ, यहूदी जातलाव मिँराए मनी हजारका हजारए ज़ येसुए ओपाँत यायुँ हुप्‍के। खाली नोराए मोसाए ओकानुन ब बनै सघ्‍योःज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","नँ नजूँनी ब थैद नैर। ख्वा ख्वाराए नँलाई, ‘पावलए मोसाए ओपाँकिन तँदा जैसिद छुत देसल लिज़्याव यहूदीरालाई याचलन भरी ऱासो परींद याज़ारालाई मनी ‘क्‍याल्‍न्‍या सरेस जेमाराजैदी ब ताए’ है यादोज़्‍याव दी,’ है दींज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","गे कै लिन्‍या ओताव? अब ते ‘हुके दी’ लिन्‍या ब थैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","है जैद अइ जैव ताके — गेसकाव चार जना मिँराए मोसाए ओकानुन मितावनी किर्‍या झाःद नैर। ");
INSERT INTO kjl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","पुजारीराए ल्‍योक चोखोइसिद याचेम एन्‍न्‍या वाज़ बाँखी लिज़्‍या। है जैद नँ नोरास बाद यास ज़ चोखोइसिद नलाव खर्च भरी नँ ज़ फो·व ताके। हो ताकिन नो याथैव पाँ भरी ‘माथ॰रिउ ची ओल्‍यो’ है लिन्‍या लेर। ‘मोसाए ओकानुन ब ओदोज़्‍याव ओल्‍यो’ लिन्‍या ब सैंन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","खाली छुत जातलाव यायुँ हुबोराए दान्‍या य़ेन ते आव ज़ थ·रैद सर्द गेनै — अङग्‍यालाई चरैःसिउ ज़्‍यावर माज़्यान्‍या, झी माज़्यान्‍या, ओधें फर्लेद सैःसिउ स्‍याकरी माकैन्‍या, पातर्‍या पातर्नी ब माजैसिन्‍या,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","है जैद हो पराःती पावलए नो चार जना मिँरालाई ध्‍यान झ़िमक लाँद नोरास चोखोइसिद, ‘सात दिनत किर्‍या खेम्‍द मार ब चरैःन्‍या गेले’ लिद भकल दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","नो सात दिन ओयो·नावत एसिया खन्‍दनी हुव यहूदीराए पावललाई ध्‍यान झ़िमल रँःद नकाव मिँरालाई मचैद, पावललाई क्‍योःद, ");
INSERT INTO kjl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“अ इस्राएली गेदाज्‍यु भाइर, चाँदो हुचिके। आकाव मिँए संसार भरी दुलिद गेजातलाई सज़िम्‍द, मोसाए ओकानुनलाव पाँलाई ख्याद, ध्‍यान झ़िमए उमिन ब बले·द्यासिज़्‍याव। झन ग्रीक मिँरालाई ध्‍यान झ़िमल रैद चोखो गेपो ब छुद्यासिक्‍यो,” है दाद यारामचैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","नोर ङ़ादा सहरल त्रोफिमस यादोज़्‍याव एफिससलाव मिँलाई पावलस यारँःवए, ‘ध्‍यान झ़िमल मनी रैद नैज़्‍याखेहो’ लिन्‍या यासम्जिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","है जैद सहरलाव मिँर बनै ज़ मचिद प़ाइँनी ज़ धोंःहुद, पावललाई क्‍योःद, ध्‍यान झ़िमनी स़ेल्‍द, य़ामर गल्केर। ");
INSERT INTO kjl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","नोलाई सैःव यापैंज़्याक ज़ नकाव रोमी सेनापतीए ‘यरूसलेम भरी बनै खैलानी बैला ताके दी’ लिन्‍या थैद, ");
INSERT INTO kjl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","हतप्‍त ज़ सिपाईंर स़ोनो कप्‍तानरालाई लाँद नो मचिज़्‍यावराए ल्‍योदा धोंःनाकेर। नो माहोल्‍याराए नोर याहुज़्‍याव रँःद पावललाई प़ोन्‍या च़िम दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","हाःत ज़ नो सेनापतीए पावललाई क्‍योःद ऩेब्‍लो साँगलए किव परींद, माहोल्‍यारालाई, ‘आव मिँ सु ओताव, काता य़ेन ओदोव?’ है लिद ओरासुधिक ते, ");
INSERT INTO kjl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ख्वाराए ‘आव ज़’, ख्वाराए ‘हो ज़’ लिद बनै राउँनी झ्याउँ लिकेर। सुए यापाँ ब ओमाथ·रैधुवए उसिपाईंरालाई पावललाई थानाक लाँव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","थानालाव थप्‍काक याकेसोत माहोल्‍यार यारिसए बनै ज़ याछुइसिहुवए सिपाईंराए पावललाई छींद लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","नो माहोल्‍यार थानाक पै याछीं याछीं ज़ हुद, “आवलाई खदम ज़ ख्यान्‍या,” है लिद बनै ज़ क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","हाःत ज़ पावललाई थानाल लाँव यापैंज़्‍याक, पावलए सेनापतीलाई, “ङा नँस तोबो पाँव ङादैक,” है ओदोक ते, नो सेनापतीए, “नँ ग्रीक पाँ कातानी नसैंव? ");
INSERT INTO kjl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ङा ते नँलाई छुत ची है ङाल्‍यो। नँ नो तालाङाव सरकारकिन तँदा जैसिद चार हजार गुन्‍दारालाई मचैज़्‍याव इजिपी माःक रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पावलए, “ङा हो माःक। ङा ते किलिकियालाव तार्सस सहरल जर्मिउ यहूदी ची। नो पो बनै उमिन थासो, छ्याल्‍ल्‍यु सहर ब माःक। नँस ङाबिन्‍ती तोबो लिज़्‍या — आव माहोल्‍यारास तखेप पाँव ङादैक,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","नो सेनापतीए पावललाई भैंःदिक्‍यो। पावल थप्‍कात च्‍याँःसिद, ‘च़िम दोचिके’ लिद उकुइए सान दाद याएक्‍यो। प़ाइँ च़िम यादोवत पावलए हिब्रू खामनी अइ लिद पाँके, ");
INSERT INTO kjl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“अ ङादाज्‍यु भाइर, ङास़ेरर, ङा ङापाँ ब तखेप थैद्याँचिके,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","हिब्रू खामनी ओपाँज़्‍याव थैद माहोल्‍यार झन ज़ चाप चुप ताकेर। ");
INSERT INTO kjl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","है जैद पावलए, “ङा यहूदी जातलाव मिँ ज़, किलिकियालाव तार्सस सहरल ङाजर्मिउ। ननी सरिद आल यरूसलेमल ङाङासिके। गमलिएलए उसिस ब ताद, गेजिज्‍यु बाज्‍युकिनकाव हुव चलन भरी माबिरैद ज़ पैसिद, जे माँःती परमेस्‍वरए ल्‍योदा बनै ध्‍यावना ङादोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","येसुए ओपाँत बाज़्‍याव खेपा मेंमार यामासिवा पै याखिरी पसिद, ख्‍वा ख्‍वारालाई क्‍योःद झ्यालखानाल ब ङाराझाःके। ");
INSERT INTO kjl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","अछादी प्रधान पुजारी स़ोनो घ्योःव कचरीलाव स़ेररालाई यारासुधिचिके, याज़ सैंज़्‍यार। तछा नोराए ल्‍योनी दमस्‍कसलाव यहूदी दाज्‍यु भाइराए यामिनताव चिथील नलाव यायुँ हुबोरालाई मनी क्‍योःद सजा यान्‍याए जूँनी यरूसलेमदा किद रैन्‍या हक दैद नदा ज़ ङाबाके। ");
INSERT INTO kjl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“येमत ङाबाज़्‍याक अधमर लाक दमस्‍कस ङाकेस्‍नाक, उमँःजानी बनै मी झीःन्‍या ज़गै नमतिन हुद ङाल्‍योक बनै म्‍याल्‍याकनी मिलिक ताके। ");
INSERT INTO kjl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","हाःत ज़ नामक ङाधलिउत, कातानी तोबो गा अइ लिद ओपाँज़्‍याव ङाथैके, ‘अ साऊल, अ साऊल, नँ काराव ङाखिरी नपसिज़्‍याव?’ है ओदाँक ते, ");
INSERT INTO kjl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘नँ सु प्रभु?’ है ङादोके। नो गा फरी हुद, ‘ङा नो ङाखिरी नपसिज़्‍याव नासरतलाव येसु ज़’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","नो ङास बाज़्‍याव ङानैंराए ते ज़गै वाज़ रँःकेर, ङास पाँज़्‍याव गा ते माथ·रैधुकेर। ");
INSERT INTO kjl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","हाःत ज़, ‘ङा काता य़ेन दान्‍या, प्रभु?’ है ङादोक ते, ‘नँ सोद दमस्‍कसल बान्‍केदा, नङ ज़ नँ दान्‍या य़ेन भरी थैन्‍या नले,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","नो ज़गैए ङालाई अन्‍दनी मुन्‍द ओजैनावए ङानैंराए ङाकुइनी दोरैद दमस्‍कसल लाँनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“नल तोबो हननिया यादोज़्‍याव मोसाए ओकानुन माबिरैद दाज़्याव धर्मी मिँ उलिज़्‍याव। नलाव यहूदीराए नोलाई बनै चाव थ·रैद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","नो मिँ ङाल्‍योक हुद, ‘अ भाइ साऊल, नमी ओरैंःक,’ है ओदाँव प़ाइँना ङामी फैसिद रँःधुन्‍या ङाताके। ");
INSERT INTO kjl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“हाःत ज़ नोए, ‘गेजिज्‍यु बाज्‍युकिनकाव गेपरमेस्‍वरए नँलाई उयुँलाव मिताव पाँर सतैंन्‍या जूँनी खतैद नैनिउ। छैंव ओज़ा नल्‍योक सरैंःद्याद, ओर्गा थैन्‍या ब जैनिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","है जैद आव नरँःव नथैव भरित प़ाइँ मिँराए ङ़ाक येसुए ओसाची तान्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","है जैद मातेन्‍सिद ज़ नँ आख सोद नपापलाई छेन्‍याए जूँनी येसुए उमिन हाइद ऱील सछैंसिन्‍के,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“नकिन छींनी यरूसलेमदा ओल्‍द बाद, तछा ध्‍यान झ़िमल ङापोंखारिज़्‍याक ज़ नल झजल्‍किद, येसुलाई ङारँःके। ");
INSERT INTO kjl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","नोए, ‘नँ चाँदो ज़ घल्‍सिद, यरूसलेमनी हाइसिद बान्‍के। आल ङाजूँनी नराएज़्याव गोहाई भैंःन्‍या मालेर,’ है ओदाँक ते, ");
INSERT INTO kjl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ङा फरी, ‘काराव प्रभु? याज़ सैंज़्‍यार — ङा यासकाव ताद धर्मसास्‍त्र झ़िम झ़िमक बाद नपाँ दोज़्‍याव भरिरालाई साप्‍द क्‍योःद कैताक प़ोद झ्यालखानाल ब ङाराझाःज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","नसाची स्‍तिफनसलाई लुँए झेःद यासैःव बेलाक ङा मनी नोरास खैद नक च्‍याँःसिद नो झेःज़्‍यावराए याक्‍वार समारिद ङाराएज़्‍याव,’ है ङादोके। ");
INSERT INTO kjl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“हाःत ज़ येसुए, ‘नँ घबानी। तादा तादाङ लिज़्‍याव छुत जातलाव मिँराए ल्‍योदा ङापरींनिरिज़्‍या,’ है दाँक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","नो माहोल्‍याराए नाःपै पावलए ओपाँ चावस ज़ थैकेर। खाली छुत जातराए यामिन ओहाइव प़ाइँना माहोल्‍यार बनै मचिद, “निताव मिँलाई काताए उजूँनी नैन्‍या? बुरू सैःकिन पाथ लिज़्‍या,” है लिद, ");
INSERT INTO kjl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","याक्वार सिउःद ख्याद, धुइरो ब सिमे सिमे नमदा ख्याद बनै क़िकेर। ");
INSERT INTO kjl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","है जैद सेनापतीए उसिपाईंरालाई पावललाई थानाल लाँव परींद, “काताए जूँनी नाः याक़िज़्‍याव? आवलाई रीःद खोले·व ताके, कसा मापाँए,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","पावललाई किद रीःव यापैंज़्‍याक, नकाव च्‍याँःसिद लिज़्‍याव कप्‍तानलाई पावलए, “ङा रोमी नागरिकलाई ङागल्‍ती माथ·रैद अइज़ रीःन्‍या ओताज़्‍याव रो?” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","नो कप्‍तानए नो पाँ थैद सेनापतीलाई, “कै जैन्‍या नपैंज़्याव? आव मिँ ते रोमी नागरिक ची ओल्‍यो, नमासैंए रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","नो सेनापती पावलए ल्‍योक बाद, “साचो नँ रोमी नागरिक रो?” है ओदोक ते, “ङा रोमी नागरिक ज़,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","नकिन नो सेनापतीए, “ङा कुधु पैसार फो·द वाज़ नागरिक ङाताके,” है ओदोक ते, पावलए, “ङा ते रोमी नागरिक ज़ ङाजर्मिउ ची,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","हाःत ज़ पावललाई खोले·ना हुवर नो पाँ थैद याछींदा तेन्सिकेर। सेनापती मनी, ‘अऩाकल ज़ रोमी नागरिकलाई ची ङाकिउ ओल्‍यो’ लिद छे·के। ");
INSERT INTO kjl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","हो पराःती नो सेनापतीए पावललाई पला·द, ‘यहूदीराए काराव आवलाई खत यालैज़्याव’ लिद थ·रैन्‍याए जूँनी मुख्या पुजारीर स़ोनो घ्योःव कचरीलाव मिँरालाई दुप्‍द, पावललाई याङ़ाक सच्‍याँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पावलए नो कचरीलाव मिँराए ल्‍योदा भाल्‍सिद अइ लिद जवाप याएक्‍यो, “दाज्‍यु भाइर, ङा आःपै परमेस्‍वरए ओङ़ाक छैंव युँस ज़ ङालिज़्‍या,” है ओरादोव प़ाइँना, ");
INSERT INTO kjl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","प्रधान पुजारी हननियाए नकाव च्‍याँःसिद लिज़्‍यावरालाई पावलए ओयाःत लफरैव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","हाःत ज़ पावलए उरिस चोद, “ए पाखात वाज़ चाव जैसिज़्‍याव, नँलाई तछा परमेस्‍वरए लफरैनिरिज़्‍याव। नँ मोसाए ओकानुननी फाल्‍न्‍या जैसिज़्‍यावए कै जैद नो कानुनलाई उल्‍तैद ङालाई प़ोव नरापरींज़्‍याव?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","नकाव च्‍याँःसिद लिज़्‍यावराए, “नँ कै जैद नाःल्‍दिउ परमेस्‍वरनी खतैसिउ प्रधान पुजारीस याः नदोज़्‍याव?” है यादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पावलए, “दाज्‍यु भाइर, नो प्रधान पुजारी ओल्‍यो लिन्‍या ङा ङामासैंए। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, ‘राज्‍या चलैज़्‍याव घेप्‍पाराए याङ़ैत माचाव पाँन्‍या माताए।’ ” ");
INSERT INTO kjl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","नो घ्योःव कचरील तभा सदुकी दललावर, तभा फरिसीर यालिज़्‍याव सैंद, याङ़ाक च्‍याँःसिद प़ाइँलाई, “अ दाज्‍यु भाइर, ङा फरिसीए ओज़ा फरिसी ज़। ङा, ‘सिद मनी अजम्‍बरी जुनीए आस लिज़्‍या,’ है ङालिज़्‍यावनी ज़ आछिमकाव मुद्दाल ङापरिके,” ");
INSERT INTO kjl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","है ओरादोव प़ाइँना नलाव सदुकीर स़ोनो फरिसीर या या माखैद बनै खर्लेसिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","सदुकीराए ते, ‘अजम्‍बरी जुनी ब माले, परमेस्‍वरए ओचाकर्‍यार ब मालेर, पुरूसर ब मालेर’ है यालिज़्‍याव। फरिसीराए फरी, ‘कै जैद ओमालिज़्‍याव? नो भरी लिज़्‍या ज़’ है यालिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","है जैद नोर बनै राउँनी झ्याउँ जैद, फरिसीरासकाव यासास्‍त्रीर च्‍याँःसिद बनै रसिद, “आवए माचाव काता दाद ओनैज़्‍याव? है उलिज़्‍याव मिताव परमेस्‍वरए ओचाकर्‍या कितर परमेस्‍वरए उपुरूस हुद ओलस ज़ ओपाँव ताक्‍या,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","है जैद या याज़ माखैद झन ज़ मचिनाद पावललाई हो ज़ स़ेल्‍न्‍या, हो ज़ छुइन्‍या जैकेर। निताव रँःद नो सेनापतीए सैःर्‍या लिद छे·द उसिपाईंरालाई पावललाई करस ज़ पले·व परींद थानाक लाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","हो छ्याम रील ज़ प्रभु पावलए ओङ़ाक सरैंःसिद, “नयुँ तासतेयो, नयुँ होलाँ ओताक। किताव आल यरूसलेमल ङासाची जैसिद ङापाँ नरासथैव, हिताव ज़ रोमल मनी ङासाची नतानारिज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","हो पराःती छकाल्‍न्‍या यहूदीर दुप्‍सिद पावललाई सैःन्‍या बुद्धी कलैद, “नोलाई गेमासैःवा पै ज़्‍यान्‍या ब गेमाज़्‍यु, ओन्‍या ब गेमाओ,” लिद किर्‍या ब झाःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","निताव किर्‍या झाःज़्यावर चालीसकिन यादा ज़ याल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","नोर मुख्या पुजारीर स़ोनो स़ेरराए ल्‍योक बाद, “गे भरी पावललाई गेमासैःवा पै काता ज़ ज़्‍यान्‍या गेमाले लिद किर्‍या झाःद गेनै। ");
INSERT INTO kjl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","है जैद जे घ्योःव कचरी दाव जैसिद, सेनापतीए ल्‍योदा ‘पावललाई चावस फाल्‍न्‍याए जूँनी आदा रैके’ लिद था परींव ताके। हो बेलाक ज़ गे येमक वैंसिद नोलाई गेसैःरिज़्‍या,” है दाद सल्‍ला याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","हाः बेलाक पावलए ओभान्‍जए यासल्‍ला भरी थैद, थानाक बाद ओबागे पावललाई है दोनाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पावलए फरी कप्‍तानलाई खुल्‍द, “आव छोर्‍यालाई सेनापतीए ल्‍योक लाँद्याव ताके, होस तोबो पाँ पाँरिज़्‍या दी,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","नोए नो छोर्‍यालाई सेनापतीए ल्‍योक लाँद, “आवए ओपाँ तोबो लिज़्‍या दी। कैदी पावलए ङालाई नल्‍योक सारैव परींनाक्‍यो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","नो सेनापतीए नो छोर्‍यालाई उकुइनी क्‍योःद तँदा अलगज़ा लाँद, “काराव, ङालाई है दाँके,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","नकिन नो छोर्‍याए, “पराःती यहूदीर घ्योःव कचरी दाव जैसिद, ‘पावललाई चावस फाल्‍न्‍याए जूँनी आदा रैके’ लिद नँस बिन्‍ती दोरिज़्यार दी। ");
INSERT INTO kjl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","खाली नँ नोराए यापाँ ताभैंःनी। चालीसकिन यादाङाव मिँर पावललाई सैःन्‍या लिद येमक वैंसिद लेर। नोराए, ‘पावललाई गेमासैःवा पै ज़्‍यान्‍या ब गेमाज़्‍यु, ओन्‍या ब गेमाओ,’ लिद किर्‍या झाःद नैर। नँ नपाँलाई वाज़ कींद नैर,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","नो सेनापतीए, “आव पाँर ङालाई है नदाँव सुलाई ज़ है तारादोयो,” है दाद नो छोर्‍यालाई उझ़िमदा परींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","नो सेनापतीए ऩेब्‍लो कप्‍ताननिलाई खुल्‍द, “पते रील नौ बजेवाक, जिन पावललाई कैसरियादा लाँन्‍याए जूँनी खँनी बान्‍या सिपाईंर ऩेसय, घोरा चेप्‍द बान्‍यार सत्तरी स़ोनो ज़लरास बान्‍यार ऩेसय जना तयार याराजैचिन्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","पावललाई मनी घोरात जोगोइद हाकिम फेलिक्‍सए ल्‍योदा पाथस सारैव ताके,” है निदोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","नो सेनापतीए फरी, हाकिमए ल्‍योदा तोबो चिथी अइ लिद सर्द परींक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ङा क्‍लौदियस लुसियसए ङाल्‍योनी, नँ माननिय हाकिम फेलिक्‍सलाई जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","आव नल्‍योदा ङापरींज़्‍याव मिँलाई यहूदीराए क्‍योःद सैःव यापैंज़्‍याव। रोमी नागरिक ज़ ओल्‍यो लिन्‍या सैंद ङा ङासिपाईंरास बाद नोलाई ङाजोगोइके। ");
INSERT INTO kjl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ओगल्‍ती काता ओताव लिद थ·रैन्‍याए जूँनी यहूदीराए घ्योःव याकचरील ब ङालाँके। ");
INSERT INTO kjl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","नल याधर्मए उजूँनी वाज़ यामाखैज़्‍याव ओल्‍यो लिन्‍या ङाथ·रैके। नोलाई झ्यालखानाल झाःन्‍या स़ोनो सैःन्‍या सजा स्‍यासो ते काता ज़ ङामादैके। ");
INSERT INTO kjl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","हितावत ब यहूदीराए नोलाई सैःन्‍या बुद्धी याकलैज़्‍याव ओल्‍यो। निताव ङासैंवत हतप्‍त ज़ नल्‍योदा ङापरींके। ओङ़ैत पाँज़्‍यावरालाई मनी, ‘जेमुद्दा कातार उलिकिन हाकिमए ल्‍योदा लाँचिके,’ लिद हुकुम ङाराएके। ङापाँ आःज़, जेरो।” ");
INSERT INTO kjl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","है जैद नो सेनापतीए है ओरादोव मिताव ज़ सिपाईंराए हो छ्याम रील ज़ पावललाई एन्‍तिपात्रिस सहरक पै लाँकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","हो पराःतीकिन नो खँनी बाज़्‍यावर ओल्‍द, घोरा चेप्‍द बाज़्‍यावरालाई वाज़ पावलस यारापरींकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","नो घोरा चेप्‍द बाज़्यावर कैसरियाल केस्‍द हाकिमलाई चिथी बुझैद पावललाई मनी बुझैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","है जैद नो हाकिमए नो चिथी प़रिद, पावलए उजिल्‍ला सुधिद किलिकियालाव ओल्‍यो लिन्‍या सैंद, ");
INSERT INTO kjl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","पावललाई, “नजगर्‍यार मनी याहुवत आव नमुद्दा ङाथैया,” है दाद पावललाई हेरोदए ओदरबारल नैव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिन ओतावत प्रधान पुजारी हननिया तोबो ऩेब्‍लो यहूदीराए यास़ेररास कैसरियाल हुद, हाकिमए ल्‍योक बाद पावलए उजूँनी उजुर दोनाकेर। नोरास तोबो तर्तुल्‍लस यादोज़्‍याव वकिल ब रैद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","है जैद मुद्दा चलैद पावललाई यारैवत तर्तुल्‍लसए अइ लिद पाँके, “माननिय फेलिक्‍स ज्‍यू, नँ गेपोङाव हाकिम ताद, नदयानी गेदेस बनैद नयासिउए गे प़ाइँङावरालाई बनै सन्‍च ताद फाबिउ ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","होए उजूँनी गे प़ाइँनी ज़ नगुनर मामेंःद मानिउ ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","खाली आछिम नर्च्‍या मासैःद गेल्‍योदा दया दाद आव तोबो ज़िम्‍ज़ा गेपाँ वाज़ थैद नयासिकिन ताखेहो है गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","खास गेपाँ आव ज़ — आकाव नल्‍योक रैद यानैज़्‍याव मिँ ते बनै नाल क़्याव माचाव मिँ लिज़्‍या। नासरी दललाव यागुर्बा ताद संसार भरिल दुलिद यहूदीरालाई बनै ज़ यामचैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ध्‍यान झ़िमलाई झन झुथो जैव ओपैंज़्‍याक बल्‍ल गेक्‍योःके। मोसाए ओकानुननी गे ज़ फालो गेपैंक ते, ");
INSERT INTO kjl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","कप्‍तान लुसियस हुद झन नोलाई गेल्‍योनी जबरज्‍यास्‍ती नैंद, ");
INSERT INTO kjl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","गे ओजगर्‍यारालाई मनी नँ नल्‍योदा हुव परींसिक्‍यो। है जैद आवलाई नबिचारिक उजुर गेदोव पाँ भरी साचो ज़ ओल्‍यो लिन्‍या थ·रैन्‍या नले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","नोस हुव यहूदीराए मनी ओपाँ जोर्दिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","हाःत ज़ हाकिमए पावललाई सान दाद ओएक ते पावलए अइ लिद पाँके, “माननिय हाकिम, नँ आव राज्‍याल कुधु बर्सकिन ज़ मिँरालाई नराफाल्‍ज़्‍यावए ङा नङ़ाक ङायुँ हुप्‍द ज़ ङापाँज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ङा यरूसलेमदा परमेस्‍वरए ओध्‍यान दाना ङाबाव आछिम बाह्र दिन वाज़ ताके। आव ङापाँ साचो सैं माःक नँ ज़ थ·रैधुन्‍या नले। ");
INSERT INTO kjl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","नाः भरिल ङाकिन तँदाङावराए ना ङा सुरास ध्‍यान झ़िमल ङाखर्लेसिज़्याव यारँःनाव, ना धर्मसास्‍त्र झ़िमराल ना सहरल मिँरालाई ङारामचैज़्याव यारँःनाव। ");
INSERT INTO kjl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","है जैद आव ङाङ़ैताव झाःव यापैंज़्‍याव पाँर काता ज़ थ॰रिन्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","खाली आव तोबो भन्‍या हैज़, गेजिज्‍यु बाज्‍युकिनकाव ओसेवा गेदोहुज़्‍याव परमेस्‍वरलाई ङा मनी साःरो येमनी ओसेवा ङादोज़्‍या। आवराए झन ‘तँनिकाव येम’ है दाँज़्‍यार। है यादाँदी ब मोसाए ओकानुन स़ोनो अगमबक्ताराए यासरो पाँ भरित ङायुँ हुप्‍ज़्या। ");
INSERT INTO kjl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","आवराए यादोज़्‍याव मिताव ङा मनी ‘तछा चाव माचाव दाज़्याव प़ाइँ मिँर परमेस्‍वरए ओङ़ाक च्‍याँःसिरिज़्‍यार,’ है लिद परमेस्‍वरए ल्‍योदा आस ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","है जैद नो पाँर चेतैद ङा परमेस्‍वरए ओङ़ाक स़ोनो मिँराए याङ़ाक छैंव युँस दान्‍या वाज़ धामा ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“है जैद ङा छुत देस जीदा ऩेरिम स़ोंरिम भरी दुलिद, ‘ङादेसलाव दुखिरालाई सघैद परमेस्‍वरलाई मनी भिती चरैःन्‍या’ लिद फरी यरूसलेमल ङाहुके। ");
INSERT INTO kjl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","होए उजूँनी ध्‍यान झ़िमल ङालिज़्‍याव बेलाक यहूदीराए दैनाकेर। हो बेलाक ज़ भर चोखोइसिद ङालिज़्‍याव, ध्‍यान झ़िमल खैलानी बैला ब काता ज़ ओमालिज़्‍याव। हाःत ज़ एसिया खन्दनी हुव यहूदीराए ङालाई सरेस्‍द नलाव मिँरालाई यारामचैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","नोराए ङाङ़ैत झाःन्‍या पाँ कातार ओल्‍यो ताकिन नोर याज़ आछिम हुद उजुर दाव परिन्‍या ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","अथबा, यहूदीराए घ्योःव याकचरील काता ङागल्‍तीर यादैव ताकिन आकाव हुद लिज़्‍यावराए ओपाँरक ते। ");
INSERT INTO kjl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","सैं नो कचरीलाव सिउनी सैंसिन्‍याए जूँनी ङापाँवनी आछिमकाव मुद्दा याचलैज़्‍याव ओताव?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","हाःत ज़ नो हाकिम फेलिक्‍सए नाः थैद, “ङा आव जेपाँ भरी कप्‍तान लुसियस उहुवत ङाबिचारिया,” है दाद भाःसिउ यापरींक्‍यो। ओल ते उपुर्कावराकिन येसुए ओपाँ सर्बा ज़ ओसैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","है जैद नोए पावललाई गुन्‍याए जूँनी सिपाईंराए याकमान्‍दरए उजिम्‍बाल नैद, “आवलाई जाँ आदा होदा ल्‍यो ब यान्‍या, दैसिना हुज़्‍याव ओनैंरालाई मनी तारावैंयो,” है लिद हुकुम एक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ऩेला स़ोंलावात फेलिक्‍स, यहूदी ओज्‍या द्रसिल्‍लास हुद, येसु ख्रीसनिकाव येम किताव उलिज़्‍याव लिद चावस थैन्‍याए जूँनी पावललाई खुल्‍द पलासो परींक्यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","है जैद पावलए ओअर्थ भरी पलास्‍द्याद, परमेस्‍वरए उयुँलाव मिताव य़ेन दान्‍या, तहस लिन्‍या, स़ोनो परमेस्‍वरनिकाव फाल्‍न्‍या छ्यामए उजूँनी उनिसथैवत, फेलिक्‍सए उयुँल बनै छे·द, “आछिम नाःत ज़ नैकेदा बान्‍के। बुरू तछा फरी ङाधाःक ङाकिन्‍यादा नसथैना,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","हाःकिन, ‘पावलए ओल्‍योनी घुस ब ङादैए सैं’ लिद पावललाई घरी पाला ज़ खुल्‍द सिप सिप ज़ निपाँज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ऩेरिम ओतावत फेलिक्‍सए ओपाला त़ोसिद तोबो पर्किअस फेस्‍तस हाकिम ताके। फेलिक्‍सए ते नो य़ेन ओऱास्‍क यहूदीरालाई खुसी जैन्‍याए जूँनी पावललाई माऱास्‍द कैतल ज़ नैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","साःरो हाकिम फेस्‍तस यहूदिया खन्दल उहुव स़ोंला ओतावत कैसरियानी पुलुस्‍द यरूसलेमदा बाके। ");
INSERT INTO kjl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","यरूसलेम ओकेसोत नलाव मुख्या पुजारीर स़ोनो यहूदीराए याघेप्‍पाराए पावलए ओङ़ैताव याझाःव पाँर सम्‍जैद, ");
INSERT INTO kjl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","‘यरूसलेमल सारैन्‍या’ लिद बिन्‍ती दोकेर। नोर खास येमत वैंसिद सैःन्‍या बुद्धी कलैद यानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्‍तसए नोराए यापाँ भैंःद मायाद, “पावललाई कैसरियाल थुनाल थुनैद नैर, ङा मनी जाँवाक नदा ज़ ङाबारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","है जैद जे नोए उजूँनी जेपाँ कातार उलिकिन तोबो ऩेब्‍लो जेस़ेररालाई ङास ज़ बान्‍या यारापरींच्‍यो। होए ओगल्‍ती कातार उलिकिन नोराए ज़ उजुर दोर्‍या,” है लिद यासम्‍जैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","हाकिम यरूसलेमल ओल्‍यो आथ दस दिन ओतावत कैसरियादा ओल्‍द बाके। ओकेसो हो पराःती अदालतल बाद पावललाई रैव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पावल अदालतल उहुवत, यरूसलेमनी हुव यहूदीर प़ाइँ ओल्‍योक गुरिगाँ जैसिद घ्योःव घ्योःव माथ॰रिउ पाँर ओङ़ैत झाःदिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पावलए नोरालाई जवाप याद हाकिमलाई, “ङा यहूदीराए याकानुनलाई तादी ब, ध्‍यान झ़िमलाई तादी ब, माहाराजालाई तादी ब, काता ज़ बले·द ङामाराएए,” लिद है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","फेस्‍तसए यहूदीरालाई ओल्‍योदा जैन्‍याए जूँनी पावललाई, “हुकी नँ यरूसलेमदा बान्‍केदा आव पाँर होङ ज़ फसेला ङाजैया, कै ताके?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पावलए, “ङा सरकारए अदालत ङ़ाक ज़ ङालिज़्या, आल ज़ फाल्‍सिउ परिए। यहूदीरालाई ते काता ज़ बले·द ङामाराएए है ङाल्‍यो ते नँ ज़ नसैंज़्‍याखेहो सानी। ");
INSERT INTO kjl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ङा माचाव य़ेन दाद, ङालाई सैःन्‍या मिताव गल्‍ती कातार उलिकिन ते थिक ज़, ङालाई जेसैःनादी ब ताए ज़। खाली आवराए ङाङ़ैताव झाःद यायाँज़्‍याव पाँर ओमाथ॰रिउ ताकिन नँ ङालाई याल्‍योदा सूँपिन्‍या नहक ब माले। है जैद ङा आख ज़ माहाराजाए ल्‍योदा बिन्‍ती दान्‍या ङापैंज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","हाःत ज़ फेस्‍तसए ओलसकाव सल्‍ला याज़्यावरास जलफल दाद पावललाई, “नँ माहाराजाए ल्‍योदा बिन्‍ती दान्‍या नपैंव प़ाइँना नदा ज़ बान्‍या नले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ऩेला स़ोंला ओतावत तोबो अग्रिपास राजा ओबैंनी बरनिकीस कैसरियाल फेस्‍तसस दैसिना हुकिनी। ");
INSERT INTO kjl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","नोनी सर्बा कुधु दिन नल लिन्‍या बिचार निदोवए हाकिम फेस्‍तसए पावलए उजूँनी राजा अग्रिपासस सल्‍ला दाद, “ङाकिन ङ़ादाङाव हाकिम फेलिक्‍सए तोबो कैदीलाई ङा ङाजिम्‍बाल ख्यानैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ङा तछा यरूसलेमल ङालिज़्‍याव बेलाक नलाव मुख्या पुजारीर स़ोनो यहूदीराए यास़ेरर ङाल्‍योक हुद नोए ओङ़ैत ओखत पले·द्याद होक ज़ सजा ब याव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ङा फरी नोरालाई, ‘रोमी कानुननी बादी पर्तीनी जोरन जैद, नो पर्तीवालाए ओङ़ैत झाःद यायो पाँ भरिए ओजवाप याव ओमादैवा पै नोलाई अइज़ सूँपिन्‍या माताए,’ है ङारादोके। ");
INSERT INTO kjl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","है जैद नो मुद्दा याज़्‍यावर आल ज़ हुकेर। धिलो मादाद हो पराःती ङा कचरी जैद पावललाई मनी अदालतल रैव ङारापरींके। ");
INSERT INTO kjl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","नोर च्‍याँःसिद ओङ़ैत झाःद यापाँक ङा बनै अचम्‍ब ङाताके। अपराधी मिताव य़ेन ते काता ज़ ङामाङम्‍सिके। ");
INSERT INTO kjl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","अइज़ याधर्म रोक मेक ओतावए यामाखैज़्‍याव ओल्‍यो। तोबो सिउ येसु यादोज़्‍यावए उजूँनी पावलए ‘जींदो ज़ लिज़्‍या’ है ओरादोवनी बनै यारसिउ ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ङा याधर्मलाव पाँ जाँ मासैंद कातानी फाल्‍न्‍या ओताव लिद पावललाई, ‘आव पाँर फाल्‍न्‍याए जूँनी नँ यरूसलेमदा नमाबाके?’ है ङादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पावलए झन, ‘ङा नदा ङामाबा, बुरू आव पाँर फाल्‍न्‍याए जूँनी माहाराजाए ल्‍योदा ङामाबावा पै आल ज़ ङालिरिज़्‍या,’ है लिके। है जैद ङा नोलाई माहाराजाए ल्‍योदा परींन्‍या मौका ओमाहुवा पै आल ज़ ङानैज़्‍या,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","अग्रिपासए नो भरी थैद, “ङा मनी नोए ओपाँ तखेप थैव ङादैक,” है ओदोक ते, फेस्‍तसए, “ताए, नोए ओपाँ पराःती ज़ नथैया,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","हो पराःती अग्रिपास स़ोनो बरनिकी बनै तह महौ जैसिद, सेनापतीर स़ोनो सहरलाव घेप्‍पारास सिप ज़ कचरी दान्‍या महलल हुकेर। प़ाइँ यादुप्‍सिउत फेस्‍तसए उसिपाईंरालाई पावललाई रैव यापरींक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","हाःत ज़ फेस्‍तसए प़ाइँलाई, “राजा अग्रिपास स़ोनो आल हुद लिज़्‍यावर, आव ङापाँ थैचिके। आव जेङ़ाकाव च्‍याँःसिद लिज़्‍याव मिँए उजूँनी यरूसलेमलाव यहूदीर स़ोनो आलाव यहूदीर बनै रसिद ङाल्‍योक हुद, सैःन्‍या सजा याव यापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","आवलाई ङाबिचारिक फरी सैःन्‍या सजा यान्‍या स्‍यासो ते काता ज़ ङामादैके। हाःत ज़ माहाराजाए ल्‍योदा बिन्‍ती दान्‍या ओपैंवए नदा ज़ परींन्‍या ङाथ·रैके। ");
INSERT INTO kjl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","खाली नदा ङापरींकिन माहाराजालाई आवए उजूँनी सर्द्यान्‍या मिताव पाँर ते काता ज़ माले। है जैद आछिम जे भरिए जेङ़ाक स़ोनो खास ते नँ राजा अग्रिपासए नङ़ाक आव मिँलाई सच्‍याँद ङानै, कसा आवए उजूँनी तोबो ऩेब्‍लो सर्न्‍या पाँर मापुलुस्‍रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","म़ानी नाःल्‍दिउ राजाए ल्‍योदा बिनु गल्‍ती कै जैद परींन्‍या?” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","हाःत ज़ राजा अग्रिपासए पावललाई, “नपाँ काता उलिज़्‍याव, पाँनिके,” है ओदोक ते, पावलए उकुइए सान दाद अइ लिद जवाप एक्‍यो, ");
INSERT INTO kjl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ङालाई यहूदीराए ङाङ़ैत झाःद यायाँव खतए ओजवाप नँ राजा अग्रिपासए नङ़ाक पाँव ङादैवए, ङा आछिम बनै ङाभागी ल्‍यो ज़ ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","नँ यहूदी चलन भरी बनै सैंन्‍या मिँ ज़ नलिज़्‍या। है जैद आछिम पै ङालाई सहिद ङापाँ भरी चावस थैयो लिद बिन्‍ती ङाचरैःनिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ङा ङाजर्मिउ पो स़ोनो यरूसलेम सहरल यहूदी जातलावराए याखार्ल ज़ ङाघ्योःके। है जैद यहूदी भरी प़ाइँए ज़ ज़िम्ज़ाकिन ङादोहुज़्‍याव य़ेनर चावस सैंज़्यार। ");
INSERT INTO kjl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","हाः बेलाक फरिसी ब ङाजैसिके। गेधर्म मानिज़्‍याव भरिरानी फरिसीराकिन कर्रा सु ज़ मालेर। है जैद ङालाई नो य़ेनत ङ़ादाकिन ज़ सरेस्‍द नैनार। नो पाँए उजूँनी है यालिकिन है लिधुन्‍या ज़ लेर। ");
INSERT INTO kjl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","नोराए झन आछिम ङा ‘गेसाखा पुर्खारालाई परमेस्‍वरए ओरायो य़ाका सयो·द्यासिक्‍यो’ है ङारादोवनी ज़ ङालाई सजा याव पैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","नो य़ाकाए उजूँनी ज़ गेमीं बाह्र थरलाव मिँराए आस दाद लाकनी रील ध्‍यान दाद खिमो ज़ नैज़्‍यार। अ राजा, ङा नो खिमो ज़ यानैज़्‍यावलाई थ·रैद ङारायोनी ज़ यहूदीराए माभैंःद आछिम नल्‍योक रैद नैनार। ");
INSERT INTO kjl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","‘परमेस्‍वरए सिउरालाई यासोचोइज़्याव’ है ङालिज़्याव पाँत कै जैद अचम्‍ब ताद जेमापतिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ङा मनी ङ़ादा नासरतलाव येसुए उमिन बनै सोद ओपाँलाई जुनी ब वैंव ङापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","है जैद यरूसलेमल नोए उउपर्त बनै धामा दाद, मुख्या पुजारीराए ल्‍योनी क्‍योःन्‍या हक रैद येसुए छैंव उमीं कुधुरालाई झ्यालखानाल ब ङाराझाःके। सैःन्‍या याथ·रैक ङा मनी ‘हैज़’ लिद यापाँ जोर्द ङाराएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","कैताक धर्मसास्‍त्र झ़िम झ़िमक बाद नोरालाई दुख याद, कसा माऱास्‍र लिद कर ब ङारालैज़्‍याव। ङारिस बनै माचाव ओतावए छुत देसलाव सहर जीदा मनी दुलिद नोरालाई सापे सापे याखिरी ङापसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“अ राजा, तछा निताव य़ेनए जूँनी मुख्या पुजारीराए ल्‍योनी हक रैद दमस्‍कसदा ङाबाज़्‍याव बेलाक, ");
INSERT INTO kjl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","अधमर लाक निमीकिन ब ओझ़ार ल्‍यो ज़गै नमतिन हुद, ङानैंरास गेल्‍योक म्‍याल्‍याकनी मिलिक रैंःहुके। ");
INSERT INTO kjl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","गे भरी प़ाइँ नामक गेधलिउत तोबो गा हिब्रू खामनी ङास, ‘अ साऊल, अ साऊल, नँ काराव ङाखिरी नपसिज़्‍याव? नँ सैंज़्‍यावत ब ज़पत लातए थेंद ननैज़्‍याव मिताव ज़ नलिज़्‍या,’ है ओदाँक ते, ");
INSERT INTO kjl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ङा, ‘नँ सु प्रभु?’ है ङादोके। प्रभुए फरी, ‘ङा नो ङाखिरी नपसिज़्‍याव येसु ज़। ");
INSERT INTO kjl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","नँ सोद च्‍याँःसिन्‍केदा, ङा नँलाई ङानोकोर जैन्‍याए जूँनी आछिम नल्‍योक ङासरैंःसिके। आछिम ङालाई नरँःनावए नँ ङासाची ताद, छींनी सतैंद ङाईंरिज़्‍याव पाँए ओसाची ब नतारिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","यहूदीराए ल्‍योदा स़ोनो छुत जातलावराए ल्‍योदा ङापरींनिक नोराए ल्‍योनी ङाजोगोइनिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","नँ होरालाई ङापाँ सथैद यामी फैद्यान्‍या नले। चुम चुमो सैतानए ओराज्‍यानी पले·द, ओज़गै ल्‍यो परमेस्‍वरए ओराज्‍याल लाँन्‍या नले। हुनी ज़ नोर ङालाई यायुँ हुप्‍द यापापर क्‍याल्‍सिद, परमेस्‍वरस खैवरास स्‍वर्गताव बताहा दैन्‍याकावर तान्‍या लेर,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“है जैद, राजा अग्रिपास, ङा नो नमतिन हुव पाँकिन तँदा माबाद, ");
INSERT INTO kjl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","दमस्‍कसल येसुए ओपाँ सथैन्‍यात ङाथूसिके। नकिन यरूसलेमलावर, यहूदिया खन्‍द जीदाङावर, स़ोनो छुत जातलावराए याल्‍योदा मनी बाद, ‘जेपापलाई ऱास्‍द, परमेस्‍वरए ल्‍योदा जेयुँ फर्कैद, साचो हो मिताव य़ेन ब दोव ताके,’ लिद सथैव ज़ ङारानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","होए उजूँनी ज़ ङा ध्‍यान झ़िमल ङालिज़्‍याव बेलाक यहूदीराए ङालाई क्‍योःद सैःव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","खाली परमेस्‍वरए ङालाई पाथस ओनैनावए आछिम पै घेप्‍पा ज़िम्‍ज़ारालाई ओसाची याव ज़ ङालिज़्‍या। नो ङापाँल मोसा स़ोनो अगमबक्ताराए, ‘इताव इताव तारिज़्‍या’ है याल्‍यो पाँकिन ङा छुत काता ज़ चरैःद ङामापाँए। ");
INSERT INTO kjl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","होराए पाला, ‘ख्रीस दुखर सहिद, सिउनी सैंसिउ प़ाइँरानी ङ़ात ताद, यहूदीर स़ोनो छुत जातलाव मिँरालाई अजम्‍बरी जुनील बान्‍या येम सतैंद याएरिज़्‍याव,’ है लिद मिँरालाई यारासथैकेर।” ");
INSERT INTO kjl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","पावल निताव ओपाँज़्‍याक ज़ फेस्‍तस बनै चोइस क़िद, “पावल, नँ दासानी बिसा ताद नले। कुधु प़रिद चबनै बूलिउ स्‍यासो नताके,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पावलए, “माननिय फेस्‍तस ज्‍यू, ङा बूलिउ माःक। साचो थ॰रिउ पाँ ज़ ङापाँज़्‍याव ची। ");
INSERT INTO kjl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","आव पाँ भरी राजा अग्रिपासए मनी सैंज़्‍याखेहो लिद ओङ़ाक ङायुँ हुप्‍द ज़ ङापाँज़्‍या। आव म़ोंसिउलाव पाँ स्‍यासो ते माःक। है जैद ‘ओमासैंव ब काता ज़ मालिखेहो’ लिद ङायुँ हुप्‍द ले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","राजा अग्रिपासलाई मनी, “अ राजा, अगमबक्ताराए यासरो पाँ नमापतिज़्‍या? नपतिज़्‍याखेहो,” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अग्रिपासए, “आव छ्यावा नपाँए ङालाई ब ख्रीस्‍त्‍यान जैव नपैंज़्‍याव रो?” है ओदोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पावलए फरी, “परमेस्‍वरए ओङ़ाक ङाबिन्‍ती आव ज़ लिज़्‍या — छ्यावानी तादी ब, कुधुनी तादी ब, जे आछिमकाव ङापाँ थैज़्‍याव भरिए, ङालाई सुर्सिउ साँगलराकिन बाहेक, ङा स्‍यासो जेताकिन ताखेहो है ङालिज़्‍या,” है यादोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","हाःत ज़ राजा अग्रिपास, हाकिम फेस्‍तस, बरनिकी स़ोनो यास च़ुसिद लिज़्‍याव भरी च्‍याँःसिद लाँःदा पुलुस्‍द, ");
INSERT INTO kjl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","या या पाँसिद, “साचो ज़ ओल्‍यो, आवलाई सैःन्‍या सजा अथबा झ्यालखानाल झाःन्‍या सजा यान्‍या स्‍यासो ते माले,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","नकिन राजा अग्रिपासए फेस्‍तसलाई, “आव मिँए माहाराजाए ल्‍योदा बिन्‍ती दान्‍या ओमापैंव ताकिन गे नोलाई ऱास्‍न्‍या गेल्‍यो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","पावललाई इतालिया देसदा लाँन्‍या याथ·रैवत छुत कैदीरास माहाराजाए ओफौजीलाव कप्‍तान युलियस यादोज़्‍यावए ओपासल ज़ झाःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","है जैद गे तोबो एद्रामितेनोस सहरनी हुव एसियालाव समुन्‍द्र छ्योकाव पो पोक बाज़्‍याव ऱी जहाजल पसिद गेबाके। गेस माकेदोनिया खन्‍दलाव थेसलोनिके सहरनी हुव तोबो अरिस्‍तार्खस ब उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","गेबाव हो पराःती सीदोन सहरल केस्‍द जाँवा पै गेलिके। युलियसए पावललाई दया दाद, “ननैंरास दैसिद नचाहिन्‍यार होराए ल्‍योनी रैयो,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","नकिन फरी ऱी जहाजल गेबाक गेङ़ानी बतास उहुवए, साइप्रस तापुए बतास ओथोरोलाव घ्याँ गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","नकिन किलिकिया स़ोनो पामफिलिया खन्‍द ङ़ाकाव घ्‍योःव समुन्‍द्रलाव घ्याँ बाद, लुकिया खन्‍दलाव माइरा सहरङ केस्‍द, नो ङ़ादाङाव जहाजनी झरिद, ");
INSERT INTO kjl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","गेसकाव कप्‍तानए तोबो अलेक्‍जेन्‍द्रिया सहरनी हुव इतालियादा बाज़्‍याव जहाज दैद नल झाःसिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","नो जहाजल मनी, बतास गेङ़ानी हुद कुधु दिनत बल्‍ल क्‍नीदस सहर नजिकक गेकेस्‍के। हुकिन होदा, गे बाव गेपैंज़्‍याव येमदा बतासए बाव ओमायासिउए फरी क्रेत तापुए बतास ओथोर्ज़्‍याव सालमोने यादोज़्याव पोलाव घ्याँ गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","नकिन बनै ज़ धो धो तापु छ्यो छ्यो बाद लासिया सहर लापकाव ‘चाव बन्‍दरगाह’ यादोज़्‍याव जहाज थकनैन्‍या पोल गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","नक पै केस्‍न्‍या कुधु दिन गेझाःधुवए ज़्‍यूँःव साहा हुनाद उलिज़्याव। नो साहाक बतास दाद समुन्‍द्रल बान्‍या बनै ओछ्यास ल्‍यो ओताज़्‍याव। है जैद पावलए नो जहाज चलैज़्यावरालाई, ");
INSERT INTO kjl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“अ ङादाज्‍यु भाइर, गे आथ पाला गेबाकिन जहाजलाव सामानर स़ोनो जहाजलाई मनी कुधु नोक्‍सान तारिज़्‍या। गेजिउलाई मनी ओछ्यास ल्‍यो ज़ लिज़्‍या,” है ओरादोज़्‍यावत ब, ");
INSERT INTO kjl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","नोए ओपाँ कप्‍तानए काता माँःती माङम्‍सिद, बुरू जहाजए ओर्गे स़ोनो जहाज चलैज़्‍यावनी निपाँ कोसै भैंःके। ");
INSERT INTO kjl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","हो स़ोनो ज़्‍यूँःव साहाक नो जहाज थकनैन्‍या पोल लिन्‍या जाँ माज़्‍यासो उलिज़्‍यावए नो जहाजत बाज़्‍यावर जाँकोसैए नो क्रेत तापुत छ्यावा होकसैकाव फोनिक्‍स सहरदा बान्‍या जैकेर। नो सहर दखिन-पछ्युँ स़ोनो उतर-पछ्युँदा फर्किउ जहाज नैन्‍या पो थुमो उलिज़्‍यावए य़ुँदा भरी नक ज़ लिन्‍या थ·रैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","हाःत ज़ दखिन त॰नी बनै चाव बतास स॰ स॰ हुद जहाज चलैज़्‍यावराए ‘अब ते गेकेस्‍या’ लिद नो जहाजलाई अदैज़्‍याव झँए साँगललाई ऱीनी स़ेल्‍द क्रेत तापु छ्यो छ्यो ज़ गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","हाःत ज़ उमँःजानी उतर त॰निकाव तापुनी ल्‍यो माल्‍यो बतास गेतर्त हुद, ");
INSERT INTO kjl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जहाजलाई आदानी होदा ख्याक्‍यो। बतास त॰दा गेमालाँधुवए जहाजलाई गेऱास्‍क, बतासए झन समुन्‍द्र माँजल ज़ लाँसिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","बल्‍ल बतासलाई जाँ थोर्ज़्‍याव क्‍लौदा यादोज़्‍याव ज़िम्‍ज़ा तापु छींक गेकेस्‍नाक जहाजए ओर्मेःताव सुर्सिउ आदा होदा लिन्‍या दोङ्गालाई स़ेल्‍द बनै दुखस छींद जहाजल गेझाःके। ");
INSERT INTO kjl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","‘ऱीए जहाजलाई मनी सुफुवा’ लिद घेप्‍पा तारए बनै ज़ कस्‍कैकेर। लिबिया छ्योकाव उर्जीं माल्‍यो बगरल गैन्‍या ओछ्यास ओतावए नो जहाजलाई स़ेल्‍ज़्‍याव क्‍वार सतेद्याद बतासए ओभरत ज़ ऱास्‍केर। ");
INSERT INTO kjl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","हो पराःती आँधीए जहाजलाई पा·वा पा·वा ओजैवए जहाजलाव सामानर ब हाइद ऱील याराख्याकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","हुकिनकाव हो पराःती जहाजए ओजार ब याराख्याकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","कुधु दिन पै आँधी बाबत ताद निमी सोरोर ब यामारैंःज़्‍यावए, ‘गेमारहिके ब’ लिद गेयुँर स्‍यासे गेसतेके। ");
INSERT INTO kjl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ज़्‍यावर गेमाज़्‍युव कुधु दिन ओतावत पावल प़ाइँए ङ़ाक च्‍याँःसिद, “अ ङादाज्‍यु भाइर, ङा जेलाई है ङादाचिउ पाँर भैंःद क्रेत तापु जेमाऱासो ताकिन आः नोक्‍सान तान्‍या ओमाल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","हैदी ब जेयुँ स्‍यासे तासतेच्‍यो — जहाज वाज़ खदम तारिज़्या, गे मिँर ते सु ज़ सिन्‍या गेमाले। ");
INSERT INTO kjl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","आछ्या रील ओसेवा ङादोज़्‍याव ङापरमेस्‍वरए ओचाकर्‍या ङाल्‍योक सरैंःसिद, ");
INSERT INTO kjl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘पावल, ताछे·नी। नँ जुनी ब माहाराजाए ओङ़ाक नच्‍याँःसिरिज़्‍या। नँस बाज़्‍याव ननैंर मनी परमेस्‍वरए ओदयानी बाँचिरिज़्‍यार,’ है दाँक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","है जैद ङानैंर, जेयुँ होलाँ जैचिके। परमेस्‍वरए है ओदाँव मिताव जुनी ब तान्‍या ज़ ले लिद ङायुँ हुबो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","खाली गे तोबो तापुत उर्जीं माल्‍योल गर्न्‍या गेले,” है दासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","बतास ओदोव चौध रात ओतावत एद्रियास समुन्‍द्रल बतासए गेजहाजलाई आदा होदा उहुतैनाज़्याव। आधा रील ऱी छ्योदा गेहुव मिताव ङम्‍सिद जहाज चलैज़्‍यावराए, ");
INSERT INTO kjl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","‘उर्जीं खा उलिज़्‍याव’ लिद यागोइँक चालीस मितर ताके। नकिन जाँ होकसैकावक फरी यागोइँक तीस मितर ताके। ");
INSERT INTO kjl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","‘जहाज घ्‍योःव घ्‍योःव पहर जीदा थुकिसिया’ लिन्‍या छ्यासए जहाज अदैन्‍या झँए साँगलर ओर्मेःतिन चारता यारासतेकेर। हाःकिन ‘नम खर्क सँके’ लिद कींद ज़ गेझाःके। ");
INSERT INTO kjl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","हाःत ज़ नो जहाज चलैज़्‍यावराए धोंःन्‍या निउँ तोबो जैद, ‘जहाजए उसुनी धूँलाव झँर मनी पला·द सतेव ताके’ लिद नो आदा होदा लिन्‍या ज़िम्‍ज़ा दोङ्गालाई ऱील झरैकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","पावलए याचाल सैंद कप्‍तान स़ोनो सिपाईंरालाई, “आवर जहाजल गेस यामारहिकिन, गे भरी बाँचिन्‍या गेमाले,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","नो सिपाईंराए दोङ्गाए ओच़ेंर च़म्‍द बगैद याराएकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","नम उसँनाक पावलए प़ाइँलाई यायुँर सझेंःद्याद, “आछिम पै जेसोगोए काता ज़ माज़्‍याद जेल्‍यो चौध दिन जेताके। ");
INSERT INTO kjl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","है जैद आछिम जेर्सार सपरीन्‍याए जूँनी ज़्‍यावर ब ज़्‍युव ताके। गे सु ज़ मासिद तोबो गेम़ुल ब गलिन्या माले,” है दाद, ");
INSERT INTO kjl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","उकुइत भरेस रैद प़ाइँए याङ़ाक परमेस्‍वरलाई धन्‍याबाद चरैःद केःद ज़्‍युक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","हाःत ज़ उपुर्काव भरिए पाला यायुँ होलाँ जैद या मनी ज़्‍युकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","नो जहाजल लिज़्‍यावर, गे भरी प़ाइँ झाःद, ऩेसय छयहत्तर जना गेल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","है जैद गे भरी गेफू तसी ज़्‍याद, जहाजए उगुर सोबोम्‍न्‍याए जूँनी नो गेसय़ेलो गेदा भरी ऱील याराख्याकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","नम छेलाला उसँवत ‘आव काता पो ओताव?’ लिद सुए ज़ माथ·रैधुकेर। खाली तोबोक ओधाँद माल्‍यो छेरारा·व पो रँःद ‘गेधुवा पै जहाजलाई नङ ज़ लाँव ताके’ है लिद, ");
INSERT INTO kjl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","नो जहाजलाई अदैज़्‍याव सतेसिउ झँए साँगलर च़म्‍द ऱील ज़ ख्यानैद, जहाजए ओङ़ै आदा होदा दल्‍कैज़्‍याव दाबीलाई मनी चलैन्‍याए जूँनी पला·केर। नकिन बतासए फुलैद जहाजलाई स़ेल्‍ज़्‍याव क्‍वार तङ्गैद नो छेरारा·व पोदा यालाँज़्‍यावत ज़, ");
INSERT INTO kjl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ऱी जींलाव बालुवा बोर्सिउत त़ोल्‍द जहाज होल ज़ गैके। ओङ़ै बनै चोइस उतूँसिउए कै जैद ब माहाइधुकेर। उछींनीकाव ऱीए छल्‍काए जहाजलाई बनै प़ोद पा·नाक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","हाःत ज़ सिपाईंराए, ‘आलाव कैदीर हाइसिद धोंःर्‍या’ लिद सैःव पैंकेर। ");
INSERT INTO kjl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","खाली कप्‍तानए पावललाई जोगोइव ओपैंज़्‍याव। है जैद नोरालाई भैंःद मायाद, “जे ऱील चेल्‍न्‍या सैंज़्‍यावर ङ़ादा ऱील ज़ो·द पाखादा पुलुसचिके। ");
INSERT INTO kjl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","चेल्‍न्‍या मासैंज़्‍याव भरी जहाजलाव फल्‍यार, काता कातार हाइद नत ज़ बाचिके,” है लिद याअर्थैक्‍यो। है जैद तोबो ब कै मै माताद ज़ प़ाइँ पाखात गेपुलुस्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","गे भरी कैज़ माताद पाखात गेपुलुसो प़ाइँना ‘आव तापुए उमिन माल्‍ता ची ओल्‍यो’ लिन्‍या गेसैंके। ");
INSERT INTO kjl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","नकाव लिज़्‍याव मिँराए गेलाई रँःद यायुँ नाद दया दासिकेर। नम फाइ फाइनी फुइ फुइ जैद बनै उज़्‍यूँःवए मेंःर दाद्यासिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पावलए सीं तकर रैद मेंःल ओझाःक मेंःए ओघम्‍काए घुल तोबो पुलुस्‍द पावलए उकुइ दा·दिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","नो तापुताव मिँराए उकुइत घुल उझुन्‍दिउ रँःद, “ओहो! आव मिँ ते ज्‍यानमारा ज़ ओल्‍यो ताखेहो। नाःल्‍दिउ ऱीनी उजुगिदी ब न्‍यायनी ते बाँचिउ मादैक्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","खाली पावलए उकुइ फरैद घुललाई मेंःल ख्याक्‍यो, ओल ते कैज़ माताके। ");
INSERT INTO kjl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","तापुताव मिँराए ते, ‘जुनी ब गोद सिए’ लिद चिऊद यानैज़्‍याव। कुधु पै चिऊद ब कैज़ ओमातावए, हाःकिन “आव मिँ ते देवता ची ओल्‍यो,” है लिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","नो तापुताव याघेप्‍पा पब्लियसए ओएँःर उझ़िमर नजीदा ज़ यालिज़्‍याव। है जैद नोए गेलाई दया दाद स़ोंला पै बनै चावस ज़ नैसिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","नोए ओबाबु फू बान्‍या बेथाए ओजोरो हुद थलिद उलिज़्‍याव। पावलए नोलाई चिऊनाद परमेस्‍वरलाई पोंखारिद, ओक्‍याँत उकुइ नैद ओयोत, होक ज़ गराँके। ");
INSERT INTO kjl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","हाःकिन नो तापुताव मिँराए ‘पावलए अइ जैक्‍यो’ लिन्‍या थैद याजोरो हुवर प़ाइँ ओल्‍योक हुद यासगराँसिहुज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","है जैद गेलेवा भरी नो तापुताव मिँराए गेलाई बनै मानस ज़ नैद, गेबान्‍या छ्याम ओतावत येमताव गेज़्‍यावर ब झाःद्यासिकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","माल्‍ता तापुत स़ोंमैना गेतावत तोबो अलेक्‍जेन्‍द्रिया सहरनी हुव जहाजत गेबाके। नो जहाज य़ुँदा भरी नो तापुत नैसिउ उलिज़्‍याव, ओङ़ैत जोङोल्‍या देवता यादोज़्‍यावए ओअङग्‍या खुपिसिउ उलिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","माल्‍ताकिन सुराकुसाई सहरक बाद स़ोंला पै नक ज़ गेलिके। ");
INSERT INTO kjl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","नकिन फरी बाद इतालिया देसलाव रेगियन सहरल गेकेस्‍के। नल तछा गेतावत दखिन त॰नी बतास चलिद ऩेलात ज़ पतिओली सहरल गेकेस्‍के। ");
INSERT INTO kjl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","नो सहरल येसुए ओपाँत बाज़्‍यावरास गेदैसिक, नोराए ‘गेस ल्‍यो ताके’ है यादासिक ते नोरास तसाता पै गेलिके। नकिन बल्‍ल रोम सहरदा ज़ गेबाके। ");
INSERT INTO kjl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","रोमलाव यायुँ हुबोराए ‘हुज़्‍यार दी’ लिन्‍या थैद ख्वार अप्‍पियस बजारक पै, ख्वार तीन-भत्ती बजारक पै गेलाई च़िहुसिकेर। पावलए नोरालाई रँःद उयुँर होलाँ ताद परमेस्‍वरलाई धन्‍याबाद चरैःक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","रोम गेकेसोत पावललाई तोबो सिपाईंए ओपासल झ्यालखानाकिन अछतङ तोबो झ़िमल ल्‍यो एकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","पावल स़ोंला ओतावत नलाव यहूदीराए याघेप्‍पारालाई दुप्‍द अइ लिद यासथैक्‍यो, “अ ङादाज्‍यु भाइर, ङा गेजिज्‍यु बाज्‍युराए याचलन स़ोनो गेजातलाव मिँरालाई काता ज़ बले·द ङामाराएदी ब, यरूसलेमलाव यहूदीराए ङालाई क्‍योःद रोम सरकारए ल्‍योदा सूँपिनाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमीराए ङापाँ फाल्‍द ङालाई सैःन्‍या स्‍यासो काता ज़ मादैद ऱासो यापैंज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ङामीं यहूदी दाज्‍यु भाइराए याउपर्त काता खतर लैन्‍या पाँ ज़ ओमाल्‍यो, खाली यहूदीराए ते झन ङालाई ऱास्‍न्‍या पाँलाई यामाभैंःवए माहाराजाए ल्‍योदा बिन्‍ती दान्‍या कर ज़ लागिके। ");
INSERT INTO kjl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","खास ङा इस्राएलीराए आस दाद यानैज़्‍याव ख्रीसए उजूँनी है ङारादोवनी ज़ ङालाई इताव साँगलए किद नैनार। है जैद नो पाँर जेलाई है दान्‍याए जूँनी आछिम ङाखुल्‍चिउ,” है ओरादोक ते, ");
INSERT INTO kjl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","नोराए, “गे आःपै यहूदिया देसनी नँ नजूँनी काता चिथी ज़ गेमादैताए। ननी हुज़्‍याव गेमींराए यायाःनी ब नजूँनी माचाव काता ज़ गेमाथैताए। ");
INSERT INTO kjl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","खाली प़ाइँङ ज़ जे ख्रीस्‍त्‍यानराए जेजूँनी ‘आवराए यापाँ थिक माले’ है यालिज़्‍याव वाज़ गेथैज़्‍या। है जैद जेपाँ किताव उलिज़्‍याव, गे मनी तखेप थैव ताके,” है दोकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","है जैद ‘आव छ्याम दुप्‍सिउ ताके’ लिन्‍या याथ·रैव छ्याम यहूदीर पावलए उझ़िमक ओपाँ थैना काला मुलु हुकेर। हो छ्याम छकाल्‍न्‍याकिन ऱिमक पै पावलए नोरालाई परमेस्‍वरए ओराज्‍यालाव पाँर पलास्‍द्याद, मोसाए ओकानुन स़ोनो अगमबक्ताराए येसुए उजूँनी यासरो भरिनी थ·रैद्याद यायुँ सुहुप्‍द्यान्‍या धामा दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","नोर ख्वाराए ओपाँ चावस थैद नो पाँत यायुँ हुप्‍के, ख्वाराए ते माभैंःकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","है जैद या या माखैद ननी पुलुस्‍द याबाज़्‍याक पावलए आव तोबो पाँ याङ़ैत झाःद याएक्‍यो, “जेजिज्‍यु बाज्‍युरालाई छैंव पुरूसए है ओरादोव पाँ ते थिक ज़ ताद ले। नो पाँ यसैया अगमबक्ताए अइ लिद सर्द नैद यायो, ");
INSERT INTO kjl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘आव मिँरालाई है यादोनाके, थैन्‍या ते जेथैज़्‍या, जेमातीधुइ। रँःन्‍या ते जेरँःज़्‍या, जेमासरेस्‍धुइ। ");
INSERT INTO kjl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","आवराए यायुँ काता ज़ मातीधुन्‍या भुत्‍यासो ताद ले। यार्ना ब सूइसिउ मिताव ताद ले। यामी ब च़िम जैद यानैज़्‍याव मिताव लिज़्‍या। निताव यामाताव ताकिन आः झरी यामीए रँःधुखेरहो, यार्नाए थैधुखेरहो, यायुँल तीधुखेरहो। ङाल्‍योदा यायुँ फर्कैधुखेरहो। सोजोकावर ब ङाराजैधुखेहो।’ ");
INSERT INTO kjl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","है जैद आव ब सैंच्‍यो — आछिमकाव जेथैव परमेस्‍वरनिकाव हुव बाँचैन्‍या पाँर जेल्‍योङ मारहिद छुत जातलाव मिँराए ल्‍योदा बारिज़्‍या। नोराए ते झन थैन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","पावलए आव पाँ है ओरादोवत यहूदीर या या खर्लेसिद पुलुस्‍द बाकेर। ");
INSERT INTO kjl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पावल रोम सहरल झ़िमए किराया फो·द ऩेरिम भरी नल ज़ लिके। उझ़िमक हुज़्‍याव भरिरालाई चावस सुम्द, ");
INSERT INTO kjl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","परमेस्‍वरए ओराज्‍यालाव पाँर सथैद, घ्‍योःव युँस प्रभु येसु ख्रीसए उजूँनी ब पलास्‍द ओराएज़्‍याव। नो य़ेनत सुए ज़ यामावैंज़्‍याव।");
INSERT INTO kjl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ङा पावल, येसु ख्रीसए ओनोकोर, परमेस्‍वरए चाव ओथा सथैन्‍यात ओसाची खतैसिउ ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","नो चाव था परमेस्‍वरए ‘यान्‍या ङाले’ लिद अगमबक्ताराए यासरो धर्मसास्‍त्रल ङ़ादा ज़ य़ाका दाद ओनैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","नो पाँ ओज़ा येसु ख्रीसए उजूँनी ज़। नो दाऊदए ओथोल ज़ मिँ मिन्‍सिद जर्मिके। ");
INSERT INTO kjl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","फरी छैंव पुरूसए ओसक्तीए गेप्रभु येसु ख्रीसलाई सिउनी ओसोचोइवए परमेस्वरए ओज़ा ज़ थ॰रिके। ");
INSERT INTO kjl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","है जैद ङा गेप्रभुए उमिननी ज़ यहूदीराकिन छुत जातलाव मिँरालाई ओल ओपाँत उघुरिउर जैद, यायुँ सुहुप्‍द्यान्‍याए जूँनी नोए ओल्‍योनी ज़ असिकर दैद ओसाची तान्‍या हक ब दैद ङानै। ");
INSERT INTO kjl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","जे मनी येसु ख्रीसए उमींर तान्‍या खुल्सिउर जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","है जैद जे परमेस्वरए उयुँलाव मिताव रोमलाव छैंव उमींरालाई आव चिथी परींद ङायाचिज़्‍या। परमेस्‍वर गेबाबु स़ोनो गेप्रभु येसु ख्रीसनी जेल्‍योदा नियुँ गराँद जेयुँ होलाँ जैद ओयाचिरक। ");
INSERT INTO kjl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","प़ाइँरानी ङ़ात आव तोबो पाँ लिज़्‍या — जे परमेस्वरए ओपाँत जेयुँ जेसुहुबो संसार भरिल प़ाइँदा ज़ थास्‍द ले। है जैद ङा जेजूँनी परमेस्वरलाई पोंखारिद येसु ख्रीसनी धन्‍याबाद चरैःव ज़ ङानैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ओज़ाए ओय़ेनत बनै जाँगरस ओसेवा ङादोज़्‍याव परमेस्वरए ओङ़ाक जेलाई मनी खर्क ज़ ङामामेंःचिए। आव पाँत ओल ज़ साची लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","‘परमेस्वरए उयुँ ओताकिन ङा आथ पाला जेल्‍योदा हुव ङादैक’ लिद परमेस्वरलाई बिन्‍ती चरैःव ज़ ङानैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ङा जेल्‍योङ जेलाई थ॰रिउ जैन्‍याए जूँनी परमेस्वरनिकाव काता असिकर याव ङादैकिन ताखेहो लिद जेस दैसिन्‍या बनै युँ ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ङा जेल्‍योक हुद जेस दैसिउ ङादैकिन गे तखेप्‍त ज़ गेयुँर सझेंःसिन्‍या गेले — जे ङा ङाल्‍योनी, ङा जे जेल्‍योनी। ");
INSERT INTO kjl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","आव ब सैंच्‍यो ङानैं ङामेंर, ङा जेल्‍योदा कुधु पाला ज़ हुन्‍या ङापैंके, खाली काता काताराए माधाःद हुव ङामादैके। जेल्‍योङाव ङायुँ ते इताव ज़ ओल्‍यो — किताव पो पोङ छुत जातलाव मिँरालाई परमेस्वरए ल्‍योदा हुन्‍या ङाराजैके, हिताव ज़ जे जेल्‍योङ मनी तोबो ऩेब्‍लो ङाराजैधुकिन ताखेहो लिद बनै युँ ङादोज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ङा घेप्‍पा ज़िम्‍ज़ार, सैंवर मासैंवर, जो मितावरालाई तादी ब चाव था सथैन्‍या कर ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","है जैद ङा जे रोमल लिज़्‍यावरालाई मनी चाव था सथैन्‍या युँ ङादोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ङा ख्रीसए चाव ओथा सथैन्‍या ङालाज माहुइ। यहूदीर तादी ब, छुत जातलावर तादी ब आव पाँत यायुँ हुप्‍ज़्‍यावरालाई परमेस्वरनिकाव साःरो जुनी दैन्‍या सक्ती लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ननी ज़ परमेस्वरए मिँरालाई ओलस ओरासखैज़्‍याव येम ब सतैंसिउ लिज़्‍या। नो येम ओजरानी उतुपाङ पै गेयुँ गेसुहुबोनी वाज़ लिज़्‍या। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “उयुँ हुप्‍द परमेस्‍वरस खैव मिँ वाज़ बाँचिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","मिँराए यादोव पापत स़ोनो अधर्म यादोज़्‍याव य़ेन भरित परमेस्वरए ओसजा सरैंःसिउ लिज़्‍या। नोराए यायुँल माचाव वाज़ नैद परमेस्वरए साचो ओपाँलाई ब वैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","नोराए यायुँल परमेस्वरए उजूँनी ते ङ़ादाकिन ज़ सैंद यानैज़्‍याव, काराव ल्‍यो ताकिन ओल परमेस्वरए ज़ सतैंद नैद यायो। ");
INSERT INTO kjl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","परमेस्वरए आव संसार ओजैज़्‍यावकिन ज़ ‘ओगेर उगुनर स़ोनो खर्क ज़ माखेम्न्‍या ओसक्तीर आवर ज़’ लिन्‍या प़ाइँए ज़ सैंद नैर। ओललाई यामारँःधुदी ब ओदोज़्याव य़ेननी ज़ रैंःज़्‍या। है जैद सुलाई ज़ ‘आव भरी गेमासैंए’ लिन्‍या काता निउँ ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","हिताव सैंज़्‍यावत ब परमेस्वरलाई नैद्याव परिन्‍या मान ब नैद माएर, धन्‍याबाद ब माचरैःर। नोराए झन अऩाकलाव पाँर ससैद यायुँनी काता ज़ माहुन्‍या तानाकेर। ");
INSERT INTO kjl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","नोर, ‘गे बनै सैंन्‍यार गेलिज़्‍या’ है यालिज़्‍यावत ब काता ज़ मासैंन्‍यार ताकेर। ");
INSERT INTO kjl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","बनै ज़गै मगैव, उजिउँनी लिज़्‍याव, खर्क ज़ माखेम्‍ज़्‍याव परमेस्वरए ओपोल झन जै जन्‍तु, बाज़ा बिज़ा, ऱूइज़ा वान्‍ज़ा, मिँराए अङग्‍या जैद, नोराए यासेवा दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","है जैद परमेस्वरए ‘आवर कै जैद ब माताके’ लिद यामन लागिउ य़ेनदा ज़ याऱास्‍क्‍यो। हाःकिन नोर झन या याल युँ माजामो य़ेनर वाज़ दाद याइज्‍यात याज़ झाःज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","सैंज़्‍यावत ब परमेस्वरनिकाव साचो ओपाँलाई ऱास्‍द, होए ओपोल झन धुतनी ताव पाँलाई रैद, हो ज़ साचो जैकेर। एकम्‍न्‍या ओमान नैद्याव परिन्‍या प़ाइँ जैज़्‍याव परमेस्वरलाई माभैंःद ओसेवा ब मादाद, झन ओल ओराजैवराए यासेवा ज़ दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","है जैद परमेस्वरए नोरालाई लाज मोर्नो य़ेनदा ज़ याऱास्‍क्‍यो। ननी ज़ मेंमाराए मनी दाव परिन्‍या य़ेनलाई ऱास्‍द या याल युँ माजामो य़ेन ज़ दोनाकेर। ");
INSERT INTO kjl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","हो मिताव ज़ खेपाराए मनी मेंमारास माताद झन या याल ज़ यायुँ मानैधुद युँ माजामो य़ेनर ब दोनाकेर। नितावराए यापाप याक्‍याँत याज़ भुगिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","नोराए परमेस्वरए ओमान नैद्याव माभैंःद यायुँ बिप्‍यादा वाज़ याझाःवए परमेस्वरए नोरालाई ‘कुबानी याय़ेनदा ज़ घबाज़्‍यारक’ लिद बिप्‍यादा ज़ याऱास्‍क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","है जैद नोराए याय़ेन जम्‍मा माचाव वाज़ लिज़्‍या — युँनी कुबातैं हुन्‍या, लोभ दान्‍या, छुतलाई सोन्‍या, प़ाइँत ज़ मी तून्‍या, मिँ सैःन्‍या, इ़सिन्‍या, धुतैद ज़्‍यान्‍या, छुलैं पुलैं दान्‍या, अर्काए उछींनी पाँन्‍या, ");
INSERT INTO kjl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","अर्काए उमिन बले·द्यान्‍या, परमेस्वरलाई सोन्‍या, स॰द सँ सँनी बँ बँ लिन्‍या, सघ्योःसिन्‍या, माचाहिउ बुद्धी कलैन्‍या, बाबु आमाए ओपाँ माभैंःन्‍या, ");
INSERT INTO kjl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","पत मुर्ख जैसिन्‍या, सतत मालिन्‍या, युँ मानान्‍या, सुए ल्‍योदा ब युँ माजैन्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","निताव य़ेन दाज़्‍यावराए, ‘परमेस्वरए ओकानुननी सिन्‍या सजा ते दैव ज़ परिके’ लिन्‍या यासैंज़्‍यावत ब झन याजिउ नदा ज़ च्‍यो च्‍यो झाःज़्‍यार। छुत निताव य़ेन दोज़्‍यावरास मनी बनै रेंद यापाँ तप्‍द याराएज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","है जैद जे छुतलाई वाज़ ‘इताव हिताव’ है दाज़्‍यावर जेलाई मनी परमेस्वरए ओङ़ाक काता निउँ ज़ माले। जे नोरास जेय़ेन तोबो ज़ ओतावए नोराए यागल्‍ती थ·रैद जेराएक जे जेगल्‍ती ब जे ज़ जेथ·रैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","नितावराए याक्‍याँत परमेस्वरए ओसजा उहुरिज़्‍याव ते थिक ज़ है लिन्‍या गे गेसैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","हिताव ताकिन जे छुतए ओगल्‍ती थ·रैद जेएज़्‍याव य़ेन जे ब जेदोज़्‍याव ताकिन परमेस्वरए ओसजानी कातानी उस्‍किउ जेदैरिज़्‍याव? ");
INSERT INTO kjl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","सैं परमेस्वरए ओदयानी जेगल्‍ती भरी कुधु ज़ सहिद ओयाचिज़्‍यावए, ‘गेलाई कैज़ ओमाजैसिज़्‍याव ओल्‍यो’ है जेलिज़्‍याव रो? परमेस्वरए ओदया ते बुरू, ‘कसा ङाल्‍योदा यायुँ माफर्कैर’ लिद कींद नैचिज़्‍याव लिन्‍या जे जेमासैंज़्याव रो? ");
INSERT INTO kjl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","जे ते झन माचाव जेदिउदीए ओल्‍योदा जेयुँ फर्कैव जेमाभैंःवए, परमेस्वरए मिँरालाई न्‍यायस फाल्‍द ओसजा ओसतैंरिज़्‍याव छ्यामकावए जूँनी उरिस दुपो ज़ जेनैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेस्वरए हो छ्याम मिँरालाई सु सु यादोव मितावनी ज़ यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","चाव य़ेनत थ॰रिद ज़गै मगैवलाव माखेम्‍न्‍या जुनी खिम्‍ज़्‍यावरालाई अजम्‍बरी जुनी याएरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","फरी यालाई वाज़ तान्‍या खिम्‍द साचो पाँलाई माभैंःद माचाव य़ेन दाज़्‍यावराए याक्‍याँत परमेस्‍वरए उरिस थुद याएरिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","माचाव य़ेन दाज़्‍यावरालाई यहूदीर तादी ब, छुत जातलावर तादी ब बनै दुख तान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","चाव य़ेन दाज़्‍यावरालाई फरी, यहूदीर तादी ब, छुत जातलावर तादी ब असिक स़ोनो मान याद यायुँ ब होलाँ जैद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","परमेस्वरए मिँ रँःद मादोव, य़ेन रँःद दोज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","है जैद परमेस्वरए ओकानुन सैंदकाव पाप दोव भरी हो कानुननी ज़ फाल्‍सिरिज़्‍यार। परमेस्वरए ओकानुन मासैंदकाव पाप दोव भरिए बिनु कानुननी ज़ सजा दैरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","परमेस्वरए ओकानुन थैद वाज़ परमेस्वरए ओङ़ाक सु ज़ धर्मी माथ॰रिए। ओकानुन दाद वाज़ धर्मी थ॰रिन्‍या ताए। ");
INSERT INTO kjl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","परमेस्वरए ओकानुन मादैव छुत जातलाव मिँराए मनी परमेस्वरए ओकानुनलाव मिताव य़ेनर यायुँ स्‍यानी याज़ दान्‍या यासैंवए नोराए मनी तोबो कानुन यादैव मिताव ज़ ताद ले। ");
INSERT INTO kjl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","परमेस्वरए ओकानुन ते यायुँल ज़ सर्सिउ लिज़्‍या। है जैद याज़ यायुँल छाप छाप दाद, ‘आव ते चाव ज़ ङादोके, आव ते माचाव ची ङादोके’ लिन्‍या याज़ सैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","आव भरी परमेस्वरए मिँरालाई येसु ख्रीसनी ओराफाल्‍रिज़्‍याव छ्याम ज़ तारिज़्या। ङा ङारासथैज़्याव चाव था मिताव ज़, नो छ्याम यायुँलाव म़ोंसिउ पाँ भरी फाल्‍सिरिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","जे नलाव यहूदी तावर मोसाए ओकानुनत जेयुँ हुप्‍द, ‘परमेस्वरए गेलाई वाज़ चाव रँःसिज़्‍याव’ है ब जेलिज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","नो कानुननी फरी चाव माचाव सैंद, परमेस्वरए उयुँलाव मिताव दान्‍या य़ेनर ब जेसैंज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","‘यामी मारैंःवरालाई दोरैज़्यावर ब गे ज़, चुम चुमोल लिज़्‍यावरालाई पलाँ जैद्याज़्‍यावर ब गे ज़। ");
INSERT INTO kjl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","साचो पाँ स़ोनो सैंन्‍या भरिए ओथालन परमेस्वरए ओकानुनल गेदैवनी मुर्खरालाई गेरासुधारैज़्‍या, मासैंज़्‍यावरालाई गेरापैज़्‍या,’ है जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","है जैद जे छुतरालाई पैज़्‍यावर जे जेमापैसिज़्‍या नी? जे छुतरालाई ‘कुन्‍या माताए’ है दाज़्‍यावर जे जेमाकुज़्‍या नी? ");
INSERT INTO kjl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","जे ‘अर्काए ओज्‍याए ल्‍योदा बान्‍या माताए’ है दाज़्‍यावर जे जेमाबाज़्‍या नी? जे अङग्‍या पुजात जेयुँ माजाम्‍ज़्‍यावर मन्‍दिरलाव अङग्‍यार कुद जेमारायो·ज़्‍या नी? ");
INSERT INTO kjl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","जे मोसाए ओकानुन जेदैवनी सघ्योःसिज़्‍यावर नो कानुन माभैंःद परमेस्वरए उमिन जेमाबले·ज़्‍या नी? ");
INSERT INTO kjl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","जे मितावराए जेजूँनी धर्मसास्‍त्रल इताव ब सर्सिउ लिज़्‍या, ‘जे जेदोव हुनानी छुत जातलाव मिँराए खार्ल परमेस्वरए उमिन माचाव थ॰रिके।’ ");
INSERT INTO kjl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","है जैद नो कानुनलाव पाँ जेदोकिन वाज़ नो यहूदी जैसिन्‍या क्‍याल्‍न्‍या सरेस ओलेखा ल्‍यो लिज़्‍या। कानुनलाव पाँ जेमादोकिन ते नो सरेस जैसिद ब माजैसिउ स्‍यासोर जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","हो मिताव ज़ फरी, क्‍याल्‍न्‍या सरेस माजैसिउ छुत जातलाव मिँए कानुनलाव य़ेन ओदोकिन, नो मिँ सरेस माजैसिद ब जैसिउ स्‍यासो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","है जैद निताव क्‍याँताव सरेस माजैसिउ छुत जातलाव मिँए कानुनलाव य़ेन ओदोकिन, नोए ज़ झन जे मिताव सरेस जैसिउ यहूदी जातलाव कानुन सैंद ब मादोज़्‍याव मिँरालाई जेपाहा झाःद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","पाखातावए वाज़ साचो यहूदी तान्‍या माताए। हिताव ज़ सतैंन्‍याए जूँनी वाज़ क्‍याल्‍न्‍या सरेस जैसिउ ब साचो सरेस माःक। ");
INSERT INTO kjl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","साचो यहूदी तान्‍या युँल ज़ ताज़्‍या। साचो क्‍याल्‍न्‍या सरेस ब युँल ज़ ताज़्‍या। नो सरेस ते पाखाताव कानुननी माताए, छैंव पुरूसनी ज़ ताज़्‍या। निताव मिँ मिँराए ल्‍योनी ओमागनिसिदी ब परमेस्वरए ल्‍योनी ते गनिसिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","जे ते, ‘हो ची ताकिन्‍दा, गे यहूदी गेताव स़ोनो क्‍याल्‍न्‍या सरेस गेजैसिउ अऩाकलाव ज़ ची ओल्‍यो’ है जेलिज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","अऩाकलाव ते माले, ओलेखा ल्‍यो ज़ लिज़्‍या। प़ाइँरानी उस॰कताव आव ज़ — परमेस्वरए ओपाँर यहूदीराए यापासल ज़ नैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","नोर नो य़ाकाए ओसतत यामालिदी ब, यायुँ ओमाहुप्‍दी ब परमेस्वरलाई असतलाव माजैधुर। ");
INSERT INTO kjl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","मानुवाताव मिँ भरी ओपो·स ज़ असतलावर याथ॰रिदी ब, परमेस्वर ते सतलाव ज़ थ॰रिन्‍या ले। धर्मसास्‍त्रल मनी परमेस्वरए उजूँनी इताव सर्सिउ लिज़्‍या, “नपाँ भरिल नँ ज़ साचो थ॰रिन्‍या नले। नपाँलाई याफाल्‍दी ब नँ ज़ झेंःन्‍या नले।” ");
INSERT INTO kjl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ख्वा ख्वाराए ते मिँराए बिचार मितावनी है लिज़्‍याखेरहो, “माचाव गेय़ेननी परमेस्वरए ओय़ेन झन ज़ ओसत ल्‍यो ओरैंःकिन कातानी गेलाई नो य़ेनत सजा ओयासिरिज़्‍याव?” ");
INSERT INTO kjl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","निताव ते माताए। परमेस्वरए ननी ज़ अन्‍याय ओदोव उथ॰रिकिन, कै जैद आव मानुवाताव मिँरालाई याफालोके? ");
INSERT INTO kjl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ख्‍वा ख्‍वाराए फरी, “काता, गे माचाव गेय़ेनत परमेस्वरए उमिन झन ज़ ओघ्योःकिन काराव गेलाई पापी ओथ·रैसिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","हिताव ताकिन चाव घताक लिद प़ाइँए पाप ज़ गेदोया,” है लिज़्याखेरहो। हिताव ते माताए। गेमिन बले·द्याव पैंज़्‍याव ख्वा ख्वाराए ते झन हो ज़ थ·रैद्यासिज़्‍यार। नितावराए सजा दैन्‍या ते थिक ज़। ");
INSERT INTO kjl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","है जैद गे यहूदीर छुत जातलाव मिँराकिन चावर गेमाले। ङा है ङादाचिज़्‍याव मिताव यहूदीर तादी ब, छुत जातलावर तादी ब प़ाइँ पापल ज़ लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “परमेस्वरए ओङ़ाक धर्मी तोबो ब माले। ");
INSERT INTO kjl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","परमेस्वरए ओपाँ तीज़्‍याव ब सु ज़ माले। परमेस्वरलाई खिम्‍ज़्‍याव ब सु ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","प़ाइँ तँदा बाद काम मालागिउर ताद लेर। चाव य़ेन दाज़्‍यावर तोबो ब मालेर।” ");
INSERT INTO kjl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“नोराए याभोंकोरा घ्वाँःव खादर स्‍यासो लिज़्‍या। यापाँ ब धुत वाज़ लिज़्‍या।” “यायाःत घुलए ओधास स्‍यासो लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“यायाःनी हुज़्‍याव भरी गाल स़ोनो सराप वाज़ लिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“मिँ सैःन्‍यादा याखँ बनै गिल्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","जोङ बाद ब दुख यान्‍या वाज़ सैंज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","छुतस खैन्‍या येमदा खर्क ज़ माबार।” ");
INSERT INTO kjl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“परमेस्वरलाई रँःद ब माछे·र।” ");
INSERT INTO kjl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","जे ज़ जेसैंज़्या, जो कानुन तादी ब कानुन मादैवराए जूँनी ते माले, दैवराए जूँनी ज़ लिज़्‍या। है जैद मानुवाताव मिँ भरी परमेस्वरए ओङ़ाक पाँन्‍या येम ज़ माले, ओपो·स ज़ परमेस्वरए ओसजा दैन्‍यार ताद लेर। ");
INSERT INTO kjl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","कानुनलाव य़ेन दाद परमेस्वरए ओङ़ाक सु ज़ धर्मी थ॰रिन्‍या मालेर। नो कानुनए ओय़ेन ते गेपाप सतैंद्यान्‍या लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","गे मिँरालाई परमेस्वरए ओङ़ाक गेखत माल्‍यो धर्मी थ॰रिन्‍या साःरो येम सतैंसिउ लिज़्‍या। हो येम कानुनलाव य़ेन दान्‍यानी माःक। हैदी ब नो येम ङ़ादाकिन ज़ मोसाए ओकानुन स़ोनो अगमबक्ताराए यासरो भरिल सतैंसिउ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","नो येम आव ज़ — जोए येसु ख्रीसलाई उयुँ हुप्‍ज़्‍या, नो उयुँ उसुहुबोनी ज़ परमेस्वरए ओङ़ाक धर्मी थ॰रिज़्‍या। है जैद यहूदीरालाई तादी ब, छुत जातलावरालाई तादी ब, हुनी वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","काराव ल्‍यो ताकिन प़ाइँए ज़ पाप दाद परमेस्‍वरए ओज़गैनी अछत ताकेर। ");
INSERT INTO kjl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","है जैद परमेस्‍वरए उयुँ गराँद मिँरालाई ओज़ा येसु ख्रीसनी ओलस सखैन्‍याए जूँनी यासजानी अइज़ यापले·क्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ओज़ाए ओक्‍याँत यायुँ हुप्‍ज़्‍यावरालाई ओल परमेस्वरए ज़ यासजा भरी नोए उझीनी ज़ क्‍याल्‍द याएज़्‍याव। परमेस्वरए ओन्‍याय सतैंन्‍याए जूँनी येसु ख्रीस ओमाहुदकाव यादोव पाप भरी सहिद्याद ओज़ाए ओक्‍याँत ज़ सयो·द याएक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","आज्‍याल मनी ओज़ा येसुलाई यायुँ हुप्‍ज़्‍यावरालाई हुनी ज़ यासखैज़्‍याव। परमेस्‍वरए न्‍यायस ज़ ओराफाल्ज़्‍याव मनी ननी ज़ रैंःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","है जैद मिँराए, ‘ङा ङादोव य़ेननी ज़ परमेस्वरए ओङ़ाक धर्मी ङाथ॰रिके’ है लिद मास॰धुर, युँ हुप्‍न्‍यानी वाज़ धर्मी तान्‍या ताज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","कानुनलाव य़ेननी परमेस्वरए ओङ़ाक सु ज़ माथ॰रिधुर, युँ हुप्‍न्‍यानी वाज़ परमेस्वरए ओङ़ाक कानुन सयो·सिउ थ॰रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","परमेस्‍वर काता यहूदीराए यापरमेस्‍वर वाज़ रो? छुत जातलावराए यापरमेस्‍वर माःक रो? नो छुत जातलावराए यापरमेस्‍वर पाला ज़ सानी। ");
INSERT INTO kjl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","परमेस्वर तोबोका तोबो वाज़ ओतावए, नो परमेस्वर यहूदीराए यापरमेस्वर वाज़ माःक, प़ाइँए यापरमेस्वर ज़ लिज़्‍या। है जैद यहूदीर तादी ब, छुत जातलावर तादी ब परमेस्वरए मिँरालाई उयुँलाव मिताव धर्मी ओरारँःज़्‍याव तोबोनी वाज़ — नो येसुलाई युँ हुप्‍न्‍यानी वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","है जैद परमेस्वरए ओङ़ाक धर्मी थ॰रिन्‍या येम युँ सुहुप्‍न्‍यानी वाज़ ओताकिन ‘कानुन ते अऩाकलाव ची ओल्‍यो’ है जेलिज़्‍याखेहो। हिताव ते माःक, बुरू गेयुँ गेसुहुबोनी परमेस्वरए ओकानुन झन ज़ गेसयो·ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","हो ताकिन यहूदीराए गेपुर्खा अब्राहामए उजूँनी काता पाँन्‍या? ");
INSERT INTO kjl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","अब्राहामए ओदोव य़ेननी परमेस्वरए उयुँलाव मिताव उथ॰रिउ ताकिन, ‘ङानी ज़ धर्मी ङाथ॰रिके’ है लिखेहो। खाली परमेस्वरए ओङ़ाक ते है मालिधुइ। ");
INSERT INTO kjl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","धर्मसास्‍त्रल ब नोए उजूँनी इताव सर्सिउ लिज़्‍या, “अब्राहामए परमेस्वरए ओपाँत उयुँ उसुहुबोनी ज़ परमेस्वरए नोलाई धर्मी ज़ थ·रैक्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","य़ेन दाज़्‍यावए ओजेला ते दयानी मादैव, ओय़ेनए ओपाकैवनी वाज़ दैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ओय़ेननी काता ज़ मापाकैव मिँए ते यागल्‍ती क्‍याल्‍द्याज़्‍याव परमेस्वरलाई उयुँ उसुहुप्‍किन, नो ज़ झन परमेस्वरए ओङ़ाक धर्मी थ॰रिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","दाऊदए पाला परमेस्वरए याय़ेन चिऊद मायाद धर्मी ओराथ·रैव असिकए जूँनी अइ लिद सर्द नैव, ");
INSERT INTO kjl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“मादान्‍या यादोव य़ेनलाई चिऊद मायाद, यापाप क्‍याल्‍द ओराएकिन, नोर याभागी ल्‍योर लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","परमेस्वरए यापाप ओलेखा नैद ओमाराएकिन, नोर ब असिक दैवर लिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","10","नो परमेस्वरए ओराएज़्‍याव असिक क्याल्‍न्‍या सरेस जैसिउरालाई वाज़ माःक, प़ाइँलाई ज़ यासिउ लिज़्‍या। परमेस्‍वरए अब्राहामलाई पाला क्याल्‍न्‍या सरेस ओमाजैसिद ङ़ादा ज़, उयुँ उसुहुबोनी वाज़ धर्मी थ·रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","उयुँ सुहुप्‍द परमेस्वरए ओङ़ाक धर्मी उथ॰रिउ छींनी वाज़ परमेस्वरए, ‘ङामीं ज़’ लिद थामिन्‍याए जूँनी नो सरेस य़ाकाए जूँनी एक्‍यो। है जैद अब्राहाम क्‍याल्‍न्‍या सरेस माजैसिउ यायुँ हुप्‍ज़्‍याव छुत जातलाव मिँराए याबाबु मनी ज़। नोर मनी यायुँ यासुहुबोनी ज़ परमेस्वरए उयुँलाव मिताव उमींर ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","फरी क्‍याल्‍न्‍या सरेस जैसिउ यहूदीराए याबाबु मनी लिज़्‍या, खाली नोर मनी यापुर्खा अब्राहामए उसिलत बाद नोए ओदोव मितावनी ज़ यायुँ यासुहुप्‍किन वाज़ साचो नोए ओथोर ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेस्वरए अब्राहाम स़ोनो ओथोरालाई, ‘आव मानुवाताव राज्‍या जेमीं ज़ जैद ङायाचिरिज़्‍या’ है ओरादोव य़ाका अब्राहामए कानुनलाव य़ेन ओदोवनी ओदैव माःक, उयुँ हुप्‍द परमेस्वरए उयुँलाव मिताव उथ॰रिउनी ओदैव ची। ");
INSERT INTO kjl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","परमेस्वरए नोरास ओनैधुव य़ाका, छींनी कानुनलाव य़ेननी दैन्‍या ओजैव ताकिन, युँ हुप्‍न्‍या भरी अऩाकलाव ज़ ताद परमेस्वरए ओय़ाका ब मातान्‍या ज़ ताखेहो, ");
INSERT INTO kjl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","काराव ल्‍यो ताकिन कानुननी ज़ मिँराए परमेस्‍वरनी सजा दैज़्यार। कानुन ओमालिकिन सजा ब माताखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","है जैद ज़ परमेस्वरए ‘नो य़ाका ङायुँ गराँवनी ज़ ओताक’ लिद अब्राहामए ओथोरालाई नो य़ाका दैन्‍या यायुँ यासुहुबोनी ज़ जैद याएक्‍यो। ननी वाज़ नोरालाई दैन्‍या फिस्‍को माताए। नो य़ाका कानुन धूँलाव यहूदीराए जूँनी वाज़ माःक, प़ाइँए गेबाबु अब्राहामए ओदोव मितावनी ज़ यायुँ सुहुप्‍ज़्याव भरिराए जूँनी ब लिज़्‍या ");
INSERT INTO kjl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","धर्मसास्‍त्रलाव सर्सिउ मितावनी ज़, “परमेस्वरए अब्राहामलाई प़ाइँ राज्‍यालावराए याबाबु ज़ जैद नैद यायो।” नो य़ाका उयुँ उसुहुप्‍ज़्‍याव परमेस्वरए ओङ़ाक थ॰रिउ ज़ ताके। नो परमेस्वर सिउरालाई ब याजागैज़्‍याव, ताज़्‍याव भरी ब ओपाँनी ज़ यासिर्जैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","आस मालिज़्‍यावत ब अब्राहामलाई, “नथोर मागनिसिधुन्‍या तारिज़्‍यार,” है ओदोव पाँत उयुँ हुप्‍के। है जैद अब्राहाम कुधु जातलावराए याबाबु ताके। ");
INSERT INTO kjl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ज़ार मादैद सय बर्सवा ताद फ्या·न्‍याल गनिसिद उलिज़्‍यावत ब, ओज्‍या सारा जूचास्‍द ओबेथ रूःम्‍द उलिज़्‍यावत ब उयुँ मासतेद परमेस्वरए ओपाँत उयुँ हुप्‍के। ");
INSERT INTO kjl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","है जैद परमेस्वरनिकाव ओदैव य़ाकात अब्राहामए उयुँ आदा होदा माजैद, उयुँर झन ज़ हुप्द, परमेस्वरलाई ओमानर नैद्याद, ");
INSERT INTO kjl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","‘ङालाई है ओदाँव भरी जुनी ब सयो·द्याँवा ज़’ लिन्‍या सैंक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ननी ज़ परमेस्वरए अब्राहामलाई धर्मी थ·रैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","खाली नोलाई धर्मी ओथ·रैव पाँ ओललाई वाज़ माःक, ");
INSERT INTO kjl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","गे गेजूँनी ब लिज़्‍या। गे ब गेप्रभु येसुलाई सिउनी सोचोइज़्‍याव परमेस्वरलाई गेयुँ गेसुहुप्‍किन नोए गेलाई मनी धर्मी ज़ थ·रैन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","परमेस्‍वरए गे गेपापए जूँनी येसुलाई ज़ सिउ एक्‍यो। फरी परमेस्‍वरए ओङ़ाक गे धर्मी थ॰रिन्‍याए जूँनी येसुलाई सिउनी सोचोइक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","है जैद गेयुँ गेसुहुबोनी परमेस्‍वरए ओङ़ाक गेगल्‍ती माल्‍यो धर्मी गेथ॰रिउए, गेप्रभु येसु ख्रीसनी परमेस्‍वरस गेखैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","गेयुँ गेसुहुबोनी ज़ नो गेप्रभुए गेल्‍योदा उयुँ गराँद ओबाबु परमेस्‍वरस साःरो सर्‍यो जैद ओयासिउए गे नत ज़ गेलिज़्या। ननी ज़ गे स्‍वर्गताव आसत गेयुँ हुप्‍द रेंव ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","नाः वाज़ माःक, जो मिताव दुख उहुदी ब गेयुँ गेमासतेए, काराव ल्‍यो ताकिन नो दुखराए गेलाई माबले·सिउ, झन थ॰रिउ ज़ जैसिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","थ॰रिउ युँए फरी, पाखो जैव दोज़्‍याव। पाखो ताव मिँए ओआस झन घ्योःनाज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","गे आव आसत निरास तान्‍या गेमाले, काराव ल्‍यो ताकिन परमेस्‍वरए छैंव उपुरूस याद नो छैंव पुरूसनी गेयुँल ओमया थुद नैद्यासिउ। ");
INSERT INTO kjl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","गेनी काता ज़ माजैधुन्‍यार गेलिज़्याक, थिक ओगोइँव बेलाक ज़ ख्रीसए गे पापीराए जूँनी उजिउ झाःद्यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","मिँराए ताकिन ते चाव मिँए उजूँनी ब सुए ज़ उजिउ झाःद मायो, खाली बनै घ्योःव उयुँ उलिकिन वाज़ कैताराक बनै चाव मिँए उजूँनी उजिउ झाःद्याव ब धुव। ");
INSERT INTO kjl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","खाली परमेस्‍वरए ते गेल्‍योदा उयुँ उलिज़्याव आनी ज़ रैंःज़्‍या — गे पापीर गेलिज़्‍याक ज़ ख्रीसए गेजूँनी उजिउ झाःद्यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","है जैद नो उझीनी ज़ परमेस्‍वरए ओङ़ाक उयुँलाव मिताव ओजैसिउए, नोए ओल्‍योनी ज़ परमेस्‍वरए ओसजानी ब पुलुस्‍न्‍या गेले। ");
INSERT INTO kjl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","गे निताव ओलकिन तँदा लिज़्‍यावराए गेजूँनी उजिउ झाःद्याद ओबाबु परमेस्‍वरस ओसखैसिउए, गे परमेस्‍वरस खैवराए गेजूँनी ते दाद ओमायासिज़्‍याव काता ची लिज़्‍यादा? काता ज़ माले। ओल सिउनी सोद परमेस्‍वरस उलिज़्‍यावए गेलाई मनी बाँचैसिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","हो वाज़ माःक, गेप्रभु येसु ख्रीसनी परमेस्‍वरस गेखैवए, परमेस्‍वरए ओङ़ाक गेयुँर होलाँ ताद रेंव ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","आव मानुवात तोबो मिँए ल्‍योनी ज़ पाप पसिके। ननी ज़ सिन्‍या ब ताके। हाःकिन प़ाइँए पाप यादोवए प़ाइँ सिन्‍या ताकेर। ");
INSERT INTO kjl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मोसाए ओकानुनकिन ङ़ादा ज़ आव मानुवात पाप पसिद उलिज़्‍याव। खाली नो कानुन ओमातावा पै नो यादोव पापए ओहिसाप ब ओमालिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","हितावत ब आदमए ओपालाकिन मोसाए ओपालाक पै सिउ ज़ यालिज़्‍याव। नोराए आदमए ओदोव पाप मिताव यामादोदी ब सिउ ज़ परिके। है जैद किताव आदमए ओदोव हुनानी प़ाइँलाई ताके, हिताव ज़ छींनी हुज़्‍याव ख्रीसए उहुनानी मनी प़ाइँलाई ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","खाली आदमए ओदोव पाप परमेस्‍वरए ओदया स्‍यासो ते माले। आदमए ओदोव पापनी कुधुए सिन्‍या सजा दैकेर। येसु ख्रीसए ओदोव हुनानी परमेस्‍वरए ओदया ताद प़ाइँए बाँचिन्‍या असिक दैकेर। ");
INSERT INTO kjl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","हो मिताव ज़ परमेस्‍वरए ओल्‍योनी गेदैज़्‍याव असिक आदमए उहुनानी गेदैज़्‍याव स्‍यासो माःक। आदमए उहुनानी परमेस्‍वरए ओसजाल प़ाइँ ज़ परिकेर। ख्रीसए उहुनानी ते नोराए कुधु पाप यादोव तादी ब परमेस्‍वरए उयुँ नाद उयुँलाव मितावर थ॰रिज़्यार। ");
INSERT INTO kjl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","तोबोए ओदोव पापए हुनानी प़ाइँ सिन्‍याल परिकेर। परमेस्‍वरए ओदयानिकाव असिक दैद ओङ़ाक धर्मी थ॰रिउराए ते होकिन झन येसु ख्रीसए उहुनानी अजम्‍बरी जुनी दैज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","है जैद तोबो पापनी प़ाइँ ज़ परमेस्‍वरए ओसजा दैन्‍या ताकेर। हो मिताव ज़ तोबो धर्मलाव य़ेननी प़ाइँए ज़ फुर्सुल ताद साःरो जुनी दैन्‍या ताकेर। ");
INSERT INTO kjl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","काराव ल्‍यो ताकिन किताव परमेस्‍वरए ओपाँ तोबोए ओमाभैंःवनी कुधु ज़ याखत ल्‍योर थ॰रिकेर, हिताव ज़ परमेस्‍वरए ओपाँ तोबोए ओभैंःवनी कुधु ज़ याखत माल्‍यो छैंवर थ॰रिकेर। ");
INSERT INTO kjl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","मिँ भरी प़ाइँ पापीर ज़ लिज़्यार लिन्‍या सतैंद्यान्‍याए जूँनी परमेस्‍वरए कानुन जैक्‍यो। हितावत ब नो पाप खा कुधु ओताव, नोकिन झन परमेस्‍वरए ओदया कुधु ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","किताव ङ़ादा प़ाइँ मिँर पाप धूँल ताद सिन्‍या सजाल परिकेर, हिताव ज़ परमेस्‍वरए ओदयानी नो भरी त़ोसिद, गेप्रभु येसु ख्रीसनी परमेस्‍वरस सखैसिद, अजम्‍बरी जुनी दैन्‍यार गेताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","जे ख्वाराए ते, ‘परमेस्‍वरए ओदया झन कुधु घताक लिद गे मनी झन पाप गेदोया की’ है जेलिज़्‍याखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","हिताव ते माःक। गे पापस सर्‍यो फ्या·द पापए जूँनी सिधुवर काराव फरी पापल जन्‍न्‍या? ");
INSERT INTO kjl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","जे ज़ जेसैंज़्‍या, गे येसु ख्रीसए उमिनत गेसछैंसिक ओलस तोबो ताद, सिप ज़ गेसिके। ");
INSERT INTO kjl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","है जैद किताव ख्रीसए सिउ ओक्‍याँलाई खादरल याझाःव, हिताव ज़ गे मनी ख्रीसए उमिनत गेसछैंसिक ङ़ादाङाव गेक्‍याँ खादरल बाके। खाली हो वाज़ माःक, किताव ओबाबु परमेस्‍वरए ओसक्तीनी सिउनी ओसोव, हिताव ज़ गे मनी सोद साःरो येमल गेबाज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","सिन्‍यात ओलस तोबो गेताकिन, साःरोल पुलुस्‍न्‍यात मनी ओलस तोबो ज़ गेताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","आव ब सैंच्‍यो, नो ङ़ादाङाव पाप दोज़्याव गेक्‍याँ ख्रीसस क्रुसत सिप ज़ सिके, हाःकिन पाप धूँल गेमाले। ");
INSERT INTO kjl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","काराव ल्‍यो ताकिन सिउ मिँ पापए उधूँल मालिद फुर्सुल ताज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","गे ख्रीसस सिप गेसिउए, ‘ओलस साःरो जुनील पुलुसोर ब गेताके’ लिद गेयुँ हुप्‍द ले। ");
INSERT INTO kjl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ख्रीस सिउनी ओसैंसिउत फरी खर्क ज़ सिन्‍या माले। होए ओक्‍याँत सिन्‍याए ओहक फरी तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","नो तखेप उसिउ गेपापए उजूँनी ज़, नो सिउनी पुलुसो उजिउ ते परमेस्‍वरए उजूँनी ज़ बाँचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","हिताव ज़ जे मनी ‘गे पाप दान्‍यात सिद, येसु ख्रीसनी जींदो ताद, आव गेजिउ परमेस्‍वरए उजूँनी बाँचिज़्‍या’ लिन्‍या चेतैव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","है जैद जे आव जेजिउत कुबाना बानी धूँल लिद जेमन लागिउ य़ेनदा ताबाच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","पाप दान्‍यादा जेखँ जेकुइलाई फरी बाव ताएच्‍यो। बुरू, ‘गेलाई सिउनी बाँचैज़्‍याव नँ ज़’ लिद जेक्‍याँ भरी परमेस्‍वरलाई चरैःद, उयुँलाव मिताव य़ेन दान्‍यादा जेक्‍याँर थाँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","जे कानुन धूँल माताद परमेस्‍वरए ओअसिक धूँल जेतावए, जे जेक्‍याँत पापए ओहक माताव परिके। ");
INSERT INTO kjl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","जे ख्वाराए ते, ‘कानुन धूँल माताद असिक धूँल गेलिज़्यावए पाप गेदोदी ब ओताज़्‍याव ची ओल्‍यो’ है जेलिज़्‍याखेहो। हिताव ते माःक। ");
INSERT INTO kjl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","काता जे, जोए ओपाँ भैंःद ओसेवा जेदोज़्‍या, होए ओनोकोरर जेताज़्‍याव जेमासैंए रो? मादान्‍या य़ेन दाद होत ज़ जेलिकिन सिन्‍या सजाल परिन्‍या जेले। फरी परमेस्‍वरए ओपाँ जेभैंःकिन ते ओङ़ाक उयुँलाव मितावर थ॰रिन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","जे ङ़ादा मादान्‍या य़ेनर दाद पापए ओबाँदार जेल्‍यो। अब ते परमेस्वरए ओपाँ किताव जेथैव, हिताव ज़ नो पाँत लिद जेयुँ स्‍यानी ज़ जेदोज़्‍या। आवए उजूँनी परमेस्‍वरलाई धन्‍याबाद लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","जे पापए ओसेवानी पुलुस्‍द चाव य़ेन दान्‍यादा परमेस्वरए ओसेवा दान्‍यार ताद जेले। ");
INSERT INTO kjl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","आव ङापाँ कसा मातीधुर लिद जेतीधुन्‍या पाँनी ज़ ङापाँज़्‍या। किताव ङ़ादाकिन जेखँ जेकुइए युँ माजामो माचाव य़ेन दावका दाव लिद होए ओबाँदा जेजैसिज़्‍याव, हिताव ज़ अबकिन ते नो जेखँ जेकुइलाई परमेस्वरए ओय़ेन दाव परींद होए ओसेवा दान्‍या जेजैसिकिन उमिनताव छैंवर जेतारिज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जे ङ़ादा मादान्‍या य़ेन दाद पापए ओबाँदा जेजैसिक, परमेस्वरए ओय़ेन दान्‍या जात्त ज़ जेमाचेतैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","है जैद आज्‍याल ते नो ङ़ादाङाव जेदोव य़ेनलाई जेचेतैक जेलाज ब हुज़्‍या। नो ङ़ादाङाव जेदोव भरिए जेलाई यादा माजैचिक्‍यो, झन सिन्‍याल वाज़ ओझाःचिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","अब ते जे नो पापए ओसेवा दान्‍यानी पुलुस्‍द परमेस्वरए ओसेवा दान्‍यार ताद जेले। ननी ओफाइदा ऩेथो लिज़्‍या — परमेस्वरए उयुँलाव मिताव छैंवर जेतानाज़्‍या, स़ोनो अजम्‍बरी जुनी ब जेदैरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","पापए ओजेला नर्ग लिज़्‍या, परमेस्वरए ओयासिज़्‍याव बरदान ते गेप्रभु येसु ख्रीसनी अजम्‍बरी जुनी लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","अ ङानैं ङामेंर, जे मोसाए ओकानुन भरी सैंद जेनै। है जैद आव ङापाँ ब चावस तीच्‍यो। जो मिताव कानुननी तादी ब नो कानुनए ओहक मासिवा भरी वाज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","किताव रे दाव मेंमा, ओरे ओमासिवा पै कानुन मितावनी ओरेए ओसतत लिन्‍या ज़ लिज़्‍या। ओरे उसिकिन वाज़ बल्‍ल फुर्सुल ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ओरे लिज़्‍यावत ज़ नो मेंमा छुतए ल्‍योदा ओरेस्‍किन नो मेंमाए जारी य़ेन ओदोव थ॰रिज़्‍या। खाली ओरे उसिकिन वाज़ नो कानुननी फुर्सुल ताज़्या। हाःकिन छुतस ओरेस्‍दी ब नोलाई काता खत ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ङानैं ङामेंर, हो मिताव ज़ गे मनी ङ़ादाकिन मोसाए ओकानुन धूँल गेलिज़्‍याव। खाली ख्रीसए उमिनत ओलस गेसिउ मिताव ज़ ओतावए नो ङ़ादाकिनकाव मोसाए ओकानुनलाव गेसर्‍यो भरी फ्या·द अबकिन ते सिउनी सोव ख्रीसस साःरो गेसर्‍यो ताके। हुनी ज़ परमेस्वरए उयुँलाव मिताव य़ेन ब सयो·धुन्‍या गेले। ");
INSERT INTO kjl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ङ़ादा माचाव गेय़ेनए उधूँल गेलिज़्याक कानुनलाव ‘मादान्‍या’ सर्सिउए गेलाई झन मादान्‍या वाज़ खर॰ चेतैव उपरींसिज़्‍याव। है जैद सिन्‍या सजाल गेपरिके। ");
INSERT INTO kjl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","आज्‍याल ते नो सजात गेसिउ मिताव ज़ ओतावए नो कानुनए ओहकनी पुलुस्‍द गेले। है जैद हाःकिन गे परमेस्‍वरए ओसेवा कानुननी गेदोज़्‍याव माःक, गेयुँल लिज़्याव छैंव पुरूसनी ज़ गेदोज़्‍याव ची। ");
INSERT INTO kjl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ङा परमेस्‍वरए ओकानुन माचाव है ङालिज़्‍याव ते माःक। कानुन ओमाल्‍यो ताकिन ‘पाप आव ज़’ लिद कातानी ङासैंरिज़्‍याव? कानुनल “लोभ दान्‍या माताए” लिद सर्सिउ ओमाल्‍यो ताकिन ङा लोभए उमिन ब ङामासैंखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","खाली नो कानुनलाव ‘तादोच्‍यो’ लिन्‍या पाँत ज़ पापए ओमौका हुके। ननी ज़ ङायुँलाव प़ाइँ किसिमलाव लोभ ब सरैंःद्याँक्‍यो। है जैद कानुनल ‘तादोच्‍यो’ लिन्‍या ओमाल्‍यो ताकिन ङापाप ब मारैंःखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ङा ङ़ादा परमेस्‍वरए ओकानुन ङामासैंद, सन्‍चस ज़ ङालिज़्‍याव। हाःत ज़ ओकानुनलाव पाँर ङासैंवत ङापाप भरी रैंःद सिउल ङागनिसिके। ");
INSERT INTO kjl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","है जैद नो कानुनलाव बाँचैव परिन्‍या पाँए ज़ झन ङालाई सिन्‍याल झाःनाज़्याव लिन्‍या ङासैंके। ");
INSERT INTO kjl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","खास नो ङ़ादाकिनकाव ङादोव पापए ज़ कानुननी पल्‍तैन्‍या कर दैद ङालाई झुकैद नो कानुननी ओसैःनाव मिताव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","हैदी ब परमेस्‍वरए ओकानुन माचाव माःक, छैंव ज़ लिज़्‍या। नलाव दान्‍या य़ेन ब परमेस्‍वर मिताव छैंव ब लिज़्‍या, सोजो ब लिज़्‍या, चाव ब लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","है जैद ङालाई सिन्‍या सजाल नो चाव पाँए ओझाःनाव ते माःक, ङादोव य़ेनए ज़ ओझाःनाव ची। है जैद ङादोव य़ेनए परमेस्‍वरए नाः चाव ओकानुननी मनी सिन्‍याल ओझाःनावए, नो ङाय़ेन ‘पाप ज़’ रैंःके। है जैद परमेस्‍वरए ओकानुननी पाप भरी झन छे छे ङम्सिउ रैंःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","नो कानुन भरी परमेस्‍वरनी हुव, चाव ज़ लिज़्‍या लिन्‍या ते गेसैंज़्‍या। खाली ङा माचाव य़ेन दोज़्याव स़ोनो पापए ओबाँदा ङालिज़्याव ज़ रैंःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","निताव ङाय़ेनलाई रँःद ङा मनी बक्‍क ज़ ङाताज़्‍या। ङायुँए चाव य़ेन दाव ङापैंदी ब, नो य़ेन मादाद झन ङासोव य़ेनलाई ङादोज़्‍याव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","नो ङासोज़्याव माचाव य़ेननी ज़ ‘परमेस्‍वरए ओकानुन ते चाव ज़ ओल्‍यो’ लिन्‍या ङाथ·रैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","नो ङादोव य़ेन ङानी ज़ ङाखुसीनी ङादोव माःक, ङायुँलाव पापए ची ओदोज़्‍याव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","आव ङाक्‍याँत चाव काता ज़ माले लिन्‍या ङासैंज़्‍या। ङायुँल चाव य़ेन दाव ङापैंदी ब, ङाकुइए ते ङामासयो·धुइ। ");
INSERT INTO kjl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","‘चाव य़ेन ङादोया’ है ङालिदी ब, नो य़ेन ज़ मापुलुसे। झन वैंव ङापैंज़्‍याव य़ेन, हो ज़ पुलुस्‍ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ङायुँए ओमाभैंःव य़ेन ङादोज़्‍या ल्‍यो ताकिन, नो ङानी ङादोज़्‍याव माःक, ङायुँलाव पापए ची ओदोज़्‍याव ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ननी ज़ ङासैंज़्‍या — ङा चाव य़ेन दाव पैंज़्‍यावए ङाक्‍याँत पाप ङास ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ङायुँल ते परमेस्‍वरए ओकानुन चाव ज़ ङम्‍सिद खुसीस ङाभैंःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","खाली ङाखँ कुइए ते ङायुँलाव पाँकिन तँदा ज़ दोज़्‍याव। है जैद पापए ओसक्तीए ङायुँस लरैं दाद, पाप धूँल ङालाई कैदी जैद माचाव य़ेनदा ज़ लाँनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ओहो! ङा इताव पापीलाई सिन्‍याल झाःज़्याव ङाक्‍याँनी सुए हाइनावके? ");
INSERT INTO kjl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","गेप्रभु येसु ख्रीसनी वाज़ पुलुसो ङादैज़्‍या। होए उजूँनी परमेस्‍वरलाई धन्‍याबाद लिज़्‍या। है जैद ङायुँए परमेस्‍वरए ओकानुनलाव य़ेन दोव ङापैंज़्‍या, खाली माचाव य़ेन दाज़्याव ङाक्‍याँए ते पाप दान्‍यादा वाज़ लाँनाज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","है जैद येसु ख्रीसए उमिनत लिज़्‍यावरालाई परमेस्‍वरनी काता सजा ज़ तान्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","येसु ख्रीसनी साःरो जुनी याज़्याव छैंव पुरूसए ओसक्तीनी नो ङ़ादाङाव पाप दाद सिन्‍या सजाल झाःज़्‍याव गेय़ेननी ऱास्‍सिद गेले। ");
INSERT INTO kjl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","गे माचाव य़ेन दोज़्यावराए गेक्‍याँत परमेस्‍वरए ओय़ेन सयो·न्‍या काता सक्ती ज़ ओमाल्‍योए नो कानुनए सुलाई ज़ धर्मी माजैधुव। है जैद परमेस्‍वरए ओल ओज़ालाई गे स्‍यासो मिँ जैद, गेपापए उजूँनी परींद, गेक्‍याँताव पापए ओसक्ती भरी सम़ैद्यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","परमेस्‍वरए ओकानुनलाव पाँ भरी गे माचाव य़ेन मादाद छैंव पुरूसनी दाज़्यावराए गेक्‍याँनी ज़ ओयो·क लिद ननी ज़ दाद्यासिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","क्‍याँनिकाव माचाव य़ेन दोज़्यावर ते याक्‍याँए ओपैंज़्यावदा वाज़ यायुँ झाःज़्यार। छैंव पुरूसनी दोज़्यावर ते छैंव पुरूसए ओपैंज़्यावदा ज़ यायुँ झाःज़्यार। ");
INSERT INTO kjl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","माचाव य़ेन दोज़्याव क्‍याँए ल्‍योदा यायुँ झाःज़्‍यावर पापल सिज़्‍यार। छैंव पुरूसए ओल्‍योदा यायुँ झाःज़्‍यावर ते यायुँ होलाँ ताद साःरो जुनी दैज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","नो क्‍याँए ल्‍योदा झाःसिउ युँ ते परमेस्‍वरकिन तँदा ताद परमेस्‍वरलाई सोज़्‍याव। परमेस्‍वरए ओकानुन धूँल मालिधुइ। ");
INSERT INTO kjl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","है जैद क्‍याँए ओपैंज़्याव माचाव य़ेननी सुए ज़ परमेस्‍वरलाई खुसी माजैधुव। ");
INSERT INTO kjl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","खाली जेस ते परमेस्‍वरए उपुरूस जेयुँल बास ओदोवए माचाव य़ेन दोज़्याव क्‍याँए उधूँल माताद परमेस्‍वरए उपुरूसए उधूँल जेलिज़्‍या। जोस ख्रीसए उपुरूस माले, हो ख्रीससकाव माःक। ");
INSERT INTO kjl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","है जैद जेक्‍याँत ख्रीस उलिकिन, पाखाताव जेक्‍याँ पापए उहुनाए उसिदी ब, परमेस्‍वरस जेखैवए परमेस्‍वरए उपुरूसनी साःरो जुनी जेदैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","येसुलाई सिउनी सोचोइज़्‍यावए उपुरूस जेयुँल बास ओदोवए, येसु ख्रीसलाई सिउनी सोचोइज़्‍याव ओबाबुए जेलाई मनी तछा ओल उपुरूसनी ज़ जेक्‍याँलाई अजम्‍बरी जुनील सोचोइचिरिज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","है जैद ङानैं ङामेंर, गेक्‍याँए मादान्‍या उखिम्‍ज़्‍याव मितावनी दान्‍या गेलाई काता कर ज़ माले। ");
INSERT INTO kjl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","क्‍याँए उखिम्‍ज़्याव मितावनी माचाव य़ेनल ज़ जेलिकिन सिन्‍या जेले। छैंव पुरूसए ओसक्तीनी ते निताव क्‍याँनिकाव माचाव य़ेनरालाई जेरासम़ैकिन साःरो जुनी ज़ दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","परमेस्‍वरए उपुरूसए ओरापैज़्‍याव मितावनी दोज़्‍यावर ज़ परमेस्‍वरए ओज़ार ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","परमेस्‍वरनिकाव जेदैव पुरूसए जेलाई छे·द ज़ लिन्‍या उधूँलाव बाँदा स्‍यासो माजैचिउ, बुरू ओल परमेस्‍वरस ज़ा बाबु ज़ तान्‍या जैचिज़्‍याव। ननी ज़ गे परमेस्‍वरलाई ‘अब्बा, बाबु’ है ब गेदोज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","छैंव पुरूस गे गेपुरूस जोरैसिद ‘परमेस्‍वरए ओज़ार गेताके’ है लिन्‍या पाँत ओल ओसाची ब याद नो गेयुँलाव पाँलाई जोर्द्यासिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","गे ओज़ार गेतावए ओबताहा दैन्‍यार ब गेताके — ओज़ा ख्रीसस सिप ज़ दैन्‍या गेले। है जैद ओल उमिनताव दुखर गेदैकिन ओलस ज़ सुख ब दैन्‍या गेले। ");
INSERT INTO kjl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","आव गेजिउताव गेदैज़्‍याव दुखर अजम्‍बरी जुनील गेदैरिज़्‍याव सुखकिन काता ज़ माले लिद ङायुँ हुप्‍द ले। ");
INSERT INTO kjl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","परमेस्‍वरए ओरासिर्जैव भरिए ब ‘परमेस्‍वरए ओज़ारालाई खर्क सतैंद अजम्‍बरी जुनी यायोके?’ लिद यायुँ थू जैव ज़ नैज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","नो ओरासिर्जैव भरी ते खेम्‍न्‍यादा म़ान्‍यादा बान्‍या ताकेर। नो यानी माःक, ओल परमेस्‍वरए ज़ नै याजैक्‍यो। खाली नोरालाई मनी तोबो आस लिज़्‍या — ");
INSERT INTO kjl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","परमेस्‍वरए ओज़ारालाई फुर्सुल जैद ओज़गै मगै ओराएरिज़्‍याव मिताव ज़ नो ओरासिर्जैव भरी तछा खेम्‍न्‍या म़ान्‍यानी बाँचिद साःरोल पुलुस्‍न्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","किताव ज़ा दैन्‍या मेंमा उघर्लिज़्याव, हिताव ज़ नो ओरासिर्जैव भरिए नो भरी ओमातावा पै ‘आव जुकलाव दुखर खर्क खेम्‍के?’ लिद उथुपुल ताद गहनिउ ज़ लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","खाली नोर वाज़ माःक, गे उपुरूस बैना दैवराए मनी ‘आव सिन्‍यानी खर्क पुलुस्‍द ओज़ार गेमिन्‍सिके?’ लिद गेयुँ थू जैद कींव ज़ गेनैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","निताव आसए जूँनी ज़ परमेस्‍वरए ओपाँत गेहुके। हुन्‍या पाँत वाज़ आस ताज़्‍या, ताधुवलाई आस गेमादोदी ब ताए। ");
INSERT INTO kjl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","खाली गेआस आःपै माहुताव पाँत ओतावए, नो पाँ ओमाहुवा पै गेयुँ थू जैद कींव ज़ गेनैज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","हिताव ज़ गेनी गेमादोधुज़्‍याव य़ेनल छैंव पुरूसए गेलाई सघैसिज़्‍याव। परमेस्‍वरलाई पोंखारिन्‍या मनी गेनी ज़ गेमासैंए। ओल छैंव पुरूसए ज़ गे सुए ज़ गेमाहाइधुज़्‍याव पाँर गेयुँल पाँद्यासिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","प़ाइँ युँलाव पाँ सैंज़्‍याव परमेस्‍वरए नो छैंव पुरूसए गेयुँलाव ओपाँव पाँए ओअर्थ भरी तीज़्‍याव। काराव ल्‍यो ताकिन गे परमेस्‍वरए उमिनत लिज़्‍यावराए गेजूँनी नो पुरूसए पाँद ओयासिज़्‍याव पाँ भरी ओल परमेस्‍वरए उयुँलाव पाँस खैव लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","आव पाँत गेयुँ हुप्‍ज़्‍या — परमेस्‍वरए उमिनताव खुल्‍सिउर, ओल्‍योदा यायुँ थू जैद नैज़्‍यावरालाई ओल परमेस्‍वरए ज़ प़ाइँ यालाई तान्‍या ज़ सखैद याएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","परमेस्‍वरए ङ़ादाकिन ज़ ‘ङामींर ज़ तारिज़्‍यार’ लिद सरेस्‍द ओरानैज़्‍यावरालाई, नोराए याक्‍याँत तोबोका तोबो ओज़ाए ओगे रैन्‍यार याथ·रैक्‍यो। है जैद ओज़ा ख्रीस छींनी ताज़्‍याव भरिराए यादाज्‍यु ताके। ");
INSERT INTO kjl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","नो ङ़ादाकिन ओराथ·रैवरालाई ओल्‍योदा हुन्‍या ब याखुल्‍क्‍यो। ओल्‍योदा हुन्‍या ओराखुलोरालाई ओलस खैवर ब याजैक्‍यो। ओलस खैव ओराजैवरालाई याज़गै ल्‍योर ब याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","आव पाँ भरिल गे कै लिन्‍या लिक ते — परमेस्‍वर गेल्‍योदा ओतावए गेलाई सुए ज़ कैज़ माजैसिधुर। ");
INSERT INTO kjl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","तोबोका तोबो ओज़ा ओलस मानैद, सिन्‍या गेपोल झाःद्याज़्‍याव परमेस्‍वरए, गेलाई ओज़ास ज़ चाहिज़्‍याव भरी कै जैद मायासिउके? ");
INSERT INTO kjl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ओल परमेस्‍वरए ज़ छाँतिद ओराथ·रैवरालाई सुए ज़ खत मारालैधुर। परमेस्‍वरए ओल ज़ उयुँलाव मितावर ओराथ·रैवए, ");
INSERT INTO kjl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","नोरालाई सजा यान्‍या सुए ची ओराथ·रैधुरिज़्‍याव? येसु ख्रीसए गेपापए जूँनी उजिउ झाःद्यासिक्‍यो। हो वाज़ माःक, सिउनी सोद, परमेस्‍वरए ओवोर्दा च़ुसिद गेजूँनी परमेस्‍वरलाई बिन्‍ती दाव ज़ नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","है जैद गेलाई ख्रीसए ओमयानी सुए ओपले·सिधुरिज़्‍याव? गेलाई दुख उहुदी ब, धो सहिन्‍या उहुदी ब, गेखिरी यापसिदी ब, करे गेतादी ब, नाङग्‍या गेतादी ब, ऩुल उहुदी ब, लरैं उहुदी ब, गेलाई ओमयानी काताए ब मापले·सिधुव। ");
INSERT INTO kjl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","धर्मसास्‍त्रल इताव सर्सिउ लिज़्‍या, “नँ नजूँनी गे दिनकाव सिन्‍या मितावल गेबाज़्‍या। पल्‍ना यालाँज़्‍याव पाथा स्‍यासोर गेलिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","हैदी ब गेल्‍योदा उयुँ थू जैज़्‍यावए ल्‍योनी गे आव भरिल झेंःस्‍याराकिन झेंःस्‍या ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","आव पाँत ङायुँ हुप्‍द ले — गेसिदी ब, गेबाँचिदी ब, स्‍वर्गताव चाकर्‍यार तादी ब, मानुवाताव घेप्‍पार तादी ब, आज्‍यालकाव पाँरानी तादी ब, हुन्‍या पाँरानी तादी ब, सक्तीरानी तादी ब, ");
INSERT INTO kjl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","रोतावर तादी ब, मेलावर तादी ब, छुत कातारानी तादी ब, गेलाई गेप्रभु येसु ख्रीसनी ताज़्‍याव परमेस्‍वरए ओमयानी काताए ब मापले·सिधुव। ");
INSERT INTO kjl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ङा जेलाई साचो है ङादाचिज़्‍या, धुत ङामापाँए, ख्रीस साची लिज़्‍या। आव पाँत छैंव पुरूसनी ब ङायुँ छैंव ज़ लिज़्‍या। ङापाँ आव ज़ — ");
INSERT INTO kjl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","3","ङाभेराराए जूँनी ङायुँ बनै घरो ज़ लिज़्‍या। ङा नोराए यापोल ख्रीसए ल्‍योनी ख्यासिद ओसराप धूँल ङापरिदी ब, नोर याबाँचिकिन खुसी ङाताखेहो। ");
INSERT INTO kjl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","नो इस्राएलीरालाई ङ़ादाकिन ज़ ओल परमेस्‍वरए, ओज़ार जैन्‍या थ·रैद, ओज़गैर सतैंद्याद, ओबाचा स़ोनो ओय़ाकार ब याएक्‍यो। ओकानुन ब याद, ओसेवार दान्‍या यापैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","अब्राहाम, इसहाक, याकूबर मनी नोराए यापुर्खार ज़। नोराए याथोल फरी ख्रीस ब मिँ मिन्‍सिद जर्मिके। नो प़ाइँराए ङ़ैत राज्या दान्‍या परमेस्‍वर ज़। नोए उमिन एकतार ज़ ओघ्‍योःक। आमेन। ");
INSERT INTO kjl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","परमेस्‍वरए नोरालाई ओय़ाका सयो·द ओमाराएज़्‍याव ते माःक। खाली इस्राएली भरी प़ाइँ याकूबए ओथोर यातादी ब परमेस्‍वरनी ते प़ाइँ मालेर। ");
INSERT INTO kjl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","हो मिताव ज़ अब्राहामए ओज़ार मनी प़ाइँ ओथोल ते मागनिसिर। धर्मसास्‍त्रल मनी परमेस्‍वरए अब्राहामलाई है दाद नैव, “इसहाकनिकावर वाज़ नथोल गनिसिन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ननी ज़ रैंःज़्‍या, अब्राहामए ओक्‍याँ बातनिकावर माःक, परमेस्‍वरए अब्राहामलाई ओयो य़ाकानिकावर वाज़ परमेस्‍वरए ओज़ार ताज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","नो ओयो य़ाका आव ज़, “ङा फर्नी आः बेलाक फरी ङाहुरिज़्‍या। हो बेलाक नज्‍या साराए खेपा ज़ा दैरिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","खाली हो वाज़ माःक, गेपुर्खा इसहाकए ओज्‍या रिबेकाए पाला, जोङोल्‍या खेपानी निदैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","नोनी चाव ब मादाद माचाव ब मादाद, निआमाए उफूल ज़ परमेस्‍वरए मिँरालाई ओराथ·रैज़्‍याव मिताव, ");
INSERT INTO kjl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","निय़ेननी माःक, ओल उयुँ स्‍यानी ज़ नोनी तोबोलाई रूजिद, रिबेकालाई, “ओदाज्‍युए ओभाइए ओसेवा दान्‍या ले,” है दोक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","परमेस्‍वरए है उलिज़्‍याव मिताव धर्मसास्‍त्रल आव मनी सर्सिउ लिज़्या, “याकूबए ल्‍योदा ङायुँ लिज़्‍या, एसावए ल्‍योदा ङायुँ माले।” ");
INSERT INTO kjl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","जे ख्वा ख्वाराए, ‘निताव ताकिन ते परमेस्‍वरए न्‍यायस ज़ ओमादोज़्‍याव ची ओल्‍यो’ है ब जेलिज़्‍याखेहो। हिताव ते माःक। ");
INSERT INTO kjl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","परमेस्‍वरए मोसालाई है दोक्‍यो, “जोए ल्‍योदा ङायुँ नान्‍या ङापैंज़्या, होए ल्‍योदा ङायुँ नाज़्‍या। जोए ल्‍योदा ङायुँ सय़ालो ङापैंज़्या, होए ल्‍योदा ङायुँ य़ाल्‍ज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","परमेस्‍वरए मिँराए ल्‍योदा उयुँ ओय़ाल्‍ज़्‍याव याय़ेननी ब माःक, या यापैंज़्‍यावनी ब माःक, ओल परमेस्‍वरए उयुँ स्‍यानी वाज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","धर्मसास्‍त्रल परमेस्‍वरए राजा फारोलाई मनी है दोक्‍यो, “नँ नक्‍याँत ङासक्ती सतैंन्‍याए जूँनी नँलाई राजा जैद ङानैनिए। ननी ज़ ङामिन संसार भरिल प़ाइँदा ज़ थास्‍न्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","है जैद जोए ल्‍योदा परमेस्‍वरए उयुँ नान्‍या पैंज़्याव, होए ल्‍योदा उयुँ नाज़्या। फरी जोलाई परमेस्‍वरए खाव जैन्‍या पैंज़्याव, होलाई खाव ज़ जैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","जे ख्वाराए है जेलिज़्‍याखेहो, ‘ओल ज़ नै ओराजैव ताकिन ते कै जैद यागल्‍ती थ·रैद ओराएज़्‍याव? परमेस्‍वरए मिँरालाई गोइँद ओराएज़्‍यावकिन सुए ची तँदा ओलाँधुरिज़्‍याव?’ ");
INSERT INTO kjl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ङा ते झन है ङादाचिज़्‍या, ए निताव पाँज़्‍याव मिँ, नँ कै जैद परमेस्‍वरस याः नदोज़्‍याव? गम जाए ब ओक्‍याँ जैज़्‍यावलाई, ‘ङालाई काराव अइ नजैनाव?’ है मादोव। ");
INSERT INTO kjl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","नो गम जा जैज़्‍याव कुमाल्‍याए जो मिताव ओजैदी ब ओल ओमाहाँ ज़ लिज़्‍या। ख्वारालाई बनै घेप्‍पा, याएः ल्‍योर याजैज़्‍याव, ख्‍वारालाई अइज़ तके दँकावर याजैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","परमेस्‍वरए ओय़ेन ब हिताव ज़। उरिस चोवराए याक्‍याँत उरिसलाव सक्ती सतैंन्‍या ब ओल ओमाहाँ ज़ लिज़्‍या। हैदी मनी नोर नास दैन्‍याकावर यालिदी ब नोराए याक्‍याँत उरिस थामिउ ज़ नैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","है जैद निताव उरिस चोवरालाई मनी हैज़ ओराजैकिन, उयुँ नावरालाई झन कै जैद ओदया सतैंद मारायोके? नोरालाई ते ङ़ादाकिन ज़ ओज़गै दैन्‍यार ब जैद ओरानैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","गे ओछाँतिसिउर ब उयुँ नावर ज़ गेलिज़्‍या — यहूदीर वाज़ माःक, जे छुत जातलावर ब जेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","अगमबक्ता होसेए मनी परमेस्‍वरए ओपाँ अइ लिद सर्द नैव, “ङामींर मातावर ङामींर ज़ ङाराजैरिज़्‍या। ङामन मालागिउरालाई ङामन लागिउर ङाराजैरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","स़ोनो, “ ‘जे ङामींर माःक’ है ओरादोव पोल झन नल ज़ ‘जींदो परमेस्‍वरए ओज़ार ज़’ है दान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","यसैयाए मनी इस्राएलीराए जूँनी अइ लिद सर्द नैव, “इस्राएलीर समुन्‍द्रलाव बालुवा स्‍यासो मागनिसिधुन्‍यार यालिदी ब, छ्या वाज़ परमेस्‍वरए ओङ़ाक थ॰रिन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","परमेस्‍वरए आव मानुवात ओपाँ चाँदो ज़ छत्‍कैद सयो·रिज़्‍याव।” ");
INSERT INTO kjl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","फरी तोथोल यसैयाए किताव ओसरो, हिताव ज़ तान्‍या ले — “गेथोर माहान परमेस्‍वरए तोबो ऩेब्‍लो बाँचैद ओमायासिउ ताकिन, सदोम स़ोनो गमोरालाव स्‍यासोर तान्‍या गेल्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ङा है ङालिज़्‍यावए ओअर्थ आव ज़ — यहूदीकिन छुत जातलाव मिँराए परमेस्‍वरए ल्‍योदा बान्‍या येम यामाखिम्‍दी ब, परमेस्‍वरए ल्‍योदा यायुँ यासुहुबोनी झन, नो येम ज़ दैकेर। ");
INSERT INTO kjl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","यहूदीराए ते परमेस्‍वरए ल्‍योदा बान्‍या येम ङ़ादाकिन ज़ कानुन भैंःद दान्‍यानी याखिम्‍दी ब मादैकेर। ");
INSERT INTO kjl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","काराव यामादैव? काराव ल्‍यो ताकिन नोराए युँ हुप्‍न्‍यानी यामाखिम्‍ज़्‍याव, कानुनलाव य़ेननी वाज़ याखिम्‍ज़्‍याव। है जैद नोर धर्मसास्‍त्रलाव सर्सिउ ‘सुत़ुम्‍न्‍या लुँत’ पर्दप्‍द यापाव मिताव ज़ ताके। ");
INSERT INTO kjl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","नलाव सर्सिउ आव ज़, “ङा सियोनलाव ङाराज्‍याल मिँराए यायुँ केःद्यान्‍या सुत़ुम्‍न्‍या लुँ थाँद ङानै। नो लुँत यायुँ हुप्‍ज़्‍यावर लाज मोर्नो तान्‍या मालेर।” ");
INSERT INTO kjl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","अ ङानैं ङामेंर, ङा ङाभेरा यहूदीराए जूँनी पोंखारिद, ‘परमेस्‍वरनी बाँचिउ यादैकिन ताखेहो’ है ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","नोर परमेस्‍वरए ल्‍योदा बान्‍या बनै धामा दोज़्‍यार लिन्‍या ते ङासैंज़्या। खाली चावस माबुझिद अऩाकल ज़ दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","परमेस्‍वरए मिँरालाई ओल्‍योदा ओरासखैज़्‍याव येम माप़ाल्‍धुद यानी ज़ सखैसिउ पैंद परमेस्‍वरए ओयेमल माहुकेर। ");
INSERT INTO kjl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ख्रीसए ओय़ेन उसुदुमोए कानुननी बान्‍या येम तुपिके। है जैद ओललाई यायुँ हुप्ज़्‍याव भरी ते परमेस्‍वरस खैवर ताज़्यार। ");
INSERT INTO kjl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","कानुनलाव य़ेननी परमेस्‍वरस खैन्‍याए जूँनी मोसाए अइ लिद सर्द नैव, “कानुनलाव य़ेन माबिरैद दोज़्‍याव मिँ वाज़ बाँचिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","युँ सुहुप्‍न्‍यानी परमेस्‍वरस खैन्‍याए जूँनी ते इताव सर्सिउ लिज़्‍या, “जे, ‘स्‍वर्गत बान्‍या सुए ची उधुरिज़्‍याव,’ है तालिच्‍यो।” (अथबा, ‘गे ख्रीसलाई स्‍वर्गतिन मेल गेमारैधुइ’ है ल्‍यो मापरिए।) ");
INSERT INTO kjl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","स़ोनो, “जे, ‘खादरल बान्‍या सुए ची उधुरिज़्‍याव,’ है ब तालिच्‍यो।” (अथबा, ‘गे ख्रीसलाई सिउनी गेमासोचोइधुइ’ है ब ल्‍यो मापरिए।) ");
INSERT INTO kjl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","बुरू ‘आव चेतैव ताके’ है लिन्‍या सर्सिउ लिज़्‍या, “ओपाँ जेकिन तादाङ माले। ओपाँ जेयुँल ज़ लिज़्‍या, जेयाःत ज़ लिज़्‍या।” नो पाँ फरी गे गेसथैचिज़्‍याव युँ सुहुप्‍न्‍या चाव था ज़। ");
INSERT INTO kjl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","जेयाःत ‘येसु ख्रीस ज़ गेप्रभु’ लिद जेपाँकिन, स़ोनो जेयुँल ‘परमेस्‍वरए ख्रीसलाई सिउनी सोचोइक्‍यो’ लिद जेयुँल जेपतिकिन बाँचिन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","गेयुँए ज़ परमेस्‍वरए ओपाँलाई गेयुँ हुप्‍द ओलस गेखैज़्‍या, फरी नो गेयुँलाव पाँलाई गेयाःए पाखात पाँद गेबाँचिज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","नो धर्मसास्‍त्रलाव ‘ओल्‍योदा उयुँ सुहुप्‍ज़्‍याव मिँ लाज मोर्नो तान्‍या माले’ है लिन्‍या पाँ ");
INSERT INTO kjl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदीरालाई मनी लिज़्‍या, छुत जातलावरालाई मनी लिज़्‍या। परमेस्‍वर तोबोका तोबो ओतावए प़ाइँए परमेस्‍वर ज़ लिज़्‍या। जो जातए तादी ब ओललाई खिम्‍ज़्‍यावरालाई ओअसिकर थुद याएज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","धर्मसास्‍त्रल मनी, “जोए परमेस्‍वरए उमिन हाइद परमेस्‍वरलाई खिम्‍ज़्‍याव, हो बाँचिन्‍या ले,” लिद सर्सिउ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","खाली परमेस्‍वरलाई यायुँ यामासुहुप्‍किन परमेस्‍वरलाई कातानी ची याखिम्‍रिज़्‍याव? स़ोनो, परमेस्‍वरए ओपाँ थैव यामादैकिन कातानी यायुँ यासुहुप्‍रिज़्‍याव? स़ोनो, सथैन्‍या मिँ याल्‍योदा ओमाबाकिन कातानी याथैरिज़्याव? ");
INSERT INTO kjl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","सथैन्‍या मिँलाई सुवाराए यामापरींकिन कातानी ओबाधुरिज़्‍याव? निताव बाज़्‍यावराए जूँनी धर्मसास्‍त्रल मनी अइ लिद सर्सिउ लिज़्‍या, “चाव था रैद हुज़्‍याव मिँलाई रँःद, प़ाइँए यायुँ होलाँ ताद रेंज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","हितावत मनी इस्राएलीर जाँकोसैए चाव था थैन्‍या युँ ज़ मादोकेर। यसैयाए मनी अइ लिद सर्द नैव, “अ परमेस्‍वर, गेरासथैव पाँत सुए यायुँ ज़ माहुप्‍के।” ");
INSERT INTO kjl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","है जैद थैद वाज़ युँ हुप्‍ज़्‍या — नो थैन्‍या ते ख्रीसए ओपाँ ज़। ");
INSERT INTO kjl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","हितावत ब नो परमेस्‍वरए ओपाँत यायुँ माहुबो इस्राएलीराए ‘गेमाथैए’ लिन्‍या काता निउँ ज़ माले। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “परमेस्‍वरए ओपाँ सथैज़्‍यावराए यार्गा संसार भरिल थास्‍द ले। यापाँ ब काना कुनीङ पै केस्‍द ले।” ");
INSERT INTO kjl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","हिताव ताकिन इस्राएलीराए यामाबुझिउ ते माःक। नोराए जूँनी मोसाए ङ़ादा ज़ अइ लिद सर्द नैव, परमेस्‍वरए है लिज़्‍या, “छुत जातलाव मिँरालाई रँःद, जेमी तून्‍या ङाजैचिरिज़्‍या। ङामिन मासैंज़्‍यावराए याल्‍योनी जेरिस ब सोचोइद ङायाचिरिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","यसैयाए ओपाँ झन ज़ कर्रा जैद इतावनी ज़ सर्द नैद यायो, “ङालाई खिम ज़ माखिम्‍ज़्‍यावराए ल्‍योक ङासरैंःसिके। पजै ज़ मापजैज़्‍यावरास ङादैसिके।” ");
INSERT INTO kjl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","खाली इस्राएलीराए जूँनी ते इताव ज़ लिज़्‍या, “जे बनै अखत्‍यासो मामुइलिउ मिँरालाई ‘हुचिके’ लिद ङाकुइ थाँद नैद ङायाचिक ब जेमाहुके।” ");
INSERT INTO kjl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","हितावत मनी उमीं इस्राएलीरालाई परमेस्‍वरए माराऱासो। ङा मनी इस्राएली ज़, अब्राहामनिकाव बेन्‍यामीनए ओथोलाव मिँ ज़। ");
INSERT INTO kjl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेस्‍वरए ङ़ादाकिनकाव थ·रैद ओरानैज़्‍याव उमींरालाई माराऱासो। आवए उजूँनी धर्मसास्‍त्रलाव सर्सिउ एलियाए ओपाँ ब तखेप चिऊव ताके। नोए इस्राएलीरालाई रँःद बनै हार मानिद अइ लिद पाँके, ");
INSERT INTO kjl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“अ परमेस्‍वर, नअगमबक्तारालाई यारासैःकेर। नँलाई चरैःन्‍या थानर ब यारातैःकेर। बाँचिउ ङा वाज़ ङालिज़्‍या। ङालाई ब सैःन्‍याए जूँनी खिमो ज़ नैनाज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","परमेस्‍वरए ओजवाप फरी अइ लिद हुके, “माःक, बाल देवताए ओसेवा मादोज़्‍यावर सात हजार ङामींर लिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","हो मिताव ज़ आज्‍याल मनी इस्राएलीराए खार्ल परमेस्‍वरए ओदयानी ओराछाँतिउ उमींर अझ लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","खाली नोर या यादोव य़ेननी मातार, परमेस्‍वरए ओदयानी वाज़ ताकेर। हिताव ओमाताव ताकिन दया ते अऩाकलाव ज़ तान्‍या ओल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","है जैद इस्राएलीराए यानी ज़ परमेस्‍वरए ओयेम खिम्‍द ते मादैकेर। याखार्लाव परमेस्‍वरए ओराछाँतिउराए वाज़ दैकेर। उपुर्कावर झन ज़ यायुँ खाव तानाके। ");
INSERT INTO kjl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","धर्मसास्‍त्रल मनी इतावनी सर्सिउ लिज़्‍या — “परमेस्‍वरए नोरालाई ङ़ल्‍द लिज़्‍याव मितावर ज़ याजैक्‍यो। यामी लिज़्‍यावत ब मारँःधुर, यार्ना लिज़्‍यावत ब माथैधुर। आज्‍याल पै ब हिताव ज़ लिज़्‍यार।” ");
INSERT INTO kjl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","हो मिताव ज़ दाऊद राजाए ब अइ लिद सर्द नैव, “नोराए याभत्‍यार ज़ याघुर्धुम ओताक, नोर नल ज़ तेद सजा ओदैरक। ");
INSERT INTO kjl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","यामी मारैंःद छाम छामोर ओतारक। नोराए यावाँः एकम्‍न्‍या घोंत्‍यासो ज़ उलिक।” ");
INSERT INTO kjl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ङा जेलाई है ङादाचिज़्‍या, इस्राएलीर त़ुम्‍द धलिउका धलिउ याताव ते माःक। नोराए बुरू परमेस्‍वरए ओपाँ यामाभैंःवए परमेस्‍वरए ओपाँ छुत जातलाव मिँराए ल्‍योक ब हुके। ननी ज़ परमेस्‍वरए इस्राएलीरालाई यामी तून्‍या याजैक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","नोराए परमेस्‍वरए ओपाँ माभैंःद तँदा याबावनी परमेस्‍वरए ओअसिक संसार भरिल रा·सिद छुत जातलाव मिँराए ल्‍योक ब ओबावए, नोर या मनी याभैंःवत प़ाइँलाई झन ज़ चाव ताया। ");
INSERT INTO kjl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","14","आव पाँ भरी जे यहूदीकिन छुत जातलाव मिँरालाई है ङादाचिज़्‍या। परमेस्‍वरए ङालाई जेल्‍योदा ओल ओपाँ सथैन्‍यात ओसाची परींद नैनाव। हो ताकिन कसा ङाभेरा यहूदीर जेस खिस्‍द यायुँ परमेस्‍वरए ल्‍योदा माफर्कैर लिद जेस ङादोज़्‍याव य़ेन नोराए याङ़ाक बनै ङासघ्योःज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","परमेस्‍वरए नोरालाई ओराऱासोनी मानुवाताव मिँरालाई ओनैंर ओराजैवए, नो ओराऱासोरालाई फरी ओरारैकिन सिउनी ओरासोचोइव मितावर ज़ ताखेरहो। ");
INSERT INTO kjl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","मुछिसिउ कनेनी तोचोप परमेस्‍वरलाई चरैःकिन कने भरी प़ाइँ ज़ चोखो ताज़्या। हिताव ज़ सींए ओजरा चोखो ओताकिन ओखार भरी ब चोखो ज़ ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","हितावत ब ख्‍वा यहूदीर जैतून सींए ओखारर च़म्सिउ मिताव ज़ लिज़्‍यार। जे छुत जातलावर फरी ज्‍याँलाव सीं स्‍यासोर जेल्‍यो। परमेस्‍वरए जेलाई रैद जैतून सींए ओक्‍याँत जोरैद ओरस दैन्‍या जैचिक्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","है जैद नो ङ़ादाङाव खारराकिन जे तास॰च्‍यो। जे खारराए जरालाई अदैद जेनैज़्‍याव माःक, जराए ची जेलाई अदैद नैचिउ। ");
INSERT INTO kjl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","जे है जेलिज़्याखेहो, “नो च़म्सिउ खारराए पोल परमेस्‍वरए गेलाई ची ओजोरैसिउ ओल्‍यो।” ");
INSERT INTO kjl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","नो ते साचो ज़, नोर यायुँ ओमाहुबोए परमेस्‍वरए सींतिन याच़म्क्‍यो। खाली जे ते जेयुँ उहुबोनी वाज़ जोरैसिउर जेताके। है जैद जे छे·द लिचिके, तास॰च्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","परमेस्‍वरए साचो ओखाररालाई बाँखी ओमारानैकिन जेलाई मनी बाँखी नैन्‍या माले। ");
INSERT INTO kjl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ननी ज़ परमेस्‍वरए उरिस ब रैंःज़्‍या, ओदया ब रैंःज़्‍या। नो च़म्सिउरालाई उरिस ताके, जेलाई ओदया ताके। खाली जे ओदयाल ल्‍यो ज़ ताके, म़ानी जेलाई मनी च़म्‍न्‍या ओछ्यास लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","नो च़म्सिउर फरी यायुँ उहुप्‍किन परमेस्‍वरए नोरालाई ङ़ादाङाव यापोल ज़ जोरैधुन्‍या ब ले। ");
INSERT INTO kjl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","जे छुत जातलाव ज्‍याँलाव सीं स्‍यासोरालाई रैद चाव सींए ओक्‍याँत ओजोरैचिउए, साचो ओखाररालाई झन या यासींत कै जैद माराजोरैवके? ");
INSERT INTO kjl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","अ ङानैं ङामेंर, जेलाई तोबो कप्‍सिउ पाँ सतैंद ङायाचिरिज़्‍या। नो पाँ जेसैंकिन यहूदीराकिन सघ्योःसिन्‍या जेमाले। नो पाँ आव ज़ — परमेस्‍वरए ओराज्‍याल छुत जातलाव मिँर यामादुमा पै वाज़ इस्राएलीर परमेस्‍वरए ओपाँकिन तँदा तान्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","हाःकिन इस्राएली भरिए परमेस्‍वरए ओयेम दैद बाँचिन्‍या लेर। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “बाँचैज़्याव सियोननी हुरिज़्‍या, याकूबए ओथोनी अधर्मलाव य़ेन भरी ब हाइद्यान्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ङा नोराए यापाप हाइद ङारायोत ङाबाचा भरी नत ज़ यो·न्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","आज्‍याल ते नो इस्राएलीर आव गेरासथैज़्‍याव चाव थानी ते परमेस्‍वरए उसुतुर मितावर ज़ लिज़्‍यार। ननी ज़ जेलाई फाइदा ब ताके। खाली यासाखा पुर्खारालाई परमेस्‍वरए ओरायो य़ाकानी ते उयुँ नावर ज़ लिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","परमेस्‍वरए ओय़ाकालाई खर्क ज़ फिस्‍को माजैव, ओराछाँतिउ उमींरालाई ब माराऱासो। ");
INSERT INTO kjl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ङ़ादा जे छुत जातलाव मिँराए परमेस्‍वरए ओपाँ जेमादोज़्‍याव। हितावत ब इस्राएलीराए परमेस्‍वरए ओपाँ यामाभैंःवए जे परमेस्‍वरए ओदया दैन्‍यार जेताके। ");
INSERT INTO kjl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","नोर मनी परमेस्‍वरए ओपाँ यामाभैंःदी ब, जे परमेस्‍वरए ओदया जेदैवए तछा नोराए मनी दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","परमेस्‍वरए ओदया सतैंन्‍याए जूँनी प़ाइँलाई यामन लागिउदा तखेप याऱास्‍ज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","परमेस्‍वरए ओगहक उबुद्धी बनै अचम्‍बलाव लिज़्‍या। परमेस्‍वरए ओथ·रैव पाँलाई सुए ज़ मापल्‍तैधुर, ओदोज़्‍याव य़ेन ब सुए ज़ माथ·रैधुर। ");
INSERT INTO kjl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","धर्मसास्‍त्रल ब अइ लिद सर्सिउ लिज़्‍या, “परमेस्‍वरए उयुँलाव पाँलाई थ·रैन्‍या सु ची उलिज़्‍यावदा? नोलाई सल्‍ला यान्‍या सु ची उलिज़्‍यावदा?” ");
INSERT INTO kjl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“परमेस्‍वरए सुए ल्‍योनी ची लोस्‍द लोइ धूँल उलिज़्‍यावदा?” ");
INSERT INTO kjl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ताज़्‍याव भरी ओल ओल्‍योनी ज़ ताज़्‍या, ओल उजूँनी ज़ ताज़्‍या, ओल उमींर ज़ ताज़्‍या। है जैद परमेस्‍वरलाई खर्क ज़ माखेम्‍न्‍या ज़गै मगैव ओताक। आमेन। ");
INSERT INTO kjl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","है जैद ङानैं ङामेंर, परमेस्‍वरए जेलाई उयुँ नावर जैद ओदयार सतैंद ओयाचिउए आव तोबो पाँत ङाबिन्‍ती लिज़्‍या — जे परमेस्‍वरलाई ओज़्‍यास्‍ज़्याव मिताव य़ेन छैंवनी दाद, जेक्‍याँ भरी ओललाई चरैःचिके। परमेस्‍वरए साचो ओसेवा दान्‍या ननी ज़। ");
INSERT INTO kjl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","आव जुकलाव लन्‍थादा जेयुँ ताझाःच्‍यो। बुरू जेयुँलाई त़ोद साःरो जैचिके। हो ताकिन वाज़ परमेस्‍वरए काता ओपैंज़्‍याव हो सैंन्‍या जेले। है जैद काताकाव चाव उलिज़्‍याव, परमेस्‍वरलाई काताए खुसी ओजैज़्‍याव स़ोनो पक्‍का काता उलिज़्‍याव, हो ब चबनै सैंन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","परमेस्‍वरए ङाल्योदा उयुँ ओगराँवए ज़ जे प़ाइँलाई है ङादाचिज़्‍या — जे तास॰च्‍यो। बुरू मासघ्योःसिद परमेस्‍वरए ओयाचिउ युँ हुप्‍न्‍या खावाकाव जेस उलिज़्‍याव हाःवाकाव ज़ जेक्‍याँलाई थ·रैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","किताव गेक्‍याँताव गेखँ गेकुइर छुत छुत ताद सु सु याय़ेन ब लिज़्‍या, ");
INSERT INTO kjl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","हिताव ज़ गे ख्रीसए उमिनतावर छुत छुत गेलिदी ब ख्रीसनी तक्‍याँ ज़ गेताज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","है जैद परमेस्‍वरए ओयासिउ गोइँनी सु सु गेबरदान छुत छुत ओतावए हो मितावनी ज़ दोव ताके। परमेस्‍वरए उपुरूसनी पाँज़्‍यावए परमेस्‍वरए ल्‍योनी ओदैव गोइँनी ज़ ओपाँक। ");
INSERT INTO kjl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","सेवा दाज़्‍यावए सेवा ज़ ओदोवक। परमेस्‍वरए ओपाँ पैज़्‍यावए ओसैंव भरी ओरापैवक। ");
INSERT INTO kjl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","परमेस्‍वरए ओपाँत यायुँ सझेंःद्याज़्‍यावए झन ज़ सझेंःद ओरायोक। याज़्‍यावए उकुइ सघ्योःद ओरायोक। हक दैवए गहकस य़ेन ओचलैवक। उयुँ नाज़्‍यावए उयुँ माकैद ज़ ओदोवक। ");
INSERT INTO kjl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","जे जेल खैन्‍या साचो युँनी ज़ ओताक। माचाव पाँलाई सोद, चाव पाँत खदेप ल्‍यो ताके। ");
INSERT INTO kjl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","जे तोबो फूलाव मितावर जेतावए जे जेल समारिसिउ ताके। जे जेल क्‍याँकिन छुतए ओमान ब नैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","परमेस्‍वरए ओसेवा धेङ्गै मादाद छैंव पुरूसनी कलँ लिद दोच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","परमेस्‍वरनिकाव जेदैव आसत रेंद ज़ लिच्‍यो, दुखलाई सहिच्‍यो, एकम्‍न्‍या पोंखारिउ ज़ नैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","परमेस्‍वरए उमिनताव जेनैं जेमेंरालाई माथैंव मायो·वल यारासघैच्‍यो। जेझ़िमक हुव पाहुनारालाई चावस यारानैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","जेखिरी पसिज़्‍यावरालाई ताराथल्‍च्‍यो, बुरू परमेस्‍वरए ल्‍योनी असिक याराएच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","रेंज़्‍यावरास रेंचिके, घर्ज़्‍यावरास घर्चिके। ");
INSERT INTO kjl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","जे जे खैद लिच्‍यो। मासघ्योःसिद, ज़िम्‍ज़ारास मनी खदेप लिच्‍यो। ‘जे वाज़ बनै सैंन्‍या’ ताजैसिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","माचावलाई माचाव फर्कैद ताएच्‍यो। जेदोज़्‍याव भरिल जेपाँःच्‍या तापुलुस्‍क। ");
INSERT INTO kjl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जेधुवा भरी प़ाइँ मिँरास खैद लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ङानैं ङामेंर, सुए ओक्‍याँत ज़ जेखिस ताफेरैच्‍यो। बुरू नो पाँ परमेस्‍वरलाई याद ओलस ज़ नैचिके। धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “परमेस्‍वरए है लिज़्‍या, खिस फेरैद्यान्‍या ङा ङालिज़्‍या।” ");
INSERT INTO kjl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“जे ते जेसुतुर ओकरेकिन ओकरे सैःदिचिके। ऱी ओछोस्‍किन उऱीछो सैःदिचिके। ननी ज़ ओङ़ैनी भुबुराए जेरालो मिताव तान्‍या ले।” ");
INSERT INTO kjl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","है जैद माचावलाई माचावनी हारैन्‍या माःक, माचावलाई बुरू चावनी हारैन्‍या ची। ");
INSERT INTO kjl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","प़ाइँ ज़ घेप्‍पा हक दैवराए धूँल उलिरक। हक भरी ओल परमेस्‍वरनी ज़ हुज़्‍या। हक दैवर मनी परमेस्‍वरए ओराखतैवर ज़। ");
INSERT INTO kjl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","है जैद हक दैवराकिन जो तँदा जैसिज़्‍या, हो परमेस्‍वरए ओपाँकिन तँदा ओजैसिउ मिताव ज़ लिज़्‍या। नितावराए परमेस्‍वरनी सजा दैन्‍या लेर। ");
INSERT INTO kjl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","चाव य़ेन दाज़्‍यावर हक दैवराए ल्‍योनी छे·व मापरिए, माचाव य़ेन दाज़्‍यावर वाज़ छे·व परिज़्‍या। है जैद हक दैवरालाई रँःद माछे·द लिन्‍या ताकिन चाव य़ेन ज़ दोव ताके। हो ताकिन ची सजाए ओपोल ‘स्‍याबास’ दैन्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","होए जेजूँनी परमेस्‍वरए ओखतैव य़ेन दोज़्‍याव। है जैद माचाव य़ेन दान्‍यात छे·च्‍यो। हक दैव मिँए ओतरवाली अइज़ सतैंद नैसिउ वाज़ माःक, परमेस्‍वरए ओय़ेन ज़ दोज़्‍याव। माचाव य़ेन दाज़्‍यावए ओक्‍याँत परमेस्‍वरए ओसजा सयो·दिज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","है जैद हक धूँल ल्‍यो ज़ परिके — खाली सजा रँःद वाज़ माःक, ‘आव य़ेन ज़्‍यासो ज़ लिज़्‍या’ लिद दोव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","सरकारए ल्‍योदा सिर्मा जेफो·क ब नो पाँ चेतैव ताके। सरकारए ओय़ेन दाज़्‍यावराए प़ाइँए जूँनी परमेस्‍वरए ओय़ेन ज़ दोज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","है जैद याव परिन्‍यालाई एचिके। सिर्मा फो·न्‍याल सिर्मा फो·चिके, दोरो फो·न्‍याल दोरो फो·चिके, छे·व परिन्‍याल छे·चिके, मान नैव परिन्‍याल मान नैचिके। ");
INSERT INTO kjl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","काताए ओभार धूँल ब तालिच्‍यो। खाली जे जेल खैद समारिसिन्‍या भार वाज़ ओताक। छुतलाई समारिन्‍यानी परमेस्‍वरए ओकानुन ब यो·ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","परमेस्‍वरए ओकानुनल, “अर्काए ओज्‍याए ल्‍योदा माबान्‍या, मिँ मासैःन्‍या, माकुन्‍या, लोभ मादान्‍या,” लिद सर्सिउ लिज़्‍या। आव पाँर स़ोनो उपुर्काव कानुनलाव पाँ भरी ओपो·स ज़ आव तोबो पाँत थोम्‍सिज़्‍या — “जेक्‍याँलाई किताव जेसमारिज़्‍या, छुतलाई ब हिताव ज़ समारिउ ताके।” ");
INSERT INTO kjl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","छुतए ल्‍योदा उयुँ थू जैद समारिज़्‍याव मिँए सुलाई ज़ माबले·व। है जैद छुतलाई समारिन्‍यानी ज़ कानुन भरी यो·ज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","है जैद बेला सैंद, है ङादाचिउ भरी दोचिके। ङ़ल्‍द लिन्‍या माःक, सैंसिद लिच्‍यो। परमेस्‍वरए ओपाँल गेहुव छ्यामकिन ख्रीस उहुन्‍या छ्याम नजिक हुद ले। ");
INSERT INTO kjl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","री कुधु बाधुके, नम सँन्‍या बेला हुके। है जैद चुम चुमोलाव य़ेन भरी ऱास्‍द ज़गैवलाव य़ेन दोव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","पलाँवल ओसहिज़्‍याव मिताव ओतह ल्‍यो य़ेन दोव ताके — तुबुरी दुलिद राउँनी झ्याउँ लिन्‍या ब माःक, मँःन्‍या ब माःक, पातर्‍या पातर्नी जैसिन्‍या ब माःक, कोभादा बान्‍या ब माःक, मी तूद इ़सिन्‍या ब माःक। ");
INSERT INTO kjl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","बुरू नोए ओपोल गेप्रभु येसु ख्रीसए ओगे रैद, ङ़ादाङाव जेयुँ मानैधुद माचाव जेखिमो भरी वैंद उमिन सम़ैद्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","चाव माचाव माछुतैधुज़्यावलाई सुम्‍च्‍यो, ओपाँलाई सज़िम्‍द्याद इ़सिन्‍या ताजैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ख्वाराए ज़्‍यान्‍या भरित यायुँ हुप्‍द ज़्‍युज़्‍यार। ख्वाराए फरी यायुँ जाँ ओमाहुबोए स्‍याकरी माकैर। ");
INSERT INTO kjl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","नो प़ाइँ ज़्‍युज़्‍यावए माज़्‍युज़्‍यावलाई तासोवक। हिताव ज़ फरी माज़्‍युज़्‍यावए प़ाइँ ज़्‍युज़्‍यावलाई, ‘माज़्‍यान्‍या ज़्‍युक्‍यो’ है तादोवक। परमेस्‍वरए ऩेथोलाई ज़ उमींर जैद यानैव। ");
INSERT INTO kjl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","अर्काए ओबाँदालाई फाल्‍न्‍या नँ सु? नोए ओदोज़्‍याव य़ेन चाव सैं माचाव लिद फाल्‍न्या ओसाहुए ची। है जैद ओय़ेन थ·रैद्यान्‍या ओर्गे परमेस्‍वरए ची। होए ज़ नोलाई चाव य़ेन दान्‍यात सघैज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ख्वाराए उपुर्काव छ्यामकिन तोबो छ्यामलाई घेप्‍पा जैज़्‍यार। ख्वाराए फरी प़ाइँ तोबो ज़ थ·रैज़्‍यार। जो मितावनी तादी ब सु सु युँल ज़ थ·रैव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","नो तोबो छ्यामलाई घेप्‍पा मानिज़्‍यावए मनी परमेस्‍वरए उजूँनी ज़ दोज़्‍याव। प़ाइँ ज़्‍युज़्‍यावए मनी परमेस्‍वरलाई धन्‍याबाद चरैःद ज़ ज़्‍युज़्‍याव। स्‍याकरी माकैज़्‍यावए परमेस्‍वरलाई चेतैद ज़ माकैव। होए ब परमेस्‍वरलाई धन्‍याबाद चरैःज़्याव। ");
INSERT INTO kjl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","गे सु मनी गेजूँनी गेमाबाँचिए, सु मनी गेजूँनी गेमासिए। ");
INSERT INTO kjl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","गेबाँचिदी ब परमेस्‍वरए उजूँनी ज़ गेबाँचिज़्‍या, गेसिदी ब परमेस्‍वरए उजूँनी ज़ गेसिज़्‍या। है जैद जुनी ब उमींर ज़ गेलिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ख्रीस सिउ मासिउराए गेप्रभु तान्‍याए जूँनी ज़ सिद सैंसिके। ");
INSERT INTO kjl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","हिताव ताकिन ते जेसकाव जेभाइए जाँ छुत य़ेन ओदोक काराव माचाव जेङम्सिज़्‍याव? काराव स॰द नोलाई जेसज़िम्‍ज़्‍याव? गे प़ाइँ ज़ परमेस्‍वरए ओङ़ाक च्‍याँःसिद तछा गेफाल्‍सिरिज़्‍या लिन्‍या चेतैच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","धर्मसास्‍त्रल मनी अइ लिद सर्सिउ लिज़्‍या, “प्रभुए है लिज़्‍या, ङा साचो है ङालिज़्‍या, मिँ भरी प़ाइँ ङाङ़ाक फुलुप्‍सिन्‍या लेर। प़ाइँए परमेस्‍वरए उमिन सघ्योःन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","है जैद गे भरी प़ाइँ सु सु गेय़ेन परमेस्‍वरलाई है दाव परिरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","है जैद जे तोबोए तोबोलाई ओय़ेन गल्‍ती थ·रैद ताएच्‍यो। बुरू छुतलाई उयुँ केःद्यान्‍या पाँ मादान्‍या थ·रैव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","गेप्रभु येसुलाई ङायुँ उहुबोए ङा है ङालिज़्‍या, माज़्‍यान्‍या काता ज़ माले। हैदी ब जोए उयुँल, ‘आव ते माज़्‍यान्‍या ज़’ लिद थ·रैज़्‍याव, नोलाई माज़्‍यान्‍या ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","है जैद नोलाई ज़्‍यावए जूँनी उयुँ केःद जेएकिन नोलाई मया जेमादोव मिताव ज़ ताके। है जैद ख्रीसए उजिउ झाःद ओयो मिँलाई जे ज़्‍यान्‍यानी परमेस्‍वरए ओपाँत ओजाँगर सैःद ताएच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","है जैद जे जो चाव जेथ·रैज़्या, हो छुतए माचाव है ल्‍यो तादैवक। ");
INSERT INTO kjl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","परमेस्‍वरए ओराज्‍यालाव पाँ ज़्‍यान्‍या ओन्‍याए जूँनी माःक। नो पाँ ते आव ज़ — परमेस्‍वरए उयुँलाव मिताव य़ेन दान्‍या, खैद लिन्‍या, स़ोनो छैंव पुरूसनी युँ होलाँ दान्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जोए नितावनी ख्रीसए ओसेवा दोज़्‍याव, हो परमेस्‍वरए उयुँलाव मिताव ब ताज़्‍या, मिँराए याजाँगर हुव ब ताज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","है जैद जे जेल खैद प़ाइँलाई सपारैन्‍यात उदिम दोचिके। ");
INSERT INTO kjl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","परमेस्‍वरए ओय़ेनलाई ज़्‍यान्‍यानी ताबले·च्‍यो। ज़्‍यान्‍या भरी प़ाइँ चोखो उलिदी ब जोए ज़्‍याद ओद ओभाइलाई उयुँ केःद ओएकिन, नोलाई माज़्‍यान्‍या ज़ पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","नो जेभाइलाई जेबले·ज़्‍याव देखा बुरू स्‍याकरी माकैन्‍या, स़ोनो मद छोकोरा माओन्‍या पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","है जैद दान्‍या जेथ·रैव भरी परमेस्‍वरए ओङ़ाक जेयुँल पक्‍का ज़ थ·रैव ताके। जोए ओथ·रैव पाँत उथुपुल ओमालिकिन नोलाई पाथ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","खाली जोए सङ्खा दाद उज़्‍युकिन ओलनी ज़ ओखत ल्‍यो थ॰रिज़्या। युँ माहुप्‍द दान्‍या भरी पाप ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","गे परमेस्‍वरए ओपाँत थ॰रिउराए चाव माचाव माछुतैधुज़्यावराए यापाँ सहिद्याव ताके। क्याँलाई तान्या वाज़ दान्‍या माःक। ");
INSERT INTO kjl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","गे प़ाइँए छुतलाई सपारैन्‍याए जूँनी ओललाई तान्‍या य़ेन दाद्याद खुसी जैव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ख्रीसए मनी ओललाई तान्‍याए जूँनी मादोक्‍यो। हिताव ज़ धर्मसास्‍त्रल ब अइ लिद सर्सिउ लिज़्‍या, “नँलाई याथल्निउ भरी ङा ङाक्‍याँत ज़ हुद ले।” ");
INSERT INTO kjl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","नो भाःङाव धर्मसास्‍त्रलाव सर्सिउ भरी गेजूँनी ज़ लिज़्‍या। ननी ज़ य़ेन भरी पैसिद गेयुँर होलाँ ओताज़्‍यावए दुखर उहुदी ब ननी ज़ थ॰रिद गेआस लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","है जैद युँ होलाँ जैद्याद थ॰रिउ जैज़्‍याव परमेस्‍वरए, येसु ख्रीसए उमींर जेतावए जेलाई तयुँ ओजैचिउक। ");
INSERT INTO kjl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","हो ताकिन ची जे प़ाइँए ज़ तयुँ तपाँ जैद गेप्रभु येसु ख्रीसए ओबाबु परमेस्‍वरलाई उमिन सघ्योःद्यान्‍या जेले। ");
INSERT INTO kjl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","है जैद जे परमेस्‍वरए उमिन सघ्योःद्यान्‍याए जूँनी किताव ख्रीसए गेलाई सहिद उसुम्‍सिउ, जे जेल ब सुम्‍सिचिके। ");
INSERT INTO kjl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ङा जेलाई है ङादाचिज़्या, ख्रीसए मनी यासाखा पुर्खारालाई परमेस्‍वरए ओरायो य़ाका भरी साचो ज़ थ·रैद्यान्‍याए जूँनी यहूदीराए यासेवा दान्‍या जैसिहुके। ");
INSERT INTO kjl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","छुत जातलावराए मनी ‘परमेस्‍वरए ओदया गेलाई ब ताके’ लिद उमिन सघ्योःद्यान्‍या लेर। धर्मसास्‍त्रल मनी अइ लिद सर्सिउ लिज़्‍या, “ङा छुत जातलावराए याखार्ल मनी नमिन सघ्योःद्यान्‍या ङाले। नमिनताव भजन ब गैन्‍या ङाले।” ");
INSERT INTO kjl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फरी तोथोल इताव मनी लिज़्‍या, “अ छुत जातलाव मिँर, परमेस्‍वरए उमींरास जे ब रेंचिके।” ");
INSERT INTO kjl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","फरी तोथोल इताव मनी लिज़्‍या, “अ छुत जातलाव मिँर, परमेस्‍वरए उमिन सघ्योःदिचिके। संसार भरिलाव मिँराए मनी उमिन ओसघ्योःरक।” ");
INSERT INTO kjl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","यसैयाए मनी अइ लिद सर्द नैव, “यिसैए ओथोनी तोबो हुरिज़्‍या। नो छुत जातलावराए याङ़ैताव ब तारिज़्‍या। नोए ओक्‍याँत छुत जातलावराए ब आस दान्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","जेलाई मनी नो आस दाद जेनैज़्‍याव परमेस्‍वरए, ओललाई जेयुँ जेसुहुबोए जेयुँ होलाँ जैद रेंद लिन्‍या ओजैचिउक। हो ताकिन ची छैंव पुरूसए ओसक्तीनी जेआस ब झन ज़ घ्योःन्‍या ले। ");
INSERT INTO kjl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","अ ङानैं ङामेंर, जे परमेस्‍वरए ओपाँर सैंद, धर्मलाव य़ेनर दाद, जे जेल जेसुदारैसिज़्‍याखेहो लिद ङायुँ हुबो ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","हितावत मनी परमेस्‍वरए ङालाई उयुँ नाद ओखतैनावए जेलाई सम्‍जैन्‍याए जूँनी तोबो ऩेब्‍लो जाँ नास्‍न्‍या मिताव पाँर सर्द नैद ङायाचिए। ");
INSERT INTO kjl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","नो ओखतैनाव य़ेन जे मिताव छुत जातलाव मिँरालाई येसु ख्रीसए ओपाँ सथैद ओसेवा दान्‍या ज़। है जैद नलाव ङाय़ेन पुजारी य़ेन स्‍यासो लिज़्‍या। जेलाई छैंव पुरूसनी जेखत माल्‍यो छैंवर जैद परमेस्‍वरए उयुँलाव मितावर ङाजैचिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","है जैद परमेस्‍वरए उजूँनी ङादोज़्याव ङाय़ेनत येसु ख्रीसए उमिनत ङासुनी च्याँःसिउ ज़ लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","खाली ङा ङादोवत माःक, ख्रीसए ङाक्याँताव ओदोव य़ेनत वाज़ सघ्योःद ङापाँज़्‍या। है जैद ख्रीसए ङाक्याँताव ओदोव ङाय़ेननी स़ोनो ङापाँनी छुत जातलाव मिँराए मनी परमेस्‍वरए ओपाँ भैंःकेर। ");
INSERT INTO kjl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","नो पाँत छैंव पुरूसए ओसक्ती हुद अचम्‍बलाव सरेसर य़ेनर ब सतैंद याएक्‍यो। है जैद यरूसलेमकिन इल्‍लुरिकन खन्‍द पै ख्रीसए चाव ओथा प़ाइँनी ज़ सथैद ङारानै। ");
INSERT INTO kjl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","छुतए ओथालिउलाई पुरा जैद ङामीं ङामाजैए। बुरू जोल ख्रीसए उमिन माथासो लिज़्‍या, होल ज़ सथैन्‍या ङायुँ लिज़्या। ");
INSERT INTO kjl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","धर्मसास्‍त्रल मनी इताव सर्सिउ लिज़्‍या, “ओथा मादैतावराए मनी ओललाई रँःन्‍या लेर, ओपाँ माथैतावराए मनी बुझिन्‍या लेर।” ");
INSERT INTO kjl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","है जैद परमेस्‍वरए ओपाँ माथासो पो पोङ सथैन्‍या ङातावए जेल्‍योदा हुन्‍या ङामाताप्‍के। ");
INSERT INTO kjl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","अब ते नाः भरिल सथैन्‍या ङाय़ेन खेम्‍द ङानै। है जैद ङ़ादाकिन ज़ जेस दैसिन्‍या युँ ङादोज़्‍यावए, ");
INSERT INTO kjl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ङा छींनी स्‍पेन देसदा ङाबाक जेल्‍योलाव घ्याँ हुद जेस दैसिन्‍या आस ङादोज़्‍या। हो बेलाक जाँवा लिद गेमयार सैःद ननी ङाबाक ङालाई जेसघैनाए सैं है ङालिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","खाली ङा आथ पाला यरूसलेमलाव परमेस्‍वरए छैंव उमिनतावराए जूँनी तखेप नदा ङाबाज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","नलाव माथैंव मायो·वरालाई माकेदोनिया स़ोनो अखैयालाव मन्‍दलीराए ङाकुइत रूप्‍यार परींद याराएज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","नो य़ेन यायुँ स्‍यानी ब दोज़्‍यार, दाव परिन्‍यानी ब दोज़्‍यार। निताव छुत जातलाव मिँराए परमेस्‍वरए ओअसिक यहूदीराए ल्‍योनी यादैवए, नोराए मनी यहूदीरालाई माथैंव मायो·वल यान्‍या ज़्‍यासो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","है जैद ङा नो रूप्‍यार लाँद ङारायोत, स्‍पेनदा ङाबाक जेल्‍योलाव घ्याँ ङाहुरिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","हो बेलाक ख्रीसए ओयाँज़्याव कुधु असिकरास जेल्‍योङ हुन्‍या ङाले। ");
INSERT INTO kjl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","अ ङानैं ङामेंर, जेस ङाबिन्‍ती लिज़्‍या — गेप्रभु येसु ख्रीस स़ोनो छैंव पुरूसए ओयाचिउ मयानी ङा ङादुखराल सघैन्‍याए जूँनी परमेस्‍वरलाई पोंखारिद्याव ताके। ");
INSERT INTO kjl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","जेपोंखारिक, ङा यरूसलेमदा ङाबाक यहूदियालाव येसुए ओपाँ माभैंःज़्‍यावरानी कै मै ताताक, स़ोनो लाँद ङाराएज़्‍याव रूप्‍या नलाव परमेस्‍वरए छैंव उमींरालाई याचाहिज़्‍याव मिताव ज़ ओताक लिद पोंखारिद्याँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","हो ताकिन ची परमेस्‍वरए उयुँ ओताकिन ङा जेल्‍योङ ङाहुक सिप गेयुँर होलाँ जैद रेंन्‍या गेले। ");
INSERT INTO kjl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","युँ होलाँ जैद्याज़्‍याव परमेस्‍वर जेस ज़ बास ओदोवक। आमेन। ");
INSERT INTO kjl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","परमेस्‍वरए उमिनताव गेबैंनी फिबीलाई सरेसो ङापरींचिज़्‍या। नोए किंक्रियालाव मन्‍दलील परमेस्‍वरए ओय़ेनत यासघैज़्‍याव। ");
INSERT INTO kjl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","जे परमेस्‍वरए छैंव उमींराए दाव परिन्‍या य़ेन दाद, प्रभुए उमिनत चावस नैच्‍यो, नोलाई ओचाहिज़्‍याव भरिल सघैच्‍यो। ओल ब कुधुलाई सघैद यानैव, ङालाई मनी सघैद नैनाव। ");
INSERT INTO kjl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ङास येसु ख्रीसए ओय़ेन दाज़्‍याव अकिलास स़ोनो प्रिस्‍किलानिलाई जेरो है दाद्याँच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","नोनी ङाजूँनी कोज़ाइ म़ानी निजिउ ब झाःकिनी। नोनी निगुन ङा वाज़ माःक, छुत जातलाव मन्‍दलीराए ब प़ाइँए ज़ चेतैज़्यार। ");
INSERT INTO kjl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","नोनी निझ़िमकाव दुप्‍सिज़्‍याव मन्‍दलीलाई ब जेरो है दाद्याँच्‍यो। ङायुँलाव ङानैं इपेनितसलाई मनी जेरो लिज़्‍या। नो एसिया भरिल प़ाइँरानी उस॰कत ख्रीसए ओपाँत हुव मिँ ज़। ");
INSERT INTO kjl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","जेजूँनी सैःसिवा जैसिद जेय़ेन दोव मरियमलाई मनी जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ङास झ्यालखानाल ल्‍यो यहूदी ङानैं एन्‍द्रोनिकस स़ोनो युनियसनिलाई जेरो लिज़्‍या। नोनी निमिन येसुए ओसाचीराए खार्ल थासो लिज़्‍या। नोनी ङाकिन ङ़ादा ज़ ख्रीसलाई नियुँ हुबोनी निल्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","प्रभुए उमिनताव ङायुँलाव ङानैं एम्‍प्‍लीआतसलाई जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ख्रीसए जूँनी गेस य़ेन दोज़्‍याव उर्बानस स़ोनो ङायुँलाव ङानैं स्‍ताखुसलाई पाला जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ख्रीसए उमिनत थ॰रिउ अपेल्‍लेसलाई जेरो लिज़्‍या। अरिस्‍तोबुलसए उझ़िमलावरालाई ब जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","यहूदी ङानैं हेरोदियनलाई जेरो लिज़्‍या। प्रभुलाई यायुँ हुप्‍ज़्‍याव नर्किससए उझ़िमलावरालाई जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","प्रभुए ओय़ेन कुधु दाज़्‍याव त्रुफेना स़ोनो त्रोफोसा ङाबैंनीनिलाई ब जेरो लिज़्‍या। परमेस्‍वरए ओय़ेन सैःसिवा जैसिद दोज़्‍याव ङायुँलाव ङाबैंनी परसीसलाई ब जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","प्रभुए उरूजिउ रूफसलाई स़ोनो ओआमालाई पाला जेरो लिज़्‍या। नोए ओआमा ङा ब ङाआमा स्‍यासो ज़। ");
INSERT INTO kjl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असिंक्रितस, फ्लेगन, हर्मेस, पत्रोबास, हर्मास स़ोनो नोरास लिज़्‍याव गेदाज्‍यु भाइरालाई प़ाइँलाई ज़ जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलोलोगस, युलिया, ओलिम्‍पास, नेरियस, ओल ओबैंनी स़ोनो नोरास लिज़्‍याव परमेस्‍वरए छैंव उमींरालाई प़ाइँलाई जेरो लिज़्‍या। ");
INSERT INTO kjl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आव जेरो जे जेल ब मयास है दासिच्‍यो। पो पोङाव ख्रीसए ओमन्‍दलीराए मनी जेरो है दाचिज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","अ ङानैं ङामेंर, जेस फरी ङाबिन्‍ती तोबो लिज़्‍या — फातैज़्‍यावरास जोगोइसिद लिच्‍यो। जेलाई पैसिउ परमेस्‍वरए ओपाँ तँदा बले·द जेयुँ जेसुहुबोलाई बले·द्याव पैंज़्यार। है जैद जे नितावरानी अछतङ लिच्‍यो। ");
INSERT INTO kjl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","नोराए गेप्रभु ख्रीसए ओसेवा मादोर, याभूँदीए ओसेवा वाज़ दोज़्‍यार। यायाःत रग रग जैद लातो गाँदोरालाई याराधुतैज़्‍यार। ");
INSERT INTO kjl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","खाली जे ते परमेस्‍वरए ओपाँ चावस जेदोज़्‍याव प़ाइँए ज़ थैद नैर। होए जूँनी जेस ङा बनै खुसी ङालिज़्‍या। है जैद जे चावत बनै सैंन्‍यार ताच्‍यो, माचावत जेखत माल्‍योर ताच्‍यो। ");
I