﻿USE sofia;
DROP TABLE IF EXISTS sofia.kjeNT_vpl;
CREATE TABLE kjeNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kjeNT_vpl WRITE;
INSERT INTO kjeNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristus upun a'an: Yesus eni rai Daud upun anan; Daud eni Abraham upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham na'ori Isak, Isak na'ori Yakup, Yakup na'ori Yehuda noro mo'oniwalinhe idaweli ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda na'ori Peres noro Zerah (woro'o eniyenihe inna naran Tamar) Peres na'ori Hezron, Hezron na'ori Ram, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram na'ori Aminadab, Aminadab na'ori Nahason, Nahason na'ori Salmon, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon na'ori Boas (Boas eniyeni inna naran Rahab), Boas na'ori Obed (Obed eniyeni inna naran Rut), Obed na'ori Isai, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","la Isai na'ori Daud ma namwali rai Israel. Daud na'ori Salomo (Salomo eniyeni inna naran Batseba, la nonolu Uria hono ma namwalumedi). ");
INSERT INTO kjeNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo na'ori Rehabeam, Rehabeam na'ori Abia, Abia na'ori Asa, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa na'ori Yosafat, Yosafat na'ori Yoram, Yoram na'ori Uzia, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia na'ori Yotam, Yotam na'ori Ahas, Ahas na'ori Hizkia, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia na'ori Manasye, Manasye na'ori Amon, Amon na'ori Yosia, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","la Yosia na'ori Yekonya noro mo'oniwalinhe lere Babel enihe keledi Israel, rodi laa rir nohe. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nano lere Babel enihe keledi Israel, Yekonya na'ori Sealtiel, Sealtiel na'ori Zerubabel, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel na'ori Abihud, Abihud na'ori Elyakim, Elyakim na'ori Azur, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azur na'ori Zadok, Zadok na'ori Akim, Akim na'ori Eliud, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud na'ori Eleazar, Eleazar na'ori Matan, Matan na'ori Yakup, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","la Yakup na'ori Yusup man ho Maria. Maria eniyeni mori Yesus man rapolu Kristus. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ende Yesus upun a'anhe nano Abraham rakan Daud, ku rewen idaweli wo'akka; nano Daud rakan lere manin Babel enihe keledi Israel rodi laa rir nohe, ku rewen idaweli wo'akka haenhi; nano lere Israel laa noho Babel rakan Yesus Kristus Nin lere, ku rewen idaweli wo'akka wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lere momori Yesus onneni lirna la'an hi'i heheni: Yesus inna Maria noro aman Yusup, ida ma naledi honorok aki ida me'e, maa ka ramkuru wuku makun. Roh Kudus nodi molollo Maria ihin kemen, penia nornoro raramne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maa, Yusup ka nauroin Roh Kudus nodi molollo Maria kemen makun, de an pene'ek Maria larlewenedi woro'ohe rira honorok aki ma namnehe na'alono me'e. Yusup eni ri man akin mou la namdudu, penia ai namhene wakunu nano'onyaka Maria lolo heri kalarna, de nanoin kalla namehin leke yon ho Maria me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Alam ida nine, Yusup naho'ok nakail nina aki eniyeni mene namkuru la namarmi. Namlilinnohi Makromod Lalap Nin hophopon a'am raram mai nalhari kemen Yusup lolo nina namarmi na'aheni, “Yusup, Daud upun anan o, Tatana man minle Maria ihin kemen onne, Roh Kudus nina molollo, de yon mamka'uk more ho. ");
INSERT INTO kjeNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Rakan Maria nina lere alam nokor, an mori mo'oniyane. Lere onne waki naran Yesus, ono Ai penia man huri we'er Nin ri nano dohohale nin molollo.” ");
INSERT INTO kjeNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Onnenihe na'akeme namwali lekpananne na'akuku na'anokor inhawa Makromod Lalap na'aheniyedi lolo Nin nabi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dernala! Maekrara ida ma kan ho makun nornoro raramne, de moriyana mo'oni ida. Tatan eniyeni rin waki naran Imanuel.” Nano wanakunu Ibrani, naran ‘Imanuel’ napa'ahne, ‘Makromod Lalap aiyedi ik leken kalarna me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusup namake ne, lernohi inhawa man Makromod Lalap Nina hophopon a'am raram hohopon onneni, de ai nala Maria namwali hono, ");
INSERT INTO kjeNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","maa noro Maria ka ramkuru wuku hehen nanumene rakan Maria moriyedi mo'oniyana onneni. Enla Yusup waki naran Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus mori lolo kota Betlehem, noho Yudea, lere rai Herodes nodi molollo noho onne. Ler onne ri Majus woro'o wokelu ma nauroin tada kaliyoro ramhara rano noho wali kimur mai kota Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rakanedi Yerusalem hi ra'ukani, “Emene Tatana man Makromod Lalap nouwedi namwali Rai Yahudi nano nonolu me'eni, mori Ai lolo ewie? Am do'onedi kaliyoro ida ha'a lolo kimur nala tanada mayai nahenia An mori lolo eniyeni, penia am mai leke male ainima hiyene arore.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rai Herodes derne rir na'ukankani ne, ai akin apinha me'e, de ri Yerusalem na'akeme ramka'uk haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Enime'ede an hopon imam-imam lalap noro meser Horok Lap na'akeme lawuku hopun pepen leke na'ukani hi tarana. Ai na'ukani, “Emene ri man Makromod Lalap na'anouwedi namwali Rai Yahudi onne, mori ai lolo ewie?” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hir walha ra'aheni, “Ai onne mori lolo kota Betlehem, noho Yudea, ono nabi ida horokedi na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Eih, Betlehem, o kam tana narehi nano kota lalap man minle noho Yudea, ono nano o, ri ida namwali Rai man leluwai makrana Ainu'u ri mormori Israel.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Enime'ede rai Herodes nodi kalla susuwar napolu Majus ma nauroin tada kaliyoro enihe leke na'ukani hi, “Konohi ya'u lere dedesne paphe do'on kaliyoro onne?” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hir konohiyedi Herodes horu ne, an nou hi na'ahenia, “Mim laa Betlehem manoin Tatana onne wawa'an, la mim do'onedi haromo, wali mam konohi ya'u leke i laa ala ainu'u hiyene arore Ai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Hir derne rai Herodes nin nou horu, hi rala'a me'e. Hi rala'a ne, hi akin senan wake'e ono hir do'on wali'ur kaliyoro dodo'on lolo kimur eni. Kaliyoro onne noluwedi hi rakan Betlehem, ren namlolole onno Tatana miminle wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Enime'ede hir laa nakar onne raram, do'on Tatana onne noro inna. Hir kadi ein korno, rawa rahuwo'ok, la ra'uli rasa'a Ai. Hir hari rir panaku onno leke rala mahe, kemenyan, noro mur, hoikani Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hi rala'a ne, Makromod Lalap nou hi lolo namarmi na'ahenia, “Mim wali laa minim lekloi, yono lolo rai Herodes me'e.” Ende hir wali laa rir lekloi loledi kalla namehin. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ri Majus onne rala'edi ne, Makromod Lalap Nina hophopon a'am raram mai nalhari kemen Yusup lolo namarmi hopon na'ahenia, “Mamakedi! Herodes maha nanoin Tatana onne leke nesne, de mala Tatana noro inna mala'a laa noho Mesir. Min lolo onne rakan lere Ya'u kukunohi mi mamhara.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A'alam onne me'ede Yusup namaka, la noro hono anan rala'a Mesir me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hir min lolo onne hehen nanumene Herodes makiyedi. Ha onnenihe namwali lekpananne na'akuku na'anokor inhawa Makromod Lalap na'aheniyedi lolo Nin nabi na'ahenia, “Ya apolu Ya An'u namhara noho Mesir.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes nauroinnala Majus enihe wuku hapliuredi ne, ai na'ahan rehi, de hopon resne mouwedi tatana mo'oniyana na'akeme ma nin anna woro'o laa yawa lolo kota Betlehem noro leke-leke man aile herne wali-wali enihe. Ai nala panaeku onneni ono majus enihe ra'aheni hir do'on kaliyoro ma nala tanada onne anna woro'o man laedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nina hini'i onne na'akuku na'anokor nabi Yeremia lirna ma na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lolo leke Rama, rin derne sus mak oir mamani. Rahel nina sus mak oir kan horu, de naherhere mamani, ono anan na'akeme resne horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lere Herodes maki, Makromod Lalap Nina hophopon a'am raram nalhari kemen lolo Yusup nina namarmi wali'ur na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mamakedi! Man paeku nesne tataneni makiyedi me'e, de moro tatana noro inna wali wali'ur laa noho Israel.” ");
INSERT INTO kjeNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Enime'ede Yusup namaka, la noro hono ananne wali wali'ur laa Israel. ");
INSERT INTO kjeNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maa an dernedi nahenia Herodes ananne Arkelaus herre wali'ur aman nodi molollo noho Yudea, de ai namka'uk laa enne. Makromod Lalap Nin hophopon a'am raram nou wali'ur lolo nina namarmi nahenia ai noro nakar raram laa noho Galilea, ");
INSERT INTO kjeNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","penia hir laa Galilea ramkene lolo kota Nazaret. Panaeku onne na'akuku na'anokor nabi-nabi lirna ma na'aheni, “Ai onne, rin wekel manin Nazaret.” ");
INSERT INTO kjeNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lere Yesus minle leke Nazaret makun, Yohanis ma nodi oir ulutada ri mai Yudea loikaru Makromod Lalap Lirna Wawan laa ri lolo noho mamun ma napro'uk man ai lolo onne. Ai na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Herre minim morimori ma ka namloleni, la derne makani Makromod Lalap, ono lere Makromod nodi molollo ri mormori wakuraniyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nonolu nabi Yesaya wekel Yohanis eni na'aheni, “Ri ida aile lolo noho mamun ma napro'uk wakaukau na'aheni, ‘Ma'ahari kalla, la ma'anehe, leke Makromod lole.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis eni nin nainair rodi unta wulu hi'ie, nin kali ehe rodi ha mormori ulikne hi'ie, la nina nana'an nonomun poreke noro wani oir. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ri nammori rano Yerusalem, Yudea ne'en raramne na'akeme, noro leke-leke man minle oir wauwau Yordan wali-wali maiwuku, derne Yohanis nin loloi kakaru eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hi meririi werre akin kukunohi rira dohohale nanumene Yohanis norhe laa oir Yordan raram leke ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Enimaa lere an do'on ri Parisi noro ri Saduki nammori mai leke ulutade ne, ai ne'el hi na'ahenia, “Heih, mi eniyenihe ailanna maisa haimoke! Yon makoto mim mai ulutade leke lo'o mahinuriyedi nano hunukum lere man mamai eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Maa lam hi'i ha man wa'an leke ri nauroin mim herredi minima morimori ma ka namloleni, la derne makani Makromod Lalap me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yon makoto mi mamwali Abraham upun anan de kam lernala hunukum. Makromod Lalap peni nodi molollo hi'i waku eniyenihe herre mi namwali Abraham upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Makromod Lalap Nin hunukum na'akeki rakanedi me'e. Lere eni Ai na'akenedi Nin he'i aile au onno me'e. Inhawa au'ono ma kan woi wawa'an, An keri, sopol laedi aiye raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yo odi oir ulutada mi leke namwali tanada mim herredi minima morimori ma ka namloleni, maa yo oluwedi Ri ida man ulutada mi nodi Roh Kudus noro aiye. Ai nodi molollo narehi ya'u, penia ainu'u molollo kaale yo ohu Nina pakpak ei. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ai nodi kokopo ka'i na'amou Nina gandum, loiwuku ihin dakar raram, la osorne sopol laedi aiye man mori mamani raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lere onneni Yesus namhara noho Galilea mai oir wauwau Yordan leke Yohanis ulutade, ");
INSERT INTO kjeNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","maa Yohanis na'okulale na'aheni, “Wa'an rehi Pape ulutada ya'u. Yon Papa napanak ya'u ulutade.” ");
INSERT INTO kjeNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Maa Yesus na'aheni, “Wa'an rehi ors eni ulutade Ya'u leke ik ka'akuku ka'anokor Makromod Lalap Nin honorok panaeku na'akemeni.” Enine ai ne'e, de noro Yesus laa oir raram leke ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus namhara oir wauwau eni ne, namlilinnohi a'am nahinari, An po'on Makromod Lalap Nin Roh naise merpati ida kopur namlololo Ai wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Enla lirida nano a'am raram na'aheni, “E'eni Ya An'u, Ya amre'e amharu. An hi'i Ya akin nahuwa'an rehi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lere onneni Roh Kudus norkaru Yesus laa noho mamun ma napro'uk leke Hayakyak Makromon kene patale. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lere alam weli'akka raram Ai na'aluli kemen ka na'ak, de namlara wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Enine Hayakyak Makromon man ken patal onne, mai na'aheni, “Lo'o namlolo kokkoo Makromod Lalap Anan O, hopon waku eniyenihe namwali hanana'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Maa Yesus walhe, “Makromod Lalap na'aheniyedi lolo Horok Lap raram, ‘Ri kan mori nano hanana'an mehe, maa nano Makromod Lalap Lirna na'akeme haenhi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Onne horu, Hayakyak Makromon norkaru Ai laa Makromod Lalap Nin kota Yerusalem laa onno man kulu wake'e lolo Makromod Lalap Nin Romleu Lape, la na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Lo'o namlolo kokkoo Makromod Lalap Anan O, nehu laa yawa, ono horhorok aile Lirna Wawan ma na'ahenia, ‘Makromod Lalap hopon Nin hophopon a'am raram mai leke radiyaka O. Hir mai paku O leke yom wekur wakue.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus walha, “Maa horhorok aile haenhi ma na'aheni, ‘Yon hi'i ha ma kan min haida modi kene Makrommu, ma namwali Makromod Lalap.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Horu ne, Hayakyak Makromon norkaru Yesus laa wo'or man kulu rehi leke An do'on hair-hair na'akeme noro rira linikir kanaru. An nou Yesus na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ya ala ha onne na'akeme ki O, horo kadi eum korno yawa, ma'uli masa'a ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Maa Yesus walhe, “Hayakyak Makromon o, mala'a here! Horhorok aile man hopon mayai na'ahenia, ‘Ma'uli masa'a Makromod Lalap, la derne makani Ai mehe.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Enime'ede Hayakyak Makromon hoikaruwedi Yesus, la hophopon a'am raram mai ilitolle Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesus derne nahenia Yohanis aiyedi bui raram me'e ne, Ai namhara Yudea wali wali'ur laa noho Galilea. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ai namhara Nazaret la minle kota Kapernaum man aile oir lape Galilea herne. Nohorai eniyeni, Yakup anan Zebulon noro Naptali rira nohe. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus min lolo onne leke na'akuku na'anokor inhawa Makromod Lalap na'aheniyedi lolo horok nabi Yesaya nonolu eni, na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lolo ri Zebulon noro Naptali rira nohorai man aile ranrani oir lapa Galilea, la man aile oir wauwau Yordan wali enne, ri nammori ma ka namwali Yahudi holi enne. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hir do'on Ropropo man lapida, la Ropropo onne ropa'ahedi hi man minle metmetek kalkala onnenihe me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nano lere onne me'ede Yesus loikaru Makromod Lalap Lirna Wawan na'aheni, “Herredi minim morimori ma ka namloleni, la derne makani Makromod Lalap, ono Nin lere alam nodi molollo ri mormori na'uraniyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lerida Yesus nala'ala'a lolo oir lapa Galilea arkan ne, An do'on mo'oni woro'o, Simon (rapolu ‘Petrus’ haenhi) noro mo'oniwalla Andreas. Woro'ohe ma nohu meki de mahar sopol diyale. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus napolu hi na'ahenia, “Mam lernohi Ya'u, leke Ya'u wakuku mi manoin ri mormori naise manoin i'in.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Idewe hir hoikaruwedi rir diyaleni, la lernohi Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hi rala'a kan ko'uwala, An do'on ri woro'o wali'ur, Yakobus noro mo'oniwalla Yohanis. Hi roro aman Zebedeus mahanoro tapil dari lolo korkore wawan. Yesus napolu hi, “Mam lernohi Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Idewe hir huri karuwedi aman, kopur laa ro lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Onne horu, Yesus laliwewer noho Galilea wakukuwala ri lolo Yahudi rira kerei-kerei. An loikaru Makromod Lirna Wawa'an eni, na'amou na'aropo hi'ihehewi Makromod nodi molollo ri mormori, la An hi'i wa'an ri ma nakni'ir noro man apinha na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Enpenia Ai naran pe'eredi lolo Siria ne'en raram me'e, de ri nammori rorkaru man lernala apinha noro ma nakni'ir warna-warna mai Yesus, ma napipi haha'al, ma naplu'uk nap'eker, noro idewe ri man hayakyaka huhu'ur raram haenhi. An hi'i wa'an na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Heri nammori mai lolo ewi-ewi lernohi Yesus. Hir mai nano noho Galilea, Dekapolis (napa'ahne, ‘Leke Idaweli’), kota Yerusalem, noho Yudea, noro leke-leke ma aile oir wauwau Yordan wali kimur haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus po'on heri onnenihe, An wakiha'a wo'or ida naikoredi, la Nina man lernohi pakunohi enihe mai raikoro wukuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","An wakuku hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ri ma nauroin nahenia ai mehe ka nauroin hi'i haida-haida man wa'an, de honorok akin pu'ik mehe Makromod Lalap, ai akin nahuwa'anedi, ono ai namwali Makromod Lalap Nin ri. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ri ma akin sus, ai akin nahuwa'anedi, ono Makromod Lalap na'alapedi ai honorok akin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ri ma kan holi kukulu lalapa, ai onne akin nahuwa'anedi, ono na'amoli manarna noho wawan na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ri man raram nodi rehi hi'i ha ma namlolo lolo Makromod Lalap kalarna, ai onne akin nahuwa'anedi, ono Makromod Lalap na'akuku na'anokor nin raram nodi onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ri man kukul aki man wa'an nina ri mormori wali, ai akin nahuwa'anedi, ono Makromod Lalap kukul Nin aki man wa'an ai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ri man honorok akin mou, ai akin nahuwa'anedi, ono na'amoli an min wewerre noro Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ri man holi lilili maumau la iuwuku auwuku man yaka man hala lolo nina ri heri ri wali, ai akin nahuwa'anedi, ono ai onne penia rapolu Makromod Lalap ananne. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ri man lernohi Makromod Lalap Nin honorok panaeku mamani, de lernala wewerek pananaka, ai akin nahuwa'anedi, ono ai namwali Makromod Lalap Nin ri. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Lere rin hadwei hadwokor mi, hi'i apinpinha mi, la wakunu nano'onyak mi ono mim lernohi Ya'u, mi akim nahuwa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Horhorok, nonolu rin hi'i apinpinha nabi-nabi haenhi. Ende hi'i mi akim nahuwa'an wake'edi here, ono Makromod Lalap na'akenedi minim mahmaha kolkoli ihin ennen man lap aiyedi a'am raram me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mi man lernohi Ya'u, mamwali asir noho wawan, maa lo'o mi kam lernohi Ainu'u wanakuku, mi maisa asir ma ka nam'arha me'e. Rodi inhawe leke hi'i nam'arha wali'ur? Asir onne wawedi ha man yaka, de sopoledi laa kalla wawan leke rin hihir hamar. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mi ri man lernohi Ya'u maisa wadu ma nala ropropo noho wawan na'akeme, la maisa kote man minle wo'or tilu ma ka nasinuwar. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ri ka nadedem lokon wadu rodi e'enoir honowale, maa rala loile onno kukulu leke ropo lolo nakar raram na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ende yon mim suwarala minim ropropo lolo heri kalarna, maa hurinohi heri onne do'on minim hini'i wenewhe man wa'ane, leke hi ra'uli rasa'a minim Pape man minle a'am raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yom pene'ek Ainu'u panaeku mai eni a'amoluloinedi Makromod Lalap Nina keneri hono'ok noro nabi-nabi rira horok. Ka! Ya'u mai leke a'akuku a'anokor rira wanakuku na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Horhorok Ainu'u nou ma na'ono eniyeni: Noho wawan noro a'am aile makun, wanakunu lirna na'akeme lolo Makromod Lalap nin keneri hono'ok eni na'ene namwali kokkoo, hurup ida, me, titik ida kan molu. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inhoi man larlewenedi keneri hono'ok ida, kade man deul tana wake'e, lan wakuku ri namehin lernohi haenhi, an lolo yawa Makromod Lalap Nin ri na'akeme. Maa inhoi lernohi Nin keneri hono'ok na'akeme, la wakuku ri namehin leke lernohi haenhi, ai onne Makromod Lalap kikan namwali ri lalapa lolo Nin ri na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ende mahinorokedi, lo'o mi ka mamkene lernohi Makromod Lalap Nin honorok panaeku eni narehi nalewen meser-meser Horok Lape roro ri Parisi enihe, mi kam laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mi mauroinedi nounaku ik upud a'ad kokaledi me'e ma na'ahenia, ‘Yono resne ri. Inhoi ma nesne ri, na'amoli ho'ok kail ai leke hukum.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Maa Ya aheni ki mi, inhoi ma na'ahan noro walinne, na'amoli ho'ok kail ai leke hukume. Inhoi man warei yaksala noro walinne, ai onne rodi laa nakpali Yahudi rir man ho'ok kail enihe. Inhoi ma ne'el walinne na'ahenia, ‘Maplo'edi,’ ai onne na'akeki rakanedi kawali pire ai porom raram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ende lo'o mim laa Makromod Lalap Nin Romleu Lape raram modi minim honoi kanani leke loile honoi kanani onno wawan, maa mamlilinnohi horokala mi walinne ma na'a'ahan ki mi, ");
INSERT INTO kjeNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma'akenedi honoi kanani onne lolo honoi kanani onno kalarne, laa moro mi walinne mahuwa'anedi nanumene wali mai honoi kanani onno onne mala minim honoi kanani Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Enla lo'o man tumdesne mi aile, halhala mapanak mahuwa'anedi noro ai, leke yon ai lan kalaka mi laa man ho'ok kail eni, de man ho'ok kail onne huri mi laa polisi, rala mi nahan bui raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Horhorok Ainu'u nou ma na'ono eniyeni: Lo'o mi ka mahuwa'anedi noro ai nolu, hi kar huri mi nano bui raram hehen nanumene mim pair minim okon raka onne na'akeme horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mi mauroinedi nounaku ma na'ahenia, ‘yono lerwa'u hailai’. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Maa Ya aheni ki mi, inhoi po'on maeke ida, la namono lolo honorok akin mehe, ai onne lerwa'u hailaiyedi noro maeke onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ende lo'o mi makum malanna nakoko mi hi'i dohohala, hidu sopoledi. Wa'an rehi min wewerre ik Makromod Lalap mamani, kade mi makum wali kaale. Yon hi'i de mi makum woro'o aile, maa Makromod Lalap sopol mi laa kawali pire ai porom raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lo'o mi liman malanna nakoko mi hi'i dohohala, heru sopoledi. Wa'an rehi min wewerre Makromod Lalap mamani, kade mi liman wali kaale. Yon hi'i de mi liman woro'o aile, maa mi mala'a kawali pire ai porom raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mi mauroinedi nounaku man hopon heheni, ‘Ri ma namhene nin maekleher, hi'i horok reiha'ar nala nin maekleher nanumene reiha'ar noro ai.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Maa Ya aheni ki mi, inhoi namhene nin maekleher, la maeke onne kan larlewenedi rir nou, mo'oni onne penia hi'i maeke onne lerwa'u lere an ho mo'oni namehin. Enla mo'oni man ho noro maeke onneni, an lerwa'u hailai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mi mauroin haenhi nounaku ik upud a'ad kokaledi ma na'ahenia, ‘Yono lari nano onum noue. Lo'o rin nou haida la nahopedi laa Makromod Lalap, kan huri ai lari nano nin nou onne!’ ");
INSERT INTO kjeNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Maa Ya aheni ki mi, yono ma'akerhe nou modi hopo me'e. Lo'o mim hi'i nou, yon wekel a'am raram naran ma'akerhe nou onne, ono a'am raram onne Makromod Lalap Nina naikoro onno. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yon ma'akerhe nou wekel in-noho naran, ono in-noho onne Makromod Lalap Nina ek'eker onno. Yon ma'akerhe nou wekel Yerusalem naran, ono kota onne Rai Lalap onno. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yono ma'akerhe nou wekel mi uluwakun ono ka modi molollo ma'uwarha, ee ma'amohon muruk lihir ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lo'o minim panaeku ma'aheni, ‘Ya,’ ma'aheni mehe, ‘Ya.’ Lo'o minim panaeku ma'aheni, ‘Ka,’ ma'aheni mehe, ‘Ka.’ Wanakunu ma narehi onne, Hayakyak Makromon nina panaeku me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mi mauroinedi nounaku ma na'ahenia, ‘Maka herre maka, nihi herre nihi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Maa Ya aheni yono mim herre walha ri nin hini'i wenewhe man yaka. Lo'o rin pahar mi muman malanna, mala mariri pahar haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ee, lo'o rin kalaka mi lolo man ho'ok kaile kalarna leke an hopon mala minim rain, na'amoli mala minim ho'ir homnono haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lo'o man panulu ida hopon mi ma'uwara nin hahaa modi mala'a kilu ida, na'amoli modi mala'a kilu woro'o. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Lo'o ri napanak haida-haida nano mi, male, la lo'o ri napanak herre haida ki mi, yon ma'okulale.” ");
INSERT INTO kjeNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mi mauroin wanakuku ida aile ma na'ahenia, ‘Maramyaka mi walinne, la sopoledi minim arwali.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Maa Ya aheni maramyaka minim arwali, la hi'i lir napanak ri man hi'i sus mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Lo'o mim hi'i heheni, ri namehin rauroin mi mamwali minim Pape man aile a'am raram ananne. Ai penia nala ha man wa'an ri mormori na'akeme. Ai nalha'a lere ri man holi wawa'an noro ri man ailanna haenhi. Ai nala okon mai ri man hi'i ha ma namlolo noro ri man hi'i ha ma ka namlolo haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lo'o mi maramyaka mehe ri ma nadedem naramyaka mi, yom pene'ek Makromod Lalap herre walha minim hini'i wenewhe onne. Ka! Man ra'uk paipair kade hir ailanna, maa hi me'ene raramyaka ri ma naramyaka hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lo'o mi maramyaka mi wallum mehe, hi'ihewi minim hini'i wenewhe wa'an narehiyedi ri ma ka nauroin Makromod Lalap makun. Hi me'ene hi'i heheni haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ende hi'i ha ma namlolo moro ri na'akeme naise mi Ammu man aile a'am raram eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Horhorok! Yom paeku hi'i agame nina holoor halauk lolo heri kalarna leke rin do'on la ra'uli rasa'a mi. Lo'o mim hi'i heheni, mi kam lernala wawa'an rara'a nano Makromod Lalap man minle a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Enla lo'o mi mala haida ri ma na'alehe haida-haida, yono wakunu laliwewer minim hini'i wenewhe onne naise ri man kokme'e. Hir suk hi'i panaeku wawa'an lolo rir kerei raram, ee lolo kalla lapeni leke rin do'onne, ra'uli. Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Hi kar kokala haida nano Makromod Lalap, ono ri mormori ra'uli rasa'edi hi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Maa lere mi mala haida ri ma na'alehe haida-haida, karkaramedi, leke yon ri mahaku do'on nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na'amoli mi Ammu ma nauroin ha ma nasinuwar na'akeme, po'on minim hini'i wawa'an onne, mehen herre walha minim hini'i onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lere mim hi'i lir napanak yom hi'i naise ri man kokme'e ramwali ri molololo. Hir suk laa ramriri hi'i lir napanak lolo kerei raram, la hir suk minle kalla heri lololo lalaa leke rin do'onne, ra'uli. Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Hi kar kokala haida nano Makromod Lalap, ono hir lernaledi ri mormori rira uli sa'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maa lere mim hi'i lir napanak, mala'edi kamar raram elekedi nike mene hi'i lir napanak laa mi Ammu man ri kan dodo'on eni. An do'on minim hini'i wenewhe ma nasinuwar onneni, An herre walha minim hini'i man wa'an onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Enla lere mim hi'i lir napanak, yono mim teti lau ki mai naise ri ma ka nauroin ik Makromod Lalap. Hi rakoto nahenia lo'o Makromod Lalap kokala hirira lir napanak ono hir wakunu nammori. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yom hi'i naise ri eniyenihe ono mi kam hi'i lir napanak makun, mi Ammu nauroinedi minim ha wo'ira ma kan kuku kan nokor me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ende mim hi'i lir napanak, hi'i heheni leke! ‘Ainim Pape man minle a'am raram, Na'amoli O naran man moumou dewdewe, ri na'akeme rahiyene arore. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na'amoli mamwali Rai ma nodi molollo ri noho wawan na'akeme, la malala molollo mayai leke am derne makani Onum panaeku na'akeme lolo noho wawan naise man derne nakani O lolo a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Lere eniyeni mala hanana'an man kukkuku noknokor mayai, ");
INSERT INTO kjeNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","la malala ampun ainima sale naise ai mala ampun ri man hi'i sala mayai. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ewekala kawala mayai leke yono am lernala kenene panatal, la morle'ule'u morwaliwali yai leke yono hayakyaka makromon nodi molollo mayai, ono O penia Rai man siksik lerlere, la ma nodi molollo laa ewi-ewi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lo'o mi mala ampun ri man hi'i sala mi, mi Ammu man aile a'am raram nala ampun mi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Maa lo'o mi ka mala ampun ri man hi'i sala ki mi, mi Ammu man aile a'am raram ka nala ampun minim sale haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Enla rakan lere mi ma'aluli mi kemen ka ma'ak leke ma'uli masa'a Makromod Lalap wawa'an, yon hi'i naisa ri man kokme'e ramwali ri molololo. Hir hi'i oin makan sus leke rin po'onne, ra'aheni hir maha ra'aluli kemen ka ra'ak. Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Makromod Lalap ka nala haida hi, ono hir kokaledi uli sa'a nano ri mormori me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Maa, rakan lere ma'aluli mi kemen ka ma'ak, laru mi oin makan la ma'akeki mi kemen haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","leke yon ri nauroin nahenia mi maha ma'aluli mi kemen ka ma'ak. Naukara ik Amad man kak dodo'on eni mehe nauroin minim hini'i ma nasinuwar onne, la An herre walha minim hini'i wenewhe onneni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yom loiwuku kanaru lolo noho wawan ono wutu rau noro karkoi nano'onyaka, la ma namna'a lo'o namna'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Loiwuku kanaru man minle a'am raram man wutu rau noro karkoi ka nano'onyaka, la ma namna'a ka namna'e, ");
INSERT INTO kjeNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ono minim linikir kanaru nin miminlole namwali mi akim nin miminlole haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Makum namwali wadu mi kemmu. Lo'o mi makum mou, mim do'on mauroin wawa'an naise ri man min lolo ropropo. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Maa lo'o mi makum kan mou, mi kam do'on mauroin haida naisa ri man min lolo noho momohon mamani. Lo'o mauroin hi'ihehewi lernohi ropropo man aile mi raram, maa kam lernohie, minim morimori eren memetek, kam do'on haida-haida. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ri kan paekunala namwali man howok makromon woro'o, kalo'o nalida wa'an, nalida yaka, ee namkene lernohi ida, la ida ka. Kam paekunala mamwali Makromod Lalap Nin man howok noro idewe man howok nanoin linikir kanaru mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Enpenia Ya'u konohi mi, yon ma'irhu minim morimori akilere. Yon ma'aheni, ‘Lo'o ai mo'on momun inhawa, ee lo'o am hewek nair inhawa?’ ono ha ma na'ono lolo minim morimori eni ka namwali hanana'an noro nainair mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Po'onala manu merwui me'ene, kar howok kirna, ka ra'ili radai hanana'an loiwuku dakar raram, maa mi Ammu man aile a'am raram leluwai makrana hi. Emene mi ri mormori, Makromod Lalap peni na'ono mi narehiyedi manu merwui enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mi eniyenihe, lo'o ma'irhu la loi honorok ha wo'ira onne mamani, maa onne kan paku mi ma'uwali lere ida lolo minim lere alam. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Alhi'ihepenia ma'irhu minim nainairre? Po'onala au dipi man minle wo'or au tilu. Au dipi onne kar howok, la kar kenna mair. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Maa horhorok, rai Salomo onne ri orkanaru wake'e, maa ai kan nair nainair ma'aruru naise au dipi onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Penek man minle wo'or au tilu Makromod Lalap na'akeki ma'aruru, kade mori lere eniyeni, maa oreki harnedi! Emene maika ho'o? Ai na'akeki ika narehi nalewenedi penek onne, maa mi akim ka naili'il wawa'an makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Enpenia Ya aheni, yon mamka'uk. Yon ma'aheni, ‘Lo'o ai mo'on momun inhawa, ee lo'o am nair inhawa?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Panaeku rahu eni ri ma ka nauroin ik Makromod Lalap rahinorok mamani. Ende yon mamka'uk panaeku rahu onneni ono mi Ammu man minle a'am raram nauroinedi minim ha wo'ira na'akeme ma kan kuku kan nokor makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ai na'uwali ha wo'ira onneni ki mi, horo nahenia mi mahehe leke Makromod Lalap nodi molollo mi mamani, la mim hi'i ha ma namlolo lolo Makromod Lalap herne kalarne. ");
INSERT INTO kjeNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ende yono mamka'uk alam oreki nin suse, ono lere eniyeni nina suse nokoredi me'e. Yon ma'uwali alam oreki onne nina sus wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yom ho'ok kail ri namehin, leke yono Makromod ho'ok kail mi, ");
INSERT INTO kjeNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ono Ai lo'o ho'ok kail mi namnenehe mim ho'ok kail ri namehin. Enla hono'ok mim nanair modi ho'ok kail ri namehin onne, Makromod Lalap lo'o nairre nodi ho'ok kail mi wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hi'ihepenia mim do'odo'on au mo'anida man minle mi wallum makan raram, maa au lapa man aile mi makan raram kam talukire? ");
INSERT INTO kjeNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hi'ihepenia mi me'el mi wallum ma'aheni, ‘Mai, ya aledi au mo'o onne nano makum,’ maa mi makan me'ene au lapida aile kam do'one? ");
INSERT INTO kjeNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yon kokme'e mamwali ri molololo! Maledi au lapa man aile mi makan raram leke mim do'on wawa'an nanumene mi mala au mo'o man aile mi wallum makan mai paharne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yon mala ha man moumou dewdewe ahue, kalo'o wali kili'ur na'unihi mi, la yono diuk mutiyare laa wawi, kalo'o hihir hamar mutiyara onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mapanak ik Makromod Lalap leke mim lernala, manoin leke lernale, la disna nike leke hari nika. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hi'i heheni ono inhoi ma napanak, Makromod Lalap nale ai; inhoi ma nanoin, an lernale; la inhoi man disna nika, nahinari ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mi ri mormori eniyenihe lo'o mi anum rapanak roti, mi ka mala waku, ra'an! ");
INSERT INTO kjeNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lo'o mi anum rapanak i'in, mi ka mala nee, ra'an! ");
INSERT INTO kjeNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kade mi mamwali man hi'i yaksala, maa mi mauroin mala ha man wa'an mi anume. Emene mi Ammu man aile a'am raram lo'o nauroin narehi mi nala ha man wa'an ri ma napanak Ai! ");
INSERT INTO kjeNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Inhawa hini'i wenewhe mim suk rin hi'i ki mi, hi'i onne laa hi haenhi. Onne penia wanakuku ma na'ono lolo agame nina keneri hono'ok noro nabi enihe rira wanakuku.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Lole nike man mamarke leke laa raram, ono nike noro kalla ma naprororo naphari laa kawali pire ai porom raram, la ri nammori lole. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Maa nike mamarka noro kalla mamarka man laa or'ori dardari onno onne, sus mene rin do'on de ri taran mehe lole.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nakinemen ki mi! Madiyaka nabi ma ka namlolo. Hir mai kokme'e hi'i rira morimori naise pipdume, maa hi onneni naise ahu merwui ma na'an makmaka nomun rarara. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ik kahiyene hi nano rira hini'i wenewhe. Ruri roke kan woi anggur woin, la penek lauhohoro kan woi are woin. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Namnenehe onne, ik lernala woin man wa'an nano au'ono man meur, maa au'ono ma kan meur kak lernala woin man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Au'ono man meur, kan woi woin man yak, la au'ono ma kan meur, kan woi woin man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nadedem man howok kirna keri au'ono man woin kan wa'an, harnedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ende ik po'on rira hini'i wenewhe me'e de, ik kauroin hi ramwali nabi-nabi ma ka namlolo. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ri nammori rapolu Ya'u, ‘Makromod! Makromod!’ Maa nano hi, heruwali ka ramwali Makromod Lalap Nina ri. Inhoi man hi'i lernohi Ya Am'u man aile a'am raram Nin honorok panaeku, ai onne mehen laa onno man Makromod Lalap nodi molollo, de na'amoli noro Ai min wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lere alam Makromod Lalap naho'ok nakail noho wawan na'akeme, ri nammori lo'o ra'aheni Maya'u, ‘Makromod! Makromod! Om mehe do'on am nair O naran loikaru Num nou laa ri mormoriyaneni. Ai modi O naram mohiyedi hayakyaka, la ai modi Makromod naran hi'i ha nammori ri kan dodo'onnala makun.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ya'u walha hi na'ahenia, ‘Ka auroin mi! Mala'a here, mi man hi'i ha yakyaka mamani.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ende ri man derne Ainu'u wanakunu, la lernohie, ai onne akin namkene naise ri ma nauroin, de na'ariri nina nakar waku wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lere okon, anna, noro oirulu lapa mai nediyale nakar onne, ka nawollo ono ra'ariri aile waku wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Enimaa ri man derne Ainu'u wanakunu eni, la kan lernohie, ai onne naise ri man pode, de na'ariri nina nakar lolo doslo wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lere okon, anna, noro oir rulu lapa mai nediyala nakar onne, nakar nadiporedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus wakuku horu, heri man min lolo onne mehe nanana mouwedi la aki'aki uluwakun derne Nina wanakukue, ");
INSERT INTO kjeNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ono Ai kan wakuku naise hirira meser Horok Lap enihe, maa An wakuku naise ma nodi molollo. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus kopur nano wo'or onneni, ri nammori lernohie. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lere onne mo'oni ida man ulik yak hi'ie mai Yesus kadi ein korno kalarna, na'aheni, “Papa ne'e harome, hi'i wa'anedi ainu'u apinha ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Enime'ede Yesus kemenala liman laa ri onneni, na'aheni, “Ye e'e! Wa'anedi here!” Me'e'eni me'ede ri onne nina ulik yake wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Horu ne, Yesus nou na'ahenia, “Yom konohi ri ha ma namwali o kemmu eniyeni, maa mala'a laa imam nanu leke an po'onala o kemmu, nauroin nahenia om wa'anedi me'e, la modi onum honoi kanani mala ai leke lernohi agame nina holoor halauk eni. Hi'i onne leke namwali tanada nahenia om wa'anedi kokkoo me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lere Yesus rakanedi Kapernaum, Roma nin uluwakun arida mai napanak Yesus pakuwale. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ai na'aheni, “Pape, naramyakala ainu'u hophopon ida ma nakni'ir, aile ainu'u nakar. Ai ka nauroin nawollo me'e, la kemen apinha wake'e, de ya apanak hi'i wa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus na'aheni, “Wa'an, Ya'u ki num nakar leke hi'i wa'ane.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Maa uluwakun onne na'aheni, “Eih! Kan wa'an Pape ki ainu'u nakar, ono ya'u inhoi penia Pape ki ainu'u nakar! Lo'o Pape wekelle wanakunu lisir ida woro'o, ainu'u ma nakni'ir wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ya auroin Papa nodi molollo hi'i wa'an ai, ono ya'u me'ene man derne nakani ri ma nodi molollo haenhi, la yo odi molollo ri namehin haenhi. I hopon ainu'u ma nasala ke'urauk, ‘Mala'a here!’ Hi rala'a. Ya'u polu mai, hir mai. Ya'u hopon ainu'u hophopon lolo nakar hi'i haida, hir hi'ie.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus derne nina wanakunu onneni, heheledi, de ne'el heri man lernohi onnenihe na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni! Ri ma ka namwali Yahudi eniyeni, akin naili'il kokkoo! Lolo Israel raramne ka oro ri ma naise eniyeni pakromala makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lere man mai ri nammori ma ka namwali Yahudi enihe mai nano noho wali kimur noro noho wali warak leke raikoro wuku roro ik upud a'adhe Abraham, Isak, noro Yakup ra'an romun wewerre lolo onno man Makromod Lalap nodi molollo. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nano nonolu eni Makromod Lalap na'ono Yahudi enihe ramwali Nin ri, maa ri nammori nano hi akin ka naili'il Ai, de lere man mai An sopol hi laa paharne laa noho momohon man ko'u Ai. Lolo onne hi raherhere la apinpinha mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kame'ede Yesus hopon uluwakun onne, “Mala'a wawa'anedi, ono ha man o akim naili'il onneni namwaliyedi me'e.” Ai na'aheni onne horu nina hophopon wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus laa Petrus nina nakar, do'on paninne maeke nakni'ir rinna manha aile namkuru onno. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus lan roulle liman me'ede, nina kini'ir onne wa'anedi. Enine namaka na'akene hanana'an Yesus na'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na'akeki lere helem, ri nammori mai Yesus rodi ri man hayakyake huhu'ur raramne noro ri ma nakni'ir leke An hi'i wa'an. An wakunu mehe, hayakyaka manin ri onnenihe raramne ramharedi, la An hi'i ri ma nakni'ir na'akeme wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","An hi'i ha eni na'akeme leke na'akuku na'anokor nabi Yesaya lirna ma na'ahenia, “Ai penia na'uwara iknik apinha wo'operi rahue la hi'i wa'an iknika kini'ir na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ler ida wali'ur ri namansa minwuku Yesus herne wali-wali, de An hopon Nina man lernohi pakunohi ha'a korkore wewerre hopol laa oir lap Galilea wali enne. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Maa, kar ha'a korkore makun, meser Horok Lapida mai Yesus na'aheni, “Papa Meser, i raram nodi lernohi Papa laa ewi-ewi!” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus na'aheni, “La'u nina ku'il aile, manu liwliwar nina wonno aile, maa Ya'u ma namwali Ri Mormori Anane, Ya a'alehe nakar leke ren warnala.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Onne horu man lernohi ida mai Yesus na'aheni, “Pape, hurinohi ya'u ke'ede waliyala laa nakar karuwedi ainu'u papa nanumene i wali mai lernohi Papa wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus hopon na'ahenia, “Lernohi Ya'u mamani! Na'amoli ri man maki meher karu rira makie!” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus wakunu onne horu, An ha'a laa korkore, la Nin man lernohi pakunohi enihe lernohi wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hir hopol rakanedi heleken, ramlilinnohi kahi anna lapa mai nalwalile korkore, de na'iheri nawali, maa Yesus namkuru mahmahal. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Enime'ede hir laa ramake, ra'aheni, “Pape, Pape, pelek mamaka! Pakuwala yai nanu, kalo'o ik maki!” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Enime'ede Ai namaka ne'el hi na'ahenia, “Alhi'ihepe mi mamka'uk? Mi akim ka naili'il Maya'u wawa'an makun!” Yesus namriri komdere na'ahenia, “Heih! Kahi anna lapa, mamlinedi here!” Idewe kahi anna lapa onne namlina namkaiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hir do'on ha ma namwali onne hir hehel rehi, la ida ma na'ukani ida na'ahenia, “Leher eni inhoi, penia kahi anna lapa derne nakani Aie?” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus noro Nin man lernohi pakunohi enihe rakanedi ro ne, rala'a onnida na'urani kota Gadara. Lolo onne mo'oni woro'o aile hayakyake hu'uhu'ur raramne. Hi radedem minle ku'il man aile makileke raram. Hayakyake hi'i woro'ohe ra'iseri la ailanna wake'e penia ri na'akeme ramka'uk lolo kalla man lolo onne. Hi ramhara ku'il onne, mai pakromo noro Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hayakyaka man hu'ur raramne enihe wakaukau, “Makromod Lalap Anan O! Onum panaeku inhawa noro mayai? Yom ma'o'o mayai! Kan rakan Makromod Lalap Nina lere alam hukum mayai makun!” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lere onne wawi ukun lapida aile kan ko'uwala maha ranoin ya'ane. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hayakyaka man hu'ur raram onnenihe rapanak Yesus ra'aheni, “Lo'o hopon mayai mamhara ri eniyenihe, hurinohi yai laedi wawi ukun onne raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus na'aheni, “Wa'an, mamhara here!” Ende hayakyak onnenihe laedi wawi onnenihe raramne, penia wawi rahu onne lari lolo wo'or laa yawa idewe wauwedi laa oir lapa Galilea raram de keper mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Enime'ede ma nadiyaka wawi onnenihe lari laa leke raram konohi ri na'akeme ha wo'ira na'akeme ma namwali noro ri woro'o man hayakyaka huhu'ur raram onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ende leke raram onneni na'akeme ramhara lar pakromo noro Yesus. Hi ramka'uk, de rapanak rehrehi lewlewen, “Wa'an rehi Pape laedi onno namehin here! Yon min lolo eni me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ende Yesus noro Nina man lernohi pakunohi enihe ha'a korkore hopol laa oir lapa wali enne wali wali'ur laa Nin leke miminlole. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lolo onne, ri ida woro'o le'ule'u mo'oni ma naplu'uk nap'eker ida mai Yesus. An po'on ri onnenihe akin naili'il wake'e, de ne'el ri man apinha onne na'ahenia, “Pa'e, yon mamka'uk! Ya a'ohu ahaledi num dohohala me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lere onne, meser Horok Lap ida woro'o aile man derne lirna onneni, de roro akin wakunu, ra'aheni, “Ri eni na'ihoru na'idaru Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Maa Yesus nauroinedi hi honorok akin, de na'ukani na'ahenia, “Alhi'ihepeni mim paeku honorok yaka mi raramne? ");
INSERT INTO kjeNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ewi man sus rehi? Ya a'ohu ahala ri eniyeni nin dohohala, ee Ya'u hi'i ai nala'ala'edi? ");
INSERT INTO kjeNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ya'u hi'i wa'an ri eni leke mi mauroin mouropo nahenia Ya'u eni ma namwali Ri Mormori Anan, la Yo odi molollo lolo noho wawan a'ohu ahala ri nina dohohala!” Enime'ede Yesus hopon ri ma naplu'uk nap'eker onne, “Mamakedi! Modi num namkuru onno, wali laa num nakar here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ai namaka kikan nina namkuru onno nala'a nina nakar me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Enime'ede heri onne ramka'uk wake'e, ra'uli rasa'a Makromod Lalap ono Ai naledi Nina molollo man lewlewen ri mormori me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus namhara lolo onne nala'ala'a, An po'on ri ida naran Matius naikorkoro lolo onno rodi ra'uk paipair. Ai napolu na'ahenia, “Mam lernohi Ya'u!” Idewe ai lan lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka nalo'ol Matius lariyala Yesus noro Nin man lernohi pakunohi rala'a nina nakar, ra'ak. Man ra'uk paipair nammori roro ri namehin ma nin hini'i wenewhe namehiyala, mai raikoro wuku roro Yesus ra'ak wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Enla ri Parisi ida woro'o po'on onneni, de hi ra'ukani Yesus Nina man lernohi pakunohi ra'aheni, “Hi'ihepenia minim Meser eni na'ak wewerre noro man ra'uk paipair noro man hi'i dohohala onnenihe?” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus dederne rira na'ukankani onne de walha na'ahenia, “Ri ma kan apinha, ka nanoin ma na'inapin, maa ri man apinha penia nanoin ma na'inapin. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ken koklolo ma'inau Makromod Lalap Lirna Wawan ma na'ahenia, ‘Ya'u raram nodi mi ida man kukul aki man wa'an ida, narehi mala honoi kanani Maya'u.’ Ka'u mai apolu ri man hi'i ha ma namlolo mamani, maa Ya'u mai apolu ri man hi'i dohohala, leke hir lernohi Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Enla Yohanis man ulutade eni, ainina man lernohi pakunohi enihe mai Yesus ra'ukani, “Alhi'ihepe ai moro ri Parisi ma'aluli kemen ka ma'ak momun, maa Num man lernohi pakunohi enihe, kae?” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus walhe, “Emene ik min hohoo ida, popolu lalariyala ka ra'ak romune? Kan wa'an hi akin sus la ka ra'ak! Mo'oni man ho eni nornorhe makun, de hi ra'ak romun. Enimaa rakan orekiyedi, ri namehin mai rala man ho eni nano hi leken kalarne nanumene hi ra'aluli kemen ka ra'ak.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesus nala wanakunu naho'ok na'aheni, “Ri ka nadedem tapil nainair lo'olo'ol nodi tapi a'un worworu, kalo'o tapi a'un rodi tatapil onne hi'i riki nainair onne eren lalapa.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ai na'aheni ida wali'ur, “Ri ka nadedem nala anggur worworu halle sak ulik lo'olo'ole, kalo'o anggur worworu eni hi'i sak ulik onne napriki. Maa ri nadedem nala anggur worworu halle sak ulik worworu, leke yon sak ulik napriki, de anggur worworu halle.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus wakunkunu makun ne, Yahudi rir man panulu ida mai, kadi ein korno Yesus kalarna. Ai napanak an'anhedi na'ahenia, “Pape, ya an'u maekida eni nanu maki, maa Papa ki nakar ke'e de, rouwalle leke mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Enime'ede Yesus noro Nina man lernohi pakunohi enihe roro mo'oni onne laa nina nakar me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kar rakan nina nakar makun, maekida lolo kili'urne mai na'urani Yesus. Ai onne rara waue anna idaweli woro'o raram me'e. An paeku nahenia lo'o an tukulala Yesus Nina rain mehe, nin apinhe wa'anedi. Ende ai lan rouwalle Nin rain ki'il. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus wali kili'ur do'onedi, de na'aheni, “Ya an'u, ma'alapedi o akim, o akim naili'il Ya'u, de num apinha wa'anedi me'e.” Idewe nina apinha wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesus rakanedi uluwakun kerei onne nina nakar ne, An po'on ri man penpenu onnenihe, ma nou poloit, ma naherhere, la rusu arra wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","An hopon hi na'ahenia, “Laedi paharne! Tataneni kan maki, maa namkuru mehe!” Hir derne Ai lirna onneni, na'akeme ralauwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Heri onnenihe na'akeme laedi paharne nanumene An laa tatan onne nin kamar raram roulle liman. Idewe an moriyedi, namaka, la namririyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Enpenia ha eniyeni pe'eredi lolo ri manina noho onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus noro Nina man lernohi pakunohi enihe ramhara nakar onne, rala'a. Mo'oni woro'o makan tokedi lernohi Ai wakaukau ra'aheni, “Daud upun anan O, maramyakala mayai ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus rakan nakar An miminle, laedi romleher ne, maktoko woro'o onnenihe lernohie laa raram haenhi. Yesus na'ukani hi na'ahenia, “Hi'ihehewi? Mi akim naili'il Yo odi molollo hi'i mi makam mouwedi?” Hir walhe, “Ya, ai akim naili'il Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Enime'ede Yesus kemenala liman makanhe, na'aheni, “Ya'u hi'i mi makan wa'anedi, ono mi akim naili'il Maya'u kokkoo.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Me'e'eni me'ede hi makan mouwedi, la Yesus nou an'anhedi hi na'aheni, “Yono konohi ri ha ma namwali mi eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Maa woro'ohe raderre radaul panaeku onneni ri manina noho onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Woro'ohe rala'ala'a ne, ri namehin rodi ri ida man hayakyake huhu'ur raramne de hakukuwedi, mai Yesus leke hi'i wa'ane. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ende Yesus nohiyedi hayakyaka man hu'uhu'ur ri onne raramne, idewe nauroin wakunuwedi. Heri lolo onne hehel rehi, la ida ma ne'el ida na'ahenia, “Rakan lere eni ik kak do'onala ha ma namwali heheni lolo Israel makun!” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Maa ri Parisi man aile lolo onne ra'aheni, “Hayakyak Makromon nala molollo Ai, penia Ai nodi molollo nohi hayakyaka.” ");
INSERT INTO kjeNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus laliwewer leke-leke noro kota-kota nammori. An laa Yahudi rira kerei raram loikaru Makromod Lirna Wawa'an eni man konohi hi'ihehewi Makromod Lalap nodi molollo ri mormori. An hi'i wa'an ri ma nakni'ir noro man lernala apinha warna-warna na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","An po'on heri rahu onnenihe, Ai raram penu rehi, ono hir mehe ili'ili mehe lohloho, naise pipduma ma na'alehe nina man huri. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Enime'ede Yesus ne'el Nina man lernohi pakunohi enihe na'ahenia, “Noho ihin ennen nammori, maa, ma na'ili nadai tarana mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ende mapanak Orkirneni, Makromod Lalap, leke nala man howok mai na'ili nadai Nina kirna raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus polu Nina man lernohi pakunohi idaweli woro'o maiwuku, leke nala molollo hi rohi hayakyaka, la hi'i wa'an ri ma nakni'ir noro man lernala apinha warna-warna na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ri idaweli woro'o ma namwali Nin hophopon onnenihe naran: Simon (rapolu Petrus haenhi) noro mo'oniwalla Andreas, Yakobus noro mo'oniwalla Yohanis (woro'ohe Zebedeus ananhe). ");
INSERT INTO kjeNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipus noro Bartolomeus, Tomas noro Matius (Matius ma nadedem ra'uk paipaire), Yakobus (Alfeus ananne) noro Tadeus, ");
INSERT INTO kjeNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon (ai eni namhene noho Roma nodi molollo Israel), noro Yudas Iskariot (ma na'olu Yesus). ");
INSERT INTO kjeNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus hopon ri idaweli woro'o enihe laa manin Israel. An nou hi na'ahenia, “Yono mim laa ri ma ka namwali Yahudi, maa mala'a ri Yahudi mehe. Yon laa kota-kota lolo Samaria haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","maa mala'a ik walin, Israel upun ananhe nolu. Hi raisa pipduma ma ka nauroin kalla me'e, ono ra'alehe man huri. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lam loikaru mouropo ma'aheni, ‘Lere alam Makromod Lalap nodi molollo ri mormori lolo noho wawan na'uraniyedi me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lam hi'i wa'an ri ma nakni'ir, ma'amori ri man makiyedi, hi'i wa'an ri man ulik yak hi'ie, la mohi hayakyaka man hu'uhu'ur ri raramne. Ya ala molollo mi hi'i ha wo'ira na'akemeni, maa ka apanak wanalhan ida, de mi lam hi'i ha wawa'an eni, yono mapanak wanalhan haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yono modi kupan mahe, kupan pere, ee kupan namehin. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yono modi panaku onno, nainair, pakpak ei me au ke'eke'en, ono wa'an rehi mi man howok eni lernala minim hewhewek nanair nano ri man mim papaku eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Rakan leke ida, manoin ri man akin wa'an kokala mi leke minala nina nakar hehen nanumene mamhara wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mim rakan lolo nike laa raram, mapanak Makromod Lalap nodi nala hi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lo'o hir kokala mi wawa'anedi, hir lernala rere'e haharu onne, maa lo'o hi akin yaka de kar kokala mi, mapanak Makromod Lalap nala wali'uredi minim lir napanak onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lo'o lolo nakar me lolo kote kar kokala mi, mamharedi lolo onne, disnedi elimo'o hapu man aile mi ein rarame. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Rakan lere Makromod Lalap hukum ri na'akeme, manin kota onne lernala hunukum man werek narehi manin kota Sodom noro Gomora nonolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesus nala nounaku Nina ri idaweli woro'o enihe wali'ur na'ahenia, “Nakinemen ki mi, ono I hopon mim laa mamkene noro ri man ailanna naise pipduma man maru min lolo ahu merwui raram. Ende madiyakyaka mi kemen leke mi maise nee ma nauroin nahala kemen nano ha yakyaka, maa madiyaka leke mi akim wa'an mamani naise manu merpati. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ende ma'akenkene mi, ono ri lo'o kele mi rodi laa makpali agame nin man ho'ok kail enihe, la ri lo'o riuk rerhe mi lolo Yahudi rira kerei-kerei haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ri lo'o kele mi rodi laa makpali rir man panulu noro rir rai-rai kalarna, ono mim lernohi Ya'u. Lere onne Makromod Lalap nala leken paharin loikaru Lirna Wawa'an eni hi noro ri ma ka nauroin Ai makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lere hir kele mi, yono mamka'uk walha rira na'ukankani, ono Makromod Lalap mehe nala wanalhanne ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ende lere onne yon mamka'uk ono inhawa man mim wakunu, ka mehem wakunu, maa mi Ammu Nin Roh mehen hari mi honorok akin moro hi wakunu. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Lere onne ri nammori kar suk mi, ono mim lernohi Ya'u. Ri mehen huri we'er mo'oniwalla ri nesne. Onne namwali noro papa noro ananne haenhi. Enla tatana lalapana kar derne rakani hi inna aman me'e, de huri laa rin nesnehe. Maa inhoi akin namkene naili'il Ya'u rakan lere onneni horu, an lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lo'o mim laa kotida, la hir hi'i yakyaka mi, mamharedi lari laa kote namehin. Horhorok Ainu'u nou ma na'ono eniyeni: Mi kam laa Israel nin kota na'akeme horu makun, Ya'u ma namwali Ri Mormori Anan maiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pudpude kan kulu narehi nin meser, la hophopon wahwahane kan kulu narehi makromon. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ha man wa'an, pudpude nin hini'i wenewhe namnenehe nin meser, la hophopon wahwahan nin hini'i wenewhe namnenehe noro makromon. Lo'o hir waki Ya'u ma namwali uluwakun nakar raramne naran Beelzebul, Hayakyak Makromon onne, Ainu'u nakar raramne lo'o lernala naran man yaka narehi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Enimaa yono mamka'uk ri ma na'okul minim loloi kakaru eni, ono lere man mai ha man rin suwsuwar lere eniyeni na'akeme ralhari mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ende inhawe Ya'u konohi mi aimehi, lam loikaru ri na'akeme leke derne rauroin haenhi. Inhawa man Ya alpupu mi kilinum, lam wakau lolo nakar-nakar leke heri derne rauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yon mamka'uk ri man suk nesne mi. Hi rodi molollo resne ri ihin kemen mehe, maa ka rodi molollo resne ri hamaranne. Mamka'uk Makromod Lalap mehe, ono Ai penia nodi molollo hukum ri kemen noro hamaranne sopol laa kawali pire ai porom raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nadedem rin na'olu nurn woro'o wella lo'o rupei ida mehe, maa lo'o ik Amad, Makromod Lalap kan huri we'er nurn onne makun, mahaku ka nadiyaur. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Makromod Lalap penia nauroinedi minima muruk lawanne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ende yono mamka'uk, ono Ai naramyaka mi narehi nalewen nurn onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Inhoi na'aheni ai namwali Ainu'u ri lolo ri leken kalarna, Ya'u konohi Ya Am'u man aile a'am raram, ‘Ai onne lernohi Ya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Maa inhoi wiuk namhene Ya'u lolo ri mormori leken kalarna, Ya'u wiuk amhenedi ai lolo Ya Am'u man aile a'am raram kalarna haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yom pene'ek Ya'u mai noho wawan odi moiliwi mahuwele. Ka! Ya'u mai eni hi'i ida ma nasesi na'ara noro ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Ya'u mamai eni hi'i nakar raramne ida man rohon ara noro ida. Hir hi'i ara ono heruwali lernohi Ya'u, heruwali ka. Ende mo'oniyana kan derne nakani aman, maekana kan derne nakani inna, la anan panin maeke kan derne nakani paninne maeke. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Inhoi naramyaka inne noro aman narehi Ya'u, la inhoi naramyaka anan narehi Ya'u, ai onne ka namwali Ainu'u ri, ono hini'i onne ka nahuwa'an Makromod Lalap akin. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inhoi namhene lernala apinpinha la namhene maki leke lernohi Ya'u, ai onne ka namwali man lernohi Ya'u, ono hini'i onne ka nahuwa'an Makromod Lalap akin haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Inhoi namka'uk ihin kemen maki, de nasala kerkerhe nin morimori aimehi, ai onne kan lernala or'ori dardari ma kan horu eni. Maa inhoi hurinohi Makromod Lalap nodi molollo nin morimori, kade ihin kemen maki, ai onne lernala or'ori dardari ma kan horue. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Inhoi kokala mi, an kokala Ya'u haenhi, la inhoi kokala Ya'u, an kokala Makromod Lalap man hopon Ya'u mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inhoi kokala nabi ono ai namwali ma nodi Makromod Lalap Lirna kokkoo, Makromod Lalap herre walha nin hini'i man wa'an onne namnenehe noro nabi onne haenhi. Enla inhoi kokala ri man wa'an ono ri onne akin mou, Makromod Lalap herre walha nin hini'i onne namnenehe noro ri man wa'an onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi paku ri yakyak halhala ono an lernohi Ya'u, Makromod Lalap herre walha nin hini'i wawa'an onne, kade ai nala oir lali'oir raram mehe nomun.” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus nounaku Nina man lernohi pakunohi idaweli woro'o enihe horu, hi rahina'ar. Enla An laa loikaru Makromod Lalap Nina nou eni lolo leke-leke ma na'uranrani lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lere onne Yohanis man ulutade ri aile bui raram. An derne ha wo'ira na'akeme Kristus (Mesias) hihi'i eni ne, an hopon nina man lernohi ri ida woro'o ");
INSERT INTO kjeNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","laa ra'ukani, “Pape penia man Makromod Lalap nouwedi mai noho wawan, ee am newek ri namehin?” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","An walhe na'ahenia, “Wali here! Lam konohi Yohanis inhawe mi mehem derne la mehem do'on: ");
INSERT INTO kjeNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ri man makan tokedi, makan mouwedi; ri ma ka nauroin nala'a, nala'ala'edi; ri man ulik yak hi'ie, wa'anedi; ri man rohedi, derne wali'uredi; ri man makiyedi, mori wali'ur; la Makromod Lalap Lirna Wawa'an eni rodi laa loikaru ri ma na'alehe naulinu. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Konohi ai haenhi na'ahenia, ‘Ri ma namkene akin naili'il Ya'u, ai akin nahuwa'anedi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohanis nin man lernohi onnenihe rala'edi ne, Yesus wakunu Yohanis nina hini'i man wa'an laa heri onne. Ai na'aheni, “Minim panaeku inhawa mim laa noho mamun ma napro'uk leke derne Yohanis wakukue? Lo'o mim laa leke po'on ri ma akin ka namkene naisa penek larlari man anna huhue? ");
INSERT INTO kjeNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lo'o mi raram nodi lam po'on inhawa lolo enne? Ri man nair nainair ma'aruru harome? Ka! Ri man nair nainair ma'aruru nadedem min rai nina nakar! ");
INSERT INTO kjeNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ende hi'ihepenia mi raram nodi laa enne? Lo'o mi raram nodi lam po'on nabie? Namlolo kokkoo mim do'onedi nabi, maa nabi onne namwali nabi man kulu narehi nabi nadedem! ");
INSERT INTO kjeNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nonolu eni Makromod Lalap wekel Yohanis ma namwali Nin hophopon eni lolo Horok Lap na'ahenia, ‘Ya'u hopon Ainu'u ma nodi Lir'u nolu mai na'ahari kalla leke Om lole.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesus na'aheni wali'ur, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Rakan lere eni, lolo noho wawan na'akeme ri kaale man kulu narehi Yohanis man ulutadeni. Maa nano lere eni ri na'akeme man Makromod Lalap nodi molollo, kade hi onne tana rehi, hir lernala rere'e haharu narehi ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nano lere Yohanis loikaru panaeku ma na'ono hi'ihehewi Makromod Lalap nodi molollo ri mormori rakan lere eniyeni, ri man ailanna rodi rurilai rahehe ewekala kawala Makromod Lalap Nin molollo ri mormoriyaneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nano nonolu rakan Yohanis nin mamai eni, Musa noro nabi-nabi rir horok na'akeme konohiyedi kokkoo inhawa ma namwali lere Makromod Lalap nodi molollo ri mormori. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lo'o mi me'e kokale, Yohanis onneni penia nabi Elia man ra'anouwedi nano nonolu me'e, de mi akim naili'il, leke! ");
INSERT INTO kjeNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inhoi kilinna aile, derne nakani!” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ya aho'ok ri mormori ku eniyeni noro inhawe? Hi raisa tatana man ha'ar ramwali muku woro'o ma naikoro ra'aromo lolo pasar raram, ");
INSERT INTO kjeNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","la muku ida napopolu muku namehin ra'aheni, ‘Ai mahinara hanara man hi'i ri nahere, maa mi mamhene mahere moro mayai! Enla ai mou poloit modi mahinara soksok murmura, maa mi mamhene pe'uk waur moro mayai.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ri ku eniyeni namnehe noro onne. Lere Yohanis mai wakuku ri, ai ka nomun arak, la lere romromo ka na'ak. Hi ra'aheni, ‘Ai onne hayakyaka hu'uhu'ur raramne.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Enla Ya'u ma namwali Ri Mormori Anan mai, Ya a'ak Yo omun mamani, maa hi ramhene kokala Ya'u haenhi la ra'aheni, ‘Po'onala ri onne! An suk na'ak nammori, nomun manha mamani, Ai nawaur noro ri man ra'uk paipaire, la minwuku noro ri man hi'i dohohala mamani!’ Kade hi ramhene kokala Maya'u, maa ik kauroin Makromod Lalap Nin honorok panaeku namlolo, ono ik do'on honorok panaeku onne ihin ennen.” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Onne horu, Yesus dadiyala ri Yahudi man minle kota-kota lolo Galilea, ono An hi'i tanada nammori ri kan dodo'onnale makun, maa hi ramhene herre rir morimori, lernohi Makromod Lalap Nin panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ai nawuhur hi na'aheni, “Mi manin Korazim noro Betsaida, mim mayo'o. Ya'u hi'iyedi tanada nammori ri kan dodo'onnala makun mi herne kalarna, maa kam kokala Maya'u. Lo'o Ya'u hi'i tanada rahu onne lolo ri manina kota Tirus noro Sidon (ri ma ka namwali Yahudi enihe), hir nairedi homnono yak, loiyedi apu hi uluwakun leke namwali tanada hir herredi rira morimori ma ka namlolo me'e, la derne rakani Makromod Lalap Nin panaeku me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Horhorok, rakan lere alam Makromod Lalap naho'ok nakail ri na'akeme, ri manina kota Tirus noro Sidon rira hunukum namrana narehi mi! ");
INSERT INTO kjeNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mi manin Kapernaum, mi mauroin lo'o ra'uli rasa'a mi lolo a'am raram? Ka! Makromod Lalap sopol mi laa kawali pire ai porom raram. Ya'u hi'iyedi tanada nammori ri kan dodo'onnala makun lolo mi kalarum, maa mi mamhene Maya'u. Nonolu eni lo'o Sodom do'on Ya'u hi'i ha lewlewen onne lolo hi, hir herredi rira morimori de rorroro ika makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ende horhorok, rakan lere Makromod Lalap naho'ok nakail ri mormori na'akeme, Ai nala hunukum mi man werek narehi Sodom onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Me'e'eni me'ede Yesus hi'i lir napanak Aman na'aheni, “Papa, Makromod ma nodi molollo a'am noro noho wawan na'akeme, Ya apanak trimkasi nammori ono Om kukul ha wo'ira ri ma nin woroin kan kuku kan nokor, maa Om suwarala ha wo'ira nano orworoin roro ma nauroin ha wo'ira lolo noho wawan enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pape, Num hini'i onne penia ma nahuwa'an O akim.” ");
INSERT INTO kjeNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus na'aheni heri wali'ur, “Ha wo'ire na'akeme Ya Am'u naledi Ya'u me'e. Ya Am'u mehe nauroin Ya'u ma namwali Ananne, ri namehin ka nauroin Ya'u, la Ya'u mehe auroin Ya Am'u. Enla inhoi-inhoi Ya ala woroin, hi rauroin Ya Am'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mi eniyeni man maha rehi la ma na'uwara yodi wewerek, mai leke I huriyedi mi nano minim yodi wewerek onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma'uwara yodiwara Ya ala ki mi mehe. Mapanak Ya'u wakuku mi, leke mi ulla kawa'al namranedi, ono ka odi lira apipinha, ka'u holi kukulu lalap, la Ya ala aki ma namkene ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Honowok Ya ala ki mi eni kan werek, la yodiwara Ya ala mi eni namrana.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lerida, Yahudi nina Alam Renren Warwarna, Yesus noro Nina man lernohi pakunohi enihe rala'ala'a lolo gandum kirna ida. Hir rala'a lolo kirna onne, Nin man lernohi pakunohi enihe ramlara de reku gandum ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi enihe do'on hi reku gandum ra'an ne, re'el Yesus, “Po'onala Num man lernohi enihe! Iknik agame nina keneri hono'ok kan huri ika howok Alam Renren Warwarna, de kan wa'an hir howok reku gandum lere eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","An walhala hi, “Lo'o mim lesedi Horok Lap Lirna man konohi inhawa namwaliyedi nonolu lere Daud noro nin man lernohi enihe ramlara, ee kaun? ");
INSERT INTO kjeNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hi ramlara, de Daud laa Tenda ma namwali Makromod Lalap Nin miminlole raram, nala roti man luli hi ra'an. Roti onne nadedem rodi hoikani Makromod Lalap. Ende rir hini'i onne larlewenedi rir agame nin holoor halauk man huri imam mehe ra'ane, ri namehin ka. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lo'o mi kam lesala agame nina keneri hono'ok makun man konohi hi'ihehewi nonolu imam enihe howok mamani lolo Makromod Lalap Nin Romleu Lape kade rir lere nedille Alam Renren Warwarna. Rir hini'i onne larlewenedi keneri hono'ok me'e, maa kar sala. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya'u konohi mi, ri ida ai lolo eni man kulu narehi nano Makromod Lalap Nina Romleu Lap eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lolo Horok Lape raram Makromod Lalap na'aheni, ‘Ya'u raram nodi mi ida man kukul aki man wa'an ida narehi nano mi mala honoi kanani Maya'u.’ Lo'o mi mauroinedi panaeku onne wawa'an me'e, mi kam hukum ri ma kan sala enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ya amwali Ri Mormori Ananne, eni penia Yo odi molollo hopon rin hi'i inhawa-inhawa Alam Renren Warwarna.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus namhara lolo onneni, An laa Yahudi rira kerei raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lolo onne mo'oni ida aile liman wali makiyedi. Ri ida woro'o namehin aile haenhi maha ranoin Yesus Nina sale, de ra'ukani, “Hi'ihehewi, iknik holoor halauk huri ika hi'i wa'an ri Alam Renren Warwarna, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","An walha na'ahenia, “Nano mi eniyenihe, lo'o ri ida nina pipi waku ida nediyawedi laa ku'il raram lolo Alam Renren Warwarna, orpipi lo'o nahehe nala mai paharne, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ri mormori peni wa'an narehi ha mormori, de kan hi'i haida ika hi'i ha man wa'an lolo Alam Renren Warwarna.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Horu ne, Yesus hopon ri man liman wali maki onne na'aheni, “Ma'aloledi o limmu.” Ri onne na'alolo liman ideweni ne, wa'anedi naisa liman walie. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Enimaa ri Parisi enihe do'on ha ma namwali onne, hi ramhara laa paharne wakunu wuku leke resne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus nauroin rira panaeku yakyaka penia Ai namhara lolo onne, la ri nammori lernohi. An hi'i wa'an ma nakni'ir na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","la komdere hi, “Yono konohi ri, Ya'u eni inhoi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ainin hini'i onne na'akuku na'anokor inhawa Makromod Lalap na'aheniyedi lolo nabi Yesaya, ");
INSERT INTO kjeNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ai eni penia Ya'u niliyedi namwali Ainu'u hophopon. Ya aramyaka la Ya akin nodi nale. Ya ala Ainu'u Roh Ai, la Ai penia man loikaru Ainu'u hono'ok kanail ma namlolo laa ri mormori noho wawan na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ai ka nasesi, kan mehe wakaukau, la kan wakunu warei lolo kalla wawan leke ra'uli. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ai kan duni ta'al ri man akin ka naili'il wawa'an makun. An paku na'alapa ri ma akin tana hehen nanumene rakan lere hair na'akeme kokala Nina hono'ok kanail ma namlole. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Enla Ai onne penia ri mormori noho wawan lalapan.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lere onne, ri nodi ri ida laa Yesus. Ri onne makan tokedi, la hakukuwedi ono hayakyaka hu'uhu'ur raramne. Yesus hi'i wa'anedi ri onne, de do'on la wakunu. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kame'ede na'akeme polletilu do'on Yesus Nina hini'i onne, de ida ma na'ukani ida na'ahenia, “Lo'o leher eni Daud Anan?” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi enihe derne onne, hi ra'aheni, “Beelzebul, Hayakyak Makromon onne, penia nala molollo Ai nohi hayakyaka nano ri raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Maa Yesus nauroiroin hi honorok akin de na'aheni, “Lo'o hair ida napye'er ono ida ma kan derne ida, de namwali muku woro'o, hair onne ra'akeperedi. Lo'o kote ida, meheromo ida, ee nakar raram, hi ida ma kan derne wawa'an ida, na'akeme nakperredi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Namnenehe Beelzebul nodi molollo nin noho. Lo'o hayakyaka ida pakuwala ri nohi hayakyaka namehin, nin nohe napye'eredi la ka naruri me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi ma'aheni Yo ohi hayakyaka ono Beelzebul nala molollo maya'u, de Ya a'ukani mi, ‘Inhoi nala molollo minim man lernohi enihe, leke hi rohi hayakyaka?’ Lo'o Beelzebul harome? Ka! Ma namlolo, hi rodi molollo nano Makromod Lalap. Rir hini'i onne penia kukul nahenia minim tunum desne Maya'u onne, saledi. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Maa Yo ohi hayakyaka odi molollo nano Makromod Lalap Nina Roh. Onneni namwali tanade nodi kunukunohi nahenia lere alam Makromod Lalap nodi molollo ri mormori maiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hi'ihehewi? Lo'o rin paeku laa ornakar ma naruri ida nina nakar namna'a hahaa, maa kan kele wuku ornakar ma naruri onne makun, ka namwali namna'a nin hahaa. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ri ma ka nodi Maya'u, ai onne namwali Ainu'u arwali, la ri ma kan paku Ya'u, ai onne ma nano'onyaka Ainu'u honowoke. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ende Ya'u konohi mi, lo'o rin hi'i dohohala la na'ihoru na'idaru Ya'u, Makromod Lalap nala ampun, maa lo'o rin na'ihoru na'idaru Makromod Lalap Nina Roh, Ai ka nala ampun. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Makromod Lalap nala ampun ri ma na'ihoru na'idaru Ri Mormori Anan, maa Ai ka nala ampun ri ma na'ihoru na'idaru Nin Roh, lere eniyeni noro idewe lere man maie.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Lo'o au'ono ida ka namnoro nahuwa'an, ik kak lernala au woin man wa'an. Lo'o au'ono ka namnoro nahuwa'an, woinni kan wa'an. Ik po'onala au woin ik kauroin idewe, au'ono onne namnoro nahuwa'an, ee ka! ");
INSERT INTO kjeNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Maa, mi ri man ailanna! Mi kam paekunala wakunu panaeku man wa'an ida ono inhawe man mim wakunu, onne namhara nano mi honorok akim man ailanna onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ri man wa'an, nin honorok aki wa'an, de an wakunu panaeku man wa'an mamani. Ri man yaka, nin honorok aki yaka, de an wakunu panaeku man yaka. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ende horhorok! Rakan Lere Alam Ho'ok Kail ri na'akeme, hi dohdoho meher konohi Makromod Lalap rir wanakunu ma kan min haida! ");
INSERT INTO kjeNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Minima wanakunu mehe nala kenekrohu mim saledi, ee ka!” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Horu ne, meser Horok Lap ida woro'o noro ri Parisi enihe ra'aheni, “Pap Meser, am suk po'onala Pape hi'iyala tanada ri kan dodo'onnale makun.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus walhe na'ahenia, “Kulere alam eni ailanna la akinhe ka namkene naili'il Makromod Lalap. Mi mapanak Ya'u hi'i tanada man ri kan dodo'onnale makun, maa Ka'u hi'i haida mim do'on, naukara inhawa ma namwali noro nabi Yunus mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","An minle i'in lape konoin lere wokelu alam wokelu, namnenehe noro Ri Mormori Ananne. An maki minle noho wi'in lere wokelu alam wokelu haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Rakan Lere Alam Ho'ok Kail ri na'akeme, ri man maki lolo kota Niniwe mori wali'ur, de ramriri roro ku enie kuku sala mi, ono lere hir derne Yunus nina wanakunu, hir herredi rir morimori ma ka namlolo, la derne rakaniyedi Makromod Lalap me'e. Lere eni ri man kulu narehi Yunus aile, maa mi akim kerhe. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lere Alam Ho'ok Kail ri na'akeme, rai maeke nano noho wali karanna mori wali'ur, la mai namriri noro ku enie kuku sala mi, ono nonolu ai nala'a kalla man ko'u mai leke derne nakani rai Salomo nina wanakuku. Kade lere eniyeni ri ida aile man kulu narehiyedi rai Salomo, maa mi kam derne makani Ai!” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesus na'aheni wali'ur, “Lo'o hayakyaka ida namharedi ri raram, an lalaa mamai noho mamun nanoin onno man wa'an leke holi, maa kan lernala. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ende ai nala kenekrohu wali wali'ur laa onno dedesneni. Rakanedi an do'on ri onne naise nakar man mammamu, sapu moumouwedi la ra'akene wawa'anedi me'e, ");
INSERT INTO kjeNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","de ai noro hayakyaka wo'ikku man ailanna narehi ai, hu'ur ri onne raramne wali'ur. Ende ri onne nina morimori eren yayaka narehi nonolu eni. Onne lo'o namwali ri mormori man ailanna ku eni haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus wakunkunu heri kalarna makun, inne noro mo'oniwalinhe mai ramriri lolo paharne, rapanak roro Yesus wakunu. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Rin laa kukunohi Ai na'ahenia, “Papa Meser, Num mame noro mo'oniwallumhe aile paharne. Hi raram nodi roro Papa wakunu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","An walha na'ahenia, “O mauroin Yi in'u la I mo'oniwal'uhe inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Horu ne, An kukuwala liman Nina man lernohi pakunohi enihe la na'aheni, “Hi penia Yi in'u noro I mo'oniwal'uhe. ");
INSERT INTO kjeNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ri man lernohi la derne nakani Ya Am'u man aile a'am raram, hi onne penia Yi in'u, I nar'u, la I mo'oniwal'uhe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lere onne me'ede Yesus namhara nakar onne laa naikoro oir lapa arkanne. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Heri rahu mai lupurala Yesus, de An ha'a laa korkoro ida wawanne, naikoredi. Heri onnenihe ramriri herraram. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ai nodi wanakunu naho'ok wakuku panaeku nammori na'ahenia, “Ler ida, man howok kirna ida nodi wini hawono lan wahair nin kirna. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","An wahair ne, wini heruwali nadiyaur kalla wawan, de manu liwliwar mai na'an mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Heruwali nadiyaur elimo'o wakwaku. Memen pelek mori ono elimo'o tarana mehe, ");
INSERT INTO kjeNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","maa rakan lere ulu, namlau napro'ukedi ono ka na'a'ar. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wini namehin nadiyaur ruri roke raram, mori, maa ruri roke eren lolode, de elewesnedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Maa, ma nadiyaur elimo'o man meur na'ihiyedi, de ihin ennen lernala rewen welikelu, welneme, rakan rahu rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ende lo'o mi kilinum aile, makani wawa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Man lernohi pakunohi Yesus mai ra'ukani Ai, “Alhi'ihepe nair wanakunu naho'ok noro herie?” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus walha na'ahenia, “Makromod Lalap nala woroin mi leke mauroin hi'ihehewi Ai nodi molollo ri mormori. An hi'i mi mauroin panaeku ma nasinuwar onne, ri namehin, ka. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ri ma nauroinedi Ainu'u wanakuku wawa'an taran me'e, lo'o ra'uwali woroin narehi nalewen makun, maa ri ma kan peinohi Ainu'u wanakuku onne, nin woroin taran man aile, lo'o rala wali'uredi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Enpenia Ya'u nair wanakunu naho'ok eniyeni wakuku herie ono: ‘Hir do'odo'one, maa naise ri ma kan do'on, hir derderne, maa naise ri ma kan derne, la ka rauroin haida-haida.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ende inhawa man Makromod Lalap konohiyedi lolo nabi Yesaya nonolu eni namwali noro hi, ‘Lo'o mim dederne mamani, maa ka mauroin haida. Lo'o mim dodo'on mamani, maa ka mauroin inhawa ma namwali, ");
INSERT INTO kjeNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ono mi honorok akim kerhe, de mamhene makani, mamhene do'on, la mamhene mauroin. Ende Ka'u huri mim do'on, derne, mauroin, la wali wali'ur Maya'u leke Ya'u hi'i wa'an mi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesus na'aheni Nina man lernohi pakunohi enihe, “Mi akim nahuwa'anedi, ono mim do'on la derne kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Nonolu nabi-nabi roro ri nammori ma akin mou lolo Makromod Lalap kalarna, hi raram nodi do'on inhawa mim dodo'on lere eniyeni, la raram nodi derne inhawa mim dederneni, maa lere onne Ka'u mai noho wawan makun de hi kar do'on kar derne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Derne wawa'an! Ya apa'aha wanakunu ma na'ono ri man wahair wini hawono eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wini ma nadiyaur kalla wawan naise ri man derne hi'ihehewi Makromod Lalap nodi molollo ri mormori, maa ka rauroin wawa'an. Hayakyak Makromon mai nahoredi wini man aiyedi ai akin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wini ma nadiyaur elimo'o wakwaku eni, naise ri man derne Makromod Lalap Lirna Wawan, la kokale noro wawa'an, ");
INSERT INTO kjeNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","maa lirna onne ka na'a'ar akin, de ka nalo'ol moluwedi. Lere an lernala apinpinha ono an derne nakani Makromod Lalap Lirna Wawan, an waliyedi kili'urne. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wini ma nadiyaur lolo ruri roko raram, naise ri man derne Makromod Lalap Lirna Wawa'an eni, maa an ma'irhu nin hehewek nainair akilere, la raram nodi lernala kanaru nammori penia kan ilitolle Makromod Lalap Lirna Wawa'an eni. Ende wini onne kan woi, ");
INSERT INTO kjeNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","maa wini ma nadiyaur elimo'o man meur onne na'ono ri man derne nakani la nauroin Makromod Lalap Lirna Wawan eni. Ende ihin ennen nammori, heruwali lernala ihin ennen rewen rahu ida, heruwali welneme, la heruwali welikelu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nala wanakunu naho'ok ida wali'ur na'aheni, “Lere Makromod Lalap nodi molollo ri mormori, naho'ok naise ri man howok kirnida. Ri onne lan pekir ariyono wini gandum man wa'an nina kirne. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Alam ida, ri na'akeme ramkukuru ne, nina arwali mai wahair penek hohoro woi nina kirne raram mene nala'a. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lere wini hawonne mori la woin namhara, penek hohore mori wewerre noro gandum onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Orkirne nina man howok enihe mai ra'aheni, ‘Pape, lere pekir ariyono wini nonolu eni, kirne ra'amouwedi la pape pekir ariyono wini man wa'an menee, alhi'ihepe penek hohoro mormori raram me'e?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Orkirne walha na'ahenia, ‘Onne ainu'u arwali nin hini'i.’ Nina man howok ra'ukani wali'ur, ‘Lo'o pape ne'e, am laa he'uledi penek hohoro onne, ka?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","An walha na'ahenia, ‘Yono, kalo'o gandum onno nahine'uledi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na'amolia mori wewerre rakan nina alam rereku mene ya'u konohi ma neku enihe ra'ukwuku penek hohore, leke harne. Onne horu, ra'ukwuku gandum rodi laa ra'akene lolo ainu'u na'akene onno.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus nala wanakunu naho'ok ida wali'ur heri onne na'aheni, “Lere Makromod Lalap nodi molollo ri mormori lo'o naise wanakunu naho'ok eniyeni. Ri ida nala wini au manu waku ida hap nin kirna. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wini au manu waku onne tutusiyana wake'e, maa an moriyedi, lapa narehi nano au or'oriyana man aile lolo onne na'akeme, penia namwali au'ono lape, de manu liwliwar mai hi'i rira wonne min hinan hanan.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus nala wanakunu naho'ok ida wali'ur heri onne na'aheni, “Lere Makromod Lalap nodi molollo ri mormori lo'o naise ha ma namwali lere maeke nodi ragi nawa'aha noro tapon terigu nammori (lo'o kilo werro'o woro'o). Nalo'oledi tarana mene na'akeme ha'a wawa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus wakuku heri panaeku rahu nair wanakunu naho'ok mamani. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","An wakuku heheni leke inhawa man nabi-nabi ra'aheniyedi nonolu eni namwali. Hi ra'aheni, “Ya'u nair wanakunu naho'ok mamani wakuku hi panaeku ma nasinuwaredi nano lere noho nina ma namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Onne horu, Yesus hoikaruwedi heri eni, wali laa nakar me'e. Nina man lernohi pakunohi enihe mai ra'aheni, “Pape kene ma'amou ma'aropo wanakunu naho'ok ‘penek hohoro man mori gandum raram’ ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","An walha, “Ri man pekir ariyono wini man wa'an, Ai onne, Ri Mormori Ananne. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kirne onne, noho eni wawan. Wini man wa'an onne, ri ma namwaliyedi Makromod Lalap Nina ri me'e, la penek hohoro onne, ri man lernohi Hayakyak Makromon. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Arwali man wahair penek horhoro woi onne, Hayakyak Makromon. Alam rereku onne, lere alam man horu, la ri ma neku onnenihe ramwali hophopon a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lere onne hi ra'ukwuku penek hohore leke harne, namnenehe noro noho wawan nin man horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lere onne Ri Mormori Ananne hopon Nina hophopon a'am raram enihe ra'ukwuku ri na'akeme man ailanna noro ma nakoko rin hi'i dohohala. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Onne horu, man ailanna onnenihe sopol laedi kawali pire ai porom raram. Lolo aiye man mormori onne, hi raherhere mamani la apinha wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Enla lere onne ri man akin mou lolo Makromod Lalap kalarne laa minle hi Aman Nin noho worworu, la hir siksik lerlere naise lere lolo onne. Ende mi kilinum aile derne makani!” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Lere Makromod Lalap nodi molollo ri mormori lo'o naise linikir kanaru man wella ai wawan rawilo'edi elimo'o wi'in. Ler ida ri ida mai do'onne, laa nawilo'edi wali'ur, la akin nahuwa'an rehi de wali laa na'olu mouwedi nina hahaa na'akeme nanumene mai nodi kupan onne weli noho onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Lere Makromod Lalap nodi molollo ri mormori naho'ok naise ri ida ma nanoin mutiyara man wella ai wawan leke weli. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lere an do'on mutiyara man ma'aruru wake'eni, ai na'oluwedi nina hahaa na'akeme leke nodi weli mutiyara onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Lere Makromod Lalap nodi molollo ri mormori naho'ok naise ri ma nodi dari laa meki nanoin i'in, de lernala i'in warna-warna nammori. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","I'in nammoriyedi dari raram, de ma nohu meki eni ri'ik mai ro. I'in man wa'an eni, hir loiyedi lo'or raram, la ma kan wa'an sopoledi. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Onne namnenehe noro lere alam noho nina man horu. Lere onne lo'o Makromod Lalap Nina hophopon a'am raram lan reiha'ar ri man ailanna nano ri ma akin mou lolo Makromod Lalap kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ri man ailanna, sopol laedi kawali pire ai porom raram. Lolo aiye man mormori onne, hi raherhere mamani la apinha wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus na'ukani Nina man lernohi pakunohi enihe, “Lo'o mi mauroinedi panaeku enihe na'akeme me'e?” Hir walha, “Ai mauroinedi me'e, Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ende Ai na'aheni wali'ur hi na'ahenia, “Meser Horok Lap ma nauroinedi hi'ihehewi Makromod Lalap nodi molollo Nin ri, hi onne naho'ok naise ri ornakar ida ma nala nin linikir kanaru lo'olo'ol noro worworu nano nina panaku onno mai paharne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus loikaru wanakunu naho'ok onnenihe horu, Ai namharedi lolo onne ");
INSERT INTO kjeNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wali wali'ur laa Nina lekloi. Rakanedi An wakuku ri lolo Yahudi nina kerei raram. Heri man derne Ainina wanakunu eni polletilu, la ida ma ne'el ida na'ahenia, “Ri eni lernala woroin noro molollo man lewlewen eni nano ewi? ");
INSERT INTO kjeNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nin pape tukan au, ee ka? Nin mame lo'o ma naran Maria onne, la Yakobus, Yusup, Simon noro Yudas onne mo'oniwalinhe, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","La narna na'akeme holi mai eni haenhi. Ai nauroin ha rahu eniyeni nano ewi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ende hi ra'okuledi Yesus. Enimaa Yesus na'aheniyedi hi na'ahenia, “Nabi ida lolo ewi-ewi ri nahiyene arore, maa lolo nina lekloi noro nakar raram, ka.” ");
INSERT INTO kjeNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hi akin ka naili'il Ai, de Ai kan hi'i hahaa nammori ri kan dodo'onnala makun lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lere onne rai Herodes ma nodi molollo noho Galilea, derne Yesus Nina hini'i wenewhe rahue, ");
INSERT INTO kjeNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","la ne'el nina man hemen enihe na'ahenia, “Ai eni lo'o Yohanis man ulutada ri, de moriyedi ho'o me'e! Onne penia Ainina molollo aile hi'i ha man ri kan dodo'onnale makun.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nonolu Herodes hopon nina man hemen enihe kele Yohanis, wuku rala laedi bui raram me'e. Herodes hi'i heheni ono Yohanis dadiyaledi ai me'e na'ahenia, “Iknik agame nina holoor halauk na'aheni luli o moro Herodias ho.” Ai na'aheni onne ono Herodias onne, Herodes mo'oniwalla Pilipus hono. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lere onne Herodes raram nodi nesne Yohanis, maa namka'uk heri onnenihe ono hi rauroin Yohanis onne nabi. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Rakan lere Herodes nina lere alam momori, hir hi'i yapi. Herodias onne anan maekana lan waur lolo ri popolu lalariyala enihe kalarna. An waur ma'aruru rehi, de Herodes akin nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ende Herodes kikan hopo na'aheni, “Inhawa o mapanak, ya ala.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","An derne inna nin honopon nanumene napanak na'ahenia, “Mala Yohanis uluwakun, loile ra'u lap, mala maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes derne napanak onne, akin woir rehi, maa an kikanedi hopo me'e lolo heri man penu-penu onne kalarna, de an hopon hi'i lernohi maekana onne nina napanak eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","An hopon ri laa bui raram peku Yohanis uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Horu ne, rala Yohanis uluwakun loile ra'u lap rodi laa raram kanile maekana onne, mene ai nodi laa inna. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Onne horu, Yohanis nina man lernohi enihe derne, de mai rala ihin kemen rodi laa rawilo'edi nanumene lar konohi panaeku onne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus dernedi panaeku onneni, An ha'a laa korkoro ida namhara lolo onneni, hopol laa noho mamun ida. Maa heri onnenihe dernedi Ai nala'edi, de hi ramhara kota-kote, rala'ala'a ei lernohi Yesus lolo ro. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus rakanedi ro, An do'on heri rahu onneni ne, Ai raram penu rehi. Enime'ede An kopur laa ro, hi'i wa'an ri ma nakni'ir enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lere na'ikeki helem ne, Yesus Nina man lernohi pakunohi enihe mai ra'aheni, “Pape, lere helem me'e. Mai eni noho mamun, de wa'an narehi Pape hopon heri rala'a here, leke lar weli hanana'an lolo leke-leke man ranrani eni, ra'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus na'aheni hi, “Yono hopon hi rala'a, mi mehe mala hanana'an hi ra'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hir walha, “Ainima roti kem wolima noro i'in kem woro'o mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","19","An hopon hi na'ahenia, “Modi mai, la hopon heri rahu onne raikoredi.” Ai nala roti kem wolima noro i'in kem woro'o onne, niliha'a laa wawan mene napanak trimkasi Makromod Lalap. Horu, An a'un roti nala kanile Nin man lernohi pakunohi enihe leke ha'ar heri ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Heri rahu onne na'akeme ra'an hehen nanumene pehur. Horu ne, Nina man lernohi pakunohi enihe ra'ukwuku hanana'an ma narehi, lunu idaweli woro'o penpenu. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma na'ak lere onne lo'o mo'oni riwan wolima, kar aki maeke noro tatan'ukun. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Onne horu, Yesus hopon Nina man lernohi pakunohi enihe ha'a korkore rolu laa oir lapa wali, la An hopon heri onneni rala'a here. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Heri rahu onne rala'edi ne, Yesus wakiha'a wo'or ida man aile lolo onne hi'i lir napanak. Alamedi me'e, Yesus mehe aile lolo onne makun, la ");
INSERT INTO kjeNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","man ha'a korkoro eni rakanedi oir lape toro me'e, maa anna nano kalari, de korkoro onne wo'o do'odewe. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na'ikeki nohoropeni, Yesus nala'ala'a lolo oir ulikne laa hi. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hir po'on Ai nala'ala'a lolo oir ulikne rahumarnedi. Hir pene'ek maki hamarane, de wakau ono ramka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus walha hi, “Karkaramedi, Maya'u eni Yesus. Yono mamka'uk.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Enime'ede Petrus na'aheni, “Makrom'u! Namlolo kokkoo ki O Yesus, hopon ya ala'ala'a lolo oir ulikne ki.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus walha, “Mai!” Ende Petrus kopur nano korkore wawan nala'ala'a lolo oir ulikne laa Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Maa Petrus po'onala kahi anna namansa, ai namka'uk, de keper-keper me'e. Enla wakau na'ahenia, “Makrom'ue, pakuwala'u!” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Idewe Yesus nasala liman na'aheni, “Petrus, Petrus alhi'ihepe o akim tana! Alhi'ihepe kam pu'ik heli wawa'an Maya'ue?” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Enime'ede woro'ohe ha'a laa korkore wawanne la kahi anneni namlinedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Manin korkore raram ra'uli rasa'e ra'aheni, “Makromod, O penia namlolo kokkoo Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hir rakanedi oir lapa Galilea wali enne, hir kopur laa ro lolo Genesaret. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri man holi lolo onne rahiyennaledi man mai onne Yesus ne, hir konohi ri na'akeme ma na'urani lolo onne. Enime'ede hi rodi rir ma nakni'ir nammori mai Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Enla hi rapanak rehrehi lewlewen leke Yesus hurinohi ma nakni'ir enihe tukulala Nin rain eni, kade rain honon me'e wa'an. Ende man tukul Nin rainne na'akeme wa'an mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ler onne ri Parisi roro meser Horok Lap ida woro'o ramhara Yerusalem mai pakromo noro Yesus. Hir ra'ukani Yesus ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Hi'ihepeni Numa man lernohi pakunohi enihe larlewenedi ik upud a'adhe rira holoor halauke? Hi kar lernohi agame nin holoor halauke rawanedi liman mene ra'ak.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus walha na'ahenia, “Mi me'ene larlewenedi Makromod Lalap Nina keneri hono'ok, ono mi modi rehirehi mi upum a'umhe rira holoor halauke. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Makromod Lalap na'aheni, ‘Horhawa minima ri leleher,’ la ‘Inhoi ma nahopo nin ri leleher, hukumesnedie.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Maa mi mala nounaku namehin naise eniyeni: Lo'o ri ida paeku naramyaka nina ri leleher nala haida hi, mi ma'aheni, ‘Yon me'e, lo'o wa'an rehi modi ha onne laa hoikaniyedi Makromod Lalap,’ de ri leleher kan lernala haida. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ende ri onne kan horhawe nina ri leleher me'e, la mi ma'ihoru ma'idaru Makromod Lalap Nina nounaku, leke lernohi mi upum a'umhe rira holoor halauke. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi eniyenihe ri man kokme'e mamwali ri molololo. Nonolu eni Yesaya wakunu namlolo kokkoo, lere an wekel mi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Makromod Lalap na'aheni heheni: Ri onnenihe horhawa Ya'u rodi lirna mehe, maa akinhe ko'u wake'e Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hirira honoi kanani Maya'u kan min haida, ono hir nair ri mormori nina holoor halauk mehe ra'aheni onne Ainu'u, maa ka namlolo.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Horu ne, Yesus napolu heri onnenihe na'ahenia, “Derne makani, leke mauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ha man laa ri wawan raram kan hi'i rin morso, maa ha ma namhara nano ri wawan penia man hi'i rin morso.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesus Nina man lernohi pakunohi enihe mai ra'ukani ra'aheni, “Pape lo'o mauroin ri Parisi enihe ra'ahan? Hi kar suk derne Pape nin wanakunu enie.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus walha na'ahenia, “Au or'ori na'akeme man Ya Am'u man aile a'am raram kan kamane, lo'o he'uledi. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yono lernohi Parisi enihe. Hi onne ramwali uluwakun-uluwakun, maa makanhe tokedi. Enlo'o man maktoko norkaru maktoko, woro'ohe wau laedi moke raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus na'aheni Yesus, “Pape kene napa'aha wanakunu naho'ok onne mayai ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","An walha na'ahenia, “Emene mi na'akeme ka mauroin onne makun? ");
INSERT INTO kjeNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mi ka mauroin nahenia ha man ik ka'an, keper la namhara wali'ur? ");
INSERT INTO kjeNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Panaeku ma aile ri akin namhara nano ri nuran, onne penia man hi'i rin ‘morso’. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nano ri akin penia panaeku yakyaka mai paharne. Panaeku naise: ida ma nesne ida, lerpi'u lerwa'u, holi yak leke yak, poho mana'a, la wakunu nano'onyaka ri. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Panaeku onnenihe penia man hi'i rin morso, maa lo'o ri na'ak ka nawana liman, onne kan hi'i rin morso.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Horu ne, Yesus noro Nina man lernohi pakunohi enihe rala'a onnida ma na'urani lolo kota Tirus noro Sidon. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Maeke Kana'an ida lolo onne mai Yesus, wakau na'ahenia, “Makrom'u, Daud Anan, maramyakala'u. Ya an'u maekanida hayakyaka huhu'ur raram, de apinha wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus kan walha maeke onne. Enime'ede Nina man lernohi enihe mai Yesus rapanak na'ahenia, “Pape, hopon maeke onne nala'a here ono na'o'o ika mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus walha na'ahenia, “Makromod Lalap hopon Ya'u mai ri Israel mehe, ono hi raisa pipduma ma na'alehe man huri.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Maeke onne mai kadi ein korno lolo Yesus kalarna na'aheni, “Makrom'u, pakuwala'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","An walha na'ahenia, “Lo'o kan wa'an rala tatan'ukun rira hanana'an sopol laa ahu, na'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maeke onne walha na'ahenia, “Namlolo Makrom'u, maa ahu enihe peni ra'an ha mo'o ma nadiyaur nano makromon nina mei.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Enime'ede Yesus na'aheni, “Mame akin naili'il kokkoo, de num napanak eni na'ene namwaliyedi me'e.” Lere onne me'ede, anan wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus namhara lolo onneni, nala'a naulohir oir lap Galilea arkanne. Enla An wakiha'a laa wo'or ida naikoredi lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ri nammori mai rodi ri ma ein he'ehe'e, makan toko, naplu'uk nap'ekere, hakuku, la ri namansa man apinha namehin. Hir karu ma nakni'ir enihe Yesus kalarna, de Yesus hi'i wa'anedi na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Heri rahu man aile lolo onne polletilu, ono hir do'on man hakuku rauroin wakunuwedi, man ein he'ehe'e rala'a wawa'anedi, ma naplu'uk nap'eker lalaa mamaiyedi, la man makan toko do'onedi. Enime'ede hi na'akeme ra'uli rasa'a Israel rira Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Enla Yesus napolu Nina man lernohi pakunohi enihe na'ahenia, “Ya'u raram penu rehi heri rahu enie. Alam wokelu me'e hir lernohi Ya'u, ka rodi hanana'an, de Ya amhene huri hi ramlarlara rala'a, kalo'o hir uma lolo kalla.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hi ra'ukani Yesus na'ahenia, “Am laa ewi leke lernala hanana'an lolo noho mamun enie, heri rahu eni ra'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ai na'ukani hi wali'ur, “Minim roti kem wo'ira aile?” Hir walha, “Kem wo'ikku noro i'in kemana woro'o wokelu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kame'ede Yesus hopon heri rahu onne raikoredi, ");
INSERT INTO kjeNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","la Ai nala roti kem wo'ikku noro i'in. Ai napanak trimkasi Makromod Lalap horu mene An a'un roti la uku i'in onneni nala Nina ri mememen enihe ha'ar heri rahu ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Heri rahu onne ra'an hehen nanumene pehuredi. Ra'ak horu Nin ri enihe ra'ukwuku hanana'an rehin na'akeme lunu wo'ikku. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lere onne aki mo'oni ma na'ak enihe ri riwan wo'akka, kar aki maeke noro tatan'ukun. ");
INSERT INTO kjeNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Onne horu, Yesus hopon heri rahu onne rala'a, la An ha'a laa korkoro ida hopol laa noho Magadan. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri ida woro'o nano muku Parisi noro muku Saduki mai Yesus leke ken patal Ai. Hi rapanak An hi'i ha man ri kan dodo'onnala makun ida leke namwali tanada nahenia kokkoo An mai nano Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","An walhe na'ahenia, “Ler heheleme mim po'on a'am memere, mi ma'aheni noho lo'o mou, ");
INSERT INTO kjeNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","la al'alam mim po'on a'am memere la ma'uwodow, mi ma'aheni lo'o okon mai. Mi mauroin napa'aha a'am nina tanade, maa ku eniyeni nina tanade mi ka mauroin napa'ahe. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kulere enie ailanna la akinhe ka namkene naili'il Makromod Lalap. Mi mapanak Ya'u hi'i tanada man ri kan dodo'onnala makun, maa Ka'u hi'i haida mim do'on, naukara inhawa ma namwali noro nabi Yunus mehe.” An wakunuwedi heheni nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus noro Nina man lernohi pakunohi hopol laa oir lapa wali, maa hir hamlinuwedi rodi roti. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ai na'aheni hi, “Nakinemen ki mi! Madiyakyaka ri Parisi roro ri Saduki enihe ono rira wanakuku naisa ragi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hir derne Nina wanakunu onne me'ede ida ma ne'el ida na'ahenia, “An wakunu heheni ono ka kodi roti.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ai nauroiroin rir wanakunu me'e, de na'aheni, “Hi'ihepenia mi mawalha lira ma'aheni ka modi roti? Mi na'akeme akim ka naili'il wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mi ka mauroin makun! Hi'ihepenia mim hamlinuwedi roti kem wolima man Ya a'un, male ri riwan wolime ra'ane? Mim ra'ukwuku roti ma narehi, lunu wo'ira? ");
INSERT INTO kjeNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","La hi'ihehewi noro roti kem wo'ikku mala ri riwan wo'akka onne ra'an? Mim ra'ukwuku hanana'an rehi, lunu wo'ira? ");
INSERT INTO kjeNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Alhi'ihepe mi ka mauroin makun nahenia Ka'u wakunu roti mehe! Nakinemen ki mi moro ri Parisi noro ri Saduki rira ragi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Enime'ede hir eremnala Ainin wanakunu onne ka na'ono ragi rodi ralha'a roti, maa ri Parisi noro ri Saduki rira wanakuku, de wa'an rehi hi rahaledi kemen nano wanakuku onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Enla Yesus noro Nin man lernohi enihe rala'a rakanedi noho Kaisarea Pilipi, la Ai na'ukani hi na'ahenia, “Ri nadedem wekel Ri Mormori Anan onne inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hir walha na'ahenia, “Ri aile ma na'aheni Ai onne Yohanis man ulutada ri, heruwali ra'aheni Elia, namehin ra'aheni Yeremia alka lo'o nabi namehin.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ai na'ukani hi wali'ur, “Emene lernohi minim panaeku, Ya'u eni inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus walha na'ahenia, “Papa penia Kristus man kikan namwali Rai, la O penia Makromod Lalap man mori laa ewi-ewi Anan.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","An walhe, “Simon, Yunus ananne, o akim nahuwa'anedi, ono ri mormori kan konohi panaeku eni ki o, maa Ya Am'u man aile a'am raram penia konohi o. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya'u konohi o mamwali Petrus, ono o maise waku ma naruri. Lolo waku eni Ya ariri Ainu'u kerei, la Hayakyak Makromon ka naiye'er. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Makromod Lalap Nina noho worworu nina konse Ya ala ki o. Inhawe kenekrohu mim hi'i lolo noho wawanne, Makromod Lalap hi'iyedi lolo a'am raram me'e. Lo'o mi ma'aheni, ‘Yono,’ Makromod Lalap na'aheniyedi, ‘Yono,’ haenhi. Lo'o mim hurinohi rin hi'i haida, Makromod Lalap hurinohiyedi haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Onne horu, An hopon hi yono konohi ri nahenia Ai onne namwali Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nano lere onne me'ede, Yesus konohi mouropo Nina man lernohi pakunohi enihe nahenia Makromod Lalap Nin panaeku Ai nala'a laa Yerusalem. Laa enne An lernala wewerek pananaka nano Yahudi rir leleher lalap, imam lalapa roro meser Horok Lap enihe. Lo'o resne Ai, maa rakan lere wokelu An mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Enime'ede Petrus ni'ik Ai laa herne dadiyale na'ahenia, “Alhi'ihepe wakunu heheni? Ya apanak Makromod Lalap nako'u nahaledi panaeku onne leke yono na'ene namwali Makrom'u kemen.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus po'onala ai na'aheni, “Hayakyak Makromon o! Mala'a here. O mamwali our heliyowok au heliyowok Maya'u. Num panaeku onne ri mormori nine, Makromod Lalap ka.” ");
INSERT INTO kjeNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Onne horu, Yesus na'aheni Nina man lernohi pakunohi enihe, “Ri man raram nodi lernohi Ya'u, yon nodi nina raram nodi aimehi, maa na'uwara nina au kekiyowok la lernohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ya a'aheni eniyeni ono inhoi namka'uk ihin kemen maki de namhene huri nin morimori lolo noho wawan eni, ai onne kan lernala or'ori dardari ma namlolo. Maa ri man huriyedi nin morimori lolo noho wawan eni leke lernohi Ya'u, ai onne lernala or'ori dardari ma namlolo ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lo'o ri ida manarna noho wawan nin ha wo'ira na'akeme, maa kan lernala or'ori dardari ma kan horu, nin panaeku onne kan min haida. Ai lo'o nala inhawe leke lernala or'ori dardari ma kan horu? ");
INSERT INTO kjeNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ri Mormori Anan noro Nina hophopon a'am raram mai rodi Aman Nin molollo ma narehi ma nalewen. Lere onne me'ede An mai herre walha ri dohodoho nina hini'i wenewhe. ");
INSERT INTO kjeNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Horhorok Ainu'u nou ma na'ono eniyeni: Lolo mi eniyeni man min lolo eni, heruwali kam maki hehen nanumene mim do'on Ri Mormori Anan nodi molollo namwali Rai noho wawan.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesus wakunu na'akeme onne horu, nakawedi lere woneme ne, Ai napolu Petrus, Yakobus noro mo'oniwalla Yohanis lernohi Ai wakiha'a laa wo'or kukulu ida. Hir memehedi lolo onne, ");
INSERT INTO kjeNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","la hir po'on Yesus kemen namehiyedi me'e, oin makan siksika naise lere, la Nin rain wawarha alellele. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hi ramlilinnohi do'on Musa noro Elia hariyedi roro Yesus wakunkunu. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Enime'ede Petrus na'aheni, “Makrom'u, ma'aruru rehi ik min mai eni, de lo'o Papa raram nodi ya a'ariri heuheu wokelu lolo eni, ida Makrom'u nine, ida Musa nine, la ida Elia nine.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","An wakunkunu makun, kakam yorno ida mai pupinala hi. Hir derne lira ida nano kakam onne raram na'aheni, “E'eni Ya An'u, Ya amre'e Ya amharu Ai, la An hi'i Ya akin nahuwa'an. Mim derne makani Ai!” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hir derne lir onne, hi ramka'uk rehi me'e, de ralwali yawa, ");
INSERT INTO kjeNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","maa Yesus mai roul hi na'aheni, “Mamririyedi, yono mamka'uk.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hir po'on wali'ur ne, kar do'on ri namehin onnenihe me'e, la Yesus memehedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Onne horu, hir kopkopur lolo wo'or laa yawa, la Yesus nou hi na'ahenia, “Yom konohi ri inhawe mim dodo'on eni hehen nanumene Ya'u ma namwali Ri Mormori Ananne maki la mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Enine hi ra'ukani Ai, “Alhi'ihepenia meser-meser Horok Lap ra'aheni Elia mai nolue?” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","An walhe na'ahenia, “Memen namlolo, Elia mai nolu na'akene ha rahu namkene. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ya'u konohi mi nahenia Elia maiyedi me'e, maa ri ka nahiyennale. Hi rodi rira suke hi'i sus Elia naise lere man mai hir hi'i sus Ri Mormori Ananne haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eni nanumene hi rauroin Yesus Nin wanakunu onne na'ono Yohanis ma nodi oir ulutada ri eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus noro ri wokelu enihe kopuredi wo'or eni po'on ri nammori, la mo'oni ida mai kadi ein korno Yesus kalarna ");
INSERT INTO kjeNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na'aheni, “Pape, maramyakala ya an'u ke'e. An apinha pipi haha'al, de ai nadedem nediyawa ai laur noro oir raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yo odi laedi Pape Nina man lernohi pakunohi enihe me'e, maa kar paekunale hi'i wa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus walha na'ahenia, “Eih! Mi ku eniyeni kam derne makani la mi akim ka naili'il kokkoo. Yo oro mi nalo'oledi me'e, maa mi akim ka naili'il Maya'u wawa'an makun! Rakan ma'anana ho'o Ya'u kerhu oro mi mene mi akim naili'il kokkoe? Modi tatana onne mai.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Enime'ede An hopon hayakyaka man aile tatana onne raram namharedi. Lere onne me'ede, hayakyaka namhara, la tatana wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Horu ne, Nina man lernohi pakunohi enihe hoi na'urani, ra'ukani na'ahenia, “Hi'ihepenia ai kam paekunala mohi ha yakyaka onne?” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","An walha na'ahenia, “Horhorok! Mi kam paekunala mohi hayakyak onne ono mi akim ka naili'il wawa'an Ya'u makun. Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lo'o mi akim naili'il Makromod Lalap, kade tarana mehe naise aukawi waku man tutusiyane, maa mim paekunala hopon wo'or eni hoi laedi onno namehin, wo'or eni lernohi minim honopon onne de hoi laa. Inhawa memehe mim paeku hi'i, onne namwali.  ");
INSERT INTO kjeNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Enla hayakyaka naise enie mi modi molollo mohie, horo ma'aluli kemen ka ma'ak nanumene hi'i lir napanak Makromod Lalap.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Enla Yesus Nina man lernohi pakunohi enihe pakromo wuku lolo Galilea ne, Yesus na'aheni hi, “Ka nalo'ol me'e ri na'olu Ri Mormori Ananne kanile ri mormori liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hi lo'o resnedi, maa rakan lere alam wokelu An mori wali'ur.” Hir derne ne, akinhe woir wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus noro Nina man lernohi pakunohi enihe rakan Kapernaum, man ra'uk paipair ida mai na'ukani Petrus na'ahenia, “Minim Meser nadedem pair Makromod Lalap Nin Romleu Lape nin paipair, ee ka?” An walha, “An paire.” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus wali laa nakar ne, idewe Yesus na'ukani, “Simon, hi'ihewiyala numa panaekue? Lo'o rai noho wawan enihe rapanak paipair nano inhoi? Nano rira ri, ee ri ma nano paharne?” ");
INSERT INTO kjeNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus walha, “Ri ma nano noho paharne.” Yesus na'aheni ai, “Ende yon rai nin ri pair me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maa yono ik hi'i ri onnenihe akin yaka, de mala'a oir lap ma'ili i'in. Om lae ne, i'in om wowo'ok dedesne, hari wawan. Lo'o om do'on kupan man noknokor rodi pair ikroko nika paipair, de mala kupan onne modi lam pair iknika paipair onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lere onne man lernohi pakunohi Yesus enihe mai ra'ukani Ai na'ahenia, “Nano mayai eniyenihe inhoi man kulu narehi lolo Makromod Lalap Nina ri na'akeme?” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kame'ede Yesus napolu tatanida mai napanak namriri hi kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Eni nanumene Ai ne'el hi na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lo'o mi kam herre minim morimori, leke maise tatana eniyeni, Makromod Lalap kan huri mi laa onno man Ai nodi molollo raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ende inhoi nin morimori naise tatana eniyeni de kan holi kukulu lalap, ai penia man kulu narehi lolo Makromod Lalap Nin ri. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Enla inhoi kokala tatanida naise eniyeni ono hir lernohi Ya'u, hi onne kokala Ya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Maa inhoi nakoko tatana ma akin naili'il Ya'u hi'i dohohala, wa'an rehi wairredi waku lapida ri onne kelenne la rodi laa ra'akeperedi heleken. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lere man mai noho wawan eniyeni mayo'o ono kenen panatal aile ma nakoko ri hi'i dohohale mamani. Lolo noho wawan eni kenen panatal nammori aile, maa ri man ken patal ri namehin de nakoko hi'i dohohala, ai onne mayo'o narehi! ");
INSERT INTO kjeNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Lo'o mi liman ein nakoko mi hi'i dohohala, heru sopoledi. Yonde mi liman ein wawa'an, maa nakoko mi laa kawali pire ai porom raram laa ewi-ewi. Wa'an rehi mi liman ein wali kaale, maa mim lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lo'o mi makum wali nakoko mi hi'i dohohala, hidue sopoledi. Yonde mi makam wa'awa'an, maa hi'i mi laa kawali pire ai porom raram. Wa'an rehi mi makam wali mehe, maa mim lernala or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ya'u konohi mi! Yono mim hadwei ri ida nano tatana eniyenihe ono hirira hophopon a'am raram namkenkene aile Makromod Lalap herne kalarna lolo a'am raram.  ");
INSERT INTO kjeNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ya'u, Ri Mormori Ananne, mai leke ri ma nako'uwedi Ya'u lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ri ida nina pipduma waku rahu ida, la pipi waku ida nahineiredi. Ri onne lo'o paeku hehewi? Ai lo'o hoikaruwedi welihii wohii lolo wo'or, laa nanoin ma nahineiredi eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ai akin nahuwa'an ono nin pipduma welihii wohii kar molu, maa lere an holikuku pipduma man molu onne, ai akin nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mi Aman man aile a'am raram naise man huri pipi onne. Ai namhene tatanida nako'u nano Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Lo'o mi wallum ida hi'i yaksala noro mi, laa moro ai wakunu mehe, leke kukunohi ainina saleni. Lo'o an derne nakani, more mahuwa'an wali'uredi, ");
INSERT INTO kjeNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","maa lo'o kan derne, moro wallumhe man lernohi Yesus ida woro'o laa lekpananne ramwali man kukumaka num wanakunu, ewi man sala la ewi ma namlolo. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lo'o ri onne kan derne nakani makun, lam konohi kerei raramne. Lo'o namhene derne wali'ur, yon mawaur noro ai naise mi ka madedem mawaur noro man ra'uk paipaire noro ri ma ka nauroin Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Horhorok Ainu'u nou ma na'ono eniyeni: Inhawe kenekrohu mim hi'i lolo noho wawanne, Makromod Lalap hi'iyedi lolo a'am raram me'e. Lo'o mi ma'aheni, ‘Yono,’ Makromod Lalap na'aheniyedi, ‘Yono’ haenhi. Lo'o mim hurinohi rin hi'i haida, Makromod Lalap hurinohiyedi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ya'u konohi mi wali'ur, nano mi man minle noho wawan eniyeni, lo'o ri ida woro'o lawuku aki panaeku ida la hi'i lir napanak, inhawe mi mapanak Makromod Lalap man minle a'am raram, Ai nala ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lo'o ri woro'o wokelu minwuku lolo onnida ono hir lernohi Maya'u, Ya'u aile lolo onne haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kame'ede Petrus mai Yesus na'ukani, “Lo'o ya ala ampun rew'ira i wal'u man hi'i sala maya'u? Lo'o rew'ikku?” ");
INSERT INTO kjeNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Enine An walhale na'ahenia, “Rew'ikku ka! Maa weli'ikku nala rew'ikku! ");
INSERT INTO kjeNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ya aheni heheni ono lere Makromod Lalap nodi molollo ri mormori naho'ok naise rai ida ma nala kenekrohu ra'ukwuku nin man howok enihe rira okon raka na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ler ida rai onne mahan ra'ukwuku okon raka onneni, nin ri rodi nin man howok ida mai. Nonolu eni ai napanak kupan nammori rehi, maa kan herre makun. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ri onneni kan paekunala herre nin kupan napapanak onneni, de rai hopon ra'olu ai noro hono ananhe noro rira hahaa na'akeme leke herre kupan onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Maa nin man howok onne lan kadi ein korno rai eni kalarna napanak na'ahenia, ‘Papa raie, ya apanak ke'e de, mala leken taran maya'u mene ya'u herre kupan onneni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Enime'ede rai nararamyakale, de nala ampun la namhene an herre kupan onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Enla ri onne namhara nano rai lan pakromo noro man howok wali man nonolu napanak ainin kupan tarana, maa kan herre makun. An ramhala kelen la hopon, ‘Herre ainu'u kupan here!’ ");
INSERT INTO kjeNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Man howok wali onne kadi ein korno kalarna napanak rala leken tarana mene herre kupan onne, ");
INSERT INTO kjeNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","maa ai namhene. Ende hopon kele ri onne rodi laedi bui raram hukum hehen nanumene an herre kupan onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ri man howok namehin po'on inhawa ma namwali onneni, hir hehel rehi de lar konohi rai eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ende rai napolu nin man howok onne mai ne'el na'ahenia, ‘Om ailanna wake'e! Ya'u huriyedi o nano num okon raka rahu eni ono mapanak ampun de ya araramyaka o. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Alhi'ihepe ka mararamyaka ri namehin naise ya araramyaka o eni?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rai na'ahan rehi de nala ri onne laa ma nadiyaka ri ma nahinukum enihe leke lernala hunukum hehen nanumene herre nin okon raka horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ende lo'o mi ida ma ka nala ampun ida modi aki man mou, Ya Am'u man minle a'am raram hi'i heheni noro mi haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nala wanakunu onne horu ne, ai namhara Galilea nala'a noho Yudea man aile oir wauwau Yordan wali enne. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Heri rahu lernohi, la An hi'i wa'an ma nakni'ir nano heri onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ri Parisi ida woro'o mai leke ken Ai de ra'ukani, “Lo'o iknika agame nina holoor halauk hurinohi mo'oni reiha'ar noro hono?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","An walhe na'ahenia, “Mim lesedi Horok Lapeni, ee ka? Horhorok aile Horok Lapeni ma na'aheni, ‘Lere nonolu me'ede, Makromod Lalap umupala ri mormori, mo'oni noro maeke.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Horu Makromod Lalap na'aheni, ‘Onne penia mo'oni hoikaruwedi inna aman leke noro hono minwuku, de woro'ohe ramwali mahaku.’ Ende inhoi-inhoi Makromod Lalap kali wukuwedi me'e, yono ri mahaku reiha'ar ono hi penia ka ramwali woro'o, maa ramwaliyedi mahaku me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hi ra'ukani Ai wali'ur, “Alhi'ihepe Musa hurinohi mo'oni hi'i horok reiha'ar nala hono, la hopon ai nala'a here?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","An walhe, “Musa nala leken reiha'ar ono mi akim kerhe rehi, maa nano lere dedesne Makromod Lalap kan paeku heheni. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya'u konohi mi na'akeme, Makromod Lalap kan huri ri reiha'ar noro hono, ono lo'o ai namhene hono lan ho maeke namehin, an lerwau hailai. Maa lo'o hono lerwa'u noro mo'oni namehin mene huri hi reiha'ar.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesus Nin man lernohi pakunohi enihe ra'ukani na'ahenia, “Hi'i heheni ne, wa'an rehi yono ho me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus na'aheni, “Ri na'akeme kar kokala panaeku onneni, kokoko ri man Makromod Lalap niliyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Heruwali mori me'ede oplori maekedi, heruwali rin hi'i oplori maekedi de kar ho ri, la heruwali rala kenekrohu kar ho leke lernohi Makromod Lalap mehe. Ende inhoi paekunala kokala wanakuku eniyeni, kokala wawa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Enla ri heruwali rorkaru tatan'ukun mai Yesus leke An kemenala liman hi la hi'i lir napanak, maa Nin man lernohi pakunohi enihe ra'ahan de dadiyala ma norkaru tatan'ukun onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Enimaa Yesus na'aheni, “Hurinohi tatana onnenihe mai Maya'u! Yom kawala hi ono Makromod Lalap nodi molollo ri ma naise tatana eniyenihe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ende An kemenala liman tatan'ukun la namre'e namharu hi horu mene namhara lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lerida ma na'ikaka ida mai Yesus na'ukani, “Pap Meser, lo'o ya'u hi'i inhawa hini'i wenewhe man wa'an leke lernala or'ori dardari ma kan horu?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus na'ukaniyale, “Alhi'ihepe ma'ukani Ya'u inhawa man wa'ane? Ida mehe aile man wa'an! Lo'o o raram nodi lernala or'ori dardari ma kan horu, lernohi ik Makromod Lalap Nin keneri hono'ok na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ri onne na'ukani wali'ur, “Ya'u lernohi inhawa keneri hono'ok ho'o?” An walhale, “Yono mesne ri, yon lerpi'u lerwa'u, yon mamna'a, la yon modi poho tumdesne ri lolo hono'ok kanail onno. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Horhawa o inum, o ammu, la maramyaka numa ri mormori wali, naise o maramyaka o kemmu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma na'ikaka onne walha, “Ya'u lernohiyedi keneri hono'ok onne na'akeme me'e, de ya'u hi'i inhawa ma kan kuku kan nokor makun?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus na'aheni wali'ur, “O raram nodi num hini'i wenewhe kukuku noknokor lolo Makromod Lalap kalarna, laa ma'oluwedi num ha wo'ira na'akeme, male ma na'alehe haida-haida nanumene mam lernohi Ya'u. Lo'o om hi'i heheni, om lernala kanaru man aile a'am raram!” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Enimaa ri onneni derne Nina wanakunu eni hehel rehi, ono ai onneni ri orkanaru wake'e, de nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Enime'ede Yesus ne'el Nin man lernohi pakunohi enihe na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Sus wake'e orkanaru laa onno man Makromod Lalap nodi molollo raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya'u konohi mi wali'ur: Sus wake'e unta waku ida lolala wanaka ku'il, maa man sus narehi onne, orkanaru ida laa minle onno man Makromod Lalap nodi molollo.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hir derne Nina loloi kakaru ne, hir mehe kakaiyedi la ra'ukani, “Ende inhoi man lernala or'ori dardari ma kan horue?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","An po'onalahe na'aheni, “Ri mormori kan paekunala hi'i ha onneni namwali, maa Makromod Lalap mehe paekunala hi'i ha wo'ira na'akeme namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kame'ede Petrus na'ukani Ai, “Mayai eniyenihe, am hoikaruwedi ha wo'ire na'akeme me'e leke lernohi Pap Meser, de lo'o am lernala inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","An walhale na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Lere man mai Makromod Lalap hi'i ha rahu na'akeme worworu. Lere onne Ri Mormori Ananne naikoro lolo Nin onno man siksik lerlere, la mi man lernohi Ya'u enihe maikoro onno kukulu idaweli woro'o leke ho'ok kail Israel nin luhu idaweli woro'o enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Enla inhoi man hoikaruwedi inna, aman, lodon walin, ananhe, noro nina kirne nakar leke lernohi Ya'u, ri onneni lernala wali'ur rewen rahu ida, la ai onne lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Maa ri nammori ma namwali man panulu lere eniyeni, lere man mai ramwali man lolo yawa. Ri nammori ma namwali man lolo yawa lere eniyeni, lere man mai ramwali man panulu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus nala wanakunu naho'ok konohi hi'ihehewi Makromod Lalap nodi molollo ri mormori na'ahenia, “Al'alam lerida orkirna ida namhara laa nanoin man howok leke howok nina kirna. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","An lernaledi ri, la ne'e pair man howok onnenihe alam ida kupan pere ida, la hopon hi lar howok me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Riuk wohii an laa pasar do'on ri ida woro'o ra'aroromo, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","de napanak hi lar howok nina kirne haenhi, la nou nala naiwe'el ma namlolo hi, de lar howok me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Riuk idaweli woro'o, noro riuk wokelu (lere mamamal) namhara wali'ur nanoin man howok. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Riuk wolima (na'akeki lere helem) namhara ho'o me'e, la an do'on ri ida woro'o ra'alehe honowok, de na'ukanihe, ‘Alhi'ihepenia lere eniyenia ma'aromo mamani la kam howok haida-haide?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Enine hir walha ra'ahenia, ‘Ri ka nala honowok mayai.’ Orkirna na'aheni, ‘Lam howok ainu'u kirna enne.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Rakan lere helem orkirne onne hopon nin ma namwali uluwakun man howok enihe napolu man howok kirna enihe maiwuku leke pair rira maha-mahe. An pair man howok kauli'ur nolu, mene pair ma nolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Man howok kauli'ur enihe kokala kupan pere ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ende man mai nolu howok, pene'ek lo'o pair hi narehi man kauli'ur, maa mai ne kokala kupan pere ida haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Enpenia man howok nolu onnenihe akin apinha, de rawalha lira noro orkirna eni ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Alhi'ihepenia ri eniyenihe howok jam ida mehe, maa pair hi namnenehe noro mayai? Am howok lere kekeme lolo lere manmanha raram!’ ");
INSERT INTO kjeNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Orkirne onneni walhala man howok ida na'ahenia, ‘Ya'u ka'u hi'i sala ida noro i wal'u. O me'e kokala kupan pere ida penia mam howok. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kokala kupan eniyeni la mala'a here. Ya'u raram nodi pair man mai howok kauli'ur namnenehe noro o. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yo odi ainu'u kupan pair, de menmololla'u. Lo'o makehen ono ya'u hi'i ha man wa'an noro hie?’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesus na'aheni wali'ur, “Ende man kauli'ur namwali ma nolu, la ma nolu namwali man kauli'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus noro Nina man lernohi pakunohi idaweli woro'o enihe rala'a laa Yerusalem. Ahille kalla makun, An kukunohi hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Makaniyala! Lere eni ik kala'a mamani laa Yerusalem. Ik rakan enne, ri na'olu Ya'u, ma namwali Ri Mormori Anane, nala kanile imam lalape roro meser Horok Lap enihe mene hir hukumnesnA'u, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","la rala Ya'u kanile ri ma ka namwali Yahudi enihe. Hir ilnohi ralnohi Ya'u, riuk rerhe Ya'u, la wairesne Ya'u lolo au kekiyowok. Maa alam wokelu Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yakobus, Yohanis, noro inna (hono naran Zebedeus) mai Yesus. Inna kadi ein korno Ai kalarna leke napanak haida. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus na'ukani ai, “Mame nina panaeku inhawe?” Ai na'aheni, “Ya apanak lere Makrom'u mamwali Rai, ya an'u woro'o enihe raikorala herum mariri malanna.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Maa Yesus ne'el ai, “O ka mauroin inhawe man mapapanak onneni.” Yesus po'onala anan woro'ohe, na'ukani, “Mi lo'o mamkene momun oir man meru nano cawan ma ka nalo'ol Yo omune?” Hir walha, “Ai mamkene, Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus ne'el, “Namlolo, mi lo'o momun oir man meru nano Ainu'u cawan, maa Ka odi molollo wekel inhoi naikoro Ya'u herne mariri malanna. Ya Am'u niliyedi ri man Ai raram nodi naikoro lolo onne, la na'akenedi rir onno me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Man lernohi pakunohi idaweli namehin derne woro'ohe rira napanak eni ne, hi ra'ahan. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Enime'ede Yesus napolu hi na'akeme maiwuku, na'aheni, “Mi mauroin nahenia hair-hair rira rai-rai roro rir uluwakun lalapa ma ka nauroin Makromod Lalap enihe, rodi molollo kerne dalha ri mormoriyane, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","maa yom hi'i heheni. Inhoi raram nodi namwali man panulu lolo mi, ai namkene ilitolle mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Inhoi raram nodi namwali ma nolu, ai onne helkaki namdaru namkene namwali hophopon wahwahan ki mi, ");
INSERT INTO kjeNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","leke maise Maya'u ma namwali Ri Mormori Anane. Ka'u mai leke rin ilitolle Maya'u, maa Ya'u mai leke ilitolle ri la ala I kem'u resne leke huri we'er ri nammori nano rira dohohale.” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus noro Nina man lernohi pakunohi enihe ramhara nano Yeriko, ri namansa lernonohi hi. ");
INSERT INTO kjeNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lolo kalla, ri maktoko woro'o raikoro aile kalla arkanne. Hir derne Yesus lo'o lole kalla onneni, de wakau ra'aheni, “Makromod Yesus, Daud Anan, maramyakala mayai ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Heri rahu onnenihe dadiyala woro'ohe, “Karkaramedi!” Maa hir wakau eren rarururi, “Makromod, Daud upun anan, maramyakalai ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus rakanedi woro'ohe miminloleni ne, Ai namririyala, napolu woro'ohe la na'ukani, “Mi raram nodi Ya'u hi'i inhawa ki mie?” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hir walhe, “Makromod, ai raram nodi do'onedi here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus nararamyakala woro'ohe, de kemenala liman makanhe. Idewe woro'ohe makan mouwedi la lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus noro Nina man lernohi pakunohi enihe ra'uraniyedi Yerusalem, na'akeki rakan lekida naran Betfage man aile wo'or Zaitun leren. Yesus hopon Nina ri woro'o rolu ");
INSERT INTO kjeNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","laa leke onne la Ai na'aheni, “Lolo onne mim do'on keledei ida na'inonorok noro anan, de we'er modi woro'ohe mai. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lo'o ri na'ukani na'ahenia, ‘Maham hi'i inhawa?’ ma'aheni, ‘Makromod hopon mayai mai mala keledei enihe.’ Mi ma'aheni heheni, hir hurinohi mi'ik modi mai.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Panaeku eniyeni namwali leke na'akuku na'anokor inhawe man nonolu nabi ida na'aheni, “Konohi ri man minle kota Sion heheni, ‘Po'onala, ");
INSERT INTO kjeNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","minim Rai mai me'e. Ai lo'o mai helkaki namdaru, naikoro keledei anan.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kame'ede woro'ohe lernohi inhawe man An kononohi, de rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hir wali mai riri'ik keledei noro anan onne mai Yesus, la ruri rira rain rodi pakpake leke naikorole. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ai naikoredi keledei anan eni, heri nammori ruri rira rain rala werre kalle wawan, la heruwali peku aukawi wakal kalle haenhi leke namwali tanada nahenia hir kokala Ai noro wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Enla heri onnenihe ma nolu man kauli'ur wakau ra'aheni, “Hosana! Ka'uli kasa'a Daud Anan! Makromod Lalap namre'e namharu Ai man mai nodi Makromod Oin Naran man kulu narehi! Ka'uli kasa'a Makromod Lalap man aile a'am raram” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus rarakan kote ne, Yerusalem ne'en raram na'akeme derne mouwedi la ramhara ra'ukani, “Ri onne inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Heri man lernohi enihe walha ra'aheni, “Ai penia Yesus, ma namwali nabi ma nano Nazaret noho Galilea.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus rakanedi Makromod Lalap Nina Romleu Lapa nin nikoin, Ai nohi ri ma na'iwali lolo waliwali onnenihe. Ai nawaliyedi mei man rodi herre kupan la nawaliyedi awana ma na'olu merpati enihe raikorkorole. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ai ne'el heri onne na'ahenia, “Lolo Horok Lap raram, Makromod Lalap konohi, ‘Ainu'u Romleu Lapeni namwali onno rin mai leke hi'i lir napanak, maa mim hi'i namwali ma namna'a hahaa rir sunuwar onno.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus aile nikoin makun, ri man mak toko roro ma ein he'ehe'e mai, la An hi'i wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Imam lalapa roro meser Horok Lap enihe ra'ahan ono do'on Yesus hi'i ha ri kan dodo'onnala makun onne, la derne tatan'ukun maha ra'uli rasa'a Ai lolo onne ra'aheni, “Ai ma'uli masa'a Daud Ananne!” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ende hi ra'ukani Yesus na'ahenia, “Om derne tatana eniyenihe rira ul'uli sasa'eni, ee ka?” An walha na'ahenia, “Ya'u derderne. Lo'o kam lesala Horok Lape Lirna ma na'ahenia, ‘Om hi'i tatan'ukun roro tatana man huhuhu makun ra'uli rasa'a O Oin Naran wawa'an.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kame'ede An hoikaruwedi hi, la namhara kote nala'a leke Betania, namkuru lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nohoropo Yesus wali wali'ur laa Yerusalem, kan rakan makun namlaredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","An do'on ara onida aile kalla arkanne, de laa na'urani ara onne na'inau ke'ede, woi, ee ka. Maa kan woi, kawin mamani, de Ai nakineri ara onne na'ahenia, “Kam woi laa ewi-ewi me'e!” Idewe ara onne namlau la makiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesus Nina man lernohi pakunohi enihe po'on ara onneni, hir polletilu de ra'ukani na'ahenia, “Heih! Alhi'ihepenia ara onne idewe napro'ukedie?” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Enime'ede Yesus walhala hi na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Lo'o mi akim naili'il wawa'an la mamkene lernohi ik Makromod Lalap, mim hi'i panaeku ma naise eni haenhi. Enla lo'o mim hopon wo'or eniyeni na'ahenia, ‘Laedi kahi raram!’ wo'or eni laa. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ende inhawe mi mapanak lolo lir napanak, mim lernala horo mi akim naili'il kokkoo.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus wali wali'ur laa Makromod Lalap Nina Romleu Lapa nin nikoin mahan wakuku ne, imam lalap roro Yahudi rir leleher lalap enihe mai ra'ukani Ai na'ahenia, “Inhoi nala molollo ki O, penia mam hi'i ha eniyeni na'akeme?” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","An walha hi na'ahenia, “Lo'o Ya a'ukaniyala paphe na'ukankani ida nanu. Ya'u konohi mi Yo odi molollo nano ewi hi'i ha eniyenihe, horo nahenia paphe walha Ainu'u na'ukankani eni namlolo kokkoo: ");
INSERT INTO kjeNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanis onne lernala molollo nano ewi nodi oir ulutada ri? Nano Makromod Lalap, ee nano ri mormorie?” Kame'ede ida ma nawalha lira noro ida ra'ahenia, “Ik ka'aheni nodi Makromod Lalap Nina molollo, enlo'o na'ukani ik, ‘Alhi'ihepe mi akim ka naili'il Yohanis nina wanakunue?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Maa lo'o ik ka'aheni, ‘Nodi ri mormori nina molollo, kamka'uk heri onne, ono hi rauroinedi Yohanis onne nabi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ende hir walha ra'ahenia, “Ai ka mauroin.” Yesus na'aheni, “Ka'u konohi mi inhoi nala molollo Maya'u hi'i ha eniyeni haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus na'aheni wali'ur, “Derne makani wawa'an wanakunu eniyeni: Papa ida anan mo'oni woro'o. Ai lan hopon anulu na'ahenia, ‘Pa'e, lere eni om laa kirne howokala.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anan walha, ‘Ka'u laa me'e,’ maa nahinorokala wali'ur de nala'a kirna me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Papa onne hopon anan karuri laa kirna haenhi. Anan walha, ‘Wa'an pape,’ maa kan laa kirna. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nano tatana woro'o onne inhoi lernohi aman nin akie?” Hir walha, “Anulu eni.” Yesus ne'el imam lalap roro Yahudi rir leleher lalap onnenihe na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Ri man ra'uk noho nin paipaire noro maeke man holi yaka leke yaka enihe laa onno man Makromod Lalap nodi molollo raram rolu mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanis mai leke wakuku mi kalla ma namlole, maa mi akim ka naili'il nina wanakuku eni. Enimaa man ra'uk paipair noro maeke man holi yaka leke yaka derne rakaniyedi me'e. Kade mim do'onedi hi me'e, maa kam herre minim honorok panaeku la mi akim ka naili'il Makromod Lalap.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus nala wanakunu naho'ok ida wali'ur na'aheni, “Orkirna ida lan kaman anggur kirna ida. An takin laliweweredi, na'ir lo'o rodi ramha anggur woin, la na'ariri he'u-he'u man kulu ida rodi radiyaka. Horu, ai nala kirna onne man howok kirna ida woro'o sewa, mene an laedi onno namehin. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Rakan lere ra'ili radai nina kirna raramne, an hopon nin hophopon ri wokelu laa kokala ainin hana'are. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Enimaa man howok kirna onnenihe kele wokeluhe, de nukur ida, resne ida, la rodi waku wasle ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","An hopon ri namehin, lo'o wo'akka wolima, laa rapanak nina hana'are, maa man howok kirna onne hi'i ha ma namnenehe wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kame'ede an hopon anan mememen laa napanak, ono nahinorok nahenia lo'o anan de hir horhawe. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Maa man howok kirna enihe do'onedi orkirne anan ne, hi ida ma ne'el ida na'ahenia, ‘Ai eni penia man manarna kirna enie de kesnedi leke ik manarnedi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hir kele tatana onne rodi laedi kirne paharne mene resne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus na'ukani, “Ende orkirna onne wali mai lo'o ai nala inhawa panaeku man howok kirna onnenihe?” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hir walha, “Ai lo'o nesnedi ri man ailanna onnenihe la nala kirna ri namehin howok leke rakan lere ra'ili radai ihin ennen haromo, rala nina hana'are idewe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus na'ukani hi, “Lo'o kam lese Horok Lape lirna makun ma na'ahenia, ‘Waku man ma nayapi nakar sopoledi me'eni, Makromod Lalap hi'iyedi namwali waku na'a'ar ma na'ono. Makromod Lalap hi'i onne namwali, la ik do'on ma'aruru la wa'an wake'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ende horhorok! Mi mamhene hurinohi Makromod Lalap nodi molollo mi, de An hi'i ri noho namehin ramwali Nin ri, ono hi penia derne rakani Nin konomdere.  ");
INSERT INTO kjeNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Inhoi nediyawa lolo waku eni, ihin kemen namno'o horu la maki, la inhoi waku dunie lo'o namwaliyedi elimo'o hapu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Imam lalapa roro ri Parisi enihe dernedi Yesus Nin wanakunu naho'ok onneni ne, hi rauroinedi me'e nahenia wanakunu onne na'ono hi. ");
INSERT INTO kjeNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ende hir paeku leke kele Ai, maa ramka'uk heri onne ono rauroinedi Yesus onne nabi. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus nala wanakunu naho'ok wali'ur hi na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Lere Makromod Lalap nodi molollo ri mormori naho'ok naise wanakunu eniyeni: Rai ida hi'i anan mo'oni nina yapi hohoo. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","An hopon nina man howok enihe laa polu ri man lernala popolu lalariyala enihe, maa ramhene mai. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kame'ede an hopon nin man howok namehin na'ahenia, ‘Lam kunukunohi hi ma'aheni, “Ai mesnedi arpau noro sapiyana ida woro'o ma'akene namkenedi me'ede, lariyala.” ’ ");
INSERT INTO kjeNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Maa ri man lernala kunukunohi onnenihe kar peinohi de heruwali rala'a rira kirne, la heruwali laa ra'olu rira hahaa me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Enla namehin kele rai nina man howok onnenihe nukur la resnedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rai derne panaeku ma namwali onneni, an ma'ara wake'e de hopon nina ma nasala ke'urauk enihe laa enne resnedi ri man ailanna onnenihe la harnedi rira kote. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Enla an konohi nina man howok na'ahenia, ‘Ha rahu na'akeme namkenedi me'e, maa ri man ya'u poluwedi onnenihe, kan wa'an polu wali'ur me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ende mala'a kalla lapa leke moro inhoi-inhoi pakromo lariyala mai yapi eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kame'ede hi rala'a me'e. Roro ri pakromo raka'uk, ri wawa'an noro ri ailanna, de onno man ra'akene yapi hohoo onne penuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Rai lan po'onnala ri lalariyala onnenihe, an do'on ri ida nina nainair ka nakoknohiyala wake'e ri man laa yapi hohoo. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rai na'ukani ri onne na'ahenia, ‘I wal'u, hi'ihehewi mai raram lernohi yapi eni nair nainair man namehiyale?’ Maa ri onne ka na'oho wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Enime'ede rai hopon nina man howok enihe kele ai wukuwedi liman ein la rodi laedi paharne laa noho momohon eni. Lolo onne rin lernala apinpinha wake'e la raherhere mamani. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Makromod Lalap polu lariyala ri nammori, maa An nili ri tarana mehe ramwali Nin ri.” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ka nalo'ol ne, ri Parisi enihe laa rahinopun ra'ukani Yesus leke koko Ai wakunu sala. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hir hopon rira ri ida woro'o roro Herodes nin muku heruwali laa ra'ukani na'ahenia, “Pap Meser, ai mauroin Pape akin ma namdudu de wakuku panaeku ma namlolo mamani, la ai mauroin Pape wakuku hi'ihehewi Makromod Lalap nodi molollo ri mormori lernohi honorok panaeku ma namlolo. Enla Papa mamkene mehe derne Makromod Lalap, ri mormori ka, ono Om horhawa ma na'alehe haida-haida namnenehe noro orkanaru. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ende ai ma'ukaniyala Pape haida ke'e: Lernohi iknika agame nina holoor halauk, lo'o wa'an ik pair noho nin paipaire laa hair Roma nina rai lalap, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Maa Yesus nauroinnaledi rira panaeku yake onne me'e, de na'aheni, “Eih! Ri man kokme'e mamwali ri molololo mi! Alhi'ihepeni mim ken kokwudi Ya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ken mala minim kupan modi lam pair noho nin paipaire onne I po'onale ke'e.” Hi rala kupan pere ida An po'on ne, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","na'ukani, “Inhoi oin makan la inhoi naran melle kupan eniyeni?” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hir walhe, “Kaisar.” Ende Ai na'aheni, “Inhawe man Kaisar nina, mala Kaisar, la inhawa man Makromod Lalap Nina, mala Makromod Lalap.” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hir derne Nina wanakunu eniyeni, hir mehe nanana mouwedi la rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Lere onne me'ede, ri Saduki ida woro'o aile lolo onne haenhi. Heri Saduki onne rira honorok panaeku ri man makiyedi kar mori wali'ur. Hir mai Yesus ra'aheni, “Pap Meser, nonolu eni Musa hopon nahenia lo'o mo'oni ida ho, maa makiyedi na'alehe tatana, walin ho wali'ur orno onneni leke lernala tatana nahinerre walla man maki eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Enla nano mayai eni ri wo'ikku aile ma na'umo'oniwali. Anulu ho, maa makiyedi na'alehe tatana, penia maeke ho wali'ur walin leke lernala tatana nahinerre walla man maki eni, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","maa walla onne maki wali'uredi. Panaeku eni namwali lolo ri wo'ikku onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Man horue, maeke onne makiyedi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ende lere ri man makiyedi mori wali'ur, nano mo'oni wo'ikku enihe, inhoi namwali ai hono?” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus walha hi na'ahenia, “Memen mim sala wake'e, ono ka mauroin Makromod Lalap Lirna Wawan noro Nina ke'eke'el an'anhe. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rakan lere ri man makiyedi mori wali'ur, hir mori naise Makromod Lalap Nina hophopon a'am raram, de kar ho me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Enimaa lo'o kam lesale Makromod Lalap Lirna ma na'ono ‘ri man maki mori wali'ur’ makun. Ai na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ya amwali Makromod Lalap man Abraham, Isak, noro Yakup ra'ul'uli rasa'sa'a rakan lere eniyeni.’ Ri man makiyedi ka ra'uli rasa'a Makromod Lalap, maa ri man mori penia ra'uli rasa'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Heri man derne onnenihe aki'aki ulla ono raram nodi rehi Ainina wanakuku eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lere muku Parisi derne Yesus wakunu hi'i muku Saduki enihe ka rauroin wakunu me'e, hir lawuku, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","la rir meser ida ma nauroin Makromod Lalap Nin keneri hono'ok wawa'an laa na'ukani Yesus leke kene. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ai na'aheni, “Pap Meser, lolo Makromod Lalap Nina keneri hono'ok na'akeme, ewi penia ma na'ono narehi?” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus walha hi na'ahenia, “Modi mi honorok akin, mi irhun raramne noro minim ruri pe'el na'akeme maramyaka Makromod Lalap ma namwali Makrommu. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Onne penia Makromod Lalap Nina keneri hono'ok ma na'ono la ma nolu! ");
INSERT INTO kjeNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Rewro'o nine namnenehe: Maramyaka minim ri mormori wali naise maramyaka mi kemmu. ");
INSERT INTO kjeNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ende Makromod Lalap Nina keneri hono'ok na'akeme noro nabi rira wanakuku enihe, melle keneri hono'ok woro'o eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi enihe ka rahina'ar lolo onne makun, Yesus na'ukani hi, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Menmelollo minim honorok panaeku, Mesias (Kristus) man Makromod Lalap kikan namwali Rai laa ewi-ewi onne inhoi ananne?” Hir walha, “Daud Anan.” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ai na'ukani wali'ur na'ahenia, “Alhi'ihepe Daud napolu Ai onne, ‘Makrom'u,’ lere Roh Kudus nodi molollo aie? Lere onne Daud na'ahenia lolo Horok Lape, ");
INSERT INTO kjeNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Makromod Lalap ne'el i Makrom'u na'ahenia: Maikoro I her'u malanne hehen nanumene Ya'u hi'i Num arwali enihe lolo yawa ki O.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ende lo'o Daud napolu Ai ‘Makrom'u’, hi'ihehewi namwali anan mememen?” ");
INSERT INTO kjeNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ri mahaku ka nauroin walha, la nano lere onne me'ede ri namka'uk na'ukani haida-haida Ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesus ne'el heri onnenihe noro Nina man lernohi pakunohi enihe ");
INSERT INTO kjeNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","na'aheni, “Meser-meser Horok Lap noro ri Parisi rodi molollo ra'amou ra'aropo agame nina keneri hono'ok. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Inhawe man hir wakuku la hopon hi'ie, lernohi na'akeme, maa yono lernohi rira hini'i wenewhe, ono hir wakuku ri, maa rira hini'i wenewhe kan lernohi rira wanakuku eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hi rodi yodiwara man werek duni ta'al ri leke lernohi kenekrohu hi raraleni, maa hi me'ene, kar paku ri lernohi rira kenekrohu onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hir hi'i ha wo'ira na'akeme leke rin po'on ra'uli rasa'ahe. Po'onala, hir loile Makromod Lalap Lirna dosi man lapa tarana raram lawuku lerene noro liman apun mariri, la hi'i ho'ir man harna naru rodi hi'i lir napanak leke rin po'on ra'uli rasa'a. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hir laa Yahudi rira kerei raram suk raikoro kalari. Hir laa yapi suk raikoro mei uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lo'o hir pakromo ri lolo kalla, lolo pasar, hir suk lernala honoor hanawa la suk ri napoluhe ‘pap mesere’. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Maa yono raram nodi ri napolu mi ‘papa meser’, ono mi eniyenihe ma na'umo'oniwali la minim Meser ida mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lolo noho eni wawan yono mapolu ri, ‘ame’, ono Makromod Lalap man aile a'am raram mehe namwali mi Ammu, ");
INSERT INTO kjeNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","la yono raram nodi ri napolu mi ‘man panulu’, ono minima Man Panulu ida mehe, onneni Mesias man Makromod Lalap kikanedi namwali Rai laa ewi-ewi eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nano mi eniyenihe inhoi namwali man panulu, ai onne ilitolle ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Enpenia inhoi holi kukulu lalapa lo'o ra'idaruwedi, la inhoi helkaki-namdaru lo'o ra'akulu ra'alapedie.” ");
INSERT INTO kjeNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Enla Yesus konohi meser Horok Lap roro ri Parisi enihe na'ahenia, “Mi man kokme'e mamwali ri molololo mi! Mim mayo'o! Mi me'ene mamhene hurinohi Makromod Lalap nodi molollo mi, la mim kawala ri man raram nodi namwali Nin ri haenhi!  ");
INSERT INTO kjeNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mi man kokpoho mie! Mim mayo'o wake'e, ono mahoro maeke walwalum rira hahaa noro rira nakar, maa kokme'e mamwali ri man wa'an de hi'i lir napanak ma nalo'ol leke ri na'uli nasa'a mi. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mi man kokme'e mie! Mim mayo'o, ono mim lalaa mamaiyala lolo lour lolo ro, manoin ri ida mim paekunala wakuku leke akin namrana lernohiyedi minim holoor halauk na'akeme. Mim hi'i ai ailanna narehi mi penia namlolo kokkoo an laa kawali pire ai porom raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mi mamwali man panulu man makan tokedi, de mim mayo'o, ono mim wakuku ha ma ka namlolo ma'aheni, ‘Inhoi kikan hopo wekel Makromod Lalap Nina Romleu Lapa, ai onne nina hopo ka naruri, ma inhoi kikan hopo wekel mahe man aile Makromod Lalap Nin Romleu, ai onne ka nahinuri nano nina hopeni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mi ka mauroin haida! Makromod Lalap Nin Romleu Lapa namwali ha ma na'ono narehi maha man aile Romleu raram onne. Romleu onne penia ma na'amou na'adewe maha onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mim wakuku haenhi ma'aheni, ‘Inhoi kikan hopo wekel honoi kanani onno lolo Makromod Lalap Nina Romleu, nin hopo ka naruri, maa lo'o an wekel nina honoi kanani man aile lolo honoi kanani onno onne wawan, Makromod Lalap kan huri ai hamlinu nin hopeni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Heih, maktoko mie! Ma'alehe honorok aki! Honoi kanani onno onne na'ono narehi ha ma namwali honoi kanani onne. Honoi kanani onno onne penia ma na'amou na'adewe ri nin honoi kanani onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ende inhoi kikan hopo wekel honoi kanani onno, ai onne kikan hopo noro idewe hahaa na'akeme man aile lolo honoi kanani onno onne wawan, ");
INSERT INTO kjeNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","la inhoi kikan hopo wekel Makromod Lalap Nin Romleu Lape ai onne kikan hopo noro idewe Ri man holi Romleu onneni, ");
INSERT INTO kjeNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","la inhoi kikan hopo wekel a'am raram, ai onne kikan hopo Makromod Lalap Nina naikoronno noro idewe Ma naikoro lolo onne! ");
INSERT INTO kjeNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Heih, meser-meser Horok Lap noro ri Parisi mie! Mim mayo'o. Mim kokme'e mamwali ri molololo mamani ono mi mala Makromod Lalap Nin hana'are, persen idaweli nano minima rampa-rampa ma naise: ta'arutuk, lahono, limarra, lakwahi. Maa ha ma na'ono lolo Makromod Lalap Nina keneri hono'ok mim hamlinuwedi naise: ho'ok kail ri modi honorok akin man mou, ida man kukul aki man wa'an ida, la mamkene lernohi Makromod Lalap mamani. Ha ma na'ono onnenihe mi akim ka na'ini'ik wake'e. Wa'an rehi mim ilitolle ha ma na'ono onne noro idewe hi'i namehin onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Heih, ma na'alehe honorok aki mie! Mi maisa ri man ka'i paripari romok man kaile minim nonomun onno mene momune, maa ha mormori unte mim kelledi, kam eremnala haida. Ha ma ka na'ono mim loi honorok, maa ha ma na'ono ka. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Heih, meser Horok Lap noro ri Parisi mie! Mim mayo'o ono kokme'e mamwali ri molololo mamani. Mi mahoro ri namehin rira hahaa la horok mi kemen mehe, maa mim hi'i ha wo'ira leke rin do'on rauroin mi mamwali ri ma akin mou. Mi maisa nonomun onno noro ra'u man ri nawana paharne mehe, maa raram mormorso noro ha ma namehiyala wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Heih, maktok mi, ma'alehe honorok aki! Ma'amou nonomun onno noro ra'u raram nolu, leke paharne mou haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mi Parisi moro meser Horok Lap man kokme'e mamwali ri molololo enihe! Mim mayo'o wake'e, ono mi eniyenihe maisa lunna man mesel la ra'awarhedi. Rin po'on pene'ek onne ma'aruru, maa lolo raram maki ruri la ha ma na'itehedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mi maise onneni, ono mim posi paharne rin po'on minim morimori ma'aruru la ra'aheni, ‘Ri onne hi'i ha ma namlolo lolo Makromod Lalap kalarna,’ maa hi kar do'on lolo mi honorok akin panaeku yaka mamani. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mim lernala hunukum man werek ono kokme'e mamwali ri molololo. Mim mesel nabi-nabi roro ri ma akin mou rira lunne, hi'i kulu la ma'akeki ma'aruru. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Enla mi ma'ahenia, ‘Lo'o am mori wewerre noro ai upun a'um nonolu eni, ai kam lernohi hi mesne nabi onnenihe!’ ");
INSERT INTO kjeNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Enpenia nano minima wanakunu onneni mehe kuku maka nahenia mi mamwali ma nesne nabi onnenihe upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ende lam hi'i na'ahoruwedi panaeku man yak mi upun a'umhe nonolu hi'iyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Heih, ri man ailanna ihin rarna mi. Mi maise haimoke! Yom pene'ek mahala mi nano kawali pire ai porom raram! ");
INSERT INTO kjeNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lere man mai Ya'u lo'o hopon nabi-nabi, ri ma nauroin, noro meser-meser mai ki mi, maa mi lo'o mesne heruwali, namehin wairesne lolo au kekiyowok, heruwali hi'i apinpinha kemen, la heruwali mohi ramhara laa kote namehin. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Onne penia Makromod Lalap nala hunukum mi. Onne kan mehe, maa ri man hi'i ha ma namlolo na'akeme man mi upum a'umhe resnedi nonolu nano Habel rakan man kauli'ur Barekya ananne Zakaria, hi na'akeme ramwali minim yodiwara haenhi. (Zakaria onne hi resne lolo Makromod Lalap Nin Romleu Lape noro honoi kanani onno leken.) ");
INSERT INTO kjeNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Horhorok Ainu'u nou ma na'ono eniyeni: Memen ma'uwara yodiwara ha man yaka onne na'akeme, la Makromod Lalap lo'o hukum mi ku eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesus na'aheni wali'ur, “Yerusalem mie, mi mesne nabi enihe la wadesne hophopon wahwahan man Ya'u hopon mai ki mi eni. Ler romromo Ya'u raram nodi apolu mi mai leke leluwai makrana naise manu orana man rawa ananne, maa mamhene mai. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Enpenia minima Romleu Lape lo'o hoikaruwedi den mamu. ");
INSERT INTO kjeNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Enla Ya'u konohi mi, nano lere eniyeni me'ede kam do'on Ya'u hehen nanumene rakan lere mi ma'aheni, ‘Makromod Lalap namre'e namharu Ai man mai nodi Naran man kulu narehi!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus wakunu onne na'akeme horu, hi ramhara nano Romleu Lap onne kan ko'u makun, man lernohi pakunohi enihe laa ra'urani Ai la kukulle Romleu Lapa noro nin romo ma aile na'uranrani onnenihe ra'ahenia, “Po'onala, Pape, onne ma'aruru wake'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Maa Yesus ne'el hi na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Lere eniyeni mim po'on ha onnenihe na'akeme ma'aruru, maa lere man mamai eni arwali mai de raiye'er mouwedi Romleu Lap onne de nina waku danaran na'akeme ida ka nadinara ida me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Horu ne, Yesus noro Nina man lernohi pakunohi enihe rala'a wo'or Zaitun raikoro wukuwedi la ra'ukani Yesus na'ahenia, “Ken Pape konohiyala mayai ke'e, ha eniyenihe lo'o ma'anana namwali? Am lernala inhawa tanada man kukul mayai lere Pap mai wali'ur, la noho nin lere alam man horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus walha na'ahenia, “Nakinemen ki mi, kalo'o rin paipudi mi, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ono ri nammori lo'o rodi I naran mai ra'ahenia, ‘Ya'u eni, Kristus man Makromod Lalap kikan namwali Rai!’ de paipudi ri nammori. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi lo'o derne ara mamani noro lir anna are lolo ewi-ewi, maa yon mamkauk. Ha eniyenihe na'akeme namwali, maa yono pene'ek rakanedi noho nin lere alam man horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Noho pa'i'ik rai pakakar lo'o ida ma na'ara noro ida, hair noro hair, la noho wawan na'akeme lernala roulara noro rururuwai lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wewerek pananaka onnenihe ha ma namwali nolu, maa lere alam man horu onne na'urani ne, eren apipinha. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lere onne rin kele mi leke hi'i apinpinha, resne, la ri noho wawan na'akeme kar suk mi, ono mim lernohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ri ma akin naili'iledi Ya'u me'e, hoi kili'urn kani ko'oredi Ya'u, la ida ma ka naramyak ida, ida ma na'okul ida laa arwalie. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ri nammori kokme'e mai rodi Ya'u naran paipudi ri nammori. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lere onne, ida ma kan holi wawa'an noro ida me'e, ono lolo ewi-ewi ri ailanna aile. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Maa inhoi namkene lernohi Ya'u rakan nina lere horu, ai onne lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lolo noho wawan na'akeme, rin loikaru Makromod Lalap Lirna Wawa'an ma na'ono hi'ihehewi Ai nodi molollo ri mormori eni. Lirna onne ri mormori lolo noho wawan na'akeme derne mouwedi nanumene lere alam nina man horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Lere onne mim do'on ‘Ha Man Ailanna ma na'ihoru na'idaru Makromod Lalap mamani’ namriri lolo Moumou Dewdewe Onno. Nonolu nabi Daniel konohiyedi ha onne namwali. (Ri man lese horok eniyeni loi honorok wawa'an panaeku eniyeni.) ");
INSERT INTO kjeNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Lere onneni ri ma aile Yudea lari mouwedi laa wo'or! ");
INSERT INTO kjeNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri ma aile nakar wuwane kopur pelekleke, maa yon laa romleher nala haida, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","la ri man aile kirna yono wali laa nakar rala rira nainaire. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lere onne maeke ma nornoro raramne, man anan huhuhu makun, apinpinha nore! ");
INSERT INTO kjeNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ende hi'i lir napanak leke panaeku onne yono namwali lere noho ma'urinrinna me Alam Renren Warwarne. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lere onne, ri mormori lernala wewerek pananaka wake'e. Nano noho namwali me'ede rakan lere eniyeni ri kan do'onala wewerek pananaka ma naise onneni makun, la ka namwali wali'ur naise onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lo'o Makromod Lalap ka na'adeul lere alam onneni, ri na'akeme lo'o maki mouwedi. Ai na'adeul lere alam onne ono Ai nararamyaka Nina ri ninili enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lere onne lo'o ri ne'el mi na'ahenia, ‘Po'onala! Kristus man Makromod Lalap kikan namwali Rai aile mai eni, ee aile lolo onne,’ yono derne makanie. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lere onne ri ma nodi konoko wunudi heruwali ra'aheni hi ramwali Kristus, la heruwali ramwali nabi-nabi ma ka namlolo. Hi lo'o mai hi'i tanada lewlewen noro ha ri kan dodo'onnala makun haenhi leke kene paipudi ri nammori. Hir kene paipudi ri man Makromod Lalap niliyedi me'e haenhi, maa lo'o ka namwali. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ende loi honorok memen! Ya'u konohiyedi mi ha eniyenihe na'akeme nolu mene namwali. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ende lo'o ri konohi mi na'ahenia, ‘Kristus aile noho mamun,’ yono mim laa enne, la lo'o ra'aheni, ‘Aile mai lolo kamar raram,’ yono derne makanie. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Lere Ya'u ma namwali Ri Mormori Anan mai wali'ur rin do'on naise noho lerlere nano kimur hikkan rakan idewe warak. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lo'o mim do'on tanada onne na'akeme mi mauroin nahenia lere Ya'u wali mai wali'ur na'uranraniyedi me'e, naise mim do'on manu arpau nammori luplupur onnida, mi mauroin lolo onne ya'anne aile.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Rakan lere alam wewerek pananake man werek onne horu, lere kan hari, wollo kan ropo, kaliyore nadiya'ur nahoho'ok nano a'am, la hahaa na'akeme man aile a'am narururu. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lere onne mene do'on tanadida lolo a'am man kukul nahenia Ri Mormori Ananne mai me'e, de ri mormori noho wawan na'akeme sus mak oir mamani. Enla hir do'on An mai lolo hulik poloi kakam palari nodi Nina ke'eke'el an'anha noro siksika lerlere man ma'aruru wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lere onne, derne kowuri man lirna lap wake'e, la An hopon Nina hophopon a'am raram lar polu ri mormori na'akeme man Makromod Lalap niliyedi lolo noho huhun wo'akkenihe, nano a'am ki'ile rakan a'am ulla maiwuku.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesus wakunu wali'ur na'ahenia, “Mala wanakuku nano ara ono. Rakan lere hinan hanan napupul naweti la moko, mi mauroin nahenia ka nalo'ol me'e ara ono onne lo'o woi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Namnenehe noro ara ono onne, lere mim do'on hahaa onne na'akeme namwali, mi mauroinedi nahenia Ainu'u lere alam mai wali'ur wakuraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Horhorok Ainu'u nou ma na'ono eniyeni: Ha eniyeni na'akeme namwali mouwedi nolu mene kulere eniyeni maki horu. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A'am noro noho lo'o moluloin, maa I Lir'u eni kan molu laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ri mahaku ka nauroin ma'anana lere alam onneni namwali. Maya'u, hophopon a'am raram, la ri mormori na'akeme ka rauroin. Ya Am'u, Makromod Lalap mehe nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lere Ya'u ma namwali Ri Mormori Anan mai wali'ur, ri mormori rir hini'i wenewhe ailanna naise ik upud a'ad Nuh nin kulere nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lere oir rulu lape kan mai makun, ri mormori onne lawuku hi'i ya'an yomun noro yapi hohoo mamani rakan lere Nuh laedi kapal raram, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","la hi kar eremnala haida hehen nanumene okon noro oir rulu lape nakliu pupin mouwedihe de ka naurehiyala haida. Onneni namwali lere Ri Mormori Anan mai noho wawan haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lere onne ri woro'o mahar howok aile kirna, ida nakinikan laa wawan la ida hoikaruwedi, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","la maeke woro'o mahar wain kele'uk, ri ida hoikaruwedi la ida nakinikanedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mi ka mauroin lere alam Ya'u ma namwali mi Makrommu mai wali'ur noho wawan, de mamkene madiyaka wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lo'o ornakar ida nauroinedi ma'anana ri ma namna'a mai nakar, ai nadiyaka wawa'an leke yono mai raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ende ma'akenkene mi mamani, ono lere alam Ri Mormori Anan mai, ka mauroin.” ");
INSERT INTO kjeNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesus na'aheni wali'ur, “Lo'o man howok ida nampe'el la nauroin, ai onne penia makromon kikan namwali uluwakun nin man howok na'akeme, leke kakar hanana'an man howok onnenihe ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Enla lere makromon mai wali'ur do'on nin man howok onne mahan howok, man howok onne akin nahuwa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Makromon onne kikan nin ri onne nadiyaka nina linikir kanaru na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Maa lo'o man howok onne hi'i ailanna, la nahinorok lolo akin na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Makromon nalo'ol mene mai,’ de an nukur man howok wali la na'an nomun noro ri ma nomun arak manha mamani, ");
INSERT INTO kjeNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","namlilinnohi makromon wali mai lere alam man howok onne ka nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","An daresne man howok onne la sopoledi laa onno ri man kokme'e ramwali ri molololo enihe miminle. Lolo onne rin lernala apinpinha la sus mak oir kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus wakunu wali'ur na'ahenia, “Lere onne, Makromod Lalap Nin molollo naise wanakunu naho'ok eniyeni: Maekrara idaweli ra'akene obor rodi laa kokala man ho mo'oni ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nano maekrara idaweli onnenihe, wolima rauroin la wolima raploedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Maeke ma naploo onne, rodi obor, maa ka ra'akene mintana aimehi loile potol, ");
INSERT INTO kjeNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","la maeke wolima ma nauroin onnenihe ra'akene mintana aimehi rodi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Enla newek man ho nalo'oledi mene mai, de makanhe nasoi me'ede, ramkuru mahaledi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ende rakan alam torowali mene derne ri ida wakau na'ahenia, ‘Man ho meneni me'e de mam kokala here.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Idewe ramaka po'on rir obor morna ma'uledi me'e, de ra'akene rir obor leke moriyala wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Enine maeke wolima ma ka nodi mintana enihe rapanak ma nodi onne ralala tarana loiyale rira obor here ono rira mintana horuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Maeke man rira mintana aile onne ra'aheni, ‘Kan yadi, kalo'o kan nokor mayai. Wa'an rehi mala'a tokue weliyalida.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kame'ede hir laa me'e. Hi rala'a, kan maha ne, man ho rakanedi, de maekrara man rira obor mormori onnenihe kokale la rore ra'alono laa nakar man korowuku ra'ukwuku onne raram nanumene elekedi nike, laa ra'an romun wewerre! ");
INSERT INTO kjeNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maeke man weli mintana onnenihe wali laa, rapolu na'ahenia, ‘Makrom'u, hariyedi nike mayai ke'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Man ho onne walha na'ahenia, ‘Ya'u konohi mi namlolo kokoo: Ka auroin mi!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ende Yesus na'aheni, “Onne penia Ya'u nounaku mi, madiyakyaka mamani ono ka mauroin ors, jam, me lere alam Ya'u mai wali'ur!” ");
INSERT INTO kjeNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Enla lere Makromod Lalap nodi molollo ri mormoriyaneni, naho'ok naise wanakunu eniyeni: Ri ida na'akene nala'a noho man koko'u de hopon nina man howok radiyaka nina linikir kanaru. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ende ai nala kupan man howok wokelu nodnohi rira woroin. Enpenia nala ri ida kupan mahe riwan wolima, ri ida kupan mahe riwan woro'o, la ri ida kupan mahe riwan ida. Horu ne, ai nala'a. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kame'ede man lernala kupan mahe riwan wolima onne namhara laa nahehe nina ma na'ikar la ma na'uwali. Ainina nahehe onne lernala na'uwalin riwan wolima wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Man lernala mahe riwan woro'o eni nala'a, an lernala na'ikar na'uwali riwan woro'o haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Maa man lernala kupan mahe riwan ida onne, laa na'ir lo'o suwaredi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Enla makromon onne nalo'oledi mene wali laa nakar. Lere an rakan nakar, napanak hi rala rira honowok man rahehehe noro na'ikar na'uwalla. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ri man lernala kupan mahe riwan wolima onne nodi nina mai na'aheni, ‘Makrom'u po'on! Kupan man mala maya'u, na'ikar na'uwali riwan wolima de na'akeme riwan idaweli.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Makromon na'aheni, ‘Onuma nahehe onne ma'aruru. O mamwali man howok man wa'an! O mamkene paku ya'u. Nonolu ya ala honowok tarana, o madiyaka wawa'an, de ya ala yodiwara nammori ki o. Lariyala mai raram min noro maya'u, la akim nahuwa'anedi here.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Onne horu, man lernala kupan mahe riwan woro'o mai na'aheni, ‘Makrom'u, po'on! Kupan mahe riwan woro'o man mala maya'u, na'ikar na'uwali riwan woro'o de na'akeme kupan riwan wo'akka.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Enpenia makromon na'aheni, ‘Onuma nahehe onne ma'aruru la o mamwali man howok man wa'an! O mamkene paku ya'u. Nonolu ya ala honowok tarana ki o, la madiyaka wawa'an, de ya ala yodiwara nammori ki o. Lariyala mai raram min noro maya'u, la akim nahuwa'anedi here.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Enla man lernala kupan mahe riwan ida onne mai ne'el na'ahenia, ‘Makrom'u, ya auroin nahenia makrom'u ri man owok, ono makrom'u naise ri ma na'ili nadai ha ma kan pepekir ariyoyone. Ri namehin howok mene papa lernala ihin ennen. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Onne penia ya amka'uk, de laa a'ir lo'o suwaredie. Ende kokala wali'ur makrom'u nina kupan eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Makromon walha na'ahenia, ‘O maprehenne! O ma'aheni ya a'ili adai hanana'an lolo onno man ka'u pekir ariyone la loiwuku hanana'an man ri namehin pekir ariyone. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Alhi'ihepe ka manoin ri mala kupan herre leke ya'u wali mai wali'ur ne, kokala noro dipin woin?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Makromon onne hopon man howok namehin na'ahenia, ‘Mala nin kupan onne kanile ri ma nina kupan mahe riwan idaweli onne, ");
INSERT INTO kjeNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ono inhoi nina aiyedi me'e, lo'o lernala nammori la narehi nalewen, maa inhoi nina taran mehe aile, raledi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Enla sopoledi ri ma naprehen onne laa noho momohon leke min enne lernala apinpinha noro sus mak oir mamani.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lere Ri Mormori Anan mai noro wewerre Nina hophopon a'am raram na'akeme, Ai nodi ke'eke'el an'anha ma narehi nalewen. Lere onne Ai naikoro Nina naikoro onno man moumou dewdewe namwali Rai noho wawan na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Enla ri lolo noho wawan na'akeme lawuku herne kalarna leke Ai naheir hi namwali muku woro'o, naise man huri pipi naheir pipdume nano ketawe, ");
INSERT INTO kjeNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","leke pipdum enihe minedi herne malanna la pipi ketawa enihe laedi herne mariri. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Enla Rai ne'el hi man minle herne wali malanna enihe na'ahenia, ‘Mi man Makromod Lalap namrere'e namhaharu, mai here leke manarna noho worworu man Ya Am'u na'akenedi nala mi nano noho eniyeni nina ma namwali me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mi manarna noho worworu eni, ono lere Ya amlara mi mala ha Yo o'on, lere Ya'u marou mala oir Yo omun, la lere Ya amwali do'on awan mim kokalA'u lolo minim nakar. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Lere Ya alehe nainair mala nainair Ya'u, Ya akni'ir mim ilitolle Maya'u, la Ya'u aile bui raram mim ka'aka'ar Ya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Enine ri ma namlolo onnenihe walha ra'aheni, ‘Makrom'u, ma'ananahe am do'on Makrom'u namlara la ai mala hanana'an mo'on, la marou ai mala oir momun? ");
INSERT INTO kjeNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Enla ma'ananahe am do'on Makrom'u namwali do'on awan am lariyala mai ainima nakar? Makrom'u na'alehe nainair, la ai mala nainair? ");
INSERT INTO kjeNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","La ma'ananahe am do'on Makrom'u nakni'ir am ilitolle, la aile bui raram am ka'are?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Rai onne walha hi na'ahenia, ‘Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Mim hi'i wewhedi haida man wa'an I wal'u ida man lolo yawa walin namehin me'e de, minim hini'i wenewhe onne naisa mim hi'i wewhedi Maya'u haenhi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Enla Ai ne'el hi man minle herne mariri na'ahenia, ‘Mim lernala hunukum man werek! Mamharedi lolo eni, laedi aiye man mori laa ewi-ewi eni. Aiye man mormori onne ra'akenedi Hayakyak Makromon noro nina hophopon wali minle raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Lam minle aiye raram ono lere Ya amlara ka mala hanana'an Yo o'on, la marou ka mala oir Yo omun, ");
INSERT INTO kjeNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","lere Ya amwali do'on awan ki minim nakar kam kokalA'u, la lere Ya alehe nainair ka mala nainair Maya'u. Ya akni'ir kam ilitolle Maya'u, la Ya'u aile bui raram kam ka'ar Ya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Enime'ede hir walha ra'aheni, ‘Ma'ananahe am do'on Makrom'u namlara, marou, mamwali do'on awan, ma'alehe nainair, makni'ir, la minle bui raram la kam ilitolle?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","An walha hi, ‘Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lere mamhene paku ilitolle i wal'u ida man lolo yawa walin namehin, onne naisa kam paku Ya'u haenhi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Enpenia Makromod Lalap hukum hi de lernala apinpinha laa ewi-ewi, maa ri ma namlolo lolo Ai kalarna, hir kokala or'ori dardari ma kan horu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nala wanakuku onne horu, Ai ne'el Nin man lernohi pakunohi enihe na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Lo'o mauroinedi me'e, inworo'o ik lernohi Paska, iknik lere alam lalap onneni. Enla lere onne kele Ya'u ma namwali Ri Mormori Anan, ralle leke wairesne lolo au kekiyowok.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Enime'ede imam lalap roro Yahudi rira leleher lalap enihe lawuku hopun lolo Kayapas nina nakar. (Ai onne namwali imam man kulu narehi). ");
INSERT INTO kjeNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hir hopun leke ranoin kalla suwsuwar ida kele Yesus hukumesne. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Enimaa ida ma ne'el ida, “Yono ik hi'i panaeku eniyeni iknik lere alam lalap, kalo'o nakoko man suk derne Yesus Nin wanakuku hi'i wowo'o ar'arra.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lere Yesus aile Betania, An minle Simon nina nakar. Simon onne, ri napolu ‘Simon man ulik yak hi'ie,’ ono nonolu eni an lernala apinha onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesus nana'ak ne, maeke ida mai nodi wuru wola'ula'u potol ida man wella ai wawan wake'e nala halle Yesus uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Man lernohi pakunohi enihe po'on maeke onne nina hini'i eni hi ra'ahan la ida ma ne'el ida ra'aheni, “Alhi'ihepenia nano'onyaka wuru man wella ai wawan onne? ");
INSERT INTO kjeNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa'an rehi rodi laa ra'olu, leke nina kupan nalle ma na'alehe haida-haida!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus nauroin rira panaeku de na'aheni, “An hi'i ha man wa'an Maya'u menee, alhi'ihepenia mim hi'i yakyaka maeke enie? ");
INSERT INTO kjeNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma na'alehe haida-haida aile mi leken kalarna mamani, maa ka nalo'ol Ya'u eni ka oro mi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ai nala wuru halle Ya'u kemen eniyeni nodi na'akenala I kem'u leke laa lunne raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Horhorok Ainu'u nou ma na'ono eniyeni: Lolo ewi-ewi Makromod Lalap Lirna raderre radaulle, maeke eni nina hini'i wenewhe onne loikaru haenhi, de ri kan hamlinu ai.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kame'ede ri ida nano man lernohi pakunohi idaweli woro'o onnenihe naran Yudas Iskariot nala'a laa imam lalap enihe ");
INSERT INTO kjeNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na'aheni, “Lo'o mala inhawa maya'u leke ya ala Yesus kani paphe?” Enime'ede imam lalap onnenihe aki kupan pere welikelu rala ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nano lere onne me'ede ai nanoin leken paharin leke kani Yesus laa hi liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Rakan Lere Alam Lalap ‘Ra'an Roti Ma Na'alehe Ragi’ nin lere dedesne, man lernohi pakunohi enihe ra'ukani, “Papa raram nodi am laa ewi ma'akene Paska nina ya'an yomun leke Pap na'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus walha, “Mala'a laa ri ida man min lolo kote raram ma'aheni, ‘Ainima Pap Meser nahenia Nin lere alam rakanedi me'e, de Ai raram nodi hi'i Paska nin ya'an yomun noro Nin man lernohi pakunohi enihe lolo num nakar.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ende hir hi'i na'akeme man Ai na'aheheni eni, de laa ra'akene hanana'an nonomun me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lere helem ne, Yesus noro Nina ri mememen enihe raikoro wuku ra'an romun. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mahanoro ra'an romunu makun, Ai ne'el hi na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Nano mi eniyenihe ri ida aile ma na'olu Ya'u, kanile ri leke resnA'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hir derne Nina wanakunu onneni, hi raram penu rehi, la dohdoho ra'ukani Ai, “Pape! Lo'o maya'u, ka!?” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus walha, “Man kani Ya'u laa arwali onne ri ma noro Ya'u remen roti manuk raram wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ri Mormori Anan lo'o maki naise horhorok man aile Horok Lapeni, maa ri man kani Ai laa arwali onne mayo'edi me'e. Wa'an rehi ri onne inna aman kar morie.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Enine Yudas ma nahinorok kani Yesus laa arwali onne na'ukani, “Pap Meser, maya'u, ka?” Yesus walha, “Naisa o lirum eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mahanoro ra'an romun ne, Yesus nala roti napanak trimkasi Makromod Lalap nanumene a'un, ha'arle Nina ri mememen enihe na'aheni, “Kokale la mo'one, roti eniyeni Yi ihin kem'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Onne horu, Ai nala anggur cawan ida napanak trimkasi nanumene nale hi romun la na'aheni, “Mi na'akeme momune, ");
INSERT INTO kjeNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ono anggur eniyeni Ya'u rarna man wui man kolo eni na'ono nawinau Makromod Lalap Nin nou man du'ul kali ri nammori roro Ai, la na'ohu nahala hi nano rira dohohale. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya'u konohi mi, nano lere eni me'ede, ka omun anggur eni hehen nanumene rakan lere Yo oro mi komun anggur worworu lolo Ya Am'u Nina noho worworu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kame'ede hi rahinara hanara ida ra'uli rasa'a Makromod Lalap. Horu ne, hi rala'a laa wo'or Zaitun. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Enla Yesus ne'el Nina man lernohi pakunohi enihe na'ahenia, “A'alam eni me'ede mi na'akeme lo'o hoikaruwedi Maya'u me'e, ono horhorok aile Horok Lape ma na'aheni, ‘Ye esne man huri onne, la Nina pipdum ukun lariye'er rarari.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Maa lere Makromod Lalap na'amori Ya'u wali'ur nano maki-maki eni Yo olu mi laa Galilea.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus na'aheni, “Lo'o hi na'akeme hoikaruwedi Pape, maa maya'u ka!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus na'aheni, “Horhorok Ainu'u nou ma na'ono eniyeni: A'alam eni me'ede manu kan kokoroi makun, o ma'aheniyedi ka mauroin Ya'u rewkelu me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Enimaa Petrus walha na'ahenia, “Kade yo oro Papa maki wewerre, maa ya'u ka a'aheni ka auroin Papa!” La man lernohi pakunohi namehin enihe ra'aheni heheni haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Onne horu, Yesus noro Nina man lernohi pakunohi enihe rakanedi wo'or Zaitun laa onnida naran Getsemani. Ai ne'el hi na'ahenia, “Maikoredi lolo eni la Ya'u laa enne hi'i lir napanak.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ai naka'uk Petrus noro Zebedeus anan woro'o enihe ra'alono laa, la Ai akin woir la rase sus rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Enime'ede An konohi wokeluhe na'ahenia, “Ya akin woir rehi naise I maki me'e, de moro Maya'u madiyakyaka mai eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ende An laa kalari tarana, nala kemen wali yawa nahinononow hi'i lir napanak na'ahenia, “Papee! Ya apanak lo'o Papa ne'e, huriyedi Ya'u nano wewerek pananaka eniyeni. Enimaa yono hi'i lernohi Ainu'u honorok panaeku eni, maa lernohi Papa Nina honorok panaeku mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","An hi'i lir napanak horu, wali laa Nin ri wokelu enihe, hi ramkukuru. Ende Ai ne'el Petrus, “Alhi'ihepe kam kerhu madiyaka jam ida moro Maya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Madiyakyaka mi la hi'i lir napanak leke yono mi madiyaur kenene panatal de hi'i sala. Mi honorok akim namrana lernohi Ya'u, maa mi ihin kemen ka naruri.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesus lan hi'i lir napanak rewro'o nina na'ahenia, “Ya Am'u, lo'o kalla namehin kaale, Ye e'e odi a'uwara wewerek pananaka eni. Ya apanak Ya Am'u Nina honorok panaeku namwali!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Horu An wali wali'ur tolle wokeluhe ramkukuru wali'ur ono makanhe nasoi rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","An hoikaruwedi hi lan hi'i lir napanak wali'ur. Nina napanak rewkelu onne lirna namnenehe haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Horu ne, An wali laa hi. Ai ne'el hi na'ahenia, “Mamkukuru makun? Rakanedi Ainu'u lere alam rala Ya'u ma namwali Ri Mormori Anan, kanile man hi'i dohohala liman raram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mamakedi! Mai kala'a here! Ri ma nodi honorok yaka Maya'u eni mai me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus wakunkunu makun, ri ida nano Nin ri idaweli woro'o, ma naran Yudas noro ri nammori mai rodi ilak raa noro au deul. Imam lalap roro Yahudi rira leleher lalapa enihe hopon hir laa kele Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesus walin ma na'olu Ai onne, an kukunohiyedi heri onnenihe me'e na'ahenia, “Ya'u nair tanada eni, de ri man ya'u masi onne, mim kele here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Enime'ede Yudas laa Yesus napolu, “Pap Meser,” nanumene masiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus na'aheni, “I wal'u, paeku inhawa penia maie?” Idewe heri onnenihe lar kele Yesus wukuwedie, ");
INSERT INTO kjeNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","maa man lernohi Yesus ida lehu nin raa dara imam man kulu narehi nina hophopon ida kilinna me'ede kaprosuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus ne'el man lernohi onneni, “Kowosedi num raa wali'ur ono ‘inhoi nodi raa na'aromo, resne ai rodi raa haenhi.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Om pene'ek Ya a'alehe molollo apanak Ya Am'u hopon Nina hophopon a'am raram riwriwan halhalle mai paku Ya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Maa panaeku eniyeni na'akeme namwali leke na'akuku na'anokor inhawe man nabi-nabi horokedi lolo Horok Lape raram me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Enla Yesus ne'el heri onnenihe na'ahenia, “Enlo'o Ya'u eni ri man ailanna penia modi kere, raa, au deul mam kele Ya'ue? Akilere Ya'u aikoro lolo Makromod Lalap Nina Romleu Lapa raram wakuku, maa mi kam kelA'u, ");
INSERT INTO kjeNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","maa eni na'akeme namwali leke na'akuku na'anokor inhawa man nabi-nabi horokedi lolo Horok Lape raram me'e.” Lere onne man lernohi pakunohi enihe ramka'uk kelehe, de lari mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hir kele Yesus horu, hi rorkaru laa nakpali Kayapas ma namwali imam man kulu narehi. Lolo onne meser Horok Lap roro Yahudi rira leleher lalapa lawukuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus lernohi Yesus lolo kili'ur nano ko'u rakan imam man kulu narehi onne nina nikoin. An laa naikoredi ma nadiyaka nakar enihe leken, leke derne man ho'ok kail enihe rala inhawa kenekrohu man horue. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imam lalapa roro agame nina man ho'ok kail na'akeme ranoin man kuku maka wakunu ha man sala leke tumdesne Yesus la hukumesne. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ende ri nammori wakunu poho, maa kar lernala wanakunu ma na'ono ida hehen nanumene ri woro'o laa kalari ");
INSERT INTO kjeNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ra'aheni, “Ri eni na'aheni Nin molollo aile naiye'eredi Makromod Lalap Nina Romleu Lapeni la alam wokelu na'ariri wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Idewe imam man kulu narehi onne namriri na'ukani, “Man kuku maka eniyenihe wakunu tumdesne O. Alhi'ihepenia O kam walhe rira wanakunu ma nano'onyak O?” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Enimaa Yesus ka na'oho, de ai na'aheni wali'ur, “Ya'u hopon Om walha mouropo. Lo'o ka, ya apanak Makromod Lalap man mormori hukum O. Ende kukunohi mayai lo'o mamwali Kristus, Makromod Lalap Anan, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus walha, “Molmolo o lirum eni, maa Ya'u konohi mi, nano lere eni me'ede mi lo'o do'on Ya'u, ma namwali Ri Mormori Anan, naikoro lolo Makromod Lalap Ma Narehi Ma Nalewen herne malanna, la mim do'on Ya'u mai wali'ur lolo hulik loiloi kakam larlarie!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Enime'ede imam man kulu narehi onne sirrikiyedi rainne na'aheni, “Ai na'ihoru na'idaru Makromod Lalap me'e, de yono kanoin man kuku maka namehin me'e. Mi na'akeme dernedi Ainina wanakunu ma na'ihoru na'idaru Makromod Lalap! ");
INSERT INTO kjeNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ende mala inhawa kenekrohu?” Hir walha, “An sale wake'e, de hukumesne here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ende hir saprui apar Yesus oin makan, hudi, pahare, ");
INSERT INTO kjeNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","la ra'ahenia, “Heih, lo'o mamwali Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi eni, kene kukunohi mayai inhoi man pahar O?” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lere onne Petrus naikokoro aile nikoin, la man howok maeke ida laa na'aheni, “Om lernohi Yesus ri Galilea onne haenhi!” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Maa an konohi heri onne na'ahenia, “Ya'u ka auroin onuma panaeku onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Enine ai nala'a nika lapa makan, man howok maeke namehin aile lolo onne do'on ai, de konohi ri man aile lolo onne na'ahenia, “Ri eni idedi noro Yesus ra'alono rano Nazaret.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Enine an kikan hopo na'ahenia, “Makromod mehen do'on, ya'u ka auroin ri onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka nalo'ol ne, ri man aile lolo onne re'el Petrus na'ahenia, “Memen o eni, ri nano hi haenhi, ono onuma wanakunu naise hirira wanakunu.” ");
INSERT INTO kjeNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Enime'ede Petrus nahopo wali'ur na'ahenia, “Makromod Lalap mehen do'on ka auroin ri onneni!” Idewe manu kokoroiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Enime'ede Petrus horoknala inhawa man Yesus na'aheheni, “Manu kan kokoroi makun, o ma'aheniyedi ka mauroin Ya'u rewkelu me'e.” Ai raram penuwale me'e de nala'a paharne la nahere maheruheru. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Noho kan ropo wawa'an makun, imam lapa na'akeme roro Yahudi rira leleher lalap rala kenekrohu resne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hir wukuwedi Yesus rodi laa kanile Pilatus. Pilatus onne, Roma nin rai lalap kikan namwali gubernur lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lere Yudas ma nodi panaeku yaka onne, derne Yesus lernaledi kenekrohu hukumesne, an hehel rehi de nala wali'ur kupan pere welikelu onne imam lalape noro Yahudi rir leleher lalap enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudas na'aheni, “Ya'u hi'iyedi dohohala me'e, ono ya a'oluwedi ri ma na'alehe sala.” Maa hir walhe, “Ai ka modi ma'uwara num panaeku onne. Onne onum panaeku aimehi!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Enime'ede Yudas sopoledi kupan onne lolo Makromod Lalap Nin Romleu Lap raram la namhara lolo onne lan mehen wairesne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Imam lalap enihe rala kupan onne la ra'aheni, “Iknika agame nina holoor halauk luli nair kupan onneni ono namwali kupan rodi pair ma nesne ri, de kan wa'an kala kupan onne rodi rawa'aha kupan man aile oplaha rodi hohoi kakani Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hi rala kenekrohu rodi kupan onne weli lari ipida nano ri ida ma nauroin hi'i randale. Lari ipa onneni hir weli leke namwali do'on awan rira makileke. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rakan lere eni, waki lari ip onne ra'ahenia, ‘Lari Ipa Rare’ ono kupan onne rodi resne ri. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Nonolu nabi Yeremia na'aheni, “Hir kokala kupan pere welikelu, ono ri Israel re'e pair onne leke rodi weli Ai. Enla hi rodi kupan onne weli lari ipida nano ri man hi'i randale. Ha wo'ira onne namwali lernohi Makromod Lalap Nin konomdere maya'u.” Lere imam lalap onnenihe weli lari ip onne hi ra'akuku ra'anokor Yeremia nin wanakunu onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Enla Yesus namriri lolo Pilatus ma namwali gubernur kalarna ne, Pilatus na'ukani Ai na'ahenia, “O penia ma namwali Rai Yahudie?” An walha, “Namlolo, naise ma'aheheni eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Enime'ede imam lalap roro Yahudi rir leleher lalap tumdesne Ai, maa kan walha wanakunu ida. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatus na'ukanie, “Kam derne rira wanakunu rodi tutumdesne Oe?” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Maa Yesus kan walha wake'e, de Pilatus mehe nanana me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nadedem rakan Lere Alam Lalap Paska, gubernur huri ri ida nano nin hunukum, la nala leken heri Yahudi enihe nili ri onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lere onne ri ida aile bui raram naran Yesus Barabas. Ai onne ailanna wake'e de naran pe'eredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Heri lawukuwedi me'e, Pilatus na'ukani hi, “Minim suke ya'u huri inhoi? Yesus Barabas, ee Yesus man rapolu, ‘Kristus’ eni?” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus na'ukani heheni ono nauroiroin Yahudi rir man panulu enihe kele Yesus rodi mai ono hir kehekehen Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus naikokoro aile kadere rodi ho'ok kail ri makun, hono aku lir ma na'ahenia, “Yom hi'i haida-haida ri ma na'alehe sala onne, ono alam eni apinpinhedi lolo ainu'u mi lo.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Maa imam lalapa roro Yahudi rir leleher lalap rawa'u heri onnenihe leke rapanak Pilatus huriyedi Barabas la hukumesnedi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Enine gubernur na'ukani heri wali'ur, “Nano ri woro'o eniyeni, minim suke ya'u huri inhoi?” Hir walha, “Barabas!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus na'ukani, “Ende minim suke ya'u hi'i inhawa noro Yesus man rapolu ‘Kristus’?” Hi na'akeme walha, “Male, wairesne au kekiyowok here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus na'ukani, “Alhi'ihepe? Nina inhawa sala pe?” Maa hir eren wakaukau raruri ra'aheni, “Wairesnedie lolo au kekiyowok here!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus nina panaeku huri Yesus, maa heri onnenihe lo'o hi'i wowo'o ar'arra de ka namwali. Enpenia ai nala oir nodi wuri liman lolo heri kalarna na'aheni, “Ya'u ka a'uwara Ri eni Nina maki-maki, de minima panaeku aimehie!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Heri onnenihe na'akeme walha, “Na'amolia rarna ai ma'uware, moro idewe ai upum anumhe.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ende Pilatus huriyedi Barabas la hopon nin ma nasala ke'urauk enihe riuk rerhe Yesus horu mene rodi laa leke roho waire lolo au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatus nin ma nasala ke'urauk enihe rodi Yesus laa gubernur nina rom rodi ho'ok kail ri raram, la nin ke'urauk na'akeme olokedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hir ruriyedi Yesus Nina nainair la rala rai nin nainair nanaru mere mohmohon ida An nair. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hir nanau dupal rururi ida nanumene rala loile uluwakun la rala our deul ida loile liman malanneni. Enla hir kadi ein korno Ai kalarna la hadwei hadwokor ra'aheni, “Hiyene arore ki O, Rai Yahudi O!” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hir saprui saworno Yesus la rala our deul onne rodi nukur uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hadwei hadwokor Yesus horu, hir herre wali'uredi rai nin nainair nanaru hi raraleni, la rala Ainina nainair wali'ur. Horu ne, hi rodi laa kota paharne leke rohe wairesne lolo au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hi ramhara kota onne, pakromo noro ri ida nano kota Kirene naran Simon. Hi rakernne ai na'uwara au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kame'ede hir rakan wo'or ida naranne Golgota napa'ahne, ‘onno ma naisa uluwaku rurna’, ");
INSERT INTO kjeNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","la rala anggur rawa'aha noro ha man mermeru rala Yesus nomun, maa An kenedi ne, namhene nomun me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Roho wair Yesus horu, hir hi'i undi leke ha'ar Yesus Nina nainair eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Horu ne, hi raikoro lolo onne radiyaka. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Enla hi rala papan ida loile Yesus uluwakun wawan. Hir horok rodi tunum desne Ai lolo papan onne nahenia: ");
INSERT INTO kjeNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Lere onne ri man ailanna woro'o roho wairesne wewerre noro Yesus, ida minle herne malanna la ida minle herne mariri. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Heri man min lolo onne hadwei hadwokor Ai, la rado'do'o uluwakun ");
INSERT INTO kjeNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ra'ahenia, “Heih, O ma'aheni maiye'eredi Makromod Lalap Nina Romleu Lapa la alam wokelu ma'ariri wali'ure? Makromod Lalap Anan O kokkoo, ma'ohu mahaledi O kopuredi nano au kekiyowok onneni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Imam lalap, meser Horok Lap roro Yahudi rira leleher lalap enihe hadwei hadwokor Yesus ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ai na'ohu nahala ri namehin nano rir apinpinha, maa Ai kemen ne, ka. Lo'o Ai namwali Rai Israel haromo, kopuredi nano au kekiyowok leke ik akin naili'il Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ai akin naili'il Makromod Lalap, la Ai na'aheni, ‘Ya'u Makromod Lalap Anan,’ de ik po'on ke'ede lere eni Makromod Lalap na'ohu nahala Ai kemen, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ri man ailanna ma noro Yesus wairesne onnenihe hadwei hadwokor Ai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nano lere ulu (riuk idaweli woro'o) rakan lere mamamal (riuk wokelu) noho metek lolo noho onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rakanedi lere mamamal eni ne, Yesus wakau naruri na'ahenia, “Eloi, Eloi, lama sabaktani?” Napa'ahne ‘Makrom'u Lalap, Makrom'u Lalap, alhi'ihepenia hurikaruwedi Ya'ue?’ ");
INSERT INTO kjeNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ri man aile lolo onne derne Ai Lirn onne, ra'aheni, “Ai maha napolu Elia.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Enime'ede ri ida nano hi larlari laa nala sawar wukule au ida nala ku'ule anggur ma'alinlinu mene nala loile Yesus nuranne, ");
INSERT INTO kjeNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","maa ri namehin ra'aheni, “Yono! Wa'an rehi ik po'on lo'o Elia man huri nano au kekiyowok eni, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus wakau naruri, idewe aran horuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Idewe tapi rodi kawkawa Makromod Lalap Nina Romleu Lap raram onne, nahinarukedi nano wawan laa yawa namwali woro'o me'e, la noho narururu de waku ma aile wo'or-wo'or pa'ahedi. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lunna-lunna nahinari horu, la Makromod Lalap Nin ri man maki nonolue eni, mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rakan lere Yesus mori wali'ur mene man mori wali'ur onnenihe ramhara rala'a Yerusalem, la ri nammori do'on hi lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uluwakun ke'urauk ma nadiyaka Yesus noro ma nasala ke'urauk namehin, hir rase rururuwai noro ha ma namwali onne me'e, de ramka'uk wake'e la ra'aheni, “Namlolo kokkoo, Ai onne Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lolo onne maeke nammori aile mahar popo'on nano ko'uko'u. Hir lernohiyedi Yesus nano Galilea leke ilitolle. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Magdalena, Maria (Yakobus noro Yusup inna), noro Zebedeus hono aile maeke onnenihe raram. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na'ikeki na'umetek, ri orkanaru ida nano Arimatea naran Yusup laa Pilatus. Ai namwali Yesus Nina man lernohi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","An laa nakpali Pilatus napanak Yesus ihin kemen. Ende Pilatus hopon rala Ai ihin kemen Yusup. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusup kokale la nodi tapi lenan worworu nanaru ida komonedie. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ai nodi Yesus ihin kemen laa na'akene manaku lolo nina ku'il worworu man hi'iyedi me'e lolo wo'or waku herne. Ai nala ihin kemen laa ku'il raram horu, poi waku lapida nodi elekedi nikeni la nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena noro Maria namehin raikoro rakpaliyedi ku'il onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rakan oreki, Alam Renren Warwarna, imam lalap roro ri Parisi enihe laa rakpali Pilatus ");
INSERT INTO kjeNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ra'aheni, “Makrom'u, am horhorok lere ri ma napoho onne mori-mori makun Ai na'aheni, ‘Alam wokelu Ya'u mori wali'ur.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ende hopon ri nadiyaka ku'il wawa'an hehen nanumene rakan alam wokelu leke yono Nina man lernohi pakunohi enihe mai ramna'a, la konohi ri nahenia mori wali'uredi me'e. Yon hi'i nahenia poho man kauli'ur eni yaka narehi poho ma nolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus hopon na'ahenia, “Moro ainu'u ma nasala ke'urauk heruwali laa madiyaka ku'il wawa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kame'ede hi rala'a me'e. Hir rakan ku'il onne, rala tanadida loile waku rodi e'elek ku'il onne leke lo'o ri nawolle haromo, hi rauroiroin, la ma nasala ke'urauk enihe minedi kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Alam Renren Warwarna horu, domeku al'alam wake'e, Maria Magdalena noro Maria namehin eni lar tolle ku'il eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lere onne me'ede rururuwai lape, la hophopon a'am raram ida kopur mai nano a'am raram lan poiyedi waku lapa man min nikeni, la naikoredi waku wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oin makan siksika lerlere la nina nainair wawarha wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma nasala ke'urauk ma nadiyaka lunna onne rarururu la ramka'uk wake'e de ralwali yawa naise makiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maa hophopon a'am raram onne ne'el maekenihe, “Yono mamka'uk! Ya auroiroin mim mai manoin Yesus man wairesnedi lolo au kekiyowok onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ai kan min mai eni, An mori wali'uredi me'e naise nonolu An kukunohi mi eni. Mam po'onnala Nin namkuru onneni, ");
INSERT INTO kjeNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","la halhala lam kukunohi Nina man lernohi pakunohi enihe, ‘An mori wali'uredi me'e, la noluwedi mi laa Galilea me'e, de mala'a enne leke mim do'on Ai!’ Horhorok inhawe man ya'u kukunohi mi eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kame'ede hi ramka'uk maa akinhe nahuwa'an haenhi, de pelekleke lar kukunohi Yesus Nina man lernohi pakunohi enihe inhawe ma namwali eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hi ka rala'a ko'u makun, ramlilinnohi Yesus mai pakromo noro hi nahuwo'okedi na'aheni, “Hi'ihewiyala? Wa'wa'an, ee ka?” Hir mai raurukuwala ein la ra'uli rasa'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesus konohi hi na'ahenia, “Yono mamkauk, mala'a here, lam konohi I wal'uhe rala'a Galilea leke do'onala Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maeke onnenihe aile kalla makun, ke'urauk ma nadiyaka ku'il heruwali wali laa kote kukunohi imam lalapa enihe ha ma namwali lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ende imam lalap noro Yahudi rira leleher lalap enihe lawuku, rala kupan nammori ke'urauk ma nadiyaka onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Enla hir nou ke'urauk enihe, “Lo'o rin mai na'ukani mi Yesus ihin kemen ai ewi, mi ma'ahenia, ‘Man lernohi pakunohi Yesus enihe rodi a'alam mai ramna'edi me'e. Hir mai ne, ai mamkukuru.’ ");
INSERT INTO kjeNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lo'o gubernur derne panaeku eniyeni, am wakunu noro ai leke yono hukumesne mi.” ");
INSERT INTO kjeNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ende hir kokala kupan onne la hi'i naise nonou eni. Enpenia rakan lere eni wanakunu onne ri Yahudi maha raderre radaul. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ri idaweli ida man lernohi Yesus enihe rala'a Galilea, hir wakiha'a laa wo'or man Yesus konohiyedi hi me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lere onne hir do'on Yesus, la hi ra'uli rasa'e, maa heruwali akin ka namkene. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus na'urani hi na'aheni, “Molollo a'am raram noro noho wawan na'akeme raledi Maya'u me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ende mi lam konohi I Lir'u ri mormori noho wawan na'akeme leke hi ramwali man lernohi Ya'u, la moro hi laa oir raram ulutade rodi Makromod Lalap, Anan, noro Roh Kudus Oin Naranne. ");
INSERT INTO kjeNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wakuku hi leke derne rakani lernohi wanakuku na'akeme man Ya aledi ki mi me'e. Enla Yo orole'ule'u orowaliwali mi mamani rakan noho nin man horu.”");
INSERT INTO kjeNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Horok eniyeni Lira Wawa'an ma na'ono Yesus Kristus, Makromod Lalap Anan. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hari Lira Wawa'an eniyeni namnenehe nabi Yesaya nin horok ma na'ahenia, “Makromod Lalap na'aheni, ‘Ya'u hopon Ainu'u ma nodi lira na'ahari kalla nolu mai leke hari kalla ki O. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ri ida aile lolo noho mamun ma napro'uk wakaukau na'ahenia: Ma'ahari kalla la ma'anehe, leke Makromod lole.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Enpenia Yohanis ma nodi oir ulutada ri min lolo noho mamun ma napro'uk. Lolo onne an loikaru lir ri na'akeme na'ahenia, “Herredi minim morimori ma ka namlolo eni, mai derne makani Makromod Lalap, la mala mi kemmu ulutade leke namwali tanada nahenia Makromod Lalap na'ohu nahaledi minim dohohala me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ende ri nammori rano Yudea ulla ki'il lolo waliwali noro kota Yerusalem ne'en raram na'akeme maiwuku, derne Yohanis. Hi meririi werre akin kukunohi rira dohohale nanumene Yohanis norhe laa oir wauwau Yordan raram ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanis nair nainair rodi unte wulu hi'ie noro kali ehe rodi ha mormori ulikne hi'ie, la nina nana'an nonomun poreke noro wani oir. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohanis konohiyedi ri na'ahenia, “Yo oluwedi Ri ma nodi molollo narehi ya'u mai. Ainina pakpak ei nin kali me'ene kan wa'an ya'u we'er. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yo odi oir ulutada mi, maa An ulutada mi nodi Roh Kudus.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lere onneni Yesus mai oir wauwau Yordan nano Nin leke Nazaret lolo noho Galilea, de Yohanis ulutada Ai lolo oir onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus namharedi oir eni ne, An po'on laa wawan, a'am nahinariyedi, la Roh Kudus molmolo merpati ida kopur mai Ai wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Onne horu, derne lira ida namhara a'am raram na'ahenia, “Ya An'u O! Ya amre'e amharu O. Om hi'i Ya akin nahuwa'an rehi!” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lere onne me'ede, Roh Kudus norkaru Yesus laa noho mamun ma napro'uk. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","An min lolo onne alam weli'akka la Hayakyak Makromon mai kene patal Ai. Lolo onne ha mormori merwui naworo nawa'aha noro Ai, la hophopon a'am raram mai wayahu wadane. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kele Yohanis rala laedi bui raram ne, Yesus laa noho Galilea loikaru Makromod Lalap Lirna Wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ai na'aheni, “Lere Makromod Lalap nodi molollo ri mormori na'uraniyedi me'e. Herredi minim morimori ma ka namlolo eni, la derne makani Makromod Lalap Lirna Wawa'an eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ai nala'ala'a lolo oir lap Galilea arkanne, An do'on ma nohu meki woro'o, Simon noro mo'oniwalla Andreas mahar sopol diyale. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus naka'uk hi na'ahenia, “Mam lernohi Ya'u leke Ya'u wakuku mi manoin ri mormori naise manoin i'in.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Idewe hir hoikaruwedi rir diyaleni, laa lernohi Ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hi rala'a laa kalari tarana, Yesus do'on Yakobus noro mo'oniwalla Yohanis noro aman Zebedeus mahar tapil dari aile korkore wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ai napoluwedi hi, idewe hir hoikaruwedi aman noro nina man howok enihe, laa lernohi Ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus noro Nina man lernohi pakunohi rakan kota Kapernaum nediyale Yahudi nina Alam Renren Warwarna, de Yesus laa Yahudi nina kerei raram wakuku. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","An wakuku ne, heri mehe nanana mouwedi la aki'aki uluwakun derne Nina wanakukue, ono Ai kan wakuku naise hirira meser Horok Lap enihe, maa An wakuku naise ma nodi molollo. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ai mahan wakuku, ri ida mai kerei raram, hayakyaka hu'uhu'ur raramne. Maiyedi kerei raram ne, an wakau Yesus na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Oih! Yesus! Nazaret O. Onuma inhawa panaeku noro mayai? O mam mesne mayai? Ya auroinedi O me'e. O penia Makromod Lalap Nin Hophopon mememen man moumou dewdewe.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus dadiyale, “Karkaramedi! Mamharedi ai raram here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hayakyaka onne do'odewe ri onne me'ede, kais makin la namhara. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Idewe na'akeme polletilu. Ida ma na'ukani ida na'ahenia, “Eih! Ha eni inhawpe? Ma namwali eni lo'o wanakuku worworu. Ai nodi molollo hayakyaka enihe penia hir derne rakani Aie!” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Enime'ede lira ma na'ono Yesus Nin hini'i eni pelek raderre radaul lolo Galilea ne'en raram na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kerei namharedi ne, Yesus, Yakobus noro Yohanis ra'alono laa Simon noro Andreas rira nakar. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lere onne Simon paninne maeke nakni'ir rinna manha, de namkukuru lolo nakar. Hir rakan nakar, manin nakar konohi Yesus na'ahenia, “Pape, mama ornakar nakni'ir rinna manha.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Enine An laa roulle liman namake. Ideweni ne, nin kini'ir wa'anedi. Horu ne, ai na'akene hanana'an hi ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lere helemedi ri nodi ma nakni'ir noro man hayakyaka huhu'ur raram na'akeme mai Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ri nammori man holi kota onneni mai nakar onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Enime'ede An hi'i wa'an apinha rahu eni, la nohi hayakyaka man hu'uhu'ur ri raram enihe. Enimaa, Yesus ka nala leken hayakyaka wakunu, ono hi rauroinedi me'e Ai onne Makromod Lalap Anan. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rakan noho roropo Ai namaka laa paharne. Ai namhara leke laa onno ma namlina namkai hi'i lir napanak, ");
INSERT INTO kjeNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","maa Simon noro nina mukue laa ranoin Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pakromedi ne, hi ra'aheni, “Eih! Pape, ri nammori maha ranoin Papa!” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Enine Ai na'aheni, “Mai kala'a leke-leke ma na'uranrani eni leke Ya'u loikaru Lira Wawa'an lolo enne haenhi. Onne penia Ainu'u panaeku mai noho wawan eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Enime'ede An laliwewer Galilea raramne laa Yahudi rira kerei-kerei loikaru Lira Wawa'an onne, la nohi hayakyaka man aile ri raramne. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ler ida mo'oni ida man ulik yak hi'ie mai Yesus kadi ein korno kalarna na'aheni, “Papa ne'e harome hi'i wa'anedi ainu'u apinha ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Enime'ede Yesus naramyakale, de kemenala liman laa ri onneni na'aheni, “Ye e'e! Wa'anedi here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Me'e'eni me'ede nina ulik yake moluwedi, de wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Horue ne, Yesus hopon ai na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Yom konohi ri ha ma namwali o kemmu eniyeni, maa mala'a laa imam nanu leke an po'onala o kemmu, nauroin nahenia om wa'anedi me'e, la modi onum honoi kanani mala ai leke lernohi agame nina holoor halauk eni. Hi'i onne leke namwali tanada nahenia om wa'anedi kokkoo me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Enimaa, ri onne nala'a ka nodi nou onneni, ono an wakunu laliwewer panaeku ma namwali kemen eni. Enpenia ka namwali Yesus laa leke-leke nin leke raram, de minle leke paharne lolo onno ma namlina namkai. Min lolo onne maa, ri nammori lolo waliwali mai leke dernale. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nakawedi alam ida woro'o ne, Yesus nala'a Kapernaum wali'ur. Enpenia raderre radauledi nahenia An minle nakar ida. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Enime'ede heri maiwuku ho'o me'e, hir penuwuku lolo onne penia onno kan nokor. Nika makan penpenu ri mormori. Enine Yesus loikaru Makromod Lalap Lirna Wawan ri onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","An wakunkunu ne, ri wo'akka rodi ma naplu'uk nap'eker ida mai Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ri nammori rehi, de leken kaale laa wakurani Yesus miminlole. Ende hir raiye'er nakar wawan nanumene hi rala kopur ri onne noro nin namkuru onno laa Yesus kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus po'on nauroin nahenia ri onnenihe akin naili'il kokkoo, de ne'el man apinha onne na'ahenia, “Pa'e, Ya a'ohu ahaledi onuma dohohale me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Maa, meser Horok Lape woro'o wokelu raikokoro aile lolo onne roro akin wakunu na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Alhi'ihepenia ri eni wakunu heheni? Ai na'ihoru na'idaruwedi Makromod Lalap me'e. Inhoi nodi molollo na'ohu nahala dohohala? Makromod Lalap mehe!” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus nauroinedi hi honorok akin me'e, de na'ukani hi na'ahenia, “Hi'ihepeni mim kikan panaeku eni mi raramne? ");
INSERT INTO kjeNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ewi man sus rehi? Ya aheni ma naplu'uk nap'eker eniyeni Ya a'ohu ahaledi nin dohohala, ee Ya'u hopon ai namakedi, la kikan nina namkuru onno, wali laa nin nakar here! ");
INSERT INTO kjeNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ya'u hi'i wa'an ri eni leke mi mauroin mouropo nahenia Ya'u eni ma namwali Ri Mormori Anan, la Yo odi molollo lolo noho wawan a'ohu ahala ri nina dohohala!” Enime'ede Yesus hopon ri ma naplu'uk nap'eker onne, ");
INSERT INTO kjeNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mamakedi! Modi num namkuru onno, wali laa num nakar here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ai namriri, kikan nina namkuru onno, nodie namhara. Heri man po'on mo'oni man wa'anedi onne na'akeme polletilu. Hi ra'uli rasa'a Makromod Lalap ra'aheni, “Makromod Lalap Ma Narehi Ma Nalewen! Ai kam do'onala ha nais eni makun.” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus wali wali'ur laa oir lap Galilea, la ri nammori mai de Yesus wakuku hi. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hi rala'ala'a ne, An do'on Alfeus anan Lewi naikokoro lolo onno rodi ra'uk paipair. Yesus na'aheni, “Mam lernohi Ya'u.” Enime'ede Lewi namriri lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ka nalo'ol Lewi lariyala Yesus noro Nin man lernohi pakunohi rala'a nina nakar, ra'ak. Man ra'uk paipairi noro ‘man hi'i dohohala’ nammori raikoro wuku roro Yesus noro Nin man lernohi pakunohi, la ra'ak wewerre ono ri nammori lernohiyedi Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Meser Horok Lap nano muku Parisi ida woro'o mai do'on Yesus na'akwuku noro man ra'uk paipair noro ‘man hi'i dohohala’ enihe. Hi ra'ukani Yesus Nina man lernohi pakunohi enihe ra'aheni, “Hi'ihepenia minim Meser eni ra'ak wewerre noro man ra'uk paipair roro man hi'i dohohala enihe?” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus dederne rira na'ukankani onneni, de An walha na'ahenia, “Ma kan apinha ka nanoin ma na'inapin. Man apinha mehe nanoin ma na'inapin. Ka'u mai apolu ri man hi'i ha ma namlolo mamani, maa Ya'u mai apolu ri man hi'i dohohala.” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ler ida Yohanis man ulutada ri nin man lernohi ida woro'o roro Parisi enihe mahanoro ra'aluli kemen ka ra'ak romun. Ende rin mai na'ukani Yesus, “Hi'ihepenia Yohanis nina man lernohi enihe roro Parisi enihe lernohi Yahudi nina holoor halauk, de ka ra'ak romun, maa Onuma man lernohi enihe kae?” ");
INSERT INTO kjeNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus walha na'ahenia, “Ik min hohoo, popolu lalariyala enihe ka ra'ak romun? Ka! Mo'oni man ho eni nornore makun, hi ra'ak romun mamani! ");
INSERT INTO kjeNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Enimaa rakan orekiyedi ri namehin mai rala man ho eni nano hi leken kalarne nanumene hi ra'aluli kemen ka ra'ak. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ri kan tapil nainair lo'olo'ol nodi tapi a'un worworu, kalo'o tapi a'un rodi tatapil onne hi'i riki nainair onne eren lalapa. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Namnenehe onne ri ka nadedem nala anggur worworu halle sak ulik lo'olo'ole, kalo'o anggur worworu eni hi'i sak ulik lo'olo'ole napriki de anggur noro sak ulik yakedi, kar nair me'e. Maa ri nadedem nala anggur worworu halle sak ulik worworu.” (Ai nodi wanakunu naho'ok eniyeni leke nounaku hi yono lernohi wanakuku nonolu eni, maa lernohi Makromod Lalap Nina wanakuku worworu eni.) ");
INSERT INTO kjeNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ler ida, Yahudi nin Alam Renren Warwarna, Yesus noro Nin man lernohi pakunohi enihe rala'a lolo gandum kirna ida. Maie ne, man lernohi pakunohi enihe reku gandum. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ri Parisi ida woro'o ma aile lolo onne do'odo'on, de ra'ukaniyale, “Hi'ihepenia Onuma man lernohi pakunohi enihe larlewenedi iknik agame nina holoor halauk me'e?” Hi ra'ukani heheni ono hir pene'ek reku gandum onne namwali honowok man luli hi'i lolo Alam Renren Warwarna. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yesus walhe na'ahenia, “Lo'o mi kam lesala inhawa ik upud Daud hihi'i lere ai noro nina kalla wali ra'alehe hanana'an de ramlara me'e! Lere onne Abyatar namwali Makromod Lalap Nina imam man kulu narehi. Daud laa Tenda ma namwali Makromod Lalap Nin miminlole raram na'an roti man luli ra'an ono rodi hoikani Makromod Lalap. Makromod Lalap Nin holoor halauk hurinohi imam mehe ra'an roti onne, ri namehin ka. Maa Daud nala roti ha'ar nina muku ra'an haenhi, ono Daud nauroin nahenia Makromod Lalap naramyaka ri mormori narehi Ai naramyaka Nina holoor halauk onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Alam Renren Warwarna nin holoor halauk eni peni ra'akene leke paku ri mormori, ka nahenia hi'i ri mormoriyana leke derne rakani Alam Renren Warwarna nin holoor halauk eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ya'u, ma namwali Ri Mormori Anan, odi molollo hopon rin hi'i ha wo'ira Alam Renren Warwarna.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lere namehin Yesus wali wali'ur laa Yahudi nina kerei raram. Lae ne, holikuku mo'oni ida liman wali makiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lere onne Parisi ida woro'o aile lolo onne maha ranoin Yesus Nina sale, leke hir kele la kalake. Hir kokolole ke'ede, lo'o An hi'i wa'an mo'oni man liman wali maki eni Alam Renren Warwarneni, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus ne'el mo'oni man liman maki onne na'ahenia, “Mai mamririyedi heri kalarna.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","An maiyedi kalarie ne, Yesus na'ukani Parisi man aile lolo onnenihe na'ahenia, “Iknik holoor halauk hurinohi ika hi'i inhawa Alam Renren Warwarna? Hi'i ha wawa'an, ee hi'i ha yakyake? Hi'i ri man apinha wa'an, ee reden ri?” Maa, hi na'akeme ka ra'oho ono ka rauroin walha me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus nodi oi mahu po'on waliwali la na'ahan haenhi ono Ai nauroin ri enihe ra'uluwaku kekerhe la honorok akin kiki'il. Enime'ede Ai ne'el ri man liman maki eni na'ahenia, “Ma'aloledi o limmu.” Ri onne na'aloledi liman, idewe liman wa'anedie. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ende me'e'eni me'ede, ri Parisi enihe ramhara kerei korowuku ra'ukwuku roro ri woro'o wokelu man kuku leu Herodes leke ranoin kalla man wa'an resne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Enime'ede Yesus noro Nina man lernohi pakunohi ramhara leke onne laa oir lap Galilea. Lere onne ri nammori nano Galilea lernohi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yesus naran pe'eredi me'e, de rin maiyedi nano kota Yerusalem wali karanna, Yudea, noro Idumea. Heruwali mai nano oir wauwau Yordan wali kimur, la heruwali mai nano Tirus noro Sidon wali ra'i. Hi na'akeme mai Yesus ono hir dernedi Ainina hini'i rahu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ri nammori rehi mai lupurale, de Yesus hopon Nin man lernohi pakunohi enihe ra'akene korkoro ida leke yon heri rahu onne rokul Ai laa oir lap raram. Heri onne luplupurale ono ");
INSERT INTO kjeNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","An hi'i wa'anedi ri nammori me'e. Lolo heri onne raram ri man apinha noro ma nakni'ir nammori hi ida ma nokul ida laa kalari leke tukulala Nin rain. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lere onne lo'o hayakyaka man huhu'urle ri raramne enihe do'on Yesus, ri onnenihe ne'e namhene laa Yesus kalarna awikorno wakau na'ahenia, “O penia Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Maa An kawala hayakyak onnenihe na'aheni, “Yono konohi ri Ya'u eni inhoi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus namhara oir lapa arkanne wakiha'a wo'or ida napolu ri man Ai raram nodie. Ri onnenihe mai ne, ");
INSERT INTO kjeNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","An kikan ri idaweli woro'o nano hi ramwali Nin hophopon ma nodi Lirna Wawa'an enihe. Ai na'ahenia, “Ya'u nili mi leke lernohi Ya'u, leke mi maderre madaul I Lir'u laa ri mormori, ");
INSERT INTO kjeNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","la Ya ala molollo mi mohi hayakyaka.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri idaweli woro'o enihe naran me'eni: Simon (Yesus waki naran Petrus haenhi), ");
INSERT INTO kjeNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus noro mo'oniwalla Yohanis, Zebedeus ananhe. (Yesus waki hi naran ‘Boanerges’ haenhi. Naran onne napa'ahne, ‘rir morimori naisa ilak waslene’.) ");
INSERT INTO kjeNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Pilipus, Bartolomeus, Matius, Tomas, Yakobus (Alfeus anan), Tadeus, Simon (nano muku Zelot), ");
INSERT INTO kjeNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","la Yudas (ma na'olu Yesus). ");
INSERT INTO kjeNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Horu ne, An wali laa nakar miminle, la ri nammori mai wali'ur penia Ai noro Nina man lernohi pakunohi ra'alehe leken ra'ak romun. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ainina nakar raram derne lira anna na'ahenia, “Yesus ka na'ak, de lo'o Ai honorok akin ka namlolo me'e,” penia walinhe lar polu. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Meser Horok Lap enihe rano Yerusalem mai ra'aheni, “Beelzebul ma namwali Hayakyak Makromon eni hu'uredi raramne me'e, de nala molollo Ai nohi hayayaka nano ri raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Enpenia Yesus napolu heri mai mene nala wanakunu naho'ok ida woro'o. Ai na'ukaniyala hi na'ahenia, “Hi'ihehewi hayakyak ida nohi hayakyaka namehin? ");
INSERT INTO kjeNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lo'o hair ida napye'er namwali muku ida woro'o, la ida ma kan derne ida, hair onne lo'o keperedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lo'o meheromo ida man holi iw'iwar wo'owo'or noro ida ka namwali haida, maa keperedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Namnenehe Hayakyak Makromon nina ma nodi molollo. Lo'o ida ma na'okul ida, molollo onne lo'o moluloinedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lo'o rin paeku laa ornakar ma naruri ida nina nakar namna'a hahaa, maa ai kan kele wuku ma naruri onne makun, ka namwali nala nin hahaa. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Makromod Lalap na'ohu nahala ri nin dohohale noro wanakunu ma na'ihoru na'idaru na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","maa inhoi ma na'ihoru na'idaru Roh Kudus, Makromod Lalap ka na'ohu nahala nin dohohala onne laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus na'aheni heheni ono ri na'ahenia, “Hayakyaka hu'ur Ai raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ende Yesus inna noro mo'oniwalinhe mai. Hir lapan paharne, la hopon ri lan polu Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lere onne ri nammori raikoro lolowewer Yesus. Hir konohie ra'aheni, “Papee, O inum noro mo'oniwallumhe aile paharne. Hir maha ranoin Papa.” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Enine An walha na'ahenia, “Yi in'u inhoi? I mo'oniwal'uhe inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Enime'ede An po'onala ma naikoro lolo herne waliwali na'aheni, “E'eni penia Yi in'u la I mo'oniwal'uhe. ");
INSERT INTO kjeNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ri man derne rakani Makromod Lalap Nina panaeku, onne penia Yi In'u, I nar'u, la I mo'onwal'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ler ida Yesus wakuku wali'ur lolo oir lap Galilea arkan. Ri nammori mai lupurale, de An ha'a korkoro ida man palpali lolo onne, naikoro wawanne mene wakuku heri lape man aile lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ai nodi wanakunu naho'ok leke wakuku panaeku nammori heri onne, la lolo Nin wanakuku Ai na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Makaniyala! Ler ida ri man howok kirna nodi wini hawonne lan wahaire. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","An wahair ne, wini heruwali nadiyaur kalla wawan. Ende manu liwliwar mai na'an moumouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Heruwali nadiyaur elimo'o wakwaku. Memen pelek mori ono elimo'o tarana mehe, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","maa rakan lere ulu, lupun napro'ukedi ono ka na'a'ar. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wini namehin nadiyaur ruri roke raram, mori maa ruri roke eren lolode, elewesnedi de ka na'ihi. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wini ma nadiyaur elimo'o man meur onne mori wawa'anedi. Ende dipi woi nammori, de lernala rewen welikelu, welineme, rakan rahu rehi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","An loikaru panaeku onne horu, Ai na'aheni, “Lo'o mi kilinum aile, makaniyala wawa'an!” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus memehedi onnida ne, ri man dernedi Ainin wanakuku eni roro ri idaweli woro'o man lernohi pakunohi enihe mai ra'ukani Ai na'ahenia, “Wanakunu naho'ok man Papa loikaruwedi me'eni nin panaeku inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","An konohi hi na'ahenia, “Makromod Lalap nala woroin mi leke mauroin hi'ihehewi Ai nodi molollo ri mormori, maa rakan lere eniyeni mene ri mormori nauroin panaeku onne. Enimaa Yo odi wanakunu naho'ok wakuku ri ma kan peinohi Makromod Lalap Nin wanakuku wanayo'o leke, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Hir do'odo'on, maa ka rauroin inhawa namwali. Hi rakani mamani, maa ka rauroin panaeku ida. Eni namwali leke yon hir wali wali'ur mai Makromod Lalap de Ai na'ohu nahala hirira dohohale.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Enine Ai na'aheni, “Lo'o mi ka mauroin wanakunu naho'ok eniyeni, hi'ihehewi leke mauroin wanakunu naho'ok namehin? ");
INSERT INTO kjeNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Man wahair wini hawonne onneni naise ri ma naderre nadaul Makromod Lalap Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wini ma nadiyaur kalle molmolo ri mormori man akin naise elimo'o kekerhe, de lere hir derne Makromod Lalap Lirna Wawan eni, Hayakyak Makromon mai naledi nano hi akin. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wini ma nadiyaur elimo'o wakwaku eni, naise ri man derne Makromod Lalap Lirna Wawan, la kokale noro wawa'an, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","maa lirna onne ka na'a'ar hi akin, de ka nalo'ol moluwedi. Lere hir nehule ew'ewek kawkawe ono derne rakani Lirna onne, hir waliyedi kili'urnne. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wini ma nadiyaur ruri roko raram naisa ri man dernedi Makromod Lalap Lirna Wawan eni, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","maa pelek akin tana, la akin ni'ik kanaru noho wawan mamani. Akin ma ni'ik mouwedi noho wawan nin ha rahu eni penia namwali ruri roko man ewek kawala Lirneni. Ende wini onne kan woi. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Enimaa, wini ma nadiyaur elimo'o man meur na'ono ri man derne Makromod Lalap Lirna Wawan la kokala wawa'an, penia na'ili nadai ihin ennen nammori, de heruwali lernala rewen welikelu, heruwali lernala rewen welineme, la heruwali lernala rewen rahu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Onne horu Yesus na'ukani wali'ur, “Nadedem ri lokon wadu nodi ra'u lapa honow, ee nala loile leu leherne? Ka menee! Lo'o rala loile wadu onno man kulu leke ropo waliwali. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Inhawe man suwsuwar lere eniyeni, hari mouwedi lere man mai. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ende mi kilinum aile, derne makaniyala!” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","An wakunu wali'ur na'ahenia, “Loi honorok wawa'an inhawa man mim dederne eniyeni! Hono'ok mim nanair modi ho'ok kail ri namehin, Makromod Lalap lo'o nairre nodi ho'ok kail mi wali'ur, la lo'o narehi makun. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ri ma nauroin Ainu'u wanakuku wa'an tarana me'e, lo'o ra'uwali woroin narehi nalewen makun, maa ri ma kan peinohi Ainu'u wanakuku, nina woroin tarana man aile lo'o rala wali'uredi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus na'ikar na'uwali Nina panaeku wali'ur, “Lere Makromod Lalap nodi molollo ri mormori naho'ok naise ri man pekir ariyono wini hawonne. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A'alam ai namkuru, lelere namaka, ka nauroin nahenia wini hawonne mori eren lalapa. Wini mormorna, ai me'e ne ka nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Elimo'o mehen hi'i wini hawonne mori, dedesne lollo, horu kaki, horu woi la na'ihi hehen nanumene napro'uk. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Woin onne napro'ukedi ne, ai nodi kuri rosu, ono rakanedi lere alam ra'ili radai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus na'ukani wali'ur, “I kodi inhawa wanakunu leke ka'amou ka'arope hi'ihewi Makromod Lalap nodi molollo ri mormori? ");
INSERT INTO kjeNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nina molollo eni molmolo wini man tutusiyana wake'e naise wini au manu waku ida ri nala loile elimo'o eni. Kade wini onne tutusiyana, ");
INSERT INTO kjeNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","maa moriyedi eren lalapa narehi au or'oriyana man minwuku lolo onneni. Hinan hanan nammori, de manu merwui mai kaile, hi'i rira wonne nahirei kakan.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ende Yesus loikaru Horok Lap Lirna La'an ri nodi wanakunu naho'ok naise onneni namnenehe rira woroin. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesus nodi wanakunu naho'ok mamani leke wakuku heri onneni. Maa, Ai noro Nina man lernohi pakunohi enihe mehe minwuku nanumene Ai na'amou na'aropedi Nina wanakunu eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lere onne, lere helem me'e, de Yesus naka'uk Nina man lernohi pakunohi na'ahenia, “Mai ika ha'a korkore hopol laa oir lapa wali enne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Enime'ede hir hoikaruwedi heri rahu onnenihe la ha'a rir korkoro, la roro korkoro namehin ra'alono hopol me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Hopol ne, Yesus nodi luni, de namkuru mahal lolo korkoro li'ur. Rakan heleken hir lernala kahi anna lapa. Eih! Kili'uru kalari wawarhe mamani! Man lernohi Yesus lari laa ramaka Ai, “Papa Meser, mamakedi nanu, kalo'o ika keper lolo eni me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kame'ede Yesus namaka komdere na'ahenia, “Kahi anna o, mamlinedi here.” Idewe kahi anna namlina namkaiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Enine Ai na'ukaniyalahe na'ahenia, “Alhi'ihepenia mi akim tana rehie? Mi akim ka naili'il Maya'u makune?” ");
INSERT INTO kjeNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Enime'ede hi eren ramkaka'uk, ida ma na'ukani ida na'ahenia, “Leher eni inhoi, penia kahi anna lapa derne nakani Aie?” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","3","Yesus noro man lernohi pakunohi enihe rakanedi oir lap Galilea wali enne lolo leke Gerasa ne, hi pakromnala mo'oni ida man hayakyaka huhu'urle raram. Ai nadedem holi ku'il-ku'il man aile makileke. Ai onne naruri rehi, de ri nodi rantan wuku me'ene, kan yadi. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lere romromo hi rodi rantan wuku liman ein, maa ma na'iseri eni hi'i rohuwedi, ri kan rehinale wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lelere a'alam an wakaukau mamani, nala waku nodi kuku tehtehe kemen. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","An po'on Yesus lolo ko'u makun, an larlari la awikorno Yesus kalarna, ono hayakyaka man huhu'ur raramne nauroinedi Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus hopon hayakyak onne na'ahenia, “Hayakyak o, mamharedi ri eni raram here!” Hayakyak onneni wakau naruri na'ahenia, “Yesus, Makromod Lalap Ma Narehi Ma Nalewen Anan O! Num panaeku inhawa noro maya'u? Yon hi'i apinpinha maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus na'ukaniyale, “O naram inhoi?” An walhe na'ahenia, “I naran ‘Legiun,’ ono mayai eniyenihe riwriwan rahrahu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hi rapanak Yesus rewen wo'irha ra'aheni, “Yono mohi yai mamhara leke eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lere onne me'ede, wawi ukun aile maha ranoin ya'an lolo wo'or leren kan ko'uwala. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hayakyak onnenihe rapanak Ai na'ahenia, “Hopon mayai laa hu'urle wawi onnenihe raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus hurinohi hi rala'a. Idewe ne, hayakyak onnenihe lar hu'urle wawi onne raram. Oih! Wawi lo'o riwan woro'o rapaililili lolo wo'or leren idewe laa oir lap Galilea raram, de maki mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Enime'ede man wa'an wawi onnenihe wali lari laa leke raram raderre radaul Yesus Nin hini'i eni, penia ri na'akeme lari lar do'on inhawa ma namwaliyedi eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","17","Hir lae ne, lupurala Yesus noro mo'oni man wa'anedi me'e onne. Hir po'one, mo'oni onne naikokoro, ka na'oho, naspolo rainedi me'e. Enla ri man idedi do'on Yesus, mahanoro konohi heri onnenihe na'ahenia, “Idedi ai lam po'on Yesus nohiyedi hayakyaka manin mo'oni onne raramne. Enla hayakyaka onnenihe lar hu'ur wawi ma aile wo'or leren raramne. Idewe ne, wawi onnenihe lari laa oir lapa raram, de maki mouwedi.” Ende na'akeme ramka'uk, rapanakala Yesus na'ahenia, “Pape, wa'an rehi Papa laa onno namehin here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kame'ede An ha'a laa korkoro wawan wali'ur, mo'oni man idedi hayakyaka huhu'urle raramneni mai napanak Yesus, “Pape, ya'u lernohi haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Enimaa, Yesus namhene. Ai na'ahenia, “O mala'a here! Lam do'on o wallumhe konohi hi na'ahenia, ‘Makromod naramyaka ya'u, de hi'i wa'anedi ya'u me'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ende mo'oni onne kuli kuli leke idaweli lolo noho ma naran Dekapolis kukunohi inhawa man Yesus hi'i ai kemen. Enpenia na'akeme man derne polletilu. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus hopol wali'ur laa oir lap Galilea wali. An rakan ne, ri nammori mai lupurale lolo oir lap arkanne. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kan maha ne, uluwakun Yahudi rir kerei ida naran Yairus mai oir lapa arkan onneni. An do'onedi Yesus ne, lan awikorno Yesus kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ai napanak an'anhedi na'ahenia, “Papee, ya an'u maekane nin kini'ir werek wake'e, na'akeki maki me'e. Papa laa roulale leke wa'an. Alkalo'o ka noro ika me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Enime'ede Yesus noro Yairus ra'alono rala'a. Ri nammori lernohi la lupurale lolo waliwali. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maeke ida man lernohi nina apinha rare wau anna idaweli woro'o me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ainin apinha werek wake'e penia ai na'ahoruwedi kupan rahu ono nale ma na'inapin nammori me'e, maa nin apinhe kan wa'ane, eren wewerek. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","An derne Yesus eni penia hi'i wa'anedi ri nammori me'e, de ai nahehe na'urani lolo Yesus kili'urne, ono ainina panaeku nahenia lo'o tukulala Yesus Nina rain ke'e de nin apinha wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ende an tukuledi Yesus Nina raine eni ne, idewe ai nauroin nina apinha wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","An tukuledi Nina raine me'e ne, Yesus nauroin nahenia Nina ke'eke'el an'anhe tarana namharedi raramne me'e, de An wali kili'urne na'ukani, “Inhoi man tukul Ainu'u raine?” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Enine man lernohi pakunohi ra'aheni, “Eih! Papa mehen do'on ri rahu eni, rasessese, de ai kam do'on inhoi man tukul Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Enimaa Yesus koklolo waliwali nanoin inhoi man tukule. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ri maeke onneni nauroin ha ma namwali kemen eni, de nodi kemen ma narururu mai nalwali yawa Yesus kalarna konohi inhawa ma namwali ai kemen eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Horu ne, Yesus na'aheni, “Ya an'u, o akin naili'il Maya'u, de num apinha wa'anedi me'e, mala'a wawa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus wakunkunu ne, hophopon wahwahan nano uluwakun kerei Yairus nina nakar mai konohi Yairus na'ahenia, “Pape, tatana maekane aran horuwedi me'e, de yono ma'o'o Pap Meser me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Enimaa Yesus kan peinohi rira wanakunu onne, de Ai ne'el Yairus na'ahenia, “Yono mamka'uk, maa akim naili'il Maya'u mehe!” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ende Yesus nala'a me'e, la namhene rin lernohie kokoko Petrus, Yakobus noro mo'oniwalla Yohanis. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hir rakanedi Yairus nina nakar ne, Yesus do'on heri rusu arra wake'e la derne kananhi dududum. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","An laa romleher na'ukani hi na'ahenia, “Alhi'ihepenia mim arra la mahere? Tataneni kan maki, maa namkukuru.” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Man penpenu onne ralau Yesus. Enime'ede An hopon heri onne laa mouwedi paharne. Enla Ai noro tatana onne inna aman noro ri wokelu man lernohi pakunohi laa tatana onne nina kamar. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","An roulle tatana liman na'aheni, “Talita kum!” Napa'ahne, “Inaye, mamakedi!” ");
INSERT INTO kjeNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Idewe inai onne namaka, nala'ala'a. Nina anna idaweli woro'o me'e. Ri man aile kamar onne do'on ha ma namwali eni polletilu. ");
INSERT INTO kjeNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Enla Yesus nala konomdere hi na'ahenia, “Yono wakunu ha eniyeni ri.” Enla An hopon inna aman na'ahenia, “Mala hanana'an tarana na'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus noro Nina man lernohi pakunohi enihe ramhara lolo onne (Kapernaum) wali wali'ur laa Nina leke Nazaret. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Enla rakan Yahudi nina Alam Renren Warwarna, An laa rira kerei wakuku. Ri nammori derne Nina wanakuku eni polletilu, ra'aheni, “Ri eni lernala panaeku na'akemeni nano ewi? An lernala woroin eni nano ewi penia Ai nauroin hi'i tanada ri kan dodo'onnala makun?” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ida ma na'ukani ida, “Namlolo, ka? Ai onne namwali tukan aue? Inna Maria, la mo'oniwalinhe Yakobus, Yoses, Yudas, noro Simon? Narnhe aile mai eni, haenhi.” Enpenia hi ramhene derne rakani Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Enine Yesus na'aheni, “Nadedem rin horhawa nabi lolo ewi-ewi, maa mai lolo nina lekloi ai lodon walinhe noro nakar raram memen ka rahiyene arore.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ende lolo onne Ai kan hi'i ha man ri kan do'onala makun nammori, kokoko roulle ri ida woro'o liman hi'i wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","An hehel rehi hi akin ka naili'ile. Ai namhara nano Nazaret laa wakuku ri ma aile leke-leke lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enla Ai napolu Nin ri idaweli woro'o man lernohi pakunohi enihe, hopon hi wororo'o laa leke-leke lolo onne, la Ai nala molollo hi rohi hayakyaka. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","An nou hi na'ahenia, “Mala'a, maa yono modi haida-haida, oir wa'alehere, kupan, me rou soke. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Modi au ke'ke'en, pakpak ei, maa yon modi nainair herherre. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mim laa onnida, nakar ida kokaledi mi, mamkene lolo onne hehen nanumene mi mamhara leke onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Enimaa, mim laa onno namehin lo'o ri namhene kokala mi, mamharedi lolo onne. Mamharedi ne, disnedi elimo'o hapu man aile mi eium raram, leke namwali tanada hi nahenia mi ka modi yodiwara ida hi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","An wakunu horu ne, hir laa loikaru Makromod Lirna ri, leke herredi rir morimori ma ka namlolo eni, la derne rakani Makromod Lalap Lirna Wawan eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hi rohi hayakyaka nammori nano ri raram, rala wuru sapu ma nakni'ir, la hi'i wa'anedie. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Enime'ede rai Herodes dernedi wanakunu ma na'ono Yesus Nina hini'i wenewheni, ono Yesus naran pe'er wake'edi me'e. Ri heruwali ra'aheni Ai onne Yohanis ma nodi oir ulutada ri, mori wali'uredi me'e, penia Nina molollo aile hi'i tanada ri kan do'onala makun, ");
INSERT INTO kjeNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","maa ri namehin ra'aheni Ai onne, Elia. Ri namehin ra'aheni wali'ur Ai onne nabi ma nodi Makromod Lalap Lirna Wawan nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ende Herodes derne panaeku onneni an kernala na'ahenia, “Ka! E'eni, Yohanis man nonolu ya'u hopon peku uluwakun eni. Ai peni mori wali'uredi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","An wakunu heheni ono lere nonolu an hopon ri lan kele Yohanis rodi laa bui raram. Yohanis eni tumdesne mamani ono an ho'edi noro mo'oniwalla Pilipus hono naran Herodias. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ler onne Yohanis ne'el Herodes na'ahenia, “Om larlewenedi Makromod Lalap Nina keneri hono'ok me'e, ono o moro mo'oniwallum hono Herodias ho.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Enpenia Herodias nala panaeku wo'ira loiyedi akin, de nahehe nanoin kalla nesne Yohanis. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Maa, rai Herodes kawkawala hono leke yono nesne Yohanis, ono ai nauroin Yohanis ri man akin moumou dewdewe, la namwali ri molololo Makromod Lalap kalarna haenhi, de horhawe. Herodes hopon ri lan kele Yohanis wuku rodi laa bui raram, la radiyaka wawa'an leke yono rin hi'i suse. Lere romromo ne, rai Herodes hopon rala Yohanis mai paharne, leke woro'ohe wakunu ono Herodes nina suk nakanie, kade nin wanakunu onne hi'i Herodes akin ka namkene. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kame'ede rakan Herodes nin lere alam momori mene Herodias lernala leken pahaharin nesne Yohanis. Lere onne rai Herodes hi'i yapi lapa. Lariyala nina muku uluwakun ma nodi molollo noro uluwakun-uluwakun ke'urauk, roro leleher lapa Galilea mai. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Enpenia lere onne Herodias nahehe paipudi hono lolo yapi, de hopon anan maekane lan waur heri onne kalarna. An waur ma'aruru, de rai Herodes nala lira nahenia turanne, “O mapanak inhawa, ya ala ki o, kade leke a'un wali ya ala ki o.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Enime'ede an laa na'ukani inna na'ahenia, “Mame, ya apanak inhawa?” Inna walhe na'ahenia, “Laa mapanak Yohanis uluwakun.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Idewe ne, an laa napanak na'ahenia, “Pape, ya apanak lere eni me'ede, mala Yohanis uluwakun loile ra'u lape mala maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes derne napanak onneni akin woiredi. Enimaa na'okul hehewi ho'o, ono an loiyedi lira hopo popolu lalariyala enihe kalarna me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ende ne'e namhene hopon nin ri laa bui raram peku Yohanis uluwakun nodi mai. An peku Yohanis uluwakun horu, ");
INSERT INTO kjeNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nodi mai nala kani maekana onneni. Horue ne, nodi laa inna. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kame'ede Yohanis nina man lernohi pakunohi derne ha onne, hir laa rala Yohanis ihin kemen rodi loile ku'il ida ma namwali lunne raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus Nina hophopon man laa raderre radauledi Lirna Wawa'an enihe wali mai roro Yesus pakromo wuku wali'ur, leke loikaru rira nala'la'a lirna la'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hir waliyedi ne, ri nammori mai mamani, de kar lernala leken ra'ak romun. Ende Yesus naka'uk hi, “Pap mie, mai kala'a onno ma namlina namkai, warnala tarana.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ende hir ha'a laa korkoro wawan hopol laa onnida man ri kan holie. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Enimaa ri nammori po'on hi rala'a. Enime'ede ida man konohi ida na'ahenia, “Yesus hopoledi me'e. Mai ik lolo kalla ro kala'a halhala leke ik koluwedi Yesus la onno man hir lalaa eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus rakanedi ro, An do'on heri rahu onneni ne, Ai raram penu rehi ono hi raisa pipduma ma na'alehe man hurie. Ende An min lolo onne, An wakuku Makromod Lalap Lirna Wawan nammori hi. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rakan lere na'akeki helem me'e, Yesus Nina man lernohi pakunohi mai ra'ahenia, “Pape, lere helem me'e. Mai eni noho mamun, ");
INSERT INTO kjeNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","de wa'an rehi hopon heri rala'a here, leke lar weli hanana'an leke-leke man ranrani eni, ra'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Enimaa Yesus na'aheni, “Mi mehe mala hanana'an, hi ra'ane.” Hir polletilu ra'ahenia, “Idei! Ainim kupan kan nokor lam weli roti hi na'akeme ra'an! Lo'o ik na'akeme howok rakan wollo ida mene ik lernala kupan man nokor laa weli roti heri rahu eni ra'ane.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ai na'ukani hi na'ahenia, “Roti aile, ka? Mim lam tolle ke'e.” Ende hi lar tolle, wali mai konohi Yesus, “Roti kem wolima noro i'in kem woro'o mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kame'ede Yesus hopon heri onnenihe raikoro penek wawanne, hi'i lopun-lopun. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lopun heruwali muku ri wellima, lopun heruwali ri rahu ida. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Enime'ede Yesus nala roti kem wolima noro i'in kem woro'o onne, niliha'a laa wawan napanak trimkasi Makromod Lalap. Horu, An a'un roti nala kanile Nin man lernohi pakunohi enihe leke ha'ar heri ra'an. An uku i'in kem woro'o heri na'akeme ra'an haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ende heri na'akeme ra'an hehen nanumene pehur mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Horu ne, man lernohi pakunohi ra'ukwuku roti noro i'in ma narehi lunu idaweli woro'o penpenu. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lere onne aki mo'oni ma na'ak enihe mehe riwan wolima (maeke noro tatan'ukun kar aki makun). ");
INSERT INTO kjeNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hi ra'ak horu ne, An hopon Nin man lernohi pakunohi ha'a laa korkore hopol rolu laa leke Betsaida ma aile oir lapa wali. Enla An hopon heri onneni wali wali'ur laa rir lekloie. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hi rala'edi mene Yesus wakiha'a laa wo'or ida leke hi'i lir napanak Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Alamedi me'e, korkoro man lernohi pakunohi haha'ale aiyedi oir lapa toro me'e, la Yesus memehedi lolo ro makun. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","An po'onala hi kar wainnala korkoro me'e onno kahi anne nammori rehi kukuwala hi. Ende rakan noho roropeni, Yesus nala'ala'a lolo oir ulikne mai wakuraniyedi rir korkoro eni me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ai na'akeki lewenedi rir korkoro mene hir do'on Ai nala'ala'a lolo oir ulikne. Hir do'on ne, hi ramka'uk rehi ono hir pene'ek hir do'on maki hamarane. Ai ne'el hi, “Karkaramedi! E'eni Maya'u. Yono mamka'uk!” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","An ha'a laa korkoro wawan, ideweni kahi anne namlinedi. Hir polletilu ra'aheni, “E'eni inhoi pe?” ");
INSERT INTO kjeNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kade eni nanumene hir do'on Yesus nala roti tarana hi'i namwali nammori, maa hi ka rahinoroknala panaeku onne wake'e ono hi akin kerhe. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Rakanedi oir lap Galilea wali ne, hir pali lolo her Genasaret. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Paliyedi ne, hir kopur laa ro, la ri man aile lolo onne rahiyennaledi Yesus me'e, de ");
INSERT INTO kjeNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","hir lari laa leke-leke ma aile waliwali onnenihe wakau na'ahenia, “Yesus maiyedi me'e. Modi ma nakni'ir laa here!” Enime'ede hi rodi ma nakni'ir rala loile piki, rodi laa Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ende An laa ewi-ewi rin lernonohie, laa leke-leke, laa wo'or-wo'or, ri nodi ma nakni'ir mai pasar leke rapanak An hi'i wa'ane. Ende hi rapanak rehrehi lewlewen leke Yesus hurinohi ma nakni'ir enihe tukulala Nin rain eni, kade rain honon me'e wa'an. Enla man tukul rainne na'akeme wa'an mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ler ida ri Parisi enihe roro meser Horok Lape ida woro'o rano Yerusalem mai pakromo noro Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hir do'on Nina man lernohi pakunohi enihe kar lernohi agame Yahudi nina holoor halauk man hopon ri nawanedi liman, mene na'ak. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ri Parisi roro Yahudi namehin na'akeme rasala kerkerhe upun a'anhe rira noho honolla ma na'ono rawana liman mouwedi mene ra'ak. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Enla inhawa hir weli pasar hi radedem rodi oir wuriyedi mene ra'an. Onne kan mehe, maa hi rasala kerkerhe rira holoor halauk ma na'ono rawana ra'u noro ha man rodi hi'i ya'an yomun. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Enpenia ri Parisi roro meser Horok Lape enihe ra'ukani Yesus, “Alhi'ihepenia Numa man lernohi pakunohi kar lernohi ik upud a'ad rira holoor halauk de rawanedi liman mene ra'ake?” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Enine Yesus walhe na'ahenia, “Eih! Mi ri man kokme'e ramwali ri molololo mie! Nonolu eni Yesaya wakunu namlolo kokkoo, lere an wekel mi na'ahenia, ‘Makromod Lalap na'aheni heheni, Ri onnenihe horhawa Ya'u rodi lirna mehe, maa akinhe ko'u wake'e Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hirira honoi kanani Maya'u kan min haida, ono hir nair ri mormori nina holoor halauk mehe la ra'aheni onne Ainu'u, maa ka namlolo.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mim kemenedi Makromod Lalap Nina keneri hono'ok la masala kerkerhe ri mormori nina. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mi mauroin wawa'an ma'okul Makromod Lalap Nina keneri hono'ok leke mi masala ri mormori nina. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa loikaruwedi honopon me'e na'ahenia, ‘Horhawe mi inum ammu.’ Enla, ‘Inhoi warei yakyaka inna-aman, hukumesnedie.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Maa mim wakuku nahenia kan hi'i haida rin wakunu noro inna aman na'ahenia, ‘Yono ya ala haida paku mi leke mim mori wawa'an, maa lo'o wa'an rehi ya ala hahaa rodi paku mi onne, odi laa hoikani Makromod Lalap.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ende mi ma'okuledi la larlewenedi Makromod Lalap Nina keneri hono'ok me'e, leke masala kerkerhe mi upun a'anhe rira noho honolla. Onne kan mehe, maa mim hi'i yaksala namehin nammori haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Horu, Yesus napolu wali'ur heri rahu onneni na'ahenia, “Derne makaniyala leke mauroin Ainu'u panaeku eniyeni: ");
INSERT INTO kjeNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ha man laa ri raram kan hi'i rin morso, maa ha ma namhara nano ri akin penia hi'i rin morso.  ");
INSERT INTO kjeNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ende mi kilinum aile dernala.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","An wakuku horu ne, Ai noro Nina man lernohi pakunohi hoikaruwedi heri onne rala'a romleher me'e. Hi ra'ukanie, “Wanakunu naho'ok idedi eni nina panaeku inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Enine An walhe, “Alhi'ihepenia mi ka mauroin wanakunu onne makun? Hanana'an man ri na'an laa ri raram mehe, la kan hi'i rin morso. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hanana'an man laa ri raram onne penia kan laa ri akin, maa lolo ri konoin mene namhara mai paharne.” (Ende Yesus na'aheni hanana'an na'akeme wa'an, kan hi'i rin morso.) ");
INSERT INTO kjeNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Enine Yesus na'uwali wali'ur na'ahenia, “Ik honorok akin penia ma na'amo'ol na'ameru iknik mormori, ");
INSERT INTO kjeNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ono nano ri akin penia namhara panaeku yaka noro ha ma ka namlolo naise: lerpi'u lerwa'u, ramna'a, resne ri, ");
INSERT INTO kjeNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rakmanna ri nina hahaa, ka rauroin honoli, wukupoho ri, hi'i ha ma kan lolo ri honorok akin, kunu kehen ri, wakunu nano'onyak ri, holi kukulu lalapa, noro hi'i ha ma naploo naplakar. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Panaeku wo'ira ma namhara ri irhun raramne eni penia hi'i rin morso.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Horu, Yesus lolo Galilea laa onnida na'uranrani Tirus. An rakan nakar ida, Ai namhene ri nauroin nahenia An min lolo onne, maa Nina maimai onne ka nasinuwar, de ri nammori mai. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Maeke ida derne Yesus aile ne, an mai wali kemen yawa Yesus kalarna na'aheni, “Ya apanak Papa hi'i wa'an ya an'u maekana, ono hayakyaka hu'uhu'ur raramne.” Maeke onne ka namwali ri Yahudi, maa namhara leke Penisia, lolo noho Siria. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Enpenia Yesus na'aheni, “Ka nadedem rala tatan'ukun nin hanana'an sopol laa ahu, maa rala tatan'ukun ra'an nolu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","An walhe na'ahenia, “Kokkoo Makrom'u, maa ahu enihe peni ra'an tatan'ukun rir ha mo'o ma nadiyaur mei leherne haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Enime'ede Yesus na'aheni ai, “Onuma wanalhe ma'aruru, de mala'a wawa'anedi. Hayakyaka namharedi anum raram me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","An wali laa nakar po'onala ananne aile leu wawan namkuru karkaramedi la hayakyak onne kaale me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus namhara nano onno ma na'urani Tirus nala'a laa ra'i lolala kota Sidon mene wali wali'ur laa karanna lolo Dekapolis (leke Idaweli) mai oir lap Galilea. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","An rakan lolo onne, ri ida woro'o rodi mo'oni ida roho hakukuwedi mai rapanak Yesus loiyala liman leke wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Enime'ede Yesus ni'ik ri onne nahaledi heri eni. Hir memehedi nanumene nala liman ra'an loile ri onne kilinna ku'il woro'o enihe, mene saprui aparne liman ra'ane nodi patal ri onne namalle, ");
INSERT INTO kjeNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","la Yesus niliha'a laa wawan, warnedi enu, la na'aheni, “Epata”. Napa'ahne, ‘Mahinari here.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Idewe kilinna nahinariyedi, namal mamaledi, la an derne wakunu wawa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Enla Yesus nouwala hi na'akeme na'ahenia, “Yono konohi ri ha ma namwali eniyeni.” Yesus eren nonou hi, maa hir eren wakukunu laliwewer. ");
INSERT INTO kjeNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ende man derne na'akeme polletilu, ra'aheni, “Ainin hini'i wenewhe na'akeme ha wawa'an mamani. Man roho derne, man hakuku wakunu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nakawedi lere ida woro'edi ri nammori mai Yesus ho'o me'e. Maa, rira oir wa'aleher horu penia Yesus napolu Nina man lernohi pakunohi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ya'u raram penu heri eniyeni. Hir lernohi Ya'u lere wokelu me'e, la rira hanana'an horuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lo'o Ya'u hopon heri eni ramlarlara rala'a lo'o hir uma lolo kalla, ono heruwali ho'o ne holi ko'uwedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Man lernohi pakunohi ra'ahenia, “Meneni ika mai noho kili'urne, de lernala hanana'an ewi heri rahu eni ra'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus na'ukani, “Mi modi roti kem wo'ira?” Hir walhe, “Keme wo'ikku.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kame'ede Yesus hopon heri rahu onne raikoredi nanumene nala roti onneni napanak trimkasi Makromod Lalap. Horu An a'un roti nala kani Nin man lernohi pakunohi leke ha'are, na'akeme ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Enla hirira i'in kemana ida woro'o aile haenhi. Ai napanak trimkasi Makromod Lalap la kani Nina man lernohi pakunohi leke ha'are ho'o, de ");
INSERT INTO kjeNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","heri onne na'akeme ra'an pehur. Ra'ak horu, Nin ri enihe ra'ukwuku hanana'an rehin na'akeme lunu wo'ikku. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma na'ak mo'oni riwan wo'akka. Enla An hopon hi na'akeme wali laa nakar, ");
INSERT INTO kjeNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nanumene Ai noro Nina man lernohi pakunohi ha'a laa korkoro wawan hopol laa Dalmanuta. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ri Parisi ida woro'o mai leke rawalha lira noro Yesus. Hirira panaeku ken Ai de rapanak An hi'i tanadida nodi kunukunohi nahenia An mai nano a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus heheledi la na'aheni, “Alhi'ihepenia ri ku eniyeni rapanak ya'u hi'i ha ri kan dodo'onale? Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ka'u hi'i haida-haida ri eniyeni do'on.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Horu ne, Yesus hoikaruwedi heri onne, la ha'a laa korkoro wawan hopol laa oir lapa wali. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hir hopol ne, man lernohi pakunohi enihe hamlinuwedi rodi oir wa'aleher, la roti kem ida mehe aile korkoro wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus konohie na'ahenia, “Nakinemen ki mi! Herodes noro ri Parisi enihe rira wanakuku naise ragi rodi ralha'a taponne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Enpenia man lernohi pakunohi ida ma na'ukani ida ra'aheni, “Alhi'ihepenia An wakunu heheni? Lo'o An wakunu heheni ono ika hamlinuwedi kodi roti harome.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Enine Yesus nauroinnaledi rira wanakunu me'e, de Ai na'ukani hi, “Hi'ihepenia mawalha lira ma'aheni, ‘Ik hamlinuwedi kodi rotie?’ Ya'u hehel rehi! Alhi'ihepenia mi honorok akim makiyedi? ");
INSERT INTO kjeNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hi'ihepenia mi makum aile, maa mi kam do'on, mi kilinum aile, maa mi kam derne? Lo'o mim hamlinuwedi ha ma namwali ");
INSERT INTO kjeNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","lere Yo odi roti keme wolima ha'ar leke ri riwan wolima ra'ane? Emene rehin mim loiwuku lunu penpenu wo'ire?” Hir walha, “Lunu idaweli woro'o, Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus na'ukani hi wali'ur, “Lo'o mim hamlinuwedi lere Yo odi roti keme wo'ikku ala ri riwan wo'akka leke ra'ane? Emene rehin mim loiwuku lunu lapa wo'ira?” Hir walha ra'ahenia, “Lunu lapa wo'ikku, Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesus na'ukani hi wali'ur na'ahenia, “Hi'ihepenia mi ka mauroin makun?” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus noro Nina man lernohi pakunohi rakan Betsaida, ri nodi mo'oni ida man makan tokedi mai Yesus. Man makan toko onne napanak Ai, “Papee, ya apanak Papa rouwalle i mak'u leke hi'i wa'anedi ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Enine Yesus nasala liman nodi laa leke paharne mene An saprui ri onne makan. Horu kemenala liman ri onneni makan la na'ukani na'ahenia, “Om do'on haida me'e, kaunu?” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Enine ri onne po'onala Yesus na'aheni, “Ya'u do'on ri, maa kan mouropo makun. Ya'u po'on ri naise au'ono ma nala'ala'a.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Enime'ede Yesus nodi liman kemenala ri onne makan wali'ur. Idewe an do'on ha wo'ira na'akeme mouwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Horu Yesus hopon ai na'ahenia, “Wali laa nakar here! Yom lolo leke onne me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Enla Yesus noro Nina man lernohi pakunohi laa leke-leke man aile na'uranrani kota Kaisaria Pilipi. Rakan kalla toro ne, Ai na'ukanihe, “Ri na'aheni Ya'u eni inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hir walha, “Heruwali ra'aheni Yohanis ma nodi oir ulutade (man makiyedi me'eni), heruwali ra'aheni Elia, heruwali ra'aheni nabi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Horu ne, Ai na'ukani hi wali'ur, “Emene lernohi minim panaeku, Ya'u eni inhoi?” Petrus walhe, “Papa eni penia Kristus man Makromod Lalap kikan namwali Rai laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Enla Yesus hopon hi yono konohi ri Ai onne inhoi. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Onne horu Yesus wakukuwala Nina man lernohi pakunohi enihe na'ahenia, “Ya'u, ma namwali Ri Mormori Anan, lernala wewerek pananaka rahu. Enla Yahudi rir leleher lalapa, imam lalapa, roro meser Horok Lap enihe kar kokala Ya'u, de resnedi Ya'u. Enimaa rakan lere wokelu Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","An wakuku hi nodi wanakunu man mouropo. Enimaa Petrus ni'ik Yesus laa herne dadiyale na'ahenia, “Papa, yono wakunu heheni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Enine Yesus nadiwali po'onala man lernohi pakunohi enihe mene dadiyala Petrus na'ahenia, “Hayakyak Makromon o! Mala'edi here! Onuma panaeku onne ri mormori nine, Makromod Lalap, ka.” ");
INSERT INTO kjeNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kame'ede Yesus napolu Nina man lernohi pakunohi noro ri nammori man aile lolo onneni mai, leke wakuku hi na'ahenia, “Ri man raram nodi lernohi Ya'u, yon nodi nina raram nodi aimehi, maa na'uwara nina au kekiyowok la lernohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ya a'aheni eniyeni ono inhoi namka'uk ihin kemen maki, de namhene huri nin morimori lolo noho wawan eni, ai onne kan lernala or'ori dardari ma namlolo. Maa ri man huriyedi nin morimori lolo noho wawan eni leke lernohi Ya'u noro Makromod Lalap Lirna Wawa'an eni, ai onne lernala or'ori dardari ma namlolo ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lo'o ri ida manarna noho wawan nin ha wo'ira na'akeme, maa kan lernala or'ori dardari ma kan horu, nin panaeku onne kan min haida. ");
INSERT INTO kjeNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ai lo'o nala inhawe leke lernala or'ori dardari ma kan horu? ");
INSERT INTO kjeNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ri mormori lere alam eniyeni kar derne rakani Makromod Lalap Nina nounaku, maa hir derne rakani ri namehin la hi'i dohohala mamani. Horhorok! Inhoi nawawa Maya'u de namhene konohi ri man ailanna onne na'ahenia, ‘Ya'u lernohi Yesus noro Nina wanakuku eni,’ na'amoli Ya awawa nala ai haenhi. Lere Yo odi Ya Am'u Nina ke'eke'el an'anhe ma narehi nalewen oro hophopon a'am raram man moumou dewdewe kopur mai noho wawan, Ya awawa nala ai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Horu ne, Yesus na'aheni, “Horhorok Ainu'u nou ma na'ono eniyeni: Nano mi man min lolo eni heruwali kam maki makun, mim do'on mauroin hi'ihewi Makromod Lalap nodi molollo mai noho wawan eni noro idewe Nina ke'eke'el an'anhe.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Nakawedi lere woneme ne, Yesus, Petrus, Yakobus noro mo'oniwalla Yohanis ra'alono wakiha'a wo'or kukulu ida. Hir mehe min lolo onne. Hi ramririri ra'uranrani Yesus, idewe Yesus kemen namehiyedi la oin makan noro Nina rain siksika lerlere, la Nina rain wawarha narehiyedi ha wawarha na'akeme noho wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Horu ne, hi ramlilinnohi do'on Yesus wakunkunu noro Elia noro Musa. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Enine Petrus na'ukani Ai na'ahenia, “Hi'ihewi Pap Meser, ika min mai eni ma'aruru rehi, de lo'o wa'an rehi ai ma'ariri heuheu wokelu lolo eni, ida Makrom'u nine, ida Musa nine, la ida Elia nine.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus na'ukani heheni ono ai noro walin ramka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Enime'ede kakam ida mai pupinala hi, derne lira ida aile kakam raram na'ahenia, “E'eni Ya An'u, Ya amre'e Ya amharue, de mim derne makanie.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Horu, hir po'on waliwali kar do'on ri woro'o onne me'e, do'on Yesus mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hir kopkopur lolo wo'or laa yawa An nou hi na'ahenia, “Yom konohi ri inhawa man mim dodo'on lolo wo'or eni, hehen nanumene Ya'u ma namwali Ri Mormori Anan, maki la mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ende hir lernohi Yesus Nina nou eni, maa ida ma na'ukani ida na'ahenia, “Ainin panaeku inhawa na'aheni An maki, maa mori wali'ur?” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Enine hi ra'ukani Ai na'ahenia, “Alhi'ihepenia meser Horok Lape enihe ra'aheni Elia mai noho wawan nolu mene ri ma namwali Ri Mormori Anan maie?” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus walhe, “Hir wakunu namlolo, Elia nolu mai na'akene ha wo'ira namkene. Enimaa hi'ihehewi noro Ya'u ma namwali Ri Mormori Anan onne!? Yon hamlinu horhorok aile Horok Lape raram ma na'aheni rin hi'i apinpinha la ra'okul Ri Mormori Anan onne! ");
INSERT INTO kjeNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Enimaa Ya'u konohi mi, Elia maiyedi me'e, la hir lernohi rira suk hi'i apinpinha Elia naise Horok Lape Lirna na'aheniyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus noro wokelu enihe waliyedi nano wo'or rakan yawa ne, hir po'on ri nammori lupurala walinhe ma noro meser Horok Lape enihe rasesesi. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Heri onne do'onedi Yesus ne, hi rahumarnedi, la lar kokale. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Enine Yesus na'ukani man lernohi pakunohi na'ahenia, “Moro hi masesi inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ri ida aile heri onne walhe, “Papa Meser, yo odi ya an'u mai Papa ono hayakyaka huhu'urle raram de hakukuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lere hayakyak onne hu'ur raramne, nale wali yawa, ukum wukuwedi nihin wawan, aparne nawurwuri, idewe liman ein lapekiredi. Ende ya apanak Papa Nina man lernohi pakunohi enihe rohi hayakyaka man aile raramne, maa kar paekunale.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Enine Yesus na'aheni, “Heih! Mi ri ku eniyeni! Mi kam derne makani Ya'u la mi akim ka naili'il kokkoo. Yo oro mi nalo'oledi me'e, maa mi akim ka naili'il Ya'u wawa'an makun! Rakan ma'anana ho'o Ya'u kerhu oro mi mene mi akim naili'il kokkoo? Modi tatana onne mai.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ende hi rodi tatana onne lae ne, hayakyak onne do'on Yesus, an hi'i tatana onne liman ein lapekir, de laedi yawa, idewe napoitititie la aparne nawurwuri. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Enine Yesus na'ukani tatana aman na'ahenia, “Ma'ananahe me'e an hi'i heheni?” An walhe na'ahenia, “Nano tatana me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lere romromo hayakyak onne nahehe nesne de nodi la wakale aiye raram me oire rarame. Enpenia ya apanak Papa naramyakala ke'e. Yonde Papa paekunala haromo, hi'i wa'anedi ya an'u ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus walhe, “Alhi'ihepe O ma'aheni, ‘Yonde Ya'u paekunale haromo?’ Ha wo'ira namwali horo nahenia ri akin naili'il Makromod Lalap.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tatana onne aman wakau na'ahenia, “Makrom'u, ya akin naili'il Makromod Lalap, maa kekekiyana makun. Pakuwala'u leke ya akin naili'il wawa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus po'on ri nammori larlari maie ne, An komdere hayakyak onne na'ahenia, “Hayakyaka o! Mamharedi nano tatana eniyeni, la yom kene hu'ur raramne wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Enime'ede hayakyak onne wakau la hi'i orok ni'ini'ik wake'e mene namhara. Man aile lolo onne do'on tatana onne naise makiyedi me'e, de hi ra'aheni, “Aran horuwedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Enimaa Yesus roulle liman paku leke namriri. Enime'ede tatana onne namririyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus noro Nina man lernohi pakunohi enihe rakanedi nakar ne, ri ida na'ukani Ai na'ahenia, “Hi'ihepenia ai kam paekunala mohi hayakyak onne?” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","An walhe, “Mi kam paekunala ono hayakyaka naise onneni ka rodi haida-haida rohi, kokoko mim hi'i lir napanak nolu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus noro man lernohi pakunohi enihe ramharedi lolo onne ne, hir lolala Galilea rahaledi kemen leke yono ri nauroin hirira miminlole. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","An hi'i onne leke nounakuwala Nina man lernohi pakunohi enihe. An nou hi na'ahenia, “Ka nalo'ol me'e ri na'olu Ya'u ma namwali Ri Mormori Ananne, kanile ri mormori liman raram resne, maa alam wokelu Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Enimaa hi honorok akin ka nala Nina wanakunu eni, la ramka'uk ra'ukani Ai ono hi rawawa. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesus noro man lernohi pakunohi mai Kapernaum. Rakanedi nakar ne, Ai na'ukani hi, “Idedi mi masesi inhawa lolo kalla?” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Enimaa, hi ka ra'oho, ono idedi hi rasesi inhoi man kulu narehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Enine Yesus naikoro la napolu ri idaweli woro'o onnenihe mai na'ahenia, “Inhoi raram nodi namwali man kulu narehi, wa'an rehi namwali ri man lolo yawa la ri man lolo honopon heri na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Enla Yesus napanak tatanida mai namriri hi kalarna mene Ai naurukue. An konohi hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Inhoi kokala tatana naise eniyeni ono hir lernohi Ya'u, kokaledi Ya'u haenhi, la ai kan kokala Ya'u mehe, maa kokala Makromod Lalap man hopon Ya'u mai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Horu ne, Yohanis konohi Yesus na'ahenia, “Pap Meser, am do'on ri ida nohi hayakyaka nodi Papa naran, maa am kawale ono ri onne iknik ri, ka.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Enine Yesus walhe, “Yom kawale! Lo'o ri nodi I naran hi'i tanade man ri kan dodo'onnala makun, kan idewe wakunu warei yakyaka Maya'u, ");
INSERT INTO kjeNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ono inhoi kan ewek kawala ika, onne iknika muku. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi paku mi ono mim lernohi Ya'u man Makromod Lalap kikanedi namwali Rai, an kokala nina wanalhane, kade nala oir mi momun mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesus wakunu wali'ur na'ahenia, “Inhoi hi'i tatana ma akin naili'il Ya'u nadiyaur dohohale, wa'an rehi wairedi waku lapida kelenne, rodi laa auredi heleken. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Enla lo'o limmu hi'i o madiyaur dohohala, heruwedi, kalo'o o limmu woro'o enihe nodi o laa kawali pire ai porom raram. Wa'an rehi o limmu wali kaale, maa mori wewerre noro Makromod Lalap,  ");
INSERT INTO kjeNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ono lolo kawali pire ai porom onne aiye noro orre kan maki. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lo'o o eum hi'i o madiyaur dohohala, heruwedi! Kalo'o o eum woro'o enihe wakal o laa kawali pire ai porom raram. Wa'an rehi o eum wali kaale, maa mori wewerre noro Makromod Lalap,  ");
INSERT INTO kjeNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ono lolo kawali pire ai porom onne aiye noro orre kan maki. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Lo'o o makum hi'i o madiyaur dohohala, hiduwedi, kalo'o makum woro'o enihe wakal o laa kawali pire ai porom raram. Wa'an rehi o makum wali kaale, maa om laa onno man Makromod Lalap nodi molollo raram, ");
INSERT INTO kjeNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ono lolo kawali pire ai porom onne aiye noro orre kan maki. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rodi aiye ra'amou ra'adewe ri mormori na'akeme naise ri nala asir loile mahin leke yon yaka. ");
INSERT INTO kjeNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Asir penia wa'an, maa asir ma ka nam'arha me'e, rodi inhawa leke hi'i nam'arha wali'ur? Ende yon mi maise asir ma ka nam'arha de sopoledi me'e, maa wa'an rehi mi mamwali asir ma nam'arha leke mi ida man mori wawa'an noro ida.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Enla Yesus noro Nina man lernohi pakunohi ramhara Kapernaum laa leke-leke man aile noho Yudea noro leke-leke man aile oir wauwau Yordan wali. Hir lae ne, ri nammori mai lupurale, la An wakuku hi naise nadedem eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ri Parisi ida woro'o mai leke ken Ai ra'ukani, “Lo'o iknika agame nina holoor halauk hurilira mo'oni reiha'ar noro hono, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Enine Yesus walhale na'ahenia, “Musa nala inhawa keneri hono'ok ki mi?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hir walhe, “Musa hurinohi mo'oni namhenedi hono, horo nahenia hi'i horok reiha'ar nolu mene hopon hono nala'a.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Maa Yesus walhe, “Hi'ihepenia Musa hopon mi hi'i horok reiha'ar onneni? Musa hi'i holoor halauk eniyeni ono mi akim kerhe rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maa nano dedesneni, ‘Makromod Lalap umupaledi ri mormori, mo'oni noro maeke, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","penia mo'oni hoikaruwedi inna aman leke noro hono minwuku, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","9","de woro'ohe ramwali mahaku.’ Ende inhoi Makromod Lalap kali wukuwedi me'e, yono ri mahaku reiha'ar, ono hi ka ramwali woro'o, maa ramwaliyedi mahaku me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hir wali laa nakar ne, Nina man lernohi pakunohi ra'ukani panaeku eni wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Enine An konohi hi na'ahenia, “Inhoi namhene maekleher, lan ho noro maeke namehin, ai onne lerwa'uwedi me'e la hi'i yaksala nin maekleher dedesneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Enla lo'o maeke ida namhenedi nin mo'onleher, lan ho noro mo'oni namehin, an lerwa'uwedi me'e la hi'i yaksala nina mo'onleher dedesneni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ri nodi tatan'ukun mai Yesus leke An kemenala liman hi, maa man lernohi pakunohi enihe dadiyala hi. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Enimaa Yesus do'on rir hini'i eniyeni, na'ahan de na'aheni, “Hurinohi tatana onnenihe mai Maya'u! Yom kawala hi ono Makromod Lalap nodi molollo ri naise tatana eniyenihe. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi ma akin ka naili'il Makromod Lalap naise tataneni, kan laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","An wakunu horu, Ai naurukuwala tatana onnenihe, la kemenala liman tatana onnenihe dohodoho napanak Makromod Lalap nala Nina rere'e haharu la norle'ule'u norwaliwali hi. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus na'akene nala'a, mo'oni ida lari mai awikorno kalarne na'ukani, “Pap Meser man wa'an, ya'u hi'i inhawa leke lernala or'ori dardari ma kan horue?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Enine Yesus na'ukani ai, “Hi'ihepenia o ma'aheni Ya'u wa'anA'u? Ri mahaku kan wa'an! Makromod Lalap mehe man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O mauroinedi Makromod Lalap Nina keneri hono'ok ma na'anou na'anaku nahenia: Yono mesne ri, yon lerpi'u lerwa'u, yon mamna'a, la yon modi poho tumdesne ri lolo hono'ok kanail onno, yono paipudi ri namehin, la horhawa o inum, o ammu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ri onne walhe, “Pap Meser, keneri hono'ok onne na'akeme ya'u lernohiyedi nano tatana'u rakan lere eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus po'one raram penuwale me'e na'aheni, “Enimaa, ha ida o kam hi'i makun. Laa ma'olu onuma hahaa na'akeme, mala kupan ha'ar ri ma na'alehe haida-haida, mene mam lernohi Ya'u, leke om lernala kanaru ma aile a'am raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","An derne Yesus wakunu heheni, akin werek rehi, de nala'a me'e ono ai orkanaru wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Enla Yesus po'on waliwali konohi Nina man lernohi pakunohi enihe na'ahenia, “Sus wake'e orkanaru laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","An wakunu horu, man lernohi pakunohi polletilu. Enimaa Yesus wakunu wali'ur na'ahenia, “Ya an'u mie, sus wake'e rin laa onno man Makromod Lalap nodi molollo raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sus wake'e unta waku ida lolala wanaka ku'il, maa man sus narehi onne, orkanaru laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Enime'ede hir eren polletilu, ida ma na'ukani ida na'ahenia, “Lo'o hi'i heheni ne, inhoi lernala or'ori dardari ma kan horu onne?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus po'onalahe na'aheni, “Ri mormori kan paekunala hi'i ha onneni namwali, maa Makromod Lalap mehe paekunala hi'i ha wo'ira na'akeme namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Enine Petrus na'aheni, “Emene mayai hi'ihehewi ho'o? Am kemenedi ainim ha wo'ira na'akeme me'e leke lernohi Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus walhe, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ri man hoikaruwedi nina nakar, mo'oniwalla, narna, inna aman, anan, la nina kirna, leke lernohi Ya'u la derne nakani Makromod Lalap Lirna Wawa'an eni, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lere man mai ri onne lernala nakar, mo'oniwalla, narna, inna aman, anan, kirna riwriwan rahrahu. Enimaa an lernala wewerek pananaka haenhi. Enla rakan lere man mai eni, ri onne lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Enimaa ri nammori ma namwali man panulu lere eniyeni, lere man mai, ramwali ri man lolo yawa. Enla ri nammori man lolo yawa lere eniyeni, lere onne ramwali ri man panulu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus noro man lernohi pakunohi rala'ala'a laa Yerusalem, la Yesus noluwedi laa kalari tarana. Nin man lernohi pakunohi hehel Nin wanakunu idedi eni, la ri man lernohi nano kili'urn ramka'uk. Enine Yesus napolu Nina ri idaweli woro'o enihe maiwuku mene An konohi hi wali'ur lo'o inhawe namwali Ai kemen eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ai na'aheni, “Makaniyala! Lere eni ik kala'a mamani laa Yerusalem. Ik rakan enne, Ya'u ma namwali Ri Mormori Anane, rin na'olu, nala kanile imam-imam lalape roro meser Horok Lap enihe. Hir hukumesne Ya'u, la rala Ya'u kanile ri ma ka namwali Yahudi enihe, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","la hir ilnohi ralnohi Ya'u, saprui saworno Ya'u, riuk rerhe Ya'u, la resne Ya'u haenhi, maa rakan lere wokelu Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeus ananne Yakobus noro Yohanis, laa ra'urani Yesus ra'aheni, “Papa Meser, am mai Papa mapanak ke'e de malala haida mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Enine Yesus na'ukani hi, “Mi raram nodi ya ala inhawa ki mi?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hir walhe, “Rakan lere Papa nodi molollo lolo onno man kukulu lalape, ai raram nodi maikoro lolo Papa herne mariri la malanna.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Enimaa, Yesus walhe, “Mi mapanak, maa mi ka mauroin minim napanpanak onneni inhawa. Mi lo'o paekunala momun oir man meru nano cawan Yo omun eni, ee ka? Mim paekunala rin ulutada mi noro unulu tanada maki naise hir ulutada Ya'u, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hir walhe, “Am paekunala.” Enine An konohi hi na'ahenia, “Namlolo! Lo'o oreki mi momun oir man meru nano cawan Yo omun eni, la mim lernala apinpinha naise Ya'u haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","maa Ka odi molollo wekel inhoi naikoro Ya'u herne mariri malanna. Makromod Lalap mehen niliyedi ri man Ai raram nodi naikoro lolo onne, la na'akenedi rir onno me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Man lernohi pakunohi idaweli namehin derne Yakobus noro Yohanis rira napanak eni ne, hi ra'ahan. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ende Yesus napolu hi na'akeme maiwuku, nala wanakunu na'ahenia, “Mi mauroin hair-hair rir rai noro rir uluwakun lalapa ma ka nauroin Makromod Lalap enihe, rodi molollo kerne dalha ri mormoriyaneni, ");
INSERT INTO kjeNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","maa yom hi'i heheni. Inhoi raram nodi namwali man panulu lolo mi, ai namkene ilitolle mi. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Inhoi raram nodi namwali ma nolu, ai onne helkaki namdaru namwali hophopon wahwahan ri na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ya'u ma namwali Ri Mormori Anan penia ka'u mai leke rin ilitolle Maya'u, maa Ya'u mai leke ilitolle ri, la ala I kem'u resne leke huri we'er ri nammori nano rira dohohale.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus noro Nina man lernohi pakunohi roro heri ra'alono lolala kota Yeriko. Ramharedi ne, pakromonala mo'oni ida. Ai onne Timeus anan ma naran Bartimeus, makan tokedi la nadedem naikoro kalla arkan mehe napanpanak. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","An derne nano man lolo onnenihe Yesus manin Nazaret eni maiyedi me'e. An wakau na'ahenia, “Yesus, Daud upun anane, maramyakala'u ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Enimaa ri nammori dadiyale, hopon na'ahenia, “Karkaramedi!” Maa, ai namhene, wakaukau eren naruri na'ahenia, “Daud upun anane maramyakala'u ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Enime'ede Yesus derne namririyala, na'aheni, “Lam polu ri onne more mai.” Hir laa ra'aheni, “Papee, akim namranedi. Mamririyedi! Leher napolu o.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Idewe an ruriyedi nina raine nanaru eni wakaledi lolo onne, la nehu wawan nala'a laa Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","An lae ne, Yesus na'ukanie, “O raram nodi Ya'u hi'i inhawa ki o?” Ai na'aheni, “Pap Meser, ya apanak hi'i i mak'u wa'anedi ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Enine Yesus na'aheni, “Mala'a here! O akim naili'il Maya'u, de om wa'anedi me'e.” Idewe ai makan wa'anedi, de lernohi Yesus rala'a. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus noro Nina man lernohi pakunohi enihe ra'uraniyedi Yerusalem me'e. Na'akeki rakan leke Befage noro leke Betania ma aile wo'or Zaitun leren, An hopon Nin ri woro'o rolu ");
INSERT INTO kjeNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na'ahenia, “Mala'a laa leke man aile kalari onne. Rakanedi leke raram ne, keledei ida man ri ka naikorala makun na'inonorok aile lolo onne. We'ere, modi mai Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Enimaa lo'o ri lolo onne ra'uhoi mi na'ahenia, ‘Hi'ihepenia mim we'er keledei onne,’ konohi hi nahenia Makromod Nina panaeku tarana aile de nairale. Ka nalo'ol ai modi mai wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ende woro'ohe lar do'on keledei onne na'inonorok lolo nakar ida nin nika makan ai kalla arkanne. Hi mahar we'er ne, ");
INSERT INTO kjeNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ri ida woro'o ai lolo onne ra'ukanihe na'ahenia, “Mim hi'i inhawa, pe? Hi'ihepeni mima we'er keledei onne?” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Enine woro'ohe walha naise Yesus Nina noue, penia hir re'enohi woro'ohe rodi keledei rala'a. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ende hi rodi keledei onne laa rakan Yesus, la ruri rira rain nanaru rodi pakedi keledei ko'orne mene Yesus naikore. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Enla ri nammori ruri rira rain nanaru werre kalla wawan, la heruwali peku au hana lolo kirna rodi mai wakale kalla wawan leke horhawa Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Heri man lernohi nano kili'ur na'akeme wakaukau ra'aheni, “Hosana! Ka'uli kasa'a Makromod Lalap! Makromod Lalap namre'e namharu O man mai nodi Ai Oin Naran! ");
INSERT INTO kjeNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Na'amoli Makromod Lalap namre'e namharu O lere modi molollo naisa ika upud a'ad Daud nonolu eni. Mai ka'uli kasa'a Makromod Lalap man aile onno man kulu narehi eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Rakan kota Yerusalem ne, Yesus nala'a laa Makromod Lalap Nina Romleu Lape, lalaa mamai po'onala waliwali ha wo'ira man ai lolo onneni. Enimaa lere na'akeki helem me'e, de noro Nin ri idaweli woro'o enihe wali wali'ur laa leke Betania. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rakan nohoropo Yesus noro Nina man lernohi pakunohi ramhara Betania rala'a rakan kalla toro ne, Yesus namlaredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nano ko'u makun An po'on ara onida, kawin aile de, Ai lan na'inau ke'e lo'o woin aile, ka. Enimaa rakan ara ono, An po'on woin kaale, kawin mamani, ono kan rakan ara nina lere dipi woi makun. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Enine Yesus nakineri ara ono onne na'ahenia, “Nano lere eniyeni me'ede, ri ka na'an o dipin woin me'e.” Enla Nin man lernohi pakunohi enihe derderne Ai lirna keneri onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus rakanedi Yerusalem, An laa Makromod Lalap Nina Romleu Lape raram. Rakanedi Romleu onne nin nikoin, Ai nohi ri ma na'iwali lolo waliwali onnenihe. Enla Ai nawali mei rodi heherre kupan la nawali ma na'olu merpati rir awana na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","la An kawala ri nodi inhawa memehe mai lolo Makromod Lalap Nina Romleu Lapa nin nikoin. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Horu An konohi hi na'ahenia, “Makromod Lalap Lirna aile ma na'aheni, ‘Ainu'u Romleu Lapeni namwali onno rin lolo noho ulik rai wawan mai leke hi'i lir napanak, maa mim hi'i namwali ri ma namna'a hahaa nin sunuwar onno.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ende imam-imam lalap noro meser Horok Lap man aile lolo onnenihe dederne wanakunu onne ne, hi ranoin kalla resne Yesus. Maa hir mahini'i la ramka'uk Ai ono heri rahu eni derne Yesus Nina wanakukue de mehe nanana mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rakan lere helem Yesus noro man lernohi pakunohi ramhara Yerusalem wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Rakan oreki al'alam hir lolala ara ono onne, po'one, napro'uk wake'edi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Enime'ede Petrus horokale ha ma namwali oirawi eni, an konohi Yesus na'ahenia, “Papa Meser, kene po'onala ara ono man papa nakineneri onne, napro'ukedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus walhe, “Hi'i mi akim naili'il Makromod Lalap kokkoo! ");
INSERT INTO kjeNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi akin naili'il Makromod Lalap kokkoo nin molollo aile hopon wo'or ida na'ahenia, ‘Laedi kahi raram!’ Idewe panaeku onne namwali ki mi horo nahenia yono mi akim towor, maa mi akim naili'il kokkoo inhawa mim wakunu namwali. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ende Ya a'ori honorok mi nahenia lo'o mi mapanak haida nano Makromod Lalap, mim lernale, horo nahenia mi akim naili'il kokkoo Makromod Lalap, la mi mauroin kokkoo Ai nala ha onne ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Enla lo'o mim hi'i lir napanak Makromod Lalap, maa mi moro ri namehin ma'ahan, mala ampun ai, leke minim Ame man aile a'am raram nala ampun minim dohohale haenhi.  ");
INSERT INTO kjeNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lo'o mi ka mala ampun ri namehin man hi'i dohohale ki mi, minim Ame man aile a'am raram ka nala ampun minim dohohale haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus noro Nina man lernohi pakunohi rakan Yerusalem wali'ur ne, Ai nala'ala'a lolo nikoin man aile Makromod Lalap Nina Romleu Lapa onno. Enime'ede imam lalapa, meser Horok Lap noro Yahudi rir leleher lalapa lolo onnenihe mai ");
INSERT INTO kjeNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ra'ukanie, “Inhoi nala molollo ki O, penia mam hi'i ha eniyeni na'akeme?” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","An walhe, “Ya a'ukaniyala mi na'ukankani ida nanu, la lo'o paphe walha Ainu'u na'ukankani eni mene Ya'u walha paphe rir naukankani haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Enine Yesus na'ukani hi na'ahenia, “Yohanis ma nodi oir ulutade ri, nodi molollo nano inhoi, Makromod Lalap, ee ri mormori?” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kame'ede ida ma nawalha lira noro ida na'ahenia, “Ik ka'aheni nodi Makromod Lalap Nina molollo, enlo'o Ai na'ukani ika, ‘Alhi'ihepe mi akim ka naili'il Yohanis nina wanakunue?’ ");
INSERT INTO kjeNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Maa, lo'o ik ka'aheni Ai nodi molollo nano ri mormori. Lo'o ri nammori rawuhur maika ono hi rauroin Yohanis onneni namwali nabi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ende hir walhe, “Ai ka mauroin.” Yesus na'aheni, “Ka'u konohi mi inhoi nala molollo Maya'u hi'i ha eniyeni haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus nodi wanakunu naho'ok wakunu noro imam-imam, meser-meser agame roro Yahudi rir leleher lalap onnenihe na'ahenia, “Ri ida lan kaman anggur kirna ida. An takin laliweweredi kirna onneni, mene na'ir lo'o rodi ramha anggur woin, la na'ariri heuheu man kulu ida rodi radiyaka kirna. Horu, ai nala nin kirna onne man howok kirna ida woro'o sewe, la nala'a laa onno namehin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Rakan lere ra'ili radai nin kirna raramne, an hopon nina hophopon ida laa kokala nina hana'are. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Enimaa, man howok kirna onnenihe kele ri onne, nukure, hopon wali nalalaliyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Enime'ede orkirna hopon nin hophopon namehin laa wali'ur, maa man howok onnenihe riuk uluwakun, la warei yakyaka ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Orkirna hopon ri namehin laa wali'ur, maa hi resnedi ri onne. Kame'ede an hopon ri nammori laa, maa heruwali hir nukure, la heruwali hir resnedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Orkirna onne na'alehe ri hophopon me'e, kokoko ri ida mehe aile. Ri onne anan mo'oni mememen man ai naramyaka rehi. Kame'ede an hopon anan laa enne, ono nahinorok nahenia, ‘Lo'o Ya'u hopon ya an'u mememen laa, hir horhawe harome.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Enimaa man howok kirna enihe, ida ma ne'el ida na'ahenia, ‘Lo'o aman makiyedi, ri enie lo'o namwali orkirna. Mai ik kesnedi anan leke ika manarnedi kirna eniyeni.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ende hir kele ai, resnedi la sopoledi laa kirna paharne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesus na'ukani hi na'ahenia, “Lo'o orkirna derne ha ma namwali onneni, an hi'i inhawe? Memen an mai nesne mouwedi man howok kirna onneni mene nala ri namehin howok wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lo'o mim lesedi wanakunu ida lolo Horok Lape ma na'ahenia, ‘Waku man ma nayapi nakar sopoledi me'eni, Makromod Lalap hi'iyedi namwaliyedi waku na'a'ar ma na'ono. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Makromod Lalap hi'i onne namwali, la ik do'on ma'aruru la wa'an wake'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma nodi molollo Yahudi onnenihe rauroin Nina wanakunu naho'ok onneni nala hi kemenhe de ranoin kalla kele Ai, maa ramka'uk heri enihe de hoikaruwedi Yesus, rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka nalo'ol ma nodi molollo Yahudi onnenihe hopon ri Parisi ida woro'o roro Herodes nina ri ida woro'o haenhi rala'a laa Yesus ra'ukani leke kokwudi Ai ranoin Nina sale. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hir laa ra'aheni, “Pap Meser, ai mauroin Papa akin ma namdudu de wakuku panaeku ma namlolo mamani. Papa namkene mehe derne Makromod Lalap, ri mormori ka, la ka ma'ili maloho ri ono Om horhawa ma na'alehe haida-haida namnenehe noro orkanaru. Enla Papa wakuku hi'ihehewi Makromod Lalap nodi molollo ri mormori lernohi honorok panaeku ma namlolo. Ende lo'o Papa konohiyala ke'e, lernohi iknika agame nina holoor halauk, lo'o wa'an ik pair noho nin paipaire laa Roma nina rai lalap, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ika pair, ee yono me'e?” Enimaa Yesus nauroinedi hi onne man kokme'e, de An walhe na'ahenia, “Alhi'ihepenia mim ken kokwudi Ya'u? Modi Roma nin kupan pere waku ida mai I po'onale.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Enine hi rale kupan pere waku ida. Yesus na'ukani hi, “Inhoi oin makan la inhoi naran melle kupan eniyeni?” Hir walhe, “Kaisar.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ende Yesus na'aheni, “Inhawe man Kaisar nina, mala Kaisar, la inhawe man Makromod Lalap Nina, mala Makromod Lalap.” Hir derne Nina wanakunu eniyeni hir mehe nananedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lere onne me'ede, ri Saduki ida woro'o mai leke ra'ukani Yesus rir na'ukankani haenhi. Heri Saduki rira honorok panaeku ri man makiyedi kar mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Hi ra'aheni, “Pap Meser, nonolu Musa horokedi nounaku nahenia lo'o mo'oni ida ho, maa an maki na'alehe tatana, wa'an rehi mo'oniwalin ho wali'ur orno onneni leke lernala tatana nahinerre walla man maki eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wanakunu ida aile ma na'ahenia: Ri wo'ikku ra'umo'onwali, anulu ho, maki na'alehe ananne, ");
INSERT INTO kjeNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","de mo'oniwalla man lernohi anulu eni ho noro orno waluwalum eni, maki na'alehe ananne haenhi. Enla mo'oniwalla man lernohi eni ho noro orno waluwalum eni, maki na'alehe ananne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kame'ede mo'oni wo'ikku na'akeme ho noro maeke onneni, la maki mouwedi ra'alehe anane nanumene maeke onne maki haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ende rakan lere alam rin mori wali'ur, maeke onne namwali inhoi hono? Mo'oni wo'ikku na'akeme penia hoedi noro ai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Enine Yesus walhe, “Mim saledi me'e ono mi ka mauroin Makromod Lalap Lirna Wawan noro Nina ke'eke'el an'anhe. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rakan lere ri man makiyedi mori wali'ur, hir mori naise Makromod Lalap Nina hophopon a'am raram, de kar ho me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Enimaa mi ka mauroin panaeku ma na'ahenia, ‘ri man maki, mori wali'ur,’ ono lo'o mi kam lesala Musa nina horok man konohi inhawe namwali lolo au um'umu man lerlere onne? Horok onne lirna na'ahenia, ‘Makromod Lalap na'aheni Musa: Ya amwali Makromod Lalap man Abraham, Isak, noro Yakup ra'ul'uli rasa'asa'a rakan lere eniyeni.’ Ri man makiyedi ka ra'uli rasa'a Makromod Lalap, maa ri man morimori mehe man ra'uli rasa'e! ");
INSERT INTO kjeNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Makromod Lalap ka namwali ri man makiyedi nin Makromod Lalap, maa Ai namwali ri man mormori rir Makromod Lalap. Mim sala wake'edi me'e ono mi ka mauroin nahenia ri man maki mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Enime'ede meser Horok Lapida derderne Yesus noro Saduki enihe rawalha lira panaeku onne, la derne Yesus Nina wanalha man wa'an, de na'ukani Yesus na'ahenia, “Pap Meser, lolo Makromod Lalap Nina keneri hono'ok na'akeme, ewi penia ma na'ono narehi?” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Enine Yesus walhe, “Keneri hono'ok ma na'ono dedesne na'ahenia, ‘Israel ne'en raram, makaniyala! Makromod eniyeni, Makromod Lalap. Makromod eni mahaku mehe. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Modi mi honorok akin, mi irhun raramne noro minim ruri pe'el na'akeme maramyaka Makromod Lalap ma namwali Makrommu.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Keneri hono'ok rewro'o nina na'ahenia, ‘Maramyaka minim ri mormori wali naise maramyaka mi kemmu haenhi.’ Keneri hono'ok woro'o eniyenihe, ma na'ono narehi keneri hono'ok namehin.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Enine meser Horok Lape eni walhe, “Pap Meser wakunu namlolo kokkoo ma'aheni: Ik Makromod, Makromod Lalap ida mehe, Makromod Lalap namehin kaale. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Enla lo'o ri nodi honorok akin, irhun raramne noro rir ruri pe'el na'akeme raramyaka Makromod Lalap ma namwali hi Makromon, la lo'o hi raramyaka hirira ri mormori wali naise raramyaka hi kemen aimehi, hir hi'i ha ma na'ono wake'e. Panaeku onne penia ma na'ono narehi nano ri nasala kerkerhe keneri hono'ok man hopon harna honoi kanani nala Makromod Lalap noro ha namehin haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus derne meser Horok Lap onneni nodi nina woroin wakunu wa'an de Ai na'aheni, “Pap na'akeki namwali ri man Makromod Lalap nodi molollo me'e.” An wakunu horu ne, hi ramka'uk ra'ukani Yesus haida-haida me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus mahan wakuku lolo Makromod Lalap Nina Romleu Lape, Ai na'ukani hi na'ahenia, “Alhi'ihepenia meser Horok Lape enihe ra'aheni Mesias (Kristus) namwali Daud upun anan? ");
INSERT INTO kjeNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Enimaa nonolu eni Roh Kudus nodi molollo Daud penia wakunu na'ahenia, ‘Makromod Lalap ne'el i Makrom'u na'ahenia: Maikoro I her'u malanne hehen nanumene Ya'u hi'i Num arwali enihe lolo yawa ki O.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud mehe napolu Ai, ‘I Makrom'u,’ de hi'ihehewi namwali anan mememen?” Ri nammori lolo onne akinhe nahuwa'an wake'e derne Nina wanakunu eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Enla Yesus wakuku hi na'ahenia, “Madiyakyaka mi nano meser Horok Lap eniyenihe, ono hir suk nair rain nanaru lalaa mamai leke rin po'on de rauroin hi eni man panulu, la hir suk laa pasar raram leke rin horhawe. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hir laa Yahudi nina kerei raram ne, suk raikoro kalari, la lere hir laa yapi, suk raikoro mei uluwakun haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Enla hir wukupodo maeke waluwalum, leke rahoro rira nakar, la hir hi'i lir napanak nanaru rodi pupin aduwala rir poheni. Ri eniyenihe lernala hunukum man werek wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus naikorkoro nohi Romleu Lap nin honoi kanani onno. An po'on heri ma nala kupan loile honoi kanani onno raram. Orkanaru nammori mai rala kupan namansa loile honoi kanani onno eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rakan maeke walwalum ida ma na'alehe haida-haida mai nala kupan pere waku woro'o loile honoi kanani onno eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Enine Yesus napolu Nina man lernohi pakunohi na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni! Maeke walwalum ma na'alehe haida-haida onne loile kupan nammori narehiyedi ri orkanaru na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ono nina kupan nodi mori akilere na'akeme loile honoi kanani onno eni, maa ri namehin rala rira kanaru heruwali mehe loile.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus noro Nina man lernohi pakunohi enihe ramharedi Makromod Lalap Nina Rom Lapeni ne, Nina man lernohi pakunohi ida po'onala waliwali na'aheni, “Pap Meser, ken po'onala rom-rom eniyenihe ma'aruru wake'e. Hi rodi waku lalapa mamani hi'ie.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus walhe, “Namlolo, lere eniyeni om po'on ma'aruru, maa lere man mamai eni arwali mai de naiye'er mouwedi Romleu Lap onne nina waku danaran na'akeme de ida ma ka nadinara ida wawan me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Horu ne, Yesus noro Nina man lernohi pakunohi enihe rala'a laa wo'or Zaitun raikoro onnida ma nakpali Makromod Lalap Nina Romleu Lape onne. Enine Petrus, Yakobus, Yohanis noro Andreas rodi rira panaeku aimehi laa roro Yesus wakunu ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ken Papa konohi yai ke'e ma'anana ha eniyeni namwali? Enla am lernala inhawa tanade leke ai mauroin nina lere alam na'uraniyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Enine Yesus walhe na'ahenia, “Nakinemen ki mi, kalo'o rin paipudi mi. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ri nammori rodi I naran mai ra'aheni, ‘Ya'u eni Kristus!’ de hir paipudi ri nammori. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lo'o mim derne lira are noro lira anna ara lolo waliwali, maa yono mi mamka'uk ono panaeku rahu onne namwali. Yom pene'ek nahenia rakanedi noho nin lere alam man horu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Noho pa'i'ik rai pakakar lo'o ida ma na'ara noro ida, hair noro hair, la noho wawan lernala rururuwai noro roulara lolo ewi-ewi. Ha wo'ira eniyenihe hi'i noho wawan apinha rehi, naise maeke man apun la rakanedi nin lere alam de apinpinha wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ende nakinemen ki mi, ono na'amoli hir kele mi rodi laa makpali leleher lalapa lolo hono'ok kanail onno. Hir nukur mi lolo Yahudi rir kerei raram, la hi rodi mi laa hair-hair rir ma nodi molollo roro rai-rai ma nodi molollo kalarna, ono mim lernohi Ya'u. Lere onne me'ede, mim lernala leken loikaru I Lir'u hi kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ri nodi Makromod Lalap Lirna Wawa'an eni raderre radaul noho ulikne rai wawan nolu mene ha onne namwali. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Enla lo'o rin kele mi rodi la leleher lalapa ma nasala hono'ok kanail enihe leke ho'ok kail mi, yom mahini'i inhawa mim wakunu lere onne, maa loikaru inhawa wanakunu man Ya ala ki mi. Hi'i heheni leke inhawa mim loloi kakaru eni ka namwali minim wanakunu aimehi, maa Roh Kudus Nina. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ri mehen kuku sala mo'oniwalla penia ri nesne. Onne namwali papa noro ananne haenhi. Enla tatana lalapana kar derne rakani hi inna aman me'ede nakoke ri nesne. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ri na'akeme kar suk mi, ono mim lernohi Ya'u. Enimaa inhoi akin namkene naili'il Ya'u rakan nin lere man horue, an lernala or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lere man mai mim do'on ‘Ha Man Ailanna ma na'ihoru na'idaru Makromod Lalap mamani’ namririri onno man luli lolo Makromod Lalap Nina Romleu Lapa. Lere onneni inhoi aile Yudea lari mouwedi laa wo'or! (Ri man lese horok eniyeni loi honorok wawa'an wanakunu eni.) ");
INSERT INTO kjeNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri ma aile nakar wuwane kopur pelekleke, maa yon laa romleher nala haida. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri ma aile kirna yon wali laa nakar rala rir nainair. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Heih! Lere onne maeke ma nornoro raramne roro man anan huhuhu makun, apinpinha nore! ");
INSERT INTO kjeNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hi'i lir napanak leke panaeku onne yono nedile lere alam noho ma'urinrinna leke yono eren apinpinha. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lere onne, ri mormori lernala wewerek pananaka wake'e. Nano lere Makromod Lalap nakuku naleu noho wawan rakan lere eniyeni ri kan do'onala wewerek pananaka ma naise onneni makun, la ka namwali wali'ur naise onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lo'o Makromod Lalap ka na'adeul lere alam onneni, ri na'akeme lo'o maki mouwedi. Maa, Ai na'adeul lere alam onne leke ri man Makromod Lalap niliyedi me'e yono lernala wewerek pananaka nammori rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lere onne lo'o ri ne'el ki mi na'ahenia, ‘Po'onala, Kristus aile mai eni me'e,’ ee ‘Po'onale, aile lolo onne!’ Yono mim derne makani ri onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rin mai kokwudi mi ra'aheni hi ramwali Kristus, ee nabi namehin, maa ka namlolo. Hir hi'i tanada lewlewen noro ha man ri kan dodo'onnala makun haenhi leke kene paipudi ri nammori. Hir kene paipudi ri man Makromod Lalap niliyedi me'e haenhi, maa lo'o ka namwali. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ende loi honorok memen! Ya'u konohiyedi mi ha eniyenihe na'akeme nolu mene namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Rakan lere alam wewerek pananake man werek onne horu ne, lere kan hari, wollo kan ropo, ");
INSERT INTO kjeNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","la kaliyore nadiya'ur nahoho'ok la hahaa na'akeme man aile a'am narururu. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lere onneni rin do'on Ya'u, ma namwali Ri Mormori Ananne, mai lolo hulik poloi kakam palari. Lere onne Yo odi ke'eke'el an'anhe ma narehi nalewen, la rin po'on Ya'u siksika lerlere. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ya'u maie ne, Ya'u hopon Ainu'u hophopon a'am raram laa poluwuku Ainu'u ri man Makromod Lalap niliyedi enihe nano noho huhun wo'akka enihe, la nano noho ulla rakan a'am ki'ilne. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Loi honorok wawa'an panaeku ida nano ara ono: Rakan lere are napupul naweti lan moko, mi mauroin nahenia ka nalo'ol me'e ara ono onne woi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Namnenehe noro ara ono onne, lere mim do'on ha onneni namwali mi mauroinedi nahenia Ainu'u lere alam mai wali'ur wakuraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Horhorok Ainu'u nou ma na'ono eniyeni: Ha eniyeni na'akeme namwali mouwedi nolu mene kulere eniyeni maki horu. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A'am noro noho moluloin, maa I Lir'u eni kan molu laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ri mahaku ka nauroin ma'anana lere alam onneni namwali. Maya'u, hophopon a'am raram, la ri mormori na'akeme ka rauroin. Ya Am'u, Makromod Lalap, mehe nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ende madiyakyaka mi mamani, ono ka mauroin Ainu'u lere alam mai wali'ur noho wawan. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eni molmolo ri man hoikaru nina nakar nala'a kalla koko'u. An hopon nina hophopon radiyaka nina nakar eni. Enla an ha'aredi honowok hi dohodoho, la an nou ma nadiyaka nikenihe radiyaka wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ende madiyaka mi memen, ono ka mauroin ma'anana Ya'u ma namwali ornakar eni wali mai, lere helhelem, ee alam tortoro, ee noho roropo, ee al'alam wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yon hi'i de mamlilinnohi Ya'u mai holikuku mi mamkukuru makun. ");
INSERT INTO kjeNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enpenia Ya'u konohi mi noro ri na'akeme, ‘Madiyakyaka mi mamani.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Inworo'o mene rakan Lere Alam Lap Paska noro Lere Alam Ra'an Roti Ma Na'alehe Ragi. Enine imam-imam lalap noro meser Horok Lape onnenihe ranoin kalla ma nasinuwar kele Yesus, resne. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Enimaa ida ma ne'el ida, “Yono ik hi'i panaeku eniyeni iknik lere alam lalap, kalo'o nakoko man suk derne Yesus Nin wanakuku hi'i wowo'o ar'arra.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lere Yesus aile Betania An minle Simon nina nakar. Simon onne, ri napolu ‘Simon man ulik yak hi'ie’ ono nonolu eni an lernala apinha onne, maa ors eni wa'anedi me'e. Yesus nana'ak ne, maeke ida mai nodi wuru wala'ula'u man aile potol ma'aruru ida. Potol onne rodi waku marmer hi'ie. Wuru eni wella ai wawan wake'e. An hi'i yaki potol nurane mene halla wuru Yesus uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Enime'ede ri ida woro'o ai lolo onne ra'ahan maeke onneni, la ida ma ne'el ida, “Alhi'ihepenia wuru wala'ula'u onneni kolo nano'onyake? ");
INSERT INTO kjeNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wuru eniyeni ra'olu wella kupan pere rahu wokelu rehi. Wella onne namnenehe noro ri nina naiwe'el annida. Wa'an rehi kupan eni ha'arle ma na'alehe haida-haida.” Enla hi rodi lir apinha dadiyale. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Enimaa, Yesus na'aheni, “Na'amoli ke'e! Yom dadiyala maeke eniyeni! An hi'i ha man wa'an noro Ya'u menee. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Akilere mim holiwuku noro ma na'alehe haida-haida enihe. Ende ma'anana-ma'anana mi raram nodi paku hi, pakuwala ke'e, maa Ya'u eni ka oro mi nalo'ol. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Maeke eni hi'i ha man wa'an eni leke paku Ya'u, ai ka nauroin hi'i inhawa ikara. An hi'i ha eniyeni leke rakan Ainu'u lere alam I maki, Ya'u ihin kemen ra'akenedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Horhorok Ainu'u nou ma na'ono eniyeni: Lolo ewi-ewi Makromod Lalap Lirna Wawa'an raderre radaulle, maeke eni nina hini'i wenewhe onne loikaru haenhi de ri kan hamlinu ai.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kame'ede Yudas Iskariot ma namwali ri ida nano man lernohi pakunohi idaweli woro'o onnenihe laa imam lalap leke na'olu Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iman lalap onne raram nahuwa'an derne nina panaeku onneni, de hir noue nahenia rala kupan ai. Enpenia Yudas nanoin leken paharin leke kani Yesus hi liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Rakan Lere Alam Lalap ‘Ra'an Roti Ma Na'alehe Ragi’ nin lere dedesne (lere onne Alam Paska de ri Yahudi radedem resne pipdumana leke rodi hoikani Makromod). Yesus Nin man lernohi pakunohi ra'ukanie na'ahenia, “Pap raram nodi am laa ewi ma'akene Paska nina ya'an yomun leke Pap na'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Enine Yesus hopon man lernohi pakunohi ri woro'o na'ahenia, “Mala'a laa kota Yerusalem raram. Rakanedi ne, mim holikuku mo'oni ida ma na'uwarwara oir e'en de lernohie laa nakar an lalaeni. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma'aheni ornakar lolo onne na'ahenia, ‘Pap Meser na'ukani: Lo'o Yo oro Ainu'u man lernohi pakunohi enihe mo'on momun Paska lolo onno ewi?’ ");
INSERT INTO kjeNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Enlo'o ornakar onne kukul onno ma naphari ida ki mi aile danaran wawan man ai na'akenedi me'e, de miro laa ma'akene nana'an nonomun lolo onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ende woro'ohe rala'a. Hir rakan kote raram, do'on ha wo'ira na'akeme naise Yesus konohiyedi hi eni. Idewe hi ra'akene hanana'an Paska. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Horu ne hir wali laa Betania. Rakan lere helemedi Yesus noro Nina man lernohi pakunohi idaweli woro'o ra'alono laa nakar onneni. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hi raikoro maha ra'ak, Yesus na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Nano mi ma naikoro wuku mo'on momun eniyeni, ri ida aile ma na'olu Ya'u, kanile ri leke resnA'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hir derne Nin wanakunu onneni hi akinhe woiredi, la dohdoho ra'ukani Yesus ra'aheni, “Pape, lo'o maya'u, ka!?” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Enine An walhe na'ahenia, “Nano mi ri idaweli woro'o eniyenihe ri onne aile, la noro Maya'u remen roti wewerre lolo manuk raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ri Mormori Anan lo'o maki naise horhorok aile Horok Lapeni, maa ri man kani Ai laa arwali onne mayo'edi me'e. Wa'an rehi ri onne inna aman kar morie.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hi ra'ak larlari, Yesus nala roti kem ida, napanak trimkasi Makromod Lalap nanumene a'un, ha'arle Nina ri mememen enihe, na'aheni, “Kokala la mo'on, roti eniyeni Yi ihin kem'u.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Horu ne, Ai nala anggur cawan ida, napanak trimkasi nanumene nale hi romun, la na'akeme romun anggur onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ai na'aheni, “Anggur eniyeni Ya'u rarna man wui man kolo la ma na'ono nawinau Makromod Lalap Nin nou worworu man du'ul kali ri nammori roro Ai laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Horhorok Ainu'u nou ma na'ono eniyeni: Nano lere eni me'ede ka omun anggur eni hehen nanumene rakan lere Yo oro mi komun anggur worworu lolo Makromod Lalap Nina noho worworu.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kame'ede hi rahinara hanara ida, ra'uli rasa'a Makromod Lalap. Horu ne, hi rala'a laa wo'or Zaitun. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Enine Yesus konohi hi na'ahenia, “Ka nalo'ol mi na'akeme lari hoikaruwedi Maya'u me'e, ono horhorok aile Horok Lape ma na'ahenia, ‘Ye esne man huri onne, la nina pipdum ukun lariye'er rarari.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maa lere Makromod Lalap na'amori Ya'u wali'ur nano maki-maki eni, Yo oluwedi mi laa Galilea.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus na'aheni, “Lo'o hi na'akeme hoikaruwedi Pape, maa maya'u ka!” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Enla Yesus na'aheni, “Horhorok Ainu'u nou ma na'ono eniyeni: A'alam eni manu kan kokoroi rewro'o makun, o ma'aheniyedi ka mauroin Ya'u rewkelu me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Enimaa Petrus walha naruri na'ahenia, “Kade yo oro Papa maki wewerre, maa ya'u ka a'aheni ka auroin Papa!” Enla man lernohi pakunohi namehin enihe ra'aheni heheni haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hi rala'a laa onnida naran Getsemani. Rakanedi ne, Yesus hopon Nin man lernohi pakunohi na'ahenia, “Maikoro lolo eni, Ya'u laa enne hi'i lir napanak.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Enine Ai naka'uk Petrus, Yakobus noro mo'oniwalla Yohanis ra'alono laa. Hi rala'a ne, Yesus akin woir la sus rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Enime'ede An konohi wokeluhe na'ahenia, “Ya akin woir rehi naise I maki me'e, de mim min lolo eni la madiyakyaka.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Horu ne, Ai nala'a kalari tarana wali kemen yawa nahinononow hi'i lir napanak na'ahenia, “Lo'o wa'an rehi yono Ya a'uwara wewerek pananaka man mai eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Papa, Ya Am'u, peni paekunala hi'i ha wo'ira na'akeme de Ya apanak Papa leke yon Ya a'uware wewerek pananaka onneni. Enimaa yono hi'i lernohi Ainu'u honorok panaeku aimehi, maa lernohi Papa Nina honorok panaeku mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Horu An wali laa, Nin ri wokelu onne ramkukuru me'e. Enine Ai ne'el Petrus na'ahenia, “Simon, mamkukuru me'e? Kam kerhu madiyakala jam ida? ");
INSERT INTO kjeNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Madiyaka la hi'i lir napanak leke yono mi madiyaur kenene panatal! Mi honorok akin namrana lernohi Ya'u, maa mi ihin kemen ka naruri.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","An wali wali'ur lan hi'i lir napanak nodi panaeku mahaku eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Horu An wali wali'ur tolle wokeluhe ramkukuru ho'o me'e ono makanhe nasoi rehi. Ai na'ukani hi wali'ur, maa hi ka rauroin walha haida. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus wali wali'ur rewkelu nina eni, hi ramkukuru wali'ur. Ai na'ukani hi na'ahenia, “Mi mamkukuru makun? Wa'anedi me'e. Rakanedi Ainu'u lere alam me'e. Ya'u, ma namwali Ri Mormori Anan, rala kanile ri man hi'i dohohala liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mamakedi! Mai, kala'a here! Po'onala man koklira Maya'u mai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus wakunkunu makun, Yudas, ri ida nano Nin ri idaweli woro'o onne, noro ri nammori mai rodi ilak raa noro au deul. Imam-imam lalap roro Yahudi rira meser-meser Horok Lap roro rira leleher lalapa enihe hopon hir laa kele Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesus walin ma na'olu Ai onne, an kukunohiyedi heri onnenihe me'e na'ahenia, “Ya'u nair tanada eni de ri man ya'u masi onne, mim kele here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Enime'ede Yudas laa Yesus napolu, “Pap Meser,” nanumene masie. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Idewe ne, heri onne kele Yesus lawukuwedie. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Enimaa ri ida lolo onne lehu nin raa dara imam man kulu narehi nina hophopon ida kilinna me'ede kaprosuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ende Yesus ne'el heri onnenihe na'ahenia, “Enlo'o Ya'u eni ri man ailanna penia modi ilak raa noro au deul mam kele Ya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Akilere Ya'u wakuku mi lolo Makromod Lalap Nina Romleu Lapa raram, maa mi kam kelA'u. Enimaa eni na'akeme namwali leke na'akuku na'anokor inhawa man horokedi aile Horok Lape raram me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hir keledi Yesus ne, Nina man lernohi pakunohi lari moumouwedi, kokoko ma na'ikaka ida man lernohi lolo kili'ur, la ");
INSERT INTO kjeNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ri onne sawisawik homnono. Heri onne kene kele ");
INSERT INTO kjeNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","maa, ai nawe'ul la huriyedi nina homnono, de nadlewlewhe lari me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ende man kele Yesus rodi laa imam man kulu narehi nina rom. Laa enne, imam-imam lalap roro meser-meser Horok Lape roro Yahudi rir leleher lalap onnenihe mahanoro hopun pepen. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus lernohi hi nano ko'u. Rakan imam man kulu narehi eni nina nikoin, ai naikoro namrinnu ai noro ma nadiyaka enihe. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Imam lalap enihe roro Yahudi rir muku man ho'ok kail eni rahehe ranoin man kuku maka man wakunu ha man sala leke tumdesne Yesus la hukumesne, maa kar lernala. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ende polu ri nammori mai rala panaeku leke rodi kuku sala Yesus, ma rira panaeku eni ka namnehe. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Horu ne, ri ida woro'o man aile lolo onne ramriri rala wanakunu poho, tumdesne Yesus ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Am derne Ai na'ahenia, ‘Ya aye'er Makromod Lalap Nina Romleu Lape man ri mormori hi'i eniyeni, la lere wokelu Ya'u wanna worworu ri mormori kan hi'i.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enimaa rira wanakunue ida ma ka namnenehe noro ida. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Enime'ede imam man kulu narehi eni namriri hi kalarna na'ukani Yesus na'ahenia, “Man kuku maka eniyenihe wakunu tumdesne O. Alhi'ihepenia O kam walhe?” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Maa, Yesus ka na'oho. Ende imam onne na'ukani Yesus raram wali'ur, “Namlolo, O eniyeni Kristus, Makromod Lalap Ma Narehi Ma Nalewen Ananne?” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus walhe na'ahenia, “Ya'u eni Ai, la na'amoli mi na'akeme do'on Ya'u, ma namwali Ri Mormori Anan, aikoro Makromod Lalap Ma Nodi Molollo Narehi Ma Nalewen na'akeme herne malanna. Enla lere man mai mim do'on Ya'u mai wali'ur lolo hulik loiloi kakam larlarie!” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ideweni ne, imam man kulu narehi onne sirriki nina rain kemen la na'ahenia, “Yono kanoin man kuku maka namehin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ende minim panaeku hi'ihehewi? Mim dernedi Ai na'ihoru na'idaru Makromod Lalap me'e, de mala inhawa kenekrohu?” Hi rala kenekrohu ra'aheni, “An sale wake'e, de hukumesne here.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Enime'ede heruwali saprui saworno Ai, hir pasunedi oin makan mene hudi la pahar. Hi ra'aheni, “Heih, kene kukunohi yai inhoi man hudi pahar O.” Horue ne ma nadiyaka lolo onne riuk Ai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Hir maha ra'ukani Yesus romleher ne, Petrus aile nikoine. Enine maeke ida ma namwali man howok lolo imam man kulu narehi onne nina nakar mai do'on Petrus mahan namrinna aiye. Ai nahiyennale Petrus de na'aheni, “O penia nadedem moro Yesus ma nano Nazaret onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Maa Petrus nawali ekemale la na'aheni, “Ka auroin ri onne inhoi, ka auroin onuma panaeku inhawa.” Enime'ede Petrus nala'a lolo nika lapa makan, idewe manu kokoroiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka nalo'ol maeke onne do'on Petrus ho'o me'e. Enime'ede an konohi man min lolo onne na'ahenia, “Ri eni peni namwali man lernohi pakunohi ri man ai raram onne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petrus derne, maa ai nawali ekemale wali'ur. Kan mahala ne, ri man min lolo onne re'el Petrus na'ahenia, “Lo'o namlolo, o mamwali man lernohi hi haenhi ono onum wanakunu lirna mehe nodi kunukunohi nahenia o eni manin Galilea.” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Enine Petrus nahopo me'e, “Ka auroin ri mim wewekel onneni!” ");
INSERT INTO kjeNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Idewe manu kokoroi rewro'o nina. Enime'ede Petrus horoknala Yesus Nina wanakunu: “Manu kan kokoroi rewro'o nina makun, o ma'aheni ka mauroin Ya'u rewkelu me'e.” Idewe ai nahere maheruheru. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Noho kan ropo wawa'an makun, Yahudi rir imam lalap, leleher lalapa roro meser Horok Lap ma namwali Yahudi rira muku man ho'ok kail agame enihe rala kenekrohu resne Yesus. Raledi kenekrohu resne Yesus ne, hir wukuwedi Yesus rodi laa kanile Pilatus (Roma nina gubernur). ");
INSERT INTO kjeNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yesus rakanedi Pilatus kalarna ne, Pilatus na'ukanie, “O penia ma namwali Rai Yahudie?” An walha, “Namlolo, naisa ma'aheheni eni.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Enime'ede Yahudi rir imam lalap enihe loikaru kalaklaka nammori Ai kemen. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus na'ukanie wali'ur na'ahenia, “Hi'ihepenia ka ma'ohe. O mehe makani rira kalaklake nahenia Om hi'i yaksala nammori.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Maa Yesus kan walha wake'e, de Pilatus hehel rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nadedem rakan Yahudi nina Lere Alam Lalape Paska, Yahudi enihe nili ri ida man aile bui raram leke ma nodi molollo Roma huri nano nina hunukum. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Enla ri ida naran Barabas aile bui raram noro ri woro'o wokelu namehin ma namhene derne rakani Roma nina molollo me'e, de resnedi ri lolo rusrusu ar'arra. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ende ri nammori mai rapanak Pilatus ra'aheni, “Aki anna papa nadedem huri ri ida nano hunukum, de lo'o lere eni papa huri ri, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus na'ukani hi na'ahenia, “Minim suk ya'u huriyedi ri ma na'aheni Ai namwali Rai Yahudi eni?” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ai na'ukani onne ono nauroiroin imam lalap onnenihe kele Yesus rodi mai ono hi kehekehen Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Enimaa man panulu onnenihe rawa'u heri eni leke rapanak Pilatus huriyedi Barabas, maa Yesus ne, yono. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Enla Pilatus na'ukani hi, “Emene, mi raram nodi ya'u hi'i inhawa noro ri man wewekel Rai Yahudi eniyeni?” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Idewe ne hir wakau raruri ra'aheni, “Rodi laa wairesne au kekiyowok here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus na'ukani, “Alhi'ihepe? Nina inhawa sala pe?” Enimaa hir eren wakaukau raruri ra'aheni, “Wairesnedie lolo au kekiyowok here!” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus nin panaeku nahuwa'annala heri akinhe, de an huriyedi Barabas, maa hopon nin ma nasala ke'urauk enihe riuk rerhe Yesus horu mene kanile ke'urauk leke rodi laa roho waire lolo au kekiyowok me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Enime'ede ma nasala ke'urauk enihe rodi Yesus laa Pilatus nina rom rodi ho'ok kail raram mene rapolu rira ke'urauk na'akeme mai. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hir maie ne, rodi rai nin nainair nanaru man mere au'au leke Yesus nairi. Enla hir nanau dupal rururi ida nanumene rala loile Yesus uluwakun. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Onne horu, hir kokme'e rala honoor hanawe ra'aheni, “Hiyene arore ki O, Rai Yahudi O!” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hi rodi our deul ida taka uluwakun mamani, saprui saworno, la hir kadi ein korno yawa, kokme'e rahuwo'ok Ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hadwei hadwokor Yesus horu, hir herre wali'uredi rai nin nainair nanaru onne, la rala Nina nainair wali'ur. Horu ne, hi rodi laa kota paharne leke rohe, wairesne lolo au kekiyowok. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hir laa kota paharne, Yesus noro ma nasala ke'urauk onnenihe holikuku mo'oni ida man eninanu mai nano leke Kirene nala'a Yerusalem. Mo'oni onneni naran Simon, (Aleksander noro Rufus aman). Ma nasala ke'urauk rakerne ai na'uwara au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ende rodi Yesus la wo'or ida naranne Golgota, napa'ahne, ‘onno ma naisa uluwaku rurna.’ ");
INSERT INTO kjeNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Rakanedi ne, ke'urauk wa'aha anggur noro wuru awa'ar naran mur rale nomun leke yono kemen apinha rehi, maa Ai namhene nomune. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Horu, hir roho, waire lolo au kekiyowok. Horu ne, hir hi'i undi leke kukul inhoi lernala Yesus Nina nainaire. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Roho wair Yesus au kekiyowok eni ri'uk wohii orereki. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hir horok Yahudi rira kalaklake lolo au kekiyowok wawan na'ahenia: Eni ri Yahudi rir Rai. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lere onne hir roho wair ri woro'o man ailanna lolo au kekiyowok haenhi, ida man minle herne malanna la ida man minle herne mariri. Woro'ohe ramwali ri ma namna'a.  ");
INSERT INTO kjeNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Onneni na'akuku na'anokor Horok Lap Lirna ma na'ahenia, “Hi rahinorok Ai nornoro ri man ailanna.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ende heri man laa ki laa mai lolo onne po'one, rado'do'o uluwakun ilnohi ralnohi ra'aheni, “Eih! O peni ma'aheni maiye'er Makromod Lalap Nina Romleu Lape, la lere wokelu raram ma'ariri wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ende mehe mala kopur O kemmu nano au kekiyowok mai yawa ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Enla imam-imam lalap noro meser Horok Lap onnenihe ilnohi ralnohi naise hi, ida ma na'aheni ida, “Eih! Ai onne nauroin na'ohu nahala ri nammori nano rir apinpinha, maa alhi'ihepe kemen mememen ka nauroin na'ohu nahale? ");
INSERT INTO kjeNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ai penia na'aheni Ai namwali Kristus man Makromod Lalap kikanedi namwali Israel nin Rai laa ewi-ewi. Ende alhi'ihepe Ai kan kopur nano au kekiyowok eni leke ik po'one la ik akin naili'il Ai.” Enla ri woro'o man aile herne mariri malanna ilnohi ralnohi Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rakan lere ulu noho onne na'akeme na'umetekedi hehen nanumene riuk wokelu lere mamamal. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Rakanedi lere mamamal eni ne, An wakau naruri na'ahenia, “Eloi, Eloi, lama sabaktani?” Napa'ahne: “Makrom'u Lalap, Makrom'u Lalap! Alhi'ihepe hoikaruwedi Ya'ue?” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ri man aile lolo onne dederne lirna onne ne heruwali ra'aheni, “Makaniyala! Ai maha napolu Elia.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Enime'ede ri ida larlari, nala sawar koun anggur ma'alinu mene naloile au ko'oko'ol ida honon, kani laa Yesus nuranne. Enimaa ri ida na'aheni, “Ika lapanala ke'e. Yon hi'i de taikarala Elia mai nalkopur Ai nano au kekiyowok eni harome.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Enine Yesus wakau naruri, la aran horuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Idewe tapi rodi kawkawa Makromod Lalap Nina Romleu Lap raram eni nahinarukedi nano wawan idewe laa yawa namwali woro'o me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Enine ke'urauk ida ma namwali uluwakun ke'urauk rahu ida ma namriri Yesus kalarne po'on hi'ihewi Yesus aran horuwedi, ai na'aheni, “Namlolo kokkoo, ri eniyeni Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Lolo onne maeke nammori aile mahar popo'on nano ko'uko'u. Maria Magdalena, Salome, noro Maria (ma namwali Yoses noro mo'oniwalla karuri Yakobus inna) aile maeke onnenihe raramne. Maeke onnenihe radedem lernohi Yesus lolo Galilea la ramwali man ilitolle Ai. Hi roro maeke nammori ra'alono roro Yesus laa kota Yerusalem de ramriri ko'uko'u po'one. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Lere onne ri Yahudi rira Alam Ra'akekene hanana'an ono oreki Alam Renren Warwarna, la lere na'ikeki helem me'e, de na'uraniyedi Alam Renren Warwarna me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Enpenia Yusup man holi leke Arimatea mai leke na'akene manaku Yesus ihin kemen. Ai onneni naikorole agame Yahudi nina muku man ho'ok kail, de ri nahiyene arore, la an weilapan lere alam Makromod Lalap nodi molollo haenhi. Ai mehe na'alapa akin leke ka namka'uk nakpali Pilatus napanak nala kopur Yesus ihin kemen nano au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ai napanakedi ne, Pilatus hehel rehi derne nahenia Yesus lo'o makiyedi me'e. Enime'ede ai napolu nina uluwakun ma nasala ke'urauk ri rahu ida onne na'ukanie, “Yesus makiyedi me'e kokkoo, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Uluwakun onne konohi Pilatus na'ahenia, “Namlolo kokkoo, pape. Aran horuwedi me'e.” Kame'ede Pilatus ne'enohi Yusup nala kopur Yesus ihin kemen nano au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Enime'ede ai lan weli tapi lenan mene nala kopur Yesus kemen. Enine ai nodi tapi onne komon Yesus ihin kemen, nodi la wo'or leren karule ku'il ida ma namwali lunne. Karu horue ne, an poi waku lapa ida nodi elekedi ku'il nina nika. ");
INSERT INTO kjeNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena noro Maria, Yoses inna do'odo'on hi rala Yesus loile lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ende lewenedi Alam Renren Warwarna, lere helemedi, mene Maria Magdalena, noro Yakobus inna Maria, noro Salome ra'alono laa weli wuru wala'ula'u noro rampa-rampa leke rodi laa ra'akene manaku Yesus ihin kemen. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Rakan domeku al'alam, lere ha'edi, hi rodi wuru noro rampa-rampeni rala'a Nin ku'il me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rakan kalla toro, hi ida ma ne'el ida, “Ika rakanedi, inhoi paku ika poi waku rodi el'elek ku'il nina nike?” ");
INSERT INTO kjeNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hir rakanedi ku'il ne, do'on waku onne napoiyedi me'e de polletilu ono waku onne lape rehi. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ende hir laa ku'il raram, do'on ma na'ikaka ida rain wawarhe sorsorue naikokoro aile ku'il herne malanna, idewe hi ramka'ukedi. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mo'oni onne konohi hi na'ahenia, “Yon mamka'uk, ya auroiroin mi manoin Yesus ri Nazaret man wairesnedi lolo au kekiyowok onne, maa An mori wali'uredi me'e. Po'onala, hir karu lolo eni, maa kaale me'e. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lere eni me'e de, lam kukunohi Petrus noro Nin man lernohi pakunohi namehin na'ahenia, ‘Yesus noluwedi mi laa Galilea me'e, de mala'a enne leke mim do'on Ai naise Ai na'aheniyedi ki mi me'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Enime'ede hi rahumarna ramka'ukesne me'e. Hi ramhara ku'il idewe lari nano lolo onne ono ramka'uk de kar wakunu haida-haida noro ri.  ");
INSERT INTO kjeNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lere Yesus mori wali'ur, domeku al'alam wake'e, An pakromo dedesne noro Maria nano Magdala. Lere man laedi Yesus nohi hayakyaka wo'ikku nano Maria raramne. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Idewe ai lan konohi ri man lernohi Yesus man mahar sus mak oir enihe na'ahenia, “Yesus mori wali'uredi me'e. Idedi eni yo oro Ai pakromo.” ");
INSERT INTO kjeNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maa hi kar derne rakani ai. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Horu ne mo'oni woro'o ma nadedem derne Yesus Nin wanakuku, wali rano Yerusalem laa rira leke (Emaus). Rakan kalla toro hir pakromo roro Yesus de ra'alono rala'a. Hi kar pelek rahiyennale ono oin makan namehiyedi me'e, maa Yesus nalhari kemen hi. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kame'ede hir wali wali'ur la Yerusalem konohi rir mukue ha ma namwali nahenia hi roro Yesus pakromo, maa rira mukue kar derne rakani hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lere li'ur ri idaweli ida man lernohi pakunohi maha rara'ak, ramlilinnohi Yesus mai nalhari kemen hi la na'ukani, “Alhi'ihepenia mi akim ho'o ne na'akekeme la mi uluwakum kerhe rehi, penia mi mamhene derne makani ri man do'on Ya'u ra'aheni Ya'u mori wali'uredi me'e?” ");
INSERT INTO kjeNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Horu ne, Yesus hopon na'ahenia, “Mi mala'a noho wawan la maderre madaul Makromod Lalap Lirna Wawa'an eni ri mormori na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inhoi ma akin naili'il Ya'u la napanak ri nodi oir ulutade, ai penia nahinuriyedi nano nina hunukum makmaki, maa inhoi akin ka naili'il Ya'u lernala hunukum makmaki laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri ma akin naili'il onne paekunala hi'i tanada naise: rodi I naran rohi hayakyaka, rauroin wanakunu man worworu, ");
INSERT INTO kjeNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","la lo'o rasala haimoke, ee romun awa'ar man merumeru, maa kar maki, la kemenala liman ma nakni'ir, idewe wa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Makromod Yesus wakunu noro man lernohi pakunohi enihe horu ne, Ai nakinikan laa a'am raram, laa enne naikoro Makromod Lalap herne malanna leke rodi molollo wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Enime'ede man lernohi pakunohi enihe laliwewer noho wawan loikaru Makromod Lalap Lirna Wawa'an eni, la Makromod norle'ule'u norwaliwali hi. Ai nala ke'eke'el an'anha hi rodi hi'i tanada nammori leke nodi kunukunohi nahenia Lirna Wawa'an eniyeni namlolo kokkoo.");
INSERT INTO kjeNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","I wal'u Teopilus man rin horhawe! Ri nammori ken hi'iyedi horok ma na'ono Yesus Nin panaeku wo'ira ma namwaliyedi lolo mayai herne kalarna nonolu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Lolo rir horok onne hi rodi panaeku man am dernedi nano ri man mehe rodi oin makan do'on Yesus Nin morimori. Ri man meher do'on Yesus Nin morimori onnenihe penia do'on Nin hini'i wenewhe na'akeme la hi me'ene ramwaliyedi ma nodi Ai Lirna Wawa'an eni loikaru ri namehin haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ya'u mehe a'inauwedi wawa'an panaeku wo'ira na'akeme onne nano lere dedesne me'e de ya aledi kenekrohu nahenia wa'an rehi ya'u kakar panaeku wo'ira wawa'an lolo horok ida aku ki makrom'u, Teopilus. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya'u hi'i heheni leke makrom'u nauroin inhawe man rin wakukuwedi makrom'u me'e, onneni namwali panaeku ma namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lere Herodes namwali rai lolo Yudea, imam ida aile naran Zakaria. An howok wewerre noro imam-imam rira muku ida rapolu muku Abia. Hono naran Elisabet, la ai namwali Harun upun anan haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hirira morimori namlololo Makromod Lalap kalarna ono woro'ohe derne rakani Nin keneri hono'ok noro Nin holoor halauk na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Maa woro'ohe ka ra'ori tatana ono Elisabet tatane kaale raramne, la hi ra'ileheredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ler ida, Zakaria nina muku enihe rira lere alam ilitolle Makromod Lalap Nin honowok de ai mahan ilitolle Nin honowok lolo Makromod Lalap Nin Romleu Lape. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lere onne imam man howok onnenihe radedem hi'i undi leke nili inhoi man laa onno man moumou dewdewe lolo Makromod Lalap Nin Romleu Lape raram harna honoi kanani man wala'ula'u. Hi'iyedi undi horu, Zakaria lernale. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ende an laedi raram mahan harna honoi kanani onne, la lolo paharne ri nammori mahar hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Enime'ede Zakaria onne, namlilinnohi Makromod Lalap Nin hophopon a'am raram ida nalhari kemen ai. Hophopon onne namriri lolo honoi kanani onno rodi haharna au hairne wala'ula'u herne malanna. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria do'onedi hophopon onneni ne, ai nahumarnedi la namka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Enimaa hophopon a'am raram onne ne'el Zakaria na'ahenia, “Yono mamkauk! Makromod Lalap dernedi numa lir napanak me'e. Na'amoli o houm Elisabet moriyana tatana mo'oni ida, la om waki naran Yohanis. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na'amoli an hi'i mi akim nahuwa'an wake'e, la lere mori ai, ri nammori akinhe nahuwa'an haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ono ai namwali ri lalapa lolo Makromod kalarna. Yon ai nomun anggur me arak, la nano nin lere momori me'ede Roh Kudus na'aromromo irhun raramne. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Enla lere Israel upun ananhe derne ai lirna, hi nammori wali wali'ur mai hi Makromon, Makromod Lalap! ");
INSERT INTO kjeNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ainin molollo namnenehe nabi Elia la Roh Kudus nala molollo ai naise nonolu nala Elia haenhi. Ende ai noluwedi Makromod hari kalla leke ri Israel akinhe ramkenedi lere Makromod mai eni. An hi'i ri leleher roro tatan'ukun ramwali mahaku. Enla ri ma kan derne rakani Makromod enihe, an wakuku hi leke rauroin derne rakani Makromod la ramwali ri molololo Makromod Lalap kalarna. An hi'i panaeku eni na'akeme leke hi'i ri mormori akinhe ramkene kokala Makromod.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria na'ukani hophopon a'am raram onne na'ahenia, “Hi'i hehewi ya auroin num wanakunu eni namlolo? Ya'u eni a'ileheredi me'e, la ainu'u maekleher na'ileheredi me'e haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Enime'ede hophopon onne na'ahenia, “Ya'u eni Gabriel, Makromod Lalap Nin hophopon wahwahan ma namriri Ai leken kalarna. Ai penia hopon yo odi lira wawa'an eni mai loikaru ki o. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Horhorok! Rakan nin lere alam, ainu'u wanakunu eni na'akeme namwali kokkoo. Maa o eni kam derne makani ainu'u wanakunu eni, de om hakukuwedi hehen nanumene ainu'u wanakunu eni namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zakaria aile Makromod Lalap Nin Romleu Lape raram makun ne, ri nammori mahar lalapan ai namhara mai paharne. Hir mehe kakaiyedi ono ai nalo'oledi Romleu raram onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Enla an maiyedi paharne ne, ai kan wakunu haida ono ka nauroin wakunu me'e. Hir do'on ai nodi liman mehe herre wanakunu mene hi rauroin ai lo'o mehen do'onedi haida lolo Makromod Lalap Nin Romleu Lape raram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ainin lere alam howok lolo Romleu Lape horuwedi ne, an wali laa nin nakar me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ka nalo'ol ne, hono Elisabet ap'apun me'e, la ka namhara nin nakar wollo wolima raramne. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ai na'aheni, “Eni mene Makromod kukule akin man wa'an paku maya'u. Ende ka awawa lolo heri kalarna me'e ono Ai nala tatana ya'u moriyane.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lere Elisabet nornoro raramne wollo woneme ne, Makromod Lalap hopon Nin hophopon a'am raram ma naran Gabriel nala'a noho Galilea lolo kota Nazaret ");
INSERT INTO kjeNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pakromo noro maeke ida naran Maria. Ai noro Yusup rira honorok aki namnehe na'alonedi me'e leke woro'ohe ho, maa lere onne ka ramkuru wuku makun. Yusup onne rai Daud upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hophopon a'am raram onne ne'el Maria na'ahenia, “Heih, Maria! Akim nahuwa'anedi ono Makromod namre'e namharu o rehi, Ai norle'ule'u norwaliwali o mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria derne hophopon onne lirna, idewe an polletilu la namka'uk de lolo akin na'aheni, “Lira eni nina panaeku inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Enimaa hophopon onne na'aheni, “Maria, yono mamkauk! Makromod Lalap naledi kenekrohu nala rere'e haharu man lap la ma'aruru wake'e ki o. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka nalo'ol mormoro o raram me'e, la tatana ma namwali lolo o ihin kemen onne mo'oniyane. Na'amoli waki tatana onne naran Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ai onne namwali ri lalapa la rin wekel Makromod Lalap Man Kulu Narehi Man Lap Narehi Ananne, la Makromod Lalap mehe kikan Ai namwali Rai naise upun a'an rai Daud. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Enla Ai nodi molollo Israel upun ananhe rakan laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria na'ukani hophopon a'am raram onne na'ahenia, “Hi'ihehewi ha eniyenihe namwali? Ya'u ka oro mo'oni amkuruwala makun.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","An walhe, “Na'amolia Makromod Lalap huri wali Nina Roh mai ki o. Makromod Lalap Man Kulu Narehi Man Lap Narehi Nin ke'eke'el an'anha norle'ule'u norwaliwali o de anum man om momori onne moumou dewdewe la rin wekel Ai onne Makromod Lalap Anan. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","O mehem po'on we'ekwallum Elisabet, kade ai onne na'ileheredi me'e la ri na'aheni tatane kaale raramne me'e ne, ors eni nornoro raramne wollo woneme me'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ono Makromod Lalap mehe nauroin hi'i ha wo'ira na'akeme namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria na'aheni, “Ya amkene hi'i lernohi Makromod Lalap Nina honorok aki! Inhawe man Makromod na'aheni onne ya amkene kokale lolo i kem'u ono ya amwali Nina hophopon.” Enime'ede hophopon a'am raram onne nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka nalo'ol ne, Maria na'akenedi nin hahaa la idewe nala'a laa leke ida ma aile Yudea nin wo'or. Lolo onne wo'or mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Rakanedi enne ne, ai nala'a laa Zakaria nin nakar, napoluwala la nala hiyene arore Elisabet. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet dernedi Maria lirna ne, tatana man minle konoin raram nawolwollo wake'e, la Roh Kudus na'aromromo lolo Elisabet raramne. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Enime'ede Elisabet wakau naruri na'ahenia, “O penia Makromod Lalap namre'e namharu o narehi maeke rahu na'akeme, la Ai namre'e namharu tatana man aile o raramne! ");
INSERT INTO kjeNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maya'u eni inhoi penia Makrom'u inna mam ka'ara'ue? ");
INSERT INTO kjeNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ya auroin Makrom'u aile o raramne ono ya'u derne num napolpolu idediyeni ne, idewe tatana man minle i kono'u raram nawolwollo wake'e ono ai akin nahuwa'an rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Om lernala rere'e haharu man lapa ono o akim naili'iledi nahenia Makromod lo'o hi'i inhawa An konohiyedi me'eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Enla Maria na'uli nasa'a Makromod Lalap na'ahenia, “Yo odi i honorok akin penpenu kemkeme a'uli asa'a i Makrom'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ya akin nahuwa'an wake'e ono Makromod Lalap huri we'er ya'u nano ainu'u dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ai penia kan hamlinu ya'u ma namwali Nin hophopon wahwahan man lolo yawa eni. Nano lere eniyeni ri na'akeme ra'aheni ya amwali maeke man Makromod Lalap namre'e namharu narehi, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ono Makromod Lalap Ma Nodi Molollo Ma Narehi Na'akeme hi'iyedi panaeku man ma'aruru maya'u. Ai Oin Naran penia nahineiredi nano naran namehin na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ku herre ku An kukul aki man wa'an ri ma namka'uk Ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ai nodi Nin ke'eke'el an'anha hi'i hini'i man lewlewen. An reiye'er kope'eredi ri man holi kukulu lalap, leke rir panaeku yon namwali. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ai nalkopuredi rai-rai nano rir kadere de ka rodi molollo me'e, maa An kikan ri ma kan holi kukulu lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ai nala hanana'an man wa'an na'apehur ri ma namlara, maa An hopon ri orkanaru enihe rala'a ra'alehe haida-haida. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","An kukul aki man wa'an maika, Israel upun ananhe ma namwali Nin hophopon wahwahan enihe. An paku ika naisa An nouwedi ik upud a'ad nonolu eni. Ai kan hamlinu Nin nou man An hi'iyedi noro Abraham noro upun ananhe laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria nin ul'uli sasa'e horu an minle noro Elisabet wollo wokelu mene wali laa nina nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Rakanedi Elisabet nina lere alam moriyana, an mori mo'oniyanida. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nin nakar wali noro lodon walinhe dernedi hi'ihehewi Makromod Lalap kukul Nin aki man wa'an wake'e Elisabet me'e, de roro ai akinhe nahuwa'an wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tatana onne nina alam wo'aedi ne, nin nakar wali roro lodon walinhe mai leke sunate, la ai lodon walinhe rir panaeku waki tatana onne naran lernohi aman naran Zakaria. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Enimaa inna namhene la na'aheni, “Yono! Am waki naran Yohanis!” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hi re'el ai na'ahenia, “Hi'ihepe? O upun a'anhe kar wawa naran eni menee!” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Enime'ede hi rodi liman herre wanakunu ra'ukani Zakaria na'ahenia, “Tatane waki naran inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kame'ede Zakaria nodi liman herre wanakunu napanak waku man rodi hi'i horok leke an horok tatana naran. An horok na'ahenia, “Ai naran Yohanis.” Hi na'akeme mehe nananedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lere onne me'ede Zakaria nauroin wakunu wali'uredi la na'uli nasa'a Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rir nakar wali na'akeme ramka'uk rehi, la panaeku onne naderre nadaul lolo ri man minle Yudea nin wo'or-wo'or na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ri man derne panaeku onne na'akeme roro akin wakunu na'ahenia, “Tataneni lo'o namwali inhawa?” ono hir do'on rauroinedi Makromod norle'ule'u norwaliwali ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Enime'ede Roh Kudus nodi molollo Yohanis aman Zakaria de an wakunu inhawa ma namwali lere man mai. Ai na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mai ka'uli kasa'a Makromod, Israel nina Makromod Lalap, ono An mai leke huri we'er Nin ri nano rir dohohala nin hunukum makmaki. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ai nala Ri lewlewen ida mai huri we'er ika nano iknik dohohala nin molollo. Ai onne, Makromod Lalap Nin hophopon wahwahan Daud upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Panaeku ma namwali eni naise inhawa man nonolu eni Makromod nouwedi lolo Nin nabi mememen enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ai nala Ri man lewlewen onne mai huri we'er ika nano iknik arwali, leke ma kan suk maika yon rodi molollo maika me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","An kikan Ri man lewlewen onne leke kukul aki man wa'an ik upud a'ad Abraham, Isak, noro Yakup, ono Ai kan hamlinu Nin nou man Ai mehe naledi hi me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","An kikan hopo na'akerhe Nin nou ma namkene noro ik upud a'ad Abraham ");
INSERT INTO kjeNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nahenia Ai lo'o huri we'er ika nano iknik arwali lekpananne yon kamka'uk ilitolle Ai, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","leke ik kamwali Nin ri ma na'alehe dohohala, la hi'i ha ma namlolo lolo Ai leken kalarna mamani rakan iknik lere horu. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Enla ya an'u Yohanis o, na'amoli rin wekwekel o nabi man ilitolle Makromod Lalap Man Kulu Narehi Man Lapa Narehi eni, ono o penia moluwedi Makromod leke ma'ahari la ma'akene kalla An lole. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","O penia man kukul kalla man wa'an Nin ri eni, leke hi rauroin Makromod Lalap Nin panaeku nala or'ori dardari ma kan horu hi, ono na'ohu nahala rir dohohala. ");
INSERT INTO kjeNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Makromod Lalap hi'i onne ono An kukul aki man wa'an wake'e maika. Onne penia Nin Ropropeni na'akeki mai leke paku maika. An mai nano a'am raram nala ropropo naisa lere man ha'a orereki, ");
INSERT INTO kjeNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","leke na'aropedi ri man minle metmetek kalkale roro ri ma namka'uk makmaki eni. Ai penia man kukul kalla maika leke koro Makromod Lalap holi moiliwi mahuwele.” ");
INSERT INTO kjeNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakaria anan eni, eren lalapa, ai honorok akin eren narururi haenhi. Lapedi ne, an holi lolo noho mamun ma napro'uk hehen nanumene rakan lere an mai nalhari kemen ri Israel enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lere onne Kaisar Agustus nodi molollo noho Roma de an komdere nina man howok enihe horok hair Roma ne'en raram na'akeme naranhe. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Lere onne hi kar horok ri na'akeme naran makun, de eniyeni dedesne wake'e. Hir hi'i horok eni lere Kirenius namwali gubernur lolo noho Siria.) ");
INSERT INTO kjeNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ainina konomdere onne hopon ri na'akeme wali laa rira lekloi mememen leke horok naranhe. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ende Yusup noro Maria ramhara Nazaret ma aile noho Galilea wali laa kota Betlehem ma aile noho Yudea leke horok naranhe. Hir wali laa enne ono Yusup upun a'an rai Daud nonolu morie lolo kota onneni. Lere onne Yusup noro Maria lawukuwedi honorok aki leke woro'ohe ho me'e, la Maria nornoro raramne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hir minle Betlehem makun, Maria nina lere alam nokoredi me'e de karuwana me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","An mori tatana anulu eniyeni, mo'oniyane. Maria nodi tapi a'un ho'iho'ir la na'aduduwedi ha mormori nina nana'an onno, ono kar lernala onno lolo nakar paipair. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A'alam onne man huri pipduma maha radiyaka rira pipi ukun kan ko'uwala nano kota onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ramlilinnohi Makromod Lalap Nin hophopon a'am raram ida nalhari kemen hi, la Makromod Nina siksika lerlere ropa'ahedi lolo onne de ramka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Maa hophopon a'am raram onne ne'el hi na'ahenia, “Yono mamkauk! Ya'u mai leke kukunohi mi Lira Wawa'an man hi'i ri na'akeme akin nahuwa'an rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lere eni tatanida moriyedi mai lolo rai Daud nina lekloi Betlehem me'e. Tatana onne penia man huri we'er ri mormori nano rira dohohale nin molollo. Ai namwali Kristus, ik Makromod man Makromod Lalap kikan namwali Rai laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mi mauroin ainu'u wanakunu eni namlolo kokkoo nano tanada eniyeni: Mim laa enne mim do'on Tatana man idedi nanumene morie la rodi tapi a'un ho'iho'ir la ra'adudu aile ha mormori nina nana'an onno raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Enla ramlilinnohi hophopon a'am raram nammori rehi mai roro hophopon idediyeni minwuku, ra'uli rasa'a Makromod Lalap ra'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ka'uli kasa'a Makromod Lalap man aile onno man kulu narehi lolo a'am raram. Ai penia ma nala moiliwi mahuwele ri mormori ma nahuwa'an Ai akin lolo noho wawan.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hophopon a'am raram onnenihe hoikaruwedi man huri onnenihe la wali wali'uredi laa a'am raram ne, man huri onnenihe ida ma ne'el ida na'ahenia, “Mai ik kala'a laa Betlehem leke do'on panaeku man idedi nanumene Makromod kukunohi maikeni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kame'ede hir pelekleke rala'a laa kote raram pakromnala Maria, Yusup noro Tatana man idedi nanumene momorie, la ra'adudue aile ha mormori nina nana'an onno raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hir laa do'onedi tatana onneni ne, hir kukunohi ri na'akeme lolo onne panaeku ma na'ono Tatana man hophopon a'am raram onne kononohi hi eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ri na'akeme man derne man huri rira wanakunu eni, hir mehe nanananedi, ");
INSERT INTO kjeNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","maa Maria loi honorok panaeku onne na'akeme la na'akenedi lolo honorok akin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kame'ede man huri onnenihe wali wali'ur laa rir miminlole, la hi na'akeme ra'uli rasa'a Makromod Lalap la ra'akulu ra'alapa Ai Naran mamani ono ha wo'ira na'akeme man hir dodo'on dederne onne namwali lernohi hophopon a'am raram nin wanakunu onneni. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lernohi ri Yahudi rira noho honolla, Tataneni Nin alam wo'aa ne, hi rodi laa sunate, la waki naran Yesus. Naran onne penia hophopon a'am raram nale lere Maria kan apun makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Rakanedi lere alam man kuku nokor me'e, Yusup noro Maria rala'a laa Yerusalem leke ra'amou kemenhe lernohi Musa nin keneri hono'ok ma na'ono ri man moriyana. Keneri hono'ok onne hopon rin nala orpopo'o kem woro'o, ka eni, merpatiyana kem woro'o rodi hoikani Makromod. Onne kan mehe, maa hi rodi Tatana laa haenhi leke rale kanile Makromod lernohi Makromod Nin keneri hono'ok ida man hopon na'ahenia, “Mala minim tatana mo'oni dedesne na'akeme kanile Makromod leke namwali Nin ri mememen.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lere hir minle Yerusalem ri ida aile naran Simeon. Ai onne ri molololo la akin ka nahinuri Makromod. Ai mahan lalapan lere Makromod Lalap huri we'er Israel nano rir arwali, la Roh Kudus norle'ule'u norwaliwali ai mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Enla Roh Kudus kukunohiyedi ai me'e nahenia ai lo'o do'on Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi nanumene an maki. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lere onne Roh Kudus nodi molollo ai penia an mai Romleu Lap raram. Lolo onne an holikuku Yusup noro Maria maha rodi Anan Yesus mai leke hi'i wewhe lernohi Musa nin holoor halauk. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Enime'ede Simeon nala Tatane nomonedi la na'uli nasa'a Makromod Lalap na'ahenia: ");
INSERT INTO kjeNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Makrom'uee! Lere eniyeni O ma'akuku ma'anokoredi Num nou maya'u ma namwali Num hophopon wahwahan me'e, de ya akin nahuwa'anedi la ya amkene maki, ono ya'u mehe odi i mak'u do'onedi Ri man Om niliyedi namwali man huri we'er ri nano rir dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","I Makrom'u na'akenedi Ai man huri we'er hair rahu na'akeme nano dohohala nin molollo me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ai eni naise ropropo ma na'amou na'aropo ri ma ka namwali Yahudi akinhe leke hi rauroin O. Enla nano Nin hini'i wenewhe de ri na'akeme horhawa mayai ma namwali Israel upun ananhe, Num ri mememen.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tatana onne inna noro aman hehel rehi derne Simeon nin wanakunu man ma'aruru ma na'ono hi anan eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon napanak Makromod Lalap namre'e namharu hi la ne'el Maria na'ahenia, “Tatana eniyeni, Makromod Lalap niliyedi leke na'idaru Israel upun ananhe nammori ma kan derne nakani Ai, maa na'akulu na'alapa ri nammori ono hir derne rakani Ai haenhi. Enla ri nammori lo'o do'on Nin hini'i wenewhe la derne rakani Nin wanakunu ma na'ono Makromod Lalap Nin honorok panaeku, maa ri nammori lo'o ra'okul Ai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Makromod Lalap hi'i heheni leke nalhari ri nammori honorok akin leke ri namehin rauroin haenhi. Enla Maria, o akin woir wake'e naisa rin nodi raa ma namlorno kadie haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lolo onne nabi maeke ida naran Hana ma na'ileheredi me'e aile haenhi. Ai eni Panuel anan nano luhu Aser. An ho anna wo'ikku mehe ne, nin mo'onleher maki, ");
INSERT INTO kjeNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","de ai namwalum nalo'oledi me'e, ono nin anna weli'aa wo'akkedi me'e. Ai namkene lolo Makromod Lalap Nin Romleu Lape mamani. Lelere al'alam an hi'i lir napanak la ka na'ak, ono an hi'i lir napanak la na'uli nasa'a Makromod Lalap mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon wakunu horu ne, maeke onne mai de na'uli nasa'a Makromod Lalap. Lolo onne ri nammori aile mahar lalapan lere Makromod Lalap huri we'er Yerusalem nano ri man kerne dalhe, la Hana konohi hi na'akeme panaeku nammori ma na'ono Tatana onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusup noro Maria hi'i wewhedi lernohi Makromod Lalap Nin holoor halauk eni horu ne, hir wali wali'ur laa rir lekloi Nazaret man aile noho Galilea. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tatan onne eren lalap, eren narururi, la eren nauroroin. Enla Makromod Lalap namre'e namharu Ai mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aki anne Yesus Nin ri leleher laa Yerusalem leke lernohi Yahudi rira Lere Alam Lapa Paska ma na'ori honorok hi lere ramharedi Mesir nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Rakan Yesus Nin anna idaweli woro'o ne, An lernohi Nin ri leleher laa Yerusalem leke lernohi lere alam lap onne naise nadedem. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lere Paska eni horu, hir wali wali'ur, maa Yesus kan lernohi hi. An minle Yerusalem, maa Nin ri leleher ka rauroini. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hi rauroin nahenia an lernohi rir kalla wali enihe de rala'edi lerida mene ranoin. Hi ranoin lolo lodon walinhe roro rira ri orwali, ");
INSERT INTO kjeNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","maa kar do'one de wali wali'ur laa Yerusalem leke ranoin Ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Alam wokelu horu mene pakromnale aile Makromod Lalap Nin Romleu Lape raram naikokoro mahan nakani meser agamenihe rira wanakunu la na'ukani hi na'ukankani nammori. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Heri man derne Ainin wanakunu polletilu ra'aheni, “Hoih! Tataneni nauroin! Nin wanalhe lewlewen!” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nin ri leleher do'onedi Ai, hir hehel rehi. Inna ne'el Ai na'ahenia, “Pa'e, hi'ihepenia Om hi'i heheni mayaie? Yo oro Num papa sus wake'e manoin O.” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus walhe, “Mame, hi'ihepenia moro papa sus wake'e manoin Ya'ue? Mi lo'o ka mauroin Ya amkene lolo Ya Am'u nin Romleu?” ");
INSERT INTO kjeNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Maa hi ka rauroin Nina wanakunu eni nin panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kame'ede Yesus noro Nin ri leleher wali laa Nazaret, la An derne nakani hi mamani. Inna na'akenedi panaeku onnenihe na'akeme akin. ");
INSERT INTO kjeNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus eren lalap, eren nauroroin la eren nahuwawa'an Makromod Lalap noro ri mormori akinhe. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kaisar Tiberius nodi molollo Roma anna idaweli wolima mene Pontius Pilatus namwali gubernur lolo Yudea. Lere onne rai Herodes nodi molollo Galilea, mo'oniwalla Pilipus nodi molollo Iturea noro Trakonitis, la Lisanias nodi molollo Abilene. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Enla ma namwali imam man kulu narehi, Hanas noro Kayapas. Lere onne Makromod Lalap nalhari Lirna Zakaria anan Yohanis lolo noho mamun ma napro'uk. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ende an laa oir wauwau Yordan arkan wali-wali loikaru Makromod Lalap Lirna Wawan. Yohanis wakau na'ahenia, “Heih! Herredi minim morimori ma ka namlolo, wali derne makani Makromod Lalap, la mai mapanak yo odi oir ulutada mi leke Makromod Lalap na'ohu nahala minim dohohale.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanis onne na'akuku na'anokor horhorok ma aile nabi Yesaya nina horok ma na'ahenia, “Ri ida aile lolo noho mamun ma napro'uk wakaukau, na'aheni, ‘Ma'ahari kalla, la ma'anehe, leke Makromod lole. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Onno ma na'umokmoko ra'enuwedi, ma nawo'wo'or ra'anehedi. Kalla ma naple'ule'u ra'aduduwedi la kalla ma na'ohu nakepe ra'anehedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hi'i heheni leke ri na'akeme lolo noho wawan do'on rauroin hi'ihewi Makromod Lalap huri we'er ri nano dohohala nin molollo.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ri nammori mai Yohanis leke ulutade, la ai na'aheni, “Heih, mi eniyenihe ailanna maisa haimoke! Yon makoto nahenia lo'o mim mai ulutade leke mahinuriyedi nano hunukum lere man mamai eni, ");
INSERT INTO kjeNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","maa lam hi'i ha man wa'an leke ri nauroin kokkoo mim herredi minima morimori ma ka namloleni, la lernohi Makromod Lalap Nin honorok panaeku mehe. Yon pene'ek mi mamwali Abraham upun ananne de kam lernala hunukum. Makromod Lalap peni nodi molollo hi'i waku eniyenihe herre mi namwali Abraham upun anan. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Makromod Lalap Nin hunukum na'akeki rakan me'e. Lere eni Ai na'akenedi Nin he'i aile au onno me'e. Inhawa au'ono ma woin ka namlolo, An keri, sopol laedi aiye raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ri nammori ra'ukani Yohanis, “Ende lo'o am hi'i inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanis walha, “Ri ma nin rain woro'o aile, nala ida laa ri ma na'alehe, la ma nin hanana'an aile, ha'ar noro ri ma na'alehe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Man ra'uk paipaire me'e ne mai Yohanis leke ulutade lolo oir. Hi ra'ukani, “Papa Meser, lo'o am hi'i inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","An walhe, “Lere mim ra'uk paipaire, yon larlewen ma nodi molollo paipair nin kenekrohu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma nasala ke'urauk mai haenhi, ra'ukanie, “Emene am hi'i inhawa ho'o?” An walhe, “Yon kerne dalha ri leke hi rala kupan ki mi, yon kuku sala ri ma kan hi'i yaksala leke lernala kupan, maa modi aki ma namkene mori noro minim naiwe'el herme'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lere onne ri nammori mahar lalapan Ai man Makromod Lalap kikanedi namwali Rai laa ewi-ewi, de hir derne Yohanis nina wanakunu eni ne, lolo akinhe ra'aheni, “Ai eni lo'o Kristus man Makromod Lalap nouwedi maika eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Onne penia Yohanis walhe na'ahenia, “Ka nalo'ol Ri ma nodi molollo narehi ya'u mai, Nin pakpak ei nin kali me'ene, kan wa'an ya'u we'er. Yo odi oir ulutada mi, maa Ri man mamai onne nodi Roh Kudus noro aiye ulutada mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ai nodi kokopo ka'i na'amou Nina gandum, loiwuku ihin dakar raram, la osorne, sopol laedi aiye man mori mamani raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanis nodi panaeku ma naise onne nammori nounaku heri lere ai na'amou na'aropo Lira Wawa'an hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Enimaa ler ida Yohanis dadiyala rai Herodes ma nodi molollo Galilea ono an ho mo'oniwalla Pilipus hono Herodias, la hi'i panaeku namehin man ailanna haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes kan ren nin ailanna, maa hi'i eren ailalanna, de kele Yohanis nale laa bui raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lere Yohanis mahan ulutade ri nammori lolo oire, Yesus mai napanak ulutade haenhi. (Lere onne Herodes kan kelewuku Yohanis makun.) Ai mahan hi'i lir napanak, a'am nahinariyedi, ");
INSERT INTO kjeNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","la Roh Kudus molmolo merpati ida kopur mai Yesus wawan. Enla lira ida namhara a'am raram na'ahenia, “Ya An'u O! Ya amre'e amharu O rehi. Om hi'i Ya akin nahuwa'an rehi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Lere Yesus naderre nadaul Makromod Lalap Lirna Wawan dedesne Ainina anna lo'o welikelu la rin pene'ek Ai onne Yusup anan la Eli upun. Eli aman Matat, Matat aman Lewi, Lewi aman Malki, Malki aman Yanai, Yanai aman Yusup, Yusup aman Matica, Matica aman Amos, Amos aman Nahum, Nahum aman Hesli, Hesli aman Nagai, Nagai aman Ma'at, Ma'at aman Matica, Matica aman Simei, Simei aman Yosek, Yosek aman Yoda, Yoda aman Yohanan, Yohanan aman Resa, Resa aman Zerubabel, Zerubabel aman Sealtiel, Sealtiel aman Neri, Neri aman Malki, Malki aman Adi, Adi aman Kosam, Kosam aman Elmadam, Elmadam aman Er, Er aman Yesua, Yesua aman Eliezer, Eliezer aman Yorim, Yorim aman Matat, Matat aman Lewi, Lewi aman Simeon, Simeon aman Yehuda, Yehuda aman Yusup, Yusup aman Yonam, Yonam aman Eliyakim, Eliyakim aman Melea, Melea aman Mina, Mina aman Matata, Matata aman Natan, Natan aman Daud, Daud aman Isai, Isai aman Obet, Obet aman Boas, Boas aman Salmon, Salmon aman Nahason, Nahason aman Aminadab, Aminadab aman Admin, Admin aman Arni, Arni aman Hezron, Hezron aman Peres, Peres aman Yehuda, Yehuda aman Yakup, Yakup aman Isak, Isak aman Abraham, Abraham aman Tera, Tera aman Nahor, Nahor aman Seruk, Seruk aman Rehu, Rehu aman Peleg, Peleg aman Eber, Eber aman Salmon, Salmon aman Kenan, Kenan aman Arpaksad, Arpaksad aman Sem, Sem aman Nuh, Nuh aman Lamek, Lamek aman Metusalah, Metusalah aman Henok, Henok aman Yared, Yared aman Mahalaleel, Mahalaleel aman Kenan, Kenan aman Enos, Enos aman Set, Set aman Adam. Adam aman Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Lere Yesus namhara oir wauwau Yordan onne, Roh Kudus minle Ai raramne la norkaru Ai laa noho mamun ma napro'uk. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Min lolo onne Hayakyak Makromon man kene patal Yesus lere weli'akka raram. Lelere a'alam ka na'an haida de rakan alam weli'akka horu, Ai namlara wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Enime'ede Hayakyak Makromon mai ne'el Ai na'ahenia, “Lo'o namlolo kokkoo Makromod Lalap Anan O, hopon waku eni namwali hanana'an.” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Enimaa Yesus walhe na'ahenia, “Makromod Lalap na'aheniyedi lolo Horok Lap raram, ‘Ri kan mori nano hanana'an mehe.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Horu ne, Hayakyak Makromon nodi Yesus laa wo'or man kulu rehi. Me'e'eni me'ede an kukul Yesus noho wawan nin hair-hair na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ai ne'el Yesus na'aheni, “Ya ala hair-hair noro rir linikir kanaru na'akeme ki O leke modi molollo. Ainu'u molollo aile hi'i onne ono ha wo'ira na'akeme onne raledi ya'u me'e de ya ale inhoi-inhoi menmolollo ainu'u suke. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ende ya ala ha wo'ira na'akeme onne Om manarne horo nahenia O ma'uli masa'a ya'u nanu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Enimaa Yesus walha na'ahenia, “Horhorok aile man hopon Makromod Lalap Nin ri na'ahenia, ‘Ma'uli masa'a Makrommu, Makromod Lalap, la derne makani Ai mehe.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Onne horu, Hayakyak Makromon nodi Ai laa kota Yerusalem laa onno man kulu wake'e lolo Makromod Lalap Nin Romleu Lape, la na'aheni, “Lo'o namlolo kokkoo Makromod Lalap Ananne O, nehu laa yawa, ");
INSERT INTO kjeNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ono horhorok aile Horok Lapeni ma na'ahenia, ‘Makromod Lalap hopon Nin hophopon a'am raram mai leke radiyaka O wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hir mai kokala O leke yon mediyawa la yon eum tukul wakue.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus walha na'ahenia, “Maa horhorok aile haenhi man hopon Makromod Lalap Nin ri na'ahenia, ‘Yon hi'i ha ma kan min haida modi kene Makromod Lalap Ma Narehi Ma Nalewen.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hayakyak Makromon nodi kalla wo'ira kene patal Yesus horu ne, an hoikaruwedi Yesus la lapan leken paharin wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kame'ede Yesus wali laa Galilea la Roh Kudus na'aromromo raramne de Nin ke'eke'el an'anha norle'ule'u norwaliwali Ai mamani. Yesus naran pe'eredi lolo noho onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","An wakuku lolo Yahudi rir kerei-kerei la ri na'akeme ra'uli Ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Enime'ede Yesus wali laa Nin leke Nazaret. (Nano tatana rakan lapa, Ai noro Nin ri leleher minle leke onne.) Rakanedi Yahudi nin Alam Renren Warwarna, An laa Yahudi rir kerei raram naisa nadedem. Ai namriri leke lese Horok Lape, ");
INSERT INTO kjeNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","la hi rala nabi Yesaya nin horok An lese. An hari horok lunlunna onne nanoin lisar ida woro'o leke lese heri kalarna. Lisar onne lirna na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Makromod Lalap Nin Roh aile Maya'u raram, ono Ai na'onedi Maya'u leke aderre adaul Lirna Wawa'an laa ri ma na'alehe haida-haida. Makromod Lalap hopon Ya'u mai kukunohi Lirna Wawa'an onne laa ri ma aile kali wunuku dadal rai raram, leke hi rahinuri rawine'eredi. An hopon Ya'u mai leke hi'i man makan toko wa'anedi la huri we'er ri man aile kenerne danalha raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","An hopon Ya aderre adaul Ai Lirna ma na'ahenia lere alam man An kukul Nin rere'e haharu ri mormori rakanedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lese horu, Yesus lunne horok onne wali'ur, nala kanile wali'ur laa man howok kerei onne la naikoredi leke wakuku kerei raramne. Man penpenu kerei raram onnenihe po'on kakane. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Enime'ede An kukunohi hi na'ahenia, “Lere eniyeni Horok Lap Lirna man mim dederne idedi eni namwaliyedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Heri man derne Ainina wanakunu eni mehe nanana mouwedi, la ra'uli Ai ra'aheni, “Nin wanakunu ma'aruru wake'e! Kak dernala wanakuku man mou heheni makun! Maa ida ma ne'el ida na'ahenia, ‘Ri eni Yusup anan menee!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus ne'el heri onne na'ahenia, “Ya auroin mi kam hamlinu wanakunu naho'ok eniyeni: Lo'o o mamwali dokter kokkoo, ken ma'inapin o kemen nanu! Mi raram nodi hopon Ya'u hi'i heheni. Mi mahinorok nahenia lo'o Ya amwali nabi kokkoo, wa'an rehi Ya'u hi'i ha man ri kan dodo'onnala makun lolo iknik leke eni naisa mim dederne Ya'u hi'iyedi lolo Kapernaum. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Horhorok Ainu'u panaeku eniyeni: Ri ka nadedem kokala nabi ida lolo nina leke mememen. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Derne makaniyala Ainu'u wanakunu ma namlolo eniyeni ono panaeku ma naise onne namwaliyedi nabi Elia nin lere nonolu eni. Lere onne a'am na'inelekedi anna wokelu wollo woneme raramne de roulara lape lolo noho onne na'akeme, la maeke walwalum nammori aile noho Israel. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kade onne namlolo, maa Makromod Lalap kan hopon Elia laa maeke ida nano hi, maa hopon nala'a laa maeke walwalum ida ma aile Sarfat lolo Sidon. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ha naisa onne namwali nabi Elisa nin lere nonolu eni haenhi. Lolo Israel ri nammori ulik yak hi'ie, maa Elisa kan hi'i wa'an ri mahaku nano hi. An hi'i wa'an Na'aman mehe, ai onne ri manin Syria.” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Man min lolo kerei raram onne na'akeme derne Nin wanakunu onneni ne, hi ra'ahan rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hi ramriri, rohi Yesus namhara kote, rodie laa wo'or kekin ma na'uranrani kota onne leke rokul lolo wo'or kekin laa yawa. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Enimaa Yesus loledi heri leken de nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Horu ne, Yesus nala'a laa kota Kapernaum lolo noho Galilea. Rakan Alam Renren Warwarna An wakuku ri nammori lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Heri man min lolo onnenihe mehe nanana mouwedi la aki'aki uluwakun derne Nina wanakukue, ono Nin wanakuku nodi molollo la nedille hi akin. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lolo Yahudi rira kerei raram ri ida aile man hayakyak hu'uhu'ur raramne. An wakau na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Heih! Yesus! Nazaret O. Om paeku inhawa noro mayai? Om mai leke mano'onyaka mayai me'e? Ya auroinedi O me'e. O penia Makromod Lalap Nin Hophopon mememen Man Moumou Dewdeweni!” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus komdere na'ahenia, “Karkaramedi! Mamharedi ai raramne here!” Enime'ede hayakyak onne hi'i ri onne nalwali yawa lolo heri kalarna la idewe namharedi ai, maa kan hi'i apinpinha ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Heri na'akeme polletilu la ida ma ne'el ida na'ahenia, “Wanakuku eni ra'ahewi pe? Ai nodi molollo noro ke'eke'el an'anha hopon hayakyaka me'ene, hir derne rakani de ramharedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kame'ede panaeku ma na'ono Yesus Nin hini'i eni naderre nadaul lolo leke-leke ma aile lolo onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus namharedi Yahudi rira kerei ne, idewe laa Simon nin nakar. Rakanedi nakar ne, hir do'on Simon panin nakni'ir rinna manha de rapanak Yesus paku ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Enime'ede Yesus na'uraniyedi nin namkuru onno la nohiyedi nin kini'ir rinna manha me'e de moluwedi. Ideweni ne maeke onne namaka la na'akene hanana'an hi ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lere na'ikeki helem eni ne, ri nodi ma nakni'ir nammori mai Yesus. Hirira apinha wo'ira aile. Enla Yesus kemenala liman hi dohodoho me'ede hir wa'an mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ri heruwali hayakyaka hu'uhu'ur raramne, la Yesus hopon hayakyaka namharedi hi raram here. Ramharedi ne, hir wakau ra'aheni, “Ai mauroinedi Makromod Lalap Anan O.” Maa Yesus ka nala leken wake'e hayakyaka wakunu, ono hi rauroinedi me'e Ai onne Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rakan oreki nohoropo Yesus nala'a laa onno ma namlina namkai lolo leke paharne. Heri laliwewer ranoin Ai, de maiyedi Nin miminlole, rahehe kawala Ai leke yon laa onno namehin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Enimaa Ai na'aheni, “Ya'u mai leke loikaru Lir Wawa'an man kukunohi ri hi'ihehewi Makromod Lalap nodi molollo ri man derne nakani Ai. Ende Ka'u loikaru ki mi mehe, maa loikaru leke-leke namehin haenhi. Onne penia Makromod Lalap hopon Ya'u mai noho wawan eni!” ");
INSERT INTO kjeNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ende An kuli kerei laa kerei lolo noho Yudea na'akeme leke loikaru Makromod Lalap Lirna Wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ler ida Yesus mahan wakuku lolo oir lap Galilea arkan, la ri nammori mai lupurale leke derne Makromod Lalap Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus do'on ma nohu meki rir korkoro woro'o palipali aile oir arkan, la An do'on ma nohu meki enihe kopuredi maha ra'amou darie lolo herre raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Enime'ede Yesus ha'a korkoro ida man Simon nine, la napanak Simon rokul laedi roromne nanumene naikoredi wawan la wakuku heri onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wakuku horu ne, Ai ne'el Simon, “Ik kala'a laa onno man rorom la kaki dari lolo onne leke lernala i'in.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon walhe, “Makrom'u, alam eni am kaki dari alam kekeme, maa ai kam lernala i'in kem mahaku. Enimaa Papa Meser napanak kaki dari de ya'u kenala ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hir laa kakiyedi dari horu ne, ri'ik wali'ur, i'in penuwedi dari me'e de dari napriki me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ende Simon nodi liman aun walin manina korkoro namehin mai paku ra'uk i'ine rala loile rir korkoro hehen nanumene korkoro woro'o onnenihe na'ikeki keper. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Petrus po'on panaeku onneni ne, an rawa yawa Yesus kalarna na'ahenia, “Makrom'u, ya'u eni man hi'i dohohale de wa'an rehi yon moro ya'u min mai eni me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ai na'aheni onne ono eni nanumene ai noro nin man howok wali enihe lernala i'in nammori rehi naiseni de hir hehel rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon nin man howok wali Yakobus noro Yohanis, Zebedeus ananhe, hehel rehi haenhi. Enime'ede Yesus ne'el Simon, “Yon mamkauk Simon! Nano lere eniyeni o mauroin manoin ri mormori naisa o manoin i'in haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ende hir wokedi rir korkoro eni, hoikaruwedi rir ha wo'ira na'akeme, la lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ler ida Yesus aile leke namehin. Lolo onne mo'oni ida aile ulik yak hi'ie de kemen yak wake'e. An do'onedi Yesus ne, an mai kadi ein korno kalarna, napanak an'anhedi, “Papa ne'e harome hi'i wa'anedi ainu'u apinha ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Enime'ede Yesus kemenala liman laa ri onneni, na'aheni, “Ye e'e! Wa'anedi here!” Me'e'eni me'ede ri onne nina ulik yake wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Horu ne, Yesus hopon na'ahenia, “Yom konohi ri ha ma namwali o kemen eniyeni, maa mala'a laa imam nanu leke an po'onala o kemmu, nauroin nahenia om wa'anedi me'e. Modi onum honoi kanani laa mala ai leke lernohi agame nina holoor halauk eni. Hi'i onne leke namwali tanada nahenia om wa'anedi kokkoo me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Enimaa Yesus Nin hini'i onne naderre nadaul eren koko'u penia ri nammori mai leke derne Nin wanakuku la rapanak An hi'i wa'an rira apinha. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kade onne namlolo, maa lere romromo Yesus nahaledi kemen laa noho mamun leke hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ler ida nine Yesus mahan wakuku lolo onnida, la ri Parisi noro meser-meser Horok Lap raikokoro lolo onne. Heruwali rano Yerusalem mai, heruwali mai nano leke na'akeme ma aile Yudea noro Galilea. Ke'eke'el an'anhe nano Makromod Lalap aile Yesus raramne de Ai nodi molollo hi'i wa'an ma nakni'ir. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lere onne ri ida woro'o le'u mo'oni ma naplu'uk nap'eker ida noro nin namkuru onno mai. Hi rahehe rodi mo'oni onne laa romleher leke loile Yesus kalarne, ");
INSERT INTO kjeNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","maa ri nammori rehi de kar lernala kalla rodi ma nakni'ir laa raram, de hir ha'a laa nakar wawan, raiye'er nakar wawan mene rala kopur ma nakni'ir noro nin namkuru onno idewe laa Yesus kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus po'on nauroinedi nahenia ri onnenihe akin naili'il kokkoo, de ne'el man apinha onne na'ahenia, “I wal'u, Ya a'ohu ahaledi onuma dohohale me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Enime'ede meser Horok Lap noro ri Parisi enihe roro akin wakunu ra'ahenia, “E'eni inhoi penia wakunu heheni? Ai na'ihoru na'idaruwedi Makromod Lalap me'e ono Makromod Lalap mehe nodi molollo na'ohu nahala dohohala!” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Enimaa Yesus nauroinedi hi honorok akinhe me'e de na'ukani hi na'ahenia, “Hi'ihepeni mim kikan panaeku eni mi raramne? ");
INSERT INTO kjeNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ewi man sus rehi? Ya a'ohu ahala ri eniyeni nin dohohala, ee Ya'u hi'i ai nala'ala'edi? ");
INSERT INTO kjeNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Enimaa Ya'u hi'i wa'an ri eni leke mi mauroin mouropo nahenia Ya'u eni ma namwali Ri Mormori Anan, la Yo odi molollo lolo noho wawan a'ohu ahala ri nina dohohala!” Enime'ede Yesus hopon ri ma naplu'uk nap'eker onne, “Mamakedi! Modi num namkuru onno, wali laa num nakar here!” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lere onne me'ede ai namaka lolo heri kalarna, na'uwara nin namkuru onno wali laa nina nakar. Ai nala'a ne, na'ul'uli nasasa'a Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Enla heri man min lolo onne polletilu la ra'uli rasa'a Makromod Lalap haenhi. Hi ramka'uk la ra'aheni, “Lere eni ika do'onedi ha man ri kan dodo'onnala makun.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Horu ne, Yesus namhara nakar onne, do'on mo'oni ida naran Lewi. Lere onne ai naikokoro lolo onno ai nadedem ra'uk paipaire. Yesus napolu ai, “Mam lernohi Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kame'ede ai namriri hoikaruwedi nin ha wo'ira na'akeme la lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Enime'ede Lewi hi'i ya'an yomun lolo nin nakar, la lariyala nina muku man ra'uk paipair enihe roro ri namehin nammori, leke hi na'akeme mai roro Yesus ra'ak romun wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Enimaa ri Parisi noro rira meser-meser Horok Lap enihe kar suk nin hini'i onne de ra'ukani man lernohi pakunohi Yesus enihe, “Hi'ihepeni moro man ra'uk paipair la moro man hi'i dohohala enihe ma'ak wewerre?” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus walhe na'ahenia, “Ma kan apinha, ka nanoin ma na'inapin, maa man apinha penia nanoin ma na'inapin. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ka'u mai apolu ri man hi'i ha ma namlolo mamani, maa Ya'u mai apolu ri man hi'i dohohala, leke herredi rir morimori ma ka namlolo eni, mai lernohi Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ri Parisi enihe re'el Yesus na'ahenia, “Lere romromo Yohanis nin man lernohi enihe ra'aluli kemen ka ra'ak romun leke hi'i lir napanak Makromod Lalap naisa ainim man lernohi haenhi, maa Num man lernohi enihe ra'ak romun mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus nodi wanakunu naho'ok ida walhe na'ahenia, “Lo'o ik min hohoo ida, polpolu larlariyala radedem ra'aluli kemen ka ra'ak romun, pe? Ka! Hi ra'ak romun mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Enimaa rakan orekiyedi, ri namehin mai rala man ho nano hi leken kalarne. Lere onne mene hi ra'aluli kemen ka ra'ak romun.” ");
INSERT INTO kjeNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Horu ne, Yesus nala wanakunu naho'ok ida woro'o wali'ur. Ai na'aheni, “Ri ka nadedem sirriki rain worworu leke tapil rain lo'olo'ol ma naprikiyedi me'e, kalo'o ai nano'onyaka rain worworu onne noro idewe rain lo'olo'ol haenhi. An hi'i rain lo'olo'ol onne yakedi ono tapi nano rain worworu onne ka namnehe noro tapi nano rain lo'olo'ol. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Onne namnenehe panaeku eniyeni: ri ka nadedem nala anggur worworu halle sak ulik lo'olo'ole, kalo'o anggur woruworu eni hi'i sak ulik lo'olo'ol onne naprikiyedi de anggur halle mouwedi, ");
INSERT INTO kjeNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","maa ri nadedem nala anggur worworu halle sak ulik worworu. ");
INSERT INTO kjeNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Enla ri ma nadedem nomun anggur lo'olo'ol kar suk romun anggur worworu ono hir pene'ek lo'olo'ol nine penia man wa'an narehi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Alam Renren Warwarna ida, Yesus noro Nin man lernohi pakunohi enihe rala'ala'a lolo gandum kirna ida reku gandum wurna, ra'adi, de ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ri Parisi heruwali ma aile lolo onne do'odo'on, de ra'ukaniyale ra'aheni, “Lere eniyeni Alam Renren Warwarna! Emene hi'ihepenia mim larlewenedi iknik agame nina holoor halauk penia mim hi'i honowok naise onneni?” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus walha hi na'ahenia, “Mim lesedi inhawa ik upud a'ad Daud hihi'i lere ai noro nina kalla wali ramlara wake'e harome!? ");
INSERT INTO kjeNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lere onne Daud laa Tenda ma namwali Makromod Lalap Nin miminlole raram na'an roti man luli ra'an ono rodi hoikani Makromod Lalap, la nala nin muku ra'an haenhi. Makromod Lalap Nin holoor halauk hurinohi imam mehe ra'an roti onne, ri namehin ka, maa mi ka mala sala Daud, de hi'ihepe mala sala Maya'u? ");
INSERT INTO kjeNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ya a'aheni heheni ono Ya'u, ma namwali Ri Mormori Ananne, odi molollo hopon rin hi'i inhawa-inhawa Alam Renren Warwarna.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Alam Renren Warwarna wali'ur, Yesus laa wakuku lolo Yahudi rir kerei raram. Laedi kerei raram ne, An do'on mo'oni ida man liman wali malanne makiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lere onne meser-meser Horok Lap roro Parisi ida woro'o aile lolo onne maha ranoin Yesus Nina sale, leke kele rodi laa hono'ok kanail onno, kalake. Hi radiyake leke rauroin An hi'i wa'an mo'oni man liman maki eni Alam Renren Warwarna, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Enimaa Yesus nauroinedi hi honorok akin me'e de ne'el mo'oni man liman maki onne, “Mamririyedi! Mai mamriri heri kalarna.” Enime'ede mo'oni onne mai namririyedi heri kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus wakunu noro ri man aile lolo onne na'ahenia, “Ainu'u na'ukankani aile. Iknik holoor halauk hurinohi ika hi'i inhawa Alam Renren Warwarne? Hi'i ha wawa'an, ee hi'i ha yakyaka? Hi'i ri man apinha wa'an, ee kesne ri?” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","An po'on heri onnenihe dohodoho horu mene ne'el ma liman maki onne, “Ma'aloledi o liman, pa'e.” Kame'ede ai na'aloledi liman, idewe liman wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Onne penia meser-meser roro Parisi enihe eren ra'a'ahan de hir wakunu wuku leke rala kenekrohu hi'i inhawa noro Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ler ida Yesus wakiha'a wo'or ida leke hi'i lir napanak. A'alam kekeme ida An hi'i lir napanak Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Rakan nohoropo ne, Ai napolu man lernohi enihe mai leke nili ri idaweli woro'o nano hi na'akeme. An kikan hi leke ramwali Nina hophopon ma nodi Lirna Wawa'an enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri onnenihe naran: Simon (man An waki naran Petrus) noro mo'oniwalla Andreas, Yakobus noro Yohanis, Pilipus noro Bartolomeus, ");
INSERT INTO kjeNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius noro Tomas, Yakobus (Alfeus anan) noro Simon--rapolu ri Zelot (napa'ahne, ‘ri ma namhene hair Roma nodi molollo Israel’), ");
INSERT INTO kjeNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobus anan) noro Yudas Iskariot (ma na'olu Yesus). ");
INSERT INTO kjeNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kame'ede Yesus noro Nin man lernohi pakunohi enihe kopur wo'or onne laa kauhu ida. Lolo onne nin man lernohi nammori aile roro idewe ri nammori ma nano Yudea, Yerusalem, la nano kota Tirus noro Sidon ma aile Kahi Lapa herraram. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hi na'akeme mai leke derne Yesus Nin wanakuku la rapanak An hi'i wa'an rira apinha. Ri man hayakyaka huhu'ur raramne mai haenhi la An nohi hayakyak nano hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Heri onnenihe rahehe leke tukulala Yesus ono ke'eke'el an'anha man hi'i wa'an rira kini'ir na'akeme namhara nano Ai kemen. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kame'ede Yesus po'onala Nin man lernohi pakunohi enihe la na'ahenia, “I wal'uhe ma na'alehe haida-haida, mi akim nahuwa'anedi ono mi mamwali Makromod Lalap Nin ri la Ai namwali minim Rai. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mi ma namlara lere eniyeni, mi akim nahuwa'anedi ono lere man mai mim lernala ha man kukkuku noknokor de mi akim namkene. Mi ma naherhere lere eniyeni, mi akim nahuwa'anedi ono lere man mai Makromod Lalap hi'i mi malau mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Lere ri kan suk mi, de ra'okul mi, ilnohi ralnohi mi, la ra'ihoru ra'idaru mi ono mi akim namkene lernohi Ri Mormori Anan eni, mi akim nahuwa'anedi, ");
INSERT INTO kjeNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ono hi upun a'anhe penia hi'i heheni nabi-nabi nonolu eni. Ende lere mim lernala apinpinha onne, mahuwa'anedi mi akim la sokmura mamani ono Makromod Lalap na'akenedi minim mahmaha kolkoli ihin ennen man lap aiyedi a'am raram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Enimaa apinha wake'e ki mi ma namwali orkanaru lere eniyeni, ono mim lernaledi ha wo'ira ma nahuwa'an mi akim me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Apinha wake'e ki mi man pehur lere eniyeni, ono na'amoli mi mamlara. Apinha wake'e ki mi man sokmura lere eniyeni, ono na'amoli mi lo'o sus mak oir la mahehere. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Apinha wake'e ki mi lere ri na'akeme ra'uli mi ono naise onne haenhi mi upum a'umhe ra'uli nabi-nabi ma ka namlolo nonolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Enimaa mi ma nakani Ya'u mai eni, makaniyala Ainu'u nounaku eniyeni: Maramyaka minim arwali, la hi'i ha man wa'an ri ma kan suk mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mapanak Makromod Lalap namre'e namharu ri man lokor hauk mi, la hi'i lir napanak ri man hi'i yakyaka mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lo'o rin pahar mi muman wali, mala wali pahar wali'ur. Lo'o ri napanak num rain sorsoru eni, male num rain dedeul haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lo'o rin napanak haida nano mi, male hi, la lo'o rin nala minim hahaa, yono mapanak nale wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Inhawa hini'i wenewhe mi raram nodi rin hi'i ki mi, hi'i onne laa hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Lo'o mi maramyaka mehe ri ma nadedem naramyaka mi, yom pene'ek Makromod Lalap na'akene haida man wa'an herre walha minim hini'i wenewhe onne ono ri man hi'i dohohala me'ene raramyaka ri ma naramyaka hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lo'o mim hi'i ha wawa'an laa ri man hi'i wawa'an ki mi, Makromod Lalap ka na'uli mi, ono ri man hi'i dohohale me'ene hi'i heheni haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lo'o mi mala kupan ri ma nin panaeku herre kupan onne wali'ur mehe, Makromod Lalap ka na'uli mi, ono ri man hi'i dohohala me'ene rala kupan rir ri orwali horo nahenia hir herre wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yon hi'i heheni, maa maramyaka minim arwali la hi'i ha man wa'an hi. Lo'o mala haida ri yon mim keker henerunne. Lo'o mim hi'i ha man wa'an eniyeni, mim lernala wanalhanne man lap, la mim kukul nahenia mamwali Makromod Lalap Man Kulu Narehi Man Lapa Narehi ananhe. Ai penia kukul aki man wa'an ri ma ka napanak trimkasi Ai noro idewe ri man ailanna. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ende kukul aki man wa'an minim ri heri ri wali naisa mi Ammu, Makromod Lalap man aile a'am raram, kukul aki man wa'an ki mi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yom ho'ok kail ri namehin, leke yono Makromod Lalap ho'ok kail mi. Yon suk mala hunukum ri namehin, leke yon Makromod Lalap nala hunukum mi. Enimaa mala ampun ri man hi'i yaksala ki mi, leke na'amoli Makromod Lalap na'ohu nahala minim dohohala haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mala inhawa-inhawa leke paku ri namehin. Na'amoli mi lo'o kokala wanalhanne ma narehi nalewen inhawa man mi mamala onne. Enla hono'ok mim nanair leke mala hahaa ri namehin onne, Makromod Lalap lo'o nairre nala ki mi wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Enla Yesus nodi wanakunu naho'ok ida woro'o wali'ur na'ahenia, “Hi'ihehewi, lo'o maktoko ida ni'ik maktoke namehin wa'an, ee ka? Ka! Lo'o ida ma ni'ik ida, woro'ohe rediyedi laa moke raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pudpude ka nauroin narehi nin meser, maa lo'o pudpude ida nampe'el wakuku hehen nanumene nin wanakuku horu, ai onne noro nin meser namnenehe. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hi'ihepenia mim do'odo'on au mo'anida man minle mi wallum makan raram, maa au lapa man aile mi makan raram kam talukire? ");
INSERT INTO kjeNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hi'ihepenia me'el mi wallum ma'ahenia, ‘Mai, ya aledi au mo'o onne nano makum,’ maa mi makan me'ene au lapida aile kam do'one? Man kokme'e mamwali ri molololo mie! Maledi au lap man aile mi makan raram leke mim do'on wawa'an nanumene mi mala au mo'o man aile mi wallum makan mai paharne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Au'ono man meur ka nadedem woi woin ma kan wa'an, la au'ono ma kan meur kan woi woin man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lo'o ik do'on au'ono ida woini, ik kauroin idewe onne inhawa au'ono. Ri ka neku ara woi lolo ruri roke raram, la ri ka neku anggur lolo au um'umu. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ri man wa'an, nin honorok aki wa'an, de wakunu panaeku man wa'an mamani. Ri man yaka, nin honorok aki yaka, de wakunu panaeku man yaka, ono inhawa ma namhara ik nuran, mai nano ik irhun raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Alhi'ihepenia mi mapolu Ya'u, ‘Makromod, Makromod,’ maa kam hi'i lernohi inhawe Ya a'aheheni ki mie? ");
INSERT INTO kjeNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ya ala wanakunu naho'ok ida ma na'ono ri ma nauroin na'ariri nakar wawa'an noro ri ma ka nauroin wake'e. Ri man mai Maya'u, la derne Ainu'u wanakunu de lernohie, ai onne naisa ");
INSERT INTO kjeNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ri ma nauroin na'ariri nakar wawa'an. Ai na'ir onno rorom leke na'ariri nakar onne lolo waku na'a'ar ma namlolo. Ende lere oir rulu lape mai na'o'e, nakar onne ka nawollo ono waku na'a'ar naruri memen. ");
INSERT INTO kjeNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Enimaa ri man derne Ainu'u wanakunu eni, la kan lernohie, ai onne naise ri ma ka nauroin na'ariri nakar wawa'an, de ka na'aririe lolo waku na'a'ar. Ende lere oir rulu lapa mai na'o'e nakar onne, pelek nadiporedi de yaka mouwedi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus wakuku heri onnenihe horu, An laa kota Kapernaum. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lolo onne Roma nin uluwakun arida aile la nina man howok ida man ai naramyaka rehi nakni'ir, na'akeki maki me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","An dernedi Yesus ai lolo onne ne, an hopon Yahudi rira leleher lalap ida woro'o laa rapanak Yesus mai hi'i wa'an nin man howok eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hir mai ne, rapanak an'anhedi ra'aheni, “Papee! Ai mauroin uluwakun ke'urauk ida nin man howok nakni'ir de yon hi'i nahenia Papa raram nodi pakuwala harome, ai mapanak Papa lan hi'i wa'an ke'e ono uluwakun onne ri wawa'an, ");
INSERT INTO kjeNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","la ai naramyaka iknik hair de na'aririyedi ainim kerei me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kame'ede Yesus noro man lariyala onnenihe laa wewerre. Hi lar wakuraniyedi uluwakun ke'urauk nina nakar ne, uluwakun onne hopon nina ri orwali ida woro'o rodi ai lirna laa kukunohi Yesus na'ahenia, “Eih! Yon Pape ki nakar me'e, ono ya'u inhoi penia Pape ki ainu'u nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ya'u eni man lolo yawa Pape, de kan wa'an ya'u laa pakromo noro Papa, maa lo'o Pape wekelle wanakunu lisir ida woro'o mehe, ainu'u ma nakni'ir wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ya auroin Papa nodi molollo hi'i wa'an ai, ono ya'u me'ene man derne nakani ri ma nodi molollo maya'u, la yo odi molollo ri namehin haenhi. I hopon ainu'u ma nasala ke'urauk, ‘Mala'a here!’ Hi rala'a. Ya'u polu mai, hir mai. Ya'u hopon ainu'u hophopon lolo nakar hi'i haida, hir hi'ie.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus derne nina wanakunu onneni, heheledi de, ne'el heri man lernohi onnenihe na'ahenia, “Loi honorok wawa'an panaeku eniyeni! Ri ma ka namwali Yahudi eniyeni, akin naili'il kokkoo! Lolo Israel ne'en raram Ka'u pakromala noro ri ma naisa eniyeni makun.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Onne horu, man lolo honopon onnenihe wali laa uluwakun ke'urauk onne nin nakar, la ma nakni'ir onne wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ka nalo'olala, Yesus noro Nina man lernohi pakunohi ramhara lolo onne rala'a laa leke ida naran Nain, la ri nammori lernohi Ai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wakuraniyedi leke onne nin nika lape ne, hir holikuku ri man le'u maki lolo nika lape mai paharne. Man maki onne tatana mo'oni mahaku aloloi, la inne namwalumedi me'e. Ri nammori nano leke onne lernohi maeke walwalum onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Makromod Yesus po'onedi maeke walwalum onneni ne, raram penuwedi ono naramyake de ne'el na'ahenia, “Yon mahere, ine!” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Enime'ede An laa na'urani maki eni la tukul nin daira'e. Man le'u enihe ramririyala la Yesus na'aheni, “Heih! Ma na'ikake, mamakedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Me'e'eni me'ede ma na'ikaka onne namaka, naikoredi, la wakunkunu me'e. Kame'ede Yesus ne'el nin mame, “Ine, o anum eni moriyedi wali'ur me'e de mala'a wawa'anedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Heri onnenihe ramka'uk rehi la ra'uli rasa'a Makromod Lalap ra'aheni, “Nabi lalapida maiyedi ika leken kalarna me'e! Makromod Lalap maiyedi leke paku Nin ri me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lirna ma na'ono Yesus Nin hini'i onneni raderre radaul lolo Yudea ne'en raramne na'akeme noro leke-leke ma aile herne waliwali na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanis nin man lernohi enihe do'odo'on Yesus haenhi, de wali mai konohi Yohanis Yesus Nin hini'i na'akeme. Ende ai napolu nin man lernohi woro'o, ");
INSERT INTO kjeNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","hopon hir laa ra'ukani Makromod Yesus na'ahenia, “Makromod penia man Makromod Lalap nouwedi mai noho wawan, ee am lapan ri namehin?” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ende ri woro'o onnenihe rakanedi Yesus ne, hi ra'ukani, “Makromod, Yohanis ma nodi oir ulutade ri hopon mayai mai ma'ukani Papa na'ahenia, ‘Papeni penia man Makromod Lalap nouwedi mai noho wawan, ee am lapan ri namehin?’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lere onne me'e de Yesus hi'i wa'an ri nammori ma nakni'ir noro rir apinha warna-warna. Ai nohiyedi hayakyaka nano ri raramne, la hi'i wa'an maktoko de do'on wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ende Yesus walha hi na'ahenia, “Wali lam konohi Yohanis inhawe mim derne la do'onedi me'e. ‘Ri man makan tokedi, makan mouwedi; ri ma ka nauroin nala'a, nala'ala'edi, ri man ulik yaka hi'ie, wa'anedi, ri man rohedi, derne wali'uredi, ri man makiyedi, mori wali'ur, la Makromod Lalap Lirna Wawa'an Eni rodi laa loikaruwedi ri ma na'alehe naulinu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Enla ri ma namkene akin naili'il Ya'u, ai akin nahuwa'anedi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanis nin hophopon onne waliyedi ne, Yesus konohi heri onne panaeku ma na'ono Yohanis. Ai na'aheni, “Minim panaeku inhawa mim laa noho mamun ma napro'uk derne Yohanis wakukue? Lo'o mim laa leke po'on ri ma akin ka namkene naisa penek larlari man anna huhue? ");
INSERT INTO kjeNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lo'o mi raram nodi lam po'on inhawa lolo enne? Lo'o mi lam leke po'on ri man nair nainair ma'aruru harome? Ka! Ri man nair nainair ma'aruru la manin morimori karu, nadedem min rai nina nakar! ");
INSERT INTO kjeNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ende hi'ihepenia mi raram nodi laa enne? Lo'o mi raram nodi lam po'on nabie? Namlolo kokkoo mim do'onedi nabi, maa nabi onne namwali nabi man kulu narehi nabi nadedem. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nonolu eni Makromod Lalap wekel Yohanis ma namwali Nin hophopon lolo Horok Lap na'ahenia, ‘Ya'u hopon Ainu'u ma nodi lira na'ahari kalla nolu mai leke hari kalla ki O.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesus na'aheni wali'ur, “Horhorok! Rakan lere eni, lolo noho wawan na'akeme ri kaale man kulu narehi Yohanis man ulutadeni, maa nano lere eniyeni ri na'akeme man Makromod Lalap nodi molollo, kade hi onne tana rehi, hir lernala rere'e haharu narehi ai.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Heri noro idewe man ra'uk paipair enihe derne Nin wanakunu ma na'ono Yohanis onneni ne, hir kokala wawa'an Makromod Lalap Lirna, ono nonolu hi raledi kemen Yohanis ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Enimaa ri Parisi roro meser-meser ma nauroin keneri hono'ok wawa'an ra'okuledi Makromod Lalap Nin panaeku ma na'ono hi kemen, ono hi penia ramhene rala kemen Yohanis ulutade haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus wakunu wali'ur na'ahenia, “Ya aho'ok ri mormori ku eniyeni noro inhawe? Hi raisa inhawe? ");
INSERT INTO kjeNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hi raisa tatana man ha'ar ramwali muku woro'o ma naikoro ra'aromo lolo pasar raram, la muku ida napopolu muku namehin ra'aheni, ‘Ai mou poloit modi mahinara soksok murmura, maa mi mamhene moro mayai pe'uk waur. Enla ai mahinara hanara man hi'i ri nahere, maa mi mamhene mahere moro mayai!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Namnehe noro onne, lere Yohanis ma nodi oir ulutada mai wakuku ri, ai na'aluli kemen ka na'ak, la ka nomun arak. Enla mi mamhene kokale la ma'aheni, ‘Ai onne, hayakyaka hu'uhu'ur raramne.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Enla Ya'u, Ri Mormori Anan mai, Ya a'ak Yo omun mamani, maa mi mamhene kokala Ya'u haenhi ma'aheni, ‘Po'onala ri onne! An suk na'ak nammori, nomun manha mamani, Ai nawaur noro ri man ra'uk paipaire, la minwuku noro ri man hi'i dohohala mamani!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kade mi mamhene kokala mayai, maa ik kauroin Makromod Lalap Nin honorok panaeku mou ono ik do'on Nin man lernohi rir morimori ma'aruru la namlolo.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ler ida ri Parisi ida naran Simon lariyala Yesus mai nore na'ak. Yesus mai nin nakar de ra'ak wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lolo kota onne, maeke ida aile man hi'i dohohala nammori. An dederne Yesus maha na'ak aile ri Parisi onne nin nakar, de an mai nodi wuru wala'ula'u ra'akekene lolo potol rodi waku hi'ie. Wuru noro potol onne wella ai wawan wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Maie ne, ai namriri Yesus kili'urne na'urani ein, mene awikorno nahere de makan oron napa'uk Yesus ein. Enime'ede ai nodi nina muruk soru na'akisi. Horu ne, an masi ein la nodi wuru wala'ula'u onne halle Yesus ein. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ri Parisi man lariyala Yesus eni po'onedi panaeku onneni ne, noro akin wakunu na'aheni, “Lo'o Yesus namwali nabi kokkoo, hi'ihepe Ai ka nauroin maeke man tukul Ai eni, inhoi? Ai eni maeke man hi'i dohohala nammori menee!” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Enime'ede Yesus ne'el ai na'ahenia, “Simon, I raram nodi kukunohi panaeku ida woro'o ki o.” Simon walhe, “Kukunohi ke'e, Papa Meser.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus na'aheni, “Ri woro'o herre ri ida nin kupan de rir okon raka aile. Nano woro'ohe, ri ida nin okon raka alam rahu wolima nin naiwe'el, la namehin eni nin okon raka alam wellima nin naiwe'el. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lere alam pair rir okon raka rakanedi ne, rir kupan kaale de kar paekunala paire or'okon raka onne wali'ur. Enimaa or'okon raka na'aheni, ‘Na'amoli ke'e, yon paire me'e.’ Ende nano woro'ohe, inhoi ma naramyaka or'okon raka onne narehi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon walha, “Ya ahinorok manin okon raka nammori rehi eni lo'o naramyak rehi or'okon onne.” Yesus na'aheni, “Num panaeku namlolo.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus wali kemen laa po'onala maeke onne la ne'el Simon na'ahenia, “Po'onala maeke enie! Ya'u mai num nakar, ka mala oir modi wuri Ye ei'u, maa ai nodi makan oron wuri Ye ei'u la nodi nin murukne soru na'akisi. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Idediyeni Ya'u mai num nakar, o kam masi Ya'u, maa maeke eni kan ren masi Ye ei'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ka mala wuru loile Yu uluwak'u leke horhawa Ya'u, maa maeke eni halledi wuru wola'ula'u soruwedi Ye ei'u me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ende Ya'u konohi o, ainin raramyak man lap onne kukul nahenia an lernala ampun nin dohohala rahu onne, maa ri ma nin raramyak tarane kukul nahenia an lernala ampun tarana haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Enime'ede Yesus na'aheni maeke onne na'ahenia, “Inai, num dohohala Ya a'ohu ahaledi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ri ma noro Yesus ra'ak wewerre onnenihe ida ma ne'el ida na'ahenia, “Ri eni inhoi penia Nin molollo aile na'ohu nahala ri nin dohohala?” ");
INSERT INTO kjeNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kame'ede Yesus ne'el maeke onne na'ahenia, “O akim naili'il Ya'u de Makromod Lalap na'ohu nahaledi o nano num dohohala nin molollo me'e. Mala'a wawa'anedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka nalo'ol ne Yesus lan kuli leke-leke noro kota-kota loikaru Lira Wawa'an konohi hi'ihehewi Makromod Lalap nodi molollo ri mormori. Enla man lernohi pakunohi idaweli woro'o enihe roro Yesus laa wewerre, ");
INSERT INTO kjeNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","noro idewe maeke wo'irha man Yesus hi'i wa'anedi nano rir apinha me'e me nohiyedi hayakyaka nano raramne. Maeke man lernohi Yesus mamani onnenihe: Maria ma nadedem rapolu Magdalena man Yesus huriyedi nano hayakyaka wo'ikku man minle raramne, ");
INSERT INTO kjeNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana (Khusa hono), Susana noro maeke nammori namehin. (Khusa onne namwali uluwakun ri man howok lolo rai Herodes nin nakar.) Maeke onnenihe na'akeme lernohi Yesus, la rodi rir kupan aimehi ilitolle Ai noro Nin man lernohi pakunohi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nadedem ri nammori nano leke-leke mai rawaur noro Yesus, de ler ida Yesus wakunu nodi wanakunu naho'ok ida na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Man howok kirna ida nodi wini hawono lan wahair kirna. An wahair ne, wini heruwali nadiyaur kalla wawan de rin hihir hamar la manu liwliwar mai ra'an mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Heruwali nadiyaur elimo'o wakwaku, de moriyedi, maa pelek namlau ono elimo'o napro'ukedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wini namehin nadiyaur ruri roke raram, de mori, maa ruri roke eren lolode de elewesnedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Enimaa, wini heruwali nadiyaur laa elimo'o man meur, de mori wawa'anedi rakan ihin ennen rewen rahu.” An loikaru panaeku onne horu, wakau na'ahenia, “Lo'o mi kilinum aile, makaniyala wawa'an!” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nin man lernohi pakunohi enihe ra'ukani Ai wanakunu naho'ok onne nin panaeku inhawa. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ende An walhe na'ahenia, “Makromod Lalap nala woroin mi leke mauroin hi'ihehewi Ai nodi molollo ri mormori. Enimaa Ya'u nair wanakunu naho'ok eniyeni wakuku ri ma akin ka naili'il leke, ‘Hir do'odo'one, maa ka rauroin inhawa hir dodo'on; hir derderne, maa ka rauroin panaeku ida.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Wanakunu naho'ok idedi eni nin panaeku hi'i heheni: Wini hawono onne Makromod Lalap Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wini ma nadiyaur kalla wawan onne, naisa ri man dernedi Makromod Lalap Lirna me'e, maa Hayakyak Makromon mai nala wali'ur nano akinhe leke yon akin naili'il la yon hi rahinuri nano rir dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wini ma nadiyaur lolo elimo'o wakwaku onne, naisa ri man dernedi Lir Wawa'an eni, la kokale noro wawa'an, maa ka na'a'ar akinhe. Onne penia lere Hayakyak Makromon mai ken patal, hir waliyedi kili'urne. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wini ma nadiyaur lolo ruri roko raram onne, naisa ri man dernedi Lirna Wawan me'e, maa hir ma'irhu rira morimori lolo noho wawan eni, la ranoin noho wawan eni nin linikir kanaru noro nin soksok murmura mamani. Onne penia hi kar kokala Makromod Lalap Lirna wawa'an, de hi raisa wini ma kan woi wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Enimaa wini ma nadiyaur lolo elimo'o ihi man meur na'ono ri man derne Makromod Lalap Lirna, la rasale rodi aki ma namdudu la man mou. Rir hini'i wenewhe man wa'an onne nodi kunukunohi nahenia hi ramkene lernohi Makromod Lirna mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ri kan lokon wadu moriyedi nanumene nodi e'enoir honowale, ka eni nale loiyedi leu lehern, maa ai nala loile wadu onno man kulu leke ri na'akeme man mai nakar raram do'on nin roprope. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Makromod Lalap Lirna namwali ropropo, de ik kauroin nahenia ha wo'ira na'akeme man suwsuwar na'amoli rin do'on rauroinedi, la panaeku ma kan mou makun na'amoli ralhari mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Onne penia Ya a'aheni madiyaka wawa'an hi'ihewi mim loi honorok Makromod Lalap Lirna Wawan, ono ri man kokala Ai Lirna wawa'an, eren rauroroin, maa ri ma kan kokala Makromod Lalap Lirna Wawan, rir woroin ma aile, raledi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ler ida nine Yesus inna noro mo'oniwalinhe mai leke rore pakromala, maa kar paekunale wakurani Ai ono ri namansa rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Rin laa kukunohi Ai na'ahenia, “Papa Meser, Num mame noro mo'oniwallumhe aile paharne. Hi raram nodi roro Papa pakromala.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","An walhale na'ahenia, “Inhoi man derne Makromod Lalap Lirna Wawan la hi'i wewhe, ai onne Ainu'u mame noro I mo'oniwal'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ler ida wali'ur Yesus ne'el Nin man lernohi pakunohi enihe, “Mai, ik ha'a korkore hopol laa oir lape wali.” Kame'ede hir ha'a korkore wawan ne, hopol me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hir rakanedi heleken ne, Yesus namkukuru me'e. Ramlilinnohi kahi anna lapa mai nalwalile korkore de naheri nawali, la wo'o ha'a na'enu korkoro me'e de na'ikeki keper me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Enime'ede man lernohi pakunohi laa ramake, ra'aheni, “Makromueee! Peleke mamaka! Pakuwala yai nanu, kalo'o ik maki me'e!” Yesus namriri komdere kahi anna lapa na'ahenia, “Heih! Kahi anna lapa, mamlinedi here!” Idewe kahi anna lapa onne namlina namkaiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Horu ne, ne'el hi, “Alhi'ihepe mi akim ka naili'il Maya'ue?” Hi na'akeme polletilu la ramka'uk rehi, la ida ma na'ukani ida na'ahenia, “Leher eni inhoi, penia Ai nodi molollo komdere kahi anna lapa heheni?” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus noro Nin man lernohi pakunohi enihe hopol mamani rakan manin Gerasa nin nohe ma aile oir lap Galilea wali kimur karanna. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus kopuredi laa herre raram ne, mo'oni ida nano leke onne mai pakromo noro Ai. Mo'oni onne, hayakyaka huhu'ur raram nalo'oledi me'e, de kan nair nainair la kan minle nin nakar, maa nadedem holi ku'il-ku'il ma namwali makileke. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","An do'onedi Yesus ne, an wakau nanumene nahinonowedi Yesus kalarna la wakau naruri na'ahenia, “Yesus, Makromod Lalap Ma Narehi Ma Nalewen Anan O! Num panaeku inhawa noro maya'u? Ya apanak yon hukuma'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","An wakunu heheni ono Yesus hoponedi hayakyaka man huhu'ur raramne namharedi. Kade ri namehin rodi rantan dasledi la radiyaka mo'oni onne mamani, maa lere romromo hayakyak onne nale ke'eke'el an'anha noro rurilai leke we'eredi rantan onne, la rakerne ai lari laa noho mamun. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kame'ede Yesus na'ukaniyale, “O naram inhoi?” An walhe na'ahenia, “I naran ‘Legiun’ (napa'ahne, ‘riwriwan rahrahu’),” ono hayakyaka nammori hu'uhu'ur raramne. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hayakyaka onnenihe rapapanak an'anhedi Yesus leke yono hopon hi laa Lo'o Lalap man roromne kar ho'oknale. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lere onne wawi ukun lap aile wo'or leren kan ko'uwala maha ranoin ya'ane. Hayakyaka onnenihe rapanak Yesus hurinohi hi laa hu'urle wawi onnenihe raramne. Kame'ede Yesus hurinohi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ende hayakyak onnenihe ramharedi ri onne lar hu'urle wawi onnenihe raram. Ideweni ne, wawi ukun onne lari laa wauwedi werne oir lap Galilea raram, de maki mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Man wa'an wawi onnenihe do'onedi inhawa ma namwali onneni ne, hir lariwewer leke-leke lolo onne rakan kote raram raderre radaul Yesus Nin hini'i eni laa ri na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ende ri nammori mai leke meher po'on inhawa ma namwaliyedi eni. Rakanedi ne, hir do'on mo'oni man idedi hayakyaka huhu'ur raramne, naikokoro aile Yesus kalarna. An nairedi nainair la ka na'iseri me'e, de heri onne ramka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Enla ri man do'odo'on panaeku ma namwali onne kukunohi heri onne hi'ihehewi Yesus hi'i wa'an ri man hayakyak huhu'ur raram onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kame'ede manina Gerasa na'akeme laa rapanak Yesus pelek namhara lolo onne ono ramka'uk rehi. Ende Yesus ha'a laa korkoro wawan la hopol wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kan hopol makun, ri man idedi hayakyaka huhu'ur raram onne laa napanak lernohi Yesus, maa kan hurinohie la hopon na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wali laa num nakar here. Rakanedi ne, kukunohi ha wo'ire man Makromod Lalap hi'iyedi ki o me'eni.” Enime'ede ri onne laliwewer nin leke raram konohi inhawe man Yesus hi'i namwaliyedi ai kemen me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus waliyedi nano oir lapa wali ne, ri nammori kokale noro wawa'an ono mahar lalapan Ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Enime'ede uluwakun Yahudi rir kerei ida ma naran Yairus mai rawa Yesus kalarna napanak an'anhedi leke An mai nin nakar, ");
INSERT INTO kjeNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ono anan maeke mahaku, nakni'ir de na'akeki maki me'e. Anan onne nin anna idaweli woro'o. Yesus kan rakan nin nakar makun ne, ri nammori lernohi la lupurale rasese wake'e lolo kalla. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lere onne maeke ida aile man lernohi haenhi, la nina apinha rare wau anna idaweli woro'o me'e. Kade ai na'oluwedi nin hahaa wo'ire nodi pair ma na'inapin enihe, maa ri mahaku kan paekunala hi'i wa'an ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","An paeku nahenia lo'o an tukulala Yesus Nin rain mehe, nin apinhe wa'anedi. Ende an laa na'urani Yesus lolo kili'urne, tukulala Nin rain nanaru ki'il. Me'e'eni me'ede nina rara wauwau onne nekedi de wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus na'ukani, “Inhoi man tukulA'u?” Ri mahaku ka na'aheni hir tukulale de Petrus na'ahenia, “Papa Meser, ri nammori sese Pape menee!” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesus na'aheni, “Maa ri ida tukuledi Ya'u me'e ono Ya auroroin ke'eke'el an'anha heruwali namharedi I kem'u me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Maeke onne nauroin nin hini'i onne kan suwarala de nodi kemen ma narururu mai nalwali yawa Yesus kalarna. Lolo heri onne kalarna an konohi hi'ihepeni an tukul Yesus, la hi'ihehewi nin kini'ir onne idewe wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Horu ne, Yesus na'aheni, “Mame, o akin naili'il Maya'u, de onuma apinha wa'anedi me'e, mala'a wawa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus wakunkunu ne, Yairus ma namwali uluwakun kerei onne nina hophopon wahwahan ida mai konohi Yairus na'ahenia, “Pape, tatana maekane aran horuwedi me'e, de yono ma'o'o Pap Meser me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dernedi onne, Yesus konohi Yairus na'ahenia, “Yono mamka'uk, maa akim naili'il Maya'u mehe, la o anum wa'an wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hir rakanedi Yairus nin nakar ne, Yesus namhene ri noro Ai laa romleher, naukara Petrus, Yohanis, Yakobus, noro tatana inna aman mehe rore laa raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Heri na'akeme raherhere kanihi tatana onne, maa Yesus hopon na'ahenia, “Yon mahere! Ai kan maki, maa namkuru mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Enimaa heri ralau Ai ono rauroin nahenia tatane makiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kame'ede Yesus nasala tatana onne liman na'aheni, “Inaiye, mamakedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tatana aran wali wali'ur la me'e'eni me'ede namaka namririyedi. Enime'ede Yesus hopon hi rala hanana'an ai na'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inna aman hehel rehi, maa Yesus hopon hi yon kukunohi ha ma namwali eni ri namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus poluwedi Nin man lernohi pakunohi idaweli woro'o maiwuku ne, Ai nala ke'eke'el an'anha noro molollo hi leke rohi hayakyaka nano ri raram la hi'i wa'an kini'ir warna-warna. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","An hopon hi laa loikaru lirna man konohi hi'ihehewi Makromod Lalap nodi molollo ri mormori la hi'i wa'an ma nakni'ir. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","An nou hi na'ahenia, “Mala'a, maa yono modi haida-haida me'e. Yon modi au ke'ke'en, oir wa'alehere, kupan, rou soke, me nainair herherre. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lo'o mim laa nakar ida haromo, mamkene lolo onne hehen nanumene mamhara leke onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Enla lo'o leke ida kar kokala mi, mamharedi leke onne. Mamharedi leke onneni ne, disnedi elimo'o hapu man aile mi eium raram, leke namwali tanada nahenia mi ka modi yodiwara ida ono leke onne raramne kar kokala mi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesus nounaku hi horu, hi rala'a laliwewer leke-leke raderre radaul Makromod Lalap Lirna Wawa'an eni la hi'i wa'an ma nakni'ir lolo ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lere onne rai Herodes nodi molollo Galilea. An dederne Yesus Nin hini'i na'akeme onneni ne, mehe kakaiyedi ono ri heruwali ra'aheni, “Yohanis ma nodi oir ulutade ri, mori wali'uredi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Heruwali ra'aheni, “Elia hariyedi ho'o me'e,” la ri namehin ra'aheni, “Ai onne namwali nabi ida nano nabi nonolu enihe man mori wali'uredi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes na'aheni, “Yohanis eni, ya'u pekuwedi uluwakun me'e, de ri man ya'u derderne eni inhoi penia hi'i panaeku rahu man lewlewen enie?” Onne penia nahehe leke noro Yesus pakromo. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Rakanedi lere Yesus Nin hophopon ma nodi Makromod Lalap Lirna enihe wali mai ne, hir kukunohi Yesus inhawa hir hi'iyedi me'eni. Horu ne, Yesus noro hi laa onnida man ri ka nadedem minle na'uranrani leke ida naran Betsaida. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Enimaa ri nammori dederne rauroiroin rira lalaa eni de lar lernohi Yesus. Hir rakanedi Yesus ne, An kokala hi la wakuku hi panaeku ma na'ono hi'ihehewi Makromod Lalap nodi molollo ri mormori. Enla An hi'i wa'an ma nakni'ir haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na'ikeki lere helem me'e, man lernohi pakunohi idaweli woro'o enihe mai Yesus ra'aheni, “Pape, mai eni noho mamun la nako'uwedi leke-leke, de hopon heri eni rala'a ranoin hanana'an noro onno ramkuru lolo leke-leke noro awak-awak ma aile waliwali eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Maa Yesus na'ahenia, “Mi mehe mala hanana'an hi ra'an.” Hir walhe, “Ainima roti kem wolima noro i'in kem woro'o mehe. Lo'o Onum panaeku am laa weli hanana'an noknokor heri rahu eni ra'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Lere onne aki mo'oni mehe ri riwan wolima. Enime'ede Yesus ne'el hi na'ahenia, “Hopon hi raikoro hi'i lopun-lopun, lopun ida lo'o muku ri wellima.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Enime'ede hir lernohi Yesus Nin honopon. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Heri onnenihe raikoredi ne, Ai nala roti kem wolima noro i'in kem woro'o onne, niliha'a laa wawan mene napanak trimkasi Makromod Lalap. Onne horu, An a'un roti la uku i'in onne nala kanile Nin man lernohi pakunohi enihe leke ha'ar heri ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ende heri na'akeme ra'an hehen nanumene pehur mouwedi. Horu ne, man lernohi pakunohi ra'ukwuku hanana'an ma narehi onne lunu idaweli woro'o. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lerida Yesus noro Nin man lernohi pakunohi memehedi lolo onnida, la Yesus mahan hi'i lir napanak. Horu ne, Ai na'ukanihe na'ahenia, “Heri ra'aheni Ya'u eni inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hir walha na'ahenia, “Heruwali ra'aheni Yohanis ma nodi oir ulutada ri, heruwali ra'aheni Elia, la heruwali ra'aheni nabi ida nano nonolu eni man mori wali'uredi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ai na'ukani hi wali'ur na'ahenia, “Emene lernohi minim panaeku, Ya'u eni inhoi?” Petrus walhe na'ahenia, “Papa penia Kristus man Makromod Lalap kikan namwali Rai laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kame'ede Yesus nou an'anhedi hi na'ahenia, “Onne namlolo, maa yom konohi ri Ya'u eni inhoi! ");
INSERT INTO kjeNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Horhorok! Ya'u ma namwali Ri Mormori Anan, na'amoli lernala wewerek pananaka rahu, la Yahudi rir leleher lalapa, imam, roro meser Horok Lap enihe kar kokala Ya'u, de resne Ya'u. Enimaa rakan lere wokelu Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Onne horu, Yesus na'aheni ri na'akeme lolo onne na'ahenia, “Ri man raram nodi lernohi Ya'u, yon nodi nina raram nodi aimehi, maa na'uwara nina au kekiyowok akilere, la lernohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ya a'aheni eniyeni ono inhoi namka'uk ihin kemen maki de namhene huri nin morimori lolo noho wawan eni, ai onne kan lernala or'ori dardari ma namlolo. Maa ri man huriyedi nin morimori lolo noho wawan eni leke lernohi Ya'u, ai onne lernala or'ori dardari ma namlolo ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lo'o ri ida manarna noho wawan nin ha wo'ira na'akeme, maa kan lernala or'ori dardari ma kan horu, nin panaeku onne kan min haida. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Inhoi nawawa konohi ri namehin na'ahenia, ‘Ya'u lernohi Yesus noro Nina wanakuku eni,’ lere Ya'u ma namwali Ri Mormori Anan wali wali'ur mai noho wawan eni, Ya awawa ai haenhi. Lere onne Yo odi Ainu'u ke'eke'el an'anhe noro Ya Am'u Nine ke'eke'el an'anha ma narehi nalewen, la Yo oro Hophopon a'am raram man moumou dewdewe enihe kopur mai noho wawan. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Horhorok Ainu'u nou ma na'ono eniyeni: Mi ri man min lolo eni heruwali kam maki makun, mim do'on mauroin hi'ihehewi Makromod Lalap nodi molollo mai noho wawan eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ai nala wanakuku eni horu ne, lo'o domeku ida wali'ur Yesus naka'uk Petrus, Yohanis, noro Yakobus wakiha'a wo'or ida leke hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Rakanedi wo'or tilu ne, Yesus mahan hi'i lir napanak, oin makan namehiyedi la Nina nainaire nahinerredi namwali wawarhe la siksika naise noho lerlere. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ramlilinnohi ri woro'o aile roro Ai wakunkunu. Ri woro'o onne Musa noro Elia. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hir mai ralhari kemen lolo siksika lerlere man mai nano a'am raram la wakunkunu Yesus Nin makmaki ma ka nalo'ol me'e namwali lolo kota Yerusalem eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mahan wakunkunu ne, Petrus noro nin kalla wali enihe ramkukuru, maa ramaka de po'on Yesus Nin siksika lerlere man ma'aruru wake'e la mahanoro ri woro'o wakunkunu. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ri woro'o enihe na'ikeki rala'a ne, Petrus ne'el Yesus, “Papa Meser, wa'an rehi ik min mai eni me'e, de lo'o wa'an rehi ai ma'ariri heuheu wokelu lolo eni: ida Papa Meser Nine, ida Musa nine, la ida Elia nine.” Maa Petrus wakunu mehe, ono ai ka nauroin ha ma namwali onne inhawa. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mahanoro wakunu ne, kakam ida mai pupinalahe de ramka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hir derne lirida nano kakam raram na'aheni, “E'eni Ya An'u, Ya'u mehe nili! Derne makani Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dernedi lira onne horu, hir po'on Yesus memehedi me'e. Lere onne man lernohi pakunohi onnenihe suwarala panaeku ma namwali onne de kar konohi ri namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rakan oreki, hir kopuredi nano wo'or ne, ri nammori aile mahar lalapan pakromo noro Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lolo heri onnenihe, ri ida aile wakaukau na'ahenia, “Papa Meser, ya apanak ke'e de mam pakuwala ya an'u ke'e ono ya an'u mahaku mehe! ");
INSERT INTO kjeNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lere romromo hayakyaka hu'uredile raramne ne, an wakau naruri, kemen narururu, la aparne nawurwuri. Nalo'ol mene hayakyak onne namhare la nin panaeku nano'onyaka ainu'u tatane! ");
INSERT INTO kjeNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya apanakedi Papa Nina man lernohi pakunohi enihe rohi hayakyaka man aile raramne, maa kar paekunala rohie.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Enine Yesus walha na'ahenia, “Hoih, mi ri ku eniyeni! Mi kam derne makani la mi akim ka naili'il kokkoo. Yo oro mi nalo'oledi me'e, maa mi akim ka naili'il Ya'u wawa'an makun! Rakan ma'anana ho'o Ya'u kerhu oro mi mene mi akim naili'il kokkoe? Modi num tataneni mai.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hi roro tatana onne mai ne, hayakyaka walikore laa elimo'o wawan la kemen narururu, maa Yesus dadiyale na'ahenia, “Heih! Hayakyak o, mamharedi tatane here!” Me'e'eni me'ede hayakyak onne namharedie la tatana onne wa'anedi. Horu ne, Yesus nala kanile aman wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Heri onnenihe po'onedi Makromod Lalap Nina ke'eke'el an'anhe me'e de hir polletilu. Hir mahar polletilu Yesus Nin hini'i onne, Ai ne'el Nin man lernohi pakunohi enihe na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Loi honorok wawa'an Ainu'u wanakunu eniyeni: Ka nalo'ol me'e ri na'olu Ya'u ma namwali Ri Mormori Ananne kanile ri mormori liman raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Enimaa hi ka rauroinnala Nina wanakunu onneni nin panaeku ono nasinunuwar hi. Enla hi ramka'uk de ka ra'ukani Ai panaeku onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus Nin man lernohi pakunohi enihe ida ma nasesi noro ida panaeku ma na'ono inhoi man kulu narehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus nauroiroin rir honorok panaeku de napanak tatana tutusiyanida mai namriri herne. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ai ne'el hi na'ahenia, “Inhoi kokala tatana ma naise eniyeni ono an lernohi Ya'u, an kokaledi Ya'u me'e haenhi. Enla inhoi kokala Ya'u, an kokaledi Makromod Lalap man hopon Ya'u mai haenhi. Onne namlolo ono man tana narehi, penia namwali man lap narehi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Horu ne, Yohanis konohi Yesus na'ahenia, “Makrom'u, am do'on ri ida nohi hayakyaka nodi Papa naran, maa am kawale ono ri onne iknik ri, ka.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Maa Yesus na'aheni, “Yon mim kawale ono inhoi kan ewek kawala mi, onneni minim mukue.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na'ikeki rakan lere alam Yesus nakinikan laa a'am raram Ai mehe nala kenekrohu nala'a laa Yerusalem la namhene wake'e haida kawala Nin kenekrohu onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hi rala'a ne, An hopon Nin ri heruwali rolu laa lekida lolo Samaria leke ra'akenedi mene An rakan lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Enimaa manin leke onne dernedi Ainin panaeku laa Yerusalem de ramhene kokale. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Man lernohi pakunohi woro'o, Yakobus noro Yohanis, do'on rauroin onneni ne, hir ra'ukani, “Makromod, lo'o Pape raram nodi ai mapanak aiye nano a'am mai harnedi ri eniyenihe?” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Enimaa Yesus po'onalehe la dadiyala hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Onne horu, hi rala'a laa leke namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hi rala'ala'a ne, ri ida ne'el Yesus na'ahenia, “Pape, ya'u raram nodi lernohi Papa laa ewi-ewi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus na'aheni, “La'u nina ku'il aile, manu liwliwar nina wonno aile, maa Ya'u, Ri Mormori Anane, Ya a'alehe nakar leke ren warnala.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kame'ede Ai ne'el ri ida wali'ur na'ahenia, “Lernohi Ya'u.” Maa ri onne na'aheni, “Makrom'u, mala leken ya'u ke'e de waliyala laa nakar karuwedi ainu'u papa nanumene i wali mai lernohi Papa wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Enimaa Yesus na'aheni, “Na'amoli ri man maki meher karu rira makie! Lam wakuku ri hi'ihehewi Makromod Lalap nodi molollo Nin ri!” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ri namehin na'aheni wali'ur, “Makrom'u, i raram nodi lernohi Makrom'u, maa malala leken maya'u la'u konohiyala ainu'u nakar raram nanu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Maa Yesus na'aheni, “Ri ma namkene howok kirna yon hurinohi panaeku namehin kawale. Onne namnenehe noro ri man ilitolle Makromod Lalap Nin honowok la raram nodi Makromod Lalap namwali nin Rai. Lo'o ai nahinorok nin ri leleher me nin linikir kanaru mehe, ai ka namkene lernohi Makromod Lalap de nin honowok ka namlolo.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Horu ne, Makromod nili ri weli'ikku nano ri man lernohi Ai, la hopon hi roluwedi Ai laa leke-leke noro onno na'akeme man An paeku lalaa enihe. Rira lalaeni nakakar ri wororo'o lolo kalla ida. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ai ne'el hi na'ahenia, “Noho ihin ennen nammori, maa ma na'ili nadai tarana mehe. Ende kapanak Orkirneni, Makromod Lalap, leke nala man howok mai na'ili nadai Nina kirna raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mala'a here, maa horhorok! Ya'u hopon mim laa mamkene noro ri man ailanna, de mi maise pipdumana man minwuku noro ahu merwui. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mim laa, yon modi rakuraku kupan, rousoke, me pakpak ei leke herre, la yon moro ri wakunu nalo'ol lolo kalla wawan. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mim laa ri nina nakar ma'aheni, ‘Moiliwi mahuwele mai nakar raram eniyeni.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lo'o man minle nakar onne kokala mi noro wawa'an, hir lernala moiliwi mahuwele man mi mamala onne, maa lo'o kar kokala mi wawa'an, hi kar lernala moiliwi mahuwele onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lo'o rin kokala mi minle nin nakar, mo'on momun inhawa hi rarala ki mi, ono wa'an rehi ri man howok kokala mahmaha awenne ihin ennen nano rir honowok onne. Enla mamkene lolo nakar onne, yom laa nakar namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Lo'o mim rakan leke ida, la leke onne ne'en raramne kokala mi, mo'on momun inhawa hi rarala ki mi! ");
INSERT INTO kjeNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hi'i wa'an ma nakni'ir lolo leke onne la konohi leke raramne na'ahenia, ‘Lere alam Makromod Lalap nodi molollo ri mormori na'uraniyedi me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Enimaa lo'o mim rakan lekida, la leke raramne kar kokala mi, mala'a lolo leke onne nin kalla lape ma'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Heih! Am disnedi leke eni nina elimo'o hapu ma aile ai eum raram lolo mi kalarum leke na'ori honorok mi na'ahenia mi ma'okuledi mayai. Maa yon hamlinu! Lere alam Makromod Lalap nodi molollo ri mormori na'uraniyedi me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Horhorok! Rakan lere alam Makromod Lalap hukum ri na'akeme, manin leke onne lernala hunukum man werek narehi nano manin kota Sodom nonolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mi manin Korazim noro Betsaida, mim mayo'o wake'e. Ya'u hi'iyedi tanada nammori ri kan dodo'onnala makun mi herne kalarna, maa mi kam herre minim morimori ma ka namloleni, mai derne makani Makromod Lalap Nin panaeku. Lo'o Ya'u hi'i tanada rahu onne lolo ri manin kota Tirus noro Sidon, ri ma ka namwali Yahudi enihe, hir nairedi homnono yak, loiyedi apu hi uluwakun leke namwali tanada hir herredi rira morimori ma ka namlolo me'e, la derne rakani Makromod Lalap Nin panaeku me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Horhorok! Rakan lere alam Makromod Lalap naho'ok nakail ri na'akeme, ri manina kota Tirus noro Sidon rira hunukum namrana narehi mi! ");
INSERT INTO kjeNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mi manin Kapernaum, mi mauroin lo'o ra'uli rasa'a mi lolo a'am raram? Ka! Makromod Lalap sopol mi laa kawali pire ai porom raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Enime'ede Yesus konohi Nin man lernohi enihe na'ahenia, “Inhoi man derne nakani mi, an derne nakani Maya'u, la inhoi ma na'okul mi, na'okuledi Maya'u. Enla ri ma na'okul Ya'u onne, na'okuledi Makromod Lalap man hopon Ya'u mai eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kame'ede man lernohi weli'ikku onnenihe lar lernohi Yesus Nin honopon, la wali mai rodi aki ma nahuwa'an rehi la ra'aheni, “Makromodee! Am lae ne, hayakyaka me'ene derne rakani mayai ono ai modi O Oin Naranne!” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus na'aheni, “Ya'u do'onedi Hayakyak Makromon nadiyaur nano a'am raram laa yawa naise noho lerlere. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ya aledi molollo ki mi leke hamarala haimoke noro sayorne, la rehiyedi minim arwali nin ke'eke'el an'anhe haenhi. Haida kan hi'i apinha mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Enimaa yono sokmura ono mi modi molollo hayakyaka enihe, maa wa'an rehi sokmura ono mi naramne horokedi aile a'am raram me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Me'e'eni me'ede Roh Kudus nodi molollo Yesus penia Ai akin nahuwa'an rehi de kikan lirna laa Makromod Lalap na'aheni, “Ya Am'u, ma nodi molollo a'am noro noho wawan na'akeme, Ya apanak trimkasi nammori ono Om kukul ha wo'ira ri ma nin woroin kan kuku kan nokor, maa Om suwarala ha wo'ira nano orworoin roro ma nauroin ha wo'ira lolo noho wawan enihe. Pape, num hini'i onne nahuwa'an O akim.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","An hi'i lir napanak horu ne, Yesus na'aheni heri wali'ur, “Ha wo'ire na'akeme Ya Am'u naledi Ya'u me'e. Ya Am'u mehe nauroin Ya'u ma namwali Ananne, ri namehin, ka. Ya'u mehe auroin Ya Am'u, la inhoi-inhoi Ya ala woroin, hi rauroin Ya Am'u haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Horu ne, Yesus wali po'onala Nin man lernohi pakunohi enihe na'aheni, “Mim kokaledi rere'e haharu man lapa narehi ono mim do'onedi Ainu'u hini'i na'akeme me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Horhorok! Nonolu nabi-nabi roro rai-rai nammori, hi raram nodi do'on inhawa mim dodo'on lere eniyeni, la raram nodi derne inhawa mim dederneni, maa lere onne Ka'u mai noho wawan makun de kar do'on la kar derne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ler ida meser ida ma nauroin Makromod Lalap Nin keneri hono'ok wawa'an mai ken Yesus leke kuku sala Ai. Ai namriri na'ukani, “Pap Meser, ya'u hi'i inhawa leke lernala or'ori dardari ma kan horu?” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus walha na'ahenia, “Horhorok man aile lolo Horok Lap raram wakuku inhawe? Om lese onne mauroin inhawa panaeku?” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Meser onne walhe, “Modi mi honorok akin, mi irhun raramne noro minim ruri pe'el na'akeme maramyaka Makromod Lalap ma namwali Makrommu. Enla maramyaka minim ri mormori wali naise maramyaka mi kemmu haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus walhe, “Num wanalha onne namlolo de hi'i wewhe lernohie leke om lernala or'ori dardari.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Maa meser onne raram nodi ri nauroin ai onne ri ma namlolo de na'ukani Yesus wali'ur, “Ainu'u ri mormori wali onne inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus nala wanakunu naho'ok ida walhe na'ahenia, “Mo'oni ida kopur nano Yerusalem laa Yeriko. An rakanedi kalla toro ne, pakromo noro ri man ailanna. Hi rahoredi nin hahaa na'akeme noro idewe nin nainaire, la nukure hehen nanumene na'ikeki maki mene hoikaruwedi, rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka nalo'ol ne, Yahudi rir imam ida mai lolo kalla onne. An do'onedi ma namno'no'o onneni ne, an larlewenedi la loledi kalla wali. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Namnenehe noro ri Lewi ida (ma nadedem howok lolo Makromod Lalap Nin Romleu Lape). An mai do'onedi ma namno'o onneni ne, larlewenedi la loledi kalla wali haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Enimaa ka nalo'olala, manin Samaria ida (ma nadedem ri Yahudi mahalarna) mai. An do'on ma namno'o onne, ai raram penu me'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","de nala wuru noro arak nodi na'inapin nin no'o enihe, la nodi tapi wukuwedi nin no'o enihe nanumene nalha'e laa nina keledei wawan la nodi laa nakar ida ma nadedem rin pair namkuru onno. Rakanedi nakar onne ne, an ilitolle wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Rakan oreki ai nala kupan pere woro'o (alam woro'o nin paipaire) ornakar onne la ne'el na'ahenia, ‘Ilitolle ri eniyeni. Na'amoli i wali mai mene ya'u pair wali'ur kupan ma kan nokor makun eni.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus nala wanakunu onne horu, ai na'ukani meser onne, “Nano ri wokelu enihe, inhoi namwali nin ri mormori wali man wa'an?” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Meser onne walha, “Ma naramyaka ma namno'o onne.” Kame'ede Yesus na'aheni, “Namlolo! Lam hi'i wewhe naisa onne haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Onne horu, Yesus noro Nin man lernohi pakunohi enihe rala'ala'a rakan lekida. Lolo leke onne maekida naran Marta lariyale laa nina nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maeke onne we'ekwalla ida aile naran Maria. Maria eni naikoro wakurani Makromod Yesus ein nakani Nin wanakunu. ");
INSERT INTO kjeNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Enimaa Marta eni, nin honowok nammori ono mahan ilitolle peina'a enihe de an mai na'aheni, “Makrom'u, honowok nammori de hi'ihepe Pape hurinohi Maria naikoro nakani mamani! Hopon ai man pakuwala'u ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kame'ede Yesus na'aheni, “Marta, Marta, o ma'irhu panaeku rahu enihe, ");
INSERT INTO kjeNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","maa panaeku ida aile ma na'ono narehi. Panaeku onne, Maria niliyedi me'e de ka rala nano ai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ler ida Yesus mahan hi'i lir napanak lolo onnida. Hi'i lir napanak horu ne, Nin man lernohi pakunohi ida ne'el Ai na'ahenia, “Makromod, wakukuwala mayai hi'i lir napanak ke'e, naisa Yohanis wakuku nin man lernohi enihe haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Enime'ede Yesus wakuku hi na'ahenia, “Lere mim hi'i lir napanak ma'aheni, ‘Papa, Na'amoli ri na'akeme horhawe O naran man moumou dewdewe. Mamwali Rai ma nodi molollo ri noho wawan na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mala hanana'an man kukkuku noknokor mayai akilere, ");
INSERT INTO kjeNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","la malala ampun ainima dohohala ono ai maledi ampun ri man hi'i sala mayai. Morle'ule'u morwaliwali yai leke yono hayakyaka ken patal ai.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Horu, Yesus nala wanakunu naho'ok ida hi wali'ur na'ahenia, “Nano mi eniyenihe, lo'o ri ida nala'a nin yore nin nakar alam tortoro napanak heheni: ‘Yore, ya apanakala roti keme wokelu ya'u herrale ke'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ono idedi nanumene ainu'u na'aromwali ida man lolo kalle mene lolala ainu'u nakar, maa ainu'u haida kaale odi ahinoi amkauwale.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ik kauroin nin yoro onne lo'o walhe na'ahenia, ‘Ei! Yon ma'o'o ya'u, nike elekedi me'e! Yo oro ya an'uhe amkukuru me'e de ka amaka ala haida ki o me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kade mi ida ma nayoro noro ida, maa ai ka namaka nala haida ki mi. Enimaa Ya'u konohi mi, lo'o ka mawawa mapanak mamani, ai lo'o namaka nala inhawa man mi mapapanak eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ende Ya'u konohi panaeku ma na'ono ki mi. Mapanak ik Makromod Lalap, leke mim kokala, manoin leke lernale, la disna nike leke hari nika. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hi'i heheni ono inhoi ma napanak, Makromod Lalap nale ai, inhoi ma nanoin, an lernale, la inhoi man disna nika, nahinari ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mi ri mormori eniyenihe lo'o mi anum napanak i'in, mi kam herre i'in onne mala nee ai na'an! ");
INSERT INTO kjeNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Alka eni, napanak manu kerre na'an, ka mala sayorne na'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kade mi mamwali man hi'i yaksala, maa mi mauroin mala ha man wa'an mi anume. Emene mi Ammu man aile a'am raram, lo'o nauroin nala ha man wa'an narehi mi! Ai nala Nin Roh Kudus inhoi-inhoi ma napanak Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ler ida Yesus nohi hayakyaka man hi'i mo'oni ida hakukuwedi. Hayakyaka onne namharedi ne, idewe ri onne nauroin wakunuwedi de heri lolo onne polletilu. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Enimaa ri heruwali ra'aheni, “Beelzebul ma namwali Hayakyak Makromon penia nala molollo Yesus nohi hayakyaka nano ri raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Enla ri namehin mai leke ken Yesus de rapanak An hi'i tanadida ri kan dodo'onnala makun leke hi rauroin An mai nano Makromod Lalap, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Enimaa Yesus nauroiroin hi honorok akin de na'aheni, “Lo'o hair ida napye'er namwali muku woro'o ono ida ma kan derne ida, lo'o hair onne ra'akeperedi. Enla lolo nakar raram, lo'o ida ma kan derne nakani ida, nakar raram onne namderredi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Onne namnenehe Hayakyak Makromon nodi molollo nin noho. Lo'o hayakyaka muku ida nohi hayakyaka muku namehin, nin molollo napye'eredi la ka naruri me'e. Ya a'aheni heheni ono mi ma'aheni Yo ohi hayakyak odi Beelzebul nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Enimaa minim man howok wali aile ma nohi hayakyaka nano ri haenhi. Hi rodi inhoi nin molollo rohi hayakyak onne? Ma namlolo, hi rodi molollo nano Makromod Lalap. Rir hini'i onne penia kukul nahenia minim tunum desne Maya'u onne saledi, ");
INSERT INTO kjeNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","maa Yo odi Makromod Lalap Nina molollo ohi hayakyak onne. Onneni namwali tanade nahenia lere alam eniyeni Makromod Lalap nodi molollo ri mormori me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Hayakyakeni naho'ok naisa ri ma naruri ida. Ai nodi ilak raa wo'ira nadiyaka nin nakar, de ri mahaku kan mai namna'e nin hahaa. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Enimaa lo'o ri ma naruri narehi ri onne mai na'okul la rehiyedi, ma naruri narehi onne nahoredi nin ilak rae man ai nahinorok nodi nadiyaka nin hahaa onne, la ha'aredi nin hahaa na'akeme me'e. Ende lo'o Yo ohi hayakyaka eni, onne nin panaeku ainu'u molollo narehi hayakyaka nine. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Horhorok! Inhoi kan lernohi Ya'u, ai onne namwali Ainu'u arwali! Enla inhoi kan paku Ya'u lolo Ainu'u honowok, ai onne penia ma nano'onyaka Ainu'u honowok.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus na'aheni wali'ur, “Lo'o hayakyaka ida namharedi ri raram, an lalaa mamai noho mamun nanoin onno man wa'an leke holi, maa kan lernale. Ende ai nala kenekrohu wali wali'ur laa onno dedesneni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Rakanedi an do'on ri onne naise nakar man sapu moumouwedi la ra'akene wawa'anedi me'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","de an laa nala hayakyaka wo'ikku man ailanna narehi ai, leke noro hi hu'urle ri onne raramne wali'ur. Ende ri onne nina morimori eren yayaka narehi nonolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus mahan wakukunu panaeku onne, maekida ma aile heri onne raramne wakaukau na'ahenia, “O inum man mori O la ma nala huhu Om huhu, ai onne akin nahuwa'an wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Enimaa Yesus na'aheni, “Ma namlolo, inhoi man derne Makromod Lalap Lirna Wawan la hi'i wewhe, ai penia man akin nahuwa'an narehi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lere onne ri nammori mai lupurala Yesus ne, Ai na'aheni, “Ku lere alam enie ailanna. Mi mapanak Ya'u hi'i tanada man ri kan dodo'onnale makun, maa Ka'u hi'i haida mim do'on, naukara inhawa ma namwali noro nabi Yunus mehe. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yunus man minle i'in konoin onne penia namwali tanada man lewlewen manin kota Ninewe. Ya'u, ma namwali Ri Mormori Anan, amwali tanada ku eniyeni naise onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lere Alam Ho'ok Kail ri na'akeme, rai maeke nano noho wali karanna mori wali'ur, la an mai namriri noro ku eniyeni kuku sala hi. An kuku sala hi ono nonolu eni ai nala'a kalla man ko'u mai leke derne nakani wanakuku nano rai Salomo manin woroin lap narehi. Kade lere eniyeni ri ida aile man kulu narehiyedi rai Salomo, maa mi kam derne makani Ai! ");
INSERT INTO kjeNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lere Alam Hono'ok Kanail onne, ri Niniwe mori wali'ur, la mai ramriri kuku sala ri mormori ku enie, ono hir herredi rir morimori ma ka namlolo lere Yunus loikaruwedi Makromod Lalap Lirna Wawan hi. Kade Ya amwali man lap narehi Yunus, maa mi kam derne makani Ya'u la kam herre minim morimori ma ka namloleni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ri man lokon wadu horu kan suwarale, la ka nodi lunu honowale, maa ai nala loile onno man kulu leke ri man mai romleher do'on nin ropropeni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Makum namwali wadu mi kemmu. Lo'o mi makum mou, mim do'on mauroin wawa'an naise ri man minle ropropo, maa lo'o mi makum kan mou, mi kam do'on mauroin haida naisa ri man min lolo noho momohon. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ende loi honorok wawa'an. Yon hi'i de mauroin nahenia ropropo aile mi raram, maa man minle mi raram onne metmetek nine. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ende lo'o mi kemen na'akeme ropo mamani la metmetek nine kaale mi kemen, onne nin panaeku minim morimori eni ropa'ahedi naise wadu man mori na'aropo man minle nin ropropeni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus wakukuwedi horu ne, ri Parisi ida lariyale laa nin nakar ra'ak wewerre. Ende Yesus lernohi ai laa nin nakar, la idewe naikoro leke na'ak. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ri Parisi onne heheledi ono po'on Yesus ka nawana liman mene na'ak de larlewenedi Yahudi rir holoor halauk me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Enime'ede Makromod Yesus ne'el ai na'ahenia, “Kokkoo, mi Parisi enihe, minim morimori naise nonomun onno noro ra'u man paharne mehe rawana, maa raramne morso makun. Mi madiyaka wawa'an leke ri do'on nauroin nahenia minim morimori mou, maa raramne ailanna wake'e, ono mi mahehe mahoro ri namehin rira hahaa la ilitolle mi kemen mehe, ri namehin ka. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Heih, ri ma naploo mi! Ka mauroin Makromod Lalap man hi'i ri kemen penia hi'i hi raramne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Enimaa modi aki man mou mala hahaa laa ri ma na'alehe naulinu enihe, leke minim morimori man rin po'on enie noro idewe mi raramne ra'amou ra'adewedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Heih, ri Parisi mie! Mim mayo'o wake'e. Kade mi mala Makromod Lalap persen idaweli nano minima rampa-rampa naise ta'arutuk, lahono, aukawi warna-warna, maa mim hamlinuwedi panaeku ma na'ono naise maramyaka Makromod Lalap la hi'i wewhe ha ma namlolo noro minim ri heri ri wali. Ha ma na'ono onnenihe, mi akim ka na'ini'ik wake'e. Wa'an rehi mim ilitolle panaeku ma na'ono onne noro idewe hi'i ha naise nala Makromod Lalap Nin persen haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mi ri Parisi mayo'o wake'e. Lere mim laa Yahudi rira kerei raram mi raram nodi maikoro kalari, la lo'o moro ri pakromo lolo pasar mi raram nodi lernala hirira hiyene arore. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aduu! Mi mayo'o wake'e. Mi man kokme'e nahenia mamwali ri molololo maa mi raramne ailanna mamani. Ende mi maisa lunna manin tanade kaale de ri nala'a lolo wawan, maa ka rauroin lunna man penpenu ha man poppopo aile lolo yawa.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kame'ede meser ida ma nauroin Makromod Lalap Nin keneri hono'ok wawa'an ne'el Yesus na'ahenia, “Papa Meser wakunu heheni, ma'ihoru ma'idaru mayai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus walhe, “Mim mayo'o haenhi, ono mi mala yodi man werek rehi mala ri na'uware, maa kam paku hi lernohi num wanakuku onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mim lernala hunukum man werek ono mim kokme'e horhawa nabi-nabi de mim mesel rira lunne hi'i kulu, maa mi maisa mi upum a'um ma nesnedi nabi onnenihe nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kade mim mesel nabi onnenihe rir lunne, maa mi raram nodi mesne Makromod Lalap Nin nabi-nabi naise mi upum a'umhe nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Onne penia Makromod Lalap ma nauroin ha wo'ira na'akeme na'ono mi upum a'um na'aheni, ‘Ya'u hopon nabi-nabi roro ri ma nodi I Lir'u enihe laa hi, la heruwali hi resnedi, heruwali hir hi'i apinpinha.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ende Makromod Lalap nala hunukum ki mi. Onne kan mehe, maa nabi-nabi man mi upum a'umhe resnedi nano noho nina ma namwali rakan lere eniyeni, hi rarna namwali yodiwara ki mi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ende nano Habel rakan man kauli'ur Barekya ananne Zakaria, hi na'akeme ramwali minim yodiwara haenhi. (Zakaria onne hi resne lolo Makromod Lalap Nin Romleu Lape noro honoi kanani onno leken.) Memen mi ma'uwara yodiwara ha man yaka onne na'akeme, la Ya'u nou mi na'ahenia na'amoli Makromod Lalap nala hunukum man werek mi man mori ku eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mi meser ma nauroin Makromod Lap Nin keneri hono'ok wawa'an, mi mayo'o wake'e ono masala konse rodi hari ri honorokne leke rauroin Makromod Lalap Nin wanakuku, maa mim sopoledi kons onne me'e. Mi mehe mauroin Makromod Lalap Nin kalla, maa ka mahehe lolala kalla onne, la mi mehem kawala ri namehin man raram nodi lolale haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kame'ede Yesus namhara lolo onne, la nano lere onne me'ede ri Parisi roro meser Horok Lap enihe ra'ahan Ai de rodi na'ukankani warna-warna ra'o'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hi ra'ukani heheni leke An walha sala harome, hir kele wukue. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lere onne ri riwriwan rahrahu mai lupurala Yesus rasessese wake'e. Ai nala wanakuku Nina man lernohi pakunohi enihe na'ahenia, “Madiyaka ri Parisi enihe! Hir kokme'e hi'i ha man wa'an, maa hir hi'i ha man ailanna mamani. Rir hini'i onne naise ragi rodi ralha'a taponne. Kade nair taran mehe, maa hi'i taponne na'akeme ha'a mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lere eniyeni hirira hini'i wenewhe suwsuware, maa lere man mai na'akeme ralhari mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ende panaeku na'akeme man mim konohi ri a'alam, rakan nohoropo ri na'akeme rauroin, la panaeku man mi malpupu ri kilinna lolo kamar raram man konsedi raderre radaul laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Horhorok, i wal'u na'ahoru! Yon mamka'uk ri man suk nesne mi. Hi rodi molollo resne ri ihin kemen mehe, ka rodi molollo hi'i ha namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Enimaa Ya'u kukunohi mi mamka'uk inhoi. Mamka'uk Makromod Lalap ono Ai penia ma nodi molollo nesne mi ihin kemen nanumene nala mi sopol laa kawali pire aiye porom raram. Namlolo! Ai onne penia mamka'uk! ");
INSERT INTO kjeNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ra'olu nurn wolima wella yawa wake'e, maa Makromod Lalap kan hamlinu nurn kemida. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ai penia nauroinedi minima muruk lawanne me'e. Ende yono mamka'uk, ono Ai naramyaka mi narehi nalewen nurn onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ya'u konohi mi inhoi ma ka namka'uk konohi ri namehin na'ahenia, ‘Ya'u lernohi Yesus,’ Ya'u ma namwali Ri Mormori Anan amkene konohi Makromod Lalap Nin hophopon a'am raram enihe na'ahenia, ‘An lernohi Ya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Enimaa inhoi wiuk namhene Ya'u de na'aheni ai kan lernohi Ya'u lolo ri mormori leken kalarna, Ya'u wiuk amhenedi lolo Makromod Lalap Nin hophopon leken kalarna haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Makromod Lalap nala ampun ri na'akeme ma na'ihoru na'idaru Ri Mormori Anan, maa ri ma na'ihoru na'idaru Nin Roh, Ai ka nala ampun wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lere rin nodi mi laa Yahudi rir kerei leke ho'ok kail mi, ee nodi mi laa makpali man panulu noro ma nodi molollo hair-hair, yono mamka'uk mim walha inhawa hi, ");
INSERT INTO kjeNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ono lere onne Roh Kudus mehen wakuku mi inhawa man wa'an mim walha onneni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ri ida nano heri rahu onnenihe ne'el Yesus na'ahenia, “Papa Meser! Hopon i mo'oniwal'u ha'ar hahaa man ainim ri leleher rala mayai eni, leke nala heruwali maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus walhe, “I wal'u, inhoi kikan Ya amwali ma nodi molollo ha'ar minim pusake?!” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Horu ne An wakuku hi na'ahenia, “Madiyakyaka mi, yon hi'i de mi mamwali ri man makiyala linikir kanaru mamani. Kade iknik linikir kanaru nammori, maa linikir kanaru onne kan hi'i ik mori wawa'an, ono iknik morimori ka nawinair kanarue.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Onne horu Ai nala wanakunu naho'ok wali'ur hi na'ahenia, “Orkanaru ida nin kirna ma na'ihi de lernala ihin ennen nammori. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ai nahinorok lolo akin na'ahenia, ‘Lo'o ya'u hi'i inhawa? Ainu'u nakar rodi ra'akene ainu'u kirne raramne kan nokor me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Enine ai na'aheni, ‘Ya'u lo'o aye'eredi onno-onno rodi ra'akene ainu'u hanana'an eniyeni, la hi'i onno woruworu man lap narehi leke a'akene ainu'u hanana'an noro linikir kanaru namehin haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya'u hi'i onne horu, ka'u howok me'e ono ainu'u hanana'an man noknokor anna laa anna. Ende ya'u aikoro lolo nakar mehe, a'ak omun, la hi'i inhawa man hi'i i raram nahuwa'an.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Maa Makromod Lalap na'aheni ri onne na'ahenia, ‘Heih! O maploedi! A'alam eni Ya aledi o aran me'e de hahaa rahu ma'akekene eni, inhoi man manarne?’ ");
INSERT INTO kjeNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Onneni namwali noro ri ma nanoin noho wawan nina linikir kanaru mamani, maa ka nanoin kanaru ma namlolo lolo Makromod Lalap kalarne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Enine Yesus nounaku Nin man lernohi pakunohi enihe na'ahenia, “Onne penia Ya'u konohi mi, yon ma'irhu minim morimori akilere. Yon ma'aheni, ‘Lo'o ai mo'on inhawa?’ ee, ‘Lo'o am hewek nair inhawa?’ ");
INSERT INTO kjeNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ono ha ma na'ono lolo minim morimori eni ka namwali hanana'an noro nainair mehe. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Po'onala manu arpau me'ene, kar howok kirna, ka ra'ili radai hanana'an, la ra'alehe onno rodi ra'akene rir hanana'an, maa Makromod Lalap leluwai makrana hi. Emene mi eniyenihe, Makromod Lalap peni na'ono mi narehiyedi manu merwui enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mi eniyenihe, kade ma'irhu la loi honorok ha wo'ira mamani, maa onne kan paku mi ma'uwali lere ida lolo minim lere alam mormori. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Enla lo'o kam paekunala hi'i ha tatana naisa na'uwali lerida minim morimori, hi'ihepenia mi ma'irhu noro ha namehin enie? ");
INSERT INTO kjeNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Po'onala au dipi man minle wo'or au tilu. Au dipi onne kar howok, la kar kenna mair, maa horhorok, rai Salomo ma namwali orkanaru wake'e kan nair nainair ma'aruru naise au dipi onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Penek man minle wo'or au tilu Makromod Lalap na'akeki ma'aruru, kade mori lere eniyeni, maa oreki harnedi! Emene maika ho'o? Ai na'akeki ika narehi nalewenedi penek onne, maa mi akim ka naili'il wawa'an makun! ");
INSERT INTO kjeNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yon mahinorok minim nana'an nonomun mamani la yon mim ma'irhu. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Panaeku rahu eni, ri ma ka nauroin ik Makromod Lalap rahinorok mamani. Yon mi ma'irhu panaeku rahu onneni, ono mi Ammu nauroinedi minim hewhewek nainair ma kan kuku kan nokor makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ai na'uwali ha wo'ira onneni ki mi, horo nahenia mi mahehe leke Makromod Lalap nodi molollo mi mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kade mi man lernohi Ya'u ka nammori, maa yon mamka'uk ono minim Pape akin namrana nala molollo mi leke more modi molollo wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ende ma'olu minim ha wo'ira la mala kupan onne ma na'alehe haida-haida. Hi'i heheni leke ma'akene linikir kanaru ma namkene laa ewi-ewi. Onneni naisa mi ma'akene linikir kanaru lolo rakraku ma ka napriki laa ewi-ewi, ono ri mahaku ka namna'a la serurau ka na'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ende ma'akene hahaa lolo a'am raram ono minim linikir kanaru nin miminlole namwali mi akim nin miminlole haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Yon mi kemen naprehen, maa mamkene madiyakyaka la lapan Ya'u mai wali'ur. Wa'an rehi mi mamkene naisa hophopon man lapan hi makromon wali mai nano hohoo nin ya'an yomun. Hophopon onnenihe, rir nainaire namkenkene la rira wadu mormori mamani lekpananne lere hi makromon mai disne nike ne, hi ramkene hari nika hi makromon. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hophopon onnenihe kokala rere'e haharu lalap ono lere hi makromon mai, ka ramkuru, maa radiyaka wawa'an. Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Makromon onne herredi nin nainair leke namkene ilitolle hophopon onnenihe, la an lariyala hi raikoro ra'ak nanumene ilitolle hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lo'o makromon onne mai alam toro me na'ikeki nohoropo, la nin hophopon onnenihe maha radiyaka la lapan ai, hir kokala rere'e harharu man lap wake'e! ");
INSERT INTO kjeNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Loi honorok wawa'an wanakunu naho'ok eniyeni. Lo'o ornakar ida nauroinedi ma'anana ri ma namna'a mai nin nakar, ai nadiyaka wawa'an leke yono ma namna'a mai raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mim hi'i naise onne haenhi. Ma'akenkene mi mamani, ono lere alam Ri Mormori Anan mai, ri ka nauroin.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus na'ukani Yesus, “Makrom'u, wanakunu naho'ok eni mala mayai mehe, ee ri na'akeme?” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Makromod walhe, “Lo'o man howok ida nampe'el la nauroin, ai onne penia makromon kikan namwali uluwakun nin man howok na'akeme, leke kakar hanana'an man howok onnenihe ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Enla lere makromon eni mai wali'ur do'on nin man howok onne mahan hi'i nin honowok wawa'an, man howok onne akin nahuwa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Makromon onne kikan nin ri onne nadiyaka nina linikir kanaru na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Enimaa lo'o man howok onne ailanna, la nahinorok lolo akin na'ahenia, ‘Makromon nalo'ol mene mai,’ la an nukur nin man howok wali enihe la na'an nomun noro ri ma nomun arak manha mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Namlilinnohi makromon wali mai lere alam man ai ka nauroin. Ende an daresne nin man howok onne la sopoledi laa onno ri ma akin ka naili'il enihe miminle. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hophopon ma nauroin makromon honorok akin, maa ka na'akenkene kemen la kan hi'i wewhe lernohi makromon honorok akin, ai onne lernala riuriuk rerrerhe nammori. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Enimaa ri ma ka nauroin makromon honorok akin de hi'i ha man sala, ai onne lernala riuriuk tarana mehe. Inhoi man kokaledi nammori, nin yodiwara nammori rehi ri namehin ma kan kokala nammori.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ya'u mai leke odi aiye lolo noho wawan eni, la I raram nodi aiye onne mormori me'e! ");
INSERT INTO kjeNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ya'u mehe lernala unulu tanade apinpinha noro makmaki. Yi irhun raram ka namkene ono apinpinha onne ka namwali makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lo'o mim pene'ek Ya'u mai noho wawan eni odi moiliwi mahuwele? Ka! Ya'u mai eni hi'i ri mormori ida man sopuse'er ida. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nano lere eniyeni lo'o ri wolima aile nakar ida, wokelu ra'okul woro'o, ee woro'o ra'okul wokelu, de ka ramwali mahaku me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aman noro anan mo'oni, ida ma na'okul ida, la inna noro anan maeke, ida ma na'okul ida. Ine noro panin maeke, ida ma na'okul ida haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus wakunu noro heri onnenihe na'ahenia, “Mim po'on noho ha'aha'a ha'a lolo warak eni ne, ma'aheni, ‘Okon lo'o mai me'e.’ Memen okon mai. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Enla mim po'on anna karanna huu ma'aheni, ‘Lere lo'o manha wake'e.’ Memen namwali. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mi man kokme'e mauroin Makromod Lalap Nin kalla, maa mi ka mauroin! Mi mauroin mapa'aha a'am nina tanade, maa lere mim do'on Ainu'u hini'i la derne Ainu'u wanakunu alhi'ihepe mi ka mauroin nina panaekue?” ");
INSERT INTO kjeNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Alhi'ihepenia mi ka mala kenekrohu inhawa ma namlolo la hi'i wewhe?! ");
INSERT INTO kjeNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lere ri man tumdesne mi nodi mi makpali man ho'ok man kail eni, wa'an rehi mi manoin kalla leke mahuwa'anedi noro ai lolo kalla toro, leke yon ai lan kalaka mi man ho'ok kail eni kalarna. Yon hi'i de man ho'ok kail onne huri mi laa polisi, la polisi onne rala mi nahan bui raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Horhorok, lo'o mi ka mahuwa'an noro ai nolu, hi kar huri mi nano bui raram hehen nanumene minim sala onne pair mouwedi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lere onne ri ida woro'o rodi lira mai konohi Yesus hi'ihehewi gubernur Pilatus hopon resnedi ri manin Galilea wo'irha lere hi maha rala rir honoi kanani Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus dernedi rira wanakunu eni ne, ai ne'el hi na'ahenia, “Lo'o mi mahinorok ri Galilea onnenihe rira dohohale lap narehi manin Galilea namehin penia resnedi hi? ");
INSERT INTO kjeNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lo'o mahinorok heheni, mim saledi! Maa horhorok! Lo'o mi kam herre minim morimori ma ka namlolo eni, la derne makani Makromod Lalap, mi na'akeme lernala hunukum makmaki haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Horhorok! Lere manara man aile Siloam nadiporo duniyesnedi ri idaweli wo'aa, hi'ihehewi? Lo'o hirira dohohala lap narehi ri namehin man minle Yerusalem penia onne namwali hi? ");
INSERT INTO kjeNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ka menee! Maa lo'o mi kam herre minim morimori ma ka namlolo eni, mai derne makani Makromod Lalap, mi na'akeme lernala hunukum makmaki haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Horu ne, Yesus nala wanakunu naho'ok wali'ur. Ai na'aheni, “Orkirna kaman ara onida lolo nin kirna anggur. Lerida orkirna onne laa kirna raram koklolo na'inau ara woin, maa kan do'one. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kame'ede an ne'el ma nadiyaka anggur kirna onne na'ahenia, ‘Anna wokelu raram me'e ya'u mai anoin ara woin, maa ka'u do'on wake'e. Ende keriyedi ke'e! Wa'an rehi ik kaman au'ono namehin man mori wawa'an leke yon holo onno lolo iknik kirna eni!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Enimaa ma nadiyaka kirne walhale na'ahenia, ‘Makrom'ue! Yono keri! Hurinohi ya'u de adiyakale annida raram ikar. Na'amolia ya a'irala au'ono eni waliwali, la ala pipi koi loiyale. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lo'o anna kalari ara woin ma'aruru, onne wa'an, maa lo'o woin kaale makun, ik keriyedi here.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Alam Renren Warwarna ida, Yesus mahan wakuku lolo Yahudi rir kerei ida raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lolo onne maekida aile nakni'ir anna idaweli wo'aa me'e ono hayakyaka huhu'urle raramne. Maeke onne ko'oko'or wake'e la ka nauroin na'alolo nelhen me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus do'onedi maeke onne ne, napolu na'ahenia, “Mame, mai nanu owe!” An maie ne, Ai na'aheni, “Ya'u huri o nano num apinhe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kame'ede An kemenala maeke onne. Me'e'eni me'ede nin apinha onne wa'anedi me'e de namriri wawa'an la na'uli nasa'a Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Enimaa man panulu lolo Yahudi rir kerei onne nawuhur ono Yesus hi'i wa'an man apinha Alam Renren Warwarna. Ai ne'el ri na'akeme lolo onne na'ahenia, “Heih! Alam woneme aile leke howok, de lolo alam woneme raram onne mai leke hi'i wa'an minim apinha, yono lapan Alam Renren Warwarne mene hi'i wa'an minim apinhe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Enime'ede Makromod na'aheni, “Eih! Mi man kokme'e mamwali ri molololo, maa kam peinohi ha ma namlolo! Alam Renren Warwarna me'ene, mi modi minim kude arpau laa romun oir menee. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Maeke eniyeni, Abraham upun anan man hayakyake wuku worre anna idaweli wo'aa raram me'e! Hi'ihepeni mi ma'aheni ik hi'i sala ono ik huri we'er ai nano nina kali wunuku wonorre Alam Renren Warwarne?!” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus Nin wanakunu onne hi'i wawwawa ri ma na'okul Ai enihe, maa ri namehin raram nodi wake'e do'on rauroin Nin hini'i man lewlewen onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus na'ukani wali'ur, “I kodi inhawa wanakunu leke ka'amou ka'arope hi'ihehewi Makromod Lalap nodi molollo ri mormori? Ya aho'ok onne noro inhawe? ");
INSERT INTO kjeNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nina molollo eni naho'ok naisa wini au manu waku ida man ri hap nin ki raram. Wini onne mori namwali au'ono lap, la manu merwui man kaile hinan hanan, hi'i rira wonne nahirei kakan.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus na'ukani wali'ur na'aheni, “Yo odi wanakunu naho'ok inhawa a'amou hi'ihehewi Makromod Lalap nodi molollo ri mormori? ");
INSERT INTO kjeNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Onneni naisa ha ma namwali lere maeke nodi ragi nawa'aha noro tapon terigu nammori (lo'o kilo werro'o woro'o). Nalo'oledi tarana mene na'akeme ha'a wawa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus nala'a laa Yerusalem, An kuli kuli kota-kota noro leke-leke wakuku ri. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ri ida na'ukani, “Makrom'u, lo'o ri taran mehe lernala or'ori dardari ma kan horu eni?” Yesus walha heri na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ri man lernala or'ori dardari ma kan horu enihe naho'ok naisa ri man lolala nika mamarke. Ende mahehe kokkoo leke lolale nike man mamarke laa raram, ono ri nammori rahehe laa raram, maa ka namwali. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Rakan lere Ornakar onne namaka, elekedi nike, lo'o mi aile paharne makun, mi mamriri disne nike mehe, la ma'aheni, ‘Makromod, hariyala nike mayai ke'e!’ Enimaa Ai onne lo'o na'aheni, ‘Ka auroin mi.’ Ka eni, ‘Ka auroin mano ewi mai!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kame'ede mi ma'aheni, ‘Ka mauroin mayai? Ai moro O mo'on momun wewerre, la Makrommu mehen wakuku lolo ainim leke raram.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Enimaa An walhe, ‘Ka auroin mi la ka auroin mim mai nano ewi! Mim ailanna de mamharedi lolo eni here!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lere onne mi mahehere la apinpinha mamani, ono mim do'on Abraham, Isak, noro Yakup noro idewe nabi-nabi na'akeme akinhe rahuwa'anedi raikoro wuku lolo onno man Makromod Lalap nodi molollo eni, maa mi me'e ne sopoledi laa paharne. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lere onne ri nammori rano noho-noho wali kimur, wali warak, wali ra'i, la wali karanna mai raikoro wuku ra'ak romun lolo onno man Makromod Lalap nodi molollo onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Namlolo kokkoo lere man mai ri man kauli'ur ramwali ri man dedesne, la ri man dedesne lere eniyeni ramwali man kauli'ur lere man mai onne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lere onne ri Parisi ida woro'o mai re'el Yesus na'ahenia, “Mala'a onno namehin here, yono min lolo eni me'e kalo'o Herodes nesne O.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus walha hi na'ahenia, “Lam kukunohi man wukupoho onne nahenia lere eni noro orekie Yo ohi hayakyaka enihe la hi'i wa'an ri mamani, la rakan alam wokelu nina mene Ainu'u honowok horu. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Enimaa lere eni, oreki, noro inworo'o Ya ala'a mamani laa Yerusalem ono kan wa'an resne nabi lolo kote namehin, ono nadedem resne lolo kota Yerusalem raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ai na'aheni wali'ur, “Yerusalem mie, mi mesne nabi enihe la wadesne hophopon wahwahan man Ya'u hopon mai ki mi eni. Ler romromo Ya'u raram nodi apolu mi mai leke leluwai makrana naise manu orana man rawa ananne, maa mamhene mai. ");
INSERT INTO kjeNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enpenia Makromod Lalap hoikaruwedi mi de rin mai nano'onyaka minim Romleu Lape. Enla Ya'u konohi mi, nano lere eniyeni me'ede kam do'on Ya'u hehen nanumene rakan lere mi ma'aheni, ‘Makromod Lalap namre'e namharu Ai man mai nodi naran man kulu narehi! Mai ka'uli kasa'e!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Alam Renren Warwarna ida, Parisi rir man panulu ida lariyala Yesus laa nin nakar leke ra'ak. Yesus laedi romleher ne, man panulu ma aile lolo onne radiyakyaka Ai mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lolo Yesus kalarna ri ida aile man apinha penu de liman ein pekpeken wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Enine Yesus ne'el meser-meser ma nauroin keneri hono'ok wawa'an roro ri Parisi enihe na'ahenia, “Hi'ihehewi? Lo'o iknik agame nin holoor halauk hurinohi ika hi'i wa'an ri Alam Renren Warwarne, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Maa hi na'akeme ka ra'oho. Kame'ede Yesus kemenala liman man apinha onne la hi'i wa'anedi nanumene hopon nala'a here. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Horu ne, Ai na'ukani hi na'ahenia, “Mi eniyenihe, lo'o mi anum me minim arpau nediyawedi laa oir makan raram Alam Renren Warwarna, mi lo'o mahehe mala mai paharne, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hi ka ra'oho wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus po'opo'on hi'ihehewi peina'a heruwali mai rahehe raikoro onno man minle kalari leke rin horhawe, de Ai nala wanakunu naho'ok ida hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lo'o rin lariyala mi laa hohoo haromo, yono manoin naikoro onno man ma'aruru rehi, kalo'o ornakar lariyaledi ri namehin man lap narehi mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lo'o hi'i heheni, ornakar man lariyala mi eni mai na'aheni, ‘Mala kadere eni ri eniyeni naikoro.’ Enine mi mawawedi me'e de ne'e namhene, maikoro onno man minle kili'ur honon wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Enimaa, lo'o rin lariyala mi haromo ne, wa'an rehi laa maikoro onno man aile kili'ur honon wake'e. Ende lo'o ornakar mai harome ne, na'aheni, ‘Pape, lariyala mai kaikoredi kalari eni.’ Lo'o hi'i heheni, mim lernala honoor hanawa nano peina'a na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ono inhoi mehe na'akulu kemen lo'o ra'idaru, la inhoi mehe helkaki namdaru kemen lo'o ra'akulu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Horu ne, Yesus ne'el ornakar man lariyaleni, “Lo'o om hi'i ya'an yomun, yom lariyala num ri heri ri wali, o lodon wallumhe, me ri orwali man karu enihe, ono lere namehin hir herre walha num lalariyale wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maa lo'o om hi'i ya'an yomun, lariyala ri ma na'alehe naulinu, man liman yaka ein yaka, ma naplu'uk nap'eker, noro man oitoko maktoko enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lo'o om hi'i heheni, Makromod Lalap namre'e namharu o, ono hi kar paekunala herre walha num wawa'an eni. Rakan lere alam ri molololo Makromod Lalap kalarna mori wali'ur, Makromod Lalap mehen herre walha num hini'i man wa'an onne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hi maha ra'ak, peina'a ida dederne Yesus Nin wanakunu onne de ne'el Ai na'ahenia, “Ri ma noro Makromod Lalap ra'ak wewerre lolo Nin onno man Ai nodi molollo eni, ai onne lernala rere'e haharu man lap narehi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Enimaa Yesus walha na'ahenia, “Ler ida, ri ida hi'i ya'an yomun lalap la lariyala ri nammori mai. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rakanedi lere alam ya'an yomun eni ne, an hopon nin hophopon ida lan konohi popolu lalariyala enihe na'ahenia, ‘Ha wo'ira namkenedi me'e de lariyala.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Enimaa popolu lalariyala enihe na'akeme hehelala. Ida na'aheni, ‘Eni nanumene ya'u weli lari ipida, de ka namwali ya'u ki ono lo'o la'u tollala. Yon ma'ahan, pape!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ri namehin na'aheni, ‘Eni nanumene ya'u weli arpau kem idaweli de ka namwali ya'u ki ono lo'o la'u po'onale nanu. Yon ma'ahan, pape.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ri namehin wali'ur na'aheni, ‘Eni nanumene ya'u hohoo de ka namwali ya'u ki. Yon ma'ahan, pape!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Enime'ede hophopon onne lan konohi makromon na'ahenia, ‘Pape, na'akeme hehelala de kar mai.’ Enine ornakar onne nawuhur la hopon nin hophopon na'ahenia, ‘Mala'a halhala laa koteni nin kalla lapa noro idewe kalla hanana na'akeme lariyala ma na'alehe naulinu, man liman yaka ein yaka, man oitoko maktoko, noro ma naplu'uk nap'eker na'akeme mai leke ra'ak mai eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","An lae ne, hi'i lernohi makromon nin hohopon eni, wali mai na'aheni, ‘Makrom'u, popolu lalariyala enihe na'akeme raikoredi me'e, maa naikoro onno heruwali mammamu makun.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kame'ede makromon onne hopon nin hophopon na'ahenia, ‘Mala'a laa kalla lap noro idewe kalla hanana na'akeme ma aile kote paharne mapanak an'anhedi tatana lalapa mai leke ainu'u nakar penuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Horhorok, ri mahaku nano ri man dedesne ya'u lariyala onnenihe ka noro ya'u ra'ak wewerre lolo ya'an yomun eniyeni.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ri nammori roro Yesus ra'alono rala'a, An wali kili'ur po'onala hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Inhoi raram nodi lernohi Maya'u, maa ka naramyaka Ya'u narehi inna, aman, hono, anan, mo'oniwalla, narna, noro idewe kemen mememen, ai ka namwali Ainu'u man lernohi. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inhoi namhene na'uwara nin au kekiyowok la lernohi Ya'u, ai onne ka namwali Ainu'u man lernohi. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Lo'o ki mi ri ida raram nodi na'ariri nakar man lapa, ai nakakar nakar onne nin ha wo'ira wella nanu leke nauroin nin kupan nokor, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kalo'o an hi'i pondasi horu, nin kupan horuwedi me'e de rin mai nalau ai, ");
INSERT INTO kjeNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","na'aheni, ‘Papa onne nin panaeku na'ariri nakar lalapa, maa nin kupan kan nokor.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ka eni, hi'ihehewi rai ida man paeku laa ra'ara noro rai namehin. Ai lo'o naikoro wuku nanu leke naho'ok nakailale ke'ede nin ke'urauk riwan idaweli rira ruri noknokor rehiyedi ara noro nin arwali ma nin ke'urauk riwan werro'o, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yon hi'i nahenia ka nakinuku noro nin arwali, hir min ko'u makun an hopon nina ri laa leke napanak rahuwa'an here. ");
INSERT INTO kjeNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wanakunu naho'ok eni namnenehe noro mi haenhi. Ende loi honorok wawa'an nanu, ono inhoi kan wiuk namhene nina hahaa wo'ireni, ka namwali Ainu'u man lernohi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Asir ma nam'arha penia wa'an, maa lo'o ka nam'arha me'e, rodi inhawa leke hi'i nam'arha wali'ur? ");
INSERT INTO kjeNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kar nair me'e. Kan wa'an rodi hi'i pupuk man ri nala loile kiraram leke meur, de sopoledi ke'e. Lo'o mi kilinum aile, makaniyala here.” ");
INSERT INTO kjeNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lerida ri nammori man ra'uk paipair roro ri namehin man rin wekel ‘man hi'i dohohala’ mai leke derne Yesus Nin wanakunu. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ri Parisi roro Yahudi rir meser Horok Lap enihe ra'alolo ra'aheni, “Eih! Po'onala! Ri eni nawaur noro ri man hi'i dohohala, la noro hi ra'ak romun wewerre.” ");
INSERT INTO kjeNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Onne penia Yesus nala wanakunu naho'ok ida hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Lo'o mi ri ida nina pipduma waku rahu ida, la pipduma waku ida moluwedi. Ai lo'o hoikaruwedi welihii-wohii mehe ra'an penek lolo onno man wa'an, laa nanoin man moluwedi eni hehen nanumene do'onedie. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","An do'onedi man molu eni ne, akin nahuwa'an wake'e la na'uware wali laa nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Rakanedi nin nakar ne, ai napolu nin na'aromwali roro nakar wali enihe na'aheni, ‘Mai moro ya'u soksok murmurala ono ya'u do'onedi ainu'u pipduma man molu me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Horhorok! Lolo a'am raram ha ma naise onne namwali haenhi. Lo'o man hi'i dohohala ida herredi nin morimori ma ka namloleni, Makromod Lalap noro Nin hophopon a'am raram rir soksok murmure lap narehi ri welhii wohii man rira morimori namloledi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Onne horu Yesus nala wanakunu naho'ok namehin na'ahenia, “Mama ida nin kupan pere idaweli, la lere ida nin kupan pere ida moluwedi. Ende ai lo'o hi'i inhawe? Ai lo'o lokon wadu la sapu nakar raram na'akeme leke na'inau wawa'an hehen nanumene do'onedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","An do'onedi kupan onne ne, ai napolu nin na'aromwali noro nakar wali enihe na'ahenia, ‘Mai moro ya'u soksok murmurala nanu ono ya'u do'onedi kupan man molu onne me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lolo a'am raram ha ma naise onne namwali haenhi. Makromod Lalap noro Nin hophopon a'am raram enihe sok mur rehi lere ri man hi'i dohohala herredi nin morimori ma ka namloleni la derne nakani Makromod Lalap, kade ri ida mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus nala wanakunu naho'ok ida wali'ur na'ahenia, “Papa ida anan mo'oni woro'o. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ler ida anan karuri mai napanak aman na'ahenia, ‘Pape, ha'ar num linikir kanaru mala ainu'u hana'ar maya'u ke'e!’ Enime'ede aman ha'ar nin linikir kanaru noro nin nohana raiyana nala anan woro'o enihe me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka nalo'olala anan karuri eni na'akenedi nin hahaa, la na'oluwedi nin hana'ar leke nala'a laa noho man ko'u. Minle enne ai nodi nin kupan na'akeme hi'i ha ma kan min haida lernohi nina suk aimehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lere nin kupan na'akeme horu mouwedi, noho an miminle onne lernala roulara lapa de nin morimori sus rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ende an laa nanoin honowok ri ornoho ida. Enine ri onne kokale de hopon wa'an nin wawi. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mo'oni onne namlara wake'e, maa ri mahaku ka nala haida ai na'an, de raram nodi na'an wawi onne rir hanana'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kame'ede ai nahinorokala me'e, de noro akin wakunu na'ahenia, ‘Eih! Lolo ainu'u papa nin nakar ri man howok na'akeme lernala hanana'an ra'an pehur, maa lo'o ya'u min mai eni i maki lare me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wa'an rehi ya'u wali wali'ur laa ainu'u pape konohi ai nahenia ya'u hi'iyedi sala lape Makromod Lalap noro papa me'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","de kan wa'an ya amwali papa anan me'e, maa wa'an rehi ya amwali papa nin man howok lolo nakar me'e wa'an!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ai nahinorok heheni horu, an wali laa aman nin nakar me'e. Ai nalko'u makun aman do'onedi me'e, la raram penuwala, naramyakale de lari laa noro anan pakromo naurukuwale la masie. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Enime'ede anan ne'el aman na'ahenia, ‘Papa, ya'u hi'iyedi dohohala papa noro Makromod Lalap me'e de kan wa'an papa napolu ya'u ananne me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Enimaa aman napolu nin hophopon wahwahan enihe na'ahenia, ‘Pelek mala nainair man ma'aruru modi mai an naire. Mala deli noro pakpak ei an nair haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Onne horu, modi sapiyana poipoir ida mai mesne leke ka'an la kore soksok murmurala, ");
INSERT INTO kjeNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ono ya an'u eni naise an makiyedi me'e, maa lere eni mori wali'uredi me'e! Nonolu penia an molu, maa lere eni ya'u do'on wali'uredi me'e!’ Ende hir lernohi nin honopon hi'i ya'an yomun la soksok murmura me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mahar hi'i ya'an yomun ne, mo'oniwalla anulu aile kirna mahan howok. Howok horu an wali laa nakar. Na'uranrani nakar ne, an derne poloit, hitare, keki ra'a lirlira, mahar pe'uk waur. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ende ai napolu hophopon wahwahan ida na'ukani, ‘Mahar hi'i inhawa ai nakar?’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hophopon wahwahan onne walha na'ahenia, ‘Makrom'u, ammu hopon resne sapiyana man poipoir ida hi'i yapi lalap ono mo'oniwallum karuri ma nala'a nohide, haida kan hi'i de, wali mai wali'uredi me'e!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","An dernedi ne, na'ahan rehi de namhene laa nakar raram me'e. Ende aman pelek laa paharne nori leke laa raram, ");
INSERT INTO kjeNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","maa ai ne'el aman, ‘Pape, ken pape nahinorokala nanu! Anna laa anna ya ampe'el ilitolle papa nin honowok. Ya'u derne akani papa nin honopon mamani. Kade ya'u howok wewerek, maa pape ka nala sapiyana ida yo odi hi'i yapi soksok murmur noro ainu'u na'aromwali enihe menee. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Maa papa anan man laa na'ahoruwedi num kupan nodi na'aromo noro maekyaka wali mai nakar, papa nesne sapiyana man poipoir ida hi'i yapi lalap noro ai!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aman na'aheni, ‘Pa'eee! Moro ya'u mamani la ainu'u ha wo'ira onume. ");
INSERT INTO kjeNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Enimaa lere eniyeni wa'an rehi ik hi'i yapi leke soksok murmura ono o mo'oniwallum karuri eniyeni, an maki maa mori wali'uredi me'e, an molu maa do'on wali'uredi me'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Onne horu Yesus na'uwali wanakunu naho'ok ida wali'ur Nina man lernohi pakunohi enihe na'ahenia, “Orkanaru ida nala naiwe'el ri ida leke namwali nin ma nasala kupan noro kakar nina linikir kanaru. Ler ida orkanaru onne derne nahenia nina man howok onne ka nadiyaka nin kanaru wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ende ai napolu man howok onne mai na'ahenia, ‘Alhi'ihepe ya'u derne o ka madiyaka ainu'u kanaru wawa'an!? Me'e'eni me'ede laa mala horok rodi kakar ainu'u kupan herherre noro kanaru eni modi mai ya'u po'onale, ono ya amhene om howok me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Man howok onne dernedi heheni ne, nahinorokala me'e la noro akin wakunu na'ahenia, ‘Lo'o ya'u howok inhawa? Ya asala saplai, ka aruri, la ya amwali ri man mehe napanpanak, ya awawa. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, ya auroin kalla man wa'an lole leke rakan ainu'u honowok eni horu, ri nammori kokala ya'u lolo rir nakar.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kame'ede an polu ri na'akeme ma nin okon raka aile makromon mai. Ai na'ukani ri man mai dedesne na'ahenia, ‘O numa okon raka wo'ira aile i makrom'u?’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ri onne walha, ‘Ainu'u okon raka wuru zaitun uhi rahu ida.’ Ma nasala kupan na'aheni ai, ‘Mala num horok okon raka onne herredi uhi rahu ida onne horok uhi wellima herme'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Onne horu ai na'ukani ida ho'o me'e na'ahenia, ‘Num okon raka wo'ira?’ An walha, ‘Ainu'u okon raka aliwerhe kaduk riwan ida.’ Ma nasala kupan onne na'aheni, ‘Mala num horok okon raka herredi kaduk riwan ida onne horok kaduk rahu wo'aa herme'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","An hi'i heheni mamani. Kade makromon po'on nauroin nin pohe onne, maa ai na'uli ai ono nahehe lernala kalla man wa'an an lole lere nin honowok horu, leke ri aile man kokale noro wawa'an.” Enime'ede Yesus na'aheni wali'ur ri man dederne enihe na'ahenia, “Ya ala wanakunu naho'ok eni leke kukul nahenia ri ma ka nauroin Makromod Lalap rauroin kakar rir morimori noro rir ri heri ri wali leke kokala wawa'an rara'e wa'an narehi ri ma aiyedi ropropo me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ende mahinorok wawa'an! Wa'an rehi modi minim linikir kanaru lolo noho wawan eni paku ri leke mi wallum aile ma naramyak mi. Hi'i heheni lekpanane lere minim kanaru horu la mim makiyedi me'e, Makromod Lalap kokala mi wawa'an lolo miminlole ma namkene laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ri ma nodi aki man mou kakar hahaa tarana, ik kauroin ai nodi aki man mou kakar hahaa nammori. Maa lo'o ri ka nodi aki man mou kakar hahaa tarana, ik kauroin ai kan kakar hahaa nammori wawa'an haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lo'o mi modi noho wawan nin linikir kanaru hi'i ha ma ka namlolo, onne nin panaeku mi modi a'am raram nin linikir kanaru hi'i ha ma ka namlolo haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Enla lo'o ri nala hahaa mi madiyaka lolo noho wawan, maa mi modi rir hahaa onne hi'i ha ma ka namlolo, lo'o inhoi raram nodi nala hahaa mi manarna lolo a'am raram? ");
INSERT INTO kjeNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hophopon wahwahan kan paekunala namwali man howok ilitolle makromon woro'o, kalo'o nalida wa'an, la namehin yaka, ee namkene lernohi ida, la ida ka. Kam paekunala mamwali Makromod Lalap Nin man howok noro idewe man howok nanoin kupan mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ri Parisi enihe dernedi Nin wanakunu onneni ne, ralau Ai ono hi raram nodi ranoin kupan mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Enimaa Yesus ne'el hi na'ahenia, “Mi ma'aheni mi ihin kemen mou lolo ri kalarna, maa mi kam mou lolo Makromod Lalap kalarna, ono Ai penia nauroiroin mi akim man ailanna onne. Panaeku man ri mormori horhawe narehi, Makromod Lalap kan suk wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nano nonolu rin wakuku Makromod Lalap Nin keneri hono'ok noro nabi-nabi rira wanakuku. Hir wakuku hehen nanumene Yohanis ma nodi oir ulutade mai, maa nano Yohanis nin lere onne, Lira Wawa'an ma na'ono hi'ihehewi Makromod Lalap nodi molollo ri mormori raderre radaul mamani. Enla ri nammori kar ren ranoin kalla leke ramwali Makromod Lalap Nin ri. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kade onne namlolo, maa Makromod Lalap Nin keneri hono'ok onneni kan molu laa ewi-ewi. Keneri hono'ok onne nin hurup noro titik na'akeme namkene nalo'ol rehi noho wawan noro a'am eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Inhoi namhene nin maekleher, lan ho noro maeke namehin, ri onneni lerwa'u hailaiyedi me'e, la inhoi man ho noro maeke man reiha'aredi noro hono, an lerwa'u hailai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus nala wanakunu ida wali'ur na'ahenia, “Orkanaru ida aile nin nainair naisa rai nine, na'akeme ma'aruru mamani, la nin morimori naisa ri man lernohi yapi ra'an romun mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Akilere ri nala mo'oni ida ma na'alehe haida-haida naran Lazarus loiyedi lolo orkanaru onne nin nika lapa makan. Lazarus onne no'o penpenu kemen, ");
INSERT INTO kjeNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","la ai raram nodi na'anala orkanaru onne nin ha rehin ma nadiyaur nano nin mei. Onne kan mehe, maa ahu-ahu mai poho kemen ma namno'ono'o eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ka nalo'ol ne, ri ma na'alehe haida-haida onne makiyedi, la Makromod Lalap Nin hophopon a'am raram mai nale laa a'am raram leke naikoro wewerre noro Abraham. Enla orkanaru onne maki la rawilo'edi me'e haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Minle kawali pire ai porom raram, an lernala apinpinha mamani, la an po'on laa wawan do'on Abraham lolo onno man ko'u, la do'on Lazarus aile Abraham herne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Enine an wakau na'ahenia, ‘Papa Abraham-eee! Maramyakala'u ke'e! Hopon Lazarus nala liman ra'an remenala oir mai napa'ukala i namal honon me'e wa'ane. Ya'u apinha wake'e lolo aiye raram.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Maa Abraham walha na'ahenia, ‘Pa'e, mahinorokala nanu! Lere om mori lolo noho wawan om lernala ha wawa'an mamani, maa Lazarus lernala ha man namehiyala mamani. Enimaa, mai eni ai akin nahuwa'anedi, la om lernala apinpinha mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Onne kan mehe, maa ka namwali ya'u paku o ono moko ma naphari man rorom wake'e aile ik leken de kalla kaale leke om mai eni, ee am ki enne.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kame'ede orkanaru onne na'aheni, ‘Lo'o onne namlolo, ya apanak papa hopon Lazarus laa ainu'u pape nin nakar, ");
INSERT INTO kjeNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ono mo'onwal'u wolima aile makun. Hopon Lazarus laa na'ori honorok hi leke yon hi'i de hir mai onno man apinpinha eniyeni haenhi.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Maa Abraham ne'el ai na'ahenia, ‘Pa'e, hirira horok-horok aile man Musa noro nabi-nabi horokedi me'e! Na'amoli hir lernohi horhorok ma aile horok onnenihe ke'e!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Maa orkanaru onne napanak an'anhedi Abraham na'ahenia, ‘Papa Abraham, onne kan nokor makunee! Maa lo'o ri man maki mori wali'ur lan konohi hi mene hir herre rir morimori ma ka namlolo, la derne rakani Makromod!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kame'ede Abraham walha na'ahenia, ‘Lo'o hi kar derne rakani Musa noro nabi enihe lirna, hi kar derne rakani ri namehin haenhi, kade an maki la mori wali'ur lan konohi hi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus ne'el Nin man lernohi pakunohi enihe na'ahenia, “Panaeku ma nakoko ri nadiyaur dohohala aile, maa mayo'o wake'e ri ma nodi panaeku ma nakoko ri nadiyaur dohohala. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wa'an rehi wairedi waku lapida kelenne, rodi laa auredi heleken leke yon an mori de hi'i Ainu'u tatanida nadiyaur dohohale. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ende madiyaka mi kemen wawa'an leke yono hi'i ri nadiyaur dohohala! Lo'o mi wallum hi'i dohohala, dadiyale. Enlo'o an herredi nin morimori ma ka namlolo onne, mala ampun ai. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Enla lo'o an hi'i sala ki mi rew'ikku lere ida, la an mai rew'ikku na'ahenia, ‘Ya'u hi'iyedi sala me'e de ya apanak malala ampun ya'u ke'e owe.’ Enine yon horhorok nin yakyak salsala onne me'e, maa mala ampun ai mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ler ida Yesus Nin hophopon ma nodi Lirna Wawa'an enihe rapanak Ai na'ahenia, “Makromod, paku mayai leke ai akim namkene naili'il Makromod!” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","An walhe, “Lo'o mi akim naili'il Makromod Lalap, kade tarana mehe naisa aukawi waku man tutusiyane, mi lo'o paekunala hopon nunu ono lapida nahine'uledi nano elimo'o hoi laedi kahi raram, la au'ono onne idewe lernohi minim honopon onne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus nala wanakuku wali'ur na'ahenia, “Lo'o mim hopon minim hophopon wahwahan ida laa na'alarna kirna, ee lan huri pipi lolo wo'or. An hi'i nin honowok onne horu an wali laa nakar. Waliyedi laa nakar ne, mi kam lariyala, ‘Pelek mai na'ak,’ ");
INSERT INTO kjeNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","maa mi lo'o ma'aheni, ‘Mapali ai here! Onne horu herredi num nainair man morso onne ma'akene hanana'an yo o'on. Ya a'ak horu mene o ma'ak here!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kade nin hophopon wahwahan onne derne nakani ai wawa'an, maa makromon ka napanak trimkasi ai ono onne penia namwali nin honowok. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onne namnenehe noro mi haenhi. Lo'o mim hi'i konomdere na'akeme man Makromod Lalap nanale horuwedi, wa'an rehi mi ma'aheni, ‘Ai mamwali hophopon wahwahan man hi'i lernohi ai makrommu nin honopon mehe, ono onne penia namwali ainim honowok.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus nala'la'a laa Yerusalem, An lolo kalla ma aile Samaria noro Galilea leken. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","An rakan leke ida, ri idaweli man ulik yak hi'ie mai ramririri rako'u Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Hir wakau ra'ahenia, “Yesus, Makrommu-ee! Maramyakalai ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","An do'onedi hi, hopon na'ahenia, “Lam, kukul mi kemen laa imam enihe!” Man apinha onne aile kalla makun, rir apinha wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ri ida nano ri idaweli onnenihe do'on nauroin kemen wa'anedi ne, an wali wali'ur laa Yesus wakaukau na'ul'uli nasa'sa'a Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","An rakanedi Yesus ne, ai nahinononow kalarne mene napanak trimkasi Ai. Ri onne ka namwali ri Yahudi, maa manin Samaria. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Enine Yesus na'ukani ai, “Idedi Ya'u hi'i wa'an ri idaweli, emene wohii aile ewi? ");
INSERT INTO kjeNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Alhi'ihepe ma nano noho namehin mehe wali mai na'uli nasa'a Makromod Lalap?” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kame'ede Yesus na'aheni ri onne, “Mamriri here, mala'a wawa'anedi! Om wa'anedi me'e ono akim naili'il Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ler ida ri Parisi ida woro'o mai ra'ukani Yesus na'ahenia, “Pap Meser! Ma'anana Makromod Lalap mai nodi molollo mai noho wawan eni?” Yesus walhe, “Lere Makromod Lalap mai nodi molollo noho wawan ri kan do'on tanada man kukul An mai. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Enla ri ka na'aheni, ‘Heih! Makromod Lalap Nin molollo onno aile mai eni, ee aile lolo onne.’ Hi kar wakunu heheni ono Makromod Lalap Nin lere nodi molollo rakanedi me'e, aiyedi mi leken kalarne me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Horu ne, An konohi Nin man lernohi pakunohi enihe, “Lere man mai mi raram nodi min wewerre noro Ya'u ma namwali Ri Mormori Anan, kade alam ida mehe, maa, kam do'on Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lere onne ri lo'o ra'aheni, ‘Eih! Po'on lolo onne,’ ee ‘Po'on mai eni, Ri Mormori Anan maiyedi me'e!’ Maa yon lari lernohi hi, ");
INSERT INTO kjeNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ono Ri Mormori Anan nin maimai eni ka naisa onne. Nin maimai onne naisa noho lerlere man siksik ropedi nano a'am honon wali rakan honon wali de ri na'akeme do'odo'one mouropo. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Enimaa onne ka namwali hehen nanumene ku eniyeni hi'i Ya'u ma namwali Ri Mormori Anan lernala apinpinha man werek wake'e la ra'okuledi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lere Ya'u, Ri Mormori Anan, mai wali'ur onne, ri mormori lolo noho wawan eni rir hini'i wenewhe namnenehe ik upud a'ad Nuh nin kulere nonolu haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lere onne ri mormori lawuku mahar hi'i ya'an yomun noro yapi hohoo mamani rakan lere Nuh laedi kapal raram. Lere onne me'ede oir rulu lape mai na'akeperedi hi na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Enla lere Ya'u wali mai eni, ri mormori rir morimori naise manin kota Sodom lere Lot min lolo onne haenhi. Lere onne hi ra'an romun, ra'iwali hahaa, howok kirna la ra'ariri nakar-nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Maa lere Lot namhara Sodom, lere onne me'e de aiye noro lali nadiyaur nano a'am naisa okon harnesne mouwedi hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ende lere Ya'u ma namwali Ri Mormori Anan mai wali'ur, ri mormori noho wawan rir morimori naise onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lere onne ri ma aile nakar wuwanne, yono laa romleher rala rir hahaa, la ri man howok lolo kirna yon wali laa nakar. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Horhorok inhawa ma namwali noro Lot hono nonolu eni. An po'on kili'ur de maki! ");
INSERT INTO kjeNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri ma namhene huri nin morimori lolo noho wawan eni kan lernala or'ori dardari ma kan horu. Enimaa ri man hurinohi Makromod Lalap nodi molollo nin morimori lolo noho wawan eni, ai onne lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Derne wawa'an! Lere Ya'u wali mai wali'ur, alam onne ri woro'o ramkukuru aile namkuru onnida, ramlilinnohi Makromod Lalap kikanedi man lernohi Ya'u, maa walin ma akin ka naili'il Ya'u hoikaruwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lo'o maeke woro'o mahar wain kele'uk, ida hoikaruwedi la ida nakinikanedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ri woro'o mahar howok wewerre aile kirna, Makromod Lalap kikan ida la hoikaruwedi ida.” ");
INSERT INTO kjeNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Enime'ede man lernohi pakunohi ra'ukani, “Rin po'on Papa Nin maimai lolo ewi?” Yesus walha nodi wanakunu naho'ok eni, “Lo'o mim do'on manu arpau nammori luplupur onnida, mi mauroin ha mormori man maki aile lolo onne. Onne penia naisa lere Ya'u wali mai wali'ur, Ka'u suwarala Ainu'u maimai eni, maa ri na'akeme po'on rauroini.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Enime'ede Yesus nala wanakunu naho'ok ida wakuku Nin man lernohi pakunohi enihe leke hi ramkene hi'i lir napanak Makromod Lalap mamani, la yon ren hi'i lir napanak ono rahinorok nahenia Makromod Lalap kan derne rir lir napanak me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ai na'aheni, “Lolo kote ida, man ho'ok kail ida aile ma ka namka'uk Makromod Lalap la kan peinohi nin ri heri ri wali enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lolo onne maeke walwalum ida aile haenhi. Akilere an mai napanak man ho'ok kail onne na'ahenia, ‘Pape, pakuwala'u akpali ainu'u arwali.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lere dedesne an laa napanak, man ho'ok kail onne namhene kokala nin napapanak onne, maa akilere an mai mamani. Kame'ede man ho'ok kail noro akin wakunu na'ahenia, ‘Ya'u ka amka'uk Makromod Lalap me ri mormori, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","maa akilere maeke eni mai na'o'o ya'u, de wa'an rehi ya'u paku ai, kalo'o an mai mamani de hi'i ya a'iseri noro nin napapanak eni!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Enine Makromod na'aheni, “Loi honorok wawa'an man ho'ok kail man ailanna onne nina wanakunu eni! ");
INSERT INTO kjeNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lo'o man ailanna onne paku maeke walwalum onneni, emene hi'ihehewi noro Makromod Lalap? Namlolo kokkoo Ai nodiyala Nin ri mememen man hi'i lir napanak lelere a'alam. Ai ka na'aromromo noro hi, maa Ai namkene paku hi! ");
INSERT INTO kjeNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Loi honorok wawa'an! Makromod Lalap memen pelek walha rira lir napanak de nala ha ma namlolo hi. Enimaa Ya'u ma namwali Ri Mormori Anan a'ukani eniyeni, ‘Lere Ri Mormori Anan wali mai noho wawan wali'ur lo'o An pakromo noro ri ma akin namkene naili'il Ai, ee ka?’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus nala wanakunu naho'ok ida wali'ur ma na'ono ri ma nauroin hi ramwali ri molololo de holi kukulu lalap la po'on lewen ri namehin. Ai na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ler ida pap woro'o rala'a laa Makromod Lalap Nin Romleu Lape raram leke hi'i lir napanak. Ida namwali ri Parisi la ida man ra'uk paipair. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri Parisi onne mehe namriri la hi'i lir napanak ma na'ono ai kemen mehe na'ahenia, ‘Makromod Lalape! Trimkasi Makrom'u ono ka'u hi'i dohohala naise ri namehin, rehirehi man ra'uk paipair man aile lolo onne! Ya'u peni ka amna'a ri nin hahaa, ka'u hi'i yakyak salsala, ka'u holi yak leke yak, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ya a'aluli kem'u ka a'ak rewro'o domeku ida, la nano ainu'u mahmaha awenne ihin ennen na'akeme ya ala persen idaweli laa kerei mamani.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Enimaa man ra'uk paipair onne namririri ko'u lolo kili'ur ono nauroinedi an hi'i dohohala, la namka'uk wanna ha'a oin makan po'on laa wawan. An sapsapu irhun na'ahenia, ‘Makromod Lalapee, mala ampun maya'u. Ya'u eni man hi'i dohohala.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Horu ne, Yesus konohi, “Derne makani eniyeni, man ra'uk paipair eni wali laa nin nakar akin nahuwa'anedi noro Makromod Lalap, maa Parisi onne, ka, ono Makromod Lalap na'ihoru na'idaru ri man holi kukulu lalapa la na'akulu na'alapa ri man helkaki namdaru.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lere onne ri nodi tatana mai Yesus leke kemenala liman la namre'e namharu hi haenhi. Nin man lernohi pakunohi do'onedi ma nodi tatana onnenihe mai ne, hi ra'ahan de dadiyale. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Enimaa Yesus napolu tatana onne mai la ne'el Nin man lernohi pakunohi enihe, “Hurinohi tatana onnenihe mai Maya'u! Yom kawala hi ono Makromod Lalap nodi molollo ri ma naise tatana eniyenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi ma akin ka naili'il Makromod Lalap naise tatana eniyenihe, ai kan laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yahudi rir uluwakun ida mai Yesus na'aheni, “Pap Meser man wa'an! Ya'u hi'i inhawa leke ya'u mori laa ewi-ewi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus walhe, “Hi'ihepenia o ma'aheni Ya'u wa'an A'u? Ri mahaku kan wa'an! Makromod Lalap mehe man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O mehe mauroinedi Makromod Lalap Nina keneri hono'ok na'aheni: ‘Yon lerwa'u hailai, yon mesne ri, yon mamna'a, yon modi poho tumdesne ri lolo hono'ok kanail onno, la horhawa o inum, o ammu.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Enime'ede ri onne ne'el Yesus na'ahenia, “Pape, keneri hono'ok onne na'akeme ya'u lernohiyedi nano tatana'u me'e de rakan lere eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus derne onne ne, na'aheni, “Maa, ha ida o kam hi'i makun. Laa ma'olu onuma hahaa na'akeme, mala kupan ha'arle ma na'alehe haida-haida nanumene mam lernohi Ya'u, leke om lernala kanaru ma aile a'am raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","An dernedi onneni ne, akin woir rehi, ono nin kanaru lap rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus po'opo'on ri onne la na'aheni, “Sus wake'e ri orkanaru laa onno man Makromod Lalap nodi molollo raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Horhorok! Sus wake'e unta waku ida lolala wanaka ku'il, maa man sus narehi onne, orkanaru laa onno man Makromod Lalap nodi molollo raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri man dederne Yesus Nin wanakunu onne ra'ukani na'ahenia, “Lo'o hi'i heheni ne, inhoi penia nahinuriyedi nano hunukum makmaki leke lernala or'ori dardari ma kan horu onne?” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus walhe, “Ri mormori kar paekunala mehe rahala kemen nano hunukum, maa Makromod Lalap mehe nodi molollo huri we'er ri nano hunukum.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kame'ede Petrus na'aheni, “Am hoikaruwedi ainim ha wo'ira na'akeme me'e leke lernohi Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus walhe, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ri man hoikaruwedi nin nakar, hono, walinhe, ri leleher, ananhe lan ilitolle Makromod Nin honowok leke paku ri rauroin hi'ihehewi Makromod Lalap nodi molollo hi, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ai onne lernala wanalha lolo noho wawan eni man wa'an narehi nalewen hahaa an hoikakaruwedi onne. Onne kan mehe, maa lere man mai, ai noro Makromod mori wewerre laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Enine Yesus napolu Nina ri idaweli woro'o man lernohi pakunohi enihe maiwuku memehedi onnida nanumene na'aheni, “Makaniyala! Lere eni ik kala'a mamani laa kota Yerusalem. Ik rakan enne, panaeku na'akeme ma na'ono Ri Mormori Anan man nabi-nabi nonolu eni horokedi, lo'o namwali Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hi rala Ya'u kanile ri ma ka namwali Yahudi enihe. Hir hadwei hadwokor Ya'u, ra'ihoru ra'idaru Ya'u, la saprui saworno Ya'u. Hir riuk rerhe Ya'u, la resnA'u, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","maa rakan lere wokelu, Ya'u mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Enimaa lirna onne nin panaeku suwsuwar nano Nin man lernohi pakunohi enihe de ka rauroin Nin wanakunu onne nina panaeku wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hi rala'a laa Yerusalem na'ikeki rakan kota Yeriko ne, hir holikuku ri maktoko ida naikoro mehe napanpanak aile kalla arkanne. ");
INSERT INTO kjeNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","An derne ri namansa lolnohi ai, de na'ukani, “Oih! Inhawa aile lolo eni?” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rin konohie na'ahenia, “Yesus ma nano Nazaret lolo eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","An dernedi onneni ne, wakau naruri na'ahenia, “Yesus, Daud upun anan Owe, maramyakala'u ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Enime'ede ri ma nolu rakan maktoko onne ra'ahan de dadiyale ra'aheni, “Karkaramedi!” Maa, ai namhene, wakau eren narururi na'ahenia, “Daud upun anane maramyakala'u ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus derne lirna onneni, namririyala la hopon ri laa ni'ik maktoko onne nore mai. An rakanedi ne, Yesus na'ukanie, ");
INSERT INTO kjeNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O raram nodi Ya'u hi'i inhawa ki o?” Ai na'ahenia, “Makromod, i raram nodi i mak'u do'onedi ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Enine Yesus na'aheni, “Wa'ane, o makum wa'anedi me'e! O akim naili'il Maya'u de om wa'anedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ideweni ne, ai makan mouwedi la an lernohi Yesus. Hir rala'a ne, ai na'uli nasa'a Makromod Lalap. Heri man po'on hini'i onne na'akeme ra'uli rasa'a Makromod Lalap haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Enime'ede Yesus lan lolale kota Yeriko. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lolo kota onne uluwakun man ra'uk paipair man karu ida aile. Ri onne naran Zakeus. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakeus raram nodi do'onala Yesus, maa ri namansa rehi de kan do'on wawa'an ono kemen dedeulanedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ende an lari noluwedi ri na'akeme ha'a laedi ara ono lalapida lolo kalla arkan leke do'on Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus rakanedi ara ono onneni, An po'on laa wawan ne, do'on Zakeus la hopon na'ahenia, “Zakeus! Kopur here! Lere eni Ya'u minle onum nakar.” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Enime'ede Zakeus pelek kopur la akin nahuwa'an wake'e de norkaru Yesus laa nin nakar me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ri namansa do'odo'on onneni ne, kar suk de ra'aheni, “Heih! Zakeus onne ri man hi'i dohohala menee! Hi'ihepenia Yesus noro ai laa nin nakar?” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hir rakanedi Zakeus nin nakar ne, ai namriri lolo onne konohi Makromod na'ahenia, “Makrom'u, nano lere eni me'ede lo'o ha'ar ainu'u linikir kanaru namwali woro'o, ya ala hana'arne ida laa ma na'alehe haida-haida, la lo'o ya'u ra'ukedi paipair nano ri narehiyedi me'e, ya ala wali'ur rew'akka nine hi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus ne'el ai na'ahenia, “Lere eni me'ede o moro num nakar raram na'akeme lernaledi or'ori dardari ma kan horu me'e, ono akim naili'il Makromod naise ik upud a'ad Abraham. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ya'u, ma namwali Ri Mormori Anan, peni mai noho wawan anoin ri man molu la ma ka nauroin Makromod Nin kalla leke huri we'er hi nano rir dohohala nin molollo.” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus nala'a na'akeki rakan Yerusalem la ri nammori pene'ek nahenia lo'o Makromod Lalap niliyedi lere alam eniyeni leke kikan Ai namwali Rai mai noho wawan eni. Ende Ai nala wanakunu naho'ok ida wali'ur heri ma nore ra'alono la rakakani Nin wanakuku mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ai na'aheni, “Marna ida nin panaeku laa hair namehin man ko'u leke rai man kulu narehi kikan ai namwali rai nanumene wali wali'ur mai nodi molollo nina nohe onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Maa kan laa makun, ai napolu nin hophopon wahwahan idaweli maiwuku la nala hi dohodoho kupan mahe ida. Nala kupan horu, an hopon na'ahenia, ‘Modi kupan onne lam weli hahaa, ma'olu hehen nanumene ya'u wali mai.’ Kame'ede ai nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Enimaa marna onne nin nohe ne'en raram kar suk ai. Ende ai nala'edi ne, hir hopon rin lernohi rodi lira ma na'aheni, ‘Ai mamhene marna onne namwali ainima rai!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kade hir hi'i heheni, maa kikan marne onne namwali rir rai nanumene wali mai nin nohe. Waliyedi laa nin nohe ne, ai napolu nin hophopon wahwahan enihe mai rakpalie leke nauroin hir lernaledi kupan mahe ai nanala nonolu eni ihin ennen wo'ira me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hophopon dedesne nine man konohi, ‘Papa rai! Kupan mahe mamala maya'u onne na'uwaliyedi idaweli wali'ur me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Makromon na'aheni, ‘Ma'aruru! O mamwali hophopon wahwahan man wa'an. O mamkene howok kakar tarana modi aki ma namdudu de ya'u kikan o modi molollo kote idaweli.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hophopon wahwahan woro'o nine na'aheni, ‘Papa rai! Kupan maha mamala maya'u onne, ya a'uwaliyedi wolima wali'ur me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Makromon walhe na'ahenia, ‘Wa'an, modi molollo kote wolima!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Onne horu nin hophopon wahwahan namehin mai na'aheni, ‘Papa rai! Num kupan mahe meneni, ya a'akene wawa'anedi lolo tapi ida de kan molu! ");
INSERT INTO kjeNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ya amka'uk pap rai ono ya auroin papa owok. Enla papa lernala wawa'an nano ri namehin nin honowok man werek, la ma'ili madai inhawa man kam pekir ariyone.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Makromon walhe, ‘Ri ailanna o! Onum wanakunu mehen hukum o kemen. Lo'o mauroin ya'u eni owok, la ya ala wawa'an nano ri namehin nin honowok, la a'ili adai inhawa ka'u pekir ariyono, ");
INSERT INTO kjeNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","alhi'ihepe ka modi kupan onne laa pakuwedi lolo kupan onno leke ya'u wali mai kokala kupan eni noro dipin woini?’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kame'ede rai onne komdere ri ma namriri lolo onne na'ahenia, ‘Mala nin kupan mahe onne, kanile man lernala kupan ihin ennen nalrewen idaweli onne!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Maa hi ra'aheni, ‘Pap rai, ainin kupan mahe idaweli aiyedi me'e menee!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Maa rai onne walhe, ‘Horhorok! Ri ma nadiyaka wawa'an inhawa man rarala ai, rala na'ikar na'uwali ai. Maa inhoi ma ka nadiyaka wawa'an inhawa man rarala ai, nin hahaa tarana ma aile rala mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Enla ors eni modi ainu'u arwali ma namhene ya amwali rai mai eni here! Mesne mouwedi i kalar'u!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus wakuku onne horu, Ai noluwedi heri nala'a mamani laa kota Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na'ikeki rarakan leke Betfage noro Betania ma aile wo'or Zaitun, An hopon Nin man lernohi pakunohi woro'o na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mala'a laa leke man aile kalari onne. Rakanedi leke raram lo'o mim do'on keledei ida man ri ka naikorala makun na'inonorok aile lolo onne. We'ere, modi mai Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Enimaa lo'o ri lolo onne ra'uhoi mi ra'aheni, ‘Hi'ihepenia mim we'er keledei onne,’ konohi hi na'ahenia, ‘Makromod Nina panaeku aile nairale!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Enime'ede woro'ohe rala'a do'on na'akeme naise Yesus na'aheheni eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hir wewe'er keledei nin kali onneni, orkeledei onnenihe ra'uhoi, “Heih! Hi'ihepeni mima we'er keledei onne?” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hir walhe, “Ik Makromod napanak nairre!” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kame'ede hi ri'ik keledei onne mai Yesus, la ruri rira rain nanaru rodi pakala keledei ko'orne mene paku Yesus naikore wawan. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ai naikoredi keledei ne, ri nammori ruri rira rain nanaru werre kalla wawan leke An lole. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","An kopkopur wo'or Zaitun na'uraniyedi Yerusalem ne, Ainin man lernohi nammori aile, la hi akinhe rahuwa'an rehi, de wakau raruri ra'uli rasa'a Makromod Lalap ono hir do'onedi Yesus hi'i tanada man hi kar dodo'onnale makun. Hir wakau wewerre ra'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Makromod Lalap namre'e namharu Rai man mai nodi Ai Oin Naran. Lere eni ri mormori roro Makromod Lalap ma aile a'am raram rahuwa'an wali'uredi me'e. Mai ka'uli kasa'a Makromod Lalap Man Kulu Narehi Man Lap Narehi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ri Parisi ida woro'o ma aile heri onne raram re'el Yesus, “Papa Meser! Dadiyala Num man lernohi enihe leke karkaramedi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Maa An walhe na'ahenia, “Yom dadiyalahe! Ya'u konohi mi! Lo'o hir karkaramedi, waku eniyenihe herre hi wakaukau ra'uli rasa'a Makromod!” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus na'uraniyedi Yerusalem ne, An po'on kota onne nahere me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ai na'aheni, “Aduu, Yerusalem mie! I raram nodi wake'e mi mehe mauroin hi'i hehewi leke lernala aki man moiliwi mahuwele, maa ors eni moiliwi mahuwele onneni suwaredi nano mi de kam do'on mauroin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Rakan ler ida minim arwali mai olok o la hi'i lukur man kulu lolo o herne wali-wali leke yon ri mahaku lari. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hi raiye'er o la resne mouwedi num ri mormori na'akeme. Hi ra'anehe kote na'akeme, penia waku ka nadinara me'e la resne mouwedi num ri ono ka mahiyenala Makromod Lalap lere An mai leke nala or'ori dardari ma kan horu mi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus nala'a laa Makromod Lalap Nina Romleu Lape. An rakan Romleu nin nikoin, Ai nohiyedi ri ma na'olu hahaa lolo waliwali na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Enla Ai na'aheni, “Lolo Horok Lap raram, Makromod Lalap konohi, ‘Ainu'u Romleu Lapeni namwali onno rin mai leke hi'i lir napanak, maa mim hi'i namwali ri ma namna'a onno.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Akilere Yesus wakuku lolo Romleu Lap onne. Enla imam-imam lalap, meser-meser Horok Lap roro Yahudi rir man panulu ranoin kalla leke resne Ai, ");
INSERT INTO kjeNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","maa kar lernala, ono ri namansa mai mamani leke rakani Nin wanakuku ma nedille hi akinhe. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ler ida Yesus mahan wakukuku Makromod Lalap Lirna Wawa'an lolo Nina Romleu Lapa nin nikoin ne, imam-imam lalap roro meser-meser Horok Lap roro Yahudi rir leleher lalap enihe mai ");
INSERT INTO kjeNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ra'ukani Ai ra'aheni, “Inhoi nala molollo ki O, penia mam hi'i ha eniyeni na'akeme?” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus walha hi na'ahenia, “Ya a'ukaniyala paphe na'ukankani ida haenhi. Konohi Ya'u, ");
INSERT INTO kjeNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanis ma nodi oir ulutade ri eni, nodi molollo nano inhoi, Makromod Lalap, ee ri mormori?” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kame'ede hi ida ma nawalha lira noro ida ra'aheni, “Lo'o ik ka'aheni Yohanis nodi Makromod Lalap Nina molollo, enlo'o Ai na'ukani alhi'ihepenia ik akin ka naili'il Yohanis nin wanakunu? ");
INSERT INTO kjeNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Maa, lo'o ik ka'aheni ai nodi ri mormori nin molollo, heri na'akeme ma aile mai eni lo'o rodi waku waslesne maika, ono hi rauroin Yohanis onne nabi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ende hi re'enohi walha Yesus na'ahenia, “Ai ka mauroin an lernala molollo onne nano ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus na'aheni, “Ka'u konohi mi inhoi nala molollo Maya'u haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Enine Yesus nala wanakunu naho'ok ida wali'ur heri na'ahenia, “Ri ida lan kaman anggur kirna ida. Horu, ai nala nin kirna ri woro'o wokelu howok leke hir ha'ar ihin ennen rala heruwali wali'ur ai. Kame'ede, ai lan min nalo'ol onno namehin. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Rakan lere ra'ili radai nin kirna raramne, an hopon nina hophopon ida laa kokala nina hana'arne nano man howok kirna onneni, maa man howok kirna enihe nukure, hopon nalalaliyedi wali wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Enime'ede orkirna hopon nin hophopon namehin laa wali'ur, maa man howok onnenihe nukur la ilnohi ralnohi ai haenhi, mene hopon nalalaliyedi wali wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Horu, orkirna hopon nin hophopon rewkelu nine laa enne, maa hir nukur hehen nanumene namno'edi la kele, sopol laedi kirna paharne. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Orkirna onne noro akin wakunu na'ahenia, ‘Ya'u lo'o hi'i inhawa ho'o? Wa'an rehi ya'u hopon ya an'u man ya aramyake laa enne me'e. Lo'o hir horhawe la kokale wawa'anedi.’ Kame'ede an hopon anan laa enne. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Enimaa, man howok kirna enihe do'onedi orkirne ananne, hi ida ma ne'el ida na'ahenia, ‘Lo'o aman makiyedi ai namwali orkirna. Mai ik kesnedi anan leke ika manarnedi kirna enie.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ende hir kele ai, sopoledi laa kirna paharne mene resne.” Yesus na'ukani hi na'ahenia, “Lo'o orkirna derne ha ma namwali onneni an hi'i inhawe? ");
INSERT INTO kjeNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Memen an mai nesne mouwedi man howok kirna onneni mene nala nin kirne ri namehin howok.” Heri derne Yesus Nin wanakunu ne, ra'aheni, “Yono hi'i de namwali heheni!” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus po'on desnala hi na'aheni, “Mi ma'aheni, ‘Yono hi'i de namwali heheni’, maa onne lo'o namwali me'e. Onne penia wanakunu aile Horok Lape raram ma naho'ok Ya'u noro waku na'a'ar. Horok Lap Lirna onne na'ahenia, ‘Waku man ma nayapi nakar sopoledi me'eni, Makromod Lalap hi'iyedi namwali waku na'a'ar ma na'ono.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inhoi nediyawa lolo waku onne wawan, ai onne lernala apinpinha, la inhoi waku onne dunie, lo'o namwaliyedi elimo'o hapu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Meser-meser Horok Lap roro imam lalap onnenihe rauroin Nina wanakunu naho'ok onneni nala hi kemenhe de ranoin kalla leke idewe kele Ai, maa hi ramka'uk heri enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ende hi radiyaka Ai mamani. Hir hopon ri man koklolo na'inau laa ranoin Yesus Nin sala. Ri eniyenihe kokme'e ramwali ri ma akin mou la ra'ukani Yesus na'ukankani wo'ira leke An wakunu ha man sala. Hir ken paipudie leke yon hi'i de An wakunu ha man sala haromo ne, hir tumdesne lolo gubernor kalarne. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ende man koklolo na'inau onnenihe laa ra'ukani Yesus ra'aheni, “Pap Meser, ai mauroin Pape akin mou la mehem wakunu panaeku ma namlolo mamani la kan wakuku ha man sala ida. Papa ka na'ili naloho ri, maa Papa wakuku Makromod Lalap Nin kalla lernohi panaeku ma namlolo. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ende ai ma'ukaniyala Pape panaeku ida ke'e! Lernohi iknika agame nina holoor halauk, lo'o wa'an ik pair Roma nin paipaire laa rai Kaisar, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Maa Yesus nauroinedi hi akin kan mou de na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mala kupan pere ida modi mai I po'onale.” Hi rala kupan pere ida mai An po'onedi mene na'ukani, “Inhoi oin makan noro naran melle kupan enie?” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hir walhe, “Kaisar.” Ende Yesus na'aheni, “Inhawe man Kaisar nine, male Kaisar, la inhawe man Makromod Lalap Nine, male Makromod Lalap.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ende kar paekunala paipudi Ai lolo heri kalarne. Hir dernedi Nin wanalheni mehe nanana mouwedi de ka ra'oho me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Enime'ede ri Saduki ida woro'o mai ra'ukani Yesus haenhi. Heri Saduki rira honorok panaeku ri man makiyedi kar mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hi ra'aheni, “Pap Meser, nonolu Musa horokedi nounaku nahenia lo'o mo'oni ida ho, maa an maki na'alehe tatana, wa'an rehi mo'oniwalin ho wali'ur orno onneni leke lernala tatana nahinerre walla man maki eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ende hi rala wanakunu eniyeni, “Lerida ri wo'ikku ma na'umo'oniwali aile, la anulu hoedi, maa maki na'alehe ananne. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Enime'ede walin man lernohi ai ho wali'ur orno, maa ka nalo'ol maki na'alehe ananne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Onneni namwali noro walin wokelu nine wali'ur. Hi'i heheni hehen nanumene mo'oniwalla man karuri maki haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kame'ede maeke onne maki na'alehe anan mahaku haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ende rakan lere alam rin mori wali'ur, maeke onne namwali inhoi hono? Mo'oni wo'ikku eniyeni na'akeme penia hoedi noro ai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus walhe na'ahenia, “Ri man mori mai noho wawan eni, hir ho, ");
INSERT INTO kjeNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","maa ri man Makromod Lalap mehen nili de na'amori wali'ur minle a'am raram kar ho me'e, ");
INSERT INTO kjeNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ono hir mori raisedi Makromod Lalap Nin hophopon a'am raram, de kar maki me'e. Hi ramwali Makromod Lalap ananhe ono Ai na'amoriyedi hi nano makmaki me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mi akim ka naili'il nahenia ri man maki mori wali'ur, maa Musa mehen wakunu mouropo lolo nin horok nahenia ri man maki mori wali'ur. Ik kauroin onne ono an horokedi Makromod lirna man an dederne lere an do'on aiye man lerlere lolo au um'umu raram. Lirna onne na'aheni, ‘Ya amwali Makromod Lalap man Abraham, Isak, noro Yakup ra'ul'uli rasa'sa'a rakan lere eniyeni.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ri man makiyedi ka ra'uli rasa'a Makromod Lalap, maa ri man mori penia ra'uli rasa'e, la Makromod Lalap mehe nauroin ri na'akeme man makiyedi mori wali'ur lolo Ai leken kalarna.” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Derne Yesus Nin wanakunu onneni ne, meser Horok Lape walhe ra'aheni, “Papa Meser Nin wanalha onne namlolo wake'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nano lere onne me'ede ri namka'uk ra'ukani haida-haida Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Enime'ede Yesus na'ukani hi, “Alhi'ihepenia meser agame enihe ra'aheni Kristus namwali Daud upun ananne? ");
INSERT INTO kjeNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daud mehen horok Makromod Lalap Lirna ma na'ono Mesias lolo horok Mazmur na'ahenia, ‘Makromod Lalap ne'el i Makrom'u na'ahenia: Maikoro I her'u malanne ");
INSERT INTO kjeNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hehen nanumene Ya'u hi'i Num arwali enihe lolo yawa ki O.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ende lo'o Daud napolu Kristus, ‘Makrom'u’, hi'ihehewi namwali upun anan mememen haenhi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Heri rakankani Yesus Nin wanakunu eni ne, Ai ne'el Nin man lernohi pakunohi enihe na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lere moro meser Horok Lap eniyenihe minwuku, madiyaka mi memen leke yon lernohi rir hini'i wenewhe ma ka namlolo, ono hi raram nodi nair rain nanaru lalaa mamai leke rin po'on de rauroin hi eni man panulu, la hi raram nodi laa pasar raram leke rin horhawe. Hir laa Yahudi rira kerei raram ne, suk raikoro kalari, la lere hir laa yapi kalla, suk raikoro mei uluwakun haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Enla hir wukupodo maeke walwalum enihe, leke rahoro rira nakar, maa hir hi'i lir napanak nanaru rodi pupin aduwala rir hini'i wenewhe ma ka namlolo. Ri eniyenihe lernala hunukum man werek wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus mahan wakuku lolo Makromod Lalap Nin Romleu Lap eni, An po'on orkanaru ida woro'o rodi rira kupan mai loile honoi kanani onno raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","An po'on maeke walwalum ida ma na'alehe haida-haida mai nala doit waku woro'o loile honoi kanani onno haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesus konohi Nin man lernohi pakunohi enihe na'ahenia, “Loi honorok wawa'an! Maeke walwalum ma na'alehe haida-haida onne loi kupan nammori narehi ri namehin na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ono nina kupan nodi momori akilere na'akeme loile honoi kanani onno eni, maa ri namehin rodi tarana mehe nano rira kanaru man lapa.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lere onne Yesus Nin man lernohi pakunohi heruwali po'onala Makromod Lalap Nina Romleu Lapa ra'aheni, “Makromod Lalap Nin Romleu Lape eniyeni ma'aruru wake'e, ono rodi waku man ma'aruru hi'ie, la rodi hahaa man ma'aruru namehin ra'akeki haenhi. Hahaa onneni ri nala rodi hoikani Makromod Lalap.” Maa Yesus ne'el hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Rakan lere man Makromod Lalap mehen nili, ha mim po'opo'on eniyeni, arwali mai raiye'er mouwedi de nin waku danaran na'akeme ida ma ka nadinara ida me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Horu ne, Yesus Nin man lernohi pakunohi enihe ra'ukani, “Pap Meser! Ha onneni ma'anana lo'o namwali? Am lernala inhawa tanade leke mauroin nahenia nina lere alam na'uraniyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus walhe, “Nakinemen ki mi, kalo'o rin paipudi mi, ono ri nammori lo'o rodi I naran mai ra'aheni, ‘Ya'u eni, Kristus!’ la, ‘Noho nin man horu na'uraniyedi me'e.’ Maa yon lernohi hi! ");
INSERT INTO kjeNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lo'o mim derne lira ara lolo ewi-ewi, yono mamka'uk, ono ha rahu onne namwali nolu, maa noho nin man horu onne kan rakan makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lolo noho pa'i'ik rai pakakar ida ma na'ara noro ida, hair ida na'ara noro hair ida. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Enla noho wawan eni lernala rururuwai man lap narehi, roulara lalapa, noro apinha wo'operi man pelek rin nammori lernala. Lolo a'am mim po'on tanade man lewlewen man hi'i ri namka'uk rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Enimaa hir kele mi la hi'i apinpinha mi nolu mene panaeku onne na'akeme namwali. Hi rodi mi laa makpali agame nina man ho'ok kail, la rala mi laa bui raram. Enla hi rodi mi laa makpali rai-rai noro ma nodi molollo namehin ono mi akim naili'il Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lere onne me'ede mim lernala leken loikaru I Lir'u hi kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ende hi'i mi akim namkene la yon ma'irhu inhawa mim walha modiyala mi kemmu lere rin tumdesne mi, ");
INSERT INTO kjeNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ono Ya'u mehe ala wanakunu noro woroin ki mi leke modiyala mi kemmu, penia minim arwali enihe ka rauroin rawalha lir roro mi la kar lernala minim salida. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Lere onne ri nammori kar suk mi, ono mim lernohi Ya'u. Mi inum ammu, mo'oniwallum, narum, meheromo raramne, lodon wallumhe noro minim na'aromwali me'ene ranoin kalla koklira ki mi, la hi resne mi heruwali haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Maa minim muruk lisar ida me'e ne kan molu! ");
INSERT INTO kjeNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ende lo'o mi mamkene akin naili'il Ya'u mamani, mim lernala or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Lere mim do'on ma nasala ke'urauk nammori olokedi kota Yerusalem, mauroin nahenia ka nalo'ol nadiporo me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lere onneni inhoi aile Yudea lari mouwedi laa wo'or! Man minle kote raram, lariyedi laa paharne! Enla man minle kote paharne yono laa kote raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lere onne penia hunukum man werek wake'e mai leke na'akuku na'anokoredi inhawa man nabi-nabi horokedi nonolu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ooih! Lere onne maeke ma nornoro raramne roro man anan huhuhu makun, apinpinha nore! Manin Israel lernala apinpinha wake'e ono Makromod Lalap nawuhur hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Arwali rodi raa daresne heruwali, kele heruwali wuku rodi laa hair-hair namehin na'akeme ma ka nauroin Makromod. Enla Makromod Lalap hurinohi ri ma ka namwali Yahudi enihe rodi rurilai kerne dalha manin Yerusalem hehen nanumene rakan lere alam An kukukule nokoredi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lere onne manin noho wawan po'on tanada man ri kan dodo'onnala makun lolo lere, wollo, noro kaliyore. Enla lolo noho wawan ri na'akeme do'on derne kahi anna lapa wake'e de ramka'uk rehi la mehe kakaiyedi penia ka rauroin hi'i inhawa me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ri mormori ramka'uk rehi penia heruwali oin makan metek ono ka rauroin inhawa lo'o namwali lolo noho wawan eni. Ha ma nodi molollo lolo a'am na'akeme narururu wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lere onneni rin do'on Ya'u ma namwali Ri Mormori Ananne, mai lolo kakam odi ke'eke'el an'anhe ma narehi nalewen la hir po'on Ya'u siksika lerlere waliwali. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lere mim do'on tanada na'akeme onne namwali, wanna ha'edi mi uluwakun la mahuwa'anedi mi akim here, ono ka nalo'ol me'e Makromod huri we'er mi nano noho wawan nin apinpinha me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesus nala wanakunu naho'ok ida na'ahenia, “Po'onala ara ono noro au'ono namehin enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mim po'on ara ono kawin mokon marra me'e, mi mauroin nahenia ka nalo'ol woi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Naisa onne, lere mim do'on ha onne na'akeme namwali mi mauroinedi nahenia lere alam Makromod Lalap namwali rai ma nodi molollo mai noho wawan na'uraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ku eniyeni kar maki horu hehen nanumene ha eniyeni na'akeme namwali. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A'am noro noho eniyeni lo'o moluloin, maa Ainu'u wanakunu eni kan molu laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Madiyakyaka mi wawa'an ono mamlilinnohi Ya'u wali wali'ur mai noho wawan! Yon hi'i de mim hi'i yapi ma'ak mamani, momun arak manha de hi'i ha man ailanna mamani, ee mahinorok minim popono orereki mamani penia maprehen hi'i panaeku ma nahuwa'an Makromod akin. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ainu'u mamai onne mamlilinnohi namwali ri na'akeme lolo noho wawan, naise honhonow man rodi kele manu de namlilinnohi honowedi manu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ende madiyakyaka mamani la yon ren hi'i lir napanak leke mim kerhu lolo sus onnenihe na'akeme. Enla mi akim namkene naili'il Ya'u mamani leke rakan lere Ya'u ma namwali Ri Mormori Anan eni mai wali'ur ho'ok kail ri mormori, ka mamka'uk mamriri Ya'u kalarna.” ");
INSERT INTO kjeNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Akilere Yesus wakuku lolo Makromod Lalap Nin Romleu Lape, maa lere helem ne, Ai namhara Yerusalem laa namkuru lolo wo'or Zaitun. ");
INSERT INTO kjeNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ende akilere al'alam wake'e ri na'akeme mai Romleu Lap eni leke derne Nin wanakuku. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yahudi rir Lere Alam Lalap ‘Ra'an Roti Ma Na'alehe Ragi’ man wekel ‘Lere Alam Lalap Paska’ na'uraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Lere onne imam-imam lalap roro meser Horok Lap enihe maha ranoin kalla ma nasinuwar leke resne Yesus. Hi ramka'uk heri onnenihe ono heri onne raram nodi derne Nin wanakuku eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Enime'ede Hayakyak Makromon hu'urle Yudas raramne. Ai onne rapolu Iskariot haenhi la namwali Yesus Nin man lernohi pakunohi ida nano ri idaweli woro'o enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Enpenia Yudas laa noro imam-imam lalap roro ri ma nadiyaka Romleu Lapa rir uluwakun enihe wakunu wuku leke rauroin lole inhawa kalla man wa'an nala Yesus mai kanile hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hir dernedi Yudas nin panaeku eni, hi akin nahuwa'an wake'e la ra'aheni, “O mala Yesus mayai, ai mala kupan ki o.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas ne'enohi rir panaeku de nanoin leken paharin nala Yesus hi leke yon heri rauroin. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Enine Yahudi rir Lere Alam Lalap ‘Ra'an Roti Man Na'alehe Ragi’ nin lere dedesne rakanedi me'e. Lere onne Lere Alam Lalap Paska de hi radedem ra'akene pipdumana leke resne ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Enime'ede Yesus hopon Petrus noro Yohanis lar ra'akene Paska nin hanana'an nonomun leke hir ra'an romun wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Woro'ohe ra'ukani, “Pap raram nodi am laa ewi ma'akene Paska nina ya'an yomun?” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","An walhe, “Mim laedi Yerusalem raram ne, mim pakromo mo'oni ida nodnodi oir e'en de lernohie laa nakar man an lalaa raram. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kukunohi ornakar nahenia Pap Meser na'ukani lo'o Ai noro Nin man lernohi pakunohi enihe ra'an romun Paska lolo onno ewi? ");
INSERT INTO kjeNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Enla ornakar onne lo'o kukul onno lapa ida ki mi aile danaran wawan man ai na'akenedi me'e. Miro ma'akene nana'an nonomun Paska lolo onne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hi rala'a laa rakan kote raram, do'on ha wo'ira na'akeme naise Yesus konohiyedi hi eni. Idewe hi ra'akene hanana'an Paska. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Rakanedi ya'an yomun Paska nin ors jam ne, Yesus noro Nina hophopon ma nodi Lirna Wawa'an enihe raikoro wuku ra'an romun wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesus ne'el hi na'ahenia, “Ya akin namrana rehi oro mi aikoro wuku ka'an komun hanana'an Paska eniyeni nanumene Ya'u lernala apinpinha. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Derne makani Ya'u! Ik ka'an komun eni horu, ka o'on omun naisa eniyeni hehen nanumene rakanedi Lere Alam Lalap Paska eni nin panaeku na'akuku na'anokoredi lolo Makromod Lalap Nin noho worworu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Enime'ede An roulle cawan anggur, la napanak trimkasi Makromod Lalap. Horu, Ai na'aheni, “Mala eni mi dohodoho momun. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya'u konohi mi, nano lere eni me'ede ka omun anggur eni hehen nanumene Yo omun anggur worworu lere alam Makromod Lalap mai nodi molollo ri na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Onne horu, Ai nala roti napanak trimkasi Makromod Lalap nanumene a'un roti onne nala hi ra'an la na'aheni, “Roti eniyeni, Yi ihin kem'u man Ya ala leke paku mi. Hi'i heheni leke yono hamlinu Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hi ra'an romun horu, naise idedi eni Ai nala anggur cawan onne wali'ur na'aheni, “Cawan ihin eniyeni naulinu nawali Nou Worworu man Makromod Lalap nanale man hi'i Ai noro ri mormori radinu'ul rakinaliyedi wali'ur. I rar'u ma nakliu lere Ya'u maki na'ono nawinau Nou ma namkene onne la huri we'er mi nano dohohala nin hunukum. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Maa po'onala! Ri ma na'olu Ya'u kani laa Ainu'u arwali enihe koro wewerre ai lolo eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Memen Ya'u, Ri Mormori Anan, maki ono Makromod Lalap hi'iyedi kenekrohu Ya'u maki me'e, maa ri man kani Ya'u laa arwali onnenihe mayo'o wake'edi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nin man lernohi pakunohi enihe dernedi Nin wanakunu eni, ida ma na'ukani ida leke rauroin inhoi man paeku heheni. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus Nin man lernohi pakunohi enihe rasesi panaeku ma na'ono inhoi man lapa narehi nano hi onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Onne penia Yesus ne'el hi na'ahenia, “Lolo hair-hair ma ka nauroin Makromod Lalap, rir rai enihe kerne dalha hirira ri mormoriyana mamani, maa hi me'ene ra'aheni hi ramwali man paku rir nohe ne'en raramne. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yon mim hi'i heheni, maa inhoi man kulu narehi wa'an rehi an holi naisa man lolo yawa. Enla ma nodi molollo eni wa'an rehi an holi naise hophopon wahwahan. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ken mahinorok, inhoi man kulu narehi? Ri ma naikoro mei na'ak, ee ri man lolo honopon wanahan ai? Ri na'akeme rauroin ma naikoro mei na'ak eni peni man kulu narehi! Maa Ya'u eni mai oro mi minwuku la ilitolle ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mi eniyenihe, moro Ya'u mamani lere Ya'u lernala apinpinha. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Enla naisa Ya Am'u kikan Ya amwali Rai ma nodi molollo, na'amoli Ya'u kikan mi mamwali rai-rai ma nodi molollo haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","leke moro Maya'u kaikoro ka'an komun lolo mei man aile Ainu'u molollo onno la mi maikoro onno kukulu leke ho'ok kail Israel nin luhu idaweli woro'o enihe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Enime'ede Yesus ne'el Simon Petrus na'ahenia, “Simonee! Makaniyala! Makromod Lalap hurinohi Hayakyak Makromon ken mi na'akeme naise ri man ka'i aliwerhe naheir ulikin nano ihin. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Maa Ya'u hi'iyedi lir napanak ki o Simon leke yon o akim nahinuri Maya'u. Enla lere om wali wali'uredi Maya'u, ma'alapedi o wallum akinhe haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus walhe, “Lo'o ka, Makromod! Kade yo oro Pape laa bui raram, ee maki wewerre, maa ka'u huri Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus na'ahenia, “Petrus! Makani wawa'an! A'alam eni me'ede manu kan kokoroi makun, o ma'aheniyedi ka mauroin Ya'u rewkelu me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Horu Yesus na'aheni, “Horokala! Lere Ya'u hopon mi lam loikaru lir wawa'an nonolu eni, ka modi kupan, tas, noro pakpak ei herherre. Hi'ihehewi, lere onne minim ha wo'ira noknokor, ee ka?” Hir walhe, “Ha wo'ira noknokor, Pape!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ai na'aheni, “Maa ors eni yom hi'i heheni me'e. Lo'o minim kupan me tas aile haromo, modie, la lo'o ma'alehe raa, ma'olu minim rain leke modi weli raa, ");
INSERT INTO kjeNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ono Yesaya horokedi lira ma na'ono Ya'u na'ahenia, ‘Hi rahinorok Ai namwali ri man ailanna.’ Enla horhorok eniyeni namlolo kokkoo ra'akuku ra'anokoredi lolo I kem'u. Namlolo! Inhawa man horokedi lolo Horok Lape ma na'ono Ya'u, ik do'on namwali lere eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nin man lernohi pakunohi enihe ra'aheni, “Makromod! Po'onala! Ai modmodi raa woro'o!” Yesus walhe, “Yom wakunu onne me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Enime'ede Yesus namharedi Yerusalem nala'a laa wo'or Zaitun naise nadedem, la Nin man lernohi pakunohi enihe lernohi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hir rakanedi lolo onne ne, Ai ne'el hi na'ahenia, “Hi'i lir napanak leke yono madiyaur kenene panatal de hi'i dohohala.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Horu Ai nala'a kan ko'uwala, lo'o penere wellima nano hi, mene kadi ein korno hi'i lir napanak na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Papee! Ya apanak Om huriyedi Ya'u nano wewerek pananaka Ya a'uwarwara eniyeni. Maa yom hi'i lernohi Ainu'u honorok panaeku, maa hi'i lernohi Papa Nin honorok panaeku mehe!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Enime'ede hophopon a'am raram ida mai na'aruriyala akin. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus nodi aki man woir wake'e hi'i lir napanak mamani hehen nanumene ka naruri me'e la Nin awenne dupu laa yawa naise rare. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hi'i lir napanak horu, An wali laa Nin man lernohi pakunohi enihe, maa hi ramkukuru mahaledi ono akin woir rehi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ai napolu hi na'ahenia, “Alhi'ihepe mamkuru? Mamakedi here la hi'i lir napanak leke yono madiyaur lere mim lernala kenene panatal.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus wakunkunu makun, ri nammori mai, la Yudas ma namwali Yesus Nin man lernohi pakunohi ida nano idaweli woro'o enihe ni'ik kalla hi. Hir mai ra'uraniyedi ne, Yudas lan masiyedi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maa Yesus na'ukani Yudas na'ahenia, “Mam masi Ri Mormori Anan leke mala kanile laa Nin arwalie?!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nin man lernohi pakunohi enihe do'on rauroroin rir panaeku eni, hir ra'ukani Yesus na'ahenia, “Makrommu, lo'o ai modi raa eniyenihe daresne hi?” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kame'ede Nin man lernohi ida lehu nin raa dara imam man kulu narehi eni nina hophopon ida me'ede, kilinna wali malanna nadiyauredi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Maa Yesus na'aheni, “Wa'anedi me'e!” Enine An tukulala ri onne kilinna de hi'i wa'anedi wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Enime'ede Yesus ne'el imam-imam lalap roro ma nadiyaka Makromod Lalap Nin Romleu Lape rir uluwakun roro Yahudi rir leleher lalap enihe na'ahenia, “Mi mauroin Ya'u eni ri man ailanna penia modi ilak raa noro au deul mam kele Ya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Akilere Ya'u wakuku mi lolo Romleu Lap raram, maa mi kam kelA'u. Enimaa lere eni me'ede Makromod Lalap hurinohi Hayakyak Makromon man howok lolo noho momohon nodi molollo me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hir keledi Yesus ne, rodie laa imam man kulu narehi nin nakar. Enla Petrus lernohi lolo kili'ur ko'u tarana. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Rakanedi nakar onne nin nikoin, hir hunuku aiye lolo nikoin toro la raikoro poloweweredi, la Petrus laa naikoro nohiyedi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka nalo'ol maeke hophopon wahwahan ida popo'on ai wawa'an de nahiyennale la na'aheni, “Heih, ri eniyeni noro Yesus ra'alono wewerre haenhi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Maa Petrus na'okuledi na'ahenia, “Ka! Ya'u ka auroin Ri onne!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kan maha ne, ri namehin do'on Petrus la na'aheni, “Heih! Memen o eni Yesus Nin ri!” Maa Petrus na'aheni, “Ka, ka'u lernohi Ri onne.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lo'o jam ida wali'ur ri namehin ida na'aheni, “Woi! Ya auroiroin ri eniyeni man lernohi Yesus mamani ono ai eni manin Galilea.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Maa Petrus walhe, “Papee! Ka auroin onum wanakunu onne nin panaeku!” An wakunkunu makun, manu kokoroiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kame'ede Yesus waliyedi oin makan po'onale Petrus. Enine Petrus horoknaledi Makromod Lirna ma na'ahenia, “A'alam eni me'ede manu kan kokoroi makun, o ma'aheniyedi ka mauroin Ya'u rewkelu me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ai raram penuwale me'ede nala'a paharne nahere maheruheru. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma nadiyaka Yesus enihe lupurale, hadwei hadwokor la nukure. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hir pasunala oin makan nanumene ra'aheni, “Heih, nabi O! Ken konohi yai inhoi nukur O!” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hir warei diwar dawar rodi ra'ihoru ra'idaru Yesus mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Al'alam makun Yahudi rira leleher lalap, imam-imam lalap roro meser-meser Horok Lap ma namwali Yahudi rir muku man ho'ok kail enihe hopun pepen leke ho'ok kail Yesus. Ma nadiyaka Yesus rodi Ai laa nakpali hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hi ra'aheni, “Konohi yai, O eni Kristus, ee ka?” Yesus walhe, “Ya'u konohi mi maano mi akim ka naili'il Ya'u, ");
INSERT INTO kjeNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","la Ya a'ukani mi maano kam walha Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Maa nano lere eni me'ede Ya'u ma namwali Ri Mormori Anan, aikoro lolo Makromod Lalap Ma Nodi Molollo Narehi Nalewen Na'akeme herne malanna.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hi na'akeme ra'ukani, “O eni Makromod Lalap Ananne?” An walha, “Namlolo! Mi mehe ma'aheniyedi onne me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kame'ede hi ra'aheni, “Ik mehe dernedi Nin wanakunu man kuku Ainin sala me'e, de yon kanoin man kuku maka namehin me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Enime'ede Yahudi rira man ho'ok kail onnenihe na'akeme ramriri rodi Yesus laa nakpali Pilatus. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Rakanedi Pilatus kalarne, hir tumdesne Ai ra'aheni, “Am do'onedi ri eni nawa'u ainim ri leke yon derne rakani Rome nin ma nodi molollo me'e. Ai penia na'okul ri man pair paipair rale Kaisar la na'aheni Ai namwali Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ende Pilatus na'ukanie na'ahenia, “O penia ma namwali Rai Yahudie?” An walha, “Namlolo, naisa ma'aheheni eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Enime'ede Pilatus na'aheni imam-imam lalap noro heri rahu onneni na'ahenia, “Ka'u do'on Ri eniyeni Nin salida.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Maa hirira ahan kan horu de wakunu mamani ra'aheni, “Ai nodi Nin wanakuku nawa'u noho Yudea ne'en raram na'akeme nano Galilea rakanedi mai Yerusalem eni me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus dernedi ne, na'ukani, “Namlolo? Ri eniyeni nano Galilea?” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hir walhedi, “An mai nano Galilea.” Hi ra'aheniyedi heheni ne, Pilatus hopon rodi laa rai Herodes ono ai nodi molollo noho Galilea eni. Lere onne Herodes aile Yerusalem haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes do'onedi Yesus ne, ai raram nahuwa'an wake'e ono nalo'oledi me'e raram nodi rehi pakromo noro Yesus. Ai raram nodi do'on Yesus hi'i tanada man ri kan dodo'onnale makun, ono nadedem derderne Ri eni Nin hini'i wenewhe me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Enine Herodes na'ukani Ai warna-warna, maa Yesus kan walhala ida. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Enimaa imam-imam lalap roro meser Horok Lap enihe na'akeme ramriri wewerre rai kalarna tumdesne Yesus mamani. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kame'ede Herodes noro nin ke'urauk enihe hadwei hadwokor Ai. Hi rala rai nin nainair nanaru rodi rainedi Yesus nanumene hopon nin ke'urauk enihe rodi Ai wali'ur laa nakpali Pilatus. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nonolu, Herodes noro Pilatus ramwali arwali, maa lere onne me'e de woro'ohe rahuwa'an wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Enime'ede Pilatus poluwuku imam-imam lalap roro kote nin man panulu enihe roro idewe kote ne'en raram, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","la ne'el hi na'ahenia, “Mim tumdesne ri eniyeni ma'aheni Ai nawa'u ri leke yon derne rakani Roma nin ma nodi molollo enihe. Mi mehem do'onedi ya'u koklolo a'inauwedi Ai me'e, de mauroin ka'u do'on Nin salida molmolle mi ma'aheheni eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Enla Herodes me'ene kan do'on Nin salida penia hopon wali mai eni nakpali ya'u wali'ur. Namlolo kokkoo, ri eni kan hi'i yak salida leke lernala hunukum makmaki. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Onne penia ya'u lo'o riuk rerhe nanumene huriyedi wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nadedem rakan Lere Alam Lalap Paska eni Pilatus huri ri ida man aile bui raram lernohi noho honolla. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hir dernedi onneni ne, ri na'akeme wakau wewerre ra'ahenia, “Resnedi Yesus la huriyedi Barabas mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas eni rala laa bui raram ono nesne ri la hi'i wowo'o ar'arra nawa'u kote raram leke yon derne rakani Roma nin molollo haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus raram nodi huri Yesus, de noro hi wakunu wali'ur leke huri Ai, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","maa heri onne wakaukau mamani, “Wairesnedi here! Wairesnedi here!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus wakunu rewkelu nine na'ahenia, “Hi'ihepeni? An hi'i inhawa yaksala pe? Ka'u do'on Nin yaksalida ma namnehe na'alono noro hunukum makmaki. Ende ya'u hopon ri riuk rerhe mehe mene huri wali'uredi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Enimaa hi rodi ahan wakaukau mamani ra'aheni, “Wairesnedie! Wairesnedie here!” Kame'ede rir wanakau eni kerne rehirehiyedi Pilatus, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","de nala kenekrohu lernohi rir napanpanak eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilatus huri we'eredi Barabas man hi rapanak huri eni, kade an minle bui raram ono nesne ri la nawa'u ri yon derne rakani Roma nin molollo, maa Pilatus nala Yesus kani hi leke rodi laa hi'i lernohi rir suk mehe. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hi rodi Yesus rala'a ne, holikuku manin Kirene ida naran Simon ma nin panaeku laa kote raram mehe. Hi rakerne paku na'uwara au kekiyowok onne nodi lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ri nammori rala'ala'a lernohi Yesus, la lolo heri onne maeke wo'iraha ma naherhere Yesus aile haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Enime'ede Yesus wali oin makan po'onala hi na'aheni, “Heih, mama ma nano Yerusalem mie! Yon maherA'u me'e, maa mahere mi kemen moro mi anumhe mehe, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ono na'amoli rakan ler ida ri na'aheni, ‘Idee! Maeke ma kan moriyana, lernala rere'e haharu narehi!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lere onne ri napanak wo'or-wo'or man kulu noro man deul ra'ahenia, ‘Mapye'er here! Duniyesnedi yai ke'e!’ ");
INSERT INTO kjeNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ya'u molmolle au'ono man mormori de sus mene aiye na'ane, maa mi man hi'i dohohala maisa au'ono ma napro'ukedi me'e de rakan lere sopoledi aiye raram, pelek na'an horu. Ya a'aheni eni ono lo'o rin hi'i heheni Maya'u ma na'alehe dohohala, hi lo'o hi'i ha man eren apipinha ki mi man hi'i dohohala.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lere onne hi rodi mo'oni woro'o man ailanna laa kote paharne hukumesne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rakanedi onno man rin wekel ‘Uluwaku Rurna’, hir wairesne Yesus noro ri ailanna woro'o onnenihe, ida lolo Yesus herne malanna la ida minle herne mariri. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Enime'ede Yesus hi'i lir napanak na'ahenia, “Papee! Mala ampun hi ono ka rauroin inhawa hir hihi'i eni.” Ma nasala ke'urauk hi'i undi leke rauroin inhoi lernala Yesus Nin nainair. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ri nammori ramririri lolo onne po'onala ha ma namwali na'akeme onne, la Yahudi rir man panulu me'ene ilnohi ralnohi Ai ra'aheni, “Lo'o mamwali Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi, hi'ihepenia kam paekunala mahala O kemmu nano apinpinheni? Ri namehin me'ene Om ma'ohu mahaledi menee!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma nasala ke'urauk enihe hadwei hadwokor Ai haenhi. Hir mai leke rala anggur ma'alinu Ai nomun, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","la ra'aheni, “Lo'o mamwali Yahudi rira Rai, mahaledi O kemmu ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lolo au kekiyowok honorokana ida aile Yesus uluwakun wawan ma na'ahenia: ");
INSERT INTO kjeNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ri ida nano man ailanna woro'o onnenihe ilnohi nalnohi Yesus na'ahenia, “Lo'o O mamwali Kristus man Makromod Lalap kikanedi namwali Rai eni, mahaledi O kemmu noro mayai ke'e!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Maa man ailanna namehin eni dadiyale na'ahenia, “Hoi! Moro Ai lernala hunukum makmaki haenhi. Alhi'ihepenia ka mamka'uk Makromod Lalap Nin hunukum?! ");
INSERT INTO kjeNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ikroko lernala hunukum ma namnehe na'alono noro iknik dohohala, maa Ai eni kan hi'i ha yakyak ida.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Enime'ede ai ne'el Yesus na'ahenia, “Yesus, horhoroka'u lere Om mai mamwali Rai lolo Num nohe.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus walhe na'ahenia, “Horhorok Ainu'u nou ma na'ono eniyeni: Lere eni me'ede o moro Ya'u min wewerre Firdaus raram.” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Rakanedi lere ulu ne, noho onne na'akeme na'umetekedi hehen nanumene riuk wokelu lere mamamal, ");
INSERT INTO kjeNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ono lere kan hari. Ideweni ne, tapi rodi kawkawa Makromod Lalap Nina Romleu Lap raram eni, nahinarukedi namwali woro'o. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Enine Yesus wakau naruri na'ahenia, “Pape! Ya ala Ya'u hamaran kani O liman raram me'e.” Na'aheni onne horu, aran horuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Uluwakun ke'urauk eni do'odo'on ha ma namwali onneni ne, ai na'uli nasa'a Makromod Lalap na'ahenia, “Memen namlolo kokkoo, Ri eniyeni Ri mololole!” ");
INSERT INTO kjeNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Heri rahu man maiwuku lolo onne do'on ha wo'ira ma namwali onne horu ne, akinhe woir wake'e la rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maa Yesus Nin heri man lernohi na'akeme, roro maeke-maeke man lernohi Ai nano Galilea, ramririri kan ko'uwala po'opo'on ha wo'ira na'akeme ma namwali eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ri ida aile naran Yusup. Ai namhara nano leke Arimatea man aile noho Yudea. Ai onne ri mololole la akin mou, la mahan weilapan Makromod Lalap Nin lere alam mai nodi molollo ri mormori. Ai noro Yahudi rir man panulu namehin enihe radedem hopun pepen lolo Sanhedrin nin honopun penepen haenhi. Enimaa lere hi rala kenekrohu resne Yesus, ai ka ne'enohi rir panaeku onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Enime'ede Yusup laa napanak Pilatus nala Yesus ihin kemen leke na'akene manaku. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ai nalkopuredi Yesus ihin kemen nano au kekiyowok, nodi tapi lenan komonedi la nodi laa loiyedi ku'il ma namwali lunna raram. Rin wakeke waku hi'iyedi ku'il onne me'e, maa ka rala maki loile makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lere Yesus maki onne lere alam ri Yahudi ra'akene ha wo'ira leke yon howok rir Alam Renren Warwarna ma na'ikeki rakan me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lere onne maeke manin Galilea man lernohi Yesus enihe mai lernohi Yusup leke po'on karu Yesus ihin kemen lolo ewi. ");
INSERT INTO kjeNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Do'onedi Nin ku'il eni ne, hir wali laa nakar ra'akenkene rampa-rampa noro wuru wola'ula'u leke rodi laa ra'akene Yesus ihin kemen, maa rakanedi Alam Renren Warwarna, hir warnala lernohi Makromod Lalap Nin keneri hono'ok. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Rakanedi alam domeku nohoropo al'alam wake'e ne, maeke onnenihe rodi rampa-rampa noro wuru wola'ula'u onnenihe laa Nin ku'il me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hir rakanedi ne, hir po'on waku lapa rodi el'elek ku'il onne napoiyedi laa herne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Enime'ede hir laa ku'il raram, maa kar do'on Makromod Yesus ihin kemen, ");
INSERT INTO kjeNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","de ramriri mehe kakaiyedi. Ramlilinnohi mo'oni woro'o ma nair nainair wawarhe man siksik lerlere ramriririnohi. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ideweni ne hi ramka'uk rehi la kadi ein korno rawa yawa ri woro'o onne kalarna, maa mo'oni onnenihe re'el hi na'ahenia, “Hi'ihepenia mim mai manoin Ri man mormori lolo ri makmaki onno? ");
INSERT INTO kjeNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ai kan min mai eni, An mori wali'uredi me'e! Lo'o mim hamlinuwedi Nin wanakunu lere mi moro Ai min wewerre lolo Galilea? ");
INSERT INTO kjeNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Lere onne Ai na'aheni Ri Mormori Ananne lo'o rala kanile man hi'i dohohala leke wairesne, la alam wokelu mori wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Enime'ede hir horoknala Yesus Nina wanakunu onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kame'ede hir wali laa nakar me'e. Rakanedi ne, hir wakunu ha ma namwali onne laa Yesus Nina Ri idaweli ida man loikaru Lirna Wawa'an eni noro idewe ri man lernohi Ai namehin na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maeke ma nodi lira onnenihe, Maria manin Magdala, Yohana, Yakobus inna Maria, noro maeke namehin makun. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yesus Nin ma nodi Lirna Wawa'an roro namehin enihe dernedi rir wanakunu onneni, maa rauroin rir wanakunu eni namwali koirwakar ma kan min haida, de ka rakanie. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Maa Petrus namriri la peleklek lari laa ku'il ma namwali Yesus Nin lunne. Rakanedi ne, an rawa po'on laa ku'il raram do'on tapi rodi kokomon mehe aile. Enine an wali me'e la noro akin wakunu na'ahenia, “Inhawa ma namwali enie?” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lere onne mo'oni woro'o man lernohi Yesus rala'ala'a laa leke ida naran Emaus, ko'unne lo'o kilo idaweli ida nano Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hir rala'ala'a ne, hir wakunkunu panaeku ma namwaliyedi Yesus alam ida woro'o man laedi eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hir wakunkunu ne, Yesus mai noro hi ra'alono wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hir do'on Yesus, maa Makromod Lalap kawala hi honorok akin de ka rahiyennale. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Enime'ede Yesus na'ukaniyalhe na'ahenia, “Maham wakunu inhawe?” Enine hi ramririyala la hi oin makan koko raram yakyakedi. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Enime'ede ri ida nano woro'o onnenihe ma naran Kleopas na'ukaniyale, “O mamhara nano ewi pe, kam do'on mauroin ha ma namwali domeku man laedi eni?” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus na'ukani wali'ur, “Inhawa panaeku pe?” Woro'ohe ra'aheni, “Ka mauroin inhawa hir hihi'i lolo Yesus ma nano Nazaret onne? Ai onne Nabi man kukul Nin molollo lolo Nin wanakuku noro idewe hini'i man ri kan dodo'onnala makun. Ai nahuwa'anedi Makromod Lalap akin la ri nammori horhawe. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Imam lalap roro ainim man panulu enihe rala Ai kanile man hukum de wairesnedi lolo au kekiyowok me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nano nonolu me'ede, ai mauroin nahenia Ai penia man mai leke huri we'er maika, ri Israel, nano iknik arwali, maa onne ka namwali ono hi resnedi Ai alam wokelu man laedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ainim man howok wali mama ida woro'o hi'i ahumarmarnedi mayai ono orereki al'alame hir laa ka'ar Nin ku'il, ");
INSERT INTO kjeNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","maa kar do'on ihin kemen me'e, de hir wali mai konohi nahenia hir do'onedi hophopon a'am raram woro'o me'e. Hophopon onnenihe konohi hi nahenia Yesus mori wali'uredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Enime'ede ai walin ida woro'o laa Nin ku'il do'on ha wo'ira na'akeme naise maeke onnenihe wakunkunu eni, maa hi kar do'on Yesus haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Enime'ede Yesus ne'el woro'ohe na'ahenia, “Eih, ri poloo mie, sus mene mim derne makani nabi-nabi lirna nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mi lo'o hamlinuwedi nabi-nabi nonolu eni konihiyedi nahenia panaeku onne namwali lere man maie? Hi ra'aheni Kristus man Makromod Lalap kikanedi namwali Rai eni lo'o lernala apinpinha wo'operperi nammori nanumene maki, maa An mori wali'ur la kokala Oin Naran kukulu lalapa.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Onne horu Yesus na'amou na'aropo wanakunu man aile Horok Lap ma na'ono Ai kemen nano Musa nin horok rakan nabi-nabi namehin rir horok haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na'akeki rakan leke hir lalaa eni ne, manlo'o Ai nala'a mamani, ");
INSERT INTO kjeNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","maa mo'oni woro'o onne rapanak an'anhedi Yesus min wewerre noro hi me'e ono lere helem me'e. Ende Yesus ne'enohi de noro hi ra'alono leke minala wewerre a'alam onne. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A'alam onne hi raikoro mei ne, Yesus nala roti napanak trimkasi Makromod Lalap nanumene a'una'ahe nala hi ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ideweni ne hi makan mouwedi la rahiyennaledi Yesus me'e, maa mehe naplenedi wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Enine ida ma ne'el ida na'ahenia, “Idedi eni koro Ai wakunu lolo kalla, Nin wanakunu ma na'amou na'aropo Horok Lap Lirna maika nedille ik akin penia ik akin nahuwa'an wake'e ho!” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A'alam onne me'ede hir wali wali'ur laa Yerusalem. Rakanedi enne ne, hir laa pakromo noro Yesus Nin man lernohi pakunohi idaweli ida man maha raikoro wuku roro Nin man lernohi namehin enihe. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Man lernohi onnenihe konohi mo'oni woro'o onne ra'aheni, “Eih! Kokkoo! Makromod moriyedi me'e! Ai nalhariyedi kemen Simon Petrus me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kame'ede mo'oni woro'o onnenihe wakunu inhawa ma namwali lolo kalla laa Emaus, la hi'ihehewi Yesus mahan a'un roti nanumene hi rahiyennale. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hir wakunkunu panaeku ma namwali onne makun ne, ramlilinnohi Yesus namriri aile hi leken kalarna me'e la na'aheni, “Moiliwi mahuwele ki mi!” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hi rahumarnedi la ramka'uk rehi ono hir pene'ek hir do'onedi maki hamarne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Enime'ede Yesus ne'el hi, “Hi'ihepenia mamka'uk la mi akim ka namkene Maya'ue? ");
INSERT INTO kjeNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Po'onala Ya'u liman ein, leke mauroin e'eni Maya'u. Ken rouwalle I kem'u ono maki hamarne na'alehe ihin kemen naisa i kem'u mim dodo'on eni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wakunuwedi onneni ne, An kukul liman ein ma namno'ono'o hir po'on. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hi akin nahuwa'an wake'e, maa mehe kakaiyedi makun ono akinhe ka naili'il wawa'an makun. Enine Yesus na'ukani hi na'ahenia, “Minim hanana'an aile mai eni, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Enime'ede hi rala i'in he'ihe'ik sidalida kani Ai na'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ai nalle na'an lolo hi kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na'an horu, Ai ne'el hi na'ahenia, “Nonolu lere Yo oro mi minwuku makun Ya'u konohiyedi mi nahenia ha wo'ira ma na'ono Ya'u kemen man horokedi aile Musa noro nabi-nabi rira horok noro horok Mazmur onne kan sala, maa namlolo kokkoo namwali.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Horu ne, An hariyedi hi honorok akin leke rauroin Horok Lap Lirna La'an. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ai ne'el hi na'ahenia, “Horhorok aile ma na'ahenia, ‘Kristus man Makromod Lalap kikan namwali Rai laa ewi-ewi eni lo'o lernala apinpinha wo'operperi mene maki, maa rakan lere wokelu nine, An mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Enla Rai onne Nin man lernohi rodi Nin molollo loikaru Ai Lirna Wawa'an la wakuku ri mormori nano Yerusalem rakan idewe noho wawan na'akeme leke hir herredi rir morimori ma ka namlolo eni, wali derne rakani Makromod Lalap la lernala ampun hirira dohohala.’ ");
INSERT INTO kjeNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mi penia mamwali man kuku maka ha wo'ira na'akeme eni. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Enla ka nalo'ol Ya'u aku Makromod Lalap Nin Roh man Ya Am'u nouwedi nala ki mi. Ende mamkene lolo koteni hehen nanumene mim lernala Nin molollo onneni.” ");
INSERT INTO kjeNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Onne horu, Yesus noro hi laa kote paharne laa onnida na'uranrani leke Betania. Hir lae ne, An kikan liman leke namre'e namharu hi. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Maha namre'e namharu hi makun, Ai nakinikan laa a'am raram me'e, de hir memehedi lolo onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Enine hir rawa la ra'uli rasa'a Ai me'e. Horu ne, hir wali laa Yerusalem rodi aki ma nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akilere hir lawuku lolo Makromod Lalap Nin Romleu Lape ra'uli rasa'a Ai mamani.");
INSERT INTO kjeNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nonolu wake'e noho eni ka rakuku rawau makun, Ai ma namwali Lirna Wawan aiyedi me'e, la Ai noro Makromod Lalap aile wewerre, la Ai onne Makromod Lalap haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nano nonolu wake'e onne Ai noro Makromod Lalap aile wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ai nakuku nawau noho noro ne'en raram na'akeme, la hi'i ha wo'ira na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ai onne or'ori dardari onno, la or'ori dardari onne namwali ropropo ma na'aropo ri mormori akin penia rauroin Makromod Lalap Nin ropropo. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ropropo onne ropedi lolo metmetek, la metmetek ka nodi molollo ropropo onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Enine Makromod Lalap hopon ri ida ma naran Yohanis mai noho wawan namwali ma na'amou na'aropo wanakunu ma na'ono ropropo onne, leke ri na'akeme man derne ainina wanakunu onne akinhe naili'il ropropo onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanis ka namwali ropropo onne, maa an mai leke nala wanakunu ma na'ono ropropo onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ropropo ma namlolo wake'e onne kopur mai noho wawan, la ropedi lolo ri mormori na'akeme me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ai ma nakuku nawa'u noho wawan eniyeni aiyedi mai noho wawan me'e, maa manin noho wawan eni ka rauroin Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","An maiyedi Nina noho mememen, maa Nina ri mormori wali ka rauroin Ai, la kar kokale, ");
INSERT INTO kjeNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","maa inhoi-inhoi man kokale, la akin naili'il Ai Naran, hir lernala molollo ramwali Makromod Lalap ananhe de lernala mormori worworu. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Rin lernala mormori ma nadedem nano noho wawan nin panaeku, ee ri mormori rir suk raram nodi aimehi, maa mormori worworu onne lernala nano Makromod Lalap ono Ai penia man hi'i hi ramwali Ai ananhe. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lirna Wawan onne namwali ri mormori naise maika, de Ai kemen naise ik kemen haenhi, la An mai nano a'am raram minle ik leken kalarna. Ik do'onedi Nina ke'eke'el an'anha man ma'aruru wake'e man An kokala ono namwali Anan Kuru Mehe Lai Mehe, la An mai nano Aman, Makromod Lalap. Nano Ai penia ik do'on kauroin inhawe ma namlolo kokkoo lolo Makromod Lalap leken kalarna, la ik do'on kauroin Nin rere'e harharu man penpenu kemkeme maika. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Lere Yohanis mai wakunu ha ma na'ono Yesus, ai na'aheni, “Nonolu eni ya'u wakunu nahenia ri ida mai. Ai onne na'ono narehi maya'u, la Ai onne maiyedi me'e. Yo oluwedi Ai mai, maa Ai penia ma na'ono narehi maya'u, ono kar mori ya'u makun Ai onne aiyedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ai onne Nin rere'e harharu lap narehi, la Ai nodi rere'e harharu onne nala panaeku nammori leke namre'e namharu maika mamani. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lere nonolu Makromod Lalap namre'e namharu maika ono nala Nin keneri hono'ok lolo Musa, maa lere eniyeni Ai nala Nin rere'e haharu ma narehi ma nalewen maika lolo Yesus Kristus, la hi'i ika kauroin mouropo panaeku ma namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ri mahaku kan do'onala Makromod Lalap makun, kokoko Anan Kuru Mehe Lai Mehe. Ai onne Makromod Lalap, la An min wewerre noro Aman lolo a'am raram. Ai penia man loikaru Makromod Lalap Nina honorok panaeku maika, leke ik kauroin Makromod Lalap haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ler ida ri Yahudi rir man panulu man minle Yerusalem enihe hopon imam-imam roro ri Lewi laa ra'ukani Yohanis na'ahenia, “O eni inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanis kan suwarala nin panaeku maa walha hi mouropo nahenia, “Ka amwali Kristus man Makromod Lalap kikan namwali Rai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Enime'ede hi ra'ukani wali'ur, “O eni inhoi? O eni Elia?” Yohanis walhe na'ahenia, “Ka!” Hi ra'ukani wali'ur, “O eni mamwali nabi man Makromod Lalap nonou lolo Musa nonolu eni?” Maa Yohanis walhe na'ahenia, “Ka haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Enine konohi yai o eni inhoi, lekpananne am wali wali'ur laa konohi ri man hopon mayai mai ma'ukani o eni. Papa wakunu inhawa ma na'ono o kemene?” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanis nodi nabi Yesaya lirna nonolu eni walha na'ahenia, “Ya'u eni amwali ri man wakaukau lolo noho mamun ma napro'uk ma na'aheni, ‘Ma'ahari kalla, la ma'anehe leke Makromod lole.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kame'ede ri Parisi rir hohopon onnenihe ra'ukani wali'ur ra'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Pape lo'o ka mamwali Kristus, ka mamwali Elia, la ka mamwali nabi haenhi, emene alhi'ihepe Papa nodi oir ulutada rie?” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Enime'ede Yohanis walhale, “Ya'u eni ulutada ri odi oir mehe, maa lolo mi leken kalarna ri ida aile mi ka mauroin makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ya'u mai noluwedi Ai, maa Ai narehi nalewen maya'u penia Nina pakpak ei me'ene kan wa'an yo ohu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ha eniyeni na'akeme namwali lolo leke Betania, man aile lolo oir wauwau Yordan wali kimur. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rakan oreki, Yohanis po'onale Yesus mai me'e, la na'aheni, “Po'onale! Makromod Lalap Nina Pipdumana ma na'ohu nahala ri mormori rira dohohaleni mai me'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nonolu ya aheni, ‘Ya'u mai nolu ri ida ma narehi nalewen maya'u. Ai man ya'u wekel lere onne me'eni me'e. An kulu narehi ya'u ono kar mori ya'u makun Ai aiyedi me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nonolu ka auroin inhoi man Makromod Lalap kikan namwali Rai laa ewi-ewi, maa ya'u mai odi oir ulutada ri leke ri Israel enihe rauroin Rai onne inhoi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Yohanis kukunohi wali'ur na'ahenia, “Nonolu ka auroin Yesus namwali Rai onne makun, maa Makromod Lalap man hopon yo odi oir ulutada ri konohi ya'u heheni, ‘Lo'o om do'on Roh Kudus kopur nano a'am raram mai ri ida wawan, o mauroin nahenia Ai onne ma nodi Roh Kudus ulutada ri.’ Enla rakan lerida ya'u do'on Makromod Lalap Nina Roh kopur naise manu merpati mai Yesus uluwakun wawan. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ende yo odi mak'u mehe do'on auroin ha onne na'akeme, penia ya amwali man kuku maka nahenia Yesus onne Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rakan oreki, Yohanis noro nina man lernohi pakunohi woro'o aile lolo onno onne wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yohanis do'on Yesus lolnohi hirira miminle onneni, ai na'aheni, “Po'onale! Ai onne penia Makromod Lalap Nin Pipdumana eni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Woro'ohe dernedi Yohanis nin wanakunu ne, hir laa lernohi Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus wali kili'ur do'on woro'ohe mahar lernohi, na'ukani na'ahenia, “Mi maham manoin inhawe?” Woro'ohe walha ra'ahenia, “Papa Meser min ewi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesus walha hi na'ahenia, “Mai lernohi Ya'u leke mehem do'on Ainu'u miminloleni.” Ende hir lernohi mamani laa Yesus Nin miminlole. Hi roro Yesus min lolo onne nano lere mamal rakan lere helem. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nano ri woro'o man lernohi Yesus onnenihe, ida naran Andreas, Simon Petrus mo'oni walla. Woro'ohe lernohi Yesus ono derne Yohanis nin wanakunu ma na'ono Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreas noro Yesus wakunu horu ne, idewe lari lan konohi Simon na'ahenia, “Pa'e, am pakromo noredi Mesias man Makromod Lalap kikan namwali Rai laa ewi-ewi. (Lolo wanakunu Ibrani ‘Mesias’ onne ‘Kristus’.)” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kame'ede ai norkaru walla Simon laa Yesus. Enine Yesus po'onala ai na'ahenia, “O naran Simon, la o ammu naran Yohanis! Maa nano lere eniyeni waki o naran Kepas napa'ahne, ‘waku ma naruri’!” (Naran ‘Kepas’ onne namnenehe noro naran ‘Petrus’ haenhi.) ");
INSERT INTO kjeNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rakan oreki wali'ur Yesus Nin panaeku wali laa Galilea, de lan naka'uk Pilipus na'ahenia, “Mam lernohi Ya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Pilipus onne manina Betsaida, la Andreas noro Petrus ramhara nano leke onne haenhi.) ");
INSERT INTO kjeNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Enla Pilipus lan pakromo noro Nataniel la konohi na'ahenia, “Am pakromedi noro ri man Makromod Lalap kikan namwali Rai laa ewi-ewi me'e. Nonolu Musa kukunohiyedi panaeku ma na'ono Ai lolo nin horok me'e, la nabi-nabi namehin loikaruwedi panaeku ma na'ono Ai haenhi. Ai onne naran Yesus, Yusup anan ma nano Nazaret.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Enimaa Nataniel walha na'ahenia, “Hi'ihehewi ha man wa'an mai nano Nazaret?!” Pilipus na'aheni, “Mam lernohi mayai, leke mehem do'on idewe!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus do'odo'on Nataniel mai, Ai na'aheni, “Po'onala! Ri eniyeni ri Israel ma namlolo wake'e. Ai onne ka nauroin napoho!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Enine Nataniel na'ukani Yesus, “Pape, hi'ihehewi Pape nauroiroin ainu'u morimorie?” Yesus walha, “Eh, Pilipus kan ki napolu o makun, Ya'u do'onedi o lolo ara ono lehern me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel walha na'ahenia, “Papa Meser, O penia Makromod Anan ma namwali Rai Israel!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus na'ahenia, “Hi'ihehewi? Lo'o o akim naili'iledi me'e ono Ya'u konohi o na'aheni Ya'u do'onedi o lolo ara ono lehern me'e? Lere man mai om do'on panaeku namehin man wa'an narehi onne!” ");
INSERT INTO kjeNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Enla Yesus na'aheni wali'ur, “Horhorok Ainu'u nou ma na'ono eniyeni: Lere man mai mim do'on a'am nahinari la Makromod Lalap Nina hophopon a'am raram mahar ha'a kopur Maya'u man mai nano a'am raram namwali Ri Mormori Anan.” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rakan alam woro'o wali'ur, rin hi'i hohoo lolo leke Kana minle noho Galilea, la Yesus inna aile lolo yapi hohoo onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus noro Nina man lernohi pakunohi enihe lernala larlariyala de laa haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lere onne man korowuku ra'ukwuku enihe rir anggur horuwedi, de Yesus inna lan konohi Ai, “Rira anggur horuwedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus na'ahenia, “Alhi'ihepe mame konohi Ya'ue? Kan rakan Ainu'u ors Ya alhari I kem'u heri do'on makun.” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Enimaa Yesus inna ne'el man howok lolo onnenihe, “Hi'i lernohi inhawe man Ai na'aheheni ki mi eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lolo onne hi ra'akenedi uhi woneme leke rala oir loile de nair rawana liman lernohi Yahudi nin agame. Uhi ida raramne potol rahu rehi. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kame'ede Yesus ne'el man howok enihe na'ahenia, “Mala oir loile uhi woneme enihe.” Ende hi rala oir loile uhi woneme onne penu mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Horu ne, Yesus hopon man howok enihe, “Mala oir tarana modi laa malle man panulu lolo hohoo eni kenala.” Kame'ede hi rodi oir onne tarana laa me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ai nomun oir ma namwaliyedi anggur onne, maa ka nauroin anggur onne nano ewi, ono man howok ma nala oir halle uhi onnenihe mehe rauroin. Kame'ede man panulu lolo hohoo onne laa na'uraniyedi mo'oni man ho onne, ");
INSERT INTO kjeNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na'aheni, “Nadedem yapi heheni ne, ri nala anggur wawa'an rala peina'a romun nolu leke rira suk horuwedi mene rala ma nadedem, maa i wal'u lapan ors eni mene mala anggur man wa'an wake'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tanada man ri kan dodo'onnala makun eni, namwali dedesne Yesus hi'i minle leke Kana lolo Galilea. Lolo tanada eniyeni, An kukul Nin ke'eke'el an'anha ma narehi ma nalewen, penia Nina man lernohi pakunohi enihe akin naili'il Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Horu ne, Yesus noro Nin inne, mo'oniwalinhe, noro Nin man lernohi pakunohi enihe wali laa Kapernaum. Hir min lolo onne alam woro'o wokelu. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yahudi rira Lere Alam Lalap Paska na'uraniyedi me'e de Yesus nala'a laa Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rakanedi Makromod Lalap Nin Romleu Lape nina nikoin ne, An po'on ri nammori maha ra'olu pipduma, sapi, manu merpati, la heruwali raikoro raherre kupan lolo mei-mei man minle nikoin eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus hi'i kali namwali losno nanumene nodi laa nohiye'er rarari ri onne noro rir pipi noro sapi haenhi, la Ai nawaliyedi mei-mei rodi raherre kupan onnenihe de rira kupan wahair re'er rarari horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ai ne'el ma na'olu manu merpati onnenihe na'ahenia, “Ra'uk minim hahaa mamharedi lolo eni here! Yono modi Ya Am'u Nina Romleu hi'i pasar!” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kame'ede man lernohi pakunohi Yesus enihe horokala Horok Lap Lirna ma na'ahenia, “Ya'u raram nodi rehi ri mormori nodi Onum Romleu Lalap hi'i lir napanak mamani! Enla onneni Ainu'u suk wake'e penia nakoko Ya akin woir la lo'o Ya'u maki!” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yahudi rir man panulu enihe ra'ahan Yesus de ra'aheni, “O modi inhawa molollo hi'i ha eniyeni!? Kene Om hi'iyala tanada ri kar dodo'onnale ida leke ai mauroin nahenia Numa molollo aile hi'i ha ma naise eniyenihe!” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kame'ede Yesus walhe, “Ya'u hi'i tanada eniyeni. Maye'eredi Makromod Lalap Nina Romleu eniyeni, la alam wokelu raramne Ya aririe wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Enine hi ra'ahenia, “Ik upud a'adhe howok Makromod Nina Romleu Lapeni anna weli'akka woneme raramne mene horu! Hi'ihehewi Om ma'ariri wali'ur alam wokelu raram mehe?” ");
INSERT INTO kjeNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Enimaa hi ka rauroin nahenia Yesus kan wekel Romleu Lap hir dodo'on onne, maa An wekel Ai kemen. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ende Yesus mori wali'uredi nano Nin makmaki eni, mene Nina man lernohi pakunohi enihe horoknala Ai Lirn eniyeni, de nano lere onne hi rauroin kokkoo la akin naili'il inhawe man aile Horok Lape raram noro Yesus Nin wanakunu eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lere onne Yesus aile Yerusalem makun leke lernohi Lere Alam Lalap Paska, la ri nammori akin naili'il Ai ono do'odo'on An hi'i tanada ri kan dodo'onnala makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Enimaa Ai me'ene akin ka naili'il hi ono nauroiroin rira honorok panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ai ka napanak rin konohi hi honorok akin, ono Ai mehe ma nauroin wake'e inhawe man aile ri mormori honorok akin. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ri ida aile naran Nikodemus. Ai onne ri Parisi la ai namwali man panulu ida nano agame Yahudi rir muku man ho'ok kail. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ai nodi a'alam ida mai Yesus na'ahenia, “Pap Meser, ai mauroiroin nahenia Papa namwali Meser man mai nano Makromod Lalap, ono Pape hihi'i tanada ri kan dodo'onnale makun ma nodi kunukunohi nahenia Makromod Lalap mehe norle'ule'u norwalwali O.” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus walhe, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lo'o ri ida aile, maa kar mori ai wali'ur, ai onne ka namwali Makromod Lalap Nin ri, ono Makromod Lalap ka nodi molollo ai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus walha Yesus, “Papa Meser Nina panaeku hi'i hehewi? Hi'ihehewi ri na'ileheredi me'e wali wali'ur laa inna konoin leke mori wali'ur?” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus walhe wali'ur, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi kar mori rodi oir noro Roh Kudus, ai onne ka namwali Makromod Lalap Nin ri, de kan laa onno man Ai nodi molollo raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lolo noho eniyeni ik kemen iknik ine mori, maa iknik morimori worworu eniyeni mai nano Makromod Lalap Nina Roh. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ende yono mi mahumarna Ainu'u wanakunu ma na'ahenia, lo'o kar mori wali'ure mi, ka mamwali Makromod Lalap Nin ri! ");
INSERT INTO kjeNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wa'an rehi ik kaho'ok ha eniyeni noro anna huhuu. Ik ka kauroin anna man huhuu onne mai nano ewi la huu laa ewi, maa ik derne la rase de kauroin nahenia anna aile. Onne naise ri man mori wali'uredi nano Makromod Nin Roh. Ik ka kauroin hi'ihehewi Nin Roh nala morimori worworu onne, maa ik do'on Ainin honowok lolo ri man lernaledi morimori worworu onne.” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus na'ukani ho'o me'e, “Hi'ihehewi Pape Nina panaeku eni namwali?” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus na'aheni, “O eni mamwali meser Israel enihe! Emene alhi'ihepe o ka mauroin Ainu'u wanakunu enie? ");
INSERT INTO kjeNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Horhorok Ainu'u panaeku eniyeni: Am wakunu inhawe man Ai mauroiroin la Am konohi mi inhawa man Am do'odo'on, maa mi kam kokala Ainima wanakunu eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi akim ka naili'il Ainu'u wanakunu ma na'ono inhawe ma namwali lolo noho eniyeni, de hi'ihehewi mi akim naili'il Ainu'u wanakunu ma na'ono inhawe ma namwali lolo a'am raram ho'o? ");
INSERT INTO kjeNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ri mahaku kan ha'a laa a'am raram, naukara Ya'u man mai nano a'am raram. Ya'u mehe auroin inhawe ma namwali lolo a'am raram ono Ya amwali Ri Mormori Anan. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nonolu lere Musa minle noho mamun ma napro'uk onne, ai nala nee man rodi pere hi'ie wair lolo au meriri nanumene kikan laa wawan. Ende inhoi wanna uluwakun po'on nee onneni, ai onne kan maki, kade nee man aile lolo onne ni'ie. Naise onne haenhi, nonolu Makromod Lalap konohiyedi nahenia lere man mai rin kikan Ya'u, Ri Mormori Anan, laa wawan, ");
INSERT INTO kjeNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","leke inhoi man akin naili'il Maya'u man Makromod Lalap kikanedi, ai onne lernala morimori man ma'aruru la ma kan horu eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Makromod Lalap hi'i heheni ono naramyaka rehi ri mormori noho wawan penia Ai nala Anan Kuru Mehe Lai Mehe leke inhoi akin naili'il Ai yono maki ko'u Makromod Lalap, maa lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Makromod Lalap kan hopon Anan mai nala hunukum noho wawan eni, maa An hopon mai leke huri we'er ri mormori nano dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inhoi akin naili'il Makromod Lalap Anan, ai kan lernala hunukum. Enimaa inhoi akin ka naili'il Ai, an lernaledi hunukum makimaki, ono akin ka naili'il Makromod Lalap Anan Kuru Mehe Lai Mehe! ");
INSERT INTO kjeNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Makromod Lalap ho'ok kail ri mormori heheni, ono Ai Anan nodi ropropo maiyedi noho wawan me'e, maa ri mormori suk rehi noho momohone nano roprope ono hir hi'i ha man ailanna mamani. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ri na'akeme man hi'i ha man ailanna, kar suk ropropo. Hi ramhene ra'urani ropropo onne, kalo'o ropropo onne nalhari rir hini'i man ailanne. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Enimaa inhoi man raram nodi hi'i ha ma namlolo, hi akin namrana mai ra'urani ropropo onne leke rin do'on rira hini'i wenewhe rauroin mouropo nahenia inhawe man hir hi'i onne lernohi Makromod Lalap Nin honorok panaeku.” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Onne horu, Yesus noro Nina man lernohi pakunohi enihe ramhara rala'a laa noho Yudea minala enne tarana, la rodi oir ulutada ri lolo noho onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lere onne Yohanis mahan ulutada ri lolo leke Ainon, ono lolo onne oir nammori aile, la akilere ri nammori mai leke ulutade. Leke Ainon onne na'uranrani leke Salim. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lere onne ka rala Yohanis laa bui raram makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Enla lerida Yohanis nin man lernohi enihe roro ri Yahudi ida rasesi panaeku ma na'ono hi'ihehewi rodi oir ra'amou ra'adewe kemen lolo agame nina holoor halauk. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Enla nin man lernohi enihe mai re'el Yohanis ra'aheni, “Papa meser, horokala lere nonolu papa kukul ri ida mayai lere minle oir Yordan wali? Po'onala! Lere eni Ai mahan ulutada ri nammori de kar mai pape me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Enine Yohanis walha na'ahenia, “Lo'o ik ri mormori kak lernala ruri pe'el nano Makromod Lalap, ik ka kauroin hi'i haida-haida. Na'akeme man ik lernala, onne mai nano a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mi mehem dernedi nano nonolu ya'u kukunohi mouropo nahenia ya'u eni ka amwali Kristus, maa Makromod Lalap hopon ya'u mai nolu hari kalla Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ya ala wanakunu naho'ok nano hohoo. Lo'o mo'oni ida ho, ai onne ma na'ono, la maeke man ho namwali ai hono mehe, maa nin orwali akin nahuwa'an paku mo'oni man ho la raram nodi wake'e derne man ho onne lirna. Ors eni ya akin nahuwa'an, ono ya aise man ho nin orwali, la Yesus naise man ho. Ya akin nahuwa'an wake'e ono ya'u dernedi Ai lirna, la ri nammori lernohi Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ai penia ma na'ono wake'e, de wa'an rehi Ai eren lalap la ya'u eren tatana. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ai onne mai nano a'am raram, de An kulu lapa narehi na'akeme. Ri man minle noho wawan mai nano noho eniyeni, de hi ramwali ri mormori ma nadedem la hir wakunu noho wawan nin panaeku mehe. Enimaa Ai man mai nano a'am raram onne narehi nalewen na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","An wakunu inhawe man An do'on la derne, maa ri mormori noho wawan eni ramhene rakani Ainina wanakunu. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Enimaa inhoi kokala Ainin wanakunu, onne nodi kunukunohi nahenia ai nauroinedi mouropo Makromod Lalap Nin wanakunu na'akeme namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Onne namlolo ono Makromod Lalap hopon An mai leke wakunu nodi Lirna. Ai naledi Nina Roh nodi na'enuwedi Yesus akin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ik Amad, Makromod Lalap, naramyaka Anan Yesus, la naledi molollo penia ha wo'ira na'akeme lolo yawa Ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Inhoi man akin naili'il Makromod Lalap Anan onneni, ai onne penia man lernala or'ori dardari ma kan horu. Inhoi kan derne nakani Makromod Lalap Anan onneni, kan lernala or'ori dardari onne, la na'akene kokala Makromod Lalap Nina hunukum ma kan horu laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ka nalo'olo ri Parisi enihe dernedi nahenia ri nammori lernohiyedi Yesus, la rapanak An ulutada hi, penia ri man lernohi Yesus nammori rehi nano man lernohi Yohanis me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesus me'ene kan ulutade, maa Nina man lernohi pakunohi enihe penia man ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ende rakan lere Ai nauroin ri Parisi derne ri nammori lernohiyedi me'e, Ai namharedi nano noho Yudea wali wali'ur laa Galilea, ");
INSERT INTO kjeNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","maa An lolo kalla man lole noho Samaria. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesus rakan leke ida naran Sikhar, la leke eni kan ko'u nano lari ipida man nonolu Yakup nale anan Yusup. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lolo lari ip onne Yakup nin oir makan ida aile, de Yesus naikoro warnala lolo oir makan onne. An mahedi ono nala'a ko'u, la lere uluwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kan mahe ne, maeke Samaria ida mai nahur oir me'e. Yesus ne'el ai na'ahenia, “Mame, malala oir ida Yo omunale ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nina man lernohi pakunohi enihe laedi kote leke weli hanana'an me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Maeke Samaria onne ne'el Yesus, “Alhi'ihepe Papa manina Yahudi napanak oir maya'u manina Samaria?” Maeke onne wakunu heheni ono manina Yahudi ramhene rawaur noro manin Samaria. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus walhale, “Lo'o mauroinedi Makromod Lalap Nina rere'e haharu, la mauroin Maya'u eni inhoi, o mapanak Ya ala oir momun, la namlolo kokkoo Ya ala oir ma nala or'ori dardari ki o.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Enla maeke onne ne'el Ai na'ahenia, “Pape, oir makan eni rorom, la Papa Nin kipkali kaale, de hi'ihehewi leke mahur oir ma nala or'ori dardarie? ");
INSERT INTO kjeNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ai upme Yakup nala oir makan eni mayai man min lolo eniyenihe, la ai noro ananhe me'ene romun nano oir makan eni na'uwali rir ha mormori na'akeme haenhi! Alhi'ihepe Papa nauroin nahenia Papa kulu narehi nano ai upmu Yakup? Lo'o ri kaale ma nala oir man wa'an narehi man Yakup nala mayai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kame'ede Yesus na'aheni wali'ur, “Inhoi nomun oir eni ka nalo'olo marou wali'ur, ");
INSERT INTO kjeNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","maa inhoi nomun oir Ya a'ala, ai eni kan marou me'e, ono oir onne namwali oir makan ida ai raram de wau mamani, namwali morimori man ma'aruru ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Maeke onne ne'el Yesus, “Pape, mala oir onne yo omun leke yono ya'u marou me'e, de yono mai ahur oir eni mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus na'ahenia, “Lam polu num mo'onleher moro mai Ya'u nanu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Maeke onne walha na'ahenia, “I ho'u kaale.” Yesus na'ahenia, “Onne namlolo, ");
INSERT INTO kjeNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ono om hoedi rewlima me'e, la ors eni om minwuku noro mo'oni ma ka namwali o houm haenhi! Onum wanakunu onne namlolo kokkoo!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Maeke onne na'aheni wali'ur, “Eni nanumene ya auroin Papeni nabi ida! ");
INSERT INTO kjeNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mayai manina Samaria ai upme hoikaniyedi Makromod Lalap lolo wo'or eni me'e, maa Papa Nina ri Yahudi ramhene, la ra'aheni wa'an rehi hoikani Makromod Lalap lolo Yerusalem mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus na'aheni, “Mame, Ya'u konohi o kokkoo, lere man mai lo'o ri hoikani ik Amad Makromod Lalap, hi kar mai wo'or eni noro Yerusalem haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mi ri Samaria eni hoikani inhawa ma ka mauroin wawa'an makun, maa mayai Yahudi hoikani inhawa man ai mauroin wawa'anedi me'e, ono Makromod Lalap nalhariyedi Nin panaeku mayai la An nouwedi me'e nahenia Ri ida mai nano ri Yahudi man huri we'er hi nano dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Enimaa lere man mai Makromod Lalap Nin ri kan hoikani naise nonolu, maa hir hoikani la ra'uli rasa'a Ai rodi kalla ma namlolo, ono Roh Kudus nodi molollo hi penia hi rauroin ha ma namlolo wake'e, de hi onne rahuwa'an Makromod Lalap akin. Enla namlolo kokkoo lere onne rakanedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Makromod Lalap onne Roh, de inhoi raram nodi lolo kalla ma namlolo hoikani la ra'uli rasa'e, ai onne nodi Ainin Roh Nin molollo penia lernohi inhawa ma namlolo wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Horu ne, maeke Samaria onne ne'el Yesus na'ahenia, “Ya auroinedi me'e nahenia ler ida Ri man Makromod Lalap kikan namwali Rai laa ewi-ewi (man rin wekwekel Kristus) onne lo'o mai. Na'amoli An mai mene kukunohi ha wo'ira na'akeme mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus ne'el maeke onne, “Ya'u, ma noro o wakunu eni, penia Kristus onne!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesus wakunkunu noro maeke onne makun, Nina man lernohi pakunohi enihe wali mai. Hir do'on Yesus mahan wakunu noro maeke Samaria onne de hehel, maa hi ri mahaku ka na'ukani maeke onne na'ahenia, ‘O mapanak inhawe?’ la ka ra'ukani Yesus na'ahenia, ‘Alhi'ihepe moro maeke onne wakunu?’ ");
INSERT INTO kjeNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kame'ede maeke onne nala nina oir onno loiyedi lolo onne nala'a leke raram lan kukunohi inhawe man Yesus wakukunu noro ai lolo oir makan onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ai ne'el leke raram na'ahenia, “Heih! Mai ik lak po'on ri ma nauroiroin ainu'u hini'i wenewhe na'akeme. Ai onne lo'o man Makromod Lalap kikanedi namwali Rai harome!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Leke raram dernedi ne, lari laa leke paharne leke pakromo noro Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Heri onnenihe kar rakan makun ne, Yesus Nin man lernohi pakunohi enihe ra'akenedi hanana'an me'e leke roro Yesus ra'ak. Hir lariyala, “Papa Meser, hanana'an namkenedi me'ede, mai ka'ak here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Enimaa Yesus ne'el hi na'ahenia, “Ainu'u hanana'an aile, maa mi ka mauroin hanana'an onne inhawe.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kame'ede ida ma na'ukani ida, “Lo'o ri nodi hanana'an mai nala Ai harome?” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus na'aheni, “Ya'u raram nodi lernohi Makromod Lalap man hopon Ya'u eni, la Ainu'u panaeku hi'i na'ahoruwedi honowok man Makromod Lalap nanala Maya'u. Panaeku woro'o onnenihe namwali Ainu'u hanana'an man hi'i Ya akin nahuwa'an naise ri ma namlara ma na'ak pehuredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nadedem mi ma'aheni, ‘Lo'o wollo wo'akka ikar rakan kirna nina na'ili nadai me'e,’ maa Ya apanak mim po'onala kirna ma na'ihiyedi lolo eniyeni me'e, leke rin mai ra'ili radai ihin ennen! ");
INSERT INTO kjeNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lere eniyeni ri ma na'ili nadai lernala nin naiwe'el, la ihin ennen man an loiwuku onne kan horu laa ewi-ewi. Onne namwali leke man pekir ariyono noro ma na'ili nadai woro'ohe akin nahuwa'an wewerre ono hir loiwukuwedi ihin ennen nammori, la ihin ennen onne wekel ri man lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wanakunu eniyeni namlolo kokkoo, ‘Ida pekir ariyono, la namehin na'ili nadai.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya'u hopon mi ma'ili madai kirne man mi kam howok makun. Ri namehin mai nolu pekir ariyono, mene mim mai ma'ili madai ihin ennen nano rir honowok lolo kirna onne. Ri namehin mai nolu loikaru Makromod Lalap Lirna, maa mim mai wakunu noro hi mene hi akin naili'il Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lolo kota Samaria, ri nammori akin naili'il Yesus ono dernedi maeke idedi onne nin wanakunu ma na'ahenia, “Yesus nauroiroin ainu'u hini'i wenewhe na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ende ri Samaria enihe mai pakromo noro Yesus la rapanak Ai norhe minala lolo onne alam ida woro'o. Enpenia Yesus minle rir leke lere ida woro'o mene nala'a, la ");
INSERT INTO kjeNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","nano Ainina wanakuku onne, ri eren namomori akin naili'il Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hi re'el maeke onne na'ahenia, “Dedesne ik akin naili'il ono ik dernedi num wanakunu, maa ors eni ik akin eren nailili'il Ai, ono ai mehem derne Ai la mauroinedi nahenia Ai penia namwali Rai man mai noho wawan leke huri we'er ri nano rir dohohala nin molollo!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rakan alam woro'edi Yesus wali wali'ur laa Nin noho Galilea. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus mehen na'aheniyedi, ‘Nadedem ri ma namwali nabi, lolo nin nohorai mememen, ri kan horhawe.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lere An rakan Galilea ri man min lolo onnenihe akin nahuwa'an kokala Ai. Hir pene'ek lo'o do'on An hi'i tanada man ri kan dodo'onala makun, ono oirawi inworo'ohe hi ri nammori min wewerre Yerusalem Lere Alam Paska onne de do'odo'on mouwedi Ainina hini'i wenewhe na'akeme me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kame'ede Yesus nala'a wali'ur laa leke Kana lolo Galilea. Nonolu lolo leke onne, An hi'i oir namwali anggur. Enla lere onne rai nina man howok ida aile man minle leke Kapernaum ma kan ko'u nano Kana, la ai onne anan mo'oni nin kini'ir werek wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Man howok onne nauroinnala Yesus aiyedi mai Kana ne, an laa napanak Yesus lernohi laa Kapernaum hi'i wa'an anan ono na'ikeki maki me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ende Yesus ne'el ai na'ahenia, “Alhi'ihepe mi man minle noho eniyeni mapanak do'onala tanada man kukul Makromod Lalap Nina ke'eke'el an'anhe nanumene mi akim naili'il?” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Enime'ede ri onne na'aheni, “Pape, halhala ik laa here, leke yono ya an'u maki!” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus ne'el ri onne na'ahenia, “Om wali here. Anum kan maki.” Ri onne akin naili'il Yesus Nin wanakunu, de nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Rakan kalla toro pakromo noro nina man howok lolo nakar enihe. Hir mai leke kukunohi ai nahenia anan wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kame'ede ai na'ukani hi, “Ma'ananahe wa'an?” Hir walha, “Oirawi lere u'ulu riuk ida, kan manha me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ai nauroin nahenia oirawi lere u'ulue haenhi Yesus hopon wali here ono anan wa'anedi me'e. Lere onne me'ede ai noro hono ananhe nakar raram na'akeme akin naili'il Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tanada ri kan dodo'onnale makun onne namwali rewro'o nine man Yesus hi'i lolo Galilea lere An waliyedi nano Yudea. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Onne horu, Yahudi rira lere alam lalapida na'urani me'e, de Yesus wali laa Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Enla lolo Yerusalem nika ida aile ma nadedem rin wekel, ‘Nika Pipdume’. Na'urani nika onne oir kiliu lapida aile la rin hi'i henei wolima lolo oir onne herne. Ri nodi wanakunu Ibrani wekel oir kiliu onne ‘Betseda’. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nadedem ri ma nakni'ir nammori ramkukuru lolo henei onnenihe, ri ma makan toko, ein he'ehe'e, noro ma naplu'uk nap'eker. Hi eniyenihe na'akeme mahar lapan oir kiliu onne nawollo, ");
INSERT INTO kjeNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ono lere romromo Makromod Lalap Nin hophopon a'am raram ida kopur mai nawollo oir onne, la inhoi ma nolu kopur laa oir raram wuwala kemen, idewe nina apinha onne wa'anedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ende mo'oni ida aile naplu'uk nap'eker anna welikelu wo'aa me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus po'on mo'oni onne lolo henei raram, la nauroinedi ai nakni'ir nalo'ol me'e, de ne'el ai, “O raram nodi om wa'an, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ri onne walhe, “Papee, rakan lere oir nawollo, ri kaale man paku nala kopur ya'u laa oir raram. Ya'u na'ik laa, maa ri namehin noluwedi ya'u mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus ne'el ai, “Mamakedi here! Lunna onuma piki luni, mala'a here!” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lere onne me'ede mo'oni onne nina apinhe moluwedi, de an lunna nina piki luni na'uware nala'a me'e. Lere Yesus hi'i wa'an mo'oni onne pakromnala Alam Renren Warwarna, la lolo agame Yahudi luli ri Yahudi howok lere alam onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Enpenia Yahudi rir man panulu re'el mo'oni idedi ra'aheni, “Heih! Yom ma'uwara numa piki luni! Ka mauroin nahenia lere eni Alam Renren Warwarne, de luli om ma'uwara numa piki luni?” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Enimaa mo'oni onne walha na'ahenia, “Ri man hi'i wa'an ya'u hopon lunna ainu'u piki luni ya ala'a here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Inhoi man hopon om lunna onuma piki luni mala'a?” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Enimaa mo'oni onne ka nauroin inhoi man hi'i wa'an ainina apinhe onne naran, ono heri aile lolo onne, la Yesus nala'edi, de kan do'on me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ka nalo'ol ne, Yesus pakromo wali'ur noro mo'oni onne lolo Romleu Lape nin nikoin la ne'el ai, “Makani wawa'an! Ors eni om wa'anedi me'e, maa yono om hi'i dohohala me'e, kalo'o om lernala wanalhanne man werek narehi nano num apinha nonolu eni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kame'ede mo'oni onne lan konohi ha ma namwali ai kemen laa Yahudi rir man panulu enihe na'ahenia, “Yesus penia man hi'i wa'an ainu'u apinhe!” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Enime'ede man panulu Yahudi ken hi'i apinpinha Yesus mamani ono hi rauroiroin Yesus hi'i wa'an ri Alam Renren Warwarna onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Enimaa Yesus ne'el Yahudi enihe, “Ya Am'u me'ene howok mamani, ka nadedem warna, la Ya'u hi'i heheni haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Onne penia Yahudi rir man panulu raram nodi ranoin kalla leke resne Yesus here. Hi ra'ahan ono Yesus hi'i wa'an ri Alam Renren Warwarne, maa hi ra'ahan wake'e ono Yesus na'aheni Makromod Lalap onne Ainina Papa mememen, penia Ai namnenehe noro Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Onne penia Yesus ne'el hi na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ya'u, Makromod Lalap Anan, ka odi molollo howok haida lernohi Ainu'u suk aimehi, maa Ya'u hi'i inhawe man Ya'u po'on Ainu'u Pape hi'i mehe. Inhawe man Ya Am'u hi'ie, Anan hi'i lernohi haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ono Ainu'u Pape naramyaka Ya'u ma namwali Ai Anan, la kukul Nin hini'i wenewhe na'akeme Maya'u haenhi. Ka nalo'ol, An kukul hini'i wenewhe ma narehi nalewen lolo tanada man Ya'u hi'iyedi, leke mim do'on la polletilu. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ainu'u Pape onne nodi molollo na'amori wali'ur ri man makiyedi, la Ai Anan hi'i heheni haenhi. Ya ala or'ori dardari ri na'akeme man Ya'u niliyedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ainu'u Pape kan ho'ok kail ri mormori me'e, maa Ai naledi molollo Maya'u, Ai Anan, ho'ok kail ri na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","leke ri na'akeme horhawe la rahiyene aroro Ya'u namnenehe noro Ai haenhi. Inhoi kan horhawe Ya'u, Ai Anan, kan horhawe Ya Am'u man hopon Ya'u mai noho wawan eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi derne nakani Ainu'u wanakunu eni la akin naili'il Ainu'u Pape man hopon Ya'u mai noho wawan eniyeni, ai onne mori laa ewi-ewi la kan lernala hunukum makmaki me'e. Nonolu makmaki nodi molollo ai, maa ors eniyeni an lernaledi or'ori dardari ma kan horu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ka nalo'olala ri ma akin ka naili'il Maya'u de mori naise man makiyedi me'e, derne Makromod Lalap Anan Lirna. Memen lere alam onne rakanedi me'e. Nano ri man makiyedi onne, inhoi man derne nakani Ai Lirna mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ainu'u Papa penia or'ori dardari onno, la Ai nala molollo Maya'u, Ai Anan, namnenehe Ainina molollo leke Ya amwali or'ori dardari onno haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Enla Ai nala molollo Anan leke ho'ok kail ri mormori na'akeme, ono Ya'u eni peni Ri Mormori Anan. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mim derne Ainu'u wanakunu eniyeni, yono mim polletilu! Ler man mai ri man makiyedi, derne I lir'u, ");
INSERT INTO kjeNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","la idewe hir mori wali'ur, la hi ramhara nano noho makmaki, leke lernala wanalhan nano rir hini'i wenewhe man hir hi'i nonolu lere hir mori lolo noho wawan. Ri man hi'i ha man wa'an, kokala or'ori dardari ma kan horu eni, maa ri man hi'i ha man ailanna, kokala hunukum makmakie. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ka'u hi'i haida lernohi Ainu'u suk aimehi. Lere Ya'u ho'ok kail ri, Ya'u derne Makromod Lalap mamani. Ainu'u kenekrohu na'akemhe namlolo kokkoo, ono Ka'u lernohi Ainu'u panaeku aimehi, maa Ya'u lernohi Ainu'u Pape Nina panaeku mehe, ono Ai penia man hopon Ya'u mai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesus wakunu wali'ur na'ahenia, “Lo'o Ya'u mehe wakunu panaeku ma na'ono Ya'u kemen, la man kuku maka namehin kaale, mi ka mauroin Ainu'u wanakunu onne namlolo, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Enimaa Makromod Lalap wakunu nala wanakunu ma na'ono Ya'u kemen, la Ya auroin Ainin wanakunu namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mim hopon minim ri ida woro'o lar derne Yohanis man ulutade ri lirna me'e, la an konohi mi ha ma na'ono Maya'u haenhi, la ainin wanakunu namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Lo'o ri mormori man kuku maka ma na'ono Maya'u aile, wa'an, maa lo'o kaale, onne kan herre Ainu'u panaeku ida. Enimaa Ya a'ori honorok mi Yohanis nin wanakuku leke mi lo'o lernala or'ori dardari ono mi akim naili'il ainin wanakunu onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanis onne naise wadu man mormori leke mim do'on Makromod Nin kalla ma namlolo eni. Mi akim nahuwa'an derne ainin wanakunu, maa ka nalo'olo mi kam derne ai lirna me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Enimaa Ainu'u man kuku maka ida ma na'ono narehi Yohanis aile, la onne Ainu'u hini'i wenewhe. Ya'u hi'i wewhe honowok man Ya Am'u nala Maya'u leke hi'i na'ahoruwedi lolo noho eniyeni. Hini'i wenewhe onne kukul nahenia Ya'u mai nano Ya Am'u, Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Enla Ya Am'u man hopon Ya'u mai, Ai me'ene kuku maka ma na'ono Ya'u kemen haenhi, maa mi kam derne Ai lirna wake'e, la mi kam do'on oin makan haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ai Lirna kan minle mi raram, ono mi akim ka naili'il Maya'u, kade Ai penia man hopon Ya'u mai loikaru Ai Lirna onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mi na'akeme mampe'el wakuku Horok Lape mamani, ono mauroin nahenia Horok Lape onne nala or'ori dardari ma kan horu ki mi, maa mi ka mauroin nahenia Horok Lap onne wakunu mouropo panaeku ma na'ono Ya'u kemen. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mim wakuku Horok Lap raram mamani, maa mi mamhene mai Maya'u leke lernala or'ori dardari ma kan horu eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Lo'o ri mormori ra'uli rasa'a Ya'u, ee ka, kan hi'i haida, ono ka anoin rir ul'uli sasa'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ya auroiroin mi akim, de Ya auroin nahenia Makromod Lalap Nin raramyaka kaale lolo mi raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ya'u mai odi Ainu'u Pape Naran, maa mi kam kokala Maya'u! Enimaa lo'o ri namehin mai rodi rira panaeku aimehi, mi raram nodi kokale! ");
INSERT INTO kjeNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ki mi eniyenihe mi ida ma nanoin uli sa'a nano ida mamani, maa mi ka manoin uli sa'a nano Ai man mehe namwali Makromod Lalap ma namlolo kokkoo. Hi'ihehewi mi akim naili'il Maya'u?! ");
INSERT INTO kjeNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yon mim pene'ek Ya ala sala ki mi lolo Ainu'u Pape leken kalarna. Ka! Maa Musa penia ma nala sala ki mi ono mi ka mauroin nin wanakuku! Mim pene'ek nahenia mim lernala or'ori dardari ma kan horu ono hi'i wewhe Musa nin keneri hono'ok, maa Musa kan wakuku heheni! ");
INSERT INTO kjeNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ende lo'o mi akim naili'il Musa la mauroin nin wanakuku kokkoo, mi akim naili'il Ya'u haenhi, ono lolo Horok Lap raram Musa penia horok panaeku nammori ma na'ono Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Enimaa lo'o mi akim ka naili'il Musa nin horok ma na'ono Maya'u onne, hi'ihehewi mi akim naili'il Ainu'u wanakuku eniyeni?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ler ida woro'o wali'ur Yesus hopol deul oir lap Galilea laa wali. Oir lapa Galilea onne rin wekel oir lap Tiberias haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ri nammori lernohi Ai, ono hir do'onedi Ai nodi tanada man kukul Makromod Lalap Nin ke'eke'el an'anha hi'i wa'an ma nakni'ir nammori. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Enime'ede Yesus noro Nina man lernohi pakunohi enihe wakiha'a laa wo'or ida raikoro lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lere onne Yahudi rira Lere Alam Lalap Paska na'uraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus po'on laa waliwali ne, do'on ri nammori mai me'e. Ende Ai ne'el Pilipus na'ahenia, “Lo'o ik laa ewi weli hanana'an nonomun leke kala heri eni ra'an?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus mehe paeku nala hanana'an heri onne ra'an, maa Ai na'ukani heheni leke nodi kene Pilipus akin naili'il wawa'an kokkoo ee kaun? ");
INSERT INTO kjeNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kame'ede Pilipus na'ahenia, “Ik kala hanana'an noknokor heri rahu eni, na'an kupan namansa rehi! Kupan pere waku rahu woro'o kodi weli roti ha'ar heri ra'an maano kan nokor!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Enine Yesus Nina man lernohi pakunohi ida naran Andreas, Simon Petrus mo'oniwalla, na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Papa Meser, lolo eni tatana mo'oni ida nina roti waku wolima noro i'in kem woro'o aile, maa lo'o kan nokor heri rahu enihe ra'an.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kame'ede Yesus na'aheni, “Lam hopon na'akeme raikoro mouwedi.” An hopon heheni ono lolo onne penek mamani, de na'akeme raikoro mouwedi. Aki mo'oni mehe ri riwan wolima, kar aki maeke noro tatan'ukun. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus nala roti wolima onne de napanak trimkasi Makromod Lalap nanumene An a'un roti onne ha'ar heri onne ra'an. An hi'i namnenehe noro i'in kem woro'o onne haenhi, penia heri onnenihe ra'an hehen nanumene pehur. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Heri onne pehur mouwedi, mene Yesus hopon Nina man lernohi pakunohi enihe loiwuku hanana'an ma narehi na'akeme leke yon sopol. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ende hir loiwuku hanana'an ma narehi na'akeme lunu idaweli woro'o penu mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lere onne heri ma na'ak onnenihe do'on Yesus Nin hini'i ri kan dodo'onnala makun onne ra'aheni, “Namlolo kokkoo Ai onne Nabi man Makromod Lalap nouwedi mai noho wawan nano nonolu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus nauroiroin nahenia heri onnenihe rira panaeku kikan Ai namwali rir Rai, de Ai mehen wakiha'a laa wo'or tilu. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Enla rakan lere helem, Yesus Nina man lernohi pakunohi enihe kopur laa oir lap Galilea, ");
INSERT INTO kjeNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","leke ha'a korkoro deul oir lape laa Kapernaum. Hir lapan Yesus, maa Ai kan mai de hi rala'a me'e ono alamedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kan maha ne, anna lapa huu me'e, de oir lape nadiwo'owo'o me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hir wohi lo'o kilu wolima woneme na'ikeki rakan oir lape toro, mene po'onale Yesus nala'ala'a lolo oir ulikine mai rira korkoro me'e. Hir po'on ramka'uk rehi, ");
INSERT INTO kjeNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","maa Yesus na'aheni, “Eni Maya'u! Yon mamka'uk!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kame'ede hi akin nahuwa'anedi la ralha'edi Yesus laa korkoro wawan, la idewe ramlilinnohi rakanedi Kapernaum herraram! ");
INSERT INTO kjeNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Rakan oreki heri man aile oir lape walie makun maha ranoin Yesus. Hi rauroin nahenia oirawi korkoro ida mehe, la Yesus kan ha'a wewerre noro Nin man lernohi pakunohi enihe. Heri onne rauroin nahenia Nin man lernohi pakunohi enihe mehe rala'a, maa Yesus kan lernohi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kame'ede, korkoro ma nano kota Tiberias mai paliyedi, na'uranrani onno man oirawi Yesus hi'i lir napanak ha'ar roti rala heri ra'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Heri ranoin Yesus lolo onne, maa ka nalo'olo hi rauroin nahenia memen Yesus noro Nina man lernohi pakunohi enihe kaale lolo onneni, de hir lernohi korkoro ma nano Tiberias onnenihe leke deul oir lape laa Kapernaum leke ranoin Yesus lolo enne. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hir rakanedi oir lap wali enne do'on Yesus la ra'ukanie, “Ma'ananahe Pap Meser rakan mai eni?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Enimaa Yesus walhe, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Mi manoin Ya'u ono mi mo'on momun pehur mehe! Mi ka manoin Ya'u ono Ya'u hi'i tanada mi kam dodo'onnale makun man kukul Makromod Lalap Nin ke'eke'el an'anha! ");
INSERT INTO kjeNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yon howok leke lernala hanana'an man pelek horu, maa howok leke lernala hanana'an ma nala or'ori dardari ma kan horu laa ewi-ewi. Ya'u, ma namwali Ri Mormori Anan, ala hanana'an onne ki mi, ono Ya Am'u, Makromod Lalap, kikan la niliyedi Ya'u me'e, la Ya'u hi'i Ai akin nahuwa'an wake'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Enine hi re'el Yesus na'ahenia, “Am hi'i inhawa leke hi'i wewhe Makromod Lalap Nin honowok? Hi'ihehewi am hi'i Ai akin nahuwa'an?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus na'aheni, “Makromod Lalap napanak mim hi'i honowok eniyeni: Mi akim naili'il Maya'u man An hopon mai noho wawan eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Enine hi ra'aheni, “Maa Om hi'i inhawa tanada leke am do'on de ai akim naili'il ki Oe? ");
INSERT INTO kjeNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ai upme ra'an hanana'an manna lere hir minle noho mamun naise horhorok man aile Horok Lape raram ma na'ahenia, ‘Ai nala hanana'an nano a'am raram leke hi ra'an.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus na'aheni, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Musa ka nala hanana'an nano a'am raram onne ki mi nonolu eni, maa Ainu'u Pape penia ma nala hanana'an onne, la ors eniyeni Ainu'u Papa mahan nala hanana'an ma namlolo wake'e nano a'am raram ki mi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Makromod Lalap Nin hanana'an ma namlolo onne me'eni Maya'u man kopur nano a'am raram mai leke nala noho wawan or'ori dardari ma kan horu!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ende heri onne ra'aheni, “Pape, mala hanana'an onne mayai mamani!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus na'aheni, “Ya amwali hanana'an ma nala or'ori dardari! Inhoi mai Maya'u eni ka namlara me'e, la inhoi akin naili'il Maya'u eni kan marou me'e laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya'u konohiyedi mi me'e nahenia mim do'onedi Maya'u me'e maa mi akim ka naili'il makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ri man akin naili'il Maya'u, hi onnenihe Ainu'u Papa naledi Maya'u, la namlolo kokkoo Ya'u kokala hi na'akeme. Inhoi-inhoi mai Maya'u, ka'u huri we'erala ida, ");
INSERT INTO kjeNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ono Ka'u mai leke hi'i lernohi Ainu'u panaeku aimehi, maa Ya'u mai hi'i Ainu'u Papa man hopon Ya'u mai Nin panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ai man hopon Maya'u mai, Nina panaeku yon ri mahaku nano ri man Ai naledi Maya'u enihe maki nako'u Ai, la Ainina panaeku Ya a'amori hi na'akeme wali'ur lere noho eni nina man horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Onne namlolo ono Ainu'u Pape raram nodi nahenia ri na'akeme man do'on Anan, la akin naili'il Ai, hi onnenihe lernala or'ori dardari ma kan horu eni, la Ya a'amori hi wali'ur lere noho nina man horu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Enine ri Yahudi hehel Yesus Nin wanakunu ma kan lolo ri raram ono Ai na'aheni, “Ya amwali hanana'an man mai nano a'am raram!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ida ma ne'el ida na'ahenia, “Yesus eni Yusup anan, la Nina ri leleher kauroiroin! Emene hi'ihepenia Ai na'aheni, ‘Ya'u mai nano A'am rarame?’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Enime'ede Yesus walha na'ahenia, “Yono mim hehel! Yon mi ida ma na'aheni ida Ainu'u wanakunu eniyeni ka namlolo! ");
INSERT INTO kjeNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lo'o Ainu'u Papa man hopon Ya'u mai noho eni ka napolu mi mai Maya'u, mi ri mahaku kan lernala or'ori dardari. Enimaa ri na'akeme man Ai napolu, mai Maya'u, la Ya a'amori hi nano makmaki lere noho nina man horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nonolu nabi-nabi horok lolo Horok Lap raram ra'aheni, ‘Ler man mai Makromod Lalap wakuku hi na'akeme.’ Ende ri na'akeme man derne rakani Ainu'u Papa, la ri man wakuku nano Ai, hi onnenihe man mai Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Onne ka na'aheni ri mormori do'onedi Makromod Lalap, ono ri mahaku kan do'on Ai, naukara Ya'u man mai nano Makromod Lalap, Ya'u mehe do'on Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi ma akin naili'il Maya'u, ai onne lernala or'ori dardari ma kan horu laa ewi-ewi! ");
INSERT INTO kjeNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maya'u eni penia hanana'an ma nala or'ori dardari. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kade mi upme ra'an hanana'an manna minle noho mamun, maa hir maki haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Enimaa hanana'an ma nano a'am raram aile, la inhoi na'an hanana'an onne hi kar maki. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ya amwali hanana'an man mai nano a'am raram ma nala or'ori dardari. Inhoi ma na'an hanana'an ma namwali Ya'u ihin kemen eni, an mori laa ewi-ewi. Ya ala hanana'an ma namwali Ya'u kemen eni leke ri noho wawan lernala or'ori dardari.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hir derne Yesus Nina wanakunu onne ne, ida ma nasesi noro ida me'e ra'aheni, “Hi'ihehewi Ri eni nala ihin kemen ik ka'ane?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kame'ede Yesus na'aheni, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lo'o mi ka mo'on Ri Mormori Anan ihin kemen la ka momun rarne, mi kam lernala or'ori dardari ma kan horu onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inhoi ma na'an Ya'u ihin kemen la ma nomun Ya'u rarna, ri onne lernala or'ori dardari ma kan horue la Ya a'amori wali'ur lere noho eni nina man horue, ");
INSERT INTO kjeNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ono Ya'u ihin kemen noro Ya'u rarna enie namwali hanana'an noro nonomun ma namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inhoi ma na'an nomun onne nodi kunukunohi nahenia noro Maya'u ramwali mahaku. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ainu'u Pape mori laa ewi-ewi, la Ai onne penia man hopon Ya'u mai, la Ya'u mori naise Ai ono Ai penia man hi'i Ya'u mori. Namnenehe onne inhoi ma na'an Ya'u ihin kemen Ya ala or'ori dardari hi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya'u eni hanana'an man mai nano a'am raram. Hanana'an eni ka namnenehe noro manna mi upmu a'um rara'an onne ono rakan rir lere horu hir makiyedi, maa inhoi ma na'an hanana'an eniyeni, mori laa ewi-ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus wakuku wanakuku eni na'akeme lolo Yahudi rir kerei man minle leke Kapernaum. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lere onne, man lernohi enihe derne Yesus Nin wanakuku onneni, ri nammori hehel rehi de ida ma ne'el ida na'ahenia, “Wanakuku onne sus wake'e! Wanakuku eniyeni, ri ka nauroin de ri kan kokale!” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Enine Yesus mehe nauroiroin hi mahan ida man hehel ida, de Ai na'aheni, “Alhi'ihepe mi ma'ahan derne Ainu'u wanakuku idedi eni? Lo'o panaeku eni ka nedille mi akim? ");
INSERT INTO kjeNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ya aheni heheni me'ene mi ma'ahan! Hi'ihehewi lo'o mim po'on Ya'u, Ri Mormori Anan, ha'a wali'ur laa Ainu'u onno dedesne!? ");
INSERT INTO kjeNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Makromod Lalap Nina Roh penia ma nala or'ori dardari! Ri mormori ka nodi molollo mehen nala or'ori dardari kemen. Ainu'u wanakunu eniyeni mai nano Makromod Lalap Nin Roh, la Ai penia ma nala or'ori dardari. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kade onne namlolo, maa mi heruwali akin ka naili'il Maya'u!” Yesus wakunu heheni ono nano dedesne Ai nauroinedi me'e inhoi penia man akin ka naili'il Ai la inhoi lo'o lere li'ur na'olu Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Enla Yesus na'aheni wali'ur, “Onne penia nonolu Ya'u konohiyedi mi nahenia lo'o Ainu'u Papa kan paku napolu, ri mahaku kan mai Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesus na'aheni heheni me'ede ri nammori ma nadedem lernohi Ai onne kar lernohi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ende Yesus na'ukani ri idaweli woro'o ma namkene lernohi enihe na'ahenia, “Yonde mi mamhene lernohi Ya'u haenhi harome?” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Enine Ainina man lernohi pakunohi ida naran Simon Petrus na'aheni, “Makromod, mayai lo'o lernohi inhoi ho'o? Makromod mehe Nina wanakuku ma nala or'ori dardari ma kan horue. ");
INSERT INTO kjeNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ai akim naili'il Makromod la mauroiroin nahenia O penia ma na'alehe dohohale wake'e, la O ma namwali Makromod Lalap Nin Hophopon mememen man An hopon mai noho wawan eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Enine Yesus na'aheni, “Eih! Ya'u mehe nili mi ri idaweli woro'o eniyenihe, maa ri ida aile lolo mi leken kalarna ma namwali nediyomon.” ");
INSERT INTO kjeNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesus Nin wanakunu onne wekel Simon Iskariot anan Yudas ono Yesus nauroinedi nahenia lere man mai Yudas onne na'olu Ai, kade ai namwali ri ida nano ri idaweli woro'o onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Onne horu, Yesus nala'a laliwewer noho Galilea onne. Ai namhene lan lolo Yudea ono Yahudi rir man panulu enihe mahar paeku leke resne. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Enla lere onne Yahudi rira lere alam lalap man hir waki ‘Heuheu Man Ra'an Romunle Raram’ wakuraniyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ende Yesus mo'oniwalla mememen enihe rawalha lira Ai ra'aheni, “Alhi'ihepe min mai eni mehe. Wa'an rehi kala'a Yudea leke Num man lernohi pakunohi onnenihe do'on tanada Om hihi'i enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ri ma nanoin naran kan suwar nina hini'i! Om hi'i tanada ri kan dodo'onnala makun, de wa'an rehi mala'a leke noho wawan do'on idewe Num hini'i wenewhe man lewlewen eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesus mo'oniwalinhe wakunu heheni ono hi ka rauroin An mai nano Makromod Lalap, de hi akinhe ka naili'il Ai makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Enine Yesus ne'el walinhe, “Wal'u mie, Ainu'u lere alam kan rakan makun, maa ki mi inhawa lere alam mi mala'a, namnenehe, kan hi'i haida. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri man minle noho wawan enihe kar hadwei hadwokor mi, maa hi kar suk Maya'u ono nadedem Ya'u wakunu rira ailanne noro dohohala. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wa'an rehi mi mala'a here! Lam lernohi lere alam lalap onne. Ka'u laa makun ono Ainu'u lere alam kan rakan makun.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesus wakunu heheni walinhe mene hi rala'a, la Ai ka namhara Galilea makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesus walin enihe rala'edi leke lernohi lere alam lalap onne, mene Yesus lernohi laa enne, maa An lolo kalla suwsuwar, de ri mahaku ka nauroin. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yahudi rir man panulu maha ranoin Yesus lolo lere alam lalap onne ra'aheni, “Ri onne ai ewi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Heri man minle rana'ukwuku onne wakunu ralpupupu panaeku ma na'ono Ai. Heruwali ra'aheni, “Ai onne ri wawa'an!” maa heruwali ra'aheni, “Ai onne ri yakyake ono An ken paipudi ri.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hir wakunu maa ramka'uk wekel Yesus naran leke yono rin derne ono hi me'ene ramka'uk Yahudi rir man panulu enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hirira lere alam lalap onne kan horu makun, Yesus lan wakuku lolo Makromod Lalap Nin Romleu Lap. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudi rir man panulu man min lolo onne polletilu, de ra'ahenia, “Yesus kan lernala agame nin wanakuku makun, maa Ai nauroin wanakuku man lewlewen!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus walha hi na'ahenia, “Inhawe man Ya'u wakukuku enie Ainu'u wanakuku ka, maa Ai man hopon Ya'u mai penia Nina wanakuku. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ende inhoi raram nodi lernohi Makromod Lalap Nina panaeku, ai onne nauroin Ainu'u wanakuku eniyeni mai nano ewi-nano Makromod Lalap, ee nano Maya'u mehe. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ri ma nodi nin wanakuku aimehi, nanoin naran aimehi haenhi, maa ri man Makromod Lalap hopon mai, ai onne raram nodi na'akulu na'alapa Makromod Lalap naran. An wakuku panaeku ma namlolo, la na'alehe salida. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mi mauroinedi Makromod Lalap Nina keneri hono'ok nano Musa me'e! Maa mi na'akeme kam lernohi keneri hono'ok onne. Alhi'ihepe mi manoin kalla mesne Ya'ue?” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Enine hi re'el Yesus na'ahenia, “Inhoi raram nodi nesne o? Lo'o hayakyake hu'uredi o raram me'e harome!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus walha na'ahenia, “Mi na'akeme polletilu ono Ya'u hi'i tanada man ri kan dodo'onnala lere Ya'u hi'i wa'an ri onne Alam Renren Warwarna. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Enimaa mi me'e ne howok Alam Renren Warwarna haenhi leke lernohi Musa nina holoor halauk sunat mo'oniyana, ono lo'o sunat onne nin lere alam nedille Alam Renren Warwarna, mim sunate. Ma namlolo, sunate onne kan mai nano Musa, maa ik upud a'ad Abraham, Isak noro Yakup penia hi'i dedesne. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ende lo'o mim hurinohi sunat ri, kade nedille Alam Renren Warwarna, leke lernohi Musa nin holoor halauk, emene alhi'ihepe mi ma'ahan Maya'u ono Ya'u hi'i wa'an ri ida kemen na'akeme lere alam warwarne? ");
INSERT INTO kjeNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yono modi panaeku man rin dodo'on dederne mehe ho'ok kail Ya'u, maa wa'an rehi modi panaeku ma namlolo lolo Makromod Lalap leken kalarna leke ho'ok kail Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ri heruwali man minle Yerusalem enihe ra'ahenia, “Yonde Ai onne penia maha ranoin resne harome? ");
INSERT INTO kjeNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","An wakuku mouropo lolo heri kalarna, maa iknik man panulu enihe ka ra'uhoiyala Ai. Yonde hi rauroinedi nahenia Ai onne Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi harome? ");
INSERT INTO kjeNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Enimaa ik kauroin nahenia lere Kristus onne mai, ri mahaku ka nauroin mai nano ewi, la kauroin Ai onne mai nano Galilea, de lo'o ka namwali Rai onne.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus mahan wakuku lolo Romleu Lape nina nikoini, la wakunu naruri na'ahenia, “Eh! Mi mauroin Maya'u eni inhoi? La amhara nano ewi? Ka'u mai odi Ainu'u panaeku aimehi. Ya'u mai ono Makromod Lalap hopon mai, la Ai penia ma namlolo kokkoo. Mi ka mauroin Ai, ");
INSERT INTO kjeNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","maa Ya auroiroin Ai ono Ya'u mai nano Ai, la Ai penia man hopon Ya'u mai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Enime'ede heri man derne Ainin wanakunu onnenihe ra'akene kele me'e, maa ka namwali ono kan rakan Nina lere alam makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Enimaa ri nammori aile lolo onne ma akin naili'il Ai la ra'aheni, “Ai eni namlolo kokkoo Rai man Makromod Lalap kikanedi eni, ono inhoi lo'o hi'i tanada narehi Ainin hini'i eniyeni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri Parisi enihe derne ri man lolo onnenihe mahar wakunu ralpupupu panaeku ma na'ono Yesus, de roro imam lalap enihe hopon ri ma nadiyaka Romleu Lapa lar kele Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ende Yesus ne'el heri onnenihe na'ahenia, “Ors eni Yo or'oro mi, maa tarana ikar Ya'u wali laa Ai man hopon Ya'u mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lere onne lo'o mi manoin Ya'u, maa kak pakromo me'e, ono mi ka mauroin kalla man laa Ainu'u miminlole.” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kame'ede Yahudi rir man panulu ma kar kokala Yesus enihe ida ma ne'el ida, “Lo'o ri eni nala'a ewi penia kak pakromo noro Ai me'e? Yonde An laa noro Yahudi man aile noho namehin enihe lawuku leke An wakuku ri ma ka namwali Yahudi harome? ");
INSERT INTO kjeNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ainin panaeku inhawe nahenia ik kanoin Ai, maa kak pakrome? Alhi'ihepe Ai na'aheni maika ka kauroin kalla man laa Ainin miminlole?” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lere alam lalap onne na'akeki horu, la alam man kauli'ur onne alam ma na'ono wake'e. Rakan lere alam onne Yesus namririyedi nanumene wakunu naruri na'ahenia, “Inhoi man marou mai leke Ya ala oir nomun. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na'amoli ri ma akin naili'il Ya'u mai nomun. Ai onne naise horhorok man aile Horok Lap raram ma na'ahenia, ‘Nin morimori ma'aruru wake'e, ono lolo ai raramne Ainu'u oir man wau mamani nala or'ori dardari ma kan horu.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lere Yesus wekel oir man wauwau onne, Ainin panaeku nahenia lere man mai inhoi ma akin naili'il Ai, Makromod Lalap Nina Roh mai ri onne. Lere An wakunu onne, Makromod Lalap Nina Roh kan mai noho wawan makun ono Yesus ka nakinikan laa a'am raram makun, la Makromod Lalap ka na'akulu na'alapa Ai lolo onne makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ri nammori mahar derne Yesus Nin wanakuku de heruwali ra'aheni, “Kokkoe! Eni lo'o Nabi man Makromod Lalap nonou eni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Heruwali ra'aheni, “Ai eni lo'o Kristus man Makromod Lalap kikanedi namwali Rai eni!” Maa heruwali ra'aheni, “Ka! Hi'ihehewi Kristus eni mai nano Galilea? ");
INSERT INTO kjeNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Horok Lape na'aheniyedi me'e Kristus onne Daud upun anan, de kan mai nano Galilea maa nano Betlehem, ono Betlehem onne Daud nina lekloi!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kame'ede na'akeme rasesikuli Ai ho'o me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ri heruwali ra'akene kele Ai me'e, maa ri mahaku kan tukule. ");
INSERT INTO kjeNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kame'ede ma nadiyaka Romleu Lapa onnenihe wali mai imam lalap roro Parisi man nonolu hopon hi lar kele Yesus onnenihe, maa kar kele Yesus makun. Imam-imam roro ri Parisi onnenihe ra'ukani, “Alhi'ihepe ka moro ri onne maie?” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Enine ma nadiyaka onnenihe walha, “Eih! Ai kam dernala ri man wakunu naise Ai makun!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Enine ri Parisi enihe ra'ihoru ra'idaru hi ra'aheni, “Yonde ri onne wukupohedi mi me'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kene mim po'on! Iknika man panulu roro ri Parisi enihe akin ka naili'il ri onne menee! ");
INSERT INTO kjeNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Heri ma ka nauroin Musa nina keneri hono'ok mehe akin naili'il Yesus! Mayai ma nauroiroin, ka! Na'amoli heri onne mehe lernala Makromod Lalap nina keneri kanai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus aile lolo onne haenhi. Ai onne Yahudi rir man panulu ida man nonolu mai pakromo noredi Yesus me'e. Ai ne'el Parisi namehin enihe na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“I wal'u na'ahoru, iknik holoor halauk hopon ika kala leken ri man sala leke na'amou na'aropo nina hini'i wenewhe noro wanakunu mene ik kala hunukum!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ideweni ne Parisi enihe wahilei ra'idaru Nikodemus ra'aheni, “Eh! O eni ma nina Galilea haenhi? Lam wakuku Horok Lape raram wawa'an! Horok Lap ka na'aheni ri Galilea namwali nabi!” ");
INSERT INTO kjeNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hir wakunu horu ne ri na'akeme wali laa rira nakar me'e, ");
INSERT INTO kjeNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","maa Yesus wakiha'a laa wo'or Zaitun. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Rakan oreki al'alam wake'e An wali wali'ur laa Makromod Nina Romleu Lape nina nikoin la ri nammori mai lupurale. Enine Ai naikoredi wakuku hi. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ai mahan wakuku ne, meser Horok Lape roro ri Parisi enihe rodi maeke ida mai Yesus me'e. Kame'ede hir hopon maeke onne namririyedi lolo heri kalarna, ono rin lerkuku ai mahan hi'i sale noro mo'oni ma ka namwali hono. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ende hir mai re'el Yesus na'ahenia, “Papa Meser, am do'on maeke eni mahan hi'i sale. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musa nina keneri hono'ok hopon nahenia lo'o ik lerkuku maeke mahan hi'i sale naise eni, rodi waku wasle hehen nanumene makiyedi! Ende Papa Nina honorok panaeku hi'ihehewi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hi rodi na'ukankani onne kene Yesus ranoin Nin sale leke tumdesne la kele Ai. Yesus kan idewe walhe, maa nahirawa yawa nodi liman horok elimoe. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hi ra'ukani Yesus mamani. Kame'ede Ai namriri na'ahenia, “Ki mi na'akeme, inhoi na'alehe dohohala mai nala waku nodi wasla maeke eni nolu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Horu ne, Yesus rawa yawa nodi liman ra'an horok elimoe wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hir derne Yesus Nin wanakunu me'ede hi dohodoho rala'a me'e, ma na'ileheredi rala'a nolu mene namehin enihe lernohi. Heri onne rala'a mouwedi, Yesus noro maeke onne memehedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kame'ede Yesus namriri wali'ur na'ukani maeke onne, “Naiye, heri na'akeme aile ewi me'e? Lo'o ri kaale man hukum o?” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maeke onne walhe, “Ri kaale me'e, Pape.” Enine Yesus na'aheni, “Ya'u ka'u hukum o haenhi, de mala'a here, maa yom hi'i dohohala me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesus ne'el heri onnenihe na'ahenia, “Ya amwali ropropo noho eni wawan! Inhoi man lernohi Ya'u, ai onne kan minle metmetek kalkala me'e, maa an mori lolo ropropo ma nala or'ori dardari ma kan horu!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ende Parisi enihe ra'ahan rehi ra'aheni, “Onum wanakunu ma na'ono O kemen ka namlolo, ono mehem kuku maka O kemen.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ende Yesus na'ahenia, “Kade Ya'u wakunu Ya'u kemen mehe, maa Ainu'u wanakunu eniyeni namlolo ono Ya auroiroin Ya'u mai nano ewi, la wali laa ewi haenhi! Maa mi eniyeni ka mauroin Ya'u mai nano ewi la wali laa ewi! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lo'o mim hukum ri, mim lernohi ri mormori nina panaeku mehe, maa Ya'u ka'u hukum ri mahaku lolo noho eni wawan. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lo'o Ya ala hunukum, Ainu'u hunukum onne namlolo kokkoo ono Ka'u mehe ho'ok kail, maa Ya'u ho'ok kail ri oro wewerre Ainu'u Pape man hopon Ya'u mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Minim keneri hono'ok ida na'aheni, ‘Yon ho'ok kail ri rodi man kuku maka ida mehe, maa rodi ri woro'o ramwali man kuku maka leke rauroin kokkoo inhawe ma namlolo.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ya amwali man kuku maka ida, la Ainu'u Papa namwali man kuku maka woro'o nine, de ri nauroin nahenia Ainu'u wanakunu eni namlolo.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Enine hi ra'ukani Yesus, “Onum Pape aile ewi?” Yesus na'ahenia, “Mi ka mauroin Ya'u, de ka mauroin Ainu'u Pape haenhi! Lo'o mi mauroin Maya'u, mauroin Ainu'u Pape haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ler Yesus wakuku hi wanakuku eniyeni, Ai namriri na'urani oplaha rala kupan loloile man minle Romleu Lape paharne. Ri mahaku kan kele Ai ono kan rakan Nina lere alam makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus ne'el ri Yahudi onnenihe na'ahenia, “Ka nalo'olo Ya ala'a me'e, la lo'o mi manoin Ya'u maano kam do'on Ya'u, ono mim maki lolo minim dohohale, de ka namwali mim lernohi Ya'u laa Ainu'u miminlole.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ende Yahudi rir man panulu ida ma na'ukani ida, “Yonde ri eni mehen nesne kemen harome? Eni penia Ai na'aheni ik kak lernohi Ai laa Nina miminlole.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesus na'aheni wali'ur, “Mi eniyeni mamwali ri ma nano yawa, ri ma nano noho wawan, maa Maya'u, ka! Ya ano wawan! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Enpenia Ya aheni lo'o mim maki lolo minim dohohale. Lo'o mi akim ka naili'il Ainu'u wanakunu man konohi Ya'u eni inhoi, namlolo kokkoo mim maki lolo minim dohohala.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hi ra'ukani Yesus wali'ur, “Ende ki O eni inhoi?” Yesus walhe, “Ya'u wakunu inhawe noro mi ho'o?! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ainu'u wanakunu nammori makun man kukul minim sala leke nodi ho'ok kail mi, maa Ka'u wakunu lernohi Ainu'u panaeku aimehi. Makromod Lalap man hopon Ya'u mai, Ai onne namlolo kokkoo. Ya'u konohi ri mormori noho wawan inhawe man Ya'u derne nano Ai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Enimaa hi ka rauroin nahenia Ai mahan wakunu panaeku ma na'ono Ai Aman Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ende Yesus ne'el hi na'ahenia, “Lere man mai rin kikan Ya'u ma namwali Ri Mormori Anan laa wawan. Lere onne mene mauroin nahenia Ya'u eni amwali Ai man Ya'u konohiyedi mi me'e, la lere onne mi mauroin nahenia Ka'u hi'i haida lernohi Ainu'u panaeku aimehi, maa Ya'u wakunu mehe inhawe man Ainu'u Pape wakukuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ai man hopon Ya'u mai noho wawan norle'ule'u norwaliwali Ya'u mamani, la Ai kan huri Ya'u memehedi, ono Ainu'u hini'i wenewhe hi'i Ai akin nahuwa'an mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lere Yesus wakunu heheni, ri nammori akinhe naili'il Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ende Yesus ne'el ri Yahudi man akin naili'iledi enihe na'ahenia, “Lo'o mi mamkene lernohi Ainu'u wanakuku eni, namlolo kokkoo mi mamwaliyedi Ainu'u man lernohi me'e, la ");
INSERT INTO kjeNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mi mauroinedi wanakuku ma namlolo wake'e lolo Makromod Lalap kalarna, de mi mahinuriyedi nano dohohala nin molollo me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Enine hi re'el Yesus wali'ur, “Mayai eniyenihe Abraham upun ananhe, de Onum panaeku hi'ihehewi ma'aheni ai mahinuriyedi? Ri mahaku ka nodi molollo mayai me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus walha na'ahenia, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi man hi'i dohohala, ai onne namwali dohohale nin hophopon, ono dohohala nodi molollo ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ri ma namwali hophopon na'alehe onno ma namkene lolo nakar raram, maa ri ma namwali anan mememen nin onno namkene laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ende lo'o Ya'u, Makromod Lalap Anan, huri we'er mi nano minim dohohale, mi mahinuriyedi kokkoo nano dohohale nin molollo me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Memen Ya auroiroin mi eniyenihe Abraham upun anan, maa mim ken mesne Ya'u, ono mamhene kokala Ainu'u wanakuku. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inhawe man Ya'u do'onedi lere Yo oro Ya Am'u min wewerre, onne Ya'u konohi mi, maa mim hi'i ha man ailanna mamani lernohi inhawe man mim derne nano minim pape!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Enine hir walha Yesus, “Alhi'ihepe wakunu heheni?! Ainim pape Abraham, namehin ka!” Enimaa Yesus walha na'ahenia, “Lo'o namlolo kokkoo Abraham namwali minim papa, mim lernohi nina hini'i, ");
INSERT INTO kjeNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","maa kam hi'i lernohi ainin hini'i ono mi maham paeku mesne Maya'u, kade Ya'u mehe konohi mi panaeku ma namlolo man Ya'u dernedi nano Makromod Lalap! Abraham kan hi'i heheni! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Minim hini'i wenewhe onne kan lernohi minim papa Abraham, maa lernohi minim papa aimehi!” Enine hi re'el Yesus, “Mayai eniyenihe tatana apun leke ka, la ainim Papa ida mehe, Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Enime'ede Yesus na'ahenia, “Lo'o Makromod Lalap namlolo kokkoo namwali minim Papa, mi maramyaka Ya'u, ono Ya'u mai nano Ai. Ya'u ka'u mai lernohi Ainu'u panaeku aimehi, Ya'u lernohi Ainin panaeku mamani, ono Ai penia man hopon Ya'u mai. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Alhi'ihepe mi ka mauroin Ainu'u wanakunue? Mi ka mauroin ono mamhene kokala Ainu'u wanakuku eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mi eniyenihe, minim pape namwali Hayakyak Makromon, la mi raram nodi lernohi ainina panaeku man ailanna mamani. Nano dedesne ai raram nodi nesne ri, la napoho mamani ono panaeku ma namlolo ida kaale raramne! Nin hini'i wenewhe onne lernohi nin honoli wenewhe ma namehiyala wake'e, ono ai penia namwali poho rahu na'akeme onno, de napoho mamani! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Onne penia Ya ala wanakuku ma namlolo ki mi, maa mi akim ka naili'il Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nano mi eniyenihe, ri mahaku kan kukul mouropo na'aheni Ya'u hi'i dohohale, ono Ainu'u dohohala kaale! Ya'u wakunu ha ma namlolo, de alhi'ihepe mi akim ka naili'il Maya'u? ");
INSERT INTO kjeNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Inhoi ma namwali Makromod Lalap Nin ri, ai onne raram nodi derne nakani la kokale Makromod Lalap Nina wanakuku. Enimaa mi eniyenihe mamhene derne makani Makromod Lalap Nin wanakuku ono mi ka mamwali Nin ri.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudi enihe re'el Yesus na'ahenia, “Ai ma'aheniyedi me'e O mano Samaria, la hayakyake hu'uredi O raramne, de ainim wanakunu onne namlolo kokkoo!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus na'ahenia, “Hayakyaka kan hu'ur Ya'u raram! Ya'u horhawe Ainu'u Pape, maa mim ilinohi malnohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ya'u ka anoin ul'uli sasa'a nano ri mormori, maa Makromod Lalap Nin panaeku na'akulu na'alapa Maya'u, la Ai onne ma naho'ok nakail ri mormori. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi derne nakani de hi'i lernohi Ainu'u wanakuku eni, ai onne kan maki, maa lernala or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Enime'ede Yahudi enihe ra'aheni wali'ur, “Ai mauroin nahenia namlolo kokkoo hayakyake hu'uredi O raram me'e, ono am dernedi Onum wanakunu nahenia ri man lernohi O lo'o kan maki! Abraham noro nabi-nabi enihe makiyedi me'e, de hi'ihehewi Om wakunu heheni? ");
INSERT INTO kjeNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Alhi'ihepe Om pene'ek Om kulu narehi Abraham noro nabi-nabi man makiyedi me'enihe? O eni inhoi penia wakunu heheni?!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus na'aheni, “Lo'o Ya'u mehe a'akulu a'alap Ya'u kemen, onne kan min haida, maa Ya Am'u penia ma na'akulu na'alap Maya'u, la mi me'ene ma'aheni Ya Am'u namwali minim Makromod Lalap! ");
INSERT INTO kjeNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mim wakunu heheni, maa namlolo kokkoo mi ka mauroin Ai! Ya auroiroin Ai, la lo'o Ya aheni ka auroin Ai, Ya amwali ma napoho naise mi haenhi, maa Ya auroiroin Ai, la Ya'u hi'i wewhe Ainin wanakuku mamani. ");
INSERT INTO kjeNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nonolu minim papa Abraham akin nahuwa'an ono ai nauroin lere man mai an do'on Ya'u mai noho wawan, la ors eni an do'onedi de akin nahuwa'an wake'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kame'ede ri Yahudi man derne Yesus enihe ra'aheni, “Onum anna kan rakan wellima makun! Hi'ihehewi Om do'onedi Abraham me'e?” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus na'aheni wali'ur, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lere kar mori Abraham makun, Ya'u aiyedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Idewe Yahudi enihe rala waku rodi wasla Yesus, maa Ai nahaledi kemen de namhara Romleu Lap onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus nala'ala'a ne, An do'on mo'oni ida. Mo'oni onne lere mori me'ede makan tokedi memen. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Enine Nina man lernohi pakunohi enihe ra'ukani Ai, “Papa Meser, alhi'ihepe mori me'ede makan tokedi memen me'e? Inhoi nin dohohala nakoko penia makan toko? Ainina, ee inna amanhe?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus na'ahenia, “Ainina dohohala ka nakoko ai makan toko, la ai inna aman rira ka haenhi, maa ai makan tokedi leke rin do'on Makromod Lalap Nina ke'eke'el an'anhe namwali ri eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ors eni lelere makun, de leken paharin aile ik hi'i wewhe Ai man hopon Ya'u mai Nin honowok, maa ka nalo'olo lo'o na'umetek me'e, de kak howok me'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lere Ya'u mormori mai noho wawan eni makun, Ya amwali ropropo man ropedi ri mormori man minle mai noho wawan eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ai na'ahenia heheni horu, An sapruiyedi aparne napa'uk elimo'e nanumene nalsoru mo'oni onne makan. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Horu ne, Yesus hopon maktoko onne na'ahenia, “Lam laruwedi o makam lolo oir kiliu Siloam (Siloam onne napa'ahne, ‘hopon nala'a’).” Ende maktoko onne lan laru makan horu ne, an wali la makan mouwedi me'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Enine maktoko onne nina nakar wali noro ma nadedem do'on ai naikokore mehe napanpanak, hi ida ma na'ukani ida na'ahenia, “Ai eni ri ma nadedem naikoro kalla wawan mehen napanpanak onne harome?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ri heruwali ra'aheni, “Namlolo ai kokkoo,” maa ri namehin ra'aheni, “Ai onne ka, maa oin makan namnenehe noro maktoko onne.” Enimaa maktoko onne na'aheni mamani, “Ya'u penia maktoke man mehe napanpanak lolo kalla onne!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ende hi ra'ukani ai, “Emene hi'ihepenia o makam mouwedi me'e?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ai na'aheni, “Ri ida ma naran Yesus hi'i wa'an. An saprui aparne napa'uk elimo'e nanumene nalsoru ya'u makan, horu ne hopon la'u laru lolo oir Siloam eni, de ya'u laru horu ne, i mak'u mouwedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hi ra'ukani ai ra'aheni, “Ri onne aile ewi me'e?” An walhe, “Ka auroin.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Lere Yesus hi'i wa'an man makan toko onne pakroromnala Yahudi rir Lere Alam Renren Warwarne, de luli rin howok lere onne. Ende Yahudi enihe rodi man nonolu makan toko onne laa ri Parisi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Enpenia ri Parisi enihe ra'ukani ai wali'ur na'ahenia, “Hi'ihehewi penia o makan mouwedi me'e?” Ai na'aheni, “Ri onne nala elimo'o tehe soru ya'u makan nanumene la'u laru, idewe i mak'u mouwedi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Enine ri Parisi heruwali ra'aheni, “Ri man hi'i wa'an ai makan onne kan mai nano Makromod Lalap ono kan horhawa Alam Renren Warwarne.” Enimaa ri Parisi namehin ra'aheni, “Hi'ihehewi ri man hi'i dohohale nauroin hi'i tanada ri kan dodo'onnala makun ma nodi Makromod Lalap Nina ke'eke'el an'anha heheni!” Kame'ede na'akeme rasesi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ende ri Parisi enihe ra'ukani man nonolu makan toko onne ho'o me'e, “Kene konohi mayai, ri man hi'i wa'an o makan onne ri wawa'an, ee ri yakyaka?” An walhe, “Ya auroin Ai onne nabi ida.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Enimaa Yahudi rir man panulu enihe kar derne rakanie, de ra'aheni ai makan kan toko la Yesus kan hi'i wa'an, penia hir polu nina ri leleher mai. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hi ra'ukani, “Namlolo kokkoo mi anum eni mori me'ede makan tokedi, ee ka? Hi'ihehewi penia makan mouwedi me'e?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nina ri leleher walhe, “Namlolo kokkoo ai anum eni mori me'ede makan tokedi memen me'e, ");
INSERT INTO kjeNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","maa ai ka mauroin hi'ihepenia ors eni makan mouwedi me'eni. Mayai me'ene ka mauroin inhoi man hi'i wa'an makan penia mouwedi me'e. An lapedi me'e de, ken pape mehe ra'ukani ai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Man nonolu makan toko onne nina ri leleher ra'aheni heheni ono ramka'uk Yahudi rir man panulu onnenihe, ono hi raledi kenekrohu me'e nahenia rohiyedi ri na'akeme ma ne'enohi Yesus onne namwali Kristus man Makromod Lalap kikan namwali Rai laa ewi-ewi nano rir kerei. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Onne penia hir walhe deudeul ra'aheni, “An lapedi me'e, de ken papa mehe ra'ukani ai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kame'ede hi rapolu wali'ur man nonolu makan toko onne leke ra'ukani wali'ur, “Kikan hopo ma'aheni om wakunu ha ma namlolo lolo Makromod Lalap leken kalarna! Ai mauroiroin ri man hi'i wa'an o makam onne, ri man hi'i dohohale!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","An walhe, “Ka auroin lo'o ri man hi'i ya'u wa'an onne man hi'i dohohale, ee ka, maa ya auroiroin nahenia nonolu i mak'u tokedi, maa ors eni i mak'u mouwedi me'e la ya'u po'onedi waliwali me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Enine hi ra'aheni wali'ur, “An hi'ihewi o makan penia om do'onedi me'e? An hi'i inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","An walhe, “Ya'u konohiyedi mi me'e, maa mamhene derne ainu'u wanakunu wake'e. Alhi'ihepe ma'ukani ho'o me'e? Yon hi'i de mi raram nodi mamwali Nina man lernohi harome?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ideweni ne, hir wahilei ra'idaru ai ra'aheni, “Eih! O penia mamwali man lernohi Ai, maa mayai eniyenihe lernohi Musa mehe. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ai mauroine Makromod Lalap wakunu noro Musa, maa ai ka mauroin ri onneni mai nano ewi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mo'oni onne polletilu de na'aheni, “Eih! Ka auroin minim panaeku! Lere mori ya'u me'ede mak'u tokedi, maa An hi'i i mak'u mou penia ya'u do'onedi me'e! Hi'ihehewi mi ka mauroin Ai nano ewi?! ");
INSERT INTO kjeNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ik kauroin Makromod Lalap kan derne ri man hi'i dohohala, maa An derne ri man horhawe la man lernohi Nina honorok panaeku mamani. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nano noho eni nin ma namwali me'ede kak derne rin hi'i wa'an ri man mori me'ede makan tokedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Lo'o Ri onne kan mai nano Makromod Lalap, Nin molollo kaale hi'i ha naise eniyeni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Idewe Parisi enihe ra'aheni, “Lere num ine kan mori o makun, num dohohale nammoriyedi me'e, de hi'ihepenia om wakuku mayai?” Lere onne me'ede hir kawala ai leke yono laa rir kerei raram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus derne Yahudi enihe kawala man nonolu makan toko onne leke yon laa rira kerei raram me'e, de Ai nanoin la na'aheni, “O akin naili'il Ai man mai nano a'am raram namwali Ri Mormori Anan, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Enine ai na'aheni, “Pape, Ai onne inhoi? Ya apanak Pape konohi maya'u leke ya akin naili'il Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus walha na'ahenia, “Om do'onedi Ai me'e. O moro Ai maham wakukunue!” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Makrom'u, ya akin naili'il Makrom'u!” Idewe eni ai nahirawa Yesus kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus na'aheni, “Ya'u mai leke ho'ok kail ri mormori noho wawan eni. Ya'u mai leke hi'i maktoko do'onedi, la man dodo'on makan tokedi, ono ri ma na'aheni hir do'on mouropo kar do'on rauroin haida ma namlolo.” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Enla ri Parisi man aile lolo onnenihe heruwali derne Yesus Nin wanakunu ra'aheni, “Num panaeku mayai eniyenihe maktoke?” ");
INSERT INTO kjeNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kame'ede Yesus ne'el hi, “Lo'o mi mauroin nahenia mi makum tokedi ono ka mauroin inhawe ma namlolo, Makromod Lalap ka nala sala ki mi, maa mi mehe mauroin mi makum moumou la mauroin ha wo'ira na'akeme ma namlolo. Onne penia mim saledi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Yesus na'aheni, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ri man huri pipduma nadedem mai ro'o raram lolo takin nina nikeni, maa ri ma nodi kalla susuwar mai raram, ai onne ri ma namna'a la nahoro ri nin hahaa. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ri ma nadiyaka ro'o hari nike leke man huri onne laa raram, la nin pipdum enihe rauroiroin ai lirna, de lernohi ai. Ai napolu wekel dohodoho naran mene lernohi laa paharne. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nina pipdum enihe laedi paharne mene ai noluwedi, la nina pipdum enihe lernohi ono rauroiroin ai lirna. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hi ramhene lernohi ri namehin. Lo'o ri namehin napolu, hir lari, ono ka rauroin lirne.” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus wakunu lir naho'ok eniyeni, maa ri Parisi man derne enihe ka rauroin Ainin panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ende Yesus na'aheni wali'ur, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ya'u penia amwali pipi ro'o nina nike. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ri man mai nolu Ya'u man hi'i kemen namwali man huri, hi onne ma namna'a, maa pipdum enihe kar derne rakani ma namna'a onnenihe lirna. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ya'u eni amwali nike, de inhoi mai raram lolo Maya'u, ai onne huri we'eredi nano nin dohohala nin hunukum makmaki, la lernala or'ori dardari ma kan horu. Enla ai onne naise pipduma man lolo nike laa raram mai paharne leke lernala hanana'an nonomun man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ri ma namna'a onne mai leke namna'a, nesne, la nano'onyaka mamani, maa Ya'u mai leke ri mormori lernala or'ori ma namlolo man penpenu kemkeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ya'u eni amwali man huri wawa'an. Ya ala I kem'u maki leke nahinerre Ainu'u pipdum enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lo'o orpipi pair ri namehin namwali man huri, ri onne ka nadiyaka pipduma wawa'an naise orpipi mememen, ono pipduma onne ainine, ka. Ende lere ha mormori merwui mai tamak pipdum enihe, an lari me'e la kan peinohi pipdum enihe, penia lariye'er rarari. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","An lari ono nanoin naiwe'el mehe, la kan peinohi pipdum enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ya'u eni man huri wawa'an. Ya auroiroin Ainu'u pipdum enihe, la pipdum enihe rauroiroin Ya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Onne namnenehe noro Yo oro Ainu'u Pape. Ai nauroiroin Ya'u la Ya auroiroin Ainu'u Pape, la Ya ala I kem'u maki leke nahinerre Ainu'u pipdum enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ainu'u pipduma namehin aile haenhi, maa kan minwuku noro pipduma ma aile ro'o eni, la Ainu'u panaeku Yo odi mai leke min wewerre noro Ainu'u pipdum enihe. Hi lo'o derne Ya'u lirna haenhi, leke Ainu'u pipi na'akeme minwuku ro'o ida la rir man huri ida mehe, ono Ya'u penia ma namwali rir man huri. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ainu'u Pape naramyaka Ya'u ono Ya ala I kem'u maki leke Ya'u mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri mahaku ka nodi molollo nesne Maya'u, maa Ya'u raram nodi ala I kem'u maki. Ainu'u molollo aile Ya ala I kem'u ri nesne la Ainu'u molollo aile Ya'u mori wali'ur. Onne penia honowok man Ya'u kokale nano Ainu'u Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesus wakunu horu ne, ri Yahudi enihe rasesi wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hi nammori ra'aheni, “Yono makani Ai! Hayakyake hu'uhu'ur raram de na'iseriyedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Maa ri namehin ra'aheni, “Lo'o hayakyake hu'uhu'ur raramne, Ai kan wakunu heheni. Hayakyaka onne ka nadedem hi'i wa'an man makan toko!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lere ri Yahudi hi'i yapi ra'aromo rira ‘Romleu Lape Nin Ler Alam Man Horu’ lolo Yerusalem rakanedi me'e, la lere onne noho rinrinne nina lere alam. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus mahan lalaa mamai lolo Solomo Nin Henei man aile Romleu Lape. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Lere onne ri Yahudi enihe lawuku lupurala Yesus la ra'aheni, “Ma'anana Om konohi mayai mouropo O eni inhoi? Yom hi'i yai ma'irhu! Lo'o mamwali Kristus man Makromod Lalap kikanedi namwali Rai eni, konohi mayai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kame'ede Yesus ne'el hi, “Ya'u konohiyedi mi me'e, maa mi akim ka naili'il Maya'u! Ainu'u hini'i wenewhe nodi kunukunohi nahenia Ya'u eni inhoi, la kukunohi nahenia Yo odi Makromod Lalap Nin ke'eke'el an'anha haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Enimaa mi akim ka naili'il Maya'u ono mi ka mamwali Ainu'u pipduma hunuri. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ainu'u pipduma na'akeme rauroiroin Ainu'u wanakunu. Ya auroiroin hi, la hir lernohi Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya ala or'ori dardari hi de kar makileken, maa hir mori laa ewi-ewi, la ri mahaku ka naruri nahoro hi nano Ya'u liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ainu'u Papa naledi hi na'akeme Maya'u me'e, la An lapa narehi na'akeme, de ri mahaku ka naruri nahoro hi nano Ainu'u Pape liman raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yo oro Ainu'u Pape mahaku.” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Enine Yahudi eni rala waku rodi wasla Yesus ho'o me'e, ");
INSERT INTO kjeNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","maa Yesus na'aheni, “Mim do'onedi tanada lalapa nammori me'e man Ainu'u Pape hopon Ya'u hi'i. Inhawa tanada namehiyala penia mim wasla Ya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kame'ede ri Yahudi enihe ra'aheni, “Ai ka ma'ahan ono Om hi'i tanada onnenihe, maa ai ma'ahan ono O ma'ihoru ma'idaru Makromod Lalap! O ri mormori mehe, maa O ma'aheni mamwali Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus na'aheni wali'ur, “Lolo minim keneri hono'ok eni horhorok ma na'ono mi ri mormori aile ma na'aheni, ‘Mi mamnenehe Makromod Lalap ananhe.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ik kauroiroin nahenia inhawe man horokedi lolo Horok Lap raram kar herre laa ewi-ewi, de lo'o Horok Lap na'aheni ri man mori nonolu onnenihe namnenehe Makromod Lalap ananhe, emene hi'ihehewi noro Maya'u ma namwali Ai Anan? ");
INSERT INTO kjeNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Makromod Lalap me'ene na'ono Maya'u la hopon Ya'u mai noho wawan eniyeni. Ende lo'o Ya aheni Ya amwali Makromod Lalap Anan, alhi'ihepe ma'aheni Ya a'ihoru a'idaru Ai naran!? ");
INSERT INTO kjeNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lo'o Ka'u hi'i honowok man Ainu'u Pape nala Maya'u eni, wa'an rehi yono mi akim naili'il Ya'u, maa Ya'u hi'i Nin honowok onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kade mi akim ka naili'il Ainu'u wanakunu, maa wa'an rehi mi akim naili'il Ainu'u hini'i wenewhe onnenihe leke mim do'on mauroin nahenia Ainu'u Papa minle Ya'u raram, la Ya'u minle Ainu'u Pape raram haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Enine hir kene kele Yesus wali'ur, maa Ai nahala kemen nala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesus wali wali'ur laa oir Yordan walie, la minle onno man nonolu Yohanis nodi oir ulutada ri eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ri nammori mai Yesus minwuku lolo onne la ra'aheni, “Kade Yohanis kan hi'i tanada ri kan dodo'onnala makun, maa ainina wanakunu ma na'ono ri eni na'akeme namwaliyedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ende ri nammori ma aile lolo onne akin naili'il Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lere onne mo'oni ida aile naran Lazarus, la an minle leke Betania noro narna woro'o, ida naran Maria la ida naran Marta. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma naran Maria eni penia ma nala wuru wola'ula'u halle Yesus ein la nodi nina muruk sorue. Enla lerida Lazarus onne nakni'ir, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","de narna woro'o enihe hopon ri lan konohi Yesus nahenia hi narna man Yesus naramyake nakni'ir. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus dernedi ne na'aheni, “Apinha onne kan hi'i den maki, maa kini'ir eniyeni namwali leke ik po'on Makromod Lalap Nin ke'eke'el an'anha ma narehi ma nalewen la Ya'u ma namwali Ai Anan lernala ul'uli sa'sa'a haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kade Yesus naramyaka Maria, Marta noro narna Lazarus, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","maa lere dernedi Lazarus nakni'ir, An min lolo onne alam woro'edi mene wali laa Betania. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ende nakawedi alam woro'o nanumene Yesus ne'el Nina man lernohi pakunohi na'ahenia, “Mai ik wali laa Yudea here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Enine man lernohi enihe ra'aheni, “Papa Meser, idedi nanumene Yahudi enihe manlo'o rodi waku wadesne Papa! Alhi'ihepe ik wali laa enne ho'o me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kame'ede Yesus nair wanakunu naho'ok na'ahenia, “Lere kekeme ida nin jam idaweli woro'o, namlolo, ee ka? Ende inhoi nala'a noro wewerre Maya'u kan wekur, ono ai nodi lelere leke do'odo'on kalla, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","maa inhoi ma nala'a a'alam lo'o wekur, ono ropropo kaale.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus wakunu heheni horu ne, na'aheni wali'ur, “Ik walin Lazarus namkukuru, maa na'amoli ik laa mene Ya amake.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Man lernohi pakunohi ra'aheni, “Papa Meser, lo'o Lazarus namkukuru, an pelek wa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lere onne Yesus na'aheni Lazarus namkukuru, maa Ainina panaeku Lazarus makiyedi me'e, maa Nin man lernohi pakunohi enihe ka rauroin Nin panaeku. Hir pene'ek Lazarus namkukuru naise ma namkuru nadedem mehe. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ende Yesus wakunu mouropo nahenia, “Lazarus makiyedi me'e, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","maa onne namwali leke mi akim naili'il Maya'u wawa'an, de wa'an rehi an makiyedi mene Ya'u rakan enne. Ende mai kala'a laa Betania here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kame'ede Tomas (ma nadedem rin wekel Tatana Adodo'o) ne'el walin man lernohi Yesus enihe, na'ahenia, “Mai ik lernohi Yesus laa Yudea, kade koro Ai maki wewerre!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus rakanedi Betania ne, rin konohi Ai, “Lazarus makiyedi me'e, la ai modi la ma'akene manakuwedi ku'il raram alam wo'akkedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Leke Betania onne ko'u lo'o kilu wokelu nano Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ende Yahudi nammori mai ka'ar rahuwa'an Marta noro Maria akin ono narna makiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta derne Yesus maiyedi ne, idewe lan pakromo noro Yesus, maa Maria ka namhara nakar makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ne'el Yesus na'ahenia, “Makrom'ue! Lere onne Makrom'u aile mai eni manlo'o I nar'u kan maki, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","maa ya auroiroin nahenia ors eni me'ede inhawe O mapanak, Makromod Lalap nala ki O.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus na'aheni, “O narum eni mori wali'ur!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta na'ahenia, “Makrom'ue! Ya auroiroin Lazarus lo'o mori wali'ur noro ri man maki na'akeme lere noho nina man horue.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus na'aheni, “Ya amwali or'ori dardari onno! Ya'u penia ma na'amori ri man makiyedi me'e, la Ya ala or'ori dardari ma kan horu hi. Inhoi ma akin naili'il Maya'u, kade an maki, maa makmaki ka nodi molollo ai me'e, de mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Enla ri man lernala or'ori dardari, la ma akin naili'il Maya'u, ai onne kan maki, maa mori laa ewi-ewi! O akim naili'il Ainu'u wanakunu eni, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta walha, “Makrom'u! Ya akin naili'il O, la ya auroin O penia Makromod Lalap Anan man kikanedi namwali Rai laa ewi-ewi eni, la ya auroin Makromod Lalap hopon O mai noho wawan eniyeni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta na'aheni heheni horu ne, lan polu Maria. Ai nalpupu Maria na'ahenia, “Papa Meser maiyedi me'e la mahan na'ukani o.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria nauroiroin Yesus maiyedi ne, idewe halhala lan pakromo noro Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Enimaa Yesus kan rakan leke raram makun, aile leke paharne lolo onno man idedi wakunu noro Marta onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ri Yahudi man minle Maria nina nakar onnenihe do'on Maria halhala laa paharn, de hir lernohi ono rauroiroin nahenia Maria nala'a ku'il nahere. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria laa na'urani Yesus, idewe kadi ein korno yawa la na'aheni, “Makrom'e! Lere onne Makrom'u aile mai eni manlo'o i nar'u kan maki.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus do'onedi Maria noro ri Yahudi enihe mai raherhere ne, idewe Ai honorok akin sus wake'e la hehel rehi. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kame'ede Ai na'ukani, “Mi ma'aken manakuwedi ihin kemen mala loile aile ewi?” Hi ra'aheni, “Makrom'e, mam po'on.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ideweni Yesus nahere me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Enine Yahudi enihe ida ma ne'el ida, “Eih! Namlolo kokkoo Ai naramyaka rehi Lazarus!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Maa heruwali ra'aheni, “An hi'i wa'an man makan toko do'on wali'ur, emene hi'ihepenia Ai kan hi'i wa'an Lazarus leke yon maki?” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kame'ede hi roro Yesus laa ku'il man rodi ra'akene manaku Lazarus ihin kemen. Hir rakanedi ne, Yesus akin woir wali'ur. Ku'il kalarna onne rodi waku lapa ida el'elek ku'il makan. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ende Yesus hopon poiyedi waku rodi el'elek onne. Enine man maki narna Marta na'aheni, “Makrom'ue, hir loiyedi Lazarus ihin kemen lolo eni alam wo'akka me'e, de lo'o ihin kemen popedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus na'aheni, “Ya'u konohiyedi mi me'e nahenia lo'o mi akim naili'il mim do'on Makromod Lalap Nina ke'eke'el an'anhe ma narehi ma nalewen!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kame'ede hir poiyedi waku onne laa herne, la Yesus niliha'a laa wawan la na'aheni, “Pape, Ya apanak trimkasi Pape ono dernedi Ya'u me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ya auroin Pape derne Ya'u lirna mamani, maa Ya'u konohi ha eni na'akeme lolo heri eni kalarna leke akinhe naili'il la rauroin nahenia O penia man hopon Ya'u mai noho eni wawan.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Onne horu ne, Yesus wakau naruri na'ahenia, “Lazarus, mamhara mai paharne here!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Idewe Lazarus man makiyedi onne namhara nano ku'il mai paharn, liman ein rodi tapi lunlunne makun, la oin makan rodi tapi paspasun haenhi. Yesus na'ahenia, “Mim we'eredi tapi leke nauroin nala'a wawa'an.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lere onne ri Yahudi nammori aile lolo onne, de na'akeme man lernohi Maria laa paharne do'onedi Yesus Nin hini'i onnenihe, penia hi nammori akin naili'il Yesus, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","maa heruwali lar konohi Yesus Nin hini'i onne ri Parisi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ende imam-imam lalap roro Parisi enihe polu wuku ri ma nadedem naikoro wuku ho'ok kail ri lernohi Yahudi rir agame nin holoor halauk enihe. Hi na'akeme ra'ahenia, “Lo'o ik hi'ihewi Ai?! Ai eni hi'i tanada namansa man kukul Makromod Lalap Nin ke'eke'el an'anha! ");
INSERT INTO kjeNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lo'o maika kak kawala de An wakuku mamani, iknik ri na'akeme akin naili'il Ai, penia Roma nin ke'urauk mai rano'onyaka iknika Romleu Lape, la raiye'eredi iknik hair!” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lere onne nano ri man ho'ok kail onne ri ida aile naran Kayapas. Anna onne ai namwali imam man kulu narehi. Ai ne'el hi na'ahenia, “Heih! Mi ka mauroin haida-haida. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mi ka mauroin nahenia wa'an rehi ri ida maki leke yon iknik hair makileken.” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayapas pene'ek nodi nin panaeku aimehi wakunu heheni, maa ai ka nauroin Makromod Lalap nodi nin wanakunu onne kukul panaeku namehin, ono anna onne ai penia ma namwali imam man kulu narehi. Enpenia Makromod Lalap nodi ainin wanakunu onne kukunohi nahenia Yesus maki leke ri Yahudi lernala or'ori dardari, ");
INSERT INTO kjeNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","la ka na'aheni Yahudi mehe, maa An maki leke Makromod Lalap Nina ri mormori na'akeme ma aile ewi-ewi lernala or'ori dardari haenhi leke na'akeme lawuku ramwali mahaku. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ende nano lere onne me'ede Yahudi rir man panulu enihe lawuku rala panaeku leke resne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Onne penia Yesus kan lalaa mamai lolo Yahudi kalarna me'e, maa namharedi Yudea nala'a leke ida naran Efraim. Leke onne na'urani noho mamun, la Yesus noro Nina man lernohi pakunohi enihe min lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lere onne Yahudi nina Lere Alam Lalap Paska na'uraniyedi me'e, de ri nammori nano lekleke mai Yerusalem leke ra'amou kemen nano dohohale lernohi Yahudi nin holoor halauk mene rakan lere alam lernohi Paska. ");
INSERT INTO kjeNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hi maha ranoin Yesus, de lere hir minwuku Romleu Lapa nina nikoin ida ma na'ukani ida, “Minim panaeku hi'ihehewi? Lo'o kan mai harome?” ");
INSERT INTO kjeNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hi ra'aheni heheni ono imam-imam lalapa noro ri Parisi enihe raledi kenekrohu la loikaruwedi heri onne me'e nahenia inhoi nauroiroin Yesus Nin miminlole kukunohi leke lar kele. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yesus nala'a leke Betania la lere alam woneme wali'ur mene Yahudi rir Lere Alam Lalap Paska. Lazarus man Yesus na'amori nano makmaki min Betania onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ende lolo Betania onne rin hi'i ya'an yomun rodi horhawe Yesus. Lere onne Lazarus noro heri man mai enihe ra'ak wewerre noro Yesus, la Marta penia ma nahinoi namkau hanana'an na'akeme hi ra'an. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ka nalo'ol ne, Maria nodi wuru Narwastu man wala'ula'u potol ida mai nala halla Yesus ein mene nodi nina muruk soru na'akisi. Wuru wola'ula'u onne wella ai wawan wake'e la ra'in holkekeme nakar onne raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Enime'ede Yesus Nina man lernohi ma naran Yudas Iskariot (ma na'olu Yesus), an hehel rehi do'on Maria nina hini'i onne de na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Heih! Hi'ihepenia ka ma'olu wuru onne leke mala nin kupan laa ma na'alehe haida-ha'ide? O ma'olu wuru onne wella kupan pere rahu wokelu menee!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas wakunu heheni, maa nina panaeku ka na'ono ma na'alehe haida-haida enihe, ono ai onne nakmanna kupan. Ai namwali ma nasala ri idaweli woro'o enihe rira kupan, maa nadedem ai namna'a kupan nodi na'uwali nine haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Enimaa Yesus dadiyale, “Yono kawala maeke eni nin hini'i Maya'u. An hi'i heheni Maya'u, leke I kem'u namkene rin na'akene manaku. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ri ma na'alehe haida-haida onnenihe nornoro mi mamani, maa ka nalo'ol Ya'u ka oro mi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ri nammori derne nahenia Yesus aile Betania de rala'a enne. Rira panaeku kar laa do'on Yesus mehe, maa rira panaeku laa do'on Lazarus man mori wali'uredi onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ende imam lalap enihe rala panaeku resne Lazarus haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ono ri Yahudi nammori ma nano Yerusalem ramhene derne rakani hi me'e, maa hi akin naili'il Yesus ono hir do'on rauroin Lazarus maki la ra'amori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Rakan oreki, ri nammori maiyedi Yerusalem me'e, leke lernohi Lere Alam Paska. Hir derne nahenia Yesus aile kalla toro, la na'uraniyedi Yerusalem me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ende hir laa rala korma kawin rodi laa pakromo Yesus, leke na'akeme sokmura lolo kalla, la hir wakau ra'aheni, “Ka'uli kasa'a Makromod Lalap! Na'amoli Makromod Lalap namre'e namharu O man mai nodi Ai Oin Naran! Na'amoli Makromod Lalap namre'e namharu Makromod ma namwali Israel nina Rai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lere Yesus mai Yerusalem, An ha'a keledei anan ida man aile lolo kalla, la onne na'akuku na'anokor wanakunu man horokedi lolo Horok Lape raram ma na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ri Sion mie! Yom mamka'uk! Po'onala! Minim Rai ha'aha'a keledei anan mai me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nano nonolu panaeku ma namwali noro Yesus eni horokedi lolo Horok Lape raram, maa lere onne Nin man lernohi pakunohi enihe ka rauroin nahenia ha ma namwali onne na'akuku na'anokor inhawe man horhorok ai Horok Lap raram. Enimaa rakan lere Makromod Lalap na'akulu na'alap Yesus nano makmaki mene hir horoknala la rauroin ha onne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ende heri man po'on Yesus napolu Lazarus namhara ku'il mai paharne onne laliwewer Yerusalem wakunu Yesus Nin hini'i onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Enpenia ri nammori mai pakromo noro Yesus, ono hir derne nahenia Yesus hi'i tanada man ri kan dodo'onnala makun man kukul Makromod Lalap Nin ke'eke'el an'anha. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kame'ede ri Parisi enihe ida ma ne'el ida, “Ik ka karuri hi'i haida-haida me'e! Ik po'on mehe ri noho wawan na'akeme lari lernohi Ai me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lere Alam Paska onne ri nammori mai Yerusalem leke hoikani Makromod Lalap, la lolo hi onne ri Yunani aile haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ende hir mai Pilipus manin Betsaida ma aile noho Galilea onne, la ra'ukani, “Pa'e, ainima panaeku pakromo norala Yesus.” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kame'ede Pilipus lan konohi Andreas de woro'ohe laa konohi Yesus, “Pap Meser! Manina noho Yunani maha ranoin Papa Meser.” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus ne'el hi na'ahenia, “Makromod Lalap Nin lere alam rakanedi me'e, leke Maya'u ma namwali Ri Mormori Anan ra'akulu ra'alapa. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ik kaho'ok wini gandum waku ida ma nadiyaur laa yawa la hapedi, naise I kem'u man makiyedi. Lo'o rin kan hape, wini gandum onne ka namwali haida-haida, maa lo'o wini onne nadiyaur la rin hape, wini onne mori, dipi, la woi leke eren nammomori. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Inhoi nanoin nin wawa'an mamani, an makileken, maa inhoi namhene nanoin nin wawa'an aimehi lolo noho eniyeni, ai onne lernala or'ori dardari ma kan horue. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inhoi raram nodi ilitolle Ainu'u honowok, hi onnenihe lernohi Maya'u mamani, la Yo oro man howok onne min wewerre lolo Ainu'u miminlole. Enla Ainu'u Pape horhawe ri na'akeme ma namwali Ainu'u man howok.” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ya akin woir rehi la Ka'u kerhu wewerek pananaka ma na'ikeki mamai enie, de ka auroin Ya a'aheni inhawa Ainu'u Pape! Manlo'o Ya a'aheni, ‘Papa, mahaledi Ya'u nano wewerek pananaka eniyeni!’ Maa Ya'u ka'u wakunu heheni ono panaeku lernala wewerek pananaka eni penia nakoko Ya'u mai noho wawan!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ende Yesus hi'i lir napanak Makromod Lalap, “Pape mala hari Onuma ke'eke'el an'anhe ri mormori noho wawan do'on leke Pape Naran na'amoli ra'uli rasa'e!” Yesus na'aheni onne horu, Lir ida nano a'am raram na'aheni, “Ya a'akulu a'alapedi Ya'u Naran me'e, la Ainu'u panaeku Ya a'akulu a'alapala wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ri nammori man min lolo onnenihe dederne Lir onne, la heruwali ra'aheni onne noho dildille, maa heruwali ra'aheni onne hophopon a'am raram lirna mai Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Enimaa Yesus na'aheni, “Lir man mim dederne onne ka rala leke paku Maya'u, maa Lir onne rala leke paku mi. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lere eni me'ede Makromod Lalap naho'ok nakail ri mormori noho wawan eni, la Ai namkene nahoredi Hayakyak Makromon nina molollo lolo noho wawan eni me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Enla Maya'u, lere rin kikan Ya'u laa onno man kulu, lere onne Ya apolu ri na'akeme mai Maya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus na'aheni rin kikan Ai laa onno man kulu leke heri rauroin nahenia An maki lolo au kekiyowok. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Enine ri man min lolo onne ra'aheni, “Lolo ainima keneri hono'ok, horhorok aile ma na'aheni, ‘Kristus man Makromod Lalap kikan namwali Rai eni mori laa ewi-ewi!’ Hi'ihepenia O ma'aheni, ‘Ri Mormori Anan lo'o kikan laa onno man kulu! Ri Mormori Anan onne inhoi?!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ende Yesus wakunu kemen na'ahenia, “Ka nalo'ol me'e ropropo man minle mi leken kalarneni moluwedi me'e, de modi ropropo eni mala'a here, leke yonde metmetek dawak mi. Ri ma nala'ala'a lolo metmetek raram kan do'on haida-haida de ka nauroin kalla. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lere eniyeni ropropo aile nornoro mi, de wa'an rehi mi akim naili'il ropropo onne, leke mi mamwali ropropo onne Nin ri!” Yesus wakunu heheni horu, mene Ai nala'a, la ka nalhari kemen hi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kade Yesus nodi Makromod Lalap Nin ke'eke'el an'anha hi'i tanada nammori man ri kan dodo'onnale makun, maa ri Yahudi enihe hi akin ka naili'il Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ende onne na'akuku na'anokor nabi Yesaya lirna ma na'aheni, “Makromod, inhoi akin naili'il ainima wanakunu loloi kakarue? Inhoi lo'o do'on Num ke'eke'el an'anha? Ri mahaku ka nauroin ha eniyeni na'akeme Onuma molollo!” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Onne penia, hi akin ka naili'il, ono lolo horok Yesaya horhorok aile haenhi ma na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Makromod Lalap na'aheni, ‘Ya'u mehe hi'i hi makan toko la akin kerhe leke yono hir do'on la rauroin de yon hir wali mai Maya'u leke Ya'u hi'i wa'an wali'ur.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya na'aheheni heheni ono lere nonolu onne an do'onedi Kristus Nina ke'eke'el an'anha ma narehi ma nalewen, la an konohi inhawe an do'onedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kade Yahudi rir man panulu nammori akin kerhe, maa heruwali akin naili'il Yesus haenhi. Hi akin naili'iledi Yesus, maa hi ramhene wakunu ra'aheni Yesus eni man kikanedi namwali Rai laa ewi-ewi, ono hi ramka'uk lo'o ri Parisi enihe kawale kar laa rira Romleu Lap raram me'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hi ramka'uk wakunu nahenia hi akin naili'il Yesus ono hi raram nodi lernala ul'uli sasa'a nano ri mormori narehi lernala ul'uli sasa'a ma nano Makromod Lalap! ");
INSERT INTO kjeNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ende Yesus wakau naruri na'ahenia, “Inhoi akin naili'il Maya'u, ai onne akin naili'il idewe Ai man hopon Ya'u mai haenhi! ");
INSERT INTO kjeNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Enla inhoi man do'onedi Ya'u me'e, ai onne do'onedi Ai man hopon Ya'u mai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ya'u mai amwali ropropo noho wawan eniyeni, leke inhoi ma akin naili'il Maya'u kan min lolo noho metmetek me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ka'u mai leke ho'ok kail ri ma kan hi'i wewhe Ainu'u wanakunu, kade loikaruwedi hi, maa Ya'u mai leke huri we'er noho wawan nano rir dohohala nin molollo. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Enimaa rakan noho eni nin man horu, Ya'u Lir'u penia namwali man ho'ok kail ri ma kan kokala Ainu'u wanakunu eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Onne namlolo ono ka odi Ainu'u molollo aimehi, maa Yo odi Ainu'u Pape man hopon Ya'u mai noho eniyeni Nin molollo. Ai penia man hopon Ya'u wakunu ha wo'ire eniyeni ki mi leke mauroin. ");
INSERT INTO kjeNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Enla Ya auroiroin nahenia Nin honopon man An hopon Ya'u konohi mi eniyeni nala or'ori dardari ma kan horu ki mi. Ende Ya'u mai konohi mi ha wo'ira na'akeme man Ainu'u Pape konohiyedi Maya'u me'eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lere onne Lere Alam Paska na'uraniyedi me'e, la Yesus nauroiroin nahenia Nin lere alam rakanedi Ai namhara noho wawan eni wali laa Nina Pape. Lere Yesus minle noho wawan Ai naramyaka Nina ri man aile mai noho wawan enihe, la kan ren naramyaka hi hehen nanumene Nin lere alam mai noho wawan horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lere helem ne, Yesus noro Nina man lernohi pakunohi enihe ra'an romun wewerre. Enla lere onne Hayakyak Makromon howok lolo Yudas raramne, penia an paekuwedi na'olu Yesus laa Yahudi enihe. Yudas eni Simon Iskariot anan. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus nauroinedi Nina Pape naledi molollo na'akeme Ai me'e, la Ai nauroinedi An mai nano Makromod Lalap la wali wali'ur laa Makromod Lalap haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ende Ai namriri nano onno rara'ak onne la ruriyedi Nina rain nanaru la nala haiwarwara ida nodi wukuwedi nelhenne. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Enine Ai nala oir halle ra'u lapa ida nanumene nodi wuri man lernohi enihe ein, la nodi haiwawara onne soru na'akisi einhe. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Rakan Simon Petrus ein ne, ai ne'el Yesus, “Makrom'u! Yono Makrom'u wuri ye ei'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus na'aheni, “Ors eni o ka mauroin makun inhawe man Ya'u hihi'i eni, maa lere li'ur mene mauroin.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus na'aheni, “Yono Makrom'u! Kan wa'an wuri ye ei'u!” Maa Yesus na'aheni, “Lo'o Ya'u ka'u wuri o eum, ikroko nik dunu'ul kanali kaprohuwedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ende Simon Petrus na'aheni, “Makrom'u! Yono wuri ye ei'u mehe, maa i lim'u noro ya'u uluwakun haenhi!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus na'aheni, “Ri ma narohedi me'e, onne mouwedi me'e, de yono wuri kemen me'e naukara wuri ein mehe. Mi eniyenihe mouwedi me'e, maa lolo mi eniyenie ri aile ma kan mou!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus na'aheni heheni ono Ai nauroinedi me'e inhoi man paeku na'olu Ai eni. Onne penia Ai na'aheni, “Mim mouwedi me'e maa lolo mi ri aile ma kan mou!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kame'ede Yesus wuri na'akeme ein horu nanumene An nair wali'ur Nina rain nanaru eni laa naikoro wali'ur na'ukani hi, “Mi mauroiroin inhawe man Ya'u hihi'i eni, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mi mapolu Ya'u ‘Papa Meser’ noro ‘Makromod’ la onne namlolo wake'e ono Ya'u penia ma namwali minim Meser noro Makrommu. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ende lo'o Ya'u ma namwali mi Makrommu noro minim Meser wuri mi ein, wa'an rehi mi ida man wuri ida ein haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ya'u kukul kalla ki mi de wa'an rehi mim teunohi Ainu'u hini'i onne, la ilitolle ri namehin naise Ya'u ilitolle mi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Hophopon wahwahan kan kulu narehi makromon, la ma nodi wanakunu kan kulu narehi ri man hopon an loikaru wanakunu onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lo'o mi mauroinedi ha wo'ire na'akeme man Ya'u konohi mi eniyeni la hi'i lernohie, Makromod Lalap nala rere'e haharu nammori ki mi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ainu'u wanakunu onne ka na'ono mi na'akeme. Ya auroin eniyeni namlolo ono Ya'u nili mi, la Ya auroiroin kokkoo mi akim. Enimaa eniyeni namwali leke na'akuku na'anokor horhorok man aile Horok Lape raram ma na'ahenia, ‘Ai ma noro Ya'u ra'akwuku wewerre, ai penia ma na'okuledi Maya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Lere eni Ya'u konohi mi inhawe ma namwali lere man mai leke lere mim do'on ha onne namwali, mim horokale de mi akim eren nailili'il Maya'u, la mi mauroin kokkoo nahenia Ya amwali Ai man ‘Aile’! ");
INSERT INTO kjeNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Inhoi man kokala ri man Ya'u hohopon eni, an kokala Maya'u haenhi, la inhoi man kokala Ya'u, ai onne kokala Ai man hopon Ya'u mai haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus wakunu onne horu ne, Ai honorok akin woir wake'e de konohi mouropo, “Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Nano mi eniyenihe ri ida aile ma na'olu Ya'u kanile Ainu'u arwali enihe.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kame'ede man lernohi pakunohi enihe ida man po'onala ida la mehe kakaiyedi ono ka rauroin Yesus Nin wanakunu eni lo'o nala inhoi. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ler onne Nin man lernohi pakunohi man Yesus naramyake onne naikoro aile Yesus herne malanna. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Enpenia Simon Petrus na'aromo makan laa man lernohi pakunohi onne leke na'ukani inhoi penia ma na'olu Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kame'ede man lernohi pakunohi onne hoi na'uraniyala Yesus mene na'ukani, “Makrom'u, lo'o inhoi man hi'i ha onne?” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus walha na'ahenia, “Na'amolia Ya ala roti eni remen Ainu'u manuk, mene Ya ala kani man hi'i ha onne.” Kame'ede Yesus nala roti tarana remen Nin manuk nanumene kanile Yudas ma namwali Simon Iskariot ananne. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas kokaledi roti nano Yesus ne, idewe Hayakyak Makromon nodiyedi molollo kemen me'e. Horu ne, Yesus ne'el Yudas na'ahenia, “Inhawe man om paeku, hi'i here!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesus Nina man lernohi pakunohi ma na'ak wewerre onnenihe ka rauroin panaeku onne wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Man lernohi pakunohi onnenihe heruwali rauroin nahenia lo'o Yesus hopon Yudas laa weli hahaa leke ra'akene Lere Alam Lalap Paska onne, ka eni lo'o hopon ai nodi kupan nalle ri ma na'alehe haida-haida. Hir paeku heheni ono Yudas namwali rira ma nasala kupan. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas kokaledi roti nano Yesus ne, idewe namharedi laa paharn. Lere onne alamedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas namharedi laa paharne, Yesus na'ahenia, “Lere alam rakanedi me'e leke ri mormori do'on Makromod Lalap na'akulu na'alapa Maya'u ma namwali Ri Mormori Anan, la ri na'akeme lo'o ra'akulu ra'alap Makromod Lalap haenhi ono do'on inhawe ma namwali noro Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Enla Ainu'u hini'i wenewhe onne na'akulu na'alapa Makromod Lalap, la Ai na'akulu na'alap Maya'u haenhi, la ors eni ha onne na'akeme lo'o pelek namwali. ");
INSERT INTO kjeNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ya an'u na'ahoru man Ya aramyaka! Ka nalo'olo Ya ala'a me'e, de ka oro mi me'e! Lo'o mi manoin Maya'u, maa kam do'on, naise nonolu Ya'u konohiyedi leleher Yahudi enihe. Enla Ya'u konohi mi haenhi, ‘Ka namwali mim lernohi Maya'u laa Ainu'u miminlole.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‘Ya ala keneri hono'ok worworu eniyeni ki mi: Mi ida ma naramyaka ida naise Ya aramyaka mi haenhi! ");
INSERT INTO kjeNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lo'o mi ida ma naramyaka ida, ri na'akeme rauroin nahenia mi mamwali man lernohi Maya'u!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kame'ede Simon Petrus na'aheni, “Makrom'u, lo'o mala'a ewi?” Yesus na'aheni Petrus, “Ors eni ka namwali om lernohi Maya'u, maa lere man mai mene om lernohi haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus na'aheni, “Makrom'u, hi'ihepe ka'u lernohi ors enie? Ya'u eni, ya amkene maki herre Makrom'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus na'ukani ai, “Namlolo Petrus, o me'e maki mahinerre Maya'u? Loi honorok wawa'an Ainu'u nou eniyeni: Manu kan kokoroi makun, o ma'aheni ka mauroin Maya'u rewkelu me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus na'aheni, “Yono mamkauk! Yon mi akim werek! Wa'an rehi mi akim naili'il Makromod Lalap la mi akim naili'il Maya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lolo Ainu'u Papa Nin nakar, onno miminlole nammori aile, la Ya ala'a enne leke Ya a'akene minim onno leke kokala mi. Lo'o eniyeni ka namlolo, Ya'u ka'u konohi mi heheni, maa namlolo kokkoo minim onno aile lolo enne. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ende Ya'u laa, leke a'akene minim onno onnenihe namkenedi mene Ya'u wali wali'ur mai orokaru mi laa onno onneni, leke ik min wewerre lolo enne. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Enla mi mauroinedi kalla man laa Ainu'u onno miminlole, la ka nalo'olo Ya'u laa enne me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Enimaa Tomas na'ukani, “Makrom'u, ai ka mauroin Makrommu laa ewi, de hi'ihehewi ai mauroin kalla?” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus walha na'ahenia, “Ya'u eni penia amwali kalla man laa Makromod Lalap. Ya'u penia amwali man wakuku mi panaeku ma namlolo kokkoo, la Ya'u penia amwali ma nala or'ori dardari ma kan horue ki mi. Ende inhoi raram nodi mai Ainu'u Pape Nina miminlole, ai onne mai lolo Maya'u leke rakan Ainu'u Pape Nin miminlole, kalla namehin kaale. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lo'o mi eniyenihe namlolo kokkoo mauroinedi Maya'u, onne nin panaeku nahenia mi mauroinedi Ainu'u Pape haenhi. Ende nano lere eniyeni mim do'onedi la mauroinedi Ai me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipus na'aheni, “Makromod, kene kukul Papa eni mayai, leke am do'onedi de ai akim namkenedi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Enimaa Yesus ne'el ai, “Pilipus! Yo oro mi nalo'oledi me'e! Alhi'ihepe ka mauroin Maya'u makun?! Inhoi do'onedi Ya'u me'e, ai onne do'onedi Ainu'u Pape me'e haenhi! Alhi'ihepe o mapanak Ya'u kukul Ainu'u Papa mim do'one? ");
INSERT INTO kjeNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipus, alhi'ihepe o akin ka naili'il Yo oro Ainu'u Pape mamwali mahakue? Yo oro Ainu'u Pape onne mahaku, de Ainu'u wanakunu man mim dederne onne Ainu'u wanakunu ka, maa Ainu'u Papa nine. Yo oro Ainu'u Papa mamwali mahaku, de Ainu'u hini'i wenewhe man ma'aruru na'akeme onne namwali Nin honowok man An hi'i lolo Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wa'an rehi o akin naili'il nahenia Yo oro Ainu'u Pape mamwali mahaku, maa lo'o o akim ka nala Ainu'u wanakunu makun, hi'i mi akim naili'il Ainu'u hini'i wenewhe man kukul Makromod Lalap Nin ke'eke'el an'anha. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Ri na'akeme ma akin naili'il Maya'u, hi onne hi'i tanada ri kan dodo'onnala makun naise Ya'u hihi'i haenhi. Memen hir hi'i tanada man lo'o narehiyedi man Ya'u hihi'i eni, ono Ya'u laa min wewerre noro Ainu'u Papa. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Enla inhawe man mi mapanak modi Ya'u naran, Ya ala ki mi, leke ri na'uli nasa'a Ainu'u Pape ono do'on rauroin nahenia Ya'u dernedi minim lir napanak me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ende inhawe man mapanak modi Ya'u naran, Ya ala ki mi!” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesus na'aheni, “Inhoi naramyaka Ya'u, ai onne man derne nakani Ainu'u keneri hono'ok. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Enine Ya apanak Ainu'u Pape de nala Man Paku nahinerre Maya'u, la Man Paku onne norle'ule'u norwaliwali mi laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Man Paku onne namwali Makromod Lalap Nin Roh man kukunohi mi panaeku ma namlolo wake'e ma na'ono Makromod Lalap. Noho eni wawan kan kokala Ai ono hi kar do'on la ka rauroin Ai, maa mi mauroin Ai, ono ors eni An min wewerre noro mi la lere man mai moro Ai mamwali mahaku. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ya'u laa, maa Ka'u hoikaru mi naise tatana ana'a re'e. Lere man mai Ya'u wali wali'ur mai ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taran ikar noho wawan eniyeni kar do'on Maya'u me'e, maa mi mehe man do'on Ya'u wali'ur. Lere onne Ya'u mori wali'ur, de lere onne mim lernala morimori ma namlolo haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Rakan lere Ya'u mori wali'ur mene mi mauroin nahenia Yo oro Ainu'u Pape mamwali mahaku, la Yo oro mi mamwali mahaku haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inhoi man derne Ainu'u keneri hono'ok, la hi'i lernohie, ai penia ma naramyaka Maya'u. Enla Ainu'u Pape naramyaka ai onne, la Ya aramyaka ai haenhi, la Ya alahari Ya'u kemen ai leke nauroin Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kame'ede Yudas (ri namehin nano Yudas Iskariot) na'aheni, “Yesus, hi'ihepenia Makrom'u nalhari kemen mayai mehe, la ri mormori noho wawan kae?” ");
INSERT INTO kjeNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Enine Yesus walhe, “Inhoi naramyaka Ya'u, ai onne hi'i lernohi Ainu'u wanakuku, la Ainu'u Pape naramyaka ai haenhi. Yo oro Ainu'u Pape manoin ai leke min wewerre noro Mayai. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Inhoi ma ka naramyaka Maya'u, ai onne kan hi'i lernohi Ainu'u wanakuku. Enla wanakuku man mim dederne eni, Ainu'u ka, maa mai nano Ainu'u Papa man hopon Ya'u mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ha eni na'akeme Ya'u konohiyedi mi me'e lere ka'alonlono makun eni, ");
INSERT INTO kjeNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","maa ka nalo'olo Ya'u wali wali'ur laa Ainu'u Pape. Ler onne Ainu'u Pape nala Roh Kudus mai namwali Man Paku. Roh Kudus onne wakuku mi ha wo'ire na'akeme, la na'ori honorok mi inhawe man Ya'u wakukuwedi me'eni, ono Ainu'u Papa hopon An mai nahinerre Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na'amolia Ya'u hi'i mi akim namkene la namlina namkai naise Ya akin haenhi. Ya ala aki ma namlina namkai eni ki mi, ka naise noho wawan nina, ono noho wawan nina ka namkene. Ende yon ma'irhu la yon mamkauk haida-haida. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mim derne Ya a'aheniyedi me'e na'ahenia, ‘Ya ala'a me'e, maa Ya'u wali wali'ur mai ki mi.’ Lo'o mi maramyaka Ya'u kokkoo, wa'an rehi mi akim nahuwa'an hurinohi Ya ala'a Ainu'u Pape ono Ainu'u Pape kulu narehi lapa narehi Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ha man Ya'u konohinohi mi eniyenihe ka namwali makun, maa Ya'u konohi mi leke lere mim do'on ha eniyeni namwali mi akim naili'il Maya'u kokkoo! ");
INSERT INTO kjeNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Leken kame'el Ya'u wakunu noro mi, ono Hayakyak Makromon ma nodi molollo noho wawan eniyeni na'akeki mai me'e. Ai ka nodi molollo Maya'u, ");
INSERT INTO kjeNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","maa ha eniyeni na'akeme namwali leke ri mormori noho wawan rauroin nahenia Ya aramyaka Ainu'u Papa la Ya'u hi'i ha wo'ira na'akeme man Ainu'u Papa hopon Ya'u hi'i. Mai kamharedi onno eni kala'a here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus nala wanakunu naho'ok na'ahenia, “Ya'u eni anggur ono ma namlole la Ainu'u Pape penia ma nadiyaka anggur kirna onneni. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mi eniyenihe mamwali Ya'u hanan, la hanan ma kan woi Ainu'u Papa sopoledi, la hanan man woi, Ai na'amou leke eren wowoi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Enla mi eniyenihe mim mouwedi me'e, ono Ainu'u wanakunu man Ya ala ki mi na'amouwedi mi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yono mi mako'u nano Maya'u, la Ya'u ka ako'u mi haenhi. Lo'o auhana ida pakiyedi nano anggur onno, auhana onne kan woi me'e, maa auhana man minle anggur onno onne penia man woi eni. Namnenehe naise onne lo'o mi mako'uwedi Maya'u, minim hini'i wenewhe man wa'an kaale lolo Makromod Lalap kalarna, maa lo'o mamkene min noro Maya'u, minim hini'i wenewhe man wa'an aile, de maise au hanan man woi ma'aruru. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ende Ya'u eni aise anggur onno la mi maise anggur hanan, de inhoi ma namkene minwuku noro Maya'u, la Ya amkene minwuku noro ai haenhi, ai onne hi'i ha man ma'aruru naise anggur hanan ma woin parinu. Lo'o mi kam minwuku noro Maya'u, mi kam hi'i haida man wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inhoi ka namkene minwuku noro Ya'u, ai onne naise au hanan ma kan woi, de kekiyedi nano onno, na'amoli loiwuku, napro'uk mene harne. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lo'o mi mamkene minwuku noro Maya'u, la mim horhorok Ainu'u wanakunu man Ya'u wakukuwedi ki mi me'eni, inhawe man mi mapanak nano Ainu'u Pape Ai nala. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi maise au hanan man woi nammori onne, de lere ri mormori do'on minim morimori man ma'aruru, hi ra'uli rasa'a Ainu'u Papa, la minim morimori man wa'an naise onne nodi kunukunohi nahenia namlolo kokkoo mi mamwaliyedi ri man lernohi Maya'u me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ainu'u Papa naramyaka Ya'u, la Ainu'u raramyaka ki mi naise Ainu'u Papa haenhi, de wa'an rehi mi mamkene lolo Ainu'u raramyake mamani haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lo'o mim hi'i wewhe Ainu'u keneri hono'ok, mi mamkene lolo Ainu'u raramyaka, naise Ya'u hi'i wewhedi Ainu'u Papa Nin keneri hono'ok la Ya amkene lolo Ainina raramyaka haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ya'u konohi mi panaeku eni na'akeme leke mi akim nahuwa'an wake'e naisa Ya akin nahuwa'an wake'e haenhi, penia minim soksok murmura penpenu kemkemen. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ainu'u keneri hono'ok heheni: Mi ida ma naramyaka ida naise Ya aramyaka mi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Inhoi ma ne'enohi nala kemen maki herre walin leke yon walin maki, ainin raramyaka walin onne narehi nalewen na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lo'o mim hi'i wewhe Ainu'u keneri hono'ok eni, mi mamwaliyedi I walin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ka apolu mi hophopon me'e ono ri ma namwaliyedi hophopon onne ka nauroin makromon nin panaeku ida me'e, maa Ya apolu mi I wal'uhe, ono Ya'u konohiyedi mi me'e panaeku na'akeme man Ya'u derne nano Ainu'u Pape. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mi kam nili Ya'u, maa Ya'u nili mi, la Ya'u penia hopon mi lam hi'i hini'i wenewhe ma nodi ihin ennen man ma'aruru, naise auhana man meur de woiwoi mamani. Lo'o mim hi'i heheni, inhawe man mi mapanak modi Ya'u naran, Ainu'u Papa nala ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ende Ya ala ki mi keneri hono'ok eniyeni: Mi ida ma naramyaka ida.” ");
INSERT INTO kjeNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Lo'o noho wawan kar suk mi, yon hamlinu nahenia nonolu eni noho wawan kar suk Ya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lo'o mi eni mamwali noho nin ri, namlolo kokkoo noho wawan naramyaka mi. Enimaa Maya'u penia nili mi nano noho eni leke mi mamwali Ainu'u ri aimehi, la ka mamwali noho wawan nine, de noho wawan akin apinha ki mi mamani. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Horhorok inhawe man Ya'u konohiyedi mi me'e, ‘Ma namwali hophopon ka narehi nalewen makromon.’ Ende lo'o rin hi'i apinpinhedi Ya'u mai noho eni wawan me'e, onne nin panaeku namlolo kokkoo hir hi'i apinpinha mi haenhi. Lo'o hir kokala Ainu'u wanakunu, onne nin panaeku hi lo'o kokala minim wanakunu haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hir hi'i apinpinha mi ono mim lernohi Ya'u ma namwali Makromod Lalap Anan. Hir hi'i heheni mi ono ka rauroin Ai man hopon Ya'u mai noho wawan eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Lo'o Ka'u mai konohi Makromod Lalap Nina panaeku, Makromod Lalap ka nala sala hi, maa Ya'u mai noho wawan konohiyedi Makromod Lalap Nin panaeku hi me'e, maa ramhene kokale, de namlolo kokkoo hir sala. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inhoi namhene kokala Ya'u, namhene kokala Ainu'u Pape haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lo'o Ya'u ka'u hi'i tanada man ri kan dodo'onnale makun lolo hi kalarna eni, Makromod Lalap ka nala sala hi. Hir sala wake'e, ono do'onedi Ainu'u hini'i wenewhe nammori onne me'e, maa ramhene kokala Yo oro Ainu'u Pape. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Onne na'akeme namwali leke na'akuku na'anokor inhawe man horhorok aile hirira Horok Lape ma na'aheni, ‘Ka'u hi'i salida hi, Ya'u hi'i ha man wa'an mamani, maa hi ramhene kokala Maya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lere man mai, Man Paku mi mai nano Makromod Lalap, la An konohi mi ha ma na'ono Maya'u. Ai onne namwali Roh Kudus, la Ya'u hopon An mai nano Makromod Lalap leke paku mi. An konohi mi panaeku ma namlolo wake'e, la An konohi mi ha ma na'ono Maya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Enla mi lam konohi ri ha ma na'ono Maya'u haenhi, ono nano lere dedesne Ya'u mai noho wawan, mi moro Ya'u ma'alono mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ya'u konohi ha eniyeni na'akeme ki mi leke yono mim lari nano minim aki ma naili'il Maya'u eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka nalo'ol lo'o ri nohiyedi mi nano Yahudi rir kerei, la lere man mai ri ma nesne mi onnenihe pene'ek rir hini'i wenewhe onne ilitolle Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hir hi'i heheni ono ka rauroin Ainu'u Pape, la ka rauroin Ya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Enimaa Ya'u wakunu na'ono apinpinha wo'operperi ma na'ikeki mai onne, leke lere ha onne na'akeme namwali, mi ka mamka'uk ono Ya'u konohiyedi mi me'e.” “Lere nonolu Ya'u ka'u konohi ha onneni ki mi ono Yo or'oro mi makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Enimaa ors eni na'akeki Ya'u wali laa Ainu'u Pape man hopon Ya'u mai noho wawan, la nano mi na'akeme ri mahaku ka na'ukani Ya'u na'ahenia, ‘Mala'a ewi?’ ");
INSERT INTO kjeNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mi ka ma'ukani haida, maa mi akim woir rehi ono Ya'u konohiyedi mi Ya ala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Enimaa Ya'u konohi mi ha ma namlolo kokkoo: Wa'an rehi Ya ala'a here, leke namwali ha man wa'an ki mi, ono lo'o ka ala'a, Roh Kudus kan mai paku mi. Maa lo'o Ya ala'a, Ya'u hopon Roh Kudus mai ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Enla lere Roh Kudus mai An kukunohi noho wawan eniyeni inhawe ma namlolo noro inhawe man sala, leke hi rauroin hir sala ono hir hi'i dohohala, la hi rauroin inhawe ma namlolo lolo Makromod Lalap kalarna, noro inhawe ma namwali lere Makromod Lalap ho'ok kail ri mormori noho wawan na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","An konohi nahenia ri mormori hi'iyedi dohohala me'e ono hi akin ka naili'il Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Enla An wakunu nahenia Ainu'u hini'i wenewhe namlolo kokkoo lolo Makromod Lalap kalarna. Enla rin do'on nahenia onne namlolo ono Ya ala'a leke min wewerre noro Ainu'u Papa, la lere onne mi kam do'on Ya'u me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Enla An kukunohi nahenia lere man mai Makromod Lalap ho'ok kail noho wawan eni, ono naledi hunukum Hayakyak Makromon ma nodi molollo noho eni wawan. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ainu'u panaeku nammori aile man Ka'u wakunu ki mi makun, ono ors eni mi honorok akin ka naruri kokale, maa kan hi'i haida. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Roh Kudus mai mene An kukunohi mi leke mauroin panaeku ma namlolo na'akeme. Ai ka nodi Nin panaeku aimehi wakuku mi, maa An wakuku inhawe An dederne nano Makromod Lalap la kukunohi mi inhawe ma namwali lere man mai. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ai na'akulu na'alap Maya'u haenhi, ono An konohi mi Ainu'u wanakunu na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ha wo'ire na'akeme Ainu'u Pape Nina, namwali Ainu'u haenhi. Onne penia Ya aheni inhawe man Roh Kudus konohi mi onne An kokale nano Maya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ka nalo'ol mi kam do'on Ya'u me'e, maa ka nalo'ol nano lere onne, mim do'on Ya'u wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesus wakunu horu ne, Nina man lernohi pakunohi ida ma ne'el ida na'ahenia, “Hi'ihipenia Ai na'aheni, ‘Ka nalo'ol kam do'on Ya'u me'e la ka nalo'ol nano lere onne do'on Ya'u wali'ur?’ La hi'ihepenia Ai na'aheni wali'ur, ‘Onne namlolo ono Ya ala'a Ainu'u Pape.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Man lernohi pakunohi ida ma na'ukani ida mamani na'ahenia, “Nin wanakunu, ‘Ka nalo'ol me'e onne,’ ra'ahewie? Ai ka mauroin Ainin panaeku inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus nauroin nahenia hi raram nodi ra'ukani Ainin wanakunu idedi onne nin panaeku inhawe, de Ai na'aheni, “Idedi Ya aheni, ‘Ka nalo'ol lo'o kam do'on Ya'u me'e, maa ka nalo'ol nano lere onne mim do'onedi Ya'u wali'ur.’ Mi lo'o ka mauroin panaeku onne makun? ");
INSERT INTO kjeNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Loi honorok wawa'an Ainu'u panaeku ma na'ono eniyeni: Lere Ya ala'edi, mi akim sus wake'e la mi mahere, maa ri mormori noho wawan soksok murmura mamani. Lere onne lo'o mim sus rehi, maa mi akim man sus onne herre wali'ur namwali akin ma nahuwa'an wake'e! ");
INSERT INTO kjeNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ik kala wanakunu naho'ok nano maeke ma na'ikeki moriyana me'e. Ai kemen apinha wake'e de nahere wakaukau, maa moriyedi anan ne, an hamlinuwedi nin apinhe me'e, la ai akin nahuwa'an wake'e ono moriyedi anan me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onne naise mi haenhi, ono ors eni mi akim sus rehi, maa lere Ya'u pakromo noro mi wali'ur, mi akim nahuwa'an wake'e, la ri mahaku ka naruri nahoro minim soksok murmure man aile mi akim me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Rakan lere onne mi ka ma'ukani Ya'u haida me'e. Horhorok Ainu'u nou ma na'ono eniyeni: Inhawe man mi mapanak nano Ainu'u Papa modi Ya'u naran, Ai nala ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nano nonolu rakan ors eni mi ka modi Ya'u naran mapanak haida nano Ainu'u Pape, maa ors eni mapanak here, la Ai nala ki mi leke mi akim penpenu kemkeme la nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ya'u konohiyedi mi ha eniyenihe na'akeme nair wanakunu naho'ok, maa ka nalo'ol Ka'u wakunu heheni me'e. Lere onne Yo odi wanakunu man mouropo konohi mi ha ma na'ono Ainu'u Pape. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Rakan lere onne mi mehe modi Ya'u naran mapanak nano Ainu'u Papa. Lo'o Ka odi minim napanak laa Ainu'u Pape, kan hi'i haida, ");
INSERT INTO kjeNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ono Ainu'u Pape naramyaka rehi mi. Ai naramyaka mi ono mi maramyaka Ya'u, la mi akim naili'il Ya'u de mauroin nahenia Ya'u eni mai nano Ai. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya'u mai nano Ainu'u Papa leke minle noho wawan eniyeni, maa ors eni Ya amhara noho wawan wali laa Ainu'u Pape.” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kame'ede man lernohi pakunohi enihe re'el Yesus, “Ma'aruru! Ors eni Papa wakunu ka nodi wanakunu naho'ok me'e, maa wakunu mouropo idewe! ");
INSERT INTO kjeNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ai mauroin nahenia Papa nauroin ha wo'ira na'akeme, de lo'o ai ka ma'ukani haida makun, Papa nauroinedi ainim na'ukankani na'akeme. Onne nodi kunukunohi mayai nahenia namlolo kokkoo Papa mai nano Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus walha na'ahenia, “Ende ors eni mauroin nahenia mi akim naili'iledi wawa'an me'e? ");
INSERT INTO kjeNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Horhorok! Lere man mai mi dohodoho lari wali wali'ur laa minim nakar, maa Ka'u memehedi ono Ainu'u Pape norle'ule'u norwaliwali Ya'u mamani, la namlolo kokkoo lere onne rakanedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ya'u konohi eni na'akeme ki mi leke mi akim namkene la namlina namkai mamani. Memen lolo noho wawan eniyeni, mim lernala apinpinha wo'operperi mamani, maa ma'alapa mi akim la yon mamka'uk, ono Ya'u rehiyedi noho wawan nina molollo me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus konohi ha wo'ire na'akeme onne horu, An niliha'a laa wawan la hi'i lir napanak na'aheni, “Pape, lere alam man Pape ninili rakanedi me'e! Ya apanak Pape ma'akulu ma'alapa Ya'u, Papa Anan, lolo ri mormori kalarna, leke Ya'u, Papa Anan, a'akulu a'alapa Papa haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pape kikanedi Ya'u leke odi molollo ri mormori noho eni wawan, leke Ya ala or'ori dardari ma kan horu hi man Pape naledi Maya'u me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Or'ori dardari man ma'aruru ma kan horu nin panaeku heheni: Ri man lernala or'ori dardari ma kan horu rauroin kokkoo Makromod Lalap ma namlolo wake'e, la Ai onne ida mehe, namehin kaale. Enla hi rauroin Ya'u eni, Yesus Kristus man Makromod Lalap hopon mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pape, Ya a'akulu a'alapedi Pape lolo noho eni wawan ono Ya'u hi'i na'ahoruwedi honowok man Pape hopon Ya'u hihi'i eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Enla Ya apanak Pape ma'akulu ma'alap Maya'u lolo Papa leken kalarna, leke Ik min lolo siksika lerlere raram wali'ur naise nonolu lere noho wawan ka namwali makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Pape naledi Num ri man minle noho wawan eniyeni Maya'u, la Ya'u konohiyedi hi panaeku ma na'ono Papa. Kokkoo, hi ramwali Num ri nano nonolu, la Papa nala hi Maya'u, la hir derne rakaniyedi Pape Lirna Wawan me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ors eni hi rauroinedi nahenia ha wo'ira na'akeme man Papa nala Maya'u, namlolo kokkoo mai nano Papa, ");
INSERT INTO kjeNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ono Ya ala hi wanakunu na'akeme man Papa nala Maya'u. Hir kokala wawa'an Ainu'u wanakunu onne, la rauroinedi kokkoo nahenia Ya ano Ainu'u Pape, la hi akin naili'il Ya'u de rauroinedi Pape man hopon Ya'u mai noho eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pape, Ya'u hi'i lir napanak hi mehe. Ya'u ka'u hi'i lir napanak noho eni na'akeme, maa Ya'u hi'i lir napanak mehe ri man Pape nanala Maya'u enihe, ono hi onne penia Pape Nina ri. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ainu'u ri na'akeme ramwali Papa Nin ri haenhi, la Papa Nin ri ramwali Ainu'u haenhi, la nano hi Ya'u lernala ul'uli sasa'a man lap narehi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ors eni Ya'u mai Pape, de Ka'u minle noho wawan me'e, maa hi aile noho wawan makun. Pape Man Moumou Dewdewe, Ya apanak Papa modi Papa Nin molollo man mamalle Maya'u nadiyaka hi wawa'an, leke hi ramwali mahaku, naise Yo oro Pape mahaku haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ler Yo or'oro hi makun, Yo odi Papa Nin ke'eke'el an'anhe man Papa nala Maya'u leke adiyaka hi wawa'an, la nano hi ri mahaku kan molu, naukara ai man rakineriyedi nano nonolu me'e. Ai onne moluwedi me'e, leke na'akuku na'anokor horhorok man aile Horok Lape raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ors eni Ya'u mai Pape, maa Ya'u wakunu ha eniyeni mene Ya amhara noho wawan eni, leke Ainu'u soksok murmura aile hi akin, de hi akin nahuwa'an wake'e naise Maya'u. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ya'u loikaruwedi Pape Lirna Wawa'an hi me'e, la noho wawan kar suk hi ono hi ka ramwali noho nine ri me'e, naise ka amwali noho nine ri haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka apanak Pape naledi hi nano noho eni wawan, maa Ya apanak Pape nadiyaka hi wawa'an leke yon Hayakyak Makromon man ailanne onne nano'onyak hi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hi ka ramwali noho eni nine, naise Ya'u ka amwali noho nine haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ya apanak Papa nodi Lirna Wawan ma namlolo wake'e hi'i hi ramwali Pap Nin ri mememen man moumou dewdewe. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pape hopon Ya'u mai noho wawan, de namnenehe Ya'u hopon hi laa ri mormori noho wawan haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ya ala I kem'u Papa, la lernohi Pape Nina honorok aki mehe, leke hi onne ramwali Pape Nin ri mememen man lernohi O mamani, ono hi akin naili'il Pape Lirna Wawan ma namlolo eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pape, Ya'u hi'i lir napanak hi, maa onne kan mehe, Ya'u hi'i lir napanak ri na'akeme ma akin naili'il Maya'u, la man dernedi Ainu'u man lernohi pakunohi enihe rir wanakunu ma na'ono Maya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ya apanak Pape hi'i hi ramwali mahaku naise Yo oro Papa mamwali mahaku haenhi. Ya apanak hi roro Maika kamwali mahaku haenhi, leke noho wawan na'akeme rauroin nahenia Pape hopon Ya'u mai noho wawan. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ya a'akulu a'alap hi, naise Papa na'akulu na'alapedi Maya'u, leke hi ramwali mahaku naise Maika haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yo oro hi mamwali mahaku, la Yo oro Pape mahaku haenhi, leke namlolo kokkoo hi ramwali mahaku, de noho wawan eniyeni do'on rauroin nahenia Pape man hopon Ya'u mai, la Pape naramyak hi naise naramyaka Ya'u haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pape, Ya apanak leke ri man Pape nala Maya'u enihe, hir laa Ainu'u onno min wewerre noro Maya'u, leke hir do'on Ainu'u siksika lerlere man Pape mehe nala Maya'u, ono Papa penia ma naramyak Maya'u nano lere noho eni ka namwali makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Papa penia molololo onno! Kade noho wawan eniyeni ka rauroin Pape, maa Ya auroiroin Papa, la Ainu'u man lernohi pakunohi enihe rauroiroin nahenia Pape hopon Ya'u mai. ");
INSERT INTO kjeNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ya'u loikaruwedi hi panaeku ma na'ono Pape me'e, la Ka'u ren hi'i onne, leke Papa Nin raramyaka Maya'u min hi raram, la Ya'u min hi raram haenhi, ono Yo oro hi mamwaliyedi mahaku me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus hi'i lir napanak horu, Ai noro Nina man lernohi pakunohi enihe deul oir wauwau Kidron. Lolo enne kirnida aile man penpenu noro au'ono zaitun. Enime'ede Yesus noro Nina man lernohi pakunohi enihe rala'a kirne onne raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas ma na'olu Yesus onne nauroiroin kirna onne haenhi, ono Yesus noro Nina man lernohi pakunohi enihe radedem lawuku lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ende imam-imam lalap roro ri Parisi enihe rapanak Roma rira ma nasala ke'urauk enihe muku ida noro idewe ma nadiayake rir Romleu Lap lar kele Yesus, la Yudas ma norkaru hi laa kirna onne. Hi na'akeme rodi ilak raa, obor, noro wadu. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus nauroinedi ha wo'ire ma namwali Ai kemen, de lan pakromo noro hi la na'ukani, “Mi manoin inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hi ra'aheni, “Ai manoin Yesus ri Nazaret onne.” Yesus walhe, “Ya'u eni Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesus wakunu heheni, idewe hi na'akeme so'o kilili'ur rala wali yawa. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kame'ede Ai na'ukani wali'ur, “Mi manoin inhoi?” Hir walhe, “Ai manoin Yesus ri Nazaret onne.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus na'aheni wali'ur, “Ya a'aheniyedi Ya'u eni Ai. Lo'o namlolo kokkoo manoin Ya'u, hurinohi Ainu'u man lernohi pakunohi enihe rala'a here.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Onne namwali leke na'akuku na'anokor Yesus Nin wanakunu ma na'ahenia, “Ya adiyaka wawa'an ri na'akeme man O mala Maya'u, leke yon mahaku molu.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kame'ede Simon Petrus nasalsala nina raa de nodi dare imam man kulu narehi nin hophopon ida me'ede kilinna wali malanna nadiyauredi. (Hophopon onne naran Malkus.) ");
INSERT INTO kjeNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus ne'el Petrus, “Heih! Kowosedi numa rae! Lo'o ka mauroin nahenia Ye e'enohiyedi me'e kokala apinpinha wo'operperi man Ainu'u Pape naledi Maya'u me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kame'ede Roma nina ma nasala ke'urauk enihe roro rira uluwakun noro idewe ri Yahudi ma nadiyaka Romleu Lape onnenihe, hir kele Yesus wukue. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hi rodi Yesus laa Hanas, ono Hanas onne Kayapas panin, la anna onne Kayapas namwali imam man kulu narehi. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas onne nonolu konohi Yahudi rir man panulu enihe nahenia wa'an rehi ri ida maki herre ri nammori. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus noro Yesus Nina man lernohi pakunohi ida lernohi Yesus lolo kili'urn. Lere onne imam man kulu narehi nauroinedi man lernohi pakunohi ida onne, de ainin ri hurinohi ai lernohi Yesus laa nin nikoin. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Enimaa hi ka rauroin Simon Petrus, de an minedi paharne na'urani takin nin nika makan, hehen nanumene man lernohi pakunohi namehin onne lan napanak maeke ma nadiyaka nike, de hurinohi Petrus maiyedi raram haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kame'ede maeke onne ne'el Petrus na'ahenia, “Heih! O eni Yesus Nina man lernohi pakunohi haenhi?” Petrus na'aheni, “Ka! Ya'u ka!” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A'alam onne noho rinna de ma nadiyaka enihe roro man howok lolo onne, hir hunuku aiye de ramririnu. Enla Petrus mai namrinu aiye wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Enine imam man kulu narehi na'ukani Yesus, “Inhoi namwali O Num man lernohi pakunohi enihe? Om wakuku inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ende Yesus walhe, “Ka'u suwarala Ainu'u wanakuku, maa nadedem Ya'u wakuku mouropo lolo heri kalarna ma nadedem lawuku lolo Yahudi rir kerei-kerei noro Makromod Lalap Nin Romleu Lap. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Alhi'ihepe ma'ukani Ya'u heheni? Wa'an rehi ma'ukani ri man derne Ainu'u wanakuku onne. Hi rauroinedi inhawa ma nadedem Ya'u wakukue.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus wakunu heheni horu, ma nadiyaka ida pahar Yesus oin makan la ne'el na'ahenia, “Alhi'ihepe Om wakunu heheni imam man kulu narehi eni!” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus walha, “Lo'o Ainu'u wanakunu eni saledi, kene kukul inhawe man sale, maa lo'o Ainu'u wanakunu eni namlolo, hi'ihepenia om pahar Ya'ue?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kame'ede Hanas hopon rodi Yesus laa Kayapas ma namwali imam man kulu narehi, la Ai liman nawinuknuku makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petrus mahan namrinu aiye makun, ri ne'el ai na'ahenia, “Yonde o eni Yesus Nina man lernohi pakunohi harome?” Maa Petrus na'aheni, “Ka! Ya'u ka!” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Enine imam man kulu narehi onne nin hophopon ida mai ne'el Petrus na'ahenia, “Idedi ya'u do'odo'on o moro Ai wewerre lolo kirna onne!” Hophopon onne walin penia man Petrus dara kilinneni. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus na'aheni, “Maya'u ka!” Idewe manu kokoroiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rakan oreki noho roropo ne, Yahudi enihe rodi Yesus nano Kayafas nin nakar laa gubernur Roma nina nakar. Lere onne Yahudi enihe ramhene laa gubernur nina nakar raram ono ai ka namwali ri Yahudi, de hi ramka'uk ha man luli aile lolo onne lo'o ra'amorso kemen. Rira agame nina holoor halauk hopon ri yon na'urani ri ma ka namwali Yahudi, kalo'o kar lernohi ya'an yomun Lere Alam Lalap Paska. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ende Pilatus laa paharne na'ukani ri Yahudi enihe na'ahenia, “Ri eni hi'i inhawe man sala, penia mim tumdesne Ai?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hi ra'aheni, “Lo'o Ai kan sala, alhi'ihepe ai modi mai pape?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Enime'ede Pilatus na'aheni, “Mim mehe male leke moro laa kekrohu Nina sale lernohi minim agame nina keneri hono'ok.” Enimaa hi ra'aheni, “Ainima molollo kaale hukumesne Ri eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Onne namwali leke na'akuku na'anokor Yesus Nin wanakunu nonolu onne ma na'ono Nin makimaki. ");
INSERT INTO kjeNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kame'ede Pilatus wali laa raram, mene napolu Yesus mai na'ukanie, “Hi'ihewi? O eni Yahudi rira Raie?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus na'aheni, “Papa na'ukani heheni nodi nin panaeku mehe, ee ri namehin rir panaeku?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus walhe, “Ka amwali ri Yahudi! Onum ri mememen noro num imam lalap enihe penia rodi O mai maya'u! Om hi'i inhawe penia rodi o maie?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus na'aheni, “Ya amwali rai, maa ka odi molollo lolo noho eni wawan. Lo'o Ya amwali rai ma nodi molollo lolo noho wawan eniyeni, Ainu'u hophopon enihe hi'i ara leke yon ri Yahudi enihe kele Maya'u, maa Ainu'u molollo kan mai nano noho eniyeni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Enine Pilatus na'ukani wali'ur, “Ende O mamwali Raie?” Yesus ne'el ai na'ahenia, “Pap mehe na'aheniyedi me'e Maya'u eni Rai. Onuma wanakunu namlolo. Mori Ya'u mai noho wawan amwali Rai leke kukunohi ri noho wawan eniyeni panaeku ma namlolo kokkoo lolo Makromod Lalap kalarna. Inhoi raram nodi derne panaeku ma namlolo, hi onne derne rakani Ainu'u wanakuku.” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus na'ukani, “Ik ri mormori mehe, de hi'ihehewi leke kauroin kokkoo inhawe ma namlolo enie?” Kame'ede Pilatus mai paharne ne'el Yahudi enihe na'ahenia, “Ya'u po'on ri eni nina sale kaale, ");
INSERT INTO kjeNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","maa nadedem rakan Lere Alam Lalap Paska mi mapanak ya'u huri ri ida namhara nano bui raram. Ende hi'ihehewi? Minim panaeku ya'u huri ‘Yahudi Nin Rai’ eniyeni ki mi, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ideweni na'akeme wakau ra'aheni, “Yono, yono huri Ai! Na'amoli huri Barabas! Barabas onne namwali ri ailanna ma nawa'u ri leke yon derne rakani Roma nina molollo.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatus noro Yahudi wakunu horu ne, an hopon ke'urauk enihe riuk rerhe Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Enine ke'urauk onnenihe nanau dupal rururi ida nanumene rala loile Yesus uluwakun. Onne horu hi rala rai nina nainair nanaru mere au'au ida Yesus nair. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eni nanumene hir mai Yesus kalarne mamani ra'aheni, “Hiyene arore ki O, Rai Yahudi O!” Horu ne, hir pahar kili'ur kalari oin makan. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Horu Pilatus laa paharne wali'ur na'aheni heri man minle paharn, “Po'onala! Na'amolia yo odi Ri eni mai ki mi leke mi mauroin kokkoo nahenia ka'u lernala Ri eni Nina sale!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kame'ede Yesus laa paharne nairedi dupal rururi la rainedi rain nanaru mere au'au nanumene Pilatus na'aheni, “Po'onala, ri onne mai me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Idewe imam-imam lalap roro ma nadiyaka Romleu Lapa enihe po'onedi Yesus ne, hir wakau, “Wairesne here! Wair lolo au kekiyowok here!” Enimaa Pilatus na'aheni, “Mai mala Ai here leke mi mehe modi laa wairesne ono ya'u ka'u do'on ri eni nin salida!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ri Yahudi enihe walhala Pilatus ra'aheni, “Lernohi ainim agame nin keneri hono'ok, kan wa'an ri na'aheni ai onne Makromod Lalap Anan. Keneri hono'ok ida aile man hopon resnedi ri onneni. Ende Ai onne sala wake'e ono na'aheni Makromod Lalap Anan Ai!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus derne hi ra'aheni heheni, idewe ai eren namkaka'uk me'e, ");
INSERT INTO kjeNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","de laa wali'ur raram na'ukani Yesus, “Kii O manina ewie?” Maa Yesus kan walhe. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus na'ukani wali'ur, “Alhi'ihepe O kam wakunu! Lo'o ka mauroin yo odi molollo huriyedi O, la yo odi molollo wairesne O haenhi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus na'aheni, “Lo'o Makromod Lalap ka nala molollo, onuma molollo kaale hi'i haida Ya'u kemen, de ri ma nala Ya'u kani ki o, hi onne rira dohohale nammori rehi ki o.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus derne Yesus na'aheni heheni ne, idewe ai nanoin kalla leke huri Yesus, maa Yahudi enihe wakaukau mamani, “Makrom'e, makrom'e, lo'o om huri Ri onneni, makrom'u ka noro Kaisar lawuku me'e. Ri man mehen kikan kemen namwali rai, ai onne penia Kaisar nin arwali!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus derne Yahudi ra'aheni heheni, an hopon Yesus laa paharne namriri lolo heri kalarna mene ai naikoro lolo hono'ok kanail nin kadere leke nala nin kenekrohu. Nin kadere rodi ho'ok kail onne aile lolo onno man wekel ‘Onno Rodi Waku Hi'ie’, la lolo wanakunu Ibrani wekel ‘Gabata’. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lere onne na'ikeki riuk idaweli woro'o lere u'ulu me'e, la ri maha ra'akene hanana'an ono oreki Lere Alam Lalap Paska. Enine Pilatus ne'el Yahudi enihe na'ahenia, “Ai eni penia minim Rai.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Enimaa hir wakau ra'aheni, “Mesnediye! Mesnediye! Rodi laa wairesnedie lolo au kekiyowoke here!” Enine Pilatus wakunu wali'ur, “Mi mapanak ya'u wairesne minim Raie?” Enimaa imam lalap enihe ra'aheni, “Ainima rai Kaisar mehe, namehin ka!” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kame'ede Pilatus nala Yesus kanile hi leke rodi laa roho wair lolo au kekiyowok. Ende ke'urauk onnenihe rala Yesus nano Pilatus rodi rala'a me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus mehe na'uwara Nina au kekiyowok, la hi rala'a laa onno ma nadedem wekel ‘Onno Ma Naisa Uluwaku Rurna’ la lolo wanakunu Ibrani ra'ahenia ‘Golgota’. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hir rakan Golgota mene hir wairesne Yesus noro ri woro'o haenhi, Yesus minle toro la woro'o onnenihe ida min mariri la ida min malanna. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus hopon horok lolo papan deulana ida wanakunu ma nahenia: Yesus Ma Nano Nazaret, Yahudi Rir Rai. Horu ne, roho papan onne uluwakun wawan lolo Nina au kekiyowok eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ri Yahudi nammori lese honorokana onne ono hir wair Yesus lolo onno ma kan ko'u nano kote, la hir horok rodi wanakunu Ibrani, Latin noro Yunani. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Enime'ede imam lalap enihe re'el Pilatus na'ahenia, “Yom horok heheni, maa wa'an rehi horok na'aheni, ‘Ri eni na'aheni Ai namwali Yahudi Rir Rai.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Enimaa Pilatus na'ahenia, “Yono rin herre inhawe man ya'u hohorok eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma nasala ke'urauk onnenihe wair Yesus horu ne, hi rala Nina nainair de hir ha'ar namwali wo'akka leke dohodoho lernala, maa kar ha'ar Nina rain nanaru ono ramhene sirriki. Rain nanaru onne ma'aruru la na'alehe honourn, ono kenne me'ede lisar mahaku mehe. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kame'ede ke'urauk onne ida ma ne'el ida, “Yono ik sirriki rain nanaru eni. Mai ik hi'i undi leke kauroin inhoi man lernale.” Onne na'akeme namwali leke na'akuku na'anokor horhorok man aile Horok Lap raram ma na'ahenia, “Na'amoli hir ha'ar Ainu'u nainair la hir hi'i undi leke rauroin inhoi lernala Ainu'u rain.” Ende ke'urauk onnenihe rodi Yesus Nin rain nanaru onne hi'i undi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Enine Yesus inna, intono, Maria ma namwali Klopas hono, noro Maria Magdalena, hi ramriri ra'urani Yesus Nin au kekiyowok. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus do'on Nina mama noro Nin man lernohi pakunohi man Ai nararamyaka onne ramririri wewerre aile lolo onne, la Ai ne'el woro'ohe na'ahenia, “Mame, ai onne o anum.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kame'ede Yesus ne'el man lernohi pakunohi onne eni, “Pa'e, ai onne onum mame!” Nano lere onne me'ede, man lernohi pakunohi onne napanak Yesus ine min nin nakar. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Onne horu, Yesus nauroin nahenia An hi'i na'ahoruwedi honowok na'akeme man Makromod Lalap naledi Ai me'eni, la Ainin panaeku na'akuku na'anokor inhawe man aile Horok Lap raram, de Ai na'aheni, “Ya'u marouwedi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lolo onne anggur man ma'alinu aile de hi rala sawar ku'ule nanumene wukule au hisop rala soru Yesus nuran. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus kimis anggur man ma'alinu onne la na'aheni, “Ainu'u honowok horuwedi me'e!” Enine An kani hamaran laa Makromod Lalap horu, idewe wawuluwedi uluwakun la aran horuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lere onne ri Yahudi ra'akekene hanana'an ono oreki Alam Renren Warwarna, la Alam Renren Warwarna onne ma na'ono wake'e ono Lere Alam Paska. Ri Yahudi rir agame nahenia kan wa'an ri man maki lolo au kekiyowok nawinainair Alam Renren Warwarna, de Yahudi rir man panulu rapanak Pilatus leke hi'i yakiyedi ri ma nawinair onnenihe ein. Hir hi'i heheni leke pelek maki la rala kopuredi nano au kekiyowok mene rakan Lere Alam Paska onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ende ma nasala ke'urauk onnenihe laa hi'i yakiyedi ri woro'o onne ein nolu, ");
INSERT INTO kjeNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","maa rakan Yesus, hir po'on makiyedi me'e de kar hi'i yaki ein. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Enimaa ke'urauk ida nodi kere kadi Yesus herne, de idewe rare noro oir namhara. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Enla ai man mehen do'on ha ma namwali eniyenihe, ai penia man loikaru ki mi, la ai nauroin nahenia nin wanakunu namlolo kokkoo, ono ai mehe do'on ha onne namwali, de mi akim nala nin wanakunu, leke mi akim namkene naili'il Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ha onne na'akeme namwali leke na'akuku na'anokor horhorok man aile Horok Lap raram ma na'ahenia, “Nano Ai rurna na'akeme, mahaku kan paki.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Horhorok namehin lolo Horok Lape raram na'aheni, “Hir do'onedi Ai man hir kakadi kemen me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kame'ede Yusup manina Arimatea mai napanak Pilatus nala Yesus ihin kemen nodi laa ra'akene manaku lolo ku'il ma namwali lunne. Yusup eni man lernohi Yesus haenhi, maa ai kan konohi ri ono ai namka'uk Yahudi rir man panulu enihe. Enine Pilatus ne'enohi ainina napanak eni, de Yusup nala Yesus ihin kemen laa na'akene manaku. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus man mai pakromo Yesus a'alam nonolu onne noro Yusup ra'alono laa rala Yesus ihin kemen. Nikodemus nodi rampa warna-warna man werekne lo'o kilu welikelu. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ende woro'ohe rodi tapi lenan laa komon Yesus kemen noro rampa-rampa onne lernohi Yahudi rir noho honolla. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lere onne kirna ida aile lolo onne ma na'uranrani onno wawair Yesus eni, la lolo kirne raram onne ku'il woruworu ida aile man ri ka nala maki loile makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ende Yusup noro Nikodemus rodi Yesus kemen laa loile lolo ku'il ma na'uranrani onne ono na'akeki rakanedi Alam Renren Warwarna me'e, de maha ra'akene ha wo'ira leke yon howok lere onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domeku al'alam na'ulawlawak makun, Maria Magdalena nala'a ku'il onne, la an po'on waku lapa rodi el'elek ku'il makan onne napoiyedi laa herne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ende an lari laa nanoin Simon Petrus noro man lernohi pakunohi man Yesus nararamyake onne. Pakromedi ne, ai na'aheni, “Eih! Ri naledi Makromod ihin kemen me'e, ka auroin aile ewi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kame'ede Petrus noro man lernohi pakunohi onne laa tolle ku'il. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Woro'ohe larlari, maa man lernohi pakunohi namehin onne pelek rehi, de rakan noluwedi Petrus laa ku'il. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rakanedi ne, an nahirawa po'on laa ku'il raram, do'on tapi man rodi komon Yesus kemen mehe aile, maa kan laa raram makun. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kan maha ne, Simon Petrus rakanedi la idewe laa ku'il raram. An do'on mehe tapi man aile lolo onne haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","la an do'on tapi deul rodi wuwuku Yesus uluwakun, maa tapi deul onne nadlunlunna min aimehi. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kame'ede man lernohi pakunohi onne man rakan nolu laa raram haenhi, de do'on mouwedi ha onnenihe na'akeme mene akin naili'il nahenia Yesus mori wali'uredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Rakan lere onneni hi ka rauroin makun horhorok lolo Horok Lape raram ma na'ahenia, ‘Yesus maki maa mori wali'ur.’ ");
INSERT INTO kjeNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kame'ede woro'ohe wali laa rira nakar me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Enimaa Maria Magdalena namriri ku'il kalarna nahehere la nahirawa po'on laa ku'il raram. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Enine an do'on hophopon a'am raram woro'o man nair nainair wawarhe, la hi raikokoro aile Yesus Nin namkukuru lole, ida naikoro uluwakun wawan la ida naikoro ein ki'il. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ende hophopon a'am raram onnenihe ra'ukani Maria, “Ine, hi'ihepenia ine nahere!” Maria walha, “Ri naledi i Makrom'u ihin kemen me'e, la ka auroin loile ai ewi!” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria na'aheni heheni horu ne, an wali kili'ur do'on Yesus namriri aile kili'urne, maa ai ka nauroin onne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus na'ukani, “Ine, hi'ihepenia mahere? O manoin inhoi?” Maa Maria nauroin nahenia ri onne orkirne de na'aheni, “Pape, yono hi'i pape rei wali'uredi i Makrom'u ihin kemen nano mai eni me'e, Pape konohi ya'u leke laa ale.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kame'ede Yesus na'aheni, “Maria.” Idewe Maria po'onala Yesus la na'aheni, “Raboni,” napa'ahne, ‘Papa Meser’. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus walha na'ahenia, “Ine, yom roule Maya'u, ono Ya'u ka'u ha'a laa wawan laa Ainu'u Pape makun. Wali here, lam konohi I walin na'akeme ma'aheni na'ikeki Ya'u ha'a laa wawan laa Ainu'u Pape ma namwali minim Pape haenhi, laa I Makrom'u ma namwali mi Makrommu haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kame'ede Maria wali lan konohi Yesus Nin man lernohi pakunohi enihe na'ahenia, “Heih! Ya'u mehe odi mak'u do'onedi Makromod Yesus. An mori wali'uredi me'e!” Enla an konohi hi ha wo'ira na'akeme man Yesus konohiyedi ai me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lere onne Domeku, la na'ikeki lere helem me'e, Yesus Nina man lernohi pakunohi onnenihe minwuku aile nakar ida, la hir konkonso nike na'akeme ono ramka'uk Yahudi enihe. Ende ramlilinnohi Yesus namriri aile hi leken kalarna me'e, la na'aheni, “Yon mamka'uk! Ya ala aki ma namlina namkai ki mi na'ahoru!” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Horu ne, An kukul liman kawin noro herne ma namno'no'o hir do'on. Hir do'on rauroinedi Ai onne Makromod, de hi akin nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Enine Yesus na'aheni wali'ur, “Ya ala aki ma namlina namkai ki mi na'ahoru! Ya'u hopon mi lam hi'i Ainu'u panaeku lolo noho wawan, naise Ainu'u Pape hopon Ya'u mai noho wawan hi'i Ainin panaeku haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kame'ede An nou aran laa hi na'aheni, “Kokala Roh Kudus”. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Enla An hopon hi na'ahenia, “Lo'o mi mala ampun ri nin dohohala, onne nin panaeku Makromod Lalap naledi ampun rir dohohala haenhi. Lo'o mi ka mala ampun rir dohohala, onne nin panaeku Makromod Lalap ka nala ampun haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ler Yesus nalhari kemen onne, Tomas kaale. Tomas eni namwali man lernohi pakunohi ida nano ri idaweli woro'o enihe haenhi, la ri nadedem rapolu ai ‘Tatana Adodo'o’. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ende ai walin enihe ra'ahenia, “Am do'onedi Makromod me'e!” Maa Tomas na'aheni, “Lo'o ka'u do'on liman man hir roroho eni noro herne man kakadi eni, la lo'o ka'u roulle Nina no'o man aile liman noro herne, ya akin ka naili'il makun.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nakawedi domeku ida wali'ur, man lernohi pakunohi enihe lawuku nakar onne wali'ur, la Tomas aile haenhi. Kade nika na'akeme konsedi me'e, maa ramlilinnohi Yesus namriri aile hi tore la na'aheni, “Ya ala aki ma namlina namkai ki mi na'ahoru.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Enine, Yesus ne'el Tomas na'ahenia, “Tomas, mala o liman ra'an loile lolo eni, po'on Ya'u liman, la hapu dilhe man aile Ya'u herne eniyeni. Yon o akin ka namkene, maa naili'il Maya'u kokkoo!” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas na'aheni, “Makrom'u! O eni Ya'u Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus na'aheni, “O akin naili'il ono om do'onedi Ya'u me'e. Onne wa'an, maa ri ma akin naili'il Ya'u nolu mene do'on, ai onne akin nahuwa'an wake'e.” ");
INSERT INTO kjeNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus nodi Makromod Lalap Nina ke'eke'el an'anha hi'i tanada namehin nammori man ri kan dodo'onnale makun lolo Nin man lernohi pakunohi enihe kalarna, maa tanada onnenihe kar horok mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Enimaa ri man hi'i horok eniyeni, horok tanada eniyenihe leke mi akim naili'il Yesus, leke mi mauroin nahenia Makromod Lalap kikanedi Ai namwali Rai laa ewi-ewi, leke mi mauroin Ai onne Makromod Lalap Anan haenhi. Enla mi na'akeme ma akin naili'il Ai eni, mim lernala or'ori dardari ma kan horu. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nakawedi domeku ida woro'o wali'ur, Yesus nalhari kemen wali'ur laa Nin man lernohi pakunohi enihe lolo oir lap Tiberias nin herraram. Ende wanakunu lere Ai nalhari kemen onne hi'i heheni: ");
INSERT INTO kjeNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus, Tomas man rapolu Didimus (Tatana Adodo'o), Nataniel ma namhara nano leke Kana noho Galilea, Zebedeus ananhe, roro man lernohi pakunohi woro'o namehin, hir lawuku lolo herraram onne. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Enla Simon Petrus ne'el man lawuku onnenihe na'ahenia, “Ya'u laa paharne leke sopol diyala.” Enime'ede hi na'akeme ra'aheni, “Am lernohi haenhi.” Kame'ede hi na'akeme ha'a korkore laa paharne ranoin i'in me'e, maa alam kekeme onne rira diyale ka nalala i'in kem mahakue. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Noho na'ikeki roropeni, hir po'on Yesus namriri aile herraram, maa ka rahiyennala ma namririri onne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Enine Yesus wakau hi na'ahenia, “I wal'u mie, lernala i'in me'e, ee kaun?” Hir walhe, “Ai ka malalala i'in kem ida makun, Pape!” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesus na'aheni, “Sopol minim diyale lolo korkore herne malanne leke mim lernala i'in.” Kame'ede hir sopol diyala lolo korkore herne malanneni. Hir sopol ne, kar hedunale ono naledi i'in nammori me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesus Nin man lernohi pakunohi man Ai nararamyaka onne ne'el Petrus na'ahenia, “Ai onne, Makromod!” Petrus dernedi ne, an nairedi nin rain ono idedi kan rain. An rain horu mene nehu laa oir raram nanani laa herraram. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Enla man lernohi pakunohi namehin enihe wohi korkore lernohi me'e ono kan ko'uwala ro lo'o ko'unne meter rahu ida mehe. Ende hir tode rira diyale man i'in penpenu onne laa herraram me'e. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hir kopur korkore laedi herraram, la po'on i'in ailedi aiware wawan la roti aile haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus na'aheni, “Modi minim i'in mamala onne heruwali mai eni.” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Enine Petrus ha'a laa korkore hedu diyale mai herraram. Diyale onne nala i'in lape mamani, na'akeme kem rahu wellima wokelu. Kade diyale nala i'in rahu onne, maa lisar ida kan kaprosu. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus ne'el hi na'ahenia, “Mai ik ka'ak here!” Petrus noro walinhe rauroinedi Ai onne Makromod me'e de ramka'uk ra'ukani Ai, “Pape inhoi?” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Enime'ede Yesus laa na'uraniyedi hi, nala roti noro i'in onne nalkani hi. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lere Yesus nalhari kemen onne namwali rewkelu nina nano lere Makromod Lalap na'amori Ai wali'ur nano Nin makmaki. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hi ra'ak horu ne, Yesus ne'el Simon Petrus, “Simon, Yohanis anan o, lo'o maramyaka Maya'u narehi hi eniyenihe, ee ka?” Simon Petrus na'aheni, “Makrom'u! Makrom'u nauroinedi me'e ya aramyaka Makrom'u.” Yesus ne'el ai na'ahenia, “Ilitolle Ainu'u pipduman enihe.” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesus na'ukani Petrus wali'ur, “Simon, Yohanis anan o, namlolo kokkoo o maramyaka Ya'u?” Petrus na'aheni, “Makrom'u! Makrom'u nauroiroin ya aramyaka Makrom'u.” Yesus ne'el ai, “Ilitolle Ainu'u pipdum enihe.” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesus na'ukani rewkelu nine na'ahenia, “Simon, Yohanis anan o, maramyaka Ya'u, ee ka?” Petrus akin woir wake'e, ono Yesus na'ukani ai rewkelu nina, penia Petrus na'aheni, “Makrom'u nauroinedi ha rahu na'akeme. Makrom'u nauroiroin ya aramyaka Makrom'u.” Yesus na'aheni, “Ilitolle Ainu'u pipdum enihe. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Loi honorok wawa'an Ainu'u nou eniyeni: Lere eniyeni o ka ma'ileher makun, de om hi'i inhawa lernohi mehe num honorok panaeku, maa lere ma'ileheredi, om kikan o limmu, la rin wuku o rodi rala'a, kade mamhene.” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus Nina wanakunu eniyeni kukunohi Petrus hi'ihehewi an maki, la na'aheni nin makmaki onne na'akulu na'alapa Makromod Lalap. An wakunu horu, na'ahenia, “Petrus, mai lernohi Ya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus po'on laa kili'ur ne, po'onala Yesus Nin man lernohi pakunohi man Ai nararamyaka onneni lernohi haenhi. (Nonolu, lere hir hi'i ya'an yomun Paska onne, ai ma naikoro na'urani Yesus, la Petrus hopon nalpupu Yesus, na'ukani na'ahenia, ‘Inhoi ma na'olu Makrom'u?’) ");
INSERT INTO kjeNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus po'on man lernohi pakunohi onneni ne, ai na'ukani Yesus, “Hi'ihehewi noro ai eniyeni?” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus walhe na'ahenia, “Yon mahinorok wallumhe namehin. Lo'o Ya'u hurinohi an mori hehen nanumene Ya'u wali mai noho wawan wali'ur, onne Ainu'u honorok panaeku mehe, onum panaeku ka. Mam lernohi Ya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Onne penia lir anna pe'eredi nahenia man lernohi pakunohi onne kan maki, maa Yesus kan konohi Petrus heheni. Ai na'aheni eni mehe, “Lo'o Ainu'u panaeku o wallum kan maki, maa mori hehen nanumene Ya'u wali mai noho wawan wali'ur, onne onum panaeku ka.” ");
INSERT INTO kjeNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Man lernohi pakunohi onneni mehen do'on ha wo'ira na'akeme eniyeni namwali, la ai penia man horok ha eniyeni na'akeme lolo horok eniyeni, la ik kauroin nahenia ainin wanakunu eni namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus Nin hini'i wenewhe namehin nammori aile makun, de lo'o ik horok na'akeme lolo horok namehin, onno kan nokor lolo noho wawan leke ra'akene horok rahu onneni.");
INSERT INTO kjeNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Konohiyala i makrom'u Teopilus, Lolo ainu'u horok dedesne ihin, ya'u konohiyedi papa ha wo'ira man Yesus hi'i la wakuku nano lere dedesne An howok, ");
INSERT INTO kjeNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","rakan lere alam Ai nakinikan laa a'am raram. Lere Ai kan ha'a laa a'am raram makun, Ai nodi Roh Kudus Nin molollo kuku kalla Nina hophopon man An niliyedi nonolu enihe leke hi rodi Lirna Wawa'an loikaru ri. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Enla An maki, maa mori wali'ur, la alam weli'akka raram Ai nalhari kemen idewe-idewe pakromo noro Nin ri enihe, leke hi rauroin kokkoo An mori wali'uredi me'e, la An wakuku hi hi'ihewi Makromod Lalap nodi molollo Nin ri mormori. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lerida Ai noro hi maha ra'ak ne, An hopon hi, “Yon pelekleke mamhara Yerusalem, maa mamkene lolo koteni newek Ya Am'u nala Roh Kudus ki mi lernohi Nin nou man Ya'u konohiyedi mi lere man laedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nonolu eni Yohanis nodi oir ulutada mi, maa ka nalo'ol me'e Makromod Lalap nodi Roh Kudus ulutade mi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ler namehin hi rore pakromo wali'ur ne, hi ra'ukanie, “Makrom'u, Num panaeku lere eni ma'akeperedi Romawi la ma'ariri noho Israel wali'ur leke mamwali Rai?” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesus walhe, “Makromod Lalap mehe Nin molollo nala alam la nala leken. Ai kan huri mi mauroin onne, ");
INSERT INTO kjeNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","maa ka nalo'ol me'e, Makromod Lalap nala Roh Kudus naikoro mi honorok akin, de mim lernala Nin molollo mamwali Ainu'u man kuku maka lolo Yerusalem, lolo noho Yudea noro Samaria ne'en raram na'akeme, rakan noho pa'i'ik rai pakakar.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ai na'aheniyedi eni horu, hir po'onala Ai nakinikan laa lanik hehen nanumene noho ha'aha'a pupinedie. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hi maha rahehe po'on Yesus ha'a laa lanik makun, ramlilinnohi mo'oni woro'o man nair nainair wawarhe ramririri kan ko'u hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Woro'ohe ra'ahenia, “Heih, ri Galilea mie! Alhi'ihepenia mamriri lolo eni po'opo'on lanik enie? Yesus eniyeni man idedi eni mim po'on nakinikan, laedi a'am raram me'e. Lere man mai An wali mai wali'ur naise idedi mim popo'on An ha'a laa a'am raram eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ler onne hir minle wo'or Au Zaitun de hir wali wali'ur laa Yerusalem. Wo'or onne lo'o kilu ida nano Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hir rakanedi Yerusalem ne, laa nakar mene ha'a laa wawan laa kamar man hir miminle. Hi onnenihe: Petrus noro Yohanis, Yakobus noro Andreas, Pilipus noro Tomas, Bartolomeus noro Matius, Yakobus (Alfeus anan), Simon (ri ma namhene hair namehin nodi molollo hair Israel), noro Yudas (Yakobus anan). ");
INSERT INTO kjeNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Akilere hi na'ahoru lawuku aki mahaku hi'i lir napanak roro idewe maeke ida woro'o. Yesus inne Maria aile haenhi roro wewerre Yesus mo'oniwalinhe. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lerida Petrus namriri lolo walinhe toro (hi na'akeme lo'o ri rahu ida werro'o.) Enla ai na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“I wal'u na'ahoru! Nonolu eni Roh Kudus konohiyedi lolo Daud inhawa ma namwali noro Yudas na'ahenia ai onne namwali ma norkaru ri man kele Yesus wukue. Ha na'akeme ma aile Horok Lap eni peni namwali, de lere eniyeni Daud nin horok onne namwaliyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nonolu eni Yudas onne namwali mahaku noro maika, la Yesus mehen nili ai leke lernohi maika kamwali Nin man lernohi pakunohi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nano Yudas nin ailanne lere ai na'olu Yesus onneni, an lernala kupan rodi weli lari ipida. Lolo nin lari ip onne ai nediyawa la konoin napriki penia konoin romok maiyedi paharne idewe makiyedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yudas nina makimaki eni pe'eredi ri manina Yerusalem na'akeme penia hi rodi rira wanakunu waki kirna onne naranne Akaldama, ma napa'ahne, ‘Lari Ip Rare’. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus na'aheni wali'ur na'ahenia, “Panaeku eniyeni horokedi aile horok Mazmur me'e na'ahenia, ‘Na'amoliyedi nina nakar mamue, yon ri mahaku minle nakar onne.’ La horok aile haenhi ma na'ahenia, ‘Enla na'amoli man panulu nala nin honowok ri namehin hi'ie.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ende lere eni wa'an rehi ika nili ri ida herre Yudas, leke namwali man kuku maka na'aheni Makromod Lalap na'amoriyedi Yesus wali'ur nano Nin makimaki. Wa'an rehi ik nili ri ma nadedem lernohi ika mamani lere Makromod Yesus noro ika min wewerre, nano lere Yohanis nodi oir ulutade ri rakan lere Yesus nakinikan laa a'am raram nano ika kalarna.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ende hir nili ri woro'o: Yusup Barsabas (rapolu Yustus haenhi) noro Matias. ");
INSERT INTO kjeNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Onne horu, hi na'akeme hi'i lir napanak ra'ahenia, “Makromod, O penia mauroin ri mormori akin, de kukul mayai nano ri woro'enihe inhoi Makromod nili, ");
INSERT INTO kjeNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","leke herre Yudas howok honowok eni, ono Yudas eni hoikaruwedi honowok eniyeni la lernaledi nina hunukum me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hir hi'i lir napanak horu ne, rala ri woro'enihe naran leke nili. Matias penia ma naran namhara. Ende kikan ai namwali man howok wewerre noro hophopon idaweli ida ma nodi Yesus Lirna enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Rakanedi lere alam lalapa ma naran Pentakosta ne, ri ma akin naili'il Yesus enihe na'akeme raikokoro wuku lolo onnida. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hi raikokoro wuku ne, ramlilinnohi hir derne haida neknekir nano wawan naisa opil lape. Ha hir dederne onne nekir mamani lolo nakar hir miminle raram na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hir po'onnala haida naisa ai lere man anna hu lalaa mamai nalwali hi dohdoho. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Makromod Lalap nala Roh Kudus naikoro hi honorok akin, idewe Roh Kudus nala woroin hi leke wakunu noho-noho namehin rira wanakunu. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ler onne ri Yahudi ma namka'uk Makromod Lalap nano hair-hair lolo noho wawan na'akeme aile Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hir derne ha man neknekir onneni ne, hir maiwuku me'e. Hir derne ri ma akin naili'il Yesus enihe dohdoho wakunkunu hirira wanakunue, na'akeme polletilu la mehe nanana mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hi na'akeme hehel, la ida ma ne'el ida, “Heih! Ri man wakunkunu eniyenihe manina Galilea, ee ka? ");
INSERT INTO kjeNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hi'ihepenia ika derne hir wakunu rodi iknika wanakunu rahue? ");
INSERT INTO kjeNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Maika eniyenihe ri ma nano noho Patria, Media, noro Elam, ma nano noho Mesapotamia, Yudea, noro Kapadokia, ma nano noho Pontus noro Asia, ");
INSERT INTO kjeNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma nano noho Frigia noro Pamfilia, ma nano noho Mesir noro leke-leke lolo noho Libia ma na'uranrani leke Kirene, la maika heruwali mai nano Roma haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Maika heruwali ri Yahudi la heruwali ri ma ka namwali Yahudi man lernohiyedi Yahudi rira agame me'e, la ik heruwali ma nano noho Kreta noro Arab haenhi. Ik derne ri man wakunu onnenihe dohdoho rodi iknika wanakunu ra'aheni, ‘Makromod Lalap hi'iyedi ha man ik kak dedernale la kak dodo'onnale makun.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hi na'akeme hehel rehi la mehe kakaiyedi, la ida ma na'ukani ida, “Ha ma namwali eniyenihe nina panaeku inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Maa ri aile haenhi mahar hadwei hi ra'ahenia, “Ah, ri eniyenihe nadoo romun arak, de manha mouwedi me'e menee!” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petrus noro Yesus Nin hophopon idaweli ida ramririri wewerre, la an wakunu naruri laa heri onnenihe na'ahenia, “I walin Yahudi roro walin namehin man minle Yerusalem na'ahoru! Makaniyala wawa'an, ya a'amou a'aropo ha man mim dodo'on eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ri enihe ka romon arak, de kar manha naise mim pae'eku eni! Idedi nanumene riuk wohii al'alam menee! ");
INSERT INTO kjeNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ka! Ha ma namwali eniyeni, Makromod Lalap konohiyedi lolo Nin nabi Yoel na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Rakan ku lili'ur Ya ala Ainu'u Roh ri mormori na'akeme leke: Mi anum mo'oni maeke lo'o konohi mi inhawa namwali lere man mai, la minim mo'oni ma na'ikaka makun meher do'on haida-haida, la minim ri leleher ramarmi. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ler onne, Ya ala Roh Kudus ki Ainu'u hophopon wahwahan--mo'oni maeke, leke hir konohi ri namehin inhawa Ya'u pae'eku eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ya'u hi'i tanada ri ka nadedem do'on lolo a'am eni, noro tanada ri ka nadedem do'on lolo noho wawan haenhi, rara noro aiye, la ai mahu namansa haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lere onne lere maki, la wollo namwali mere naisa rare. Eniyeni namwali nolu mene Ainu'u Ler Alam Lalapa man ma'aruru wake'e mai. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Enla inhoi napanak Maya'u pakue, ai onne lernala Ainu'u or'ori dardari ma kan horu.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","I wal'uhe ri Israel na'ahohoruwedi! Makaniyala wawa'an ainu'u panaeku eniyeni: Yesus, manin Nazaret onne, ik Makromod Lalap hopon mai min noro maika. Ik kauroin panaeku onne, ono Makromod Lalap nala molollo Ai leke An hi'iyedi ha man lewlewen noro tanada nammori man ik kak dodo'onnala makun. Ha onne na'akeme An hi'iyedi lolo mi herne kalarne, de i wal'uhe do'on la mauroinedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesus onne, Makromod Lalap nala ki mi, maa mi mesnedie, mala kani ri man ailanna leke waire lolo au kekiyowok. Panaeku onne na'akeme Makromod Lalap nakakaredi nano nonolu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Enimaa Makromod Lalap huri Yesus nano makmaki nin apinpinha wo'operperi, ono makimaki ka naruri nodi molollo Yesus mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nonolu eni ik upud a'ad Daud konohiyedi ha ma namwali noro Yesus heheni, ‘I do'on Makromod Lalap lolo Ya'u kalarna mamani, Ai norle'ule'u norwaliwali Ya'u de, haida ka na'o'o nadewe Ya'u. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Enpenia Ya akin nahuwa'an, Ya a'uli asa'e mamani, la ka amkauk inhawa namwali I kem'u ono Ya akin naili'il O. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","O kam huri we'er Ya'u minle makimaki onno mamani, la kam hoikaru Num Man Moumou Dewdewe kemen popo. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Papa kukuwedi kalla or'ori dardari Ya'u me'e, la morle'ule'u morwalwali Ya'u penia Ya akin nahuwa'an wake'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Konohiyala I wal'u na'ahoru, nano Daud lirna nonolu onne, ik kauroin mouropo ai kan wakunu ha ma namwali ai kemen mehe, ono Daud onne makiyedi me'e, la nina lunne aile noho eni makun. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud namwali nabi, de ai nauroin nahenia Makromod Lalap kikan hopo na'akerhe Nin nou ma na'ahenia nano ai upun anan Ri ida kikan namwali Rai naise Daud haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Enpenia Daud nauroinedi ha ma namwali lere li'ur penia na'aheni, ‘Kristus onne, Makromod Lalap kikan namwali Rai laa ewi-ewi, la An maki, maa mori wali'ur.’ Daud na'ahenia An maki laedi lunne raram, maa Makromod Lalap kan hoikaru Ai minle makimaki onno, la Ai kemen kan popo lunne raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesus eni penia Makromod Lalap na'ori wali'ur nano makimaki. Mayai na'akeme mehem do'onedi panaeku onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Makromod Lalap kikan Ai naikoro onno man kukulu lalapa lolo Ai herne malanna. Ai Aman nala Roh Kudus Ai naise An nonou eni, de ha mi mehem do'odo'on derderne eniyeni namwali ono Yesus naledi Roh Kudus onne naikoredi mayai honorok akin me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ik kauroin onne, ono Daud kemen kan ha'a laa a'am lapa raram, maa lolo horok namehin Daud napolu Yesus, ‘Makrom'u’. Ai na'aheni, ‘Makromod Lalap na'aheni I Makrom'u: Mai, maikoredi I her'u malanne, ");
INSERT INTO kjeNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","newek hehen nanumene Ya akeperedi Onum arwali enihe, leke O modi molollo hi.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kame'ede Petrus na'ahenia, “Ende mi ri Israel na'ahoru mauroin kokkoo panaeku eniyeni: Yesus eni man mim wairesne, Makromod Lalap kikan namwali mi Makrommu noro idewe minim Rai (Kristus).” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hir derne panaeku onneni horu, hi akin woiredi me'e, de ra'ukani Petrus noro hophopon ma nodi Yesus Lirna namehin enihe ra'ahenia, “Mayai lo'o hi'i inhawa?” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus walhale, “Mi dodoho herre minim morimori ma ka namloleni, la derne makani Makromod Lalap. Enla na'amoli mim hurinohi rin nodi oir ulutada mi nodi Yesus Kristus Naran, leke ra'ohu rahaledi minim dohohale, la na'amoli mim lernala Roh Kudus, ");
INSERT INTO kjeNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ono Makromod Lalap nouwedi me'e na'ahenia Ai nala Roh Kudus mi moro mi upun anumhe, noro idewe ri ma aile noho koko'u enihe. Ik Makromod, Makromod Lalap, nala nou eniyeni ri na'akeme man Ai napolu mai namwali Nin ri.” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus nala panaeku namansa hi leke ken herre hi honorok akin, la napanak an'anhedi na'ahenia, “Mapanak Makromod Lalap huriyedi mi nano ku eniyeni nin honoli man yaka, leke yon An hukum mi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Enime'ede ri man kokala Petrus nina wanakunu enihe aki hi na'akeme lo'o ri riwan wokelu. Hi na'akeme rala'a oir raram leke rin ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hi onnenihe rampe'el lawuku mamani leke derne rakani hophopon ma nodi Yesus Lirnenihe wakuku. Hi ida ma nala akin ida, la ha'ar roti ra'an romun mamani, la hi'i lir napanak wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ri na'akeme lolo Yerusalem heheledi po'on hophopon ma nodi Yesus Lirnenihe hi'i hahaa kar dodo'onnala la ka rauroroinnala makun. Hir horhawa rehi hophopon ma nodi Yesus Lirnenihe ono Makromod Lalap naledi molollo hi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ri ma akin naili'il Yesus enihe lawuku mamani, ida man mori wawa'an noro ida, la inhawe man hirira aile hir ha'ar nair wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hi ra'olu rira hahaa leke ha'ar wella rale hirira ri man hewhewek nainair kan nokor. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Akilere hir lawuku Makromod Lalap Nina Romleu Lap raram ra'uli rasa'a Oin Naran man kukulu la man lalape. Hir pakromo wuku lolo nakar laa nakar leke ra'ak wewerre noro akin ma nahuwa'anedi, la ida man helkaki ramdaru ida. ");
INSERT INTO kjeNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hi ra'uli rasa'a Makromod Lalap mamani, la ri man minle kote onne akin nahuwa'an noro hi. Akilere Makromod Lalap na'uwali ri man lernaledi Nina or'ori dardari ma kan horu eni, penia heri ma akin naili'il Yesus eren na'uwawali. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Rakan lerida lere mamamal, Petrus noro Yohanis rala'a laa Romleu Lapa naise nadedem leke hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hir rakan Romleu Lapa nin nika lapa ma naran, ‘Nika Man Ma'arurue,’ la lole laa raram. Ri mahar rodi mo'oni ida man ein naplu'ukedi mai raram haenhi. Nano lere mori me'ede ein makiyedi de, akilere rodi laa naikoredi lolo onne leke napanak kupan tarana. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","An po'on Petrus noro Yohanis laa raram ne, ai napanak ralala haida ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Enime'ede hir po'on nale, Petrus hopon na'ahenia, “Po'onala mai eni!” ");
INSERT INTO kjeNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","An po'on hi, raram hawa'anedi ono lo'o an kokala haida nano hi harome. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Maa Petrus na'aheni, “Kupan kaale mayai, maa inhawe man ainima ai mala ki o. Lolo Yesus Kristus nano Nazaret Nina ke'eke'el an'anha am hopon o mamriri mala'ala'a here!” ");
INSERT INTO kjeNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petrus nasala ri onne liman malanne paku na'ariri, idewe ein ma naplu'uk noro ein hunuhun naruriyedi, de nehu laa wawan, namririri, lalaa mamai. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Enine ai noro hi laedi Romleu Lap raram, la ai onne nehunehu, lalaa mamai, la na'uli nasa'a Makromod Lalap mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Heri man minle Romleu Lape raram po'onale nala'ala'a, la dederne ai maha na'uli nasa'a Makromod Lalap. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mai hi rahiyennala ri onne ma nadedem naikoro Romleu nin ‘Nika Man Ma'aruru’ mehe napanpanak ne, hir hehel rehi, ida ma ne'el ida, “Ha man ik kak dodo'onnale makun, namwaliyedi me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ri man wa'anedi onne lernohi Petrus noro Yohanis mamani, de ri nammori do'on ai la larinohi hi laa Salomo Nina Henei Lap eni ono hi na'akeme hehel rehi. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus po'on ri namansa onneni, ai na'aheni hi, “Heih! I walin Israel mie! Alhi'ihepenia i walin hehel rehi po'on inhawa namwali mai eni? Hi'ihepenia mim po'on mayai mamanie? Yon makoto nahenia ai modi ainima ke'eke'el an'anha aimehi hi'i wa'an ri eni, ee lo'o ai akim mou wake'e de am hi'i wa'an ri onne! Ka menee! ");
INSERT INTO kjeNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Makromod Lalap man ik upud a'ad Abraham, Isak, noro Yakup roro ik upud a'ad namehin enihe ra'uli rasa'eni penia na'akulu na'alapedi Yesus, Ai Nina Hophopon Wahwahan, me'e. Yesus eni penia, i wal'uhe mamale laa ma nodi molollo, la ma'okuledie lolo Pilatus kalarna, kade Pilatus na'ahenia huriyedi Ai here. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mi ma'okuledi Ai Man Moumou Dewdewe la Man Akin Namdudu onne, la mi mapanak Pilatus huriyedi ri ma nadedem nesne ri mormori ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I walin mesnedi Ai ma namwali or'ori dardari onno, maa Makromod Lalap na'ori wali'ur, la lere onne ai mehe modi ai makam do'odo'on. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesus eni penia Nin ke'eke'el an'anha hi'i wa'an man ein maki eni. Ende ri man mim do'odo'on la mauroinedi nano nonolu me'eni, an wa'anedi ono ai akim naili'il Yesus nodi molollo hi'i wa'an ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","I wal'u na'ahoru! Ler eniyeni ya auroin mi moro idewe minim man panulu enihe ka mauroin mim hi'i inhawa lere mi mesne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Maa Makromod Lalap nonolu eni nouwedi lolo Nina nabi na'akeme me'e nahenia Rai man Ai mehen kikanedi eni lo'o resnedi, de An hi'i Nina panaeku onne namwali lere mi mesne Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ende, i wal'uhe, herredi minim morimori ma ka namloleni, la derne makani Makromod Lalap leke Ai na'ohu nahaledi minima dohohala. Hi'i heheni leke Makromod Lalap nala honorok wawa'an nodi na'alaplapa mi akim, ");
INSERT INTO kjeNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","leke lere man mai An hopon Yesus mai ki mi wali'ur, ono nano lere dedesne Makromod Lalap kikanedi Ai namwali minim Rai laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesus eni ka namhara a'am raram hehen nanumene lere alam Makromod Lalap na'alolo ha wo'ira na'akeme wali'ur, naisa nonolu Ai na'aheniyedi lolo Nina nabi enihe me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nonolu eni nabi Musa konohiyedi ik upud a'ad na'ahenia, ‘Na'amoli Makromod Lalap kukul Nabi ida naise ya'u nano minim nohe. Derne makani Nina panaeku na'akeme man An loikaru ki mi eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Inhoi kan derne nakani Nina loloi kakarue, Makromod Lalap naheiredi nano Nin ri la hukumesne.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nonolu eni Makromod Lalap Nina nabi na'akeme, nano nabi Samuel rakan nabi-nabi namehin man kauli'ur, konohiyedi ha ma namwali ku eniyeni me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","I wal'uhe, Makromod Lalap nala Nina nou ma namkene nabi ma namwali mi upun a'um onnenihe, de mim lernala nou onne haenhi. An nou Abraham na'ahenia, ‘Nano o upun anan ida, Ya ala wawa'an rara'a noho wawan na'akeme.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ende Makromod Lalap kikan Nin Hophopon Wahwahan, Yesus, la hopon mai mi nolu, namre'e namharu mi, leke mi na'akeme herre minim morimori ma ka namloleni, mai lernohi Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus noro Yohanis wakunkunu heri kalarna makun, imam lalapa ida woro'o roro uluwakun ma nadiyaka Makromod Lalap Nin Romleu Lape roro muku Saduki mai. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hi ra'ahan wake'e ono Petrus noro Yohanis wakuku ri nammori lolo onne ra'ahenia, “Yesus mori wali'uredi me'e,” la nano rira wanakuku eni, hi ra'amou ra'aropo panaeku ri man maki, mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ende hir kele wuku hi, rale laedi bui raram min lolo onne rakan nohoropo, ono lere helemedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Enimaa nano ri man dernedi rira wanakunu onneni, ri namansa akin naili'iledi Yesus. Enpenia rakan lere onne, aki mo'oni mehe man lernohi Yesus rakanedi riwan wolima me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Rakan nohoropo nanumene agame nina man panulu roro Yahudi rira leleher lalap roro meser Horok Lap enihe lawuku lolo Yerusalem hopun pepen. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hir lawuku roro wewerre Hanas ma namwali imam man kulu narehi, noro Kayapas, Yohanis, Aleksander noro ri namehin man ihin walin na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hi raikoro wukuwedi ne, hopon rodi Petrus noro Yohanis mai rakpali hi, mene ra'ukani hi ra'ahenia, “Hi'ihehewi? Modi inhoi nina ke'eke'el an'anha la inhoi naran penia mim hi'i wa'an ri ma naplu'uk onne?” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Enime'ede Roh Kudus nodi molollo Petrus de walhale na'ahenia, “Man panulu roro leleher lalap Israel ne'en raramne mie! ");
INSERT INTO kjeNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Lere eni i wal'uhe sisnai mayai ono am paku ri ma naplu'uk eni, la mi mahehe mauroin hi'ihehewi mayai hi'i wa'an ai, ");
INSERT INTO kjeNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","de ya'u konohi mi inhawa ma namwali eni leke i wal'uhe moro manin Israel na'akeme mauroin kokkoo: Yesus Kristus, ri Nazaret onne, mehe Nina ke'eke'el an'anhe hi'i ri eniyeni wa'anedi, penia ai namriri mi kalarna. Yesus onne mim wairesnedi, maa Makromod Lalap na'oriyedi wali'ur me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Horok Lap Lirna aile man kukul Yesus eni na'ahenia, ‘Waku man ri ma nayapi nakar sosopole, namwali waku na'a'ar.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Onne horu, Petrus na'aheni wali'ur, “Lolo Yesus mehe rin lernala or'ori dardari ma kan horu, kalla namehin kaale. Lolo noho wawan na'akeme Makromod Lalap ka nala molollo ri namehin nala or'ori dardari maika, maa Yesus mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Man panulu onnenihe rauroin Petrus noro Yohanis kar iskolo, maa ramwali ri ma nadedem mehe, de hir hehel rehi po'on woro'ohe ka ramka'uk wakunu mouropo roro hi. Hi rauroinedi nahenia woro'ohe lidan nohi la'ak nohi Yesus mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Man panulu onnenihe ka rauroin wakunu me'e, ono hir po'on ri man wa'anedi onne namririri hi kalarna roro Petrus noro Yohanis. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Enime'ede hir hopon woro'ohe laedi paharne leke hir paeku wukuwala. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ida ma na'ukani ida, “Lo'o kala inhawa panaeku kodi walha ri eniyenihe? Ri man minle Yerusalem na'akeme rauroinedi woro'ohe hi'iyedi ha man ri kan dodo'onnala makun eni me'e, de kan wa'an ka'aheni hi kar hi'i ha onne namwali. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Maa wa'an rehi ik kasu hi, yono wakuku ri rodi Yesus Naran me'e leke panaeku eni yono naderre nadaul laa pororo pahahari herie.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Enpenia hi rapolu Petrus noro Yohanis mai raram wali'ur, hopon na'ahenia, “Yono mim wakuku ri modi Yesus Naran me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maa Petrus noro Yohanis walhale, “Mi mehem hi'i kenekrohu lolo Makromod Lalap herne kalarna, ewi man wa'an narehi: Am lernohi minim honopon, ee lernohi Makromod Lalap Nina honopon? ");
INSERT INTO kjeNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mayai eni kam ren wakunu panaeku onne ono ai mehem dodo'on la dederneni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Onne horu, man ho'ok kail onnenihe kasuwedi woro'ohe wali'ur mene huri. Hi ka rauroin hukum hi hi'ihewi, ono heri na'akeme ra'uli rasa'a Makromod Lalap ono hir hi'i wa'anedi ri ma naplu'uk onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Heri onne hehel rehi ono ri man wa'anedi onne nina anna weli'akka rehi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Huriyedi Petrus noro Yohanis ne, hir wali wali'ur laa walinhe man lernohi Yesus la konohi hi imam lalapa roro Yahudi rir leleher lalap enihe rira lira kanasu eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Walinhe derne wanakunu onne horu, hir lawuku aki hi'i lir napanak Makromod Lalap. Hi ra'ahenia, “Makromod Ma Nodi Molollo Ha Wo'ira Na'akeme! O peni ma nakuku noho ma naleu a'am, la ma nakuku lour noro ihin ennen na'akeme, ");
INSERT INTO kjeNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","O mala Roh Kudus wakunuwedi lolo Onum hophopon, ai upum a'um Daud, na'ahenia, ‘Hair-hair ma ka nauroin Makromod Lalap, alhi'ihepe mi ma'ahan, la paeku hi'i wowo'o ar'arra mamani? Mi ri ma ka namwali Yahudi, alhi'ihepe mim hi'i panaeku ma kan min haida? ");
INSERT INTO kjeNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Rai lolo noho wawanne roro rira man panulu lawuku ra'akene leke ra'ara roro Makromod Lalap noro Nina Rai man Ai mehen kikan eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Oirawi inworo'ohe Herodes noro gubernur Pontius Pilatus lawuku roro ri ma ka namwali Yahudi roro ri Israel na'akeme manin koteni. Hir paekuwuku leke kohon yaka O Hophopon Wahwahan Man Moumou Dewdewe onne, man Om kikanedi namwali Rai me'e, de Daud nina wanakunu onne namwaliyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hir lawuku leke resne Yesus, maa hi ka rauroin O mehem nakakaredi rira hini'i wenewhe onne nano nonolu eni me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Makromod, lere eniyeni dernala rira wanakunu rodi aka'ukai. Ma'alapedi ai akim, mayai ma namwali Onum hophopon leke yono ai mamkauk loikaru O Lirmu wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mala Onum ke'eke'el an'anha mayai leke am hi'i wa'an ma nakni'ir, la hi'i ha man ri kan dodo'onnala makun modi molollo nano Yesus, Num Hophopon Wahwahan Man Moumou Dewdeweni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hir hi'i lir napanak horu, nakar hir miminle onne narururue, la Roh Kudus nodi molollo hi na'ahoru honorok akin, de hi ka ramka'uk wakunu Makromod Lalap Lirna Wawan laa heri mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Heri ma akin naili'il Yesus na'akeme rira honorok namnehe panaeku na'alono. Ri mahaku ka na'aheni, “E'eni ainu'u hahaa aimehi,” maa inhoi nina, hirira wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Roh Kudus nala molollo hophopon ma nodi Yesus Lirnenihe, de rampe'el wake'e konohi ri na'ahenia, “Yesus maki, maa mori wali'uredi me'e.” Makromod Lalap namre'e namharu rehi hi na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ler romromo ri aile ma na'olu nina kirna, ee nakar, mene nodi wella laa nale hophopon ma nodi Yesus Lirnenihe, ");
INSERT INTO kjeNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","leke hir ha'arle ri ma nin hahaa kan kuku kan nokor. ");
INSERT INTO kjeNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ri ida naran Yusup na'olu nina lari ipida nodi wella nala hophopon ma nodi Yesus Lirnenihe. Yusup onne nano luhu Lewi manin noho Siprus. Hophopon enihe waki ai ‘Barnabas’ haenhi. Naran Barnabas onne napa'ahne, ‘ma na'alapa ri akin’. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ler onne, mo'on ida naran Ananias noro hono Safira ra'olu rira lari ipida haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias nodi lari ip onne wella heruwali laa nalle hophopon ma nodi Yesus Lirnenihe, maa ai noro hono manaku aimehiyedi heruwali me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ende Petrus na'ahenia Ananias, “Hi'ihepenia Hayakyak Makromon nodi molollo o akim, de mapoho Roh Kudus ma'ahenia o mala noho wella na'akeme, maa mala heruwali mehe? ");
INSERT INTO kjeNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Noho ka ma'olu makun, om manarna. O ma'oluwedi noho onne, om manarna wella na'akeme haenhi. Emene hi'ihepenia om paeku yaka heheni o raramne? O ka mapoho ri mormori, maa mapoho Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias derne wanakunu onneni horu, namlilinnohi nalwali yawa, idewe aran horuwedi. Ri man derne panaeku onne na'akeme ramka'uk wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ananias makiyedi ne, ma na'ikakenihe rodi tapi mai komon ihin kemen nanumene rodi laa paharne rawilo'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lo'o jam wokeluwedi nanumene hono Safira mai Petrus nina nakar raram, maa ai kan derne inhawa ma namwali hono makun. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus na'ukani Safira, “Noho moro o houm Ananias ma'o'olu onne, wella na'akeme me'eniyeni, ee ka?” Safira walhe, “Kokkoo, wella me'eni mehe.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Enine Petrus na'ahenia, “Alhi'ihepenia moro o houm lawuku panaeku kene Makromod Nin Roh? Po'onale! Ma nawilo'edi o houm enihe, waliyedi ramririri melle nike makan me'e. Ler eniyeni hi rodi o laa paharne haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ideweni ne, ai nalwali yawa Petrus kalarna, idewe aran horuwedi. Ma na'ikakenihe laedi raram ne, hir po'on Safira makiyedi me'e, de rodi laa paharne leke rawilo'e min nohi hono Ananias nina lunne. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Enpenia kerei raramne na'akeme roro idewe ri namehin man derne panaeku onne ramka'uk wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hophopon ma nodi Yesus Lirnenihe hi'i tanada noro hahaa lewlewen nammori man ri kan dodo'onnale makun. Ri ma akin naili'il Yesus na'akeme radedem lawuku rodi honorok ma namnehe panaeku ma na'alono lolo Salomo Nin Henei Lapa ma aile Makromod Lalap Nina Romleu eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ri namehin ramka'uk roro hi lawuku, maa kota ne'en raram na'akeme horhawa hi ma akin naili'il Yesus enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ka nalo'ol mo'oni maeke ma akin naili'il Yesus enihe, eren nammomori. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Heri do'onedi ma nodi Yesus Lirnenihe hi'i hahaa man ri ka nadedem do'on, de hi rodi ma nakni'ir noro rira piki luni laa loile kalla arkan leke newek Petrus lolo onne, ono hi akin naili'il nahenia lo'o Petrus kakan mehe nalala hi, wa'anedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ende ri nammori rano leke-leke ma na'urani Yerusalem rodi hirira ma nakni'ir roro ri man hayakyake huhu'ur raramne mai Petrus leke hi'i wa'an, la rohi hayakyaka man min ri raram onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ler onne imam man kulu narehi noro nina ri nano muku Saduki do'on ma nodi Yesus Lirn onnenihe hi'i ha wo'ira na'akeme onneni ne, hi akin apinha wake'e. Enpenia hir paeku wuku leke hi'i sus hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hir kele hophopon ma nodi Yesus Lirn onnenihe rale laedi bui raram, ");
INSERT INTO kjeNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","maa mai a'alam onneni Makromod Lalap Nina hophopon a'am raram ida lan hari bui nina nikenihe, norkaru hi laa paharne mene hopon hi, ");
INSERT INTO kjeNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mala'a laa Romleu Lapa konohi heri lolo onne Lirna na'akeme ma nala or'ori dardari ma kan horu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ende rakan oreki al'alam, hir laa Romleu Lap raram wakuku heri lolo onne. Al'alam onne me'ede, imam man kulu narehi noro nina ri enihe polu wuku Yahudi rira man ho'ok kail enihe na'akeme mai leke rahinopun. Hi raikoro wukuwedi, hir hopon ri laa rala ma nodi Yesus Lirnenihe nano bui raram mai leke ho'ok kail hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Enimaa ri hohopon onnenihe rakanedi bui eni, kar do'on hi me'e, de wali laa konohi man ho'ok kail enihe, ra'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Am rakanedi bui nina nikenihe, na'akeme konkonse makun, la ma nadiyak enihe ramriri aile nike makan. Ende am hari nike po'on bui raram, maa ri mahaku kaale.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uluwakun ma nadiyaka Romleu Lap noro imam lalap enihe derne rira wanakunu onneni, hir mehe kakaiyedi ono ka rauroin lo'o inhawe namwali hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ka nalo'ol, mo'oni ida nodi lir mai konohi na'ahenia, “Eih, pap mie, ri man mi mala laa bui raram onnenihe aile Romleu Lap raram, mahar wakuku ri namansa.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Enime'ede uluwakun ma nadiyaka onne noro nin man howok wali enihe laa rala wali'ur ma nodi Yesus Lirnenihe, maa heri raram nodi derne rira wanakuku, de hir ka rodi apipinha rala hi, kalo'o heri onnenihe ra'ahan rodi waku wasla hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hi rorkaru Petrus noro Yohanis laa rakpali man ho'ok kail enihe. Imam man kulu narehi ne'el hi na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Eih! Am kasuwedi mi me'e nahenia yono wakuku ri modi Yesus onne Naran me'e menee! Maa ken mehem po'on inhawe mim hihi'i! Mim loikaruwedi wanakuku onne lolo Yerusalem ne'en raram na'akeme me'e, la mim tumdesne mayai nahenia am hi'i ri onne maki!” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus noro Yesus Nin hophopon namehin enihe walhale, “Mayai lernohi Makromod Lalap Nina panaeku mehe, Ai kan huri mayai lernohi ri mormori nin panaeku. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mi mesne Yesus, rohedi au kekiyowok eni, maa Makromod Lalap man ik upud a'ad ra'uli rasa'eni na'ori wali'uredi, ");
INSERT INTO kjeNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","la kikanedi Ai, naikoro lolo herne malanna me'e leke rodi molollo wewerre. Naledi molollo Ai namwali Rai Ma Nala or'ori dardari maika. Ai nala leken paharin ika, noho Israel eni, herredi iknik morimori ma ka namloleni, leke Ai na'ohu nahaledi iknik dohohaleni. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ai moro Roh Kudus mamwali man kuku kalla laa ri namehin ha onne na'akeme. Roh Kudus eni, Makromod Lalap nalle ri na'akeme man derne rakani Ai.” ");
INSERT INTO kjeNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hir derne Petrus nina wanakunu onneni horu, hi raram ha'a wake'e, de hi na'akeme rira panaeku resne hophopon ma nodi Yesus Lirnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Enimaa ri Parisi ida ma narane Gamaliel namriri lolo hi leken kalarna la hopon rodi ma nodi Yesus Lirnenihe laedi paharne nanu. Ai onne meser Horok Lap man ri na'akeme horhawe rehi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hir laedi paharne, ai ne'el walinhe na'ahenia, “Konohiyala i walin Israel na'ahohoruwedi! Paekuwala wawa'an nanumene hi'i kenekrohu kala ri eniyenihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","I walin horhorok annida woro'o man laedi me'e ne, Taudus onne na'aheni ai namwali ri lewlewen ma nodi molollo, penia lo'o ri rahu wo'akka lernohi ai, maa ri nesnedi ai, de nina man lernohi enihe na'akeme rapye'eredi, la rira panaeku onne namderredi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lerida wali'ur, lere rin lalaa mamai horok ri narane leke aki lawanne, ri Galilea ida aile naran Yudas. Ai namwali uluwakun ri namansa haenhi. An kohon arra noro ma nodi molollo iknik nohe, maa ri nesnedi ai haenhi, la nina man lernohi enihe rapye'er mouwedi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ende, i wal'uhe, ainu'u nounaku eni: Yono hi'i haida-haida ri eniyenihe. Wa'an rehi na'amoliyedi me'e, ono lo'o hirira panaeku noro hini'i wenewhe kan mai nano Makromod Lalap, maa namwali rir panaeku aimehi, rira wanakuku mehen moluwedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Maa lo'o hir lernala panaeku onne nano Makromod Lalap, i wal'uhe ma'alehe molollo kawala hi. Yon mim hi'i ik koro Makromod Lalap ka'ara!” Enime'ede man ho'ok kail onnenihe kokala nin nounaku onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ende hi rapolu hophopon ma nodi Yesus Lirnenihe wali mai nanumene riuk rerhe. Hir kasuwedi ra'ahenia, “Yono wakuku ri wekel Yesus naran me'e!” Onne horu, huriyedi hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ma nodi Yesus Lirna onnenihe ramhara honopun onne rodi aki ma nahuwa'an wake'e, ono Makromod Lalap naledi hi leken lernala apinpinha wo'operperi me'e ono hir lernohi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Akilere hi kar ren wakuku ri lolo Makromod Lalap Nina Romleu Lap noro ri nina nakar, la kar ren loikaru Makromod Lalap Lirna Wawa'an eni nahenia Yesus onne penia namwali Ai man Makromod Lalap kikanedi namwali Rai laa ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ri man lernohi Yesus enihe eren nammomori. Nano hi, ri Yahudi ma nodi wanakunu Yunani enihe akin kar wa'an roro ri Yahudi ma nodi wanakunu Ibrani. Hir hehel warna enu ra'ahenia, “Akilere hirira maeke walwalum enihe lernala hana'ar hanana'an, maa ainim walwalum enihe, kar lernala!” ");
INSERT INTO kjeNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ri idaweli woro'o ma nodi Yesus Lirnenihe derne panaeku onne, hir polu wuku ri man lernohi Yesus na'akeme hopun. Hi ra'ahenia, “Lo'o kan wa'an mayai ma'akene hanana'an, kalo'o ainim leken kaale loikaru Makromod Lalap Lirna Wawan eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ende lo'o man wa'an narehi, ai walinhe nili ri wo'ikku nano mi, ri man Roh Kudus nodi molollo, la man mori wawa'an, la ma nin honorok panaeku wa'an, leke ai mala hi tolle honowok onne, ");
INSERT INTO kjeNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","leke huri yai hi'i lir napanak noro loikaru Makromod Lalap Lirna Wawan eni mamani.” ");
INSERT INTO kjeNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ri na'akeme kokaledi hirira panaeku onne. Enpenia hir nili Stepanus, ono Roh Kudus nodi molollo ai la akin naili'il Yesus kokkoo. Enla hir nili wali'ur Pilipus, Prokhorus, Nikanor, Timon, Parmenas, noro Nikolas ma nano Antiokia. Nikolas eni ri ma ka namwali Yahudi, maa an lernohiyedi agame Yahudi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ri man hopun enihe roro ri wo'ikku ninili enihe laa rakpali hophopon ma nodi Yesus Lirnenihe. Hir kemenala liman hi, rapanak Makromod Lalap nala molollo hi leke ilitolle honowok eni wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ende Makromod Lalap Lirna Wawan eni eren naderre nadaul, penia ri man lernohi Yesus eren nammomori lolo Yerusalem, la imam nammori akin naili'il Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stepanus onne, Makromod Lalap nodi nale kokkoo, la nala molollo ai penia hi'i ha nammori ri kan dodo'onnale makun lolo heri kalarna, ");
INSERT INTO kjeNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","maa ri namehin aile man kawale. Man kawala enihe radedem laa Yahudi rira kerei ida wekwekel, ‘Hophopon Wahwahan Ma Nahinuriyedi Me'e Rira Kerei.’ Kerei onne raramne Yahudi ma nano leke Kirene noro Aleksandaria. Hi roro ri Yahudi ma nano Kilikia noro Asia rawalha lira roro Stepanus, ");
INSERT INTO kjeNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","maa hi ka rauroin walha Stepanus, ono Roh Kudus nala woroin ai penia nauroin wakunu wawa'an. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ende hi rodi kalla suwsuwar rala kupan ri ida woro'o, leke hir tumdesne ai na'ahenia, “Mayai derne ri onne na'ihoru na'idaru Musa noro Makromod Lalap!” ");
INSERT INTO kjeNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hi rawa'u ri namansa roro leleher lalap roro meser Horok Lap enihe, penia hir laa kele Stepanus rodi laa nakpali Yahudi rira man ho'ok kail enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Hi rodi rira man kuku maka rakpali hi haenhi leke hir loikaru ha ma ka namlolo ainina hini'i wenewhe. Hi ra'ahenia, “Ri eniyeni kan ren na'ihoru na'idaru Makromod Lalap Nina Romleu man moumou dewdeweni noro idewe agame nina keneri hono'ok haenhi! Am derne an wakunkunu na'ahenia, ‘Na'amoli Yesus, ri Nazaret onne, naiye'eredi Makromod Lalap Nin Romleue, la An herre iknik honoli wenewhe na'akeme man ik upud a'ad Musa naledi maika nonolu me'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hir wakunu horu, man min honopun eni po'on kakane Stepanus oin makan siksik lerlere naisedi hophopon a'am raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Imam man kulu narehi na'ukani Stepanus na'ahenia, “Lo'o hirira kalaklak onnenihe namlololo, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stepanus walhe, “Konohiyala ya am'u la i walin na'ahohoruwedi! Makaniyala tarana. Ler ik upud a'ad Abraham min Mesopotamia, ka nala'a Haran makun, Makromod Lalap ma Nin ke'eke'el an'anha narehi nalewen eni nalhari kemen ai, hopon na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Hoikaruwedi onum lekloi noro lodon wallumhe mala'a laa leke man Ya'u kukul ki o.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Enime'ede an hoikaruwedi nina noho miminle, Kasdim onne, rei kau laa leke Haran. Abraham aman maki lolo Haran nanumene Makromod Lalap hopon ai rei kau wali'ur mai noho ika holiholi eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ler onne Makromod Lalap ka nala noho me kirnida, nala Abraham leke manarna lolo onne, maa An nou na'ahenia, ‘Noho eniyeni Ya ala ki o moro o upun anum manarna.’ Ler Ai nala nou onne, Abraham anan kaale makun. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Enine Makromod Lalap konohi ai wali'ur na'ahenia, ‘Ku man mai o upun anum rala'a laa noho namehin ramwali do'on awan enne. Ornoho orrai lolo onne hi'i hi ramwali hophopon wahwahan, la kerne dalha hi hehen nanumene anna rahu wo'akka. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hir hi'i heheni nanumene Ya'u hukum noho ma nodi kenerne danalha onne. Hunukum onne horu, hi ramhara lolo onne laa noho Kana'an mene ra'uli rasa'a Ya'u.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","An konohiyedi onne horu, Ai nala nou ma namkene ida Abraham, la hopon ai noro upun anan na'akeme laa sunat, leke na'akerhe nou onne. Ende moriyedi Isak alam wo'aa nina ame mehen sunate. Mai wali'ur Isak na'ori Yakup, an mehe sunat anan haenhi. Enla Yakup na'ori tatana idaweli woro'o mehen sunat hi haenhi. Ri eniyenihe penia ma namwali Yahudi upun a'an. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mai lere li'ur, ik upud a'ad Yakup anan idaweli ida ra'olu walla Yusup laa Mesir, ono hi akin apinha, maa Makromod Lalap norle'ule'u norwaliwali ai, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","la huriyedie nano nina kenerne danalha lolo Mesir eni. Enla Ai nala morimori man wa'an noro honorok aki man wa'an ai penia lere ai nakpali Firaun ma namwali rai Mesir, ai nahuwa'an rai eni akin. Enpenia Firaun kikan ai namwali ma nodi molollo lolo Mesir ne'en raramne, la hi'i ai namwali uluwakun nin romleu onno. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Eni nanumene Mesir noro Kana'an lernala roulara lapa. Roulara onne hi'i ri nammori sus wake'e, la aman noro walinhe kar lernala hanana'an lolo Kana'an me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakup derne maha ra'olu gandum ai Mesir, de hopon ik upud a'ad laa enne weli hanana'an. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Rakan hir laa Mesir rewro'o nine, Yusup konohi walinhe na'ahenia, ‘Maya'u eni Yusup.’ Eni nanumene rai Mesir nauroin nahenia hi eniyenihe Yusup mo'oniwalinhe. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Enime'ede Yusup aku lira laa aman napanak ai noro upun anan na'akeme rei kau mai Mesir. Aki hi na'akeme ri weli'ikku wolima. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Enine Yakup noro ananhe re'e nohi laa Mesir. Min enne hehen nanumene hir maki, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","maa lere li'ur hi rurna hokon rodi wali'ur laa Sikem nanumene ra'akene lolo ku'il raram man Abraham nodi kupan pere weliyedi nano Hemor upun ananhe me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stepanus na'aheni wali'ur, “Rakan lere li'ur, lere Makromod Lalap Nina nou noro Abraham na'uraniyedi me'e, ai upun ananhe lolo Mesir eren na'uwawali. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kame'ede kikan rai namehin nodi molollo Mesir ne'en raram, la ai onne ka nauroin Yusup onne inhoi. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ai nodi konoko wunudi noro rurilai nala ik upud a'ad, hopon hi sopoledi anan memerana na'akeme, yono kihi lauhe. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ler onne mori Musa. Ai onne tatana man oin makan ma'aruru. Wollo wokelu raram mehe inna aman suwar, de wayahue rira nakar. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Maa kan wa'an suware lolo nakar me'e, de rodi laa loiyedi paharne nanumene Firaun anan maeke nala, wayahue, nodi hi'i ananne. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Noho Mesir nina wanakuku wanayo'e na'akeme rodi wakuku ai penia nina honoli wenewhe noro nina wanakunu wa'an. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Rakan nina anna weli'akka, ai mehen hi'i kenekrohu lan ka'arala walin ri Israel enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","An lae ne, an do'on ri Mesir ida nukur walin ida, de ai nodiyala ri man lernala nuknukur onne, la nesnedi ri Mesir eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa pene'ek walinhe rauroinedi nahenia Makromod Lalap nair ai leke huriyedi hi nano kenern danalhe rahu eni, maa hi ka rauroin nina panaeku onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Rakan oreki, an do'on wali'ur ri Israel woro'o mahar wahihi'i, de nahehe paku woro'ohe leke rahuwa'an wali'ur, penia ai na'ukani hi na'ahenia, ‘Mi eniyenihe ma'ulosno ma'umo'onwali menee?! Alhi'ihepe mim wahi'ie?’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Maa ri man hudi walin onne nokuledi Musa laa herne, na'ahenia, ‘Inhoi man kikan o modi molollo mamwali man ho'ok kail mayai? ");
INSERT INTO kjeNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lo'o onuma panaeku mesne ya'u naisa oirawi mesne ri Mesir onne?’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","An derne wanakunu onneni horu, namka'uk me'e, de lari laedi Midian. Lere an minle enne an ho, la na'ori tatana mo'oni woro'o. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","An minle Midian anna weli'akka. Lerida ai mahan huri pipduma lolo noho mamu na'urani wo'or Sinai, an holikuku hophopon a'am raram ida aile ruri roke raram man ai lerlere mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","An po'on ai lerlere onneni an hehel rehi, penia an hoi na'urani leke nauroin kokkoo onne inhawe. Na'uraniyedi ne, an derne Makromod Lalap Lirna na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ya amwali o upun a'um Abraham, Isak noro Yakup rira Makromod Lalap man hi ra'uli rasa'eni.’ Ideweni Musa namka'uk wake'e, la narururu me'e, de an po'onedi herne ono ka naruri po'on ai lerlere onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Enine Makromod Lalap hopon na'ahenia, ‘Mohuwedi onuma pakpak ei eni, ono onno mamririri onne, moumou dewdewe. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ya'u mehe po'on ri Mesir eni hi'i Ainu'u ri enihe lernala kenerne danalha mamani. Ya'u dernedi rira sus mak oir me'e, de Ya'u kopuredi leke huriyedi hi nano rira kenerne danalheni. Ende lere eni me'ede ma'akene mala'a laa Mesir here.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stepanus konohi wali'ur man ho'ok kail onnenihe, na'ahenia, “Ler Musa ka namhara Mesir makun, ri Israel kar kokala ai. Lere onne hi ra'ahenia, ‘Inhoi kikan o mamwali man panulu noro man ho'ok kail mayai?’ Maa lere li'ur Makromod Lalap nodi Nin hophopon a'am raram, mehen kikan Musa eni namwali rira man panulu noro man huri we'er hi. Onne namwali lere an do'on aiye man lerlere ruri roke raram onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa eni penia ma nodi ri Israel enihe ramhara rano Mesir. An hi'i ha ri kan dodo'onnale makun lolo Mesir, lolo Kahi Memere, la lolo noho mamun ma napro'uk hehen nanumene anna weli'akka raramne. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa me'ene konohi ri Israel na'ahenia, ‘Lere man mai Makromod Lalap kikan mi upun anum ida namwali Nabi naise ya'u eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa eni nodi heri Israel lolo noho mamun ma napro'uk onne, la an laa wo'or Sinai derne la kokala Makromod Lalap Lirna nano hophopon a'am raram leke wali mai loikaru ik upud a'ad enihe. Ler onne an kokala Makromod Lalap Lirna Wawan ma nala or'ori dardari ma kan horu, leke rakan lere eni maika lernala haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Enimaa ik upud a'ad enihe ramhene derne rakani Musa, de lere an minle wo'or onne hi ra'okuledi ai, la lolo akinhe ra'ahenia, ‘Lo'o wa'an rehi ika wali wali'ur laa Mesir me'e!’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Enla hir hopon Harun ra'aheni, ‘Hi'iyala aukerhida woro'o mayai leke rodi molollo mayai la norle'ule'u norwaliwali yai, ono ai ka mauroin inhawa ma namwali noro Musa ma nodi ai mamharedi nano Mesir onne.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ende hir hi'i aukerhida naisa sapiyana, nanumene resne ha mormori rodi hoikani aukerhe onne. Horu ne, hir hi'i ya'an yomun lapa, la ra'uli rasa'a rira hini'i onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Enpenia Makromod Lalap waliyedi kili'urn, huri we'eredi hi hoikani lere, wollo, noro kaliyoro manina a'am eni. Onne penia namnenehe Makromod Lalap Lirna ma aile horok nabi enihe, na'ahenia, ‘Eih! Israel mie! Ler mim minminle noho mamu anna weli'akka raram, mi ka mesne ha mormori modi hoikani Ya'u, maa modi hoikani aukerhe noro noho makromon mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mim le'u aukerhe Molok noro aukerhe Refan ma naisa kaliyore noro rira heuheu mamani. Enpenia Ya'u huri mi leke manin Babilon enihe kerne dalha mi la rodi mi ko'u laa kota Babel wali enne.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stepanus na'aheni wali'ur, “Lere ik upud a'ad minle noho mamun ma napro'uk makun, Makromod Lalap hopon Musa nayapi Nin Tenda ma nodi kunukunohi nahenia Makromod Lalap aile hi leken kalarna. Ai na'ariri Tenda onne lernohi kanakarne noro lapanne man Makromod Lalap konohiyedi ai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ler li'ur rira ananhe kokala Tenda onne haenhi, rodie roro Yosua laa ra'ara lere Makromod Lalap rohiyedi rira arwali man holiholi iknika lekloi eniyeni. Tenda onne min lolo onne hehen nanumene rai Daud nina lere. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daud onne nahuwa'an Makromod Lalap akin, la napanak leke nayapi rom ida namwali Makromod Lalap man Yakup na'uli nasa'eni Nina miminlole, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","maa ka namwali. Anan Salomo nayapi Nina Romleu onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","I wal'uhe, yon makoto nahenia Makromod Lalap Man Kulu Narehi Man Lap Narehi eni holi lolo rom ri mormori rayayapi, ono nabi lirna aile ma na'ahenia; ");
INSERT INTO kjeNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘A'am onne namwali Ainu'u naikoro onno, la noho wawan namwali Ye ei'u onno, de ma'ariri inhawa rom Maya'u? I holi ewi leke warnala? ");
INSERT INTO kjeNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ya'u penia man hi'i hahaa na'akeme.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","I wal'u na'ahoru! Mi akim kerhe rehi la mi mamhene lernohi Roh Kudus wake'e naise mi upun a'um nonolu eni! Mi kilinna rohedi, de kam derne makani Ai Lirna me'e! ");
INSERT INTO kjeNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mi upun a'um na'akeme hi'i apipinha nabi na'akeme, la resne hi haenhi, ono nabi onnenihe konohi hi nahenia oreki inworo'o Makromod Lalap nala Hophopon Ma Namloleni mai. Hophopon onneni, Yesus, maiyedi me'e, maa mi ma'olu Ai male Nin arwali enihe, de minim hini'i eni, peni nesne Ai! ");
INSERT INTO kjeNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hophopon a'am raram mehen mai loikaruwedi Makromod Lalap Nin keneri hono'ok ki mi me'e, maa mi kam lernohie.” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Man ho'ok kail onnenihe derne onne horu, hir raram ha'a wake'e weuweur nihin a'arne. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Maa Roh Kudus nodi molollo Stepanus me'e, de an po'on laa a'am. An do'on Makromod Lalap Nina siksika lerlere, la an do'on Yesus namririri aile herne malanna. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ai na'ahenia, “Po'onale! Ya'u do'on a'am nahinariyedi me'e, la Ai ma namwali Ri Mormori Anan onne namririri aile Makromod Lalap herne malanna.” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ai na'aheni onne horu, heri pasunala kilinna, wakaukau, la ra'ouwale, ");
INSERT INTO kjeNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kele, soru laedi kote paharne mene wadesne. Man tumdesne Stepanus enihe, ruri rira rain nanaru, rale ma na'ikakida naran Saulus nadiyake. ");
INSERT INTO kjeNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mahar wawasle, Stepanus wakau na'ahenia, “Makromod Yesus, kokaledi ainu'u roh.” ");
INSERT INTO kjeNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Enine Stepanus laa yawa kadi ein korno la wakau, “Makromod, dohohaleni yono mala hi ra'uwara.” An wakau heheni, idewe aran horuwedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus me'ene ne'enohi hi resne Stepanus. Ler onne me'ede hir hi'i sus la hi'i apipinha Yerusalem nin kerei raramne na'akeme penia lariye'er rarari laa leke-leke ma aile Yudea noro Samaria na'akeme. Hophopon ma nodi Yesus Lirnenihe mehe ramkene Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ri ma namka'uk Makromod Lalap ida woro'o rodi Stepanus kemen laa rawilo'e. Hi rahere rehi ono raramhe penu, ");
INSERT INTO kjeNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","maa Saulus eni nahehe naiye'er rarari kerei raramne mamani. An lolo nakar laa nakar kele ma akin naili'il Yesus enihe soru laa bui. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Man lari enihe ramharedi Yerusalem me'e, la hir loikaru Makromod Lalap Lirna Wawa'an onne lolo ewi-ewi. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipus namhara nala'a laa kota Samaria la konohi hi panaeku ma na'ono Kristus man Makromod Lalap kikanedi namwali Rai laa ewi-ewi eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Heri onnenihe rakakani an loikaru Yesus Lirna Wawa'an onneni, la hir loi honorok nin loloi kakaru eni ono do'on an hi'i tanada ri kan dodo'onnala makun. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilipus rohi hayakyak man hu'uhu'ur ri raramne, (hayakyak onne wakaukau naruri mene ramhara ri raramne), la an hi'i wa'anedi ri nammori ma naplu'uk noro man liman ein yaka haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ende ri manina kota Samaria onnenihe akin nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lolo kote onne mo'oni ida aile narane Simon ma nadedem hi'i waliwali maka man lewlewen. Nalo'oledi manin Samaria onnenihe hehel rehi do'on nin waliwali maka lewlewen onne. Ai mehe na'uli kemen na'aheni ai penia man lewlewen lolo kota onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Enpenia kota onne ne'en raram na'akeme lernohi ainina hini'i onne mamani ra'ahenia ai onne lo'o nodi Makromod Lalap Nin molollo. Hir rapolu ai, “Papa Molollo Lape.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","An min lolo onne nalo'oledi me'e de, hi akin ka nahinuri nin hini'i onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Enimaa Pilipus maie ne, hir derne ai. Pilipus loikaru Lira Wawa'an man konohi hi'ihewi Makromod Lalap nodi molollo ri mormori, la an wakuku hi na'ahenia Yesus penia namwali Rai man huri we'er ri nano dohohala nin molollo. Enpenia mo'oni maeke nammori akin naili'il Yesus mene laa oir raram leke Pilipus ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon me'ene akin naili'il Yesus, de laa oir raram leke ulutade. Onne horu, an lernohi Pilipus mamani, la an hehel rehi po'on Pilipus nin hini'i ri kan dodo'onnala makun onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hophopon ma nodi Yesus Lirnenihe man minle Yerusalem derne nahenia manin Samaria enihe kokaledi Makromod Lalap Lirna Wawa'an me'e, de hir hopon Petrus noro Yohanis laa enne. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Ri Samaria enihe rodi Yesus Naran laedi oir raram leke ulutade me'e, maa kar lernala Roh Kudus makun. Petrus noro Yohanis rakanedi ne, hir hi'i lir napanak leke Makromod Lalap nala Roh Kudus ri Samaria enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Enla Petrus noro Yohanis kemenala liman ri Samaria enihe uluwakun, idewe hir kokaledi Roh Kudus. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon po'on hophopon ma nodi Yesus Lirna onnenihe kemenala liman hi uluwakun leke hir kokala Roh Kudus, ai nodi kupan laa Petrus noro Yohanis na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Pap mie, malala molollo maya'u here ke'e, leke i kemenala inhoi uluwakun, ri onne kokala Roh Kudus haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Maa Petrus walhe, “Modi onum kupane laa kawali pire ai porom raram! Yom makoto nahenia Makromod Lalap Nina nanala mayai eni rodi kupan welie! ");
INSERT INTO kjeNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","O akim ka namlolo Makromod Lalap kalarna, de onum molollo kaale howok ainima honowok enie. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ende sopoledi panaeku yaka onne, la mapanak Makromod Lalap leke nala ampun onum panaeku man ailanna onneni, ");
INSERT INTO kjeNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ono ya auroiroin nahenia o akim apinha ri, la dohohala nodi molollo o raramne.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Enime'ede Simon na'aheni, “Pap mie! Mararamyaka'u ke'e de, mapanak Makromod Lalap leke yon ha man om wakunkunu onne namwali maya'u!” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hir wakuku ri, la loikaruwedi Makromod Lalap Lirna Wawan lolo onne horu, Petrus noro Yohanis wali laa Yerusalem. Rala'e ne, hir kuli kuli Samaria nina leke-leke loikaru Makromod Lalap Lirna Wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lerida Makromod Lalap Nina hophopon a'am raram ida mai Pilipus na'ahenia, “Mala'a laa karanna laa kalla ma nano Yerusalem laa Gasa, kalla man ri ka nadedem lole.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Enime'ede Pilipus nala'a me'e. Ler onne manin Etiopia ida nano Yerusalem wali laa nina lekloi lolo kalla onne haenhi. Ai onne or'onno lalap ida ma nadiyaka Kandake nina kanaru na'akeme. Kandake onne namwali Etiopia nin rai maeke. Or'onno lalap onne na'uli nasa'edi Makromod Lalap lolo Yerusalem me'e, de wali laa nin leke me'e. Ai naikokoro nina kerete wawan, mahan lelese nabi Yesaya nin horok. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roh Kudus hopon Pilipus, “Laa ma'uraniyala kerete onneni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipus laa na'uraniyedi kerete onneni ne, an derne ri onne mahan lelese Yesaya nin horok. Ai na'ukaniyale na'ahenia, “Hi'ihewi? Makrom'u lese horok onneni mauroin nin panaeku, ee ka?” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","An walhale, “Lo'o ri ka napa'ahe, hi'i hehewi ya auroin nin panaeku?” Enime'ede ai naka'uk Pilipus, “Mai ha'a wewerre ainu'u kerete.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Horok Lape Lirna an lelese onne na'aheni heheni, ‘Ai onne, naisa pipduma waku ida man rodi laa resne, la naisa pipduma man makromon tori wulunne, maa ka na'umee, ai me'e ne ka na'oho, kan wakunu haida. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ri na'ihoru na'idaru Ai onne, la nala hunukum ma ka namnenehe na'alono hono'ok kanail ma namlolo. Ai kan minle noho wawan nalo'ol, ono ri nesne ai penia upun anan kaale me'e, de ri kan horok me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Or'onno lalapa onne na'aheni Pilipus, “Pipduma onne wekel inhoi? Nabi Yesaya mehen wekel kemen, ee ri namehin?” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Enime'ede Pilipus napa'aha Horok Lapeni Lirna La'an leke konohi ai Yesus Nin wanakuku wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hir raikoro ai kerete makun, rakan onnida oir aile, de ri Etiopia na'ahenia, “Po'onale, oire me'eni me'e! Inhawa kawala ika makun penia kam ulutada ya'ue?”  ");
INSERT INTO kjeNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipus na'ahenia, “Lo'o makrom'u akin naili'il Yesus kokkoo, ik kala'a oire leke ulutade pape.” An walhale, “Ya akin naili'il Yesus Kristus eni namwali Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ende an hopon ma nodi kerete paliyedi lolo onne, la woro'ohe kopur laa oir raram nanumene Pilipus ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hi ramharedi oir raram mai paharne, namlilinnohi Makromod Nin Roh naledi Pilipus laa onno namehin, de Etiopia onne kan do'on ai me'e, maa ai akin nahuwa'an wake'edi me'e, la nala'a mamani laa nina leke. ");
INSERT INTO kjeNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipus onne, namlilinnohi aiyedi leke ida naran Asdod. Ai namhara leke onne laa mamani wali ra'i, loikaru Makromod Lalap Lirna Wawa'an eni lolo leke-leke na'akeme hehen nanumene rakan Kaisarea. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ler Pilipus mahan laliwewer leke-leke onne, Saulus nanoinoin ri man lernohi Yesus enihe leke aka'uku la nesne hi. An laa imam man kulu narehi, ");
INSERT INTO kjeNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","napanak horok molollo ida leke nodi laa uluwakun kerei Yahudi enihe lolo kota Damsyik. Ainin panaeku nanoin ri manin Damsyik man lernohi Yesus Nina Kalla, mo'oni maeke, kele, la nodi laa Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","An laa na'uranrani kota Damsyik onneni, namlilinnohi ropropida mai nano lanik siksika wake'e, idewe pupinedi Saulus. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Idewe ai nalwali yawa, la derne lira ida ma na'ahenia, “Saulus! Saulus! Hi'ihepenia om hi'i sus Ya'u?” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulus na'ukaniyale, “Makrom'u, inhoi O?” An walhale, “Ya'u eni Yesus man om hihi'i suse. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mamririyedi! Mala'a laa kote raram. Rakan lolo onne rin konohi o hi'i inhawa.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nina kalla wali enihe ramka'ukedi, ka rauroin wakunu me'e, ono hir derne lir onneni, maa kar do'on ri man wakunu onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Enla, Saulus eni namriri, hari makan, maa makan tokedi me'e, de hi ri'ik roro laa Damsyik. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Min enne, lere wokeluwedi ai kan do'on haida-haida, la ka na'ak, ka nomun haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ler onne ri man lernohi Yesus ida naran Ananias aile Damsyik. Ai mehen do'on haida nano Makromod Yesus naisa namarmi. Lolo ha man ai mehen do'on onne, Yesus napolu, “Ananias!” An walhe, “Makromod, eni ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Makromod hopon na'ahenia, “Mala'a here! Lolo kalla ma naran ‘Kalla Namdudu’ laa Yudas nin nakar. Lolo nakar onne manoin mo'oni ida naran Saulus, manin kota Tarsus. Ai onne mahan hi'i lir napanak, ");
INSERT INTO kjeNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","la lolo haida man ai mehen do'onedi me'e, an dodo'on ri ida ma naran Ananias mai nala liman loile ai uluwakun wawan leke makan mou wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias walhe, “Wa'an Makrom'u, maa ya'u dernedi ri nammori kukunohi nahenia ri eniyeni nodi rurilai hi'i sus Num ri ma aile Yerusalem enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Enla lere eni me'ede an mai eni nodi molollo nano imam man kulu narehi leke kele ri ma akin naili'il ki O na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Maa Makromod na'ahenia, “Ananias! Ya'u niliyedi ai me'e leke howok Ainu'u honowok eni, de yon mamka'uk. Mala'a here. Ya'u nili Ai leke loikaru Ya'u Naran laa ri Yahudi noro ri ma ka namwali Yahudi enihe, noro rira rai-rai haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ya'u mehe konohi ai nahenia na'amoli an lernala apipinha nammori ono an lernohi Ya'u.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ende Ananias nala'a laa nakar onne, la nala liman loile Saulus wawanne. Ai na'aheni, “I wal'u Saulus! Makromod Yesus man om dodo'on lolo kalla lere om mamai eni, Ai penia man hopon ya'u mai leke i wal'u makan mou wali'ur, leke Roh Kudus nala molollo ki o.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Idewe ha ma naisa i'in di'ikne man minle makan nadiyauredi, idewe makan mou wali'uredi. Ai namaka, nala'a laa oir leke Ananias ulutade. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Onne horu, ai na'ane, la kemen naruri wali'uredi. Onne horu, Saulus minle Damsyik alam wokelu wo'akka noro man lernohi Yesus enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","An laa idewe Yahudi rira kerei-kerei loikaru Yesus Lirna na'ahenia, “Yesus onne penia Makromod Lalap Ananne.” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ri na'akeme man derne Saulus wakunu mehe kakaiyedi, la hehel rehi ra'ahenia, “Hi'ihepenia an wakunu heheni? Oirawi inworo'ohe onneni an kele man lernohi Yesus enihe lolo Yerusalem, nahehe nesne horu, la lere eniyeni ainina panaeku mai eni kele ri nodi laa imam lalap enihe leke rala hunukum harome!” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Maa Saulus nina wanakuku eni, eren nalolo'ol eren nana'an ri akin, penia Yahudi man minle Damsyik enihe mehe kakaiyedi, ka rauroin walha nin wanakuku me'e. Ai na'amou na'aropedi kokkoo panaeku ma nodi kunukunohi nahenia Yesus onne namwali Ai man Makromod Lalap kikanedi namwali Rai laa ewi-ewi me'eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","An min lolo onne nalo'oledi tarana mene Yahudi enihe paeku kelewuku leke resne. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Hirira panaeku radiyaka kote nina nika na'akeme lelere a'alam leke resne Saulus, maa an dernedi rira panaeku yak onne, ");
INSERT INTO kjeNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","de a'alam ida nin muku man lernohi Yesus enihe rala ai loile lo'or raram mene ralkopur laa yawa lewen lukur kukulu man rodi kawkawa kote paharn, leke an lari laa Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Rakanedi Yerusalem, Saulus nahehe noro ri man lernohi Yesus enihe lawuku, maa hi ramka'uk ai, ono ka rauroin nahenia namlolo kokkoo an lernohi Yesus, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Enimaa Barnabas lan lariyala ai rala'a wewerre leke roro hophopon ma nodi Yesus Lirnenihe pakromo. Barnabas konohi hi'ihehewi Saulus do'on Yesus lolo kalla man laa Damsyik, la hi'ihehewi Makromod Yesus wakunu noro ai. An konohi hi hi'ihehewi Saulus ka namka'uk nodi Yesus Naran wakuku manin Damsyik onnenihe haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Enime'ede Saulus noro hi min wewerre Yerusalem, la ka namka'uk nodi Makromod Yesus Naran wakuku Yerusalem ne'en raram na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ai noro ri Yahudi man wakunu Yunani enihe, wakunu la raherre honorok panaeku, maa hi kar kokale de rahehe ranoin kalla leke resne. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ai walinhe dernedi rira panaeku yak onneni ne, hi roro Saulus laedi Kaisarea mene hopon ai nala'a laa Tarsus. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Enine man lernohi Yesus lolo Yudea, Galilea, noro Samaria na'akeme holi namlina namkai ono ri kan hi'i apinha hi. Ler onne Makromod Lalap na'alapa kerei raramne akinhe, de eren ramkene lernohi Yesus. Hirira honoli ramka'uk Makromod Lalap, la Roh Kudus na'alap hi akin, de kerei raramne eren na'uwawali. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus laliwewer ka'arala man lernohi Yesus enihe, de lerida an lole kota Lida. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lolo onne an holikuku mo'oni ida naran Eneas ma naplu'uk nap'ekeredi anna wo'aa me'e, ka namaka nano piki luni. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus na'aheni ai, “Eneas! Yesus Kristus hi'i wa'anedi o me'e, de mamakedi la ma'akenedi onum piki luni here!” Idewe namakedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ri manina Lida noro Saron do'on Eneas wa'anedi, hi na'akeme akin naili'il Makromod Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kote ida aile naran Yope ma kan ko'uwala Lida. Lolo onne maeke ida aile naran Tabita, la ai onne man lernohi Yesus. Naran ‘Tabita’ eni namnenehe naran ‘Dorkas’ rodi wanakunu Yunani, la napa'ahne, ‘ruse’. Ai eni hi'i ha man wa'an mamani, la an paku ri nammori ma na'alehe naulinu. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ler onne ai nakni'ir de makiyedi. Walinhe raroho ihin kemen horu, rale laedi kamar nowawanne. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Man lernohi Yesus lolo Yope derne Petrus aile Lida, de hir hopon ri woro'o rodi nou laa rapanpanakedi Petrus, “Halhaledi mai Yope nanu!” ");
INSERT INTO kjeNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Konohiyedi Petrus ne, ai noro hi ra'alono peleklekedi laa enne. Hir rakanedi enne ne, hi rore laa kamar nowawan. Maeke walwalum ma nahehere lolo onne mai lupurala Petrus kukulle rira nainairi man Dorkas hohour nala hi eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Enime'ede Petrus hopon hi laedi paharne, la an kadi ein korno yawa hi'i lir napanak. Hi'i lir napanak horu, nakpaliyala Dorkas ihin kemen na'ahenia, “Tabita, mamakedi!” Idewe Tabita makan mouwedi, po'onala Petrus, namaka, naikoredi. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Enine Petrus nasala liman leke paku na'ariri. Ai namririyedi, Petrus napolu maeke walwalum roro ma akin naili'il Yesus lolo onnenihe leke mai hir do'on rauroin maeke man maki onne mori wali'uredi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ha ma namwali onne raderre radaul lolo Yope ne'en raram na'akeme penia ri namansa akin naili'il Makromod Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus min Yope nalo'oledi tarana noro mo'on ida naran Simon. Ai onne nin honowok akilere na'akene ha mormori ulikin leke rodi ra'olu. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lolo kota Kaisarea mo'oni ida aile naran Kornelius. Ai onne namwali uluwakun ara ma nodi molollo ma nasala ke'urauk rahu ida ma nano hair Italia. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ai noro nina nakar raram ramka'uk Makromod Lalap, de ra'uli rasa'a Ai mamani, kade hi ka ramwali ri Yahudi. Ai nala kupan nammori ri Yahudi ma na'alehe haida-haida, la an hi'i lir napanak laa Makromod Lalap mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lerida lere mamamal Makromod Lalap hi'i haida harile Kornelius mehen do'on. Lolo ha onne an do'on mouropo Makromod Lalap Nina hophopon a'am raram ida mai napolu ai, “Kornelius.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius po'on hophopon a'am raram onneni ne, ai namka'uk wake'edi me'e de na'ukani, “Makrom'u nodi inhawa panaeku?” An walhe, “Makromod Lalap kokaledi onum lir napanak, la kan hamlinu onum hini'i wawa'an rahu laa ri ma na'alehe haida. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ende lere eniyeni hopon ri ida woro'o laa Yope lariyala Simon Petrus wali mai eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","An min noro Simon ma nadedem na'akene ha mormori ulikin. Simon onne nina nakar aile herraram.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hophopon a'am raram onne nala'edi ne, Kornelius napolu nina hophopon mo'oni woro'o roro nina ma nasala ke'urauk ida ma namkene nadiyaka ai. Ma nasala ke'urauk onne namka'uk Makromod Lalap haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelius konohi hi ha wo'ira na'akeme man hophopon a'am raram konohiyedi ai me'e. Onne horu, an hopon hi rala'a laa Yope. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Rakan orekiyedi, wokeluhe ramhara Kaisarea rala'a Yope me'e. Hi kar rakan Yope makun, Petrus ha'a laa onno ma aile nakar wawan leke hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na'ikeki lere ulu me'e de, ai namlaredi me'e. An newnewek ra'akene hanana'an lere u'ulu nine, Makromod Lalap nalhari haida ai mehen do'on. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","An po'on lanik nahinariyedi, do'on haida naisa tapi ma naphari, huhun wo'akkenihe naha'ilorlore, ku'uku'u mai noho wawan. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tapi raram onne, ha mormori ma ein wo'akka na'akeme aile, ha mormori ma na'ina'ik noro manu merwui na'akeme aile. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ka nalo'ol, an derne lir ida na'ahenia, “Petrus, laa malle mesne here, leke mo'on.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Maa Petrus walhale, “Eih, Makromod! Ha mormori eniyenihe heruwali morso de luli ra'an, peni ka o'onala makun.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Maa lir onne na'aheni wali'ur, “Inhawe man Makromod Lalap na'aheni mou, yom ma'aheni, ‘Ha onneni morso, de luli yo o'on!’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Petrus do'on ha ma namwali onne rakan rewkelu nanumene tapi an dodo'on onne mehen nakinikanedi wali'ur laedi a'am. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus mahan nahehe nauroin hahaa an dodo'on onneni nina panaeku inhawa ne, Kornelius nina hophopon wokelu ma nanoin Simon nin nakar enihe rakanedi nina nike makan me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hi ra'ukani ra'ahenia, “Peina'a ma naran Simon Petrus aile mai enie?” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus mahan nahehe nauroin ha an dodo'on onneni nina panaeku inhawa, la Roh Kudus na'aheni ai, “Petrus, mo'oni wokelu maha ranoin o. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kopur laa yawa, yono mamkauk moro hi mala'a, ono Ya'u penia man hopon hi mai eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Enime'ede Petrus kopur laa yawa ne'el wokeluhe na'ahenia, “Ya'u eni peni paphe ranonoine! Ik kodi inhawa panaeku mai eni?” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hir walhe, “Uluwakun ara ida naran Kornelius hopon am mai eni. Ai onne ri molololo, la namka'uk Makromod Lalap. Yahudi enihe na'akeme horhawe rehi. Makromod Lalap Nina hophopon a'am raram man moumou dewdewe ida hopon an polu papa la'ala nina nakar, leke an dernala papa nala inhawa wanakunu mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Enine Petrus lariyala hi laa raram leke minala lolo onne. Orekiyedi mene noro hi rala'a. Ri Yahudi man lernohi Yesus ida woro'o ra'alono haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Alam ida horu, hir rakanedi Kaisarea. Kornelius mahan lalapan, la lariyaledi walinhe noro nina ri orwali rarani enihe roro ai lapan wewerre haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrus rakan nika makan ne, Kornelius lan rawa yawa la lariyale. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Maa Petrus roul liman na'aririyedi la na'aheni, “Yom hi'i heheni, mamririyedi! Ya'u eni ri mormori naisa papa haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kame'ede Kornelius namririyedi, la mahar wakunkunu woro'ohe laa romleher. Laedi romleher ne, Petrus do'on ri namansa lawukuwedi lolo onne me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ai ne'el hi na'ahenia, “I walin na'ahohoru mehe mauroinedi Yahudi rira holoor halauk me'e. Holoor halauk onnenihe nou mayai Yahudi enihe na'ahenia, ‘Yon ka'ar, ee minwuku noro ri ma ka namwali Yahudi naisa mi eniyenihe.’ Maa Makromod Lalap kukuledi panaeku namehin maya'u me'e, de kan wa'an ya ahinorok nahenia ri namehin morso me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Enpenia papa polu pelekleke mai ne, ye e'enohi. Ende ya'u raram nodi auroinala papa nina panaeku inhawa penia polu ya'u maie?” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Enime'ede Kornelius walhe na'ahenia, “Alam wokelu man laedi eni, lo'o lere mamamal naisa eniyeni, ya'u mahanoro hi'i lir napanak min nakar. Ya amlilinnohi mo'oni ida man nair nainair hikhika wake'e namririri ya'u kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ai na'ahenia, ‘Kornelius! Makromod Lalap kokaledi onum lir napanak me'e, la kan hamlinu onum hini'i wawa'an eni, ");
INSERT INTO kjeNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","de Ai napanak om hopon ri ida woro'o laa Yope lariyala ri ma naran Simon Petrus roro mai. Ainin miminlole aile herraram minle Simon ma na'akene ha mormori ulikn nin nakar.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Onne penia pelekleke ya'u hopon ri ki polu makrom'u, la makrom'u akin wa'an rehi de aiyedi mai eni me'e. Enpenia mayai na'akeme maiwukuwedi Makromod Lalap kalarna me'e, leke am derne makani inhawe Makromod Lalap hopon makrom'u konohi mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Enime'ede Petrus na'ahenia, “Eni mene ya auroin kokkoo Makromod Lalap ka na'ili naloho ika ri mormori eni, ");
INSERT INTO kjeNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","maa An kokala ri na'akeme nano noho pa'i'ik rai pakakar horo hi ramka'uk Ai la hi'i ha ma namlolo mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mi mehe mauroinedi Lira man Makromod Lalap naledi mayai ri Israel enihe me'e. Onneni Lirna Wawa'an man konohi hi'ihewi Yesus Kristus du'ul kali wali'ur ika ri mormori eni koro Makromod Lalap, la Yesus onne namwali ri mormori na'akeme Makromon. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mi me'ene mauroin Lirna ma naderre nadauledi lolo noho Yudea ne'en raram me'e. Yohanis mai wakuku ri leke herre rira morimori ma ka namlolo la derne rakani Makromod Lalap mene laa oir raram ulutade. Yohanis mai wakuku onne horu mene rin derne panaeku ma na'ono Yesus lolo Galilea. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","I walin lo'o mauroinedi Yesus ma nano Nazaret onne nina morimori me'e. Mi mauroin Makromod Lalap kikanedi Ai namwali Rai, la nala Roh Kudus Ai, la nala ke'eke'el an'anha Ai haenhi. Lolo ewi-ewi Yesus hi'i ha man wa'an, la hi'i wa'an ri na'akeme man Hayakyak Makromon kerne dalha, ono Makromod Lalap norle'ule'u norwaliwali Ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mayai eniyenihe mehem do'onedi An hi'i ha wo'ira na'akeme lolo Yahudi rira nohe rakan Yerusalem haenhi. Lolo onne hir wairesne lolo au kekiyowok eni, ");
INSERT INTO kjeNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","maa rakan lere wokelu Makromod Lalap na'ori Ai wali'ur nano makmaki, la hi'i ri mormori do'on Ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ri na'akeme kar do'on, maa mayai mehe man Makromod Lalap nili leke namwali Nina man kuku maka, man mo'on momun wewerre moro Ai lere An mori wali'ur nano Nin makmaki. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","An hopon mayai loikaru Lirna Wawa'an eni laa ri na'akeme, la kukunohi hi nahenia Ai penia Makromod Lalap niliyedi namwali man ho'ok kail ri na'akeme, ri man mormori makun noro ri man makiyedi haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nabi nonolu na'akeme wekel Yesus haenhi ra'ahenia ri na'akeme ma akin naili'il Yesus, Makromod Lalap na'ohu nahaledi rira dohohale me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus wakunkunu makun, Roh Kudus kopur mai ri na'akeme man derne lirna onne honorok akinhe. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ri Yahudi ma akin naili'iledi Yesus man lernohi Petrus nano Yope, hir heheledi, ono hir do'on Roh Kudus kopur laa ri ma ka namwali Yahudi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hi rauroin mouropo nahenia ma ka namwali Yahudi enihe kokaledi Roh Kudus ono hir derderne ri ma ka namwali Yahudi enihe wakunkunu rodi wanakunu man mai nano Roh Kudus ra'uli rasa'a Makromod Lalap. Enine Petrus na'ahenia, “Po'onale, ");
INSERT INTO kjeNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ri eniyenihe lernaledi Roh Kudus me'e naisa maika nonolu eni, de wa'an rehi hir laa oir leke ulutade.” ");
INSERT INTO kjeNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Enpenia Petrus hopon hi rala'a laa oir leke ulutade nodi Yesus Kristus Naran. Onne horu, hi rapanak Petrus minala alam ida woro'o noralahe. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lolo Yerusalem hophopon ma nodi Yesus Lirna roro walin man lernohi Yesus enihe derne nahenia ri ma ka namwali Yahudi enihe kokaledi Makromod Lalap Lirna Wawan me'e haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Enpenia lere Petrus laa Yerusalem, Yahudi man lernohi Yesus ida woro'o mai rodi ahan ra'ukani ai, ");
INSERT INTO kjeNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Hi'ihepenia om hi'i ha ma kan lolo ri raram mala'a laa ri ma kar sunat rira nakar moro ma'ake?” ");
INSERT INTO kjeNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Enime'ede Petrus loikaru panaeku onne na'akeme nano dedesne rakan honon na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ya'u mahanoro hi'i lir napanak min kota Yope, ya amlilinnohi i do'on haida naisa tapi ma naphari ida rala kopur nano a'am mai yawa, maa tapi onne huhun wo'akkenihe naha'iloloro rakan ya'u kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ya'u po'on a'inau tapi onne raramne, i do'on ha mormoriyana ma ein wo'akka, ha mormori man merwui, ha mormori ma na'ina'ik roro manu merwui haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ya'u derne lir ida na'ahenia, ‘Petrus, laa mala mesne, leke mo'on here!’ ");
INSERT INTO kjeNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Maa ya'u walhe, ‘Makromod, luli yo o'on! Ka o'onala hanana'an man morse naise eni makun. Hanana'an eni ainim agame nin holoor halauk penia na'ahenia morso de luli ra'an.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Maa lir ma nano a'am raram onne na'ahenia wali'ur, ‘Inhawe ha man Makromod Lalap na'aheni mou de kan luli ra'an, yon ma'aheni morso!’ ");
INSERT INTO kjeNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Panaeku i dodo'on onne namwali rakan rewkelu. Onne horu, tapi ma naphari onne noro raramne mehen nakinikan wali'uredi laa a'ame. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Onne horu, hophopon wokelu rano Kaisarea mai nakar i miminle. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roh Kudus hopon maya'u, ‘Yon mamka'uk moro hi ma'alono laa Kaisarea!’ Yo oro i walin Yahudi woneme ma'alono laa Kaisarea haenhi. Mayai na'akeme laa Kornelius nina nakar. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","An konohi mayai hi'ihehewi an do'on hophopon a'am raram ida mai namriri nina nakar raram na'ahenia, ‘Hopon ri ida woro'o laa Yope lariyala mo'oni ida naran Simon Petrus moro mai nakar, ");
INSERT INTO kjeNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","leke ai nala wanakunu ma nala or'ori dardari man wa'an ki o moro num nakar raramne na'akeme.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ende ya'u wakunkunu heheni hi, Roh Kudus kopur mai nala molollo hi naisa namwali maika nonolu eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Enine ya'u horoknaledi Makromod Yesus Lirna ma na'ahenia, ‘Yohanis nodi oir ulutada ri, maa oreki inworo'o mi eniyenihe, Makromod Lalap ulutade mi nodi Roh Kudus!’ ");
INSERT INTO kjeNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ende ha onne namwaliyedi me'e. I wal'uhe, Makromod Lalap nala hi ma ka namwali Yahudi, panaeku ma namnenehe Ai nala maika, ono ika na'akeme akin naili'il Makromod Yesus Kristus. Ende ya'u lo'o kawala Makromod Lalap hehewi?” ");
INSERT INTO kjeNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hir dernedi panaeku onneni, hi ka rawalha lira me'e, maa ra'uli rasa'a Makromod Lalap ra'ahenia, “Panaeku onne namlolo, lo'o Makromod Lalap naledi leken paharin ri ma ka namwali Yahudi enihe haenhi, leke hir herre rira morimori ma ka namlolo, mai lernohi Makromod, la lernala or'ori dardari ma kan horu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ler Stepanus makiyedi onneni, ri ma akin naili'il Yesus enihe lariye'er rarariyedi, ono ri ma kan lernohi Yesus enihe kerne dalha wake'e hi. Heruwali lari rakan noho Finesia, heruwali rakan noho Siprus noro kota Antiokia. Hir lae ne, hir loikaru Makromod Lalap Lirna Wawan laa ri Yahudi enihe mehe. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Enimaa ri man lernohi Yesus heruwali ma nano kota Siprus noro kota Kirene rala'a laa Antiokia loikaru Lira Wawa'an ma na'ono Makromod Yesus eni laa ri ma ka namwali Yahudi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Makromod Nina molollo aile hi penia ri ma ka namwali Yahudi enihe derne rakani rira wanakunu onne, de lernohi Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yerusalem nin kerei raramne derne inhawa ma namwali lolo Antiokia eni, de hir hopon Barnabas laa enne. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","An rakanedi, ai akin nahuwa'an wake'e ono do'on hi'ihehewi Makromod Lalap namre'e namharu heri onne. Ende an wakuku la na'alap hi akin leke ramkene lernohi Makromod Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas eni akin wa'an, la Roh Kudus nodi molollo ai mamani, la ai akin namkene naili'il Makromod, de ri namansa derne ai la lernohi Makromod Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Enime'ede Barnabas nala'a Tarsus nanoin Saulus. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hir pakromedi, ai noro Saulus wali wali'ur laa Antiokia. Annida raram, hi roro kerei raramne lawuku mamani la hir wakuku ri nammori. Lolo Antiokia eni lere dedesne wake'e rin waki man lernohi Yesus enihe ‘Kristen’. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ler onne nabi ida woro'o rano Yerusalem mai Antiokia, ");
INSERT INTO kjeNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","la nano hi, nabi ida aile ma naran Agabus. Lerida ai namriri heri kalarna, la Roh Kudus nodi molollo ai de an wakunu ha ma namwali lere man mai na'ahenia, “Oreki inworo'o noho wawan na'akeme lernala roulara lapa.” (Panaeku onne namwali kokkoo lere rai Kaisar Klaudius nodi molollo.) ");
INSERT INTO kjeNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hir derne onne horu, man lernohi Yesus enihe lawuku honorok panaeku puli kupan aku laa walinhe man minle Yudea. Man lernala nammori nala nammori, man lernala tarana nala tarana. ");
INSERT INTO kjeNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hir puliyedi kupan onneni, hir hopon Barnabas noro Saulus rodi laa ralle uluwakun man lernohi Yesus enihe ma aile Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ler onne rai Herodes nodi rurilai kele ri ida woro'o ma aile kerei raramne leke hi'i apinpinha hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","An hopon ri nodi raa nesne Yohanis mo'oniwalla Yakobus. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodes po'on nin hini'i onne nahuwa'an Yahudi ma akin ka naili'il Yesus akinhe, de an hopon ri kele Petrus haenhi. Panaeku onne namwali Yahudi nin Lere Alam Lalapa Ra'an Roti Ma Na'alehe Ragi. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hir kele Petrus rale laedi bui raram ne, rai Herodes hopon ma nasala ke'urauk idaweli woneme radiyaka na'apiku lolo onne. Hir ha'ar namwali muku wo'akka leke ida man herre ida. Herodes nin panaeku lapan rir Lere Alam Lalap Paska horu mene ho'ok kail Petrus lolo heri na'akeme kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ende Petrus minle bui raram, maa kerei raramne hi'i lir napanak mamani leke Makromod Lalap paku nala kalla ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A'alam ida nine, Petrus namkuru mahmahal lolo ma nasala ke'urauk woro'o leken, la rodi rantan wukwuku ai liman woro'o noro ma nasala ke'urauk woro'o liman haenhi. Ma nasala ke'urauk namehin radiyaka nika makan haenhi. Herodes nin panaeku oreki al'alam rodi laa heri kalarna leke hukumesne. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Maa a'alam onne namlilinnohi hophopon a'am raram ida mai namriri lolo nin kamar raram, de hikhika lolo kamar onne raram. Hophopon onne roulle Petrus nado'e na'ahenia, “Heih, heih, mamakedi nanu!” Idewe rantan rodi wuwuku liman onne mehe nawine'eredi. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Onne horu hophopon onne hopon na'ahenia, “Nairedi num nainair, la ma'akerhedi num pakpak ei here.” Petrus hi'i onne horu, an hopon wali'ur, “Nairedi num rain nanaru, kala'a here!” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petrus lernohi ai ramhara nano bui raram. Ai ka nauroinnala hophopon a'am raram onne hi'i ha ma namwali kokkoo, maa ai nauroin nahenia namarmi mehe. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hir lewenedi muku ma nadiyaka dedesne noro rewro'o nine, rakanedi nike lapa man rodi pesi hihi'ie man laa paharneni. Enine nika mehen nahinariyedi, de hir laa paharne, rala'a. Kan ko'uwala namlilinnohi hophopon a'am raram onne mehen moluwedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eni nanumene Petrus nauroinnala ha onne namwali kokkoo. Ai mehen hehel kemen na'ahenia, “Eih, kokkoe! Makromod Lalap hopon Nina hophopon mai, de huriyedi ya'u nano Herodes liman raram, la huriyedi ya'u nano hahaa na'akeme man ri Yahudi enihe lo'o hihi'i maya'u eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kame'ede ai nala'a Maria, Yohanis inna nina nakar. (Yohanis onne rapolu Markus haenhi). Lolo nin nakar onne, ri nammori aile mahar hi'i lir napanak. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrus rakan nakar nin nika lap eni, disne nike. Maeke hophopon ida naran Rode laa leke hari nikeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrus napolu, idewe ai nauroinnala lirna, de akin nahuwa'an wake'e penia an hamlinu hari nika, maa lari wali'ur laa romleher! An laa konohi heri onneni na'ahenia, “Petrus aile paharne.” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hir walhe, “O ma'iseri haromo!” Maa Rode na'aheni mamani, “Kokkoo! E'eni, Petrus.” Enimaa hi ra'ahenia, “Ah, onne lo'o nina hophopon a'am raram harome!” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hi mahar wakunu, Petrus disne nike mamani. Kame'ede hir laa hari nike, po'one, rauroin kokkoo ai onne Petrus. Hi na'akeme hehel rehi. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus nodi liman dadiyala, “Karkaramedi.” Enine an konohi hi hi'ihehewi Makromod nodi ai namhara nano bui raram, la an hopon hi, “Lam konohi panaeku ma namwali eni laa Yakobus noro ik walinhe namehin haenhi.” Onne horu, ai kan min lolo onne me'e, maa nala'edi onno namehin wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Rakan oreki al'alam ma nasala ke'urauk ma nadiyaka Petrus onnenihe ramka'uk wake'e, de ida man rusu arra noro ida ra'ahenia, “Inhawe namwaliyedi noro Petrus me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes derne Petrus kaale bui raram me'e, an hopon ma nasala ke'urauk enihe lalaa mamai ranoin Petrus, maa kar do'one. Kame'ede Herodes polu ma nasala ke'urauk ma nadiyaka na'akeme mai, sisnai nanumene resne mouwedi. Onne horu Herodes namharedi Yudea nala'a Kaisarea min lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Lerida Herodes na'ahan wake'e ri manin kota Tirus noro kota Sidon. Enpenia hi rodi honorok panaeku mahaku laa Herodes leke wa'an wali'ur noro ai, ono hi radedem kokala hanana'an nano ainin noho. Hir rakanedi ne, hir nori Blastus ma namwali uluwakun lolo Herodes nin nakar romleher, leke an paku hi rakpali Herodes. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ende rakan lere hi rakpali Herodes, an nairedi nina nainaire man kukulu lalape, la naikoro kadere molollo mene wakunu heri kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Hir derne Herodes wakunu horu, hi ra'uli rasa'e, wakau ra'ahenia, “Ik derne lirna eniyeni naise noho makromon lirna, ri mormori, ka.” ");
INSERT INTO kjeNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ler onne me'ede hophopon a'am raram nala apinha ida walile Herodes ono an holi kukulu lalapa, la kan horhawa Makromod Lalap. Ka nalo'ol ne, maki me'e ono sususu na'an riki raramne. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Makromod Lalap Lirna Wawan eni eren raderre radaul, la man derne nakani eren na'uwawali. ");
INSERT INTO kjeNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas noro Saulus rala'a laa Yerusalem ha'ar kupan pulipuli horu ne, roro Yohanis wali wali'ur laa Antiokia. (Yohanis eni rapolu Markus haenhi). ");
INSERT INTO kjeNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lolo Antiokia nin kerei raramne nabi-nabi roro meser-meser aile: onnenihe Barnabas, Simeon (waki Mau Mohon), Lukius nano Kirene, Saulus, noro Menahem (ai eni wayahu lapa wewerre noro rai Herodes). ");
INSERT INTO kjeNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hi maha ra'uli rasa'a Makromod la ra'aluli kemen ka ra'ak ne, Roh Kudus hopon hi na'ahenia, “Ma'onnedi Barnabas noro Saulus Maya'u, leke hir howok Ainu'u honowok man Ya aledi hi me'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ende hi ra'aluli kemenhe ka ra'ak la hi'i lir napanak horu, hir kemenala limanhe Barnabas noro Saulus uluwakun wawan mene huri woro'ohe rala'a. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Roh Kudus naledi molollo Barnabas noro Saulus loikaru Lira Wawa'an eni me'e, de hir kopur laa lour laa kota Seleukia, mene ha'a kapal laa noho Siprus. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yohanis (rapolu ‘Markus’ haenhi) lernohi Barnabas noro Saulus leke pakuwala hi haenhi. Rakanedi kota Salamis, hir loikaru Makromod Lalap Lirna Wawan eni lolo Yahudi rir kerei-kerei. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hi ramhara Salamis, hir kuli kuli hehen nanumene rakan kota Papos. Rakan lolo onne, hir holikuku mo'oni Yahudi ida narane Bar Yesus (rodi wanakunu Yunani rapolu Elimas). Ai eni ri man hi'i u'ur leher. Ai mehe na'aheni ai onne Makromod Lalap Nin nabi, maa ka namlolo. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Elimas eni namwali na'aromwali ri ida ma naran Sergius Paulus. Sergius Paulus namwali gubernur noho onne, la ai onne ri ma nauroin. Ai napolu Barnabas noro Saulus mai, ono ai raram nodi derne Makromod Lalap Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Enimaa Elimas (ma naran napa'ahne, ‘ma nauroin hi'i u'ur leher’), ai onne nadiyaka gubernur akin leke yono naili'il Yesus, penia noro Barnabas la Saulus nawalha lira mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Maa, Roh Kudus nala molollo Saulus (rapolu Paulus haenhi), penia an po'on desnala ri man hi'i u'ur leher onne na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Heih! Hayakyak Makromon anan, o! O modi konoko wunudi mamani. O kam suk honorok panaeku ma namlolo ida. Om suk herre Makromod Lalap Nin panaeku ma namlolo, modi onuma poho mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Makanie! Lere eni me'ede, Makromod Lalap hukum o me'e. An hi'i o makum toko, de alam ida woro'o kam do'on haida-haida me'e.” Ler onne me'ede, haida naise howe damunala makan. Enime'ede makan tokedi, la mehe hapu napanak ri ni'ik liman lolo kalla. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernur po'on ha onneni namwali ne, ai akin naili'il Yesus, ono ai nahumarna derne wanakuku wanayo'o ma na'ono Makromod. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ramhara Papos, Paulus noro nin kalla wali enihe hopol laa noho Pamfilia rala'a laa kota Perga, maa lolo kota onne Yohanis (rapolu Markus haenhi) hoikaruwedi hi wali wali'ur laa kota Yerusalem. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulus noro Barnabas ramhara Perga rala'a laa Antiokia lolo Pisidia. Rakan Yahudi nin Alam Renren Warwarna, hir laa Yahudi rir kerei raram raikoro. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ri lolo kerei onne lese Musa nina horok noro nabi-nabi rira horok horu ne, man panulu lolo Yahudi rir kerei onne hopon ri lan lariyala Paulus noro Barnabas na'ahenia, “I wal'u mie, lo'o papa lirna romo aile ma na'alapa ai akim, ken loikaruwale, am derne makaniyale ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kame'ede, Paulus namriri, kikan liman laa wawan na'ahenia, “Konohiyala, i wal'uhe Israel roro i walin ma ka namwali ri Yahudi man horhawe Makromod Lalap na'ahoru. Ya apanak i wal'uhe, makaniyala tarana! ");
INSERT INTO kjeNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Makromod Lalap Ma Narehi Ma Nalewen, man ri Israel na'akeme hoikani eni, niliyedi ai upun a'um ramwali Nina ri. An hi'i hi rariwan rarahu lere hir holile Mesir ramwali do'on awan lolo onne. Enime'ede, Ai nodi Nina ke'eke'el an'anha hi'i hi ramhara Mesir. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hi ramharedi Mesir ne, min lolo kalla noho mamun ma napro'uk anna weli'akka raram. Kade lere onne Makromod Lalap po'on rira hini'i wenewhe rahu man yakeni, maa An pepen haun, la kan huri we'er hi lolo noho mamun onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ai na'akeperedi leke wo'ikku lolo noho Kana'an raramne, leke ha'ar durum nohorai noro leke ruhun onnenihe, Israel manarne. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Panaeku onnenihe na'akeme na'ene namwali horu lolo anna rahu wo'akka wellima raramne onne. Ha'ar durum leke ruhun Kana'an raram horu, Makromod Lalap kikan man ho'ok kail wo'ira rodi molollo Israel hehen nanumene Samuel ma namwali nabi nin kulere. Ai onne namwali ri Israel nin man ho'ok kail man kauli'ur wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Rakan nin lere onne, hi rapanak rai nodi molollo hi. Ende Makromod Lalap kikan Saul, Kis ananne nano luhu Benyamin namwali rir rai la ai nodi molollo anna weli'akka. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Makromod Lalap nalkopuredie Saul onne mene kikan wali'ur Daud namwali rira rai. Enla Makromod Lalap wakunu na'ono Daud na'ahenia, ‘I do'onedi Daud, ma namwali Isai ananne, la ai onne ri ma nahuwa'an Ya akin. Ai penia man hi'i wewhe Ainu'u honorok panaeku rahue.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nano Daud upun ananhe Makromod Lalap na'akenedi Israel nin Rai man huri we'er ri mormori nano dohohala nin molollo, naise oirawie An konohiyedi me'e. Yesus eni peni Rai onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus kan mai wakukuwala ri makun, Yohanis hopon ri mormori noho Israel na'ahenia, ‘Herredi minim morimori ma ka namlolo, wali derne makani Makromod Lalap, la mai oir leke ulutada mi.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lere Yohanis na'akeki na'ahoru nina honowok eni, ai na'ukani ri onne na'ahenia, ‘Mi mauroin ya'u eni inhoi? Ka amwali Rai man mim nenewek eni. Horhoroke! Yo olu mai mene An mai, maa An kulu narehi ya'u, de kan wa'an ya'u we'er nina sepatu kali eni.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","I wal'uhe, Abraham upun ananhe roro idewe ma ka namwali Yahudi man horhawe Makromod Lalap na'ahohoruwedi! Makromod Lalap akuwedi Lirna or'ori dardari maiyedi ika me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ri man minle Yerusalem roro rira man panulu onnenihe kar eremnala nahenia Yesus onne penia man Makromod Lalap kikan namwali Rai man huri we'er ri mormori nano dohohala nin molollo onne, de hukumesne. Kade aki Alam Renren Warwarna hir lese nabi-nabi rira wanakuku, maa hi ka rauroin wanakuku loloi kakaruwedi onne kukul hirira hini'i wenewhe man yakeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hi kar lernala Ainina yaksala ida leke hukumesne, maa rapanak Pilatus nesne Ai. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ende hir hi'i ha wo'ira Ai kemen man horokedi lolo Horok Lap raram, mene rala kopur nano au kekiyowok, rala loile lunne raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Enimaa Makromod Lalap na'amori Ai wali'ur nano makimakie, ");
INSERT INTO kjeNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","la An mai nalhari kemen lere wo'irha Nina ri ma nadedem lernohie nano Galilea rakan Yerusalem. Ri eniyenihe penia ramwali Nina man kuku maka laa heri Israel enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ende, lere eniyeni am loikaru Makromod Lalap Lirna Wawa'an ma na'ono panaeku na'akeme man Makromod Lalap nouwedi ai upmu ai a'umhe nonolu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","An hi'i mayai ma namwali hi upun anan do'onedi Nin nou onne ma na'ahenia Ai na'amori wali'ur Yesus nano makimakie. Panaeku eni horokedi haenhi lolo horok Mazmur panakan woro'o ma na'ahenia, ‘O penia Ya An'u, O. Ler eniyeni Ya amwaliyedi O Ammu.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesus onne, Makromod Lalap na'amori wali'uredi nano makimakie leke yon An minle lunna raram la yon Ai kemen popo. Panaeku onne Makromod Lalap nouwedi ai upun a'umhe nonolu me'e na'ahenia, ‘Ya ala nou man moumou dewdeweni la ma namkene ki mi naise Ya aledi Daud me'e.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lolo lisir namehin Daud na'aheni haenhi, ‘O kam huri we'er Num Man Moumou Dewdewe kemen popo.’ ");
INSERT INTO kjeNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","I wal'uhe, lere Daud mormori lolo noho wawan, an hi'iyedi inhawa man Makromod Lalap hohopon na'akeme nanumene aran horuwedi. Ende ik kauroin wanakunu onne kan kukul nina makimaki aimehi, ono an maki rawilo'edi noro upun a'anhe me'e de kemen popo la namwaliyedi elimo'o larihapu me'e, ");
INSERT INTO kjeNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","maa Makromod Lalap na'amori wali'ur Yesus nano makimakie de Ai kemen kan popo la ka namwali elimo'o larihapue. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ende i wal'u na'ahoru, leke mi mauroin kokkoo, lere eniyeni Makromod Lalap hariyedi kalla lolo Yesus eni leke minim dohohala na'akeme ra'ohu rahaledi. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kade ika lernohi Musa nin keneri hono'ok, maa ik ka kahinuri nano iknika dohohale, de ik akin kan mou lolo Makromod Lalap kalarna. Maa inhoi ma akin naili'il kokkoo Yesus, ri onne nina dohohale na'akeme ra'ohu rahaledi, la ai namwali ri molololo Makromod Lalap kalarna me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mi na'ahohoru loi honorok wawa'an! Yono hi'i de inhawa Makromod Lalap na'aheni lolo Nin nabi-nabi nonolu eni namwali ki mi. Makromod Lalap na'aheni, ");
INSERT INTO kjeNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mahinorok wawa'an, mi man suk na'ihoru na'idaru mamani! Ya'u hi'i panaeku ma narehi ma nalewen, la mim heheledi do'on Ainu'u hini'i wenewhe man ri kan dodo'onnala makun, maa oreki inworo'o mim maki, ko'u nano Maya'u, Makromod Lalap. Mim makileken ono ri aile man kukunohi mi Ainu'u hini'i wenewhe man ma'aruru onne, maa mi akim mamhene naili'il Maya'u.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulus noro Barnabas ramhara kerei onneni ne, kerei raramne heruwali mai rapanak na'ahenia, “Paphe, Alam Renren Warwarna nokalari eni am lariyala paphe mai loikaru minima wanakuku eni mayai wali'ur.” ");
INSERT INTO kjeNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Heri ramharedi Yahudi rir kerei onneni ne, ri nammori lernohi Paulus noro Barnabas--ri Yahudi noro idewe ri ma ka namwali Yahudi man lernohiyedi Yahudi nin agama me'enihe. Enpenia woro'ohe nounaku heri onne leke rauroin la akin namkene naili'il Makromod Lalap ma nala rere'e haharu hi na'ahoru. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Rakan Alam Renren Warwarna wali'ur, manin kota onne, manlo'o ne'en raram na'akeme, maiwuku derne Makromod Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Enimaa, ri Yahudi heruwali po'on heri nammori onne maie ne, hi akin apinha wake'e. Ende hir wahilei ra'idaru inhawa Paulus loloi kakaru eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Enine Paulus noro Barnabas ka ramka'uk, der wakunu mouropo roro hi, ra'ahenia, “Ai modi Makromod Lalap Lirna Wawan mai loikaru mi nolu, maa mi mamhene kokale! Mi mehe hi'iyedi kenekrohu nahenia kan wa'an mim lernala or'ori dardari ma kan horu eni! Ende lere eniyeni ai modi wanakuku eni laa konohi ri ma ka namwali Yahudi enihe! ");
INSERT INTO kjeNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Makromod Lalap hopon mayai na'ahenia, ‘Ya aledi molollo ki mi me'e, leke mamwali wadu man ropo ri ma ka namwali Yahudi enihe, leke hi rauroin Ainu'u honorok panaeku. Laa ma'amou ma'aropo Ainu'u panaeku ri manin noho wawan na'akeme, leke hir lernala or'ori dardari ma namlolo eni.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ler onne ri ma ka namwali Yahudi onnenihe derne Paulus nina wanakunu onne, de hi akin nahuwa'an wake'e. Hi ra'uli rasa'a ra'ahenia, “Makromod Lalap Lirna Wawan eni ma'aruru wake'e.” Ende ri na'akeme man Makromod Lalap niliyedi leke lernala or'ori dardari ma kan horu enihe, hi onne akin naili'il Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ende Makromod Lalap Lirna Wawa'an eni raderre radaul lolo kota onne ne'en raram na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Enimaa, ri Yahudi heruwali onnenihe rawa'u maeke marna man horhawa Makromod Lalap roro man panulu lolo kota onnenihe, penia hir hi'i ha man yaka roro Paulus noro Barnabas, la rohi woro'ohe ramharedi nano leke onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hi ramharedi kota onneni ne, Paulus noro Barnabas disnedi elimo'o hapue nano ein raram me'e, leke namwali tanada hi ka rodi yodiwara ida ono kota raramne kar kokala hi. Horu ne, hi rala'a laa kota Ikonium. ");
INSERT INTO kjeNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ri Antiokia man lernohiyedi Yesus, hi akin nahuwa'an wake'e, la Roh Kudus nodi molollo hi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Rakanedi kota Ikonium, Paulus noro Barnabas laa Yahudi nin kerei raram wakuku Makromod Lalap Lirna Wawa'an eni naise nadedem. Wanakuku onne nedille ri akinhe penia ri nammori, ri Yahudi noro ri ma ka namwali Yahudi enihe, akin naili'iledi Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Maa, ri Yahudi ma namhene akin naili'il Yesus rawa'u ri ma ka namwali Yahudi heruwali, penia hi kar suk ri ma akin naili'il Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Enimaa Paulus noro Barnabas min nalo'ol lolo kota onne. Hi ka ramka'uk, der wakunu mouropo Makromod Lalap Lirna Wawan. Enla Makromod mehe nala molollo hi hi'i ha ri kan dodo'onnala makun, leke ri lolo onne rauroin nahenia Lira ma na'ono Nin rere'e haharu onne, Lira ma namlolo kokkoo. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Maa, ri manin kota onne ida ma kan derne ida, de heruwali rodi Yahudi rir man panulu honorok akin, heruwali rodi Paulus noro Barnabas rira loloi kakarue. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Enine ler ida ri ma ka namwali Yahudi, noro ri Yahudi, noro wewerre rira man panulu, na'akeme lawuku panaeku leke na'omhe la rodi waku wadesne woro'ohe. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Paulus noro Barnabas eremnala rira panaeku yaka onne, de ramharedi kota onne rala'a kota Listra noro kota Derbe ma aile noho Likaonia noro leke-leke lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Min lolo onne, hir loikaru Makromod Lalap Lirna Wawa'an eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lolo Listra mo'oni ida aile ein naplu'ukedi. Nano lere momori me'ede ai ka nauroin nala'a ono ein kawin ka naruri. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ri onne naikoro derne Paulus wakunkunu, Paulus po'on desnale, nauroinedi mo'oni onne akin naili'iledi kokkoo, ");
INSERT INTO kjeNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","de Paulus hopon naruri na'ahenia, “Mamririyedi!” Enime'ede, mo'oni ma naplu'uk onne nehu laa wawan lalaa mamai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Idewe heri onne po'onala Paulus hi'i wa'anedi ma naplu'uk onne, hir wakau rodi rira wanakunu Likaonia ra'ahenia, “Iknik noho makromon enihe kopuredi ramwali ri mormori kemen me'e!” ");
INSERT INTO kjeNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ende hir waki Barnabas naran ‘Zeus’ ono hirira noho makromon uluwakun naran onne, la Paulus hir waki naran ‘Hermes’ ono Paulus penia man wakunu eni, la hirira noho makromon ma nauroin wakunu warei naran Hermes. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Rira imam nala'a laa kote paharne laa rira noho makromon Zeus nin romleu ma na'urani nika lapa makan. An lae ne, ai nodi sapi dalu ida woro'o noro au dipi laa nika lapa makan. Ai noro heri onne raram nodi resne ha mormori onne rodi hoikani woro'ohe. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barnabas noro Paulus ma namwali hophopon ma nodi Yesus Lirnenihe derne rira panaeku onne, idewe hir sirrikiyedi rira rain lari laa heri toro, ");
INSERT INTO kjeNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","wakaukau ra'ahenia, “Heih! Alhi'ihepenia mim hi'i ha enie? Mayai eniyenihe ri mormori naise ai walum haenhi. Am mai loikaru Makromod Lalap Lirna Wawa'an ki mi leke mim ren hoikani noho makromon ma ka namlolenihe, la mai hoikani Makromod Lalap man mormori eni. Ai penia ma nakuku nawau a'am noro noho wawan noro kahi, la man umupala ha or'ori na'akeme ma aile raramne. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kade nano nonolu Makromod Lalap hurinohi ri mormori noho wawan lernohi rira raram nodi aimehi, ");
INSERT INTO kjeNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","maa Ai kan hamlinu nala tanada ai wallumhe leke mi mauroin namlolo kokkoo Ai onne inhoi. Tanada man Ai nala ki mi hi'i heheni: Ai nala ha man wa'an, nala okon kuru wara lanik, la hi'i noho ennen namwali nin yare. Ai nala i wal'uhe hanana'an, la nahuwa'an mi akim.” ");
INSERT INTO kjeNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kade Paulus noro Barnabas wakunuwedi roro heri onne me'e, maa sus wake'e mene hir dadiyalahe leke yon heri resne ha mormori rodi hoikani hi. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Enine ri Yahudi wo'ira nano kota Antiokia noro kota Ikonium mai Listra rawa'u ri nammori lolo onne, leke hir lernohi rira honorok panaeku yaka. Penia hi rodi waku wasla Paulus, soru kemen laedi kote paharne, ono hi rauroin nahenia an makiyedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Maa, ri man lernohi Yesus laa ramriri Paulus herne wali-wali, mahar po'one, ai namaka wali laa kote raram wali'ur. Mai noho werra'ha ai noro Barnabas ra'alono laa kota Derbe. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hir minle Derbe, Paulus noro Barnabas loikaru Makromod Lalap Lirna Wawa'an eni, la ri nammori lernohi Yesus. Enime'ede hir wali wali'ur laa Listra. Horu ne, hir wali laa Ikonium mene wali laa Antiokia ai Pisidia. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lolo kota-kota onne hi ra'alapa man lernohi Yesus onnenihe akin, la nounaku hi leke hi ramkene lernohi Yesus. Hir wakuku ra'ahenia, “Ika lernala kenene panatal noro ha man sus nammori mene i kala'a Makromod Lalap Nin miminlole raram.” ");
INSERT INTO kjeNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Woro'ohe nili ri ida woro'o ma akin naili'il Yesus leke ramwali man leluwai makrana kerei raramne lolo kote laa kote. Hi ra'aluli kemen ka ra'ak, la hi'i lir napanak leke Makromod Lalap norle'ule'u norwaliwali man leluwai makrana onnenihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Onne horu, Paulus noro Barnabas rala'a lolo noho Pisidia rakan noho Pamfilia. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Rakan lolo onne hir loikaru Makromod Lalap Lirna Wawan wali'ur lolo kota Perga. Horu ne, hi rala'a laa kota Atalia. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nano Atalia hir hopol wali wali'ur laa kota Antiokia ai noho Siria. Lere nonolu onne heri man lernohi Yesus lolo Antiokia onne rapanak Makromod Lalap nala Nin rere'e haharu noro molollo woro'ohe, leke howok Nin honowok, la ors eni rira honowok onne horuwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hir rakan Antiokia ne, hir ra'ukwuku kerei raramne leke wakunu panaeku na'akeme man Makromod Lalap hi'iyedi lolo rira nala'ala'a me'e. Enla hir konohi hi'ihewi Makromod Lalap hari kalla leke ri ma ka namwali Yahudi enihe akin naili'iledi Yesus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Hir min nalo'ol roro man lernohi Yesus lolo kote onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ri Yahudi ida woro'o rano noho Yudea mai kota Antiokia wakuku ri ma akin naili'il Yesus lolo onne ra'ahenia, “Lo'o mi kam lernohi Musa nin keneri hono'ok de lam sunate, Makromod Lalap ka nala or'ori dardari ma kan horu ki mi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus noro Barnabas kar huri wu'u ri onnenihe, penia rawalha lira naruri roro hi. Kame'ede, man lernohi Yesus lolo Antiokia kukul Paulus noro Barnabas roro ri ida woro'o namehin rano rir kerei raramne rala'a laa Yerusalem, leke wakunuwala panaeku onne roro hophopon ma nodi Yesus Lirna roro uluwakun kerei enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ende hi rala'a ne, kerei raramne na'akeme lolo Antiokia rorkaru hi rakan kote paharne. Hi rala rir tape masi horu, rala'a lolo noho Penesia laa noho Samaria kukunohi ri ma akin naili'il Yesus lolo onne ra'ahenia, “Ri ma ka namwali Yahudi nammori akin naili'iledi Yesus me'e.” Manin lolo onne derne lirna onne hi akin nahuwa'an wake'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hir rakanedi Yerusalem, uluwakun kerei roro hophopon ma nodi Yesus Lirna, roro kerei raramne na'akeme kokalahe wawa'anedi. Ende hir konohi hi panaeku na'akeme man Makromod Lalap hi'iyedi lolo hi eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Maa, ri ida woro'o ma nano Parisi rir muku man lernohi Yesus haenhi, hi ramriri wakunu ra'ahenia, “Hopon ri ma ka namwali Yahudi man lernohi Yesus enihe lar sunatedi, la hopon hi lernohi Musa nin keneri hono'ok eni!” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Enine hophopon ma nodi Yesus Lirna roro uluwakun kerei enihe ra'ukwuku leke wakunu panaeku onneni wewerre. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hi raherre honorok aki nalo'ol mene Petrus namriri na'ahenia, “Konohiyala i wal'u na'ahoru. Mi mauroin lere man laedi Makromod Lalap polu ya ano mi na'ahoru, leke ya'u loikaru Ai Lirna Wawa'an eni laa ri ma ka namwali Yahudi enihe. An hi'i heheni leke hir derne Lirna onne la akin naili'il Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Enla Makromod Lalap ma nauroin ri mormori akinne, nodi kunukunohi nahenia An kokaledi ri ma ka namwali Yahudi onnenihe ono Ai nala Roh Kudus hi namnenehe Ai naledi Roh Kudus maika ma namwali Yahudi enihe. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Makromod Lalap ka na'ili naheir ik koro hi. Ai na'amouwedi hi akin me'e ono hi akin naili'il Yesus. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ende, i wal'uhe, alhi'ihepe mi raram nodi ken Makromod Lalap makun? Alhi'ihepe mi makerne ri ma ka namwali Yahudi enihe hi'i hi sus wake'e duni ta'al hi noro agame nina keneri hono'ok rahue? Ik upud a'ad me'ene kar paekunala lernohi keneri hono'ok rahu onne, emene maika ho'o! ");
INSERT INTO kjeNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ka! Naherre nawaliyedi! Ik akin naili'il Yesus, de ik kauroin nahenia ika lernala or'ori dardari ma kan horu nano Makromod Yesus Nin rere'e haharu eni mehe. Ri ma ka namwali Yahudi enihe lernala or'ori dardari namnenehe maika haenhi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Enpenia ri man hopun enihe na'akeme karkaramedi lolo onne. Enine Barnabas noro Paulus wakunu wali'ur hi'ihehewi Makromod Lalap nodi hi hi'i ha ri kan dodo'onnale makun lolo ri ma ka namwali Yahudi enihe kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hir wakunu horu, Yakobus na'ahenia, “Konohiyala, i wal'u na'ahoru! Makaniyala maya'u nanu! ");
INSERT INTO kjeNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Idediyeni Simon Petrus konohiyedi maika hi'ihewi Makromod Lalap kan huri we'er ri ma ka namwali Yahudi enihe nano nonolu eni, maa nalhari Nin rere'e haharu, de nili ri nano hi leke namwali Ainin ri. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Onne namnenehe panaeku man nabi-nabi loikaruwedi lolo Horok Lap nonolu eni me'e. Horok onne na'ahenia, ");
INSERT INTO kjeNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Makromod Lalap na'ahenia: Onne horu, lere man mai Ya'u wali wali'ur leke wanna Daud noro upun anan rira nakar ma nadporeni, la hi'i wali'ur lukur akur ma nadiyaur eni, leke namriri wali'ur; ");
INSERT INTO kjeNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","leke ri na'akeme ma aile noho wawan makun, ri ma ka namwali Yahudi enihe man Ya apoluwedi ramwali Ainu'u ri haenhi, mai ranoin Makromod. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","E'eniyeni Makromod Nina wanakunu man An loikaruwedi mouropo nano lere nonolu eni me'e.’ ” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobus na'aheni wali'ur, “I wal'uhe, ainu'u honorok panaeku eniyeni: Yon ik hi'i susa ri ma ka namwali Yahudi enihe, man mehe re'e Makromod Lalap nodi molollo hi akin. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Maa, wa'an rehi ika hi'i horok ida aku hi hopon yon hi'i panaeku ida woro'o: Yon ra'an hanana'an man ri nodi hoikani lernulu aukerhe, yon ra'an mahin man rarna ka namhara makun, yon romun rarna, la yon mo'oni maeke holi yaka leke yaka. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Konohi hi panaeku eniyeni, leke yon hi ra'ihoru ra'idaru ri Yahudi enihe, maa ida man mori wawa'an noro ida, ono nano nonolu me'e, aki Alam Renren Warwarna rin laa Yahudi nin kerei raram leke lese Musa nina keneri hono'ok eni, la hir wakukuwala keneri hono'ok onne lolo kota na'akeme.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ende hophopon ma nodi Yesus Lirna roro uluwakun kerei roro kerei raramne na'akeme, hi rala kenekrohu nili ri ida woro'o rala'a Antiokia roro wewerre Paulus noro Barnabas wali'ur. Hir nili Silas noro Yudas (man waki Barsabas haenhi). Hir nili woro'ohe ono rin horhawa hi narehi ri namehin lolo kerei Yerusalem raramne. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ende kerei onne hi'i horok ida aku noro man laa enihe rodie. Horok onne lirna na'ahenia, “Nano mi walinhe ma namwali hophopon ma nodi Yesus Lirna roro man leluwai makrana lolo kerei enihe, Aku laa ai walinhe ma ka namwali Yahudi enihe, ma aile kota Antiokia, noho Siria, noro noho Kilikia. Konohiyala ai walinhe ma akin naili'il Yesus na'ahoru! ");
INSERT INTO kjeNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Am derne ri ida woro'o nano mayai kiyedi Antiokia wakuku mi ha ma na'o'o nadewe mi honorok akim la hi'i mi akim ka namkene. Ai kam hopon ri onnenihe hi'i ha onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Enpenia am ra'ukwukuwedi me'e, modi akim mahaku nili ri ida woro'o, hopon hi ki ai wallumhe. Hi ra'alono roro wewerre Paulus noro Barnabas man ai mararamyakeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Lere man laedi manlo'o rin nesne ri woro'o onnenihe, maa hi ramkene lernohi Makromod Yesus Kristus. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ende am hopon Yudas noro Silas ki ai wallumhe, leke mehe ra'amou ra'aropo ainima honorok panaeku ma aile horok eni raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ai moro Roh Kudus hi'i kenekrohu kan wa'an ma'awerek mi noro agame nin holoor halauk rahu eni kokoko panaeku ida woro'o mehe. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Onnenihe: Yono ra'an hanana'an ri nodi laa hoikaniyedi lernulu aukerhe, yon romun rarna, yon ra'an mahin man rarna ka namhara makun, la yon mo'oni maeke holi yaka leke yaka. Lo'o mim lernohi holoor halauk ida woro'o eniyenihe mim hi'i ha man wa'an. E'eni mehe ainima honorok panaeku ki mi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ri wo'akka ma nodi horok onne konohiyala Yerusalem nina kerei raramne horu, de ramharedi lolo onne ra'alono laa Antiokia. Hir rakanedi Antiokia ne, hi ra'ukwuku kerei raramne na'ahoru leke rala horok onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Heri dernedi ri lese horok onne horu ne, hi akin nahuwa'anedi la hi honorok akin kan laa ki laa mai me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Onne horu, Yudas noro Silas (woro'ohe ramwali nabi haenhi) wakunu nalo'ol, nounaku hi walinhe man lernohi Yesus leke ra'alapa hi akinhe. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yudas noro Silas min lolo onne nalo'oledi tarana mene hi walinhe ma akin naili'il Yesus lolo Antiokia huri hi wali wali'ur laa Yerusalem, la ra'ahenia, “Mala'a wawa'anedi! Mala'a, yon hamlinu mayai, la modi ainim tape masi laa ri man hopon mi mai enihe.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Maa Silas mehe hi'i kenekrohu minle Antiokia, de kan wali me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus me'e ne noro Barnabas min nalo'ol lolo Antiokia. Hi roro ri nammori wakukuwala, la loikaru Makromod Lirna Wawan. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ka nalo'ol Paulus lariyala Barnabas na'ahenia, “Mai, ika laa ka'arala ik walin ma akin naili'il Yesus lolo kota na'akeme man ik loikaruwedi Makromod Lirna Wawan me'e, leke ika po'on rira honoli hi'ihewi, wa'an, ee ka.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas raram nodi lariyala Yohanis (rapolu Markus haenhi) ra'alono, ");
INSERT INTO kjeNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","maa Paulus namhene na'ahenia, “Lo'o yon lariyala ai me'e, ono nonolu an lernohi ika laa, maa ai ka namkene howok noro ika, de an hoikaruwedi ika lolo Pamfilia.” ");
INSERT INTO kjeNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ende Paulus noro Barnabas rawalha lira la rasesi me'e, de woro'ohe rahina'aredi. Barnabas nala Markus hopol wewerre laa noho Siprus, ");
INSERT INTO kjeNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","maa Paulus nili Silas namwali nin kalla wali. Ka rala'a makun, hi walinhe lolo Antiokia nina kerei hi'i lir napanak leke Makromod nala Nin rere'e haharu hi, la norle'ule'u norwaliwali hi lolo kalla. ");
INSERT INTO kjeNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Woro'ohe konohiyala, rala'a laliwewer noho Siria noro noho Kilikia. Hi rala'a ne, ra'alapa ri akin lolo kerei-kerei lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ramhara noho Kilikia, Paulus nala'a kota Derbe noro kota Listra. Lolo onne ri ida aile naranne Timotius man lernohi Yesus haenhi. Ai inne ri Yahudi ma akin naili'iledi Yesus me'e, maa aman ri Yunani. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lolo Listra noro Ikonium walin ma akin naili'il Yesus na'ahoru rauroin Timotius onne ri ma nina honoli wa'an der horhawe. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus raram nodi Timotius lernohie de, sunatedi ai leke yon ri Yahudi lolo onne rahinorok namehiyala ono hi rauroiroin ai aman ri Yunani. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hir kuli leke-leke lolo onne, hi rodi horok nano hophopon ma nodi Yesus Lirna roro uluwakun kerei Yerusalem enihe kukunohi ma akin naili'il Yesus onnenihe leke derne rakani rira kenekrohu eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Enpenia lolo onne hi ra'alapa kerei raramne na'akeme akinhe leke ramkene lernohi Yesus, la akilere ra'uwali ri ma akin naili'il mamani de kerei raramne eren nammomori. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Roh Kudus kawala Paulus noro nin kalla wali enihe loikaru Lirna Wawa'an eni laa ri mormori manina Asia. Ende hi ramlololo laa noho Frigia noro noho Galatia. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hir rakanedi korono noho Misia, hir kene laa noho Bitinia raram, maa Roh Kudus kawala hi yono laa noho onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Enpenia woro'ohe rala'a mamani lewen Misia la idewe kopur laa lour laa kota Troas. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A'alam hi ramkukuru lolo Troas ne, Makromod Lalap hi'i haida harile Paulus mehen do'on. An do'on ri ida manina Makedonia namririri lolo kalarna napanpanakedi na'ahenia, “Lariyala mai noho Makedonia leke paku mayai.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus do'on Makromod Lalap Nina hini'i onne horu, ai ma'akene mala'a Makedonia, ono am paeku wuku la mala kenekrohu nahenia Makromod Lalap penia hari kalla mayai lam loikaru Lirna Wawa'an eni ri ma aile lolo Makedonia. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Am ha'a kapal lolo Troas mene hopol namlololo laa Samotrake, la orekiyedi nanumene am hopol laa kota Neapolis. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Am kopur laa ro lolo onne, ai mala'a laa Pilipi ma namwali kota ma na'ono lolo noho Makedonia. Manin Roma nammori minle kota eni haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Rakan Alam Renren Warwarna, am laa kote paharne laa oir wauwau kilinna, kan ko'uwala kote nin nika lape. Am laa lolo onne ono ai makoto lo'o Yahudi rira lir napanak onno aile lolo onne. Am rakan ne, ai maikoro, wakunkunu noro maeke ida woro'o ma naikokoro wuku lolo onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Maeke ida aile ma naranne Lidia manina Tiatira, la ai ma na'olu tapi au'auwe. Ai eni ri ma nadedem na'uli nasa'a Makromod Lalap, de Makromod nala honorok aki ai leke kokala Paulus nina wanakuku loloi kakaru eni. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Onne horu, hir laa oir leke ulutade Lidia noro nakar raram na'akeme. Hir ulutade horu ne, an lariyala mayai na'ahenia, “Lo'o i wal'uhe mauroin mayai akin naili'iledi Yesus namlolo kokkoo, mai minala ainu'u nakar nanu ke'e.” Ende an nori yai leke ai me'e nohiyala nina napanak onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ler ida ai mala'ala'a laa Yahudi rira onno rodi hi'i lir napanak wali'ur, am holikuku hophopon wahwahan maekida. Hayakyaka hu'ur ai raramne, de ai nauroin hi'i u'ur leher penia nauroin panaeku ma namwali lere man mai. Enpenia makromonhe lernala kupan nammori nano nin woroin eniyeni. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Maeke onne lernohi Paulus noro mayai mamani, wakaukau mamani na'ahenia, “Ri eniyenihe Makromod Lalap Ma Narehi Ma Nalewen Nina hophopon wahwahane! Hir mai leke konohi i wal'u na'ahoru hi'i inhawa leke lernala Makromod Lalap Nina or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ende lelere a'alam an wakau heheni mamani rakan lere ida Paulus kan kerhu nina wanakau me'e, de ai nadwali po'on desnala maeke onne hopon hayakyaka man hu'ur raramne na'ahenia, “Yo odi Yesus Naranne, de mamharedi ai here!” Ler onne me'ede, hayakyak onne namharedi maeke onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Idewe makromonhe eremnaledi nahenia lo'o rira lere alam lernala kupan moluwedi me'e, de hir kele Paulus noro Silas sedu rodi laa pasar raram leke rakpali ma nodi molollo lolo kota onne. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rakpaliyedi ma nodi molollo enihe ne, hir tumdesne ra'ahenia, “Ri eniyenihe ri Yahudi. Hir hi'i rusrusu ar'arra lolo iknika kote. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hir wakuku ri noho honolla ma ka namnehe na'alono ika manin Roma enihe nik noho honolla. Ende kan wa'an ik kokala hi, ono luli ik lernohi rira noho honolla onneni!” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Enime'ede, heri lolo onne lernohi hi tumdesne woro'ohe haenhi. Ma nodi molollo onnenihe hopon ri hedu rikiyedi Paulus noro Silas rira nainair, riuk rerhe woro'ohe. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hir riuk rerhe woro'ohe kemen apinha wake'edi nanumene rale laa bui raram. Ma nodi molollo enihe hopon uluwakun bui eni nadiyaka na'apiku woro'ohe. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Uluwakun bui eni lernaledi rir honopon onneni ne, ai nala hi laa kamar ma aile raram wake'e la nodi dasle dasdasle hi ein. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mai alam totore Paulus noro Silas mahanoro hi'i lir napanak, rahinara, la ra'uli rasa'a Makromod Lalap. Ri namehin man minle bui raram derderne rira hanara haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ramlilinnohi rururuwai lape namwali, de bui nina mesel noro pondasi narururu wake'e. Idewe bui nina nikenihe nahinari mouwedi, dasle ma aile liman ein mehe nawine'er mouwedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Uluwakun bui eni namkukuru, nahumarna namaka idewe, la po'on nika na'akeme nahinariyedi, lehu nina rae leke mehe nodi nesne me'e, ono an pene'ek ri mormori manina bui raram na'akeme ramhara lari mouwedi me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Maa Paulus wakau naruri, “Yono mehe mesne o, mayai na'akeme meneni yai makun!” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Uluwakun onne napanak wadu ida nodie lari laa bui raram. Ai narururue, wali kemen laa yawa Paulus noro Silas kalarna. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Enime'ede ai norkaru hi laa paharne na'ahenia, “Papee, ya'u hi'i inhawa leke yon lernala hunukum makimaki, maa lernala or'ori dardari ma kan horu.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paulus noro Silas walhale ra'ahenia, “Papa, hi'i akin naili'il Yesus leke papa noro nakar raram na'akeme rahinuriyedi nano hunukum, la lernala Makromod Lalap Nina or'ori dardari ma kan horu eni.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Enine Paulus noro Silas loikaru Makromod Lirna Wawan uluwakun bui noro nakar raramne na'akeme. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Alam totoro onne me'ede uluwakun bui onne na'amou hirira no'o ririuk rererhe ma aile kemen. Alam onne me'ede hir laa oir leke ulutada ai noro nakar raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ulutade horu, uluwakun bui onne norhe laa nin nakar nala hanana'an, ra'an. Ai noro nakar raram na'akeme akin nahuwa'an wake'e ono hi akin naili'iledi Makromod Lalap me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Rakan werra'ha al'alam ma nodi molollo nano Roma onnenihe hopon rira ma nasala ke'uraukhe mai uluwakun buie na'ahenia, “Huriyedi woro'ohe here!” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","An dernedi rira honopon eni ne, an laa konohi Paulus na'ahenia, “Papee, idedi nanumene Roma nin ma nodi molollo enihe rala honopon mai na'ahenia huriyedi paphe nano bui raram. Ende lo'o me'eni me'e Paphe wali laa nakar. Mala'a wawa'anedi.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Enimaa Paulus namhene la na'aheni ma nasala ke'urauk onnenihe, “Mayai manin Roma haenhi! Ai mamhene mala'a, ono minima ma nodi molollo kar ho'ok kail mayai lernohi Roma nin keneri hono'ok makun, hir riuk rerhedi mayai heri rahue kalarna, ralai laa bui raram me'e. Kade Roma rira keneri hono'ok kan huri hi hi'i heheni, maa lere eniyeni rodi kalla susuwar huri yai! Ai mamhene! Lam hopon minima ma nodi molollo onnenihe meher mai huri yai!” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Enime'ede ma nasala ke'urauk onnenihe wali laa konohi Roma nin ma nodi molollo onnenihe rira panaeku onne. Hir derne Paulus noro Silas manin Roma haenhi, ramka'ukedi. ");
INSERT INTO kjeNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ende hir laa rapanak lilili maumau Paulus noro Silas. Horu ne, hi rorkaru woro'ohe nano bui raram mai paharne la ra'ahenia, “Lo'o wa'an rehi paphe mamharedi koteni ke'e.” ");
INSERT INTO kjeNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulus noro Silas ramharedi bui ne, hi rala'a Lidia nina nakar. Lolo onne hir pakromo roro walin ma akin naili'il Yesus enihe raledi nounaku hi leke ra'alapa hi akin. Horu ne, hi rala'a ramharedi kota Pilipi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hi rala kalla lolo kota Amfipolis noro kota Apolonia nanumene rakan kota Tesalonika. Lolo onne Yahudi rira kerei aile. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ende naise nadedem, Paulus laa kerei raram noro ri manina lolo onne wakunu Horok Lap Lirna, la raherre honorok panaeku nano Horok Lape raram nano nina lisar laa lisar. Alam Renren Warwarna wokelu an hi'i heheni. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Paulus na'amou na'aropedi honorok nano Horok Lape ma nodi kunukunohi nahenia Kristus man Makromod Lalap kikan namwali Rai laa ewi-ewi mai noho wawan leke lernala apinpinha, maki, la mori wali'ur. Ai na'amou panaeku onne leke hi rauroin mouropo Lirna Wawan nina panaeku ma namlolo. Horu ne, ai na'ahenia, “Yesus man ya'u konohi mi eni, namwali Rai onne.” ");
INSERT INTO kjeNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ende ri Yahudi wo'ira akin naili'iledi Yesus me'e, de lernohi Paulus noro Silas. Lolo onne ri Yunani nammori ma namka'uk Makromod Lalap roro idewe maeke marna nammori akin naili'il Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Enimaa, ri Yahudi ma akin ka naili'il Yesus enihe, hi akin apinha wake'e Paulus noro Silas. Ende hi ra'ukwukuwedi mo'oni man ailanna ma nakosi mamani leke rore rawa'u ri lolo kote raram na'akeme hi'i rusu arra. Heri rahu onne laa idewe Yason nina nakar ranoin Paulus noro Silas, leke rodi woro'ohe laa paharne rakpali heri onneni. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Maa kar do'on Paulus noro Silas, de hir soru Yason noro walin ma akin naili'il Yesus namehin rodi laa rakpali ma nodi molollo lolo kota onne. Hir wakau ra'ahenia, “Lolo ewi-ewi Paulus noro Silas hi'i rusrusu ar'arra mamani! Ler eniyeni hir mai iknika kote haenhi, ");
INSERT INTO kjeNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","la Yason kokaledi hi lolo ainina nakar me'e. Hi na'akeme kar lernohi rai Kaisar nina konomdere, ono hi ra'ahenia Rai man kulu narehi aile, naranne Yesus.” ");
INSERT INTO kjeNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Rir wanakunu onne hi'i ri nammori roro ma nodi molollo lolo kota onne raram rakponhu me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ende ma nodi molollo onnenihe hopon Yason noro nina muku wali ma akin naili'il Yesus enihe pair kupan rodi herre kemen leke yon lernala hunukum lernohi kote nina keneri hono'ok mene huri hi rala'a. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A'alam onne me'e de walinhe ma akin naili'il Yesus lolo onne hopon Paulus noro Silas rala'a laa Berea. Hir rakanedi enne, rala'a Yahudi nina kerei raram. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ri manin Berea kar suwarala honorok akin, de kokale hi wa'an narehi manin Tesalonika onnenihe. Hir raram nodi derne Paulus nina loloi kakaru eni. Akilere hir lese Horok Lape rodi naho'ok Paulus nina wanakuku ke'e, de namlolo, ee ka. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ende ri Yahudi nammori akin naili'il Yesus. Yunani rir maeke marna roro mo'oni nammori akin naili'il Yesus haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ri Yahudi manina Tesalonika onnenihe derne Paulus mahan loikaru Makromod Lalap Lirna Wawan lolo Berea ne, hir mai Berea haenhi rawa'u heri lolo onne leke yono kokala Paulus me'e. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Me'e'eni me'e de walin man minle Berea rorkaru Paulus laedi herraram, maa Silas noro Timotius minedi kote. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ende hi rorkaru Paulus rakan Atena nanumene wali wali'ur laa Berea. Paulus nou hi, wali laa hopon Silas noro Timotius halhala lernohi here. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulus newnewek woro'ohe mai Atena ne, an po'on wali-wali kote raram aukerhe honoi kanani mamani, de akin woir rehi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ende Paulus nala'a Yahudi rir kerei raram loiwuku honorok aki noro ri lolo onne, ri Yahudi roro ri ma ka namwali Yahudi ma namka'uk Makromod Lalap haenhi, leke hir ramkene lernohi Yesus. Enla akilere an laa pasare loiwuku honorok aki noro inhoi-inhoi ma aile lolo onne haenhi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Orworoin nano muku Epikoras noro muku Stoa roro Paulus rawalha lira haenhi. Heruwali ra'ahenia, “Ri onne nauroin inhawa pe? Ka nauroin haida! Wakunu namansa mehe.” Ri namehin ra'aheni, “Ai onne lo'o wakunkunu noho namehin nina noho makromon!” Hi ra'aheni heheni ono Paulus loikaru Lira Wawa'an ma na'ono Yesus, la hi'ihewi An maki, la mori wali'ur. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kame'ede, hi rorkaru Paulus laa wo'or Areopagus leke raikoro wuku. Raikoro wukuwedi, hi ra'ukani Paulus, “Ai raram nodi mauroinala papa nina wanakuku worworu man idedie loloi kakaru onne, ");
INSERT INTO kjeNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ono am dernedi papa wakuku panaeku ida woro'o man rin kan derne rauroinnale makun. Ai raram nodi mauroin panaeku loloi kakaru onne inhawe?” ");
INSERT INTO kjeNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Manin Atena roro ri rano noho namehin man minle kota onne radedem ra'ahoru alam leken mamani makani wanakuku man worworu leke raherre honorok panaeku.) ");
INSERT INTO kjeNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ler onne me'e de Paulus namriri lolo heri man minle rana'ukwuku onne kalarna na'ahenia, “Konohiyala i wal'uhe Atena mie! Ya'u po'onedi i wal'uhe mampe'el hoikani noho makromon mamani. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ya'u lalaa mamai lolo minim kote waliwali po'onedi minim honoi kanani rahu ne, ya'u do'on panaur ida horhorok ai wawan na'ahenia, ‘Panaur eni hi'i leke horhawe noho makromon ma naranne ri ka nauroinnala makun.’ Ende mim hoikani Makromod Lalap eni, maa ka mauroin Naran makun, onne penia ya'u loloi kakaru ki mi. ");
INSERT INTO kjeNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Makromod Lalap eni ornakuku la ornawau, la man umu man pala noho ne'en raram na'akeme, la Ai nodi molollo a'am raram noro noho wawan, penia Ai kan minle romleu rodi hi'i h