﻿USE sofia;
DROP TABLE IF EXISTS sofia.kiz_vpl;
CREATE TABLE kiz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kiz_vpl WRITE;
INSERT INTO kiz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitabu kya lukholo lwa Yesu Kristu mwana ghwa Daudi, mwana ghwa Ibrahimu. ");
INSERT INTO kiz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahimu aj'hele tata ghwa Isaka, ni Isaka aj'hele tata ghwa Yakobo, ni Yakobo tata ghwa Yuda ni bhalongomunu. ");
INSERT INTO kiz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda aj'hele tata ghwa Peresi ni Sera kwa Tamari, Peresi tata ghwa Hezeroni, ni Hezeroni tata ghwa Ramu. ");
INSERT INTO kiz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu ajhele tata ghwa Aminadabu, Aminadabu tata ghwa Nashoni, ni Nashoni tata ghwa Salimoni. ");
INSERT INTO kiz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni ajhele tata ghwa Boazi kwa Rahabu, Boazi tata ghwa Obedi kwa Ruth, Obedi tata ghwa Yese, ");
INSERT INTO kiz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ajhele tata ghwa mfalme Daudi. Daudi ajhele tata ghwa Sulemani kwa n'dala ghwa Uria. ");
INSERT INTO kiz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani ajhele tata ghwa Rehoboamu, Rehoboamu tata ghwa Abiya, Abiya tata ghwa Asa. ");
INSERT INTO kiz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ajhele tata ghwa Yehoshafati, Yehoshafati tata ghwa Yoramu, ni Yoramu tata ghwa Uzia. ");
INSERT INTO kiz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia ajhele tata ghwa Yothamu, Yothamu tata ghwa Ahazi, Ahazi tata ghwa Hezekia. ");
INSERT INTO kiz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia ajhele tata ghwa Manase, Manase tata ghwa Amoni ni Amoni tata ghwa Yosia. ");
INSERT INTO kiz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia ajhele tata ghwa Yekonia ni bhalongomunu bhwakati bhwa kutolibhwa kulota Babeli. ");
INSERT INTO kiz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ni baada jha kutolibhwa kul'ota Babeli, Yekonia ajhele tata ghwa Shatieli, Shatieli ajhele kokho munu ni Zerubabeli. ");
INSERT INTO kiz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli ajhele tata ghwa Abiudi, Abiudi tata ghwa Eliakimu, ni Eliakimu tata ghwa Azori. ");
INSERT INTO kiz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori ajhele tata ghwa Zadoki, Zadoki tata ghwa Akimu, Akimu tata ghwa Eliudi. ");
INSERT INTO kiz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi ajhele tata ghwa Elieza, Elieza tata ghwa Matani ni Matani tata ghwa Yakobo. ");
INSERT INTO kiz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo ajhele tata ghwa Yusufu n'gosi ghwa Mariamu, ambajhe kwa muene Yesu ahogoliki, j'haikutibhwa Kristu. ");
INSERT INTO kiz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Fizazi fyoha kuh'omela Ibrahimu hadi Daudi fyaj'hele fizazi kumi na nne, kuh'omela Daudi hadi kutolibhwa kulota Babeli fizazi kumi na nne, ni kuhomela kutolibhwa kulota Babeli hadi Kristu fizazi kumi na nne. ");
INSERT INTO kiz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kuhogoleka kwa Yesu Kristu kwajhele namna e'j'he. Ndebhuake, Mariamu, achumbilibhu ni Yusufu, lakini kabla bhakhona kubhonana, abhonekene kujha nu luleme kwa ngofo sya Roho Mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngwanamunu Yusufu, aj'hele munu mwenye haki alondeghe lepi kun'haibisya hadharani. Aamuili kuleka uchumba bhwake kwa siri. ");
INSERT INTO kiz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bho ifikirira juu j'ha mambo agha, Malaika ghwa Bwana an'hidili mu ndoto, ajobhili, “Yusufu muana ghwa Daudi, usilili kun'tola Mariamu kama n'dalabhu, kwa ndabha luleme lwaaj'henabhu ni kwa bhuweza bhwa Roho Mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ibetakuhogola mwana ghwa n'gosi ni ghwibeta kun'kuta lihina lyake Yesu, kwa ndabha ibetakubhaokola bhanu bhake ni dhambi syabhene.” ");
INSERT INTO kiz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ghoha agha ghahomili kutimisibhwa k'hela kyaka nenebhu ni Bwana kwa nj'hela j'ha nabiii ajobhili, ");
INSERT INTO kiz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Langai, bikira ibetakukabha luleme ni kuhogola muana n'gosi, na bhibetakun'kuta lihina lyake Imanueli”— maana ghiake, “K'yara pamonga natu.” ");
INSERT INTO kiz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu aj'humuiki kuh'omela mulugono ni kubhomba kama malaika ghwa Bwana kyaan'jobhili na an'tolili kama n'dala. ");
INSERT INTO kiz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hata nahu agonililepi naku mpaka bho akifunguili muana n'gosi ni kunkuta lihina lyake Yesu ");
INSERT INTO kiz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baada jha Yesu kuhogoleka mu Bethelehem j'ha Bhuj'hahudi mu magono gha mfalme Herode, bhanu bhasomi kuh'oma mashariki gha patali bhahidili Yerusalemu bhajobhili, ");
INSERT INTO kiz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Aj'hendaku muene ambajhe ahogoliki Mfalme ghwa Bhayahudi? Twaj'hibhuene nyota j'hiake mashariki natu tuhidili kumwabudu.” ");
INSERT INTO kiz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pindi Mfalme Herode bhoapeliki agha adadili sanan, ni Yerusalemu j'hioha pamonga nu muene. ");
INSERT INTO kiz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herode abhabhongene bhak'alo bha makuhani bhoha ni bhaalembesi bha bhanu, nu muene akabhakota, “Kristu ibetakuhogoleka ndaku?” ");
INSERT INTO kiz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhan'j'hobhili, “Mu Bethelehemu j'ha Bhuj'hahudi, kwa kuj'ha efe ndo kyaj'hilembibhu ni nabii, ");
INSERT INTO kiz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Naghwe Bethelehemu, mu nchi j'ha Yuda, n'debe lepi miongoni mwa bhalongosi bha Yuda, kwa kuj'ha kuhoma kwa bhebhe ibetakuhida mtawala j'haibetakubhadima bhanu bhangu Israeli.” ");
INSERT INTO kiz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Efyo Herode abhakutili bhala bhasomi kwa siri ni kubhakhota ndo bhwakati gani hasa litondo libhonekeghe. ");
INSERT INTO kiz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Akabhatuma Bethelehem, akajobha, “Mlotai kwa bhuangalifu mu kandondaghe muana j'ha ahogoliki. Bhwakati pamwibeta kumbona, mundetayi habari ili nani nibhwesiayi kuhida ni kumwabudu.” ");
INSERT INTO kiz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baada j'ha kuj'ha bhamp'heliki mfalme, bhaj'hendelili ni safuari syabhu, ni litondo lela ambalyo bhalibhwene mashariki j'habhalongolili hadi paj'haj'hemili panani pa muene pa ahogoliki. ");
INSERT INTO kiz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bhwakati bho bhaj'hibhuene litondo, bhahobhwaki kwa furaha m'baha munu. ");
INSERT INTO kiz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhaj'hingili mu nyumba ni kumbona muana j'haahogoliki ni Mariamu ndebhuake. Bhansujudili ni kumwabudu. Bhabhopuili hazina syabho ni kumpisya zawadi sya dhahabu, bhuvumba, ni manemane. ");
INSERT INTO kiz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","K'yara abhaonyili mu ndoto bhasibhuj'hi kwa Herode, hivyo, bhabhokili kubhuj'ha mu nchi syabho kwanj'ela j'henge. ");
INSERT INTO kiz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baada j'ha kuj'ha bhabhokhili, malaika ghwa Bwana antokili Yusufu mu ndoto ni kujobha, “J'hinukai ntolai muana ni nyinamunu na mulotai Misri. Mubakilai okhu mpaka panibeta kubhajobhela, kwa kuj'ha Herode akandonda muana ili anj'hangamisiaghe. ");
INSERT INTO kiz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pakilu apu Yusufu ajhumuiki ni kuntola muana ni ndebhuake ni kukhem'belela Misri. ");
INSERT INTO kiz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Atamili okhu hadi Herode bho afuili. Ejhe j'hatimisibhu khela Bwana bhoajobhili kup'hetela nabii, “Kuhoma Misri nu nkutili mwanabhangu.” ");
INSERT INTO kiz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kisha Herode bho abhuene adhihakibhu ni bhanu bhasomi, adadili sana. Alaghisi kukomibhwa kwa bhana bhoha bhagosi bhabhaj'hele Bhethelehemu ni bhoha mu lieneo lela ambalyo bhaj'hele ni umri bhwa miaka mibhele ni pasi pa apu kul'engana ni bhwakati bhwa aj'hele athibitishi kabisa kuhoma kwa bhala bhasomi. ");
INSERT INTO kiz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndipo palyatimisibhu lela lilobhi lyalyajobhibhu kwa kinywa kya nabii Yeremia, ");
INSERT INTO kiz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sauti j'hap'helekiki Ramah, kilelu ni maombolezo mabhaha, Raheli bho ikabhalelela bhana munu na abelili kufarijibhwa, kwwa ndabha bhajhelepi kabhele.” ");
INSERT INTO kiz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode bho afuili, langai malaika ghwa Bwana an'tokili Yusufu mu ndoto okhu Misri ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“J'hinukayi n'tolayi muana ni ndebhuake, na mulotai mu nchi j'ha Israeli kwa ndabha bhabhalondeghe bhuhai bhwa muana bhafuili.” ");
INSERT INTO kiz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu aj'hinuiki, an'tolili muana pamonga nu ndebhuake, na bhahidili mu nchi j'ha Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini bho ap'eliki kuj'ha Arikelau aj'hele itawala Yuda mahali pa tata ghwake Herode, atilili kulota okhu. Baada j'ha K'yara kumwonya mu ndoto, abhokhili kulota mkoa ghwa Galilaya ");
INSERT INTO kiz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na alotili kutama okhu mu mji bhwabhwikutibhwa Nazareti. E'le lyatimisi k'hela kyakyaj'hele kimalili kujobhibhwa kwa nj'hela j'ha manabii, kuj'ha ibetakukutibhwa Mnazareti. ");
INSERT INTO kiz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu magono ghala Yohana Mbatizaji ahidili akihubiri mu nyika j'ha Yuda akajha ijobha, ");
INSERT INTO kiz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mtubuayi kwa maana bhufalme bhwa mbinguni bhwikaribila.” ");
INSERT INTO kiz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kwa ndabha oj'ho ndo j'haananibhu nu nabii Isaya ajobhili, “sauti j'ha munu j'haikutibhwa kuhoma jangwani; 'mubhekai tayari nj'hela j'ha Bwana, mughanyosiaghe mapito ghake.” ");
INSERT INTO kiz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Henu Yohana afuele maj'hoj'ha gha ngamia ni nkanda ghwa ngosi mu nsana ghwake kyakulya kiake kyaj'hele nzige ni bhuoki bhwa munsitu. ");
INSERT INTO kiz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kisha Yerusalemu, Yuda j'hioha, ni lieneo lyoha lyalisyonguiki kiholo Yorodani bhalotili kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhaj'hele bhibatisibhwa nu muene mu kuh'olo Yorodani khoni bhitubu dhambi syabho. ");
INSERT INTO kiz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lakini bhoabhabhuene bhingi bha mafarisayo ni masadukayo bhihida kwa muene kubatisibhwa, abhajobhili, “Muenga bhuzao bhwa liyoka bhwabhuj'ha ni sumu niani j'ha abhaonyili kuj'hijumba ghadhabu j'haj'hihida? ");
INSERT INTO kiz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Muhogolai matunda ghaipasyayo toba. ");
INSERT INTO kiz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na msifiriri ni kujobhesana miongoni mwinu, 'Tuj'henaku Ibrahimu kama tata j'hitu.' Kwa kujha nikabhajobhela K'yara ibhwesya kun'jhinula Ibrahimu bhana hata kuhoma mu maganga agha. ");
INSERT INTO kiz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tayari libhangu limalili kubhekibhwa mu mzizi bhwa libehe. Kwa ejhu kila libehe lyalibelili kuhogola matunda manofu lidumulibhwa ni kutaghibhwa mu muoto. ");
INSERT INTO kiz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nikabhabatisya kwa masi kwa nj'ela j'ha toba. Lakini muene ibetakubhabatisya kwa Roho Mtakatifu ni kwa muoto. ");
INSERT INTO kiz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ni pepeto lyake lijhele mmabhoko mwa muene kusuka kabisa bhuwanda bhuake ni kuj'hibhongana ngano j'hiake mu lighala. Lakini ibetakughanyanya makapi kwa muoto ambabho bhwibhwesya lepi kusimika. ");
INSERT INTO kiz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kisha Yesu akahida kuhoma Galilaya mpaka kih'olo Yorodani kubatisibhwa ni Yohana. ");
INSERT INTO kiz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohana alondeghe kum'besya akajobha, “Nene nilonda kubatisibhwa naghwe, bhebhe ghwihida kwa nene?” ");
INSERT INTO kiz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu an'jibili akajobha, “Ruhusuayi ej'helai naha henu, kwa kuj'ha ndo kya j'hikatulondeka kutimisya haki j'hioha.” Kisha Yohana akanduhusu. ");
INSERT INTO kiz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baada j'ha kuj'ha abatisibhu, mara Yesu abhokili mmasi, ni langai, Mbingu syafunguiuki kwa muene. Na ambuene Roho ghwa K'yara kyaiselela kwa mfano ghwa nj'hebha ni kut'ola panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Langai, sauti j'hah'omili kumbinguni j'hikawa j'hijobha, “Oj'ho ndo mwanabhangu. J'hanipendesibhu sana naku.” ");
INSERT INTO kiz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kisha Yesu alongosibhu ni Roho mpaka kulijangwa ili akajaribibhwayi ni ibilisi. ");
INSERT INTO kiz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bho afunguili kwa magono arobaini pamusi ni pakilu akabhili njala. ");
INSERT INTO kiz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mjarabu akahida na akan'jobhela, “Kama bhehe ndo Mwana ghwa K'yara, liamuruaj'hi maganga agha kuj'ha nkate.” ");
INSERT INTO kiz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lakini Yesu an'jibili ni kun'jobhela, “J'hilembibhu, Munu ibetalepi kutama nkate tuu bhuene, bali kwa kila lilobhi lyalihomela mu kinywa mwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kisha ibilisi akandongosya mpaka pa mji ntakatifu ni kumbeka panani sana pa lijengo lya lihekalu, ");
INSERT INTO kiz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ni kun'jobhela, “kama bhebhe Muana ghwa K'yara, kitaghai pasi, kwandabha j'hilembibhu, 'Ibetakuamuru malaika bha muene bhahidayi bhakudakayi,' ni, 'bhibetakuj'hinula kwa mabhoko ghabhu, ili ukatakwikungufula kig'olo kyako mu liganga.” ");
INSERT INTO kiz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akan'jobhela, “Kabhele j'hilembibhu, 'Usin'jaribu Bwana K'yara ghwaku.'” ");
INSERT INTO kiz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kisha, ibilisi akantola ni kundongosya sehemu j'ha panani zaidi akandasya falme siyoha sya bhulimwengu ni fahari j'ha e'su sioha. ");
INSERT INTO kiz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akan'jobhela, “Nibetakupela fenu fyoha efe ukanisujudilai ni kuniabudu.” ");
INSERT INTO kiz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kisha Yesu akan'jobhela, “Lotai okhu naubhokai apa, lisyetani, kwandabha j'hilembibhu, 'J'hilondeka kumwabudu Bwana K'yara ghwaku, na un'tumikiayi muene tu.'” ");
INSERT INTO kiz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kisha ibilisi akandeka, na langai, malaika bhakahida bhakan'tumikila. ");
INSERT INTO kiz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Basi Yesu bho ap'heliki kuj'ha Yohana akamuliki, abhokhili mpaka Galilaya. ");
INSERT INTO kiz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Abhokhili Nazareti alotili ni kutama Kaperanaumu, j'haj'hij'hele kandokando ni Bahari j'ha Galilaya, mumipaka ghya majimbo ghya Zabuloni ni Naftali. ");
INSERT INTO kiz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ej'he j'hatomili kutimisya khela kyakyajobhibhu ni nabii Isaya, ");
INSERT INTO kiz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mu mji ghwa Zabuloni ni mji ghwa Naftali, kulotela kubahari, kwiselya j'ha Yorodani, Galilaya j'ha bhamataifa! ");
INSERT INTO kiz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bhanu bhabhatamili mu ngisi bhabhubhwene mwanga m'mbaha, na bhala bhabhaj'hele bhatamili mu maeneo ni kivuli kya mauti, panani pa bhene nuru ibhamuliki.” ");
INSERT INTO kiz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuhomela bhwakati obhu Yesu aj'handili kuhubiri ni kujobha, “Mutubuaj'hi kwa ndabha bhufalme bhwa K'yara bhwikaribila.” ");
INSERT INTO kiz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bhoigenda kandokando j'ha Bahari j'ha Galilaya, abhabhuene bhalongo bhabhele, Simoni j'haakutibhweghe Petro, ni Andrea nd'hombo munu, bhitegha n'kuabhu mu bahari, kwa kuj'ha bhaj'hele bhavuvi bha somba. ");
INSERT INTO kiz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu akabhajobhela, “Muhidai munikhesiaghe, nibeta kubhabhomba kuj'ha bhavuvi bha bhanu.” ");
INSERT INTO kiz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mara j'himonga bhasilekili mikwabhu na bhankesili. ");
INSERT INTO kiz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ni Yesu bho ij'hendolela kuh'omela apu abhabhuene bhangi bhabhele, Yakobo mwana ghwa Zebedayo, ni Yohana nd'h'ombo munu. Bhaj'hele mu bhuatu pamonga ni Zebedayo tata ghwabho bhishona mikwabhu ghiabhu. Akabhakuta, ");
INSERT INTO kiz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ni mara j'himonga bhakankesya. ");
INSERT INTO kiz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu alotili karibia Galilaya kuoha, akaj'haimanyisya mu masinagogi ghabhu, akaj'ha ihubiri injili j'ha bhufalme, na akaj'ha ikabhaponyesya kila aina gha maradhi ni bhubhine miongoni mwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Habari sya muene syasambere Siria j'hioha, ni bhanu bhakabhaleta kwa muene bhala bhoha bhabhalwaleghe ni maradhi mbalimbali ni maumivu, bhabhaj'hele ni mapepo, ni bhenye kifafa na bhabhopozili. Yesu abhaponyisi. ");
INSERT INTO kiz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Umati m'mbaha ghwa bhanu bhwa mfwatili kuhomela Galilaya, ni Dekapoli, ni Yerusalemu ni Bhuyahudi na ku'homa kwiselya j'ha Yorodani. ");
INSERT INTO kiz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu bho abhuene bhumati, akabhoka ni kulota Kukidonda. Bho atamili pasi bhanafunzi bha muene bhakahida. ");
INSERT INTO kiz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Akafunula kinywa kiake ni kubhafundisya, akajobha, ");
INSERT INTO kiz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Heri bhabhajhele bhab'onyi bha roho kwandabha bhufalme bhwa kumbinguni ndo bhwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Heri bhabhaj'hele ni huzuni, kwa ndabha bhibetakufarijibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Heri bhenye bhololo, kwandabha bhibetakurithi nchi. ");
INSERT INTO kiz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Heri bhenye njala ni kiu, j'ha kiki, kwa ndabha obhu bhibetakushibishwa. ");
INSERT INTO kiz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Heri j'habhaj'hele ni Rehema. ");
INSERT INTO kiz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Heri j'ha bhaj'hele, ni muoyo safi kwa ndabha abhu bhibetakumbona K'yara. ");
INSERT INTO kiz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Heri bhapatanishi, kwa ndabha abhu bhibetakukutibhwa bhana bha K'yara. ");
INSERT INTO kiz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Heri bhala bhabhitesibhwa kwa ndabha j'ha haki kwandabha bhufalme bhwa mbinguni ndo bhwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Heru muenga ambabho bhanu bhakabhaligha ni kubhatesya, au kujobha kila aina j'ha bhubhibhi dhidi j'ha muenga kwa bhudesi kwa ndabha j'ha nene. ");
INSERT INTO kiz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhobhokai ni kushangilila. kwa ndabha thawabu j'ha muenga ndo m'baha kunani kumbinguni. Kwa kuj'ha efe ndo bhanu kyabhabhatesili manabii bhabhatamili kabla j'ha muenga. ");
INSERT INTO kiz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Muenga ndo muinyu ghwa dunia. Lakini kama muinyu ghuj'haseli ladha j'hiake, j'hibetabhwesya bhuli kuj'ha muinyu kabhele? Kamwe jhibhwesya lepi kuj'ha j'hinofu kwa khenu khenge kyokyoha khela, isipokuwa kutaghibhwa kwibhala ni kukanyibhwa ni magolo gha bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Muenga ndo nuru j'ha bhulimwengu. Mji ghwa ghujengibhu panani pa kid'honda ghwifighika lepi. ");
INSERT INTO kiz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bhwala bhanu bhibhwasya lepi taa ni kubheka pasi pa kikapu, bali kwenye kinara, naghu ghikabhaangasya bhoha bha bhaj'hele, mugati mu nyumba. ");
INSERT INTO kiz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lekai nuru j'hamuenga j'hij'hakai mbele j'ha bhanu kwa namna ambaj'ho kujha, bhaghabhonai matendo jhinu manofu ni kuntukusya dadi j'hinu j'haaj'hele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mkaikufikirira nihidili kuj'hionanga sheria bhwala manabii. Nihidili lepi kuijhonanga lakini kutimisya. ");
INSERT INTO kiz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kwakueli nikabhajobhela kujha mpaka mbingu ni dunia syoha sipetayi jhij'helepi yodi imonga bhwala nukta j'himonga j'ha sheria jhibetakubhosibhwa mu sheria hadi apo khila khenu pakibetakuj'ha kimali kutimisibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Henu j'hij'hioha j'hola j'haibeta kubomola amri sidebesidebe mojawapo j'ha amri e'se ni kubhamanyisya bhangi kubhomba agha ibetakukutibhwa n'debe mubhufalme bhwa mbinguni. Lakini jhejhoha azishikaye na kuzifuata ataitwa mkubwa mu bhufalme bhwa mbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kwa ndabha nikabhajobhela haki j'ha muenga j'hikatayi kujhongeseka haki j'ha bhaandishi ni Mafarisayo, kwa fyofyoha fela mwibetalepi kuj'hingila mu bhufalme bhwa mbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mup'heliki j'hajobhibhu muandi sana, “Usikomi” na 'j'haj'hioha j'haibeta kukhoma basi ajhele mu hatari j'ha hukumu.' ");
INSERT INTO kiz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini nikabhajobhela j'hej'hioha j'haikan'dadila ndongomunu ibetakuj'ha mu hukumu. Na j'hej'hioha j'haibetakumbola ndongomunu kuj'ha, 'Bhebhe ndo munu j'haghwilondeka lepi!' ibetakuj'ha mu hatari j'ha baraza. Ni j'hej'hioha j'haijobha, 'Bhebhe n'jinga!' ibetakuj'ha mu hatari j'ha muoto bhwa jehanamu. ");
INSERT INTO kiz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Na kama ghwipisya sadaka j'ha j'hobhi munu madhabahu na ghwikhomboka, kuj'ha ndongobhu aj'he ni lijambo dhidi j'ha bhebhe, ");
INSERT INTO kiz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jhilekai sadaka mbele j'ha madhabahu, kisha kamulai nj'hela j'hiaku kapatanaj'hi hoti ni ndongobhu, na kisha uhidai kupisya sadaka j'ha j'hobhi. ");
INSERT INTO kiz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Patanai ni mshtaki ghwa j'hobhi manyata, ukajhiaghe pamonga nu muene munj'hela kul'ota kumahakama, bila naha mshtaki ghwa j'hobhi ibnhwesya kukuleka mabhoko mwa hakimu, ni hakimu akulekai mmabhoko gha askari, naghwe ghwisopibhwa muligereza. ");
INSERT INTO kiz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Amini kya nikabhjobhela, kamwe wibetalepi kuj'ha huru hadi ulepai senti j'ha mwishu j'ha pesa j'hawidaibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mup'heliki j'hinenibhu kuj'ha, 'Ukatai kuzini.' ");
INSERT INTO kiz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini nikabhajobhela j'hej'hioha jhiambona n'dala kwa kun'noghela amalili kuzini naku mun'teema ghwake. ");
INSERT INTO kiz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na kama lihu lya bhebhe lya kulia likusababisya kwikungufula, libhosiaj'hi na ulitaghai kutali nu bhebhe. Kwa kuj'ha ndo afadhali kiungo kimonga mu m'bele bhwako kyonangikai kuliko m'bele bhuoha kutangibhwa jehanamu. ");
INSERT INTO kiz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni kama kiubhoko kya bhebhe kya kulia kikusababishila kwikungufula, dumulayi kisha utaghai patali nabhi. Kwandabha ni afadhali kiungo kimonga mu mbele bhwaku kuliko m'bele bhuoha kusopibhwa jehanamu. ");
INSERT INTO kiz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","J'hijobhibhu pia, j'hej'hioha j'ha ikamb'enga n'dala, na ampelai hati j'ha talaka.' ");
INSERT INTO kiz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini nene nikabhajobhela, j'hoj'hioha j'hiakandeka n'dala munu, isipokuj'ha kwa ndabha j'ha zinaa, ambombayi kuj'ha mzinzi. Na j'hej'hioha j'hiikan'gega baada j'ha kup'elibhwa talaka abhombaghe bhuzinzi. ");
INSERT INTO kiz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kabhele, mp'heliki lyajobhibhu kwa bhala bha muandi, 'Mkatai kulapa kwa bhudesi, bali mupelekaghe fiapo fyinu kwa Bwana.' ");
INSERT INTO kiz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini nikabhajobhela, mkata kulapa hata kidogo, ama kwa mbingu, kwa ndabha ndo enzi j'ha K'yara; ");
INSERT INTO kiz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bhwala kwa dunia, kwandabha ndo mahali pa kubheka kiti kya kukanyila njayu syake, ama kwa Jerusalemu, kwa ndabha ndo miji ghya mfalme m'mbaha. ");
INSERT INTO kiz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bhwala usilapi kwa mutu bhwaku, kwandabha ghwibhwesya lepi kubhomba luj'huwili limonga kuj'ha lubhalafu au lutitu. ");
INSERT INTO kiz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bali malobhi ghinu ghaj'helayi, 'Ena, ena, Lepi, lepi.' Kwa kuj'ha ghaghizidi aghu ghihoma kwa j'hola mwovu. ");
INSERT INTO kiz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mup'helikhi j'hijobhibhu kuj'ha, 'Lihu kwa lihu, ni linu kwa linu.' ");
INSERT INTO kiz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini nene nikabhajobhela, Musitolani ni munu muovu; lakini akakutobhai litama lya kulia nsanusilaghe ni leng'he pia. ");
INSERT INTO kiz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na kama j'hoj'hioha ilonda kulota ni bhebhe mahakamani na akunyakili kanzu lya bhebhe, ndekelaghe ni joho lya bhebhe pia. ");
INSERT INTO kiz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na j'hej'hioha j'haikulasimisya kulota naku maili j'himonga, lotayi naku maili mbili. ");
INSERT INTO kiz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","J'hej'hioha jhaikus'oma mpelai, na ukatakunjepa j'hoj'hioha j'hailonda ku kuj'hasima. ");
INSERT INTO kiz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mp'heliki j'hij'hobhibhu un'ganai jirani ghwa j'hobhi, na un'dadilayi adui ghwa jhobhi.' ");
INSERT INTO kiz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini nikabhajobhela, mubhaganai maadui bhinu, mubhas'omelayi bhabhakabhadadisya. ");
INSERT INTO kiz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ili kuj'ha muj'helaghe bhana bha tata j'hinu j'haaj'hele kumbinguni. Kwa kuj'ha ibhomba lij'hobha libhaangasilaj'hi bhabhibhi ni bhanofu, na ikabhatonyela fula bhaovu ni bhanofu. ");
INSERT INTO kiz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kama m'beta kubhagana bhabhikabhagana muenga, mwikabha thawabu gani? Kwani bhatoza ushuru bhibhomba lepi naha? ");
INSERT INTO kiz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na kama mkabhasalimila bhalongobhinu tu mwikabha kiki zidi j'ha bhangi? Je! Bhanu bha mataifa bhibhomba lepi naha? ");
INSERT INTO kiz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Henu j'hilondeka kuj'ha bhakamilifu, kama tata ghwenu ghwa kumbinguni kyaaj'hele n'kamilifu. ");
INSERT INTO kiz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zingatilayi kutokubhomba matendo gha haki mbele sya bhanu ili kwilasya, vinginevyo ghikabhalepi thawabu kuhomela kwa Tata j'ha aj'hele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hivyo basi paghwih'omesya usikhobhi tarumbeta ni kwisifu muene bhanafiki kyabhibhomba mu masinagogi ni mu mitaa, ili kuj'ha bhanu bhabhasifuaj'hi. Kweli nikabhajobhela, bhamalikupokela thawabu j'ha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini bhebhe paghwih'omesya kibhoko kya bhebhe kya kushoto kisimanyi kya kibhoko mbeka nikibhoko kya kulia, ");
INSERT INTO kiz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ili kuj'ha zawadi j'ha bhebhe j'hihomesibhwaghe kwa siri. Ndipo Tata ghwako alangai sirini ibetakup'hela thawabu j'hiakhu. ");
INSERT INTO kiz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na paghwij'ha ghwis'oma, usij'hi kama bhanafiki, kwa kuj'ha bhilonda kuj'hema ni kus'oma mu masinagogi ni mu kona sya mitaani, ili kwamba bhanu bhabhalangai. Kueli nikabhajobhela bhamalili kuj'hambelela thawabu sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini bhebhe, paghwis'oma, j'hingilaghe kugati. Fungai ndiangu na usomaghe kwa dadij'hu j'ha aj'hele sirini. Ndipo Tata ghwako j'hairanga mu siri ibetakupela thawabu j'hiaku. ");
INSERT INTO kiz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na paghwijha ghwis'oma usikhelukiri malobhi ghaghadulili ni maana kama mataifa kya bhibhomba kwa kuj'ha bhifikiri kuj'ha bhibeta kuphelekibhwa kwandabha j'ha malobhi mingi ghabhijobha. ");
INSERT INTO kiz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Henu, usij'hi kama bhene, kwa kuj'ha Tata ghwako amanyili mahitaji gha bhebhe hata kabla us'omili lepi kwa uene. ");
INSERT INTO kiz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Henu s'omaghe naha: Tata ghwetu j'ha uj'hele kunani, ulitukusiaghe litabhu liaku. ");
INSERT INTO kiz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bhufalme bhuaku uhidai mapenzi ghaku ghabhombekai apa paduniani kama okhu kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupelaghe n'kate ghwitu ghwa kila ligono. ");
INSERT INTO kiz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","utusameayi lideni lyitu, kama tete kyatukabhasamehe bhadeni bhitu. ");
INSERT INTO kiz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na usituleti mu majaribu, lakini utuj'hepusiaghe kuhoma kwa j'hola mwovu. ");
INSERT INTO kiz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ikaj'hiaghe m'beta kubhasamehe bhanu makosa ghabhu, Tata ghuakhu j'haaj'hele kumbinguni pia ibetakubhasamehe muenga. ");
INSERT INTO kiz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini ikaj'hiaghe mwibetalepi kubhasamehe makosa ghabhu, bhwala Tata ghuakho ibetalepi kubhasamehe muenga makosa ghinu. ");
INSERT INTO kiz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Zaidi j'ha ghoha, paghwijha ufungili, usilasi sura j'ha huzuni kama bhanafiki kya bhibhomba, kwa kuj'ha bhikunja sura sya bhene ili kuj'ha bhanu bhabhamanyai kuj'ha bhafungili. Kueli nikabhabhola, bhamalili kuj'hambelela thawabu j'ha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini bhebhe, pa ghwij'he ufungili, bakaghe mafuta mutu ghwa j'hobhi na usukaghe pamihu pa j'hobhi. ");
INSERT INTO kiz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hivyo haitakuonyesha mbele ya watu kuwa umefunga, lakini tu itakuwa kwa Baba yako aliye sirini. Na Tata ghwako j'hailola sirini ibetakup'hela thawabu j'ha bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ukatakwitunzila hazina j'ha bhebhe muene apa pa dunia, ambapo nondo ni kutu sij'honanga, ambapo bhaheji bhibomola ni kuh'eja. ");
INSERT INTO kiz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Baada j'hiake, ghwitunzilaghe hazina j'hiakhu muene kumbinguni, ambapo bhwala nondo bhwala kutu jibhwesya lepi kuj'honanga, na ambapo bhah'eji bhibhwesya lepi kubomola ni kuh'eja. ");
INSERT INTO kiz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwa kuj'ha hazina j'ha bhebhe j'hij'hele, ndipo ni muoyo ghwakho paghwibeta kuj'ha pia. ");
INSERT INTO kiz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lihu ndo taa j'ha m'bele. Henu ikaj'helayi lihu lyakhu lisima, m'mbele bhuoha bhwibeta kujasibhwa ni nuru. ");
INSERT INTO kiz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini ikaj'hiaghe lihu lya bhebhe libovu, m'bele bhwakhu bhuovu bhumemili ngisi totoro. Henu, ikaj'hiaghe nuru ambaj'ho ij'hele mugati j'ha bhebhe ndo ngisi hasa ndo ngisi mmbaha kiasi gani! ");
INSERT INTO kiz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","J'hij'helepi hata mmonga j'haibhuwesya kubhatumikila mabwana bhabhele, kwa kuj'ha ibetakun'dadila mmonga ni kun'gana j'hongi, au la sivyo ibetakwih'omesya kwa mmonga ni kun'dharau j'hongi. Mwibhwesya lepi kun'tumikila K'yara ni mali. ");
INSERT INTO kiz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Henu nikujobhela, usiwi ni mashaka kuhusu maisha ghakhu, kuj'ha ghwibeta kulya kiki au ghwibeta kunywa kiki, au kuhusu m'mbele ghwaku, ghwibeta kufuala kiki. Je! Maisha zaidi lepi j'ha kyakulya ni m'bele zaidi lepi ya mavazi? ");
INSERT INTO kiz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Langai fidege fya fij'hele kunani. Bhipanda lepi na bhivuna lepi na bhibhonganya lepi na bhikutunza gharani, lakini Tata ghwa kunani akabhalesya bhene. Je muenga bha thamani lepi zaidi kuliko bhene? ");
INSERT INTO kiz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na niani miongoni mwa muenga kwa kujihangaisya ibhwesya kuj'hongesya dhiraa j'himonga mu bhuhai bhwa maisha ghake? ");
INSERT INTO kiz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na kwandabha j'ha kiki mwij'ha ni bhuogha kuhusu mavazi? Fikirini kuhusu maua mu mig'onda, jinsi kya ghij'ha. Ghibhomba lepi mbombo na ghibhwesya lepi kwifweka. ");
INSERT INTO kiz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bado nikabhajobhela hata Sulemani mu bhutukufu bhwake bhuoha akifweki lepi kama mmonga ghwa agha. ");
INSERT INTO kiz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ikaj'hiaghe K'yara akaghafueka mat'ondo mu mig'onda, ambaghyo ghidumu ligono limonga ni kilabhu ghitaghibhwa mu muoto, je, ni kwa kiasi gani ibetakufwalika muenga, muenga j'ha muj'hele ni imani ndusu? ");
INSERT INTO kiz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Henu musij'hi ni bhuogha ni kujobha, 'Je twibetakulya kiki?' au “Je twibetakunywa kiki?” au “Je twifuala ngobho gani?” ");
INSERT INTO kiz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwa kuj'ha mataifa bhilonda mambo kama agha, ni dadi j'hinu ghwa mbinguni amanyili kuj'ha mwilonda aghu. ");
INSERT INTO kiz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakini h'oti mulondai bhufalme bhuake ni haki j'hiakhe na agha ghoha ghibetakukabidhibhwa kwa j'hoghwe. ");
INSERT INTO kiz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Henu, usibhoni shaka kwandabha j'ha kilabhu, kwa kij'ha j'hibetakwishughulikila j'hiene. Khila ligono kuj'ha ni litalisu lya muene. ");
INSERT INTO kiz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ukataghe kuhukumu naghwe usihidi kuhukumulibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwa hukumu j'ha ghwihukumu, naghwa ghwibeta kuhukumulibhwa. Na kwa kip'hemu kya ghwip'hema naghwe pia ghwibeta kup'hemibhwa kyakuekhu. ");
INSERT INTO kiz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na kwa ndabha j'ha kiki ghwilota kipandi kya libehe kya kuj'hele mu lihu lya ndongobhu, lakini umanyilepi kipandi kya ligogo ambakyo kuj'hele mu lihu lya bhebhe? ");
INSERT INTO kiz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ghwibhesyabhuli kujobha kwa ndongobhu, lendai nikubhosiaghe kipandi kya kij'hele mu lihu lyakhu, bhwakali kipandi kya ligogo kij'hele mu lihu lya j'hoghwe? ");
INSERT INTO kiz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mnafiki bhebhe; kwanza bhosiaghe ligogo lyalij'hele mu lihu lya j'hobhi, na ndipo ghwibetakubhwesya kulola nikukibhosya kipandi kya lib'ehe kyakij'hele mu lihu lya ndongobhu. ");
INSERT INTO kiz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Usibhap'heli mabwa kyakij'hele kitakatifu, na usibhakhesusili maghorobhi, mbele j'ha bhene. Vinginevyo bhibetakufiharibu ni kufikanyatila kwa magolo, na kabhele bhibetakugeukila bhebhe ni kukurarura fipandi fipandi. ");
INSERT INTO kiz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Somaghe, naghwe ghwibetakup'helibhwa. Londai, naghwe ghwibetakukabha. Bishiaj'hi hodi naghwe ghwibetakubhopolibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwa j'hej'hioha j'hola j'haisoma, ij'hamb'elela. Na kwa j'hej'hioha j'hola j'hailonda, ikabha. ");
INSERT INTO kiz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na kwa munu ambaj'he j'haibisha hodi ibekubhopolibhwa. Au kuj'ha ni munu miongoni mwa muenga ambaj'he, ikaj'hiaghe mwanabhe an's'omili kipandi kya nkati akampela liganga? ");
INSERT INTO kiz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au ikaj'hiagha an's'omili somba ni muene akampela liyoka? ");
INSERT INTO kiz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Henu, ikaj'hiaghe muenga mwe bhaovu mm'anyili kubhap'hela bhanabhinu zawadi sinofu, Je! Ni kiasi gani zaidi tata j'ha aj'hele kunani ibetakubhapela fenu finofu bhala bhabhan's'oma muene? ");
INSERT INTO kiz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kwa ndabha ej'hu, paghwilonda kubhombibhwa khenu kyokyoha khela ni bhanu bhangi, naghwe pia j'hikulondeka kubhabhombela mebhwa bhene. Kwa kuj'ha ej'hu ndo sheria ni manabii. ");
INSERT INTO kiz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Muj'hingilaghe kwa kup'hetela ligeti lisekele. Kwa kuj'ha ligeti ndo lipana ni nj'hela ndo j'hipanuiki j'haj'hilongosya mu bhuharibifu, na bhajhenabhu bhangi bhabhip'hetela nj'hela ej'hu. ");
INSERT INTO kiz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Legeti lisekele, Ligeti lisekele ndo nj'hela j'haj'hilongosya mu bhusima na ni bhadebe bhabhibhwesya kujibhona. ");
INSERT INTO kiz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mwikihadhariaj'hi ni manabii bha bhudesi, bhabhihida bha fuele ngozi j'ha ng'osi, lakini bhukuweli ndo mbweha mkali. ");
INSERT INTO kiz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kwa matunda ghabho m'beta kubhamanya. Je bhanu bhibhwesya kuvuna matunda mu mifwa, au mulibeha mu mbeyu j'ha mbaruti? ");
INSERT INTO kiz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kwa namna ej'hu, khila libehe linofu lihogola matunda manofu, lakini libehe libhibhi lihogola matunda mabhibhi. ");
INSERT INTO kiz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Libehe linofu libhwesya lepi kuhogola matunda mabhibhi, bhwala libehe libhibhi libhwesyalepi kuhogola matunda manofu. ");
INSERT INTO kiz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Khila libehe lya lihogola lepi matunda manofu lidumulibhwa ni kutaghibhwa mu muoto. ");
INSERT INTO kiz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Henu, mwibeta kubhamanya kutokana ni matunda gha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Si khila munu j'ha ikam'mbola nene, 'Bwana, Bwana,' ubetakuj'hingila mu bhufalme bhwa kumbinguni, bali muene j'haibhomba mapenzi gha tata ghwangu j'ha aj'hele kumbingni. ");
INSERT INTO kiz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bhanu bhingi bhibetakumbola ligono e'lu, 'Bwana, Bwana, twah'omisi lepi bhunabii kwa lihina lya bhebhe, twabhosi lepi mapepo kwa lihina lya bhebhe, na kwa lihina lya bhebhe twabhombili matendo mingi mabhah?' ");
INSERT INTO kiz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ndipo nibetakubhajobhela bhwasi, 'nabhatambuili lepi muenga! Mubhokaj'hi kwa nene, muenga j'ha mwibhomba maovu!' ");
INSERT INTO kiz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kwa ej'hu, khila mmonga j'haip'heleka malobhi ghangu ni kutii ibetakufuana ni munu j'haaj'hele ni hekima j'haajengili nyumba j'ha muene panani pa muamba. ");
INSERT INTO kiz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fula ikatonya, mafuriko ghakahida, ni mp'ongo ukahida na ukatobha nyumba ej'hu, lakini j'habhwesilepi kubina pasi kwa kuj'ha j'hajengibhu panani pa mwamba. ");
INSERT INTO kiz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lakini khila munu j'haip'heleka lilobhi lyangu naasilitii ibetakufananisibhwa ni munu mpumbafu j'haajengili nyumba j'ha muene panani pa nsanga. ");
INSERT INTO kiz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fula j'hikahida, mafuriko ghakahida ni mp'ongo ukahida ni kuj'hitobha nyumba ej'hu. Na j'habinili, ni bhuharibifu bhwake bhukakamilika.” ");
INSERT INTO kiz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bhafikiri bhwakati ambabho Yesu bho amalili kulongela malobhi agha, makutano bhasyangesibhu ni mafundisu gha muene, ");
INSERT INTO kiz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwa kuj'ha afundisi kama munu j'ha aj'hele ni mamlaka, na sio kama bhalembesi bha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bhwakati Yesu aselili pasi kuh'oma pa kid'onda, bhumati m'mbaha bhwamfwatili. ");
INSERT INTO kiz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Langai, mkoma ahidili ni kusujudu m'b'ele j'ha muene, akajobha, “Bwana, ikaj'hiaghe ujhe tayari ghwibhwesya kunibhomba nj'hiaghe kinofu”. ");
INSERT INTO kiz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu anyosisi kibhoko kya muene ni kun'gusa, akajobha, “Nj'hela tayari. Uj'hiaghe n'safi.” Bahuapu atakasibhu bhukhoma bhuake. ");
INSERT INTO kiz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu an'jobhili, “Langai kwamba usijobhi kwa munu j'hej'hioha. Kamulai nj'hela j'ha bhebhe, na ghwilasiaghe ghwimuene kwa kuhani na uh'omesiaghe zawadi ambayo Musa alaghisi, kwa ndabha j'ha bhushuhuda bhuakhu” ");
INSERT INTO kiz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bhwakati Yesu afikiri Kapernaumu, Jemedari akahida kwa muene akan'kota ");
INSERT INTO kiz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akajobha, “Bwana, n'tumishi ghuangu agonili kunyumba apoozili na ajhele ni maumivu gha kutisya.” Yesu akan'jobhela, ");
INSERT INTO kiz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Nibetakuhida ni kumponesya”. ");
INSERT INTO kiz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jemedari ajibili ni kun'jobhela, “Bwana, nene ghwa thamani lepi hata uhidai ni kuj'hingila mugati mu dari j'ha nene, jobhai lilobhi tu ni n'tumishi ghwangu ibetakupona. ");
INSERT INTO kiz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwa kujha nene pia ndo munu j'haniyele ni mamlaka, na njele ni askari bhabhajhele pasi pa nene. Nikajobhai kwa oj'ho “Lotai' na ilota, na kwa j'hongi 'Hidajhi' na ihida, ni kwa n'tumishi bhwangu, 'Bhombaghe naha,' nu muene ibhomba naha” ");
INSERT INTO kiz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bhwakati Yesu ap'heliki aghu asyangele ni kubhajobhela bhala ambabho bhamfuateghe, “Bhukweli nikabhajobhela. Nibhwajhili lepi kubhona munu mwenye imani kama oj'ho mu Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nikabhajobhela, bhingi bhibetakuhida kuh'omela mashariki ni magharibi, bhibetakutama mu meza pamonga ni Abrahamu, Isaka, ni Yakobo mu bhufalme bhwa mbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini bhana bha ufalme bhibeta kutaghibhwa mu ngisi lya kubhala, ambapo kwibekujha ni khilelu ni kusiagha minu.” ");
INSERT INTO kiz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu akabhajobhela Jemedari, “Lotaghe! Kama kyaumalili kukiera, na j'hibhombekaghe naha kwa bhebhe.” Ni n'tumishi aponyisibhu mu lisaa lelue'lu. ");
INSERT INTO kiz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bhwakati Yesu afikiri pa nyuma j'ha Petro, ambwene nkwibhi ghwa Petro agonili akaj'ha n'tamu ghwa homa. ");
INSERT INTO kiz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ankamuili kibhoko kya muene, ni homa j'ha muene j'hikan'ndeka. Kisha akaj'humuka akaj'handa kun'hudumila ");
INSERT INTO kiz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na bhoj'hifikiri kimihi, bhanu bhakandetela Yesu bhingi bhabhatawalibhu ni pepo. Akabh'enga mapepo ni bhala bhabhaj'he bhabhine abhaponisi. ");
INSERT INTO kiz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kwa jinsi ej'he ghatimili ghala ghaghamali kujobhibhwa ni Isaya nabii, “Muene atolili bhubhine bhwetu na ap'hendili maradhi ghitu” ");
INSERT INTO kiz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kisha Yesu bho alibhwene likusanyiku lya bhanu lin'syonguikhi, apisili maelekezo gha kulota lubhafu longi mwa Bahari j'ha Galilaya. ");
INSERT INTO kiz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kisha mwandishi ahidili kwa muene ni kun'jobhela, “Mwalimu, nibetakufuata popoa pala paghwibeta kul'ota.” ");
INSERT INTO kiz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu an'jhobhili, “Mbweha bhana mal'ende ni fidege fya angani bhaj'he ni fiota, lakini mwana ghwa Adamu aj'helepi ni sehemu j'ha kugoneka mutu bhwakhe.” ");
INSERT INTO kiz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mwanafunzi j'hongi an'jobhili, “Bwana, niruhusiaghe oti nilotaghe kun'siela tata ghwangu.” ");
INSERT INTO kiz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu an'jobhili, “Un'kesiaghe, na ubhalekai bhafu bhasyelayi bhafu bha j'hinu.” ");
INSERT INTO kiz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu bho aj'hingili mu bhuatu, bhanafunzi bhakankesya mu bhuatu. ");
INSERT INTO kiz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Langai, lyaj'handili linyegha libhaa panani pa bahari, kiasi kwamba bhuatu bhwafunikibhu ni manyegha. Lakini Yesu agonili lugono. ");
INSERT INTO kiz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bhanafunzi bhakahida kwa muene ni kunjumusya bhakaj'ha bhijobha, “Bwana, tuokolayi tete, twilota kufwa!” ");
INSERT INTO kiz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu akabhajobhela, kwa ndabha j'ha kiki mwitila, muenga j'ha muj'he ni imani idusu?” Ndipo akaj'humuka ni kubhubesya mp'ongo ni bahari. Kisha kukabhwa ni bhutulivu m'mbaha, ");
INSERT INTO kiz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","bhagosi bhakamuliki ni mshangao m'baha bhakajobha, “Oj'ho ghwa namna gani, kwamba hata mp'ongo ni bahari figudeme kwa muene?” ");
INSERT INTO kiz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bhwakati Yesu ahidili lubhafu longilwa nchi j'ha Magadala, bhagosi bhabhele bha bhatawalibhu ni pepo bhabhonene naku. Bhakaj'ha bhihomela kumakaburi na bhakaj'ha bhibhomba vurugu sana, kiasi kwamba aj'he lepi msafiri ghwa kubhwesya kup'heta nj'hela j'hela. ");
INSERT INTO kiz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Langaghe, bhakwesili sauti ni kujobha, “Tuj'he ni kiki kya kubhomba kwa bhebhe, mwana ghwa K'yara? Uhidili apa kututesya kabla j'ha bhwakati kufika?” ");
INSERT INTO kiz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Henu likundi libhaha lya maghorobhi aj'hele likidima, paj'helelepi patali ni pabhaj'hele, ");
INSERT INTO kiz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","pepo bhaj'handelili kulalamika kwa Yesu ni kujobha, “Ikaj'hiaghe wibetakutuamuru kubhoka, tulongosiaghe mu likundi lya maghorobhi.” ");
INSERT INTO kiz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu akabhajobhela, “Mlotaghe!” Pepo bhakabhoka ni kubanga kwa maghorobhi. Na langaghe, likundi lyoha lyaselili kuhomela kukid'onda kuserelela ku bahari na lyoha lyafwelili mu masi. ");
INSERT INTO kiz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bhagosi bhabhaj'hele bhidima maghorobhi bhajumbili. Na bho bhalotili kumjini bhakaj'helesya khila khenu, hususani kyakyatokili kwa bhagosi bhabhatawalibhu ni mapepo. ");
INSERT INTO kiz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Langaghe, mji bhuoha ukahida kubhonana ni Yesu. Bho bhabhuene, bhakan'sihi abhokai mu mkoa ghwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu akaj'hingila mu liboti, akalobhokha na akafika mu mji ghwa atameghe. ");
INSERT INTO kiz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Langaghe bhandetili munu j'haapozili agonili mu ligodoro. bho ajhibhuene imani j'ha bhene, Yesu akan'jobhela munu j'ha apoozili, “Mwanabhangu, uj'hiaghe ni furaha, Dhambi sa j'hobhi lisamehibhu” ");
INSERT INTO kiz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Langaghe, Baadhi j'ha bhalimu bha sheria bhakajobhesana bhene kwa bhene, “Munu oj'ho ikufuru” ");
INSERT INTO kiz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu akaghamanya mabhuasu gha bhene na akajobha, “Kwa ndabha j'ha kiki mwibhuasya maovu mu mioyo ghinu? ");
INSERT INTO kiz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Khelekhu kya kij'hoj'hofu kujobha, 'Dhambi sa j'hobhi simalikusamehebhwa' au kujobha, 'Uj'hemaghe na ugendayi?' ");
INSERT INTO kiz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lakini mmanyaghe j'he kuj'ha Mwana ghwa Adamu aj'he ni bhuwezo bhwa kusamee dhambi...” aghajobhi agha kwa j'hola amalikupooza, “J'hemai. tolayi ligodoro lya j'hobhi, na ulotaj'hi kunyumba kwa j'hobhi” ");
INSERT INTO kiz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndipo munu j'hola akaj'hema ni kubhoka kulota kunyumba kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Makutano bho bhaghabhuene agha, bhashangale ni kunsifu K'yara, ambaj'he abhapelili bhuwezo obhu bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na Yesu bho ip'heta kuh'omela apu ambwene munu ambaj'he akutibhu kwa lihina lya Mathayo, ambaj'he aj'hele atamili sehemu j'ha bhatoza ushuru. Ni muene akan'jobhela, “Nikhesiayi nene” Ni muene aj'hema nu kunkesya. ");
INSERT INTO kiz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ni Yesu bho atamili ili aliayi kyakulya mugati mu nyumba bhakahida bhatoza ushuru bhingi ni bhanu bhaovu bhakashiriki pamonga ni Yesu ni bhanafunzi bha muene. ");
INSERT INTO kiz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ndipo Mafarisayo bho bhaghabhuene agha bhakabhajobhela bhanafunzi “Kwandabha j'ha kiki mwalimu ghwa j'homu ilya kyakulya ni bhatoza ushuru ni bhanu bhaovu pamonga?” ");
INSERT INTO kiz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu bho ap'heliki ni afya j'hinofu bhilonda lepi n'ganga, isipokuj'ha kwa bhala bhabhine tu. ");
INSERT INTO kiz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","J'hikabhalondeka mul'otaghe mukwimanyisiaghe maana j'hiake, “Niganili rehema na siyo dhabihu” Kwa kuj'ha nahidili, si kwa bhenye haki kutubu, lakini kwa bhabhajhe ni dhambi. ");
INSERT INTO kiz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ndipo bhanafunzi bha Yohana bhakahida kwa muene ni kujobha, “Kwa ndabha j'ha kiki tete ni mafarisayo twifunga, lakini bhanafunzi bha j'hobhi bhifunga lepi?” ");
INSERT INTO kiz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akabhajobhela, Je bhasindikizaji bha harusi bhibhwesya kuj'ha ni huzuni pindi Bwana arusi paijha pamonga nabhu? Lakini magono ghihida ambapo Bwana arusi ibetakutolibhwa kuh'oma kwa bhene, na ndipo pabhibetakufunga. ");
INSERT INTO kiz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aj'helepi munu j'haibheka kipandi kya ngobho mpya mu ngobho j'ha muandi, kiraka kibetakubhosibhwa kuh'oma mu ngobho ni kakachulilu kabhaa kibetakutokela. ");
INSERT INTO kiz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bhaj'helepi bhanu bha bhibheka mvinyo mpya mu khenu kya mvinyo bhwa muandi, ikaj'hiaghe bhibeta kubhomba, ngosi j'hihatuka, mvinyo bhwibhokha ni ngozi j'hij'honangheka. Badala j'hiakhe, bhibheka mvinyo mpya mu ngozi mpya na fyoha fibetakuj'ha salama. ");
INSERT INTO kiz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bhwakati Yesu bho aj'hele akabhajobhela mambo agha, langaghe, afisa akahida akasujudu mb'ele j'ha muene, Nu muene akajobha, “Mwalibhangu afuili henu naha, lakini hidayi na ubhekai kibhoko kya j'hobhi panani pa muene nu muene ibetakuishi kabhele. ");
INSERT INTO kiz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ndipo Yesu akaj'hema ni kun'kesya ni bhanafunzi bha muene pia. ");
INSERT INTO kiz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Langaghe, n'dala ambaj'he aj'hele ihoma muasi kwa muda ghwa miaka mibhele, akahida karibu ni Yesu na akakamula sehemu j'ha pindo lya livazi lyake. ");
INSERT INTO kiz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwa kuj'ha ajobhili, “Kama nibetakukamula livazi la muene, ni nene nibekukabha uponyaji.” ");
INSERT INTO kiz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu asanuiki ni kundanga ni kun'jobhela.” Mwalibhangu, kip'elayi muoyo, imani j'ha bhebhe j'hikubhombili uponayi,” Na muda bhobhuobhu n'dala akakabha kupona. ");
INSERT INTO kiz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na Yesu bho afikiri pa nyumba j'ha afisa abhabhuene bhalehobha tarumbeta ni bhumati bhwa bhanu bhakaj'ha bhipiga makhelele. ");
INSERT INTO kiz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ni muene akajobha, “Mubhokaj'hi apa, kwa ndabha mwali oj'ho afwilepi agonili. Lakini bhene bhakaheka ni kunkebehi. ");
INSERT INTO kiz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na bhala bhana bho bhah'omesibhu kwibhala, ni akaj'hingila kugati ni kunkamula kibhokho ni n'dala akaj'humuka. ");
INSERT INTO kiz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ni habari e'se sikaj'henela katika mji bhuoha. ");
INSERT INTO kiz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ndipo Yesu bho ip'heta kuhoma pala, bhagosi bhabhele fipofu bhakankesya. Bhakaj'handelela kukwesya sauti bhakaj'ha bhijobha, “Twis'oma uturehemu, Mwana ghwa Daudi.” ");
INSERT INTO kiz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pindi Yesu bho afikiri mu nyumba, bhala fipofu bhakahida kwa muene, Yesu akabhajobhela, “Mwikyera kuj'ha nibhwesya kubhomba?” Na bhene bhakan'jobhela “Ena, Bwana” ");
INSERT INTO kiz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ndipo Yesu akakamula mihu gha bhene ni kujobha “Na j'hibhombekai naha kwa muenga kama imani j'ha muenga kyaij'hele” ");
INSERT INTO kiz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na mihu gha bhene ghakafumbuka. Ndipo Yesu akasisitisya akabhaamuru nikujobha “Mulangayi munu j'hej'hioha j'hola asimanyi kuhusu lijambo e'le.” ");
INSERT INTO kiz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini bhanu abha bhabhele bhakabhoka ni kutangasya habari e'se sehemu syoha sya mji. ");
INSERT INTO kiz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ndipo bhala bhagosi bhabhele bhobhikwilotela, Langayi, munu mmonga bubu ambaj'he apagewa ni mapepo alitibhu kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ni pepo bhambokili, yola munu bubu aj'handa kulongela. Bhumati bhusyangasibhwa ni kujobha “Ej'he j'hibhwaj'hi lepi kuh'omela mu Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini mafarisayo bhakaj'ha bhijobha “Kwa bhabhaha bha pepo, akabhabhenga mapepo” ");
INSERT INTO kiz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu akalota mu miji ghioha ni vijiji. Nu muene akaj'hendelela kumanyisya mu masinagogi, akihubiri injili j'ha bhufalme, ni kuponesya bhubhine bhwa kila aina ni bhudhaifu bhwa aina syoha. ");
INSERT INTO kiz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bhwakati ilola bhumati, kwa ndabha bhasumbuikhi ni kudumuka mioyo. Bhaj'hele kama makondoo ghaghadulili n'dimaji. ");
INSERT INTO kiz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nu muene akabhajobhela bhanafunzi bha muene. “Mavuno ndo mingi, lakini bhabhomba mambo bhadebe. ");
INSERT INTO kiz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Henu manyata mun'somaghe Bwana ghwa mavuno, ili abhatumaghe bhabhomba mbombo mu mavuno ghakhe. ");
INSERT INTO kiz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu akabhakhuta bhanafunzi bha muene kumi na bhabhele pamonga ni kubhapela mamlaka juu j'ha pepo bhachafu, kubhakemela ni kubhabhenga ni kuponesya aina syoha sya maradhi ni aina syoha sya bhubhine. ");
INSERT INTO kiz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mahina kumi na mabhele ndo agha. Lya kubhwandelu simeoni (ambaj'he pia ikutibhwa Petro), ni Andrea n'dombobhe, Yakobo mwana ghwa Zebedayo, ni Yohana ndombomunu: ");
INSERT INTO kiz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philipo, ni Bartelemayo, Thomaso, ni Mathayo mtoza ushuru, Yakhobo mwana ghwa Alfayo, ni Tadeo, ");
INSERT INTO kiz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mkananayo, ni Yuda iskariote, ambaj'he ansaliti. ");
INSERT INTO kiz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Abha kumi ni bhabhele Yesu abhatumili. Nu muene akabhaj'helekesya akajobha “Musiloti sehemu kwa bhitama mataifa na musijhingili mu miji ghya bhasamalia. ");
INSERT INTO kiz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Badala j'hiakhe, mlotaghe kwa makondoo ghaghaj'haghili gha nyumba j'ha Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na pamwilota muhubinaghe ni kujobha bhufalme bhwa mbinguni bhukaribiri.' ");
INSERT INTO kiz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mubhaponyaghe bha bhine, mubhafufulaghe bhafu, mutakasiaghe bhenye bhokhoma na mubhengai pepo. Mupokhiri mebhu, mupisiaghe mebhu. ");
INSERT INTO kiz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Musitoli dhahabu, almasi au shaba mu pochi syinu. ");
INSERT INTO kiz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Usitoli nkoba mu safuari j'hinu, au nghobho sya ziada, firatu au ndonga, kwa kuj'ha mmbombambombo ilondeka kukabha kyakulya kya muene. ");
INSERT INTO kiz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mji bhobhuaha bhola au kijiji kya mwibeta kuj'hingila, mulondayi ambaye ilondeka na mtamayi pala mpaka pa mwibhokha. ");
INSERT INTO kiz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamwibeta kuj'hingila mu nyumba muponesiaghe, ");
INSERT INTO kiz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","endapo nyumba j'hilondeka amani j'hinu j'hisyalaghe pala, lakini kama nyumba j'hilondeka lepi, amani j'ha muenga j'hibhokaghe pamonga namu. ");
INSERT INTO kiz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na kwa bhala bhabhapokili lepi muenga au kubhap'helekesya malobhi ghinu, bhwakati mwibhoka mu nyumba au mji obhu, mwikipolosiayi mafumbo gha nyayo sya muenga mahala apu. ");
INSERT INTO kiz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kweli nikabhajobhela, j'hibetakuj'ha j'ha kustahimili zaidi miji ghya Sodoma ni Gomorah ligono lya hukumu kuliko mji obhu. ");
INSERT INTO kiz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Langai, nikabhalaghisya kama kondoo pagati pa mbwamwitu, kwa henu, muj'hiaghe ni bherevu kama liyoko ni bhapole kama nj'hebha. ");
INSERT INTO kiz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muj'hiaghe bhaangalifu ni bhanu, bhibetakubhap'eleka mu mabaraza, na bhibetakubhatobha mu masinagogi. ");
INSERT INTO kiz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mwibetakuletibhwa m'bele j'ha bhabhaha ni bhafalme kwa ndabha j'hangu, kama bhushuhuda kwa bhene ni kwa mataifa. ");
INSERT INTO kiz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pindi pabhibetakubhashutumu, musij'hi ni bhuogha jinsi gani au kiki kya kulongela, kwa kuj'ha k'henu kya kujobha mwibekupelibhwa kwa bhwakati bhobhuobhu. ");
INSERT INTO kiz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa kuj'ha sio muenga mwamwibeta kulongela, lakini Roho ghwa Tata j'hinu ibetakulongela, mugati mwinu. ");
INSERT INTO kiz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ndongo ibetakunjinukila ndongomunu kunkoma, ni tata kwa mwanabhe. Bhana bhibetakuj'hinuka dhidi j'ha bhazazi, ni kubhasababishila kufwa. ");
INSERT INTO kiz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namu nibetakudadibhwa ni kila munu kwandabha j'ha lihina lya nene. Lakini j'hej'hioha j'hola j'haibetakuvumilila mpaka kumwishu munu oyu ibetakuokolibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pindi bhikabhatesya mu mji obhu, mujumbilayi mji ghwa ghifuatila, kwa kuwele nikabhajobhela mwibetalepi kuj'ha mulotilli mu miji ghioha ghya Israeli kabla ya mwana ghwa Adamu kukerebhuka. ");
INSERT INTO kiz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mwanafunzi nkholo lepi kuliko mwalimu ghwa muene, bhwala n'tumwa j'haaj'hele panani pa Bwana ghuake. ");
INSERT INTO kiz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","J'hitosya kwa mwanafunzi kuj'ha kama mwalimu ghwa muene ni n'tumishi kuj'ha kama Bwana ghwakhe. Ikaj'hiaghe bhankutili Bwana ghwa nyumba Belzabuli, ni kwa kiasi gani zaidi bhibetakubhakashfu bha nyumba j'hiakhe! ");
INSERT INTO kiz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hivyo basi musij'hi ni bhuogha kwa bhene, kwa kuj'ha lij'helepi lijambo ambalyo libetalepi kufunulibhwa na lij'hele lepi lyalikifighili ambalyo libetakwifigha. ");
INSERT INTO kiz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Khela kyanikabhajobhela mu ngisi, musijobhi mu nuru, na kyamukakipeleka kwa bhulaini mu m'bolokhoto syinu, mukitangasiaghe mkaj'hiaghe panani pa nyumba. ");
INSERT INTO kiz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Musibhatili bhala ambabho bhikhoma m'bhele lakini bhaj'helepi ni bhuwezo bhwa kukhoma roho. Badala j'hiakhe, mwuntilaghe j'hola ambaj'he j'haibhwesya kuj'hangamisya m'b'ele ni roho khola kuzimu. ");
INSERT INTO kiz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Je kasuku bhabhele bhigolesibhwa lepi kwa senti idebe? Hata ivyo aj'helepi j'ha ibhwesya kubina pasi bila Tata j'hinu kumanya. ");
INSERT INTO kiz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakini hata idadi j'ha njuwili sa muenga sibhalangibhu. ");
INSERT INTO kiz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Musij'hi ni hofu, kwa kuj'ha muj'he ni thamani zaidi kuliko kasuku bhingi. ");
INSERT INTO kiz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hivyo basi khila mmonga j'haibetakunikiri mb'ele sya bhanu, nani pia nibetakunkiri mbele sya Tata ghwangu j'haaj'hele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini muene j'haibetakunibela nene mbele sya bhanu, nani pia nibetakumb'ela mbele j'ha Tata ghwangu j'ha aj'hele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Musifikiriri kuj'ha nihidili kuleta amani pa duniani. Nikahidi lepi kuleta amani, lakini bhupanga. ");
INSERT INTO kiz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwa kuj'ha nahidili kumb'heka munu apinganaj'hi ni tata ghwake, ni binti dhidi j'ha nyinamunu, ni nkuwibhi dhidi j'ha mkwe ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Adui ghwa bhanu bhibhetakuj'ha bhala bha kunyumba kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Muene j'ha an'ganili tata au mabhu zaidi kuliko nene oj'hu nikandondalepi. Na muene j'ha an'ganili nsongolo au mmenja zaidi kuliko nene oj'hu nikandondalepi. ");
INSERT INTO kiz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Muene ambaj'he ibetalepi kup'enda nsalaba ni kunikhesya nene oj'hu nikandonda lepi. ");
INSERT INTO kiz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Muene j'haibetakulonda maisha ibetakughaj'hasya. Lakini muene j'haibetakughaj'hasya maisha kwa ndabha j'hangu ibetakughakabha. ");
INSERT INTO kiz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Muene j'haibetakubhakaribisya anikaribisi nene, ni muene j'haibetakunikaribisya nene an'karibisi muene j'ha anitumili nene. ");
INSERT INTO kiz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu muene j'haibetakunkaribisya nabii kwa ndabha ndo nabii ibetakupokela thawabu j'ha nabii. Nu muene j'haibetakun'karibisya mwenye haki kwa ndabha ndo munu ghwa haki ibetakupokela thawabu kwa munu ghwa haki. ");
INSERT INTO kiz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","J'hoj'hioha j'haibetakumpela mmonga ghwa bhadebe abha, hata kikombi kya masi gha kunywa masisimu, kwa ndabha muene ndo mwanafunzi, kweli nikabhajobhela, muene ibhwesyalepi kudula kwa nj'hela j'hoj'hioha thawabu j'hiakhe. ");
INSERT INTO kiz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ikabhwa baada j'ha Yesu kumala kubhaj'helekesya bhanafunzi bha muene kumi na bhabhele abhokhili pala kulota kumanyisya ni kuhubiri mu miji ghiabhu, ");
INSERT INTO kiz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ni Yohana bho aj'he kuligereza bho ap'heliki aj'hele panani pa matendo gha Kristu, alaghisye bhujumbe kup'etela bhanafunzi bha muene, ");
INSERT INTO kiz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na bhakankota, “Bhebhe ndo j'hola j'ha ihida, au aj'hele j'hongi twilondeka kundendela?” ");
INSERT INTO kiz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ajibili nikujobha kwa bhene “'Mulotayi mukan'jobhilayi Yohana ghala gha mukaghabhona ni kughap'heleka. ");
INSERT INTO kiz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bhanu bhabhilolalepi bhibeta kulola, viwete bhibeta kutakasibhwa, bhana bhabhipeleke lepi bhib'eta kup'eleka kabhele, bhana bhabhafuili bhibetakufufulibhwa kukabha bhuhai, na bhanu bhabhilonda bhihubiriwa habari jhinofu. ");
INSERT INTO kiz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na abarikibhu jhola jhaibhonalepi shaka juu jha nene. ");
INSERT INTO kiz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pindi bhanu abha bhobhabhokili, Yesu akaj'handa kujobha ni bhumati kuhusu Yohana, “Kiki mwalotili kulola kulijangwa__lidete lihugunisibhwa ni mp'ongo? ");
INSERT INTO kiz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lakini kiki mwalotili kubhona__munu j'haafuele mavazi mololo? Hakika, bhala bhabhifuala mavazi mololo bhitama mu nyumba sya bhafalme. ");
INSERT INTO kiz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakini mwabhokhili kulola kiki-Nabii? Ena, nikabhajobhela, na zaidi j'ha Nabii. ");
INSERT INTO kiz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Oj'ho ndo aj'handikibhu, 'Langai, nikandaghisya mjumbe ghwangu mbele j'ha uso bhuakhu, ambaj'he ibetakuandala nj'hela j'ha bhebhe mbele j'ha bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nene nikabhajobhela bhukweli, kati j'ha bhabhahogoliki ni bhadala aj'helepi j'haaj'he m'mbaha kuliko Yohana Mbatizaji. Lakini aj'hele n'debe mu bhufalme bhwa mbinguni ndo mmbaha kuliko muene. ");
INSERT INTO kiz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuhoma magono gha Yohana Mbatizaji mpaka henu, bhufalme bhwa mbinguni ni bhwa ngofu, na bhanu bhenye ngofu, bhikautola kwa ngofu. ");
INSERT INTO kiz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwa kuj'ja manabii ni sheria, imekuwa bhakitabiri mpaka kwa Yohana. ");
INSERT INTO kiz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na kama muj'hela tayari kuj'hetekela, oj'ho ndo Eliya, j'hoola j'haihida. ");
INSERT INTO kiz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","J'haaj'hele ni mbolokhoto sya kup'heleka na ap'helekai. ");
INSERT INTO kiz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nikil'eng'enesiayi ni kiki kizazi e'khe? ni mfwanu ghwa bhana bhabhikhina maeneo gha pa soko, babhitama ni kukutana ");
INSERT INTO kiz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ni kujobha, 'Twabhakhobhili zamori na mwakinilepi. Twaombolizi, na mwal'elililepi.' ");
INSERT INTO kiz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwa kuj'ha Yohana ahidili bila kulya nkate au kunywa mvinyo, na bhakaj'ha bhijobha, 'Aj'he ni pepo.' ");
INSERT INTO kiz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana ghwa Adamu ahidili akaj'ha ilya ni kunywa na bhajobhili 'Langai, munu mlyaji ni n'defi, nkamu ghwa bhatoza ushuru na bhenye dhambi!' Lakini heshima j'hidhihirishibhwa kwa matendo ghakhe.” ");
INSERT INTO kiz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu aj'handili kuj'hikhemela miji ambamo baadhi j'ha matendo ghakhe gha ajabu ghabhombiki, kwa ndabha bhabeli kutubu, ");
INSERT INTO kiz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ole bhwakhu, Kolazini, Ole bhwakhu Bethsaida! Kama matendo mabhaha ngaghabhombiki Tiro ni Sidoni ghala ghaghabhombiki apa, ngabhaj'hele bhamali kutubu muandi kwa kufuala magunila ni kubakala malyenge. ");
INSERT INTO kiz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lakini j'hibetakuj'ha bhuvumilivu kwa Tiro ni Sidoni ligono lya hukumu kuliko kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bhebhe, Kapernaum, ghwidhanila ghwibetakuj'hinulibhwa hadi kumbinguni? Lepi ghwibeta kuselesibhwa hadi pasi kuzimu. Kama kwa Sodoma ni kubhombibhwa matendo mabhaha, kama kyaghabhombiki kwa bhebhe, ngaj'hij'hele hadi lelu. ");
INSERT INTO kiz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bali nijobha kwa bhebhe kuj'ha j'hibetakuj'ha rahisi kwa nchi j'ha Sodoma kuj'hema ligono lya hukumu kuliko bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Katika muda obho Yesu ajobhili, “Nikusifu bhebhe, Tata, Bwana ghwa Mbingu ni Nchi, kwa ndabha ghwabhafighili mambo agha bhenye hekima ni bhufalme, ni kiughafunula kwa bhasio ni elimu, kama bhana bhadebe. ");
INSERT INTO kiz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata kwa kuj'ha j'hakupendisi naha pamihu pa bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mambo agha ghakabidhibhu kwa nene kuhoma kwa Tata. Na aj'helepi j'ha ammanyili mwana isipokuj'ha Tata, na aj'helepi j'haammanyili Mwana, na j'hej'hioha j'hola ambaj'he Mwana aj'he ni hamu j'ha kumfunulila. ");
INSERT INTO kiz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Muhidai kwa nene, muenga mwebhobha mwamisumbulibhwa ni kuelemebhwa ni misighu misitu, nani nibetakukup'omosesya. ");
INSERT INTO kiz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwikipelai nira j'hangu ni mwikifundisiaghe kuhoma kwa nene, kwa kuj'ha nene ne nyenyekevu na mololo ghwa muoyo na mwikabha kuj'homosekelu ka nafsi syenu. ");
INSERT INTO kiz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwa kuj'ha nira j'hangu j'hilaini ni misighu ghiangu mipepe. ");
INSERT INTO kiz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bhwakati obhu Yesu alotili ligono lya sabato kup'hetela mumigonda. Bhanafunzi bha muene bha j'hele ni njala na bhakayanda kughadumula masuke ni kulya. ");
INSERT INTO kiz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lakini Mafarisayo bho bhabhuene aghu, bhakan'jobhela Yesu “Langai bhanafunzi bha j'hobhi bhifunja sheria bhibhomba ligono lyaliruhusibhu lepi ligono lya Sabato” ");
INSERT INTO kiz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lakini Yesu akabhajobhela, “Msomilepi jinsi Daudi kya abhombili, bhwakati aj'hele ni njala, pamonga ni bhana bha aj'he nabhu? ");
INSERT INTO kiz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Namna kyaaj'hingili mgati mu nyumba j'ha K'yara ni mikate ghya bhonyesho, ambaghyo ghyaj'hele lepi halali kwa muene kulya ni bhala bhaaj'hele nabhu, ila halali kwa Makuhani? ");
INSERT INTO kiz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bado musomilepi mu sheria, kuj'ha ligono lya Sabato Makuhani mugati mu lihekalu j'hikainajisi Sabato, lakini bhaj'helepi ni hatia? ");
INSERT INTO kiz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lakini nijobha kwa muenga kuj'ha j'ha aj'he mmbaha kuliko hekalu aj'he apa. ");
INSERT INTO kiz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kama ngamumanyi ej'he j'himaanisha kiki; nilonda rehema na sio dhabihu ngamubhahukumuili lepi bhabhaduli hatia, ");
INSERT INTO kiz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwa kuj'ha Mwana ghwa Adamu ndij'je Bwana ghwa Sabato.” ");
INSERT INTO kiz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kisha Yesu akabhoka pala akalota mu lisinagogi lyabhu. ");
INSERT INTO kiz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Langaghe twaj'hele ni munu j'haapozili kibhoko. Mafarisayo bhakankota Yesu, bhakajobha. “'Je, ndo halali kuponesya ligono lya Sabato?” ili bhabhwesiaghe kumshtaki kwa kubhomba dhambi. ");
INSERT INTO kiz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu akabhajobhela, “Niani kati j'ha muenga, ambaj'he ikaj'hiaghe ni likondoo limonga, ligono e'lu likabina mu lil'ende ligono lya sabato, ibetalepi kun'kamula ni kumbosya kwa ngofu ligono lya sabato mulil'ende? ");
INSERT INTO kiz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Je, k'heleku kyakij'hele ni thamani, zaidi hoti, si zaidi j'ha likondoo! Henu ni halali kubhomba manofu ligono lya Sabato.” ");
INSERT INTO kiz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kisha Yesu akabhajobhela munu y'ola, “Nyoosyaghe kibhoko” Akanyosya, na ukakabha afya, kama bhongi bhola. ");
INSERT INTO kiz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lakini Mafarisayo bhakap'hita kwibhala ni kupanga jinsi j'ha kunjangamisya bhakalota kwibhala kupanga kinyume kyake. Bhaj'hele bhilonda jinsi j'ha kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu bho aj'helibhu e'le akabhoka apu. Bhanu bhingi bhakan'kesya na akabhaponya bhoha. ");
INSERT INTO kiz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akabhalaghisya bhasihidi bhakambomba amanyikanai kwa bhangi, ");
INSERT INTO kiz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","kwamba j'hitimilayi j'hela kweli, j'haj'hikajobhibhu ni nabii Isaya, akajobha, ");
INSERT INTO kiz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Langai, mtumishi bhwangu j'hanin'salili n'ganwa ghwangu, kwa muene nafsi j'ha nene j'hihobhwiki. Nibetakubheka Roho j'hangu panani pa muene, na ibetakutangasya hukumu kwa Mataifa. ");
INSERT INTO kiz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ibetalepi kuhangaika bhwala kulela kwa ngofu; bhwala j'hoj'hioha j'hola kup'heleka sauti j'ha muene mitaani. Ibetalepi kulidumula lidete lyalichubulibhu; ");
INSERT INTO kiz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ibetalepi kusimisya bhutambi bhobhuoha bhwabhwihomesya liosi, mpaka pa mwibeta kuleta hukumu na j'hitolaghe. ");
INSERT INTO kiz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ni Mataifa bhibetakuj'ha ni bhujasiri mu lihina lyake. ");
INSERT INTO kiz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Munu fulani kipofu ni bubu, j'haapagawa ni pepo aletibhu mbele j'ha Yesu. Amponyisi, pamonga ni matokeo gha munu bubu ajobhili ni kulola. ");
INSERT INTO kiz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Makutano bhoha bhashangale ni kujobha, “J'hibhwesekana munu oj'ho muana ghwa Daudi?” ");
INSERT INTO kiz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini pindi Mafarisayo bho bhap'heliki muujiza obho bhakajobha, “Munu oj'ho ibhosya lepi pepo kwa ngofu sya muene isipokuj'ha kwa ngofu sya Belzebuli, m'baha ghwa pepo. ");
INSERT INTO kiz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","“Lakini Yesu amanyili fikra sya bhene na akabhajobhela, “Kila bhufalme bhwa bhugawanyiki bhuene bhwiharibika, ni khila mji au nyumba j'haj'higawanyika j'hiene j'hij'hema lepi. ");
INSERT INTO kiz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikaj'hiaghe Syetani, ibetakumbosya Syetani, basi ikipinga mu nafsi j'ha muene. ");
INSERT INTO kiz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni namna gani bhufalme bhwake bhwibeta kuj'hema? Na kama nibhosya pepo kwa ngofu sya Belizabuli, bhafuasi bhinu bhibetakubhosya kwa nj'hela j'ha niani? Kwa ndabha j'ha e'le bhibetakuj'ha mahakimu bhinu. ");
INSERT INTO kiz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na kama nibhosya pepo kwa ng'hofu sya Roho ghwa K'yara, basi bhufalme bhwa K'yara bhuhidili kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Na munu ibetakubhwesya bhuli kuj'hingila mu nyumba j'ha munu mwenye nghofu ni kuh'eja, bila kun'konga mwenye nghofu hosi? Ndipo ibetakuh'eja mali ghakhe kuhoma mugati mu nyumba. ");
INSERT INTO kiz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","J'hej'hoiha j'hola j'haabeli kuj'ha pamonga nani aj'he kinyume ni nene, ni j'haibetalepi kubhongan'ya pamonga nani oj'hu itabhwanya. ");
INSERT INTO kiz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa hiyo nijobha kwa muenga, kila dhambi ni kufuru bhana bhibetakusamehebhwa, ila kun'kufuru Roho Mtakatifu bhibetakusamehebhwalepi ");
INSERT INTO kiz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32",". Na j'hej'hioha j'haijobha lilobhi kinyume kya Mwana ghwa Adamu, e'lu libetakusamehebhwa. Lakini j'hej'hioha j'hola j'haijobha kinyume ni Roho Mtakatifu, oj'hu ibetalepi kusamehebhwa mu bhulimwengu obho, na bhwala bhola bhwa bhwihida. ");
INSERT INTO kiz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ama ubhombaghe libehe kuj'ha linofu ni litunda lyake kuj'ha linofu, au uharibuaj'hi litunda ni libehe lyake, kwa kuj'ha libehe litambulisibhwa kwa litunda lyakhe. ");
INSERT INTO kiz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Muenga kizazi kya liyoka, muenga bhaovu, mwebhwesya bhuli kujobha mambo manofu? Kwa kuj'ha kinywa kijobha kuhoma mu akiba j'ha ghaghaj'hele mu muoyo. ");
INSERT INTO kiz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munu nnofu mu akiba j'hinofu j'ha muoyo bhwake ghihoma manofu, na munu muovu mu akiba ovu j'ha muoyo bhwake ghwih'omesya kyakyaj'hele kiovu. ");
INSERT INTO kiz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nikabhajobhela kuj'ha mu ligono lya hukumu bhanu bhibetakuh'omesya hesabu j'ha khila lilobhi lyalij'helepi ni maana lyabhalijobhili. ");
INSERT INTO kiz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwa kuj'ha malobhi gha j'hobhi ghwibetakubhalangibhwa haki ni kwa malobhi gha j'hobhi ghwibetahukumibhwa.” ");
INSERT INTO kiz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kisha baadhi j'ha bhaandishi ni Mafarisayo bhan'jibili Yesu bhakajobha” Mwalimu, tulondeghe kubhona ishara kuhoma kwa bhebhe.” Lakini Yesu akajibu ni kubhajobhela, “Kizazi kiovu na lya zinaa kilonda ishara. ");
INSERT INTO kiz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lakini j'hij'helepi ishara j'haj'hibetakupisibhwa kwa bhene isipokuj'ha j'hela ishara j'ha Yona nabii. ");
INSERT INTO kiz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kama vile nabii Yona kyaaj'hele mugati mu lileme lya somba m'baha kwa magono madatu pamusi ni pakilu, hivyo ndivyo Mwana ghwa Adamu kyaibetakuj'ha mugati mu mioyo ghya nchi kwa magono madatu pamusi ni pakilu. ");
INSERT INTO kiz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bhanu bha ninawi bhibetakuj'hema mbele j'ha hukumu pamonga ni kizazi kya bhanu abha ni bhibetakukihukumu. Kwa kuj'ha bhatubuili kwa mahubiri gha Yona, na langai, munu fulani m'baha kuliko Yona apa. ");
INSERT INTO kiz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Malkia ghwa kusini ibetakujhinuka mu hukumu pamonga ni bhanu bha kizazi e'khe ni kukihukumu. Ahidili kuhoma miisho ghya dunia kuhida kup'heleka hekima j'ha Selemani, na langai, munu fulani m'baha kuliko Selemani aj'hele apa. ");
INSERT INTO kiz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bhwakati pepo bhachafu bhakamboka munu ghip'heta mahali papaj'helepi ni masi ilonda kup'homoseka, lakini akapabhona lepi. ");
INSERT INTO kiz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kisha ijobha, “Nibetakherebhuka mu nyumba j'hangu j'hanihomili.' Paikherebhuka akajhikholela nyumba j'hisafishibhu na ij'hele tayari. ");
INSERT INTO kiz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kisha huenda ni kubhaleta bhangi roho bhachafu saba bhabhaj'hele bhabhibhi zaidi kuliko muene, ghihida kutama ghoha pala. Ni hali j'hiakhe j'ha mwisho huwa j'hibhibhi kuliko j'ha kubhwandelu. Efe ndo kyaj'hibeta kuj'ha kwa kizazi ekhe kiovu. ");
INSERT INTO kiz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bhwakati Yesu ilongela ni bhumati langai, nyinamunu ni bhalongomunu bhakhaj'hema kwibhala, bhakaj'ha bhilonda kulongela nakhu. ");
INSERT INTO kiz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Munu mmonga akan'jobhela, “Langai nyinuaku ni bhalongobhu bhaj'hemili kwibhala bhilonda kulongela ni bhebhe”. ");
INSERT INTO kiz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu ni kun'jobhela j'haan'jobheleghe, “Mabhu ndo niani? Ni bhalongobhangu ndo bha niani?” ");
INSERT INTO kiz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nu muene akanyosya kibhokho kya muene kwa bhanafunzi ni kujobha, “Langai abha ndo mabhu ni bhalongobhangu! ");
INSERT INTO kiz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwa kuj'ha j'hej'hioha j'hola j'haibhomba mapenzi gha Tata ghwangu j'haaj'hele kumbinguni, munu oj'hu ndo ndongobhangu, n'dombo bhangu ni mabhu ghwa nene”. ");
INSERT INTO kiz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ligono e'lu Yesu abhokili pa nyumba ni kutama kando j'ha bahari. ");
INSERT INTO kiz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bhumati m'baha bhwakusanyiki ni kun'syonghoka, aj'hingili mugati mu bhuatu ni kutama. Bhumati bhuoha bhwa j'hemili kando j'ha bahari. ");
INSERT INTO kiz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kisha Yesu akajobha malobhi ghamehele kwa mifuano, Akajobha, “Langai, mpanzi alothili kubhiala. ");
INSERT INTO kiz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bho ibhiala baadhi j'ha mbeyu syabinili kando j'ha nj'hela ni fidege fikahida fikadonola. ");
INSERT INTO kiz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu seng'he syabinili panani pa muamba, ambapo syakabhili lepi bhud'hopi bhwa kutosha. Ghafla sikakhipula kwa ndabha bhud'hopi bhwaj'helepi ni kina. ");
INSERT INTO kiz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lakini lij'hobha bho liyakili syanyanyibhu kwandabha syaj'helepi ni mizizi, na syaj'homili. ");
INSERT INTO kiz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu s'enge syabinili mu bhud'hopi bhunofu, mbeyu senge syabinili mu mab'ehe gha mifwa. Mab'ehe ghenye mifwa j'halotili kunani ghikaip'eta. ");
INSERT INTO kiz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbeyu s'enge syabinili mu bhud'hopi bhunofu ni kuhogola mbeyu, s'enge mara mia moja zaidi, s'enge sitini ni s'enge thelathini ");
INSERT INTO kiz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","J'haaj'hele ni mb'holokhoto na ap'elekai. ");
INSERT INTO kiz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bhanafunzi bhakahida ni kun'jobhela Yesu, “Kwa ndabha j'ha kiki ghwilongela ni makutano kwa mifano?” ");
INSERT INTO kiz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akajibu akabhajobhela, “Mup'helibhu bhupendeleo bhwa mbinguni, bali bhene bhapelibhulepi. ");
INSERT INTO kiz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lakini j'hej'hioha j'haaj'henaku, kwa muene ibetakuj'hongesibhwa nesu, na ibetakukabha faida ibhaha nesu. Ila j'haabelikuj'ha naku hata khela kidebe kyaaj'henaku ipokibhwa. . ");
INSERT INTO kiz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hivyo nilongela nabhu kwa mifano kwa ndabha ingabhwa bhilola, bhasibhoni kweli. Na ingabhwa bhip'heleka, bhasip'heleki bhwala kumanya. ");
INSERT INTO kiz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bhunabii bhwa Isaya bhutimili kwa bhene, bhola bhwabhwijobha, “Pamwip'heleka mup'helekayi, lakini kwa namna j'hej'hioha mwibetalepi kuj'helebhwa; bhwakati pamwilola mubhwesiayi kulola, lakini kwa namna j'hej'hioha j'hela musimanyi. ");
INSERT INTO kiz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na mioyo ghya bhanu abha j'himalikuj'ha ngisi, ni figumu kup'heleka na bhafumbili mihu gha bhene, ili bhasibhwesi kulola kwa mihu gha bhene, au kup'heleka kwa mb'olokhoto sya bhene, au kumanya kwa mioyo ghya bhene, hivyo ngabhanisanikili kabhele na nganibhaponyisi.' ");
INSERT INTO kiz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bali mihu gha j'homu ghabarikibhu, kwa ndabha ghilola, ni mbolokhoto sya j'homu kwa kuj'ha sip'heleka. ");
INSERT INTO kiz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hakika nikabhajobhela manabii bhingi ni bhanu bhabhajhele ni haki bhaj'hele ni hamu j'ha kughabhona mambo ghala gha mkaghabhona, na bhabhwesilepi kughabhona. Bhanyonyweghe kup'heleka mambo agha gha mwip'heleka, bhashindilu kughap'heleka. ");
INSERT INTO kiz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Henu mp'helekhesiayi mfuano ghwa mpanzi. ");
INSERT INTO kiz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bhwakati j'hej'hioha pa ip'heleka lilobhi lya mfalme na asilimanyi, ndipo mwovu ihida ni kukitola kyakimalikuj'ha kimali kubhyalibhwa mugati mu n'teema ghwakhe. Ej'he ndo mbeyu j'hela j'haj'habhyalibhu kando j'ha nj'hela. ");
INSERT INTO kiz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Muene j'ha abhyalibhu mu miamba ndo j'hola j'haip'heleka lilobhi ni kulijamb'elela nyata kwa kuhobhoka. ");
INSERT INTO kiz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bado aj'helepi ni mizizi mugati mwake, ila isindamala kwa muda bhudebe. Bhwakati matatisu au malombosi paghihida kwandabha j'ha lilobhi ikwikungufula ghafla. ");
INSERT INTO kiz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jhaabhyalibhu kati j'ha mabehe ghya mifwa oj'ho ndo j'hola j'haap'heliki lilobhi lakini malombosi gha bhulimwengu ni bhusiobhi bhwa bhutajiri bhukalisiobha lela lilobhi lisihidi likahogola matunda. ");
INSERT INTO kiz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","J'haabhyalibhu mu bhud'opi bhunofu, oj'ho ndo j'hola j'haip'heleka lilobhi ni kulimanya. Oj'ho ndo j'hola j'haihogola matunda ni kuj'hendelela kuhogola limonga zaidi j'ha mara mia, s'enge sitini, s'enge thelathini.” ");
INSERT INTO kiz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu akabhap'ela mfuano bhongi. Akajobha, “Bhufalme bha kumbinguni bhwifananisibhwa ni munu j'ha abhiele mbeyu sinofu mu n'gonda ghwake. ");
INSERT INTO kiz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lakini bhanu bho bhisinjila, adui akahida akabhiala mag'ug'u pagati pa ngano kisha akabhoka. ");
INSERT INTO kiz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baadaye ngano bho j'himelili ni kuhomesya mazao ghake, ndipo mag'ug'u ghakaj'ha ghihomisi na ghene. ");
INSERT INTO kiz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ni bhatumishi bha n'kolo nyumba bhakahida bhakan'jobhela, 'Bwana, ghwabhiele lepi mbeyu j'hinofu mu n'gonda? J'hij'hebhuli henu lij'hele ni maghogho? ");
INSERT INTO kiz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akabhajobhela, Adui abhombili e'le.' Bhatumishi bhakan'jobhela, “Kwa hiyo ghwilonda tulotaj'hi tukaghabhosi?” ");
INSERT INTO kiz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","N'kolo n'gonda akajobha, 'Lepi, bhwakati mwidupula maghogho mwibeta kudupula pamonga ni ngano. ");
INSERT INTO kiz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mughalekai ghakholayi pamonga hadi bhwakati bhwa mavuno. Bhwakati bhwa mavuno nibetakujobha kwa bhavunaji, 'Kwanza mughadupulayi maghogho na mughakonga matita matita ni kughanyanya, lakini mukhonganiayi ngano mu lighala lyangu.”” ");
INSERT INTO kiz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kisha Yesu akabhahomesela mfuano bhongi. Akajobha, “Bhufalme bhwa mbinguni bhwifanana ni mbeyu j'ha haradali ambaj'ho munu aitolili ni kuj'hibhiala mu n'gonda ghuake. ");
INSERT INTO kiz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu ej'he kwa hakika ndo j'hidebe kuliko mbeyu s'enge sioha. Lakini paj'himela j'hiha m'baha kuliko mimea ghenge ghioha ghwa bustani, ghwij'ha lib'ehe, kiasi kwamba fidege fya kunani fihida ni kujenga fiseiswi mu matafi ghake.” ");
INSERT INTO kiz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Akabhajobhela mfuano bhongi kabhele.”Bufalme bhwa mbinguni ni kama chachu j'hela j'haj'hitabhwalibhu ni n'dala ni kuj'hichanganya kwa fipemo fidatu kwa sembe mpaka fiumukai. ");
INSERT INTO kiz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Agha ghoha Yesu aghajobhili mu bhumati kwa mifuanu. Na bila mifuano ajobhilepi khenu kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E'j'he j'haj'hele kuj'ha khela kyakimali kujobhibhwa kup'hetela kwa nabii kibhwesiaghe kutimila, pala paajobhili, “Nibetakufumbula kinywa kyangu mu mifuano. Nibetakujobha mambo ghala ghaghaj'hele gha figheme kuhomela misingi ghya bhulimwengu”. ");
INSERT INTO kiz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kisha Yesu abhaleka makutano ni kulota kunyumba. Bhanafunzi bha muene bhakan'kesya ni kujobha, “Tufafanulilayi mfano ghwa maghogho gha mun'gonda. ");
INSERT INTO kiz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ajibili ni kujobha, “J'haibhiala mbeyu j'hinofu ndo Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","N'gonda ndo bhulimwengu; ni mbeyu j'hinofu ndo abha bhana bhufalme. Maghogho ndo bhana bha j'hola mwovu, na adui j'haasibhiele ndo ibilisi. ");
INSERT INTO kiz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na mavuno ndo mwisu ghwa bhulimwengu, na bhavunaji ndo malaika. ");
INSERT INTO kiz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kama vile maghogho kyaghibhonganibhwa ni kunyanyibhwa muoto, efyo ndivyo kyaj'hibeta kuj'ha mwisu ghwa bhulimwengu. ");
INSERT INTO kiz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana ghwa Adamu ibetakubhalaghisya malaika bha muene, ni kubhonganiya kuhoma mu bhufalme bhuakhe mambo ghoha ghaghasababisibhu dhambi ni bhala bha bhibhomba maasi. ");
INSERT INTO kiz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bhibetakubhatagha bhoha mu litanuru lya muoto, ambako kubeta kuj'ha ni kilelu ni kusiagha minu. ");
INSERT INTO kiz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ndipo bhanu bhenye haki babhibetakung'ara kama lijobha mu Bhufalme bhwa Tata j'habhu. Muene j'ha aj'hele ni mbolokhoto na ap'helekai. ");
INSERT INTO kiz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Bhufalme bhwa mbinguni ni kama hazina j'haj'hifighibhu mu n'gonda. Munu kama ajhibuene ni kuj'hifigha. Mu furaha j'hiakhe akalota kuhemelesya fyoha fya aj'he nafu, ni kuhemela n'gonda. ");
INSERT INTO kiz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kabhele, bhufalme bhwa mbinguni ni kama munu j'ha thamani. ");
INSERT INTO kiz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bhwakati bho aj'hibhuene j'hela j'haj'hij'hele ni thamani, akalota akahemelesya kila khenu kyaaj'henaku na akaj'hihemela. ");
INSERT INTO kiz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bhufalme bhwa mbinguni ni kama nkwabhu bhwabhujele mmasi, na kwamba ghwibhonganisya fiumbe fya kila aina. ");
INSERT INTO kiz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bhobhamemili bhavuvi bhaufutili pa lubhafu. Kisha bhakatama pasi bhakabhonganiya fenu finofu mugati mu k'henu, lakini fya fibelikuj'ha ni thamani fyataghibhu kutali. ");
INSERT INTO kiz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","J'hibeta kuj'ha namna ej'he mu mwisu ghwa dunia. Malaika bhibetakuhida ni kubhatenga bhanu bhaovu kuh'oma miongoni mwa bhenye haki. ");
INSERT INTO kiz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ni kubhatagha mugati mu litanuru lya muoto, ambako kubetakuj'ha ni maombolezo ni kusiagha minu. ");
INSERT INTO kiz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mughamanyili mambo ghoha agha? Bhanafunzi bhan'jibili, ");
INSERT INTO kiz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Ena.”Kisha Yesu akabhajobhela, “Khila mwandishi ambaj'he aj'hele mwanafunzi ghwa bhufalme ibhwaningana ni n'kolo nyumba j'haihomesya fenu mu hazina j'ha muene fipya ni filala.” ");
INSERT INTO kiz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikaj'ha Yesu bho amalili mifano ghioha eghu, akabhoka pa sehemu ej'hu. ");
INSERT INTO kiz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kisha Yesu akafika mu mkoa ghwa muene na akabhafundisya bhanu mu masinagogi. Matokeo ghake ni kuj'ha bhasyangele ni kujobha, “Ndaku munu oj'ho pa akabhili hekima ej'he ni miujiza eghe? ");
INSERT INTO kiz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Munu oj'ho si mwana ghwa seremala? Mariamu nyinamunu lepi? ni bhalongomunu Yakobo, Yusufu, Simoni ni Yuda? ");
INSERT INTO kiz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ni bhalomb'omuni tuj'henabhu apa patete? Basi munu oj'ho aghakabhili ndaku ghoha agha?”. ");
INSERT INTO kiz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Akabhadadisya. Lakini Yesu akabhajobhela, “Nabii ikosalepi kuj'ha ni heshima isipokuj'ha kwa bhene ni nchi j'ha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na abhwesilepi kubhomba miujiza mingi kwa ndabha bhaj'helepi ni imani naku. ");
INSERT INTO kiz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kwa bhwakati obhu, Herode ap'heliki habari juu j'ha Yesu. ");
INSERT INTO kiz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akabhajobhela bhatumishi bha muene, “Oj'ho ndo Yohana Mbatizaji afufuiki kuhoma kwa bhafu. Kwa hiyo ngofu ise sijhele juu j'hiakhe.” ");
INSERT INTO kiz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwa kuj'ha Herode aj'hele akamuili Yohana akankonga ni kun'tagha gerezani kwa ndabha ya Herodia, n'dala ghwa Filipo kaka j'hiake. ");
INSERT INTO kiz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwa kuj'ha Yohana an'jobhili, “Si halali kun'tola muene kuj'ha n'dala munu.” ");
INSERT INTO kiz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herode ngaan'komili lakini abhatilili bhanu kwa ndabha bhambwene Yohana kuj'ha nabii. ");
INSERT INTO kiz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lakini ligono lya kuhogoleka Herode bho afikili mwali Herodia amoghili pagati pa bhanu ni kumfurahisya Herode. ");
INSERT INTO kiz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Katika kujibu kili ahidili kwa kulapa kuj'ha ibetakumpela kyokyoha kyaibetakus'oma. ");
INSERT INTO kiz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Baada j'ha kushauribhwa ni nyinamunu, akajobha, “Nipelayi neno apa mutu bhwa Yohana Mbatizaji.” ");
INSERT INTO kiz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mfalme aj'hele ni sikitiko kwa maombi gha binti, lakini kwa ndabha j'ha bhoha bha bhaj'hele chakulani pamonga nu muene aamuiri kuj'ha j'hilondeka j'hibhombekaghe. ");
INSERT INTO kiz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Alaghisye Yohana aletibhwaghe kuhomela gerezani ");
INSERT INTO kiz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ili adumulibhwaghe mutu na kyaletibhu nu lisinia nu kupelibhwa binti na akakipeleka kwa nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kisha bhanafunzi bha muene bhakahida kuutola m'bele ni kubhusiela, baada j'ha e'le bhakalota kun'jobhela Yesu. ");
INSERT INTO kiz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ni muene Yesu bho ap'heliki agha, akakitenga kuhoma mahali pala akapakama mu mashua akalota sehemu j'haj'hitengibhu. Bhwakati bhumati bhumanyili kwaalotili, bhankesili kwa mag'olo kuhoma mijini. ");
INSERT INTO kiz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kisha Yesu akahida mbele j'ha bhene akabhubhona bhumati m'baha. Akabhabhonera k'hesa ni kubhaponya bhubhina bhwabho ");
INSERT INTO kiz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kimihi bho kifikiri, bhanafunzi bhakahida kwa muene nikujobha, “E'j'he sehemu j'ha jangwa ni ligono tayari limalili kulota. Bhatabhwanyisiayi makutano ili bhalota kufijijini bhakahemelayi fyakulya kwandabha j'ha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lakini Yesu akabhajobhela, “Bhaj'helepi ni haja j'ha kul'ota. Mubhap'elayi muenga kyakulya” ");
INSERT INTO kiz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bhakan'jobhela, “Lepi tuj'henaj'hu mikate mihanu ni somba sibhele tu.” ");
INSERT INTO kiz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu akajobha, Mughiletayi kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kisha Yesu akamuru bhumati kutama pasi pa manyasi. Akalota mikate mihano ni somba sibhele. Akalanga kunani kumbinguni, akabariki ni kumetula mikate akabhapela bhanafunzi. Bhanafunzi bhakaupela umati. ");
INSERT INTO kiz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhakalya bhoha na bhakatupilwa. Kisha bhakafibhonganiya fipaku kumi na fibhele. ");
INSERT INTO kiz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bhala bhabhalili bhakadiribhhu kuj'ha bhagosi elfu tano bila j'ha kubhalangibhwa bhadala ni bhana. ");
INSERT INTO kiz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mara moja akabhaamuru bhanafunzi bhaj'hingilayi mugati mu mashua, bhwakati bhobhuobhu muene akabhalagha bhumati bhalota nabhu. ");
INSERT INTO kiz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baada j'ha kubhulagha bhumati ni kwilotela, akakuela panani pa kid'honda kus'oma muene. Bwakati ij'hele kimihi aj'hele okhu muene. ");
INSERT INTO kiz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lakini henu mashua ij'hele katikati j'ha bahari jhidengadenga kwandabha j'ha manyegha, kwani mp'ongo bhwaj'hele bhwa mpisho ");
INSERT INTO kiz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bhwakati pakilu kya zamu j'ha nne Yesu abhakaribiri, akaj'haigenda panani pa masi. ");
INSERT INTO kiz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bhwakati bhanafunzi bha muene bha mbwene igenda panani pa masi gha bahari, bhakahofu ni kujobha, “E'le lij'hogij'hogi” ni kukwesya sauti katika hali j'ha bhuogha. ");
INSERT INTO kiz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu akabhajobhela mara moja, akajobha, “Mwikipelayi muoyo! ndo nene! musitili.” ");
INSERT INTO kiz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petro akan'jibu kwa kujobha, “Bwana, kama ndo bhebhe, niamuruayi nihidai panani pa masi kwa bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akajobha, “Hidayi.” Hivyo Petro akapita mugati mu mashua ni kugenda panani pa masi kul'ota kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini Petro bho abhuene manyegha, akatila, ni kubhwanja kujhibhila, pasi, akakuta sauti ni kujobha, “Bwana, niokolayi!” ");
INSERT INTO kiz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu manyata akanyosya kibhoko kya muene akanjinula Petro ni kuj'obhela, “Bhebhe mwenye imani j'hidebe, kwa ndabha j'ha kiki likaj'hele ni bhuogha?” ");
INSERT INTO kiz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndipo Yesu ni Petro bho bhaj'hingili mu mashua, mp'ongo ukagudama kubhuma. ");
INSERT INTO kiz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bhanafunzi mashuani bhakamwabudu Yesu ni kujobha, “Kuweli bhebhe ndo Mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na bho bhamalili kulobhoka, bhakafika mu nchi j'ha Genesareti. ");
INSERT INTO kiz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ni bhanu pa lieneo lela bhobhammanyili Yesu, bhalaghisye bhujumbe kila sehemu sya kando, ni kundeta khila j'haaj'hele n'tamu. ");
INSERT INTO kiz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhakan'sihi kuj'ha bhabhwesiaghe kukamula pindo lya livazi lya muene, na bhingi bhabhakamuili bhaponyisibhu. ");
INSERT INTO kiz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ndipo Mafarisayo ni bhaandishi bhakahida kwa Yesu kuh'omela Yerusalemu. Ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“kwandabha j'ha kiki bhanafunzi bhikaghaharifu mapokelelu gha bhaseya? Kwa kuj'ha bhisamba lepi mabhokho gha bhene pa bhilya kyakulya.” ");
INSERT INTO kiz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akabhajibu ni kubhajobhela, “Namu__kwa ndabha j'hakiki mukajhiharifu sheria j'ha Bwana kwa ndabha j'ha mapokelelu ghinu? ");
INSERT INTO kiz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwa kuj'ha K'yara ajobhili, 'Uniheshimuaghe dadij'hu ni ndebhuaku; na 'J'haijobha bhuovu kwa dadij'he ni ndebhuakhe, hakika ifwa.' ");
INSERT INTO kiz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini muenga mwijobha, 'Khila j'haikombola dadij'he ni nyina, “'Kila msaada ambabho j'ha alondeghe kukabha kwa nene henu j'hibetakujha kuh'oma kwa K'yara,”' ");
INSERT INTO kiz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Munu oj'ho aj'helepi ni haja j'ha kun'heshimu dadij'he. Mu namna ej'he mulitenguili lilobhi lya K'yara kwa ndabha j'ha mapokelelu ghinu. ");
INSERT INTO kiz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enyi bhanafiki, ni vyema kama Isaya kyaatabiri juu j'ha muenga bho ajobhili, ");
INSERT INTO kiz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Bhanu abha bhakaniheshimu nene kwa milomo ghiabhu, lakini mioyo ghiabhu ghij'hele patali nani. ");
INSERT INTO kiz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bhaakaniabudu bure, kwa ndabha bhifundisya mafundisu ghaghaj'hele malaghisu gha bhanadamu.”' ");
INSERT INTO kiz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ndipo akabhakuta makutano ni kubhajobhela, “Mup'elekisiaghe ni kumanya__ ");
INSERT INTO kiz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kij'helepi khenu kyakij'hingila mundomo mwa munu ni kumbomba najisi. Bali khela kyakih'oma mundomo, akebhai ndo najisi kwa munu.” ");
INSERT INTO kiz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ndipo bhanafunzi bhakandotela ni kujobha ni Yesu, “Je!, Umanyili Mafarisayo bho bhalipheliki lilobhi lela bha dadili?” ");
INSERT INTO kiz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu akabhajibu ni kujobha, “Khila mmea ambabho dadij'hangu ghwa mbinguni abhubhiele lepi bhwibeta kubhosibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bhalekayi bhene, bhene bhalongosi fipofu. Kama munu kipofu akandongosya kipofu nyinu, bhoha bhabhele bhibetakudumbukila mu lilende.” ");
INSERT INTO kiz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro akajibu ni kun'jobhela Yesu,” Tuj'helesiaghe mfano obho kwa tete, ");
INSERT INTO kiz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu akajibu, “Namu pia bado mwij'helebhwa lepi? ");
INSERT INTO kiz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Muenga mumanyi lepi khila kyakhilota mundomo kup'etela mulileme ni kulota kuchoro? ");
INSERT INTO kiz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini fenu fyoha fyafihomela mundomo fihomela mugati mumuoyo. Ndivyo fenu fyafikampela munu bhunajisi. ");
INSERT INTO kiz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwa kuj'ha mu muoyo ghihoma mabhwasu mabhibhi, bhukomaji, bhuzinzi, bhuasherati, bhuheji, bhushuhuda bhwa bhudesi, ni malighu. ");
INSERT INTO kiz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Agha ndo mambo gha ghakamp'ela munu bhunajisi. Lakini kulya bila kusamba mabhokho kukambomba lepi munu kuj'ha najisi.” ");
INSERT INTO kiz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ndipo Yesu ibhoka mahala pala ni kwitenga kulotela pande sya miji ghya Tiro ni Sidoni. ");
INSERT INTO kiz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Langai akahida n'dala Mkanani kuhomela lubhafu o'lu. Akakwesya sauti akajobha, “Unihurumilayi, Bwana, Mwana ghwa Daudi; binti j'hangu itesibhwa sana ni pepo.” ");
INSERT INTO kiz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu an'jibilepi lilobhi. Bhanafunzi bha muene bhakahida bhakan'sihi, bhakaj'ha bhijobha, “M'mbosiaghe alotaghe o'khu, mana akatuj'hweghela tu apa.” ");
INSERT INTO kiz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akabhajibu ni kujobha, Nalaghisibhulepi kwa munu j'hej'hioha isipokuj'ha kwa kondoo bhabhaj'hangili mu nyumba j'ha Israeli.” ");
INSERT INTO kiz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lakini akahida ni kuj'hinama mbele j'ha muene, akajobha, “Bwana nisaidilayi.” ");
INSERT INTO kiz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akan'jibu ni kujobha, “Khinofu lepi kulota kyakulya kwa bhana ni kus'opela mabwa,” ");
INSERT INTO kiz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akajobha, “Ena, Bwana, hata mabwa madebe ghilya kyakulya kyakibina pameza mwa Bwana ghwabhi.” ");
INSERT INTO kiz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ndipo Yesu akajibu ni kujobha “N'dala, imani j'ha bhebhe m'baha. Na j'hibhombekaghe kwa bhebhe kama kyaghwilonda.” Ni binti ghwa muene amalikupontisibhwa bhwakati bhobhuobhu. ");
INSERT INTO kiz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu akabhoka mahala pala ni kulota karibu ni bahari j'ha Galilaya. Kisha akalota panani pa kid'onda ni kutama okhu. ");
INSERT INTO kiz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Likundi libhaha kwa muene. Ni kundetela fiwete, fipofu, bubu, filema ni bhangi bhingi, bhabhaj'hele bhatamu. Bhabhakhili mu magholo gha Yesu na akabhaponya. ");
INSERT INTO kiz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nao bhumati bhukasyangala bho bhabhabhuene mabubu bhilongela, ni vilema bhakaj'ha bhasima, fiwete bhigenda, ni fipofu bhilola. Bhan'sifuili K'yara ghwa Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu akabhakuta bhanafunzi bha muene ni kujobha, “'Nibhabhonili huruma bhumati, kwandabha bhaj'hele nani kwa magono madatu bila kilya khenu kyokioha khela. Nikabhalagha lepi bhalotayi kwa bhene bila kulya bhasije bhakazimila mu nj'hela.” ");
INSERT INTO kiz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bhanafunzi bha muene bhakan'jobhela, “Ndaku twibhwesya kukabha mikate ghya kutosya apa pa nyika ghya kushibisha umati m'baha obho?” ");
INSERT INTO kiz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu akabhajobhela, “Muj'he ni mikate mil'enga?” Bhakajobha, “Saba, ni somba sidusu sudebe.” ");
INSERT INTO kiz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu akabhaamuru bhumati bhutamaghe pasi. ");
INSERT INTO kiz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akaghileta mikate j'hela saba ni somba, ni baada j'ha kushukuru, akaj'himetula ni kubhapela bhanafunzi. ");
INSERT INTO kiz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhanafunzi bhakabhap'hela bhumati. Bhanu bhoha bhakalya ni kutosheka. Na bhakabhonganya mabaki gha vipandi fya fyakulya fyafibakili fipandifipandi, fyamemili fikapu saba. ");
INSERT INTO kiz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bhoha bhabhalili bhaj'hele bhagosi elfu nne bila bhadala ni bhana. ");
INSERT INTO kiz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kisha Yesu akabhulagha bhumati bhakilotilayi na akaj'hingila mu mashua ni kulota sehemu sya Magadani. ");
INSERT INTO kiz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisayo ni Masadukayo bhakahida ni kunjera Yesu abhalasiaghe ishara j'haj'hihomela kunani. ");
INSERT INTO kiz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu akabhajibu ni kubhajobhela kuj'ha “Ikaj'hiaghe kimihi mwijobha kuj'ha hali j'ha hewa j'hinofu, kwa kuj'ha anga lidung'u. ");
INSERT INTO kiz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ni lukhela mwijobha 'Hali j'ha hewa lelu j'hinofu lepi kwa kuj'ha anga lidung'u ni mabhengu ghaj'hifuniki anga lioha.' Mmanyiri kufasiri mwonekanu ghwa anga, lakini j'hij'helepi kufasiri ishara sya bhwakati. ");
INSERT INTO kiz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kizazi kiovu ni kya bhuzinzi kilonda ishara, lakini j'hij'helepi ishara j'hej'hioha j'haj'hibetakupelibhwa, isipokughwa j'hala Yona. Kisha Yesu akabhaleka ni kubhoka. ");
INSERT INTO kiz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bhanafunzi bhakahida lubhafu lwa bhubhele, lakini bhaj'hele bhaj'habhilu kutola mikate. ");
INSERT INTO kiz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu akabhajobhela “Mwikitahadharishiayi na muj'helayi makini ni chachu j'ha Mafarisayo ni Masadukayo.” ");
INSERT INTO kiz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bhanafunzi bhakahojiana miongoni mwa bhene ni kujobha. “Kwa ndabha tukalotili lepi mikate.” ");
INSERT INTO kiz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu akalitambula e'lu ni kujobha, “Enyi j'ha muj'hele ni imani j'hidusu, kwa ndabha j'ha kiki mwibhuasya ni kujobhesana miongoni mwa j'humu ni kujobha kuj'ha kwa ndabha mkatolili ni kujobha kuj'ha kwa ndabha mkatolili lepi mikate? ");
INSERT INTO kiz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Je bado mmanyili lepi bhwala mwikhomboka lepi j'hela mikate mihanu kwa bhanu elfu tano, ni fikapu filenga fyamwabhongene? ");
INSERT INTO kiz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Au mikate saba kwa bhanu elfu nne, na fikapu lilenga mwafitolili? ");
INSERT INTO kiz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","J'hij'hebhuli hata mwej'helebhwa lepi kuja nizungumzileghe lepi kuhusiana ni mikate? Mukitunzaj'hi na mkitahadhariaj'hi ni chachu j'ha Mafarisayo ni Masadukayo.” ");
INSERT INTO kiz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kisha bhakamanya kuj'ha abhajobhilaghe lepi juu j'ha kujihadhari ni mikate j'haij'hele ni chachu, bali kujihadhari ni mafundisyo gha Mafarisayo ni Masadukayo. ");
INSERT INTO kiz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bhwakati Yesu afikiri sehemu sya Kaisaria j'ha Filipi, akabhakhota bhanafunzi bha muene, akajobha, “Bhanu bhijobha kuj'ha Mwana ghwa Munu niani?” ");
INSERT INTO kiz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhaakajobha,” Bhangi bhijobha kuj'ha ni Yohana Mbatizaji; bhangi, Eliya; na bhangi Yeremia, au mmonga kati j'ha manabii. ");
INSERT INTO kiz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Akabhajobhela, muenga mwijobha nene na niani? ");
INSERT INTO kiz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Akajibu Simoni Petro akajobha, “Bhebhe ndo Kristu Mwana ghwa K'yara j'ha aj'he hai” ");
INSERT INTO kiz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akan'jibu ni kun'jobhela, “Ubarikibhu bhebhe, Simoni Bar Yona, kwa kuj'ha muasi ni nyama fikakufunulili lepi e'le, bali Dadi j'hangu j'ha aj'he kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nani pia nikabhajobhela kuj'ha bhebhe Petro, na panani pa muamba obhu nibetakulijenga likanisa lya nene. Miliangu ghya kuzimi ghib'hetalepi kulilenda. ");
INSERT INTO kiz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nibetakupela bhebhe fungulu sya bhufalme bhwa mbinguni. Kyokyoha kyaghwibetakukifunga pa duniani kibetakuj'ha kifungibhu kumbinguni, na kyokyoha kyakibetakufungulibhwa pa duniani basi kibeta kifungulibhu kumbinguni.” ");
INSERT INTO kiz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kisha Yesu akabhaamuru bhanafunzi bhasin'jobhela munu j'hej'hioha kuj'ha muene aj'hele Kristu. ");
INSERT INTO kiz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuhomela bhwakati obhu Yesu akayanda kubhajobhela bhanafunzi kuj'ha ni lazima alotayi Yerusalemu, kutesibhwa kwa mambo mingi mu mabhoko gha bhaseya ni bhakholo bha makuhani ni bhaandishi, kukhomibhwa ni kufufuka ligono lya tatu. ");
INSERT INTO kiz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kisha Petro akan'tola Yesu palubhafu ni kum'besya kwa kujobha, “Jambo e'le na lij'helayi patali nabhi, Bwana, ej'he j'hikatakuh'omela kwa bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu akasanuka ni kun'jobhela Petro, “Kherukayi kunyuma j'ha nene syetani! Bhebhe ndo kizuizi kwa nene, kwa ndabha ghwijali lepi mambo gha K'yara, bali mambo gha bhanadamu.” ");
INSERT INTO kiz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kisha Yesu akabhajobhela bhanafunzi bha muene, “Kama munu j'hej'hioha j'hailonda kunikesya nene ni lazima akibelai muene, atolai nsalaba ghwa muene na anifatayi. ");
INSERT INTO kiz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwa kuj'ha j'hailonda kughaokola maisha gha muene akaghayasya na kwa yeyioha j'haibetakuyasya maisha gha muene kwa ndabha j'ha nene ibeta kughaokola. ");
INSERT INTO kiz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Je! Khenu gani kyaibetakubhosya munu katika kusanusiana ni maisha gha muene? ");
INSERT INTO kiz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwa kuj'ha Mwana ghwa Adamu ibetakuhida mu bhutukufu bhwa Dadi munu ni malaika ghwake. Nu muene ibetakundepa khila munu kul'engana ni matendo gha muene. ");
INSERT INTO kiz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kweli nikabhajobhela kuna baadhi j'ha muenga mwamuj'hemili apa ambabho bhibetalepi kubhonja mauti mpaka pabhibetakumbona Mwana ghwa Adamu kya ihida mu bhufalme bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Magono sita baadaye Yesu abhatolili pamonga nu muene Petro, ni Yakobo, ni Yohana ndongomunu, na akabhatola mpaka panani pa kid'onda kitali bhabhu bhene. ");
INSERT INTO kiz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Abadilisibhu mb'ele j'ha bhene. Pamihu pa muene pang'areghe kama lij'hobha, ni ngobho sya muene syabhonekene kung'ara kama nuru. ");
INSERT INTO kiz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Langai, pala bhakatokili Musa ni Eliya bhakaj'habhilongela nakhu. ");
INSERT INTO kiz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petro akajibu ni kun'jobhela Yesu, “Bwana, ni kinofu kwa tete kuj'ha mahali apa. Kama ghwinoghela, nibetakujenga fibanda fidatu - kimonga kya bhebhe, ni kimonga kwa ndabha j'ha Musa, ni kimonga kwa ndabha j'ha Eliya.” ");
INSERT INTO kiz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bhwakati ilongela, langai libhengu libhalafu likabhafunika na langai, na j'hikah'omela sauti mulibhengu, j'hijobha, “Oj'ho ndo Mwanabhangu n'ganwa j'han'hobhwiki naghu. Mump'elekisiaghe muene.” ");
INSERT INTO kiz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhanafunzi bho bhap'heliki aghu bhakabina kifudifudi na bhakatila sana. ");
INSERT INTO kiz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kisha Yesu akahida akabhakamula ni kujobha, “Muj'hinukayi musitili.” ");
INSERT INTO kiz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ni bhene bhakaj'hinula nyuso sya bhene kunani lakini bhambwene lepi munu isipokuj'ha Yesu muene. ");
INSERT INTO kiz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na bhobhiselela pa kid'onda, Yesu akalaghisya, akajobha, “Musih'omesi habari ya maono agha mpaka Mwana ghwa Adamu paibetakufufuka kuhoma kwa bhafu.” ");
INSERT INTO kiz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bhanafunzi bha muene bhakan'kota bhakajobha, “Kwa ndabha j'ha kiki bhaandishi bhijobha kuj'ha Eliya ibetakuhida hoti? ");
INSERT INTO kiz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akabhajibu nikujobha, “Eliya ibetakuhida kweli na ibetakukherebhusya mambo ghoha. ");
INSERT INTO kiz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini nikabhajobhela muenga, Eliya amali kuhida, lakini bhakammanyi lepi. Baada j'hiake, bhambombili mambo gha bhitonda bhene. Na efyo ndo Mwana ghwa Adamu kyaibetakutesibhwa mu mabhokho gha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndipo bhanafunzi bhakatambula kuj'ha alongeleghe habari sya Yohana Mbatizaji. ");
INSERT INTO kiz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bhobhafikiri mu bhumati bhwa bhanu munu mmonga akabhalotela, akapiga magoti mbele sya muene, ni kun'jobhela, ");
INSERT INTO kiz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bwana, un'hurumilayi mwanabhangu, maana aj'hele ni kifafa ni kuteseka sana. Kwa kuj'ha mara nyingi ibina mu muoto au mu masi. ");
INSERT INTO kiz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nandetili kwa bhanafunzi bha jhobi, lakini bhabhwesilepi kumponya. ");
INSERT INTO kiz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu akajibu akajobha, “Enyi kizazi kyaibetakukiera na kyakiharibiki nibetakutama ni muenga mpaka? Nibeta kuvumililana ni muenga mpaka ndali? Mundetayi apa kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu akam'b'enga, ni pepo likabhoka. Nsongolo aponyisibhu kuh'omela lisaa lela. ");
INSERT INTO kiz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kisha bhanafunzi bhakan'kesya Yesu kwa siri ni kun'kota, “Kwa ndabha j'ha kiki twabhwesilepi kumb'enga?” ");
INSERT INTO kiz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akabhajobhela, “Kwa ndabha j'ha imani j'hinu ndebe. Kweli nikabhajobhela, kama mwibetakuj'ha ni imani hata ndebe kama punje j'ha mbeyu ya haradali, mwibeta kubhwesya kuujobhela kid'onda ek'he, kihamaghe kuhomela pala kilotayi khola, ni bhuene bhwibeta kuhama na kubetakujha lepi ni khenu kyokyoha khela kya kushindikanika kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bhwakati bhajele bado Galilaya, Yesu akabhajobhela Bhanafunzi bha muene, “Mwana ghwa Adamu ibetakubhakibhwa mu mabhoko gha bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na bhibetakun'koma, na ligono lya tatu ibetakufufuka.” Bhanafunzi bhahuzuniki sana. ");
INSERT INTO kiz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na bhene bho bhafikiri Kapenaumu, bhanu bhabhikhonganiya kodi j'ha nusu shekheli bhakandotela Petro ni kujobha, “Je mwalimu ghwa muenga e'lepa kodi j'ha nusu shekheli?” ");
INSERT INTO kiz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Akajobha, “Ena” Lakini Petro bho aj'hingili mugati mu nyumba, Yesu akalongela ni Petro h'oti ni kujobha, “Ghwifikirira kiki Simoni? Bhafalme bha dunia, bhipokela kodi au bhshuru kuhomela kwa niani? Kwa bhala bhabhikabhatabhwala kuh'oma kwa bhahesya? ");
INSERT INTO kiz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na bhwakati Petro ajobhili, “Kuhoma kwa bhahesya” Yesu akabhajobhela, hivyo bhatawalibhwa bhabhosibhu mu bhul'epaji. ");
INSERT INTO kiz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini tusihidi kubhabhomba bhatoza ushuru bhakabhomba dhambi, lotaghe kubahari, sopayi ndobhani, na ulayi somba hosi. Baada ya kuufungula ndomo bhwake, ghibeta kuj'hikholela mo'la shekeli j'himonga. J'hitolayi na ubhapelayi bhatoza ushuru kwa ndabha j'ha nene ni bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Muda bhobhuobhu bhanafunzi bhakahida kwa Yesu ni kun'jobhela, “Niani mbaha mu bhufalme bhwa mbinguni?” ");
INSERT INTO kiz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu akankuta mwana n'debe akambheka pagati pa bhene, ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Kweli nikabhajobhela, kama mtubwi lepi ni kujha kama bhana bhadebe mwibetalepi kujhingila mu ufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hiyo j'hej'hioha j'haikiselesya kama mwana n'debe, munu ojhu ibetakujha mmbaha mu ufalme bhwa K'yara kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na yeyote j'ha ikanjamb'elela muana n'debe kwa lihina lya nene an'jamb'elili nene. ");
INSERT INTO kiz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lakini j'hej'hioha j'haibetakusababisya mmonga kati j'ha bhadebe abha bhabhakaniamini kuasi, ibetakuj'ha kinofu kwa munu oj'hu liganga likholo lya kusyaghila likakhongibhwa mu nsingu mwa muene, ni kusopibhwa kul'osi kunyanja. ");
INSERT INTO kiz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ole kwa dunia kwa ndabha j'ha bhwakati bhwa kudadisibhwa! kwa kuj'ha haina budi kwa nyakati esu kuhida, lakini ole ghwake kwa munu j'hola nyakati e'su sideta kuhida kwa ndabha j'ha muene! ");
INSERT INTO kiz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","kama kibhoko kya bhebhe au kigolo kikakusababishilayi kudada, uudumulayi ni kuutagha patali nabhi. Kinofu zaidi kwa bhebhe kujhingila mu bhuzima bila kibhoko au kilema, kuliko kutaghibhwa mu muoto bhwa milele akaj'helayi ni mabhoko ghoha ni magolo ghoha. ");
INSERT INTO kiz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kama lihu lya j'hobhi likakudadisiayi ulibhosiayi na ulitaghai kutali nabhi. Na kinofu zaidi kwa bhebhe uj'hingilayi hosi mu bhusima ni lihu limonga, kuliko kutaghibhwa mu muoto bhwa milele ukaj'helayi ni mihu ghoha. ");
INSERT INTO kiz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mulangayi kuj'ha musihidi mukan'jimula mmonga wa abha bhadebe. Kwa ndabha nikabhajobhela kuj'ha kumbinguni bhajhele malaika bha bhene magono ghoha bhakabhulanga bhuso bhwa Tata ghwangu j'haaj'hele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Zingatilayi: Malobhi ghaghibhonekana kama gha mstari ghwa 11, “Kwa kuj'ha Mwana ghwa Adamu ahidili kuokola khela kyakyaj'haghili” ghabhonekene lepi mu nakala bora sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mwifikirira kiki? Ikaj'hiaghe munu aj'he ni likondoo mia moja, na limonga likajhagha, je ibetakughaleka tisini na tisa kukid'onda ni kulota kulonda limonga lyalijhaghili? ");
INSERT INTO kiz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na akamalayi kulikabha, kweli nikabhajobhela akamfurahia kuliko bhala tisini na tisa bhabhabeli kujhagha. ");
INSERT INTO kiz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Fefuefu, sio mapenzi gha Tata ghwinu g'hwa mbinguni kuj'ha mmonga ghwa bhadebe abha ajhangamilayi. ");
INSERT INTO kiz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kama ndongobhu akakuselayi, lotayi, kandasiayi dosari j'haj'hiyele kati ya bhebhe ni muene akaj'helayi muene. Kama ibetakup'helekesya bhwibeta kiujha unkerebhwisi ndongobhu. ");
INSERT INTO kiz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lakini kama ibetakubela kup'elekesya ntolayi ndongobhu mmonga au bhabhele zaidi pamonga ni bhebhe kwa kuj'ha kwa vinywa fya mashahidi bhabhele au bhadatu kila lilobhi libhwesya kuthibitishibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na kama ibetakubhapuuzila kubhap'helekesya, lijobhelayi kanisa khenu ekhu, kama ibetakupuuzila kabhele kulip'helekesya kanisa, basi na aj'helayi kama munu bhwa mataifa ni mtoza ushuru. ");
INSERT INTO kiz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kweli nikabhajobhela, kyokyoha khela kyamwibeta kukidenda kuduniani ni kumbinguni kid'endibhu. na kyokyoha khela kya mwibeta kukidendulila ku duniani ni kumbinguni kid'endulibhu. ");
INSERT INTO kiz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kabhele nikabhajobhela kama bhanu bhabhele kati j'ha muenga bhakubaliene juu jha khenu kyokyoha khela pa duniani kyabhis'oma, e'lu Tata ghwa nene ghwa kumbinguni ibetakulibhomba. ");
INSERT INTO kiz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwa kuj'ha bhabhele au bhadatu bhakakusanyikayi pamonga kwa lihina lya nene, Nene njele pagati pa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kabhele Petro akahida ni kun'jobhela Yesu, “Bwana, ni mara silenga ndongo bhangu akanikosela ni nene nikan'samehe? Hata mara jha saba?” ");
INSERT INTO kiz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akan'jobhela, “Nikujobhela lepi mara saba, lakini hata sabini mara saba. ");
INSERT INTO kiz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa ndabha ejhu bhufalme bhwa mbinguni ni sawa ni mfalme mmonga jhaalondeghe kwisahihisha hesabu kuhoma kwa bhatumwa bha muene. ");
INSERT INTO kiz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bho abhwanji kusahihisha hesabu, mtumwa mmonga akaletibhwa kwa muene ambajhe an'dajheghe talanta elfu kumi. ");
INSERT INTO kiz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwa kujha ajhelepi ni njela jha kulepa, bwana ghwa muene akalaghisya aghosibhwayi, n'dala munu pamonga ni bhana munu ni khila khenu kyaajhe nakhu, ni mal'epu ghabhombekayi. ");
INSERT INTO kiz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hivyo mtumwa akabina, akapiga magoti m'bele jha muene, akajobha, 'Bwana, uj'helayi ni bhuvumilivu pamonga ni nene, na nibetakulepa khila khenu.' ");
INSERT INTO kiz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hivyo bwana ghwa j'hola n'tumwa, kwa kuj'ha asukumibhu sana ni huruma andekhesili ni kun'samehe lideni e'lu ");
INSERT INTO kiz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Lakini n'tumwa j'hola akabhoka ni kunkabha mmonga kati j'ha bhatumwa bhajhinu, jhaajhele akan'dai denari mia. Akamfuta, akankaba pa nkoromelu, ni kun'jobhela, 'Nil'epai khela kyanikudai.' ");
INSERT INTO kiz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lakini y'ola n'tumwa njinu akabina ni kun'sihi sana akajobha, 'Ujhelayi ni bhuvumilivu nani, na nibetakul'epa.' ");
INSERT INTO kiz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini n'tumwa j'hola ghwa kubhwandelu abelili. Badala j'hiake, akalota ni kun'tagha gerezani, mpaka pa ibeta kundepa khela kyaakan'dai. ");
INSERT INTO kiz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na bho bhabhuene bhatumwa bhajhinu khela kya kitokili. Bhasikitishibu sana. Bhakahida ni kun'jobhela bwana ghwa bhene kila khenu kya kyah'omili. ");
INSERT INTO kiz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ndipo y'ola bwana ghwa mtumwa j'hola akan'kuta, ni kun'jobhela, 'Ewe n'tumwa mwovu, nikakusamehe bhebhe lideni lyangu lyoha kwa ndabha ukan'somili muni. ");
INSERT INTO kiz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Je! Ulondekaghelepi kujha ni huruma kwa n'tumwa njinu, kama nene kyanikuhurumili bhebhe? ");
INSERT INTO kiz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bwana ghwa muene akadada ni kun'kabidhi kwa bhala bhatesaji mpaka pa ibetakulepa kiasi kyoha kyaadaibhweghe. ");
INSERT INTO kiz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Efyo ndo dadi j'hangu ghwa kumbinguni kyaibetakubhabhombela, kama kila mmonga ghwinu ibetalepi kun'samehe ndongo munu kuhomela ghwa muene.” ");
INSERT INTO kiz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","J'hatokili bho Yesu amalili kudongela malobhi aghu, akabhoka Galilaya, ni kulota mpakani mwa Yudea mbele j'ha kih'olo Jordani. ");
INSERT INTO kiz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bhumati mbaha bhukan'kesya ni kubhaponyesya okhu. ");
INSERT INTO kiz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafarisayo bhakan'hidila, bhakan'jaribu, bhakan'jobhela, “Je ni halali kwa munu kundeka n'dala munu kwa ndabha yeyioha?” ");
INSERT INTO kiz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akajibu nikujobha, “Mwas'omili lepi, kwamba muene j'haabhabhombili kubhwandelu abhabhombili n'gosi ni n'dala? ");
INSERT INTO kiz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na kabhele akajobha, 'Kwa ndabha ejhu n'gosi ibetakundeka dadimunu ni nyinamunu ni n'dalamunu, na bhene bhabhele bhibhetakujha m'bele bhumonga?' ");
INSERT INTO kiz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Efyo sio bhabhele kabhele, bali m'b'ele bhumonga. Basi, khela ambakyo akiunganisi K'yara, munu jhejhioha y'ola asikitenganisi.” ");
INSERT INTO kiz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bhakan'jobhela, “Henu kwa ndabha j'ha kiki Musa atuamuiri kuhomesya hati j'ha talaka ni kundeka?” ");
INSERT INTO kiz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Akabhajobhela, “Kwa bhugumu bhwa mioyo ghinu Musa abharuhusili kubhaleka bhadala bhinu, lakini kuhomela kubhwandelu jhajhelepi naha. ");
INSERT INTO kiz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nikabhajobhela, kujha jhejhioha j'hola j'haibetakundeka n'dala munu isipokuj'ha kwa ndabha j'ha uzinzi, na kun'gega yongi, amalikuzini. Na n'gosi j'haibetakun'gega n'dala j'haalekibhu amalikuzini.” ");
INSERT INTO kiz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bhanafunzi bhakan'jobhela Yesu, “Kama ndo ncha kwa n'gosi ni n'dala kinofu lepi kugega.” ");
INSERT INTO kiz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lakini Yesu akabhajobhela, “Sio khila munu ibhwesya kughapokela mafundisu agha, bali ni kwa bhala tu bhabharuhusibhu kupokela. Kwa kuj'ha bhajhele bhatowashi bhabhahogoliki kuhomela mu maleme gha bhanyinabhabhi. ");
INSERT INTO kiz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na kabhele bhajhele bhatowashi bhabhabhombibhu ni bhanu. Na bhajhele matowashi bhabhikifwanyisya matowashi kwandabha j'ha bhufalme bhwa kumbinguni. J'haibhwesya kupokela mafundisu agha na aghapokelayi.” ");
INSERT INTO kiz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kisha akaletibhwa baadhi j'ha bhana bhadebe ili abhabhekelayi mabhoko panani pa bhene ni kus'oma, lakini bhanafunzi bha muene bhakabhakemela. ");
INSERT INTO kiz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bali Yesu akajobha, “Bharuhusuaghe bhana bhadebe, bhwala musibhabesi kuhida kwa nene, kwa ndabha bhufalme bhwa mbinguni ni wa bhanu kama abhu. ");
INSERT INTO kiz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ni muene akabheka mabhoko panani pa bhene, kisha akabhoka pala. ");
INSERT INTO kiz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Langai munu mmonga akahida kwa Yesu ni kujobha, “Mwalimu, khenu gani kinofu kyanilondeka kubhomba ili nikabhai bhusima bhwa milele?” ");
INSERT INTO kiz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akabhajobhela, “Kwa ndabha j'ha kiki ukanikota khenu gani kinofu? Aj'he mmonga tu j'ha ajhe n'nofu, lakini kama ghwilonda kukabha bhusima bhwa milele, sikamulayi sheria sya K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Munu yola akan'kota, “Sheria syene seleku?” Yesu akajobha, “Usikomi, usibhushuhudili bhudesi, ");
INSERT INTO kiz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bhaheshimuaghe dadiwaku ni nyinuaku, na un'ganai jirani ghwa j'hobhi kama nafsi j'ha bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Munu yola akan'jobhela, “Mambo ghoha aghu nimalili kughatii. Bado nilonda kiki? ");
INSERT INTO kiz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“Yesu akan'jobhela. “Kama ghwilonda kuj'ha n'kamilifu, lotayi, ukagolisiayi fenu fyoha fya ujhe nafu, na ubhapelayi maskini, na ghwibetakuj'ha ni hazina kumbinguni. Kisha hidayi unikhesiayi.” ");
INSERT INTO kiz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lakini n'songolo y'ola bho apeliki ghala ghaan'jobhili akabhoka kwa huzuni, kwa ndabha aj'hele imiliki mali simehele. ");
INSERT INTO kiz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu akabhajobhela bhanafunzi bha muene, “Kweli nikabhajobhela, ni vigumu kwa munu tajiri kuj'hingila mu bhufalme bhwa mbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kabhele nikabhakobhela, ni rahisi kwa ngamia kup'heta mu lilende sya sindanu, kuliko kwa munu tajiri kuj'hingila mu bhufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bhanafunzi bhobhap'eliki aghu, bhakashangala sana ni kujobha, “Ndo j'holekhu basi jhaibeta kuokoka?” ");
INSERT INTO kiz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akabhalanga ni kujobha, “Kwa mwanadamu e'lu libhwesekana lepi, lakini kwa K'yara ghoha ghibhwesekana.” ");
INSERT INTO kiz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kisha Petro akan'jibu ni kun'jobhela, “Langai tulekayi fyoha ni kukukesya bhebhe. Khenu gani twibetakukabha?” ");
INSERT INTO kiz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akabhajobhela, “Kweli nikabhajobhela, muene j'haibeta kunikesya nene, munu bhuzao mpya bhwakati Mwana ghwa Adamu pa ibeta kutama mu kiti kya enzi kya bhutukufu bhwakhe, namu mwibetakutama panani pa kiti kya enzi kumi na mbili, kugha hukumu makabila kumi na mabhele gha Israeli. ");
INSERT INTO kiz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kila mmonga bhinu j'ha alekili nyumba, kaka, dada. tata, mabhu, bhana, au n'gonda kwa ndabha j'ha lihina lya nene, ibeta kupokela mara mia ni kubhurithi bhuzima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini bhingi bha bhajhele bhakubhwandelu henu, bhibetakujha bha mwishu, na bhabhaj'hele bha mwishu bhibheta kujha bha kubhwandelu. ");
INSERT INTO kiz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kwa ndabha bhufalme bhwa kumbinguni bhwifwanana ni mmiliki ghwa n'gonda, jha ajhumuiki lukhela na mapema ili kuajili bhabhombambombo mu n'gonda bhwa muene bhwa mizabibu. ");
INSERT INTO kiz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Baada j'ha kujha akubaliene ni bhabhomba mbombo dinari jhimonga kwa kutwa, akabhatuma kulola kun'gonda ghwa mizabibu. ");
INSERT INTO kiz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akalota kabhele baada j'ha masaa madatu ivi na akabhabhona bhabhombambombo bhangi bhajhele bhajhemili bila mbombo mu lieneo lya soko. ");
INSERT INTO kiz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akabhajobhela, 'Muenga pia, mlotayi kun'gonda lya mizabibu, na kyokioha kya kij'hele halali nibetakubhapela.' Hivyo bhakalota kubhomba mbombo. ");
INSERT INTO kiz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Akalota kabhele baada jha masaa sita ni kabhele katika saa jha tisa, na abhombili mebhu. ");
INSERT INTO kiz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mara j'henge kabhele mnamo saa kumi na moja, akalota ni kubhakolela bhangi bhajhemili bila mbombo. Akabhajobhela, 'kwa ndabha jhakiki mujhemili apa bila mbombo j'hoj'hioha j'hela kwa ligono lyoha? ");
INSERT INTO kiz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bhakan'jobhela, kwa ndabha ajhelepi munu jhejhioha j'hola j'haatuajiri. Akabhajobhela, 'Ni muenga mulotayi mu n'gonda ghwa mizabibu.' ");
INSERT INTO kiz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Bhwakati bhwa kimihi bho bhufikiri, n'kolo n'gonda ghwa mizabibu akan'jobhela msimamizi ghwa muene, 'Ubhakutayi bhabhombambombo na ubhalepayi mishahara, kwa kubhwanja ni bhwa mwishu hadi ghwa kubhwandelu.' ");
INSERT INTO kiz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bhobhahidili bhabhaajiribhu saa kumi na moja, kila mmonga ghwa bhene apelibhu dinari. ");
INSERT INTO kiz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bho bhahidili bhabhomba mbomo bha kubhwandelu bhafikirileghe kujha bhibeta kukabha zaidi, lakini bhapokili pia kila munu dinari jhimonga kwa kila munu. ");
INSERT INTO kiz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baada jha kupokela malipo gha bhene, bhandalamikili mmiliki ghwa n'gonda. ");
INSERT INTO kiz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bhakajobha, “Abha bhabhombambombo bha mwishu bhabhombili lisaa limonga tu kubhombambombo, lakini ubhalenganisi ni tete, tete tup'hendili misighu ligono lyoha ni kupya ni lifukhe.' ");
INSERT INTO kiz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lakini n'kolo n'gonda akajibu ni kujobha kwa mmonga ghwa bhene, 'Rafiki, nabhombili lepi khenu kibhibhi. Je! tukakubaliene lepi ni nene dinari j'himonga? ");
INSERT INTO kiz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pokelayi khela kya kijhele halali jha bhebhe naubho kayi. turahe ya nene kubhap'hela abha bhabhomba mbombo bhabhaajiribhu kumwishu sawasawa ni muenga. ");
INSERT INTO kiz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Je! hakilepi kwa nene kubhomba khela kyanilonda ni mali syangu? au lihu lya bhebhe liovu kwa ndabha nene ne mwema? ");
INSERT INTO kiz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Efyo ghwa mwishu ij'ha ghwa kubhwandelu nighwa kubhwandelu ijha ghwa mwishu” ");
INSERT INTO kiz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu bho ikwela kulota Yerusalemu, akabhatola bhanafynzibha muene kumi na bhabhale palubhafu, na mun'jhela akabhajibhela, ");
INSERT INTO kiz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Langai twilota Yerusalemu, ni Mwana ghwa Adamu ibetakujha mmabhoko gha bhakuu bha makuhani ni bhaandishi. ");
INSERT INTO kiz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na bhibetakun'hukumula kifo na bhibetakumbosya kwa bhanu bha mataifa ili kundhihaki, kun'tobha ni kunsulubisya. Lakini ligono lya tatu ibetakufufuka.” ");
INSERT INTO kiz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kisha mabhu ghwa bhana bha Zebedayo ahidili kwa Yesu ni bhana munu. Apigili magoti mbele jha muene ni kun'soma khenu kuhoma kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu akan'jobhela, “Ghwilonda kiki?” Akanijobhela, “Amuru kujha abha bhanabhangu bhabhele bhatamayi, mmonga kibhoko kya kulia ni mmonga kibhoko kya bhebhe kya kushoto mu bhufalme bhwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lakini Yesu akan'jibu ni kujobha, “Ukimanyili lepi khela kyaghwis'oma. Je! Ghwibhwesya kukinyuela kikombi ambakyo nibetakunywela?” bhakan'jobhela, “Twibhwesya.” ");
INSERT INTO kiz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Akabhajobhela, “Kikombi kya nene hakika mwibeta kukinywela. Lakini kutama kibhoko kya nene kya kulia ni kibhoko kya nene kya kushoto sio jukumu la nene kubhap'hela, lakini ni kwa bhala ambabho bhamalili kuandalibhwa ni dadiyangu.” ");
INSERT INTO kiz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhanafunzi bhangi kumi bho bhapeliki naha, bhakahuzunishwa sana ni bhala bhanu bhabhele. ");
INSERT INTO kiz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lakini Yesu akabhakuta bhene ni kubhajobhela, “Mmanyili kujha bhatawala bha mataifa bhakabhalisya, ni bhabhaha bha bhene bhibetakelesya mamlaka juu jha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini isijhi naha kwa muenga. Badala yake, yeyote atakayetaka kuwa mkubwa miongoni mwenu lazima awe mtumishi wenu. ");
INSERT INTO kiz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na jhaibeta kujha ghwa kubhuandu kati jha muenga lazima ajhiaghe n'tumishi ghwa muenga. ");
INSERT INTO kiz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kama vile Mwana ghwa Adamu ahidilepi kutumikibhwa, bali kutumika, ni kuhomesya bhuhai bhwake kujha bhukhombozi kwa bhingi.” ");
INSERT INTO kiz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bhwakati bhihomela Yeriko, bhumati m'baha bhwa n'kesisi. ");
INSERT INTO kiz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na bhabhabhuene fipofu mbabhele bhatamili kando j'ha barabara. Bho bhapeliki kuj'ha Yesu ipeta, bhakakuesya sauti ni kujobha, “Bwana, Mwana ghwa Daudi, utuhurumilayi.” ");
INSERT INTO kiz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lakini bhumati ukabhakhemela, ni kubhajobhela mgudamayi. Hata ivyo, bhene bhakazidi kukwesya sauti ni kujobha, “Bwana, Mwana ghwa Daudi, utuhurumilayi.” ");
INSERT INTO kiz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kisha Yesu akajhema na akabhakuta ni kubhakota, “Mwilonda nibhambombilayi kiki?” ");
INSERT INTO kiz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bhakan'jobhela, “Bwana kuj'ha mihu gha tete ghabhwesiaghe, kulola.” ");
INSERT INTO kiz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Basi Yesu, akajha avutibhu ni huruma, akaghagusa mihu gha bhene, mara ej'hu bhakapokela bhuwezo bhwa kulola na bhakan'kesya. ");
INSERT INTO kiz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ni bhanafunzi bha muene bhakalota karibu ni Yerusalemu na bhakalota mpaka Bethfage, mu kid'onda kya mizeituni, kisha Yesu akabhatuma bhanafunzi bhabhele, ");
INSERT INTO kiz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akabhajobhela, “Mulotayi mu kijiji kyakifwatila, na mara jhimonga mwibetakun'kolela punda akhongibhu pala, ni mwanaounda pamonga ni muene. mubhakhongai ni kubhaleta kwa nene. ");
INSERT INTO kiz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ikajhiaghe munu jhojhuoha akabhajobhela khenu kyokyoha kuhusu elu, mwibeta kujobha, `Bwana akabhalonda, ` na munu ojhu mara moja akabharuhusu mhidai pamonga nabhu” ");
INSERT INTO kiz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jambo e'le lyatokili na lela lyajobhibhu kup'elela kwa nabii lazima litimisibhwayi. Akabhajobhela, ");
INSERT INTO kiz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mubhabholayi binti Sayuni, langai, mfalme bhwaku ihida kwa muenga, mnyenyekevu na ihida akwelili punda, ni kubheka ngobho sya bhene ni mwana punda n'gosi, mwana punda n'debe. ");
INSERT INTO kiz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kisha bhanafunzi bhakabhoka ni kubhomba jinsi Yesu kya abhalaghisi. ");
INSERT INTO kiz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakandeta punda ni mwanapunda, ni kubheka ngobho sya bhene panani, nu muene Yesu akatama pala. ");
INSERT INTO kiz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bhingi mu mkusanyiku bhatandesye ngobho sya bhene munj'hela, ni bhangi bhadumuili matawi mu mabehe ni kutandasya mu barabara. ");
INSERT INTO kiz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bhumati bhwa bhudongolili Yesu ni bhala bhabhan'kesisi bhakwesi sauti, bhikajha bhijobha,”Hosana kwa mwana ghwa Daudi! Ni mbarikibhwa j'ha ihida kwa lihina lya Bwana. Hosana juu zaidi!” ");
INSERT INTO kiz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu bho afikiri Yerusalemu, mji bhuoha bhwanyimwiki ni kujobha, “Ojho ndo niani? ");
INSERT INTO kiz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Bhumati bhukajibu, “Ojho ndo Yesu Nabii, kuhoma Nazareti ya Galilaya.” ");
INSERT INTO kiz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kisha Yesu akajhingila mu lihekalu lya Mungu au K'yara. akabhabhenga kwibhala bhoha bhabhajhele bhigola ni kugolesya mu lihekalu. Pia abinisi ni kup'hendade meza sya bhabadilishaji bha fedha ni fiti fya bhahemelesaji bha nj'hebha. ");
INSERT INTO kiz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akabhajobhela, “Jhilembibhwa, `'Nyumba jhangu jhikutibhwa nyumba jha maombi, `lakini muenga mujhibhakhili pango lya bhanyang`anyi.” ");
INSERT INTO kiz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","kisha fipofu ni filema bhakahida mu lihekalu, nu muene akaponesya. ");
INSERT INTO kiz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lakini bhwakati bhakholo bha makuhani ni bhaalembesi bho bhaghabhuene maajabu ghaaghabhombili, na bhobhapeliki bhana bhijhwegha mulihekalu ni kujobha, “Hosana kwa Mwana ghwa Daudi,” bhakamuliki ni ligoga. ");
INSERT INTO kiz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakan'jobhela, “Ukip'heliki khela kyakijobhibhwa ni bhanu abha?” Yesu akabhajobhela, “Ena! Lakini bhamanyi lepi kusoma, 'Kuhoma ku milomo ghya bhana na bhana bhadebe bhabhijhonga muj'he ni sifa kamili?” ");
INSERT INTO kiz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kisha Yesu akabhaleka ni kulota kwibhala jha mji mu Bethania ni kugona okhu. ");
INSERT INTO kiz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lukhela bho ikerebhuka ku mjini ajhele ni njala. ");
INSERT INTO kiz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Abhubhuene libehe kandokando j'ha barabara, akabhulotela, lakini akabhilepi khenu juu jhiakhe isipokujha matondo. Akabhujobhela, “Kusijhi ni matunda mu libehe o'mo daima kabhele.” Na mara ejhu libehe lela likayoma. ");
INSERT INTO kiz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bhanafunzi bho bhabhuene, bhakastaajabu ni kujobha, “Jhijhebhuli libehe lij'homili mara moja?” ");
INSERT INTO kiz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu akajibu ni kubhajobhela, “Kweli nikabhajobhela, kama mkajhelayi ni imani bila bhugha, mwibetalepi kubhomba khela kya kibhombiki mu libehe e'lu tu, lakini mwibeta kukijobhela ata ekibaha kid'onda utolibhwayi ni kutaghibhwa mu bahari, na jhibetakubhombeka. ");
INSERT INTO kiz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kyokyoha kyamwibeta kus'oma kwa sala, khoni mwikiera.” ");
INSERT INTO kiz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu bho afikili mu lihekalu, bhabhaha bha makuhani ni bhaseya bha bhanu bhakan'hidila bhwakati imanyisya ni kun'kota, “Ni kwa mamlaka gani ghwibhomba mambo agha? ");
INSERT INTO kiz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akajibu ni kubhajobhela, “Ni nene kabhele nikabhokhota limonga. kama mwibeta kunijobhela, nani mebhu nikabhajobhela ni kwa mamlaka gani nibhomba mambo agha. ");
INSERT INTO kiz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bhubatizo bhwa Yohana- bhwahomili ndaku, kumbinguni au kwa mwanadamu?” Bhakahojiana bhene, bhakajobha, tukajobha bhukah'omili kumbinguni, `ibetakutujobhela, kwa ndabha jhakiki mukamwamini lepi?` ");
INSERT INTO kiz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lakini tukajobhai, `bhwah'omilik kwa mwanadamu, `tukabhatila makhutano, kwa ndabha bhoha bhakan'kiera Yohana kama nabii.” ");
INSERT INTO kiz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kisha bhakan'jibu Yesu ni kujobha, “Tumanyi lepi” Akabhajobhela pia, “Bhwala nene nikabhajobhela lepi ni kwa mamlaka gani nibhomba mambo agha. ");
INSERT INTO kiz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Lakini mwifikiri kiki? Munu jhaajhele ni bhana bhabhele. Akalota kwa mmonga ni kun'jobhela, `Mwanabhangu, lotayi kabhomba mbombo mu n'gonda ghwa mizabibu lelu. ");
INSERT INTO kiz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","`Mwanamunu akan'jibu ni kujobha, `nilotalepi,' Lakini baadaye akalota akabadilisha mabhuasu gha muene na akalota. ");
INSERT INTO kiz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na Munu yolayola akalota kwa mwana ghwa pili ni kun'jobhela mabhwa. Mwana jhola akajibu ni kujobha, `nilota, bwana', lakini akalotalepi. ");
INSERT INTO kiz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jholoki kati j'ha bhana bhabhele j'haabhombili matakwa gha tata ghuake? Bhakajobha, “Mwana ghwa kubhwandelu.” Yesu akabhajobhela, “Kweli nikabhajobhela, bhabhonganiya ushuru ni makahaba bhibetakujhingila mu bhufalme bhwa K'yara kabla jha muenga kujhingila. ");
INSERT INTO kiz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa ndabha Yohana ahidili kwa nj'hela j'hinofu, lakini mwabelili kun'kiera, bhwakati bhabhonganiya bhushuru ni makahaba bhan'kyeriri. Na muenga, bho mubhuene e'lu likheteka, mwabhwesilepi kutubu ili baadaye mun'kieraghe. ");
INSERT INTO kiz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mup'helekisiaghe mfuano bhongi. Kwa jhele ni munu n'kolo lieneo libhaha lya ardhi. Abhiere mizabibu akajhibhekhela bhuzio, akatengenesya ni khenu kya kukamulila divai, akajenga ni mnara ghwa bhalinzi, na akalikodisya kwa bhatunza zabibu. Kisha akalota mu nchi jhenge. ");
INSERT INTO kiz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bhwakati bhwa mavuno ghya mizabibu bho bhukaribili, abhatumili baadhi jha bhatumishi kwa bhakulima bha mizabibu kutola mizabibu ghya bhene. ");
INSERT INTO kiz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lakini bhakulima bha mizabibu bhakabhalota bhatumishi bha muene, bhakan'tobha mmonga, kwa maganga. ");
INSERT INTO kiz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kwa mara jhenge, Mmiliki akabhatuma bhatumishi bhangi, bhingi zaidi jha bhala bha kubhwandelu, lakini bhakulima bha mizabibu bhakabhakhetela mabhu. ");
INSERT INTO kiz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Baada j'ha apu bwana j'hola akan'tuma kwa bhene mwana munu, akajobha, `'Mwibetakun'heshimu mwanabhangu.'` ");
INSERT INTO kiz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini bhakulima bha mizabibu bho bhambwene n'songolo jhola, bhakajobhesana `'Ojho ndo mrithi, Muhidayi, tunkemayi na tumilikiayi urithi.' ");
INSERT INTO kiz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","`Hivyo bhakan'tola, bhakan'tagha kubhala ku n'gonda ghwa mizabibu ni kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Je mmiliki ghwa migonda ghya mizabibu paibetakuhida, ibetakubhabhomba bhuli au kiki bhakulima bha mizabibu?” ");
INSERT INTO kiz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhakan'jobhela, “Ibetakubhaharibu bhanu abhu bhaovu mu njela jha bhukali zaidi, na kisha ibetakulikodisya kwa bhakulima bhangi n'gonda ghwa mizabibu, bhanu ambabho bhibeta kulepa kwandabha jha mizabibu pa jhibeta kufunda.” ");
INSERT INTO kiz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu akabhajobhela, “Mwas'omi lepi mu maandiko, 'Liganga lya bhalibelili waashi lijhele liganda likholu lya msingi. E'le lyahomili kwa Bwana, na jhishangasya pamihu pa tete?' ");
INSERT INTO kiz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hivyo nikabhajobhela, Bhufalme bhwa K'yara bhwibeta kuletibhwa kuh'omela kwa muenga ni kupelibhwa taifa lyalijali matunda ghake. ");
INSERT INTO kiz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jhojhioha jhaibeta kubina panani pa liganga e'lu ibetakubomolibhwa fipandi fipandi. Lakini kwa jhejhioha lyalibetakum'banila, libeta kun'siagha.” ");
INSERT INTO kiz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bhabhaha bha makuhani ni Mafarisayo bho bhap'eliki mifano ghiake bhakabhona kujha akabhazungumzila bhene. ");
INSERT INTO kiz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lakini khila kya bhalondeghe kunyosya kibhoko kunani kwa muene, bhatilili makutano, kwa ndabha bhanu bhambwene kama nabii. ");
INSERT INTO kiz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ajobhili nabhu kabhele mu mifuanu, akajobha, ");
INSERT INTO kiz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bhufalme bhwa kumbinguni bhwighwaningana ni mfalme jha ajhandele sherehe jha harusi jha mwanabhe. ");
INSERT INTO kiz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akabhatuma bhatumishi bha muene kubhakaribisya bhabhaalikibhu kuhida kusherehe jha harusi, lakini bhafiki lepi. ");
INSERT INTO kiz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mfalme abhatumili kabhele bhatumishi bhangi, akajobha. “Mubhajobhilayi bhoha bhabhaalikibhu, Mulangayi, niandele kyakulya. Fahali ni litoli lyanene lya linenipi bhachinjili ni mambo ghoha ghayele tayari, Muhidayi ku sherehe jha harusi.” ");
INSERT INTO kiz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini bhanu abhu bhazingatili lepi kwa dhati mualiko bhwa muene. Baadhi jha bhene bhakherebhuiki mu mig'onda ghya bhene, ni bhangi bhakherebhuiki mu sehemu sya biashara sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bhangi bhabhajhinukili bhatumishi bha mfalme ni kubhaaibisya ni kubhakhoma. ");
INSERT INTO kiz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lakini mfalme adadili. Atumili jeshi lya muene, akabhakoma bhala bhakomaji ni kubhukosya mji ghwa bhene ni muoto. ");
INSERT INTO kiz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kisha akabhajobhela bhatumishi bha muene, “Harusi iyele tayari, lakini bhabhaalikibhu bhalondekeghe lepi. ");
INSERT INTO kiz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Henu mulotayi ku makutano gha njhela mbaha, mubhaalikayi bhanu bhingi kadiri kya jhilondeka bhahidai ku sherehe jha harusi.” ");
INSERT INTO kiz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bhatumishi bhakalota njhela mbaha ni kubhakaribisya bhanu bhoha bhabhabhuene, bhema ni au bhanofu ni bhabhibhi. Henu bhukumbi bhwa harusi bhwa memili bhahesya. ");
INSERT INTO kiz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lakini mfalme bho ajhingili kubhalanga bhahesya ambwene munu mmonga ambajhe afwali lepi ligwanda rasmi lya harusi! ");
INSERT INTO kiz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mfalme akan'kota, 'Ndongo bhangu, ghwabhwesi bhuli kufika apa mugati bila ligwanda lya harusi?' Na munu ojhu an'jibili lepi khenu kyokyoha khela. ");
INSERT INTO kiz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ndipo mfalme akabhajobhela bhatumishi bha muene, “Mun'kongoyi munu ojho mabhoko ni magolo mun'taghai kwibhala mu kitila, ekhu ambako kubeta kujha ni kilelu ni kusiagha minu. ");
INSERT INTO kiz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kwa kujha bhanu bhingi bhikutibhwa, lakini bhateule bhadebe.” ");
INSERT INTO kiz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ndipo Mafarisayo bhakabhoka ni kupanga jinsi jha kun'kamula Yesu mu malobhi gha muene. ");
INSERT INTO kiz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ndipo bhakabhatuma bhanafunzi bha bhene ni Maherode. Na bhakan'jobhela Yesu, “Mwalimu, tumanyili kujobha bhebhe ndo munu ghwa bhukweli, na ghwimanyisya matakwa gha Mungu mu bhukweli. Ghwijali lepi maoni gha munu jhongi na ghwilasya lepi bhupendelelu kwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Henu tujobhilayi ghwifikilila kiki? Je, bhukweli kulepa kodi kwa Kaisari au lepi?” ");
INSERT INTO kiz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu akamanya bhuovu bhwa bhene na akajobha, “Kwandabha jhakiki mkanijaribu, muenga bhanafiki? ");
INSERT INTO kiz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mimilasiayi hela jhejhitumika kulep'hela kodi.” Ndipo bhakandetela dinari. ");
INSERT INTO kiz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu akabhakhota, “Sura ni lihina ele lya niani?” ");
INSERT INTO kiz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakan'jibu, “fya Kaisari.” Ndipo Yesu akabhajobhela, “Mumpelayi Kaisari fenu fyafijhele fya muene ni fya K'yara mumpelayi K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bho bhap'heliki naha bhakashangala. Kisha bhakandeka ni kwilotela. ");
INSERT INTO kiz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ligono elu baadhi jha Masadukayo bhakahida kwa Yesu, bhala bhabhijobha kujha bhujhelepi bhufufuo bhwa bhafu. Bhakan'kota, ");
INSERT INTO kiz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","bhakajhabhijobha, “Mwalimu, Musa ajobhili, Ikajhiyi munu afuili bila kuhogola bhana, ndongo munu na andisiayi n'dala ojhu na ampelayi muana kwa ndabha jha ndongo munu. ");
INSERT INTO kiz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bhajhele bhalongo saba. ghwa kuanda agegili na kisha afuili bila kuhogola bhana. Akandekela n'dala ndongomunu. ");
INSERT INTO kiz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kisha ndongomunu ghwa pili nu muene aketili mebhu, kisha yola ghwa tatu, ikajha mebhu hadi jhola ghwa saba. ");
INSERT INTO kiz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Baada jha kubhomba aghu bhoha, yola n'dala nu muene akafwa. ");
INSERT INTO kiz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Henu katika bhufufuo n'dala ojhu ibetakujha n'dala ghwa niani kati jha bhanu abhu saba? Kwa ndabha bhoha bhan'gegili.” ");
INSERT INTO kiz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lakini Yesu abhajibili ni kubhajobhela, “Mwikosela, kwa ndabha mumanyilepi mayandiku ni nghofu sya K'yara. ");
INSERT INTO kiz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwa kujha mu bhufufuo, bhanu bhigega lepi bhwala kugegikibhwa. Badala jhiaki bhanu bhijha kama malaika okhu kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini kuhusu bhufufuo bhwa bhafu, mubhwayi lepi kusoma khela ambakyo K'yara akijobhili kwa muenga, ajobhili, ");
INSERT INTO kiz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nene ndo K'yara ghwa Ibrahimu, K'yara ghwa Isaka, na K'yara ghwa Yakobo? K'yara si K'yara ghwa bhafu, bali ni K'yara ghwa bhajhe bhasima.'” ");
INSERT INTO kiz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bhwakati likusanyiku bho bhapeliki ele, bhaghasyangele mafundiso agha muene. ");
INSERT INTO kiz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lakini Mafarisayo bho bhapheliki kujha Yesu abhagudamisi Masadukayo, bhakibhongeniye bhoha kwa pamonga. ");
INSERT INTO kiz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mmonga ghwa bhene, ajhele mwana sheria, an'kotili liswali kwa kun'jaribu. ");
INSERT INTO kiz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwalimu, amri jheleku ijhele mbaha kuliko syoha mu sheria?” ");
INSERT INTO kiz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akan'jibu, “Lazima un'ganayi Bwana kwa n'tema ghuoha ghwa bhebhe, kwa roho jhiakhu jhioha ni kwa luhala lwakhu luoha. ");
INSERT INTO kiz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ejhe ndo amri mbaha na jha kuanza. ");
INSERT INTO kiz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na jha bhubhele jhiwaningana ni ejhu- Ni lazima kun'gana jirani ghwa jhobhi kama kyawikigana ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sheria syoha ni manabii bhitegemela amri ese sibhele.” ");
INSERT INTO kiz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ni Mafarisayo bhajhele bhakona bhakusanyiki pamonga, Yesu akabhakota liswali. ");
INSERT INTO kiz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Akajobha, “Je, Mwifikirila kiki kwa ndabha jha Kristu? Muene muana ghwa niani?” Nibhene bhakan'jibu, “Ni muana ghwa Daudi.” ");
INSERT INTO kiz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu akabhajibu, “Ni kwa namna gani Daudi mu Roho akan'kuta Bwana, akajobha, ");
INSERT INTO kiz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Bwana an'jobhili Bwana bhangu, “Tamayi kibhokho kya nene kyakulia, hadi panibetakubhabhomba maadui bhakhu bhabhekibhuayi pasi pa magolo gha jhobhi.”'?” ");
INSERT INTO kiz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kama Daudi akan'kuta Kristu “Bwana,” jinsi jhelekhu ibetakujha mwanamunu?” ");
INSERT INTO kiz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ajhelepi jhaabhwesili kunjibu lilobhi kabhele, na ajhele lepi jhaathubutuwili kabhele kun'kota maswali zaidi tangia ligono elu ni kujhandelela. ");
INSERT INTO kiz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Baadaye akalongela ni bhumati bhwa bhanafunzi bha muene ni bhanu. Akajobha, ");
INSERT INTO kiz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bhaandishi ni Mafarisayo bhitamila kiti kya Musa. ");
INSERT INTO kiz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Henu kyokyoha khela kyabhakaa munu kubhomba, mubhombayi khoni mukabhachungusya. Lakini msijhesi matendo gha bhene, kwa ndabha bhene bhitamka mambo gha bhibhomba lepi. ");
INSERT INTO kiz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kweli, bhene bhikhonga misighu ghyaghitopa ambaghyo ni figumu kup'henda, na kisha bhakabhap'endesya bhanu mu mabega gha bhene. Lakini bhene bhihegelesya lepi hata kikonji kujhip'henda. ");
INSERT INTO kiz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Matendo ghoha agha ghakaghabhomba ili bhalangibhuajhi ni bhanu. Kwa ndabha bhene bhipanula masanduku gha bhene na bhijhongesya mapindo gha mavazi gha bhene. ");
INSERT INTO kiz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bhene bhip'hendelela kutama maeneo gha kifahari mu sherehe ni mu fiti fya heshima mugati mu masinagogi, ");
INSERT INTO kiz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ni kusalimibhwa kwa heshima maeneo gha pa soko, ni kukutibhwa “Bhalimu” ni bhanu. ");
INSERT INTO kiz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini muenga mwilondeka lepi kukutibhwa “Bhalimi,” kwa ndabha mujhenaku Mwalimu mmonga tu, yaani Kristu na muenga mwebhoha lukholo. ");
INSERT INTO kiz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Musin'kuti munu jhojhioha jhola pa duniani apa kujha dadi jhinu, kwa kujha myenaku dadi yinu, mmonga tu, nu muene ajhele kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bhwala musihidi kukutibhwa 'bhalimu,' kwa kujha mjhenaku Mwalimu tu, yaani Kristu. ");
INSERT INTO kiz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bali jhaajhe mbaha mugati mwa muenga ibetakujha n'tumishib ghwa muenga. Jhejhioha jhola jhaikwikuesya ibetaselesibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na jhejhioha jha ibetakwiselesya ibetakukwesibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lakini ole bhwinu bhaandishi ni Mafarisayo, bhanafiki! Mkabhafungila bhanu bhufalme bhwa mbinguni. Namu mwibhwesya lepi kujhingila, na mkabharuhusu lepi bha bhijhingila kubhomba aghu. ");
INSERT INTO kiz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mwilobhoka kwiselya jha bahari ni kufika kummbomba munu mmonga jhaiamini ghala gha mughamanyisi, na paijha kama muenga, mwibhomba mara mbili mwana ghwa jehanamu kama muenga mwebhene kyamujhele. ");
INSERT INTO kiz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ole bhinu muenga bhalongosi bhabhilola lepi, muenga mwijobha, Jhejhioha jha ilapa ku lihekalu khenu lepi. Lakini jhailapa kwa dhabahu jha hekalu, afungibhu kwa kiapo kya muene. ");
INSERT INTO kiz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Muenga fipofu bhapumbafu, kheleku kibhaha kuliko khenge, dhahabu au lihekalu ambalyo libhabhekili bhakfu dhahabu kwa K'yara? ");
INSERT INTO kiz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na, j'hejhioha jhailapa kwa madhabahu, khenu lepi. Bali jhailapa kwa sadaka jhaijhele panani pa muene, afungibhu ni kiapo kya muene. ");
INSERT INTO kiz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Muenga bhanu fipofu, khelekhu kibhaha kuliko khenge, sadaka au madhabahu ambagho ghibheka bhakfu sadaka syasipisibhwa kwa K'yara? ");
INSERT INTO kiz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Henu, muene jhailapa kwa madhabahu ilapa kwa ejhu ni kwa fenu fyoha fyafijhele panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu muene jhailapa kwa hekalu, ilapa kwa elu na kwa muene jhaitama mugati mwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nu muene jhailapa kwa mbingu, ilapa kwa kya enzi kya K'yara ni kwa muene jhaitama kunani kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ole bhinu, bhaandishi ni Mafarisayo, bhanafiki! Kwa kujha mwilepa zaka kwa bizali, mnaanaa ni nchicha, lakini mwilepa mambo masitu gha sheria- haki, rehema, ni imani. Lakini agha mwilondeka kujha mughabhombili, na siyo kuleka ghangi bila kughatekelesya. ");
INSERT INTO kiz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Muenga bhalongosi fipofu, muenga ambabho mwichuja lenu lidusu mwimila ngamia! ");
INSERT INTO kiz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ole bhinu, bhaandishi ni Mafarisayo, bhanafiki kwa kujha mwisuka kwibhala ku fikombe ni kwibhala ku sahani, lakini mugati mumemili dhuluma ni kutokujha ni kiasi. ");
INSERT INTO kiz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Muenga Mafarisayo fipofu, musukayi hoti mugati mu kikombi ni musahani, ili lubhafu lwa kwibhala nu luene lujhelayi kinofu pia. ");
INSERT INTO kiz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ole bhinu, bhaandishi ni Mafarisayo, bhanafiki! kwa ndabha mwiwaningana ni makaburi ghaghabakibhu chokaa, ambagho kwa kwibhala ghibhonekana manofu, lakini kwa mugati ghamemili mafupa gha bhafu ni khila khenu kyakijhele kichafu. ");
INSERT INTO kiz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Fefuefu, namu kwa kwibhala mwibhonekana bhenye haki mbele sa bhanu, lakini kwa mugati mumemili bhunafiki ni bhudhalimu. ");
INSERT INTO kiz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ole bhinu, bhaandishi ni Mafarisayo, bhanafiki! kwa kujha mwijenga makaburi gha manabii ni kughapamba makaburi gha bhenye haki. ");
INSERT INTO kiz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Muenga mwijobha, kama tungeishi magono gha tata ghwitu, ngatujhelepi pamonga nabhu kujhitisya lilopa lya manabii. ");
INSERT INTO kiz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Henu, mwishuhudila mwebhene kujha muenga ndo bhana bha abhu bha bhakomili manabii. ");
INSERT INTO kiz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pia muenga mwikamilisya kumemesya sehemu jhajhilondeka dhambi sya bha tata jhinu. ");
INSERT INTO kiz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Muenga mayoka, bhana bha vipiribao, kibhuli mkajhiyepa hukumu jha jehanamu? ");
INSERT INTO kiz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Henu, langayi, nikabhatuma kwa muenga manabii, bhanu bhabhajhe ni hekima, ni bhaandishi. Baadhi jha bhene bhibeta kubhakhoma ni kubhasulubisya. Na baadhi jha bhene mwibetakubhatobha mgati mu masinagogi gha muenga ni kubhabhenga kuh'omela mji umonga hadi bhongi. ");
INSERT INTO kiz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Matokeo ni kwamba panani pa muenga pibeta kuhomela lilopa lyoha lya bhenye haki syasijhitisibhu pa duniani, kujhandila kilo pa lya Habili jhaajhe ni haki hadi kwa lilopa lya Zakaria mwana ghwa Barakia, jha mwan'komili kati jha patakatifu ni madhabahu. ");
INSERT INTO kiz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bhukweli, nikabhajobhela, mambo agha ghoha ghibetakukikabha kizazi e'khe. ");
INSERT INTO kiz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalemu, Yerusalemu, bhebhe jhaukabhakhoma manabii ni kubhahomelela maganga bhala ambabho bhatumwa bha bhebhe! mara silenga nibhabhongeniye bhana bha bhebhe pamonga kama vile n'ng'oko kya ikafibhonganiya fyana fya muene pasi pa mababatilu gha muene, lakini ghwabelili! ");
INSERT INTO kiz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Langai, nyumba jha jhobhi jhisiele bhukhebha. ");
INSERT INTO kiz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nani nikujobhela, Kujhandila henu ni kujhendelela ghwibeta lepi kunibhona, hadi paghibeta kujobha, 'Abarikibhu muene jhaibetakuhida ku lihina lya Bwana.'” ");
INSERT INTO kiz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ahomili mu lihekalu ni kwibhokhela. Bhanafunzi bha muene bhakandotela ni kundasya majengo gha hekalu. ");
INSERT INTO kiz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lakini abhajibili ni kubhajobhela, “Je, mukaghabhona lepi mambo ghoha agha? Bhukweli nikabhajobhela, lijhelepi liganda lya lise'ele panani pa l'enge bila kubomolibhwa.” ");
INSERT INTO kiz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na bhoatamili pa Kid'onda kya Mizeituni, bhanafunzi bha muene bhakandotela kwa faragha ni kujobha, “Tujobhilayi, mambo agha ghibetakuh'omela ndali? Khenu khelekhu kibetakujha dalili jha kuhida kwa bhebhe ni mwisho ghwa dunia?” ");
INSERT INTO kiz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu abhajibili ni kubhajobhela, “Mujhelayi mkangamele asihidi munu kubhapotosha. ");
INSERT INTO kiz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwandabha bhingi bhibetakuhida kwa lihina lya nene. Bhibeta kujobha, 'Nene ndo Kristu', na bhibetakubhakofya bhingi. ");
INSERT INTO kiz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mwibetakupel'eka ngondo ni taarifa sya ngondo. Mulangayi musihidi mkajha ni bhuogha, kwandabha mambo agha ghilondeka lepi kuh'omela; lakini mwisho bhola ghwibetakujha bado. ");
INSERT INTO kiz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwa kujha taifa libetakujhinuka dhidi jha litaifa l'enge ni bhufalme dhidi jha bhufalme. Kubetakujha ni njala ni matetemeku gha n'dema mu sehemu mbalimbali. ");
INSERT INTO kiz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lakini mambo agha ghoha ni kubhwandelu tu ghwa bhuchungu bhwa kuhogola. ");
INSERT INTO kiz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ndipo bhibetakubhahomesya kwandabha jha malombosi ni kubhakhoma. mwibetakudadibhwa ni mataifa ghoha kwandabha jha lihina lya nene. ");
INSERT INTO kiz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ndipo bhingi bhibeta kwikungufula ni kusalitiana ni kudadilana bhene kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Manabii bhingi bha bhudesi bhibetakuhomela ni kubhakofya bhingi. ");
INSERT INTO kiz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwandabha bhuovu bhwibetakujhongeseka, luganu lwa bhingi bhwibetakupola. ");
INSERT INTO kiz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini jhaibetakusindamala mpaka kumwishu, ibetakuokolibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ejhu Injili jha bhufalme jhibetakuhubiribhwa mu bhulimwengu mzima kama bhushuhuda kwa mataifa ghoha. Na ndipo mwishu bhola bhwibetakufika. ");
INSERT INTO kiz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Henu, pamwibetakubhona lichukizo lya bhuharibifu, lyalijobhibhu ni nabii Danieli lijhemili mahali patakatifu jhaisoma ni jhaimanya, ");
INSERT INTO kiz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ndipo bhabhajhele Yuda bhajumbilayi kukid'onda. ");
INSERT INTO kiz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ni jhola jha ajhele kunani ku paa lya nyumba asibhwesi kuselela pasi kutola khenu kyokyoha khela kuh'oma mugati mu nyumba jha muene, ");
INSERT INTO kiz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nu muene jha ajhele kun'gonda asikerebhuki kutola liguanda lya muene. ");
INSERT INTO kiz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lakini ole bhinu ambabho bhabhajhe ni muana ni bhala bhabhijhong'esya mu magono aghu! ");
INSERT INTO kiz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Musomayi kujha kujumba kwa muenga kusijhi bhwakati bhwa mepu bhwala ligono lya sabato. ");
INSERT INTO kiz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwandabha kubetakujha ni dhiki mbaha ambayo jhibhwahilepi kujha tangia kubhombibhwa kwa bhulimwengu hadi henu, na bhwala jhibetalepi kujha kabhele. ");
INSERT INTO kiz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kama magono aghu ghabelikufupisibhwa, ajhelepi ambajhe ngaookuiki. Lakini kwa ndabha jha bhateule, magono aghu ghibetakufupisibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kisha jhikajhiayi munu jhejhioha ibetakubhajobhela 'Langayi, Kristu ajhele apa! au, 'Kristu ajhele khola' msikieli malobhi aghu. ");
INSERT INTO kiz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa ndabha Makristu gha bhudesi ni manabii bha bhudesi bhibetakuhida ni ishara mbaha ni maajabu, kwa ndabha jha kukofya, kama jhibhwesekana hata ni bhateule. ");
INSERT INTO kiz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mulangayi, ni bhatahadharishi kabla jha mambo aghu kuho'mela. ");
INSERT INTO kiz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Henu, ikajhiagha bhibetakubhajobhela, “Kristu ajhele kulijangwa,' musiloti okhu ku lijangwa. Au, 'Mulangayi ajhele mugati mu nyumba,' musikieli malobhi aghu. ");
INSERT INTO kiz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kama vile radi kyajhimuliki kuh'omela mashariki ni kulasya hadi magharibi, naha ndo kyajhibetakujha kuhida kwa Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Popoha pala pa ujhele ufuili, okhu ndo tai kwa bhikwibhonganiya. ");
INSERT INTO kiz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Lakini mara baada jha malombosi mabhaha gha magono ghala, lij'obha libetakujha ni ngisi, muwesi ghwibetalepi kuh'omesya mwanga ghwake, matondo ghibetakubina kuh'omela kunani, ni nghofu sya kumbinguni sibetakuhugunika. ");
INSERT INTO kiz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ndipo ishara jha Muana ghwa Adamu jhibetakubhonekana kunani, ni makabila ghoha gha pa duniani ghibetakuombolesya. Bhibetakumbona Mwana ghwa Adamu ihida mu mabhengu gha kunani kwa nghofu ni bhutukufu mmbaha. ");
INSERT INTO kiz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ibetakubhalaghisya malaika bha muene kwa sauti mbaha jha tarumbeta, na bhene bhibetakwibhonganiya pamonga ni bhateule bha muene kuhomela pande mbaha nne sya dunia, kuh'oma mwishu umonga bhwa mbingu hadi bhongi. ");
INSERT INTO kiz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mwikimanyisiayi lisomo kuh'omela ni libehe mulibehe. Mara tu litafi palibetakumela ni kuh'omesya matondo, mmanyili kujha kiangazi kihegelela. ");
INSERT INTO kiz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Henu, pia, pamwibetakubhona mambo agha ghoha, mwilondeka kumanya kujha ihegelela, karibila ni kujhingila. ");
INSERT INTO kiz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bhukweli nikabhajobhela kizazi ekhe kibetalepi kup'heta, hadi mambo ghoha agha ghibetakujhahah'omili. ");
INSERT INTO kiz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mbingu ni nchi sibetakup'heta, lakini malobhi ghangu ghibetalepi kup'heta hata ligono limonga. ");
INSERT INTO kiz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lakini kuhusu ligono lela ni saa ajhelepi jha amanyili, hata malaika bha kumbinguni, bhwala Mwana, bali tete muene tu. ");
INSERT INTO kiz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kama vile kyaijhele mu ligono lya Nuhu, ndivyo kajhibetakujha kwa Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwa kujha mu magono aghu kabla jha gharika bhanu bhajhele bhilya ni kunywa, bhigega ni kugegikibhwa hadi ligono lela ambalyo Nuhu ajhingili mu safina, ");
INSERT INTO kiz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na bhamanyili lepi khenu kyokyoha, khela hadi ghatika bho jhihidili ni kubhap'hendana bhoha - ndivyo kyajhibetakujha kuhida kwa Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ndipo bhanu bhabhele bhibetakujha kun'gonda- mmonga ibetakulibhwa ni mmonga ibetakulekibhwa kunyuma. ");
INSERT INTO kiz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bhadala bhabhele bhibetakujha bhisiagha pamonga- mmonga ibetakutolibhwa, ni mmonga ibetakubakila. ");
INSERT INTO kiz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Henu, mujhiayi mihu kwa ndabha mmanyilepi ligono bhwala lisaa lelekhu ambalyo ibetakuhida Bwana bhinu. ");
INSERT INTO kiz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini mmanyayi kujha, ikajhelayi bwana n'kolo nyumba ngaamanyi ni lisaa lelekhu mmeji ngaahidili, ngaakeshili ni kutokuruhusu nyumba jha muene kuvamibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Henu, pia mwilondeka kujha tayari, kwa kujha Mwana ghwa Adamu ibetakuhida mu lisaa lyamtarajili lepi. ");
INSERT INTO kiz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Henu niani jhaajhele n'kamilifu, n'tumwa jha ajhe ni luhala, ambajhe bwana ghwa muene ampelili madaraka gha panani kwa bhabhajhele panyumba jha muene ili abhapelayi kyakula kwa bhwakati bhwa bhwilondeka? ");
INSERT INTO kiz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Abarikibhu n'tumishi ojhu, ambajhe bwana ghwa muene ibetakun'kolela ibhomba aghu bhwakati bhwabhwihida. ");
INSERT INTO kiz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bhukweli nikabhabhola kujha bwana ibetakumbeka panani pa khila khenu kya muene. ");
INSERT INTO kiz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini kama n'tumwa muovu akajobhayi mun'teema bhwa muene, 'Bwana ghwangu akabhili,' ");
INSERT INTO kiz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na akajhanda kubhatobha bhatumishi bha muene, na akalya ni kugala fileo, ");
INSERT INTO kiz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bwana ghwa n'tumwa ojhu ibetakuhida mu magono ambagho ghaghitarajila lepi, ni lisaa ambalyo alimanyililepi. ");
INSERT INTO kiz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bwana ghwa muene ibetakun'dumula fipandi fibhele ni kumbekha mu nafasi jhimonga sawa ni bhanafiki, ambako kubetakujha ni khilelu ni kusiagha minu. ");
INSERT INTO kiz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ndipo bhufalme bhwa kumbinguni bhwibetakufananisibhwa ni bhanabhali kumi bhabhatolili taa sya bhene ni kulota kunjambelela bwana harusi. ");
INSERT INTO kiz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bhahanu miongoni mwa bhene bhajhele bhapumbafu na bhahanu bhangi bhajhele bherevu. ");
INSERT INTO kiz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhanabhali bhapumbafu bhatolili taa sya bhene, bhatolili lepi mafuta ghoghoha ghala. ");
INSERT INTO kiz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bali bhanabhali bherevu bhatolili fenu fyafijhele ni mafuta pamonga ni taa sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hene bho bwana harusi akabhili kuhida bhoha bhakamuliki ni ligono na bhakagona. ");
INSERT INTO kiz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lakini bho jhijhingili ngisi pakilu pajhele ni njweghu, 'Langayi, bwana harusi! Muhomayi kwibhala kunjamb'elela.' ");
INSERT INTO kiz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ndipo abhu bhana bhali bhakajhumuka bhoha ni kubhwasya taa sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bhala bhapumbafu bhakabhajobhela bhala bherevu, 'mutupelayi sehemu jha mafuta gha muenga kwandabha taa syitu sisimika.' ");
INSERT INTO kiz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini bhala bherevu bhakabhajibu ni kubhajobhela, 'Kwa kujha ghibetalepi kututosya tete ni muenga badala jhiakhe mulotayi kwa bhabhihemetesya mkahemelayi kiasi kwa ndabha jha muenga.' ");
INSERT INTO kiz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bho bhatolili okhu kuhemela, Bwana harusi akahida, na bhoha bhajhele tayari bhakalota nakhu ku sherehe jha harusi, ni ndiangu ukadendibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baadaye bhala bhana bhali bhangi pia bhakahida ni kujobha, 'Bwana, bwana, tudendulilayi.' ");
INSERT INTO kiz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini ajibili ni kujobha, 'Kweli nikabhajobhela, Nene nibhamanyili lepi.' ");
INSERT INTO kiz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Henu mulangayi, kwandabha mumanyilepi ligono au lisaa. ");
INSERT INTO kiz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kwa kujha ni sawa ni munu jhaalondeghe kusafiri kulota nchi yenge. Akabhakuta bhatumwa bhwa muene ni kubhakabidhi bhutajiri bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mmonga kati jha bhene ampelili talanta sihanu, jhongi ampelili sibhele, nu jhongi ampelili talanta jhimonga. Kila mmonga ampelili kul'engana ni bhuwezo bhwa muene, nu munu jhola akasafiri kwilotela. ");
INSERT INTO kiz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Manyata jhola jhaajhambelili talanta sihanu alotili kusijhandisila ni kusihogolesya taanta sengi sihanu. ");
INSERT INTO kiz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vilevile jhola jhaapokili talanta sibhele asihogolisi senge sibhele. ");
INSERT INTO kiz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini n'tumwa j'haapokili talanta jhimonga, akilotili, akagima lilende pasi ni kufigha talanta jha bwana ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na baada jha muda ufupi, bwana ghwa bhatumwa abhu akherebhwiki ni kutengenesiya mahesabu nabhu. ");
INSERT INTO kiz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jhola n'tumwa jhaapokili talanta sihanu ahidi ni kusileta kabhele senge sihanu, akajobha, 'Bwana, wanipelili talanta sihanu. Langayi, nikabhili faida jha talanta senge sihanu.' ");
INSERT INTO kiz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bwana ghwa muene akan'jobhela, 'Hongera, n'tumwa nnofu na mwaminifu! Ujhele mwaminofu kwa fenu fidebe. Nibetakupela madaraka kufenu fibhaha fingi. Jhingilayi mu furaha jha bwana ghwakhu! ");
INSERT INTO kiz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","N'tumwa jha apokili talanta sibhele akahida ni kujobha, 'Bwana, ghwanibelili talanta sibhele. Langayi, nikabhili kabhele faida jha talanta sijhele,' ");
INSERT INTO kiz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bwana ghwa muene akan'jobhela, 'Hongera, n'tumwa nnofu na mwaminifu! Ujhele ghwa mwaminifu kwa fenu fidebe. Nibetakupela madaraka juu jha fenu fingi. Jhingilayi mu furaha jha bwana bhwakhu.' ");
INSERT INTO kiz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Baadajhe n'tumwa jhaapokili talanta jhimonga akahida ni kujobha, 'Bwana, nimanyili kujha bhebhe ghwe nkali. Ghwijhabhe ambapo upandilepi, na ghwivuna mahali ambapo usiyelili lepi. ");
INSERT INTO kiz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nene natilili nalotili kuifigha talanta jha jhobhi mu bhudongo. Langayi, ujhenajhu apa jhele jhaijhele jhajhobhi.' ");
INSERT INTO kiz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lakini bwana ghwake akajibu akajibu ni kujobha, 'Bhebhe n'tumwa mwovu na mzembe ghwamanyili kujha nijhabha mahali ambapo nipandilepi ni kuvuna mahali ambapo nisyelili lepi. ");
INSERT INTO kiz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Henu ulondekeghe kubhapela hela jhangu bhanu bha benki, na bhwakati bhwa kubhujha kwa nene nganijhipokili jhela jha nene pamonga ni faida jhiakhe. ");
INSERT INTO kiz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Henu munyakayi talanta ejhu na mumpelayi jhola jha ajhele ni talanta kumi. ");
INSERT INTO kiz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kila munu jha ajhenaku, ibetakujhongesibhwa zaidi-hata kwa kujhongesibhwa kabhele. Lakini kwa jhejhioha jhaibetalepi kujha naku na hata khela kya ajhe nakhu inyakibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mun'sopayi kwibhala kukitita n'tumwa ojhu jhailondeka lepi, ambako kubetakujha ni kilelu ni kusiagha minu.' ");
INSERT INTO kiz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Bwakati Mwana ghwa Adamu paibetakuhida mu bhutukufu bhwa muene, ni malaika bhoha pamonga nu muene, ndipo paibetakutama panani pa kiti kwa muene kya bhutukufu. ");
INSERT INTO kiz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mataifa ghoha ghibetakwibhongeniya mbele sya muene, nu muene ibetakubhatangenisya bhanu, kama vile n'chungaji kyaikabhatenganisya kondoo ni mmene. ");
INSERT INTO kiz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ibetakubheka kondoo kibhoko kyamuene kya kuume, bali mmene ibetakubhabheka kibhoko kya kushoto. ");
INSERT INTO kiz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kisha mfalme ibetakubhajobhela bhala bha bhajhele kibhoko kya kulia, 'Muhidayi, mwamubarikibhu ni tata ghwa ghwanene, mubhulithiayi bhufalme bhwabhujhandalibhu kwa ndabha jhinu kuhomela kubhakibhwa msingi bhwa bhulimwengu. ");
INSERT INTO kiz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa kujha najhele ni njala na mwanipelili kyakulya; Najhele na n'geni na mwanikaribisi; ");
INSERT INTO kiz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Najhele ngholi, na mwanifwatiki nghobho; Najhele na n'tamu na mwan'tunzili; Najhele mu kifungu na mwahidili kunilota. ");
INSERT INTO kiz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ndipo bhenye haki bhibetakun'jibu ni kun'jobhela, 'Bwana, ndali twakubhwene ujhe ni njala ni kukulesya? Au kujha ni kiu na tukakupela masi? ");
INSERT INTO kiz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na ndali twakubhwene ghwe n'geni, na tukakukaribisya? Au ujhe ngholi na tukakufweka nghobho? ");
INSERT INTO kiz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ndali tubetakubhona ghwiluala kama wiluala, au mu kifungu, tukahida kulola? ");
INSERT INTO kiz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na mfalme ibetakubhajibu ni kubhajobhela, 'bhukweli nikabhajobhela, kyamkibhombili apa kwa mmonga ghwa bhalongo bhangu bhadebe, munibhombili nene.' ");
INSERT INTO kiz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ndipo ibetakubhajobhela abhu bhabhajhele kibhokho kya muene kya kushoto, 'Mubhokayi kwa nene, mwamulaanibhu, mulotayi mu muoto bhwa milele bhwabhujhandalibhu kwa ndabha jha lisyetani ni malaika bha muene, ");
INSERT INTO kiz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kwa ndabha najhele ni njala lakini mwanijhimili kyakulya; najhele ni kiu lakini mwanjimili masi; ");
INSERT INTO kiz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Najhele ne n'geni lakini mwabelili kunikaribisya; najhele ngholi lakini mwanipelili lepi nghobho; najhele nen'tamu na nikajhelayi mu kifungu, lakini mwan'tunzi lepi.' ");
INSERT INTO kiz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ndipo bhene pia bhibetakun'jibu ni kujobha, 'Bwana, ndali twakubhwene ujhele ni njala au kiu au n'geni, au ngholi, au n'tamu, au afungibhu, na twakuhudumili lepi? ");
INSERT INTO kiz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kisha ibetakubhajibu ni kubhajobhela, 'Kweli nikabhajobhela, khela ambakyo mwakibhombili lepi kwa mmonga ghwa abha bhadebe, munibhombilepi nene.' ");
INSERT INTO kiz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Abha bhibetakulota mu adhabu jha milele bali bhenye haki mu bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bhwakati Yesu amalili kujobha malobhi ghoha agha, akabhajobhela bhanafunzi bha muene, ");
INSERT INTO kiz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mmanyili kujha baada jha magono mabhele kubetakujha ni sikukuu jha pasaka, ni Mwana ghwa Adamu ibetakuletibhwa ili asulubibhwayi.” ");
INSERT INTO kiz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Baadaye bhabhaha bha makuhani ni bhaseya bha bhanu bhabhonene pamonga mu makao gha Kuhani Mbaha, jhaakutibhweghe Kayafa. ");
INSERT INTO kiz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kwa pamonga bhapangili njama jha kun'kamula Yesu kwa siri ni kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kwa kujha bhajobhili, “Isibhombeki bhwakati bhwa sikukuu, kusudi jhisijhi jhikajhaghasia mugati mwa bhanu,” ");
INSERT INTO kiz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bhwakati Yesu ajhele Bethania mu nyumba jha Simoni mkoma, ");
INSERT INTO kiz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bho akinyosisi pa meza, n'dala mmonga akahida kwa muene akajha apendili nkebe ghwa alabasta jhajhijhela ni mafuta ghenye thamani mbaha, na aghamimini panani pa mutu bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lakini bhanafunzi bha muene bhobhabhuene lijambo lala, bhakadada ni kujobha, “Kiki ndabha jha hasara ejhu? ");
INSERT INTO kiz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aghu ngaghabhwesi kugolesibhwa kwa kiasi kibhaha ni kupelibhwa maskini,” ");
INSERT INTO kiz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lakini Yesu, akajha amanyili elu, akabhajobhela, “Kwa ndabha jha kiki mkandombosya n'dala ojhu? Kwa kujha abhombili mambo manofu kwa nene. ");
INSERT INTO kiz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maskini mjhenabhu magono ghoha, lakini mwibeta lepi ni nene daima. ");
INSERT INTO kiz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kwa ndabha bho amimini mafuta agha panani pa mb'ele bhuangu, abhombili aghu kwandabha jha maziku ghangu. ");
INSERT INTO kiz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bhukuweli nikabhajobhela, popoha pala Injili ejhe jhibetakuhubiribhwa mu bhulimwengu mzima, khenu kya abhombili n'dala ojho, pia kibeta kujobhibhwa kwa ndabha jha kumbukumbu.” ");
INSERT INTO kiz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndipo mmonga ghwa bhala kumi ni bhabhele, jhaakutibhweghe Yuda Iskarioti, alotili kwa bhabhaha bha makuhani ");
INSERT INTO kiz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ni kujobha, “Mwibetakunipela kiki kama nin'saliti?” Bhakamp'emela Yuda fipandi thelathini fya fedha. ");
INSERT INTO kiz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tangia muda obhu akalonda muda ghwa kun'saliti. ");
INSERT INTO kiz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hata ligono lya kubhwandelu lya mikate ghya ghisopibhu lepi chachu, bhanafunzi bhakandotela Yesu ni kujobha, “Ndaku ghwilonda tukujhandalilayi uliaghi kyakulya kya Pasaka?” ");
INSERT INTO kiz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Akabhajobhela, “Mulotayi kumjini kwa munu fulani na mun'jobhilayi, Mwalimu ijobha, “Muda ghwa nene ukaribili. Nibetakujhitimisya Pasaka pamonga ni bhanafunzi bhangu mu nyumba jha jhobhi.”” ");
INSERT INTO kiz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bhanafunzi bhakabhomba kama Yesu kya abhabholili, na bhajhendele kyakulya kya Pasaka. ");
INSERT INTO kiz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bhojhifikili kimihi, atamili pamonga ni bhanafunzi kumi na bhabhele. ");
INSERT INTO kiz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bhobhiliya kyakulya, akajobha, “Kweli nikabhajobhela mmonga bhinu ibetakunisaliti.” ");
INSERT INTO kiz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhahuzuniki sana, na khila mmonga akayanda kun'kota, “Je, hakika nenelepi, Bwana?” ");
INSERT INTO kiz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Akabhajibu, “Y'ola ambajhe ijhina kibhoko kya muene pamonga ni nene mu bakuli ndo jhaibeta kun'saliti. ");
INSERT INTO kiz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana ghwa Adamu ibetakubhoka, kama kyajhilembibhu. Lakini ole bhwake munu ambajhe ibetakun'saliti Mwana ghwa Adamu! Ngajhijhele kinofu kwa munu ojhu asihogoleki.” ");
INSERT INTO kiz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ambajhe an'saliti ajobhili, “Je!, Ndo nene Rabi?” Yesu akan'jobhela, “Ujobhili lijambo elu ghwa muene.” ");
INSERT INTO kiz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bho bhilya kyakulya, Yesu aupisili n'kate akabhubariki, ni kubhumetula. Akabhapela bhanafunzi bha muene akajobha, “Mutolayi, muliajhi. Obho ndo mb'ele bhwangu.” ");
INSERT INTO kiz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akapisya kikombi ni kubhombesya, akabhapela ni kujobha, “Munywajhi mwabhoha o'mo. ");
INSERT INTO kiz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwa kujha ejhe ndo lilopa lya agano lyangu, jhejhijhitika kwa ndabha jha bhingi kwa n'samaha ghwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lakini nikabhajobhela, nibetakunywa lepi matunda gha mzabibu obho hadi ligono lela panibetakunywa mpya pamonga namu mu bhufalme bhwa Tata ghwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bho bhamalili kujhemba lwembu, bhakabhoka kulota ku Kidonda kya Mizeituni. ");
INSERT INTO kiz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kisha Yesu akabhajobhela, “Pakilu apa mwebhoha mwibetakwikungufula kwandabha jha nene, kwa kujha jhijhandikibhu, Nibetakun'tobha n'chungaji ni kondoo mu likundi bhibetakutabhwanyika. ");
INSERT INTO kiz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini baada jha kufufuka kwa nene, nibetakubhalongolela kulota Galilaya.” ");
INSERT INTO kiz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lakini Petro akan'jobhela, “Hata kama bhoha bhibetakubela kwa ndabha jha mambo ghaghibeta kukabha, nene nibetalepi kubela.” ");
INSERT INTO kiz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu akan'jibu, “Bhukweli nikubhola, pakilu apa kabla jha likongobhe lyakona kubheka, ghwibeta kunilela mara sidatu.” ");
INSERT INTO kiz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro akan'jobhela, “hata kama ngajhilondekeghe kufwa ni bhebhe, nganikubelili lepi.” Ni bhanafunzi bhangi bhoha bhajobhili mebhu. ");
INSERT INTO kiz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baadaye Yesu akalota nabhu mahali pa pikutibhwa Gethsemane na abhajobhili bhanafunzi bha muene, “Mutamanyi apa bhwakati nilota okhu nikus'oma.” ");
INSERT INTO kiz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akan'tola Petro ni bhana bhabhele bha Zebedayo na akajhanda kwilombosya ni kwilamu. ");
INSERT INTO kiz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kisha akabhajobhela, “Roho jha nene ijhele ni malombosi mabhaha sana, hata kiasi kya kufwa. Musyalayi apa na mukeshayi pamonga nani.” ");
INSERT INTO kiz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akalota palongolo kidogo, akabina kifudifudi, ni kus'oma. Akajobha, “Tata ghwangu kama jhibhwesekana, kikombi ekhe nikijhepajhi. Isjhi kama kyanilonda nene, bali kyaghwilonda bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akabhalotela bhanafunzi na abhakolili bhagonili lugono na akan'jobhela Petro, “Kwandabha ya kiki mshindilu kukesha nani kwa lisaa limonga? ");
INSERT INTO kiz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mukeshajhi ni kus'oma kusudi musijhingili majaribuni. Roho i radhi, lakini mb'ele dhaifu.” ");
INSERT INTO kiz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akalota mara jha bhubhele ni kus'oma. akajobha, “Tata ghwangu, kama lijambo e'le libhwesya lepi kujhepukika na ni lazima ninywajhi kikombi ekhe, mapenzi ghwa jhobhi ghatimitajhi.” ");
INSERT INTO kiz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akakerebhuka kabhele ni kubhakholela bhagonili lugono, kwa kujha mihu gha bhene gha jhele masitu. ");
INSERT INTO kiz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kisha akabhaleka kabhele akabhoka. Akas'oma mara jha tatu akajobha malobhi ghalaghala. ");
INSERT INTO kiz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baadaye Yesu akabhalotela, “Bado mugonili tu ni kup'omoseka? Mulangayi, saa jhikaribili, na Mwana ghwa Adamu isalitibhwa mumabhokho gha bhenye dhambi. ");
INSERT INTO kiz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mujhumukayi tubhoki. Mulangayi, jhola jhaibetakunisaliti ikaribila.” ");
INSERT INTO kiz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bhwakati badop ilongela, Yuda mmonga kati jha bhala kumi ni bhabhele, akahida. Likundi libhaha lya bhanu lyafikiri pamonga naku likajhalihomela kwa bha bhaha bha makuhani ni bhaseya bha bhanu. Bhahidili ni mapanga ni mabonga. ");
INSERT INTO kiz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kabhele munu jhaalondejhe kun'saliti Yesu abhapelili ishara, akajobha, “Jhola jhanibetakumbusu, ndo muene. Mun'kamulayi.” ");
INSERT INTO kiz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mara ejhu akahida kwa Yesu ni kujobha, “Salamu, Mwalimu!” Akajhanda kumbusu. ");
INSERT INTO kiz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu akan'jobhela, “Ndongo bhangu, libhombajhi lela ambalyo likuletili.” Ndipo bhakahida, ni kun'sosolela Yesu fibhoko, ni kun'kamula. ");
INSERT INTO kiz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Langajhi, munu mmonga jha ajhele pamonga ni Yesu, anyosisi kibhokho kya muene akachomola bhupanga bhwake ni kun'tobha n'tumishi ghwa kuhani mbaha, ni kun'dumula mb'olokhot'o jhiakhe. ");
INSERT INTO kiz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ndipo Yesu akan'jobhela, kerebhusijhi bhupanga bhwa jhobhi paubhutolili, kwa kujha bhoha bha bhutumila bhupanga bhibetakujhangamisibhwa kwa bhupanga. ");
INSERT INTO kiz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mwidhanila nihotolalepi kun'kuta Tata ghwangu, nu muene akanitumila majeshi zaidi jha kumi na mabhele gha malaika? ");
INSERT INTO kiz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini basi jinsi jhelekhu majhandikhu ngaghabhwesili kutimisibhwa, efe ndo jhilondeka kuh'omela?” ");
INSERT INTO kiz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bhwakati obhu Yesu akabhajobhela bhumati, “Je! Muhidili ni mapanga ni mabonga kunikamula kama n'nyang'anyi? Khila ligono natamili mu lihekalu kumanyisya, na mkanikamuili lepi! ");
INSERT INTO kiz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini ghoha agha ghabhombiki ili majhandiku gha manabii ghatimilajhi.” Ndipo bhanafunzi bha muene bhakandeka ni kujumba. ");
INSERT INTO kiz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhala bhabhan'kamuili Yesu bhampeliki kwa Kayafa, Kuhani Mbaha, mahali ambapo bhaandishi ni bhaseya bhajhele bhakibhongeniye pamonga. ");
INSERT INTO kiz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lakini Petro amfwatili kumbele kwa patali hadi mu bhukumbi bhwa Kuhani Mbaha. Akajhingila mugati ni kutama pamonga ni bhalinzi alangajhi kyakibetakuh'omela. ");
INSERT INTO kiz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basi bhabhaha bha makuhani ni libaraza lyoha bhajhele bhilonda bhushahidi bhwa bhudesi dhidi jha Yesu, kusudi bhabhwesiajhi kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ingabhwa bhakitokisi mashahidi bhingi, Lakini bhakabhilepi sababu jhojhioha jhila. Lakini baadajhe mashahidi bhabhele bhakitokesya palongolo ");
INSERT INTO kiz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ni kujobha, “Munu ojho ajobhili, “Nibhwesya kulib'omola lihekalu lya K'yara ni kulijenga kabhele kwa magono madatu.” ");
INSERT INTO kiz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kuhani Mbaha akajhema ni kun'kota, “Gwibhwesyalepi kujibu? Abha bhikushuhudila kiki dhidi jha bhebhe?” ");
INSERT INTO kiz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu akatama kimya kuhani Mbaha akan'jobhela, “Kama K'yara kyaiishi, nikuamuru utubholajhi, kama bhebhe ndo Kristu, Mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akan'jibu, “Bhebhe ghwe muene ujobhili lijambo elu. Lakini ni kujobhela, kuh'omela henu ni kujhendelela ghwibetakumbona Mwana ghwa Adamu atamili, kibhokho kya kulia kyenye nghofu, na ihida mu mabhengu gha kunani.” ");
INSERT INTO kiz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndipo Kuhani Mbaha akararula maguanda gha muene ni kujobha, “Akufuiri! Je, twilonda kabhele bhushahidi bhwa kiki? Langayi, tajhari mup'eliki ikufuru. ");
INSERT INTO kiz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Je! Mwibhwasya kiki? bhakan'jibu ni kujobha, “Jhilondeka kufwa.” ");
INSERT INTO kiz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kisha bhakamfunyila mata kumihu ni kun'tobha ngumi, ni makofi kwa mabhokho gha bhene, ");
INSERT INTO kiz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ni kujobha, “Tulaghulilajhi, bhebhe Kristu. Niani akutobhili?” ");
INSERT INTO kiz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bhwakati obhu Petro ajhele atamili kwibhala mu bhukumbi, ni n'tumishi n'dala akandotela ni kujobha, “Bhebhe pia ukajhele pamonga ni Yesu ghwa Galilaya.” ");
INSERT INTO kiz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini akabela mbele jha bhene bhoha, akajobha, nimanyilepi khenu kyaukanijobhela.” ");
INSERT INTO kiz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bho alotili kwibhala pa ndiangu, n'tumishi jhongi n'dala bho ambwene akabhajobhela bhabhajhele apu kujha, “Munu ojho pia ajhele pamonga ni Yesu ghwa Nazareti.” ");
INSERT INTO kiz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Akabela kabhele kwa kulapa, “Nene nimmanyilepi munu ojho.” ");
INSERT INTO kiz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Muda bhufupi baadajhe bhala bhabhajhele bhajhemili karibu, bhakandotela ni kujobha ni Petro, “Kwa hakika bhebhe pia ndo mmonga bha muene, kwa kujha hata lafudhi jha jhobhi jhilasya.” ");
INSERT INTO kiz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndipo akajhanda kulaani ni kulapa, “Nene nimmanyilepi munu ojho,” na mara ejhu likongobha likabheka. ");
INSERT INTO kiz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petro akakhomboka malobhi ghaabholibhu ni Yesu, “Kabla jha likongobhe kubheka ghwibeta kunibela mara sidatu.” ");
INSERT INTO kiz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Muda ghwa lukhele bho bhufikili, bhabhaha bhoha bha makuhani ni bhaseya bhabhanu bhalili njama dhidi jha Yesu bhakabhajhi kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhamfungili, bhakan'dongosya, ni kumfikisya kwa Liwali Pilato. ");
INSERT INTO kiz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kisha bhwakati Yuda, ambajhe an'saliti, bho abhuene Yesu amalili kuhukumulibhwa, ajutili ni kukhelebhusya fipandi thelathini fya fedha kwa bhabhaha bha makuhani ni bhaseya, ");
INSERT INTO kiz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","na akajobha, “Nibhombili dhambi kwa kujhisaliti damu jhajhibelikujha ni hatia.” Lakini bhakajibu,” Jhikatuhusu kiki tete? ghalangajhi aghu ghwe muene.” ");
INSERT INTO kiz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kisha akafitagha pasi fila fipandi thelathini fya fedha mu lihekalu ni kubhoka ni kulota kwinionga muene. ");
INSERT INTO kiz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mbaha ghwa makuhani afitolili fela fipandi thelathini fya fedha ni kujobha, “Halali lepi kujhibheke fedha ejhe mu hazina, kwandabha ni gharama jha lilopa.” ");
INSERT INTO kiz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bhakajadiliana kwa pamonga ni fedha ikatumika kuhemelela n'gonda ghwa mfinyanzi ghwa kusiela bhageni. ");
INSERT INTO kiz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwa ndabha ejhe n'gonda obhu ghwibetakukutibhwa, “N'gonda ghwa lilopa” hadi lelu ejhe. ");
INSERT INTO kiz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kisha litobhi lela lya lyanenibhu ni nabii Yeremia lyatimili, kujobha, “Bhaletili fipandi thelathini fya fedha, gharama jha jhapangibhu ni bhanu bha Israeli kwa ndabha jha muene, ");
INSERT INTO kiz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na bhajhitumili kun'gonda ghwa mfinyanzi, kama Bwana kyaanjelekisi.” ");
INSERT INTO kiz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Henu Yesu ajhemili mbele jha liwali, ni liwali akan'kota, “Je! Bhebhe ndo mfalme ghwa Bhayahudi?” Yesu akan'jibu, “Bhebhe ghwijobha aghu.” Bjhebhe ghwijobha aghu.” ");
INSERT INTO kiz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini bho ashtakibhu ni bhabhaha bha makuhani ni bhaseya, ajibilepi khenu kyokioha khela. ");
INSERT INTO kiz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kisha Pilato akan'jobhela, “Ughapelikilepi mashitaka ghoha dhidi jha bhebhe?” ");
INSERT INTO kiz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Laki ni an'bilepi hata lilobhi limonga, hivyo, hivyo liwali akajha ni mshangao. ");
INSERT INTO kiz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","Henu mu sikukuu jhajhele desturi jha liwali kumfungula mfungwa mmonga jha achagulibhu ni bhumati. Bhwakati obhu bhajhele bhafungwa sugu kama vile Baraba. ");
INSERT INTO kiz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Henu bho bhakibhongeniye pamonga, Pilato abhakhotili, “Niani mwilonda tumbopolajhi kwa ndabha jha muenga?” Barabara au Yesu jhaikutibhwa Kristu? ");
INSERT INTO kiz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwandabha amalili kumanya kujha bhankamuili kwandabha jha chuki. ");
INSERT INTO kiz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bwakati itanama pa kiti kya hukumu, n'dalamunu akan'tumila lilobhi ni kujobha, “Usibhombi lijambo lyolioha lela kwa munu ojhu jhaabelikujha ni hatia. Kwanda yakiki nitesibhu muni hata lelu mu ndoto kwa ndabha jha muene. ");
INSERT INTO kiz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ndipo bhabaha bha makuhani ni bhaseya bhabhashawishi makutano bhan'somajhi Baraba, ni Yesu akomibhwajhi. ");
INSERT INTO kiz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Liwali abhakhotili, “Jholeku kati jha abha bhabhele mwilonda nene nibhalekelayi kwa muenga?” Bhoha bhakajibhu bhakajobha, “Baraba.” ");
INSERT INTO kiz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato akabhajobhela, Nin'kheta kiki Yesu jhaikutibhwa Kristu?” Bhoha bhakan'jibu, “Msulubisijhi.” ");
INSERT INTO kiz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ni muene akajobha, “Kwandabha jhakiki, likosa leleku lyaabhombili?” Lakini bhazidili kuwesya sauti hata panani muni, “Nsulubisiajhi.” ");
INSERT INTO kiz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Henu bhwakati Pilato bhoabhuene ibwesyalepi kubhomba kyokyoha khela, lakini badala jhiake vurugu sikajhanda, akaleta masi akasamba mabhoko gha muene embele jha bhumati, ni kujobha, “Nene nijhelepi ni hatia juu jha lilopa lya munu ojho jhaabeli kujha ni hatia. Mughalangajhi agha mwebhene.” ");
INSERT INTO kiz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bhanu bhoha bhakajobha, Damu jha muene ijhelayi panani pa tete ni bhana bhitu.” ");
INSERT INTO kiz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kisha akambopelela Baraba kwa bhene, lakini akan'tobha mijeredi Yesu ni kun'kabidhi kwa bhene kulota kusubibhwa. ");
INSERT INTO kiz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kisha askari bha liwali bhakan'tola Yesu mpaka Praitorio ni likundi libhaha lya maaskari bhoha bhalkabhonganika. ");
INSERT INTO kiz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakanfula nghobho sya muene ni kunfwatika likanzu lya rangi jhidung'u. ");
INSERT INTO kiz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kisha bhakatenesya litaji lya mifwa ni kulibheka panani mutu ghwa muene, na bhambekili lilasi ku kibhokho kya muene kya kuume. Bhapigili magoti mbele jha muene ni kun'kejeli, bhakajobha, aaaaa'Salamu, Mfalme ghwa Bhayahudi?” ");
INSERT INTO kiz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na bhamfunyili mate, na bhaletili lisali ni kuntobha kumutu. ");
INSERT INTO kiz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bwakati bhakan'keli bhakamfula likanzu lela ni kunfwatika nghobho sya muene, ni kundongosya kulota kun'sulubisya. ");
INSERT INTO kiz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bho bhapili kwibhala, bhambwene munu kuhomela Krene lihina lya muene Simeoni, ambajhe bhandasimisi kulota naku ili abhweajhwi kuupenda n'salaba ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bhabhafikiri mahali pa pikutibhwa Goligotha, maana jhiakhe, “Fuvu lya mutu.” ");
INSERT INTO kiz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bhampelili siki jhaichanyibhu ni nyongo anyuajhi. Lakini bho ajhibonjili abhwesilepi kunywa. ");
INSERT INTO kiz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bho bhikan'sulubisya, bhagabhene maguanda gha muene kwa kupigila kura. ");
INSERT INTO kiz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na bhakamata ni kundanga. ");
INSERT INTO kiz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani pa mutu ghwa muene bhambekili mashtaka dhidi jha muene ghakajha ghisomeka, “Ojho ndo Yesu, mfalme ghwa Bhayahudi.” ");
INSERT INTO kiz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bhanyang'anyi bhabhele bhakasulubibhwa pamonga ni muene, mmonga upande bhwa kulia ni jhongi bhwa kushoto. ");
INSERT INTO kiz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhala ambabho bhapeteghe bhakajhanda kun'dhiaki, bhakajha bhihugusya mitu ghya bhene ");
INSERT INTO kiz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ni kujobha, “Bhebhe ndo ulondeghe kuliharibu lihekalu ni kulijenga magono madatu, ukiokolayi ghwemuene! Kama kueli bhebhe ndo mwana ghwa K'yara, selelajhi pasi ubhokayi pa n'salaba apu!” ");
INSERT INTO kiz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mu hali jhelajhela bhabhaha bha makuhani bhakajha bhakan'kashifu, pamonga ni bhaandishi ni bhaseya ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aokwili bhangi, lakini ibhwesya lepi kwiokola muene. Muene ndo mfalme ghwa Bhayahudi. Na aselelajhi pasi kuhomela pa n'salaba, ndipo pa tubetakumwamini. ");
INSERT INTO kiz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","An'tumainili K'yara. Lekajhi K'yara an'hokolajhi henu kama ilonda, kwandabha ajobhili, “Nene na mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ni bhala bhanyang'anyi bhabhajhele bhasulubibhu pamonga ni muene pia bhakajobha malobhi gha kun'dhiaki. ");
INSERT INTO kiz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Henu kuhomela saa sita kwajhele ni ngisi mu nchi jhiola hadi saa tisa. ");
INSERT INTO kiz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bhojhifikiri saa tisa, Yesu akalela kwa sauiti mbaha, “Eloi, Eloi lamathabakithani?” akajhaimaanisya, “K'yara ghwangu K'yara ghwangu, kwandabha jha kiki undekili? ");
INSERT INTO kiz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bhwakati obhu bhaadhi jha bhe bhene bhabhajhemili pala bhap'heliki bhakajobha, “Akan'kuta Eliya.” ");
INSERT INTO kiz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mara mmonga bhene akajumba kutola sifongo ni kujhimemesya kinywaji kikali, akajibheka panani pa libehe ni kumpela akabhai kunywa. ");
INSERT INTO kiz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na bhene bha bhabakili bhakajobha, “Mundekajhi muene, tulotayi kama Eliya ibetakuhida kumwokola.” ");
INSERT INTO kiz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kisha Yesu akalela kabhele kwa sauti mbaha na akaibhosya roho jha muene. ");
INSERT INTO kiz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Langayi, Lipazia lya hekalu lyakachwiki sehemu sebhele kuh'omela panani hadi pasi. Ni ardhi jhikatetemeka ni miamba ikakayuka fipandi. ");
INSERT INTO kiz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Makaburi ghakagupuka, ni mibhele ghya bhatakatifu bhingi bhabhajhele bhaginili lugono bhafufulibhu. ");
INSERT INTO kiz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bhahomili mu makaburi baada jha bhfufuo bhwa muene, bhajhingili mji mtakatifu, na bhakabhonekana ni bhingi. ");
INSERT INTO kiz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Basi jhola akida ni bhala mbabho bhajele bhakandama Yesu bhabhwene litetemekhu ni mamabao ghaghajhele ghih'omela, bhamemesibhu ni bhuogha sana ni kujobha, “Bhukweli Ojho ajhele mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bhadala bhingi bhabhajhele bhakamfuata Yesu kuh'omela Galilaya ili kun'hudumila bhajhele pala bhilanga kwa patali. ");
INSERT INTO kiz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Miongoni mwa bhene Mariamu Magdarene, Mariamu nyinamunu Yakobo ni Joseph, ni mabhu ghwa bhana bha Zebedayo. ");
INSERT INTO kiz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bho jhifikiri kimihi ahidili munu tajiri kuh'omela Arimatahayo, jhaakutibhu Yusufu, ambajhe pia ajhele mwanafunzi ghwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Andotili Pilato ni kuus'oma mb'eele ghwayi. ");
INSERT INTO kiz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu abhutolili mb'ele akauk'onga nghobho jha sufi safi, ");
INSERT INTO kiz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na akaugoneka mu likaburi lipya lya muene lya alichongili mu muamba. Kisha akaviringisya liganga libhaha likagupika ndiangu bhwa likaburi na akabhoka. ");
INSERT INTO kiz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariamu Mgdalena ni Mariamu jhongi bhajhele pala bhatamili kulanga likaburi. ");
INSERT INTO kiz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ligono lya lyafwatili ambalyo lyajhele ligono baada jha maandalio, bhabhaha bha makuhani ni Mafarisayo bhakibhongeniye pamonga kwa Pilato. ");
INSERT INTO kiz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bhakan'jobhela, Bwana, twikhomboka kujha bhwakati jhola n'siobhi ajhele hai, ajobhili, “Baada jha ligono lya tatu ibetakufufuka kabhele.' ");
INSERT INTO kiz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Henu, laghisighi kujha likaburi lilendibhwajhi salama mpaka ligono lya tatu. Vinginevyo, bhanafunzi bha muene bhibhwesya kuhida kun'heja ni kujobha kwa bhanu, 'Afufuiki kuhoma kwa bhafu.' Ni bhudanganyifu bhwa mishu bhwibetakujha bhubhibhi kuliko bhola bhwa kubhuandelu.” ");
INSERT INTO kiz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato akabhajobhela, “Mulotayi bhalinzi. Mulotayi mukabhekayi hali jha bhusalama kama kyamwibhwesya.” ");
INSERT INTO kiz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Efyo bhakalota ni kubhomba likaburi kujha salama, liganga lyagongibhu mhuri ni kubheka bhalinzi. ");
INSERT INTO kiz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Baadaye kimihi ligono lya Sabato, lijobha bho libhahala kutolela ligono lya kuanza lya juma, Mariamu magadalena, nu jhola Mariamu jhongi bhahidili kulilola likaburi. ");
INSERT INTO kiz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Langayi kwa jhela ni tetemeko libhaha, kwa ndabha malaika ghwa Bwana aselili ni kuliviringisya liganga lela, kisha akalitamula. ");
INSERT INTO kiz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sura jha muene jhajhele kama jha bhumeme ni maguanda ghake ghajhele mabhalafu kama theluji. ");
INSERT INTO kiz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhalinzi bhala bhamemili ni hofu ni kujha kama bhafu. ");
INSERT INTO kiz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaika jhola akabhafafanulila bhala bhadala akajobha, “Musitili kwa maana nimanyili mukandonda Yesu, jhaasulubhibhu. ");
INSERT INTO kiz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ajhelepi aoa, lakini afufuiki kama kyaabhajobhili. Muhidayi mulolayi ambapo Bwana agonili. ");
INSERT INTO kiz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mulotajhi manyata mukabhajobhilayi bhanafunzi bha muene, 'Afufuiki kuhomela bhafu, langajhi abhalongolili Galilaya. Okhu ndo mwibetakumbona.' Langajhi nene nibhajobhili.” ");
INSERT INTO kiz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bhadala bhala bhakabhoka pa likaburi pala manyata bhakajha ni hofu ni furaha mbaha, na bhakajumba kubhajobhela bhanafunzi bha muene. ");
INSERT INTO kiz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Langayi Yesu akabhonana nabhu ni kujobha, “Salamu.” bhala bhadala bhahidili ni kukamula magolo gha muene, na kisha bhakamwabudu. ");
INSERT INTO kiz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kisha Yesu akabhajobhela, “musitili, mulotayi mukabhajobhelayi bhalongobhangu bhalongolelayi Galilaya. Okhu bhibetakunibhona. ");
INSERT INTO kiz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bhwakati bhola bhadala bhakajha bhilota, langayi baadhi jha bhalinzi bhalotili ku mjini ni kubhajobhela bhabhaha bha makuhani ni bhaseya mambo ghoha ghaghajhele ghahomili. ");
INSERT INTO kiz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na bhene makuhani bho bhabhonene ni bhaseya ni kulijadili lijambo elu pamonga nabhu, bhahomisi kiasi kibhaha kya hela kwa bhala askari ");
INSERT INTO kiz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ni kubhajobhela, “Mubhajobhilayi bhangi kujha, 'bhanafunzi bha Yesu bhahidili pakilu kuheja mb'ele ghwa Yesu bhwakati tete tugonili.' ");
INSERT INTO kiz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kama taarifa ejhe jhibetakunfikila liwali, tete twibeta kun'shawishi ni kubhabhosela muenga mashaka ghoha.” ");
INSERT INTO kiz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Henu bhala askari bhasitola hela sela ni kubhomba kama kyabhajhelekesibhu. Habari ejhe jhikajhenela sana kwa Bhajhahudi na jhijhele naha hadi lelu. ");
INSERT INTO kiz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lakini bhala mitume kumi na moja bhakalota Galilaya, pa kidonda pala pa abhajhelekesi. ");
INSERT INTO kiz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ni bhene bho bhambwene, bhakamwabudu. Lakini baadhi jha bhene bhakabhona shaka. ");
INSERT INTO kiz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akahida kwa bhene akabhajobhela, “Nipelibhu mamlaka ghoha paduniani ni kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Henu mulotajhi mukabhabhombayi malaika ghoha kujha bhanafunzi. Mubhabatisiajhi mu lihina lya Tata, ni la Muana, ni la Roho Mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mubhamanyisiajhi kughati mambo ghoha ghanibhaamuriri, Na langajhi, nene nijhele pamonga namu daima, hata mpaka mwisho ghwa dunia. ");
INSERT INTO kiz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Obho ndo mwanzo ghwa injili jha Yesu Kristo, mwana ghwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kama kya jhilembibhu ni nabii Isaya, “Langayi, nikan'tume n'jumbe ghwa nene mbele jha jhobhi, mmonga jhaibetakutayarisya njela jha bhebhe. ");
INSERT INTO kiz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sauti jha munu jhikuta ku nyika, “Mujhikamilisiayi njela jha Bwana; musinyosiayi njela sya muene”. ");
INSERT INTO kiz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana ahidili, ni kubatisya nyikani ni kuhubili bhubatisu bhwa toba kwa n'samaha ghwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nchi jhioha jha Yudea na bhanu bhoha bha Yerusalemu bhalotili kwa muene. Bhabatisibhu mu kih'olo Yordani, bhakajha bhibhungama dhambi sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana ajhele ifuala liguanda lya mangama gha ngamia ni nkanda ghwa ngozi mu nsana ghwa muene, na alijheghe nzige ni asali jha muda si. ");
INSERT INTO kiz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ahubiri ni kujobha, “Ajhele mmonga ihida badala jha nene na ajhe ni nghofo kuliko nene, na nijhelepi ni hadhi hata kujhinama pasi ni kukhonga mighojhi jha filatu fya muene. ");
INSERT INTO kiz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nene nabhabatisi kwa masi, lakini muene ibetakubhabatisya muenga kwa roho mtakatifu.” ");
INSERT INTO kiz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jhatokili mu magono aghu kujha Yesu ahidili kuh'oma Nazareti jha Galilaya na abatisibhu ni Yohana mu kih'olo Yordani. ");
INSERT INTO kiz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bhwakati Yesu ijhinuka kuh'oma mmasi, abhwene mbingu sigabhwanyiki bhwasi ni Roho akaselela pasi panani pa muene Kama njebha. ");
INSERT INTO kiz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni sauti jha h'omili kumbinguni “Bhebhe ndo mwanabhangu jha nikuganili. Nipendesibhu sana ni bhene.” ");
INSERT INTO kiz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kisha mara moja Roho akandalimisya kulita nyikani. ");
INSERT INTO kiz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ajhele kunyikani magono arobaini, akajha ijaribibhwa ni lisyetani. Ajhele pamonga ni bhanyama bha kun'situ ni malaika bhan'hudumili. ");
INSERT INTO kiz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Henu baada jha Yohana kukamulibhwa, Yesu akahida Galilaya kutangasya injili ya K'yara, ");
INSERT INTO kiz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akajobha, “Muda bhutimili, ni bhufalme bhwa K'yara bhukaribili. Mutubuajhi ni kujiamini injili”. ");
INSERT INTO kiz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na akajha ip'eta kando mu bahari jha Galilaya, ambwene Simoni ni Andrea ndongho ghwa Simoni bhakajha bhilo bha nkwabhu ghwa bhene mu bahari kwa kujha bhajhele bhavuvi. ");
INSERT INTO kiz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu akabhajobhela, “Muhidayi, munikesiajhi, na nibetakubhabhomba bhavuvi bha bhanu.” ");
INSERT INTO kiz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na mara jhe jhuejhu bhakaleka mikwabhu ghya bhene bhakankesya. ");
INSERT INTO kiz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bhwakati agendili patali kidogo, ambwene Yakobo mwana ghwa Zebedayo ni Yohana ndongo munu; Bhajhele mu bhuatu bhitengenesya nkuabhu. ");
INSERT INTO kiz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mara akabhakuta na bhene bhakandeka Dadi jha bhu Zebedayo mugati mu bhuatu ni bhatumishi bhabhakodibhu, bhakan'kesya. ");
INSERT INTO kiz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na bho bhafika kaperinaumu, ligono lya sabato Yesu akajhingila mu sinagogi ni kufundisya. ");
INSERT INTO kiz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bhakashangala tifundisu la muene, kwandabha ajhele akabhafundisya kama munu ambajhe ajhe ni mamlaka na siyo kama bhaandishi. ");
INSERT INTO kiz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bhwakati bhobhuobhu kwa jhele ni munu mu lisinagogi lya bhene jhaajhele ni roho jhibaya, na apigili kelele, ");
INSERT INTO kiz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akajobha, “Tujhe ni kiki kya kubhomba ni bhebhe Yesu ghwa Nazareti? Uhidili kutujhangamisya? Nikumanyili ghe niani. Bhebhe ghwe n'takatifu pekee ghwa k'yara!” ");
INSERT INTO kiz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu akankemela pepo ni kujobha, “Gudamayi ni ubhokayi mugati omu!” ");
INSERT INTO kiz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ni roho jhichafu jhambinisi pasi ni kubhoka kwa muene bhwakati ilela kwa sauti jha panani. ");
INSERT INTO kiz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na bhanu bhoha bhashangala bhakajhandana kukotana kila mmonga, “Elehe kiki? Lifundisu lipya lyalijhele ni mamlaka? Hata liamuru pepo bhabhi naghughuken'tii” ");
INSERT INTO kiz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ni habari kuhusu muene mara jha jhuejhu sileasambala khila mahali mugati mu mkoa bhuoa bhwa Galilaya. ");
INSERT INTO kiz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na mara jhejhuejhu baada jha kuh'oma kwibhala lya sinagogi bhajhingili munyumba mwa Simoni ni Andrea bhakajha ni Yakobo ni Yohana. ");
INSERT INTO kiz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Henu nkuwibhi ghwa Simoni ajhele agonili iluala bhutamu, mara jhejhuejhu bhakari jobhela Yesu habari sya muene. ");
INSERT INTO kiz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Efyo akahida, akarikamula kibhokho, ni kunj'hinula kunani; bhutemu bhukabhoka kwa muene, na akajhanda kubhahudumila. ");
INSERT INTO kiz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kimihi kekuekhu lijhobha limali kujhibhela, bhakanditela kwa muene bhoha bhabhejhele bhatamu, au bhahajhe ni mapepo. ");
INSERT INTO kiz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mji bhuoha bhakibhongeniye pamonga pa ndiangu. ");
INSERT INTO kiz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Abhapo ngisi bhingi bha bhajhe bhatamu bha bhutemu mbalimbali ni kubhosya pepo mingi bali anihusili lepi pepo kulongela kwandabha bhammanyili. ");
INSERT INTO kiz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ajhumuiki lukhela sana bhwakati jha jhele bado ngisi; abhokili akalota mahali pa faragha na as'omili okhu. ");
INSERT INTO kiz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni ni bhoha bhabhajhele pamonga ni muene bharikesisi. ");
INSERT INTO kiz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bhankabhili ni kun'jobhela, “khila mmonga ikulonda” ");
INSERT INTO kiz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Akabhejobhela, “Tubhoki mahali pangi, kwibhala mu miji jha jhizunguka, ili nibhwesiajhi kuhubili okhu pia. Ndio sababu nihidili hapa.” ");
INSERT INTO kiz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Akalota akajha ep'ete Galilaya jhioha, ihubiri mu masinagogi gha bhene ni kukemela pepo. ");
INSERT INTO kiz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jaajhele ni bhukoma mmonga akahida kwa muene. Akajha akan'sihi; Apigili magoti nikun'jobhela, “Kama ghwilonda, ghwibhwesya kunibhomba nijhiajhi kinofu.” ");
INSERT INTO kiz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Akajha sukumibhwa ni huruma, Yesu akanyosya kibhoko Kya muene ni kurikamula, akan'jobhla, “Nilonda ujhelayi ghwe n'nofu.” ");
INSERT INTO kiz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mara jhejhuejhu bhukoma bhukabhoka, na ambombili kujha kinofu. ");
INSERT INTO kiz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu akan'sihi sana ni kun'jobhela alotajhi mara moja, ");
INSERT INTO kiz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Akan'jobhela, “Hakikisia jhi ghwajo bha lepi litobhi kwa jhejhioha j'hola, lakini lotajhi, ukilasiajhi kwa kuhani, na uhomesiajhi dhabihu kwandabha jha bhutakaso ambabho Musa alaghisye, kama bhushuhuda kwa bhene.” ");
INSERT INTO kiz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini akalota ni kujha nda kumb'ola kila mmonga ni kujhenesya lilobhi zaidi hata Yesu abhwesi lepi kabhele kuj'hingila kun'jini kwa bhuhuru. Efyo atamili mahali pa faragha ni bhanu bha hidili kwa muene kuhomela kila mahali. ");
INSERT INTO kiz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bho akerebhiuki kaperinaumu baada jha magono madebe jhapelekiki kujha ajhele kunyumba. ");
INSERT INTO kiz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bhanu bhingi sana bhajhele bhakibhongeniye pala na jhajhelepi nafasi kabhele, jhela jhe pala pa ndiangu, ni Yesu ajobhili lilobhi kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kisha baadhi jha bhangu bhahidili kwa muene bhandetili munu jha apozili; Bhanu bhancheche bha mp'endili. ");
INSERT INTO kiz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bhwakati bhashindilu kunkaribila kwa ndabha jha bhumati bhwa bhanu, bhabhosili paa panani pa mahali pa ajhele. Na bhobhamalili kutobola lil'ende, bhaselisi kitanda ambakyo munu jha apozili agonili. ");
INSERT INTO kiz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bhoajhibhwene imani jha bhene Yesu akan'jobhela munu jha apozili, “mwanabhangu, dhambi sya jhobhilimalikusamehebhwa.” ");
INSERT INTO kiz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lakini baadhi jha bhaandishi bhala bha bhatamili pala bhakinong'uinu mu mioyo jha bhene, ");
INSERT INTO kiz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ibhwesyabhuli munu ojho kujobha naha? Ikufuru! Nani jhaibhwesya kusamehe dhambi isipokujha K'yara muene?” ");
INSERT INTO kiz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mara Yesu amanyili mu roho jha muene kyabhafikirileghe mu mioyo jha bhene. Kwandabha jha kiki mwifikirira aghu mu mioyo jha muenga? ");
INSERT INTO kiz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lelekhu lyepusi zaidi kujobha kwa munu jha apozili, 'Dhambi sya jhobhi sisamehibhu' au kujobha 'Jhemajhi, tolajhi kitanda kyajhobhi na ugendajhi?' ");
INSERT INTO kiz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lakini ili bhabhwesiajhi kumanya mwana ghwa Adamu ajhele ni mamlaka gha kusamehe dhambi paduniani, an'jobhili jhola j'ha apozili, ");
INSERT INTO kiz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikujobhela bhebhe, jhemayi, tolayi nkeka ghwa jhobhi, na ulajhi kunyumba kwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Akajhema ni mara jhejhuejhu akatola nkeka ghwa muene, na akalota kwibhala ku nyumba palongolo pa kila munu, Efyo bhanu bhoha bhashangele na bhampelili K'yara bhutukufu, na bhakajobha “kamwe tubhwajhilepi kubhona lijambo kama e'le.” ");
INSERT INTO kiz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Akalota kabhele kando jha nyanja, ni bhumati bhuoha bhwa bhanu bhakahida kwa muene, na akabhamanyisya. ");
INSERT INTO kiz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bho ib'eta akambona Lawi mwana ghwa Alfayo atamili pa sehemu jha kubhonganila kodi na akan'jobhela, “Nikisiayi.” Akajhema ni kun'kesiya. ");
INSERT INTO kiz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ni bhwakati Yesu ilya kyakulya munyumba jha Lawi, bhabhonganiya kodi bhingi ni bhanu bhabhajhele ni dhambi bhajhele bhilya ni Yesu ni bhanafunzi bha muene, kwandabha bhajhele bhingi ni bhene bhakan'kesiya. ");
INSERT INTO kiz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bhwakati bhaandishi, ambabho bhajhele Mafarisayo, bho bhabhuene Yesu elya ni bhanu bhenye dhambi ni bhabhonganiya kodi, akabhajobhela bhanafunzi bha muene, “Kwa ndabha j'hakiki ilya ni bhakusanya kodi ni bhanu bhabhaj'hele ni dhambi?” ");
INSERT INTO kiz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bhwakati Yesu ap'heliki aghu akabhajobhela,” Bhanu bhabhajhele ni afya mu mb'ele bhikandonda lepi tabibu; ni bhanu bhatamu tu ndo bhakandonda. Nahidi lepi kubhakuta bhanu bhabhajhele ni haki, lakini bhanu bhenye dhambi.” ");
INSERT INTO kiz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bhanafunzi bha Yohana ni Mafarisayo bhajhele bhifuanana. Ni baadhi j'ha bhanu bhakahida kwa muene ni kun'jobhela, “Kwa j'ha kiki bhanafunzi bha Yohana ni Mafarisayo bhifunga, lakini bhanafunzi bha jhobhi bhifunga lepi? ");
INSERT INTO kiz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akabhajobhela, “Je bhabhayele hudhuriri ku harusi bhibhuesya kufunga bhwakati bhwa harusi back ajhele pamonga nabhu? Kwa fyofyoha fela bwana harusi akajhiayi bado ajhele pamonga nabhu bhibhwesya lepi kufunga.” ");
INSERT INTO kiz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini magono ghibetakuhida bhwakati bwana harusi paibetakubhosibhwa kwa bhene, ni khila ligono elu bhene bhibeta kufunga. ");
INSERT INTO kiz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ajhelepi munu jha ihona kipandi kipya Kya nghobho mu liguanda lilala, na kubetakujha mpasuko bhubhibhi. ");
INSERT INTO kiz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ajhelepi munu jha isopa divai mpya mu firiba fya fichakele, Kama ndo naha divai ibetakujobha fimba ni fyoha fibhele divai ni firiba tubetakufuana. Badala j'hiake, bhakajhe divai mpya mu firiba fipya.” ");
INSERT INTO kiz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mu ligono lya sabato Yesu akap'eta mu baadhi jha mig'onda ni bhanafunzi bha muene bhakajhanda kutola baadhi jha masuka gha ngano. ");
INSERT INTO kiz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ni Mafarisayo bhakan'jobhela, “Langai, kwa ndabha ya kiki bhibhomba khenu kinyume ni sheria mu ligono lya Sabato?” ");
INSERT INTO kiz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Akabhajobhela, “Mwasomilepi khela kya akibhombili Daudi bho ajhele mu bhuhitaji ni njala —muene pamonga ni bhanu bhabhaj'hele pamonga nabhu? ");
INSERT INTO kiz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jinsi kyaalotili mu nyumba j'ha K'yara bhwakati Abiathari aj'he kuhani mbaha na akalya nkate ghwa ghubhakibhu palongolo — ambao j'ha jhele kinyume kya sheria kwa munu jhejhioha jhola kulya isipokujha makuhani na abhapelili hata baadhi jha bhala bhabhajhe pamonga nakhu?” ");
INSERT INTO kiz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu akajobha, “Sabato jhabhombiki kwa ndabha j'ha mwanadamu, siyo mwanadamu kwa ndabha jha Sabato. ");
INSERT INTO kiz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Henu, Mwana ghwa Adamu ndo Bwana, hata kwa Sabato.” ");
INSERT INTO kiz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ni kabhele akajhingila mugati mu lisinagogi na m'ola jaajhele ni munu jhaapoozili kibhoko. ");
INSERT INTO kiz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baadhi jha bhanu bhankeseleleghe kwa bhuharibifu kulola Kama ibetakujobha ligono lya Sabato ili kwamba bhan'shtakiajhi. ");
INSERT INTO kiz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu akan'jobhela munu jha apoozili kibhokho,” Jhinukayi na ujhemayi katikati jha bhumati obho.” ");
INSERT INTO kiz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kisha akabhajobhela bhanu, “Je ni halali kubhomba khenu kinofu ligono lya Sabato au kubhomba ghaghabelili kuj'ha gha haki; kuokola maisha, au kukoma?” Lakini bhakabakila kinunu. ");
INSERT INTO kiz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Akabhalanga kwa ligoga, akajhaihuzunika kwa ndabha j'ha bhubomolaji bhwa mioyo ghyabhene na akan'jobhela munu jhola, “Nyosiajhi kibhokho Kya jhobhi”. Akabhunyoosya ni Yesu akamponesya kibhokho Kya muene. ");
INSERT INTO kiz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mafarisayo bhakalota kwibhala na mara bhakabhomba njama pamonga ni Maherode dhidi jha muene ili kun'koma. ");
INSERT INTO kiz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kisha Yesu pamonga ni bhanafunzi bha muene, bhakalota kubahari, ni bhumati mbaha bhwa bhanu ghwabhakesisi kuh'omela Galilaya ni Bhuyahudi ");
INSERT INTO kiz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ni kuh'omela Yerusalemu ni kuh'omela Idumaya ni palongolo jha Yorodani hi jirani jha Tiro ni Sidoni, bhumati mbaha, bhobhup'eliki khila khenu Kya abhombekai, bhahidili kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na abhajobhili bhanafunzi bha muene kuandala bhuatu bhudebe kwa ndabha jha bhumati ili kwamba bhasihidi kun'komanila. ");
INSERT INTO kiz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kwa kujha aponisi bhingi, ili kila munu jha ajhele ni malombosi ajhele ni shauku jha kun'fikila ili an'kamulayi. ");
INSERT INTO kiz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Popoha pala roho bhachafu bho bhikambona, bhabinili pasi mbele jha muene ni kuleta na bhajobhili, “Bhebhe ndo Mwana ghwa k'yara”. ");
INSERT INTO kiz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Akabhakuta kwa msisitizo bhasibhombi amanyikanikayi. ");
INSERT INTO kiz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Akalota panani pa kid'onda, na akabhakuta bha abhalondeghe, na bhakabhoka. ");
INSERT INTO kiz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akakabhachagula kumi ni bhabhele (abhakutili mitume), ili. kwamba bhajhelayi pamonga ni muene na abhwesiaghe kubhatuma kuhubiri, ");
INSERT INTO kiz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni kujha ni mamlaka gha kubhosya mapepo. ");
INSERT INTO kiz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na akabhachagula kumi ni bhabhele: Simoni, j'haampelili lihina lya Petro, ");
INSERT INTO kiz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo mwana ghwa Zebedayo, ni Yohana ndongo munu Yakobo, j'haampelili lihina lya Bonagesi, abhu ndo bhana bha ngurumo, ");
INSERT INTO kiz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Andrea, Filipo, Bartholomayo, Mathayo, Tomaso, Yakobo mwana wa Alfayo, Thadayo, Simoni Mkananayo ");
INSERT INTO kiz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yuda Iskariote, ambaj'he an'saliti. ");
INSERT INTO kiz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kisha akalota kunyumba, ni bhumati bhwa bhanu bhakahida pamonga kabhele, hata bhasibhwesi kulya kabhele hata nkate. ");
INSERT INTO kiz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Familia jha muene bho bhapeliki habari ejhu bhakalota kun'kamula, kwani bhajobhili, “Arukibhu ni kuhala”. ");
INSERT INTO kiz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bhaandishi bhabhahidili kuh'oma Yerusalemu bhajobhili, “Apagewe ni Beelzebuli,” ni, “Kwan'tawala ghwa mapepo ibhosya mapepo”. ");
INSERT INTO kiz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu akabhakuta kwa muene ni kujobha nabhu kwa mifuanu, “Jinsi gani lisyetani kibhwesiayi kumbosya lisyetani? ");
INSERT INTO kiz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kama bhufalme bhugawanyiki bhwene, bhufalme obhu ghwibhwesya lepi kujhema. ");
INSERT INTO kiz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kama nyumba jhigabhwanyiki jhiene, jhibhwesya lepi kujhema. ");
INSERT INTO kiz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kama lisyetani libeta kujhinuka kinyume kyake liene, libhwesya lepi kujhema, na kubetakujha lifikili mwisho bhwake. ");
INSERT INTO kiz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lakini ajhelepi hata mmonga jhaibhwesya kujhingila mugati mu nyumba jha munu mwenye nghofu ni kuheja fenu fya muene bila kunfunga mwenye nghofu hoti, na Kisha ni kubhonganiya Kya kijhele mu nyumba. ");
INSERT INTO kiz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bhukweli nikabhajobhela, dhambi syoha. sya bhana bha bhanu sibetakusamehebhwa, pamonga ni kufufulibhwa ambasyo bhitamka, ");
INSERT INTO kiz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lakini jhejhioha jhaibeta kun'situ Roho Mtakatifu ibetalepi kusamehebhwa kamwe bali ajhele ni hatia jha dhambi jha milele”. ");
INSERT INTO kiz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu alijobhili ele kwa ndabha bhajobhaghe, “Ajhe ni roho bhachafu”. ");
INSERT INTO kiz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kisha nyinamunu ni bhalongomunu bhakahida ni kujhema kwibhala. Bhakan'tuma munu kun'kuta. ");
INSERT INTO kiz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ni bhumati bhwa bhanu bhwabhujhele bhutamili karibu nu muene bhakan'jobhela, “Nyinu aku ni bhalongobhu bhajhe kwibhala, na bhikulonda bhebhe”. ");
INSERT INTO kiz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Akabhajibu, “Niani nyina bhangu ni ndongobhangu?” ");
INSERT INTO kiz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akabhalanga bhabhatamili bhan'syonguiki ni kujobha, Lakini, Langayi, abha ndo bha nyina bhangu ni bhalongobhangu! ");
INSERT INTO kiz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jhejhioha j'haibhomba mapenzi gha K'yara, munu oj'hu ndo ndongobhangu, ndo nd'ombo bhangu, ni nyina bhangu”. ");
INSERT INTO kiz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kabhele ajhandili kumanyisya kandokando jha bahari. Ni bhumati mbaha bhwakibhongeniye bhwanzunguiki bhukajhingila mugati mu bhuatu mu bahari, ni kutama. Bhumati bhuoha bhwajhele pembeni mu bahari bhufukweni. ");
INSERT INTO kiz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ni kubhafundisya mambo mingi kwa mifuanu, ni kujobha kwa bhene kwa mafundisu ghake. ");
INSERT INTO kiz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Mup'elekesiajhi, mpanzi alotili kupanda. ");
INSERT INTO kiz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bhoipanda, baadhi jha mbeyu syabinili munjela, ni fidege fikahida fikalya. ");
INSERT INTO kiz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeyu senge syabinili mu muamba, ambako kwa jhelepi ni bhud'opi bhwingi. Mara syajhomili, kwa ndabha syajhelepi ni bhud'opi bhwa kutosya. ");
INSERT INTO kiz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lakini lijobha bho lih'omili, syajhomili, na kwandabha syajhelepi ni mizizi, syajhomili. ");
INSERT INTO kiz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu senge syabinili katikati jha mifwa. Mifwa ghyakhotili ghikasizuila, na syahoguili lepi matunda ghoghoha ghala ");
INSERT INTO kiz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbeyu s'enge syabinili mu bhud'opi bhunofu na syahogwili matunda bhwakati syahogwili ni kujhongeseka, s'enge syahoghwili mara thelathini zaidi, ni s'enge sitini, ni s'enge mia”. ");
INSERT INTO kiz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na akajobha, “Jhejhioha jha ajhele ni mbolokoto na apelekayi!” ");
INSERT INTO kiz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu bho ajhemuene, bhala bhabhajhe karibu nakhu ni bhala kumi ni bhabhele bhakan'kotili kuhusu mifuano. ");
INSERT INTO kiz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akabhajobha kwa bhene, “Kwa muenga mupelibhu siri sya bhufalme bhwa K'yara. Lakini kwa bhajhele kwibhala khila khenu mifuanu, ");
INSERT INTO kiz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ili bhakalangajhi, ndo bhilola, lakini bhilola lepi, ni kwa ejhu pa bhip'eleka, lakini bhijhelebhwa lepi, amasivo bhabhayeli ni K'yara ngaabhasamee.” ");
INSERT INTO kiz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na akajobha kwa bhene,” Je mwijhelebhwa lepi mifuano obho? Mwibeta mu bhuli mifuano ghenge? ");
INSERT INTO kiz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpanzi apandili lilobhi. ");
INSERT INTO kiz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Baadhi ndo bhaka bhabhabinili palubhafu mu nj'hela, mahali lilobhi pa lipandibhu. Na bho bhalip'eliki, mara lisyetani likahida ni kulotela lilobhi ambalyo lapandibhu mugati mwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na baadhi ndo bhala bha bhapandibhu panani pa muamba, ambabho pabhakalipheleka lilobhi, manyata bhakalipokela kwa furaha. ");
INSERT INTO kiz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na bhajhelepi ni mizizi ghyoghyoha mugati mwa bhene, lakini bhuvumilivu kwa muda bhufupi. Halafu tabu ni malombosi pafihida kwa ndabha jha lilobhi, mara bhikwikungufula. ");
INSERT INTO kiz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na bhangi ndo bhala bhanandibhu mu mifwa, bha kalip'eleka lilobhi, ");
INSERT INTO kiz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lakini malombosi gha dunia, bhusiobhi bhwa mali, ni tamaa sya mambo ghangi ghakabhajhingila ni kulijhoghaniya lilobhi na lisindwa kuhogola matunda. ");
INSERT INTO kiz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kisha bhajhele bhala ambabho bhapandibhu mu bhud'opi bhunofu. Bhikalipeleka lilobhi nikulipokela ni kuhogola matunda: baadhi thelathini, ni baadhi sitini, ni baadhi miamoja.” ");
INSERT INTO kiz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu akabhajobhela,”Je huwa ghwilela taa mugati mu nyumba ni kujhibheka basi pa kind'onga au pasi pa kitanda? Jhiletibhwa mugati ni kubhekibhwa panani pa kiango. ");
INSERT INTO kiz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kwa kujha kyalepi khenu kyokyoha kyakikifighili ambakyo kibetalepi kumanyikana na jhijhelepi siri ambayo jhibetalepi kubhakibhwa bhwasi. ");
INSERT INTO kiz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Akajhelayi mwenye mb'olokoto na apelekajhi!” ");
INSERT INTO kiz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akabhajobhela,”Mujhelayi makini kwa khela kya mukakip'eleka, kwa kujha kup'emu kya mwip'ema, ndo kyamwibeta kup'emibhwa na jhibetakujhongesibhwa kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwandabha muene jha ajhe nakhu ibetakukabha zaidi, na jhola jha abelili kujha nakhu ibetakunyakibhwa ni fela fidebe fya aj'he nakhu.” ");
INSERT INTO kiz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na akajobha, “Bhufalme bhwa K'yara bhufananisibhu ni munu jha apandili mbeyu mu bhud'opi. ");
INSERT INTO kiz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bho alili pakilu ni kujhumuka lukhela, ni mbeyu sikachipula ni kukhola ingawa amanyilepi Kya jhitokili. ");
INSERT INTO kiz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dunia jhipisya mbeyu jhiene; kwanza matondo, halafu maua, halafu mbeyu syasikomele. ");
INSERT INTO kiz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ni bhwakati mbeyu pa jhibetakujha jhifundili mara jhipelekibhwa mundu, kwa ndabha mavuno ghawadili.” ");
INSERT INTO kiz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na akajobha, “tubhufananisiajhi bhufalme bhwa K'yara ni khenu gani, au titumilajhi mfuanu bholoki kubhujhelesela? ");
INSERT INTO kiz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ni Kama mbeyu jha haradali, ambapo bho jhipandibhu jhidusu kuliko mbeyu sioha paduniani. ");
INSERT INTO kiz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hata, bhwakati jhipandibhu, j'hikhola ni kujha mbaha zaidi jha mimea ghioha ghya pa bustani, na jhibhomba matafi mabhaha hata fidege fya kumbinguni fibhwesya kubhomba fisuisi fya kubhene mu kivuli lyake.” ");
INSERT INTO kiz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kwa mifuanu mingi jhafundisi na ajobhili lilobhi kwa bhene Kwa kadiri kyabhabhwesili kujhelebhwa, ");
INSERT INTO kiz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","na ajobhili lepi nabhu bila mifano. Lakini bhwakati bho ajhele muene, akabhajhelesya kila khenu bhanafunzi bha muene. ");
INSERT INTO kiz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mu ligono e'lu, bhwakati bhwa kimihi bho bhufikili kwa bhene, “Tubhoki lubhafu longi”. ");
INSERT INTO kiz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hivyo bhakabhuleka bhumati, bhakan'tola Yesu, bhwakati obhu bhajhele mugati mu bhuatu, Miatu jhenge jhajhele pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ni mpongo bhukali bhwa linyegha bhukajha bhwijhingisya masi mu bhuatu ni bhuatu tayari bhwa melili masi. ");
INSERT INTO kiz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lakini Yesu muene ajhele mu shetri, agonili mu mto, bhakan'jobhela, bhakajhanda kun'jhumusiya, “Mwalimu, ghwijali lepi tete twifwa?” ");
INSERT INTO kiz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na akajhumuka akabhukemela mp'ongo ni kujhijobhela bahari, “' J'higudamayi amani”. Mp'ongo ukagudama, na kwajhele ni bhutulivu ghubhakibhu. ");
INSERT INTO kiz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na akabhajobhela, “Kwa ndabha jha kiki mwitila? Je mjhelepi ni imani bado?” ");
INSERT INTO kiz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bhajhingilibhu ni hofu mbaha mugati mwa bhene na bhakajobhesana bhene kwa bhene, “Ojho niani kabhele, kwa ndabha hata mp'ongo ghwa bhahari bhukan'tii?”. ");
INSERT INTO kiz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bhakahidili hadi lubhafu l'ongi lwa bahari mu mkoa ghwa Gerasi ");
INSERT INTO kiz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ni ghafla bhwakati Yesu ipita mugati mu bhuatu, munu jhaajhele ni roho chafu akahida kwa muene kuhomela kumakaburi. ");
INSERT INTO kiz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munu ojhu atameghe ku makaburi. Ajhelepi jhaabhwesili kunsifila, ajhelepi hata ku minyororo. ");
INSERT INTO kiz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akongibhu bhwakati bhwingi ni p'engu ni minyororo. Ahidumuili minyororo ni p'engu syake syadumuiki. Ajhelepi hata mmonga jha ajhe ni nghofu sya kun'shinda. ");
INSERT INTO kiz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pakilu ni pamusi ajhele kumakaburi ni kufidonda alelili ni kwidumula muene kwa maganga makali. ");
INSERT INTO kiz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bho ambwene Yesu kwa patali ojumbili kwa muene ni kujhinama mbele jha muene. ");
INSERT INTO kiz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Al'elili kwa sauti mbaha, “Ghwilonda nikubhombilayi kiki, Yesu, Mwana ghwa K'yara j'haajhele kunani Sana? Nikus'okha kwa K'yara muene usin'tesi.” ");
INSERT INTO kiz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kwa kujha amali kun'jobhela, “Umbokajhi bhebhe roho n'chafu.” ");
INSERT INTO kiz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nu muene akan'kota, “Lihina lya bhebhe niani?” Nu muene akan'jibu, “Lihina lya nene ni Legion, kwa kujha tujhe twebhingi.” ");
INSERT INTO kiz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akan'sihi kabhele asibhap'eleki kwibhala ku mkoa. ");
INSERT INTO kiz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Henu likundi libhaha lya maghorobhi likajhele lilasibhwa panani pa kid'onda, ");
INSERT INTO kiz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","naghu ghakan'sihi ni kujobha, “Tutumajhi ku maghorobhi; tujhingilayi mugati mwa bhene.” ");
INSERT INTO kiz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Efyo akagharuhusu; roho bhachafu bhakabhoka kulota ku maghorobhi, naghu ghakajumba pasi pa kid'onda mpaka mu masi ni karibila maghorobhi elfu mbili ghajiembili mu bahari. ");
INSERT INTO kiz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nibhala bhabhajhele bhikaghalesya maghorobhi bhakajumba ni kupisya taarifa jha kyah'omili mu mji ni mundu. Ndipo bhanu bhingi bhakahoma kulota kulola kya kutokili. ");
INSERT INTO kiz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ndipo bhakahida kwa Yesu na bhambwene munu jha apagewe ni pepo— ajhele ni jeshi — atamili pasi, afwekibhu, na ajhele ni luhala lwa muene timamu, na bhakatila. ");
INSERT INTO kiz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhala bhabhabhuene kya kyah'omili kwa jha apagewe ni pepo bhabhajobhili Kya kih'omili kwa bhene ni pia kuhusu maghorobhi. ");
INSERT INTO kiz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nabhu bhakajhanda kun'sihi abhokayi mu mkoa ghwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na bhoijhingila mubhwatu, munu jha apagewe ni mapepo an'sokili bhalotayi pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini ambelekelili, lakini an'jobhili, “Lotajhi kunyumba jha jhobhi ni kwa bhanu bha j'hobhi, na ubhajobhilayi akibhombili Bwana, ni rehema jha akup'elili.” ");
INSERT INTO kiz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Efyu akalota ni kujhanda kutangasya mambo mabhaha ambagho Yesu aghabhombili kwa muene mu Dekapoli, na khila mmonga ashangele. ");
INSERT INTO kiz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na bhwakati Yesu ilobhoka kabhele lubhafu lwa bhubhele, mugati mu bhuatu, bhumati mbaha bhwa syonguiki kumbonganila, bho ajhele kando jha bahari. ");
INSERT INTO kiz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na mmonga ndongosi ghwa sinagogi jhaakutibhweghe Yairo, ahidili, na bho ambwene, abinili mu magolo gha muene. ");
INSERT INTO kiz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akan'soka zaidi ni zaidi, akajobha, “Mwalibhangu n'debe mkaribishaji kufwa. Nikus'oka uhidayi na ubhekayi mabhokho gha jhobhi panani pa muene ili abhwesiayi afya jha kutama au kuishi.” ");
INSERT INTO kiz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Efyo akalota pamonga naku, ni bhumati mbaha bhwan'kesisi nabhu bhandondamili karibu bhakajha bhan'syonguiki ");
INSERT INTO kiz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kwa jhele ni n'dala ambajhe lilopa lya muene kyah'omili kwa miaka kumi na mibhele. ");
INSERT INTO kiz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atesiki fya kutosha kwa matibabu mingi na atumili khila khenu kya ajhele nakhu. Hata efyu asaidiki lepi kwa kyokyoha khela, lakini badala jhiake ajhongesiki kujha ni hali jhibhibhi. ");
INSERT INTO kiz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ap'eliki habari kuhusu Yesu. Hivyo akahida kunyuma jha muene bhwakati igenda mu bhumati, nu muene aligusili liguanda lya muene. ");
INSERT INTO kiz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kwa kujha ajobhili, “kama nighakamuili maguanda gha muene tu, nibetakujha n'sima.” ");
INSERT INTO kiz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bho arikamuili kuh'oma lilopa kabhele kwa lekili, na akip'eliki mu mb'ele ghwa muene kujha aponisibhu kuh'omela mu malombosi gha muene. ");
INSERT INTO kiz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ni ghafla Yesu agunduili mu mb'ele ghwa muene kujha nghofu lip'onguiki. Na ageuke khoni ni khoni ni mu bhumati bhwa bhanu ni kukhota, “Niani jha akamuili liguanda lya nene?” ");
INSERT INTO kiz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bhanafunzi bha muene bhakan'jobhela, “Ulolili bhumati obho bhukulundamili, bhukulundamili, ni bhabhe ghwi jobha, Niani akukamuili?”' ");
INSERT INTO kiz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu akalenga khoni ni khoni ili ambonayi jha abhombili ele. ");
INSERT INTO kiz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","N'dala, amanyili kya kih'omili kwa muene atilili ni kutetemeka. Ahidili ni kubina chini mbele jha muene ni kun'jobhela bhukweli bhuoha. ");
INSERT INTO kiz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Akajobha kwa muene “Mwalibhangu, imani jha jhobhi jhikubhombili ujhiaghe ghwa n'sima. Ujhendelelayi kujha ni imani na uponyisibhwayi matamu gha jhobhi ghoha” ");
INSERT INTO kiz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bho ilongela, baadhi jha jha bhanu bhahidili kuh'oma kwa te ndongosi ghwa sinagogi, bhakajha bhijobha “Mwalibhu afuili. Kwandabha jhakiki ghwijhendelela ku ndombosya mwalimu?” ");
INSERT INTO kiz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lakini Yesu bho ap'eliki kya bhilongela, akan'jobhela ndo ngosi ghwa sinagogi, “Usitili. Aminiayi tu” ");
INSERT INTO kiz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Anduhuswili lepi j'hejhioha jhola kulongosana naku, isipokujha Petro, Yakobo, ni Yohana, ndongu munu Yakobo. ");
INSERT INTO kiz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bhakahida kunyumba kwa kiongozi ghwa sinagogi nu muene akabhona fuju, kulela kwingi ni kuombolesya. ");
INSERT INTO kiz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bho ajhingili mugati munyumba, akabhajobhela “Kwandabha jha kiki mwisikitika na kwandabha jha kiki mwilela? Muana afuili lepi bali agonili.” ");
INSERT INTO kiz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bhakan'heka, lakini muene, akabhahomesya bhoha kwibhala, akan'tola dadi ghwa muene ni mabhu ni bhala bhabhajhe pamonga nakhu, ni kujhingila mugati mwa ajhele muana. ");
INSERT INTO kiz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aukamuili kibhoko kya muana ni kun'jobhela, “Talitha koum,” ambayo ni kujobha, “Mmenja n'debe, nikujobhela, jhumukai.” ");
INSERT INTO kiz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ghafla muana akajhumuka ni kugenda (kwandabha ajhele ni miaka kumi ni mibhele). Ni ghafla bhakamuliki ni mshangao mbaha. ");
INSERT INTO kiz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Akabhaamuru kwa nghofo kujha ajhelepi jhejhioha jhailondeka kumanya kuhusu ele. Na abhajbhili bhampelayi m'meja yola kyakulya. ");
INSERT INTO kiz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na akabhoka apu ni kulota kumjini kwa bhene ni bhanafunzi bha muene bhakan'kesya. ");
INSERT INTO kiz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabato bho jhifikili ajhandili kufundisya mu sinagogi. Bhanu bhingi bhampelekisi na bhasyangasibhu. Bhakajobha “Akabhili ndaku mafundisu agha?” “Ndo hekima jhelekhu jha apelibhu?” “Ibhomba bhuli miujiza eghe kwa mabhoko gha muene?” ");
INSERT INTO kiz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Je ojho si ndo jhola selemala, mwana ghwa Mariamu ni ndongo bhabhi bha Yakobo, Yose, Yuda ni Simoni? Je, bhal'omb'o munu si ndo bhitama bahapa pamonga ni tete?” Na bhafurahisibhu lepi ni Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu akabhajobhela, “Nabii idula lepi heshima, isipokujha mu mji bhwa muene ni mwa bhalongo munu ni munyumba jha muene.” ");
INSERT INTO kiz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Abhwesilepi kubhomba miujiza Apu, ila akabhabhekela bhatamu bhaolebe mabhoko kumutu bhakaponyesibhwa. ");
INSERT INTO kiz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Asyangesibhu sana kwandabha jha kutokuamini kwa bhene. Kisha akafigendela fejiji fya jirani fikumanyisya. ");
INSERT INTO kiz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akabhakuta bhala bhanafunzi kumi na bhabhele akajha nela kubhalaghisya bhabhele bhabhele. Abhapelili mamlaka juu jha pepo bhabhibhi, ");
INSERT INTO kiz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ni kubhaamuru bhasiloli kyokyohakila isipokujha ndonga tu. Bhasitoli nkate, bhwala nkoba, bhwala fedha, mu kibindu; ");
INSERT INTO kiz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lakini bhafwalajhi filatu na siyo makanzu mabhele. ");
INSERT INTO kiz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na akabhajobhela, “Nyumba jhojhioha jha mwibeta kujhingila, mutamayi apu mpaka pa mwibeta kubhoka. ");
INSERT INTO kiz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na mji bhobhuoha bhwa bhabelili kubhapokela bhwala kubhap'elekesya mu bhokai kwa bhene, mukung'undai mafumbi gha magolo ghinu, ijhiayi bhushuhuda kwa bhene.” ");
INSERT INTO kiz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na bhene bhakalota kutangasya bhanu bhatubuajhi ni kuleka dhambi sya bhene. ");
INSERT INTO kiz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhabhabhosili pepo bhingi, na bhabhabakili bhatamu mafuta hi kubhaponyesya. ");
INSERT INTO kiz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mfalme Herode bho ap'eliki aghu, kwa kujha lihina lya Yesu lyamalili kumanyikana sana. Baadhi bhakajobha, “Yohana mbatizaji afufuiki ni kwa ndabha ej'he nghofu jha miujiza jhibhomba mbombo mugati mwa muene.” ");
INSERT INTO kiz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baadhi jha bhene bhakajobha, “Ojho ndo Eliya,” bado bhangi bhakajobha, “Ojho ndo nabii, kama mmonga ghwa bhala manabii bha muandi.” ");
INSERT INTO kiz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lakini Herode bho ap'eliki agha akajobha, “Yohana, jhanin'dumuili mutu afufulibhu.” ");
INSERT INTO kiz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maana Herode muene alaghisi Yohana akamulibhwayi na amfungili mu ligereza kwandabha jha Herodia (n'dala ghwa kakajhake Filipo) kwa ndabha muene ajhele an'gegili. ");
INSERT INTO kiz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwandabha Yohana an'jobhili Herode, “Halali lepi kun'gega n'dala ghwa kakajhaku.” ");
INSERT INTO kiz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lakini Herodia ajhandili kun'dadila kun'koma lakini abhwesi lepi, ");
INSERT INTO kiz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","maana Herode an'tilili Yohana; amanyili kujha n'kolo haki na n'takatifu, na andekili kinofu. Na bhoajhendelili kump'elekesya ahuzuniki sana, lakini ah'obhelili kump'elekesya. ");
INSERT INTO kiz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hata bho nghufikili bhwakati muafaka jhifikili ni kukaribila ligono lya kuhogoleka Herode akabhajhandalila maofisa bha muene karamu, ni makamanda ni bhalongosi bha Galilaya. ");
INSERT INTO kiz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndipo mwali ghwa Herodia akajhingila ni kukina mbele jha bhene, akamfurahisya Herode ni bhageni bhabhatamili bhwakati bhwa kyakulya kya kimihi. Ndipo mfalme akan'jobhela mwali, “Nis'okajhi kyokyoha kya ghwilonda nani nikupela.” ");
INSERT INTO kiz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akandapila ni kujobha, kyokyoha kyaghwibeta kunis'oma, nibetakupela, hata nusu jha bhufalme bhuangu.” ");
INSERT INTO kiz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Akah'oma kwibhala akan'kota nyinamunu, “Nis'okajhi kiki?” Akajobha, “Mutu ghwa Yohana Mbatisiaji.” ");
INSERT INTO kiz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na mara jhejhuejhu akajhingila kwa mfalme akajhanda kujobha, “Nilonda nipelayi mu sahani, mutu ghwa Yohana Mbatisiji.” ");
INSERT INTO kiz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mfalme asikitishibhu sana, lakini kwa ndabha jha kiapo kya muene ni kwa ndabha jha bhahesya abhwesilepi kumbelekelela liombi lya muene. ");
INSERT INTO kiz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Efyo, mfalme akabhatuma askari Kati jha bhalinzi bha muene ni kubhalaghisya kulota kundetela mutu ghwa Yohana. Mlinzi akalota kun'dumula mutu kwa ajhele mu kifungu. ");
INSERT INTO kiz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akaghuleta mutu ghwa muene mu sahani ni kumpela mwali, ni mwali akampela nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na bhanafunzi bha muene bho muene bho bhapheliki aghu, bhakalota kuulota mb'ele ghwa muene bhakal'ota kuusiela kumakaburi. ");
INSERT INTO kiz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ni mitume, bhabhonganiki pamonga mb'ele jha Yesu bhakamb'ola ghoha gha bhabhombili ni ghabhafundisi. ");
INSERT INTO kiz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu muene akabhajobhela, “Muhidayi mwebhene mahali pa faragha na tup'omosekajhi kwa muda.” Bhanu bhingi bhakajha bhihhida ni kubhoka, hata bhakabhili lepi nafasi jha kulya. ");
INSERT INTO kiz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kabhele bhakakuela mashua bhakalota mahali pa faragha bhene. ");
INSERT INTO kiz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini bhabhabhuene bhibhomba ni bhingi bhakabhamanya kwa pamonga bhajumbili kwa magolo kuh'omela miji ghioha, nabhu bhakafika kabla jha bhene. ");
INSERT INTO kiz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bho bhafikili pwani, abhubhuene bhumati mbaha na akabhahurumila kwa ndabha bha jhele kama ng'osi syasidulili n'dimaji. Na akajhanda kubhafundisya mambo mingi. ");
INSERT INTO kiz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Muda bho bhulotili sana, bhanafunzi bhakan'hidila bhakan'jobhela, “Apa ndo mahali pa faragha ni muda ghulotili. ");
INSERT INTO kiz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ubhalaghajhi bhalotajhi miji ghya jirani ni fijiji ili bhakih'emelilayi kya kulya.” ");
INSERT INTO kiz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lakini akabhajibu akajobha,”Mubhapelayi muenga kyakulya.” Bhakan'jobhela, “Twibhwesya kulota kubhahemelela kyakulya ni mikate ghuaghejhe ni thamani jha dinari mia mbili ni kubhapela bhaliajhi?” ");
INSERT INTO kiz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Akabhajobhela,” Mujhele ni mikate milenga? Mulotajhi mukalangayi, “bhobhakabhili bhakan'jobhela, “Mikate mihanu ni somba sibhele.” ");
INSERT INTO kiz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Akabhaamuru bhanu bhatamajhi mu makundi mu mat'ondo mabhesi. ");
INSERT INTO kiz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bhakabhatamika mu makundi; makundi gha mamia kwa hamsini. ");
INSERT INTO kiz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kisha akalota mikate mihanu ni somba sibhele, ni kulanga kunani, akaghibariki kisha akabhapela bhanafunzi bha muene bhabhakajhi mbele jha bhumati. Kisha aghabhili somba sibhele kwa bhanu bhoha. ");
INSERT INTO kiz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhalili bhoha hadi bhatoshiki. ");
INSERT INTO kiz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bhabhongeniyi fipandi fya mikate ghyaghibakiri, fyamemili fikapu kumi ni fibhele ni pia fipandi fya somba. ");
INSERT INTO kiz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na bhajhele bhagosi elfu tano bhabhalili mikate. ");
INSERT INTO kiz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mara akabhajobhela bhakwelayi mu mashua bhalotayi sehemu jh'enge, hadi Bethsaida, bhwakati muene akabhalagha makutano. ");
INSERT INTO kiz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bhobhamalili kubhoka, akalota kukid'onda kus'oma. ");
INSERT INTO kiz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bhojhifikili kimihi ni mashua gha bhene bhwakati obhu jhajhele katikati jha bahari nu muene ajhele muene pa ndema. ");
INSERT INTO kiz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na abhabhuene bhitaabika kufigha ngafi kwa ndabha mp'ongo ghwabhazuili. Bhojhikalibili lukhela, akabhalotela, akajhaigenda panani pa masi na alondeghe kubhap'eta. ");
INSERT INTO kiz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lakini bho bhambwene igenda panani pa masi, bhakajhingibhwa ni bhuogha bhakidhanila ndo lijhogijhogi hata bhakajhanda kujhwegha njwegho. ");
INSERT INTO kiz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kwa ndabha bhambwene bhakajhingibhwa ni hofu. Mara akajobha nu muene akabhajobhela, “Mujhelayi bhajasiri! ndo nene! Musijhi ni bhuogha.” ");
INSERT INTO kiz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Akajhingila mu mashua ni mp'ongo ukalekaghwa gudeme ni bhene bhakan'shangala kabisa. ");
INSERT INTO kiz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kabhele bhajhelibhu lepi maana jhajhele mikate. Maana akili sya bhene syajhele ni bhuelebhwa bhudebe. ");
INSERT INTO kiz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na bhene bho bhalobhwiki kwiselya, bhafikili nchi jha Genesareti mashua jhasopili nanga. ");
INSERT INTO kiz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bhobhah'omili mu mashua, mara bhakammanya. ");
INSERT INTO kiz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bhakajumba kutangasya mu mkoa bhuoha na bhakajhanda kubhaleta bhatamu mu machela, khila bhobhip'eleka ihida. ");
INSERT INTO kiz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Popoha pa ajhingili mu fijiji; au mjini, au mu nchi, bhabhabhekili bhabhine mahali pa soko, na bhakan'sihi abharuhusiajhi kun'kamula pindo lya liguanda lya muene. Na bhoha bhabhan'kamuili bhaponyisibhu. ");
INSERT INTO kiz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafarisayo ni baadhi jha bhaandishi ghaghah'omili Yerusalemu bhabhonganiki kun'syong'oka muene. ");
INSERT INTO kiz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na bhabhuene bhanafunzi bha muene bhilya mikate kwa mabhoko najisi ambaghyo bhasambi lepi. ");
INSERT INTO kiz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(kwa Mafarisayo ni bhajhahudi bhoha bhilya lepi mpaka bhasambaji mabhoko gha bhene kinofu; bhikamulila bhutamaduni bhwa bhaseya bhwakati. ");
INSERT INTO kiz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mafarisayo bhikherebhuka kuh'omela mahali pa soko bhilya lepi mpaka bhajhoghayi hosi. Na kujha sheria s'enge ambalyo bhakasikesya kabisa, pamonga ni kusuka fikombi, masufuria, fenu fya shaba, ni hata fiti fya fitumika bhwakati bhwa kyakulya.) ");
INSERT INTO kiz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mafarisayo ni bhaandishi bhakan'kota Yesu, “Kwa ndabha j'ha kiki bhanafunzi bhajobhibhiishi lepi Kul'hengana ni tamaduni sya bhaseya, kwandabha jha kiki bhilya mikate bota kusamba mabhoko?” ");
INSERT INTO kiz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lakini muene akabhajobhela, “Isaya atabiri kinofu kuhusu muenga bhanafiki, ajhandiki, 'bhanu abha bhakaniheshimu kwa milomo ghya bhene, lakini miteema ghya bhene ghijhele patali ninene. ");
INSERT INTO kiz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bhakanibhombela ibada syasibelili kujha ni maana, bhifundisya sheria sya bhanadamu Kama mapokeo gha bhene.' ");
INSERT INTO kiz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mujhilekili sheria jha K'yara ni kusikamulila kwa bhwujhofu sheria sya bhanadamu.” ");
INSERT INTO kiz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na akajobha kwa bhene, “Muj'hibelili amri jha K'yara kwa bhujhojhofu ni ili kujha mutunzayi tamaduni sya muenga! ");
INSERT INTO kiz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwa kujha Musa ajobhili, 'mun'heshimuajhi dadi waku ni nyinuaku,' na 'Jhejhioha jhaibetakun'jobhela mabhibhi dadimunu au nyinamunu hakika ibetakufwa.' ");
INSERT INTO kiz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini mwijobha, 'kama munu akajobhayi kwa dadi munu au nyina, “Msaada bhobhuha ambabho nga mup'okili kwa nene ndo hazina jha hekalu,”' (ejhu ndo kujobha kujha, 'jhihomesibhu kwa K'yara') ");
INSERT INTO kiz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kama ukanduhusu lepi kubhomba lijambo lyolyoha kwa ndabha jha dadimunu au nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mukajhibhomba amri jha K'yara kujha bure kwa kulota tamaduni sya jhomu. Ni mambo mingi ghya namna ejhu jha mukajhibhomba.” ");
INSERT INTO kiz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Akabhakuta makutano kabhele ni kubhajobhela, “Munip'elekesiajhi nene muenga mwe bhoha, na munu njelebhwajhi. ");
INSERT INTO kiz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","kijhelepi kyokyoha kuh'omela kwibhala kwa bhanu ambakyo kibhwesya kun'chafula munu pa kijhingila kwa muene. Bali kyakikamp'ita munu ndo kyakikanchafula. ");
INSERT INTO kiz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Zingatilayi: mstari obho, “Kama munu jhejhioha ajhe ni mbolokhoto sya kup'eleka, na ap'elekayi” bhujhelepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu bho abhalikili makutano ni kujhingila mu nyumba, bhanafunzi bha muene bhakan'kota kuhusu mfano obho. ");
INSERT INTO kiz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu akajobha, Ni muene pia mujhelibhu lepi? Mwibhona lepi kyokioha kya kikanjhingila munu kibhwesya lepi kunchafula, ");
INSERT INTO kiz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwandabha kibhwesya lepi kul'ota mu n'teema ghwa muene, lakini kijhingita mu lileme lya muene na kisha kip'eta kulota ku choro.” kwa majhelesu agha Yesu asibhombili fyakulya fyoha kujha safi. ");
INSERT INTO kiz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akajobha, “kyakikampita munu ndo kyakikan'chafula. ");
INSERT INTO kiz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa kujha kih'omela mugati mwa munu, kunja mu muoyo, ghih'oma mabhwasu maovu, zinaa, bhuheji, bhukoma, ");
INSERT INTO kiz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bhuasherati, tamaa sibhibhi, bhuovu, bhusiobhi, kuhongana, bhwifu, kashfa, majivuno, bhujinga. ");
INSERT INTO kiz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maovu agha ghoha ghih'omela mugati, ndo ghala ghakan'chafula munu.” ");
INSERT INTO kiz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ajhinuiki pala ni kubhoka kulota ku mkoa ghwa Tiro ni sidoni. Akajhingila mugati na ambwene lepi munu jhejhioha umanyajhi kujha ajhele apu, lakini jhabhwesekene lepi kumfigha. ");
INSERT INTO kiz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lakini ghafla n'dala ambajhe mwana munu ajhele ni roho bhachafu, ap'eliki habari sya muene, akahida ni kubina mmagolo gha muene. ");
INSERT INTO kiz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","N'dala ojhu ajhele Myunani, ghwa kabila lya kifoeniki. An'sokili muene abhosiajhi pepo kuh'omela kwa mwali munu. ");
INSERT INTO kiz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu akan'jobhela n'dala, “Bhalekayi bhana bhalekayi bhana bhalesibhwayi hoti, kwa kujha sawalepi kutola n'kata ghwa muana ni kusopela libhwa.” ");
INSERT INTO kiz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lakini n'dala akan'jibu ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Akabhajobhela, “Kwa kujha ujobhili naha, ujhe huru kulota. Pepo amalili kumboka mwalibhu.” ");
INSERT INTO kiz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","N'dala akaghibariki kunyumba jha muene ni kun'kolela mwalimunu agonili pa kitanda, ni pepo amalili kumbokha. ");
INSERT INTO kiz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu akabhomba kabhele kwibhala jha mkoa ghwa Tiro ni kup'etela Sidoni kulotela Bahari jha Galilaya mpaka kanda jha Dikapolisi. ");
INSERT INTO kiz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na bhakandeta munu kiziwi na akajha ibhwesyalepi kulongela kinofu, bhakan'soka Yesu abhekayi mabhoko panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","An'homisi kwibhala ku lukhomanu kwa seri na akabheka fikonji fya muene mu mbolokhoto sya muene ni baada jha kufunya mata, agusili bhulimi bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akalanga kunani ku mbinguni ahemili ni kun'jobhela, “Efata,” ejhu ndo kujobha “fungukajhi!” ");
INSERT INTO kiz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ni muda bhola bhola mb'olo khoto sikafunguka, na kyakikazuili bhulimi kyaharibibhu na akabhwesya kulongela kinofu. ");
INSERT INTO kiz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na abhaamuili bhasin'jobheli munu jhejhioha. Lakini kadiri kya abhaamuili, ndo jinsi kyabhatangasili habari esu kwa bhwingi. ");
INSERT INTO kiz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hakika bhasyangesibhu ni kujobha, “Abhombili kila khenu kinofu. Hata abhabhombili viziwi kup'eleka ni mabubu kulongela.” ");
INSERT INTO kiz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu magono aghu, kwa jhele kabhele ni bhumati mbaha na bhajhelepi ni kyakulya. Yesu akabhakuta bhanafunzi bha muene akabhajobhela, ");
INSERT INTO kiz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nikabhuhurumila bhumati obho bhajhendelili kujha nani kwa magono madatu na bhajhelepi ni kyakulya. ");
INSERT INTO kiz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nibetakubhatabhwanya bhalotajhi ku nyumba sya bhene bila kulya bhibhwesya kusirika munjhela ni njala. Na baadhi jha bhene bhahomili patali sana.” ");
INSERT INTO kiz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bhanafunzi bha muene bhakan'jibu, Twibeta kukabha ndaku mikate ghya kufuana kubhasibisya bhanu abha mu lieneo ele lya lilekibhu?” ");
INSERT INTO kiz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Akabhakhota, “mujhele ni fipandi filenga fya mikate” bhakajobha, “Saba”. ");
INSERT INTO kiz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Abhuamuili bhumati bhutamayi pasi. Akalota mikate saba akan'shukuru k'yara, ni kujhimetula. Akabhap'ela bhanafunzi bha muene bhaibhekajhi palongolo pa bhene, ni bhene bhakajhibhaka palongolo jha bhumati. ");
INSERT INTO kiz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pia bhajhele ni somba sidebe, ni baada jha kushukuru, abhaamuili bhanafunzi bha muene bhabhagabhilayi ele pia. ");
INSERT INTO kiz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bhalili na bhatoshiki. Na bhabhongeniye fipandi fya libakili findonga fibhaha saba. ");
INSERT INTO kiz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bhakaribili bhanu elfu nne. Na abhalikili bhalotayi. ");
INSERT INTO kiz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mara akajhingila mu mashua ni bhanafunzi bha muene, na bhakalota mu bhukanda bhwa Dalmanuta. ");
INSERT INTO kiz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kisha Mafarisayo bhakapita kwibhala ni kujhanda kubishana ni muene. Bhalondeghe abhapelayi ishara kuh'omela kumbinguni, kwa kun'jaribu. ");
INSERT INTO kiz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Akatafakari kwa kina mu muoyo mwa muene akajobha, “Kwandabha jhakiki kizazi ekhe kilonda ishara? Nikabhajobhela muenga kweli, jhijhelepi ishara jha jhibeta kupisibhwa kwa kizazi ekhe.” ");
INSERT INTO kiz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kisha akabhaleka, akajhingila mugati mu mashua kabhele, akabhoka kulota lubhafu l'ongi. ");
INSERT INTO kiz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bhwakati abhu bhanafunzi bhajhebhelili mikate. Bhajhelepi ni mikate zaidi jha kipandi kimonga kyakikajhele mu mashua. ");
INSERT INTO kiz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Abhaonyili ni kujobha, “Mujhelayi mchu na mkil'endayi dhidi jha chachu jha Mafarisayo ni chachu jha Herode. ");
INSERT INTO kiz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bhanafunzi bhakajobhesana bhene kwa bhene, “Kwandabha tudulili mikate.” ");
INSERT INTO kiz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu alimanyili elu, na akabhajobhela, “kwa ndabha jhakiki mwijobhesana kuhusu kudula mikate? Mmanyili lepi? mwijhelabhwa lepi? mioyo ghya muenga mijhojhofu? ");
INSERT INTO kiz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mujheni mihu, mwilola lepi? mujheni mbolokhoto, mwip'eleka lepi? mwikhomboka lepi? ");
INSERT INTO kiz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bho nijhigabhwenye mikate mihanu kwa bhanu elfu tano, mwatolili fikapu filenga fya fimemili fipandi fya mikate?” Bhakan'jibu, “kumi ni fibhele.” ");
INSERT INTO kiz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“na bho nijhigabhwenye mikate saba kwa bhanu elfu nne, mwatolili fikapu filenga?” ");
INSERT INTO kiz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bhakajobha, “saba.” Akabhajobhela, “Badomwijhelebhwa lepi?” ");
INSERT INTO kiz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bhakahida Bethsaida. Bhanu abhu bhakandeta kwa Yesu munu kibofu ni kun'sihi Yesu an'kamulayi. Yesu akan'kamula kwa kibhoko ");
INSERT INTO kiz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","kya muene jhola kipofu ni kun'sihi Yesu an'kamulayi. Yesu akan'kamula kwa kibhoko Kya muene jhola kipofu ni kundongosya kwibhala ku Kijiji. Bho afunyili mata panani pa mihu gha muene ni kunyosya mabhoko gha muene panani pa muene, akan'kota, “Ghwilonda kyokyoha khela?” ");
INSERT INTO kiz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Alolili kunani ni kujobha, “Nibhona bhanu bhibhonekana Kama mab'ehe gha ghigenda.” ");
INSERT INTO kiz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ndipo akanyosya kabhele mabhoko gha muene kunani pa mihu gha muene, munu jhola akafumbula mihu gha muene, akalota kabhele, na akalota khila khenu kinofu. ");
INSERT INTO kiz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu akandeka alotayi kunyumba ni akan'jobhela, “Usijhingili ku mjini.” ");
INSERT INTO kiz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu akabhoka ni bhanafunzi bha muene kulota fijiji fya Kaiseria jha Filipi. Bho bhajhele munjela akabhakhota bhanafunzi, “Bhanu bhijobha nene na niani?” ");
INSERT INTO kiz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakan'jibu bhakajobha, “Yohana Mbatisiaji. Bhangi bhijobha, 'Eliya' na bhangi, 'Bhebhe mmonga ghwa Manabii.” ");
INSERT INTO kiz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Akabhakota, “Lakini muenga mwijobha nene na niani?” Petro akan'jobhela, “Bhebhe ndo kristu.” ");
INSERT INTO kiz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu akabhaonya bhasimb'oli munu jhejhioha kun'husu muene. ");
INSERT INTO kiz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ni kujhanda kubhafundisya kujha Mwana ghwa Adamu lazima atesekajhi kwa mambo mingi, na ibetakubelibhwa ni bhalongosi ni makuhani bhabhaha, ni bhaandishi na ibetakukomibhwa, ni baada jha magono madatu ibetakufufuka. ");
INSERT INTO kiz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ajobhili agha kwa bhuwazi. Ndipo Petro akan'tola palubhafu ni kujhanda kum'besya. ");
INSERT INTO kiz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lakini Yesu asanuiki ni kubhalanga bhanafunzi bha muene ni kun'kemela Petro ni kujobha, “p'etayi kunyuma jha nene lisyetani! Ghwijali lepi mambo gha K'yara, isipokujha mambo gha bhanu.” ");
INSERT INTO kiz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kisha akabhukuta bhumati bhwa bhanafunzi bha muene pamonga ni kubhajobhela, “Kama kuna munu ilonda kunikesya, akibelayi muene, atolayi n'salaba ghwa muene na anikesiayi. ");
INSERT INTO kiz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwa kujha jhejhioha jhailonda kughaokola maisha gha muene ibetakughayasya, na jhejhioha jha ibetakughajhasya maisha gha muene ibetakughaokola kwa ndabha jha nene. ");
INSERT INTO kiz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jhikamfaidisya kiki munu, kukabha bhulimwengu bhuoha, ni Kisha kukabha hasara jha maisha gha muene? ");
INSERT INTO kiz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Munu ibhwesya kuh'omesya kiki badala jha maisha gha muene? ");
INSERT INTO kiz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jhejhioha jha ikanibhonela soni ni nene mu kizazi ekhe kya bhazinzi hi kizazi Kya bhenye dhambi, Mwana ghwa Adamu ibetakumbonela soni paibetakuhida mu bhufalme bhwa dadimunu pamonga ni malaika bhatakatifu. ");
INSERT INTO kiz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na ajobhili kwa bhene, “Hakika nijobha kwa jhomu, baadhi jha muenga kuna bhanu bhabhajhemili bhibetalepi kubhonja mauti kabla jha kuubhona bhufalme bhwa K'yara ghwihida kwa nghofu.” ");
INSERT INTO kiz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ni baada jha magono sita, Yesu akabhatola Petro, Yakobo ni Yohana pamonga ni muene kukid'onda, bhene. Ndipo akajhanda kubadilika mbele jha bhene. ");
INSERT INTO kiz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Maguanda gha muene ghakajhanda kung'ara sana, mabhalafu zaidi kuliko mng'arishaji jhejhioha pa duniani. ");
INSERT INTO kiz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ndipo Eliya pamonga ni Musa bhakahomela pa longolo pa bhene, na bhajhele bhilongela ni Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petro akajibu akan'jobhela Yesu, “Mwalimu kinofu tete kujha apa na tujengayi fibanda fidatu, kimonga kwa ndabha jha bhebhe, kimonga kya Musa ni khenge kya Eliya.” ");
INSERT INTO kiz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Kwa kujha bhamanyilepi Kya kujobha, bhatili sana.) ");
INSERT INTO kiz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Libhengu lya homili ni kubhafueka. Ndipo sauti ikah'oma mumabhangu jhikajha j'hijobha, “Ojho ndo mwanabhangu mpendwa. Mup'elekesiayi muene.” ");
INSERT INTO kiz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ghafla, bho bhilanga, bhambwene lepi jhejhioha pamonga naku, isipokujha Yesu tu. ");
INSERT INTO kiz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bho bhiselela kih'omela kukid'onda, abhaamuili kutokun'jobhela munu jhejhioha jhola gha bhaghabhuene, mpaka Mwana ghwa Adamu paibetakufufuka kuh'omela kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ndipo bhaghatunzili mambo aghu bhene. Lakini bhajadiliene bhene kwa bhene kiki maana ghake “kufufulibhwa kuh'omela kwa bhafu” ");
INSERT INTO kiz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakan'kota Yesu, “Kwa ndabha j'ha kiki bhanafunzi bhaandishi bhijobha lazima Eliya ahidayi hoti?” ");
INSERT INTO kiz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Akabhajobhela, “hakika Eliya ibetakuhida hosi kuokola fenu fyoha. Kwandabha jhakiki jhilembibhu Mwana ghwa Adamu lazima akabhayi mateso hoti mingi na achukibhwayi? ");
INSERT INTO kiz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakini nijobha kwa muenga Eliya amalili kuhida, na bhambombili Kama kya bhalondeghe, kama vile majhandiku kyaghijobha kuhusu muene.” ");
INSERT INTO kiz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na bho bhakherebhuiki kwa bhanafunzi, bhabhuene likundi libhaha lya bhanu libhazunguiki ni Masadukayo bhajhele bhibishana nabhu. ");
INSERT INTO kiz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na mara bho bhambwene, likundi lyoha lyasyangele ni kun'jumbilila kumponesya. ");
INSERT INTO kiz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Abhakotili bhanafunzi bha muene, “Mwibishana nabhu juu jha kiki?” ");
INSERT INTO kiz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mmonga ghwa bhene mulikundi akan'jibu, “Mwalimu, nikandetili mwanabhangu kwa bhebhe; ajhe ni roho jhichafu ambajho jhiikamfwanya ashindwayi kulongela, ");
INSERT INTO kiz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","na ghakan'sababishila kutetemeka ni kum'binisya pasi, ni kuh'oma povu mu ndomo ni kusiagha minu ni kukakamala. Nikabhas'omili bhanafunzi bha j'hobhi kumb'osya pepo, lakini bhashindilu. ");
INSERT INTO kiz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Abhajibili, “kizazi kyakibeli kuamini, nibetakutama namu kwa muda gani? Nibetakutolana namu mpaka ndahi? Mundetayi kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhandetili mwana munu. Roho n'chafu bho ambwene Yesu, ghafla alimtii kwa kujhonganika. N'gosi abinili pasi ni kuh'omesya povu mu ndomo. ");
INSERT INTO kiz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu akan'kota dadimunu, “Ajhele kwa hali ejhe kwa muda gani?” Dadimunu akajobha, “kuh'omela bhuana. ");
INSERT INTO kiz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mara jhenge ibina mu muoto au mu masi, ni kujaribu kunjasya. Kama ghwibhwesya kubhomba kyokyoha tuhurumilayi na utusaidilayi.” ");
INSERT INTO kiz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akan'jobhela, “Kama ujhe tayari? Khila khenu kibhwesekana kwa jhejhioha jha iamini.” ");
INSERT INTO kiz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ghafla dadi ghwa mwana alelili ni kujobha, “Niamini! Nisaidilayi kutokuamini kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bhwakati Yesu abhwene likundi likhembelela kwa bhene, an'kemili roho n'chafu ni kujobha, “bhebhe roho bubu ni kiziwi, nikuamuru undekayi, usijhingili kwa muene kabhele.” ");
INSERT INTO kiz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Akatela kwa ngofu ni kun'hangaisya muana ni roho ambokili. Muana abhonekene kama afuili, Ndipo bhingi bhakajobha, “Afuili,” ");
INSERT INTO kiz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu akan'tola kwa mabhoko akanjinula, ni muana akajhema. ");
INSERT INTO kiz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bhwakati Yesu ajhingili mugati, bhanafunzi bha muene bhan'kotili faragha, “Kwa ndabha jha kiki twashindilu kumbosya?” ");
INSERT INTO kiz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Akabhajobhela, “kwa namna ejhe ghibhoka lepi isipokujha kwa maombi.” ");
INSERT INTO kiz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bhakabhoka pala ni kup'etela Galilaya, Alondelepi munu jhojhioha jhola amanyayi pa bhajhele, ");
INSERT INTO kiz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwa kujha afundisieghe bhanafunzi bha muene. Akabhajobhela, “Mwana ghwa Adamu ibetakufikisibhwa mu mabhoko gha bhanu na bhibetakun'koma. Paibetakujha afuili, baada jha magono madatu ibetakufufuka kabhele. “ ");
INSERT INTO kiz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakini bhajhelibhulepi majhelesu agha, na bhatilili kun'kota. ");
INSERT INTO kiz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ndipo bhafikiri Karperinaumu. Bhwakati bhajhele munyumba abhakhotili, “Mujadilieghe kiki mu nj'ela”? ");
INSERT INTO kiz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakini bhajhele kimya. Kwani bhajhele bhibishana mu njela kujha niani ajhele mbaha zaidi. ");
INSERT INTO kiz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Atamili pasi abhakutili kumi ni bhabhele pamonga, na ajobhili nabhu, “Kama jhejhioha ilonda kujha ghwa kuanza, ndo lazima ajhelayi ghwa mwishu na n'tumishi ghwa bhoha.” ");
INSERT INTO kiz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","An'tolili muana ndebe akambeka katikati jha bhene. Akan'tola mu mabhoko gha muene, akajobha, ");
INSERT INTO kiz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jhojhioha jha ikampokela muana kama ojho kwa lihina lya nene, pia anipokili nene, na ikajhiajhi munu anipokili, akanipokelalepi nene tu, lakini pia jhaanitumili.” ");
INSERT INTO kiz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana akan'jobhela, “Mwalimu tukambwene munu ibhosya pepo kwa lihina lya bhebhe na tukambwene, kwa ndabha akatufuayi lepi.” ");
INSERT INTO kiz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lakini Yesu akajobha, “Musimbesi, kwa kujha ajhelepi jhaibetakubhomba mbombo mbaha kwa lihina lya nene ni ndipo baadaye ajobhayi lilobhi lyolyoha juu jha nene. ");
INSERT INTO kiz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jhejhioha jha ajhele kinyume ni tete basi ajhele lubhafu kwa tete. ");
INSERT INTO kiz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jhojhioha jhaibetakupela kikombi kya masi gha kunywa kwa ndabha ujhe ni Kristu, bhukweli nikabhajobhela ibetalepi kujasya thawabu jha muene. ");
INSERT INTO kiz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jhejhioha jha ikabhakosela abha bhadebe bhabhakaniamini nene, ngajhijhele kinofu kwa muene kufungibhwa liganga lya kusyaghila ku n'singu ni kutaghibhwa ku bahari. ");
INSERT INTO kiz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kama kibhoko Kya bhebhe kikukosili kidumulayi. Ni heri kujhingila mu bhusima bila kibhoko kuliko kujhingila mu hukumu ujhele ni mabhoko ghoha mu muoto “bhwabhwisimalepi”. ");
INSERT INTO kiz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Zingatilayi: Mistari ejhe, “Mahali ambapo masomi ghifwa lepi ni muoto bhwabhwisima lepi.” bhujhelepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kama kigolo kya bhebhe kikukosili dumulayi. Ni kinofu kwa bhebhe kujhingila mu bhuzima ukajhiajhi kilema, kuliko kutaghibhwa mu hukumu ni magolo ghoha mabhele. ");
INSERT INTO kiz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Zingatilayi: N'sitari obho, “Mahali ambapo masomi ghifwa lepi ni muoto bhwabhwisima lepi” bhujhelepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kama lihu lya bhebhe likakukoselayi, libhosiayi. Ni kinofu kwa bhebhe kujhingila mu bhufalme bhwa K'yara ni lihu limonga, kuliko kujha ni mihu ghoha mabhele ni kutaghibhwa kuzimu. ");
INSERT INTO kiz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mahali pa paj'hele ni masomi ghaghifwa lepi ni muoto bhwa bhwisimalepi. ");
INSERT INTO kiz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kwa kujha kila mmonga ibetakukolesibhwa ni muoto. ");
INSERT INTO kiz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Muinyu bhunofu, kama muinyu bhujasili ladha jhiake, ghibetakujhibhomba bhuli jhijhiajhi ni ladha kabhele? Mujhelayi ni muinyu miongoni mwa muenga mwejihomu, na mujhelayi ni amani kwa khila mmonga.” ");
INSERT INTO kiz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu akabhoka lieneo elu ni kulota mu mkoa ghwa Uyahudi ni lieneo lya kiholo Yorodani, ni makutano bhakan'kesya kabhele. Abhamanyisi kabhele, kama kyajhikajhele kawaida jha muene kubhomba. ");
INSERT INTO kiz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ni Mafarisayo bhakahida kun'jaribu ni kunkota, “Ni halali kwa n'gosi kundekan'dala munu?” ");
INSERT INTO kiz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akabhajibu, “Musa abhaamuiri kiki?” ");
INSERT INTO kiz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhakajobha, “Musa aruhusili kulemba cheti kya kulekana ni kumb'enga n'dala.” ");
INSERT INTO kiz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ni kwa ndabha ghya mioyo ghya jhomu ndio maana abhajhandikili sheria ejhe,” Yesu abhajobhili. ");
INSERT INTO kiz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Lakini kuhoma mwanzo ghwa bhuumbaji, 'K'yara abhabhombili n'gosi ni n'dala.' ");
INSERT INTO kiz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","wa ndabha ejhe n'gosi ibetakundeka dadimunu ni nyinamunu na ibetakuungana ni n'dala munu. ");
INSERT INTO kiz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na abhu bhabhele bhibetakujha mb'ele umonga; kwa kujha sio bhabhele kabhele, bali mb'ele bhumonga. ");
INSERT INTO kiz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Henu, kyaakiunganishi K'yara, mwanadamu asikitenganisi. ");
INSERT INTO kiz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bhobhafikili mugati mu nyumba bhanafunzi bha muene bhan'kota kabhele kuhusu ele. ");
INSERT INTO kiz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akabhajobhela, “Jhijhioha jhaibetakundeka n'dala munu ni kun'gega n'dala jhongi ibetakujha abhombili bhuzinzi. ");
INSERT INTO kiz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","N'dala ni muene akandekayi n'gosi munu ni kulota kugegikibhwa ni n'gosi jhongi ibetakujha abhombili bhuzinzi.” ");
INSERT INTO kiz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na bhene, bhakandetela bhana bhabhi bhadebe ili abhagusayi, lakini bhanafunzi bhakabhabesya. ");
INSERT INTO kiz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lakini Yesu bho amanyili elu, afurahisibhulepi akabhajobhela, “bharuhusujhi bhana bhadusu bhahidayi kwa nene, na musibhabesi, kwa ndabha bhabhajhe kama abha bhufalme bhwa mbingu ndo ghwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bhukweli nikabhajobhela, jhejhioha jhaapokili lepi bhufalme bhwa K'yara kama mwana n'debe hakika ibhwesyalepi kujhingila mu bhufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kisha akabhatola bhana mu mabhoko gha muene na akabhabariki khoni abhabhakhili mabhoko gha muene panani pa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na bho ajhandili safari jha muene munu mmonga akan'jumbilila ni kupiga magoti mbele jha muene, akan'kota, Mwalimu nnofu, niketajhi kiki ili nibhwesijhi kubhurithi bhuzima bhwa milele?” ");
INSERT INTO kiz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ni Yesu akajobha, “Kwa ndabha jha kiki ukanikuta mwema? Ajhelepi jha ajhe mwema, isipokujha K'yara muene. ");
INSERT INTO kiz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Usimanyi amri: 'Usikomi, usizini, usiheji, usijobhi bhudesi, usikofi, un'heshimuajhi dadiwaku ni nyinawaku'.” ");
INSERT INTO kiz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munu jhola akajobha, “Mwalimu, agha ghoha nimalikughatii kuh'omela bhusongolo bhwa nene.” ");
INSERT INTO kiz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu akandanga ni kun'gana. Akan'jobhela, “Up'hong'okibhu khenu kimonga. Ghwilondeka kuhemelesya fenu fyoha fya ujhe nafu na ubhapelayi maskini, na ibetakujha ni hazina kumbinguni. Ndipo uhidayi unikesa.” ");
INSERT INTO kiz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lakini akatitamaa kwa ndabha jha majhelesu agha; abhokhili kwa huzuni, kwa ndabha ajhele ni malisimehele. ");
INSERT INTO kiz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu akalanga sehemu syoha ni kubhajobhela bhanafunzi bha muene, “Ni jinsi gani kya jhijhele panonono kwa tajiri kujhingila mu bhufalme bhwa K'yara! ");
INSERT INTO kiz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bhanafunzi bhashangisiibhu ni malobhi agha. Lakini Yesu akabhajobhela kabhele, “Bhana, ni jinsi gani kyajhijhela panonono kujhingila mu bhufalme bhwa K'yara! ");
INSERT INTO kiz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni rahisi kwa ngamia kuholota mu lilende lya sindanu, kuliko munu tajiri kujhingila mu bhufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bhashangele sana ni kujobhesana, “Hivyo niani ibetakuokoka” ");
INSERT INTO kiz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu akabhalanga ni kujobha, “Kwa binadamu j'hibhwesekanalepi, lakini kwa K'yara lepi. Kwa kujha kwa K'yara ghoha ghibhwesekana.” ");
INSERT INTO kiz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petro akayanda kulongela naku, “Langajhi tulekili ghoha na tukukesili.” ");
INSERT INTO kiz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu akajobha, “Bhukweli ni kabhajobhela muenga, ajhelepi jha alekili nyumba, au kaka, au dada, au mabhu, au tata, au bhana, au ndema, kwa ndabha jha nene, ni Injili, ");
INSERT INTO kiz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ambajhe ibetalepi kujhamb'elela zaidi jha mara mia zaidi jha henu apa pa duniani: nyumba, kaka, dada, mabhu, bhana, ni ndema, kwa malombosi, ni bhulimwengu bhwa bhwihida, bhuzima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakini bhingi bhabhajhe bha kuanza bhibetakujha bha mwishu na bhabhajhele bhamuishu bhibetakujha bha kuanza.” ");
INSERT INTO kiz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bho bhajhe munjela, kulota Yerusalemu, Yesu abhalongolili palongolo pa bhene. Bhanafunzi bhashangele ni bhala bhabhak'hesieghe kunyuma bhatilili. Ndipo Yesu akabhabhosya pa lubhafu kabhele bhala kumi ni bhabhele ni kujhanda kubhajobhela ambakyo kibetakun'tokela henu naha: ");
INSERT INTO kiz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Langayi, twilota mpaka Yerusalemu, ni Mwana ghwa Adamu ibetakufikisibhwa kwa makuhani ni bhaandishi. Bhibetakun'hukumu afuayi na bhibetakun'deta kwa bhanu bha Mataifa. ");
INSERT INTO kiz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bhibetakun'hukumu, bhibetakunfunyila mata, bhibetakuntobha ndonga, ni kun'koma. Lakini baada jha magono madatu ibetakufufuka.” ");
INSERT INTO kiz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo ni Yohana, bhana bha Zebedayo, bhakahida kwa muene ni kujobha, “Mwalimu, twisoka utubhombelajhi kyokioha kila kya twibeta kus'oma.” ");
INSERT INTO kiz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Akabhajobhela, “Mwilonda nibhabhombilajhi kiki?” ");
INSERT INTO kiz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakajobha, “Turuhusiajhi tutamajhi pamonga ni bhebhe mu bhutukufu bhwa jhobhi mmonga kibhoko jhobhi kya kulia ni jhongi kibhoko kya kushoto.” ");
INSERT INTO kiz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lakini Yesu abhajibili, “Mumanyilepi kya mwisoma. Mwibhwesya kunywelela kikombi ambakyo nibetakunywelela au kusindamala bhubatizo bhwa nibeta kubatisibhwa?” ");
INSERT INTO kiz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakan'jobhela, “Twibhwesya” Yesu akabhajobhela, “Kikombi Kya nibetakunywelela, mwibetakunywelela. Ni bhubatizo ambabho kwa bhene nibatisibhu, mwibetakubhusindamala. ");
INSERT INTO kiz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lakini jhaibetakutama kibhoko Kyangu kya kuume au kibhoko Kya nene kya kushoto sio nene ghwa kupisya lakini ni kwa bhala ambabho jhimalikuandalibhwa.” ");
INSERT INTO kiz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhala bhangi bhanafunzi kumi bho bhap'eliki agha, bhakajhanda kubhadadila Yakobo ni Yohana. ");
INSERT INTO kiz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu akabhakuta kwa muene ni kujobha, “Mmanyili kujha bhala bhabhidheminibhwa kujha bhatawala bha bhanu bha mataifa bhikabhatawala, ni bhanu bha bhene mashuhuri bhikabhalasya mamlaka juu jha bhene.” ");
INSERT INTO kiz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini jhilondeka lepi kujha naha kati jha jhomu. Jhojhioha jha ibetakujha mbaha kati jha muenga lazima abhatumikilayi. ");
INSERT INTO kiz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na jhejhioha jha ibetakujha ghwa kuanda kati jha muenga na lazima ajhelayi n'tumwa ghwa bhoha. ");
INSERT INTO kiz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwa kujha mwana ghwa Adamu ahidilepi kutumikibhwa bali kutumika, ni kughabhosya maisha gha muene kujha fidia jha bhangi.” ");
INSERT INTO kiz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhakahida Yeriko. Wakati ibhoka Yeriko ni bhanafunzi bha muene ni likundi libhaha, mwana ghwa Timayo, Batimayo, kipofu n'somaji, alikaa kando jha barabara. ");
INSERT INTO kiz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bho ap'eliki kujha Yesu Mnazareti, akajhanda kujhuegha ni kujobha, “Yesu, Mwana ghwa Daudi, nihurumilayi!” ");
INSERT INTO kiz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bhingi bhan'kemili jhola kipofu, bhakan'jobhela agudamayi. Lakini akalela kwa sauti zaidi, “Mwana ghwa Daudi, nihurumilayi!” ");
INSERT INTO kiz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu akajhema ni kuamuru akutibhwayi. Bhakan'kuta kipofu jhola, bhakajobha, “Jhiajhi shujaa! Jhinukayi! Yesu ikukuta.” ");
INSERT INTO kiz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akalitaga pa lubhafu likoti lya muene, akajumba zaidi, ni kuhida kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu akan'jibhu ni kujobha, “ghwilonda nikukhetelayi kiki?” Jola n'gosi kipofu akan'jibu, “Mwalimu, nilonda kulola.” ");
INSERT INTO kiz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu akan'jobhela, “Lotayi. Imani jha jhobhi jhikuponisi. Bahuapu mihu gha muene ghakajhanda kulola; na akan'kesiya Yesu mu nj'ela. ");
INSERT INTO kiz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wakati obhu bho bhahidili Yerusalemu Bho bhakaribili Besthfage ni Bethania, pa kid'onda kya Mizeituni, Yesu abhatumili bhabhele miongoni mwa bhanafunzi bha muene ");
INSERT INTO kiz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ni kubhajobhela, “mulotayi mu kijiji kya kikabiliana ni tete. Mara pa mwibeta kujhingila omu, mwibeta kurikolela mwanapunda ambajhe akwellibhu lepi. Mun'kongajhi na mundetayi kwa nene. ");
INSERT INTO kiz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na kama jhajhioha akabhajobhelayi, “kwa ndabha jha kiki mwibhomba na ha?, mwilondeka kujobha, 'Bwana akandonda na mara abetakun'kerebhusya apa'.” ");
INSERT INTO kiz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhakalota ni kunkolela mwanapunda akongibhu kwibhala pa ndiangu pa mtaa ghwa ghujhele bhuwasi, na bhene bhakajhanda kumbopola. ");
INSERT INTO kiz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na baadhi jha bhanu bhajhele bhajhemili pala ni kabhajobhela, “Mwikheta kiki, kumbopola mwanapunda ojhu?” ");
INSERT INTO kiz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bhakabhajobhela kama Yesu kya abhajobhili, na bhanu bhakabhaleka bhalotayi. ");
INSERT INTO kiz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhanafunzi bhabhele bhakandeta mwanapunda kwa Yesu na bhatandiki mavazi gha bhene panani pa muene ili Yesu abhwesiajhi kun'kwela. ");
INSERT INTO kiz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bhanu bhingi bhatandiki mavazi gha bhene mu njela, na bhangi bhatandiki matawi gha bhadumuili kuh'omela mu n'gonda. ");
INSERT INTO kiz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bhala bhabhalotili palongolo pa muene ni bhala bhabhamfwatili bhapigili njuegho, “Hosana! Abarikibhu jha ihida kwa lihina lya Bwana. ");
INSERT INTO kiz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ubarikibhwayi bhufalme bhwa bhwihida bhwa dadi jhitu Daudi! Hosana kwa jha ajhe kunani” ");
INSERT INTO kiz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ndipo Yesu akajhingila Yerusalemu ni kulota kulihekalu na alangili khila khenu. Henu, wakati ghwa malikulota, alotili Bethania pamonga nabhu kumi ni bhabhele. ");
INSERT INTO kiz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ligono lya lafwatili, wakati bhikherebhuka kuh'omela Bethania, ajhele ni njala. ");
INSERT INTO kiz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na akaghubhona libehe lya mtinghwa ghwajhele ni mat'ondo kwa patali, akalota kulenga kama ngaabhwesili kyokyoha khela munani mu libehe. Ni wakati alotili apu, akabhilepi kyokyoha isipokujha mat'ondo, kwa kujha jhajhelepi majira gha mtini. ");
INSERT INTO kiz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Abhojobhili, “Ajhelepi jhejhioha jha ibeta kulya litunda kuh'omela kwa bhebhe kabhele”. Ni bhanafunzi bha muene bhakap'eleka. ");
INSERT INTO kiz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bhakahida Yerusalemu, nu muene akajhingila mu lihekalu ni kujhanda kubhapisya kwibhala bhabhigolesya ni bhabhigola mugati mu lihekalu. Ap'enduili meza sya bhabadilishaji bha fedha ni fiti fya bhala bhabhagole sieghe nj'ebha. ");
INSERT INTO kiz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anduhuswili lepi jhejhioha kup'enda kyokyoha mu hekalu kyakyabhwesili kugolesibhwa. ");
INSERT INTO kiz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abhafundisi ni kujobha, “Je jhajhandikibhu lepi, 'nyumba jha nene ibetakujha nyumba jha sala kwa mataifa ghoha'? Lakini mujhibhombili pango lya bhanyang'anyi”. ");
INSERT INTO kiz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makuhani bhabhaha ni bhaandishi bhap'eliki gha ajobhili, na bhene bhakalonda njela jha kun'koma. Hata naha bhantilili kwandabha bhumati bhwasangesibhu ni mafundisho gha muene. ");
INSERT INTO kiz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ni kila bhwakati kimihi jhikahidayi, bhabhokili kumjini. ");
INSERT INTO kiz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wakati bhigenda lukhela bhaghu bhene libehe lya mtini bhujhomili mpaka mu mizizi ghiake. ");
INSERT INTO kiz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro akakhomboka ni kujobha, “Rabi! Langayi, libehe lya mti ni lyawalilaanili lijhomili”. ");
INSERT INTO kiz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu abhajibili, “Mujhelayi ni imani kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Muaminiayi nikabhajobhela kujha khila jha akubhujibhela kid'onda ekhe, bhokayi, na ukakiteghayi ghwa muene mu bahari, 'na kama ajhelepi ni mashaka mu muoyo ghwa muene lakini iamini kujha kya akijobhili kubeta kuh'omela, naha K'yara ibetakubhomba. ");
INSERT INTO kiz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Henu nikabhajobhela: Khila khenu kya mwis'oma ni kukota kwa ndabha jha muene, muaminiayi kujha mupokili, ni fyene fibetakujha fya muenga. ");
INSERT INTO kiz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wakati mwijhema ni kus'oma mwilondeka kusamehe kyokyoha kyamujhenaku dhidi jha jhejhioha, ili kujha dadi jhime jhaajhe kumbinguni abhasameajhi pia muenga makosa gha jhomu. ");
INSERT INTO kiz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Zingatilayi: N'sitari obho, “Lakini mukabelayi kusamehe, wala Dadi jhinu jha ajha kumbinguni ibetalepi kusamehe dhambi sya jhomu” bhujhelepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bhakahida Yerusalemu kabhele. Ni Yesu bho igenda mu lihekalu, makuhani bhabhaha, bhaandishi ni bhaseya bhakahida kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhan'jobhili, “Kwa mamlaka ghaloki ghwibhomba mambo agha?” Na niani akupelili mamlaka gha kubhomba agha?” ");
INSERT INTO kiz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu akabhajobhela, “Nibeta kubhakhota liswali limonga. Munijobhilayi ni nena nibeta kujobhela kwa mamlaka ghaloki nibeta kubhomba mambo agha. ");
INSERT INTO kiz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Je, bhubatisu bha Yohana bhwahomili kumbinguni au kwa bhanadamu? Munijibuajhi.” ");
INSERT INTO kiz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhakajadiliana miongoni mwa bhene ni kusindana ni kujobha, “Kama tukajihakiki, 'Kuh'omela kumbinguni,' ibeta kujobha, 'Kwa ndabha jha kiki mwabelili kumwamini?' ");
INSERT INTO kiz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lakini kama tukajobhai, 'Kutoka kwa bhanadamu,'...” Bhabhatilili bhenu, kwa kujha bhoha bhakamulili kujha Yohana ajhele nabii. ");
INSERT INTO kiz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ndipo bhakan'jibu Yesu ni kujobha, “Tumanyili lepi. Ndipo Yesu akabhajobhela, “Wala nene nikabhajobhela lepi ni kwa mamlaka gani nikabhajobhela lepi ni kwa mamlaka gani nibhomba mambo agha. ");
INSERT INTO kiz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kisha Yesu akayanda kubhafundisya kwa mifano. Akajobha, “Munu apandili n'gonda ghwa mizabibu, akalisyongosela bhuzio, na akagima lilenda lya kusindika mvinyo. Akajenga mnara ni kisha akalipangisya n'gonda ghwa mizabibu kwa bhakulima bha mizabibu. Kisha asafiri safari jha patali. ");
INSERT INTO kiz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wakati bho bhufikili, an'tumili n'tumishi kwa bhakulima bha mizabibu kutola kuh'omela kwa bhene baadhi jha matunda gha n'gonda ghwa mizabibu. ");
INSERT INTO kiz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lakini bhan'kamuili, bhan'tobhili, ni kumb'enga bila kyokyoha. ");
INSERT INTO kiz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akan'tuma kwa bhene kabhele n'tumishi jhongi, bhakan'jeruhi kumutu ni kun'ketela mambo gha soni. ");
INSERT INTO kiz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bado an'tumili jhongi, ni ojho mmonga bha n'kamili. Bhabhaketili bhangi bhingi mambo kama bhaghabhuene, bhakabhatobha ni bhangi kubhakhoma. ");
INSERT INTO kiz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ajhe bado ni munu mmonga zaidi ghwa kun'tuma, mwana mpendwa. Ni muene ajhele ghwa mwishu jha atumibhu kwa bhene. Akajobha, “Bhibeta kun'heshimu mwanabhangu”. ");
INSERT INTO kiz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini bhapangaji bhajobhisene bhene kwa bhene, “Ojho ndo mrithi. Mhidayi, hebu na tun'komayi, ni bhurithi bhwibeta kujha bhwa tete.” ");
INSERT INTO kiz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bhakamvamila, bhakan'koma ni kum'tagha kwibhala mu n'gonda ghwa mizabibu. ");
INSERT INTO kiz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Henu, Je! ibeta kuketa kiki mmiliki ghwa n'gonda ghwa mizabibu? ibeta kuhida ni kubhajhangamisya bhakulima bha mizabibu kulikabidhi n'gonda ghwa mizabibu kwa bhangi. ");
INSERT INTO kiz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mbwajhilepi kusoma liandiku ele? “Liganga ambalyo bhajenzi bha libelili, limalikujha liganga lya palubhafu. ");
INSERT INTO kiz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ela lyahomili kwa Bwana na lya ajabu pamihu pa tete.” ");
INSERT INTO kiz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bhakalonda kunikamula Yesu, Lakini bhabhatilili makutano kwani bhamanyili kujha ajobhili mfuano bhola kwandabha jha bhene. Hivyo bhakandeka ni kubhoka. ");
INSERT INTO kiz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kisha bhakabhatuma Mafarisayo ni Maherodia ili kuntegha kwa malobhi. ");
INSERT INTO kiz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bho bhafikili, bhakan'jobhela, Mwalimu, tumanyili kujha ghwijali lepi maoni gha jhejhioha jhola na ghwilasya lepi bhupendulu kati jha bhanu. Ghwimanyisya njela jha K'yara mu bhukweli. Je! ndo haki kulepa kodi kwa Kaisari au la? Je! Twibhwesya kulepa au la? ");
INSERT INTO kiz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini Yesu amanyili bhunafiki bhwa bhene ni kubhajobhela, “Kwa ndajhakiki mkanijaribu? Munipelayi dinari nibhwesiajhi kujhilanga.” ");
INSERT INTO kiz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhakaleta jhimonga kwa Yesu, Akabhajobhela, “Je! ijhe sura jha niani ni maandishi ghaghajhele apa gha niani? Bhakajobha, “Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu akabhajobhela, “Mumpelayi Kaisari fenu fya Kaisari ni K'yara fenu fya K'yara.” Bhakan'staajabu. ");
INSERT INTO kiz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kisha Masadukayo, bhabhijobha bhujhelepi bhufufuo, bhakandotela. Bhakan'kota, bhakajobha, ");
INSERT INTO kiz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimu, Musa atujhandikili kujha, 'Ndongo ghwa munu afuili ni kundeka n'dala munu kumbele kwa muene, lakini aleki lepi muana, munu ibetakun'tola n'dala ghwa ndongo munu, ni kwikabhela bhana kwandabha jha ndongo munu.' ");
INSERT INTO kiz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwajhele ni bhanandugu saba ghwa kwanza atolili n'dala ni kisha akafwa, alekili lepi bhana. ");
INSERT INTO kiz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kisha ghwa pili an'tolili ni muene akafwa alekilepi bhana. Ni ghwa tatu jhajhe mebhu. ");
INSERT INTO kiz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ni ghwa saba afuili bila kuleka bhana. Mwishowe ni n'dala ni muene akafwa. ");
INSERT INTO kiz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wakati ghwa bhufufuo, pabhibeta kufufuka kabhele He! ibeta kujha n'dala, ghwa niani? Kwani bhala bhanandugu bhoha saba bhajhele bhagosi munu.” ");
INSERT INTO kiz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akabhajobhela, “Je! Ejhe sababu lepi kujha mu potosibhu, kwa ndabha mumanyilepi mayandiku wala ngofu sya K'yara?” ");
INSERT INTO kiz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wakati bhwa kufufuka kuh'omela kwa bhafu, bhibeta lepi kugega, wala kujhingila mu ndobho, bali bhibeta kujha kama malaika bha kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lakini, kuhusu bhafu bha bhifufulibhwa, Je! Mwasomilepi kuhomela kitabu kya Musa, Mu bahari sya kichaka, jinsi K'yara kyaajobhili ni kun'jobhela, 'Nene ndo K'yara ghwa Ibrahimu ni K'yara ghwa Isaka, ni K'yara ghwa Yakobo?' ");
INSERT INTO kiz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Muene K'yara ghwa bhafulepi, bali bhabhajhe hai. Ndo bhukweli mupotuiki.” ");
INSERT INTO kiz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mmonga ghwa bhaandishi akahida ni kup'elekesya mazungumzo gha bhene; abhwene kujha Yesu abhajitili kinofu. “Je! amri jheleku jha muhimu zaidi kuliko senge?” ");
INSERT INTO kiz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akan'jibu, “Jhaijhele jha muhimu ejhe, “Pelekayi, Israeli, Bwana K'yara ghwitu, Bwana ndo mmonga. ");
INSERT INTO kiz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lazima un'ganayi Bwana K'yara ghwa jhobhi muoyo ghwa jhobhi bhuoha, kwa roho jha jhobhi, kwa luhala kwa jhobhi lwoha, ni kwa ngofu sya jhobhi syoha.' ");
INSERT INTO kiz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Amri jha pili ejhe, 'Lazima un'ganayi jirani ghwa jhobhi kama kyaukigana ghwa jobhi.' Ijhelepi amri jhenge mbaha zaidi jha e'se.” ");
INSERT INTO kiz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mwandishi akajobha, “Knofu Mwalimu! Ujobhili bhukweli kujha K'yara ni mmonga, ni kujha ajhelepi jhongi zaidi jha muene. ");
INSERT INTO kiz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kun'gana muene kwa muoyo bhuoha, ni kwa bhufahamu bhuoha, ni kwa nghofu syoha nikun'gana jirani kama muene ni muhimu kuliko matoleo gha dhabihu sya kuteketesibhwa.” ");
INSERT INTO kiz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wakati Yesu abhuene ahomisi lijibu lya busara akan'jobhela, “Bhebhe ujhelepi patali ni bhufalme bhwa K'yara.” Baada jha hapo ajhelepi hata mmonga jhe athubutiuli kun'kota Yesu maswali ghoghoha. ");
INSERT INTO kiz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ni Yesu akajibu bho ifundisya mu hekalu, akajobha, “Je! bhaandishi bhijobha bhuli kujha Kristu ndo mwana ghwa Daudi? ");
INSERT INTO kiz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi muene mu Roho mtakatifu, ajobhili, 'Bwana ajobhili kwa Bwana ghwa nene tamayi mu kibhoko kya nene kya kuume, mpaka nibhabhombajhi maaduibha bhebhe kujha pasi pa magolo gha bhebhe.' ");
INSERT INTO kiz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi muene akan'kuta Kristu, 'Bwana' Je! ni mwana ghoa Daudi kwa jinsi gani?” Ni likusanyiku libhala lyamp'elekisi kwa furaha. ");
INSERT INTO kiz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mu mafundisho gha muene na Yesu ajobhili, “Mukitahadhariajhi ni bhaandishi, bhabhinoghela kugenda ni likanzu litali ni kusalimibhwa mu masoko. ");
INSERT INTO kiz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ni kutama mu fiti fya bha bhaha mu masinagogi ni mu sikukuu mu maeneo gha bhabhaha. ");
INSERT INTO kiz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pia bhilya nyumba sya bhajana bhis'oma maombi matali ili bhanu bha bhabhonayi. Bhanu abha bhibeta kupokela hukumu mbaha.” ");
INSERT INTO kiz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kisha Yesu atumili pasi karibu ni lisanduku lya sadaka mugati mu lihekalu; ajhele ilola bhanu bha bhajhele bhisopa hela sya bhene mu kisanduku. Bhanu bhingi matajiri bhabhekili kiasi kibhaha kya pesa. ");
INSERT INTO kiz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kisha n'dala mjane maskini akahida ni kus'opa fipandi fibhele, thamani jha senti. ");
INSERT INTO kiz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kisha akabhakuta bhanafunzi bha muene ni kubhajobhela, “Muaminiajhi nikabhajobhela, N'dala ojho mjane asopili kiasi kibhaha zaidi jha bhuoha ambabho bhamalikusopa lya sadaka. ");
INSERT INTO kiz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwani bhoha bhasopili kutokana ni bhwingi bhwa mapato gha bhene. Lakini n'dala mjane ojho, kutokana ni umasikini bhwa muene, asopili hela jhioha ambajho alondekeghe kuitumila kwa maisha gha muene.” ");
INSERT INTO kiz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu bho igenda kuh'omela ku lihekalu mmonga ghwa bhanafunzi bha muene akan'kota, “Mwalimu, langayi maganga agha gha kusyangasya ni majengo!” ");
INSERT INTO kiz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Akan'jobhela, ghwilola majengo agha mabhaha? Lijhelepi hata liganga limonga lyalibetakubakila panani pa lenge ambalyo libetakubinisibhwa pasi”. ");
INSERT INTO kiz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na muene bho atamili panani pa kidonda kya Mizeituni kunyuma ku lihekalu, Petro, Yakobo, Yohana ni Andrea bhakan'kota kwa siri, ");
INSERT INTO kiz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tujobhilayi, mambo agha ghibeta kujha ndali? Na kiki dalili gha mambo agha kuh'omela?” ");
INSERT INTO kiz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akajhanda kubhajobhela, “Mujhiajhi makini kwamba asihidi munu kubhapotosya. ");
INSERT INTO kiz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bhingi bhibeta kuhida kwa lihina lya nene bhibeta kujobha, 'Nene ndiye', na bhibetakubhapotosya bhingi. ");
INSERT INTO kiz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pa mwibeta kup'eleka vita ni tetesi sya vita, musitili; mambo agha ghilondeka kuh'omela lakini mwisho bado. ");
INSERT INTO kiz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Taifa libeta kujhinuka kinyume ni litaifa l'enge, ni bhufalme kinyume ni bhufalme. Pibeta kujha ni matetemeku sehemu mbalimbali ni njala. Obho ndo mwanzo ghwa bhutungu. ");
INSERT INTO kiz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mujhelayi mihu. Bhibetakubhapeleka mpaka mabarazani, na mwibetakupingibhwa mu masinagogi. Mwibetakujhemikibhwa mbele jha bhatawala ni bhafalme kwa ndabha jha nene, kama bhushuhuda bhwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lakini injili lazima hoti ihubiribhwayi kwa mataifa ghoha. ");
INSERT INTO kiz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pabhibeta kubhakamula ni kubhakabidhi, musitili kuhusu khela kya mwibeta kujobha. Ndani jha muda obhu, mwibetakupelibhwa kiki kya kujobha; Mwibeta lepi kujha muenga mwilongila, bali Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndugu ibetakun'shtaki ndugu kukomibhwa, Dadi ni mwana munu. Bhana bhibeta kujhama kinyume ni Dadi jhabhi ni kusababisya kukomibhwa. ");
INSERT INTO kiz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mwibetakudadibhwa ni khila munu kwa ndabha jha lihina lya nene. Lakini jha ibetakuvumilila mpaka kumuisu, munu ojhu ibeta kuokoka. ");
INSERT INTO kiz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pamwibetakubhona lichukizo lya bhuharibifu lijhemili pala palilondeka lepi kujhema (jhaisoma na amanyayi), ndipo bhabhajhele mugati mwa Yuda bhajumbililayi kukidonda, ");
INSERT INTO kiz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","nu muene jha ajhele kunani pa nyumba asiseleli pasi pa nyumba, au kutola kyokyoha kyekijhele kwibhala, ");
INSERT INTO kiz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","na jhaajhele kun'gonda asikerebhuki kulota liguanda lya muene. ");
INSERT INTO kiz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lakini ole bhabhi bhadala bha bhajhele ni luleme ni bhabhijhong'esya mu magono aghu! ");
INSERT INTO kiz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mus'omelayi kujha jhisih'omeli wakati bhwa mepu. ");
INSERT INTO kiz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwani pibeta kujha ni malombosi mabhaha, ambagho ghabhwayilepi kuh'omela, kuhomela K'yara abhubhombili bhulimwengu, mpaka henu, ijhelepi, wala jhibetalepi kuh'omela kabhele. ");
INSERT INTO kiz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mpaka Bwana paibetakup'ongosya magono, ghujhelepi mb'ele ghwa ghwibeta kuokoka, lakini kwa ndabha jha bhateule, jhaibeta kubhahagula, ibetakup'ongosya namba sya magono. ");
INSERT INTO kiz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wakati obhu kama munu jhejhioha ibetakubhajobhela, langai, Kristu ajhele apa!' au 'Langai, ajhe pala!' musiamini. ");
INSERT INTO kiz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwani bhakristu bha bhudesi ni manabii bha bhudesi bhibeta kuh'omela ni kulasya ishara ni maajabu ili kwamba, bhabhakofiajhi, yamkini hata bhateule. ");
INSERT INTO kiz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mujhiaji mihu! Nimelikubhajobhela agha ghoha kabla jha bhwakati. ");
INSERT INTO kiz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lakini baada jha mal'ombosi gha magono aghu, lijobha libeta kus'opibhwa ngisi, muesi ghwibeta lepi kupisya mwanga ghwake, ");
INSERT INTO kiz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Matondo ghibeta kubina kuh'omela kunani ni nghofu syasijhele kumbinguni sibetakutikisika. ");
INSERT INTO kiz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ndipo pabhibeta kumbona mwana ghwa Adamu ihida mumabhengu kwa nghofu mbaha ni bhutukufu. ");
INSERT INTO kiz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ndipo paibeta kutuma malaika bha muene na ibeta kubhabhonganya pamonga bhateule bha muene kuh'omela pande mbaha nne sya dunia, kuh'omela mwisho ghwa dunia mpaka mwisho ghwa mbingu. ");
INSERT INTO kiz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kwa mtini mwikimanyisijhi. Kama tawi kyalibhwesya kupisya ni kubheka haraka mat'ondo ghake, ndipo mwibeta kumanya kujha kilolelu kijhe karibu. ");
INSERT INTO kiz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ndo kyajhijhele pamwibetakubhona mambo agha ghih'omela, mumanyayi kujha ajhele karibu, ni malango. ");
INSERT INTO kiz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bhokweli, nikabhajobhela, kizazi ekhe kibetap'etalepi patali kabla mambo agha ghah'omili lepi. ");
INSERT INTO kiz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbingu ni nchi sibeta kup'eta, lakini malobhi ghangu ghibeta lepi kup'eta kamwe. ");
INSERT INTO kiz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lakini kuhusu ligono elu au saa ajhelepi jha ibeta kumanya, hata malaika bha kumbinguni, wala mwana, ila Dadi. ");
INSERT INTO kiz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mujhelayi mihu Langayi, kwa ndabha mumanyilepi ni muda bholoki ghibeta kuh'omela. (zingatilayi: N'sitari obho, “Mujhelayi bhaangalifu, mulangayi na mus'okayi kwa ndabha...” bhujhelepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni kama munu jhailota ku safuari: alekili nyumba jha muene, ni kumbeka n'tumwa ghwa muene kujha ntawala ghwa nyumba, khila mmonga ni mbombo jha muene. Ni kumwamuru mlinzi kutama mihu. ");
INSERT INTO kiz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Henu mujhelayi mihu! kwani mumanyilepi bwana ghwa nyumba pa ibeta kubhujhe kunyumba, jhibhwesekana kimihi kilukya manane, wakati likongobha palibeta kubheka, au lukhela. ");
INSERT INTO kiz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kama ahidili ghafla, asikukoleli ugonili. ");
INSERT INTO kiz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Khela kyanikakijobha kwa bhebhe, nikakijobha kwa kila munu: Mukeshayi”! ");
INSERT INTO kiz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ghajhele magono mabhele tu baada jha sikukuu jha Pasaka ni jha mikate jhajhibeli kusopibhwa chachu. Makuhani bhabhaha ni bhaandishi bhalondeghe namna jha kunkamula Yesu kwa hila hi kwekoma. ");
INSERT INTO kiz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kwa kujha bhajobhili, “Sio bhwakati bhwa sikukuu, bhanu bhasije bhakabhomba ghasia.” ");
INSERT INTO kiz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wakati Yesu ajhele Bethania kunyumba kwa Simoni mkoma, ni bhwakati ilota kumeza, n'dala mmonga akahida kwa muene ni chupa jha marashi gha nardo safi ghaghajhele ni gharama mbaha sana, ajhikaguili chupa ni kujhimimina panani pa mutu ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lakini kwajhele ni baadhi jha bhene bhadadili. Bhajobhisene bhene kwa bhene bhakajobha, “Kiki sababu jha bhopotevu obho? ");
INSERT INTO kiz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Manukato agha ngaghabhwesili kugolesibhwa kwa zaidi jha dinari mia tatu, ni kupelibhwa maskini.” Na bhene bhakan'kemela. ");
INSERT INTO kiz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lakini Yesu akajobha, “Mundekayi muene kwandabha jha kiki mkandombosya? Abhombili khenu kinofu kwa nene. ");
INSERT INTO kiz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Magono ghoha maskini mujhenabhu, ni wakati bhuoha pa mwilonda mwibhwesya kubhomba manofu kwa bhene, lakini mwajhedumu nani wakati bhuoha. ");
INSERT INTO kiz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Abhombili kila kya ibhwesya: Abhubakili mb'ele bhwangu mafuta kwa ndabha jha maziko. ");
INSERT INTO kiz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kweli nikabhajobhela khila mahali injili pajhihubiribhwa mu bhulimwengu bhuoha, khela kya abhombili n'dala ojho kibeta kujobhibhwa kwa ukumbusho ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kisha Yuda Iskariote, mmonga ghwa kumi ni bhabhele, alotili kwa bhabhaha bha makuhani ili kwamba abhwesaijhi kun'kabidhi kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wakati bhabhaha bha makuhani bhobhap'eliki ni kuahidi kumpela hela. Akayanda kulonda nafasi jha kun'kabidhi kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Muligono lya kuanza lya n'kate bhwa bhusopibhulepi chachu, wakati bhapisili mwanakondoo ghwa Pasaka, bhanafunzi bha muene bhakan'jobhela, “Wilonda tulatayi ndaku tukaandalayi ili ubhwesiayi kulya mlo ghwa Pasaka?” ");
INSERT INTO kiz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Abhatumili bhanafunzi bha muene bhabhele ni kubhajobhela, “Mlotayi ku mjini, ni n'gosi ambaye ap'endili kibhegha ibeta kubhonana namu. Mun'kesiajhi. ");
INSERT INTO kiz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nyumba jha ibeta kujhingila, mun'kesiajhi na mun'jobhilayi n'kolo nyumba ejhu, 'Mwalimu ijobha, “kyendaku chumba kya bhahesya mahali pa nibeta kulya Pasaka ni bhanafunzi bhangu?” ");
INSERT INTO kiz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Akabhalasya chumba kya kunena kibhaha kya kijhele ni samani ambakyo kijhele tayari. Mubhombayi maandalizi kwa ndabha jha tete pala.” ");
INSERT INTO kiz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bhanafunzi bhakabhoka kulota kumjini; bhakolili khila khenu kama kya abhajobhili, ni kuandala mlo ghwa Pasaka. ");
INSERT INTO kiz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wakati jhifikili kimihi, akahida ni bhala kumi ni bhabhele. ");
INSERT INTO kiz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na bhobhakajhikaribila meza ni kulya, Yesu akajobha, “Kweli nikabhajobhela mmonga jha ilya pamonga nani ibeta kunisaliti.” ");
INSERT INTO kiz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bhoha bhasikitika, ni mmonga baada jha jhongi bhakan'jobhela, “Hakika nene lepi?” ");
INSERT INTO kiz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu abhajibili ni kubhajobhela, “Ni mmonga kati jha kumi ni bhabhele kati jha jhomu, mmonga ambaj'he henu ijhina nongi mu bakuli pamonga ni nene. ");
INSERT INTO kiz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kwa kujha mwana ghwa Adamu ibetakulota kama vile maandiku kyaghijobha juu jha muene. lakini ole bhwake munu jhola ambajhe kup'etela muene mwana ghwa Adamu ibetakusalitibhwa! Ngajhijhele kinofu zaidi kwa muene kama munu jhola ngaabeleghe kuhogoleka.” ");
INSERT INTO kiz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na wakati bhilya, Yesu atolili nkate akabhubariki, ni kubhu metula. Abhapelili akajobha, “Mutolayi. Obho ndo mb'ele bhwangu.” ");
INSERT INTO kiz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Atolili kikombi, ashukuili, ni kubhap'ela, na bhoha bhanywelili. ");
INSERT INTO kiz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Abhajobhili, “Ejhe ndo lilopa lya nene lya agano, lilopa lya libeta kujhitika kwa ndabha jha bhingi. ");
INSERT INTO kiz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kweli nikabhajobhela, nibetalepi kunywa kabhele mu lizao ele lya mzabibu mpaka ligono lela panibeta kunywa mpya mu bhufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bho bhamalili kujhemba nyembu bhalotili kwibhala ku Kid'onda kya Mizeituni. ");
INSERT INTO kiz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu abhajobhili, Muenga mwebhoha mwilota kwitenga patali kwa ndabha jha nene, kwa kujha jhitembibhu, 'Nibeta kun'tobha mchungaji ni kondoo bhibeta kutabhwanyika.' ");
INSERT INTO kiz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini baada jha kufufuka kwa nene, nibetakubhalongolela palongolo pa jhomu Galilaya.” ");
INSERT INTO kiz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro an'jobhili, “Hata kama bhoha bhibetakuleka, nene nikupela lepi.” ");
INSERT INTO kiz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu an'jobhili, “Kweli nikujobhela, pakilu apa, kabla jha likongobhe kubheka mara sibhele, ghwibetakujha unibelili mara sidatu.” ");
INSERT INTO kiz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petro akajobha, “Hata jhibetakunilazimu kufwa pamonga nabhu, nikubela lepi. “Bhola bhapisili ahadi jhela jhela. ");
INSERT INTO kiz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhakahida pa lieneo lyalikutibhwa Gethsemane ni Yesu akabhajobhela bhanafunzi bha muene, “Mutamanyi apa wakati ni sali.” ");
INSERT INTO kiz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Abhatolili Petro, Yakobo, ni Yohana pamonga ni muene, akayanda kuhuzunika ni kutaabika sana. ");
INSERT INTO kiz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Abhajobhili, “Ntema bhwangu bhujheni huzuni sana, hata kufwa. Mubakilayi apa na Mukeshayi”.” ");
INSERT INTO kiz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu akalota palongolo kidogo, akabina pasi, akas'oma, kama jhibhwesekana, kujha saa ejhe ngajhinjhepwiki. ");
INSERT INTO kiz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ajobhili, “Aba, Dadi, Mambo ghoha kwa bhebhe ghibhwesekana. Nibhosilayi kikombi ekhe. Lakini sio kwa mapenzi gha nene, bali mapenzi gha bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Akakerebhuka ni kubhakolela bhagonili, na akan'jobhela Petro, “Simoni, je ugonili? Ubhwesilepi kukesha hata lisaa limonga? ");
INSERT INTO kiz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mukeshayi na ms'omayi musihidi kujhingila mu majaribu. Hakika roho i radhi, lakini ni mb'ele ndo dhaifu.” ");
INSERT INTO kiz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Alotili kabhele ni kus'oma, na atumili malobhi ghalaghala. ");
INSERT INTO kiz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ahidili kabhele abhakolili bhagonili, kwa kujha mihu gha bhene gha jhele masitu na bhamanyilepi kiki kya kun'jobhela. ");
INSERT INTO kiz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Akahida mara jha tatu ni kubhajobhela, “Bado mugonili ni kup'omoseka? Jhitosya saa jhifikili. Langayi! Mwana ghwa Adamu isalitibhwa mu mabhoko gha bhenye dhambi. ");
INSERT INTO kiz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mujhumukayi, tubhoki. Langayi, jhola jhaibetakunisaliti ikaribila.” ");
INSERT INTO kiz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mara tu bho akona ilongela, Yuda, mmonga ghwa bhala kumi ni bhabhele, afikili, ni likundi libhaha lya bhanu kuh'omela kwa bhabhaha bha makuhani, bhaandishi ni bhaseya bhenye mapanga ni mabonga. ");
INSERT INTO kiz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wakati obhu nsaliti ghwa muene ajhele amalili kubhapela ishara, akajobha, jhola jhanibetakumbusu, ndijhe. Munkamulayi ni kundongosya pasi, pa bhulinzi.” ");
INSERT INTO kiz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wakati Yuda bho afikili, moja kwa moja akalota kwa Yesu ni kujobha, “Ni kumbusu. ");
INSERT INTO kiz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kisha bhakambeka chini jha ulinzi ni kun'kamula. ");
INSERT INTO kiz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lakini mmonga kati jha bhene jha ajhemili karibu naku achomuili bhupanga bhwa muene akan'tobha n'tumishi ghwa kuhani mbaha ni kun'dumula mb'olokoto. ");
INSERT INTO kiz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu akan'jobhela, “Muhidili kunikamula kwa mapanga ni mabonga kama mnyang'anyi? ");
INSERT INTO kiz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wakati khila ligono najhele pamonga namu ni kufundisya hekaluni, mwanikamuili lepi. Lakini ele libhombiki ili maandiku ghatimilayi. ");
INSERT INTO kiz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ni bhala bhoha bhabhajhe ni Yesu bhakandeka bhakayanda kujumba. ");
INSERT INTO kiz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","N'songolo mmonga anfwatili jhaafwatili lishuka tu jha akifwekili kun'syong'hoka; bhan'kamuili lakini ");
INSERT INTO kiz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","abhaponyuiki akalileka lishuka pala akajumba ngoli. ");
INSERT INTO kiz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bhandongwisi Yesu kwa kuhani mbaha. Pala bhakusanyiki pamonga ni muene makuhani bhabhaha bhoha, bhaseya ni bhaandishi. ");
INSERT INTO kiz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro ni muene akan'kesya Yesu kwa patali, kulotela mu ua bhwa kuhani mbaha. Atamili pamonga ni bhalinzi bhabhajhele karibu ni muoto bhijhota ili kukabha joto. ");
INSERT INTO kiz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wakati obhu makuhani bhabhaha bhoha ni libaraza lyoha bhajhele bhilonda bhushahidi dhidi jha Yesu ili bhabhwesiayi kun'koma. Lakini bhaukabhilepi. ");
INSERT INTO kiz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kwa kujha bhanu bhingi bhabetili bhushahidi bhwa bhudesi dhidi jha muene, lakini hata ushaidi bhwa bhene bhwawaningene lepi. ");
INSERT INTO kiz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Baadhi bhajhemili ni kuleta bhushahidi bhwa bhudesi dhidi jha bhene; bhakajhabhijobha, ");
INSERT INTO kiz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Twamp'eliki ijobha, 'Nibetakuliharibu lihekalu ele lya litengenesibhu kwa mabhoko, ni ndani jha magono madatu nikalijenga l'enge lya lijengibhu lepi kwa mabhoko.”' ");
INSERT INTO kiz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lakini hata bhushahidi bhwa bhene bhwawaningene lepi. ");
INSERT INTO kiz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kuhani mbaha akajhema katikati jha bhene ni kun'kota Yesu,”Je, ujhelepi ni lijibu? Bhanu abha bhushudila kiki dhidi jha bhebhe?” ");
INSERT INTO kiz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini atamili kinunu na ajibilepi kyokioha khela. Mara kuhani mbaha akan'kota kabhele, “Je bhebhe ndo Kristu, mwana ghwa Mbarikiwa?” ");
INSERT INTO kiz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akajobha, “Nene ena. Na ghwibetakumbona Mwana ghwa Adamu atamili kibhoko Kya kulia bhwa nghofu ihida ni mmabhengu gha mbinguni.” ");
INSERT INTO kiz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kuhani mbaha araruili maguanda gha muene ni kujobha, “Je wakona wilonda mashahidi? ");
INSERT INTO kiz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mup'eliki kufuru. Bhuamuzi bhwa muenga bholoki?” Na bhoha bhan'hukumuili kama mmonga jhailondeka kufwa. ");
INSERT INTO kiz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Baadhi bhakajhanda kun'funyila mata ni kun'gupika pa mihu ni kun'tobha ni kun'jobhela, “Tabiriayi!” Maafisa bhan'tolili ni kun'tobha. ");
INSERT INTO kiz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ni Petro bho ajhe akona ajhe pasi pa lufuka, mtumishi mmonga ghwa bhadala bha kuhani mbaha akahida kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ambwene Petro pa ajhemili ijhota muoto, na andangili ni kun'hegerela. Kisha akajobha, “Nabhi pia ghwajhele ni Mnazareti, Yesu”. ");
INSERT INTO kiz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini abelili, akajobha, “Nimanyilepi wala nijhelebhwa lepi kuhusu khela kya wijobha!” Kisha akabhoka akalota kwibhala pa lufuka. ");
INSERT INTO kiz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lakini n'tumishi ghwa kidala pala, ambwene na ajhandili kun'jobhela kabhele bhala ambabho bhajhele bhajhemili pala, “Munu ojho ni mmonga kati jha bhene!” ");
INSERT INTO kiz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lakini abelili kabhele. Baadaye kidogo bhala bhabhajhemili pala bhan'jobhili Petro, “Hakika bhebhe ndo mmonga kati jha bhene, kwa ndabha bhebhe pia wa Mgalilaya.” ");
INSERT INTO kiz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lakini akayanda kwibheka muene pasi jha laana ni kulapa, “Nimanyilepi munu ojhu jha mwikanijobhela.” ");
INSERT INTO kiz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kisha likongobhe lyabhekili kabhele mara jha pili. Kisha Petro akhombwiki malobhi ambagho Yesu ghaan'jobhili: “Kabla jha likongobhe kubheka mara mbili wibetakunibela mara sidat.” Na abinili pasi ni kulela. ");
INSERT INTO kiz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lubhuliku bhabhaha bha makuhani bhabhonene pamonga ni bhaseya ni bhaandishi ni libaraza lyoha lya bhaseya. Kisha bhakan'kota, “Bhebhe ndo Mfalme ghwa bhayahudi?” ");
INSERT INTO kiz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Akan'jibu, “Bhebhe ujobhili naha.” ");
INSERT INTO kiz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bhabhabha makuhani bhakajhelesya mashitaka mingi juu jha Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato akan'kota kabhele, “Ghwijibhu lepi kyokyoha? Ghwilola lepi kya bhikushitaki kwa mambo mingi? ");
INSERT INTO kiz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu an'jibilepi Pilato, ni hiyo jhan'syangese. ");
INSERT INTO kiz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kwa kawaida wakati bhwa sikukuu ibhopolibhwa mfungwa mmonga, mfungwa jhabhans'oili. ");
INSERT INTO kiz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bhajhele bhahalifu gerezani, miongoni mwa bhauaji bhabhamali kuasi bhabhitumikila makosa gha bhene. Ajhele munu mmonga jhaikutibhwa Baraba. ");
INSERT INTO kiz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Umati ukahida kwa Pilato, ni kun'jobhela abhombayi kama kyaabhombili kunyuma. ");
INSERT INTO kiz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato akabhajibu ni kujobha, mwilonda nibhafungulilayi Mfalme ghwa bhayahudi?” ");
INSERT INTO kiz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kwa kujha amanyili ni kwa ndabha jha wivu ghwa bhabhaha bha makuhani bhabhan'kamuili Yesu ni kundeta kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini bhabhaha bha makuhani bhachochili umati kujhuegha kwa sauti kujha abhopolibhwayi Baraba badala jha muene. ");
INSERT INTO kiz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato akabhajibu kabhele ni kujobha, “Nin'ketayi kiki Mfalme ghwa bhayahudi? ");
INSERT INTO kiz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bhakapiga kelele kabhele, Nsulubisighi!” ");
INSERT INTO kiz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato Akajobha, “Abhombili lijambo leleku libhibhi?” Lakini bhazidili kupiga kelele zaidi ni zaidi “Nsulubisiayi.” ");
INSERT INTO kiz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato akabhuridhisha bhumati, akabhafungulila Baraba. Akan'tobha Yesu mijeledi kisha akambosya ili asulubibhwayi. ");
INSERT INTO kiz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Askari andongwisi hadi mugati mu lufuka (bhola bhwa bhajhele mugati mu kambi) na bhakibhongeniye pamonga kikosi kya Askari. ");
INSERT INTO kiz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakamfwatika Yesu liguanda lya rangi jha zambarau, na bhasokwiti litaji lya mifwa bhakamfwatika. ");
INSERT INTO kiz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakajhanda kundhihaki ni kujobha, “Salam, Mfalme ghwa bhayahudi!” ");
INSERT INTO kiz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakan'komalela kumutu kwa lilasi ni kunfunyila mata. Bhakapiga magoti mbele jha muene kwa kun'heshimu. ");
INSERT INTO kiz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bhobhamalili kundhihaki, bhakamfula likanzu lela lya rangi jha zambarau ni kumfwatika maguanda gha muene, ni kumpisya kwibhala kulota kunsulubisya. ");
INSERT INTO kiz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bhakandasimisya mp'eta njela kun'tangatila, jhaajhele ijhingila kumjini kuh'omela kun'gonda. Akutibhweghe Simon Mkirene (Dadi munu Iskanda ni Rufo); Bhakandasimisya kup'enda n'salaba ghwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Askari bhampeliki Yesu mahali papikutibhwa Goligotha (maana jha tafsiri ejhe ndo, sehemu jha fuvu lya mutu). ");
INSERT INTO kiz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhakampela mvinyo bhwa bhuchanganyibhu ni manemane, lakini anywilepi. ");
INSERT INTO kiz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bhakan'sulubisya ni kugabhana maguanda gha muene bhakaghapigila kura kuamula kipandi kyaibeta kukabha khila askari. ");
INSERT INTO kiz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jhikaya saa tatu lukhela bhan'sulubisi. ");
INSERT INTO kiz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhakabheka panani pa muene ubao bhwabhujhandikibhu shitaka, “Mfalme ghwa. bhayahudi.” ");
INSERT INTO kiz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhan'sulubisi pamonga ni majambazi bhabhele, mmonga lubhafu lwa muene lwa kulia ni jhongi lubhafu lwa kushoto kwa muene. ");
INSERT INTO kiz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Zingatilayi: Mstari obho, “Ni mayandiku ghakatimila ghaghane nibhu” bhujha lepi mu nakala sya muandi). ");
INSERT INTO kiz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ni bhene bhakajhabhip'eta bhakandigha bhakajha bhihugusya mitu ghya bhene ni kujobha, “Aha! bhebhe jhaghwibeta kubomola hekalu ni kulijenga kwa magono madatu, ");
INSERT INTO kiz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ukiokolayi ghwajhobhi na uselelayi pasi kuh'omela pa n'salaba apu!” ");
INSERT INTO kiz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kwa namna jhelajhela bhabhaha bha makuhani bhandhihakili ni kujobhesana, pamonga ni bhaandishi ni kujobha, “Abhaokuili bhangi, lakini ibhwesyalepi kuiokola muene. ");
INSERT INTO kiz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristu Mfalme ghwa Israel, selelayi pasi henu kuh'omela pa n'salaba, ili tubhwesijhi kulola ni kuamini.” Ni bhala bha bhasulubibhu pamonga ni muene pia bhandhihakili. ");
INSERT INTO kiz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bhojhifikili saa sita, giza likahida kunani jha nchi jhioha hadi saa tisa. ");
INSERT INTO kiz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wakati ghwa saa tisa, Yesu apigili kelele kwa sauti mbaha, “Eloi, Eloi, lama sabaktani?” jhimaanisya “k'yara ghwangu, K'yara ghwangu, kwa ndabha jha kiki undekili?” ");
INSERT INTO kiz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Baadhi jha abhu bhabhajhemili bho bhap'ehki bhakajobha, “Langayi, akan'kuta Eliya.” ");
INSERT INTO kiz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munu mmonga akajumba akamemesya siki mu sponji ni kujhibheka panani pa libehe lya lilasi, akampela ili anyuayi. Munu mmonga akajobha, “Lendayi tuloli kama Eliya ibetakun'selesya pasi.” ");
INSERT INTO kiz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kisha Yesu akalela kwa sauti mbaha ni kufwa. ");
INSERT INTO kiz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lipazia lya hekalu likagabhwanyika fipandi fibhele kuhomela kunani mpaka pasi. ");
INSERT INTO kiz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ofisa mmonga jha ajhemili kundanga Yesu, bhoabhuene afuili kwa jinsi jhela, akajobha, “Kweli munu ojho ajhele mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhajhele pia bhadala ambabho bhalangeghe kwa patali. Miongoni mwa bhene ajhele Mariamu Magdalena, Mariamu (nyinamunu Yakobo n'debe ghwa Yose), ni Salome. ");
INSERT INTO kiz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wakati bhajhele Galilaya bhan'kesisi ni kuntumikila. Ni bhadala bhangi bhingi pia bhaambatene naku hadi Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bhokijhingili kimihi, ni kwa kujha jhajhele ligono lya maandalio, ligono kabla ya sabato, ");
INSERT INTO kiz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu ni Arimathaya akahida pala. Ajhele mjumbe ghwa baraza jhaiheshimibhwa munu jha autarajili bhufalme bhwa K'yara. Kwa ujasiri akalota kwa Pilato, ");
INSERT INTO kiz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ni kubhusoma mb'ele ghwa Yesu. Pilato akayangasibhwa kujha Yesu tayari amalikufwa; akan'kuta jhola afisa ni kun'kota kama Yesu tayari amalikufwa. ");
INSERT INTO kiz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bhoakabhili bhuhakika kwa afisa kujha Yesu tayari amalikufwa anduhuswiri Yusufu kuutola mb'ele. ");
INSERT INTO kiz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu ajhele tayari amalikugola sanda. Akan'selesya kuhomela pa n'salaba, akan'konga kwa sanda hi kumbeka mugati mu likaburi lyalagimibhu mu muamba. Kisha aliviringisi liganga lela pa ndiangu ghwa likaburi. ");
INSERT INTO kiz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariamu Magdalena ni Mariamu nyinamunu Yose bhebhuene sehemu jha asyelibhu Yesu. ");
INSERT INTO kiz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wakati sabato jhimaliki, Mariamu Magdalena ni Mariamu nyinamunu ni Yakobo, ni Salome, bhahemili manukato manofu, ili bhabhwesiajhi kuhida ni kubhubaka mafuta mb'ele ghwa Yesu kwa ndabha jha maziku. ");
INSERT INTO kiz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lubhuliku ligono lya kuanza jha juma, bhakalota kulikaburi wakati lijobha lih'omili. ");
INSERT INTO kiz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bhakajha bhijobhesana bhene kwa bhene, “Niani ibetakuliviringisya liganga kwa ndabha jha tete ili tujhingilayi mu likaburi?” ");
INSERT INTO kiz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wakati bhalolili bhambwene munu tayari amalili kulibelendusya liganga, ambalyo lyajhele libhaha sana. ");
INSERT INTO kiz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bhakajhingila mu likaburi na bhambwene n'songolo afwalili lijoho libhalafu, atamili lubhafu lwa kulia na bhasyangele. ");
INSERT INTO kiz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akabhajobhela, “Musilili. Mukandonda Yesu, ghwa Nazareti, jhaasulubibhu. Afufuiki! Ajhelepi apa. Langayi mahali pala pa bhambekili. ");
INSERT INTO kiz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mulotayi, mukabhajobhilayi bhanafunzi bha muene ni Petro jha kujha abhalongolili kulota Galilaya. Okhu mwibetakumbona, Kama kyaabhajobhili.” ");
INSERT INTO kiz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bhakabhoka ni kujumba kuhoma mu likaburi; bhatetemiki na bhasyangesibhu. Bhajobhilepi kyokyoha kwa munu jhojhioha ndabha bhatilili sana. ");
INSERT INTO kiz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Manyata ligono lya kuanza lya juma, baada jha kufufuka an'tokili hosi Mariamu Magdalena, ambajhe kuh'omela kwa muene ambosisi mapepo saba. ");
INSERT INTO kiz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Abhokili ni kubhajobhela bhala ambabho bhajhele pamonga naku, wakati bhihuzunika ni kupisya mahosi. ");
INSERT INTO kiz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bhap'eliki kujha n'sima na abhonekene ni muene, lakini bhabeli kumwamini. ");
INSERT INTO kiz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baada jha aghu akakitokesya kwa namna tofauti tofauti kwa bhangi bhabhele kabhele, wakati bhigenda kuhomela mu nchi. ");
INSERT INTO kiz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bhakalota kubhajobhela bhanafunzi bha muene bhangi bha bhabhabakili, lakini bhabelikubhaamini. ");
INSERT INTO kiz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu baadaye akakih'omesya kwa bhala kumi na moja bho bhajhegheme mu meza, ni kubhakemela kwa kutokuamini kwa bhene ni bhunonono bhwa mioyo, kwa ndabha bhabelikubhaamini bhala bhabhambwene baada jha kufufuka kuh'omela kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Akabhajobhela, “Mulotayi ku bhulimwengu bhuoha, ni kuhubiri injili kwa viumbe fyoha. ");
INSERT INTO kiz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yejhioha jhaibetakuamini ni kubatisibhwa ibetakuokolibhwa, ni jhola jhaibetalepi kuamini ibetakuhukumulibhwa. ");
INSERT INTO kiz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ishara e'se sibetakuambatana ni bhoha bha bhiamini. Kwa lihina lya nene bhibetakubhosya pepo. Bhibetakujobha kwa lugha mpya. ");
INSERT INTO kiz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bhibetakukamula lijhoka kwa mabhoko gha bhene, na hata Kama bhanywili khenu kyokioha kya kufisha kibetalepi kubhadhuru. Bhibeta kukabha mabhoko kwa bhatamu, na bhene bhibetakujha bhasima”. ");
INSERT INTO kiz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Baada jha Bwana kujobha nabhu, ibetakutolibhwa kunani kumbinguni ni kutama kibhoko kya kulia kya K'yara. ");
INSERT INTO kiz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bhanafunzi bhakabhoka ni kuhubiri khila mahali, wakati Bwana ibhomba mbombo nabhu ni kulithibitisya lilobhi kwa miujiza ni ishara sibetakulongosana nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bhamehele bhakitahidi kubheka simulizi mpangilio kuhusu masuala ambagho ghatimisibhu kati jhitu, ");
INSERT INTO kiz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kama kyabhatupelili tete, ambabho kuhomela kubhuandu twajhele mashahidi bha mihu ni bhatumishi bha bhajumbe. ");
INSERT INTO kiz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hivyo ni nene kabhele, baada jha kuchungusya kwa uangalifu chanzo kya mambo ghoha agha kuhoma kubhuandu - nibhuene ni kinofu kwa nene kabhele kukuj'handikila mu mpangilio bhuake - mheshimibhwa Theofilo. ");
INSERT INTO kiz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ili kwamba abhwesiajhi kumanya ukweli ghwa mambo ghaufundisibhu. ");
INSERT INTO kiz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Katika magono gha Herode, mfalme ghwa Yudea, pajhele ni kuhani fulani jhaakutibhweghe Zakaria, bhwa lukholo lwa Abiya. N'dala munu ahomili mu bhabinti bha Haruni, ni lihina lya muene akutibhweghe Elizabeth. ");
INSERT INTO kiz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bhoha bhajhele ni haki mbele sya k'yara; Bhagendili bila lawama mu amri syoha ni malagisu gha Bwana. ");
INSERT INTO kiz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lakini bhajhelepi ni muana, kwandabha Elizabeth ajhe tasa, ni kwa wakati obho bhuoha bhoha bhabhele bhajhele bhaseya sana. ");
INSERT INTO kiz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Henu jhatokili kujha Zakaria ajhele ku uwepo bhwa K'yara, akajhendelela ni wajibu bhwa kikuhani ku utaratibu bhwa zamu jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kulengana ni desturi jha kuchagula ndo kuhani jholekhu jhaibetakuhudumu, jha ahagulibhu kwa kura kujhingila mu hekalu lya Bwana ni kabhele ngaafukizi uvumba. ");
INSERT INTO kiz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Likundi lyoha lya bhanu likajha lis'oka kwibhala wakati bhwa kufukizibhwa kwa uvumba. ");
INSERT INTO kiz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Henu malaika bha Bwana bhan'tokili ni kujhenia lubhafu lwa kulia bhwa madhabahu gha kufukizila. ");
INSERT INTO kiz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria atishiki bho ambwene; hofu jhambinili. ");
INSERT INTO kiz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini malaika akan'jobhela, “Usitili Zakaria, kwandabha maombi gha jhobhi nighap'eliki. N'dala bhu Elizabeth ibeta kuhogola mwana. Lihina lya muene wibetakun'kuta Yohana. ");
INSERT INTO kiz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wibetakujha ni furaha ni uchangamfu, ni bhingi bhibeta kuhobhokela kuhogoleka kwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwa kujha wibetakujha wembahe pa mihu gha Bwana. Ibetalepi kunywa divai wala kinywaji kikali, na ibeta kujha ajasibhu ni Roho mtakatifu kuhomela mu lileme lya nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ni bhanu bhingi bha Israel bhibeta kugeusibhwa kwa Bwana k'yara ghwa bhene. ");
INSERT INTO kiz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ibeta kulota palongolo pa mihu pa Bwana ku Roho ni nghofu sya Eliya. Ibeta kubhomba naha ili kukerebhusya mioyo ghya Dadi kwa bhana, ili kwamba bhabhibela kutii bhibeta kulota mu hekima jha bhenye haki. Ibeta kubhomba naha ili kubheka tayari kwa Bwana bhanu ambabho bhaandalibhu kwa ndabha jha muene.” ");
INSERT INTO kiz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria akan'jobhela malaika, “Nibetakubhwesya bhuli kumanya ele? kwandabha nene ne n'seya ni n'dala bhangu miaka ghya muene ghimehele sana.” ");
INSERT INTO kiz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika ajibili ni kun'jobhela, “Nene ne Gabrili, ambajhe nijhema palongolo pa K'yara. Nalaghisibhu kukujobhela, kukuletela habari ejhe njema. ");
INSERT INTO kiz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na langayi, wibetalepi kulongela, wibetakujha kununu, wibetalepi kulongela mpaka ligono lela mambo agha pa ghibeta kuhomela. Ejhe Kwandabha ghwa shindilu kukiera malobhi ghangu ambagho ghibeta kutimisibhwa kwa wakati mwafaka.” ");
INSERT INTO kiz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Henu bhanu bhakajha bhakandela Zakaria. Bhasyangesibhu kujha ajhele itumila muda ghumehele mu hekalu. ");
INSERT INTO kiz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lakini bho ahomili kwibhala, abhwesilepi kulongela nabhu. Bhakatambula kujha ibeta kujha akabhili maono bho ajhe mu hekalu. Ajhendelili kulasya ishara ni kubakila kinunu. ");
INSERT INTO kiz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ikatokela kwamba lgono lya huduma jha muene bhosimaliki kukerebhuka kunyumba jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baada jha Zakaria kukerebhuka kunyumba kuhoma ku huduma jha muene jhe hekalu, n'dala munu ajhe ni luleme. Ni muene abhokilepi panyumba jha muene kwa muda bhwa miezi mitano. Akajobha, ");
INSERT INTO kiz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ele ndo Bwana alibhombi kwa nene bho anilangili kwa upendeleo ili kujhibhosya soni jha nene palongolo pa bhanu.” ");
INSERT INTO kiz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Henu, pa mwesi ghwa sita bhwa luleme lwa Elizabeth, k'yara an'jobhili malaika Gabrieli kulota ku mji ghwa Galilaya bhwawikutibhwa Nazareti, ");
INSERT INTO kiz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kwa bikra jha aposibhu ni n'gosi ambajhe lihina lya muene lyajhele Yusufu. Muene ajhele bhwa lukholo lwa Daudi, ni lihina lya bikra ojhu ajhele Mariamu. ");
INSERT INTO kiz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Akahida kwa muene ni kujobha, “salaam, bhebhe jhe upokili neema mbaha! Bwana apendisibhu nabhi” ");
INSERT INTO kiz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lakini malobhi gha malaika ghan'changenye na ajhelibhu lepi kwandabha jha kiki malaika ajobhili salaam ejhe jha ajabu kwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika akan'jobhela, “Usitili, Mariamu, kwandabha ukabhili neema kuhoma kwa k'yara. ");
INSERT INTO kiz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na langayi, na wibeta kuhogola muana. Ni bhebhe wibetakun'kuta lihina lya muene 'Yesu.' ");
INSERT INTO kiz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ibeta kujha mbaha ne ibeta kukutibhwa mwana jha ajhee panani sana. Bwana k'yara ibeta kump'ela kiti kya enzi kya Daudi dadimunu. ");
INSERT INTO kiz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ibeta kutawala panani pa lukholo lwa Yakobo milele ni ufalme bhwa muene wibetalepi kujha ni mwisho. ");
INSERT INTO kiz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariamu akan'jobhela malaika, e'le libetakutokela kwa muda gani, ndabha nibhwajhi lepi kugona ni n'gosi jhejhioha? ");
INSERT INTO kiz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika ajibili ni kun'jobhela, “Roho mtakatifu ibeta kuhidila juu jha bhebhe, ni nghofu jha ajhekunani sana jhibeta kuhida panani pa bhebhe. kwa hiyo, mtakatifu jha ibeta kuhogoleka ibeta kukutibhwa mwana ghwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na langayi, ndongo bhu Elizabeth ajhe ni luleme lwa mwana mu umri bhwa muene bhwa useya. Obho ndo mwesu ghwa sita kwa muene, ambajhe ambajhe akutibhweghe mgumba. ");
INSERT INTO kiz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwandabha lijhelepi libeta kubwesekana kwa k'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariamu akajobha, “Langayi, nene na n'tumishi n'dala ghwa Bwana. Lekajhi jhijhelayi naha kwa nene sawasawa ni ujumbe bhwa jhobhi.” Kisha malaika akandeka. ");
INSERT INTO kiz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ndipo katika magono aghu Mariamu abhokili manyata alotili ku nchi jha vilima, ku mji katika nchi jha Yudea. ");
INSERT INTO kiz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Alotili munyumba jha Zakaria ni kumponesya Elizabeth. ");
INSERT INTO kiz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bho ap'eliki salamu jha Mariamu, muana mulileme lya muene arukili, ni Elizabeth akamemesibhwa ni Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Apazili sauti jha muene ni kujobha kwa sauti mbaha, “ubarikibhu bhebhe zaidi miongoni mwa bhadala, ni muana jha ajhele mu lileme lya jhobhi abarikibhu. ");
INSERT INTO kiz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na jhijhebhuli kwa nene kujha, mabhu ghwa Bwana bhangu jhilondekaghe ahidayi kwa nene? ");
INSERT INTO kiz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kwa kujha langayi, bhojhipelekiki mie mb'olokhoto mwa nene sauti jha kuponesya kwa jhobhi, muana mulileme lya nene aruki kwa furaha. ");
INSERT INTO kiz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na abarikibhu n'dala jhola ambajhe akyeriri jha kujha ngeuhomili ukamilifu bhwa mambo ghala ghaajobhibhu kuhoma kwa Bwana.” ");
INSERT INTO kiz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamu akajobha, nafsi jha nene jhikan'sifu Bwana, ");
INSERT INTO kiz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ni roho jha nene jhibiobhwiki kwa k'yara mwokozi ghwangu. ");
INSERT INTO kiz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwandabha ajhilangili hali jha pasi jha n'tumishi bhwa muene n'dala. Langayi, tangu henu mu fizazi fyoha bhibeta kunikuta mbarikibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwandabha muene jha ajhe muweza abhombi mambo mabhaha kwa nene, ni lihina lya muene ni takatifu. ");
INSERT INTO kiz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Rehema jha muene jhidumu kuh'oma kizazi hadi kizazi kwa bhale bhabhaken'heshimu muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Alasili nghofo kwa kibhoko kya muene; abhatawenye bhela bhabhikifuneghe panani pa mabhwasu gha mioyo ghya bhene. ");
INSERT INTO kiz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhaselisi pasi bhana bha bhafalme kuhoma pa fiti fya bhene fya enzi ni kubhajhinula panani bhabhejhele bha hali jha pasi. ");
INSERT INTO kiz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abheshibishi bhenye njala kwa fenu finofu, bali matajiri abhabhengili mabhoko mat'opu. ");
INSERT INTO kiz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ahomisi msaada kwa Israeli n'tumishi ghwa muene, ili kukhomboka kulasya rehema. ");
INSERT INTO kiz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Kama kyaajobhili kwa bhadadi jhitu) kwa Abrahamu ni uzao bhwa muene milele.” ");
INSERT INTO kiz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariamu atamili ni Elizabeth yapata miesi midatu efe ndo akakerebhuka kunyumba jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Henu wakati bhwajhele uwadili kwa Elizabeth kwifungula mwana bhwa muene ni kwifungula mwana ghwa kigosi. ");
INSERT INTO kiz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Majirani bha muene ni bhalongo munu bhap'eliki jinsi Bwana kya ajhikuzili rehema kwa muene, na bhahobhwiki pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Henu jhatokili ligono lya nane kwamba bhahidili kun'tahiri muana. Jhilondekaghe kun'kuta lihina lya muene, “Zekaria,” kwa kuzingatila lihina lya Dadimunu, ");
INSERT INTO kiz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lakini nyinamunu ajibili ni kujobhoha, “Lepi; ibeta kukutibhwa Yohana.” ");
INSERT INTO kiz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhakan'jobhela ajhelepi hata mmonga kwa bhalongobhu jhaikutibhwa kwa lihina e'le.” ");
INSERT INTO kiz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bhakambombela ishara Dadimunu kuashiria muene alondeghe lihina akutibhwayi niani. ");
INSERT INTO kiz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dadi munu alondeghe kibao kya kulembela, na akalemba, “Lihina lya muene Yohana.” Bhoha bhasyangesibhu ni e'le. ");
INSERT INTO kiz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ghafla ndomo ghwa muene ghwafungulibhu ni lumilu lwa muene lwajhele huru. Akalongela ni kun'sifu k'yara. ");
INSERT INTO kiz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hofu jhikabhahidila bhoha bhabhaishieghe karibu nabhu. Mambo agha ghakaenela mu nchi jhioha jha vilima vya Yudea. ");
INSERT INTO kiz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na bhoha bhabhap'eliki bhaghatunzili mu mioyo ghya bhene, bhakajobha, “Muana ojho kujha ghwa namna jheleku?” kwandabha kibhoko kya Bwana kyajhele pamonga naku. ");
INSERT INTO kiz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dadimunu Zekaria amemesibhu ni Roho mtakatifu na ahomisi unabii, akajobha, ");
INSERT INTO kiz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Asifibhwayi Bwana, k'yara ghwa Israeli, kwandabha asaidili na ashughulikili wokovu bhwa bhanu bha muene. ");
INSERT INTO kiz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atujhimelili pembe jha wokovu mu nyumba jha mtumishi bhwa muene Daudi, kuh'oma miongoni mwa mtumishi bhwa muene Daudi, ");
INSERT INTO kiz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kama kyaajobhili kwa kinywa kya manabii bha muene bhabhajhele kuhoma muandi. ");
INSERT INTO kiz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ibeta kutuokola kuhoma kwa bhaadui bhitu ni kuhoma mumabhoko gha bhoha bha bhatudadili. ");
INSERT INTO kiz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ibeta kubhomba naha kulasya rehema kwa Dadi jhitu ni kukhomboka agano lya muene takatifu, ");
INSERT INTO kiz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kiapo kyaajobhili kwa Abrahamu Dadi jhitu. ");
INSERT INTO kiz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Alapili kuthibitisya kwamba ngajhibhwesekene kun'tumikila muene bila bhuogha baada jha kuokolebhwa kuhoma mu mabhoko jha maadui bhitu. ");
INSERT INTO kiz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mu utakatifu ni haki palongolo pa tete magono ghitu ghoha. ");
INSERT INTO kiz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ena, ni nabii ghwa ajhele panani sana, kwa kujha wibetakulota palongolo pa mihu pa Bwana ili kubhajhendalila njela, kubhaandala bhanu kwa ndabha jha ujio bhwa muene, ");
INSERT INTO kiz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kujha bhibeta kuokolibhwa kwa njela jha kusamehebhwa dhambi sya bhene. ");
INSERT INTO kiz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ele libeta kuhomela kwa ndabha jha huruma jha k'yara ghwitu, sababu ambajho lijobha kuhomela kunani libeta kutu hidila, ");
INSERT INTO kiz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kajhangasya kwa bhene bhabhitama mu ngisi ni mu kivuli kya mauti. Ibeta kubhomba naha kujhilongosya magolo ghitu ku njela jha amani.” ");
INSERT INTO kiz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Henu, muana jhola akakhola ni kujha mwenye nghofu mu roho na atamili nyikani mpaka ligono lya kwitokesya kwa muene kwa Israeli. ");
INSERT INTO kiz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Henu mu magono aghu, jhatokili kwamba Kaisari Agusto ahomisi lilaghisu kujhelesya kujha jhitolibhwayi sensa jha bhanu bhoha bhabhiishi pa dunia. ");
INSERT INTO kiz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ejhe jhajhele sensa jha kwanza jhajhabhombiki wakati Krenio ndo gavana bhwa Siria. ");
INSERT INTO kiz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Efyo, kila mmonga akalota kumjini kwa muene kujhandikisya sensa. ");
INSERT INTO kiz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ni muene Yusufu akabhoka kabhele mu mji bhwa Nazareti okhu Galilaya ni kusafiri Yudea mu mji bhwa Bethlehemu, bhwa umanyikene kama mji bhwa Daudi, kwandabha jhatokili mu lukholo lwa Daudi. ");
INSERT INTO kiz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Alotili okhu kwijhandikisya pamonga ni Mariamu, ambajhe amposili na akajha ilolelela muana. ");
INSERT INTO kiz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Henu jhatokili kujha, bhobhajhele khola wakati bhwa muene bhwa kwifungula muana bhwa wadili. ");
INSERT INTO kiz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akahogola muana ghwa kigos, mzalibhwa bhwa muene bhwa kuanza, akan'syongosela ngobho mb'ele bhuoha kun'kenga muana ni mepu. Ndipo akambeka mu kihori kya kulesela bhanyama kwandabha jhajhelepi nafasi mu nyumba jha bhahesya. ");
INSERT INTO kiz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Katika eneo e'lu, bhajhele bhachungaji bhabhatameghe kumigonda bhakajha bhilenda makundi gha kondoo bha bhene pakiru. ");
INSERT INTO kiz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ghafla, malaika bha Bwana akabhatokela, ni bhutukufu bhwa Bwana bhwa langele kubhasyongoka, na bhajhe ni bhuogha sana. ");
INSERT INTO kiz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ndipo malaika akabhajobhela, “Musitili, kwa ndabha ni kabhaletela habari jhinofu ambajho jhileta furaha mbaha kwa bhanu bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lelu mwokozi ahogoliki kwandabha jhinu kumjini kwa Daudi! muene ndo Kristu Bwana! ");
INSERT INTO kiz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ejhe, ndo ishara jha mwibetakupelibhwa, bhwa mwibetakunkolela muana akongibhu nghobho na agonili mu liholi lya kulesela bhanyama.” ");
INSERT INTO kiz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ghafla kwajhele ni kijeshi kibhaha lya kumbinguni lyaungena Ni malaika ojhu bhakansifu k'yara bhakajobha, ");
INSERT INTO kiz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Utukufu kwa K'yara j'ha ajhele kunani, ni amani ij'helayi pa duniani kwa bhoha bhaipendesibhwa nabhu.” ");
INSERT INTO kiz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ikajha kwamba malaika bhobhamalikubhoka kulota kumbinguni, bhachungaji bhakajobhe sana bhene kwa bhene, “Tulotayi henu khola Bethlehemu, na tukalolayi khenu ekhe ambakyo kih'omili, ambakyo Bwana atujobhili.” ");
INSERT INTO kiz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bhakaharakisya khola, na bhan'kolili Mariamu ni Yusufu, na bhambwene muana agonili mu liholi lya kulesele bhanyama. ");
INSERT INTO kiz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na bhobhabhuene naha, bhakabhajulisha bhanu khela kyabhajobhibhu kuhusu muana. ");
INSERT INTO kiz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bhoha bhabhepeliki habari ejhe bhasyangesibhu ni khela kyakyajobhibhu ni bhachungaji. ");
INSERT INTO kiz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Mariamu ajhendelili kufikiri kuhusu ghoha ghaamali kughap'eleka, aghatunzili mu muoyo ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhachungaji bhakakerebhuka bhakantukusya ni kun'sifu k'yara kwandabha jha khila khenu kyabhamali kup'eleka ni kulola, kama tukyajhikajhele jhinenibhu kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bhojhifikili ligono lya nane na jhajhele ndo wakati bhwa kun'tahiri muana, bhakan'kuta lihina Yesu, lya amalikupelibhwa ni jhola malaika kabla jha luleme kut'ongibhwa mulileme. ");
INSERT INTO kiz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Zao lyalilondekeghe lya utakaso bho sipetili, kul'engana ni sheria jha Musa, Yusufu ni Mariamu bhakampeleka ku hekalu khola Yerusalemu kumb'eka palongolo pa Bwana. ");
INSERT INTO kiz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kama kyajhalembibhu mu sheria sya Bwana, “khila n'gosi jhaafungulibhu lileme ni ibetakukutibhwa jhaapisibhu bhakfu kwa Bwana.” ");
INSERT INTO kiz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bhabhu ni bhene bhahidili kupisya sadaka kulengana ni khela kyakijobhibhwa mu sheria jha Bwana, Jozi jha jhebha au makinda mabhele gha njebha.” ");
INSERT INTO kiz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Langayi, pajhele ni munu mu Yerusalemu ambajhe lihina lya muene akutibhweghe Simeoni. Munu ojho ajhele mwenye haki ni mcha Mungu. Muene akajha ilendela kwandabha jha mfariji ghwa Israeli, ni Roho mtakatifu ajhele panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jhamali kufunulibhwa kwa muene kupetela Roho mtakatifu kujha muene ngaafwilepi kabla jha kumbona kristu Bwana. ");
INSERT INTO kiz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ligono limonga ahidili mugati mu hekalu, alongosibhu ni Roho mtakatifu. Ambapo bhazazi bhandetili muana, Yesu, kumbombela ghala ghaghalondekejhe jha sheria, ");
INSERT INTO kiz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ndipo Simeoni ampokili mu mabhoko gha muene, ni kun'sifu k'yara ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Henu ruhusuayi n'tumishi ghwa jhobhi alotayi kwa amani Bwana, kulengana ni lilobhi lya jhobhi. ");
INSERT INTO kiz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa kujha mihu ghangu ghaubhwene wokovu bhwa jhobhi, ");
INSERT INTO kiz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ambabho bhubhonekene kwa mihu gha bhanu bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Muene ndo nuru kwandabha jha ufunuo kwa bhamataifa ni utukufu bhwa bhanu Israeli.” ");
INSERT INTO kiz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dadi ni Mabhu ghwa bhana bhasyangesibhu kwa mambo ghaghalongeliki juu jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndipo Simeoni akabhabariki ni kujobha Mariamu nyinamunu, “Pelekesiajhi kwa ndabha jha kujhagha ni kuokoka kwa bhanu bhingi mu Israeli na ndo ishara ambajho bhanu bhingi bhibeta kujhipinga. ");
INSERT INTO kiz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kabhele ndo upanga bhwawibeta kuhoma nafsi jha jhobhi ghwe muene, ili kwamba mabhwasu gha mioyo jha bhingi jhidhihirikayi”. ");
INSERT INTO kiz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nabii n'dala jhaakutibhweghe Ana ajhele mu hekalu. Muene ajhele binti ghwa Fanueli kuhoma kabila lya Asheri. Ajhele ni miaka ghimehele sana. Ni muene atamili ni n'gosi kwa miaka sana baada jha kubhonana, ");
INSERT INTO kiz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na ndipo akajha mjane kwa miaka themanini na nne. Ni muene abhwayilepi kubhoka mu hekalu na akajha ijhendelela kumwabudu K'yara pamonga ni kufunga ni kus'oka, kiru ni musi. ");
INSERT INTO kiz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na kwa wakati obhu ahidili pala pa bhajhele akajhanda kun'shuru k'yara. Alongili kumhusu muana kwa khila munu ambajhe alendeleleghe ukombozi bhwa Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bho bhamalili khila khenu kya bhalondeghe kubhomba kulengana ni sheria jha Bwana, bhakakerebhuka Galilaya, kumjini kwa bhene, Nazareti. ");
INSERT INTO kiz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Muana akholili, na ajhe ni nghofu, akajhongeseka katika hekima, ni neema jha K'yara jhajhele panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bhazazi bha mwene khila mwaka bhalotili Yerusalemu kwandabha jha sikukuu jha Pasaka. ");
INSERT INTO kiz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bhoajhe ni umri wa miaka kumi hi mibhele, bhakalota kabhele wakati muafaka kidesturi kwandabha jha sikukuu. ");
INSERT INTO kiz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baada jha kubhakila magono ghoha kwandabha jha sikukuu bhajhandili kukerebhuka kunyumba. Lakini n'gosi Yesu abakili kunyuma m'ola mu Yerusalemu ni bhazazi bha muene bhamanyilepi e'le. ");
INSERT INTO kiz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhadhanieghe ajhele mu likundi lya bhasafirieghe nalu, hivyo bhasafiri safari jha ligono. Ndipo bhakajhanda kundonda miongoni mwa bhalongo munu ni marafiki bha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bhobhashindilu kun'kabha, bhakakerebhuka Yerusalemu ni kujhanda kundonda omu. ");
INSERT INTO kiz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jhatokili kwamba baada jha magono madatu, bhakan'kabha mu hekalu, akajha atamili pagati pa bhalimu, akabhap'elekesya ni kubhakhota maswali. ");
INSERT INTO kiz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bhoha bhabhampelekisi bhasyangesibhu ni ufahamu bhwa muene ni majibu gha muene. ");
INSERT INTO kiz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bho bhambwene, bhastajabili. Nyinamunu akan'jobhela, “Mwanabhangu, kwandabha jhakiki ukatubhombela naha? Pelekesiajhi, Dadi waku ni nene tukulondili kwa wasiwasi mbaha.” ");
INSERT INTO kiz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akabhajobhela, “kwandabha jhakiki mnilondeghe? Mwamanyilepi kujha lazima nijhelayi mu nyumba jha dadi jhangu? ");
INSERT INTO kiz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini bhanjelibhu lepi kiki akimaanishieghe kwa malobhi aghu. ");
INSERT INTO kiz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ndipo akalota pamonga nabhu mpaka kunyumba Nazareti na ajhele mtii lwa bhene. Nyinamunu ahifadhili mambo ghoha mu muoyo ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Lakini Yesu ajhendelili kukhola katika hekima ni kimo, na ajhongesiki kuganikibhwa ni k'yara ni bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Henu, mu mwaka ghwa kumi na tano bhwa utawala bhwa Kaisari Tiberia, wakati Pontio Pilato ajhe gavana ghwa Uyahudi, Herode ajhele mbaha ghwa mkoa ghwa Galilaya, ni Filipo ndogomunu ajhele mbaha ghwa mkoa bhwa Iturea ni Trakoniti, ni Lisania ajhele mbaha ghwa mkoa bhwa Abilene, ");
INSERT INTO kiz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ni bhwakati bhwa ukuhani mbaha bhwa Anasi ni Kayafa, Lilobhi lya k'yara lyan'hidili Yohana mwana ghwa Zakaria, jangwani. ");
INSERT INTO kiz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Asafiri mu mkoa bhuoha kusyongoka kiholo Yorodani, akihubiri bhubatisu bhwa toba kwandabha jha msamaha bhwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kama kya jhilembibhu mu kitabu kya malobhi gha nabii Isaya, “sauti jha munu jha ajhe munyika,” Mujhitengenesiajhi tayari njela jha Bwana, mughatengenesiajhi mapito gha muene ghaghanyokili. ");
INSERT INTO kiz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila libondi libeta kujasibhwa, kila kid'onda fibeta kusawazishibhwa, barabara syasibedeme sibeta kunyosibhwa, ni njela sya siparasibhu sibetakulainishibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bhanu bhoha bhibetakubhubhona wokovu bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Efyo, Yohana akabhajobhela makutano mabhajha gha bhanu bhabhan'hidili bhabhwesiajhi kubatisibhwa ni muene, “Muenga uzao bhwa lijhoka bhenye sumu, niani abhaonyili kujhijumba gadhabu jhajhihida? ");
INSERT INTO kiz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Muhogolayi matunda ghaghiyendana ni toba, na musijhendi kujobha mgati mwa jhomu, “Tujhe ni Ibrahimu ambajhe Dadi jhitu kwa ndabha nikabhajobhela jha kujha k'yara ibhwesya kunjinulila Ibrahimu bhana hata kutokana ni maganga agha. ");
INSERT INTO kiz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tayari libhagu limelikubhekibhwa mu mzizi bhwa libehe. Efyo, khila libehe lya lihogolalepi matunda manofu, lidumulibhwa ni kutaghibhwa mu muoto. ");
INSERT INTO kiz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kisha bhanu mu makutano bhan'tokili bhakajobha, “Henu twilondeka tukheta bhuli?” ");
INSERT INTO kiz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ajibili ni kujobhoha, “Kama munu ajhe ni kanzu sibhele jhilondeka ampelayi kanzu jhimonga jhinu jha adulili, na ambajhe ajhe ni kyakulya na abhombayi mebhu.” ");
INSERT INTO kiz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kisha baadhi jha bhatoza ushuru bhahidili kabhele kubhatisibhwa, na bhan'jobhili, “Mwalimu twilondeka kubhomba kiki? ");
INSERT INTO kiz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akabhajobhela, “musikusanyi hela nisu kuliko kya mwilondeka kubhonganiya.” ");
INSERT INTO kiz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baadhi jha maaskari kabhele bhakan'kota bhakajobha, “Ni teta je? Twilondeka tuketajhi kiki?” Akabhajobhela, “Musitoli hela kwa munu jhejhioha kwa nghofu, na musin'tuhumu munu jhejhioha kwa udesi. Muridhikayi kwa mishahara jhinu.” ");
INSERT INTO kiz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Henu, kwa kujha bhanu bhajhele ni shauku jha kundendela Kristo jhaibeta kuhida, khila mmonga akajhaibhwasya mu muoyo bhwa muene kuhusu Yohana kama muene ndo kristo. ");
INSERT INTO kiz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana ajibili ni kubhajobhela bhoha, “Nene nikabhabatisya muenga kwa masi, lakini ajhe mmonga jhaihida ambajhe muene ajhe ni nghofu kuliko nene, na nilondeka lepi hata kuhobhosya mighojhi jha filatu fya muene. Ibeta kubhabatisya muenga kwa Roho mtakatifu ni kwa muoto. ");
INSERT INTO kiz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pepeto lya muene lijhele mumabhoko gha muene bhwa kupepetela ngano ni kujhibhonganiya ngano mu ghala lya muene. Lakini, ibeta kughateketesya makapi kwa muoto ambabho bhwibhwesya lepi kusimika. ");
INSERT INTO kiz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa maonyo ghangi ghamehele kabhele, ahubiri habari jhinofu kwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana an'kemili kabhele Herode mbaha ghwa mkoa kwa kun'gega Herodia, n'dala ghwa ndongo munu ni kwa maovu ghangi ghamehele ambagho Herode aghabhombili. ");
INSERT INTO kiz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lakini baadajhe Herode abhombili uovu bhongi bhubhibhi sana. An'kongili Yohana muligereza. ");
INSERT INTO kiz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kisha jhatokili kwamba, wakati bhanu bhoha bhibatisibhwa ni Yohana, ni muene Yesu abatisibhu kabhele. Wakati bho isoka, mbingu syafunguiki. ");
INSERT INTO kiz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Roho mtakatifu akaselela panani pa muene kwa mfano ghwa kiwiliwili kama njebha, wakati bhobhuobhu sauti ikahida kuhomela kumbinguni jhajobhili, “Bhebhe ghwa mwanabhangu mpendwa. Nipendesibhu sana ni bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Henu Yesu muene, bhoajhandi kufundisya, ajhele ni umri upatao miaka thelathini. Ajhele mwana (kama kyajhejobhibhu) ghwa Yusufu, mwana ghwa Eli, ");
INSERT INTO kiz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mwana ghwa Mathati, mwana ghwa Lawi, mwana ghwa Melki, mwana ghwa Yana, mwana ghwa Yusufu, ");
INSERT INTO kiz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwana ghwa Matathia, mwana ghwa Amosi, mwana ghwa Nuhumu, mwana ghwa Esli, mwana ghwa Nagai, ");
INSERT INTO kiz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana ghwa Maati, mwana ghwa Matathia, mwana ghwa Semeini, mwana ghwa Yusufu, mwana ghwa Yuda, ");
INSERT INTO kiz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwana ghwa Yoanani, mwana ghwa Resa, mwana ghwa Zerubabeli, mwana ghwa Shealtieli, mwana ghwa Neri, ");
INSERT INTO kiz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana ghwa Melki, mwana ghwa Adi, mwana ghwa kosamu, mwana ghwa Elmadamu, mwana ghwa Eri, ");
INSERT INTO kiz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana ghwa Yoshua, mwana ghwa Eliezeri, mwana ghwa Yorimu, mwana ghwa Matathi, mwana ghwa Lawi, ");
INSERT INTO kiz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana ghwa Simeoni, mwana ghwa Yuda, mwana ghwa Yusufu, mwana ghwa Yonamu, mwana ghwa Eliyakimu, ");
INSERT INTO kiz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana ghwa Melea, mwana ghwa Mena, mwana ghwa Nathani, mwana ghwa Daudi, ");
INSERT INTO kiz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana ghwa Yese, mwana ghwa Obedi, mwana ghwa Boazi, mwana ghwa Salmoni, mwana ghwa Nashoni, ");
INSERT INTO kiz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana ghwa Abinadabu, mwana ghwa Aramu, mwana ghwa Hesroni, mwana ghwa Peresi, mwana ghwa Yuda, ");
INSERT INTO kiz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana ghwa Yakobo, mwana ghwa Isaka, mwana ghwa Ibrahimu, mwana ghwa Tera, mwana ghwa Nahori, ");
INSERT INTO kiz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana ghwa Seruig, mwana ghwa Ragau, mwana ghwa Pelegi, mwana ghwa Eberi, mwana ghwa Sala, ");
INSERT INTO kiz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana ghwa Kenani, mwana ghwa Arfaksadi, mwana ghwa Shemu, mwana ghwa Nuhu, mwana ghwa Lameki, ");
INSERT INTO kiz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana ghwa Methusela, mwana ghwa Henoko, mwana ghwa Yaredi, mwana ghwa Mahalalei, mwana ghwa Kenani, ");
INSERT INTO kiz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana ghwa Enoshi, mwana ghwa Sethi mwana ghwa Adamu, mwana ghwa k'yara. ");
INSERT INTO kiz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kisha, Yesu bho amemili Roho mtakatifu, akerebhwiki kuhoma ku kiholo Jordani, na alongosibhu ni Roho mu jangwa. ");
INSERT INTO kiz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwa magono arobaini, na okhu ajaribibhu ni ibilisi. Wakati obhu alilepi kyokyoha, ni mwisho bhwa wakati akipeliki njala. ");
INSERT INTO kiz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibilisi akan'jobhela, “Kama bhebhe mwana ghwa K'yara, liamuruajhi liganga ele kujha n'kate.” ");
INSERT INTO kiz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu akan'jibu, “Jhilembibhu; 'munu ibeta lepi kuishi kwa n'kate bhuene.” ");
INSERT INTO kiz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kisha Ibilisi akendongosya panani pa kilele kya kid'onda ni kundasya falme syoha sya dunia kwa muda mfupi. ");
INSERT INTO kiz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibilisi akan'jobhela, “Nibetakupela mamlaka gha kutawala falme ese syoha pamonga ni fahari syake. Nibhwesya kuketa naha kwandabha fyoha fikabidhibhu kwa nene nifitawaleyi, na nibhwesya kumpela jhejhioha jha nilonda kumpela. ");
INSERT INTO kiz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kwa hiyo, kama wibetakunijhinamila ni kuniabudu, fenu efe fyoha fibetakujha fya bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Lakini Yesu ajibili ni kun'jobhela, “Jhilembibhu, “lazima umwabuduajhi Bwana k'yara ghwa jhobhi, na lazima un'tumililayi muene tu.” ");
INSERT INTO kiz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baadaye Ibilisi andonguisi Yesu hadi Yerusalemu ni kumbeka sehemu jha panani kabisa jha lijengo lya hekalu ni kun'jobhela, “kama bhebhe ndo mwana ghwa K'yara, kisopayi pasi kuhomela apu. ");
INSERT INTO kiz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwandabha jhilembibhu, “Ibetakubhalangisya malaika bha muene bhahidayi kukutunze ni kukul'enda, ");
INSERT INTO kiz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na bhibetakujhinula panani mu mabhoko gha bhene ili kwamba usilamasi magono gha jhobhi panani pa maganga.” ");
INSERT INTO kiz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu ajibili an'jobhili, “Jhinenibhu, “usin'jaribu Bwana K'yara ghwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibilisi bho amali kun'jaribu Yesu, akabhoka ni kundeka hadi wakati bhongi. ");
INSERT INTO kiz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kisha Yesu akerebhwiki Galilaya kwa nghofu sya Roho, ni habari kun'husu muene sya jhemili ni kusambala mu mikoa ghioha ghya jirani. ");
INSERT INTO kiz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Afundisi mu masinagogi gha bhene, ni kila mmonga an'sifili. ");
INSERT INTO kiz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ligono limonga alotili Nazareti, mji ambabho alelibhu ni kukholela. Kama kyajhijhele desturi jha muene ajhingili mu sinagogi ligono lya sabato naajhemili kusoma maandiku. ");
INSERT INTO kiz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akabidhibhu gombo lya nabii Isaya, hivyo, afunguili gombo na alondili sehemu jha jhilembibhu, ");
INSERT INTO kiz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Roho ghwa Bwana ajhele panani pa nene, kwandabha anisopili mafuta kuhubiri habari jhinofu kwa maskini. Anilaghisi kutangasya uhuru kwa bhafungwa, ni kubhafuanya bhabhibela bhabhwesiajhi kulola kabhele. kubhabheka huru bhala bhabhigandamisibhwa, ");
INSERT INTO kiz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kubhutangasya mwaka ambabho Bwana ibetakulasya wema bhwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kisha akalifunga gombo, akan'kerebhusila ndongosi ghwa sinagogi ni kutama pasi. Mihu gha bhanu bhoha bha bhajhele mu sinagogi ghanda ngili muene. ");
INSERT INTO kiz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akajhanda kulongela nabhu akajobha, “Lelu lijhandiku e'le litimisibhu mu mb'olokoto sya jhomu.” ");
INSERT INTO kiz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Khila mmonga pala ashuhudili kya ajobhili Yesu, na bhingi miongoni mwa bhene bhasyangesibhu ni malobhi gha hekima ghaghajhele ghihomela mu kinywa kya muene. Bhakajha bhijobha, “ojho ndo n'songolo tu ghwa Yusufu, naha lepi?” ");
INSERT INTO kiz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu akabhajobhela, “hakika mwibeta kujobha methali ejhe kwa nene, “Tabibu, ukiponesijhi ghwe muene. Kyokyoha kyatupeliki wibhombha Karperinaumu, kibhombayi hapa kabhele pakijiji kya jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kabhele ajobhili, “hakika nikabhajobhela muenga, ajhelepi nabii jha ikakubalika mu nchi jha muene.” ");
INSERT INTO kiz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lakini nikabhajobhela ukweli muenga kujha kwajhele ni bhajane bhingi Israeli mu kipindi kya Eliya, wakati mbingu jhidendibhu kusijhi ni fula kwa miaka midatu ni nusu, wakati kujhele ni njala mbaha mu nchi jhioha. ");
INSERT INTO kiz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lakini Eliya atumibhu lepi kwa jhejhioha mmonga ghwa bhene, lakini kwa mjane mmonga tu jhaatameghe sarepta karibu ni mji bhwa Sidoni. ");
INSERT INTO kiz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kabhele, kwajhele ni bhakoma bhamehele Israeli katika kipindi kya Elisha nabii, lakini ajhelepi hata mmonga bhabhi jha aponyisibhu isipokujha Naamani munu ghwa Siria. ");
INSERT INTO kiz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhanu bhoha mu sinagogi bhamemibhu ni gadhabu bho bhaghapheliki agha ghoha. ");
INSERT INTO kiz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bhajhemili ni kun'sukumila kwibhala jhe mji nikundongosya hadi kuligema lya kundonda bhwa mji ambabho mji bhwa bhene ghwajengibhu panani pake, ili bhabhwesiajhi kun'tegha pasi. ");
INSERT INTO kiz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini ap'etili salama pagati pa bhene kwilotela. ");
INSERT INTO kiz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kisha aselelili Kapernaumu, mu mji ghwa Galilaya. Sabato jhimonga akajha ifundisya bhanu mu lisinagogi. ");
INSERT INTO kiz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bhasiyangesibhu ni mafundisu gha muene, kwandabha afundisi kwa mamlaka. ");
INSERT INTO kiz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Henu ligono elu mu sinagogi, kwajhele ni muene ghe ajhele ni roho chafu jha pepo, na alelili kwa sauti jha panani, ");
INSERT INTO kiz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tujhe ni kiki nabhi, Yesu ghwa Nazareti? Uhidili kutujhangamisya? Nimanyili kujha bhebhe ndo niani! Bhebhe ghwe mtakatifu ghwa K'yara!” ");
INSERT INTO kiz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu an'kemili pepo akajobha, “Gudamayi kununu, na umbo kayimunu ojho!” Pepo jhola bho an'sopili munu jhola pasi pagati pa bhene, ambokili munu jhola bila jha kun'sababishila maumivu ghoghoha ghala. ");
INSERT INTO kiz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bhanu bhoha bha syangele, na bhajhendelili kulongelela lijambo elu kila mmonga ni njinu. Bhakajobha, “Ndo malobhi gha aina jheleku agha?” Akabhaamuru roho kwa mamlaka ni nghofu na bhibhoka.” ");
INSERT INTO kiz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Efyo, habari juu jha Yesu syajhenili khila sehemu mu maeneo ghaghisyonghoka mkoa oghu. ");
INSERT INTO kiz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kisha Yesu akabhoka mu mji obhu ni kujhingila mu nyumba jha Simoni. Henu, n'kwibhi ghwa Simoni akajha ilwala homa jhikali, na bhakan'sihi kwa niaba jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Efyo, Yesu akan'hegelela, akajhikemela home jhela ni kupona. Ghafla akajhema ni kujhanda kubhatumikila. ");
INSERT INTO kiz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lijobha bho lijhibhela, bhanu bhake ndetela Yesu khila n'tamu ni kubhaponesya bhohba. ");
INSERT INTO kiz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mapepo kabhele ghabhapitili bhamehele ghakajhe ghilela kwa sauti ni kujobha, “bhebhe ndo mwana ghwa K'yara!” Yesu abhakemili mapepo ni kubharuhusu bhalongelayi, kwandabha bhamanyili kwamba muene ajhele ndo Kristu. ");
INSERT INTO kiz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bho kubhebhele, alotili lieneo lya libeli kujha ni bhanu. Makutano gha bhanu bhajhele bhakandonda na bhakahida mu lieneo lya ajhele. Bhakajaribu kun'besya asiloti patali ni bhene. ");
INSERT INTO kiz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini akabhajobhela, “Lazima kabhele nihubiriajhi habari sinofu sya ufalme bhwa K'yara mu miji ghenge, ghimehele kwandabha ejhe ndo sababu nalaghisibhu apa.” ");
INSERT INTO kiz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kisha ajhendelili kuhubiri mumasinagogi mu uyahudi jhioha. ");
INSERT INTO kiz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Basi jhatokili bhanu bho bhabhonganiki ni kun'syong'oka Yesu ni kupelekesya lilobhi lya K'yara ambapo ajhemili kando jha ziwa Genesareti. ");
INSERT INTO kiz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Abhuene mashua sibhele sisopi nanga palubhafu me nyanja. Bhalobhi bhajhe bhamali kupita na bhakajha bhisuka, mikwabhu ghya bhene. ");
INSERT INTO kiz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu akajhingila mu mojawapo mu s'ela mashua, ambajho jhajhele jha Simoni ni kun'soka ajhipelekayi mu masi patali kidogo ni pandema. Kisha atamili ni kumanyisya kuhomela mu mashua. ");
INSERT INTO kiz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kulongela, akan'jobhela Simoni, “Jhipelekajhi mashua jha jhobhi kulosi ni kuselesya mikwabhu ghya jhobhi ili kulobha somba.” ");
INSERT INTO kiz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon akajibi ni kujobha, Bwana, tubhombi mbombo kiru khoha na tukabhi lepi kyokyoha, lakini kwa lilobhi lya jhobhi, nikeselesya mikwabhu. ");
INSERT INTO kiz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bho bhabhombi nahu, bhabhongeniye kiasi kibhaha kya somba ni mikwabhu ghya bhene ghikajhenda kuhatuka. ");
INSERT INTO kiz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Efyo bhakabhaashirila bhashirika bha bhene mu mashua senge ili bhahidayi ni kubhatangasila. Bhakahida bhakasimemesya mashua syoha, kiasi kwamba sikajhanda kujhibhila. ");
INSERT INTO kiz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lakini simoni Petro, bhoabhwene naha, abinili pa magoti gha Yesu akajobha, “Bhokayi kwa nene, kwandabha nene ne munu jha nijheni dhambi Bwana.” ");
INSERT INTO kiz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kwandabha asyangesibhu, ni bhanu bhoha bhabhajhele pamonga nabhu, kwa bhalobhi bha somba bhabhajhele bhaubhombili. ");
INSERT INTO kiz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E'le lyabhajumuishi Yakobo ni Yohana bhana bha Zebedayo, ambabho bhajhele bhashiriki bha Simoni. Ni Yesu akan'jobhela Simoni, “Usitili, kwa ndabha kwabhwanji henu ni kuj'hendelela wibeta kulobha bhanu.” ");
INSERT INTO kiz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bhobhamali kusileta mashua sya bhene kundema, bhalekili khila khenu ni kun'kesya muene. ");
INSERT INTO kiz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jhatokili bho ajhe mu mji umongawapo, munu jha amemili ukoma ajhele okhu. Wakati ambwene Yesu, abinili wakati ijhinamisya uso bhwa muene pasi ni kun'soka, akajobha, Bwana, ikajhiajhi wilonda, ghwibhwesya kunitakasa.” ");
INSERT INTO kiz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kisha Yesu anyosisi kibhoko kya muene ni kun'gusa, akajobha. “Nilonda.” Ni lisaa lelalela ukoma ukamalika. ");
INSERT INTO kiz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","“Akandaghisya asin'jobheli munu jhejhioha, lakini akan'jobhela, “Lotayi na ukakilasiajhi kwa makuhani na uhomesiajhi sadaka jha utakaso bhwa jhobhi, sawasawa ni khela Musa kyaakiamuiri kwa nushuhuda bhwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini habari kuhusu muene sya jhenili patali zaidi ni umati mbaha bhwa bhanu ukahida pamonga kump'elekesya ifundisya ni kuponyesya matamu gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini mara kwa mara akitengili faragha ni kus'oka. ");
INSERT INTO kiz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jhatokili ligono limonga kati jha e'lu akajha ifundisya, na bhajhele Mafarisayo ni bhalimu bha sheria bhatemili apu ambabho bhahidili kuhomela fijiji fimehele tofauti mu mkoa ghwa Galilaya ni Yudea, na kabhele kuhomela mji bhwa Yerusalemu. Ngofu jha Bwana jhajhele pamonga naku kuponesya. ");
INSERT INTO kiz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bhanu kadhaa bhahidili, bhampendili mu n'keka munu jhaapoozili, na bhakalonda njela jha kunjingisya mugati eli kun'gonesya pasi mbele jha Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bhakibhi lepi njela jha kunjhingisya mugati kwandabha jha umati, hivyo bhakwelili panani pa paa lya nyumba ni kun'selesya munu jhola pasi kupetela ku figae, panani n'keka ghwa muene pagati pa bhanu, palongolo kabisa jha Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Akajhe ilanga imani jha bhene, Yesu akajobha, “Rafiki, dhambi sya jhobhi usamehibhu.” ");
INSERT INTO kiz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bhaandishi ni Mafarisayo bhakajhanda kuhoji e'lu, bhakajobha, “Ojho ndo niani jhailongela makufuru? Niani jhaibhwesya kusamehe dhambi ila K'yara muene?” ");
INSERT INTO kiz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lakini Yesu, amanyili kiki kyabhafikirileghe, abhajibili ni kubhajobhela, “kwandabha mwikotana e'le mu mioyo ghya jhomu? ");
INSERT INTO kiz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kheleku rahisi kujobha, 'Dhambi sya jhobhi sisamehibhu' au kujobha jhemayi ugendayi?' ");
INSERT INTO kiz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lakini mumanyajhi kujha mwana ghwa Adamu ajhe ni mamlaka pa duniani gha kusamehe dhambi, Nikujobhela bhebhe, 'Jhinukayi, tolayi n'keka bhwa jhobhi na alotayi kunyumba jha jhobhi.”' ");
INSERT INTO kiz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","wakati bhobhuobhu akajhema mbele jha bhene ni kutola n'keka ghwa muene bhwaagonili. Kisha akabhujha kunyumba jha muene akin'tukusya K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Khila mmonga asyangele ni kun'tukusya k'yara bhamemibhu ni hofu, bhakajobha, “Tughabhwene mambo ambagho ghakawaida lepi lelu.” ");
INSERT INTO kiz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baada jha mambo agha kuhomela, Yesu abhokili okhu ni kumbona mtoza ushuru jhaakutibhweghe Lawi atamili lieneo lya kutolela kodi. Akan'jobhela, “Nikesiajhi.” ");
INSERT INTO kiz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Efyo Lawi akajhema ni kun'kesiya, akaleka khila khenu kunyuma. ");
INSERT INTO kiz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kisha Lawi aandele kunyumba jha muene karamu mbaha kwandabha jha Yesu. bhajhele bhatoza ushuru bhamehele khola ni bhanu bhingi bhabhatamili pameza bhakajha bhilya pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lakini Mafarisayo bhene bhakajhe bhakebhadadila bhanafunzi, bhakajobha, “kwandabha jha kiki mwilya ni kunywa ni bhatoza ushuru pamonga ni bhanu bhamana, bhabhajhe ni dhambi?” ");
INSERT INTO kiz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akabhaji, “Bhanu bhabhajhele mu afya jhinofu bhilondelepi tabibu, bhela tu bhabhikandonda mmonga. ");
INSERT INTO kiz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nahidilepi kubhakuta bhanu bhabhajhe ni hakebhajhi kutubu, bali kubhakuta bhenye dhambi bhabhwesiajhi kutubu.” ");
INSERT INTO kiz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bakan'jobhela, “Bhanafunzi bha Yohana mara nyingi bhifunga ni kus'oka, ni bhanafunzi bha Mafarisayo bhibhomba mebhu. Lakini bhanafunzi bha jhobhi bhilya ni kunywa.” ");
INSERT INTO kiz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akabhajobhela, “Jhibhwesekana munu jhejhioha akabha bhomba bhabhahudhuriri mu harusi jha Bwana harusi kufunga wakati Bwana Arusi bado ajhe pamonga nabhu? ");
INSERT INTO kiz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini magono ghibeta kuhida wakati Bwana Arusi pa ibeta kubhosibhwa kwa bhene, ndipo ku magono aghu bhibeta kufunga.” ");
INSERT INTO kiz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kisha Yesu alongelili kabhele kwa bhene kwa mfano. “Ajhelepi jhachatule kipandi kya nghobho kuhoma mu nghobho mpya ni kukitumila kurekebisya liguanda lya muandi. Kama abhombi naha ibeta kuhatula nghobho mpya, ni kipandi kya nghobho kuhoma liguanda lipya ngakifwayi lepi kutumika ni nghobho jha liguanda lya muandi. ");
INSERT INTO kiz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kabhele, ajhelepi munu ambajhe ibheka divai mpya mu firiba fya fichakele. Kama aketili naha divai mpya ngejhi kayuili khenu khela, ni divai ngejhijhitiki, ni firiba ngafiharibiki. ");
INSERT INTO kiz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakini divai mpya lazima ibhekibhwayi mu firiba fipya. ");
INSERT INTO kiz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na ajhelepi munu baada jha kunywa divai jha muandi, wibetalepi kulonda mpya kwandabha bhijobha, 'Jha muandi ndo bora.”' ");
INSERT INTO kiz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Henu jhatokili kusabato kwamba Yesu akajha ipeta mu mig'onda ghya nafaka ni bhanafunzi bha muene bhakajha bhijhabha masuke, bhakaghasugula kati jha mabhoko gha bhene bhakalya nafaka. ");
INSERT INTO kiz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lakini baadhi jha Mafarisayo bhakajobha, “kwandabha kiki mwibhomba khenu ambakyo halali lepi kisha na kukibhomba ligono lya sabato”? ");
INSERT INTO kiz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu, akabhajibu, akajobha, “Mwabhajhi lepi kusoma khele Daudi akiketili bho ajhe ni njala, muene ni bhagosi bhabhajhe pamonga nabhu? ");
INSERT INTO kiz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Alotili mu nyumba jha k'yara na atolili mikate ni kulya baadhi, ni kujhihomesya baadhi bhanu bhabhajhe naku kulya, hata kama jha jhele halali kwa makuhani kulya.” ");
INSERT INTO kiz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kisha akabhajobhela, “Mwana ghwa Adamu ndo Bwana ghwa sabato.” ");
INSERT INTO kiz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","jhatokili mu sabato jhenge kwamba alotili mugati mu masinagogi ni kubhafundisya bhanu okhu. Pajhele ni munu ambajhe kibhoko kya kuha kyapoozili. ");
INSERT INTO kiz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bhaandishi ni Mafarisayo bhakajha bhakandanga kwa makini kulola kama ngaamponyili mu ligono lya sabato, ili bhakabhayi sababu jhe jhakun'takila kwa kubhomba likosa. ");
INSERT INTO kiz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini amanyili kiki kyabhifikilila ni kujobha kwa munu jhaapozili kibhoko, “Jhemayi, jhema apa pagati pa khila mmonga.” Efyo munu ajhu akajhinuka ni kujhema pala. ");
INSERT INTO kiz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu akajobha kwa bhene, “Nikabhakhota muenga, halali ligono lya sabato kubhomba manofu au kubhomba madhara, kuokola maisha au kughaharibu?” Kisha akabhalenga bhoha ni kun'jobhela munu jhola, ");
INSERT INTO kiz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","“Nyoosyajhi kibhoko kya jhobhi.” Akakheta mebhu kibhoko kya muene kyaponyisibhu. ");
INSERT INTO kiz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini bhamemibhu ni hasira bhakalongelesana bhane kwa bhene kuhusu kiki bhakikhetayi kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jhatokili magono aghu alotili ku kid'onda kus'oka. Ajhendelili kiru khoha kun'soka k'yara. ");
INSERT INTO kiz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bho jhifikili lukhela, abhakutili bhanafunzi bha muene ni kubhechagula kumi ni bhabhele kati jha bhene, ambabho kabhele abhakutili “mitume.” ");
INSERT INTO kiz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mahina gha bhala mitume ghajhele Simoni (ambajhe kabhele an'kutili Petro) na Andrea munu, Yakobo, Yohana, Filipo, Bartolomayo, ");
INSERT INTO kiz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayo, Tomaso na Yakobo mwana ghwa Alfayo, Simoni, ambajhe akutibhu Zelote, ");
INSERT INTO kiz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana ghwa Yakobo ni Yuda Iskariote, ambajhe ajhele msaliti. ");
INSERT INTO kiz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kisha Yesu akaselela pamonga nabhu kuhoma ku kid'onda ni kujhema mahali tambarare. Idadi mbaha jha bhanafunzi bha muene bhajhele okhu, pamonga ni idadi mbaha jha bhanu kuhoma Uyahudi ni Yerusalemu, ni kuhoma pwani jha Tiro ni Sidoni. ");
INSERT INTO kiz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bhahidili kumpelekesya ni kuponyisibhwa matamu gha bhene. Bhanu bhabhasumbuli bhweghe ni pepo bhachafu bhaponyisibhu pia. ");
INSERT INTO kiz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Khila mmonga pa kusanyiku e'lu ajaribu kun'gusa kwandabha nghofu sya uponyajhi syajhele sihomela mwa muene, na abhaponyisi bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kisha akabhalanga bhanafunzi bha muene, ni kujobha, “Mbarikibhu muenga mwe maskini, kwandabha ufalme bhwa K'yara ndo bhwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbarikibhu muenga jhe mujhele ni njala henu kwa ndabha mwibeta kushibishibhwa. Mbarikibhu muenga jha mwilela henu kwandabha mwibeta kuheka. ");
INSERT INTO kiz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mbarikibhu muenga ambabho bhanu pabhibeta kubhachukila ni kubhatenga ni kubhashutumu muenga kwamba ndo bhaovu, kwandabha jha mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muhobhokajhi ligono e'lu ni kurukaruka kwa furaha, kwandabha hakika mwibeta kujha ni thawabu mbaha kumbinguni kwandabha bhadadi jhabhi bhabhabhombili mebhu manabii. ");
INSERT INTO kiz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini o'le bhinu bhamujhe mataji! kwandabha mumalikukabha farajha jha jhomu. ");
INSERT INTO kiz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O'le bhinu bhamushibili henu! Kwa maana mwibeta kubhona njala baadaje. Ole bhinu bhe mwiheka henu! Kwandabha mwibeta kuombolesya ni kulela baadaye. ");
INSERT INTO kiz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ole bhinu, pamwibetakusifibhwa ni bhanu bhoha! kwandabha bhadadi jhabhi bhabhabhombili manabii bha udesi fefuefu. ");
INSERT INTO kiz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lakini nijobha kwa muenga jha mukanipelekesya, mubhaganayi maadui bhinu ni kukheta manofu kwa bhakabhadadila. ");
INSERT INTO kiz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mubhabarikiajhi bhala bhabhekebhalaani muenga na mubhaombelayi bhala bhala bhabhe kabhabhonela. ");
INSERT INTO kiz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jhaikutobha litama limonga, un'geuzilayi ni la pili. Kama munu akunyakili lijoho lya jhobhi usimbesi ni likanzu. ");
INSERT INTO kiz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mpelayi khila kya ikusoka. Kama munu akunyakili khenu ambakyo mali gha jhobhi, usin'soki akukerebhusilayi. ");
INSERT INTO kiz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kama mgani bhanu bhabhakhetelayi, namu mukhetayi mebhu. ");
INSERT INTO kiz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kama mwibeta kubhagana bhanu bhabhaganili muenga tu, hivyo thawabu jhelekhu kwa muenga? kwandabha hata bhenye dhambi bhabhaganili bhala bhabhaganili. ");
INSERT INTO kiz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kama mwibeta kubhakhetela manofu bhala bhabhakabhaketela muenga manofu, hiyo thawabu jheleku kwa muenga? kwandabha hata bhenye dhambi bhikheta mebhu. ");
INSERT INTO kiz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kama mwikopesya fenu kwa bhanu ambabho mwitegemela bhakabhakerusila, ejhu ndo thawabu jheleku kwa muenga? Hata bhenye dhambi bhikopesya bhenye dhambi, na bhitegemela kupokela kiasi kekuekhu kabhele. ");
INSERT INTO kiz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lakini mubhaganayi maadui bhinu na mubhakhetelayi manofu. Mubhakopesiajhi ni msihofu kuhusu kukerusibhwa, ni thawabu jha muenga jhibeta kujha mbaha. Mwibetakujha bhana bha ajhe kunani, kwandabha muene ndo mwema na mwema kwa bhanu bhabhaduli shukrani ni bhaovu. ");
INSERT INTO kiz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mujhelayi ni huruma, kama Dadi jhinu kyaajhe ni huruma. ");
INSERT INTO kiz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Msihukumu, namu mwibeta kuhukumibhwa. Musilaani, namu mwibetalepi laanibhwa. mubhasameheajhi bhamana, namu mwibeta kusamehebhwa. ");
INSERT INTO kiz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mubhapelayi bhangi, namu mwibeta kupelibhwa. Kiasi kya ukarimu - kyakishindilibhu, kusukibhwa ni kujhitika - kibeta kujhitika pa magoti gha jhomu. Kwandabha jha kup'emu kyokyoha kyamwitumila kupemela, kip'emu ekhu kibetakutumika kubhap'emela muenga.” ");
INSERT INTO kiz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kisha akabhajobhela mfano kabhele. “Je, munu kipofu ibhwesya kundongosya munu jhongi kipofu? Kama kyaajhele efu, basi bhoha bhibetakudumbukila mu lilende, je bhidumbukila lepi? ");
INSERT INTO kiz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanafunzi ijha lepi mbaha kuliko mwalimu ghwa muene lakini khila munu akafundisibhwayi kwa ukamilifu ijha kama mwalimu ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na kwandajha kiki basi ukakilanga kibanzi mu lihu lya ndongobhu na wakati riboriti lijhe mu lihu lya jhobhi ukalibhona lepi? ");
INSERT INTO kiz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wabhwesya bhuli kun'jobhela ndongobhu, 'Ndongo, nis'oka nikubhosiajhi kibanzi kyekijhele mu lihu lya bhebhe,' nabhi wilange lepi liboriti lyalijhele mu lihu lya jhobhi? Mnafiki bhebhe! kwanza libhosyajhe boriti mu lihu lya bhebhe, ndipo wibeta kulola kinofu kibanzi mu lihu lya ndongobhu. ");
INSERT INTO kiz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kwandabha lijhelepi libehe linofu lyalihogola matunda mabaya, wala lijhelepi libehe libaya lihogola matunda manofu. ");
INSERT INTO kiz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwandabha khila limanyikana kwa matunda ghaki. Kwandabha bhanu bhijhabha lepi tini kuhoma mu mifwa, wala bhijhabha lepi tini kuhoma mu mifwa, wala bhijhabha lepi zabibu kuhoma mu michongoma. ");
INSERT INTO kiz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munu mwema katika hazina jha muene mu muoyo bhwake ipisya ghaghajhele mabovu. kwandabha kinywa kya muene ijobha ghala ghaghakaumemesya muoyo ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kwanda jha kiki mkanikuta, 'Bwana, Bwana', na bado mkaghabhomba lepi ghala ghanijobha? ");
INSERT INTO kiz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Khila munu jhaihida kwa nene ni kughap'eleka malobhi ghangu ni kughatendela mbombo, nibeta kubhalasya kya ajhele. ");
INSERT INTO kiz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iwaningana ni munu jhaijenga nyumba jha muene, ambajhe igima pasi sana, ni kujenga msingi bhwa nyumba panani pa mwamba imara. Mafuriko bho ghahidili, mahemu gha masi ghajhitobhili nyumba, lakini ghabhwesilepi kujhihugusya, kwa ndabha jhajengibhu kinofu. ");
INSERT INTO kiz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini jhejhioha jhe ep'eleka lilobhi lyangu na alitii lepi; mfano bhuake ndo munu jhaajengili nyumba panani pa ardhi bila msingi, kiholo bho kiselili lwa nghofu, nyumba jhela jhakabhili maangamizi mabhaha. ");
INSERT INTO kiz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baada jha Yesu kumala khila khenu kya ajobheghe kwa bhanu bhabhamp'elekisieghe, akajhingila Kapernaumu. ");
INSERT INTO kiz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mtumwa fulani ghwa akida, jhaajhe ghwa thamani sana kwa muene, ajhen'tamu sana na ajhele karibu kufwa. ");
INSERT INTO kiz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lakini bho ap'eliki kuhusu Yesu, jhola Akahida andaghisi ndongosi ghwa kiyahudi kun'soka ahidayi kumwokola mtumwa ghwa muene ili asifi. ");
INSERT INTO kiz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bhobhafikiri karibu ni Yesu, bhan'sihili kwa bidii ni kujobha, “akestahili kwamba ghwilondeka kubhomba naha kwandabha jha muene, ");
INSERT INTO kiz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwandabha aliganili litaifa lya tete, na ndo jhaajengili lisinagogi kwandabha jha tete”. ");
INSERT INTO kiz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu akajhendelela ni safari jha muene pamonga nabhu. Lakini kabla jha kulota patali ni nyumba, afisa mmonga abhalaghisi marafiki zake kulongela naku. “Bwana, usikitondesi ghwe muene kwandabha nene nilondeka lepi bhebhe kujhingila mu dari jhangu. ");
INSERT INTO kiz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kwandabha ejhe nafikiririlepi hata nene nemwene kujha nilondeka kuhida kwa bhebhe, lakini jobhayi lilobhi tu ni mtumishi ghwa nene ibeta kupona. ");
INSERT INTO kiz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwani ni nene ne munu jha nibhekhibhwa mu mamlaka na nijhe ni askari chini jha nene. Wijobha kwa ojho “Lotayi” na ilota, nikwajhongi, “Hidayi” ni muene ihida, ni kwa mtumishi ghwa nene 'bhomba ekhe', ni muene ibhomba”. ");
INSERT INTO kiz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu bhoapeliki agha ashangele, ni kubhageukila makutano bhabhan'kesieghe ni kujobha. “Nikabhajobhela hata mu Israeli, nibhwayilepi kubhona munu mwenye imani kama ejho. ");
INSERT INTO kiz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kisha bhala bhabhalaghisibhu bhakherebhuiki kunyumba ni kun'kolela mtumishi amalikupona. ");
INSERT INTO kiz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","fulani baada jha agha, jhatokili kujha Yesu ajhe isafiri kulota mji bhwabhukutibhweghe Naini. Bhanafunzi bha muene bhakalota pamonga nabhu bhakaambatana ni umati bhwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bhoafikiri karibu ni lango lya jiji langayi, munu jhaafwili ajhele ap'endibhu, na ndo muana ghwa pekee kwa nyinamunu jhaajhe mjane, ni umati bhwa bhawakilishi kuhoma mu jiji bhajhele pamonga nakhu. ");
INSERT INTO kiz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bho ambwene, Bwana akan'hegelela kwa huruma mbaha sana juu jha muene ni kun'jobhela, “Usileli”. ");
INSERT INTO kiz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kisha akahegelela palongolo akaligusa lijeneza ambalyo bhap'endili mb'ele, na bhala bhabhap'endili bhakajhema akajobha “N'songolo nijobha jhumukayi” ");
INSERT INTO kiz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mfu akajhinuka ni kutama pasi ni kujhanda kulongela. Kisha Yesu akan'kabidhi kwa nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kisha hofu ikabhamema bhoha. Bhakajhendelela kun'tukusya k'yara bhakajobha “Nabii mbaha ajhinulibhu miongoni mwa jhotu” ni “k'yara abhalangili bhanu bha muene” ");
INSERT INTO kiz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ese habari sinofu sya Yesu syajhenili Yudea jhioha ni mikoa ghioha ghya jirani. ");
INSERT INTO kiz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bhanafunzi bha Yohana bhakan'jobhili mambo agha ghoha. ");
INSERT INTO kiz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ndipo Yohana akabhakuta bhabhele bha bhanafunzi bha muene ni kubhalaghisya kwa Bwana kujobha “Bhebhe ndo jhola jhaihida, au ajhe munu jhongi tundendelelajhi? ");
INSERT INTO kiz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bhobhafikiri karibu ni Yesu abha bhakajobha, “Yohana mbatizaji atulaghisi kwa bhebhe kujobha, 'Bhebhe ndo jhola jhaihida au ajhe jhongi tundendelelajhi?” ");
INSERT INTO kiz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kwa wakati obho abhaponyisi bhanu bhingi bhenye matamu ni malombosi, kuhoma kwa roho bhachafu ni kwa bhanu bhenye upofu wabhapelili kulanga. ");
INSERT INTO kiz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu ajibili ni kujobha kwa bhene. “Baada jha kujha mlotili kwa muhomili mwibeta kumjulisha Yohana kya mukibhwene ni kup'eleka. Bhenye upofu bhipokela kulola ni fiwete bhibeta kugenda, bhenye ukoma bhitakasika viziwi bhibeta kup'eleka, bhafu bhifufulibhwa ni kujha hai kabhele, masikini bhijobhibhwa habari jhinofu. ");
INSERT INTO kiz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na munu jhaibeta kuleka lepi kuniamini nene kwa matendo ghangu abarikibhu”. ");
INSERT INTO kiz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baada jha bhala bhabhalaghisibhu ni Yohana kukerebhuka kwa bhahomili, Yesu akajhanda kujobha kwa makutano juu jha Yohana, “Mwalotili kwibhala kulanga kiki, litasi likajha lihugunisibhwa ni mp'ongo? ");
INSERT INTO kiz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lakini Mwalotili kwibhala kulola kiki, munu jhaafwalili kinofu? Langajhi bhanu bhala bhabhifuala maguanda gha kifalme ni kuishi maisha gha starehe bhajhe mu nafasi sya bhafalme. ");
INSERT INTO kiz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lakini mwilota kwibhala kulola kiki, Nabii? Ndio, nijobha kwa muenga ni zaidi sana kuliko nabii. ");
INSERT INTO kiz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ojho ndo jhaajhandikibhu, “Langayi, nikandaghisya mjumbe ghwa nene palongolo pa mihu gha jhomu, jhaibeta kujhandala njela kwandabha jha nene, ");
INSERT INTO kiz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nijobha kwa muenga, kati jha bhala bhabhahogoliki ni n'dala, ajhelepi mbaha kama Yohana, lakini munu jha ajhele muhimu lepi sana jhaibeta kuishi ni K'yara mahali pa ajhele muene, ibeta kujha mbaha kuliko Yohana.” ");
INSERT INTO kiz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ni bhanu bhobhap'eliki agha pamonga ni bhatoza ushuru, bhatangasisi kujha k'yara ndo ajhe ni huruma ni haki. Bhajhele kati jha bhene bhala bhabhabatisibhu kwa ubatizo bhwa Yohana. ");
INSERT INTO kiz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Mafarisayo ni bhataaalamu bha sheria sya kiyahudi, ambabho bhabatisibhulepi ni muene bhabelili hekima sya k'yara kwandabha jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kabhele nibhwesya kubhalenganisya ni. kiki bhanu bha kizazi ekhe? bhajhe bhuli hasai? ");
INSERT INTO kiz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhiwaningana ni bhana bhabhikina maeneo gha soko, bhabhitama ni kukutana mmonga baada jha jhongi bhijobha, 'Tukobhili filimbi kwandabha jha muenga na mwakinilepi. Tuombolisi na mulelilepi.' ");
INSERT INTO kiz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana mbatizaji ahidili alilepi n'kate wala kunywa divai, na mwajobhili “Ajheni pepo. ");
INSERT INTO kiz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana ghwa munu ahidili alili ni kunywa na mwajobhili, “Langayi ndo mlafi na ndefi, rafiki ghwa bhatoza ushuru ni bhenye dhambi! ");
INSERT INTO kiz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lakini hekima itambuliki kujhe ijhe ni haki kwa bhana munu bhoha” ");
INSERT INTO kiz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mmonga ghwa Mafarisayo ans'okili Yesu alotayi kulya pamonga ni muene. Baada jha Yesu kujhingila mu nyumba jha farisayo, ajheghemili mu meza ili aliayi. ");
INSERT INTO kiz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Langayi kwajhele ni n'dala mmonga katika jiji e'lu jhaajhe ni dhambi. Agunduili kujha atamili kwa farisayo, akaleta chupa jha manukato. ");
INSERT INTO kiz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ajhemili kunyuma jha muene karibu ni magolo gha muene khoni ilela. Kabhele ajhandili kulobhanisya magolo gha muene kwa mahosi, ni kujhifuta kwa niwili sya mutu bhwa muene akaibusu magolo gha muene ni kujhibaka manukato. ");
INSERT INTO kiz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ni jhola Farisayo jhaamwaliki Yesu bho abhuene naha, akawasya muene akajobha, “Kama munu ojho ngaajhe nabii, ngaamanyi ojho niani na ni aina jheleku jha n'dala jhaikan'gusa, jhakujha mwenye dhambi. ");
INSERT INTO kiz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ajibili ni kujobha, “Simoni nijhe ni khenu kyakijobhela.”akajobha” “kijobha tu Mwalimu!” ");
INSERT INTO kiz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu akajobha “kwajhele ni bhaefaiwa bhabhele kwa mkopeshaji mmonga. Mmonga akabha wa idaibhwa dinari Mia tano ni bhwa pili adaibhu dinari hamsini. ");
INSERT INTO kiz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na bhobhajhelapi ni hela jha kundapa akabha samehe bhoha. Henu nieni jha ibeta kurigana zaidi? ");
INSERT INTO kiz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni ajibilili ni kujobha, “Nidhani jha asamehibhu nesu.” Yesu akanijobhla, “Uhukumuili kwa usahihi.” ");
INSERT INTO kiz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu akanigeukila n'dala ni kujobha kwa Simoni, “Umbwene n'dala ojho. Nijhingili munyumba jha jhobh. Unipelihitapi masi kwandabha jha magolo gha nene, lakini ojho, kwa mahosi gha muene alobhani si magolo gha nene ni kuifuta kwa njuili sya muene. ");
INSERT INTO kiz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wanibusuililepi, lakini muene, tangia ajhingili o'mo alekilepi kunibusu magola gha nene. ");
INSERT INTO kiz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gwa jhibaki lepi magolo gha need nene mafuta, lakini ajhibakili magolo gha nene kwa manukato. ");
INSERT INTO kiz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa lijambo ele, nikujobhela kujha ni dhambi semehele na asamehibhu nesu, na kabhele aganili nesu. Lakini jha asamehibhu kidebe, igana kidebe tu.” ");
INSERT INTO kiz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Baadajhe akan'jobhela n'dala, “Dhambi sya bhebhe simalikusamehebhwa” ");
INSERT INTO kiz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bhala bhabhatamili pameza pamonga ni muene bhakajhanda kujobhesana bhene kwa bhene, “Ojho niani mpaka isamehe dhambi?” ");
INSERT INTO kiz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ni Yesu akan'jobhela n'dala, “Imani jha jhobhi jhikuokwili. Lotayi kwa amani” ");
INSERT INTO kiz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jhatokili muda mfupi baada jha kwamba Yesu ajhandili kusafiri mu miji ni jiji mbalimbali, akihubiri ni kutangasya habari sinofu sya ufalme bhwa K'yara ni bhala kumi ni bhabhele bhalotili pamonga nakhu, ");
INSERT INTO kiz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","khelakhela, bhadala fulani bhabhaponyisibhu kuhoma kwa roho bhachafu ni matamu mbalimbali. Bhajhele ndo Mariamu jhaakutibhu Magdalena ambajhe ajhele abhosibhu mapepo saba. ");
INSERT INTO kiz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana ndala ghwa Kuza ni meneja ghwa Herode, Susana, ni bhadala bhangi bhingi, bhabhapisili mali jha muene Kwandabha jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ni baada jha umati bhwa bhanu kubhonganika pamonga bhakajha ni bhanu bha bhahideghe kwa muene kuhoma miji mbalimbali, akalongela nabhu kwa kutumila mifuanu. “ ");
INSERT INTO kiz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mpandaji akalota kupanda mbeyu, bho apandili, baadhi sya mbeyu e'su sya binili kando jha jhela syakanyibhu pasi pa magolo, ni fidege fya angani fyalili. ");
INSERT INTO kiz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeyu senge syabinili panani pa udongo bhwa miamba na bho simelili ni kujha miche bho sibholili kwa ndabha jha kutokujha ni unyevunyevu. ");
INSERT INTO kiz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeyu s'enge syabinili mu mumabehe gha mifwa, ni ejhu mabehe ghya mifwa ghyakholili pamonga ni mifwa ghela ni mbeyu syasongibhu. ");
INSERT INTO kiz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lakini mbeyu s'enge syabinili mu udongo bhwawilondeka na syahoguili mazao mara mia nesu. “Baada jha Yesu kujobha mambo agha akwesi sauti, “Jhejhioha jha ajhe ni mb'olokoto na ap'elekayi.” ");
INSERT INTO kiz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kabhele bhanafunzi bha muene bhakan'kota ndabha jha mfano obhu, ");
INSERT INTO kiz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu akabhajobhela, “Mupelibhu upendeleo bhwa kumanya siri jha ufalme bhwa K'yara, lakini bhanu bhamana bhibetakufundisibhwa tu kwa mifuano, ili kwamba 'bhakabhonayi bhasibhone na bhakap'elekayi bhasichelibhwi.' ");
INSERT INTO kiz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na ejhe ndo maana jha mfano obho. Mbeyu ndo lilobhi lya K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu s'ele syasabinili kando jha njela ndo bhanu bhabhip'eleka litobhi, ni baadaye mwovu shetani akalilota patali mu mioyo, ili kwamba bhasiamini ni kuokolibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kisha ni s'ela syasibinili mu muamba ndo bhanu bhala bhabhip'oleka lilobhi ni kulipokela kwa furaha lakini bhajhelepi ni mizizi gheghioha, bhiamini ku kwa muda mfupi, ni wakati bhwa majaribu bhibina. ");
INSERT INTO kiz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni mbeyu s'ela syasibinili mu mifwa ndo bhanu bhabhakalip'eleka lilobhi, lakini pabhijhendelela kutama bhisongibhwa ni huduma sya utajiri ni unofu bhwa maisha agha na bhihogola lepi matunda. ");
INSERT INTO kiz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lakini mbeyu s'ela syasibini mu udongo unofu ndo bhale bhanu, ambabho bhanyenyekevu ni mioyo minofu, baada jha kulipeleka litobhi bhakalikamulila ni kujha salama ni kuhogola matunda gha uvumilivu. ");
INSERT INTO kiz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Henu, ajhelepi hata mmonga, jhaibhwasya taa ni kuifunika kwa bakuli au kujhibheka pasi pa kitanda. Badala jha kujhibheka pa kinara kya taa ili kwamba khila mmonga jhaijhingila akabhayi kujhibhona. ");
INSERT INTO kiz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kwa kujha kijhelepi kya kifighama ambakyo kibetalepi kumanyikana, au kyokyoha kya kijhele sirini ambakyo kibetalepi kumanyikana kikajhelayi mu muanga. ");
INSERT INTO kiz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwa hiyo jhelayi makini pawijha wip'elekesya. Kwandabha jhaajhihenaku, kwa muene ibetakujhongesibhwa nesu, lakini jhaabelikujha naku, hata khela kidebe kya ajhenaku kitolibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baadaye nyinamunu wa Yesu ni bhalongo munu bhakahida kwa muene bhahegelili lepi kwandabha jha umati bhwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na ajobhibhu, “Nyinamunu ni bhalongobhu bhajhele pibhala bhilonda kubhona bhebhe. ");
INSERT INTO kiz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lakini, Yesu ajibili ni kujobha, “Mabhu wa nene ni bhalongo bhangu ndo bhala bhabhip'elekesya lilobhi lya K'yara ni kulitii.” ");
INSERT INTO kiz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jhatokili ligono limonga kati jha magono ghala Yesu ni bhanafunzi bha muene apakeme mu bhuatu ni kubhajobhela, “Tulobhokayi kwiseli jha pili jha nyanja.”Bhakaandala mashua gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lakini bho bhajhandi kubhoka, Yesu agonili lugono, ni linyegha libhaha ni mp'ongo, ni mashua jhikajhanda kumema masi na lajhele libhaha sana. ");
INSERT INTO kiz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Baadaye bhanafunzi bha muene bhakahida kwa muene ni kunjumusya, bhakajobha, “Bwana mkubhwa! Bwana mkubhwa! tujhe karibu kufwa!” Akajhumuka ni kubhubesya mbelu ni bhuene bhwagudeme masi ghagudeme na kwatulili. ");
INSERT INTO kiz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kabhele akabhajobhela, “Imani jha muenga ijhendaku?” Bhakatila, bhashangele, bhakajobhesana kila mmonga ni njinu, “Ojho niani, kiasi kwamba iamuru hata mp'ongo ni masi na bhukan'tii?” ");
INSERT INTO kiz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bhakafika mu mji bhwa Gerasini jhaijhele upande bhwa kunyuma jha Galilaya. ");
INSERT INTO kiz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu bho aselili ni kukanya pa ardhi munu fulani kuhoma kumjini akabhonana naku, na munu ojhu ajhe ni nghofu sya giza. Kwa muda mrefu afwalepi nghobho, na atamelepi munyumba, atameghe kumakaburi. ");
INSERT INTO kiz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","lkojo okay ya paBho ambwene Yesu akalela kwa sauti, ni kubina pasi mbele jha muene kwa sauti mbaha akajobha, Niketikiki kwa bhebhe, Yesu ghwa K'yara jha ajhe kunani? Nikusihi usinitobhi nene” ");
INSERT INTO kiz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu akaamuru roho chafu jhimbokayi munu jhola kwa kujha mara nyingi apangili. Na hata kama ajhe mfungwa minyororo ni kubanibhwa ni kubhekibhwa chini jha ulinzi, adenyi fifungu ni kugendesibhwa ni mapepo hadi ku jangwa. ");
INSERT INTO kiz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu akan'kota, “Lihina lya jhobhi niani?” akajibu ni kujobha, “Legioni” kwamana mapepo mingi ghajhingili kwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bhakajhendelela kun'sihi usituamuru tulolayi mu lilende. ");
INSERT INTO kiz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Likundi lya maghorobhi lidimibhweghe pa kid'onda, bhakan'sihi bhakajhingilayi kwa ghala maghorobhi. Ni kubharuhusu kukheta naha. ");
INSERT INTO kiz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kwa hiyo bhala mapepo bhakamboka munu jhola ni kujhingila mu maghorobhi ni likundi lela likajumbilila mu magema gha kid'onda mpaka kumanga ni kujhibhila omu. ");
INSERT INTO kiz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bhanu bhala bha bhadimeghe maghorobhi ghala bho bhabhuene kya kihomili, bhakajumba ni kuh'omesya taarifa ku mjini ni kwibhala jha mji jha jhisyonguiki. ");
INSERT INTO kiz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bhanu bhobhapeliki aghu bhakalota kulola kya kihomili, na bhakahida kwa Yesu na bhakambona munu ambajhe mapepo gha mbokili. ajhele afwalili kinofu na ajhe ni luhala lwoha, atamili magolo gha Yesu na bhatilili ");
INSERT INTO kiz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndipo mmonga bhabhi jhaabhwene kyakahomili ajhandili kubhapangila bhangi jinsi munu ojho jhaalongisibhweghe ni mapepo kyaaponyibhu. ");
INSERT INTO kiz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bhanu bhoha bha mkoa ghwa Bhageresi ni maeneo gha ghasyonguiki bhan'sokili Yesu abhokayi kwa bhene Kwandabha bhajhele ni hofu mbaha. Na ajhingili mu bhuatu ili akerebhukayi. ");
INSERT INTO kiz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Munu jhola jhaajhe ni mapepo an'sihili Yesu kubhoka naku, lakini Yesu akan'jobhela alotayi ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ukerebhukayi kunyumba jha jhobhi na ubhalangayi ghala ghoha ambagho k'yara akubhombili” Munu ojho akabhoka, akatangasya poha mu mji bhuoha ghala ghoha ambagho Yesu aghabhombili kwa muene. ");
INSERT INTO kiz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ni Yesu akakerebhuka, makutano bhakan'karibisya, kwandabha bhoha bhakajha bhakandendela. ");
INSERT INTO kiz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Langayi akahida munu mmonga ikutibhwa Yairo ni mmonga kati jha bhalongosi mu sinagogi. Yairo akabina pa magolo gha Yesu ni kun'sihi alotayi kunyumba jha muene, ");
INSERT INTO kiz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kwandabha ajhele ni muana n'dala mmonga tu, mwenye umri bhwa miaka kumi ni mibhele, na ajhele mu hali jha kufwa. Na bho ilota, makutano bhakajha bhisongamana dhidi jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","N'dala mwenye kupisya damu miaka kumi ni mibhele ajhele pala na atumili hela syoha kwa bhaganga, lakini ajhelepi hata mmonga jha amponyisi, ");
INSERT INTO kiz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ahidili kunyuma jha Yesu ni kukamula pindo lya liguanda lya muene ni ghafla kupita damu kukaleka. ");
INSERT INTO kiz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu akajobha, “Niani anikamuili?” Bhobhabelili bhoha, Petro akajobha, Bwana mkubhwa, umati bhwa bhanu bhikusukuma ni kusongana.” ");
INSERT INTO kiz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu akajobha, “Munu mmonga anigusili, mana nimanyili nghofu sinibhokili kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","N'dala bho abhuene ibhwesyalepi kwifigha kyaakikhetili, akajhanda kutetemeka, akabina pasi palongolo jha Yesu akatangasya mbele jha bhanu bhoha sababu syaabhombili an'gusayi ni fela kya aponyibhu ghafla. ");
INSERT INTO kiz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kisha akajobha kwa muene, “Binti, imani jha jhobhi hikubhombili ujhelayi ghwa mzima. Lotayi kwa amani.” ");
INSERT INTO kiz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bho ijhendelela kujobha, munu mmonga akahida kuh'oma munyumba jha ndongosi ghwa sinagogi, akajobha, “Binti ghwa jhobhi afuili. Usin'sumbuli mwalimu.” ");
INSERT INTO kiz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lakini Yesu bho ap'eliki naha, an'jibili, “Usitili. Aminiayi tu, na ibeta kuokolibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kisha bho ajhingili mu nyumba ejhu, aruhusuili lepi munu jhejhioha kujhingila pamonga ni muene, isipokujha Petro, Yohana ni Yakobo, Dadi munu ghwa binti, ni nyinamunu. ");
INSERT INTO kiz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Henu bhanu bhoha bhakajobha bhiomboleza ni kuhomesya sauti kwandabha jha muene, lakini akajobha, “Musipigi makelele, afwilepi, lakini agonili tu.” ");
INSERT INTO kiz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lakini bhakan'heka kwa dharau, bhamanyi kujha afuili. ");
INSERT INTO kiz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini muene, akan'kamula binti kibhoko, akakuta kwa sauti, akajobha, “Muana, jhemayi” ");
INSERT INTO kiz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","roho jha muene jhikan'kerebhukila, na ajhinuiki wakati bhobhuobhu. Akaamrisha kujha apelibhwayi khenu fulani ili aliajhi. ");
INSERT INTO kiz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bhazazi bha muene bhashangele, lakini abhaamuiri bhasin'jobheli munu kyakatokili. ");
INSERT INTO kiz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Akabhakuta bhala kumi ni bhabhele pamonga, akabhapela uwezo bhwa mamlaka juu jha mapepo ghoha ni kuponyesya bhatamu. ");
INSERT INTO kiz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akabhalaghisya bhalotayi kuhubiri ufalme bhwa K'yara ni kunyesya bhatamu. ");
INSERT INTO kiz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akabhajobhela, “Msitolikyoha kwandabha jha safari jha jhomu wala ndonga, wala mkoba, wala n'kate, wala hela wala musitoli kanzu sibhele. ");
INSERT INTO kiz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba jhejhioha jhamwibeta kujhingila, mutamayi omu mpaka pa mwibeta kubhoka mahali apu. ");
INSERT INTO kiz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na kwa bhala bhabhita kubhapokela, pamwibeta kubhoka pa mji obhu, mkikung'undayi malifu mu magolo gha jhomu kwa ushuhuda just jha bhene”. ");
INSERT INTO kiz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bhakabhoka kup'etela mu fijiji, kutangasya habari sinofu ni kuponyesya bhanu khila mahali. ");
INSERT INTO kiz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Henu Herode, mtawala, ap'eliki ghoha ghaghatokeleghe ataabiki nesu, kwandabha jhajobhekene ni baadhi kujha Yohana mbatizaji afufuiki kuh'omela kwa bhafu, ");
INSERT INTO kiz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ni baadhi kujha Eliya amalikuhida, ni kwa bhangi kwamba mmonga ghwa manabii bha muandi afufuiki kabhele kuh'omela bhafu kabhele. ");
INSERT INTO kiz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herode akajobha, “nanchinjili Yohana, lakini ojho niani jha nip'eleka habari sya muene? Ni Herode alondili njela jha kumbona Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wakati bhakherebhuiki bhala bhabhatumibhu, bhakan'jobhela khila khenu kya bhakhetili. Akabhatola pamonga ni muene, akalota muene mu mji bhwa bhwikutibhwa Bethsaida. ");
INSERT INTO kiz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini makutano bhakap'eleka kuhusu e'le bhakan'kesya, na abhakaribisi, ni kulongela nakhu kuhusu ufalme bhwa K'yara, na abhaponyisi bhele bhabhalondeghe uponyaji. ");
INSERT INTO kiz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ligono likajhanda kumalika ni bhala kumi ni bhabhele bhakalota kwa muene ni kujobha, “Bhatawanyayi makutano kwamba bhalotayi mu fijiji fya karibu ni mijini bhakakesiajhi mapumziko ni kyakulya, kwandabha tujhele lieneo lya kunyika.” ");
INSERT INTO kiz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini akabhajobhela, “Muenga mubhap'elayi khenu kya kulya.” Bhakajobha “Tujhelepi nafu zaidi jha fipandi fihanu fya mikate ni somba sibhele isipokujha ngatulotili ni kuhemela kyakulya kwandabha jha likusanyiku e'le lya bhanu.” ");
INSERT INTO kiz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kwajhele ni bhagosi kama elfu tano pala. Akabhajobhela bhanafunzi bha muene. “Bhatamikayi pasi mu makundi gha bhanu kama hamsini kwa khila likundi. ");
INSERT INTO kiz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kwa hiyo bhakakheta mebhu ni bhanu bhakatama pasi. ");
INSERT INTO kiz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Akatola mikate mihanu ni somba sibhele ni kulanga kunani, akafibariki ni kufimetula mu fipandi akabhapela bhanafunzi bha muene ili bhafibhekayi palongolo pa makutano. ");
INSERT INTO kiz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhoha bhalili na bhashibili, ni fipandi fya fyakulya fya fyabakili fyaholibhu ni kumemesya fikapu kumi ni fibhele. ");
INSERT INTO kiz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nijhiene jhajhele kwamba, bho isoka muene, bhanafunzi bha muene bhajhele pamonga ni muene, na abhakotili akajobha, “Bhanu bhijobha nene ne niani?” ");
INSERT INTO kiz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhakajibu, bhakajobha, “Yohana mbatizaji, lakini bhangi bhijobha Eliya, ni bhamana bhijobha mmonga ghwa manabii bha nyakati sya muandi afufuiki kabhele.” ");
INSERT INTO kiz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Akabhajobhela, “Lakini muenga mwijobha nene ne niani?” Ajibili Petro akajobha, “Kristu kuhomela kwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lakini kwa kubhaonya, Yesu akabhajhelekesya kutokun'jobhela jhejhioha just jha e'le, ");
INSERT INTO kiz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akajobha kwamba mwana ghwa Adamu lazima atesekajhi kwa mambo ghamehele ni kubelibhwa ni bhaseya ni makuhani bhabhaha ni bhaandishi na ibetakukhomibhwa, ni ligono lya tatu ibeta kufufuka. ");
INSERT INTO kiz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Akabhajobhela bhoha, “kama munu jhejhioha ilonda kunikesya, lazima akibelayi muene, atolayi n'salaba ghwa muene khila ligono na anikesiajhi. ");
INSERT INTO kiz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jhejhioha jhaijaribu kughaokola maisha gha muene ibeta kughajhasya, lakini jhejhioha jha ibeta kughajhasya maisha gha muene, kwa faida jha nene, ibeta kughaokola. ");
INSERT INTO kiz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Je kibetakumfaidila kiki mwanadamu, kama aukabhili ulimwengu bhuoha, lakini akajhasya au kukabha hasara jha nafsi jha muene? ");
INSERT INTO kiz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jhejhioha jha ibeta kunibhonela soni nene ni malobhi gha Joni, kwa muene mwana ghwa Adamu ibetakumbonela soni pa ibeta kujha mu utukufu bhwa muene, ni utukufu bhwa Dadi. ni malaika bhatakatifu. ");
INSERT INTO kiz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lakini nikabhajobhela ukweli, kuna baadhi jha jhomu jhamujhemili apa, bhibeta lepi kubhonja umati mpaka bhaubhonayi ufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jhatokili yapata magono nane baada ya Yesu kujobha malobhi agha kwamba ibeta kubhatola pamonga nabhu Petro, Yohana ni, Yakobo, bhakakuela pa kid'onda kus'oka. ");
INSERT INTO kiz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bho ajhe mu maombi, muonekanu bha usobhwa muene bhwabadiliki, ni maguanda gha muene ghajhele mabhalafu ni ngekun'gara. ");
INSERT INTO kiz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na langayi, bhajhele bhagosi bhabhele bhilongela naku! Bhajhele Musa ni Eliya, ");
INSERT INTO kiz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bhabhonekene mu utukufu. bhalongelili kuhusu kubhoka kwa muene, lijambo ambalyo akaribili kulitimisya Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Henu Petro ni bhala bhabhajhe pamonga nakhu, bhajhele mu lugono. Lakini bho bhajhumuiki bhabhubhuene utukufu bhwa muene ni bhagosi bhabhele bhabhajhemili pamonga nakhu. ");
INSERT INTO kiz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jhatokili kujha bho bhibhoka kwa Yesu, Petro akan'jobhela, “Bwana ni kinofu kwa tete kutema apa ni jhilondeka tutengenesiajhi makazi gha bhanu bhadatu. Tutengenesiajhi kimonga kwa ndabha jha bhebhe, khenge kwa ndabha jha Musa ni kimonga kwa ndabha jha Eliya.” Ajhelibhu lepi kyaalongeleghe. ");
INSERT INTO kiz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bhoijobha aghu, likahida libhengu ni kubhagupika; na bhatilili bho bhabhuene bhasyongokibhu ni libhengu. ");
INSERT INTO kiz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauti jhikahoma mu libhengu jhikajobha, “Ojho ndo mwanabhangu mteule. Munip'elekisiajhi muene.” ");
INSERT INTO kiz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sauti bho jhigudeme, Yesu ajhemuene. Bhatemili kinunu, jhejhioha miongoni mwa bhaghabhwene. ");
INSERT INTO kiz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ligono lya lyafuatili baada jha kuhoma kukid'onda likusanyiku libhaha lya bhanu lyabhonene naku. ");
INSERT INTO kiz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Langayi, bhagosi kuhoma kulikusanyiku alelili kwa sauti, akajobha, “Mwalimu nikus'oka undangayi mwana bhangu kwa kujha ndo mwanabhangu ghwa pekee. ");
INSERT INTO kiz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wilola roho bhachafu bhan'kamuili, ni mara ipiga makelele, na kabhele ghikambomba achanganyikibhwayi ni kupita povu mu ndomo. Ni ghene ghipita kwa shida, jhikan'sabababishila maumivu makali. ");
INSERT INTO kiz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nabhasiili bhanafunzi bha jhobhi kujhikemela jhibhokayi. lakini bhabhwesilepi.” ");
INSERT INTO kiz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu akajibu akajobha, “Enyi kizazi kya kibela kuameni na kyakipotuiki, mpaka ndali nibetakujha namu ni kutolana namu? Ndetayi mwanabhu apa.” ");
INSERT INTO kiz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","N'songolo jhaahideghe, roho chafu jhikembinisya pasi ni kun'hugusya kwa fujo. Lakini Yesu ajhikemili jhela roho chafu, amponyisi n'gosi, ni kunkabisya kwa dadi munu. ");
INSERT INTO kiz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bhoha bhasyangesibhu ni ubhaa bhwa K'yara. Lakini bho bhakastaajabu bhoha kwa mambo ghoha ghaghabhombiki, akajobha kwa bhanafunzi bha muene, ");
INSERT INTO kiz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Malobhi ghabhatamayi mu mbolokhoto sya muenga, kwa kujha mwana ghwa Adamu ibeta kupisibhwa mumabhoko mwa bhanadamu.” ");
INSERT INTO kiz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini bhajhelibhu lepi maana jha malobhi aghu, na ghalighibhu pamihu pa bhene, ili bhasihidi kulijhelebhwa. Bhatilili kun'kota Yesu kuhusu lilobhi e'lu. ");
INSERT INTO kiz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kisha mgogoro bhwajhandili bhwazukili miongoni mwa bhene juu jha niani ngaajhe mbaha. ");
INSERT INTO kiz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lakini Yesu bho amanyili kyabhajhele bhikihoji mu mioyo ghya bhene, bhan'tolili muana n'debe ni kumbeka lubhafu kwa muene, ");
INSERT INTO kiz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na akajobha “Kama munu jhejhioha ampokili mwana n'debe kama ojho kwa lihina lya nene, ibeta kujha anipokili nene, na jhejhioha jhaibeta kunipokela nene ibeta kujha ampokili jha anitumili, kwa kujha jheajhe n'debe kati jha muenga mwebhoha ndo mbaha” ");
INSERT INTO kiz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana akajibu akajobha, “Bwana, twambwene munu ibhenga pepo kwa lihina lya bhebhe na twambesili, kwandabha igenda lepi ni tete.” ");
INSERT INTO kiz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu akabhajobhela, “Musimbesi, kwa kujha ghaabelikujha kinyume ni muenga” ");
INSERT INTO kiz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","atokili kwamba, kulengana ni magono kyaghakaribileghe gha magono gha muene gha kulota kumbinguni, kwa bhuimara ajhelekisi uso bhwa muene Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akatume bhajumbe palongolo pa muene, na bhene bhakalota ni kujhingila mu kijiji kya bhasamaria ili bhantayarishilayi mahali. ");
INSERT INTO kiz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini bhanu oku bhampokili lepi, kwandabha ajhele ajhele kisi usobhwa muene Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bhanafunzi bha muene Yakobo ni Yohana bhobhali bhwene e'le, bhakajobha, “Bwana ghwilonda tuamuruajhi muoto uselelayi pasi kuhoma kumbinguni ubhatekatesiajhi?” ");
INSERT INTO kiz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lakini abhageukili abhakemili. ");
INSERT INTO kiz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kisha bhakalota kijiji khenge. ");
INSERT INTO kiz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bhobhilota mu njela jha bhene, munu mmonga akabhajobhela, “Nibeta kukesya popoha pa wilota.” ");
INSERT INTO kiz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akabhajobhela, “Mbweha bhajhe ni malende, fidege fya kuanga fijhe ni fiswisi, lakini mwana ghwa Adamu ajhelepi ni pakugoneka mutu ghwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndipo akan'jobhela munu j'hongi, “Nikhesiajhi.” Lakini muene akajobha, “Bwana, niruhusiajhi hoti nikan'syelayi dadi jhangu,” ");
INSERT INTO kiz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lakini muene akan'jobhela, “Bhalekayi bhafu bhasyelenayi bhene, lakini bhebhe lotayi ukautangasiajhi ufalme bhwa K'yara khila mahali.” ");
INSERT INTO kiz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pia munu jhongi akajobha. “Nibetakukesya, Bwana, lakini niruhusiajhi hoti nikabhalaghayi bhabhajhele mu nyumba jha nene.” ");
INSERT INTO kiz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lakini Yesu akan'jobhela, ajhelepi munu, jhaisopa kibhoko kya muene kulima ni kulanga kunyuma jhaibeta kulondeka KU ufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baada jha mambo agha, Bwana akahagula sabini bhangi, ni kubhalaghisya bhabhele bhabhele bhandongo lelayi mu khila mji ni lieneo lya atarajileghe kulota. ");
INSERT INTO kiz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akabhajobhela, “Mavuno ghamehele, lakini bhabhomba mbombo bhadebe. Hivyo basi mun'sokayi Bwana ghwa mavuno, ili kwamba atumayi manyata bhabhomba mbombo mu mavuno gha muene. ");
INSERT INTO kiz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mulotayi mu miji. Mulangayi nikabhatuma kama kondoo pagati pa mbwa mwitu. ");
INSERT INTO kiz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Musipendi mfuku ghwa hela, wala mikoba jha bhasafiri, wala firatu, wala msimponesi jhejhioha munjela. ");
INSERT INTO kiz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Katika nyumba jhejhioha jhamwibeta kujhingila, hoti mujobhayi, 'Amani jhiyelayi pa nyumba ejhe pala, ");
INSERT INTO kiz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","amani jha muenga jhibeta kubakila panani pa muene, lakini kama siyo, jhibeta kukerebhuka kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mubakilayi mu nyumba ejhu, muliajhi na munywayi kyabhibetakuphepela, kwandabha mfanyakazi ikastahili mshahara ghwa muene. Musihami kuhoma nyumba ejhe kulota jhenge. ");
INSERT INTO kiz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mji bhobhuoha bhwa mwijhingila, ni kubhapokela, muliajhi kyokyoha kyakibetakubhekibhwa palongolo pa jhomu, ");
INSERT INTO kiz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","na muponyesiajhi bhatamu bhabhajhele omu mujhobha kwa bhene, 'ufalme bhwa K'yara uhidili karibu jha muene' ");
INSERT INTO kiz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini mu mji bhobhuoha bhamwibeta kujhingila, na bhasibhapokeli, mulotayi mu barabara na mujobhayi, ");
INSERT INTO kiz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Hata lifu lya lijhele magolo gha jhotu tukalikung'hunda dhidi jha muenga! lakini mumanyajhi e'le, Ufalme bhwa K'yara ukaribili.' ");
INSERT INTO kiz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nikabhajobhela ligono lya hukumu libeta kujha ni ustahimilivu nesu kuliko sodoma kuliko mji obhu. ");
INSERT INTO kiz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ole bhwaku Korazini, Ole bhwaku Bethsaida! Kama mbombo mbaha syasibhombiki mugati mwa jhobhi ngajhibhombiki Tiro ni Sidoni, ngabhatubuili lukhombi nesu, bhitama mugati mu nghobho sya magunila ni malienge. ");
INSERT INTO kiz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lakini jhibeta kujha usitahimilivu nesu ligono lya hukumu kwa Tiro ni Sidoni zaidi jha muenga. ");
INSERT INTO kiz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bhebhe Karperinaumu, wifikiri wibeta kujhinulibhwa hadi kumbinguni? Lepi wibetakuselesibhwa pasi hadi kuzimu ");
INSERT INTO kiz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jhaibeta kubhap'elekesya muenga anip'elekesiajhi nene na jhejhioha jhaibeta kubhabela akanibeta nene, akambela jha anitumili “ ");
INSERT INTO kiz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bhala sabini bhakherebhuiki kwa furaha, bhakajobha, “Bwana, hata mapepo ghakatutii kwa lihina lya jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu akabhajobhela, “Nimbwene shetani abinili kuhoma kumbinguni kama radi. ");
INSERT INTO kiz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Langayi nibhapelili mamlaka gha kukanya linjoka ni kip'el'el'e ni nghofu syoha sya adui, na kyelepi kyokyoha kwa njela jhejhioha kyakibeta kubhadhuru. ");
INSERT INTO kiz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hata hivyo musihobhoki tu kwa e'le kwamba roho sikabhatii lakini muhobhokayi nesu kwamba mahina gha jhomu ghalembibhu kumbinguni.” ");
INSERT INTO kiz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mu mda bhola bhola ahobhwiki nesu mu roho mtakatifu, ni kujobha, “Nikusifu bhebhe, Dadi, Bwana ghwa mbingu ni dunia, kwandabha ughafighili mambo agha kwa bhenye hekima ni luhala, ni kughafunula kwa bhabhafundisibhu lepi, kama bhana bhadebe. Ndo, Dadi, kwa kujha ngajhipendisi muhu gha jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Khila khenu kikabidhibhu kwa nene ni Dadi jhangu, na ajhelepi jha amanyili mwana ndo niani ila mwana, na jhejhioha ambajho mwana inoghela kwifunula kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Akabhageukila bhanafunzi, akajobha pa faragha, “Bhabarikibhu bhabha kaghabhona agha ambagho nene nikaghabhona agha ambagho nene nikaghabhona. ");
INSERT INTO kiz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nikabhajobhela muenga, kujha manabii bhamehele ni bhafalme bhanogheleghe kulola mambo gha mkaghabhona, na bhaghabhwene lepi ni mkaghap'eleka na bhaghap'eliki lepi.” ");
INSERT INTO kiz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Langayi, mwalimu fulani ghwa sheria jha kiyahudi ajhemili ni kun'jaribu, akajobha, “Mwalimu, niketa kiki ili niurithi uzima bhwa milele?” ");
INSERT INTO kiz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu akan'jobhela, “Kilembibhu kiki mu sheria? Ukaisoma bhuli?” ");
INSERT INTO kiz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akajibu akajobha, “Wibetakun'gana Bwana K'yara ghwa jhobhi kwa muoyo bhwa jhobhi bhuoha, kwa roho jha jhobhi jhioha, kwa nghofu sya jhobhi syoha, ni kwa luhala lwa jhobhi lwoha ni jirani jhakhu kama nafsi jha jhobhi ghwe muene.” ");
INSERT INTO kiz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu akajobha, “Ujibili kwa usahihi. Ketayi mebhu na wibeta kuishi.” ");
INSERT INTO kiz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini Mwalimu, akalonda kwibhalangila haki muene, akan'jobhela Yesu, “Ni jirani jhangu niani?” ");
INSERT INTO kiz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ajibili akajobha, “Munu fulani akajha iselela kuhoma Yerusalemu kulota Yeriko. Akabina pagati pa bhanyang'anyi, bhabhanyakili mali sya muene, ni kun'tobha ni kundeka karibu ajhe nusu kufwa. ");
INSERT INTO kiz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwa bahati kuhani fulani akajha iselela mu njela ejhu, bho ambwene akapeta lubhafu l'ongi. ");
INSERT INTO kiz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mebhwa ni mlawi kabhele, bho afikili mahali pala ni kumbona, akap'eta lubhafu l'ongi. ");
INSERT INTO kiz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini Msamaria mmonga, bho asafiri, ap'etili pala pajhele munu ojhu. ambwene asukumibhu ni huruma. ");
INSERT INTO kiz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","An'hegeriri ni kun'konga filonda fya muene, akajhitisya mafuta ni divai panani pa muene. Akan'kwesya panani pa mnyama bhwa muene ni kump'eleka mu nyumba jha bhahesya ni kun'hudumila. ");
INSERT INTO kiz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ligono lya lyafwatili atolili dinari sibhele, ni kumpela mmiliki ghwa nyumba jha bhahesya ni kun'jobhela, 'N'hudumilayi ni kyokyoha kya ziada kya wibeta kutumila, nibekulepa panibekukerebhuka.' ");
INSERT INTO kiz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jholekhu kati jha abha bhadatu, wifikiri, ajhele jirani kwa muene jha abinili mwa bhanyang'anyi?” ");
INSERT INTO kiz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mwalimu akajobha, “Ni jhola jha alasili huruma kwa muene.” Yesu akan'jobhela, “Lotayi na ukakhetayi mebhu” ");
INSERT INTO kiz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Henu bho bhisafiri, bhajhingili mu kijiji fulani, ni n'dala mmonga lihina lya muene Martha an'karibisi kunyumba jha muene. ");
INSERT INTO kiz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ajhele ni dada jha akutibhweghe Mariamu, jhaatamili pa magolo gha Bwana ni kup'elekesya lilobhi lya muene. ");
INSERT INTO kiz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Martha akipelili shughuli simehele sya kuandala mlo. Alotili kwa Yesu, ni kujobha, “Bwana, wijalilepi dada jhangu anilekili nihudumilayi ne jhoni? Hivyo basi n'jobhilayi anitangayi.” ");
INSERT INTO kiz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Bwana an'jibili ni kun'jobhela, “Martha, wisumbuka juu jha mambo ghamehele, ");
INSERT INTO kiz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lakini ni khenu kimonga tu kya muhimu. Mariamu ahaguili kyakijhele kinofu, ambakyo kibetalepi kubhosibhwa kuhoma kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jhatokili wakati Yesu is'oka mahali fulani, mmonga ghwa bhanafunzi bha muene akan'jobhela, “Bwana, tumanyisiajhi tete kus'oka kama Yohana kya abhafundisi bhanafunzi bha muene'. ");
INSERT INTO kiz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu akabhajobhela, Pamwisali, mjobhayi, 'Dadi, lihina lya jhobhi litakasibhwayi. Ufalme bhwa bhebhe uhidayi. ");
INSERT INTO kiz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupelayi n'kate ghwitu ghwa kila ligono. ");
INSERT INTO kiz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utusamehajhi makosa gha jhotu, kama tete kyatukabhasamehe bhoha bhabhatukosili. Usitulongosi mu majaribu.” ");
INSERT INTO kiz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu akabhajobhela, “Niani kwa muenga ibeta kujha rafiki ambajhe ibeta kundotela pakilu, ni kun'jobhela, Rafiki nijhasimayi mikate midatu. ");
INSERT INTO kiz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwandabha rafiki jhangu anihidili hanu naha kuhoma mu safuari nani nidulili kya kunjandalila. ");
INSERT INTO kiz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ni jhola jhaajhe mugati akajibu, usinitaabisi, ndiangu undendibhu, ni bhanabhangu, pamonga ni nene tumalili kugona pa kitanda. Nibhwesya lepi kujhumuka ni kupela bhebhe mikate. ");
INSERT INTO kiz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nikabhajobhela, japokuwa ijhumuka lepi ni kupela mikate kama rafiki jhake, kwa kujhendelela kun'gongela bila soni, ibeta kujhumuka nikupela fipandi fingi fya mikate kulengana ni mahitaji gha jhobhi. ");
INSERT INTO kiz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nani kabhele nikabhajobhela, Mus'okayi, namu mwipelibhwa; mulondayi namu nwikabha, mupigayi hodi namu mwifungulibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwa kujha khila munu jhais'oka ibeta kupokela na khila munu jhailonda ikabha, ni khila munu jhaipga hodi ibetakufungulibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Dadi jholekhu miongoni mwa muenga, mwanamunu akan'sokayi somba akampela liyoka? ");
INSERT INTO kiz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au akas'omayi lifombi akampela kip'el'el'e? ");
INSERT INTO kiz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwa hiyo, ikajhiajhi mwe bhaovu mumanyili kubhap'ela bhana bhinu zawadi sinofu, je nesu lepi sana Dadi jhinu ghwa kumbinguni kwamba ibeta kubhap'ela Roho mtakatifu abhu bhabhakarisoka?” ");
INSERT INTO kiz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Baadaye, Yesu akajha ikemela pepo, ni munu mwenye pepo ajhele bubu. Bho pepo limbokili, munu ojhu abhwesi kulongela. Umati bhwastaajabili nesu. ");
INSERT INTO kiz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini bhanu bhangi bhakajobha, ojho ibhosya mapepo kwa Beelzebul, mbaha ghwa mapepo ");
INSERT INTO kiz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhangi bhan'jaribili kwa kundonda abhalasiajhi ishara kuhomela kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini Yesu aghatambuili mawazo gha bhene nikubhajobhela, “Khila ufalme bhwa wibeta kugawanyika ibeta kujha ukebha, ni nyumba jhajhigawanyiki jhibeta kubina. ");
INSERT INTO kiz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kama shetani ibeta kujha agawanyiki, ufalme bhwa muene bhwibeta kujhema bhuli? kwandabha mwijibha nibhosya mapepo kwa Belzebuli ");
INSERT INTO kiz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kama nene nibhosya mapepo kwa Belzebuli, je bhajhinu bhibhosya mapepo kwa njela jheleku? kwandabha ejhe bhene bhibeta kubhahukumu muenga. ");
INSERT INTO kiz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini, kama nibhosya mapepo kwa kikhonji kya K'yara basi ufalme bhwa K'yara ubhahidili. ");
INSERT INTO kiz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Munu mwenye nghofu ajhe ni silaha ilenda kunyumba jha jhobhi fenu fya muene fibetakujha salama. ");
INSERT INTO kiz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini akavamibhwayi ni munu mwenye nghofu zaidi, munu jhola mwenye nghofu ibeta kunyaka silaha sya muene, ni kulola mali sya muene syoha. ");
INSERT INTO kiz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Muene jhajhelepi pamonga ni nene ajhe kinyume ni nene, ni muene jhaibeta kubhonganiya pamonga nani nitabhwanya. ");
INSERT INTO kiz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Pepo n'chafu pa ikamboka munu, ilota kulonda ni mahali pa padulili ni mesi ili ap'omosekajhi. Paibetakudula, ajobha nikerebhuka kwa nihomili. ");
INSERT INTO kiz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Akakerebhukajhi ni kukolela nyumba jhifyaghilibhu na jhitamili kinofu. ");
INSERT INTO kiz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hivyo ilota ni kulonda mapepo saba ghaghajhele maovu kuliko muene ni kubhaleta bhahidayi bhatamayi mahali pala. Ni hali jha munu ojhu jhijha mbaya kuliko kyajhikajhela mara jha kuanza.” ");
INSERT INTO kiz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jhatokili kwamba bhoijobha malobhi aghu, n'dala fulani akakuesya sauti zaidi jha bhoha pa mkutano bhwa bhanu ni kujobha” Libarikibhu lileme lya likuhoguili ni mabhele ghauyong'ili” ");
INSERT INTO kiz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini muene akajobha, bhabarikibhu bhala bhabhi p'elekesya lilobhi lya K'yara ni kulitunza. ");
INSERT INTO kiz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wakati umati bhwa bhanu bhikibhonganiya ni kujhongeseka, Yesu akajhanda kujobha “Kizazi ekhe ndo kizazi kya uovu. Kilonda ishara, na ijhelepi ishara jhebhibeta kupelibhwa zaidi jha Yona. ");
INSERT INTO kiz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maana kama Yona kyaajhele ishara kwa bhanu bha Ninawi, ndo mwana ghwa Adamu kya ibekujha ishara kwa kizazi ekhe. ");
INSERT INTO kiz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Malkia ghwa kusini ibeta kujhema ligono lya hukumu ni bhanu bha kizazi ekhe ni kubhahukumu bhene, kwani muene ahomili kumwishu mwa nchi ili ahidayi kup'elekesya hekima sya Solomoni, ni apa ajhe mbaha kuliko Solomoni. ");
INSERT INTO kiz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bhanu bha Ninawi bhibeta kujhema mu hukumu pamonga ni bhanu bha kizazi ekhe ligono lya hukumu bhibeta kukihukumu, kwani bhene bhatubuili kwa mahubiri gha Yona, na langayi, apa ajhe mbaha kuliko Yona. ");
INSERT INTO kiz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ajhelepi munu jhejhioha, jhaibhwesya taa ni kujhibheka sehemu jha pasi jhaijhe ni ngisi jhajhibhoneka lepi au pasi pa likapu, ila ibhwasya ni kubheka panani pa khenu ili khila munu jhaijhingila abhwesyayi kulola muenga. ");
INSERT INTO kiz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lehu lya bhebhe ndo taa jha mb'ele. Lihu lya bhebhe likajhelayi linofu basi mb'ele bhwa bhebhe wibetakujha mu muenga. Lakini lihu lya bhebhe likajhelayi libaya basi mb'ele bhwa bhebhe bhuoha wibeta kujha mu ngisi. ");
INSERT INTO kiz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kwa hivyo, mkihadhariajhi ili mwanga, bhwabhujhele mugati mwa jhomu usisopibhu ngisi. ");
INSERT INTO kiz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Efyo basi, kama mb'ele ghwa jhobhi bhuoha bhujhe mu mwanga, na ajhelepi sehemu jha jhijhele mu ngisi, basi mbele bhwa bhebhe wibetakujha sawa ni taa jha jhiyaka ni kupisya mwanga kwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bhoamali kulongela, Farisayo amwaliki akaliajhi kyakulya kunyumba jha muene, ni muene Yesu akajhingila mugati ni kujha pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ni Mafarisayo bhasyangele jinsi kya abelikusamba hoti kabla jha kyakulya kya kimihi. ");
INSERT INTO kiz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lakini Bwana akabhajobhela, “Muenga Mafarisayo mwisuka kwibhala kukikombi ni bakuli, lakini mugati mwa muenga mumemili tamaa ni uovu. ");
INSERT INTO kiz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Muenga bhanu bhamuduli ufahamu, Je muene jha abhombili kwibhala abhombilepi ni mugati kabhele? ");
INSERT INTO kiz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mubhapelayi maskini ghaghajhele mugati, ni mambo ghoha ghibeta kujha manofu kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lakini ole bhinu Mafarisayo, kwani mwipisya zaka sya mnanaa ni nchi cha ni khila aina jha mbogha jha bustani. Lakini mughalekili mambo gha haki ni kun'gana K'yara. Ndo muhimu zaidi kubhomba gha haki ni kun'gana K'yara, bila kuleka kubhomba ni agha ghangi kabhele. ");
INSERT INTO kiz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ole bhinu Mafarisayo, kwa kujha mwigana kutama pa fiti fya palongolo mu masinagogi ni kuamkibhwa ni salamu sya heshima mu soko. ");
INSERT INTO kiz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ole bhinu kwani mwiwaningana ni makaburi ghaghadulili alama ambajho bhanu bhigenda panani pa bhene bila kumanya.” ");
INSERT INTO kiz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mwalimu mmonga ghwa sheria sya kiyahudi akan'jibu ni kujobha, “Mwalimu, kyawijobha kikatuudhi kabhele tete.” ");
INSERT INTO kiz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akajobha, “Ole bhinu, bhalimu bha sheria! kwani mukabhapela bhanu misighu mibhabha ghyabhibhwesyalepi kughip'enda, walakini muenga mwigusya lepi misighu ejhu hata kwa jhimonga ghya kikhonji kya jhomu. ");
INSERT INTO kiz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ole bhinu, kwandabha mwijenga ni kubheka kumbukumbu mu makaburi gha manabii ambabho bhakomibhu ni bhakhokhobhinu. ");
INSERT INTO kiz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hivyo muenga mwishuhudila ni kukubaliana ni mbombo syabhabhombili bhakhokhobhinu kwandabha hakika bhabhakhomili manabii ambabho mwijenga kumbukumbu mu makaburi gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwandabha ejhu kabhele, hekima jha K'yara jhifobha, 'Nibeta kubhatumila manabii ni mitume na bhene bhibeta kubhatesya ni kubhakoma baadhi jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kizazi ekhe kibeta kuwajibika kwa damu jha manabii bhabhakhomibhu kuhomela kwa dunia, ");
INSERT INTO kiz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kuhoma damu jha Abeli hadi damu jha Zakaria, jhaakhomibhu pagati pa madhabahu ni patakatifu. Ena, nikabhajobhela muenga, kizazi ekhe kibeta kuwajibika. ");
INSERT INTO kiz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ole bhinu bhalimu bha sheria sya kiyahudi, kwandabha mtolili fungulusya bhufahamu mwebhene mwijhingila lepi ni bhala bhabhilonda kujhingila mkabhabesya.” ");
INSERT INTO kiz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Baada jha Yesu kubhoka pala, bhaandishi ni Mafarisayo bhampingili ni kubishana ni muene juu jha mambo ghamehele. ");
INSERT INTO kiz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bhakajaribu kun'kamula kwa malobhi gha muene. ");
INSERT INTO kiz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kwa wakati obhu, maelfu mingi gha bhanu bhakusanyiki pamonga kiasi kya kujhanda kukanyana, akajhanda kujobha ni bhanafunzi bha muene hoti, “Mukihadhariajhi ni chachu jha Mafarisayo ambajho ndo unafiki” ");
INSERT INTO kiz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Na pibelepi kujha ni siri gha jhifigheme ambajho jhibeta lepi kufunulibhwa, wala lijambo lya lifighibhu ambalyo libelepi kumanyikana. ");
INSERT INTO kiz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na lyolyoha lyamwibeta kujobha mu ngisi libetapelekibhwa mu mwanga. Na ghoghoha gha mghajobhili mu mbolokhoto mu fichumba fyenu fya futendibhu ghibeta kutangasibhwa panani pa nyumba. ");
INSERT INTO kiz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nikabhajobhela marafiki zangu, musibhatili bhala bhabhikoma mb'ele na kisha bhajhelepi ni khenu khenge kya kukheta, ");
INSERT INTO kiz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lakini nikabhaonya jhamwibeta kuntila. Muntilayi jhola ambajhe baada jha kuhoma, ajheni mamlaka gha kutagha jehanamu. Ena, nikabhajobhela muenga muntilayi ojho. ");
INSERT INTO kiz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Je shomoro bhahanu bhigolesibhwa lepi kwa sarafu sibhele? hata hivyo ajhelepi hata mmonga bhabhi jhaibeta kujhebhelelibhwa palongolo pa K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lakini mumanyayi kujha, njwili sya mitu ghinu ghibhalangibhu. Msitili muenga mwebha thamani mbaha kuliko shomoro bhingi. ");
INSERT INTO kiz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nikabhajobhela, jhejhioha jha akanikiri nene mbele sya bhanu, Mwana ghwa Adamu ibeta kun'kiri mbele sya malaika bha K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini jhejhioha jhaibeta kunibela mbele sya bhanu, ni muene ibetakubelibhwa mbele jha malaika bha K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jhejhioha jhaibeta kujobha lilobhi linofu lepi kwa mwana ghwa Adamu, ibetakusamehebhwa, lakini jhejhioha jhaibekun'kufuru Roho mtakatifu, ibetalepi kusamehebhwa. ");
INSERT INTO kiz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pabhibeta kubhapeleka mbele sya bhabhaha bha masinagogi, bhatawala ni bhenye mamlaka, Musitili juu ni namna jha kulongela katika kwitetela au kiki kyamwibeta kujobha, ");
INSERT INTO kiz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwa kujha Roho mtakatifu ibetakubhafundisya kya mwibeta kujobha kwa wakati obhu.” ");
INSERT INTO kiz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Munu mmonga pa kusanyiku akan'jobhela, “Mwalimu, n'jobhelayi ndongo bhangu anigabhilayi sehemu jha urithi bhwangu.” ");
INSERT INTO kiz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akan'jibu, niani anibhekili kujha mwamuzi ni mpatanishi kati jha muenga? ");
INSERT INTO kiz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndipo akabhajobhela, mkihadhariajhi ni khila namna jha tamaa, kwandabha uzima bhwa munu ujhelepi kwa fenu fya ajhe nafu.” ");
INSERT INTO kiz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yes akabhajobhela mfano, akajobha, N'gonda ghwa munu mmonga tajiri ghwahoguili nesu, ");
INSERT INTO kiz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","na akakikota mugati mwa muene, akajobha nibetaketabhuli kwani nijhelepi ni sehemu jha kubheka mazao ghangu? ");
INSERT INTO kiz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akajobha, nibetakheta naha. Nibetakubomola ghala sya jhoni sidebe ni kujhenga jhibhaha nikuhifadhi mazao gha nene ghoha ni fenu fenge. ");
INSERT INTO kiz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nibetakujobhela nafsi jha nene, “Nafsi, ukibhakili akiba jha fenu fingi kwa miaka ghimehele. P'omosekayi, uliayi, unyuajhi ni kustarehe.” ");
INSERT INTO kiz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini K'yara akabhajobhela, ebhe munu mpumbafu, kiru kya lelu wilonda Roho kuhoma kwa bhebhe ni fenu fyoha fye ufiandele fibetakujha fya kiki? ");
INSERT INTO kiz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ndivyo kyajhibekujha kwa khila munu jhaikibhekela mali na sio kwitayarisya kwandabha jha Bwana. ");
INSERT INTO kiz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu akabhajobhela bhanafunzi bha muene, kwa hiyo nikabhajobhela musihofu juu jha maisha gha jhomu _ jha kujha mwibeta kulya kiki au juu jha mibhele ghya jhomu _jha kujha mwibeta kufuala kiki ");
INSERT INTO kiz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwa kuwa maisha ndo zaidi jha kyakulya, ni mb'ele ndo zaidi jha mavazi. ");
INSERT INTO kiz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mulangayi fidege fya anga, bhilema lepi bhwala kuvuna. Bhajhelepi ni kichumba bhwala ghala lya kubhekela, lakini Dadi jhinu akabhalasya. Muenga bora lepi kuliko fidege! ");
INSERT INTO kiz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jholekhu kati jha muenga akakisumbulayi ibhwesya kujhongesya dhiraa jhimonga katika maisha gha muene? ");
INSERT INTO kiz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ikajhiajhi mwibhwesya lepi kuketa naha ekhu khenu kidusu kyepesi kwandajha kiki kusumbukila aghu ghangi? ");
INSERT INTO kiz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mulangayi maua -kyaghimele. Ghibhomba lepi mbombo wala kusokota. Lakini nikabhajobhela, hata Sulemani mu utukufu bhwa muene bhoha afwekibhu lepi kama mmonga ghwa agha, ");
INSERT INTO kiz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kama K'yara akaghafueka kinofu mat'ondo ghakondeni, ambagho lelu ghajhele, ni kilabhu ghitaghibhwa mu muoto. Je si nesu akabhafueka muenga? mwebha imani haba! ");
INSERT INTO kiz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Msisumbukili juu jha kujha mwibeta kulya kiki au mwibeta kunywa kiki, bhwala musijhi ni hofu. ");
INSERT INTO kiz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwakujha Mataifa ghoha gha dunia ghisumbukila mambo agha. Ni Dadi jhinu amanyili kujha mwilonda aghu. ");
INSERT INTO kiz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lakini mulondayi ufalme bhwa muene hoti, ni aghu ghangi mwibeta kuzidishibhwa, ");
INSERT INTO kiz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Musitili muenga likundi lidebe, kwandabha Dadi jhinu ohobhwiki kubhap'ela muenga ufalme obhu. ");
INSERT INTO kiz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muhemelesiajhi mali sya muenga ni mali mubhapelayi maskini, mukifanyilayi mifuko ghyaghushibhwa lepi__hazina jha kumbinguni jhajhimalika lepi, sehemu ambajho bhaheji bhibeta lepi kukaribila wala nondo jhibeta lepi kuharibu. ");
INSERT INTO kiz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwakujha pajhe ni hazina jha jhobhi, ndipo ni roho jha jhobhi pajhibekujha. ");
INSERT INTO kiz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nghobho sya jhomu sitali sijhelayi sikongibhu kwa n'kanda, ni taa sya jhomu sihakikisibhwayi kujha sijhendelela kujhaka, ");
INSERT INTO kiz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","na mujhelayi kama bhanu bhabhakandendela Bwana ghwa bhene kuhomela mu sherehe jha harusi, ili kwamba ahidayi ni kupiga hodi, bhibeta kubhwesya kun'dendulila ndiangu kwa haraka. ");
INSERT INTO kiz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bhabarikibhu bhala bhatumishi, ambabho Bwana ibeta kubhekolela mihu. Hakika ibeta kukonga nghobhu jha muene jhitali kwa n'kanda, kisha ibeta kubhatamika pasi kwa kyakulya, Kisha kubhahudumila. ");
INSERT INTO kiz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kama Bwana ibeta kuhida kwa zamu jha pili jha ulinzi jha pakiru, au zamu jha tatu jha ulinzi, nu kubhakolela bhajhe tayari, ibeta kujha heri kwa abhu bhatumishi. ");
INSERT INTO kiz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Zaidi jha aghu, mmanyayi ele, kama Bwana n'kolo nyumba ngaajhimanyi saa ambajho mmeji ihida, ngaanihusuililepi nyumba jha muene jhibomolibhwayi. ");
INSERT INTO kiz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mujhiajhi tayari kwani mumanyilepi ndo wakati gani Mwana ghwa Adamu ibeta kerebhuka. ");
INSERT INTO kiz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro akajobha, “Bwana, ukatujobhela tete twebhene mifano ejhe, au ukan'jobhela khila munu? ");
INSERT INTO kiz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bwana akabhajobhela, “Niani mtumwa mwaminifu au mwenye hekima ambaye Bwana ghwa muene ibeta kumbeka panani pa bhatumishi bhangi, ili abhag'abhilayi kyakulya kwa wakati muafaka? ");
INSERT INTO kiz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Abarikibhu mtumishi jhola, ambajhe Bwana ghwake akahidajhi ibeta kun'kolela ibhomba ghala gha alaghisibhu. ");
INSERT INTO kiz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hakika nikabhajobhela muenga jha kujha ibeta kumbeka panani pa mali jha muene jhioha. ");
INSERT INTO kiz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini mtumishi jhola akajobha mu muoyo ghwa muene, “bwana ikabhela kukerebhuka; hivyo akajhanda kubhatobha bhala bhatumishi bha kigosi ni kidala, kisha akajhanda kulya, kunywa ni kugala, ");
INSERT INTO kiz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bwana ghwa muene mtumwa jhola ibeta kuhida ligono lya ategemeleghe lepi ni saa jhaajhimanyilepi, ni muene ibeta kun'dumula fipandi ni kumbeka sehemu jhimonga ni bhabhabelikujha bhaaminifu' ");
INSERT INTO kiz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mtumishi, jhaamanyili mapenzi gha Bwana ghwa muene, ni muene akakiandele lepi wala aketili lepi kinofu ni mapenzi gha muene ibetakutobhibhwa fiboko fimehele. ");
INSERT INTO kiz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini mtumishi jhaamanyilepi mapenzi gha bwana ghwa muene, na adhabu, ibeta kutobhibhwa fiboko fidebe. Kwa kujha muene jha apelibhu fimehele, idaibhwa kuhoma kwa muene, ni muene jhaaminibhu kwa fimehele, kwa muene fibetakudaibhwa fimehele zaidi. ");
INSERT INTO kiz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nihidili kubhwasya muoto duniani, na ninoghele ujhelayi umalikujhaka, ");
INSERT INTO kiz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lakini nijheni ubatizo ambabho nibetakubatisibhwa na nijhe ni huzuni mpaka pa wibeta kukamilika! ");
INSERT INTO kiz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Je mwifikiri nihidili kuleta amani duniani? Lepi, nikabhajobhela, badala jhiake niletili mgawanyiku. ");
INSERT INTO kiz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","kuh'omela henu ni kujhendelela kubetakujha ni bhanu bhahanu mu nyumba jhimonga bhagawanyiki, na bhadatu bhibetakujha kinyume ni bhabhele bhibetakujha kinyume ni bhadatu. ");
INSERT INTO kiz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bhibeta kugabhwanyika, Dadi ibetakujha kinyume ni mwanabhe ni ibetakujha kinyume ni Dadijhe, mabhu ibetakujha kinyume ni mwali munu ni mwali munu ibetakujha kinyume ni nyinamunu, Mama mkwe ibetakujha kinyume ni n'kwibhi ni nkwibhi ibeta kujha kinyume ni Mama mkwe ghu muene. ");
INSERT INTO kiz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu akajhe akabhajobhela makutano kabhele, “Mara pa mwibhona mabhengu ghihomela magharibi, mwijobha nyakati sya fula sifikili; na ndo kya jhijha, ");
INSERT INTO kiz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni mpongo ghwa kusini ukabhumayi, mwijobha, pibeta kujha ni joto kali, na ndo kya jhijha. ");
INSERT INTO kiz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enyi bhanafiki, mwibhwesya kutafsiri mwonekano bhwa nchi ni anga, lakini jhijha bhuli mwisindwa kutafsiri wakati bhwa ujhele? ");
INSERT INTO kiz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kwandajha kiki khila mmonga bhinu. asipambanuli lyalijhele sahihi kwa muene wakati ambapo angali ajhe ni nafasi jha kubhomba aghu? ");
INSERT INTO kiz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndabha mkalotayi ni mshitaki ghwa jhobhi pa hakimu, kitahidiajhi kupatana ni mshitaki ghwa jhobhi mugati mwako na munjela asije akakupeleka kwa hakimu, ni hakimu kulongosya kwa ofisa, ni ofisa kusopa mu ligereza. ");
INSERT INTO kiz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nikujobhela, wibetalepi kupita okhu hadi ulepayi mpaka senti jha mwishu. ");
INSERT INTO kiz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kwa wakati bhobhuobhu, kwajhele ni baadhi jha bhbanu bhabhan'taarifu juu jha bhagalilaya ambabho Pilato abhakomili ni kubhachanganya damu jha bhene ni sadaka sya bhene. ");
INSERT INTO kiz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu akajibu ni kubhajobhela, “Je mwidhanila kujha bhagalilaya abhu bhajhele ni dhambi kuliko bhagalilaya bhamana ndo maana bhakabhili mabhibhi aghu? ");
INSERT INTO kiz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","L'epi, mkabhajobhela, lakini mukabela kutubu, namu mwibeta kuangamila mebhu. ");
INSERT INTO kiz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au bhale bhanu kumi ni nne mu Siloamu ambabho mnara bhwabinili ni kubhakoma, mwifikiri bhene bhajhele ni dhambi nesu kuliko bhamana mu Yerusalemu? ");
INSERT INTO kiz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lepi, nene nijobha, lakini kama mutubuili lepi muenga mwebhoha mwibeta kuangamila. ");
INSERT INTO kiz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu an'jobhili mfano obho, “Munu mmonga ajhele ni mtini upandibhu pa n'gonda ghwa muene na alotili kulonda matunda munani mu mwene lakini akabhilepi. ");
INSERT INTO kiz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Akan'jobhele mtunza bustani, 'Langayi, kwa miaka midatu nihidili ni kujaribu kulonda matunda mu mtini obho lakini nikabhilepi. Udumulayi. kwani wileta uharibifu bhwa Ardhi? ");
INSERT INTO kiz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mtunza bustani akajibu ni kujobha uulekayi mwaka obho ili niugehelelayi ni kubheka mbolea panani pake. ");
INSERT INTO kiz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kama akahogolayi matunda mwaka ujao, ni kinofu; lakini kama wibeta lepi kuhogola, mudumulayi!”' ");
INSERT INTO kiz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Henu Yesu akajhe ifundisya mu mojawapo gha Masinagogi wakati wa sabato. ");
INSERT INTO kiz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Langayi ajhele mabhu mmonga ambajhe kwa miaka kumi na nne ajhele ni roho chafu bhwa udhaifu, ni muene ajhe apindili na ajhelepi ni uwezo kabisa bhwa kujhema. ");
INSERT INTO kiz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu bho ambwene akan'kuta, akan'jobhele, “Mabhu, ubhekibhu huru kuh'oma mu udhaifu bhwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akabheka mabhoko gha muene panani pa muene, ni mara mb'ele bhwa muene bhukakinyosya na an'tukuzili K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini mbaha ghwa sinagogi adadili kwa ndabha Yesu ajhele amponyisi ligono lya sabato. Hivyo mtawala akajibu akabhajobhela makutano, “Kuna magono sita ambagho ni lazima kubhomba mbombo. Muhidayi kuponyisibhwa basi, ni katika ligono lya sabato.' ");
INSERT INTO kiz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bwana an'jibili ni kujobha, “Bhanafiki! Ajhelepi hata mmonga bhinu kufungula punda bhwa jhobhi au ng'ombi kuhoma mu zizi ni kabhalongosya kumpeleka kunywa ligono lya sabato? ");
INSERT INTO kiz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hivyo kabhele binti ghwa Abrahamu, ambajhe shetani amfungili kwa miaka kumi ni nane, je jhilondekaghe lepi kifungulibhwajhi ligono lya sabato?” ");
INSERT INTO kiz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bhoijobha malobhi aghu bhala bhoha bhabhampingili bha bhuene soni, bali makutano bhoha ni bhangi bhashangilili kwa mambo gha ajabu ghabhombili. ");
INSERT INTO kiz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu akajobha, “Ufalme bhwa K'yara wiwaningana ni kiki, na wibhesya kulenganisya ni kiki? ");
INSERT INTO kiz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ni kama mbeyu jha haradari jhaailetili munu mmonga ni kujhibhiala mu n'gonda bhwa muene, ni kumela kujha libehe libhaha, ni fidege fya kumbinguni fyajengili fisiwisi fya bhene mu matafi ghake. ");
INSERT INTO kiz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kabhele akajobha, “Niufananisiajhi ni kiki ufalme bhwa K'yara? ");
INSERT INTO kiz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ni kama chachu ambajho n'dala atolili ni kuchanganya mu fipemu fidatu fya sembe hata ukaumuka.” ");
INSERT INTO kiz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu agendili kila mji ni fijiji munjela kulotela Yerusalemu ni kubhafundisya. ");
INSERT INTO kiz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munu mmonga akakote, “Bwana, ni bhanu bhadebe tu bbhabhibeta kuikolibhwa?” Hivyo akabhajobhela, ");
INSERT INTO kiz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ukitahidiajhi kujhingila kwa kup'etela ndiangu mwembamba, kwandabha bhamehele bhibeta kujaribu na bhibetalepi kubhwesya kujhingila. ");
INSERT INTO kiz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mara baada jha mmiliki ghwa nyumba kujhema ni kudenda ndiangu, basi mwibeta kujhema kwibhala ni kupiga hodi pa ndiangu ni kujobha, Bwana, Bwana, tufungulilayi muene ibeta kujibu kwa kubhajobhela, nibhamanyilepi muenga wala kwa mihoma.' ");
INSERT INTO kiz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ndipo mwibeta kujobha, Twalili ni kunywa mbele jha jhobhi ni bhebhe wafundisi mu mitaa ghya tete.” ");
INSERT INTO kiz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini muene ibeta kubhajibu, nibhajobhili nibhamanyilepi kwa mwihoma, mubhokayi kwa nene, muenga bhabhomba maovu! ");
INSERT INTO kiz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kubetakujha ni kilelu ni kusiagha minu wakati pa mwibeta kumbona na Abrahamu, Isaka, Yakobo ni manabii bhoha mu ufalme bhwa K'yara, lakini mwebhene mu taghibhu kwibhala. ");
INSERT INTO kiz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bhibetakuhida kuhoma mashariki, magharibi, kaskazini ni kusini ni kup'omolela mu meza jha kyakulya kya kimihi mu ufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na nimanyili e'le, wamwishu ndo ghwa kwanza ni ghwa kwanza ndo ghwa mwisho.” ");
INSERT INTO kiz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Muda mfupi baadajhe, jha Mafarisayo bhakahida ni kun'jobhela, “Lotayi ne ubhokayi apa kwandabha Herode ilonda kukoma.” ");
INSERT INTO kiz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akajobha, “Mulotayi mukan'jobhelayi jhola Mbweha, `Langayi, nikabhabhenga pepo ni kukheta uponyajhi lelu ni kilabhu ni ligono lya tatu nitimisya lilengo lyangu. ");
INSERT INTO kiz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mu hali jhejhioha, ni muhimu kwandabha jha nene kujhendelela lelu, kilabhu ni n'tondo, kwa vile jhilondeka lepi kun'koma nabii patali ni Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalemu, Yerusalemu, niani akabhakoma manabii ni kubhatobha maganga bhala bhabhalaghisibhu kwa muenga. Mara ngapi nilondikubhabhonganiya bhana bhinu kama vile n'gokho kyajhibhonganya fyana fya muene pasi pa mababatilu gha muene, lakini mulilondelepi e'le. ");
INSERT INTO kiz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Langayi, nyumba jha jhobhi jhitelesibhu. Nani nikabhajobhela, mwibhwesya lepi kunibhona hata pa mwibeta kujobha 'Abarikibhu ojho jha ihida kwa lihina lya Bwana.”' ");
INSERT INTO kiz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jhatokili ligono lya sabato, bho ilota kunyumba kwa mmonga ghwa bhalongosi bha Mafarisayo kulya n'kate, nabhene bhakajha bhakan'chunghuza kwa karibu. ");
INSERT INTO kiz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Langayi, palongo pa muene ajhele munu ambajhe isumbulibhwa ni uvimbe. ");
INSERT INTO kiz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu akakota bhataalamu mu sheria sya bhayahudi ni Mafarisayo, “Je, ni halali kumponya ligono lya sabato, au lepi?” ");
INSERT INTO kiz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini bhene bhajhele kinunu, kwa hiyo Yesu akan'kamula, ni kumponya ni kundeka alotayi. ");
INSERT INTO kiz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nimuene akabhajobhela, “Niani kati jha muenga ajhe ni muana au ng'ombi idumbukila mu ligono lya sabato akamfuta lepi kwibhala mara moja?” ");
INSERT INTO kiz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bhene bhajhelepi ni uwezo bhwa kuhomesya lijibu kwa mambo agha. ");
INSERT INTO kiz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wakati Yesu agunduili jinsi bhala bhabhaalikibhu kwamba bhachaguili fiti fya heshima, akabhajobhela mfano, akajobha, ");
INSERT INTO kiz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wakati pa mwialikibhwa ni munu pa harusi, usitami mu nafasi sya heshima, kwandabha jhibhwesekana aalikibhu munu ambajhe ndo wakuheshimibhwa nesu kuliko bhebhe. ");
INSERT INTO kiz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wakati munu jheabhaaliki muenga bhabhele akafikayi, ibeta kujobhela bhebhe, “mpishayi munu ojho nafasi jhe bhebhe,” ni kisha kwa soni wibetakutola nafasi jha mwishu. ");
INSERT INTO kiz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakini bhebhe ukaalikibhwayi, lotayi ukatamayi mahali pa mwishu, ili wakati jhola jhaakualiki akahidayi abhwesiajhi kukujobhela bhebhe, `Rafiki, lotayi palongolo nesu.” Ndipo wibeta kujha uheshimiki mbele jha bhoha bhabhatamili pamonga ni bhebhe pa meza. ");
INSERT INTO kiz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwandabha khila jhaikikweza iselesibhwa na haikiselesya ikwesibhwa.' ");
INSERT INTO kiz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu kabhele akan'jobhela munu jhaamwaliki,'pawihomesya kyakulya kya pamusi au kimihi, usibihaaliki rafiki zako au bhalongobhu au jamaa bhajhobhi au majirani bha jhabhi matajiri, ili kwamba bhene bhasihidi kukualika ni bhebhe ukakabhe malipo. ");
INSERT INTO kiz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Badala jhieke, pawibhomba sherehe, bhaalikayi maskini, filema, fiwete ni fipofu, ");
INSERT INTO kiz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ni bhebhe wibetakujha kubarikibhwa, kwandabha bhibhwesya lepi kulepa. kwandabha wibeta kulepibhwa mu ufufuo bhwa bhenye.” ");
INSERT INTO kiz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wakati mmonga ghwa bhale bhabhatamili pameza pamonga ni Yesu bho apeliki aghu, ni muene akanijobhela, “Abarikibhu jhola jhaibetekulya n'kate mu Ufalme bhwa k'yara!” ");
INSERT INTO kiz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lakini Yesu akan'jobhela, “munu mmonga aandele sherehe mbaha, aaliki bhanu bhamehele. ");
INSERT INTO kiz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakati sherehe bho ijhe tayari, akandaghisya mtumishi ghwa muene kubhajobhela bhela bhaalikwa, “Muhidayi, kwandabha fenu fyoha fimalili kubhekibhwa tayari.' ");
INSERT INTO kiz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bhoha, bhakajhanda kus'oma radhi. Wa kwanza akan'jobhela mtumishi, 'Nihemili n'gonda, lazima nilotayi kulilola. Tafadhali unisamee.' ");
INSERT INTO kiz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na jhongi akajobha, Nihemili Jozi sihanu sya ng'ombi, ni nene nilotakubhajaribu. Tafadhali uniwie radhi.' ");
INSERT INTO kiz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni munu jhongi akajobha, 'Nigegili n'dala, henu nibhwesya lepi kuhida.' ");
INSERT INTO kiz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mtumishi akakerebhuka ni kun'jobhela mtumishi ghwa muene,'Lotayi manyata mitaani ni mufichochoro fya miji ukabhaletayi apa maskini, filema, fipofu ni bhalemavu.” ");
INSERT INTO kiz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mtumishi akajobha, Bwana, aghu gha ulaghisij ghaamali kukhomboka, hata henu nafasi khona.' ");
INSERT INTO kiz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bwana akan'jobhela mtumishi, 'Lotayi mu n'jhela mbaha ni fichochoro na ubhashunitushjajhi bhanu bhajhingilibhu, ili nyumba jha nene jhimemayi. ");
INSERT INTO kiz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwandabha nikabhajobhela, kwabhala bhashaafikibhu kubhwandelu ajhelepi jhaibetakubhonja sherehe jhanene.' ");
INSERT INTO kiz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Henu umati mbaha bhajhele bhilota pamonga Ni muene, ni muene akageuka ni kubhajobhela, ");
INSERT INTO kiz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","'Kama munu ihida kwa nene ni muene akan'dadila lepi dadi munu, n'dala munu, mwana munu, bhalongo munu bha n'gosi ni n'dala - ndio, ni hata maisha gha muene kabhele -ibhwesya lepi kujhe mwanafunzi ghwa nene. ");
INSERT INTO kiz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Munu akabelayi kuulota msalaba ghwa muene ni kuhida kunyumba jha nene ibhwesyalepi kujha mwanafunzi ghwa nene. ");
INSERT INTO kiz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Maana niani kati jhe muenga, ambajhe inoghela kujenga mnara ibeta lepi kutama hoti akadirirajhi gharama kwa mahesabu kama ajhe ni khela kyailonda ili kukamilisya e'lu? ");
INSERT INTO kiz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vinginevyo, baada jha kubheka msingi ni kusindwa kumallisila, bhoha bhabhalolili bhibeta kujhanda kundhihaki. ");
INSERT INTO kiz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bhijobha, Munu ojho ajhandi kujenga, ajhelepi ni nghofu sya kumalisya.' ");
INSERT INTO kiz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Au mfalme jholekhu, akalondajhi kulota kukomana ni mfalme jhongi mu vita, ambajhe ibetalepi kutama pasi hoti ni kutola ushauri kuhusu kama ibhwesya, pamonga ni bhanu elfu kumi kutobhana ni mfalme jhongi jha ihida panani pa muene ni bhanu ishirini elfu? ");
INSERT INTO kiz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na kama naha lepi, wakati jeshi lya bhangi bado lijhe patali, itume balozi kulonda masharti gha amani. ");
INSERT INTO kiz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kwa hiyo basi, jhejhioha kati jha muenga ambajhe ibetalepi kuleka fyoha fya ajhe nafu, ibhwesyalepi kujha mwanafunzi ghwa nene. ");
INSERT INTO kiz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Muinyu unofu, lakini ikajhelajhi jhijhasili ladha jhiake, jinsi jheleku jhibhwesya kujha muinyu kabhele? ");
INSERT INTO kiz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ijhelepi ni matumizi kwa udongo au hata kwa mbolea. jhitaghibhwa patali. Muene jha ajhele ni mb'olokoto na ap'elekayi gha kup'eleka.” ");
INSERT INTO kiz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Basi bhatoza ushuru bhoha ni bhangi bhenye dhambi bhahidili kwa Yesu ni kump'elekesya. ");
INSERT INTO kiz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafarisayo ni bhaandishi bhanung'uniki bhakajobha, “Munu ojho akabhakaribisya bhenye dhambi na ilya nabhu.” ");
INSERT INTO kiz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu akajobha mfano obho kwa bhene, akajobha ");
INSERT INTO kiz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Niani kwa muenga, kama ajhe ni kondoo mia moja ni akajhaghayi mmonga bhabhi akabhaleka bhala tisini na tisa mu nyika, ni kulota kulonda jhola jha ajhaghili hadi ambonayi? ");
INSERT INTO kiz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni mwene akamalayi kun'kabha akambeka mumabega pa muene ni kufurahela. ");
INSERT INTO kiz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bhoafikili mu nyumba, akabhakuta marafiki zake ni majirani bha muene akabhajobhela muhobhokayi pamonga ni nene, kwa kujha nikabhili kondoo jha akajhag'heli.' ");
INSERT INTO kiz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nikabhajobhela mebhu kubetakujha ni furaha kumbinguni kwandabha jhe mwenye dhambi mmonga jhaitubu, zaidi jha bhenye haki tisini na tisa ambabho bhajhelepi ni hajha jha kutubu. ");
INSERT INTO kiz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aajhe n'dala gani mwenye sarafu kumi sya hela, akajha ghibhwayi ni sarafu jhimonga, ibetakubhwasya lepi taa ni kufyaghila nyumba ni kulonda kwa bidii hadi paibetakujhikabha? ");
INSERT INTO kiz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na akamalayi kujhibhona akabhakuta marafiki zake ni majirani zake kubhajobhela muhobhokayi pamonga ni nene, kwa kujha nijhikabhili kabhele sarafu jha nijhasili. ");
INSERT INTO kiz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hata hivyo nikabhajobhela kujhe ni furaha palongolo pa malaika bha K'yara kwa ndabha jha mwenye dhambi mmonga jha ibeta kutubu. ");
INSERT INTO kiz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ni Yesu akajobha, “Munu mmonga ajhe ni bhana bhabhele ");
INSERT INTO kiz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","y'ola n'debe akan'jobhela dadimunu, Dadi nipelayi sehemu jha mali jhanistahili kujhirithi. Hivyo agawenye mali sya muene kati jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Magono mingilepi n'debe jhola akabhonganiya fyohe fyeimiliki akalota nchi jha patali, ni okhu akatapanya mali ni hela sya muene, kwa kuhemela fenu fyefilondekeghe lepi, ni kutabhwanya hela sya muene kwa anasa. ");
INSERT INTO kiz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ni muene bho atumili fyoha njala mbaha jhajhingili mu nchi jhela ni muene akajhanda kujha mu uhitaji. ");
INSERT INTO kiz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akalota ni kujiajiri muene kwa mmonga ghwa raia bhwa nchi jhela, ni muene akampeleke kun'gonda kulisya maghorobhi. ");
INSERT INTO kiz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na akajha inoghela kwishibisya kwa, maganda ghaghalijheghe maghorobhi kwandabha ajhelepi munu jha ampelili khenu kyokyoha khela abhwesya kulya. ");
INSERT INTO kiz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ila jhola muana n'debe bho azingatili mu muoyo bhwa muene, ajobhili 'Ni bhatumishi bhalenga bha dadijhangu bhajhe ni kyakulya kingi kya kutosha ni nene nijhe apa nifwa ni njala! ");
INSERT INTO kiz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nibhoka ni kulota kwa dadijhangu, ni kun'jobhela, “Dadi nikukosili juu jha mbingu ni palongolo pa mihu jhobhi. ");
INSERT INTO kiz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nikastahili lepi kukutibhwa mwanabhu kabhele; nifwanyajhi kama mmonga ghwa bhatumishi bha jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndipo akabhoka akalota kwa dadi munu. Bho ajhe patali dadi munu ambwene akambonela huruma akalota mbio ni kun'kumbatila ni kumbusu. ");
INSERT INTO kiz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana jhola akan'jobhela, “dadi nikosili juu jha mbingu ni palongolo pa mihu gha bhebhe nikastahili lepi kukutibhwa mwanabhu.' ");
INSERT INTO kiz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dadi munu jhola abhajobhili bhatumishi bha muene, muliletayi livazi lyalijhele linofu, mukamfwekayi mufwatikayi ni pete mu kikonji ni filatu mu magolo. ");
INSERT INTO kiz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kisha mundetayi jhola jhaanenipi mukan'chinjayi tulieyi ni kuhobhoka. ");
INSERT INTO kiz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa kujha mwanabhangu afuili ni muene ajhe hai. Ajhele ajhaghili ni muene abhonekene bhakajhanda kushangilila. ");
INSERT INTO kiz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Basi jhola mwanamunu mbaha ajhele kun'gonda. Bho ihida ni kukaribila pa nyumba ap'eliki ny'embu ni michezo. ");
INSERT INTO kiz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akan'kuta mtumishi mmonga ni kun'kota mambo agha maana yake kiki? ");
INSERT INTO kiz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mtumishi akan'jobhela mbenabhu ahidili ni dadi waku an'chinjili litoli jha anonili kwandabha akerebhuiki kinofu.' ");
INSERT INTO kiz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwana mbaha akadada akabela kujhingila mgati ni dadimunu akahoma kwibhala kumsihi. Ila akan'jibu dadimunu akajobha, 'Langayi ");
INSERT INTO kiz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","nene nikutumikili kwa miaka ghimehele, wala nikosilepi amri jha jhobhi, unipelili lepi mwana mene, ili nisherehekelayi ni marafiki zangu. ");
INSERT INTO kiz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini bho ahidili ojho mwanabhu jhaa tapenye mali gha jhobhi ghoha pamonga ni makahaba un'chinjili litoli lya linenepi. ");
INSERT INTO kiz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dadimunu akan'jobhela, 'Mwanabhangu, bhebhe ujhele pamonga ni nene magono ghoha ni fyoha fyanijhe nafu ndo fyajhobhi. ");
INSERT INTO kiz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ila jhajhele kinofu kwa tete kubhomba sherehe ni kubhoka, ndongobhu ojho afuili, ni henu muomi; ajhele ajhele ajhaghili ni muene abhonekene.” ");
INSERT INTO kiz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu akabhajobhela bhanafunzi bha muene, “Pajhele ni munu mmonga tajiri ajhe ni meneja, na ataarifibhu jha kujha meneja ojho itapanya mali sya muene. ");
INSERT INTO kiz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hivyo tajiri akan'kuta, akan'jobhela, “kiki ekhe kya nikakip'eleka juu jha bhebhe? Bhosiajhi hesabu jha umeneja bhwa jhobhi, kwandabha wibhwesya lepi kuja meneja kabhele.' ");
INSERT INTO kiz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Meneja jhola akajobha mu muoyo bhwa muene, nikhetayi kiki, maana bwana ghwa nene akanibhosya mu kazi jhangu jha umeneja? nijhelepi ni nghofu sya kulema, ni kus'oka nibhona soni. ");
INSERT INTO kiz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nimanyili lyaibeta kubhomba ili panibeta kubhosibhwa mu mbombo jhangu jha uwakili bhanu bhanikaribisiajhi mu nyumba sya bhene ");
INSERT INTO kiz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hivyo wakili akabhakuta bhadeni bhwa bwana ghwa muene kwa khila mmonga akan'jobhela ghwa kuanza, 'ghwidaibhwa kiasi gani ni bwana bhangu?' ");
INSERT INTO kiz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akajobha fipemu mia moja fya mafuta akan'jobhela 'tolayi hati jha jhobhi tamayi manyata yandikayi hamsini.' ");
INSERT INTO kiz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kisha akan'jobhela jhongi ni bhebhe widaibhwa kiasi gani?' akajobha 'fipemu mia moja fya sembe ghwa ngano.' Akan'jobhela 'letayi hati jha bhebhe jhandikayi themanini.' ");
INSERT INTO kiz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","bwana jhola akan'sifu meneja dhalimu kwa vile kyaabhombili kwa wereu. Kwa kujha bhanu bha ulimwengu obho bherevu bhingi na bhishughulika kwa ujanja ni bhanu bha lubhafu lwa bhene kuliko kya bhajhele bhana bha nuru. ");
INSERT INTO kiz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nani nikabhajobhela mwikibhekayi marafiki kwa mali gha udhalimu ili pajhibeta kukosekana bhabhakaribisiajhi mu makao gha milele. ");
INSERT INTO kiz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jhaajhe mwaminifu kwa e'le lidebe nesu ijha mwaminifu mu libhaha kabhele. na jhaajhe dhalimu kwa ele lidebe ijha dhahalimu kwa lijhele libhaha kabhele. ");
INSERT INTO kiz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kama muenga mwajhelepi mwebhaaminifu mu mali gha udhalimu niani jha ibeta kubhaamini mu mali gha bhukweli? ");
INSERT INTO kiz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kama mwajhelepi bhaaminifu katika mali gha munu jhongi niani ibeta kubhaamini kwa gha muenga? ");
INSERT INTO kiz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ajhelepi mtumishi jha ibhwesya kutumikila mabwana bhabhele, kwandabha ibeta kun'dadila mmonga ni kun'gana jhongi, ama ibeta kushikamana ni ojho nikumdharau ojho. Mwibhwesya lepi kun'tumikila K'yara ni mali.” ");
INSERT INTO kiz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Basi Mafarisayo, bhabhasiganili hela bhaghap'eliki agha ghoha na bhan'dhihakili. ");
INSERT INTO kiz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na akabhajobhela, “Muenga ndo mwamikidayi haki mbele jha bhanadamu, lakini Mungu ajhimanyili mioyo ghya muenga. Kwa kujha lyalitukuiki kwa mwanadamu lijha chukizo kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sheria ni manabii fyajhele mpaka Yohana bho ahidili. Kuh'omela bhwakati obhu, habari jhinofu jha ufalme bhwa K'yara bhwitangesibhwa ni kila munu ijaribu kwijhingisya kwa nghofu. ");
INSERT INTO kiz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini rahisi kwa mbingu ni nchi fibhokayi kuliko hata herufi jhimonga jha sheria kukosekana. ");
INSERT INTO kiz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kila jhaakandeka nd'ala munu ni kun'gega n'dala jhongi idhinilepi, ni muene jhaakan'gega jha alekibhu ni n'gosi munu izinilepi. ");
INSERT INTO kiz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pajhele ni munu mmonga tajiri jhaafwalili nghobho sya rangi sya zambarau ni kitani kinofu na akajha furahila kila ligono utajiri bhwa muene mbaha. ");
INSERT INTO kiz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ni maskini mmonga lihina lya muene Lazaro abhekibhu pageti lya muene, na ajhe ni filonda. ");
INSERT INTO kiz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ni muene akajha inoghela kushibishwa kwa makombo ghaghabinili kuh'oma pameza pa jhola tajiri hata mabwa ghakahida kun'yabha filonda fya muene. ");
INSERT INTO kiz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ikajha maskini jhola afwili na atolibhu ni malaika mpaka pakifua kya Ibrahimu. Tajiri jhola ni muene afwili na asyelibhu. ");
INSERT INTO kiz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ni khola kuzimu paajhele mu malombosi akaghajhinula mihu gha muene akambona Ibrahimu kwa patali ni Lazaro pakifua kya muene. ");
INSERT INTO kiz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akalela akajobha, 'Dadi Ibrahimu, unihurumilayi un'tumayi Lazaro ajhinayi ncha jha kikonji kya muene mumasi, auburudisiajhi lumilu lwa nene; kwandabha nitesibhwa mu muoto obho. ");
INSERT INTO kiz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lakini Ibrahimu akajobha, 'Mwanabhangu khombokayi katika maisha gha jhobhi ghwa ejhapokili mambo gha jhobhi manofu ni Lazaro mebhu akabhili manofu lepi. Ila henu ajhe apa ifarijibhwa ni bhebhe wilamasibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ni zaidi jha aghu libhekibhu lilende libhaha na litali kati jha tete, ili bhala bhabhilonda kubhoka khoni kulota kwa jhomu bhasibhwesi wala bhanu bha muenga bhasilobhoki kuhida khoni.' ");
INSERT INTO kiz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tajiri jhola akajobha, 'Nikus'oka Dadi Ibrahimu, kwamba undaghisiajhi kunyumba kwa dadijhangu ");
INSERT INTO kiz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwakujha nijhe nibhalongo bhangu bhahanu ili abhaonyanyi, kwa hofu kujha na bhene kabhele bhibeta kuhida mahali pa mal'ombosi. ");
INSERT INTO kiz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lakini Ibrahimu akajobha, 'Bhajheni Musa ni manabii. Bhalekayi bhabhapelekesiajhi bhene. ");
INSERT INTO kiz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tajiri jhola akajobha, 'lepi, Dadi Ibrahimu, lakini kama abhalotili munu jha ih'omela kwa bhafu bhibeta kutubu.' ");
INSERT INTO kiz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lakini Ibrahimu akabhajobhela, 'bhakabelayi lubhap'eleka Musa ni manabii bhibeta lepi kushawishibhwa hata munu akafufukayi kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu akabhajobhela bhanafunzi bha muene, “mambo ghabhisababisha bhanu bhabhombayi dhambi ghilondeka lepi kuhomela, lakini ole wake jha isababisya! ");
INSERT INTO kiz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngajhijhele heri munu ojhu ngaafungibhu ligenga lya lilopa lya kusyaghila pa n'singu ni kutaghibhwa mu bahari kuliko kumbomba mmonga ghwa abha bhadebe akhetayi dhambi. ");
INSERT INTO kiz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mukilendayi. Kama ndongo bhu akukosili umwonyayi, na akutubuajhi msameajhi. ");
INSERT INTO kiz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kama akukosili mara saba kwa ligono limonga akahida kwa bhebhe ijobha, 'nitubu,' m'sameajhi!” ");
INSERT INTO kiz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mitume bha muene bhakan'jobhela Bwana, “Tujhongeselayi imani jha jhotu.” ");
INSERT INTO kiz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bwana akajobha, “Kama ngamujha ni imani kama punje jha haradarii, ngamubhwesi kuujobhela libehe e'le lya mkuyu, 'dupukayi na ukamelayi mu bahari,' nibhwene ngaubhatiili. ");
INSERT INTO kiz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lakini niani miongoni mwa muenga, ambajhe ajhe ni mtumishi jhailema n'gonda au jhaidima kondoo, ibeta kun'jobhela akerukayi kun'gonda hidayi manyata na utamayi uliajhi kyakulya? ");
INSERT INTO kiz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Je ibeta lepi kun'jobhela niandalilaiji kyakulya niliajhi, na ukikongayi mkanda na unitumikilayi mpaka panibeta kumala kulya ni kunywa. Baada jha apo wibeta kulya ni kunywa? ");
INSERT INTO kiz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ibeta lepi kumbombesya mtumishi ojhu kwandabha atimisi ghala gha an'jobhili? ");
INSERT INTO kiz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mebhu ni muenga mkabhombayi gha mlaghisibhu mjobhayi 'Tete twe bhatumishi twetukastahili lepi. Tubhombi tu ghala ghaghalondekeghe kubhombeka.' ");
INSERT INTO kiz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jhatokili kwamba bho isafiri kulota Yerusalemu, a'petili mpakani mwa Samaria ni Galilaya. ");
INSERT INTO kiz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bhoijhingili mu kijiji kimonga, okhu abhonene ni bhanu kumi bhabhajhele ni ukoma. Bhakajhema patali ");
INSERT INTO kiz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bhakapwesya sauti bhakajobha “Yesu, Bwana tuhurumilayi.” ");
INSERT INTO kiz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bho abhabhwene akabhajobhela, “Mulolayi mkakilesiajhi kwa makuhani.” na bhene bho bhilota bhatakasiki. ");
INSERT INTO kiz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmonga ghwa bhene bho ambwene aponili, akakerebhuka kwa sauti mbaha akan'sifu K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akapiga magoti mu magolo gha Yesu akan'shukuru. Muene ajhele Msamaria. ");
INSERT INTO kiz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ajibili, akajobha, “Je bhatakasikilepi bhoha kumi? bhajhendaku bhala bhamana tisa? ");
INSERT INTO kiz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ajhelepi hata mmonga jhaabhonekene kukerebhuka ili kun'tukusya k'yara, isipokujha ojho n'hesya?” ");
INSERT INTO kiz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Akan'jobhela, “Jhinukayi na alotayi imani jha jhobhi jhikuponyisi.” ");
INSERT INTO kiz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bho akotibhu ni Mafarisayo kujha ufalme bhwa K'yara bhwihida ndali, Yesu akabhajibu akajobha, “Ufalme bhwa K'yara sio khenu ambakyo kibhwesya kubhonekana. ");
INSERT INTO kiz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala bhanu bhibeta lepi kujobha, 'Langayi apa!' au, 'Langayi khola!' kwandabha ufalme bhwa K'yara ajhele mugati mwa jhomo.” ");
INSERT INTO kiz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu akabhajobhela bhanafunzi bha muene, “Wakati wibeta kufika ambapo mwibeta kunoghela kujhibhona moja jha magono gha mwana ghwa Adamu, lakini mwibeta lepi kujhibhona. ");
INSERT INTO kiz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bhibeta kubhajobhela, 'Langayi, khola! Langayi apa!' Lakini msil'oti kulanga, wala kubhakhesya, ");
INSERT INTO kiz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kama umeme bhwa radi kya bhwimulika mu anga kubhwanjila lubhafu l'ongi hadi l'ongi. Mebhu hata mwana ghwa Adamu ibeta kujha mebhu mu ligono lya muene. ");
INSERT INTO kiz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini hoti jhibeta kulondeka kutesibhwa mu mambo ghamehele ni kubelibhwa ni kizazi ekhe. ");
INSERT INTO kiz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kama kyajhikajhele magono gha Nuhu, ndo kyajhibetakujha mu magono gha mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bhalili, bhanywili, bhakagega ni kugegikibhwa mpaka ligono lela ambalyo Nuhu bho ajhingili mu safina ni gharika ikahida ni kubhaangamisya bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndo kyajhikajhele mu magono gha Lutu, bhalili, kunywa, bhagolili ni kuhemelesya, kulema na bhajengili. ");
INSERT INTO kiz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini ligono lela Lutu bho abhokili Sodoma, jhatonyili fula jha muoto ni kiberiti kuhoma kumbinguni jhabhaangamisi bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mebhu ndo kyajhibetakujha mu ligono lela lya mwana ghwa Adamu paibetakufunulibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ligono e'lu, usinduhusu jha ajhele padari jha nyumba aseleleyi kutola bidhaa sya muene mugati munyumba. Na usinduhusu jha ajhele kun'gonda kukerebhuka kunyumba. ");
INSERT INTO kiz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkhombokajhi ghwa Lutu. ");
INSERT INTO kiz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jhejhioha jha ijaribu kughaokola maisha gha muene ibeta kughajhasya, lakini jhejhioha jha ibeta kujhesya maisha gha muene ibeta kughaokola. ");
INSERT INTO kiz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nikabhajobhela, kiru ekhu kibeta kujha ni bhanu bhabhele pa kitanda kimonga. Mmonga ibeta kujha ni jhongi ilekibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kubetakujha ni bhadala bhabhele bhisyagha nafaka pamonga, ");
INSERT INTO kiz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","mmonga itolibhwa ni jhongi ilekibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wakamwuliza, “Wapi, Mungu?” akabhajobhela, “Pale ulipo mzoga, ndipo tai hukusanyika kwa pamoja.” ");
INSERT INTO kiz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kisha akabhajobhela mfano bhwa namna kyabhilondeka kus'oka daima, not bhasikati tamaa. ");
INSERT INTO kiz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","akajobha, 'Kwajhele ni hakimu mu mji fulani, ambajhe an'tileghe lepi K'yara na abhaheshimuili lepi bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kwajhele ni mjane mu jiji e'lu, ni muene andotili mara jhimehele, akajobha, 'Nitangatilayi kukabha haki dhidi jha mpinzani ghwangu.' ");
INSERT INTO kiz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa muda mrefu ajhelepi tayari kun'saidila, lakini baada jha muda akajobha mu muoyo bhwa muene, `Ingawa nene niken'tila lepi K'yara au kuheshimu munu, ");
INSERT INTO kiz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Lakini kwa vile ojho mjane akanisumbula nibeta kun'tangatila kukabha haki jha muene, ili asihidi kunitondesya kwa kunihidila mara kwa mara.” ");
INSERT INTO kiz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kisha Bwana akajobha, 'Pe'lekesiajhi kya ajobhili hakimu ojhu dhalimu. ");
INSERT INTO kiz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Je K'yara kabhele ibeta lepi kuleta haki kwa bhateule bha muene ambabho bhakandelele kiru ni musi? Je, muene ibeta lepi kujha mvumilivu kwa bhene? ");
INSERT INTO kiz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nikabhajobhela kujha ibeta haki kwa bhene manyata. Lakini mwana ghwa Adamu pa ibeta kuhida, je, ibetakukolela imani paduniani?' ");
INSERT INTO kiz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ndipo akabhajobhela mfano obho kwa baadhi jhe bhanu ambabho bhikibhona bhene kujha bhenye haki ni kubhadharau bhanu bhangi. ");
INSERT INTO kiz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","'Bhanu bhabhele bhakwelili kulota ku hekalu kusali: Jhongi Mfarisayo ni jhongi mtoza ushuru. ");
INSERT INTO kiz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisayo akajhema akasoka mambo agha juu jha muene K'yara nikubhombesya kwandabha nene sio kama bhanu bhamana ambabho bhanyang'anyi, bhanu bhabhabelikujha bhaadilifu bhazinzi, au kama ojho mtoza ushuru. ");
INSERT INTO kiz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nifunga mara sibhele khila wiki. Nipisya zaka mu mapato ghoha ghanikabha. ");
INSERT INTO kiz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini jhola mtoza ushuru, ajhemili patali, abhwesilepi hata kujhinula mihu gha muene kumbinguni, akatobha kifua kya muene akajobha, 'k'yara nirehemu nene mwenye dhambi. ");
INSERT INTO kiz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nikabhajobhela, munu ojho abhujhili kunyumba khoni abhalangibhu haki kuliko jhongi jhola, kwandabha kila jhe ikikwesya ibeta kuselesibhwa, lakini khila munu jheikaji nyenyekela ibetakujhinulibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bhanu bhandetili bhana bhabhi bhadebe, ili abhwesiajhi kubhagusa, lakini bhanafunzi bha muene bho bhaghabhuene aghu bhabhabesili. ");
INSERT INTO kiz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu akabhakuta kwa muene akajobha, 'bhalekayi bhana bhadebe bhahidayi kwa nene, wala musibhabesi. Maana ufalme bhwa K'yara ndo ghwa bhanu kama abhu. ");
INSERT INTO kiz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aminiayi, nikabhajobhela, munu jhejhioha jhaabelili kuupokela ufalme bhwa K'yara kama muana ni dhahiri ibeta lepi kujhingila.' ");
INSERT INTO kiz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mtawala mmonga akan'kota, akajobha, 'mwalimu n'nofu, niketabhuli ili niurithiajhi uzima bhwa milele?' ");
INSERT INTO kiz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akan'jobhela, 'Kwandajhakiki ukanikuta mwema? Ajhelepi munu jha ajhe n'nofu, muene. ");
INSERT INTO kiz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Usimanyili amri- usizini, usikomi, usiheji, usishuhudili udesi, bhaheshimuajhi dadiwaku ni nyinuaku. ");
INSERT INTO kiz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mtawala jhola akajobha, 'Mambo agha ghoha nighakamuili kuhomela ne n'songolo.' ");
INSERT INTO kiz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu bho aghapeliki aghu akan'jobhela, “Up'hong'okibhu lijambo limonga. Lazima uhemelesiajhi fyoha fya ujhenafu na ubhagabhilayi maskini, nabhi wibetakujha ni hazina kumbinguni -kisha hidayi unikesiajhi.' ");
INSERT INTO kiz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini tajiri bho ap'eliki aghu, ahuzuniki sana, kwandabha ajhele tajiri sana. ");
INSERT INTO kiz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kisha Yesu, akambona kyaahuzuniki nesu akajobha, 'Jinsi gani kyajhibetakujha panonono kwa tajiri kujhingila mu ufalme bhwa K'yara! ");
INSERT INTO kiz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mana ni rahisi muni kwa ngamia kup'eta mu lilende lya sindanu, kuliko tajiri kujhingila mu ufalme bhwa K'yara.' ");
INSERT INTO kiz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhala bhabhap'eliki aghu, bhakajobha, 'Niani basi, jhaibeta kuokolibhwa?' ");
INSERT INTO kiz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ajibili, 'Mambo ghaghabelili kubhwesekana kwa mwanadamu kwa K'yara ghibhwesekana.” ");
INSERT INTO kiz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petro akajobha, 'Naam, tete tukilekili khila khenu na tukukesisi bhebhe.' ");
INSERT INTO kiz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kisha Yesu akabhajobhela, Muaminiajhi nikabhajobhela kujha ajhelepi munu jha alekhili nyumba au n'dala, au ndongo, au bhazazi au bhana, kwandabha jha ufalme bhwa K'yara, ");
INSERT INTO kiz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ambajhe jhaibeta lepi kupokela ghamehele zaidi mu ulimwengu obho, ni mu ulimwengu bhwawihida uzima bhwa milele.' ");
INSERT INTO kiz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Baada jha kubhabhonganiya bhala kumi ni bhabhele akabhajobhela, 'Langayi, twikwela kulota Yerusalemu, ni mambo ghoha ambagho ghalembibhu ni manabii kuhusu Mwana ghwa Adamu ghibeta kukamilisibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwa mana ibeta kupokelibhwa mu mabhoko gha bhanu bha mataifa ni kubhombibhwa dhihaka ni jeuri ni kufunyibhwa mata. ");
INSERT INTO kiz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baada jhe kun'tobha fiboko bhibeta kun'koma ni ligono lya tatu ibeta kufufuka.' ");
INSERT INTO kiz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bhajhelibhu lepi mambo agha, ni lilobhi ele lyafighibhu kwa bhene, nabhajhelibhu lepi mambo ghaghajobhibhu. ");
INSERT INTO kiz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ikajha Yesu bho akaribili Yeriko, munu mmonga kipofu ajhele atamili kando jha barabara isoka msaada, ");
INSERT INTO kiz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","bho ap'eliki umati bhwa bhanu bhip'eta akotili kitokela kiki. ");
INSERT INTO kiz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakan'jobhela Yesu ghwa Nazareti ip'eta. ");
INSERT INTO kiz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hivyo kipofu jhola akalela kwa sauti, akajobha, 'Yesu, mwana ghwa Daudi, unirehemu.' ");
INSERT INTO kiz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bhala bhabhagendeghe bhakanjwangila kipofu ojhu, bhakan'jobhela agudamayi. Lakini muene ajhendelili kulela kwa sauti, Mwana ghwa Daudi unirehemu. ");
INSERT INTO kiz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu akajhema akaamuru munu jhola aletibhwayi kwa muene. Kisha jhola kipofu bho an'karibili, Yesu akan'kota, ");
INSERT INTO kiz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","'Wilonda nikuketalayi kiki?' Akajobha, 'Bwana, nilonda kulola.' ");
INSERT INTO kiz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu akan'jobhela, 'Ubhwesiajhi kulola. Imani jha jhobhi ikuponyisi.' ");
INSERT INTO kiz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mara jhejhuejhu akabhwesya kulola, akan'kesya Yesu ni kun'tukusya k'yara. Bhobhalibhwene e'le bhanu bhoha bhan'sifiri K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ajhingili ni kup'eta pagati pa Yeriko. ");
INSERT INTO kiz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ni apu pajhele ni munu mmonga jhaakutibhweghe Zakayo. Ambajhe ajhele mbaha ghwa bhatoza ushuru kabhele munu tajiri. ");
INSERT INTO kiz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Akajha ijaribu kumbona Yesu ndo munu kulola kwandabha jha umati bhwa bhanu, kwandabha ajhe mfupi ghwa kimo. ");
INSERT INTO kiz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hivyo, alongolili mbio mbele sya bhanu, akakwela panani pa mkuyu ili abhwesiajhi kumbona, kwandabha Yesu akaribili kup'etela njela ejhu. ");
INSERT INTO kiz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wakati Yesu afikili mahali pala, akalenga kunani akan'jobhela, 'Zakayo, selelayi manyata, maana lelu lazima nishindayi munyumba jha bhebhe.'. ");
INSERT INTO kiz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Akabhomba haraka, akaselela ni kun'karibisya kwa furaha. ");
INSERT INTO kiz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bhanu bhoha bho bhabhuene aghu bhalalamiki, bhakajobha, 'Alotili kun'gendela munu mwenye dhambi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo akajhema akan'jobhela Bwana, Nusu gha mali jha nene nikabhapela maskini, na jhikajhiajhi ninyakili munu jhejhioha khenu, ni betakunkerebhusila mara nne.' ");
INSERT INTO kiz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu akan'jobhela, lelu wokovu ufikili munyumba ejhe, kwandabha muene kabhele ni mwana ghwa Ibrahimu. ");
INSERT INTO kiz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwandabha mwana ghwa munu ahidili kulonda ni kuokola bhanu bhabhajhaghili.' ");
INSERT INTO kiz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bho ap'eliki aghu, ajhendelili kulongela ni kupisya mifano, kwandabha ajhele karibu ni Yerusalemu, ni bhene bhafikilireghe kujha ndo Mfalme bhwa K'yara ajhele karibu kubhonekana mara jhimonga. ");
INSERT INTO kiz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hivyo akabhajobhela, 'Ofisa mmonga alotili nchi jha patali ili apokelayi ufalme ni kisha akerebhukajhi. ");
INSERT INTO kiz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Abhakutili bhatumishi bhwa muene kumi, akabhapela mafungu kumi, akabhajobhela, mubhombelayi biashara mpaka pa nibeta kukerebhuka.' ");
INSERT INTO kiz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini bhananchi bha muene bhan'dadili na hivyo bhakalaghisya bhajumbe bhalotayi kun'kesya ni kujobha, Twilondalepi munu ojho atutawalayi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ikajha bho akerebhwiki kunyumba baada jha kujha mfalme, akaamuru bhala bhatumishi bha abhalakili hela bhakutibhwayi kwa muene, abhwesiajhi kumanya faida jheleku bhajhikabhili kwa kubhomba biashara. ");
INSERT INTO kiz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wa kuanza akahida, akajobha, `Bwana, fungu lya jhobhi libhombili mafungu kumi zaidi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ofisa ojhu akan'jobhela, kinofu mtumishi rinofu. Kwandabha wajhele ghwe mwaminifu mu khenu kidebe, wibeta kujha ni madaraka juu jha miji kumi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa pili akahida, akajobha, 'Bwana, fungu lya jhobhi libhombili mafungu mahanu.' ");
INSERT INTO kiz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Afisa ojhu akan'jobhela, 'Tolayi mamlaka juu jha miji mihanu.' ");
INSERT INTO kiz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ni jhongi akahida, akajobha, `Bwana ejhe apa hela jha jhobhi najhitunzili kinofu mu kitambala, ");
INSERT INTO kiz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kwandabha natikili bhebhe ghwe n'kali. ghwibhosya khela kya ubhekilepi ni kuvuna khela kya ubelikupanda.' ");
INSERT INTO kiz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Afisa ojhu akan'jobhela, 'Kwa malobhi ghaku ghwe muene, nibeta kuhukumu, ebhe mtumishi n'nofu lepi. Ghwamanyili kujonene ne munu nenkali nitola kya nikibhekilepi ni kuvuna ambakyo napandilepi. ");
INSERT INTO kiz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Basi, mbona ghwabhekilepi hela jha nene benki, ili nikakerebhukayi niitolayi pamonga ni faida? ");
INSERT INTO kiz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ofisa akabhajobhela bhanu bhabhajhemili apu, 'Munyakayi lifungu e'lu ni kumpela jhola mwenye mafungu kumi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhakan'jobhela, `Bwana, muene ajhe ni mafungu kumi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Nikabhajobhela, kila munu jhaa jhe naku ibeta kupelibhwa nesu, lakini jhaadulili, hata khela kya ajhenaku kitolibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lakini abha maadui bha nene, ambabho bhilonda lepi nijhelayi mfalme ghwa bhene, mubhaletayi apa ni kubhakoma mbele jha muenga.” ");
INSERT INTO kiz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Baada jha kujobha aghu, akajhendelela palongolo akakwela kulota Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bho akaribili Bethfage ni Bethania, karibu ni kidonda kya Mizeituni, akabhalaghisya bhanafunzi bha muene bhabhele, ");
INSERT INTO kiz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Akajobha: `Mulotayi mu kijiji kya jirani. Mkajhingilayi, mwibeta kun'kolela mwana -punda apandisibhulepi akona. Mumbopolayi, mundetayi kwa nene. ");
INSERT INTO kiz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kama munu abhakotili kwandajha kiki mwibhopola? 'Mujobhayi, “Bwana akandonda.” ");
INSERT INTO kiz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bhala bhabhatumibhu bhakalota bhakambona mwana-punda kama Yesu kyaabhajobhili. ");
INSERT INTO kiz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bho bhikambopola mwana-punda bhamiliki bhakebhajobhela, 'Kwandajha kiki mkambopola mwana punda ojhu?' ");
INSERT INTO kiz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhakajobha, `Bwana akandonda.' ");
INSERT INTO kiz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Basi, bhakampelekela Yesu bhakatandika ghobho sya bhene panani pa mwana punda ni kun'kwesya Yesu panani. ");
INSERT INTO kiz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bho ilota bhanu bhakatandasya maguanda gha bhene mu njela. ");
INSERT INTO kiz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bho iselela kidonda kya Mizeituni, jumuiya jhioha jha bhanafunzi bhakajhanda kushangilila ni kun'tukusya k'yara kwa sauti mbaha, kwandabha jha mambo mabhaha bhaghabhwene, ");
INSERT INTO kiz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bhakajobha, 'Ndo mbarikibhwa mfalme jhaihida kwa lihina lya Bwana! Amani kumbinguni, ni utukufu panani!' ");
INSERT INTO kiz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baadhi jha Mafarisayo pa mkutano bhakan'jobhela, Mwalimu, bhagudamisiajhi bhanafunzi bha jhobhi.' ");
INSERT INTO kiz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akajibu akajobha, `Nikabhajobhela, kama abha bhakagudamayi, maganga ghibeta kukwesya sauti.' ");
INSERT INTO kiz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu bhoaukaribili mji aulelili, ");
INSERT INTO kiz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akajobha, laiti ngaumanyi hata bhebhe, mu ligono e'le mambo ambagho ghibeta kuletela amani! Lakini henu ghakifighili pamihu gha jhobhi. ");
INSERT INTO kiz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwa kujha magono ghihida ambagho maadui bha jhobhi bhibeta kujenga liboma karibu ni bhebhe ni kukusyongoka ni kukukandamisya kuh'oma khila lubhafu. ");
INSERT INTO kiz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bhibeta kubinisya pasi bhebhe ni bhanabhu. Bhibeta lepi kulekela hata liganga limonga panani pa l'enge, kwandabha ghwatambuili lepi wakati K'yara bho ijaribu kuokola'. ");
INSERT INTO kiz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu akajhingila mu lihekalu, akajhanda kubhabhenga bhala bhabhahemelisiaghe, ");
INSERT INTO kiz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akabhajobhela, “Jhilembibhu, 'Nyumba jha nene jhibeta kujha nyumba jha sala, 'lakini muenga mujhifwanyili kujha lipangu lya bhanyang'anyi”. ");
INSERT INTO kiz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Henu, Yesu akajha ifundisya khila ligono mu hekalu. Makuhani bhabhaha ni bhalimu bha sheria ni bhalongosi bha bhanu bhalondeghe kun'koma, ");
INSERT INTO kiz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lakini bhabhwesi lepi kukabha njela jha kubhomba naha, kwandabha bhanu bhoha bhajhele bha kamp'el'ek'esya kwa makini. ");
INSERT INTO kiz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lyajhele ligono limonga, Yesu bho akabhafundisya bhanu mu hekalu ni kuhubiri injili, makuhani bhabhaha ni bhalimu bha sheria bhandotili pamonga ni bheseya. ");
INSERT INTO kiz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bhalongelili, bhakan'jobhela, 'Tujobhelayi ni kwa mamlaka ghaloki wibhomba mambo agha? au niani ojho jha akupelili mamlaka agha?” ");
INSERT INTO kiz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ni muene akajibu, akabhajobhela, 'Ni nene kabhele nibeta kubhakhota liswali. Munijobhelayi ");
INSERT INTO kiz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ubatisu bhwa Yohana. Je, wahomili kumbinguni au kwa bhanu?' ");
INSERT INTO kiz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini bhakajadiliana bhene kwa bhene, 'Tukajobhayi, `lyahomili kumbinguni, ibeta kutukota, `Basi, kwandabha kiki mwamwaminilepi?' ");
INSERT INTO kiz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tukajobhayi; lyahomili kwa bhanadamu; bhanu bhoha apa bhibeta kututobha maganga, maana bhoha bhiamini kujha Yohana ajhele nabii.' ");
INSERT INTO kiz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Basi, Bhakajibu kujha bhamanyilepi kwa jhah'omili. ");
INSERT INTO kiz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu akabhajobhela, “Wala nene nikabhajobhela lepi ni kwa mamlaka ghaloki nibhomba mambo agha.” ");
INSERT INTO kiz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Abhajobhili bhanu mfano obho, “Munu mmonga apandili n'gonda ghwa mizabibu, alikodisi kwa bhakulima bha mizabibu ni kulota nchi jhenge kwa muda mrefu. ");
INSERT INTO kiz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kwa muda bhwa ghwapangibhu, andaghisi mtumishi kwa bhakulima bha mizabibu, kwamba bhampelayi sehemu jha n'gonda ghwa mizabibu. Lakini bhakulima bha mizabibu bhan'tobhili, bhambombili kinofu lepi, bhakan'kerebhusya mabhoko mat'op'o. ");
INSERT INTO kiz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kisha akan'tuma kabhele mtumishi jhongi ni bhene bhakan'tobha, ni kumbombela kinofu lepi, ni kun'kerebhusya mabhoko mat'op'o. ");
INSERT INTO kiz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","An'tumili kabhele ghwa tatu ni bhakan'jeruhi ni kun'tagha kwibhala. ");
INSERT INTO kiz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hivyo bwana ghwa n'gonda akajobha, 'Nibeta kuketa kiki? Nibetakun'tuma mwanabhangu mpendwa. Labda bhibeta kun'heshimu. ");
INSERT INTO kiz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Lakini bhakulima bha mizabibu bho bhambwene, bhajadili bhene kwa bhene kwa bhene bhakajobha, `Ojho ndo mrithi. Tun'komayi ili urithi bhwa muene bhujhelayi bhwa tete.' ");
INSERT INTO kiz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhakampisya kwibhala mu n'gonda ghwa mizabibu bhakan'koma. Je n'kolo n'gonda ibeta kubhakheta kiki? ");
INSERT INTO kiz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ibeta kuhida kubhaangamisya bhakulima bha mizabibu, ni kubhapela n'gonda obhu bhangi”. 'Na bhene bho bhap'eliki aghu, bhakajobha, 'k'yara abelili. ");
INSERT INTO kiz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu akabhalanga, akajobha, “Je andiku e'le lijhe ni maana jheleku? 'Liganga lya bhalibelili bhajenzi, lijheli liganga lya palubhafu? ");
INSERT INTO kiz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Khila munu jhaibina pa liganga e'lu, ibeta kudenyeka fipandi fipandi. Lakini jhola ambajhe libeta kumbinila, libetakuntimbikila. ");
INSERT INTO kiz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hivyo bhaandishi ni bhabhaha bha makuhani bhalondili njela jha kun'kamula muda bhobhuobhu, bhamanyili kujha ajobheghe mfano obho kwa ndabha jha bhene. Lakini bhabhatilili bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bhandangili kwa makini, bhakalaghisya bhapelelezi bhabhakifwanyeghe kujha bhanu bha haki, ili bhabhwesiajhi kukabha likosa kwa hotuba jha muene, ili kumpeleka kwa bhatawala ni bhenye mamlaka. ");
INSERT INTO kiz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na bhene bhakan'kota, bhakajobha, “Mwalimu, tumanyili kujha wijobha ni kufundisya mambo gha bhukweli na sio kushawishiwa ni munu jhejhioha, lakini bhebhe wifundisya bhukweli kup'etela njela j'ha K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Je, ndo halali kwa tete kul'epa kodi kwa Kaisari, au la?” ");
INSERT INTO kiz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lakini Yesu amanyili n'teghu ghwa bhene, akabhajobhela, ");
INSERT INTO kiz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nilasiajhi dinari. Sura ni chapa jha niani ijhe panani pake?” Bhakajobha,'”Ya Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ni muene akabhajobhela, 'Basi, mumpelayi Kaisari jhaijhele jha Kaisari, ni K'yara jheijhele jha muene k'yara.' ");
INSERT INTO kiz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bhaandishi ni bhabhaha bha makuhani bhajhelepi ni uwezo bhwa kukosola khela kya ajobhili palongolo pa bhanu. Bhakastaajabu majibu gha muene na bhajobhililepi kyokyoha. ");
INSERT INTO kiz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baadhi jha Masadukayo bhakandotela, bhala bhabhijibha kujha ujhe lepi ufufuo, ");
INSERT INTO kiz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bhakan'kota bhakajobha, “Mwalimu, Musa atulembili kujha kama munu afwelibhu ni ndongo mwenye n'dala ambajhe ajhelepi ni muana basi jhilondeka kun'tola ni n'dala ghwa ndongo munu ni kuhogola naku kwandabha jha kaka yake. ");
INSERT INTO kiz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwajhele ni bhanandugu saba ghwa kuanza agegili, afwili bila kuleka muana, ");
INSERT INTO kiz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ni wapili kabhele. ");
INSERT INTO kiz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ni wa tatu akan'tola mebhu mebhu ni wa saba alekilepi muana ni kufwa. ");
INSERT INTO kiz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Baadaye n'dala jhola afwali ni muene. ");
INSERT INTO kiz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mu ufufuo ibeta kujha n'dala ghwa niani? Mana bhoha saba bhan'gegili.' ");
INSERT INTO kiz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akabhajobhela, “Bhanu bha ulimwengu obho bhigega ni kugegikibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lakini bhala bhabhilondeka kupokela ufufuo bhwa bhafu ni kujhingila uzima bhwa milele bhigega lepi wala kugegikibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wala bhibhwesya lepi kufwa kabhele, kwandabha bhijha sawasawa ni malaika na ndo bhana bha K'yara, bha ufufuo. ");
INSERT INTO kiz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini naha ndo bhafu bhifufulibhwa, hata Musa alasili mahali pa habari sya kichaka, pala an'kutili Bwana kama K'yara ghwa Ibrahimu ni K'yara ghwa Isaka ni K'yara ghwa Yakobo. ");
INSERT INTO kiz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Henu, muene sio K'yara bhafu, bali ghoa bhajhe hai, kwandabha bhoha bhiishi kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baadhi jha bhalimu bha sheria bhakan'jibu, 'Mwalimu, Ujibili kinofu.' ");
INSERT INTO kiz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bhathubuiti lepi kun'kota maswali ghamehele nesu. ");
INSERT INTO kiz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu akabhajobhela, “Bhulibhuli bhanu bhijobha kujha Kristu mwana ghwa Daudi? ");
INSERT INTO kiz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mana Daudi muene ijobha mu Zaburi: Bwana an'jobhili Bwana bhangu: Tamayi kibhoko kya kulia, ");
INSERT INTO kiz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka nibhabhekayi maadui bha jhobhi pasi pa magolo gha jhobhi.' ");
INSERT INTO kiz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi akan'kuta Kristu 'Bwana', basi ibeta kujha bhuli mwana ghwa Daudi?” ");
INSERT INTO kiz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bhanu bho bbhakamp'elekesya akabhajobhela bhanafunzi bha muene, ");
INSERT INTO kiz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","'Mukihadhariajhi ni bhaandishi, bhabhalonda kugenda bhafwalili maguanda matali, na bhilonda salaamu maalumu mu soko ni fiti fya heshima mu Masinagogi, ni maeneo ghangi gha heshima mu karamu. ");
INSERT INTO kiz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bhabhu bhene bhilya mu nyumba sya bhajane, na bhikifwanya bhisali sala sitali. Abha bhibeta kupokela hukumu mbaha nesu.' ");
INSERT INTO kiz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu alangili abhabhuene bhagosi matajiri bhabhabhekeghe zawadi sya bhene mu hazina. ");
INSERT INTO kiz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akambona mjane mmonga maskini ibheka senti sya muene sibhele. ");
INSERT INTO kiz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hivyo akajobha, kweli nikabhajobhela, ojhu mjane maskini abhekili simehele kuliko bhangi bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Abha bhoha bhahomisi zawadi ese kuhoma mu fingi fyabhajhe nefu. Lakini ojho mjane, mu umasikini bhwa muene ahomisi hela syoha syaajhe nasu kwa ndabha jha kuishi kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wakati bhamana bho bhijobha panani pa hekalu, namna kyalikepambibhu ni maganga manofu ni matoleo, ajobhili, ");
INSERT INTO kiz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kwa habari jha mambo agha ghamkaghabhona, magono ghibetakuhida ambagho lijhelepi liganga limonga ambalyo libeta kulekibhwa panani pa lenge ambalyo libeta lepi kubomolibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hivyo bhakan'kota, bhakajobha, “Mwalimu, mambo agha ghibeta kutokela ndali? Ni kiki kibeta kujha ishara kwamba agha mambo gha jhobhi karibu kutokela?” ");
INSERT INTO kiz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ajibili, “Mujhelayi bhaangalifu kwamba musikofibhu. Kwandabha bhingi bhibeta kuhida kwa lihina lya nene, ni kujobha, 'Nene ndo muene, ni muda ukaribili'. Musibhabesi. ");
INSERT INTO kiz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mukapelekayi vita ni fuju musitili, kwandabha mambo agha lazima ghatokelayi hoti, lakini mwisho wibetalepi kuhomela manyata.” ");
INSERT INTO kiz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kisha akabhajobhela, “Taifa libeta kujhinuka kukomana ni taifa lenge, ni ufalme juu jha ufalme bhongi. ");
INSERT INTO kiz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kubetakujha ni matetemeku mabhaha ni njala ni tauni mu maeneo mbalimbali. Kubetakujha ni matukio gha kutisya ni ishara sya kutisya kuhoma kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakini kabla jha mambo agha ghoha, bhibeta kubheka mabhoko ghe bhene panani pa muenga ni kubhatisya, kubhapeleka mu masinagogi ni magereza, kubhaleta mbele jha bhafalme ni bhenye mamlaka kwandabha jha lihina lya nene. ");
INSERT INTO kiz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ijhe jhibeta kufungulibhwa fursa kwa ushuhuda bhwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Henu muamulayi mu mioyo ghya jhomu kubela kuandala utetezi bhwinu manyata, ");
INSERT INTO kiz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwandabha nibeta kubhapela malobhi gha hekima, ambagho bhaadui bhinu bhoha bhibeta bhwesya lepi kujhipinga ni kujhibela. ");
INSERT INTO kiz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Lakini mwibeta kubelibhwa kabhele ni bhazazi bha jhomu, bhalongo bhinu, jamaa bhinu ni marafiki bhinu, ni kubhakoma baadhi jha muenga. ");
INSERT INTO kiz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mwibeta kudadibhwa ni khila mmonga kwandabha jha lihina lya nene. ");
INSERT INTO kiz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini lwibeta lepi kujha unywele wa vichwa vyenu utakaopotea. ");
INSERT INTO kiz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","katika kuvumilia mtaziponya nafsi zenu. ");
INSERT INTO kiz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pamwibeta kubhona Yerusalemu jhisyonguiki ni majeshi, basi mumanyayi kujha uharibifu bhuake bhukaribili. ");
INSERT INTO kiz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Apu bhala bhabhajhele Yudea bhajumbililayi kukidonda, ni bhala bhabhajhele pagati pa jiji bhabhokayi, na musibhaleki bhabhajhele mu fijijini kujhingila. ");
INSERT INTO kiz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mana agha ndo magono gha kisasi, ili kwamba mambo ghoha ghaghabembibhu ghatimilalayi. ");
INSERT INTO kiz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ole ni kwa bhala bha bhajhele ni luleme ni kwa bhala bhafiele mu magono aghu! Kwa mana kubetakujha ni adha mbaha panani pa nchi, ni gadhabu kwa bhanu abha. ");
INSERT INTO kiz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na bhibeta kubina kwa ncha jha upanga na bhibeta kitolibhwa mateka kwa mataifa ghoha, ni Yerusalemu jhibetakukanyibhwa ni bhanu bha mataifa, mpaka wakati bhwa bhanu bha mataifa pamwibeta kutimilika. ");
INSERT INTO kiz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kubetakujha ni ishara mu lijobha, muesi ni mat'ondo. Ni mu nchi kubetakujha ni dhiki jha mataifa, mu kakata tamaa kutokana ni mwamujhele bha bahari ni manyegha. ");
INSERT INTO kiz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kubetakujha ni bhanu bhabhizimila kwa hofu ni katika kutalajila mambo ghaghibeta kuhomela panani pa dunia kwa maana nghofu sya mbigu sibetakutikisibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kisha bhibeta kumbona mwana ghwa Adamu ihida mu mabhengu mu ngofu ni utukufu mbaha. ");
INSERT INTO kiz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lakini mambo agha paghibeta kujhanda kuhomela, mujhemayi, mujhinulayi mitu ghya jhomu, kwandabha ukombozi bhwa jhomu uhegelili karibu. ");
INSERT INTO kiz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu akabhajobhela kwa mfano, “Mubhulangayi mtini, ni mabhehe ghoha. ");
INSERT INTO kiz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pajhihome sya machipukizi, mukilolela mwebhene ni kumanya kujha kilolelu tayari kijhe karibu. ");
INSERT INTO kiz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mebhu, pamwibhona mambo agha ghihomela, muenga mumanyayi jha kujha ufalme bhwa K'yara uhegelili. ");
INSERT INTO kiz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kweli, nikabhajobhela, kizazi ekhe kibetalepi kupeta, mpaka mambo agha ghoha paghibeta kuhomela. ");
INSERT INTO kiz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mbingu ni nchi sibetakup'eta, lakini malobhi ghangu ghibeta lepi kup'eta kamwe. ");
INSERT INTO kiz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Lakini mulangayi mwabhene, ili kwamba mioyo ghya jhomu isihidi kudemebhwa ni ufisadi, ulevi, ni mahangaiku gha maisha agha. Kwandabha ligono lela libetakubhahidila ghafla. ");
INSERT INTO kiz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kama n'teghu. kwa ndabha ibeta kujha panani pa khila mmonga jhaitama mu uso bhwa dunia jhioha. ");
INSERT INTO kiz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lakini mujhelayi tayari muda bhuoha, mus'okayi kujha mwibeta kujha imara fya kutosha kughajhepa agha ghoha ghaghibeta kuhomela, ni kujhemela mbele sya mwana ghwa Adamu.” ");
INSERT INTO kiz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hivyo wakati wa pamusi ajhele ifundisya mu hekalu ni pakilu ahomili kwibhala, ni kulota kukesha pa kidonda kya kikutibhweghe kya Mzeituni. ");
INSERT INTO kiz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bhanu bhoha bhan'hidili lukhela lubhuliku ili kumpelekesya mugati mu. hekalu. ");
INSERT INTO kiz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Basi sikukuu jha mikate jhajhisopibhu chachu jhakalibili, ambajho jhikutibhwa Pasaka. ");
INSERT INTO kiz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Makuhani bhabhaha ni bhaandishi bhajadiliene namna jha kun'koma Yesu, kwa ndabha bhabhatilili bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shetani akajhingila mugati mwa Yuda Iskariote, mmonga ghwa bhanafunzi bha Yesu kumi ni bhabhele. ");
INSERT INTO kiz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda akalota kujadiliana ni bhabhaha bha makuhani ni bhabhaha namna ambavyo ibeta kun'kabidhi Yesu kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bhohobhelili, ni kukubaliana kumpela hela. ");
INSERT INTO kiz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Muene alidhiri, na alondili fursa jha kun'kabidhi Yesu kwa bhene mbali ni likundi lya bhanu. ");
INSERT INTO kiz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ligono lya mikate jha fikili, ambapo kondoo ghwa Pasaka lazima apisibhwayi. ");
INSERT INTO kiz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu abhatumili Petro ni Yohana, akajobha, “Mulotayi mkatuandalilayi kyakulya kya Pasaka ili tuhidayi tukiliayi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhakan'kota, “Ndaku wilonda tubhombelayi maandalizi aghu?” ");
INSERT INTO kiz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ajibili, “Mup'elekesiajhi, pamwibeta kujha mujhingili pa mjini, n'gosi jha ap'endili kibhegha kya masi ibeta kubhonana ni muenga. Mun'kesiajhi mu nyumba jhaibetakujhingila. ");
INSERT INTO kiz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kisha mun'jobhilayi bwana ghwa nyumba, “Mwalimu ikujobhela, “Kijhendaku kichumba kya bhahesya, mahali ambapo nibetakulya pasaka ni bhanafunzi bha nene?” ");
INSERT INTO kiz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ibetakubhalasya kichumba kya kughorofa ambakyo kijhele tayari. Mubhombayi maandalizi omu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hivyo bhakalota, ni kukolela khila khenu kya abhajobhili. Kisha bhaandele kyakulya kya Pasaka. ");
INSERT INTO kiz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Muda bho ufikili atamili ni bhala mitume. ");
INSERT INTO kiz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kisha akabhajobhela, “Nijhe ni shauku mbaha kulya sikukuu ejhe jha Pasaka ni muenga kabla jha kutesibhwa kwa nene. ");
INSERT INTO kiz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwa ndabha nikabhajobhela, nibeta lepi kulya kabhele mpaka pajhibeta kutimisibhwa mu ufalme bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kisha Yesu akatola kikombi, na bhoamalili kushukuru, akajobha, “Mtolayi ekhe, na mgabhanayi jhomu kwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwandabha nikabhajobhela, nibeta lepi kunywa kabhele mzao bhwa mzabibu, mpaka ufalme bhwa K'yara pawibeta kuhida.” ");
INSERT INTO kiz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kisha akatola n'kate, na bhoamalili kushukuru akaumetula, ni kubhap'ela, akajobha, “Obho ndo mb'ele bhwa nene ambabho bhwibeta kupisibhwa kwa ndabha jha muenga. Mukhetayi naha kwa kunikhomboka nene.” ");
INSERT INTO kiz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akatola kikombi mebhu baada jha kyakulya kyapakiru akajobha, “Kikombi ekhe ndo agano lipya mu damu jha nene ambayo jhibetakujhitika kwa ndabha jha muenga. ");
INSERT INTO kiz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lakini mulangayi. Jhola jhaibeta kunisaliti ajhele pamonga ni nene pameza. ");
INSERT INTO kiz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwa mana Mwana ghwa Adamu kwa kweli ikwilotela kama kyaamulibhu. Lakini ole kwa munu jhola ambajhe kup'etela muene mwana ghwa Adamu asalitibhwayi!” ");
INSERT INTO kiz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bhakajhanda kukotana bhena kwa bhene, niani miongoni mwa bhene ngaabhombili lijambo ele. ");
INSERT INTO kiz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kisha ghakatokela mabishano kati jha bhene kujha niani jhaidhaniwa kujha mbaha kuliko bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Akabhajobhela, “Bhafalme bha bhanu bha mataifa bhajhe ni ubwana juu jha bhene, ni bhala mwenye mamlaka juu jha bhene ikutibhwa bhaheshimibhwa bhatawala. ");
INSERT INTO kiz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini jhilondeka lepi kabisa kujha naha kwa muenga. Bhadala jhiake, lekayi jhola ambajhe ndo mbaha kati jha muenga ajhe kama n'debe. Ni jhola ambajhe ndo wa muhimu sana ajhelayi kama jhaitumikila. ");
INSERT INTO kiz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwa ndabha jholekhu mbaha, jhola jhaitama pameza au jhola jhaitumikila? Je sio jhola jha itama pameza? Ni nene nakona kama jhola jha itama itumikila. ");
INSERT INTO kiz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lakini muenga ndo mujhendelili kujha ni nene mu majaribu ghangu. ");
INSERT INTO kiz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nikabhapela muenga ufalme, kama vile Dadi kyaanilili nene ufalme, ");
INSERT INTO kiz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kwamba mubhwesiajhi ni kunywa pameza pa nene mu fiti fya enzi kuhukumula makabila kumi ni mabhele gha Israeli. ");
INSERT INTO kiz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni, manyajhi kujha, shetani asomili abhakebhajhi ili abhapetayi kama ngano. ");
INSERT INTO kiz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini nikus'omili, kujha imani jha jhobhi isishindwi. Baada jha kujha ukerebhwiki kabhele, bhaimarishajhi bhalongabhu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro akan'jobhela, “Bwana, nijhe tayari kulota ni bhebhe mu ligereza ni hata mu mauti.” ");
INSERT INTO kiz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ajibili, “Nikujobhela, Petro, likongobhe libetalepi kubheka lelu, kabla ya kunibela mara tatu kujha unimanyili.” ");
INSERT INTO kiz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kisha Yesu akabhajobhela, “Bhonibhapeliki muenga bila mfuku, kikapu kya fyakulya, au firatu, je mwap'ongokibhu ni kiki?” Bhakajibu “Lepi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kisha akabhajobhela, “Lakini henu, khila mwenye mfuku, na atolayi ni kikapu kya fyakulya. Jhola jha adulili upanga jhilondeka ahemelesiajhi Roho jha muene ahemelayi umonga. ");
INSERT INTO kiz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwa ndabha nikabhajobhela, ghoha ambagho ghalambibhu kwa ndabha jha nene lazima ghatimilayi, 'Na atolibhu kama munu jha ivunja torati.' Kwa ndabha khela kya ketebiribhu kwa ndabha jha nene kutimisibhwa.” ");
INSERT INTO kiz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kisha bhakajobha, “Bwana, langayi! Ese apa panga sibhele.” Na abhajobhili “sitosya.” ");
INSERT INTO kiz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Baada jha kyakulya kya pakilu, Yesu abhokili, kama kyaajobhili mara kwa mara, akalota pa kidonda kya Mizeituni ni bhanafunzi bhakarikesya. ");
INSERT INTO kiz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bho bhafikili abhajobhili, “Musokayi kwa nene musijhingili mu majaribu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Akalota patali ni bhene kama mrusho bhwa liganga, akapiga magoti akas'oka, ");
INSERT INTO kiz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Akajobha, “Dadi, kama wilonda, nibhoselayi kikombi ekhe. Lakini sio kyanilonda nene, basi kwa mapenzi gha jhobhi ghabhombekayi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kisha malaika kuhoma kumbinguni akan'tokela, akan'sopela nghofu. ");
INSERT INTO kiz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akajha mu kuluala, akas'oka kwa dhati nesu, ni jasho lya muene lyajhele kama madonyangi mabhaha gha damu ghibina pasi. ");
INSERT INTO kiz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bho ajhemili kuhoma mu maombi gha muene, akahida kwa bhanafunzi bha muene, ni kubhakolela bhagonili kwa ndabha jha huzuni jha bhene, ");
INSERT INTO kiz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","na abhakotili, “Kwa ndajha kiki mwigona? Mujhumukayi mus'okayi, ili musijhingili mu majaribu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wakati akona ilongela, langayi, likundi libhaha lya bhanu lyatokili, ni Yuda, mmonga ghwa mitume kumi ni bhabhele ikabhalongosya. Akahida karibu ni Yesu ili ambusuajhi, ");
INSERT INTO kiz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lakini Yesu akan'jobhela, “Yuda, je ukan'saliti mwana ghwa Adamu kwa busu?” ");
INSERT INTO kiz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wakati bhala bhabhajhele karibu ni Yesu bho bhabhwene, aghu ghaghitokela, bhakajobha, “Bwana, je tubhatobhai kwa upanga?” ");
INSERT INTO kiz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kisha mmonga bhabhi akan'tobha mtumishi ghwa kuhani mbaha akan'dumula mb'olokoto jha muene jha kulia. ");
INSERT INTO kiz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu akajobha, “ejhe jhitosya. Ni kugusya mb'olokoto jha muene, akapona. ");
INSERT INTO kiz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu akajobha kwa kuhani mbaha, ni kwa bhabhaha bha hekalu, ni kwa bhaseya bhabhahidili kinyume kya muene, “Je mwihida kama mwihida kupambana ni mnyang'anyi kwa mabonga ni mapanga? ");
INSERT INTO kiz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bho nijhe namu magono ghoha mu hekalu, mwaletilepi mabhoko gha jhomu panani pa nene. Lakini ejhe ndo saa jha jhobhi ni mamlaka ghe ngisi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bhakan'kamula, bhakandongosya kwa kuhani mbaha. Lakini Petro akamfwatilila kwa patali. ");
INSERT INTO kiz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baada jha kujha bhabhwasili muoto muuwanda bhola bhwa mugati na bho bhatamili pasi pamonga, Petro akatama pagati pa bhene. ");
INSERT INTO kiz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mtumishi mmonga n'dala akambona Petro bho atamili mu muenga bhwabhwitokana ni muoto, akandanga akan'jobhela, “Munu ojho kabhele ajhele pamonga ni muene.” ");
INSERT INTO kiz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petro akabela, akajobha, “N'dala nene nimmanyilepi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Baada jha muda kidogo, munu jhongi akambona akan'jobhela “Bhebhe kabhele ndo mmonga ghwa bhene”. Lakini Petro akan'jibu, “N'gosi nenelepi.” ");
INSERT INTO kiz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Baada jha kama lisaa limonga naha, n'gosi mmonga akasisitiza akajobha, “Kweli kabisa munu ojho kabhele ajhele pamonga ni muene, ndabha mgalilaya.” ");
INSERT INTO kiz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petro akajobha, “N'gosi, nijhelebhwa lepi lya wilongela.” Ni mara, wakati ilongela likongobhe likabheka. ");
INSERT INTO kiz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Akageuka, Bwana akandanga Petro. Ni Petro akalikomboka litobhi lya Bwana, paan'jobhileghe, “Kabla jha likongobhe kubheka lelu wibeta kumbela nene mara tatu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bho ilota kwibhala, Petro akalela kwa uchungu mwingi. ");
INSERT INTO kiz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kisha bhala bhagosi bhabhandendeghe Yesu, bhakan'dhihaki ni kun'tobha. ");
INSERT INTO kiz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baada jha kumfunika mihu, bhakan'kota, bhakajobha, “Tabiriajhi! niani jha akutobhili?” ");
INSERT INTO kiz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bhakalongele mambo ghangi ghamehele kinyume kya Yesu ni kun'kufuru muene. ");
INSERT INTO kiz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mara bho jhifikili lukhela, bhaseya bha bhanu bhabhonganiki pamonga, bhabhaha bha makuhani ni bhaandishi. Bhakampeleka mu baraza, ");
INSERT INTO kiz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bhakajobha, “Kama bhebhe ndo Kristu, tujobhelayi.” Lakini muene akabhajobhela, “Kama nikabhajobhelayi mwibeta lepi kuniamini, ");
INSERT INTO kiz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na kama nikabhakotayi mwibeta lepi kunijibu.” ");
INSERT INTO kiz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini kujhandila henu ni kujhendelela Mwana ghwa Adamu ibeta kujha atamili kibhoko kya kuume kya nghofu kya K'yara.” ");
INSERT INTO kiz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhoha bhakajobha, “Kwa hiyo bhebhe ndo mwana ghwa K'yara?” Ni Yesu akabhajobhela, “Muenga mwijobha nene ndo muene.” ");
INSERT INTO kiz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bhakajobha, Kwa ndajha kiki twakona kabhele twilonda ushahidi? kwa ndabha twebhene tumpeliki kuhoma mu kinywa kya muene.” ");
INSERT INTO kiz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mkutano bhoha bhukajhema bhakampeleka Yesu mbele jha Pilato. ");
INSERT INTO kiz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhakajhanda kun'shutumu, bhakajobha, “Tumbwene munu ojho ipotosya taifa lya tete, kwa kubesya tusihomesi kodi kwa Kaisari, ni kujobha kujha muene ndo Kristu, Mfalme.” ");
INSERT INTO kiz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato akan'kota, akajobha, “Je bhebhe ndo Mfalme ghwa bhayahudi?” Ni Yesu akan'jibu akajobha, “Bhebhe nijobha naha”. ");
INSERT INTO kiz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato akan'jobhela kuhani mbaha ni makutano, “Nikalibhona lepi likosa kwa munu ojho”. ");
INSERT INTO kiz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini bhene bhasisitizi, bhakajobha, “Abhachocheleghe bhanu, ifundisya mu uyahudi bhuoha, kubhwanzila Galilaya ni henu ajhele apa.” ");
INSERT INTO kiz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato bho ap'eliki agha, akakotelesya kama munu ojho ghwa Galilaya? ");
INSERT INTO kiz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bho amanyili kujha ajhele chini jha utawala bhwa Herode, ampeliki Yesu kwa Herode, ambajhe ni muene ajhele Yerusalemu kwa magono aghu. ");
INSERT INTO kiz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode bho ambwene Yesu, ahobhwiki kweli kwa ndabha alondeghe kumbona kwa magono ghamehele. Ap'eliki habari sya muene na anogheleghe ligono limonga kulola miujiza jhibhombeka ni muene. ");
INSERT INTO kiz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herode an'kotili Yesu kwa malobhi ghamehele lakini Yesu an'jibili lepi kyokyoha. ");
INSERT INTO kiz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makuhani bhabhaha pamonga ni bhaandishi bhajhemili kwa ukali bhikan'takila. ");
INSERT INTO kiz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode pamonga ni maaskari bha muene, bhandighili ni kumdhihaki, kwa kumfwatika maguanda manofu, kisha akan'kerebhusya Yesu kwa Pilato. ");
INSERT INTO kiz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herode ni Pilato bhakajha marafiki kujhandi ligono e'lu, (kabla jha apu bhajhele maadui). ");
INSERT INTO kiz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato akabhakuta pamonga makuhani bhabhaha ni bhatawala ni umati bhwa bhanu, ");
INSERT INTO kiz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akabhajobhela, “Mundetili munu ojho kama munu jha akabhalongosya bhanu kubhombi manofulepi, na langayi, baada jha kujha nin'hojili mbele jha muenga, nikabhwene lepi likosa kwa munu ojho kuhusu mambo ghoha muenga gha mukan'takila. ");
INSERT INTO kiz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Lepi, wala Herode, kwa ndabha Herode an'kerebhuisi kwa tete, na langayi kijhelepi kyokyoha kyaakibhombili kyakilondeka adhabu jha kufwa. ");
INSERT INTO kiz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kwa hiyo nibeta kun'tobha ni kundekesela. ");
INSERT INTO kiz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Henu, Pilato iwajibika kundekesela mfungwa mmonga kwa bhayahudi wakati bhwa sikukuu). ");
INSERT INTO kiz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini bhoha bhapigili kelele pamonga, bhakajobha, “Umbosyajhi ojhu, ni tubhopolelejhi Baraba!” ");
INSERT INTO kiz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba ajhele munu jha abhekibhu mu ligereza kwa ndabha jha uasi fulani mu jiji ni kukoma. ");
INSERT INTO kiz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato akabhajobhela kabhele, inoghela kundekesela Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini bhene bhapigili kelele, bhakajobha, “N'sulubisiajhi, N'sulubisiajhi.” ");
INSERT INTO kiz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Akabhakota kwa mara jha tatu, “kwandajha kiki, munu ojho akhetili maovu ghaloki? nikabhilepi likosa lya lilondeka adhabu jha kifo kwa muene. Henu panibeta kumala kun'tobha nikandekesela.” ");
INSERT INTO kiz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini bhakasisitiza kwa sauti jha panani, bhakajha bhilonda asulubisibhwajhi. Ni sauti sya bhene syan'shawishi Pilato. ");
INSERT INTO kiz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hivyo Pilato akaamula kubhapela matakwa gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akandekesela jhola jha bhandondeghe ambajhe afungibhu kwa kusababisya ghasia ni kukoma. Lakini akambosya Yesu kwa matakwa gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bho bhakampeleka, bhan'kamuili munu mmonga jhaakutibhweghe Simoni wa Ukirene, akajha ihomela mu nchi, bhakan'tweka n'salaba ili ap'endayi, kun'kesya Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Umati mbaha bhwa bhanu, ni bhadala ambabho bhahuzuniki ni kuombolesya kwa ndabha jha muene bhakajha bhakan'kesya. ");
INSERT INTO kiz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lakini akabhageukila, Yesu akabhajobhela, “Bhahenja bha Yerusalemu, musinileleli nene, bali mukilelelajhi mwebhene kwa ndabha jha bhanabhinu. ");
INSERT INTO kiz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Langayi, magono ghihida bhibeta kujobha, “Bhabarikibhu bhabhajhele tasa ni malemeghaghabeli kuhogola, ni mabhele ambagho ghajhong'isi lepi. ");
INSERT INTO kiz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndipo pabhibeta kuijobhela fidonda, 'Mutubinilayi,' ni filima, 'mutufunikayi.' ");
INSERT INTO kiz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mana kama bhabhabhombili mambo agha ikajhiajhi libehe libhesi, ibeta kujha bhuli KU lijhomu?” ");
INSERT INTO kiz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","bhagosi bhangi, bhabhele, bhapelekibhu pamonga ni muene ili bhakomibhwayi. ");
INSERT INTO kiz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bhobhafikili mahali papikutibhwa fuvu lya mutu, ndipo bhan'sulubisi pamonga ni bhala bhahalifu, mmonga upande bhwa kulia ni jhongi bhwa kushoto. ");
INSERT INTO kiz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu ajobhili, “Dadi ubhasamehajhi, kwandabha bhamanyilepi lya bhikheta. “Na bhene bhakapiga kura, kugabha mavazi gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bhanu bhajhele bhajhemili bhilanga khoni bhatawala bhidhihaki, bhijobha, “Abhaokuili bhangi. Henu akiokolayi muene, kama mwene ndo Kristu ghwa K'yara, mteule”. ");
INSERT INTO kiz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Askari kabhele bhen'dharauli, bhan'hegelili muene ni kumpela ");
INSERT INTO kiz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","siki, Bhakajobha, “Kama bhebhe mfalme ghwa bhajhahudi ukiokolayi ghwejhobhi” ");
INSERT INTO kiz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kwajhe kabhele ni alama panani pa muene jha jhalembibhu “OJHO NDO MFALME GHWA BHAYAHUDI.” ");
INSERT INTO kiz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mmonga ghwa bhahalifu jhaasulubibhu andighili ajobhili, “Bhebhe ghwa Kristu lepi? ukiokolayi ghwe muene ni tete” ");
INSERT INTO kiz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini jhongi jhola ajibili, akanjwangila ni kujobha, “Je bhebhe ukantila lepi K'yara, nabhi ujhe mu hukumu jhejhuejhu? ");
INSERT INTO kiz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tete tujhele hapa kwa haki kwa ndabha tete twipokela khela kya twilondeka kwa matendo gha jhotu. Lakini munu ojho abhombilepi kyokyoha kibaya.” ");
INSERT INTO kiz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na ejhonesi, Yesu, unikhombokayi pawibeta kijhingila mu ufalme bhwa jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu akabhajobhela, “Aminiajhi nikujobhela, lelu jhejhejhe wibetakujha pamonga ni nene paradiso.” ");
INSERT INTO kiz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Apo jhajhele karibu saa sita, ngisi jhahidili panani pa nchi jhioha hadi saa tisa, ");
INSERT INTO kiz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mwanga ghwa lijobha bhasimili, kisha lipazia lya hekalu lyakachuiki pagati kujhandi kunani. ");
INSERT INTO kiz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Alelili kwa sauti mbaha, Yesu akajobha, “Dadi mu mabhoko gha jhobhi nikajhibheka roho jha nene,” baada jha kujobha agha, afuili. ");
INSERT INTO kiz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wakati Akida abhwene ghaghabhombiki an'tukuisi K'yara akajobha, “Hakika ojho ajhele munu mwenye haki.” ");
INSERT INTO kiz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wakati umati bhwa bhanu bhwa uhidili pamonga kushuhudila bho bhabhwene mambo ghaghabhombiki, bhakerebhuki khoni bhitobha fifua fya bhene. ");
INSERT INTO kiz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lakini marafiki zake, ni bhadala bhabhan'kesili kuhoma Galilaya, bhajhemili kwa patali bhilanga aghu mambo. ");
INSERT INTO kiz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Langayi, pajhele ni munu jha akutibhweghe Yusufu, ambajhe ni mmonga ghwa baraza, munu n'nofu na mwenye haki, ");
INSERT INTO kiz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(ajhele akubaliene lepi ni maamuzi au matendo ghabhu), kuhoma Armathaya, mji bhwa Kiyahudi, ambabho bhwajhele wilondela ufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Munu ojho, an'karibili Pilato, akas'oka apelibhwajhi mb'ele bhwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","An'selisi, ni kuusyangosela sanda, ni kumbeka mulikaburi lyalyachongibhu mu liganga, ambalyo ajhelepi jhe abhwayili kusyelibhwa. ");
INSERT INTO kiz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jhajhele ligono lya maandalizi, ni sabato jhikaribila. ");
INSERT INTO kiz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bhadala, bhabhahidili nabhu kuhoma Galilaya, bhan'kesisi na bhabhwene kaburi ni jinsi mbele bhwa muene Kya ugonikibhu. ");
INSERT INTO kiz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bhakerebhuki ni kujhandala manukato ni marashi. Kisha ligono lya sabato bhap'om'osiki kwa mujibu bhwa sheria. ");
INSERT INTO kiz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Manyata sana ligono lya kwanza lya juma, bhahidili kumakaburi bhaletili manukato ambagho bhajhele bhaghaandele. ");
INSERT INTO kiz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhalibhwene liganga libelendusibhu patali ni likaburi. ");
INSERT INTO kiz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bhakajhingila mugati, lakini bhaghubhwene lepi mb'ele bhwa Bwana Yesu. ");
INSERT INTO kiz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jhatokili kwamba, wakati bhachanganyikibhu kuhusu e'le ghafla, bhanu bhabhele bhajhemili pagati pa bhene bhafwalili mavazi gha kulangala. ");
INSERT INTO kiz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bhadala bhamemili hofu ni kujhinamisya nyuso sya bhene pasi, bhakabhajobhela bhadala, “Kwandajha kiki mukandonda jha ajhe hai miongoni mwa bhafu? ");
INSERT INTO kiz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ajhelepi apa, ila afufuiki! Mukhombokayi kyaajobhi ni muenga bho ajhe ni muenga Galilaya, ");
INSERT INTO kiz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ajobhili kujha Mwana ghwa Adamu lazima abhosibhwajhi mu mabhoko gha bhanu bhenye dhambi ni kusulubisibhwa, ni ligono lya tatu, afufukajhi kabhele.” ");
INSERT INTO kiz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bhadala bhalabhakakhomboka malobhi gha muene, ");
INSERT INTO kiz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ni kubhujha kuhoma kumakaburi ni kubhajobhela mambo agha ghoha bhala kumi na moja ni bhangi bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Basi Maria Magdalena, Joana, Maria mabhu ghwa Yakobo, ni bhadala bhangi pamonga nabhu bhakahomesya taarifa e'se kwa mitume. ");
INSERT INTO kiz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakini ujumbe obho bhwabhonekene kama mzaha tu kwa mitume, na bhebhaamini lepi bhadala bhala. ");
INSERT INTO kiz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hata hivyo Petro ajhumuiki, ni kujumba kulota kulikaburi, ni kuhongolela mgati abhuene sanda jhiene. Petro kisha akabhoka akalota kunyumba kwa muene, ni kustaajabu kiki kyakikahomili. ");
INSERT INTO kiz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na langayi, bhabhele miongoni mwa bhene bhajhele bhilota ligono leluelu mu kijiji kimonga kyakikutibhwa Emmau, ambakyo kyajhele maili sitini kuhoma Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhajadiliene bhene kwa bhene kuhusu mambo ghaghatokili. ");
INSERT INTO kiz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jhatokili kwamba, wakati bhijadiliana ni kukota na maswali, Yesu akahegelela karibu akaambatana nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lakini mihu gha bhene ghazuilibhu kummanya muene. ");
INSERT INTO kiz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu akabhajobhela, “Kiki ambakyo muenga bhabhele mkilongelela wakati mwigenda?” Bhakajhema pala bhakajha bhibhonekana ni huzuni. ");
INSERT INTO kiz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmonga bhabhi, lihina lya muene Cleopa, an'jibili, “Je bhebhe ghwe munu pekee apa Yerusalemu ambajhe amanyilepi mambo ghaghatokili okhu magono agha?” ");
INSERT INTO kiz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu akabhajobhela, “Mambo ghaloki?” Bhakan'jibu, “Mambo kuhusu Yesu Mnazareti, ambajhe ajhele nabii, muweza mu matendo ni malobhi mbele sya K'yara ni bhanu bhoha. ");
INSERT INTO kiz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ni jinsi ambavyo bhabhaha bha makuhani ni bhalongosi bha jhotu kyampisili kuhukumibhwa kifo ni kun'sulubisya. ");
INSERT INTO kiz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lakini twatumaini kujha muene ndo jhaibeta kubhebheka huru Israeli. Ena, patali ni agha ghoha, henu ndo ligono lya tatu kuhomela mambo agha ghatokili. ");
INSERT INTO kiz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lakini kabhele, baadhi jha bhadala kuhoma mu likundi lya tete bhatusyangese, baada jha kujha kulikaburi lubhuliku. ");
INSERT INTO kiz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Bho bhaudulili mbele ghwa muene, bhakahida, bhakajobha kwamba bhabhuene kabhele maono gha malaika bhabhajobhili kwamba muomi. ");
INSERT INTO kiz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Baadhi jha bhagosi ambabho bhajhele pamonga natu bhalotili ku likaburi, ni kukolela ni kama vile bhadala kyabhajobhili. Lakini bhambwene lepi muene.” ");
INSERT INTO kiz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu akabhajobhela, “Muenga bhanu bhajinga na bhenye mioyo mizito gha kuamini ghoha ambagho manabii bhajobhili! ");
INSERT INTO kiz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Je jhajhelepi lazima Yesu kuteseka kwa mambo agha, ni kujhingila mu utukufu bhwa muene?” ");
INSERT INTO kiz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kisha kujhandila kuhoma kwa Musa ni manabii bhoha, Yesu abhatafsiriri mambo ghaghakamhusu muene mu maandiku ghoha. ");
INSERT INTO kiz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bhobhakaribili kijiji khela, okhu kwa bhaloteghe, Yesu akabhomba kana kwamba ijhendelela palongolo. ");
INSERT INTO kiz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lakini bhandasimisi, bhakajobha, “Tamayi pamonga ni tete, maana jhilotela kimihi ni ligono kama limaliki.” Hivyo Yesu akajhingila kulota kutama nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jhatokili kwamba, wakati atamili nabhu kulya, atolili n'kate abhubariki, ni kuumetula, akabhapela. ");
INSERT INTO kiz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kisha mihu gha bhene ghafungulibhu, bhakammanya, na abhokili ghafla palongolo pa mihu gha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhakajobhesana bhene kwa bhene, “Hivyo mioyo ghya jhotu ghyikajhelepi mu mioyo ghya jhotu, wakati ilongela natu munjela, wakati atufungutili maandiku?” ");
INSERT INTO kiz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bhakajhinuka lisaa leluelu nikukerebhuka Yerusalemu. Bhakabhakolela bhala kumi na moja bhakibhongeniye pamonga, nibhala bhabhajhe pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bhakajobha, “Bwana afufuiki kweli kweli, na an'tokili Simoni.” ");
INSERT INTO kiz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hivyo bhakabhajobhela mambo ghaghatokili mu njela ni namna Yesu kyaadhihirishibhu kwa bhene mukuumetula n'kate. ");
INSERT INTO kiz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wakati bhilongela mambo agha, Yesu muene ajhemili pagati pa bhene ni kubhajobhela, “Amani jhijhelayi kwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lakini bhatilili ni kujhingilibhwa ni hofu, na bhafikiriri kujha bhabhwene roho. ");
INSERT INTO kiz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu akabhajobhela, kwa ndajhakiki mwifadhaika? kwa ndajhakiki maswali ghijhinuka mu mioyo ghya jhomu? ");
INSERT INTO kiz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mulangayi mabhoko ghangu ni magolo ghangu, kwamba ni nene ne muene. Munigusayi na mulolayi kwa mana roho ijhelepi ni nyama ni mafupa, kama kyamukanibhona nene kujha nafu.” ");
INSERT INTO kiz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bho amali kujobha naha, akabhalasya mabhoko gha muene ni magolo gha muene. ");
INSERT INTO kiz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bhabhakona ni furaha jhajhichanganyikene ni kutokuakiniana ni kustaajabu, Yesu akabhajobhela, “Je mujhe ni khenu kyokyoha kya kulya?” ");
INSERT INTO kiz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakampela kipandi kya somba jhaanyanyibhu. ");
INSERT INTO kiz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu akakitola, ni kukilya mbele jha bhene. ");
INSERT INTO kiz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Akabhajobhela, “Bhonijhele namu, nabhajobhili kujha ghoha ghaghalembibhu musheria sya Musa ni manabii ni Zaburi lazima ghatimilikayi.” ");
INSERT INTO kiz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kisha akafungula akili sya bhene, kwamba bhabhwesiajhi kughajhelebhwa maandiku. ");
INSERT INTO kiz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akabhajobhela, “Kwamba jhilembibhu, Kristu lazima atesekayi, ni kufufuka kabhele kuhoma kwa bhafu ligono lya tatu. ");
INSERT INTO kiz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ni toba ni msamaha bhwa dhambi lazima ihubiribhwayi kwa lihina lya muene kwa mataifa ghoha, kujhandila kuhomela Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Muenga mashahidi bha mambo agha. ");
INSERT INTO kiz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Langayi nikabhapelekela ahadi jha Dadi jhangu juu jha muenga. Lakini mulendayi apa jijini, mpaka pamwibeta kufwatikibhwa nghofu kuhoma kunani. ");
INSERT INTO kiz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kisha Yesu abhalonguisi kwibhala mpaka pabhakaribili Bethania. Ajhinuili mabhoko gha muene kunani, ni kubhabariki. ");
INSERT INTO kiz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jhatokili kwamba, wakati ikabhabariki, abhalekili ni kup'endibhwa kunani kulotela kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Basi bhakamwabudu, ni kukerebhuka Yerusalemu ni furaha mbaha. ");
INSERT INTO kiz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bhajhendelili kujha mu lihekalu, bhikambariki K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kubhwandelu kwa jhela ni Lilobhi, ni Lilobhi ajhela pamonga ni K'yara, ni lilobhi ajhele K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E'le lilobhi, kubhwandelu ajhele pamonga ni K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Fenu fyoha fyabhombiki kup'etela muene, ni bila muene kujhelepi khenu kimonga kya kikajhele kimalikubhombibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mugati mwa muene kwajhele ni bhusima, ni bhusima obhu bhwajhele nuru jha bhanadamu bhoha. ");
INSERT INTO kiz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nuru jing'ara mu ngisi, wala ngisi jhajhisimisi lepi. ");
INSERT INTO kiz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pajhe ni munu jha atumibhu kuh'omela kwa K'yara, ambajhe lihina lya muene akutibhweghe Yohana. ");
INSERT INTO kiz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ahidili kama shahidi kushuhudila kuhusu nuru jhela, ili kwamba bhoha bhabhwesiajhi kuamini kup'etela muene. ");
INSERT INTO kiz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana ajhelepi nuru jhela, bali ahidili kushuhudila kuhusu nuru jhela. ");
INSERT INTO kiz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ejhu jhajhele nuru jha bhukweli ambajho jhajhele jhihida ku dunia najhu jhikampela nuru kila mmonga ");
INSERT INTO kiz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ajhele ku dunia ni dunia jhabhombiki kup'etela muene, ni dunia jhammanyi lepi. ");
INSERT INTO kiz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ahidili kwa fenu fya muene, nibharui bha muene bhabelikumpokela. ");
INSERT INTO kiz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bali kwa bhala bhingi bhabhampokili, ambabho bhaliamini lihina lya muene, kwa abhu abhapelili haki jha kujha bhana bha K'yara, ");
INSERT INTO kiz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ambabho bhahogoliki, sio kwa damu, wala kwa mapenzi gha mb'ele, wala kwa mapenzi gha munu, bali kwa K'yara muene. ");
INSERT INTO kiz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nu muene Lilobhi abhombiki mb'ele ni kutama miongoni mwa tete, tubhubhwene bhutukufu bhwa muene, bhutukufu kama bhwamunu muene ghwa pasima ahidili kuh'omela kwa dadi, amemili neema ni kweli. ");
INSERT INTO kiz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana ashuhudili kuhusu muene, na akwesili sauti ajobhili, “Ojho ndo jha najobhili habari sya muene najobhili, “Jhola jhaibetakuhida badala jha nene ndo mbaha kuliko nene, kwa ndabha ajhele kabla jha nene.” ");
INSERT INTO kiz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa kujha kuh'omela mu bhutimilifu bhwa muene, tete twebhoha tupokili mebhu kipawa baada jha kipawa. ");
INSERT INTO kiz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwa kujha sheria jhaletibhu kup'etela Musa. Neema ni kweli fyahidili kup'etela Yesu kristu. ");
INSERT INTO kiz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ajhelepi mwanadamu jhaambwene K'yara wakati bhuoha. Munu muene ambajhe ndo K'yara, jhaajhele pa kifua kya dadi, ambombili muene amanyikanayi. ");
INSERT INTO kiz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na obhu ndo bhushuhuda bhwa Yohana wakati makuhani ni walawi bhabhatumibhu kwa muene ni bhayahudi kun'kota, “Bhebhe wa niani?” ");
INSERT INTO kiz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bila kusitasita na abelilepi, bali ajibili, “Nene na Kristu lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hivyo bhakan'kota, “henu bhebhe ghweniani?” Bhebhe ndo Eliya? Akajobha, “Nene lepi.” Bhakajobha bhebhe wa niani wa nabii? Ajibili,” Lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kisha bhakan'jobhela, “Bhebhe wa niani, ili tubhapelayi lijibu bhabhatutumili”? Ukishuhudilayi wajhobhi?” ");
INSERT INTO kiz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Akajobha, “Nene na sauti jha muene jha ajhe nyikani: 'Mujhinyosiajhi njela jha Bwana,' kama nabii Isaya kyaajobhili.” ");
INSERT INTO kiz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Basi kwajhele ni bhanu bha bhatumibhu pala kuhoma kwa Mafarisayo. Bhakan'kota ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Kwa ndabha jha kiki wibatisya basi kama bhebhe sio Kristu wala Eliya wala nabii?” ");
INSERT INTO kiz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana abhajibili akajobha, “Nibatisya kwa masi. Hata efyo, miongoni mwa muenga ijhema munu jhamummanyilepi. ");
INSERT INTO kiz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ojho ndo jha ihida baada jha nene. Nene nilondeka lepi ata kuhobhosya mighojhi jha filatu fya muene.” ");
INSERT INTO kiz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mambo agha ghabhombiki okhu Bethania, kwiselya ku Yordani, mahali ambapo Yohana ajhele ibatisya. ");
INSERT INTO kiz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ligono lyalafwatili Yohana ambwene Yesu ihida kwa muene akajobha, “Langayi mwanakondoo ghwa K'yara jhaibetakujhitola dhambi jha bhulimwengu! ");
INSERT INTO kiz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ojho ndo jhanijobheghe habari sya muene, nikajobhili, “Muene jhaibetakuhida kunyuma jha nene ndo mbaha kuliko nene, kwa kujha ajhele kabla jha nene.' ");
INSERT INTO kiz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nikammanyilepi muene, lakini jhabhombiki naha ili kwamba afumulibhwayi ku Israeli, kujha nahidili kubatisya kwa masi.” ");
INSERT INTO kiz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana ashuhudili, “Nabhwene Roho iselela kuh'oma kumbinguni mfuano ghwa hua, najhabakili kunani kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nene nammanyilepi lakini muene jhaanitumili ili nibatisiajhi kwa masi anijobhili, 'jhola ambajhe ibetakubhona Roho iselela ni kutama panani pa muene, Ojho ndo ibetakubatisya kwa Roho Mtakatifu.' ");
INSERT INTO kiz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nibhuene na nishuhudili kujha ojho ndo Mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kabhele ligono lya lafwatili Yohana ajhemili pamonga ni bhanafunzi bhamuene bhabhele, ");
INSERT INTO kiz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bhambwene Yesu igenda ni Yohana akajobha, “Langayi, Mwana kondoo ghwa K'yara!” ");
INSERT INTO kiz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bhanafunzi bhabhele bhampeliki Yohana ijobha haya bhakan'kesya Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kabhele Yesu ageuki ni kubhabhona bhanafunzi bhala bhabhele bhakan'kesya, na akabhajobhela, “Mwilonda kiki?” Bhakajibu, “Rabbi, (maana jhiake 'mwalimu,' witama ndaku?” ");
INSERT INTO kiz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Akabhajobhela, “Muhidayi na mulotayi.”Kisha bhakalota ni kulola mahali pa atameghe; bhatamili pamonga naku ligono elu kwakujha jha jhele kama saa kumi ivi. ");
INSERT INTO kiz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mmonga kati jha bhala bhabhele bhabhamp'eliki Yohana ilongela na kisha kun'kesya Yesu ajhele Andrea, ndongomunu Simoni Petro. ");
INSERT INTO kiz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ambwene ndongomunu Simoni ni kun'jobhela, “Tun'kabhili masihi” (ambajho jhitafsiribhwa Kristu). ");
INSERT INTO kiz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andetili kwa Yesu. Yesu akandanga ni kujobha, “Bhebhe ndo Simoni mwana ghwa Yohana” wibetakutibhwa kefa,” (maana jhiake 'Petro'). ");
INSERT INTO kiz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ligono lya lyafwatili wakati abhokili kulota Galilaya, an'kabhili Filipo ni kun'jobhela, “Nik'esiajhi nene.” ");
INSERT INTO kiz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo ajhele mwenyeji wa Bethsaida, mji wa Andrea ni Petro. ");
INSERT INTO kiz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo an'kabhili Nathanaeli ni kun'jobhela, Tun'kabhili jhola ambajhe Musa abhwesiti kulamba habari sya muene mun sheria sya manabii. Yesu mwana ghwa Yusufu, kuh'omela ku Nazareti. ");
INSERT INTO kiz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanaeli akan'jobhela, “Je khenu kinofu kibhwesya kuh'omela Nazareti?” Filipo akan'jobhela, Hidayi na ulolayi.” ");
INSERT INTO kiz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu akambona Nathanaeli ihida kwa muene ni kujobha, “Langayi, Mwisraeli kweli kweli jhaabelikujha ni udesi mugati mwa muene!” ");
INSERT INTO kiz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanaeli akan'jobhela, “Unimanyibhuili nene?” Yesu akan'jibu ni kun'jobhela, “Kabla Filipo akukutilepi bho ujhele pasi pa mtini, nikakubhwene.” ");
INSERT INTO kiz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanaeli akajibu, “Rabi bhebhe u Mwana ghwa K'yara! Bhebhe ndo Mfalme ghwa Israeli”! ");
INSERT INTO kiz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu akan'jibu akan'jobhela, Kwa ndabha nikujobhili nikakubhwene pasi pa libehe lya mtini' je ghwiamini? wibetakulola matendo mabhaha kuliko agha.” ");
INSERT INTO kiz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu akajobha, “Muaminiajhi muaminiajhi nikabhajobhela mwibetakusibhona malaika bhikwela ni kuselela panani pa Mwana ghwa Adamu.” ");
INSERT INTO kiz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baada jha magono madatu, kwajhele ni ndobho okhu kana jha Galilaya ni nyinamunu Yesu ajhele okhu. ");
INSERT INTO kiz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ni bhanafunzi bha muene bhaalikibhu okhu ku ndobho. ");
INSERT INTO kiz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wakati bhamalikibhu divai, nyinamunu Yesu akan'jobhela, “Bhajhelepi ni divai.” ");
INSERT INTO kiz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ajibili,” N'dala ej'hu jhikanihusu kiki nene? muda ghwa nene bado bhutimili lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nyinamunu akabhajebhela bhatumishi, “Kyokyote kyaibeta kubhajobhela mubhombayi.” ");
INSERT INTO kiz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Basi kwajhele ni mitungi sita jha maganga pala jhajhabhekibhu kwa ndabha jha kusamba mu sikukuu sya bhayahudi khila limonga lyajhele ni bhujazo bhwa nzio mbili tatu. ");
INSERT INTO kiz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu akabhajobhela, “Mumemesiayi masi mitungi ghya maganga.” Bhakamemesya hadi panani. ");
INSERT INTO kiz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kisha akabhajobhela bhala bhatumishi, “Mulotayi kiasi henu na mupelekayi kwa muhudumu mbaha ghwa meza.” Bhakabhomba kama kyabhalaghisibhu. ");
INSERT INTO kiz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mhudumu mbaha akaghabhonja ghala masi ghaghajhele ghabadiliki ni kujha divai, ila amanyilepi kwa ghahomili (ila bhatumishi bhabhaneghili masi bhamanyili kwa ghah'omili). Kisha akan'kuta bwana harusi ni ");
INSERT INTO kiz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kun'jobhela, “Khila mmonga iganda kubhahudumila bhanu divai jhinofu na bhakagalayi bhakabhapela divai jhajhibeli kujha yinofu. Lakini bhebhe uitunzili divai yinofu hadi henu” ");
INSERT INTO kiz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Muujiza obho bhwa Kana jha Galilaya, bhujhele ndo mwanzo bhwa ishara sya miujiza jhaajhibhombili Yesu, bhoifunula utukufu bhwa muene, naha ndo bhanafunzi bha muene bhakamwamini. ");
INSERT INTO kiz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baada jha e'le, Yesu, nyinamunu, bhalongomunu ni bhanafunzi bha muene bhakalota mu mji wa Kapernaum na bhakatama okhu kwa magono madusu. ");
INSERT INTO kiz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Basi pasaka jha bhayahudi jhakaribili himo Yesu akalota Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akabhakolela bhahemelesiji bha ng'ombi, kondoo, ninjebha mugati mu hekalu. pia ni bhabadilisha hata bhaj'hele bhatamili mugati muhekalu. ");
INSERT INTO kiz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu akatengeneza mjeledi wenye vifundo, akawatoa wote walikuwemo katika hekalu. Akajhitisya hela sya bhabadilisha hela ni kup'endula meza sya bhene. ");
INSERT INTO kiz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kwa bhahemesiayi bha njebha akabhajobhela, “Mubhosiayi fenu ehe patali ni mahali apa, mulekayi kujhibheka nyumba jha dadi jhangu kujha mahali pa soko. ");
INSERT INTO kiz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bhanafunzi bha muene bhakakhombuka kujha jhalembibhu, “Bhwifu bhwa nyumba jha bhebhe ghwibetakunilya.” ");
INSERT INTO kiz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bhabhaha bha Kiyahudi bhakajibu, bhakan'jobhela, Ishara jheleku ghwibeta kujhilasya kwa ndabha ghwibhomba mambo agha?” ");
INSERT INTO kiz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akabhajibu, mulibomolayi lihekalu e'le nani nibetakulijenga baada jha magono madatu.” ");
INSERT INTO kiz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kisha bhabhaha bha Bhayahudi bhakajobha, “Jha gharimu miaka arobaini na sita kulijenga hekalu e'le ni bhebhe ghwijobha wibetakulijenga kwa magono madatu?” ");
INSERT INTO kiz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ingawa, muene alongili hekalu kumaanisya mb'ele ghwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hivyo baadaye baada jha kufufuka kwa muene kuhomela kwa bhafu, bhanafunzi bha muene bhakakhomboka kujha ajobhili naha, bhakaghaamini maandiku ni kauli ejhe ambayo Yesu amalikujobha. ");
INSERT INTO kiz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Basi bhoajhele Yerusalemu wakati wa Pasaka, wakati wa sikukuu bhanu bhingi bhaamini lihina lya muene, bhobhabhuene ishara jha miujiza jhaajhibhombili. ");
INSERT INTO kiz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu ajhelepi ni imani nabhu kwa ndabha abhamanyili bhanadamu bhoha. ");
INSERT INTO kiz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Alondelepi munu jhejhioha kun'jobhela kya bhajhele bhanadamu kwa ndabha amanyili kyakijhele mugati mwa bhene. ");
INSERT INTO kiz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Basi kwajhele ni Farisayo ambajhe lihina lya muene Nikodemo, mmonga wa bhajumbe wa baraza lya bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Munu ojho andotili Bwana Yesu pakilu ni kun'jobhela, “Rabi, tumanyili kujha bhebhe mwalimu kuh'omela kwa K'yara, kwa maana ajhelepi munu jha ibhwesya kubhomba ishara ese syoha sya K'yara isipokujha pamonga ni bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ajibili, “Aminiayi, aminiayi, munu ibhwesyalepi kujhingila mu bhufalme bhwa k'yara kama ahogiliki lepi mara jha pili.” ");
INSERT INTO kiz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo akajobha,” Munu ibhwesya bhuli kuh'ogoleka akajhelayi nseya? Ibhwesya lepi kujhingila mu lileme mwa nyinamunu mara ya pili ni kuhogoleka, je ibhwesya?” ");
INSERT INTO kiz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ajibili, “Aminiayi, aminiayi munu kama ahogoliki lepi kwa masi ni kwa Roho, ibhwesya lepi kujhingila mu bhufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kyakihogoliki ni mb'ele ni mb'ele, na kyakihogoliki kwa Roho ni roho. ");
INSERT INTO kiz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usishangali kwa ndabha nakujobhili, 'ni lazima kuh'ogoleka mara jha pili.' ");
INSERT INTO kiz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mp'ongo ghwibhuma popoha pa wilonda ni sauti jhiake mukajhipeleka, lakini mumanyilepi kwa wihoma wala kwa wilota. Ndivyo kyajhijhele hali jha kila jhaahogoliki ni roho. ");
INSERT INTO kiz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ajibili, kwa kujobha, “Mambo agha ghibhwessekana bhuli?” ");
INSERT INTO kiz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akan'jibu, “Bhebhe ghwa mwalimu wa Israeli, hata ughamanyi lepi mambo agha? ");
INSERT INTO kiz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aminiayi, aminiayi, nikujobhela khela kyatukimanyili tukakishuhudila kwa khela kya tukibhuene. Lakini mwipokela lepi bhushuda bhwa tete. ");
INSERT INTO kiz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kama nibhajobhili mambo agha apa pa duniani na mwiamini lepi, mubetakuamini bhuli nikabhajobhilayi mambo gha kumbinguni? ");
INSERT INTO kiz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maana ajhelepi jha akwelili kunani kuhomela kumbinguni isipokujha muene jhaaselili, Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kama vile Musa kya ajhinuili liyoka jangwani, mebhu ni Mwana ghwa Adamu lazima ajhinulibhwayi, ");
INSERT INTO kiz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili kwamba bhoha bhabhibetakumwamini bhakabhayi uzima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwa maana jinsi ejhe K'yara abhuganili bhulimwengu, kwamba akambosya mwanamunu ghwa pekee, ili kwamba munu yeyioha jhaakamwamini asijhangamili bali ajhelayi ni uzima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwa ndabha K'yara antumilepi mwanamunu pa dunia ili kubhuhukumu ulimwengu, bali ulimwengu uokolibhwayi kup'etela muene. ");
INSERT INTO kiz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jhaibetakumwamini muene ibetalepi kuhukumulibhwa. Bhebhe jhaiamini lepi tayari amalikuhukumulibhwa kwa ndabha abelikuliamini lihina lya Mwana pekee ghwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ejhe ndo sababu jha hukumu, jha kujha nuru ihidili ulimwengu, lakini bhanadamu bhaganili ngisi zaidi jha nuru kwandabha matendo gha bhene ghajhe maovu. ");
INSERT INTO kiz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","kila munu jhaibhomba mabhibhi akayidadila nuru wala ihidalepi mu nuru ili matendo gha muene ghasihidi kubhakibhwa wazi. ");
INSERT INTO kiz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini, muene jha ibhomba kweli ihida mu nuru ili matendo gha muene ghabhonekanayi kujha ghabhombibhu kwa utiifu bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baada jha agha, Yesu pamonga ni bhanafunzi bha muene bhakalota mpaka nchi ya Yudea. Okhu atumili muda pamonga nabhu na abatisieghe. ");
INSERT INTO kiz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Henu Yohana pia ajhele ibatisya okhu Ainea karibu ni Salim maana kwajhele ni masi mingi pala. Bhanu bhakajha bhihida kwa muene ni kubatisibhwa, ");
INSERT INTO kiz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","kwa kujha Yohana ajheasopibhulepi mu ligereza. ");
INSERT INTO kiz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kisha ghatokili mabishano kati jha bhanafunzi bha Yohana ni Myahudi kuhusu sikukuu sya utakaso. ");
INSERT INTO kiz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bhakalota kwa Yohana bhakan'jobhela, “Rabi, muene jhaukajhenaku kwiselya ya kiholo Yorodani, muene ghwashuhudili habari sya muene, langayi, ibatisya ni bhoha bhilota bhakan'kesya.” ");
INSERT INTO kiz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana ajibili munu ibhwesyalepi kupokela khenu kyokyoha isipokujha kama apelibhu kuh'omela kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwejhomu mwishuhudila kujha najobhili kujha, 'nene na Kristu lepi', badala jhiake najobhili, 'nitumibhu mbele jha muene.' ");
INSERT INTO kiz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Muene jha ajhe ni bibi arusi ndo bwana arusi. Henu rafiki wa bwana arusi, jhaijhema ni kup'elekesya ifurahibhwa sana kwa ndabha jha sauti jha bwana arusi. Ejhe henu ndo furaha jha nene jha jhitimiliki. ");
INSERT INTO kiz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ilondeka kuzidi, nani nilondeka kup'ongola. ");
INSERT INTO kiz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Muene jha ihoma kunani, ajhele panani pa fyoha. Muene jha ajhele ghwa ulimwengu ihomela kuulimwengu na ilongela mambo gha kiulimwengu. Muene jha ihomela kumbinguni ajhele panani pa ghoha. ");
INSERT INTO kiz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Muene ishuhudila ghala ghaaghabhwene ni kughap'eleka, lakini ajhelepi jhaipokela ushuhuda bhwa mwene. ");
INSERT INTO kiz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Muene jha apokili ushuhuda bhwa muene ahakikishi kujha K'yara ndo mkweli. ");
INSERT INTO kiz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kwa ndabha muene jhaatumibhu ni K'yara ilongela malobhi gha K'yara. kwa kujha akampela lepi Roho kwa kip'emu. ");
INSERT INTO kiz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba akan'gana Mwana na ampelili fenu fyoha mu mabhoko gha muene. ");
INSERT INTO kiz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muene jha akamwamini Mwana ajhenabhu uzima bhwa milele, lakini kwa muene jha abelikun'tii ibetalepi kubhubhona bhuzima, bali ghadhabu jha K'yara jhikamulana panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Basi Yesu bho amanyili kujha Mafarisayo bhap'eliki kujha Yesu ajhele ni bhafuasi ni kubhabatisya zaidi jha Yohana, ");
INSERT INTO kiz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ingabhwa Yesu muene abatisighe lepi bali bhanafunzi bha muene), ");
INSERT INTO kiz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","abhoki Yudea ni kulota Galilaya. ");
INSERT INTO kiz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hivyo jhajhele muhimu kup'etela Samaria. ");
INSERT INTO kiz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni kufika ku mji ghwa Samaria, ghwaghwikutibhwa Sikari, karibu ni lieneo ambalyo Yakobo ampelili mwanamunu Yusufu. ");
INSERT INTO kiz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ni kisima kya Yakobo kyajhele apu. Yesu ajhele atondili kwa ndabha jha safuari ni kutama karibu ni kisima. Ghwajhele muda ghwa pamusi. ");
INSERT INTO kiz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","N'dala n'samaria ahidili kunegha masi, ni Yesu akan'jobhela, “Nipelayi masi ninyuayi.” ");
INSERT INTO kiz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kwa ndabha bhanafunzi bha muene bhalotili kumjini kuh'emela kya kulya. ");
INSERT INTO kiz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","N'dala y'ola akan'jobhela, “Jhijhabhuli bhebhe Myahudi, kunisoma nene masi n'dala N'samaria, khenu kya kunywa?” Kwandabha Bhayahudi bhichangamana lepi ni Bhasamaria. ");
INSERT INTO kiz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akan'jibu, “Kama ngaumanyi karama jha K'yara, ni jhola jhaikujobhela 'Nipelayi masi,' ngaun'somili, na ngaakupelili masi gha uzima.” ");
INSERT INTO kiz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","N'dala akajibu, “Bwana ujhelepi ni lidoo lya kuneghela, ni kisima kitali. Ghwibeta kughakabha ndaku masi gha uzima? ");
INSERT INTO kiz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Je bhebhe ndo mbaha, kuliko dadi jhitu Yakobo, ambajhe atupelili kisima ekhe ni muene ni bhanamunu pamonga ni mifugo ghya muene kunywa masi gha kisima ekhe?” ");
INSERT INTO kiz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akajibu, “Jhejhioha jha ibetakunywa masi agha ibetakukabha kiu kabhele, ");
INSERT INTO kiz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lakini muene jha nibetakumpela nene masi anyuayi ibetalepi kukabha kiu kabhele. Badala yiake masi gha nibetakumpela ghibetakujha chemichemi jhajhibubujika hata milele.” ");
INSERT INTO kiz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","N'dala jhola akan'jobhela, “Bwana, nikaghas'oma masi aghu ili nisikabhi kiu kabhele, na nisihangaiki kuhida apa kunenga masi.” ");
INSERT INTO kiz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu akan'jobhela, “Lotayi kan'kutayi n'gosibhu, kisha kerebhutayi.” ");
INSERT INTO kiz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","N'dala akan'jobhela, “Nijhelepi ni n'gosi.” Yesu akajibu, “Ujobhili kinofu, 'Nijhelepi n'gosi;' ");
INSERT INTO kiz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kwa maana ujhele ni bhagosi bhahanu, ni mmonga ambajhe ujhe naku henu n'gosibhu lepi. Kwa e'le ujobhi bhukweli!” ");
INSERT INTO kiz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","N'dala akan'jobhela, “Bwana nibhona kujha bhebhe ndo nabii. ");
INSERT INTO kiz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bha dadijhitu bhaabuduili pa kid'onda ekhe. Lakini muenga mwijobha kujha Yerusalemu ndiyo sehemu ambajho bhanu bhilondeka kuabudu.” ");
INSERT INTO kiz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu akan'jibu, “N'dala, niaminiayi, wakati wihida ambapo mwibetalepi kumwabudu dadi pa kid'onda ekhe au Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Muenga bhanu mwiabudu khila kyamukimanyi lepi, lakini tete twiabudu kyatukimanyili, kwa ndabha bhwokovu bhwihoma kwa bhayahudi.” ");
INSERT INTO kiz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hata ivyo, wakati ihida, na henu ujhele apa, wakati bhabhiabudu kweli bhibeta kumwabudu Dadi mu roho ni kweli, kwa ndabha Dadi akabhalonda bhanu bha namna ejhu kujha bhanu bha muene bhabhikamwabudu. ");
INSERT INTO kiz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","K'yara ndo roho, ni bhala bhobhakamwabudu bhilondeka kumwabudu kwa roho ni kweli.” ");
INSERT INTO kiz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","N'dala akan'jobhela, “Nimanyili kujha Masihi ihida, (jhaikutibhwa Kristu). Ojhu pa ibetakuhida ibetakutujobhela ghoha.” ");
INSERT INTO kiz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu akan'jobhela, “Nene jhaghwijobha nani ndo nene.” ");
INSERT INTO kiz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wakati bhobhuobhu bhanafunzi bha muene bhakakerebhuka. Ni bhene bhakasyangala kwa ndabha jhakiki alongeleghe ni n'dala, lakini ajhelepi jhaathubutu ili kun'kota, “Ghwilonda kiki?” au “Kwa ndabha jhakiki ghwilonda nakhu?” ");
INSERT INTO kiz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Naha n'dala akabhuleka pala kibhegha kya masi ni kulota kumjini ni kubhajobhela bhanu, ");
INSERT INTO kiz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Muhidayi mundangayi munu jha anijobhili mambo gha nene ghoha ghanighabhombili, je jhibhwesekana kujha ndo Kristu?” ");
INSERT INTO kiz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bhakabhoka ku mjini bhakahida kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wakati ghwa pamusi bhanafunzi bha muene bhakan'sihi bhakajobha, “Rabi lyajhi kyakulya.” ");
INSERT INTO kiz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","lakini muene abhajobhili, “Nene ni jhele ni kyakulya kya mukimanyilepi muenga.” ");
INSERT INTO kiz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bhanafunzi bhakajobhesana, ajhelepi munu jha andetili khenu kyokyoha kulya, “Je bhalatili?” ");
INSERT INTO kiz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu akabhajobhela, “Kyakulya kya nene ndo kubhomba mapenzi gha muene jha anitumili ni kutimisya mbombo jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Je, mwijobhalepi, 'Jhakhona miesi mihanu ni mavuno ghibetakujha tayari?' Nikabhajobhela mulangayi mig'onda kyaghijha tayari kwa mavuno! ");
INSERT INTO kiz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muene jhaivuna ipokela mishahara ni kukusanya matunda kwa ndabha jha bhusima bhwa milele, ili kwamba muene jha ipanda ni jha ivuna bhahobhelelayi pamonga. ");
INSERT INTO kiz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa kujha msemo obho ni wa bhukweli, 'Mmonga ipanda ni jhongi ivuna.' ");
INSERT INTO kiz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nikabhatumili kuvuna ambakyo mkakihangaikili lepi, bhangi bhabhombili mbombo ni muenga mujhingili mu furaha jha kazi jha bhene.” ");
INSERT INTO kiz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bhasamaria bhingi mu mji bhola bha mwamini kwa ndabha jha taarifa jha n'dala jhola jhaashuhudili, “Jhaanijobhili mambo ghoha ghanighabhombili.” ");
INSERT INTO kiz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hivyo bhasamaria bho bhahidili bhan'sokili atamayi naku na atamili kwa bhene kwa magono mabhele. ");
INSERT INTO kiz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ni bhingi zaidi bhakajhanda kumwamini kwa ndabha jha lilobhi lya muene. ");
INSERT INTO kiz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","bhakan'jobhela muene n'dala, “Tunaamini sio tu kwa maneno yak0o, kwa ndabha twebhene tup'eliki, ni henu tumanyili kujha hakika muene ndo mwokozi ghwa bhulimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Baada jha magono aghu mabhele, akabhoka ni kulota Galilaya. ");
INSERT INTO kiz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwandabha muene atangasili kujha nabii ajhelepi ni heshima mu hali jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bho ahidili kuh'oma Galilaya, Bhagalilaya bhakan'karibisya. Bhabhuene mambo ghoha gha aghabhombili Yerusalemu ku sikukuu, kwa ndabha ni bhene pia bhahuzulili ku sikukuu. ");
INSERT INTO kiz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ahidili kabhele Kana jha Galilaya okhu aghabadilisi masi kujha divai. Pajhele ni ofisa ambajhe mwana munu ajhele n'tamu okhu Kapernaumu. ");
INSERT INTO kiz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bho ap'eliki Yesu ah'omili Yudea ni kulota Galilaya, akalota kwa Yesu ni kun'sihi aselelayi amponesi mwanamunu, ambajhe ajhele karibu kufwa. ");
INSERT INTO kiz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ndipo Yesu akan'jobhela, “Muenga mukabelayi kubhona ishara ni maajabu mwibhwesya lepi kuamini. ");
INSERT INTO kiz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nndongosi akajobha, “Bwana selelayi pasi kabla mwanabhangu kufwa.” ");
INSERT INTO kiz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akan'jobhela, “Lotayi mwanabhu mzima.” Munu jhola akaamini lilobhi lyaalijobhili Yesu ni kwilotela. ");
INSERT INTO kiz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bho iselela, bhatumishi bha muene bhakampokelela ni kun'jobhela mwanamunu ajhe n'sima. ");
INSERT INTO kiz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hivyo akabhakhota ndo mda bholoki ghwa kabhili nafuu. Bhakajibu, “Golo muda ghwa saa saba homa jhagudeme.” ");
INSERT INTO kiz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ndipo dadimunu akamanya kujha ndo muda bholabhola Yesu pa ajobhili, “Mwana ghwa jhobhi ndo n'sima.” Hivyo muene ni familia jha muene bhakaamini. ");
INSERT INTO kiz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ejhe jhajhele ndo ishara jha bhubhele jhaajhibhombili Yesu bhoahomili Yudea kul'ota Galilaya. ");
INSERT INTO kiz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baada jha apu kwajhele ni sikukuu jha bhajhahudi, ni Yesu akwelili kul'ota Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ni khola Yerusalemu pajhele ni bikira pa ndiangu ghwa ling'osi, lyalyajhele likutibhwa kwa lugha jha Kiebrania Bethzatha, ni liene lijhele ni matao mahanu. ");
INSERT INTO kiz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Idadi mbaha jha bhatamu jhajhele, fipofu, fiwete, au bhabhapozili bhajhele bhagonili mu matao aghu. {Zingatilayi: Malobhi gha n'sitari ghwa 3 ghibhonekana lepi mu nakala sinofu sya muandi. “Bhilend'ela masi kutibulibhwa.) Kwa hakika bhwakati fulani malaika asilili mugati mwa Bwana ni kughatibula masi. ");
INSERT INTO kiz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Henu, jhola ambajhe ajhele ghwa kuanza kujhingila mugati mu masi baada jha masi kutibulibhwa abhomboki mzima kufwatana ni kyokyoha kyakikajhele kunkamuili kwa bhwakati obhu. ");
INSERT INTO kiz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na munu mmonga jhaalwalili kwa muda ghwa miaka thelathini na nne ajhele mugati mu matao. ");
INSERT INTO kiz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu bho ambwene agonili mugati mu matao ni baada jha kutambula kujha agonili pala kwa muda mrefu Yesu an'jobhili, “Je ghwilonda kujha nsima?” ");
INSERT INTO kiz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","N'tamu jhola akan'jibu, “Bwana njedumu ni munu, ghwa kunibheka mu birika bhwakati masi paghitibulibhwa. Bhwakati panilonda kujhingila munu jhongi akanilongolela.” ");
INSERT INTO kiz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu akan'jobhela, “Jhemayi na ulotayi ligodoro lya jhobhi na ulotayi.” ");
INSERT INTO kiz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mara munu jhola akaponesibhwa, akalota kitanda kya muene akabhoka. Na ligono elu lyajhele ligono lya Sabato. ");
INSERT INTO kiz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hivyo Bhayahudi bhakan'jobhela munu jhola jha aponisibhu, “Lelu ligono lya Sabato, na ghwiruhusibhwa lepi kup'enda ligodoro lya bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akajibu, muene jhaaniponyisi ndo anijobhili, “Tolayi ligodoro lya jhobhi na ulotayi.” ");
INSERT INTO kiz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bhakakota, “Niani jha akujobhili 'Tolayi ligodoro lya jhobhi na ulotayi?”' ");
INSERT INTO kiz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ingawa, jhola jha aponyisibhu amanyilepi kwa ndabha Yesu ajhele amali kubhoka kwa siri. Kwa kujha kwajhele ni bhanu bhingi pa sehemu jhela. ");
INSERT INTO kiz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Baada jha apu Yesu ankolili munu jhola mu lihekalu ni kun'jobhela, “Langayi, uponili! “Usibhombi dhambi kabhele usihidi ukakabha ni lijambo libaya nesu.” ");
INSERT INTO kiz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Munu jhola akabhoka ni kubhataarifu Bhayahudi kujha Yesu ndo aniponyisi. ");
INSERT INTO kiz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Henu kwa ndabha jha mambo agha Bhayahudi bhan'tesisi Yesu, kwa ndabha abhombili mambo agha ligono lya Sabato. ");
INSERT INTO kiz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu akabhajobhela, “Dadi jhangu ibhomba mbombo hata henu nani nibhomba mbombo.” ");
INSERT INTO kiz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa ndabha ejhu Bhajhahudi bhakaseniye kundonda ili bhan'komayi sio tu kwa ndabha jha kuidenya Sabato, bali kwa kun'kuta K'yara Dadi munu, ikifwanya kujha sawa ni K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu akabhajibu, “Muaminiayi, muaminiayi, Muana ibhwesyalepi kubhomba kyokyoha isipokujha khela ambakyo ni Mwana kyaibetakubhomba. ");
INSERT INTO kiz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwa kujha Dadi an'ganili Muana, ni kundasya khila khenu kyaibhomba na ibetakundasya mambo mabhaha kuliko agha ili kwamba mujhongesiayi kusyangala.” ");
INSERT INTO kiz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kwa kujha kama fela ambafyo Dadi kyaikabhafufula bhafu ni kubhapela bhusima, kabhele Muana ni muene akampela jhejhioha jha an'ganili. ");
INSERT INTO kiz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kwa kujha dadi akan'hukumulepi jhejhioha, bali ampelili Mwana hukumu jhioha ili ");
INSERT INTO kiz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kwamba bhoha bhamuheshimuayi Mwana kama vile Mwana kyaakan'heshimu Dadi. Muenga jhaikan'heshimu lepi Muana akan'heshimu lepi Dadi jha an'tumili. ");
INSERT INTO kiz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Aminiajhi, aminiajhi, jhaipeleka lilobhi lyangu ni kumwamini muene jhaanitumili ajhe nabhu bhusima bhwa milele na ibetalepi kuhukumibhwa. Badala jhiake, apetili kuh'omela mautini ni kujhingila mu bhuzima. ");
INSERT INTO kiz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aminiayi, aminiayi, nikabhajobhela bhwakati bhwihida na henu ujhele ambabho bhafu bhibeta kup'eleka sauti jha Muana ghwa K'yara, ni bhoha bhabhibetakup'el'eka bhibetakuishi. ");
INSERT INTO kiz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kwa kujha kama vile Dadi kyaajhele ni bhusima mugati mwa muene, ");
INSERT INTO kiz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kabhele ampelili Muana kujha ni bhusima mugati mwa muene, ni Dadi ampelili Muana mamlaka ili kwamba ahukumuayi kwa kujha ndo Mwana ghwa Adamu. ");
INSERT INTO kiz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Musisyangesibhu ni e'le, kwa kujha bhwakati bhwihida ambabho bhafu bhoha bhabhajhele mu makaburi bhibeta kujhip'el'eka sauti jha muene ");
INSERT INTO kiz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na bhene bhibhetakupita kwibhala: kwa bhabhembili manofu kwa bhufufo bhwa bhusima, na bhabhabhombili manofu lepio ku bhufufuo bhwa hukumu. ");
INSERT INTO kiz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nibhwesya lepi kubhomba khenu kyokyoha kuh'oma kwa nene ne muene. Kama kyanip'eleka, ndo kyanihukumu ni hukumu jha nene jha haki kwa kujha nil'ondalepi mapenzi gha nene, bali mapenzi gha muene jhanitumili. ");
INSERT INTO kiz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kama nikibhonili ne muene, bhushuda bhwangu ngabhujhelepi ghwa bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ajhe jhongi jhaishuhudila kuhusu nene na nimanyili kwa hakika bhushuda bhwa ukanishuhudila bhwa bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mutumili kwa Yohana ni muene anishuhudili bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Henu, bhushuhuda bhwa nikabhupokela bhwihomela lepi kwa mwanadamu. Nikaghajobha agha ili mubhwesiayi kuokolibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana ajhele ligesi lya lijhaka ni kulangala, na mwajhele tayari kujhifurahila kwa muda kitambo nuru jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bhushuhuda bhwanijhe nabhu mbaha kuliko bhola bhwa Yohana, kwa mbombo ambasyo Dadi anipelili kusikamilisya mbombo syanibhombo esu ndo sya sushuhudila kujha Dadi anilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dadi jha andaghisi muene an'shuhudili nene. Mubhwayilepi kup'eleka sauti jha muene bhwala kulibhona liumbo lya muene bhwakati bhuoha. ");
INSERT INTO kiz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lijhelepi lilobhi lya muene kutama mugati mwa jhomu kwa kujha mukan'kiera lepi muene jha anilaghisi' ");
INSERT INTO kiz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mkaghalanga majhandiku mwikiera omu bhujhele bhusima bhwa milele, ni majhandiku agha ghishuhudila habari sya nene ni ");
INSERT INTO kiz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mwibeta kuhida kwa nene ili mukabhai bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nijhamb'elela lepi sifa kuh'omela kwa bhanu, ");
INSERT INTO kiz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","lakini nimanyili mujhelepi ni luganu lwa K'yara mugati mwa muenga mwejhomu. ");
INSERT INTO kiz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nihidili kwa lihina lya Dadi jhangu, mwabhesilepi kunijhambelela. Kama jhongi akahidayi kwa lihina lya muene ngamu jhamb'elili. ");
INSERT INTO kiz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Je mwibhwesya bhuli kukiera muenga ambabho mwijhamb'elela sifa kuh'omela kwa kila mmonga ghwa jhomu lakini mwilonda lepi sifa jhajhih'omela kwa K'yara ghwa pasima? ");
INSERT INTO kiz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Musitegemeli nene nibetakubhatakila palongolo pa Dadi. Jhaikabhatakila muenga ndo Musa, ambajhe muenga mubhekhili matumaini ghinu kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kama ngamujha mukan'kiera Musa, ngamunikieriri ni nene kwa ndabha alembili kuhusu habari sya nene. ");
INSERT INTO kiz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kama mwikieralepi majhandiku gha muene, mwibetakubhwesya bhuli kukiera malobhi ghangu? ");
INSERT INTO kiz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Baada jha mambo agha, Yesu akalota pande sya Bahari jha Galilaya, pia jhikutibhwa Bahari jha Tiberia. ");
INSERT INTO kiz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mkutano mbaha bhwajhele bhukan'kesya kwa ndabha bhabhuene ishara syaasibhombili kwa bhajhele bhatamu. ");
INSERT INTO kiz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu akwelili kunena hadi lubhafu kwa kunena ghwa kid'onda ni kutama okhu ni bhanafunzi bha muene ");
INSERT INTO kiz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Ni Pasaka, Sikukuu jha Bhajhahudi jhakaribili). ");
INSERT INTO kiz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu bho ajhinuili mihu gha muene kunani ni kubhona bhumati mbaha bhwihida kwa muene, akan'jobhela Filipo, “Twibetakulota kuhemele mikate ili abha bhabhwesijhi kulya”? ");
INSERT INTO kiz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Lakini Yesu aghajobhili agha kwa Filipo kwa kun'jaribu kwa kujha muene amanyili kyaibetakubhomba). ");
INSERT INTO kiz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo an'jibili, “Hata mikate jha thamani jha dinari mia mbili ngajhitolili lepi hata khila mmonga kukabha hata kipandi kidebe.” ");
INSERT INTO kiz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrea, mmonga ghwa bhanafunzi bha muene ndongomunu Simoni Petro akan'jobhela ");
INSERT INTO kiz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yesu, “Ajhele n'gosi apa ajhe ni mikate mihanu ni somba sibhele, lakini ejhe jhifwanyi kiki kwa bhanu bhingi kama abha?” ");
INSERT INTO kiz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu akabhajobhela, “Mubhatamikiayi bhanu pasi” (kwajhele ni linyasi lingi mahali pala). Efyo bhagosi bhajhele elfu tano bhatamili pasi. ");
INSERT INTO kiz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kisha Yesu akalota mikate jhela mihanu akabhombesya akabhagabhila bhala bhabhajhele bhatamili. Fefuefu akabhagabhila ni somba kadiri kya bhalondeghe. ");
INSERT INTO kiz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bhanu bho bhasibili abhajobhili bhanafunzi bha muene, “Mufibhonganiayi fipandi fya mabaki, fyafisiele ili kwamba kisijhaghi kyokyoha.” ");
INSERT INTO kiz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Basi bhakabhonganiya ni kumemesya fikapu kumi ni fibhele, fipandi fya mikate mihanu jha shayiri- fipandi fya fisiel'ebhu ni bhala bha bhalili. ");
INSERT INTO kiz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kisha bhanu bho bhabhuene ishara ejhe jha ajhibhombili bhakajobha, “Bhukweli ojho ndo nabii jhola jhaibetakuhida ulimwenguni.” ");
INSERT INTO kiz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu bhoamanyili kujha bhalondeghe kun'kamula ili bhambombajhi kujha mfalme ghwa bhene, akitengili, kabhele ni kul'ota kukid'onda muene pasima. ");
INSERT INTO kiz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bhojhingili kimihi, bhanafunzi bha muene bhaselili kul'ota kumanga. ");
INSERT INTO kiz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhakakwela mu bhuatu na bhajhele bhilobhoka kulota Kapernaumu. (Ngisi jhajhingili ni Yesu ajhele bado ahidili lepi kwa bhene). ");
INSERT INTO kiz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bhwakati obhu mp'ongo mbaha bhukajha bhwibhuma, ni bahari jhikajha jhilotakuchafuka. ");
INSERT INTO kiz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kabhele bhanafunzi bha muene bhatobhili ngafi kama ishirini na tano au thelathini, bhakambona Yesu igenda panani pa masi kubhuhidila bhuatu, na bhatilili. ");
INSERT INTO kiz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lakini akabhajobhela, “Nene! Musitili.” ");
INSERT INTO kiz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kabhele bhajhele tayari kump'enda mu bhuatu, ni mara bhuatu bhwafikili kundema kwa bhaloteghe. ");
INSERT INTO kiz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ligono lya lifwatileghe, mkutano bhwajhele bhujhemili lubhafu lwa bahari bhabhwene kujha bhujhelepi bhuatu bhongi isipokujha bhola ambabho Yesu ni bhanafunzi bha muene bhajhele bhaukweli lepi lakini bhanafunzi bha muene bhajhele bhalotili bhene. ");
INSERT INTO kiz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Ingabhwa, kwajhele ni baadhi jha miatu jhajhah'omili Tiberia karibila ni mahali pa bhalili mikate baada jha Bwana kuhomesya shukurani). ");
INSERT INTO kiz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bhwakati makutano bho bhamanyili kujha Yesu lepi bhwala bhanafunzi bha muene bhajhele khola, bhene bha kwelili mu bhuatu bhakal'ota Kapernaumu kun'ndonda Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baada jha kun'kabha lubhafu l'ongi lwa nyanja bhakan'kota, “Rabbi ghwahidili ndali khoni?” ");
INSERT INTO kiz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu abhajibili, akabhajobhela, Muaminiayi, muaminiayi, mkanilonda nene, sio kwandabha mwasibhwene ishara, bali kwa ndabha mwalili mikate ni kusiba. ");
INSERT INTO kiz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mulekayi kukibhombela mbombo kyakulya kya kijonangiki, bali mukibhombelayi mbombo kyakulya kyakisindamala hata milele khela ambakyo Mwana ghwa Adamu ibetakubhapela, kwa kujha K'yara Dadi abhekhili muhuri panani pa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kisha bhakan'jobhela, “Kheleku twilondeka kubhomba ili kusibhomba mbombo sya K'yara?” ");
INSERT INTO kiz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akajibu, “Ejhe ndo kazi jha K' yara: kujha mun'kierajhi muene jha an'tumili.” ");
INSERT INTO kiz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Basi bhakan'jobhela, “Ishara se'lekhu ghwibeta kubhomba, kujha twibhwesya kusibhona ni kukukiera? Ghwibetakubhomba kiki? ");
INSERT INTO kiz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bhadadi jhitu bhalili manna mu lijangwa, kama kyajhalembibhu, “Abhapelili mikate kuh'omela kumbinguni ili bhalyayi.” ");
INSERT INTO kiz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kisha Yesu abhajibili, “Muaminiayi, muaminiayi, Musalepi jha abhapelili n'kate kuh'omela kumbinguni, bali Dadi jhangu ndo jha akabhapela n'kate ghwa bhukweli kuhomela kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwa kujha n'kate ghwa K'yara ndoghola ghwaghwiselela kuh'omela kumbinguni ni kuupela bhusima bhwa milele ulimwenguni. ");
INSERT INTO kiz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Basi bhakan'jobhela, “Bwana tupelayi n'kate obhu wakati bhuoha.” ");
INSERT INTO kiz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu akabhajobhela, “Nene ndo n'kate ghwa uzima, muene jha ihida kwa nene ibetalepi kukabha njala ni muene jhaibetakunikiera ibetalepi kwipeleka kiu kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ingawa nabhajobhili kujha, munibhwene, na bado mwikiera lepi. ");
INSERT INTO kiz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhoha Dadi bhaibetakunipela bhibetakuhida kwa nene, na jhejhioha jhaibetakuhida kwa nene, nibetalepi kun'tagha kwibhala kamwe. ");
INSERT INTO kiz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwa kujha niselili kuhomela kumbinguni, sio kwa ndabha jha kubhomba mapenzi ghangu, bali mapenzi gha anilaghisye. ");
INSERT INTO kiz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na aghu ndo mapenzi gha muene gha jha anilaghisi, kujha nisijhasi hata mmonga ghwa bhala bho anipelili, bali nibetakubhafufula ligono lya mwishu. ");
INSERT INTO kiz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwa kujha aghu ndo mapenzi gha Dadi jhangu, kujha jhejhioha jha ikanganga Muana ni kun'kiera akabhayi uzima bhwa milele; nani nibetakumfufula ligono lya mwishu. ");
INSERT INTO kiz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kisha bhayahudi bhakan'dadila kun'husu muene kwandabha ajobhili, “Nene ndo n'kate ghwa ghuselili kuh'omela kumbinguni.” ");
INSERT INTO kiz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakajobha, “Ojho si ndo Yesu Mwana ghwa Yusufu, ambajhe dadi munu ni nyinamunu tubhamanyili? Ijhebhuli henu ijobha, 'Niselili kuh'omela kumbinguni`?” ");
INSERT INTO kiz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu akabhajibu, akabhajobhela, “Musidadi miongoni mwa jhomu mwibhene. ");
INSERT INTO kiz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ajhelepi munu jha amanyili kwa nene kama abelikufutibhwa ni dadi jhangu jhaanitumili, nani nibetakumfufula ligono lya mwishu. ");
INSERT INTO kiz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kwa kujha jhilembibhu ni manabii, 'Bhibetakumanyisibhwa ni K'yara' Khila jhaap'eliki na akimanyisi kuh'omela kwa Dadi, ihida kwa nene. ");
INSERT INTO kiz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sio kujha ajhe munu jha ambwene Dadi, isipokujha muene jhaihomela kwa K'yara- ambwene Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Muaminiayi, muaminiayi muene jha ikiera ajhenabhu bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nene ndo n'kate ghwa bhusima. ");
INSERT INTO kiz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","bhadadi jhinu bhalili manna mu jangwa, na bhafuili. ");
INSERT INTO kiz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Obho ndo n'kate ghwa ghwiselela kuh'omela kumbinguni, ili kujha munu aliayi sehemu jha muene ili asifwi. ");
INSERT INTO kiz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nene na n'kate ghwa ghwiishi ambabho uselili kuhomela kumbinguni. Kama munu jhejhioha akaliayi sehemu jha n'kate obho ibetakutama milele. Nkate ghwanibetakubhubhosya ndo mb'ele bhwangu kwa ndabha jha bhusima bhwa ulimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bhayahudi bhakadada bhene kwa bhene bhakayanda kubishana bhakajha bhijobha, “Munu ojho ibhwesyabhuli kutup'ela mb'ele ghwa muene tuliayi?” ");
INSERT INTO kiz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kisha Yesu akabhajobhela, “Muaminiayi, muaminiayi pamwitakub'ela kulya mb'ele ghwa Muana ghwa Adamu ni kunywa damu jha muene, mwibetalepi kujha ni bhusima bhwa milele mugati mwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jhejhioha jhaibetakulya mb'ele ghwangu ni kunywa damu jha nene nibetakumfufula ligono lya mwishu. ");
INSERT INTO kiz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwa kujha mb'ele bhwangu ndo kyakulya kya bhukweli, ni damu jha nene ndo kinywaji kya bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Muene jhaibetakulya mb'ele bhwangu ni kunywa damu jha nene ibetakutama mugati mwa nene, nani mugati mwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kama Dadi jha ajhe ni bhusima jha an'tumili, ni kama kyanitama kwa ndabha jha Dadi, ni muene ibetakutama kwa ndabha jha nene. ");
INSERT INTO kiz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Obho ndo n'kate ghwaghuselili kuh'omela kumbinguni, sio kama kyabhalili bhadadi jhinu bhafuili. Muene jhaibetakulya n'kate obho ibetakutama milele. ");
INSERT INTO kiz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu aghajobhili mambo aghu mugati mu sinagogi bho imanyisya okhu Kapernaumu. ");
INSERT INTO kiz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ndipo bhingi bha bhanafunzi bha muene bho bhap'eliki agha, bhakajobha, “Ele lifundisu linonono niani nibetabhwesya kulipokela?” ");
INSERT INTO kiz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kwa ndabha amanyili kujha bhanafunzi bha muene bhakil'ombosieghe kwa ndabha jha lijambo e'le, akabhajobhela, je lijambo e'le libhwesekana? ");
INSERT INTO kiz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Basi jhibetakujhabhuli pamwibeta kumbona Mwana ghwa Adamu iselela kuh'omela kwa ajhele kabla? ");
INSERT INTO kiz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Roho muene ndo jha ihomesya bhusima. Mb'ele ghwifaidi lepi khenu kyokyoha. Malobhi ghanighajobhili kwa muenga ndo roho na ni bhusima. ");
INSERT INTO kiz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bado kuna bhanu kati jha muenga bhabhiamini lepi.” kwa ndabha Yesu amanyili kuh'omela kubhwandelu jhola ambajhe jhaabhwesilepi kuamini ni muene ambajhe ngaan'saliti. ");
INSERT INTO kiz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akabhajobhela, kwa ndabha ejhe nabhajobhili kujha ajhelepi munu jhaibhwesya lepi kuhida kwa nene isipokujha apelibhu ni Dadi.” ");
INSERT INTO kiz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baada jha agha bhanafunzi bha muene bhingi bhakerebhwiki kumbele na bhabelikulongosana naku kabhele. ");
INSERT INTO kiz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu akabhajobhela bhala kumi ni bhabhele, “Je namu mwil'onda kubh'oka?” ");
INSERT INTO kiz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petro akan'jibu, “Bwana tulotayi kwa niani kwani bhebhe ujhe ni malobhi gha bhusima bhwa milele, ");
INSERT INTO kiz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","na tukyeriri ni kumanya kujha bhebhe ndoghwe N'takatifu ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akabhajobhela, “Je nene nabhachaguililepi muenga, ni mmonga bhinu ndo ibilisi? ");
INSERT INTO kiz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Henu akajha ilongela kuhusu Yuda, mwana ghwa Simoni Iskariote, kwa kujha ajhele ni muene akajha mmonga ghwa bhala kumi ni bhabhele, ambajhe ndijhe ngaan'saliti Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ni baada jha mambo agha Yesu asafiri na ku Galialaya kwa ndabha alondelepi kulota Bhuyahudi kwa ndabha bhayahudi bhabhombeghe mipango ghya kun'koma. ");
INSERT INTO kiz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Henu sikukuu jha Bhayahudi, sikukuu jha fibanda, jhajhele karibu. ");
INSERT INTO kiz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ndipo bhalongomunu bhan'jobhili, “Bhokayi mahali apa ulotayi ku Bhuyahudi, ili kwamba bhanafunzi bha jhobhi khelakhela bhaghabhonayi matendo ghaghwifuanya. ");
INSERT INTO kiz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ajhelepi jha ibhomba lyolyoha kwa siri iwapo muene ilonda kumanyikana bhwasi. Iwapo ghwibhomba mambo agha, ghwilasiayi ghwimuene kwa bhalimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata bhalongomunu pia bhakyeli lepi. ");
INSERT INTO kiz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ndipo Yesu akabhajobhela, “Bhwakati ghwa nene bhwakona, lakini wakati ghwa muenga khila mara bhujhe tayari. ");
INSERT INTO kiz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bhulimwengu bhwibhuesya lepi kubhadadila muenga, bali bhukanidadila nene kwa ndabha nikabhushuhudila kwa matendo ghake maovu. ");
INSERT INTO kiz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mukwelayi kulota ku sikukuu; nene nilotalepi ku sikukuu ejhe kwa ndabha muda gha nene bhukamilikilepi bado.” ");
INSERT INTO kiz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Baada jha kujobha mambo aghu kwa bhene, abakili Galilaya. ");
INSERT INTO kiz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hata ivyo bhalongo munu bhalotili ku sikukuu, ndipo ni muene akalota, sio kwa wazi bali kwa siri. ");
INSERT INTO kiz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bhayahudi bhakayabhakandonda ku sikukuu ni kujobha, “Ajhendaku?” ");
INSERT INTO kiz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwajhele ni majadiliano mingi miongoni mwa makutano juu jha muene. Bhangi bhajobhili, “Munu n'nofu.” Bhangi bhakajobha, “Lepi, ikabhakofya makutano.” ");
INSERT INTO kiz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hata ivyo ajhelepi jha ajobhili bhukweli juu jha muene kwa kubhatila Bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wakati sikukuu jhifikili pagati, Yesu akwelili kulota ku lihekalu ni kuyanda kumanyisya. ");
INSERT INTO kiz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bhayahudi bhakaya bhisyangala ni kujobha, “Kibhuli munu ojho amanyili mambo ghamehele? Abhwayilepi kusoma hata.” ");
INSERT INTO kiz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu abhajibhili ni kubhajobhela, “Mafundisu gha nene ghanelepi, bali jha muene jha anilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ikajhelayi jhejhioha jhaibeta kubhomba mapenzi gha muene, ibetakumanya kuhusu mafundisu agha kama ghihomela kwa K'yara, au kama nilongela kuhomela kwa nene ne muene. ");
INSERT INTO kiz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Khila ghailongela ghihoma kwa muene ghilonda utukufu bhwa muene jhaanilaghisi, munu ojhu ghwa bhukweli, ni mugati mwa muene kujhelepi kutokubhomba haki. ");
INSERT INTO kiz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa abhapelili lepi muenga sheria? Lakini ajhelepi hata mmonga kati jha muenga jhaibhomba sheria. Kwa ndabha jhakiki mwilonda kunikoma? ");
INSERT INTO kiz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Makutano bhakajibu, “Ujhe ni pepo. Niani ilonda kukoma?” ");
INSERT INTO kiz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akajibu ni kubhajobhela, “Nikhetili mbombo jhimonga, namu mwebhoka musyangesibhu kwa ndabha jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa abapelili tohara (siyo kwamba jhihoma kwa Musa, bali jhela jhihoma kwa mababa), ni mu Sabato mukan'tahili munu. ");
INSERT INTO kiz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ikajhelayi munu ibetakupokela tohara mu ligono lya Sabato ili kwamba sheria jha Musa isivunjibhu, kwandajhakiki mkanidadila nene kwa ndabha nimponyisi munu ligono lya Sabato? ");
INSERT INTO kiz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Musihukumu kul'engana ni mwonekano, bali muhukumuajhi kwa haki. ");
INSERT INTO kiz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Baadhi jha bhene kuhoma Yerusalemu bhakajobha, “Ojho lepi jha bhikandonda kun'koma? ");
INSERT INTO kiz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na langayi ilongela waziwazi, na bhijobhalepi kyokyoha juu jha muene. Jhibhwesya lepi kujha bhalongosi bhamanyili kueli kujha ojho ndo Kristu, jhibhwesya kujha? ");
INSERT INTO kiz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tumanyili munu ojho ihomela ndaku. Kristu paibeta kuhida, ataivyo. ajhelepi jhaibetakumanya ndaku kwaihomela.” ");
INSERT INTO kiz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu ajhele ikwesya sauti jha muene mu lihekalu ifundisya ni kujobha, “Muenga mwebhoha munimanyili nene na mumanyili kwa nihomela. Nahidilepi kwa nafsi jha nene, bali muene jhaanilaghisi ni ghwa bhukweli, na mumanyilepi muene. ");
INSERT INTO kiz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nimanyili muene kwa ndabha nihomili kwa muene na anilaghisi.” ");
INSERT INTO kiz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bhajaribueghe kun'teemula, lakini ajhelepi hata mmonga jha ajhinuleghe kibhoko kya muene panani pa muene kwa ndandabha jha saa jha muene jhajhele bado jhifikili lepi. ");
INSERT INTO kiz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hata hivyo, bhingi mu makutano bhamwamini. Bhajobhili, “Kristu paibetakuhida, ibetakukheta ishara simehele kuliko sya abhombili munu ojho?” ");
INSERT INTO kiz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarisayo bhapeliki makutano bhinong'onezana mambo agha kuhusu Yesu, ni bhabhaha bha makuhani ni Mafarisayo bhakatuma maafisa ili kunikamula. ");
INSERT INTO kiz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ndipo Yesu pajobhili, “Bado kujha ni muda kitambo ni jha pamonga namu, ni baadaye nibetakulota kwa muene jhaanilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwibeta kunilonda wala mwibeta lepi kunibhona; khola kwanibeta kulota.” ");
INSERT INTO kiz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kwahiyo Bhayahudi bhakajobhesana bhene kwa bhene, “Munu ojho ibetakulota ndaku kwamba tusibhwesi kumbona? Ibetakulota kwa bhabhatawanyiki kati jha Bhayunani ni kubhafundisya Bhayunani? ");
INSERT INTO kiz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Litobhi leleku e'le lyaali jobhili, 'Mwibetakunilonda ni wala mwibetalepi kunibhona; khola kwa nilota mwibetalepi bhuesya kuhida'?” ");
INSERT INTO kiz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Henu ligono lya mwishu, ligono libhaha lya sikukuu, Yesu akajhema akakuesya sauti, akajobha, “Ikajhiajhi jhejhioha ajhe ni kiu, na ahidayi kwa nene anyuajhi. ");
INSERT INTO kiz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muene jha akaniamini nene, kama maandiku kyaghajobhili, kuhoma mugati mwa muene jhibetakutiririka masi gha uzima.” ");
INSERT INTO kiz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lakini aghajibhili agha kuhusu Roho, ambajhe bhene bhakamwamini bhibetakumpokela; Roho ajhe akona kupisibhwa kwa ndabha Yesu ajhe akona kutukusibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Baadhi jha makutano, bho bhap'eliki malobhi agha bhajobhili, “Kweli ojho ndo nabii.” ");
INSERT INTO kiz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bhamana bhajobhili, “Ojho ndo Kristu.” Lakini bhamana bhajobhili, “kiki, Kristu abhwesiajhi kuhoma Galilaya? ");
INSERT INTO kiz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiku ghajobhi lepi kujha Kristu ibeta kuhomela mu lukhoto kwa Daudi ni kuhoma Bethlehemu, kijiji ambakyo Daudi ajhele? ");
INSERT INTO kiz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hivyo pala ghwajhinuiki mgawanijo pagati pa makutano kwandabha jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhamana kati jha bhene ngabhan'kamuili, lakini ajhelepi jha anyosisi mabhoko gha muene panani pa muene. ");
INSERT INTO kiz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ndipo bhala maofisa bhakakerebhuka kwa bhabhaha bha makuhani ni Mafarisayo, na bhene bhakajobhela, “Kwandajhakiki mundetili lepi?” ");
INSERT INTO kiz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Maofisa bhakajibu, “Ajhelepi munu jha abhwayili kulongela kama ojho kabla.” ");
INSERT INTO kiz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ndipo Mafarisayo bhabhajibhili, “Ni muenga kabhele mupotosibhu? ");
INSERT INTO kiz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kujha ni jhejhioha kati jha bhatawala jhaikan'kiera, au jhejhioha bhwa Mafarisayo? ");
INSERT INTO kiz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bali abha makutano bhabhamanyilepi sheria - bhalaanibhu.” ");
INSERT INTO kiz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo akabhajobhela (muene jhaandotili Yesu lukhombi, bho ajhe mmonga ghwa Mafarisayo), ");
INSERT INTO kiz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Je sheria jha tete ikan'hukumu munu isipokujha ap'elekisibhu hoti ni kumanya kyaikheta?” ");
INSERT INTO kiz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bhajibili ni kun'jobhela, “Ni bhebhe kabhele ghwihomela Galilaya? Londayi na ulotayi kwamba ajhelepi nabii jha ahomili Galilaya.” ");
INSERT INTO kiz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kisha khila munu alotili kunyumba jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu akalota kid'onda kya mizeituni. ");
INSERT INTO kiz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lubhuliku akahida kabhele mu lihekalu, ni bhanu bhoha bhakandotela; akatama ni kubhafundisya. ");
INSERT INTO kiz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bhaandishi ni Mafarisayo bhakandeta n'dala jha akamuili bhugoni. Bhakambeka pagati. ");
INSERT INTO kiz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ndipo bhakan'jobhela Yesu, “Mwalimu, n'dala ojhu akamuliki bhugoni, kwa kitendo kabisa. ");
INSERT INTO kiz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Henu, sheria, Musa atujobhili kubhatobha maganga bhana kama abha, ghwijobhuli juu jha muene? ");
INSERT INTO kiz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bhajobhili agha ili kun'tegha tu ili kwamba bhakabhayi lijambo lya kun'takila, lakini Yesu ajhineme pasi alembili palifu kwa kikonji kya muene. ");
INSERT INTO kiz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bho bhijhendelela kun'kota ajhemili ni kubhajobhela, “Muene jhaajhelepi ni dhambi miongoni mwa muenga, ajhe layi wa kwanza kuh'oma liganga.” ");
INSERT INTO kiz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akajhinama kabhele pasi, akalemba ni kikonji kya muene pasi. ");
INSERT INTO kiz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bho bhap'eliki aghu bhabhokili mmonga badala jha jhongi, kujhandila jhaajhe n'seya. Mwishu Yesu alekibhu muene, pamonga ni n'dala jha ajhele pagati pa bhene. ");
INSERT INTO kiz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ajhemili ni kun'jobhela, “N'dala bhabhakutakili bhajhendaku? Ajhelepi hata mmonga jhaakutakili?” ");
INSERT INTO kiz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akajobha, “Ajhelepi hata mmonga Bwana.” Yesu akajobha, “Hata nene nikutakila lepi. Lotayi njela jha yobhi; kujhandila henu ni kujhendelela usibhombi dhambi kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kabhele Yesu alungili ni bhanu akajobha, “Nene ndo nuru jha ulimwengu; muene jha akanikesya ibetalepi kugenda mu ngisi bali ibetakujha ni nuru jha bhusima.” ");
INSERT INTO kiz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafarisayo bhakan'jobhela, “Ghwikishuhudila ghwa muene bhushuhuda bhwa jhobhi bhwa bhukweli lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ajibili akabhajobhela, “Hata kama nibetakwishuhudila ne muene, bhushuhuda bhwangu bhwa bhukweli. Nimanyili kwa nih'omela ni khola kwa nilota, lakini muenga mumanyilepi mahali kwa nihoma ni kwanilota. ");
INSERT INTO kiz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Muenga mwihukumula kimb'ele; nene nikan'takila lepi jhejhioha. ");
INSERT INTO kiz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nene hata nikatakilayi hukumu jha nene jha bhukweli kwa ndabha njelepi ne muene, bali nje ni dadi jhangu jha anilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ena, ni ku sheria jha muenga jhilembibhu kujha bhushuhuda bhwa bhanu bhabhele bhwa bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nene ndo jhanikishuhudila, ni Dadi jha anilaghisye akanishuhudila.” ");
INSERT INTO kiz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bhakan'jobhela, “Dadi waku ajhe ndaku?” Yesu ajibili, “nene munimanyilepi; ng'amuyimunimanyi nene, ngamumanyi ni Dadi jhangu.” ");
INSERT INTO kiz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ajobhi malobhi agha ajhe karibu ni hazina pa afundisieghe mu lihekalu, na ajhe lepi hata mmonga jha an'kamuili kwa ndabha saa jha muene jhajhejhakona kufika. ");
INSERT INTO kiz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Basi akabhajobhela kabhele, “Nikilotela; mwibetakunilonda na mwibetakufwa ni dhambi sya jhomu. Khola kwa nilota, mwibwesya lepi kuhida.” ");
INSERT INTO kiz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bhayahudi bhakajobha, “Ibetakwikoma muene, muene jha ajobhili, 'khola kwanilota mwibhwesya lepi kuhida'?” ");
INSERT INTO kiz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu akabhajobhela, “Mwihomela pasi; nene nihomela kunani. Muenga bha ulimwengu obho nene sio ghwa ulimwengu obho. ");
INSERT INTO kiz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Henu, nabhajobhili kujha mwibetakufwa ni dhambi sya jhomu. Labda mukyerayi kujha NENE NDIYE, mwibetakufwa ni dhambi sya jhomu”. ");
INSERT INTO kiz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kabhele bhakayanda kunijobhela, “Bhebhe ghwa niani?” Yesu akabhajobhela, ghala ghanibhajobhili kuhomela kubhwandelu. ");
INSERT INTO kiz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nijhe ni mambo mingi gha kulongela ni hukumu juu jha muenga. Hata naha, muene jha anilaghisye ni ghwa bhukweli; ni mambo gha nighap'eliki kuhoma kwa muene, mambo agha nikaghajobha kwa bhulimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bhanjelibhu lepi kujha alongeleghe kuhusu Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu akajobha, “Pamwibetakunjinula panani Muana ghwa Munu, ndipo pa mwibetakumanya kujha NENE NDO MUENE, ni kwamba nibhomba lepi lyolyoha kwa nafsi jha nene. Kama Dadi kya animanyisi, nilongela mambo agha. ");
INSERT INTO kiz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Muene jha anitumili ajhele pamonga nani, ni muene anilekililepi ne muene, kwandabha khila mara nibhomba ghala ghaghikampendesya.” ");
INSERT INTO kiz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wakati Yesu ijobha mambo agha, bhingi bhankieriri. ");
INSERT INTO kiz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu akajobha kwa bhala Bhayahudi bhabhankieriri, “Pamwibetakutama mu lilobhi lya nene, ndipo pamwibetakujha bhanafunzi bha nene kueli, ");
INSERT INTO kiz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","namu mwibetakujhimanya kuweli, ni kuweli jhibetakubhabheka huru.” ");
INSERT INTO kiz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhan'jibili, “Tete ndo bhuzao bhwa Ibrahimu ni kamwe tubhwayilepi kujha pasi pa utumwa ghwa jhejhioha; ghwijobha bhuli, “Tubekubhekibhwa huru?” ");
INSERT INTO kiz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu abhajibhili, “Muaminiayi, muaminiayi, nikabhajobhela, khila jhaibetakubhomba dhambi ndo n'tumwa ghwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","N'tumwa itamalepi kunyumba mda ghuoha; muana itamisya mda ghuoha. ");
INSERT INTO kiz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Henu, ikajhelayi muana abhabhekili huru, mwibetakujha huru kabisa.” ");
INSERT INTO kiz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nimanyili kujha muenga ndo bhuzao bhwa Ibrahimu; mwilonda kunikoma kwandabha lilobhi lya nene lijhelepi ni nafasi kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nijobha mambo ambagho nighabhuene pamonga ni Dadi jhangu, ni muenga khelakhela mwibhomba mambo ambagho mwaghap'eleki kuhoma kwa dadi jhinu.” ");
INSERT INTO kiz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhajibili ni kun'jobhela, “Dadi jhitu ndo Ibrahimu.” Yesu akabhajobhela, Kama ngamujhebhana bha Ibrahimu, ngamubhomba mbombo sya Ibrahimu. ");
INSERT INTO kiz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hata henu mwilonda kunikoma, munu jha abhajobhili bhukweli kujha nap'eliki kuhomela kwa K'yara. Abrahamu abhombilepi naha. ");
INSERT INTO kiz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mbombambombo sya dadi jhinu.” Bhakan'jobhela, “Twahogolikilepi mu uzinzi, tujhenaku Dadi mmonga, K'yara.” ");
INSERT INTO kiz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu akabhajobhela, “Ikajhiajhi K'yara ndo Dadi jhinu, ngamunigani nene, kwa ndabha nihomili kwa K'yara; wala nahidilepi kwa nafsi jha jhoni, bali muene jha anilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwandabha jha kiki mukaghajhelebhwa lepi malobhi ghangu? Kwa ndabha mwibhwesyalepi kusindamala kughap'eleka malobhi ghangu. ");
INSERT INTO kiz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Muenga ndo bha dadi jhinu, syetani, na mwilonda kusibhomba tamaa sya dadi jhinu. Ajhele n'komi kuhomela kubhwandelu na ibhwesyalepi kujhema mu bhukweli kwandabha kweli jhilepi kwa muene. Pailongela bhudesi, ilongela kuhoma kiasili jha muene kwa ndabha n'desi ni dadi ghwa bhudesi. ");
INSERT INTO kiz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hata henu, kwa ndabha nijobha jhajhijhela jha bhukweli, mukanikiera lepi. ");
INSERT INTO kiz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Niani kati jha muenga jhaakanishuhudila kujha nijhe ni dhambi? ikajhiajhi nijobha gha bhukweli, kwandabhajhakiki mkanikiera lepi? ");
INSERT INTO kiz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muene jha ajhe ghwa K'yara akaghapeleka malobhi gha K'yara; muenga mukaghap'eleka lepi kwandabha muenga bha K'yara lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bhayahudi bhakan'jibu ni kun'jobhela, tujobhilepi bhukweli kujha bhebhe ndo Msamaria na ujhe ni pepo?” ");
INSERT INTO kiz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ajibili, nijhelepi ni pepo; lakini nikan'heshimu Dadi jhangu namu mukaniheshimu lepi. ");
INSERT INTO kiz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nilonda lepi bhutukufu bhwangu; ajhe mmonga jhailonda ni kuhukumu. ");
INSERT INTO kiz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aminiayi, aminiayi, nikabhajobhela, iwapo jhejhioha jhaibetakulikamula lilobhi lyangu, ibetalepi kubhona mauti kamwe.” ");
INSERT INTO kiz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bhayahudi bhakan'hobhela, “Henu tumanyili kujha ujhe ni pepo. Abrahamu ni manabii bhafuili; lakini ghwijobha, 'Ikajhiajhi munu ibetakulikamula lilobhi lyangu, ibetakubhonja lepi mauti'. ");
INSERT INTO kiz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bhebhe ghwa mbaha lepi kuliko dadi jhitu Abrahamu jhaafuili, sivyo? Manabii pia bhafuili. Bhebhe ukibheka ghwe niani?” ");
INSERT INTO kiz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akajibu, “Ikajhiayi nibetakwitukusya ne muene bhutukufu bhwa nene ndo bure; ni Dadi jhangu jhaanitukuisi - jhola jha mukan'jobha kujha ndo K'yara ghwinu. ");
INSERT INTO kiz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Muenga mu mmanyilepi muene, lakini nene nimanyili muene. Ikajhiajhi nibetakujobha, 'nimanyilepi,' nibetakujha kama muenga, n'desi. Hata naha, nimmanyili ni malobhi gha muene nighakamuili. ");
INSERT INTO kiz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dadi jhinu Abrahamu ahobhwiki paibetakujhibhona ligono lya nene; ajhibhwene na ahobhwiki.” ");
INSERT INTO kiz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bhayahudi bhakan'jobhela, “Ufikisilepi umri ghwa miaka hamsini bado, nabhi umbwene Ibrahimu?” ");
INSERT INTO kiz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu akabhajobhela, “Aminiayi, aminiayi, nikabhajobhela, kabla Abrahamu ahogiliki lepi, NENE NIJHELE.” ");
INSERT INTO kiz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ndipo bhaholili maganga bhabhwesiajhi kun'tobha, lakini Yesu akifighili ni kuhoma kwibhala mu hekalu. ");
INSERT INTO kiz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wakati, kama Yesu bho ip'eta, ambwene munu kipofu kuhomela kuhogoleka kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bhanafunzi bha muene bhakan'kota, “Rabi, niani jha abhombi dhambi, munu ojho au bhazazi bha muene, hata ahogolikayi kipofu?” ");
INSERT INTO kiz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akabhajibu, “Siyo munu ojho wala bhazazi bha muene bhabhabhombi dhambi, bali mbombo sya K'yara sibhwesiajhi kufunulibhwa kup'etela kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Twilondeka kubhomba mbombo sya muene muene jha anitumili wakati bado pamusi. Kiru kihida wakati ambapo ajhelepi jhaibetakubhwesya kubhomba mbombo. ");
INSERT INTO kiz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wakati nje ku bhulimwengu, nene ne nuru jha ulimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Baada jha Yesu kujobha malobhi agha afunyili palifu, abhombi bhudopi kwa mata ni kumbaka munu jhola pamihu ni bhud'opi bhola. ");
INSERT INTO kiz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akan'jobhela, lotayi kujhogha mu kisima kya Siloam (Jhajhitafsiribhwa kama 'jhaatumibhu').” Henu munu ojhu alotili, akasamba, ni kukerebhuka, ilola. ");
INSERT INTO kiz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Majirani bha munu jhola ni bhala bhabhambwene kubhwandelu kama n'somaji bhajobhili, Je! ojho si jhola jhaatamaghe ni kus'oma?” bhangi bhakajobha, ");
INSERT INTO kiz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“Lepi, bali iwaningana naku.” Lakini akajha ijobha, “Ndo nene.” ");
INSERT INTO kiz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bhakan'jobhela, “Henu mihu gha jhobhi ghafungulibhu bhuli?” ");
INSERT INTO kiz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ajibili, munu jhaikutibhwa Yesu, abhombili bhudopi ni kubaka pa mihu ghangu ni kunijobhela, 'Nilotayi Siloam ukasambayi.' Henu nikalota, ni kusamba, na nikajhanilola kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhakan'jobhela, “Ajhendaku?” Ajibili, “Ndesi.” ");
INSERT INTO kiz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bhakampeleka munu jhola jha ajhele kipofu kwa Mafarisayo. ");
INSERT INTO kiz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nijhiene jha ajhele ligono lya Sabato wakati Yesu bho atendekisi bhodopi ni kughafumbula mihu gha muene. ");
INSERT INTO kiz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ndipo kabhele Mafarisayo bhakan'kota abhwesibhuli kulola. Akabhajobhela, “Abhekili bhudopi mu mihu ghangu nikasamba na henu nibhwesya kulola.” ");
INSERT INTO kiz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Baadhi jha Mafarisayo bhakajobha, “Munu ojho ahomilepi kwa K'yara kwandabha aikamuililepi Sabato.” Bhangi bhakajobha, “Jhibhwesekana bhuli munu jha ajhe ni dhambi kubhomba ishara kama esu?” Henu kukajhe ni mgabhwanyiku kati jha bhene. ");
INSERT INTO kiz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ndipo bhan'kotili jhola kipofu kabhele, “Ghwijobhuli juu jha muene kwandabha aghafunguili mihu gha jhobhi?” Kipofu akajobha, “Nabii.” ");
INSERT INTO kiz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hata wakati obhu bhayahudi bhan'kyeriri lepi kujha ajhele kipofu ni muene ibhwesya kulola mpaka bhakabhakuta bhazazi bha muene jha abhwesi kulola. ");
INSERT INTO kiz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhakabhakota bhazazi, Je, ojho mwanabhinu jha mwijobha ahogoliki kipofu? abhwesibhuli henu kulola?” ");
INSERT INTO kiz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hivyo bhazazi bha muene bhakan'jibu, “Tumanyili kujha ahogoliki kipofu. ");
INSERT INTO kiz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jinsi gani henu ilola, tumanyi lepi ni muene jha amfumbuili mihu gha muene, tumanyililepi. Mun'kotayi muene. Nyuluala. Ibhwesya kwijhe lesya muene.” ");
INSERT INTO kiz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bhazazi bha muene bhajobhili mambo agha, kwa ndabha bhabhatilili Bhayahudi. Kwa vile Bhayahudi bhajhele bha kubaliene tayari kujha, ikajhiayi jhejhioha ibetakukiri kujha Yesu ndo Kristu, ibetakutengibhwa ni Sinagogi. ");
INSERT INTO kiz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kwa ndabha ejhe, bhazazi bha muene bhakajobha, “Munu nnyuluala, munkotayi muene.” ");
INSERT INTO kiz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Henu kwa mara jha pili, bhakankuta munu jhola jha ajhele kipofu ni kun'jobhela, Mpelayi K'yara bhutukufu. Tumanyili munu ojho ajhe ni dhambi.” ");
INSERT INTO kiz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ndipo munu jhola akajibu, “Ajhelayi ni dhambi, nenimanyilepi. Khenu kimonga kya nikimanyili: najhele kipofu, ni henu nilola.” ");
INSERT INTO kiz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndipo bhakan'jobhela, “Akubhombili kiki? Aghafumbuili bhuli mihu gha jhobhi?” ");
INSERT INTO kiz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ajibili, “Nimalikubhajobhela tayari, ni muenga mup'elekisilepi! kwa ndajhakiki mwilonda kup'eleka kabhele? namu mwilonda lepi kujha bhanafunzi bha muene pia, sivyo? ");
INSERT INTO kiz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bhandighili ni kujobha, “Bhebhe ghwe mwanafunzi ghwa muene, lakini tete bhanafunzi bha Musa. ");
INSERT INTO kiz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumanyili kujha K'yara alongili ni Mussa, lakini kwa munu ojho, tumanyili lepi kwa ihomela.” ");
INSERT INTO kiz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Munu jhola akajibu ni kubhajobhela, “Kwa ndabha jha kiki, ele lijambo lya kusyangasya, kwamba mumanyilepi kwaihomela, na bado aghafumbuili mihu ghangu. ");
INSERT INTO kiz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanyili kujha K'yara akabhap'elekesya lepi bhenye dhambi, lakini ikajhiajhi munu jhejhioha ikamwabudu K'yara na ibhomba mapenzi gha muene, K'yara akamp'elekesya. ");
INSERT INTO kiz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuh'omela kujhanda kwa ulimwengu jhibhwayilepi kamwe kupelekibhwa kujha jhejhioha jhaifumbula mihu gha munu jha ahogoliki kipofu. ");
INSERT INTO kiz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ikajhiayi munu ojho ahomilepi kwa K'yara, ngaabhombilepi kyokyoha.” ");
INSERT INTO kiz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bhajibili ni kun'jobhela, “Ghwahogoliki ni dhambi kabisa, ni bhebhe ukatumanyisya tete?” Ndipo bhamb'engili mu sinagogi. ");
INSERT INTO kiz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ap'eliki kujha bhabhosili mu sinagogi. Akan'kabhili ni kun'jobhela, “Ukan'kiera Muana ghwa Munu?” ");
INSERT INTO kiz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ajibili ni kujobha, “Niani, Bwana, ili nani nikabhayi kun'kiera?” ");
INSERT INTO kiz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu akabhajobhela, “Umbwene, nu ndo jha ilongela naku.” ");
INSERT INTO kiz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jhola munu akajobha, “Bwana, Nikiera.” Ndipo akan'sujudila. ");
INSERT INTO kiz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu akajobha, “Kwa hukumu nihidili mu ulimwengu obho ili kwamba bhala bhabhilola lepi bhabhwesiajhi kulola ni bhala bha bhibhona bhajhelayi fipofu,” ");
INSERT INTO kiz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Baadhi jha Mafarisayo bhajhele pamonga ni muene bhakapeleka malobhi aghu ni kun'kota, “Nitete fipofu?” ");
INSERT INTO kiz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akabhajobhela, “Kama ngamujhele fipofu, ngamujhelepi ni dhambi. Hata naha, henu mwijobha, 'Mwilola,' dhambi jha muenga jhitama.” ");
INSERT INTO kiz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Aminiayi, aminiayi nikabhajobhela, jhola jhaijhingila lepi kwa kup'etela ndiangu ghwa zizi lya likondoo, lakini ikwela kwa njela jhenge, munu ojhu meji na mmang'anyi. ");
INSERT INTO kiz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Muene jha ijhingila pa ndiangu ndo n'dimaji ghwa kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kwamuene mlinzi ghwa ndiangu akan'dendulila. Kondoo bhakajhip'eleka sauti jha muene kwa mahina gha bhene ni kubhahomesiya kwibhala. ");
INSERT INTO kiz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paibetakubhahomesya kwibhala abhu bha bhajhele bha muene, akabhalongolela, ni kondoo bhakan'kesya, kwa ndabha bhajhimanyili sauti jha jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bhibetalepi kun'kesya n'geni lakini badala jhiake bhibetakunjepa, kwandabha bhasimanyilepi sauti sya bhahesya.” ");
INSERT INTO kiz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ajobhili mfano obhu kwa bhene, lakini bhaghayelibhu lepi mambo agha ambagho aghajobhaghe kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu akajobha nabhu kabhele, “Aminiayi, aminiayi, nikabhajobhela, Nene na ndiangu ghwa kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhoha bhanilongolili ndo bhaheji ni bhanyang'anyi, lakini kondoo bhamp'elekisi lepi. ");
INSERT INTO kiz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nene na ndiangu. Yejhioha jha ijhingila kup'etela kwa nene, ibetakuokolibhwa; ibetakujhingila mgani ni kuhoma, nu muene ibetakwikabhila malisho. ");
INSERT INTO kiz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Meji ihidalepi kup'etela kwa nene kuheja kukoma, ni kujhangamisya. Nihidili ili kwamba bhakabhayi bhuzima na bhajhela nabhu tele. ");
INSERT INTO kiz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nene n'dimaji nnofu. N'dimaji nnofu ibhosya bhuhai bhwa muene, kwa ndabha jha kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","N'tumishi jha aajaribhu, na n'dimaji lepi, ambajhe kondoo mali jha muene lepi, akabhabhona mbwa mwitu bhihida ni kubhaleka ni kubhajumba kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ni mbwa mwitu bhakabhakamula ni kubhatawanya. Ghijumba kwa ndabha ndo n'tumishi ghwa kuajiribhwa ni kubhajalilepi kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nene na n'dimaji nnofu, na nibhamanyili bhabhajhele bha nene, nabhene bhabhajhele bha nene bhanimanyi nene. ");
INSERT INTO kiz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Dadi animanyi nene, nani nimmanyi muene, nani nikambhosya uhai bhwa jhoni kwa ndabha jha kondoo. ");
INSERT INTO kiz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nijhenabhu kondoo bhangi ambabho sio bhazinzi e'le. Abhu pia, nilondeka kubhaleta, nabhanu bhibhetakujhip'eleka sauti jha nene ili kwamba pajhiaghe ni likundi limonga ni n'dimaji mmonga. ");
INSERT INTO kiz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ejhe ndo sababu Dadi aniganili: Niubhosiajhi bhuhai bhwa nene halafu niuletayi kabhele. ");
INSERT INTO kiz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ajhelepi jhaibetakutola kuhomela kwa nene, lakini nene nikaupisya ne muene. Nijhe ni mamlaka gha kupisya, nanijhe ni mamlaka gha kubhuleta pia. Nilijhamb'elili lilaghisu e'le kuhomela kwa Dadi.” ");
INSERT INTO kiz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mgawanyiku kabhele ghwibetakuh'omela kati jha bhayahudi kwandabha jha malobhi agha. ");
INSERT INTO kiz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bhingi bhakajobha, “Ajhe ni pepo na ig'oloka. Kwandabha jhakiki mkampel'ekesya?” ");
INSERT INTO kiz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bhangi bhakajobha, “Agha sio malobhi gha munu ghwa apagawe ni mapepo. Pepo libhwesya kufungula mihu gha kipofu?” ");
INSERT INTO kiz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ndipo ikahida Sikukuu jha Kubhekibhwa Wakfu Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bhwajhele bhwakati bhwa mepu, ni Yesu ajhele igenda mu lihekalu mu ukumbi bhwa Selemani. ");
INSERT INTO kiz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndipo Bhayahudi bho bhan'syonguiki ni kun'jobhela, “Mpaka ndali wibetakutubheka mu mashaka? kama bhebhe ndo Kristu, tujobhilayi wazi. ");
INSERT INTO kiz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu abhajibili, “Nimali kubhajobhela lakini mwikiera lepi mbombo syanibhomba kwa lihina lya Dadi jhangu, esu sishuhudilajuu jha nene. ");
INSERT INTO kiz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hata naha, mwikiera lepi kwa ndabha muenga sio kondoo bha nene. ");
INSERT INTO kiz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kondoo bha nene bhakajhipeleka sauti jha nene; Nibhamanyili, nabho bhakanikesya nene. ");
INSERT INTO kiz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nibhapelili uzima bhwa milele; bhibetalepi kujhangamila kamwe, na ajhelepi hata mmonga jhaibetakunyakula kuhoma mumabhoko ghangu. ");
INSERT INTO kiz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dadi jhangu, jhanipelili abhu, ndo mbaha kuliko bhangi bhoha, na ajhelepi ata mmonga jha ajheni bhuwezo bhwa kubhanyakula mu mabhoko gha Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nene ni Dadi tujhe pamonga.” ");
INSERT INTO kiz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bhakap'enda maganga ili bhampondayi kabhele. ");
INSERT INTO kiz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu akabhajibu, “Nimalikubhalasya mbombo simehele sinofu kuhomela kwa Dadi. Kwa mbombo seleku kati jha esu mwilonda kuniponda maganga?” ");
INSERT INTO kiz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bhayahudi bhakan'jibu, “Tukupondalepi maganga kwa mbombo jhinofu, lakini kwa kufuru, kwa ndabha bhebhe, ghwe munu ukifuanya kujha Mungu,” ");
INSERT INTO kiz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akabhajibu, “Jhalembibhu lepi mu sheria jha muenga, 'Najobhili, “Muenga ndo miungu”'?” ");
INSERT INTO kiz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ikajha abhakutili miungu, kwa bhala ambabho lilobhi lya K'yara lyabhahidili (ni Majhandiku ghibhwesyalepi kubomolibhwa), ");
INSERT INTO kiz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","mwijobha juu jha hola ambajhe Dadi an'homisi ni kundaghisya ku ulimwengu, 'Ghwikufuru,' kwa ndabha najobhili, 'nene na mwana ghwa K' yara'? ");
INSERT INTO kiz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ikajhiajhi nibhomba lepi mbombo sya Dadi jhangu, musin'kieri. ");
INSERT INTO kiz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hata ivyo, ikajhiajhi nikasibhomba, hata kama mkanikiera lepi, musikierayi mbombo ili kwamba mubhwesyajhi kumanya kwamba Dadi ajhele mugati mwa nene ni nene nijhele mugati mwa Dadi.” ");
INSERT INTO kiz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bhakajaribu kabhele kun'kamula Yesu, lakini akalota kuhoma mumabhoko gha bhene. ");
INSERT INTO kiz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu akalota kabhele kwiseli jha Yorodani sehemu ambajho Yohana abatisieghe, ni kutama oku. ");
INSERT INTO kiz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bhanu bhingi bhakahida kwa Yesu. Bhakayendelela kujobha, “Yohana kueli abhombilepi ishara jhejhioha, lakini mambo ghoha gha aghajobhili Yohana juu jha munu ojho ni gha bhukweli.” ");
INSERT INTO kiz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bhanu bhingi bhakamwamini Yesu apu. ");
INSERT INTO kiz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Basi munu mmonga lihina lya muene ajhele Lazaro alwaleghe. Ahomili Bethania, kijiji kya Mariamu ni dada jhake Martha. ");
INSERT INTO kiz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ajhele Mariamu jhola jhola jhaambakili Bwana Marhamu ni kumpolosya magolo gha muene kwa njuili sya muene, ambajhe ndongomunu Lazaro ajhele n'tamu. ");
INSERT INTO kiz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ndipo dada abha bhalaghisiye bhujumbe kwa Yesu ni kujobha, “Bwana, langayi jhola jha un'ganili iluala.” ");
INSERT INTO kiz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu bho apeliki akajobha, “Bhubhine obho bhwa mauti lepi, lakini, badala jhiake ni kwandabha jha utukufu bhwa K'yara ili kwamba Mwana ghwa K'yara abhwesiayi kutukusibhwa mu Bhutamu obhu.” ");
INSERT INTO kiz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu an'ganili Martha ni dada jhiake ni Lazaro. ");
INSERT INTO kiz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bho apeliki kujha Lazaro iluala, Yesu atamili magono mabhele zaidi mahali paajhele. ");
INSERT INTO kiz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ndipo baada jha ele akabhajobhela bhanafunzi bha muene, “Tulotayi Uyahudi kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bhanafunzi bhakan'jobhela, “Rabi, Bhayahudi bhajhele bhijaribu kukuponda maganga, ni bhebhe ghwilonda kukerebhuka kabhele?” ");
INSERT INTO kiz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akabhajibu, “Saa sya pamusi si kumi na mbili? Munu paigenda pamusi ibhwesya lepi kwikungufula, kwandabha ibhona kwa munu jha pamusi. ");
INSERT INTO kiz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hata efyo, ikajhiajhi ibetakugenda pakilu, ibetakwikungufula kwa ndabha nuru ijhelepi mugati mwa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu akajobha mambo agha, akabhajobhela, “Rafiki jhitu Lazaro agonili, lakini nilota ili kwamba nikabhayi kunjumusya kuhomela mu ligono.” ");
INSERT INTO kiz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ndipo bhanafunzi bhakan'jobhela, “Bwana, kama agonili, ibetakujhumuka. ");
INSERT INTO kiz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wakati obho Yesu ajhele ilongela habari sya kifo kya Lazaro, lakini bhene bhafikilaghe ilongela juu jha kugona lugono. ");
INSERT INTO kiz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndipo Yesu akalongela nabhu wazi wazi, “Lazaro afuili. ");
INSERT INTO kiz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nihobhwiki kwandabha jhinu, kujha najhelepi khola ili kwamba mkabhayi kukiera. Tubhoki kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Basi Tomaso, jhaakutibhu Pacha, abhajobhili bhanafunzi bhajhinu, “Natu tubhoki pia tukafuayi pamonga ni Yesu.” ");
INSERT INTO kiz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wakati Yesu bho ahidili, akolili kujha Lazaro tayari amalikujha mu likaburi magono mancheche. ");
INSERT INTO kiz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ni Bethania jhajhele karibu ni Yerusalemu kama kilomita arobaini na tano naha. ");
INSERT INTO kiz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bhingi kati jha Bhayahudi bhakahida kwa Martha ni Mariamu kubhafariji kwa ndabha jha ndongo bhabhi. ");
INSERT INTO kiz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ndipo Martha bho ap'eliki kujha Yesu ihida, akalota kubhonana naku, lakini Mariamu ajhendelili kutama kunyumba. ");
INSERT INTO kiz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ndipo Martha akan'jobhela Yesu, “Bwana, kama ngaujhi apa, kaka jhangu ngafuili lepi. ");
INSERT INTO kiz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hata henu, nimanyili jha kujha lyolyoha lya wibetakus'oka kuh'oma kwa K'yara, ibetakupela.” ");
INSERT INTO kiz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu akan'jobhela, kaka jhakhu ibetakufufuka kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha akan'jobhela, nimanyili kujha ibetakufufuka ligono lya mwishu.” ");
INSERT INTO kiz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu akan'jobhela, “Nene na ufufuo ni bhusima; muene jha akanikiera, ingabhwa ibetakufwa hata efyo ibetakujha itama; ");
INSERT INTO kiz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ni muene jha itama ni kunikiera nene ibetalepi kufwa. Ghwikiera e'le?” ");
INSERT INTO kiz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Akajobhela, “Ena, Bwana nikiera kujha bhebhe ndo Kristu, Mwana ghwa K'yara, muene jha ihida mu ulimwengu.” ");
INSERT INTO kiz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bho amalikujobha e'le, akabhoka ni kun'kuta dada jhake Mariamu pa lubhafu. Akajobha, “Mwalimu ajhele apa na ikukuta.” ");
INSERT INTO kiz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariamu bho ap'eliki agha ajhimuiki kwa haraka ni kulota kwa haraka ni kulota kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ni muene Yesu ajhele bado ahidi lepi mu kijiji, bali ajhe akona mahali pa abhonene ni Martha. ");
INSERT INTO kiz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndipo Bhayahudi bhabhajhele Mariamu mu nyumba ni bhala bhabhajhele bhikmfariji, bho bhambwene ijhinuka haraka ni kuhoma kwibhala, bhan'kesisi; bhafikirileghe ilota kulikaburi ili akalelayi okhu. ");
INSERT INTO kiz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ndipo Mariamu, bho afikiri pala Yesu pa ajhele ambwene na, aguili pasi pa magolo gha muene ni kun'jobhela, “Bwana, kama ngaujhele apa, ndongobhangu ngaafuili lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu bho ambwene ilela, ni Bhayahudi bhabhahidili pamonga ni muene bhajhele bhilela pia, aombolisi kwa roho ni kufadhaika; ");
INSERT INTO kiz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","akajobha, “Mun'gonisi ndaku? bhakan'jobhela, Bwana, hidayi langayi.” ");
INSERT INTO kiz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu akalela. ");
INSERT INTO kiz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndipo Bhayahudi bhakajobha, “Langayi kyaan'ganili Lazaro!” ");
INSERT INTO kiz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakini bhangi kati jha bhene bhakajobha, “Ojholepi, jhaaghafumbuili mihu gha jhola kipofu, abhwesi lepi kubhomba munu ojho asifwi?” ");
INSERT INTO kiz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ndipo Yesu, hali iomboleza mu nafsi mwa muene kabhele, akalota ku likaburi. Henu lyajhele pango, ni liganda lya bhekibhu panani. ");
INSERT INTO kiz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu akajobha, “Mulibhosiajhi liganga.” Martha, dada jhake ni Lazaro, jhaafuili akan'jobhela Yesu, “Bwana, kwa muda obho, mb'ele ghwibeta kujha ubholili, kwa ndabha amalikujha maiti kwa magono mancheche.” ");
INSERT INTO kiz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu akabhajobhela, “Nene nakujobhilepi jhakujha, kama ukakierayi, wibetakubhubhona utukufu ghwa K'yara?” ");
INSERT INTO kiz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Henu bhakalibhosya liganga. Yesu akajhinula mihu gha muene kunani ni kujobha, “Dadi, nikushukuru kwa ndabha ukanip'elek'esya. ");
INSERT INTO kiz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nimanyili kujha ukanip'elekesya mara siyoha, lakini kwandabha jha likusanyiku ambalyo lijhemili kunisyong'oka kujha ni jobhili agha ili kwamba bhabhwesiajhi kuamini kujha bhebhe unilaghisi.” ");
INSERT INTO kiz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Baada jha kujobha agha, alelili kwa sauti mbaha, “Lazaro, pitayi kwibhala!” ");
INSERT INTO kiz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mfu apitili kwibhala akongibhu mabhoko ni magolo kwa sanda sya kusyelela, ni pamihu pa muene ni kitambala.” Yesu akabhajobhela, “Mumbopolayi mkandekayi alotayi.” ");
INSERT INTO kiz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndipo Bhayahudi bhingi bhabhahidili kwa Mariamu ni kutola Yesu kyaabhombili, bhakankiera; ");
INSERT INTO kiz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","lakini baadhi jha bhene bhakalota kwa Mafarisayo ni kubhajobhela mambo gha abhombili Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ndipo bhabhaha bha Makuhani ni Mafarisayo bhakabhonganika pamonga mu libaraza ni kujobha, “Tubeta khetabhuli? Munu ojho ibhomba ishara simehele. ");
INSERT INTO kiz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ikajhelayi tubetakun'kiera naha muene, bhoha bhibetakun'kiera; Bharumi bhibetakuhida ni kutola fyoha mahali pa tete ni litaifa lya jhotu.” ");
INSERT INTO kiz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hata naha, munu mmonga kati jha bhene, Kayafa, jhaajhele kuhani mbaha mwaka obhu, akabhajobhela, “Mmanyilepi kyokyoha kabisa. ");
INSERT INTO kiz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mwifikirira kujha jhilondeka kwa ndabha jha muenga kujha kati jha muenga jhilondeka munu mmonga kufwa kwa ndabha jha bhanu kuliko litaifa lyoha kujhangamila.” ");
INSERT INTO kiz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Agha aghajobhilepi kwa ndabha jha muene, badala jhiake, kwa kujha ajhele, kuhani mkuu mwaka ghola, atabiri kujha Yesu ibetakufwa kwa ndabha jha litaifa; ");
INSERT INTO kiz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na sio kwa litaifa liene, bali Yesu akabhayi vilevile kubhabhonganiya bhana bha K'yara ambabho bhatabhwanyiki sehemu mbalimbali. ");
INSERT INTO kiz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Henu kujhandila e'lu ni kujhendelela bhakapanga namna jha kunkoma Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu agendilepi kabhele wazi wazi pa Bhayahudi, bali akabhoka apu akalota nchi jha ijhele karibu ni jangwa pa mji ghwa Efraimu. Apu atamili ni bhanafunzi. ");
INSERT INTO kiz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Basi Pasaka jha Bhayahudi jhajhele karibu, ni bhingi bhalondeghe kulota Yerusalemu kwibhala pa mji kabla jha Pasaka ili bhabhwesiayi kwitakasya bhene. ");
INSERT INTO kiz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bhakajha bhakan'donda Yesu, ni kulongela khila mmonga pabhajhele bhajhemili mu lihekalu, “Mwifikirira kiki? Kujha ibetalepi kuhida ku sikukuu?” ");
INSERT INTO kiz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakati obhu bhabhaha bha makuhani ni Mafarisayo bhajhele bhahomisi amri kujha ikajhiayi mmonga amanyili Yesu pa ajhele, ilondeka kupisya taarifa ili kwamba bhabhwesiayi kun'kamula. ");
INSERT INTO kiz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Magono sita kabla jha Pasaka, Yesu alotili Bethania, paajhele Lazaro, muene jha amfufuili kuh'omela kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Basi bhakanjandalila kyakulya kya kimihi oku, ni Martha akanitumikila, wakati obhu Lazaro ajhele mmonga wipoghwa bhala bhabhatamili pa kyakulya pamonga ni Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kisha Mariamu atolili ratli jha manukato ghaghatengenesibhu kwa nardo jhinofu, jhajhijhe ni thamani mbaha, akambakasya Yesu mu magolo, ni kumpolosya magolo kwa njuili sya muene; nyumba jhioha jha memili harufu jha manukato. ");
INSERT INTO kiz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Iskariote, mmonga ghwa bhala bhanafunzi bha muene, ambajhe ndo an'saliti Yesu, akajobha, ");
INSERT INTO kiz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwa ndabha jha kiki manukato agha ghabeleghe kugolesibhwa kwa dinari mia tatu ni kupelibhwa maskini?” ");
INSERT INTO kiz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ni muene akajobha aghu, si kwa kubhafuhurumila maskini, bali kwa ndabha ajhele mmeji: muene ndo jhaakamuili mfuku ghwa hela na atoleghe baadhi jha fibhekibhu omu kwa ndabha jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu akajobha, “Ndekayi abhekayi kya ajhenaku kwa ndabha jha maziku ghangu. ");
INSERT INTO kiz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maskini mwibetakujha nabhu magono ghoha; lakini mwibetalepi kujha nani magono ghoha.” ");
INSERT INTO kiz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Basi bhumati mbaha ghwa Bhayahudi bhakabhwesya kumanya kujha Yesu ajhele okhu, na bhene bhakahida, sio kwandabha jha Yesu tu bali bhambonayi Lazaro ambaye Yesu amfufuili kuhomela kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ni bhabhaha bha makuhani bhakabhomba shauri ili bhan'komayi Lazaro; ");
INSERT INTO kiz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maana kwa ndabha jha muene bhingi Bhayahudi bhakilotili ni kun'kiera Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ni ligono lya pili lyake umati mbaha bhahidili ku sikukuu. Bho bhap'eliki Yesu ihida Yerusalemu, ");
INSERT INTO kiz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","bhakalota matawi gha mabhehe gha mitende ni kuhoma kwibhala kulota kumlaki ni kujhuegha, “Hosana! Abarikibhu muene jha ihida kwa lihina lya Bwana, Mfalme ghwa Israeli.” ");
INSERT INTO kiz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu an'kabhili mwana-punda akakuela; kama vile kyajhalembibhu, ");
INSERT INTO kiz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Usitili, binti Sayuni; langayi, Mfalme ghwa jhobhi ihida, akwelili mwana-punda.” ");
INSERT INTO kiz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bhanafunzi bha muene bhaghajhelibhu lepi mambo agha hapo hoti; lakini Yesu bho atukusibhu, ndipo bhakhombuiki jha kujha mambo agha alembibhu muene ni kwamba bhabhombili mambo agha kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Basi likundi lele lya bhanu bhabhajhele pamonga ni Yesu wakati an'kutili Lazaro kuhomela mu likaburi, bhakashuhudila kwa bhangi. ");
INSERT INTO kiz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na jhajhele kwa ndabha ejhe kwamba likundi lya bhanu bhalotili kumlaki kwa ndabha bhap'eliki jha kujha ajhibhombili ishara ejhu. ");
INSERT INTO kiz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafarisayo bhakajobhesana bhene kwa bhene, “Langayi, henu mwibhwesya lepi kubhomba kyokyoha; langayi, ulimwengu ulolili kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Henu baadhi jha Bhayunani bhajhele miongoni mwa bhala bhabhajhele bhilota kuabudu ku sikukuu. ");
INSERT INTO kiz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Abha bhandotili Filipo, ambajhe ahomili Bethsaida jha Galilaya, bhakans'oka bhakajobha, “Bwana, tete twilonda kumbona Yesu.” ");
INSERT INTO kiz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo akalota akan'jobhela Andrea; Andrea ni Filipo bhakalota ni kun'jobhela Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akabhajibu akajobha, “Saa jhifikiri kwa ndabha jha Muana ghwa Adamu kutukusibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aminiayi, aminiayi, nikabhajobhela chembe jha ngano jhikabelayi kubina palifu jhikafwa, jhitama mebhwa jhiene; bali jhikafuayi jhihogola matunda mingi. ");
INSERT INTO kiz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jhaabhuganili uhai bhwa muene ibetakubhujhasya; bali jhaabhudadili uhai bhwa muene pa uloimwengu obho ibetakubhusalimisya hata uzima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Munu jhejhioha jhaibetakunitumikila nene, na anikesiajhi; nani pa nijhele ndipo ni n'tumishi ghwangu paibetakujha. Munu jhejhioha jhaibetakunitumikila, Dadi ibetakun'heshi. ");
INSERT INTO kiz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Henu roho jha nene ifadhaiki: nani nijobhabhuli? Dadi, uniokolayi katika lisaa e'le? Lakini kwa kusudi e'le nijhifikili lisaa e'le. ");
INSERT INTO kiz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dadi, ulitukusiajhi lihina lya jhobhi.” Kisha sauti ikahida kuh'omela kumbinguni ni kujobha, “Nilitukuisi nani nibetakulitukusya kabhele.” ");
INSERT INTO kiz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Basi n'kutano ghwajhemili palubhafu pa muene bhap'eliki, bhakajobha kujha kujhe ni ngurumo. Bhangi bhakajobha, “Malaika ajobhi naku.” ");
INSERT INTO kiz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu akajibu ni kujobha, “Sauti ejhe jhikahidi lepi kwa ndabha jha nene, bali kwandabha jha muenga. ");
INSERT INTO kiz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Henu hukumu jha ulimwengu obhu jhijhele: Henu mbaha ghwa ulimwengu obhu isopibhwa kwibhala. ");
INSERT INTO kiz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ni nene panibetakujhinulibhwa panani pa nchi, nibetakubhatafuta bhoha kwa nene.” ");
INSERT INTO kiz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aghajobhili aghu kulasya kujha mauti gani gha ibetakufwa. ");
INSERT INTO kiz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mkutano bhukan'jibu, “Tete tup'eliki ku sheria kujha Kristu ibetakutamisya hata milele. Ni bhe ghwijobhuli, 'Mwana ghwa Adamu lazima ajhinulibhwayi kunani'? Ojho Muana ghwa Munu niani?” ");
INSERT INTO kiz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Basi Yesu akabhajobhela, “Nuru jhijhepamonga namu muda kidogo. Mulotayi kwa kujha mujhe ni nuru, ili kwamba ngisi jhisibhabhwesi. Jhailota ku ngisi amanyilepi kwa ilota. ");
INSERT INTO kiz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mujhe ni nuru mujhiaminiajhi nuru ejhu ili mukabhayi kujha bhana bha nuru.” Yesu ajobhili aghu ni kisha akabhoka akakifigha bhasimboni. ");
INSERT INTO kiz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ingabhwa Yesu abhombili ishara simehele namna ejhu mbele jha bhene, bado bhabelikumwamini ");
INSERT INTO kiz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ili litimilayi lilobhi lya nabii Isaya, lyaalijobhili: “Bwana, niani jhaasisadiki habari sya tete? Ni kibhoko kya Bwana afunulibhu niani?” ");
INSERT INTO kiz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndio sababu bhene bhabeli kun'kiera, ndabha Isaya ajobhi kabhele, ");
INSERT INTO kiz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Abhapofuisi mihu, ni kujhibhomba minonono mioyo jha bhene; bhasihidi bhakalota kwa mihu gha bhene ni kumanya kwa mioyo ghya bhene, ni kuongoka nani kubhaponyesya.” ");
INSERT INTO kiz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya ajobhili malobhi agha kwa kujha aubhwene utukufu bhwa Yesu ni kujobha habari sya muene. ");
INSERT INTO kiz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bhalakini, hata bhabhaha bhingi bhan'kyeriri Yesu; lakini kwa ndabha jha Mafarisayo, bhakiririlepi ili bhasihidi kutengibhwa ni sinagogi. ");
INSERT INTO kiz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bhaganili sifa sya bhanadamu kuliko sifa syasihomela kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu akakuesya sauti ni kujobha, “Jhaibetakuniamini, akaniamini nene tu bali ni muene jhaanitumili nene, ");
INSERT INTO kiz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ni jhaibetakunibhona nene ibetakumbona muene jha anilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nene nihidili kama nuru pa ulimwengu ili khila munu aniaminiayi nene asitami mu ngisi. ");
INSERT INTO kiz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ikajhelayi munu jhejhioha ibetakughap'eleka malobhi ghangu lakini akaghakamula lepi, nene nikan'hukumu lepi; ndabha nahidilepi ili kuhukumu ulimwengu bali nibhuokolayi ulimwengu. ");
INSERT INTO kiz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jhaibetakunibela nene ni kughabela malobhi ghangu ajhele jhaibetakun'hukumu: lilobhi e'lu lyanilijobhili ndo lyalibetakun'hukumu ligono lya mwishu. ");
INSERT INTO kiz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ndabha nene najobhilepi kwa nafsi jha nene tu. Bali Dadi jha anipeliki, muene angaghisi ghaibetakujobha ni kughapanga. ");
INSERT INTO kiz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nani nimanyili kujha lilaghisu lya muene ni bhusima bhwa milele; basi aghu ndo ghanijobha nene - kama Dadi kyaanijobhili, ndo kyanibeta kujobha kwa bhene.” ");
INSERT INTO kiz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Henu kabla ya ligono lya sikukuu jha pasaka, kwa ndabha Yesu amanyili kujha saa jha muene jhifikili ambajho ibetakuhoma mu dunia ejhe kulota kwa dadi, ikajha bhajhele pa dunia, abhaganili upeo. ");
INSERT INTO kiz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ni ibilisi ajhele abhekibhu tayari mu muoyo ghwa Yuda Iskariote, mwana ghwa simoni, kun'saliti Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu amanyili kujha dadi abhekili fenu fyoha mu mabhoko gha muene ni kwamba ahomili kwa K'yara na ajhele ilotakabhele kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ajhemili pa kulya ni kutandika liguanda lya muene kwibhala. Kisha akalota litaulo ni kwik'onga muene. ");
INSERT INTO kiz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kisha akabheka masi mu bakuli ni kujhanda kubhasuka magolo bhanafunzi bha muene ni kubhafuta ni litaulo ambalyo akikongili muene. ");
INSERT INTO kiz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Akahida kwa Simoni Petro, ni Petro akan'jobhela, “Bwana, ghwilonda kunisambisya magolo ghangu?” ");
INSERT INTO kiz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akajibu ni kubhajobhela, “Lyanibhomba ulimanyilepi henu, lakini wibetakumanya baadaye.” ");
INSERT INTO kiz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro akan'jobhela, “Wibetalepi kunisambisya magolo gha nene kamwe.” Yesu ajibili, “Ikajhelayi nibetalepi kusambisya wibetalepi kujha ni sehemu pamonga ni nene.” ");
INSERT INTO kiz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petro akan'jobhela, “Bwana, usinisambisi magolo ghangu tu, bali pia ni mabhoko ni mutu bhwangu.” ");
INSERT INTO kiz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu akan'jobhela, “Jhejhioha jha amalili kujhogha ilondeka lepi kujhogha isipokujha magolo gha muene, na ajhele kinofu mb'ele ghwa muene bhwoha; muenga mujhele mwe bhanofu lakini sio mwe bhoha.” ");
INSERT INTO kiz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kwa kujha Yesu amanyili jhola jhaibetakun'saliti; ejhe ndo sababu ajobhili, mwebhoha lepi jha mujhele kinofu.” ");
INSERT INTO kiz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wakati Yesu bho abhasambisi magolo gha bhene ni kutola livazi lya muene ni kutama kabhele, abhajobhili, “Je Mwijhelebhwa khela ambakyo nibhabhombili? ");
INSERT INTO kiz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukanikuta nene “Mwalimu” ni Bwana ejhe mwijobha bhukweli, ndabha ndo kya nijhele. ");
INSERT INTO kiz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ikajhelayi nene Bwana ni Mwalimu, nibhasambisi magolo gha jhomu, namu kabhele jhikabhalondeka kubhasanbisya bhajhinyu magolo. ");
INSERT INTO kiz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kwa kujha nibhapelili mifuano ili kujha muenga mubhombayi kama nene kyanibhombili kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aminiayi, Aminiayi, nikabhajobhela n'tumwa mbaha lepi kuliko bwana ghwa muene; wala jhola jha atumibhu mbaha kuliko jha antumili. ");
INSERT INTO kiz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ikajhiajhi umanyili mambo agha, ubarikibhu ukaghabhomba. ");
INSERT INTO kiz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nijobha lepi kuhusu muenga mwebhoha, kwa kujha nibhamanyili bhala ambabho ni bhachaguili - bali nijobha agha ili kwamba majhandiku ghabhwesyajhi kutimilizwa: 'Muene jha ilya nkate ghwangu, an'jhinulili kisigino kya muene.' ");
INSERT INTO kiz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nikabhajobhela ele henu kabla kyakona kuh'omela ili kwamba palibeta kuhomela, mubhwesyayi kukiera kujha nene NDO NE MUENE. ");
INSERT INTO kiz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aminiayi, aminiayi, nikabhajobhela, jhaikanipokela nene akampokela jhola jha anilaghisye nene.” ");
INSERT INTO kiz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wakati Yesu ajobhili agha, asumbuiki mu roho, ashuhudili ni kujobha, “Aminiayi, aminiayi, nikabhajobhela kujha mmonga bhinu ibetakunisaliti.” ");
INSERT INTO kiz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bhanafunzi bha muene bhakalolesana, bhakashangala kwandabha jha niani ajobhili.” ");
INSERT INTO kiz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pajhele pameza mmonga ghwa bhanafunzi bha muene ajhegheme pakifua kya Yesu jhola ambajhe Yesu an'ganili. ");
INSERT INTO kiz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petro akan'kota mwanafunzi ojho ni kujobha, “Tujobhilayi jholeku kwa muene ilongela.” ");
INSERT INTO kiz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mwanafunzi jhola jha ajhegheme pa kifua kya Yesu ni kun'jobhela, “Bwana, ndo niani?” ");
INSERT INTO kiz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kisha Yesu ajibili, “Ni kwa jhola ambajhe nibetakujhina kipandi kya n'kate ni kumpela.” Naha bho ajhinili n'kate, ampelili Yuda mwana ghwa Simoni Iskariote. ");
INSERT INTO kiz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ni baada jha n'kate, lisyetani lyan'jhingili. Kisha Yesu akan'jobhela, “Khela kya ghwilonda kukibhona ukibhombojhi manyata.” ");
INSERT INTO kiz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Henu ajhelepi munu pameza amanyili ndabha jha Yesu kujobha lijambo e'le kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Baadhi jha bhene bhadhanileghe kujha, kwandabha Yuda akamuili mfuku ghwa hela, Yesu an'jobhili, “Golayi fenu fyatwilonda kwa ndabha jha sikukuu,” au kwamba ilondeka kupisya khenu kwa maskini. ");
INSERT INTO kiz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Baada jha Yuda kupokela n'kate, ahomili kwibhala manyata; na jhajhele pakilu. ");
INSERT INTO kiz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wakati Yuda abhokili, Yesu ajobhili, “Henu mwana ghwa Adamu atukusibhu, ni K'yara atukusibhu kup'etela muene. ");
INSERT INTO kiz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","K'yara ibetakun'tukusya kwa muene, ni ibetakun'tukusya manyata. ");
INSERT INTO kiz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bhana bhadebe, nijhele pamonga namu patali kidogo. Mwibetakunilonda, na kama kyanibhajobhili Bhayahudi, 'Kwanilota, mwibhwesya lepi kuhida.' henu nikabhajobhela muenga, pia. ");
INSERT INTO kiz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nikabhapela amri mpya, kujha mgananayi; kama nene kyanibhaganili muenga, fefuefu namu kya mwilondeka kuganana jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kwandabha jha e'le bhanu bhibetakumanya kujha muenga ndo bhanafunzi bha nene, ikajhiajhi bhupendo bhwa khila mmonga ni jhongi.” ");
INSERT INTO kiz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petro an'jobhili, “Bwana, wilota ndaku?” Yesu ajibili, “Mahali panilota kwa henu wibetabhwesyalepi kunikesya, lakini wibetakunikesya baadajhe.” ");
INSERT INTO kiz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro akan'jobhela, “Bwana, kwa ndabha jhakiki ni sikukhesi hata henu? Nene nikaghabhosya maisha gha nene kwa ndabha jha bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ajibili, “Je wibetakubhosya maisha gha jhobhi kwa ndabha jha nene? Aminiayi aminiayi nikujobhela, kabla jha likongobhe kubheka mara tatu wibetakujha unibelili.” ");
INSERT INTO kiz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Usiruhusu muoyo ghwa jhobhi kujha mu mahangaiko. Ukan'kiera K'yara basi nikierayi ni nene. ");
INSERT INTO kiz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu nyumba jha Dadi jhangu ghajhele makazi ghamahele gha kutama; kama ngajhijhe lepi naha nganikujobhili, kwa vile nilota kuandalila mahali kwandabha jha bhebhe. ");
INSERT INTO kiz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kama nibetakulota kubhaandalila mahali, nibetakuhida kabhele kubhakaribisya kwa nene, ili mahali pa niyele namu mujhelayi. ");
INSERT INTO kiz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mumanyili paniyele namu mujhelayi.” ");
INSERT INTO kiz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso an'jobhili Yesu, “Bwana, tumanyilepi mahali pa ghwilota; Je! Twibhwesya bhuli kujhimanya njela? ");
INSERT INTO kiz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu an'jobhili, “Nene ndo njela, kweli, ni uzima; ajhelepi jha ibhwesya kuhida kwa Dadi bila kup'etela kwa nene. ");
INSERT INTO kiz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kama ngamu nimanyili nene, ngamumanyili ni Dadi jhangu kabhele; kubhwanjila henu nikuyendelela mumanyili na nimalili kumbona muene.” ");
INSERT INTO kiz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philipo an'jobhili Yesu, “Bwana, tulasiajhi Baba, ni naha jhibetakujha jhitutosisi.” ");
INSERT INTO kiz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akan'jobhela, “Nijhelepi namu kwa mda mrefu, na bado unimanyilepi nene, Philipo? Jhejhioha jha anibhwene nene ambwene Dadi; Namna jheleku ghwijobha, 'Tulaseajhi Dadi'? ");
INSERT INTO kiz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mwikieralepi kujha nene mugati mwa Dadi, ni Dadi ajhe mugati mwa nene? Malobhi ghanijobha kwa muenga nijobhalepi kwa kusudi lya nene; badala jhiakhe, Dadi jha itama mugati mwa nene jhaibhomba mbombo jhiakhe. ");
INSERT INTO kiz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nikierayi nene, kujha nijhe mugati mwa Dadi, ni Dadi ajhele mugati mwa nene kadhalika nikierayi nene kwandabha jha mbombo jhangu hosi. ");
INSERT INTO kiz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aminiayi, aminiayi, nikabhajobhela, jhaibetakunikiera, mbombo syanibhomba nene, ibetakusibhomba ni muene pia; na ibetakusibhomba hata mbombo mbaha kwandabha nilota kwa Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kyokyoha kya mwibetakus'oka kwa lihina lya nene, nibetakubhomba ili Dadi abhwesyayi kutukusibhwa katika Muana. ");
INSERT INTO kiz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kama mwibetakus'oka khenu kyokyoha khela kwa lihina lya nene, e'lu nibetakubhomba. ");
INSERT INTO kiz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kama nibetakunigana, mwibetakusikamula amri sya nene. ");
INSERT INTO kiz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na nibetakun'soka Dadi, Ni muene ibetakubhap'ela N'saidizi jhongi ili kujha abhwesiajhi kujha pamonga namu milele, ");
INSERT INTO kiz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Roho ghwa bhuwkeli. Ulimwengu ghwibhwesya lepi kumpokela muene kwa ndabha ukambona lepi, au kummanya muene. hata naha muenga, mummanyili muene, kwani itama pamonga namu na ibetakujha mugati mwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nibetalepi kubhaleka mwejhomu; Nibetakukerebhuka kwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kwa lukhombi, ulimwengu wibetalepi kunibhona kabhele, lakini muenga mkanibhona, kwandabha nitama, namu mwiishi pia. ");
INSERT INTO kiz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Katika ligono e'lu mwibetakumanya kujha nene nijhele mugati mwa Dadi, ni kwamba muenga mujhele mugati mwawnene, ni nene nijhele mugati mwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jhejhioha jha ibetakusikamula amri sya nene ni kusikesya, ndo mmonga jhaaniganili nene; na jhaibeta kunigana nene basi ibetakuganikibhwa ni Dadi jhangu, na nibetakun'gana na nibetakwilasya ne muene kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (siyo Iskariote) akan'jobhela Yesu, “Bwana, Je! Kheleku kibetakuh'omela kwamba wibetakwilasya ghwe muene kwa tete na siyo kwa ulimwengu? ");
INSERT INTO kiz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ajibili akan'jobhela, “Kama jhejhioha jhaaniganili, ibetakulikamula lilobhi lyangu. Dadi jhangu ibetakun'gana, na twibetakuhida kwa muene ni kubheka makao gha jhotu pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jhejhioha jha aniganilepi nene, ikamu lepi malobhi ghangu. Lilobhi ambalyo mkalip'eleka lya nene lepi bali lya Dadi jha anilaghisye. ");
INSERT INTO kiz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nighajobhili mambo agha kwa jhomu, wakati bado niishi miongoni mwa jh'omu. ");
INSERT INTO kiz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hata naha, Mfariji, Roho Mtakatifu, ambajhe Dadi ibetakundaghisya kwa lihina lya nene, ibetakubhamanyisya mambo ghoha ni kubhabhomba mkhomb'okayi ghoha ambagho maghajobhili kwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Amani nikabhap'ela amani jha nene kwa muenga. Nikabhap'ela lepi kama ulimwengu kyawipisya. Musijhibhombi mioyo jha muenge kujha ni mahangaiko, ni bhuogha. ");
INSERT INTO kiz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwap'eliki kya nabhajobhili, 'Nibetakwilotela, na nibetakukerebhuka kwa jhomu.' Kama ngamuniganilli nene, ngamuhobhuiki kwandabha nilota kwa Dadi, kwa ndabha Dadi ndo mbaha kuliko nene. ");
INSERT INTO kiz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Henu nimalikubhajobhela kabla jhakhona kuh'omela ili kwamba wakati ikahomelayi mubhwesyayi kukiera. ");
INSERT INTO kiz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nibetalepi kulongela namu malobhi mingi, kwa kujha mbaha ghwa dunia ejhe ihida. Muene ajhelepi ni nghofu juu jha nene, ");
INSERT INTO kiz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini ili kwamba ulimwengu ukabhayi kumanya kujha nin'ganili Dadi, nibhomba ambakyo Dadi anilaghisi, kama vile kyaanipelili amri. Mujhinukayi, na mubhokayi mahali apa. ");
INSERT INTO kiz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nene na mzabibu ghwa bhukweli, ni dadi jhangu ndo n'kulima ghwa mizabibu. ");
INSERT INTO kiz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila litafi mugati mwa nene ambalyo lihogola lepi litunda libhosibhwa ili libhwesiyi kuhogola zaidi. ");
INSERT INTO kiz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Muenga tayari mujhele mwebhanofu kwandabha jha bhujumbe ambabho ni bhajobhili. ");
INSERT INTO kiz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mtamayi mgati mwa nene ni nene mwa muenga. Kama litafi kyalibhwesyalepi kuhogola lyene palibelikujha mu mzabibu, kadhalika namu, mkabelayi kutama mwanene. ");
INSERT INTO kiz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nene na mzabibu; muenga matafi. Jhaibetakudumu mugati mwa nene nani nibetakujha mwa muene, munu ojho ihogola matunda mini, kwa kujha pasipo nene wibhwesyalepi kubhomba khenu kyokyoha khela. ");
INSERT INTO kiz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ikajhiajhi munu jhejhioha ibetalepi kusalila mugati mwa nene ibetakutaghibhwa kama litafi ni kujhoma; bhanu bhibhonganya matafi ni kutagha mu muoto, ni kuteketela. ");
INSERT INTO kiz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ikajhiayi mwibetakudumu mugati mwa nene, ni kama malobhi ghangu ghatamisyi mwa muenga, mus'okayi lyolyoha lya mwilonda namu mwibetakubhombibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Katika e'le Dadi jhangu atukusibhu, kwamba mwihogola matunda mingi ni kwamba bhanafunzi bhanene. ");
INSERT INTO kiz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kama dadijhangu kya aniganili nene, nani pia nibhaganili muenga; mudumumuayi mu lipendo lyangu. ");
INSERT INTO kiz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ikajhiajhi mwibeta kusikamula amri sya nene, mwibeta kutamisya mu lipendo lya muene. ");
INSERT INTO kiz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nijobhili mambo agha kwa muenga ili furaha jha nene jhijhelayi mugati mwa muenga ili kwamba furaha jha muenga jhibhombekayi kujha timilifu. ");
INSERT INTO kiz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ejhe ndo amri jha nene, kwamba mgananayi jhomu kwa jhomu kama kyanibhaganili nene. ");
INSERT INTO kiz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ajhelepi munu jha ajhe ni bhupendo mbaha kuliko obho, kujha aghapisiayi maisha gha muene kwandabha jha bhalongomunu. ");
INSERT INTO kiz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Muenga bhalongobhangu kama mwibetakubhomba ghala ghanibhalaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nikabhakuta lepi bhatumwa, kwa kujha n'tumwa amanyilepi khela kyaibhomba bwana ghwa muene. Nibhakutili muenga marafiki, kwa ndabha nibhajobhili muenga mambo ghoha ambagho ni ghap'eliki kuhomela kwa Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mwanichuguili lepi nene, bali nene nabhachaguili muenga ni kubhabheka mlotayi kuhogola matunda ni litunda lya muega libhwesyayi kutama. E'le lijhele naha ili kyamwis'oka kwa Dadi kwa lihina lya nene, ibetakubhapela. ");
INSERT INTO kiz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mambo agha nikabhalaghisya, kujha mgananayi khila munu ni njhinu. ");
INSERT INTO kiz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kamam ulimwengu ghwibetakubhadadila, mmanyayi kujha bhwanidadila nene kabla jha kubhadadila muenga. ");
INSERT INTO kiz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kama ngamujhele bha ulimwengu, ulimwengu gha ubhaganili kama ghwa bhene; Lakini kwa ndabha bhaulimwengu lepi na kwa ndabha nabhachaguili kuh'omela ku ulimwengu, kwandabha ejhe ulimwengu ukabhachukila. ");
INSERT INTO kiz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mkhombokayi lilobhi lya nabhajobhili, 'N'tumwa mbaha lepi kuliko bwana ghwa muene.' Ikajhelayi bhanitesisi nene, bhibetakubhatesya ni muenga pia; kama bhakamuili lilobhi lya nene, ngabhalikamuili lya jhomu pia. ");
INSERT INTO kiz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bhibetakubhabhombela mbombo agha ghoha kwandabha jha lihina lya nene, kwa ndabha bhammanyilepi jhola jhaanilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kama nganihidilepi ni kubhajobhela, ngabhajhelepi bhabhomba dhambi; lakini henu bhajhelepi ni udhuru kwa dhambi sya bhene. ");
INSERT INTO kiz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jhaakanida dila nene akan'dadila ni Dadi pia. ");
INSERT INTO kiz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ikajhiajhi nibhombilepi mbombo miongoni mwa bhene ambayo ajhelepi hata mmonga jha ajhibhombili, ngabhajhele bhaduli dhambi; lakini henu bhabhombili ghoha mabhele bhabhuene na bhanidadili nene ni Dadi jhangu. ");
INSERT INTO kiz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","E'le lihomlea ili lilobhi litimilayi ambalyo lilembibhu mu sheria sya bhene: 'Bhakanidadila nene bila sababu.' ");
INSERT INTO kiz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Wakati mfariji ahidili, ambajhe nikandaghisya kwa muenga kuhomela kwa Dadi, ojho ndo, Roho ghwa kweli, ambajhe ihomela kwa Dadi, ibetakunishuhudila. ");
INSERT INTO kiz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Namu pia mwibetakunishuhudila kwa ndabha nijhele pamonga nani kuhomela kubhwandelu. ");
INSERT INTO kiz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nibhajobhili mambo agha ili msibhwesi kukwazibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bhibeta kubhapisya kwibhala mu masinagogi; hakika saa jhihida ambajho khila jha ibetakubhakhoma ibetakufikiri ibhomba mbombo jhinofu kwa ndabah jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bhibetakubhabhombela mambo agha kwa ndabha bhammanyilepi Dadi wala bhanimanyilepi nene. ");
INSERT INTO kiz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nibhajobhili mambo agha ili kwamba wakati ukafikayi ghwa agha kutokela, mwibhwesya kughakhomboka na jinsi kyanibhajobhili mubhwesiajhi bhene. Nabhajobhilepi kuhusu mambo agha kuh'omela kubhwandelu kwa ndabha najhele pamonga namu. ");
INSERT INTO kiz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Japokujha, henu nilota kwa jhola jhaanilaghisi; lakini ajhelepi kati jha muenga jha akanikota, “Wilotandakhu?” ");
INSERT INTO kiz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa ndabha nijobhili malobhi agha kwa muenga, huzuni imemili mu mioyo jha jhomu. ");
INSERT INTO kiz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hata naha, nikabhajobhela ukweli: ni vyema kwa muenga nikabhokayi; kwa ndabha nikabelakubhoka, mfariji ibetalepi kuhida kwa muenga; lakini nikalotayi nibetakundaghisya kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Akahidayi, mfariji ojhu ibetakuubitisha ulimwengu kuhusiana ni dhambi, kuhusiana ni haki na kuhusiana ni hukumu. ");
INSERT INTO kiz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kuhusiana ni dhambi, kwa ndabha bhabelikunikiera nene, ");
INSERT INTO kiz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kuhusiana ni haki, kwa ndabha nilota kwa dadi, na mwibetalepi kunibhona kabhele' ");
INSERT INTO kiz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ni kuhusiana ni hukumu kwa ndabha mbaha ghwa ulimwengu obho ahukumibhu. ");
INSERT INTO kiz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nijhenaku mingi gha kubhajobhela, lakini mwibetalepi kughatekelesya henu. ");
INSERT INTO kiz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini, muene, Roho ghwa kweli, akahidayi, ibetakubhalongosya mu bhukweli ghoha; kwa kujha ibetalepi kulongela kwa ndabha jha muene; lakini ghoha ghaibetakughap'eleka, ibetakughajobha mambo aghu; na ibetakughadhihirisha kwa jhomu mambo agha ghaghibetakuhida. ");
INSERT INTO kiz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Muene jha ibetakunitukusya nene, kwa ndabha ibetakughatola mambo ghangu ni kughatangasya kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fenu fyoha fya ajhenafu Dadi ndo fya nene; henu, nijobhili kujha Roho ibetakutola mambo ghangu ni kughadhihirisha kwa muenga. ");
INSERT INTO kiz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bado muda bhufupi, mwibetalepi kunibhona kabhele; ni baada jha muda bhufupi kabhele, mwibetakunibhona.” ");
INSERT INTO kiz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Baadhi jha bhanafunzi bha muene bhakajobhesana, “Kiki yaakatujobhela, “muda bhufupi, na mwibetalepi kunibhona kabhele,' na, kisha, mda bhufupi mkanibhona,' na, 'kwandabha nilota kwa Dadi?” ");
INSERT INTO kiz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Henu, bhakajobha, 'Khenu kheleku kyaijobha, 'Bado mda mfupi'? Tumanyilepi kyaijobha. ");
INSERT INTO kiz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu abhuene bhinoghela kun'kota, ni muene akabhajobhela, “Mwikikota, mwe bhene kuhusu e'le, kyanijobhili, 'Bado mda mfupi, mwibetalepi kunibhona kabhele; na baada jha muda mfupi mwibetakunibhona'? ");
INSERT INTO kiz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aminiayi, aminiayi, nikabhajobhela, mwibetakulela ni kuombolesya, lakini ulimwengu wibetakushangilila, mwibetakujha ni huzuni lakini huzuni jha muenga ibetakugeuka kujha furaha. ");
INSERT INTO kiz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","N'dala ijha ni huzuni wakati paijha ni uchungu kwandabha wakati ghwa kwifungula ufikili; lakini paikifungula muana, ikhomboka lepi kabhele maumivu kwandabha jha furaha jha muene kwamba muana ahogoliki pa duniani. ");
INSERT INTO kiz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Muenga mujheni huzuni henu, lakini nibetakubhabhona kabhele; ni mioyo jha jhomu ibetakuhobhoka na ajhelepi jhaibeta kubhwesya kujhibhosya furaha jha muenga. ");
INSERT INTO kiz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ligono e'le mwibetata lepi kunikota maswali. Aminiayi, Aminiayi, nikabhajobhela, ");
INSERT INTO kiz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mkas'okayi kyokyoha kwa Dadi, ibetakubhap'ela kwa lihina lya nene; musokayi, namu mwibetakupokela ili kwamba furaha jha muenga ikamilikayi. ");
INSERT INTO kiz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nilongilili ni muenga kwa lugha jha jhibelikujhelebhweka, lakini saa jhihida ambapo nibetalepi kulongela kwa lugha jhajhiyeleweka lepi, lakini badala jhiake nibetakubhajobhela waziwazi kuhusu Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ligono e'lu mwibetakus'oka kwa lihina lya nene, na nikabhajobhela lepi kujha nibetakus'oka kwa Dadi kwa ndabha jha muenga; ");
INSERT INTO kiz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kwa kujha Dadi muene abhaganili kwandabha mniganili nene na kwandabha muniamini kujha nihomili kwa Dadi. ");
INSERT INTO kiz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nah'omili kwa Dadi na nahidili ku ulimwengu; kabhele, nibhoka ulimwenguni na nilota kwa Dadi”. ");
INSERT INTO kiz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bhanafunzi bha muene bhakan'jobhela, “Ghwilola, henu ghwilongela wazi wazi na witumila lepi mafumbo. ");
INSERT INTO kiz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Henu, tumanyili kujha umanyili mambo ghoha, na wilonda lepi munu jhejhioha akukotayi maswali. Kwandabha ejhe twikiera kujha ghwihomela kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akabhajibu, “Henu muamini?” ");
INSERT INTO kiz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Langayi, saa jhihida, ena na hakika jhifikili, ambapo mwibetakutabhwanyika khila mmonga ni kwa bhene mwibetakunileka najhoni. Lakini nijhelepi ne muene kwandabha Dadi ajhele nani. ");
INSERT INTO kiz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nikabhajobhela mambo agha ili kwamba mugati mwa nene mujhelayi ni amani. Duniani mujhe ni matatizo, lakini mukipelayi muoyo, nibhushindili ulimwengu. ");
INSERT INTO kiz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu aghajobhili mambo agha; kisha akajhinula mihu gha muene kulotela kumbinguni ni kujobha, “Dadi saa jhiwadili; n'tukusijhi mwanabhu ili ni muana ni muene akutukusiajhi bhebhe - ");
INSERT INTO kiz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kama vile kyaghwampelili mamlaka juu jha fyoha fya fijhe ni mb'ele ili abhapelayi uzima bhwa milele bhala bhoha bha wampelili. ");
INSERT INTO kiz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Obhu ndo uzima bhwa milele: kujha bhakumanyayi bhebhe, K'yara ghwa bhukweli ni ghwa pamisa, ni muene jhaandaghisi Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nakutukusili hapa duniani, ni kujhikamilisya mbombo jha wanipelili kujhibhomba. ");
INSERT INTO kiz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Henu, Dadi, unitukusiajhi nene pamonga ni bhebhe kwa bhutukufu bhola bhwa najhenabhu pamonga ni bhebeh kabla jha ulimwengu kubhombibhwa. ");
INSERT INTO kiz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nalifunuili lihina lya bhebhe kwa bhanu lya wanipelili hapa pa duniani. Bhajhele bhanu bha jhobhi; lakini ghwanikabidhi nene. na bhene bhalikamuili lilobhi lya jhobhi. ");
INSERT INTO kiz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Henu bhamanyili kujha khila khenu kya unipelili nene kihomela kwa bhebhe, ");
INSERT INTO kiz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kwa malobhi ghala ghawanipelili nene— Nimalikubhapela bhene malobhi aghu. Bhaghapokili ni kweli bhamanyili jha kujha bhebhe ndo jha unilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nikabhas'omela bhene. Nikabhusomela lepi ulimwengu bali bhala bha unipelili kwa kujha bhene bha jhobhi. ");
INSERT INTO kiz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Fenu fyoha ambafyo fya nene ndo fya jhobhi, ni fela fya ujhe nafu bhebhe fya nene; nani nitukusibhwa kwa e'lu. ");
INSERT INTO kiz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nene nijhelepi kabhele ulimwenguni, bali bhanu bhajhele ulimwenguni, nani henu nihida kwa bhebhe. Dadi Mtakatifu, bhatunzayi kwa lihina lya jhobhi lela lya wanipelili tete, ili nabhene bhajhelayi ni umoja, kama vile nene ni bhebhe kyatujhele ni umoja. ");
INSERT INTO kiz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bho nijhe nabhu, nabhalendili kwa lihina lya wanipelili, nabhalendili na ajhelepi hata mmonga ghwa bhene jha ajhaghili isipokujha mwana upotevu, ili kwamba maandiku ghatimilayi. ");
INSERT INTO kiz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Henu nihida kwa bhebhe; lakini nijobha agha ulimwenguni ili kwamba furaha jha nene ikamulisibhwayi mugati mwa bhene. ");
INSERT INTO kiz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nibhapelili lilobhi lya bhebhe; ulimwengu ubhadadili kwandabha bhenye bha ulimwenguni ubhadadili kwandabha bhene bha ulimwengu lepi, kama vile nene kyanijhelepi ghwa ulimwengu ");
INSERT INTO kiz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nikabhaombela lepi kujha ubhabhosiajhi ku ulimwengu bali ubhalendayi ni jhola mwovu. ");
INSERT INTO kiz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bhene sio bha dunia kama vile nene kyanibelikujha ghwa ulimwengu. ");
INSERT INTO kiz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ubhabhekayi bhakfu kwa jhobhi ghwa muene mu bhukweli; lilobhi lya jhobhi ndo bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wanilaghisi ku ulimwengu, nani nibhalaghisi ku ulimwengu. ");
INSERT INTO kiz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwa ndabha jha bhene nene ne muene nikipisya kwa bhebhe ili kwamba ni bhene bhakipisyayi kwa bhebhe ku bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sio abha tu bhanikabhas'okela, bali ni bhala bhabhibeta kukiera kup'etela lilobhi lya bhene ");
INSERT INTO kiz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ili kwamba nabhene bhajhelayi ni umoja, kama vile bhebhe Dadi, ujhe mugati mwa nene nani mugati mwa bhebhe. Nikabhasokela ili kwamba bhene pia bhajhelayi mugati mwa tete ili ulimwengu ubhwesujhi kukiera kujha bhebhe ndiye jha unilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Utukufu bhola bhwa unipelili nene - nibhapelili bhene, ili kwamba bhabhwesiayi kujha ni umoja kama vile tete kyatujha ni umoja ");
INSERT INTO kiz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","-Nene mugati mwa bhene, nabhi mugati mwa nene, ili bhabhwesijhi kukamilisibhwa mu umoja; ili ulimwengu umanyayi kujha hakika bhebhe ndiye jha unitumili, ni kubhagana, kama vile bhebhe kyauniganili, nene. ");
INSERT INTO kiz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dadi khela kya unipelili nene - Ninoghela kujha bhene pia bhabhwesiajhi kujha pamonga nani mahali pa nijhele ili bhabhwesiayi kulola utukufu bhwa nene, bhola unipelili: kwa kujha bhebhe ghwaniganili nene kabla jha kubhomb'eka kwa misingi jha ulimwengu. ");
INSERT INTO kiz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dadi jha ujhe ni haki, ulimwengu bhwakumanyilepi bhebhe, lakini nene nikumanyili bhebhe; na bhamanyili kujhe ghwanilaghisi. ");
INSERT INTO kiz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nalibhombili lihina lya bhebhe limanyikinayi kwa bhene, na nibetakulibhomba limanyikinayi ili kwamba l'ela lipendo ambalyo kwa jhobhi ghwaniganili nene libhweajhi kujha mugati mwa bhene, ni nene nibhwesiajhi kujha mugayi mwa bhene.” ");
INSERT INTO kiz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Baada jha Yesu kujobha malobhi agha, akabhoka ni bhanafunzi bha muene kul'otela bonde lya Kidron, ambako kwajhele ni bustani, ambako muene ni bhanafunzi bha muene bhakajhingila mugati. ");
INSERT INTO kiz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Henu Yuda, jhola jhaalondeghe kun'saliti, ni muene alimanyili lilobhi e'lu, kwani Yesu ajhele illota lieneo lela mara kadhaa ni bhanafunzi bha muene, ");
INSERT INTO kiz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ni muene Yuda baada jhakubhona akabhili likundi lya maaskari ni maofisa kuhomela kwa bhabhaha bha makuhani, bhakahida ni taa, kurunzi ni silaha. ");
INSERT INTO kiz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nu muene Yesu, akajha amanyili khila khenu kyakibhombeleghe dhidi jha muene, akakitokesya pa longolo ni kubhakota, “Niani mukandonda?” ");
INSERT INTO kiz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ni bhene bhan'jibili, “Yesu Mnazareth.” Yesu akabhajobhela, “Ndo nene” Ni muene Yuda jha an'saliti, ajhele ajhemili pamonga ni bhala askari. ");
INSERT INTO kiz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Henu bho abhajobhili, “Ndio nene” bhakerebhuiki kinyume bhakabina pasi. ");
INSERT INTO kiz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Halafu akabhakota kabhele, “Niani mukandonda? Ni bhene bhakan'jibu kabhele “Yesu mnazareth.” ");
INSERT INTO kiz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akabhajibu, “Nimalili kubhajobhela Ndio nene; henu kama mkanilonda nene, mubhalekayi bhangi abha bhalotayi.” ");
INSERT INTO kiz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Agha ghajhele naha ili lilobhi lela litimilikayi; pa ajobhi pala; “Katika bhaukanipelili, nikanjasilepi hata mmonga.” ");
INSERT INTO kiz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ndipo Simoni Petro, jha ajhele ni upanga akaufuta ni kun'dumula mb'olokoto lya kulia n'tumishi ghwa Kuhani mbaha. Ni lihina lya muene n'tumishi jhola lya jhele Malko. ");
INSERT INTO kiz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu akan'jobhela Petro, “Ubhukerusiajhi upanga ghwa jhobhi mu ala jhike. Kwa ndabha jha kiki nisikinyweli kikombi khela kyaanipelili Dadi?” ");
INSERT INTO kiz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Basi likundi lela lya askari ni jemedari, ni bhatumishi bha Bhayahudi, bhan'kamuili Yesu ni kun'konga. ");
INSERT INTO kiz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na bhene bhandonguisi mpaka kwa Anasi, kwani muene ajhele mkwe ghwa Kayafa, ambaye ajhele Kuhani mbaha kwa mwaka obhu. ");
INSERT INTO kiz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Henu Kayafa ndo abhapelili ushauri Bhayahudi jhi kujha jhilondeka munu mmonga afuayi kwa ndabha jha bhanu. ");
INSERT INTO kiz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petro an'kesisi Yesu, mebhu ni bhanafunzi bhangi. Ni mwanafunzi jhola jha amanyikene kwa kuhani mbaha, ni muene akajhingila pamonga ni Yesu mu libehewa lya kuhani mbaha; ");
INSERT INTO kiz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","lakini Petro ajhemili kwibhala kundiangu. Mwanafunzi jhola jha amanyikene kwa kuhani mbaha apitili kwibhala akalota kulongela ni n'dala jhola n'tumishi jhaalendeghe ndiangu ni kunjhingisya Petro mugati. ");
INSERT INTO kiz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Basi kijakazi jhola jha alandeghe pandiangu, an'jobhili Petro, “Je bhebhe sio ndo mmonga ghwa bhafuasi bha munu ojho?” Ni muene akajobha, “Ne lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ni bhala bhatumishi ni bhabhaha bhajhemili mahali pala, bhakajha bhakosili muoto bhijhota kwa ndabha kwa jhele ni mepu, bhakajha bhijhota ili kukabha joto. Ni Petro ajhenabhu ijhota muoto ajhemili. ");
INSERT INTO kiz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kuhani mbaha akan'kota Yesu juu jha bhanafunzi bha muene ni mafundisu gha muene. ");
INSERT INTO kiz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akajibu, “Nibhujobhili waziwazi bhulimwengu; Nene nafundisi mara kwa mara mu masinagogi ni mahekalu mahali ambapo bhayahudi bhikusanyika. Nani najobhilepi lyolyoha kwa kufigha. ");
INSERT INTO kiz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwandabha jha kiki mwanikotili? Mubhakotayi bhabhanip'elekisi juu jha khela kya nikijobhili. Bhanu abha bhamanyili mambo ghala ghanighajobhili. ");
INSERT INTO kiz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu bho amalikujobha aghu, mmonga ghwa bhabhaha jha ajhemili akan'tobha Yesu kwa kibhoko kya muene ni kujobha, “Je, ndo jhilondeka naha kun'jibu kuhani mbaha?” ");
INSERT INTO kiz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ni Yesu akan'jibu, “Kama nijobhili lijambo lyolyoha linofu lepi basi ujhelayi shahidi kwa ndabha jha uovu, na kama nirijibili kinofu kwandabha jha kiki ukanitobha? ");
INSERT INTO kiz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ndipo Anasi ampeliki Yesu kwa Kayafa kuhani mbaha khoni akongibhu. ");
INSERT INTO kiz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Henu Simoni Petro akajha ajhemili ijhota muoto. Halafu bhanu bhala bhakan'jobhela. “Je, bhebhe pia si mmonga ghwa bhanafunzi bha muene?” Akabele akajobha “Nene lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mmonga ghwa bhatumishi bha kuhani mbaha ambajhe ajhele ndongomunu ghwa jhola jha adumulibhu mbolokhoto ni Petro akajobha, “Je sio bhebhe nikakubhwene naku ku bustani?” ");
INSERT INTO kiz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro akabela kabhele, ni mara likongobhe likabheka. ");
INSERT INTO kiz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kisha bhakan'tola Yesu kuhoma kwa Kayafa mpaka ku Praitorio. Kwajhelukhela lubhuliku. Bhabhu bhene bhaijhingi lepi jhela Praitorio ili bhasihidi bhakanajisika ni kujhilya pasaka. ");
INSERT INTO kiz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Henu Pilato akabhalotela akajobha. “Lishitaka lelekhu lyalikan'husu munu ojho?” ");
INSERT INTO kiz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bhakan'jibu ni kun'jobhela, “Munu ojho nga ajhiabhombi lepi makosa ngatundetili lepi kwa bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato akabhajobhela, “Mun'tolayi mwejhomu, mukan'hukumuayi kul'engana ni sheria jha muenga.” Ni bhene Bhayahudi bhakan'jobhela, “Sheria jhikaturuhusu lepi tete kun'koma munu jhejhioha.” ");
INSERT INTO kiz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bhajobhili agha ili lilobhi lya Yesu litimilikayi, lilobhi ambalyo amalikujobha juu jha aina jha kifo kya kya muene. ");
INSERT INTO kiz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Basi Pilato akajhingila kabhele Praitorio ankutilepi Yesu; akan'jobhela, “Je, bhebhe ndo mfalme ghwa Bhayahudi?” ");
INSERT INTO kiz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu an'jibili, “Je, bhebhe ukanikota lisuali e'le kwa ndabha wilonda kumanya au kwandabha bhangi bhakutumili ili unikotayi nene?” ");
INSERT INTO kiz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ni muene pilato akan'jibu, “Nene na Myahudi, au lepi?” Litaifa lya bhebhe ni kuhani mbaha ndo bhakuletili kwa nene; bhebhe uketili kiki? ");
INSERT INTO kiz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akajibu; “Ufalme bhwa nene sio bhwa ulimwengu obho, kama ufalme bhwa nene ngabhujhele bhwa ulimwengu obho bhatumwa bha nene ngabhajhemili ili nisibhekibhu kwa bhayahudi. Kwa kweli ufalme bhwa nene bhwihomela lepi apa” ");
INSERT INTO kiz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Basi Pilato akan'jobhela, “Je, bhebhe wa mfalme?” Yesu akajibu, “bhebhe ndo kya wijobha kujha nene na mfalme, Kwandabha ejhe nene nahogoliki na kwandabha nene nihidili pa ulimwengu ili nijhelayi shahidi ghwa kweli jhela. Jhejhioha jha ajhele ghwa ejhu kweli akajhipelekesya sauti jha nene. ");
INSERT INTO kiz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato akan'jobhela, “Kweli ndo kiki?” Ni muene bho amalikujobha agha akalota kwa Bhayahudi ni kujobha “Nikalibhona lepi likosa lyolyoha kwa munu ojho. ");
INSERT INTO kiz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Muenga mujhele ni utamaduni bhwa ukanifuanya nimfungulilayi mfungwa mmonga wakati wa Pasaka. Je mwilonda nibhafungulilayi mfalme ghwa Bhayahudi.” ");
INSERT INTO kiz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kisha bhapigili majhuegha bhakajobha, ojho lepi, tufungulilayi Baraba.” Ni muene Baraba ajhele mnyang'anyi. ");
INSERT INTO kiz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Basi Pilato akan'tola Yesu ni kun'tobha. ");
INSERT INTO kiz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Maaskari bhala bhakasokota mifwa ni kutengenesya litaji. Bhakaibheka panani pa mutu ghwa Yesu ni kumfwatika liguanda lya zambarau. ");
INSERT INTO kiz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakan'hidila ni kujobha, “Bhebhe mfalme ghwa Bhayahudi! na kisha kun'tobha kwa mabhokho gha bhene. ");
INSERT INTO kiz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kisha Pilato akahoma kwibhala ni kubhajobhela bhanu, “Lngayi nikabhaletela kwa muenga munu ojho ila mumanya kujha nene nikajhibhona lepi hatia jha munu ojho.” ");
INSERT INTO kiz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Henu Yesu akapita kwibhala akajha afwalili litaji lya mifwa ni liguanda lya zambarau. Ndipo Pilato akabhajobhela, “Mulangayi munu ojho apa!” ");
INSERT INTO kiz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kwa hiyo wakati kuhani mbaha na bhabhaha bho bhambwene Yesu, wakapiga makele bhakajobha, “N'sulubisiajhi, n'sulubisiajhi.” Pilato akabhajobhela, “Mun'tolayi mwebhene mkan'sulubisiajhi, kwa ndabha nene nibhonalepi hatia kwa muene.” ");
INSERT INTO kiz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bhayahudi bhakan'jibu Pilato, “Tete tujhe ni sheria, ni kwa sheria ejhe jhilondeka afuayi kwandabha muene akibhekeghe mwana ghwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato bho ap'eliki malobhi agha azidi kutila, ");
INSERT INTO kiz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","akajhingila Praitorio kabhele ni kun'jobhela Yesu, “Bhebhe wihomela ndaku? Hata naha, Yesu an'jibi lepi. ");
INSERT INTO kiz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kisha Pilato akan'jobhela, “Je, bhebhe wilongela lepi ni nene? Je, bhebhe umanyilepi kujha nene nijhe ni mamlaka gha kusulubisya?” ");
INSERT INTO kiz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akan'jibu, “Ngaujhelepi ni nghofu dhidi jha nene kama ngaupelibhu lepi kuhomela kunani. Henu, munu jha anipisili kwa bhebhe ajhe ni dhambi mbaha.” ");
INSERT INTO kiz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kutokana ni lijibu e'le, Pilato alondeghe kundeka huru, lakini Bhayahudi bhakapiga majhueghu bhakajobha, “Kama wibetakundeka huru basi bhebhe sio rafiki ghwa Kaisari: Kila jhaikibheka mfalme ilota kinyume ni Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato bho aghapeliki malobhi agha, akandeta Yesu kwibhala kisha akatama pa kiti kya hukumu mahali pala papimanyikana kama sakafu, lakini kwa Kiebrania, Gabatha. ");
INSERT INTO kiz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ligono lya maandalizi gha pasaka bho bhifikili, muda ghwa saa sita. Pilato akabhajobhela Bhayahudi, “Mulangayi mfalme ghwa jhomu ojho apa!” ");
INSERT INTO kiz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bhakapiga makelele, “Umbosiajhi, umbosiajhi, un'sulubisiajhi!” Pilato akabhajobhela, “Je, nin'sulubusuajhi mfalme ghwa jhomu?” Ni muene Kuhani mbaha akajibu, “Tete tujhelepi ni mfalme isipokujha Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndipo Pilato akandeta Yesu kwa bhene ili asulubibhwayi ");
INSERT INTO kiz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na bhene bhakantola Yesu, ni muene akapita, hali aup'endili n'salaba ghwa muene mpaka ku lieneo lyalikutibhwa fuvu lya mutu, kwa Kihebrania likutibhwa Golgotha. ");
INSERT INTO kiz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ndipo pa bhan'sulubisi Yesu, pamonga ni bhagosi bhabhele, mmonga lubhafu olo ni jhongi lubhafu olo, ni Yesu katikati jha bhene. ");
INSERT INTO kiz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kisha Pilato akajhandika alama ni kujhibheka panani pa n'salaba. Apu pajhandikibhu: YESU MNAZARETH, MFALME GHWA BHAYAHUDI. ");
INSERT INTO kiz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bhayahudi bhingi bhaisomili alama jhela kwani mahali pala pa asululibibhu Yesu pajhele karibu ni mji. Alama ejhu jhalembibhu Kiebrania, kwa Kirumi ni kwa Kiyunani. ");
INSERT INTO kiz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kisha bhabhaha bha makuhani ghwa Bhayahudi bhakan'jobhela Pilato, “Usilembi, 'Mfalme ghwa Bhayahudi; bali muene ajobhili nene ndo mfalme ghwa Bhayahudi.” ");
INSERT INTO kiz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ni muene Pilato akabhajibu, “Ghanijhandiki nijhandiki.” ");
INSERT INTO kiz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Baada jha askari kun'sulubisya Yesu, bhakatola mavazi gha muene ni kughagabha katika mafungu mancheche, khila askari lifungu limonga, fefuefu ni kanzu, Henu kanzu jhela jhashonibhu lepi bali jhafumibhu jhioha kuhomela kunani. ");
INSERT INTO kiz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kisha bhakajobhesana bhene kwa bhene, “Tusijhikachuli, bali tupigayi kura ili tulolayi jhibetakujha jha niani?” Ele lyahomili ili lela liandiku litimizwajhi, lela lya lijobha bhagabhenye nghobho syangu, ni liguanda lya nene bhalipigili kura.” ");
INSERT INTO kiz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Askari abhombi mambo agha. Nyinamunu Yesu, ndombo munu nyina ghwa Yesu, Mariamu n'dala ghwa Kleopa ni Mariamu Magdalena - bhadala abha bhajhele bhajhele bhajhemili karibu ni n'salaba ghwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu bho ambwene nyinamunu ni jhola mwanafunzi jhaan'ganili bhajhemili karibu akan'jobhela nyinamunu, “N'dala, langayi, mwanabhu ojho apa!” ");
INSERT INTO kiz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kisha akan'jobhela jhola mwanafunzi, “Langayi, ojho apa nyinu waku. “Kuhomela saa ejhu mwanafunzi jhola akan'tola kulota kunyumba kwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Baada jha e'lu, Hali Yesu amanyili kujha ghoha ghamaliki ili kutimisya maandiku, akajobha, “Nibhona kiu,” ");
INSERT INTO kiz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Khenu kyakikamemili Siki kyabhekibhu pala, henu bhakabheka sifongo jhajhimemili siki panani pa ufito ghwa hisopo, bhakambekela mundomo mwa muene. ");
INSERT INTO kiz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ni muene Yesu bho ajhibhonjili ejhu, akajobha, “Imaliki.” Kisha akajhinamisya mutu ghwa muene akajhikabidhi roho jha muene. ");
INSERT INTO kiz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kwa vile bhwajhele bhwakati bhwa maandalio, ni kwam ndabha mibhele jhilondekeghe lepi kubakila panani pa n'salaba wakati bhwa Sabato (kwa kujha Sabato jha jhele ligono lya muhimu), bhayahudi bhan'sokili Pilato kujha magolo gha bhene bhala bhabhasulubisibhu idenyibhwayi, ni kwamba mibhele ghya bhene iselesibhwayi. ");
INSERT INTO kiz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ndipo askari bhakahida ni kudenya magolo gha munu ghwa kwanza ni ghwa pili bhabhasulubisibhu pamonga ni Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bhobhamfikirir Yesu bhan'kolili tayari amali kufwa, henu bhakadenya lepi magolo gha muene. ");
INSERT INTO kiz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Hata naha, mmonga ghwa askari akan'homa Yesu ng'oha mu mbafu ni mara jhikahoma masi ni damu. ");
INSERT INTO kiz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni muene jha alibhwene lela ahomisi bhushuhuda, ni bhushuhuda bhwa muene bhwa kweli. Muene amanyili kyaajobhili kya bhukweli ili namu pia mukierayi. ");
INSERT INTO kiz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mambo agha ghajhele ili lela lyalyanenibhu libhwesiyi kutimila, “Bhujhele hata umonga bhwa bhwibetakudenyibhwa.” ");
INSERT INTO kiz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kabhele liandiku lenge lijobha, “Bhibetakundangamuene jha ahomibhu” ");
INSERT INTO kiz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baada jha mambo agha Yusufu ghwa Arimathaya, kwa vile ajhele mwanafunzi ghwa Yesu, lakini kwa siri kwa kubhatila Bhayahudi, an'sokili Pilato kujha autolayi mb'ele bhwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ni muene Pilato akampela ruhusa. Henu Yusufu akahida kuubhosya mb'ele ghwa Yesu. Ni muene Nicodemo ambajhe kubhwandelu an'kesisi Yesu pakilu ni muene akahida. Muene aletili mchanganyiiku ghwa manemane ni udi, kama uzito ghwa ratili mia moja. ");
INSERT INTO kiz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Henu bhakautola mb'ele ghwa Yesu bhakaukonga sanda jha kitani ni pamonga ni ghala manukato, kama kyajhikajhele desturi jha bhayahudi wakati wa kusiela. ");
INSERT INTO kiz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mahali ambapo Yesu asulubisibhu kwajhele ni bustani; mugati mu jhela bustani kwajhele ni likaburi lipya ambalyo ajhelepi munu ambajhe abhwajhili kusyelibhwa omu. ");
INSERT INTO kiz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Basi, kwa kujha jhajhele ligono lya maandalio kwa Bhayahudi, ni kwa vile lela likaburi lyajhele karibu, basi bhakan'goneka Yesu mugati omu. ");
INSERT INTO kiz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Manyata ligono lya kuanza lya juma lubhuliku Mariamu Magdalena ahidili kulikaburi akalibhona liganga lele libhosibhu pa likaburi. ");
INSERT INTO kiz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kwa iyo akajumba mbio kulota kwa Simoni Petro ni kwa jhola mwanafunzi jhongi ambajhe Yesu an'ganili, kisha akabhajobhela, “bhan'tolili Bwana mu likaburi, natu tumanyilepi kwa bhambekili.” ");
INSERT INTO kiz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kisha Petro ni jhola mwanafunzi jhongi bhakabhoka, kulotela kulikaburi. ");
INSERT INTO kiz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhoha bhakajha bhijumba kwa pamonga; mwanafunzi jhongi jhola ajumbili nesu kuliko Petro ni kubhwayi kufika kulikaburi. ");
INSERT INTO kiz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akajhema na kisha kuhongolela mu likaburi; akajhibhona sanda jhela jha kitani jhigonili, lakini ajhingilepi mugati. ");
INSERT INTO kiz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kisha Simoni Petro ni muene akahida akajhingila mugati mu likaburi. Akajhibhona sanda jha kitani jhela jhigonili pala ");
INSERT INTO kiz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni leso jhela jhajhele pamuto pa muene jhajhelepi pamonga ni sanda jha kitani bali jhajhele jhigonili pa lubhafu. ");
INSERT INTO kiz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ndipo mwanafunzi jhongi jhola ni muene akajhingila mu likaburi; akalola ni kukiera. ");
INSERT INTO kiz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwa kujha hadi wakati obhu bhajhele bhaghamanyilepi maandiku kwamba ilimlazimu Yesu afufukayi kabhele katika bhafu. ");
INSERT INTO kiz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kisha bhanafunzi bhakalota kabhele kunyumba jha bhene. ");
INSERT INTO kiz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hata nahu, Mariamu ajhele ajhemili pa likaburi ilela, bho ijhendelela kulela akajhema kisha akalanga mulikaburi. ");
INSERT INTO kiz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akabhabhona malaika bhabhele bhenye sura sibhalafu bhatamili mmonga kumutu ni jhongi kumagolo mahali ambapo Yesu agonili. ");
INSERT INTO kiz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na bhene bhakan'jobhela, “N'dala, kwandabha jha kiki ghwilela?” Ni muene akabhajobhela, “Kwa ndabha bhan'tolili Bwana ghuangu, nani nimanyilepi kwa bhamp'ekili.” ");
INSERT INTO kiz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bho amalikujobha aghu, ageuiki ni kumbona Yesu akajha ajhemili. Lakini amanyilepi kujobha ojhu ajhele Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ni muene Yesu akan'jobhela, “Mabhu, kwa ndabha jha kiki wilela? Ukandonda niani?” Ni muene khuni akajha amanyili kujha ndo mtunza bustani akan'jobhela, “Bwana, kama ndo bhebhe un'tolili, nijobhelayi kwa umb'ekili, ni nene nibetakun'tola.” ");
INSERT INTO kiz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu akan'jobhela, “Mariamu.” Ni muene akageuka muene ni kun'jobhela kwa Kiaramu, “Raboni,” yaani sawa nikujobha, “Mwalimu.” ");
INSERT INTO kiz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu akan'jobhela, “Usinigusi, kwani bado nakona kupaa kulota kwa dadi; bali ulotayi kwa bhalongobhangu ukabhajobhelayi kujha nibetakupaa kulota kwa Ddadi jhangu ambajhe pia ndo Dadi jhinu, K'yara ghwa nene na K'yara ghwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariamu Magdalena akahida kubhajobhela bhanafunzi, “Nimbwene Bwana,” na kwamba an'jobhili mambo agha. ");
INSERT INTO kiz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na bho jhifikili kimihi, ligono elu, ligono lya kuanza lya juma, ni milyangu jhikajha jhidendibhu mahali ambapo bhanafunzi bhajhele kwa kuhofela Bhayahudi, Yesu akahida ni kujhema katikati jha bhene ni kubhajobhela, “Amani ijhelayi kwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bho amalikujobha aghu akabhalasya mabhokho gha muene ni lubhafu kwa muene. Na bhene bhanafunzi bho bhambwene Bwana bhahobhelili. ");
INSERT INTO kiz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kisha Yesu akabhajobhela kabhele, “Amani ijhelayi namu. Kama vile Dadi kyaanilaghisi nene, fefuefu nani nikabhatuma muenga.” ");
INSERT INTO kiz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu bho amalili kujobha aghu akabhavuvila akabhajobhela, Mupokelayi Roho Mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jhejhioha jha mwibetakun'samehe dhambi, bhasamehibhu; ni bhala bha mwibetakubhafungila bhafungibhu.” ");
INSERT INTO kiz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomaso, mmonga wa bhala kumi ni bhabhele, jhaakutibhu Dididmas, ajhelepi ni bhanafunzi bhajhinu Yesu bho ahiodili. ");
INSERT INTO kiz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bhanafunzi bhangi bhala bhakan'jobhela baadajhe, “Tumbwene Bwana.” N i muene akabhajobhela, “Kama nibetalepi kubhona alama sya misumari mu mabhoko gha muene, ni kubheka fikonji fya nene mu alama e'su, na pia kubheka kubhoko kyangu mu lubhafu kwa muene nibetalepi kukiera.” ");
INSERT INTO kiz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Baada jha magono nane bhanafunzi bhajhele kabhele mu kichumba, ni Thomaso ajhele pamonga nabhu. Wakati miliangu idendibhu Yesu ajhemili katikati jha bhene na akajobha, “Amani na ijhelayi kwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kisha akan'jobhela Thomaso, letayi kikonyi kya jhobhi na ulotayi mabhoko ghangu; letayi apa mabhoko gha jhobhi na ubhekayi mu lubhafu lwa nene; wala usijhi jhaibetakukiera bali jhaikiera.” ");
INSERT INTO kiz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ni muene Thomaso akajibu ni kun'jobhela, “Bwana ghuangu ni K'yara ghuangu.” ");
INSERT INTO kiz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu akan'jobhela, Kwa kujha unibhwene, ukieriri. Bhabarikibhu bhene bhabhikier, bila kubhona.” ");
INSERT INTO kiz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kisha Yesu abhombi ishara simehele mbele jha bhanafunzi, ambasyo sibhwajhilepi kulembibhwa mu kitabu ekhe; ");
INSERT INTO kiz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","bali e'se silembibhu ili kwamba mubhwesyayi kukiera kwamba Yesu ndo Kristu, mwana ghwa K'yara, na kwamba pamwikiera mujhiajhi ni uzima mu lihina lya muene. ");
INSERT INTO kiz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baada jha mambo aghu Yesu kwidhihirisha kabhele kwa bhanafunzi mu Bahari jha Tiberia; efe ndo kyaakidhihirishi muene: ");
INSERT INTO kiz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petro ajhele pamonga ni Thomaso jhaakutibhweghe Didimas, Nathanaeli ghwa Kana jha Galilaya, bhana bha Zebedayo ni bhanafunzi bhangi bhabhele bha Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petro akabhajobhela, “Nene nilota kulobha somba.” Ni bhene bhakan'jobhela, “Tete, pia twilota pamonga ni bhebhe.” Bhakalota bhakajhingila mu mashua, lakini kinu kyoha eku bhakilepi khenu. ");
INSERT INTO kiz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ni lukhela bho kubhalele, Yesu ajhemili kundema, na bhene bhanafunzi bhamanyilepi kujha ndo Yesu. ");
INSERT INTO kiz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kisha Yesu akabhajobhela, “Bhasongolo, mujhe ni kyokyoha kya kulya?” Na bhene bakan'jibu, “Lepi.” ");
INSERT INTO kiz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Akabhajobhela, “Muselesiajhi nkwabhu lubhafu kwa kuume bhwa mashua, na mu mwibeta kukabha kiasi.” Kwa hiyo bhakaselesya nkwabhu ni bhene bhabhwesilepi kufuta kabhele kwandabha jha bhwingi bhwa somba. ");
INSERT INTO kiz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Basi mwanafunzi jhola ambajhe Yesu an'ganili akan'jobhela Petro, “Ndo Bwana.” Ni muene Simoni Petro bho apeliki kujha ndo Bwana, akakikonga liguanda lya muene (ndabha alifwali lepi kinofu), kisha akakisopa mu masi. ");
INSERT INTO kiz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bhanafunzi bhangi bhala bhakahida mu mashua (kwani bhajhelepi patali ni pwani, kama mita mia moja kuhomela ufukweni), na bhene bhakajha bhifuta mikwabhu ghela ambaghyo ghyamemili somba. ");
INSERT INTO kiz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bho bhafikili ufukweni, bhaghubhwene muoto ghwa mkaa pala ni panani pa muene kwajhele ni somba pamonga ni mkate. ");
INSERT INTO kiz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu akabhajobhela, “Muletayi baadhi jha somba sya mulobhili henu naha.” ");
INSERT INTO kiz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Basi Simoni Petro akakuela ni kuukokota nkwabhu bhwa wamemili somba sibhaha, kiasi kya somba 153; japo bhajhebhingi, nkwabhu bhola bhwakachwiki lepi. ");
INSERT INTO kiz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu akabhajobhela, “Muhidayi mkabhayi kifungua kinywa.” Ajhelepi hata mmonga ghwa bhanafunzi jhaan'kotili, “Bhebhe ghwa niani?” Bhamanyili kujha ajhele Bwana. ");
INSERT INTO kiz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu akahida, akautola n'kate bhola, kisha akabhapela, akabhomba mebhu niku somba sela. ");
INSERT INTO kiz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ejhe jha jhele mara jha tatu kwa Yesu kwidhihirisha kwa bhanafunzi bha muene baada jha kufufuka kuhoma kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baada jha kufungula kinywa, Yesu akan'jobhela Simoni Petro, “Simoni mwana ghwa Yohana je, uniganili nene kuliko abha?” Petro akajibu, “Ena, Bwana; “Bhebhe umanyili kujha nene nikuganili.” Yesu akan'jobhela, “Lesyajhi bhanakondoo bha nene.” ");
INSERT INTO kiz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akan'jobhela mara jha pili, “Simoni mwana ghwa Yona, je, uniganili?” Petro akan'jobhela, “Ena, Bwana; bhebhe umanyili kujha nikuganili. “Yesu akan'jobhela, “Dimayi kondoo bhangu.” ");
INSERT INTO kiz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akan'jobhela kabhele mara jha tatu, “Simoni, mwana ghwa Yohana, Je uniganili?” Ni muene Petro ahuzuniki kwa vile kyaan'jobhili mara jha tatu, “Je Bhebhe uniganili?” Ni muene akan'jobhela, “Bwana, umanyili ghoha; umanyili kujha nikuganili.” Yesu akan'jobhela, Lesiajhi kondoo bha nene. ");
INSERT INTO kiz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aminiayi, aminiayi, nikujobhela, bho ghwen'songolo ghwasobhelili kufwala nghobho muene ni kulota kokuoha khola kwa ulondeghe; lakini paghwibetakujha ghwe nseya, ghwibetakugholosya mabhoko gha jhobhi, ni jhongi ibetakufwalika nghobho ni kukupeleka kwa ulondeghe lepi kulota.” ");
INSERT INTO kiz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu ajobhi agha ili kulasya ni aina jheleku jha kifo ambakyo Petro ngaan'tukuizi K'yara. Baada jha kujha ajobhili agha, akan'jobhela Petro, “Nikesiajhi.” ");
INSERT INTO kiz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro akageuka ni kumbona jhola mwanafunzi ambajhe Yesu an'ganili akabhakesya- Ojho ndo ajhele akijheghemisi mu kifua kya Yesu wakati wa kyakulya kya kimihi ni kun'kota, “Bwana, niani jhaibetakusaliti?” ");
INSERT INTO kiz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petro ambwene ni kisha akan'kota Yesu, “Bwana, Ojho munu ibetakubhomba kiki?” ");
INSERT INTO kiz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu akan'jibu, “Kama nilonda abakilayi mpaka pa nibetakuhida, e'lu likuhusu kiki?” Nikesiajhi.” ");
INSERT INTO kiz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kwa hiyo habari ejhe jhikaenela miongoni mwa bhala ndugu, kwamba mwanafunzi ojhui ibetalepi kufwa. Lakini Yesu an'jobhilepi Petro kujha, mwanafunzi ojhu ifwa lepi, “Kama nilonda muene abakilayi mpaka pa nibetakuhida ghikuhusu kiki?” ");
INSERT INTO kiz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ojho ndo mwanafunzi jhaibetakupisya ushuhuda bhwa mambo agha, na ndo jhaalembili mambo agha, na tumanyili jha kujha ushuhuda bhwa muene bhwa bhukweli. ");
INSERT INTO kiz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuna mambo ghangi ambagho Yesu aghabhombili. Kama kila limonga ngalijhandikibhu, nidhanila kwamba ulimwengu bhuene ngabhutoshilepi kufibheka fitabu ambafyo ngafilembibhu. ");
INSERT INTO kiz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kitabu kya muandi nakilembili, Theofilo nikajobha ghoha kwa yesu ghaabhanji kubhomba ni kumanyisya, ");
INSERT INTO kiz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka ligono muene apokelibhu kunani. Ej'ha jha jhele baada jha kupisya amri kup'etela Roho Mtakatifu kwa mitume bhabhajhele abhachaguili. ");
INSERT INTO kiz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Baada jha malombosi gha muene, abhonekane kwa bhene ajha hai pia ni fitishu fingi kushuhudibhwa. Kwa magono arobaini akidhihirishi kwa bhene, naa ajobhili kuhusu bhufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bhoibhonana nabhu abhajubhili bhasibhoki Yerusalemu, lakini bhalendayi kwa ndabha jha ahadi jha Dadi, ambajho ajobhili, “Mwaip'eliki kuhomela kwa nene. ");
INSERT INTO kiz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwamba Yohana abatili kwa masi, lakini mbatisibhwa kwa Roho Mtakatatifu mu magono agha madebe.” ");
INSERT INTO kiz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nabho bhabhonene pamonga bhakan'kota “Bwana, ivi obho ndo muda ambabho wibeta kubhakerebhusila Israeli bhufalme?” ");
INSERT INTO kiz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Muene akabhajobhela, “Sawalepi kwa muenga kumanya bhwakati au majira ambayo Dadi akusudili kwa mamlaka gha muene.” ");
INSERT INTO kiz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini mwibeta kupokela nghofu bhwakati Roho mtakatifu paibeta kuhida kwa mwenga, ni muenga mwibe kujha mashahidi bha nene kuoha Yeresalemu ni Uyahudi jhioha ni Samaria mpaka mwisho ghwa nchi.” ");
INSERT INTO kiz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bwana Yesu bho amalili kujobha agha, bhakaj'ha bhilanga kunani, muene ajhinulibhu kunani, ni libhengu lyan'gupiki bhasimboni kwa mihu gha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bhwakati bhilola kumbinguni ilota, ghafla bhanu bhabhele bhajhemili katikati jha bhene bhafwalili maguanda mabhalafu. ");
INSERT INTO kiz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bhakajobha, “Enyi bhanu bha Galilaya kwandabha jha kiki mwijhema apa mwilola kumbinguni.” Ojho Yesu jhaakwelili kunani kumbinguni ibeta kukerebhuka kwa namna jhela jhela kama kya mumbwene ilota kumbinguni. ");
INSERT INTO kiz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ndipo bhakakerebhuka Yerusalemu, kuhoma kukidonda kya mizeituni ambako okhu karibu ni Yerusalemu, mwendo ghwa ligono lya sabato. ");
INSERT INTO kiz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bho bhafihili bhakalota ghorofani ambako bhatamaghe. Nabhene ndo Petro, Yohana Yakobo, Andrea, Filipo, Thomaso, Bhatholomayo, Mathayo, Yakobo mwana ghwa Alfayo, Simoni Zelote ni Yuda mwana ghwa Yakobo. ");
INSERT INTO kiz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhoha bhaungene kama munu mmonga, kwa juhudi bhajhe bhijhendelela ni maombi pamonga ni abhu bhajhela bhadala, Mariamu nyinamunu Yesu nibhakaka yake. ");
INSERT INTO kiz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Katika magono ghala ajhemili katikati jha bhalongomunu, kama bhenu 120, akajobha. ");
INSERT INTO kiz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Bhalonho bhangu, jhahele lazima maandiku ghatimisibhwayi, ambapo muandi Roho Mtakatifu ajobhili kwa kinywa kya muene Daudi, kuhusiana ni Yuda, ambajhe abha jhekisi bhala bhabharikamuili Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kwa kujha muene ajhele mmonga bhitu na apokili fungu lya muene lye faida katika huduma ejhe.” ");
INSERT INTO kiz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Henu, munu ojho, ahemili lieneo kwa khela kya akipokili kwa uovu bhwa muene ni apuabinili kulongolasya mutu, mbhele ghwa kayuiki ni matumbu gha muene ghoha gajhele pabhwaka ghajhitiki. ");
INSERT INTO kiz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bhoha bha bhataniuli Yerusalemu bhabeliki kuhusu e'le, hivyo lieneo e'lu bhakalikuta kwa lihina lya bhene. “Akeldama” e'lu ndo “N'gonda ghwa damu.”) ");
INSERT INTO kiz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Mukitabu kya Zaburi ile mbibhu, lendayi eneo lya muene lijhelayi hame na asinihusibhu hata mmonga kutani apala, na Ruhusuajhi munu jhongi atolayi nafasi jha muenejha uongozi. ");
INSERT INTO kiz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ejhu, jha muhimu, henu, mmonga ghwa bhagosi ambabho bhalongosene ni tete bhwakati Bwana Yesu abhokili ni kujhingila kwa tete. ");
INSERT INTO kiz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kubhwanjila ku ubatisu bhwa Yohana mpaka ligono lela bho atwalibhu kunani lazima ajhelayi shahidi bhwa ufufuo pamonga ni tete. ");
INSERT INTO kiz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bhakabhabheka palongolo bhagosi bhabhele, Yusufu jhaakutibhweghe Barnaba ambaye pia akutibhu Yusto ni Mathia. ");
INSERT INTO kiz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bhene bhasokili bhajobhili, “Bhebhe Bwana, jhaumanyi mioyo jha bhanu bhoha hivyo bhekayi wazi jholeku kati jha bhabhele abha ambajhe un'chaguili. ");
INSERT INTO kiz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kutola nafasi katika huduma jha utume, ambapo Yuda abhombi uovu ni kulota mahali pa muene.” ");
INSERT INTO kiz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bhakapiga kura kwa ajili jha bhene, ni kura jhikanibinila Mathia ambajhe abhalangibhu pamonga ni bhala mitume kumi na moja. ");
INSERT INTO kiz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bho jhifikili ligono lya Pentekoste, bhoha bhajhele pamonga sehemu jhimonga. ");
INSERT INTO kiz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ghafla bwatokili muungurumo kuhomela kumbinguni kama mp'ongo n'kali. ");
INSERT INTO kiz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ukameme mu nyumba jhioha mwa bhatamili. Apo syabhatokili ndimi kama ndimi sya muoto sigabhwanyiki, sikajha panani pa bhene kwa khila mmonga. ");
INSERT INTO kiz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bhene bhoha bhakamemesibhwa ni Roho mtakatifu na bhakayanda kujobha kwa lugha s'enge, kama vile Roho mtakatifu kya abhajalili kujobha. ");
INSERT INTO kiz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Henu, bhahele bhayahudi bhabatameghe Yerusalemu, Bhacha K'yara kuhoma kila taifa pasi pa mbingu. ");
INSERT INTO kiz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ngurumo e'se bho sipelekibhu, likundi lya bhanu bhakahida pamonga ni bhakajha ni wasiwasi kwandabha khila munu abhapeliki bhilongela kwa kila munu ni lugha jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bhaduele ni kusyangasibhwa, bhene bhajobhili, “Kweli abha bhoha bhilongela bha Galilaya lepi mbona? ");
INSERT INTO kiz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kwa ndaya kiki tete tukabhap'heleka, kila mmonga ku lugha sya tuhogoliki nasu? ");
INSERT INTO kiz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bhapartia ni Bhamedi ni Bhaelamu, niabhu bhabitama Mesopotamia, Uyahudi, ni Kapodokia ni mu Ponto ni Asia, ");
INSERT INTO kiz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ku Frigia, Pamfilia, ku Misri ni sehemu jha Libya hata Kerene, nibhahesya kuh'omelaRumi, ");
INSERT INTO kiz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bhayahudi ni Bhaongofu Bhakrete ni Bhaarabu, tukabhap'eleka bhilongela kwa lugha sya tete kuhusu mbombo sya uweza bhwa K'yara.” ");
INSERT INTO kiz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bhoha bhaduele ni kutatanisibhwa; bhajobhesene bhene kwa bhene, “Ejhe ijhe ni maana gani?” ");
INSERT INTO kiz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini bhangi bhadhihakili bhakajobha, “Abha bhajasibhu kwa mvinyo mpya.” ");
INSERT INTO kiz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lakini Petro akjhema pamonga ni bhala kumi na moja, akakwesya sauti, akajobha, “Bhanu bha Yudea na bhoha bha mwitema apa Yerusalemu, e'le limanyikanayi kwa muenga, mup'elekesiajhi kwa makini malobi gha nene. ");
INSERT INTO kiz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bhanu abha bhagalilepi kama kya mwidhanila kwa ndabha henu lukhela saa tatu ");
INSERT INTO kiz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lakini lyajhele limalikujobhibhwa kup'etela nabii Yoeli: ");
INSERT INTO kiz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ibetakujha katika magono ghwa kumuishu, K'yara ijobha nibeta kujihitisya Roho bha jhoni kwa bhanu bhoha. Bhana bhinu ni bhali bhinu bhibeta kuhomesya unabii, Bhasoni golo bhibeta kulola maono, ni bhaseya bhinu bhibeta kulota ndoto. ");
INSERT INTO kiz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Felafela juu jha bhatumishi bhangu nibhatumishi bhangu bhadala katika magono aghu, nibeta kujhatisya Roho bha jhoni, na bhene bhibeta kutabiri. ");
INSERT INTO kiz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nibeta kulasya maajabu kunani ni ishara pasi pa duniani, damu, muoto, ni mafusho gha liosi. ");
INSERT INTO kiz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nilijobha libeta kubadilisibhwa kujha ngisi ni mwesi kujha damu, kabla jhakuhida ligono libhaha ni lya ajabu jha Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ibeta kujha kila mmonga ambajhe akalikuta lihina lya Bwana ibeta kuokoka. ");
INSERT INTO kiz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bhanu bha Israeli, mup'elekayi malobhi agha. Yesu gha Nazareti mwanadamu jha athibitishibhu ni K'yara kwa muenga kwa matendo gha uweza ni maajabu, ni ishara ambasyo K'yara kup'etela muene katikati jha muenga, kama mwejhomu kya mumanyili. ");
INSERT INTO kiz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kwa ndabha jha mpango ambajho ghwa kusudidibhu kuh'omela kubhuandu. Ni maarifa gha K'yara abhosibhu, ni muenga, kwa mabhobho gha bhanu bhahalifu, mwan'sulubishji ni kun'koma, ");
INSERT INTO kiz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ambajhe K'yara an'jhiuili, akaubhosya uchungu bhwa mauti kwa muene, kwa ndabha jhabhwesekene lepi kwa muene kumilikibhwa ni obhu. ");
INSERT INTO kiz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hivyo Daudi ijobha kuhusu muene, nana bwene Bwana daima mbele jha mihu ghanghu, muene ajhele kibhoko kyangu kya kulia hivyo basi nibetalepi kuhegelesibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa hiyo muoyo bhwa nene bhwa hobhwiki ni lumilu lwa nene ghwafurahishibhu. Pia mbele bhwangu wibeta kuishi mu bhujasiri. ");
INSERT INTO kiz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wibetalepi kujhileka nafsi jha nene jhilotayi kuzimu, wala wibetalepi kuruhusu mtakatifu ghwa jhobhi kulola uozo. ");
INSERT INTO kiz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bhebhe udhihirishi kwa nene jhele jha uzima; wibeta kunibhomba nijhela ni furaha pamihu pa jhobhi. ");
INSERT INTO kiz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ndongo, nibhwesya kulongela kwa muenga kwa bhujasiri kuhusu dadi hitu Daudi: muene lijhele pamonga natu hadi lelu. ");
INSERT INTO kiz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hivyo, ajhele nabii na amanyili kujha k'yara amalikupaa kwa kiapo kya muene, kwamba ibeta kubheka mmonga katika uzao bhwa muene pa kiti kya enzi. ");
INSERT INTO kiz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Alibhwene e'le manyata ni kujobha kuhusu ufufuo bhwa Kristu, wala alekibhulepi kuzimu, wala mbele ghwa muene ghwa bholi lepi. ");
INSERT INTO kiz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu Ojho - K'yara amfufuili ambajhe twebhoha mashahidi. ");
INSERT INTO kiz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Henu bho ajhinulibhu ku kibhoko kya kuume kya K'yara ni kupokela ahadi jha Roho mtakatifu kuh'omela kwa Dad, muene amimi ni ahadi ejhe, ambajhe muenga mwilola ni kup'eleka. ");
INSERT INTO kiz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwani Daudi apai lepi kulota kumbinguni, lakini ijobha, 'BWANA ajobhili kwa Bwana ghwa nene, ");
INSERT INTO kiz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“tamayi kibhoko kyangu kya kulia, mpaka panibeta kubhabhomba maadui bha jhobhi kigoda kwa ndabha jha magolo gha jhobhi. ");
INSERT INTO kiz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kwa hiyo nyumba jhioha jha Israeli na imananyayi kwa hakika kwamba K'yara ambombili muene kujha Bwana ni Kristu, Ojho Yesu ambajhe mwan'sulubisi.” ");
INSERT INTO kiz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Henu bho bhap'eliki nahu, bhahomibhu mu miteema gha bhene bhakan'jobhela Petro ni mitume bhangi, “Ndongo, tuketabhuli? ");
INSERT INTO kiz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ni Petro atabhajobhela, “Mutubuayi na mubatisibhwayi, khila mmonga bhinu, kwa lihina lya Yesu Kristu kwa ndabha jha msamaha ghwa dhambi sya muenga na mwibeta kupokela zawadi jha Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","kwani kwa jhomo ndo ahadi ni kwa bhana bhinu ni kwa bhala bhoha bhabhahe kutali, bhanu bhingi na kwa kadri Bwana K'yara ghwelu pa ibeta kubhakuta.” ");
INSERT INTO kiz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa malobhi mingi ashuhudili ni kubhasihi ajobhili, “mwikiokolayi mbokayi mukizazi e'le kiovu.” ");
INSERT INTO kiz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","(ndipo bhakaghepokela malobhi gha muene ni kubatisibhwa, hapo bhakajhongeseka mu ligono e'le kama nafsi elfu tatu. ");
INSERT INTO kiz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bhakayendelela ni mafundisu gha mitume ni ushirikiano, katika kuumetula n'kate ni mu maombi. ");
INSERT INTO kiz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hofu ikahida juu jha khila nafsi ni maajabu ghamehele ni ishara sikabhombibhwa kup'etela mitume. ");
INSERT INTO kiz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","bhohe bhabhakyeri'ri pamonga ni kujha ni fenu fya bhene kwa pamonga, ");
INSERT INTO kiz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","na bhahemelisi fenu ni miliki sya bhene ni kugabhwanya kwa bhoha kul'engana ni hitaji lya khila mmonga. ");
INSERT INTO kiz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hivyo ligono baada jha ligono bhajhendilili bhakajha ni lengo limonga mu hekalu, na bhametuili n'kate mu kaya, na bhashirki kya kulya kwa furaha ni unyenyekevu bhwa miteema. ");
INSERT INTO kiz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bhan'sifili K'yara na bhajhele ni kibali ni bhanu bhoha. Bwana abhajhongisi ligono kwa ligono ambabho bhajhele bhiokoliwa. ");
INSERT INTO kiz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Henu Petro ni Yohana bhakajha bhitola kuhekalu bhwakati wa maombi, saa tisa. ");
INSERT INTO kiz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Munu fulani, kiwete kuhomela kuhogoleka akajha ip'endibhwa kila ligono kugonekibhwa pa ndiangu ghwa hekalu bhukutibhwege mzuri, ili abhwesiajhi kus'oka sadaka kuh'oma kwa bhanu bhabheloleghe mu hekalu. ");
INSERT INTO kiz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bhoabhhwene Petro ni Yohana bhikaribila kujhingila mu hekalu, as'okili sadaka. ");
INSERT INTO kiz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petro, akan'kesila mihu, pamonga ni Yohana, ajobhili, “tu langayi tete.” ");
INSERT INTO kiz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kiwete akabhalanga, akajha elolelela kukabha khenu fulani kuhoma kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lakini Petro akajobha, “hela ni dhahabu nene njelepi nafu, lakini kyani jhenaku kuhomesya kwabhebhe. Katika lihina lya Yesu Kristu ghwa Nazareth, gendaya.” ");
INSERT INTO kiz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petro akan'tala kwa kibhoko kya muene kya kulia, ni kunjinula kunani: mara jhejhuejhu magologha muene ni fifundo fya mafupa gha muene fyakabhi nghofu. ");
INSERT INTO kiz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Aruki kunani, munu kiwete ajhemili ni kujhanda kugenda. Akajhingila mu hekalu pamonga ni Petro ni Yohana akajhaigenda, iruka, ni kun'sifu K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bhanu bhoha bhambwene igenda ni kun'sifu K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhakamanya kujha ajhele munu jhola ambajhe ajhe atameghe ni kus'oka sadaka pa ndiangu ghunofu ghwa hekalu. Bhajhe ni mshangao ni kustaajabu kwa ndabha jhakhela kya kihomili kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Namna kya abhakemulili bha Petro ni Yohana bhanu bhoha kwa pamonga bhakajumbilila mu ukumbi bhwabhukutibhweghe bhwa Sulemani bhakajha bhishangale sana. ");
INSERT INTO kiz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petro bho alibhwene e'le, muene akabhajibu bhanu, “Enyi bhanu bha Israrel, kwandajhekiki mwishangala? Kwandajhakiki mukaghalasya mihu gha jhomu kwa tete, kama kwamba tumbombili ajha agendayi kwa nghofu sya jhoto bhene au uchaji bhwa jhoto?” ");
INSERT INTO kiz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","K'yara ghwa Ibrahimu, ni ghwa Isaka, ni ghwa Yakobo, K'yara ghwa bha dadi hitu, an'tukuisi n'tumishi ghwa muene Yesu. Ojho ndo ambajhe muenga mwan'kabidhi ni kum'bela mbele jha mihu gha Pilato, japo muene aamuli kundeka huru. ");
INSERT INTO kiz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwam'belili n'takatifu ni mwenye haki ni badala jhiake mkalonde n'komi alekibhwayi huru. ");
INSERT INTO kiz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Muenga mwan'komili mfalme ghwa uzima ambajhe K'yara amfufuili kuhomela kwa bhafu-tete ndo mashahidi bha e'le. ");
INSERT INTO kiz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Henu kwa imani kwa lihina lya muene, munu ajho ambajhe mukambona ni kumanya, abhombiki kujha ni nghofu. Imani ambajho jhip'otela kwa Yesu impelili muene afya ejhe kamilifu, mbele jha muenga mwebhoha. ");
INSERT INTO kiz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Henu, ndongo, nimanyili kujha mwabhombili katika ujinga, ndiyo kya bha bhabhombili bhalongosi bha jhomu. ");
INSERT INTO kiz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lakini mambo ambagho K'yara abhajobhili manyata kwa vinywa fya manabii bhoha, kwamba Kristu ojhu ibetakuteseka, henu aghatimisi. ");
INSERT INTO kiz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kwa hiyo mutubuajhi na mgeukayi, ili kwamba dhambi sya muenga sibhwesiajhi kubhosibhwa kabisa, kusudi sihidayi nyakati sya kuburudika kutokana na uwepo bhwa Bwana; ");
INSERT INTO kiz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ni kwamba abhwesiajhi kun'tuma Kristu ambajhe ataulibhu kwa ndabha jhinu, Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Muene ndo ambajhe lazima mbingu simpokelayi mpaka bhwakati bhwa kukerusibhwa kwa fenu fyoha ambafyo K'yara alonelili muandi kwa finywa fya manabii bha takatifu. ");
INSERT INTO kiz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hakika musa ajobhili; Bwana k'yara ibetakujhinula nabii kama nene kuh'omela kwa bhalongobhinu. Mwibeta kump'elekesya khita khenu ambakyo ibeta kubhajobhela muenga. ");
INSERT INTO kiz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jhibeta kutokela kujha khila munu ambahe ip'elekesya lepi kwa nabii. Ojho ibeta kujhangamisi bhwa kabisa abhokayi kkati jhe bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ena, ni manabii bhoha kuhomela Samweli ni bhala bhabhakesisi baada jha muene, bhalongelili ni kutangasya magono agha. ");
INSERT INTO kiz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Muenga mwe bhana bha manabii ni bha agano ambalyo K'yara alibhombili pamonga ni mababu, kama kya ajobhili kwa Abrahamu katika mbeyu jha bhebhe familia syoha sya dunia sibetakubarikibhwa.' ");
INSERT INTO kiz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Baada jha K'yara kunjinula n'tumishi ghwa muene, an'daghisi kwa muenga hotiili abbabarikiayi muenga kwa kugeuka kuhomela mu uovu bha muenga.” ");
INSERT INTO kiz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bwakati Petro ni Yohana bhilongela ni bhanu, akuhani ni bhalinzi bha hekalu ni Masudukayo bhakabhalotela. ");
INSERT INTO kiz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhadadilili nesu kwa ndabha Petro ni Yohana bhajhe bhakabhafundisya bhanu kuhusu Yesu ni kutangasya juu jha kufufuka kwa muene kuh'omela kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bhakabhakamula ni kubhabheke mu ligereza hadi lukhela kabhele, kwani jha tayari kimili. ");
INSERT INTO kiz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini bhanu bhingi bhabhap'eliki ujumbe bhakyeriri; ni idadi jha bhagosi bhajhele bhakimini bhakadilibhu kujha elfu tano. ");
INSERT INTO kiz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hata bhojhifikili likhela ligono lya lyefuatili bhabhaha bha bhene bhasaeya ni bhaandishi, kwa pamonga bhakibhongenuye Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi kuhani mbaha ajhele, ni Kayafa, ni Yohana, ni Iskanda, ni bhoha bhabhajhele ni ndongo ghwa kuhani mbaha. ");
INSERT INTO kiz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bhobhabhabhekili Petro ni Yohana katikati jha bhene bhakabhakota, “Kwa uwezo bholoki, au kwa lilina lelaku mmbombi agha?” ");
INSERT INTO kiz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kisha Petro, akajha ameniuli Roho mtakatifu, akabhajobhela, “Muenga bhabhaha bha bhanu, ni bhaseya, ");
INSERT INTO kiz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kama teteligono lya lelu tuikotibhwa kuhusu litendo linofu lyalibhombibhu kwa munu ojho n'tamu - kwanda jhakiki munu ajho tumponisi? ");
INSERT INTO kiz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Hebu limanyikanayi e'tu kwa muenga ni kwa bhanu bhoha, bha Israeli kwamba kwa lihina lya yesu Kristu ghwa Nazareth, ambajhe fuwan'sulubisi, ambajhe K'yara amfufuili kuhoma kwa bhafu, ni kwa njela jha muene kwamba munu ajho ijhema apa mbele jhe muenga ni afya jhioha. ");
INSERT INTO kiz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu kristu ndo liganga ambalyo muenga bhajenzi mwalizalaulili, lakini bado libhombibhu kujha liganga libhaha lya palubhafu. ");
INSERT INTO kiz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ujhelepi wokovu kwa munu ojho jhongi ghoa jhoha kwa mena lijhepi liganga lenge pasi pa mbingu lya bhapelibhu bhangi bhanu ambalyo kwa e'lu twibhwesya kuokolibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Henu bho bhabhuene bhujasiri bhwa Petro ni Yohana, ni kugundula kujha bhajhele bhanubhe kawaida bhabhaduli elimu, bhashangele, bhakamanya kujha Petro ni Yohana bhajhele pamonga ni Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kwa ndabha bhambwene munu jhola jhaaponysibhu ajhemili pamonga nibhene, bhajhelepi ni khenu kya kujobha dhidi jha e'le. ");
INSERT INTO kiz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lakini bho bhamalili kumuamuru mitume bhabhokayi mbele jha mkutano ghwa baraza, bhalongili bhene kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bhajobhili tubeta kubhabhomba bhuli bhanu abha? Ni kweli kujha muujiza ghwa ajabu ubhombiki kup'etela bhene umanyikene ni khila mmonga jha itama Yerusalemu; twibhwesya lepi kulibela e'lu. ");
INSERT INTO kiz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini, ili kwamba lijambo e'le lisijheneli miongoni mwa bhanu, hebu tubhaonyayi bhasijobhi kabhele kwa munu jhejhioha kwa lihina e'le. ");
INSERT INTO kiz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bhakabhakuta Petro ni Yohana mugati ni kubhaamuru kamwe bhasiojobhi wala kufundisya kwa lihina lya Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petro ni Yohana bhajobhili ni kubhajobhela, “kama ndo sahihi pamihu pa K'yara kubhatii muenga kuliko K'yara muhukumuayi mwebhene. ");
INSERT INTO kiz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndabha tete twibhwesya lepikuleka kughenene mambo ambagho tughabhuene ni kughap'eleka.” ");
INSERT INTO kiz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baada jhe kubhaonya nesu Petro ni Yohana, bhakabhaleka bhalotayi. Bhabhwesilepi kukabha sababu jhejhioha jhe kubha adhibu kwa ndabha bhanu bhoha bha jhele bhakan'sifu K'yara kwa khela kya kya khele kibhombiki. ");
INSERT INTO kiz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Munu jha apokili muujiza bhwa uponyaji ajhe ni umri zaidi jha miaka arobaini. ");
INSERT INTO kiz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Baada jha kubhalaka huru, petro ni Yohana bhakahida kwa bhanu bhabhene ni kubhataarifu ghoha ambagho makuhani bhabhaha ni bhaseya gha bhabhajobhili. ");
INSERT INTO kiz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bhobhaghap'eliki, bhakakwesya sauti sya bhane kwa pamonga kwa K'yara nikujobha, “Bwana, bhebhe jhaubhombili mbingu ni dunia ni nyanja ni khila khenu mugati mwake. ");
INSERT INTO kiz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bhebhe ambajhe kwa Roho mtakatifu kwa kinywa kya dadi jhitu Daudi, n'tumishi ghwa jhobhi, ghwa jhobili, “Kwa ndaya kiki bhanu bha mataifa bhabhombili ghasia, ni bhanu bhamali kutafakari mambo ghaghifwayi lepi? ");
INSERT INTO kiz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bhafalme bha dunia bhakipangili pamonga, ni bhatawala bhakibhongiye ku pamonga dhidi jha Bwana dhidi jha Masihi bhake.” ");
INSERT INTO kiz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ni hakika, bhoha Herode ni Pontio Pilato, pamonga ni bhanu bha mataifa ni bhanu bha Israeli, bhabhonganiki kwa pamonga katika mji ajobho dhidi jha n'tumishi bhwa jhobhi mtakatifu Yesu, ambajhe ghwa mpakili mafuta. ");
INSERT INTO kiz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bhabhonganiki kwa pamonga kubhomba ghoha ambagho kibhoko kya jhobhi ni mapenzi gha jhobhi ghaamuiri kuhomela kubhwandelu kabla ghakona kuh'omela. ");
INSERT INTO kiz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Henu, Bwana, ghalangayi matisho gha bhene, na ukabhajalilayi bhatumishi bha jhobhi kulijobha litobhi lya bhebhe kwa ujasiri bhuoha. ");
INSERT INTO kiz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ili kwamba pa ghwinyosya kibhoko kya jhobhi koponyesya, ishara ni maajabu fisibhwese kuhomela kup'etela lihina lya n'tumishi ghwa jhobhi mtakatifu Yesu.” ");
INSERT INTO kiz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bho bhamali kus/oka, eneo ambalyo bhabhonganiki kwa pamonga lyatikisibhu, na bhoha bhamemesibhu Roho mtakatifu, na bhanenili litobhi lya K'yara kwa bhujasiri. ");
INSERT INTO kiz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Idadi jhibhaha, jhaa bhala bhabhaamini bhajhele ni muoyo umonga ni Roho jhimonga: na ajhelepi hata mmonga ghoa bhene jhaajobhili kujha kyokyoha kyaimiliki lya jhele kya muene: badala jhiake bhajhele ni fenu fyoha fya shirika. ");
INSERT INTO kiz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa nghofu mbaha mitume bhakajhe bhitangasya ushuhuda ghwa bhene kuhus ufufuo bhwa Bwana Yesu, ni neema mbaha jhejhele panani pabhene bhoha. ");
INSERT INTO kiz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pajhelepi ni munu jhejhiojha miongoni mwa bhene jhaap'ongokibhu ni mahitaji, kwa ndabha bhanu bhoha bha jhele ni hatia sya fibhanja au nyumba, bhafihemilisi kikuleta hela jha fenu fya bhahemelisi ");
INSERT INTO kiz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ni kufibheka pasi pa magolo gha mitume. Ni mgawanyo ghwa bhombiki, kwa khila muumini, kulengana ni khila mmonga fyaalo ndeghe. ");
INSERT INTO kiz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu, mlawi, munu kuhoma kipro, apelibhu lihina lya Barnabasi ni mitume (ejho jhikatafiribhwayi, ndo muana ghwa faraja). ");
INSERT INTO kiz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Akajha ni n'gonda, ahemelisi ni kuleta hela, akasibheka pasi pamagologha mitume. ");
INSERT INTO kiz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Efyo, munu mmonga jha akutibhweghe Anania, ni Safira nkwibhi, bhehemelisi sehemu jha mali, ");
INSERT INTO kiz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","na afighili sehemu jha hela jhabhahemlisi (n'dala ghwa bhubhele amanyi e'lu), ni kuleta sehemu jha jhisiele ni kujhibheka mu magolo gha mitume. ");
INSERT INTO kiz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lakini Petro akajbha, Anania, kwa ndabha jhakiki ghwa shetani uumemisi muoyo ghoa jhobhi kujobha udesi kwa Roho mtakatifu ni kufigha sehemu jha maligha n'gonda? ");
INSERT INTO kiz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bhwakati lihemelesibhu lepi, lyajhelepi mali gha jhobhi? Ni baada jha kuhemelesibhwa, lya jhelepi pasi pa uamuzi bhwa jhobhi? Jhikajhebhuli ubhwasiajhi lijambo elu mu muoyo bhwa jhobhi? jhikajhebhuli ubhwasiajhi lijambo elu mu muoyo bhwa jhobhi? Ubhakosilepi bhanadamu bali un'kosi K'yara.” ");
INSERT INTO kiz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Katika kup'eteleka malobhi agha Anania abinili pasi ni kufwa. Ni hofu mbaha jhabha hidili bhana bhabhap'eliki e'le. ");
INSERT INTO kiz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bhasongolo bhakahida palongolo ni kumbeka katika sanda, ni kumpeleka kwibhala ni kun'siela. ");
INSERT INTO kiz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Baada jha masaa madatu ivi n'dala munu akajhingila mugati bila kumanya kyakikatokili. ");
INSERT INTO kiz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro akan'jobhela, “Nijobhelayi, kama mwahemelisi n'gonda kwa thamani ejhu.” Akajobha, “Ena, kwa thamani ejhu.” ");
INSERT INTO kiz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kisha Petro akan'jobhela, “jhijhabhuli kwamba mupatene kwa pamonga kun'jaribu Roho ghwa Bwana? Langayi magolo ha bhale bhabhan'syelili n'gosibhu ijhe pandiangu, na bhibeta kupenda ni kupeleka kwibhala.” ");
INSERT INTO kiz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ghafla akabina mumagolo gha Petro, akafwa, ni bhala bhasongolo bhakahida mugati bhaka'kolela amalikufwa. Bhakampenda kumpeleka kwibhala, ni kun'siela karibu ni n'gosi. ");
INSERT INTO kiz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hofu mbaha jhikahida juu jhe kanisa lyoha, ni juu jha bhoha bhaghap'eliki mambo agha. ");
INSERT INTO kiz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ishara simehele ni maajabu fya jhele fihomele ni maajabu fya jhele fihomele miongoni mwa bhanu kup'etela mabhoko gha mitume. Bhajhele pamonga mu ukumbi bhwa sulemani. ");
INSERT INTO kiz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lakini, ajhelepi munu jhongi tofauti jha ajhele ni bhujasiri bhwa kuambatana ne bhene hata naha bhapelibhu heshima jhe panani ni bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ni kabhele, bhaamini bhingi bhakajha bhijhongeseka kwa Bwana, idadi mbaha jha bhagosi ni bhadala, ");
INSERT INTO kiz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","kiasi kwamba hata akabhap'enda bhatamu mitaani, ni kubhagoneke pa fitanda ni mumakochi, ili kwamba Petro kama ipeta, kivuli kya muene kibhwesiajhi kuselele juu jha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Apu kabhele idadi mbaha jha bhanu bhakahida kuhoma miji jhajhisyonguiki Yerusalemu, bhakabhaleta bhatamu ni bhoha bhabhapagewe ni mapepo ni roho chafu, ne bhoha bhaponyibhu. ");
INSERT INTO kiz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lakini kuhani mbaha ajhinuiki, nibhoha bhabhajhe pamonga naku (ambaho bha dhahabu lya masudukayo); na bhamemili ni bhwifu. ");
INSERT INTO kiz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bhakanyosya mabhoko gha bhene kubhakamula mitume ni kubhabheka mu ligereza lya jumla. ");
INSERT INTO kiz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ni bhwakati wa pakilu malaika bha Bwana akaifungula miliangu ghya geraza ni kubhalongosya kwibhala ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mutolayi, mkajhemayi mulihekalu ni kubhajobhela bhanu malobhi ghoha gha uzima obho.” ");
INSERT INTO kiz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bhobhapeliki e'le, bhakajhingila muhekalu wakati bhwa kubhalala ni kumanyisya. Lakini, kuhani mbaha ahidili na bhoha bhajhenaku, nikukutisya baraza lyoha kwa pamonga, ni bhaseya bhoha bha bhanu bha Israeli, ni kubhalaghisya kuligereza ili kubhalata mitume. ");
INSERT INTO kiz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini bhatumishi bhabhalotili, bhabhakolilepi mu ligereza, bhakerbhuiki ni kuhomesya taarifa, ");
INSERT INTO kiz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tukolili gereza lidendibhu kinofu, ni bhalinzi bhalinzi bhajhemili pa ndiangu lakini bhotwidendula twambwene lepi munu mugati.” ");
INSERT INTO kiz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Henu bhwakati jemedari ghwa hekalu ni makuhani bhabhaha bhobhep'eliki malobhi aghu, bhajhingbhu ni shaka mbaha kwa ndabha jha bhene bhakajha bhiibhwesya, jhibeta kujhebhuli lijambo e'le. ");
INSERT INTO kiz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kisha mmonga akahida ni kubhajobhela, “Bhanu bha mubhabhekili muligereza bhajhemili mu hekalu na bhifundisya bhanu.” ");
INSERT INTO kiz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Henu jemedari akalota pamonga ni bhatumishi, ni kubhaleta, lakini bila jhe kubhomba fuju, kwa ndabha bhabhatilili bhanu ngabhabhwesili kubhahomelela maganga. ");
INSERT INTO kiz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bhobhabhaletili bhabhebhekili palongolo pa baraza. Kuhani mbaha abhakotili, ");
INSERT INTO kiz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","akajobha, “Twabhajobhili mufundisiajhi kwa lihina ele, na bado mujhiniemisi Yerusalemu kwa lifundisu lya muenga, ni kulonda kuleta damu jhe munu ojho juu jha tete.” ");
INSERT INTO kiz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lakini Petro ni mitume bhakajibu, “azima tun'kesiajhi K'yara kuliko bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","K'yara ghwa dadi jhitu amfufuili Yesu, jhamun'komili, kwa kun'tondeka panani pa libehe. ");
INSERT INTO kiz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","K'yara an'tukuisi katika kibhoko kya muene kya kuume ni kumbomba kujhe mbhaha ni mwokozi, kubhosya toba kwa Israeli, ni msamaha kwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tete ndo mashahidi bha mambo agha, ni Roho mtakatifu ambajhe K'yara ambosisi kwa bhala bhabha kan'tii.” ");
INSERT INTO kiz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhajumbe bha baraza bho bhap'eliki naha, bhakamlibhu ni ligoga bhakalonda kuhakoma mitume. ");
INSERT INTO kiz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini pharisayo jhaakutibhweghe Gamalieli, mwalimu ghwa sheria, jhaahashimibhweghe ni bhanu bhoha, ajhemili ni kubhaamuru mitume bhatolibhwayi kwibhala kwa muda bhufupi. ");
INSERT INTO kiz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kisha abhabhajobhela, “Bhagosi bha Israeli, mujhelayi makini sana ni khela kya mwependekesya kubhabhombela bhanu abha. ");
INSERT INTO kiz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","kwa ndabha muandi theuda ajhinuiki ni kwidayi kujha mun mbaha, ni idadi jha bhanu kama mia nne bhan'kesisi. Akomibhu, ni bhoha bhabhan'tieghe bhatawanyiki ni kujhagha. ");
INSERT INTO kiz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Baada jha munu ojho, Yuda mgalilaya, ajhinuiki magono ghala gha kulekebibhwa sensa akafuta bhanu bhingi kunyma kwa muene. Ni muene kabhele ajhaghili ni bhoha bhabhan'tieghe bhatawanyiki. ");
INSERT INTO kiz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Henu, nikabhajobhela, mukijhepusighe ni bhanu abha na mubhalekayi bhene, kwa ndabha, kama mpango obho au mbombo ejhe jha bhanu jhitaghibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini kama jha K'yara, mwibetalepi kubhazuila: mwibhwesya kwikolela hata mwishindana ni K'yara.” Efyo, bhashawishiki ni malobhi gha muene. ");
INSERT INTO kiz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kisha bhakabhakuta mitume mugati ni kubhatobha ni kubhaamuru bhasijobhi kwa lihina lya Yesu, ni kubhaleka bhalotayi. ");
INSERT INTO kiz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bhabhokili mbele jha baraza bhahobhwiki kwa ndabha bha bhalangibhu kujha bhilondeke kutebhwa ni kutokuheshibhwa kwa ndabha jhe lihina e'lu. ");
INSERT INTO kiz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Henu, khila ligono, mugati mu hekalu ni kuhomela kunyumba hadi nyumba bhajhendelili kumanyisya ni kuhubiri Yesu kujha ndo Masihi. ");
INSERT INTO kiz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Henu katika magono agha, idadi jhe bhanafunzi jhijhogeseka, lalamiko lya bhayahudi bha kiyunani lyajhandili dhidi jha Baebrania kwa ndabha bhajane bha bhene bhajhela bhiyebhelibhwa mu mgao bhwa khila ligono bhwa kyakulya. ");
INSERT INTO kiz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mitume kumi ni bhabhele bhabhakutili kusanyiku lyoha lya bhanafunzi ni kujobha, “Sahihi lepi kwa tete kulileka lilobhi lya K'yara ni kuhudumila pa meza. ");
INSERT INTO kiz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwa hiyo ndongo, muchagulayi bhagosi saba, kuhomela miongoni mwa muenga bhanu bhema, bhabhamemili roho ni hekima ambabho twibhwesya kubhakabidhi huduma ejhe. ");
INSERT INTO kiz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ni tete tubeta kujhendelela mu maombi ni mu huduma jha lilobhi.” ");
INSERT INTO kiz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hotuba jha bhene jhabhupendisi mkutano bhuoha. Hivyo bhakan'chagula stefano, munu jha ojhe ni imani ni Roho mtakatifu, ni Filipo, Prokoro, Nikanori, Timoni, Parmena, na Nikolai, mwongofu kuhoma Antiokia. ");
INSERT INTO kiz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhaumini bhabhaletili bhanu abha mbele jha bhamitume, bhabhas'okili ni baadaye bhada bhabhekela mabhoko gha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hivyo, lilobhi lya K'yara liaenili ni idadi jhe bhanafunzi, jhajhongesiki, okho Yerusalemu; ni idadi mbaha jha makuhani bhakaitii imani. ");
INSERT INTO kiz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ni Stefano, jhaamemili neema ni nghofu, akifanya maajabu ni ishara mbaha miongoni mwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini apu bhajhinuiki baadhi jha bhanu bhafuasi bha sinagogi lya likutibhweghe sinagogi lya mahuru, ni la Bhakerene ni la Bhaeskandaria, ni baadhi kuhoma Kilikia ni Asia. Bhanu abha bha jhele bhihojiana ni Stefano. ");
INSERT INTO kiz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini bbwabhwesilepi kusindana ni hekima sya Roho ambajho Stefano ajhe itumila mu malongesi. ");
INSERT INTO kiz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kisha bhabhashawishi baadhi jha bhanu kwa siri kujobha, “Tup'eliki Stefano ilongela malobhi gha kufuru dhidi jha Musa ni dhidi jha K'yara.” ");
INSERT INTO kiz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bhabhashurutishi bhanu, bhaseya, ni bhaandishi, ni kun'dotela Stefano bhakan'kamula ni kundeta mbele jha baraza. ");
INSERT INTO kiz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bhakabhaleta mashahidi bha bhudesi, bhabhajobhili, “Munu ojho ilekalepi kujobha malobhi manofulepi dhidi jha lieneo ele takatifu ni sheria. ");
INSERT INTO kiz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwani tup'eliki ijobha kujha ojho Yesu ghwa Nazareth ibeta kupa haribu mahali apa ni kusibadilisya desturi sya tukabisibhu ni Musa.” ");
INSERT INTO kiz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Khila mmonga jha ajhe mu baraza, akajhelekesya mihu gha muene kundanga Stefano, nabhane bhakaubhona uso bhwa muene bhwajhele kama bhwa malaika. ");
INSERT INTO kiz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kuhani mbaha akajobha. “Mambo agha gha bhukweli”? ");
INSERT INTO kiz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano akajobha, “Bhalongo bhangu ni badadi jhangu munip'elekesiajhi nene: K'yara ghwa bhutukufu an'tokili dadi jhitu Abrahamu bhwakati ajhele Mesopotamia kabla hja, kutama Harani; ");
INSERT INTO kiz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","akan'jobhela, bhokayi katika nchi jha jhobhi ni bhanu bha jhobhi na ulotayi, mu nchi jha nibetakulasya'. ");
INSERT INTO kiz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kisha akabhoka mu nchi jha ukaldayo akatama Harani, kuhomela apu, Baada jha dadi munu kufwa, K'yara akandeta mu nchi ejhe, jhabhitama henu. ");
INSERT INTO kiz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ampelilepi kyokyoha kama urithi bwa muene, pajhelepi hata ni sehemu jha kubheka ligolo. Lakini Abrahamu ahaidibhu hata kabla jha kukabhe muana kujhanibetakupelibhwa nchi kama miliki jha muene ni uzao bhwa muene ");
INSERT INTO kiz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","K'yara ajobhi naku naha, jha kujha bhazao bha muene nghabhatamili mu nchi jha kubhuhesya ni bhenyeji bha okhubhibeta kubhabhomba bhatumwa bha bhene ni kubhabhomba fibaya kwa muda ghwa miaka mianne. ");
INSERT INTO kiz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ni K'yara akajobha nibetakulihukumu taifa ambalyo libeta kubhabhomba mateka, ni baada jha apu bhibhita kuhoma ni kuniabudu pa sehemu ejhe. ");
INSERT INTO kiz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na ampelili Abrahamu Agano lya tohara. Ivyo Abrahamu akajha ghwa ISaka akan'tahiri ligono lya nane; Isaka akajha dadi ghwa Yakobo ni Yakobo akajha dadi ghwa bhakhoko bhitu kumi ni bhabhele. ");
INSERT INTO kiz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bhakoko bhitu bhakambonela bhwifu Yusufu bhakan'hemesya katika nchi jh a Misri, ni K'yara ajhele pamonga ni muene, ");
INSERT INTO kiz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ni kumwokola katika malombosi gha muene, ni kumpela fadhili ni hekima mbele jha Farao mfalme ghwa Misri. Farao akambeka kujha mtawala juu jha Misri ni juu jha nyumba jha muene jhioha. ");
INSERT INTO kiz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Basi kwajhele ni njala mbaha ni malombosi mingi mu nchi jha Misri ni kanani, ni bhadidi jhitu bhakabhilepi kyakulya. ");
INSERT INTO kiz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lakini Yakobo bho apeliki kujha ni nafakaMisri, abhalaghisi bha dadi jhitu kwa mara jha kwanza. ");
INSERT INTO kiz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Katika safari jha pili Yusufu akakilasya kwa bhalongo munu, familia jha Yusufu jhikamanyikana kwa Farao. ");
INSERT INTO kiz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu abhalaghisi bhalongomunu kulota kun'jobhela Yakobo dadi jabhi ahidayi Misri, pamonga ni ndongo munu, jumla jha bhanu bhoha sabini na tano. ");
INSERT INTO kiz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hivyo Yakobo aselili Misri; kisha afuili pamonga ni bhadadi jhitu. ");
INSERT INTO kiz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bhakatolibhwa hata Shekemu bhakasyelibhwa mulikaburi ambalyo Abrahamu alihemili kwa fipandi fya hela kuhoma kwa bhana bha Hamori okhu Shekemu. ");
INSERT INTO kiz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Bhwakati bhwa jhela ahidi ambayo K'yara aahidi Abrahamu bho bhukaribili, bhanu bho bhajhongesiki oku Misri, ");
INSERT INTO kiz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bhwakati obhu ajhinuiki mfalme jhongi Misri, mfalme jhaa manyilepi kuhusu Yusufu. ");
INSERT INTO kiz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mfalme jhongi ojho akabhakofya bhanu bhitu ni kubhabhomba mabhibhi bha dadi jhitu, ni kubhatagha bhana bhabhi bhadebe ili bhasiishi. ");
INSERT INTO kiz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Katika kipindi khela Musa ahogoliki ajhele nnofu mbele jha K'yara alalibhu miesi midatu mu nyumba jha dadi munu. ");
INSERT INTO kiz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bhwakati ataghibhu, binti ghwa Farao antolili akandela kama mwana munu. ");
INSERT INTO kiz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa amanyisibhu mafundisu ghoha gha kimisri; ajhele ni nghofu mu malobhi ni matendo. ");
INSERT INTO kiz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Lakini baada jha kutimisya miaka arobaini, jhikanhidila mu muoyo bhwa muene kubhagendela bhalongo munu, bhana bha Israeli. ");
INSERT INTO kiz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bhoambwene mwisraeli ibhombibhwa mabhibhi, Musa an'telili ni kulepesya kisasi kwa jhaamboneleghe kwa kun'tobha Mmsri. ");
INSERT INTO kiz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Afikineghe kujha bhalongo munu bhibeta kumanya kujha K'yara akabhaokola kwa mabhoko gha muene lakini bhamanyilepi. ");
INSERT INTO kiz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ligono lya lafwatili akalota kwa baadhi jha bhaisraeli bhahakomaneghe; akajaribu kubhapatenisya; akajobha Mabwana, muenga ndongo, mbona mwikoselana jhmu kwa jhomu? ");
INSERT INTO kiz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lakini jhaankosili jirani ghwa muene akansukumila patali ni kujobha, 'Niani akubhombili kujha mtawala ni mhukumu ghwa tete? ");
INSERT INTO kiz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bhebhe wilonda kunikoma kama kyaghwan'komili Mmisri golo”? ");
INSERT INTO kiz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa ajumbili baada jha kupeleka nahu; akajha n'hesya mu nchi jha Midiani ambapo akajha dadi ghwa bhana bhabhele. ");
INSERT INTO kiz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Baada jha miaka arobaini kup'eta, malaika akan'tokela mu jangwa lya kidonda sinai, katika mb'ele ghwa muoto mukichaka. ");
INSERT INTO kiz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bwakati Musa abubhwene muoto, ashangele ni kustajabila khela kya akibhwene, na bhoajeribu kukihegelela ili kukilanga sauti jha Bwana ikan'hidila ni kujobha, ");
INSERT INTO kiz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nene ne K'yara ghwa bha dadi waku, K'yara ghwa Abrahamu, ni ghwa Isaka, ni ghwa Yakobo; Musa atetenuki na athubulepi kulanga. ");
INSERT INTO kiz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bwana akan'jobhela, “Fulayi filatu fya jhibhi, sehemu pa ujhemili ndo mahali patakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nighabhuene mateso gha bhanu bhangu bhabhajhele Misri; Nip'eleliki kuluala kwa bhene, nani niselili ili nibhaokolayi; Henu hidayi, nibeta kulaghisya bhebhe Misri.' ");
INSERT INTO kiz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ojhi Musa jha bhambelili, wakati bhijobha, Niani akubhekili kujha mtawala ni mwamuzi ghwa tete? Ajhele ndo K'yara andaghisi kujha mtawala ni n'kombozi K'yara andaghisi kwa kibhoko kya malaika ambajhe an'tokili Musa mu kichaka. ");
INSERT INTO kiz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa abhalonguisi kuhomela Misri baada jha kubhomba miujiza ni ishara kuimisri ni kubahari jha Shamu, ni kulijangwa kwa kipindi kya miaka arobaini. ");
INSERT INTO kiz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ndo Musa ojho jhaabhajobhili bhanu bha Israeli kujha, K'yara ibetakubhajhinubila nabii kuhomele miongonni mwa bhalongo bhinu, nabii kama nene. ");
INSERT INTO kiz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ojho ndo munu ambajhe ajhele ku n'kutano ku lijangwa ni malaika ambajhe alongi nakhu pa kidonda Sinai. Ojho ndo munu apokili lilobhi lyalijhe hai ni kutupela tete. ");
INSERT INTO kiz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ojho ndo munu ambajhe bhadadijhitu bhabeli kuntii; bhan'sukumili patali ni mu mioyo ghyabho bhageukili Misri. ");
INSERT INTO kiz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mu kipindi e'ku bhan'jobhili Haruni.'tutengeneselayi miungu ghyaghibetakutulongosya. Musa ojho, jhaatulongosiaghe kuhomela nchi jha Misri, tumanyilepi kyakin'kolili.' ");
INSERT INTO kiz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hiyo bhatengenisi liloli kwa magono aghu ni kupisya sadaka kwa sanamu ejhu na bhahobheleli kwa ndabha jha mbombo jhe mabhoko gha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lakini K'yara abhageuzili ni kubhapela bhaabudu ajhi litondo lya kunani, kama kya jhilembibhu mu kitabu kya manabii, je, munihomesili nene sadaka sya bhanyama bha mubhachijhili ku jangwa kwa muda bhwa miaka arobaini nyumba jha Israeli? ");
INSERT INTO kiz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mujhedekili hema jha kubhonanila jha Moleki ni litondo lya K'yara refani, ni picha jha muteng'enisi ni kubhaabudu bhene: ne nibetakubhapeleka patali zaidi jha Babeli . ");
INSERT INTO kiz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bhadadi jhitu bha jhe ni hema lya kubhonanila jha bhushuhuda jangwani kama K'yara kyaamuili bhoilongela ni Musa, kwamba ngaaiteng'enisi kwa mfano bhwa bhola bhwaabhuene. ");
INSERT INTO kiz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","E'le ndo lihema ambalyobha dadi jhitu, kwa bhwakati ghwa bhene bhaletibhu mu nchi ni Joshua. Ejhhe jhatokili bhwakati bho bhajhingili kumiliki taifa ambalyo K'yara abhabhengili kabla jha uwepo ghwa bha dadi jhitu. Ejhe jha jhele naha mpaka magono gha Daudi, ");
INSERT INTO kiz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ambajhe akabhaili kibanda makao kwa k'yara ghwa Yakobo ");
INSERT INTO kiz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Sulemani an'jengili nyumba jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Hata naha jhe ajhe kunani itama lepi munyumba sya sijengebhu kwa mabhoko; ejhe kama nabii kya ajobhili, ");
INSERT INTO kiz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mbingu ndo kiti kyangu kya enzi, ni dunia ndo sehemu jha kubheka magolo gha jhoni. Nyumba jha aina jheleku mwibetakujenga? ijobha Bwana; jhjhendaku sehemu jha nene jha kup'omoseka? ");
INSERT INTO kiz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Siyo kibhoko kya nene kya kibhombili agha ghoha? ");
INSERT INTO kiz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Enye bhanu bha mujhe ni singu sikatafu mwam'belikuiribhwa mioyoni mb'olokolo, khila mara mukampinga Roho mtakatifu; mwibhombil. ");
INSERT INTO kiz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ni nabii jholeku katika manabii ambajhe bhadadi jhinu bhan'tesilipi? Bhabhakhomili manabii bhoha bhabhetokili kabla jha ujio bhwa mmonga mwenye haki,' ni henu mmalikujha mwebhasaliti ni bhauajhi bha muene kabhole, ");
INSERT INTO kiz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","enyi bhanu jha mwapokili sheria jhela jha laghisibhu ni malaika lakini mwajhikamuili lepi.” ");
INSERT INTO kiz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kisha bhajumbe bha baraza bhobhap'eliki mambo agha, bhanyanyibhu mioyo ghya bhene, bhakan'syaghila minu Stefano. ");
INSERT INTO kiz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini muene bho amemili Roho mtakatifu, alolili kumbinguni kwa makini ni kubhubhona utukufu bhwa K'yara; ni kumbona Yesu ajhemili kibhoko kya kuume kya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefano akajobha, “Langayi nijhibhwene mbingu sifungwiki, ni Mwana gha Adamu ajhemili kibhoko kya kuume kya K'yara.” ");
INSERT INTO kiz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lakini bhajmbe bhe baraza bhapigili kelele kwa sauti mbaha, bhakaziba mb'olokoto sya bhene, bhakan'jumbilila kwa pamonga, ");
INSERT INTO kiz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bhakan'tagha kwibhala mu masi ni kun'tobha ni maganga; ni mashahidi bhakafula nghobho sya bhene kwibhala ni kubheka pasi karibu ni magolo gha n'songolo jhaakutibhweghe Sauli. ");
INSERT INTO kiz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bhwakati bhakan'tobha magangaa Stefano, ajhendelili kunkuta Bwana ni kujobha, “Bwana Yesu pokelayi roho jhangu,”. ");
INSERT INTO kiz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akapiga magoti ni kukuta kwa sauti mbaha, “Bwana, usibhabhalangili dhambi ejhe.” Bho ajobhi aghu akatili roho. ");
INSERT INTO kiz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli ajhele makubaliano gha kifo kya muene. Legono elu ndo ajhandili kubhatesya kinyume kya kanisa lya lyejhele Yerusalemu; na bhoha jha bhiamini bhabhatawanyiki mu majimbo gha Yudea ni Samaria, isipokujha mitume. ");
INSERT INTO kiz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bhanu bhacha mungu bhan'syelili Stefano ni kubhomba maombolez mabhaha juu jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lakini Sauli alilizuru likanisa. Alotili nyumba kwa nyumba nikubhabuniza kwibhala bhadala ni bhagosi, ni kubhasopa mu ligereza. ");
INSERT INTO kiz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bhabhikeera ambabho bhatawanyiki bado bhalihubiri lilobhi. ");
INSERT INTO kiz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo asalili katika mji bhwa Samaria ni kun'tangasya Kristu okhu. ");
INSERT INTO kiz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Baada jha makutano kup'eleka ni ishara syaabhombi Filipo; bhakabheka umakini juu jha khela kyaajobhili. ");
INSERT INTO kiz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kuhomela apu bhanu bhingi bhabhap'eliki pepo bhachafu bhakabhabhoka bhanu khoni bhilela kwa sauti mbaha, ni bhingi bhabhapoozili ni fiwete bhaponyisibhu. ");
INSERT INTO kiz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na kwajhele ni furaha mbaha mu mji. ");
INSERT INTO kiz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lakini pajhele ni munu mmonga mu mji bhola lihina lya muene Simoni ambajhe abhombeghe uhabhi; ambabho abhutimili kubhashangasya bhanu bha taifa la Samaria, wakati ijobha kujha muene ndo munu muhimu. ");
INSERT INTO kiz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bhasamaria bhoha kuhomela bhana hata bhabhaha, bhakamp'elekesya, bhakajobha, “Munu ojho ndo jhela nghofu jha K'yara ambajho ndo mbaha.” ");
INSERT INTO kiz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bhakamp'elekesya, kwa ndabha abhesyangese mda mrefu kwa uhabhi bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini wakati bhakyeriri kujha Filipo ahubiriri juu jha ufalme bhwa K'yara ni juu jhalihina lya Yesu Kristu, bhabatisibhu bhagosi kwa bhadala. ");
INSERT INTO kiz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ni Simoni muene akyeriri; baada jha kubatisibhwa ajhendelili kujha ni Filipo; bho abhuene ishara ni miujiza jhaijhele jhibhombekeghe, ashangele. ");
INSERT INTO kiz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wakati mitume bha Yerusalemu bho bhap'eliki kujha samaria ipokili lilobhi lya K'yara bhakabhautma Petro ni Yohana. ");
INSERT INTO kiz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wakati bhiselela bhakabhaombela; kujha bhampokelayi Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mpaka mda obhu, Roho mtakatifu ajhele akona kubhaselelela hata mmonga ghwa bhene; bhabatisibhu lu kwa lihina lya Bwana Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndipo Petro ni Yohana bhakabhabhekela mabhoko ni bhene bhakampokela Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wakati Simoni abhwena Roho mtakatifu abhosibhu kupetelakubhekibhwa mabhoko ni mitume; alondeghe kubhapela hela, ");
INSERT INTO kiz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akajobha, “Nipelayi nghofu ejhe, ili kila jha nibetakumbeka mabhoko paokelayi Roho mtakatifu.” ");
INSERT INTO kiz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lakini Petro akan'jobhela; hela jha jhobhi pamonga ni bhebhe ijhaghanikilayi patali, kwa ndabha udhanili kujha karama jha K'yara jhipalikana kwa hela. ");
INSERT INTO kiz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ujhelepi ni sehemu kulijambo e'le, n'nofu lepi mbele sya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hivyo basi, tubuayi maovu gha jhobhi ni kun'soka K'yara labda wibeta kusamehebhwa fikra sya muoyo ghwa jhobhi. ");
INSERT INTO kiz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwa maana nibhona ujhele mu sumu jha bhuchungu ni kifungu kya dhambi.” ");
INSERT INTO kiz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni akajibu ni kujobha, “Mun'sokayi Bwana kwa ndabha jha nene kwa kujha mambo ghoha ghamulongelili ghibhwesya kunitokela. ");
INSERT INTO kiz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wakati Petro ni Yohana bho bhashuhudili ni kuhubiri lilobhi lya Bwana, bhakakerebhuka Yerusalemu kwa njela ejhu; bhahubiri injili mu fijiji fingi fya bhasamaria. ");
INSERT INTO kiz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Basi malaika bha Bwana anenili ni Filipo ni kujobha, “Jhangasiajhi na ulotayi kusini kwa njela jhajhilota kusika jha Yerusalemu kulotela Gaza.” (Njela ejhe jhijhe mujangwa). ");
INSERT INTO kiz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Akajhangasya ni kulota. Langayi, kwajhele ni munu ghwa Ethiopia, towashi mwenye mamlaka mbaha pasi pa kandese; Malkia ghwa Ethiopia. Jhaabhekibhu panani pa hazina jha muene jhioha; nu muene akalota Yerusalemu kuabudu. ");
INSERT INTO kiz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wakati ikerebhuka atamili mu ligari lyamuene isoma chuo kya nabii Isaya. ");
INSERT INTO kiz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roho akajobha ni Filipo, “Hegelelayi karibu ni ligari e'le ukakamulana nalu. ");
INSERT INTO kiz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","“Efyo Filipo akalota mbio, akampeleka isoma mu chuo kya nabii Isaya; akajobha, umanyili kya wisoma?” ");
INSERT INTO kiz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Muethiopia akajobha, “nibebhwesya bhuli munu kama andongwisi lepi?” Akan'sihi Filipo akwela mu ligari ni kutama pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Henu lifungu lya maandiku lya asomeghe Muethiopia ndo e'le, Alongosibhu kama likondoo kulota kuchinjibhwa ku machinjioni; ni kama likondoo agudeme kinunu, afunguililepi kinywa kya muene. ");
INSERT INTO kiz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kwa huzunishibhwa kwa muene hukumu jha muene jhabhosibhu, niani jha ibetakujhelesya kizazi kya muene? maisha muene ghabhosibhu munchi.” ");
INSERT INTO kiz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hivyo towashi akan'kota Filipo, ni kujobha, “nikus'oka, nabii jholeku ilongelibhwa habari sya muene, ni kuhusu muene au sya munu jhongi”? ");
INSERT INTO kiz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo ajhandikulongela, abhwanji kwa andiko e'le lya Isaya kun'hubirira habari sya Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bhobhajhe munjela, bhakafika pa masi,' towashi akajobha, “Langayi, pajheni masi apa kheleku kizuila nisibatisibhu?” ");
INSERT INTO kiz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Malobhi agha, “Hivyo Muethiopia akajibu “Nikiera kujha Yesu Kristu ndo mwana ghwa K'yara,” ghajhelepi mu maandiku gha muandi). Ndipo Muethiopia akaamuru ligari lijhemayi. ");
INSERT INTO kiz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Bhakalota mugati mu masi, pamonga ni Filipo ni towashi, Filipoakambatisya. ");
INSERT INTO kiz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wakati bhofobhwiki mu masi, Roho ghwa Bwana jhampeliki Filipo patali; tawashi ambwene lepi, akalota njela jha muene khoni ishangilila. ");
INSERT INTO kiz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lakini Filipo akahomela Azoto. Apetili mu mkoa bhola ni kuhubiri injili mu miji ghioha mpaka bho afikili Kaisaria. ");
INSERT INTO kiz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lakini Sauli, ajhendelili kujobha fitisho ata fya kufwa kwa bhanafunzi bha Bwana, alotili kwa kuhani mbaha ");
INSERT INTO kiz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ni kun'soka barua kwa ndabha jha masinagogi oku Dameski, ili kwamba akankabha munu jha ajhe mu njela jhela ajhele n'gosi au n'dala, abhakongayi ni kubhaleta Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hata bho isafiri, jhatokili bho ikaribila Dameski, gafla jhikamwangasya kokuoha nuru kuh'omela kumbinguni,' ");
INSERT INTO kiz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ni muene akabina pasi na ap'eliki sauti jhikan'jobhela, “Sauli, Sauli, mbona ukanitesya nene?” ");
INSERT INTO kiz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli ajibili, bhebhe ghwe niani Bwana? Bwana akajobha, “Nene ndo Yesu jha ukanidadisya; ");
INSERT INTO kiz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lakini jhinukayi, jhingilayi ku mjini nabhi ghwibeta kujobhighwa gha wilondeka kubhomba. ");
INSERT INTO kiz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bhanu bhabhasafiri pamonga ni Sauli bhatulili kinunu, kupelekesya sauti, bhabhwelepi munu. ");
INSERT INTO kiz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli akajhinuka mu nchi na bho afunguili mihu gha muene abhwesilepi kulola khenu, bhakankamula kibhoko bhakandeta mpaka Dameski. ");
INSERT INTO kiz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa magono madatu ilolalepi, ilyalepi, wala kunywa. ");
INSERT INTO kiz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Basi pajhele ni mwanafunzi Dameski lihina lya muene Anania, Bwana ajobhinaku ku lugono, “Anania.” Na ajobhili, “Langayi, jhele apa, Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Bwana akan'jobhela, “Jhemayi ulotayi mu mtaa bhwa bhwikutibhwa Nyofu, ni mu nyumba jha Yuda na kakotelesiajhi munu kuhoma Tarso jhaikutibhwa Sauli; Maana akona isoka; ");
INSERT INTO kiz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na ambwene mu maono munu lihina lya muene Anania ijhingila ni kumbekela mabhoko panani pa muene kwamba abhwesyahi kulola. ");
INSERT INTO kiz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lakini Anania ajibili, “Bwana, nip'eliki habari sya munu ojhu kwa bhanu bhingi, kwa kiasi kereku abhabhombili mabhibhi bhatakatifu bha okhu Yerusalemu; ");
INSERT INTO kiz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Apa ajhe ni mamlaka kuhomakwa kuhani mbaha kun'kamula khila munu jha ikalitia lihina lya bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Bwana akan'jobhela, “Lotayi, kwandabha ndo khenu kiteule kwa nene alitolayi lihina lya nene mbele jha mataifa ni bhafalme ni bhana bha Israeli. ");
INSERT INTO kiz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Maana nibetakubhalasya ghaghajhe mingi ghaghibekundondeka kutesibhwa kwandabha jha lihina lya nene”. ");
INSERT INTO kiz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania akalota, akajhingila mugati mu nyumba m'ola; akambekela mabhokho akajobha, Ndongo Sauli, Bwana Yesu, jhaakuh'omili pa njela bho wihida, anilaghisi ukabhayi kulola kabhele na ujhiagha ni Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Gafla fikabina fenu pamihu pa muene kama magamba, abhwesi kulola, akajhema, akabatisibhwa akalya kyakulya ni kukabha nghofu. ");
INSERT INTO kiz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Akatama pamonga ni bhanafunzi okhu Dameski kwa magono ghamehele. ");
INSERT INTO kiz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wakati bhobhuobhu akan'tangasya Yesu mu masinagogi, akajobha kujha muene ndo mwana ghwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na bhoha bhabhap'eliki bhashangele ni kujobha, “Munu ojholepi jha abhaharibu bhoha bhabhakuti lihina e'le okhu Yerusalemu? Na apa ahidili kwa kusudi la kubhakhonga ni kubhap'eleka kwa Makuhani.” ");
INSERT INTO kiz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lakini Sauli abhwesibhu kuhubiri ni kubhafwanya bhayahudi bhabhetanieli Dameski bhachanganyikibhwayi ni kuthibitisha jha kujha ojho ndo Kristu. ");
INSERT INTO kiz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Baada jha magono ghamehele, bhayahudi bhakabhomba Shauri pamonga ili bhan'komayi. ");
INSERT INTO kiz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini mpango ghwa bhene ghwajulikene kwa Sauli. Bhakanvizila pa ndiangu pamusi ni pakilu bhabhwesyayi kun'koma. ");
INSERT INTO kiz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini bhanafunzi bha muene bhakan'tola pakilu bhakan'selesya kup'etela pa ukuta, bhakan'selesya pasi mu kapu. ");
INSERT INTO kiz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ni Sauli bho afikili Yerusalemu, ajaribu kwilonga ni bhanafunzi lakini bhakajha bhiken'tila bhakajha bhikiera lepi kama ni muene mwanafunzi. ");
INSERT INTO kiz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lakini Barnaba akan'tola ni kumpeleka kwa mitume, Ni kubhajhelesya jinsi Sauli kya ambwene Bwana munjele ni Bwana kyaajobhinaku, ni jinsi Sauli kyaahubiri kwa ujasiri kwa lihina lya Yesu okhu Dameski. ");
INSERT INTO kiz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Abhonene nabhu bho bhijhingila ni kupita Yerusalemu. Ajobhikwa ujasiri lihina lya Bwana Yesu, ");
INSERT INTO kiz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Akajhaihojiana ni bhayahudi bha kiyunani lakini bhakajha bhijaribu mara kwa mara kun'koma. ");
INSERT INTO kiz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wakati bhalongomunu bhamanyili lijambo elu, bhakan; tola mpaka Kaisari, na bhampelekayi alolayi Tarso. ");
INSERT INTO kiz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Basi likanisa lyoha mu bhuyahudi, Galilaya ni Samaria, lyajhele ni imani, na lyajengibhu, ni kugenda mu hofu jha Bwana ni faraja jha Roho mtakatifu, kanisa lyakholili kwa kujhongeseka idadi. ");
INSERT INTO kiz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kisha atokili Petro bho isyongokasyongoka pande syoha sya mkoa, akabhaselelela bhaumini bhabhatameghe mu mji ghwa Lida. ");
INSERT INTO kiz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ambwene okhu munu mmonga jhaakutibhweghe Ainea, munu ojhu ajhele pakitanda miaka mia nane; maana apozili. ");
INSERT INTO kiz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro akan'jobhela, “Ainea, Yesu Kristu akuponyiayi; Jhumukayi ni ukitandikilayi kitanda kya jhobhi,” Mara akajhumuka. ");
INSERT INTO kiz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ni bhanu bhoha bhabhatamili Lida ni Sharoni bho bhambwene munu ojhu, bhan'geukili Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pajhele ni bhanafunzi Yafa jhaakutibhweghe Tabitha, ambalyo lyatasfriribhu kama “Dorcas” N'dala ojhu ajasisi mambo kinofu ni matendo gha rehema ghaaghabhombi kwa maskini. ");
INSERT INTO kiz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jhatokili katika magono aghu alwalili ni kufwa; bhobhan'safisi, bhan'kwesi kichumba kya panani ni kun'goneka. ");
INSERT INTO kiz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kwa vile Lida kyaajhele karibu ni Yafa na bhanafunzi bhap'eliki kwamba Petro ajhele okhu, bhabhalaghisi bhabehle kwa muene bhakan'sihi, “Hidayi kwa tete bila kuchelebhwa.” ");
INSERT INTO kiz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petro akahema ni kubhoka pamonga ni bhene. bho afikiri, bhan'ndeitli mu kichumba kya panani. Ni bhajane bhoha bhajhemili karibu ni muene bhakajha bhilela, bhakajha bhakandasya likotili ni nghobho ambasyo Dorcas abhashonili wakati ajhe pamonga ni bhene. ");
INSERT INTO kiz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro akabhabhosya bhoha kwibhala ku kichumba, akapiga magoti akas'oka, kisha akabhugeukila mb'ele, akajobha, “Tabitha, jhumukayi”. Akafungula mihu gha muene na bho ambwene Petro akatama pasi. ");
INSERT INTO kiz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kisha Petro akampela kibhoko kya muene akanjinula, na bho abhakutili bhaamini ni bhajane, akabhakabidhi kwa bhene ajhe hai. ");
INSERT INTO kiz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lijambo e'lu lyamanyikene Yafa jhioha, ni bhanu bhingi bhakamwamini Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jhatokili Petro atamili magono mingi Yafa pamonga ni munu jhaakutibheghe Simoni, n'tengenesya ngozi. ");
INSERT INTO kiz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwajhele ni munu fulani mu mji ghwa Kaisaria, lihina lya muene Kornelio, ajhele mbaha ghwa kikosi kya kiitalia. ");
INSERT INTO kiz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ajhe mchamungu na amwabuduili K'yara ni nyumba jha muene jhioha ahomisi hela nyingi kwa bhayahudi na asokili kwa K'yara magono ghoha. ");
INSERT INTO kiz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Muda ghwa saa tisa gha pamusi, abhwene maono Malaika ghwa K'yara ihida kwa muene. Malaika akan'jobhela ");
INSERT INTO kiz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","“Kornelio! Kornelio akandanga malaika na ajhele ni hofu mbaha sana akajobha “Ejhe ndo kiki n'kolo?” Malaika akan'jobhela “Maombi gha jhobhi ni zawadi sya jhobhi kwa maskini sikwelili kunani kama kumbukumbu mu uwepo bhwa K'yara”. ");
INSERT INTO kiz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Henu laghisiajhi bhanu kulota mji ghwa Yafa kundeta munu mmonga jhaikutibhwa Simoni ambaye pia ikutibhwa Petro. ");
INSERT INTO kiz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Itamana ni n'tengenesiajhi ghwa ngozi jhaikutibhwa Simoni ambajhe nyumba jha muene ijhele kando jha bahari.” ");
INSERT INTO kiz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Baada jha Malaika jha ajobheghe nu muene kubhoka, kornelio akabhakuta bhatumishi bha panyumba jha muene bhabhele ni askari jha amwabudueghe K'yara kati jha maaskari bhabhan'tumikileghe. ");
INSERT INTO kiz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelio akabhajobhela ghoha ghaghatokili ni kubhalaghisya Yafa. ");
INSERT INTO kiz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ligono lyalyafwatili muda ghwa saa sita bho bhajhe munjela na bhikaribila ku mjini Petro akakuela panani pa darini kus'oka. ");
INSERT INTO kiz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na kabhele ajhele ni njala naalondeghe kulya khenu, lakini wakati bhanu bhiteleka kyakulya, akalasibhwa maono. ");
INSERT INTO kiz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Akabhona anga lifunguiki ni khenu kiselela ni khenu fulani kama nghobho mbhaha jhiselela pasi pa ardhi mu kona syake syoha nne. ");
INSERT INTO kiz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mugati mwake kwajhele ni aina syoha sya bhanyama bhenye magolo mancheche na bhabhiboya panani pa ardhi, ni fidege fya anga. ");
INSERT INTO kiz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kabhele sauti ikajobha kwa muene “Jhumukayi, Petro chinja ni bhola”. ");
INSERT INTO kiz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lakini Petro akajobha “Naha lepi, Bwana kwandabha nibhwayilepi kulya khenu kyokyoha najisi na kichafu. ");
INSERT INTO kiz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lakini sauti ikahida kwa muene kabhele kabhele mara jhe pili “Kyaakitakasili Mungu ghilondeka lepi kukikuta najisi wala kichafu”. ");
INSERT INTO kiz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ejhe jhatokili mara tatu ni khenu kela kikajha kitolibhu kabhele angani. ");
INSERT INTO kiz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ni Petro bho ajhele katika hali jha kuchanganyikibhwa juu jha maono aghu ghimaanisha kiki, Langayi, bhanu bhabhatumibhu ni Kornelio bhakajhema palongolo ndiangu, bhakajha bhikota jhela jha kulota mu nyumba. ");
INSERT INTO kiz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na bhakakuta ni kukotelesya kama Simoni ambajhe pia akutibhu Petro kama atameghe pala. ");
INSERT INTO kiz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Wakati obhu Petr ibhwasya juu jha maono aghu, Roho akajobha nakhu, “Langayi bhanu bhadatu bhikulonda. ");
INSERT INTO kiz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jhumukayi na uselelayi pasi na ulotayi nabhu. Usitili kulota nabhu, kwa ndabha nibhalaghisi.” ");
INSERT INTO kiz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petro akaselela pasi kwa bhene ni kujobha, “Nene ndo jhola jha mukandonda kwandajha kiki muhidili?” ");
INSERT INTO kiz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhakajobha, “Akida mmongalihina lya muene Kornelio, munu ghwa haki ni kugana kumwabudu K'yara ni bhanu bhakan'jobha kinofu mu litaifa lyoha lya kiyahudi, ajobhibhu ni malaika ghwa K'yara kukulaghisya ili kulota ku nyumba jha mene, ili ap'elekayi ujumbe kuhomela kwa bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro akabhakaribisya kujhingila mugati ni kutama pamonga ni muene, Lukhela bhakajhumuka bhakalota pamonga ni muene, ni bhalongomunu bhadebe kuhomela Yafa bhakalongosana naku. ");
INSERT INTO kiz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ligono lyalyafwatili bhahidili Kaisaria. Ni Kornelio akajha akabhalendela; na abhakutili ni bhalongo munu ni bharafiki zake bha karibu. ");
INSERT INTO kiz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wakati Petro ijhingila mugati Kornelio akamlaki ni kujhinama hadi pais mu magolo gha muene kwa kun'heshimu. ");
INSERT INTO kiz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lakini Petro an'jhinuili ni kujobha “Jhemayi; ne mwene ne mwanadamu.” ");
INSERT INTO kiz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wakati Petro ilongela naku, alotili mgati abhwene bhanu bhabhonganiki pamonga. ");
INSERT INTO kiz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Akabhajobhela, “Mwejhomu mumanyili kujha sheria lepi jha kiyahudi kushirikiana au kugendibhwa ni munu ambajhe wa taifa e'le lepi. Lakini K'yara andasi nene kujha nilondeka lepi kun'kuta munu jhejhioha ndo najisi au n'chafu. ");
INSERT INTO kiz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na ndo maana nihidili bila kubishila, bhonilaghisibhu kwa ndabha jha ejhu. Hene nibhakotayi kwandayakiki mwalaghisibhu kwandabha jha nene.” ");
INSERT INTO kiz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio akajobha, “Magono mancheche gha ghalotili, wakati kama obho nikajha nis'oka muda ghwa saa tisa pamusi mugati mu nyumba jha nene; Nabhwene palongolo pa nene munu ajhemili ajhe ni maguanda mabhalafu, ");
INSERT INTO kiz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akan'jobhela “Kornelio maombi gha jhobhi ghap'elibhu ni K'yara, ni zawadi sya jhobhi kwa maskini sijhele sya ukumbusho mbele sya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kwa hiyo laghisiajhi munu Yafa na akan'kutayi munu mmonga jhaikutibhwa Simoni ahidayi kwa bhebhe, ambajhe ikutibhwa Petro ambajhe iishi kwa n'tengenesya ngozi mmonga jhaikutibhwa Simoni ambajhe nyumba jha muene ijhele pembeni mwa bahari. ");
INSERT INTO kiz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zingatilayi: N'sitari obho, “Nu muene pa ibeta kuhida ibeta kujobha namu,” bhujhelepi mu aandiku gha muandi. ");
INSERT INTO kiz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndipo Petro akajhajhula ndomo ghwa muene ni kujobha “Kweli, nikiera K'yara ibhwesya lepi kujha ni upendeleo. ");
INSERT INTO kiz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Badala jhike khila taifa munu jhejhioha jha ikamwabudu ni kubhomba matendo gha haki ijhedekelibhwa kwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Umanyi ujumbe bhwa abhupisi kwa bhana bha Israeli, bho itangasya habari sinofu sya amani kup'etela Yesu Kristu ambajhe ni Bwana ghwa bhoha- ");
INSERT INTO kiz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwejhomo mumanyili litukio lya litokili, ambalyo litokili Yudea jhioha na lyajhandili Galilaya, baada jha ubatizo ambabho Yohana alangasili. ");
INSERT INTO kiz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yukio lya limhusueghe Yesu Kristu jinsi K'yara kya an'sopili mafuta kwa Roho mtakatifu ni kwa nghofu. Alotili kubhomba manofu ni kupongesya bhoha bhabhatesibhu ni ibilisi kwa kujha K'yara ajhele pamonga na bhene. ");
INSERT INTO kiz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tete ndo mashahidi bha mambo ghoha gha aghabhombili mu nchi sya uyahudi ni mu Yerusalemu- ojho ndo Yesu jhabhan'komili ni kun'tondeka pa libehe. ");
INSERT INTO kiz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Munu ojho K'yara amfufuili ligono lya tatu ni kumbeka kumanyikana, ");
INSERT INTO kiz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","tete kwa bhanu bhoha, lakini kwa mashahidi bhabhachagulibhu kabla ni K'yara - tete twebhene, jha twalili naku ni kunywa naku baada jha kufufuka kuhoma kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atulaghisi kuhubiri kwa bhanu ni kushuhudila kujha mwamuzi ghwa bhabhajhe hai ni bhoha bhabhafuili. ");
INSERT INTO kiz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kwa muene manabii bhoha bhashuhudilayi, ili kwamba khila jha iamini kwa muene apokelayi msamaha ghwa dhambi kup'etela lihina lya muene.” ");
INSERT INTO kiz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wakati Petro ijhendelela kujobha agha, Roho mtakatifu akabhajaza bhoha bhabhajhele bhip'elekesya ujumbe bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bhanu bhala bha bhihusika ni kikundi kya bhaamini bhabhatahiribhu- bhoha bhabhahidili ni Petro- bhasyangesibhu, kwa ndabha jha karama jha Roho mtakatifu jhaamwagibhu pia kwa bhamataifa. ");
INSERT INTO kiz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwa kujha bhap'eliki abha bhamataifa bhilongela kwa lugha s'enge ni kumwabudu K'yara. Petro ajibili, ");
INSERT INTO kiz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ajhe munu jhejhioha jhaibhwesya kuzuila masi ili bhanu bhasibatisibhu, bhanu abha bhampokili Roho mtakatifu kama tete?” ");
INSERT INTO kiz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ndipo akabhaamuru bhabatisibhwayi kwa lihina lya Yesu Kristu. Baadaye bhakan'soka atama ni bhene kwa magono kadhaa. ");
INSERT INTO kiz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mitume ni bhalongo bhale bhabhajhe okhu Yudea bhap'eliki kujha bhamataifa bhalipokili lilobhi lya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petro bho ahidili okhu Yerusalemu, likundi lya bhanu bha bhatahiribhu bhakajhanda kun'kosola, bhakajobha, ");
INSERT INTO kiz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ushikamane ni bhanu bhabhabeli kutahiribhwa na wilya nabhu!” ");
INSERT INTO kiz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lakini Petro akajhanda kujhelesya litukio kwa kina, akajobha, ");
INSERT INTO kiz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nisomeghe mu ghwa Yafa, na nabhwene maono gha khenu kiselela pasi kama nghobho jhiselela kuhomela kumbinguni mu pembe syake syoha. kyaselili kwa nene. ");
INSERT INTO kiz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nakilolili ni kufikirira juu jha kiene. Nabhabhwene bhanyama bhenye magolo mancheche bhabhitama mu nchi ni bhanyama bha mudasi ni bhanyama bhabhi boya ni fidege fya angani. ");
INSERT INTO kiz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kisha nikap'eleka sauti jhijobha ni nene, “jhumukayi, Petro, chinjayi nauliayi!” ");
INSERT INTO kiz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikajobha, “Nahalepi, Bwana, mundomo mwa nene kibhwayilepi kujhingila khenu kyokyoha kyakibeli kujha kitakatifu au kichafu” ");
INSERT INTO kiz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lakini sauti jhajibi kabhele kuhomela kumbinguni, khela K'yara kya kakitangaseli kujha kinofu, usikikuti najisi, ");
INSERT INTO kiz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ejhe jhatokili mara sidatu na khila khanu kyatolibhu kumbinguni kabhele. ");
INSERT INTO kiz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Langayi bwakati obhu bhanu bhadatu bhajhela bhajhele; bhatumibhu kuhomela Kaisaria kuhida kwa nene. ");
INSERT INTO kiz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roho akanijobhela lotayi nabhu, na nisitofautiani nabhu. Abha bhagosi sits bhakalota pamonga ni nene na twalitili munyumba jha munu mmonga. ");
INSERT INTO kiz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Atujobhili fela kyambwene malaika ajhe mili mugati mu nyumba jha muene akajobha, “Nilaghisiayi Yafa nikandetayi Simoni ambajhe lihina l'enge Petro. ");
INSERT INTO kiz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ibeta kujobha ujumbe kwa bhebhe muobhu wibeta kuokoka bhebhe ni nyumba jha jhobhi jhioha.” ");
INSERT INTO kiz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Bhonijhandi kujobha nabhu, Roho mtakatifu akahida panani pa bhene kama kya ahidili kwa tete kubhwandelu. ");
INSERT INTO kiz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nikomboka malobhi gha Bwana, kya ajobhili, “Yohana abatisibhu kwa masi, lakini mwibeta kubatisibhwa kwa Roho mtakatifu.” ");
INSERT INTO kiz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kabhele kama K'yara ahomisi zawadi kama sya atupelili tete potukyeriri Bwana Yesu kristu, nene ne niani kujha nibhwesya kumpinga K'yara? ");
INSERT INTO kiz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bhobhap'eliki mambo agha, bhakerebhuisi lepi, bali bhan'sifili K'yara ni kujobha, “K'yara apisi toba kwa ajili jha bhamataifa kabhele.” ");
INSERT INTO kiz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Basi bhaamini ambabho malombosi ghajhandili mu kifo kya stefano bhatawanyiki kuhoma Yerusalemu- bhaamini abha bhalotili patali hadi mpakaFoinike, Kipro ni Antiokia. Bhabhajobhili ujumbe kuhusu yesu muene kwa bhayahudi na sio kwa jhongi jhejhioha. ");
INSERT INTO kiz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini baadhi jhabhene ndo bhanu kuhoma kipro ni krene, bhahidili Antikia ni kujobha ni bhayunani ni kun'hubiri Bwana Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ni kibhoko kjya Bwana bhwajhele pamonga ni bhene, na bhanu bhingi bhakeriri ni kun'geukila Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Habari sya bhene syafikili mu mb'olokoto mwa kanisa lya Yerusalemu: na bhan'tumili Barnaba alotayi mpaka Anttikia. ");
INSERT INTO kiz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bho ahidi ni kubhona karama jha K'yara ahobhwiki; na abhapeli muoyo bhuoha kubakila ni Bwana mu mioyo ghya bhene. ");
INSERT INTO kiz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kwa ndaba ajhele munu mwema na amemesibhu ni Roho mtakatifu ni imani ni bhanu bhamehele bhakajhongeseka kwa Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Baadaye Barnaba alotili Tarso kumbona Sauli. ");
INSERT INTO kiz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bho an'kabhili, akandeta Antiokia. Akajha kwa mwaka ghuoha bhakabhonganika pamonga ni kanisa ni kubhamanyisya bhanu bhamehele. Ni bhanafunzi bhakakutibhwa bhakristu kwa mara jha kuanza okhu Antiokia. ");
INSERT INTO kiz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ni katika magono agha manabii bhakaselela kuhomela Yerusalemu, mpaka Antiokia. ");
INSERT INTO kiz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mmonga bhabhi Agabo ndo lihina lya muene, akajhema iashiribhwa ni Roho kujha njala jhikali jhibeta kutokela pa ulimwengu poha Ese syahomili wakati wa magono gha Klaudio. ");
INSERT INTO kiz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kwa hiyo bhanafunzi khila mmonga kya afanikibhu, bhaamuili kupeleka misaada kwa bhalongobhe jhe Uyahudi. ");
INSERT INTO kiz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhabhombi naba; bhalaghisi hela kwa kibhoko kya Barnaba ni Sauli. ");
INSERT INTO kiz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bwakati obhu mfalme Herode akanyosya kibhoko kya muene kwa baadhi jha bhala bhabhihomela ku kusanyiko ili kubhatesya. ");
INSERT INTO kiz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akan'koma Yakobo ndongomunu Yohana kwa upanga. ");
INSERT INTO kiz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Baada jha kubhona ikabhapendesya Bhayahudi akan'kamula ni Petro kabhele. Ejhe jhajhela wakati bhwa mikate jha jhibeli kulola. ");
INSERT INTO kiz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bho an'kamuili, akambeka mu ligereza ni kubheka fikosi fincheche fya askari ili kundonda Petro, akajha itarajila kumpeleka kwa bhanu baadajha pasaka. ");
INSERT INTO kiz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petro abhakibhu mu ligereza, lakini maombi gha bhombiki kwa bidii ni likusanyiku kwa ndabha jhe muene kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ligono kabla Herode alotilepi kumpisya, kiru abhu Petro agonili katikati jha maaskari bhabhele akajha akanjibhu minyororo mibhele, ni bhalinzi mbele jha ndiangu bhakajha bhilenda gereza. ");
INSERT INTO kiz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Langagi, malaika bha Bwana ghafla akantokela ni nuru jhikan'g'ara mugati. Akajotobha Petro Petro mu ubhafu ni kunjumuisya akajobha, “Jhumukayi manyata.” Ndipo minyororo gha aka akongibhu ghyabhopuiki mu mabhoko gha muene. ");
INSERT INTO kiz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaika akan'jobhela, “Fwatayi liguanda lya jhobhi na unitesiajhi.” Hivyo Petro akankesya Malaika ni kuhoma kwibhala. Aaminilepi kya kya bhombiki ni ");
INSERT INTO kiz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Hivyo Petro akankesya Malaika ni kuhoma kwibhala. Aaminilepi kya kya bhombiki ni Malaika kama kya bhukweli. Afikirileghe ibhona maono. ");
INSERT INTO kiz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baada jha kupeta lindo lya chuma lya kujhingilila kulota kumjini likafunguka lyene kwa ndabha jha bhene. Bhakapita kwibhala bhakaselela ku mtaa, mara Malaika akandeka. ");
INSERT INTO kiz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petro bho akimbuili, akajobha, “Henu ni amini kujha Bwana andaghisi Malaika ghwa muene ili kunibhosya mu mabhoko gha Herode, ni kwa matarajio gha bhanu bhoha bha uyahudi.” ");
INSERT INTO kiz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","baada jha kumanya agha, akahida mu nyumba jha manamu nyinamunu Yohana ambaye ndo Marko; bhakristu bhamehele bha bhonganiki bhis'oka. ");
INSERT INTO kiz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bhoabishili pa ndiangu ghwa kizuizi, n'tumishi mmonga n'dala jhaakutibhweghe Roda akahida kufungula. ");
INSERT INTO kiz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bhoatamuili sauti jha Petro, kwa furaha akasindwa kudendula ndiangu. Badala jhiake akajumba mugati mu kichumba: ni kubhajulisya ku jha Petro ajhemili pa ndiangu. ");
INSERT INTO kiz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hivyo bhakajobha kwa muene, “Bhebhe ndo mwendawazimu.” Lakini akazili kujha ndo kweli ndo muene. Bhakajobha “Ojho ndo Malaika ghwa muene.” ");
INSERT INTO kiz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lakini Petro ajhendelili kubisha, na bho bhahinguili ndiangu, bhakambona na bhashangele sana. Petro akabhagudamisya kibhokho kimyakimya ni kubhajobhela jinsi Bwana kyaambosili mu ligereza. Akajobha, ");
INSERT INTO kiz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Bhajulishayi mambo agha Yakobo ni bhalongo munu.” Kisha akabhoka akalota sehemu jhenge. ");
INSERT INTO kiz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pamusi, kwahjele ni huzuni mbaha kati jha askari, kuhusiana ni kyakitokili kwa Petro. ");
INSERT INTO kiz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Baada jha Herode kundonda na ambwene lepi akabhakota bhalinzi ni kuamuru bhakonibhwayi. Akalota kuhoma Uyahudi mpaka Kaisaria ni kutama okhu. ");
INSERT INTO kiz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode ajhele ni ligoga juu jha bhanu bha Tiro ni Sidoni. Bhakalota kwa pamonga kwa muene. Bhakejha ni urafiki ni Blasto msaidizi ghwa mfalme, ili abhasaidilayi. Kisha bhakasoka amani, kwa ndabha nchi jha mfalme. ");
INSERT INTO kiz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ligono lya kusudibhu Herode afwalili maguanda gha kifalme ni kutama pa kiti kya muene kya kifalme, ni kubhahutubila. ");
INSERT INTO kiz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bhanu bhakapiga maghuegho, “Ejhe ndo sauti jha K'yara wala sio sauti jha mwanadamu.” ");
INSERT INTO kiz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mara ghafla Malaika akan'tobha kwa ndabha ampelililepi K'yara utukufu; alelibhu ni chango na afuili. ");
INSERT INTO kiz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lakini lilobhi lya k'yara likakhola ni kusambala. ");
INSERT INTO kiz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baada jha Barnaba ni Sauli kukamilisya huduma jha bhene bhakabhoka pala bhakakerebhuka Yerusalemu, bhakan'tola ni Yohana ambajhe lilina lya kuhogoleka ndo Marko ");
INSERT INTO kiz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Henu mu kanisa lya Antiokia pajhele n baadhi jha manabii ni bhalimu. Bhajhele Barnaba, Simeoni (jhaakutisbhu Nigeri). Lukio wa Kirene, Manaeni (Ndongo jha abeli kujha ghwa damu ghwa Herode kiongozi ghwa mkoa), ni Sauli. ");
INSERT INTO kiz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bho bhakamwabudu Bwana ni kufunga, Roho mtakatifu ajobhili, “Munitengelayi palubhafu Barnba ni Sauli bhaibhombayi mbombo jha nibhakutili.” ");
INSERT INTO kiz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Baada jha kanisa kufunga, kus'oka, ni kubheka mabhoko gha bhene panani pa bhanu abha bhakabhaleka bhalotayi. ");
INSERT INTO kiz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kwa hiyo Barnabasi ni Sauli bhantiijhi Roho mtakatifu na bhaselili kulota seleukia; kuhomela okhu bhasafiri mu bahari kulotela kisiwa kya Kipro. ");
INSERT INTO kiz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bho bhajhe mu mji ghwa Salami, bhalitangasili lilobhi lya K'yara mu masinagogi gha bhayahudi. Pia bhajhele pamonga ni Yohana Marko kama msaidizi ghwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bho bhalolili katika kisiwa kyoha mpaka Pafo, bhan'kolili munufulani mmabhi Myahudi nabii ghwa bhudesi ambajhe lihina lya muene lyajhele Bar Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mmabhi ojho ashirikiene ni liwali Sergio Paulus, jha ajhele munu mwenye luhala. Munu ojho abhaaliki Barnaba ni Sauli kwandabha alondeghe kupeleka lilobhi lya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini Elima “mmabhi jhola” (Naha ndo lihina lya muene kya lyatafsiribhu) abhapingili; ajaribu kugeusya liwali jhola abhoka mu imani. ");
INSERT INTO kiz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lakini Sauli jha akutibhweghe Paulo, ajhele amemesibhu Roho mtakatifu, akan'kazila mihu ");
INSERT INTO kiz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ni kujobha, “Ewe muana ghwa ibilisi umemesibhu ni aina syoha sya udesi ni udhaifu. Bhebhe ndo adui ghwa kila aina jha haki. Wibetalepi kuleka kusigeusya nj'ela sya Bwana, syasinyeokili je, wibeta kubhwenya? ");
INSERT INTO kiz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Henu langayi, kibhoko kya Bwana kijhe panani pa jhobhi, na wibeta kujha kipofu. Wibetalepi kulibhona lijobha kwa muda “Mara jhejhuejhu ukungu ni ngisi fyabinili panani pa Elimasi; akajhanda kusyngoka pala kus'oka bhanu bhandongo syajhi kwa kun'kamula kibhoko. ");
INSERT INTO kiz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Baada jha liwali kubhona kya kitokili akyelili kwandabha asyangesibhu kwa mafundisu kuhusu Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Henu Paulo ni rafiki bha muene bhasafiri mjini kuhoma Pafo na bhafikiri Perge mu Pamfilia. Lakini Yohana akabhaleka ni kukerebhuka Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulo ni rafiki yake bhasafiri kuhoma Perge na bhafikili Antiokia jha Pisidia. Okhu bhalotili mu sinagogi ligono lya sabato ni kutama pasi. ");
INSERT INTO kiz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Baada jha kusoma sheria ni manabii bhalongosi bha sinagogi abhakalaghisili ujumbe bhakajobha, “Ndongo, kama mujhe ni ujumbe bhwa kupela muoyo bhanu apa, mujobhayi” ");
INSERT INTO kiz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kwa hiyo Paulo akajhema ni kubhapungila kibhoko; akajobha, “Bhagosi bha Israeli ni mwamukan'tii K'yara, mupelekisiajhi. ");
INSERT INTO kiz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","K'yara ghwa abha bhanu bha Israeli abhachaguili bha dadijhitu ni kubhabhomba bhanu bhamehele bho bhitama mu nchi jha Misri na kwa kibhoko kya muene kujhinulibhwa abhalonguisi kwibhala kwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwa miaka arobaini abhavumilili pa jangwa. ");
INSERT INTO kiz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Baada jha kughaharibu mataifa saba pa nchi jha kaanani, abhapelili bhanu bha tete nchi jha bhene kwa urithi. ");
INSERT INTO kiz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Matukio agha ghoha ghatokili zaidi jha miaka mia nne na hamsini. Baada jha fenu efe fyoka, K'yara abhapelili bhaamuzi mpaka Samweli Nabii. ");
INSERT INTO kiz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Baada jha agha, bhanu bhasokili mfalme, hiyo K'yara abhapelili Sauli mwana ghwa Kishi munu ghwa kabila lya Benjamini, kujha mfalme ghwa miaka arobaini. ");
INSERT INTO kiz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kisha baada jhe K'yara kumbosya mu ufalme an'jinuili Daydi kujha mfalme ghwa bhene. Jhajhele kuhusu Daudi kwamba K'yara ajobhili, 'Nin'kabhili Daudi mwana ghwa Yese kujha munu jha aganikibhu ni muoyo bhwa nene; ambaye ibeta kubhomba khila khenu kyanilonda. ");
INSERT INTO kiz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhomela mu lukholo lwa munu ojho K'yara ajhiletili Israeli mkombozi Yesu, kama kya ahidi kubhomba. ");
INSERT INTO kiz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ele lyabhwajhili kuhomele, kabla jha Yesu kuhida Yohana kwanza atangasili ubatisu bhwa toba kwa bhanu bhoha bha Israeli. ");
INSERT INTO kiz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu muene Yohana bho imalisila mbombo jha muene, ajobhili, 'Mwifikiri nene ne niani? Nene ne jhola lepi. Lakini map'elekesiajhi jhaibe takuhida kumbele jha nene, nilondekalepi kuhobhosya filatu fya muene mu magolo. ");
INSERT INTO kiz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ndongo bhana bha lukholo lwa Abrahamu, ni bhala ambabho kati jha muenga mukamwabudu K'yara, kwandabha jha tete kwamba ujumbe obho bhwa ukombozi ulaghisibhu. ");
INSERT INTO kiz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwa bhala bhabhitama Yerusalemu, ni bhatawala bha bhene bhan'tambuili lep kwa bhuhalisia, na bhwala bhan'tambuili lepi ujumbe bhwa manabii kwa kun'hukumu kifo Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Japokuwa bhakabhilepi sababu jhinofu jha kifo mugati mwa muene bhakan'soka Pilato an'komayi. ");
INSERT INTO kiz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bho bhamalili mamboghohe ghaghalembibhu kuhusu muene, bhakan'selesya mu libehe ni kungoneka mu likaburi. ");
INSERT INTO kiz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini K'yara amfufuili kuhoma kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Abhonekana kwa magono ghamehele kwa bhala bhabhalotili pamonga ni muene kuhoma Galilaya kulotela Yerusalemu. Bhanu abha henu ndo mashahidi bhabhanu. ");
INSERT INTO kiz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Hivyo tukabhaletela habari jhinofu kuhusu ahadi sya bhapelibhu bhakhokho bhitu. ");
INSERT INTO kiz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","K'yara abhakili ahadi e'se kwa tete, bhana bhabhi, kwa e'lu amfufuili Yessu ni kun'kerebhusya kabhele mu uhai. E'le kabhele lyalembibhu mu Zaburi, jha pili; Bhebhe ghwe mwanabhangu lelu njele ne Dadijhu. ");
INSERT INTO kiz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kabhele kuhusu bhukweli ni kwamba amfufuili kuhomela kwa bhafu ili kwamba mb'ele ghwa muene usiharibiki, alongili naha. Nibeta kup'ela utakatifu ni baraka halisi sya Daudi. ");
INSERT INTO kiz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ejhe ndo sababu jha kujobha kabhele mu Zaburi jh'enge, ghwibetalepi ni husu mtakatifu ghwa jhobhi kubhubhona uozo.' ");
INSERT INTO kiz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kwa kujha baada jha Daudi kutumikila mapenzi gha K'yara pa kizazi kya muene, agonili agonesibhu pamonga ni bha dsdi jhabhi, na abhubhwene uharibifu, ");
INSERT INTO kiz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini jhaafufulibh ni K'yara aubhwelepi uharibifu. ");
INSERT INTO kiz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Efyo na imanyikanayi kwa muenga, ndongo, kup'etela munu ojho, n'samaha ghwa dhambi uhubiribhu. ");
INSERT INTO kiz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwa muene khila jhaiamini ibhalangibhwa haki kwa mambo ghoha ambagho sheria jha Musa ngajhibhepelilepi haki. ");
INSERT INTO kiz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hivyo basi mujhelayi bhaangalifu kwamba khenu kya bhakilongelili manabii kisihomeli kwa jhomu: ");
INSERT INTO kiz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Langayi, enyi bha mwidharau, na mkasya nngalayi ni kujhangamila; kwa vile nibhomba mbombo ambayo mwibhwesya lepi kujhikiera, hata kama munu ibetakubhajhelesya. ");
INSERT INTO kiz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bwakati Paulo ni Barnaba bho bhabhokili, bhanu bhakabhas'oka bhelongelayi malobhi agha ligono lya sabato ijayo. ");
INSERT INTO kiz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bwakati mkutano wa sinagogi bho bhumaliki Bhayahudi bhingi ni bhaongofu thabiti bhabhakesisi Paulo ni Barnaba, ambabho bhalongili nabhu na bhabhahimizi bhajhendelelayi mu neema jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabato jhajhafwatili karibu mji bhuoha bhwabhonganiki kupeleka litobhi lya K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bhayahudi bho bhabhuene makutano, bhajhe ni bhwifu ni kulongela malobhi ghaghapingili fenu fyafijobhibhu ni Paulo na bhindighili. ");
INSERT INTO kiz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lakini Paulo ni Barnaba bhalongili kwa ujasiri ni kujobha, “Jhajhemuhimu kwamba lilobhi lya K'yara lilongelibhwayi kwanza henu. Kwa kujha mkalisukumila patali kuhomela kwa muenga ni kwibhona kujha mkastahililepi uzima bhwa milele mulangayi twibeta kubhageukila mataifa. ");
INSERT INTO kiz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kama vile Bwana kya atuamuamuili, akajobha, Nibhabhekili muenga kama nuru kwa bhanu bha mataifa, kwamba mletayi wokovu kwa pande syoha sya dunia.” ");
INSERT INTO kiz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mataifa bho bhap'eliki e'le, bhahobhelili ni kulisifila lilobhi lya Bwana. Bhingi bha bhasalibhu kwa uzima bhwa milele bhakyeriri. ");
INSERT INTO kiz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilobhi lya Bwana lyaenili nchi jhioha. ");
INSERT INTO kiz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lakini Bhayahudi bhabhasokili bhabhakihomisi ni bhadala muhimu, kabhele ni bhalongosi bha mji. Agha ghachochili malombosi dhidi jha Paulo ni Barnaba na bhabhataghili kwibhala kumipaka ghya mji. ");
INSERT INTO kiz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Lakini ni Paulo ni Barnaba bhakung'utili lifu mafumbi lya magolo gha bhene. Kisha bhalotili mu mji bhwa Ikonia. ");
INSERT INTO kiz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ni bhanafunzi bhamemili ni furaha pamonga ni Roho mtakatifu. ");
INSERT INTO kiz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jhatokili mu Ikonio kujiha paulo ni Barnaba bhajhingili pamonga mu sinagogi lya Bhayahudi ni kulongela namana ambajho likundi libhaha lya bhanu Bhayahudi ni Bhayunani bhakyeriri. ");
INSERT INTO kiz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Bhayahudi bhabhalii bhabhachochili luhala bhamataifa ni kubhabhomba khujha bhbhibhi dhidi jha ndongo. ");
INSERT INTO kiz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kwa hiyo bhatamili okhu kwa muda mrefu, bhaka jhabhilongela kwa ujasiri kwa ngofu, jha Bwana, kuni ipisya uthibitisho kuhusu ujumbe bhwa neema jha muene. Abhombi naha kwa kubhosya isshara ni maajabu fibhombibhwayi kwa mabhoko gha Paulo ni Barnaba. ");
INSERT INTO kiz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lakini lieneo libhaha lya mji lyagabhwanyiki baadhi jha bhanu bhajhele pamonga ni Bhayahudi ni baadhi pamonga ni mitume. ");
INSERT INTO kiz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bwakati bhamataifa ni Bhayahudi bhobhajaribu kubhashawishi bhalongosi bha bhene kubhabhombela vibaya ni kubhaponda ni maganga Paulo ni Barnaba, ");
INSERT INTO kiz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bhakalimanya e'lu ni kujumbila mu miji ghya Likonia, Listra ni Derbe, ni maeneo ghaghisyongo'ka pala, ");
INSERT INTO kiz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ni okhu bhahubiri injili. ");
INSERT INTO kiz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ni okhu Listra pajhele ni munu mmonga jhaatameghe, ajhelepi ni ngofu mumagolo gha muene, kilema kuhomela mu lileme lya nyinamunu, abhwayilepi kugenda. ");
INSERT INTO kiz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Munu ojho ampeliki Paulo ilongela. Paulo ankazili mihu ni kubhona ajhele ni imani jha kunyesibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Hivyo ajobhili kwa muene kwa sauti mbaha, “Jhemayi kwa magolo gha jhobhi” Ni munu jhola aniki kunani ni kuyanda kugenda. ");
INSERT INTO kiz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bhumati bho bhubhwene kya abhombili Paulo bhajhinuili sauti sya bhene bhakajha bhijobha kwa lahaja jha kitikanio, “Miungu jhituselelili kwa namna jha binadamu.” ");
INSERT INTO kiz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhan'kutili Barnaba “Zeu,” ni Paulo “Herme.” Kwa ndabha ajhele msemaji mbaha. ");
INSERT INTO kiz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kuhani ghwa Zeu, ambajhe hekalu lya muene lyajhele kwibhala ku mji aletili fahari la ng'ombe ni ntongo ghwa maua mpaka ku ndiangu ghwa mji muene ni umati bhalondeghe kuhomesya sadaka. ");
INSERT INTO kiz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lakini mitume, Barnaba ni Paulo, bho bhalipeliki e'le, bharaneili maguanda gha bhene manyata bhakalota kubhala ku umati bhilela. ");
INSERT INTO kiz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ni kajobha, “Enyi bhanu, kwandayakiki mwibhomba mambo agha? ni tete kabhele twebha binadamu bhenye ligoga kama lya muenga. Tukabhaletela habari njema, kwamba mgeukayi kuhomela mu fiti efufya fitondikalepi ni kulota kwa K'yara jha ajhe hai jhaabhombi mbingu, dunia ni bahari ni khila khenu kyakijhele. ");
INSERT INTO kiz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mu nyakati sya silotili, abharuhuisi mataifa kugenda mu njela sya bhene. ");
INSERT INTO kiz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lakini bado abhokilepi bila shahidi, kwa e'lu abhombi kinofu na abhapelili fula kuhoma kumbinguni ni nyakati sya mazao akajhimemesya mioyo ghinu kwa fyakulya ni furaha. ");
INSERT INTO kiz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hata kwa malobhi agha Paulo ni Barnaba kwa shida bhakauzuila umati kubhasopela sadaka. ");
INSERT INTO kiz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lakini baadhi jha Bhayahudi kuhomela Antiokia ni Ikonio bhahidili kuushawishi umati. Bhan'homelili maganga Paulo ni kundundusya hadi kwibhala ku mji, bhakajha bhitegemela afuili. ");
INSERT INTO kiz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hata naha bhanafunzi bhajhele bhajhemili karibu nabhu ajhu muiki, bhakajhingila ku nyini. Ligono lya pili, alotili Derbe ni Barnaba. ");
INSERT INTO kiz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baada jha kumanyisya injili mu mjibhola ni kubhabhomba bhanafunzi bhamehele bhakerebhuiki Listra, hadi Ikoniamu, ni hadi Antiookia. ");
INSERT INTO kiz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bhajhendelili kuiman'sya nafsi sya bhanafunzi ni kupelibhwa muoyo kujhendelela mu imani, akajoobha, “Lazima tujhingilayi ku ufalme bhwa K'yara kwa kupetela malombosi ghamehele. ");
INSERT INTO kiz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bho bhabha teuili kwa ndabha jha bhene bhaseya kwa kila likusanyiku lya bhaaminio na bhakajha bhas'okili ni kufunga, bhabhakabidhi kwa Bwana, ambajhe bhene bhamwaminili. ");
INSERT INTO kiz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kisha bhapelili kupisidia, bhafikili pamfilia. ");
INSERT INTO kiz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bhwakati bhalongili malobhi perga, bhaselili kulota Atalia. ");
INSERT INTO kiz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuhoma okhu bhakweli meli hadi Antiokia ambako bhajhele bhakihomisi kwa neema jha K'yara kwa ndabha jha mbombo ambayo henu bhajhele bhaikamilisi. ");
INSERT INTO kiz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bhobhafikili okhu Antiokia, ni kulibhonganiya, likusanyiku lya pamonga, bhakapisya taarifa jha mambo ambagho K'yara agha bhombi kwa bhene, ni jinsi kya abhadendeilili ndiangu ghwa imani kwa bhanu bha mataifa. ");
INSERT INTO kiz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhatamili kwa muda mrefu ni bhanafunzi ");
INSERT INTO kiz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bhanu fulani bhaselili kuhoma Uyahudi ni kubhamanyesya bhalongo, bhakajonha, “Mkabela kutahiribhwa kama desturi jha Musa, mwibhwesya lepi kuolibhwa.” ");
INSERT INTO kiz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bwakati Paulo ni Barnaba bhobhajhele na mapambano ni mjadala pamonga na bhalongo bhaamuili kujha Paulo, Barnaba ni bhangi kadhaa bhalotayi Yerusalemu kwa mitume ni bhaseya kwandabha jhe liswali e'le. ");
INSERT INTO kiz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Henu kwa kulaghisibhwa kwa bhene, ni kanisa bhapetili Foinike ni Samaria bhakajha bhitangasyali furaha mbaha kwa bhalongobha bhoha. ");
INSERT INTO kiz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bho bhahidili Yerusalemu, bhakaribisibhu ni kanisa ni mitume ni bhaseya, na bhawasilishi taarifa jha mambo ghoha ambagho K'yara abhombili pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini bhanu fulani bhabhaamini bhajhele mu likundi lya Mafarisayo bhajhemili ni kujobha, “ni muhimu kubhatahiri ni kubhaamuru bhayikamulayi sheria jha Musa,” ");
INSERT INTO kiz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hivyo mitume nibhaseya bhajhemi pamonga kulifikirila liswala e'le. ");
INSERT INTO kiz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Baada jha majadiliano matali Petro ajhenuli ni kujobha kwa bhene, “Bhalongo mumanyili kujha kitambo kinofu kyakilotili K'yara abhombili lichaguo jha muenga, kujha kwa ndomo ghwangu mataifa bhapelekayi lilobhi lya injili, ni kuamini. ");
INSERT INTO kiz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","K'yara jha aghimanyili mioyo, ishuhudila kwa bhene, akabhapela Roho mtakatifu, kama kyaabhombili kwa tete; ");
INSERT INTO kiz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","na atengenisilepi utofauti kati jha tete ni bhene, akajhibhomba mioyo jhya bhene minofu kwa imani. ");
INSERT INTO kiz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kwa hiyo, kwanajhakiki mukan'jaribu K'yara kujha mubhekayi nira panani pa nsingu sya bhanafunzi ambabho hata bhadadi jhitu wala tete twibhwesyalepi kustahimili? ");
INSERT INTO kiz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lakini twikiera kujha twibetakuokolibhwa kwa neema jha Bwana Yesu, kama kyabhajhele.” ");
INSERT INTO kiz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kusanyiku lyoha lyagudeme bho bhakampelekesya Barnaba ni Paulo bho bhihomesya taarifa jha ishara ni maajabu ambagho K'yara abhombi pamonga nabhu kati jha bhanu bha mataifa. ");
INSERT INTO kiz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bho bhalekili kulongela, Yakobo ajibili akajobha, “Bhalongo munipelekesiajhi. ");
INSERT INTO kiz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ajhelekisi hoti jinsi hoti K'yara kwa neema abhasaidili mataifa ili kwamba akikabhilayi kuhoma kwa bhene bhanu kwandabha jha lihina lya bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Malobhi gha manabii ghikakubaliana ni e'le kama kya lilembibhu. ");
INSERT INTO kiz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Baada jha mambo agha nibetakukerebhuka ni kujenga kabhele hema jha Daudi, jhahaguili pasi; nibetakuhinula ni kubhumala uharibufu bhwake, ");
INSERT INTO kiz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ili kwamba bhanu bhabhasiele bhandondayi Bwana, pamonga ni bhanu bha mataifa bhabhakutibhu kwa lihina lya nene; ");
INSERT INTO kiz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Efe ndo, kyaajobhili Bwana jhaabhombi mambo agha ghamanyikanayi kuhomela enzi sya muandi. ");
INSERT INTO kiz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Efyo basi, ushauri bhwa nene ni kwamba tusibhapeli shida bhanu bha mataifa bhabhakan'geukila K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lakini tujhandikayi kwa bhene kujha bhakijhepusiajhi patali ni uharibifu bhwa sanamu, tamaa sya uasherati, ni fyafiniongibhu, ni damu. ");
INSERT INTO kiz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kuhoma fizazi fya bhasee kuna bhanu ku kila mji bhabhihubiri ni kun'soma Musa mu masinagogi khila sabato.” ");
INSERT INTO kiz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kwa hiyo jhibhonekana kujha jhibhapendesi mitume ni bhaseya, pamonga ni likanisa lyaoha, ku'chagula Yuda ghaakutibhu Barnaba ni Silas bhabhajhele bhalongosi bha kanisa, nikubhalaghisya Antiokia pamonga ni Paulo ni Barnaba. ");
INSERT INTO kiz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bhalembi naha, “Mitume bhasee ni bhalongo bhangu kwa bhalongo bha mataifa bhabhajhele Antiokia, Shamu ni Kilikia, salamu. ");
INSERT INTO kiz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Twapelili kujha bhanu fulani ambho twabhapelili lepi amri ejhu, bhabhokili kwa tete na bhabhataabisi kwa mafundisu ghaghileta shida mu nafsi sya muenga. ");
INSERT INTO kiz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwa hiyo, jhibhonekana kinofu kwa tete twebhoha kuchagula bhanu bha kubhalaghisya kwa muenga pamonga ni bhapendwa bhitu Barnaba, ni Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bhanu bhabhahatarisi maisha gha bhene kwa ndabha jha lihina lya Bwana Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Henu, tundaghisi Yuda ni Sila, bhibeta kubhajobhela mambo ghaghuaghu. ");
INSERT INTO kiz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kwa kujha jhabhoniki kinofu kwa Roho mtakatifu ni kwa tete, kubho juu jha muenga nsighu mbaha kuliko mambo agha ghaghajhele gha lazima. ");
INSERT INTO kiz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kwamba mgeukayi kuhomela kufenu fya fipisibhu kwa sanamu, damu, fenu fya kunyongibhwa, ni uasherati. kama mwibetakwibheka patali ni efe jhibetakujha kinofu kwa muenga. kwaherini.” ");
INSERT INTO kiz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Efyo basi, bhobhatawanyisi bhu bhaselelili Antiokia; baada jha kubhonganiya kusanyiku pamonga, bhawasilishi barua. ");
INSERT INTO kiz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bho bhajhisomili bhahobhwiki kwandabha jha kupelibhwa muoyo. ");
INSERT INTO kiz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda ni Sila ni manabii, bhabhapelili muoyo bhalongo kwa malobhi ghamehele ni kubhasopela ngofu. ");
INSERT INTO kiz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baada jha kutama muda fulani okhu, bhatawanyisibhu kwa amani kuhoma kwa bhalongo kwa bhala bhabhalaghisi. ");
INSERT INTO kiz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Lakini jhabhonekene kinofu lepi kusiala okhu). ");
INSERT INTO kiz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Lakini Paulo ni bhangi bhatamili Antiokia pamonga ni bhangi bhamehele, ambapo bhanafundisi ni kuhubiri lilobhi lya Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Baada jha magono kadhaa Paulo ajobhili kwa Barnaba, “Natukerebhukayi henu ni kubhagendela bhalongo mu khila mji pa twahubiri lilobhi lya Bwana, ni kubhabhona kyabhajhele. ");
INSERT INTO kiz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba alondeghe kabhele kun'tola pamonga nabhu Yohana jhaakutibhu Marko. ");
INSERT INTO kiz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lakini Paulo afikiriri jhajhekinofu lepi kun'tola Marko, jhaabhalekili okhu pamfilia na ajhendeli lepi nabhu mu mbombo. ");
INSERT INTO kiz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kisha apu kwahomili mabishano mabhaha kwa hiyo bhatengene, ni Barnaba an'tolili Marko ni kusafiri kwa meli mpaka Kipro. ");
INSERT INTO kiz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lakini Paulo an'chaguili Sila ni kubhoka, baada jha kukabisibhwa ni bhalongomunu mu neema jha Bwana. ");
INSERT INTO kiz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naalotili kupelela Shamu ni Kilikia, ikajha akaghasindimalisya makanisa. ");
INSERT INTO kiz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo kabhele bho ahidili Derbe ni Litra; na langayi, pala pajhe ni mwanafunzi jhaakutibhweghe Timotheo, ndo kijana jhaahogoliki ni mabhu ghwa Kiyahudi ambajhe ndo muumini ni dadi munu ndo mgiriki. ");
INSERT INTO kiz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bhanu bha listra ni Ikonia bhan'shuhudili kinofu. ");
INSERT INTO kiz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo andondeghe ili asafiriajhi nakhu, hiyo akantola ni kun'tahiri kwa ndabha jhe bhammanyili kujha dadimuni ndo Mgiriki. ");
INSERT INTO kiz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bho bhilota bhap'elili ku miji nikuhomesya malaghisu ku makanisa ili kughatii malaghisu aghu ghalembibhu ni mitume ni bhasee okhu Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Efyo makanisa ghaimarishibhu mu imani ni bhabhaamini bhajhongesiki kwa idadi khila ligono. ");
INSERT INTO kiz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo ni bhajhinu bha kalota firigia ni Galatia kwani Roho ghwa K'yara abhabesili kuhubiri lilobhi okhu ku lijimbo lya Asia. ");
INSERT INTO kiz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bho bhakaribili Misia, bhajaribu kulota Bithinia, lakini Roho ghwa Yesu abhabesili. ");
INSERT INTO kiz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kwa hiyo bhakapeta Misi bhakajhida mpaka mji bhwa Troa. ");
INSERT INTO kiz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Maono ghan'tokili Paulo pakilu, bhajheleni munu ghwa Makedonia ajhemili, akan'kuta ni kujobha, “Muhidayi mutulaidilayi choni Makedonia.” ");
INSERT INTO kiz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo bho abhwene maono, mara tukakia ndala kulota Makedonia akimanya kujhe K'yara atukutili kulota kubhahubilila injili. ");
INSERT INTO kiz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hivyo twabhokili kuhoma Troa twalotili moja kwa moja Samothrake, ni ligono lyalafwatili twafikili mji bhwa Neapoli. ");
INSERT INTO kiz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuhoma apu tukalota Filipi ambaghyo ndo moja ghya mji bhwa Makedonia, mji muhimu mu wilaya ni utawala bhwa Kirumi ni kutama magono kadhaa. ");
INSERT INTO kiz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ligono lya sabato twalotili kwibhala kulango kwa njela jha kiholo sehemu ambajho tudhanieghe kubeta kujha ni mahali pa kubhombela maombi. Twatamili pasi ni kulongela ni bhamama bhabhahidi pamonga. ");
INSERT INTO kiz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","N'dala mmonga he akutibhweghe Lidia, n'hemelesajhi ghwa zambarau, kuhoma ku mji bhwa Tiatira, jha ikamwabudu K'yara atupelikisi. Bwana anfunguili muoyo bhwa muene ni kubheka maanani malobhi ghaghajobhibhu ni Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Baada jha kubatisibhwa, atusiili ni kujobha, “Kama munibhwene kujha nene na mwaminifu kwa Bwana, basi nikabhasihi mujhingilayi ni kutama kwa nene.”Atusihili kweli. ");
INSERT INTO kiz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ikajha kwamba, bhotwilota mahali pa kus'oka, n'dala mmonga jheajhe ni pepo lya utambuzi abhone ne ni tete. Andetili Bwana ghwa muene faida simehele kwa kubashiri. ");
INSERT INTO kiz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","N'dala ojho akan'kesya Paulo pamonga ni tete, akajha ipiga kelele ni kujobha, “Abha bhagosi ndo bhatumishi bha K'yara jha ajhe mbaha, bhabhikabhatangasila muenga habari jha wokovu.” ");
INSERT INTO kiz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Abhombi naha kwa magono ghamehele, lakini Paulo akajha adadili ni litendo e'lu, ageuki kunyuma ni kun'jobhela pepo'”Nikuamuru kwa lihina lya Yesu umhokayi mugati mwa muene.” Niliene likabhoka ni kundeka mara moja. ");
INSERT INTO kiz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mabwana bha muene bho bhabhuene jha kujha tumaini lya faida jha bhene libhokili, bhabhakamuili Paulo ni Sila ni kubhabunisya mu soko mbele jha bhenye mamlaka. ");
INSERT INTO kiz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bho bhabhafikisi kwa makuhakimu bhakajobha, “Bhagosi abha Bhayahudi na bhisababisya ghasia mbaha mu mji bhwitu. ");
INSERT INTO kiz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhimanyisya mambo ambagho sio sheria tete kughapokela wala kughakesya kama Warumi.” ");
INSERT INTO kiz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Umati ukabhajhinukila kinyume, Paulo ni Sila, mahakimu bharanuli nghobho sya bhene ni kubhafula ni kuamuru bhatobhibhwayi fiboko. ");
INSERT INTO kiz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Baada jha kubhatobha fiboko fimehele, bhakabhasopa mu ligereza ni kuamuru askari bha gereza kubhalenda kinofu. ");
INSERT INTO kiz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Baada jha kupokela amri ejhu, askari bha gereza abhasopili mu kichumba kya mugati mu gereza ni kubhakonga magolo gha bhene pa sehemu pa bhabhekibhu. ");
INSERT INTO kiz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bwakati wa kiru kya manane Paulo ni Sila bhakajha bhisoka ni kujhemba nyembu sya kunsifu K'yara, khoni bhafungwa bhangi bhakajha bhipelekesya. ");
INSERT INTO kiz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ghafla kwatokili litetemeko libhaha ni misingi ghya gereza ghyatikisiki, miliangu ghya gereza ghikadenduka, ni minyororo ghya bhafungwa bhoha jhalegesibhu. ");
INSERT INTO kiz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mlinzi ghwa gereza akajhumuka kuhoma mulogono ni kubhona miliangu ghioha ghya gereza jhidendulibhu; hivyo akatola upanga bhwa muene maana alondeghe kwikoma kwandabha afikilireghe bhafungwa bhoha bhatoniiki. ");
INSERT INTO kiz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini Paulo akapiga kelele kwa sauti mbaha, akajobha, “Usikidhuru kwa ndabha twebhoha tujhele mahali apa. ");
INSERT INTO kiz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mlinzi ghwa gereza akas'oka taa siletibhwayi ni kujhingila mugati mu gereza manyata, akajha itetemeka ni kutila akabhabinila Paulo ni Sila, ");
INSERT INTO kiz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ni kubhapisya nje jha gereza ni kujobha, “Bhaheshimibhwa, niketakiki ili nibhweijhi kuokoka? ");
INSERT INTO kiz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na bhene bhakan'jobhela, “Umwamini ajhi Bwana Yesu nabhi wibetekuokoka pamonga ni nyumba jha jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bhajobhi lilobhi lya Bwana kwa muene pamonga ni bhanu bhoha bha pa nyumba jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mlinzi ghwa gereza akabhatola ke'ru khela ni kubhasambisya sehemu sya bhalamele, muene pamonga ni bhanu bha panyumba pa muene. Mara bhakabatisibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Akabhaleta Paulo ni Sila kunyumba jha muene ni kubhatengela kyakulya. Ni muene ajhele ni furaha mbaha pamonga ni bhanu bha panyumba jha muene kwandabha bhamwamini K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bho jhilikili pamusi, mahakimu bhatumili ujumbe kwa mlinzi jhola ghwa gereza bhakajobha, “Bharuhusu ajhi bhanu bhala bhalotayi.” ");
INSERT INTO kiz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mlinzi ghwa gereza akan'julisha Paulo juu jha malobhi aghu jha kujha, “Mahakimu bhaghisi ujumbe kujha nibharuhusuajhi mulotayi: hivyo mupitayi kwibhala na mulotayi kwa amani. ");
INSERT INTO kiz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lakini Paulo akabhajobhela, “Bhatutobhili hadharani, bhanu ambabho ndo Bharumi bila kutuhukumu na bhaamuili kutusopa mu ligereza; halafu henu bhilonda kutupisya kwa siri? Lepi jhibhwesekana lepi, bhene bhahidayi kutupisya mahali apa.” ");
INSERT INTO kiz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bhalinzi bhakabhajulisya mahakimu juu jha malobhi aghu, mahakimu bhatilili sana bhobhamanyili kujha Paulo ni Sila ndo Bharumi. ");
INSERT INTO kiz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mahakimu bhakahida ni kubhasihi bhapitayi, na bhobhabhapisili kwibhala pa gereza, bhabhesokili Paulo ni Sila bhakapita kwibhala kubhoka mu mji obhu. ");
INSERT INTO kiz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kwa hiyo Paulo ni Sila bhakapita kwibhala pa gereza bhakahida kunyumba jha Lidia. Paulo ni Sila bho bha mbwene ndogo bhabhi bhabhapelimu muoyo ni kisha kubhoka mu mji obhu. ");
INSERT INTO kiz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na bho bhapetili mu miji ghya Amfipoli ni Apolonia, bhahidili mpaka mji ghwa Thesalonike ambabho kwa jhele ni sinagogi lya bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kama kya jhijhele kawaida jha Paulo akalota kwa bhene, na kwa muda ghwa magono madatu gha sabato ajadiliene nabhu juu jha maandiku. ");
INSERT INTO kiz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ajhele akabhafungulila maandiku ni, kubhajhelesya kujha jhilondekeghe Kristu atesekayi ni kisha kufufuka kabhelel kuhoma kwa bhafu. Abhajobhili, “Ojho Yesu jha nikabhajobhela habari sya muene ndo Kristu.” ");
INSERT INTO kiz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Baadhi jhe Bhayahudi bhashawishiki ni kuungana ni Paulo ni Sila pamonga ni Bhagiriki bhachamungu, bhamama bhingi bhaongofu ni likundi libhaha lya bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini baadhi jha Bhayahudi bhabhiamini lepi, bhabhamemi bhwifu, bhalotili kusoko ni kubhatola baadhi jha bhanu bhaovu, bhabhongene umati bhwa bhanu pamonga ni kusababisya ghasia mjini, kisha bhakaivamila nyumna jha jasoni bhakalonda kubhakamula Paulo ni Sila ili kubhaleta palongolo pa bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lakini bho bhabhakofili bhakan'kamula Yasoni ni baadhi jha bhalongomunu bhangi nikubhapeleka mbele jha maofisa bha mji, bhakapiga kelele, “Abha bhagosi bhabhupenduili ulimwengu bhafikili mpaka khoni kabhele. ");
INSERT INTO kiz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Bhagosi abha bhabhakaribisibhu ni Yasoni bhakaiharibu sheria jha kaisari, bhijobha ojhe mfalme jhongi jhaikutibhwa Yesu.” ");
INSERT INTO kiz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Umati ni maofisa bha mji bho bhapeliki mambo agha bhajhingibhu ni bhuogha. ");
INSERT INTO kiz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Baada jha kujha bhamakutola hela jha thamani jha ulinzi kuhoma kwa Yasoni ni bhangi bhabhalikisi bhalotayi. ");
INSERT INTO kiz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kiru khela bhalongobhe bhandaghisi Paulo ni Sila Beroya. Na bhobhafikiri khola bhalotili mu sinagogi lya Bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bhanu bhalabha jhele bhenye werevu mbhaha kulikobhala bhanu bha Thesalonike, kwandabha bhajhele ni utayari bhwa kulipokela lilobhi kwa akili sya bhene, ni kuchungusya maandiku khila ligono ili kulola kama malobhi agha ghabhajobhibhu ndo kyaghajhele. ");
INSERT INTO kiz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kwa ejho bhingi bha bhene bhakyeriri bhakiweno bhadala bhenye ushawishi mbaha ghwa Bhagiriki ni bhagosi bhingi. ");
INSERT INTO kiz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini Bhayahudi bha Thesalonike bho bhagunduili kwamba Paulo itangasya lilobhi lya k'yara okhu Beroya, bhalotili okhu ni kuchochela ni kisha kubhwandisya ghasia kwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Manyata, bhalongomunu bhakampeleka Paulo ku njela jha nyanja, lakini Sila ni Timotheo bhasiele pala. ");
INSERT INTO kiz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhala bhalongo bhabhampeliki Paulo bhalotili naku hadi Athene, bhandekili Paulo okhu, bhapokili malaghisu kuhoma kwa muene kujha, Sila ni Timotheo bhahidayi kwa muene kwa haraka kyajhibhwesekana. ");
INSERT INTO kiz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","thene, roho jha muene jhadadisibhu mugati mwa muene kwa jinsi kya abhubhwene mji kya abhumemili sanamu simehele. ");
INSERT INTO kiz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Efyo akajadiliana mu sinagogi ni Bhayahudi bhala bhabhamehi K'yara ni kwa bhala bhoha bhaabhonene nabhu kila ligono mu soko. ");
INSERT INTO kiz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Lakini baadhi jha bhanafalisafa bha Bhaepikureo ni Bhastoiko bhakan'kabili. Ni bhangi bhakajobha, “Kiki kyaaka kijobha munu ojho n'jobhajhi n'dele? Bhangi bhakajobha, “Jhibhonekana ihubiri habari jha K'yara n'hesya” kwandabha ihubiri habari jha Yesu ni ufufuo. ");
INSERT INTO kiz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bhakan'tola Paulo ni kundeta Areopago, bhakajobha, Twibhwesya kumanya agha mafundisu mapya gha wilongela? ");
INSERT INTO kiz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kwa ndabha wileta mambo mahesiya mu mbol'ok'oto sya tete. Henu, twilonda kumanya mambo agha ghana maana gani?” ");
INSERT INTO kiz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ni bhanu bhoha bha Athene pamonga ni bhahesya bha bhajhele nabhu, bhitumila muda bhwa bhene aidha kwa kulongela ni kup'elekesya juu jha lijambo lipya.) ");
INSERT INTO kiz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Henu, paulo akajhema pagati pa bhanu bha Areopago ni kujobha, “Enyi bhanu bha Athene nibhuene kujha muenga ndo bhanu bha dini kwa kila namna, ");
INSERT INTO kiz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwani kwa kupetela kwa nene ni kulola fenu fya muenga fya kuabud, nighabhuene malobhi gha ghalembibhu mu madhabahu ghinu, ghijobha, “KWA K'YARA JHA AMANYIKENE LEPI.” Efyo basi ojhu jha mukamwabudu pasipokumanya ndo jhanikabhajulisha muenga. ");
INSERT INTO kiz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","K'yara jhaabhombili bhulimwengu ni kila khenu kya kijhele mugati kwakujha ndo Bwana ghwa mbingu ni nchi ibhwesya lepi kutama mu mahekalu gha ghatengenesibhu ni mabhoko. ");
INSERT INTO kiz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na itumikibhwa lepi ni mabhoko gha bhanadamu kana kwamba ilonda khenu kwa bhene kwani, muene akabhapela bhanu uzima ni pumzi ni fenu fengi fyoha. ");
INSERT INTO kiz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kup'etela munu mmonga, aghabhombi mataifa ghoha gha bhanu bhabhitama panani pa uso bhwa dunia ni kubhabhekela nyakati ni mipaka mu maeneo gha bhatama. ");
INSERT INTO kiz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Henu, bhilondeka kundonda K'yara, ni yamkini bhamfikilayi ni kun'kabha, ni kwa bhuhakika ajhelepi patali ni khila mmonga bhitu. ");
INSERT INTO kiz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kwa muene twitama twigenda ni kujha ni uzima bhwitu, kama vile mtunzi ghwa jhomu mmonga ghwa shairi bho ajobhili twebhazawa bha muene. ");
INSERT INTO kiz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Henu ikajhelayi tete twebhazaiwa bha K'yara, twilondeka lepi kufikiri kujha uungu ni kama dhahabu, au shaba, au maganga, sanamu jhajhichongibhu kwa ustadi ni mawazo gha bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Henu, K'yara agudeme nyakati sela sya bhujinga, lakini henu iamuru bhanu bhoha kila mahali bhabhwesya kutubu. ");
INSERT INTO kiz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ejhe kwa ndabha abhekili ligono lya ilonda kujhihukumu dunia kwa haki kwa munu jhaan'chaguili. K'yara apisisi bhuhakika bhwa munu ojho kwa khila munu pala paamfufuili kuhoma kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ni bhanu bha Athene bho bhap'eliki habari jha kufufulibhwa kwa bhafu, baadhi jha bhene bhan'dhihakili Paulo ila bhangi bhakajobha, Tukuup'elekesya kabhele kwa habari jha lijambo e'le.” ");
INSERT INTO kiz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Baada jha apu, Paulo akabhaleka. ");
INSERT INTO kiz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini baadhi jha bhanu bhaungeneni muene bhakakiera, akajha ni Dionisio Mwareopago, ni N'dala jhaikutibhwa Dmari ni bhangi pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Baada jha mambo agha, Paulo akabhoka Athene kulota Korintho. ");
INSERT INTO kiz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Okhu akankabha myahudi jhaakutibhweghe Akwila munu ghwa kabila lya Ponto, muene ni n'dala munu jhaakutibhweghe Prisila bhahidili kuhoma okhu Italia, kwandabha Klaudia aamuiri bhayahudi bhoha bhabhokayi Roma; Paulo akahida kwa bhene; ");
INSERT INTO kiz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo aishili ni kubhomba mbombo nabhu kwani muene ibhomba mbombo jhajhiwaningana nijha bhene. Bhene bhajhele bhatengenesya mahema. ");
INSERT INTO kiz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo ajadiliene nabhu mu sinagogi kila ligono lya sabato. Abhashawishili bhayahudi pamonga ni Bhagiriki. ");
INSERT INTO kiz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lakini Sila ni Timotheo bhobhahidili kuhoma Makedonia, Paulo asukumibhu ni Roho kubhashuhudila bhayahudi kujha Yesu ndo Kristu. ");
INSERT INTO kiz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wakati bhayahudi bham'belili ni kumdhihakili, hivyo Paulo akung'uindi liguanda lya muene mbele jha bhene, ni kubhajobhela, “Damu jha jhomu na jhijhelayi panani pa mitu gha jhomu mwebhene; Nene nijhelepi ni hatia. Kuhomela henu ni kujhendelela, nikabhalotela mataifa.” ");
INSERT INTO kiz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Efyo akabhoka kuhoma pala akalola kunyumba jha TitoYusto, munu jheakamwabudu K'yara. Nyumba jha muene jhihele karibu ni sinagogi. ");
INSERT INTO kiz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kripo, ndongo si ghwa sinagogi pamonga ni bhanu bha panyumba jha muene bhamwamini Bwana. Bhanu bhingi Bhakorintho bho bhampeliki Paulo ilongela bhakyeriri ni kubatifibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bwana akan'jobhela Paulo pakilu kwa njela jha maono, “Usitil, lakini longelayi na usigudami. ");
INSERT INTO kiz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kwani nene nijhe pamonga nabbi, naajhelepi jhaibetakukudhuru, maana nijhe ni bhanu bhingi katika mjiabho.” ");
INSERT INTO kiz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulo atamili okhu kwa muda bhwa mwaka umonga ni miesi sita akajhaimanyisya lilobhi lya K'yara miongoni mwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakini Gali bho abhombibhu mtawala bhwa Akaya, Bhayahudi bhakayema pamonga kinyume ni Paulo ni kumpeleka mbele jha kiti kya hukumu, ");
INSERT INTO kiz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bhakajobha, “Munu ojho akabhashawishi bhanu kumwabudu K'yara kinyume kya sheria” ");
INSERT INTO kiz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bhwakati Paulo alondghe kujobha, gailo akabhajobhela Bhayahudi, Muenga Bhayahudi, kama ngalijhe likosa au bhuhalifu, ngajhijhe halali kubhashughulikila. ");
INSERT INTO kiz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini kwandabha ndo maswali ghaghihusu malobhi ni mahina ni sheria sya muenga basi muhukumulayi mwe bhene. Nene ninoghelalepi kujha hakimu kwa habari jha mambo aghu.” ");
INSERT INTO kiz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galio akabhaamuru bhabhokayi mbele jha kiti kya hukumu, ");
INSERT INTO kiz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Efyo, bhakan'kamula Sosthene ndongosighwa sinagogi, bhakantobha mbele jha kiti kya hukumu. Lakini Galio ajalilepi kya bhabhombili. ");
INSERT INTO kiz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo baada jha kutama pala kwa muda mrefu, akabhaleka ndugu ni kulota kwa meli Siria pamonga ni Prisila ni Akwila. Kabla jha kubhoka pa bandari, akaili njuili sya muene kwani ajhele alapili kujha mnadhiri. ");
INSERT INTO kiz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bhebhafikili Efeso, Paulo akandeka Prisila ni Akwila pala lakini muene akajhingila mu sinagogi ni kujadili ni Bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bhobhan'jobhili Paulo atama nabhu kwa muda mrefu muene abelili. ");
INSERT INTO kiz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lakini akabhoka kwa bhene akabhajobhela, “Nibetakukerebhuka kabhele kwa jhomu, ikajhiajhi ndo mapenzi gha K'yara. Baada jhe hapu, akabhoka kwa meli kuhoma Efeso. ");
INSERT INTO kiz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulo bho atolili Kaisaria, akakuela kulota kujhemelela kanisa lya Antikia. ");
INSERT INTO kiz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Baada jha lutama kwa muda mrefu pala, Paulo akabhoka kupetela maeneo gha Galataia ni Frigia ni kubhapela muoyo bhanafunzi bhoha. ");
INSERT INTO kiz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myahudi mmonga jhaakutibhweghe Apolo, jhaahogoliki okhu Alexandria, ahidi Efeso. Ajhele ni ufasaha katika kulongela ni hodari ghwa majhandiku. ");
INSERT INTO kiz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolo ajheajhelekesibhu kumafundisu gha Bwana. Kwa jinsi kyaajhe ni bidiii ku roho, alongili ni kumanyisya kwa usahihi, mamabo ghaaghakan'husu Yesu, ila amanyi tu ubatizo bhwa Yohana. ");
INSERT INTO kiz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo akajhanda kulongela kwa ujasiri mu mahekalu. Lakini Prisila ni Akwila bhobhapeliki bhabheki urafiki ni muene ni kunjelekesya juu jha njela sya K'yara kwa usahihi. ");
INSERT INTO kiz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Bho anoghila kubhoka kulota Akaya, bhalongomunu bhakampela muoyo nikubhalembela barua bhanafunzi bhabhajhe Akaya ili bhakabhayi kumpokela. Bhoafikilili kwa neema abhasaidili sana bhala bhabhakyeriri. ");
INSERT INTO kiz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwa ngofu sya muene ni maarifa Apolo abhazidili Bhayahudi hadharani akajhailasya kupetela majhandiku gha kujha Yesu ndo Kristu. ");
INSERT INTO kiz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ikajha kujha Apolo bho ajhe Korintho, Paulo apetili nyanda sya panani ni kufika mu mji bhwa Efeso, na akolili bhanafunzi kadhaa okhu. ");
INSERT INTO kiz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulo akabhajobhela, “Je mwapokili Roho mtakatifu bho mukyeriri?” Bhakan'jobhela, “Lepi, twabhwesilepi hata kup'eleka kuhusu Roho mtakatifu.” ");
INSERT INTO kiz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo akajobha, “henu muenga mwabatisibhu bhuli? Bhakajobha, Mu bhubatisu bhwa Yohana. ");
INSERT INTO kiz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Basi paulo akajibu, “Yohana abatisi kwa bhubatisu bhwa toba. Akabhajobhela bhanu bhala kujha bhilondeka kunkiera jhola ambajhe ngaahidili baada jha muene, yaani, Yesu.” ");
INSERT INTO kiz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bhanu bho bhap'eliki habari ejhe, bhakabatisibhwa kwa lihina lya Bwana Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na jhikajhe Paulo bho abhekili mabhoko panani pa bhene, Roho mtakatifu akahida juu jha bhene ni kujhanda kunene kwa lugha ni kutabiri. ");
INSERT INTO kiz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jumla jha bhene bhajhele bhaghosi jhapata kumi ni bhabhele. ");
INSERT INTO kiz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo akalota kusinagogi akanena kwa bhujasiri kwa muda bhwa miesi midatu. Akajha ilongosya majadiliano ni kubhafuta bhanu kuhusu mambo ghaghihusu ufalme bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini Bhayahudi bhangi bhajhele bhakaidi na bhabhi belakutii, bhakajhanda kujobha mabhibhi kuhusu njela jha Kristu mbele jha bhumati. Basi Paulo akalekana nabhu ni kubhatenga bhabhikiera patali nabhu. Nu muene akajhanda kulongela kila ligono mu ukumbi bhwa Tirano. ");
INSERT INTO kiz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ejhe jhayendelili kwa miaka mibhele, kwa hiyo bhoha bhakajha bhiishi ku Asia bhap'eliki lilobhi lya Bwana, bhoha Bhayahudi ni Bhayunani. ");
INSERT INTO kiz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","K'yara akajha ibhomba mambo mabaha kumabhoko gha Paulo, ");
INSERT INTO kiz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kwamba hata bhatamu bhaponyisibhu, ni roho bhabhibhi bhahomili wkati bho bhatolili leso ni ngobho sya sihomili mu mbele bhwa Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lakini bhayele Bhayahudi bhapunga pepo bhakajha bhisafiri kupetela lieneo elu, bhakajha bhalalitumila lihina lya Ysu kwandabha jha matumizi gha bhene. Bhakajobhele bhala bhabhajheni pepo bhachafu: Bhakajobha, “Nikabhaarumuru mubhokayi kwa lihina lya Yesu ambaye Paulo akamhubiri.” ");
INSERT INTO kiz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhabhakabhobi agha bhajhele bhana saba bha kuhani mbaha bhwa Kiyahudi, Sekewa. ");
INSERT INTO kiz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Roho bhachafu bhakabhajibu, “Yesu ni mmanyili, ni Paulo ni mmanyili, lakini muene bha niani?” ");
INSERT INTO kiz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Roho nchafu jhola mugati mwa munu akabhanukila bhapunga pepo ni kubhatola nghofu ni kubhatosha. Ndipo bhakajumba kuhoma mu nyumba jhela bhakajha ngoli ni kujeruhibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Lijambo ele lyamanyikene kwa bhoha, Bhayahudi ni Bhayunani, ambabho bhatamili okhu Efeso. Bhakajha ni hofu sana ni lihina lya Bwana lyazidili kuheshimibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kabhele, bhingi bha bhaumini bhahidili ni kuungama na bhadhihirishi matendo mabhibhi bhaghabhombili. ");
INSERT INTO kiz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bhingi bhabhombeghe uganga bhabhongeniye fitabu fya bhene, bhekafinyanya mbele jha kila munu. Bwakati bhene bhibhalanga thamani jha fenu efu, jhajhele fipandi hamsini elfu fya hela. ");
INSERT INTO kiz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Efyo lilobhi lya Bwana lyajhenili kwa upana sana kwa ngofu. ");
INSERT INTO kiz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jha Paulo kukamilisya huduma jha muene khola Efeso, Roho akandongosya kulota Yerusalemu kupetela Makedonia ni Akaya; Akajobha, “Baada jha kujha okhu, jhilondeka kulota Rumi kabhele.” ");
INSERT INTO kiz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulo akabhalaghisya Makedonia bhanafunzi bha muene bhabhele, Timotheo ni Erasto, ambabho bhajhele bhan'saidili. Lakini muene asiele Asia kwa muda. ");
INSERT INTO kiz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wakati obhu kwatokili ghasia mbaha okhu Efeso kuhusu njela jhela. ");
INSERT INTO kiz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sonara mmonga lihina lya muene Demetrio, ambajhe atengenisi fisanamu fya hela fya K'yara Diana, aletili biashara mbaha kwa mafundi. ");
INSERT INTO kiz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Efyo akabhabhonganiya mafundi bha mbombo ejhu ni kujobha, “Bhaheshimibhwa, mmanyili kujha mu biashara ejhe tete twijhingisya hela simehele. ");
INSERT INTO kiz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mwilola ni kupeleka kujha, si apa tu Efeso, bali karibia Asia jhioha, Paulo ojho abhashawishi ni kubhageusya bhanu bhingi. Ijobha kujha ijhelepi miungu ambayo jhibhombiki kwa mabhoko. ");
INSERT INTO kiz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na sio tu jhijhele hatari kujha biashara jha tete jhibetakujha jhilondeka lepi, lakini kabhele ni hekalu lya K'yara n'dala jha ajhe mbaha Diana ibhwesya kutolibhwa kujha ajhelepi ni maana. Kabhele ngaabhwesili hata kujhasya ubhaha bhwa muene, muene ambajhe Asia ni dunia bhakamwabudu.” ");
INSERT INTO kiz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bho bhapeliki agha, bhamemibhu ni ligoga ni kujhuegha, bhakajobha, “Diana ghwa bhaefeso ndo mbaha.” ");
INSERT INTO kiz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mji bhuoha bhwameli ligoga, ni bhanu bhakajumba pamonga mugati mu ukumbi bhwa michezo. Bhakabhakamila bhasafiri bhajhinu ni Paulo, Gayo ni Aristariko, bhabhahomili Makedonia. ");
INSERT INTO kiz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo alondeghe kujhingila mu umati bhwa bhanu, lakini bhanafunzi bhakambesya. ");
INSERT INTO kiz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kabhele, baadhi jha maafisa bha mkoa ghwa Asia ambabho bhajhele marafiki bha muene bhakandetela ujumbe kwa nghofo kunsoka asijhingili mu ukumbi bhwa michezo. ");
INSERT INTO kiz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Baadhi jha bhanu bhakajha bhijobha khenu ekhe ni bhangi lijambo lela, kwa ndabha umati bhwa bhanu bhwachanganyikibhu bhingi bhabhwesilepi hata kumanya kwandayakiki bhahidi pamonga. ");
INSERT INTO kiz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bhayahudi bhakandeta Iskanda kwibhala jha umati bhwa bhanu ni kumbeka panani mbele jha bhanu. Iskanda akapisya ishara kwa kibhoko kya muene kupisya majhelesu kwa bhanu. ");
INSERT INTO kiz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini bho bhamanyili kujha muene Myahudi, bhoha bhajhwegili kwa sauti jhimonga kwa muda ghwa masaa mabhele, “Diana ndo mbaha ghwa Bhaefeso.” ");
INSERT INTO kiz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Baada jha karani ghwa mji kubhugudamisya umati, ajobhili, 'Muenga bhagosi bha Efeso, niani jha amanyilepi mji obho bhwa Efeso ndo ntunzaji ghwa hekalu lya Diana mbaha ni picha jhela jhajhaguili kuhomela kumbinguni? ");
INSERT INTO kiz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kulola kujha mambo agha ghibhwesekakalepi, twilondeka kujha ni utulivu na msibhombi kyokyoha kwa haraka. ");
INSERT INTO kiz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kwandabha mubhakutili bhanu abha pa mahakama ambabho bhah'ejilepi bha hekalu wala sio bha kun'kufuru K'yara watete n'dala. ");
INSERT INTO kiz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Henu, kama Demetrio ni mafundi bhabhajhe pamonga nabhu bhajhe ni mashtaka dhidi jha munu jhejhioha, mahakama sijhewazi ni maliwali bhajhele. Na bhaletibhwayi mbele jha shauri. ");
INSERT INTO kiz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lakini kama bhebhe wilonda kyokyoha kuhusu mambo ghangi, ghibeta kushughulikibhwamu kikao halali. ");
INSERT INTO kiz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa kweli tujhele mu hatari jha kutuhumibhwa kuhusu ghasia ligono ele. Ijhelepi sababu jha machafuko agha na kubetakujha ni uwezo bhwa kughajhelesya. ");
INSERT INTO kiz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Baada jha kujobha agha, abhatawenye makutano. ");
INSERT INTO kiz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Baada jha ghasia kumalika, Paulo akabhakuta bhanafunzi ni kubhapela muoyo. Kisha kubhalagha ni kubhoka kulota Makedonia. ");
INSERT INTO kiz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ni muene bho apetili mikoa ejhu na akajha akabhapela muoyo bhaamini, akajhingila Uyunani. ");
INSERT INTO kiz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Baada jha muene kujha pala kwa muda ghwa miesi midatu njama syaundibhu dhidi jha muene ni bhayahudi bho bhapeliki ikaribila kubhoka ku njela jha bahari kulotela Shamu, hivyo jhandondiki kukerebhuka kupetela Makedonia. ");
INSERT INTO kiz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bhaandamene naku hadi Asia bhajhele Sopatro, mwana ghwa Pirho kuhoma Berea; Aristariko ni Sekundo, bhoha kuhoma bhaamini bha Bhathesalonike; Gayo ghwa Derbe; Timotheo; Tikiko ni Trofimo kuhoma Asia. ");
INSERT INTO kiz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Lakini bhanu abha bhamalikulongolela na bhatulendeleghe kula Troa. ");
INSERT INTO kiz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kwa njela jha bahari kuhoma Filipi baada jha magono gha mikate ghyaghisopibhu lepi chachu, ni mu magono mahanu twabhafikili okhu Troa. Twatamili okhu kwa magono saba. ");
INSERT INTO kiz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hata ligono lya kuanza lya juma, bho tubhonganiki pamonga ili kuumetula n'kate, Paulo alongelili ni bhaumini. Akajha apangili kubhoka ligono lya kilabhu lyake, Efyo akajhendelela kulongela hadi kiru kya manane. ");
INSERT INTO kiz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kwajhele ni taa simehele mu kichumba kya panani ambapo twajhele tubhonganiki pamonga. ");
INSERT INTO kiz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mu ridirisha ajhele atamili n'songolo mmonga lihina lya muene Utiko, ambajhe uelemibhu ni lugono. Hata Paulo bho ihutubila kwa muda mrefu, n'songolo ojho, ajhele amalikugona, akabina pasi kuhoma ghorofa jha tatu na aholibhu bho amalikufwa. ");
INSERT INTO kiz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lakini Paulo akaselela pasi akinyosi muene panani pa muene, akan'kumbatila. Kisha akajobha, “Msikati tamaa kwandabha ujhe hai.” ");
INSERT INTO kiz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kisha akakwela kabhele ghorofani na akaumetula n'kate akalya. Baada jha kulongela nabhu kwa muda mrefu hadi lubhuliku, akabhoka. ");
INSERT INTO kiz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bhakandeta n'songolo jhola ajhe muomi bhafarijiki sana. ");
INSERT INTO kiz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twebhene twalongolili palongolo jha Paulo kwa meli ni kulota Aso, ambapo tete tulondeghe kun'tola Paulo okhu. Ekhe ndo muene kyaalondeghe kubhomba, kwandabha apangi kubhomba kulota kupetela pandema. ");
INSERT INTO kiz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bhoatufikili okhu Aso, twampaki mu meli tukalota Mitilene. ");
INSERT INTO kiz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kisha tete tukatweka kuhoma okhu na ligono lya bhubhele twafikili lubhafu lwa bhubhele bhwa kisiwa kya Kio. Ligono lyalyafwatili twafikili kisiwa kya Samo, ni kilabhu jhiake twafikili mji bhwa Mileto. ");
INSERT INTO kiz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kwandabha Paulo aamuili kusafiri kup'etela Efeso, ili kwamba asitumili muda bhwobhwoha mu Asia; kwandabha ajhe ni hangara jha kubhwahi Yerusalemu kwandabha jha sikukuu jha Pentekoste, kama ngajhibhwesekene muene kubhomba naha. ");
INSERT INTO kiz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuhoma Mileto akalaghisya bhanu hadi Efeso ni kubhakuta bhaseya bhakanisa. ");
INSERT INTO kiz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bho bhafikili kwa muene akabhajobhela, muenga mwebhene mmanyili kuhoma ligono lya kuanza bho nikanyi apaAsia, jinsi kyanijhe kwa muenga muda bhuoha. ");
INSERT INTO kiz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nintumikili Bwana kwa unyenyekevu bhoha ni kwa mahosi, ni mateso ghaghanikabhili nene kwa hila sya bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanyilijinsi ambafyo nakizuililepi kutangasya kwa muenga khenu kyokyoha ambakyo kyajhele muhimu, na jinsi nene kyanibhemenyisi waziwazi na kabhele kulota nyumba kwa nyumba. ");
INSERT INTO kiz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mumanyili jinsi nene kyanikajhendelili kubhaonya bhayahudi ni bhayunani juu jha toba kwa K'yara ni imani kwa Bwana bhitu Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na henu, mulangayi, nene, nikantii Roho mtakatifu kulotela Yerusalemu, nisighamanyi mambo ambagho ghibetakunitokela nene okhu, ");
INSERT INTO kiz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ila kwa kujha Roho mtakatifu ikanishuhudila nene mu khila mji na ijobha kujha minyororo ni malombosi ndo fikanilendela. ");
INSERT INTO kiz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini nene nafikiriri lepi kujha maisha ghangu ndo kwa njela jhojhioha jha thamani kwa nene, ili nibhwesiajhi kumala mwendo bhwangu ni huduma jhenipokili kuhoma kwa Bwana Yesu, kushuhudila injili jha neema jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ni henu, langayi, nimanyili kujha bhoha, miongoni mwa bhala bhanitolili kubhahubiri Ufalme, mwibetalepi kunibhona pamihu kabhele. ");
INSERT INTO kiz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwa hiyo nikabhashuhudila lelu ejhe, kujha nijhelepi ni hatia ni damu jha munu jhejhioha jhola. ");
INSERT INTO kiz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwandabha nakizuili lepi kubhatangasila mapenzi ghoha gha K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwa hiyo mujhelayi mwebhaangalifu juu jha jhomu mwibhene, ni juu jha likundi lyoha ambalyo Roho mtakatifu abhabhekili muenga kujha bhaangalizi. Mujhelayi bhaangalifu kulilolela likusanyiku lya Bwana ambalyo alihemili kwa damu jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nimanyili kujha baada jha kubhoka kwa nene mbwa mwitu bhakali bhibheta kujhingila kwa muenga, na bhasilihurumili likundi. ");
INSERT INTO kiz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nimanyili kwamba hata miongoni mwa jhomu mwebhene baadhi jha bhanu bhibeta kuhida ni kujobha mambo manofulepi, ili kubhafuta bhanafunzi bhabhakesiajhi bhene. ");
INSERT INTO kiz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Henu, mujhelayi mihu. Mukhombokayi kujha kwa miaka midatu nalekilepi kubhafundisha kila mmonga bhinu kwa mahosi kiru ni pamusi. ");
INSERT INTO kiz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ni henu nene nikabhakabisi kwa K'yara, ni kwa lilobhi lya neema jha muene, ambalyo libhwesya kubhajenga ni kubhapela urithi pamonga nabhu bhoha bhabhabhekibhu bhakfu kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Natamanilepi hela, dhahabu, au maguanda. ");
INSERT INTO kiz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mmanyili mwebhene kujha mabhoko agha inipelili mahitaji ghangu nejhoni ni mahitaji gha bhala bhabhajhe pamonga nani. ");
INSERT INTO kiz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu mambo agha nabhapelili mfano bhwa jinsi kyajhilondeka kubhasaidila bhanyonge kwa kubhomba mbombo, na jinsi kyamwilondeka kukhomboka malobhi gha Bwana Yesu, malobhi ambagho muene ajobhili: “Heri kupisya kuliko kupokela.” ");
INSERT INTO kiz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Baada jha kujobha namna ejhe, apigili magoti akas'oka pamonga nabhu. ");
INSERT INTO kiz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bhoha bhakalela sana ni kumbinila Paulo mu n'singu ni kumbusu. ");
INSERT INTO kiz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bhahuzuniki zaidi jha ghoha kwandabha jha khela ambakyo ajobhili, kwamba kamwe bhibetalepi kubhubhona uso bhwa muene kabhele. Kisha bhakan'sindikila Merikebuni. ");
INSERT INTO kiz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wakati tulekene nabhu, na twisafiri mu bahari, twafikili moja kwa moja mu mji bhwa Kosi, ni kilabhu jhiake twafikili mji bhwa Rodi, ni kuhoma okhu twafikili mji bhwa Patara. ");
INSERT INTO kiz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Bhotukabhili meli jhajhilobhoka kulota Foinike, twakwelili twasafiri. ");
INSERT INTO kiz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bhotufikiri palongolo jha kisiwa kya Kipro, tukajhileka lubhafu lwa kushoto, twasafiri hadi Siria, tukabheka nanga mu mji bhwa Tiro, kwandabha okhu ndo meli jhilondekeghe ipakulibhwayi shehena jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Baada jha kubhabhona bhanafunzi, twatamili okhu magono saba. Bhanafunzi abha bhakan'jobhela Paulo kupetela kwa Roho kwamba muene asikanyi Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Hata bho tutimisi magono ghala, tete twabhokili tukakilotela, bhoha pamonga, ni bhadala bhabhi ni bhana bhabhi, bhatusindikisi mu njela sa jhofo hadi bho tuhomi kwibhala jha mji. Kisha twapigili magoti mu masimbale, twasokili, twalaghene khila mmonga. ");
INSERT INTO kiz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Twakweli meli, khoni na bhene bhakakerebhuka kunyumba jha bhene kabhele. ");
INSERT INTO kiz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hata bho tumalili safari jha jhoto kuhoma Tiro, twafikili Tolemai. Pala twasalimili bhalongobhitu, na twatamili okhu kwa ligono limonga. ");
INSERT INTO kiz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kilabhu jhiake tukabhoka tukalota Kaisaria. Tete twajhingili munyumba jha Filipo, muhubiri bhwa injili, jhaajhele mmonga ghwa bhala saba, natu twatamili pamonga ni muene. ");
INSERT INTO kiz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Munu ojho ajhele ni bhabinti bhancheche mabikra ambabho bhatabiri. ");
INSERT INTO kiz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Baada jhakutama okhu kwa magono kadhaa, akaselela kuhoma Uyahudi nabii mmonga jhaakutibhwe gha Agabo. ");
INSERT INTO kiz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Muene akahida kwa tete ni kuuleta n'kanda ghwa Paulo. kwa obhu akakikhongili magolo ni mabhoko gha muene ni kujobha, “Roho Mtakatifu ijobha naha,” “Bhayahudi bha Yerusalemu bhibetakun'konga munu jhaimiliki n'kanda obho, nabhene bhibetakun'karibisi mu mabhoko gha bhanu bha mataifa.” ");
INSERT INTO kiz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bhotupeliki mambo aghu, tete ni bhanu bhabhatameghe pala twansihi Paulo asikweli kulota Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ndipo Paulo ajibili, “Mwibhomba kiki, mwilela ni kunivunja muoyo ghwa nene? Kwa ndabha nijhe tayari siyo tu kufungibhwa, lakini pia kufwelela okhu Yerusalemu kwandabha jha lihina lya Bwana Yesu.” ");
INSERT INTO kiz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kwa vile Paulo alondelepi kushawishibhwa, twalekili ni kujobha, “Basi mapenzi gha Bwana ghabhombekayi.” ");
INSERT INTO kiz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Baada jha magono agha, twatolili mifuku ghitu ni kukwela Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Baadhi jha bhanafunzi kuhoma Kaisaria kabhele bhalongosene hatu. Bandetili munu mmonga jhaakutibhweghe Mnasoni, munu ghwa Kipro, mwanafunzi ghwa muandi, ambajhe twataminakhu. ");
INSERT INTO kiz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Bho tufikili Yerusalemu bhalongobhitu bhatukaribisi kwa furaha. ");
INSERT INTO kiz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kilabhu jhiake Paulo alotili pamonga ni tete kwa Yakobo, ni bhaseya bhoha bhajhele. ");
INSERT INTO kiz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Baada jha kubhaponesya, abhapelili taarifa jhimonga baada jha jhenge jha mambo ambagho K'yara aghabhombili miongoni mwa mataifa kupetela huduma jhiake. ");
INSERT INTO kiz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wakati bhapeliki aghu, bhakan'sifu K'yara ni kun'jobhela, “Wilola, ndongo, kujha ni maelfu bhalenga bhakyeriri miongoni mwa Bhayahudi. Bhene bhoha bhajhe ni nia jha kukamula sheria. ");
INSERT INTO kiz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bhajobhibu kuhusu bhebhe, kujha ifundisya Bhayahudi bhabhitama kati jha mataifa kulekana ni Musa, ni kwamba ukabhajobhela bhasibhatairi bhana bhabhi, na bhasikesi desturi sya muandi. ");
INSERT INTO kiz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Twilondeka tukheta kiki? Bila shaka bhibetakupeleka bhebhe uhidili. ");
INSERT INTO kiz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Efyo bhombayi khila tete kyatukujobhela henu: tujhe ni bhanu bhancheche ambabho bhabhekili nadhiri. ");
INSERT INTO kiz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bhatolayi bhanu abha ni ukitakasiayi wa muene pamonga nabhu, na ubhalepayi gharama sya bhene, ili bhabhwesiayi kukasa mitu ghya bhene. Efyo khila mmonga akabhayi kumanya kujha mambo ghabhajobhibhu kuhusu bhebhe gha udesi. Bhibetakusimanyisya kujha bhebhe kabhele ghwikesya sheria. ");
INSERT INTO kiz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lakini kwa habari sya bhamataifa ambabho bhajhele bhaumini, twalembilli ni kupisya malaghisu kwamba bhilondeka kwijhepusya ni fenu fya fipisibhu dhabihu kwa sanamu, ni damu, kutokana ni khela kya kiniyongibhu, na bhakiepushayi ni uasherati.” ");
INSERT INTO kiz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ndipo, Paulo abhaletili bhagosi, ni ligono lya pili, akakitakasa muene pamonga nabhu, akajhingila mu hekalu, kipindi kya ligono lya kwitakasya hadi sadaka kupisibhwa kwa ndabha jha khila mmonga bhabhi. ");
INSERT INTO kiz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Magono aghu saba bho ghakaribili kumalika, baadhi jha Bhayahudi kuhoma Asia bhakambona Paulo mu hekalu, ni makutano bhakadada, ni kun'sosolela mabhoko. ");
INSERT INTO kiz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bhakajha bhijhwegha, “Bhanu bha Israeli, tutangatilayi. Ojho ndo munu jhola jha ikabhamanyisya bhanu khila mahali mambo ambagho ndo kinyume kya bhanu, sheria, ni mahali apa. Kabhele abhaletili Bhayunani mu hekalu ni kupanajisi mahali apa patakatifu.” ");
INSERT INTO kiz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kwa kujha mwanzoni bhajhele bhambwene Trofimo Muefeso akajha pamonga ni muene mjini, na bhene bhadhanileghe kwamba Paulo andetili mu hekalu. ");
INSERT INTO kiz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mji bhuoha bhwajhele ni taharuki, ni bhanu bhakajumba pamonga ni kun'kamula Paulo. Bhakampisya kwibhala jha hekalu, ni miliangu mara jhikafungibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bhobhijaribu kun'koma habari syamfikili mbaha ghwa jeshi lya bhalinzi kujha Yerusalemu jhioha jhimemili ghasia. ");
INSERT INTO kiz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mara ejhu akabhatola askari ni jemedari akaujumbila umati. Wakati bhanu bhambwene mbaha ghwa majeshi ni askari, bhakaleka kun'tobha Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kisha mbaha ghwa majeshi akan'karibila ni kun'kamula Paulo, ni kuamuru akongibhwayi minyororo mu mbele. Akan'kota muene niani na aketili kiki. ");
INSERT INTO kiz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Baadhi jha bhanu mu umati bhakajha bhipwayuka khenu akhe ni bhangi k'enge. Kwa kujha jemedari abhwesilepi kubhajobhela kyokyoha kwandabha jha sela njuegho, akaamuru Paulo aletibhwayi mugati mu ngome. ");
INSERT INTO kiz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Basi bho afikili pa ngazi, akatolibhwa ni askari kwa ndabha jha ghasia sya umati. ");
INSERT INTO kiz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ndabha umati bhwa bhanu bhan'kesisi na bhajhendelili kujhuegha, “Mumbosiajhi ojhu!” ");
INSERT INTO kiz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulo bho iletibhwa mugati mu ngome, an'jobhili mbaha ghwa majeshi, “Nibhwesya kun'jobhela khenu?” Jhola mbaha ghwa jeshi akajobha, “Je wilongela Kiyunani? ");
INSERT INTO kiz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Je, bhebhe sio jhola Mmisri ambajhe awali alonguisi uasi na atolili magaidi elfu nne nyikani?” ");
INSERT INTO kiz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo akajobha, “Nene na Myahudi, kuhoma mji bhwa Tarso jha Kilikia. Nene na raia ghwa mji maarufu. Nikabhas'oka, mniruhusiajhi nilongelayi ni bhanu.” ");
INSERT INTO kiz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wakati jemedari ampelili ruhusa, Paulo akajhema pa ngazi ni kupisya ishara kwa bhanu kwa kibhoko kya muene. Wakati bhajhele kinunu sana, akalongela nabhu kwa Kihebrania. Akajobha, ");
INSERT INTO kiz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“'Bhalongo bha dadijhangu, mupelekisiajhi utetezi bhwa nene bhwanibetakubhomba henu kwa muenga.” ");
INSERT INTO kiz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Makutano bho bhap'eliki Paulo ilongela nabhu kwa kiebrania, bhakagudama. Akajobha, ");
INSERT INTO kiz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nene ne myahudi, nihogoliki mji bhwa Tarso lieneo lya Kilikia, ila nakabhili elimu katika mji obho, pamagolo pa Gamalieli. Namanyisibhu kul'engana ni njela sahihi sya sheria sya bhadadijhitu. Nene nijhenibidii jha K'yara, kama muenga mwebhoha kyamujhe lelu. ");
INSERT INTO kiz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nabhatesisi kwa njela ejhe hadi kufwa; nabhakhongili bhagosi ni bhadala ni kubhasopa mu ligereza. ");
INSERT INTO kiz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hata kuhani mbaha ni bhaseya bhoha bhibhwesya kupisya ushahidi kujha napokili barua kuhoma kwa bhene kwandabha jha bhalongobhangu bhabhajhele Dameski, kwanene kusafiri kulota okhu. Jhajhele nibhaletayi bhanu Yerusalemu kwa njela ili bhakongibhwayi ni kutobhibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Jhatokili pala bho nisafiri nikaribila Dameski, majira gha pamusi ghafla nuru mbaha jhikatokela kumbinguni jhikajhanda kuniangasya. ");
INSERT INTO kiz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nikabina pasi ni kupeleka sauti jhikanijobhela, 'Sauli, Sauli kwandayakiki ukaniudhi?' ");
INSERT INTO kiz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Najibili, 'bhebhe wa niani, Bwana?' Akanijobhela, 'Nene na Yesu Mnazareti, ambajhe bhebhe ukaniudhi.' ");
INSERT INTO kiz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bhala bhabhajhele pamonga ni nene bhajhibhwene nuru, ila bhapeliki lepi sauti jha jhola jhaalongeleghe ni nene. ");
INSERT INTO kiz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nikajobha, 'Niketakiki, Bwana?' akanijobhela, jhemayi na ujhingilayi Dameski; okhu wibeta kujobhibhwa kila khenu kya wilondeka kubhomba.' ");
INSERT INTO kiz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nabhwesilepi kulola kwandabha jha muangaza bhwa nuru jhela, ndipo nikalota Dameski kwa kulongosibhwa ni mabhoko gha bhala bha bhajhe ni nene. ");
INSERT INTO kiz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Okhu nikabhonana ni munu jhaakutibhweghe Anania, ajhele munu jhaakamili sheria ni mwenye kuheshimika mbele jha bhayahudi bhoha bhabhatamili okhu. ");
INSERT INTO kiz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Akahida kwa nene, akajhema palongolo pa nene, ni kujobha, 'Ndongobhangu Sauli, ubhwesiajhi kulola.' Kwa muda bholabhola nikabhwesya kulola ni kumbona. ");
INSERT INTO kiz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Akajobha, 'K'yara ghwa dadijhitu akuchaguili bhebhe ubhwesyajhi kumanya mapenzi gha muene, kumbona jhola mwenye haki, ni kupeleka sauti jha jhihomela mu kinywa kya muene. ");
INSERT INTO kiz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwandabha wibetakujha shahidi kwa muene kwa bhanu bhoha juu jha ughabhwene ni kup'eleka. ");
INSERT INTO kiz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Basi henu kwandayikiki wilenda? Jhumukayi, ubatisibhwayi, ukasukayi dhambi sya jhobhi wakati ukalikuta lihina lya jhobhi.' ");
INSERT INTO kiz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Baada jha kukerebhuka Yerusalemu, na bho nisali mugati mu hekalu, jhikatokela kujha napelibhu maono. ");
INSERT INTO kiz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikambona akanijobhela, 'Hima na ubhokayi Yerusalemu manyata, kwandabha bhibetalepi kujhedekela ushuhuda bhwa jhobhi kuhusu nene.' ");
INSERT INTO kiz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikajobha, 'Bwana, bhabhu bhene bhamanyili nabhafungili mu ligereza ni kubhatobha bhala bhabhakuaminili mu khila lisinagogi. ");
INSERT INTO kiz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ni damu jha Stefano shahidi ghwa jhobhi bho jhijhitiki, Nene kabhele najhele nijhemili karibu ni kujhedekela na najhele nilenda nghobho sya bhala bhabhan'komili. ");
INSERT INTO kiz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lakini akanijobhela, 'Lotayi, kwandabha nene nibeta kulaghisya ulotayi patali kwa bhanu bha mataifa.” ");
INSERT INTO kiz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bhanu bhakanduhusu kulongela habari jha lilobhi e'le. Lakini baadaye bhakakwesya sauti ni kujobha, “mbosiajhi munu ojho mu nchi: Kwandabha sahihi aishiayi.” ");
INSERT INTO kiz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bho bhikwesya sauti, ni kutagha maguanda gha bhene ni kusopa malifu kunani, ");
INSERT INTO kiz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jemedari mbaha akaamuru Paulo aletibhwayi ngomeni. Akaamuru akotibhwayi khoni itobhibhwa mijeledi, ili muene amanyayi kwandabha jhakiki bhampigileghe makelele namna jhela. ");
INSERT INTO kiz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Hata bho bhan'kongili mighojhi, Paulo akan'jobhela jhola akida jha ajhemili pamonga naku, “Je! ndo haki kwa muenga kun'tobha munu jha ajhele Mrumi na akona kuhukumibhwa?” ");
INSERT INTO kiz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yola akida bho apeliki malobhi agha akalota kwa jemedari mbaha ni kun'jobhela, akajobha, “Wilonda kubhomba kiki? kwa maana munu ojho ndo Mrumi.” ");
INSERT INTO kiz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jemedari mbaha akahida ni kun'jobhela, “Nijobhelayi, je bhebhe ndo raia ghwa Rumi?” Paulo akajobha, “Ena.” ");
INSERT INTO kiz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jemedari akan'jibu, “Kwa kupetela kiasi kibhaha kya hela ndipo nakabhili uraia.” Lakini Paulo akan'jobhela, “'Nene ndo Mrumi wa kuhogoleka.” ");
INSERT INTO kiz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Basi bhala bhabhajhetayari kulota kun'kota bhakabhoka ni kundeka wakati bhobhuobhu. Ni jemedari ni muene akatila, bho amanyili kujha Paulo ndo Mrumi, ni kwandabha an'kongili. ");
INSERT INTO kiz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ligono lyalyafwatili, jemedari mbaha alondeghe kumanya ukweli kuhusu mashtaka gha bhayahudi dhidi jha Paulo. Efyo akambopolela fifungu fya muene akaamuru bhakuu bha makuhani ni baraza lyoha bhabhonanayi. Akandeta Paulo pasi, ni kumbeka pagati pa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo akabhalanga moja kwa moja bhanu bha baraza ni kujobha, “Bhalongobhangu, niishi mbele sya K'yaara kwa dhamira sinofu hadi naha lelu.” ");
INSERT INTO kiz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kuhani mbaha Anania akabhaamuru bhala bhabhajhemili karibu nakhu bhan'tobhayi kinywa kya muene. ");
INSERT INTO kiz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ndipo Paulo akan'jobhela, “K'yara ibetakutobha bhebhe, ukuta bhwa bhubakibhu chokaa. Utamili ukanihukumu kwa sheria, nabhi wiamuru nitobhibhwayi kinyume kya sheria?” ");
INSERT INTO kiz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhala bhabhajhemili karibu ni muene bhakajobha, “Ivi naha ndo kya ukandigha kuhani mbaha ghwa K'yara?” ");
INSERT INTO kiz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo akajobha, “bhalongobhangu, nene namanyilepi kujha ojho ndo kuhani mbaha. Kwa kujha jhilembibhu wibetalepi kulongela vibaya panani pa mtawala wa bhanu bha jhobhi.” ");
INSERT INTO kiz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo bho abhuene jha kujha upande umonga bhwa baraza ni Masadukayo ni bhangi Mafarisayo, akakuesya sauti ni kujobha, “bhalongobhangu nene na Mfarisayo, mwana ghwa Mfarisayo. Kwa ndabha ejhu nitegemela kwa ujasiri ufufuo bhwa bhafu bhanihukumibhwa nabhu.” ");
INSERT INTO kiz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bho aghajobhi agha, malumbano mabhaha ghatokili baina jha Mafarisayo ni Masadukayo, ni mkutano bhwagawanyiki. ");
INSERT INTO kiz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kwani Masadukayo bhijobha ujhelepi ufufuo, malaika bhwala ijhelepi roho, ila Mafarisayo bhijobha agha ghoha ghajhele. ");
INSERT INTO kiz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ghasia mbaha jhikatokela ni baadhi jha bhaandishi bhabhajhele lubhafu lwa Mafarisayo bhakajhema ni kujadili, bhakajobha, “tubhwelepi kyokyoh dhidi jha munu ojho. Bhuli kama roho au malaika alongili nabhu?” ");
INSERT INTO kiz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Wakati kuhomili hoja mbaha, mbaha ghwa majeshi atilili kujha Paulo ngaalalulibhu fipandi fipandi na bhene, hivyo akaamuru bhanajeshi bhaselelayi pasi ni kuntola kwa nghofu kuhoma kwa bhajumbe bha baraza, ni kundeta mu ngome. ");
INSERT INTO kiz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kiru kyakyafwatili Bwana ajhemili karibu ni muene ni kujobha, “Usitili, kwa ndabha unishuhudili katika Yerusalemu, hivyo kabhele wibetakupisya ushahidi ku Roma.” ");
INSERT INTO kiz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bho kubhalele, baadhi jha Bhayahudi bhabhombi liagano ni kukuta laana panani pa bhene: bhajobhi kujha bhibetalepi kulya wala kunywa kyokyoha mpaka pabhibetakun'koma Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kwajhele ni bhanu zaidi jha arobaini ambabho bhabhombili njama ejhe. ");
INSERT INTO kiz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhakalota kwa bhabhaha bha makuhani ni bhaseya ni kujobha, “Tukibhekili twebhene mu laana mbaha, tusili kyokyoha mpaka patwibetakun'koma Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hivyo henu, baraza lin'jobhelayi jemedari mbaha andetayi kwa muenga, kana kwamba mwiamura kesi jha muene kwa usahihi. Kwa tete tujhe tayari kun'koma kabla jha kuhida apa.” ");
INSERT INTO kiz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini muana wa dada jhake ni Paulo apeliki kujha kujhe ni njama, akalota akajhingila mugati mu ngome ni kun'jobhela Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulo akan'kuta akida mmonga ni kujobha, “N'tolayi n'songolo ojho kwa jemedari; ndabha ajhe ni lilobhi lya kun'jobhela.” ");
INSERT INTO kiz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Basi akida akan'tola n'songolo jhola akandongosya kwa jemedari mbaha akan'jobhela, “Paulo jhola mfungwa anikutili alondeghe nikuletelayi n'songolo ojho kwa bhebhe. Ajhe ni lilobhi lya kujobhela.” ");
INSERT INTO kiz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jemedali mbaha jhola akan'kamula kwa kun'kota, “Khenu gani wilonda kun'jobhela?” ");
INSERT INTO kiz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kijana jhola akajobha “Bhayahudi bhajobhene kukusoka undetayi Paulo kilabhu ku baraza ili kana kwamba bhilonda kukabha habari sya muene kwa usahihi nesu. ");
INSERT INTO kiz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Basi bhebhe usijhedekeli kwandabha bhanu zaidi jha arobaini bhakamvizila. Bhakikhongili kw laana, bhasili wala kunywa hadi pabhibetakun'koma. Hata henu bhajhe tayari, bhil'endela kibali kuhoma kwa bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Basi jhola jemedari mbaha akandeka n'songolo akilotelayi, baada jha kundaghisya, “usin'jobheli munu jhejhioha kujobha unijobhili agha.” ");
INSERT INTO kiz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Akabhakuta maakida bhabhele akajobha bhatayarisiajhi askari mia mbili kulota Kaisaria ni askari bhakwela farasi sabini, ni bhabhajhe ni migoha mia mbili, mwibetakubhoka zamu jha tatu pakilu. ");
INSERT INTO kiz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Akabhajobhela kubheka bhanyama tayari ambaye Paulo ibetakun'tumila ni kun'tola salama kwa Feliki Gavana. ");
INSERT INTO kiz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akajhendika barua kwa namna ejhe, ");
INSERT INTO kiz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio Lisia kwa Liwali mtukufu Feliki, salamu. ");
INSERT INTO kiz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Munu ojho akamuili kwa bhayahudi bhakajha karibu kun'koma, ndipo nikalota pamonga ni kikosi kya askari nikamwokola, bhonikabhili habari kujha muene raia ghwa kirumi. ");
INSERT INTO kiz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nilondeghe kumanya kwandayakiki bhan'takili, efyo nampelili mu baraza. ");
INSERT INTO kiz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nikabhona kwamba atakilibhu kwandabha jha maswali gha sheria jha bhene wala atakilibhu lepi lilobhi lyolyoha lya kustahili kukomibhwa wala kukongeka. ");
INSERT INTO kiz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kisha jhamanyikene kwa nene kujha ijhe njama dhidi jha muene, ivyo kwa haraka nikandaghisya kwa bhebhe, ni kubhalaghisya bhabhakan'shtaki kabhele bhaletayi mashataka dhidi jha muene mbele jha bhebhe. Bhakalaghana.” ");
INSERT INTO kiz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Basi askari bhala bhakatii amri: bhakan'tola Paulo bhakandeta hadi Antipatri pakilu. ");
INSERT INTO kiz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ligono lyalyakesili, maaskari bhingi bhakabhateka bhala bhakwela farasi bhalotayi pamonga ni muene na bhene bhakakerebhuka ku ngome. ");
INSERT INTO kiz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ni bhakwela farasi bhobhafikili Kaisaria, ni kumpela liwali barua jhela, bhakambeka Paulo palongolo pa muene. ");
INSERT INTO kiz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ni muene liwali bho ajhisomili barua, an'kotili Paulo ahomili lijimbo leleku; bhoamanyili jha kujha ni munu ghwa Kilikia, ");
INSERT INTO kiz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akajobha, “Nibetakup'eleka bhebhe pabhibetakuhida bhala bhabhakutakili, “akamuru abhekibhwayi pa ikulu jha Herode. ");
INSERT INTO kiz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Baada jha magono mahanu, Anania kuhani mbaha, baadhi jha bhaseya ni n'jobhaji mmonga jhaakutibhweghe Tertulo, bhakalota pala. Bhanu abha bhaletili mashataka dhidi jha Paulo kwa Gavana. ");
INSERT INTO kiz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo bho ajhemili palongolo pa gavana, Tertulo akajhanda kun'takila ni kujobha kwa gavana, “kwandabha jha bhebhe tujhe ni imani nibaha; ni kwa maono ghe jhobhi ghileta mageuzi manofu mu taifa lya jhoto; ");
INSERT INTO kiz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Basi kwa shukurani jhioha twipokela shukurani jhioha khila khenu kya wibhomba, Wasalam mheshimibhwa Feliki. ");
INSERT INTO kiz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini nisikutondesi zaidi, nikusihi unipelekesiajhi malobhi madusu kwa fadhili jha jhobhi. ");
INSERT INTO kiz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kwandabha tun'kabhili munu ojho n'korofi, na isababisya bhayahudi bhoha kuasi pa dunia. Kabhele ndo ndongosi ghwa madhehebu gha Bhanazorayo. (Zingatilati: Sehemu jha malobhi gha n'sitari obhu 24: 6 ");
INSERT INTO kiz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na kabhele ajaribu kulisoppa hekalu unajisi hivyo tukan'kamula, ujhelepi mu nakala sinofu sya muandi). (Zingatilayi: N'stari obho ");
INSERT INTO kiz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lisiasi, afisa, akahida na akan'tola kwa nghofu mu mabhoko gha tete, ujhelepi mu nakala sinofu sya majhandiku gha muandi). ");
INSERT INTO kiz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Lekan'kotayi Paulo kuhusu mambo agha, hata wibetakusimanyisya ni khenu gani tun'takili.” ");
INSERT INTO kiz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bhayahudi ni bhene bhakan'takila Paulo, bhakajobha kujha mambo agha gha bhukweli. ");
INSERT INTO kiz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Liwali bho ampungili kibhoko ili Paulo alongelayi, Paulo ajibili, “Nimanyili kujha kwa miaka mingi ujhe ghwa mwamuzi ghwa taifa ele, na nijhe ni furaha kwijhelesya nejhoni kwa bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wibhwesya kuhakikisya kujha ghapetilepi zaidi jha magono kumi na mbili tangia nikwelili kulota kuabudu Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na bhobhanikolili mu hekalu, nabishenelepi ni munu jhejhioha, na nabhombi lepi fuju pa mkutano, wala ku masinagogi wala mugati mu mji; ");
INSERT INTO kiz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","na bhibhwesya lepi kuhakikisha kwa bhebhe mashitaka gha bhakanitakila dhidi jha nene. ");
INSERT INTO kiz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila nikiri e'le kwa bhebhe, jha kujha kwa njela jhela ambayo bhakajhikuta dhehebu, kwa njela jhejhu ejhu nikantumikila K'yara ghwa dadi jhitu. Nene ne mwaminifu kwa ghoha mu sheria ni maandikhu gha manabii. ");
INSERT INTO kiz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nijhe ni bhujasiri bholabhola kwa K'yara ambabho hata abhu nabhene bhakaulendela, kuhida kwa ufufuo kwa bhafu, kwa bhoha bhenye haki na bhabhabelikujha ni haki kabhele; ");
INSERT INTO kiz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ni kwa e'le, nibhomba mbombo ili nijhelayi ni dhamiri jhajhibelikujha ni hatia mbele jha K'yara ni mbele jha bhanu kupetela mambo ghoha. ");
INSERT INTO kiz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Henu baada jha miaka mingi nihidili kuleta msaada kwa taifa lya nene ni zawadi jha hela. ");
INSERT INTO kiz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bho nibhombi naha, Bhayahudi fulani bha Asia bhanikolili mugati mu sherehe jha utakaso mugati mu hekalu, bila likundi lya bhanu wala ghasia. ");
INSERT INTO kiz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bhanu abha ambabho jhilondeka bhajhelayi mbele jha bhebhe henu apa na bhajobhayi khela kyabhajhenaku juu jha nene kama bhajhe ni lilobhi lyolyoha. ");
INSERT INTO kiz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au bhanu abha bhene na bhajobhayi likosa leleku lyabhalibhwene kwa nene bho nijhemili palongolo pa baraza lya kiyahudi; ");
INSERT INTO kiz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Isipokujha kwa ndabha jha khenu kimonga kyanakijobhili kwa sauti bho nijhemili katikati jha bhene, 'kwandabha jha ufufuo bhwa bhafu muenga mukanihukumu.” ");
INSERT INTO kiz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliki ajhele ataarifibhu kinofu kuhusu njela, ni kubhuairisha mkutano. Akajobha, “Lisia jemedari paibeta kuhida pasi kuhoma Yerusalemu nibetakubisya maamuzi dhidi jha mashitaka gha muenga.” ");
INSERT INTO kiz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ndipo akaamuru akida andendayi Paulo, ili ajhelayi ni nafasi na sijhi munu wakubhabesya bharafiki bha muene bhasin'tangatili wala kun'gendela. ");
INSERT INTO kiz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Baada jha magono kadhaa, Feliki akakerebhuka ni Drusila n'dala munu jha ajhe Myahudi, akalaghisya kun'kuta Paulo ni kupelekesya kuhomela kwa muene habari sya imani mugati mwa Kristu Yesu. ");
INSERT INTO kiz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ila Paulo bho ajhele ijadiliana ni muene kuhusu haki kujha ni kiasi ni hukumu jhajhibeta kuhida, Feliki akakabha hofu akajibu, “lotayi patali kwa henu, ila nikakabhayi muda kabhele, nibetakukuta.” ");
INSERT INTO kiz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Muda bhobhuobhu, ategemili kujha Paulo ibeta kumpela hela kwa hiyo ankutili mara simehele kulongela naku. ");
INSERT INTO kiz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ila miaka mibhele jhajhipetili, Porkio Festo akajha Liwali baada jha Feliki, ila Feliki alondeghe kwipendekesya kwa bhayahudi, efyo akandeka Paulo chini jha uangalizi. ");
INSERT INTO kiz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ndipo Festo ajhingili mu lijimbo elu ni baada jha magono madatu akalota kuhoma Kaisaria hadi Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kuhani mbaha ni bhayahudi mashuhuri bhaletili shutuma dhidi jha Paulo kwa Festo, na bhalongili kwa nghofu kwa Festo. ");
INSERT INTO kiz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Na bhan'sokili Festo fadhili juu jha habari sya Paulo abhwesiajhi kunkuta Yerusalemu ili bhabhwesiajhi kun'koma munjela. ");
INSERT INTO kiz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lakini Festo ajibili kujha Paulo ajhele mfungwa mu Kaisaria, ni kwamba muene ikerebhuka okhu manyata. ");
INSERT INTO kiz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ajobhili “Kwa hiyo, bhala ambabho bhibhwesya kulota okhu ni tete. Kama kujhe ni khenu kibaya kwa munu ojho, mwilondeka kun'shtaki.” ");
INSERT INTO kiz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Baada jha kutama magono nane au kumi zaidi, akakerebhuka Kaisaria. Na ligono lyalafuatili atamili pa kiti kya hukumu ni kuamuru Paulo aletibhwayi kwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bho afikili, Bhayahudi kuhoma Yerusalemu bhajhemi karibu, bhakapisya mashtaka mazito ambajho bhabhwesilepi kughathibitisha. ");
INSERT INTO kiz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo akitetili ni kujobha, sio dhidi jha lihina lya bhayahudi, sio panani pa hekalu, na sio panani pa Kaisaria, nibhombi mabaya.' ");
INSERT INTO kiz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lakini Festo alondeghe kwipendekesya kwa bhayahudi, efyo akan'jibu Paulo ni kujobha, 'Je, wilonda kulota Yerusalemu ni kuhukumulibhwa ni nene kuhusu mambo agha okhu?' ");
INSERT INTO kiz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo ajobhili, 'nijhemili mbele jha kiti kya hukumu kya Kaisari ambapo nilondeka kuhukumulibhwa. Nibhakosilepi bhayahudi, kama kya umanyi bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nikajhiajhi nikosili na kama nibhombi kyakilondeka kifo, nibelepi kufwa. Lakini kama shutuma sya bhene khenu lepi, ajhelepi munu jhaibhwesya kunikabidhi kwa bhene. Nikansoka Kaisari. ' ");
INSERT INTO kiz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Baada jha Festo kulongela ni baraza akajibu, “Ukan'soka Kaisari; wibetalota kwa Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Baada jha magono kadhaa, mfalme Agripa ni Bernike bhafikili Kaisaria kubhomba ziara rasmi kwa Festo. ");
INSERT INTO kiz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baada jha kutamaapu kwa magono mingi, Festo awasilishi kesi jha Paulo kwa mfalme; Akajobha, 'Munu mmonga alekibhu apa ni Feliki kama mfungwa. ");
INSERT INTO kiz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bho nijhe Yerusalemu makuhani bhabhaha ni bhaseya bha bhayahudi bhaletili mashtaka juu jha munu ojho kwa nene na bhene bhakotili juu jha hukumu dhidi jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kwa e'le nene nabhajibili kujha desturi jha Bharoma lepi kumpisya munu upendeleo badala jhiake, mtuhumibhwa ilondeka kujha ni nafasi jha kubhakabili bhashtaki bha muene ni kwitetela dhidi jha tuhuma e'su. ");
INSERT INTO kiz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kwa hiyo, bhobhahidili pamonga apa, nabhwesilepi kulendela, lakini ligono lya lyafwatili natamili pakiti kya hukumu ni kuamuru munu ojho aletibhwayi mugati. ");
INSERT INTO kiz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wakati bhashtaki bhajhemili ni kun'shtaki, nifikirileghe kujha ghajhelepi mashtaka mabaha ghaghaletibhu dhidi jha muene. ");
INSERT INTO kiz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Badala jhiake, bhajhele ni mabishano fulani pamonga ni muene kuhusu dini jha bhene ni kuhusu Yesu ambajhe afuili, lakini Paulo idai kuwa ajhe muomi. ");
INSERT INTO kiz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nafumbibhu jinsi jha kuchungusya lisuala e'le, na nan'kotili kama ngaalotili Yerusalemu kuhukumibhwa kuhusu mambo agha. ");
INSERT INTO kiz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Paulo bho akutibhu abhekibhwayi chini jha ulinzi kwandabha jha uamuzi bhwa Mfalme, naamuiri abhekibhwayi hata panibeta kumpeleka kwa Kaisari.' ");
INSERT INTO kiz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa alongilili ni Festo, “Nilondeghe kabhele kumpelekesya munu ojho.” “Festo, akajobha, “kilabhu wibeta kumpelekesya.” ");
INSERT INTO kiz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hivyo kilabhu jhiake, Agripa ni Bernike bhafikili ni sherehe simehele; bhafikili pa ukumbi ni maafisa bha kijeshi, ni bhanu mashuhuri bha mji. Ni Festo bho apisili amri, Paulo aletibhu kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo akajobha, “Mfalme Agripa, ni bhanu bhoha ambabho bhabhajhele apa pamonga natu, mukambona munu ojho; Jumuiya jhioha jha bhayahudi okhu Yerusalemu ni apa kabhele bhilonda nibhashauriajhi, ni bhene bhakapiga kelele kwa nene kwamba asitami. ");
INSERT INTO kiz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nibhona kujha abhombilepi lyalilondeka kufwa; Lakini kwandabha an'kutili Mfalme, naamuili nimpelekayi kwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lakini nijhelepi ni khenu dhahiri kya kulemba kwa Mfalme. Kwandabha ejhe, nindetili kwa bhebhe, hasa kwa bhebhe, Mfalme Agripa, ili nibhwesiajhi kujha ni khenu kya kulemba kuhusu kesi. ");
INSERT INTO kiz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwa kujha nibhona ijhelepi ni maana kumpeleka mfungwa ni bila kulasya mashtaka ghaghakan'kabili. ");
INSERT INTO kiz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Efyo, Agripa akan'jobhela Paulo, `Wiruhusibhwa kwitetela. 'Ndipo Paulo akanyosya kibhoko kya muene akakitetela naha. ");
INSERT INTO kiz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","'Nikibhona nihobhwiki, Mfalme Agripa, ili kubhomba kesi jha nene mbele jha bhebhe dhidi jha mashtaka ghoha gha bhayahudi. ");
INSERT INTO kiz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Hasa, kwandabha bhebhe ghwe n'taalamu ghwa desturi sya bhajhahudi ni maswali. Hivyo nisoka unipelekesiajhi kwa uvumilivu. ");
INSERT INTO kiz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kweli, Bhayahudi bhoha bhamanyili jinsi kyaniishili kuhoma ujana bhwangu mu taifa lyangu okhu Yerusalemu. ");
INSERT INTO kiz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bhanimanyili kuh'omela kubhuandu na bhilondeka kujhedekela kujha naiishili kama Mfarisayo, dhehebu lenye msimamo n'kali ku dini jhitu. ");
INSERT INTO kiz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Henu nijhemili apa nihukumulibhwayi kwandabha nene nalangili ahadi ambajho K'yara abhombili ni bha dadi jhitu. ");
INSERT INTO kiz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ejhe ndo ahadi ambajho makabila ghitu kumi na mbili ghinoghela kupokela kama bhakamwabudu K'yara kwa bidii kiru ni musi. Ndo kwandabha jha tumaini e'le, mfalme Agripa, kujha Bhayahudi bhakanishtaki. ");
INSERT INTO kiz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwandajhakiki jhejhioha kati jhinu ifiki kujha ajabu kwamba K'yara ifufula bhafu? ");
INSERT INTO kiz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Wakati umonga nafikiri ne muene kujha nganibhombili mambo ghamehele dhidi jha lihina lya Yesu ghwa Nazareti. ");
INSERT INTO kiz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nabhombi agha ku Yerusalemu; Nabhafungili bhaamini bhingi mu ligereza na najhele ni mamlaka kuhoma kwa bhabhaha bha makuhani kubhomba naha; na wakati bhikomibhwa, napigili kura dhidi jha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mara nyingi nabhatobhili mu masinagogi ghoha na najaribu kubhabhomba bhaibelayi imani jha bhene. Najhele ni ligoga sana juu jha bhene na nabhabhengili ata mu miiji jha kubhuhesya. ");
INSERT INTO kiz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Wakati nibhomba agha, nalotili Dameski, nikajha ni mamlaka ni malaghisu kuhoma kwa makuhani ni bhabhaha; ");
INSERT INTO kiz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","bho nijhele munjhela wakati wa pamusi, Mfalme, nabhubhwene muanga kuhoma kumbinguni bhwajhele n'kali kuliko kijobha na bhwang'aniri kutusyongoka nene ni bhanu bhabhasafiriaghe pamonga ni nene. ");
INSERT INTO kiz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twebhona bho tubinili pasi, napeliki sauti jhilongela ni nene jhikajha jhijhoba kwa lugha jha Kiebrani: `Sauli, Sauli! Kwandajhakiki ukanitesya? Ni panonono kwa bhebhe kutobha liteke ni chokoo. ");
INSERT INTO kiz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ndipo nikajobha, 'Bhebhe we niani, Bwana?' Bwana akajibu, 'Nene ne Yesu ambajhe ukanitesya. ");
INSERT INTO kiz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Henu jhinukayi ujhemayi kwa magolo gha jhobhi; ndabha kwa kusudi e'le nene nibhonekene kwa jhobhi, nikuteuili kujha m'tumishi ni shahidi juu jha mambo ambagho umanyili kuhusu nene henu ni mambo ghanibetakulasya baadajhe; ");
INSERT INTO kiz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","na Nibetakuokola kwa bhanu ni bhanu bha mataifa ambapo nibetakulaghisya, ");
INSERT INTO kiz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kufungula mihu gha bhene ni kubhapisya mu ngisi kulota kwa muanga ni kuhoma ku nghofu sya syetani bhan'geukilayi K'yara; ili bhabhwesyajhi kupokela kuhoma kwa K'yara msamaha bhwa dhambi ni urithi ambao nibhapeli bhala bhanibhatengili kwa imani jhaijhe kwa nene. ");
INSERT INTO kiz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Hivyo, mfalme Agripa, nabhwesilepi kuasi maono gha kumbinguni, ");
INSERT INTO kiz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","lakini, kwa bhala bhabhajhele ku Dameski hoti, ni kisha Yerusalemu ni nchi jhioha jha Yudea, kabhele ni kwa bhanu bha mataifa ghangi, nahubiri kujha bhatubuajhi ni kun'geukila K'yara, bhabhombayi matendo gha ghikastahili toba. ");
INSERT INTO kiz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa ndabha ejhu Bhajhahudi bhanikamuili mu lihekalu, bhakajaribu kunikoma. ");
INSERT INTO kiz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","K'yara anitangili mpaka henu, hivyo ni jhema ni kushuhudila kwa bhanu bha kawaida ni kwa bhala bhabhaha juu jha ghala ambagho manabii ni Musa bhajobhili ghitokel na sio fenge; ");
INSERT INTO kiz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kwamba Kristu lazima ibetakutesibhwa na ibetakujha gwa kuanza kufufuka kuhoma kwa bhafu ni kutangasya mwanga kwa Bhayahudi ni bhanu bha mataifa. ");
INSERT INTO kiz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo akamala kwitetela, Festo akajobha kwa sauti mbaha, 'Paulo, bhebhe ndo mwendawazimu! masomo gha bhebhe ghakubhombili ujhelayi ghwe silola. ");
INSERT INTO kiz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lakini Paulo akajobha, Nene namwendawazimu lepi, mheshimiwa Festo; lakini kwa ujasiri nijobha malobhi gha ukweli tu. ");
INSERT INTO kiz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kwa kujha mfalme umanyili kuhusu mambo agha; na hivyo, nilongela kwa uhuru kwa muene, kwa maana nijhe ni hakika kujha lijhelepi lyolyoha lya libetakufighibhwa; kwa kujha e'le libhombiki lepi pa pembeni. ");
INSERT INTO kiz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Je, ghwikiera manabii, Mfalme Agripa? Nimanyi kujha wiamini.' ");
INSERT INTO kiz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa akan'jobhela Paulo, 'Kwa muda mfupi wibhwesya Mkristu? ");
INSERT INTO kiz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo akajobha, “Nikan'soka K'yara kujha, kwa mda mfupi au n'tali, sio bhebhe tu, bali bhoha bhabhakanipelekesya lelu, bhebhe kama nene, lakini bila ejhe minyororo ghya mu gereza.” ");
INSERT INTO kiz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ndipo mfalme akajhema, ni liwali, ni Bernike kabhele, ni bhala bhabhajhele bhatami pamonga nabhu, ");
INSERT INTO kiz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","bho bhabhokili pa ukumbi, bhalongili bhene kwa bhene ni kujobha, 'Munu ojho akastahili lepi kifo wala kifungu.' ");
INSERT INTO kiz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa akan'jobhela Festo, “Munu ojho jhilondeka ajhelayi huru kama ngaakatilepi rufani kwa Kaisari.” ");
INSERT INTO kiz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bho jhiamulibhu kujha twilondeka kusafiri kwa masi kulota Italia, bhan'kabidhi Paulo ni bhafungwa bhangi kwa afisa mmonga bhwa jeshi la Kiroma jhaakutibhweghe Julio, ghwa kikosi kya Agustani. ");
INSERT INTO kiz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twakweli meli kuhoma Adramitamu, ambajho jhajhele isafiriajhi mundemandema jha pwani jha Asia. Hivyo tukajhingila baharini. Aristaka kuhoma Thesolanike jha Makedonia akalota pamonga ni tete. ");
INSERT INTO kiz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ligono lyalakesisi tukasopa nanga mu mji bhwa Sidoni, ambapo Julio ambombili Paulo kwa ukarimu ni kunduhusu kulota kwa bharafiki zake kupokela ukarimu bhwa nene. ");
INSERT INTO kiz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuhoma api tokalota mu bahari twasafiri kusyongoka kisiwa kya Kipro ambakyo kya k'engibhu ni m'pongo, kwa ndabha m'pongo utusumbuleghe. ");
INSERT INTO kiz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Baada jha kusafiri mmasi kalibu ni Kilikia ni Pamfilia, tukahida Mira, mji bhwa Lisia. ");
INSERT INTO kiz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pala jhola afisa ghwa jeshi lya Kiroma, ajhikolili meli kuhoma Alexandria ambajho jhilondeghe kusafiri kulota Italia. Akatukwesya mugati. ");
INSERT INTO kiz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Baada jha kusafiri molimoli kwa magono mingi ni hatimaye twfikili kwa tabu karibu ni Kinidas, m'pongo ghwa turuhusuili lepi kabhele kulota njela ejhu hivyo twasafiri mundemandema jha kivuli kya Krete khoni twikikenga mp'ongo, mkabala ni Salmone. ");
INSERT INTO kiz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twasafiri mundemandem jha pwani kwa ukakatafu, mpaka tukafika mahali papakutibhu Fari Haveni ambajho ijhele karibu ni mji bhwa Lasi. ");
INSERT INTO kiz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twatolili muda umelele muni, ni muda bhwa mfungo ghwa Kiyahudi ghwajhele umalikupea kabhele, na henu jhajhele ni hatari kujhendelela kusafiri. Hivyo Paulo akatuonya, ");
INSERT INTO kiz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ni kujobha, “Bhagosi, nibhona safari jha twilonda kulota ejhe ni madhara ni hasara simehele, siyo tu jha misighu ni meli, lakini ni jha maisha gha jhotu.” ");
INSERT INTO kiz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini afisa ghwa jeshi la Kiroma akampelekesya zaidi bwana ghwa muene ni mmiliki ghwa meli, kuliko mambo ghala ghaghalongelibhu ni Paulo. ");
INSERT INTO kiz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwandabha bandari jhajhelepi sehemu rahisi kutama wakati bhwa mepu, mabaharia bhingi bhashauriri tusafiriajhi kuhoma pala, ili kwa namna jhejhioha tubhwesiajhi kubhufikila mji bhwa Foinike, tutamayi pala bhwakati bhwa mepu. Foinike ndo bandari okhu Krete, na jhilola kaskazini mashariki ni kusini mashariki. ");
INSERT INTO kiz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mp'ongo ghwa kusini bho bhujhendili kubhuma molimoli, mabaharia bhakafikirira kujha bhamalili kukabha kya bhakilondeghe. Bhakajhonja nanga ni kusafiri mundemandema jha Krete karibu ni pwani. ");
INSERT INTO kiz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakini baada jha muda mfupi mp'ongo n'kali, bhwabhukutibhweghe bhwa kaskazini mashariki, ukajhanda kututobha kuhoma kwiselya jha kisiwa. ");
INSERT INTO kiz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wakati meli ijhelemibhu ni kushindwa kubhukali mp'ongo, tukajhedekelana ni hali ejhu, tukasafirisibhwa nabhu. ");
INSERT INTO kiz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tukajhumba kup'etela lubhafu lwa luukingighe mp'ongo bhwa kisiwa kyakikutibhweghe Kauda; ni kwa taabu sana twafanikibhu kuokola bhwatu. ");
INSERT INTO kiz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Baada jha kujha bhabhufutili, bhatumili ngojhi kuuk'onga meli. Bhatileghe kujha ngatubhwesi kulota ku lieneo lya n'sanga ghumehele lya Syiti, hivyo bhakaselesya nanga na bhagendesibhu mundemandema. ");
INSERT INTO kiz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Twatobhibhu kwa nghofu sana ni linyegha, hivyo ligono lyalyifwatili mabaharia bhakajhanda kusopa misighu kuhoma mu meli. ");
INSERT INTO kiz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ligono lya tatu, mabaharia bhakayanda kup'omba masi kwa mabhoko gha bhene. ");
INSERT INTO kiz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wakati ambapo lijobh ni litondo syatumuliki lepi kwa magono mingi, bado linyegha libhaha lyatutobhili, ni matumaini kujha tubetakuokolibhwa ghabhokili. ");
INSERT INTO kiz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Baada jha kujha bhalotili muda mrefu bila kyakulya, apu Paulo akajhema pagati pa mabaharia akajobha, “Bhagosi, mlondekeghe mnip'elekesiajhi, ngatubhokilepi kuhoma Krete, ili kukabha agha madhara ni hasara. ");
INSERT INTO kiz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Na henu nikabhafariji mkipelayi muoyo, kwa ndabha kubetalepi kujha ni upotefu bhwa maisha kati jha muenga, isipokujha hasara jha meli tu. ");
INSERT INTO kiz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwa ndabha kiru kya kilotili malaika ghwa K'yara, ambajhe K'yara ojhu nene ne ghwa muene, ni ambajhe nikamwabudi kabhele - malaika ghwa muene ajhemili palubhafu pa nene ");
INSERT INTO kiz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ni kujobha, “Usitili Paulo. Lazima ujhemayi palongolo Kaisari, na langayi, K'yara ku bhunofu bhwa muene akupelili abha bhoha ambabho bhisafiri pamonga ni bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Efyo, bhagosi, mukipelayi muoyo, kwandabha nikan'kier K'yara, kujha ibetakujha kama kyanibhajobhili. ");
INSERT INTO kiz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini lazima tulamatayi kwa kutobhibhwa mu baadhi jha fisibhwa.” ");
INSERT INTO kiz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Bho ufikili kiru kya kumi na nne, bho twigendesibhwa okhu ni okhu mu bahari jha Adratik, kama kiru kya manane naha, mabaharia bhafikirileghe kujha bhikaribila kundema. ");
INSERT INTO kiz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bhatumili milio kup'ema kina kya masi nabhakabhaka mita thelathini na sita, baada jha muda mfupi bhakap'ema kabhele bhakakabha mita ishirini na sita, baada jha muda mfupi bhakap'ema kabhele bhakakabha mita ishirini na saba. ");
INSERT INTO kiz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bhatilili kujha bhibhwesya kugonga miamba, hivyo bhakaselesya nanga sinchenche kuhomela sehemu jha lukhela jhihidayi manyata. ");
INSERT INTO kiz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bhala mabaharia bhakajha bhilonda bhaselisi maboti mu masi madebemadebe gha kuokolela maisha, na bhakajha bhikifuanya bhisopa nanga pa sehemu jha palongolo jha liboti. ");
INSERT INTO kiz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Paulo akan'jobhela jhola askari ghwa jeshi la Kiroma ni bhala askari, “Mwibhwesya lepi kuokoka isipokujha bhanu abha bhibakila mu meli”. ");
INSERT INTO kiz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kisha askari bhala bhakadumula mighojhi jha liboti ni kujhileka jhitolibhwayi ni masi. ");
INSERT INTO kiz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Wakati mwanga ghwa lukhela ghwihoma, Paulo akabhasihi bhoha angalau bhala bhadebe. Akajobha, “Ejhe ligono lya kumi na nne mwilendela bila kulya mlilepi khenu. ");
INSERT INTO kiz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hivyo nikabhasihi mtolayi kyakulya kidebe, kwandabha ejhe kwandabha jha kuishi kwa muenga; na lujhelepi hata lujhusili lumonga pamitu ghya jhomu lwalibetakujhagha. ");
INSERT INTO kiz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Abhoamali kujobha aghu, akalota n'kate akan'shukuru K'yara palongolo jha mihu gha khila munu. Kisha akaumetula n'kate akajhanda kulya. ");
INSERT INTO kiz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kisha bhoha bhakapelibhwa muoyo na bhene bhakalota kyakulya. ");
INSERT INTO kiz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Twajhele bhanu 276 mugati mu meli. ");
INSERT INTO kiz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bho bhalili fya kutosha, bhaibhombi meli mbepe kwa kutagha ngano mu masi. ");
INSERT INTO kiz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bhojhifikiri pamusi, bhajhitambuili lepi kundema, lakini bhakabhona sehemu jha kundema jhajhingili mmasi jhajhijhele ni n'sanga mwingi. bhakajadiliana kama bhibhwesya kugendesya meli kulota apu. ");
INSERT INTO kiz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Hivyo bhakesihobhosya nanga bhakasileka mmasi. Katika muda bhobhuobhu bhakasihobhosya mighojhi jha nanga ni kujhijhinula sehemu jha palongolo kulotela ku mp'ongo, hivyo bhakalota sehemu jha nsanga bhumehele. ");
INSERT INTO kiz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini bhakahida mahali ambapo miela mibhele ghya masi ghibhonana, ni meli jhikalota kun'sanga. Ni jhela sehemu jha palongolo jha meli jhakwamili pala na jhabhwesilepi kubhoka, lakini sehemu jha palongolo jha meli jhikajhanda kudumuka kwa ndabha jha ukali ghwa manyegha. ");
INSERT INTO kiz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mpango ghwa bhala askari bhwajhele kubhakoma bhafungwa, ili kwamba ajhelepi ambajhe ngaasoghili ni kutoroka. ");
INSERT INTO kiz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini jhola askari ghwa jeshi lya Kiroma alondeghe kumwokola Paulo, hivyo akabhujhemeka mpango bhwa bhene; ni kubhaamuru bhala ambabho bhibhwesya kusogha, bharukayi kuhoma mu meli hoti na bhalotayi kundema. ");
INSERT INTO kiz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kisha bhagosi bhamana bhakakesya, bhangi panani pa fenu fenge kuhoma mu meli. Kwa njela ejhe jhatokili bhoha twibeta kufika kinofu kundema. ");
INSERT INTO kiz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bhotufikisibhu kinofu, twamanyili kujha kisibhwa kukutibhwa Malta. ");
INSERT INTO kiz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bhanu bhenyeji bha pala si tu bhatupelili ukarimu bhwa kawaida, bali bhakosi muoto ni kutukaribisya bhoha, kwandabha jha fula ni mepu jha jhijhendeleleghe. ");
INSERT INTO kiz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lakini Paulo bho abhongeniye nsighu ghwa mbabhu ni kubheka pa muoto, lijhoka lidebe lyalijhe ni sumu akahoma mu mbabhu mola kwandabha jha lijotolela, ni kwisyongosya mu kibhoko kya muene. ");
INSERT INTO kiz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bhanu bhenyeji bha pala bhobhebhuene mnyama inimbila mu kibhoko kya muene, bhakajobhesana bhene kwa bhene, “Munu ojho hakika muuaji atoruiki mu bahari, lakini haki jhikanduhusu lepi kuishi.” ");
INSERT INTO kiz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini muene akansopa mnyama ojhu mu muoto na akabhilepi madhara ghoghoha. ");
INSERT INTO kiz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bhene bhakajha bhakandendela afimbayi kwa homa au abinayi ghafla ni kufwa. Lakini baada jha kundanga kwa muda mrefu ni kubhona kujha lijhelepi lijambo ambalyo la kawaida lepi kwa muene, bhakabadilisya mawazo gha bhene ni kujobha ajhele K'yara. ");
INSERT INTO kiz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Basi mahali pala karibu pajhele ni ardhi ambajho jhajhele mali jha mbaha ghwa kisiwa, munu jha akutibhweghe Pablio. Atukaribisi ni kutukarimu kwa magono madatu. ");
INSERT INTO kiz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Jhatokili kujha ni dadi ghwa Pablio akamulibhu ni homa ni bhutamu bhwa kuhara. Ni Paulo bho andotili, asokili akabheka mabhoko panani pa muene ni kumponesya. ");
INSERT INTO kiz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Baada jha e'le kuhomela, bhanu bhangi pa kisiwa pala bhabhalwaleghe kabhele bhakalota ni kumponyesibhwa. ");
INSERT INTO kiz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bhanu bhakatuheshimu kwa heshima simehele. Bho twikiandala kusafiri, bhatupelili fela fya tulondeghe. ");
INSERT INTO kiz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Baada jha miesi midatu, twasafiri mugati mu meli jha Iskanda ambajho jhajhele jhitobhibhu mepi apu pakisiwa, ambajho bhalongosi bhake bhajhele bhalongo bhabhele mapasa. ");
INSERT INTO kiz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Baada jha kujha tutolili pa mji bhwa Sirakusa, twatamili pala magono madatu. ");
INSERT INTO kiz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuhomela pala twasafiri mu mji bhwa Regio. Baada jha ligono limonga mp'ongo ghwa kusini ghwatokili ghafla, na baada jha magono mabhele twafikili ku mji bhwa Putoli. ");
INSERT INTO kiz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Okhu twabhakolili baadhi jha bhalongobhifu na twakalibisibhu kutama nabhu kwa magono saba. Kwa njela ejhe tukahida Rumi. ");
INSERT INTO kiz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kuhoma okhu bhala bhalongobhitu, baada jha kujha bhapeliki habari sya tete, bhakahida kutupokela okho soko lya Apias ni Hotel sidatu. Paulo bho abhuene bhala bhalongo akan'shukuru K'yara akakipela ujasiri. ");
INSERT INTO kiz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Bho tujhingili Roma, Paulo aruhusibhu kutama muene pamonga ni jhola askari jha andendeghe. ");
INSERT INTO kiz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Basi jhajhele baada jha magono madatu Paulo abhakutili bhala bhagosi bhabhajhele bhalongosi kati jha Bhayahudi. Bho bhahidili pamonga, ajobhi kwa bhene, “Bhalongobhangu, pamonga ni kwamba nibhombilepi likosa lyolyoha kwa bhanu abha au kubhomba kinyume ni taratibu sya bhakhokho bhitu bhabhatulongolili, napisibhu kama mfungwa kuhoma Yerusalemu hadi mu mabhoko gha Bharumi. ");
INSERT INTO kiz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Baada jha kunihoji, bhanogheleghe kundeka huru, kwandabha kwajhelepi ni sababu kwa nene kulondeka adhabu jha kifo. ");
INSERT INTO kiz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Bhayahudi bhala bho bhalongili kinyume kya shauku jha bhene, nalazimiki kukata rufaa kwa Kaisari, japokujha jhajhelepi kana kwamba nileta mashataka panani pa taifa lya nene. ");
INSERT INTO kiz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwa ndabha jha kukata kwa nene rufaa, efyo, nasokili ni kulongela namu. Kwandabha jha khela ambakyo Israeli ajhe ni ujasiri naku, nifungibhu ni kifungu ekhe. ");
INSERT INTO kiz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kisha bhakan'jobhela, “Tubhwayilepi kupokela barua kuhoma Yudea kuhusu bhebhe, wala ndongobhu kuhida kupisya taarifa au kujobha lilobhi lyolyoha lela libaya kuhusu bhebhe. ");
INSERT INTO kiz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini twilonda kupeleka likundi e'le lya bhanu abha, kwandabha limanyikene kwa tete kujha lilongela kinyume kila mahali.” ");
INSERT INTO kiz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bhobhatengili ligono kwandabha jha bhene, bhanu bhingi bhan'hidili mahali pa atameghe. Ajobhi lijambo lela kwa bhene ni kushuhudila kuhusu ufalme bhwa K'yara. Ajaribu kubhashawishi kuhusu Yesu, kwa namna syoha sibhele kuhoma kusheria sya Musa ni kuhoma kwa manabii, kujhandila lukhela hadi kimihi. ");
INSERT INTO kiz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baadhi jha bhene bhashawishiki kuhusu mambo ghala ghaghajobhibhu, wakati bhamana bhkyeri lepi. ");
INSERT INTO kiz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bhobhashindilu kukubaliana bhene kwa bhene, bhabhokili baada jha Paulo kulijobha lijambo e'le limonga, “Roho Mtakatifu ajobhili kinofu kup'etela Isaya nabii kwa bhadadi jhinu. ");
INSERT INTO kiz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ajobhili, 'Lotayi kwa bhanu abha ujobhayi, “Kwa mb'olokoto sya jhomu mwibetakup'eleka, lakini mwibetalepi kujhelebhwa; Na kwa mihu ghinu mwibetakulola lakini mwibetakutambula lepi. ");
INSERT INTO kiz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwandabha jha mioyo jha bhanu abha midhaifu, mb'ol'okoto sya bhene sipeleka kwa tabu, bhafumbili mihu gha bhene, ili kwamba bhasihidi kutambula kwa mihu gha bhene, ni kup'el'eka kwa mb'ol'okoto sya bhene, ni kujhelebhwa kwa mioyo ghya bhene ni kugeuka kabhele, na nganibhaponyisi.”' ");
INSERT INTO kiz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kwa hiyo, mwilondeka kumanya kujha bhwokovu obho bhwa K'yara up'elekibhu kwa bhanu bha Mataifa, na bhibetakup'elekesya.” ");
INSERT INTO kiz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo atamili mu nyumba jha muene jha kupanga kwa miaka ghioha mibhele, na kwa muene. ");
INSERT INTO kiz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Akajha ihubiri ufalme bhwa K'yara na akajha ifundisya mambo juu jha Bwana Yesu Kristu kwa ujasiri bhwoha. Ajhelepi jha am'besili. ");
INSERT INTO kiz_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo ntumishi ghwa Yesu Kritu jha akutibhu kujha mfalme, ni kutengibhwa kwa ndabha jha injili jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ejhe ndo jhela Injili jhaaihaidi muandi kup'etela manabii bha muene mu maj'handiku matakatifu. ");
INSERT INTO kiz_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ndo kwandabha jha mwanabhe, jha ahogoliki mu lukholo lwa Daudi ku namna j'ha mbhele. ");
INSERT INTO kiz_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Muene atangasibhu kuj'ha mwana ghwa K'yara kwa ng'hofo j'ha Roho mtakatifu kwa bhufufuo bhwa bhafu Yesu Kristu Bwana bhitu. ");
INSERT INTO kiz_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kup'etela muene tuj'hamb'elili neema ni bhutme bhwa utii bhwa imani kati j'ha mataifa ghoha kwa ndabha jha lihina lya muene. ");
INSERT INTO kiz_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kati jha mataifa agha, muenga kabhele mukkutibhu kujha bha Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Barua ejhe jha kwa bhoha bhabhajhele rumi bhabhaganikibhu ni K'yara, bhakutibhu kujha bhanu bhatakatifu. Neema jhijhafayi kwa muenga ni amani kuhoma kwa K'yara Dadi jhitu ni Bwana Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Hoti nikambombesya K'yara ghwangu kwa Yesu Kristu kwandabha jha muenga mwebhoha kwandabha imani jha muenga jhihubiribhwa pa dunia jhioha. ");
INSERT INTO kiz_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kwandabha K'yara ndo shahidi ghwa nene ambajhe nan'tumikili kwa roho jha nene mu Injili jha mwanamunu, namna kyenitamisya kubhataja. ");
INSERT INTO kiz_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Daima nisoma mu sala sya nene kujha kwa njela jhejhioha nikabhaikwa kumalikili kujha ni mafanikilu henu kwa mapenzi gha K'yara kwa kuhida kwa jhomu. ");
INSERT INTO kiz_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ndabha ninoghela kubhabhona ili nibhwesiajhi kubhapela muenga karama sya mu roho, nibhwesiajhi kubhasindamalisya. ");
INSERT INTO kiz_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yaani nilolelela kupelibhwa muoyo ni muenga, kwa njela jha imani jha khila mmonga bhitu, muenga ni nene. ");
INSERT INTO kiz_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Henu bhalongo bhangu nilondalepi musindwayi kmanya kujha, mara simehele nilondeghe kuhida kwa muenga lakini nibesibhu hadi henu. Nilondeghe naha ili kujha ni matunda kwa muenga kama kyajhijhele kabhele miongoni mwa bhanu bha mataifa. ");
INSERT INTO kiz_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nimalibhwa ni Bhayunani ni bhahesya kabhele, bherevu ni bhajinga. ");
INSERT INTO kiz_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Henu, kwa nene, nene nijhe tayari kutangasya Injili kwa muenga kabhele muenga jha mujhele okhu Roma. ");
INSERT INTO kiz_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kwa ndabha nikajhibhonela lepi soni Injili, kwa kujha ndo bhuweza bhwa K'yara bhwawileta bhwokovu kwa khila jhaiamini kwa Myahudi hoti ni kwa Muyunani kabhele. ");
INSERT INTO kiz_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwandabha haki jha K'yara j'hidhihirishibhu kuhoma imani hata imani, kama kyajhilembibhu, “Jhaajhele ni haki ibeta kuishi kwa imani.” ");
INSERT INTO kiz_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ndabha ghadhabu jha K'yara jhidhihirishibhu kuhoma kumbinguni dhidi jha bhuasi ni bhuovu bhwoha bhwa bhanu, ambabho kwa njela jha bhudhalimu jhifigha bhukweli. ");
INSERT INTO kiz_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ejhe kwandabha, ghoha ghaghibhwesye kumanyikana panani pa K'yara ghajhe bhwasi kwa bhene. Ndabha K'yara abhabholili. ");
INSERT INTO kiz_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ndabha mambo gha muene ghaghabhonekeneghelepi kinofu ghajhele bhwasi kuhomela kubhombibhwa kwa ulimwengu. Ghijhelabhweka kup'etela fenu fyafibhombibhu. mambo agha ndo bhuweza bhwa muene bhwa milele ni asili jha bhu K'yara. Matokeo ghake, bhanu abha bhajhelepi ni bhudhuru. ");
INSERT INTO kiz_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ejhe kwandabha, ingabhwa bhamanyili kuhusu K'yara bhabeli kun'tukusya muene kama K'yara bhwala bhampeli lepi kabhombeselu. Badala jhiake, bhajhe bhapumbafu mu mabhuasu gha bhene, ni mioyo ghya bhene ghyaghijhele ni ujinga bhwa sopibhu ngisi. ");
INSERT INTO kiz_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bhakikuteghe bhaervu, lakini bhajhele bhajinga. ");
INSERT INTO kiz_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bhaugeusi bhutukufu bhwa K'yara jha abeli kujha ni bhuharibifu kwa mfuanu bhwa sura jha binadamu jhaajhele ni bhuharibifu, ni jha fidege jha bhanyama bhenye magolo mancheche, ni fiumbe fyafiboya. ");
INSERT INTO kiz_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Henu, Kyara abhalekhili bhakhesiajhi tamaa sya mioyo ghya bhene kwa bhuchafu, kwa mibhele ghya bhene kukosibhwa soni baina jha bhene. ");
INSERT INTO kiz_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ndo bhene bhabhajhisanuisi kweli jha K'yara kujha bhudesi, na bhabhaabuili ni kutumikila fiumbe badala jha muumbaji ambajhe isifibhwa milele. Amina ");
INSERT INTO kiz_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwa ndabha ejhe k'yara abhalekili bhakhesiajhi tamaa sya bhene sya soni kwa kujha bhadala bhabhi bhasanuisi matumizi gha bhene gha asili kwa khele kyakijhele kinyume ni asili. ");
INSERT INTO kiz_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hali mabhu bhadosi ni bhene kabhele bhalekili matumizi gha bhene gha asili kwa bhadala ni kujha ni tamaa dhidi jha bhene Abha bhajhele bhagosi ambabho bhabhombibhu ni bhagosi bhajhine ghaghilondeka lepi, ni ambabho bhapokili adhabu jhajhiondeghe bhukonyofu bhwa bhene. ");
INSERT INTO kiz_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwa ndabha bhabelili kujha ni K'yara mu fahamu sya bhene, abhalekhili bhakhasiajhi akili sya bhene syasifuajhi lepi, bhabhombayi mambo ghala ghaghifuajhilepi. ");
INSERT INTO kiz_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bhamemili bhudhalimu bhuoha, bhuovu, tamaa ni bhubhibhi. Bhamemibhu ni bhuifu, bhukhomi, Ngondo, bhudesi, ni nia jhibhibhi. ");
INSERT INTO kiz_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bhene kabhele ndo bhadesi bhasomani, na bhakan'dadisya K'yara bhajhe ni fuju, kiburi ni kwifuna. Bhene bhatonga mabhibhi, na bhabhitii lepi bhazazi bha bhene. ");
INSERT INTO kiz_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bhene bhajhelepi ni bhufahamu: bhabhijhaminika lepi, bhajhepi ni mapenzi gha asili, na bhajhelepi ni ke'sa. ");
INSERT INTO kiz_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bhijhelebhwa kanuni sya K'yara, jha kujha bhanu bhabhibhomba mambo gha namna ejhu bhilondeka kufwa. Lakini sio tubhibhomba mambo aghu, bhene kabhele bhijhetekelana ni bhala bhabhibhomba mambo agha. ");
INSERT INTO kiz_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Henu, ujhelepi ni udhuru bhebhe jha wihukumu, kwandabha mu ghala jhaghwihukumu jhongi ikwibheka mu hatia muene. Kwandabha bhebhe jhaghwihukumu ghwibhomba mambo ghalaghala. ");
INSERT INTO kiz_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Lakini tumanyili kujha hukumu jha K'yara jha bhukweli panani pa bhene bhabhibhomba mambo kama agha. ");
INSERT INTO kiz_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lakini bhebhe ghwinoghonayi e'le bhebhe jha ghwihukmu bhala bhabhibhomba mambo agha ingabhwa nabhi ghwikheta mambo ghaghu aghu. Je wibeta kujhepuka hukumu jha K'yara? ");
INSERT INTO kiz_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au wifikilila padebe nesu panani pa bhwingi bhwa wema bhwa muene, kuchelebhwa kwa adhabu jha muene, ni bhuvumilivu bhwa muene? Je umanyili lepi wema bhwa muene bhwilondeka kukujhesya kutoba? ");
INSERT INTO kiz_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Bali kwa kadri jha bhunonono bhwa jhobhi ni kwa muoyo bhwa jhobhi bhwabhubeli kujha ni toba ukibhakhela ghwe muene akiba jha ghadhabu kwa ligono lela lya bhufunuo bwa hukumu jha haki jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Muene ampelili khila munu kipemu kulengana ni matendo gha muene. ");
INSERT INTO kiz_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kwa bhala ambabho kwa uthabiti bhwa matendo manofu bhalondili sifa, litengu, ni kubela kuharibika ibetakubhapela bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lakini bhala ambabho kwa uthabiti bhwa matendo manofu bhalondili sifa litengu, ni kubela kuharibika ibetakubhapela bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Lakini kwa bhala ambabho bhabinafsi, bhabhabeli kutii kweli, balibhitii dhuluma ghadhabu ni ligoga likali libeta kuhida. ");
INSERT INTO kiz_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini sifa, litengu, ni amani jhibetakuhida kwa khila munu jha ibhomba manofu, kwa Muyahudi hoti, ni kwa Muyunani kabhele. ");
INSERT INTO kiz_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwandabha bhujhelepi bhupendelelu kwa k'yara. ");
INSERT INTO kiz_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","kwandabha kama vile bhingi bhabhakosili bila sheria bhibeta kujha gha bila sheria, ndo kama fele bha mehele kya bhadulili kul'engana ni sheria bhibeta kuhukumibhwa kwa sheria. ");
INSERT INTO kiz_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ndabha bhip'eleka lepi sheria bhabhajhe ni haki palongolo pa K'yara, bali ndo bhale bhabhibhomba sheria bhibeta kubhalangibhwa haki. ");
INSERT INTO kiz_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kwa ndabha bhanu bha mataifa ambabho bhajhelepi ni sheria bhibhomba kwa asili mambo gha sheria, bhene bhajhele sheria kwa nafsi sya bhene, ingabhwa bhene bhajhelepi ni sheria. ");
INSERT INTO kiz_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kwa e'le bhilasya kujha matendo ghaghilondeka kwa mujibu bhwa sheria ghalambibhu mu mioyo ghya bhene. Dhamira sya bhene kabhele sikabhashuhudila bhene ni mabhwasu gha bhene ame kubhatakila au kubhalenda bhene. ");
INSERT INTO kiz_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ni kabhele kwa k'yara. Aghe ghibeta kuhomela mu ligono ambalyo K'yara ibetakusihukumu siri sya bhene, kwa njela jha Yesu kristu. ");
INSERT INTO kiz_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tujobhajhi kujha wikikuta ghwe muene Myahudi, jhaatamili mu sheria, hobhokayi kwa kwisifila kwa k'yara, ");
INSERT INTO kiz_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ghamanyayi mapenzi gha muene, ni kup'ema mambo ambagho ghitofautiana nakhu, baada jha kulaghisibhwa ni sheria. ");
INSERT INTO kiz_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Na tujobheyi kujha ujhe ni bhujasiri kujha bhebhe ghwe muene ndo ndongosi ghwa kipofu, mwanga kwa bhala bhabhajhe mu ngisi, ");
INSERT INTO kiz_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","n'sahihishaji ghwa bhajinga, mwalimu ghwa bhana, ni kwamba ujhe nakhu mu sheria namna jha elimu ni kweli. ");
INSERT INTO kiz_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Bhebhe basi, jhawihubiri jhongi, je, ukifundisya lepi ghwa muene? Bhebhe jha wihubiri kubela kuheja, je bhebhe wihejalepi? ");
INSERT INTO kiz_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Bhebhe jha wijobha usihongi, je wihonga? Bhebhe jha wilota sanamu, je wiheja mu hekalu? ");
INSERT INTO kiz_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Bhebhe jhawikisifu mu sheria, je ukamfedhehesya lepi K'yara mu kubomola sheria? ");
INSERT INTO kiz_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kwa ndabha “lihina lya K'yara lifedheheshibhwa kati jha bhanu bha mataifa kwa ndabha jha muenga, “kama kyajhilembibhu. ");
INSERT INTO kiz_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kwa ndabha kutahiribhwa kweli kwibetakujha kinofu kama ukakhesiajhi sheria, lakini kama bhebhe kama ghwibomola sheria, kutahiribhwa kwa bhebhe kwijha kubelakutahiribhwa. ");
INSERT INTO kiz_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Basi, ikajhiajhi, munu jhaabeli kutahiribhwa ijhendelela kukamula matakwa gha sheria, je kubela kutahiribhwa kwa muene kwibetalepi kutolibhwa kana kujha atahiribhu? ");
INSERT INTO kiz_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ni muene jhaabelili kutahiribhwa asili ibetalepi kuhukumulibhwa kama ibetakutimisya sheria? Ejhe kwa ndabha ujhe ni majhandiku ghaghalembibhu ni tohara kabhele lakini ghwakhona ghwa n'konyofu ghwa sheria! ");
INSERT INTO kiz_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kwa ndabha muene Myahudi lepi jhaajhele kwa hali jha kwibhala; bhwala kutahiribhwa sio khola ambako ndo kwa kwibhala mu mb'el'e. ");
INSERT INTO kiz_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lakini muene Myahudi jhaajhele kwa mugati, ni tohara jha muoyo, mu roho, mu liandiku lepi. Sifa jha munu ghwa namna ejhu jhihomela lepi kwa bhanu bali ghihomela kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Kabhele ndo faida jhelekhu jhaajhe najhu Myahudi? Ni faida jha tohara ndo kiki? ");
INSERT INTO kiz_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kinofu nesu kwa khila njela. Awali jha ghoha, Bhayahudi bhakabisibhu bhufunuo kuhoma kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lakini, jhijhabhuli jhikajhiajhi baada jha Bhayahudi bhajhelepi ni imani? Je, kubela kuamini kwa bhene kwibetakubheka bhuaminifu bhwa K'yara kujha batili? ");
INSERT INTO kiz_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","La hasha. Badala jhiake, lekayi K'yara abhonekayi kujha ghwa bhukweli, hata kama khila munu n'desi. Kama kyajhalembibhu, “Jha kujha ubhwesiajhi haki mu malobhi gha jhobhi, na ubhwesiajhi kutobhesya pa ghwijhingila mu hukumu.” ");
INSERT INTO kiz_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ikajhiajhi bhubhibhi bhwa jhoto bhwibhonekana haki jha K'yara, tujobhayi kiki? K'yara dhalimu lepi pachomesya ghadhabu jha muene, je ajhe naha? Nilongela kufwalila mantiki gha kibinadamu. ");
INSERT INTO kiz_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","La hasha! Ni khelekhu K'yara ibetakubhuhukumu ulimwengu? ");
INSERT INTO kiz_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Lakini ikajhiajhi bhukweli jha K'yara kup'etela udesi bhwa nene jhihomesya sifa simehele kwa ndabha jha muene kwa ndabha jhakiki nakona ni hukumulibhwa b'ojho nijhe ni dhambi? ");
INSERT INTO kiz_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kwa ndajhakiki tusijobhi, kama kyatudetibhu ni kama bhamana kyabhikatuthibitisya kujha twijobha, “Tubhombayi bhuovu, ili manofu ghahidayi”? Hukumu panani pa bhene jha bhukweli. ");
INSERT INTO kiz_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ndo niani? Twikitetela twebhene? Lepi nesu. Kwa ndabha tete tayari tumanyili kubhatuhumu Bhayahudi ni Bhayunani bhoha pamonga, jha kujha bhajhele pasi pa dhambi. ");
INSERT INTO kiz_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ejhe ndo kama kyajhilembibhu: “Ajhelepi jhaajhe ni haki, hata mmonga. ");
INSERT INTO kiz_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ajhelepi munu jhaijhelebhwa. Ajhelepi munu ambajhe akandonda K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bhoha bhasanuikhi. Bhoha kwa pamonga bhajhelepi ni mana. Ajhelepi jha ibhomba manofu, la, hata mmonga. ");
INSERT INTO kiz_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mikoromelu ghya bhene ndo lip'omba lyalijhele bhuwasi. Lumilu lwa bhene lukofili. Sumu jha liyoka ijhele mu milomo ghya bhene. ");
INSERT INTO kiz_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Finywa fya bhene bhimemili laana ni bhuchungu. ");
INSERT INTO kiz_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Magolo gha bhene ghajhe ni lubhelu kujhitisya damu. ");
INSERT INTO kiz_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bhuharibifu ni malombosi ghajhele mu mu njela sya bhene. ");
INSERT INTO kiz_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bhanu abha bhajhimanyilepi njela jha amani. ");
INSERT INTO kiz_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ijhelepi hofu jha K'yara pamihu pa bhene.” ");
INSERT INTO kiz_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Henu tumanyili kujha kyokyoha sheria kyajhijobha, jhijobha ni bhala bhabhajhele pasi jha sheria. Ejhe ili kwamba khila n'singu bhudendibhwajhi, ni naha khila kwamba ulimwengu bhuoha bhubhwesiajhi kubhwajibika kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ejhe kwa ndabha lijhelepi mb'ele bhwawibeta kubhalangibhwa haki kwa matendo gha sheria palongolo pa mihu gha muene. Kwa kujha kup'etela sheria bhwihida bhufahamu bhwa dhambi. ");
INSERT INTO kiz_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lakini henu bila sheria, haki jha K'yara jhimanyikene. Jhashuhudibhu kwa sheria ni manabii, ");
INSERT INTO kiz_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ejhu ndo haki jha K'yara kup'etela imani kwa Yesu Kristu kwa bhala bhoha bhabhikiera. Ndabha jhijhelepi bhutofauti. ");
INSERT INTO kiz_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kwa kujha bhoha bhabhombili dhambi, ni kup'ong'okibhwa ni bhutukufu bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bhabhalangibhu haki jhaitolo kwa neema jha muene kwandabha jha ukombozi bhwabhujhele mu Kristu Yesu. ");
INSERT INTO kiz_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kwa ndabha K'yara andetili Kristu Yesu ajhelayi bhupatanisho kwa njela jha imani mu damu jha muene. Ambosili Kristu kama bhushahidi bhwa haki jha muene, kwa ndabha jha kusilekesela dhambi syasip'etili ");
INSERT INTO kiz_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","mu bhuvumilivu bhwa muene. Agha ghoha ghahomili ili kulasya haki jha muene wakati obho bhwa henu. Ejhe jhajhele ili abhwesiajhi kwithibitisya muene kujha haki, ni kulasya kujha ikambalangila haki munu jhejhioha kwa ndabha jha imani kwa Yesu. ");
INSERT INTO kiz_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kujha ndaku kwitufya? kutangibhu. Kwa misingi jhelekhu? Misingi ghya matendo? Lepi, lakini kwa misingi gha imani. ");
INSERT INTO kiz_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nahu twihitimisya kujha munu ibhalangibhwa haki kwa imani bila matendo gha sheria. ");
INSERT INTO kiz_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Au K'yara ndo K'yara ghwa Bhayahudi tu? Je muene K'yara ghwa bhanu lepi bha mataifa kabhele? Ena, ghwa mataifa kabhele. ");
INSERT INTO kiz_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ikajhia bhukweli K'yara ndo mmonga ibetakubhabhalangila haki bhabhajhele bha tohara kwa imani, na bhabhabeli kutahiribhwa kwa njela jha imani. ");
INSERT INTO kiz_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Je tete tukajhibatilisya sheria kwa imani? La hasha! kinyume kya aghu tukajhithibitisya sheria. ");
INSERT INTO kiz_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Twibetakujobha kiki kabhele kujha Abrahamu, dadi jhitu kwa namna jha mb'el'e, abhonekene? ");
INSERT INTO kiz_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kwa ndabha ikajhelayi Abrahamu abhalangibhu haki kwa matendo, na aajhe ni sababu jha kwitufya, lakini sio palongolo pa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kwani majhandiku ghijobhuli? “Abrahamu an'kyeriri K'yara na abhalangibhu kwa muene kujha haki.” ");
INSERT INTO kiz_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Henu kwa munu jha ibhomba mbombo, mal'epu gha muene ghibhalangibhwa lepi kujha ni neema, bali kujha lideni. ");
INSERT INTO kiz_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lakini kwa munu jha ibhomba lepi mbombo jhojhioha bali akan'kiera muene ambajhe akambalangila haki jhaabeli kujha mtauwa, imani jha muene munu ojhu jhibalangibhu kujha haki. ");
INSERT INTO kiz_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daudi ni muene ijobha baraka panani pa munu ambajhe K'yara akambalangila haki bila matendo. ");
INSERT INTO kiz_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ajobhili, “Bhabarikibhu bhala ambabho maovu gha bhene ghasamehibhu ni ambapo dhambi sya bhene sigupikibhu. ");
INSERT INTO kiz_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Abarikibhu munu jhola ambajhe Bwana akambalangila lepi dhambi.” ");
INSERT INTO kiz_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Basi je baraka e'se ndo kwa bhala bhabhatahiribhu tu, au kabhele ni kwa bhala bhabhabelikutahiribhwa? Kwa ndabha twijobha, “kwa Abrahamu imani jha muene jhabhalangiki kujha jha haki.” ");
INSERT INTO kiz_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Henu jhabhalangibhu bhuli? Wakati Abrahamu ajhele mu tohara, au bho akhona kutahiribhwa? Jhajhelepi mu kutahiribhwa, bali kubela kutahiribhwa. ");
INSERT INTO kiz_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahamu apokili alama jha kutahiribhwa. Obho bhwajhele bhola muhuribhwa jhela haki jha amani jhaajhe nayu tayari kabla jha kutahiribhwa. Matokeo jha ishara ejhe ndo kwamba abhombiki kujha dadi ghwa bhoha bhabhikiera, hata kama bhajhele mu kutokutahiribhwa. Ejhe jhijhe ni maana kujha haki jhibetakubhalangibhwa kwa bhene. ");
INSERT INTO kiz_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ejhe kabhele jha maamisi kujha Abrahamu abhombiki kujha dadi ghwa tohara sio tu kwa bhala bhabhitokana ni tohara, bali bhala bhabhakasikesya nyayu sya dadijhitu Abrahamu. Na ejhe ndo imani jhaajhe najhu kwa bhabeli kutahiribhwa. ");
INSERT INTO kiz_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kwa ndabha jha jhelepi kwa sheria kwamba ahadi jhahomesibhu kwa Abrahamu ni uzao bhwa muene, ahadi ejhe jha kujha bhibetakujha bharithi bha dunia. Isipokujha jhajhele kup'et'ela haki jha imani. ");
INSERT INTO kiz_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kwa maana kama bhala, bha sheria ndo bharithi, imani ijhele jha bhwaka, ni ahadi jhibatiliki. ");
INSERT INTO kiz_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kwa ndabha sheria jhileta ghadhabu, lakini pala ambapo ijhelepi sheria, kabhele kujhelepi kutii. ");
INSERT INTO kiz_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kwa ndabha ejhe e'le lihomela kwa imani, ili ijhelayi kwa neema. Matokeo ghake, ahadi ndo dhahiri kwa uzao bhuha. Ni bhazawa abha sio tu bhala bhabhajhimanyi sheria, bali kabhele bhala ambabho ndo bha imani jha Abrahamu. Kwa maana muene ndo dadijhitu tete twebhoka, ");
INSERT INTO kiz_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","kama kyajhilembibhu, “Nikubhombili bhebhe kujha dadi ghwa mataifa ghamehele.” Abrahamu ajhele mu uwepo bhwa jhola jhaamwamini, yaani, K'yara ambajhe akabhapela bhanu uzima ni kughakuta mambo ambagho ghajhelepi ili ghabhwesiajhi kujha. ");
INSERT INTO kiz_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Licha jha hali syoha syakwibhala, Abrahamu kwa ujasiri an'kieriri K'yara kwa magono ghaghahideghe. Naha ajhele dadi ghwa mataifa ghamehele, kul'engana ni khela kyakyajobhibhu, “... Ndo kwawibetakujha uzao bhwa bhebhe.” ");
INSERT INTO kiz_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Muene ajhelepi dhaifu mu imani. Abrahamu ajobhili kujhamb'el'e ghwa muene bhwamalili kujha bhufwili - ajhele ni umuli kulibila miaka mia moja. Kabhele ajhedekili ni hali jha kufwa jha lileme lya Sara. ");
INSERT INTO kiz_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Lakini kwa ndabha jha ahadi jha K'yara, Abrahamu abelilepi kubela kukiera, bali apelibhu nghofu mu imani ni kun'tufya K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ajhele amanyili bhukweli kujha khela ambakyo K'yara aahidi, ajhele kabhele ni bhuwezo bhwa kukikamilisya. ");
INSERT INTO kiz_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Henu ejhe kabhele jhabhalangibhu kwa muene kujha ndo haki. ");
INSERT INTO kiz_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Henu jhalembibhu lepi tu kwa faida jha muene, kujha jhabhalangibhu kwa muene. ");
INSERT INTO kiz_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Jhalembibhu kwa ndabha jha tete kabhele, kwa bhabhekibhu kubhalangibhwa tete ambabho twikiera kwa muene jha amfufuili Bwana bhitu Yesu kuhoma kwa bhafu. ");
INSERT INTO kiz_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ojho ndo jhola ambajhe apisibhu kwandabha jha makosa ghitu ni kufufulibhwa ili tukabhayi kubhalangibhwa haki. ");
INSERT INTO kiz_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kwa kujha tubhalangibhu haki kwa njela jha imani, tujhe ni amani ni K'yara kwa njela jha Bwana bhitu Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kup'etela muene tete kabhele tujhe ni fursa kwa njela jha imani mu neema ejhe ambajho mugati mwake twijhema. Tuhobhuiki mu bhujasiri bhwaatupelili K'yara kwa ndabha jha baadajhe, bhujasiri ambabho bhwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Sio e'le liene, lakini kabhele tuhobhwiki mu malombosi ghitu. Tumanyili kujha malombosi ghihogolo bhuvumilivu. ");
INSERT INTO kiz_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Bhusindamalilu bhwihogola kujha dekelibhwa, ni kujhedekilibhwa bhwihogola bhujasiri kwa ndabha jha baadajhe. ");
INSERT INTO kiz_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Bhujasiri obho bhwikatisya lepi tamaa kwandabha luganu lwa K'yara bhujhitisibhu mu mioyo ghya jhotu kup'etela Roho Mtakatifu, ambajhe ahomesibhu kwa tete. ");
INSERT INTO kiz_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kwa bho tujhele tungali tu dhaifu, kwa bhwakati muafaka Kristu afuili kwa ndabha jha bhwokovu. ");
INSERT INTO kiz_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kwa kujha jhibetakujha jhinonono kwa mmonga kufwa kwa ndabha jha munu jha ajhe ni haki. Ejhe ndo kwamba, labda munu ngaalondeghe kufwa kwa ndabha jha munu n'nofu. ");
INSERT INTO kiz_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini K'yara ahakikisi luganu lwa muene kwa tete, kwa ndabha bho twakona tujhe ni dhambi, Kristu afuili kwa ndabha jha tete. ");
INSERT INTO kiz_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kabhele zaidi jha henu kwa kujha tubhalangibhu haki kwa damu jha muene, twiokolibhwa kwa henu kuhoma mu gadhabu jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kwa kujha, bho tujhele maadui, twapatanisibhu ni K'yara kwa njela jha kifo kya mwanabhe zaidi nesu, baada jha kujha tumalikupatanisibhwa, tubetakuokolibhwa kwa maisha gha muene. ");
INSERT INTO kiz_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Sio efe tu, bali kabhele tuhobhwiki kwa K'yara kup'etela Bwana Yesu Kristu, kup'etela ambajhe henu tujhambelili bhupatanisu obho. ");
INSERT INTO kiz_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Henu basi, kama kup'etela munu mmonga dhambi jhajhingili paduniani, kwa njela ejhe kifo kyajhingili kwa njela jha dhambi. Ni kifo kyasambele kwa bhanu bhoha, kwandabha bhoha bhabhombi dhambi. ");
INSERT INTO kiz_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kwa kujha hadi sheria, dhambi jhajhele paduniani, lakini dhambi jhibhalangika lepi bhwakati jhijhelepi sheria. ");
INSERT INTO kiz_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Hata naha, kifo kyatabhwele kuhoma Adamu hadi Musa, hata panani pa bhala ambabho bhabhombi lepi dhambi kama kubela kutii kwa Adamu, ambaye ndo mfano ghwa muene ambajhe ngaahidili. ");
INSERT INTO kiz_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini hata naha, zawadi jha bure sio kama likosa. Kwa kujha likajhelayi likosa lya mmonga bhamehele bhafwili, zaidi nesu neema jha K'yara ni zawadi jha neema jha munu mmonga, Yesu Kristu, jhijhongesiki kwa bhamehele. ");
INSERT INTO kiz_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kwa kujha zawadi sio kama matokeo gha jhola ambajhe abhombi dhambi. Kwa kujha kwa lubhafu l'ongi, hukumu jha adhabu jhahidili kwa ndabha jha likosa lya munu mmonga, lakini kwa lubhafu l'ongi, kipawa kyaitolo kyakihomela mu kubhalangibhwa haki kyahidili baada jha makosa ghamehele. ");
INSERT INTO kiz_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwa ndabha, likajhelayi kwa likosa lya mmonga, kifo kyatawele kup'et'ela mmonga zaidi nesu bhala ambabho bhibetakupokela neema simehele pamonga ni kipawa kya haki bhibetakutawala kup'etela maisha gha mmonga, Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Henu, kama kup'et'ela likosa limonga bhanu bhoha bhahidili mu hukumu, ingabhwa kup'et'ela litendo limonga lya haki kwahidili kubhalangibhwa haki jha maisha kwa bhanu bhoha. ");
INSERT INTO kiz_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kwa kujha kama kup'etela kubela kutii, kwa munu mmonga bhamehele bhibetakujha bhajhe ni haki. ");
INSERT INTO kiz_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Lakini sheria jhajhingili pamonga, ili kujha likosa libhwesiajhi kujhenela. Lakini mahali ambapo dhambi jhajhongesiki kujha jhimehele, neema jhajhongesiki hata nesu. ");
INSERT INTO kiz_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ejhe jahomili ili kwamba, kama dhambi kyajhatabhwele mu kifo, ndo hata neema jhibhwesya kutabhwala kup”etela haki kwa ndabha jha maisha gha milele kup'et'ela Yesu Kristu Bwana bhitu. ");
INSERT INTO kiz_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tujobhayi kiki henu? Tujhendelelayi mu dhambi ili neema jhijhongesekayi? ");
INSERT INTO kiz_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","La hasha. Tete jhatufwili mu dhambi, twibhwesya bhuli kabhele kuishi mu ejhu? ");
INSERT INTO kiz_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Je mumanyilepi jha kujha bhala bhabatisibhu kwa Kristu bhabhatisibhu mu mauti gha muene? ");
INSERT INTO kiz_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Twajhele tusyelibhu pamonga ni muene kup'etela bhubatisu mu kifo. Ejhe jhabhombiki ili kwamba kama fela Kristu kya ajhinulibhu kuhoma mauti kup'etela utukufu bhwa Dadi, ili kwamba ni tete tubhwesiajhi kugenda mu bhupya bhwa maisha. ");
INSERT INTO kiz_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ndabha jhikajhelayi tuunganisibhu pamonga ni muene mu mfano bhwa kifo kya muene, kabhele twibetakuunganisibhwa mu ufufuo bhwa muene. ");
INSERT INTO kiz_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tete tumanyili naha, utu bhwa jhoto bhwa muandi bhwasulubibhu pamonga ni muene, ili kwamba mb'el'e ghwa dhambi bhuharibibhwayi. ");
INSERT INTO kiz_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ejhe jhahomili ili kujha tusijhendeleli kujha bhatumwa bha dhambi. Muene jhaafuili abhombiki jha ajhe ni haki kul'engana ni dhambi. ");
INSERT INTO kiz_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Lakini kama tufuili pamonga ni Kristu, twikiera kujha twibeta kuishi pamonga ni muene kabhele. ");
INSERT INTO kiz_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tumanyili kujha Kristu afufulibhu kuhoma kwa bhafu, ni kwamba mfulepi kabhele. Kifo kikan'tabhwala lepi kabhele. ");
INSERT INTO kiz_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Maana jha kifo kyaafuili kwa dhambi, afuili mara jhimonga kwa ndabha jha bhoha. Hata, naha, maisha gha iishi, iishi kwa ndabha jha K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kwa njela jhejhuejhu, namu kabhele mwilondeka kwibhalangila kujha bhafu mu dhambi, bali mwebhaomi kwa K'yara mu Yesu Kristu. ");
INSERT INTO kiz_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kwa ndabha ejhu usiruhusu dhambi jhitabhwalayi mb'ele bhwa jhobhi ili kusudi ibhwesiajhi kusitii tamaa syake. ");
INSERT INTO kiz_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Usibhosi sehemu sya mb'el'e ghwa jhobhi mu dhambi kama fenu fyafidulili haki, bali mukihomesiajhi mwebhene kwa K'yara, kama bhabhajhele hai kuhoma mu mauti. Na musibhosiajhi sehemu sya mibhele ghya muenga kama fenu fya haki kwa K'yara. ");
INSERT INTO kiz_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Musiruhusu dhambi jhibhatawalayi. Kwa kujha mujhelepi pasi pa sheria, la hasha. ");
INSERT INTO kiz_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Kiki henu? Tubhombayi dhambi kwandabha tujhelepi pasi pa sheria, bali pasi pa neema? La hasha. ");
INSERT INTO kiz_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mumanyilepi jha kujha kwa muene ambajhe mukwihomesya mwebhene kama bhatumishi ndo ambajhe muenga mwibetakujha bhatumishi bha muene, muene jhamwilondeka kun'tii? Ejhe ndo kweli hata kama muenga bhatumwa mu dhambi ambajho jhipelekela mauti, au bhatumwa bha bhutii bhwabhwipelekela haki. ");
INSERT INTO kiz_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Lakini abhombesibhwajhi K'yara! Kwa ndabha mwajhele bhatumwa bha dhambi, lakini mumalikutii kuhoma mu muoyo jhela namna jha lifundisu lyamupelibhu. ");
INSERT INTO kiz_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mubhombibhu huru kuhoma mu dhambi, na mubhombibhu bhatumwa bha haki. ");
INSERT INTO kiz_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nilongela kama munu kwa ndabha jha madhaifu gha mibhele ghya jhomu. Kwa ndabha kama fela kyamwabhosili fiungo fya mibhele ghya muenga kujha bhatumwa kwa bhuchafu ni bhuovu, kwa namna jhejhuejhu, henu mubhosiajhi fiungo fya mibhele ghya muenga kujha bhatumwa bha haki kwa bhutakaso. ");
INSERT INTO kiz_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kwa kujha bho mujhe mwe bhatumwa bha dhambi, mwajhele huru patali ni haki. ");
INSERT INTO kiz_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kwa wakati obhu, mwajhele ni litunda leleku kwa mambo ambagho kwa henu mwibhona soni naghu? Kwa kujha matokeo gha mambo agha ndo kufwa. ");
INSERT INTO kiz_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini kwa kujha henu mufungibhu huru patali ni dhambi na mubhombiki bhatumwa kwa K'yara, mujhe ni litunda kwandabha jha utakaso. Litokeo ndo bhusima bhwa milele. ");
INSERT INTO kiz_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwa kujha mshahara ghwa dhambi ndo mauti, bali zawadi jha bure jha K'yara ndo bhuzima bhwa milele kwa Kristu Yesu Bwana bhitu. ");
INSERT INTO kiz_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Au mumanyilepi bhalongobhangu (kwa kujha nilongela ni bhanu ambabho bhajhimanyili sheria), kwamba sheria jhikan'tabhwala munu pa ijha hai? ");
INSERT INTO kiz_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kwandabha n'dala jha agegikibhu akhongibhu ni sheria kwa jhola ngwana munu paijha muomi, lakini akajhelayi ngwanamunu afuili, ibetakujha ajhe huru kuhoma sheria jha ndobho. ");
INSERT INTO kiz_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Henu basi, bho ngwanamunu akona muomi, ni muene itama ni n'gosi jhongi, ibetakukutibhwa mzinzi. Lakini ikajhiajhi ngwanamunu afuili, ajhe huru dhidi jha sheria, efyo ibetalepi kujha mzinzi ikajhiajhi igenda ni n'gosi jhongi. ");
INSERT INTO kiz_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Henu, bhalongobhangu, muenga kabhele mwajhele mwe bhafu kwa sheria kwa njela jha mb'el'e ghwa Kristu. Jhijhe naha ili mukabhayi kuunganisibhwa ni jhongi, kwa muene ambajhe afunulibhu kuhoma kwa bhafu ili tubhwesiajhi kun'hogolela K'yara matunda. ");
INSERT INTO kiz_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kwa ndabha bho tujhele mu hali jha mb'el'e, tamaa sya dhambi syajhumuiki mu fiungo fya tete kwa njela jha sheria ni kujhihogolela mauti matunda. ");
INSERT INTO kiz_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lakini henu tubhopolibhu kuhoma mu sheria. Tujhifwelili hali jhela jhatubelili. 